﻿USE sofia;
DROP TABLE IF EXISTS sofia.chk_vpl;
CREATE TABLE chk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES chk_vpl WRITE;
INSERT INTO chk_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Lepopun Kot a föri läng me fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nge fanüfan a kotongau o pön, a pwal lölö o rochokich ekis meinisin, nge Ngünün Kot a tümwünü ewe lölö. ");
INSERT INTO chk_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mürin, Kot a apasa, “Epwe saram.” Iwe, a saramala. ");
INSERT INTO chk_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Iwe, Kot a küna ewe saram pwe a öch. Iwe, a aimwü rochopwak seni saram, ");
INSERT INTO chk_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","o aita ngeni saram rän, nge rochopwak a aita ngeni pwin. Iwe, seni lesosor tori lekuniol pwal tori lesosorun ewe eu rän, iei ewe aeuin rän. ");
INSERT INTO chk_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Iwe, Kot a apasa, “Epwe fis kiännin ewe lölö, pwe epwe imwüfesen lölön pekitä me lölön pekitiu.” ");
INSERT INTO chk_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mürin, Kot a föri ewe kiä pwe lölön pekitä me lölön pekitiu resap chüen chufengen. Iwe, a fis. ");
INSERT INTO chk_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nge ewe kiä Kot a aita ngeni läng. Iwe, seni lesosor tori lekuniol pwal tori lesosorun ewe eu rän, iei ewe aruuen rän. ");
INSERT INTO chk_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mürin, Kot a pwal apasa, “Lölön pekitiu repwe chufengen lon lenier pwe epwe pwä lenien pwasapwas.” Iwe, a pwal fis. ");
INSERT INTO chk_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Iwe, Kot a aita ngeni ewe lenien pwasapwas fanü, nge ewe lenien lölö a aita ngeni matau. Iwe, Kot a küna pwe a öch meinisin. ");
INSERT INTO chk_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Mürin a pwal apasa, “Fanü epwe amärätä fetil me iräkis mi püsin afisätä föür, pwal sokun irä mi ukua, a pwal wor föür lor, pwe repwe püsin sokuni sokur won fanüfan.” Iwe, a fis. ");
INSERT INTO chk_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Iwe, fanü a amärätä fetil me iräkis mi ua, pwal sokopaten irä mi ukua, a pwal wor föür lor pwe repwe sokuni sokur. Iwe, Kot a küna pwe a öch meinisin. ");
INSERT INTO chk_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Iwe, seni lesosor tori lekuniol pwal tori lesosorun ewe eu rän, iei ewe aülüngatin rän. ");
INSERT INTO chk_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mürin, Kot a apasa, “Ekewe saram repwe pwäla fän läng pwe repwe aimwüfeseni rän me pwin o asisila kinikinin fansoun me rän me ier kana. ");
INSERT INTO chk_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Repwe nonom fän läng o asarama unusen fanüfan.” Iwe, a fis. ");
INSERT INTO chk_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Iei usun Kot a föri ruu saram mi watte: akkar mi tin lerän, maram mi tin lepwin, a pwal föri fü kana. ");
INSERT INTO chk_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Iwe, Kot a alenieer fän läng pwe repwe asarama fanüfan, ");
INSERT INTO chk_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","repwe nemeni rän me pwin o aimwüfeseni saram me rochopwak. Iwe, Kot a küna pwe a öch meinisin. ");
INSERT INTO chk_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Iwe, seni lesosor tori lekuniol pwal tori lesosorun ewe eu rän, iei ewe arüanün rän. ");
INSERT INTO chk_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mürin, Kot a apasa, “Ekewe lenien lölö repwe masou ren mönümanau, nge mansüsü repwe äkäs fän läng.” ");
INSERT INTO chk_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Iei usun Kot a föri chomong sokun man mi watte me kükün pwe matau epwe masou rer. A pwal föri chomong sokun mansüsü. Iwe, Kot a küna pwe a öch meinisin. ");
INSERT INTO chk_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Iwe, Kot a afeiöchüür o üreniir pwe repwe nöünöü o achomongeer, pwe matau epwe masou rer. Nge mansüsü kana repwe chomongola won fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Iwe, seni lesosor tori lekuniol pwal tori lesosorun ewe eu rän, iei ewe alimuen rän. ");
INSERT INTO chk_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Mürin, Kot a apasa, “Fanü epwe afisätä sokun man meinisin: Manfesir, mantötö me manmwacho, ekewe mi watte me kükün, eman me eman lon en me sokun.” Iwe, a fis. ");
INSERT INTO chk_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Iei usun Kot a föriir meinisin, eman me eman lon en me sokun. Iwe, a küna pwe ra öch meinisin. ");
INSERT INTO chk_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mürin, Kot a apasa, “Sipwe föri aramas mi wewe ngenikich pwe repwe nemeni ekewe ikenen leset me ekewe mansüsü me ekewe man meinisin won unusen fanüfan.” ");
INSERT INTO chk_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Iei usun Kot a föri aramas lon püsin lapalapan, eman mwän me eman fefin. ");
INSERT INTO chk_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Iwe, Kot a afeiöchüür o üreniir, “Oupwe nöünöü o achomongakemi pwe fanüfan epwe masou remi o nom fän nemeniemi. Oupwe nemeni ekewe ikenen leset me ekewe mansüsü me mönün won unusen fanüfan.” ");
INSERT INTO chk_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mürin, Kot a pwal apasa, “Üa ngenikemi ekewe iräkis meinisin won fanüfan mi afisätä föür, pwal ekewe irä meinisin mi ukua, a pwal wor föür lor, pwe oupwe mongö seniir. ");
INSERT INTO chk_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Nge ekewe fetil meinisin üa ngeni ekewe manmwacho, ekewe mantötö me mansüsü, pwal ngeni ekewe sokopaten man meinisin won fanüfan, pwe repwe mongö seniir.” Iwe, a fis. ");
INSERT INTO chk_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Iwe, Kot a nengeni meinisin mine a föri o küna pwe a fokun öch. Iwe, seni lesosor tori lekuniol pwal tori lesosorun ewe eu rän, iei ewe awonuen rän. ");
INSERT INTO chk_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Iei usun Kot a awesala läng me fanüfan me meinisin mine a wor lor. ");
INSERT INTO chk_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nge lon ewe afisuen rän Kot a aükätiu an we angang o asösö seni an kewe angang meinisin. ");
INSERT INTO chk_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Iwe, Kot a afeiöchü o apini ewe afisuen rän, pun lon ewe rän a asösö seni an angangen föri läng me fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Iei uruwon mine a fis, lupwen Kot a föri läng me fanüfan. 2.4-25 Lon ewe rän, lupwen Kot ewe Samol mi Lapalap a föri fanüfan me läng, ");
INSERT INTO chk_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","esamwo wor iräkis me fetil mi mär seni lon ewe pwül, pun Kot ewe Samol mi Lapalap esamwo apüngätiu üt, esamwo pwal wor eman aramas mi föri angangen tanipi. ");
INSERT INTO chk_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nge eu nikapwor a ötütä seni won pwül o achöchönala unusen ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mürin, Kot ewe Samol mi Lapalap a föri eman aramas seni pwülün fanü o wussalong lon pwötün enienin ngasangasen manau. Iei usun manau a tori ewe aramas. ");
INSERT INTO chk_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mürin, Kot a föri eu tanipi lon fanüen ötiu itan Eten. Ikenan a alenia ewe aramas a föri. ");
INSERT INTO chk_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Iwe, seni lon ewe pwül Kot ewe Samol mi Lapalap a amärätä sokun irä meinisin mi apwapwai aramas le katol o mürina le mongö. Nge lukalapen ewe tanipi a amärätä ewe irän manau, pwal ewe irän silei öch me ngau. ");
INSERT INTO chk_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Iwe, eu chanpupu a achöchönü ewe tanipi Eten o puwu seni. Ikenan a kinikinfesen lon rüanü chanpupu. ");
INSERT INTO chk_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ewe aeuin chanpupu itan Pison a pula ünükün unusen ewe fanü Hefila, ia a wor kolt ie. ");
INSERT INTO chk_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Iwe, kolten ei fanü a mürina. Ikenan a pwal wor apach mi pwokus me ewe fau aüchea itan oniks. ");
INSERT INTO chk_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ewe aruuen chanpupu itan Kihon a pula ünükün unusen ewe fanü Kuus. ");
INSERT INTO chk_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ewe aülüngatin chanpupu itan Tikris a pula ötiuen ewe fanü Asiria. Nge ewe arüanün chanpupu itan Oifrat. ");
INSERT INTO chk_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mürin, Kot ewe Samol mi Lapalap a alenia ewe aramas lon ewe tanipi Eten pwe epwe tanipini o tümwünü. ");
INSERT INTO chk_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Iwe, Kot ewe Samol mi Lapalap a allük ngeni ewe aramas, “Ka tongeni mongö seni irän ei tanipi meinisin, ");
INSERT INTO chk_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","nge seni ewe irän silei öch me ngau kosap fokun mongö. Pun lon ränin om kopwe mongö seni, kopwe fokun mäla.” ");
INSERT INTO chk_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mürin, Kot ewe Samol mi Lapalap a pwal apasa, “Esap öch pwe ewe aramas epwe chök eman. Üpwe föri eman alisian mi wewe ngeni.” ");
INSERT INTO chk_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Iwe, Kot ewe Samol mi Lapalap a föri seni pwül sokun mönün lemäl, pwal sokun mansüsü meinisin. Mürin a uweereto ren ewe aramas, pun a mochen silei met epwe aita ngeniir. Nge mine ewe aramas epwe aita ngeni ekewe mönümanu, iei repwe iteni. ");
INSERT INTO chk_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Iei usun ewe aramas a aita ekewe manfetal, ekewe mansüsü pwal ekewe mönün lemäl meinisin. Nge fän äsengesin ewe aramas esap wor eman alisian mi wewe ngeni. ");
INSERT INTO chk_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Iei mine Kot ewe Samol mi Lapalap a apüngätiu och möürüchou won ewe aramas. Iwe, lupwen an möür Kot a angeawu efoch chürärän o apacha ngeni fituk lemon ewe kinas. ");
INSERT INTO chk_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nge seni chürärän ewe aramas Kot ewe Samol mi Lapalap a föri eman fefin o uwato ren. ");
INSERT INTO chk_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Iwe, ewe aramas a apasa, “Iei chün chüi, nge fitukan fitukei. Epwe iteni etien mwän, pun a pop seni mwän.” ");
INSERT INTO chk_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Iei mine eman mwän epwe likiti saman me inan o pachei ngeni pwülüan, nge ekewe ruoman repwe wiliti eu chök inis. ");
INSERT INTO chk_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Iwe, ewe mwän me pwülüan we ra selela, nge resap säw. ");
INSERT INTO chk_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Iwe, ewe serepenit a tipachemsolä seni ekewe man meinisin Kot ewe Samol mi Lapalap a föriir. Iwe, a aisini ewe fefin, “Ifa usun, Kot a wesewesen apasa pwe ousap fokun mongö seni ekewe irän ei tanipi?” ");
INSERT INTO chk_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nge ewe fefin a pälüeni ewe serepenit, “Äm aia tongeni mongö seni ekewe uän irän ei tanipi. ");
INSERT INTO chk_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Nge Kot a apasa pwe aisap fokun mongö seni uän ewe irä a nonom lukalapen ei tanipi, aisap pwal atapa. Pun are aipwe mongö seni, aipwe mäla.” ");
INSERT INTO chk_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Iwe, ewe serepenit a üreni ewe fefin, “Apwi, ousap fokun mäla. ");
INSERT INTO chk_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Pun Kot a silei pwe lon ränin ämi oupwe mongö seni, mesemi epwe nela. Iwe, oupwe wewe ngeni Kot o silei mine a öch pwal mine a ngau.” ");
INSERT INTO chk_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nge lupwen ewe fefin a nenengeni ewe irä, a mefi pwe a mürina le mongö o apwapwai aramas le katol, a pwal aüchea ren an afisätä tipachem. Iei popun ewe fefin a angei uän ewe irä o mongö. Mürin a ngeni pwülüan we, iwe, a pwal mongö. ");
INSERT INTO chk_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Lon ewe chök otun meser me ruoman a nela. Iwe, ra mefi pwe ra selela. Iei mine ra teifengeni chön irä fiik pwe pwölüpwölür. ");
INSERT INTO chk_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Iwe, lekuniol, lupwen fansoun patapat, ewe mwän me pwülüan we ra rong pwe Kot ewe Samol mi Lapalap a fetal lon ewe tanipi. Iwe, ra op seni lein irän ewe tanipi. ");
INSERT INTO chk_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nge Kot ewe Samol mi Lapalap a köri ewe mwän o aisini, “Ia ka nom ie?” ");
INSERT INTO chk_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ewe mwän a pälüeni, “Üa rong mwaataaten om fetal lon ei tanipi, nge üa niuokus, pun üa selela. Iei popun üa op.” ");
INSERT INTO chk_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Iwe, Kot a aisini, “Iö a asile ngonuk pwe ka selela? Ifa usun, ka mongö seni ewe irä üa allük pwe kosap mongö seni?” ");
INSERT INTO chk_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ewe mwän a pälüeni, “Ewe fefin en ka ngeniei pwe pwülüei, neminewe a ngeniei uän ewe irä, iwe, üa mongö.” ");
INSERT INTO chk_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mürin, Kot ewe Samol mi Lapalap a aisini ewe fefin, “Pwota ka föri ei sokun?” Nge ewe fefin a pälüeni, “Ewe serepenit a atupuei, iei mine üa mongö.” ");
INSERT INTO chk_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Iwe, Kot ewe Samol mi Lapalap a üreni ewe serepenit, “Pokiten om föri ei, en kopwe anümamau me lein ekewe manfesir me manmwacho meinisin. Kopwe tö won upwom o eni pwül lon ränin manauom meinisin. ");
INSERT INTO chk_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Üpwe afiukemi me ewe fefin, pwal mwirimwirum me mwirimwirin. Men epwe puri mökürom, nge en kopwe küw apilipilin pechen.” ");
INSERT INTO chk_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Iwe, Kot a üreni ewe fefin, “Üpwe fokun alapala weiresin om pwopwo. Fän cheuch kopwe nöünöü. Kopwe tipeni pwülüom we, nge i epwe nemenuk.” ");
INSERT INTO chk_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Mürin, Kot a üreni ewe mwän, “Pokiten om aüselinga alon pwülüom we o mongö seni ewe irä üa allük pwe kosap mongö seni, pwülün fanü epwe anümamau pokitom. Kopwe angang weires lon ränin manauom meinisin pwe epwe wor anom mongö. ");
INSERT INTO chk_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Pwül epwe amäri ngonuk iräfölüföl me pötöwölingau, nge kopwe mongö irän lemäl. ");
INSERT INTO chk_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kopwe mongö anom fän molonom tori om kopwe wiliti pwül ka för seni. Pun pwül en, iei popun om kopwe wiliti pwül.” ");
INSERT INTO chk_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Iwe, Atam a aita ngeni pwülüan Efa, pun i inelapen chokewe meinisin mi manau. ");
INSERT INTO chk_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nge Kot ewe Samol mi Lapalap a föri üf seni ünüchen man o aüföüfa ngeni Atam me pwülüan we. ");
INSERT INTO chk_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mürin, Kot ewe Samol mi Lapalap a apasa, “Iei a fis pwe ewe aramas a wewe ngenikich, pun a silei öch me ngau. Nge esap tufich, pwe epwe pwal aitiela pöün o angei seni uän ewe irän manau o mongö pwe epwe manau tori feilfeilachök.” ");
INSERT INTO chk_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Iei popun Kot ewe Samol mi Lapalap a asüela ewe aramas seni ewe tanipi Eten, pwe epwe tuw ewe pwül a för seni. ");
INSERT INTO chk_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mürin än Kot asüela ewe aramas, a anomu Keropim ötiuen ewe tanipi Eten, pwal efoch ketilas mi pulopulen ekkei o märäkul, pwe repwe mamasa ewe al a ale ngeni ewe irän manau. ");
INSERT INTO chk_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Iwe, Atam a kon ren Efa pwülüan we, nge neminewe a pwopwo. Iwe, lupwen a nöüni Kain, Efa a apasa, “Üa nöüni eman ät ren än ewe Samol mi Lapalap alilis.” ");
INSERT INTO chk_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mürin a pwal nöüni Epel pwin Kain. Iwe, Epel eman chon fofol sip, nge Kain eman chon tanipi. ");
INSERT INTO chk_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Iwe, ekoch fansoun mürin a fis pwe Kain a eäni asor uän irä seni lon tanipin ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Nge Epel a eäni asor mwänichien folenian sip pwal seni kirisir. Iwe, ewe Samol mi Lapalap a efich Epel me an asor, ");
INSERT INTO chk_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","nge Kain me an asor esap efich. Iei mine Kain a fokun chou, nge won mesan a wowongau. ");
INSERT INTO chk_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mürin, ewe Samol mi Lapalap a aisini Kain, “Pwota ka chou, nge met ka wowongau ren? ");
INSERT INTO chk_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ifa usun, are ka föri mine a pwüng, üsap etiwa om asor? Nge pokiten ka föri mine a ngau, tipis a operuk lükün asamom. Iwe, a mochen nemenuk, nge en kopwe akufu.” ");
INSERT INTO chk_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Iwe, Kain a kapas ngeni Epel pwin we, “Sipwe feila lemäl.” Nge lupwen ar nonomfengen ikenan, Kain a ü ngeni pwin, a turufi o niela. ");
INSERT INTO chk_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mürin, ewe Samol mi Lapalap a aisini Kain, “Ifa i pwiüm we Epel?” Nge Kain a pälüeni, “Üsap silei. Ifa usun, ngang chon tümwünün pwii?” ");
INSERT INTO chk_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nge ewe Samol mi Lapalap a üreni, “Met ka föri? Chan pwiüm we a köriei seni won pwül. ");
INSERT INTO chk_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Iwe, kopwe nom fän anümamau o kasüela seni ei fanü mi amasawala awan pwe epwe ünümi chan pwiüm we ka niela. ");
INSERT INTO chk_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Lupwen om kopwe tanipini ewe fanü, esap chüen ngonuk uän fotom. Kopwe nomofetal o süsüfeil won fanüfan.” ");
INSERT INTO chk_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Iwe, Kain a üreni ewe Samol mi Lapalap, “A kon watte liwinin ai tipis. Esap ki ngeniei ai üpwe uwei. ");
INSERT INTO chk_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ikenai ka asüeila seni ei fanü pwal seni fän mesom, pwe üpwe nomofetal o süsüfeil won fanüfan. Iwe, epwe fis pwe iö epwe künaei, epwe nieila.” ");
INSERT INTO chk_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nge ewe Samol mi Lapalap a üreni, “Apwi! Iö epwe niikela, epwe angei chappan fän fisu.” Iwe, ewe Samol mi Lapalap a föri eu asisil won Kain pwe are eman epwe küna, esap niela. ");
INSERT INTO chk_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Mürin, Kain a feil seni fän mesen ewe Samol mi Lapalap o imweimw lon ewe fanü itan Not ötiuen Eten. ");
INSERT INTO chk_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Iwe, Kain a kon ren pwülüan we, nge neminewe a pwopwo, a nöüni eman ät o aita ngeni Enok. Mürin, Kain a aüetä eu telinimw o aita ngeni iten nöün we Enok. ");
INSERT INTO chk_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Iwe, mi wor eman nöün Enok mwän itan Irat. Irat semen Mehujael, Mehujael semen Metusael, nge Metusael semen Lamek. ");
INSERT INTO chk_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Iwe, Lamek a pwülüeni ruoman fefin, eman itan Ata, nge eman itan Sila. ");
INSERT INTO chk_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ata a nöüni Japal, i semelapen chokewe ra fofol man o imweimw lon imw mangaku. ");
INSERT INTO chk_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nge pwin Japal itan Jupal, i semelapen chokewe mi sile ettik pisekin ettik. ");
INSERT INTO chk_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Iwe, Sila a nöüni Tupalkain, i eman mi silelap le föri pisek seni mächä. Nge fefinen Tupalkain itan Naama. ");
INSERT INTO chk_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Iwe, Lamek a üreni pwülüan kewe, “Ata me Sila, oupwe rongorong ai kapas, ämi pwülüen Lamek, oupwe aüseling ai fos. Üa niela eman mwän pokiten a akinasaei, üa niela eman alüal pokiten a sukuei. ");
INSERT INTO chk_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Are manauen Kain epwe mö fän fisu, manauen Lamek epwe mö fän fik me fisu.” ");
INSERT INTO chk_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Iwe, Atam a pwal kon ren pwülüan we, nge neminewe a pwopwo o nöüni eman ät. Iwe, a aita ngeni Set, pun a apasa, “Kot a ngeniei eman nei siwilin Epel, ätewe Kain a niela.” ");
INSERT INTO chk_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set a pwal nöüni eman ät o aita ngeni Enos. Lon ena fansoun aramas ra popuetä le köri iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iei uruwon mwirimwirin Atam. Lupwen Kot a föri ewe aramas, a föri lon püsin lapalapan. ");
INSERT INTO chk_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","A föri eman mwän me eman fefin. Nge wesin an föriir, a afeiöchüür o aita ngeniir aramas. ");
INSERT INTO chk_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Lupwen Atam a ierini ipükü ilik, a nöüni eman ät mi wewe ngeni püsin lapalapan, iwe, a aita ngeni Set. ");
INSERT INTO chk_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Iwe, ükükün ierin manauen Atam mürin an nöüni Set walüpükü, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nge ierin manauen Atam meinisin tiwepükü ilik. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Iwe, lupwen Set a ierini ipükü limu, a nöüni Enos. ");
INSERT INTO chk_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Nge ierin manauen Set mürin än Enos uputiu walüpükü fisu, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nge ierin manauen Set meinisin tiwepükü engol me ruu. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Iwe, lupwen Enos a ierini tiwe, a nöüni Kenan. ");
INSERT INTO chk_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nge ierin manauen Enos mürin än Kenan uputiu walüpükü engol me limu, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nge ierin manauen Enos meinisin tiwepükü limu. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Iwe, lupwen Kenan a ierini fik, a nöüni Mahalalel. ");
INSERT INTO chk_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Nge ierin manauen Kenan mürin än Mahalalel uputiu walüpükü faik, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nge ierin manauen Kenan meinisin tiwepükü engol. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Iwe, lupwen Mahalalel a ierini wone me limu, a nöüni Jaret. ");
INSERT INTO chk_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nge ierin manauen Mahalalel mürin än Jaret uputiu walüpükü ilik, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Nge ierin manauen Mahalalel meinisin walüpükü tiwe me limu. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Iwe, lupwen Jaret a ierini ipükü wone me ruu, a nöüni Enok. ");
INSERT INTO chk_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nge ierin manauen Jaret mürin än Enok uputiu walüpükü, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Nge ierin manauen Jaret meinisin tiwepükü wone me ruu. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Iwe, lupwen Enok a ierini wone me limu, a nöüni Metusala. ");
INSERT INTO chk_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nge mürin än Metusala uputiu, Enok a chiechiefengen me Kot ülüpükü ier, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Iwe, ierin manauen Enok meinisin ülüpükü wone me limu. ");
INSERT INTO chk_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok a chiechifengen me Kot. Mürin esap chüen nom, pun Kot a angei. ");
INSERT INTO chk_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Iwe, lupwen Metusala a ierini ipükü walik me fisu, a nöüni Lamek. ");
INSERT INTO chk_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nge ierin manauen Metusala mürin än Lamek uputiu füpükü walik me ruu, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Nge ierin manauen Metusala meinisin tiwepükü wone me tiu. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Iwe, lupwen Lamek a ierini ipükü walik me ruu, a nöüni eman ät. ");
INSERT INTO chk_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A aita ngeni Noa o apasa, “Ätei epwe angasakich seni weiresin angangen pöüch, pokiten ewe pwül a anümamau me ren ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nge ierin manauen Lamek mürin än Noa uputiu limupükü tiwe me limu, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Iwe, ierin manauen Lamek meinisin füpükü fik me fisu. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Iwe, lupwen Noa a ierini limupükü, a nöüni Säm, Ham me Jafet. ");
INSERT INTO chk_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Iwe, lupwen aramas ra popuetä chomongola won fanüfan, a pwal wor nöür föpwül. ");
INSERT INTO chk_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Nge nöün Kot kewe chon läng mi ngauala ra nenengeni liöchün nöün aramas föpwül. Iwe, ra pwülüeni chokewe ra efich. ");
INSERT INTO chk_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Mürin, ewe Samol mi Lapalap a apasa, “Ngüni esap nonom lon aramas tori feilfeilachök, pun aramas fituk chök. Iwe, ränin manauan epwe ipükü rüe ier chök.” ");
INSERT INTO chk_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Lon ena fansoun, pwal lon fansoun mürin a wor mwänämong won fanüfan, ir chokewe nöün aramas föpwül ra nöünöü me won nöün Kot kewe chon läng mi ngauala. Nge ekei mwänämong ra iteföüla lon ar nemenem me pwora lon ewe fansoun lomlom. ");
INSERT INTO chk_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Iwe, ewe Samol mi Lapalap a küna pwe än aramas föföringau a fokun wattela won fanüfan, nge ekiekin leluker a chök ngauala fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Iwe, ewe Samol mi Lapalap a lamalamala ren an föri aramas won fanüfan, letipan a pwal fokun weires ren. ");
INSERT INTO chk_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Iei mine a apasa, “Üpwe arosala föriei aramas me won fanüfan, pwal manfetal me mantötö me ekewe mansüsü. Pun üa lamalamala ren ai föriir.” ");
INSERT INTO chk_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nge Noa a küna ümöümöch me ren Kot. ");
INSERT INTO chk_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iei uruwon Noa. Noa eman chon pwüng, i chök a föföröch lein pilon kana, a pwal chiechifengen me Kot. ");
INSERT INTO chk_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Iwe, a wor ülüman nöün Noa mwän iter Säm, Ham me Jafet. ");
INSERT INTO chk_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nge chon fanüfan ra fokun föföringau fän mesen Kot o eäni föförün mwäneson ekis meinisin. ");
INSERT INTO chk_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Iwe, Kot a nengeni fanüfan o küna pwe a unusen ngau, pun ekewe aramas meinisin ra chök alapala ar föför mi ngau. ");
INSERT INTO chk_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nge Kot a üreni Noa, “Üpwe fokun arosala ekewe aramas meinisin, pun fanüfan a uren föförün mwäneson me rer. Üpwe fokun aroserela o ataala fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kopwe föri efoch waimw seni ewe irä itan kofer. Kopwe refi lon, kopwe pwal apacha ngeni apach lon me lükün. ");
INSERT INTO chk_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Iei usun om kopwe föri: langataman epwe ükükün föpükü lime fiit, chölapan fik me limu fiit, nge tekian faik me limu fiit. ");
INSERT INTO chk_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kopwe föri osun ewe waimw o likiti eu leni fan lefilen ewe os me etippan ükükün engol me walü inis. Kopwe pwal föri asamalapan lepekin. Epwe wor sässärin fan, sässärin lukalapan me sässärin won. ");
INSERT INTO chk_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ngang üpwe awarato eu noter won fanüfan pwe epwe arosala mönümanau meinisin won fanüfan. Meinisin mine a manau won fanüfan epwe mäla. ");
INSERT INTO chk_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nge ngang üpwe föri ai pwon ngonuk. Oupwe tolong lon ewe waimw, ämi me noum kewe mwän, pwal pwülüom me pwülüer kewe. ");
INSERT INTO chk_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Iwe, kopwe pwal uwalong lon ewe waimw akaruoman man seni man meinisin, eman ätemwän me eman liefefin, pwe repwe etuk le manau. ");
INSERT INTO chk_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Akaruoman seni iteiten sokun mansüsü me manfetal me mantötö repwe feilong reöm pwe repwe manau. ");
INSERT INTO chk_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Iwe, kopwe pwal uwalong sokun mongö meinisin o iseni pwe amötümi me amötür.” ");
INSERT INTO chk_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Iwe, Noa a föri meinisin mine Kot a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Iwe, ewe Samol mi Lapalap a üreni Noa, “Oupwe tolong lon ewe waimw ämi me chon leimwom, pun ngang üa küna pwe en ka pwüng mwen pilom kana. ");
INSERT INTO chk_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kopwe angei fisu pea seni iteiten sokun man mi limöch meinisin ra fich ngeni asor, eman ätemwän me eman liefefin, pwal eu pea seni iteiten sokun man mi limengau resap fich ngeni asor, eman ätemwän me eman liefefin. ");
INSERT INTO chk_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kopwe pwal angei fisu pea seni iteiten sokun mansüsü meinisin, eman ätemwän me eman liefefin, pun ekewe sokopaten mönümanau meinisin repwe manau won unusen fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mürin fisu rän üpwe apüngätiu üt won fanüfan lon ükükün faik rän me faik pwin. Üpwe arosala seni won fanüfan ekewe mönümanau meinisin üa föriir.” ");
INSERT INTO chk_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Iwe, Noa a föri meinisin mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Iwe, lupwen Noa a ierini wonopükü, ewe noter a tori fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nge Noa me nöün kewe, pwal pwülüan me pwülüer kewe ra tolong lon ewe waimw pwe repwe sü seni feiengauen ewe noter. ");
INSERT INTO chk_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Iwe, pwal akaruoman seni iteiten sokun man mi limöch me ekewe man mi limengau, pwal akaruoman seni iteiten sokun mansüsü me mantötö, eman ätemwän me eman liefefin, ");
INSERT INTO chk_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ra etalong Noa lon ewe waimw usun Kot a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Nge fisu rän mürin, ewe noter a tori fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Iwe, lupwen Noa a ierini wonopükü, lon engol me fisuen ränin ewe aruuen maram, ra möküla lenien kolukun failol pwe koluk a puächetä, ra pwal suk asammwachon läng ");
INSERT INTO chk_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","pwe üt a püngfochofochetiu won fanüfan lon ükükün faik rän me faik pwin. ");
INSERT INTO chk_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Lon ewe chök ränin, Noa me nöün kewe iter Säm, Ham me Jafet pwal pwülüan me pwülüen nöün kewe ülüman mwän ra tolong lon ewe waimw, ");
INSERT INTO chk_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ir me iteiten sokun manmwacho meinisin, sokun manfetal me sokun mantötö pwal sokun mansüsü meinisin. ");
INSERT INTO chk_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Iwe, akaruoman seni iteiten sokun mönümanau meinisin ra eti Noa le tolong lon ewe waimw, ");
INSERT INTO chk_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","eman ätemwän me eman liefefin. Ra tolong, pun iei usun Kot a allük ngeni Noa. Mürin, ewe Samol mi Lapalap a apüngala ewe asam. ");
INSERT INTO chk_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Iwe, a noter won fanüfan lon ükükün faik rän. Nge lupwen ewe koluk a fefeitä, ewe waimw a pwal feitä tori a tekia seni fanü. ");
INSERT INTO chk_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ewe koluk a nonomola o feitä, feitä won fanüfan, nge ewe waimw a maanüla won ewe koluk. ");
INSERT INTO chk_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Iwe, ewe koluk a chök feitä, feitä, feitä won fanüfan tori ekewe chuk mi fokun tekia seni chuk meinisin ra kokola. ");
INSERT INTO chk_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ewe koluk a chök fefeitä o pwölüöla ekewe chuk, nge alololun seni won ewe koluk feitiu won ungen ekewe chuk ükükün rüe me limu fiit. ");
INSERT INTO chk_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ekewe mönümanau meinisin mi nom won fanüfan ra mäla: mansüsü, manfesir, manmwacho me man meinisin mi mwökütüküt won fanüfan, pwal tori aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Meinisin mi eäni ngasangasen manau o nom won fanüfan ra mäla. ");
INSERT INTO chk_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Iwe, Kot a arosala mönümanau meinisin mi nom won fanüfan: aramas, manfetal, mantötö me mansüsü. Ir meinisin ra rosola seni won fanüfan. Noa chök a manau me chokewe mi eti lon ewe waimw. ");
INSERT INTO chk_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nge ewe koluk a nonomola won fanüfan lon ükükün ipükü lime rän. ");
INSERT INTO chk_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nge Kot a chechemeni Noa me ekewe man meinisin mi eti lon ewe waimw. Iwe, a tinato eu asepwäl won fanüfan. Iwe, ewe koluk a kisikisitiu. ");
INSERT INTO chk_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ekewe lenien kolukun failol ra morola, ekewe asammwachon läng ra kapüngüla, nge üt esap chüen püngütiu. ");
INSERT INTO chk_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Iwe, ewe koluk a chök kisikisitiu, nge mürin ipükü lime rän a morotiu. ");
INSERT INTO chk_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nge lon engol me fisuen ränin ewe afisuen maram ewe waimw a fanetä won eu chukun Ararat. ");
INSERT INTO chk_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Iwe, ewe koluk a chök kisikisitiu tori ewe aengolun maram. Nge lon ewe aeuin ränin ewe aengolun maram ra pwätä ungen ekewe chuk. ");
INSERT INTO chk_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mürin faik rän Noa a sukala asammwachon ewe waimw, i a föri, ");
INSERT INTO chk_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","o ässala eman machang . Iwe, ewe machang a chök äsfeil tori ewe koluk a pwasala me won fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mürin, Noa a ässala eman lisom, pun a mochen silei are ewe koluk a pwasala me won fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nge ewe lisom esap küna lenian ia epwe sotiu ie, pokiten ewe koluk a chüen pwölüöla unusen fanüfan. Iei mine a liwinto ren Noa lon ewe waimw. Iwe, Noa a angewu o angealong ewe lisom lon ewe waimw. ");
INSERT INTO chk_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nge Noa a pwal witiwit lon ükükün fisu rän. Mürin a ässisefäliela ewe lisom seni won ewe waimw. ");
INSERT INTO chk_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Iwe, ewe lisom a liwinsefälito lekuniol, nge a ilei echö chön irä olif mi manau. Iei mine Noa a silei pwe ewe koluk a morola seni won fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mürin, Noa a pwal witiwit fisu rän o ässala ewe lisom. Iwe, esap chüen liwinsefälito ren. ");
INSERT INTO chk_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nge lupwen Noa a ierini wonopükü eu, lon aeuin ränin ewe aeuin maram, ewe koluk a pwasala seni won fanüfan. Iwe, Noa a atomwala osun ewe waimw o küna pwe a ekis pwas won fanü. ");
INSERT INTO chk_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nge lon rüe me fisuen ränin ewe aruuen maram, a wesewesen pwas fanü. ");
INSERT INTO chk_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Iwe, Kot a üreni Noa, ");
INSERT INTO chk_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Oupwe towu me lon ewe waimw, en me pwülüom, pwal noum me pwülüer kewe. ");
INSERT INTO chk_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kopwe pwal atowu ekewe mönümanau meinisin mi etuk, ekewe mansüsü me manfetal me mantötö, pwe repwe nöünöü o achomongerela won fanüfan.” ");
INSERT INTO chk_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Iei mine Noa me nöün kewe ra towu seni ewe waimw, pwal pwülüan me pwülüen nöün kewe. ");
INSERT INTO chk_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Pwal ekewe manfetal me mantötö meinisin, ekewe mansüsü me ekewe man meinisin mi mwökütüküt won fanüfan ra towu me lon ewe waimw lon en me sokun. ");
INSERT INTO chk_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Mürin, Noa a senätä eu rongen asor fän iten ewe Samol mi Lapalap. Iwe, a angei eman man seni iteiten sokun man mi limöch me iteiten sokun mansüsü mi limöch, o eäniir asoren kek won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nge lupwen ewe Samol mi Lapalap a tini pwoöchün ewe asor, a ekieki lon lelukan, “Üsap chüen anümamaua fanüfan pokiten aramas. Üa silei pwe ekiekin leluken aramas a ngau seni lekisikisin. Üsap chüen arosala mönümanau meinisin, usun üa piin föri. ");
INSERT INTO chk_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Lon ükükün fansoun fanüfan a nom esap chüen ükütiu fofot me kinikin, patapat me pwichikar, räs me efen, rän me pwin.” ");
INSERT INTO chk_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Iwe, Kot a afeiöchü Noa me nöün kewe o üreniir, “Oupwe nöünöü o achomongakemi pwe fanüfan epwe masou remi. ");
INSERT INTO chk_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ekewe manfetal me mansüsü, ekewe mantötö me ikenen leset meinisin repwe niueitikemi. Üa atolongeer fän nemeniemi. ");
INSERT INTO chk_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Üa ngenikemi ekewe man meinisin mi manau pwe ochämi, usun üa fen ngenikemi uän ekewe irä pwe enemi. ");
INSERT INTO chk_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Eu chök, ousap fokun ochoch fituk mi cha, pun manau a chüen nom lon. ");
INSERT INTO chk_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Are eman epwe niela eman aramas, üpwe fokun liwini ngeni. Iteiten man me iteiten aramas mi niela eman aramas üpwe liwini ar föför ngeni mäla. ");
INSERT INTO chk_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kot a föri aramas lon püsin lapalapan. Iei mine iö epwe niela eman aramas, i epwe pwal ninnila ren aramas. ");
INSERT INTO chk_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nge ämi oupwe nöünöü o achomongakemi pwe fanüfan epwe masou remi.” ");
INSERT INTO chk_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Iwe, Kot a üreni Noa me nöün kewe, ");
INSERT INTO chk_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Iei üpwe föri ai pwon ngonuk me mwirimwirum kana, ");
INSERT INTO chk_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","pwal ngeni ekewe mönümanau meinisin mi nom reöm: ekewe mansüsü me manfesir me ekewe manmwacho meinisin mi etukowu me lon ewe waimw. ");
INSERT INTO chk_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Iei masouen ai we pwon ngonuk: Esap chüen fis mälan ekewe mönümanau meinisin ren pwal eu noter. Esap fokun chüen fis pwal eu noter mi ataela fanüfan.” ");
INSERT INTO chk_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kot a pwal apasa, “Iei asisilen ewe pwon esemwüch üa föri lefilei me ämi me ekewe mönümanau meinisin mi nom remi. ");
INSERT INTO chk_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Üpwe anomu ai resim won kuchu pwe asisilen ewe pwon lefilei me fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Iwe, lupwen üpwe awara kuchu won fanüfan, nge a pwal pwä ewe resim won, ");
INSERT INTO chk_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","üpwe chechemeni ai we pwon lefilei me ämi me ekewe mönümanau meinisin, pwe esap chüen fisisefäl eu noter mi arosala mönümanau meinisin. ");
INSERT INTO chk_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Iwe, lupwen ewe resim a nonom won kuchu, üpwe nenengeni o chechemeni ewe pwon esemwüch lefilei me ekewe mönümanau meinisin won fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Iei asisilen ewe pwon üa föri lefilei me mönümanau meinisin won fanüfan.” ");
INSERT INTO chk_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Iwe, iten nöün Noa kewe mwän ra towu seni lon ewe waimw: Säm, Ham me Jafet. Nge Ham semen Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ekei ülüman nöün Noa ir semelapen chon fanüfan meinisin. ");
INSERT INTO chk_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Iwe, Noa eman chon tanipi, i aemanün chon fotuki irän wain. ");
INSERT INTO chk_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Nge lupwen a ün seni ewe wain, a puchala ren. Iwe, a kon lon imwan imw mangaku, nge a selela. ");
INSERT INTO chk_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Iwe, lupwen Ham semen Kanaan a küna saman we lon an selela, a towu lükün o asile ngeni pwin kewe ruoman. ");
INSERT INTO chk_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Mürin, Säm me Jafet ra angei och mangaku, ra anomu won afarer o fetalsökürülong pwe repwe pwölüöla semer we lon an selela. Iwe, meser ra kul seni semer we pwe resap küna lon an selela. ");
INSERT INTO chk_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nge lupwen Noa a nela seni an puch o rong mine nöün we setiputur a föri ngeni, ");
INSERT INTO chk_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","a apasa, “Kanaan epwe anümamau. Pwin kana repwe nöüni amanau.” ");
INSERT INTO chk_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A pwal apasa, “Sipwe mwareiti ewe Samol mi Lapalap än Säm we Kot. Nge Säm epwe nöüni Kanaan amanau. ");
INSERT INTO chk_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kot epwe awattela fanüen Jafet, nge epwe imweimw lon imwen Säm. Iwe, Jafet epwe nöüni Kanaan amanau.” ");
INSERT INTO chk_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Iwe, Noa a manau mürin ewe noter lon ükükün ülüpükü lime ier. ");
INSERT INTO chk_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nge ükükün ierin manauen Noa tiwepükü lime. Mürin a mäla. ");
INSERT INTO chk_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iei mwirimwirin nöün Noa kewe mwän Säm, Ham me Jafet. Iwe, a wor nöür mwän mürin ewe noter won fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iwe, nöün Jafet mwän: Komer, Makok, Matai, Jafan, Tupal, Mesek me Tiras. ");
INSERT INTO chk_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Nge nöün Komer mwän: Askenas, Rifat me Tokarma. ");
INSERT INTO chk_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Nge nöün Jafan mwän: Elisha, Tarsis, pwal ekewe chon Kit me chon Totan. ");
INSERT INTO chk_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Iwe, ekewe aramas mi nonom aroset ra pop seniir. Iei mwirimwirin Jafet lon tettelin fanüer me ar fos, pwal lon tettelin ar famili me ar ainang. ");
INSERT INTO chk_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Iwe, nöün Ham mwän: Kush, Isip, Put me Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Nge nöün Kush mwän: Sepa, Hawila, Sapta, Raama me Sapteka. Nge nöün Raama mwän: Shepa me Tetan. ");
INSERT INTO chk_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Iwe, Kush a nöüni Nimrot. I aemanün sounemenem won fanüfan mi nemeni aramas fän pöchökül. ");
INSERT INTO chk_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nge Nimrot eman chon tapweri man, pwal eman chon pwora mi ü ngeni Kot. Iei mine aramas ra apasa lon ar mwiitun: Eman mi usun chök Nimrot ewe chon tapweri man, pwal ewe chon pwora mi ü ngeni Kot. ");
INSERT INTO chk_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Iwe, Nimrot a popuetä mwün lon Papilon, Erech, Akkat me Kalne. Ir meinisin ra nom lon ewe fanü Papilon. ");
INSERT INTO chk_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nge seni ei fanü Nimrot a pwal feila Asiria o aüetä ekewe telinimw Ninifa, Rehopot Ir, Kala ");
INSERT INTO chk_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","me Resen mi nom lefilen Ninifa me Kala, ewe telinimw mi fokun watte. ");
INSERT INTO chk_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Iwe, ekewe mwirimwirin Isip ekewe chon Lut, chon Anam, chon Lehap, chon Naftu, ");
INSERT INTO chk_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","chon Patrus, chon Kaslu me chon Kaftor, ir ekewe aramas chon Filistia ra pop seniir. ");
INSERT INTO chk_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Iwe, Kanaan semen Siton nöün we mwänichi me Het. ");
INSERT INTO chk_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Nge mwirimwirin Kanaan pwal ekewe chon Jepus, chon Amor, chon Kirkas, ");
INSERT INTO chk_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","chon Kiw, chon Ark, chon Sin, ");
INSERT INTO chk_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","chon Arwat, chon Semar me chon Hamat. Mürin, chon ekewe ainangen Kanaan ra chöfetal, ");
INSERT INTO chk_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","pwe kiännin fanüer a seni Siton wenewenen Kerar tori Kasa, a pwal weneiti Sotom me Komora, Atma me Sepoim, pwal tori Lasa. ");
INSERT INTO chk_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ir meinisin mwirimwirin Ham lon tettelin ar ainang, ar fos, fanüer me mwür. ");
INSERT INTO chk_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Iwe, Säm ewe mwänichi pwin Jafet i än nöün Eper kewe mwän meinisin lewo. ");
INSERT INTO chk_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Iwe, nöün Säm mwän: Elam, Ashur, Arpaksat, Lut me Aram. ");
INSERT INTO chk_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ekewe mwirimwirin Aram ekewe chon Us, chon Hul, chon Keter me chon Mesek. ");
INSERT INTO chk_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Iwe, Arpaksat semen Shela, nge Shela semen Eper. ");
INSERT INTO chk_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","A wor ruoman nöün Eper mwän. Iwe, iten ewe mwänichi Pelek , pun lon fansoun manauan ekewe aramasen fanüfan ra imwüfesen. Nge iten pwin we Joktan. ");
INSERT INTO chk_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Iwe, ekewe mwirimwirin Joktan ekewe chon Almotat, chon Selef, chon Hasarmawet, chon Jera, ");
INSERT INTO chk_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","chon Hatoram, chon Usal, chon Tikla, ");
INSERT INTO chk_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","chon Opal, chon Apimael, chon Sepa, ");
INSERT INTO chk_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","chon Ofair, chon Hawila me chon Jopap. Ir meinisin mwirimwirin Joktan. ");
INSERT INTO chk_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Iwe, kiännin fanüer seni Mesa tori Sefar lon ewe fanü mi chukuchukutä, mi nom ötiu. ");
INSERT INTO chk_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ir meinisin mwirimwirin Säm lon tettelin ar ainang, ar fos, fanüer me mwür. ");
INSERT INTO chk_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ekei aramas meinisin ir mwirimwirin nöün Noa kewe lon tettelin ar ainang me mwür. Iwe, ekewe ainangen aramas meinisin ra pop seniir o chonisefäli fanüfan mürin ewe noter. ");
INSERT INTO chk_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Lepoputan, chon fanüfan meinisin ra eäni eu chök fos pwal eu chök sokun kapas. ");
INSERT INTO chk_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nge lupwen aramas ra sai ngeni ötiu, ra küna eu fanü mi sosonöch itan Papilon. Iwe, ra nonom ikenan. ");
INSERT INTO chk_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Iwe, ra kapasfengen lefiler, “Ou etto, sipwe föri pilak seni pwül o umwuniir.” Iwe, a wor ar pilak fän iten aüetä imw me ar apach ra küna me fän pwül fän iten sessen pilak. ");
INSERT INTO chk_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Mürin ra apasa, “Ou etto, sipwe aüetä eu telinimw fän itach, pwal eu imw mi tekia, ungan epwe tori läng. Pun sipwe afisätä itach ren pwe sisap toropasfeil won unusen fanüfan.” ");
INSERT INTO chk_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Iwe, ewe Samol mi Lapalap a feitiu me läng pwe epwe nengeni ewe telinimw me ewe imw tekia ekewe aramas ra aüetä. ");
INSERT INTO chk_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mürin, ewe Samol mi Lapalap a apasa, “Eu chök mwichen aramas ir meinisin, nge eu chök ar fos lefiler. Ekärän iei poputän met ra föri, nge mürin repwe chök föri meinisin mine ra ekiekin föri, nge epwe chök tufich ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ousipwe feitiu ikenan o alikofifi ar fos pwe esap wor eman epwe chüen wewe ren kapasen eman.” ");
INSERT INTO chk_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Iei usun ewe Samol mi Lapalap a atoropasafeseniir won unusen fanüfan. Iwe, ra ükütiu me aüetä ewe telinimw. ");
INSERT INTO chk_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Iei mine ewe telinimw a iteni Papilon, pun ikenan ewe Samol mi Lapalap a alikofifi fosun aramas meinisin, a pwal atoropasafeseniir seni ikenan tori won unusen fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iei uruwon mwirimwirin Säm. Iwe, ruu ier mürin ewe noter won fanüfan, lupwen Säm a ierini ipükü, a nöüni Arpaksat. ");
INSERT INTO chk_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Iwe, ierin manauen Säm mürin än Arpaksat uputiu limepükü, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Iwe, lupwen Arpaksat a ierini ilik me limu, a nöüni Shela. ");
INSERT INTO chk_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nge ierin manauen Arpaksat mürin än Shela uputiu föpükü ülüngat, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Iwe, lupwen Shela a ierini ilik, a nöüni Eper. ");
INSERT INTO chk_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nge ierin manauen Shela mürin än Eper uputiu föpükü ülüngat, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Iwe, lupwen Eper a ierini ilik me rüanü, a nöüni Pelek. ");
INSERT INTO chk_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nge ierin manauen Eper mürin än Pelek uputiu föpükü ilik, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Iwe, lupwen Pelek a ierini ilik, a nöüni Reu. ");
INSERT INTO chk_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nge ierin manauen Pelek mürin än Reu uputiu ruupükü tiu, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Iwe, lupwen Reu a ierini ilik me ruu, a nöüni Seruk. ");
INSERT INTO chk_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nge ierin manauen Reu mürin än Seruk uputiu ruupükü fisu, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Iwe, lupwen Seruk a ierini ilik, a nöüni Nahor. ");
INSERT INTO chk_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Iwe, ierin manauen Seruk mürin än Nahor uputiu ruupükü, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Iwe, lupwen Nahor a ierini rüe me tiu, a nöüni Tara. ");
INSERT INTO chk_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nge ierin manauen Nahor mürin än Tara uputiu ipükü engol me tiu, a pwal wor nöün mwän me fefin. ");
INSERT INTO chk_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Iwe, lupwen Tara a ierini fik, a nöüni Apram, Nahor me Haran. ");
INSERT INTO chk_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Iei uruwon mwirimwirin Tara. Tara semen Apram, Nahor me Haran, nge Haran semen Lot. ");
INSERT INTO chk_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Iwe, Haran a mäla lon Ur lon ewe fanü Papilon, ewe telinimw a uputiu lon, lupwen saman Tara a chüen manau. ");
INSERT INTO chk_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Iwe, pwülüen Apram Sarai, nge pwülüen Nahor Milka. Iwe, Haran semen Milka me Iska. ");
INSERT INTO chk_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Nge Sarai esap nöünöü, pun a rit. ");
INSERT INTO chk_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Iwe, Tara a angei Apram nöün we me Lot nöün Haran pwin Apram we, pwal Sarai pwülüen Apram. Iwe, ra towu seni ewe telinimw Ur lon ewe fanü Papilon, pwe repwe feila lon ewe fanü Kanaan. Nge lupwen ra tori ewe telinimw Haran, ra imweimw ikenan. ");
INSERT INTO chk_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Iwe, Tara a mäla lon Haran, lupwen a ierini ruupükü limu. ");
INSERT INTO chk_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lon ewe fansoun ewe Samol mi Lapalap a üreni Apram, “Kopwe towu seni fanüom, seni aramasom pwal seni imwen semom, pwe kopwe feila lon ewe fanü ngang üpwe aiti ngonuk. ");
INSERT INTO chk_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Iwe, üpwe achomonga mwirimwirum kana pwe ir repwe wiliti eu mwü mi watte, üpwe pwal afeiöchuk o alapala itom pwe kopwe eman wän feiöch. ");
INSERT INTO chk_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Iwe, üpwe afeiöchü ekewe chon afeiöchuk, nge afeiengaua ekewe chon afeiengauok. Iwe, chon ekewe mwü meinisin won fanüfan repwe küna feiöch reöm.” ");
INSERT INTO chk_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Iwe, lupwen Apram a ierini fik me limu, a sai seni Haran, usun ewe Samol mi Lapalap a üreni, nge Lot a eti. ");
INSERT INTO chk_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Iwe, Apram a angei Sarai pwülüan we me Lot nöün pwin, pwal pisekir meinisin ra achufengeni me nöür kewe chon angang ra nöüniir amanau me lon Haran. Iwe, ra towu pwe repwe feila lon ewe fanü Kanaan. Iwe, lupwen ra tori, ");
INSERT INTO chk_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Apram a saifeil lon ewe fanü tori ewe leni itan Sikem, ia a wor ie ewe irä ook mi pin än More. Lon ena fansoun ekewe chon Kanaan ra nom lon ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Iwe, ewe Samol mi Lapalap a pwä ngeni Apram o üreni, “Ei fanü üpwe ngeni mwirimwirum kana.” Mürin, Apram a senätä eu rongen asor ikenan fän iten ewe Samol mi Lapalap mi pwä ngeni. ");
INSERT INTO chk_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Seni ikenan a feila ngeni ewe fanü mi chukuchukutä ötiuen Petel. Iwe, a aüetä imwan imw mangaku lefilen Petel mi nom lotou me Ai mi nom ötiu. Nge ikenan a pwal senätä eu rongen asor fän iten ewe Samol mi Lapalap o fel ngeni. ");
INSERT INTO chk_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mürin, Apram a sai seni eu leni tori pwal eu o fetaleiti peliörün ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nge a fis lengita lon ewe fanü Kanaan. Iei mine Apram a feila Isip o nonom ikenan, pun ewe lengita a fokun chou won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Nge lupwen a arap ngeni Isip, a kapas ngeni Sarai pwülüan we, “Üa silei pwe en eman fefin mi fokun liöch. ");
INSERT INTO chk_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Lupwen ekewe chon Isip repwe künok, repwe apasa pwe en pwülüei. Iwe, repwe nieila, nge en kopwe manau. ");
INSERT INTO chk_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Iei mine kopwe apasa pwe en fefinei. Mürin repwe eäni kirikiröch ngeniei o amanauaei pokitom.” ");
INSERT INTO chk_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Iwe, lupwen Apram a tolong lon Isip, ekewe chon Isip ra küna pwe ewe fefin a fokun liöch. ");
INSERT INTO chk_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nge lupwen nöün Farao kewe nöüwis ra küna neminewe, ra ainga ngeni Farao. Iwe, ra angei Sarai o emwenato lon imwen Farao. ");
INSERT INTO chk_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nge Farao a fokun eäni kirikiröch ngeni Apram pokiten Sarai. Iwe, a fang ngeni sip, kow, aas, chon angang mwän me chon angang fefin me kamel. ");
INSERT INTO chk_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Nge ewe Samol mi Lapalap a ariaföüü Farao me chon leimwan meinisin ren sokun feiengau mi lapalap pokiten Sarai pwülüen Apram we. ");
INSERT INTO chk_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mürin, Farao a körato Apram o apasa, “Pwota ka föri ngeniei ei sokun? Pwota kosap asile ngeniei pwe neminei pwülüom? ");
INSERT INTO chk_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pwota ka apasa pwe neminei fefinom? Ina popun üa angei pwe pwülüei. Kopwe angei pwülüom ei o sü seniei.” ");
INSERT INTO chk_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mürin, Farao a allük ngeni nöün kewe chon angang pwe repwe emwenala Apram. Iwe, ra angei Apram me pwülüan we me mettochun meinisin o emwenawu seni ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Iwe, Apram a liwinto seni Isip o feila peliörün Kanaan, i me pwülüan me pisekin meinisin. Nge Lot a pwal eti. ");
INSERT INTO chk_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Iwe, Apram a fokun wöü, pun a wor fokun chomong folenian man pwal an silifer me an kolt. ");
INSERT INTO chk_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mürin a sai seni ikenan, a sai seni eu leni tori pwal eu o feila ngeni Petel. Iwe, a tori ewe leni lefilen Petel me Ai ia imwan imw mangaku a nom ie me mwan. ");
INSERT INTO chk_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","A pwal tori ewe leni ia a senätä ie eu rongen asor me mwan. Ikenan Apram a fel ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Nge Lot mi eti Apram a pwal wor nöün sip me kow, a pwal wor an famili me nöün chon angang. ");
INSERT INTO chk_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Iei mine ewe fanü esap chüen ku ngeni ar repwe nonomfengen lon eu chök leni, pun a wor chomong folenier man. ");
INSERT INTO chk_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nge a wor aninifengen lefilen nöün Apram kewe chon fofol man me nöün Lot kewe chon fofol man. Lon ena fansoun ekewe chon Kanaan me chon Peres ra imweimw lon ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Mürin, Apram a kapas ngeni Lot, “Esap öch pwe epwe wor aninifengen lefilei me en, pwal lefilen nei chon fofol man me noum, pun en nei. ");
INSERT INTO chk_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ifa usun, esap suk ngonuk unusen ei fanü? Kose mochen imwü seniei. Are ka mochen feila pelimöngün ei fanü, ngang üpwe feila pelifichin, nge are ka mochen feila pelifichin, ngang üpwe feila pelimöngün.” ");
INSERT INTO chk_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nge Lot a nenefeil o küna pwe unusen ewe fanü ünüpen ewe chanpupu Jortan a wöün koluk ekis meinisin, usun chök ewe tanipin ewe Samol mi Lapalap, pwal usun chök ewe fanü Isip awenewenen Soar. Iei usun ewe fanü me mwen än ewe Samol mi Lapalap atai Sotom me Komora. ");
INSERT INTO chk_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Iei mine Lot a filätä unusen ewe fanü ünüpen ewe chanpupu Jortan fän itan o feila ngeni ötiu. Iei usun ekewe ruoman ra imwüfesen. ");
INSERT INTO chk_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iwe, Apram a nonom lon ewe fanü Kanaan. Nge Lot a imweimw lon ekewe telinimw mi nom lon ewe lemolun Jortan o aüetä imwan imw mangaku arap ngeni Sotom. ");
INSERT INTO chk_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Nge ekewe re Sotom ra fokun föföringau o tipis ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mürin än Lot feila seni Apram, ewe Samol mi Lapalap a kapas ngeni Apram, “Kopwe netä seni lon leniom o nengeni efeng me ör, ötiu me lotou, ");
INSERT INTO chk_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","pun unusen ewe fanü ka küna üpwe ngenikemi me mwirimwirum kana pwe oupwe fanüeni tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Üpwe achomonga mwirimwirum kana usun pien aroset. Iwe, are eman a tongeni aleani pien aroset, epwe pwal tongeni aleani mwirimwirum. ");
INSERT INTO chk_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kopwe feila o siamüfetal lon unusen ewe fanü, pun ngang üpwe ngonuk.” ");
INSERT INTO chk_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Iei mine Apram a atomwala imwan imw mangaku o feila. A aüetä imwan lein ekewe irä ook än Mamre lon ewe leni itan Hepron o nonom ikenan. Iwe, ikenan a pwal senätä eu rongen asor fän iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Iwe, lon ewe fansoun Amrafel ewe kingen Papilon, Ariok ewe kingen Ellasar, Ketor Laomer ewe kingen Elam me Tital ewe kingen Koim ");
INSERT INTO chk_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ra feila o maun ngeni Pera ewe kingen Sotom, Pirsa ewe kingen Komora, Sinap ewe kingen Atma, Semeper ewe kingen Sepoim pwal ngeni ewe kingen Pela, a pwal iteni Soar. ");
INSERT INTO chk_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Iwe, Pera me chienan kewe ra achufengeni nöür mwichen sounfiu lon ewe lemolun Sitim, iei ewe Setin Mäla ikenai. ");
INSERT INTO chk_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Iwe, lon ükükün engol me ruu ier ra angang ngeni Ketor Laomer, nge lon ewe engol me ülüngatin ier ra ütä o pälüeni. ");
INSERT INTO chk_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Iwe, lon engol me rüanün ier Ketor Laomer me ailan kewe king ra akufu ekewe chon Refa lon Asterot Karnaim, ekewe chon Sus lon Ham, ekewe chon Em lon Safei Kiriataim, ");
INSERT INTO chk_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","pwal ekewe chon Hor won ekewe chukun Etom, ra pwal tapweriir tori El Paran lon kiännin ewe fanüapö. ");
INSERT INTO chk_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Mürin ra kul o liwinsefäliti En Mispat, a pwal iteni Kates. Ra liapeni unusen ewe fanüen chon Amalek me chon Amor mi nom lon Hasason Tamar. ");
INSERT INTO chk_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Iwe, ekewe kingen Sotom, Komora, Atma, Sepoim me Pela, a pwal iteni Soar, ra achufengeni ar kewe mwichen sounfiu lon ewe lemolun Sitim ");
INSERT INTO chk_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","o maun ngeni Ketor Laomer ewe kingen Elam, Tital ewe kingen Koim, Amrafel ewe kingen Papilon me Ariok ewe kingen Ellasar. Iwe, föman king ra maun ngeni limman. ");
INSERT INTO chk_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Iwe, lemolun Sitim a wor chomong pwang ra ur ren apach mi lölö . Nge lupwen ekewe kingen Sotom me Komora ra süla me nöür kewe sounfiu, ekoch ra turutiu lor, nge ekewe lusun ra süla won ekewe chuk. ");
INSERT INTO chk_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Iwe, ekewe föman king ra angei pisekin chon Sotom me chon Komora meinisin pwal tori ener mongö o süla far. ");
INSERT INTO chk_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ra pwal uwala Lot nöün pwin Apram mi imweimw lon Sotom, me pisekin meinisin. ");
INSERT INTO chk_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Iwe, eman chon süla seniir a feito o apworausa ei pworaus ngeni Apram ewe re Ipru mi nonom lein ekewe irä ook än Mamre ewe chon Amor, pwin Eskol me Aner. Iwe, ir ailen Apram. ");
INSERT INTO chk_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Nge lupwen Apram a rong pwe nöün pwin we a oola, a körifengeni ülüpükü engol me walüman nöün chon angang mi uputiu lon imwan o sipeöch le maun, a ngeniir pisekin maun o tapweri ekewe chon liapenala Lot tori Tan. ");
INSERT INTO chk_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ikenan Apram a aimwüfeseni nöün kewe chon angang lon kükün mwich o maun ngeniir lepwin. Iwe, a akufuur o tapweriir tori Hopa efengin Tamaskus. ");
INSERT INTO chk_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Mürin, Apram a aliwinato ekewe pisek meinisin, a pwal aliwinato Lot nöün pwin we me an pisek, pwal tori ekewe fefin me ekewe aramas mi oola meinisin. ");
INSERT INTO chk_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Iwe, lupwen Apram a liwinto seni an akufu Ketor Laomer me chienan kewe king, ewe kingen Sotom a towu pwe epwe churi me lemolun Safe, a pwal iteni Lemolun King. ");
INSERT INTO chk_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Iwe, Melkisetek ewe kingen Salem a uwato pilawa me wain ren Apram. Melkisetek eman souasor nöün ewe Kot mi Unusen Tekia. ");
INSERT INTO chk_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Iwe, a afeiöchü Apram o apasa, “Kopwe feiöch, Apram, me ren ewe Kot mi Unusen Tekia, a föri läng me fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Sipwe mwareiti ewe Kot mi Unusen Tekia, a atolonga chon oputom fän nemeniom.” Mürin, Apram a ngeni Melkisetek eu leengol seni choon wokun meinisin. ");
INSERT INTO chk_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Iwe, ewe kingen Sotom a üreni Apram, “Kopwe aliwini ngeniei ekewe aramas, nge choon wokum kopwe eäni.” ");
INSERT INTO chk_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Nge Apram a üreni ewe kingen Sotom, “Üa akapel ngeni ewe Samol mi Lapalap, ewe Kot mi Unusen Tekia, a föri läng me fanüfan, ");
INSERT INTO chk_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","üsap angei och seni mine ka eäni, üsap pwal mwo nge angei emwü terech are efoch ririn sus, pwe kete üra pwe en ka awöüü Apram. ");
INSERT INTO chk_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Üsap fokun angei och fän itei lükün mine nei kewe chon angang ra mongö. Nge ekewe mwän mi etiei, Aner me Eskol me Mamre, repwe angei wiser.” ");
INSERT INTO chk_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Iwe, wesin ewe maun ewe Samol mi Lapalap a kapas ngeni Apram lon künaan, “Kosap niuokus Apram. Ngang tittum, nge liwinum epwe fokun watte.” ");
INSERT INTO chk_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Nge Apram a apasa, “Ai Samol me ai Kot, met ka tongeni ngeniei, nge esap wor nei. Nei chon angang Elieser seni Tamaskus epwe wöüni wöüi meinisin.” ");
INSERT INTO chk_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Iwe, Apram a pwal apasa, “Nengeni, kosamwo ngeniei eman nei. Iei popun eman nei kewe chon angang mi uputiu lon imwei epwe wöüni wöüi.” ");
INSERT INTO chk_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mürin, ewe Samol mi Lapalap a kapassefäl ngeni Apram, “Elieser esap wöüni woum, nge püsin eman noum mwän epwe wöüni.” ");
INSERT INTO chk_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nge Kot a üreni Apram pwe epwe towu me lon imwan. Mürin a kapas ngeni, “Kopwe netä läng o aleani ekewe fü. Ifa usun, ka tongeni aleaniir? Iei usun mwirimwirum kana repwe chomong usun chomongun ekewe fü.” ");
INSERT INTO chk_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iwe, Apram a lükü ewe Samol mi Lapalap o küna pwüng me ren Kot pokiten an lükülük. ");
INSERT INTO chk_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mürin, Kot a üreni, “Ngang ewe Samol mi Lapalap. Üa emwenukowu seni Ur lon ewe fanü Papilon, pwe üpwe ngonuk ei fanü pwe kopwe fanüeni.” ");
INSERT INTO chk_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Nge Apram a aisini, “Ai Samol me ai Kot, met üpwe silei ren pwe üpwe fanüeni ei fanü?” ");
INSERT INTO chk_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Iwe, a pälüeni, “Kopwe uwato rei eman kow esamwo nöünöü, eman liefefinin kuuch me eman ätemwänin sip ir me ülüman ülüngat ierir, pwal ruoman lisom, eman watte me eman kükün. ");
INSERT INTO chk_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iwe, Apram a uwato ren Kot ekewe man meinisin, a kinifeseniir lon ruu kinikin o anomu eu kinikin won eu pekin, nge eu kinikin won pwal eu pekin. Nge ekewe machang esap kinifeseniir. ");
INSERT INTO chk_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Iwe, lupwen machang mi mwacho ra sotiu won fituken ekewe man, Apram a asürela. ");
INSERT INTO chk_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nge lupwen akkar a arap ngeni an epwe tup, och möürüchou a tori Apram, pwal och niuokus me rochopwak mi fokun watte a püngütiu won. ");
INSERT INTO chk_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Iwe, ewe Samol mi Lapalap a üreni Apram, “Iei kopwe fokun silei pwe mwirimwirum kana repwe wasöla lon eu fanü sap fanüer. Aramas repwe nöüniir amanau ikenan, repwe küna riaföü lon ükükün föpükü ier. ");
INSERT INTO chk_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nge ngang üpwe apwüngü chon ewe fanü ra nöüniir amanau. Iwe, mürin repwe towu seni ewe fanü fän pisek mi chomong. ");
INSERT INTO chk_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nge en kopwe mäla o peias fän kinamwe lon om chinlap. ");
INSERT INTO chk_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Iwe, lon arüanün tettel mwirimwirum kewe repwe liwinsefälito ikei, pun esamwo tori otun ai üpwe apwüngü än ekewe chon Amor föföringau.” ");
INSERT INTO chk_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nge lupwen akkar a tuputiu, lupwen a kirochola, och ötüötün um me efoch töl mi ngetenget a fetal lefilen ekewe kinikinin fituken man. ");
INSERT INTO chk_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Iwe, lon ewe rän ewe Samol mi Lapalap a föri eu pwon ngeni Apram o apasa, “Üpwe ngeni mwirimwirum kana ei fanü, seni ewe chanpupun Isip tori ewe chanpupu mi watte itan Oifrat, ");
INSERT INTO chk_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ewe fanüen chon Ken, chon Kenis me chon Katmon, ");
INSERT INTO chk_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ewe fanüen chon Hit, chon Peris me chon Refa, ");
INSERT INTO chk_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","pwal tori fanüen ekewe chon Amor, chon Kanaan, chon Kirkas me chon Jepus.” ");
INSERT INTO chk_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Iwe, Sarai pwülüen Apram esamwo nöünöü. Nge a wor eman nöün kewe chon angang itan Hakar, eman fin Isip. ");
INSERT INTO chk_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Iwe, Sarai a üreni Apram, “Nengeni, ewe Samol mi Lapalap esap mwüt ngeniei ai üpwe nöünöü. Iei mine kopwe pwülüeni nei we chon angang. Eli epwe fis pwe epwe wor nei me ren.” Iwe, Apram a aüselinga alon Sarai. ");
INSERT INTO chk_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Iei mine Sarai a angei Hakar nöün we chon angang ewe fin Isip o ngeni Apram pwe epwe pwülüeni. Ei a fis mürin än Apram nom lon ewe fanü Kanaan lon ükükün engol ier. ");
INSERT INTO chk_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Iwe, Apram a kon ren Hakar, nge a pwopwo me won. Nge lupwen a mefi pwe a pwopwo, a lamalamtekia won Sarai an samol. ");
INSERT INTO chk_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mürin, Sarai a üreni Apram, “Tipisum ei, pwe ei riaföü a toriei. Üa ngonuk nei chon angang pwe kopwe pwülüeni. Nge lupwen a mefi pwe a pwopwo, a lamalamtekia woi. Ewe Samol mi Lapalap epwe eäni apwüng lefilach pwe epwe pwä iö a pwüng. ");
INSERT INTO chk_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Iwe, Apram a üreni Sarai, “Noum we chon angang a nom fän nemeniom. Kopwe föri ngeni mine ka mochen.” Iei mine Sarai a amiriti Hakar, nge neminewe a süla. ");
INSERT INTO chk_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nge nöün ewe Samol mi Lapalap chon läng a küna Hakar ünükün eu chönüttu lon fanüapö mi nom lepekin ewe al a ale ngeni Sur. ");
INSERT INTO chk_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Iwe, ewe chon läng a aisini, “Hakar nöün Sarai chon angang, ia ka feito me ie, nge ia kopwe feila ie?” Iwe, Hakar a pälüeni, “Üa sü seni ai samol Sarai.” ");
INSERT INTO chk_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Nge ewe chon läng a üreni, “Kopwe liwiniti om samol o anomuk fän nemenian.” ");
INSERT INTO chk_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mürin, nöün ewe Samol mi Lapalap chon läng a pwal üreni, “Üpwe fokun achomongala mwirimwirum pwe esap wor eman a tongeni aleaniir pokiten chomongur. ");
INSERT INTO chk_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nengeni ka pwopwo, nge kopwe nöüni eman ät. Iwe, kopwe aita ngeni Ismael , pun ewe Samol mi Lapalap a rongorong om siön riaföü. ");
INSERT INTO chk_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Iwe, noum epwe usun chök eman aas mi mwacho, epwe ü ngeni aramas meinisin, nge aramas meinisin repwe pwal ü ngeni. Iwe, epwe nonom lon fanüan o tipepöchökül ngeni aramasan.” ");
INSERT INTO chk_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Iwe, Hakar a aita ngeni ewe Samol mi Lapalap mi kapas ngeni me mwan, “En eman Kot mi nenengeniei.” Pun a apasa, “Ellet, üa küna ewe mi fen nenengeniei.” ");
INSERT INTO chk_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Iei mine aramas ra aita ngeni ewe chönüttu mi nom lefilen Kates me Peret Peer Lahairoi . ");
INSERT INTO chk_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Iwe, Hakar a nöüni eman ät me won Apram. Iwe, Apram a aita ngeni nöün we Ismael. ");
INSERT INTO chk_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Apram a ierini walik me wonu, lupwen Hakar a nöüni Ismael. ");
INSERT INTO chk_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Iwe, lupwen Apram a ierini tiwe me tiu, ewe Samol mi Lapalap a pwä ngeni o üreni, “Ngang ewe Kot mi Unusen Manaman. Kopwe manau me fän mesei o unusen föföröch. ");
INSERT INTO chk_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Iwe, üpwe anüküchara ai pwon lefilei me en, üpwe pwal fokun achomonga mwirimwirum.” ");
INSERT INTO chk_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Iwe, Apram a chapetiu lepwül, nge Kot a üreni, ");
INSERT INTO chk_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Iei ai we pwon ngonuk: En kopwe semen chomong ainang. ");
INSERT INTO chk_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Iei mine kosap chüen iteni Apram , nge kopwe iteni Apraham , pun üa awisok pwe kopwe semen chomong ainang. ");
INSERT INTO chk_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Üpwe fokun achomongala mwirimwirum o förätä chomong ainang senuk, epwe pwal wor king me lein mwirimwirum kana. ");
INSERT INTO chk_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Iwe, üpwe apwönüetä ai we pwon lefilei me ämi me mwirimwirum kana lon tettelir meinisin. Ai we pwon epwe nonom tori feilfeilachök pwe ngang üpwe om Kot, üpwe pwal än mwirimwirum kana Kot. ");
INSERT INTO chk_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Iwe, üpwe ngonuk pwal ngeni mwirimwirum kana unusen ewe fanü Kanaan ka wasöla lon. Iwe, repwe fanüeni ewe fanü tori feilfeilachök, nge ngang üpwe ar Kot.” ");
INSERT INTO chk_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Iwe, Kot a üreni Apraham, “Nge en kopwe pwal apwönüetä ai we pwon, ämi me mwirimwirum lon tettelir meinisin. ");
INSERT INTO chk_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Iei ai we pwon ngonuk me mwirimwirum kana oupwe apwönüetä: Nöümi ät meinisin repwe sirkomsais. ");
INSERT INTO chk_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Oupwe sirkomsaisi ewe kükün inis. Iei asisilen ewe pwon lefilei me ämi. ");
INSERT INTO chk_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Oupwe sirkomsaisi iteiten ät, lupwen a tori walu ränin, seni eu täppin aramas tori pwal eu. Oupwe pwal sirkomsaisi ekewe amanau mi uputiu lon ämi kewe famili me chokewe oua möniir seni ekewe chon ekis, ir sap mwirimwirimi. ");
INSERT INTO chk_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ir meinisin repwe sirkomsais. Iei usun ai we pwon mi fis won inisimi epwe nonom tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Iteiten mwän esap sirkomsais epwe kärila me lein aramasan, pun a atai ai we pwon.” ");
INSERT INTO chk_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Iwe, Kot a pwal üreni Apraham, “Kosap chüen aita ngeni pwülüom we Sarai, nge kopwe aita ngeni Sara . ");
INSERT INTO chk_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Üpwe afeiöchü Sara, nge üpwe ngonuk eman ät me ren. Ewer, üpwe afeiöchü pwe epwe inelapen chomong ainang, epwe pwal wor king me lein mwirimwirin kana.” ");
INSERT INTO chk_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iwe, Apraham a chapetiu lepwül, a takir o ekieki lon lelukan, “Ifa usun, eman mönükol epwe uputiu ngeni eman chinlap mi ierini ipükü? Nge Sara mi ierini tiwe epwe tongeni nöünöü?” ");
INSERT INTO chk_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Iwe, Apraham a üreni Kot, “Amwo Ismael epwe manau o feiöch me fän mesom.” ");
INSERT INTO chk_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nge Kot a üreni Apraham, “Apwi, Sara pwülüom we epwe nöüni eman noum ät. Iwe, kopwe aita ngeni Isaak . Üpwe apwönüetä ai pwon esemwüch ngeni, pwal ngeni mwirimwirin kana. ");
INSERT INTO chk_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nge üa pwal aüselingok fän iten Ismael. Üpwe fokun afeiöchü o achomongala nöün pwal mwirimwirin kana. Iwe, epwe semen engol me ruoman samol, nge üpwe föri pwe mwirimwirin repwe eu mwü mi fokun watte. ");
INSERT INTO chk_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nge ai we pwon üpwe apwönüetä ngeni Isaak noum we, ätewe Sara epwe nöüni mürin eu ier.” ");
INSERT INTO chk_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Iwe, lupwen Kot a wes me fos ngeni Apraham, a feitä seni. ");
INSERT INTO chk_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Lon ewe chök ränin, Apraham a angei Ismael nöün we me ekewe amanau meinisin mi uputiu lon imwan, pwal chokewe a möniir, o sirkomsaisiir meinisin, usun Kot a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iwe, Apraham a ierini tiwe me tiu, lupwen a sirkomsais. ");
INSERT INTO chk_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Nge Ismael nöün we a ierini engol me ülüngat, lupwen a sirkomsais. ");
INSERT INTO chk_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Iwe, lon ewe chök ränin, Apraham me Ismael nöün we ra sirkomsais, ");
INSERT INTO chk_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","pwal tori nöün kewe amanau ät me mwän meinisin, ir mi uputiu lon imwan, pwal chokewe a möniir seni chon ekis. Irfengen meinisin ra sirkomsais. ");
INSERT INTO chk_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Iwe, ewe Samol mi Lapalap a pwä ngeni Apraham lein ekewe irä ook än Mamre, lupwen a mot leasamalapen imwan imw mangaku leolokenin ewe rän. ");
INSERT INTO chk_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Iwe, lupwen a netä, a küna ülüman mwän ra ütä ekis toau seni. Nge lupwen a küneer, a mümütüla rer pwe epwe churiir. Iwe, a chapetiu lepwül ");
INSERT INTO chk_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","o apasa, “Ai kana samol, are üa küna ümöümöch me remi, ousap feila seniei ngang nöümi chon angang. ");
INSERT INTO chk_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Repwe uwato remi ekis koluk pwe oupwe talü pechemi. Iwe, oupwe asösö fän ewe irä, ");
INSERT INTO chk_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","nge ngang üpwe feila o angei elülü mongö pwe oupwe chünikemi. Iwe, mürin oupwapw feila. A öch pwe oua feito rei ngang nöümi chon angang.” Iwe, ra üreni, “Kopwe föri usun om apasa.” ");
INSERT INTO chk_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Iwe, Apraham a müttirilong lon imwan imw mangaku o üreni Sara, “Kopwe müttir angei eu tuk pilawa mi mürina, kopwe öüwa o umuni.” ");
INSERT INTO chk_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mürin, Apraham a mümütüla ngeni ewe lenien man o angei eman apanen kow mi ipwötükai o annö. Iwe, a ngeni eman nöün chon angang mi müttir amoota fitukan. ");
INSERT INTO chk_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Iwe, Apraham a uwato rer pwötö me milik me fituken ewe kow o ngeniir. Iwe, lupwen ar mongö, Apraham a ütä rer fän ewe irä. ");
INSERT INTO chk_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Iwe, ra aisini, “Ifa i Sara pwülüom we?” Nge Apraham a pälüeniir, “A nom leimw.” ");
INSERT INTO chk_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Iwe, ewe Samol mi Lapalap a üreni, “Üpwe fokun liwinto reöm mürin eu ier. Nge Sara pwülüom we epwe nöüni eman ät.” Iwe, Sara a rongorong ei kapas me aropen asamalapen ewe imw mangaku me lükisökürün. ");
INSERT INTO chk_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nge Apraham me Sara ra wesewesen chinlap, iei popun Sara esap chüen tongeni nöünöü. ");
INSERT INTO chk_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Iei mine Sara a takir o ekieki lon lelukan, “Ifa usun, ngang üpwe chüen eäni mochenin fituk lon ai chinlap, nge ai samol a pwal chinlap?” ");
INSERT INTO chk_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mürin, ewe Samol mi Lapalap a üreni Apraham, “Pwota Sara a takir o ekieki lon lelukan, ‘Ifa usun, üpwe wesewesen tongeni nöünöü lon ai chinlap?’ ");
INSERT INTO chk_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ifa usun, epwe wor och ewe Samol mi Lapalap esap tufich ngeni? Üpwe fokun liwinto reöm mürin eu ier, usun üa fen pwon ngonuk me mwan. Lon na otun Sara epwe nöüni eman ät.” ");
INSERT INTO chk_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Nge Sara a niuokus, iei mine a amam o apasa, “Üsap takir.” Nge ewe Samol mi Lapalap a pälüeni, “Apwi, ka wesewesen takir.” ");
INSERT INTO chk_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Iwe, ekewe mwän ra ütä o feila ngeni eu leni ia ra tongeni netiu won Sotom me ie. Nge Apraham a etiir pwe epwe emweni ngeniir aler. ");
INSERT INTO chk_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mürin, ewe Samol mi Lapalap a apasa, “Pwota üpwe aopa seni Apraham mine üpwe föri? ");
INSERT INTO chk_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Pun üa silei pwe Apraham epwe wiliti eu mwü mi fokun watte o pöchökül, nge mwün fanüfan meinisin repwe küna ar feiöch me ren. ");
INSERT INTO chk_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Iwe, üa fen afili pwe epwe aiti ngeni nöün me chon leimwan me mwirimwirin kana usun ar repwe aleasochisiei o föri mine a pwüng me wenechar. Iwe, are repwe föri iei usun, ngang ewe Samol mi Lapalap üpwe atoto won Apraham mine üa fen pwon ngeni.” ");
INSERT INTO chk_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mürin, ewe Samol mi Lapalap a üreni Apraham, “Kapasen atutur usun än chon Sotom me Komora föföringau a watte, nge ar kewe tipis ra fokun chou. ");
INSERT INTO chk_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Üpwe feitiu rer o nengeni are a pwüng ekewe kapasen atutur mi toriei. Nge are esap pwüng, üpwe pwal silei.” ");
INSERT INTO chk_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Iwe, ekewe ruoman mwän ra feila seni ikenan pwe repwe feila Sotom. Nge Apraham a chök ütä fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Mürin, Apraham a kan ngeni o aisini, “Ifa usun, kopwe wesewesen niela chon pwüng fiti chon pwüngingau? ");
INSERT INTO chk_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Eli epwe wor lime chon pwüng lon ewe telinimw. Kopwe pwal nirela, nge kosap amanaua ewe telinimw fän iten ekewe lime chon pwüng ra nonom lon? ");
INSERT INTO chk_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ese tufich om kopwe föri ina usun, pwe kopwe niela ekewe chon pwüng fiti chon pwüngingau, pwe chon pwüng repwe chök wewe ngeni chon pwüngingau. Ese tufich om kopwe föri ina usun. Ifa usun, ewe Souapwüngün unusen fanüfan esap eäni apwüng fän pwüng?” ");
INSERT INTO chk_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Iwe, ewe Samol mi Lapalap a pälüeni, “Are üpwe küna lime chon pwüng lon ewe telinimw Sotom, üpwe amanaua unusen chon ewe telinimw fän iten ekewe lime.” ");
INSERT INTO chk_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Mürin Apraham a kapassefäl ngeni, “Kose mochen kopwe amusala ai kapaspat ngonuk, ai Samol, pun ngang pwül me falang chök. ");
INSERT INTO chk_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Eli esap tori lime chon pwüng, nge faik me limman chök. Ifa usun, kopwe atai unusen ewe telinimw fän iten ekewe limman rese nom?” Iwe, Kot a pälüeni, “Are üpwe küna faik me limman, üsap atai ewe telinimw.” ");
INSERT INTO chk_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nge Apraham a kapassefäl ngeni, “Eli a chök wor faik mi nom lon.” Iwe, Kot a pälüeni, “Üsap atai fän iten ekewe faik.” ");
INSERT INTO chk_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Mürin, Apraham a üreni, “Kose mochen kosap chou ngeniei, ai Samol, are üpwe pwal kapas fän eu. Eli a chök wor ilik mi nom lon.” Nge Kot a pälüeni, “Üsap atai, are üpwe küna ilik.” ");
INSERT INTO chk_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iwe, Apraham a pwal apasa, “Kose mochen kopwe amusala pwe üa chök kapaspat ngonuk, ai Samol. Eli rüe chök ra nom lon.” Nge Kot a pälüeni, “Üsap atai ewe telinimw fän iten ekewe rüe.” ");
INSERT INTO chk_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iwe, Apraham a kapassefäl, “Kose mochen kosap chou ngeniei, ai Samol. Üpwe kapassefäl pwal fän eu chök. Eli epwe wor engol mi nom lon.” Nge Kot a pälüeni, “Üsap fokun atai ewe telinimw fän iten ekewe engol.” ");
INSERT INTO chk_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Iwe, lupwen ewe Samol mi Lapalap a wes me kapas ngeni Apraham, a feila seni. Nge Apraham a liwiniti lenian. ");
INSERT INTO chk_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Iwe, lupwen ekewe ruoman chon läng ra tori Sotom lekuniol, Lot a mot lon asamalapen tittin Sotom. Nge lupwen Lot a küneer, a ütä o feila rer. Iwe, a chapetiu lepwül ");
INSERT INTO chk_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","o üreniir, “Ai kana samol, ouse mochen oupwe tolong lon imwei ngang nöümi chon angang. Iwe, oupwe talü pechemi o möür rei. Nge lesosorusich oupwe pwätä o sopwela ämi sai.” Nge ir ra pälüeni, “Apwi, äm aipwe chök nonom lükün.” ");
INSERT INTO chk_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nge Lot a fokun peseer pwe repwe eti. Iei mine ra tolong lon imwan. Iwe, Lot a amolätä eu mongö fän iter, a pwal umuni pilawa esap wor iis lon. Iwe, ra mongö. ");
INSERT INTO chk_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nge mwen ar möür, ekewe re Sotom meinisin, ekewe alüal me chinlap ra feito seni ekis meinisin o pwelifeili imwen Lot. ");
INSERT INTO chk_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Iwe, ra kölong ren Lot o apasa, “Ikafa ir ekana mwän ra feito reöm lon ei pwinin? Kopwe emwenirewu pwe aipwe föföringau ngeniir.” ");
INSERT INTO chk_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Iwe, Lot a towu rer o apüngala asamalapen imwan me lükün sökürün. ");
INSERT INTO chk_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Iwe, a üreniir, “Pwipwi kana, üa tüngor ngenikemi pwe ousap föri ei sokun föför mi ngau. ");
INSERT INTO chk_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nengeni, mi wor ruoman nei föpwül resamwo pwüpwülü. Üpwe emwenirewu remi pwe oupwe föri ngeniir mine oua mochen. Nge ousap föföringau ngeni ekewe mwän, pun üa etiweer lon imwei pwe üpwe tümwünüür.” ");
INSERT INTO chk_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nge ekewe re Sotom ra pälüeni, “Kopwe süla! En ka feito pwe kopwe wasöla rem, nge iei ka apwüngükem. Iei mine aipwe aweiresuk lap seniir.” Iwe, ra ki ngeni Lot fän pöchökül, ra pwal kan ngeni pwe repwe ripi asamalapen imwan. ");
INSERT INTO chk_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Nge ekewe ruoman mwän ra angewu o angealong Lot pwe epwe nom rer leimw. Iwe, ra anükala ewe asamalap. ");
INSERT INTO chk_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mürin ra achuna ekewe mwän meinisin mi nonom lükün asamalapen ewe imw, seni alüal tori chinlap, pwe resap tongeni küna ewe asamalap. ");
INSERT INTO chk_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nge ekewe ruoman mwän ra aisini Lot, “Ifa usun, mi pwal wor aramasom ikei, pwülüen noum kewe föpwül, are noum ät me nengin, are pwal eman märärum? Kopwe emwenirewu seni lon ei telinimw. ");
INSERT INTO chk_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pun äm aipwe ataala. Kapasen atutur usun föföringauen aramasen ei leni a fokun wattela fän mesen ewe Samol mi Lapalap. Iei popun a tinikeemito pwe aipwe atai.” ");
INSERT INTO chk_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Iwe, Lot a towu ren kofotun nöün kewe föpwül o üreniir, “Oupwe feil seni ikei, pun ewe Samol mi Lapalap epwe atai ei telinimw.” Nge ir me ruoman ra ekieki pwe a chök urumwot. ");
INSERT INTO chk_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Iwe, lupwen a tö mallen rän, ekewe chon läng ra amüttiri Lot o üreni, “Kopwe müttir angei pwülüom me noum kewe ruoman föpwül mi nom reöm o sü pwe kosap pwal feiengaueni feiengauen ei telinimw.” ");
INSERT INTO chk_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Nge lupwen Lot a mang, ekewe mwän ra turufi pöün pwal pöün pwülüan me nöün kewe ruoman föpwül o aweinerewu lükün ewe telinimw, pun ewe Samol mi Lapalap a ümöümöch ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Iwe, lupwen ra aweinerewu lükün, eman leir a üreniir, “Oupwe kaila o amanauakemi, nge ousap nesefäl. Ousap pwal üla lon ewe lemol, nge oupwe süla ngeni ekewe chuk pwe oute mäla.” ");
INSERT INTO chk_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Nge Lot a pälüeni, “Apwi, sap ina, ai Samol! ");
INSERT INTO chk_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Noum ei chon angang a küna ümöümöch me reöm, ka pwal fokun kirikiröch ren om amanauaei. Nge ngang üsap tongeni süla ngeni ekewe chuk. Eli feiengau epwe toriei pwe üpwe mäla me mwen üpwe tori ekewe chuk. ");
INSERT INTO chk_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nengeni, mi wor eu kükün telinimw, a kanoto pwe üpwe tongeni sülong lon. Kose mochen kopwe mwüt ngeniei pwe üpwe sülong lon. Ifa usun, esap kükün ewe telinimw? Iwe, ikenan üpwe tongeni manau me ie.” ");
INSERT INTO chk_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Iwe, a pälüeni, “Ewer, üa tipeeu ngeni om ei tüngor, üsap ataala ewe telinimw ka kapas usun. ");
INSERT INTO chk_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kopwe kaila o süla ikenan, pun üsap tongeni föri och me mwen om kopwe tori.” Iei popun ewe telinimw a iteni Soar . ");
INSERT INTO chk_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Iwe, akkar a tötä, lupwen Lot a tori Soar. ");
INSERT INTO chk_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Mürin, ewe Samol mi Lapalap a apüngätiu seni läng ütten primston me ekkei won Sotom me Komora. ");
INSERT INTO chk_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Iwe, a ataala ekewe telinimw pwal unusen ewe lemol, pwe aramasen ekewe telinimw meinisin ra rosola, a pwal tala mine a mär won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nge pwülüen Lot mi nom kukumwir a nesefäl o wiliti efoch üresalt. ");
INSERT INTO chk_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Iwe, lesosorusich Apraham a pwätä o feila won ewe leni ia a ütä ie fän mesen ewe Samol mi Lapalap me mwan. ");
INSERT INTO chk_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Iwe, a netiuei Sotom me Komora me unusen ewe lemol, nge a chök küna och ötün ekkei a ötütä seni ewe fanü, a wewe ngeni ötün eu um mi fokun watte. ");
INSERT INTO chk_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Iwe, a fis pwe lupwen Kot a ataala ekewe telinimwen ewe lemol, a chechemeni Apraham. Iwe, a emwenawu Lot seni lon ewe feiengau, lupwen a ataala ekewe telinimw Lot a imweimw lon. ");
INSERT INTO chk_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Iwe, mürin, Lot a towu seni Soar o nonom won ekewe chuk me nöün kewe ruoman föpwül, pun a niuokus an epwe imweimw lon Soar. Iwe, ra nonom lon eu föüimw. ");
INSERT INTO chk_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Iwe, lon eu rän ewe finichi a üreni ewe setipütür, “Samach ei a chinlap, nge esap wor eman mwän won ei fanü a tongeni pwülüenikich pwe epwe wor nöüch. ");
INSERT INTO chk_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Etto, sipwe aünü ngeni samach ei wain, mürin sipwe kon ren pwe epwe wor mwirimwirin.” ");
INSERT INTO chk_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Iwe, ra aünü ngeni semer we wain lon ewe pwinin. Iwe, ewe finichi a tolong o kon ren. Nge Lot esap mefi, lupwen nöün we a kon ren, pwal lupwen a pwätä. ");
INSERT INTO chk_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Iwe, sorotän ewe rän ewe finichi a üreni ewe setipütür, “Üa kon ren semei lepwin ewe. Sipwe pwal aünü ngeni samach ei wain lepwin ei. Mürin, en kopwe tolong o kon ren pwe epwe wor mwirimwirin.” ");
INSERT INTO chk_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Iwe, ra pwal aünü ngeni semer we wain lon ewe pwinin, nge ewe setipütür a tolong o kon ren. Nge Lot esap pwal mefi, lupwen nöün we a kon ren, pwal lupwen a pwätä. ");
INSERT INTO chk_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Iei usun nöün Lot kewe ruoman föpwül ra pwopwo me won semer we. ");
INSERT INTO chk_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Iwe, ewe finichi a nöüni eman ät o aita ngeni Moap. Iwe, tori ikenai i semelapen ekewe chon Moap. ");
INSERT INTO chk_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nge ewe setipütür a pwal nöüni eman ät o aita ngeni Pen Ami. Iwe, tori ikenai i semelapen ekewe chon Amon. ");
INSERT INTO chk_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Iwe, Apraham a sai seni Mamre o sai ngeni peliör tori ewe fanü itan Nekep. Iwe, a nom lefilen Kates me Sur, a pwal wasöla lon Kerar. ");
INSERT INTO chk_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Nge Apraham a apasa usun Sara pwülüan we pwe fefinan. Iwe, Apimelek ewe kingen Kerar a titi Sara pwe epwe feito ren. ");
INSERT INTO chk_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Nge Kot a pwä ngeni Apimelek lon an tan lepwin o üreni, “Kopwe le mäla, pokiten ka angei neminewe, nge a wor pwülüan.” ");
INSERT INTO chk_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nge Apimelek esamwo kon ren. Iei mine a apasa, “Ai Samol, ifa usun, kopwe nieila me aramasei, nge esap wor äm tipis? ");
INSERT INTO chk_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ifa usun, ätenan esap püsin apasa ngeniei pwe neminan fefinan? Ifa usun, neminan esap pwal apasa pwe mongean ätenan? Iwe, ren wenecharen letipei me limöchün pei ngang üa föri ei sokun föför.” ");
INSERT INTO chk_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mürin, Kot a kapas ngeni lon an tan, “Ewer, üa silei pwe ka föri ena sokun föför ren wenecharen letipom. Ngang ewe üa apetuk seni om tipis ngeniei, iei mine üsap mwüt ngonuk pwe kopwe atapa. ");
INSERT INTO chk_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Iei kopwe chök aliwinala ngeni ätenan pwülüan we, pun i eman soufos. Iwe, epwe iotek fän itom pwe kopwe manau. Nge are kosap aliwinala, kopwe silei pwe kopwe wesewesen mäla, en me aramasom kewe meinisin.” ");
INSERT INTO chk_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Iei mine Apimelek a pwätä lesosorusich, a körato nöün kewe nöüwis meinisin o apworausa ngeniir ekewe mettoch meinisin. Iwe, ekewe mwän ra fokun niuokus. ");
INSERT INTO chk_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Mürin, Apimelek a körato Apraham o üreni, “Met ei ka föri ngenikem? Met ai tipis ngonuk pwe ka awarato eu tipis watte woi pwal won mwüi? Esap wor eman epwe föri ei sokun föför ka föri ngeniei.” ");
INSERT INTO chk_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Iwe, Apimelek a pwal aisini Apraham, “Pwota ka föri ei sokun föför?” ");
INSERT INTO chk_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nge Apraham a pälüeni, “Üa föri ei, pun üa ekieki pwe aramasen ei leni resap niueiti Kot, iwe, repwe nieila pokiten pwülüei we. ");
INSERT INTO chk_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ellet, neminei wesewesen fefinei pun nöün semei, nge esap nöün inei. Iwe, üa chök pwülüeni. ");
INSERT INTO chk_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Nge lupwen Kot a aiti ngeniei pwe üpwe feila seni imwen semei o siamüfetal, üa üreni pwülüei we, ‘Iei usun kopwe pwäri om kirikiröch ngeniei. Lon ekewe leni meinisin sia tori kopwe apasa pwe ngang mongeom.’” ");
INSERT INTO chk_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Mürin, Apimelek a angei sip me kow pwal chon angang mwän me chon angang fefin o ngeni Apraham. A pwal aliwini ngeni Apraham Sara pwülüan we. ");
INSERT INTO chk_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Iwe, Apimelek a üreni Apraham, “Nengeni, fanüei a nom mwom, kopwe nonom ia ka mochen nonom ie.” ");
INSERT INTO chk_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A pwal üreni Sara, “Nengeni, üa ngeni mongeom we engeröü föün moni silifer. Ei epwe alletä ngeni ekewe aramas mi nonom reöm pwe kosap tipis. Ir meinisin repwe silei pwe kosap föri och mi mwäl.” ");
INSERT INTO chk_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Mürin, Apraham a iotek ngeni Kot fän iter. Iwe, Kot a apöchökülätä Apimelek me pwülüan me nöün kewe chon angang fefin pwe ra tongeni nöünöü. ");
INSERT INTO chk_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Pun me mwan ewe Samol mi Lapalap a föri pwe ekewe fefin mi nom lon imwen Apimelek ra rit pokiten mine a fis ngeni Sara pwülüen Apraham we. ");
INSERT INTO chk_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Iwe, ewe Samol mi Lapalap a eäni kirikiröch ngeni Sara o apwönüetä mine a fen pwon ngeni. ");
INSERT INTO chk_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Iwe, Sara a pwopwo o nöüni eman ät ngeni Apraham lon an chinlap. Ei a fis lon ewe fansoun Kot a fen kapas usun. ");
INSERT INTO chk_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Nge Apraham a aita ngeni nöün we Isaak. ");
INSERT INTO chk_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Iwe, Apraham a sirkomsaisi Isaak nöün we, lupwen a tori walü ränin, usun Kot a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nge Apraham a ierini ipükü, lupwen Isaak a uputiu ngeni. ");
INSERT INTO chk_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Iwe, Sara a üra, “Kot a apwapwaei o atakiriei, nge meinisin mi rong ei pworaus repwe pwal etiei le takir.” ");
INSERT INTO chk_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A pwal üra, “Iö a tongeni ürü ngeni Apraham pwe Sara epwe oupwu semirit? Nge iei üa wesewesen nöüni eman ät ngeni Apraham lon an chinlap.” ");
INSERT INTO chk_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Iwe, ewe ät Isaak a mämäritä, nge lupwen a mwü seni oupw, Apraham a föri eu kametip mi watte lon ewe ränin. ");
INSERT INTO chk_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lon eu rän Sara a küna Ismael nöün Hakar we ewe fin Isip, ätewe a nöüni me won Apraham, pwe a urumwotiti Isaak nöün we. ");
INSERT INTO chk_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Iei mine a üreni Apraham, “Kopwe asüela ewe chon angang me nöün we. Pun nöün ewe chon angang esap eti nei we le wöüni woum.” ");
INSERT INTO chk_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Iwe, Apraham a fokun oput alon Sara usun Ismael nöün we. ");
INSERT INTO chk_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nge Kot a üreni Apraham, “Kosap oput alon Sara usun ewe ät me noum we chon angang fefin. Kopwe föri meinisin mine Sara a ürenuk, pun mwirimwirin Isaak chök ikkei ir mwirimwirum kewe üa pwon ngonuk. ");
INSERT INTO chk_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nge üpwe pwal föri seni nöün ewe chon angang fefin eu mwichen aramas mi chomong, pun i pwal noum.” ");
INSERT INTO chk_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Iei mine Apraham a pwätä lesosorusich, a angei mongö me eu rumen koluk o isetä won afaren Hakar. Iwe, a tinirela me nöün we ät. Iwe, Hakar a feila o süsüfeil lon ewe fanüapön Peersepa. ");
INSERT INTO chk_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nge lupwen a pöla ewe koluk seni lon ewe rume, a likitala nöün we fän efoch irä. ");
INSERT INTO chk_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Mürin, a feila seni o mottiu awenewenan, nge toauan ina epwe ükükün lime ngaf. Pun a apasa, “Üsap tongeni nengeni mälan ewe ät.” Iwe, lupwen a mot ikenan, ewe ät a popuetä le kechü. ");
INSERT INTO chk_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nge Kot a aüselinga kechüen ewe ät. Iwe, nöün Kot we chon läng a köri Hakar seni lon läng o üreni, “Met ka weires ren, Hakar? Kosap niuokus, pun Kot a aüselinga kechüen ewe ät seni ewe ia a nom ie. ");
INSERT INTO chk_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kopwe ütä, apwätäi ewe ät o achipa, pun ngang üpwe föri seni eu mwichen aramas mi chomong.” ");
INSERT INTO chk_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Mürin, Kot a anelai mesen Hakar pwe a küna eu chönüttu. Iwe, a feila ngeni, a alölöü ewe rumen koluk o aünü nöün we. ");
INSERT INTO chk_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nge Kot a tümwünü ewe ät pwe a mämäritä. Iwe, a nonom lon fanüapö, nge a fokun föükus le likapich. ");
INSERT INTO chk_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Iwe, lupwen a nonom lon ewe fanüapön Paran, inan we a angei eman pwülüan seni ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lon ewe fansoun Apimelek me Fikol ewe meilapen nöün mwichen sounfiu ra feila ren Apraham o üreni, “Kot a etuk lon meinisin mine ka föri. ");
INSERT INTO chk_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Iei mine kopwe pwon fän akapel ngeniei ikenai me fän mesen Kot, pwe kosap angangingau ngeniei are ngeni nei kewe are pwal ngeni mwirimwiri kewe. Usun ngang üa kirikiröch ngonuk, iei usun en kopwe pwal kirikiröch ngeniei, pwal ngeni ewe fanü ia ka wasöla lon.” ");
INSERT INTO chk_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Nge Apraham a üreni, “Ina, üpwe pwon fän akapel ngonuk.” ");
INSERT INTO chk_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Iwe, lupwen Apraham a apwüngü Apimelek pokiten eu chönüttu nöün kewe chon angang ra angei fän pöchökül, ");
INSERT INTO chk_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Apimelek a üreni, “Üsap silei iö a föri ena sokun föför. En kosap asile ngeniei, üsamwo rongorong usun tori ikenai.” ");
INSERT INTO chk_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Mürin, Apraham a angei sip me kow o ngeni Apimelek. Iei usun ekewe ruoman mwän ra pwonfengen. ");
INSERT INTO chk_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nge Apraham a aimwüela füman apanen sip seni me lein nöün pwiin sip. ");
INSERT INTO chk_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Iwe, Apimelek a aisini Apraham, “Met wewen ekewe füman apanen sip en ka aimwüela?” ");
INSERT INTO chk_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iwe, a pälüeni, “Ekewe füman apanen sip kopwe angei seniei, pwe repwe eu pisekin pwärätä pwe ngang üa tuw ei chönüttu.” ");
INSERT INTO chk_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Iei mine ewe leni a iteni Peersepa , pun ikenan ir me ruoman ra pwon fän akapel. ");
INSERT INTO chk_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mürin ar pwonfengen lon Peersepa, Apimelek me Fikol ewe meilapen nöün mwichen sounfiu ra ütä o liwiniti ewe fanü Filistia. ");
INSERT INTO chk_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Iwe, Apraham a fotuki efoch irä itan tamarisk lon Peersepa. Ikenan a fel ngeni ewe Samol mi Lapalap, ewe Kot mi nom tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Iwe, Apraham a wasöla lon ewe fanü Filistia fansoun langatam. ");
INSERT INTO chk_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mürin ekoch fansoun Kot a sotuni Apraham o üreni, “Apraham.” Nge i a pälüeni, “Ngang iei.” ");
INSERT INTO chk_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Iwe, Kot a üreni, “Kopwe angei Isaak noum aleman, ka echeni, o feila won ewe fanü Moria. Ikenan kopwe eäni asoren kek ngeniei won eu chuk üpwe aiti ngonuk.” ");
INSERT INTO chk_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Iei mine Apraham a pwätä lesosorusich, a äsätta mwüch fän iten ewe asoren kek o rietä won nöün aas. A pwal angei Isaak nöün we me ruoman nöün kewe chon angang, pwe repwe eti. Iwe, ra feila lon ewe leni Kot a aiti ngeni. ");
INSERT INTO chk_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nge lon aülüngatin ränin ar sai, Apraham a küna ewe leni me toau. ");
INSERT INTO chk_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Mürin, Apraham a üreni nöün kewe chon angang, “Oupwe nonom ikei me ewe aas. Nge äm me ätei aipwe feila ikenan o fel ngeni Kot. Iwe, are aipwe wes, aipwe liwinto remi.” ");
INSERT INTO chk_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Mürin, Apraham a angei ewe mwüchün asoren kek o isetä won afaren Isaak nöün we. Nge ewe ekkei me ewe naif a püsin uwei. Iwe, lupwen ra mwinemwinela, ");
INSERT INTO chk_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaak a kapas ngeni Apraham, “Semei!” Nge i a aisini, “Met ka mochen, nei?” Iwe, Isaak a pälüeni, “Üa küna pwe a wor rech ekkei me mwüch, nge ifa ewe sip sipwe eäni asoren kek?” ");
INSERT INTO chk_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Nge Apraham a pälüeni, “Nei, Kot epwe püsin amolätä eman sip fän iten ach asoren kek.” Iwe, ra mwinemwinela ir me ruoman. ");
INSERT INTO chk_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Iwe, lupwen ra tori ewe leni Kot a aiti ngeni, Apraham a senätä eu rongen asor o isetä ewe mwüch won. Mürin a föti Isaak nöün we o akona won mwüchün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Mürin, Apraham a aitiela pöün o angei ewe naif pwe epwe niela nöün we. ");
INSERT INTO chk_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Nge nöün ewe Samol mi Lapalap chon läng a köri Apraham me lon läng, “Apraham! Apraham!” Iwe, a pälüeni, “Ngang iei.” ");
INSERT INTO chk_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Nge ewe chon läng a apasa, “Kosap afeiengaua ewe ät. Iei üa silei pwe ka niueiti Kot, pun kosap achika noum aleman seni.” ");
INSERT INTO chk_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Iwe, Apraham a nenela o küna eman ätemwänin sip a mwöch lein pötöwöl ren mächän. Iwe, Apraham a feila, a angei ewe ätemwänin sip o eäni asor won ewe rongen asoren kek siwilin nöün we. ");
INSERT INTO chk_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iei mine Apraham a aita ngeni ewe leni “Ewe Samol mi Lapalap epwe amolätä.” Nge tori ikenai aramas ra apasa, “Won chukun ewe Samol mi Lapalap epwe molotä.” ");
INSERT INTO chk_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Iwe, nöün ewe Samol mi Lapalap chon läng a körisefäli Apraham me lon läng ");
INSERT INTO chk_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","o üreni, “Ewe Samol mi Lapalap a apasa: Üa akapelüei. Pokiten ka föri ei pwe kosap achika noum aleman, ");
INSERT INTO chk_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ngang üpwe fokun afeiöchuk, üpwe pwal achomongala mwirimwirum kana pwe repwe usun chök chomongun ekewe fün läng, pwal usun pien aroset. Iwe, mwirimwirum kana repwe nemeni fanüen ekewe chon oputeer. ");
INSERT INTO chk_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Chon ekewe mwü won unusen fanüfan repwe feiöch me ren mwirimwirum kana, pun en ka aleasochis ngeni ai kapas.” ");
INSERT INTO chk_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Iwe, Apraham a liwiniti nöün kewe chon angang. Mürin, ra mwinemwinela Peersepa. Iwe, Apraham a nonom ikenan. ");
INSERT INTO chk_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mürin ekoch fansoun Apraham a rongorong pwe Milka a pwal nöünöü me won Nahor pwin we. ");
INSERT INTO chk_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Iwe, iten ewe mwänichi Us, nge iten pwin kewe Pus, Kemuel semen Aram, ");
INSERT INTO chk_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keset, Haso, Piltas, Jitlaf me Petuel. ");
INSERT INTO chk_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Iwe, Petuel semen Repeka. Ikkei ir ekewe walüman Milka a nöüni me won Nahor pwin Apraham we. ");
INSERT INTO chk_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nge wülüpwülüen Nahor itan Rehuma a nöüni Tepa, Kaham, Tahas me Maaka. ");
INSERT INTO chk_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Iwe, ükükün ierin manauen Sara ipükü rüe me fisu. ");
INSERT INTO chk_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Iwe, Sara a mäla lon Kiriat Arpa, a pwal iteni Hepron, lon ewe fanü Kanaan. Nge Apraham a tolong ren pwe epwe kechüeiti Sara o ngüngüres won. ");
INSERT INTO chk_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Mürin, Apraham a ütä seni ewe somä, a feila ren ekewe chon Hit o üreniir, ");
INSERT INTO chk_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngang eman wasöla mi siamü remi. Ouse mochen oupwe amömö ngeniei eu fanü pwe ai lenien peias, pun üa mochen peiaseni ai ei somä.” ");
INSERT INTO chk_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Nge ekewe chon Hit ra üreni Apraham, ");
INSERT INTO chk_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Äm samol, kopwe aüselingakem. En eman samol mi lap leim. Kopwe peiaseni om we somä lon eu äm lenien peias mi mürina seni meinisin. Ese wor eman leim epwe amwöchü senuk an lenien peias ika epetuk seni om kopwe peiaseni om we somä.” ");
INSERT INTO chk_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Mürin, Apraham a chapetiu mwen ekewe chon Hit ");
INSERT INTO chk_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","o üreniir, “Are iei letipemi pwe üpwe peiaseni ai we somä, ouse mochen oupwe tüngor ngeni Efron nöün Soar we fän itei, ");
INSERT INTO chk_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","pwe epwe amömö ngeniei an we pwangen achau lon Makpela, a nom lesopolan tanipin we. Epwe amömö ngeniei ren unusen liwinin fän mesemi pwe üpwe eäni lenien peias.” ");
INSERT INTO chk_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Nge Efron a püsin mot lein ekewe chon Hit lon ewe lenien mwicheich lon asamalapen an telinimw. Iwe, a üreni Apraham me fän mesen ekewe chon Hit meinisin, ");
INSERT INTO chk_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Apwi ai samol, kopwe aüselingaei. Üpwe fang ngonuk unusen ewe tanipi me ewe pwangen achau mi nom lon. Üpwe fang ngonuk ewe tanipi me fän mesen aramasei kei pwe kopwe peiaseni om we somä lon.” ");
INSERT INTO chk_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Mürin, Apraham a chapetiu mwen chon ewe fanü ");
INSERT INTO chk_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","o kapas ngeni Efron me fän meser meinisin, “Kose mochen kopwe pwal aüselingaei. Üpwe mönätiu liwinin ewe tanipi. Kose mochen kopwe angei liwinin pwe üpwe tongeni peiaseni ai we somä ikenan.” ");
INSERT INTO chk_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Iwe, Efron a üreni Apraham, ");
INSERT INTO chk_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ai samol, kopwe aüselingaei. Mön ei fanü engol paun silifer a chök möngin me rech. Kopwe chök peiasenala om we somä.” ");
INSERT INTO chk_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iwe, Apraham a tipeeu ngeni Efron. A kiloni ewe silifer Efron a fos usun me mwan fän mesen ekewe chon Hit, pwe epwe ngeni ükükün engol paun silifer. Iwe, Apraham a aea ewe kilo ekewe chon amömö lon ewe leni ra aea. ");
INSERT INTO chk_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Iei usun Apraham a eäni ewe tanipin Efron lon Makpela a nonom ötiuen Mamre, ewe tanipi me ewe pwangen achau mi nom lon, pwal ekewe irä meinisin mi nom won unusen ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Iwe, a anükünük me fän mesen ekewe chon Hit ra mwich lon asamalapen an we telinimw, pwe Apraham a eäni ewe tanipi. ");
INSERT INTO chk_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mürin, Apraham a peiaseni Sara pwülüan we lon ewe pwangen achau lon Makpela ötiuen Mamre a pwal iteni Hepron, lon ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Iei usun ewe tanipi me ewe pwangen achau mi nom lon, än ekewe chon Hit me lom, Apraham a eäni pwe an lenien peias. ");
INSERT INTO chk_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Iwe, Apraham a chinlapala, pun ierin a chomong. Nge ewe Samol mi Lapalap a afeiöchü Apraham lon meinisin mine a föri. ");
INSERT INTO chk_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Iwe, Apraham a üreni ewe meilapen nöün kewe chon angang mi nemeni an kewe pisek meinisin, “Kopwe sökalong poum fän aföi, ");
INSERT INTO chk_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","pun kopwe pwon fän akapel ngeni ewe Samol mi Lapalap, ewe Koten läng me fanüfan, pwe kosap tüngor pwülüen nei we me lein ekewe fin Kanaan, ewe ia üa nonom ie. ");
INSERT INTO chk_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nge kopwe feila lon fanüei ren aramasei kewe pwe kopwe kütta eman pwülüen Isaak nei we.” ");
INSERT INTO chk_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Iwe, ewe chon angang a üreni, “Eli ewe föpwül esap mochen etieito ikei. Ifa usun, üpwe uwala noum we ngeni ewe fanü ka feito seni?” ");
INSERT INTO chk_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Nge Apraham a pälüeni, “Kopwe afäli pwe kosap uwala nei we ikenan. ");
INSERT INTO chk_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ewe Samol mi Lapalap, ewe Koten läng mi emwenieiwu seni imwen semei pwal seni poputän fanüei, i a pwon ngeniei fän akapel pwe epwe ngeni mwirimwiri kana ei fanü. Kot epwe tinala nöün chon läng, pwe epwe akom mwom pwe kopwe angei pwülüen nei we seni ikenan. ");
INSERT INTO chk_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nge are ewe fefin esap mochen etuk, en kopwe ngas seni om pwon fän akapel ngeniei. Nge kosap fokun uwala nei we ikenan.” ");
INSERT INTO chk_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Iei mine ewe chon angang a sökalong pöün fän afön an samol Apraham o pwon fän akapel ngeni pwe epwe föri usun mine a apasa. ");
INSERT INTO chk_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Mürin, ewe chon angang a angei seni an samol engol kamel pwal chomong sokun lifang o feila lon ewe telinimwen Nahor mi nom efeng lon ewe fanü Mesopotamia. ");
INSERT INTO chk_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Iwe, lupwen ewe chon angang a tori ewe leni, a asösöü ekewe kamel lükün ewe telinimw ünükün eu chönüttu. Ei otun a tori lekuniol, lupwen fefin ra feito pwe repwe üfüf koluk. ");
INSERT INTO chk_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Iwe, a iotek, “Ai Samol mi Lapalap, än ai samol Apraham we Kot, kose mochen kopwe atufichiei ikenai o eäni kirikiröch ngeni ai we samol Apraham. ");
INSERT INTO chk_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Üa ütä ikei ünükün ei chönüttu, ia nöün chon ewe telinimw föpwül repwe feito ie o üfüf koluk. ");
INSERT INTO chk_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Iwe, amwo epwe iei usun: Are üpwe tüngor ngeni eman föpwül, ‘Kose mochen apäa om na rume pwe üpwe ünümi ekis koluk seni,’ nge i epwe üra, ‘Kopwe ün, nge üpwe pwal aünü noum kewe kamel,’ neminewe epwe ina i ewe ka filätä pwe pwülüen noum we chon angang Isaak. Ren ei ngang üpwe silei pwe ka eäni kirikiröch ngeni ai we samol.” ");
INSERT INTO chk_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Iwe, lupwen esamwo wes me iotek, Repeka a war o uwei eu an rumen koluk won afaran. Iwe, Repeka nöün Petuel we föpwül, nge Petuel nöün Milka pwülüen Nahor we, nge Nahor pwin Apraham. ");
INSERT INTO chk_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Iwe, ewe föpwül a fokun liöch, nge esamwo pwal pwüpwülü. Iwe, a tötiu lon ewe chönüttu o alölöü an we rume. Iwe, lupwen a tötä, ");
INSERT INTO chk_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ewe chon angang a mümütüto ren o üreni, “Kose mochen ngeniei ekkum ünümei koluk seni om na rume.” ");
INSERT INTO chk_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nge Repeka a pälüeni, “Kopwe ün ai samol.” Iwe, a müttir uwätiu an we rume me won afaran o aünü ewe mwän ewe koluk. ");
INSERT INTO chk_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iwe, lupwen Repeka a wes me aünü, a pwal üreni, “Ngang üpwe pwal üfi ünümen noum kewe kamel tori ar repwe möt.” ");
INSERT INTO chk_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mürin, a müttir ninalong ewe koluk lon ewe lenien ün o mümütsefälila ngeni ewe chönüttu pwe epwe üfi ünümen ekewe kamel koluk tori ra möt. ");
INSERT INTO chk_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Iwe, ewe mwän a chök fanafanala o newenewen ngeni, pun epwe pi ika ewe Samol mi Lapalap a afeiöchü an sai, ika esap afeiöchü. ");
INSERT INTO chk_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Iwe, lupwen ekewe kamel ra wes me ün, ewe mwän a angei efoch ring o ngeni ewe föpwül, nge choun ewe ring ina epwe eu lelimu aunus. Iwe, a pwal ngeni ruu lälä seni kolt fän iten pöün, nge choun eu lälä ina epwe rüanü aunus. ");
INSERT INTO chk_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Mürin a aisini, “Kose mochen üreniei ika en nöün iö? Ifa usun, epwe wor lenien äm asösö lon imwen semom?” ");
INSERT INTO chk_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nge Repeka a pälüeni, “Ngang nöün Petuel, nge semei nöün Milka pwülüen Nahor we.” ");
INSERT INTO chk_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Iwe, a pwal apasa, “Mi fokun wor lenien om asösö rem, mi pwal wor fetilipwas me enen noum kewe man.” ");
INSERT INTO chk_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mürin, ewe mwän a chapetiu lepwül o fel ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Iwe, a apasa, “Üpwe mwareiti ewe Samol mi Lapalap än ai samol Apraham we Kot, pwe esap amwöchü seni ai samol an tong me an allükülük. Pun ewe Samol mi Lapalap a wenewenen emweniei tori imwen aramasen semen ai we samol.” ");
INSERT INTO chk_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Iwe, ewe föpwül a mümütüla lon imwen inan we o apworausa ekewe mettoch meinisin. ");
INSERT INTO chk_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Nge a wor eman mongeen Repeka itan Lapan. Iwe, ätewe a mümütüla ren ewe mwän mi nom ünükün ewe chönüttu. ");
INSERT INTO chk_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Pun lupwen Lapan a küna ewe ring me ekewe lälä won pöün fefinan we, a pwal rong mine Repeka a apworausa usun alon ewe mwän ngeni, a feila ren nöün Apraham we chon angang mi ütä ren nöün kewe kamel ünükün ewe chönüttu. ");
INSERT INTO chk_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Iwe, Lapan a üreni, “Kopwe etiei, chon feiöch me ren ewe Samol mi Lapalap. Pwota ka chök ükü ikei? Üa fen amolätä leniom lon imwei, pwal lenien ekewe kamel.” ");
INSERT INTO chk_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Iei mine ewe mwän a tolong leimw. Nge Lapan a apichala ririn ekewe kamel, a pwal ngeniir fetilipwas me mongö. Iwe, a uwato koluk ren ewe mwän me chienan kewe pwe repwe talü pecher. ");
INSERT INTO chk_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nge lupwen a uwato mongö ren ewe mwän, ätewe a üreni, “Üsap fokun mongö tori üpwe wes me apworausa pworausei.” Mürin, Lapan a pälüeni, “Kopwe pworaus.” ");
INSERT INTO chk_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Iwe, a apasa, “Ngang nöün Apraham we chon angang. ");
INSERT INTO chk_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ewe Samol mi Lapalap a fokun afeiöchü ai samol pwe a wöümong. A ngeni chomong pwiin sip me kow, silifer me kolt, chon angang mwän me chon angang fefin, pwal kamel me aas kana. ");
INSERT INTO chk_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nge lupwen Sara pwülüen ai we samol a chinlap, a nöüni eman ät me won. Iwe, Apraham a ngeni nöün we wöün meinisin. ");
INSERT INTO chk_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ai samol a üreniei pwe üpwe pwon fän akapel ngeni. Iwe, a apasa, ‘Kosap tüngor pwülüen nei we me lein ekewe fin Kanaan, ewe ia üa nonom ie. ");
INSERT INTO chk_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Nge kopwe feila ren aramasen semei o kütta eman pwülüen nei we alüal.’ ");
INSERT INTO chk_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nge ngang üa üreni ai samol, ‘Eli ewe föpwül esap mochen etieito.’ ");
INSERT INTO chk_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Iwe, a üreniei, ‘Ewe Samol mi Lapalap üa aleasochis ngeni epwe tinato nöün chon läng pwe epwe etuk o afeiöchü om sai. Kopwe angei eman pwülüen nei we alüal seni aramasen semei. ");
INSERT INTO chk_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Iwe, lupwen kopwe tori aramasei kewe, kopwe ngas seni om we pwon fän akapel ngeniei. Nge are resap mochen mwüt ngonuk ewe föpwül, kopwe chök ngas seni om we pwon fän akapel ngeniei.’ ");
INSERT INTO chk_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Iwe, lupwen üa tori ünükün ewe chönüttu ikenai, üa iotek, ‘Ai Samol mi Lapalap, än ai samol Apraham we Kot, kose mochen afeiöchü ai ei sai. ");
INSERT INTO chk_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Üa ütä ikei ünükün ei chönüttu. Amwo epwe iei usun: Are eman föpwül a feito pwe epwe üfüf koluk, nge üpwe tüngor ngeni, “Kose mochen ngeniei ekkum ünümei koluk seni om na rume,” ");
INSERT INTO chk_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","nge i epwe üra, “Kopwe ün, nge üpwe pwal aünü noum kewe kamel,” neminewe epwe ina i ewe ka filätä pwe pwülüen nöün ai we samol.’ ");
INSERT INTO chk_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Iwe, mwen üsamwo wes le iotek lon lelukei, Repeka a feito o uwei an we rumen koluk won afaran. A tötiu lon ewe chönüttu pwe epwe üfüf koluk. Iwe, ngang üa tüngor ngeni, ‘Kose mochen kopwe aünüei.’ ");
INSERT INTO chk_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Iwe, a müttir isetiu an we rume seni won afaran o apasa, ‘Kopwe ün, nge üpwe pwal aünü noum kewe kamel.’ Iwe, üa ün, nge a pwal aünü ekewe kamel. ");
INSERT INTO chk_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mürin üa aisini, ‘En nöün iö?’ Iwe, a pälüeni, ‘Ngang nöün Petuel, nge semei nöün Milka pwülüen Nahor we.’ Mürin üa apachätä ewe ring won pwötün o anomu ekewe lälä won pöün. ");
INSERT INTO chk_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Iwe, üa chapetiu lepwül o fel ngeni ewe Samol mi Lapalap. Üa mwareiti ewe Samol mi Lapalap än ai samol Apraham we Kot, pun a emwenieito won efoch al mi wenechar, pwe üpwe tüngor eman föpwül seni aramasen ai samol pwe pwülüen nöün we alüal. ");
INSERT INTO chk_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Iei kopwe pwäri ngeniei are kopwe eäni kirikiröch me allükülük ngeni ai we samol. Nge ika kosap, kopwe pwal pwäri ngeniei pwe üpwe silei mine üpwe föri.” ");
INSERT INTO chk_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Mürin, Lapan me Petuel ra pälüeni, “Ei mettoch a pop seni ewe Samol mi Lapalap. Äm aisap tongeni filätä och me lükün ei. ");
INSERT INTO chk_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Iei i Repeka. Kopwe angei o uwala pwe epwe pwülüen nöün om we samol usun ewe Samol mi Lapalap a püsin apasa.” ");
INSERT INTO chk_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Iwe, lupwen nöün Apraham we chon angang a rong ar kewe kapas, a chapetiu lepwül o fel ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Mürin, ewe chon angang a uwawu fout seni silifer me kolt pwal mangaku o ngeni Repeka. Iwe, a pwal kisen ngeni mongeen Repeka we me inan pisek mi aüchea. ");
INSERT INTO chk_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Mürin, ewe chon angang me chienan kewe ra mongö o ün, ra pwal möür ikenan. Nge lupwen ra pwätä lesosor, ewe chon angang a apasa, “Ouse mochen oupwe mwüt ngeniei pwe üpwe liwinla ren ai samol.” ");
INSERT INTO chk_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nge mongeen Repeka me inan we ra üreni, “Kose mochen mwüt ngenikem ewe föpwül epwe mwo ekis nonom rem, eli lon ükükün engol rän. Mürin epwap feila.” ");
INSERT INTO chk_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Nge ewe chon angang a pälüeni, “Ouse mochen ousap amwöchüei, pun ewe Samol mi Lapalap a afeiöchü ai sai. Ouse mochen oupwe mwüt ngeniei pwe üpwe liwinla ren ai samol.” ");
INSERT INTO chk_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Iwe, ra üreni, “Aipwe köri Repeka o aisini met letipan.” ");
INSERT INTO chk_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Mürin ra körato o aisini, “Ifa usun, ka mochen eti ei mwän?” Nge Repeka a pälüeni, “Ewer, üpwe eti.” ");
INSERT INTO chk_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Iwe, ra tinala Repeka fefiner we me nöün chon angang fefin, pwal nöün Apraham chon angang me chienan kewe. ");
INSERT INTO chk_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ra afeiöchü Repeka o üreni, “En fefinem kopwe inelapen aramas mi chomong usun pien aroset. Mwirimwirum kana repwe nemeni ekewe telinimwen chon oputeer.” ");
INSERT INTO chk_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Mürin Repeka me nöün kewe chon angang fefin ra amolätä ar sai, ra tötä won ekewe kamel pwe repwe eti nöün Apraham we chon angang. Iei usun ir meinisin ra feila. ");
INSERT INTO chk_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Iwe, Isaak a liwinto seni ewe chönüttu Peer Lahairoi, pun a nonom lon ewe fanü Nekep. ");
INSERT INTO chk_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Iwe, Isaak a feila lemäl lekuniol pwe epwe iotek. Nge lupwen a chimwetä, a küna pwe eu mwichen kamel a feito. ");
INSERT INTO chk_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Iwe, pwal Repeka a chimwetä. Nge lupwen a küna Isaak, a tötiu seni wan we kamel ");
INSERT INTO chk_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","o aisini ewe chon angang, “Iö ewe mwän pekila a fetal lemäl pwe epwe sounikich?” Ewe chon angang a pälüeni, “Iei i ai we samol.” Iwe, Repeka a angei och mangaku o pwölüöla won mesan. ");
INSERT INTO chk_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nge ewe chon angang a apworausa ngeni Isaak usun meinisin mine a föri. ");
INSERT INTO chk_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Mürin, Isaak a emwenalong Repeka lon imwen Sara inan we. Iwe, a pwülüeni o echeni. Iei usun Isaak a chipila mürin än inan we mäla. ");
INSERT INTO chk_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Iwe, Apraham a pwüpwülüsefäl ngeni eman fefin itan Katura. ");
INSERT INTO chk_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Neminewe a nöüni me won Apraham Simran, Joksan, Metan, Mitian, Ispak me Sua. ");
INSERT INTO chk_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan semen Sepa me Tetan, nge ekewe mwirimwirin Tetan ekewe chon Asur, chon Letus me chon Leum. ");
INSERT INTO chk_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Iwe, a wor limman nöün Mitian mwän: Efah, Efer, Hanok, Apita me Eltaa. Ir meinisin mwirimwirin Katura. ");
INSERT INTO chk_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Iwe, Apraham a ngeni Isaak wöün meinisin. ");
INSERT INTO chk_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Nge lupwen a chüen manau, a ngeni nöün kewe mwän me won Hakar me Katura lifanger. Mürin a tinirela ngeni ewe fanüen ötiu pwe repwe toauela seni Isaak nöün we. ");
INSERT INTO chk_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Iwe, ierin manauen Apraham ipükü fik me limu. ");
INSERT INTO chk_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Mürin, Apraham a mäla lupwen a wesewesen chinlap. Iwe, a chufengen me an kewe lewo. ");
INSERT INTO chk_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nge nöün kewe Isaak me Ismael ra peiaseni lon ewe pwangen achau lon Makpela ötiuen Mamre, a nom lon ewe tanipin Efron nöün Sohar we, ewe re Hit. ");
INSERT INTO chk_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Iei ewe tanipi Apraham a möni seni ekewe chon Hit. Ikenan ra peiaseni Apraham ünükün Sara pwülüan we. ");
INSERT INTO chk_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Iwe, mürin än Apraham mäla Kot a afeiöchü Isaak nöün we. Nge Isaak a nonom arun ewe chönüttu Peer Lahairoi. ");
INSERT INTO chk_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iei uruwon mwirimwirin Ismael nöün Apraham we, Hakar ewe fin Isip a nöüni me won, lupwen Sara a nöüni chon angang. ");
INSERT INTO chk_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ikkei iten nöün Ismael kewe mwän lon tettelin ar uputiu: Nepaiot ewe mwänichi, Ketar, Atpeel, Mipsam, ");
INSERT INTO chk_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Tuma, Massa, ");
INSERT INTO chk_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hatat, Tema, Jetur, Hafis me Ketema. ");
INSERT INTO chk_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nöün Ismael kei, ir ekewe engol me ruoman samolun ar kewe ainang lon tettelin sopur me lenier kewe. ");
INSERT INTO chk_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Iwe, ierin manauen Ismael ipükü ilik me fisu. Mürin a mäla o chufengen me an kewe lewo. ");
INSERT INTO chk_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Iwe, ekewe mwirimwirin Ismael ra nonom lon ewe fanü seni Hawila tori Shur ötiuen Isip awenewenen Asiria. Nge ra nonom lon fanüer o tipepöchökül ngeni pwir kewe ekewe mwirimwirin Apraham. ");
INSERT INTO chk_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iei pworausen Isaak nöün Apraham we. ");
INSERT INTO chk_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Iwe, Isaak a ierini faik, lupwen a pwülüeni Repeka nöün Petuel we ewe re Siria seni Mesopotamia. Nge Repeka fefinen Lapan we. ");
INSERT INTO chk_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Iwe, Isaak a ikiotek fän äsengesin pwülüan we, pun a rit. Nge ewe Samol mi Lapalap a aüselinga an iotek, iei mine Repeka a pwopwo. ");
INSERT INTO chk_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nge a wor nöün lippwe, ra fiufengen lon lukan. Iwe, Repeka a apasa, “Met popun a fis ngeniei ei sokun lapalap?” Iwe, a feila pwe epwe aisini ewe Samol mi Lapalap usun. ");
INSERT INTO chk_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Nge ewe Samol mi Lapalap a üreni, “Ruu ainang ra nonom lon lukom, nge ruu mwichen aramas repwe uputiu senuk. Iwe, ekewe ruu mwich repwe aimwüfesen, nge eu leir epwe pöchökül mwen eu. Iwe, ewe mi lap epwe angang ngeni ewe mi kis.” ");
INSERT INTO chk_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Iwe, lupwen a tori fansoun an nöünöü, a wor nöün lippwe. ");
INSERT INTO chk_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Iwe, ewe aeumanün mi uputiu akom a parapar ünüchan, nge unusen inisin a ülöül usun ülen man. Iei mine ra aita ngeni Esau . ");
INSERT INTO chk_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Mürin pwin we a uputiu, nge pöün a amwöchü apilipilin pechen Esau. Iei mine ra aita ngeni Jakop . Iwe, Isaak a ierini wone, lupwen Repeka a nöünöü. ");
INSERT INTO chk_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Iwe, lupwen ekewe ät ra mämäritä, Esau a fokun foukus le likapich manmwacho, eman mi sani le nom lemäl. Nge Jakop eman mwän mi mosonoson, a chök nonom leimw. ");
INSERT INTO chk_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Iwe, Isaak a echeni Esau, pun a sani le ochoch liapan man. Nge Repeka a echeni Jakop. ");
INSERT INTO chk_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Iwe, lon eu rän, lupwen Jakop a amoota och mongö, Esau a liwinto seni lemäl, nge a fokun echik. ");
INSERT INTO chk_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iwe, Esau a üreni Jakop, “Kose mochen ngeniei och seni ewe mongö mi par pwe üpwe mongö, pun üa fokun echik.” Iei popun ra aita ngeni Etom . ");
INSERT INTO chk_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Nge Jakop a pälüeni, “Üpwe ngonuk ei mongö, are kopwe amömö ngeniei wisom wisen mwänichi.” ");
INSERT INTO chk_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Mürin, Esau a üreni, “Nengeni, üpwe le mäla. Met echök lomoten ai wiseni ewe wisen mwänichi.” ");
INSERT INTO chk_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Nge Jakop a pälüeni, “Kopwe akomwen akapel ngeniei pwe kopwe ngeniei wisom we.” Iei mine Esau a akapel ngeni o amömö ngeni wisan we wisen mwänichi. ");
INSERT INTO chk_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Mürin, Jakop a ngeni Esau pilawa me ewe mongö mi par. Iwe, Esau a mongö o ün, a pwal ütä o feila. Iei usun Esau a aücheangaua wisan we wisen mwänichi. ");
INSERT INTO chk_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Iwe, a fis lengita lon ewe fanü usun chök ewe a fis me lom lupwen fansoun Apraham. Nge Isaak a saila Kerar ren Apimelek ewe kingen Filistia. ");
INSERT INTO chk_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Iwe, ewe Samol mi Lapalap a pwä ngeni o apasa, “Kosap feila Isip, nge kopwe chök nomotiu lon ewe fanü ia ngang üpwe aiti ngonuk pwe kopwe nom ie. ");
INSERT INTO chk_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kopwe wasöla lon ei fanü, nge ngang üpwe etuk o afeiöchuk. Iwe, üpwe ngenikemi me mwirimwirum kana ei fanü meinisin, üpwe pwal apwonüetä mine üa pwon fän akapel ngeni Apraham semom we. ");
INSERT INTO chk_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ngang üpwe achomongala mwirimwirum kana pwe repwe usun chök chomongun fün läng, üpwe pwal ngeniir unusen ei fanü. Iwe, chon ekewe mwü meinisin won fanüfan repwe küna feiöch reöm, ");
INSERT INTO chk_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","pun Apraham a aleasochisi aloi o tümwünüöchü meinisin mine üa allük ngeni.” ");
INSERT INTO chk_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Iwe, Isaak a chök nonom Kerar. ");
INSERT INTO chk_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Nge lupwen ekewe re Kerar ra kapas ngeni usun pwülüan we, a üreniir, “Neminei fefinei,” pun a niuokus le apasa pwe i pwülüan. A chök ekieki pwe ekewe re Kerar repwe niela pokiten Repeka, pun a fokun liöch. ");
INSERT INTO chk_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nge lupwen a nonom ikenan fansoun langatam, Apimelek ewe kingen Filistia a nenewu seni lon asammwachon imwan o küna Isaak pwe a romi Repeka pwülüan we. ");
INSERT INTO chk_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Iwe, Apimelek a körato Isaak o üreni, “Neminan wesewesen pwülüom. Pwota ka apasa pwe i fefinom?” Nge Isaak a pälüeni, “Üa chök ekieki pwe üpwe ninniila pokitan.” ");
INSERT INTO chk_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Mürin, Apimelek a üra, “Pwota ka föri ngenikem ei sokun? A fokun tongeni fis pwe eman lein ekewe aramas epwe kon ren pwülüom we. Nge en kopwe awarato tipis wom.” ");
INSERT INTO chk_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Iei mine Apimelek a fönöü nöün aramas meinisin, “Are eman epwe atapa ei mwän ika pwülüan, epwe mäla.” ");
INSERT INTO chk_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Iwe, Isaak a tanipi lon ewe fanü, nge lon ena ier a kinikin fän ipükü lap seni mine a fotuki, pun ewe Samol mi Lapalap a afeiöchü Isaak. ");
INSERT INTO chk_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Iwe, a pisekisekila, a pwal fefeitä tori a fokun wöümong. ");
INSERT INTO chk_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","A wor chomong nöün pwiin sip me kow, pwal chomong nöün chon angang, iei mine ekewe chon Filistia ra lolowo ngeni. ");
INSERT INTO chk_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Iwe, ekewe chon Filistia ra ireela ekewe chönüttu meinisin nöün saman kewe chon angang ra tuw lupwen fansoun Apraham saman we. ");
INSERT INTO chk_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Mürin, Apimelek a üreni Isaak, “Kopwe sü senikem, pun ka pöchökül o wöümong senikem.” ");
INSERT INTO chk_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Iei mine Isaak a feila seni ikenan, a säla lemolun Kerar o nom ikenan. ");
INSERT INTO chk_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Iwe, Isaak a tusefäli ekewe chönüttu ra fen tu lupwen fansoun Apraham saman we, pun ekewe chon Filistia ra ireerela mürin än Apraham mäla. Iwe, a aita ngeniir ekewe it saman we a fen aita ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Nge lupwen nöün Isaak kewe chon angang ra tuw eu chönüttu lon ewe lemol o küna eu koluk mi puächetä, ");
INSERT INTO chk_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ekewe chon fofol man seni Kerar ra anini ngeni nöün Isaak kewe chon fofol man o apasa, “Ei koluk äm.” Iei mine Isaak a aita ngeni ewe chönüttu Esek , pun ra anini ngeni. ");
INSERT INTO chk_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Mürin, nöün Isaak kewe chon angang ra pwal tuw eu chönüttu, nge ra pwal fitikoko ngeni won. Iei mine Isaak a aita ngeni ewe chönüttu Sitna . ");
INSERT INTO chk_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Iwe, seni ikenan a feila ekis o tuw pwal eu chönüttu. Mürin resap chüen anini won. Iei mine a aita ngeni Rehopot , pun a apasa, “Iei ewe Samol mi Lapalap a wäsi leniach pwe sipwe chomongola won ei fanü.” ");
INSERT INTO chk_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Nge seni ikenan Isaak a feila Peersepa. ");
INSERT INTO chk_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Iwe, ewe Samol mi Lapalap a pwä ngeni lon ewe chök pwin o apasa, “Ngang än semom Apraham we Kot. Kosap niuokus, pun ngang üa etuk, üpwe pwal afeiöchuk o achomongala mwirimwirum kana pokiten ai pwon ngeni nei we chon angang Apraham.” ");
INSERT INTO chk_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Iei mine Isaak a senätä eu rongen asor ikenan o fel ngeni ewe Samol mi Lapalap. A pwal aüetä imwan imw mangaku, nge nöün kewe chon angang ra pwal tuw eu chönüttu. ");
INSERT INTO chk_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Mürin, Apimelek a feila seni Kerar pwe epwe churi Isaak, nge Ahussat nöün chon öüröür me Fikol ewe meilapen nöün mwichen sounfiu ra eti. ");
INSERT INTO chk_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Iwe, Isaak a aisiniir, “Pwota oua feito rei, nge oua fen oputaei o asüeila senikemi?” ");
INSERT INTO chk_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nge ir ra pälüeni, “Am aia küna pwe ewe Samol mi Lapalap a wesewesen etuk. Iei mine aia mochen pwe sipwe pwonfengen fän akapel o föri eu pwonen atipeeufengen lefilach. ");
INSERT INTO chk_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Iwe, kosap afeiengauakem usun chök äm aisap pwal afeiengauok. Aia chök kirikiröch ngonuk o tinukela fän kinamwe. Iei en ka feiöch me ren ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Iwe, Isaak a föri eu kametip mi watte, nge ra mongöfengen o ünfengen. ");
INSERT INTO chk_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nge lesosorusich ra pwätä o pwonfengen fän akapel. Mürin, Isaak a tinirela, nge ra imwüfesen fän kinamwe. ");
INSERT INTO chk_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Iwe, lon ewe chök ränin, nöün Isaak kewe chon angang ra feito ren, ra apworausa ngeni usun ewe chönüttu ra tuw o apasa, “Äm aia küna koluk.” ");
INSERT INTO chk_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Iwe, Isaak a aita ngeni ewe chönüttu Sepa . Iei mine ewe telinimw a iteni Peersepa tori ikenai. ");
INSERT INTO chk_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iwe, lupwen Esau a ierini faik, a pwülüeni ruoman fin Hit: Jutit nöün Peeri we, me Pasemat nöün Elon we. ");
INSERT INTO chk_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nge ra fokun ariaföüü Isaak me Repeka. ");
INSERT INTO chk_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Iwe, lupwen Isaak a chinlap, mesan ra toputop pwe esap chüen tongeni küna. Iwe, a köri Esau nöün we mwänichi o apasa, “Nei!” Nge Esau a pälüeni, “Ngang iei.” ");
INSERT INTO chk_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Iwe, Isaak a üreni, “Ka küna pwe üa chinlap, nge üsap silei inet üpwe mäla. ");
INSERT INTO chk_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Iei kopwe angei om kewe pisekin likapich o feila lemäl pwe kopwe liapeni eman uchäi manmwacho. ");
INSERT INTO chk_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Iwe, kopwe föri och mongö mi anö usun ai mwon o uwato rei pwe üpwe mongö. Pun üa mochen afeiöchuk mwen ai üpwe mäla.” ");
INSERT INTO chk_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Nge Repeka a rongorong mine Isaak a eäni kapas ngeni Esau nöün we. Iwe, lupwen Esau a feila lemäl pwe epwe liapeni eman manmwacho, ");
INSERT INTO chk_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Repeka a üreni Jakop nöün we, “Üa rong pwe semom a kapas ngeni pwiüm Esau, ");
INSERT INTO chk_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kopwe uwato eman manmwacho rei o föri och mongö mi anö fän itei pwe üpwe mongö. Pun üa mochen afeiöchuk me fän mesen ewe Samol mi Lapalap mwen ai üpwe mäla.’ ");
INSERT INTO chk_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Iei mine nei, kopwe aleasochisi mine üpwe ürenuk. ");
INSERT INTO chk_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kopwe feila o uwato ruoman apanen kuuch mi aümanau pwe üpwe föri och mongö mi anö fän iten semom we usun an mwon. ");
INSERT INTO chk_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mürin kopwe uwala ren semom pwe epwe mongö o afeiöchuk mwen an epwe mäla.” ");
INSERT INTO chk_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Nge Jakop a üreni Repeka inan we, “Ka silei pwe Esau pwii we eman mwän mi fokun ülöül, nge ngang üsap fokun ülöül. ");
INSERT INTO chk_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Eli semei epwe atapaei, nge epwe mefi pwe üa atupu. Iwe, epwe anümamauaei, nge esap afeiöchüei.” ");
INSERT INTO chk_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nge inan we a üreni, “Nei, ewe anümamau epwe nonom woi. Kopwe chök aleasochisi aloi, kopwe feila o uwato rei ekewe kuuch.” ");
INSERT INTO chk_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Iei mine Jakop a feila o uweereto ren inan we. Nge neminewe a föri eu mongö mi anö usun Isaak a mwon. ");
INSERT INTO chk_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Mürin, Repeka a angei üfen Esau mi fokun öch ra nom lon imwan o aüföüfa ngeni Jakop. ");
INSERT INTO chk_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nge silin ekewe kuuch a tükümi ngeni pöün me üan pwe epwe ülöül ren. ");
INSERT INTO chk_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Mürin, Repeka a ngeni Jakop ewe mongö mi anö me ewe pilawa a amolätä. ");
INSERT INTO chk_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iwe, Jakop a tolong lon äseengen saman we o üra, “Semei!” Nge Isaak a pälüeni, “Ngang iei, nei, nge en iö, Esau ika Jakop?” ");
INSERT INTO chk_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Iwe, Jakop a üreni saman we, “Ngang Esau noum we mwänichi. Üa föri mine ka akünöü ngeniei. Kose mochen kopwe pwätä o ochoch liapei ei man pwe kopwe afeiöchüei.” ");
INSERT INTO chk_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Nge Isaak a aisini nöün we, “Nei, ifa usun, met popun ka müttir le liap?” Nge a pälüeni, “Pun ewe Samol mi Lapalap om we Kot a aliapaei.” ");
INSERT INTO chk_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Mürin, Isaak a üreni Jakop, “Nei, kopwe kineto rei pwe üpwe atapok o silei, are en ka wesewesen nei we Esau are eman.” ");
INSERT INTO chk_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Iei mine Jakop a kan ngeni saman, nge ätewe a atapa o apasa, “Ngingimw a usun chök ngingin Jakop, nge poum ra usun chök pöün Esau.” ");
INSERT INTO chk_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Iwe, Isaak esap silleni Jakop, pun pöün ra ülöül usun pöün pwin Esau. Nge lupwen an epwe le afeiöchü, ");
INSERT INTO chk_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","a aisinisefäli, “Ifa usun, en wesewesen nei Esau?” Iwe, Jakop a pälüeni, “Ewer!” ");
INSERT INTO chk_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Mürin, Isaak a üreni, “Kopwe uwato rei mine ka liapeni pwe üpwe ochoch o afeiöchuk.” Iwe, Jakop a uwato ren, nge Isaak a mongö. A pwal uwato ünüman wain, nge a ün. ");
INSERT INTO chk_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mürin, Isaak a üreni Jakop, “Nei, kopwe kineto o mitiriei.” ");
INSERT INTO chk_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Iwe, lupwen Jakop a kineto o mitiri, saman we Isaak a tini pwoon üfan, a afeiöchü o apasa, “Pwoon nei a usun chök pwoon eu mälämäl ewe Samol mi Lapalap a afeiöchü. ");
INSERT INTO chk_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Iwe, Kot epwe fang ngonuk amurenipwin seni läng me pwülüöchün fanü pwe anom me ünümom repwe somwola. ");
INSERT INTO chk_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Chon ekewe mwü repwe angang ngonuk, nge chomong mwichen aramas repwe chapetiu me mwom. Kopwe samolun pwiüm kana, nge nöün inom repwe chapetiu me mwom. Epwe anümamau iö epwe anümamauok, nge epwe feiöch iö epwe afeiöchuk.” ");
INSERT INTO chk_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Iwe, wesin än Isaak afeiöchü Jakop, nge lupwen Jakop ekärän towu seni saman, Esau pwin we a war seni an likapich man. ");
INSERT INTO chk_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iwe, Esau a pwal föri och mongö mi anö o uwato ren saman. A üreni saman we, “Kose mochen kopwe pwätä o ochoch liapei ei man pwe kopwe afeiöchüei.” ");
INSERT INTO chk_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nge Isaak a aisini, “En iö?” Nge Esau a pälüeni, “Ngang Esau noum mwänichi.” ");
INSERT INTO chk_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Iwe, Isaak a fokun chechech o apasa, “Iö chök ewe chon likapich man a uwato liapan rei? Üa mongö meinisin mwen kosamwo feito, üa pwal afeiöchü. Ewer, epwe fokun feiöch.” ");
INSERT INTO chk_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Iwe, lupwen Esau a rong mine saman we a üreni, a fokun kechü lon an letipeta o tüngor ngeni saman, “Kose mochen kopwe pwal afeiöchüei.” ");
INSERT INTO chk_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nge Isaak a pälüeni, “Pwiüm we a feito fän tipachemsolä o angeala feiöchum we.” ");
INSERT INTO chk_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iwe, Esau a apasa, “A let pwe itan Jakop. Pun iei aruuen an atupuei. Iwe, a angeala wisei we wisen mwänichi, nge iei a angeala feiöchi we.” Mürin a aisini saman we, “Ifa usun, esap wor pwal eu feiöch ka iseis fän itei?” ");
INSERT INTO chk_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Nge Isaak a pälüeni Esau, “Nengeni, üa seikätä Jakop pwe epwe om samol, nge pwin kana meinisin repwe angang ngeni. Iwe, anan me ünüman repwe somwola. Met chök üpwe pwal föri ngonuk, nei?” ");
INSERT INTO chk_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iwe, Esau a tüngormau ngeni saman we, “Ifa usun, a chök wor eu om feiöch, semei? Kose mochen kopwe pwal afeiöchüei.” Nge Esau a leüömong le kechü. ");
INSERT INTO chk_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Mürin, Isaak saman we a pälüeni, “Kopwe imweimw toau seni pwülüöchün fanü, pwal seni amurenipwinin läng. ");
INSERT INTO chk_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kopwe manau ren noum ketilas, nge kopwe angang ngeni pwiüm. Iwe, lupwen om kopwe pöchökülela, epwap fis pwe kopwe towu seni fän nemeneman.” ");
INSERT INTO chk_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iwe, Esau a koum ngeni Jakop pokiten ewe feiöch saman we a afeiöchü ngeni. Iwe, Esau a apasa ngeni püsin i, “Ränin kechüeiti semei, lupwen epwe mäla, a arapoto. Mürin üpwap niela Jakop.” ");
INSERT INTO chk_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Nge eman a asile ngeni Repeka alon Esau. Iei mine a köri Jakop o üreni, “Esau pwiüm we a achipa lelukan ren an ekiekin niikala. ");
INSERT INTO chk_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Iei mine, nei, kopwe aleasochisi mine üpwe ürenuk. Kopwe ütä o sükaila ren mongeei we Lapan lon Haran. ");
INSERT INTO chk_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Iwe, kopwe nonom ren ekoch fansoun tori epwe kisikisila än pwiüm we koum ngonuk. ");
INSERT INTO chk_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Iwe, lupwen epwe wes an song ngonuk, epwe pwal manlükala mine ka föri ngeni, ngang üpwap titila reöm pwe kopwe liwinto seni ikenan. Pwota ämi me ruoman oupwe mä seniei lon eu chök rän?” ");
INSERT INTO chk_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Mürin, Repeka a üreni Isaak, “Ngang üsap chüen mochen manau pokiten pwülüen Esau kewe fin Hit. Are Jakop epwe pwal pwülüeni eman lein ekei fin Hit, epwe fen öch ai üpwe mäla.” ");
INSERT INTO chk_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Mürin, Isaak a köri Jakop, a afeiöchü o fönöü, “Kosap fokun pwüpwülü ngeni eman fin Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nge kopwe feila Mesopotamia lon imwen Petuel semen inom we. Iwe, kopwe tüngor seni ikenan eman föpwül nöün Lapan mongeen inom we pwe kopwe pwülüeni. ");
INSERT INTO chk_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Amwo ewe Kot mi Unusen Manaman epwe afeiöchuk, epwe pwal aupwuk o achomongokola pwe kopwe wiliti eu mwichen aramas mi chomong. ");
INSERT INTO chk_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Amwo epwe afeiöchuk me mwirimwirum kana usun an afeiöchü Apraham, pwe kopwe fanüeni ewe fanü ka wasöla lon, ewe fanü Kot a fen ngeni Apraham!” ");
INSERT INTO chk_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Iei usun Isaak a kapas ngeni Jakop o tinala Mesopotamia ren Lapan nöün Petuel ewe re Siria. Nge Lapan mongeen Repeka inen Jakop me Esau. ");
INSERT INTO chk_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iwe, Esau a silei pwe Isaak a afeiöchü Jakop o tinala Mesopotamia, pwe epwe tüngor eman pwülüan seni ikenan. A pwal rong pwe Isaak a fönöü Jakop lupwen an afeiöchü, pwe esap fokun pwüpwülü ngeni eman fin Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Iwe, a pwal küna pwe Jakop a aleasochis ngeni saman me inan o feila Mesopotamia. ");
INSERT INTO chk_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Iwe, lupwen Esau a mefi pwe Isaak saman we a oput ekewe fin Kanaan, ");
INSERT INTO chk_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","a feila ren Ismael nöün Apraham we o angei eman nöün föpwül itan Mahalat pwe pwülüan lükün pwülüan kewe. Iwe, Mahalat fefinen Nepajot. ");
INSERT INTO chk_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iwe, Jakop a feila seni Peersepa pwe epwe feila Haran. ");
INSERT INTO chk_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nge lupwen akkar a tup, a tori eu leni o pwini epwin ikenan. Iwe, Jakop a angei eföü fau me lon ewe leni pwe epwe ülleni, a kon o möür. ");
INSERT INTO chk_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Iwe, a tan pwe efoch latta a ititä seni won fanüfan, nge lesopun a tori läng. Iwe, nöün Kot kewe chon läng ra tötä o tötiu won. ");
INSERT INTO chk_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nge ewe Samol mi Lapalap a ü asen ewe latta o apasa, “Ngang ewe Samol mi Lapalap än semom Apraham me Isaak we Kot. Ewe fanü ka kon won üpwe ngonuk me mwirimwirum kana. ");
INSERT INTO chk_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Iwe, mwirimwirum repwe chomong usun chök pwülmoromoren fanü. Oupwe chonifetalei ewe fanü tori lotou me ötiu, pwal tori efeng me ör. Iwe, chon ekewe mwü meinisin won fanüfan repwe feiöch me reöm me mwirimwirum kana. ");
INSERT INTO chk_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ngang üpwe etuk o tümwünuk ekis meinisin ia kopwe feila ie, üpwe pwal aliwiniiketo won ei fanü, pun ngang üsap likituk tori üpwe apwönüetä meinisin mine üa pwon ngonuk.” ");
INSERT INTO chk_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Iwe, lupwen Jakop a nela seni an möür, a apasa, “Ellet, ewe Samol mi Lapalap a nonom lon ei leni, nge ngang üsap silei.” ");
INSERT INTO chk_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nge Jakop a niuokus o apasa, “A men eniuokus ei leni! Achiöü fokun ikei imwen Kot me asamen läng.” ");
INSERT INTO chk_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Iwe, Jakop a pwätä lesosorusich, a angei ewe fau a ülleni lon ewe pwin, a aüetä o ninätä lö won pwe eföü föün achem. ");
INSERT INTO chk_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Iwe, a aita ngeni ewe leni Petel . Nge iten ewe telinimw me lom Lus. ");
INSERT INTO chk_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Mürin, Jakop a pwon ngeni ewe Samol mi Lapalap, “Are kopwe etiei o tümwünüei won alen ai sai, are kopwe pwal ngeniei enei me üfei ");
INSERT INTO chk_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","pwe üpwe liwiniti imwen semei fän kinamwe, iwe, en kopwe ai Kot. ");
INSERT INTO chk_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Iwe, ewe fau üa aüetä pwe eföü föün achem epwe wiliti eu imwenfelin Kot, nge seni mettoch meinisin mine kopwe ngeniei üpwe ngonuk eu leengolun. ");
INSERT INTO chk_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iwe, Jakop a sopwela an sai tori ewe fanüen chon ötiu. ");
INSERT INTO chk_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nge lupwen a nenefetal, a küna eu chönüttu lon ewe mälämäl. Iwe, ülüpwi pwiin sip ra kon ünükün, pun iei ewe koluk chon ewe fanü ra aünü nöür kewe man seni. Iwe, ewe chönüttu a pinepin ngeni eföü fau mi fokun föümong. ");
INSERT INTO chk_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Iwe, lupwen ekewe pwiin man meinisin ra chufengen arun, ekewe chon mas ra akulu ewe fau seni leawen ewe chönüttu o aünü ekewe sip. Mürin ra pineesefäliela ewe chönüttu ngeni ewe fau. ");
INSERT INTO chk_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Iwe, Jakop a üreni ekewe chon mas, “Pwii kana, ia oua feito me ie?” Nge ra pälüeni, “Äm aia feito seni Haran.” ");
INSERT INTO chk_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Mürin, Jakop a aisiniir, “Ifa usun, oua silei Lapan nöün Nahor we?” Nge ra pälüeni, “Ewer, aia silei.” ");
INSERT INTO chk_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Iwe, Jakop a pwal aisiniir, “Ifa usun, a pöchökül?” Nge ra üreni, “Ewer, a pöchökül. Nengeni, iei i Rahel nöün we föpwül a feito me nöün sip kana.” ");
INSERT INTO chk_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Nge Jakop a üreniir, “A chüen leoloas, nge esamwo tori fansoun pwe ekewe man repwe mwuchifengen. Oupwe aünü ekewe sip o emwenirela pwe repwe mongö.” ");
INSERT INTO chk_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nge ra pälüeni, “Äm aisap tongeni föri ei are ekewe pwiin man resamwo chufengen meinisin. Mürin, aipwe akulu ewe fau seni leawen ewe chönüttu o aünü ekewe sip.” ");
INSERT INTO chk_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Iwe, lupwen Jakop me ekewe mwän ra chüen kapasfengen, Rahel a feito me nöün saman kewe sip, pun i a tümwünüür. ");
INSERT INTO chk_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Nge lupwen Jakop a küna Rahel nöün Lapan mongeen inan we, pwal nöün Lapan kewe sip, a akulu ewe fau seni leawen ewe chönüttu o aünü ekewe sip nöün mongeen inan we. ");
INSERT INTO chk_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Mürin, Jakop a mitiri Rahel o kechü fän leüömong. ");
INSERT INTO chk_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iwe, Jakop a pwäri ngeni Rahel pwe i a pwal semeni saman, pun i nöün Repeka. Iei mine Rahel a mümütüla o apworausa ngeni saman we. ");
INSERT INTO chk_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nge lupwen Lapan a rong usun pworausen Jakop nöün fefinan we, a mümütüla pwe epwe churi. Iwe, a romi, a pwal mitiri o emwenala lon imwan. Nge lupwen Jakop a pwäri ngeni Lapan usun pworausan meinisin, ");
INSERT INTO chk_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lapan a üreni, “Ellet, en chüi me fitukei.” Iwe, Jakop a nonom ren Lapan eu maram. ");
INSERT INTO chk_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Mürin, Lapan a üreni Jakop, “Ifa usun, epwe tufich om kopwe chök angang ngeniei pokiten en aramasei, nge esap wor liwinum? Apwi, kopwe chök pwäri ngeniei ükükün om mochen.” ");
INSERT INTO chk_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Nge a wor ruoman nöün Lapan föpwül, iten ewe finichi Lea, nge iten ewe mi kis fan Rahel. ");
INSERT INTO chk_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Iwe, Lea a mesengau, nge Rahel a meseöch o fokun liöch. ");
INSERT INTO chk_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakop a efich Rahel. Iei mine a apasa, “Üpwe angang ngonuk lon ükükün fisu ier fän iten noum föpwül Rahel ewe mi kis, pwe üpwe pwülüeni.” ");
INSERT INTO chk_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lapan a üreni, “A öch ai üpwe ngonuk mwen ai üpwe ngeni eman. Kopwe chök nonom rei.” ");
INSERT INTO chk_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Iei mine Jakop a angang lon ükükün fisu ier fän iten Rahel. Nge me ren Jakop ekewe fisu ier ra chök wewe ngeni ekoch rän pokiten an echeni ewe föpwül. ");
INSERT INTO chk_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Mürin, Jakop a üreni Lapan, “Kopwe ngeniei pwülüei pwe üpwe pwülüeni, pun a wes ierin ai angang.” ");
INSERT INTO chk_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Iei mine Lapan a körifengeni ekewe chon Haran meinisin o föri eu kametip mi watte. ");
INSERT INTO chk_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Nge lupwen a pwinila, a angei nöün we föpwül Lea o ngeni Jakop. Iwe, a pwülüeni. ");
INSERT INTO chk_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lapan a pwal angei nöün we chon angang Silpa o ngeni Lea pwe epwe chon angang ngeni. ");
INSERT INTO chk_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nge lesosor, Jakop a küna pwe a pwülüeni Lea. Iwe, a feila ren Lapan o üreni, “Pwota ka föri ei sokun ngeniei? Ifa usun, üsap angang ngonuk fän iten Rahel? Pwota ka atupuei?” ");
INSERT INTO chk_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Nge Lapan a pälüeni, “Esap pwüngün fanüem pwe ewe mi kis epwe akomwen pwüpwülü mwen ewe finichi. ");
INSERT INTO chk_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kopwe chök awesala ei wiken apwapwan apwüpwülü, mürin aipwe ngonuk pwal ewe mi kis. Nge liwinin om kopwe le pwülüeni Rahel, kopwe angang ngeniei pwal fisu ier.” ");
INSERT INTO chk_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Iwe, Jakop a tipeeu ngeni. Nge lupwen a wes ewe wik, Lapan a ngeni Jakop nöün we föpwül Rahel pwe pwülüan. ");
INSERT INTO chk_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lapan a angei nöün we chon angang Pila o ngeni Rahel pwe epwe chon angang ngeni. ");
INSERT INTO chk_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iwe, Jakop a pwal pwülüeni Rahel, nge a efich Rahel mwen Lea. Mürin, Jakop a angang ngeni Lapan pwal fisu ier. ");
INSERT INTO chk_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Iwe, lupwen ewe Samol mi Lapalap a küna pwe Lea a sochowun me ren Jakop, a anöünöü, nge Rahel a rit. ");
INSERT INTO chk_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Iwe, Lea a pwopwo, a nöüni eman ät o aita ngeni Rupen . Pun a apasa, “Ewe Samol mi Lapalap a küna ai riaföü, ellet iei pwülüei we epwe tongeei.” ");
INSERT INTO chk_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Mürin, Lea a pwopwosefäl o nöüni eman ät. Iwe, a apasa, “Pokiten ewe Samol mi Lapalap a rong pwe ngang üa sochowun, a pwal ngeniei ei ät.” Iei mine a aita ngeni Simeon . ");
INSERT INTO chk_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nge Lea a pwal pwopwosefäl o nöüni pwal eman ät. Iwe a apasa, “Iei otun pwülüei we epwe pach ngeniei, pun üa nöüni ngeni ülüman ät.” Iei mine a aita ngeni Lefi . ");
INSERT INTO chk_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Mürin, Lea a pwal pwopwosefäl o nöüni eman ät. Iwe, a apasa, “Iei üpwe mwareiti ewe Samol mi Lapalap.” Iei mine a aita ngeni Juta . Mürin a ükütiu le nöünöü. ");
INSERT INTO chk_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nge lupwen Rahel a küna pwe esap nöünöü me won Jakop, a lolowo ngeni pwin we. Nge a üreni Jakop, “Kopwe föri mine üpwe nöünöü ren. Pun are kosap, üpwe mäla.” ");
INSERT INTO chk_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Iwe, Jakop a song ngeni Rahel o apasa, “Ifa usun, ngang siwilin Kot mi amwöchü senuk om kopwe pwopwo?” ");
INSERT INTO chk_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Nge Rahel a apasa, “Iei i nei we chon angang Pila. Kopwe kon ren pwe epwe nöünöü me womw. Nge ngang üpwe nöüni nöün.” ");
INSERT INTO chk_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Iei mine Rahel a ngeni Jakop nöün we chon angang Pila pwe epwe pwülüeni. Iwe, Jakop a kon ren. ");
INSERT INTO chk_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Iwe, Pila a pwopwo o nöüni ngeni Jakop eman ät. ");
INSERT INTO chk_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Mürin, Rahel a apasa, “Kot a alletätä ai pwüng, a pwal rong ai iotek o ngeniei eman ät.” Iei mine a aita ngeni Tan . ");
INSERT INTO chk_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Pila nöün Rahel we chon angang a pwal pwopwo o nöüni ngeni Jakop aruomanün nöün ät. ");
INSERT INTO chk_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Mürin Rahel a apasa, “Fän pöchökül üa aülap ngeni pwii, nge üa akufu.” Iei mine a aita ngeni ewe ät Naftali . ");
INSERT INTO chk_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Iwe, lupwen Lea a küna pwe a ük le nöünöü, a angei nöün we chon angang Silpa o ngeni Jakop pwe epwe pwülüeni. ");
INSERT INTO chk_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Mürin nöün Lea we chon angang Silpa a nöüni eman ät me won Jakop. ");
INSERT INTO chk_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nge Lea a apasa, “Feiöch a toriei!” Iei mine a aita ngeni ewe ät Kat . ");
INSERT INTO chk_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Mürin, nöün Lea we chon angang Silpa a nöüni aruomanün nöün ät me won Jakop. ");
INSERT INTO chk_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nge Lea a üra, “Pwapwa a toriei. Iei ekewe fefin repwe apasa pwe ngang üa pwapwa.” Iei mine a aita ngeni ewe ät Aser . ");
INSERT INTO chk_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Iwe, lupwen fansoun resin wiich Rupen a feila lemäl, a küna ekoch föün apelin omung o uwato ren Lea inan we. Iwe, Rahel a üreni Lea, “Kose mochen kopwe ngeniei ekoch seni ekewe apelin omung noum we a kini.” ");
INSERT INTO chk_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nge Lea a aisini, “Ifa usun, ese naf om angei seniei pwülüei? Ka pwal mochen angei seniei ekewe apelin omung nei we a kini?” Iwe, Rahel a pälüeni, “Ika kopwe ngeniei ekewe apelin omung, Jakop epwe kon reöm lepwin ei.” ");
INSERT INTO chk_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nge lupwen Jakop a liwinto seni lemäl lekuniol, Lea a feila pwe epwe churi. Iwe, a üreni Jakop, “Kopwe fokun kon rei lepwin ei, pun üa mönuk seni Rahel ren kinien nei we apelin omung.” Iei mine Jakop a kon ren lon ewe pwin. ");
INSERT INTO chk_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Iwe, Kot a aüselinga Lea, pwe a pwopwo o nöüni ngeni Jakop alimmanün nöün ät. ");
INSERT INTO chk_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Mürin, Lea a apasa, “Kot a ngeniei liwini, pun üa mwüt ngeni pwülüei nei we chon angang.” Iwe, a aita ngeni ewe ät Isakar . ");
INSERT INTO chk_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Iwe, Lea a pwal pwopwosefäl o nöüni ngeni Jakop awonomanün nöün ät. ");
INSERT INTO chk_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Mürin, Lea a apasa, “Kot a lifang ngeniei eu lifang mi aüchea. Iei pwülüei epwe wesewesen nonom rei, pun üa nöüni ngeni wonoman ät.” Iwe, a aita ngeni ewe ät Sepulon . ");
INSERT INTO chk_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Iwe, Lea a pwal nöüni eman nengin o aita ngeni Tina. ");
INSERT INTO chk_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Mürin, Kot a chechemeni Rahel, a aüselinga an tüngor o anöünöü. ");
INSERT INTO chk_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Iei mine Rahel a pwopwo, a nöüni eman ät o apasa, “Kot a angei seniei ai itengau.” ");
INSERT INTO chk_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Iwe, a aita ngeni Josef o apasa, “Amwo ewe Samol mi Lapalap epwe apacha ngeniei pwal eman ät.” ");
INSERT INTO chk_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mürin än Rahel nöüni Josef, Jakop a üreni Lapan, “Kose mochen mwüt ngeniei pwe üpwe liwiniti poputän fanüei. ");
INSERT INTO chk_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kopwe ngeniei pwülüei me nei kewe, pun liwinin ai angang ngonuk. Kopwe mwüt ngeniei pwe üpwe feila, pun en ka silei ükükün ai angang ngonuk.” ");
INSERT INTO chk_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Nge Lapan a pälüeni, “Kose kan mochen kopwe aüselingaei. Üa fen silei seni ai pwee pwe ewe Samol mi Lapalap a afeiöchüei fän äsengesum. ");
INSERT INTO chk_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kopwe üreniei mine üpwe ngonuk pwe liwinin om angang, pun üpwe ngonuk.” ");
INSERT INTO chk_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iwe, Jakop a üreni, “En ka püsin silei usun ai angang ngonuk pwal usun ai tümwünüöchü noum kewe man. ");
INSERT INTO chk_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Pun mwen ai feito reöm noum kewe man ra chokisikis, nge iei ra fokun chomongola. Iwe, ewe Samol mi Lapalap a afeiöchuk ren ai angang meinisin üa föri. Nge inet ngang üpwe püsin tümwünü imwei?” ");
INSERT INTO chk_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Iwe, Lapan a aisini, “Met sokun liwin üpwe ngonuk?” Nge Jakop a pälüeni, “Kosap ngeniei och mettoch. Üpwe pwal tümwünü noum kewe pwiin man, are kopwe chök tipeeu ngeni mine üpwe ürenuk. ");
INSERT INTO chk_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ikenai üpwe fetal lein noum kewe pwiin man o aimwü iteiten sip me kuuch mi mwakelekel me tiketik, pwal iteiten apanen sip mi chochol. Ekei man ina chök liwinin ai angang. ");
INSERT INTO chk_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Iei ai wenechar epwe pwä me mürin, lupwen kopwe feito o nenengeni liwinin ai angang. Nge ika ka küna eman kuuch esap mwakelekel ika tiketik, ika eman apanen sip esap chochol, iwe, kopwe silei pwe üa soläniir.” ");
INSERT INTO chk_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Nge Lapan a üreni, “A öch, epwe usun chök mine ka apasa.” ");
INSERT INTO chk_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Iwe, lon ewe chök rän, Lapan a aimwü ekewe ätemwänin kuuch pwal ekewe liefefinin kuuch mi mwakelekel me tiketik, pwal meinisin mi ekis pwech me ekewe apanen sip mi chochol. Iwe, a anomuur fän tümwünüen nöün kewe mwän. ");
INSERT INTO chk_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Mürin, Lapan a atoauala ekewe pwiin man seni i me Jakop ükükün fetalin ülüngat rän. Nge Jakop a tümwünü ekewe lusun pwiin man nöün Lapan. ");
INSERT INTO chk_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mürin, Jakop a angei fönupun ekewe irä iter poplar, almont me plein, a atika ekis ünücher pwe epwe pwä mwakelekelin pwechepwecher. ");
INSERT INTO chk_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Iwe, a fotukätiu ekei fönupun irä lon lenien ünümen ekewe man koluk pwe repwe nom fän meser, lupwen ra etto pwe repwe ün. Iwe, lupwen a tori fansoun ar mochen etieti o ra etto pwe repwe ün, ");
INSERT INTO chk_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","a fis pwe ra pwüpwülüfengen o pwopwo mwen ekewe fönupun irä. Iwe, ra nöünöü mi mwakelekel me tiketik o chükelekel. ");
INSERT INTO chk_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Mürin, Jakop a aimwü ekewe apanen sip o awena mesen ekewe lusun man ngeni nöün Lapan kewe man mi mwakelekel me chochol. Iei usun a aimwüela nöün kewe pwiin man, pwe resap chufengen me nöün Lapan kewe pwiin man. ");
INSERT INTO chk_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Iwe, iteiten fansoun ekewe man mi kitinup a tori fansoun ar mochen etieti, Jakop a fotukätiu ekewe fönupun irä mwen mesen ekewe man lon lenien ünümer koluk pwe repwe pwüpwülüfengen lein ekewe fönupun irä. ");
INSERT INTO chk_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nge esap fotukätiu ekewe fönupun irä mwen ekewe man mi kichüchü. Iei mine a fis pwe ekewe man mi kichüchü nöün Lapan, nge ekewe mi kitinup nöün Jakop. ");
INSERT INTO chk_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Iei usun Jakop a fokun pisekisekila. A wor chomong nöün pwiin man, nöün chon angang fefin me nöün chon angang mwän, pwal nöün kamel me aas kana. ");
INSERT INTO chk_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Iwe, Jakop a rong pwe nöün Lapan kewe mwän ra apasa, “Jakop a angei meinisin mine än samach. A fokun wöümongola ren wöün samach.” ");
INSERT INTO chk_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakop a pwal küna pwe Lapan esap chüen wopwapwa ngeni usun me mwan. ");
INSERT INTO chk_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mürin, ewe Samol mi Lapalap a üreni Jakop, “Kopwe liwinla won fanüen semom kewe pwal ren aramasom, nge ngang üpwe etuk.” ");
INSERT INTO chk_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Iwe, Jakop a körato Rahel me Lea lon ewe mälämäl ia a tümwünü ie ekewe pwiin man. ");
INSERT INTO chk_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Iwe, a üreniir, “Üa küna pwe sememi we esap chüen wopwapwa ngeniei usun me mwan. Nge än semei we Kot a etiei. ");
INSERT INTO chk_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ämi oua silei pwe üa angangöch ngeni sememi we ren unusen ai tufich. ");
INSERT INTO chk_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Iwe, sememi we a atupuei o awilala liwinin ai angang fän engol, nge Kot esap mwüt ngeni pwe epwe ataala ai feiöch. ");
INSERT INTO chk_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Are a apasa, ‘Ekewe man mi tiketik repwe liwinin om angang,’ mürin ekewe man meinisin ra nöünöü mi tiketik. Nge are a apasa, ‘Ekewe man mi mwakelekel repwe liwinin om angang,’ mürin ekewe man meinisin ra nöünöü mi mwakelekel. ");
INSERT INTO chk_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Iei usun Kot a angei seni sememi we nöün kewe man o ngeniei. ");
INSERT INTO chk_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Iwe, lon fansoun ekewe man ra pwüpwülüfengen pwe repwe pwopwo, üa küna lon ai tan pwe ekewe ätemwänin kuuch ra pwülüeni ekewe man mi mwakelekel me tiketik me chükelekel. ");
INSERT INTO chk_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Iwe, nöün Kot we chon läng a köriei lon ai tan, ‘Jakop.’ Nge ngang üa apasa, ‘Ngang iei.’ ");
INSERT INTO chk_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Iwe, ewe chon läng a pwal apasa, ‘Kopwe nenengeni ekewe ätemwänin kuuch meinisin mi pwülüeni ekewe man ra mwakelekel me tiketik pwal chükelekel. Pun ngang üa küna meinisin mine Lapan a föri ngonuk. ");
INSERT INTO chk_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ngang ewe Kot mi pwä ngonuk me lon Petel, ewe ia ka epiti ewe fau ie o pwon ngeniei. Kopwe amolokotä o feila seni ei fanü pwe kopwe liwiniti poputän fanüom.’” ");
INSERT INTO chk_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Mürin Rahel me Lea ra üreni Jakop, “Esap chüen wor wisem me ren semem. ");
INSERT INTO chk_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","A föri ngenikem usun mine a föri ngeni chon ekis. A eänikem amömö, nge a püsin eitala ewe moni a angei, lupwen a eänikem amömö. ");
INSERT INTO chk_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Iwe, ekewe wöü meinisin Kot a fen angei seni semem we, äm me nöüm kewe aia eäni. Iei mine kopwe chök föri mine Kot a ürenuk.” ");
INSERT INTO chk_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Iwe, Jakop a ütä o ekietä nöün kewe me pwülüan kewe won ekewe kamel. ");
INSERT INTO chk_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A emwenala nöün kewe man meinisin a nöüni o uweela pisekin kewe meinisin a eäni lon Mesopotamia, pwe epwe feila ren Isaak saman we lon ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nge lupwen Lapan a feila pwe epwe fichi ülen nöün kewe sip, Rahel a soläni nöün saman we uluulun anün leimw. ");
INSERT INTO chk_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Iwe, Jakop a tükümi seni Lapan ewe re Siria, pwe esap asile ngeni an epwe feila seni. ");
INSERT INTO chk_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jakop a süla o uwala meinisin mine a eäni. A feila pekilan ewe chanpupu Oifrat o awena mesan ngeni ewe fanü mi chukuchukutä lon Kiliat. ");
INSERT INTO chk_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Iwe, ülüngat rän mürin eman a asile ngeni Lapan pwe Jakop a sü. ");
INSERT INTO chk_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Iwe, Lapan a angei aramasan pwe repwe eti le tapweri Jakop. Nge mürin fisu rän ra tori i me won ewe fanü mi chukuchukutä lon Kiliat. ");
INSERT INTO chk_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nge Kot a kapas ngeni Lapan ewe re Siria lon an tan lepwin o üreni, “Kopwe fokun föröchü pwe kosap kapas pöchökül ngeni Jakop.” ");
INSERT INTO chk_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Iwe, lupwen Lapan a tori Jakop, Jakop a fen aüetä imwan imw mangaku won ewe fanü mi chukuchukutä lon Kiliat. Pwal Lapan me aramasan ra aüetä imwer imw mangaku ikenan. ");
INSERT INTO chk_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Iwe, Lapan a üreni Jakop, “Pwota ka föri ei pwe ka tükümi seniei om süla o uwala nei kewe fefin usun chök chon oola lon maun? ");
INSERT INTO chk_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pwota ka süla lemonomon? Pwota kosap asile ngeniei pwe üpwe afeilakemi fän pwapwa me köl, ren tikin keseng me kitar? ");
INSERT INTO chk_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Pwota kosap mwüt ngeniei pwe üpwe mitiri nei kewe fefin me nöür kewe? Ewer, ka chök umwes lon mine ka föri. ");
INSERT INTO chk_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Iwe, ngang üa tongeni afeiengauok. Nge än semom we Kot a üreniei lepwin ewe, ‘Kopwe fokun föröchü pwe kosap kapas pöchökül ngeni Jakop.’ ");
INSERT INTO chk_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Iwe, iei ka fen feila, pun ka fokun positi chon leimwen semom. Nge pwota ka soläni nei kewe uluulun anün leimw?” ");
INSERT INTO chk_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Nge Jakop a üreni Lapan, “Üa niuokus, pun üa ekieki pwe kopwe angei seniei noum kewe fefin fän pöchökül. ");
INSERT INTO chk_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nge ewe eman kopwe küna me ren noum kewe uluulun anün leimw, epwe mäla. Iei kopwe kütta mwen mesen aramasom kei o angei mine om me lein ai kewe pisek.” Nge Jakop esap silei pwe Rahel a soläni ekewe uluulun anü. ");
INSERT INTO chk_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Iwe, Lapan a tolong lon imwen Jakop, lon imwen Lea, pwal lon imwen ekewe ruoman chon angang fefin, nge esap küna nöün kewe uluulun anü. Mürin, a towu seni imwen Lea o tolong lon imwen Rahel. ");
INSERT INTO chk_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Nge Rahel a angei ekewe uluulun anü, a aopala fän an lenien mot o mottiu won. Iei ewe lenien mot ra aea won nöür kewe kamel. Iwe, Lapan a kütta ekewe uluulun anü lon unusen ewe imw, nge esap küneer. ");
INSERT INTO chk_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Iwe, Rahel a üreni saman we, “Semei, kose mochen kosap song ngeniei pwe üsap ütä mwom, pun üa samaun fefin.” Iei usun Lapan a kütta nöün kewe uluulun anün leimw ekis meinisin, nge esap küneer. ");
INSERT INTO chk_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Mürin, Jakop a song o anini ngeni Lapan. Iwe, a kapas ngeni, “Met ai pwüngingau? Are met ai tipis pwe ka tapweriei fän choun om song? ");
INSERT INTO chk_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Iei ka kütta lein ai pisek meinisin. Nge met sokun pisekin lon imwomw ka küna? Kopwe iseis ikei mwen aramasei me aramasom pwe repwe filätä iö leich a pwüng. ");
INSERT INTO chk_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Rüe ier üa nom reöm. Noum kewe liefefinin sip me kuuch esap mwetela nöür. Üsap fokun ochoch eman noum ätemwänin kuuch seni noum kewe pwiin man. ");
INSERT INTO chk_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Iwe, mine manmwacho ra niela, ngang üsap uwato reöm, pwe üa püsin liwini. En ka angei seniei liwinin ekewe man eman a soläniir lerän ika lepwin. ");
INSERT INTO chk_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Iei usun mine a fis ngeniei: Lerän üa riaföü ren pwichikaren akkar, nge lepwin üa föü pwe üsap tongeni möür. ");
INSERT INTO chk_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Lon ükükün rüe ier üa nonom reöm. Üa angang ngonuk lon ükükün engol me rüanü ier fän iten noum kewe ruoman fefin, pwal wonu ier fän iten noum kewe pwiin man. Nge en ka awilala liwinin ai angang fän engol. ");
INSERT INTO chk_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Are än semei we Kot esap nonom rei, än Apraham we Kot, ewe Isaak a niueiti, ellet iei en kopwe tinieila fän ai asöülapö. Nge Kot a küna ai riaföü me angangen pei o apwünguk lepwin ewe.” ");
INSERT INTO chk_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Mürin, Lapan a pälüeni Jakop, “Ekei fefin nei, ekei semirit nei, ekei pwiin man nei. Meinisin mine ka küna ai. Nge met ngang üpwe tongeni föri ikenai ngeni nei kei fefin me nöür kei semirit? ");
INSERT INTO chk_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Iwe, kopwe etto pwe sipwe föri eu pwonen atipeeufengen. Ousipwe achukuchukätä fau pwe eu pisekin pwärätä lefilen en me ngang.” ");
INSERT INTO chk_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Iei mine Jakop a angei eföü fau o aüetä pwe epwe eföü föün achem. ");
INSERT INTO chk_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","A pwal üreni aramasan kewe pwe repwe ionifengeni fau.” Iwe, ra achukuchukätä fau o mongö arun. ");
INSERT INTO chk_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Iwe, Lapan a aita ngeni ewe leni Jekar Sahatuta , nge Jakop a aita ngeni Kaleet . ");
INSERT INTO chk_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Mürin, Lapan a üreni Jakop, “Ei ioien fau epwe eu pisekin pwärätä lefilen en me ngang.” Iei popun ewe leni a iteni Kaleet, ");
INSERT INTO chk_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","nge ewe föün achem a iteni Mispa , pun Lapan a apasa, “Ewe Samol mi Lapalap epwe mamasa lefilen en me ngang, lupwen sia toaufesen. ");
INSERT INTO chk_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Are kopwe ariaföüü nei kewe fefin, ika kopwe pwal angei ekoch pwülüom lükün nei kewe fefin, kopwe chök chechemeni pwe Kot epwe chon pwärätä lefilen en me ngang, inamwo ika esap wor eman a nom rech.” ");
INSERT INTO chk_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Mürin, Lapan a pwal üreni Jakop, “Nengeni, ei ioien fau me ei föün achem üa anomu lefilen en me ngang. ");
INSERT INTO chk_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ei ioien fau me ei föün achem eu pisekin pwärätä. Üsap fokun feila reöm pekilan ei ioien fau pwe üpwe afeiengauok. Nge en kosap pwal feito rei pekiton ei ioien fau me ewe föün achem pwe kopwe afeiengauaei. ");
INSERT INTO chk_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Än Apraham me Nahor we Kot, än semer we Kot epwe souapwüng lefilach.” Mürin, Jakop a pwon fän akapel fän iten ewe chök Kot Isaak a niueiti, pwe epwe apwönüetä ewe pwon. ");
INSERT INTO chk_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Iwe, Jakop a niela eman man o eäni asor ngeni Kot won ewe chuk. A pwal köri aramasan kewe pwe repwe eti le mongö. Mürin ar mongöfengen ra möür lon ewe pwin won ewe chuk. ");
INSERT INTO chk_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nge lesosorusich Lapan a pwätä, a mitiri nöün kewe fefin me nöür kewe o afeiöchüür. Mürin a feila seniir o liwiniti lenian. ");
INSERT INTO chk_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Iwe, lupwen Jakop a saila, nöün Kot kewe chon läng ra churi. ");
INSERT INTO chk_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nge lupwen Jakop a küneer, a apasa, “Ikei nöün Kot kewe mwichen sounfiu.” Iei mine a aita ngeni ewe leni Mahanaim . ");
INSERT INTO chk_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Iwe, Jakop a tinala ekoch chon künö pwe repwe akomwola mwan o feila ren Esau pwin we mi nom Seir lon ewe fanü Etom. ");
INSERT INTO chk_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Iwe, a öüröüreer o üreniir pwe iei usun mine repwe apasa ngeni Esau, “Ngang noum chon angang Jakop, üa wasöla ren Lapan o nom ren tori ikenai. ");
INSERT INTO chk_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A wor nei kow, aas, sip me kuuch, pwal nei chon angang mwän me chon angang fefin. Iei üa tinala nei kei chon künö pwe repwe asile ngonuk, ai samol, usun pwe kopwe ümöümöch ngeniei.” ");
INSERT INTO chk_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Iwe, ekewe chon künö ra liwinto ren Jakop o apworausa ngeni, “Aia churi Esau pwiüm we. Iwe, i epwe feito pwe epwe churuk, nge föpükü mwän ra eti.” ");
INSERT INTO chk_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nge lupwen Jakop a rong ei pworaus, a fokun niuokus o riaföü. Iwe, a aimwüfeseni lon ruu mwich an we mwichen aramas mi nom ren, pwal nöün kewe mwichen sip me kuuch, kow me kamel kana. ");
INSERT INTO chk_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Pun a ekieki, “Are Esau epwe war o niela eu mwich, ewe pwal eu mwich epwe tongeni süla.” ");
INSERT INTO chk_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Mürin, Jakop a iotek, “Ai Samol mi Lapalap, en än semei Apraham me Isaak we Kot, en ka üreniei, ‘Kopwe liwiniti fanüom pwal aramasom, nge ngang üpwe atoto feiöch womw.’ ");
INSERT INTO chk_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Üa kon aücheangau ngeni om kirikiröch me om tipelükülük meinisin ka eäni ngeniei noum chon angang. Pun ei chök wok a nom rei, lupwen üa pwerela pekilan ei chanpupu Jortan, nge ikenai üa wiliti ruu mwich. ");
INSERT INTO chk_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kose mochen kopwe amanauaei seni lepöün pwii, fokun seni lepöün Esau. Pun üa niuokus pwe epwe feito o nikeemila meinisin, pwal ekewe in me ekewe semirit. ");
INSERT INTO chk_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nge en ka pwon ngeniei pwe kopwe atoto feiöch woi o achomonga mwirimwiri usun pien aroset pwe esap wor eman a tongeni aleaniir pokiten chomonguur.” ");
INSERT INTO chk_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Iwe, Jakop a asösö ikenan lon ewe pwinin. Nge lesosor a angei seni nöün kewe pwiin man mine epwe lifang ngeni Esau pwin we: ");
INSERT INTO chk_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","rüepükü liefefinin kuuch me rüe ätemwänin kuuch, rüepükü liefefinin sip me rüe ätemwänin sip, ");
INSERT INTO chk_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ilik liefefinin kamel me apaner, faik liefefinin kow me engol ätemwänin kow, rüe liefefinin aas me engol ätemwänin aas. ");
INSERT INTO chk_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ekei man meinisin Jakop a inetiir lon eu me eu mwich o anomuur fän tümwünüen nöün kewe chon angang. Iwe, a üreniir, “Oupwe akom mwei, nge eu mwich epwe ekis toau seni pwal eu.” ");
INSERT INTO chk_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Iwe, a öüröüra ewe aemanün nöün chon angang, “Are Esau pwii we epwe churuk o aisinuk, ‘Ifa usun, en nöün iö? Ia kopwe feila ie? Nge nöün iö ekewe man ra akom mwom?’, ");
INSERT INTO chk_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","mürin kopwe pälüeni, ‘Ir meinisin nöün noum we chon angang Jakop. A tinireto pwe an lifang ngeni an samol Esau. Nge Jakop a pwal tapweto mürim.’” ");
INSERT INTO chk_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Iwe, a pwal öüröüra ewe aruomanün me ewe aülümanün nöün chon angang tori chokewe meinisin mi tümwünü ekewe pwiin man, “Ikkei chök ekewe kapas oupwe üreni Esau, lupwen oupwe churi. ");
INSERT INTO chk_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Nge oupwe pwal üreni, ‘Noum chon angang Jakop a tapweto mürim.’” Pun Jakop a ekieki, “Eli ewe lifang a akom mwei epwe chäri pwii. Mürin, lupwen üpwe küna mesan, eli epwe chä ngeniei.” ");
INSERT INTO chk_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Iei usun ekewe lifang ra akomwola mwan, nge Jakop a chök nom ren an we mwich lon ewe pwinin. ");
INSERT INTO chk_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Iwe, lon ewe chök pwinin Jakop a pwätä o angei pwülüan kewe ruoman me nöün kewe ruoman chon angang fefin pwal nöün kewe engol me eman ät. Iwe, ra feila pekilan ewe chanpupu Jappok. ");
INSERT INTO chk_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mürin an tinirela pekilan ewe chanpupu, a pwal tinala pisekin meinisin. ");
INSERT INTO chk_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nge Jakop a chök alemanüla. Mürin, eman mwän a feito o aülap ngeni tori a tö mallen rän. ");
INSERT INTO chk_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nge lupwen ewe mwän a mefi pwe esap tongeni akufu Jakop, a pisiri wilan pwe a rü chün, lupwen an aülap ngeni. ");
INSERT INTO chk_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Mürin, ewe mwän a apasa, “Kose mochen likitieila, pun a tö mallen rän.” Nge Jakop a pälüeni, “Üsap fokun likitukela are kosap afeiöchüei.” ");
INSERT INTO chk_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nge ewe mwän a aisini, “Ifa itom?” Iwe, a pälüeni, “Itei Jakop.” ");
INSERT INTO chk_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nge ewe mwän a üreni, “Kosap chüen iteni Jakop, pwe kopwe iteni Israel . Pun ka fiu ngeni Kot me aramas, nge en ka win.” ");
INSERT INTO chk_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Mürin, Jakop a tüngor ngeni ewe mwän, “Kose mochen kopwe asile ngeniei itom.” Nge i a pälüeni, “Pwota ka ais itei?” Iwe, a afeiöchü Jakop ikenan. ");
INSERT INTO chk_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Iwe, Jakop a apasa, “Üa küna won mesen Kot, nge üa chüen manau.” Iei mine a aita ngeni ewe leni Peniel . ");
INSERT INTO chk_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Iwe, akkar a tötä, lupwen Jakop a feila seni Peniel, nge a likoi ren wilan. ");
INSERT INTO chk_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Iei popun chon Israel resap ochoch ewe fituk a nom won chün wilan man tori ikenai pokiten ewe mwän a pisiri won wilan Jakop. ");
INSERT INTO chk_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Iwe, Jakop a netä o küna pwe Esau a war me föpükü mwän. Iei popun Jakop a aimwüfeseni nöün kewe o ngeni Lea me Rahel nöür, a pwal ngeni ekewe ruoman chon angang fefin nöür. ");
INSERT INTO chk_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Iwe, a akomwa ekewe ruoman chon angang fefin me nöür kewe, mürin Lea me nöün kewe, nge Rahel me Josef ra kükümwir. ");
INSERT INTO chk_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nge Jakop a akom mwer meinisin, a chapetiu lepwül fän fisu tori a kan ngeni pwin. ");
INSERT INTO chk_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Nge Esau a mümütüto ren, a romi o mitiri. Iwe, ra kechüfengen me ruoman. ");
INSERT INTO chk_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nge lupwen Esau a netä, a küna ekewe fefin me nöür kewe o aisini Jakop, “Nöün iö kana mi nom reöm?” Jakop a pälüeni, “Ai samol, ir meinisin nei, Kot a ngeniei lon an ümöümöch.” ");
INSERT INTO chk_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mürin ekewe chon angang fefin me nöür kewe ra arapoto o chapetiu mwen Esau. ");
INSERT INTO chk_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Pwal usun chök Lea me nöün kewe ra arapeto o chapetiu me mwan, nge lesopolan Rahel me Josef ra arapeto o chapetiu me mwan. ");
INSERT INTO chk_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iwe, Esau a aisini, “Met ka mochen ren ekewe mwich meinisin üa churiir?” Nge Jakop a pälüeni, “Üa mochen küna ümöümöch me reöm, ai samol.” ");
INSERT INTO chk_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Iwe, Esau a üreni, “Pwii, üa menemenöch ren mine üa eäni. Kopwe chök amwöchü mine ka eäni.” ");
INSERT INTO chk_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Nge Jakop a üreni, “Apwi, are üa küna ümöümöch me reöm, kose mochen kopwe etiwa ai we lifang ngonuk. Ellet, lupwen üa küna mesom usun chök nge üa küna mesen Kot, pun ka etiwaei lon om ümöümöch. ");
INSERT INTO chk_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kose mochen kopwe angei ai ei lifang üa uwato reöm. Pun Kot a fokun kisäsew ngeniei, iei popun a fokun naf ngeniei mine üa eäni.” Iwe, Jakop a pesei Esau tori a angei ekewe lifang. ");
INSERT INTO chk_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Mürin Esau a apasa, “Ousipwe popuetä ach sai, nge ngang üpwe wisen akom mwemi.” ");
INSERT INTO chk_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Nge Jakop a üreni, “Ai samol, ka silei pwe ekewe semirit ra apwangapwang, nge üa pwal wisen tümwünü ekewe pwiin sip me kow ra nöünöü. Iwe, are ekewe chon angang repwe amüttirirela lon eu chök rän, repwe fokun mäla meinisin. ");
INSERT INTO chk_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kose mochen kopwe akomwola mwei, nge ngang üpwe mangeni mangen ekewe man me semirit, tori üpwe churuk lon Etom.” ");
INSERT INTO chk_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iwe, Esau a apasa, “Kose mochen üpwe likiti ngonuk ekoch kei mwän mi nom rei.” Nge Jakop a üreni, “Ina chök i. Amwo üpwe chök küna ümöümöch me reöm, ai samol.” ");
INSERT INTO chk_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Iei mine Esau a liwiniti Etom lon ewe chök ränin. ");
INSERT INTO chk_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nge Jakop a saila Sukot. Iwe, a aüetä imwan o förätä lenien nöün kewe man. Iei mine ewe leni a iteni Sukot . ");
INSERT INTO chk_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Iwe, lupwen Jakop a liwinto seni Mesopotamia, a tori ewe telinimw Sikem lon ewe fanü Kanaan fän kinamwe. Iwe, a aüetä imwan imw mangaku lükün ewe telinimw. ");
INSERT INTO chk_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Pun Jakop a möni ewe fanü seni nöün Hamor kewe mwän, semen Sikem we, won ipükü föün moni silifer. ");
INSERT INTO chk_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Iwe, ikenan Jakop a senätä eu rongen asor o aita ngeni El Elohe Israel . ");
INSERT INTO chk_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Iwe, lon eu rän Tina nöün Lea me Jakop we föpwül a feila kukulou ren fin ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nge lupwen Sikem nöün Hamar we ewe re Hiw, i pwal samolun ewe fanü, a küna Tina, a achomanauei o kon ren. ");
INSERT INTO chk_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Iwe, leluken Sikem a pach ngeni Tina nöün Jakop we föpwül, pwe a fokun tongei o fos pwetete ngeni. ");
INSERT INTO chk_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Iei mine Sikem a kapas ngeni Hamor saman we, “Kopwe tüngor ei föpwül pwe üpwe pwülüeni.” ");
INSERT INTO chk_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Iwe, Jakop a rong pwe Sikem a achomanauei nöün we föpwül Tina. Nge lon ei otun, nöün Jakop kewe mwän ra tümwünü nöür kewe man lemäl. Iei mine Jakop a chök fanafanala tori ar repwe liwinto. ");
INSERT INTO chk_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Mürin, Hamor semen Sikem a feila ren Jakop pwe epwe kapas ngeni. ");
INSERT INTO chk_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Iwe, lupwen nöün Jakop kewe mwän ra rong ei pworaus, ra müttir liwinto me lemäl. Ra chou o fokun song, pun Sikem a föri och föför mi äsäw lon Israel ren an konfengen me nöün Jakop we föpwül. Pun a ngau ei sokun föför än eman epwe föri. ");
INSERT INTO chk_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Iwe, Hamor a kapas ngeni Jakop, “Leluken nei we mwän Sikem a mochen riri ngeni noum we föpwül. Üa tüngor ngonuk, kose mochen kopwe mwüt ngeni pwe epwe pwülüeni. ");
INSERT INTO chk_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ousipwe pwüpwülüfengen. Oupwe ngenikem nöümi föpwül, nge ämi oupwe angei nöüm föpwül pwe oupwe pwülüeni. ");
INSERT INTO chk_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Oupwe nonom rem, nge ewe fanü epwe suk ngenikemi. Oupwe nonom lon, oupwe pwal föri ämi angang o kamö fanüemi.” ");
INSERT INTO chk_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Mürin, Sikem a üreni Jakop me mongeen Tina kewe, “Amwo üpwe küna ümöümöch me remi, nge üpwe ngenikemi meinisin mine oupwe tüngor seniei. ");
INSERT INTO chk_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Oupwe chök üreniei ükükün mine oua mochen pwe üpwe kiseni ngenikemi. Iwe, üpwe ngenikemi meinisin mine oupwe tüngor seniei, nge oupwe chök ngeniei ewe föpwül pwe üpwe pwülüeni.” ");
INSERT INTO chk_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Iwe, nöün Jakop kewe mwän ra atupu Sikem me Hamor saman we ren ar kapas, pokiten än Sikem aitengaua Tina fefiner we. ");
INSERT INTO chk_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Iwe, ra üreni, “Äm aisap tongeni mwüt ngeni eman esap sirkomsais pwe epwe pwülüeni fefinem, pun aipwe itengau ren. ");
INSERT INTO chk_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nge äm aipwe chök tipeeu ngeni, ika ämi mwän meinisin oupwe sirkomsais usun chök äm. ");
INSERT INTO chk_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mürin äm aipwe ngenikemi nöüm kewe föpwül, äm aipwe pwal angei nöümi kewe föpwül. Iwe, äm aipwe nonom remi pwe sipwe eu chök mwichen aramas. ");
INSERT INTO chk_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nge are ousap mochen aüselingakem o sirkomsais, äm aipwe angei fefinem o feila.” ");
INSERT INTO chk_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Iwe, Hamor me Sikem nöün we mwän ra efich ar kewe kapas. ");
INSERT INTO chk_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Iwe, ewe alüal esap mang le föri mine ra üra, pun a fokun tongei nöün Jakop we föpwül. Iwe, Sikem ewe mi lap lon an famili. ");
INSERT INTO chk_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Iei mine Hamor me Sikem nöün we ra feila lon ewe lenien amwicheich le asamalapen telinimwer we o üreni mwänin ewe telinimw, ");
INSERT INTO chk_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ekei mwän ra mochen chiechi ngenikich. Ousipwe mwüt ngeniir pwe repwe nonom rech won fanüach, pwe repwe föri ar angang, pun ewe fanü a pwal naf ngeniir. Iwe, ousipwe pwülüeni nöür kewe föpwül, nge kich sipwe ngeniir nöüch kewe föpwül pwe repwe pwülüeniir. ");
INSERT INTO chk_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nge ir ra chök tipeeu ngeni ar repwe nonom rech pwe sipwe eu chök mwichen aramas, ika iteiten mwän leich repwe sirkomsais usun chök ir ra sirkomsais. ");
INSERT INTO chk_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ifa usun, sisap nöüni nöür man, sisap pwal pisekini pisekir meinisin? Sipwe chök tipeeu ngeniir pwe repwe nonom rech.” ");
INSERT INTO chk_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Iwe, aramasen ewe telinimw meinisin ra aüselinga alon Hamor me Sikem, nge iteiten mwänin ewe telinimw ra sirkomsais. ");
INSERT INTO chk_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Iwe, mürin ülüngat rän, lupwen ra onoson, ruoman nöün Jakop kewe mwän Simeon me Lefi mongeen Tina ra angei nöür ketilas, ra anifilong lon ewe telinimw o niela ekewe mwän meinisin. ");
INSERT INTO chk_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ra pwal niela Hamor me Sikem nöün we. Mürin ra angei Tina seni lon imwen Sikem o süla fan. ");
INSERT INTO chk_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mürin, nöün Jakop kewe mwän ra feito won ekewe somä o angei pisekin ewe telinimw fän pöchökül pokiten fefiner we a itengau rer. ");
INSERT INTO chk_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ra pwal angei nöür kewe pwiin sip me kow me nöür kewe aas me meinisin mine a nom lon ewe telinimw, pwal lon ewe mälämäl. ");
INSERT INTO chk_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Iwe, ra uweeala wöür meinisin mi nom lon imwer, pwal nöür semirit me pwülüer. ");
INSERT INTO chk_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mürin, Jakop a üreni Simeon me Lefi, “Ämi oua ariaföüüei, pun oua föri mine chon ekei fanü, chon Kanaan me chon Peris repwe oputaei ren. Kich sa chokükün. Nge are ra chufengen pwe repwe maun ngenikich, ngang me chon leimwei meinisin aipwe rosola.” ");
INSERT INTO chk_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Nge ra apasa, “Ifa usun, a öch an epwe föri ngeni fefinem ei, usun chök an föri ngeni eman fin lisowu?” ");
INSERT INTO chk_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Iwe, Kot a üreni Jakop, “Kopwe feila Petel o nonom ikenan. Iwe, kopwe senätä eu rongen asor ikenan fän itei ngang ewe Kot mi pwä ngonuk, lupwen ka sü seni Esau pwiüm we.” ");
INSERT INTO chk_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Iei mine Jakop a kapas ngeni chon leimwan me chokewe meinisin mi eti, “Oupwe pöütala ekewe uluulun anümwäl mi wor remi, oupwe pwal limetikemi o siwili üfemi. ");
INSERT INTO chk_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mürin, ousipwe ütä o feila Petel pwe üpwe senätä eu rongen asor fän iten ewe Kot a aüselingaei lon ränin ai riaföü, a pwal etiei ekis meinisin ia üa feila ie.” ");
INSERT INTO chk_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Iwe, ra ngeni Jakop ar kewe uluulun anümwäl mi nom rer, pwal niouter kewe mi nom won selinger. Nge Jakop a ireerela meinisin fän ewe irä ook a arap ngeni Sikem. ");
INSERT INTO chk_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Iwe, lupwen Jakop me an we mwich ra popuetä ar sai, eu niuokus watte me ren Kot a tori chon ekewe telinimw mi nom ünükür pwe resap tapweriir. ");
INSERT INTO chk_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Iwe, Jakop me ekewe aramas meinisin mi eti ra tori Lus, a pwal iteni Petel, lon ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ikenan a senätä eu rongen asor o aita ngeni ewe leni El Petel , pun ikenan Kot a pwä ngeni Jakop, lupwen a sü seni pwin we. ");
INSERT INTO chk_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Iwe, Tepora ewe chon tümwünü Repeka seni an kükün a mäla, nge ra peiaseni fän efoch ook pekitiuen Petel. Iei mine ra aita ngeni ewe irä Allon Pakut . ");
INSERT INTO chk_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Mürin än Jakop liwinto seni Mesopotamia, Kot a pwäsefäl ngeni o afeiöchü. ");
INSERT INTO chk_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Iwe, Kot a kapas ngeni, “Itom Jakop, nge kosap chüen iteni Jakop, pwe kopwe le iteni Israel.” Iei mine a iteni Israel. ");
INSERT INTO chk_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Iwe, a pwal üreni, “Ngang ewe Kot mi Unusen Manaman. Kopwe upw o chomongola. Kopwe wiliti eu mwichen aramas, nge chomong mwicheichen aramas me king kana repwe pop senuk. ");
INSERT INTO chk_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ewe fanü üa fen ngeni Apraham me Isaak üpwe pwal ngonuk me mwirimwirum kana.” ");
INSERT INTO chk_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mürin, Kot a feitä seni Jakop. ");
INSERT INTO chk_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nge Jakop a aüetä eföü föün achem won ewe leni ia Kot a kapas ngeni me ie, a pwal ninätiu asoren ün me lö won. ");
INSERT INTO chk_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Iei mine Jakop a aita ngeni ewe leni Petel, ewe ia Kot a kapas ngeni me ie. ");
INSERT INTO chk_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Mürin, Jakop me an famili ra sai seni Petel. Iwe, lupwen resamwo arap ngeni Efrat, Rahel a tori an cheuchen fam, nge a weires an epwe nöünöü. ");
INSERT INTO chk_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Iwe, lupwen a fokun weires ren an cheuch, ewe chon afam a üreni, “Kosap niuokus, pun kopwe nöüni pwal eman ät.” ");
INSERT INTO chk_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Nge lupwen a arap ngeni än Rahel epwe mäla, a aita ngeni ewe ät Pen Oni , nge saman we a aita ngeni Peniamin . ");
INSERT INTO chk_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Iwe, lupwen Rahel a mäla, ra peiaseni lepekin ewe al a ale ngeni Efrat, a pwal iteni Petleem. ");
INSERT INTO chk_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nge Jakop a aüetä eföü föün achem won peiasan. Iei ewe föün achem won peiasen Rahel a chüen nom tori ikenai. ");
INSERT INTO chk_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Mürin, Israel a sopwela an sai o aüetä imwan imw mangaku pekilan ewe imw tekia lon Eter. ");
INSERT INTO chk_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Iwe, lupwen Israel a nonom lon ewe fanü, Rupen a kon ren Pila ülüpwülüen saman we, nge Israel a rong usun. ");
INSERT INTO chk_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Iwe, a wor engol me ruoman nöün Jakop mwän. Iwe, nöün me won Lea: Rupen nöün Jakop we mwänichi, Simeon, Lefi, Juta, Isakar me Sepulon. ");
INSERT INTO chk_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Nge nöün me won Rahel: Josef me Peniamin. ");
INSERT INTO chk_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Iwe, Pila nöün Rahel we chon angang a nöüni rüoman mwän Tan me Naftali. ");
INSERT INTO chk_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Nge Silpa nöün Lea we chon angang a pwal nöüni ruoman mwän Kat me Aser. Ikkei ir nöün Jakop mwän a nöüniir me lon Mesopotamia. ");
INSERT INTO chk_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Iwe, Jakop a feito ren Isaak saman we lon Mamre mi arap ngeni Kiriat Arpa ika Hepron, ewe ia Apraham me Isaak ra wasöla ie. ");
INSERT INTO chk_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nge ierin manauen Isaak ipükü walik. ");
INSERT INTO chk_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Iwe, Isaak a mäla, lupwen a fokun chinlapala, o chufengen me an kewe lewo. Iwe, nöün kewe ruoman mwän Esau me Jakop ra peiaseni. ");
INSERT INTO chk_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iei uruwon ekewe mwirimwirin Esau a pwal iteni Etom. ");
INSERT INTO chk_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iwe, Esau a pwülüeni ekei fin Kanaan: Ata nöün Elon fefin, ewe re Hit, pwal Oholipama nöün Ana fefin, nge Ana nöün Sipeon ewe re Hiw. ");
INSERT INTO chk_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau a pwal pwülüeni Pasemat nöün Ismael fefin, fefinen Nepajot. ");
INSERT INTO chk_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Iwe, Ata a nöüni me won Esau Elifas, Pasemat a nöüni Reuel, ");
INSERT INTO chk_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","nge Oholipama a nöüni Jeus, Jalam me Kora. Ikkei ir nöün Esau kewe mwän a nöüniir me lon ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Iwe, Esau a angei pwülüan kewe pwal nöün kewe mwän me fefin me chon leimwan meinisin. A pwal angei nöün kewe pwiin man me pisekin meinisin a eäni me lon ewe fanü Kanaan. Iwe, a aimwü seni Jakop pwin we o feila lon pwal eu fanü. ");
INSERT INTO chk_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","A feila, pun wöür ra kon chomong pwe resap tongeni nomfengen, nge ewe fanü ra nom lon esap naf ngeniir pokiten chomongun nöür kewe pwiin man. ");
INSERT INTO chk_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Iei popun Esau mi pwal iteni Etom a nonom lon ewe fanü mi chukuchukutä lon Etom. ");
INSERT INTO chk_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iei uruwon ekewe mwirimwirin Esau, ir än ekewe chon Etom mi nonom lon ewe fanü mi chukuchukutä lon Etom kewe lewo. ");
INSERT INTO chk_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iwe, nöün Esau kewe mwän: Elifas, a nöüni me won Ata, nge Reuel, a nöüni me won Pasemat. ");
INSERT INTO chk_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Nge nöün Elifas kewe mwän: Teman, Omar, Sefo, Katam me Kenas. ");
INSERT INTO chk_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas nöün Esau we a pwal nöüni Amalek me won ülüpwülüan we itan Timna. Ekei mwän meinisin nöün nöün Ata pwülüen Esau. ");
INSERT INTO chk_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Nge nöün Reuel kewe mwän: Nahat, Sera, Samma me Missa. Ekei mwän nöün nöün Pasemat pwülüen Esau. ");
INSERT INTO chk_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iwe, Oholipama nöün Ana fefin, nge Ana nöün Sipeon mwän, a nöüni me won Esau pwülüan we: Jeus, Jalam me Kora. ");
INSERT INTO chk_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iwe, ikkei ir ekewe samol me lein ekewe mwirimwirin Esau. Elifas nöün Esau we mwänichi, nge nöün kewe mwän ir samol iter Teman, Omar, Sefo, Kenas, ");
INSERT INTO chk_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Katam me Amalek. Ätekei ir ekewe samol mwirimwirin Elifas mi nom lon ewe fanü Etom, pwal ir nöün nöün Ata mwän. ");
INSERT INTO chk_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nge Reuel nöün Esau we a pwal wor nöün kewe mi samol iter Nahat, Sera, Samma me Missa. Ätekei ir ekewe samol mwirimwirin Reuel mi nom lon ewe fanü Etom, pwal ir nöün nöün Pasemat pwülüen Esau we. ");
INSERT INTO chk_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iwe, Oholipama pwülüen Esau a pwal wor nöün kewe mi samol iter Jeus, Jalam me Kora. Ätekei ir ekewe samol mwirimwirin Oholipama pwülüen Esau nöün Ana we fefin. ");
INSERT INTO chk_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ätekei meinisin ir mwirimwirin Esau, a pwal iteni Etom, nge pwal ir ar kewe samol. ");
INSERT INTO chk_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Iwe, nöün Seir kewe mwän ewe re Hor mi nonom lon ewe fanü Etom: Lotan, Sopal, Sipeon, Ana, ");
INSERT INTO chk_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Tison, Eser me Tisan. Ätekei ir ekewe samolun chon Hor nöün Seir kewe mwän mi nom lon ewe fanü Etom. ");
INSERT INTO chk_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Iwe, nöün Lotan kewe mwän Hori me Heman, nge Timna fefinen Lotan. ");
INSERT INTO chk_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Nöün Sopal kewe mwän Alwan, Manahat, Epal, Sefo me Onam. ");
INSERT INTO chk_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Nge nöün Sipeon kewe mwän Aia me Ana. Iwe, Ana ätewe mi küna ewe koluk mi pwichikar lon ewe fanüapö, lupwen a tümwünü nöün saman kewe aas. ");
INSERT INTO chk_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Iwe, Tison nöün Ana mwän, nge Oholipama nöün fefin. ");
INSERT INTO chk_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Nge nöün Tison kewe mwän: Hemtan, Espan, Itran me Cheran. ");
INSERT INTO chk_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Iwe, nöün Eser kewe mwän: Pilan, Saawan me Akan. ");
INSERT INTO chk_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Nge nöün Tisan kewe mwän: Us me Aran. ");
INSERT INTO chk_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Iwe, ekewe samolun chon Hor iter Lotan, Sopal, Sipeon, Ana, ");
INSERT INTO chk_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Tison, Eser me Tisan. Ätekei ir ekewe samolun chon Hor lon tettelin ar ainang mi nom lon ewe fanü Etom. ");
INSERT INTO chk_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ikkei ir ekewe king mi nemenem lon ewe fanü Etom, lupwen esamwo wor king mi nemenem lon Israel. ");
INSERT INTO chk_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Pela nöün Peor a kingen Etom, iten an telinimw Tinhapa. ");
INSERT INTO chk_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Iwe, mürin än Pela mäla, Jopap nöün Sera seni Posra a siwili lon wisan wisen king. ");
INSERT INTO chk_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Nge mürin än Jopap mäla, Husam seni fanüen chon Teman a siwili lon wisan wisen king. ");
INSERT INTO chk_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Mürin än Husam mäla, Hatat nöün Petat a siwili lon wisan wisen king. Hatat ewe mi akufu chon Mitian me lon ewe fanü Moap. Iwe, iten an telinimw Awit. ");
INSERT INTO chk_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Nge mürin än Hatat mäla, Samla seni Masreka a siwili lon wisan wisen king. ");
INSERT INTO chk_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Iwe, mürin än Samla mäla, Shaul seni ewe telinimw Rehopot mi nom arun ewe chanpupu Oifrat a siwili lon wisan wisen king. ");
INSERT INTO chk_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Mürin än Shaul mäla, Paalanan nöün Akpor a siwili lon wisan wisen king. ");
INSERT INTO chk_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Iwe, mürin än Paalanan nöün Akpor mäla, Hatat a siwili lon wisan wisen king. Iten an telinimw Pau, nge iten pwülüan Mehetapel nöün Matret we fefin, nge Matret nöün Mesahap fefin. ");
INSERT INTO chk_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Iwe, ikkei ir ekewe samol, ir mwirimwirin Esau lon tettelin ar kewe ainang me lenier: Timna, Alwa, Jetet, ");
INSERT INTO chk_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholipama, Ela, Pinon, ");
INSERT INTO chk_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mipsar, ");
INSERT INTO chk_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Maktiel me Iram. Ätekei ir ekewe samolun Etom lon tettelin en me lenian me lon ewe fanü ra fanüeni. Nge Esau än chon Etom lewo. ");
INSERT INTO chk_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iwe, Jakop a nonom lon ewe fanü Kanaan, ia saman a wasöla ie me lom. ");
INSERT INTO chk_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iwe, iei pworausen än Jakop famili. Lupwen Josef a ierini engol me fisu, a eti pwin kewe nöün Pila me Silpa ülüpwülüen saman we le fofol sip. Nge Josef a apworausa ngeni semer we usun föföringauen pwin kewe. ");
INSERT INTO chk_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Iwe, Israel a echeni Josef lap seni nöün kewe meinisin, pun a nöüni lupwen an chinlap. Iwe, a aüföüfa ngeni echö üf mi lingöch. ");
INSERT INTO chk_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nge lupwen pwin kewe ra küna pwe semer we a echeni Josef lap seniir meinisin, ra oputa Josef, nge resap chüen tongeni wokekei are kapas pwapwa ngeni. ");
INSERT INTO chk_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Iwe, lon eu pwin Josef a eäni eu tan. Nge lupwen a apworausa ngeni pwin kewe usun, ra chök alapala ar oput. ");
INSERT INTO chk_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Josef a üreniir, “Oupwe rongorong pworausen ai ei tan. ");
INSERT INTO chk_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Sia pilükü irän wiich. Iwe, pilüküei we a püsin ütä, nge pilüküemi kewe ra pwelifeili o chap ngeni.” ");
INSERT INTO chk_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Nge pwin kewe ra aisini, “Ifa usun, ka ekieki pwe en kopwe nemenikem, are ka ekieki pwe kopwe äm samol?” Iwe, ra chök fokun alapala ar oput pokiten pworausen an we tan. ");
INSERT INTO chk_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mürin, Josef a pwal eäni eu tan o apworausa ngeni pwin kewe. Iwe, a apasa, “Üa pwal eäni eu tan. Lon ai we tan akkar me maram me engol me eföü fü ra chapetiu fän mesei.” ");
INSERT INTO chk_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Nge lupwen a apworausa an we tan ngeni saman me pwin kewe, saman we a apwüngü o aisini, “Met sokun tan en ka eäni? Ifa usun, äm me inom me pwiüm kewe aipwe wesewesen feito o chapetiu lepwül fän mesom?” ");
INSERT INTO chk_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Iwe, pwin kewe ra lolowo ngeni, nge saman we a amwöchü an kewe kapas lon lelukan. ");
INSERT INTO chk_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Iwe, pwin Josef kewe ra feila arun Sikem pwe repwe tümwünü nöün semer kewe sip. ");
INSERT INTO chk_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Iwe, Israel a üreni Josef, “Ka silei pwe pwiüm kewe ra tümwünü ekewe sip arun Sikem? Etto, üpwe tinukela rer.” Nge Josef a pälüeni, “Ewer, üpwe feila.” ");
INSERT INTO chk_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Iwe, Israel a üreni, “Kopwe feila o pi are a öch pworausen pwiüm kewe me ekewe sip. Mürin, kopwe liwinto o asileto rei.” Iei mine Israel a tinala Josef seni ewe lemolun Hepron. Nge lupwen Josef a tori Sikem, ");
INSERT INTO chk_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","eman mwän a küna lon an fetalfeil lon ekewe mälämäl. Iwe, a aisini Josef, “Met ka kütta?” ");
INSERT INTO chk_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nge Josef a pälüeni, “Üa kütta pwii kewe. Kose mochen kopwe aiti ngeniei ia ra tümwünü ie nöüm kewe sip.” ");
INSERT INTO chk_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nge ewe mwän a üreni, “Ra fen feila ekis, pun üa rong pwe ra kapasfengen lefiler pwe repwe feila Totan.” Iei mine Josef a tapwela mürin pwin kewe, nge a küneer me Totan. ");
INSERT INTO chk_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Iwe, pwin kewe ra küna Josef me toau. Nge lupwen esamwo arap ngeniir, ra pwüngüpwüngfengen lemonomon usun ar repwe niela. ");
INSERT INTO chk_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Iwe, ra kapasfengen lefiler, “Nengeni, a war ewe chon tan. ");
INSERT INTO chk_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ou etto, sipwe niela o aturalong lon eu kewe pwang. Mürin sipwap üra pwe eman manmwacho a ochei. Iwe, sipwe pi ika epwe fis pwüngün mine a eäni tan.” ");
INSERT INTO chk_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Nge lupwen Rupen a rong ar pwüngüpwüng, a ekiekin angasa Josef seniir. Iwe, a apasa, “Ouse mochen sisap niela pwiich. ");
INSERT INTO chk_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ousap afeiengaua. Oupwe aturätiu lon ei pwang ikei lon fanüapö, nge ousap niela.” Rupen a apasa ei, pun a ekiekin amanaua Josef seniir o aliwinala ren saman we. ");
INSERT INTO chk_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Iwe, lupwen Josef a tori pwin kewe, ra turufi o pwiliti seni üfan mi lingöch. ");
INSERT INTO chk_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Iwe, ra angei o aturalong lon eu pwang mi pö esap wor koluk lon. ");
INSERT INTO chk_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mürin, ra mottiu pwe repwe mongö. Nge lupwen ra chimwetä, ra küna eu mwichen chon Ismael me nöür kewe kamel ra feito me Kiliat. Iwe, ekewe kamel ra uwou sokun apach mi pwokus me säfei mi aüchea itan mör, pwe repwe uwala Isip. ");
INSERT INTO chk_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Iwe, Juta a üreni pwin kewe, “Met lomoten ach sipwe niela pwiich o tukumala ach föför?” ");
INSERT INTO chk_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ou etto, sipwe amömöla pwiich ei ngeni ekanan chon Ismael. Nge ousisap niela. Pun i pwiich pwal fitukach.” Iwe, pwin kewe ra tipeeu ngeni. ");
INSERT INTO chk_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nge lupwen ekewe chon amömö seni Mitian ra toriir, ra efietä Josef me lon ewe pwang o amömöla ngeni ekewe mwirimwirin Ismael ren rüe föün moni silifer. Iwe, ekewe chon Ismael ra uwala Josef Isip. ");
INSERT INTO chk_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nge lupwen Rupen a liwinto ren ewe pwang o küna pwe Josef esap chüen nom lon, a kamwei üfan fän an letipeta. ");
INSERT INTO chk_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Iwe, a liwinla ren pwin kewe o apasa, “Ese chüen nom ewe ät. Met üpwe föri iei?” ");
INSERT INTO chk_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mürin ra niela eman kuuch o iselong üfen Josef we lon chan. ");
INSERT INTO chk_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Iwe, ra tinala ewe üf mi lingöch ren semer we o asile ngeni, “Iei ei üf aia küna. Kopwe nenengeni ika üfen noum we ika esap üfan.” ");
INSERT INTO chk_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iwe, Jakop a sileni ewe üf o apasa, “Ei üf wesewesen üfen nei we, eman manmwacho a ochei. Ellet, inisin Josef a tatakis.” ");
INSERT INTO chk_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Mürin, Jakop a kamwei üfan fän an letipeta, a üföüfolong echö üf seni tuk o kechüeiti nöün we lon chomong rän. ");
INSERT INTO chk_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Iwe, nöün kewe mwän me fefin meinisin ra sotun achipa, nge Jakop esap mochen chipila. Iwe, a üra, “Lon ai letipeta üpwe feitiu lon lenien sotup ren nei ät.” Iei usun Jakop a kechüeiti Josef. ");
INSERT INTO chk_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nge lon ewe fansoun, ekewe chon Mitian ra fen amömöla Josef lon Isip ngeni Potifar, eman nöün Farao nöüwis, pwal i ewe meilapen mwichen sounfiu mi wisen tümwünü imwen Farao. ");
INSERT INTO chk_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Lon ena fansoun a fis pwe Juta a feila seni pwin kewe o wasöla ren eman re Atullam itan Hira. ");
INSERT INTO chk_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ikenan Juta a küna eman föpwül nöün eman re Kanaan itan Shua. Iwe, a pwüpwülü ngeni o kon ren. ");
INSERT INTO chk_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nge ewe föpwül a pwopwo, a nöüni eman ät o aita ngeni Er. ");
INSERT INTO chk_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mürin, a pwal pwopwo, a nöüni eman ät o aita ngeni Onan. ");
INSERT INTO chk_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nge lupwen a nonom Kesip, a pwal nöüni eman ät o aita ngeni Shela. ");
INSERT INTO chk_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iwe, Juta a kütta eman föpwül itan Tamar pwe pwülüen Er nöün we mwänichi. ");
INSERT INTO chk_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nge Er nöün Juta mwänichi a fokun föföringau fän mesen ewe Samol mi Lapalap. Iei mine ewe Samol mi Lapalap a niela. ");
INSERT INTO chk_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Mürin, Juta a üreni Onan, “Kopwe pwülüeni pwülüen pwiüm we pwe epwe wor mwirimwirin, pun iei usun pwüngün ngeni eman a mä pwin. ");
INSERT INTO chk_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nge Onan a silei pwe esap tongeni nöüni nöün me won pwülüen pwin we. Iwe, lupwen a kon ren pwülüen pwin, a chök akusätiu chan lepwül pwe esap wor mwirimwirin pwin. ");
INSERT INTO chk_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nge ewe Samol mi Lapalap a oput mine Onan a föri, iei popun a pwal niela. ");
INSERT INTO chk_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Mürin, Juta a üreni Tamar pwülüen nöün we, “Kopwe liwiniti imwen semom o nonom lon om lipich, tori Shela nei we epwe mwän.” Juta a apasa ei, pun a niuokus pwe Shela epwe pwal mäla usun chök pwin kewe. Iei mine Tamar a liwinla lon imwen saman. ");
INSERT INTO chk_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Feilfeil pwülüen Juta nöün Shua we fefin a mäla. Nge lupwen a wes än Juta letipeta, a feila Timnat pwe epwe fichi ülen nöün kewe sip, nge chienan Hira ewe re Atullam a eti. ");
INSERT INTO chk_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Iwe, eman a asile ngeni Tamar pwe semen pwülüan we a feila Timnat pwe epwe fichi ülen nöün kewe sip. ");
INSERT INTO chk_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Mürin, Tamar a pwilitawu üfan üfen lipichsefäl, a filiti inisin ngeni echö mangaku, a pwölüöla won mesan o mottiu leasamalapen Enaim ünükün ewe al a ale ngeni Timnat. Pun a silei pwe Shela a tori ierin mwän, nge resamwo apwüpwülüa ngeni. ");
INSERT INTO chk_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Iwe, lupwen Juta a küna neminewe, a ekieki pwe i eman fefin mi amömö inisin fän iten lisowu, pun a pwölüöla won mesan. ");
INSERT INTO chk_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Iwe, a feila ren lükün ewe al o üreni, “Etto, üpwe kon reöm.” Pun esap silei pwe pwülüen nöün we. Nge Tamar a aisini, “Met kopwe liwini ngeniei ika kopwe kon rei?” ");
INSERT INTO chk_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Iwe, Juta a pälüeni, “Üpwe tinala reöm eman apanen kuuch.” Nge Tamar a üra, “Kose mochen kopwe ngeniei asisilen om pwon tori kopwe tinato rei ewe kuuch?” ");
INSERT INTO chk_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Nge Juta a aisini, “Met sokun mettoch üpwe ngonuk pwe asisilen ai pwon?” Iwe, Tamar a pälüeni, “Kopwe ngeniei noum ringen pwau fiti selin, pwal wokum na mi nom lepoum.” Iwe, a ngeni neminewe ekewe mettoch. Mürin a kon ren, nge neminewe a pwopwo me won. ");
INSERT INTO chk_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mürin, Tamar a liwiniti imwan, a pwilitätiu ewe mangaku, a pwölü ngeni won mesan, o pwilitalong üfan üfen lipichsefäl. ");
INSERT INTO chk_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Iwe, Juta a tinala Hira chienan we pwe epwe uwala ewe apanen kuuch ren ewe fefin o angei seni ekewe asisilen an pwon. Nge Hira esap chüen küna. ");
INSERT INTO chk_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Iwe, a aisini mwänin ewe leni, “Ifa i ewe fefin mi amömö inisin fän iten lisowu a nom Enaim ünükün ewe al?” Nge ra palüeni, “Ese wor eman fefin mi amömö inisin a nom ikei.” ");
INSERT INTO chk_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Iei popun a liwinla ren Juta o apasa, “Üsap küna ewe fefin. Nge mwänin ewe leni ra apasa pwe esap wor eman fefin mi amömö inisin fän iten lisowu a nom ikenan.” ");
INSERT INTO chk_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Nge Juta a üreni, “Ina chök, epwe chök nöüni ekewe mettoch pwe site uren takir. En ka püsin silei pwe üa tinala ewe apanen kuuch ren ewe fefin, nge kosap küna.” ");
INSERT INTO chk_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Iwe, ina epwe ülüngat maram mürin, eman a asile ngeni Juta, “Tamar pwülüen noum we a tipisin lisowu, nge a pwal pwopwo.” Iwe, Juta a apasa, “Oupwe emwenawu pwe sipwe keni.” ");
INSERT INTO chk_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Nge lupwen ra emwenawu Tamar, a tinala pworaus ren semen pwülüan we o apasa, “Ngang üa pwopwo me won ewe mwän mine nöün ekei mettoch. Üa tüngor ngonuk pwe kopwe nengenifichi, ika nöün iö ei ringen pwau fiti selin me ei wok.” ");
INSERT INTO chk_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nge Juta a sileni ekewe mettoch o apasa, “Neminan a pwüng seniei, pun üsap apwüpwülüa ngeni nei mwän Shela.” Nge Juta esap chüen kon ren. ");
INSERT INTO chk_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Iwe, lupwen a tori fansoun an epwe nöünöü, a pwä pwe a wor nöün lippwe lon lukan. ");
INSERT INTO chk_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Nge lupwen a tori an cheuchen fam, eman a sikiwu pöün. Iwe, ewe chon afam a amwöchü pöün, a rii ngeni emwü terech mi par o apasa, “Ätei a akomwen uputiu.” ");
INSERT INTO chk_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nge lupwen a siksefälielong pöün, pwin we a uputiu. Mürin, ewe chon afam a apasa, “Oo, iei usun ka püsin amökkawu!” Iei mine a iteni Peres . ");
INSERT INTO chk_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mürin, pwin we a uputiu, nge a wor ewe terech mi par won pöün. Iwe, a iteni Sera. ");
INSERT INTO chk_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Iwe, ekewe mwirimwirin Ismael ra uwala Josef Isip. Nge eman re Isip itan Potifar, eman nöün Farao nöüwis, pwal i ewe meilapen mwichen sounfiu mi wisen tümwünü imwen Farao, a möni Josef seni ekewe chon Ismael, lupwen ra uwato. ");
INSERT INTO chk_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Nge ewe Samol mi Lapalap a eti Josef pwe a fisiöch an angang meinisin. Iwe, a nonom lon imwen an samol ewe re Isip. ");
INSERT INTO chk_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ätewe a küna pwe ewe Samol mi Lapalap a eti Josef o apwönüetä an angang meinisin a föri. ");
INSERT INTO chk_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Iwe, Potifar a ümöümöch ngeni Josef, iei mine a afili pwe epwe angang ngeni. A seikätä Josef pwe epwe tümwünü imwan me pisekin meinisin. ");
INSERT INTO chk_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nge seni ewe otun Potifar a seikätä Josef pwe epwe tümwünü imwan me pisekin meinisin, ewe Samol mi Lapalap a afeiöchü imwan pokiten Josef. Iwe, än ewe Samol mi Lapalap feiöch a nonom won meinisin mine Potifar a eäni lon imwan pwal won fanüan. ");
INSERT INTO chk_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Iei mine Potifar a anomu fän nemenemen Josef meinisin mine a eäni. Iwe, Potifar esap chüen tümwünü och mettoch pwe anan mongö chök. Nge Josef a fokun äteöch o mesemesöch. ");
INSERT INTO chk_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mürin ekoch fansoun pwülüen an we samol a sani Josef o üreni, “Kopwe kon rei.” ");
INSERT INTO chk_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Nge Josef esap tipeeu ngeni. Iwe, a üreni pwülüen an we samol, “Nengeni, ai samol esap chüen tümwünü och mettoch lon imwan, nge a anomu meinisin mine a eäni fän nemeniei. ");
INSERT INTO chk_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ai nemenem lon ei imw a usun chök an nemenem. Ai samol esap amwöchü seniei och mettoch chilon chök en, pun en pwülüan. Ifa usun, üpwe föri och föför mi fokun ngau o tipis ngeni Kot?” ");
INSERT INTO chk_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iwe, neminewe a kakapas ngeni Josef rän me rän pwe epwe kon ren ika nom ren, nge i esap aüselinga alon. ");
INSERT INTO chk_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nge lon eu rän, lupwen Josef a tolong lon ewe imw pwe epwe föri an angang, esap wor eman lein ekewe chon angang a nom lon ewe imw. ");
INSERT INTO chk_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ewe fefin a turufi Josef, a amwöchü üfan o üreni, “Kopwe kon rei.” Nge Josef a likitala üfan we lepöün o sü seni me lon ewe imw. ");
INSERT INTO chk_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Iwe, lupwen ewe fefin a küna pwe Josef a likiti üfan lepöün o süwu lükün ewe imw, ");
INSERT INTO chk_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a körato nöün kewe chon angang o üreniir, “Nengeni, Potifar a uwato rech eman re Ipru pwe epwe turunufasekich. Iwe, a tolong rei pwe epwe kon rei, nge üa puchör. ");
INSERT INTO chk_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Nge lupwen a rong ai pupuchör, a likitala üfan rei o süla lükün.” ");
INSERT INTO chk_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Iwe, ewe fefin a iseis üfen Josef ren, tori an samol a liwiniti imwan. ");
INSERT INTO chk_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Mürin, ewe fefin a asile ngeni pwülüan we ewe chök pworaus, “Ewe re Ipru ka uwato rech pwe sipwe nöüni amanau a tolong rei pwe epwe turunufaseei. ");
INSERT INTO chk_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Nge lupwen üa pupuchör, a likitala üfan rei o süla lükün.” ");
INSERT INTO chk_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Iwe, lupwen än Josef samol a rong ewe pworaus pwülüan we a asile ngeni, a fokun song. ");
INSERT INTO chk_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Iwe, Potifar a angei nöün chon angang Josef o aturalong lon imwen fötek, ia nöün ewe king chon fötek ra fötek ie. Iwe, Josef a nonom lon ewe imwen fötek. ");
INSERT INTO chk_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nge ewe Samol mi Lapalap a eti Josef o eäni kirikiröch ngeni, pwe a küna ümöümöch me ren ewe chon nemeni ewe imwen fötek. ");
INSERT INTO chk_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Iwe, ewe chon nemeni ewe imwen fötek a lükü ngeni Josef ekewe chon fötek meinisin mi nom lon ewe imwen fötek, pwe epwe tümwünüür. Josef a pwal nemeni ekewe angang meinisin ra fis lon ewe imwen fötek. ");
INSERT INTO chk_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Iwe, ewe chon nemeni ewe imwen fötek esap chüen ekiekin püsin tümwünü mine a fen nom fän nemenien Josef, pun ewe Samol mi Lapalap a eti Josef o afeiöchü an angang meinisin. ");
INSERT INTO chk_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Iwe, mürin ekoch fansoun, ewe chon amolätä ünümen ewe kingen Isip, pwal nöün chon umuni anan pilawa ra tipis ngeni ar we samol ewe kingen Isip. ");
INSERT INTO chk_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao a song ngeni nöün kewe ruoman nöüwis, ewe meilapen chon amolätä ünüman me ewe meilapen chon umuni anan pilawa. ");
INSERT INTO chk_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Iwe, a fötekiniir lon imwen ewe meilapen sounfiu mi wisen tümwünü imwen Farao. Iei ewe imwen fötek Josef a pwal nom lon. ");
INSERT INTO chk_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Iwe, ewe meilapen sounfiu a anomuur fän tümwünüen Josef pwe epwe angang ngeniir. Iwe, lupwen ra nonom lon ewe imwen fötek ekoch fansoun, ");
INSERT INTO chk_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ewe chon amolätä ünümen ewe kingen Isip me ewe chon umuni anan pilawa ra tan lon eu chök pwin. Nge ar kewe tan a sokofesen wewen. ");
INSERT INTO chk_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Iwe, lupwen Josef a churi nöün Farao kewe nöüwis lesosor, a küna pwe ra wololilen. ");
INSERT INTO chk_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Iei mine a aisiniir, “Met popun pwe oua wololilen ikenai?” ");
INSERT INTO chk_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Iwe, ra pälüeni, “Äm aia tan, nge ese wor eman a tongeni awewe ngenikem äm kewe tan.” Nge Josef a üreniir, “Kot chök a tongeni awewei tan. Iwe, oupwe pwäri ngeniei ämi kewe tan.” ");
INSERT INTO chk_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Iei mine ewe meilapen chon amolätä ünümen Farao a pwäri an we tan ngeni Josef, “Lon ai we tan üa küna efoch irän wain, ");
INSERT INTO chk_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nge a wor ülüfoch keangan. Iwe, lupwen a pwüküwu fasaran, etin a pwal suk, nge uan kewe ra müttir nup. ");
INSERT INTO chk_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Iwe, üa amwöchü än Farao kap. Üa pwal angei uän ewe irän wain o ungutalong lon ewe kap. Mürin üa isenalong lepöün Farao.” ");
INSERT INTO chk_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Iwe, Josef a üreni, “Iei wewen om na tan: Ekewe ülüfoch keang ülüngat rän. ");
INSERT INTO chk_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mürin ülüngat rän Farao epwe echimwätä mökürom o atolongasefäliik lon wisom. Iwe, kopwe isenalong lepöün Farao an kap usun chök me lom, lupwen ka wisen amolätä ünüman. ");
INSERT INTO chk_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Nge kose mochen kopwe chechemeniei lupwen om kopwe feiöchsefäl. Iwe, kopwe kirikiröch ngeniei o achemenieitä fän mesen Farao, kopwe pwal alisiei pwe üpwe towu seni ei imwen fötek. ");
INSERT INTO chk_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pun ra soläniei seni ewe fanüen chon Ipru, nge pwal ikei üsap föri och mi ngau pwe repwe aturueilong lon imwen fötek.” ");
INSERT INTO chk_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Iwe, lupwen ewe meilapen chon umuni pilawa a rong pwe a öch wewen ewe tan, a üreni Josef, “Ngang üa pwal tan. Iwe, lon ai we tan a wor ülüngat chük üa aüwomonga. ");
INSERT INTO chk_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nge lon ewe chük mi nom asan, a wor chomong sokun pilawa fän iten Farao. Iwe, machang ra mongö seni lon ewe chük.” ");
INSERT INTO chk_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Iwe, Josef a üreni, “Iei wewen om na tan: Ekewe ülüngat chük ülüngat rän. ");
INSERT INTO chk_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mürin ülüngat rän Farao epwe echimwätä mökürom, pun epwe pökü üom, nge inisum epwe aitiuätä won efoch irä. Iwe, machang repwe feito o ochei fitukom.” ");
INSERT INTO chk_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Iwe, ülüngat rän mürin, a fis ränin uputiuen Farao. Iwe, a föri eu kametip mi watte fän iten nöün kewe nöüwis meinisin o echimwätä möküren ewe meilapen chon amolätä ünüman pwal möküren ewe meilapen chon umuni anan pilawa. ");
INSERT INTO chk_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Iwe, a atolongasefäli ewe meilapen chon amolätä ünüman lon wisan pwe epwe isenalong ewe kap lepöün. ");
INSERT INTO chk_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Nge ewe meilapen chon umuni anan pilawa a aitiuätä won efoch irä, usun Josef a fen aiti ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nge ewe meilapen chon amolätä ünümen Farao esap chüen chechemeni Josef, pwe a manlükala. ");
INSERT INTO chk_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Mürin ruu ier Farao a tan pwe a ütä ünükün ewe chanpupu Nil. ");
INSERT INTO chk_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Iwe, a küna pwe füman kow mi öch o kitinup ra towu me lon ewe chanpupu Nil o mongö fetilin ünükün. ");
INSERT INTO chk_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mürin, pwal füman kow mi ngau o kichüchü ra towu müriir, ra ütä ren ekewe kow mi öch ünükün ewe chanpupu Nil. ");
INSERT INTO chk_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Iwe, ekewe kow mi ngau o kichüchü ra ochei ekewe füman kow mi öch o kitinup. Mürin Farao a nela. ");
INSERT INTO chk_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Iwe, a möürsefäl, nge a pwal tansefäl. A küna füumw uän wiich ra pwüküwü seni efoch chök wasan, nge ra fokun masou o umwumong. ");
INSERT INTO chk_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mürin ra pwal pwüküwu füumw üän wiich, nge ra pön o pwas ren asepwälin ötiu. ");
INSERT INTO chk_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Nge ekewe füumw üän wiich mi pön ra oromala ekewe füumw uän wiich mi masou o umwumong. Iwe, lupwen Farao a nela, a mefi pwe a tan. ");
INSERT INTO chk_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Iwe, lesosor Farao a riaföü lon letipan. Iei mine a titi ekewe soupwe me ekewe soutipachemen Isip meinisin o üreniir an kewe tan. Nge esap wor eman leir a tongeni awewe ngeni Farao an kewe tan. ");
INSERT INTO chk_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Lon ewe chök otun, ewe meilapen chon amolätä ünümen Farao a üreni, “Ikenai üa chechemeni ai tipis. ");
INSERT INTO chk_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Iwe, lupwen en ka song ngeni ewe meilapen chon umuni pilawa pwal ngeniei o aturukeemilong lon fötek lon imwen ewe meilapen sounfiu mi wisen tümwünü imwomw, ");
INSERT INTO chk_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","äm me ruoman aia tan lon eu chök pwin. Nge äm kewe tan a sokofesen wewen. ");
INSERT INTO chk_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Iwe, a wor eman alüal seni chon Ipru a etikem, i chon angang ngeni ewe meilapen sounfiu. Nge lupwen aia pwäri ngeni äm kewe tan, i a awewe ngeni eman me eman leim usun wewen an we tan. ");
INSERT INTO chk_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Iwe, a fis usun an awewe ngenikem, pun ngang üa tosefälilong lon wisei, nge ewe chon umuni pilawa a itiuätä won efoch irä.” ");
INSERT INTO chk_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mürin, Farao a titi Josef. Iwe, ra müttir emwenawu seni lon ewe imwen fötek. Nge lupwen a wes me fichi möküran o siwili üfan, a tolong fän mesen Farao. ");
INSERT INTO chk_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Iwe, Farao a üreni Josef, “Ngang üa tan, nge ese wor eman a tongeni awewe ngeniei wewen. Nge üa rong pworausom, pwe lupwen ka rong eu tan, ka tongeni awewei.” ");
INSERT INTO chk_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Nge Josef a üreni Farao, “Ai king, sap ngang üa tufich ngeni, nge Kot epwe pwäri ngonuk mine kopwe feiöch ren.” ");
INSERT INTO chk_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mürin, Farao a üreni Josef, “Nengeni, lon ai we tan üa ütä ünükün ewe chanpupu Nil. ");
INSERT INTO chk_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Iwe, füman kow mi öch o kitinup ra towu me lon ewe chanpupu Nil o mongö fetilin ünükün. ");
INSERT INTO chk_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mürin pwal füman kow ra towu me mürir, ra fokun ngau o kichüchü. Üsamwo küküna ei sokun kow lon unusen ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Iwe, ekewe kow mi kichüchü o ngau ra ochei ekewe füman kow mi kitinup, ra towu me mwan. ");
INSERT INTO chk_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nge wesin ar ocheer, ese wor eman a küna pwe ra ocheer, pun ra chüen kichüchü usun me mwan. Mürin üa nela. ");
INSERT INTO chk_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Iwe, lupwen üa möürsefäl, üa pwal tan pwe üa küna füum uän wiich mi masou o umwumong, ra pwüküwu seni efoch chök wasan. ");
INSERT INTO chk_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mürin, füum uän wiich mi pön o pwas ren asepwälin ötiu ra pwüküwu me mürir. ");
INSERT INTO chk_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Iwe, ekewe füum uän wiich mi pön ra oromala ekewe füum üan wiich mi umwumong. Nge lupwen üa pwäri ngeni ekewe soupwe ai kewe tan, esap wor eman leir a tongeni awewe ngeniei wewer.” ");
INSERT INTO chk_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Mürin, Josef a üreni Farao, “Om kewe ruu tan eu chök wewen. Kot a pwäri ngonuk mine a ekiekin föri. ");
INSERT INTO chk_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ekewe füman kow mi öch ra wewe ngeni fisu ier, nge ekewe füum uän wiich mi umwumong ra pwal wewe ngeni fisu ier. Ekewe ruu tan eu chök wewen. ");
INSERT INTO chk_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ekewe füman kow mi ngau o kichüchü ra towu mürir, pwal ekewe füum uän wiich mi pön o pwas ren asepwälin ötiu ra wewe ngeni fisu ierin lengita. ");
INSERT INTO chk_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","A chök fis mine üa fen ürenuk. Kot a pwäri ngonuk mine a ekiekin föri. ");
INSERT INTO chk_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Fisu ierin räs mi watte repwe feito won unusen ei fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Nge mürin ekewe fisu ierin räs mi watte, pwal fisu ierin lengita repwe feito. Iwe, aramas repwe manlükala ewe räs mi watte won ei fanü Isip, pun ewe lengita epwe ataala ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Iwe, epwe fis pwe chon ewe fanü resap chüen chechemeni ewe räs mi watte fän äsengesin ewe lengita epwe feito me mürin, pun epwe fokun chou. ");
INSERT INTO chk_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nge wewen om tan fän ruu pwe Kot a fen amolätä ekewe mettoch, nge epwe pwal müttir afisätä. ");
INSERT INTO chk_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Iei mine a öch om kopwe filätä eman mwän mi mirit o tipachem, epwe seikitä won ei fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mürin kopwe pwal awisa ekoch nöüwis won ewe fanü, pwe repwe angei eu lelimu seni mine aramas ra kini lupwen ekewe fisu ierin räs mi watte. ");
INSERT INTO chk_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Repwe ionifengeni ekei mongö meinisin lon ekewe ierin räs mi watte repwe fefeito, repwe pwal iseni ekewe föün wiich fän nemenien Farao o tümwünüöchü pwe epwe wor mongö lon ekewe telinimw. ");
INSERT INTO chk_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nge ewe mongö epwe iseis fän iten chon ei fanü fän äsengesin ekewe fisu ierin lengita repwe tori ei fanü Isip. Ren ei, chon ei fanü resap feiengau ren ewe lengita.” ");
INSERT INTO chk_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iwe, Farao me nöün kewe nöüwis meinisin ra tipeeu ngeni ei akot. ");
INSERT INTO chk_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mürin, Farao a aisini nöün kewe nöüwis, “Ifa usun, sipwe tongeni küna eman mwän usun chök ätei, Ngünün Kot a nonom won?” ");
INSERT INTO chk_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Iei mine Farao a üreni Josef, “Esap wor eman mi wewe ngonuk ren miritum me tipachemum, pun Kot a pwäri ngonuk ekei mettoch meinisin. ");
INSERT INTO chk_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Iwe, kopwe nemeni imwei, nge nei aramas meinisin repwe aleasochisi alom. Ren chök leniei lenien king üpwe tekia senuk.” ");
INSERT INTO chk_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Iwe, Farao a pwal üreni Josef, “Iei üa seikuketä pwe kopwe nemeni unusen ei fanü Isip.” ");
INSERT INTO chk_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mürin, Farao a üttawu an ringen impwang seni won aütün o sökalong won aütün Josef. A pwal aüfaüfa ngeni mangaku mi aüchea o amwärämwära ngeni epa mwärämwär seni kolt fän üan. ");
INSERT INTO chk_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Iwe, Farao a pwal ngeni Josef aruofochun wan woken pwe epwe wawafeil, nge aramas ra akom mwan o kökkö, “Oupwe chapetiu.” Iwe, ina usun Farao a awisa Josef pwe epwe nemeni unusen ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farao a pwal üreni Josef, “Ngang Farao, nge ese wor eman won unusen ewe fanü Isip epwe föri och lükün tipom.” ");
INSERT INTO chk_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Iwe, Farao a aita ngeni Josef Safenat Panea, a pwal ngeni eman pwülüan itan Asenat nöün Potifera, ewe souasoren ewe telinimw On. Mürin, Josef a saifeil won unusen ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iwe, Josef a ierini ilik, lupwen a popuetä an angang ngeni Farao ewe kingen Isip. Mürin, Josef a feila seni fän mesen Farao o saifeil won unusen ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Iwe, lupwen ekewe fisu ierin räs mi watte, pwül a amärätä chomong föün irä. ");
INSERT INTO chk_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Lon ekewe fisu ier Josef a ionifengeni ekewe mongö mi chomong a wor won ewe fanü Isip. Iwe, lon iteiten telinimw ra iseis ekewe mongö mi mär ünükün. ");
INSERT INTO chk_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nge Josef a iseis chomong, chomong föün wiich, tori esap chüen tongeni aükük, pun a chomong usun pien aroset. ");
INSERT INTO chk_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Iwe, mwen ekewe ierin lengita, Asenat nöün Potifera, ewe souasoren On, a nöüni ruoman ät me won Josef. ");
INSERT INTO chk_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Iwe, Josef a aita ngeni nöün mwänichi Manasa , pun a apasa, “Kot a amanlükala seniei ai riaföü meinisin, pwal ai positi chon leimwen semei.” ");
INSERT INTO chk_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nge ewe aruomanün a aita ngeni Efraim , pun a apasa, “Kot a fang ngeniei nei lon ei fanü üa weires lon.” ");
INSERT INTO chk_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Iwe, ekewe fisu ierin räs mi watte ra wesila lon ewe fanü Isip, ");
INSERT INTO chk_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","nge ekewe fisu ierin lengita ra popuetä usun Josef a ürü. Iwe, a fis lengita won ekewe fanü meinisin, nge lon ewe fanü Isip a wor mongö. ");
INSERT INTO chk_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Iwe, lupwen chon Isip meinisin ra echik, ra tüngor ngeni Farao pwe epwe ngeniir mongö. Nge Farao a üreniir, “Oupwe feila ren Josef o föri mine a apasa.” ");
INSERT INTO chk_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Iwe, lupwen ewe lengita a wattela o tori unusen ewe fanü Isip, Josef a sukala ekewe imwen iseis mongö o amömöla ngeni chon Isip meinisin. ");
INSERT INTO chk_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Iwe, aramas seni ekis meinisin ra pwal feito Isip ren Josef pwe repwe kamö mongö, pun ewe lengita a fokun chouiti unusen fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Iwe, lupwen Jakop a rong pwe mi wor mongö lon Isip, a üreni nöün kewe mwän, “Pwota oua chök nonom? ");
INSERT INTO chk_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Üa rong pwe a wor wiich lon Isip. Oupwe feila o kamö anach wiich pwe sipwe manau, nge sisap mäla.” ");
INSERT INTO chk_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Iei mine pwin Josef kewe engol ra feila pwe repwe kamö eneer wiich lon Isip. ");
INSERT INTO chk_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Nge Jakop esap tinala Peniamin pwin Josef we, pun a niuokus pwe och feiengau epwe tori lupwen an etiir. ");
INSERT INTO chk_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Iei usun nöün Israel kewe ra eti ekewe aramas le feila Isip pwe repwe kamö eneer wiich, pun a pwal fis lengita lon ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Iwe, lon ewe fansoun Josef a kepinan ewe fanü, nge i chök a tongeni amömö ngeni chon fanü meinisin. Iwe, pwin Josef kewe ra pwal feito ren o chapetiu lepwül me mwan. ");
INSERT INTO chk_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iwe, lupwen Josef a küna pwin kewe, a sileniir, nge a chök föri ngeniir usun esap sisileer. A kapas pöchökül ngeniir o aisiniir, “Oua feito me ia?” Nge ra pälüeni, “Aia feito seni ewe fanü Kanaan pwe aipwe kamö mongö.” ");
INSERT INTO chk_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iwe, Josef a sileni pwin kewe, nge pwin kewe resap sileni. ");
INSERT INTO chk_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Iwe, Josef a chechemeni an kewe tan a tana usur o üreniir, “Ämi chon operi fanü. Oua chök feito pwe oupwe operi ia esap wor tümwünün fanüem me ie.” ");
INSERT INTO chk_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nge ra üreni, “Apwi äm samol, äm noum chon angang aia chök feito pwe aipwe kamö mongö. ");
INSERT INTO chk_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Äm meinisin nöün eman chök mwän. Äm aramas wenechar, nge aisap operi fanü.” ");
INSERT INTO chk_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iwe, Josef a üreniir, “Apwi, ämi oua wesewesen feito pwe oupwe operi ia esap wor tümwünün fanüem me ie.” ");
INSERT INTO chk_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nge ir ra apasa, “Äm noum chon angang aia engol me ruoman pwipwi nöün eman chök mwän lon ewe fanü Kanaan. Ewe setipütür a nom ren semem iei, nge eman a mäla.” ");
INSERT INTO chk_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nge Josef a chök üreniir, “Ellet, üa fen ürenikemi pwe ämi oua chon operi fanü. ");
INSERT INTO chk_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Iei usun üpwe alletätä ämi kapas: Mwo manauen Farao, ousap feila seni ikei, ika pwimi we setipütür esap feito. ");
INSERT INTO chk_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Oupwe tinala eman leimi pwe epwe uwato pwimi we. Nge ämi kewe lusun oupwe nonom lon imwen fötek, pwe epwe pwä leten ämi kewe kapas ika ämi oua wenechar. Nge are esap ina, mwo manauen Farao, ämi oua wesewesen chon operi fanü.” ");
INSERT INTO chk_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mürin, Josef a atururolong lon imwen fötek o anomuur ie lon ükükün ülüngat rän. ");
INSERT INTO chk_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Nge lon aülüngatin rän Josef a üreniir, “Ngang eman mi niueiti Kot. Iei oupwe föri mine üpwe ürenikemi pwe oupwe manau. ");
INSERT INTO chk_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Are ämi oua aramas wenechar, eman leimi epwe nonom lon imwen fötek, nge ämi kewe lusun oupwe feila o uwala wiich ren ämi famili mi echik. ");
INSERT INTO chk_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Iwe, oupwe uwato rei pwimi we setipütür pwe epwe pwä leten ämi kapas, nge ousap mäla.” Iwe, ra föri iei usun. ");
INSERT INTO chk_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Mürin ra kapasfengen lefiler, “Ellet, sia angei liwinin mine sia föri ngeni pwich Josef, pun sia küna riaföün lelukan lupwen an tüngor ngenikich pwe sipwe angasala, nge sisap aüseling. Iei mine ei riaföü a torikich.” ");
INSERT INTO chk_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Nge Rupen a pälüeniir, “Ifa usun, üsap fen ürenikemi pwe ousap föri och tipis ngeni ewe ät? Nge ämi ousap mochen aüselinga aloi. Iei liwinin mine sia föri ngeni a torikich.” ");
INSERT INTO chk_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Iwe, resap silei pwe Josef a wewe ren ar fos, pun eman a wisen aföü lefiler. ");
INSERT INTO chk_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Iwe, Josef a kul seniir, a feila o kechü. Nge lupwen a liwinto rer, a kapassefäl ngeniir. A angei Simeon seni lefiler o föti me mwer. ");
INSERT INTO chk_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Iwe, Josef a allük ngeni nöün chon angang pwe repwe amasoua än pwin kewe tuk ren wiich, repwe pwal aliwinalong nöür moni lon en me an tuk o ngeniir amötür. Iwe, ra föri iei usun ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Iwe, wesin ar rietä ar kewe tuken wiich won nöür kewe aas, ra la. ");
INSERT INTO chk_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nge lupwen eman leir a sukala an we tuk pwe epwe amongöü nöün aas lon ewe leni ia repwe möür ie, a küna nöün moni leawen an we tuk. ");
INSERT INTO chk_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Iwe, a üreni pwin kewe, “Eman a aliwinalong nei ei moni, a nom leawen ai ei tuk.” Nge lupwen ra küna, ra fokun mairü, ra chechech o aisfengen lefiler, “Met ei, Kot a föri ngenikich?” ");
INSERT INTO chk_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nge lupwen ra tori Jakop semer we lon ewe fanü Kanaan, ra apworausa ngeni meinisin mine a fis ngeniir, ");
INSERT INTO chk_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ewe mwän, i samolun ewe fanü, a kapas pöchökül ngenikem, pun a ekieki pwe äm chon operi fanü. ");
INSERT INTO chk_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nge äm aia üreni, ‘Äm aramas wenechar, aisap chon operi fanü. ");
INSERT INTO chk_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Äm aia engol me ruoman pwipwi nöün eman chök sam. Eman a mäla, nge ewe setipütür a chüen nom ren saman lon ewe fanü Kanaan.’ ");
INSERT INTO chk_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Iwe, ewe mwän, i samolun ewe fanü, a pälüenikem, ‘Iei usun üpwe alletä ika ämi aramas wenechar. Oupwe likitala rei eman pwimi, nge ämi kewe lusun oupwe feila o uwala wiich ren ämi famili mi echik. ");
INSERT INTO chk_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Iwe, oupwe uwato rei pwimi we setipütür. Mürin üpwe wesewesen silei pwe ämi sap chon operi fanü, nge ämi aramas wenechar. Iwe, ngang üpwe pwal aliwini ngenikemi pwimi ei, nge ämi oupwe tongeni kamö mine oua mochen lon ei fanü.’” ");
INSERT INTO chk_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Iwe, lupwen ra ninätiu ar kewe tuk, iteiten eman me eman a nom an tükütükün moni lon. Nge lupwen ir me semer we ra küna ekewe tükütükün moni, ra fokun niuokus. ");
INSERT INTO chk_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Mürin, Jakop semer we a kapas ngeniir, “Ämi oua angei seniei nei kana: Josef ese chüen nom, pwal Simeon ese chüen nom. Nge iei oua pwal mochen uwala Peniamin. Esap chüen ki ngeniei ei riaföü.” ");
INSERT INTO chk_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nge Rupen a üreni saman we, “Kopwe niela nei kewe ruoman ät, ika ngang üsap aliwinato Peniamin reöm. Kopwe lükü ngeniei pwe üpwe tümwünü, üpwe pwal aliwinato reöm.” ");
INSERT INTO chk_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nge Jakop a apasa, “Nei esap fokun etikemiila, pun pwin a mäla, nge i chök a lusun. Pun are och feiengau epwe tori i won alen ämi sai, oupwe atolongaei fän mökürei mi üwan lon lenien sotup ren ai letipeta.” ");
INSERT INTO chk_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Iwe, ewe lengita a fokun watte won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Nge lupwen a itela enen än ewe familien Jakop mongö ra kamö lon Isip, Jakop a üreni nöün kewe, “Oupwe liwinsefälila Isip o kamö ekis anach mongö.” ");
INSERT INTO chk_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nge Juta a üreni, “Ewe mwän a fokun kapas pöchökül ngenikem pwe aisap küna mesan, are pwim we esap etikem. ");
INSERT INTO chk_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Are kopwe tinikeemila me Peniamin, aipwe feila o kamö anom mongö. ");
INSERT INTO chk_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nge are kosap mwütala, aisap feila, pun ewe mwän a kapas ngenikem pwe aisap küna mesan, are pwim we esap etikem.” ");
INSERT INTO chk_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Iwe, Israel a ais, “Pwota oua atoto woi ei riaföü ren ämi asile ngeni ewe mwän pwe mi pwal wor eman pwimi?” ");
INSERT INTO chk_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nge ra pälüeni, “Ewe mwän a ais tichik usum me usun äm kewe famili. A pwal ais, ‘Ifa usun sememi, a chüen manau? A pwal wor eman pwimi?’ Äm aia chök pälüeni an kewe kapas ais. Ifa usun, ren met aia tongeni silei, pwe epwe allük ngenikem pwe aipwe uwala pwim?” ");
INSERT INTO chk_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Iwe, Juta a üreni Israel saman we, “Kopwe mwüt ngeniei ewe ät pwe epwe etiei. Iwe, aipwe müttir feila pwe äm meinisin me en pwal tori nöüm kewe kükün sipwe manau, nge sisap mäla ren ei echik. ");
INSERT INTO chk_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ngang üpwe pwon fän itan pwe üpwe siwili. Kopwe echimwa seniei mön manauan. Nge are üsap aliwinato reöm lon an pöchökül, epwe ukei chök tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Iei äm aia fen mang. Nge are aipwe müttir feila, iei aipwe le fen liwinto fän aruuan.” ");
INSERT INTO chk_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Mürin, semer we a üreniir, “Are a ina usun, oupwe angei ekoch seni ekewe uän irä mi mürina seni lon ei fanü o uwalong lon ämi kewe tuk, pwe oupwe eäni lifang ngeni ewe mwän. Oupwe uwala ekis lö mi pwokus, ekis chönün chunen, irä mi mwiik, säfei mi aüchea itan mör, pwal ekoch föün irä iter pistachio me almont. ");
INSERT INTO chk_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nge oupwe pwal uwala en me an ruu tükütükün moni pwe oupwe aliwinala ewe moni oua küna leawen ämi kewe tuk. Eli eman a chök rukala. ");
INSERT INTO chk_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Iwe, oupwe pwal uwala pwimi o müttir feila ren ewe mwän. ");
INSERT INTO chk_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Amwo ewe Kot mi Unusen Manaman epwe föri pwe ewe mwän epwe ümöümöch ngenikemi, pwe epwe aliwini ngenikemi pwimi Simeon me Peniamin. Nge are ese chüen wor nei, iwe, sipwe fetei.” ");
INSERT INTO chk_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Iei mine nöün Jakop kewe mwän ra angei ekewe lifang me en me an ruu tükütükün moni. Iwe, ra saila Isip, nge Peniamin a etiir. Nge lupwen ra tori, ra tolong ren Josef o ütä mwan. ");
INSERT INTO chk_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Nge lupwen Josef a küna pwe Peniamin a etiir, a kapas ngeni nöün we chon angang mi tümwünü imwan, “Kopwe etiwa ekewe mwän lon imwei, kopwe pwal ni eman man o amoota fitukan, pun ekewe mwän repwe etiei le mongön leoloas.” ");
INSERT INTO chk_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Iwe, ewe chon angang a föri usun mine Josef a allük ngeni o emwenala ekewe mwän lon imwen Josef. ");
INSERT INTO chk_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nge ekewe mwän ra fokun niuokus, pun ra emwenirela lon imwen Josef. Iwe, ra kapasfengen lefiler, “Ra chök emwenikicheto ikei pokiten ewe moni ra uwalong lon ach kewe tuk lon aeuin ach feito, pwe epwe wor popun an atipisikich o nöünikich chon angang me nöüch kewe aas.” ");
INSERT INTO chk_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Iwe, ra etto ren ewe chon angang mi tümwünü imwen Josef o kapas ngeni me lon ewe asamalap, ");
INSERT INTO chk_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Amusala äm samol, aia fen feito fän eu pwe aipwe kamö mongö. ");
INSERT INTO chk_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Nge lupwen aia tori ewe leni ia aipwe möür ie o sukala äm kewe tuk, iteiten eman me eman leim a küna an moni leawen an tuk. Nge äm moni a chüen unus. Iei mine aia aliwinisefälieto. ");
INSERT INTO chk_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nge iei aia pwal uwato moni lükün ewe, pwe aipwe kamö enem. Äm aisap silei iö a uwalong äm we moni lon äm kewe tuk.” ");
INSERT INTO chk_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Iwe, ewe chon angang a pälüeni, “Oupwe kinamwe, nge ousap niuokus, pun ämi we Kot me än sememi we Kot a fang ngenikemi ewe moni lon ämi kewe tuk, pwe ämi moni a toriei.” Mürin a emwenawu Simeon rer. ");
INSERT INTO chk_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nge ewe chon angang a etiwa ekewe mwän lon imwen Josef, a ngeniir koluk pwe repwe talü pecher o amongöü nöür kewe aas. ");
INSERT INTO chk_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mürin ra amolätä ar kewe lifang pwe repwe ngeni Josef, lupwen epwe war leoloas, pun ra rong pwe repwe mongö ren. ");
INSERT INTO chk_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Iwe, lupwen Josef a liwinto lon imwan, ra uwalong ren ekewe lifang ra uwei o chapetiu lepwül me mwan. ");
INSERT INTO chk_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nge Josef a aisiniir usun nonomur, mürin a pwal ais, “Ifa usun, a chüen pöchökül sememi we ewe chinlap oua fen kapas usun me mwan? Ifa usun, a chüen manau?” ");
INSERT INTO chk_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Iwe, ra pälüeni, “Semem noum we chon angang a chüen manau o pöchökül. Iwe, ra chapetiu me mwan fän chomong. ");
INSERT INTO chk_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Iwe, lupwen Josef a chimwetä, a küna Peniamin pwin we nöün inan o ais, “Ifa usun, iei i pwimi we setipütür oua fen kapas ngeniei usun? Kot epwe ümöümöch ngonuk, nei.” ");
INSERT INTO chk_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Mürin, Josef a müttir sap seniir, pun lelukan a fokun mwökütüküt ren an tongei pwin we. Iwe, a kütta ekis ia epwe kechü ie. Iei mine a tolong lon rumwan o kechü. ");
INSERT INTO chk_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mürin a oresi won mesan o towu, nge a apwosu an kechü o üra pwe repwe uwato mongö. ");
INSERT INTO chk_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Iwe, ekewe chon angang ra aimwüela enen Josef, enen pwin kewe pwal enen ekewe chon Isip ra eti Josef le mongö. Pun ekewe chon Isip resap mochen mongö ngeni chon Ipru, pokiten ra fokun anioputeer. ");
INSERT INTO chk_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Iwe, ra amota ekewe pwipwi lon en me tettelin ierin manauan mwen Josef, seni ewe mwänichi tori ewe setipütür. Iwe, ra fokun weitifengeniir usun. ");
INSERT INTO chk_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Iwe, ra angei wiser mongö seni än Josef chepel, nge Peniamin a angei limu wisan. Iwe, ra ünüfengen o pwapwafengen me Josef. ");
INSERT INTO chk_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Iwe, Josef a allük ngeni nöün we chon angang mi tümwünü imwan, “Kopwe amasoua än ekewe mwän tuk ngeni mongö won ükükün met ra tongeni uwala. Kopwe pwal uwalong nöür kewe moni meinisin leawen ar kewe tuk. ");
INSERT INTO chk_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nge kopwe uwalong ai we kap, ewe kap silifer, leawen än ewe setipütür tuk, pwal ewe moni fän iten ewe wiich.” Iwe, ewe chon angang a föri usun mine Josef a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Iwe, lesosorusich ra tinala ekewe mwän me nöür kewe aas. ");
INSERT INTO chk_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nge lupwen resamwo toau seni ewe telinimw, Josef a üreni nöün we chon angang mi tümwünü imwan, “Kopwe müttir tapweri ekewe mwän. Nge lupwen kopwe toriir, kopwe kapas ngeniir, ‘Pwota oua liwini ngau ngeni mürina? Pwota oua soläni än ai samol we kap silifer? ");
INSERT INTO chk_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Sap iei ewe kap ai samol a akaea le ün, a pwal akaea le asisil? Ämi oua fokun föföringau.’” ");
INSERT INTO chk_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Iwe, lupwen ewe chon angang a toriir, a chök apasa ekewe kapas Josef a aiti ngeni. ");
INSERT INTO chk_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nge ra üreni, “Pwota ka eäni ei sokun fos, äm samol? Äm noum chon angang aisap fokun föri ei sokun föför! ");
INSERT INTO chk_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ka silei pwe aia fen aliwinato reöm seni ewe fanü Kanaan ewe moni aia küna leawen äm kewe tuk. Pwota äm aipwe tongeni soläni seni imwen om samol silifer ika kolt? ");
INSERT INTO chk_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Are ka küna ewe kap ren eman lein äm noum chon angang, ätewe epwe le mäla. Nge äm meinisin kopwe nöünikem amanau.” ");
INSERT INTO chk_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iwe, ewe chon angang a üreniir, “Ewer, epwe ina usun mine oua apasa. Ewe eman ngang üpwe küna me ren ewe kap, i chök üpwe nöüni amanau, nge ämi lusun ousap tipis.” ");
INSERT INTO chk_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mürin ra müttir en me ekietiu an tuk lepwül o sukala. ");
INSERT INTO chk_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Iwe, nöün Josef we chon angang a küttafichi ewe kap. A popuetä me ren än ewe mwänichi tuk o ükütiu me ren ewe setipütür. Iwe, a küna ewe kap me lon än Peniamin tuk. ");
INSERT INTO chk_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Iwe, ra kamwei üfer fän ar letipeta. Mürin ra en me ekietä an tuk won nöün aas o liwiniti ewe telinimw. ");
INSERT INTO chk_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Iwe, lupwen Juta me pwin kewe ra tori imwen Josef, ätewe a chüen nom. Iwe, ra chapala lepwül me mwan. ");
INSERT INTO chk_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nge Josef a aisiniir, “Pwota oua föri ei sokun föför? Ifa usun, ämi ousap silei pwe ngang eman mwän mi tongeni asisilätä mettoch?” ");
INSERT INTO chk_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Mürin, Juta a pälüeni, “Met aipwe tongeni ürenuk, äm samol? Met aipwe pälüeni? Ren met äm aipwe tongeni alletä äm pwüngüöch? Kot a pwärawu äm pwüngingau. Äm meinisin kopwe nöünikem amanau, sap chök ätewe ka küna me ren ewe kap.” ");
INSERT INTO chk_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Nge Josef a üreniir, “Esap ina, üsap föri iei usun. Ewe eman üa küna me ren ewe kap, i chök epwe nei amanau. Nge ämi kewe lusun oupwe liwiniti sememi fän kinamwe.” ");
INSERT INTO chk_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Iwe, Juta a kanoto ren Josef o üreni, “Ai samol, kose mochen kopwe mwüt ngeniei ngang noum chon angang pwe üpwe apasätä och kapas ngonuk. Kose mochen kosap song ngeniei, pun en ka wewe chök me Farao. ");
INSERT INTO chk_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ai samol, ka aisinikem äm noum chon angang, ‘Ifa usun, a chüen manau sememi? A pwal wor pwimi?’ ");
INSERT INTO chk_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Lon ena fansoun äm aia pälüenuk, ‘Ewer, a chüen manau semem, nge a chinlap. A pwal wor eman pwim we setipütür, semem a nöüni lon an chinlap. Iwe, pwin ewe setipütür a mäla, nge ese chüen wor eman nöün inan pwe i chök. Iwe, saman we a fokun tongei.’ ");
INSERT INTO chk_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mürin ka ürenikem pwe aipwe uwato reöm pwim we pwe kopwe küna. ");
INSERT INTO chk_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nge äm aia ürenuk, äm samol, ‘Ewe ät esap tongeni likitala saman, pun are epwe likitala, saman we epwe mäla.’ ");
INSERT INTO chk_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mürin, ka ürenikem äm noum kei chon angang, ‘Ousap chüen tongeni küna mesei, are ousap uwato pwimi we setipütür rei.’ ");
INSERT INTO chk_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nge lupwen äm aia liwinla ren semem noum we chon angang, aia asile ngeni alom kewe. ");
INSERT INTO chk_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mürin, semem we a ürenikem, ‘Oupwe liwinsefälila Isip pwe oupwe kamö ekis anach mongö.’ ");
INSERT INTO chk_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nge äm aia üreni, ‘Äm aisap tongeni feila. Are pwim we setipütür epwe etikem, aipwe feila. Pun aisap tongeni küna mesen ewe mwän, are pwim we setipütür esap etikem.’ ");
INSERT INTO chk_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mürin, semem noum we chon angang a ürenikem, ‘Oua silei pwe Rahel pwülüei we a chök nöüni ngeniei ruoman ät. ");
INSERT INTO chk_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Iwe, eman a feil seniei, nge oua apasa pwe eman manmwacho a atatakisi inisin, pun üse chüen küna me mürin. ");
INSERT INTO chk_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Iwe, are oua pwal angei seniei ei ät, nge och feiengau epwe tori, oupwe atolongaei fän mökürei mi üwan lon lenien sotup ren ai letipeta.’ ");
INSERT INTO chk_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Are üpwe liwiniti semei noum we chon angang, nge ewe ät esap etikem, epwe fokun mäla, ");
INSERT INTO chk_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","lupwen epwe küna pwe ewe ät esap etikem. Pun manauen semei we a riri ngeni manauen ewe ät. Iwe, äm noum chon angang kana aipwe atolonga semem noum we chon angang fän möküran mi üwan lon lenien sotup ren an letipeta. ");
INSERT INTO chk_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Pun ngang noum chon angang üa pwon ngeni semei we fän iten ewe ät. Üa apasa ngeni pwe are üsap aliwinato ren ei ät, epwe ukei chök lon unusen manauei me fän mesen semei. ");
INSERT INTO chk_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Iei mine kose kan mochen kopwe mwüt ngeniei ngang noum chon angang, pwe üpwe le siwili ei ät pwe kopwe nöüniei amanau. Kopwe pwal mwüt ngeni ei ät pwe epwe liwiniti saman we fiti pwin kewe. ");
INSERT INTO chk_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Pun ifa usun ai üpwe tongeni liwiniti semei, are ewe ät esap etiei? Üsap tongeni küna ewe riaföü epwe tori semei.” ");
INSERT INTO chk_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Mürin, Josef esap chüen tongeni aposalong an kechü fän mesen chokewe mi ü arun. Iwe, a kökkö, “Aramas meinisin repwe towu seni ikei!” Iei mine esap wor eman a nom ren Josef, lupwen a pwäri i ngeni pwin kana. ");
INSERT INTO chk_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Iwe, a fokun leüömong le kechü pwe ekewe re Isip me chon leimwen Farao ra rong. ");
INSERT INTO chk_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Mürin, Josef a üreni pwin kewe, “Ngang Josef. Ifa usun, semei a chüen manau?” Nge pwin kewe resap tongeni pälüeni, pun ra fokun rükö ren. ");
INSERT INTO chk_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Iwe, Josef a kapas ngeni pwin kewe, “Ouse mochen oupwe kineto rei.” Iwe, ra kineto ren. Nge Josef a apasa, “Ngang pwimi Josef, ätewe oua amömöla Isip. ");
INSERT INTO chk_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Iwe, ousap aürek ren, ousap pwal tekitekila ren ämi amömöeila ikei, pun Kot a tinieito mwemi pwe üpwe amanaua aramas. ");
INSERT INTO chk_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Pun ruu ier a fis lengita lon ei fanü. Nge pwal limu ier repwe feito esap fis angangen fofot are kinikin lor. ");
INSERT INTO chk_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Iwe, Kot a tinieito mwemi pwe üpwe amanauakemi ren ei angang mi amwarar o föri met ämi me mwirimwirimi kana oupwe manau ren. ");
INSERT INTO chk_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Iei mine sap ämi oua tinieito ikei, pwe Kot. Iwe, Kot a awisaei pwe ngang üpwe eman sam ngeni Farao, üpwe pwal samolun unusen imwan o nemeni unusen ei fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Oupwe kaila ren semei we o asile ngeni pwe iei alon Josef nöün we, ‘Kot a seikieitä pwe üpwe samolun unusen ei fanü Isip. Kopwe feito rei, nge kosap mang. ");
INSERT INTO chk_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kopwe nonom lon ewe fanü Kosen pwe kopwe arap ngeniei, en me noum me nöün noum kewe, pwal noum sip me kow me meinisin mine ka eäni. ");
INSERT INTO chk_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Are ka nom lon Kosen, üpwe tongeni tümwünuk. Pun limu ierin lengita repwe pwal feito, nge üsap mochen pwe en me chon leimwom me noum kewe man oupwe echik.’ ");
INSERT INTO chk_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Nengeni, oua püsin küna, pwal en pwii Peniamin ka küna pwe püsin ngang üa fos ngenikemi. ");
INSERT INTO chk_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Oupwe fokun apworausa ngeni semei usun ai nemenem lon Isip, pwal usun meinisin mine oua küna. Oupwe kaila o uwato semei ikei.” ");
INSERT INTO chk_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Mürin, Josef a romi Peniamin o kechü won üan, nge Peniamin a pwal kechü won üen Josef. ");
INSERT INTO chk_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Iwe, a pwal mitiri pwin kewe meinisin nge kechü. Mürin, pwin kewe ra kapas ngeni. ");
INSERT INTO chk_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Iwe, lupwen ei pworaus a tori imwen Farao pwe pwin Josef ra war, Farao me nöün kewe nöüwis ra fokun pwapwa ren. ");
INSERT INTO chk_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Iwe, Farao a üreni Josef, “Kopwe üreni pwiüm kewe pwe repwe isetä ar kewe pisek won nöür kewe aas o liwiniti ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Repwe uwato semer me chon leimwer meinisin o feito rei. Iwe, ngang üpwe ngeniir eu fanü mi fokun mürina me lon ei fanü, pwe epwe wor ener mongö mi mürina me lon ei fanü. ");
INSERT INTO chk_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kopwe pwal üreniir pwe repwe uwala woken seni ei fanü Isip, pwe wän nöür semirit me pwülüer. Repwe pwal uwato semer we o feito meinisin. ");
INSERT INTO chk_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Resap lolileniti pisekir repwe likitala, pun öchün pisekin unusen ei fanü Isip repwe pisekini.” ");
INSERT INTO chk_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Iwe, nöün Israel kewe ra föri iei usun. Nge Josef a ngeniir woken usun alon Farao ngeni, a pwal ngeniir amötür. ");
INSERT INTO chk_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Iwe, a pwal ngeni eman me eman leir echö üf mi lingöch, nge a ngeni Peniamin ülüpükü föün moni silifer me limachö üf mi lingöch. ");
INSERT INTO chk_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Nge a tinala ren saman engol aas mi uwou pisek mi mürina seni Isip, pwal engol liefefinin aas mi uwou föün wiich, pilawa me ekoch mongö fän iten an sai. ");
INSERT INTO chk_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Mürin a afeilai pwin kewe. Nge mwen ar feila, a fönöör, “Ousap aninifengen won al.” ");
INSERT INTO chk_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Iwe, ra feila seni Isip o liwiniti ewe fanü Kanaan ren semer we Jakop. ");
INSERT INTO chk_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Iwe, ra asile ngeni, “Josef a chüen manau. A samolun unusen ewe fanü Isip.” Nge leluken Jakop esap mwökütüküt ren, pun esap tongeni lükü ar kapas. ");
INSERT INTO chk_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nge lupwen ra apworausa ngeni meinisin mine Josef a üreniir, a pwal küna ekewe woken Josef a tinato ren pwe epwe wawa, iwe, leluken Jakop semer we a manauala. ");
INSERT INTO chk_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Iwe, Israel a apasa, “Iei üa lükülük. Josef nei we a chüen manau. Üpwe feila o nengeni mwen ai üpwe mäla.” ");
INSERT INTO chk_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Iwe, Israel a alükülükü an pisek meinisin o popuetä an sai. Nge lupwen a tori Peersepa, a asor ngeni än saman Isaak we Kot. ");
INSERT INTO chk_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Iwe, Kot a kapas ngeni Israel lon künan lepwin, “Jakop, Jakop.” Nge a üra, “Ngang iei.” ");
INSERT INTO chk_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Iwe, Kot a üreni, “Ngang Kot, än semom we Kot. Kosap niuokus le feila Isip, pun ikenan üpwe föri senuk eu mwü mi fokun watte. ");
INSERT INTO chk_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ngang üpwe etukela Isip, nge üpwe pwal aliwinato mwirimwirum kana lon ei fanü. Iwe, Josef epwe amääk me lon Isip.” ");
INSERT INTO chk_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Mürin, Jakop a feila seni Peersepa. Iwe, nöün kewe mwän ra uwala Jakop semer we me nöür semirit pwal pwülüer won ekewe woken, Farao a tinala ren pwe epwe wawa. ");
INSERT INTO chk_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Iwe, ra pwal uwala nöür pwin man me ar pisek meinisin ra eäni me lon ewe fanü Kanaan o feila Isip. ");
INSERT INTO chk_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Iwe, Jakop a uwala Isip mwirimwirin kana meinisin: nöün mwän pwal nöün nöün kewe mwän, nöün fefin pwal nöün nöün kewe fefin. ");
INSERT INTO chk_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ikkei iten ekewe mwirimwirin Jakop mi eti le feila Isip: Rupen nöün Jakop we mwänichi. ");
INSERT INTO chk_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Nge nöün Rupen kewe mwän: Hanok, Pallu, Hesron me Karmi. ");
INSERT INTO chk_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon me nöün kewe mwän: Jemuel, Jamin, Ohat, Jakin, Sohar me Shaul nöün eman fin Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lefi me nöün kewe mwän: Kerson, Kohat me Merari. ");
INSERT INTO chk_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juta me nöün kewe mwän: Er, Onan, Shela, Peres me Sera. Nge Er me Onan ra fen mäla lon ewe fanü Kanaan. Iwe, nöün Peres kewe mwän: Hesron me Hamul. ");
INSERT INTO chk_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar me nöün kewe mwän: Tola, Puwa, Jashup me Shimron. ");
INSERT INTO chk_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sepulon me nöün kewe mwän: Seret, Elon, Jaleel. ");
INSERT INTO chk_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ir meinisin nöün Jakop kewe mwän, pwal Tina nöün we fefin Lea a nöüni me won lon Mesopotamia. Iwe, iteiten mwirimwirin meinisin me won Lea ilik me ülüman. ");
INSERT INTO chk_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Iwe, Kat me nöün kewe mwän: Sifion, Hakki, Shuni, Espon, Eri, Aroti me Areli. ");
INSERT INTO chk_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser me nöün kewe mwän: Imna, Ishwa, Ishwi, Peria me Sera fefiner we. Nge nöün Peria kewe mwän: Heper me Malkiel. ");
INSERT INTO chk_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ikkei ir mwirimwirin Jakop a nöüni me won Silpa ewe chon angang Lapan a ngeni Lea nöün we fefin, iteiter meinisin engol me wonoman. ");
INSERT INTO chk_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Iwe, nöün Rahel kewe mwän pwülüen Jakop we: Josef me Peniamin. ");
INSERT INTO chk_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Nge Asenat nöün Potifera, ewe souasoren On, a nöüni me won Josef Manasa me Efraim lon ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Nge nöün Peniamin kewe mwän: Pela, Peker, Ashpel, Kera, Naaman, Ehi, Rosh, Muppim, Huppim me Art. ");
INSERT INTO chk_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ikkei ir mwirimwirin Jakop a nöüni me won Rahel, iteiter meinisin engol me föman. ");
INSERT INTO chk_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Iwe, Tan me nöün mwän: Hushim. ");
INSERT INTO chk_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali me nöün kewe mwän: Jaseel, Kuni, Jeser me Shillem. ");
INSERT INTO chk_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ikkei ir mwirimwirin Jakop kewe, a nöüni me won Pila ewe chon angang Lapan a ngeni Rahel nöün we fefin, iteiter meinisin füman. ");
INSERT INTO chk_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Iwe, iteiten mwirimwirin Jakop meinisin ra etala Isip wone me wonoman, nge pwülüen nöün kewe mwän resap alea. ");
INSERT INTO chk_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Nge nöün Josef kewe mwän mi uputiu lon Isip ruoman. Iwe, kapachelapen chon leimwen Jakop meinisin ra feito Isip fik. ");
INSERT INTO chk_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iwe, Jakop a tinala Juta ren Josef pwe epwe akomwola mwan lon ewe fanü Kosen. Iwe, ra tori ewe fanü Kosen. ");
INSERT INTO chk_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Nge Josef a amolätä wan woken pwe epwe feila o churi Israel saman we lon Kosen. Iwe, lupwen a churi, a romi saman o kechü won üan fansoun langatam. ");
INSERT INTO chk_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Nge Israel a üreni Josef, “Iei üpwe tongeni mäla, pun üa küna mesom, üa pwal silei pwe ka chüen manau.” ");
INSERT INTO chk_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Mürin, Josef a üreni pwin kewe me chon leimwen saman meinisin, “Üpwe feila o asile ngeni Farao pwe pwii kewe me chon leimwen semei meinisin ra feito rei seni ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Üpwe asile ngeni pwe ämi chon fofol man, pun iei ämi angang seni me lom. Oua pwal uwato nöümi pwiin sip me kow me pisekimi meinisin. ");
INSERT INTO chk_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Nge lupwen Farao epwe körikemiito o ais, ‘Met ämi angang?’, ");
INSERT INTO chk_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","oupwe pälüeni pwe ämi chon fofol man seni ämi kükün tori ikenai, usun chök sememi kewe. Mürin epwe mwüt ngenikemi pwe oupwe nonom lon ewe fanü Kosen. Pun chon Isip ra anioputäsini chon fofol man.” ");
INSERT INTO chk_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Iwe, Josef a feila ren Farao o üreni, “Semei me pwii kewe ra feito seni ewe fanü Kanaan fiti nöür pwiin sip me kow me pisekir meinisin. Iei ra nonom lon ewe fanü Kosen.” ");
INSERT INTO chk_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Josef a pwal angei liman me lein pwin kewe o emwenireto fän mesen Farao. ");
INSERT INTO chk_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Iwe, Farao a aisini pwin Josef kewe, “Met ämi angang?” Nge ir ra pälüeni, “Äm noum kei chon angang aia chon fofol man usun chök semem kewe.” ");
INSERT INTO chk_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Iwe, ra pwal üreni Farao, “Äm aia etto pwe aipwe nonom lon ei fanü, pun ewe lengita a fokun chouiti ewe fanü Kanaan, pwe esap wor fetil fän iten nöüm kewe pwiin man. Iei mine aia tüngor ngonuk, kopwe mwüt ngenikem pwe aipwe nonom lon ewe fanü Kosen.” ");
INSERT INTO chk_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Mürin, Farao a üreni Josef, “Semom me pwiüm kewe ra feito reöm. ");
INSERT INTO chk_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ewe fanü Isip a mwümwü ngonuk. Kopwe alenia semom me pwiüm kewe lon ewe fanü Kosen, ewe fanü mi mürina seni meinisin. Nge are ka silei ekoch me leir mi lipwäköch le fofol man, kopwe awisa ngeniir pwe repwe foleni nei pwiin man.” ");
INSERT INTO chk_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Mürin, Josef a pwal panalong Jakop saman we pwe epwe ütä fän mesen Farao. Iwe, Jakop a afeiöchü Farao. ");
INSERT INTO chk_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Nge Farao a aisini Jakop, “Fite ükükün ierin manauom?” ");
INSERT INTO chk_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Iwe, Jakop a pälüeni, “Ierin ai siamüfetal ipükü ilik. A chokükün ierin manauei, a pwal aweires, nge esap tori ükükün ierin manauen semelapei kewe lon ar siamüfetal.” ");
INSERT INTO chk_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Mürin, Jakop a afeiöchü Farao o feila seni. ");
INSERT INTO chk_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iwe, Josef a alenia saman me pwin kewe o ngeniir eu fanü mi mürina seni meinisin lon Isip pwe repwe fanüeni, usun Farao a allük. Iwe, a ngeniir ewe fanü Rameses. ");
INSERT INTO chk_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nge Josef a amongöü saman me pwin kewe me chon leimwen saman meinisin aükük ngeni iteiter. ");
INSERT INTO chk_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nge lon ewe fansoun esap chüen wor mongö lon unusen ewe fanü, pun ewe lengita a fokun chou. Iwe, chon ewe fanü Isip me Kanaan ra apwangapwangala ren ewe lengita. ");
INSERT INTO chk_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Iwe, Josef a ionifengeni ewe moni meinisin, pun aramasen ewe fanü Isip me Kanaan ra möni ngeni ener wiich. Iwe, Josef a iseni ewe moni lon imwen Farao. ");
INSERT INTO chk_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Nge lupwen a itela nöün ekewe aramasen Isip me Kanaan moni, chon Isip meinisin ra feito ren Josef o üreni, “Kose mochen kopwe ngenikem enem mongö. Kopwe alisikem pwe aisap mäla. Ese chüen wor nöüm moni.” ");
INSERT INTO chk_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Nge Josef a pälüeniir, “Are esap chüen wor nöümi moni, oupwe ngeniei nöümi man, nge ngang üpwe ngenikemi mongö.” ");
INSERT INTO chk_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Iei mine ra uwato nöür man ren Josef. Nge Josef a siwili ngeni mongö ekewe oris, pwiin sip me kow, pwal ekewe aas. Iwe, a ngeniir mongö siwilin nöür kewe man lon ewe ier. ");
INSERT INTO chk_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nge lupwen ewe ier a la, ekewe chon Isip ra pwal feito ren Josef o apasa, “Aisap mochen tükümi senuk, äm samol, pwe nöüm moni a itela. Nge ka pwal nöüni nöüm pwiin man. Ese chüen wor och lusun aipwe tongeni ngonuk pwe inisim chök me fanüem. ");
INSERT INTO chk_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kopwe alisikem pwe aisap mäla, nge fanüem esap feiengau. Kopwe mönikem me fanüem pwe siwilin enem mongö. Iwe, Farao epwe nöünikem amanau, epwe pwal fanüeni fanüem. Kose mochen kopwe ngenikem wiich pwe aipwe manau, pwal fotäm föün irä, pwe aipwe fotuki ewe fanü pwe esap pön.” ");
INSERT INTO chk_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Iei mine Josef a möni unusen ewe fanü Isip fän iten Farao. Pun chon Isip meinisin ra amömöla fanüer pokiten ewe lengita a fokun chouitiir. Iei usun Farao a fanüeni unusen ewe fanü. ");
INSERT INTO chk_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mürin, Josef a asilefeili lon unusen ewe fanü Isip pwe ekewe aramas repwe nöün Farao amanau. ");
INSERT INTO chk_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Iwe, fanüen ekewe souasor chök esap möni, pun wiser me ren Farao. Ra manau seni wiser kewe Farao a ngeniir, iei mine resap amömöla fanüer. ");
INSERT INTO chk_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Iwe, Josef a kapas ngeni ekewe aramas, “Nengeni, ikenai üa mönikemi me fanüemi fän iten Farao. Iei oupwe angei ekei föün irä pwe oupwe fotuki ei fanü. ");
INSERT INTO chk_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nge lupwen fansoun kinikin oupwe ngeni Farao eu lelimu, nge rüanü lelimu oupwe püsin eäni, pwe epwe wor fotämi me enemi pwal enen chon leimwemi me nöümi semirit.” ");
INSERT INTO chk_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Iwe, ra apasa, “En ka amanauakem. Äm samol, kose mochen kopwe kirikiröch ngenikem. Farao epwe nöünikem amanau.” ");
INSERT INTO chk_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Iei mine Josef a föri eu allük usun ewe fanü Isip, a chüen fis tori ikenai, pwe Farao epwe angei eu lelimu seni uän fotar irä. Nge fanüen ekewe souasor chök Farao esap angei. ");
INSERT INTO chk_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Iwe, ekewe chon Israel ra nonom lon Isip lon ewe sop itan Kosen. Iwe, ra pisekisekila ikenan, ra aupwuretiu o fokun chomongola. ");
INSERT INTO chk_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iwe, Jakop a manau lon ewe fanü Isip lon ükükün engol me fisu ier, pwe unusen ierin manauen Jakop ipükü faik me fisu. ");
INSERT INTO chk_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Nge lupwen a arap fansoun än Israel epwe mäla, a körato Josef nöün we o üreni, “Are üa küna cheni me reöm, kopwe sökalong poum fän aföi o pwon ngeniei pwe kopwe kirikiröch o tipelükülük ngeniei. Kosap peiaseniei lon Isip, ");
INSERT INTO chk_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","nge kopwe uweeila seni Isip pwe üpwe peias lon lenien peiasen semei kewe.” Iwe, Josef a apasa, “Üpwe föri mine ka üreniei.” ");
INSERT INTO chk_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Nge Jakop a apasa, “Kopwe akapel ngeniei pwe kopwe föri ei.” Iwe, Josef a akapel ngeni. Mürin, Israel a iotekin kilisou won an peet. ");
INSERT INTO chk_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ekoch fansoun mürin ra asile ngeni Josef, “Semom a samau.” Iei mine Josef a angei nöün kewe ruoman ät iter Manasa me Efraim o uweerela ren. ");
INSERT INTO chk_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Lupwen ra asile ngeni Jakop pwe Josef nöün we a feito ren, a achocho ngeni an epwe mot won an peet. ");
INSERT INTO chk_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Iwe, Jakop a üreni Josef, “Ewe Kot mi Unusen Manaman a pwä ngeniei me lon Lus lon ewe fanü Kanaan o afeiöchüei. ");
INSERT INTO chk_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Iwe, a kapas ngeniei, ‘Üpwe aupwuk o achomongok pwe kopwe wiliti eu mwichen aramas mi chomong, üpwe pwal ngeni mwirimwirum kana ei fanü pwe repwe fanüeni tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Iwe, noum kana ruoman ät ra uputiu ngonuk me lon ei fanü Isip mwen ai feito lon ei fanü, ir nei. Efraim me Manasa üpwe fokun nöüniir usun chök Rupen me Simeon. ");
INSERT INTO chk_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nge ekewe mi uputiu müriir en kopwe nöüni. Ir repwe wiseni wisen Manasa me Efraim. ");
INSERT INTO chk_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Iwe, lupwen üa saito seni Mesopotamia, nge üsamwo arap ngeni Efrat, Rahel a mäla lon ewe fanü Kanaan. Üa fokun letipeta ren mälan Rahel. Iwe, üa peiaseni lükün ewe al a ale ngeni Efrat, a pwal iteni Petleem.” ");
INSERT INTO chk_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Nge lupwen Israel a küna nöün Josef kewe ät, a ais, “Nöün iö ätekei?” ");
INSERT INTO chk_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Iwe, Josef a üreni saman we, “Ir nei, Kot a ngeniei me lon ei fanü.” Nge Israel a apasa, “Kose mochen kopwe emwenireto pwe üpwe afeiöchüür.” ");
INSERT INTO chk_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Nge mesen Israel a toputop pokiten an chinlap, pwe esap chüen tongeni künaöchü. Iwe, Josef a uweereto ren saman, nge Jakop a romiir o mitiriir. ");
INSERT INTO chk_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Iwe, Israel a üreni Josef, “Üsap fokun ekieki pwe üpwe chüen küna mesom. Nge nengeni, Kot a mwüt ngeniei pwe üpwe pwal küna noum kei ät.” ");
INSERT INTO chk_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mürin, Josef a angeir me won afön Israel o chapetiu lepwül. ");
INSERT INTO chk_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Iwe, Josef a amwöchü pöür me ruoman o anomu Efraim pelimöngün Israel, nge Manasa a anomu pelifichin. Iwe, ekewe ruoman ät ra kineto ren. ");
INSERT INTO chk_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Nge Israel a afangara pöün o isetä pöüifichin won möküren Efraim ewe mi kis, nge pöüimöngün a isetä won möküren Manasa ewe mwänichi. ");
INSERT INTO chk_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Mürin a afeiöchü Josef o apasa, “Ewe Kot semelapei kewe Apraham me Isaak ra angang ngeni, ewe Kot mi emweniei lon unusen ränin manauei tori ikenai, ");
INSERT INTO chk_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","pwal ewe chon läng mi amanauaei seni feiengau meinisin epwe afeiöchü ekei ät. Iwe, repwe iteni itei me iten semelapei kewe Apraham me Isaak tori feilfeilachök, repwe pwal fokun chomongola won fanüfan. ");
INSERT INTO chk_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nge lupwen Josef a küna pwe saman a isetä pöüifichin won möküren Efraim, a oput. Iei mine a amwöchü pöün saman pwe itä epwe amwökütü seni won möküren Efraim o isetä won möküren Manasa. ");
INSERT INTO chk_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Iwe, a üreni saman, “Sap ina, semei, pun ätei ewe mwänichi. Kopwe isetä pöüifichum won möküran.” ");
INSERT INTO chk_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nge saman we esap tipeeu ngeni. Iei mine a apasa, “Nei, üa silei, üa silei. Manasa epwe pwal wiliti eu mwichen aramas, epwe pwal iteüöch. Nge pwin we mi kis epwe iteüöch seni, mwirimwirin kana repwe pwal wiliti chomong mwichen aramas.” ");
INSERT INTO chk_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Iwe, lon ewe chök ränin a afeiöchüür o apasa, “Chon Israel repwe eäni kapasen afeiöch itemi, pun repwe apasa, ‘Kot epwe föri ngonuk usun chök a föri ngeni Efraim me Manasa.’” Iei usun Jakop a akomwa Efraim mwen Manasa. ");
INSERT INTO chk_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Mürin, Israel a üreni Josef, “Nengeni, üpwe le mäla, nge Kot epwe etikemiila o aliwinikemiila lon fanüen semelapemi kewe. ");
INSERT INTO chk_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ngang üa ngonuk eu kinikinin fanü, nge üsap ngeni pwiüm kewe, ewe fanü üa angei seni chon Amor fän pöchökülen ai ketilas me ai likapich.” ");
INSERT INTO chk_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Iwe, Jakop a köri nöün kewe mwän o üreniir, “Oupwe mwicheto rei pwe üpwe asile ngenikemi mine epwe torikemi lon ekewe fansoun repwe feito. ");
INSERT INTO chk_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Oupwe chufengen o aüseling, ämi nei kana, oupwe aüselinga aloi. ");
INSERT INTO chk_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rupen, en nei mwänichi, ai tufich me akomwen ai pöchökül, ka fokun tekia lon om ling me om nemenem. ");
INSERT INTO chk_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nge ka mwökütüküt usun nonon leset. Kosap chüen tekia, pun ka kon ren ülüpwülüei. Ewer, ka alimengaua kiei ren om tolong lon. ");
INSERT INTO chk_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon me Lefi, ämi pwipwi. Oua eäni nöümi ketilas pisekin afeiengau. ");
INSERT INTO chk_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Üsap eti ämi mwichen pwüngüpwüng, üsap pwal choni ämi mwich. Pun lon ämi song oua niela mwän, oua pwal pwapwaiti le sorongauei ätemwänin kow. ");
INSERT INTO chk_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Üpwe anümamaua ämi song, pun a fokun chou. Üpwe pwal anümamaua ämi lingeringer, pun a ngau. Üpwe aimwüfesenikemi lon ewe fanüen Jakop o atoropasakemi lon Israel. ");
INSERT INTO chk_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juta, pwiüm kana repwe mwareituk. Poum epwe nonom won üen chon oputom, nge nöün semom kana repwe chapetiu mwom. ");
INSERT INTO chk_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juta, en eman apanen laion! Nei, ka fefeitä o pöchökülela ren liapom. Ka töpworo o konola usun chök eman laion, pwal usun chök eman liefefinin laion. Iö a pwora le apwökuk? ");
INSERT INTO chk_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Esap mwöküt senuk, Juta, ewe asisilen samol, nge mwirimwirum kana repwe nemenem fansoun meinisin tori epwe war ätewe mine an ewe nemenem. Iwe, chon ekewe mwü meinisin repwe aleasochis ngonuk. ");
INSERT INTO chk_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ka ri noum nienifön aas ngeni efoch irän wain mi mürina. Iwe, ka ötüüwelong üfom lon wain, üfom owokot ka ötüüwelong lon chönün uän wain. ");
INSERT INTO chk_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mesom ra parachol seni wain, nge ngiüm ra pwechepwech seni milik. ");
INSERT INTO chk_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sepulon, kopwe nonom aroset, nge arosetum epwe wiliti eu nomun ilen sip, kiännin fanüom epwe tori arun Siton. ");
INSERT INTO chk_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar, ka eman aas mi pöchökül, ka konetiu lefilen ekewe tuk man ra uwei. ");
INSERT INTO chk_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Iwe, lupwen ka küna pwe om lenien asösö a öch, ka pwal küna pwe ewe fanü a mürina, ka rotiu pwe kopwe uwou mettoch mi chou won afarom. Iwe, ka fangatä pwe kopwe angang usun eman amanau. ");
INSERT INTO chk_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Tan, kopwe souapwüng won aramasom usun chök ekewe lusun ainangen Israel. ");
INSERT INTO chk_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Tan, kopwe wewe ngeni eman serepenit lepekin al, eman serepenit mi fokun poison won al, a küw apilipilin pechen oris, pwe ewe mi wawa epwe seletä. ");
INSERT INTO chk_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ai Samol mi Lapalap, üa asüküsükü om kopwe amanauaei. ");
INSERT INTO chk_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kat, eu mwichen chon solä repwe fiu ngonuk, nge en kopwe kul o tapweriir fän pwora. ");
INSERT INTO chk_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, anom mongö epwe somwola, kopwe amwolätä mongö mi mürina, a fich ngeni enen king. ");
INSERT INTO chk_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali, ka wewe ngeni eman chia mi pichila, nge apanom ra fokun mürina. ");
INSERT INTO chk_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josef, ka wewe ngeni efoch irä mi ua, ka fot ünükün eu chanpupu, nge palom ra tori won tit. ");
INSERT INTO chk_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Chon likapich ra fokun maun ngonuk, ra likapichiik o ariaföüuk. ");
INSERT INTO chk_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nge om likapich a mei. Poum ra fokun lifech ren pöün än Jakop we Kot mi Manaman, ra pöchökül ren iten ewe Chon Mas, ewe Achauen Israel. ");
INSERT INTO chk_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Än semom we Kot epwe alisuk, ewe Kot mi Unusen Manaman epwe afeiöchuk ren feiöch seni läng, pwal ren ewe feiöch seni fän pwül. Kopwe feiöch ren chomong man me chomong semirit. ");
INSERT INTO chk_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Än semom we afeiöch a manaman seni än semelapei kewe afeiöch, a watte seni kiännin ekewe chuk mi nonom tori feilfeilachök. Ekei feiöch repwe nonom womw, en ewe mi imwü seni pwiüm kewe. ");
INSERT INTO chk_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Peniamin, ka eman wolif mi mwacho. Lesosor ka ochei liapom, nge lekuniol ka aineti lusun liapom.” ");
INSERT INTO chk_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Iei ekewe engol me ruu ainangen Israel, pwal iei usun mine semer we a üreniir, lupwen a afeiöchü eman me eman ren eu feiöch mi fich ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Mürin, Jakop a fönöü nöün kewe, “Iei üpwe le mäla o churi ai kewe lewo. Oupwe peiaseniei ren semei kewe lon ewe pwangen achau a nom lon ewe tanipin Efron ewe re Hit. ");
INSERT INTO chk_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ei pwangen achau a nom lon ewe tanipi Makpela ötiuen Mamre lon ewe fanü Kanaan, Apraham a mönifengeni me ewe tanipi seni Efron ewe re Hit, pwe an lenien peias. ");
INSERT INTO chk_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ikenan ra peiaseni Apraham me Sara pwülüan we, ra pwal peiaseni Isaak me Repeka pwülüan we. Iwe, ikenan ngang üa pwal peiaseni Lea. ");
INSERT INTO chk_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Iwe, iei ewe tanipi me ewe pwangen achau mi nom lon, Apraham a möni seni ekewe re Hit.” ");
INSERT INTO chk_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nge lupwen Jakop a awesala an fönöü nöün kewe mwän, a numätä pechen won an peet, mürin a müchüla ngasangasan. Iwe, a chufengen me an kewe lewo. ");
INSERT INTO chk_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Iwe, Josef a chapela won saman we, a kechü won o mitiri. ");
INSERT INTO chk_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mürin, Josef a allük ngeni nöün kewe chon angang mi sousäfei pwe repwe säfeeni saman. Iei mine ekewe sousäfei ra säfeeni Israel. ");
INSERT INTO chk_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Iwe, lupwen faik rän ra angang won, pun iei aükükün ränin ar angangen säfeeni. Nge chon Isip meinisin ra kechüeiti lon ükükün fik rän. ");
INSERT INTO chk_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Iwe, wesin ekewe ränin kechü, Josef a kapas ngeni nöün Farao nöüwis, “Are üa küna ümöümöch me remi, ouse mochen oupwe üreni Farao ai kei kapas. ");
INSERT INTO chk_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Lupwen semei we a arap ngeni an epwe mäla, a üreniei, pwe üpwe pwon fän akapel pwe üpwe peiaseni lon an we peias a püsin amolätä fän itan lon ewe fanü Kanaan. Iei mine üa tüngor ngonuk, pwe kopwe mwüt ngeniei pwe üpwe feila o peiaseni semei. Mürin üpwe liwinsefälito.” ");
INSERT INTO chk_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nge Farao a üreni, “Kopwe feila o peiaseni semom usun om pwon ngeni fän akapel.” ");
INSERT INTO chk_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Iwe, Josef a feila Kanaan pwe epwe peiaseni saman. Nge nöün Farao kewe nöüwis me ekewe meilapen chon leimwan pwal ekewe meilapen chon Isip meinisin ra eti. ");
INSERT INTO chk_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Pwal chon leimwen Josef, pwin kana me chon leimwen saman ra eti. Nge nöür kewe semirit pwal nöür pwin sip me kow ra likiti lon ewe fanü Kosen. ");
INSERT INTO chk_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Iwe, chon wawa woken me chon wawa oris ra pwal etala Josef. Ir meinisin eu mwich mi fokun watte. ");
INSERT INTO chk_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Iwe, lupwen ra tori ewe lenien wichiwich umwun wiich lon Atat ötiuen ewe chanpupu Jortan, ra kechü fän leüömong. Ikenan Josef a kechüeiti saman we lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Iwe, lupwen ekewe chon Kanaan ra küna ar kechü lon Atat ewe lenien wichiwich umwun wiich, ra apasa, “Oo, iei a fis eu mwichen kechüomong ren chon Isip.” Iei mine ra aita ngeni ewe leni Apel Misraim , a nom ötiuen ewe chanpupu Jortan. ");
INSERT INTO chk_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Iwe, nöün Jakop kewe mwän ra föri ngeni usun mine a allük ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ra uweala semer we ngeni ewe fanü Kanaan o peiaseni lon ewe pwangen achau mi nom lon ewe tanipi Makpela ötiuen Mamre, Apraham a mönifengeni me ewe tanipi seni Efron ewe re Hit, pwe epwe an lenien peias. ");
INSERT INTO chk_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mürin än Josef wes le peiaseni saman we, a liwinla Isip fiti pwin kewe me meinisin mi eti le peiaseni saman. ");
INSERT INTO chk_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Iwe, mürin än semer we a mäla, pwin Josef kewe ra kapasfengen lefiler, “Met sipwe föri, ika Josef a chüen oputakich o liwini ngenikich ach kewe föföringau meinisin sa föri ngeni.” ");
INSERT INTO chk_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Iei mine ra tinala eman chon künö ren Josef pwe epwe asile ngeni, “Semom a allük ngenikem mwen an mäla pwe aipwe ürenuk, ");
INSERT INTO chk_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Kose mochen kopwe amusala än pwiüm kewe föföringau, pun ra tipis ren mine ra föri ngonuk.’ Iwe, iei aia tüngor ngonuk, ika kose mochen kopwe amusala ewe föföringau äm chon angang ngeni än semom we Kot aia föri.” Iwe, lupwen ar kapas ngeni, Josef a kechü. ");
INSERT INTO chk_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Mürin, pwin kewe ra püsin feito ren, ra chapetiu mwan o apasa, “Kose mochen kopwe nöünikem amanau.” ");
INSERT INTO chk_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Nge Josef a üreniir, “Ousap niuokus, pun ngang üa nom fän nemenien Kot. ");
INSERT INTO chk_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ewer, ämi oua ekiekin föföringau ngeniei, nge Kot a awili ngeni mürina pwe epwe amanaua chomong aramas, usun a fis ikenai. ");
INSERT INTO chk_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Iei mine ousap niuokus, pun ngang üpwe tümwünükemi me nöümi semirit.” Iei usun a chächäriir ren an kapas pwetete ngeniir. ");
INSERT INTO chk_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iwe, Josef a nonom lon Isip me chon leimwen saman meinisin. Ükükün ierin manauen Josef ipükü engol. ");
INSERT INTO chk_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iwe, Josef a küna aülüngatin tettelin nöün Efraim. Ra pwal uwato ren Josef nöün Makir kewe o anomu won afön. Nge Makir nöün Manasa. ");
INSERT INTO chk_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Iwe, Josef a üreni pwin kewe, “Ngang üpwe le mäla. Nge Kot epwe fokun alisikemi, epwe emwenikemiiwu seni ei fanü o aliwinikemiila lon ewe fanü a pwon ngeni Apraham, Isaak me Jakop.” ");
INSERT INTO chk_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Mürin, Josef a üreni nöün Israel kewe pwe repwe pwon fän akapel ngeni. Iwe, a apasa, “Oupwe pwon ngeniei pwe ika Kot epwe emwenikemiiwu seni ei fanü, oupwe uwala chüi.” ");
INSERT INTO chk_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Iwe, Josef a mäla, lupwen a ierini ipükü engol. Ra säfeeni o iseni lon eu pwor lon Isip. ");
INSERT INTO chk_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iwe, ikkei iten nöün Jakop kewe mwän ra etala Isip, eman me eman fiti an famili: ");
INSERT INTO chk_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rupen, Simeon, Lefi me Juta, ");
INSERT INTO chk_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sepulon me Peniamin, ");
INSERT INTO chk_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Tan, Naftali, Kat me Aser. ");
INSERT INTO chk_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Iwe, mwirimwirin Jakop kewe meinisin ükükün fik aramas, nge Josef a fen nom Isip. ");
INSERT INTO chk_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Mürin, Josef me pwin kana ra mäla, pwal pilor meinisin. ");
INSERT INTO chk_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Nge ekewe chon Israel ra fokun up o chomongola, ra chochoola o fokun pöchökülela pwe ewe fanü Isip a ti rer. ");
INSERT INTO chk_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mürin a seikitä eman kingen Isip mi fö, esap silei usun Josef. ");
INSERT INTO chk_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Iwe, ewe king a üreni nöün kewe aramas, “Ekei aramasen Israel ra kon chomong o pöchökül senikich. ");
INSERT INTO chk_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ou etto, sipwe le sorongaueer pwe resap chüen chomongola. Pun ika maun epwe torikich, repwe eti chon oputach le fiu ngenikich, repwe pwal sü seni fanüach.” ");
INSERT INTO chk_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Iei mine ra filätä chon nemeni ekewe aramasen Israel, pwe repwe ariaföüür ren angangochou le aüetä än Farao telinimwen iseis iter Pitom me Rameses. ");
INSERT INTO chk_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nge usun lapalan ar riaföü, iei usun pwal chomongolar me chochoolar won ewe fanü. Iei popun ekewe chon Isip ra fokun niueiti chon Israel. ");
INSERT INTO chk_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Iwe, ekewe chon Isip ra nöüniir amanau ");
INSERT INTO chk_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","o fokun eweiresiir ren angangochou. Ra wisen angang ngeni pwülüpar o föri pilak, ra pwal föri chomong sokun angangen lemal. Nge lon ar angang meinisin ra chök nöüniir amanau. ");
INSERT INTO chk_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mürin, ewe kingen Isip a üreni Sifra me Pua, ekewe ruoman chon afamw, ");
INSERT INTO chk_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Lupwen oua afamwa ekewe fin Ipru, oupwe nengeniöchü nöür. Pun ika eman ät, oupwe ni, nge ika eman nengin, oupwe amanaua.” ");
INSERT INTO chk_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Nge ekewe chon afamw ra niueiti Kot. Iei mine resap apwönüetä än ewe kingen Isip allük, nge ra fen amanaua ekewe ät. ");
INSERT INTO chk_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Iwe, ewe kingen Isip a körato ekewe chon afamw o aisiniir, “Pwota oua föri iei usun pwe oua amanaua ekewe ät?” ");
INSERT INTO chk_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Iwe, ekewe chon afamw ra üreni Farao, “Pun ekewe fin Ipru resap wewe ngeni ekewe fin Isip, pwe ra pöchökül o nöünöükai mwen eman chon afamw epwe toriir.” ");
INSERT INTO chk_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Iwe, Kot a afeiöchü ekewe chon afamw. Nge ekewe aramasen Israel ra chomongola o pöchökülela. ");
INSERT INTO chk_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Pokiten ekewe chon afamw ra niueiti Kot, i a fang ngeniir püsin nöür. ");
INSERT INTO chk_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mürin, Farao a allük ngeni nöün aramas meinisin, “Iteiten ät mi uputiu ngeni chon Ipru oupwe atururolong lon ewe chanpupu Nil, nge iteiten nengin oupwe amanaueer.” ");
INSERT INTO chk_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Lon ena fansoun, eman mwän seni ewe ainangen Lefi a pwülüeni eman fefin seni ewe ainangen Lefi. ");
INSERT INTO chk_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ewe fefin a pwopwo o nöüni eman ät. Nge lupwen a küna äteöchün nöün we, a aopala lon ükükün ülüngat maram. ");
INSERT INTO chk_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Nge lupwen esap chüen tongeni aopala, a föw eu pasikit seni wowo o pwiliongei ngeni mastik me apach. Iwe, a akonala ewe semirit lon o uwala lein wowoon aropen ewe chanpupu Nil. ");
INSERT INTO chk_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Iwe, fefinen ewe ät a ütä ekis toau pwe epwe küna met epwe fis ngeni. ");
INSERT INTO chk_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mürin, nöün Farao fefin a etiu ren ewe chanpupu pwe epwe tütü lon, nge nöün kewe chon angang fefin ra fetal ünükün ewe chanpupu. Iwe, neminewe a küna ewe pasikit lein ekewe wowo o akünöü ngeni eman nöün chon angang pwe epwe uwato ren. ");
INSERT INTO chk_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Lupwen neminewe a suki ewe pasikit, a küna eman ät, nge a kechü. Iwe, a tongei o apasa, “Iei i eman lein ekewe semiritin Ipru.” ");
INSERT INTO chk_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Mürin, fefinan we a kapas ngeni nöün Farao we fefin, “Ifa usun, ka mochen üpwe feila o körato eman fin Ipru pwe epwe oupwu ngonuk ewe semirit?” ");
INSERT INTO chk_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Iwe, nöün Farao we fefin a pälüeni, “Ewer, kopwe feila.” Iei mine ewe nengin a feila o kökköri inen ewe semirit. ");
INSERT INTO chk_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Iwe, nöün Farao we fefin a üreni inen ewe semirit. “Kopwe eki ei semirit pwe kopwe oupwu ngeniei, nge ngang üpwe ngonuk liwinum.” Iei mine ewe fefin a eki ewe semirit o akoupwu. ");
INSERT INTO chk_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nge lupwen ewe semirit a märitä, neminewe a ekiela ren nöün Farao we fefin. Iwe, a nöüni o aita ngeni Moses, pun a apasa, “Üa ekiwu me lon koluk.” ");
INSERT INTO chk_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Iwe, mürin eu fansoun, lupwen Moses a mwän, a feila ren aramasan ekewe chon Ipru o küneer lon ar angang weires. Iwe, a küna eman re Isip a wichi eman aramasan. ");
INSERT INTO chk_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Iwe, Moses a nenefetal, nge lupwen a mefi pwe esap wor eman a küna, a niela ewe re Isip o ireela fän pi. ");
INSERT INTO chk_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Sorotän ewe rän, lupwen a pwal feila rer, a küna ruoman re Ipru ra aninifengen. Iwe, Moses a aisini ewe mi mwäl, “Pwota ka wichi chienom?” ");
INSERT INTO chk_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ätewe a pälüeni, “Iö a filuketä pwe kopwe samol me souapwüng wom? Ka ekieki pwe kopwe pwal nieila usun om niela ewe re Isip?” Mürin, Moses a niuokus o ekieki, “Ellet, ewe föför a pwä.” ");
INSERT INTO chk_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Lupwen Farao a rong ei pworaus, a kütta Moses pwe epwe niela. Nge Moses a süla seni Farao o feila Mitian pwe epwe nonom ikenan. Iwe, a mottiu arun eu chönüttu. ");
INSERT INTO chk_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Iwe, eman souasor seni Mitian a wor füman nöün föpwül, ra feito ren ewe chönüttu pwe repwe üfüf koluk o alölöü ekewe lenien ün, pwe repwe aünü nöün semer kewe sip. ");
INSERT INTO chk_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nge ekoch chon fofol man ra pwal feito o asüela ekewe föpwül. Mürin, Moses a ütä o alisi ekewe föpwül le aünü nöür kewe sip. ");
INSERT INTO chk_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Lupwen ekewe föpwül ra liwiniti semer we itan Setiro, a aisiniir, “Pwota oua müttirito ikenai?” ");
INSERT INTO chk_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Iwe, ra apasa, “Eman re Isip a penikem seni ekewe chon fofol man, a pwal üfi koluk fän itach o aünü ekewe sip.” ");
INSERT INTO chk_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Iwe, Setiro a aisini nöün kewe föpwül, “Ifa i ätena? Pwota oua likiti? Oupwe körato pwe epwe mongö rech.” ");
INSERT INTO chk_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Nge Moses a tipeeu ngeni an epwe nonom ren ewe mwän. Mürin, Setiro a ngeni Moses nöün föpwül Sipora pwe epwe pwülüeni. ");
INSERT INTO chk_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Iwe, neminewe a nöüni eman ät, nge Moses a aita ngeni Kersom, pun a apasa, “Ngang eman chon siamü lon fanüen ekis.” ");
INSERT INTO chk_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Mürin chomong ier ra la, ewe kingen Isip a mäla. Nge ekewe aramasen Israel ra chök ngüngü fän riaföün än chon Isip nöüniir amanau, ra pwal siö pwe eman epwe alisiir. Nge ar siö pokiten ar riaföü a tori Kot. ");
INSERT INTO chk_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Iwe, Kot a rongorong ar siö o chechemeni an we pwon ngeni Apraham, Isaak me Jakop. ");
INSERT INTO chk_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","A küna ekewe aramasen Israel lon ar riaföü o ekieki usur. ");
INSERT INTO chk_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Lon ena fansoun Moses a foleni epwi pwiin sip nöün semen pwülüan we itan Setiro ewe souasoren Mitian. A emwenala folenian sip lotoun ewe fanüapö o tori ewe chukun Kot itan Horep. ");
INSERT INTO chk_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Iwe, ewe chon läng nöün ewe Samol mi Lapalap a pwä ngeni Moses lon pulopulen ekkei seni lon efoch iräfölüföl. Lupwen Moses a neneloi, a mefi pwe ewe irä a pulopul, nge esap karala. ");
INSERT INTO chk_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Iwe, a apasa, “Üpwe feila ikenan o atola ei metoch mi amwarar, pun pwota enan iräfölüföl esap karala?” ");
INSERT INTO chk_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Lupwen ewe Samol mi Lapalap a küna pwe Moses a feila ikenan, a kökköwu me lon ewe iräfölüföl, “Moses, Moses!” Moses a pälüeni, “Ngang iei.” ");
INSERT INTO chk_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Iwe, Kot a apasa, “Kosap arapoto. Kopwe pwilitawu ipwom sus, pun ei leni ka ütä won a pin.” ");
INSERT INTO chk_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A pwal apasa, “Ngang än om kewe lewo Apraham, Isaak me Jakop we Kot.” Iwe, Moses a pwölü mesan, pun a niuokus an epwe nenengeni Kot. ");
INSERT INTO chk_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mürin, ewe Samol mi Lapalap a apasa, “Üa küna riaföün nei aramas mi nonom Isip o rongorong ar siö pokiten än chon Isip nemenemengau ngeniir, üa pwal silei ar weires meinisin. ");
INSERT INTO chk_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Iwe, üa feitiu pwe üpwe angaseer seni chon Isip, üpwe pwal emwenirewu seni ewe fanü o emwenirelong lon eu fanü mi öch o watte, eu fanü mi pwülüöch o fanüeräs, fanüen chon Kanaan, chon Hit, chon Amor, chon Peris, chon Hiw me chon Jepus. ");
INSERT INTO chk_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Iei än ekewe aramasen Israel siö a toriei, üa pwal küna ar riaföü me ren chon Isip. ");
INSERT INTO chk_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Etto, üpwe tinukela ren Farao pwe kopwe emwenawu nei kewe aramasen Israel seni lon Isip.” ");
INSERT INTO chk_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Nge Moses a üreni Kot, “Ngang iö pwe üpwe tongeni feila ren Farao o emwenawu ekewe aramasen Israel seni lon Isip?” ");
INSERT INTO chk_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Iwe, Kot a pälüeni, “Ngang üpwe etuk. Ei epwe eu asisil ngonuk pwe ngang üa tinuk: Are ka emwenawu ekewe aramas seni lon Isip, epwe fis pwe oupwe fel ngeniei won ei chuk.” ");
INSERT INTO chk_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mürin, Moses a kapas ngeni Kot, “Nge ika üpwe churi ekewe aramasen Israel o üreniir, ‘Än ämi kewe lewo we Kot a tinieito remi,’ nge ir repwe aisiniei, ‘Ifa itan?’ iwe, met üpwe pälüeni ngeniir?” ");
INSERT INTO chk_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nge Kot a üreni Moses, “Ngang ngang echök. Iei usun mine kopwe üreni ekewe aramasen Israel, ‘Ewe mi iteni Ngang a tinieito remi.’” ");
INSERT INTO chk_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Iwe, Kot a pwal üreni Moses, “Kopwe kapas ngeni ekewe aramasen Israel: Ewe Samol mi Lapalap, än ämi kewe lewo Apraham, Isaak me Jakop we Kot a tinieito remi. Iei itei tori feilfeilachök, nge ren ei it oupwe chechemeniei seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Iwe, kopwe feila o achufengeni ekewe souakomwen Israel, kopwe üreniir: Ewe Samol mi Lapalap, än ämi kewe lewo Apraham, Isaak me Jakop we Kot a pwä ngeniei o üreniei, ‘Üa nenengenikemi o küna mine a fis ngenikemi lon Isip. ");
INSERT INTO chk_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Iwe, üa pwon ngenikemi pwe üpwe emwenikemiiwu seni lon Isip, ewe leni ia oua riaföü ie, o emwenikemiilong lon fanüen chon Kanaan, chon Hit, chon Amor, chon Peris, chon Hiw me chon Jepus, eu fanü mi pwülüöch o fanüeräs.’ ");
INSERT INTO chk_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Iwe, repwe aüselinga om kapas, mürin ämi me ekewe souakomwen Israel oupwe feila ren ewe kingen Isip o üreni, ‘Ewe Samol mi Lapalap än chon Ipru we Kot a churikem. Iei aia tüngor ngonuk pwe kopwe mwüt ngenikem pwe aipwe saila lon fanüapö ükükün ülüngat rän, pun aipwe asor ngeni äm we Kot ewe Samol mi Lapalap.’ ");
INSERT INTO chk_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nge üa fen silei pwe ewe kingen Isip esap mwüt ngenikemi pwe oupwe feila, tori eman mi manaman a pöchökül ngeni. ");
INSERT INTO chk_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Iei mine üpwe aitiela pei o afeiengaua chon Isip ren ekewe manaman meinisin ngang üpwe afisätä lefiler. Mürin epwe mwüt ngenikemi pwe oupwe feila. ");
INSERT INTO chk_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Üpwe pwal föri pwe ekewe chon Isip repwe ümöümöch ngeni ekei aramas, pwe lupwen oupwe feila, ousap feila fän asöülapö. ");
INSERT INTO chk_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Iwe, ekewe fefin meinisin repwe tüngor seni chon arur me chokewe ra imweimw rer fout seni silifer me kolt, pwal üf, pwe oupwe foute ngeni nöümi ät me nengin. Iei usun oupwe angeala pisekin chon Isip.” ");
INSERT INTO chk_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mürin, Moses a üra, “Nge ika resap mochen lüküei, resap pwal aüselinga aloi? Met üpwe föri ika repwe apasa, ‘Ewe Samol mi Lapalap esap pwä ngonuk?’” ");
INSERT INTO chk_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Iwe, ewe Samol mi Lapalap a aisini, “Met na mi nom lepoum?” Nge Moses a üra, “Efoch wok.” ");
INSERT INTO chk_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Iwe, Kot a üreni, “Kopwe aturätiu ena wok lepwül.” Iei mine a aturätiu. Iwe, a wiliti eman serepenit, nge Moses a sü seni. ");
INSERT INTO chk_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, “Kopwe pworotiu o turufi wükün.” Iei mine Moses a pworotiu o turufi, nge a wilisefäliti efoch wok me lepöün. ");
INSERT INTO chk_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Iwe, ewe Samol mi Lapalap a üreni, “Ren ei repwe lükü pwe ngang ewe Samol mi Lapalap än ar kewe lewo Apraham, Isaak me Jakop we Kot a pwä ngonuk.” ");
INSERT INTO chk_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Iwe, ewe Samol mi Lapalap a pwal üreni Moses, “Kopwe sökalong poum lon üfom.” Iwe, a sökalong, nge lupwen a sökawu, pöün a rupun pwötür usun chök pwechepwechen snow. ");
INSERT INTO chk_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mürin, Kot a üreni, “Kopwe söksefälielong poum lon üfom.” Iwe, a sökalong, nge lupwen a sökawu, pöün a pwal pöchökül usun chök inisin. ");
INSERT INTO chk_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Iwe, Kot a pwal üreni, “Are resap mochen lükuuk ika ekieki ewe aeuin manaman, eli repwe lükü aruuan. ");
INSERT INTO chk_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Nge ika resap mochen lükü ekei ruu manaman ika afäli alom, kopwe üfi koluk seni ewe chanpupu Nil o ninätiu won pwül. Iwe, ewe koluk ka üfi epwe wiliti cha me won pwül.” ");
INSERT INTO chk_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nge Moses a üreni ewe Samol mi Lapalap, “Ai Samol, sap ngang eman mi sousile kapas seni me lom pwal tori ei fansoun ka kapas ngeniei ngang noum ei chon angang, pwe ngang eman mi angangau le kapas.” ");
INSERT INTO chk_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Mürin, ewe Samol mi Lapalap a üreni Moses, “Iö a föri awen aramas? Iö a föri pwe aramas resap tongeni kapas ika rongorong? Iö a föri pwe repwe küna mwer ika repwe chun? Sap ngang ewe Samol mi Lapalap? ");
INSERT INTO chk_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Iei mine kopwe feila, nge ngang üpwe alisuk le kapas o aiti ngonuk mine kopwe eäni fos.” ");
INSERT INTO chk_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Nge Moses a üreni, “Ai Samol, kose mochen kopwe tinala eman.” ");
INSERT INTO chk_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mürin, ewe Samol mi Lapalap a song ngeni Moses o üreni, “Ifa usun, esap nom Aaron pwiüm we seni ewe ainangen Lefi? Üa silei pwe a tongeni angöch le kapas. A fen nom won al pwe epwe feito o churuk, nge lupwen epwe künok, epwe pwapwa lon lelukan. ");
INSERT INTO chk_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Iwe, en kopwe kapas ngeni o aiti ngeni mine epwe apasa, nge ngang üpwe emwelieliakemi me ruoman o aiti ngenikemi mine oupwe föri. ");
INSERT INTO chk_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aaron epwe kapas ngeni aramas fänäsengesum, epwe pwal aweni awom, nge en kopwe usun chök Kot ngeni. ");
INSERT INTO chk_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Iwe, kopwe angei ei wok pwe kopwe föri ekewe manaman ren.” ");
INSERT INTO chk_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mürin, Moses a liwinla ren semen pwülüan itan Setiro o kapas ngeni, “Kose mochen kopwe mwüt ngeniei pwe üpwe liwinla ren aramasei mi nom Isip o pi ika ra chüen manau.” Iwe, Setiro a üreni Moses, “Kopwe feila fän kinamwe.” ");
INSERT INTO chk_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nge ewe Samol mi Lapalap a üreni Moses me lon Mitian, “Kopwe liwinla Isip, pun ekewe aramas meinisin mi mochen niikela ra mäla.” ");
INSERT INTO chk_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Iei mine Moses a angei pwülüan me nöün kana o amoteer won eman aas. Iwe, a liwinla lon ewe fanü Isip. Nge Moses a amwöchü lepöün ewe wokun Kot. ");
INSERT INTO chk_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Iwe, ewe Samol mi Lapalap a üreni Moses, “Lupwen kopwe liwinla Isip, kopwe pi pwe kopwe föri ekewe manaman meinisin fän mesen Farao üa atufichi ngonuk. Nge ngang üpwe aföreai lelukan pwe esap mwüt ngeni ekewe aramas pwe repwe feila. ");
INSERT INTO chk_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Mürin, en kopwe kapas ngeni Farao, ‘Iei alon ewe Samol mi Lapalap: Israel nei mwänichi. ");
INSERT INTO chk_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Iwe, üpwe ürenuk pwe kopwe mwüt ngeni nei we pwe epwe feila o fel ngeniei. Nge ika kosap mwüt ngeni, üpwe niela noum mwänichi.’” ");
INSERT INTO chk_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Iwe, lon ar sai, lupwen ra asösö lepwin, ewe Samol mi Lapalap a churi Moses, pun a ekiekin niela. ");
INSERT INTO chk_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Mürin, Sipora a angei esät sättin fau mi ken o sirkomsaisi nöün ät. Iwe, a angei ünüchen ewe kükün inis, a pachei ngeni pechen Moses o apasa, “Ellet, en eman re reimwen cha ngeniei.” ");
INSERT INTO chk_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Iei mine ewe Samol mi Lapalap a likitala Moses, lupwen neminewe a apasa, “En eman re reimwen cha,” pun a kapas fän iten ewe sirkomsais. ");
INSERT INTO chk_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Iwe, ewe Samol mi Lapalap a üreni Aaron, “Kopwe feila lon ewe fanüapö pwe kopwe churi Moses.” Iwe, a feila o churi Moses awenewenen ewe chukun Kot. Iwe, a mitiri. ");
INSERT INTO chk_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mürin, Moses a apworausa ngeni Aaron mine ewe Samol mi Lapalap a tini ren, a pwal asile ngeni ekewe manaman meinisin Kot a amwir ngeni pwe epwe föri. ");
INSERT INTO chk_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mürin, Moses me Aaron ra feila o amwichafengeni ekewe souakomwen aramasen Israel meinisin. ");
INSERT INTO chk_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Iwe, Aaron a üreniir meinisin mine ewe Samol mi Lapalap a kapas ngeni Moses. Nge Moses a pwal föri ekewe manaman fän mesen ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Iwe, ra lükü. Nge lupwen ra rong pwe ewe Samol mi Lapalap a äämwa ekewe aramasen Israel o küna ar riaföü, ra chapetiu o fel ngeni Kot. ");
INSERT INTO chk_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mürin, Moses me Aaron ra feila ren Farao o üreni, “Iei alon ewe Samol mi Lapalap ewe Koten Israel, ‘Kopwe mwüt ngeni nei aramas pwe repwe feila o föri eu chulap fän itei lon fanüapö.’” ");
INSERT INTO chk_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nge Farao a pälüeniir, “Iö na ewe Samol mi Lapalap pwe üpwe aüselinga alon o mwütala Israel? Üsap silei ewe Samol mi Lapalap, üsap pwal mwüt ngeni Israel epwe feila.” ");
INSERT INTO chk_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Iwe, ra pälüeni, “Än chon Ipru Kot a churikem. Kose mochen mwüt ngenikem pwe äm aipwe saila lon fanüapö lon ükükün ülüngat rän. Pun aipwe asor ngeni äm we Kot ewe Samol mi Lapalap, pwe esap apwüngükem ren mätter ika maun.” ");
INSERT INTO chk_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Nge ewe kingen Isip a üreni Moses me Aaron, “Pwota oua mochen uweela ekewe aramas seni ar angang weires? Oupwe feila, föri ämi angang.” ");
INSERT INTO chk_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farao a pwal üreniir, “Nengeni, ekewe aramas ra kon chomong seni chon Isip, nge ämi oua mochen aüküretiu seni ar angang.” ");
INSERT INTO chk_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Lon ewe chök rän, Farao a allük ngeni ekewe chon nemeni ekewe aramas fän pöchökül me ekewe souemwenin angang, ");
INSERT INTO chk_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Ousap chüen ngeni ekewe aramas fetilipwas le föri pilak usun me lom, pun repwe feila püsin ioni. ");
INSERT INTO chk_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Nge repwe chök föri ükükün förier pilak usun me mwan. Ousap fokun akisikisätiu, pun ra chipwang. Iei mine ra apasa lon ar siö, ‘Kopwe mwüt ngenikem pwe aipwe feila o asor ngeni äm we Kot.’ ");
INSERT INTO chk_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Oupwe achouu ar angang. Oupwe angangeer pwe esap wor fansoun ar rongorong kapas chofana.” ");
INSERT INTO chk_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Mürin ekewe chon nemenem fän pöchökül me ekewe souemwenin angang ra feila ren ekewe aramas o üreniir, “Iei alon Farao, ‘Üsap chüen ngenikemi fetilipwas. ");
INSERT INTO chk_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Oupwe püsin feila o kütfetal fetilipwas, nge iteiten föriemi pilak esap fokun kisikisitiu.’” ");
INSERT INTO chk_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Iei mine ekewe aramas ra fetalfeil won unusen ewe fanü Isip pwe repwe ionifengeni fetilipwas. ");
INSERT INTO chk_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Iwe, ekewe chon nemenem fän pöchökül ra inemoucheer o apasa, “Oupwe awesöchü ükükün föriemi pilak lon eu me eu rän usun chök me mwan, lupwen a wor ämi fetilipwas.” ");
INSERT INTO chk_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Iwe, ekewe souemwenin angang seni Israel mi kefilitä me ren nöün Farao chon nemenem ra kawet. Iwe, ra aisiniir, “Pwota ousap awesöchü föriemi pilak näneu me ikenai usun me mwan?” ");
INSERT INTO chk_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mürin ekewe souemwenin angang seni Israel ra feito ren Farao o siö ngeni, “Pwota ka föri iei usun ngenikem äm noum chon angang? ");
INSERT INTO chk_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Resap ngenikem fetilipwas, nge ra ürenikem pwe aipwe föri pilak. Iei ra wichikem äm noum chon angang, nge ei püsin mwälin noum aramas.” ");
INSERT INTO chk_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nge Farao a pälüeniir, “Oua chök chipwang, oua chök chipwang, iei mine oua apasa, ‘Kopwe mwüt ngenikem pwe äm aipwe feila o asor ngeni ewe Samol mi Lapalap.’ ");
INSERT INTO chk_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Oupwe liwinla iei o angang. Esap wor eman epwe ngenikemi fetilipwas, nge epwe chök wor ükükün föriemi pilak usun me mwan.” ");
INSERT INTO chk_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Iwe, ekewe souemwenin angang seni Israel ra küna pwe ra nonom lon osupwang watte, lupwen ra rongorong pwe ükükün förier pilak lon eu rän esap fokun kisikisitiu. ");
INSERT INTO chk_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nge lupwen ra towu seni Farao, ra churi Moses me Aaron, pun ra witiwitiir. ");
INSERT INTO chk_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Iwe, ra üreniir, “Ewe Samol mi Lapalap epwe nenengeni o apwüngükemi, pun oua apwongauakem fän mesen Farao me nöün chon angang, oua pwal föri met repwe niikem ren.” ");
INSERT INTO chk_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mürin, Moses a sap ngeni ewe Samol mi Lapalap o apasa, “Ai Samol, pwota ka afeiengaua ekei aramas? Pwota mwo chök ke fen akünöüeito ikei? ");
INSERT INTO chk_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Pun seni ewe fansoun üa churi Farao o kapas ngeni fän itom, a fen afeiengaua ekei aramas, nge kosap föri och pwe kopwe angasala noum kei aramas.” ");
INSERT INTO chk_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mürin, ewe Samol mi Lapalap a üreni Moses, “Iei kopwe le küna mine üpwe föri ngeni Farao. Pun ren pei mi manaman üpwe pöchökül ngeni Farao pwe epwe tinirewu, ewer, epwe asürela seni fanüan.” ");
INSERT INTO chk_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Iwe, Kot a üreni Moses, “Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Üa pwä ngeni Apraham, Isaak me Jakop ren itei we Kot mi Unusen Manaman, nge üsap asile ngeniir itei ei Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Üa pwal föri ai pwon ngeniir pwe üpwe ngeniir ewe fanü Kanaan, ewe fanü ra fen asösö lon usun chon siamü. ");
INSERT INTO chk_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nge iei üa rong än ekewe aramasen Israel ngüngü ren ar riaföü, pun chon Isip ra amwöchüretiu o nöüniir amanau. Iwe, üa chechemeni ai pwon ngeniir. ");
INSERT INTO chk_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Iei mine kopwe üreni ekewe aramasen Israel, ‘Ngang ewe Samol mi Lapalap. Üpwe emwenikemiiwu seni fän ämi angangochou ngeni chon Isip, üpwe pwal angasakemi seni ar nöünikemi amanau o amanauakemi fän pei mi manaman pwal ren apwüng mi lapalap. ");
INSERT INTO chk_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Iwe, üpwe nöünikemi pwe oupwe aramasei, nge ngang üpwe ämi Kot. Oupwe silei pwe ngang ewe Samol mi Lapalap ämi we Kot mi emwenikemiiwu seni fän ämi angangochou lon Isip. ");
INSERT INTO chk_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Üpwe pwal emwenikemiilong lon ewe fanü, üa pwon ngeni Apraham, Isaak me Jakop pwe üpwe ngenikemi pwe fanüemi. Ngang ewe Samol mi Lapalap.’” ");
INSERT INTO chk_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Iwe, Moses a üreni ekewe aramasen Israel ekei kapas, nge ir resap aüselinga, pun a tatakis letiper ren än chon Isip nöüniir amanau. ");
INSERT INTO chk_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Kopwe feila o üreni Farao ewe kingen Isip pwe epwe mwüt ngeni ekewe aramasen Israel pwe repwe towu seni fanüan.” ");
INSERT INTO chk_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nge Moses a üreni ewe Samol mi Lapalap, “Nengeni, ekewe aramasen Israel resap aüselingaei. Ifa usun, Farao epwe mochen aüselingaei, nge ngang fen eman mi angangau le kapas?” ");
INSERT INTO chk_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nge ewe Samol mi Lapalap a kapas ngeni Moses me Aaron, a akünöörela ren ekewe aramasen Israel pwal ren Farao ewe kingen Isip, pwe repwe emwenawu ekewe aramasen Israel seni ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ikkei ir mwänirelan ar kewe cho. Nöün Rupen kewe mwän ewe mwänichien nöün Israel: Hanok, Pallu, Hesron me Karmi. Ätekei ir än ar kewe cho lewo mi iteni iter. ");
INSERT INTO chk_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Nge nöün Simeon kewe mwän: Jemuel, Jamin, Ohat, Jakin, Sohar me Shaul nöün eman fin Kanaan. Ätekei ir än ar kewe cho lewo mi iteni iter. ");
INSERT INTO chk_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ikkei iten nöün Lefi kewe mwän lon tettelin mwirimwirir: Kerson, Kohat me Merari. Ätekei ir än ar kewe cho lewo mi iteni iter. Iwe, ierin manauen Lefi ükükün ipükü ilik me fisu. ");
INSERT INTO chk_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Iwe, nöün Kerson kewe mwän: Lipni me Shimei, a pwal wor chomong mwirimwirir. ");
INSERT INTO chk_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Nge nöün Kohat kewe mwän: Amram, Ishar, Hepron me Ussiel. Iwe, ierin manauen Kohat ükükün ipükü ilik me ülüngat. ");
INSERT INTO chk_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Iwe, nöün Merari kewe mwän: Mali me Mushi. Ir meinisin än Lefi kewe cho lon tettelin mwirimwirir. ");
INSERT INTO chk_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram a pwülüeni Jokopet fefinen saman we. Iwe, Jokopet a nöüni me won Amram: Aaron me Moses. Nge ierin manauen Amram ükükün ipükü ilik me fisu. ");
INSERT INTO chk_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Iwe, nöün Ishar kewe mwän: Kora, Nefek me Sikri. ");
INSERT INTO chk_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Nge nöün Ussiel kewe mwän: Misael, Elsafan me Sitri. ");
INSERT INTO chk_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Iwe, Aaron a pwülüeni Elisepa nöün Aminatap fefin, fefinen Nashon. Neminewe a nöüni me won Aaron: Natap, Apihu, Eleasar me Itamar. ");
INSERT INTO chk_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Iwe, nöün Kora kewe mwän: Assir, Elkana me Apiasaf. Ir än Kora kewe cho lewo. ");
INSERT INTO chk_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Iwe, Eleasar nöün Aaron mwän a pwülüeni eman lein nöün Putiel fefin. Neminewe a nöüni me won Pinehas. Ikkeiir mwänirelan än Lefi cho lon en me an famili. ");
INSERT INTO chk_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ikkeiir Aaron me Moses, ätekewe ewe Samol mi Lapalap a kapas ngeniir, “Oupwe emwenawu ekewe aramasen Israel seni lon ewe fanü Isip lon tettelin en me an cho.” ");
INSERT INTO chk_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moses me Aaron ir ätekewe mi fos ngeni Farao ewe kingen Isip usun ar repwe emwenawu ekewe aramasen Israel seni Isip. ");
INSERT INTO chk_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Lon ewe rän, lupwen ewe Samol mi Lapalap a kapas ngeni Moses me lon ewe fanü Isip, ");
INSERT INTO chk_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","a üreni, “Ngang ewe Samol mi Lapalap. Kopwe asile ngeni Farao ewe kingen Isip meinisin mine üa ürenuk.” ");
INSERT INTO chk_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Nge Moses a üreni ewe Samol mi Lapalap, “Ngang eman mi angangau le kapas. Ifa usun, Farao epwe mochen aüselingaei?” ");
INSERT INTO chk_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mürin, ewe Samol mi Lapalap a üreni Moses, “Nengeni, üpwe awisok pwe kopwe usun chök eman kot ngeni Farao, nge Aaron pwiüm we epwe usun chök noum soufos. ");
INSERT INTO chk_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kopwe asile ngeni Aaron mine üa allük ngonuk, nge Aaron pwiüm we epwe kapas ngeni Farao, pwe epwe mwüt ngeni ekewe aramasen Israel repwe towu seni fanüan. ");
INSERT INTO chk_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Nge ngang üpwe aföreai lelukan. Inamwo ika a chomong ai asisil me ai manaman üa föri lon Isip, ");
INSERT INTO chk_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Farao esap mochen aüselingakemi. Iei mine üpwe afeiengaua Isip ren apwüng mi lapalap, nge üpwe emwenawu nei aramasen Israel seni Isip lon tettelin en me an cho. ");
INSERT INTO chk_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mürin ekewe chon Isip repwe mefi pwe ngang ewe Samol mi Lapalap, lupwen üpwe aitiela pei won Isip pwe üpwe afeiengaua o emwenawu ekewe aramasen Israel seni me leir.” ");
INSERT INTO chk_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Iwe, Moses me Aaron ra föri meinisin mine ewe Samol mi Lapalap a allük ngeniir. ");
INSERT INTO chk_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Lon ewe fansoun, lupwen ra kapas ngeni Farao, Moses a ierini walik, nge Aaron a ierini walik me ülüngat. ");
INSERT INTO chk_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ika Farao epwe ürenikemi, ‘Oupwe alükülükü wisemi ren ämi oupwe föri manaman,’ en kopwe üreni Aaron, ‘Kopwe angei wokum o monetiu fän mesen Farao pwe epwe wiliti eman serepenit.’” ");
INSERT INTO chk_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Iei usun Moses me Aaron ra feila ren Farao o föri usun mine ewe Samol mi Lapalap a allük ngeniir. Iwe, Aaron a monetiu wokun we fän mesen Farao me nöün kewe nöüwis, nge a wiliti eman serepenit. ");
INSERT INTO chk_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mürin, Farao a titi ekewe soutipachem me soupöüt, pwal ir ekewe sourongen Isip. Iwe, ra föri usun mine Aaron a föri. ");
INSERT INTO chk_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Iteiten eman me eman leir a monetiu wokun, iwe, ra wiliti serepenit. Nge wokun Aaron we a aromala wokur kewe. ");
INSERT INTO chk_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Nge Farao a chök tipeföreala pwe esap mochen aüselinger, usun ewe Samol mi Lapalap a fen apasa. ");
INSERT INTO chk_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Mürin, ewe Samol mi Lapalap a üreni Moses, “Farao a chök tipeföreala, esap mochen mwüt ngeni ekewe aramas pwe repwe feila. ");
INSERT INTO chk_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Lesosorun lesor kopwe feila souni Farao ünükün ewe chanpupu Nil, lupwen epwe feila ikenan. Iwe, kopwe uwei ewe wok mi wiliti eman serepenit me mwan. ");
INSERT INTO chk_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Iwe, kopwe üreni, ‘Ewe Samol mi Lapalap, än chon Ipru we Kot a tinieito reöm pwe üpwe ürenuk, “Kopwe mwüt ngeni nei aramas pwe repwe feila o fel ngeniei lon fanüapö. Nge tori iei kosap mwo aüselingaei.” ");
INSERT INTO chk_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Iei alon ewe Samol mi Lapalap, “Ren ei kopwe silei pwe ngang ewe Samol mi Lapalap: Üpwe wichi kolukun lon ewe chanpupu Nil ren woki mi nom lepei pwe epwe wiliti cha. ");
INSERT INTO chk_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Iwe, ikenen lon ewe chanpupu Nil repwe mäla, nge ewe chanpupu epwe fokun pongau pwe ekewe chon Isip resap tongeni ün ewe koluk.” ’” ");
INSERT INTO chk_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe kapas ngeni Aaron pwe epwe angei wokun o aitiela pöün won kolukun Isip meinisin, won ekewe chanpupu me warawaren koluk, won ekewe nasen koluk me ekewe pwangen koluk meinisin, pwe repwe wiliti cha. Iwe, epwe chök cha won unusen ewe fanü Isip, pwal lon mwo nge sepi mi för seni mwüch me fau.” ");
INSERT INTO chk_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Iwe, Moses me Aaron ra föri meinisin mine ewe Samol mi Lapalap a allük ngeniir. Aaron a aitiela wokun o wichi kolukun lon ewe chanpupu Nil, pwe kolukun meinisin a wiliti cha. Ei a föri me fän mesen Farao me nöün kewe nöüwis. ");
INSERT INTO chk_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Iwe, ikenen lon ewe chanpupu Nil ra mäla, nge kolukun lon ra fokun pongau, pwe chon Isip resap tongeni ün seni. Iwe, a cha won unusen ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mürin, ekewe sourongen Isip ra pwal föri ei sokun manaman ren ronger. Iei mine Farao a chök tipeförea, pwe esap mochen aüselinga Moses me Aaron, usun mine ewe Samol mi Lapalap a fen apasa. ");
INSERT INTO chk_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Iwe, Farao a liwiniti imwan, nge esap ekieki usun lon lelukan. ");
INSERT INTO chk_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nge chon Isip meinisin ra tufetal pwang ünükün ewe chanpupu Nil pwe repwe kütta ünümer koluk, pun resap tongeni ün seni ewe chanpupu Nil. ");
INSERT INTO chk_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Iwe, ewe Samol mi Lapalap a angauala kolukun lon ewe chanpupu Nil lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe feila ren Farao o kapas ngeni, ‘Iei alon ewe Samol mi Lapalap, “Kopwe mwüt ngeni nei aramas pwe repwe feila o fel ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Nge ika kosap mwüt ngeniir pwe repwe feila, üpwe ariaföüü unusen fanüom ren kairü. ");
INSERT INTO chk_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Iwe, ewe chanpupu Nil epwe uren kairü. Repwe tolong lon imwom, lon om rumwen annut pwal won om peet. Iwe, repwe tolong lon imwen noum kewe nöüwis pwal lon imwen noum kewe aramas, repwe tolong lon om lenien um me sepien öüwöü pilawa. ");
INSERT INTO chk_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ekewe kairü repwe mwetemwetfetal womw, won noum kewe aramas me noum kewe nöüwis.” ’” ");
INSERT INTO chk_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe kapas ngeni Aaron pwe epwe aitiela pöün fiti wokun won ekewe chanpupu me ekewe warawar, pwal won ekewe nasen koluk, pwe kairü repwe tötä won ewe fanü Isip.” ");
INSERT INTO chk_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Iei mine Aaron a aitela pöün won kolukun Isip. Iwe, ekewe kairü ra tötä o pwölüela ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nge ekewe sourongen Isip ra pwal föri ei sokun manaman ren ronger, pwe ra pwal atötäi kairü won ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mürin, Farao a körato Moses me Aaron o üreniir, “Oupwe tüngorei ewe Samol mi Lapalap, pwe epwe angei ekewe kairü seniei pwal seni nei aramas. Nge ngang üpwe mwüt ngeni ekewe aramasen Israel pwe repwe feila o asor ngeni ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Iwe, Moses a üreni Farao, “Kose mochen, en chök kopwe püsin filätä inet üpwe tüngor fän itom pwal fän iten noum kewe nöüwis me noum kewe aramas, pwe ekewe kairü repwe sü senuk pwal seni imwom, nge repwe chök nonom lon ewe chanpupu Nil.” ");
INSERT INTO chk_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Iwe, Farao a üreni, “Lesor.” Nge Moses a üra, “Epwe fis usun om apasa, pwe kopwe silei pwe esap wor eman kot mi wewe ngeni äm we Kot ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ekewe kairü repwe sü senuk pwal seni imwom, repwe sü seni noum kewe nöüwis me noum kewe aramas, nge repwe chök nonom lon ewe chanpupu Nil.” ");
INSERT INTO chk_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Iwe, Moses me Aaron ra feila seni Farao. Mürin, Moses a tüngormamau ngeni ewe Samol mi Lapalap usun ekewe kairü i a awarato won Farao. ");
INSERT INTO chk_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Iwe, ewe Samol mi Lapalap a föri usun mine Moses a tüngorei. Ekewe kairü ra mäla seni lon ekewe imw tori lükün, pwal tori lemal. ");
INSERT INTO chk_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ra ionifengeniir o achukuchukuretä, nge ewe fanü a pwongau rer. ");
INSERT INTO chk_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Iwe, lupwen Farao a küna pwe a ekis ngasala, a pwal tipeföreala pwe esap mochen aüselinga Moses me Aaron, usun mine ewe Samol mi Lapalap a fen apasa. ");
INSERT INTO chk_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe kapas ngeni Aaron pwe epwe aitiela wokun o wichi pwülün ewe fanü, pwe pwülümoromorun won unusen ewe fanü Isip epwe wiliti nikken.” ");
INSERT INTO chk_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Iwe, ra föri iei usun. Aaron a aitiela pöün fiti wokun o wichi pwülün ewe fanü, pwe pwülümoromorun unusen ewe fanü Isip a wiliti nikken, nge ra küw aramas me man. ");
INSERT INTO chk_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Iwe, ekewe sourong ra pwal sotuni ronger pwe repwe afisätä nikken, nge resap tongeni. Ekewe nikken ra küw aramas me man. ");
INSERT INTO chk_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Mürin, ekewe sourong ra üreni Farao, “Ei pöün Kot a föri.” Nge Farao a fen tipeföreala pwe esap mochen aüselinga Moses me Aaron, usun mine ewe Samol mi Lapalap a fen apasa. ");
INSERT INTO chk_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe pwätä lesosorusich o feila souni Farao, lupwen epwe feila ren ewe koluk. Iwe, kopwe üreni, ‘Iei alon ewe Samol mi Lapalap: Kopwe mwüt ngeni nei aramas repwe feila pwe repwe fel ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Nge ika kosap mochen mwüt ngeniir, üpwe tinato pwiin loong womw, won noum kewe nöüwis me noum kewe aramas, pwal lon imwom. Iwe, lon imwen chon Isip meinisin epwe uren pwiin loong, pwal ewe pwül ra nom won. ");
INSERT INTO chk_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Nge lon ena ränin üpwe tiela ewe fanü Kosen, ewe ia nei aramas ra nonom ie, pwe esap wor pwiin loong rer. Ren ei kopwe silei pwe ngang ewe Samol mi Lapalap üa nonom lon ei fanü. ");
INSERT INTO chk_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Iwe, üpwe aimwü lefilen nei aramas me noum aramas. Ei manaman epwe fis lesor.’” ");
INSERT INTO chk_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Iwe, ewe Samol mi Lapalap a apwönüetä mine a apasa. Chomong pwiin loong ra ässilong lon imwen Farao pwal lon imwen nöün kewe nöüwis tori lon unusen ewe fanü Isip, pwe ewe fanü a ngauala ren ekewe loong. ");
INSERT INTO chk_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mürin, Farao a kökkörato Moses me Aaron o üreniir, “Oupwe feila o asor ngeni ämi we Kot, nge lon chök ei fanü.” ");
INSERT INTO chk_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nge Moses a üra, “Esap öch ika epwe ina usun. Pun ekewe mönün asor aia eäni asor ngeni ewe Samol mi Lapalap äm we Kot ra anioput ngeni chon Isip. Nge ika aia eäni asor ekewe mönün asor mi anioput me fän meser, ifa usun, resap monei ngenikem fau? ");
INSERT INTO chk_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Äm aipwe fokun sai lon ükükün ülüngat rän lon fanüapö pwe aipwe asor ngeni ewe Samol mi Lapalap äm we Kot, usun a allük ngenikem.” ");
INSERT INTO chk_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Nge Farao a üreniir, “Üpwe mwüt ngenikemi pwe oupwe feila o asor ngeni ewe Samol mi Lapalap ämi we Kot lon fanüapö, nge ousap chök feila toau. Oupwe pwal iotekin tüngor fän itei.” ");
INSERT INTO chk_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Iwe, Moses a üra, “Nengeni, lupwen üpwe feila senuk, üpwe iotek ngeni ewe Samol mi Lapalap pwe lesor ekewe pwiin loong repwe sü senuk, seni noum kewe nöüwis me noum kewe aramas. Nge en Farao kosap chüen atupukem ren om kosap mwüt ngeni ekewe aramas pwe repwe feila o asor ngeni ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mürin, Moses a towu seni fän mesen Farao o iotek ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Iwe, ewe Samol mi Lapalap a föri usun mine Moses a tüngor. A asüela ekewe pwiin loong seni Farao, seni nöün kewe nöüwis me nöün kewe aramas. Esap nonom mwo eman. ");
INSERT INTO chk_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nge Farao a chök tipeförea pwal lon ei fansoun, pwe esap mwüt ngeni ekewe aramas pwe repwe feila. ");
INSERT INTO chk_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe feila ren Farao o kapas ngeni, ‘Iei alon ewe Samol mi Lapalap än chon Ipru we Kot, “Kopwe mwüt ngeni nei aramas pwe repwe feila o fel ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Pun ika kosap mochen mwüt ngeniir pwe repwe feila, nge ka pwal chök amwöchüür, ");
INSERT INTO chk_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Ngang ewe Samol mi Lapalap üpwe afeiengaua noum man mi nom lemäl ren eu mäfeiengau. Üpwe afeiengaua ekewe oris, ekewe aas, ekewe kamel, ekewe kow me ekewe sip. ");
INSERT INTO chk_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nge üpwe aimwü lefilen nöün chon Israel man me nöün chon Isip man, pwe esap wor eman me lein nöün chon Israel man epwe mäla.” ’” ");
INSERT INTO chk_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Iwe, ewe Samol mi Lapalap a filätä eu rän o apasa, “Lesor ngang ewe Samol mi Lapalap üpwe awarato feiengau won ei fanü.” ");
INSERT INTO chk_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Iwe, sorotän ewe rän, ewe Samol mi Lapalap a awarato ewe feiengau. Ekewe man meinisin nöün chon Isip ra mäla, nge esap wor eman me lein nöün chon Israel man a mäla. ");
INSERT INTO chk_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao a tinala eman pwe epwe sachei, nge a pwä pwe esap wor eman me lein nöün chon Israel man a mäla. Nge Farao a fen tipeföreala, pwe esap mochen mwüt ngeni ekewe aramas pwe repwe feila. ");
INSERT INTO chk_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Mürin, ewe Samol mi Lapalap a üreni Moses me Aaron, “Oupwe tukei ngeni pöümi falang seni eu lenien um mi watte. Iwe, Moses epwe moneetä läng me fän mesen Farao, ");
INSERT INTO chk_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","nge epwe wiliti pwülümoromor won unusen ewe fanü Isip. Iwe, ewe pwülümoromor epwe afisätä mach mi usun ruup won aramas me man lon unusen ewe fanü Isip.” ");
INSERT INTO chk_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Iei mine ra tukei falang seni eu lenien um mi watte, ra ütä me fän mesen Farao, nge Moses a moneetä läng. Iwe, a afisätä mach mi usun ruup won aramas me man. ");
INSERT INTO chk_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ekewe sourong resap tongeni ütä mwen Moses pokiten inisir a kula ren mach, pun ekewe sourong me chon Isip meinisin ra mach. ");
INSERT INTO chk_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nge ewe Samol mi Lapalap a atipeföreai Farao pwe esap aüselinga Moses me Aaron, usun mine ewe Samol mi Lapalap a fen üreni Moses. ");
INSERT INTO chk_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe pwätä lesosorusich pwe kopwe ütä fän mesen Farao o kapas ngeni, ‘Iei alon ewe Samol mi Lapalap än chon Ipru we Kot, “Kopwe mwüt ngeni nei aramas pwe repwe feila o fel ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Lon ei fansoun üpwe tinätiu womw pwal won noum kewe nöüwis me noum kewe aramas unusen ai kewe afeiengau meinisin, pwe kopwe silei pwe esap wor eman won unusen fanüfan mi wewe ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Üa fen tongeni aitiela pei o afeiengauok me noum kewe aramas ren mätter, pwe manauemi epwe müchüla me won fanüfan. ");
INSERT INTO chk_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Nge üa mwüt ngonuk pwe kopwe manau tori ikenai, pwe üpwe pwäri ngonuk ai manaman, pwe itei epwe föüla won unusen fanüfan. ");
INSERT INTO chk_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pokiten ka chüen lamalamtekia ngeni nei aramas ren om kosap mwüt ngeniir pwe repwe feila, ");
INSERT INTO chk_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","lesor lon ei otun üpwe apüngätiu ütten fau mi chou won ei fanü, esap mwo fis ei sokun fän eu lon Isip seni poputän mwün tori ikenai. ");
INSERT INTO chk_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Iei mine kopwe titila pwe repwe emwenala noum man lon lenien op, pwal meinisin mine a nom lemäl. Pun aramas me man meinisin mi nom lemäl nge resap op, repwe mäla ren ewe ütten fau epwe püngütiu wor.” ’” ");
INSERT INTO chk_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Iwe, iö mi niueiti alon ewe Samol mi Lapalap me lein nöün Farao kewe nöüwis, a amüttiri le asüelong le imw ekewe aramas a nöüniir amanau me nöün man. ");
INSERT INTO chk_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Nge iö esap afäli alon ewe Samol mi Lapalap, a chök likitala lemäl ekewe aramas a nöüniir amanau me nöün man. ");
INSERT INTO chk_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe aitietä poum läng pwe epwe püngütiu ütten fau won unusen ewe fanü Isip, won aramas me man, pwal won ekewe irän lemäl.” ");
INSERT INTO chk_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Iwe, lupwen Moses a aitietä wokun läng, ewe Samol mi Lapalap a tinätiu chopulap, ütten fau me fifi mi küri fanü. Iei usun ewe Samol mi Lapalap a apüngätiu ütten fau won ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Iwe, ei ütten fau mi püngütiu fiti fifi, eu ütten fau mi fokun chou, esap mwo fis ei sokun fän eu lon Isip seni poputän mwün. ");
INSERT INTO chk_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ei ütten fau a ni aramas me man meinisin mi nom lemäl won unusen ewe fanü Isip, a pwal atai iräkis me irämong meinisin mi nom lemäl. ");
INSERT INTO chk_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nge lon chök ewe fanü Kosen, ewe ia ekewe aramasen Israel ra nom ie, esap püngütiu ütten fau. ");
INSERT INTO chk_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Mürin, Farao a titi Moses me Aaron o üreniir, “Üa tipis lon ei fansoun. Ewe Samol mi Lapalap a pwüng, nge ngang me nei kewe aramas aia mwäl. ");
INSERT INTO chk_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Oupwe iotekin tüngor ngeni ewe Samol mi Lapalap pwe epwe aükätiu ewe chopulap me ütten fau, pun a kon lapalap. Üpwe mwüt ngenikemi pwe oupwe feila, nge üsap chüen amwöchükemi.” ");
INSERT INTO chk_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses a üreni Farao, “Lon ewe otun üpwe towu seni ei telinimw, üpwe aitietä pei o iotek ngeni ewe Samol mi Lapalap. Iwe, ewe chopulap epwe kaüla, esap pwal chüen püng ütten fau. Ren ei kopwe silei pwe ewe Samol mi Lapalap a fanüeni fanüfan. ");
INSERT INTO chk_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nge üa silei pwe en me noum kewe nöüwis ousap mwo niueiti Kot ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Iwe, ekewe irä iter fläks me parli ra tala, pun ekewe parli ra ua, nge ekewe fläks ra et. ");
INSERT INTO chk_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Nge ekewe irä iter wiich me spelt resap ta, pun ra pwükümang. ");
INSERT INTO chk_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses a feila seni Farao o towu lükün ewe telinimw, a aitietä pöün o iotek ngeni ewe Samol mi Lapalap. Iwe, ewe chopulap me ütten fau ra kaüla, nge ewe üt ese chüen püngütiu won fanüfan. ");
INSERT INTO chk_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Nge lupwen Farao a küna pwe ewe üt, ewe ütten fau me ewe chopulap ra kaüla, a pwal tipissefäl. I me nöün kewe nöüwis ra chök tipeförea usun me mwan. ");
INSERT INTO chk_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Iei usun Farao a chök tipeförea, pwe esap mwüt ngeni ekewe aramas pwe repwe feila, usun mine ewe Samol mi Lapalap a fen kapas ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, “Kopwe feila ren Farao, pun ngang üa fen aföreai letipan me letipen nöün kewe nöüwis, pwe üpwe föri ekewe manaman me leir. ");
INSERT INTO chk_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Nge en kopwe eäni apworaus ngeni noum me nöün noum mine üa föri ngeni chon Isip, pwal usun ekewe manaman üa föri me leir. Ren ei oupwe silei pwe ngang ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Iwe, Moses me Aaron ra feila ren Farao o üreni, “Iei alon ewe Samol mi Lapalap än chon Ipru we Kot, ‘Ifa ükükün fansoun om kosap mochen atekisonok me fän mesei? Kopwe mwüt ngeni nei aramas pwe repwe feila o fel ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Pun ika kosap mochen mwüt ngeni nei aramas pwe repwe feila, lesor üpwe le awarato lifichimas lon fanüom. ");
INSERT INTO chk_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Repwe pwölüela unusen ewe fanü, pwe ewe pwül esap chüen ling. Iwe, repwe eni met lusun ewe ütten fau esap atai, repwe pwal eni fotämi irä meinisin mi nom lemäl. ");
INSERT INTO chk_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Iwe, imwom epwe ur rer, pwal imwen noum kewe nöüwis me imwen chon Isip meinisin. Sememi me semen sememi resap mwo küna ei sokun fän eu, seni fansoun ar uputiu tori ikenai.’” Mürin, Moses a kul seni Farao o feila. ");
INSERT INTO chk_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Mürin, nöün Farao kewe nöüwis ra aisini Farao, “Ifa ükükün fansoun än ewe mwän epwe afeiengauakich? Kopwe mwüt ngeni ekewe mwän pwe repwe feila o fel ngeni ewe Samol mi Lapalap ar we Kot. Kose mwo silei pwe Isip a tala?” ");
INSERT INTO chk_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Iwe, ra aliwinato Moses me Aaron ren Farao, nge a üreniir, “Oupwe feila pwe oupwe fel ngeni ewe Samol mi Lapalap ämi we Kot. Nge iö kana repwe feila?” ");
INSERT INTO chk_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses a üreni, “Äm aipwe feila fiti nöüm kükün me chinlap, nöüm mwän me fefin pwal nöüm kewe sip me kow. Pun äm aipwe föri eu chulap ngeni ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Mürin, Farao a pälüeniir, “Ewe Samol mi Lapalap epwe etikemi ika üpwe mwüt ngenikemi me nöümi kana kükün pwe oupwe feila. A pwä pwe oua ekiekingau. ");
INSERT INTO chk_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Apwi! Ämi mwän chök oupwe feila o fel ngeni ewe Samol mi Lapalap, pun iei ämi tüngor.” Iwe, ra asüela Moses me Aaron seni fän mesen Farao. ");
INSERT INTO chk_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe aitiela poum won ewe fanü Isip pwe ekewe lifichimas repwe feito won ewe fanü o eni irän lon, ekewe irä meinisin mi chüen nom mürin ewe ütten fau.” ");
INSERT INTO chk_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Iei mine Moses a aitiela wokun won ewe fanü Isip, nge ewe Samol mi Lapalap a awarato asepwälin ötiu won ewe fanü lon unusen ewe rän me pwin. Nge sorotän ewe rän ewe asepwälin ötiu a fen awarato ekewe lifichimas. ");
INSERT INTO chk_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Iwe, ekewe lifichimas ra wareiti unusen ewe fanü Isip o sotiu won. Ei sokun ochochen pwiin lifichimas ese mwo pwäpwä me mwan, esap pwal pwä me mürin. ");
INSERT INTO chk_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ekewe lifichimas ra pwölüela won unusen ewe fanü pwe a kiroch rer. Ra eni irän ewe fanü meinisin mi chüen nom mürin ewe ütten fau, pwal uän ekewe irä. Esap chüen wor och mi arauarau won ekewe irätam me iräkis won unusen ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Iwe, Farao a müttir titi Moses me Aaron o üreniir, “Üa tipis ngeni ewe Samol mi Lapalap ämi we Kot, pwal ngenikemi. ");
INSERT INTO chk_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Iei oupwe amusala ai tipis pwal fän eu, oupwe iotekin tüngor ngeni ewe Samol mi Lapalap ämi we Kot pwe epwe angasaei seni ei mäfeiengau.” ");
INSERT INTO chk_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mürin, Moses a feila seni Farao o iotekin tüngor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Iwe, ewe Samol mi Lapalap a siwili ewe asepwälin ötiu ngeni enienin lotou a ässätä ekewe lifichimas o pönirelong lon ewe Setipar. Esap fokun nonom mwo eman lifichimas lon unusen ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nge ewe Samol mi Lapalap a aföreai letipen Farao pwe esap mwüt ngeni ekewe aramasen Israel repwe feila. ");
INSERT INTO chk_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe aitietä poum läng pwe epwe fis rochopwak won ewe fanü Isip, eu rochopwak esap wor eman a tongeni emereirei lon.” ");
INSERT INTO chk_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Iei mine Moses a aitietä pöün läng. Iwe, a fis rochopwak watte lon unusen ewe fanü Isip lon ükükün ülüngat rän. ");
INSERT INTO chk_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ekewe chon Isip resap tongeni künafengeniir, esap pwal wor eman mi mwöküt seni lenian lon ükükün ülüngat rän. Nge lon lenien aramasen Israel a wor saram. ");
INSERT INTO chk_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Mürin, Farao a körato Moses o üreni, “Oupwe feila o fel ngeni ewe Samol mi Lapalap, nöümi ra pwal tongeni etikemi, nge oupwe chök likitätiu foleniemi sip me kow.” ");
INSERT INTO chk_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Nge Moses a üreni, “Kopwe mwüt ngenikem man fän iten sokun asor me asoren kek, pwe aipwe tongeni asor ngeni ewe Samol mi Lapalap äm we Kot. ");
INSERT INTO chk_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Äm aipwe pwal uwei foleniem man. Esap fokun wor eman leir epwe tiwetiu. Äm aipwe püsin angei seni foleniem man fän iten äm fel ngeni ewe Samol mi Lapalap äm we Kot. Äm aisap mwo silei meni sokun man ika ifa ükükün aipwe eäni asor ngeni ewe Samol mi Lapalap, tori aipwe tikeri ewe leni.” ");
INSERT INTO chk_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nge ewe Samol mi Lapalap a aföreai letipen Farao, pwe esap mwüt ngeniir pwe repwe feila. ");
INSERT INTO chk_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Iwe, Farao a üreni Moses, “Kopwe sü seniei. Kopwe afäliik pwe kosap künasefäli mesei, pun lon ewe rän kopwe küna mesei kopwe fokun mäla.” ");
INSERT INTO chk_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Nge Moses a üra, “Mi pwüng reöm. Üsap künasefäli mesom.” ");
INSERT INTO chk_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, “Mi chüen wor eu feiengau üpwe awarato won Farao pwal won chon Isip. Mürin epwe mwüt ngenikemi pwe oupwe feila. Nge lupwen epwe mwüt ngenikemi pwe oupwe feila, epwe asüfocheekemiila. ");
INSERT INTO chk_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kopwe asilei ngeni ekewe aramasen Israel, pwe eman me eman mwän pwal fefin epwe tüngor seni chon arun fout seni silifer me kolt.” ");
INSERT INTO chk_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Iwe, ewe Samol mi Lapalap a fang ngeni ekewe aramas ümöümöch me ren ekewe chon Isip. Nge Moses a fokun iteföüla lon ewe fanü Isip fän mesen nöün Farao kewe nöüwis pwal fän mesen ekewe chon Isip. ");
INSERT INTO chk_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mürin, Moses a üreni Farao, “Iei alon ewe Samol mi Lapalap: Lukenipwinei üpwe asaifetal lemenen Isip. ");
INSERT INTO chk_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mwänichien lon ei fanü Isip meinisin repwe mäla, seni nöün Farao mwänichi, epwe siwili lon wisan wisen king, tori mwänichien nöün chon angang fefin amanau mi pwoni wiich, pwal tori mweinöün ekewe man meinisin. ");
INSERT INTO chk_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Iwe, epwe wor ngüngüres mi leüömong won unusen ewe fanü Isip, eu ngüngüres esamwo fifis me mwan, esap pwal fissefäl. ");
INSERT INTO chk_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nge lein chon Israel esap wor eman aramas ika man epwe feiengau, sap mwo nge eman kolak epwe awuwu ngeniir. Ren ei oupwe silei pwe ngang ewe Samol mi Lapalap üa föri eu aimwü lefilen chon Isip me chon Israel.” ");
INSERT INTO chk_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Iwe, Moses a sopwela le kapas, “Noum kei nöüwis meinisin repwe feito rei, repwe chapetiu fän mesei o tüngor rei, ‘Oupwe feila, en me ekana aramas meinisin ka wisen emweniir.’ Mürin üpwe feila.” Iwe, Moses a feila seni Farao fän watten an song. ");
INSERT INTO chk_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, “Farao esap fokun aüselingakemi, pwe ai kewe manaman repwe chomongola lon ewe fanü Isip.” ");
INSERT INTO chk_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mürin, Moses me Aaron ra föri ekei manaman meinisin fän mesen Farao. Nge ewe Samol mi Lapalap a aföreai letipen Farao, pwe esap mwüt ngeni ekewe aramasen Israel pwe repwe towu seni fanüan. ");
INSERT INTO chk_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron lon ewe fanü Isip, ");
INSERT INTO chk_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ei maram epwe iei aeuin maramen ier ngenikemi. ");
INSERT INTO chk_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kopwe kapas ngeni ekewe chon Israel, pwe lon engolun pwinin ei maram eman me eman mwän epwe angei eman lam fän iten en me an famili, eman lam nge eu famili. ");
INSERT INTO chk_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nge ika eu famili a chokükün pwe esap it eman lam rer, repwe inetfengen won me chon arur. Repwe püsin aükü ükükün fiteman aramas repwe eti, pwal ükükün ochän eman. ");
INSERT INTO chk_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ewe man oupwe afili, epwe eman ätemwän eu ierin esap wor terin. Oupwe angei seni me lein ekewe pwiin sip ika kuuch. ");
INSERT INTO chk_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Oupwe iseis ekewe lam tori engol me rüanün pwinin ei maram. Nge lekuniolupwin unusen ewe mwichen chon Israel repwe niela nöür lam. ");
INSERT INTO chk_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Mürin repwe angei ekis chan ewe lam o tofi ngeni penkasamen imwer lepekin me ruepek, pwal me asan, ewe ia ra ochoch ewe lam ie. ");
INSERT INTO chk_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Iwe, lon ewe pwin repwe arapa fitukan o ochoch fiti pilawa esap wor iis lon me chön irä mi kipwin. ");
INSERT INTO chk_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ousap ochamas ika kuku lon koluk, nge oupwe arapa fiti möküran me pechen pwal masouen lon. ");
INSERT INTO chk_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Iwe, ousap fokun likiti ekis lusun tori lesosor. Nge mine esap it remi tori lesosor oupwe kenala. ");
INSERT INTO chk_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Epwe iei usun lapalapemi le mongö: Oupwe ri lukalapemi, oupwe ipweip sus o amwöchü wokumi lepöümi. Oupwe tawat le mongö. Ei Pasofer än ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pun lon ewe pwinin üpwe fetalfeil lon ewe fanü Isip o niela ekewe mwänichi meinisin lein aramas me ekewe mweinöün man. Iwe, üpwe awarato ai apwüng won ekewe koten Isip meinisin, pun ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ewe cha epwe eu asisilen imwemi, pun lupwen üpwe küna ewe cha, üpwe lus me womi. Esap wor feiengau epwe kükemi, lupwen üpwe afeiengaua ekewe chon Isip. ");
INSERT INTO chk_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ei rän epwe eu ränin chulap fän itemi. Lon ei rän oupwe chechemeni mine ngang ewe Samol mi Lapalap üa föri. Seni eu täppin aramas tori eu täppin oupwe föri pwüngün ei rän tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Lon ükükün fisu rän oupwe mongö pilawa esap wor iis lon. Lon aeuin rän oupwe atowu ewe pilawa a wor iis lon me lon imwemi, pun ika eman me leimi epwe mongö och fiti iis seni aeuin rän tori afisuan, epwe käriwu me lein chon Israel. ");
INSERT INTO chk_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Iwe, lon aeuin rän oupwe föri eu mwich mi pin, pwal lon ewe afisuen rän. Ousap angang lon ekana rän, mine chök oupwe eni oupwe amolätä. ");
INSERT INTO chk_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Oupwe föri ewe chulapen mongö pilawa esap wor iis lon, pun lon ewe rän üa emwenawu ämi mwicheichen aramas seni lon ewe fanü Isip. Iei mine oupwe föri pwüngün ei rän seni eu täppin aramas tori eu täppin feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Iwe, lekuniolupwinin ewe engol me rüanün ränin ewe aeuin maram oupwe mongö pilawa esap wor iis lon tori lekuniolupwinin ewe rüe me aeuin rän. ");
INSERT INTO chk_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Iwe, lon ükükün fisu rän esap wor lon imwemi pilawa mi wor iis lon, pun ika eman epwe mongö och fiti iis, epwe käriwu me lein ekewe aramasen Israel. Ese lifilifil ika i eman chon ekis ika i eman chon wilipos. ");
INSERT INTO chk_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ousap fokun mongö och fiti iis, pun lon leniemi meinisin oupwe chök mongö pilawa esap wor iis lon.” ");
INSERT INTO chk_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mürin, Moses a körato ekewe souakomwen Israel meinisin o üreniir, “Oupwe afili ekewe man fän itemi ükükün chochon ämi famili o niela ewe lamen Pasofer. ");
INSERT INTO chk_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Iwe, oupwe angei ulun ewe irä itan isop o otukalong lon ewe sepien cha. Mürin oupwe tofi ewe cha ngeni penkasamen imwemi lepekin me ruepek pwal asan. Nge esap wor eman epwe towu seni imwan tori lesosor. ");
INSERT INTO chk_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Pun ewe Samol mi Lapalap epwe fetalfeil lon ewe fanü pwe epwe niela chon Isip. Nge lupwen epwe küna ewe cha won penkasamen imwemi lepekin me ruepek pwal asan, epwe lus me won imwemi. Iwe, esap mwüt ngeni ewe chon ninni epwe tolong lon imwemi o niikemi. ");
INSERT INTO chk_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Oupwe föri pwüngün ei rän fän itemi pwal fän iten nöümi kana tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Iwe, lupwen oupwe tori ewe fanü ewe Samol mi Lapalap a pwon pwe epwe ngenikemi, oupwe tümwünü pwüngün angangen ei rän. ");
INSERT INTO chk_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Pun lupwen nöümi repwe aisinikemi, ‘Met wewen ei angang?’, ");
INSERT INTO chk_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","oupwe üreniir, ‘Iei asorun än ewe Samol mi Lapalap Pasofer. Pun a lus me won imwen ekewe aramasen Israel lon Isip, lupwen a niela ekewe re Isip, nge esap niikich.’” Mürin, ekewe aramas ra chapetiu o fel ngeni Kot. ");
INSERT INTO chk_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Iwe, ekewe aramasen Israel ra feila o föri meinisin usun mine ewe Samol mi Lapalap a allük ngeni Moses me Aaron. ");
INSERT INTO chk_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Iwe, lukenipwin ewe Samol mi Lapalap a niela mwänichi meinisin lon ewe fanü Isip, seni nöün Farao mwänichi epwe siwili lon wisan wisen king, tori mwänichien nöün chon fötek mi nom lon imwen fötek, pwal mweinöün ekewe man meinisin. ");
INSERT INTO chk_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Iwe, Farao a pwätä lon ewe pwinin, i me nöün kewe nöüwis me chon Isip meinisin. Iwe, a fokun wor kechü me ngüngüres watte lon Isip, pun lon imw meinisin a wor mönümä. ");
INSERT INTO chk_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nge lon chök ewe pwinin Farao a titi Moses me Aaron o üreniir, “Oupwe towu seni lein nei aramas, ämi me ekewe aramasen Israel. Oupwe feila! Oupwe fel ngeni ewe Samol mi Lapalap, usun oua fen apasa. ");
INSERT INTO chk_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Oupwe angei nöümi sip me kow o feila usun oua fen apasa, nge oupwe pwal afeiöchüei.” ");
INSERT INTO chk_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Iwe, ekewe chon Isip ra pesei ngeni ekewe chon Israel pwe repwe müttir towu seni ewe fanü, pun ra apasa, “Kich meinisin sipwe le mäla.” ");
INSERT INTO chk_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Iwe, ekewe aramas ra angei ener pilawa mi öüwöü esamwo wor iis lon fiti sepier le öüwöü o firoskini, pwe repwe öüafara. ");
INSERT INTO chk_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Nge ekewe aramasen Israel ra fen föri usun mine Moses a üreniir, pun ra tüngor seni ekewe chon Isip fout seni silifer me kolt pwal mangaku. ");
INSERT INTO chk_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Iwe, ewe Samol mi Lapalap a ngeni ekewe aramas ümöümöch me ren ekewe chon Isip, pwe ra mwüt ngeniir mine ra tüngor. Iei usun ra angeala wöün chon Isip. ");
INSERT INTO chk_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Iwe, ekewe aramasen Israel ra sai seni Rameses, pwe repwe sai ngeni Sukot. Iteiten ekewe mwän mi asai wonopükü ngeröü lükün fefin me semirit. ");
INSERT INTO chk_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Pwal chomong sokopaten mwichen aramas ra etiir fiti chomong pwiin sip me kow. ");
INSERT INTO chk_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ra umuni ewe pilawa esap wor iis lon ra uweela seni Isip. Pokiten chon Isip ra asürela, resap tongeni witiwit pwe ewe pilawa epwe po, resap pwal tongeni amolätä amötür. ");
INSERT INTO chk_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Iwe, ekewe aramasen Israel ra nonom Isip lon ükükün föpükü ilik ier. ");
INSERT INTO chk_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Lon amüchülan ränin ekewe föpükü ilik ier, ekewe mwicheichen aramas än ewe Samol mi Lapalap meinisin ra towu seni ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Nge lon ewe pwinin ewe Samol mi Lapalap a mamas pwe epwe emwenirewu seni ewe fanü Isip. Iei mine ekewe aramasen Israel repwe mamas lon ei pwinin pwe repwe asamolu ewe Samol mi Lapalap, seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses me Aaron, “Iei allükün ewe Pasofer: Esap wor eman re ekis epwe mongö seni. ");
INSERT INTO chk_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nge iteiten amanau mi mön moni ra tongeni mongö seni mürin ar sirkomsais. ");
INSERT INTO chk_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Esap wor eman chon siamü ika chon angang mi angei liwin epwe tongeni mongö seni. ");
INSERT INTO chk_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Oupwe mongö ewe mongön Pasofer lon en me imwan, nge ousap uweela och fituk lükün imwemi. Ousap kupi efoch chün ewe lamen Pasofer. ");
INSERT INTO chk_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Iwe, ekewe chon Israel meinisin repwe föri pwüngün ei rän. ");
INSERT INTO chk_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Nge ika eman re ekis mi nom remi a mochen choni ewe mongön Pasofer än ewe Samol mi Lapalap, mwänin lon an we famili meinisin repwe akomwen sirkomsais. Mürin epwe tongeni choni. Iwe, epwe usun chök eman re wiliposun ewe fanü. Nge eman esap sirkomsais esap tongeni mongö seni. ");
INSERT INTO chk_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Iwe, epwe eu chök allük fän iten ekewe re wilipos me re ekis mi nom remi.” ");
INSERT INTO chk_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Iei usun ekewe aramasen Israel ra föri meinisin mine ewe Samol mi Lapalap a allük ngeni Moses me Aaron. ");
INSERT INTO chk_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Iwe, lon ewe chök ränin ewe Samol mi Lapalap a emwenawu ekewe aramasen Israel lon mwicheicher seni lon ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Oupwe apini fän itei ekewe mwänichi meinisin. Iwe, meinisin mine a akomwen uputiu lein aramas me man lon Israel nei.” ");
INSERT INTO chk_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Iwe, Moses a üreni ekewe aramas, “Oupwe chechemeni ei rän, ewe rän oua towu seni Isip, ewe leni ia ra nöünikemi amanau ie. Pun lon ei rän ewe Samol mi Lapalap a emwenikemiiwu ren pöün mi manaman. Ousap mongö pilawa mi wor iis lon. ");
INSERT INTO chk_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Pun lon ei rän fän ewe maram Apip oua towu seni Isip. ");
INSERT INTO chk_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Iwe, lupwen ewe Samol mi Lapalap epwe emwenikemiilong lon ewe fanüen chon Kanaan, chon Hit, chon Amor, chon Hiw me chon Jepus, ewe fanü i a pwon fän akapel ngeni ämi kewe lewo pwe epwe ngeniir, eu fanü mi pwülüöch me fanüeräs, oupwe föri ei angang iteiten ier lon ei chök maram. ");
INSERT INTO chk_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Oupwe mongö pilawa esap wor iis lon lon ükükün fisu rän, nge lon ewe afisuen rän oupwe föri eu chulap ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Oupwe fokun mongö pilawa esap wor iis lon lon ükükün fisu rän. Esap wor pilawa mi wor iis lon epwe pwä remi, esap pwal wor iis epwe pwä lon leniemi meinisin. ");
INSERT INTO chk_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Lon ewe rän oupwe awewei ngeni en me nöün mwän, ‘Iei achechemenien usun mine ewe Samol mi Lapalap a föri ngeniei, lupwen üa towu seni Isip.’ ");
INSERT INTO chk_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ei epwe usun chök eu asisil won pöümi pwal eu pisekin achem won chamwemi, pwe oupwe chök leaweni än ewe Samol mi Lapalap kewe allük. Pun ewe Samol mi Lapalap a emwenikemiiwu seni Isip ren pöün mi manaman. ");
INSERT INTO chk_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Iei mine oupwe föri pwüngün ei angang iteiten ier, lupwen a tori fansoun.” ");
INSERT INTO chk_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Iwe, lupwen ewe Samol mi Lapalap epwe emwenikemiilong lon ewe fanü Kanaan o fang ngenikemi ewe fanü usun a fen pwon fän akapel ngenikemi me ämi kewe lewo, ");
INSERT INTO chk_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","oupwe aimwüela fän iten ewe Samol mi Lapalap ät meinisin mi akomwen uputiu. Ekewe ätemwänin man meinisin mi akomwen uputiu repwe nöün ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Iwe, iteiten ätemwänin aas meinisin mi akomwen uputiu epwe akasiwil ngeni eman lam. Nge ika ousap mochen akasiwili, oupwe kupi üen ewe aas. Iteiten eman me eman mwänichi me lein nöümi mwän oupwe möni. ");
INSERT INTO chk_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Nge ika nöümi mwän repwe aisinikemi lon kan rän mwach, ‘Met wewen ei föför?’, oupwe üreniir, ‘Ewe Samol mi Lapalap a emwenikeemiwu seni Isip ren pöün mi manaman, ewe leni ia ra nöünikem amanau ie. ");
INSERT INTO chk_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pun lupwen Farao a tipeförea ren an esap mochen mwüt ngenikem pwe aipwe feila, ewe Samol mi Lapalap a niela mwänichien ewe fanü Isip meinisin, mwänichien aramas me mweinöün man. Iei mine aia eäni asor ngeni ewe Samol mi Lapalap ätemwänin man meinisin mi akomwen uputiu. Nge ekewe mwänichien lein nöüm mwän aia möni.’ ");
INSERT INTO chk_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ei epwe usun chök eu asisil won pöümi pwal eu pisekin achem won chamwemi. Pun ewe Samol mi Lapalap a emwenikichewu seni Isip ren pöün mi pöchökül.” ");
INSERT INTO chk_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Iwe, lupwen Farao a mwüt ngeni ekewe aramas pwe repwe towu seni Isip, Kot esap emwenirela won alen fanüen chon Filistia, inamwo ika a mochomoch. Pun Kot a apasa, “Eli ekewe aramas repwe ekieksefäl o liwiniti Isip, lupwen epwe toriir maun.” ");
INSERT INTO chk_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Iei mine Kot a emwenirela lükün ewe fanü won efoch al mi alelong lon fanüapö tori ewe Setipar. Iwe, ekewe aramasen Israel ra towu seni Isip fän ar pisekin maun. ");
INSERT INTO chk_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Nge Moses a uwei chün Josef usun i a tüngorei ekewe aramasen Israel repwe pwon fän akapel pwe repwe uwei chün. Pun Josef a apasa, “Kot epwe fokun alisikemi, nge lupwen oupwe towu, oupwe uwei chüi seni ikei.” ");
INSERT INTO chk_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Iwe, ekewe chon Israel ra feil seni Sukot o tori Etam mi nom ünükün ewe fanüapö. Ikenan ra asösö. ");
INSERT INTO chk_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Nge ewe Samol mi Lapalap a akakom mwer. A emweniir won aler lerän ren eu ürekuchu, nge lepwin ren eu üreekkei pwe epwe ngeniir saram. Iei usun ra tongeni sai lerän me lepwin. ");
INSERT INTO chk_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ewe ürekuchu esap feil seni ekewe aramas lerän, pwal ewe üreekkei esap feil seniir lepwin. ");
INSERT INTO chk_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Kopwe üreni ekewe aramasen Israel pwe repwe liwinsefäl o asösö sasape ngeni Pihahirot lefilen Miktol me ewe Setipar. Iwe, repwe asösö arun ewe Setipar akawenewenen Paalsefon. ");
INSERT INTO chk_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pun Farao epwe ekieki pwe ekewe aramasen Israel ra rukola lon ewe fanü o mwöchülong lon fanüapö. ");
INSERT INTO chk_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Iwe, ngang üpwe aföreai letipen Farao pwe epwe tapweriir. Pun üpwe alinga itei won Farao me nöün mwicheichen sounfiu, pwe chon Isip meinisin repwe silei pwe ngang ewe Samol mi Lapalap.” Iwe, ekewe chon Israel ra föri iei usun. ");
INSERT INTO chk_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Iwe, lupwen ra apworausa ngeni ewe kingen Isip pwe ekewe aramasen Israel ra sü, Farao me nöün kewe nöüwis ra siwili ar ekiek fän iter. Ra apasa, “Met ei sa föri? Pwota sa mwüt ngeni ekewe chon Israel pwe ra towu seni ar angang ngenikich?” ");
INSERT INTO chk_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Iei mine Farao a anükünükü wan woken me oris o emwichato nöün sounfiu. ");
INSERT INTO chk_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","A nuki wonopükü woken me oris mi nükünüköch, pwal meinisin lusun wokenin me orisin Isip, nge a wor eman meilap won iteiten efoch me efoch. ");
INSERT INTO chk_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Nge ewe Samol mi Lapalap a aföreai leluken Farao ewe kingen Isip, pwe a tapweri ekewe aramasen Israel, lupwen ra töpworawu. ");
INSERT INTO chk_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Iwe, ewe pöisein Isip meinisin wän Farao oris me woken, fiti sounfiu mi wawa oris me sounfiu mi fetal ra tapweriir o toriir, lupwen ra asösö arosetin Pihahirot akawenewenen Paalsefon. ");
INSERT INTO chk_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Lupwen Farao a arap ngeniir, ekewe aramasen Israel ra chimwätä o küna pwe ekewe chon Isip ra telito müriir. Iwe, ra fokun niuokus o siö ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ra üreni Moses, “Ifa usun, esap wor lenien peias lon Isip, pwe ka emwenikeemiwu pwe aipwe mäla lon fanüapö? Pwota ka föri iei usun ngenikem pwe ka emwenikeemiwu seni Isip? ");
INSERT INTO chk_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Esap iei usun mine äm aia ürenuk me Isip, pwe kopwe chök likitikeemila pwe aipwe angang ngeni ekewe chon Isip? Pun epwe fen mürina ngenikem pwe ekewe chon Isip repwe nöünikem amanau, lap seni äm aipwe mäla lon fanüapö.” ");
INSERT INTO chk_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nge Moses a üreni ekewe aramas, “Ousap niuokus, oupwe üpos o nengeni usun än ewe Samol mi Lapalap amanauakemi ikenai. Pun ekewe re Isip oua küneer ikenai, ousap chüen künasefäliir. ");
INSERT INTO chk_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ewe Samol mi Lapalap epwe fiu fän itemi, nge ämi oupwe chök fanafanala.” ");
INSERT INTO chk_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mürin, ewe Samol mi Lapalap a üreni Moses, “Pwota ka siö ngeniei? Kopwe üreni ekewe aramas pwe repwe chök feila mwer. ");
INSERT INTO chk_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Iwe, en kopwe aitietä wokum o aitiela poum won ewe sät pwe kopwe kinifeseni, pwe ekewe aramasen Israel repwe fetal won pwasapwas epin ewe sät. ");
INSERT INTO chk_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nge ngang üpwe aföreai letipen chon Isip pwe repwe tapwelong müriir. Iwe, üpwe alingaei won Farao me nöün mwicheichen sounfiu, won wan woken me oris, pwal won nöün sounfiu mi wawa oris. ");
INSERT INTO chk_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Iwe, ekewe chon Isip repwe silei pwe ngang ewe Samol mi Lapalap, lupwen üpwe pwärala ai ling won Farao me wan woken me oris, pwal won nöün sounfiu mi wawa oris.” ");
INSERT INTO chk_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Mürin, nöün Kot we chon läng mi akom mwen ewe mwicheichen chon Israel a feila lükisökürür. Pwal ewe ürekuchu a mwöküt seni mwer o ütä lükisökürür, ");
INSERT INTO chk_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","pwe epwe nonom lefilen ewe mwicheichen re Isip me ewe mwicheichen chon Israel. Lon ewe pwinin, ewe ürekuchu a rochopwak kuku ngeni ekewe re Isip, nge a asarama kuku ngeni chon Israel, pwe resap tongeni chufengen lon unusen ewe pwin. ");
INSERT INTO chk_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mürin, Moses a aitiela pöün won ewe sät, nge ewe Samol mi Lapalap a aliwini ewe sät ren enienin ötiu mi fokun pöchökül lon unusen ewe pwin, pwe ewe sät a pwasatä, nge ewe lölö a kinikinfesen. ");
INSERT INTO chk_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Iwe, ekewe aramasen Israel ra fetal lukalapen ewe sät won pwasapwas, nge ewe lölö a usun chök etip lepelifichir me lepelimöngür. ");
INSERT INTO chk_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Iwe, ekewe re Isip pwal nöün Farao oris, wan woken me nöün sounfiu mi wawa oris meinisin ra tapwerirelong lukalapen ewe sät. ");
INSERT INTO chk_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Nge wünümweerän ewe Samol mi Lapalap a netiu me lon ewe üreekkei me ürekuchu won ekewe mwicheichen re Isip o afitikokoor, ");
INSERT INTO chk_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","pun a mwöch willen war woken, pwe ra weires le kul. Iwe, ekewe re Isip ra apasa, “Ousipwe sü seniir, pun ewe Samol mi Lapalap a peni chon Israel o fiu ngenikich.” ");
INSERT INTO chk_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe aitiela poum won ewe sät pwe lölön lon epwe liwinfengen won ekewe re Isip, won war woken pwal won nöür sounfiu mi wawa oris.” ");
INSERT INTO chk_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Iei mine Moses a aitiela pöün won ewe sät, nge lesosorusich ewe sät a liwinfengen usun chök me mwan. Iwe, ekewe re Isip ra süwu me lon, nge ewe Samol mi Lapalap a amopuretiu lukalapen ewe sät. ");
INSERT INTO chk_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Lölön lon a liwinfengen o pwölüela ekewe woken me ekewe sounfiu mi wawa oris, nöün Farao mwichen sounfiu meinisin mi tapweralong chon Israel lon ewe sät. Esap fokun wor eman leir a chüen manau. ");
INSERT INTO chk_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Iwe, ekewe aramasen Israel ra fetal won pwasapwas epin ewe sät, nge ewe lölö a usun chök etip lepelifichir me lepelimöngür. ");
INSERT INTO chk_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Lon ena rän ewe Samol mi Lapalap a amanaua chon Israel seni ekewe re Isip. Iwe, ekewe chon Israel ra küna somän ekewe re Isip arosetin ewe leni. ");
INSERT INTO chk_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Lupwen ekewe chon Israel ra küna än ewe Samol mi Lapalap manaman a föri ngeni ekewe re Isip, ra meniniti ewe Samol mi Lapalap, ra pwal lükü i me nöün we chon angang Moses. ");
INSERT INTO chk_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mürin, Moses me ekewe aramasen Israel ra köl ei köl ngeni ewe Samol mi Lapalap, “Üpwe köl ngeni ewe Samol mi Lapalap, pun an win a fokun amwarar. A aturalong lon ewe sät ewe oris me ewe mi wisen wawa. ");
INSERT INTO chk_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ewe Samol mi Laplap ai pöchökül me ai köl, i a amanauaei. I ai Kot, üpwe mwareiti, i än semelapei we Kot, üpwe alinga. ");
INSERT INTO chk_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ewe Samol mi Lapalap eman soumaun, itan Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","A aturalong leset nöün Farao woken me oris, pwal nöün mwicheichen sounfiu. Nöün meilapen sounfiu mi lipwäköch ra mop lon ewe Setipar. ");
INSERT INTO chk_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Iwe, lölön lon a pwölürela, ra kokotiu epin ewe sät usun eföü fau. ");
INSERT INTO chk_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ai Samol mi Lapalap, pöüifichum a lingela lon an manaman. Ai Samol mi Lapalap, pöüifichum a atatakisi chon oputok. ");
INSERT INTO chk_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Lon unusen om manaman ka aturätiu chokewe mi pälüenuk, ka tinato om song mi pöchökül, pwe a fisiir usun fetilipwas. ");
INSERT INTO chk_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ren enienin lon pwötum ewe sät a chukuchukutä, ewe lölön lon a ütä usun etip, epin ewe sät a pöchökülela me lukalapan. ");
INSERT INTO chk_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ewe chon oputakem a apasa, ‘Üpwe tapweriir, üpwe liapeniir o ineti liapei, üpwe ameseikaei wor. Iwe, üpwe üttawu nei ketilas, pei epwe aroserela.’ ");
INSERT INTO chk_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nge en ka pönato asepwälum, ewe sät a pwölürela, ra kokotiu usun pilom lon ewe lölö mi lapalap. ");
INSERT INTO chk_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ai Samol mi Lapalap, iö a wewe ngonuk lein ekewe kot? Iö a wewe ngonuk lon om pin mi tekia, pwal lon om föför mi ling o eniwokus me lon om föri manaman? ");
INSERT INTO chk_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ka aitiewu pöüifichum, nge fanüfan a oromala chon oputem. ");
INSERT INTO chk_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Lon om tong ellet ka emweni ekewe aramas ka amanaueer, ka emwenirela ren om pöchökül ngeni leniom mi pin. ");
INSERT INTO chk_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Lupwen chon ekewe mwü ra rongorong usun, ra chechech, niuokus watte a tori ekewe chon Filistia. ");
INSERT INTO chk_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ekewe samolun Etom ra fokun niuokus, ekewe aramas mi pwora seni Moap ra chechech, nge chokewe ra nonom lon Kanaan ra fokun rükö ren ar niuokus. ");
INSERT INTO chk_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Niuokus me rükö a feitiu wor. Ai Samol mi Lapalap, pokiten manamanen poum ir ra chouchoula usun eföü fau, tori noum aramas ra nuula, tori chokewe ka angaseer ra nuula. ");
INSERT INTO chk_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ai Samol mi Lapalap, en kopwe emwenirelong lon ewe fanü o fotukiretiu won chukum, ewe leni ka püsin föri pwe kopwe nonom lon, ewe leni mi pin ka afisätä ren poum, ai Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","En Samol mi Lapalap kopwe nemenem tori feilfeilachök.” ");
INSERT INTO chk_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ekewe aramasen Israel ra fetal won pwasapwasen epin ewe sät. Nge lupwen nöün Farao oris me wan woken pwal nöün sounfiu mi wawa oris ra pwal tolong lon, ewe Samol mi Lapalap a aliwinato lölön ewe sät wor. ");
INSERT INTO chk_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Iwe, Miriam fefinen Aaron eman soufos fefin a angei an pisekin kaktai, nge ekewe fefin meinisin ra tapwela mürin fän ar pisekin kaktai o pworuk. ");
INSERT INTO chk_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam a emweniir le köl, “Sipwe köl ngeni ewe Samol mi Lapalap, pun an win a fokun amwarar. A aturalong lon ewe sät ekewe oris me ätekewe mi wisen wawa.” ");
INSERT INTO chk_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mürin, Moses a emwenala chon Israel seni ewe Setipar o emwenirelong lon ewe fanüapön Sur. Iwe, ra sai lon ewe fanüapö ükükün ülüngat rän, nge resap künakün koluk. ");
INSERT INTO chk_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Nge lupwen ra tori Mara, resap tongeni ün kolukun Mara, pun a maras. Iei mine ewe leni a iteni Mara . ");
INSERT INTO chk_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Iwe, ekewe aramas ra lal ngeni Moses o üreni, “Met aipwe ünümi?” ");
INSERT INTO chk_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mürin, Moses a kökköri ewe Samol mi Lapalap, nge ewe Samol mi Lapalap a aiti ngeni efoch irä. Iwe, a aturalong ewe irä lon ewe koluk, mürin ewe koluk a öchün ün. Ikenan ewe Samol mi Lapalap a ngeniir an allük me pwüüng pwe repwe apwönüretä. Ikenan a sotuniir ");
INSERT INTO chk_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","o apasa, “Are oupwe likiitü le aüselinga mweliei ngang ewe Samol mi Lapalap ämi we Kot o föri mine a pwüng me fän mesei, are oupwe aleasochis ngeni ai kewe allük o apwönüetä ai kewe pwüüng meinisin, üsap uwato womi eu lein ekewe samau üa uwato won chon Isip, pun ngang ewe Samol mi Lapalap ämi sousafei.” ");
INSERT INTO chk_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Mürin ra tori Elim, ia a wor ie engol me ruu chönüttu pwal fik irä palm. Iwe, ra asösö ikenan arun ewe koluk. ");
INSERT INTO chk_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Mürin ekewe chon Israel meinisin ra feil seni Elim. Nge lon engol me limuen ränin aruuen maram mürin ar towu seni Isip ra tori ewe fanüapön Sin a nom lefilen Elim me Sinai. ");
INSERT INTO chk_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nge unusen ewe mwichen chon Israel ra lal ngeni Moses me Aaron lon ewe fanüapö. ");
INSERT INTO chk_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Iwe, ra üreniir, “Amwo aipwe fen mäla ren pöün ewe Samol mi Lapalap lon Isip, lupwen aia mot ngeni ekewe sepien fituk o mongö chomong sokun mongö. Nge ämi oua emwenikeemilong lon ei fanüapö pwe oupwe nikem meinisin ren echik.” ");
INSERT INTO chk_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Mürin, ewe Samol mi Lapalap a üreni Moses, “Üpwe apüngätiu mongö remi seni läng. Iwe, ekewe aramas repwe towu iteiten rän o ioni ükükün mongön eu chök rän, pwe üpwe sotuniir ika repwe apwönüetä ai allük ika resap. ");
INSERT INTO chk_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Iwe, lon awonuen rän repwe amolätä ionier mongö, nge epwe ükükün mongön ruu rän.” ");
INSERT INTO chk_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mürin, Moses me Aaron ra üreni ekewe aramasen Israel meinisin, “Lekuniolei oupwe mefi pwe ewe Samol mi Lapalap i ewe mi emwenikemiiwu seni Isip. ");
INSERT INTO chk_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Nge lesosor oupwe küna lingen ewe Samol mi Lapalap, pun a rongorong ämi lal ngeni. Pun iö äm pwe oua lal ngenikem?” ");
INSERT INTO chk_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moses a pwal üra, “Ewe Samol mi Lapalap epwe ngenikemi fituk lekuniol pwe oupwe ochoch, nge lesosor epwe ngenikemi pilawa ükükün ämi mochen, pun a rongorong ämi lal ngeni. Pun iö äm? Ousap lal ngenikem, pwe oua lal ngeni ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mürin, Moses a kapas ngeni Aaron, “Kopwe üreni ekewe aramasen Israel meinisin pwe repwe kanoto fän mesen ewe Samol mi Lapalap, pun a rongorong ar lal.” ");
INSERT INTO chk_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Iwe, lupwen Aaron a fofos ngeni ekewe aramas, ra kul ngeni ewe fanüapö, nge lon ei otun lingen ewe Samol mi Lapalap a pwä lon ewe kuchu. ");
INSERT INTO chk_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Üa rongorong än ekewe aramasen Israel lal. Kopwe üreniir, ‘Lefäf oupwe ochoch fituk, nge lesosor oupwe mongö pilawa ükükün mötümi. Mürin oupwe silei pwe ngang ewe Samol mi Lapalap ämi we Kot.’” ");
INSERT INTO chk_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Iwe, lon ewe kuniolun mansüsü iter kweil ra ässito o pwölüela ewe leni ia ra nonom ie. Nge lesosor amurenipwin a nom pwelin ünükün ewe leni. ");
INSERT INTO chk_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Nge lupwen ewe amurenipwin a morola, a wor won pwülün ewe fanüapö och sättin mettoch mi chächäk usun snow. ");
INSERT INTO chk_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Iwe, lupwen aramasen Israel ra küna, ra kapasfengen lefiler, “Met ei?” Pun resap silei met ewe. Nge Moses a üreniir, “Iei ewe mongö ewe Samol mi Lapalap a fangoto remi pwe oupwe mongö. ");
INSERT INTO chk_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Iei usun ewe Samol mi Lapalap a allük, ‘Oupwe ionifengeni ei mettoch iteiten eman me eman ükükün anan. Oupwe angei ina epwe ükükün masouen esop kalon fän iten eu pöpön mökür lon en me imwan imw mangaku.’” ");
INSERT INTO chk_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Iwe, ekewe aramasen Israel ra föri iei usun. Ra ionifengeni ewe mettoch, ekoch ra ioni chomong, nge ekoch kükün seni. ");
INSERT INTO chk_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nge lupwen ra aükük mine ra ioni, a pwä pwe ätewe mi chomong ionian esap wor somwan, nge ätewe mi kükün ionian esap nafangau ionian. Eman me eman a chök ioni ükükün anan. ");
INSERT INTO chk_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mürin, Moses a üreniir, “Ousap isoni ekis seni ewe mongö tori lesosor.” ");
INSERT INTO chk_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nge ekoch me leir resap aüselinga alon Moses, pun ra iseis och tori lesosor. Iwe, ewe mongö a wul o pongau. Nge Moses a song ngeniir. ");
INSERT INTO chk_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Iteiten lesosor ra ionifengeni ewe mongö, eman me eman ükükün anan. Nge lupwen akkar a pwichikar, a telila ewe mongö. ");
INSERT INTO chk_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Iwe, lon awonuen rän ra ionifengeni ükükün masouen eu kalon fän iten eman me eman. Nge lupwen ekewe meilapen chon Israel ra feito ren Moses o asile ngeni, ");
INSERT INTO chk_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moses a üreniir, “Iei usun mine ewe Samol mi Lapalap a allük pwe lesor eu ränin asösö, eu ränin sapat mi pin fän iten ewe Samol mi Lapalap. Ikenai oupwe umuni mine oua mochen umuni, oupwe pwal kuku mine oua mochen kuku, nge mine a lusun, oupwe iseis ngeni lesor.” ");
INSERT INTO chk_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Iei mine ra iseis ener mongö ngeni lesor, usun Moses a allük ngeniir, nge esap pongau, esap pwal wul. ");
INSERT INTO chk_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Iwe, Moses a üra, “Oupwe eni ei mongö ikenai, pun ikenai ewe ränin sapat fän iten ewe Samol mi Lapalap. Ikenai ousap küna ei mongö me lükün. ");
INSERT INTO chk_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Lon ükükün wonu rän oupwe ionifengeni ei mongö, nge lon afisuen rän, ewe ränin sapat, esap wor ewe mongö.” ");
INSERT INTO chk_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Iwe, lon afisuen rän ekoch me lein ekewe aramas ra towu lükün pwe repwe ioni ewe mongö, nge resap künakün. ");
INSERT INTO chk_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Mürin, ewe Samol mi Lapalap a üreni Moses, “Ifa ükükün fansoun ämi ousap mochen aleasochisi ai kewe allük me pwüüng? ");
INSERT INTO chk_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Oupwe chechemeni pwe ngang ewe Samol mi Lapalap üa ngenikemi ewe ränin sapat, iei mine üa pwal ngenikemi ükükün mongön ruu rän lon ewe awonuen rän. Nge lon ewe afisuen rän eman me eman leimi epwe chök nom lon lenian, esap wor eman epwe towu seni.” ");
INSERT INTO chk_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Iei usun ekewe aramas ra asösö lon ewe afisuen rän. ");
INSERT INTO chk_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Iwe, ekewe chon Israel ra aita ngeni ewe mongö mana. A usun kükün föün irä mi oleolepwech, nge nennan a usun chök nennen okasi mi nofit ngeni chönün chunen. ");
INSERT INTO chk_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses a üra, “Iei usun mine ewe Samol mi Lapalap a allük, ‘Oupwe iseis ei mongö ükükün masouen esop kalon, epwe nom pwe mwirimwirimi repwe küna ei mongö üa amongöü ngenikemi lon fanüapö, lupwen üa emwenikemiiwu seni Isip.’” ");
INSERT INTO chk_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Iei mine Moses a üreni Aaron, “Kopwe angei eu pör, kopwe iseis ükükün masouen esop kalon mana lon o anomu fän mesen ewe Samol mi Lapalap, epwe nom fän iten mwirimwirimi.” ");
INSERT INTO chk_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Usun mine ewe Samol mi Lapalap a allük ngeni Moses, iei usun Aaron a iseis ewe mongö mwen ekewe allük, pwe epwe nonom ie. ");
INSERT INTO chk_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Iwe, ekewe aramasen Israel ra mongö ewe mana lon ükükün faik ier tori ra tikeri fanü mi so. Ra mongö ewe mana tori ra ipwelong lon kiännin ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ewe aükük ra eäni longolong fän iten mettoch mi pwas lon ena fansoun, ina epwe ükükün limu kalon. ");
INSERT INTO chk_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Iwe, ekewe chon Israel meinisin ra towu seni ewe fanüapön Sin o sai seni eu leni tori pwal eu, usun ewe Samol mi Lapalap a allük ngeniir. Iwe, ra tori Refitim o aüetä imwer. Nge ikenan esap wor ünümer koluk. ");
INSERT INTO chk_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Iei mine ekewe aramas ra anini ngeni Moses o üreni, “Kopwe aünükem koluk.” Iwe, Moses a üreniir, “Pwota oua anini ngeniei? Pwota oua sotuni ewe Samol mi Lapalap?” ");
INSERT INTO chk_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Nge ekewe aramas ra fokun kakan koluk, pwe ra lal ngeni Moses o apasa, “Pwota ka emwenikeemiwu seni Isip? Ifa usun, kopwe niikem me nöüm pwal nöüm pwiin man ren om emwenikeemito lon ei leni ese wor koluk lon?” ");
INSERT INTO chk_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Iwe, Moses a siö ngeni ewe Samol mi Lapalap, “Met üpwe föri ngeni ekei aramas? Arapakan chök ar repwe monei ngeniei fau.” ");
INSERT INTO chk_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, “Kopwe nuki ekoch seni ekewe souakomwen Israel o akomwola mwen ekewe aramas. Kopwe feila o uwei ewe wok ka wichi ngeni ewe chanpupu Nil. ");
INSERT INTO chk_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ngang üpwe ütä o sounuk won ewe achau mi nom lepekin ewe chuk Horep. Kopwe wichi ewe achau pwe koluk epwe puwu seni, pwe ekewe aramas repwe tongeni ün.” Iwe, Moses a föri iei usun fän mesen ekewe souakomwen Israel. ");
INSERT INTO chk_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Iwe, a aita ngeni ewe leni Massa me Meripa , pun ekewe aramasen Israel ra anini ngeni Moses, ra pwal sotuni ewe Samol mi Lapalap ren ar apasa, “Ifa usun, ewe Samol mi Lapalap a nom leich ika esap?” ");
INSERT INTO chk_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Iwe, chon Amalek ra war pwe repwe maun ngeni chon Israel lon Refitim. ");
INSERT INTO chk_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nge Moses a üreni Josua, “Kopwe filätä ekoch mwän o feila pwe kopwe maun ngeni ekewe chon Amalek. Nge lesor ngang üpwe ütä won ungen ewe chuk fän ewe wokun Kot mi nom lepei.” ");
INSERT INTO chk_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josua a föri mine Moses a üreni, a feila o maun ngeni ekewe chon Amalek. Nge Moses, Aaron me Hur ra feitä won ungen ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Iwe, lupwen Moses a aitietä pöün, chon Israel ra win. Nge lupwen a uwätiu pöün, chon Amalek ra win. ");
INSERT INTO chk_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Nge pöün Moses a malülü. Iei mine ra angei eföü fau o amotätiu Moses won. Nge Aaron me Hur ra amwöchätä pöün, eman epek pwal eman epek. Iei usun pöün Moses ra itifochetä tori akkar a tuputiu. ");
INSERT INTO chk_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Iwe, Josua a akufu ekewe sounfiun Amalek meinisin o nirela. ");
INSERT INTO chk_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe makei ei pworaus lon eu puk pwe aramas repwe chechemeni. Kopwe pwal üreni Josua pwe üpwe fokun arosala ekewe chon Amalek, pwe esap wor eman epwe chechemeniir me won fanüfan. ");
INSERT INTO chk_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Iwe, Moses a senätä eu rongen asor o aita ngeni ‘Ewe Samol mi Lapalap ai filaik’ . ");
INSERT INTO chk_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","A apasa, “Pokiten ekewe chon Amalek ra maun ngeni ekewe chon Israel, ewe Samol mi Lapalap epwe maun ngeni ekewe chon Amalek seni eu täppin aramas tori eu täppin.” ");
INSERT INTO chk_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Iwe, Setiro ewe souasor seni Mitian semen pwülüen Moses a rongorong meinisin mine Kot a föri fän iten Moses pwal fän iten nöün aramasen Israel, lupwen a emwenirewu seni Isip. ");
INSERT INTO chk_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Lon ena fansoun Setiro a anomu Sipora pwülüen Moses, pun Moses a likiti ngeni ");
INSERT INTO chk_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","me nöün kewe ruoman ät. Iwe, iten eman Kersom, pun Moses a apasa, “Ngang eman chon siamü lon fanüen chon ekis.” ");
INSERT INTO chk_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Nge iten pwal ewe eman Elieser, pun a apasa, “Än semei we Kot a alisiei o angasaei seni än Farao mochen nieila.” ");
INSERT INTO chk_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Iwe, Setiro semen pwülüen Moses a feito fiti nöün Moses kewe me pwülüan we lon ewe fanüapö ia Moses a nom ie arap ngeni ewe chukun Kot. ");
INSERT INTO chk_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Iwe, eman a asile ngeni Moses, “Setiro semen pwülüom we a war fiti pwülüom we me nöün kewe ruoman ät.” ");
INSERT INTO chk_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Iei mine Moses a feila pwe epwe churi semen pwülüan we. Iwe, a pworotiu me mwan o mitiri, nge wesin ar akaisfengen usun pworauser, ra tolong lon imwen Moses imw mangaku. ");
INSERT INTO chk_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mürin, Moses a apworausa ngeni semen pwülüan we meinisin mine ewe Samol mi Lapalap a föri ngeni Farao me chon Isip meinisin, lupwen a angasa chon Israel. A pwal apworausa ngeni usun chomong weires a toriir lupwen ar sai, pwal usun än ewe Samol mi Lapalap amanaueer. ");
INSERT INTO chk_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Iwe, Setiro a pwapwaäsini än ewe Samol mi Lapalap föför mürina meinisinn ngeni chon Israel, pwe a angaserewu seni fän nemenien ekewe chon Isip. ");
INSERT INTO chk_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Iwe, Setiro a apasa, “Üpwe mwareiti ewe Samol mi Lapalap, a angasakemiiwu seni fän nemenien chon Isip, pwal seni lepöün Farao. ");
INSERT INTO chk_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Iei üa silei pwe ewe Samol mi Lapalap a tekia seni ekewe kot meinisin, pun a angasa ekewe aramasen Israel seni lepöün chon Isip, lupwen ra turunufaseer.” ");
INSERT INTO chk_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mürin, Setiro semen pwülüen Moses a eäni asoren kek me sokun asor ngeni Kot, nge Aaron me ekewe souakomwen Israel ra feito pwe repwe mongöfengen me semen pwülüen Moses fän mesen Kot. ");
INSERT INTO chk_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Iwe, sorotän ewe rän Moses a mot pwe epwe eäni kapwüngün ekewe aramas. Nge ekewe aramas ra ütä ünükün Moses seni lesosor tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Iwe, lupwen semen pwülüen Moses a küna meinisin mine Moses a föri fän iten ekewe aramas, a aisini, “Met ei ka föri fän iten ekewe aramas? Pwota ka mot akaleman le eäni kapwüng, nge ekewe aramas ra ütä ünükum seni lesosor tori lekuniol?” ");
INSERT INTO chk_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Iwe, Moses a üreni semen pwülüan we, “Ekewe aramas ra feito rei pwe üpwe kütta letipen Kot fän iter. ");
INSERT INTO chk_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Lupwen ra fitikokofengen, ra feito rei pwe üpwe apwüngü lefilen eman me eman, üa pwal asile ngeniir än Kot allük me pwüüng.” ");
INSERT INTO chk_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mürin, semen pwülüen Moses a üreni, “Esap öch ngonuk mine ka föri. ");
INSERT INTO chk_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","En me ekewe aramas oupwe chök apwangapwangala, pun ei angang a kon chou ngonuk, kosap tongeni akaleman le föri. ");
INSERT INTO chk_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Iei kopwe aüselinga aloi. Üpwe aiti ngonuk mefiei, nge Kot epwe etuk. En kopwe tupuni ekewe aramas fän mesen Kot le uwato ar fitikoko ren. ");
INSERT INTO chk_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kopwe pwal aiti ngeniir än Kot allük me pwüüng o afata ngeniir mine a pwüng ngeni manauer, pwal mine repwe föri. ");
INSERT INTO chk_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nge kopwe filätä me lein ekewe aramas mwän mi lipwäköch o meniniti Kot, ir mi wenechar o oput lifangen amichimich. Ekei sokun mwän kopwe seikiretä, pwe repwe nemenem won ngeröü me pükü, won lime me engol aramas. ");
INSERT INTO chk_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Iwe, ir repwe eäni kapwüngün ekewe aramas fansoun meinisin. Iteiten fitikoko mi weires repwe uwato reöm, nge ekewe fitikoko mi kis repwe püsin apwüngü. Iei usun ewe angang epwe ekis mecheres ngonuk, nge ir repwe pwal mwärelong fän om weires. ");
INSERT INTO chk_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Are kopwe föri ei, Kot epwe apöchökülok pwe kopwe tufichin sopwela ei angang. Iwe, ekei aramas meinisin repwe pwal liwiniti lenier fän kinamwe.” ");
INSERT INTO chk_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Iwe, Moses a aüselinga alon semen pwülüan we o apwönüetä meinisin mine a üra. ");
INSERT INTO chk_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","A filätä mwän mi lipwäköch me lein chon Israel meinisin o seikiretä pwe repwe nemenem won ekewe aramas, won ngeröü me pükü, won lime me engol. ");
INSERT INTO chk_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Iwe, ra eäni kapwüngün ekewe aramas fansoun meinisin. Ekewe fitikoko mi weires ra uwato ren Moses, nge ekewe fitikoko mi kis ra püsin apwüngü. ");
INSERT INTO chk_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mürin, Moses a afeilai semen pwülüan we pwe a liwiniti poputän fanüan. ");
INSERT INTO chk_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Iwe, lon aeuin ränin ewe aülüngatin maram mürin än ekewe aramasen Israel towu seni Isip, lon ewe chök rän ra tolong lon ewe fanüapön Sinai. ");
INSERT INTO chk_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Iwe, lupwen ra sai seni Refitim, ra tori ewe fanüapön Sinai o nom ie. Ikenan chon Israel ra aüetä imwer imw mangaku sasape ngeni ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mürin, Moses a feitä won ewe chuk ren Kot, nge ewe Samol mi Lapalap a kökköri Moses me won ewe chuk o üreni, “Iei usun mine kopwe üreni ekewe mwirimwirin Jakop ir ekewe aramasen Israel, ");
INSERT INTO chk_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Oua fen küna mine üa föri ngeni chon Isip, pwal usun üa uweekemi usun eman ikel a uwei nöün won pöükässin o uweekemiito rei. ");
INSERT INTO chk_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Iei mine ika oupwe aleasochisi aloi o apwönüetä ai we pwon, mürin oupwe wesewesen nei aramas. Inamwo ika unusen fanüfan ai, nge üa filikemiitä me lein aramas meinisin, ");
INSERT INTO chk_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","pwe oupwe eu mwichen souasor me eu mwü mi pin fan itei.’ Ikkei ekei kapas kopwe asile ngeni ekewe aramasen Israel.” ");
INSERT INTO chk_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Iwe, Moses a feitiu o körifengeni ekewe souakomwen ekewe aramas, a apworausa ngeniir ekewe kapas meinisin mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mürin, ekewe aramas ra pälüenipökü o apasa, “Meinisin mine ewe Samol mi Lapalap a apasa aipwe föri.” Nge Moses a asile ngeni ewe Samol mi Lapalap alon ekewe aramas. ");
INSERT INTO chk_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Iwe, ewe Samol mi Lapalap a üreni Moses, “Üpwe feito reöm lon eu kuchuchol, pwe ekewe aramas repwe rongorong lupwen üpwe kapas ngonuk, repwe pwal lükuk fansoun meinisin.” Mürin, Moses a asile ngeni ewe Samol mi Lapalap alon ekewe aramas. ");
INSERT INTO chk_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe feila ren ekewe aramas o apiniir ikenai me lesor. Repwe sopuni üfer ");
INSERT INTO chk_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","o amoleretä ngeni ewe aülüngatin rän. Pun lon ewe aülüngatin rän ngang ewe Samol mi Lapalap üpwe feitiu won ungen ewe chuk Sinai mwen mesen ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Iwe, kopwe föri eu kiä pwelin ünükün ewe chuk o üreniir, ‘Oupwe afälikemi pwe ousap feitä won ewe chuk ika arap ngeni kiännin. Pun iö epwe ipwetä won ewe chuk epwe fokun mäla. ");
INSERT INTO chk_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Esap wor eman epwe atapa ätewe mi ipwetä won ewe kiä, nge repwe chök monei ngeni fau ika likapichi, ese lifilifil ika man ika aramas, esap tongeni manau. Nge lupwen ewe rappwa epwe tikitam, aramas repwe tongeni feitä won ewe chuk.’” ");
INSERT INTO chk_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mürin än Moses feitiu seni ewe chuk ren ekewe aramas, a apiniir, nge ir ra sopuni üfer. ");
INSERT INTO chk_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Iwe, Moses a üreni ekewe aramas, “Oupwe amolakemi ngeni ewe aülüngatin rän, ousap kon ren eman fefin.” ");
INSERT INTO chk_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Nge lesosorun ewe aülüngatin rän a fis chopulap me fifi. A wor eu kuchuchol won ewe chuk, a pwal tik eu rappwa mi tikimong. Iwe, ekewe aramas mi nom lon ewe leni ra chechech ren ar niuokus. ");
INSERT INTO chk_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mürin, Moses a emwenawu ekewe aramas seni lon lenier pwe repwe churi Kot. Iwe, ra ütä fäsonun ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ewe chuk Sinai a pwölüla ren ötüöt, pun ewe Samol mi Lapalap a feitiu won lon ekkei. Nge ötün a ötütä usun ötün eu lenien um mi watte o unusen ewe chuk a fokun chechech. ");
INSERT INTO chk_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Iwe, ewe rappwa a chök titikimongola. Mürin Moses a kapas, nge Kot a pälüeni ren chopulap. ");
INSERT INTO chk_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mürin, ewe Samol mi Lapalap a feitiu won ungen ewe chuk Sinai o kökkörätä Moses won. Iwe, Moses a feitä won ungen ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nge ewe Samol mi Lapalap a üreni Moses, “Kopwe feitiu o fönöü ekewe aramas, pwe resap tolong lon kiännin ewe chuk ren ar mochen nenengeniei, pwe chomong rete mäla. ");
INSERT INTO chk_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Pwal ekewe souasor mi kanoto rei repwe apiniir, pwe üsap afeiengaueer.” ");
INSERT INTO chk_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Nge Moses a kapas ngeni ewe Samol mi Lapalap, “Ekewe aramas resap tongeni feitä won ewe chuk Sinai. Pun en ka püsin allük ngenikem pwe aipwe föri kiännin ewe chuk o apini.” ");
INSERT INTO chk_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe feitiu o emwenätä Aaron. Nge kosap mwüt ngeni ekewe souasor me ekewe aramas ar repwe tolong lon ewe kiä o feitä rei, pwe ngang üsap afeiengaueer.” ");
INSERT INTO chk_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Iwe, Moses a feitiu ren ekewe aramas o apworauseer. ");
INSERT INTO chk_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Iwe, ikkei ekewe kapas meinisin Kot a apasa, ");
INSERT INTO chk_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ngang ewe Samol mi Lapalap om Kot, üa emwenukowu seni ewe fanü Isip, ewe leni ia ra nöünuk amanau ie. ");
INSERT INTO chk_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Kosap eäni eman kot lüki. ");
INSERT INTO chk_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Kosap föri uluulun anümwäl fän itom, kosap pwal alapalapa och mettochun pekitä lon läng are och mettochun pekitiu won fanüfan are och mettochun lon lölön failol. ");
INSERT INTO chk_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kosap chapetiu ngeniir are fel ngeniir, pun ngang ewe Samol mi Lapalap om Kot eman Kot mi lukomong. Üa liwini än samasam föföringau won nöür kana tori aülüngatin are arüanün tettelin chokana mi oputaei. ");
INSERT INTO chk_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Nge üa kirikiröch ngeni ngeröün mwirimwirin chokana mi echeniei o aleasochisi ai allük kana. ");
INSERT INTO chk_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Kosap föüniwäli itei ngang ewe Samol mi Lapalap om Kot. Pun ngang ewe Samol mi Lapalap üpwe ngeni iteiten eman me eman chappen tipisin an föünimwäli itei. ");
INSERT INTO chk_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Kopwe tümwünü ewe ränin sapat pwe kopwe pinini. ");
INSERT INTO chk_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Wonu rän kopwe akangang o föri om angang meinisin. ");
INSERT INTO chk_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Nge ewe afisuen rän ewe ränin sapat fän itei ngang ewe Samol mi Lapalap om Kot. Kosap föri och angang lon, sap en are noum mwän are noum fefin, sap noum chon angang mwän are chon angang fefin, sap pwal noum man are ewe chon ekis mi nom leäpärum. ");
INSERT INTO chk_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pun lon wonu rän ngang ewe Samol mi Lapalap üa föri läng me fanüfan, pwal matau me meinisin mine a wor lor. Nge lon afisuen rän üa asösö. Iei mine üa afeiöchü ewe ränin sapat o apini. ");
INSERT INTO chk_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Kopwe asamolu semom me inom, pwe ränin manauom repwe chomongola lon ewe fanü ngang ewe Samol mi Lapalap om Kot üpwe ngonuk. ");
INSERT INTO chk_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Kosap niela aramas. ");
INSERT INTO chk_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Kosap lisowu. ");
INSERT INTO chk_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Kosap solä. ");
INSERT INTO chk_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Kosap eäni kapas chofana usun chon arum. ");
INSERT INTO chk_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Kosap mocheniaiti imwen chon arum, kosap pwal mochenia ngeni pwülüen chon arum are ngeni nöün chon angang mwän me chon angang fefin, kosap pwal mocheniaiti nöün kow me nöün aas are meinisin mine chon arum a eäni. ");
INSERT INTO chk_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Iwe, lupwen ekewe aramas meinisin ra rong ewe chopulap me tikin ewe rappwa o küna ewe fifi me ewe ötüöt mi ötütä seni ewe chuk, ra niuokus o chechech. Ra ütato me toau ");
INSERT INTO chk_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","o üreni Moses, “En kopwe kapas ngenikem, nge äm aipwe rongorong. Nge Kot esap kapas ngenikem pwe aisap mäla.” ");
INSERT INTO chk_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mürin, Moses a üreni ekewe aramas, “Ousap niuokus. Pun Kot a feito pwe epwe sotunikemi, pwe oupwe sopwela le niueiti Kot, nge ousap föri tipis.” ");
INSERT INTO chk_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Iwe, ekewe aramas ra chök ütato me toau, nge Moses a kan ngeni ewe kuchuchol Kot a nom lon. ");
INSERT INTO chk_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mürin, ewe Samol mi Lapalap a üreni Moses, “Iei usun mine kopwe eäni kapas ngeni ekewe aramasen Israel: Oua fen püsin küna pwe üa fos ngenikemi seni läng. ");
INSERT INTO chk_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ousap föri kot seni silifer lüki, ousap pwal föri kot seni kolt fän itemi. ");
INSERT INTO chk_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Iwe, oupwe föri eu rongen asor seni pwül fän itei, pwe oupwe eäni ämi asoren kek me asoren kinamwe won seni nöümi sip me kow. Ekewe leni meinisin üa filätä pwe oupwe fel ngeniei ie üpwe feito remi o afeiöchükemi me ie. ");
INSERT INTO chk_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Nge ika oupwe föri eu rongen asor seni fau, ousap föri seni fau mi fal. Pun ika oua faleer, oua angauala ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ousap feitä won ai rongen asor ren latö, pwe ämi selela esap pwätiu won.” ");
INSERT INTO chk_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ikkei ekewe allük kopwe aiti ngeni ekewe aramasen Israel: ");
INSERT INTO chk_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Lupwen kopwe möni eman chon angang re Ipru, epwe angang ngonuk lon ükükün wonu ier, nge lon ewe afisuen ier epwe ngasala, nge esap mönätiu och. ");
INSERT INTO chk_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Are a tolong lon an angang lon an lipich, epwe pwal towu lon an lipich. Iwe, are a tolong nge mi pwüpwülü, epwe pwal towufengen me pwülüan. ");
INSERT INTO chk_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Iwe, are än ewe chon angang samol epwe ngeni eman pwülüan, nge a nöünöü ät me nengin me won, ewe fefin me nöün repwe nöün ewe samol, nge ewe mwän chök epwe feila. ");
INSERT INTO chk_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Nge are ewe chon angang epwe apasa, ‘Üa tongei ai samol pwal pwülüei me nei, üsap mochen ngasala,’ ");
INSERT INTO chk_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mürin, an we samol epwe emwenala lon imwenfel ren Kot. Epwe anomu lon ewe asamalap ika ren üren ewe asamalap o pwangeni selingan ngeni efoch pwangapwang. Mürin i epwe chon angang ngeni an we samol lon ränin manauan meinisin. ");
INSERT INTO chk_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Iwe, lupwen eman aramas epwe amömöla nöün fefin pwe epwe chon angang, neminewe esap ngasala usun ekewe chon angang mwän. ");
INSERT INTO chk_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Are an samol a ekiekin pwülüeni, nge mürin esap chüen efich, epwe mwütätä pwe eman epwe mönisefäli. Esap tufich an epwe amömöla ngeni chon ekis pokiten a kirikiringau ngeni. ");
INSERT INTO chk_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Nge are ewe samol a filätä nöün chon angang fefin pwe kofotun nöün mwän, epwe tümwünü usun eman nöün fefin. ");
INSERT INTO chk_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Iwe, are ewe samol epwe pwal pwülüeni eman me lükün nöün chon angang, esap tongeni akisätiu anan me üfan me an pwüngün pwüpwülü. ");
INSERT INTO chk_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Nge are esap föri ngeni ekewe ülüngat mettoch, neminewe epwe ngasala, nge esap mönätiu och moni.” ");
INSERT INTO chk_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Iwe, eman mi wichi eman aramas pwe a mäla, epwe fokun ninnila. ");
INSERT INTO chk_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Nge ika esap amolätä lon an ekiek an epwe niela ewe aramas, pwe a chök föri fän chechengau, epwe tongeni sü ngeni eu leni üpwe filätä fän itemi. ");
INSERT INTO chk_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nge ika eman a ekiekietä lon lelukan pwe epwe nisoläi eman, ätewe kopwe ätekini seni ai rongen asor pwe epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Eman mi wichi saman ika inan epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Eman mi soläni eman aramas, inamwo ika a amömöla ika a chüen nom ren, nge lupwen a pwäla, epwe chök ninnila. ");
INSERT INTO chk_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Eman mi otteki saman ika inan epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Iwe, are mwän ra aninifengen, nge eman a wüsi ngeni eman eföü fau ika öfölü ngeni pöün, nge ätewe mi feiengau esap mäla, pwe a chök akonoson, ");
INSERT INTO chk_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","mürin, ika a pwätäsefäl o wokuukuni, ätewe mi wüsi esap chüen tipis. Nge epwe mönätiu liwinin fansoun an esap tongeni angang, pwal liwinin mine epwe pöchökülöch ren. ");
INSERT INTO chk_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Iwe, are eman mwän a wichi nöün amanau mwän ika amanau fefin ren efoch wok pwe ewe amanau a mäla ren, ätewe epwe angei chappen an föför. ");
INSERT INTO chk_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Nge ika ewe amanau epwe chüen manau eu ika ruu rän, ätewe mi wichi esap angei chappen an föför, pun ewe amanau ina nöün moni. ");
INSERT INTO chk_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Iwe, are ekoch mwän ra fiufengen, nge eman leir a üngüri eman fefin mi pwopwo pwe a lus seni nöün, nge esap pwal fis feiengau me mürin, ätewe mi üngüri ewe fefin epwe püngütiu liwinin ükükün än pwülüen ewe fefin filätä, pwal ükükün mine ekewe soukapwüng repwe apwüngala. ");
INSERT INTO chk_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Nge are epwe fis feiengau me mürin, kopwe liwini manau ngeni manau, ");
INSERT INTO chk_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eföü mas ngeni eföü mas, efoch ngi ngeni efoch ngi, efoch pau ngeni efoch pau, efoch peche ngeni efoch peche, ");
INSERT INTO chk_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","eu kar ngeni eu kar, eu kinas ngeni eu kinas, me eu mwoochol ngeni eu mwoochol. ");
INSERT INTO chk_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Iwe, are eman mwän a öfölü eföü mesen nöün amanau mwän ika amanau fefin, nge a chunela, ätewe epwe mwüt ngeni ewe amanau epwe ngasala, pwe ina liwinin mesan we mi feiengau. ");
INSERT INTO chk_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Nge are ewe mwän a tülü ngin nöün amanau mwän ika amanau fefin, ätewe epwe mwüt ngeni ewe amanau epwe ngasala pwe ina liwinin ngin we mi tül.” ");
INSERT INTO chk_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Iwe, are eman ätemwänin kow a opura eman mwän ika eman fefin pwe a mäla, ewe ätemwänin kow epwe momon ngeni fau, nge esap wor eman epwe ochei fitukan. Nge mine nöün ewe ätemwänin kow esap tipis. ");
INSERT INTO chk_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Iwe, ika ewe ätemwänin kow a fen örüni opuropur me mwan, nge ätewe mine nöün ewe kow a fen silei o esap föti, iwe, are epwe niela eman mwän ika eman fefin, ewe ätemwänin kow epwe momon ngeni fau, nge mine nöün ewe ätemwänin kow epwe pwal ninnila. ");
INSERT INTO chk_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Nge ika a püngüla pwe ewe mi tipis epwe püngütiu penmanauan ren moni, epwe püngütiu ükükün mine a filitä fän iten mön manauan. ");
INSERT INTO chk_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Iwe, are eman ätemwänin kow a opura nöün eman mwän ät ika nengin pwe a mäla, epwe chök fis ngeni pwüngün ewe allük me mwan. ");
INSERT INTO chk_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Nge ika ewe ätemwänin kow a opura eman amanau mwän are amanau fefin pwe a mäla, ätewe mine nöün ewe ätemwänin kow epwe ngeni än ewe amanau samol ilik föün moni silifer , nge ewe ätemwänin kow epwe momon ngeni fau. ");
INSERT INTO chk_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Iwe, are eman aramas a suki pwölüpwölün eu pwang ika tuw eu pwang, nge esap pwölü, pwe eman ätemwänin kow ika eman aas a turulong lon, ");
INSERT INTO chk_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ewe än ewe pwang epwe liwini ewe man. Iwe, epwe liwini won moni ngeni mine nöün ewe man, nge ewe man mi mä epwe nöün. ");
INSERT INTO chk_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Iwe, are nöün eman aramas ätemwänin kow a afeiengaua pwal nöün eman aramas kow, nge a mäla, repwe amömöla ewe ätemwänin kow mi chüen manau o inetifengeni liwinin. Nge fituken ewe man mi mäla repwe pwal inetifengeni. ");
INSERT INTO chk_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Iwe, ika a pwä pwe a fen örüni opuropur me mwan, nge ätewe mine nöün esap föti, epwe möni ngeni ewe mine nöün ewe kow eman ätemwänin kow mi manau, nge ewe man mi mäla epwe nöün.” ");
INSERT INTO chk_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Iwe, are eman aramas a soläi eman kow ika eman sip o niela ika amömöla, ätewe epwe liwini limman kow fän iten eman, pwal föman sip fän iten eman. Ewe chon solä epwe aliwinisefäli liwinin mine a soläni fiti liwinin an tipis. Nge are esap wor och ren, repwe amömöla ewe mwän. ");
INSERT INTO chk_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Are eman a liapeni eman chon solä lepwin o wichi, nge a mäla, esap wor liwinin tipisin nimanau ngeni. ");
INSERT INTO chk_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Are eman a niela eman chon solä lupwen a ränila, epwe wor liwinin tipisin nimanau ngeni. ");
INSERT INTO chk_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Are ewe man a chüen nom ren ewe chon solä o manau, ese lifilifil ika eman kow, ika eman aas, ika eman sip, epwe liwini ruoman man fän iten eman. ");
INSERT INTO chk_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Are eman aramas a amongöü ngeni nöün man fetilin eu mälämäl ika fetilin eu tanipin wain, nge a mwüt ngeni nöün man pwe repwe pwal eni fetilin än eman tanipi, ätewe epwe liwini ngeni ua mi mürina seni püsin an mälämäl ika an tanipin wain. ");
INSERT INTO chk_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Nge are a wor eu kar mi küri iräfölüföl, pwe a ngeteri irän wiich mi pilük, ika irän wiich resamwo pöküpök, ika unusen eu tanipin wiich, ätewe mi popuetä ewe kar epwe liwinisefäli meinisin mine a karala. ");
INSERT INTO chk_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Are eman a ngeni chon arun nöün moni ika pisekin pwe epwe iseis, nge eman a soläi, iwe, are a pwä ewe chon solä, epwe aliwini fän ruu mine a soläni. ");
INSERT INTO chk_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Nge are ewe chon solä esap pwä, ätewe mi iseis ewe pisek lon imwan epwe feito lon imwenfel o pwärätä pwe esap angei pisekin ewe aramas. ");
INSERT INTO chk_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Are eman aramas a silleni mettochun ren eman o apasa pwe an, ese lifilifil ika eman kow ika eman aas, eman sip ika üf, ika och mettoch a pöüt seni, ekewe ruoman repwe feito lon imwenfel. Nge ewe eman, Kot a atipisi, epwe liwini ngeni chon arun fän ruu. ");
INSERT INTO chk_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Are eman a ngeni chon arun nöün aas ika nöün kow ika nöün sip ika sokun man pwe epwe tütümwünüetiu, iwe, are ewe man a mäla, ika feiengau, ika eman a süla fan, nge esap wor eman a küna, ");
INSERT INTO chk_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ewe chon tümwünü ewe man epwe feila lon imwenfel o eäni eu akapel pwe esap angei nöün chon arun man. Iwe, ewe mine nöün ewe man epwe lükü ewe akapel, nge ewe mi tümwünü ewe man esap mönätiu liwinin. ");
INSERT INTO chk_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Nge are eman a soläni ewe man seni ewe chon tümwünü, ewe chon tümwünü epwe mönätiu liwinin ewe man ngeni mine nöün. ");
INSERT INTO chk_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Are eman manmwacho a ni ewe man, ewe chon tümwünü epwe uwato ewe man pwe an pisekin pwärätä, nge esap liwini mine a mäla ren manmwacho. ");
INSERT INTO chk_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Are eman a tüngor eman man seni chon arun, nge ewe man a feiengau ika mäla, lupwen ewe mine nöün ese nom, ätewe mi tüngor epwe wisen mönätiu liwinin ewe man. ");
INSERT INTO chk_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Nge are ewe mine nöün a nom, ätewe mi tüngor esap wisen mönätiu liwinin. Iwe, are eman a satani eman man, nge a feiengau, ewe sata a iwe chök liwinin.” ");
INSERT INTO chk_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Are eman mwän a atupu eman föpwül esamwo tori mwän, esap pwal kofot, nge a kon ren, epwe ngeni kisan o pwülüeni. ");
INSERT INTO chk_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Nge are semen ewe föpwül esap fokun tipeeu ngeni an epwe pwülüeni, ewe chon atuputup epwe mönätiu ükükün ewe kis a fis lupwen apwüpwülüen eman föpwül esamwo tori mwän. ");
INSERT INTO chk_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Oupwe niela ekewe sourong fefin meinisin. ");
INSERT INTO chk_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Eman mi kon ren eman man epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Eman mi asor ngeni eman kot lüki ngang ewe Samol mi Lapalap, ätewe epwe fokun ninnila. ");
INSERT INTO chk_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ousap föri och mi mwäl ngeni wasöla ika ariaföüür, pun oua fen piin wasöla lon ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ousap ariaföüü ekewe fefin mi mä pwülüer ika ekewe mi mäsen. ");
INSERT INTO chk_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Pun are oua ariaföüür, nge ir repwe siö ngeniei, üpwe fokun aüselinga ar siö. ");
INSERT INTO chk_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Üpwe fokun song ngenikemi o nikemi lon maun pwe pwülüemi repwe lipichsefäl, nge nöümi repwe mäsen. ");
INSERT INTO chk_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Iwe, are ka mwüt ngeni eman moni me lein nei aramas mi mwelele pwe epwe paroni, kosap usun eman mi awattela winnen nöün moni. Kosap fokun angei seni winnan. ");
INSERT INTO chk_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Are ka angei üfen eman chon arum pwe asisilen an liwinimang ngonuk, kopwe fokun aliwini ngeni mwen akkar esamwo tuputiu. ");
INSERT INTO chk_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Pun ina chök üfan a pwölü ngeni inisin. Met chök epwe chenikameni le annut? Nge are epwe siö ngeniei, üpwe rongorong, pun üa eäni tong. ");
INSERT INTO chk_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Kosap turunufasei Kot, kosap pwal otteki samolun aramasom. ");
INSERT INTO chk_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Kosap amanga le uwato rei mwen uän kiniom wiich, pwal mwen ungutiom wain. Iwe, kopwe ngeniei noum mwänichi. ");
INSERT INTO chk_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Kopwe pwal ngeniei mweinöün noum kow me noum sip. Ewe apanan epwe nom ren inan lon ükükün fisu rän, nge lon awaluen rän kopwe uwato rei. ");
INSERT INTO chk_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Iwe, ämi oupwe aramas mi pin fän itei. Iei mine ousap ochoch fituken man mi mäla ren manmwacho, nge oupwe aochocha ngeni kolak kana.” ");
INSERT INTO chk_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Iwe, kosap apworausafetalei eu pworaus mi mwäl. Kosap alisi eman aramasangau ren om pwärätä mine a pwüngingau. ");
INSERT INTO chk_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Kosap eti eu mwichemongun aramas le föri mine a ngau. Nge lupwen ka pwärätä lon kapwüng, kosap sorei mine a pwüng ren om pelieni eu mwichemongun aramas. ");
INSERT INTO chk_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kosap pwal apaap ngeni eman chon mwelele lon an kapwüng. ");
INSERT INTO chk_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Iwe, are ka küna nöün chon oputok kow ika nöün aas pwe a malechela, kopwe aliwinala ren. ");
INSERT INTO chk_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nge are ka küna eman aas nöün eman chon oputok pwe a turula fän wosan mi chou, kosap feil seni o likiti ngeni chök, nge kopwe alisi le ekietä ewe aas. ");
INSERT INTO chk_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Kosap sorei mine a pwüng fän iten eman chon mwelele lon an kapwüng. ");
INSERT INTO chk_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kosap atipisimwäli eman, kosap pwal anipweni mine eman chon pwüng epwe mäla ren, pun üsap amusafatei eman mi föri ei sokun föför mi ngau. ");
INSERT INTO chk_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Iwe, kosap angei lifangen amichimich, pun ei sokun lifang a achuna mesen nöüwis o sorei pwüngün chokewe mi pwüng. ");
INSERT INTO chk_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Iwe, ousap ariaföüü eman chon ekis, pun oua silei usun nonomun eman chon ekis, pokiten oua fen piin wasöla lon ewe fanü Isip.” ");
INSERT INTO chk_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Iwe, lon wonu ier oupwe fotuki fanüemi o kini uan. ");
INSERT INTO chk_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Nge lon ewe afisuen ier ousap fotuki ewe fanü, nge oupwe likiti pwe ekewe chon mwelele me lein aramasemi repwe mongö seni mine a püsin pwükütä. Iwe, mine ir ra likiti, manmwacho repwe tongeni mongö. Iei usun oupwe pwal föri ren ämi tanipin irän wain me tanipin irä olif. ");
INSERT INTO chk_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Iwe, lon wonu rän oupwe föri ämi angang, nge lon ewe afisuen rän oupwe asösö. Pun nöümi kow me nöümi aas repwe asösö, pwal nöümi amanau mi uputiu lon imwemi me ekewe chon ekis mi angang ngenikemi repwe ngasatä. ");
INSERT INTO chk_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Oupwe afäli meinisin mine üa ürenikemi. Ousap iotek ngeni pwal ekoch kot, ousap fokun mwo nge föüni iter.” ");
INSERT INTO chk_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Iwe, fän ülüngat lon eu ier oupwe föri eu chulap ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Iwe, oupwe föri ewe chulapen mongö pilawa esap wor iis lon. Oupwe mongö pilawa esap wor iis lon ükükün fisu rän, usun üa fen allük ngenikemi. Oupwe föri ei lon ewe fansoun üa filätä, lon ewe maram Apip, pun lon ewe maram oua towu seni Isip. Esap wor eman epwe feito rei fän an asöülapö. ");
INSERT INTO chk_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Iwe, oupwe föri eu chulapen fansoun kinikin mwen uän fotämi irä seni mine oua fotuki lon ämi mälämäl. Oupwe pwal föri eu chulapen fansoun ionalong leamüchülan ier, lupwen oua ionifengeni uän fotämi irä seni ämi mälämäl. ");
INSERT INTO chk_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Iwe, fän ülüngat lon eu ier nöümi kewe mwän meinisin repwe feito rei o fel ngeniei ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ousap eäni asor ngeniei chan ewe mönün asor fiti pilawa mi wor iis lon, ousap pwal iseis tori lesosor kirisin ewe mönün asor oua eäni lupwen fansoun chulap. ");
INSERT INTO chk_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Oupwe uwato öchün mwen uän fanüemi lon imwei ngang ewe Samol mi Lapalap ämi we Kot. Ousap kuku eman apanen kuuch lon chönün oupwun ewe inelap.” ");
INSERT INTO chk_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Nengeni, üpwe tinato eman chon läng mwemi, pwe epwe tümwünükemi won ewe al o emwenikemi ngeni ewe leni üa amolätä. ");
INSERT INTO chk_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Oupwe aüselinga alon o aleasochis ngeni, pun ngang üa tinala remi. Ousap ü ngeni, pun esap amusala ämi ü ngeni. ");
INSERT INTO chk_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nge are oupwe aüselingafichi alon o föri meinisin mine üa apasa, üpwe oput chon oputemi o ü ngeni chon ü ngenikemi. ");
INSERT INTO chk_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Iwe, nei chon läng epwe akom mwemi o emwenikemi ngeni fanüen chon Amor, chon Hit, chon Peris me chon Kanaan, chon Hiw me chon Jepus. Iwe, üpwe aroserela meinisin. ");
INSERT INTO chk_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nge ämi ousap chapetiu ngeni ar kewe kot are fel ngeniir, ousap pwal apirü föförür. Iwe, oupwe fokun aturala ar kewe uluulun anümwäl o atatakisi ekewe ür ra fel ngeni. ");
INSERT INTO chk_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Are oupwe fel ngeniei ngang ewe Samol mi Lapalap ämi we Kot, üpwe afeiöchü enemi mongö me ünümemi koluk, üpwe pwal angei senikemi sokun samau. ");
INSERT INTO chk_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Esap wor eman fefin epwe lus nöün, esap pwal wor eman epwe rit me lon fanüemi. Üpwe aunusöchü ränin manauemi. ");
INSERT INTO chk_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Iwe, üpwe föri pwe chon ü ngenikemi repwe niuokusitiei. Üpwe afitikokoi aramas meinisin, chokewe oupwe maun ngeniir, üpwe pwal föri pwe chon oputemi repwe kul senikemi o süla. ");
INSERT INTO chk_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Üpwe tinala niuokus me rükö lein chon oputemi, pwe ekewe chon Hiw, chon Kanaan me chon Hit repwe süla me mwemi. ");
INSERT INTO chk_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Iwe, üsap asürela lon eu chök ier, pwe ewe fanü esap pönüla, nge ekewe manmwacho resap chomongola o afeiengauakemi. ");
INSERT INTO chk_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ekis me ekis üpwe asürela seni mwemi, tori oupwe chomongola o fanüeni ewe fanü. ");
INSERT INTO chk_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Iwe, ngang üpwe föri kiän fanüemi seni ewe Setipar tori ewe matau watte, pwal seni ewe fanüapö tori ewe chanpupu Oifrat. Üpwe atolonga fän nemeniemi chon ewe fanü, nge ämi oupwe asürela seni mwemi. ");
INSERT INTO chk_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ousap föri eu pwon ngeniir ika ngeni ar kewe kot. ");
INSERT INTO chk_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Iwe, ousap mwüt ngeniir pwe repwe nonom lon fanüemi, pwe resap atupukemilong lon tipis. Pun ika oupwe fel ngeni ar kewe kot, epwe fokun eu lenien likatup ngenikemi.” ");
INSERT INTO chk_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Iwe, Kot a üreni Moses, “Kopwe feitä rei won ewe chuk, ämi me Aaron, Natap me Apihu, pwal fik souakomwen chon Israel. Nge lupwen oua chüen ekis toau, oupwe fel ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","En chök Moses kopwe kan ngeniei. Nge ekewe lusun resap kanetä, pwal ekewe aramas resap fitätä.” ");
INSERT INTO chk_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Iwe, Moses a feila o üreni ekewe aramas alon ewe Samol mi Lapalap meinisin, pwal ekewe allük meinisin. Nge ekewe aramas meinisin ra pälüenipökü o apasa, “Meinisin mine ewe Samol mi Lapalap a apasa aipwe föri.” ");
INSERT INTO chk_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Nge Moses a makei meinisin alon ewe Samol mi Lapalap. Iwe, a pwätä lesosorusich, a senätä eu rongen asor me fäsonun ewe chuk, pwal engol me ruofoch ürefau fän iten eu me eu ekewe engol me ruu ainangen Israel. ");
INSERT INTO chk_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mürin a tinala alüal seni me lein ekewe aramasen Israel ra eäni asoren kek, ra pwal eäni asor ätemwänin kow pwe asoren kinamwe ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Iwe, Moses a angei esopun chan ekewe mönün asor o ninalong lon ekewe sepi, nge esop a uti ngeni ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mürin a angei ewe puken pwon o aleani ngeni ekewe aramas. Iwe, ra apasa, “Meinisin mine ewe Samol mi Lapalap a apasa aipwe aleasochisi o föri.” ");
INSERT INTO chk_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Iwe, Moses a angei ewe cha lon ekewe sepi, a ütätä won ekewe aramas o apasa, “Iei chan ewe pwon ewe Samol mi Lapalap a föri ngenikemi pwe longolongun ekei kapas meinisin.” ");
INSERT INTO chk_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mürin, Moses me Aaron, Natap me Apihu pwal fik souakomwen chon Israel ra feitä won ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Iwe, ra küna ewe Koten Israel. Fän pechen a usun chök ewe fau aüchea itan safaia, pwal usun chök arauarauen läng, lupwen a kürüfat. ");
INSERT INTO chk_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Nge Kot esap afeiengaua ekewe souemwenin chon Israel. Iwe, ra nenengeni Kot, mürin ra mongöfengen o ünfengen. ");
INSERT INTO chk_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe feitä rei won ewe chuk o witiwit ikenan. Pun üpwe ngonuk ekewe fau mi chöpöp üa makei won ekewe allük pwe kopwe aiöü ngeni ekewe aramas. ");
INSERT INTO chk_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mürin, Moses a ütä me nöün chon angang Josua o feitä won ewe chukun Kot. ");
INSERT INTO chk_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Nge a kapas ngeni ekewe souakom, “Oupwe witikem ikei, tori aipwe liwinsefälitikemi. Iwe, Aaron me Hur repwe nom remi, nge iö a wor an fitikoko, epwe feila rer.” ");
INSERT INTO chk_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Lupwen Moses a feitä won ewe chuk, ewe kuchu a pwölüela ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Iwe, lingen ewe Samol mi Lapalap a nonom won ewe chuk Sinai, nge ewe kuchu a pwölüela ewe chuk lon ükükün wonu rän. Nge lon ewe afisuen rän Kot a kökköwu ren Moses me lon ewe kuchu. ");
INSERT INTO chk_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Iwe, lingen ewe Samol mi Lapalap a pwäpwäla fän mesen ekewe aramasen Israel usun chök eu ekkei mi ngetenget me won ungen ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mürin, Moses a tolong lon ewe kuchu o feitä won ewe chuk. Nge Moses a nonom won ewe chuk lon ükükün faik rän me faik pwin. ");
INSERT INTO chk_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Kopwe üreni ekewe chon Israel pwe repwe uwato ar alilis ngeniei. Kopwe angei seni eman me eman aramas mine a mochen fang ngeniei seni letipan. ");
INSERT INTO chk_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Iwe, epwe iei usun ewe alilis kopwe angei seniir: kolt, silifer me piras, ");
INSERT INTO chk_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech, mangaku seni ülöülen kuuch, ");
INSERT INTO chk_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","silin ätemwänin sip mi kapar me silin man mi mürina, pwal pap seni ewe irä itan akasia, ");
INSERT INTO chk_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","noppuk fän iten ekewe lamp, uän irä mi pwokus me chöön fän iten löön epit, pwal fän iten apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","fau aüchea itan oniks me sokun fau aüchea fän iten alingen ewe üf itan efot, pwal fän iten ewe chechen leupw. ");
INSERT INTO chk_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Mürin, ekewe aramas repwe föri ewe imw mi pin fän itei pwe üpwe imweimw lefiler. ");
INSERT INTO chk_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Repwe föri ewe imwenfel seni mangaku me pisekin lon meinisin won ükükün mine üpwe aiti ngonuk.” ");
INSERT INTO chk_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Kopwe föri eu pworofel seni ewe irä akasia langataman ükükün faik me limu inis, nge chölapan me tekian ükükün rüe mi fisu inis. ");
INSERT INTO chk_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Iwe, lon me lükün kopwe apacha ngeni kolt mi mürina, kopwe pwal alinga ngeni kolt mi chipwechip ünükün me won ewe pworofel. ");
INSERT INTO chk_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kopwe föri fofoch ring seni kolt o apacheretä ngeni pwokukun me rüanü, ruofoch me epek, pwal ruofoch me epek. ");
INSERT INTO chk_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Iwe, kopwe falei ruofoch ämwär seni ewe irä akasia o apachätä kolt wor. ");
INSERT INTO chk_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kopwe sökirelong lon ekewe ring mi pachetä lepekin ewe pworofel, pwe aramas ra tongeni ämwära. ");
INSERT INTO chk_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Iwe, ekewe ämwär repwe chök nonom lon ringen ewe pworofel, nge resap sökuwu seniir. ");
INSERT INTO chk_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mürin kopwe iseis lon ewe pworofel ekewe rüepek fau mi chöpöp üpwe ngonuk, ekewe allük ra mak won. ");
INSERT INTO chk_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Kopwe pwal föri öppüngün seni kolt mi mürina, langataman ükükün faik me limu inis, nge chölapan rüe me fisu inis. Iei lenien ai ümöümöch. ");
INSERT INTO chk_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kopwe pwal föri uluulun ruoman kerop seni kolt won lesopun ewe öppüng me ruosop, nge kopwe chök necheer ngeni ama. ");
INSERT INTO chk_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ekewe kerop repwe nonom lesopun ewe öppüng me ruosop, nge repwe chök förunus me ewe öppüng. ");
INSERT INTO chk_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Iwe, pöükässin ekewe kerop repwe itila o meresila, pwe repwe ochunoi won ewe öppüng, nge won meser repwe säpefengen o wenetiu ngeni ewe öppüng. ");
INSERT INTO chk_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Iwe, kopwe iseis lon ewe pworofel ekewe rüepek fau mi chöpöp ngang üpwe ngonuk, ekewe allük ra mak won o apüngü ngeni ewe öppüng. ");
INSERT INTO chk_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Iei ewe leni ia üpwe churuk me ie. Iwe, seni ei leni lefilen ekewe ruoman kerop mi nom won ewe pworofel üpwe kapas ngonuk o aiti ngonuk ekewe allük fän iten chon Israel.” ");
INSERT INTO chk_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Iwe, kopwe föri eu chepel seni ewe irä akasia langataman ükükün ilik me wonu inis, chölapan ükükün engol me walu inis, nge tekian rüe me fisu inis. ");
INSERT INTO chk_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kopwe apacha ngeni kolt mi mürina, kopwe pwal alinga ngeni kolt mi chipwechip ünükün me won ewe chepel. ");
INSERT INTO chk_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Iwe, kopwe föri aaman won pwelin ünükün tekian ükükün ülüngat inis, kopwe pwal alinga ngeni kolt mi chipwechip. ");
INSERT INTO chk_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Iwe, kopwe föri fofoch ring seni kolt o apacheretä ngeni lepwokukun me rüanü, ia ekewe fofoch pechen ra nom ie. ");
INSERT INTO chk_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ekewe ring repwe kuku ngeni aamen ewe chepel, nge ämwärin repwe sökulong lon ekewe ring, pwe aramas ra tongeni ämwära. ");
INSERT INTO chk_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kopwe falei ekewe ämwär seni ewe irä akasia o apachätä kolt wor. ");
INSERT INTO chk_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Kopwe pwal föri sepi me kap me rume, pwe repwe nonom fän iten ewe asoren ün. Iwe, kopwe föriir meinisin seni kolt mi mürina. ");
INSERT INTO chk_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Iwe, kopwe iseis ekewe pilawa mi pin won ewe chepel, pwe repwe nom fän mesei fansoun meinisin.” ");
INSERT INTO chk_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Iwe, kopwe föri eu lenien atittin seni kolt mi mürina, kopwe pwal auluulu motongan me popun o necheer ngeni ama. Iwe, alingan meinisin, ekewe uluulun pön irä me kirupun repwe förunus me ewe lenien atittin. ");
INSERT INTO chk_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Epwe pwal wor wonofoch keangan repwe keang seni ewe popun, ülüfoch me epek, pwal ülüfoch me epek. ");
INSERT INTO chk_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Won eu me eu keangan epwe wor ülüpö uluulun pön irä usun chök pön ewe irä itan almont. Nge iteiten pön irä epwe wor kirupun me fan. Ina usun lapalapen ekewe wonofoch keang mi keang seni popun ewe lenien atittin. ");
INSERT INTO chk_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Iwe, won popun epwe wor fapö uluulun pön irä usun chök pön ewe irä almont, epwe pwal wor föföü kirupur, ");
INSERT INTO chk_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","eföü kirup epwe nom fän iteiten ekewe leni, ia ekewe wonofoch keang ra keang seni ie. ");
INSERT INTO chk_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Nge ekewe kirup me ekewe keang repwe förunus, pwe unusen ewe lenien atittin epwe för seni kolt mi mürina, epwe pwal auluul o nechenech ngeni ama. ");
INSERT INTO chk_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kopwe pwal föri fisu lamp fän iten ewe lenien atittin. Ekewe lamp repwe nom won pwe repwe asarama mwan. ");
INSERT INTO chk_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Iwe pisekin ewe lenien atittin, ekewe fich me lenien mooch repwe pwal för seni kolt mi mürina. ");
INSERT INTO chk_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ewe lenien atittin me pisekin meinisin repwe för seni ina epwe ükükün fik me limu paun kolt mi mürina. ");
INSERT INTO chk_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kopwe tümwünü pwe kopwe chök föri meinisin usun mine üa aiti ngonuk me won ewe chuk.” ");
INSERT INTO chk_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Iwe, kopwe föri ewe imwenfel ren engol pekin mangaku mi mürina o pwechepwech, mangaku mi arauarau me parochol me parapar. Eman mi silelap le chü epwe chüri liosun kerop wor. ");
INSERT INTO chk_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Iwe, ekewe pekin mangaku meinisin repwe nönöfengen, langatamer ükükün engol me rüanü iach, nge chölaper ruu iach. ");
INSERT INTO chk_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Limu pekin mangaku repwe tetefengen, nge limu pekin repwe pwal tetefengen pwe epwe wor ruachö cheech. ");
INSERT INTO chk_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kopwe tei pwäken mi arauarau ünükün ewe echön cheech me epek, kopwe pwal föri ina usun won ewe aruachön. ");
INSERT INTO chk_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Iwe, kopwe teätä lime pwäken ünükün ewe echön cheech me epek, kopwe pwal teätä lime pwäken ünükün ewe aruachön cheech me epek. Iwe, ekewe pwäken repwe chök wenefengen. ");
INSERT INTO chk_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Mürin kopwe föri lime ökkük seni kolt o ökküküfengeni ekewe cheech. Iei usun ewe imwenfel seni mangaku epwe unus. ");
INSERT INTO chk_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Iwe, kopwe föri engol me echö pekin mangaku seni ülöülen kuuch, pwe pwölüpwölün ewe imwenfel. ");
INSERT INTO chk_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Iwe, ekewe engol me echö pekin mangaku repwe chök nönöfengen, ükükün langatamen echö pekin engol me limu iach, nge ükükün chölapan ruu iach. ");
INSERT INTO chk_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kopwe teifengeni limachö pekin mangaku pwe repwe chök eu cheech, pwal wonachö pwe epwe wor aruachön cheech. Nge ewe awonachön pekin kopwe numätä won ewe alimachön me fän mesen ewe imwenfel. ");
INSERT INTO chk_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Mürin kopwe teätä lime pwäken ngeni ünükün ewe echön cheech me epek, kopwe pwal teätä lime pwäken ngeni ünükün ewe aruachön cheech me epek. ");
INSERT INTO chk_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kopwe föri lime ökkük seni piras o ökküküfengeni ekewe pwäken. Iei usun om kopwe achufengeni ekewe pwölüpwöl pwe repwe echö chök. ");
INSERT INTO chk_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Iwe pokiten ewe pwölüpwöl a langatam seni ewe imwenfel, esop seni epekin mangaku epwe sapwilitiu me lesopun. ");
INSERT INTO chk_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ewe pwölüpwöl a chömong seni ewe imwenfel, iei mine esop iach epwe sapwilitiu me lepekin me ruu o pwölüela. ");
INSERT INTO chk_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kopwe pwal föri echö pwölüpwöl mi kapar seni silin ätemwänin sip pwal echö pwölüpwöl seni silin man mi mürina. ");
INSERT INTO chk_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Iwe, kopwe föri papen ewe imwenfel seni mangaku seni ewe irä akasia, nge ekewe pap repwe üwenewenetä. ");
INSERT INTO chk_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Langatamen echö me echö ekewe pap ükükün engol me limu fiit, nge chölapan rüe me fisu inis. ");
INSERT INTO chk_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Nge fän iteiten echö pap epwe wor ruu oupun pwe repwe tongeni afoufengen. Iei usun kopwe föri ngeni papen ewe imwenfel meinisin. ");
INSERT INTO chk_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Iwe, kopwe föri rüe pap fän iten peliörün ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kopwe pwal föri faik along seni silifer o anomuur fän ekewe rüe pap, ruu along fän iteiten echö pap, pwe oupun repwe sökulong lon pwangen ekewe along. ");
INSERT INTO chk_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Nge fän iten peliefengin ewe imwenfel seni mangaku kopwe pwal föri rüe pap ");
INSERT INTO chk_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","me faik alongur seni silifer, ruu along fän iteiten echö pap. ");
INSERT INTO chk_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Iwe, fän iten lükisökürün ewe imwenfel seni mangaku me pelilotoun kopwe föri wonachö pap. ");
INSERT INTO chk_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kopwe pwal föri ruachö pap fän iten lepwokukun ewe imwenfel seni mangaku me lükisökürün. ");
INSERT INTO chk_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ekewe ruachö pap repwe pachefengen seni fan tori asan o ökkükfengen ren efoch ring. Iei usun om kopwe föri ngeni ekewe ruachö pap fän iten ekewe ruu pwokuku. ");
INSERT INTO chk_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ina usun epwe wor waluchö pap pwal engol me wonu alongur seni silifer, ruu along fän iteiten echö pap. ");
INSERT INTO chk_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Iwe, kopwe föri ömwöch seni ewe irä akasia, limefoch fän iten papen lepekin ewe imwenfel seni mangaku me epek, ");
INSERT INTO chk_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","limefoch fän iten papen me pwal epek, nge limefoch fän iten pappen lükisökürün me pelilotoun. ");
INSERT INTO chk_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ewe ömwöch mi nom lukalapen ekewe pap epwe seni fän mesen ewe imwenfel seni mangaku tori lükisökürün. ");
INSERT INTO chk_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Iwe, kopwe apacha ngeni kolt ekewe pap, kopwe pwal föri ringen wor seni kolt, pwe ekewe ömwöch repwe sökülong lor. Kopwe pwal apachätä kolt won ekewe ömwöch. ");
INSERT INTO chk_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Lupwen kopwe aüetä ewe imwenfel seni mangaku, kopwe chök aüetä lon aükükün mine ka küna me won ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Iwe, kopwe föri echö cheech seni mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech o mürina. Eman mi silelap le chü epwe chüri liosun kerop won. ");
INSERT INTO chk_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Iwe, kopwe ökkükätä ewe cheech won fofoch ür seni ewe irä akasia mi pwölüpwöl ngeni kolt. Won ekewe ür epwe wor ökkük seni kolt, epwe pwal wor rüanü alongur seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kopwe aitiuätä ewe cheech won ekewe ökkük o anomu ewe pworofel pekilongan. Ewe cheech epwe refifeseni ewe rumw mi pin seni ewe rumw mi unusen pin. ");
INSERT INTO chk_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Iwe, kopwe anomu ewe öppüng won ewe pworofel o iseni lon ewe rumw mi unusen pin. ");
INSERT INTO chk_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Kopwe anomu ewe chepel pekiton ewe cheech me peliefengin lon ewe imwenfel seni mangaku. Nge ewe lenien atittin kopwe anomu peliörün awenewenen ewe chepel. ");
INSERT INTO chk_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Iwe, kopwe föri echö cheech fän iten asamalapen ewe imwenfel seni mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech o mürina, epwe pwal chü. ");
INSERT INTO chk_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Iwe, kopwe föri ökkük seni kolt fän iten ei cheech me limefoch ür seni ewe irä akasia o apacha ngeniir kolt. Kopwe pwal föri limu alongur seni piras. ");
INSERT INTO chk_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Iwe, kopwe föri ewe rongen asoren kek seni ewe irä akasia, langataman me chölapan repwe chök nönöfengen ükükün eu esop fiit, nge tekian epwe ükükün rüanü esop fiit. ");
INSERT INTO chk_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Iwe, kopwe pwal föri fofoch mächä won ekewe rüanü lepwokukun, nge ekewe mächä repwe förunus me ewe rongen asor. Kopwe pwal apachätä piras ngeni won unusen ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kopwe föri nape fän iten falangen me molien lon, pwal söföl me sepi fän iten chan ekewe mönün asor, pwal chü. Kopwe föri ekei pisek meinisin seni piras. ");
INSERT INTO chk_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Iwe, kopwe pwal föri äpäwunan seni piras o apachätä fofoch ring ngeni pwokukun me rüanü. ");
INSERT INTO chk_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kopwe anomu äpäwunan fän aamen ewe rongen asor, pwe epwe nom seni lukalapan tori fan. ");
INSERT INTO chk_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kopwe falei ämwärin ewe rongen asor seni ewe irä akasia o apachätä piras wor. ");
INSERT INTO chk_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Iwe, ekewe ämwär repwe sökulong lon ekewe ring me lepekin ewe rongen asor me rüepek, pwe aramas ra tongeni ämwära. ");
INSERT INTO chk_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kopwe föri ewe rongen asoren kek seni pap, nge epwe pöön lon. Iwe, kopwe chök föri usun mine üa aiti ngonuk me won ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Iwe, kopwe föri eu leni lükün ewe imwenfel seni mangaku. Lepeliörün ewe leni epwe tit ngeni mangaku mi pwechepwech, langataman ükükün lime iach. ");
INSERT INTO chk_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Epwe wor rüe üran me rüe alongur seni piras, nge ökkükün won ekewe ür pwal mächän lefiler me asan repwe för seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Iwe, lepeliefengin ewe leni epwe pwal tit ngeni mangaku, langataman ükükün lime iach, epwe pwal wor rüe üran me rüe alongur seni piras, nge ökkükün won ekewe ür pwal mächän lefiler me asan repwe för seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Iwe, lepelilotoun ewe leni epwe tit ngeni mangaku chölapan ükükün rüe me limu iach, epwe pwal wor engol üran me engol alongur. ");
INSERT INTO chk_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Nge fän mesen ewe leni me peliötiuan chölapan epwe pwal ükükün rüe me limu iach. ");
INSERT INTO chk_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Iwe, lepekin ewe asamalap me epek epwe tit ngeni mangaku langataman ükükün fisu esop iach, epwe pwal wor ülüfoch üran me ülüngat alongur. ");
INSERT INTO chk_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Nge lepekin ewe asamalap me pwal epek epwe tit ngeni mangaku langataman ükükün fisu esop iach, epwe pwal wor ülüfoch üran me ülüngat alongur. ");
INSERT INTO chk_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Won asamalapen ewe leni lükün ewe imwenfel seni mangaku epwe wor echö cheech mi för seni mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech o mürina, epwe pwal chü. Langatamen ewe cheech epwe ükükün engol iach. Epwe pwal wor fofoch üran me rüanü alongur. ");
INSERT INTO chk_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Iwe, lefilen iteiten ekewe üren ewe tit mi nom pwelin ünükün ewe leni lükün ewe imwenfel seni mangaku epwe wor mächä me ökkükün wor mi för seni silifer, epwe pwal wor alongur seni piras. ");
INSERT INTO chk_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Iwe, langatamen ewe leni lükün ewe imwenfel seni mangaku epwe ükükün lime iach, chölapan rüe me limu iach, nge tekian tittin ükükün ruu esop iach. Iwe, ewe tit epwe för seni mangaku mi pwechepwech, nge alongun üran repwe för seni piras. ");
INSERT INTO chk_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ekewe pisek meinisin ra aea le angang lon ewe imwenfel seni mangaku, pwal chüfölün me chüfölün ewe leni lükün repwe för seni piras.” ");
INSERT INTO chk_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Kopwe allük ngeni ekewe chon Israel pwe repwe uwato noppuk mi mürina seni föün olif mi üsüs fän iten ewe lenien atittin, pun laman repwe tittinfochofoch. ");
INSERT INTO chk_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Iwe, lon ewe imw mangaku ia aramas ra churiei ie, pekiton etippen ewe pworofel Aaron me nöün kewe mwän repwe amolätä ekewe lamp, pwe repwe tittin fän mesen ewe Samol mi Lapalap seni lekuniol tori lesosor. Ei allük epwe pöchökül tori feilfeilachök, seni eu täppin aramasen Israel tori pwal eu täppin.” ");
INSERT INTO chk_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Iwe, kopwe körato reöm Aaron pwiüm we seni lein ekewe chon Israel fiti nöün kewe mwän iter Natap, Apihu, Eleasar me Itamar, pwe repwe angang ngeniei lon wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Iwe, kopwe tei üf mi pin fän iten Aaron pwiüm we, pwe epwe pwäla lingen wisan me iteüöchün. ");
INSERT INTO chk_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kopwe kapas ngeni ekewe soutete üa asilelapeer o atufichiir pwe repwe tei üfen Aaron. Mürin epwe afeiöch pwe epwe angang ngeniei lon wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ikkei ekewe pisek repwe tei: echö chechen leupw, echö üf itan efot, echö owokot, echö sööch mi pwechepwech o sikapoot, eu akkaw me efoch pelit. Iwe, repwe tei ekei üf mi pin fän iten Aaron pwiüm we me nöün kewe mwän, pwe repwe angang ngeniei lon wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Iwe, ekewe soutete repwe aea terech kolt me mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech le tete. ");
INSERT INTO chk_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Repwe föri ewe üf itan efot seni terech kolt, pwal seni mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech, nge eman soutete epwe föri ei angang. ");
INSERT INTO chk_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Iwe, repwe föri ruachö chechen won afaran o teiretä lekochun me won afaren ewe üf, pwe ekewe ruu pekin repwe pachefengen. ");
INSERT INTO chk_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kiren ewe riri won ewe efot epwe usun chök kiren ewe efot, pun epwe för seni terech kolt, pwal seni mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech. ");
INSERT INTO chk_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Iwe, kopwe angei ruoföü fau aüchea iter oniks o ruputi wor iten nöün Israel kewe mwän. ");
INSERT INTO chk_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Iten wonoman leir kopwe ruputi won ewe eföü, nge iten pwal ekewe wonoman kopwe ruputi won ewe aruoföün lon tettelin ar uputiu. ");
INSERT INTO chk_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Iwe, kopwe ruputi iten nöün Israel kewe mwän won ekewe ruoföü fau usun chök eman chon fala fau aüchea a rup won ringen pwau, kopwe pwal föri lenien ömwöchür seni kolt. ");
INSERT INTO chk_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Iwe, kopwe amasatä ekewe ruoföü fau won chechen won afaren ewe üf itan efot, pwe föün achema iten nöün Israel kewe mwän. Iei usun Aaron epwe uwei iter won afaran me ruu pwe ngang ewe Samol mi Lapalap üpwe chechemeniir fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kopwe pwal föri lenien ömwöch seni kolt ");
INSERT INTO chk_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","me ruofoch säl seni kolt mi mürina. Kopwe ona ekewe säl usun chök lül o rietä ngeni ekewe lenien ömwöch. ");
INSERT INTO chk_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Iwe, kopwe tei ewe chechen leupw pwe eu lenien pwärätä letipen Kot. Eman soutete epwe föri ei angang. Kopwe föri seni terech kolt me mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech, usun chök ewe efot. ");
INSERT INTO chk_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Iwe, langataman me chölapen ewe cheech repwe nönöfengen, ükükün tiu inis, nge epwe pwal wor ruu säsärin. ");
INSERT INTO chk_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Mürin kopwe amasalong won ewe cheech rüanü telin fau aüchea. Won aeuin telin epwe wor ülüföü fau iter sartoniks, topas me karpunkel. ");
INSERT INTO chk_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Won aruuen telin epwe wor ülüföü fau iter emeralt, safaia me taiamont. ");
INSERT INTO chk_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Iwe, won aülüngatin telin epwe wor ülüföü fau iter iasint, akit me ametist, ");
INSERT INTO chk_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","nge won arüanün telin epwe wor ülüföü fau iter peril, oniks me iasper. Iwe, kopwe amaserelong lon lenien ömwöchür kewe seni kolt. ");
INSERT INTO chk_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Iei usun epwe wor engol me ruoföü fau ükükün iteiten nöün Israel kewe mwän. Iwe, iteiten eföü me eföü kewe fau epwe rup iten ekewe engol me ruu ainangen Israel won, nge ewe mak epwe usun chök rupun won ringen pwau. ");
INSERT INTO chk_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Iwe, kopwe föri selin ewe chechen leupw seni kolt mi mürina usun chök lül mi kon. ");
INSERT INTO chk_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kopwe pwal föri ruofoch ring seni kolt o apacheretä lepwokukun won ewe cheech me ruu. ");
INSERT INTO chk_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Iwe, ekewe ruofoch säl seni kolt kopwe ri ngeni ekewe ruofoch ring mi nom lepwokukun ewe chechen leupw. ");
INSERT INTO chk_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nge lesopun ekewe ruofoch säl repwe riri ngeni ekewe ruu lenien ömwöch mi nom won ekewe chechen won afaren ewe efot me fän mesan. ");
INSERT INTO chk_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Iwe, kopwe pwal föri ruofoch ring seni kolt o apacheretä lepwokukun ewe cheech me fan, pwe repwe nom lefilen ewe cheech me ewe efot. ");
INSERT INTO chk_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kopwe föri pwal ruofoch ring seni kolt o apacheretä lesopun me fän ekewe ruachö chechen won afaren ewe efot me fän mesan, pwe epwe nom lekochun ewe efot asen ewe riri. ");
INSERT INTO chk_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Iwe, ringen ewe chechen leupw repwe riri ngeni ringen ewe efot ren efoch säl mi arauarau, pwe epwe nom asen ririn ewe üf, pwe esap nükütomotom me won. ");
INSERT INTO chk_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Iwe, lupwen Aaron epwe tolong lon ewe leni mi pin, epwe uwala iten nöün Israel kewe mwän won ewe chechen leupw mi nom fän mwärin pwe ngang ewe Samol mi Lapalap üpwe chechemeni nei aramas fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Kopwe iselong ewe Urim me ewe Tumim lon ewe chechen leupw, pwe repwe nonom fän mwärin Aaron, lupwen epwe tolong fän mesei. Iei usun Aaron epwe uwei fän mwärin ewe minen asisila letipei ngeni chon Israel fansoun meinisin, lupwen epwe tolong fän mesei. ");
INSERT INTO chk_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Iwe, kopwe tei ewe owokot seni chök mangaku mi arauarau, epwe nom fän ewe efot. ");
INSERT INTO chk_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Me lukalapen ewe owokot epwe wor leawan usun chök leawen eu üf, nge ünükün leawan epwe wor leisin pwe esap tongeni kam. ");
INSERT INTO chk_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Iwe, lepwülün kopwe teätä uluulun apel seni mangaku mi arauarau me parachol me parapar, kopwe pwal teätä pel seni kolt lefiler. ");
INSERT INTO chk_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Epwe iei usun: eu pel, eföü apel, eu pel, eföü apel won pwelin lepwülün ewe owokot. ");
INSERT INTO chk_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Iwe, Aaron epwe üföüf ei üf, lupwen a föri an angang. Iwe, ekewe pel repwe nech, lupwen epwe tolong fän mesei lon ewe leni mi pin, pwal lupwen epwe towu. Ei epwe fis pwe esap mäla. ");
INSERT INTO chk_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Iwe, kopwe angei kolt mi mürina o achöpöpü, kopwe pwal ruputi ekei kapas won usun rupun won ringen pwau, ‘A pin me ren ewe Samol mi Lapalap’. ");
INSERT INTO chk_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kopwe rietä ewe kolt mi chöpöp won eten mesen ewe akkaw ren efoch säl mi arauarau. ");
INSERT INTO chk_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Iwe, Aaron epwe uwei won chamwan. Aaron epwe uwei sokun pupungau mi pach ngeni ekewe asor ekewe chon Israel ra apini, ese lifilifil met sokun asor ra eäni. Iwe, ewe kolt mi chöpöp epwe nom fochofoch won chamwan, pwe ekewe asor repwe tiw me rei ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Mürin kopwe föri ewe sööch seni mangaku mi pwechepwech o sikapoot me ewe akkaw seni mangaku mi pwechepwech o mürina, kopwe pwal tei efoch pelit epwe chü. ");
INSERT INTO chk_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Nge kopwe pwal tei sööch me pelit me akkaw fän iten nöün Aaron kewe mwän, pwe epwe pwäla lingen wiser me iteüöchür. ");
INSERT INTO chk_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Iwe, ekewe üf kopwe aüföüfa ngeni Aaron pwiüm we, pwal ngeni nöün kewe mwän. Kopwe epitiir o afeiöchüür, kopwe pwal apiniir pwe repwe angang ngeniei lon wiser wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Iwe, kopwe tei ar rauesesin lon seni mangaku mi pwechepwech, nge ükükür epwe seni won wila tori lepwäsuk, pwe epwe pwölüla ar selela. ");
INSERT INTO chk_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Iwe, Aaron me nöün kewe mwän repwe aea, lupwen repwe tolong lon ewe imw mangaku ia aramas ra churiei ie, pwal lupwen repwe kan ngeni ewe rongen asor pwe repwe föri ar angang ngeniei lon ewe leni mi pin. Iei usun resap tipis ika mäla. Nge ei epwe eu allük esemüch ngeni Aaron me mwirimwirin kana.” ");
INSERT INTO chk_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Iei usun mine kopwe föri, lupwen kopwe apini Aaron me nöün kewe mwän pwe repwe föri ar angang ngeniei lon wisen souasor. Kopwe angei eman nienifön ätemwänin kow me ruoman ätemwänin sip esap wor terir, ");
INSERT INTO chk_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","kopwe pwal angei pilawa mi amas seni föün wiich mi mürina o föri pilawa esap wor iis lon, sokun pilawa mi tonafengen me apüra, pwal nokop mi toto ngeni apüra. ");
INSERT INTO chk_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Iwe, kopwe iseniir lon eu chüük o uweefengenireto me ewe ätemwänin kow me ekewe ätemwänin sip. ");
INSERT INTO chk_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kopwe pwal emwenato Aaron me nöün kewe mwän ren asamalapen ewe imw mangaku ia aramas ra churiei ie o atütüür. ");
INSERT INTO chk_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Mürin kopwe angei ekewe üf o aüföüfa ngeni Aaron. Ewe sööch epwe akom, mürin ewe owokot, pwal mürin ewe üf itan efot, nge ewe chechen leupw epwe nom won. Iwe, ririn ewe efot mi mürina kopwe pwal riri ngeni lukalapan. ");
INSERT INTO chk_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Iwe, kopwe eimweimwa ngeni ewe akkaw o rietä ewe kolt mi chöpöp won, iei ewe mwärämwär mi pin. ");
INSERT INTO chk_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Mürin kopwe angei ewe löön epit o ninätiu won möküran pwe kopwe epiti. ");
INSERT INTO chk_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Iwe, kopwe pwal emwenato nöün Aaron kewe mwän o aüföüfa ngeniir ekewe sööch, ");
INSERT INTO chk_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","kopwe pwal peliti ngeniir ekewe pelit o eimweimwa ngeniir ekewe akkaw. Ren pwüngün ei föför ir me mwirimwirir repwe wiseni wisen souasor tori feilfeilachök. Iei usun kopwe afeiöchü Aaron me nöün kewe mwän. ");
INSERT INTO chk_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Mürin kopwe emwenato ewe ätemwänin kow mwen ewe imw mangaku ia aramas ra churiei ie. Iwe, Aaron me nöün kewe mwän repwe isetä pöür won möküren ewe ätemwänin kow, ");
INSERT INTO chk_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","nge en kopwe niela ewe kow fän mesei leasamalapen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Iwe, kopwe angei ekis chan ewe ätemwänin kow o aea poum le tofi ngeni mächän ewe rongen asor, nge ewe lusun cha kopwe ninätiu ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Mürin kopwe angei kirisin meinisin mi pwölüela pisekin lon inisin, pwal mwärekeon ammünün me ekewe ruoföü föün lon fiti kirisir o kenirela won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","nge fituken ewe ätemwänin kow me silin pwal taran kopwe kenirela lükün ewe ia chon Israel ra nonom ie, pun iei eu asoren tipis fän iten ekewe souasor. ");
INSERT INTO chk_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Mürin kopwe angei eman lein ekewe ätemwänin sip, nge Aaron me nöün kewe mwän repwe isetä pöür won möküran. ");
INSERT INTO chk_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Iwe, kopwe niela ewe ätemwänin sip, kopwe angei chan o äsupufetalei ngeni pwelin ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Mürin kopwe kinikisietiu fituken ewe ätemwänin sip o limeti pisekin lon inisin pwal pöün me pechen. Iwe, kopwe achufengeniir meinisin fiti möküran ");
INSERT INTO chk_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","o kenala kinikinin ewe ätemwänin sip meinisin won ewe rongen asor. Iei eu asoren kek ngang ewe Samol mi Lapalap üa efich pwoon. ");
INSERT INTO chk_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Iwe, kopwe angei ewe aruomanün ätemwänin sip, nge Aaron me nöün kewe mwän repwe isetä pöür won möküran. ");
INSERT INTO chk_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mürin kopwe niela ewe ätemwänin sip, kopwe angei ekis chan o tofi ngeni emin fän pelifichin selingen Aaron, pwal ngeni emin fän pelifichin selingen nöün kewe mwän, kopwe pwal tofi ngeni aütülapen pelifichin pöür me pecher, nge ewe lusun cha kopwe äsupufetalei ngeni pwelin ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Iwe, kopwe angei ekis cha me won ewe rongen asor me ewe löön epit o äsupu ngeni Aaron me üfan, pwal ngeni nöün kewe mwän me üfer. Iwe, Aaron me üfan kewe repwe pin, pwal nöün kewe mwän me üfer. ");
INSERT INTO chk_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Kopwe pwal angei kirisin ewe ätemwänin sip, kirisin ükün, ewe kiris mi pwölüela pisekin lon inisin, mwärekeon ammünün, ekewe ruoföü föün lon fiti kirisir, pwal pelifichin pechen, pun ei ätemwänin sip eu asoren afeiöch. ");
INSERT INTO chk_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Iwe, kopwe angei eföü pilawa, eföü pilawa mi tonafengen me apüra, pwal echö nokop seni lon chükün ewe pilawa esap wor iis lon mi nom fän mesei. ");
INSERT INTO chk_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ekei mettoch meinisin kopwe isenalong lepöün Aaron me lepöün nöün kewe mwän, pwe repwe assawereto fän mesei, pun eu asoren assaw. ");
INSERT INTO chk_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Mürin kopwe angei ekei mettoch seni lepöür o kenirela won ewe rongen asor pwe epwe pach ngeni ewe asoren kek. Iei eu asor ngang ewe Samol mi Lapalap üa efich pwoon. ");
INSERT INTO chk_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kopwe pwal angei leupwen ewe ätemwänin sip fän iten afeiöchün Aaron o assawa fän mesei, pun eu asoren assaw. Iei ükükün inetum. ");
INSERT INTO chk_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Iwe, kopwe apini kinikinin fituken ewe ätemwänin sip, ewe asoren afeiöch, pwe inetin Aaron me nöün kewe mwän: ewe leupw me ewe peche a fen assaw. ");
INSERT INTO chk_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ikkei inetin Aaron me nöün kewe mwän, repwe angei me ren ekewe chon Isrel iteiten fansoun meinisin. Pun iei ewe asor ekewe chon Israel repwe fang ngeniei seni ar kewe asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Mürin än Aaron mäla üfan kewe mi pin nöün kewe mwän repwe pwal üföüf le epit o afeiöch far, lupwen repwe seikitä ngeni wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Iwe, nöün we mi siwili lon wisan wisen souasor epwe üföüf ekewe üf lon ükükün fisu rän, lupwen an tolong lon ewe imw mangaku ia aramas ra churiei iei, pwe epwe föri an angang lon ewe leni mi pin. ");
INSERT INTO chk_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Iwe, kopwe angei fituken ewe ätemwänin sip fän iten asoren afeiöch o amota lon eu leni mi pin. ");
INSERT INTO chk_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron me nöün kewe mwän repwe ochoch fituken ewe ätemwänin sip o mongö ekewe pilawa mi nom lon ewe chüük leasamalapen ewe imw mangaku ia aramas ra churiei ie. ");
INSERT INTO chk_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Iei usun repwe mongö ewe asor a fis amusamusen tipis ren, lupwen ra afeiöch o apinipinila. Nge esap wor eman lükür epwe mongö seni, pun a pin. ");
INSERT INTO chk_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Iwe, sorotän ewe rän, are a chüen wor ekis lusun fituk me pilawa seni ewe asoren afeiöch, kopwe kenirela meinisin pwe esap wor eman epwe mongö, pun ra pin. ");
INSERT INTO chk_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Iei usun kopwe föri ngeni Aaron me nöün kewe mwän meinisin mine üa allük ngonuk. Lon ükükün fisu rän epwe fis angangen afeiöch wor. ");
INSERT INTO chk_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Iwe, iteiten rän kopwe eäni asoren amusamusen tipis eman ätemwänin kow. Kopwe pwal alimöchü ewe rongen asor ren om föri asoren limelim fän itan. Mürin kopwe epiti pwe epwe pin. ");
INSERT INTO chk_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Lon ükükün fisu rän kopwe föri asoren limelim fän iten ewe rongen asor, kopwe pwal apini. Mürin, ewe rongen asor epwe unusen pin, nge meinisin mine epwe toori epwe pwal pin.” ");
INSERT INTO chk_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ikkei ekewe mettoch kopwe eäni asor won ewe rongen asor: Iteiten rän tori feilfeilachök kopwe eäni asor ruoman lam eu ierir. ");
INSERT INTO chk_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ewe aemanün kopwe eäni asor lesosor, nge ewe aruomanün kopwe eäni lekuniol. ");
INSERT INTO chk_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Iwe, kopwe afiti ngeni ewe aemanün lam ruu paun pilawa mi mürina nofitfengen me eu kuoch apüra seni föün olif mi üsüs, pwal eu kuoch wain pwe eu asoren ün. ");
INSERT INTO chk_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Nge ewe aruomanün lam kopwe eäni asor lekuniol, kopwe pwal afiti ngeni ewe asoren mongö me asoren ün usun chök ewe asor a fis lesosor. Ei epwe eu asor ngang ewe Samol mi Lapalap üa efich pwoon. ");
INSERT INTO chk_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ei asoren kek mwirimwirimi kana repwe eäni fansoun meinisin me leasamalapen ewe imwenfel seni mangaku fän mesei ngang ewe Samol mi Lapalap. Iei ei leni üpwe churikemi ie pwe üpwe kapas ngenikemi. ");
INSERT INTO chk_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Eiia üpwe churi chon Israel ie, ei leni epwe pin, pun ai ling epwe nom lon. ");
INSERT INTO chk_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Iwe, üpwe apini ewe imwenfel seni mangaku me ewe rongen asor, üpwe pwal apini Aaron me nöün kewe mwän pwe repwe pin o angang ngeniei lon wiser wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Iwe, üpwe imweimw lein ekewe chon Israel pwe üpwe ar Kot. ");
INSERT INTO chk_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Nge ir repwe silei pwe ngang ewe Samol mi Lapalap ar we Kot, üa emwenirewu seni lon ewe fanü Isip pwe üpwe imweimw lefiler. Ngang ewe Samol mi Lapalap ar we Kot.” ");
INSERT INTO chk_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Iwe, kopwe föri eu rongen asoren ötüöt seni ewe irä akasia, pwe kopwe keni ewe apach mi pwokus won. ");
INSERT INTO chk_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Langataman me chölapan repwe chök nönöfengen, ükükür engol me walu inis. Iwe, tekian epwe ükükün ilik me wonu inis, nge mächän kewe fofoch kopwe förunuseifengeni me ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Iwe, kopwe apacha kolt mi mürina ngeni won me lepekin, pwal ngeni mächän kewe, kopwe pwal alinga ngeni kolt mi chipwechip ünükün me won. ");
INSERT INTO chk_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kopwe föri ruofoch ring seni kolt o apacheretä fän alingan we me epek, kopwe pwal föri ina usun me epek. Iwe, ekewe ämwär repwe sökulong lon ekewe ring pwe aramas repwe tongeni ämwära. ");
INSERT INTO chk_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kopwe falei ämwärin kewe seni ewe irä akasia o apachätä kolt wor. ");
INSERT INTO chk_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kopwe anomu ei rongen asoren ötüöt mwen chechen ewe leni ia ewe pworofel a nom ie, pwe epwe nom awenewenen öppüngün, iei ewe lenien ai ümöümöch ia üpwe churuk ie. ");
INSERT INTO chk_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Iteiten lesosor Aaron epwe keni apach mi pwokus won, lupwen a amolätä ekewe lamp. ");
INSERT INTO chk_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Nge lekuniol, lupwen Aaron epwe keni ekewe lamp, epwe pwal keni apach mi pwokus won ewe rongen asoren ötüöt. Iei ewe asoren ötüöt mwirimwirimi kana repwe eäni ngeni ewe Samol mi Lapalap fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Iwe, ousap eäni asor apach esap fich ngeni won ewe rongen asoren ötüöt, ousap pwal eäni asoren kek ika asoren mongö ika asoren ün won. ");
INSERT INTO chk_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Fän eu lon eu ier Aaron epwe föri ewe angangen elimelima ewe rongen asoren ötüöt ren an tofi ngeni mächän kewe chan ewe mönün asoren amusamusen tipis. Ei epwe fis iteiten ier seni eu täppin aramas tori eu täppin. Ei rongen asoren ötüöt a unusen pin fän itei ngang ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Lupwen kopwe angei iteiten chon Israel, eman me eman mi alealong lon ewe iteit epwe mönätiu liwinin manauan ngeniei, pwe esap wor och feiengau epwe küw lon ewe fansoun kopwe aleaniir. ");
INSERT INTO chk_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Iwe, iei ükükün mine eman mi alealong lon ewe iteit epwe mönätiu: eu lelimu aunus silifer, epwe för won ewe kilo ra aea le aükük lon ewe imw mi pin. Iwe, ewe eu lelimu aunus silifer repwe eäni asor ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Iteiten eman me eman mi alealong lon ewe iteit seni ier rüe feitä epwe eäni ei asor ngeniei ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Chon pisekisek resap mönätiu lap seni ükükün eu lelimu aunus, nge chon wöüngau resap mönätiu kis seni, lupwen ra eäni asor ngeniei liwinin manauer. ");
INSERT INTO chk_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Iwe, kopwe angei ei moni seni chon Israel fän iten angangen ewe imw mangaku ia aramas ra churiei ie. Nge ngang ewe Samol mi Lapalap üpwe chechemeni ekewe chon Israel pokiten ra mönätiu liwinin manauer.” ");
INSERT INTO chk_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Kopwe föri eu sepi me motongan seni piras fän iten angangen töttöl. Kopwe anomu ewe sepi lefilen ewe imwenfel seni mangaku me ewe rongen asor, kopwe pwal alölöü ngeni koluk. ");
INSERT INTO chk_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Iwe, Aaron me nöün kewe mwän repwe talü pöür me pecher ngeni. ");
INSERT INTO chk_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Repwe fokun chiri ngeniir koluk pwe resap mäla, lupwen repwe tolong lon ewe imwenfel seni mangaku ika lupwen repwe kan ngeni ewe rongen asor, pwe repwe föri ar angang o keni ekewe asor ngeniei. ");
INSERT INTO chk_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Iwe, repwe talü pöür me pecher pwe resap mäla. Ei epwe eu allük ngeni Aaron me mwirimwirin kana repwe apwönüetä seni eu täppin aramas tori eu täppin.” ");
INSERT INTO chk_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Iwe, ewe Samol mi Lapalap a pwal kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Kopwe angei ekei mettoch mi fokun pwokus: engol me ruu paun safei mi aüchea itan mör, ewe sokun mi lölö, wonu paun sinamon mi pwoarar me wonu paun kalamus mi pwokus, ");
INSERT INTO chk_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","pwal engol me ruu paun kasia, repwe för won ewe kilo ra aea le aükük lon ewe imw mi pin, me eu kalon noppuk seni föün olif. ");
INSERT INTO chk_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Seni ekei mettoch kopwe föri eu löön epit mi pin usun chon föri lö ra föri. ");
INSERT INTO chk_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Mürin kopwe angei ewe löön epit o epiti ngeni ewe imw mangaku, ia aramas ra churiei ie, me ewe pworofel, ");
INSERT INTO chk_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","kopwe pwal epiti ewe chepel me pisekin, ewe lenien atittin me pisekin, ewe rongen asoren ötüöt, ");
INSERT INTO chk_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ewe rongen asoren kek me pisekin meinisin, pwal ewe sepien töttöl me motongan. ");
INSERT INTO chk_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Iwe, kopwe apini ekei mettoch pwe repwe unusen pin, nge meinisin mine epwe tooriir epwe pin. ");
INSERT INTO chk_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Mürin, kopwe epiti Aaron me nöün kewe mwän o apiniir pwe repwe angang ngeniei lon wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Iwe, kopwe üreni ekewe chon Israel, ‘Ei lö ai löön epit mi pin, epwe pin ngenikemi seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ousap aea ei lö le epiti ngeni aramas, ousap pwal föri sokun lö usun chök ei, pun a pin, nge epwe pwal pin ngenikemi. ");
INSERT INTO chk_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Eman mi föri ei sokun lö ika epiti ngeni eman lükün Aaron me mwirimwirin kana epwe käriwu seni aramasan.’” ");
INSERT INTO chk_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, “Kopwe angei ekei mettoch mi pwokus iter stakte, onika, kalpanum me apach mi pwokus, nge ükükür epwe wewefengen. ");
INSERT INTO chk_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Kopwe föri seniir eu minen asoren ötüöt, epwe pwokus usun lö förien ewe chon föri lö, epwe pwal nofit ngeni salt, nge epwe limöch o pin. ");
INSERT INTO chk_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Iwe, ekis seni ewe minen asoren ötüöt kopwe üsi tori epwe moromor o isetiu mwen ewe pworofel lon ewe imwenfel seni mangaku, ewe ia üpwe churuk ie. Ei epwe eu mettoch mi unusen pin ngenikemi. ");
INSERT INTO chk_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Lupwen oupwe föri püsin ämi minen ötüöt mi pwokus, ousap apirü usun ei minen asoren ötüöt. Ei epwe pin ngenikemi, pun och mi pin fän itei. ");
INSERT INTO chk_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nge eman mi apirü ei sokun minen ötüöt mi pwokus pwe a sani pwonnan, epwe käriwu seni aramasan.” ");
INSERT INTO chk_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Iei üa filätä Pesalel nöün Uri, nge Uri nöün Hur seni ewe ainangen Juta. ");
INSERT INTO chk_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Üa fen ngeni i Ngüni o fang ngeni silelap me tipachem me tufichin föri sokopaten angang meinisin, ");
INSERT INTO chk_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","a pwal sip le ekiekietä mettoch mi fö. Iwe, a sile angang ngeni kolt, silifer me piras, ");
INSERT INTO chk_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","a pwal sile angangen nechei fau aüchea pwe repwe maseöchülong lon lenier, pwal angangen fala irä me sokopaten angang. ");
INSERT INTO chk_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Iwe, üa pwal filätä Oholiap nöün Ahisamak seni ewe ainangen Tan pwe epwe alisi Pesalel. Üa pwal atufichi aramas meinisin mi sile sokun angang pwe repwe tufichin föri meinisin mine üa aiti ngonuk: ");
INSERT INTO chk_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ewe imwenfel seni mangaku, ewe pworofel me öppüngün won, pwal pisekin lon meinisin, ");
INSERT INTO chk_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ewe chepel me pisekin, ewe lenien atittin seni kolt mi mürina me pisekin meinisin, ewe rongen asoren ötüöt, ");
INSERT INTO chk_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ewe rongen asoren kek me pisekin meinisin, ewe sepien töttöl me motongan, ");
INSERT INTO chk_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ekewe üf mi mürina o pin, ewe souasor Aaron epwe üföüf, pwal üfen nöün kewe mwän repwe üföüf, lupwen ra föri ar angangen souasor, ");
INSERT INTO chk_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ewe löön epit me ewe minen asoren ötüöt mi pwokus fän iten ewe leni mi pin. Repwe föri meinisin ükükün mine üa allük ngonuk.” ");
INSERT INTO chk_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Kopwe üreni ekewe aramasen Israel, ‘Oupwe apini ai ränin sapat, pun epwe eu asisil lefilei me ämi seni eu täppin aramas tori eu täppin. Ren ei oupwe silei pwe ngang ewe Samol mi Lapalap üa apinikemi. ");
INSERT INTO chk_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Oupwe apini ewe ränin sapat, pun a pin ngenikemi. Iteiten aramas mi aüangaua pinin ewe rän epwe ninnila. Ewer, iteiten aramas mi föri och angang lon ränin sapat epwe käriwu seni aramasan. ");
INSERT INTO chk_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Lon ükükün wonu rän oupwe föri ämi angang, nge ewe afisuen rän ewe ränin sapat, eu ränin asösö a pin me rei. Iteiten aramas mi föri och angang lon ränin sapat epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Iei mine ekewe chon Israel repwe apini ewe ränin sapat o aüöchü pinin seni eu täppin aramas tori eu täppin, pwe asisilen eu pwon esemüch. ");
INSERT INTO chk_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ei rän eu asisil lefilei me chon Israel tori feilfeilachök. Pun lon ükükün wonu rän ngang ewe Samol mi Lapalap üa föri läng me fanüfan, nge lon ewe afisuen rän üa ükütiu le angang o asösö.’” ");
INSERT INTO chk_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Iwe, lupwen Kot a wes me kapas ngeni Moses me won ewe chuk Sinai, a ngeni ekewe rüepek fau mi chöpöp, ewe ia a mak ie ekewe allük püsin Kot a makei wor. ");
INSERT INTO chk_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Iwe, lupwen ekewe chon Israel ra küna pwe Moses a mangetiu me won ewe chuk, ra mwichefengen ren Aaron o üreni, “Etto, kopwe föri ngenikem uluulun eman kot epwe akom mwach, pun sisap silei mine a fis ngeni Moses, ewe mwän a emwenikichewu seni lon ewe fanü Isip.” ");
INSERT INTO chk_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Nge Aaron a üreniir, “Oupwe ettatiu ekewe ierring seni kolt seni selingen pwülüemi, pwal seni selingen nöümi mwän me fefin o uweereto rei.” ");
INSERT INTO chk_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Iei mine ekewe aramas meinisin ra ettatiu nöür ierring seni kolt seni selinger o uwato ren Aaron. ");
INSERT INTO chk_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Iwe, a angei seniir ekewe kolt, a ateli o ninalong lon eu lenien auluulu uluulun eman kow. Mürin, ekewe aramas ra apasa, “Iei i om we Kot, Israel, ewe mi emwenukowu seni lon ewe fanü Isip.” ");
INSERT INTO chk_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Lupwen Aaron a küna ei föför, a senätä eu rongen asor me mwen ewe uluulun kow o arongafeili, “Lesor epwe fis eu chulap fän iten ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Iwe, ekewe aramas ra pwätä lesosorusich o eäni asoren kek me asoren kinamwe. Nge wesin ar asor ra mottiu pwe repwe momongö o ükün. Mürin ra ütä o urumwotongau. ");
INSERT INTO chk_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, “Kopwe müttiritiu, pun noum kewe aramas ka emwenirewu seni lon ewe fanü Isip ra föri föför mi ngau. ");
INSERT INTO chk_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ra müttir aleasolap ngeni ekewe allük üa ngeniir, ra föri eu uluulun kow seni kolt fän iter, ra fel ngeni, ra pwal asor ngeni o apasa, ‘Iei i om we Kot Israel, ewe mi emwenukowu seni lon ewe fanü Isip.’ ");
INSERT INTO chk_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Üa küna ekei aramas pwe ir aramas mi tipepöchökül o ülöförea. ");
INSERT INTO chk_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Iei mine kopwe mwüt ngeniei pwe üpwe aroserela, pun üa fokun song ngeniir. Mürin üpwe föri senuk eu mwichen aramas mi chomong.” ");
INSERT INTO chk_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nge Moses a tütüngor ngeni an we Kot ewe Samol mi Lapalap fän iten ekewe chon Israel o apasa, “Ai Samol mi Lapalap, pwota ka fokun song ngeni noum kei aramas ka emwenirewu seni lon ewe fanü Isip ren om manaman, pwal ren poum mi fokun manaman? ");
INSERT INTO chk_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ifa usun, ka mochen pwe ekewe chon Isip repwe apasa, ‘A chök emwenirewu, pun a ekiekin afeiengaueer. A mochen nirela won ekewe chuk o aroserela seni won fanüfan?’ Kopwe likitala om song mi pöchökül, kopwe pwal siwili om ekiekin afeiengaua noum kewe aramas. ");
INSERT INTO chk_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kopwe chechemeni noum kewe chon angang Apraham, Isaak, me Israel, pun ka pwon fän akapel ngeniir fän püsin itom o üreniir pwe kopwe achomongala mwirimwirir usun fün läng, kopwe pwal ngeni mwirimwirir unusen ewe fanü, pwe repwe fanüeni tori feilfeilachök usun ka fen pwon ngeniir.” ");
INSERT INTO chk_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mürin, ewe Samol mi Lapalap a siwili an ekiekin afeiengaua nöün aramas. ");
INSERT INTO chk_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Iwe, Moses a kul o feitiu me won ewe chuk, nge a uwei ekewe rüepek fau mi chöpöp lepöün, ekewe allük ra mak wor me rüepek. ");
INSERT INTO chk_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Iwe, ekei rüepek fau Kot a püsin falei o makei ekewe allük wor. ");
INSERT INTO chk_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Nge lupwen Josua a rong akürangen ekewe aramas mi mweireir, a üreni Moses, “A fis akürangen maun lon lenier.” ");
INSERT INTO chk_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Nge Moses a üreni, “Ei akürang sap akürangen aramas mi win ika kuf, nge mine üa rong ngingin aramas mi köl.” ");
INSERT INTO chk_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Iwe, lupwen Moses a arap ngeni lenien ekewe chon Israel, a küna ewe uluulun kow me ekewe aramas ra pworuk ünükün. Mürin, Moses a fokun lingeringer, pwe a aturätiu me lepöün ekewe rüepek fau o amökküür me fäsonun ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","A angei ewe uluulun kow ra föri, a atelala o atatakisi, a pwal wüsi o atoropasafeili moromoran lon koluk. Mürin a echimwa ekewe chon Israel pwe repwe ünümi ewe koluk. ");
INSERT INTO chk_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Iwe, Moses a aisini Aaron, “Met ekei aramas ra föri ngonuk pwe ka uwato wor eu tipis mi lapalap?” ");
INSERT INTO chk_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Nge Aaron a üreni, “Ai samol, kosap fokun song ngeniei. Ka püsin silei usun ekei aramas, pwe ra müttir ngeni le föri mine a ngau. ");
INSERT INTO chk_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Pun ra apasa ngeniei, ‘Kopwe föri ngenikem uluulun eman kot epwe akom mwem. Pun aisap silei mine a fis ngeni Moses, ewe mwän mi emwenikichewu seni ewe fanü Isip.’ ");
INSERT INTO chk_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Iei mine üa üreniir, ‘Iteiten eman me eman mi wor an fout seni kolt epwe uttawu.’ Mürin ra ngeniei ar kewe kolt, nge ngang üa atururolong lon ekkei. Iwe, a fis ei uluulun kow.” ");
INSERT INTO chk_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Iwe, Moses a küna pwe ekewe aramas ra parangarang, pun Aaron a mwüt ngeniir pwe repwe parangarang. Iei mine ra asäw me ren chon oputeer. ");
INSERT INTO chk_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mürin, Moses a ütä leasamalapen lenier we o leüömong le kökkö, “Iön pekin ewe Samol mi Lapalap? Oupwe feito rei.” Iwe, ekewe mwän meinisin seni ewe ainangen Lefi ra mwicheto ren. ");
INSERT INTO chk_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Moses a üreniir, “Iei alon ewe Samol mi Lapalap, ewe Koten Israel: Iteiten eman me eman mwän epwe rietä nöün ketilas lepekin o asaifetal lon ei leni seni eu asamalap tori pwal eu. Iwe, epwe ni pwin me chiechian me chon arun.” ");
INSERT INTO chk_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Iei usun ekewe mwän seni ewe ainangen Lefi ra föri mine Moses a apasa. Lon ewe rän ina epwe ükükün ülüngeröü mwän ra mäla me lein ekewe aramas. ");
INSERT INTO chk_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mürin, Moses a üreniir, “Ikenai oua püsin apinikemi fän iten angangen ewe Samol mi Lapalap, pokiten oua niela püsin nöümi mwän ika püsin pwimi. Iwe, Kot a afeiöchükemi ikenai.” ");
INSERT INTO chk_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Sorotän ewe rän Moses a üreni ekewe aramas, “Oua föri eu tipis mi lapalap. Iei üpwe feitä ren ewe Samol mi Lapalap. Eli üpwe tongeni föri angangen amusamusen ämi tipis.” ");
INSERT INTO chk_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mürin, Moses a liwinsefälitä ren ewe Samol mi Lapalap o üreni, “Üa lolilen, pun ekei aramas ra föri eu tipis mi lapalap. Ra föri kot fän iter seni kolt. ");
INSERT INTO chk_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Iwe, kose mochen kopwe amusala ar tipis. Nge ika kosap mochen, üa tüngor ngonuk, kopwe pwal talawu itei seni om puk ia ka makei iten noum kana ie.” ");
INSERT INTO chk_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nge ewe Samol mi Lapalap a üreni Moses, “Iteiten iö mi tipis ngeniei üpwe talawu itan seni ai puk. ");
INSERT INTO chk_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Iei kopwe feila. Kopwe emwenala ekewe aramas ngeni ewe leni üa fen kapas ngonuk usun. Nengeni, nei chon läng epwe akom mwom. Nge epwe war ewe fansoun üpwe liwini ngeniir liwinin ar tipis.” ");
INSERT INTO chk_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Iwe, ewe Samol mi Lapalap a awarato feiengau won ekewe aramas, pokiten ra fel ngeni ewe kow Aaron a föri. ");
INSERT INTO chk_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe feila seni ikei, ämi me ekewe aramas ka emwenirewu seni ewe fanü Isip. Kopwe emwenirela ngeni ewe fanü üa fen pwon fän akapel ngeni Apraham, Isaak me Jakop pwe üpwe ngeni mwirimwirir. ");
INSERT INTO chk_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Iwe, üpwe tinala eman chon läng pwe epwe akom mwom, üpwe pwal asüewu ekewe chon Kanaan, chon Amor, chon Hit, chon Peris, chon Hiw me chon Jepus. ");
INSERT INTO chk_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Kopwe feila lon ewe fanü mi pwülüöch o fanüeräs. Nge üsap etikemi, pwe üsap arosakemiila me won al, pun ämi eu mwichen aramas mi ülöförea o tipepöchökül.” ");
INSERT INTO chk_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Iwe, lupwen ekewe aramas ra rongorong ekei fos mi eniwokus, ra letipeta. Nge esap wor eman a foutei. ");
INSERT INTO chk_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pun ewe Samol mi Lapalap a fen üreni Moses, “Kopwe üreni ekewe aramasen Israel: Ämi eu mwichen aramas mi ülöförea me tipepöchökül. Ika üpwe etikemi fansoun mochomoch echök, üpwe arosakemiila. Iei mine oupwe ettatiu foutemi iei, pwe üpwe silei mine üpwe föri ngenikemi.” ");
INSERT INTO chk_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Iei mine ekewe aramasen Israel resap chüen fouteer seni ewe fansoun ra nom ren ewe chuk Horep. ");
INSERT INTO chk_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Iwe, Moses a angei ewe imw mangaku o aüetä lükün toau seni ewe ia chon Israel ra nonom ie. Iwe, a aita ngeni ewe imw imwenfel seni mangaku ia aramas ra churi Kot ie. Nge iteiten eman me eman mi mochen churi ewe Samol mi Lapalap, a feila ngeni ewe imwenfel seni mangaku a nom lükün ewe leni ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Iteiten fansoun Moses a feila ngeni ewe imw mangaku, aramas meinisin ra ütä leasamalapen imwer o nenela mürin Moses tori a tolong lon ewe imw mangaku. ");
INSERT INTO chk_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Lupwen Moses a tolong lon, ewe ürekuchu a feitiu o ü leasamalapen ewe imw mangaku. Iwe, ewe Samol mi Lapalap a fos ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nge lupwen ekewe aramas meinisin ra küna pwe ewe ürekuchu a ü leasamalapen ewe imw mangaku, ir meinisin ra chapetiu lepwül, eman me eman lon en me asamalapen imwan. ");
INSERT INTO chk_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Iei usun ewe Samol mi Lapalap a fos newenewen ngeni Moses, usun eman aramas a fofos ngeni chienan. Nge lupwen Moses a liwiniti lenier, nöün chon angang Josua nöün Nun we mwän esap towu seni ewe imw mangaku. ");
INSERT INTO chk_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Iwe, Moses a üreni ewe Samol mi Lapalap, “Nengeni, ka kapas ngeniei pwe üpwe emwenala ekei aramas ngeni ewe fanü, nge kosap asile ngeniei iö kopwe tini pwe epwe etiei. Nge ka fen üreniei, ‘Üa sileek, ka pwal küna ümöümöch me rei.’ ");
INSERT INTO chk_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Iei mine üa tüngor ngonuk, ika üa küna ümöümöch me reöm, kopwe aiti ngeniei om akot pwe üpwe sileek o küküna ümöümöch me reöm. Kopwe pwal chechemeni pwe ekei aramas noum.” ");
INSERT INTO chk_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Iwe, Kot a pälüeni, “Püsin ngang üpwe etuk, üpwe pwal asösök.” ");
INSERT INTO chk_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mürin, Moses a üreni, “Are en kosap püsin etikem, kosap pwal atokeemiwu seni ikei. ");
INSERT INTO chk_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ren met epwe pwä pwe aia küna ümöümöch me reöm, äm me noum aramas? Ifa usun, esap pwä, lupwen ka püsin etikem? Ren ei äm me noum aramas aipwe sokola seni aramas meinisin won fanüfan.” ");
INSERT INTO chk_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Iwe, ewe Samol mi Lapalap a üreni Moses, “Üpwe fokun föri meinisin mine ka tüngor, pun üa sileek, ka pwal küna ümöümöch me rei.” ");
INSERT INTO chk_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mürin, Moses a üreni, “Kose mochen kopwe aküna ngeniei lingom.” ");
INSERT INTO chk_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Iwe, Kot a üreni, “Üpwe awora ai kirikiröch pwe epwe akom mwom, üpwe pwal asilefeili me mwom itei we ‘Samol mi Lapalap’. Iwe, üpwe ümöümöch ngeni iö üa mochen ümöümöch ngeni, üpwe pwal eäni tong ngeni iö üa mochen eäni tong ngeni. ");
INSERT INTO chk_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nge kosap tongeni küna won mesei, pun esap wor eman epwe manau ika epwe küna won mesei.” ");
INSERT INTO chk_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mürin, ewe Samol mi Lapalap a üra, “Nengeni, mi wor eu leni ünüki ia ka tongeni ütä won eu achau ie. ");
INSERT INTO chk_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Nge lupwen ai ling epwe waroto, üpwe aopokolong lon pwangen ei achau o pwölü ngonuk pei, tori üpwe lüla senuk. ");
INSERT INTO chk_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mürin üpwe asü pei pwe kopwe küna lükisöküri, nge won mesei kosap tongeni küna.” ");
INSERT INTO chk_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe falei rüepek fau mi chöpöp usun chök ekewe me mwan. Iwe, üpwe ruputi wor ekewe kapas mi mak won ekewe fau mi chöpöp ka amökküür me mwan. ");
INSERT INTO chk_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kopwe amoloketä lesosorun lesor, pwe kopwe feitä won ewe chuk Sinai. Kopwe churiei ikenan won ungen ewe chuk. ");
INSERT INTO chk_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Esap wor eman epwe etuketä, esap pwal wor eman aramas epwe nomofetal won ewe chuk. Pwal ekewe pwiin sip me kow resap tongeni mongöfetal fäsonun ewe chuk.” ");
INSERT INTO chk_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Iei mine Moses a falei rüepek fau mi chöpöp usun chök ekewe me mwan. Iwe, a pwätä lesosorusich o feitä won ewe chuk Sinai, usun ewe Samol mi Lapalap a allük ngeni. Nge a uwei lepöün ekewe rüepek fau mi chöpöp. ");
INSERT INTO chk_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Mürin, ewe Samol mi Lapalap a feitiu lon eu kuchu, a ütä ren Moses ikenan o kökköri itan we Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Iwe, ewe Samol mi Lapalap a lü seni Moses o kökkö, “Ngang ewe Samol mi Lapalap, ngang ewe Samol mi Lapalap, ngang eman Kot mi eäni ümöümöch me kirikiröch, üa songomang, üa pwal wöün tong me allükülük. ");
INSERT INTO chk_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Üa eäni tong ngeni ngeröü o amusala föföringau me pupungau me tipis. Nge üsap amusafatei chon tipis, pwe üa liwini än samasam tipis won nöür me nöün nöür tori aülüngatin me arüanün tettelin aramas.” ");
INSERT INTO chk_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Iwe, Moses a müttir chapetiu lepwül o fel ngeni. ");
INSERT INTO chk_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","A apasa, “Ai Samol, are üa wesewesen küna ümöümöch me reöm, üa tüngor ngonuk pwe kopwe etikem. Mi pwüng pwe ir aramas mi ülöförea me tipepöchökül, nge kopwe amusala äm föföringau me äm tipis o atolongakem lon tettelin noum.” ");
INSERT INTO chk_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mürin, Kot a üreni Moses, “Iei üpwe föri eu pwon lefilei me ekewe chon Israel. Üpwe föri manaman me fän mesen ekei aramas meinisin, sokun manaman resamwo fis won unusen fanüfan ika lon eu mwü. Iwe, ekewe aramas meinisin ka nom leir repwe küna ekewe föför mi eniwokus ngang ewe Samol mi Lapalap üpwe föri fän itom. ");
INSERT INTO chk_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Oupwe aleasochisi mine üa allük ngenikemi ikenai. Üpwe asüela seni me mwemi ekewe chon Amor, chon Kanaan, chon Hit, chon Peris, chon Hiw me chon Jepus. ");
INSERT INTO chk_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Iwe, oupwe afälikemi pwe ousap föri eu pwon ngeni chon ewe fanü ia oupwe feila ie, pwe resap wiliti eu lenien likatup ngenikemi. ");
INSERT INTO chk_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nge oupwe amökkätiu ar kewe rongen asor, oupwe atatakisi ar kewe ürefau mi pin o pöküetiu ar kewe uluulun ewe anüfefin Asera. ");
INSERT INTO chk_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ousap fel ngeni pwal eman kot, pun ngang ewe Samol mi Lapalap itei lukomong, ngang eman Kot mi lukomong won aramasei. ");
INSERT INTO chk_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Iwe, ousap föri eu pwonen atipeeu ngeni chon ewe fanü, pun ar fel me asor ngeni ar kewe kot a usun chök angangen lisowu me rei. Repwe körikemi, nge ämi oupwe etiir le mongö seni ar kewe asor ra asomä ngeniir. ");
INSERT INTO chk_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Nge are oua apwüpwülüa nöümi mwän ngeni nöür föpwül mi fel ngeni ar kewe kot, ir repwe atupu nöümi mwän pwe repwe pwal föri iei usun. ");
INSERT INTO chk_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ousap föri uluulun kot seni mächä fän itemi. ");
INSERT INTO chk_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Iwe, oupwe föri ewe chulapen mongö pilawa esap wor iis lon. Lon ükükün fisu rän oupwe mongö pilawa esap wor iis lon, usun üa fen allük ngenikemi. Oupwe föri ei lon ewe fansoun üa filätä, lon ewe maram Apip, pun lon ewe maram oua towu seni Isip. ");
INSERT INTO chk_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Iwe, ekewe mwänichi meinisin nei, pwal ekewe ätemwänin mweinöün man seni ekewe pwiin kow me sip nei. ");
INSERT INTO chk_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Nge eman mweinöün aas epwe akasiwil ngeni eman nienifön sip. Iwe, ika kosap mochen akasiwili, kopwe kupi üen ewe aas. Nöümi mwänichi meinisin oupwe möni. Esap wor eman epwe feito rei fän an asöülapö. ");
INSERT INTO chk_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Iwe, wonu rän oupwe föri ämi angang, nge lon ewe afisuen rän oupwe asösö. Pwal lupwen fansoun tuw pwül me fansoun kinikin oupwe asösö. ");
INSERT INTO chk_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Iwe, oupwe föri ewe chulapen wiik, ewe fansoun kinikin mwen uän irän wiich, pwal ewe chulapen ionalong uän fanüemi leamüchülan eu ier. ");
INSERT INTO chk_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Fän ülüngat lon eu ier nöümi mwän meinisin repwe feito o fel ngeniei ngang Kot ewe Samol mi Lapalap, ewe Koten Israel. ");
INSERT INTO chk_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Pun üpwe asüela chon ekewe mwü seni mwemi o awatteloi kiännin fanüemi. Nge esap wor eman epwe mocheniaiti fanüemi, lupwen oupwe feila fän ülüngat lon eu ier, pwe oupwe fel ngeniei ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Iwe, ousap eäni asor ngeniei chan ewe mönün asor fiti pilawa mi wor iis lon, ousap pwal iseis och seni ewe mönün asoren Pasofer tori lesosor. ");
INSERT INTO chk_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Oupwe uwato öchün mwen uän fanüemi lon imwei ngang ewe Samol mi Lapalap ämi we Kot. Ousap kuku eman apanen kuuch lon chönün oupun ewe inelap.” ");
INSERT INTO chk_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe makei ekei kapas, pun ai pwon ngonuk me ekewe chon Israel a nom lon ekei kapas.” ");
INSERT INTO chk_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Iwe, Moses a nom ren ewe Samol mi Lapalap lon ükükün faik rän me faik pwin. Esap mongö, esap pwal ünümi koluk. Iwe, Kot a ruputi won ekewe fau mi chöpöp kapasen ewe pwon, ekewe engol allük. ");
INSERT INTO chk_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Iwe, Moses a feitiu seni won ewe chuk Sinai o amwöchü lepöün ekewe rüepek fau mi chöpöp ia a mak ie ekewe engol allük. Nge lupwen a feitiu, Moses esap silei pwe won mesan a saramaram pokiten an kapasfengen me Kot. ");
INSERT INTO chk_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Iwe, lupwen Aaron me ekewe aramasen Israel meinisin ra küna Moses pwe won mesan a saramaram, ra niuokus ar repwe kan ngeni. ");
INSERT INTO chk_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nge Moses a kökköriir. Iwe, Aaron me ekewe souemwenin ewe mwichen chon Israel ra liwinsefälito ren, nge Moses a fos ngeniir. ");
INSERT INTO chk_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Mürin, ekewe aramasen Israel meinisin ra kanoto ren. Iwe, Moses a aiti ngeniir ekewe allük meinisin ewe Samol mi Lapalap a fen ngeni me won ewe chuk Sinai. ");
INSERT INTO chk_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Iwe, lupwen Moses a wes me kapas ngeniir, a pwölüela won mesan ngeni echö mangaku. ");
INSERT INTO chk_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Nge iteiten fansoun än Moses tolong lon ewe imw mangaku ren ewe Samol mi Lapalap pwe epwe kapas ngeni, a särifala ewe pwölüpwöl me won mesan tori a pwal towusefäl. Iwe, lupwen a towu, a apworausa ngeni ekewe aramasen Israel mine Kot a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ekewe aramasen Israel ra küna won mesen Moses pwe a saramaram. Mürin, Moses a pwal pwölüsefäliela won mesan tori a tösefälilong lon ewe imw mangaku, pwe epwe kapas ngeni Kot. ");
INSERT INTO chk_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Iwe, Moses a emwichafengeni ekewe chon Israel meinisin o üreniir, “Ikkei än ewe Samol mi Lapalap allük ngenikemi pwe oupwe föri. ");
INSERT INTO chk_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Lon wonu rän oupwe föri ämi angang, nge ewe afisuen rän epwe eu ränin sapat mi pin ngenikemi, eu ränin asösö fän iten ewe Samol mi Lapalap. Eman mi föri och angang lon ei rän epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ousap kaküw ekkei lon leniemi meinisin lon ewe ränin sapat.” ");
INSERT INTO chk_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Iwe, Moses a üreni ekewe chon Israel meinisin, “Ikkei än ewe Samol mi Lapalap allük ngenikemi: ");
INSERT INTO chk_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Oupwe uwato eu alilis fän iten ewe Samol mi Lapalap seni mine oua eäni. Eman mi fangafangöch seni lelukan epwe uwato an alilis fän iten ewe Samol mi Lapalap: kolt, silifer me piras, ");
INSERT INTO chk_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech, mangaku seni ülöülen kuuch, ");
INSERT INTO chk_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","silin ätemwänin sip mi kapar me silin man mi mürina, pwal pap seni ewe irä akasia, ");
INSERT INTO chk_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","noppuk fän iten ekewe lamp, uän irä mi pwokus me chön fän iten löön epit, pwal fän iten apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","fau aüchea itan oniks me sokun fau aüchea fän iten elingen ewe üf itan efot, pwal fän iten ewe chechen leupw.” ");
INSERT INTO chk_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Iwe, ekewe mwän meinisin mi lipwäköch le angang me leimi repwe feito o föri meinisin mine ewe Samol mi Lapalap a allük: ewe imwenfel ");
INSERT INTO chk_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","me eimweimwan seni mangaku, pwölüpwölün me ökkükün, papan me ömwöchün, üran me alongun, ");
INSERT INTO chk_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ewe pworofel fiti ämwärin me öppüngün, pwal ewe cheech mi pwölüpwöl ");
INSERT INTO chk_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ngeni ewe chepel fiti ämwärin me pisekin meinisin, ewe pilawa mi pin, ");
INSERT INTO chk_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","pwal ewe lenien atittin epwe asarama ewe leni me pisekin meinisin, ekewe lamp me noppuk seni föün olif fän iten alölör pwe repwe tin, ");
INSERT INTO chk_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ewe rongen asoren ötüöt fiti ämwärin, ewe löön epit me ewe apach mi pwokus, pwal ewe cheech fän iten asamalapen ewe imwenfel seni mangaku, ");
INSERT INTO chk_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ewe rongen asoren kek fiti äpäwunan seni piras, ämwärin me pisekin meinisin, ewe sepien töttöl me motongan, ");
INSERT INTO chk_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ewe tit mangaku fän iten ewe leni lükün ewe imwenfel, ekewe ür me alongur, pwal ewe cheech fän iten asamalapen ewe leni lükün ewe imwenfel, ");
INSERT INTO chk_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","chüfölün ewe imwenfel me chüfölün ewe leni lükün, pwal ekewe säl, ");
INSERT INTO chk_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ekewe üf mi ling fän iten ekewe souasor mi angang lon ewe leni mi pin, ikkei ekewe üf mi pin fän iten ewe souasor Aaron me nöün kewe mwän, pwe repwe üföüf le föri ar angangen souasor.” ");
INSERT INTO chk_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Iwe, ekewe aramasen Israel meinisin ra feila seni fän mesen Moses. ");
INSERT INTO chk_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Mürin ra liwinto eman me eman fän mefien letipan, pwal fän püsin an mochen, o uwato ar alilis ren ewe Samol mi Lapalap fän iten ewe imw mangaku ia aramas ra churi Kot ie me angangan meinisin, pwal fän iten ekewe üf mi pin. ");
INSERT INTO chk_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Iwe, ra feito mwän me fefin. Ir meinisin ra uwato mwärämwär, ierring, ringen won pau, lälä me sokopaten fout ren mochenin letiper. Iteiten eman me eman a fangala an fout seni kolt ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Nge chokewe mi wor rer mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech, mangaku seni ülöülen kuuch me silin ätemwänin sip mi kapar me silin man mi mürina, ra uwato. ");
INSERT INTO chk_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Iteiter meinisin mi tongeni alisi ren silifer me piras ra uwato ar alilis ren ewe Samol mi Lapalap. Nge iön mi wor an pap seni ewe irä itan akasia mi öchiti ewe angang ra uwato. ");
INSERT INTO chk_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Iwe, ekewe fefin mi lipwäköch le föri terech ra uwato terech mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech. ");
INSERT INTO chk_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ra pwal föri terech seni ülen kuuch ren mochenin letiper. ");
INSERT INTO chk_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Nge ekewe meilap ra uwato fau aüchea itan oniks me sokun fau aüchea fän iten ewe üf itan efot, pwal fän iten ewe chechen leupw. ");
INSERT INTO chk_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ra pwal uwato uän irä mi pwokus me noppuk fän iten ekewe lamp, fän iten löön epit pwal fän iten apach mi pwokus. ");
INSERT INTO chk_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Iwe, ekewe aramasen Israel meinisin mwän me fefin mi mochen ra uwato ar alilis ren ewe Samol mi Lapalap seni mefien letiper fän iten ewe angang meinisin ewe Samol mi Lapalap a allük ngeni Moses pwe epwe fis. ");
INSERT INTO chk_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mürin, Moses a üreni ekewe aramasen Israel, “Iei ewe Samol mi Lapalap a filätä Pesalel nöün Uri we mwän, nge Uri nöün Hur seni ewe ainangen Juta. ");
INSERT INTO chk_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Iwe, Kot a fen ngeni Pesalel Ngünün o fang ngeni an tufich me tipachem me silelap, pwal tufichin föri sokopaten angang meinisin, ");
INSERT INTO chk_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","pwe a sip le ekiekietä mettoch mi fö. Iwe, a sile angang ngeni kolt, silifer me piras, ");
INSERT INTO chk_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","a pwal sile angangen nechei fau aüchea pwe repwe maseöchülong lon lenier, pwal angangen fala irä me sokopaten angang. ");
INSERT INTO chk_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Iwe, Kot a pwal atufichi Pesalel me Oholiap nöün Aisamak we mwän seni ewe ainangen Tan, pwe repwe lipwäköch le aiti ngeni aramas met ra sile. ");
INSERT INTO chk_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","A amasoueer ren tufich le föri sokopaten angang, pun ir sousile sokopaten angangen pau me chon ekiekietä mettoch mi fö, pwal chon chü mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech, pwal chon tür. Ir ätekewe mi sipeöch le angang me ekiekietä mettoch mi fö. ");
INSERT INTO chk_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Iwe, Pesalel me Oholiap repwe föri ewe angang, pwal ekewe mwän meinisin ewe Samol mi Lapalap a ngeniir tufich me tipachem pwe repwe sipeöch le föri unusen angangen ewe imw mi pin. Nge repwe chök föri usun mine ewe Samol mi Lapalap a allük ngeniir. ");
INSERT INTO chk_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mürin, Moses a körato Pesalel me Oholiap, pwal ekewe mwän ewe Samol mi Lapalap a fang ngeniir ar tufich, pwal ir mi mochen feito o föri ewe angang seni mochenin letiper. ");
INSERT INTO chk_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Iwe, ra angei seni Moses ekewe alilis meinisin ekewe aramasen Israel ra uwato seni mochenin letiper fän iten angangen ewe imw mi pin. Nge iteiten lesosor ekewe aramas ra chök wakato ar alilis seni mochenin letiper, ");
INSERT INTO chk_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","pwe ekewe mwän mi föri ekewe sokopaten angang won ewe imw mi pin ra likitala ar angang, ra feito ren Moses ");
INSERT INTO chk_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","o üreni, “Ekewe aramas ra kon uwato chomong lap seni aükükün ewe angang ewe Samol mi Lapalap a allük ngenikem pwe aipwe föri.” ");
INSERT INTO chk_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mürin, Moses a allük pwe repwe asilefeili lon unusen ewe leni, pwe esap wor eman mwän ika fefin epwe chüen uwato och fän iten alilisin ewe imw mi pin. Iei mine ekewe aramas resap chüen uwato ar alilis rer, ");
INSERT INTO chk_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","pun ekewe pisek mi fen wor ra ku ngeni ewe angang meinisin, ra pwal somwola. ");
INSERT INTO chk_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Iwe, ekewe mwän meinisin mi silelap me lein chokewe mi angang ngeni ewe imwenfel seni mangaku ra föri ewe imwenfel ren engol pekin mangaku mi mürina o pwechepwech, mangaku mi arauarau me parachol me parapar. Förün a unusen mürina, nge ekewe chon silelap le chü ra chüri liosun kerop wor. ");
INSERT INTO chk_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Iwe, ekewe pekin mangaku meinisin ra nönnöfengen, langatamer ükükün engol me rüanü iach, nge chölaper ruu iach. ");
INSERT INTO chk_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ra teifengeni limu pekin mangaku, nge ekewe limu pekin ra pwal teifengeni, pwe a wor ruachö cheech. ");
INSERT INTO chk_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Mürin ra tei pwäken mi arauarau ünükün ewe echön cheech me epek, ina usun ra pwal föri won ewe aruachön cheech. ");
INSERT INTO chk_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Iwe, ra teätä lime pwäken ünükün ewe echön cheech me epek, ra pwal teätä lime pwäken ünükün ewe arüachön cheech me epek. Iwe, ekewe pwäken ra chök wenefengen. ");
INSERT INTO chk_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ra pwal föri lime ökkük seni kolt o ökküküfengeni ekewe cheech. Iei usun ewe imwenfel seni mangaku a unus. ");
INSERT INTO chk_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Mürin ra föri engol me echö pekin mangaku seni ülöülen kuuch pwe pwölüpwölün ewe imwenfel. ");
INSERT INTO chk_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Iwe, ekewe engol me echö pekin mangaku ra chök nönnöfengen ükükün langatamen echö pekin engol me limu iach, nge ükükün chölapan ruu iach. ");
INSERT INTO chk_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Iwe, ra teifengeni limachö pekin mangaku pwe repwe chök eu cheech, ra pwal teifengeni ekewe wonachö pwe epwe wor aruachön cheech. ");
INSERT INTO chk_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Mürin ra teätä lime pwäken ngeni ünükün ewe echön cheech me epek, ra pwal teätä lime pwäken ngeni ünükün ewe aruachön cheech me epek. ");
INSERT INTO chk_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Iwe, ra föri lime ökkük seni piras o ökküküfengeni ekewe pwölüpwöl pwe repwe echö chök. ");
INSERT INTO chk_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ra pwal föri echö pwölüpwöl mi kapar seni silin ätemwänin sip, pwal echö pwölüpwöl seni silin man mi mürina. ");
INSERT INTO chk_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Mürin ra föri papen ewe imwenfel seni mangaku seni ewe irä akasia, nge ekewe pap ra üwenewenetä. ");
INSERT INTO chk_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Iwe, langatamen echö me echö kewe pap ükükün engol me limu fiit, nge chölaper rüe me fisu inis. ");
INSERT INTO chk_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Nge fän iteiten echö pap a wor ruu oupun pwe ra tongeni afoufengen. Iei usun ra föri ngeni papen ewe imwenfel seni mangaku meinisin. ");
INSERT INTO chk_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Iwe, ra föri rüe pap fän iten peliörün ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Mürin ra föri faik along seni silifer o anomuur fän ekewe rüe pap, ruu along fän iteiten echö pap, pwe oupun ra sökulong lon pwangen ekewe along. ");
INSERT INTO chk_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ra pwal föri rüe pap fän iten peliefengin ewe imwenfel seni mangaku ");
INSERT INTO chk_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","me faik alongur seni silifer, ruu along fän iteiten echö pap. ");
INSERT INTO chk_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Iwe, ra föri wonachö pap fän iten lükisökürün ewe imwenfel seni mangaku me pelilotoun. ");
INSERT INTO chk_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ra pwal föri ruachö pap fän iten lepwokukun ewe imwenfel seni mangaku me lükisökürün. ");
INSERT INTO chk_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ekewe ruachö pap ra pachfengen seni fan tori asan o ökkükfengen ren efoch ring. Iei usun ra föri ngeni ekewe ruachö pap fän iten ekewe ruu pwokuku. ");
INSERT INTO chk_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ina usun a wor walüchö pap, pwal engol me wonu alongur seni silifer, ruu along fän iteiten echö pap. ");
INSERT INTO chk_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Iwe, ra föri ömwöch seni ewe irä akasia, limefoch fän iten papen lepekin ewe imwenfel seni mangaku me epek, ");
INSERT INTO chk_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","limefoch fän iten papan me pwal epek, nge limefoch fän iten papen lükisökürün me pelilotoun. ");
INSERT INTO chk_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ra pwal föri ewe ömwöch mi nom lukalapen ekewe pap seni fän mesen ewe imwenfel seni mangaku tori lükisökürün. ");
INSERT INTO chk_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Iwe, ra apacha ngeni kolt ekewe pap o föri ringen wor seni kolt, pwe ekewe ömwöch repwe sökulong lor. Ra pwal apachätä kolt won ekewe ömwöch. ");
INSERT INTO chk_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Mürin ra föri echö cheech seni mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech o mürina. Nge ekewe chon silelap le chü ra chüri liosun kerop won. ");
INSERT INTO chk_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Iwe, ra pwal föri fofoch üren ewe cheech seni ewe irä akasia o apacha ngeniir kolt. Nge won ekewe ür a wor ökkükür seni kolt, a pwal wor rüanü alongur seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ra föri echö cheech mi chü fän iten asamalapen ewe imwenfel seni mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech o mürina. ");
INSERT INTO chk_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ra pwal föri limefoch ür fiti ökkükür fän iten ewe cheech. Iwe, asen ekewe ür fiti ömwöchür ra apachätä kolt won. Ra pwal föri limu alongur seni piras. ");
INSERT INTO chk_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Iwe, Pesalel a föri ewe pworofel seni ewe irä akasia, langataman ükükün faik me limu inis, nge chölapan me tekian ükükün rüe me fisu inis. ");
INSERT INTO chk_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A apacha ngeni kolt mi mürina lon me lükün o föri elingen ünükün me won seni kolt mi chipwechip. ");
INSERT INTO chk_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Iwe, a föri fofoch ring seni kolt o apacheretä ngeni pwokukun me rüanü, ruofoch ring me epek, pwal ruofoch me epek. ");
INSERT INTO chk_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Mürin a falei ämwär seni ewe irä akasia o apachätä kolt wor. ");
INSERT INTO chk_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A sökalong ekewe ämwär lon ekewe ring mi pachetä lepekin ewe pworofel, pwe aramas ra tongeni ämwära. ");
INSERT INTO chk_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A föri öppüngün seni kolt mi mürina, langataman ükükün faik me limu inis, nge chölapan rüe me fisu inis. ");
INSERT INTO chk_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A pwal nechei uluulun ruoman kerop seni kolt won lesopun ewe öppüng me ruosop, ");
INSERT INTO chk_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","eman kerop won me esop, nge eman won me pwal esop. Iwe, ewe öppüng me ekewe kerop mi nom lesopun me ruosop ra chök förunusfengen. ");
INSERT INTO chk_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Iwe, pöükässin ekewe kerop ra itila o meresila, pwe ra ochunoi won ewe öppüng, nge won meser ra sapefengen o wenetiu ngeni ewe öppüng. ");
INSERT INTO chk_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Iwe, a pwal föri eu chepel seni ewe irä akasia, langataman ükükün ilik me wonu inis, chölapan ükükün engol me walü inis, nge tekian rüe me fisu inis. ");
INSERT INTO chk_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Mürin a apacha ngeni kolt mi mürina o föri elingen ünükün me won seni kolt mi chipwechip. ");
INSERT INTO chk_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Iwe, a pwal föri aamen won pwelin ünükün, tekian ükükün ülüngat inis, o föri och eling won seni kolt mi chipwechip. ");
INSERT INTO chk_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A föri fofoch ring seni kolt o pacheretä ngeni pwokukun me rüanü ia ekewe fofoch pechen ra nom ie. ");
INSERT INTO chk_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ekewe ring ra kükü ngeni aamen ewe chepel, pun ekewe ämwär ra sökulong lor, pwe aramas ra tongeni ämwära. ");
INSERT INTO chk_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Iwe, a falei ämwärin ewe chepel seni ewe irä akasia o apachätä kolt wor. ");
INSERT INTO chk_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","A pwal föri pisekin won ewe chepel seni kolt mi mürina: sepi me peleich, kap me rume fän iten ewe asoren ün. ");
INSERT INTO chk_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Mürin a föri eu lenien atittin seni kolt mi mürina, nge motongan me popun a auluul o nechenech ngeni ama. Iwe, elingan meinisin, ekewe uluulun pön irä me kirupun ra förunus me ewe lenien atittin. ");
INSERT INTO chk_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","A pwal wor wonofoch keangan ra keang seni ewe popun, ülüfoch me epek, pwal ülüfoch me epek. ");
INSERT INTO chk_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Iwe, won eu me eu keangan a wor ülüpö uluulun pön irä usun chök pön ewe irä itan almont, nge iteiten pön irä a wor kirupun me fan. Ina usun lapalapen ekewe wonofoch keang mi keang seni popun ewe lenien atittin. ");
INSERT INTO chk_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Nge won popun a wor fapö uluulun pön irä usun chök pön ewe irä almont, a pwal wor föföü kirupur. ");
INSERT INTO chk_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Iwe, a wor äkääföü kirup a nom fän iteiten ekewe leni ia ekewe fofoch keang ra keang seni ie. ");
INSERT INTO chk_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nge ekewe kirup me ekewe keang ra förunus. Ina usun unusen ewe lenien atittin a för seni kolt mi mürina, a auluul o nechenech ngeni ama. ");
INSERT INTO chk_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Iwe, a pwal föri fisu lamp fän iten ewe lenien atittin, ekewe fich me lenien mooch seni kolt mi mürina. ");
INSERT INTO chk_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ewe lenien atittin me pisekin meinisin a föriir seni ina epwe ükükün fik me limu paun kolt mi mürina. ");
INSERT INTO chk_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Mürin a föri eu rongen asoren ötüöt seni ewe irä akasia, langataman me chölapan ra chök nönnöfengen ükükür engol me walü inis. Iwe, tekian ükükün ilik me wonu inis, nge mächän kewe fofoch ra förunusfengen me ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Iwe, a apacha kolt mi mürina ngeni won me lepekin meinisin, pwal ngeni mächän kewe, a pwal elinga ngeni kolt mi chipwechip ünükün me won. ");
INSERT INTO chk_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A föri ruofoch ring seni kolt o apacheretä fän alingan we me epek. A pwal föri ina usun me epek, pwe ekewe ämwär ra sökulong lor, pwe aramas ra tongeni ämwära. ");
INSERT INTO chk_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A falei ekewe ämwär seni ewe irä akasia o apachätä kolt wor. ");
INSERT INTO chk_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Iwe, a pwal föri löön epit mi pin me apach mi pwokus usun chon föri lö ra föri. ");
INSERT INTO chk_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Mürin a föri ewe rongen asoren kek seni ewe irä akasia. Langataman me chölapan ra chök nönnöfengen ükükür fisu esop fiit, nge tekian ükükün rüanü esop fiit. ");
INSERT INTO chk_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A pwal föri fofoch mächä won ekewe rüanü lepwokukun. Nge ekewe mächä ra chök förunusfengen me ewe rongen asoren kek, a pwal apachätä piras ngeni won unusen ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A föri pisekin ewe rongen asoren kek meinisin: ekewe nape me söföl, ekewe sepi fän iten chan ekewe mönün asor me chü me sepi fän iten molien lon. Ekewe pisek meinisin a föriir seni piras. ");
INSERT INTO chk_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Iwe, a föri äpäwunen ewe rongen asoren kek seni piras, nge ewe äpäwun a nom fän aaman seni lukalapan tori fan. ");
INSERT INTO chk_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Iwe, won ewe äpäwun mi för seni piras a pwal apachätä fofoch ring ngeni pwokukun me rüanü fän iten ekewe ämwär. ");
INSERT INTO chk_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A pwal falei ekewe ämwär seni ewe irä akasia o apachätä piras wor. ");
INSERT INTO chk_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Iwe, a sökalong ekewe ämwär lon ekewe ring mi pachetä lepekin ewe rongen asor me rüepek, pwe aramas ra tongeni ämwära. A föri ewe rongen asoren kek seni pap, nge lon a pön. ");
INSERT INTO chk_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Iwe, ewe lenien töttöl me motongan seni piras a föri seni ekewe kilasen ori seni piras a angei me ren ekewe fefin mi angang leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Mürin a föri ewe leni lükün ewe imwenfel seni mangaku. Lepeliörün ewe leni a tit ngeni mangaku mi pwechepwech, langataman ükükün lime iach. ");
INSERT INTO chk_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Iwe, a wor rüe üran me rüe alongur seni piras, nge ökkükün won ekewe ür pwal mächän lefiler me asan ra för seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Nge lepeliefengin ewe leni a pwal tit ngeni mangaku langataman ükükün lime iach, a pwal wor rüe üran me rüe alongur seni piras. Iwe, ökkükün won ekewe ür pwal mächän lefiler me asan ra för seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Iwe, lepelilotoun ewe leni a tit ngeni mangaku, chölapan ükükün rüe me limu iach, a pwal wor engol üran me engol alongur. Nge ökkükün won ekewe ür pwal mächän lefiler me asan ra för seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Nge fän mesen ewe leni me peliötiuan chölapan ükükün rüe me limu iach. ");
INSERT INTO chk_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Iwe, lepekin ewe asamalap me epek a tit ngeni mangaku langataman ükükün fisu esop iach, a pwal wor ülüfoch üran me ülüngat alongur. ");
INSERT INTO chk_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Pwal ina chök usun ewe epek, pun lepekin ewe asamalap me rüepek a tit ngeni mangaku langataman ükükün fisu esop iach, a pwal wor ülüfoch üran me ülüngat alongur. ");
INSERT INTO chk_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Iwe, unusen pwelin ewe leni lükün ewe imwenfel seni mangaku a tit ngeni mangaku mi pwechepwech. ");
INSERT INTO chk_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Alongun ekewe ür ra för seni piras, nge ökkükün won ekewe ür me mächän lefiler ra för seni silifer. Asen ekewe ür a pwal pwölüpwöl ngeni silifer, nge mächän lefiler meinisin ra för seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Iwe, ewe cheech mi chü fän iten asamalapen ewe leni lükün a för seni mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech. Langatamen ewe cheech ükükün engol iach, nge tekian a nönnöfengen chök me mangakun ewe tittin lükün ükükün ruu esop iach. ");
INSERT INTO chk_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Iwe, mi wor fofoch üren ewe asamalap me rüanü alongur mi för seni piras. Nge ökkükür me pwölüpwölün aser pwal mächän lefiler ra för seni silifer. ");
INSERT INTO chk_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nge chüfölün ewe imwenfel seni mangaku meinisin tori chüfölün unusen pwelin ewe leni lükün ra för seni piras. ");
INSERT INTO chk_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ikkei iteiten pisekin ewe imwenfel seni mangaku, ewe ia ekewe allük ra nom ie. Ekewe mwän seni ewe ainangen Lefi ra föri ewe angangen alea fän emwenien Itamar nöün ewe souasor Aaron we mwän, usun Moses a allük ngeniir. ");
INSERT INTO chk_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Iwe, Pesalel nöün Uri we mwän, nge Uri nöün Hur seni ewe ainangen Juta, a föri meinisin mine ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","A pwal wor chienan itan Oholiap nöün Aisamak we mwän seni ewe ainangen Tan. I eman sousilelap le angangen pau me ekiekietä mettoch mi fö, a pwal sile chü mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech. ");
INSERT INTO chk_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Iwe, ewe kolt meinisin ra aea ren angangen kaütän ewe imw mi pin ükükün ruungeröü ipükü tiue me limu paun, nge ra för won ewe kilo ra aea le aükük lon ewe imw mi pin. Ei kolt än aramas alilis. ");
INSERT INTO chk_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Iwe, ewe silifer seni chokewe mi alealong lon iteiten ar we mwich ükükün füngeröü limepükü lime paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Iteiten eman me eman mi alealong lon ewe iteit seni rüe ier feitä a püngütiu eu lelimu aunus silifer a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Iteiter meinisin wonopükü ülüngatngeröü limepükü lime mwän. ");
INSERT INTO chk_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Iwe, ekewe ipükü alongun ewe imw mi pin pwal alongun üren ewe cheech ra för seni füngeröü limepükü paun silifer, pun eu along nge fik me limu paun. ");
INSERT INTO chk_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Nge seni ekewe lime paun silifer Pesalel a föri ökkükün ekewe ür me pwölüpwölün aser, a pwal föri mächän lefiler seniir. ");
INSERT INTO chk_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Iwe, fesinien ekewe aramas piras ükükün limungeröü ülüpükü engol paun. ");
INSERT INTO chk_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Seni ei ükükün piras a föri alongun asamalapen ewe imw mangaku ia aramas ra churi Kot ie, ewe rongen asoren kek me ewe äpäwun, pwal pisekin ewe rongen asoren kek meinisin, ");
INSERT INTO chk_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","a pwal föri alongun unusen pwelin ewe leni lükün, alongun asamalapan me chüfölün ewe imwenfel seni mangaku meinisin, pwal chüfölün pwelin ewe leni lükün. ");
INSERT INTO chk_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Iwe, ra tei üf mi mürina seni ekewe mangaku mi arauarau me parachol me parapar fän iten ewe angang lon ewe leni mi pin. Ra tei üf mi pin fän iten Aaron usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Iwe, ra tei ewe üf itan efot seni mangaku mi arauarau me parachol me parapar, pwal seni mangaku mi pwechepwech, ra pwal aea terech kolt. ");
INSERT INTO chk_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ra wüsi kolt pwe a chöpöpüla, mürin ra ämetätiu o türünifengeni me ekewe mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech lon sokopaten fout. ");
INSERT INTO chk_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ra föri ruachö chechen won afaren ewe efot o teiretä lekochun me won afaran, pwe ekewe ruu pekin ra pachefengen. ");
INSERT INTO chk_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Iwe, kiren ewe riri mi nom won ewe efot a usun chök kiren ewe üf, pun a för seni terech kolt me mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech, usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ra nechei ekewe fau aüchea iter oniks o amaserelong lon lenien ömwöchür seni kolt, ra pwal ruputi iten nöün Israel kewe mwän wor, usun chök rupun won ringen pwau. ");
INSERT INTO chk_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Iwe, ra amaseretä won chechen won afaren ewe efot, pwe föün ächema iten nöün Israel kewe mwän, usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Mürin ra föri ewe chechen leupw mi mürina seni terech kolt me mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech, usun chök förün ewe efot. ");
INSERT INTO chk_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Iwe, ewe chechen leupw a wor ruu säsärin, nge langataman me chölapan ra nönnöfengen ükükür tiu inis. ");
INSERT INTO chk_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Won ewe cheech ra amasalong rüanü telin fau aüchea. Iwe, won aeuin telin a wor ülüföü fau iter sartius, topas me karpunkel. ");
INSERT INTO chk_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Nge won aruuen telin a wor ülüföü fau iter emeralt, safaia me taiamont. ");
INSERT INTO chk_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Iwe, won aülüngatin telin a wor ülüföü fau iter iasint, akit me ametist, ");
INSERT INTO chk_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","nge won aruanün telin a wor ülüföü fau iter peril, oniks me iasper. Ir meinisin ra kamasolong lon lenien ömwöchür kewe seni kolt. ");
INSERT INTO chk_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Iei usun a wor engol me ruoföü fau aüchea ükükün iteiten nöün Israel kewe mwän. Iwe, iteiten eföü me eföü kewe fau a rup wor iten ekewe engol me ruu ainangen Israel, nge ewe mak a usun chök rupun won ringen pwau. ");
INSERT INTO chk_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Mürin ra föri selin ewe chechen leupw seni kolt mi mürina usun chök lül mi kon. ");
INSERT INTO chk_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ra pwal föri ruu lenien ömwöch pwal ruofoch ring seni kolt o apacheretä lepwokukun won ewe chechen leupw me ruu. ");
INSERT INTO chk_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Mürin ra riri ekewe ruofoch säl seni kolt ngeni ekewe ruofoch ring mi nom lepwokukun ewe chechen leupw. ");
INSERT INTO chk_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Nge lesopun ekewe ruofoch säl ra riri ngeni ekewe ruu lenien ömwöch mi nom won ekewe chechen won afaren ewe efot me fän mesan. ");
INSERT INTO chk_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Iwe, ra pwal föri ruofoch ring seni kolt o apacheretä lepwokukun ewe cheech me fan, pwe repwe nom lefilen ewe cheech me ewe efot. ");
INSERT INTO chk_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Mürin ra pwal föri ruofoch ring seni kolt o apacheretä lesopun me fän ekewe rüachö chechen won afaren ewe efot me fän mesan, pwe a nom lekochun ewe efot asen ewe riri. ");
INSERT INTO chk_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Iwe, ra rifengeni ringen ewe chechen leupw ngeni ringen ewe efot ren efoch säl mi arauarau, pwe a nom asen ririn ewe efot, nge esap nükütomotom me won. Iei usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Mürin ra tei ewe owokot mi nom fän ewe efot seni chök mangaku mi arauarau. ");
INSERT INTO chk_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Iwe, leawen ewe owokot a usun chök leawen echö üf, nge ünükün leawan a wor leisin, pwe esap tongeni kam. ");
INSERT INTO chk_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Nge lepwülün ra teätä uluulun apel seni mangaku mi arauarau me parachol me parapar, pwal mangaku mi pwechepwech. ");
INSERT INTO chk_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ra pwal föri pel seni kolt mi mürina o teiretä lefilen ekewe uluulun apel won pwelin lepwülün ewe owokot. ");
INSERT INTO chk_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","A iei usun: eu pel, eföü apel, eu pel, eföü apel won pwelin lepwülün ewe owokot ra üföüf le angang. Iei usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Iwe, ra tei ekewe sööch seni mangaku mi mürina o pwechepwech fän iten Aaron me nöün kewe mwän. ");
INSERT INTO chk_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ra pwal tei ewe akkaw mi watte me ekewe mi kükün, pwal ekewe rauesesin lon seni mangaku mi mürina o pwechepwech. ");
INSERT INTO chk_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Nge ewe pelit a för seni mangaku mi mürina o pwechepwech, pwal seni mangaku mi arauarau me parachol me parapar, a pwal chü. Iei usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Iwe, ra föri epa mwärämwär mi pin seni kolt mi mürina o ruputi ewe kapas won, “A pin me ren ewe Samol mi Lapalap”. Nge makan a usun rupun won ringen pwau. ");
INSERT INTO chk_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Mürin ra föti ngeni efoch säl mi arauarau pwe epwe riritiu won ewe akkaw, usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Iei usun a wesöchüla meinisin angangen ewe imwenfel seni mangaku ia aramas ra churi Kot ie. Iwe, ekewe aramasen Israel ra föri meinisin usun mine ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ra uwato ewe imwenfel seni mangaku ren Moses, ewe imw mangaku me pisekin meinisin, ökkükün, papan, ömwöchün, üran me alongun. ");
INSERT INTO chk_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ra uwato ekewe pwölüpwöl mi kapar seni silin ätemwänin sip, pwal silin man mi mürina me ewe chechen lefil, ");
INSERT INTO chk_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ewe pworofel ekewe allük ra nom lon fiti ämwärin me öppüngün, ");
INSERT INTO chk_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ewe chepel me pisekin won meinisin, pwal ewe pilawa mi pin. ");
INSERT INTO chk_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ra pwal uwato ewe lenien atittin mi för seni kolt mi mürina fiti laman kewe lon lenien ömwöchür me sokopaten pisekin meinisin, pwal ewe noppuk seni föün olif fän iten alölön, ");
INSERT INTO chk_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ewe rongen asoren ötüöt seni kolt, ewe löön epit me ewe apach mi pwokus, pwal chechen ewe asamalapen ewe imw mangaku. ");
INSERT INTO chk_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Mürin ra uwato ewe rongen asoren kek seni piras, äpäwunan seni piras, ämwärin me sokopaten pisekin meinisin, ewe sepien töttöl me motongan, ");
INSERT INTO chk_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ewe tit mangaku fän iten ewe leni lükün, üran me alongur, chechen asamalapen ewe leni lükün, selin me chüfölün pwal sokopaten pisekin angangen ewe imwenfel seni mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ra pwal uwato ekewe üf mi ling fän iten ekewe souasor mi angang lon ewe leni mi pin, ikkei ekewe üf mi pin fän iten ewe souasor Aaron me nöün kewe mwän, pwe repwe üföüf le föri ar angangen souasor. ");
INSERT INTO chk_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Iei usun ekewe aramasen Israel ra föri meinisin mine ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Iwe, Moses a ouwasacha ewe angang meinisin o küna pwe ra föri usun mine ewe Samol mi Lapalap a fen allük. Iwe, Moses a afeiöchüür. ");
INSERT INTO chk_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Lon aeuin ränin ewe aeuin maram kopwe aüetä ewe imwenfel seni mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Kopwe anomu lon ewe imwenfel seni mangaku ewe pworun allük, nge kopwe ti ngeni echö cheech. ");
INSERT INTO chk_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Iwe, kopwe uwalong ewe chepel o atettelöchü pisekin won. Mürin kopwe uwalong ewe lenien atittin o isetä laman won. ");
INSERT INTO chk_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Kopwe pwal uwalong ewe rongen asoren ötüöt seni kolt o anomu mwen ewe pworofel. Mürin kopwe eitiuätä chechen asamalapen ewe imwenfel. ");
INSERT INTO chk_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kopwe anomu ewe rongen asoren kek mwen asamalapen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kopwe pwal anomu ewe sepien töttöl lefilen ewe imwenfel seni mangaku me ewe rongen asoren kek o alölöü koluk lon. ");
INSERT INTO chk_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Iwe, kopwe aüetä ewe tit mangaku pwelin ewe leni lükün o eitiuätä chechen asamalapan. ");
INSERT INTO chk_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Mürin kopwe angei ewe löön epit o epiti ewe imwenfel seni mangaku me mettochun lon meinisin, kopwe pwal apini me pisekin lon meinisin. Iwe, epwe pin. ");
INSERT INTO chk_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kopwe pwal epiti ewe rongen asoren kek me pisekin meinisin o apini pwe epwe unusen pin. ");
INSERT INTO chk_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Iwe, kopwe pwal epiti ewe sepien töttöl me motongan o apini. ");
INSERT INTO chk_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Mürin kopwe emwenato Aaron me nöün kewe mwän ren asamalapen ewe imwenfel seni mangaku o atütüür. ");
INSERT INTO chk_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Iwe, kopwe aüföüfa ngeni Aaron ekewe üf mi pin, kopwe pwal epiti o apini, pwe epwe angang ngeniei lon wisen souasor. ");
INSERT INTO chk_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Kopwe pwal emwenato nöün Aaron kewe mwän o aüföüfa ngeniir ekewe sööch mi pwech, ");
INSERT INTO chk_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","kopwe epitiir usun om epiti semer we, pwe repwe angang ngeniei lon wisen souasor. Pun ar kepit epwe atolongeer me mwirimwirir lon wisen souasor seni eu täppin aramas tori eu täppin.” ");
INSERT INTO chk_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Iwe, Moses a föri meinisin usun mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Lon aeuin ränin ewe aeuin maram, lon aruuen ierin ar towu seni Isip ewe imwenfel seni mangaku a kaütä o apinipinila. ");
INSERT INTO chk_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Iwe, Moses a aüetä ewe imwenfel seni mangaku. A fotuki alongun o aüetä papan, a pwal sökalong ömwöchür o aüetä üran. ");
INSERT INTO chk_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Mürin, Moses a emeresala ewe mangaku won ewe imwenfel o isetä pwölüpwölün won, usun mine ewe Samol mi Lapalap a fen allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","A pwal angei ekewe allük o isenirelong lon ewe pworofel, a sökalong ämwärin o isetä öppüngün won. ");
INSERT INTO chk_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Mürin, Moses a uwalong ewe pworofel lon ewe imwenfel seni mangaku o eitiuätä ewe chechen lefil pwe a tiela ewe pworofel, usun ewe Samol mi Lapalap a fen allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Iwe, a iseis ewe chepel peliefengin me lon ewe imwenfel seni mangaku pekiton ewe cheech. ");
INSERT INTO chk_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A pwal isetä ekewe pilawa o atettelöchü me won ewe chepel fän mesen ewe Samol mi Lapalap, usun ewe Samol mi Lapalap a fen allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Iwe, a iseis ewe lenien atittin awenewenen ewe chepel peliörün me lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","A pwal isetä ekewe lamp won o atineer me fän mesen ewe Samol mi Lapalap, usun ewe Samol mi Lapalap a fen allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mürin a iseis ewe rongen asor seni kolt lon ewe imwenfel seni mangaku kükü ngeni ewe cheech ");
INSERT INTO chk_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","o keni apach mi pwokus won, usun ewe Samol mi Lapalap a fen allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Iwe, a pwal eitiuätä chechen asamalapen ewe imwenfel. ");
INSERT INTO chk_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Mürin a iseis ewe rongen asoren kek leasamalapen ewe imwenfel seni mangaku, o eäni asoren kek me asoren mongö won, usun ewe Samol mi Lapalap a fen allük ngeni. ");
INSERT INTO chk_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A pwal iseis ewe sepien töttöl lefilen ewe imwenfel seni mangaku me ewe rongen asor o alölöü koluk lon. ");
INSERT INTO chk_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Iwe, Moses me Aaron me nöün kewe mwän ra talü pöür me pecher lon. ");
INSERT INTO chk_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Lupwen ra tolong lon ewe imwenfel seni mangaku, pwal lupwen ra kan ngeni ewe rongen asor, ra limetiir lon ewe koluk, usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Iwe, a pwal aüetä ewe tit mangaku pwelin ewe leni lükün ewe imwenfel seni mangaku me ewe rongen asor o eitiuätä chechen asamalapen ewe leni lükün. Iei usun Moses a awesi ewe angang. ");
INSERT INTO chk_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Mürin, ewe kuchu a pwölüela ewe imwenfel seni mangaku, nge lingen ewe Samol mi Lapalap a aürala lon. ");
INSERT INTO chk_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Iwe, Moses esap tufichin tolong lon ewe imwenfel seni mangaku, pun ewe kuchu a chök nonom won, nge lingen ewe Samol mi Lapalap a aürala lon. ");
INSERT INTO chk_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Lon unusen ar sai, iteiten fansoun, lupwen ewe kuchu a witä seni won ewe imwenfel seni mangaku, ekewe aramasen Israel ra sopwela ar sai. ");
INSERT INTO chk_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Nge lupwen ewe kuchu a üla won, resap sai tori ewe rän ewe kuchu a witä. ");
INSERT INTO chk_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Pun lon unusen ar sai kuchun ewe Samol mi Lapalap a nom won ewe imwenfel seni mangaku lerän, nge lepwin ekkei a nom lon ewe kuchu. Ei a fis me fän mesen ekewe chon Israel meinisin. ");
INSERT INTO chk_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Iwe, ewe Samol mi Lapalap a kökköri Moses seni lon ewe imw mangaku ia aramas ra churi Kot ie o ngeni ekei allük ");
INSERT INTO chk_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","fän iten ekewe aramasen Israel, pwe repwe apwönüetä, lupwen ra asor: Are eman aramas leimi epwe uwato an asor ngeni ewe Samol mi Lapalap, epwe uwato eman mönün asor seni lein nöün kow are sip are kuuch. ");
INSERT INTO chk_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Are an asor epwe eu asoren kek seni nöün pwiin kow, epwe uwato eman ätemwänin kow esap wor terin ren asamalapen ewe imwenfel seni mangaku, pwe ewe Samol mi Lapalap epwe etiwa. ");
INSERT INTO chk_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Iwe, epwe anomu pöün won möküren ewe mönün asoren kek, nge Kot epwe etiwa an asoren amusamusen an tipis. ");
INSERT INTO chk_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Mürin, epwe niela ewe ätemwänin kow fän mesen ewe Samol mi Lapalap, nge ekewe sousor nöün Aaron kewe mwän repwe uwato ewe cha o uti ngeni pwelin ünükün ewe rongen asor mi nom leasamalapen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Epwe etika silin ewe mönün asor o pökükisietiu fitukan. ");
INSERT INTO chk_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Nge nöün ewe souasor Aaron kewe mwän repwe aküüw ekkei won ewe rongen asor o sonätä mwüch won. ");
INSERT INTO chk_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Iwe, ekewe souasor repwe isenöchüätä kinikinin ewe mönün asor pwal möküran me kirisin won mwüchün ewe ekkei mi nom won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Nge ewe aramas epwe talü ngeni koluk pisekin lon inisin ewe mönün asor me pechen. Mürin, ewe souasor epwe kenala meinisin me won ewe rongen asor pwe eu asoren kek ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Iwe, are an asor epwe eu asoren kek seni nöün sip are kuuch, epwe uwato eman ätemwän esap wor terin. ");
INSERT INTO chk_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Epwe niela ewe mönün asor peliefengin ewe rongen asor fän mesen ewe Samol mi Lapalap, nge ekewe souasor nöün Aaron kewe mwän repwe uti chan ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Iwe, epwe pökükisietiu fitukan, nge ewe souasor epwe isenöchü won mwüchün ewe ekkei mi nom won ewe rongen asor fiti möküran me kirisin. ");
INSERT INTO chk_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Nge ewe aramas epwe talü ngeni koluk pisekin lon inisin me pechen. Iwe, ewe souasor epwe uwato unusan meinisin o kenala me won ewe rongen asor. Pun iei eu asoren kek ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Nge are an asor ngeni ewe Samol mi Lapalap epwe eu asoren kek seni machang, epwe uwato eman lisom ika eman apansüsün lisom. ");
INSERT INTO chk_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Iwe, ewe souasor epwe uwato ewe machang ren ewe rongen asor, epwe ämäräkulu möküran pwe epwe tü o keni me won ewe rongen asor. Nge chan ewe machang epwe asürätiu lepekin ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Mürin, epwe angei chükünükanan me masouan o moneretiu lon ewe lenien falang peliötiuen ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Epwe pwal amwöchü pöükässin o ekis pwiliela, nge esap wesewesen pwilifeseni. Iwe, ewe souasor epwe kenala me won mwüchün ekkein ewe rongen asor. Pun ei eu asoren kek ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Iwe, are eman epwe uwato eu asoren mongö fän iten an asor ngeni ewe Samol mi Lapalap, epwe eäni asor pilawa mi amas o mürina, epwe pwal ninätiu won apüra seni föün olif me apach mi pwokus. ");
INSERT INTO chk_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Iwe, epwe uwato ren ekewe souasor nöün Aaron kewe mwän. Nge ewe souasor epwe tukei ekumwuch seni ewe pilawa mi amas o mürina fiti ewe apüra me unusen ewe apach mi pwokus o kenala me won ewe rongen asor, iei asisilan pwe a asor meinisin. Pun ei eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Nge lusun ewe asoren mongö epwe fän iten Aaron me nöün kewe mwän. Ei kinikinin asor a unusen pin, pun och kinikin seni ewe asoren mongö ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Iwe, are kopwe uwato eu asoren mongö mi um pwe kopwe eäni asor, epwe chök pilawa mi mürina esap wor iis lon mi nofit ngeni apüra, ika sokun pilawa usun nokop esap wor iis lon mi toto ngeni apüra. ");
INSERT INTO chk_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Nge are om asor epwe eu asoren mongö mi furain lon eu furaipan, epwe chök seni pilawa mi mürina esap wor iis lon, epwe pwal nofit ngeni apüra. ");
INSERT INTO chk_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Iwe, kopwe kinikisietiu o ninätiu apüra won, pun eu asoren mongö. ");
INSERT INTO chk_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nge are om asor eu asoren mongö mi kuk lon eu nape, epwe seni pilawa mi mürina o nofit ngeni apüra. ");
INSERT INTO chk_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Iwe, kopwe uwato ren ewe Samol mi Lapalap ewe asoren mongö mi för seni ekei mettoch o ngeni ewe souasor, nge i epwe uwato ren ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Iwe, ewe souasor epwe angei eu kinikin seni ewe asoren mongö, iei asisilan pwe a asor meinisin, o keni me won ewe rongen asor, pun ei eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Nge lusun ewe asoren mongö epwe fän iten Aaron me nöün kewe mwän. Ei kinikinin asor a unusen pin, pun och kinikin seni ewe asoren mongö ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Iwe, kosap uwato ren ewe Samol mi Lapalap asoren mongö mi wor iis lon. Pun kosap kenala pilawa fiti iis me chönün chunen pwe om asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ka tongeni uwato ekei sokun asor ren ewe Samol mi Lapalap pwe om asoren mwen ua, nge kosap keniir won ewe rongen asor, pun resap eu asor mi pwoöch. ");
INSERT INTO chk_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Iwe, om kewe asoren mongö meinisin kopwe saltei, pun salt asisilen ewe pwon lefilom me Kot. Kopwe achu salt ngeni om kewe asor meinisin. ");
INSERT INTO chk_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Lupwen kopwe eäni asoren mongö ngeni ewe Samol mi Lapalap seni mwen uän fotom irä, kopwe eäni asor föün wiich mi fö, repwe pwal üsüs o tüün. ");
INSERT INTO chk_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Iwe, kopwe ninätä apüra won o iseis apach mi pwokus won, pun eu asoren mongö. ");
INSERT INTO chk_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Iwe, ewe souasor epwe keni eu kinikin seni ekewe föün wiich mi üsüs pwal seni ewe apüra, iei asisilan pwe a asor meinisin, epwe pwal keni unusen ewe apach mi pwokus. Pun ei eu asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Iwe, are eman aramas epwe eäni eu asoren kinamwe, epwe eäni asor eman ätemwän ika eman liafefin seni nöün kow, nge epwe chök eäni asor ngeni ewe Samol mi Lapalap eman man esap wor terin. ");
INSERT INTO chk_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Iwe, epwe anomu pöün won möküren an we mönün asor o niela leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. Nge ekewe souasor nöün Aaron kewe mwän repwe uti chan ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Nge seni ewe mönün asoren kinamwe epwe eäni asor won ekkei ngeni ewe Samol mi Lapalap ewe kiris mi pwölüela pisekin lon inisin meinisin, ");
INSERT INTO chk_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ekewe ruoföü föün lon fiti kirisin wor mi kükü ngeni fitukesaran wänüükün pwal mwärekeon ammünün. ");
INSERT INTO chk_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Mürin, nöün Aaron kewe mwän repwe keni me won ewe rongen asor asen ewe asoren kek mi nom won mwüchün ewe ekkei. Ei eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Iwe, are eman aramas epwe eäni eu asoren kinamwe ngeni ewe Samol mi Lapalap seni nöün sip eman ätemwän ika eman liafefin, epwe chök eäni asor eman man esap wor terin. ");
INSERT INTO chk_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Are epwe eäni asor eman sip, epwe uwato fän mesen ewe Samol mi Lapalap, ");
INSERT INTO chk_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","epwe anomu pöün won möküren an we mönün asor o niela mwen ewe imwenfel seni mangaku. Nge nöün Aaron kewe mwän repwe uti chan ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Iwe, seni ewe mönün asoren kinamwe epwe eäni asor won ekkei ngeni ewe Samol mi Lapalap ekei kinikin: kirisin, unusen kirisin mechan, epwe rei kükü ngeni chülapan, ewe kiris mi pwölüela pisekin lon inisin meinisin, ");
INSERT INTO chk_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ekewe ruoföü föün lon fiti kirisin wor mi kükü ngeni fitukesaran wänüükün pwal mwärekeon ammünün. ");
INSERT INTO chk_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Iwe, ewe souasor epwe keni ekei kinikin me won ewe rongen asor, pwe eu asoren mongö ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Nge are epwe eäni asor eman kuuch, epwe uwato fän mesen ewe Samol mi Lapalap, ");
INSERT INTO chk_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","epwe anomu pöün won möküran o niela mwen ewe imwenfel seni mangaku. Nge nöün Aaron kewe mwän repwe uti chan ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Mürin, epwe eäni asor ngeni ewe Samol mi Lapalap seni ewe mönün asor ewe kiris mi pwölüela pisekin lon inisin meinisin, ");
INSERT INTO chk_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ekewe ruoföü föün lon fiti kirisin wor mi kükü ngeni fitukesaran wänüükün pwal mwärekeon ammünün. ");
INSERT INTO chk_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Iwe, ewe souasor epwe keniir won ewe rongen asor pwe eu asoren mongö mi pwoöch. Kirisin ekewe mönün asor meinisin än ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ousap ochoch kiris ika ün cha. Ei epwe eu allük ngenikemi tori feilfeilachök seni eu täppin aramas tori eu täppin ekis meinisin ia oua nom ie. ");
INSERT INTO chk_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","pwe epwe üreni ekewe aramasen Israel: Are eman a tipisin chechengau le föri mine ewe Samol mi Lapalap a allük pwe esap föri, iei usun mine epwe föri: ");
INSERT INTO chk_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Are ewe souasor mi lap a tipis o ren an tipis a atoto tipis won ekewe aramas, epwe uwato ngeni ewe Samol mi Lapalap eman nienifön ätemwänin kow esap wor terin, pwe epwe eäni asor fän iten an tipis. ");
INSERT INTO chk_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Iwe, epwe uwato ewe ätemwänin kow leasamalapen ewe imwenfel seni mangaku, epwe anomu pöün won möküran o niela me fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Mürin, ewe souasor mi lap epwe angei ekis chan ewe ätemwänin kow o uwato lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Epwe atukalong aütün lon ewe cha o äsupu fän fisu ekis seni ewe cha mwen chechen lon ewe leni mi pin fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ewe souasor epwe pwal tofätä ekis seni ewe cha won mächän ewe rongen asoren ötüöt mi nom lon ewe imwenfel seni mangaku fän mesen ewe Samol mi Lapalap. Nge lusun chan ewe ätemwänin kow epwe ninätiu lepopun ewe rongen asoren kek mi nom leasamalapen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Iwe, seni ei asoren tipis epwe angei kirisin ewe ätemwänin kow meinisin, ewe kiris mi pwölüela pisekin lon inisin meinisin, ");
INSERT INTO chk_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ekewe ruoföü föün lon fiti kirisin wor mi kükü ngeni fitukesaran wänüükün pwal mwärekeon ammünün. ");
INSERT INTO chk_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Iwe, ewe souasor epwe keniir won ewe rongen asoren kek, usun chök mine a föri ngeni ewe mönün asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Nge silin ewe ätemwänin kow me fitukan meinisin, pwal möküran me pechen, pisekin lon inisin fiti taran, ");
INSERT INTO chk_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","unusen ewe ätemwänin kow epwe uwawu lon eu leni mi limöch lükün ewe ia ra nonom ie. Iwe, epwe keni won ekkei seni mwüch, ia ra ninala ie ewe falang. ");
INSERT INTO chk_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Iwe, are unusen ewe mwichen aramasen Israel epwe tipisin chechengau, nge resap mefi pwe ra föri mine ewe Samol mi Lapalap a allük ngeniir pwe resap föri, ra atoto tipis wor. ");
INSERT INTO chk_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Nge are ra mefi pwe ra tipis, ewe mwichen aramas epwe emwenato mwen ewe imwenfel seni mangaku eman nienifön ätemwänin kow fän iten asoren tipis. ");
INSERT INTO chk_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Iwe, ekewe souakomwen ewe mwich repwe anomu pöür won möküren ewe ätemwänin kow o niela me fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mürin, ewe souasor mi lap epwe uwato ekis seni chan ewe ätemwänin kow lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Epwe atukalong aütün lon ewe cha o äsupu fän fisu mwen chechen lon ewe leni mi pin fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Iwe, ewe souasor epwe pwal tofätä ekis seni ewe cha won mächän ewe rongen asoren ötüöt mi nom fän mesen ewe Samol mi Lapalap lon ewe imwenfel seni mangaku. Nge lusun ewe cha epwe ninätiu lepopun ewe rongen asoren kek mi nom leasamalapen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Mürin epwe angei kirisin ewe mönün asor meinisin o kenala me won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Usun mine a föri ngeni ewe mönün asoren tipis, iei usun epwe pwal föri ngeni ei ätemwänin kow. Ren ei ewe souasor epwe föri asoren amusamusen tipis fän iten ekewe aramas, pwe ar tipis epwe musala. ");
INSERT INTO chk_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Mürin epwe uwala ewe ätemwänin kow lükün ewe ia ra nonom ie o kenala, usun a kenala ewe ätemwänin kow fän iten an tipis. Iei eu asoren tipis fän iten ewe mwichen aramas. ");
INSERT INTO chk_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Iwe, are eman samol a tipisin chechengau le föri mine an we Kot ewe Samol mi Lapalap a allük ngeni pwe esap föri, a atoto tipis won. ");
INSERT INTO chk_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Iwe, are a mefi pwe a tipis, epwe uwato eman ätemwänin kuuch esap wor terin fän iten an asor. ");
INSERT INTO chk_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Epwe anomu pöün won möküren ewe kuuch o niela me lon ewe leni ia ra ni ie ekewe mönün asoren kek fän mesen ewe Samol mi Lapalap. Iei eu asoren tipis. ");
INSERT INTO chk_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Mürin, ewe souasor epwe angei ekis chan ewe mönün asoren tipis o tofätä won mächän ewe rongen asoren kek, nge lusun ewe cha epwe ninätiu lepopun ewe rongen asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Nge kirisin meinisin epwe kenala me won ewe rongen asor, usun a kenala kirisin ewe mönün asoren kinamwe. Iei usun ewe souasor epwe föri asoren amusamusen tipis fän iten ewe samol, pwe an tipis epwe musala. ");
INSERT INTO chk_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Iwe, are eman me lein ekewe aramas a tipisin chechengau le föri mine ewe Samol mi Lapalap a allük ngeni pwe esap föri, a atoto tipis won. ");
INSERT INTO chk_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nge are a mefi pwe a tipis, epwe uwato eman liafefinin kuuch esap wor terin, pwe an asor fän iten an tipis. ");
INSERT INTO chk_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Epwe anomu pöün won möküren ewe mönün asoren tipis o niela me lon ewe leni ia ra niela ie ekewe mönün asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Mürin, ewe souasor epwe angei ekis chan ewe mönün asoren tipis o tofätä won mächän ewe rongen asoren kek, nge lusun ewe cha epwe ninätiu lepopun ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Mürin, epwe aserala kirisin meinisin, usun a aserala kirisin ekewe mönün asoren kinamwe. Iwe, ewe souasor epwe keni me won ewe rongen asor, pwe ewe Samol mi Lapalap epwe efich pwoon. Iei usun ewe souasor epwe föri asoren amusamusen tipis fän iten ewe aramas, pwe an tipis epwe musala. ");
INSERT INTO chk_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Iwe, are eman aramas a uwato eman sip pwe an asoren tipis, epwe uwato eman liafefin esap wor terin. ");
INSERT INTO chk_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Epwe anomu pöün won möküren ewe mönün asor o niela me lon ewe leni ia ra niela ie ekewe mönün asoren kek, pwe eu asoren tipis. ");
INSERT INTO chk_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Mürin, ewe souasor epwe angei ekis chan ewe mönün asor o tofätä won mächän ewe rongen asoren kek, nge lusun ewe cha epwe ninätiu lepopun ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Iwe, epwe aserala kirisin meinisin, usun a aserala kirisin ewe sip a ninnila fän iten asoren kinamwe. Mürin, ewe souasor epwe kenala ewe kiris won ewe rongen asor asen ewe asoren kek ngeni ewe Samol mi Lapalap. Ren ei ewe souasor epwe föri asoren amusamusen tipis fän iten ewe aramas, pwe an tipis epwe musala. ");
INSERT INTO chk_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Are eman a kökkö me ren ewe soukapwüng pwe epwe pwärätä lon kapwüng mine a küna ika rongorong, nge esap mochen pwärätä, ätewe a tipis. ");
INSERT INTO chk_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Nge are eman a atapa och mettoch mi limengau, ese lifilifil ika inisin eman manmwacho mi limengau men mä ika inisin eman manfesir mi limengau men mä ika inisin eman mantötö mi limengau men mä, inamwo ika esap mefi, a chök limengau o tipis ren. ");
INSERT INTO chk_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Iwe, are eman a atapa limengauen eman aramas, nge esap mefi, ese lifilifil met sokun limengau a atapa o limengau ren, are epwe mefi, lon ewe otun epwe tipis. ");
INSERT INTO chk_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Nge are eman a chiekai le akapel, nge esap ekieki usun, ese lifilifil met sokun akapel eman aramas epwe chiekai won mine a ngau ika öch, are epwe mefi, lon ewe otun epwe tipis. ");
INSERT INTO chk_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Iwe, are eman aramas a tipis ren och lein ekei föför, epwe pwärätä an tipis ");
INSERT INTO chk_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","o uwato ren ewe Samol mi Lapalap fän iten an tipis eman liafefinin sip ika kuuch seni nöün man pwe an asoren tipis. Nge ewe souasor epwe föri asoren amusamusen tipis fän iten ewe aramas. ");
INSERT INTO chk_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Nge are ewe aramas esap tufich ngeni an epwe uwato eman sip, epwe chök uwato ren ewe Samol mi Lapalap fän iten an asoren tipis ruoman lisom ika ruoman apansüsün lisom. Eman lisom epwe fän iten asoren tipis, nge eman fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Iwe, epwe uweereto ren ewe souasor, nge ätewe epwe akomwen eäni asor ewe eman fän iten asoren tipis. Epwe ämäräkulu möküran, nge esap wesewesen tünüöla. ");
INSERT INTO chk_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Mürin epwe äsupu ekis chan ewe mönün asoren tipis ngeni lepekin ewe rongen asor, nge lusun ewe cha epwe asupwätiu lepopun ewe rongen asor. Iei eu asoren tipis. ");
INSERT INTO chk_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Mürin epwe eäni asor ewe aruomanün fän iten asoren kek lon pwüngün asoren kek. Iei usun ewe souasor epwe föri asoren amusamusen tipis fän iten ewe aramas. Iwe, an tipis epwe musala. ");
INSERT INTO chk_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Nge are ewe aramas esap tufich ngeni an epwe uwato ruoman lisom ika ruoman apansüsün lisom, epwe chök uwato ruu paun pilawa mi amas o mürina fän iten asoren an tipis. Iwe, esap nofiti ngeni apüra seni föün olif, esap pwal ninätä apach mi pwokus won, pun eu asoren tipis. ");
INSERT INTO chk_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Iwe, epwe uwato ren ewe souasor, nge ewe souasor epwe tukei ekumwuch seni, iei asisilan pwe a asor meinisin, o kenala me won ewe rongen asor asen ewe asoren kek ngeni ewe Samol mi Lapalap. Iei eu asoren amusamusen tipis. ");
INSERT INTO chk_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Iei usun ewe souasor epwe föri asoren amusamusen tipis fän iten än ewe aramas tipis ren eu me eu lein ekewe föför, pwe epwe musala. Nge lusun ewe asor epwe än ewe souasor, usun a fis ren ewe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük: ");
INSERT INTO chk_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Are eman aramas esap allükülük o tipisin chechengau ren an tümwününgau ngeni mettoch mi pin me ren ewe Samol mi Lapalap, epwe uwato eman ätemwänin sip esap wor terin, pwe an asoren pupungau ngeni ewe Samol mi Lapalap. Nge ükükün liwininin ewe mönün asor kopwe aükük won aüchean föün silifer mi alongolong won ewe kilo ra aea lon ewe imw mi pin. Iei eu asoren pupungau. ");
INSERT INTO chk_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Iwe, epwe liwinietiu ekewe mettoch mi pin a tümwününgau ngeni, nge epwe pwal apacha ngeni eu lelimu o ngeni ewe souasor. Ewe souasor epwe föri asoren pupungau ren ewe ätemwänin sip pwe amusamusen än ewe aramas tipis, pwe epwe musala. ");
INSERT INTO chk_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Iwe, are eman a tipis ren an föri mine ewe Samol mi Lapalap a allük ngeni pwe esap föri, inamwo ika esap mefi, a chök tipis, nge an föför esepwüng a nonom won. ");
INSERT INTO chk_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Iwe, epwe uwato ren ewe souasor eman ätemwänin sip esap wor terin. Nge liwinin ewe mönün asor me reöm epwe usun chök liwinin ewe mönün asoren pupungau. Iwe, ewe souasor epwe föri asoren amusamusen tipis fän iten än ewe aramas föför a chechengau ren, pwe epwe musala. ");
INSERT INTO chk_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Iei eu asoren pupungau, pun ewe aramas a tipis ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük: ");
INSERT INTO chk_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Are eman a tipis ngeni ewe Samol mi Lapalap ren an atupu chon arun, pun esap mochen aliwini mine a wisen tütümwünü are amwöchü, ika ren an soläni och, ika ren an ariaföüü chon arun, ");
INSERT INTO chk_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","are a küna och mine a pöütüla, nge a chofana won, are a akapelmwäl won och ika a föri sokopaten tipis aramas ra föri, iei usun mine epwe föri: ");
INSERT INTO chk_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Are eman a tipis, epwe aliwini mine a soläni, are mine a angei seni aramas fän pöchökül, epwe pwal aliwini mine eman a awisa pwe epwe tütümwünü, are mine a pöütüla, nge a küna, ");
INSERT INTO chk_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","pwal ekewe mettoch meinisin a akapelmwäl won. Iwe, epwe aliwini unusan, nge epwe pwal apacha ngeni eu lelimu o ngeni mine än ewe mettoch lon ewe ränin a eäni an asoren pupungau. ");
INSERT INTO chk_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Iwe, epwe uwato ren ewe souasor eman ätemwänin sip esap wor terin, pwe an asoren pupungau ngeni ewe Samol mi Lapalap. Nge liwinin ewe mönün asor me reöm epwe usun chök liwinin ewe mönün asoren pupungau. ");
INSERT INTO chk_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Iwe, ewe souasor epwe föri asoren amusamusen tipis fän mesen ewe Samol mi Lapalap fän iten ewe aramas. Iwe, an kewe tipis meinisin a föri repwe musala. ");
INSERT INTO chk_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","pwe epwe ngeni Aaron me nöün kewe mwän ekei allükün asoren kek: Ewe asoren kek epwe nom won ewe rongen asor unusen pwin tori lesosor, nge ekkeiin won epwe chök kükü. ");
INSERT INTO chk_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Iwe, ewe souasor epwe üföüfolong üfan mi pwechepwech o aealong an raueses mi pwechepwech. Mürin epwe tukei falangen ekkeiin ewe asoren kek mi nom won ewe rongen asor o iseis ünükün. ");
INSERT INTO chk_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Mürin epwe siwili üfan kewe o uwawu ewe falang lon eu leni mi limöch lükün ewe ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Iwe, ewe ekkei won ewe rongen asor epwe chök kükü, nge esap fokun kunula. Iteiten lesosor ewe souasor epwe sosoni ewe ekkei, epwe pwal atettelöchü ewe mönün asoren kek o kenala kirisin ekewe mönün asoren kinamwe won. ");
INSERT INTO chk_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Iwe, ekkei epwe chök kükü fochofoch won ewe rongen asor, esap fokun tongeni kunula. ");
INSERT INTO chk_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Nge iei allükün ewe asoren mongö: Nöün Aaron kewe mwän repwe uwato ewe asoren mongö ngeni ewe Samol mi Lapalap mwen ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Iwe, eman leir epwe angei ekumwuch pilawa mi amas o mürina seni ewe asoren mongö me ewe apüra seni föün olif, pwal unusen ewe apach mi pwokus mi nom won, o kenala me won ewe rongen asor, iei asisilan pwe a asor meinisin. Iei eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Nge lusun ewe asoren mongö Aaron me nöün kewe mwän repwe mongö. Iwe, repwe mongö ewe asoren mongö esap wor iis lon me lon eu leni mi pin lon ewe leni lükün ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Iwe, resap tongeni umuni ewe pilawa fiti iis. Ewe Samol mi Lapalap a ngeniir pwe inetir seni ewe asoren mongö. Iei eu asor mi unusen pin usun chök ewe asoren tipis me ewe asoren pupungau. ");
INSERT INTO chk_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Iteiten mwän me lein ekewe mwirimwirin Aaron repwe mongö seni. Iei inetir seni ewe asor ngeni ewe Samol mi Lapalap, seni eu täppin aramas tori eu täppin. Esap fokun wor eman lükür epwe atapa ekewe asor, pun iö a atapa epwe feiengau ren pinin. ");
INSERT INTO chk_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük ");
INSERT INTO chk_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","fän iten afeiöchün eman souasor i mwirimwirin Aaron: Lon ewe rän, lupwen eman leir a kepit, epwe eäni asor ngeni ewe Samol mi Lapalap ruu paun pilawa mi amas o mürina usun chök ükükün ewe asoren mongö ra eäni iteiten rän. Esop seni ewe asor epwe eäni asor lesosor, nge esop lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Iwe, epwe nokopuni fiti apüra lon eu furaipan, epwe aipwötü o kinikisietiu usun eu asoren mongö. Mürin epwe eäni asor pwe epwe eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ewe souasor mi kepit me lein nöün Aaron kewe mwän pwe epwe siwili Aaron, epwe eäni ei asor ngeni ewe Samol mi Lapalap fansoun meinisin. Iwe, unusen ei asor epwe kek. ");
INSERT INTO chk_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Iteiten än eman souasor asoren mongö epwe kek meinisin. Esap wor eman epwe tongeni mongö seni. ");
INSERT INTO chk_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Iwe, ewe Samol mi Lapalap a pwal kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","pwe epwe ngeni Aaron me nöün kewe mwän ekei allükün asoren tipis: Lon ewe leni ia ra niela ie ewe mönün asoren kek repwe pwal niela ie ewe mönün asoren tipis fän mesen ewe Samol mi Lapalap. Ei asor a unusen pin. ");
INSERT INTO chk_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ewe souasor mi föri ei angangen asoren tipis epwe pwal mongö seni ewe asor lon ewe leni mi pin lükün ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Iwe, iö a atapa fituken ewe mönün asor epwe feiengau ren pinin. Nge lupwen chan ewe mönün asor a sükiti echö üf, kopwe limeti me lon eu leni mi pin. ");
INSERT INTO chk_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Are fituken ewe mönün asor a kuk lon eu sepi mi för seni pwül, ewe sepi epwe ömmök. Nge are a kuk lon eu sepi mi för seni piras, ewe sepi epwe töttölöch o chichi lon koluk. ");
INSERT INTO chk_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Iteiten mwän mi wiseni ewe wisen souasor ra tongeni mongö seni ewe asor. Ei asor a unusen pin. ");
INSERT INTO chk_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Nge resap tongeni mongö seni ewe sokun asoren tipis ra uwala chan lon ewe imwenfel seni mangaku, pwe repwe föri asoren amusamusen tipis lon ewe leni mi pin. Ei asor epwe kekila. ");
INSERT INTO chk_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Iwe, iei allükün ewe asoren pupungau mi unusen pin: ");
INSERT INTO chk_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Lon ewe leni ia ra niela ie ewe mönün asoren kek, repwe pwal niela ie ewe mönün asoren pupungau, nge chan ewe mönün asor epwe utut ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ewe souasor epwe eäni asor kirisin ewe mönün asor meinisin: Kirisin mechan pwal ewe kiris mi pwölüela pisekin lon inisin, ");
INSERT INTO chk_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ekewe ruoföü föün lon fiti kirisin wor mi kükü ngeni fitukesaran wänüükün, pwal mwärekeon ammünün. ");
INSERT INTO chk_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Iwe, ewe souasor epwe kenirela won ewe rongen asor, pwe eu asor ngeni ewe Samol mi Lapalap. Iei eu asoren pupungau. ");
INSERT INTO chk_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Iteiten ekewe mwän mi wiseni ewe wisen souasor ra tongeni mongö seni ewe asor. Nge repwe chök mongö lon eu leni mi pin, pun eu asor mi unusen pin. ");
INSERT INTO chk_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Mi wor eu chök allükün asoren pupungau me asoren tipis: Ewe souasor mi föri ewe asoren amusamusen tipis epwe eäni fituken ewe mönün asor. ");
INSERT INTO chk_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Iwe, ewe souasor mi föri än ekewe aramas asoren kek epwe eäni silin ewe mönün asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Iteiten asoren mongö mi um pwal meinisin mine a kuk lon nape ika furain lon furaipan epwe fän iten ewe souasor mi föri ewe angangen asor. ");
INSERT INTO chk_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Nge ekewe asoren mongö resap mwot, ese lifilifil ika mi nofit ngeni apüra ika resap nofit, repwe fän iten nöün Aaron kewe mwän meinisin, epwe inetöchfengen lefiler. ");
INSERT INTO chk_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Iwe, iei allükün ekewe asoren kinamwe aramas ra eäni ngeni ewe Samol mi Lapalap: ");
INSERT INTO chk_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Are eman a eäni ewe asoren kinamwe pwe asoren kilisou, epwe uwato an mönün asor o achu ngeni pilawa esap wor iis lon mi nofit ngeni apüra, pwal sokun pilawa usun nokop esap wor iis lon mi toto ngeni apüra, pwal pilawa mi mürina o nofitöch ngeni apüra. ");
INSERT INTO chk_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Nge lupwen a eäni an asoren kinamwe fän iten kilisou, epwe pwal uwato pilawa mi wor iis lon. ");
INSERT INTO chk_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Iwe, epwe angei eföü pilawa seni iteiten ewe sokun asoren mongö o eäni asor ngeni ewe Samol mi Lapalap. Iei än ewe souasor mi uti chan ewe mönün asoren kinamwe ngeni ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nge ewe aramas epwe ocheela fituken an mönün asoren kinamwe fän iten kilisou lon ewe chök ränin a asor. Esap tongeni likiti och tori lesosor. ");
INSERT INTO chk_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Iwe, are ewe aramas a eäni an asor fän iten pwon ika seni püsin letipan, epwe ochei fituken ewe mönün asor lon ewe rän a asor, nge lusun a pwal tongeni ochei sorotan. ");
INSERT INTO chk_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nge lusun fituken ewe mönün asor mi chüen nom tori aülüngatin rän epwe kek. ");
INSERT INTO chk_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Iwe, are eman a ochei fituken ewe mönün asoren kinamwe lon aülüngatin rän, ewe asor esap tiw me ren Kot, esap pwal wor lomotan ngeni ätewe mi eäni, pun a limengau. Nge ätewe mi ochei ewe fituk epwe mwärei an tipis. ");
INSERT INTO chk_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Esap wor eman epwe ochoch fituk mi torii och mettoch mi limengau, epwe chök kek. Chokewe meinisin mi limöch ra tongeni ochei fituken ewe mönün asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Nge are eman aramas mi nom lon och limengau a ochei fituken ewe mönün asoren kinamwe än ewe Samol mi Lapalap, ewe aramas epwe käriwu seni aramasan. ");
INSERT INTO chk_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Iwe, are eman a atapa och mettoch mi limengau, ese lifilifil ika eman aramas mi limengau ika eman man mi limengau ika och sokun mettoch mi anioput, nge mürin a ochei fituken ewe mönün asoren kinamwe än ewe Samol mi Lapalap, ätewe epwe käriwu seni aramasan. ");
INSERT INTO chk_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük ");
INSERT INTO chk_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","fän iten ekewe aramasen Israel: Ousap ochoch kirisin kow ika sip ika kuuch. ");
INSERT INTO chk_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Iwe, kirisin eman man mi püsin mäla ika kirisin eman mi tatakis ren manmwacho oua tongeni aea fän iten och, nge ousap fokun tongeni ochei. ");
INSERT INTO chk_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Iteiten eman me eman aramas mi ochei kirisin ekewe man ra eäni asor won ekkei ngeni ewe Samol mi Lapalap epwe käriwu seni aramasan. ");
INSERT INTO chk_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ekis meinisin ia oua nonom ie ousap fokun ün cha, ese lifilifil ika chan mansüsü ika chan man. ");
INSERT INTO chk_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Iteiten eman me eman aramas mi ün cha epwe käriwu seni aramasan. ");
INSERT INTO chk_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Iwe, ewe Samol mi Lapalap a pwal ngeni Moses ekei allük ");
INSERT INTO chk_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","fän iten ekewe aramasen Israel: Eman mi eäni an asoren kinamwe ngeni ewe Samol mi Lapalap epwe uwato eu kinikin pwe an asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Epwe püsin uwato ekewe asor ngeni ewe Samol mi Lapalap. Iwe, epwe uwato kirisin ewe mönün asor pwal leupwan, pwe ewe leupw epwe assaw fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Iwe, ewe souasor epwe kenala ewe kiris won ewe rongen asor, nge leupwen ewe mönün asor epwe fän iten Aaron me nöün kewe mwän. ");
INSERT INTO chk_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Oupwe ngeni ewe souasor pelifichin pechen ämi mönün asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Iö me lein nöün Aaron kewe mwän a eäni asor chan ewe mönün asoren kinamwe pwal kirisin, i epwe eäni pelifichin pechen ewe mönün asor pwe ina inetin. ");
INSERT INTO chk_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pun üa angei seni än ekewe aramasen Israel mönün asoren kinamwe leupwan mi assaw pwal pechen o ngeni ewe souasor Aaron me nöün kewe mwän. Iei ekewe kinikin ekewe aramasen Israel repwe ngeni ekewe souasor fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Iei inetin Aaron me nöün kewe mwän seni ekewe asor ngeni ewe Samol mi Lapalap, mi apinipin fän iter lon ewe ränin ar tolong lon wisen souasor. ");
INSERT INTO chk_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ewe Samol mi Lapalap a allük pwe ekewe aramasen Israel repwe ngeniir inetir kei lon ewe ränin ra kepit, pwe wiser fansoun meinisin seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Iwe, iei allükün ewe asoren kek, ewe asoren mongö, ewe asoren tipis, ewe asoren pupungau, ewe asoren apinipin me ewe asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ikei ekewe allük ewe Samol mi Lapalap a ngeni Moses me won ewe chuk Sinai lon ewe ränin a allük ngeni ekewe aramasen Israel pwe repwe uwato ar asor ngeni lon ewe fanüapön Sinai. ");
INSERT INTO chk_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Kopwe emwenato Aaron me nöün kewe mwän leasamalapen ewe imw mangaku ia aramas ra churiei ie, kopwe pwal uwei ekewe üf, ewe löön epit, ewe nienifön ätemwänin kow fän iten asoren tipis me ekewe ruoman ätemwänin sip, pwal ewe chükün pilawa esap wor iis lon. ");
INSERT INTO chk_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Mürin kopwe pwal amwichafengeni ekewe aramas meinisin ikenan.” ");
INSERT INTO chk_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Iwe, Moses a föri usun mine ewe Samol mi Lapalap a allük ngeni o amwichafengeni ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Iwe, Moses a üreni ekewe aramas, “Iei usun mine ewe Samol mi Lapalap a allük ngeniei pwe üpwe föri.” ");
INSERT INTO chk_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mürin, Moses a emwenato Aaron me nöün kewe mwän o atütüür. ");
INSERT INTO chk_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A aüföüfa ngeni Aaron ewe söch o peliti ngeni ewe pelit, a pwal aüföüfa ngeni ewe owokot me ewe üf itan efot o ri ngeni ririn ewe efot mi türmürina. ");
INSERT INTO chk_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Iwe, a pachetä won ewe chechen leupw o uwalong ewe Urim me ewe Tumim lon . ");
INSERT INTO chk_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A pwal aimweimwa ngeni Aaron ewe akkaw o rietä won eten mesan ewe kolt mi chöpöp, ewe mwärämwär mi pin, usun ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mürin, Moses a angei ewe löön epit o epiti ngeni ewe imw mangaku ia aramas ra churi Kot ie, me meinisin mine a nom lon, a pwal apiniir. ");
INSERT INTO chk_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Iwe, a angei ekis seni ewe löön epit o äsupu fän fisu ngeni ewe rongen asor, a epiti ewe rongen asor me pisekin meinisin pwal ewe lenien töttöl me motongan, pwe repwe pin. ");
INSERT INTO chk_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","A pwal ninätiu ekis seni ewe löön epit won möküren Aaron o epiti pwe epwe pin. ");
INSERT INTO chk_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Mürin, Moses a emwenato nöün Aaron kewe mwän, a aüföüfa ngeniir ekewe söch o peliti ngeniir ekewe pelit, a pwal aimweimwa ngeniir ekewe akkaw, usun ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mürin, Moses a emwenato ewe ätemwänin kow fän iten asoren tipis, nge Aaron me nöün kewe mwän ra isetä pöür won möküran. ");
INSERT INTO chk_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Iwe, Moses a niela ewe mönün asor, a angei ekis chan o aea pöün le tofi ewe cha ngeni mächän ewe rongen asor me fofoch, pwe epwe alimöchü ewe rongen asor. Nge lusun ewe cha a ninätiu lepopun ewe rongen asor o apini, pwe epwe föri asoren amusamusen limengauen ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mürin, Moses a angei kirisin pisekin lon inisin ewe mönün asor me mwärekeon ammünün, pwal ekewe ruoföü föün lon fiti kirisir, o kenirela won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Nge silin ewe ätemwänin kow me fitukan pwal taran a kenirela lükün ewe ia ra nonom ie, usun ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Mürin, Moses a emwenato ewe ätemwänin sip fän iten asoren kek. Nge Aaron me nöün kewe mwän ra isetä pöür won möküran. ");
INSERT INTO chk_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Iwe, Moses a niela ewe ätemwänin sip o uti chan ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Mürin a kinikisietiu fituken ewe ätemwänin sip o kenala möküran me ekewe kinikin pwal kirisin. ");
INSERT INTO chk_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Iwe, a talü ekewe pisekin lon inisin me pechen ngeni koluk o kenala unusen ewe ätemwänin sip won ewe rongen asor pwe eu asoren kek ngeni ewe Samol mi Lapalap a efich pwoon. Iei usun ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Mürin, Moses a pwal emwenato ewe aruomanün ätemwänin sip fän iten afeiöchün ekewe souasor. Nge Aaron me nöün kewe mwän ra isetä pöür won möküran. ");
INSERT INTO chk_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Iwe, Moses a niela ewe ätemwänin sip, a angei ekis chan o tofi ngeni emin fän pelifichin selingen Aaron, pwal ngeni aütülapen pelifichin pöün me pechen. ");
INSERT INTO chk_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mürin, Moses a pwal emwenato nöün Aaron kewe mwän. Iwe, a tofi ekis ewe cha ngeni emin fän pelifichin selinger pwal ngeni aütülapen pelifichin pöür me pecher. Nge lusun ewe cha a uti ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Iwe, a angei kirisin ewe mönün asor, kirisin mechan me kirisin won pisekin lon inisin meinisin, mwärekeon ammünün pwal ekewe ruoföü föün lon fiti kirisir me pelifichin pechen. ");
INSERT INTO chk_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","A pwal angei eföü pilawa seni lon chükün ewe pilawa esap wor iis lon mi nom fän mesen ewe Samol mi Lapalap, pwal eföü pilawa mi nofitfengen me apüra, me echö nokop, o iseniir won kirisin ewe mönün asor pwal won pelifichin pechen. ");
INSERT INTO chk_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Iwe, ekei mettoch meinisin Moses a isenalong lepöün Aaron me nöün kewe mwän, nge ir ra assawerela fän mesen ewe Samol mi Lapalap pwe eu asoren assaw. ");
INSERT INTO chk_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mürin, Moses a angei ekei mettoch seni lepöür o kenirela won ewe rongen asor fiti ewe asoren kek pwe eu asoren afeiöch ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Iwe, Moses a pwal angei leupwen ewe mönün asor o assawa pwe eu asoren assaw fän mesen ewe Samol mi Lapalap. Iei inetin Moses me won ewe ätemwänin sip, ewe asoren afeiöch. Moses a föri meinisin mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mürin, Moses a angei ekis seni ewe löön epit me ekis ewe cha mi nom won ewe rongen asor o äsupu ngeni Aaron me üfan, pwal ngeni nöün kewe mwän me üfer. Iei usun a apini Aaron me nöün kewe mwän me üfer. ");
INSERT INTO chk_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Iwe, Moses a üreni Aaron me nöün kewe mwän, “Oupwe kuku ewe fituk leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. Ikenan oupwe pwal ochei ewe fituk o mongö ewe pilawa mi nom lon ewe chükün asoren afeiöch. Pun iei usun Kot a allük ngeniei pwe oupwe föri. ");
INSERT INTO chk_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Nge lusun ewe fituk me ewe pilawa oupwe kenala. ");
INSERT INTO chk_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Iwe, ousap towu lükün asamalapen ewe imwenfel seni mangaku ükükün fisu rän, tori repwe wesöchüla ränin afeiöchümi. Pun angangen afeiöchümi epwe fis lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ewe Samol mi Lapalap a allük pwe epwe fis asoren amusamusen tipis fän itemi, usun a fen fis ikenai. ");
INSERT INTO chk_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Iwe, oupwe nonom leasamalapen ewe imwenfel seni mangaku lerän me lepwin lon ükükün fisu rän, pwe oupwe föri mine ewe Samol mi Lapalap a awisa ngenikemi pwe ousap mäla. Pun iei usun Kot a allük ngeniei.” ");
INSERT INTO chk_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Iwe, Aaron me nöün kewe mwän ra föri ekewe mettoch meinisin usun mine ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Iwe, wesin ekewe ränin afeiöch, Moses a köri Aaron me nöün kewe mwän pwal ekewe souakomwen Israel. ");
INSERT INTO chk_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Iwe, a üreni Aaron, “Kopwe angei eman nienifön ätemwänin kow fän iten asoren tipis, pwal eman ätemwänin sip fän iten asoren kek, nge esap wor terir. Iwe, kopwe eäniir asor fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Mürin kopwe üreni ekewe aramasen Israel: Oupwe angei eman ätemwänin kuuch fän iten asoren tipis, pwal eman nienifön kow me eman lam fan iten asoren kek, nge ir me ruoman eu ierir, esap pwal wor terir. ");
INSERT INTO chk_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Oupwe pwal angei eman ätemwänin kow me eman ätemwänin sip fän iten asoren kinamwe o eäniir asor fän mesen ewe Samol mi Lapalap fiti eu asoren mongö mi nofit ngeni apüra, pun ikenai ewe Samol mi Lapalap epwe pwä ngenikemi.” ");
INSERT INTO chk_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Iwe, ra uwato mwen ewe imwenfel seni mangaku meinisin mine Moses a allük ngeniir. Nge ekewe aramas meinisin ra kaneto o ütä fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Iwe, Moses a apasa, “Iei usun mine ewe Samol mi Lapalap a allük pwe oupwe föri, pwe lingen ewe Samol mi Lapalap epwe pwä ngenikemi.” ");
INSERT INTO chk_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mürin, Moses a üreni Aaron, “Kopwe kan ngeni ewe rongen asor o eäni om asoren tipis me om asoren kek, pwe kopwe föri asoren amusamusen tipis fän itom me ekewe aramas. Kopwe pwal eäni ewe asor fän iten ekewe aramas o föri asoren amusamusen ar tipis, usun ewe Samol mi Lapalap a fen allük.” ");
INSERT INTO chk_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Iwe, Aaron a kan ngeni ewe rongen asor o niela ewe nienifön ätemwänin kow, pwe epwe eäni asoren tipis fän püsin itan. ");
INSERT INTO chk_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Nge nöün Aaron kewe mwän ra uwato chan ewe mönün asor ren. Iwe, Aaron a otukalong aütün lon ewe cha o tofi ngeni mächän ewe rongen asor, nge lusun a ninätiu lepopun ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Iwe, kirisin ewe mönün asoren tipis me ekewe föün lon pwal mwärekeon ammünün a kenirela won ewe rongen asor, usun ewe Samol mi Lapalap a fen allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nge fituken ewe mönün asor me silin a kenirela lükün ewe ia aramas ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Mürin, Aaron a niela an we mönün asoren kek. Iwe, nöün Aaron kewe mwän ra uwato chan ewe mönün asor ren, nge Aaron a uti ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ra pwal ngeni eu me eu kinikinin ewe mönün asoren kek pwal möküran, nge Aaron a kenirela won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Iwe, a talü pisekin lon inisin me pechen o kenirela fiti ewe asoren kek won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Mürin, Aaron a uwato än ekewe aramas asor. Iwe, a angei ewe ätemwänin kuuch pwe asoren tipis fän iten ekewe aramas, o niela. Iwe, a föri angangen asoren tipis, usun chök ewe aeuin asoren tipis a föri fän püsin itan. ");
INSERT INTO chk_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","A pwal uwato ewe mönün asoren kek o eäni asor lon pwüngün angangen allükün. ");
INSERT INTO chk_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Iwe, a pwal uwato ewe asoren mongö, a angei ekumwuch seni o keni me won ewe rongen asor pach ngeni ewe asoren kek mi fis iteiten rän. ");
INSERT INTO chk_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Mürin, Aaron a pwal niela ewe ätemwänin kow me ewe ätemwänin sip pwe asoren kinamwe fän iten ekewe aramas. Iwe, nöün Aaron kewe mwän ra uwato chan ekewe mönün asor ren, nge Aaron a uti ngeni pwelin ünükün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Iwe, ra angei kirisin ewe ätemwänin kow me kirisin ewe ätemwänin sip, iei ewe mechan mi kiris echök, ewe kiris mi pwölüela pisekin lon inisir, ekewe föün lor me mwärekeon ammünür, ");
INSERT INTO chk_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","o iseis meinisin won leupwen ekewe mönün asor. Mürin Aaron a angei ewe kiris o kenala won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Nge ekewe leupwan me pelifichin pechen, Aaron a assawa pwe eu asoren assaw fän mesen ewe Samol mi Lapalap, pun iei usun Moses a fen allük. ");
INSERT INTO chk_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Iwe, wesin än Aaron eäni ekewe asoren tipis me asoren kek pwal asoren kinamwe, a aitiela pöün won ekewe aramas o afeiöchüür. Mürin a feitiu seni ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mürin, Moses me Aaron ra tolong lon ewe imw mangaku ia aramas ra churi Kot ie. Nge lupwen ra towu, ra afeiöchü ekewe aramas. Iwe, lingen ewe Samol mi Lapalap a pwä ngeni ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Iwe, ewe Samol mi Lapalap a tinato ekkei o kenala ewe asoren kek me ewe kiris mi nom won ewe rongen asor. Nge lupwen ekewe aramas meinisin ra küna, ra mweireir ren ar pwapwa o chapetiu lepwül. ");
INSERT INTO chk_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Iwe, nöün Aaron kewe mwän iter Natap me Apihu ra angei en me an sepien asoren ötüöt, ra uwalong ekkei lon o iseis apach mi pwokus won. Nge ei asor esap pin fän mesen ewe Samol mi Lapalap, pun eu sokun asor Kot esap allük ngeniir. ");
INSERT INTO chk_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Iwe, ewe Samol mi Lapalap a tinato ekkei o kenirela pwe ra mäla fän mesan. ");
INSERT INTO chk_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mürin, Moses a üreni Aaron, “Iei usun wewen mine ewe Samol mi Lapalap a apasa: Üpwe pwärätä pwe ngang üa pin me lein chokewe ra kan ngeniei, nge üpwe pwal alinga ai ling fän mesen aramas meinisin.” Iwe, Aaron a chök fanafanala. ");
INSERT INTO chk_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mürin, Moses a körato Misael me Elsafan nöün Ussiel mwän, nge Ussiel pwin semen Aaron. Iwe, a üreniir, “Oupwe kaneto o ekiela pwimi seni lon ewe imwenfel seni mangaku, pwe oupwe ekirewu lükün ewe ia aramas ra nonom ie.” ");
INSERT INTO chk_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Iwe, ra feito o ekirewu lükün ewe ia aramas ra nonom ie, usun Moses a apasa, nge ekewe somä ra chüen üföüf üfer üfen souasor. ");
INSERT INTO chk_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mürin, Moses a üreni Aaron me nöün kewe mwän iter Eleasar me Itamar, “Ousap atorongauei möküremi, ousap pwal kamwei üfemi pwe asisilen ämi letipeta, pwe ousap mäla, nge ewe Samol mi Lapalap esap pwal song ngeni unusen ewe mwichen aramas. Nge pwimi ekewe chon Israel meinisin repwe kechüeiti afeiengauen ewe kar, ewe Samol mi Lapalap a afisätä. ");
INSERT INTO chk_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ousap towu seni leasamalapen ewe imwenfel seni mangaku, pwe ousap mäla. Pun än ewe Samol mi Lapalap löön epit a nonom womi.” Iwe, ra föri usun mine Moses a kapas ngeniir. ");
INSERT INTO chk_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Iwe, ewe Samol mi Lapalap a kapas ngeni Aaron, ");
INSERT INTO chk_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“En me noum kana mwän ousap ünümi wain are sakau mi pwichikar, lupwen oupwe tolong lon ewe imw mangaku ia aramas ra churiei ie, pwe ousap mäla. Iei eu allük esemwüch ngenikemi me mwirimwirimi kana, seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Oupwe alefila lefilen mettoch mi pin me mettoch resap pin, pwal lefilen mettoch mi limengau me mettoch mi limöch. ");
INSERT INTO chk_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Oupwe pwal aiöü ngeni ekewe aramasen Israel ekewe allük meinisin ngang ewe Samol mi Lapalap üa ngeni Moses pwe epwe aiti ngeniir.” ");
INSERT INTO chk_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Iwe, Moses a üreni Aaron me nöün kewe mwän mi chüen manau iter Eleasar me Itamar, “Oupwe angei ewe asoren mongö lusun ewe asor won ekkei ngeni ewe Samol mi Lapalap, pwe oupwe mongö ewe pilawa esap wor iis lon lükün ewe rongen asor. Pun ei asor a unusen pin. ");
INSERT INTO chk_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Oupwe mongö ei asor lon eu leni mi pin, pun iei inetum me inetin noum kewe mwän seni ewe asor ngeni ewe Samol mi Lapalap. Pun iei usun Kot a allük ngeniei. ");
INSERT INTO chk_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nge en me noum kewe mwän me fefin oupwe ochoch leupwen ewe mönün asor mi assaw pwal pechen lon sokun leni mi limöch. Pun iei inetum me inetin noum kewe mwän seni än ekewe aramasen Israel asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Iwe, pechen ewe mönün asor pwal leupwan mi assaw repwe uweefengenireto me kirisin ekewe asor, pwe repwe assawa fän mesen ewe Samol mi Lapalap, pun eu asoren assaw. Iwe, ei epwe inetum me inetin noum kewe pwe wisemi fansoun meinisin, usun ewe Samol mi Lapalap a fen allük.” ");
INSERT INTO chk_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Iwe, Moses a ais tichik usun mine ra föri ngeni ewe ätemwänin kuuch, ewe mönün asoren tipis. Nge a pwä pwe a kekila. Iwe, Moses a song ngeni Eleasar me Itamar, nöün Aaron kewe mwän mi chüen manau, a pwal üreniir, ");
INSERT INTO chk_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Pwota ousap ochoch fituken ewe mönün asoren tipis lon ewe leni mi pin? Pun ei mettoch a unusen pin, a ainet ngenikemi pwe oupwe uwei föföringauen ewe mwichen aramas ren ämi föri asoren amusamusen tipis fän iter fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Nengeni, ousap fen uwalong chan ewe mönün asor lon ewe leni mi pin. Pwüngün itä oupwe ochei fituken ewe mönün asor lon ewe leni mi pin usun üa allük ngenikemi.” ");
INSERT INTO chk_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Iwe, Aaron a üreni Moses, “Nengeni, ikenai ekewe aramas ra eäni ar asoren tipis me asoren kek fän mesen ewe Samol mi Lapalap, nge ekei sokun feiengau ra toriei. Ifa usun, epwe pwüng fän mesen ewe Samol mi Lapalap ai üpwe ochei fituken ewe mönün asoren tipis?” ");
INSERT INTO chk_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Nge lupwen Moses a rongorong ekei kapas, a menemen ren. ");
INSERT INTO chk_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Oupwe üreni ekewe aramasen Israel, ‘Ikkei ir ekewe mönümanau oua tongeni ochoch me lein man meinisin won fanüfan: ");
INSERT INTO chk_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Oua tongeni ochoch ekewe man meinisin mi keang kün pachapacher o lülüsefäli ener. ");
INSERT INTO chk_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nge ousap ochoch ekewe man mi chök lülüsefäli ener ika keang chök kün pachapacher: Ewe kamel epwe limengau ngenikemi, pun a lülüsefäli anan, nge esap keang kün pachapachan. ");
INSERT INTO chk_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Pwal ewe man itan pächer mi nom won achau epwe limengau ngenikemi, pun a lülüsefäli anan, nge esap keang kün pachapachan. ");
INSERT INTO chk_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Iwe, ewe üsangi epwe limengau ngenikemi, pun a lülüsefäli anan, nge esap keang kün pachapachan. ");
INSERT INTO chk_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nge pik epwe pwal limengau ngenikemi, pun a keang kün pachapachan, nge esap lülüsefäli anan. ");
INSERT INTO chk_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ousap fokun ochoch fituken ekei man, ousap pwal fokun atapa ekei man men mä, pun repwe limengau ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Iwe, oua tongeni mongö ekewe ik meinisin mi nom lon koluk ika leset a wor ililir me töröüner. ");
INSERT INTO chk_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Nge ekewe mönümanau mi nom leset ika lon koluk esap wor ililir me töröüner, ese lifilifil ika ra kükün ika ra watte, repwe anioput ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Iwe, repwe chök anioput ngenikemi. Ousap mongö fituker, nge are ra mäla, repwe pwal anioput ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Mönümanau meinisin mi nom lon koluk ika leset esap wor ililir me töröüner repwe chök anioput ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Iwe, ikkei iten ekewe machang ousap ochoch fituker, pun repwe anioput ngenikemi: Ikel me sokopaten ikel iter wolcher me osprei, ");
INSERT INTO chk_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ekewe machang iter kait me sokopaten machang iter falkon, ");
INSERT INTO chk_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","iteiten sokopaten ängä, ");
INSERT INTO chk_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ewe machang itan ostrich, kawakawen lepwin, nipöüwanei, sokopaten kawakaw, ");
INSERT INTO chk_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","fukuro, niwanök me ewe machang itan ipis, ");
INSERT INTO chk_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","niaupinik, ekewe machang iter pelikan me karion wolcher, ");
INSERT INTO chk_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","öröpwech pwal iteiten sokopaten örö, ewe machang itan hupo me pöüte. ");
INSERT INTO chk_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Iwe, ekewe kükün man meinisin mi äkkäs, nge ra pwal tö won fofoch aütür, repwe anioput ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Nge me lein ekewe kükün man mi äkkäs o tö won fofoch aütür oua tongeni mongö ekewe mi wor aför, pwe ra tongeni mwetemwet won pwül. ");
INSERT INTO chk_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ikkei ir ekewe kükün man oua tongeni mongö: sokopaten lifichimas, sokopaten lifichimas mi äkkäsfetal, sokopaten korongi, pwal sokun lifichimas mi nom won fetil. ");
INSERT INTO chk_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Nge ekewe lusun kükün man mi äkkäs, a pwal wor fofoch aütür, repwe anioput ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Are ämi oua atapa ekei man, oupwe limengau. Iwe, eman mi atapa ekei man men mä, epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Nge eman mi uwei eman lein ekei man men mä epwe sopuni üfan o limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Iteiten man mi kinikin kün pachapacher, nge resap keang ika resap pwal lülüsefäli ener, repwe limengau ngenikemi. Eman mi atapa ekei man men mä epwe pwal limengau. ");
INSERT INTO chk_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Iwe, ekewe man mi fetal won pöür me pecher, nge a chök wor kün aütür, repwe limengau ngenikemi. Eman mi atapa ekei man men mä epwe limengau. ");
INSERT INTO chk_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Nge eman mi uwei ekei man men mä epwe sopuni üfan o limengau tori lekuniol. Ekei man repwe limengau ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Iwe, ikkei ir ekewe mantötö mi tö won pwül repwe limengau ngenikemi: eman man itan wisel, nakich, sokopaten koluf, ");
INSERT INTO chk_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","litopach, niparoch, kuel, sokun kuel mi nom leppi me niküch. ");
INSERT INTO chk_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ekei man me lein ekewe mantötö repwe limengau ngenikemi. Eman mi atapa inisir men mä epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Nge ika eman lein ekei man a mäla o turutiu won och mettoch, ewe mettoch epwe limengau, ese lifilifil ika a för seni mwüch, ika echö üf, ika silin man, ika eu tuk, ika sokopaten sepi aramas ra aea. Iwe, ewe mettoch epwe soso lon koluk, epwe pwal limengau tori lekuniol, nge mürin epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Iwe, are eman me lein ekewe man men mä epwe turulong lon eu sepi mi för seni pwül, meinisin mine a nom lon epwe limengau, kopwe pwal amökkü ewe sepi. ");
INSERT INTO chk_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nge are chichin ewe sokun sepi mi limengau a niti och mongö, ewe mongö epwe limengau, pwal kolukun ün mi nom lon epwe limengau. ");
INSERT INTO chk_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Iwe, are eman lein ekewe kükün man men mä a torii och mettoch, epwe limengau, ese lifilifil ika eu lenien um ika eu sitof, repwe chök katala. Iwe, ekei mettoch ra limengau, repwe pwal limengau ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nge ika ewe man epwe turulong lon kolukun eu miich ika eu chönüttu, epwe chök limöch. Iwe, nge mine a torii ekewe kükün man men mä epwe limengau. ");
INSERT INTO chk_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Are eman lein ekewe kükün man men mä a turutiu won föün irä fän iten fofot, ekewe föün irä repwe chök limöch. ");
INSERT INTO chk_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Iwe, are ekewe föün irä ra nom lon chöchön, nge eman lein ekewe man men mä a turutiu won, ekewe föün irä repwe limengau ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Iwe, are eman lein ekewe man ämi mi tongeni ochoch a püsin mäla, nge eman a atapa, ätewe epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Nge eman mi ochoch ewe man men mä epwe sopuni üfan, i epwe pwal nom lon tettelin chon limengau tori lekuniol. Iwe, eman mi eki ewe man mi mä epwe sopuni üfan, epwe pwal nom lon tettelin chon limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Iteiten mantötö mi tö won pwül repwe anioput ngenikemi. Ousap fokun ocheer. ");
INSERT INTO chk_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Man meinisin mi tö won upwer lepwül, pwal meinisin mi tö won fofoch pecher ika lap seni, ousap ocheer, pun ra anioput. ");
INSERT INTO chk_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ousap alimengauakemi ren ekewe mantötö, pwe ousap nom lon tettelin chon limengau. ");
INSERT INTO chk_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Pun ngang ewe Samol mi Lapalap ämi we Kot. Iei mine oupwe püsin apinikemi pwe oupwe pin, pun ngang üa pin. Ousap püsin alimengauakemi ren ekewe mantötö mi tö won pwül. ");
INSERT INTO chk_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ngang ewe Samol mi Lapalap üa emwenikemiiwu seni ewe fanü Isip pwe üpwe ämi Kot. Iei mine oupwe pin, pun ngang üa pin.’” ");
INSERT INTO chk_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Iei ewe allük fänäsengesin ekewe man me machang, fänäsengesin mönümanau meinisin mi nom leset me lekoluk, pwal fänäsengesin ekewe mantötö meinisin mi tö won pwül. ");
INSERT INTO chk_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ei allük a alefila lefilen mine a limengau ika limöch, pwal lefilen ekewe mönümanau aramas ra tongeni ochoch me ekewe resap tongeni ochoch. ");
INSERT INTO chk_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük ");
INSERT INTO chk_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","fän iten ekewe aramasen Israel: Are eman fefin a pwopwo o nöüni eman ät, neminewe epwe nom lon tettelin chon limengau lon ükükün fisu rän, usun chök an limengau lon fansoun an samaun fefin. ");
INSERT INTO chk_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Nge lon awaluen rän ewe kükün ät epwe sirkomsais. ");
INSERT INTO chk_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Mürin, ewe fefin epwe pwal witiwit lon ükükün ilik me ülüngat rän tori epwe limöch seni chan. Esap tongeni atapa och mettoch mi pin, esap pwal tongeni feila ren ewe imwenfel seni mangaku tori a unus ränin an limelim. ");
INSERT INTO chk_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Nge are ewe fefin a nöüni eman nengin, neminewe epwe limengau lon ükükün ruu wik, usun chök an limengau lon fansoun an samaun fefin. Mürin epwe pwal witiwit lon ükükün wone me wonu rän tori epwe limöch seni chan. ");
INSERT INTO chk_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Iwe, lupwen ra wesöchüla ränin an limelim, ese lifilifil ika an limelim fän iten eman ät ika eman nengin, epwe uwato eman lam eu ierin leasamalapen ewe imw mangaku ia aramas ra churi Kot ie ren ewe souasor, pwe an asoren kek, epwe pwal uwato eman apansüsün lisom ika eman lisom pwe an asoren tipis. ");
INSERT INTO chk_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Iwe, ewe souasor epwe eäniir asor fän mesen ewe Samol mi Lapalap o föri asoren amusamusen tipis fän iten ewe fefin. Mürin epwe limöch seni chan. Iei ewe allük fän iten ekewe fefin mi nöünöü, ese lifilifil ika ra nöüni ät ika nengin. ");
INSERT INTO chk_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Nge are ewe fefin esap tufich ngeni an epwe uwato eman lam, epwe chök uwato ruoman lisom ika ruoman apansüsün lisom, eman fän iten asoren kek, nge pwal eman fän iten asoren tipis. Iwe, ewe souasor epwe föri asoren amusamusen tipis fän iten ewe fefin pwe epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Are eman aramas a wor och pwo won inisin, ika och tir ika och tikepwechepwech, a tongeni wiliti eu kilingau mi afeiengau won inisin, repwe emwenala ren ewe souasor Aaron ika ren eman lein mwirimwirin kewe. ");
INSERT INTO chk_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Iwe, ewe souasor epwe nenengenöchü ewe kilingau won inisin ewe aramas. Nge are a pwechepwechela ülöülen ewe ia a kilingau ie, are a pwal pwä pwe ewe kilingau a enalong silin, ewe aramas a eäni eu kilingau mi afeiengau. Iwe, wesin än ewe souasor nenengenöchü ewe aramas, epwe anomu lon tettelin chon limengau. ");
INSERT INTO chk_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Nge are ewe kilingau a pwechepwech won, nge esap enalong silin, are ülöülan resap pwal pwechela, ewe souasor epwe aimwüela ewe aramas lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Iwe, lon ewe afisuen rän ewe souasor epwe nenengenöchüsefäli ewe aramas. Nge are a küna pwe ewe kil esap lapala, esap pwal töfetal won silin, ewe souasor epwe aimwüela ewe aramas pwal lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Iwe, lon afisuen rän ewe souasor epwe nenengenöchüsefäli ewe aramas. Nge are ewe kil a aromomo, esap pwal töfetal won silin, ewe souasor epwe anomu lon tettelin chon limöch. Ewe kil och tir echök. Ewe aramas epwe sopuni üfan, mürin epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Nge are ewe tir a töfetal won silin ewe aramas mürin an pwäri ngeni ewe souasor inisin o nom lon tettelin chon limöch, ewe aramas epwe liwinsefälila ren ewe souasor. ");
INSERT INTO chk_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Iwe, ewe souasor epwe nenengenöchüsefäli ewe aramas. Nge are ewe tir a töfetal won silin, ewe souasor epwe anomu ewe aramas lon tettelin chon limengau, pun a eäni och kilingau mi afeiengau. ");
INSERT INTO chk_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Iwe, are eman aramas a eäni och kilingau mi afeiengau, repwe emwenala ewe aramas ren ewe souasor, ");
INSERT INTO chk_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","pwe epwe nenengenöchü. Nge are a wor eu pwo mi pwechepwech o ülöülen ewe ia a pwo ie ra pwechela, are a pwal parapar fituken lon ewe pwo, ");
INSERT INTO chk_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","iei eu kilingau mi afeiengau won inisin ewe aramas mi nom seni chök me lom. Iwe, ewe souasor epwe anomu i lon tettelin chon limengau. Esap chüen aimwüela ewe aramas ren an epwe nenengenisefäli, pun a fen limengau. ");
INSERT INTO chk_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Nge are ewe souasor a küna pwe ewe kilingau a rangewu won inisin ewe aramas o chöüla won inisin seni won möküran tori pechen, ");
INSERT INTO chk_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ewe souasor epwe nenengenöchü ewe aramas. Are ewe kilingau mi afeiengau a pwölüela unusen inisin, ewe souasor epwe anomu ewe aramas lon tettelin chon limöch. Iwe, pokiten unusen inisin a pwechela, a limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Nge are a pwä fituk mi parapar won inisin ewe aramas, epwe limengau. ");
INSERT INTO chk_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Iwe, ewe souasor epwe nenengenöchü ewe fituk mi parapar o anomu ewe aramas lon tettelin chon limengau. Fituk mi parapar a limengau, pun iei eu kilingau mi afeiengau. ");
INSERT INTO chk_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Nge are ewe fituk mi parapar won ewe aramas a siwil ngeni fituk mi pwechepwech, epwe feito ren ewe souasor. ");
INSERT INTO chk_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Iwe, ewe souasor epwe nenengenöchü ewe aramas. Nge are ewe kil a pwechela, ewe souasor epwe anomu ewe chon samau lon tettelin chon limöch, pun a limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Are a wor eu mach mi fen mo won inisin eman aramas, ");
INSERT INTO chk_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nge mürin a pwüküwu eu pwo mi pwech lerasen ewe mach ika eu pwo mi tikeparepwech, ewe aramas epwe aküna ngeni ewe souasor inisin. ");
INSERT INTO chk_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Iwe, ewe souasor epwe nenengenöchü machen ewe aramas. Pun ika a pwä pwe ewe kil lon ewe mach a enalong silin o ülöülan ra pwechela, ewe souasor epwe anomu ewe aramas lon tettelin chon limengau. Iei eu kilingau mi afeiengau a pwüküwu me lon ewe mach. ");
INSERT INTO chk_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Are ewe souasor a nenengenöchü ewe mach o küna pwe ülöülen won resap pwechela, are ewe kil lon esap pwal enalong silin pwe a aromomo, mürin ewe souasor epwe aimwüela ewe aramas lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Nge are ewe kil a töfetal won inisin ewe aramas, ewe souasor epwe anomu lon tettelin chon limengau, pun iei eu kilingau mi afeiengau. ");
INSERT INTO chk_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Nge ika ewe kil esap lapala, esap pwal töfetal, a chök eu lemomon mach. Iwe, ewe souasor epwe anomu ewe aramas lon tettelin chon limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Are eman a kar, nge mürin ewe kar a wiliti eu kil mi tikeparepwech ika pwech, ");
INSERT INTO chk_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ewe souasor epwe nenengenöchü ewe kar. Nge are ülöülen ewe ia a kar ie a pwechela, are ewe kil a pwal enalong silin, iei eu kilingau mi afeiengau. Iwe, ewe souasor epwe anomu ewe aramas lon tettelin chon limengau, pun a samaun rupun pwötür. ");
INSERT INTO chk_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Are ewe souasor a nenengenöchü ewe kar o küna pwe ülöülen won resap pwechela, are ewe kil esap pwal enalong silin pwe a aromomo, mürin ewe souasor epwe aimwüela ewe aramas lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Iwe, lon afisuen rän ewe souasor epwe nenengenisefäli ewe aramas. Nge are ewe kil a töfetal won inisin, ewe souasor epwe anomu ewe aramas lon tettelin chon limengau, pun iei eu kilingau mi afeiengau. ");
INSERT INTO chk_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Nge are ewe kil esap lapala, esap pwal töfetal won silin pwe a aromomo, a chök eu pwo seni ewe kar. Iwe, ewe souasor epwe anomu ewe aramas lon tettelin chon limöch, pun iei eu lemomon kar. ");
INSERT INTO chk_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Are eman mwän ika eman fefin a kilingau won möküran ika won ngächin, ");
INSERT INTO chk_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ewe souasor epwe nenengenöchü ewe kilingau. Nge are ewe kilingau a enalong silin, are ülöülen won ra pwal oleol o ülöngau, ewe souasor epwe anomu ewe aramas lon tettelin chon limengau. Iei eu kil mi pwerik, eu kilingau mi afeiengau won möküran ika won ngächin. ");
INSERT INTO chk_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Nge are ewe souasor a nenengenöchü ewe kilingau mi pwerik o küna pwe esap enalong silin, esap pwal wor ülöülan mi chol won, ewe souasor epwe aimwüela ewe aramas mi üri kilingau mi pwerik lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Iwe, lon afisuen rän ewe souasor epwe nenengenöchüsefäli kilingauen ewe aramas. Nge are ewe kil mi pwerik esap lapala, are esap wor ülöülen won mi oleol, esap pwal enalong silin, ");
INSERT INTO chk_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ewe aramas epwe räisöü, nge esap räisöü won ewe kil mi pwerik. Mürin, ewe souasor epwe aimwüela ewe aramas pwal lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Iwe, lon afisuen rän ewe souasor epwe nenengenöchüsefäli kilingauen ewe aramas. Nge are ewe kil mi pwerik esap lapala, esap pwal enalong silin, ewe souasor epwe anomu ewe aramas lon tettelin chon limöch. Iwe, epwe sopuni üfan, mürin epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Nge are ewe kil mi pwerik a töfetal won inisin mürin an nom lon tettelin chon limöch, ");
INSERT INTO chk_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ewe souasor epwe nenengenöchüsefäli ewe aramas. Pun ika ewe kil mi pwerik a töfetal won inisin, ewe souasor esap chüen ekiekin kütta ewe ülöül mi oleol, pun ewe aramas a limengau. ");
INSERT INTO chk_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Nge are ewe souasor a küna pwe ewe kil mi pwerik esap lapala, pwe ra pwükütä ülöülan mi chol won o ewe kil mi pwerik a mo, ewe aramas a limöch. Iwe, ewe souasor epwe anomu i lon tettelin chon limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Are a wor tikepwechepwech won inisin eman mwän ika eman fefin, ");
INSERT INTO chk_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ewe souasor epwe nenengenöchü ewe aramas. Nge are ewe tikepwechepwech won inisin esap nien lingewu, a chök üri eu kil. Iwe, ewe aramas a limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Are eman mwän a mworola meten möküran, ewe aramas a mongopal, nge a chök nom lon tettelin chon limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Iwe, are eman mwän a mworola meten möküren eten mesan me meten esen mongön, a chök pal eten mesan, nge a nom lon tettelin chon limöch. ");
INSERT INTO chk_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Nge are a wor eu kil mi parepwech won pallen möküran ika won eten mesen ewe mwän, iei eu kilingau mi afeiengau a üri won möküran ika won eten mesan. ");
INSERT INTO chk_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mürin, ewe souasor epwe nenengenöchü ewe mwän. Nge are ewe pwo won pallen möküran ika won eten mesan a tikeparepwech usun chök eu kilingau mi afeiengau won inis, ");
INSERT INTO chk_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ewe aramas a limengau. Iwe, ewe souasor epwe anomu ewe aramas lon tettelin chon limengau, pun a eäni eu kilingau mi afeiengau won möküran. ");
INSERT INTO chk_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Iwe, eman mi eäni eu kilingau mi afeiengau epwe üföüf üf mi kam o atorongaua möküran, epwe pwal pwölüela awan o kökkö, “Üa limengau, üa limengau.” ");
INSERT INTO chk_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Epwe chök nonom lon tettelin chon limengau lon ükükün langatamen fansoun an eäni ewe samau. Iwe, epwe imwüla lon lenian lükün ewe ia aramas ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Iwe, are a wor niwangir won echö üf, ese lifilifil ika ewe üf a för seni ülen man ika seni sokun silin irä, ");
INSERT INTO chk_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","are a nom won echö mangaku mi för seni sokun silin irä ika seni ülen man, are a pwal nom won silin man ika won och pisek mi för seni silin man, ");
INSERT INTO chk_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","are ei niwangir a anüefetil ika anüepar, iei eu niwangir mi chöfetal. Iwe, repwe aküna ngeni ewe souasor. ");
INSERT INTO chk_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ewe souasor epwe nenengenöchü ewe niwangir o aimwüela ewe pisek lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Nge lon afisuen rän epwe nenengenöchüsefäli ewe niwangir. Iwe, are ewe niwangir a lapala won ewe üf ika won ewe mangaku ika won ewe silin man, ese lifilifil met sokun aean ewe silin man, ewe niwangir a fokun ngau, ewe pisek a limengau. ");
INSERT INTO chk_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Iwe, ewe souasor epwe kenala ewe pisek. Pokiten ewe niwangir a fokun ngau, epwe chök kekila. ");
INSERT INTO chk_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Nge are ewe souasor a nenengenöchüsefäli o küna pwe ewe niwangir esap lapala won ewe üf ika won ewe mangaku ika won och seni silin man, ");
INSERT INTO chk_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ewe souasor epwe allük pwe repwe sopuni ewe pisek mi niwangir. Mürin epwe aimwüela pwal lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mürin, ewe souasor epwe nenengenöchüsefäli ewe pisek mi niwangir mürin an sop. Nge are ewe niwangir esap siwil anüanün, inamwo are esap pwal lapala, ewe pisek a chök limengau. Kopwe chök kenala ewe pisek, ese lifilifil ika ewe niwangir mi ngau a nom lon ika lükün. ");
INSERT INTO chk_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Nge are ewe souasor a nenengenöchüsefäli o küna pwe ewe niwangir a aromomo mürin an sop, epwe kamwewu ewe ia a niwangir ie me won ewe üf ika ewe silin man ika ewe mangaku. ");
INSERT INTO chk_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Iwe, are ewe niwangir a pwäsefäl me mürin won ewe üf ika won ewe mangaku ika won och pisek seni silin man, ewe niwangir a chöfetal. Kopwe chök kenala ewe pisek mi ngau niwangirin. ");
INSERT INTO chk_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Nge are niwangirin ewe üf ika ewe mangaku ika och pisek mi för seni silin man a mola mürin om sopuni, kopwe chök sopuni fän aruuan. Mürin epwe limöch.” ");
INSERT INTO chk_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Iei ewe allük fän iten ewe niwangir mi fokun ngau won üf mi för seni ülen man ika seni sokun silin irä ika won mangaku are pwal och pisek mi för seni silin man, pwe epwe fat ika och pisek a limöch ika a limengau. ");
INSERT INTO chk_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Iwe, ewe Samol mi Lapalap a ngeni Moses ");
INSERT INTO chk_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","ekei allük fän iten eman mi eäni eu kilingau mi afeiengau lon ränin an limelim: Repwe emwenato ewe aramas ren ewe souasor, ");
INSERT INTO chk_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","nge ewe souasor epwe feila lükün ewe leni ia aramas ra nonom ie. Iwe, ewe souasor epwe nenengenöchü ewe chon samau. Nge are ewe kilingau mi afeiengau a mola seni, ");
INSERT INTO chk_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ewe souasor epwe allük pwe repwe uwato fän iten ewe epwe limelim ruoman machang mi manau o limöch, mwüch seni ewe irä itan setar, ekam mangaku mi par pwal ülün ewe irä itan isop. ");
INSERT INTO chk_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Iwe, ewe souasor epwe allük pwe repwe niela eman me lein ekewe machang asen eu sepi mi för seni pwül, nge lon ewe sepi epwe wor koluk mi mürina. ");
INSERT INTO chk_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Mürin epwe angei ewe machang mi chüen manau fiti ewe mwüch seni ewe irä setar, ewe ekam mangaku mi par me ülün ewe irä isop, o atukurelong lon chan ewe machang a fen ninnila asen ewe koluk mi mürina. ");
INSERT INTO chk_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Iwe, epwe äsupu ewe cha fän fisu won ewe aramas, pwe epwe limöch seni an kilingau mi afeiengau. Mürin, ewe souasor epwe anomu ewe aramas lon tettelin chon limöch, epwe pwal ässala ewe machang mi chüen manau lemäl. ");
INSERT INTO chk_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Nge ewe aramas mi mochen limöch epwe sopuni üfan o räisöü ülöülan meinisin, epwe pwal tütü pwe epwe limöch. Mürin a tongeni tolong lon ewe leni ia aramas ra nonom ie, nge epwe chök nom lükün imwan lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Iwe, lon afisuen rän epwe räisöüla möküran meinisin pwal alüsan me fötün, epwe pwal räisöü ülöülan meinisin. Mürin epwe sopuni üfan o tütü. Iwe, epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Nge lon awaluen rän epwe uwato ruoman ätemwänin lam me eman liefefinin lam eu ierir esap wor terir. Epwe pwal uwato limu paun pilawa mi amas o mürina a nofitfengen me apüra, pwal ina epwe ükükün esop kuoch noppuk. ");
INSERT INTO chk_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Iwe, ewe souasor mi föri ewe angangen limelim epwe emwenato ewe aramas mi mochen limelim fiti an kewe asor mwen ewe Samol mi Lapalap leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Mürin, ewe souasor epwe angei eman me lein ekewe ätemwänin lam o eäni asor fän iten asoren pupungau fitifengen me ewe esop kuoch noppuk. Iwe, epwe assaweer fän mesen ewe Samol mi Lapalap pwe eu asoren assaw. ");
INSERT INTO chk_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Mürin epwe niela ewe lam lon ewe leni mi pin, ewe ia ra niela ie ewe mönün asoren tipis me ewe mönün asoren kek. Pun ewe asoren pupungau inetin ewe souasor usun chök ewe asoren tipis, a pwal unusen pin. ");
INSERT INTO chk_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Iwe, ewe souasor epwe angei ekis chan ewe mönün asoren pupungau o tofi ngeni emin fän pelifichin selingen ätewe mi mochen limöch, pwal ngeni aütülapen pelifichin pöün me pechen. ");
INSERT INTO chk_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Mürin, ewe souasor epwe angei ekis seni ewe esop kuoch noppuk o ninalong lon pelimöngün püsin pöün. ");
INSERT INTO chk_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Iwe, epwe atukalong aütün pelifichin pöün lon ewe noppuk o äsupu fän fisu ekis seni ewe noppuk fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Nge ekis seni ewe noppuk mi chüen nom lepöün epwe tofi ngeni emin fän pelifichin selingen ätewe mi mochen limöch, pwal ngeni aütün pelifichin pöün me pechen. Nge epwe chök tofätä ewe noppuk won ewe ia a fen tofätä ie chan ewe mönün asoren pupungau. ");
INSERT INTO chk_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Iwe, lusun ewe noppuk mi chüen nom lepöün epwe epiti ngeni möküren ätewe mi mochen limöch. Ren ei ewe souasor epwe föri asoren amusamusen tipis fän iten ewe aramas fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Mürin, ewe souasor epwe eäni ewe asoren tipis, pwe epwe föri asoren amusamusen tipis fän iten ätewe mi mochen limöch seni an limengau. Nge mürin epwe niela ewe mönün asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Iwe, ewe souasor epwe keni ewe asoren kek me ewe asoren mongö won ewe rongen asor. Iei usun ewe souasor epwe föri asoren amusamusen tipis fän iten ewe aramas. Iwe, epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Nge are ewe aramas a wöüngau pwe esap tufich ngeni an epwe uwato ei ükükün, epwe chök uwato eman ätemwänin lam fän iten asoren pupungau epwe assaw, pwe epwe fis asoren amusamusen tipis fän itan. Epwe pwal uwato ruu paun pilawa mi amas o mürina nofitfengen me apüra fän iten asoren mongö, pwal ina epwe ükükün esop kuoch noppuk. ");
INSERT INTO chk_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Iwe, epwe pwal uwato ruoman lisom ika ruoman apansüsün lisom ükükün chök an tongeni, eman epwe fän iten asoren tipis, nge ewe eman epwe fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Iwe, lon awaluen rän epwe uwato ekei mönün asor fän iten an limelim ren ewe souasor leasamalapen ewe imwenfel seni mangaku mwen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mürin, ewe souasor epwe angei ewe lam me ewe esop kuoch noppuk fän iten asoren pupungau o assaweer fän mesen ewe Samol mi Lapalap, pwe eu asoren assaw. ");
INSERT INTO chk_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Iwe, ewe souasor epwe niela ewe lam fän iten asoren pupungau. Mürin epwe angei ekis chan o tofi ngeni emin fän pelifichin selingen ätewe mi mochen limöch, pwal ngeni aütülapen pelifichin pöün me pechen. ");
INSERT INTO chk_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Epwe pwal ninalong ekis ewe noppuk lon pelimöngün püsin pöün ");
INSERT INTO chk_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","o äsupu fän fisu ekis seni ewe noppuk ren aütün pelifichin pöün fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Mürin, ewe souasor epwe tofi ekis seni ewe noppuk mi chüen nom lepöün ngeni emin fän pelifichin selingen ätewe mi mochen limöch, pwal ngeni aütülapen pelifichin pöün me pechen. Nge epwe chök tofätä ewe noppuk won ewe ia a fen tofätä ie chan ewe mönün asoren pupungau. ");
INSERT INTO chk_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Iwe, lusun ewe noppuk mi chüen nom lepöün ewe souasor epwe epiti ngeni möküren ätewe mi mochen limöch, pwe epwe föri asoren amusamusen tipis fän itan fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Mürin, epwe eäni asor ekewe ruoman lisom ika ekewe ruoman apansüsün lisom ükükün än ewe aramas tongeni. ");
INSERT INTO chk_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Epwe eäni asor eman fän iten asoren tipis, nge ewe eman fän iten asoren kek fitifengen me ewe asoren mongö. Iei usun ewe souasor epwe föri asoren amusamusen tipis fän mesen ewe Samol mi Lapalap fän iten ewe aramas mi mochen limöch. ");
INSERT INTO chk_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Iei ewe allük fän iten ewe aramas mi eäni ewe kilingau mi afeiengau esap tufich ngeni an epwe uwato ekewe sokun asor fän iten an limelim.” ");
INSERT INTO chk_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Lupwen oupwe tolong lon ewe fanü Kanaan üpwe ngenikemi pwe fanüemi, nge üpwe awora eu nuumw mi chöfetal lon eu imw won fanüemi, ");
INSERT INTO chk_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ätewe imwan ewe epwe feito o asile ngeni ewe souasor, ‘Üa küna och me lon imwei mi usun chök nuumw.’ ");
INSERT INTO chk_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Mürin, ewe souasor epwe allük pwe chon ewe imw repwe towu seni fiti pisekir me mwen an epwe tolong pwe epwe nenengenöchü ewe nuumw, pwe esap wor och mettoch mi nom lon ewe imw epwe tolong lon tettelin limengau. Mürin, ewe souasor epwe tolong lon ewe imw ");
INSERT INTO chk_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","o nenengenöchü ewe nuumw. Nge are anüen ewe nuumw mi nom won etippen ewe imw a aroanüen fetil ika aroanüepar, are ewe nuumw a pwal ekis pwangenalong ewe etip, ");
INSERT INTO chk_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ewe souasor epwe towu me lon asamalapen ewe imw o lokkenala lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Nge lon afisuen rän ewe souasor epwe liwinsefäliti ewe imw o nenengeni. Iwe, are ewe nuumw a lapala won etippen ewe imw, ");
INSERT INTO chk_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ewe souasor epwe allük pwe repwe ämwetawu ekewe fau mi nuumw o atururela lon eu leni mi limengau lükün ewe telinimw. ");
INSERT INTO chk_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Iwe, epwe pwal allük pwe repwe örööti omwotowun etippen pwelin lon ewe imw. Nge mine ra örööti repwe aturalong lon eu leni mi limengau lükün ewe telinimw. ");
INSERT INTO chk_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Mürin repwe angei ekoch fau o siwilirelong lerasen ekewe fau ra kämwetewu, repwe pwal omwotowusefäli ewe imw. ");
INSERT INTO chk_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Nge are ewe nuumw a pwüküsefälitä lon ewe imw mürin ar ämwetawu ekewe fau me ar örööti omwotowun ewe imw, pwal lupwen ar omwotowusefäli, ");
INSERT INTO chk_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ewe souasor epwe feila o nengeni. Iwe, are ewe nuumw a lapala lon ewe imw, ewe nuumw a fokun ngau. Ewe imw a limengau. ");
INSERT INTO chk_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Iwe, ewe imw epwe kata, nge föün, irän me omwotowun meinisin repwe uweerewu seni lon ewe telinimw o atururela lon eu leni mi limengau. ");
INSERT INTO chk_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Nge iö mi tolong lon ewe imw, lupwen a kesipela, epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Iö kana ra konola lon ewe imw ika mongö lon repwe sopuni üfer. ");
INSERT INTO chk_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Are ewe souasor epwe feito o nenengenöchü ewe imw, nge ewe nuumw esap pwüküsefäl mürin ar omwotowu ewe imw, ewe souasor epwe anomu ewe imw lon tettelin limöch, pun ewe nuumw a mola. ");
INSERT INTO chk_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Iwe, ren angangen limelimen ewe imw, ewe souasor epwe angei ruoman kükün machang pwal mwüch seni ewe irä setar, ekam mangaku mi par me ülün ewe irä isop. ");
INSERT INTO chk_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Epwe niela eman lein ekewe machang asen eu sepi mi för seni pwül, nge lon ewe sepi epwe wor koluk mi mürina. ");
INSERT INTO chk_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Mürin epwe angei ewe mwüch seni ewe irä setar, ülün ewe irä isop me ewe ekam mangaku mi par fiti ewe machang mi chüen manau, o atukurelong lon chan ewe machang a fen ninnila asen ewe koluk mi mürina. Iwe, epwe äsupu ewe cha fän fisu ngeni ewe imw. ");
INSERT INTO chk_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Iei usun ewe souasor epwe limeti ewe imw ren chan ewe machang me ewe koluk mi mürina, ren ewe machang mi chüen manau me ewe mwüch seni ewe irä setar, pwal ren ülün ewe irä isop me ewe ekam mangaku mi par. ");
INSERT INTO chk_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Mürin epwe ässala ewe machang mi chüen manau seni lon ewe telinimw, pwe epwe ässila lemäl. Iei usun ewe souasor epwe föri asoren limelim fän iten ewe imw, iwe, epwe limöch.” ");
INSERT INTO chk_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ikkei ekewe allük fän iten sokopaten kilingau mi afeiengau: fän iten kilingau mi pwerik, ");
INSERT INTO chk_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","fän iten niwangirin üf ika nuumw lon imw, ");
INSERT INTO chk_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","fän iten pwoon won inis ika tir ika och tikepwechepwech. ");
INSERT INTO chk_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ren ekei allük epwe pwä inet eman aramas ika och mettoch a limengau ika limöch. Ikkei ekewe allük fän iten kilingau mi afeiengau, fän iten niwangir me nuumw. ");
INSERT INTO chk_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Iwe, ewe Samol mi Lapalap a ngeni Moses me Aaron ekei allük ");
INSERT INTO chk_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","fän iten ekewe aramasen Israel: Are och chönü a towu seni ewe kükün inis seni eman mwän, ewe chönü a limengau, ");
INSERT INTO chk_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ese lifilifil ika ewe chönü a chüen pu seni ika a ükütiu, a chök limengau. ");
INSERT INTO chk_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Iteiten kieki ätewe mi pu seni och chönü a kon lon epwe limengau. Pwal mettoch meinisin mine ätewe a mot won repwe limengau. ");
INSERT INTO chk_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Iwe, eman mi atapa kien ätewe epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Nge iö a mot won och mettoch ätewe mi pu seni och chönü a fen mot won, epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Nge iö a atapa inisin ätewe mi pu seni och chönü epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Iwe, are ätewe mi pu seni och chönü a atufätä won eman mi limöch, ätewe mi limöch epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Nge iteiten sokun lenien mot aramas ra aea le mot won man epwe limengau, are ätewe mi pu seni och chönü a mot won. ");
INSERT INTO chk_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Iö a atapa och mettoch ätewe mi pu seni och chönü a chouni, epwe limengau tori lekuniol. Nge iö a eki ei sokun mettoch epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Iwe, are ätewe mi pu seni och chönü epwe atapa eman, nge esap mwo rupuri pöün lon koluk, ätewe a atapa epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Nge are ätewe mi pu seni och chönü epwe atapa eu sepi mi för seni pwül, ewe sepi epwe ömmök. Nge ika ewe sepi a för seni mwüch, epwe chök töttöl lon koluk. ");
INSERT INTO chk_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Lupwen ewe chönü a ükütiu le pu, ewe mwän epwe püsin aawit lon ükükün fisu rän fän iten an limelim. Mürin epwe sopuni üfan o tütü lon koluk mi mürina pwe epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Iwe, lon awaluen rän epwe angei ruoman lisom ika ruoman apansüsün lisom, epwe feito fän mesen ewe Samol mi Lapalap leasamalapen ewe imw mangaku ia aramas ra churi Kot ie, o ngeni ewe souasor ekewe lisom. ");
INSERT INTO chk_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Nge ewe souasor epwe eäniir asor, eman fän iten asoren tipis, nge ewe eman fän iten asoren kek. Ren ei ewe souasor epwe föri asoren amusamusen tipis fän mesen ewe Samol mi Lapalap fän iten ätewe mi pu seni och chönü. ");
INSERT INTO chk_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Iwe, are ewe chan mwän a towu seni eman mwän, epwe atütü unusen inisin, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Nge iteiten üf me iteiten mettoch mi för seni silin man a tup lon ewe chan mwän, repwe sop, repwe pwal limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Are eman mwän a kon ren eman fefin o ewe chan mwän a towu, ir me ruoman repwe tütü, nge repwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Iwe, are eman fefin a samaun fefin, neminewe epwe nom lon an limengau lon ükükün fisu rän. Nge iö a atapa ewe fefin epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Mettoch meinisin neminewe a kon lon ika mot won lupwen an samaun fefin repwe limengau. ");
INSERT INTO chk_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Iö a atapa kien neminewe epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Nge iö a atapa och mettoch neminewe a mot won, epwe sopuni üfan o tütü, epwe pwal limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ese lifilifil are neminewe a mot lon kieki ika och mettoch, lupwen eman a atapa, epwe chök limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Are eman mwän a kon ren eman fefin mi samaun fefin, limengauan a nom won ewe mwän. Iwe, ewe mwän epwe limengau lon ükükün fisu rän, nge iteiten kieki ätewe a kon lon epwe pwal limengau. ");
INSERT INTO chk_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Are eman fefin a pu seni cha lon chomong rän, nge sap lon fansoun an samaun fefin, ika lupwen a lula fansoun an samaun fefin, epwe chök limengau lon ükükün fansoun an pu seni cha. Epwe limengau usun chök limengauan lon ränin an samaun fefin. ");
INSERT INTO chk_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Iwe, kieki meinisin neminewe a kon lon lupwen ränin an pu seni cha repwe limengau, usun limengauen ekewe kieki a kon lon lupwen an samaun fefin. Nge mettoch meinisin neminewe a mot won repwe pwal limengau, usun limengauen mine a mot won lupwen an samaun fefin. ");
INSERT INTO chk_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Iö a atapa ekewe mettoch epwe pwal limengau. Iwe, epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Nge lupwen a ükütiu le pu seni neminewe chan, epwe püsin aawit lon ükükün fisu rän, mürin epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Iwe, lon awaluen rän epwe angei ruoman lisom are ruoman apansüsün lisom o uweerela ren ewe souasor leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mürin, ewe souasor epwe eäniir asor eman fän iten asoren tipis, nge ewe eman fän iten asoren kek. Iei usun, ewe souasor epwe föri asoren amusamusen tipis fän mesen ewe Samol mi Lapalap fän iten limengauen neminewe mi pu seni cha. ");
INSERT INTO chk_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Iwe, ewe Samol mi Lapalap a üreni Moses pwe epwe aiti ngeni ekewe aramasen Israel usun ar repwe aimwürela seni ekewe mettoch mi alimengaueer, pwe resap mäla lon ar limengau ren ar apiningaua ewe imwenfel seni mangaku mi nom lefiler. ");
INSERT INTO chk_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ikkei ekewe allük fän iten eman mwän mi pu seni och chönü ika mi towu seni ewe chan mwän, ");
INSERT INTO chk_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","pwal fän iten eman fefin mi samaun fefin, fän iten eman mwän ika eman fefin mi pu seni och, pwal fän iten eman mwän a kon ren eman fefin mi limengau. ");
INSERT INTO chk_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses mürin mälan nöün Aaron kewe ruoman mwän, ra mäla lupwen ar eäni asor mine esap pin fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe asile ngeni Aaron pwiüm we, pwe esap tolong inet chök a mochen lon ewe leni mi unusen pin pekilan ewe cheech mwen ewe öppüng mi nom won ewe pworofel, pwe esap mäla. Pun üpwe pwä lon ewe kuchu asen ewe öppüng. ");
INSERT INTO chk_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Iei usun pwüngün än Aaron epwe tolong lon ewe leni mi unusen pin: Epwe uwato eman nienifön ätemwänin kow fän iten asoren tipis, pwal eman ätemwänin sip fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Iwe, epwe üföüf ewe üf mi pin o pwechepwech, pwal ewe rauesesin lon mi pwechepwech, epwe peliti ngeni ewe pelit mi pwechepwech o imweimw ewe akkau mi pwechepwech. Ikkei ekewe üf mi pin. Iwe, epwe tütü, mürin epwe üföüfolong ekewe üf mi pin. ");
INSERT INTO chk_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Aaron epwe pwal angei seni ekewe aramasen Israel ruoman ätemwänin kuuch fän iten asoren tipis me eman ätemwänin sip fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Iwe, Aaron epwe eäni asor ewe ätemwänin kow pwe asoren tipis fän püsin itan, o föri asoren amusamusen an tipis me än an famili tipis. ");
INSERT INTO chk_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Mürin, epwe angei ekewe ruoman kuuch o anomuur fän mesen ewe Samol mi Lapalap leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ikenan Aaron epwe asisil won ekewe ruoman kuuch, eman fän iten ewe Samol mi Lapalap, nge ewe eman fän iten Asasel . ");
INSERT INTO chk_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Iwe, Aaron epwe uwato ewe kuuch mi kuw ewe asisil fän iten ewe Samol mi Lapalap o eäni asoren tipis. ");
INSERT INTO chk_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Nge ewe kuuch a kuw ewe asisil fän iten Asasel Aaron epwe pwal uwato fän mesen ewe Samol mi Lapalap, nge men manau. Mürin epwe tinala ewe kuuch lon fanüapö ren Asasel, pwe epwe uweala än ekewe aramas tipis. ");
INSERT INTO chk_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Iwe, Aaron epwe uwato ewe ätemwänin kow pwe asoren tipis fän püsin itan, o föri asoren amusamusen an tipis me än an famili tipis. Epwe niela ewe ätemwänin kow pwe asoren tipis fän püsin itan. ");
INSERT INTO chk_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Mürin epwe angei eu sepien asoren ötüöt mi masou ren molien ekkei seni ewe rongen asor mi nom fän mesen ewe Samol mi Lapalap. Epwe pwal angei ruukumuch apach mi pwokus o kinikisitiu. Iwe, epwe uwala ekei mettoch pekilan ewe cheech lon ewe leni mi unusen pin ");
INSERT INTO chk_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","o isetä ewe apach mi pwokus won ewe ekkei mi nom fän mesen ewe Samol mi Lapalap, pwe ötüötün ewe apach mi pwokus epwe pwölüela ewe öppüng mi nom won ewe pworofel, pwe esap mäla. ");
INSERT INTO chk_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Iwe, epwe angei ekis chan ewe ätemwänin kow o äsupu ren aütün ngeni lepekin me fän mesen ewe öppüng, epwe pwal äsupu fän fisu ngeni mwen ewe pworofel. ");
INSERT INTO chk_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Mürin, epwe niela ewe kuuch pwe asoren tipis fän iten ekewe aramas o uwalong chan lon ewe leni mi unusen pin. Iwe, epwe föri ngeni chan ewe kuuch usun mine a föri ngeni chan ewe ätemwänin kow. Epwe äsupu ewe cha ngeni won ewe öppüng pwal ngeni mwen ewe pworofel. ");
INSERT INTO chk_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Iei usun Aaron epwe föri asoren limelim fän iten ewe leni mi unusen pin pokiten limengauen ekewe aramasen Israel, pwal pokiten ar pupungau me ar tipis meinisin. Iei usun epwe pwal föri fän iten ewe imwenfel seni mangaku mi nom rer lon lenier mi limengau. ");
INSERT INTO chk_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Iwe, esap wor eman epwe nom lon ewe imwenfel seni mangaku, lupwen Aaron a tolong lon ewe leni mi unusen pin pwe epwe föri asoren amusamusen tipis, tori an epwe towu wesin an föri asoren amusamusen tipis fän püsin itan, fän iten an famili, pwal fän iten ekewe chon Israel meinisin. ");
INSERT INTO chk_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Mürin epwe towu ren ewe rongen asoren kek mi nom fän mesen ewe Samol mi Lapalap, pwe epwe föri asoren limelim fän iten ewe rong. Iwe, epwe angei ekis chan ewe ätemwänin kow, pwal ekis chan ewe kuuch, o tofätä won mächän ewe rong. ");
INSERT INTO chk_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Iwe, epwe pwal äsupu ren aütün ekis chan ekewe mönün asor fän fisu won ewe rong, pwe epwe alimöchü seni limengauen ekewe aramasen Israel o apini. ");
INSERT INTO chk_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Are Aaron a wes me föri ewe asoren limelim fän iten ewe leni mi unusen pin, ewe imw mangaku ia aramas ra churi Kot ie, me ewe rongen asor, epwe uwato ewe kuuch mi manau. ");
INSERT INTO chk_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Mürin, Aaron epwe anomu pöün me ruofoch won möküren ewe kuuch mi manau o pwärätä won än chon Israel föföringau meinisin, ar pupungau me ar tipis meinisin. Iwe, epwe anomu ekewe tipis won möküren ewe kuuch o tinala lon fanüapö ren eman mwän mi fil fän iten ewe angang. ");
INSERT INTO chk_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Iwe, ewe kuuch epwe uweela ar föföringau meinisin ngeni eu leniapö. Nge ätewe mi emwenala ewe kuuch epwe chök likitala lon leniapö. ");
INSERT INTO chk_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Mürin, Aaron epwe tolong lon ewe imwenfel seni mangaku o pwilitawu ekewe üf mi pwech a üföüf lupwen an tolong lon ewe leni mi unusen pin. Iwe, epwe likitiir ikenan. ");
INSERT INTO chk_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Epwe tütü lon eu leni mi pin o üföüfolong üfan kewe. Mürin, epwe towu o eäni an asoren kek me än ekewe aramas asoren kek, pwe epwe föri asoren amusamusen tipis fän itan pwal fän iten ekewe aramas. ");
INSERT INTO chk_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Iwe, kirisin ewe mönün asoren tipis epwe keni me won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Nge ätewe mi afeilai ewe kuuch ren Asasel epwe sopuni üfan o tütü. Mürin epwe tongeni tolong lon ewe leni ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Iwe, repwe uwala lükün ewe ia ra nonom ie ekewe mönün asoren tipis, iei ewe ätemwänin kow me ewe kuuch, mine char ewe Aaron a fen uwala lon ewe leni mi unusen pin pwe asoren amusamusen tipis. Iwe, silir me fituker pwal tarer repwe kek. ");
INSERT INTO chk_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Nge ätewe mi wisen keniir epwe sopuni üfan o tütü, mürin epwe tongeni tolong lon ewe leni ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Iwe, ei epwe eu allük ngenikemi oupwe apwönüetä fansoun meinisin. Lon aengolun ränin ewe afisuen maram oupwe echikefel, ousap pwal föri och angang, sap ämi are ekewe chon ekis mi nom remi. ");
INSERT INTO chk_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Pun lon ewe rän epwe fis asoren amusamusen tipis fän itemi pwe oupwe limöch. Mürin oupwe limöch fän mesen ewe Samol mi Lapalap seni ämi tipis meinisin. ");
INSERT INTO chk_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Iwe, ei ränin sapat epwe eu ränin asösö remi, nge ämi oupwe echikefel. Iei eu allük oupwe apwönüetä fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Nge ewe souasor mi kepit o apinipin ngeni wisen souasor lon lenien saman epwe föri asoren amusamusen tipis, nge epwe üföüf ekewe üf mi pwechewech o pin. ");
INSERT INTO chk_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Iwe, epwe föri asoren limelim fän iten ewe leni mi unusen pin, fän iten ewe imw mangaku ia aramas ra churi Kot ie, pwal fän iten ewe rongen asor. Epwe pwal föri asoren amusamusen tipis fän iten ekewe souasor me ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ei epwe eu allük oupwe apwönüetä fansoun meinisin, pwe epwe fis asoren amusamusen tipis fän eu lon eu ier fän äsengesin aramasen Israel pokiten ar tipis kana.” Iwe, Moses a föri usun mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","pwe epwe ngeni Aaron me nöün kewe mwän pwal ekewe aramasen Israel meinisin ekei allük: ");
INSERT INTO chk_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Are eman chon Israel a niela eman kow ika eman sip ika eman kuuch pwe an asor lon ewe leni ia ra nonom ie ika lükün, ");
INSERT INTO chk_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","nge esap uwato ewe man leasamalapen ewe imw mangaku ia aramas ra churi Kot ie, pwe epwe fang ngeni ewe Samol mi Lapalap mwen an imwenfel, ewe mwän epwe nom lon tipisin nimanau. Iwe, pokiten a föri ei, iei mine epwe käriwu seni aramasan. ");
INSERT INTO chk_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Popun ei allük pwe ekewe aramasen Israel repwe uwato ar kewe mönün asor ren ewe Samol mi Lapalap, nge resap chüen nirela lon ekewe maasies. Repwe uweereto ren ewe souasor leasamalapen ewe imwenfel seni mangaku o nirela, pwe ar asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Iwe, ewe souasor epwe äsupu chan ewe mönün asor ngeni ewe rongen asor än ewe Samol mi Lapalap leasamalapen ewe imwenfel seni mangaku, epwe pwal keni kirisin pwe ewe Samol mi Lapalap epwe efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Iwe, repwe ükütiu le kirikiringau ngeni ewe Samol mi Lapalap ren ar niela ar kewe mönün asor ngeni ekewe anün rochopwak. Ei epwe eu allük fän iter pwe repwe apwönüetä fansoun meinisin seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Kopwe pwal üreniir: Iteiten eman me eman me lein chon Israel ika me lein ekewe chon ekis mi nom rer a eäni eu asoren kek ika och sokun asor, ");
INSERT INTO chk_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","nge esap uwato leasamalapen ewe imwenfel seni mangaku pwe epwe eäni asor ngeni ewe Samol mi Lapalap, ätewe epwe käriwu seni lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Iwe, are eman aramas me lein chon Israel ika eman chon ekis mi nom rer a ün cha, ngang üpwe ü ngeni ewe aramas o ärawu me lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Pun manauen mönümanau meinisin a nom lon cha. Üa ngenikemi ei cha pwe oupwe föri asoren amusamusen tipis fän iten manauemi won ewe rongen asor. Iwe ren cha chök a fis amusamusen tipis, pun manau a nom lon. ");
INSERT INTO chk_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Iei mine üa üreni ekewe aramasen Israel: Esap wor eman leimi ika eman chon ekis mi nom remi epwe ün cha. ");
INSERT INTO chk_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Iwe, are eman leimi ika eman chon ekis mi nom remi epwe liapeni man ika machang mi öchün ochoch, epwe asürala chan o pwölü ewe cha ngeni pwül. ");
INSERT INTO chk_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Pun chan iteiten mönümanau ina manauan. Iei mine üa ürenikemi ämi aramasen Israel: Ousap ünümi chan eman mönümanau, pun chan iteiten mönümanau ina manauan. Iö a ün cha epwe käriwu me lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Nge iteiten aramas, ese lifilifil ika eman chon Israel ika eman chon ekis, mi ochoch fituken eman man mi püsin mäla ika mi mäla ren manmwacho, epwe sopuni üfan o tütü, nge epwe limengau tori lekuniol. Mürin epwe limöch. ");
INSERT INTO chk_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Nge ika esap sopuni üfan o tütü, an pwüngingau epwe chök nonom won.” ");
INSERT INTO chk_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Kopwe üreni ekewe aramasen Israel: Ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ousap föri sokun föför ekewe chon Isip ra föri lon ewe leni ia oua piin nonom ie me mwan. Ousap pwal föri sokun föför ekewe aramas ra föri lon ewe fanü Kanaan ewe ia üpwe emwenikemiila ie. Ousap apirü ar föför. ");
INSERT INTO chk_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Oupwe aleasochis ngeni ai kewe allük o apwönüetä ai kewe pwüüng. Ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Iei mine oupwe fokun apwönüetä ai kewe allük me pwüüng, pun are eman aramas epwe aleasochisiir, epwe manau. Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Iwe, esap wor eman me leimi epwe oror ngeni püsin aramasan ren an epwe lisowu ngeni. Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Kosap turunufasei semom ren om lisowu ngeni inom. Pokiten neminewe inelapom, kosap fokun lisowu ngeni. ");
INSERT INTO chk_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Kosap lisowu ngeni pwülüen semom, pun ka turunufasei semom ren. ");
INSERT INTO chk_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Kosap lisowu ngeni fefinom, ese lifilifil ika neminewe nöün semom ika nöün inom mi uputiu lon leniom ika ekis. ");
INSERT INTO chk_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Kosap lisowu ngeni nöün noum mwän föpwül ika nöün noum fefin föpwül, pun ka püsin turunufaseek ren. ");
INSERT INTO chk_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Kosap pwal lisowu ngeni nöün pwülüen semom föpwül, pun nöün semom, nge pwal i fefinom. ");
INSERT INTO chk_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Kosap lisowu ngeni fefinen semom, pun i fituken semom. ");
INSERT INTO chk_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Kosap lisowu ngeni pwin inom, pun i fituken inom, ");
INSERT INTO chk_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","kosap pwal turunufasei pwin semom ren om oror ngeni pwülüan pwe kopwe lisowu ngeni, pokiten neminewe pwal i inom. ");
INSERT INTO chk_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Kosap fokun lisowu ngeni pwülüen noum mwän. ");
INSERT INTO chk_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Kosap lisowu ngeni pwülüen pwiüm, pun ka turunufasei pwiüm ren. ");
INSERT INTO chk_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Iwe, kosap pwülüenifengeni eman fefin me nöün föpwül, kosap pwal lisowu ngeni nöün nöün neminewe mwän föpwül ika nöün nöün fefin föpwül, pun ir fitukfengen. Ei sokun föför a fokun ngau. ");
INSERT INTO chk_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kosap pwal angei pwin pwülüom pwe kopwe eäni aruu, lupwen pwülüom a chüen manau. ");
INSERT INTO chk_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Iwe, kosap oror ngeni eman fefin pwe kopwe lisowu ngeni, lupwen neminewe a limengau ren an samaun fefin. ");
INSERT INTO chk_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Kosap pwal lisowu ngeni pwülüen chon arum, pun ei sokun föför kopwe püsin limengau ren. ");
INSERT INTO chk_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Iwe, kosap eäni asor eman noum ngeni ewe kot itan Molok. Ren ei ka turunufasei itei, pun ngang ewe Samol mi Lapalap om we Kot. ");
INSERT INTO chk_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Kosap lisowu ngeni eman mwän usun om lisowu ngeni eman fefin, pun ei sokun föför a anioput. ");
INSERT INTO chk_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kosap pwal lisowu ngeni eman man, pun ei sokun föför kopwe püsin limengau ren. Iwe, eman fefin esap pwal mwüt ngeni inisin eman man pwe epwe lisowu ngeni, pun ei sokun föför a fokun ngau o ässäw. ");
INSERT INTO chk_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Iwe, ousap püsin alimengauakemi ren ekei sokun föför. Pun aramasen ekewe mwü üpwe asürela me mwemi ra alimengaueer ren ekei föför. ");
INSERT INTO chk_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Pwal ewe fanü a limengau ren. Iei mine üpwe apwüngü ewe fanü, pwe epwe musäsinawu ekewe aramas mi nonom won. ");
INSERT INTO chk_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Nge ämi oupwe apwönüetä ai kewe allük me pwüüng, pwe ousap föri och seni ekei föför mi anioput, sap eman leimi ika eman chon ekis mi nom remi. ");
INSERT INTO chk_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Pun ekewe aramas mi nom mwemi lon ewe fanü ra föri ekei sokun föför mi anioput meinisin. Iei mine ewe fanü a limengau ren. ");
INSERT INTO chk_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Iwe, are oua alimengaua ewe fanü, epwe pwal musäsinikemiiwu, usun a musäsinawu aramasen ekewe mwü mi akomw le nom lon ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Pun iö a föri eu me lein ekewe föför mi anioput, ewe aramas epwe käriwu me lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Iei mine oupwe apwönüetä ai allük ngenikemi, pwe ousap föri eu me lein ekewe föför mi anioput aramas ra piin föri mwen ämi tolong lon ei fanü. Ousap pwal fokun alimengauakemi ren ekei föför, pun ngang ewe Samol mi Lapalap ämi we Kot.” ");
INSERT INTO chk_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","pwe epwe üreni ekewe chon Israel meinisin, “Ämi oupwe pin, pun ngang ewe Samol mi Lapalap ämi Kot üa pin. ");
INSERT INTO chk_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Iteiten eman me eman epwe meniniti inan me seman. Oupwe pinini ai kewe ränin sapat, pun ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ousap kul seniei o fel ngeni uluulun anümwäl, ousap pwal föri fän itemi uluulun kot seni mächä, pun ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Lupwen oupwe eäni asoren kinamwe ngeniei ngang ewe Samol mi Lapalap, oupwe föri pwüngün ewe asor, pwe ngang üpwe etiwa. ");
INSERT INTO chk_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Oupwe ochoch ewe mönün asor oua eäni lon ewe chök rän ika sorotän ewe rän. Nge mine a lusun tori aülüngatin rän oupwe kenala. ");
INSERT INTO chk_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Iwe, are oupwe ochoch och seni ewe mönün asor lon aülüngatin rän, epwe eu föför mi anioput, ngang üsap etiwa ewe asor. ");
INSERT INTO chk_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Iteiten eman mi ochoch ei sokun asor epwe püsin angei chappen an föför pokiten an apiningaua eu mettoch mi pin me ren ewe Samol mi Lapalap. Iwe, ewe aramas epwe käriwu me lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Iwe, lupwen oupwe kini resin fanüemi, ousap kiniela uän tanipimi tori kiännin, ousap pwal rusifengeni mine a turutiu seni kiniemi wiich. ");
INSERT INTO chk_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ousap kiniela uän fotämi irän wain meinisin, ousap pwal rusi ekewe uän irän wain mi morotiu lon tanipimi. Oupwe likitirela fän iten ekewe chon wöüngau me ekewe chon ekis, pun ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ousap solä, ousap pwal atuputup ika chofana ngeni chon arumi. ");
INSERT INTO chk_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ousap akapelmwäli itei, pwe ousap apiningaua itei ren. Ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ousap ariaföüü chon arumi, ousap pwal angei och seni fän pöchökül. Ousap mwo nge amwöchü liwinin eman chon angang lon unusen eu pwin tori lesosor. ");
INSERT INTO chk_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ousap turunufasei eman mi selingepüng, ousap pwal likatupu eman mi mesechun. Nge oupwe meninitiei, pun ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ousap sorei mine a pwüng lon ämi kapwüng. Ousap peni eman mi wöüngau ika awina eman mi lap, nge oupwe eäni kapwüng ngeni chon arumi fän pwüng. ");
INSERT INTO chk_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ousap fetalfeil lein aramasemi o luapas, ousap pwal föri och mi afeiengau ngeni manauen chon arumi, pun ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Kosap oput pwiüm lon lelukom, nge kopwe fönöü chon arum, pwe kosap tolong lon tipis pokitan. ");
INSERT INTO chk_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kosap püsin ngeni ätewe mi tipis ngonuk chappen an föför, kosap pwal chou ngeni eman lein aramasom. Nge kopwe echeni chon arum usun püsin om echenuk, pun ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Iwe, kopwe aleasochisi ai kewe allük: Kosap apwüpwülüafengeni sokopaten man, kosap amora ruu sokun föün irä lon eu chök tanipi, kosap pwal üföüf echö üf seni ruu sokun kireen mangaku. ");
INSERT INTO chk_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Iwe, are eman mwän a lisowu ngeni eman amanau fefin mi fen kofot ngeni eman, nge neminewe esap mwo kamö, esap pwal mwo ngasala, epwe fokun fis kapwüng ngeniir, nge resap ninnila, pun neminewe esap mwo ngas. ");
INSERT INTO chk_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ewe mwän epwe uwato eman ätemwänin sip leasamalapen ewe imw mangaku ia aramas ra churiei ie, pwe an asoren pupungau ngeniei ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ren ei ätemwänin sip ewe souasor epwe föri asoren amusamusen tipis fän mesei ngang ewe Samol mi Lapalap fän iten än ewe mwän tipis. Iwe, ewe tipis ätewe a föri epwe mus seni. ");
INSERT INTO chk_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Lupwen oupwe tolong lon ewe fanü Kanaan o fotuki sokopaten irän mongö, ousap eni uar lon ükükün ülüngat ier, pun ra pin ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Iwe, lon ewe arüanün ier uar meinisin repwe eu asoren kilisou mi pin fän itei ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Nge lon ewe alimuen ier oua tongeni eni uar. Ren ei uän fotämi irä repwe chomongola. Ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ousap ochoch och fituk a chüen wor cha lon. Ousap föri angangen pwee ika pöüt. ");
INSERT INTO chk_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ousap pwal fichi meten möküren asen selingemi ika amocha alüsemi. ");
INSERT INTO chk_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ousap nekelekei inisimi fän iten mönümä, ousap ichi sokopaten lios womi. Ngang ewe Samol mi Lapalap. x Lif 21.5; Tut 14.1 ");
INSERT INTO chk_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Kosap turunufasei noum fefin ren om mwüt ngeni pwe epwe amömö inisin fän iten lisowu, pwe ewe fanü esap wiliti fanüen chon lisowu, esap pwal uren föföringau. ");
INSERT INTO chk_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kopwe pinini ai ränin sapat o meniniti imwei mi pin. Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Kosap feila ren watawa ika ren sourong, kosap angei ar öüröür, pwe kosap limengau rer. Ngang ewe Samol mi Lapalap om we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Kopwe ütä me mwen eman mi pwech möküran o asamolu ekewe chinlap, kopwe meninitiei ngang ewe Samol mi Lapalap om we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Iwe, lupwen eman chon ekis a wasöla lon fanüemi, ousap kirikiringau ngeni. ");
INSERT INTO chk_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ewe chon ekis mi nom remi epwe usun chök eman re wilipos leimi. Kopwe echeni i usun püsin om echenuk, pun ämi oua fen piin wasöla lon ewe fanü Isip. Ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Iwe, ousap eäni sokun aükük mi solä, lupwen oua aükük langatam, chou ika iteit. ");
INSERT INTO chk_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Oupwe nöünöü kilo me föün kilo mi pwüngüöch, pwal eu aükük mi pwüngüöch. Ngang ewe Samol mi Lapalap ämi we Kot mi emwenikemiiwu seni ewe fanü Isip. ");
INSERT INTO chk_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Iwe, oupwe aleasochisi ai kewe allük me pwüüng meinisin o apwönüretä: Ngang ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","pwe epwe üreni ekewe aramasen Israel, “Are eman me lein ekewe aramasen Israel ika eman me lein ekewe chon ekis mi nom lon Israel epwe eäni asor eman nöün ngeni Molok, epwe fokun ninnila. Iwe, aramasen ewe fanü repwe monei ngeni fau. ");
INSERT INTO chk_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Püsin ngang üpwe ü ngeni ewe aramas o ärawu me lein aramasan, pun a eäni asor ngeni Molok eman nöün. Ren ei a pwal apiningaua imwei mi pin o turunufasei itei mi pin. ");
INSERT INTO chk_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Nge are aramasen ewe fanü ra ömönüngau seni föförün ätewe mi eäni asor nöün ngeni Molok pwe resap niela, ");
INSERT INTO chk_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","püsin ngang üpwe ü ngeni ewe aramas me an famili o ärirewu me lein aramaser. Iwe, üpwe ärawu ätewe me chokewe meinisin mi eti le fel ngeni Molok. ");
INSERT INTO chk_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Iwe, are eman aramas a feila ren watawa me sourong pwe epwe angei an öüröür seniir, ngang üpwe ü ngeni ewe aramas o ärawu me lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Iei mine oupwe püsin apinikemi pwe oupwe pin, pun ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Oupwe aleasochisi ai kewe allük o apwönüretä. Ngang ewe Samol mi Lapalap üa apinikemi. ");
INSERT INTO chk_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Iteiten eman me eman mi otteki saman ika inan epwe fokun ninnila. Pokiten an otteki saman ika inan chan epwe ukan chök. ");
INSERT INTO chk_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Iwe, are eman mwän a lisowu ngeni pwülüen chon arun, ir me ruoman, ewe mwän me ewe fefin, repwe ninnila. ");
INSERT INTO chk_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Eman mwän mi lisowu ngeni pwülüen saman a turunufasei saman. Ir me ruoman repwe ninnila, nge char epwe uker chök. ");
INSERT INTO chk_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Are eman a lisowu ngeni pwülüen nöün mwän, ir me ruoman repwe ninnila. Ra föri tipisin lisowu lefilen märär, char epwe uker chök. ");
INSERT INTO chk_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Nge are eman mwän a lisowu ngeni eman mwän usun chök an lisowu ngeni eman fefin, ir me ruoman ra föri och föför mi anioput. Iwe, repwe ninnila, nge char epwe uker chök. ");
INSERT INTO chk_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Are eman mwän a pwülüenifengeni eman fefin me inan, ei föför a fokun ngau. Iwe, ewe mwän me ekewe ruoman fefin repwe kek, pwe esap wor föföringau leimi. ");
INSERT INTO chk_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Nge are eman mwän a kon ren eman man, ewe mwän epwe ninnila. Oupwe pwal niela ewe man. ");
INSERT INTO chk_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Are eman fefin a oror ngeni eman man pwe epwe lisowu ngeni, ewe fefin me ewe man repwe ninnila, nge char epwe uker chök. ");
INSERT INTO chk_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Iwe, are eman mwän a pwülüeni fefinan, ese lifilifil ika nöün saman ika nöün inan, nge ra künafengeni selelar, ei eu föför repwe säw ren fän mesen aramas. Iwe, repwe käriwu seni aramaser. Ewe mwän a lisowu ngeni fefinan, iei mine epwe angei chappen an föföringau. ");
INSERT INTO chk_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Nge are eman mwän a kon ren eman fefin lupwen an samaun fefin o lisowu ngeni, ätewe a pwärala lenien samaun neminewe, nge neminewe a apwälai lenien an samau. Iei mine ir me ruoman repwe käriwu me lein aramaser. ");
INSERT INTO chk_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Iwe, kosap lisowu ngeni pwin inom ika fefinen semom, pun ren ei föför ka aseleloi fitukom. Ir me ruoman repwe angei chappen ar föföringau. ");
INSERT INTO chk_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Are eman mwän a kon ren pwülüen pwin saman ika pwülüen mwänin inan, a turunufasei pwin saman ika mwänin inan. Iwe, ir me ruoman repwe angei chappen ar föför, pun repwe mäla, nge esap wor nöür. ");
INSERT INTO chk_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Nge are eman mwän a pwülüeni pwülüen pwin, ei föför a fokun ngau. Ätewe a turunufasei pwin, iei popun esap wor nöür. ");
INSERT INTO chk_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Iei mine oupwe aleasochisi ai kewe allük me pwüüng meinisin pwe oupwe föriir. Are oua föri iei usun, ewe fanü Kanaan ia üpwe emwenikemiilong ie esap musäsinikemiiwu. ");
INSERT INTO chk_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ousap angei örünien chon ekewe mwü üpwe asürela me mwemi. Pun ir ra föri ekei mettoch meinisin, iei mine ngang üa fokun oputeer. ");
INSERT INTO chk_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Nge üa pwon ngenikemi pwe üpwe ngenikemi fanüer pwe oupwe fanüeni, ewe fanü mi pwülüöch o fanüeräs. Ngang ewe Samol mi Lapalap ämi we Kot üa aimwükemiila seni chon ekewe mwü. ");
INSERT INTO chk_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Iei mine oupwe fokun alefila lefilen man mi limöch me man mi limengau, pwal lefilen machang mi limengau me machang mi limöch. Ousap alimengauakemi ren ämi ochoch man ika machang ika sokopaten man mi tö won pwül, pun üa aimwürela pwe repwe limengau me remi. ");
INSERT INTO chk_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ämi oupwe pin fän itei, pun ngang ewe Samol mi Lapalap üa pin. Üa aimwükemiila seni chon ekewe mwü pwe oupwe nei. ");
INSERT INTO chk_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Iwe, eman mwän ika eman fefin i watawa ika sourong epwe ninnila. Oupwe monei ngeni fau, nge chan epwe ukun chök.” ");
INSERT INTO chk_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, “Kopwe üreni ekewe souasor nöün Aaron kewe mwän, pwe esap wor eman me leir epwe püsin alimengaua ren somän märärin, ");
INSERT INTO chk_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","chilon chök ren somän fitukan: inan, saman, nöün mwän, nöün fefin, pwin ");
INSERT INTO chk_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ika ren fefinan esamwo wor pwülüan mi nom lon imwan. ");
INSERT INTO chk_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Esap fokun püsin alimengaua ren somän aramasen pwülüan, pwe esap apiningaua wisan. ");
INSERT INTO chk_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Iwe, ekewe souasor resap tongeni reipöpöla ulungen mökürer ika amwocha alüser, resap pwal tongeni nekelekei inisir, lupwen ra letipeta. ");
INSERT INTO chk_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Iwe, repwe pin fän itei, nge resap aitengaua itei. Pun ir ra eäni ewe asoren mongö ngeniei ngang ewe Samol mi Lapalap. Iei mine ekewe souasor repwe pin. ");
INSERT INTO chk_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Resap pwüpwülü ngeni fin lisowu ika fefin ra piin tori mwän, resap pwal pwüpwülü ngeni fefin mi mwü seni pwülüer. Pun ekewe souasor ra pin fän itei. ");
INSERT INTO chk_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Iei mine ekewe aramas repwe föri met ewe souasor epwe pin me rer, pun a eäni ewe asoren mongö ngeniei. Ngang ewe Samol mi Lapalap üa pin, üa pwal apinikemi. ");
INSERT INTO chk_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Iwe, are eman fefin nöün eman souasor a püsin alimengaua ren an amömö inisin fän iten lisowu, a aitengaua saman. Iwe, neminewe epwe kek. ");
INSERT INTO chk_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Iwe, ewe souasor mi lap me lein pwin kana, a kepit möküran ren lö o apinipin pwe epwe üföüf ekewe üf mi pin, esap atorongaua möküran ika kamwei üfan, lupwen a letipeta. ");
INSERT INTO chk_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ewe souasor mi lap esap fokun kaneto ren eman somä, sap mwo nge ren somän saman ika inan, pwe esap limengau ren. ");
INSERT INTO chk_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Esap fokun towu seni ewe imw mi pin, esap pwal apiningaua imwei mi pin, pun a apinipin ren ai we löön epit: Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Iwe, epwe chök pwüpwülü ngeni eman fefin esamwo tori mwän. ");
INSERT INTO chk_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Esap pwüpwülü ngeni eman fefin mi mä pwülüan ika eman mi mwü seni pwülüan, esap pwal pwüpwülü ngeni eman fefin a piin tori mwän ika eman fefin mi amömö inisin fän iten lisowu. Nge epwe chök angei eman pwülüan, eman fefin esap mwo tori mwän seni me lein aramasan, ");
INSERT INTO chk_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","pwe esap atolonga nöün kewe lon tettelin chon limengau me lein aramasan. Pun ngang ewe Samol mi Lapalap üa apini pwe epwe souasor mi lap.” ");
INSERT INTO chk_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Iwe, ewe Samol mi Lapalap a pwal kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Kopwe üreni Aaron: Esap wor eman me lein mwirimwirum kana mi wor terin epwe kaneto pwe epwe eäni asoren mongö ngeniei. Ei epwe fis seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Pun esap wor eman mi mesechun ika mwen, are eman a ter won mesan ika a timwo, epwe föri ewe angangen asor, ");
INSERT INTO chk_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","sap pwal eman a ter efoch pechen ika efoch pöün, ");
INSERT INTO chk_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","are a chuk sökürün ika ningenge, are a ülen ik lon mesan ika kilingau mi pwerik ika fas, are fokun. ");
INSERT INTO chk_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Esap fokun wor eman mwirimwirin ewe souasor Aaron epwe eäni ekewe asor ngeniei, are a wor terin. Pokiten a wor terin, esap tongeni eäni asoren mongö ngeniei. ");
INSERT INTO chk_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","A tongeni mongö seni ewe asoren mongö aramas ra uwato fän itei, ewe asoren mongö mi unusen pin pwal ewe mi pin. ");
INSERT INTO chk_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nge esap tongeni kan ngeni ewe chechen lefil ika ewe rongen asor, pokiten a wor terin, pwe esap apiningaua imwei mi pin. Pun ngang ewe Samol mi Lapalap üa apini ekewe mettoch.” ");
INSERT INTO chk_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mürin, Moses a asile ngeni Aaron me nöün kewe mwän pwal ngeni aramasen Israel meinisin ekei kapas meinisin. ");
INSERT INTO chk_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Kopwe üreni Aaron me nöün kewe mwän pwe repwe tümwünüöchüür ren ekewe asor mi pin ekewe chon Israel ra apini fän itei, pwe resap aitengaua itei mi pin: Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Iwe, kopwe üreniir, ‘Are eman me lein mwirimwirimi a kan ngeni ekewe asor mi pin ekewe aramasen Israel ra apini fän itei, lupwen a wor an limengau, ewe aramas esap chüen tongeni föri ewe angangen souasor. Ei epwe fis seni eu täppin aramas tori eu täppin. Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Iwe, are eman mwirimwirin Aaron a üri kilingau mi afeiengau ika a pu seni och chönü, esap tongeni mongö seni ekewe asor mi pin tori a limöchsefäl. Eman souasor mi atapa och mettoch mi limengau, pun a torii somä, ika a atapa eman mwän mi towu seni ewe chan mwän, i epwe limengau. ");
INSERT INTO chk_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Nge are eman souasor a atapa sokun mantötö mi limengau, ika a atapa eman aramas mi limengau, ese lifilifil met sokun an limengau, ");
INSERT INTO chk_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ätewe mi atapa ei sokun limengau epwe limengau tori lekuniol. Iwe, esap tongeni mongö seni ekewe asor mi pin, are esap akomw le tütü. ");
INSERT INTO chk_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Nge lupwen akkar a tuputiu, epwe limöch. Mürin a tongeni mongö seni ekewe asor mi pin, pun ekei asor anan. ");
INSERT INTO chk_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Iwe, esap ochoch eman man mi püsin mäla ika eman mi mäla ren manmwacho, pun epwe limengau ren: Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ekewe souasor meinisin repwe apwönüetä ai kewe allük, pwe resap atoto tipis wor o mäla pokiten ar lükümach ngeni ai kewe allük. Ngang ewe Samol mi Lapalap üa apiniir. ");
INSERT INTO chk_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Iwe, esap wor eman me lükün familien ewe souasor a tongeni mongö seni ewe asor mi pin, sap mwo nge eman wasölan ewe souasor ika eman nöün chon angang mi mö a tongeni mongö seni. ");
INSERT INTO chk_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Nge are eman souasor a möni ren moni eman amanau pwe nöün, ika eman amanau a uputiu lon imwan, ätewe epwe tongeni mongö seni enen ewe souasor. ");
INSERT INTO chk_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Iwe, are nöün eman souasor fefin a pwüpwülüwu lükün an ainang, neminewe esap tongeni mongö seni ekewe asor mi pin. ");
INSERT INTO chk_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Nge are eman fefin nöün eman souasor a mä pwülüan ika mwü seni pwülüan, esap pwal wor nöün, are a liwiniti imwen saman pwe a usun chök lekükünün, neminewe a tongeni mongö seni enen saman. Nge eman me lükün familien ewe souasor esap tongeni mongö seni. ");
INSERT INTO chk_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Iwe, are eman aramas lükün familien souasor a mongö och seni ewe asor mi pin fän chechengau, ätewe epwe uwato siwilin ren ewe souasor, nge epwe pacheetä eu lelimu ngeni mine a angei. ");
INSERT INTO chk_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Iwe, ekewe souasor resap fokun apiningaua än ekewe aramasen Israel asor mi pin ra eäni asor ngeniei ");
INSERT INTO chk_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ren ar mwüt ngeni ekewe aramas pwe repwe mongö seni ekewe asor mi pin. Ren ei repwe atoto tipis me pupungau wor. Pun ngang ewe Samol mi Lapalap üa apini ekewe asor.’” ");
INSERT INTO chk_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Iwe, ewe Samol mi Lapalap a pwal kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","pwe epwe ngeni Aaron me nöün kewe mwän pwal ekewe aramasen Israel meinisin ekei allük: Are eman me lein chon Israel ika eman me lein ekewe chon ekis mi wasöla lon Israel a uwato an asor ngeni ewe Samol mi Lapalap, ese lifilifil ika mön eu pwon ika eu asor seni püsin letipan pwe eu asoren kek, ");
INSERT INTO chk_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","epwe chök uwato eman ätemwänin kow ika sip ika kuuch esap wor terin, pwe Kot epwe etiwa. ");
INSERT INTO chk_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Iwe, ousap eäni asor eman man a wor terin, pun Kot esap etiwa ei sokun asor senikemi. ");
INSERT INTO chk_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Nge are eman a eäni asor eu asoren kinamwe ngeni ewe Samol mi Lapalap, pwe epwe apwönüetä an pwon ika epwe chök asor seni püsin letipan, epwe uwato seni lein nöün kow ika sip eman man mi mürina, esap fokun wor terin, pwe Kot epwe etiwa. ");
INSERT INTO chk_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Iwe, ousap eäni asor ngeni ewe Samol mi Lapalap eman man mi chun ika ter ika pök, ousap pwal uwato eman mi pu seni och chönü ika kilingau ika fas. Ousap eäniir le asor won ewe rongen asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Iwe, eman kow ika eman sip mi wor efoch pechen a kon langatam ika mochomoch oua tongeni uwato fän iten asor seni püsin letipemi. Nge ei sokun man esap tufich ngeni asoren pwon. ");
INSERT INTO chk_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ousap eäni asor ngeni ewe Samol mi Lapalap eman man mi mwochol föün ochoun ika pachach ika pök ika kinas. Ousap fokun föri ei sokun lapalap lon fanüemi. ");
INSERT INTO chk_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ousap pwal eäni asor ei sokun man oua angei me ren eman chon ekis pwe asoren mongö ngeni ämi Kot. Iwe, a wor terir, iei mine Kot esap etiwa ewe asor senikemi. ");
INSERT INTO chk_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük: ");
INSERT INTO chk_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Are a uputiu eman apanen kow ika sip ika kuuch, ewe apanan epwe nom ren inelapan lon ükükün fisu rän. Nge seni ewe awaluen rän oua tufichin eäni asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Iwe, ese lifilifil ika ewe inelap eman kow ika eman sip, ousap nipökü ewe inelap me apanan lon eu chök rän. ");
INSERT INTO chk_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Are oua eäni asor eu asoren kilisou ngeni ewe Samol mi Lapalap, oupwe asor lon pwüngüöchün ewe angang, pwe Kot epwe etiwakemi. ");
INSERT INTO chk_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Oupwe ochoch ewe mönün asor lon ewe chök rän oua eäni asor, nge ousap likiti och tori lesosor. ");
INSERT INTO chk_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Iei alon ewe Samol mi Lapalap, “Oupwe aleasochisi ai kewe allük o föriir. Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ousap aitengaua itei mi pin, pun ngang üpwe pin me ren ekewe aramasen Israel. Ngang ewe Samol mi Lapalap mi apinikemi. ");
INSERT INTO chk_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Üa emwenikemiiwu seni ewe fanü Isip pwe üpwe ämi Kot: Ngang ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Iwe, ewe Samol mi Lapalap a ngeni Moses ");
INSERT INTO chk_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","ekei allük fän iten ekewe chulap mi kefilitä, lupwen ekewe aramasen Israel repwe mwichefengen o fel ngeni: ");
INSERT INTO chk_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Lon ükükün wonu rän oupwe angang, nge ewe afisuen rän eu ränin sapat ränin asösö mi pin, eu fansoun mwich mi pin. Ousap föri och angang lon, pun eu ränin sapat fän iten ewe Samol mi Lapalap lon leniemi meinisin. ");
INSERT INTO chk_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ikkei ekewe chulap mi kefilitä me ren ewe Samol mi Lapalap, ekewe fansoun mwich mi pin, oupwe asilefeili lon ekewe fansoun ra kefilitä. ");
INSERT INTO chk_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Iwe, lekuniolun ewe engol me rüanün ränin ewe aeuin maram epwe fis än ewe Samol mi Lapalap Pasofer. ");
INSERT INTO chk_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Nge lon engol me limuen ränin ewe chök maram epwe fis än ewe Samol mi Lapalap we chulapen mongö pilawa esap wor iis lon. Lon ükükün fisu rän oupwe mongö pilawa esap wor iis lon. ");
INSERT INTO chk_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Iwe, lon aeuin rän oupwe afisi eu mwich mi pin. Ousap föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Lon iteiten ekewe fisu rän oupwe eäni eu asor ngeni ewe Samol mi Lapalap. Nge lon ewe afisuen rän oupwe pwal afisi eu mwich mi pin. Ousap föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","pwe epwe üreni ekewe aramasen Israel: Lupwen oupwe tolong lon ewe fanü, ewe Samol mi Lapalap epwe ngenikemi, o kini uan, oupwe uwato epilük mwen kiniemi uän wiich ren ewe souasor. ");
INSERT INTO chk_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Iwe, ewe souasor epwe assawa ewe pilük fän mesen ewe Samol mi Lapalap sorotän ewe ränin sapat, pwe Kot epwe etiwakemi. ");
INSERT INTO chk_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Lon ewe ränin ämi oupwe assawa ewe pilük, oupwe pwal eäni asor eman ätemwänin lam eu ierin esap wor terin, pwe eu asoren kek ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Iwe, oupwe afiti ngeni rüanü paun pilawa mi amas o mürina pwe asoren mongö, epwe pwal nofitfengen me apüra. Ei epwe eu asor ewe Samol mi Lapalap a efich pwoon. Nge oupwe pwal afiti ngeni eu kuoch wain pwe asoren ün. ");
INSERT INTO chk_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ousap fokun mongö pilawa ika föün irän wiich mi tüün ika föün mi fö tori ewe chök rän oua uwato ei asor ngeni Kot. Ei epwe eu allük oupwe apwönüetä ämi me mwirimwirimi kana seni eu täppin aramas tori eu täppin lon leniemi meinisin. ");
INSERT INTO chk_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Iwe, oupwe aleani ükükün fisu wik seni sorotän ewe ränin sapat, ewe rän oua uwato ewe pilük fän iten asoren assaw. ");
INSERT INTO chk_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Lon alimeen rän, sorotän ewe afisuen sapat, oupwe uwato ren ewe Samol mi Lapalap pwal eu asoren mongö seni ekewe föün irän wiich mi fö. ");
INSERT INTO chk_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Oupwe uwato seni lon en me imwan ruofoch pilawa pwe repwe assaw. Ekewe pilawa repwe för seni rüanü paun pilawa mi amas o mürina, repwe um fiti iis, pwe ämi mwen ua ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Oupwe pwal afiti ngeni ewe pilawa füman lam eu ierir esap wor terir, pwal eman nienifön ätemwänin kow me ruoman ätemwänin sip. Ekei man repwe eu asoren kek ngeni ewe Samol mi Lapalap fiti ämi asoren mongö me asoren ün. Ei epwe eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Oupwe pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, me ruoman ätemwänin lam eu ierir pwe asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Iwe, ewe souasor epwe assawa ekewe ruoman lam fitifengen me ewe pilawan mwen ua, pwe eu asoren assaw fän mesen ewe Samol mi Lapalap. Ekei asor repwe pin me ren ewe Samol mi Lapalap fän iten ewe souasor. ");
INSERT INTO chk_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Iwe, lon ewe chök ränin oupwe asilefeili pwe epwe fis eu mwich mi pin. Ousap föri och angang lon. Iei eu allük mwirimwirimi kana repwe apwönüetä seni eu täppin aramas tori eu täppin lon leniemi meinisin. ");
INSERT INTO chk_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Iwe, lupwen oupwe kini resin fanüemi, ousap kiniela uän tanipimi tori kiännin, ousap pwal rusifengeni mine a turutiu seni kiniemi wiich. Iwe, oupwe likitirela fän iten chon wöüngau me chon ekis. I ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","pwe epwe üreni ekewe aramasen Israel: Lon aeuin ränin ewe afisuen maram oupwe afisi eu ränin asösö mi pin, eu ränin achem fiti tikin rappwa, eu fansoun mwich mi pin. ");
INSERT INTO chk_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ousap föri och angang lon, nge oupwe eäni eu asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük: ");
INSERT INTO chk_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Lon aengolun ränin ei afisuen maram epwe fis ewe ränin ächächä. Iwe, epwe eu fansoun mwich mi pin fän itemi, nge oupwe echikefel o eäni asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ousap föri och angang lon ewe rän, pun eu ränin ächächä, pwe epwe fis asoren amusamusen tipis fän itemi fän mesen ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Nge iö esap echikefel epwe käriwu seni lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Are eman epwe föri och angang lon ewe chök rän, ewe Samol mi Lapalap epwe afeiengaua ewe aramas me lein aramasan. ");
INSERT INTO chk_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ousap fokun föri och angang. Iei eu allük oupwe apwönüetä, ämi me mwirimwirimi kana, seni eu täppin aramas tori eu täppin lon leniemi meinisin. ");
INSERT INTO chk_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ei rän epwe eu ränin asösön sapat mi pin, ämi oupwe echikefel lon. Seni lekuniolun ewe atiuen ränin ewe maram tori lekuniolun sorotan oupwe apwönüetä ämi asösön sapat. ");
INSERT INTO chk_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Iwe, ewe Samol mi Lapalap a ngeni Moses ekei allük ");
INSERT INTO chk_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","fän iten ekewe aramasen Israel: Lon engol me limuen ränin ewe afisuen maram epwe fis ewe chulapen likachoch ngeni ewe Samol mi Lapalap lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Lon aeuin rän epwe fis eu mwich mi pin. Ousap föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Iwe, lon ükükün fisu rän oupwe eäni asor ngeni ewe Samol mi Lapalap. Nge lon awaluen rän oupwe föri eu mwich mi pin o eäni asor ngeni ewe Samol mi Lapalap. Ei mwich a fokun aüchea. Ousap föri och angang lon ewe rän. ");
INSERT INTO chk_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ikkei ekewe chulap mi kefilitä me ren ewe Samol mi Lapalap. Oupwe asilefeiliir pwe fansoun mwich mi pin fän iten eäni asor ngeni ewe Samol mi Lapalap, ekewe asoren kek me asoren mongö, sokun asor me asoren ün lon akoten pwüngün fän iten eu me eu rän. ");
INSERT INTO chk_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ekei chulap me ekei asor repwe fis lükün än ewe Samol mi Lapalap kewe ränin sapat, pwal lükün ämi lifang, ämi asoren pwon me ämi asor meinisin seni püsin letipemi, oua fang ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Nge lon engol me limuen ränin ewe afisuen maram, lupwen oua wes me ionifengeni uän fanüemi, oupwe pwal föri eu chulap ngeni ewe Samol mi Lapalap lon ükükün fisu rän. Iwe, ewe aeuin rän epwe eu ränin asösö mi pin, nge ewe awaluen rän epwe pwal eu ränin asösö mi pin. ");
INSERT INTO chk_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Lon aeuin rän oupwe angei uän irä mi mürina, pan irä palm, pan irä mi muresires, pwal palen ewe irä itan willow mi mär lükün chanpupu. Iwe, oupwe fokun pwapwa fän mesen ewe Samol mi Lapalap ämi we Kot lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Iteiten ier oupwe föri ei chulap ngeni ewe Samol mi Lapalap lon ükükün fisu rän. Iei eu allük fän itemi me mwirimwirimi seni eu täppin aramas tori eu täppin. Iwe, oupwe föri ewe chulap lon ewe afisuen maram. ");
INSERT INTO chk_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Iwe, chon wiliposun Israel meinisin repwe imweimw likachoch lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","pwe mwirimwirimi repwe silei pwe ewe Samol mi Lapalap a üreni ekewe aramasen Israel pwe repwe imweimw likachoch, lupwen a emwenirewu seni ewe fanü Isip. I ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Iei usun Moses a asile ngeni ekewe aramasen Israel ekewe allük usun än ewe Samol mi Lapalap kewe chulap mi kefilitä, pwe repwe apwönüretä. ");
INSERT INTO chk_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","pwe epwe allük ngeni ekewe aramasen Israel, pwe repwe uwato noppuk mi mürina seni föün olif mi üsüs fän iten ekewe lamp lon ewe imwenfel seni mangaku, pwe repwe tittin fochofoch. ");
INSERT INTO chk_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Iwe, Aaron epwe tümwünüfochei ekewe lamp fän mesen ewe Samol mi Lapalap, pwe repwe tin seni lekuniol tori lesosor lükün ewe cheech mi refiela ewe pworofel lon ewe leni mi unusen pin. Ei epwe eu allük fän itan me mwirimwirin kana seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron epwe tümwünüfochei ekewe lamp mi nom won ewe lenien atittin a för seni kolt mi mürina pwe repwe tin fochofoch me fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Iwe, kopwe angei rüe me rüanü paun pilawa mi amas o mürina pwe kopwe umuni engol me ruoföü pilawa seni. ");
INSERT INTO chk_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Kopwe atetteliir lon ruu tettel won ewe chepel mi för seni kolt mi mürina a nom fän mesen ewe Samol mi Lapalap, akawonoföü repwe nom won eu tettel. ");
INSERT INTO chk_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kopwe pwal iseis ren eu me eu tettel apach mi pwokus o mürina, pwe eu kinikinin ewe asoren mongö akasiwilin ewe pilawa, pwe epwe eu asor epwe kek ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Iteiten ränin sapat Aaron epwe atettelöchü ewe pilawa fän mesen ewe Samol mi Lapalap. Ekei pilawa ekewe aramasen Israel repwe wisen awora iteiten fansoun. ");
INSERT INTO chk_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Iwe, ekewe pilawa enen Aaron me nöün kewe mwän, repwe mongö lon eu leni mi pin. Pun ewe pilawa eu kinikin mi unusen pin seni ekewe asor ngeni ewe Samol mi Lapalap fän iten ekewe souasor.” ");
INSERT INTO chk_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Iwe, a wor eman mwän nöün eman fin Israel, nge saman eman re Isip. Ätei a feila lein chon Israel o anini ngeni eman wesewesen re Israel me lon ewe leni ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Nge lon ar anini nöün ewe fin Israel we mwän a turunufasei iten ewe Samol mi Lapalap le ottek. Iei mine ra emwenato ren Moses. (Iwe, iten inan we Selomit nöün Tepri fefin seni ewe ainangen Tan.) ");
INSERT INTO chk_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Iwe, ra kalapusei tori repwe silei letipen ewe Samol mi Lapalap fän itan. ");
INSERT INTO chk_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Mürin, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Kopwe emwenawu ätewe mi ottek lükün ewe leni ia oua nonom ie. Nge meinisin mi rong an fos repwe iseis pöür won möküran, pwe asisilen ar atipisi. Mürin ekewe chon Israel meinisin repwe monei ngeni fau. ");
INSERT INTO chk_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Kopwe üreni ekewe aramasen Israel: Iö a otteki Kot epwe angei liwinin an tipis. ");
INSERT INTO chk_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Nge iö a turunufasei iten ewe Samol mi Lapalap epwe ninnila. Ekewe chon Israel meinisin repwe monei ngeni fau. Eman mi turunufasei ewe it mi pin epwe ninnila, ese lifilifil ika i eman chon ekis mi nom leimi ika eman chon wilipos. ");
INSERT INTO chk_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Iwe, eman mi niela eman aramas epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Nge eman mi niela nöün eman man, epwe akasiwili ewe man, pun manau akasiwilin manau. ");
INSERT INTO chk_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Iwe, are eman aramas a afeiengaua chon arun pwe a ter, epwe pwal fis ngeni usun mine a föri. ");
INSERT INTO chk_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Are eman a kupi chün eman, epwe pwal kupukup chün, are eman a afeiengaua mesen eman, mesan epwe pwal feiengau, nge are eman a tülü ngiin eman, ngiin epwe pwal tütül. Usun eman a afeiengaua eman aramas pwe a ter, iei usun epwe pwal fis ngeni. ");
INSERT INTO chk_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Eman mi niela nöün eman man epwe akasiwili ewe man, nge eman mi niela eman aramas epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Iwe, epwe wor eu chök allük fän iten chon ekis mi nom leimi me chon wilipos, pun ngang ewe Samol mi Lapalap ämi we Kot.” ");
INSERT INTO chk_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mürin än Moses üra ekei kapas ngeni ekewe aramasen Israel, ra emwenawu ätewe mi ottek lükün ewe ia ra nonom ie o monei ngeni fau tori a mäla. Iei usun ekewe aramasen Israel ra föri usun mine ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses me won ewe chuk Sinai o üreni, ");
INSERT INTO chk_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","pwe epwe ngeni ekewe aramasen Israel ekei allük: Lupwen oupwe tolong lon ewe fanü ewe Samol mi Lapalap epwe ngenikemi, epwe fis eu ierin sapat ngeni ewe Samol mi Lapalap won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Lon ükükün wonu ier oupwe fotuki fanüemi. Oupwe pwal pökütolei ämi tanipin wain o kini uan lon ükükün wonu ier. ");
INSERT INTO chk_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Nge lon ewe afisuen ier epwe fis eu ierin asösö won ewe fanü, eu ierin sapat ngeni ewe Samol mi Lapalap. Ousap fotuki fanüemi ika pökütolei ämi tanipin wain. ");
INSERT INTO chk_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ousap kini mine a püsin pwükütä, ousap pwal ionifengeni uän ekewe irän wain resap pökütol. Iwe, epwe fis eu ierin asösö won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Iwe, ewe fanü a fis ewe ierin sapat won epwe awora enemi mongö fän itemi me fän iten nöümi amanau mwän me fefin, fän iten nöümi chon angang mi mö pwal fän iten ekewe chon ekis mi nom remi. ");
INSERT INTO chk_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Epwe awora enen nöümi pwiin manfesir pwal enen ekewe manmwacho mi nom lon fanüemi, pun meinisin mine a püsin ua epwe fän iten mongö. ");
INSERT INTO chk_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Iwe, kopwe aleani fisu ierin sapat ika fisu alea ngeni fisu ier, pwe ükükün ekewe fisu ierin sapat repwe faik me tiu ier. ");
INSERT INTO chk_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Mürin, lon aengolun ränin ewe afisuen maram, lon ewe ränin ächächä, oupwe ettikifeili ewe rappwa mi tikimong lemenen unusen fanüemi. ");
INSERT INTO chk_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Oupwe apini ewe alimeen ier o asilefeili lemenen unusen fanüemi, pwe aramasan meinisin ra ngasala. Ei ier epwe eu ierin supili fän itemi, lupwen eman me eman leimi epwe angeisefäli püsin fanüan a amömö me lom, nge eman me eman amanau epwe liwiniti en me an famili. ");
INSERT INTO chk_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Iwe, ewe alimeen ier epwe eu ierin supili fän itemi. Ousap fofot, ousap pwal ionifengeni mine a püsin pwükütä, ousap pwal ionifengeni uän ekewe irän wain resap pökütol. ");
INSERT INTO chk_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Pun iei eu ierin supili epwe pin me remi. Oupwe chök mongö seni mine a püsin pwükütä me won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Iwe, lon ewe ierin supili eman me eman leimi epwe angeisefäli fanüan. ");
INSERT INTO chk_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nge are ka amömöla ngeni chon arum eu fanü ika möni seni chon arum eu fanü, ousap kirikiringaufengen lefilemi. ");
INSERT INTO chk_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Are kopwe möni seni chon arum eu fanü, kopwe liwini ngeni ükükün fitu ier mürin ewe supili, nge i epwe amömö ngonuk ükükün fitu ier ka tongeni kini uän irän ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Iwe, are ekewe ier ra chomong, liwinin ewe fanü epwe pwal watte. Nge are ekewe ier ra chokükün, liwinin epwe pwal kükün, pun chon arum epwe amömö ngonuk ükükün fitu ier ka tongeni kini uän irän ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ousap kirikiringaufengen lefilemi, nge oupwe meniniti ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Iei mine oupwe aleasochisi än ewe Samol mi Lapalap allük o apwönüetä an kewe pwüüng, pwe oupwe nonom lon ewe fanü fän kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Iwe, ewe fanü epwe efisätä ua, pwe ämi oupwe mongö o möt, oupwe pwal nonom lon ewe fanü fän kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Nge are oupwe ais, ‘Meta aipwe eni lon ewe afisuen ier, are aisap tongeni fofot ika ionifengeni uän ekewe irä?’ ");
INSERT INTO chk_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ewe Samol mi Lapalap epwe tinato an feiöch womi lon ewe awonuen ier, pwe ewe fanü epwe efisätä ua fän iten ükükün ülüngat ier. ");
INSERT INTO chk_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Nge are oupwe fofot lon ewe awaluen ier, oupwe chök chüen mongö ekewe uän lom oua kini lon ewe awonuen ier. Tori lon ewe atiuen ier, lupwen oupwe kini ekewe ua mi fö, oupwe chüen mongö ekewe uän lom. ");
INSERT INTO chk_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Iei mine ousap amömö ewe fanü tori feilfeilachök. Pun ei fanü fanüen Kot, nge ämi oua usun chök chon ekis me chon siamü won. ");
INSERT INTO chk_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ei allük a fän iten unusen ewe fanü oua fanüeni, pwe oupwe mwütätä ngeni ätewe a amömöla fanü pwe epwe fanüenisefäli. ");
INSERT INTO chk_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Iwe, are eman chon Israel a wöüngauala o amömöla eu kinikinin fanüan, eman fitukan epwe feito o mönisefäli mine pwin a amömöla. ");
INSERT INTO chk_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Nge are esap wor eman fitukan epwe tongeni möni, püsin i a tongeni mönisefäli, lupwen a wor an tufich. ");
INSERT INTO chk_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Iwe, epwe aleani ekewe ier seni ewe fansoun a amömöla ewe fanü o liwini ngeni ätewe a möni ewe fanü me mwan ükükün liwinin ekewe lusun ier tori ewe ierin supili. Mürin a tongeni fanüenisefäli fanüan. ");
INSERT INTO chk_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Nge are esap naf liwinin pwe epwe mönisefäli fanüan, ätewe mi möni epwe chök fanüeni tori ewe ierin supili. Iwe, lon ewe ierin supili ätewe mi amömöla ewe fanü me mwan epwe fanüenisefäli fanüan. ");
INSERT INTO chk_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Are eman aramas a amömöla imwan mi nom lon eu telinimw mi tit, a tongeni mönisefäli lon ünükün unusen eu ier mürin an amömöla. ");
INSERT INTO chk_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Nge ika esap mönisefäli lon ükükün unusen eu ier, ätewe mi möni ewe imw mi nom lon ewe telinimw mi tit epwe imweni, i me mwirimwirin kana seni eu täppin aramas tori eu täppin. Iwe, lon ewe ierin supili ewe imw esap liwiniti mine kaimwan. ");
INSERT INTO chk_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Nge ekewe imw mi nom lon sop resap tit repwe usun chök fanü. Iwe, aramas ra tongeni mönisefäliir, nge lon ewe ierin supili repwe liwiniti mine kaimwer. ");
INSERT INTO chk_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Nge chon ewe ainangen Lefi ra tongeni mönisefäli imwer mi nom lon ar kewe telinimw fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Iwe, are eman chon ewe ainangen Lefi esap mönisefäli imwan, ewe imw a amömöla lon ar ewe telinimw epwe liwinsefäl ngeni lon ewe ierin supili. Pun ekewe imw mi nom lon ekewe telinimwen chon ewe ainangen Lefi wesewesen imwer lein ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Nge ekewe fanü mi nom pwelin ünükün ar kewe telinimw resap fokun tongeni amömöla, pun ekei fanü fanüer tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Are eman pwiüm chon Israel a wöüngauala pwe esap chüen wor püsin an tufich, en kopwe atufichi, usun ka atufichi eman chon ekis ika eman wasöla, pwe epwe tongeni nomomola reöm won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Iwe, kosap angei manauen an liwinimang ngonuk. Nge kopwe niueiti om we Kot o mwüt ngeni pwiüm we chon Israel an epwe nonomola reöm won ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kosap ngeni pwiüm we chon Israel noum moni pwe kopwe angei seni manauan, kosap pwal amömö ngeni anom mongö pwe kopwe angei winom ren. ");
INSERT INTO chk_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ei allük än ewe Samol mi Lapalap ämi we Kot mi emwenikemiiwu seni ewe fanü Isip, pwe epwe ngenikemi ewe fanü Kanaan, epwe pwal ämi Kot. ");
INSERT INTO chk_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Are eman pwiüm chon Israel mi nom reöm a wöüngauala pwe a amömöla püsin inisin ngonuk, kosap anganga usun eman noum amanau. ");
INSERT INTO chk_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Epwe nom reöm usun eman chon angang mi mö ika usun eman wasöla. Epwe angang ngonuk tori ewe ierin supili. ");
INSERT INTO chk_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Mürin epwe feila senuk fiti nöün kana. Epwe liwiniti püsin an famili o liwinsefäliti fanüen saman. ");
INSERT INTO chk_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Pun ekewe chon Israel nöün ewe Samol mi Lapalap chon angang i a emwenirewu seni ewe fanü Isip. Kosap amömömörela pwe aramas repwe nöüniir amanau. ");
INSERT INTO chk_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kosap nemeni pwiüm we chon Israel fän pöchökül, nge kopwe niueiti om we Kot. ");
INSERT INTO chk_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Nge are oua mochen kamö mwän me fefin pwe oupwe nöüniir amanau, oua tongeni möniir seni ekewe mwü mi nom ünükümi. ");
INSERT INTO chk_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Oua pwal tongeni kamö nöümi chon angang me lein ekewe chon ekis mi wasöla remi, chokewe mi uputiu lon fanüemi. Ikkei ir oua tongeni nöüniir amanau. ");
INSERT INTO chk_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Iwe, oua tongeni eäniir amwirinimä ngeni nöümi kewe mwän pwe repwe nöüniir amanau tori ar mäla. Ikkei ir oua tongeni nöüniir amanau, nge pwimi kewe chon Israel ousap nemeniir fän pöchökül. ");
INSERT INTO chk_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Are eman chon ekis ika eman wasöla mi nom reöm a pisekisekila, nge pwiüm we chon Israel a wöüngauala pwe a amömöla püsin inisin ngeni ewe chon ekis ika ngeni eman eterekesin ewe chon ekis, ");
INSERT INTO chk_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","eman epwe tongeni mönisefäli mürin an amömöla püsin inisin. Iwe, eman me lein pwin kana a tongeni mönisefäli. ");
INSERT INTO chk_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Pwal pwin saman ika nöün pwin saman ika eman märärin seni an famili a tongeni mönisefäli. Nge are a pisekiseksefälila, a pwal tongeni püsin mönisefäli inisin. ");
INSERT INTO chk_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Iwe, repwe pwüngüpwüngfengen i me ätewe mi möni o alea seni ewe ier a amömöla püsin inisin ngeni tori ewe ierin supili. Iwe, liwinin an epwe ngasala epwe aükük ngeni iteiten ekewe ier. Nge ränin an nonom ren ätewe mi nöüni amanau repwe usun chök ränin eman chon angang mi mö. ");
INSERT INTO chk_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Are mi chüen wor chomong ier tori ewe ierin supili, ewe mi ngasala epwe mönätiu och kinikin mi watte me lon ewe moni, ewe eman mi nöüni amanau a püngütiu fän itan. ");
INSERT INTO chk_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Nge are ra chokükün ekewe ier tori ewe ierin supili, repwe pwüngüpwüngfengen me ätewe mi möni. Pun ükükün ekewe ier a angang ngeni epwe pwal kisikisila ewe moni epwe mönätiu fän iten an epwe ngasala. ");
INSERT INTO chk_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Iwe, epwe usun chök eman chon angang mi mö lon eu me eu ier. Ätewe mi nöüni amanau esap tongeni nemeni fän pöchökül. ");
INSERT INTO chk_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nge are esap mö lon ekei sokun lapalap, i me nöün kewe repwe ngasala lon ewe ierin supili. ");
INSERT INTO chk_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Pun ekewe aramasen Israel ir nöün ewe Samol mi Lapalap chon angang. Ir nöün chon angang a emwenirewu seni ewe fanü Isip: I ewe Samol mi Lapalap ar Kot. ");
INSERT INTO chk_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Iwe, ewe Samol mi Lapalap a apasa, “Ousap föri fän itemi uluulun anü, ousap aüetä uluulun anü ika ür, ousap pwal aüetä eföü fau mi auluul ngeni anü lon fanüemi pwe oupwe fel ngeni. Pun ngang ewe Samol mi Lapalap ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Oupwe apiniöchü ai kewe ränin sapat o meniniti imwei mi pin. Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Iwe, are oupwe apwönüetä ai kewe pwüüng o aleasochisi ai kewe allük, ");
INSERT INTO chk_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ngang üpwe ngenikemi üt lon fansoun öch, pwe irän ewe fanü repwe märitä o ua. ");
INSERT INTO chk_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Iwe, fansoun ämi wichi umwun wiich epwe soposopola tori fansoun ämi kini föün irän wain, nge fansoun ämi kini föün irän wain epwe soposopola tori fansoun ämi fofot. Iwe, epwe wor chomong enemi mongö, oupwe pwal nom lon fanüemi fän kinamwe. ");
INSERT INTO chk_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Üpwe fang ngenikemi kinamwe lon ewe fanü, oupwe konola o annut, nge esap wor eman epwe eniwokusukemi. Üpwe atoaua seni ewe fanü manmwacho, esap pwal chüen fis maun lon fanüemi. ");
INSERT INTO chk_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Oupwe tapweri chon oputakemi ren ketilas, nge ir repwe kuf remi. ");
INSERT INTO chk_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Iwe, limman senikemi repwe akufu ipükü, nge ipükü repwe akufu engol ngeröü. Iei usun chon oputakemi repwe kuf remi lon maun. ");
INSERT INTO chk_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Üpwe ümöümöch ngenikemi, üpwe aupukemi o achomongakemi, üpwe pwal apwönüetä ai pwon ngenikemi. ");
INSERT INTO chk_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Räsin fanüemi epwe fokun chomong, pwe oupwe chüen mongö mongön ewe ier a la tori oupwe aturala ewe mongö minen lom seni ämi lenien iseis, pwe epwe wor lenien ewe mongö mi fö. ");
INSERT INTO chk_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Iwe, üpwe imweimw lefilemi lon imwei mi pin, nge üsap oputakemi. ");
INSERT INTO chk_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Üpwe nonom remi pwe üpwe ämi Kot, nge ämi oupwe nei aramas. ");
INSERT INTO chk_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ngang ewe Samol mi Lapalap ämi we Kot, üa emwenikemiiwu seni ewe fanü Isip, pwe resap chüen nöünikemi amanau. Iwe, üa kupi ewe waas mi nom won afaremi, pwe oupwe wenetä le fetal.” ");
INSERT INTO chk_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Iwe, ewe Samol mi Lapalap a apasa, “Are ousap mochen aleasochisi aloi, ousap pwal apwönüetä ai kewe allük meinisin, ngang üpwe apwüngükemi. ");
INSERT INTO chk_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Are oua oput ai kewe pwüüng o purätiu ai kewe allük, are ousap apwönüetä ai kewe allük meinisin, pwe oua atai ai pwon ngenikemi, ");
INSERT INTO chk_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","iei usun mine üpwe föri ngenikemi: Üpwe awarakaieto womi niuokus watte, fius me pwichikar mi atopwala mesemi o akisikisala pöchökülen inisimi. Iwe, epwe solap ämi fofot, pun chon oputakemi repwe eni uän fotämi. ");
INSERT INTO chk_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Üpwe ü ngenikemi, nge oupwe kuf ren chon oputakemi. Chokewe mi oputakemi repwe nemenikemi. Iwe, ämi oupwe sü, ngei esap wor eman a tapwerikemi. ");
INSERT INTO chk_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Lupwen ekei feiengau ra torikemi, nge ousap mochen aleasochisi aloi, üpwe awatteloi ai apwüngükemi fän fisu pokiten ämi tipis. ");
INSERT INTO chk_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Iwe, üpwe aükätiu ämi lamalamtekia me ülöförea. Üpwe föri pwe üt esap püngütiu won fanüemi, nge ewe fanü epwe pwasapwas o pöchökül usun mächä. ");
INSERT INTO chk_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Epwe solapmwälila ämi pöchökül le angang ngeni ewe pwül, pun irän fanüemi resap mämäritä, resap pwal ua. ");
INSERT INTO chk_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Mürin, are oua chüen lükümach ngeniei pwe ousap mochen aleasochisi aloi, üpwe awatteloi ämi riaföü, pwe epwe fän fisu lap seni me mwan pokiten ämi tipis. ");
INSERT INTO chk_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Iwe, üpwe tinala ekewe manmwacho pwe repwe afeiengauakemi. Repwe niela nöümi semirit o ochei nöümi man, repwe pwal achokisikisikemiila pwe alen fanüemi repwe pönüla. ");
INSERT INTO chk_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Are üpwe apwüngükemi iei usun, nge ousap kul ngeniei, pwe oua chüen ü ngeniei, ");
INSERT INTO chk_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","mürin ngang üpwe pwal ü ngenikemi o afeiengauakemi fän fisu lap seni me mwan pokiten ämi tipis. ");
INSERT INTO chk_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Üpwe awarato maun womi, pwe iei chappen ämi atai ewe pwon. Nge are oua sülong lon ämi kewe telinimw, üpwe tinala mätter leimi. Oupwe tolong fän nemenien chon oputakemi. ");
INSERT INTO chk_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Lupwen üpwe akisikisala enemi mongö, epwe fis pwe engol fefin repwe umuni ener pilawa lon eu chök um. Mürin repwe paunei ewe pilawa o ineti. Iwe, oupwe mongö, nge ousap möt ren. ");
INSERT INTO chk_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Are iei mwo ai ariaföüükemi, nge ousap mochen aleasochisiei pwe oua chök sopwela le ü ngeniei, ");
INSERT INTO chk_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mürin üpwe pwal ü ngenikemi lon ai song o püsin emiritikemi fän fisu lap seni me mwan pokiten ämi tipis. ");
INSERT INTO chk_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Iwe, pokiten watten ämi echik oupwe ochei fituken püsin nöümi ät me nengin. ");
INSERT INTO chk_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Üpwe atai ämi kewe lenien fel won ekewe leni tekia o pökükisietiu ämi kewe rongen asoren ötüöt. Üpwe pwal moneetä inisin ämi kewe somä won ämi kewe uluulun anümwäl mi tatakis. Iwe, üpwe fokun oputakemi. ");
INSERT INTO chk_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Üpwe atai ämi kewe telinimw o apönü ämi kewe leni mi pin. Üsap fokun etiwa ämi kewe asor oua keni. ");
INSERT INTO chk_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ewer, üpwe fokun ataela fanüemi, pwe chon oputakemi mi lefanüla lon repwe mairü ren. ");
INSERT INTO chk_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Iwe, üpwe awarato maun womi o atoropasafeilikemi lein ekewe mwü. Fanüemi epwe tala, nge ämi kewe telinimw repwe tatakis. ");
INSERT INTO chk_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Mürin, ewe fanü epwe pwapwaiti an kewe ierin asösö lon ükükün fansoun a tala. Lupwen oua oola lon fanüen chon oputakemi, ewe fanü epwe asösö o pwapwaiti an kewe ierin sapat. ");
INSERT INTO chk_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Iwe, ükükün fansoun ewe fanü a tala lon, ina pwal ükükün fansoun an epwe asösö, pun esap asösö lon ämi kewe ierin sapat, lupwen oua nonom won. ");
INSERT INTO chk_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Nge üpwe awora niuokus lon leluken chokewe me leimi mi chüen manau lon fanüen chon oputer, pwe repwe sü ren mwataten echö chön irä mi äs ren asepwäl, usun chök eman aramas a sü lupwen maun. Iwe, repwe turula, nge esap wor eman a tapweriir. ");
INSERT INTO chk_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Eman epwe tumula won eman, usun chök aramas ra tumula ren ar sü lupwen maun, nge esap wor eman a tapweriir. Epwe wor ämi pireir, pwe ousap tongeni ü ngeni chon oputakemi. ");
INSERT INTO chk_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Iwe, oupwe mäla lein chon ekewe mwü, nge fanüen chon oputakemi epwe oromikemiila. ");
INSERT INTO chk_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Nge chokewe me leimi mi chüen manau lon fanüen chon oputer, epwe üttüla inisir pokiten ar föföringau, pwal pokiten an semer föföringau. ");
INSERT INTO chk_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Mürin epwe fis pwe repwe pwärätä ar föföringau, pwal än semer kewe föföringau ra föri ngeniei lon ar ekisolä me ü ngeniei, ");
INSERT INTO chk_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","iei popun ngang üa pwal ü ngeniir o tinirela lon fanüen chon oputer. Iwe, lupwen leluker mi ülöförea epwe tekison pwe ra angei chappen ar tipis, ");
INSERT INTO chk_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ngang üpwe chechemeni ai pwon ngeni Jakop, ai pwon ngeni Isaak me ai pwon ngeni Apraham, üpwe pwal chechemeni ewe fanü. ");
INSERT INTO chk_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Nge akom ekewe aramas repwe likitala ewe fanü, pwe ewe fanü epwe pwapwaiti an kewe ierin asösö, lupwen a tala. Iwe, repwe angei chappen ar tipis, pun ra purätiu ai kewe allük o oput ai kewe pwüüng. ");
INSERT INTO chk_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Nge inamwo are ra nom lon fanüen chon oputer, üsap likitirela, üsap pwal oputeer. Iei mine üsap fokun aroserela o atai ai pwon ngeniir. Pun ngang ewe Samol mi Lapalap ar we Kot. ");
INSERT INTO chk_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Pun fän äsengesiir üpwe chechemeni ai pwon ngeni ar kewe lewo, chokewe üa emwenirewu seni ewe fanü Isip fän mesen ekewe mwü, pwe üpwe ar Kot. Ngang ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Iwe, ikkei ekewe allük me pwüüng ewe Samol mi Lapalap a ngeni Moses me won ewe chuk Sinai fän iten ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Iwe, ewe Samol mi Lapalap a ngeni Moses ");
INSERT INTO chk_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","ekei allük fän iten ekewe aramasen Israel: Are eman aramas a eäni pwon ngeni ewe Samol mi Lapalap eman aramas, ewe aramas epwe tongeni kepichila seni ewe pwon, are ewe mi eäni ewe pwon epwe mönätiu ükükün liwinin aüchean. ");
INSERT INTO chk_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Iwe, ükükün liwinin aüchean eman mwän seni ier rüe tori wone epwe lime föün moni silifer, nge epwe för won ewe kilo ra aea le aükük lon ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nge are ewe aramas eman fefin, ükükün liwinin aüchean epwe ilik föün moni silifer. ");
INSERT INTO chk_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Iwe, are ewe aramas a lefilen ier limu tori rüe, ükükün liwinin aüchean epwe rüe föün moni silifer fän iten eman ät, nge engol föün moni silifer fän iten eman nengin. ");
INSERT INTO chk_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Nge are ewe aramas a lefilen eu maram tori limu ier, ükükün liwinin aüchean epwe limeföü föün moni silifer fän iten eman ät, nge ülüföü föün moni silifer fän iten eman nengin. ");
INSERT INTO chk_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Iwe, are ewe aramas a ierini wone feitä, ükükün liwinin aüchean epwe engol me limeföü föün moni silifer fän iten eman mwän, nge engol föün moni silifer fän iten eman fefin. ");
INSERT INTO chk_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Nge are eman aramas a wöüngau pwe esap tongeni mönätiu ükükün liwinin aüchean ewe aramas a eäni pwon won, epwe emwenato ewe aramas fän mesen ewe souasor. Iwe, ewe souasor epwe aüküsefäli liwinin aüchean, nge epwe alongolong won ükükün tufichin ätewe a eäni ewe pwon. ");
INSERT INTO chk_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Are eman a eäni pwon eman man me lein ekewe sokun man aramas ra eäni asor ngeni ewe Samol mi Lapalap, ekei man meinisin aramas ra fangala ngeni ewe Samol mi Lapalap ra pin. ");
INSERT INTO chk_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Iwe, ätewe esap tongeni akasiwili ewe man ngeni pwal eman, esap pwal tongeni akasiwili eman mi öch ngeni eman mi ngau ika eman mi ngau ngeni eman mi öch. Nge are a akasiwili eman man ngeni eman, ewe man a angei akom me akasiwilin we repwe pin me ruoman. ");
INSERT INTO chk_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Nge are a eäni pwon eman man mi limengau esap tufich an epwe eäni asor ngeni ewe Samol mi Lapalap, ewe aramas epwe uwato ewe man fän mesen ewe souasor. ");
INSERT INTO chk_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Iwe, ewe souasor epwe filätä ika men lapalapöch ika men lapalapangau. Nge ükükün aüchean mine ewe souasor epwe aükü ngeni epwe chök ina. ");
INSERT INTO chk_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Nge are ewe aramas a mochen mönisefäli ewe man, epwe pacheetä eu lelimu ngeni ükükün liwinin aüchean ren moni. ");
INSERT INTO chk_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Iwe, are eman aramas a fangala imwan pwe epwe pin fän iten ewe Samol mi Lapalap, ewe souasor epwe aükü ükükün liwinin aüchean ewe imw o filätä ika men öch ika men ngau. Nge ükükün mine ewe souasor epwe aükü ngeni epwe chök ina. ");
INSERT INTO chk_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Nge are ätewe mi fangala imwan ngeni Kot a mochen mönisefäli, epwe pacheetä eu lelimu ngeni ükükün liwinin aüchean ewe imw ren moni. Mürin epwe pwal imwenisefäli. ");
INSERT INTO chk_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Iwe, are eman aramas a fangala eu kinikin seni fanüan me won saman ngeni ewe Samol mi Lapalap, ükükün liwinin aüchean epwe alongolong won ükükün mine a tongeni fotutiu won. Iwe, ükükün liwinin iteiten wone paun föün parli a tongeni fot won epwe engol föün moni silifer. ");
INSERT INTO chk_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Are ewe aramas a fangala fanüan ngeni Kot lon ewe ierin supili, ükükün liwinin aüchean epwe unus. ");
INSERT INTO chk_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Nge are a fangala fanüan mürin ewe ierin supili, ewe souasor epwe aükü ükükün liwinin aüchean, nge epwe alongolong won ükükün fitu ier mi chüen nom tori ewe ierin supili me mürin. Iwe, ükükün liwinin aüchean epwe kotur won ükükün ekewe ier ra fen wes. ");
INSERT INTO chk_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Iwe, are ätwe mi fangala ewe fanü ngeni Kot a mochen mönisefäli, epwe pacheetä eu lelimu ngeni ükükün liwinin aüchean ewe fanü ren moni. Mürin epwe pwal fanüenisefäli. ");
INSERT INTO chk_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Nge are esap mochen mönisefäli ewe fanü, ika a amömöla ngeni eman, esap chüen wor an pwüng won me mürin. ");
INSERT INTO chk_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Are ewe fanü a pichila lon ewe ierin supili, ei fanü epwe pin fansoun meinisin usun chök eu fanü a fen pin fän iten ewe Samol mi Lapalap. Iwe, ewe souasor epwe fanüeni. ");
INSERT INTO chk_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Nge are eman a fangala ngeni ewe Samol mi Lapalap eu fanü sap fanüan me won saman pwe a möni, ");
INSERT INTO chk_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ewe souasor epwe aükü liwinin aüchean seni fansoun än ewe aramas fangala tori ewe ierin supili. Iwe, ewe aramas epwe mönätiu ükükün liwinin aüchean mi kaük lon ewe chök rän. Ei moni a fän iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Nge lon ewe ierin supili ewe fanü epwe liwiniti ätewe mi amömöla, pun fanüan me won saman. ");
INSERT INTO chk_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Iwe, iteiten aükükün liwinin epwe för won ewe kilo ra aea le aükük lon ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Iwe, esap wor eman a tongeni fangala ngeni Kot eman mweinöün nöün man pwe an asor seni püsin letipan, pun a fen nöün ewe Samol mi Lapalap. Ese lifilifil ika ätemwänin kow ika sip, ir nöün ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Nge are ewe man eman mweinöü me lein ekewe man mi limengau, ätewe nöün ewe man a tongeni mönisefäli won ükükün liwinin aüchean a fen kaük ngeni, nge epwe pacheetä eu lelimu ngeni. Nge are esap mönisefäli, repwe amömöla ewe man won ükükün liwinin aüchean a fen kaük ngeni. ");
INSERT INTO chk_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nge are eman aramas a apini och mettoch seni mine an fän iten ewe Samol mi Lapalap pwe epwe katala, ese lifilifil ika eman aramas ika nöün man ika fanüan me won saman, esap tufich an epwe amömöla are mönisefäli. Iteiten mettoch mi pin pwe repwe katala ra unusen pin fän iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Eman aramas mi apinipin pwe epwe kärila esap tufich pwe epwe mösefäl, nge epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Iwe, ämi leengol meinisin seni ewe fanü, ese lifilifil ika föün irän wiich mi mär won pwül ika uän sokopaten irä, än ewe Samol mi Lapalap. Ekewe leengol meinisin ra pin fän iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Nge are eman aramas a mochen mönisefäli eu kinikin seni an leengol, epwe mönätiu ükükün liwinin, nge epwe pwal pacheetä eu lelimu ngeni. ");
INSERT INTO chk_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Iwe, eu leengol seni ekewe kow me sip meinisin, iteiten engolun man meinisin mi alea repwe pin fän iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Esap wor eman epwe eiipöni ika ewe man a mürina ika a ngau, esap pwal akasiwili ngeni eman. Nge are a akasiwili ewe man ngeni eman, ewe man a fen nom me akasiwilin we repwe pin me ruoman, nge esap wor eman a tongeni mönisefäliir. ");
INSERT INTO chk_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Iwe, ikkei ekewe allük ewe Samol mi Lapalap a ngeni Moses fän iten ekewe aramasen Israel me won ewe chuk Sinai. ");
INSERT INTO chk_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Iwe, lon aeuin ränin ewe aruuen maram lon aruuen ier mürin än chon Israel towu seni ewe fanü Isip, ewe Samol mi Lapalap a kapas ngeni Moses me lon ewe imw mangaku ia aramas ra churi Kot ie mi nom lon ewe fanüapön Sinai, ");
INSERT INTO chk_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Oupwe angei iteiten ekewe aramasen Israel meinisin, iteiten eu me eu famili lon ar kewe cho. Oupwe makei iten eman me eman mwän ");
INSERT INTO chk_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","seni ier rüe feitä mi tongeni fiti maun. Ämi me Aaron oupwe nampaniir lon eu me eu mwich. ");
INSERT INTO chk_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Iwe, epwe wor eman mwän seni eu me eu ainang i mwänirelan an cho, epwe alisikemi. ");
INSERT INTO chk_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ikkei iten ekewe mwän repwe alisikemi: Elisur nöün Seteur mwän seni ewe ainangen Rupen, ");
INSERT INTO chk_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Selumiel nöün Surisatai mwän seni ewe ainangen Simeon, ");
INSERT INTO chk_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Nason nöün Aminatap mwän seni ewe ainangen Juta, ");
INSERT INTO chk_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Netanel nöün Suar mwän seni ewe ainangen Isakar, ");
INSERT INTO chk_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Eliap nöün Helon mwän seni ewe ainangen Sepulon, ");
INSERT INTO chk_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","nge seni mwirimwirin Josef kewe: Elisama nöün Amihut mwän seni ewe ainangen Efraim, pwal Kamaliel nöün Petasur mwän seni ewe ainangen Manasa, ");
INSERT INTO chk_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Apitan nöün Kiteoni mwän seni ewe ainangen Peniamin, ");
INSERT INTO chk_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ahieser nöün Amisatai mwän seni ewe ainangen Tan, ");
INSERT INTO chk_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pakiel nöün Okran mwän seni ewe ainangen Aser, ");
INSERT INTO chk_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Eliasaf nöün Teuel mwän seni ewe ainangen Kat, ");
INSERT INTO chk_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ahira nöün Enan mwän seni ewe ainangen Naftali.” ");
INSERT INTO chk_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ikkei ir ätekewe mi kefilitä seni ekewe chon Israel, ir ekewe souemwenin än semer ainang pwal mwänirelan ekewe eterekesin Israel. ");
INSERT INTO chk_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Iwe, Moses me Aaron ra körato ekei mwän mi föü iter. ");
INSERT INTO chk_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Nge ir ra amwichafengeni ekewe aramasen Israel meinisin lon aeuin ränin ewe aruuen maram. Iwe, ra angei iteiten chon Israel lon en me an famili me än semer cho o makei iten eman me eman mwän seni ier rüe feitä, ");
INSERT INTO chk_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","usun ewe Samol mi Lapalap a allük ngeni Moses. Iei usun Moses a angei iteiter lon ewe fanüapön Sinai. ");
INSERT INTO chk_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Iwe, seni mwirimwirin Rupen nöün Israel we mwänichi, ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iten eman me eman lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Iwe, ükükün seni ewe ainangen Rupen faik me wonungeröü limepükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Seni mwirimwirin Simeon ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iten eman me eman lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Iwe, ükükün seni ewe ainangen Simeon lime me tiwungeröü ülüpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Seni mwirimwirin Kat ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Iwe, ükükün seni ewe ainangen Kat faik me limungeröü wonopükü lime mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Seni mwirimwirin Juta ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Iwe, ükükün seni ewe ainangen Juta fik me rüanüngeröü wonopükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Seni mwirimwirin Isakar ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Iwe, ükükün seni ewe ainangen Isakar lime me rüanüngeröü föpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Seni mwirimwirin Sepulon ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Iwe, ükükün seni ewe ainangen Sepulon lime me fisungeröü föpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Seni nöün Josef kewe mwän, ekewe mwirimwirin Efraim, ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Iwe, ükükün seni ewe ainangen Efraim faikngeröü limepükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Seni mwirimwirin Manasa ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Iwe, ükükün seni ewe ainangen Manasa ilik me ruungeröü rüepükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Seni mwirimwirin Peniamin ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Iwe, ükükün seni ewe ainangen Peniamin ilik me limungeröü föpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Seni mwirimwirin Tan ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Iwe, ükükün seni ewe ainangen Tan wone me ruungeröü füpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Seni mwirimwirin Aser ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Iwe, ükükün seni ewe ainangen Aser faik me eungeröü limepükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Seni mwirimwirin Naftali ekewe mwän meinisin seni ier rüe feitä mi tongeni fiti maun, ra aleaniir o makei iter lon en me an famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Iwe, ükükün seni ewe ainangen Naftali lime me ülüngatngeröü föpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ikkei ir ekewe mwän Moses me Aaron ra aleaniir, nge ekewe engol me ruoman souemwenin Israel mi tupuni en me än saman cho ra alisiir. ");
INSERT INTO chk_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Iwe, kapachelapen iteiten mwänin Israel seni lon än semer kewe cho seni ier rüe feitä mi tongeni fiti maun ");
INSERT INTO chk_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ükükün wonopükü ülüngatngeröü limepükü lime mwän. ");
INSERT INTO chk_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Nge chon ewe ainangen Lefi resap alealong lon iteiten ekewe lusun ainang. ");
INSERT INTO chk_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Pun ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Kosap aleani chon ewe ainangen Lefi, kosap pwal alearelong lein ekewe re Israel mi tongeni fiti maun. ");
INSERT INTO chk_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Nge kopwe awisa ekewe mwän seni ewe ainangen Lefi pwe repwe tümwünü ewe imwenfel seni mangaku ia ekewe allük ra nom ie me pisekin meinisin. Iwe, repwe mwärefetalei ewe imwenfel me pisekin meinisin o tümwünüöchüür, repwe pwal aüetä imwer imw mangaku pwelin ünükün. ");
INSERT INTO chk_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Iwe, ekewe mwän seni ewe ainangen Lefi repwe atomwala ewe imwenfel seni mangaku, lupwen ekewe chon Israel repwe sai, nge repwe pwal aüsefäli, lupwen ekewe chon Israel repwe asösö. Iwe, are eman me lükür epwe kan ngeni ei imwenfel, epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Iwe, ekewe lusun aramasen Israel repwe aüetä imwer imw mangaku lon en me an mwich pwal fän en me an filäik. ");
INSERT INTO chk_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Nge ekewe mwän seni ewe ainangen Lefi repwe aüetä imwer imw mangaku pwelin ünükün ewe imwenfel seni mangaku o tümwünü pwe esap wor eman epwe arap ngeni, pwe ngang üsap song ngeni ekewe aramasen Israel.” ");
INSERT INTO chk_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Iwe, ekewe aramasen Israel ra föri meinisin mine ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Eman me eman ekewe aramasen Israel epwe aüetä imwan imw mangaku fän filäiken an mwich pwal fän asisilen än saman cho. Repwe aüetä imwer kewe pwelin ünükün ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Iwe, peliötiuen ewe imwenfel seni mangaku awenewenen meserän chon ewe ainangen Juta me ekewe mwich mi chu ngeni lon an kinikin repwe aüetä imwer imw mangaku fän ar filäik lon tettelin en me an mwich. Iten souemwenin ewe ainangen Juta Nason nöün Aminatap mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Iteiten ekewe mwän lon än Nason mwich ükükün fik me rüanüngeröü wonopükü. ");
INSERT INTO chk_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Iwe, chon ewe ainangen Isakar repwe aüetä imwer ünükür. Iten nöür souemwen Netanel nöün Suar mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Iteiten ekewe mwän lon än Netanel mwich ükükün lime me rüanüngeröü föpükü. ");
INSERT INTO chk_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Nge chon ewe ainangen Sepulon repwe nom ünükür. Iten nöür souemwen Eliap nöün Helon mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Iteiten ekewe mwän lon än Eliap mwich ükükün lime me fisungeröü föpükü. ");
INSERT INTO chk_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Iwe, iteiten chokewe meinisin mi imweimw lon kinikinin Juta lon tettelin ar kewe mwich ükükün ipükü walik me wonungeröü föpükü mwän. Ir repwe wisen akomw lupwen fansoun ar sai. ");
INSERT INTO chk_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Iwe, peliörün ewe imwenfel seni mangaku chon ewe ainangen Rupen me ekewe mwich mi chu ngeni lon an kinikin repwe aüetä imwer imw mangaku fän ar filäik lon tettelin en me an mwich. Iten souemwenin ewe ainangen Rupen Elisur nöün Seteur mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Iteiten ekewe mwän lon än Elisur mwich ükükün faik me wonungeröü limepükü. ");
INSERT INTO chk_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Iwe, chon ewe ainangen Simeon repwe aüetä imwer ünükür. Iten nöür souemwen Selumiel nöün Surisatai mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Iteiten ekewe mwän lon än Selumiel mwich ükükün lime me tiwungeröü ülüpükü. ");
INSERT INTO chk_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Nge chon ewe ainangen Kat repwe nom ünükür. Iten nöür souemwen Eliasaf nöün Reuel mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Iteiten ekewe mwän lon än Eliasaf mwich ükükün faik me limungeröü wonopükü lime. ");
INSERT INTO chk_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Iwe, iteiten chokewe meinisin mi imweimw lon kinikinin Rupen lon tettelin ar kewe mwich ükükün ipükü lime me eungeröü föpükü lime mwän. Ir repwe nom lon tettel nampa ruu lupwen fansoun ar sai. ");
INSERT INTO chk_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Mürin ekei ruu mwich chon ewe ainangen Lefi mi nom lukalaper repwe sai o eki pisekin ewe imwenfel seni mangaku. Usun tettelin ar nom lon lenier, iei usun pwal tettelin ar sai, eu me eu mwich lon an tettel fän en me an filäik. ");
INSERT INTO chk_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Iwe, pelilotoun ewe imwenfel seni mangaku chon ewe ainangen Efraim me ekewe mwich mi chu ngeni lon an kinikin repwe aüetä imwer imw mangaku fän ar filäik lon tettelin en me an mwich. Iten souemwenin ewe ainangen Efraim Elisama nöün Amihut mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Iteiten ekewe mwän lon än Elisama mwich ükükün faik ngeröü limepükü. ");
INSERT INTO chk_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Iwe, chon ewe ainangen Manasa repwe nom ünükür. Iten nöür souemwen Kamaliel nöün Petasur mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Iteiten ekewe mwän lon än Kamaliel mwich ükükün ilik me ruungeröü ruopükü. ");
INSERT INTO chk_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Nge chon ewe ainangen Peniamin repwe nom ünükür. Iten nöür souemwen Apitan nöün Kiteoni mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Iteiten ekewe mwän lon än Apitan mwich ükükün ilik me limungeröü föpükü. ");
INSERT INTO chk_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Iwe, iteiten chokewe meinisin mi imweimw lon kinikinin Efraim lon tettelin ar kewe mwich ükükün ipükü walungeröü ipükü mwän. Ir repwe nom lon tettel nampa ülüngat lupwen fansoun ar sai. ");
INSERT INTO chk_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Iwe, peliefengin ewe imwenfel seni mangaku chon ewe ainangen Tan me ekewe mwich mi chu ngeni lon an kinikin repwe aüetä imwer imw mangaku fän ar filäik lon tettelin en me an mwich. Iten souemwenin ewe ainangen Tan Ahieser nöün Amisatai mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Iteiten ekewe mwän lon än Ahieser mwich ükükün wone me ruungeröü füpükü. ");
INSERT INTO chk_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Iwe, chon ewe ainangen Aser repwe aüetä imwer ünükür. Iten nöür souemwen Pakiel nöün Okran mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Iteiten ekewe mwän lon än Pakiel mwich ükükün faik me eungeröü limepükü. ");
INSERT INTO chk_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Nge chon ewe ainangen Naftali repwe nom ünükür. Iten nöür souemwen Ahira nöün Enan mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Iteiten ekewe mwän lon än Ahira mwich ükükün lime me ülüngatngeröü föpükü. ");
INSERT INTO chk_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Iwe, iteiten chokewe meinisin mi imweimw lon kinikinin Tan ükükün ipükü lime me fisungeröü wonopükü mwän. Iwe, repwe nom mwirichikin lupwen fansoun ar sai fän en me an filäik.” ");
INSERT INTO chk_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Iwe, ikkei ir ekewe aramasen Israel ra alealong lon en me än saman cho. Nge kapachelapen meinisin mi alea lon tettelin ar kewe mwich lon lenier kewe ükükün wonopükü ülüngatngeröü limepükü lime mwän. ");
INSERT INTO chk_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Nge chon ewe ainangen Lefi resap alealong lein ekewe aramasen Israel, usun ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Iei usun ekewe aramasen Israel ra föri meinisin mine ewe Samol mi Lapalap a allük ngeni Moses. Iwe, ra aüetä imwer imw mangaku fän ar filäik, ra pwal sai en me lon an famili lon tettelin än semer kewe cho. ");
INSERT INTO chk_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Iwe, iei pworausen än Aaron me Moses famili lon ewe fansoun, lupwen ewe Samol mi Lapalap a kapas ngeni Moses me won ewe chuk Sinai. ");
INSERT INTO chk_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ikkei iten nöün Aaron kewe mwän: Natap ewe mwänichi, Apihu, Eleasar me Itamar. ");
INSERT INTO chk_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ir ätekewe mi kepit o afeiöch pwe repwe angang lon wiser wisen souasor. ");
INSERT INTO chk_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nge Natap me Apihu ra mäla, lupwen ra eäni asor ekkei esap pin me fän mesen ewe Samol mi Lapalap lon ewe fanüapön Sinai. Iwe, ätekei esap wor nöür. Iei mine Eleasar me Itamar ra angang lon wisen souasor lupwen fansoun manauen Aaron semer we. ");
INSERT INTO chk_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Kopwe emwenato chon ewe ainangen Lefi mwen ewe souasor Aaron pwe repwe angang ngeni. ");
INSERT INTO chk_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Iwe, repwe föri sokun angang ngeni Aaron, pwal ngeni unusen ewe mwichen chon Israel mwen ewe imw mangaku ia aramas ra churiei ie o föri angangen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Iwe, repwe tümwünü pisekin ewe imwenfel seni mangaku meinisin o föri sokun angang fän iten ekewe aramasen Israel ren ar angang ngeni ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Chon ewe ainangen Lefi repwe wisen angang ngeni Aaron me nöün kewe mwän. Ir repwe tiwewu seni me lein ekewe aramasen Israel pwe repwe angang ngeni. ");
INSERT INTO chk_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Iwe, kopwe awisa Aaron me nöün kewe mwän pwe repwe föri angangen wiser wisen souasor. Nge are eman me lükür epwe angelong lon ewe wis, epwe ninnila.” ");
INSERT INTO chk_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Nengeni, üa filätä ekewe mwän seni ewe ainangen Lefi seni me lein ekewe aramasen Israel, pwe repwe tupuni ekewe mwänichi me lein ekewe aramasen Israel. Iwe, ekewe mwän seni ewe ainangen Lefi repwe nei, ");
INSERT INTO chk_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","pun ekewe mwänichi meinisin nei. Lon ewe rän, lupwen üa niela ekewe mwänichi meinisin lon ewe fanü Isip, üa apini fän itei ekewe mwänichi lon Israel meinisin, seni mwänichien aramas tori man. Iwe, ir repwe nei. Ngang ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Iwe, ewe Samol mi Lapalap a üreni Moses me lon ewe fanüapön Sinai, ");
INSERT INTO chk_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Kopwe angei iteiten mwän seni ewe ainangen Lefi lon tettelin ar kewe cho me ar famili. Kopwe aleani iteiter seni eu maram feitä.” ");
INSERT INTO chk_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Iwe, Moses a angei iteiter, usun mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ikkei iten nöün Lefi kewe mwän: Kerson, Kohat me Merari. ");
INSERT INTO chk_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Nge ikkei iten nöün Kerson kewe mwän, ir lewon ar kewe cho: Lipni me Shimei. ");
INSERT INTO chk_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Iwe, iten nöün Kohat kewe mwän, ir lewon ar kewe cho: Amram, Ishar, Hepron me Usiel. ");
INSERT INTO chk_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Nge iten nöün Merari kewe mwän, ir lewon ar kewe cho: Mali me Mushi. Ikkei ir lewon ekewe familien Lefi lon tettelin än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Iwe, än Kerson cho ekewe familien Lipni me Shimei. ");
INSERT INTO chk_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Iteiten mwän meinisin ra alea seni eu maram feitä ükükün fisungeröü limepükü. ");
INSERT INTO chk_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Iwe, ekewe familien än Kerson cho repwe aüetä imwer imw mangaku pelilotoun ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Nge Eliasaf nöün Lael mwän epwe mwänirelan än Kerson cho. ");
INSERT INTO chk_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Iwe, wisen nöün Kerson kewe mwän, repwe tümwünü ewe imwenfel seni mangaku, pwölüpwölün kewe me chechen asamalapan, ");
INSERT INTO chk_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ekewe mangaku mi tit ngeni ewe leni lükün ewe imwenfel seni mangaku, pwal ewe chech fän iten asamalapen ewe leni mi pwelifeili ewe imwenfel seni mangaku me ewe rongen asor. Repwe tümwünü selin pwal meinisin mine ra aea fän iten ar angang. ");
INSERT INTO chk_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Iwe, än Kohat cho ekewe familien Amram, Ishar, Hepron me Usiel. ");
INSERT INTO chk_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Iteiten mwän meinisin ra alea seni eu maram feitä ükükün walungeröü wonopükü. Ir ra wisen tümwünü ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Iwe, ekewe familien än Kohat cho repwe aüetä imwer imw mangaku peliörün ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Nge Elisafan nöün Usiel mwän epwe mwänirelan än Kohat cho. ");
INSERT INTO chk_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Iwe, wiser repwe tümwünü ewe pworofel, ewe chepel, ewe lenien atittin, ekewe rongen asor, ekewe sepi fän iten ewe imw mi pin ekewe souasor ra aea le angang, pwal ewe cheech mi refiela ewe rum mi unusen pin me sokopaten pisek meinisin ra aea lon ar angang. ");
INSERT INTO chk_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Nge Eleasar nöün ewe souasor Aaron we mwän epwe meilapen ekewe souemwenin ewe ainangen Lefi, epwe pwal nemelapei chokewe mi tümwünü ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Iwe, än Merari cho ekewe familien Mali me Mushi. ");
INSERT INTO chk_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Iteiten mwän meinisin ra alea seni eu maram feitä ükükün wonungeröü ruopükü. ");
INSERT INTO chk_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Iwe, Suriel nöün Apihail mwän epwe mwänirelan än Merari cho. Repwe aüetä imwer imw mangaku peliefengin ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Nge wisen nöün Merari kewe mwän repwe tümwünü pappen ewe imwenfel seni mangaku, ekewe amwöch, ekewe ür me alongur me pisekin meinisin ra aea lon ar angang. ");
INSERT INTO chk_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Repwe pwal tümwünü üren pwelin ewe leni lükün ewe imwenfel seni mangaku fiti alongur, chüfölür me selir. ");
INSERT INTO chk_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Iwe, mwen ewe imwenfel seni mangaku me peliötiu sasape ngeni meserän Moses me Aaron me nöün kewe mwän repwe aüetä imwer imw mangaku. Iwe, wiser repwe föri sokun angangen souasor fän iten ekewe aramasen Israel lon ewe leni mi pin. Nge are eman me lükür epwe angelong lon ewe angang, epwe ninnila. ");
INSERT INTO chk_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Iwe, Moses me Aaron ra angei iteiten ekewe mwän seni ewe ainangen Lefi meinisin lon en me an famili fän än ewe Samol mi Lapalap allük. Nge kapachalapen ekewe mwän meinisin seni eu maram feitä ükükün rüe me ruungeröü. ");
INSERT INTO chk_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe angei iteiten ekewe mwänichi seni ekewe aramasen Israel meinisin o makei iter seni eu maram feitä. ");
INSERT INTO chk_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Mürin kopwe angei ekewe mwän seni ewe ainangen Lefi pwe akasiwilin ekewe mwänichi meinisin me lein ekewe aramasen Israel, pwe nei. Ngang ewe Samol mi Lapalap. Kopwe pwal angei fän itei nöün chon ewe ainangen Lefi man pwe akasiwilin mweinöün ekewe aramasen Israel man meinisin.” ");
INSERT INTO chk_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Iei mine Moses a angei iteiten mwänichi meinisin me lein ekewe aramasen Israel, usun ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Iwe, iteiten ekewe mwänichi meinisin seni eu maram feitä ükükün rüe me ruungeröü ruopükü fik me ülüman. ");
INSERT INTO chk_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Kopwe apini ekewe mwän seni ewe ainangen Lefi pwe repwe nei akasiwilin ekewe mwänichi meinisin me lein ekewe aramasen Israel. Kopwe pwal aimwüela nöün chon ewe ainangen Lefi man pwe akasiwilin mweinöün chon Israel man. Iwe, ekewe mwän seni ewe ainangen Lefi nei: Ngang ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Nge ren mön ekewe ruopükü fik me ülüman mwänichi seni ekewe aramasen Israel mi som seni iteiten ekewe mwän seni ewe ainangen Lefi, ");
INSERT INTO chk_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","kopwe angei limeföü föün silifer fän iten eman me eman. Iwe, kopwe föri won ewe kilo ra aea le aükük lon ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Iwe, kopwe angei ewe moni a püng fän iten mön ekewe aramas mi som seni iteiten ekewe mwän seni ewe ainangen Lefi o ngeni Aaron me nöün kewe mwän.” ");
INSERT INTO chk_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Iei mine Moses a angei mön ekewe aramas mi som seni iteiten ekewe mwän seni ewe ainangen Lefi. ");
INSERT INTO chk_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Iwe, ükükün ewe moni a angei seni ekewe mwänichi nöün ekewe aramasen Israel engeröü ülüpükü wone me limeföü föün silifer. Nge ewe moni a för won ewe kilo ra aea le aükük lon ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Iwe, Moses a ngeni Aaron me nöün kewe mwän ewe moni usun ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Oupwe angei iteiten nöün Kohat kewe mwän seni me lein chon ewe ainangen Lefi lon ar famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Oupwe aleaniir seni ier ilik feitä tori ier lime, ir ätekewe mi fich ngeni ewe angang lon ewe imw mangaku ia aramas ra churiei ie. ");
INSERT INTO chk_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Iwe, wisen nöün Kohat kewe mwän me lon ewe imwenfel seni mangaku, repwe tümwünü ekewe mettoch mi unusen pin. ");
INSERT INTO chk_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Iwe, lupwen ekewe chon Israel repwe sai, Aaron me nöün kewe mwän repwe tolong lon ewe imwenfel seni mangaku o ettätiu ewe chechen lefil pwe repwe pwölü ngeni ewe pworofel. ");
INSERT INTO chk_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Mürin repwe pwölü ngeni echö pwölüpwöl seni silin man mi mürina, repwe pwal ameresala won echö mangaku mi arauarau o sökalong ämwärin kewe. ");
INSERT INTO chk_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Iwe, repwe ameresala echö mangaku mi arauarau won ewe chepel ia ewe pilawa mi pin a nom ie. Mürin repwe iseis won ekewe peleich, ekewe sepi fän iten ewe apach mi pwokus, sokun sepi me ekewe rume fän iten ewe asoren ün. Iwe, ewe pilawa epwe chök nonom won ewe chepel fansoun meinisin. ");
INSERT INTO chk_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Mürin repwe ameresala wor echö mangaku mi parachol, repwe pwölü ngeni echö pwölüpwöl seni silin man mi mürina o sökalong ämwärin kewe. ");
INSERT INTO chk_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Iwe, repwe angei echö mangaku mi arauarau o pwölü ngeni ewe lenien atittin fiti laman, fichin me sepian, pwal ekewe rume fän iten ewe noppuk ra aea le alölöü ngeni. ");
INSERT INTO chk_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Mürin repwe tukumalong ewe lenien atittin fiti pisekin meinisin lon echö pwölüpwöl seni silin man mi mürina o iseis won ewe lenien keki. ");
INSERT INTO chk_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Iwe, Aaron me nöün kewe mwän repwe ameresala won ewe rongen asor seni kolt echö mangaku mi arauarau. Repwe pwal pwölü ngeni echö pwölüpwöl seni silin man mi mürina o sökalong ämwärin kewe. ");
INSERT INTO chk_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Repwe angei ekewe pisek meinisin ra aea le angang lon ewe imw mi pin o isenirelong lon echö mangaku mi arauarau. Mürin repwe pwölürela fän echö pwölüpwöl seni silin man mi mürina o iseniir won eu lenien keki. ");
INSERT INTO chk_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Repwe pwal tukeila falangen ewe rongen asor o ameresala echö mangaku mi parachol won ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Iwe, repwe iseis won ewe pwölüpwöl ekewe pisek meinisin ra aea le angang won ewe rongen asor: ekewe sepi fän iten moli, ekewe fook, ekewe sofel, ekewe sepi me pisekin meinisin. Mürin repwe ameresala won echö pwölüpwöl seni silin man mi mürina o sökalong ämwärin kewe. ");
INSERT INTO chk_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Nge are Aaron me nöün kewe mwän ra wes le pwölüela ekewe pisek mi pin me mettochun meinisin lupwen fansoun än chon Israel repwe sai, mürin nöün Kohat kewe mwän repwe feito o mwärei ekewe pisek. Nge resap tongeni atapa ekewe pisek mi pin pwe resap mäla. Ikkei pisekin ewe imwenfel seni mangaku nöün Kohat kewe mwän ra wisen mwärei. ");
INSERT INTO chk_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Iwe, Eleasar nöün ewe souasor Aaron we mwän epwe wisen tümwünü ewe noppuk fän iten ekewe lamp, ewe apach mi pwokus, ewe asoren mongö me ewe lön epit. Epwe pwal nemelapei unusen ewe imwenfel seni mangaku me masouen lon meinisin.” ");
INSERT INTO chk_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Oupwe tümwünü pwe ekewe familien än Kohat cho resap rosola me lein chon ewe ainangen Lefi. ");
INSERT INTO chk_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Iwe, iei usun mine oupwe föri ngeniir pwe repwe manau, nge resap mäla lupwen repwe kan ngeni ekewe mettoch mi unusen pin: Aaron me nöün kewe mwän repwe tolong o awisa eman me eman ngeni an angang mine epwe uwei. ");
INSERT INTO chk_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Nge ekewe mwän seni än Kohat cho resap fokun tolong lon pwe repwe katol ekewe mettoch mi pin, pwe resap mäla.” ");
INSERT INTO chk_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Kopwe pwal angei iteiten nöün Kerson kewe mwän lon ar famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Kopwe aleaniir seni ier ilik feitä tori ier lime, ir ätekewe mi fich ngeni ewe angang lon ewe imw mangaku ia aramas ra churiei ie. ");
INSERT INTO chk_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Iei än ekewe familien Kerson angang me mine repwe uwei: ");
INSERT INTO chk_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ewe imwenfel seni mangaku, chechan me pwölüpwölün kewe, ewe pwölüpwöl seni silin man mi mürina mi nom asan me chechen asamalapan, ");
INSERT INTO chk_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ewe tit mangaku fän iten ewe leni lükün mi pweli ewe imwenfel seni mangaku me ewe rongen asor, chechen asamalapen tolong, pwal selir me pisekin ar angang meinisin. Iwe, repwe föri ekewe angang meinisin a weneitiir fän iten ekewe pisek. ");
INSERT INTO chk_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Iwe, Aaron me nöün kewe mwän repwe emweni än nöün Kerson kewe mwän angang ren meinisin mine repwe uwei, pwal ren meinisin mine repwe föri. Nge en kopwe awisa ngeniir meinisin mine repwe uwei. ");
INSERT INTO chk_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Iei ekewe angang än familien nöün Kerson kewe mwän me lon ewe imwenfel seni mangaku. Nge ar angang epwe nom fän nemelapen Itamar nöün ewe souasor Aaron we mwän. ");
INSERT INTO chk_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Iwe, kopwe angei iteiten nöün Merari kewe mwän lon ar famili me än semer cho. ");
INSERT INTO chk_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Kopwe aleaniir seni ier ilik feitä tori ier lime, ir ätekewe mi fich ngeni ewe angang lon ewe imw mangaku ia aramas ra churiei ie. ");
INSERT INTO chk_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Iei wiser lon ar angang, pwe repwe uwei pappen ewe imwenfel seni mangaku fiti amwöchür, ekewe ür me alongur, ");
INSERT INTO chk_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","üren pwelin ewe leni lükün fiti alongur, ekewe chüföl me ekewe säl fiti pisekir meinisin me pisekinginir. Iwe, kopwe awisa ngeni eman me eman mine epwe uwei. ");
INSERT INTO chk_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Iei än familien nöün Merari kewe mwän angang. Unusen ar angang lon ewe imwenfel seni mangaku epwe nom fän nemelapen Itamar nöün ewe souasor Aaron we mwän.” ");
INSERT INTO chk_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Iwe, Moses me Aaron me ekewe souemwenin chon Israel ra aleani iteiten nöün Kohat kewe mwän lon ar famili me än semer cho ");
INSERT INTO chk_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","seni ier ilik feitä tori ier lime, ir ätekewe mi fich ngeni ewe angang lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Iteiter lon ar kewe famili ükükün ruungeröü füpükü lime mwän. ");
INSERT INTO chk_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Iei iteiten nöün Kohat kewe mwän lon ar kewe famili mi angang lon ewe imwenfel seni mangaku. Ir ätekewe Moses me Aaron ra aleaniir fän än ewe Samol mi Lapalap allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Iwe, iei iteiten nöün Kerson kewe mwän lon ar famili me än semer cho ");
INSERT INTO chk_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","seni ier ilik feitä tori ier lime, ir ätekewe mi fich ngeni ewe angang lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Iteiter lon ar kewe famili ükükün ruungeröü wonopükü ilik mwän. ");
INSERT INTO chk_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Iei iteiten nöün Kerson kewe mwän lon ar kewe famili mi angang lon ewe imwenfel seni mangaku. Ir ätekewe Moses me Aaron ra aleaniir fän än ewe Samol mi Lapalap allük. ");
INSERT INTO chk_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Iwe, iei iteiten nöün Merari kewe mwän lon ar kewe famili me än semer cho ");
INSERT INTO chk_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","seni ier ilik feitä tori ier lime, ir ätekewe mi fich ngeni ewe angang lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Iteiter lon ar kewe famili ükükün ülüngeröü ruopükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Iei iteiten nöün Merari kewe mwän lon ar kewe famili Moses me Aaron ra aleaniir fän än ewe Samol mi Lapalap allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Iei usun Moses, Aaron me ekewe souemwenin chon Israel ra aleani chon ewe ainangen Lefi lon ar kewe famili me än semer cho ");
INSERT INTO chk_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","seni ier ilik feitä tori ier lime, ir ätekewe mi fich ngeni ewe angang lon ewe imwenfel seni mangaku me ewe angangen keki pisekin meinisin. ");
INSERT INTO chk_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Iteiten chokewe mi alea ükükün walungeröü limepükü walik mwän. ");
INSERT INTO chk_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Iwe, fän än ewe Samol mi Lapalap allük ngeni Moses eman me eman a angei wisan fän iten an angang ika wosan. Iei usun Moses a föri meinisin mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Kopwe allük ngeni ekewe aramasen Israel pwe repwe atowu iteiten aramas mi üri kilingau mi afeiengau seni ewe leni ia ra nonom ie, me iteiten aramas mi pu seni och chönü, pwal iteiten aramas mi limengau ren an torii eman somä. ");
INSERT INTO chk_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Oupwe atorowu lükün ewe leni ia oua nonom ie, ese lifilifil ika mwän ika fefin, pwe resap alimengaua leniemi kewe, ewe ia üa nonom ie.” ");
INSERT INTO chk_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Iwe, ekewe aramasen Israel ra aleasochis ngeni o atowu ekewe chon limengau lükün ewe ia ra nonom ie, usun ewe Samol mi Lapalap a üreni Moses. ");
INSERT INTO chk_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Kopwe üreni ekewe aramasen Israel: Are eman aramas a föri och föför mi mwäl ngeni eman o atai an allükülük ngeni ewe Samol mi Lapalap ren, ewe aramas a tipis. ");
INSERT INTO chk_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Iwe, epwe pwärätä an tipis a föri o aliwini unusen mine a mwäl won. Nge epwe pwal apachätä eu lelimu ngeni o aliwinisefäli ngeni ätewe a wor an mwäl ngeni. ");
INSERT INTO chk_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Iwe, are ewe aramas a mäla, nge esap wor märärin mi tongeni angei mine ewe mi mwäl epwe aliwinisefäli, ewe mettoch epwe la ngeni ewe Samol mi Lapalap fän iten ewe souasor. Nge epwe pwal pach ngeni eman ätemwänin sip pwe ewe souasor epwe föri asoren amusamusen tipis fän itan. ");
INSERT INTO chk_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Iwe, ekewe lifang mi pin meinisin ekewe aramasen Israel ra uwato ren ewe souasor repwe an. ");
INSERT INTO chk_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Iteiten ekewe mettoch eman aramas a apini epwe än ewe souasor. Nge iteiten mettoch eman aramas a fang ngeni ewe souasor epwe pwal an.” ");
INSERT INTO chk_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Kopwe üreni ekewe aramasen Israel: A tongeni fis pwe ekiekin lukomong a tolong lon leluken eman mwän pwe a öümöüm ngeni pwülüan. A ekieki pwe pwülüan a kirikiringau ngeni o püsin alimengaua ren än eman mwän kon ren. ");
INSERT INTO chk_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Nge ewe mwän esap nien silei, pun ewe fefin a tukumala, esap pwal wor eman chon atipisi, pun esap wor eman a seretä wor. ");
INSERT INTO chk_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","A pwal tongeni fis pwe ekiekin lukomong a tolong lon leluken eman mwän pwe a öümöüm ngeni pwülüan, nge neminewe esap kirikiringau ngeni. ");
INSERT INTO chk_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Lon ekei lapalap me ruu, ewe mwän epwe emwenato pwülüan we ren ewe souasor. Iwe, epwe uwato pwe eu asor fän iten neminewe ülüngat paun pilawa mi amas seni föün parli. Nge esap niniitä apüra won, esap pwal iseis apach mi pwokus won, pun ei eu asor seni eman mwän mi lukomong, eu asoren alelet, pwe mine a let epwe pwäla. ");
INSERT INTO chk_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Iwe, ewe souasor epwe emwenato ewe fefin o anomu fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Mürin, ewe souasor epwe üfi koluk mi pin lon eu sepi mi för seni pwül, epwe pwal tukei ekis moromoren pwülün lon ewe imwenfel seni mangaku o uwalong lon ewe koluk pwe epwe maras. ");
INSERT INTO chk_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Iwe, mürin ewe souasor epwe atomwa möküren ewe fefin o uwalong lon pöün ewe asoren alelet, iei ewe asoren lukomong. Nge ewe souasor epwe kamwöch lon pöün ewe koluk mi maras a atoto anümamau. ");
INSERT INTO chk_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Mürin, ewe souasor epwe üreni ewe fefin pwe epwe tipeeu ngeni ewe pwon fän akapel i epwe eäni ngeni. Epwe apasa, ‘Are kosap lisowu ngeni eman o alimengauok lupwen om ei pwüpwülü, kosap feiengau ren ewe anümamau ewe koluk mi maras a atoto. ");
INSERT INTO chk_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Nge are ka lisowu ngeni eman lupwen om ei pwüpwülü o püsin alimengauok, ");
INSERT INTO chk_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(iei otun ewe souasor epwe atolonga ewe fefin fän anümamauen ewe pwon mi fis fän akapel, mürin epwe sopwela le fos), ewe Samol mi Lapalap epwe föri pwe aramasom repwe leaweni itom lon ar ottek, epwe pwal föri pwe kopwe rit, nge lukom epwe pwola. ");
INSERT INTO chk_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Iwe, ei koluk mi atoto anümamau epwe tolong leutum pwe lukom epwe pwo, kopwe pwal rit.’ Iwe, ewe fefin epwe pälüeni, ‘Üa tipeeu ngeni. Epwe fis iei usun.’ ");
INSERT INTO chk_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Mürin, ewe souasor epwe makeetiu ekei kapasen anümamau lon eu puk o talü ekewe kapas lon ewe koluk mi maras. ");
INSERT INTO chk_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Iwe, mwen an epwe aünü ngeni ewe fefin ewe koluk mi maras a atoto anümamau o afisätä metek mi weires, ");
INSERT INTO chk_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ewe souasor epwe angei seni lepöün ewe fefin ewe asoren mongö, epwe assawa me fän mesen ewe Samol mi Lapalap o uwato ren ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Iwe, ewe souasor epwe tukei ekumwuch seni ewe asoren mongö, iei asisilan pwe a asor meinisin, o kenala me won ewe rongen asor. Mürin epwe aünü ngeni ewe fefin ewe koluk. ");
INSERT INTO chk_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Iwe, are neminewe a püsin alimengaua o kirikiringau ngeni pwülüan, ewe koluk mi atoto anümamau, ewe souasor a aünü ngeni, epwe tolong leutun o afisätä metek mi weires pwe lukan epwe pwo, epwe pwal rit. Iwe, aramasan repwe leaweni itan lon ar ottek. ");
INSERT INTO chk_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Nge are ewe fefin esap tipis, esap küw ewe feiengau, nge epwe tongeni nöünöü. ");
INSERT INTO chk_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Iei ewe allük fän iten eman mwän mi lukomong, lupwen pwülüan a lisowu ngeni eman o püsin alimengaua, lupwen an pwüpwülü, ");
INSERT INTO chk_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ika lupwen ekiekin lukomong a tolong lon leluken eman mwän, pwe a öümöüm ngeni pwülüan. Iwe, ätewe epwe anomu ewe fefin fän mesen ewe Samol mi Lapalap, nge ewe souasor epwe föri ngeni unusen pwüngün ei allük. ");
INSERT INTO chk_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Iwe, esap wor än ewe mwän tipis, nge ewe fefin epwe püsin mwärelong fän liwinin an tipis.” ");
INSERT INTO chk_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","pwe epwe üreni ekewe aramasen Israel: Are eman mwän ika eman fefin a eäni och sokun pwon pwe epwe püsin apini fän iten ewe Samol mi Lapalap ren an epwe eman Nasir, ");
INSERT INTO chk_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","epwe püsin apini seni wain me sakau mi pwichikar. Esap fokun ün finikar mi för seni wain ika seni sakau mi pwichikar, esap pwal ün chönün föün wain are ochoch föün minefö ika mi apwas. ");
INSERT INTO chk_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Iwe, ükükün ekewe rän meinisin a apini lon esap fokun ochei och mi pop seni irän wain, esap mwo nge eni ekewe kükün föün lon ika silin föün wain. ");
INSERT INTO chk_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Iwe, ükükün ekewe rän meinisin a pwonen apinipin lon esap fichi möküran. Tori wesöchülan ekewe rän a püsin apini fän iten ewe Samol mi Lapalap, i epwe pin. Iwe, epwe apwükü möküran pwe epwe langatam. ");
INSERT INTO chk_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Iwe, ükükün ekewe rän meinisin a püsin apini lon fän iten ewe Samol mi Lapalap esap fokun kan ngeni eman somä. ");
INSERT INTO chk_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ese lifilifil ika saman ika inan ika pwin ika fefinan a mäla, esap fokun püsin alimengaua ren an kan ngeniir. Pun meten möküran asisilen an apinipin fän iten Kot. ");
INSERT INTO chk_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ükükün ekewe rän meinisin a apini lon epwe pin fän iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Nge are eman aramas a müttir mäla ünükün pwe möküran mi pin a limengau, epwe reipöpöla möküran lon afisuen rän, iei ränin an limöchsefäl. ");
INSERT INTO chk_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Iwe, lon awaluen rän epwe uwato ruoman lisom ika ruoman apansüsün lisom ren ewe souasor leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Iwe, ewe souasor epwe eäni asor eman leir fän iten asoren tipis, nge ewe eman fän iten asoren kek. Iwe, epwe föri asoren amusamusen tipis fän iten ätewe, pun a tipis ren an kan ngeni ewe somä. Iwe, epwe apinisefäli möküran lon ewe chök ränin ");
INSERT INTO chk_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","o püsin apini fän iten ewe Samol mi Lapalap ükükün ekewe rän a pwon pwe epwe apinipin lon. Iwe, epwe pwal uwato eman ätemwänin lam eu ierin fän iten asoren pupungau. Nge ewe fansoun mesemwan esap chüen alea, pun a limengau lon fansoun an apinipin. ");
INSERT INTO chk_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Iwe, iei ewe allük fän iten ewe Nasir, lupwen a wes ränin an apinipin. Repwe emwenato leasamalapen ewe imwenfel seni mangaku, ");
INSERT INTO chk_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","nge i epwe uwato an asor ngeni ewe Samol mi Lapalap ülüman man esap wor terir: eman ätemwänin lam eu ierin pwe asoren kek, eman liefefinin lam eu ierin pwe asoren tipis, pwal eman ätemwänin sip pwe asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Epwe pwal uwato lon eu chük pilawa esap wor iis lon, pilawa mi mürina a nofit ngeni apüra, pwal sokun pilawa usun nokop mi toto ngeni apüra, fitifengen me ekewe asoren mongö me asoren ün. ");
INSERT INTO chk_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Iwe, ewe souasor epwe uwato ekei mettoch fän mesen ewe Samol mi Lapalap o eäni asor än ewe Nasir asoren tipis me asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Epwe pwal eäni asor ewe ätemwänin sip pwe asoren kinamwe ngeni ewe Samol mi Lapalap fitifengen me ewe pilawa esap wor iis lon seni lon ewe chük. Epwe pwal eäni asor ewe asoren mongö me asoren ün. ");
INSERT INTO chk_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Iwe, ewe Nasir epwe reipöpöla möküran mi apinipin leasamalapen ewe imwenfel seni mangaku. Mürin epwe angei meten möküran o isetä won ekkein ewe asoren kinamwe. ");
INSERT INTO chk_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Iwe, wesin an reipöpöla möküran, ewe souasor epwe angei pöün ewe ätemwänin sip mi kuk, epwe pwal angei me lon ewe chük eföü pilawa mi mürina me echö nokop esap wor iis lor o isenirelong lepöün ewe Nasir. ");
INSERT INTO chk_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Mürin, ewe souasor epwe assaweer pwe eu asoren assaw fän mesen ewe Samol mi Lapalap. Ikei ekewe kinikin mi pin epwe än ewe soausor fitifengen me ewe leup mi assaw me ewe angan. Mürin ewe Nasir a tongeni ün wain. ");
INSERT INTO chk_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Iei ewe allük fän iten eman Nasir mi angei ewe pwon. An asor ngeni ewe Samol mi Lapalap epwe alongolong won ükükün ewe pwonen Nasir. Nge lükün ekei asor a pwal tongeni asor ükükün an tufich. Iwe, epwe apwönüetä pwüngün ewe pwon a angei o föri ükükün allükün ewe pwonen Nasir. ");
INSERT INTO chk_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Kopwe üreni Aaron me nöün kewe mwän pwe repwe eäni ekei kapasen afeiöch ngeni ekewe aramasen Israel: ");
INSERT INTO chk_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Ewe Samol mi Lapalap epwe afeiöchükemi o tümwünükemi, ");
INSERT INTO chk_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ewe Samol mi Lapalap epwe netiu womi fän an kirikiröch o ümöümöch ngenikemi, ");
INSERT INTO chk_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ewe Samol mi Lapalap epwe wopwapwa ngenikemi o fang ngenikemi kinamwe.’ ");
INSERT INTO chk_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Iei usun repwe föüni itei won ekewe aramasen Israel, nge ngang üpwe afeiöchüür.” ");
INSERT INTO chk_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Iwe, lon ewe rän, lupwen Moses a wes le aüetä ewe imwenfel, a pwal apiti o apini fiti pisekin meinisin. A pwal apiti o apini ewe rongen asor fiti pisekin meinisin. ");
INSERT INTO chk_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Mürin, ekewe souemwenin Israel, ir mwänirelan ar cho pwal souemwenin ar kewe ainang mi nemenem won chokewe mi alea, ");
INSERT INTO chk_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ra uwato ar kewe asor ngeni ewe Samol mi Lapalap: wonofoch woken mi imweimw me engol me ruoman ätemwänin kow, efoch woken nge ruoman souemwen, pwal iteiten eman me eman souemwen nge eman ätemwänin kow. Ra uweereto leasamalapen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mürin, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Kopwe angei ekei asor seniir o ngeni ekewe mwän seni ewe ainangen Lefi pwe repwe aea le angang ngeni ewe imwenfel seni mangaku fän awenewenen en me wisan.” ");
INSERT INTO chk_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Iwe, Moses a angei ekewe woken me ekewe ätemwänin kow o ngeni ekewe mwän seni ewe ainangen Lefi. ");
INSERT INTO chk_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Iwe, a ngeni nöün Kerson kewe mwän ruofoch woken me föman ätemwänin kow fän awenewenen angangen wiser kewe. ");
INSERT INTO chk_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Nge fofoch woken me waluman ätemwänin kow a ngeni nöün Merari kewe mwän fän awenewenen angangen wiser kewe. Ir meinisin ra nom fän nemenemen Itamar nöün ewe souasor Aaron we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Nge nöün Kohat kewe mwän esap ngeniir och, pun ir ra wisen tümwünü ekewe mettoch mi pin repwe mwärei won afarer. ");
INSERT INTO chk_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Lon ewe rän, lupwen ewe rongen asor a kepit, ekewe souemwen ra pwal uwato ar kewe asor fän iten apinipinin ewe rongen asor o anomu mwen ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Pun ewe Samol mi Lapalap a üreni Moses, “Kopwe üreniir pwe repwe uwato ar kewe asor fän iten apinipinin ewe rongen asor, eman souemwen nge eu rän.” ");
INSERT INTO chk_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Iwe, lon aeuin rän Nason nöün Aminatap we mwän seni ewe ainangen Juta a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Nason nöün Aminatap we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Iwe, lon aruuen rän Netanel nöün Suar we mwän ewe souemwenin ewe ainangen Isakar a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Netanel nöün Suar we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Nge lon aülüngatin rän Eliap nöün Helon we mwän ewe souemwenin ewe ainangen Sepulon a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Eliap nöün Helon ewe mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Iwe, lon arüanün rän Elisur nöün Seteur we mwän, ewe souemwenin ewe ainangen Rupen a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Elisur nöün Seteur we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Nge lon alimuen rän Selumiel nöün Surisatai we mwän, ewe souemwenin ewe ainangen Simeon a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Selumiel nöün Surisatai we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Iwe, lon awonuen rän Eliasaf nöün Teuel we mwän, ewe souemwenin ewe ainangen Kat a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Eliasaf nöün Teuel we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Nge lon afisuen rän Elisama nöün Amihut we mwän, ewe souemwenin ewe ainangen Efraim a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Elisama nöün Amihut we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Iwe, lon awaluen rän Kamaliel nöün Petasur we mwän, ewe souemwenin ewe ainangen Manasa a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Kamaliel nöün Petasur we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Nge lon atiuen rän Apitan nöün Kiteoni we mwän, ewe souemwenin ewe ainangen Peniamin a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Apitan nöün Kiteoni we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Iwe, lon aengolun rän Ahieser nöün Amisatai we mwän, ewe souemwenin ewe ainangen Tan, a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Ahieser nöün Amisatai we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Nge lon engol me aeuin rän Pakiel nöün Okran we mwän, ewe souemwenin ewe ainangen Aser, a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Pakiel nöün Okran we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Iwe, lon engol me ruuen rän Ahira nöün Enan we mwän, ewe souemwenin ewe ainangen Naftali, a uwato an asor. ");
INSERT INTO chk_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","A eäni asor eu peleich seni silifer ükükün choun ülüngat eu lerüanü paun, pwal eu sepi seni silifer ükükün choun eu ülüngat lerüanü paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ir me ruu ra ur ren pilawa mi amas o mürina, a nofit ngeni apüra pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","A pwal eäni asor eu sepi seni kolt ükükün choun rüanü aunus, a ur ren apach mi pwokus, ");
INSERT INTO chk_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","eman nienifön ätemwänin kow, eman ätemwänin sip me eman ätemwänin lam eu ierin fän iten asoren kek. ");
INSERT INTO chk_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","A pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis, ");
INSERT INTO chk_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","pwal ruoman ätemwänin kow, liman ätemwänin sip, liman ätemwänin kuuch pwal liman ätemwänin lam eu ierir fän iten asoren kinamwe. Iei ükükün ewe asor än Ahira nöün Enan we mwän. ");
INSERT INTO chk_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Iwe, ie ükükün asoren apinipinin ewe rongen asor seni ekewe souemwenin Israel lon ewe rän a kepit: engol me ruu peleich seni silifer, engol me ruu sepi seni silifer pwal engol me ruu sepi seni kolt. ");
INSERT INTO chk_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Iwe, ükükün choun eu me eu peleich seni silifer ülüngat eu lerüanü paun, nge ükükün choun eu me eu sepi seni silifer eu ülüngat lerüanü paun, pwe ükükün choun ewe silifer seni ekewe sepi meinisin wone paun, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Iwe, ükükün choun eu me eu ekewe engol me ruu sepi seni kolt mi ur ren apach mi pwokus rüanü aunus, a för won ewe kilo ra aea le aükük lon ewe imw mi pin. Nge ükükün choun ewe kolt seni ekewe sepi meinisin ülüngat paun. ");
INSERT INTO chk_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Iwe, ükükün ekewe man fän iten ewe asoren kek: engol me ruoman ätemwänin kow, engol me ruoman ätemwänin sip me engol me ruoman ätemwänin lam eu ierir repwe chu ngeni ekewe asoren mongö, pwal engol me ruoman ätemwänin kuuch fän iten asoren tipis. ");
INSERT INTO chk_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Nge ükükün ekewe man fän iten ewe asoren kinamwe: rüe me föman ätemwänin kow, wone ätemwänin sip, wone ätemwänin kuuch me wone ätemwänin lam eu ierir. Iei ükükün asoren apinipinin ewe rongen asor mürin an kepit. ");
INSERT INTO chk_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Iwe, lupwen Moses a tolong lon ewe imw mangaku ia aramas ra churi Kot ie, pwe epwe kapas ngeni ewe Samol mi Lapalap, a rongorong eu möngüngü a fosowu seni lefilen ekewe ruoman kerop mi nom won öppüngün ewe pworofel. Iwe, Kot a kapas ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Kopwe üreni Aaron pwe lupwen epwe pacheetä ekewe fisu lamp won ewe lenien atittin, epwe föri pwe tiner epwe asarama mwan.” ");
INSERT INTO chk_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Iwe, Aaron a föri iei usun. A pacheetä ekewe lamp won ewe lenien atittin pwe tiner epwe asarama mwan, usun ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Iei usun förün ewe lenien atittin: a för seni kolt mi nechenech seni alongun tori ekewe uluulun pön irän won. Moses a föri ewe lenien atittin usun mine ewe Samol mi Lapalap a aiti ngeni. ");
INSERT INTO chk_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Kopwe aimwüela ekewe mwän seni ewe ainangen Lefi seni lein ekewe aramasen Israel o limetiir. ");
INSERT INTO chk_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Iei usun angangen om kopwe limetiir: Kopwe äsupu wor ewe kolukun limelim, nge ir repwe räisöü ülöülen unusen inisir, repwe pwal sopuni üfer o püsin limetiir. ");
INSERT INTO chk_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Mürin repwe angei eman nienifön ätemwänin kow o achu ngeni ewe asoren mongö seni pilawa mi amas o mürina a nofit ngeni apüra. Nge en kopwe angei pwal eman nienifön ätemwänin kow fän iten asoren tipis. ");
INSERT INTO chk_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Iwe, kopwe emwenato ekewe mwän seni ewe ainangen Lefi mwen ewe imw mangaku ia aramas ra churiei ie, o amwichafengeni ekewe aramasen Israel meinisin. ");
INSERT INTO chk_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Iwe, lupwen ka aüteer fän mesei, ekewe aramasen Israel repwe anomu pöür wor. ");
INSERT INTO chk_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Mürin, Aaron epwe fangala ngeniei ekewe mwän seni ewe ainangen Lefi pwe eu asoren assaw seni ekewe aramasen Israel, pwe ir repwe wisen föri ai angang. ");
INSERT INTO chk_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Mürin, ekewe mwän seni ewe ainangen Lefi repwe anomu pöür won ekewe ätemwänin kow. Iwe, en kopwe eäni asor ngeniei eman fän iten asoren tipis, nge eman fän iten asoren kek, pwe kopwe föri asoren amusamusen tipis fän iter. ");
INSERT INTO chk_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Iwe, kopwe apini fän itei ekewe mwän seni ewe ainangen Lefi pwe repwe eu asor ngeniei, nge Aaron me nöün kewe mwän repwe nemeniir. ");
INSERT INTO chk_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Iei usun kopwe aimwüela ekewe mwän seni ewe ainangen Lefi seni lein ekewe aramasen Israel pwe ir repwe nei. ");
INSERT INTO chk_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Iwe, wesin om limetiir o apiniir fän itei, ekewe mwän seni ewe ainangen Lefi repwe tolong lon ewe imwenfel seni mangaku o föri ar angang. ");
INSERT INTO chk_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Pun ir eu lifang mi unus ngeniei seni lein ekewe aramasen Israel. Üa angeir pwe repwe nei, akasiwilin ekewe mwänichi me lein ekewe aramasen Israel meinisin. ");
INSERT INTO chk_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Iwe, ekewe mwänichi meinisin seni lein ekewe aramasen Israel me ekewe mweinöün man nei. Lon ewe rän üa niela ekewe mwänichi meinisin lon ewe fanü Isip, üa apiniir fän itei. ");
INSERT INTO chk_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nge üa angei ekewe mwän seni ewe ainangen Lefi akasiwilin ekewe mwänichi meinisin me lein ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Iwe, üa ngeni Aaron me nöün kewe ekewe mwän seni ewe ainangen Lefi pwe eu lifang seni ekewe aramasen Israel, pwe repwe föri ar angang ngeni ekewe chon Israel lon ewe imwenfel seni mangaku, repwe pwal föri asoren amusamusen tipis fän iter, pwe esap toriir mätter, lupwen repwe kaneto ren ewe imw mi pin.” ");
INSERT INTO chk_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Iei usun Moses me Aaron me ekewe aramasen Israel meinisin ra föri ngeni ekewe mwän seni ewe ainangen Lefi meinisin mine ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Iwe, ekewe mwän seni ewe ainangen Lefi ra püsin limetiir o sopuni üfer. Nge Aaron a apiniir pwe repwe eu asor ngeni ewe Samol mi Lapalap o föri asoren amusamusen tipis fän iter, pwe repwe limöch. ");
INSERT INTO chk_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Mürin, ekewe mwän seni ewe ainangen Lefi ra tolong lon ewe imwenfel seni mangaku, pwe repwe föri angangen wiser fän nemenien Aaron me nöün kewe mwän. Usun ewe Samol mi Lapalap a allük ngeni Moses fän iter, iei usun ekewe aramas ra föri ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Iei ewe akot ngeni ekewe mwän seni ewe ainangen Lefi: Seni ier rüe me limu feitä repwe tolong lon ewe imwenfel seni mangaku o föri angangen lon. ");
INSERT INTO chk_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Nge lupwen ra ierini lime, repwe ükütiu seni angangen wiser. ");
INSERT INTO chk_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Iwe, ra tongeni alisi chiener kewe le föri ewe angangen lon ewe imwenfel seni mangaku, nge esap chüen wor ar nemenem. Iei usun kopwe awisa ekewe mwän seni ewe ainangen Lefi ngeni wiser.” ");
INSERT INTO chk_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Iwe, lon aeuin maramen ewe aruuen ier mürin än chon Israel towu seni ewe fanü Isip, ewe Samol mi Lapalap a kapas ngeni Moses me lon ewe fanüapön Sinai, ");
INSERT INTO chk_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Kopwe üreni ekewe aramasen Israel pwe repwe föri ewe Pasofer lon fansoun mi filitä. ");
INSERT INTO chk_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Lekuniolupwinin ewe engol me rüanün ränin ei maram repwe föri ewe Pasofer, repwe pwal föri pwüngün me allükün meinisin.” ");
INSERT INTO chk_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Iei mine Moses a üreni ekewe aramasen Israel pwe repwe föri ewe Pasofer. ");
INSERT INTO chk_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Iwe, lekuniolupwinin ewe engol me rüanün ränin ewe aeuin maram ra föri ewe Pasofer lon ewe fanüapön Sinai. Ekewe aramasen Israel ra föri meinisin mine ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nge mi wor ekoch mwän ra limengau ren ar atapa eman somä, iei mine resap tongeni eti ewe pasofer lon ewe rän. Iwe, ra feito ren Moses me Aaron lon ewe ränin o üreniir, ");
INSERT INTO chk_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“Äm aia limengau ren äm atapa eman somä. Pwota äm aisap tongeni eäni ewe asor ngeni ewe Samol mi Lapalap fiti ekewe lusun aramasen Israel lon ewe fansoun mi filitä?” ");
INSERT INTO chk_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Iwe, Moses a üreniir, “Oupwe mwo ekis witiwit tori üpwe silei mine ewe Samol mi Lapalap epwe allük usumi.” ");
INSERT INTO chk_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Kopwe üreni ekewe aramasen Israel: Are eman mwän seni leimi ika seni mwirimwirimi kana a limengau ren an atapa eman somä ika a toau seni fanüan, ätewe epwe pwal tongeni föri ewe Pasofer ngeniei. ");
INSERT INTO chk_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ekei sokun aramas repwe tongeni föri ewe Pasofer lekuniolupwinin ewe engol me rüanün ränin ewe aruuen maram. Repwe ochoch ewe lamen Pasofer o mongö pilawa esap wor iis lon fiti chön irä mi kipwin. ");
INSERT INTO chk_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Nge resap likiti och tori lesosor, resap pwal kupi efoch chün. Iwe, repwe chök föri pwüngün allükün ewe Pasofer meinisin. ");
INSERT INTO chk_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Nge eman mwän mi limöch, esap pwal toau seni fanüan, are i esap mochen föri ewe Pasofer, epwe käriwu me lein aramasan, pun esap eäni ewe asor ngeniei lon ewe fansoun mi filitä. Iwe, ewe aramas epwe angei chappen an tipis. ");
INSERT INTO chk_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Nge are eman chon ekis mi nom remi a mochen föri ewe pasofer ngeniei, epwe chök föri lon pwüngün me allükün ewe Pasofer. Iwe, epwe chök wor eu allük fän iten chon ekis me chon wilipos.” ");
INSERT INTO chk_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Iwe, lon ewe rän ewe imwenfel seni mangaku a kaütä, iei ewe ia ekewe allük ra nom ie, ewe kuchu a pwölüela. Nge seni lekuniol tori lesosor ewe kuchu asen ewe imwenfel seni mangaku a usun chök ekkei. ");
INSERT INTO chk_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Iei usun a fis fansoun meinisin. Ewe kuchu a pwölüela ewe imwenfel seni mangaku lerän, nge lepwin a usun chök ekkei. ");
INSERT INTO chk_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Iwe, iteiten fansoun, lupwen ewe kuchu a wiitä seni won ewe imwenfel seni mangaku, ekewe aramasen Israel ra sai. Nge ewe ia ewe kuchu a üla ie, ekewe aramasen Israel ra aüetä imwer. ");
INSERT INTO chk_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Iwe, ekewe aramasen Israel ra sai fän än ewe Samol mi Lapalap allük, ra pwal aüetä imwer fän an allük. Ükükün fansoun än ewe kuchu nom asen ewe imwenfel seni mangaku, pwal iei ükükün fansoun ra nonom lon ewe leni. ");
INSERT INTO chk_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Iwe, are ewe kuchu a nonomotam asen ewe imwenfel seni mangaku lon chomong rän, ekewe aramasen Israel resap sai, pun ra aleasochis ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Lon ekoch fansoun ewe kuchu a nom asen ewe imwenfel seni mangaku ekoch chök rän. Iwe, fän än ewe Samol mi Lapalap allük ra nom lon ewe leni, nge fän an allük ra pwal sai. ");
INSERT INTO chk_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Iwe, lon ekoch fansoun ewe kuchu a chök üla seni lekuniol tori lesosor. Nge lesosor, lupwen ewe kuchu a wiitä, ra sai. Ika mwo lerän ika lepwin, lupwen ewe kuchu a wiitä, ra sai. ");
INSERT INTO chk_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ese lifilifil are ewe kuchu a üla asen ewe imwenfel seni mangaku ruu rän ika eu maram ika eu ier, ekewe aramasen Israel ra chök nonom lon lenier, nge resap sai. Nge lupwen ewe kuchu a wiitä, ra chök sai. ");
INSERT INTO chk_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Iwe, fän än ewe Samol mi Lapalap allük ra nonom lon lenier, nge fän an allük ra pwal sai. Ra chök aleasochis ngeni än ewe Samol mi Lapalap allük Moses a ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Kopwe föri ruofoch rappwa seni silifer mi nechenech ngeni ama. Iwe, kopwe ettikiir, lupwen kopwe körifengeni ekewe aramasen Israel, pwal lupwen repwe atomwala imwer. ");
INSERT INTO chk_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Iwe, lupwen ekewe ruofoch rappwa repwe tikitam, ekewe aramasen Israel meinisin repwe mwichefengen reöm leasamalapen ewe imw mangaku ia aramas ra churiei ie. ");
INSERT INTO chk_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Nge ika efoch chök a tik, ekewe souemwen, ekewe mwänirelan ekewe ainangen Israel repwe mwichefengen reöm. ");
INSERT INTO chk_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Iwe, lupwen oupwe ettiki ewe tikin asilesil mi tikimoch, ekewe aramas mi nonom peliötiuen ewe imwenfel seni mangaku repwe sai. ");
INSERT INTO chk_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Nge lupwen oupwe ettiki ewe tikin asilesil mi tikimoch fän aruuan, ekewe mi nonom peliörün repwe sai. Ewe tikin asilesil mi tikimoch epwe tik iteiten fansoun repwe sai. ");
INSERT INTO chk_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Iwe, lupwen ekewe aramasen Israel repwe mwichefengen, oupwe chök ettikitama ekewe rappwa, nge ousap ettiki ewe tikin asilesil mi tikimoch. ");
INSERT INTO chk_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Iwe, nöün Aaron kewe mwän ekewe souasor repwe ettiki ekewe rappwa. Ei epwe eu allük fochofoch ngenikemi seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Iwe, lupwen oupwe feila maun ngeni chon oputakemi mi ariaföüükemi me lon fanüemi, oupwe ettiki ewe tikin asilesilen maun ren ekewe rappwa. Mürin, ngang ewe Samol mi Lapalap ämi we Kot üpwe alisikemi o amanauakemi seni chon oputakemi. ");
INSERT INTO chk_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Oupwe ettiki ekewe rappwa pwal lon ränin ämi pwapwa, lupwen fansoun ämi kewe chulap mi kefilitä me lepoputän ekewe maram. Oupwe ettiki ekewe rappwa lupwen fansoun ämi eäni asoren kek me asoren kinamwe. Mürin üpwe alisikemi. Ngang ewe Samol mi Lapalap ämi we Kot.” ");
INSERT INTO chk_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Iwe, lon aruuen ränin ewe aruuen maram lon aruuen ier mürin än chon Israel towu seni Isip, ewe kuchu a wiitä seni won ewe imwenfel seni mangaku ewe ia ekewe allük ra nom ie. ");
INSERT INTO chk_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Iwe, ekewe aramasen Israel ra sai seni ewe fanüapön Sinai lon tettelir. Iwe, ewe kuchu a üla lon ewe fanüapön Paran. ");
INSERT INTO chk_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ekkärän iei aeuin ar sai fän än ewe Samol mi Lapalap allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Iwe, ekewe mwich mi nom lon kinikinin Juta ra akom le sai lon tettelir fän ar filäik. Nge Nason nöün Aminatap mwän i souemwenin chon ewe ainangen Juta. ");
INSERT INTO chk_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Iwe, Netanel nöün Suar mwän i souemwenin chon ewe ainangen Isakar. ");
INSERT INTO chk_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Nge Eliap nöün Helon mwän i souemwenin chon ewe ainangen Sepulon. ");
INSERT INTO chk_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Iwe, mürin än ewe imwenfel seni mangaku katomwola, nöün Kerson me Merari kewe mwän mi wisen mwärei ra sai. ");
INSERT INTO chk_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Mürin ekewe mwich mi nom lon kinikinin Rupen ra sai lon tettelir fän ar filaik. Nge Elisur nöün Seteur mwän i souemwenin chon ewe ainangen Rupen. ");
INSERT INTO chk_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Iwe, Selumiel nöün Surisatai mwän i souemwenin chon ewe ainangen Simeon. ");
INSERT INTO chk_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Nge Eliasaf nöün Teuel mwän i souemwenin chon ewe ainangen Kat. ");
INSERT INTO chk_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Mürin, än Kohat cho ra sai. Ra mwärei ekewe mettoch mi pin. Nge lupwen ra tori ewe leni ia ra asösö ie, ewe imwenfel seni mangaku a fen kaütä. ");
INSERT INTO chk_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Mürin, ekewe mwich mi nom lon kinikinin Efraim ra sai lon tettelir fän ar filaik. Nge Elisama nöün Amihut mwän i souemwenin chon ewe ainangen Efraim. ");
INSERT INTO chk_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Iwe, Kamaliel nöün Petasur mwän i souemwenin chon ewe ainangen Manasa. ");
INSERT INTO chk_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Nge Apitan nöün Kiteoni mwän i souemwenin chon ewe ainangen Peniamin. ");
INSERT INTO chk_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Iwe, ekewe mwich mi nom lon kinikinin Tan ra kükümwirifoch seni ekewe mwich meinisin. Ra sai lon tettelir fän ar filaik, nge Ahieser nöün Amisatai mwän i souemwenin chon ewe ainangen Tan. ");
INSERT INTO chk_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Iwe, Pakiel nöün Okran mwän i souemwenin chon ewe ainangen Aser. ");
INSERT INTO chk_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Nge Ahira nöün Enan mwän i souemwenin chon ewe ainangen Naftali. ");
INSERT INTO chk_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Iei tettelin än ekewe aramasen Israel sai lon ar kewe mwich iteiten fansoun ar sai. ");
INSERT INTO chk_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Iwe, Moses a üreni Hopap nöün Setiro we mwän ewe re Mitian, nge Setiro semen pwülüen Moses, “Iei äm aipwe le sai ngeni ewe leni ewe Samol mi Lapalap a pwon pwe epwe ngenikem. Kopwe etikem, nge äm aipwe kirikiröch ngonuk, pun ewe Samol mi Lapalap a pwon pwe epwe awöüü ekewe chon Israel.” ");
INSERT INTO chk_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Nge Hopap a üreni, “Üsap etikemi. Üpwe liwinsefäliti poputän fanüei me aramasei.” ");
INSERT INTO chk_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Iwe, Moses a üra, “Üa tüngoreek, kose mochen kosap likitikem. Pun en ka silei ia aipwe aüetä imwem ie lon ewe fanüapö. En kopwe emwenikem. ");
INSERT INTO chk_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Iwe, are kopwe etikem, aipwe pwal ngonuk ewe feiöch ewe Samol mi Lapalap epwe ngenikem.” ");
INSERT INTO chk_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Iwe, ekewe aramasen Israel ra sai seni chukun ewe Samol mi Lapalap o sai lon ükükün ülüngat rän. Nge än ewe Samol mi Lapalap we pworun pwon a akomwola mwer, pwe epwe kütta ia repwe asösö ie. ");
INSERT INTO chk_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Iwe, kuchun ewe Samol mi Lapalap a nom wor lerän iteiten fansoun lupwen ra sai seni lenier. ");
INSERT INTO chk_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Iwe, iteiten fansoun lupwen ewe pworofel a sai, Moses a apasa, “Äm Samol mi Lapalap, kopwe ütä o atoropasafeili chon pälüenuk, nge ekewe mi oputok repwe sü me mwom.” ");
INSERT INTO chk_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Nge iteiten fansoun lupwen ewe pworofel a asösö, Moses a apasa, “Äm Samol mi Lapalap, kopwe liwinto ren ekei ngeröüröün chon Israel.” ");
INSERT INTO chk_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Nge ekewe aramas ra popuetä le lal ngeni ewe Samol mi Lapalap usun ar weires. Iwe, lupwen ewe Samol mi Lapalap a rong, a song o awora eu ekkei lefiler. A küwu me leir o kenala eu kinikinin lesopun ewe ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mürin, ekewe aramas ra siö ngeni Moses. Nge Moses a iotek ngeni ewe Samol mi Lapalap. Iwe, ewe ekkei a kunula. ");
INSERT INTO chk_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Iwe, ra aita ngeni ewe leni Tapera , pun ewe ekkei seni ewe Samol mi Lapalap a küwu me leir. ");
INSERT INTO chk_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Iwe, a wor eu mwichen chon ekis mi ngau mi eti ekewe chon Israel lon ar sai. Ekei aramas ra mwäräkich won fituk, pwal ekewe aramasen Israel ra lalsefäl o apasa, “Amwo sia fen ochoch fituk. ");
INSERT INTO chk_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sia chechemeni ekewe ik sia mongö lon Isip, nge sisap möni. Sia pwal chechemeni ach ochoch küri me senia, nengi me anion pwal ninnikü. ");
INSERT INTO chk_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Nge iei sia chök apwangapwangala. Esap fokun wor och sokun mongö lükün ewe mana sia küna.” ");
INSERT INTO chk_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Iwe, ewe mana a usun chök kükün föün irä, nge anüwan a oleolepwech. ");
INSERT INTO chk_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Iwe, ekewe aramas ra fetalfeil o ionifengeni ewe mana, ra pwal fööira lon lenien fööir ika wüsi lon lenien wüsüs. Mürin ra kuku lon nape o nokopuni. Iwe, nennan a usun nennen nokop mi firain lon apüra. ");
INSERT INTO chk_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Iwe, lupwen amurenipwin a püngütiu lepwin won ewe ia ra nonom ie, ewe mana a pwal püngütiu. ");
INSERT INTO chk_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Iwe, Moses a rong än ekewe aramas lal lon en me asamalapen imwan imw mangaku lon iteiten en me an famili. Iwe, ewe Samol mi Lapalap a fokun song, nge Moses a weires ren. ");
INSERT INTO chk_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Iwe, Moses a aisini ewe Samol mi Lapalap, “Pwota ka aweiresiei ngang noum chon angang? Pwota kosap ümöümöch ngeniei pwe ka fen uwätä woi weiresin tümwünün ekei aramas meinisin? ");
INSERT INTO chk_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ifa usun, upun woi ir meinisin? Ir nei, pwe kopwe üreniei pwe üpwe pwisiir lepei usun eman chon tümwün a pwisi eman mönükol mi chüen oupw? Ifa usun, üpwe pwisirelong lon ewe fanü ka pwon ngeni ar kewe lewo pwe kopwe ngeniir? ");
INSERT INTO chk_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ia üpwe küt me ie fituk pwe üpwe ngeni ekei aramas meinisin? Pun ra lal ngeniei o üra, ‘Kopwe ngenikem fituk pwe aipwe ochoch.’ ");
INSERT INTO chk_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ngang üsap tufich le akaleäman ngeni weiresin tümwünün ekei aramas, pun a kon chou ngeniei. ");
INSERT INTO chk_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nge are kopwe föri iei usun ngeniei, kopwe ümöümöch ngeniei o nieila iei chök pwe üsap chüen küna ei sokun weires.” ");
INSERT INTO chk_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe körato rei fik mwän seni lein ekewe souakomwen Israel, chokewe ka sileer pwe ir souakom me sounemenemen ekewe aramas. Kopwe emwenireto ren ewe imw mangaku ia aramas ra churiei ie, pwe repwe etuk le ütä ikenan. ");
INSERT INTO chk_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ngang üpwe feitiu o kapas ngonuk ikenan. Iwe, üpwe angei och manamanen ewe ngün mi nom womw o isetä wor. Repwe etuk le mwärelong fän weiresin tümwünün ekewe aramas pwe kosap akaleäman le mwärelong fan. ");
INSERT INTO chk_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Iwe, kopwe üreni ekewe aramas, ‘Oupwe apinikemi fän iten lesor pwe oupwe ochoch fituk. Pun ewe Samol mi Lapalap a rongorong ämi lal pwal ämi apasa: Iö epwe ngenikem ochäm fituk? Pun aia nonomöch lon Isip. Iei mine ewe Samol mi Lapalap epwe ngenikemi fituk pwe oupwe ochoch. ");
INSERT INTO chk_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nge ousap ochoch fituk lon eu chök rän ika ruu rän ika limu rän ika engol rän ika rüe rän, ");
INSERT INTO chk_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","pwe lon unusen eu maram, tori epwe nipoon ngenikemi o notä womi. Pun oua oput ewe Samol mi Lapalap mi nom lefilemi o lal ngeni lupwen oua apasa: Pwota mwo chök sia towu seni Isip?’” ");
INSERT INTO chk_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Nge Moses a üreni Kot, “Iei üa emweni wonopükü ngeröü aramas, nge en ka apasa pwe kopwe ngeniir fituk, pwe repwe ochoch lon ükükün unusen eu maram. ");
INSERT INTO chk_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ifa usun, epwe naf ekewe pwiin sip me kow, pwe repwe ninnila fän iter? Ika epwe naf ngeniir ikenen leset meinisin?” ");
INSERT INTO chk_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Nge ewe Samol mi Lapalap a pälüeni Moses, “Ifa usun, a aükük ai manaman? Iei kopwe küna ika ai kapas ngonuk epwe fis ika esap fis.” ");
INSERT INTO chk_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Iwe, Moses a feila o asile ngeni ekewe aramas än ewe Samol mi Lapalap kapas. A emwichato fik mwän seni me lein ekewe souakomwen ekewe aramas o anomuur pwelin ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Mürin, ewe Samol mi Lapalap a feitiu lon ewe kuchu o kapas ngeni Moses. A angei och manamanen ewe ngün mi nom won Moses o isetä won ekewe fik souakom. Iwe, lupwen ewe ngün a nom wor, ra osuni. Nge mürin resap chüen osunisefäli. ");
INSERT INTO chk_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Nge mi wor ruoman mwän iter Eltat me Metat ra alealaong lein ekewe fik ra chök nom lon ewe ia ra nonom ie, nge resap feila ren ewe imwenfel seni mangaku. Iwe, ewe ngün a feito wor pwe ra pwal osuni me ewe ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Iwe, eman alüal a säla ren Moses o üreni, “Eltat me Metat ra osuni me lon ewe leni ia ra nonom ie.” ");
INSERT INTO chk_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nge Josua nöün Nun mwän, nöün Moses we soualilis seni lealüalün, a apasa, “Ai samol Moses, kopwe aükätiu ar osuni.” ");
INSERT INTO chk_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Nge Moses üreni, “Ifa usun, ka apangau won wisei? Amwo, nöün ewe Samol mi Lapalap aramas meinisin repwe soufos, pwe epwe anomu Ngünün wor.” ");
INSERT INTO chk_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mürin, Moses me ekewe souakomwen Israel ra liwiniti ewe ia ekewe aramasen Israel ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Iwe, ewe Samol mi Lapalap a awora och asepwäl mi pönato mansüsü iter kweil seni lematau. Iwe, ra nom pwelin ewe ia ekewe aramasen Israel ra nonom ie ükükün langatamen än eman sai lon eu rän me lepelian meinisin, nge ra ässitiu tori ükükün ülüngat fiit seni won pwül. ");
INSERT INTO chk_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Iwe, ekewe aramas ra ütä o ionifengeni ekewe kweil lon unusen ewe rän me unusen ewe pwin tori unusen ewe rän mürin. Nge ätewe mi chokükün ionian a ioni ükükün ülüngat ngeröü wonopükü paun. Iwe, ra apwaseer pwelin ünükün lenier we. ");
INSERT INTO chk_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nge lupwen ra chüen ochoch ewe fituk, nge esamwo itela, ewe Samol mi Lapalap a fokun song ngeniir, pwe a niela ekewe aramas ren eu mätter mi watte. ");
INSERT INTO chk_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Iei popun ewe leni a iteni Kiprot-atawa , pun ikenan ra peiaseni ekewe aramas mi mwäräkich. ");
INSERT INTO chk_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Iwe, ekewe aramas ra sai seni Kiprot-atawa o sai ngeni Haserot. Iwe, ra nonom Haserot. ");
INSERT INTO chk_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Iwe, Miriam me Aaron ra esita Moses pokiten ewe fin Kuus Moses a pwülüeni. ");
INSERT INTO chk_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ra apasa, “Ifa usun, ewe Samol mi Lapalap a chök wesewesen fos ngeni Moses? Esap pwal fos ngenikich?” Iwe, ewe Samol mi Lapalap a rong ei fos. ");
INSERT INTO chk_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Nge Moses eman mwän mi tipetekison, a fokun tipetekison seni aramasen fanüfan meinisin. ");
INSERT INTO chk_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Iwe, ewe Samol mi Lapalap a müttir kapas ngeni Moses, Aaron me Miriam, “Oupwe towu ämi me ülüman o feila ren ewe imw mangaku ia aramas ra churiei ie.” Iwe, ir me ülüman ra feila. ");
INSERT INTO chk_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Mürin, ewe Samol mi Lapalap a feitiu lon eu ürekuchu, a ütä leasamalapen ewe imwenfel seni mangaku o körato Aaron me Miriam. Iwe, ir me ruoman ra feito. ");
INSERT INTO chk_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Iwe, a üreniir, “Oupwe aüseling ai kapas: Are mi wor eman soufos leimi, ngang ewe Samol mi Lapalap üpwe pwäri ngeni üsi lon künan, üpwe pwal kapas ngeni lon an tan. ");
INSERT INTO chk_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nge esap iei usun ren nei ei chon angang Moses. Pun üa lükü ngeni nei aramasen Israel meinisin. ");
INSERT INTO chk_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Üa fos newenewen ngeni lon kapas mi fat, nge sap lon kapas monomon. Nge i a fen küna lapalapei. Pwota chök ousap niuokus le esita nei ei chon angang Moses?” ");
INSERT INTO chk_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Iwe, ewe Samol mi Lapalap a song ngeniir. Mürin a feila seniir. ");
INSERT INTO chk_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Nge lupwen ewe kuchu a wiitä seni ewe imw mangaku, nengeni, Miriam a üri rupun pwötür pwe inisin a pwechepwech usun snow. Iwe, Aaron a sap ngeni Miriam o küna pwe a üri rupun pwötür. ");
INSERT INTO chk_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Mürin, Aaron a üreni Moses, “Ai samol, kose mochen kosap amwöchü äm tipis aia föri ngonuk lon äm miritingau. ");
INSERT INTO chk_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Kosap mwütätä pwe Miriam epwe wewe ngeni eman mi mäla, lupwen a uputiu, mi pweila esop fitukan.” ");
INSERT INTO chk_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Iwe, Moses a siö ngeni ewe Samol mi Lapalap, “Üa tüngor ngonuk ai Kot, kose mochen kopwe apöchöküla neminei.” ");
INSERT INTO chk_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Nge ewe Samol mi Lapalap a üreni Moses, “Ifa usun, are saman a atufa mesan, neminewe esap säw lon ükükün fisu rän? Epwe kaimwüla lükün ewe ia oua nonom ie lon ükükün fisu rän, mürin a tongeni liwinsefäl.” ");
INSERT INTO chk_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Iei mine Miriam a imwüla lükün ewe ia ra nonom ie lon ükükün fisu rän. Iwe, ekewe aramas resap sai tori Miriam a liwiniti lenier we. ");
INSERT INTO chk_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Iwe, mürin, ekewe aramas ra sai seni Haserot tori ewe fanüapön Paran o nonom ikenan. ");
INSERT INTO chk_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Kopwe tinala ekoch mwän pwe repwe operi ewe fanü Kanaan, ewe fanü üpwe ngeni ekewe aramasen Israel. Kopwe tinala akaeman souemwen seni eu me eu ainangen semelaper kewe.” ");
INSERT INTO chk_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Iei mine Moses a tinirela seni ewe fanüapön Paran, usun ewe Samol mi Lapalap a allük. Nge ekewe mwän meinisin ir mwänirelan ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Iwe, ikkei iter: Samua nöün Sakur mwän seni ewe ainangen Rupen, ");
INSERT INTO chk_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Safat nöün Hori mwän seni ewe ainangen Simeon, ");
INSERT INTO chk_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kalep nöün Jefune mwän seni ewe ainangen Juta, ");
INSERT INTO chk_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Ikal nöün Josef mwän seni ewe ainangen Isakar, ");
INSERT INTO chk_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hosea nöün Nun mwän seni ewe ainangen Efraim, ");
INSERT INTO chk_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti nöün Rafu mwän seni ewe ainangen Peniamin, ");
INSERT INTO chk_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Katiel nöün Soti mwän seni ewe ainangen Sepulon, ");
INSERT INTO chk_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kati nöün Susi mwän seni ewe ainangen Josef, wesewesen seni ewe ainangen Manasa, ");
INSERT INTO chk_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amiel nöün Kemali mwän seni ewe ainangen Tan, ");
INSERT INTO chk_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setur nöün Mikael mwän seni ewe ainangen Aser, ");
INSERT INTO chk_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Napi nöün Wofsi mwän seni ewe ainangen Naftali, ");
INSERT INTO chk_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Keuel nöün Maki mwän seni ewe ainangen Kat. ");
INSERT INTO chk_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ikkei ir ekewe mwän Moses a tinirela pwe repwe operi ewe fanü. Nge Hosea nöün Nun we mwän Moses a aita ngeni Josua. ");
INSERT INTO chk_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Iwe, lupwen Moses a tinirela, a üreniir, “Oupwe feitä lon ewe fanü Nekep o feila ngeni ewe fanü mi chukuchukutä, ");
INSERT INTO chk_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","pwe oupwe ouwasacha lapalapen ewe fanü, are ekewe aramas mi nonom won ra pöchökül ika apwangapwang, are ra chokükün ika chomong. ");
INSERT INTO chk_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Oupwe ouwasacha are ewe fanü a mürina ika ngau, are ar kewe telinimw ra imweimw lon telinimw resap tit ika telinimw mi pöchökül tittir, ");
INSERT INTO chk_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","are ewe fanü a fanüeräs ika esap, are a mär irä won ika esap. Oupwe tipepwora o uwato ekoch föün irän ewe fanü.” Iwe, ei fansoun a otun nupun mwen uän irän wain. ");
INSERT INTO chk_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Iwe, ekewe chon op ra feitä o operi ewe fanü seni ewe fanüapön Sin tori Rehop arap ngeni ewe al a ale ngeni Hamat. ");
INSERT INTO chk_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ra feitä akomw lon ewe fanü Nekep o tori Hepron ia Ahiman, Sesai me Talmai, ekewe mwirimwirin Anak, ra imweim ie. Nge ewe telinimw Hepron a kaütä fisu ier mwen ewe telinimw Soan lon Isip a kaütä. ");
INSERT INTO chk_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Iwe, ra tori ewe lemolun Eskol, ewe ia ra kini me ie eumw umwun föün wain mi umwumong. Iwe, ruoman leir ra ämwära won efoch ämwär. Ra pwal uwato ekoch föün apel me föün fiik. ");
INSERT INTO chk_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Iwe, ra aita ngeni ewe leni lemolun Eskol pokiten ewe umwun föün wain ekewe re Israel ra kini me ikenan. ");
INSERT INTO chk_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Iwe, amüchülan faik rän, ekewe chon op ra liwinto seni ar operi ewe fanü. ");
INSERT INTO chk_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Iwe, ra feito ren Moses me Aaron me ekewe aramasen Israel meinisin mi nom lon Kates lon ewe fanüapön Paran. Iwe, ra apworausa ngeniir pworauser, ra pwal apii ngeniir uän irän ewe fanü. ");
INSERT INTO chk_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Iwe, ra üreni Moses, “Äm aia tori ewe fanü ia ka tinikeemila ie. Ewe fanü eu fanü mi pwülüöch o fanüeräs, nge iei uan. ");
INSERT INTO chk_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nge ekewe aramas mi nonom lon ewe fanü ra pöchökül, pwal ekewe telinimw ra watte o pöchökül tittir. Iwe, ikenan aia pwal mwo nge küna ekewe mwirimwirin Anak mi mwänemong. ");
INSERT INTO chk_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ekewe chon Amalek ra nonom lon ewe fanü Nekep. Iwe, ekewe chon Hit, chon Jepus me chon Amor ra nonom lon ewe fanü mi chukuchukutä, nge ekewe chon Kanaan ra nonom aroset me aropen ewe chanpupu Jortan.” ");
INSERT INTO chk_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Iwe, Kalep a amosonosona ekewe aramas mi mwichefengen ren Moses o üreniir, “Ousipwe feitä iei chök o liapeni ewe fanü, pun sia fokun tongeni.” ");
INSERT INTO chk_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Nge chienen Kalep kewe mi eti le feitä ra apasa, “Sisap tongeni fiu ngeni ekewe aramas, pun ra kon pöchökül senikich.” ");
INSERT INTO chk_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Iei usun ra apworausa ngeni ekewe aramasen Israel pworaus mi mwäl fän iten ewe fanü ra operi. Ra apasa, “Ewe fanü aia fetalfeil lon eu fanüen ochoch aramas. Nge ekewe aramas aia küneer ra fokun mwänätam. ");
INSERT INTO chk_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Iwe, ikenan aia pwal küna ekewe mwänämong, ekewe mwirimwirin Anak. Nge äm aia awewe ngenikem lifichimas me lükür, pwal usun chök me rer.” ");
INSERT INTO chk_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mürin, ekewe aramasen Israel meinisin ra leüömong le puchör o kechü lon unusen ewe pwin. ");
INSERT INTO chk_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Iwe, ra lal ngeni Moses me Aaron o üreniir, “Amwo aipwe fen mäla chök lon ewe fanü Isip, ika aipwe fen mäla lon ei fanüapö. ");
INSERT INTO chk_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pwota ewe Samol mi Lapalap a emwenikeemito lon ei fanü pwe aipwe mäla lon maun, nge pwülüem me nöüm kewe semirit repwe oola? Epwe fen öch äm aipwe liwinsefäliti Isip.” ");
INSERT INTO chk_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Iwe, ra kapasfengen lefiler, “Ousipwe le filätä eman nöüch souemwen pwe sipwe liwiniti Isip.” ");
INSERT INTO chk_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mürin, Moses me Aaron ra chapetiu won pwül fän mesen ekewe aramasen Israel meinisin mi mwichefengen. ");
INSERT INTO chk_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nge Josua nöün Nun mwän me Kalep nöün Jefune mwän, chienen chokewe mi operi ewe fanü Kanaan, ra kamwei üfer fän ar letipeta. ");
INSERT INTO chk_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Iwe, ra üreni ekewe aramasen Israel meinisin, “Ewe fanü aia saifetal lon o operi fokun eu fanü mi unusen mürina. ");
INSERT INTO chk_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Are ewe Samol mi Lapalap epwe kirikiröch ngenikich, epwe emwenikichelong o ngenikich ewe fanü mi pwülüöch o fanüeräs. ");
INSERT INTO chk_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nge ousap fokun ü ngeni ewe Samol mi Lapalap, ousap pwal niuokusiti aramasen ewe fanü, pun ir chök okufuach. Iwe, ar apilükülük a sü seniir, nge ewe Samol mi Lapalap a etikich. Ousap fokun niuokusitiir.” ");
INSERT INTO chk_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Nge ekewe aramas meinisin ra üra pwe repwe monei ngeniir fau. Mürin, lingen ewe Samol mi Lapalap a pwä won ewe imwenfel seni mangaku ngeni ekewe aramasen Israel meinisin. ");
INSERT INTO chk_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Iwe, ewe Samol mi Lapalap a üreni Moses, “Ifa ükükün fansoun än ekei aramas turunufaseei? Ifa ükükün fansoun ar resap mochen lüküei, inamwo ika ra fen küna ekewe manaman üa föri lefiler? ");
INSERT INTO chk_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Üpwe ni ngeniir mätter o aroserela. Nge üpwe föri senuk eu mwü mi watte o pöchökül seniir.” ");
INSERT INTO chk_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Nge Moses a üreni ewe Samol mi Lapalap, “En ka emwenawu ekei aramas seni Isip fän om manaman. Epwe ifa usun, ika ekewe chon Isip repwe rongorong usun mine ka föri ngeniir? ");
INSERT INTO chk_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Repwe asile ngeni chon ei fanü ei pworaus. Ir ra fen rongorong pwe en ai Samol mi Lapalap ka nom lein ekei aramas, pun en ka newenewen ngeniir, pwal om kuchu a ütä wor, nge en ka akomw mwer lon eu ürekuchu lerän me eu üreekkei lepwin. ");
INSERT INTO chk_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Are ka nipöküela ekei aramas iei chök, chon ekewe mwü mi rongorong usun mine ka föri repwe apasa, ");
INSERT INTO chk_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Pokiten ewe Samol mi Lapalap esap tongeni emwenalong ekewe aramas lon ewe fanü a pwon pwe epwe ngeniir, iei mine a nirela lon ewe fanüapö.’ ");
INSERT INTO chk_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nge iei üa tüngor ngonuk, ai Samol, kopwe pwäri om manaman ngenikem usun ka fen apasa lon om pwon, ");
INSERT INTO chk_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ewe Samol mi Lapalap a songomang o wöün tong, a amusala föföringau me pupungau, nge esap amusafatei chon tipis, pwe a liwini än samasam tipis won nöür tori aülüngatin me arüanün tettelin aramas.’ ");
INSERT INTO chk_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kose mochen kopwe amusala än ekei aramas tipis lon om tong mi lapalap, usun ka fen amusala än ekewe aramas tipis seni ewe fansoun ar towu seni Isip tori iei.” ");
INSERT INTO chk_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mürin, ewe Samol mi Lapalap a üreni Moses, “Üa amusala ar tipis usun ka tüngor. ");
INSERT INTO chk_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Nge ellet mwo manauei me ai we ling mi aura unusen fanüfan, ");
INSERT INTO chk_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","esap wor eman lein ekewe mwän repwe tolong lon ewe fanü. Ra küna ai ling me ai kewe manaman üa föriir lon Isip pwal lon ewe fanüapö, nge ra chök sotuniei fän chomong, resap pwal aleasochisi aloi. ");
INSERT INTO chk_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Esap wor eman leir epwe tolong lon ewe fanü üa pwon fän akapel ngeni ar kewe lewo. Esap fokun wor eman me lein chokewe mi turunufaseei repwe tolong lon ewe fanü. ");
INSERT INTO chk_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nge nei chon angang Kalep üpwe emwenalong lon ewe fanü a fen piin feila lon, pwe mwirimwirin repwe fanüeni, pun a sokola ekiekin lelukan, a pwal fokun aleasochisiei. ");
INSERT INTO chk_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Iwe, pokiten ekewe chon Amalek me chon Kanaan ra nonom lemolun ewe fanü, lesor ämi oupwe kul o feila lon ewe fanüapö won ewe al a ale ngeni ewe Setipar.” ");
INSERT INTO chk_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ifa ükükün fansoun än ei mwichen aramasangau lal ngeniei? Üa ku ren ai rongorong än ekei aramas lal ngeniei. ");
INSERT INTO chk_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Oupwe üreniir pwe iei aloi ngang ewe Samol mi Lapalap, ‘Mwo manauei, mine oua apasa, iei üpwe föri ngenikemi. ");
INSERT INTO chk_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ämi oupwe mätiu lon ei fanüapö. Nge esap wor eman me lein iteitemi seni ier rüe feitä mi lal ngeniei, ");
INSERT INTO chk_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","epwe tolong lon ewe fanü üa pwon fän akapel pwe oupwe fanüeni, chilon chök Kalep nöün Jefune mwän me Josua nöün Nun mwän. ");
INSERT INTO chk_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Nge nöümi semirit oua apasa pwe repwe oola, ngang üpwe emwenirelong lon ewe fanü ämi oua oputa, pwe repwe fanüeni. ");
INSERT INTO chk_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Nge ämi oupwe mätiu lon ei fanüapö. ");
INSERT INTO chk_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Iwe, nöümi repwe chon fofol man lon ewe fanüapö lon ükükün faik ier, repwe pwal riaföü pokiten ämi ousap allükülük, tori ewe amüchülan me leimi epwe mätiu lon ewe fanüapö. ");
INSERT INTO chk_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ükükün iteiten ekewe faik rän oua operi ewe fanü, iei ükükün ierin ämi oupwe uwei liwinin ämi föföringau. Pun eu ier epwe fän iten eu rän. Iei usun oupwe mefi weiresin ai ü ngenikemi lon ükükün faik ier.’ ");
INSERT INTO chk_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ellet üpwe föri ei ngeni unusen ei mwich mi ngau ra chufengen lon ar ü ngeniei: Repwe mätiu o rosola lon ei fanüapö. Ngang ewe Samol mi Lapalap üa kapas.” ");
INSERT INTO chk_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Nge ekewe mwän Moses a tinirela pwe repwe operi ewe fanü, ir ätekewe mi liwinto o uwato pworaus mi mwäl usun ewe fanü, pwe unusen ewe mwichen aramas ra popuetä lal ngeni Moses, ra mäla. ");
INSERT INTO chk_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Pokiten ar uwato och pworaus mi mwäl usun ewe fanü, ra mäla ren och mätter fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nge Josua nöün Nun mwän me Kalep nöün Jefune mwän ra manau me lein ätekewe mi feila operi ewe fanü. ");
INSERT INTO chk_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Iwe, lupwen Moses a apworausa ekei kapas ngeni ekewe aramasen Israel meinisin, ra fokun lolilen. ");
INSERT INTO chk_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Iwe, lesosorusichin sorotän ewe rän ra pwätä o feitä won ewe fanü mi chukuchukutä, pun ra apasa, “Sa mefi pwe sa tipis. Nge iei ousipwe feitä ngeni ewe fanü ewe Samol mi Lapalap a pwon ngenikich.” ");
INSERT INTO chk_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Nge Moses a üreniir, “Pwota oua chök sopwela le purätiu än ewe Samol mi Lapalap allük? Ämi ousap win. ");
INSERT INTO chk_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ousap feitä pwe oute kuf ren chon oputakemi, pun ewe Samol mi Lapalap esap etikemi. ");
INSERT INTO chk_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Pun ekewe chon Amalek me chon Kanaan ra nom ikenan, repwe nikemi lon maun. Pokiten oua kul seni ewe Samol mi Lapalap, i esap chüen etikemi.” ");
INSERT INTO chk_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Iwe, ekewe aramas ra chök ouucho le feitä ngeni ewe fanü mi chukuchukutä. Nge ewe pworofel än ewe Samol mi Lapalap pwal Moses ra chök nonom lon ewe leni ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Mürin, ekewe chon Amalek me ekewe chon Kanaan mi nom lon ewe fanü mi chukuchukutä ra feitiu o maun ngeniir. Ra akufu ekewe chon Israel o tapweriir tori Horma. ");
INSERT INTO chk_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Iwe, ewe Samol mi Lapalap a ngeni Moses ");
INSERT INTO chk_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","ekei allük fän iten ekewe aramasen Israel pwe repwe apwönüetä me lon ewe fanü i epwe ngeniir pwe repwe fanüeni: ");
INSERT INTO chk_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","“Oupwe eäni asor ngeni ewe Samol mi Lapalap eman ätemwänin kow, ika eman ätemwänin sip, ika kuuch, pwe ämi soren kek ika sokun asoren pwon, ika asor seni püsin letipemi, ika asor lupwen fansoun ekewe chulap mi kefilitä, pwe eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Iwe, ewe aramas mi uwato an asor epwe pwal eäni asoren mongö ngeni ewe Samol mi Lapalap ruu paun pilawa mi amas o mürina nofitfengen me eu kuoch apüra. ");
INSERT INTO chk_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Epwe pwal eäni asoren ün eu kuoch wain o achu ngeni eman me eman lam fän iten asoren kek ika sokun asor. ");
INSERT INTO chk_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Iwe, are epwe eäni asor eman ätemwänin sip, epwe achu ngeni rüanü paun pilawa mi amas o mürina nofitfengen me eu esop kuoch apüra pwe eu asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Nge fän iten asoren ün epwe eäni asor eu esop kuoch wain pwe eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Iwe, lupwen ewe aramas epwe eäni asor ngeni ewe Samol mi Lapalap eman ätemwänin kow fän iten asoren kek ika sokun asoren pwon ika asoren kinamwe, ");
INSERT INTO chk_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","epwe achu ngeni ewe ätemwänin kow wonu paun pilawa mi amas o mürina nofitfengen me esop kalon apüra, pwe eu asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Epwe pwal eäni asoren ün esop kalon wain pwe eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Iei usun oupwe föri fän iten iteiten eman me eman ätemwänin kow ika ätemwänin sip, fän iten iteiten eman me eman ätemwänin lam ika apanen kuuch. ");
INSERT INTO chk_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ükükün iteiten ekewe mönün asor oupwe eäni asor, epwe pwal ina ükükün mine oupwe achu ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Iwe, chon Israel meinisin, ir chon wilipos repwe föri pwüngün ekei lapalap, lupwen repwe asor ngeni ewe Samol mi Lapalap, pwe i epwe efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nge are eman chon ekis mi siamüfetal remi, ika eman chon ekis mi nonom leimi seni eu täppin aramas tori eu täppin, a mochen eäni eu asor ngeni ewe Samol mi Lapalap, i a efich pwoon, epwe föri pwüngün mine oua föri. ");
INSERT INTO chk_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Iwe, epwe chök wor eu allük fän itemi me fän iten ekewe chon ekis mi nom remi. Ei epwe eu allük tori feilfeilachök seni eu täppin aramas tori eu täppin. Ämi me ekewe chon ekis oua wewe chök me fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Iwe, epwe fokun wor eu chök allük me pwüng fän itemi me fän iten ekewe chon ekis mi nom remi.” ");
INSERT INTO chk_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Iwe, ewe Samol mi Lapalap a ngeni Moses ");
INSERT INTO chk_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","pwal ekoch allük usun asor fän iten ekewe aramasen Israel, pwe repwe apwönüetä me lon ewe fanü i epwe emwenirelong lon: ");
INSERT INTO chk_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","“Lupwen oupwe eni mongön ewe fanü, oupwe aimwüela eu kinikin seni, pwe eu asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Lupwen oua umuni pilawa, ewe efochun mwen öüwämi pilawa seni föün wiich mi fö oupwe eäni asor ngeni ewe Samol mi Lapalap usun chök ekewe föün wiich oua eäni asor seni ewe lenien wichiwich umwun wiich. ");
INSERT INTO chk_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Oupwe eäni asor ngeni ewe Samol mi Lapalap eföü pilawa seni mwen öüwämi pilawa. Ei allük epwe fän itemi seni eu täppin aramas tori eu täppin. ");
INSERT INTO chk_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ewe Samol mi Lapalap a ngenikemi ekei allük meinisin Moses a aiti ngenikemi. Are oua atai eu lein ekei allük, nge sap ren mochenin letipemi, ");
INSERT INTO chk_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ika mwirimwirimi kana ra pwal atai, ");
INSERT INTO chk_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","nge ewe mwichen aramas esap mefi pwe a mwäl, ikei mine oupwe föri: Unusen ewe mwichen aramas epwe eäni asor eman nienifön ätemwänin kow fän iten asoren kek ewe Samol mi Lapalap a efich pwoon. Repwe achu ngeni ewe asoren mongö me asoren ün usun mine a pwüng. Repwe pwal eäni asor eman ätemwänin kuuch fän iten asoren tipis. ");
INSERT INTO chk_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Iwe, ewe souasor epwe föri asoren amusamusen tipis fän iten unusen ewe mwichen chon Israel. Ar föför mi mwäl epwe musala, pun esap fis seni mochenin letiper, ra pwal uwato ar asoren kek ewe Samol mi Lapalap a efich pwoon, me ar asoren tipis. ");
INSERT INTO chk_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Iwe, unusen ewe mwichen chon Israel me ekewe chon ekis mi nom leir epwe musala ar mwäl, pun iteiter meinisin ra pachelong lon ewe föför mi mwäl esap fis ren mochenin letiper. ");
INSERT INTO chk_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Iwe, are eman aramas a tipisin chechengau, epwe eäni asor eman liefefinin kuuch eu ierin fän iten asoren tipis. ");
INSERT INTO chk_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Iwe, ewe souasor epwe föri asoren amusamusen tipis fän mesen ewe Samol mi Lapalap fän iten ewe aramas mi föri och mwäl, lupwen a tipisin chechengau. Iwe, epwe musala an tipis. ");
INSERT INTO chk_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Iwe, epwe wor eu chök allük fän iten ätewe mi tipisin chechengau, ese lifilifil ika i eman lein ekewe aramasen Israel ika eman chon ekis mi nom leir. ");
INSERT INTO chk_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Nge are eman a tipis seni mochenin letipan, ese lifilifil ika i eman chon wilipos ika eman chon ekis, ätewe a turunufasei ewe Samol mi Lapalap. Ewe aramas epwe käriwu seni me lein aramasan. ");
INSERT INTO chk_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Pokiten ewe aramas a oput än ewe Samol mi Lapalap kapas o purätiu an allük, epwe wesewesen käriwu. An tipis epwe chök nonom won.” ");
INSERT INTO chk_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Iwe, lupwen ekewe aramasen Israel ra nom lon ewe fanüapö, ra küna eman mwän a os mwüüch lon ewe ränin sapat. ");
INSERT INTO chk_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Nge chokewe mi küna ätewe mi os mwüüch, ra emwenato ren Moses me Aaron pwal ren ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Iwe, ra kalapusei ewe mwän, pun esap fat mine epwe fis ngeni. ");
INSERT INTO chk_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Mürin, ewe Samol mi Lapalap a üreni Moses, “Ewe mwän epwe ninnila. Ekewe aramas meinisin repwe monei ngeni fau me lükün ewe ia oua nonom ie.” ");
INSERT INTO chk_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Iei mine ekewe aramas meinisin ra emwenala ewe mwän lükün ewe ia ra nonom ie o monei ngeni fau tori a mäla, usun ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Kopwe üreni ekewe aramasen Israel: Oupwe föri sokun fout lepwülün üfemi, ämi me mwirimwirimi kana. Oupwe pwal pacheetä won iteiten fout efoch säl mi arauarau. ");
INSERT INTO chk_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Iwe, lupwen oupwe küna ewe fout, oupwe chechemeni ai kewe allük meinisin pwe oupwe aleasochisiir. Nge ousap tapwela ekiekin lelukemi me künan mesemi, usun a mecheres ngenikemi. ");
INSERT INTO chk_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Iei usun oupwe chechemeni ai kewe allük meinisin o aleasochisiir pwe oupwe pin fän itei ngang ämi we Kot. ");
INSERT INTO chk_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ngang ewe Samol mi Lapalap ämi we Kot, üa emwenikemiiwu seni ewe fanü Isip pwe üpwe ämi Kot: Ngang ewe Samol mi Lapalap ämi we Kot.” ");
INSERT INTO chk_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Iwe, Kora nöün Isar, nge Isar nöün Kohat, nge i nöün Lefi mwän, pwal Tatan me Apiram nöün Eliap kewe mwän me On nöün Pelet mwän seni ewe ainangen Rupen ");
INSERT INTO chk_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ra ü ngeni Moses. A pwal chu ngeniir ükükün ruopükü lime chon Israel, ir souemwen mi iteüöch, ra fil seni ewe mwichen aramas pwe repwe nöür souemwen. ");
INSERT INTO chk_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Iwe, ra mwichfengen o ü ngeni Moses me Aaron. Iwe, ra üreniir, “Ämi oua kon alapala nemeniemi. Pun unusen ei mwichen aramas a pin, nge ewe Samol mi Lapalap a nom lefiler. Pwota oua püsin atekiakemiitä won än ewe Samol mi Lapalap mwich?” ");
INSERT INTO chk_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Iwe, lupwen Moses a rong ekei kapas, a chapetiu lepwül o iotek. ");
INSERT INTO chk_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Mürin a üreni Kora me chienan kewe meinisin, “Lesosorun lesor ewe Samol mi Lapalap epwe pwärätä iön nöün pwal iön a pin. Epwe pwal pwärätä iön a mwüt ngeni pwe epwe kan ngeni. Ätewe Kot a filätä epwe kan ngeni. ");
INSERT INTO chk_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Iei usun oupwe föri: Lesor, ämi Kora me chienom kewe meinisin oupwe angei sepien asoren ötüöt. ");
INSERT INTO chk_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Oupwe uwalong ekkei lor o iseis apach mi pwokus wor fän mesen ewe Samol mi Lapalap. Nge ätewe ewe Samol mi Lapalap epwe filätä, i epwe pin. Ämi kana mwän seni ewe ainangen Lefi oua kon alapala nemeniemi.” ");
INSERT INTO chk_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Iwe, Moses a pwal üreni Kora, “Iei oupwe aüseling, ämi chon ewe ainangen Lefi. ");
INSERT INTO chk_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ifa usun, esap naf ngenikemi pwe än chon Israel we Kot a aimwükemi seni ewe mwichen chon Israel, a pwal mwüt ngenikemi pwe oupwe kan ngeni o föri angangen lon än ewe Samol mi Lapalap imwenfel seni mangaku? Oua pwal ü mwen ewe mwichen aramas pwe oupwe angang ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kot a mwüt ngenikemi me pwimi kewe seni ewe ainangen Lefi pwe oupwe kan ngeni. Nge iei oua pwal kütta ewe wisen souasor. ");
INSERT INTO chk_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Iei mine oua ü ngeni ewe Samol mi Lapalap, ämi me chienom kewe mi mwichefengen. Pun iö Aaron pwe oua lal ngeni?” ");
INSERT INTO chk_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mürin, Moses a titi Tatan me Apiram nöün Eliap kewe mwän. Nge ir ra üra, “Äm aisap feila. ");
INSERT INTO chk_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ifa usun, esap naf me reöm pwe ka emwenikeemiwu seni ewe fanü mi pwülüöch o fanüeräs, pwe kopwe nikem lon ewe fanüapö? Ifa usun, kopwe pwal seikuketä pwe kopwe samol wom? ");
INSERT INTO chk_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kosap fokun emwenikeemilong lon eu fanü mi pwülüöch o fanüeräs, kosap pwal ngenikem fanü me tanipin wain pwe aipwe fanüeni. Ifa usun, kopwe pwal atupu ekei aramas? Äm aisap feila.” ");
INSERT INTO chk_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mürin, Moses a fokun song ren ekei kapas o üreni ewe Samol mi Lapalap, “Kosap etiwa ar kewe asor. Ngang üsap mwo nge angei eman aas seniir, üsap pwal föri och mi mwäl ngeniir.” ");
INSERT INTO chk_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Iwe, Moses a üreni Kora, “Ämi me chienom kewe meinisin, oupwe feito lesor ren ewe imw mangaku ia aramas ra churi Kot ie, ämi pwal Aaron. ");
INSERT INTO chk_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Iwe, eman me eman leimi epwe angei an sepien asoren ötüöt, epwe iseis apach mi pwokus lon o uwato fän mesen ewe Samol mi Lapalap. Iwe, epwe wor ruopükü lime sepien asoren ötüöt, pwal en me Aaron oupwe uwato ämi sepien asoren ötüöt.” ");
INSERT INTO chk_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Iei mine ekewe mwän meinisin ra angei ar sepien asoren ötüöt, ra uwalong ekkei lor o iseis apach mi pwokus wor. Iwe, ra ütä leasamalapen ewe imwenfel seni mangaku, nge Moses me Aaron ra pwal ütä rer. ");
INSERT INTO chk_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Mürin, Kora a amwichafengeni ekewe aramas meinisin leasamalapen ewe imwenfel seni mangaku, pwe repwe ü ngeni Moses me Aaron. Iwe, lingen ewe Samol mi Lapalap a pwä ngeni ewe mwichen aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Oupwe aimwükemi seni ekei aramas pwe üpwe aroserela fän eu chök.” ");
INSERT INTO chk_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Nge ir ra chapetiu lepwül o apasa, “Äm Kot, en popun manauen aramas meinisin. Ifa usun, kopwe song ngeni unusen ewe mwichen aramas are eman chök mwän a tipis?” ");
INSERT INTO chk_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Kopwe üreni ekewe aramas pwe repwe sü seni imwen Kora, Tatan me Apiram.” ");
INSERT INTO chk_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mürin, Moses a feila ren Tatan me Apiram, nge ekewe souakomwen Israel ra tapwela mürin. ");
INSERT INTO chk_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Iwe, a üreni ekewe aramas, “Üa tüngor ngenikemi, oupwe feil seni imwen ekei mwän mi föföringau. Ousap atapa och pisekir, pwe ousap pwal etiir le tolong lon ewe feiengau epwe toriir pokiten ar kewe tipis.” ");
INSERT INTO chk_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Iei mine ekewe aramas ra sü seni imwen Kora, Tatan me Apiram. Nge Tatan me Apiram ra towu o ütä leasamalapen imwer kewe fiti pwülüer me nöür mwän pwal nöür semirit. ");
INSERT INTO chk_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Iwe, Moses a üra, “Ren ei oupwe silei pwe ewe Samol mi Lapalap a akünöüei pwe üpwe föri ekei föför meinisin, nge üsap püsin ekiekietä. ");
INSERT INTO chk_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Are ekei mwän ra mäla lon sokun mälan armamas, ika a fis ngeniir mine a fis ngeni aramas meinisin, ewe Samol mi Lapalap esap akünöüei. ");
INSERT INTO chk_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Nge are ewe Samol mi Lapalap epwe afisätä och mettoch mi fö, are ewe pwül epwe sangfesen o oromirela fiti pisekir meinisin pwe ra feilmanauetiu lon lenien sotup, oupwe silei pwe ekei mwän ra turunufasei ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Iwe, wesin chök än Moses üra ekei kapas, ewe pwül fän Tatan me Apiram a sangfesen ");
INSERT INTO chk_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","o oromirela fiti ar famili meinisin, pwal chienen Kora kewe mwän meinisin me pisekir meinisin. ");
INSERT INTO chk_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Iei usun ir meinisin ra feilmanauetiu lon lenien sotup fiti pisekir meinisin. Iwe, ewe pwül a pwölürela pwe ra mola seni me lein ewe mwichen aramas. ");
INSERT INTO chk_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Iwe, ekewe chon Israel meinisin mi nom ünükür ra sü, lupwen ra rong ar puchör. Ra puchör le apasa, “Sipwe sü pwe ewe pwül esap pwal oromikichela.” ");
INSERT INTO chk_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Nge ekkei a feitiu seni ewe Samol mi Lapalap o kenala ekewe ruopükü lime mwän mi eäni ekewe asoren ötüöt. ");
INSERT INTO chk_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Mürin, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Kopwe üreni Eleasar nöün ewe souasor Aaron we mwän, epwe angei ekewe sepien asoren ötüöt seni lon molien ewe ekkei, pun ra pin. Epwe pwal atoropasala molien ewe ekkei ekis toau. ");
INSERT INTO chk_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Nge ekewe sepien asoren ötüöt än ekewe mwän mi mäla pokiten ar tipis, repwe nechenech o achöpöp pwe pwölüpwölün ewe rongen asor. Pokiten ra aea le asor me fän mesen ewe Samol mi Lapalap, iei mine ra pin. Iwe, repwe eu asisilen fön ngeni ekewe aramasen Israel.” ");
INSERT INTO chk_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Mürin, ewe souasor Eleasar a angei ekewe sepien asoren ötüöt mi för seni piras, chokewe mi kar ra aea le asor. Iwe, a necheer o achöpöpüür pwe pwölüpwölün ewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Iwe, ekei pisek repwe achema ngeni ekewe aramasen Israel, pwe esap wor eman epwe kanoto pwe epwe keni apach mi pwokus fän mesen ewe Samol mi Lapalap, chilon chök ekewe mwirimwirin Aaron, pwe esap fis ngeni usun mine a fis ngeni Kora me chienan kewe. Iwe, ra föri meinisin usun mine ewe Samol mi Lapalap a allük ngeni Moses fän iten Eleasar. ");
INSERT INTO chk_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Nge sorotän ewe rän ekewe aramasen Israel ra lal ngeni Moses me Aaron o apasa, “Ämi oua niela nöün ewe Samol mi Lapalap aramas.” ");
INSERT INTO chk_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Iwe, lupwen ekewe aramas ra chufengen pwe repwe ü ngeni Moses me Aaron, ra kul ngeni ewe imw mangaku ia aramas ra churi Kot ie o küna pwe ewe kuchu a pwölüöla o lingen Kot a pwä. ");
INSERT INTO chk_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mürin, Moses me Aaron ra feito ren asamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Nge ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Oupwe merela seni ei mwichen aramas pwe üpwe aroserela fän eu chök.” Iwe, ir me ruoman ra chapetiu lepwül. ");
INSERT INTO chk_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mürin, Moses a üreni Aaron, “Kopwe angei om sepien asoren ötüöt, kopwe atolonga ekkei seni won ewe rongen asor o iseis apach mi pwokus won. Kopwe müttir uwala ren ewe mwichen aramas o föri asoren amusamusen tipis fän iter. Pun än ewe Samol mi Lapalap song a feitiu, nge ewe mätter a fen popuetä.” ");
INSERT INTO chk_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Iei mine Aaron a angei ewe sepien asoren ötüöt, usun Moses a üreni, o säla lein ekewe aramas. Nge lupwen Aaron a küna pwe ewe mätter a fen popuetä lein ekewe aramas, a iseis apach mi pwokus lon ewe sepien asoren ötüöt o föri asoren amusamusen tipis fän iten ekewe aramas. ");
INSERT INTO chk_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Iwe, a ütä lefilen ekewe mi mäla me ekewe mi manau, nge ewe mätter a kaüla. ");
INSERT INTO chk_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Iwe, iteiten chokewe mi mäla ren ewe mätter ükükün engol me rüanüngeröü füpükü lükün chokewe mi mäla pokiten ar eti Kora le tipis. ");
INSERT INTO chk_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Nge lupwen ewe mätter a kaüla, Aaron a liwinla ren Moses leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Kopwe üreni ekewe aramasen Israel pwe repwe uwato engol me ruofoch wok, epwe efoch nge fän iten souemwenin eu me eu ar kewe ainang. Kopwe ruputi iten eman me eman won en me wokun. ");
INSERT INTO chk_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Nge kopwe ruputi iten Aaron won wokun Lefi we. Epwe wor efoch wok fän iten eman me eman souemwenin eu me eu ainang. ");
INSERT INTO chk_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Mürin, kopwe isenirelong lon ewe imw mangaku ia aramas ra churiei ie mwen ewe pworofel, ewe ia üa churuk ie. ");
INSERT INTO chk_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Iwe, wokun ätewe üa filätä epwe fasar. Iei usun üpwe aükätiu än ekewe aramas lal ngonuk.” ");
INSERT INTO chk_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Iwe, Moses a apworausa ngeni ekewe aramasen Israel ekei kapas. Iwe, nöür kewe souemwen ra ngeni Moses engol me ruofoch wok, efoch wok nge eman souemwenin ar kewe ainang. Nge wokun Aaron we a pwal nom leir. ");
INSERT INTO chk_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Iwe, Moses a isenalong ekewe wok lon ewe imwenfel seni mangaku mwen än ewe Samol mi Lapalap we pworofel. ");
INSERT INTO chk_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Iwe, sorotän ewe rän Moses a tolong lon ewe imwenfel seni mangaku. A küna wokun Aaron we fän iten ewe ainangen Lefi pwe a fasar, a et, a pwal wor pöön irä won o uani föün almont mi maaw. ");
INSERT INTO chk_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mürin, Moses a uwawu ekewe wok seni mwen än ewe Samol mi Lapalap we pworofel o appii ngeni ekewe aramasen Israel meinisin. Iwe, ra küna mine a fis, nge eman me eman souemwen a angei wokun. ");
INSERT INTO chk_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe aliwinalong wokun Aaron we mwen ewe pworofel, pun epwe nom pwe eu asisilen fön ngeni ekewe chon ü ngeniei. Ren ei epwe wes ar lal ngeniei, pwe resap mäla.” ");
INSERT INTO chk_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Iei usun Moses a föri mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Nge ekewe aramasen Israel ra üreni Moses, “Nengeni, äm aia rosola. Äm aipwe mäla, äm meinisin aipwe mäla. ");
INSERT INTO chk_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Eman me eman mi kan ngeni än ewe Samol mi Lapalap imwenfel seni mangaku epwe mäla. Ifa usun, äm meinisin aipwe mäla?” ");
INSERT INTO chk_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Iwe, ewe Samol mi Lapalap a üreni Aaron, “Ämi me noum kewe mwän pwal chon än semom ainang oupwe mwärelong fän ekewe pupungau mi fis ngeni ewe imw mi pin. Nge ämi me noum kewe mwän oupwe pwal mwärelong fän pupungauen wisemi wisen souasor. ");
INSERT INTO chk_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Iwe, kopwe pwal emwenato pwiüm kewe chon ewe ainangen Lefi, repwe etuk o alisuk, lupwen ämi me noum kewe mwän oua föri ämi angang lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Iwe, ir repwe angang ngonuk o föri sokun angangen ewe imwenfel seni mangaku. Nge resap kan ngeni pisekin ewe imw mi pin ika ngeni ewe rongen asor pwe ämi me ir ousap mäla. ");
INSERT INTO chk_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Iwe, repwe etuk le föri angangen ewe imwenfel seni mangaku me sokun angangen lon meinisin. Nge esap wor eman lükür epwe etikemi lon ewe angang. ");
INSERT INTO chk_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Nge ämi me noum kewe oupwe föri angangen lon ewe imwenfel seni mangaku me angangen ewe rongen asor, pwe esap chüen fis ai song won ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ngang püsin üa filätä pwimi kewe chon ewe ainangen Lefi seni lein ekewe aramasen Israel pwe eu lifang ngenikemi. Ir ra imwüla fän itei pwe repwe föri angangen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Nge ämi chök me noum kewe mwän oupwe föri angangen wisen souasor won ewe rongen asor, pwal angangen lon ewe rumw mi unusen pin. Iei wisemi, pun üa lifang ngenikemi ewe wisen souasor. Nge are eman me lükün epwe kan ngeni ewe imw mi pin, epwe ninnila.” ");
INSERT INTO chk_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mürin, ewe Samol mi Lapalap a üreni Aaron, “Ngang püsin üa ngenikemi mine a imwüla seni ekewe asor ra eäni asor ngeniei. Mettoch meinisin mine ekewe aramasen Israel ra apini, üa ngenikemi me noum kewe mwän pwe inetimi tori feilfeilachök. ");
INSERT INTO chk_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ämi oupwe eni ewe kinikin esap kekila seni ekewe asor mi unusen pin. Seni ekewe lifang meinisin aramas ra uwato rei pwe eu asor mi unusen pin, ese lifilifil ika asoren mongö, ika asoren tipis, ika asoren pupungau, ekei kinikin repwe fän itemi me noum kewe mwän. ");
INSERT INTO chk_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Oupwe mongö ekei asor lon eu leni mi unusen pin. Iteiten mwän a tongeni mongö seniir. Oupwe chechemeni pwe ra pin fän itemi. ");
INSERT INTO chk_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Pwal iei inetimi: Än ekewe aramasen Israel lifang ra eäni asor, pwal ar kewe asoren assaw meinisin. Ekei asor üa ngenikemi me noum kewe mwän me fefin, pwe inetimi tori feilfeilachök. Iteiten ir mi limöch me lein chon leimwom repwe tongeni mongö seni. ");
INSERT INTO chk_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Üa pwal ngenikemi öchün apüra me öchün wain meinisin, pwal öchün föün wiich meinisin aramas ra fang ngeniei pwe ar mwen ua. ");
INSERT INTO chk_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Iwe, mwen uän irä meinisin mi mär won fanüer ra uwato rei repwe enemi. Iteiten ir mi limöch me lein chon leimwom repwe tongeni mongö seni. ");
INSERT INTO chk_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Iteiten mettoch meinisin aramas ra apini fän itei me lon Israel repwe om. ");
INSERT INTO chk_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Meinisin mine a akomwen uputiu me lein aramas ika man chon Israel ra eäni asor ngeniei repwe noum. Nge mwänichien aramas repwe liwini ngonuk won moni pwal usun chök mweinöün man mi limengau. ");
INSERT INTO chk_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Iwe, ren ekewe mwänichi repwe möni ngonuk, lupwen repwe eu maram, nge ükükün mör epwe limeföü föün silifer mi för won ewe kilo ra aea le aükük lon ewe imw mi pin. ");
INSERT INTO chk_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Nge mweinöün eman kow ika sip ika kuuch resap tongeni möni ngonuk, pun ra pin. Kopwe äsupu char ngeni won ewe rongen asor o kenala kirisir pwe eu asor üa efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nge fituker ochom, usun chök ewe leup seni ewe asor mi assaw me ewe pelifichin pechen pwal ochom. ");
INSERT INTO chk_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Iwe, ekewe asor mi pin meinisin ekewe aramasen Israel ra asor ngeniei ngang üa ngenikemi me noum kewe mwän me fefin pwe inetimi tori feilfeilachök. Iei eu pwon esap tongeni tala tori feilfeilachök, üa föri ngenikemi me mwirimwirum kana.” ");
INSERT INTO chk_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Iwe, ewe Samol mi Lapalap a pwal üreni Aaron, “Kosap fanüeni eu fanü me lon Israel, esap pwal wor inetum me leir. Pun ngang inetum me wisom me lein ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Iwe, üa ngeni chon ewe ainangen Lefi än chon Israel leengol meinisin ra uwato rei, pwe wiser fän iten ar angang lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ekewe aramasen Israel resap chüen kanoto ren ewe imwenfel seni mangaku, pwe resap tipis o mäla. ");
INSERT INTO chk_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Nge chon ewe ainangen Lefi repwe föri angangen ewe imwenfel seni mangaku o wisen tümwünü seni sokun limengau. Ei epwe eu allük tori feilfeilachök seni eu täppin aramas tori eu täppin. Iwe, esap pwal wor wisen chon ewe ainangen Lefi fanü me lein ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Pun än ekewe aramasen Israel leengol ra eäni asor ngeniei üa ngeni chon ewe ainangen Lefi pwe wiser. Iei popun üa üreniir pwe esap wor wiser fanü me lein ekewe aramasen Israel.” ");
INSERT INTO chk_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Iwe, ewe Samol mi Lapalap a kapas ngeni Moses, ");
INSERT INTO chk_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Kopwe pwal üreni chon ewe ainangen Lefi: Lupwen oupwe angei seni ekewe aramasen Israel ewe leengol ewe Samol mi Lapalap a ngenikemi pwe wisemi, ämi oupwe pwal eäni asor ngeni ewe Samol mi Lapalap eu leengol seni ewe leengol oua angei. ");
INSERT INTO chk_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ren ämi eäni ekewe asoren leengol, oua usun chök chon Israel mi eäni asor eu leengol seni ar föün wiich me ar wain. ");
INSERT INTO chk_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Iei usun pwal ämi oupwe eäni asor ngeni ewe Samol mi Lapalap seni ämi leengol meinisin oua angei seni ekewe aramasen Israel. Iwe, oupwe ngeni ewe souasor Aaron mine än ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Iwe, seni ekewe lifang meinisin oua angei, oupwe eäni asor ngeni ewe Samol mi Lapalap ewe kinikin mi fokun mürina o pin. ");
INSERT INTO chk_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Iwe, kopwe pwal üreni chon ewe ainangen Lefi: Lupwen oua wes le eäni asor mine a fokun mürina, ewe lusun epwe usun chök ekewe föün wiich seni püsin ämi lenien wichiwich umwun wiich, pwal usun chök ewe wain seni ämi lenien üchüch föün irän wain ngenikemi. ");
INSERT INTO chk_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Iwe, ewe lusun oupwe tongeni mongö ekis meinisin, ämi me chon leimwemi. Pun iei liwinimi fän iten ämi angang lon ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Lupwen oua eäni asor ewe kinikin mi fokun mürina, esap wor tipisin ämi mongö ewe lusun ekis meinisin. Nge oupwe föröchü pwe ousap apiningaua än ekewe aramasen Israel asor mi pin, pwe ousap mäla.” ");
INSERT INTO chk_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron, ");
INSERT INTO chk_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Iei pwüngün ewe allük ewe Samol mi Lapalap a allük: Kopwe üreni ekewe aramasen Israel pwe repwe nukieto eman kow mi par esamwo nöünöü, esap wor terin ika ngauan, esap pwal uwei mwo efoch waas fän eu. ");
INSERT INTO chk_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Iwe, oupwe ngeni ewe souasor Eleasar ewe kow. Nge ewe kow epwe nukunukula lükün ewe ia oua imweimw ie o ninnila me fän mesan. ");
INSERT INTO chk_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Mürin, ewe souasor Eleasar epwe angei ekis chan ewe kow won aütün o äsupu fän fisu ngeni awenewenen asamalapen ewe imwenfel seni mangaku. ");
INSERT INTO chk_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nge ewe kow epwe kekila me fän mesen Eleasar: silin, fitukan, chan pwal taran epwe chök kekila. ");
INSERT INTO chk_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Iwe, ewe souasor epwe angei mwüüch seni ewe irä setar, ülün ewe irä isop pwal ekam mangaku mi par o moneerelong lon ewe ekkei. ");
INSERT INTO chk_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Mürin, ewe souasor epwe sopuni üfan o tütü. Iwe, mürin epwe tolong lon ewe ia oua nonom ie, nge epwe nom lon tettelin chon limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Nge ätewe mi kenala ewe kow epwe sopuni üfan o tütü, epwe pwal nom lon tettelin chon limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Mürin, eman mwän mi limöch epwe tukei falangen ewe kow o iseis lükün ewe ia oua nonom ie lon eu leni mi limöch. Iwe, ewe falang epwe iseis fän iten ekewe aramasen Israel pwe epwe nofit me koluk, pwe epwe wor kolukun limelim. Pun ei koluk kolukun limeti tipis. ");
INSERT INTO chk_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Nge ätewe mi tukei falangen ewe kow epwe sopuni üfan o nom lon tettelin chon limengau tori lekuniol. Ei epwe eu allük tori feilfeilachök fän iten ekewe aramasen Israel, pwal fän iten ekewe chon ekis mi nom leir. ");
INSERT INTO chk_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Iwe, eman mi atapa eman somä epwe nom lon tettelin chon limengau lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Iwe, epwe alimelima ren ewe kolukun limelim lon aülüngatin me afisuen rän, mürin epwe limöch. Nge are esap alimelima lon aülüngatin me afisuen rän, esap limöch. ");
INSERT INTO chk_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Iwe, iö a atapa inisin eman somä, nge esap alimelima, a alimengaua än ewe Samol mi Lapalap we imwenfel seni mangaku. Ewe aramas epwe käriwu seni ekewe chon Israel. Pokiten ewe kolukun limelim esap utututä won, ätewe epwe nom lon tettelin chon limengau, nge an limengau epwe chök nonom won. ");
INSERT INTO chk_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Iwe, iei ewe allük lupwen eman aramas a mäla lon eu imw mangaku: Iteiten eman me eman mi tolong lon ewe imw mangaku, pwal iteiten eman me eman mi nom lon epwe nom lon tettelin chon limengau lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Nge iteiten sepi esap wor pwölüpwölün mi riritä won epwe pwal limengau. ");
INSERT INTO chk_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Iwe, iö a atapa eman somä mi mäla ren ketilas, ika eman somä mi chök püsin mäla me lemäl, ika chün eman somä, ika eu peias, epwe nom lon tettelin chon limengau lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Iwe, repwe angei ekis falangen ewe kow mi kekila fän iten asoren tipis o nofiti ngeni koluk mi limöch lon eu sepi fän iten ewe mi limengau. ");
INSERT INTO chk_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Mürin, eman aramas mi limöch epwe angei ülün ewe irä isop, epwe atukalong lon ewe koluk o äsupu won ewe imw mangaku, won pisekin lon meinisin pwal won ekewe aramas mi nom lon. Epwe pwal äsupu won ätewe mi atapa chün eman somä ika atapa eman mi ninnila, ika atapa eman somä mi püsin mäla, ika atapa eu peias. ");
INSERT INTO chk_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Iwe, ewe aramas mi limöch epwe äsupu ewe koluk won ätewe mi nom lon tettelin chon limengau lon aülüngatin me afisuen rän. Iei usun epwe alimelima ätewe mi limengau lon afisuen rän. Iwe, ätewe mi limengau epwe sopuni üfan o tütü, nge lekuniol epwe limöch. ");
INSERT INTO chk_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Iwe, are eman aramas a nom lon tettelin chon limengau, nge esap kütta limelim, ätewe epwe käriwu seni ewe mwichen aramas, pun i a alimengaua än ewe Samol mi Lapalap leni mi pin. Pokiten ewe kolukun limelim esap utututä won, a limengau. ");
INSERT INTO chk_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ei epwe eu allük fän itemi fansoun meinisin. Iwe, ätewe mi äsupu ewe kolukun limelim epwe sopuni üfan. Nge ätewe mi atapa ewe kolukun limelim epwe nom lon tettelin chon limengau tori lekuniol. ");
INSERT INTO chk_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Iwe, mettoch meinisin ewe aramas mi limengau a atapa epwe limengau, nge eman mi atapa ekei mettoch epwe pwal limengau tori lekuniol.” ");
INSERT INTO chk_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Iwe, lon aeuin maram ekewe aramasen Israel meinisin ra tori ewe fanüapön Sin o nonom lon Kates. Nge Miriam a mäla o peias ikenan. ");
INSERT INTO chk_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Iwe, ikenan esap wor koluk fän iten ekewe aramas. Iei mine ra mwichefengen o ü ngeni Moses me Aaron. ");
INSERT INTO chk_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Iwe, ekewe aramas ra anini ngeni Moses o üreni, “Amwo aia eti pwim kewe ra mäla fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Pwota oua emwenato nöün ewe Samol mi Lapalap mwichen aramas lon ei fanüapö pwe aipwe mäla ikei, äm me nöüm kewe man? ");
INSERT INTO chk_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Pwota oua emwenikeemiwu seni Isip o emwenikeemilong lon ei leni mi ngau. Ei leni esap eu lenien fot föün wiich, esap pwal mär irä fiik me irän wain me apel won. Iwe, esap pwal wor ünümem koluk ikei.” ");
INSERT INTO chk_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mürin, Moses me Aaron ra feila seni ekewe aramas, ra feila ren asamalapen ewe imwenfel seni mangaku o chapetiu lepwül. Iwe, lingen ewe Samol mi Lapalap a pwä ngeniir, ");
INSERT INTO chk_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","nge ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Kopwe angei ewe wok mi nom ren ewe pworofel o emwichato ekewe aramas meinisin, ämi me Aaron pwiüm we. Oupwe fos me fän meser ngeni ewe achau pwe epwe atowu kolukun lon. Iei usun kopwe atowu koluk seni lon ewe achau fän iter, pwe kopwe aünü ekewe aramas me nöür man.” ");
INSERT INTO chk_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Iwe, Moses a angei ewe wok usun ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Iwe, Moses me Aaron ra emwichafengeni ekewe aramas meinisin mwen ewe achau. Iwe, Moses a üreniir, “Oupwe rongorong, ämi chon ü ngeniei. Ifa usun, äm aipwe atowu koluk seni lon ei achau fän itemi?” ");
INSERT INTO chk_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mürin, Moses a aitiela wokun o wichi ewe achau fän ruu. Iwe, ewe koluk a pumongowu, pwe ekewe aramas me nöür kewe man ra ün. ");
INSERT INTO chk_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nge ewe Samol mi Lapalap a üreni Moses me Aaron, “Pokiten ousap lüküei, ousap pwal apiniöchüei me fän mesen ekewe aramasen Israel, iei mine ousap emwenirelong lon ewe fanü üpwe ngeniir.” ");
INSERT INTO chk_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ei a fis me arun ewe kolukun Meripa , ewe ia ekewe aramasen Israel ra anini ngeni ewe Samol mi Lapalap ie, nge i a pwärätä me leir pwe a pin. ");
INSERT INTO chk_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Iwe, Moses a tinala chon künö seni lon Kates ren ewe kingen Etom pwe repwe üreni, “Iei alon pwiüm kewe chon Israel: En ka püsin silei usun ewe riaföü a torikem. ");
INSERT INTO chk_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ka silei usun än äm kewe lewo feila Isip. Iwe, äm aia nonom lon Isip fansoun langatam. Nge ekewe chon Isip ra ariaföüükem me äm kewe lewo. ");
INSERT INTO chk_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Iwe, lupwen aia siö ngeni ewe Samol mi Lapalap, a rong äm siö o tinato eman chon läng pwe epwe emwenikeemiwu seni Isip. Iwe, iei aia nom lon Kates, eu telinimw mi nom ünükün fanüom. ");
INSERT INTO chk_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Kose mochen kopwe mwüt ngenikem pwe aipwe pwerelong lon fanüom. Äm aisap pwerelong lon om tanipin wiich ika tanipin wain, aisap pwal ün koluk seni ekewe chönüttu. Äm aipwe chök fetal won än ewe king alelap, nge aisap kul ngeni pelifichin ika pelimöngün tori aipwe pwerewu seni fanüom.” ");
INSERT INTO chk_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Nge ewe kingen Etom a pälüeni, “Ousap fokun pwerelong lon fanüei, pun are oupwe pwerelong, äm aipwe maun ngenikemi.” ");
INSERT INTO chk_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Iwe, ekewe aramasen Israel ra üreni, “Äm aipwe chök fetal won ewe alelap. Nge are äm me nöüm man aipwe ün seni om koluk, aipwe möni. Kopwe chök mwüt ngenikem pwe aipwe pwerelong, esap pwal wor och lükün.” ");
INSERT INTO chk_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Nge ewe kingen Etom a pälüeni, “Ousap fokun pwerelong lon fanüei.” Iwe, ewe kingen Etom fiti chomong nöün sounfiu ra towu pwe repwe maun ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Iwe, pokiten ekewe chon Etom resap mwüt ngeni chon Israel pwe repwe pwerelong lon fanüer, iei mine ekewe chon Israel ra kul seni o pwerela won efoch al. ");
INSERT INTO chk_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Iwe, ekewe aramasen Israel meinisin ra sai seni Kates o tori ewe chuk Hor. ");
INSERT INTO chk_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Iwe, ewe Samol mi Lapalap a üreni Moses me Aaron me fäsonun ewe chuk Hor won kiännin ewe fanü Etom, ");
INSERT INTO chk_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron epwe mäla o chufengen me an kewe lewo. Pun Aaron esap tolong lon ewe fanü üpwe ngeni ekewe aramasen Israel, pokiten oua ü ngeni ai allük arun ewe kolukun Meripa. ");
INSERT INTO chk_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Kopwe emwenätä Aaron me Eleasar nöün we mwän won ewe chuk Hor. ");
INSERT INTO chk_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mürin, kopwe pwiliti seni Aaron üfan kewe üföüfen souasor o aüföüfätä won Eleasar. Iwe, Aaron epwe mäla ikenan o chufengen me an kewe lewo.” ");
INSERT INTO chk_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Iwe, Moses a föri usun mine ewe Samol mi Lapalap a allük ngeni. Ra mwinetä won ewe chuk Hor fän mesen ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Iwe, Moses a pwiliti seni Aaron üfan kewe o aüföüfätä won Eleasar nöün we mwän. Iwe, Aaron a mäla ikenan won ungen ewe chuk. Mürin, Moses me Eleasar ra feitiu me won ewe chuk. ");
INSERT INTO chk_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Nge lupwen ekewe aramasen Israel meinisin ra silei pwe Aaron a mäla, ir meinisin ra kechüeiti Aaron lon ükükün ilik rän. ");
INSERT INTO chk_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Nge lupwen ewe kingen Arat ewe re Kanaan mi nonom lon ewe fanü Nekep a rongorong pwe chon Israel ra feito won ewe al ngeni Atarim, a maun ngeni chon Israel o liapeni ekoch leir. ");
INSERT INTO chk_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Mürin, chon Israel ra föri eu pwon ngeni ewe Samol mi Lapalap o üra, “Are kopwe fangelong ekei aramas fän nemenemem, äm aipwe wesewesen aroserela o ataela ar kewe telinimw.” ");
INSERT INTO chk_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Iwe, ewe Samol mi Lapalap a rongorong än chon Israel kapas o atolonga ekewe chon Kanaan fän nemeniir. Iwe, ra wesewesen aroserela o ataela ar kewe telinimw. Iei mine ra aita ngeni ewe leni Horma . ");
INSERT INTO chk_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Iwe, ekewe chon Israel ra feila seni ewe chuk Hor o sai won ewe al mi ale ngeni ewe Setipar, pwe repwe pwelila lükün ewe fanü Etom. Iwe, ekewe aramas resap chüen engila fän weiresin ar sai ");
INSERT INTO chk_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","o eäni kapasen ü ngeni Kot me Moses. Ra apasa, “Pwota ka emwenikeemiwu seni Isip pwe aipwe mäla lon ewe fanüapö? Pun esap wor mongö ikei, esap pwal wor koluk, nge äm aia noow ei mongö esap ngünü.” ");
INSERT INTO chk_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Mürin, ewe Samol mi Lapalap a tinato serepenit mi poison lein ekewe aramas. Iwe, ra küw chomong aramasen Israel, pwe ra mäla. ");
INSERT INTO chk_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Iwe, ekewe aramas ra feito ren Moses o üreni, “Äm aia tipis, pun aia eäni kapasen ü ngenikemi me ewe Samol mi Lapalap. Kopwe tüngor ngeni ewe Samol mi Lapalap pwe epwe angei senikem ekewe serepenit.” Iei mine Moses a iotek fän iten ekewe aramas. ");
INSERT INTO chk_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mürin, ewe Samol mi Lapalap a üreni Moses, “Kopwe föri uluulun eman serepenit seni piras o eitiuätä won efoch mwüüch. Nge lupwen ekewe serepenit ra küw eman, epwe manau are i epwe nenengeni ewe uluulun serepenit.” ");
INSERT INTO chk_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Iei mine Moses a föri uluulun eman serepenit seni piras o eitiuätä won efoch mwüüch. Iwe, are eman serepenit a küw eman aramas, nge a nenengeni ewe uluulun serepenit seni piras, a manau. ");
INSERT INTO chk_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Iwe, ekewe aramasen Israel ra sopwela ar sai tori Opot o aüetä imwer ie. ");
INSERT INTO chk_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Mürin ra sai seni Opot tori Ieaparim lon ewe fanüapö ötiuen ewe fanü Moap. Ikenan ra aüetä imwer. ");
INSERT INTO chk_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Iwe, ra pwal sai seni ikenan o sai ngeni ewe lemolun Seret o aüetä imwer ie. ");
INSERT INTO chk_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Mürin ra pwal sai seni ikenan o aüetä imwer lon ewe fanüapö efengin ewe chanpupu Arnon chöülan ewe fanüen chon Amor. Pun ewe chanpupu Arnon kiän lefilen Moap me chon Amor. ");
INSERT INTO chk_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Iei mine a mak lon ewe puken maun än ewe Samol mi Lapalap, “Wahep lon Sufa me ekewe lemol, ewe chanpupu Arnon ");
INSERT INTO chk_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","me pwokuren ekewe lemol mi chöütiu tori ewe telinimw Ar pwal tori kiännin Moap.” ");
INSERT INTO chk_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Iwe, seni ikenan ra sai tori Peer. Iei ewe chönüttu ia ewe Samol mi Lapalap a kapas ngeni Moses me ie, “Kopwe emwichafengeni ekewe aramas pwe ngang üpwe ngeniir koluk.” ");
INSERT INTO chk_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Iwe, lon ewe fansoun ekewe chon Israel ra kölü ei köl: “Kopwe michitä en chönüttu. Sipwe köl ngeni. ");
INSERT INTO chk_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Iei ewe chönüttu ekewe samol ra tuw, pwal ekewe mi iteföüla. Ra tuw ngeni ewe wokun samol, pwal ngeni wokur.” Iwe, seni ewe fanüapö ra saila ngeni Matana. ");
INSERT INTO chk_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Iwe, ra sai seni Matana tori Nahaliel, nge seni Nahaliel tori Pamot. ");
INSERT INTO chk_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Mürin ra sai seni Pamot tori ewe lemol mi nom lon kinikinin Moap fäsonun ungen ewe chuk Piska mi sasapetiu won ewe fanüapö. ");
INSERT INTO chk_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Mürin, ekewe chon Israel ra tinala chon künö ren Sihon ewe kingen Amor pwe repwe üreni, ");
INSERT INTO chk_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Kose mochen kopwe mwüt ngenikem pwe aipwe pwerelong lon fanüom. Äm aisap kul ngeni om tanipin wiich ika tanipin wain, aisap pwal ün koluk seni ekewe chönüttu. Äm aipwe chök fetal won än ewe king alelap tori aipwe pwerewu seni fanüom.” ");
INSERT INTO chk_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Nge Sihon esap mochen mwüt ngeni ekewe chon Israel pwe repwe pwerelong lon fanüan. Iwe, a emwichafengeni nöün kewe sounfiu meinisin o feila lon ewe fanüapö pwe epwe maun ngeni chon Israel. Iwe, lupwen a tori Jahas, a maun ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Nge ekewe chon Israel ra niela Sihon me chomong nöün sounfiu o liapeni fanüan seni ewe chanpupu Arnon tori ewe chanpupu Japok. Nge ra chök tori kiännin fanüen chon Amon, pun a pöchökül tittin kiännin. ");
INSERT INTO chk_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Iwe, ekewe chon Israel ra liapeni ekewe telinimwen chon Amor meinisin o imweimw lor. Ra pwal imweimw lon Hespon me wisoposopun meinisin. ");
INSERT INTO chk_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Pun Hespon telinimwen Sihon ewe kingen chon Amor, ätewe mi maun ngeni ewe minen lomun kingen Moap o liapeni fanüan meinisin tori ewe chanpupu Arnon. ");
INSERT INTO chk_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Iei popun ekewe souköl ra köl, “Oupwe feito ngeni Hespon. Oupwe aüetä o anükünüköchü ewe telinimwen Sihon. ");
INSERT INTO chk_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Pun nöün Sihon mwichen sounfiu a towu seni Hespon usun ekkei. A kenala ewe telinimw Ar lon Moap o amochala ekewe chukuchukutä arun ewe chanpupu Arnon. ");
INSERT INTO chk_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Feiengauemi chon Moap! A iei sopolomi, ämi aramas mi fel ngeni Kemos. Ämi kot a föri pwe nöümi kewe mwän ra choisä, nge nöümi kewe fefin ra oola ren Sihon ewe kingen chon Amor. ");
INSERT INTO chk_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nge iei sia aroserela seni Hespon tori Tipon, pwal tori Nofa me Metepa.” ");
INSERT INTO chk_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Iwe, ekewe chon Israel ra nonom lon fanüen chon Amor. ");
INSERT INTO chk_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mürin, Moses a tinala chon op pwe repwe operi ewe telinimw Jaser. Iwe, ekewe chon Israel ra liapeni ewe telinimw me wisoposopun kewe o asüela ekewe chon Amor mi nonom ikenan. ");
INSERT INTO chk_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Mürin ra kul o feitä ngeni Pasan. Nge Ok ewe kingen Pasan me nöün sounfiu meinisin ra towu pwe repwe maun ngeniir me lon Etrei. ");
INSERT INTO chk_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Nge ewe Samol mi Lapalap a üreni Moses, “Kosap niuokusiti Ok, pun üa atolonga i me nöün aramas meinisin pwal fanüan fän nemeniom. Iwe, kopwe föri ngeni usun mine ka föri ngeni Sihon ewe kingen chon Amor mi nonom lon Hespon.” ");
INSERT INTO chk_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Iei mine chon Israel ra niela Ok me nöün kewe mwän pwal nöün aramas meinisin tori esap chüen wor eman lusun. Mürin ra fanüeni fanüan. ");
INSERT INTO chk_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Mürin, ekewe aramasen Israel ra sai tori ewe maasiesin Moap ötiuen ewe chanpupu Jortan sasape ngeni Jeriko. Ikenan ra aüetä imwer imw mangaku. ");
INSERT INTO chk_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Nge Palak nöün Sipor mwän a rong meinisin mine chon Israel ra föri ngeni ekewe chon Amor. ");
INSERT INTO chk_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Iwe, chon Moap ra fokun niuokus ren chomongun ekewe aramasen Israel, pwe ra chechech pokiten ar niuokusitiir. ");
INSERT INTO chk_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Iwe, ekewe chon Moap ra kapas ngeni ekewe souakomwen Mitian, “Ei mwichemongun aramas epwe asomwa meinisin mine a nom ünüküch, usun eman ätemwänin kow a asomwa fetilin lemäl.” Nge Palak nöün Sipor mwän a kingen Moap lon ewe fansoun. ");
INSERT INTO chk_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Iwe, a tinala chon künö ren Palam nöün Peor mwän lon Petor, a arap ngeni ewe chanpupu Oifrat lon ewe fanü Amaw. Iwe, ra uwei ngeni alon Palak o üreni, “Eu mwichen aramas a feito seni Isip, a pwölüela unusen ewe fanü o nonom kükü ngeniei. ");
INSERT INTO chk_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Kose mochen kopwe feito iei o anümamaua ngeniei ekei aramas, pun ir ra kon pöchökül seniei. Eli üpwe tongeni akufuur o asürela seni ewe fanü. Pun üa silei pwe iö en ka afeiöchü a feiöch, nge iö ka anümamaua a anümamau.” ");
INSERT INTO chk_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Iwe, ekewe souakomwen Moap me ekewe souakomwen Mitian ra feila ren Palam o uweela owun eman soupwe. Nge lupwen ra tori, ra apworausa ngeni alon Palak. ");
INSERT INTO chk_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Iwe, Palam a üreniir, “Oupwe pwinii epwin ikei pwe üpwe aiti ngenikemi usun mine ewe Samol mi Lapalap a aiti ngeniei.” Iei usun ekewe souakom seni Moap ra nom ren Palam. ");
INSERT INTO chk_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Iwe, Kot a feito ren Palam o aisini, “Iö ekewe mwän ra nom reöm?” ");
INSERT INTO chk_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Nge Palam a üreni Kot, “Palak ewe kingen Moap a tinireto rei pwe repwe üreniei, ");
INSERT INTO chk_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","pwe eu mwichen aramas a feito seni Isip o pwölüela unusen ewe fanü. A titi ngang pwe üpwe anümamaueer ngeni, pwe epwe tongeni maun ngeniir o asürela.” ");
INSERT INTO chk_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nge Kot a üreni Palam, “Kosap etiirela. Kosap anümamaua ekewe aramas, pun ir ra feiöch.” ");
INSERT INTO chk_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Iwe, Palam a pwätä lesosor o üreni nöün Palak kewe chon künö, “Oupwe liwinla lon fanüemi, pun ewe Samol mi Lapalap esap mwüt ngeniei pwe üpwe etikemi.” ");
INSERT INTO chk_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Iei mine ekewe chon künö ra ütä o liwinla ren Palak. Iwe, ra üreni, “Palam esap mochen etikem.” ");
INSERT INTO chk_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Mürin, Palak a pwal tinisefäliela eu mwichen souakom mi chocho o iteföüla seni ätekewe. ");
INSERT INTO chk_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Iwe, ra feito ren Palam o üreni alon Palak, “Kosap mwüt ngeni och epwe epetuk seni om kopwe feito rei. ");
INSERT INTO chk_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Pun üpwe ngonuk chomong liwinum, nge meinisin mine ka üreniei üpwe föri. Kose mochen kopwe chök feito o anümamaua ngeniei ekei aramas.” ");
INSERT INTO chk_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Nge Palam a pälüeni nöün Palak kewe chon künö, “Are Palak epwe fen ngeniei an silifer me kolt meinisin mi nom lon imwan, üsap tongeni föri och mi watte ika kis pwe üpwe tongeni lukumach ngeni ewe allük än ewe Samol mi Lapalap ai we Kot. ");
INSERT INTO chk_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nge iei üa tüngor ngenikemi pwe oupwe pwal pwinii epwin ikei, pwe üpwe silei ika ewe Samol mi Lapalap epwe pwal üreniei och.” ");
INSERT INTO chk_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Iwe, Kot a feito ren Palam lon ewe pwinin o üreni, “Are ekei mwän ra feito pwe repwe köruk, kopwe etiir. Nge kopwe chök föri mine ngang üpwe ürenuk.” ");
INSERT INTO chk_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Iwe, Palam a pwätä lesosor, a rietä ewe lenien mot won nöün aas, a tötä won o eti ekewe souakomwen Moap. ");
INSERT INTO chk_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nge Kot a fokun song pokiten an feila. Iwe, Palam a sai won nöün we aas, nge ruoman nöün chon angang ra eti. Iwe, nöün ewe Samol mi Lapalap chon läng a ütä lon ewe al pwe epwe pinei an sai. ");
INSERT INTO chk_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Iwe, ewe aas a küna nöün ewe Samol mi Lapalap we chon läng a ütä lon ewe al o amwöchü efoch ketilas lepöün. Iwe, ewe aas a müttir rikiwu seni ewe al o feilong lemäl. Nge Palam a wichi ewe aas pwe epwe liwiniti ewe al. ");
INSERT INTO chk_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mürin, nöün ewe Samol mi Lapalap we chon läng a ütä won efoch al mi chökis, a nom lefilen ruu tanipin wain, nge a pwal wor tit lepekin me rüepek. ");
INSERT INTO chk_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Iwe, lupwen ewe aas a küna nöün ewe Samol mi Lapalap we chon läng, a üngüri lepekin ewe tit o achacha pechen Palam ngeni. Iei mine Palam a pwal wichisefäli ewe aas. ");
INSERT INTO chk_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Mürin, nöün ewe Samol mi Lapalap we chon läng a akomwola mwan o ütä won eu leni mi fokun chökis, ia esap wor ie eman epwe tongeni rikiwu ngeni pelifichin ewe al ika pelimöngün. ");
INSERT INTO chk_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Iwe, lupwen ewe aas a küna nöün ewe Samol mi Lapalap we chon läng, a aüpwäsukutiu fän Palam. Nge Palam a fokun song o wichi ewe aas ngeni wokun. ");
INSERT INTO chk_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Mürin, ewe Samol mi Lapalap a afosa ewe aas pwe a aisini Palam, “Met üa föri ngonuk pwe ka wichiei fän ülüngat.” ");
INSERT INTO chk_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Iwe, Palam a pälüeni, “Pokiten ka urumwoteei. Amwo itä a fen wor efoch ketilas lepei pwe üpwe niikela.” ");
INSERT INTO chk_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Iwe, ewe aas a pwal aisini Palam, “Ifa usun, sap ngang noum aas ka wakkawa lon unusen manauom tori ikenai? Ifa usun, üa fen föri ngonuk ei sokun me mwan?” Nge Palam a pälüeni, “Ap.” ");
INSERT INTO chk_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Mürin, ewe Samol mi Lapalap a aneneloi mesen Palam pwe a küna nöün ewe Samol mi Lapalap we chon läng mi ütä lukalapen ewe al o amwöchü efoch ketilas. Iwe, Palam a rotiu o chapetiu lepwül. ");
INSERT INTO chk_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Nge nöün ewe Samol mi Lapalap we chon läng a üreni, “Pwota ka wichi noum we aas fän ülüngat? Üa feito pwe üpwe pinei om al pun om ei sai esap pwüng me rei. ");
INSERT INTO chk_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Iwe, noum we aas a künaei o rik me mwei fän ülüngat. Nge are esap rik me mwei, ellet üpwe niikela iei chök, nge ewe aas epwe manau.” ");
INSERT INTO chk_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Mürin, Palam a üreni nöün ewe Samol mi Lapalap we chon läng, “Ngang üa tipis. Üsap silei pwe en ka ü lon ewe al o epetiei. Iei mine are ai ei sai a ngau me reöm, üpwe liwinsefäl.” ");
INSERT INTO chk_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Nge nöün ewe Samol mi Lapalap we chon läng a üreni Palam, “Kopwe eti ekewe mwän. Nge kopwe üra ekewe chök kapas üpwe ürenuk.” Iei mine Palam a eti nöün Palak kewe souakom. ");
INSERT INTO chk_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Iwe, lupwen Palak a rongorong pwe Palam a war, a feila pwe epwe churi lon Ar eu telinimw ünükün ewe chanpupu Arnon mi nom lon kiännin ewe fanü Moap. ");
INSERT INTO chk_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Iwe, Palak a aisini Palam, “Ifa usun, üsap titi en pwe kopwe feito rei? Pwota kose mochen feito? Ifa usun, ka ekieki pwe üsap tongeni liwiniik?” ");
INSERT INTO chk_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Nge Palam a pälüeni Palak, “Nengeni, üa feito reöm. Nge ifa usun, a wor ai pöchökül iei pwe üpwe tongeni apasa och? Üpwe chök apasa ekewe kapas Kot a üreniei.” ");
INSERT INTO chk_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Mürin, Palam a eti Palak. Iwe, ra tori Kiriat-husot. ");
INSERT INTO chk_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ikenan Palak a eäni asor ätemwänin kow me sip o ngeni Palam me ekewe souakom mi nom ren ekoch kinikin seni ekewe mönün asor. ");
INSERT INTO chk_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nge sorotän ewe rän Palak a emwenato Palam won ewe chuk Pamot-paal, ia a tongeni küna me ie eu kinikinin ewe mwichen chon Israel. ");
INSERT INTO chk_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Iwe, Palam a üreni Palak, “Kopwe senätä fän itei fisu rongen asor ikei o uwato füman ätemwänin kow me füman ätemwänin sip.” ");
INSERT INTO chk_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Iwe, Palak a föri usun mine Palam a üreni. Iwe, Palak me Palam ra eäni asor eman ätemwänin kow me eman ätemwänin sip won eu me eu kewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Mürin, Palam a üreni Palak, “Kopwe ütä lükün om kei asoren kek, nge ngang üpwe feila ekis. Eli ewe Samol mi Lapalap epwe feito o churiei. Iwe, meinisin mine epwe pwäri ngeniei üpwe ürenuk.” Iwe, a feitä won eu chukuchukutä mi amasawa. ");
INSERT INTO chk_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Iwe, Kot a churi Palam, nge Palam a üreni, “Üa amolätä fisu rongen asor o eäni asor eman ätemwänin kow me eman ätemwänin sip won eu me eu.” ");
INSERT INTO chk_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Iwe, ewe Samol mi Lapalap a aiti ngeni Palam mine epwe apasa. Mürin a üreni, “Kopwe liwinla ren Palak, nge epwe ina chök alom ngeni.” ");
INSERT INTO chk_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Iei mine Palam a liwinla ren Palak o küna pwe a chüen ütä lükün an kewe asoren kek, nge ekewe souakomwen Moap meinisin ra nom ren. ");
INSERT INTO chk_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Mürin, Palam a popuetä an kapasen osuni o üra, “Palak ewe kingen Moap a emwenieito seni Aram, seni ewe chuk mi nom ötiu. A üreniei, ‘Kopwe feito o anümamaua ngeniei ekewe mwirimwirin Jakop, kopwe feito o eniwa ekewe chon Israel.’ ");
INSERT INTO chk_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ifa usun ai üpwe tongeni anümamaua chokewe Kot esap anümamaueer? Ifa usun ai üpwe tongeni eniwa chokewe ewe Samol mi Lapalap esap eniweer? ");
INSERT INTO chk_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Üa küna ekewe chon Israel seni me won ungen ekewe chukuachau mi tekia, üa nenengeniir seni won ekewe chukutekison. Üa küna eu mwichen aramas mi imwüla lon lenier, resap mochen ar repwe wewe ngeni ekewe mwü. ");
INSERT INTO chk_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Iö a tongeni aleani ekewe mwirimwirin Jakop mi usun pien fanü, nge iö a tongeni aleani eu lerüanün ewe mwichen chon Israel? Amwo üpwe määni mään ekewe chon pwüng. Amwo sopolan manauei epwe usun sopolan manauer.” ");
INSERT INTO chk_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Mürin, Palak a üreni Palam, “Met ei ka föri ngeniei? Üa körukoto pwe kopwe anümamaua chokewe üa oputeer. Nge iei ka chök afeiöchüür.” ");
INSERT INTO chk_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Iwe, Palam a üra, “Ifa usun, üpwe tongeni apasa och me lükün mine ewe Samol mi Lapalap a aiti ngeniei?” ");
INSERT INTO chk_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Mürin, Palak a üreni Palam, “Kopwe etieila lon pwal eu leni ia ka tongeni küna ekewe aramas me ie. Pun kopwe chök küna eu kinikin seni ar we mwich, nge sap unuser. Iwe, kopwe anümamaueer ngeniei seni ikenan.” ");
INSERT INTO chk_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Iwe, a emwenala Palam ngeni ewe lemälen Sofim won ungen ewe chuk Piska. Ikenan a pwal senätä fisu rongen asor o eäni asor eman ätemwänin kow me eman ätemwänin sip won eu me eu kewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Nge Palam a üreni Palak, “Kopwe ütä ikei lükün om kei asoren kek, nge ngang üpwe churi ewe Samol mi Lapalap ikenan.” ");
INSERT INTO chk_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Iwe, ewe Samol mi Lapalap a churi Palam o aiti ngeni mine epwe apasa. Mürin a üreni, “Kopwe liwinla ren Palak, nge epwe ina chök alom ngeni.” ");
INSERT INTO chk_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Iwe, Palam a liwinla ren Palak o küna pwe a chüen ütä lükün an kewe asoren kek, nge ekewe souakomwen Moap ra nom ren. Iwe, Palak a aisini, “Met ewe Samol mi Lapalap a apasa?” ");
INSERT INTO chk_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Mürin, Palam a popuetä an kapasen osuni o üra, “Kopwe ütä, Palak, o rongorong. Kopwe aüselingaei, en nöün Sipor we mwän. ");
INSERT INTO chk_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Kot esap eman aramas pwe epwe chofana, esap pwal i nöün aramas pwe epwe ekieksefäl. Ifa usun, epwe apasa och, nge esap föri? Ika epwe pwonei och, nge esap apwönüetä? ");
INSERT INTO chk_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ngang üa angei eu allük pwe üpwe afeiöchü chon Israel. Kot a afeiöchüür, nge üsap tongeni sorei. ");
INSERT INTO chk_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Üsap küna pwe epwe wor feiengau ika osukosuk ngeni ekewe chon Israel lon ekewe fansoun repwe feito. Ewe Samol mi Lapalap ar Kot a nom rer, ra pwärätä fän mweireir pwe i ar king. ");
INSERT INTO chk_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Kot a emwenirewu seni Isip, ar pöchökül a usun chök pöchökülen eman ätemwänin kow mi mwacho. ");
INSERT INTO chk_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Pun esap wor och pöüt ika och rong epwe küw ekewe chon Israel o afeiengaueer. Lon ei fansoun repwe apasa usun ekewe aramasen Israel, ‘Nengeni mine Kot a föri fän iter.’ ");
INSERT INTO chk_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ekewe aramasen Israel ra pwätä usun eman liefefinin laion, ra öüröürela usun eman ätemwänin laion esap konola tori epwe asomwala liapan o ünümi chan chokewe a nirela.” ");
INSERT INTO chk_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Mürin, Palak a üreni Palam, “Are kosap mochen anümamaueer, kosap pwal afeiöchüür.” ");
INSERT INTO chk_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Nge Palam a üreni Palak, “Ifa usun, üsap ürenuk pwe meinisin mine ewe Samol mi Lapalap a apasa üpwe fokun föri?” ");
INSERT INTO chk_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Mürin, Palak a üreni Palam, “Kopwe etto pwe üpwe emwenuk ngeni pwal eu leni. Eli Kot epwe efich om kopwe anümamaueer ngeniei seni ikenan.” ");
INSERT INTO chk_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Iei mine Palak a emwenätä Palam won ungen ewe chuk Peor ia ra tongeni nenetiuei ewe fanüapö me ie. ");
INSERT INTO chk_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Iwe, Palam a üreni Palak, “Kopwe senätä ikei fisu rongen asor fän itei o uwato rei füman ätemwänin kow me füman ätemwänin sip.” ");
INSERT INTO chk_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Iwe, Palak a föri usun mine Palam a üreni. A eäni asor eman ätemwänin kow me eman ätemwänin sip won eu me eu kewe rongen asor. ");
INSERT INTO chk_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Iwe, lupwen Palam a silei, pwe mochenin ewe Samol mi Lapalap pwe Israel epwe feiöch, esap feila pwe epwe föri och asisil usun me mwan, nge a newenewen ngeni ewe fanüapö. ");
INSERT INTO chk_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Iwe, a küna ekewe chon Israel lon ewe leni ia ra nonom ie en me lon an ainang. Iwe, Ngünün Kot a feito won, ");
INSERT INTO chk_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","pwe a popuetä an kapasen osuni o üra, “Iei alon Palam nöün Peor we mwän. Iei alon ewe mwän mi fat mesan, ");
INSERT INTO chk_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","alon ätewe mi rongorong än Kot kapas, ätewe mi wor künan seni Ewe mi Unusen Manaman. A chapetiu, nge mesan esap pwölüpwöl: ");
INSERT INTO chk_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","A fokun mürina imwemi kewe imw mangaku me leniemi kewe ämi chon Israel. ");
INSERT INTO chk_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ra usun chök tettelin ekewe irä palm mi langatam telin, pwal usun chök ekewe tanipi ünükün eu chanpupu. Iwe, ra usun chök irä mi pwokus itan aloes, ewe Samol mi Lapalap a fotuki, pwal usun chök ekewe irä setar ünükün ekewe chanpupu. ");
INSERT INTO chk_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Iwe, koluk epwe pupu seni ar lenien koluk, repwe fotuki fotar pwükil lon pwülüchöchön. Ar king epwe tekia seni ewe king Akak, nge mwür epwe fefeitä. ");
INSERT INTO chk_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Kot a emwenirewu seni Isip, ar pöchökül a usun chök pöchökülen eman ätemwänin kow mi mwacho. Iwe, repwe asomwala ekewe mwü mi ü ngeniir, repwe kupi chüür o atatakisiir, repwe pwal posu ngeniir wokur kewe esefich. ");
INSERT INTO chk_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ewe mwün Israel a wewe ngeni eman laion mi pwora. Lupwen a konola, esap wor eman a tongeni apwätäi. Ra feiöch chon afeiöchü chon Israel, nge ra anümamau chon anümamaueer. ");
INSERT INTO chk_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Mürin, Palak a fokun song ngeni Palam, a öüwu pöün o üreni, “Üa körukoto pwe kopwe anümamaua chokewe üa oputeer. Nge iei ka fen afeiöchüür fän ülüngat. ");
INSERT INTO chk_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Iei mine kopwe süla lon fanüom. Üa pwon ngonuk pwe üpwe liwiniik, nge ewe Samol mi Lapalap a amwöchü senuk liwinum.” ");
INSERT INTO chk_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Nge Palam a üreni Palak, “Üa fen üreni noum kewe chon künö ka tinireto rei, ");
INSERT INTO chk_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","pwe inamwo ika kopwe ngeniei om silifer me kolt meinisin mi nom lon imwom, üsap tongeni lükümach ngeni än ewe Samol mi Lapalap kapas, pwe üpwe föri letipei. Ikamwo a öch ika a ngau, üpwe chök apasa mine ewe Samol mi Lapalap a kapas ngeniei. ");
INSERT INTO chk_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Iei üpwe liwinla ren aramasei kewe. Nge üpwe asile ngonuk mine ekewe aramasen Israel repwe föri ngeni noum aramas lon ekan rän mwach.” ");
INSERT INTO chk_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Mürin, Palam a popuetä an kapasen osuni o üra, “Iei alon Palam nöün Peor we mwän. Iei alon ewe mwän mi fat mesan, ");
INSERT INTO chk_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","alon ätewe mi rongorong än Kot kapas o angei ewe tipachem seni Ewe mi Unusen Tekia, ätewe mi wor künan seni Ewe mi Unusen Manaman. A chapetiu, nge mesan esap pwölüpwöl: ");
INSERT INTO chk_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Üa küna i, nge esap iei, üa nenengeni, nge esap kanoto. Eföü fü epwe tötä seni Israel, eman king epwe ütä seni lon Israel pwe epwe nemenem. Epwe amökü möküren ekewe chon Moap o niela ekewe mwirimwirin Set meinisin. ");
INSERT INTO chk_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Epwe akufu chokewe mi oput i me lon Etom o fanüeni fanüer. Nge Israel epwe chök win. ");
INSERT INTO chk_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Eman sounemenem epwe towu seni ekewe mwirimwirin Jakop, epwe arosala chokewe mi chüen manau meinisin.” ");
INSERT INTO chk_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Mürin Palam a nenela won Amalek o eäni an kapasen osuni usun, “Amalek, ewe mwü mi akom me lein ekewe mwü meinisin, nge sopolan epwe unusen tala.” ");
INSERT INTO chk_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Nge lupwen a nenela won chon Ken, a eäni an kapasen osuni usur, “Inamwo are lenien imwemi ra pöchökül o lerasen imwemi ra nom won ekewe achau, ");
INSERT INTO chk_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","nge ämi chon Ken oupwe rosola, lupwen oupwe oola ren chon Asur.” ");
INSERT INTO chk_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Mürin a eäni an kapasen osuni o üra, “Iö epwe tongeni manau, lupwen Kot a föri ei? ");
INSERT INTO chk_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Iwe, sipen maun repwe feito seni Kittim o akufu chon Asur me chon Eper. Nge pwal ir repwe fokun mäla me mürin.” ");
INSERT INTO chk_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Mürin, Palam a ütä o liwinla ngeni lenian. Nge Palak a pwal liwinla ngeni lenian. ");
INSERT INTO chk_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Iwe, lupwen ekewe chon Israel ra nonom lon Sittim, ekewe mwän ra lisowu ngeni ekewe fin Moap. ");
INSERT INTO chk_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Iwe, ekewe fin Moap ra aweineer pwe repwe etiir le asor ngeni ar kewe kot. Iwe, ekewe aramas ra etiir le mongö seni ewe asor o chapetiu ngeni ar kewe kot. ");
INSERT INTO chk_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Iei usun ekewe chon Israel ra etiir le fel ngeni Paal me lon Peor. Nge ewe Samol mi Lapalap a fokun song ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe angei ekewe samolun aramas meinisin, kopwe nirela o eitiweer fän akar me fän mesei, pwe pöchökülen ai song epwe kul seni ekewe chon Israel.” ");
INSERT INTO chk_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Iwe, Moses a üreni ekewe soukapwüng lon Israel, “Eman me eman leimi epwe niela chokewe seni en me an ainang mi eti ekewe chon Moap le fel ngeni Paal me lon Peor.” ");
INSERT INTO chk_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Nge nengeni, eman me lein ekewe aramasen Israel a feito o emwenato lon imwan eman fin Mitian fän mesen Moses pwal fän mesen ekewe aramasen Israel meinisin, lupwen ra kechü leasamalapen ewe imw mangaku ia aramas ra churi Kot ie. ");
INSERT INTO chk_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Iwe, lupwen Pineas nöün Eleasar mwän, nge Eleasar nöün ewe souasor Aaron mwän, a küna ei, a ütä o towu seni ewe mwichen aramas. A angei efoch siles ");
INSERT INTO chk_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","o tapwelong mürin ewe re Israel me ewe fefin lon ewe rumwen lon o posurifengeniir me ruoman. Iei usun ewe mätter a ükütiu seni ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Nge chokewe ra fen mäla ren ewe mätter ükükün rüe me rüanüngeröü. ");
INSERT INTO chk_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Pineas a akulu ai song seni ekewe aramasen Israel. Pokiten i a lukomonguni ai lukomong wor, iei mine üsap chüen arosala ekewe aramasen Israel lon ai lukomong. ");
INSERT INTO chk_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Iei mine kopwe üreni Pineas pwe üpwe föri ai pwonen kinamwe ngeni. ");
INSERT INTO chk_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ei pwon epwe fän itan me fän iten mwirimwirin pwe repwe wiseni ewe wisen souasor tori feilfeilachök. Pun a lukomong woi o föri asoren amusamusen tipis fän iten ekewe aramasen Israel.” ");
INSERT INTO chk_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Iwe, iten ewe re Israel mi ninnilafengen me ewe fin Mitian Simri nöün Salu mwän, i samolun eu famili seni ewe ainangen Simeon. ");
INSERT INTO chk_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Nge iten ewe fin Mitian mi ninnila Kospi nöün Sur fefin. Iwe, Sur i samolun eu cho lon Mitian. ");
INSERT INTO chk_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Oupwe afeiengaua ekewe chon Mitian o nirela. ");
INSERT INTO chk_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Pun ir ra afeiengauakemi, lupwen ra atupukemi me lon Peor, pwal mine a fis ren Kospi fefiner we, nöün eman samolun Mitian fefin, neminewe mi ninnila lon ewe rän, lupwen a fis ewe mätter pokiten ewe föför lon Peor.” ");
INSERT INTO chk_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Mürin ewe mätter, ewe Samol mi Lapalap a üreni Moses me Eleasar nöün ewe souasor Aaron we mwän, ");
INSERT INTO chk_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Oupwe angei iteiten ekewe aramasen Israel meinisin seni ier rüe feitä lon en me an famili, meinisin mi tongeni fiti maun.” ");
INSERT INTO chk_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Iwe, Moses me ewe souasor Eleasar ra kapas ngeni ekewe aramas me lon ewe maasiesin Moap arun ewe chanpupu Jortan sasape ngeni Jeriko o üreniir, ");
INSERT INTO chk_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","pwe repwe angei iteiten ekewe mwän seni ier rüe feitä, usun ewe Samol mi Lapalap a fen allük ngeni Moses. Ikkei ir ekewe aramasen Israel mi towu seni ewe fanü Isip: ");
INSERT INTO chk_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ekewe mwirimwirin Rupen, nöün Israel we mwänichi lon tettelin ar kewe cho: än Hanok cho, än Palu cho, ");
INSERT INTO chk_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","än Hesron cho me än Karmi cho. ");
INSERT INTO chk_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Iteiter meinisin me lon ewe ainangen Rupen faik me ülüngatngeröü füpükü ilik mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Iwe, nöün Palu mwän: Eliap. ");
INSERT INTO chk_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Nge nöün Eliap kewe mwän: Nemuel, Tatan me Apiram. Ätekei Tatan me Apiram ra kefilitä seni ewe mwichen aramas pwe nöür nöüwis. Ra ü ngeni Moses me Aaron o eti än Kora mwich le ü ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mürin, ewe pwül a sangfesen o oromirela fiti Kora. Iei usun ekewe aramas ra mäla, nge ekkei a kenala ekewe ruopükü lime mwän. Iwe, a fis pwe ir eu lenien eniweniw. ");
INSERT INTO chk_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Nge nöün Kora kewe mwän resap mäla. ");
INSERT INTO chk_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Iwe, ekewe mwirimwirin Simeon lon tettelin ar kewe cho: än Nemuel cho, än Jamin cho, än Jakin cho, ");
INSERT INTO chk_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","än Sera cho me än Shaul cho. ");
INSERT INTO chk_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Iteiter meinisin me lon ewe ainangen Simeon rüe me ruungeröü ruopükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Iwe, ekewe mwirimwirin Kat lon tettelin ar kewe cho: än Sefon cho, än Haki cho, än Shuni cho, ");
INSERT INTO chk_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","än Osni cho, än Eri cho, ");
INSERT INTO chk_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","än Arot cho me än Areli cho. ");
INSERT INTO chk_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Iteiter meinisin me lon ewe ainangen Kat faik ngeröü limepükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Iwe, nöün Juta kewe mwän Er me Onan. Nge Er me Onan ra mäla lon ewe fanü Kanaan. ");
INSERT INTO chk_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Iwe, ekewe mwirimwirin Juta lon tettelin ar kewe cho: än Shela cho, än Peres cho me än Sera cho. ");
INSERT INTO chk_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Nge ekewe mwirimwirin Peres: än Hesron cho me än Hamul cho. ");
INSERT INTO chk_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Iteiter meinisin me lon ewe ainangen Juta fik me wonungeröü limepükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Iwe, ekewe mwirimwirin Isakar lon tettelin ar kewe cho: än Tola cho, än Puwa cho, ");
INSERT INTO chk_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","än Jasup cho me än Simron cho. ");
INSERT INTO chk_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Iteiter meinisin me lon ewe ainangen Isakar wone me rüanüngeröü ülüpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Iwe, ekewe mwirimwirin Sepulon lon tettelin ar kewe cho: än Seret cho, än Elon cho me än Jalel cho. ");
INSERT INTO chk_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Iteiter meinisin me lon ewe ainangen Sepulon wone ngeröü limepükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Iei ekewe mwirimwirin Josef lon tettelin ar kewe cho mi pop seni Manasa me Efraim: ");
INSERT INTO chk_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ekewe mwirimwirin Manasa: än Makir cho me än Kiliat cho. (Iwe, Makir semen Kiliat.) ");
INSERT INTO chk_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Nge ekewe mwirimwirin Kiliat: än Jeser cho, än Helek cho, ");
INSERT INTO chk_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","än Asriel cho, än Sekem cho, ");
INSERT INTO chk_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","än Semita cho me än Hefer cho. ");
INSERT INTO chk_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Nge Selofehat nöün Hefer we mwän esap wor nöün mwän, pwe a chök wor nöün fefin. Iwe, ikkei iten nöün Selofehat kewe fefin: Mala, Noa, Hokla, Milka me Tirsa. ");
INSERT INTO chk_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Iteiter meinisin me lon ewe ainangen Manasa lime me ruungeröü füpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Iwe, ekewe mwirimwirin Efraim lon tettelin ar kewe cho: än Sutela cho, än Peker cho me än Tahan cho. ");
INSERT INTO chk_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Nge ekewe mwirimwirin Sutela: än Eran cho. ");
INSERT INTO chk_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Iteiter meinisin me lon ewe ainangen Efraim ilik me ruungeröü limepükü mwän. Ikkei ir ekewe mwirimwirin Josef lon tettelin ar kewe cho. ");
INSERT INTO chk_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Iwe, ekewe mwirimwirin Peniamin lon tettelin ar kewe cho: än Pela cho, än Aspel cho, än Ahiram cho, ");
INSERT INTO chk_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","än Sefufam cho me än Hufam cho. ");
INSERT INTO chk_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Nge ekewe mwirimwirin Pela: än Art cho me än Naaman cho. ");
INSERT INTO chk_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Iteiter meinisin me lon ewe ainangen Peniamin faik me limungeröü wonopükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Iwe, ekewe mwirimwirin Tan lon tettelin ar we cho: än Suham cho. ");
INSERT INTO chk_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Iteiter meinisin me lon ewe ainangen Tan wone me rüanüngeröü föpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Iwe, ekewe mwirimwirin Aser lon tettelin ar kewe cho: än Imna cho, än Iswi cho me än Peria cho. ");
INSERT INTO chk_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Nge ekewe mwirimwirin Peria: än Heper cho me än Malkiel cho. ");
INSERT INTO chk_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Iwe, iten nöün Aser we fefin Sera. ");
INSERT INTO chk_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Iteiter meinisin me lon ewe ainangen Aser lime me ülüngatngeröü föpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Iwe, ekewe mwirimwirin Naftali lon tettelin ar kewe cho: än Jaseel cho, än Kuni cho, ");
INSERT INTO chk_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","än Jeser cho me än Sillem cho. ");
INSERT INTO chk_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Iteiter meinisin me lon ewe ainangen Naftali faik me limungeröü föpükü mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Iwe, kapachalapen ekewe re Israel meinisin ükükün wonopükü eungeröü füpükü ilik mwän. ");
INSERT INTO chk_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ewe fanü epwe ainet ngeni ekei aramas pwe repwe fanüeni, epwe alongolong won iteiter. ");
INSERT INTO chk_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Are eu ainang a watte, kopwe awattei fanüan, nge are eu ainang a kükün, kopwe pwal akükünü fanüan. Iteiten eu me eu ainang epwe angei fanüan won ükükün chochon. ");
INSERT INTO chk_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Nge ewe fanü epwe inet ren üttüt. Repwe angei fanüer lon tettelin iten än semer kewe ainang. ");
INSERT INTO chk_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Iwe, fän pwüngün ar üttüt, fanüer epwe ainet ngeni ekewe ainang watte me kükün.” ");
INSERT INTO chk_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Iwe, ikkei tettelin chon ewe ainangen Lefi lon ar kewe cho: än Kerson cho, än Kohat cho me än Merari cho. ");
INSERT INTO chk_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ikkei pwal ekoch cho seni ewe ainangen Lefi: än Lipni cho, än Hepron cho, än Mali cho, än Mushi cho me än Kora cho. Nge Kohat semen Amram. ");
INSERT INTO chk_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Iwe, iten pwülüen Amram Jokopet, nöün Lefi fefin a nöüni me Isip. Nge Jokopet a nöüni me won Amram: Aaron, Moses me Miriam fefiner we. ");
INSERT INTO chk_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Iwe, Aaron a nöüni Natap, Apihu, Eleasar me Itamar. ");
INSERT INTO chk_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nge Natap me Apihu ra mäla, lupwen ra eäni asor ngeni ewe Samol mi Lapalap ekkei esap pin. ");
INSERT INTO chk_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Iwe, iteiten mwän seni ewe ainangen Lefi seni eu maram feitä ükükün rüe me ülüngat ngeröü. Ir resap alealong lon iteiten ekewe aramasen Israel, pokiten resap angei fanüer me leir. ");
INSERT INTO chk_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Iwe, ikkei ekewe iteit Moses me ewe souasor Eleasar ra aleani, lupwen ra angei iteiten ekewe aramasen Israel lon ewe maasiesin Moap arun ewe chanpupu Jortan sasape ngeni Jeriko. ");
INSERT INTO chk_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Nge lon ei iteit esap wor eman mwän me lein chokewe Moses me ewe souasor Aaron ra fen aleani, lupwen ra angei iteiten ekewe aramasen Israel lon ewe fanüapön Sinai. ");
INSERT INTO chk_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Pun ewe Samol mi Lapalap a apasa pwe ir meinisin repwe mäla lon ewe fanüapö. Esap wor eman mwän me leir a chüen manau, chilon chök Kalep nöün Jefune mwän me Josua nöün Nun mwän. ");
INSERT INTO chk_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Iwe, nöün Selofehat kewe fefin ra feito o uwato ar tüngor. Iwe, Selofehat nöün Hefer mwän, nge Hefer nöün Kiliat mwän, nge Kiliat nöün Makir mwän, nge Makir nöün Manasa mwän seni än Manasa cho, nge Manasa nöün Josef we mwän. Iwe, iten nöün Selofehat kewe fefin Mala, Noa, Hokla, Milka me Tirsa. ");
INSERT INTO chk_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Iwe, ra üta leasamalapen ewe imw mangaku ia aramas ra churi Kot ie fän mesen Moses me ewe souasor Eleasar, pwal fän mesen ekewe souemwen me ekewe aramas meinisin. Iwe, ra apasa, ");
INSERT INTO chk_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Semem we a mäla lon ewe fanüapö. Nge esap wor nöün mwän. I esap eman lein än Kora we mwich mi chufengen le ü ngeni ewe Samol mi Lapalap, pwe a mäla pokiten püsin an tipis. ");
INSERT INTO chk_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Pwota iten semem epwe töttöluwu seni an cho pokiten esap wor nöün mwän? Oupwe ngenikem eu fanü me lein fanüen pwin semem.” ");
INSERT INTO chk_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Iwe, Moses a asile ngeni ewe Samol mi Lapalap ar tüngor. ");
INSERT INTO chk_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Nge ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Än nöün Selofehat kewe fefin tüngor a pwüng. Kopwe afanüeer me lein fanüen pwin semer, pun fanüer we won semer epwe toriir. ");
INSERT INTO chk_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Iwe, kopwe üreni ekewe aramasen Israel: Are eman mwän a mäla, nge esap wor nöün mwän, nöün fefin epwe fanüeni fanüan. ");
INSERT INTO chk_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Nge are esap wor nöün fefin, pwin ewe mwän repwe fanüeni fanüan. ");
INSERT INTO chk_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Nge are esap wor pwin, pwin saman kewe repwe fanüeni fanüan. ");
INSERT INTO chk_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Nge are esap wor pwin saman we, eman me lein an eterekes mi kükü ngeni epwe fanüeni fanüan. Ei epwe eu pwüng me eu allük fän iten ekewe aramasen Israel, usun ngang ewe Samol mi Lapalap üa allük ngonuk.” ");
INSERT INTO chk_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe feitä won ewe chukuchukutä Aparim o nenneloi ewe fanü üa ngeni ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Nge lupwen ka küna ewe fanü, pwal en kopwe mäla o chufengen me om kewe lewo usun pwiüm Aaron. ");
INSERT INTO chk_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Pun oua lükümach ngeni ai kewe kapas me lükün ekewe koluk me lon ewe fanüapön Sin, lupwen ekewe aramas ra lal ngeniei, nge ämi ousap apiniöchüei fän meser.” (Ikkei ekewe kolukun Meripa lon Kates lon ewe fanüapön Sin.) ");
INSERT INTO chk_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Iwe, Moses a üreni ewe Samol mi Lapalap, ");
INSERT INTO chk_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“En Samol mi Lapalap popun manauen mönümanau meinisin, kose mochen kopwe filätä eman mwän epwe emweni ei mwichen aramas, ");
INSERT INTO chk_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","epwe akakomweer le emweniir lon mettoch meinisin, pwe noum mwichen aramas esap wewe ngeni eu pwiin sip esap wor ar chon mas.” ");
INSERT INTO chk_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Iwe, ewe Samol mi Lapalap a üreni Moses, “Kopwe emwenato Josua nöün Nun we mwän o iseis poum won, pun Ngüni a nom won. ");
INSERT INTO chk_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Kopwe aütäi fän mesen ewe souasor Eleasar pwal fän mesen ekewe aramas meinisin, pwe kopwe ngeni wisan. ");
INSERT INTO chk_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Kopwe isetä won ekis om nemenem, pwe ekewe aramasen Israel meinisin repwe aleasochisi. ");
INSERT INTO chk_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Epwe ütä fän mesen ewe souasor Eleasar, nge Eleasar epwe kütta letipei fän itan ren ewe Urim . Iwe, fän än Eleasar kapas Josua fiti ekewe aramasen Israel meinisin repwe föri sokopaten ar angang meinisin.” ");
INSERT INTO chk_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Iwe, Moses a föri usun mine ewe Samol mi Lapalap a allük ngeni. A emwenato Josua o aütäi fän mesen ewe souasor Eleasar me ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Iwe, a iseis pöün won o awisa ngeni wisan usun ewe Samol mi Lapalapa a aiti ngeni. ");
INSERT INTO chk_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Kopwe allük ngeni ekewe aramasen Israel: Oupwe tümwünü pwe oupwe uwato rei ekewe asor fän itei lon ekewe fansoun mi kefilitä, ekewe asoren mongö üa efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Iwe, kopwe üreniir: Iei ewe asor oupwe eäni asor ngeni ewe Samol mi Lapalap. Iteiten rän oupwe chök äkeäni asor ruoman ätemwänin lam eu ieriir esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Iwe, ewe aemanün oupwe eäni asor lesosor, nge ewe aruomanün oupwe eäni lekuniol. ");
INSERT INTO chk_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Oupwe pwal achu ngeni ruu paun pilawa mi amas o mürina mi nofitfengen me eu kuoch apüra seni föün olif mi wüsüs pwe asoren mongö. ");
INSERT INTO chk_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Iei ewe asoren kek epwe chök fifis iteiten rän, usun a fen kefis me fäsonun ewe chuk Sinai, pwe eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Nge fän iten eman me eman lam epwe wor asoren ün eu kuoch wain. Oupwe ninätiu ei asoren ün ngeni ewe Samol mi Lapalap lon ewe leni mi pin. ");
INSERT INTO chk_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Iwe, ewe aruomanün lam oupwe eäni asor lekuniol. Oupwe pwal achu ngeni ewe asoren mongö me ewe asoren ün, usun chök ewe asor a fis lesosor, pwe eu asor ewe Samol mi Lapalap a efich pwoon.” ");
INSERT INTO chk_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Iwe, lon ewe ränin sapat oupwe eäni asor ruoman ätemwänin lam eu ierir esap wor terir, pwal rüanü paun pilawa mi amas o mürina mi nofitfengen me apüra, pwe eu asoren mongö me ewe asoren ün. ");
INSERT INTO chk_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Iei ewe asoren kek epwe fis iteiten ränin sapat lükün ewe asoren kek me ewe asoren ün mi chök fifis iteiten rän. ");
INSERT INTO chk_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Iwe, lepoputän iteiten maram oupwe eäni asoren kek ngeni ewe Samol mi Lapalap ruoman nienifön ätemwänin kow, eman ätemwänin sip, füman ätemwänin lam eu ierir esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Iwe, wonu paun pilawa mi amas o mürina mi nofitfengen me apüra epwe chu ngeni eman me eman ätemwänin kow, rüanü paun pilawa mi amas mi nofitfengen me apüra epwe chu ngeni ewe ätemwänin sip, ");
INSERT INTO chk_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","nge ruu paun pilawa mi amas o mürina mi nofitfengen me apüra epwe chu ngeni eman me eman lam pwe asoren mongö. Iei eu asoren kek ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Iwe, ikkei ekewe asoren ün: esop kalon wain epwe chu ngeni eman me eman ätemwänin kow, eu esop kuoch wain epwe chu ngeni ewe ätemwänin sip, nge eu kuoch wain epwe chu ngeni eman me eman lam. Iei ewe asoren kek epwe fis iteiten maram lon eu ier. ");
INSERT INTO chk_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Iwe, oupwe pwal eäni asor ngeni ewe Samol mi Lapalap eman ätemwänin kuuch pwe asoren tipis. Ei asor epwe fis lükün ewe asoren kek me ewe asoren ün mi chök fifis iteiten rän.” ");
INSERT INTO chk_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Iwe, lon engol me rüanün ränin ewe aeuin maram epwe fis än ewe Samol mi Lapalap Pasofer. ");
INSERT INTO chk_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Nge lon engol me limuen ränin ewe chök maram epwe fis eu chulap. Lon ükükün fisu rän oupwe mongö pilawa esap wor iis lon. ");
INSERT INTO chk_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Iwe, lon aeuin rän oupwe afisi eu mwich mi pin. Ousap föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Oupwe eäni eu asoren kek ngeni ewe Samol mi Lapalap ruoman nienifön ätemwänin kow, eman ätemwänin sip me füman ätemwänin lam eu ierir. Oupwe pii pwe esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Epwe pwal chu ngeniir ewe asoren mongö pilawa mi amas o mürina mi nofitfengen me apüra. Iwe, wonu paun pilawa epwe chu ngeni eman me eman ätemwänin kow, rüanü paun epwe chu ngeni ewe ätemwänin sip, ");
INSERT INTO chk_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","nge ruu paun pilawa epwe chu ngeni eman me eman kewe füman lam. ");
INSERT INTO chk_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch, pwe epwe fis asoren amusamusen tipis fän itemi ren. ");
INSERT INTO chk_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Iwe, oupwe eäni ekei asor lükün ewe asoren kek mi chök fifis iteiten lesosor. ");
INSERT INTO chk_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Iei usun oupwe eäni asor iteiten rän lon ükükün fisu rän. Ei eu asoren mongö ewe Samol mi Lapalap a efich pwoon, epwe fis lükün ewe asoren kek me ewe asoren ün mi chök fifis iteiten rän. ");
INSERT INTO chk_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Iwe, lon afisuen rän oupwe pwal afisi eu mwich mi pin. Ousap föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Iwe, oupwe pwal afisi eu mwich mi pin lon ewe ränin kinikinin mwen ua, lupwen oupwe eäni ewe asoren mongö seni ekewe föün wiich mi fö ngeni ewe Samol mi Lapalap lon ewe chulapen wiik. Ousap föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Nge oupwe eäni asoren kek ruoman nienifön ätemwänin kow, eman ätemwänin sip me füman ätemwänin lam eu ierir, pwe ewe Samol mi Lapalap epwe efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Epwe pwal chu ngeniir ewe asoren mongö pilawa mi amas o mürina mi nofitfengen me apüra. Iwe, wonu paun pilawa epwe chu ngeni eman me eman ätemwänin kow, rüanü paun epwe chu ngeni ewe ätemwänin sip, ");
INSERT INTO chk_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","nge ruu paun pilawa epwe chu ngeni eman me eman kewe füman lam. ");
INSERT INTO chk_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Iwe, oupwe pwal eäni asor eman ätemwänin kuuch, pwe epwe fis asoren amusamusen tipis fän itemi ren. ");
INSERT INTO chk_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Iwe oupwe eäni ekei asor fitifengen me ekewe asoren ün lükün ewe asoren kek me ewe asoren mongö mi chök fifis iteiten rän. Oupwe pii pwe esap wor terin ekewe mönün asor. ");
INSERT INTO chk_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Iwe, lon aeuin ränin ewe afisuen maram oupwe afisi eu mwich mi pin. Ousap föri och angang lon. Ei rän eu ränin ämi oupwe ettiki ekewe rappwa. ");
INSERT INTO chk_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Oupwe eäni asoren kek eman nienifön ätemwänin kow, eman ätemwänin sip me füman ätemwänin lam eu ierir, pwe ewe Samol mi Lapalap epwe efich pwoon. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Epwe pwal chu ngeniir ewe pilawa mi amas o mürina mi nofitfengen me apüra. Iwe, wonu paun pilawa epwe chu ngeni ewe ätemwänin kow, pwal rüanü paun epwe chu ngeni ewe ätemwänin sip, ");
INSERT INTO chk_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","nge ruu paun epwe chu ngeni eman me eman kewe füman lam. ");
INSERT INTO chk_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Iwe, oupwe pwal eäni asoren tipis eman ätemwänin kuuch pwe epwe fis asoren amusamusen tipis fän itemi ren. ");
INSERT INTO chk_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Ekei asor repwe fis lükün ewe asoren kek lepoputän maram me ewe asoren mongö mi chu ngeni, pwal lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni lon pwüngün allükür. Ei eu asor ewe Samol mi Lapalap a efich pwoon. ");
INSERT INTO chk_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Iwe, lon engolun ränin ei afisuen maram oupwe afisi eu mwich mi pin. Oupwe echikefel, ousap pwal föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Nge oupwe eäni asoren kek eman nienifön ätemwänin kow, eman ätemwänin sip me füman ätemwänin lam eu ierir, pwe ewe Samol mi Lapalap epwe efich pwoon. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Epwe pwal chu ngeniir ewe asoren mongö pilawa mi amas o mürina mi nofitfengen me apüra. Iwe, wonu paun pilawa epwe chu ngeni ewe ätemwänin kow, rüanü paun pilawa epwe chu ngeni ewe ätemwänin sip, ");
INSERT INTO chk_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","nge ruu paun epwe chu ngeni eman me eman kewe füman lam. ");
INSERT INTO chk_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren amusamusen tipis, pwal lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Iwe, lon engol me limuen ränin ewe afisuen maram oupwe afisi eu mwich mi pin. Ousap föri och angang lon, nge oupwe föri eu chulap ngeni ewe Samol mi Lapalap lon ükükün fisu rän. ");
INSERT INTO chk_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Iwe, lon aeuin rän oupwe eäni asoren kek engol me ülüman nienifön ätemwänin kow, ruoman ätemwänin sip me engol me föman ätemwänin lam eu ierir, pwe ewe Samol mi Lapalap epwe efich pwoon. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Epwe pwal chu ngeniir ewe asoren mongö pilawa mi amas o mürina mi nofitfengen me apüra. Iwe, wonu paun pilawa epwe chu ngeni eman me eman kewe engol me ülüman ätemwänin kow, rüanü paun epwe chu ngeni eman me eman kewe ruoman ätemwänin sip, ");
INSERT INTO chk_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","nge ruu paun epwe chu ngeni eman me eman kewe engol me föman lam. ");
INSERT INTO chk_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Nge lon aruuen rän oupwe eäni asor engol me ruoman nienifön ätemwänin kow, ruoman ätemwänin sip me engol me föman ätemwänin lam eu ierir. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Iwe, ewe asoren mongö me asoren ün repwe chu ngeni ekewe ätemwänin kow, ekewe ätemwänin sip me ekewe lam ükükün iteiter lon pwüngün allükür. ");
INSERT INTO chk_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Iwe, lon aülüngatin rän oupwe eäni asor engol me eman nienifön ätemwänin kow, ruoman ätemwänin sip me engol me föman ätemwänin lam eu ierir. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Iwe, ewe asoren mongö me asoren ün repwe chu ngeni ekewe ätemwänin kow, ekewe ätemwänin sip me ekewe lam ükükün iteiter lon pwüngün allükür. ");
INSERT INTO chk_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Iwe, lon arüanün rän oupwe eäni asor engol nienifön ätemwänin kow, ruoman ätemwänin sip me engol me föman ätemwänin lam eu ierir. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Iwe, ewe asoren mongö me asoren ün repwe chu ngeni ekewe ätemwänin kow, ekewe ätemwänin sip me ekewe lam ükükün iteiter lon pwüngün allükür. ");
INSERT INTO chk_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Nge lon alimuen rän oupwe eäni asor tiueman nienifön ätemwänin kow, ruoman ätemwänin sip me engol me föman ätemwänin lam eu ierir. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Iwe, ewe asoren mongö me asoren ün repwe chu ngeni ekewe ätemwänin kow, ekewe ätemwänin sip me ekewe lam ükükün iteiter lon pwüngün allükür. ");
INSERT INTO chk_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Iwe, lon awonuen rän oupwe eäni asor waluman nienifön ätemwänin kow, ruoman ätemwänin sip me engol me föman lam eu ierir. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Iwe, ewe asoren mongö me asoren ün repwe chu ngeni ekewe ätemwänin kow, ekewe ätemwänin sip me ekewe lam ükükün iteiter lon pwüngün allükür. ");
INSERT INTO chk_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Nge lon afisuen rän oupwe eäni asor füman nienifön ätemwänin kow, ruoman ätemwänin sip me engol me föman ätemwänin lam eu ierir. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Iwe, ewe asoren mongö me asoren ün repwe chu ngeni ekewe ätemwänin kow, ekewe ätemwänin sip me ekewe lam ükükün iteiter lon pwüngün allükür. ");
INSERT INTO chk_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Iwe, lon awaluen rän oupwe pwal afisi eu mwich mi pin. Ousap föri och angang lon. ");
INSERT INTO chk_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Oupwe eäni asoren kek eman nienifön ätemwänin kow, eman ätemwänin sip me füman ätemwänin lam eu ierir, pwe ewe Samol mi Lapalap epwe efich pwoon. Ir meinisin esap wor terir. ");
INSERT INTO chk_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Iwe, ewe asoren mongö me asoren ün repwe chu ngeni ekewe ätemwänin kow, ekewe ätemwänin sip me ekewe lam ükükün iteiter lon pwüngün allükür. ");
INSERT INTO chk_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Oupwe pwal eäni asoren tipis eman ätemwänin kuuch lükün ewe asoren kek mi chök fifis iteiten rän me ewe asoren mongö me asoren ün mi chu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ikkei ekewe asor oupwe eäni asor ngeni ewe Samol mi Lapalap lon ämi kewe ränin chulap mi kefilitä. Repwe chu ngeni ämi kewe asoren pwon me asor seni püsin letipemi, ämi kewe asoren kek me asoren mongö me asoren ün pwal ämi kewe asoren kinamwe.” ");
INSERT INTO chk_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Iwe, Moses a asile ngeni ekewe aramasen Israel wesewesen meinisin mine ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Iwe, Moses a üreni ekewe mwänirelan ainangen ekewe aramasen Israel, “Iei usun mine ewe Samol mi Lapalap a allük: ");
INSERT INTO chk_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Are eman mwän a eäni eu pwon ngeni ewe Samol mi Lapalap, pwe epwe fang ngeni och, ika a akapel pwe epwe pölüküela och, ätei esap tongeni atai an pwon. Epwe chök apwönüetä meinisin mine a apasawu seni awan. ");
INSERT INTO chk_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Nge are eman föpwül mi chüen nom lon imwen saman a eäni eu pwon ngeni ewe Samol mi Lapalap, pwe epwe fang ngeni och, ika a pwon pwe epwe pölüküela och, ");
INSERT INTO chk_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","are saman a rongorong an pwon me an akapel, nge esap apasa och ngeni, mürin ewe föpwül epwe föri meinisin mine a eäni pwon. ");
INSERT INTO chk_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Nge are saman we esap tipeeu ngeni lon ewe rän, lupwen a rongorong usun, ewe föpwül esap wisen föri mine a eäni pwon. Iwe, ewe Samol mi Lapalap epwe amusala an tipis, pun saman we esap tipeeu ngeni. ");
INSERT INTO chk_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Nge are neminewe epwe pwüpwülü, lupwen a chüen nom fän an pwon ika fän mine a awakai won, ");
INSERT INTO chk_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","are pwülüan epwe rong usun, nge esap apasa och ngeni lon ewe ränin, mürin ewe föpwül epwe föri meinisin mine a eäni pwon. ");
INSERT INTO chk_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Iwe, are pwülüan we esap tipeeu ngeni lon ewe rän, lupwen a rongorong usun, epwe atai än ewe fefin pwon, pwal mine a awakai won. Iwe, ewe Samol mi Lapalap epwe amusala an tipis. ");
INSERT INTO chk_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Nge eman fefin mi mä pwülüan ika eman mi mwü seni pwülüan epwe fokun apwönüetä an kewe pwon meinisin. ");
INSERT INTO chk_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Iwe, are eman fefin a eäni eu pwon me lon imwen pwülüan, ika a pwon pwe epwe pölüküela och, ");
INSERT INTO chk_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","are pwülüan a rongorong, nge esap apasa och, esap pwal pälüeni, mürin ewe fefin epwe fokun apwönüetä an kewe pwon meinisin. ");
INSERT INTO chk_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Nge are pwülüan a atai ekewe pwon lon ewe rän, lupwen a rongorong usun, meinisin mine ewe fefin a apasawu fän iten an kewe pwon pwal fän iten an akapel esap wisen apwönüetä. Iwe, pwülüan a atai ekewe pwon, nge ewe Samol mi Lapalap epwe amusala än ewe fefin tipis. ");
INSERT INTO chk_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Iteiten pwon me iteiten akapel eman fefin a eäni, pwülüan a tongeni anüküchara ika atai. ");
INSERT INTO chk_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Nge are pwülüen ewe fefin esap apasa och ngeni lon ekoch rän, mürin a anüküchara än ewe fefin we pwon me an we akapel meinisin ra nom won. Pwülüan we a anüküchareer, pun esap apasa och ngeni lon ewe rän, lupwen a rongorong usun. ");
INSERT INTO chk_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Nge are a ataar ekoch fansoun mürin an rong usur, epwe mwärelong fän än neminewe tipis.” ");
INSERT INTO chk_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ikkei ekewe allükün pwon ewe Samol mi Lapalap a allük ngeni Moses usun lefilen eman mwän me pwülüan, pwal usun lefilen eman sam me nöün föpwül, lupwen a chüen nom lon imwen saman. ");
INSERT INTO chk_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Kopwe ngeni ekewe chon Mitian chappen ar föför ngeni chon Israel. Mürin kopwap mäla.” ");
INSERT INTO chk_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Iwe, Moses a üreni ekewe aramas, “Oupwe amolätä ekoch mwän me leimi, pwe repwe feila maun ngeni ekewe chon Mitian o ngeniir chappen ar föför fän iten ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Oupwe tinala lon maun engeröü mwän seni eu me eu kewe ainangen Israel.” ");
INSERT INTO chk_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Iei mine ra filätä engeröü mwän seni eu me eu ainang, pwe ükükün engol me ruungeröü re Israel ra molotä ngeni maun. ");
INSERT INTO chk_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mürin, Moses a tinirela ngeni maun, pwal Pinehas nöün ewe souasor Eleasar mwän mi uwei ekewe pisek seni ewe imw mi pin, pwal ekewe rappwa ra nöünöü le ettiki ewe tikin asilesilen maun. ");
INSERT INTO chk_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Iwe, ra maun ngeni ekewe chon Mitian usun ewe Samol mi Lapalap a allük ngeni Moses, o niela mwän meinisin. ");
INSERT INTO chk_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ra pwal achu ngeni niier kewe ekewe limman king seni Mitian iter Efi, Rekem, Sur, Hur me Repa. Ra pwal niela Palam nöün Peor we mwän. ");
INSERT INTO chk_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Iwe, ekewe aramasen Israel ra liapeni ekewe fin Mitian me nöür semirit. Ra pwal angei pwe choon wokur nöür pwiin kow me sip, pwal pisekir meinisin. ");
INSERT INTO chk_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Nge ra pwal kenala än chon Mitian kewe telinimw me ekewe leni ia ra nonom ie. ");
INSERT INTO chk_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Iwe, ra angei choon wokur meinisin ra liapeni, pwal ekewe aramas me man, ");
INSERT INTO chk_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","o uweereto ren Moses me ewe souasor Eleasar pwal ren ekewe aramasen Israel meinisin mi nom lon ewe maasiesin Moap arun ewe chanpupu Jortan sasape ngeni Jeriko. ");
INSERT INTO chk_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Iwe, Moses me ewe souasor Eleasar me ekewe souemwenin ekewe aramas meinisin ra feila lükün ewe ia ra nonom ie, pwe repwe churiir. ");
INSERT INTO chk_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Nge Moses a song ngeni ekewe meilapen mwichen sounfiu, ir ätekewe mi nemenem won ngeröü me pükü ra liwinto seni maun. ");
INSERT INTO chk_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Iwe, a üreniir, “Pwota oua amanaua ekana fefin meinisin? ");
INSERT INTO chk_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ir chokewe mi chei än Palam aüraür ngeniir, pwal ir popun pwe ekewe aramasen Israel ra kul seni ewe Samol mi Lapalap ren ewe föför ra föri me lon Peor. Iei mine ewe mätter a tori än ewe Samol mi Lapalap mwichen aramas. ");
INSERT INTO chk_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Iei popun, iei oupwe niela iteiten ät me lein ekewe semirit, pwal iteiten fefin mi tori mwän. ");
INSERT INTO chk_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Nge oupwe amanaua ekewe nengin meinisin resamwo tori mwän fän itemi. ");
INSERT INTO chk_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Ämi meinisin mi niela aramas, pwal ämi mi atapa somä, oupwe mwo nonom lükün ewe ia aramas ra nonom ie lon ükükün fisu rän. Oupwe püsin alimöchükemi me ekewe föpwül oua liapeniir lon aülüngatin me afisuen rän. ");
INSERT INTO chk_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Oupwe pwal limeti iteiten üf, iteiten pisek seni silin man, iteiten mettoch mi för seni ülen kuuch pwal iteiten pisek seni irä.” ");
INSERT INTO chk_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Iwe, ewe souasor Eleasar a üreni ekewe sounfiu mi liwinto seni maun, “Iei pwüngün ewe allük ewe Samol mi Lapalap a allük ngeni Moses: ");
INSERT INTO chk_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Mettoch meinisin resap tongeni karala: kolt, silifer, piras, mächä, tin me pilom ");
INSERT INTO chk_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","oupwe limetiir lon ekkei pwe repwe limöch. Nge repwe pwal limelim ren ewe kolukun limelim. Iwe, mettoch meinisin mi tongeni karala oupwe limetiir ren koluk. ");
INSERT INTO chk_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Oupwe sopuni üfemi lon afisuen rän pwe oupwe limöch. Mürin oupwe tolong lon ewe ia aramas ra nonom ie.” ");
INSERT INTO chk_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Iwe, ewe Samol mi Lapalap a üreni Moses, ");
INSERT INTO chk_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ämi me ewe souasor Eleasar pwal mwänirelan ekewe familien ewe mwichen aramas oupwe aleani ekewe aramas me man meinisin ra liapeni. ");
INSERT INTO chk_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Mürin kopwe ineti liaper kewe lon ruu kinikin lefilen ekewe sounfiu mi feila maun me ekewe aramas meinisin. ");
INSERT INTO chk_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Iwe, seni inetin ekewe sounfiu mi feila maun kopwe aimwüela fän iten ewe Samol mi Lapalap eman seni iteiten limepükü aramas ika kow ika aas ika sip ika kuuch. ");
INSERT INTO chk_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Kopwe angeir o ngeni ewe souasor Eleasar pwe eu asor ngeni ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Nge seni inetin ekewe aramasen Israel, kopwe aimwüela eman seni iteiten lime aramas ika kow ika aas ika sip ika kuuch ika sokopaten man o ngeni ekewe mwän seni ewe ainangen Lefi mi wisen angang ngeni än ewe Samol mi Lapalap we imwenfel seni mangaku.” ");
INSERT INTO chk_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Iwe, Moses me ewe souasor Eleasar ra föri usun mine ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Iwe, iei ükükün unusen liapen ekewe sounfiu: Wonopükü fik me limungeröü sip, ");
INSERT INTO chk_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","fik me ruungeröü kow, ");
INSERT INTO chk_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","wone me eungeröü aas ");
INSERT INTO chk_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","me ilik me ruungeröü föpwül resamwo tori mwän. ");
INSERT INTO chk_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Iwe, esopun liaper inetin ekewe sounfiu mi feila maun ükükün ülüpükü ilik me fisungeröü limepükü sip. ");
INSERT INTO chk_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Nge inetin ewe Samol mi Lapalap seni ei ükükün: wonopükü fik me limman sip. ");
INSERT INTO chk_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Iwe, inetir kow ükükün ilik me wonungeröü. Nge seni ei ükükün, fik me ruoman inetin ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Iwe, inetir aas ükükün ilik ngeröü limepükü. Nge seni ei ükükün, wone me eman inetin ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Iwe, inetir aramas ükükün engol me wonungeröü. Nge seni ei ükükün, ilik me ruoman inetin ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Iwe, Moses a ngeni ewe souasor Eleasar inetin ewe Samol mi Lapalap pwe eu asor fän itan, usun ewe Samol mi Lapalap a allük ngeni. ");
INSERT INTO chk_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Iwe, esopun liapen ekewe sounfiu Moses a aimwüela pwe inetin ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Iwe, inetin ekewe aramas ükükün ülüpükü ilik me fisungeröü limepükü sip, ");
INSERT INTO chk_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ilik me wonungeröü kow, ");
INSERT INTO chk_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ilik ngeröü limepükü aas ");
INSERT INTO chk_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","me engol me wonungeröü aramas. ");
INSERT INTO chk_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Iwe, seni esopun liaper inetin ekewe aramasen Israel Moses a angei eman seni iteiten lime aramas ika man o ngeni ekewe mwän seni ewe ainangen Lefi mi wisen tümwünü än ewe Samol mi Lapalap we imwenfel seni mangaku, usun ewe Samol mi Lapalap a allük ngeni Moses. ");
INSERT INTO chk_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Mürin, ekewe meilap mi nemeni ekewe mwichen sounfiu ra feito ren Moses ");
INSERT INTO chk_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","o üreni, “Äm noum chon angang aia aleani ekewe sonfiu mi nom fän nemenemem, nge esap wor eman a mäla me leim. ");
INSERT INTO chk_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Iei aia uwato ekewe mettoch seni kolt pwe eu asor fän iten ewe Samol mi Lapalap seni mine eman me eman a angei: lälä me sokun fouten won pau, ring won pau me ierring me sokopaten fout, pwe aipwe eäni asor liwinin manauem ngeni ewe Samol mi Lapalap.” ");
INSERT INTO chk_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Iwe, Moses me ewe souasor Eleasar ra angei seniir ekewe sokopaten fout seni kolt. ");
INSERT INTO chk_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Nge ekewe kolt meinisin ekewe meilap mi nemeni ekewe mwichen sounfiu ra eäni asor ngeni ewe Samol mi Lapalap ina epwe ükükün föpükü rüe paun. ");
INSERT INTO chk_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Nge ekewe sounfiu ra chök en me angei liapan fän püsin itan. ");
INSERT INTO chk_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Iwe, Moses me ewe souasor Eleasar ra angei ewe kolt seni ekewe meilapen sounfiu o iseis lon ewe imwenfel seni mangaku fän mesen ewe Samol mi Lapalap pwe eu pisekin achem fän iten ekewe aramasen Israel. ");
INSERT INTO chk_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Iwe, chon ekewe ainangen Rupen me Kat a wor chomong nöür pwiin kow. Iwe, ra küna pwe won ewe fanü Jaser pwal won ewe fanü Kiliat ra mürina le foleni kow. ");
INSERT INTO chk_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Iei mine chon ekewe ainangen Rupen me Kat ra feito o üreni Moses me ewe souasor Eleasar, pwal ekewe souemwenin ekewe aramas, ");
INSERT INTO chk_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ewe fanü ünükün Atarot, Tipon, Jaser, Nimra, Hespon, Eleale, Sepam, Nepo me Peon, ");
INSERT INTO chk_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ewe fanü ewe Samol mi Lapalap a akufu me fän mesen ekewe aramasen Israel, a mürina le foleni kow won. Iwe, äm noum chon angang a wor chomong nöüm kow. ");
INSERT INTO chk_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Kose mochen kopwe mwüt ngenikem ei fanü pwe aipwe fanüeni. Kosap nukikeemila pekilan ewe chanpupu Jortan.” ");
INSERT INTO chk_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Nge Moses a üreni chon ekewe ainangen Kat me Rupen, “Ifa usun, pwimi kewe repwe feila ngeni maun, nge ämi oupwe chök nonom ikei? ");
INSERT INTO chk_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Pwota oupwe atipetipa leluken ekewe aramasen Israel pwe resap feila pekilan ewe chanpupu Jortan o tolong lon ewe fanü ewe Samol mi Lapalap a ngeniir? ");
INSERT INTO chk_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Iei usun mine semelapemi kewe ra pwal föri, lupwen üa tinirela seni Kates-parnea pwe repwe operi ewe fanü. ");
INSERT INTO chk_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Iwe, ra feila tori ewe lemolun Eskol o küna ewe fanü, nge lupwen ra liwinto, ra atipetipa leluken ekewe aramasen Israel, pwe resap feila o tolong lon ewe fanü ewe Samol mi Lapalap a ngeniir. ");
INSERT INTO chk_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Iwe, lon ewe rän ewe Samol mi Lapalap a fokun song o pwon fän akapel, ");
INSERT INTO chk_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Ellet, esap wor eman me lein ekewe mwän seni ier rüe feitä mi towu seni Isip repwe küna ewe fanü üa pwon fän akapel pwe üpwe ngeni Apraham, Isaak me Jakop. Pun ir resap fokun aleasochis ngeniei. ");
INSERT INTO chk_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Chilon chök Kalep nöün Jefune we mwän ewe chon Kenis me Josua nöün Nun we mwän, pun ir ra fokun aleasochis ngeniei ngang ewe Samol mi Lapalap.’ ");
INSERT INTO chk_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Iwe, ewe Samol mi Lapalap a fokun song ngeni chon Israel o föri pwe repwe rikifetal lon ewe fanüapö lon ükükün faik ier, tori ra rosola ewe pilon aramas mi föföringau me fän mesen ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Nge iei ämi oua chök tolong lemürürün sememi kewe, ämi eu täppin aramas mi tipis. Oua chök alapala än ewe Samol mi Lapalap song mi pöchökül ngeni Israel. ");
INSERT INTO chk_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Pun are oua kul seni ämi aleasochis ngeni Kot, i epwe likitisefäliela ekei aramas lon ewe fanüapö. Ren ei ämi oupwe awarato feiengau wor.” ");
INSERT INTO chk_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Mürin, ra kanoto ren Moses o apasa, “Äm aipwe chök aüetä tittin sip ikei fän iten nöüm kewe pwiin sip pwal telinimw fän iten pwülüem me nöüm kewe semirit. ");
INSERT INTO chk_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Nge äm aipwe angei pisekin maun o feila mwen ekewe aramasen Israel tori aipwe emweniir ngeni lenier. Nge pwülüem me nöüm kewe semirit repwe nonom lon ekewe telinimw mi pöchökül tittir, pwe resap feiengau ren chon ei fanü. ");
INSERT INTO chk_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Äm aisap liwiniti imwem tori ekewe aramasen Israel repwe angei en me fanüan. ");
INSERT INTO chk_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Äm aisap angei och fanü seniir pekilan ewe chanpupu Jortan. Pun aia fen angei inetim fanü me ötiuen ei chanpupu Jortan.” ");
INSERT INTO chk_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mürin, Moses a üreniir, “Are oua wesewesen mochen föri iei usun, iei oupwe angei pisekin maun o feila maun fän emwenien ewe Samol mi Lapalap. ");
INSERT INTO chk_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Ämi mwän meinisin mi molotä ngeni maun oupwe feila pekilan ewe chanpupu Jortan fän emwenien ewe Samol mi Lapalap, tori i epwe asüela chon oputan me mwan. ");
INSERT INTO chk_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Mürin, ika ewe fanü a nom fän nemenian, ämi oupwe liwinla, pun oua apwönüetä mine oua pwon ngeni ewe Samol mi Lapalap me ekewe chon Israel. Mürin, ewe Samol mi Lapalap epwe alletätä pwe ei fanü mi nom ötiuen ewe chanpupu Jortan fanüemi. ");
INSERT INTO chk_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Nge are ousap apwönüetä ämi pwon, oua tipis ngeni ewe Samol mi Lapalap. Oupwe silei pwe liwinin ämi tipis epwe fokun torikemi. ");
INSERT INTO chk_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Iwe, oupwe aüetä telinimw fän iten pwülüemi me nöümi semirit me tit fän iten nöümi sip. Nge oupwe apwönüetä mine oua eäni pwon.” ");
INSERT INTO chk_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Iwe, chon ekewe ainangen Kat me Rupen ra üreni Moses, “Äm noum chon angang aipwe föri mine en äm samol ka eäni allük. ");
INSERT INTO chk_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nöüm semirit me pwülüem, pwal nöüm pwiin sip me kow meinisin repwe chök nonom lon ekewe telinimwen Kiliat. ");
INSERT INTO chk_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Nge äm meinisin aia molotä pwe aipwe feila pekilan ewe chanpupu Jortan o maun fän emwenien ewe Samol mi Lapalap, usun en äm samol ka allük.” ");
INSERT INTO chk_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Iwe, Moses a ngeni ewe souasor Eleasar me Josua nöün Nun we mwän, pwal ngeni mwänirelan ekewe familien ekewe ainangen Israel ei allük fän äsengesiir, ");
INSERT INTO chk_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Are ekewe mwän seni chon ekewe ainangen Kat me Rupen mi molotä ngeni maun repwe etikemi le feila pekilan ewe chanpupu Jortan fän emwenien ewe Samol mi Lapalap, nge ewe fanü epwe nom fän nemeniemi, mürin oupwe ngeniir ewe fanü Kiliat pwe repwe fanüeni. ");
INSERT INTO chk_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Nge are resap etikemi le feila maun pekila, repwe chök fafanü remi lon ewe fanü Kanaan.” ");
INSERT INTO chk_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Iwe, chon ekewe ainangen Kat me Rupen ra apasa, “Äm noum chon angang aipwe föri mine ewe Samol mi Lapalap a ürenikem. ");
INSERT INTO chk_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Äm aipwe feila pekilan ewe chanpupu Jortan o tolong lon ewe fanü Kanaan fän emwenien ewe Samol mi Lapalap pwe aipwe maun. Nge inetim fanü epwe chök nom rem ötiuen ewe chanpupu Jortan.” ");
INSERT INTO chk_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mürin, Moses a ngeni chon ekewe ainangen Kat me Rupen, pwal ngeni ewe esopun ewe ainangen Manasa nöün Josef we mwän ewe mwün Sihon ewe kingen chon Amor me ewe mwün Ok ewe kingen Pasan, unusen ewe fanü me telinimwan meinisin fiti ekewe leni ünükür. ");
INSERT INTO chk_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Iwe, chon ekewe ainangen Kat ra aüsefälietä ekewe telinimw Tipon, Atarot, Aroer, ");
INSERT INTO chk_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Arotsofan, Jaser, Jokpeha, ");
INSERT INTO chk_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Petnimra me Petharan. Iwe, ra aüetä tit ünükün ekewe telinimw, pwal tit fän iten nöür kewe sip. ");
INSERT INTO chk_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Iwe, chon ekewe ainangen Rupen ra aüsefälietä ekewe telinimw Hespon, Eleale, Kiriataim, ");
INSERT INTO chk_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nepo me Paalmeon, nge ra siwili iter. Ra pwal aüsefälietä Sipma. Iwe, ra aitasefäli ekewe telinimw ra aüsefäliretä. ");
INSERT INTO chk_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Iwe, ekewe mwirimwirin Makir, nge Makir nöün Manasa we mwän, ra feila Kiliat o liapeni, ra pwal asüela ekewe chon Amor mi nonom won. ");
INSERT INTO chk_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Iwe, Moses a ngeni ekewe mwirimwirin Makir ewe fanü Kiliat. Iwe, ra nonom lon. ");
INSERT INTO chk_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Nge Jair eman mwirimwirin Manasa a feila o liapeni wisoposopun ewe fanü Kiliat. Iwe, a aita ngeniir Hawot-jair. ");
INSERT INTO chk_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nge Nopa a feila o liapeni Kenat me wisoposopun kewe. Iwe, a aita ngeni Nopa püsin itan we. ");
INSERT INTO chk_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Iei tettelin än ekewe aramasen Israel sai, lupwen ra towu seni ewe fanü Isip lon ar kewe ainang fän emwenien Moses me Aaron. ");
INSERT INTO chk_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Iwe, Moses a makeetiu iteiten eu me eu kewe leni ra sai seni, usun ewe Samol mi Lapalap a allük ngeni. Iwe, iei tettelin ar sai seni eu leni tori pwal eu leni. ");
INSERT INTO chk_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Iwe, ekewe aramasen Israel ra sai seni Rameses lon engol me limuen ränin ewe aeuin maram, eu rän mürin ewe pasofer. Ra töpworawu me fän mesen ekewe chon Isip meinisin, ");
INSERT INTO chk_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","lupwen ra peiaseni nöür kewe mwänichi meinisin ewe Samol mi Lapalap a nirela me lefiler. Ren ei ewe Samol mi Lapalap a pwärätä pwe i a manaman seni ekewe koten Isip. ");
INSERT INTO chk_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Iwe, ekewe aramasen Israel ra sai seni Rameses o aüetä imwer lon Sukot. ");
INSERT INTO chk_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Ra pwal sai seni Sukot o aüetä imwer lon Etam mi nom lesopun ewe fanüapö. ");
INSERT INTO chk_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Iwe, ra sai seni Etam o liwiniti Pihahirot mi nom ötiuen Paal-sefon. Ra aüetä imwer arap ngeni Miktol. ");
INSERT INTO chk_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Mürin ra sai seni Pi-hahirot, ra pwerelong lukalapen ewe matau o feilong lon ewe fanüapö. Iwe, lupwen ra sai lon ewe fanüapön Etam lon ükükün ülüngat rän, ra tori Mara o aüetä imwer ikenan. ");
INSERT INTO chk_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Ra pwal sai seni Mara tori Elim o aüetä imwer, pun mi wor engol me ruu chönüttu me fik irä palm ikenan. ");
INSERT INTO chk_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Mürin ra sai seni Elim o aüetä imwer arun ewe Setipar. ");
INSERT INTO chk_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Iwe, ra sai seni ewe Setipar o aüetä imwer lon ewe fanüapön Sin. ");
INSERT INTO chk_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Mürin ra sai seni ewe fanüapön Sin o aüetä imwer lon Tofka. ");
INSERT INTO chk_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Iwe, ra sai seni Tofka o aüetä imwer lon Alus. ");
INSERT INTO chk_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Ra pwal sai seni Alus o aüetä imwer lon Refitim, ewe ia esap wor ie ünümen ekewe aramas koluk. ");
INSERT INTO chk_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Iwe, ra sai seni Refitim o aüetä imwer lon ewe fanüapön Sinai. ");
INSERT INTO chk_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Mürin ra sai seni ewe fanüapön Sinai o aüetä imwer lon Kiprotatawa. ");
INSERT INTO chk_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Ra pwal sai seni Kiprotatawa o aüetä imwer lon Haserot. ");
INSERT INTO chk_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Iwe, ra sai seni Haserot o aüetä imwer lon Ritma. ");
INSERT INTO chk_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ra pwal sai seni Ritma o aüetä imwer lon Rimon-peres. ");
INSERT INTO chk_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Mürin ra sai seni Rimon-peres o aüetä imwer lon Lipna. ");
INSERT INTO chk_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Ra pwal sai seni Lipna o aüetä imwer lon Risa. ");
INSERT INTO chk_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Iwe, ra sai seni Risa o aüetä imwer lon Kehelata. ");
INSERT INTO chk_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Mürin ra sai seni Kehelata o aüetä imwer fäsonun ewe chuk Sefer. ");
INSERT INTO chk_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Iwe, ra sai seni fäsonun ewe chuk Sefer o aüetä imwer lon Harata. ");
INSERT INTO chk_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Mürin ra sai seni Harata o aüetä imwer lon Makhelot. ");
INSERT INTO chk_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Ra pwal sai seni Makhelot o aüetä imwer lon Tahat. ");
INSERT INTO chk_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Mürin ra sai seni Tahat o aüetä imwer lon Tera. ");
INSERT INTO chk_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Iwe, ra sai seni Tera o aüetä imwer lon Mitka. ");
INSERT INTO chk_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mürin ra sai seni Mitka o aüetä imwer lon Hasmona. ");
INSERT INTO