﻿USE sofia;
DROP TABLE IF EXISTS sofia.chfNT_vpl;
CREATE TABLE chfNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES chfNT_vpl WRITE;
INSERT INTO chfNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jinda ni jun bajca tz'ibi cua'tac u c'aba' u natil noxi'papob aj Jesucristo. Untu de unejobba aj David u c'aba' y otro untuba aj Abraham. ");
INSERT INTO chfNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","U pap aj Isaacba, aj Abraham. U pap aj Jacobba, aj Isaac. U pap aj Judá con to'o u säcunob y u jitz'inobba, aj Jacob. ");
INSERT INTO chfNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","U pap aj Fares y aj Zaraba, aj Judá. U na'ob ni cha'tujob jiniba ix Tamar. U pap aj Esromba, aj Fares. U pap aj Aramba, aj Esrom. ");
INSERT INTO chfNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","U pap aj Aminadabba, aj Aram. U pap aj Naasónba, aj Aminadab. U pap aj Salmónba, aj Naasón. ");
INSERT INTO chfNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","U pap aj Boozba, aj Salmón. U na' aj Boozba ix Rahab. U pap aj Obedba, aj Booz. U na' aj Obedba ix Rut une. U pap aj Isaíba, aj Obed. ");
INSERT INTO chfNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","U pap aj Davidba, aj Isaí. Jini aj David que cäli najtäcäba, ni ochi de rey tuba aj Israelobba. U pap aj Salomónba, jini rey aj David. U na' aj Salomónba, jini ixic que ajni de jit'oc aj Uríasba. ");
INSERT INTO chfNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","U pap aj Roboamba, aj Salomón. U pap aj Abíasba, aj Roboam. U pap aj Asaba, aj Abías. ");
INSERT INTO chfNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","U pap aj Josafatba, aj Asa. U pap aj Joramba aj Josafat. U pap aj Uzíasba, aj Joram. ");
INSERT INTO chfNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","U pap aj Jotamba, aj Uzías. U pap aj Acazba, aj Jotam. U pap aj Ezequíasba, aj Acaz. ");
INSERT INTO chfNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","U pap aj Manasésba, aj Ezequías. U pap aj Amónba, aj Manasés. U pap aj Josíasba, aj Amón. ");
INSERT INTO chfNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","U pap aj Jeconías y u jitz'inobba, aj Josías. Jimba q'uinob jiniba ni aj Israelob laj bisintijob preso tä noj cab tä Babilonia. ");
INSERT INTO chfNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Najtäcä laj bisintijob tä Babilonia, y de ya'i päncäbi aj Salatiel. U pap uneba, aj Jeconías. U pap aj Zorobabelba, aj Salatiel. ");
INSERT INTO chfNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","U pap aj Abiudba, aj Zorobabel. U pap aj Eliaquimba, aj Abiud. U pap aj Azorba, aj Eliaquim. ");
INSERT INTO chfNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","U pap aj Sadocba, aj Azor. U pap aj Aquimba, aj Sadoc. U pap aj Eliudba, aj Aquim. ");
INSERT INTO chfNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","U pap aj Eleazarba, aj Eliud. U pap aj Matánba, aj Eleazar. U pap aj Jacobba, aj Matán. ");
INSERT INTO chfNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","U pap aj Joséba, aj Jacob, y u jit'oc aj Joséba, ix María. Jin ni ix María u päncäbesi aj Jesúsba, ni u yälbinte täcä cache' aj Cristoba. Jini t'an Cristoba u yäle' cache' Dios u yaqui. ");
INSERT INTO chfNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ca' jini ajni upete u natil noxi'papob aj Cristo. Desde aj Abraham ixta aj Davidba, catorce une. Desde aj David ixta jinq'uin bisinti upete ni gente tä Babilonia, catorce täcä. Desde jinq'uin bisinti ni gente tä Babilonia ixta que päncäbi aj Cristo, catorce chich täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jinq'uin päncäbi aj Jesucristo, u chi pasa ca'da: Ix María, jini u na' aj Jesucristoba, ya' c'ätä an uc'a aj José tuba lotojac t'oc. Jinq'uin mach to u bisaba, u chäni cache' c'ojo t'oc u bijch'oc. Ni Ch'u'ul Pixan u yäc'bi u mätan u tz'isa. ");
INSERT INTO chfNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aj José, jini u xe u ch'e' tuba jit'ocba, untu winic tu toja u chen une. Mach u yoli u yäq'ue' tä tze'tinte ix María, jin uc'a u yoli u mucul waläctan. ");
INSERT INTO chfNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mu'to u ch'e' u c'ajalin tuba u chen ca' jini, tajtzäc u chäni tan u naja untu ángelo ta Dios u yälben ca'da: ―José, ajlo'et taj David, mach a wäle' que mach uxet a ch'e' ix María tuba a wit'oc. Ni u tz'isa u mätiba, tuba Ch'u'ul Pixan une. ");
INSERT INTO chfNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U xe u päncäbesan untu u yajlo'. A xe a'ben u c'aba' aj Jesús, uc'a une u xe u japän t'oc u tanä upete machcatac tuba uneba. ");
INSERT INTO chfNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Upete ni jini u chi pasa uc'a pasic toj jini u yäc'bi Dios u yäle' u yajt'an oniba, jinq'uin u yäli ca'daba: ");
INSERT INTO chfNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ubixtola: Untu telom u xe u mätan u tz'isa, y u xe u päncäbesan untu u yajlo', y u xe tä äc'binte u c'aba' aj Emanuel. Jini t'an Emanuelba u yäle' ca'da une: Dios ya'an t'oc no'onla. ");
INSERT INTO chfNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cuanta p'ixi aj José bajca an tä wäye, u chi ca' chich u yälbi ni ángelo ta Dios u chen. U bisi chich ix María tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero mach u chi vida t'oc ni unnum ca' jit'oc ixta que u päncäbesi jini u yäxch'oc. U yäc'bi chich u c'aba' aj Jesús u yäxch'oc ix María. ");
INSERT INTO chfNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aj Jesús päncäbi tä Belén tama ni cab tä Judea jinq'uin aj Herodes ni rey tama ni cab jini. Jinchichba q'uinob jini c'otijob tä Jerusalén ni winicob que u c'ac'a' cänijob cache'da an ajlucerojob. U cab unejobba tä weti q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","U c'atänob ca'da: ―¿Cada an jini rey tuba aj judíosob, jini apäncäbiba? Uc'a jinq'uin ya'to anon täj cab t'ocob acä chäni t'ocob jini ajlucero que u ye'e' cache' apäncäbiba. Jin uc'a aton cä sacän t'ocob tuba cä ch'u'ul c'ajti'in t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jinq'uin u yubi ni rey aj Herodes cua' u yäle'ob ni winicob jini, u c'ac'a' jobi uba u c'ajalin, y che' chich täcä upete aj Jerusalénob. ");
INSERT INTO chfNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","De ya'i aj Herodes u yäq'ui tä jo'can upete u yajnojajob pale taj judíosob y machcatac u ye'e' ni ley taj Moisés tuba u c'atbenob cada u xe tä päncäban jini aj Cristo. ");
INSERT INTO chfNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Unejob u p'albi ca'da: ―Ya' u xe tä päncäban tä Belén tama cab tä Judea, uc'a che' chich tz'ibi an uc'a ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ni tz'ibiba u yäle' ca'da: Anela tä Belén, tama ni cab tä Judá, a cäjila más utz une que otros nuc cajob tama ni cab tä Judá, uc'a ya'i u xe tä ch'oye untu ajnoja tuba u chen manda cä gente aj Israelob. ");
INSERT INTO chfNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","De ya'i aj Herodes u yäq'ui tä jo'can sec' u bajnimajob jini winicob que u c'ac'a' cänijob cache'da ayan ni ajlucerojob. U c'alin c'atbijob caxca mero q'uin u chänijob que pasi tä cielo jini ajlucero. ");
INSERT INTO chfNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cuanta u yubi aj Herodes ca' jini, u täsqui bixicob tä Belén. U yälbijob ca'da: ―Corre cuxla tä Belén y sacänla jini ch'oc ixta que mach a pojlenla. Cuanta pojlilaba, tiquet a wälbenonla uc'a xicon no'on täcä cä ch'u'ul c'ajti'in. ");
INSERT INTO chfNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cuanta u yubijob ni t'an que u yälbijob aj Herodesba, pasi y bixijob. Jini ajlucero que u chänijob tu cab tä weti q'uinba, sujli u chänenob cha'num, y u chi xämba ixta que c'oti tä wa'tä tu pat jini otot bajca an ni ch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jinq'uin u chänijob cha'num jini ajluceroba, c'ac'a' ch'a'ali ujinob. ");
INSERT INTO chfNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ochijob tama ni otot jini, y u chänijob que ya'an ni ch'oc tu c'äb u na', jini u c'aba' ix Maríaba. Cuanta u chänijobba, nocwänijob u ch'u'ul c'ajti'in ni ch'oc. U jäbijob bajca u ch'ujnan cua' chichca que u bisanobba, y u pa'sijob ni matän tä' chojba que u xe u yäc'benobba. U yäc'bijob oro, pom, y jätz'äcnib u c'aba' mirraba. ");
INSERT INTO chfNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ni winicob jini älbintijob tan u naja que mach ni' sujlec bajca an aj Herodes. Jin uc'a tu sujtäjob tu cäjiba, u ch'ijob otro bij uc'a mach numic bajca an aj Herodes. ");
INSERT INTO chfNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cuanta bixijob ni winicob jini, untu ajc'äncan ta Dios c'oti bajca an aj José tä wäye, u yälben tan u naja ca'da: ―Ch'oyen, ch'ä ni ch'oc, y u na'. Correla tä Egipto tä putz'e y ajniquetla ya'i ixta que mach cälbenetla caq'uin a xe tä sujtäla. Aj Herodesba u xe u sacän ni ch'oc tuba u tzämsen. ");
INSERT INTO chfNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jinchichba rato p'ixi aj José y ch'oyi. Ac'äb to u ch'i ni ch'oc y u na', y pasi t'oc ya'i bixijob tä Egipto. ");
INSERT INTO chfNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jäläcnijob tä Egipto ixta que chämi aj Herodes. Ca' jini pasi toj jini u yäc'bi Cajnojala Dios u yäle' u yajt'an oniba, ni u yäle' ca'daba: “Cä täsqui tä jo'can Cajlo' bajca an tä Egipto”. ");
INSERT INTO chfNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aj Herodes c'ac'a' cäräx'i uc'a ni winicob jini mach sutwänijob u yälben si u pojli chich ni ch'oc. De ya'i aj Herodes u täsqui tä laj tzämsinte upete bijch'oc ajlo'ilbaba, jini u cänäntan chap'e añoba ixta jini mu'to u päncäbanba tama ni caj tä Belén ixta tu xupiba otote. Aj Herodes u chi ca' jini uc'a lo que u yälbijob jini winicob jini, uc'a anumi ca' tuba chap'e año desde jinq'uin u chänijob ni ajlucero. ");
INSERT INTO chfNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ca' jini pasi toj jini u yäli aj Jeremías ajt'an ta Dios oniba, ");
INSERT INTO chfNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ni u yäli ca'daba: Ubqui noj uq'ue tä Ramá. U natil ch'ocob ix Raquel u yuc'tan u ch'ocob. Mach yo ch'a'alesbintic ujinob uc'a laj chämijob u ch'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","De ya'i cuanta chämi aj Herodes, c'oti untu ajc'äncan ta Dios u pecän aj José tan u naja bajca an tä Egipto. ");
INSERT INTO chfNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","U yälbi ca'da: ―Ch'oyen, ch'ä ni ch'oc y u na' y suti'la tama ni cab taj Israelob, uc'a laj chämijob bada jini u yoli u tzämsen ni ch'ocba. ");
INSERT INTO chfNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ch'oyi chich aj José ca' chich älbinti, u ch'i ni ch'oc y u na', pasijob ya'i tuba xicob tama ni cab taj Israelob. ");
INSERT INTO chfNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jinq'uin u yubi aj José cache' aj Arquelao ochi de ajnoja tama ni cab tä Judea uc'a chämi aj Herodes u pap chich aj Arquelaoba, bäc'ti xic ya'i. Aj José älbinti tan u naja que bixic tama ni cab tä Galilea. Che' chich u chi. ");
INSERT INTO chfNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jinq'uin c'otijob ya'i, bixijob tama ump'e yoc caj u c'aba' Nazaret. Ya' chich colijob ya'i. Ca' jini pasi toj ca' chich u yäli ajt'anob ta Dios oniba cache' jini ch'oc aj Jesús u xe tä älbinte cache' u c'aba' aj nazareno täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jimba q'uinob jini, c'oti aj Juan ajc'ablesiaba u ye'e' u t'an Dios ya'i bajca mach cuxu niuntu, tama ni noj cab tä Judea. ");
INSERT INTO chfNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","U yäle' ca'da: ―Q'uexe a c'ajalinla tuba mach a ni' chen a tanäla, uc'a mach ni' q'uen yo tuba u nonoj chen manda bajca anetla ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jimba aj Juanda ni u yäli aj Isaías ajt'an ta Dios oni que u xe tä te, jinq'uin u yäli ca'daba: Ca'da u yäle' jini u chen muc' t'an bajca mach cuxu niuntuba: “Tusbenla u biji Ajnoja. To'esbenla upete u biji”. ");
INSERT INTO chfNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aj Juanba xojo uc'a u buc de u tzutze ajcamello. U cächi' näc'ba de pächi une. Cua' u c'uxe'ba, ajsäp' y te'el chab. ");
INSERT INTO chfNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Laj c'otijob bajca an aj Juan aj Jerusalénob, y upete aj Judeajob, y upete ajcabil cab jini que ya' cuxujob tu junxoyma río Jordán. ");
INSERT INTO chfNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","C'otijob u laj äle' u tanäjob, y aj Juan u c'ablesanob tu ti' río Jordán. ");
INSERT INTO chfNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jinq'uin u chäni aj Juan cache' q'uen aj fariseojob y aj saduceojob, jini ajt'äbälajob tuba aj judíosobba, u c'ote bajca an une tuba c'ablacob u yälbijob ca'da: ―¡Anela malojetla ca' a wälä u ch'ocobetla chan! ¿Caxca u yälbetla cache' c'änä a putz'tanla ni castigo que u xe u yäq'ue' Dios ji'patba? ");
INSERT INTO chfNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chenla jiq'uin tu toja uc'a chectac cache' a totoj q'uexi a c'ajalinla. ");
INSERT INTO chfNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mach a wäle'la tan a c'ajalinla ca'da: “Cä xe cä japän cäba t'ocob t'oc ni castigo que u yäq'ue' Dios uc'a aj Abraham cä natil noxi'pap t'ocob”. Uc'a cälbenetla que u chen chich trebe Dios u yäc'ben ni ji'tunobda sujlec täcä de u ch'ocob aj Abraham. ");
INSERT INTO chfNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A wila chich cache' upete ni te' que mach u che u jut utzba u laj tzepcan y u julcan tan c'ac'. Che' chich anela täcä a xe tä äc'binte a castigola si mach a q'uexe a c'ajalinla tuba mach a ni' chen a tanäla. Es ca' a wälä ya' chich an ni hacha tu wi' ni te' tuba u jule' tä cab. ");
INSERT INTO chfNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","No'onba, toj chich cache' cä c'ablesanetla t'oc ja' tuba chectac cache' a q'uexi a c'ajalinla. Jini u te ji'pat que no'onba, más q'uen u poder une que no'on. No'on mach jin niump'e cua'on tuba cä pochben u pächi'oc. Une ni u xe u c'ablesanetla t'oc Ch'u'ul Pixan y t'oc c'ac'. ");
INSERT INTO chfNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ca' a wälä ya' chich an tu c'äb ni u sisi' jut päc'äbi. U xe chich u laj sisän u jut ni päc'äbi. U xe u ch'ujnan ni u jut päc'äbi bajca an u ch'ujliba. U p'osiba u xe u jule' tama jini c'ac' que mach bay uxin tä täpoba. Ca' jini u xe u chen t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jinq'uin aj Jesús ya' ti tama cab tä Galilea c'oti bajca an aj Juan tä Jordán. C'oti tuba c'ablescac. ");
INSERT INTO chfNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aj Juan mach u yoli u c'ablesan. U yälbi aj Jesús ca'da: ―No'on une ni c'änä a c'ablesanon aneba. ¿Pero aneba a wäle' que cä c'ablesanet? ");
INSERT INTO chfNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aj Jesúsba u p'albi ca'da: ―Äctan c'ablacon bada, uc'a c'änä chich cä chenla upete lo que Dios yo utic. De ya'i mach u ni' äli cua' aj Juan. U c'ablesi chich. ");
INSERT INTO chfNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cuanta c'abli aj Jesús, seb pasi tan ja' t'äbi tä cab. Jinchichba rato jini u jäbi uba cielo. U chäni ni Ch'u'ul Pixan ta Dios, ti tä cielo ca' untu ixsäcpäcä, jaqui tan u pam. ");
INSERT INTO chfNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","De ya'i ubqui ump'e t'an que ya' ti tä cielo, que u yäle' ca'da: ―Jinda une ni cä yajben Ajlo'. Tä' u ch'a'alesan cäjin. ");
INSERT INTO chfNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","De ya'i ni Ch'u'ul Pixan u bisi aj Jesús bajca mach cuxu niuntu uc'a ya'i u xe tä c'ote diablo tuba u jiran si u yäc'ben u säte' t'oc Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ya' jini ajni cuarenta día y cuarenta ac'äb sin que c'uxnac, de ya'i u q'uechi jitz'o. ");
INSERT INTO chfNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","C'oti bajca an aj Jesús jini machca u yoli u yäc'ben u säte' t'oc Diosba, u yälben ca'da: ―Si totoj u yajlo'et Dios, älben ni ji'tunobda que sujlec de waj. ");
INSERT INTO chfNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aj Jesús u p'ali, u yäli ca'da: ―Tz'ibi chich ayan ca'da: “Mach sec' t'oc waj u ch'e' cuxlec a'ajtäjob pancab. C'änä chich täcä upete u t'an Dios”. ");
INSERT INTO chfNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","De ya'i ni diablo u bisi tama jini ch'u'ul caj tä Jerusalén, u yäc'bi wa'lec tu ni' ni torres ta ni mero noj ch'uj taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","U yälbi ca'da: ―Si totoj u yajlo'et Diosba, julu aba tä cab. Uc'a tz'ibi chich ayan ca'da: U xe u yäc'ben u ángelojob u cänäntanet. T'oc u c'äb u xe u ch'uye'et uc'a mach a jätz'e' a woc t'oc ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aj Jesús u yälbi ca'da: ―Tz'ibi chich ayan täcä ca'da: “Mach a päpä' sacän cache' a wäc'ben u chen cua' chichca a Wajnoja Dios tuba a chänen si u chen”. ");
INSERT INTO chfNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","De ya'i u bisi tu pam ump'e noj tz'ic tä' isquiba. U ye'bi upete ni cajob pancab y u pitzilan ni cajob jini. ");
INSERT INTO chfNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","U yälbi ca'da: ―Upete ni jini que mu' a chänenba cä xe cä'benet ta' c'äb tuba a chen manda si a noctä täc pänte' a ch'u'ul c'ajti'inon. ");
INSERT INTO chfNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aj Jesús u yälbi: ―Tz'eje aba t'oc no'on, Satanás, uc'a tz'ibi chich ayan que u yäle' ca'da: “A Wajnoja Dios a xe a ch'u'ul c'ajti'in. Sec' une a xe a tz'omben y a cherben u patan”. ");
INSERT INTO chfNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jinchichba rato jini, u tz'eji uba ni diablo bajca an. De ya'i c'oti ni ángelojob ta Dios bajca an aj Jesús u täclen t'oc cua' chichca que c'änä uc'a. ");
INSERT INTO chfNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jinq'uin aj Jesús u yubi cache' aj Juan amäjqui presoba, sutwäni tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mach coli tä Nazaret. Bixi tä Capernaum. Ya' jini coli tama jini caj ti' nabba, tama u cabob aj Zabulónob y aj Neftalíjob. ");
INSERT INTO chfNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ca' jini pasi toj jini u yäli aj Isaías, ajt'an ta Dios oniba, jinq'uin u yäli cache'da ayan jini que mach jin aj judíosobba. U yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","U cab aj Zabulónob y u cab aj Neftalíjob nätz'ä ti' nab, tunxe río Jordán, tama noj cab tä Galilea, bajca cuxujob q'uen aj gentilob. ");
INSERT INTO chfNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jini a'ajtäjob ya'i ca' a wälä ya'anob tan it'obni, pero u xe u chänenob ca' a wälä ump'e noj junch'äcni. Machcatac ya'anob bajca an chämo, ca' a wälä ump'e noj junch'äcni u xe tä ch'oye bajca anob. ");
INSERT INTO chfNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jinchichba q'uinob jini u täq'ui aj Jesús u ye'e' u t'an Dios, y u yäle' ca'da: ―Q'uexe a c'ajalinla tuba mach a ni' chen a tanäla, uc'a mach ni' q'uen yo tuba u nonoj chen manda bajca anetla ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nume u chen aj Jesús ti' nab tä Galilea, u chäni cha'tu winic, que tontu u papob. Untu u c'aba' aj Simón, jini älbinti ji'pat cache' aj Pedroba. Ni otro untuba u c'aba' aj Andrés. Ya'an u jule'ob noj chim ta q'uechi' buch' tama ni nab, uc'a unejobba ajq'uech buch'ob une. ");
INSERT INTO chfNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aj Jesús u yälbijob: ―La'ixla tzäypätinon, y no'on cä xe cä'benet a patanla a sacänla machcatac u xe u tz'ombenon. ");
INSERT INTO chfNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jinchichba rato jini, u yäcti u chimob y u tzäypätijob. ");
INSERT INTO chfNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Más pänte' u chäni otros cha'tu winic, aj Jacobo y aj Juan u jitz'inba. Jindajobba u ch'ocob aj Zebedeo. Ya'anob tama noj jucub nämte' t'oc aj Zebedeo, u papob chichba. Mu' u tzutzänob ni noj chim ta q'uechi' buch'. Aj Jesús u joq'uijob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Unejobba jinchichba rato u yäctijob ni jucub y u papob, y u tzäypätijob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Aj Jesús numi cachichcada tama entero ump'e ni cab tä Galilea. U ye'e' u t'an Dios bajca u woylan uba aj judíosob ya'i. U yälbenob jini t'an utz tuba Dios cache' Dios u xe u chen manda bajca anob. U tz'äcälin upete yaj y upete c'uxtäcle machcatac u cänäntanob. ");
INSERT INTO chfNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ixta upete aj Siriajob täcä u yubijob cua'tac u chi aj Jesús. U c'osijob bajca an aj Jesús upete ajc'ojpanob, y upete machcatac mu' u tz'ibajtesan cua' chichca yaj, jini tä' c'ojojobba, jini t'oc tzuc pixan tuyac'ojobba, jini u säto u c'ajalin cada ujba, jini chämen u c'äb y chämen yocob que mach u ch'ä u chen xämbaba. Aj Jesús u laj tz'äcäli. ");
INSERT INTO chfNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","U tzäypätijob q'uen machcatac cuxujob tama noj cab tä Galilea, tama ni cajob tä Decápolis, tama ni caj tä Jerusalén, y tama noj cab tä Judea, y machcatac cuxujob täcä tunxe päta' Jordán. ");
INSERT INTO chfNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jinq'uin aj Jesús u chäni cache' q'uen gente u te tu pat, t'äbi tu pam ump'e noj tz'ic tä chumtä. De ya'i u yajcänt'anob c'oti u natz'änob bajca chumca. ");
INSERT INTO chfNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aj Jesús u täq'ui u ye'benob u t'an Dios, u yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ayan ump'e u ch'a'aljinob machcatac yuwi tan u pixan cache' mach u che vale cua' tu jut Dios, uc'a tubajob chich bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ayan ump'e u ch'a'aljin machcatac u chen uq'ue, uc'a unejobba Dios u xe u yäc'ben jini u ch'a'aljinob. ");
INSERT INTO chfNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ayan ump'e u ch'a'aljinob machcatac sis u c'ajalinobba, uc'a unejob u xe tä äc'binte ni cab que Dios u yäli u xe u yäc'benobba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ayan ump'e u ch'a'aljinob machcatac tä' yojob u chenob tu toja, ca' a wälä tä' jitz' y tä' tiquin u ti'ob, uc'a Dios u xe chich u c'ac'a' äc'ben u chenob tu toja ca' chich yo u chenobba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ayan ump'e u ch'a'aljinob machcatac u ch'ämben yajin u lot, uc'a Dios täcä u xe chich u c'ac'a' ch'ämbenob yajin. ");
INSERT INTO chfNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ayan ump'e u ch'a'aljinob machcatac poco an u pixan, uc'a unejob une u xe u chänen Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ayan ump'e u ch'a'aljinob machcatac u yäc'ben u lot ajnic sis u c'ajalin, uc'a Dios u xe u yälbenob cache' u ch'ocob chich. ");
INSERT INTO chfNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ayan ump'e u ch'a'aljinob machcatac u tz'ibajtescan uc'a u chen tu toja, uc'a tubajob chich bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ayan ump'e a ch'a'aljinla jinq'uin a lotla u cäräx älbenetla uc'a a tz'ombenonla cä t'an. Ayan a ch'a'aljinla jinq'uin u tz'ibajtesanetla y u chenob jop'ojti' u yäle'ob que a chenla cua' chichca mach utz. ");
INSERT INTO chfNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ajnic a ch'a'aljinla y tä' ch'a'alac ajinla jinq'uin a cherbintela ca' jini, uc'a tä' utz ni a matänla que a xe tä äc'bintela tä cieloba. Ca' chich jini täcä u tz'ibajtesijob ajt'anob ta Dios jini ajnijob oniba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Anelaba ca' atz'ametla pancab. Atz'am u yäq'ue' mach sätic we'e. Anelaba ca' atz'ametla uc'a mach säticob gente pancab. Si ni atz'am sätic u ch'och'an, ¿cua' t'oc u ch'och'escan cua' chichca? Mach ni' utz tuba niump'e cua' une. U chojcan päti tuba xac'äjte'cac. ");
INSERT INTO chfNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Anelaba ca' a wälä ni junch'äcniletla tuba u pancab. Ump'e caj ajnic tu pam ump'e noj tz'ic isquiba, mach u ch'ä ajnic mucu. ");
INSERT INTO chfNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mach u tz'äbca täcä ump'e candil tuba äc'cac tu yaba p'et. U yäc'can tu chumliba tuba u chictan upete machcatac an tan otot. ");
INSERT INTO chfNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ca' jini täcä mach a muque'la ni a tz'onänlaba. C'änä u chictan ni junch'äcni ya'an ta'wac'olaba, uc'a u chänen otrosjob cache' a chenla tu toja. Ca' jini u xe chich u ch'u'ul c'ajti'inob ni cä Papla ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Mach a wäle'la que aton tuba cäq'ue' mach ni' tz'onintic ni ley taj Moisés y ni u tz'ibijob ajt'anob ta Diosba. Mach jin tuba aton. Aton tuba cä ye'benetla cache' a chenla upete tu toja ca' chich u yäle' ni ley. ");
INSERT INTO chfNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Totojtoj cälbenetla, ya'to ajnic cielo y u pancabba, mach uxin tä colescan niump'e letra y niump'e punto tuba ni ley sin que mach laj utic ca' chich u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Machca chichca jiq'uin que u yäctan tz'ita' ni manda jini que mach u laj tz'onä y si u ye'ben otrosjob u chen ca' jini täcä, u xe tä älbinte cache' más ajch'och'oca bajca u chen manda ni Dios ya'an tä cieloba. Machca chichca u tz'onän chich upete ni ley y che' chich u ye'ben otrosjob täcä, ni jiniba u xe tä älbinte cache' más ajnoja que u lotob bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cälbenetla jiq'uin, si mach ajniquetla más tu toja que jini tä' yuwijob ni ley y jini aj fariseojob, mach uxet tä ochela bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’A'utet a ubinla cache' älbinti machcatac cuxlijob oni ca'da: “Mach a chen tzämsala. Machca chichca que u chen tzämsa, u xe tä äc'binte u toje' u tanä”. ");
INSERT INTO chfNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ni cälbenet no'onba, jinda une: Machca chichca u cäräx'an t'oc u lot, u xe tä äc'binte u toje' u tanä. Machca chichca u yälben u lot cache' ajsen u xe tä päycanob tu pänte' ajt'äbälajob tuba caj. Machca chichca u yälben u lot cache' choco an, u xe tä julcan tama noj c'ac' tä infierno. ");
INSERT INTO chfNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Jin uc'a si a täsben u matän Dios tuba a subben tu pänte' uneba, y tic ta' c'ajalin cache' cäräx untu a lot t'oc ane, ");
INSERT INTO chfNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","äctan jini matän ya'i, y xiquet a wiran cache' u ch'e' a sis'esben u c'ajalin jini a lot t'oc ane. De ya'i, cuanta asis'i u c'ajalin t'oc aneba, suti' subben jini u matän Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Iran cache' u ch'e' a sis'esben u c'ajalin machca cäräx t'oc aneba, jinq'uin mu'to a bixe t'oc tä juez, mach me'ixto jini cäräx t'oc aneba u yäq'ue'et tu c'äb juez, y juez u yäq'ue'et tu c'äb ajcänäncárcejob, y ni jinijob u yäq'ue'et tama cárcel. ");
INSERT INTO chfNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Totojtoj cälbenet que mach uxet tä pase ya'i ixta que mach a laj toje' ni multa que a'binte a toje'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’A'utet a ubinla cache' älbintijob oni täcä ca'da: “Mach a chen a tanäla t'oc cherajtz'ijte'”. ");
INSERT INTO chfNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ni cälbenet no'onba, jinda une: Machca chichca u chänen untu ixic y u c'upän, san chich u chi ni tanä jini de cherajtz'ijte' tan u pixan. ");
INSERT INTO chfNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Jin uc'a jiq'uin, si a jut ta' nojba u yäc'benet a chen a tanä, pa'sen y choco. Más utz a säte' unxim a jut, y mach julcaquet entero untu tama noj c'ac' tä infierno. ");
INSERT INTO chfNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Si a c'äb ta' nojba u yäc'benet a chen a tanä, chunjätz'ä y choco. Más utz a säte' untz'it a c'äb y mach julcaquet entero untu tama noj ticäw c'ac' tä infierno. ");
INSERT INTO chfNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Älbintijob oni täcä ca'da: “Machca chichca u waläctan jit'oc, c'änä u yäc'ben ump'e jun bajca u yäle' que mach ni' jin jit'oc”. ");
INSERT INTO chfNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ni cälbenet no'onba, jinda une: Machca chichca que u waläctan jit'oc y mach uc'a jini tanä de cherajtz'ijte'ba, ca' jini une chich u xe u yäc'ben u chen jini tanä de cherajtz'ijte' si lotojac tä cha'num. Machca chichca que u lotojan t'oc jini ixic que waläctintiba, u chen täcä u tanä de cherajtz'ijte'. ");
INSERT INTO chfNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’A'utet a ubinla täcä cache' älbintijob machca cuxlijob oni ca'da: “Mach a wäle' tu jut Dios cache' a xe a chen cua' chichca y de ya'i mach a che. C'änä chich a chen ca' chich a wäli a xe a chen jinq'uin a c'ajti'bi u c'aba' Dios tuba tz'ombintiquet a t'an”. ");
INSERT INTO chfNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ni cälbenetla no'onba, jinda une: Mach a c'ajti'ben u c'aba' Dios jinq'uin a wäle' a chen cua' chichca jini tuba tz'onintic cache' toj a t'an. Mach a c'ajti'in niump'e cua' täcä tuba tz'onintic a t'an. Mach a c'ajti'in cielo, uc'a jin u yajlib une ni Cajnojala Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mach a c'ajti'in u pancab, uc'a jin ca' a wälä u läclib yoc une. Mach a c'ajti'in Jerusalén, uc'a jin ni noj caj tuba ni mero Rey. ");
INSERT INTO chfNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mach a c'ajti'in a pam täcä tuba tz'onintic a t'an, uc'a ane mach a che trebe a wäc'ben sujlec säc ni ic' niuntz'it a tzuc. ");
INSERT INTO chfNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","C'änä ajnic tomp'e a t'anla ca'da: “toj” si toj chich; “mach” si mach toj. Uc'a si a c'ajti'in cua' chichca másba tuba tz'onintic a t'an, mach utz une. ");
INSERT INTO chfNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’A'utet a ubinla cache' älbintijob oni täcä ca'da: “Machca u pa'säben u jut u lot, c'änä pa'säbintic u jut täcä. Machca u quecben yej u lot, c'änä quecbintic tuba täcä”. ");
INSERT INTO chfNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ni cälbenetla no'onba, jinda une: Mach a sutatz'ben u jelo cua' chichca mach utz a cherbinte. Si untu u cune' a choj, tax u cune'et cha'num, sin que a t'äbsen aba ane. ");
INSERT INTO chfNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Si untu yo u päye'et tä juez tuba u jajbenet a buc, äc'ben u ch'e' täcä a noj jeli' sisi. ");
INSERT INTO chfNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Si untu u cocoj äc'benet a bisben u cuch ump'e legua u nät'an, nonoj bisben chap'e legua u nät'an. ");
INSERT INTO chfNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Machca u c'atbenet cua' chichca, äc'ben. Machca u c'atbenet q'uex cua' chichca, mach a wäle' que mach a wäc'be. ");
INSERT INTO chfNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’A'utet a ubinla cache' älbintijob oni ca'da: “Yajna'tan a lot y cräxna'tan machca mach yo u chänenet”. ");
INSERT INTO chfNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ni cälbenetla no'onba, jinda une: Yajna'tanla machcatac mach yo u chänenetla y chenla tu toja t'oc unejob. C'atben Dios que u ch'u'ul chenob machcatac u cäräx älbenetla. Chen c'änti'yala tuba a c'atbenla Dios que u yäc'ben u yutzi jini machca u xiq'ue'etla y u tz'ibajtesanetlaba. ");
INSERT INTO chfNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Si a chenla ca' jiniba, u xe chich tä chectan cache' mero u ch'ocobetla ni cä Papla ya'an tä cieloba, jini u yäq'ue' pasic q'uin tuba u chictan machcatac mach u che utz y machcatac u chen utz. U yäq'ue' u yäc'ben ja' bajca ayan machcatac ayan tu toja y machcatac mach'an tu toja. ");
INSERT INTO chfNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Uc'a si a yajna'tan sec' machca u yajna'tanet namásba, ¿u xe quira u yäc'benet a matän Dios uc'a a chi ca' jini? Mach une. Ixta ajcojtaq'uinob täcä, ni mäx malojobba, ca' jini u chenob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Si a wäc'ben u c'aba' Dios sec' jini machca a bisan bij t'oc, mach'an niump'e cua' a chenla jiq'uin que otrosjob mach bay u chejob. Uc'a ixta ni gente que mach u totoj ch'u'ul c'ajti'i Diosba che' chich u chenob ca' jini täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","C'alin chenla tu toja jiq'uin, ca' chich u chen tu toja cä Papla ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Iranla jiq'uin que mach a chenla tu toja sec' tuba u chänenob a lotob pancab cache' tu toja mu' a chen. Si a chenla sec' tuba u chänen a lotobba, mach uxin u yäc'benetla niump'e a matän cä Papla ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jinq'uin a wäc'ben u matän pobrejilba, mach a wäq'ue' tä ustinte trompeta tuba wina'tintic cua' mu' a chen, ca' u chenob ni ajsusuccheriajob tan ch'uj y tä calle. U chenob ni jiniba tuba älbinticob cache' tu toja chich u chenob. Totojtoj cälbenetla, jin chich ni fama que u yäc'binteba, jin chich une u jelo ni mu' u chenobba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aneba, jinq'uin a wäc'ben u matän pobrejilba, mach a wäc'ben yuwina'tan niuntu cua' mu' a chen ni machca an ta' tz'ej ni machca an ta' noj. ");
INSERT INTO chfNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jini a sijänba, mucu a chen une. A Papla que ya'an tä cielo, jini u chänen cua' chichca mucuba, une chich u xe u yäc'benetla a matän uc'a a chi ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Jinq'uin a chen c'änti'ya, mach a chen ca' u chenob ajsusuccheriajobba. Unejobba tä' yojob u chen c'änti'ya wa'a tama ch'uj, y si mach, tu ch'ixma calle, uc'a chänintic cua' mu' u chen. Totojtoj cälbenetla, jin chich ni fama que u yäc'bintejobba, jin chich une u jelo ni mu' u chenobba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aneba, jinq'uin a xe a chen c'änti'ya, ochen tan a cuarto a juntuma y mäcben u ti'. Ya' jini chen c'änti'ya uc'a u yubin sec' ni a Pap ya'an tä cieloba. A Pap ni ya'an tä cieloba, jini u chänen cua' chichca mucuba, une chich u xe u yäc'benet a matän. ");
INSERT INTO chfNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Jinq'uin a chen c'änti'ya anelaba, mach a bon chenla noj q'uenel päpä' t'an tan a c'änti'ya ca' u chen ni gente que mach u totoj ch'u'ul c'ajti'i ni mero Diosba. Unejobba u chenob ca' jini t'oc noj q'uenel t'an uc'a u te tu c'ajalinob cache' ca' jini u xe u yubin u diosob. ");
INSERT INTO chfNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mach a chenla jiq'uin ca' chich u chenob unejobba, uc'a ni a Papla ya'an tä cieloba worin yuwi chich cua' jini c'änä ac'ala. Mach to a c'atbela anelaba, uneba worin yuwi chich. ");
INSERT INTO chfNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Anelaba, jinq'uin a chenla c'änti'ya, äläla ca'da: Cä Pap, bajca anet tä cielo, ch'u'ul ajnic a c'aba'. ");
INSERT INTO chfNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","La'ix de Ajnoja. Utic ca' chich a wo. Ca' chich u yute tä cielo, che' chich täcä utic pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Benon t'ocob upete q'uin cä pa' waj y upete cua' chichca que c'änä cäc'a t'ocob tuba cä numsen t'ocob t'oc q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chen perdona cä tanä t'ocob, ca' chich no'on t'ocob cä chen perdona machcatac u säte' t'oc no'on t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mach a wäctan tic täjcac'o t'ocob jini u yäc'benon cä säte' t'oc ane. Tz'eje'on t'ocob t'oc jini mach utzba. Uc'a ane chich ni paq'uin Ajnojalet. Paq'uin an a poder. Paq'uin an a pitzilan. Mach'an a xupiba. Che' chich ajnic. ");
INSERT INTO chfNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Uc'a si a chen perdona cua' chichca u cherbenetob mach utz ni winicob pancabba, u xe chich u chenet perdonala täcä ni a Papla ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Si ane mach a che perdonala ni winicob pancab cua' chichca u cherbenetla mach utzba, a Papla täcä ya'an tä cieloba mach uxin u chenet perdonala jinq'uin a säte'la t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Jinq'uin anela a chenla su'q'uin, mach a wäq'ue' ajnic tä' lástima a jutla, ca' u chenob ajsusuccheriajobba. Uc'a unejobba u yäq'ue' u yäne' uba u jutob uc'a chänintic cache' mu' u chen su'q'uinob. Totojtoj cälbenetla, jin chich ni fama que u yäc'binteba, jin chich namás u jelo u xe tä äc'binte t'oc ni u chenobba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aneba, jinq'uin a chen su'q'uin, äc'ä a jätz'äcnib tan a pam, y poco a jut. ");
INSERT INTO chfNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ca' jini mach u chäne niuntu cache' mu' a chen su'q'uin. Chen mucu, tuba u chänen sec' ni a Pap ya'an tä cieloba. A Pap ya'an tä cieloba, jini u chänen cua' chichca u yute mucuba, u xe u yäc'benet a matän u jelo ni mu' a chenba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mach a c'ac'a' woye'la q'uen cua' chichca tä' choj y pitzijtac pancab, bajca u c'uxe' u wincäre, bajca u c'u'nesan u caba, bajca u yoche täcä ajxuch' u ch'e'. ");
INSERT INTO chfNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Woyola jini mäx pitzijtac jini u yäq'ue' Dios tä cieloba, jini ayan bajca mach uyoch u wincäre u c'uxe'ba, bajca mach uc'u'na t'oc u cababa, bajca mach uyoch ajxuch' u ch'e'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Uc'a bajca an ac'a jini cua' chichca tä' pitzijtacba, sec' jin chich a xe a wäq'ue' ta' pixan tuba ajniquet ya'i bajca an. ");
INSERT INTO chfNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’T'oc cä jutla cä chänenla junch'äcni. Si utz a jutba, u ch'e' chich a c'alin chänen junch'äcni. ");
INSERT INTO chfNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Si a jut mach utzba, ca' a wälä tan it'obni ayanet. Si u bäle' uba jini a jut a chen chanäla t'ocba, noj gran it'obni chich a chänenla. Ca' jini ayan cä c'ajalinla täcä. Si mach utz cä c'ajalinla, mach cä cänäla lo que Dios yo cä chenla, es ca' a wälä tan it'obni ayanonla täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Niuntu mach u ch'ä u cherben u patan cha'tu u yum. Si cha'tu u yumba, untu u xe u cräxna'tan y untu u xe u yajna'tan. Untu u xe u tz'omben u t'an y untu mach uxin u tz'omben u t'an. Mach u ch'ä a yajna'tanla Dios si a yajna'tanla a taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Jin uc'a cälbenetla: Mach jaq'uic ajin a chen pensala cua' a xe a c'uxe'la y cua' a xe a wuch'enla tuba cuxlequetla. Mach a chen pensala täcä cada a xe a ch'e' a bucla tuba a xoje' ta'wac'ola. ¿Mach quira más u chen vale a wutzila que cua' a c'uxe'la? ¿Mach quira más a chen vale anelaba que a bucla? ");
INSERT INTO chfNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Iranla cache' cuxujob ni mutob ajwile isqui. Mach u päc'äjob cua' y mach u c'ajajob cho, y mach u yosejob ixim tan otot tuba u ch'ujnanob. Cä Papla ni ya'an tä cieloba, une chich u yäc'ben cua' u c'uxe'ob. ¿Mach quira más a chen valela ane que ni mutob jini? ");
INSERT INTO chfNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Caxca une u ch'e' u täm'esan yoc si u bon älben täm'ac? Niuntu mach u ch'ä u täm'esan ni tz'ita'. ");
INSERT INTO chfNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Cua' uc'a tä' a chen pensala cada a xe a ch'e' a bucla? Tic ta' c'ajalinla cache'da u ch'ije ni rosa ya'an tä campoba. Mach u che patanob. Mach u jälä noc'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Cälbenetla cache' jini rey aj Salomón t'oc upete u pitzilan que u jeli uba t'ocba, mach uc'ot t'oc ni tz'ita' u pitzilan ni rosajob jini. ");
INSERT INTO chfNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Si ca' jini Dios u yäc'ben ajnic u pitzilan ni bäläna ya'an tä campoba, jini cä chänenla ump'e q'uin y päscab u ch'ämcan ta julcac tan c'ac'ba, más u xe chich täcä u yäc'benetla a bucla anela. Ac'ä mäx tz'ita' a tz'onänla cache' u chen Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mach a chen pensala jiq'uin ca'da: “¿Cua' jini wäre cä xe cä c'uxe'la? ¿Cua' jini wäre cä xe cuch'enla? ¿Cada wäre cä xe cä ch'e'la cua' cä xoje' täjcac'ola?” ");
INSERT INTO chfNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Uc'a upete ni jini sec' jin chich u sacänob ni gente que mach u totoj ch'u'ul c'ajti'i ni mero Diosba. Pero jini cä Papla ni ya'an tä cieloba worin yuwi chich cache' c'änäjtac ac'ala upete ni jini. ");
INSERT INTO chfNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sacänla najtäcä cache' u ch'e' ajniquetla tu manda Dios, y chenla tu toja ca' chich u yäle' uneba. Si a chenla ca' jiniba, upete ni jinijob Dios chich u xe u yäc'benetla täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mach jaq'uic ajinla jiq'uin, a päpä' chen pensala cua' u xe tä ajtä ic'ä. Tax u yajtä lo que u xe tä ajtä ic'ä. An t'oc cada q'uin a chen lo que u yäq'ue' utic. ");
INSERT INTO chfNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Mach a päpä' äle' que a lot mach u che tu toja, uc'a mach älbintiquet täcä que ane mach a che tu toja. ");
INSERT INTO chfNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Uc'a ca' chich a cherben a lot, che' chich a xe tä cherbinte täcä. Ca' chich a p'isän cua' chichca a wäc'ben a lot, che' chich a xe tä p'isbinte täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Cua' uc'a a wäle' que mach utz cua' u chen a lot jinq'uin mäx tz'ita' u säte'ba, y ane mach a wäc'be aba cuenta que ayan a noj q'uenel tanä? Es ca' a wälä ya'an yoc p'i' p'os tan u jut y noj gran te' tan a jut aneba. ");
INSERT INTO chfNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mach u ch'ä a wäle': “Cä lot, la'ix cä pa'säbenet ni p'os tan a jut” si aneba ya'an noj gran te' tan a jut. ");
INSERT INTO chfNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ane ajsusuccheriajet! Pa'sen najtäcä ni noj te' ya'an tan a jutba, uc'a u ch'e' a chänen tuba a pa'säben ni p'os tan u jut a lot. ");
INSERT INTO chfNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Jini que ch'u'ul chere uc'a Diosba, mach a wäc'ben ni gente ajmalujle ca' a wälä wichu'jobba, mach xic u jule' ubajob ta'wac'ola. Jini tä' choj u valor que u te tu c'äb Diosba, mach a wäc'ben ni gente ca' a wälä chitamobba, mach me'ixto xic u xac'äjteq'ue'. ");
INSERT INTO chfNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’C'atbenla Dios t'oc c'änti'ya cua' chichca jini, y a xe chich tä äc'bintela. Sacänla jini u yäq'ue' Diosba, y a xe chich a pojlenla. Pecänla Dios y u xe chich u yubin a t'anla y u yäc'benetla lo que c'änä ac'ala. ");
INSERT INTO chfNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Uc'a upete machcatac u c'atän, u yäc'binte chich. Machcatac u sacän, u pojlen chich. Machcatac u pecän, u xe chich tä ubcan u t'an y u yäc'binte lo que c'änä uc'a. ");
INSERT INTO chfNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Caba winic de anelaba, si a wajlo' u c'atbenet waj, ¿a xe quira a wäc'ben ump'e ji'tun? ");
INSERT INTO chfNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Si u c'atbenet untu u pa' buch', ¿a xe quira a wäc'ben untz'it chan? ");
INSERT INTO chfNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anelaba, que ajcherajtanäjetla, si a paq'uin äc'benla a bijch'oc cua' chichca utz, ¿mach quira cä Papla tä cielo täcä más u xe u yäc'ben cua' chichca utz machca chichca u c'atben? ");
INSERT INTO chfNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Bada jiq'uin, ca' chich a wo que a lot u chen upete tu toja t'oc ane, che' chich täcä c'änä a chen t'oc unejob. Ca' jini chich u ye'benonla cä chenla ni ley taj Moisés y ni u tz'ibi ajt'anob ta Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Ya'an chatz'it bij. Untz'it bij u bisanonla tä cielo y untz'itba u bisanonla tä sätiba. Ochenla bajca p'i' u tan ni ochibaba. P'i' u tan ni ochiba y p'i' u tan täcä ni bij que u bisan untu bajca u ch'e' paq'uin cuxlec untu, y mäx tz'ita' machcatac u ch'e' ni bij jini. Uc'a noj u tan ni ochiba y noj u tan täcä ni bij que u bisan untu tä sätibaba, y q'uen machcatac u ch'e' ni bij jini. ");
INSERT INTO chfNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Iran que mach u sucpecänetla jini ajt'anob que u te u päpä' ye'e' cua' chichca t'an que mach jin ta Diosba. Unejobba u xe tä te bajca anetla ca' a wälä tä' utz u c'ajalin t'oc anela ca' u mansu'an oveja, pero tan u pixanobba tä' cäräxjob ca' ajlobo. ");
INSERT INTO chfNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","T'oc lo que u chenobba, a xe a wina'tanla caxcatac une. Ca' chich ni uva mach utuq'uinti tuyac'o te' chäcch'ix, che' chich täcä u jut tzajäla u c'aba' higoba mach utuq'uinti tuyac'o bäläna. ");
INSERT INTO chfNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ca' jini täcä upete ni te' utzba, utz chich u jut u chen. Ni te' mach utzba, mach utz u jut u chen. ");
INSERT INTO chfNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Untec te' utzba mach u ch'ä u yäq'ue' u jut que mach utz. Untec te' mach utzba mach u ch'ä u yäq'ue' u jut utz. ");
INSERT INTO chfNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Upete te' que mach u yäc'ä u jut utzba, u tzepcan une y u julcan tan c'ac' tä pule. ");
INSERT INTO chfNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jin uc'a cälbenetla que uc'a lo que u chenobba a xe a wina'tanla caxcatac une. ");
INSERT INTO chfNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Jini machca u yälbenon ca'da: “Cajnoja, Cajnoja”, mach upete u xe tä ochejob bajca u chen manda ni Dios ya'an tä cieloba. Ni u xe tä ochejobba sec' jini machca u chen ca' chich yo ni cä Pap ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jimba q'uin jiniba q'uen chich machca u xe u yälbenon ca'da: “Cajnoja, Cajnoja, ¿mach quira a t'an chich ni cä ye'i t'ocob? ¿Mach quira t'oc u poder a c'aba' cä pa'si t'ocob tzuc pixan tuyac'o machcatac u tz'ibajtesan? ¿Mach quira t'oc u poder a c'aba' cä chi t'ocob q'uen milagro?” ");
INSERT INTO chfNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jinq'uinba, no'on cä xe cä p'albenob ca'da: “Mach bay cä chet conocela. Tz'eje abala t'oc no'on, anela que mach utz cua' a chila”. ");
INSERT INTO chfNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Machca chichca jiq'uin que u yubin upete ni t'anda que mu' cäle'ba y u chen ca' chich cäli, ca'da ayan une: Es ca' untu winic que an u c'ajalin. Une u chi yotot tu pam ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","De ya'i u yäc'bi noj ja', c'ac'a' but'i. U yusti noj gran ic', y u jätz'i uba tuyac'o jini otot. Mach u chi trebe ni noj ic' ni ja' u yäsen tä cab uc'a jini otot ya' uti une tu pam ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Machca chichca que u yubin upete ni t'anda que mu' cäle'ba y mach u che ca' chich cäli, ca'da ayan une: Es ca' untu winic que mach totoj an u c'ajalin. U chi yotot tu pam ji'. ");
INSERT INTO chfNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","De ya'i u yäc'bi noj ja'. C'ac'a' but'i. U yusti noj gran ic', xi u jätz'e' uba tuyac'o ni otot jini. T'oc noj quiricne yäli tä cab. ");
INSERT INTO chfNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jinq'uin u tzupsi aj Jesús u yäle' ni t'anda, taj coli ni gente tä ch'ictä u jutob uc'a jini t'an que u yäliba. ");
INSERT INTO chfNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Uc'a uneba cheque chich cache' Dios chich u yäc'bi poder tuba u ye'e' ni t'an jini, uc'a u c'alin ye'e' une y mach ca' u ye'e' jini machcatac yuwi ni ley taj Moisés. ");
INSERT INTO chfNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jinq'uin jaqui aj Jesús ya'i tu pam jini tz'ic, q'uen gente u bixe tu pat. ");
INSERT INTO chfNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pasi untu winic ajc'unen pächi. Ni yaj jini que u cänäntanba, u yälbinte u c'aba' lepra. C'oti u nuc'tan aj Jesús, nocwäni tu pänte' u yälben ca'da: ―Noxi' winic, si a wo a tz'äcälinon, co que a pa'sen jini yajda täc pächi, uc'a cuwi chich cache' ayan a poder tuba a chen. ");
INSERT INTO chfNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aj Jesús u t'äbsi u c'äb, u täli y u yälbi ca'da: ―Co chich. Pasic jini yaj ta' pächi. Jinchichba rato säti tuyac'o ni yaj jini de c'unen pächile. ");
INSERT INTO chfNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","De ya'i aj Jesús u yälbi ca'da: ―Iranba. Mach xiquet a wälben niuntu. Corre cux najtäcä bajca an pale, uc'a u chänenet. Subben u matän Dios ca' chich u yäli aj Moisés utic. Ca' jini upete u xe u chänen cache' a pojli aba chich. ");
INSERT INTO chfNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Oche u chen aj Jesús tan caj tä Capernaum. C'oti untu ajmanda ta cien soldado bajca an une, tuba u c'atben que u tz'äcälben untu u yajpatan. ");
INSERT INTO chfNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","U yälben ca'da: ―Noxi' winic, ya'an untu cajpatan täj cotot ch'a'a pan u tz'en, chämen yoc y noj gran c'uxtäcle u tz'ibajtesan. ");
INSERT INTO chfNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aj Jesús u yälbi: ―No'on cä xe cä chänen y cä xe cä tz'äcälin. ");
INSERT INTO chfNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jini ajmanda ta cien soldado u p'ali ca'da: ―Noxi' winic, mach jin niump'e cua'on tuba ochiquet tama cotot. Toc'a a wäle' que u yäq'ue' uba cajpatan y u xe chich u yäq'ue' uba. ");
INSERT INTO chfNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Uc'a no'on täcä ayan machca u chenon manda y ya'an täc manda täcä q'uen soldado. No'on cälben untu corre cux y u xe. Otro cälben la'ix, y u te. Ni cajpatan cälben, chen ni patanda y u chen chich. ");
INSERT INTO chfNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jinq'uin u yubi aj Jesús ca' jini, tajch'icwäni u jut. De ya'i u yälbijob ca'da machcatac u te tu patba: ―Totojtoj cälbenetla, mach to bay cä chäne niuntu winic que u totoj tz'onän ca' u tz'onän uneba, pero niuntu de aj Israelob mach'an ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bada cälbenetla que u xe tä tejob q'uen aj gentilob tä weti q'uin y tä pome q'uin, u xe tä c'ote tä chumtä tä c'uxnanob nämte' t'oc aj Abraham, t'oc aj Isaac, y t'oc aj Jacob bajca u chen manda Dios tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero q'uen aj Israelob que u pitänob osinticob bajca u chen manda Dios uc'a unejobba u ch'ocob aj Abraham, mach uxin tä osintejob. U xe tä julcanob tan it'obni. Ya'i u xe u chen uq'uejob. U xe u chen cäch'äcne yejjob. ");
INSERT INTO chfNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","De ya'i aj Jesús u yälbi ni ajmanda ta cien soldado ca'da: ―Corre cux ta' wotot. Ca' chich a tz'onän ane, che' chich u xe tä ute. Jinchichba rato jini u yajpatan u yäq'ui uba. ");
INSERT INTO chfNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","C'oti aj Jesús tu yotot aj Pedro. U chäni cache' ya' ch'a'a u nojna' aj Pedro tu pan u tz'en, c'ojo t'oc ticwa. ");
INSERT INTO chfNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aj Jesús u tälbi u c'äb ni ixic. Täpi ni ticwa. De ya'i ch'oyi ni ixic u chen cua' tä c'uxcan tuba u yäc'ben aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tu yoche ac'äb u täsijob bajca an aj Jesús q'uen machcatac u tz'ibajtesan ni tzuc pixan. T'oc ump'e t'an u laj pa'si ni tzuc pixanob y u laj tz'äcäli upete ni ajc'ojpan. ");
INSERT INTO chfNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ca' jini pasi toj ni u yäli aj Isaías ajt'an ta Dios oniba jinq'uin u yäli ca'da: “Une chich u laj ch'i tuyac'o ni cä yajla, y u pa'säbonla ni cä c'uxtäclela”. ");
INSERT INTO chfNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jinq'uin u chäni aj Jesús cache' q'uen gente ayan bajca an une, u yälbi u yajcänt'anob c'axicob tunxe nab. ");
INSERT INTO chfNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","C'oti bajca an aj Jesús untu que tä' yuwi ni ley taj Moisés. U yälbi ca'da: ―Maestro, cä xe cä tzäypätinet cachichcada que xiquet. ");
INSERT INTO chfNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aj Jesús u yälbi ca'da: ―A'uch ayan u yajliba. Mut ajwile isqui ayan u c'ub. No'on que sutwänon de winicba mach'an cada cä t'eljatz'än cä pam. ");
INSERT INTO chfNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Otro untu que u tzäypätin aj Jesús u yälbi ca'da: ―Cajnoja, taxto cä muque' najtäcä cä pap, de ya'i cä xe cä tzäypätinet. ");
INSERT INTO chfNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aj Jesús u yälbi: ―Tzäypätinon. Äctan ni ca' a wälä chämenobba u muque' u yajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ochi aj Jesús tama ni jucub, y u yajcänt'anob bixijob nämte' t'oc. ");
INSERT INTO chfNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tajtzäc ch'oyi tama ni nab ump'e noj gran ic'. Tä' re'i de muc' ni ic', ixta u jule' noj t'olja' tama ni jucub. Aj Jesúsba wäye u chen une. ");
INSERT INTO chfNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","U yajcänt'anob u natz'i, y u p'isíjob u yälben ca'da: ―Cajnoja, japänon t'ocob uc'a mach chämiconla tä ja'. ");
INSERT INTO chfNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aj Jesús u yälbijob ca'da: ―¿Cua' uc'a bäc'tetla? ¿Mach to quira a totoj tz'onäla? De ya'i ch'oyi. U q'uejpi ic' y nab. Laj ch'ijcäbi upete. ");
INSERT INTO chfNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ni winicob u bixe nämte' t'ocba tajch'icwäni u jutob, u yäle'ob ca'da: ―¿Caba winic wäre jinda ixta ic' y nab u tz'omben u t'an? ");
INSERT INTO chfNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jinq'uin c'oti aj Jesús tunxe nab tu cab aj gadarenojob, pasi u nuc'tan cha'tu winic t'oc tzuc pixan tuyac'o. Ya' tijob bajca an u mucliba ajchämejob. Jini winicob jiniba tä' cäräxob y tä' q'uen u muc', ixta mach u ch'ä numic niuntu jimba bij jini bajca an ni winicob jiniba. ");
INSERT INTO chfNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","U chijob noj t'an u yäle'ob ca'da: ―¿Cua' atet a cherbenon t'ocob, aneba Jesús, u yajlo'et Dios? ¿Atet quira wida tuba a tz'ibajtesanon t'ocob antes de c'otic u q'uini? ");
INSERT INTO chfNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bajca anob cheque nat ump'e u noj tomtä chitam u sacän cua' u c'uxe'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ni tzuc pixanob u bon c'atbi aj Jesús ca'da: ―Si a xe a pa'senon t'ocob tuyac'o ni winicobdaba, äc'benon ochicon t'ocob tuyac'o ni u noj tomtä chitam ya'an nantiba. ");
INSERT INTO chfNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Une u yälbi ca'da: ―Cuxla jiq'uin. Unejob pasi tuyac'o ni winicob, bixijob tuyac'o u noj tomtä chitam. Tajtzäc ni u tomtä chitamob jini t'oc noj ancäre laj bixijob bajca isqui cab tu ti' nab, y u laj juli ubajob tä ja'. Upete laj chämijob tan nab. ");
INSERT INTO chfNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jini ajcänänchitamobba laj putz'ijob. Tu c'otejob tan caj u laj tz'ayquijob upete ni u chänijobba, y cache' u chi pasa t'oc ni winicob que ajni tzuc pixan tuyac'oba. ");
INSERT INTO chfNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Upete a'ajtäjob tama jini caj pasi u nuc'tanob aj Jesús. Cuanta u nuc'tijob u bon älbijob que pasic ya'i bajca anob y bixic. ");
INSERT INTO chfNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","De ya'i ochi aj Jesús tama ni jucub, bixi tunxe nab. C'oti tu cäji. ");
INSERT INTO chfNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jinq'uin c'oti ya'i, u täsijob bajca an aj Jesús untu winic chämen yoc. U täsijob tu pam u ch'a'liba. Jinq'uin u chäni aj Jesús cache' u totoj tz'onänob, u yälbi ni ajc'ojpan ca'da: ―Ch'a'alesan ajin cä ch'oc. A tanä alaj uti perdona. ");
INSERT INTO chfNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jinq'uin u yubijob cha'tu uxtu jini que tä' yuwijob ni ley taj Moisésba, u yälijob tan u c'ajalinob ca'da: “Jini winicda u chen uba ca' Dios, y ca' jini u xiq'ue' Dios”. ");
INSERT INTO chfNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aj Jesús yuwi chich cua' an tu c'ajalinob. U yälbijob ca'da: ―¿Cua' uc'a u te ta' c'ajalinla cua' chichca jini mach utz? ");
INSERT INTO chfNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Caxcamba jiq'uin más u ch'e' älbintic: “A tanä alaj cherbintet perdona”, o älbintic: “Ch'oyen, chen xämba”? ");
INSERT INTO chfNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iranla cua' cä xe cä chen uc'a a wina'tanla cache' no'on que sutwänon de winicba cä cänäntan poder tu pancab tuba cä chen perdona u tanä untu. Jin uc'a aj Jesús u yälbi najc'ojpan ca'da: ―Ch'oyen, ch'ä a ch'a'lib y corre cux ta' wotot. ");
INSERT INTO chfNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","De ya'i ni ajc'ojpan ch'oyi y bixi tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jinq'uin u chänijob ni gente cua' uti, tajch'icwäni u jutob. U ch'u'ul c'ajti'inob Dios, uc'a Dios u yäc'bi winic u poder tuba u tz'äcälin ni ajc'ojpan jini. ");
INSERT INTO chfNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tu pase aj Jesús ya'i u chäni untu winic u c'aba' aj Mateo, ya' chumu tama ump'e otot bajca u tojcan derecho. Aj Jesús u yälbi ca'da: ―Tzäypätinon. Une ch'oyi y u tzäypäti. ");
INSERT INTO chfNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","De ya'i aj Jesús chunwäni tä c'uxnan tama ump'e otot. C'otijob täcä q'uen ajcojtaq'uinob y ajcherajtanäjob. Chunwänijob nämte' t'oc aj Jesús y u yajcänt'anob tä c'uxnan. ");
INSERT INTO chfNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jinq'uin u chänijob aj fariseojob ca' jini, u yälbijob u yajcänt'anob aj Jesús ca'da: ―¿Cuaxca uc'a u c'uxnan a maestrola t'oc ajcojtaq'uinob y ajcherajtanäjob? ");
INSERT INTO chfNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jinq'uin u yubi aj Jesús ca' jini, u yälbijob ca'da: ―Machcatac t'oc u yutzi, mach c'änä uc'ajob ajtz'ac. Sec' jini machcatac c'ojojtacobba, unejob c'änä uc'ajob ajtz'ac. ");
INSERT INTO chfNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cuxla jiq'uin, y tic ta' c'ajalinla cua' u yäle' ni t'an a cänila ca'daba: “Ajnic utz a c'ajalinla toc a lotla. Jin une ni más co que ni matän que a subbenonba”. No'onba mach ajulon pancab tuba cä sacän machcatac an tu toja. Ajulon cä sacän machcatac ajcherajtanä tuba cä'ben u q'uexe' u c'ajalinob. ");
INSERT INTO chfNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","C'oti u yajcänt'anob aj Juan u yälben aj Jesús ca'da: ―¿Cua' uc'a no'on t'ocobba y aj fariseojob mach unnum cä chen su'q'uin t'ocob, y a wajcänt'anobba mach u chejob? ");
INSERT INTO chfNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aj Jesús u yälbijob ca'da: ―¿U ch'e' quira ajnic ch'oc u pixanob machcatac ya'an bajca an lotojan jinq'uin ajlotojan ya'to an bajca anob? U xe tä c'ote q'uin jinq'uin ajlotojan u xe tä pase bajca anob. Jinq'uintoba u xe u ch'e' u chen su'q'uinob. Ca' jini, jinq'uin ya'to anon t'oc cajcänt'anob, mach u ch'ä u chen su'q'uinob. Pero cuanta bixonba, u xe u chen su'q'uinob. ");
INSERT INTO chfNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Niuntu mach u tzutzä u jelem buc t'oc tzijib noc', uc'a ni tzijib noc' u xe u yuch'en ja' y u sätz'e' ni jelem buc y más u no'an u xet'ota. Ca' jini mach yo cä xabänla ni u t'an aj fariseojob t'oc ni cä ye'e' no'on badaba. ");
INSERT INTO chfNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Che' chich täcä niuntu mach u yäc'ä chij tzijibba tama ump'e jelem pächil ch'ujliba, uc'a si utic ca' jiniba, u xe tä tzale ni pächil ch'ujliba. De ya'i u wech'can ni chij, y ni pächil ch'ujliba mach u ni' che servi. U yä'can tzijib chij tama tzijib pächil ch'ujliba. Ca' jini u chap'elma mach usat. ");
INSERT INTO chfNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aj Jesús mu'to u t'an t'oc ni gente, c'oti untu ajnoja taj judíosob, nocwäni tu pänte' u yälben ca'da: ―Quixic ch'oc atotaj chämi. La'ix ane, äc'ben a c'äb tu pam, y u xe chich tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","De ya'i ch'oyi aj Jesús, bixi tu pat con to'o u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jimba rato jini que bixe to u chenba, c'oti ca'an aj Jesús untu ixic c'ojo t'oc u yaj de ch'ich' que u cänäntan doce año c'ojo t'oc jini yaj. Tutz'i tu pat aj Jesús u tälbi u ti' u buc. ");
INSERT INTO chfNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Uc'a ti tu c'ajalin ni ixic jini ca'da: “Si cä chen trebe namás cä tälben u ti' u bucba, cä xe cä pojlen cäba”. ");
INSERT INTO chfNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","De ya'i u suti uba aj Jesús u chänen, u yälbi ca'da: ―Ch'a'alesan ajin cä ch'oc. Uc'a a tz'oni, a pojli aba. Jinchichba rato jini u pojli uba jini ixic. ");
INSERT INTO chfNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jinq'uin c'oti aj Jesús tu yotot ni ajnoja taj judíosob, u chäni cache' ya'anob aj ustaj ämäyob y noj q'uenel gente tä bänäcne. ");
INSERT INTO chfNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aj Jesús u yälbijob ca'da: ―Tz'eje abala. Ni yoc ixocda mach chämen. Wäye u chen une. De ya'i ni gente cayi u bon tze'tanob. ");
INSERT INTO chfNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cuantu tz'eji ubajob ni gente, ochi aj Jesús u q'uechbi u c'äb ni yoc ixoc. De ya'i ch'oyi ni yoc ixoc. ");
INSERT INTO chfNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ni jinda que u chi aj Jesúsba, laj ubqui tama entero ni cab jini. ");
INSERT INTO chfNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jinq'uin pasi aj Jesús ya'i, bixe u chen tä bij, u tzäypäti cha'tu ajchoc'. U pecänob t'oc noj t'an, u yäle'ob ca'da: ―¡Ch'ämbenon t'ocob yajin, ajlo'et taj David, ni reyba! ");
INSERT INTO chfNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jinq'uin ochi aj Jesús tama ump'e otot, c'otijob ni ajchoc' bajca an. Aj Jesús u yälbijob ca'da: ―¿A tz'onänla quira cache' cä chen trebe cä tz'äcälinetla? Unejob u p'alijob: ―A chen chich trebe a tz'äcälinon t'ocob ane, Cajnoja. ");
INSERT INTO chfNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","De ya'i aj Jesús u tälbi u jutob, u yälbenob ca'da: ―Ca' chich a tz'onänla, che' chich utic t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jini ajchoc' seb u laj jäbi uba u jutob y u chi chanäjob. Aj Jesús u c'alin älbijob ca'da: ―Iranla que mach xic yuwina'tan niuntu cache' cä tz'äcäletla. ");
INSERT INTO chfNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Unejobba jinq'uin pasijob, u bon tz'ayquijob cachichcada tama ni cab jini cua' u chi aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pase u chen unejob, c'osinti bajca an aj Jesús untu a'uma', que ya'an tzuc pixan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cuanta u pa'säbi aj Jesús ni tzuc pixan tuyac'o ni a'uma', cayi u chen t'an. Ni gentejob que ya'an u chänenobba, tajch'icwäni u jutob, u yäle'ob ca'da: ―Mach bay cä chänila utic cua' chichca ca' jini tä Israel. ");
INSERT INTO chfNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aj fariseojobba u yäle'ob ca'da: ―Ajnoja tuba tzuc pixanob u yäc'ben u poder u pa'sen tzuc pixan. ");
INSERT INTO chfNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aj Jesús u nume cachichcada tama upete nuc caj y bit caj u ye'e' u t'an Dios tama ch'uj taj judíosob. U ye'e' jini t'an que u yäq'ue' ch'a'aljin, cache' Dios ni mero ajnoja. U tz'äcälin upete ajc'ojpan tama jini caj t'oc cua' chichca yaj que u cänäntanob. ");
INSERT INTO chfNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jinq'uin u chäni aj Jesús ni noj q'uenel gente, u ch'ämbi lástimajob, uc'a ya'anob tä tentenbäji, mach yuwi cache'da u numejob, ca' ni ovejajob que mach'an machca u cänäntanobba. ");
INSERT INTO chfNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aj Jesús u yälbi u yajcänt'anob ca'da: ―Q'uen machcatac yo u yubin u t'an Dios, pero mäx tz'ita' machcatac u ye'e'. Es ca' ni päc'äbi, q'uen chich u jut ayan, y mach'an q'uen ajpatan tuba u ch'uch'än. ");
INSERT INTO chfNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","A c'atbenla jiq'uin cä Yumla que u täscun q'uen u yajpatan tuba u ye'e' u t'an, ca' chich u yum päc'äbi c'änä u täscun q'uen u yajpatan tuba u ch'uch'ben u jut ni päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aj Jesús u joq'ui ni doce u yajcänt'anob, u yäc'bi u poderjob tuba u pa'sen tzuc pixan tuyac'o machca u cänäntan. U yäc'bi u poderjob täcä tuba u tz'äcälin upete ajc'ojpanob t'oc upete yaj que u cänäntanob. ");
INSERT INTO chfNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jinda u c'aba'job ni doce apóstolesjob, jini u yajc'äncanob aj Jesucristoba: najtäcäba, aj Simón, u yälbinte täcä cache' aj Pedro; aj Andrés, u jitz'in aj Pedro; aj Jacobo, ajlo' taj Zebedeo; aj Juan, u jitz'in aj Jacobo; ");
INSERT INTO chfNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","aj Felipe; aj Bartolomé; aj Tomás; aj Mateo jini ajcojtaq'uinba; aj Jacobo, ajlo' taj Alfeo; aj Lebeo jini u c'aba' täcä aj Tadeoba; ");
INSERT INTO chfNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aj Simón, jini aj cananitaba; aj Judas Iscariote, jini u yäq'ui tä c'äbä aj Jesúsba. ");
INSERT INTO chfNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jindajob une ni doce u täsqui aj Jesús. U yälbijob cache'da u xe u chen. U yälbijob ca'da: ―Mach a ch'e'la ni bij que u bixe tu cab aj gentilob. Mach ochiquetla täcä tama u cab aj samaritanojob. ");
INSERT INTO chfNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cuxla bajca an aj Israelob, jini sätä ayanob ca' ovejaba. ");
INSERT INTO chfNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ta' numela cachichcada, älbenobla ca'da: “Mach ni' q'uen yo tuba u nonoj chen manda bajca anetla ni Dios ya'an tä cieloba”. ");
INSERT INTO chfNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tz'äcälinla ajc'ojpanob. Pa'säbenla tu pächi jini machca u cänäntan ni yaj de c'unen pächiba. Cuxpesanla ajchämejob. Pa'säbenla ni tzuc pixan machca u cänäntan tuyac'o. Matän a chila jini poder, matän chich a tz'äcälinla ajc'ojpanob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mach a bisanla taq'uin tan a bolsa, ni c'änc'än taq'uin, ni yoco taq'uin, y ni ch'oc taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mach a bisanla a morral tä bij. Mach a bisanla chap'e a bucla. Mach a bisanla a pächi'oc. Mach a bisanla a bordón. Uc'a ajpatanba c'änä chich äc'bintic cua' u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Cachichcaba nuc caj o bit caj ta' c'otela, c'atänla camba winic ya'i tä' utz u c'ajalin. Colenla tan yotot ixta que mach pasiquetla ya'i tama jini caj. ");
INSERT INTO chfNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta' ochela tama jini otot, c'atbenla Dios que u ch'u'ul chen u yum ni otot, y que u yäc'ben u ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si totoj utz u c'ajalin u yum ni otot jini, ni ch'a'aljin que äc'bintetlaba, che' chich u xe tä äc'bintejob täcä. Si mach totoj utz u c'ajalinobba, mach uxin tä äc'binte ni ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Machca chichca que mach u yolin u yosenetla y mach u yolin u yubin a t'anla, pasenla tama jini otot o tama jini caj. Ta' pasela ixta jini pupuc ya'an ta' woclaba ticänla, uc'a ca' jini a ye'e'la que mach jin a tanäla säticob. ");
INSERT INTO chfNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Totojtoj cälbenetla que jinq'uin u xe tä c'ote q'uin tuba äc'cac ni castigo, más tz'ita' u xe tä äc'bintejob machcatac cuxlijob tä Sodoma y tä Gomorra y más q'uen u xe tä äc'binte a'ajtäjob tama ni caj jini. ");
INSERT INTO chfNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Ubinla jiq'uin. No'on cä täscunetla bajca an gente que mäx malojob. Es ca' a wälä cä täscun oveja bajca an cäräx ajlobo. Ajnic q'uen a c'ajalinla ca' u c'ajalin chan y sis a c'ajalinla ca' u mansu'an u c'ajalin ix paloma. ");
INSERT INTO chfNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cänäntan abala, uc'a mach xic u sucpecänet winicob, uc'a unejob u xe u päye'etla tä juez y u xe u jätz'e'etla tama u ch'uj aj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ixta tu pänte' gobierno y nuc ajnojajob a xe tä päycanla uc'a a tz'ombenonla cä t'an. Ca' jini a xe a wäq'ue' yuwina'tanob unejob caxcamba a tz'onänla, y a xe a wäq'ue' yuwina'tanob täcä ni aj gentilob, jini que mach u totoj che conoce Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jinq'uin a cherbintela ca' jini, mach a chen pensala najtäcä cache'da a xe a chen t'anla, o cua' t'an a xe a wäle'la, uc'a jinchichba rato jini Dios u xe u yäc'benetla ta' c'ajalinla cua' une a xe a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Uc'a mach anela ni a xe a chen ni t'anlaba. U Ch'u'ul Pixan cä Papla Dios, ni ya'an ta'wac'olaba, une ni u xe u chen ni t'an. ");
INSERT INTO chfNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Winic u xe u päye' tä juez u säcun u c'atän tzämsintic. Untu winic ixta u yajlo' täcä u yäq'ue' tä tzämsinte. Winic u xe u tz'osen buya tuyac'o u pap täcä ixta u yäq'ue' tä tzämsinte. ");
INSERT INTO chfNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Cachichcada a xe tä cräxna'tintela uc'a a tz'ombenon. Machca u c'älen upete ni jini sin que sujlec tu pat, une ni u xe u japän uba. ");
INSERT INTO chfNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jinq'uin a tz'ibajtescanla tama ump'e caj pasenla ya'i tä putz'e, y seb cuxla tama otro caj. Totojtoj cälbenetla cache' mach to ulaj númetla tama upete u cäji aj Israelob jinq'uin cä xe tä sujtä no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Untu ajcänjun mach u cänänta más u poder que u maestro. Untu ajpatan mach u cänänta más u poder que u yum. ");
INSERT INTO chfNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tic ta' c'ajalinla jiq'uin cache' jini u cherbinte untu maestro, che' chich u xe tä cherbinte u yajcänjun täcä. Jini u cherbinte u yum patan, che' chich u xe tä cherbinte u yajpatan täcä. Si ajnoja tuba ump'e otot u yälbinte cache' t'oc u poder tzuc pixan ayan, más u xe tä c'ac'a' älbinte u ch'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Mach a bäc'tanobla jiq'uin. Uc'a upete ni jini que u yute mucu u xe chich tä chectan ji'pat. Upete ni jini que u yälcan mucu u xe chich tä ubcan ji'pat. ");
INSERT INTO chfNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jini cälbetla a juntumalaba, laj tz'aycunla une t'oc noj t'an uc'a u yubinob upete. Es ca' a wälä cälbetla ac'äb t'oc sajab t'an, y anela a laj tz'aycunla tä q'uin bajca upete u ch'e' u yubinob. ");
INSERT INTO chfNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mach a bäc'tanla machcatac u tzämsenetla, pero mach u che trebe u tzämsen a pixanlaba. C'änä a bäc'tanla Dios jini machca u chen trebe u choque' a pixan con to'o a cuerpo tama noj c'ac' tä infierno. ");
INSERT INTO chfNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Mach quira u choncan cha'tu bit mut t'oc ump'e ch'oc taq'uin? Mäx tz'ita' u chen vale ni mutob jini, pero niuntu mach u ch'ä yälic tä cab sin que cä Papla mach u jiran. ");
INSERT INTO chfNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Anelaba ixta upete a tzucla tziqui an uc'a Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jin uc'a cälbenetla mach bäc'taquetla. Anelaba más a chen valela que noj q'uenel bit mut. ");
INSERT INTO chfNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Machca chichca que u yälben u lotob pancab que ayan t'oc no'on, no'on täcä cä xe cälben cä Pap tä cielo que une ayan t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Machca chichca que u yälben u lotob pancab que mach'an t'oc no'on, no'on täcä cä xe cälben cä Pap tä cieloba que une mach'an t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Mach tic ta' c'ajalinla cache' aton cäq'ue' mach ni' ajnic niump'e buya pancab. Mach aton cäq'ue' ajnic tomp'e u c'ajalinob upete. Uc'a aton no'on, u xe chich tä ajtä buya. ");
INSERT INTO chfNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Uc'a machca u tz'ombenon, u xe tä ajtä yänä u c'ajalin t'oc u pap, ixic t'oc u na', y u yälib t'oc u nojna'. ");
INSERT INTO chfNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ni mach yo u chänen ni winic que u tz'ombenonba, jin chich ni ya'an tan yototobba. ");
INSERT INTO chfNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Machca u yajna'tan u pap y u na' más que u yajna'tanon no'on, mach'an cua' uc'a cä sapän. Machca más u yajna'tan u yajlo' o jixic ch'oc y mach u yajna'ton no'on, mach'an cua' uc'a cä sapän. ");
INSERT INTO chfNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Machca yo u sapänon y mach yo u ch'e' tz'ibajtesia, ca' a wälä untz'it cruz que u bisanba, mach'an cua' uc'a cä sapän no'on. ");
INSERT INTO chfNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Machca u sacän cache' cuxlec utz sin que tz'ibajtescac pancab u xe u säte' upete ni jini. Machca mach u sacä tuba cuxlec utz tu pancab uc'a u tz'ombon cä t'an, u xe tä äc'binte paq'uin cuxlec más utz. ");
INSERT INTO chfNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Machca chichca u yosenetla, ca' a wälä no'on une u yosenon. Machca no'on u yosenon ca' a wälä u yosen machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Machca u yosen untu ajt'an ta Dios sec' uc'a ajt'an ta Diosba, jin chich ni matän que u yäc'binte ni ajt'an ta Diosba, jin chich u xe tä äc'binte täcä ni machca u yosiba. Machca u yosen untu que u chen tu toja tu jut Dios sec' uc'a jini u yosinteba u chen tu tojaba, jin chich ni matän que Dios u xe u yäc'ben machca u chen tu tojaba, jin chich u xe tä äc'binte täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Machca chichca u yäc'ben que sea ump'e t'ub de sis ja' ni más ajch'och'ocajobdaba sec' uc'a cajcänt'anba, totojtoj cälbenetla que Dios chich u xe u yäc'ben u matänob. ");
INSERT INTO chfNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jinq'uin aj Jesús u tzupsi u yäc'ben c'ajalin ni doce u yajcänt'anobba, pasi ya'i bixi u ye'e' u t'an Dios tama ni cajob nätz'ä. ");
INSERT INTO chfNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jinq'uin u yubi aj Juan bajca mäcä tama cárcel cua'tac mu' u chen aj Cristo, u täsqui cha'tu u yajcänt'an ");
INSERT INTO chfNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","u c'atben aj Jesús ca'da: ―¿Ane quira ni älqui cache' u xe tä teba, o c'änä cä pijnan to t'ocob otro? ");
INSERT INTO chfNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aj Jesús u p'albijob y u yälbi ca'da: ―Cuxla ca'an aj Juan, tz'aycäbenla cua' mu' a ubinla y cua' mu' a chänenla. ");
INSERT INTO chfNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Älbenla ca'da: “Ajchoc' u chen chanä. Ajc'ol'oc u chen xämba. Jini c'ojo t'oc c'unen pächiba u yäc'binte u pojlen ubajob. Ajcoc u yubin t'an. Ajchäme u cuxpescan. Ni pobrejilbajobba u tz'aycäbinte u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ch'a'a ujin machca mach u yäcta u tz'ombenon”. ");
INSERT INTO chfNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jinq'uin bixe to u chenob ni ajc'äncan que u täsqui aj Juanba, aj Jesús u täq'ui u yälbenob ni gente cache'da an aj Juan. U yäle' ca'da: ―¿Cua' ajnet a chänenla bajca mach cuxu niuntu? ¿Untz'it oj quira que yumajtan t'oc ic'? Aj Juan mach ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Cua' une jiq'uin ajnet a chänen? ¿Untu winic quira t'oc u noj pitzil buc tä' choj u valor? Aj Juan mach ca' jini. Si a wo a wiran ni machcatac u c'äne' u buc tä' choj u valorba, ya'an une tan yotot reyjob. ");
INSERT INTO chfNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Cua' une jiq'uin apaset a chänenla? ¿Untu ajt'an ta Dios quira? Jin chich une. Cälbenetla cache' mero totoj ajt'an ta Dios chich aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","De une chich une ni u worin äq'ui Dios tä tz'ibinte jini u yäle' ca'daba: Ubinba, no'on cä xe cä täscun untu cajc'äncan xic najtäcä tuba u tuse' a biji bajca a xe tä nume. ");
INSERT INTO chfNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Totojtoj cälbenetla: Niuntu de u ch'ocob ixictacob pancab mach to bay uyajna de mero ajt'an ta Dios ca' aj Juan ajc'ablesiaba. Pero jini más ajch'och'oca que ayan tu manda Diosba, más utz u xe tä ajtä que aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde jinq'uin u täq'ui u yäle' u t'an Dios aj Juan ajc'ablesiaba ixta bada ni gente u te u yubin bajca u tz'ayquinte u t'an Dios ixta u xaläjnoje' u lotob. Jini que tä' yojob u yubin u yochejob chich tu manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Uc'a upete ajt'anob ta Dios y ni jun ta Dios que u tz'ibi aj Moisés oniba, u worin äli cache' u ch'e' ochic untu bajca u chen manda Dios. De ya'i juli aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si a wo a tz'onänla, tz'onänla, pero cä xe cälbenetla cache' aj Juan une ni aj Elías ni a ubila cache' u xe tä teba. ");
INSERT INTO chfNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Äc'ä a chiquin tuba a ubinla utz y tic ta' c'ajalinla cua' mu' cälbenetla. ");
INSERT INTO chfNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Cua' jini cä xe cäle' tuba cälbenetla cache'da an upete ni machcatac cuxu pancab badaba? Es ca' ni bijch'oc tä alas que u chumtä tänxin caj y u chen noj t'an u yälben u lot ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Cä jätz'i t'ocob músico, mach a chi ac'otla. Cä chi t'ocob uq'uel c'ay tuba ajchäme, mach a chi uq'uela”. ");
INSERT INTO chfNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Uc'a juli aj Juan, mach u tä' c'uxna, mach u tä' buc', y u yälijob cache' tzuc pixan ayan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Julon, no'on que sutwänon de winic. Cä c'uxnan y cä buc'a bajca cä jo'can, y u yälcan ca'da: “Iranla untu winic tä' q'uen u c'uxnan y u chibälnan, y u bisan bij t'oc ajcojtaq'uinob y ajcherajtanäjob”. Jini machcatac u sapi chich u t'an Diosba mach u yäläjob ca' jini, uc'a yuwijob chich cache' ni c'ajalin que u yäq'ue' Diosba utz chich une. ");
INSERT INTO chfNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","De ya'i aj Jesús u täq'ui u q'uejpan ni gentejob tama ni caj bajcatac anumi u chen cua' chichca tuba chänintic u poder Diosba uc'a mach u q'uexi u c'ajalinob tuba u tz'omben Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","U yäli ca'da: ―Tä' lástimajetla anela ya'i tä Corazín. Tä' lástimajetla anela ya'i tä Betsaida. Si fuera tama machcatac cuxlijob oni tä Tiro y tä Sidón utic cua' chichca tuba chänintic u poder Dios ca' chich uti bajca anetlaba, oni ica u q'uexi u c'ajalinob tuba mach u ni' chen u tanäjob, u yäq'ui ica u tzuc buc tuyac'ojob y u muli ica tan u pam t'oc tz'i'tan. ");
INSERT INTO chfNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Cälbenetla jiq'uin cache' jinq'uin u xe tä äc'can ni mero toji'tanä, más tz'ita' u xe tä äc'bintejob u castigo machcatac cuxli tä Tiro y tä Sidón que anela. ");
INSERT INTO chfNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Anela ya'i tä Capernaum, ¿u xe quira tä c'ote a fama ixta tä cielo cache' más utzetla que machcatac cuxujob tama otros caj? Mach une. Anelaba a xe tä julcan tama noj c'ac' tä infierno. Uc'a si fuera tama a'ajtäjob tä Sodoma utic cua' chichca tuba chänintic u poder Dios ca' chich uti bajca anetla, ya'to an ica ixta bada ni caj jini. ");
INSERT INTO chfNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Cälbenetla jiq'uin cache' tu xe tä c'ote q'uin ta äc'cac ni mero toji'tanäba, más tz'ita' u xe tä äc'binte u castigo aj Sodomajob que ta'ala. ");
INSERT INTO chfNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","De ya'i aj Jesús u chi c'änti'ya ca'da: ―Cä ch'u'ul c'ajti'inet cä Pap, Ajnojalet tuba cielo y u pancab. Mach a'bi ochic tu c'ajalinob cä t'an y cua'tac cä chen ni winicob que u yäle'ob que q'uen u c'ajalinobba, jini tä' yuwijob chich q'uen cua' chichcaba. A wäc'bi yuwina'tanob jini ca' a wälä bijch'ocobba. ");
INSERT INTO chfNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ca' jini chich a chi cä Pap, uc'a che' chich a woli a chen. ");
INSERT INTO chfNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","De ya'i u yäli aj Jesús ca'da: ―Upete cua' chichca cä Pap u laj äc'bon täj c'äb. Niuntu mach u nonoj chon conoce, sec' cä Pap. Niuntu mach u nonoj che conoce cä Pap, sec' no'on uc'a u Yajlo'on. Upete machca chichca co cä ye'ben cache'da an cä Pap, u xe chich u nonoj chen conoce täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","La'ixla bajca anon apetela que tä' bo'o ajinla y ca' a wälä t'oc a noj cuchla, y no'on cä xe cä'benet a ch'e' abala. ");
INSERT INTO chfNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Äc'ä abala täc manda. Cänä upete ni cä ye'e' no'on. Mach cäräxon no'onba, y utz cä c'ajalin. T'oc no'onba a xe a pojlenla cache' u ch'e' uba a pixanla. ");
INSERT INTO chfNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Utz chich cä manda cäq'ue' no'onba. Mach uxet tä bo'an ajinla t'oc, ca' a wälä cä'benetla ump'e cuch que mach tä' al. ");
INSERT INTO chfNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jimba q'uinob jiniba nume u chen aj Jesús bajca an päc'äbi de trigo ump'e u q'uini ch'ämbäji. U yajcänt'anobba cayi u na'tanob jitz'o y u tuc'bijob tz'ita' u jut ni päc'äbi tuba u c'uxe'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jinq'uin u chäni aj fariseojob cua' mu' u chenob, u yälbijob aj Jesús ca'da: ―Iran cache' mu' u chenob a wajcänt'an. Jini que mu' u chenobba, mach utz utic tu q'uin ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aj Jesúsba u yälbijob ca'da: ―¿Mach to quira a tziquila bajca u yäle' cua' u chi ni rey aj David y u lotob jinq'uin u na'tijob jitz'o? ");
INSERT INTO chfNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uneba ochi tan yotot Dios, u c'uxi ni waj que u subbinte Diosba. Jini waj mach u ch'ä u c'uxe' une, ni u lotob. Seq'uen palejob u ch'e' u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Mach to quira a tziquila täcä tama u jun Dios, jini que u tz'ibi aj Moisés oniba, cache' palejob u chen cua' chichca bit patan tan ch'uj tuyac'o u q'uin ch'ämbäji, y mach jin tanä tubajob jinq'uin u chen ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cälbenetla täcä cache' ya'an bada wida untu más utz tu jut Dios que ni ch'uj. ");
INSERT INTO chfNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mach to uyoch ta' c'ajalinla cua' u yäle' jini que tz'ibi ayan tan u jun Dios ca'daba: “Ajnic utz a c'ajalinla, jin une ni más co que matän”; uc'a si ochic ica ta' c'ajalinla cua' u yäle' jini tz'ibi tä junba, mach ica a wälila que mach u chijob tu toja jini cajcänt'anob, uc'a mach jin tanä u chijob. ");
INSERT INTO chfNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Uc'a no'on que sutwänon de winicba cä cänäntan chich poder tuba cäle' cua' u ch'e' cä chenla tu q'uini ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pasi ya'i aj Jesús, bixi tama ni ch'uj taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ajni ya'i untu winic tiquin untz'it u c'äb. Aj fariseojob u c'atbijob aj Jesús ca'da: ―¿Utz quira tz'äcälcac untu winic tu q'uin ch'ämbäji? ―U c'atbijob ca'da uc'a u jiranob si ajnic cache'da u sube'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aj Jesús u p'albijob ca'da: ―Caba winic de anela que u cänäntan untu yoc oveja si yälic tama ch'en tu q'uini ch'ämbäji, ¿mach quira uxin u pa'sen jinchichba q'uin? ");
INSERT INTO chfNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pues, más u chen vale untu winic que untu oveja. Tic ta' c'ajalinla jiq'uin cache' utz chich cä cherbenla ump'e bien cä lotla tu q'uin ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","De ya'i aj Jesús u yälbi ni winic tiquin u c'äbba: ―Sätz'ä a c'äb. Une u sätz'i. Jinchichba hora jini u yäq'ui uba jini u c'äb. Coli utz ca' chich ni otro untz'itba. ");
INSERT INTO chfNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pasijob aj fariseojob u ch'e' u c'ajalinob cache'da u ch'e' u tzämsenob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yuwi chich aj Jesús cua' an tu c'ajalinob. Jin uc'a pasi ya'i. Noj q'uenel gente u bixe tu pat. Aj Jesús u tz'äcälin upete machcatac c'ojo. ");
INSERT INTO chfNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","U bon älbijob jini machcatac u tz'äcäliba que mach xic u tz'aycunob une. ");
INSERT INTO chfNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ca' jini pasi toj jini u yäli aj Isaías, ajt'an ta Dios oniba, jinq'uin u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Iranba, jinda ni cajpatan cä täsquiba, jini cä yaqui no'onba. Uneba tä' acä yajna'tan y u ch'a'alesben ujin cä pixan. Cä xe cäq'ue' cä Ch'u'ul Pixan tuyac'o. Uneba u xe u yälben aj gentilob camba ni u toja. ");
INSERT INTO chfNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mach uxin u chen cua' t'oc jobole ni t'oc noj t'an. Niuntu mach uxin u yubin u t'an tä calle. ");
INSERT INTO chfNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Uneba utz u c'ajalin t'oc upete. Ca' a wälä untz'it oj p'ojomba mach uxin u nonoj xule'. Jini puy que täpo u chenba, mach uxin u nonoj täpe'. Lo que u xe u chenba, u yäq'ue' tä ute tu toja tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aj gentilob u xe chich u tz'ombenob une. ");
INSERT INTO chfNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","De ya'i u täsijob bajca an aj Jesús untu winic t'oc tzuc pixan tuyac'o, ajchoc' y a'uma' une. Aj Jesús u tz'äcäli, y u täq'ui u chen chanä y u chen t'an. ");
INSERT INTO chfNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Upetejob ni gente tajch'icwäni u jutob, y u yäle'ob ca'da: ―¿Jinda wäre ni winic u yajlo' aj David u xe tä teba? ");
INSERT INTO chfNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aj fariseojobba, jinq'uin u yubijob ca' jini, u yälijob ca'da: ―Jindaba mach t'oc u poder Dios u pa'sen tzuc pixanob. U pa'sen t'oc u poder aj Beelzebú, ni ajnoja tuba tzuc pixanobba. ");
INSERT INTO chfNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aj Jesús yuwi chich cua' an tu c'ajalinob, u yälbijob ca'da: ―Ump'e noj caj, si u jec'lan uba tä jo'yanba, mach u paq'uin col u yajmanda y u laj xupojob chich. Che' chich täcä ump'e bit caj o machcatac an tama ump'e otot, si u jec'lan ubajob tä buya, mach uxin tä colan tomp'ejob. ");
INSERT INTO chfNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Si aj Satanás u pa'sen aj Satanás, ca' jini une chich u jeq'ue' uba. Si ca' jini u chenba, ¿cache'da u xe u ch'e' u chen segui de ajmanda tuba ni tzuc pixanob? ");
INSERT INTO chfNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Si no'on cä pa'sen tzuc pixan t'oc u poder aj Beelzebú, ¿ca t'oc u poder jiq'uin u pa'senob a wajcänt'anla ane? Unejob jiq'uin u xe u yäle' camba ni u toja. ");
INSERT INTO chfNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","No'on t'oc u poder chich ni u Ch'u'ul Pixan Dios cä pa'sen tzuc pixan, y si ca' jiniba, Dios chich une ac'oti tuba u chen manda bajca anetla. ");
INSERT INTO chfNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Cache'da a wäle'la jiq'uin? ¿U ch'e' quira ochic ajxuch' tama u yotot untu winic mäx q'uen u muc'ba sin que mach u cäche' najtäcä u yum jini otot? Si u cäche' najtäcäba, u ch'e' u xuch'ben upete lo que u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Machca mach'an t'oc no'on, contra de no'on ayan. Machca mach u täclon cä mote', u laj äc'ben u puclan ubajob ni an t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Jin uc'a cälbenetla cache' upete tanä y cräxt'an que u chen winic u yute chich perdona. Pero machca u cäräx älben ni Ch'u'ul Pixanba mach uyut perdona une. ");
INSERT INTO chfNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Machca chichca u yäle' algún tzuc t'an täjcac'o, no'on que sutwänon de winic, u cherbinte chich perdona. Pero jini u chen algún tzuc t'an tuyac'o ni Ch'u'ul Pixanba, mach ucherbinti perdona une, ni bada, y ni q'uin que ya'to u teba. ");
INSERT INTO chfNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Jinq'uin a päq'ue' untec te' utzba, utz chich u jut u yäq'ue'. Jinq'uin a päq'ue' untec te' mach utzba, mach utz u jut u yäq'ue'. Por u jut chich une a chen conoce cua'ba te' jini. Y ca' jini täcä por cua' u chen untu winic, a wi chich si tu toja ayan. ");
INSERT INTO chfNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Anela ca' a wälä yoco chanetla. Si ca' jini ayanetla, mach'an cache'da a wäle'la cua' chichca utz uc'a malujetla. Uc'a ca' chich an tan cä c'ajalinla, che' chich cäle' t'oc cä ti'la. ");
INSERT INTO chfNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Machca utz u c'ajalinba, jin chich ni an tan u c'ajalin utztacba, jin chich u yäle'. Machca mach utz u c'ajalinba, jin chich ni an tan u c'ajalin mach utztacba, jin chich u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cälbenetla que upete päpä' t'an que cä chenla, tu c'ote u q'uini ni toji'tanä, no'onla chich cä xe tä äc'binte cäle' cua' uc'a cälila ni t'an jini. ");
INSERT INTO chfNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Uc'a upete ni t'an a wäle'la pancabba, Dios chich u xe u jiran si utz o si mach utz ni t'an a chila. Si utz ni t'an a chiba, Dios u xe u yäle' que tu toja ayanet. Si mach utzba, une chich u xe u yäc'benet a castigola. ");
INSERT INTO chfNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yebejob jini machcatac tä' yuwi ni ley taj Moisés y aj fariseojob täcä u yälbijob aj Jesús ca'da: ―Maestro, co t'ocob a chen ump'e milagro tuba cä chänen t'ocob si totoj Dios chich u täsquet. ");
INSERT INTO chfNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aj Jesús u p'ali, u yälbijob ca'da: ―Machcatac pancab tä' malojob, que mach u ni' tz'ombejob u t'an ni mero Diosba, tä' yojob u chänen ump'e milagro. Mach uxin tä äc'binte u chänen niump'e cua' jini u c'atänob uneba. Ni u xe tä äc'binte u chänenba, sec' jini ca' u chi pasa aj Jonás ajt'an ta Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ca' chich aj Jonás ajni tama u näc' noj gran buch' uxp'e q'uin y uxp'e ac'äb, che' chich täcä no'on que sutwänon de winicba cä xe tä ajtä mero yaba cab uxp'e q'uin y uxp'e ac'äb. ");
INSERT INTO chfNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aj Nínivejob nämte' t'oc anela u xe tä c'ote tu pänte' Dios tu q'uini ni toji'tanä. T'oc lo que u chijob u xe tä ircan cache' mach a chila tu toja, uc'a unejobba u q'uexi u c'ajalinob jinq'uin u tz'aycäbijob u t'an Dios aj Jonás. Ubinla jiq'uin, wida ya'an untu ajt'an ta Dios más an u poder que aj Jonás. ");
INSERT INTO chfNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ni no' ixmanda tama ni noj cab tä Sur u xe tä c'ote nämte' t'oc anela tu pänte' Dios tu q'uini ni toji'tanä. T'oc lo que u chi uneba u xe tä ircan cache' mach a chila tu toja, uc'a uneba ya' ti ixta tu xupiba u pancab tuba u yubin u t'an aj Salomón, ni q'uen u c'ajalinba. Ubinla, wida ya'an untu más an u c'ajalin que aj Salomón. ");
INSERT INTO chfNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Jinq'uin u pase ni tzuc pixan tuyac'o untu winic, u nume bajca paq'uin tiquin cab. U sacän bajca u xe u ch'e' uba, y mach u pojle. ");
INSERT INTO chfNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","De ya'i u yäle' ca'da: “Acä sujtä tä oche tuyac'o ni winic bajca pason”. Jinq'uin u c'ote u chänen cache' ayan chich lugar bajca u yajtä, ca' a wälä tä' ti'i misi y tä' pitzi jele. ");
INSERT INTO chfNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","De ya'i u pase u ch'e' otros siete u lot más malo que uneba tuba ochicob tama ni winic jini. Jini winic u colan más peor que ajni najtäcäba. Ca' jini chich u xe u chenet pasa anela con to'o a lotla que ya'an bada tä' malojobba. ");
INSERT INTO chfNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jinq'uin aj Jesús mu'to u t'an t'oc ni noj q'uenel gente, jimba hora jini c'oti u na' y u jitz'inob. Ya' wa'ca pätijob, u yoli u pecänob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Untu winic u yälben aj Jesús ca'da: ―Ubixto, ya'an a na' y a witz'inob päti. Yojob u pecänet. ");
INSERT INTO chfNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","U yubi aj Jesús jini u yälbiba, y u p'albi ca'da: ―¿Caxca une cä na', y caxca une ni quitz'inob? Jindajob chich. ");
INSERT INTO chfNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","De ya'i u sätz'i u c'äb u ye'e' u yajcänt'anob, u yäle' ca'da: ―Ubinla. Pero jindajob täcä es ca' a wälä cä na' y quitz'inob. ");
INSERT INTO chfNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Uc'a upete machca u chen ca' chich yo utic ni cä Pap ya'an tä cieloba, jin une ni quitz'in, y cä säcun y cä chich, y cä na'. ");
INSERT INTO chfNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jinchichba q'uin jini pasi aj Jesús tama ni otot jini, bixi tä chumtä tu ti' nab. ");
INSERT INTO chfNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Noj q'uenel gente c'oti bajca an. Aj Jesúsba ochi tä chumtä tama ump'e noj jucub. Ni noj q'uenel genteba coli tä wa'tä ti' nab. ");
INSERT INTO chfNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Cayi u yälbenob q'uen cua' chichca, u ye'benob u t'an Dios t'oc tz'aji. U yälbenob ca'da: ―Ubinlaba. Ajni untu ajpäc'äb, bixi u t'it'ben u jut päc'äbi uc'a wetic. ");
INSERT INTO chfNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jinq'uin mu'to u t'it'änba, ximlaj yäli tan bij. De ya'i jaqui mutob isqui u laj buq'ue'. ");
INSERT INTO chfNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ximlaj yäli bajca an q'uen ji'tun, bajca mach totoj ayan cab utz. De ya'i seb weti uc'a mach xi tam tä cab. ");
INSERT INTO chfNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","De ya'i pasi noj ticäw q'uin, u puli jini päc'äbi uc'a mach'an tam u wi' tä cab. Jin uc'a tiqui. ");
INSERT INTO chfNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ximlaj yäli tama chäcch'ix. De ya'i c'ac'a' ch'iji ni chäcch'ix, u bisi yaba ni päc'äbi tuba mach ch'ijic. ");
INSERT INTO chfNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ximlaj yäli bajca an cab utzba. U yäq'ui chich u jut. Untec u yäq'ui cien u jut. Otro untec u yäq'ui sesenta u jut. Otro untecba u yäq'ui treinta u jut. ");
INSERT INTO chfNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Äc'ä a chiquin tuba a ubinla utz y tic ta' c'ajalinla cua' mu' cälbenetla. ");
INSERT INTO chfNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","De ya'i u natz'ijob u yajcänt'anob, u yälbijob ca'da: ―¿Cua' uc'a a wälbenob ni gente u t'an Dios t'oc tz'aji que mach cheque cua' u yäle'? ");
INSERT INTO chfNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aj Jesús u p'ali u yälbijob ca'da: ―Anelaba a'bintet a wina'tanla jini que mach uyut entende ajniba, cache'da u xe u nonoj chen manda ni Dios tä cieloba bajca anetla. Unejobba mach äc'binti yuwina'tanob. ");
INSERT INTO chfNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Machca chichca que u yäq'ue' u c'ajalin tuba u yubin cua' cä ye'e', Dios u xe u yäc'ben u cäne' más. Machca chichca que mach u yäc'ä u c'ajalin tuba u yubin cua' cä ye'e'ba, ixta lo que u cäni u xe tä laj äc'binte u najyesan. ");
INSERT INTO chfNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jin uc'a cälbenob u t'an Dios t'oc cua' chichca tz'aji, uc'a tu chänenob ca' a wälä mach u chänejob cua', y tu yubinob mach uyoch tu c'ajalinob y mach u chen entendejob. ");
INSERT INTO chfNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","De jinchichba gente jini u yäli aj Isaías ajt'an ta Dios oniba jinq'uin u yäli ca'da: T'oc a chiquin a xe a ubinla y mach uyoch ta' c'ajalinla. T'oc a jut a xe a chänenla y mach uta ta' c'ajalinla cua' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Uc'a ni genteda, alaj tzätz'i u pixanob. Mach u totoj äc'ä u chiquinob tuba u yubin. Ca' a wälä u mäqui u jutob y u chiquinob uc'a mach u chänen cua' t'oc u jutob, y mach u yubin cua' t'oc u chiquin. Mach yojob ochic cä t'an tu pixanob. Mach yojob u q'uexe' u c'ajalinob tuba cä japänob t'oc u tanäjob. ");
INSERT INTO chfNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Anelaba ayan chich a ch'a'aljinla uc'a t'oc a jut a totoj chänenla y t'oc a chiquin a totoj ubinla. ");
INSERT INTO chfNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Totojtoj cälbenetla, q'uen ajt'anob ta Dios oni y machcatac ajni tu toja tu jut Dios tä' u yoli u chänenob jini mu' a chänenla anelaba, pero mach u chänijob. Tä' u yoli u yubinob jini a ubinlaba, y mach u yubijob. ");
INSERT INTO chfNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Ubinla jiq'uin cua' u c'ote t'oc ni tz'aji tajpäc'äb. ");
INSERT INTO chfNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jinq'uin untu winic u yubin u t'an Cajnojala Dios cache' u chen manda uneba y mach u che entende ni t'an jini, u c'ote ni tzuc pixan bajca an ni winic jini u pa'säben tan u c'ajalin ni t'an jini que u yubiba. Jin une ni jut päc'äbi que yäli tan bijba. ");
INSERT INTO chfNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ni jut päc'äbi que yäli tan ji'tunba, jin une machca u yubin u t'an Dios y t'oc noj ch'a'aljin u sapän. ");
INSERT INTO chfNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero mach u nonoj col tan u pixan. Tä' seb u pase, uc'a jinq'uin u te cua' chichca u bäc'tesben u pixan o cua' chichca tz'ibajtesia uc'a u sapi ni t'an jiniba, ca' jini seb u sujtä tu pat. ");
INSERT INTO chfNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jini jut päc'äbi yäli tan ch'ixba, jin une ni machca u yubin u t'an Dios. De ya'i u tz'eje' uba t'oc uc'a u sinlaj chen pensa q'uen cua' chichca y uc'a u c'upän q'uen taq'uin. Más u yäq'ue' tu c'ajalin upete ni jini que u t'an Dios, y ca' jini mach u ch'ä u chen niump'e cua' ca' yo Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jini jut päc'äbi que yäli bajca an cab utzba, jin une ni machca u yubin u t'an Dios y u c'alin tz'onän, y ca' jini u t'an Dios u yäq'ue' más y más tu toja jini winic. Es ca' a wälä untec päc'äbi que u yäq'ue' q'uen u jut. Untec u yäq'ue' cien u jut. Otro u yäq'ue' sesenta u jut. Otro u yäq'ue' treinta u jut. ");
INSERT INTO chfNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","De ya'i aj Jesús u yälbijob otro tz'aji ca'da: ―U manda ni Dios ya'an tä cieloba es ca' untu winic u päq'ui u jut u päc'äbi utzba tan u cab. ");
INSERT INTO chfNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ump'e ac'äb, jinq'uin upete mu' u wäye, ti untu u lot que mach u bisa bij t'ocba, u päc'bi u jut tzuc bänäla tama u päc'äbi ni winic. De ya'i bixi tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jinq'uin t'äbäli ni päc'äbi, u chi u jut. Ya'i checti ni bänäla täcä tama ni päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","U yajpatanob ni winic u yum päc'äbiba c'otijob u yälben ca'da: “Cajnoja, ¿mach quira a päq'ui yajän trigo tan a cab? ¿Cua' uc'a jiq'uin aweti tzuc bänäla täcä?” ");
INSERT INTO chfNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Une u yälbijob ca'da: “Untu cä lot que mach u bisa bij t'oc no'onba u cherbon ca' jini”. Ni u yajpatanob u yälbijob ca'da: “¿A wo quira bada xicon cä boque' t'ocob ni tzuc bänäla jini?” ");
INSERT INTO chfNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Une u yälbijob ca'da: “Mach, mach me'ixto ta' boque'la ni tzuc bänäla jini, a teclaj boque'la ni trigo täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Äctan que ch'ijic u chap'elma ixta que c'ä'nac u jut. Tu xe tä ch'uch'inte u jut jini päc'äbi, cä xe cälben ni cajpatanob ca'da: Bocola najtäcä ni tzuc bänäla jini, y cächäla ajunjob tuba pulcac. Ni trigoba, ch'uch'änla tuba a wosenla tama ni otot bajca u ch'ujninte u jut ni päc'äbi”. ");
INSERT INTO chfNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","U yälbijob tä cha'num otro ump'e tz'aji ca'da: ―U manda Dios bajca anonla pancab es ca' unxim yoc bec' mostaza, que u ch'e' untu winic tuba u päq'ue' tan u cab. ");
INSERT INTO chfNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ni bec' mostazaba más p'i' une que upete u bec' päc'äbi. Pero jinq'uin u weteba, noj u ch'ije. Más noj u te'e une que upete päc'äbi. Ixta mut isqui u c'ote u chen u c'ub tama u te'e. ");
INSERT INTO chfNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Otro ump'e tz'aji u yälbijob tä cha'num ca'da: ―U manda ni Dios ya'an tä cieloba es ca' jini u yä'can tan waj tuba u yäc'ben jusicba. Jinq'uin untu ixic u ch'e' tz'ita' u yäq'ue' tama uxp'e noj t'ub de harina, de ya'i u laj xabän uba t'oc y u jusesan. ");
INSERT INTO chfNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Upete ni t'anda aj Jesús u yälbijob ni gente t'oc tz'aji que mach u se'in och tu c'ajalin untu cua' jini. Mach u yälbijob niump'e cua' sin que mach t'oc jini tz'aji. ");
INSERT INTO chfNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ca' jini pasi toj jini u tz'ibi ajt'an ta Dios oniba jinq'uin u tz'ibi ca'da: Cä xe cä ye'e' u t'an Dios t'oc tz'aji que mach u se'in och tu c'ajalin untu cua' jini. Cä xe cäle' ni mach bay ubqui oniba ixta bada. ");
INSERT INTO chfNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jinq'uin aj Jesús u laj täsqui ni gentejob bixic, ochi une tan otot. U yajcänt'anob u natz'ijob, u yälben ca'da: ―Älbenon t'ocob cache'da ni bäläb tz'aji tuba ni tzuc bänäla pä'qui tan trigoba. ");
INSERT INTO chfNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aj Jesús u p'albijob ca'da: ―Machca u päq'ue' ni trigoba, no'on une que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","U caba ni päc'äbiba, u pancab une. Jini jut päc'äbi utztacba, jin une ni u ch'ocob Diosba. Jini tzuc bänälaba, jin une ni u ch'ocob tzuc pixan. ");
INSERT INTO chfNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jini winic que u päq'ui tzuc bänäla tama u päc'äbi u lot uc'a mach yo u chänenba, tzuc pixan une. U q'uini ta ch'uch'intic u jut ni trigoba, u xupiba q'uin tu pancab une. Ni ajpatanob u ch'uch'ben u jut trigoba, u yajc'äncanob Dios une. ");
INSERT INTO chfNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ca' chich u bojcan ni tzuc bänäla y u julcan tama c'ac' tuba pulicba, che' chich u xe u chen pasa tu xupiba q'uin tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","No'on que sutwänon de winicba cä xe cä täscun cajc'äncanob tuba u pa'sen bajca u chen manda Dios upete jini u yäc'ben u säte' machcatac an tu tojaba, con to'o jini mach u che tu toja täcäba. ");
INSERT INTO chfNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Cajc'äncanob u xe u jule'ob tan c'ac' upete ni jinijob. Ya'i u xe u chen uq'uejob y u xe u chen cäch'äcne yejob. ");
INSERT INTO chfNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jinq'uinba u xe tä chäninte cache' an u pitzilan Dios tuyac'ojob upete machcatac u chen tu toja. Ca' chich u chäninte ni junch'äcni tuba q'uin, che' chich u xe tä chäninte ni u pitzilanob bajca u chen manda cä Papla Dios. Äc'ä a chiquin tuba a ubinla utz y tic ta' c'ajalinla cua' mu' cälbenetla. ");
INSERT INTO chfNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’U manda ni Dios ya'an tä cieloba u c'ote t'oc ca' q'uen taq'uin que ya' mucu yaba cabba. Jinq'uin untu winic u pojlen, de ya'i u sujtä u cha'num muque'. U bixe tu yotot t'oc noj ch'a'aljin u chone' upete lo que u cänäntan tuba u mäne' ni cab jini bajca u pojli ni taq'uin jini. ");
INSERT INTO chfNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’U manda ni Dios ya'an tä cieloba u c'ote t'oc ca' ni perla tä' pitziba que u sacän untu ajman tuba u mäne'. ");
INSERT INTO chfNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jinq'uin u pojlen unxim que tä' choj u valorba, u bixe u chone' upete lo que u cänäntan tuba u mäne'. ");
INSERT INTO chfNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’U manda ni Dios ya'an tä cieloba u c'ote t'oc ca' ump'e chim ta q'uechi' buch' täcä. Jinq'uin u julcan ni chim tama nab, tomp'e u yoche tama ni chim buch' ta c'uxcacba y jini que mach u c'uxcaba. ");
INSERT INTO chfNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cuanta u chänijob ni ajq'uech buch'ob cache' atuliba, u t'äbsenob tä cab. De ya'i u chumtäjob u ch'uch'änob ni buch' utztacba u yäq'ue' tan chach. Ni mach utztacba u choque'ob une. ");
INSERT INTO chfNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Che' chich u xe u chen pasa tu xupiba q'uin tu pancab. U xe tä tejob ajc'äncanob ta Dios u pa'senob ni machcatac mach u chi tu tojaba bajca ya'anob nämte' t'oc machcatac ayan tu tojaba. ");
INSERT INTO chfNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jini machcatac mach u chi tu tojaba u xe tä julcan tama noj ticäw c'ac'. Ya'i une u xe u chen uq'uejob y u xe u chen cäch'äcne yejob. ");
INSERT INTO chfNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aj Jesús u c'atbijob ca'da: ―¿A'ochi ta' c'ajalinla upete ni acälbetlaba? Unejob u p'ali: ―A'ochi chich. ");
INSERT INTO chfNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aj Jesús u yälbijob ca'da: ―Utz chich, uc'a upete machcatac yuwi ni ley taj Moisés, y bada u cäne' cache'da an u manda ni Dios ya'an tä cieloba, es ca' untu winic ajnoja tuba ump'e otot que mäx utz upete lo que u cänäntanba. Une u ch'e' u yäc'ben u lot cua' chichca u cänäntan tzijib o jelem. ");
INSERT INTO chfNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jinq'uin u tzupsi u yäle' upete ni tz'aji jini, aj Jesús pasi ya'i, bixi tu cab. ");
INSERT INTO chfNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tu c'ote tu cabba, u ye'e' u t'an Dios tama u ch'ujob ni aj judíosob ya'i. Tajch'icwäni u jutob u yubinob u t'an y u yäle'ob ca'da: ―¿Cada u c'ac'a' ch'i ni c'ajalin jini? ¿Caxca u yäc'bi poder u chen jini que mach bay uchänintiba? ");
INSERT INTO chfNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Mach quira jinda u yajlo' ni ajpälte' u c'aba' aj Joséba? ¿Mach quira ix María u c'aba' u na', y u jitz'inobba aj Jacobo, aj José, aj Simón, y aj Judas? ");
INSERT INTO chfNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Mach quira nämte' t'oc no'onla täcä la'anob jitz'inob ixictac? ¿Cada jiq'uin u c'ac'a' cäni upete cua' chichca que u chen? ");
INSERT INTO chfNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mach u ni' olijob u yubinob u t'an. Aj Jesúsba u yälbijob ca'da: ―Untu ajt'an ta Dios sec' tan yotot y tan u cab mach totoj yo u yubinob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mach u chi q'uen cua' chichca tuba chäncac u poder ya'i uc'a mach u totoj tz'ombejob. ");
INSERT INTO chfNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jimba q'uin jini aj Herodes gobierno tama ni cabob jini tä Galilea u yubi cua'tac u nume u chen aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","U yälbi u yajpatanob ca'da: ―Jini winic jini aj Juan ajc'ablesia une, acuxpi tan ajchäme. Jin uc'a ya'an poder tuyac'o tuba u chen ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aj Herodes u yäli ca' jini uc'a une ni u yäq'ui tä q'uechcan aj Juanba. U yäq'ui tä cächcan t'oc cadena y u yäq'ui tä äc'can tama cárcel, uc'a che' u c'ati ix Herodías jit'oc aj Felipe u jitz'in chich aj Herodesba. ");
INSERT INTO chfNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Uc'a aj Juanba xi u yälben aj Herodes ca'da: ―Mach utz a ch'ämben u jit'oc a witz'in tuba a wit'oc. ");
INSERT INTO chfNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aj Herodesba u yoli u tzämsen aj Juan uc'a xi u yälben ca' jini, pero bäc'ta t'oc gente uc'a ni genteba u yäle'ob cache' aj Juan es untu ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jinq'uin u chi u q'uin aj Herodesba, u jixic ch'oc ix Herodías pasi tä ac'ot tänxin ni gente. U c'ac'a' ch'a'alesbi ujin aj Herodes u chänen ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Uc'a tä' u ch'a'alesbi ujin, u yälbi cache' u xe u yäc'ben lo que u yolin u c'atän jini telom. Ixta ump'e t'an u yäli uc'a tz'onintic cache' toj chich. ");
INSERT INTO chfNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jini telomba, u worin älbi chich u na' cua' jini u xe u c'atän. Jin uc'a u yäli ca'da: ―Äc'benon wida bada tama ump'e plato u pam aj Juan ajc'ablesia. ");
INSERT INTO chfNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","De ya'i ni ajnoja jini aj Herodesba ch'ocomi u pixan jinq'uin u yubi cua' u c'ati. Pero uc'a jini t'an u yäli tuba tz'onintic cache' u xe chich u yäc'ben lo que u c'atänba, y uc'a täcä ni gente que ya'an u yubinob, u yäq'ui chich tä ute ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","U täsqui tä chunjätz'binte u pam aj Juan bajca an tan cárcel. ");
INSERT INTO chfNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","U täsijob u pam aj Juan tama ump'e plato y u yäc'bijob ni telom. Cuanta u ch'i ni telomba, bixi u yäc'ben u na'. ");
INSERT INTO chfNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","De ya'i c'oti u yajcänt'anob aj Juan u ch'ämbijob u cuerpo y u mucbijob. Ji'pat bixijob u yälben aj Jesús cua' u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jinq'uin u yubi aj Jesús cache' ca' jini u chi pasa, ochi tama ump'e jucub tuba bixic otro cab bajca mach cuxu niuntu, uc'a ajnic u juntuma ya'i. Jinq'uin u yubi ni gente cada u bixe, pasijob tan u cäjijob, bixijob tä cäble tuba c'oticob täcä bajca u bixe aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jinq'uin c'oti ya'i aj Jesús t'äbi tä cab, y u chäni noj q'uenel gente. U ch'ämbi yajinob. U tz'äcäli machcatac c'ojojob. ");
INSERT INTO chfNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A'ochi q'uin, u yajcänt'anob aj Jesús u natz'i u yälben ca'da: ―Bajca anonlaba mach nätz'ä ayan otote, y atarde'i bada. Täscun jiq'uin ni noj q'uenel gente bixicob ixta bajcatac an bit caj tuba u mäne'ob cua' u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aj Jesús u yälbijob ca'da: ―Mach'an cua' uc'a bixicob. Äc'benla ane cua' u c'uxe'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Unejob u p'albijob ca'da: ―Mach cä cänänta t'ocob cua' wida, sec' cinco waj y cha'tu yoc buch'. ");
INSERT INTO chfNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aj Jesús u yälbijob ca'da: ―Täsbenonla wida ni waj y ni buch'. ");
INSERT INTO chfNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","U yälbi ni gente chunwänicob tu pam bänäla. De ya'i u ch'i ni cinco waj y cha'tu buch', u t'äbsi u jut tä cielo, u ch'u'ul chi. De ya'i u taji ni waj y u yäc'bi u yajcänt'anob tuba u yäc'benob ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","C'uxni upetejob ni gente y laj na'ijob. U yajcänt'anob aj Jesús u motíjob u colob ni waj y buch' doce nuc chach tulujtac. ");
INSERT INTO chfNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jini gente c'uxnijobba, ca' ta cinco mil wincäre. Cuxnijob täcä q'uen ixictac y che' bijch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jinchichba rato jini aj Jesús u yälbi u yajcänt'anob ochic tama ump'e jucub bixicob tunxe nab tuba u pijnanob ya'i, y uneba u xe tä nebaj colan u täscun bixicob ni gente tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cuanta laj bixijob ni gente, bixi une u juntuma tu pam ump'e tz'ic u chen c'änti'ya ya'i. Tu yoche ac'äbba, ya' chich to an une u juntuma ya'i. ");
INSERT INTO chfNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ni jucub bajca u bixejob u yajcänt'anobba, ya' tzäcä to u xe tänxin nab. Noj gran t'olja' u jätz'e' uba tuyac'o ni jucub, uc'a ni ic' täcä ya' u yustan bajca u bixejob. ");
INSERT INTO chfNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tu chämp'elib u yuq'ue piyo' aj Jesús bixi u tzäc'ben u patob, t'oc xämba tu pan ja' tama ni nab. ");
INSERT INTO chfNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","U yajcänt'anob, jinq'uin u chänijob cache' ya' u te untu tä xämba tu pan ja', c'ac'a' bäc'tijob. U yäle'ob ca'da: ―¡No' ajbäc'tesia ni jini! ―U chijob noj awät de bac'ät. ");
INSERT INTO chfNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jinchichba rato jini aj Jesús u pequijob, u yälbijob ca'da: ―Mach'an cua'. No'on chich. Mach bäc'taquetla. ");
INSERT INTO chfNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aj Pedroba u yälbi ca'da: ―Cajnoja, si totojtoj que ane chichba, älbenon que ticon bajca anet t'oc xämba pan ja' täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aj Jesús u yälbi ca'da: ―La'ix jiq'uin. De ya'i aj Pedro pasi tama ni jucub, cayi u chen xämba pan ja' tuba xic bajca an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Jinq'uin u chäni aj Pedro noj gran ic' tama nab, sujli tä bäc'tan. U täq'ui jome tä ja'. De ya'i t'oc noj t'an u yäli ca'da: ―¡Cajnoja, japänon! ");
INSERT INTO chfNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jinchichba rato jini, aj Jesús u sätz'i u c'äb u q'ueche', u yälben ca'da: ―¿Cua' uc'a asujlet tä bäc'tan? ¿Mach quira a totoj tz'onä? ");
INSERT INTO chfNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jinq'uin aj Jesús y aj Pedro t'äbijob tama ni jucub, ch'ijcäbi täcä ni ic' tama ni nab. ");
INSERT INTO chfNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","De ya'i upete machca u bixe tama ni jucub jini u täq'ui u ch'u'ul c'ajti'inob, u yälbenob ca'da: ―Totojtoj chich, aneba u Yajlo'et chich Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jinq'uin c'axijob tunxe nab, c'otijob bajca an ni cab u c'aba' Genesaret. ");
INSERT INTO chfNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A'ajtäjob ya'i, jinq'uin u chänijob cache' aj Jesús ni c'otiba, u täsquijob razón tä cabil cab. Ajcabil cabobba u täsijob upete ajc'ojpanob bajca an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","U ch'oc chen ubajob t'oc, u yälbenob que u yäctan tälcac sec' u ti' u buc uc'a u pojlen ubajob. Upete machcatac u tälbiba, u pojli chich ubajob. ");
INSERT INTO chfNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yebejob jini tä' yuwi ni ley taj Moisés y aj fariseojob tijob tä Jerusalén, c'otijob bajca an aj Jesús. U yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Cua' uc'a a wajcänt'anob aneba mach u chejob ca' chich u yäq'uijob tä ute oni ni ajt'äbälajob tuba aj judíosob? Uc'a a wajcänt'anobba mach u poco u c'äb tu xe tä c'uxnanob ca' chich u yäq'ui tä ute ni ajt'äbälajob. ");
INSERT INTO chfNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aj Jesús u p'ali, u yälbijob ca'da: ―¿Cua' uc'a anelaba mach a tz'ombela u t'an Dios uc'a a tz'onän a chenla ni u yäq'ui tä ute ajt'äbälajob oniba? ");
INSERT INTO chfNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uc'a Dios u yäli que utic ca'da: “Yajna'tan a pap y a na'”. U yäli täcä ca'da: “Machca chichca u cäräx älben u pap y u na', c'änä chich chämic”. ");
INSERT INTO chfNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero anelaba a wäle'la que untu u ch'e' u yälben u na' y u pap ca'da: “Jini cä cänäntanba, tuba cä'ben u matän Dios une. Mach'an cua' t'oc cä täclenet”. ");
INSERT INTO chfNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","T'oc ni u chenba, a wäle'la cache' mach ni' c'änä u chen más cua' por u pap y u na'. Ca' chich jini a wäctila a tz'ombenla u t'an Dios uc'a a chenla ca' chich u yäq'ui tä ute ajt'äbälajob oni. ");
INSERT INTO chfNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ajsusuccheriajetla! De anela une ni u yäli aj Isaías, ajt'an ta Dios oniba jinq'uin u yäli ca'daba: ");
INSERT INTO chfNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jini genteda sec' t'oc u ti' u ch'u'ul c'ajti'inon, pero u pixanba mach totoj ayan t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","U päpä' c'ajti'inonob chich namás. U ye'e'job cache' jin u toja ni u yäq'ue' winicob tä uteba. ");
INSERT INTO chfNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aj Jesús u joq'uijob upete machcatac ya' wa'cajob nat, u yälbenob ca'da: ―Äc'ä a chiquin a ubinla ni cä xe cäle'ba, uc'a ochic ta' c'ajalinla. ");
INSERT INTO chfNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jini u yäc'ben untu winic mach ajnic tu toja, mach jin cua' u c'uxe'. Jini u yäc'ben que mach ajnic tu toja untu winicba, jin une ni u te tu c'ajalin tuba u yäle' t'oc u ti'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","De ya'i u yajcänt'anob u natz'ijob aj Jesús u yälbenob ca'da: ―¿A wi quira que mach yäli utz tu c'ajalin aj fariseojob a t'an jinq'uin u yubijob cache' a wäli? ");
INSERT INTO chfNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aj Jesús u p'albijob ca'da: ―Upete päc'äbi que mach u päq'ui ni cä Pap ya'an tä cieloba, u xe chich tä laj bojcan une. ");
INSERT INTO chfNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mach a chen casola cua' u yäle'ob. Unejobba ca' a wälä ajchoc'job une, ajye'bij tuba ajchoc'job. Si jini ajchoc' u ye'ben bij otro ajchoc', u cha'tuma chich u xe tä pomejob tama ch'en. U cha'tumajob u xe u säte' u bijijob. ");
INSERT INTO chfNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","De ya'i u p'ali aj Pedro, u yälbi aj Jesús ca'da: ―Chectesbenon t'ocob ni a wäli de cua' tä c'uxcanba. ");
INSERT INTO chfNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aj Jesús u yälbijob: ―Anela täcä, ¿mach quira u totoj och ta' c'ajalinla? ");
INSERT INTO chfNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mach quira a wila cache' upete ni u c'uxe' untuba, ya' u xe tan u näc', y de ya'i u chojcan bajca u xe päjna? ");
INSERT INTO chfNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero jini u yäle' untu t'oc u ti'ba, ya' u te tan u c'ajalin. Jin une u yäc'ben que mach ajnic tu toja. ");
INSERT INTO chfNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Uc'a tan chich u c'ajalin untu ayan cua' chichca mach utz. U te tu c'ajalin untu u chen tzämsa, cherajtz'ijte', xuch' ixic, xuch', jop'ojti', cräxt'an. ");
INSERT INTO chfNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jintacda une ni u yäc'ben mach ajnic tu toja untu winic. Pero c'uxnac untu sin que u poque' u c'äbba, mach u yäc'be que mach ajnic tu toja untu. ");
INSERT INTO chfNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pasi ya'i aj Jesús, bixi tu cab aj Tiro y aj Sidónob. ");
INSERT INTO chfNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Untu ixic ix cananea ya' ti tama ni cabob jini c'oti u pecän aj Jesús. T'oc noj t'an u yälbi ca'da: ―Cajnoja, ajlo'et taj David ni reyba, ch'ämbenon yajin. Untu quixic ch'oc tä' c'ojo ayan. Mäx u c'ac'a' tz'ibajtesan tzuc pixan. ");
INSERT INTO chfNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero aj Jesús mach u p'albi ni tz'ita'. De ya'i u natz'i u yajcänt'anob u yälbijob ca'da: ―Chen ca' chich u c'atän ni ixic jini y täscun bixic uc'a mach ni' tic tä t'an täc patla. ");
INSERT INTO chfNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aj Jesús u yäli ca'da: ―Atäsquinton cä täclenob sec' aj Israelob, jini ca' a wälä oveja asätijobba. ");
INSERT INTO chfNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","De ya'i jini ixic u natz'i aj Jesús. Nocwäni tu pänte', u yäle' ca'da: ―Cajnoja, tz'äcälbenon quixic ch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","U p'ali aj Jesús, u yälbi ca'da: ―Mach utz ch'ämcac ni waj tuba u bijch'oc untu y julbintic wichu'. ");
INSERT INTO chfNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jini ixic u p'ali ca'da: ―Toj chich une Cajnoja. Pero ni wichu' täcäba u c'uxe' chich ni u xixoma waj que u yälo yaba mesa bajca an u yum tä c'uxnan. ");
INSERT INTO chfNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jinq'uin u yubi aj Jesús ca' jini, u yälbi ca'da: ―Noxi' ixic, mäx a totoj tz'onän chich. Utic chich ca' chich a wo cherbintiquet. Jinchichba hora jini u yäq'ui uba jixic ch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aj Jesús pasi ya'i, bixi tu ti' nab u c'aba' Galilea. T'äbi tu pam ump'e tz'ic, chunwäni ya'i. ");
INSERT INTO chfNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","C'oti noj q'uenel gente bajca an aj Jesús, y u c'osijob ajc'ol'oc, ajchoc', a'uma', y jini balda'ojtacobba, y q'uen más ajc'ojpanob. U c'osijob tu yoc aj Jesús, y une u laj tz'äcäli. ");
INSERT INTO chfNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ni gente tajch'icwäni u jut u chänen ca' jini. U chänenob cache' a'uma' u chen t'an, cache' ajc'ol'oc u chen xämba, ni balda'ojobba u laj pojlen ubajob. Che' chich täcä ajchoc' u chen chanä. Cayi u ch'u'ul c'ajti'inob Dios, jini Dios tuba aj Israelobba. ");
INSERT INTO chfNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aj Jesús u joq'ui u yajcänt'anob, u yälbijob ca'da: ―Tä' acä ch'ämben yajin upete ni genteda, uc'a u cänäntan uxp'e q'uin ya'anob nämte' t'oc no'on y mach u cänäntajob cua' u c'uxe'. Mach co cä täscunob sin que c'uxnacob uc'a mach xic tä säto u c'ajalinob tä bij. ");
INSERT INTO chfNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","De ya'i u yajcänt'anob u p'ali, u yälbijob ca'da: ―¿Cada cä xe cä ch'e' t'ocob noj q'uenel waj tuba u na'esan ni noj q'uenel genteda? Wida mach'an otote. ");
INSERT INTO chfNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aj Jesús u yälbijob ca'da: ―¿Jäyp'e waj a cänäntanla? Unejob u yäli: ―Sec' siete waj namás, y tz'ita' yoc buch'. ");
INSERT INTO chfNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","De ya'i u yälbi ni gente que chumlecjob tä cab. ");
INSERT INTO chfNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","De ya'i aj Jesús u ch'i ni siete waj y che' chich täcä yoc buch', u c'ajti'bi u c'aba' Dios. De ya'i u taji ni waj. U yäc'bi u yajcänt'anob tuba u puc'ben ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","C'uxnijob chich upete, y laj na'ijob. U yajcänt'anob aj Jesús u ch'uch'ijob u colob ni waj bajca puquintiba, siete nuc chach tulu. ");
INSERT INTO chfNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","U q'ue'na ni gente c'uxnijobba, cuatro mil wincäre une. C'uxnijob täcä q'uen ixictacob y bijch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","De ya'i aj Jesús u täsqui ni gente bixic tu yototob. Uneba ochi tama ump'e jucub, bixi tunxe nab, c'oti tama cab tä Magdala. ");
INSERT INTO chfNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","C'otijob bajca an aj Jesús aj fariseojob y aj saduceojob tuba u jiranob si u ch'e' u yäc'ben u säte'. U c'atbijob que u yäq'ue' tä chäninte ump'e seña tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aj Jesús u p'albijob ca'da: ―Jinq'uin a chänenla noj chächäc bucla tu pome q'uin, a wäle'la cache' ic'ä u chen q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y jinq'uin a chänenla noj q'uenel chächäc bucla tä cielo ic'sapanba a wäle'la ca'da: “U xe u yäc'ben ja'”. ¡Ajsusuccheriajetla! A wila chich cua' u xe tä ajtä jinq'uin a chänenla tä cielo ca' jini. ¿Cuaxca uc'a jiq'uin mach uta ta' c'ajalinla cua' uc'a u yäq'ui tä ute Dios upete ni mu' cä chenba? ");
INSERT INTO chfNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Machcatac pancab tä' malojobba que mach u ni' tz'ombejob u t'an ni mero Diosba u c'atänob ump'e seña tuba u chänen. Mach uxin tä äc'bintejob otro seña, sec' jini ca' u chi pasa aj Jonás, ajt'an ta Diosba. De ya'i aj Jesús u yäctijob, bixi. ");
INSERT INTO chfNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","C'otijob u yajcänt'anob aj Jesús tunxe nab. Mach u bisijob caxtran waj uc'a najyi uc'ajob. ");
INSERT INTO chfNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aj Jesús u yälbijob ca'da: ―Iranla, mach me'ixto a ch'e'la jini jusonib ta waj que u c'äne'ob aj fariseojob y aj saduceojob, uc'a mach utz une. ");
INSERT INTO chfNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","U yajcänt'anob aj Jesús cayi u maläc äle'ob tan u c'ajalinob ca'da: ―Jini t'andaba u yäle' uc'a anajyi cäc'ala cä täsenla caxtran waj. ");
INSERT INTO chfNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yuwi chich aj Jesús cua' an tu c'ajalinob. U yälbijob ca'da: ―¿Cua' uc'a a chen pensala uc'a mach a täsila waj? ¿Mach to quira a totoj tz'onäla? ");
INSERT INTO chfNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mach to quira uta ta' c'ajalinla cache' ayan cä poder cä chen cua' chichca? ¿Mach quira ni' c'aja ac'ala cache' u chi pasa t'oc ni cinco waj que c'uxnesqui t'oc cinco mil winicob, y jäyp'e chach u colob a ch'uch'ila? ");
INSERT INTO chfNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Mach quira ni' c'aja ac'ala täcä cache' u chi pasa t'oc ni siete waj que c'uxnesqui t'oc cuatro mil winicob, y jäyp'e chach u colob a ch'uch'ila? ");
INSERT INTO chfNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mach uyoch ta' c'ajalinla lo que mu' cälbenetla. Jini cälbetla ca'da, que mach a ch'e'la ni jusonib ta waj que u c'äne'ob aj fariseojob y aj saduceojob, mach uc'a mach a täsila waj cälbetla ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jinq'uin ti tu c'ajalinob que mach jin jusonib ta waj u yälbijob. Jini u yälbijobba que mach xic u sapänob ni t'an u ye'e' aj fariseojob y aj saduceojob. Ni t'an que u ye'e'job unejobba es ca' a wälä ni jusonib ta waj. ");
INSERT INTO chfNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jinq'uin c'oti aj Jesús tama ni caj u c'aba' Cesarea Filipo, u c'atbi u yajcänt'anob ca'da: ―¿Cache'da u yäle' ni gentejob caxcajon, no'on que sutwänon de winic? ");
INSERT INTO chfNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Unejob u yälbijob ca'da: ―U yäle'ob cache' aj Juan ajc'ablesialet. Otrosjob u yäle' cache' aj Elíaset. Otrosjob u yäle' cache' aj Jeremíaset, o algún otro ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","De ya'i aj Jesús u c'atbijob tä cha'num ca'da: ―Y anelaba, ¿caxcajon a wäle'la? ");
INSERT INTO chfNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","U p'ali aj Simón Pedro u yälbi ca'da: ―Aneba aj Cristojet, u Yajlo'et ni Dios cuxuba. ");
INSERT INTO chfNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aj Jesús u yälbi ca'da: ―Ya'an ump'e ch'a'aljin ta'a, Simón, ajlo'et taj Jonás, uc'a mach jin winic pancab u yäc'bet ta' c'ajalin tuba a wina'tan ca' jini. Cä Pap, jini ya'an tä cieloba, une u yäc'bet a wina'tan. ");
INSERT INTO chfNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","No'on täcä cälbenet cache' aneba aj Pedrojet. Ni a c'aba' jiniba u ye'e' cache' ca' a wälä ji'tunet. Y por ane u xe tä ajtä q'uen machca u xe u tz'ombenon. Chämoba mach uxin u chen trebe u tzupsen machcatac u tz'ombenon. ");
INSERT INTO chfNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ane cä xe cä'benet poder, ca' a wälä cä'benet llave tuba bajca u chen manda ni Dios ya'an tä cieloba. Jini a wäle' cache' mach utz ta utic pancab, Dios täcä che' chich u xe u yäle'. Jini a wäle' cache' utz utic pancab Dios täcä che' chich u xe u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","De ya'i aj Jesús u c'alin älbi u yajcänt'anob que mach xic u yälben niuntu si une ni aj Cristo, ni u täsqui Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde jimba q'uin jini aj Jesús u täq'ui u chectesben u yajcänt'anob cache' c'änä xic tä Jerusalén tuba c'ac'a' tz'ibajtescac ya'i tu c'äbob ajt'äbäla, tu c'äb ajnojajob pale, y tu c'äb jini que tä' yuwijob ni ley taj Moisésba. C'änä tzämsintic täcä, y u yuxp'elib q'uin u xe tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","De ya'i aj Pedro u tz'eji uba nämte' t'oc tz'ita' u ch'oc chen uba t'oc, u yälben ca'da: ―Cajnoja, Dios u cänäntanet. Iran que mach xic u chenet pasa ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aj Jesúsba u suti uba, u yälben aj Pedro ca'da: ―Pasen bajca anon, Satanás. Ane a wo a ch'acbenon cä biji, uc'a ane mach a wäc'ä ta' c'ajalin jini yo Dios uticba. Aneba a wäq'ue' ta' c'ajalin jini yo winicob pancab uticba. ");
INSERT INTO chfNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","De ya'i aj Jesús u yälbi u yajcänt'anob ca'da: ―Machca chichca yo ochic de cajcänt'anba, c'änä u yäctan u chen uba manda u juntuma. C'änä u c'älen cua' chichca tz'ibajtesia ca' chich cä c'älen no'on y u tzäypätinon. ");
INSERT INTO chfNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Uc'a upete machcatac u sacän cache' cuxlec utz pancab, u xe u säte' upete ni jini. Upete machcatac mach u sacä tuba cuxlec utz pancab uc'a u tz'ombon cä t'an, u xe chich tä äc'binte paq'uin cuxlec más utz. ");
INSERT INTO chfNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Cua' u pa'se untu winic si u c'ac'a' mote' pancab q'uen cua' chichca utz tuba cuxlec y de ya'i sätic u pixan? Sätic u pixanba, mach'an cache'da u ch'e' u japän, ni t'oc noj q'uenel taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","No'on que sutwänon de winic cä xe tä sujtä pancab t'oc u pitzilan cä Pap y nämte' t'oc u ángelojob. Jinq'uin to cä xe cä'ben cada juntu u tojquiba jini cua'tac u chijob pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Totojtoj cälbenetla, yebe machca ya'an widaba mach uxin tä chämojob ixta que u chänenonjob cha'num, no'on que sutwänon de winic, cache' cä te de Ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis día ji'pat, aj Jesús bixi t'oc aj Pedro, aj Jacobo, y aj Juan u jitz'in aj Jacoboba tu pam ump'e noj tz'ic tä' isquiba. Ya' jini ajnijob sec' u juntumajob. ");
INSERT INTO chfNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","U yäni uba u jut bajca anob. U chicti u jut ca' u chictan q'uin. U bucba laj sutwäni tä' säc ca' u säjq'uelan ni q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jinchichba rato jini u chänijob cache' c'oti aj Moisés y aj Elías, ya'anob tä t'an t'oc aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","De ya'i aj Pedro u yälbi aj Jesús ca'da: ―Cajnoja, utz chich que ya'anonla wida. Si a woba, cä chen t'ocob wida uxp'e yoc boch': ump'e ta'a, ump'e taj Moisés, y ump'e taj Elías. ");
INSERT INTO chfNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mu'to u t'an aj Pedroba, tutz'i ump'e noj bucla tä cielo, tajc'äntz'alan, u bälijob u yuxtumajob. Jinchichba rato jini ump'e t'an ubqui tama ni bucla jini, u yäle' ca'da: ―Jinda cä Yajben Ajlo'. T'oc une ayan cä ch'a'aljin. Ubinla u t'an une. ");
INSERT INTO chfNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jinq'uin ni ajcänt'anob taj Jesús u yubijob jini t'an, päcwänijob tä cab uc'a c'ac'a' bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","De ya'i aj Jesús u natz'ijob, y u tälijob, u yälbijob ca'da: ―Ch'oyenla. Mach bäc'taquetla. ");
INSERT INTO chfNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jinq'uin u t'äbsi u jut u chänenob mach u ni' chänijob ni cha'tujobba. Sec' aj Jesús u juntuma ya'an. ");
INSERT INTO chfNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jinq'uin jaque u chenob tu pam ni noj tz'ic jini, aj Jesús u yälbijob ca'da: ―Mach to a wälbenla niuntu ni a chänilaba ixta que cuxpacon tan ajchämejob, no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","De ya'i u yajcänt'anob u c'atbijob ca'da: ―¿Cua' uc'a jiq'uin u yäle'ob jini que tä' yuwijob ni ley taj Moisésba cache' c'änä tic aj Elías najtäcä? ");
INSERT INTO chfNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aj Jesús u p'albijob ca'da: ―Toj chich, ni jun ta Dios u yäle' cache' aj Elías u xe tä te najtäcä y u xe u laj äq'ue' tu toja upete cua' chichca. ");
INSERT INTO chfNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bada cälbenetla que aj Elíasba ajni chich une, pero mach u chi conocejob, y u tz'ibajtesijob ca' chich u yoli u cherbenob. No'on que sutwänon de winicba, u xe chich u tz'ibajtesanonjob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jinchichba rato jini ti tu c'ajalinob u yajcänt'anob aj Jesús cache' de aj Juan ajc'ablesia ni mu' u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jinq'uin c'otijob tä cha'num bajca an noj q'uenel gente, c'oti untu winic bajca an aj Jesús, nocwäni tu pänte' u yäle' ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Cajnoja, ch'ämben yajin cajlo' y tz'äcälin, uc'a u säto u c'ajalin y mäx u tz'ibajtesan ni yaj jini. Jinq'uin u p'uje' uba ni yaj jini, mach unnum u yälo tan c'ac', y mach unnum täcä u yälo tä ja'. ");
INSERT INTO chfNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Acä täsbijob a wajcänt'anob, pero mach u chi trebe u tz'äcälinob. ");
INSERT INTO chfNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aj Jesús u p'ali, u yäli ca'da: ―¡Anela que ya'anetla pancab bada, mach a tz'onäla y mach tu toja a c'ajalinla! Ixta caxti amba q'uin cä xe tä ajtä t'oc anela. Ixta caxti amba q'uin c'änä ajnic sis cä c'ajalin t'oc anela. Täsen wida ni ajc'ojpan. ");
INSERT INTO chfNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aj Jesús u q'uejpi ni tzuc pixan. De ya'i pasi tuyac'o ni ajlo'. Jinchichba rato jini u yäq'ui uba. ");
INSERT INTO chfNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","C'oti sec' u bajnimajob u yajcänt'anob aj Jesús u yälben ca'da: ―¿Cua' uc'a no'on t'ocob mach cä chi trebe cä pa'säben t'ocob ni tzuc pixan tuyac'o? ");
INSERT INTO chfNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aj Jesús u yälbijob ca'da: ―Uc'a mach a totoj tz'onila que Dios u xe u chen. Totojtoj cälbenetla, si ajnic ica tz'ita' a fe, ca' u no'an unxim yoc bec' mostazaba, u ch'e' a wälben ni tz'icda: “Tz'eje aba wida”, y u xe chich u tz'eje' uba. Y mach'an niump'e cua' que mach u ch'e' a chenla si a totoj tz'onänla. ");
INSERT INTO chfNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tzuc pixan ca' jinijobba mach u ch'ä a päpä' pa'senla. C'änä a chenla c'änti'ya y a chenla su'q'uin tuba a chen trebe a pa'senla. ");
INSERT INTO chfNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nume to u chenob tama cab tä Galilea, aj Jesús u yälbi u yajcänt'anob ca'da: ―No'on que sutwänon de winicba cä xe tä äc'can tu c'äb winicob. ");
INSERT INTO chfNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Cä xe tä tzämsinte, y u yuxp'elib q'uin cä xe tä cuxpan. U yubijob ca' jiniba, machtajda ch'ocomi u pixanob. ");
INSERT INTO chfNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jinq'uin c'otijob tä Capernaum, c'otijob bajca an aj Pedro jini machcatac u nume u ch'uch'än ni taq'uin, jini u cojcan tuba ni ch'uj taj judíosobba, u yälben ca'da: ―¿Mach quira uxin u toje' ni a maestro ni taq'uin que u cojcanba? ");
INSERT INTO chfNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aj Pedro u yäli: ―U toje' chich une. Ochi tama ni otot bajca an aj Jesús. Mach to u yälbe cua' jinq'uin aj Jesús u yälbi ca'da: ―¿Cache' a wäle' ane, Simón? Ajmandajob pancab, ¿caxcatac u yäc'ben u toje' ni taq'uin que u ch'uch'inte tuba gobiernoba? ¿U ch'ocob quira o ni mach jin u ch'ocobba? ");
INSERT INTO chfNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aj Pedro u p'albi ca'da: ―Ni u yäc'ben u toje'ba, jin une ni mach jin u ch'ocobba. Aj Jesús u yälbi ca'da: ―Ca' jiniba, mach u yäc'binti u toje' cua' ni u ch'ocobba. ");
INSERT INTO chfNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero uc'a mach cäräx'acjobba, corre cux ti' nab y julu a mäsc'äb tä ja'. De ya'i ni buch' a xe a luque' najtäcäba, t'äbsen y jäbben u ti'. Tama u ti' a xe a pojlen ump'e taq'uin. Bisan y tojbenob t'oc. Uc'a ni taq'uin jiniba u xe u yäq'ue' tuba cä cha'tumala. ");
INSERT INTO chfNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jimba q'uin jini u yajcänt'an aj Jesús u natz'ijob u yälben ca'da: ―¿Caxca une u xe más ajnoja bajca u chen manda ni Dios ya'an tä cieloba? ");
INSERT INTO chfNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aj Jesús u joq'ui tic bajca an untu yoc p'i' ajlo', u yäq'ui tänxin de unejob. ");
INSERT INTO chfNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","U yälbijob ca'da: ―Totojtoj cälbenetla, si mach a q'uexe a c'ajalinla tuba mach a ni' chen a tanäla, y si mach sujlequetla ca' bijch'oc, mach uxet tä ochela bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Machca chichca que ajnic ca' ni yoc ajlo'da, y u chen uba que une más ajch'och'oca y u lot más ajnoja, jin une u xe más ajnoja bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Machca chichca u sapän täj c'aba' untu ajlo' ca' chich ni andaba, no'on chich une u sapänon. ");
INSERT INTO chfNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Machca chichca que u yäc'ben u säte' t'oc Dios untu bijch'oc ca' ni ajlo'da que u tz'ombenon cä t'an, más utz cächbintic tu luc'ub ni winic jini ump'e noj gran na'cha' y julcac tänxin nab tuba chämic. ");
INSERT INTO chfNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tä' lástima quiran ni a'ajtäjob pancab, uc'a ya'an machcatac u yäc'ben u lot u säte' t'oc Dios. Paq'uin ayan chich machca u yäc'ben u lot u säte' t'oc Dios, y tä' lástima ni winic jini que u yäc'ben u säte'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Si a c'äb o si a woc u yäc'benet a säte' t'oc Diosba, chunjätz'ä y choco; uc'a más utz ochiquet ajchunc'äb o ajchun'oc bajca a xe tä paq'uin ajtä cuxu, y mach julcaquet entero untu con to'o a c'äb y a woc tama ni noj c'ac' que mach u jira täpoba. ");
INSERT INTO chfNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Si unxim a jut u yäc'benet a säte' t'oc Diosba, ch'ä pa'sen y choco; uc'a más utz ochiquet tonxim a jut bajca a xe tä paq'uin ajtä cuxu y mach julcaquet entero untu con to'o u cha'xima a jut tama noj c'ac' tä infierno. ");
INSERT INTO chfNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Mach a wäle' cache' más utzet ane tu jut Dios que untu de ni bijch'ocda. Cälbenet cache' ni ángelojob que u jiranob ni bijch'ocobdaba ya' chich an tä cielo u paq'uin chämben u jut cä Papla Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","No'on que sutwänon de winicba julon cä japän machcatac sätä ayan. ");
INSERT INTO chfNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Cache' a wäle'la? Si untu winic u cänäntan cien ovejas y si sätic untuba, ¿mach quira uxin u yäctan ni noventa y nueve u juntuma tu pam tz'ic tuba bixic une u sacän jini asätiba? ");
INSERT INTO chfNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Si u pojliba, totojtoj cälbenetla cache' u xe tä c'ac'a' ch'a'alan ujin uc'a ni oveja jini que sätä ajni y u pojliba. Más ch'a'a ujin u xe tä ajtä uc'a ni oveja jini que uc'a ni noventa y nueve que mach xi tä säto. ");
INSERT INTO chfNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cälbenetla que mach yo täcä cä Papla ya'an tä cieloba que sätic niuntu de ni bijch'ocjobda. ");
INSERT INTO chfNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Si a lot u säte' t'oc ane, corre chen t'an t'oc, sec' a cha'tumala, uc'a tic tu c'ajalin cua' jini u chi. Si u yäq'ue' u chiquin u yubin a t'an, a xe chich a wäc'ben colac utz u c'ajalin t'oc ane. ");
INSERT INTO chfNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Si mach u yäc'ä u chiquin u yubin a t'anba, sacän untu o cha'tu a lot tuba bixiquet t'oc nämte', uc'a ajnic cha'tu uxtu u yäle'ob camba ni u toja. ");
INSERT INTO chfNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si mach u yäc'ä u chiquin u yubin u t'anob unejobba, älä tu pänte' machcatac u woylan ubajob jini que ayanob t'oc Diosba. Si mach u yäc'ä u chiquin u yubin u t'anob ni jinijobba, ajnic ta' jutla ca' untu ajpäpä'cab y ajcojtaq'uin jini que mach u tz'ombejob Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Totojtoj cälbenetla cache' upete jini a wäle'la cache' mach utz ta utic pancab, Dios täcä che' chich u xe u yäle'. Y upete jini a wäle'la cache' utz ta utic pancab, Dios täcä che' chich u xe u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Bada cälbenetla täcä si cha'tu de anela ajnic tomp'e a c'ajalinla tuba a c'atbenla cua' chichca ni cä Papla ya'an tä cieloba, u xe chich u yäc'benetla. ");
INSERT INTO chfNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Uc'a bajca woyo anob cha'tu uxtu tuba u ch'u'ul c'ajti'inon, ya' chich anon tänxin de unejob. ");
INSERT INTO chfNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","De ya'i aj Pedro u natz'i aj Jesús, u yälbi ca'da: ―Cajnoja, ¿jäynum c'änä cä chen perdona cä lot jinq'uin u säte' t'oc no'on? ¿Ixta siete vez quira? ");
INSERT INTO chfNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aj Jesús u yälbi ca'da: ―Mach cälbet que a chen perdona siete vez. C'änä a chen perdona ixta setenta veces siete. ");
INSERT INTO chfNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’U manda ni Dios ya'an tä cieloba es ca' untu ajnoja que u yoli u jiran jäyp'e u chen debe cada juntu u yajpatan. ");
INSERT INTO chfNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jinq'uin u täq'ui u jiranba, u pojli cache' ya'an untu que u chen debe ixta jäyp'exti millón de säsäc taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ni winicda mach u ni' che trebe u toje' u bet uc'a tä' q'uen. De ya'i u yäli jini u yum que choncac con to'o jit'oc y u bijch'oc y upete cua' chichca u cänäntan, tuba tojcac jini bet. ");
INSERT INTO chfNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jinq'uin u yubi jini winic ca' jini, nocyäli tu yoc u yum, u ch'oc chen uba t'oc, u yälben ca'da: “Cä yum, pijnaxto tz'ita', cä xe chich cä laj tojbenet upete”. ");
INSERT INTO chfNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","U yum ni winic jiniba u c'ac'a' ch'ämbi yajin. U yäcti bixic tu yotot y mach u ni' äc'bi u toje' ni tz'ita' u bet. ");
INSERT INTO chfNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jinq'uin pasi jini winic, u nuc'ti untu u lot, ajpatan täcä tuba jinchichba u yumob. Jini winic u cherben debe cien bit taq'uin. U juli uba tuyac'o, u yätz'q'uechbi u luc'ub u yälben ca'da: “Tojbenon jini taq'uin a cherbenon debeba”. ");
INSERT INTO chfNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","De ya'i jini winic nocyäli tu yoc, u ch'oc chen uba t'oc, u yälben ca'da: “Pijnaxto tz'ita', cä xe chich cä laj tojbenet upete”. ");
INSERT INTO chfNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Uneba mach u yoli u pijnan. De ya'i bixi u yäq'ue' tä mäjcan tan cárcel. Cuanta u laj tojbi upete ni taq'uin u cherben debeba, ixta jinto q'uin u xe tä pa'sinte. ");
INSERT INTO chfNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ni otros ajpatanob u lotob chich ni winic jiniba jinq'uin u chänijob cua' u chi pasa, c'ac'a' ch'ocomi u pixanob. De ya'i bixijob u laj älben u yum cache'tacda u chi ni u yajpatan jini. ");
INSERT INTO chfNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","De ya'i ni u yum u täsqui tä jo'can ni winic jini cha'num u yälben ca'da: “Aneba untu cajpatanet que tä' malujet. Upete ni a noj bet a cänäntiba mach cä'bet a toje' ni tz'ita' uc'a a ch'oc chi aba t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Mach quira u ch'ä a ch'ämben yajin untu a lot ajpatan ca' chich ane, ca' chich no'on cä ch'ämbet yajin aneba?” ");
INSERT INTO chfNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","C'ac'a' cäräx'i jini u yum. U yäq'ui jini u yajpatan tu c'äb machca u xe u c'ac'a' äc'ben u noj castigo. Ixta que mach u laj toje' upete jini u chen debeba u xe u chaje'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Ca' jini täcä u xe u chen t'oc anela ni cä Papla ya'an tä cieloba si anela mach a totoj chen perdonala cada juntu de a lot machcatac u säte' t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jinq'uin aj Jesús u tzupsi u chen ni t'anda, pasi ya'i tama ni noj cab tä Galilea, bixi tama noj cab tä Judea. C'oti tunxe río Jordán. ");
INSERT INTO chfNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Q'uen gente bixi tu pat, y ya' jini u tz'äcäli upete machcatac c'ojo. ");
INSERT INTO chfNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","De ya'i c'oti bajca an aj Jesús aj fariseojob u jiranob si u ch'e' u yäc'ben u säte', u yälbenob ca'da: ―¿U yäle' quira tama ni ley cache' utz waläctintic untu ixic que sea cua' chichca jini u säte' t'oc jit'oc? ");
INSERT INTO chfNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aj Jesús u p'ali ca'da: ―¿Mach to quira bay a tziquila ni jun ta Dios, bajca u yäle' cache' Dios jini u chi upete cua' chichca ayanba, chäcäl najtäcä u chi täcä winic y ixic? ");
INSERT INTO chfNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","U yäli täcä Dios ca'da: “Jin uc'a untu winic u xe u yäctan u pap y u na' tuba lotojac t'oc ixic. Ca' jini u cha'tumajobba u colan ca' a wälä tontujob”. ");
INSERT INTO chfNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ca' a wälä mach ni' cha'tujob. Tontujob namás une. Jini u yäc'bi Dios ajnic tomp'e t'oc jit'ocba, mach'an cua' uc'a u tz'eje' ubajob. ");
INSERT INTO chfNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","De ya'i aj fariseojob u yälbijob täcä ca'da: ―¿Cua' uc'a jiq'uin aj Moisés u yäli cache' machca u waläctan jit'oc c'änä u yäq'ue' tä tz'ibinte ump'e jun bajca u yäle' cache' atotoj waläctinti ni ixic jini? ");
INSERT INTO chfNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aj Jesús u yälbijob ca'da: ―Uc'a a tzätzäl pämlela u yälbetla aj Moisés a chenla ca' jini. Pero najtäcäba Dios mach u yäq'ui tä ute ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","No'onba cälbenetla jiq'uin ca'da: Machca chichca u waläctan jit'oc y mach uc'a u chi u tanä de cherajtz'ijte' ni ixic jiniba, y de ya'i si lotojac t'oc otro ixic, jini winic u chen u tanä de cherajtz'ijte'. Che' chich täcä machca lotojac t'oc jini ixic que waläctintiba, une täcä u chen u tanä de cherajtz'ijte'. ");
INSERT INTO chfNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","U yajcänt'anob aj Jesús u yälbijob ca'da: ―Si ca' jini ayanob jini machca u lotojanba, mejorica mach lotojac untu. ");
INSERT INTO chfNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aj Jesús u yälbijob ca'da: ―Pero mach upete u chen trebe ajnic sin que lotojac, seq'uen jini machcatac Dios u yaqui tuba ajnic ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ayan chich winic que mach u ch'ä lotojac uc'a che' chich päncäbi. Ayan chich winic que mach u lotoja uc'a winic chich u yäq'ue' tä cherbinte cua' chichca tuba mach lotojac. Ayan chich täcä winic que mach yo lotojan uc'a más yo u yäq'ue' u c'ajalin u c'alin chen cua' yo utic ni Dios ya'an tä cieloba. Machca u chen trebe u chen ca' jini, utz chich si u chen. ");
INSERT INTO chfNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","De ya'i u c'osijob bajca an aj Jesús bijch'oc tuba u yäc'ben u c'äb tan u pam y u c'atben Dios por unejob. U yajcänt'anob aj Jesús u q'uejpijob jini machcatac u täsen ni bijch'oc bajca an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aj Jesúsba u yäli ca'da: ―Äctanla tic ni bijch'oc bajca anon. Mach a ch'acbenla u biji, uc'a ca' jinijob une ni ya'an bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aj Jesús u yäc'bi chich u c'äb tan u pam ni bijch'oc y u c'atbi Dios por unejob. De ya'i, pasi bajca anob, bixi. ");
INSERT INTO chfNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","De ya'i c'oti untu winic bajca an aj Jesús u yälben ca'da: ―Maestro, utz a c'ajalin une. ¿Cua' une ni utzba que c'änä cä chen tuba äc'binticon paq'uin cuxlecon? ");
INSERT INTO chfNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aj Jesús u p'albi ca'da: ―¿Cua' uc'a a wälbenon cache' utz cä c'ajalin? Mach'an niuntu utz u c'ajalin seq'uen Dios une. Pero si a wo ochiquet bajca a xe tä paq'uin ajtä cuxu, chen ca' chich u yäle' u manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Une u yäli: ―¿Catac anba? Aj Jesús u yälbi: ―Mach a chen tzämsa. Mach a sacän a tz'ijte'. Mach a chen xuch'. Mach a sube' a lot t'oc jop'ojti'. ");
INSERT INTO chfNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tz'omben u t'an a pap y a na'. Yajna'tan a lot ca' chich a yajna'tan aba ane. ");
INSERT INTO chfNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jini ch'oc winic u yälbi ca'da: ―Upete ni jini cä chen chich ca' u yäle', desde p'i'on to. ¿Caxcamba jiq'uin u chen falta ta cä chen? ");
INSERT INTO chfNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aj Jesús u yälbi ca'da: ―Si a wo c'alin ajniquet tu toja, corre chono upete lo que a cänäntan, y laj pucben pobrejilba u taq'uini. De ya'i tiquet a tzäypätinon. Ca' jini a xe a cänäntan q'uen cua' chichca tä' choj u valor tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tu yubin ni ch'oc winic ca'da, tä' ch'ocomi u pixan, y bixi, uc'a une u cänäntan q'uen cua' chichca. ");
INSERT INTO chfNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","De ya'i aj Jesús u yälbi u yajcänt'anob ca'da: ―Totojtoj cälbenetla cache' untu ajtaq'uini mach u se'en pojle bij tuba ochic bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bada cha'num cälbenetla cache' más u ch'e' numic untu ajcamello tu jut untz'it putz' que ochic untu ajtaq'uini bajca u chen manda ni Dios ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","U yajcänt'anob aj Jesús, jinq'uin u yubi cua' u yäli, tajch'icwäni u jutob u yubin, u yäle'ob ca'da: ―¿Caxca une jiq'uin u ch'e' u japän uba? ");
INSERT INTO chfNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aj Jesús u chämben u jut u yajcänt'anob, u yälbenob ca'da: ―Winicba mach u che trebe u japän uba. Pero Diosba u chen trebe u japänonla, uc'a uneba mach'an niump'e cua' que mach u chen trebe u chen. ");
INSERT INTO chfNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","De ya'i u p'ali aj Pedro, u yälbi aj Jesús ca'da: ―Iranba, no'on t'ocobba cä laj äcti upete lo que cä cänänti t'ocob y cä tzäypätet t'ocob. ¿Cua' une jiq'uin cä xe tä äc'binte t'ocob uc'a cä chi ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aj Jesús u yälbijob ca'da: ―Totojtoj cälbenetla cache' jinq'uin Dios u xe u tzijibesan u pancab, jinq'uin no'on que sutwänon de winicba cä xe tä chumtä pan ni chumlib bajca cä xe cä chen manda t'oc cä poder, anela täcä a xe tä chumtäla bajca an jini doce chumlib tuba xiquetla de ajmanda taj Israel, uc'a a wiranla si u chi tu tojajob ni doce grupo de u ch'ocob aj Israelob. Jin une ni a xe tä äc'bintela uc'a a wäctila upete tuba a tzäypätinonla. ");
INSERT INTO chfNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Machca chichca que u yäcti yotot, u säcunob, u chichob, u jitz'inob, u pap, u na', jit'oc, u ch'ocob, o u cab uc'a u tz'ombenon, u xe chich tä äc'binte cien veces más de lo que u yäcti, y u xe tä äc'binte täcä paq'uin cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero q'uenob machcatac noj don winicob tu jut u lotob u xe tä colan de ajch'och'oca, y jini ajch'och'ocajobba u xe de ajt'äbälajob. ");
INSERT INTO chfNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Uc'a bajca u chen manda ni Dios ya'an tä cieloba es ca' untu winic u yum ump'e cab. Jini winic pasi ic'sapanto u sacän ajpatan tuba u täscun tan u caba u päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jinq'uin u pojli ni ajpatan, colijob t'oc que u xe u toje' ca' chich u chen ganajob ump'e q'uin. De ya'i u täsquijob tama u caba u päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jini winic pasi cha'num más t'äb q'uin. U chäni otros ajpatanob tan caj que mach'an cua' u chenob. ");
INSERT INTO chfNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Une u yälbijob ca'da: “Cuxla täcä tä patan tan u caba cä päc'äbi, y cä xe cä toje'etla ca' chich c'änä tojcaquetla”. Unejob bixijob chich. ");
INSERT INTO chfNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jini winic pasi täcä tänxin q'uin y ochiq'uin. U chi ca' chich u chi najtäcä. ");
INSERT INTO chfNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ump'e hora yo tuba chajcac ajpatan, pasi cha'num jini winic. U nuc'ti tä cha'num otros ajpatanob que mach'an cua' u chen. U yälbijob ca'da: “¿Cua' uc'a ya'anetla wida entero q'uin sin patan?” ");
INSERT INTO chfNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Unejob u p'ali: “Ya'anon t'ocobda uc'a mach u yäc'bon t'ocob patan niuntu”. Une u yälbijob: “Cuxla täcä tä patan tan u caba cä päc'äbi, y cä xe cä toje'etla ca' chich c'änä tojcaquetla”. ");
INSERT INTO chfNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cuanta pomi q'uin, u yum ni u caba ni päc'äbi u yälbi u yajnoja ajpatan ca'da: “Joc'o ni ajpatanob, y laj tojben u q'uinob. A täq'ue' a toje' t'oc jini machcatac ajuli ji'patba, y tzupsen t'oc jini machcatac juli najtäcäba”. ");
INSERT INTO chfNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","C'otijob jini machcatac c'otijob tä patan ump'e hora yo tuba chajcac ajpatan, y äc'bintijob cada juntu ca' chich u chen ganajob ump'e q'uin patan. ");
INSERT INTO chfNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","C'otijob täcä ni machcatac c'otijob tä patan najtäcäba, y ti tu c'ajalinob cache' u xejob tä tojcan más que ni ajpatan jini. Jinq'uin tojquintijob uneba, che' chich äc'bintijob täcä cada juntu ca' chich u chen ganajob ump'e q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cuanta tojquijobba, coli jac' ujinob t'oc u yum ni patan. ");
INSERT INTO chfNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","U yälbijob ca'da: “Jini ajpatanobdaba sec' ump'e hora u chi patanob, y ane a toji ca' chich a tojon t'ocob, y no'on t'ocobba cä chi patan t'ocob entero q'uin, tan noj ticäw q'uin”. ");
INSERT INTO chfNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Une u p'ali, u yälbi untu de ni ajpatanob ca'da: “Cä lot, acä chi chich tu toja t'oc ane. ¿Mach quira colonla cache' cä xe cä toje'et ca' chich a chen gana ump'e q'uin? ");
INSERT INTO chfNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Da jiq'uin ni taq'uin que a chi ganaba y corre cux. Pero co chich cä toje' täcä ni ajpatanob que juli ji'patba ca' chich mu' cä toje'et ane. ");
INSERT INTO chfNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Mach quira u ch'ä cä chen cache' chichca colin cä chen t'oc lo que es täc'a? ¿Mach quira a wo a chänenon uc'a utz cä c'ajalin t'oc cajpatan?” ");
INSERT INTO chfNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Uc'a ni najtäcäjobba u colanob ji'pat. Ni ji'patobba u xejob najtäcä. Uc'a q'uenob chich machcatac u joq'ue' Dios, y mäx tz'ita' ni u yaquintejobba. ");
INSERT INTO chfNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aj Jesús bixe u chen tä Jerusalén. Tä bij u pequi ni doce u yajcänt'anob u juntumajob, u yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ca' chich a wiranla, bada cä bixela tä Jerusalén. No'on que sutwänon de winicba, cä xe tä äc'can tu c'äb no' ajnoja palejob y tu c'äb jini machcatac tä' yuwi ni ley taj Moisés. Unejob u xe u yäq'ue'onob tä tzämsinte. ");
INSERT INTO chfNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","U xe u yäq'ue'onob tu c'äb aj gentilob tuba u xiq'ue'onob, u jätz'e'onob, y u yäq'ue'onob tä cruz tuba chämicon. Pero u yuxp'elib q'uin cä xe tä cuxpan tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","C'oti bajca an aj Jesús u na' u ch'ocob aj Zebedeo nämte' t'oc jini u ch'ocob täcä. Nocyäli tu pänte' tuba u c'atben que u chen ump'e favor. ");
INSERT INTO chfNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Une u yälbi: ―¿Cua' a wo? Ni ixic u yäli ca'da: ―Co que a'ben ni cä ch'ocobda chunwänicob ta' ch'ejpa bajca a xe de ajmanda, untu ta' noj y untu ta' tz'ej. ");
INSERT INTO chfNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Aj Jesús u p'ali ca'da: ―Mach a wi cua' a c'atän. ¿U ch'e' quira a c'älenla tz'ibajtesia ca' chich no'on cä c'älen, ca' a wälä a wuch'enla jini cä xe cuch'en no'on, y ca' a wälä c'ablaquetla ca' chich cä xe tä c'ablan no'on? Unejob u yäli: ―U ch'e' chich cä c'älen t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aj Jesús u yälbijob: ―A xe chich a ch'e'la ni tz'ibajtesia que cä ch'e' no'on, ca' a wälä a wuch'enla ni cä xe cuch'en no'onba y ca' a wälä a c'ablanla ca' chich cä xe tä c'ablan no'on. Pero tuba cälbenetla chunwäniquetla täc noj y täc tz'ej, mach no'on une cä xe cäle' caxca une u xe tä chumtä ya' jini. Cä Pap une u xe u yäle', uc'a ya' chich an tu c'ajalin caxca une u xe tä chumtä ya' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jinq'uin ni diezjobba u yubi cua' yojob aj Jacobo y aj Juan, cäräx'ijob t'oc ni cha'tu u lotobba. ");
INSERT INTO chfNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aj Jesús u joq'uíjob, u yälbijob ca'da: ―A wila chich cache' untu ajmanda tama ump'e noj cab, tu manda chich ayan upete gente. Nuc ajt'äbälajobba ayan chich u poder tuba u cocoj äc'ben ni gente u tz'omben u t'an. ");
INSERT INTO chfNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Anelaba mach uxet a chenla ca' jini. Machca chichca de anela yo u chen uba más ajnoja, c'änä sujlec de a wajc'äncanla. ");
INSERT INTO chfNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y machca chichca de anela yo xic más ajmanda, c'änä sujlec de a wajpatanla. ");
INSERT INTO chfNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Uc'a no'on que sutwänon de winic, mach ajulon pancab tuba cherbinticon cua' chichca que c'änä cäc'a. Julon tuba cä cherben cua' chichca que c'änä uc'ajob upete, y tuba cäq'ue' cäba tä tzämsinte de u jelojob q'uen uc'a mach chämicob. ");
INSERT INTO chfNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tu pasejob tama jini caj tä Jericó, noj q'uenel gente u tzäypätijob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Cha'tu ajchoc' ya' chumujob tu ch'ejpa bij. Jinq'uin u yubijob cache' nume u chen aj Jesús, u chijob noj t'an, u yäle'ob ca'da: ―¡Cajnoja, ajlo'et taj David, ch'ämbenon t'ocob yajin! ");
INSERT INTO chfNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ni gentejob u q'uejpijob uc'a ch'ijcäbacob. Pero unejobba más u c'ac'a' chen noj t'anob u yäle'ob ca'da: ―¡Cajnoja, ajlo'et taj David, ch'ämbenon t'ocob yajin! ");
INSERT INTO chfNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","De ya'i tajwa'wäni aj Jesús. U joq'uíjob, u yälbenob ca'da: ―¿Cua' a wo cä cherbenetla? ");
INSERT INTO chfNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Unejob u yäli: ―Cajnoja, co que a jäbbenon t'ocob cä jut. ");
INSERT INTO chfNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","De ya'i aj Jesús u ch'ämbi yajinob. U tälbi u jutob. Jinchichba rato jini u chi chanäjob y u tzäypätijob. ");
INSERT INTO chfNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jinq'uin mu' u natz'äjbälanob tä Jerusalén, c'otijob tä Betfagé bajca an ni tz'ic u c'aba' Olivas. Aj Jesús u täsqui cha'tu u yajcänt'anob xicob pänte', ");
INSERT INTO chfNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","u yälbijob ca'da: ―Cuxla tama jini caj nätz'äba. Ya'i a xe a pojlenla untu na' tzimim cächä ayan, t'oc untu ch'oc tzimim. P'änäla, y täsbenonla u cha'tumajob wida. ");
INSERT INTO chfNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Machca chichca que u yälbenetla cua' uc'a a ch'e'la, älbenla ca'da: “Ajnoja c'änä uc'a”. De ya'i u xe u yäctan a ch'e'la. ");
INSERT INTO chfNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Upete jinda u chi pasa uc'a pasic toj jini u yäli ajt'an ta Dios oniba jinq'uin u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Älbenla machcatac tä Sión ca'da: “Chänenlaba. Ya' u teda a Wajnojala, utz u c'ajalin une. U te chumu tu pat untu tzimim, chumu tu pat untu ch'oc tzimim, u yal na' tzimim, jini u c'äncan tuba beli' cargaba”. ");
INSERT INTO chfNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ni cha'tu ajc'äncanob bixijob. Ca' chich älbintijob, che' chich u chijob. ");
INSERT INTO chfNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","U täsijob chich ni na' tzimim y che' ch'oc tzimim. De ya'i u läcbijob u jeli' sisijob tu pat ni tzimimjob. Aj Jesús u chumti ni ch'oc tzimim. ");
INSERT INTO chfNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ni noj q'uenel gente u laj jäye' u jeli' sisijob tä cab tama bij. Otrosjobba u c'äse'ob u c'äb te' u laj t'e'e'ob tan bij bajca u xe tä nume aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ni noj q'uenel gente u bixejob pänte'ba, che' chich täcä ni u te patijobba, u yäle'ob ca'da: ―Ch'u'ul c'äycac u yajlo' aj David. Ch'u'ul ayan jini que Cajnojala Dios u täsquiba. Ch'u'ul c'äycac täcä tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jinq'uin oche u chen tama caj tä Jerusalén, a'ajtäjob tama ni caj jini u jobi ubajob, u yäle' ca'da: ―¿Caba winic ni jinda? ");
INSERT INTO chfNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ni gente u bixe nämte' t'oc aj Jesúsba u yälijob ca'da: ―Jinda ni aj Jesús, ajt'an ta Diosba, ya' u cäji tä Nazaret, tama noj cab tä Galileaba. ");
INSERT INTO chfNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ochi aj Jesús tama ni noj ch'u'ul otot ta Dios, u laj pa'sijob upete ajchono y ajmanob. U t'eljulbi u mesajob ni ajq'uextaq'uinob. U t'eljulbi täcä u chumlibob ni machcatac u chone' ixpaloma. ");
INSERT INTO chfNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","U yälbijob ca'da: ―Tz'ibi chich ayan tama u jun Dios u yäle' ca'daba: “Cototba, tuba utic c'änti'ya tama”. Pero anelaba a chenla ca' otot tuba u yajliba ajxuch'. ");
INSERT INTO chfNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","De ya'i c'oti bajca an aj Jesús tama noj ch'u'ul otot ajchoc' y ajc'ol'oc, y une u tz'äcäli. ");
INSERT INTO chfNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ni ajnojajob ta pale y jini que tä' yuwijob ni ley taj Moisés c'ac'a' cäräx'ijob jinq'uin u chänijob cache' aj Jesús u chen q'uen cua' chichca que mach bay achäninti, y jinq'uin u yubijob täcä ni ch'octäc ajlo' tama ni ch'u'ul otot cache' u yäle'ob que ch'u'ul c'äycac ajlo' taj David. ");
INSERT INTO chfNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Unejob u yälbi aj Jesús ca'da: ―¿Mach quira a ubi cua' mu' u yäle'ob? Aj Jesús u p'albijob: ―Mu' chich cubin. Mach quira bay to a tziquila ane bajca u yäle' ca'da: Ane a wäc'bi u ch'u'ul c'äye' a c'aba' bijch'oc ixta ni mu'to u chu'nanba. ");
INSERT INTO chfNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","De ya'i aj Jesús u yäctijob, pasi tama caj bixi tä Betania. Ya' wäyi ya'i. ");
INSERT INTO chfNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Päscab ic'sapanto, tu bixe cha'num tama noj caj, u na'ti jitz'o. ");
INSERT INTO chfNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","U chäni untec te' higo nätz'ä tu ch'ejpa bij. Bixi bajca an. Mach u pojli niump'e u jut, seq'uen u yopo namás. U yälbi ca'da: ―Aneba mach bay uni' xin tä ajtä a jut. Jinchichba hora jini, nonoj tiqui ni te' higo. ");
INSERT INTO chfNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jinq'uin u chäni u yajcänt'anob, tajch'icwäni u jutob u yäle'ob ca'da: ―¿Cache'da tiqui seb ni te' higo? ");
INSERT INTO chfNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","U p'ali aj Jesús, u yälbijob ca'da: ―Totojtoj cälbenetla, si a totoj tz'onänla y mach ajnic niump'e cua' ta' c'ajalinla que u yäle' que mach u che trebe u chen Dios lo que a c'atänla, machica a chela sec' ni acä chi no'on t'oc te' higoba. Pero si a wälbenla ni noj tz'icda: “Pasen wida y julu aba tan nab”, che' chich u chen. ");
INSERT INTO chfNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Upete cua' chichca a c'atän t'oc c'änti'ya, si a tz'onänlaba, Dios chich u xe u yäc'benetla. ");
INSERT INTO chfNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","C'oti aj Jesús tama ni noj ch'u'ul otot u ye'e' u t'an Dios ya'i. C'otijob täcä u yajnojajob pale y noxibilbajob tuba caj u yälbenob ca'da: ―¿Caxcaba poder a cänäntan tuba a chen ane ca' jini? ¿Caxca une u yäc'bet ni poder jini tuba a chen ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aj Jesús u p'albijob ca'da: ―No'on täcä cä xe cä c'atbenetla ump'e t'an. Si ane a wälbenonlaba, cä xe chich cälbenetla täcä caxca t'oc u poder cä chen upete ni jinda. ");
INSERT INTO chfNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jini c'ablesia que u chen aj Juanba, ¿caxca une u yäc'bi u chen? ¿Dios quira o winicob pancab? Unejob ti tu c'ajalinob u maläc äle'ob ca'da: ―Si cälbenla cache' Dios u yäc'bi u chen, une u xe u yälbenonla ca'da: “¿Cua' uc'a jiq'uin mach a tz'ombila?” ");
INSERT INTO chfNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Si cäle'la cache' winicob pancab u yäc'bi u chen, cä bäc'tanla ni gente, uc'a ni genteba u yäle' cache' aj Juanba ajt'an ta Dios une. ");
INSERT INTO chfNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jin uc'a unejob u yälbijob aj Jesús ca'da: ―Mach cuwi t'ocob. Aj Jesús u p'ali täcä ca'da: ―Ni no'on täcä, mach cälbetla caxca t'oc u poder cä chen upete jinda. ");
INSERT INTO chfNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aj Jesús u yälbijob täcä ca'da: ―Cache'da a wale'la jiq'uin t'oc ni t'anda cä xe cäle'ba: Ajni untu winic que u cänänti cha'tu u yajlo'. U pequi ni yajlo' u nojaba, u yälbi ca'da: “Cä ch'oc, corre bada tä patan tama u caba cä päc'äbi”. ");
INSERT INTO chfNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Une u p'ali ca'da: “Mach uxon”. De ya'i ji'pat u q'uexi u c'ajalin, y bixi chich. ");
INSERT INTO chfNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ni winic u pequi u yajlo' u ch'och'ocaba, u yälbi täcä xic tä patan. Une u yäli cache' u xe chich. De ya'i mach xi. ");
INSERT INTO chfNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Caxcamba de ni cha'tu ajlo' jini u chi ca' chich u yoli u pap u chen? Unejob u yäli: ―Ni ajnojaba. Aj Jesús u yälbijob ca'da: ―Totojtoj cälbenetla cache' ajcojtaq'uinob y jini ixictacob u nume u sacän u tz'ijte'obba más u xe u ch'e' ochicob bajca u chen manda ni Dios ya'an tä cieloba, y mach anela. ");
INSERT INTO chfNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Uc'a c'oti aj Juan bajca anetla u ye'e' ni bij tu tojaba y mach a tz'onila. Ajcojtaq'uinob y ixictacob ixtz'ijte'bajobba u tz'onijob chich. Anelaba, aunque a chänila ca' jini, mach a q'uexi a c'ajalinla tuba a tz'onänla. ");
INSERT INTO chfNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Ubinla otro ump'e tz'aji: Ajni untu winic que q'uen u cab. U päq'ui ump'e u noj caba u päc'äbi. De ya'i u bojte'i u junxoyma. U jóq'ui ump'e noj ch'en bajca u xe tä yätz'can u jut ni päc'äbi. U tz'osi ump'e torres bajca u yajtä tu pam uc'a u cänäntan ni päc'äbi jini. De ya'i u yäc'bi tu c'äb otros ajpatanob tuba u cänäntäben, y uneba bixi nat. ");
INSERT INTO chfNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Jinq'uin natz'äli u q'uini tuba c'ä'nac u jut ni päc'äbi, jini u yum u caba päc'äbiba u täsqui u yajc'äncanob tuba u ch'ämben u jut ni päc'äbi bajca an ni ajpatanob u ch'uch'än. ");
INSERT INTO chfNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jinq'uin c'otijob ni ajc'äncanob jini, ni ajpatanob u q'uechijob. Untu u cunijob t'oc te', otro u tzämsijob, y otro u yäc'bijob t'oc ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jini u yum päc'äbi sujli u täscun otros u yajc'äncan tä cha'num, más q'uen que ni u täsqui najtäcäba. Jini ajpatanob che' chich u cherbijob täcä ca' chich u cherbijob ni najtäcäba. ");
INSERT INTO chfNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ji'pat u täsqui u yajlo', uc'a jini winic u yäli: “U xe chich u yubinob u t'an, uc'a cajlo'”. ");
INSERT INTO chfNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero jini ajpatanobba, jinq'uin u chänijob u yajlo' ni winic, u maläc älijob ca'da: “Jindaba une u xe tä colan de u yum ni u caba ni päc'äbi. Cola cä tzämsenla jiq'uin uc'a colac täc'ala ni cab jini”. ");
INSERT INTO chfNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","De ya'i u q'uechijob, u pa'sijob tama u caba ni päc'äbi y u tzämsijob. ");
INSERT INTO chfNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tu xe tä te jiq'uin u yum ni u caba päc'äbi, ¿cua' a wäle'la u xe u cherbenob najpatanob jini? ");
INSERT INTO chfNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","U yajnojajob pale y noxibilbajob u p'alijob ca'da: ―Jini ajpatanob malojobba u xe u laj tzämsen sin que u ch'ämben yajin, y u xe u yäc'ben tu c'äbob otros ajpatan ni u caba päc'äbi, jini machcatac u xe chich u yäc'ben u jut ni päc'äbi u yum tu xe u chen u jutba. ");
INSERT INTO chfNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","De ya'i aj Jesús u yälbijob ca'da: ―Mach to quira bay a tziquila ni jun ta Dios tz'ibiba, ni u yäle' ca'daba: Ni ji'tun u yälijob ajcheraj otot cache' mach utzba, jin une ni ch'ämqui tuba mero u ch'ixma otot. Ajnoja chich u chi ni jini, tä' utz tä chäninte. ");
INSERT INTO chfNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Bada cälbenetla cache' anelaba a xe tä pa'sintela tu manda Dios, y u xe tä osintejob jini gente que u chenob ca' chich yo Dios uticba. ");
INSERT INTO chfNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Machca u päcteq'ue' ni ji'tun jini y yälic tu pam, u xe chich tä xulujtan u bäque. Pero machca yälic ni ji'tun tuyac'oba, ni ji'tun u xe u nonoj muxän une. ");
INSERT INTO chfNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jinq'uin u yubijob u yajnoja palejob y aj fariseojob jini tz'aji que u yäli aj Jesúsba, ti tu c'ajalinob cache' de unejob une ni mu' u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jinq'uin unejob u yoli u q'ueche'ob aj Jesús, sujli u bäc'tanob ni gente, uc'a ni genteba u yäle'ob cache' aj Jesúsba ajt'an ta Dios une. ");
INSERT INTO chfNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aj Jesús u yälbenob otro ump'e tz'aji tä cha'num, u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Jini bajca u chen manda ni Dios ya'an tä cieloba, u c'ote t'oc ca' untu ajnoja pancab jinq'uin u chen ump'e q'uin ch'uje tuba u lotojesan u yajlo'. ");
INSERT INTO chfNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","U täsqui u yajpatanob u joq'ue' ni machcatac pequinti xic tä c'uxnanobba. Pero unejob mach u sapijob xic. ");
INSERT INTO chfNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","De ya'i sujli cha'num u täscun otros u yajpatan u joq'ue'ob, u yälbijob jini u yajpatan ca'da: “Älbenla ni machca pequintijob tic tä c'uxnanobba ca'da: Ubinlaba, listo ayan ni cua' tä c'uxcan. Cäq'ui tä tzämsinte ni beq'uet ixta con to'o ni más poc'omtacba. Listo ayan upete. La'ixla jiq'uin tä c'uxnan”. ");
INSERT INTO chfNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero unejob mach u tz'oni xicob. Untu bixi tä patan tan u cab. Otro bixi bajca an u chono. ");
INSERT INTO chfNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Y otrosjobba, u q'uechijob u yajpatan ni ajnoja jini, u bon tz'ibajtesijob ixta u tzämsijob. ");
INSERT INTO chfNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jinq'uin u yubi ni ajnoja cua' uti, c'ac'a' cäräx'i. U täsqui u soldadojob tuba u tzämsen ni ajtzämsajob jini, y u pulben u cäjijob. ");
INSERT INTO chfNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","De ya'i ni ajnoja u yälbi u yajpatanob ca'da: “Totoj listo chich an ni cua' tä c'uxcan, y upete machcatac cä joq'ui tic tä c'uxnanba mach u ch'ä ticob uc'a mach u chijob tu toja. ");
INSERT INTO chfNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cuxla jiq'uin cachichcada bajca an noj bij, y upete machcatac a nuc'tanla, täsenla tä c'uxnanob”. ");
INSERT INTO chfNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pasijob ni ajpatanob jini cachichcada bajca an noj bij, u nuc'tijob q'uen, y u laj täsijob, nämte'ob t'oc jini utz u c'ajalinob y jini mach utz u c'ajalinobba. Tuli chich ni otot de ajjo'canob, bajca u xe tä c'uxnanob. ");
INSERT INTO chfNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’De ya'i ochi ni ajnoja u chänenob ni jula'job. U chäni que ya'an tä c'uxnan täcä untu winic que mach u q'uexi uba utz ca' tuba xic ca'an lotojan. ");
INSERT INTO chfNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","U yälbi ca'da: “Cä lot, ¿cua' uc'a ochet ane wida sin que a q'uexe' aba ca' tuba xiquet ca'an lotojanba?” Ni winicba mach u pojli cache' u p'alän. ");
INSERT INTO chfNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","De ya'i ni ajnoja u yälbi u yajpatanob ca'da: “Cächbenla yoc y u c'äb, y ch'ä julula päti tan it'obni. Ya'i u xe u chen uq'ue y u xe u chen cäch'äcne yej”. ");
INSERT INTO chfNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Uc'a cälbenetla cache' q'uen ni u jo'canobba, y mäx tz'ita' u yaquinte tuba colacobba. ");
INSERT INTO chfNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","De ya'i bixi u woylan ubajob aj fariseo tuba u ch'e' u c'ajalin cache'da u ch'e' u yäc'ben u säte'ob aj Jesús t'oc cua' chichca t'an, uc'a u sube'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","De ya'i u täsqui u yajcänt'anob bajca an aj Jesús, nämte' t'oc aj herodianojob, u yälben ca'da: ―Maestro, cuwi t'ocob que ane tä' a wo utic tu toja y a totoj ye'e' täcä ni bij ta Dios. Mach a bäc'ta niuntu winic. Mach u che cachichca une que tic u yubin a t'an. ");
INSERT INTO chfNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Älbenon t'ocob jiq'uin, ¿cache'da a wäle' ane? ¿Utz quira cä tojben t'ocob aj César ni derecho u chen cobraba, o mach utz? ");
INSERT INTO chfNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aj Jesúsba yuwi chich cua' an tan u c'ajalinob, u yälbijob ca'da: ―Anela ajsusuccheriajetla, ¿cua' uc'a a sacänla cache' a'benonla cä säte'? ");
INSERT INTO chfNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ye'benonla ni taq'uin que a toje'la t'oc ni derechoba. Unejob u numsäbijob ump'e taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aj Jesús u c'atbijob ca'da: ―¿Caxca u jut ya'an tuyac'o, y caxca u c'aba' ya' tz'ibi tu pamba? ");
INSERT INTO chfNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Unejob u yäli: ―Taj César. Aj Jesús u yälbijob: ―Äc'ben aj César lo que es tuba aj César. Äc'ben Dios lo que es tuba Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tajch'icwäni u jutob u yubin cua' u p'ali aj Jesús. De ya'i u yäctijob t'an y bixijob. ");
INSERT INTO chfNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jinchichba q'uin jini c'otijob bajca an aj Jesús aj saduceojob, jini mach u tz'onä si u cuxpan ajchämejobba, u yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, aj Moisés u yäli ca'da: “Si untu winic chämic y u colesan u jit'oc sin u bijch'oc, u jitz'in chich ni winic jini c'änä lotojac t'oc ni neba' ixic, uc'a ca' jini tu xe u tz'isen u bijch'oc es ca' a wälä u bijch'oc ni winic chämiba”. ");
INSERT INTO chfNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ajni untu winic que u cänänti siete u yajlo'. Ni najtäcäba lotoji, de ya'i chämi y mach u colesi u bijch'oc. Ni ixic coli tuba u jit'oc jitz'in. ");
INSERT INTO chfNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Che' chich u chi pasa täcä ni u cha'tulibba. Chämi sin que ajnic u ch'ocob. Che' chich u chi pasa täcä u yuxtulib, y che' chich y che' chich ixta que laj chämijob ni sietejob. ");
INSERT INTO chfNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ji'pat chämi täcä ni ixic. ");
INSERT INTO chfNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tu xe tä cuxpan ajchämejob jiq'uin, ¿caxcamba de ni sietejob jini u xe tä colan de mero jit'oc ni ixic, uc'a upetejob laj ajni chich de jit'ocob? ");
INSERT INTO chfNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aj Jesús u p'ali, u yälbijob ca'da: ―Sutu a chen entendela, uc'a anela mach totoj a wila ni jun tz'ibi ta Diosba, y cache'da an u poder ni Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jinq'uin u xe tä cuxpan ajchämejobba, mach uni' xin tä lotojanob, ni winic mach uxin u yäq'ue' jixic ch'oc ta lotojac täcä, uc'a upete u xe tä ajtä ca' ni ángelo tuba Dios ni ya'anob tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Mach to quira bay a tziquila lo que Dios u yäq'ui tä tz'ibinte tuba u yälbenetla cache' u xe tä cuxpan ajchämejob? Uc'a une u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“No'on ni u Dios aj Abraham, u Dios aj Isaac, y u Dios aj Jacob”. Uneba mach jin Dios tuba ni ajchämejob que mach uxin tä cuxpan tuba paq'uin cuxlecob. Dios une tuba ni u xe tä paq'uin ajtä cuxujobba. ");
INSERT INTO chfNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jinq'uin u yubi ni gente ni t'anda, tajch'icwäni u jutob uc'a u yubin cua' ni u ye'e'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jinq'uin aj fariseojob u yubi cache' aj saduceo mach u chi trebe u p'alben u t'an aj Jesús, u motli ubajob cha'num. ");
INSERT INTO chfNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Untu de unejob que tä' yuwi ni ley, u yälbi ca'da, tuba u jiran si u yäc'ben u säte': ");
INSERT INTO chfNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿camba ni u manda Dios ni más c'änä cä tz'onänlaba, jini ya' tz'ibi tama u junba? ");
INSERT INTO chfNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aj Jesús u yäli ca'da: ―“A xe a yajna'tan a Wajnoja Dios con to'o a ch'a'aljin uc'a tä' a wo a chenla, con to'o a pixan, con to'o a c'ajalin”. ");
INSERT INTO chfNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jinda une ni u manda Dios más c'änä ta tz'oninticba. ");
INSERT INTO chfNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","U chap'elibba es ca' chich jini täcä. U yäle' ca'da: “Yajna'tan a lot ca' chich a yajna'tan aba ane”. ");
INSERT INTO chfNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Si jini chap'e u manda Dios a laj tz'onänba, a chi chich cumpli upete ni ley taj Moisés y ni u tz'ibi ajt'anob ta Dios oniba. ");
INSERT INTO chfNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jinq'uin ya'to an aj fariseojob bajca an aj Jesús, une u c'atbijob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Cache'da a wäle'la ane, caxca une naj Cristo jini u yaqui Dios tuba ajnojaba? ¿Caxca u yajlo'? Aj fariseojob u p'ali ca'da: ―U yajlo' aj David une. ");
INSERT INTO chfNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aj Jesús u yälbenob: ―¿Cua' uc'a jiq'uin ni Ch'u'ul Pixan u yäc'bi u yäle' aj David cache' u Yajnoja? Uc'a aj David u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ajnoja Dios u yälbi Cajnoja: “Chumi' täc noj ixta que cä tzupsäben u poder ni machcatac mach yo u chänenetba, ca' a wälä a xäc'teq'ue'ob tä cab”. ");
INSERT INTO chfNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bada jiq'uin, si aj David u yälben aj Cristo cache' u Yajnoja, ¿cache'da a wäle'la jiq'uin cache' u yajlo'? ");
INSERT INTO chfNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Niuntu mach u che trebe u p'alben u t'an. Niuntu mach u ni' oli u c'atben niump'e cua' desde jimba q'uin jini. ");
INSERT INTO chfNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","De ya'i aj Jesús u yälbijob ni gente y ni u yajcänt'anob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Jini que tä' yuwijob ni ley taj Moisésba y aj fariseojob nämä tä paq'uin chumtä bajca u ye'e' ni u t'an Dios u tz'ibi aj Moisésba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jin uc'a cälbenetla, c'änä chich a ubinla cua' u yäle' y a chenla ca' chich u yälbenetla a chenla. Pero mach a chenla ca' chich u chenob unejobba, uc'a q'uen cua' u yäle' que utz utic y unejobba mach u che. ");
INSERT INTO chfNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Uc'a unejob ca' a wälä u cäche' ump'e noj cuch tä' alba que mach u totoj ut trebe tä bisinte, y u yäc'benob tu pechquem winicob tuba u bisan, y unejobba ni t'oc untz'it u ni'c'äb mach yo u täle'. ");
INSERT INTO chfNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Upete ni u chenob uneba, tuba chich chänintic pancab. U cäche'ob tu jut y tu c'äb ump'e cua' chichca nojba que tz'ibi u t'an Dios tuyac'o. U jele' ubajob t'oc u noj buc que ayan u noj tamäl jelquiba tu ti'ba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tä' yojob chumlec bajca an ni chumlib más utzba bajca u xe tä c'uxnanob. Tä' yojob chumlec bajca an ni chumlib más pitzi tu pänte' ni gente tama ni ch'uj taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tä' yojob täcä utic saludajob tä calle, y tä' yojob älbinticob cache' maestrojob. ");
INSERT INTO chfNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero anelaba, mach a wäctanla que otros u yälbenetla cache' maestrojetla; uc'a untuntu ni a maestrolaba, aj Cristo une. Y apete anelaba hermanojetla. ");
INSERT INTO chfNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mach xiquet a päpä' älbenla cachichca une pancab cache' a papla täcä, uc'a untuntu ni a Paplaba, jin une ni ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mach a wäctan älbintiquetla cache' ajnojaletla, uc'a untuntu ni ajnojaba, aj Cristo une. ");
INSERT INTO chfNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Machca yo xic más ajnoja de anela c'änä sujlec de a wajpatanla. ");
INSERT INTO chfNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uc'a machca u chen uba ca' noj don winicba, u xe tä quisnäjescan. Machca u chen uba ca' ajch'och'oca, u totoj xe tä sujtä de noj don winic. ");
INSERT INTO chfNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ac'ä tä' lástimajetla, anela que a wila ni ley taj Moisés y aj fariseojob! ¡Ajsusuccheriajetla! Uc'a anela ca' a wälä a mäcbenla u ti' bajca u chen manda ni Dios ya'an tä cieloba tuba mach ochic ni gente. Anela mach uyochetla, y mach a wäctala täcä ochic ni machcatac yo ochicob. ");
INSERT INTO chfNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ac'ä tä' lástimajetla, anela que a wila ni ley taj Moisés y aj fariseojob! ¡Ajsusuccheriajetla! Uc'a anela tä' a wo a ch'ämbenla cua' chichca u cänäntan neba'täc ixictac, a susuc chen aba cache' tu toja ayanetla t'oc a noj c'änti'yala. Jin uc'a más c'ux ni toji'tanä a xe tä äc'bintela. ");
INSERT INTO chfNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ac'ä tä' lástimajetla, anela que a wila ni ley taj Moisés y aj fariseojob! ¡Ajsusuccheriajetla! Ixta tunxe nab, ixta tunxe u pancab a numela tuba a q'uexben u c'ajalin untu tuba ochic t'oc anela. Ca' jini machcatac u yoche t'oc anela, a xe a wäc'ben u yosen más q'uen u tanä que anela tuba u toje' tan noj c'ac'. ");
INSERT INTO chfNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ac'ä tä' lástimajetla! Anelaba ajye'bijetla pero ca' a wälä ajchoq'uetla, uc'a a wäle'la ca'da: “Machca u c'ajti'ben u c'aba' ni noj ch'u'ul otot tuba tz'onintic que u xe u chen cua' chichca jini que u yäle' que u xe u chenba, mach c'änä u chen si mach yo. Pero machca u c'ajti'in ni c'änc'än taq'uin ya'an tan noj ch'u'ul ototba jinq'uin u yäle' que u xe u chen cua' chichca jini, c'änä chich u chen une ca' chich u yäle'ba”. ");
INSERT INTO chfNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ajsinc'ajalinetla y ajchoq'uetla! ¿Camba más utz, ni c'änc'än taq'uin, o ni noj ch'u'ul otot que u yäq'ue' ch'u'ul ajnic ni c'änc'än taq'uin que u yälo tama tuba äc'bintic Dios? ");
INSERT INTO chfNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A wäle'la täcä ca'da: “Si untu u c'ajti'ben u c'aba' alta tuba tz'onintic que u xe u chen cua' chichca, mach c'änä u chen si mach yo u chen. Pero si untu u c'ajti'ben u c'aba' ni matän que u subbinte Diosba tuba tz'ombintic u t'an, c'änä chich u chen jini u yäle' que u xe u chenba”. ");
INSERT INTO chfNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ajsinc'ajalinetla y ajchoq'uetla! ¿Caxcamba jiq'uin más utz, u matän Dios, o jini alta que u yäq'ue' ch'u'ul ajnic jini matän que u yäc'can tu pamba tuba äc'bintic Dios? ");
INSERT INTO chfNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Co cälbenetla, machca u c'ajti'in ni alta tuba tz'ombintic u t'an, u c'ajti'in chich täcä con to'o upete ni u yäc'can tu pamba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Y machca u c'ajti'ben u c'aba' ni noj ch'u'ul ototba, u c'ajti'in chich täcä con to'o u c'aba' u Yum. ");
INSERT INTO chfNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Machca u c'ajti'ben u c'aba' cielo, u c'ajti'ben u c'aba' täcä u chumlib Dios bajca u chen manda, con to'o ni Dios que ya' chumu tu pam ni u chumlibba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ac'ä tä' lástimajetla, anela que tä' a wila ni ley taj Moisés y aj fariseojob! ¡Ajsusuccheriajetla! Uc'a anelaba a wäc'benla chich lo que es tuba Diosba, ajump'e de cada diez mazo ni yerba buena, ni anís, y ni cuminos. Pero ni más c'änä a chenlaba, mach a chela une, jini u yäle' tan u manda Dios ca'daba: “Ajniconla tu toja, ajnic utz cä c'ajalinla, y cä tz'onänla”. Jintacda ni c'änä a chenlaba sin que a wäctan a chenla ni cäli najtäcäba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ajye'bijetla pero ca' a wälä ajchoq'uetla! Jini que mach tä' c'änäba, a tz'onänla chich a chenla, pero jini más tä' c'änäba, mach a chela. Es ca' a wälä jinq'uin u yälo untu a'uch'a' tan a buc'alaba, a c'alin sisänla une, y si a chänenla untu noj ajcamello tan a buc'alaba, mach a che caso a pa'senla. Con to'o jin a buq'ue'la. ");
INSERT INTO chfNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ac'ä tä' lástimajetla, anela que tä' a wila ni ley taj Moisés, y aj fariseojob! ¡Ajsusuccheriajetla! Anela a chen aba cache' tu toja ayanetla. Anela ca'da anetla, ca' jinq'uin a poque'la ni t'ub y ni plato, seq'uen tu pat namás, y u cababa a colesbenla tama. Ca' jini an tan a pixanla, a chen pensa a chen xuch'la y a chenla lo que u te tan a c'ajalinla a chenla, ni mach utzba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Anela choc' aj fariseo, poco najtäcä tama ni t'ub, uc'a ca' jini colac poco ixta tu pat. Uc'a si a wäq'ue' tä pojcan a pixanla, a xe a chen trebe a chenla tu toja. ");
INSERT INTO chfNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ac'ä tä' lástimajetla anela que tä' a wila ni ley taj Moisés y aj fariseojob! ¡Ajsusuccheriajetla! Anela ca' a wälä u noj mucliba ajchämejob, que atotaj säq'uesquiba. Tu patba cheque cache' tä' pitzi, pero tamaba tulu ayan de u bäque ajchäme y de c'unen bec'ta que tä' xilaw. ");
INSERT INTO chfNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Anela täcä ca' jini anetla. Tu jut winicob a chänintela cache' tu toja ayanetla, pero tan a pixanlaba q'uen susuccheria y q'uen malujle ayan. ");
INSERT INTO chfNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ac'ä tä' lástimajetla, anela que tä' a wila ni ley taj Moisés y aj fariseojob! ¡Ajsusuccheriajetla! A cherbenla u noj mucliba ajt'anob ta Dios y a pitzilesbenla u noj mucliba jini machcatac u chi tu tojaba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A wäle'la täcä ca'da: “Si fuera cuxleconla jinq'uin cuxlijob cä najtäcäl noxi'papla, machica cä täclila u tzämsenob najt'anob ta Dios”. ");
INSERT INTO chfNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Uc'a a wäle'la ca' jiniba, a wäq'ue' tä wina'tintela cache' u ch'ocobetla chich ni machcatac u tzämsijob najt'anob ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Anela täcä, chenla jiq'uin jini a wo a chenla, y ca' jini nonoj tzupsen a chenla jini u täq'ui u chen a najtäcäl noxi'paplaba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Ca' a wälä noj chanetla! ¡U ch'ocobetla chan! Mach'an cache'da a xe a chen trebe a japän aba t'oc ni noj toji'tanä tan c'ac' tä infierno. ");
INSERT INTO chfNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Bada jiq'uin, ubinla: No'on cä xe cä täscun bajca anetla ajt'anob ta Dios. Cä xe cä täscun machca q'uen u c'ajalinob, cä xe cä täscun jini que tä' yuwijob u t'an Diosba. Unejobba a xe a tulaj tzämsenob y a xe a tulaj äq'ue'la tä cruz. Y otros a xe a jätz'e'la tama a ch'ujla y otros a xe a tz'ibajtesanla tä cabil cab. ");
INSERT INTO chfNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jin uc'a u xe tä yälo ta'wac'ola ni toji'tanä bajca tzämsinti pancab machcatac u chi utzba, desde jinq'uin tzämsinti aj Abel, ni u chi tu toja tu jut Diosba, ixta jinq'uin chämi aj Zacarías, u yajlo' aj Berequías jini tzämsintiba bajca an a ch'ujlaba tu ch'ejpa ni altaba. ");
INSERT INTO chfNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Totojtoj cälbenetla cache' upete ni tanä jiniba anela täcä a xe a toje'la. ");
INSERT INTO chfNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Anela tä Jerusalén, anela que a tzämsenla ajt'anob ta Dios, y a wäc'benla t'oc ji'tun machcatac Dios u täscun bajca anetla! Jäynumixti coli cä mote'etla con to'o a ch'ocob, ca' chich untu na' piyo' u mote' u ch'oc tu yaba u wich', y anelaba mach a wolila cä chen ca' jini t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ubinlaba, ni bajca anetlaba con to'o a noj ch'u'ul ototlaba Dios chich u waläcti. ");
INSERT INTO chfNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Uc'a totojtoj cälbenetla, desde bada mach uni' xet a chänenonla ixta que jinq'uin a xe a wäle'la ca'da: “Ch'u'ul ayan jini u te tu c'aba' Cajnojala”. ");
INSERT INTO chfNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jinq'uin pasi aj Jesús tama ni noj ch'u'ul otot, bixe u chen, u natz'i u yajcänt'anob tuba u ye'benob u pitzilan ni noj ch'u'ul otot jini. ");
INSERT INTO chfNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Uneba u p'ali, u yälbijob ca'da: ―¿A chänenla upete ni jini? Totojtoj cälbenetla cache' mach uxin tä colan niump'e ji'tun tz'äjca tu pan u lot sin que mach jinescac. ");
INSERT INTO chfNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jinq'uin ya' chumca tu pam ni noj tz'ic u c'aba' Olivasba, u natz'i u yajcänt'anob u c'atbenob u juntuma ca'da: ―Älbenon t'ocob, ¿caxca q'uin u xe u chen pasa ni a wäliba? ¿Cua' jini u xe tä chäncan uc'a wina'tintic cache' ya' a te, y cache' atz'äcti q'uin tuba xupic u pancab? ");
INSERT INTO chfNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aj Jesús u p'ali, u yälbijob ca'da: ―Iranla jiq'uin, mach me'ixto ajnic machca u sucpecänetla. ");
INSERT INTO chfNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Uc'a q'uen u xe tä te täj c'aba', u yäle'ob ca'da: “No'on naj Cristojon”, y q'uen u xe u sucpecänob. ");
INSERT INTO chfNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A xe a ubinla cache' an jo'yan pancab y cache' u xe tä ajtä täcä cachichcada pancab. Iranla jiq'uin que mach u bäc'tesanetla, uc'a c'änä chich que u chen pasa najtäcä ni jini. Pero mach to jin u xupiba u pancab ni jini. ");
INSERT INTO chfNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Uc'a u xe tä ch'oye jo'yan. Ump'e noj cab u xe u jule' uba tuyac'o otro noj cab. Untu ajnoja u xe u jule' uba tuyac'o otro ajnoja. U xe tä ajtä noj toyoben yaj. U xe tä ajtä wi'na. U xe tä ajtä noj gran ajchaban cachichcada tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero upete ni jindaba, u tä'quiba to ni noj tz'ibajtesia que u xe tä ajtäba. ");
INSERT INTO chfNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jinq'uinba, a xe tä äc'canla tu c'äb machca u tz'ibajtesanetla, y a xe tä tzämsintela. Y upetejob mach uxin u yolin u chänenetla uc'a a tz'ombenonla. ");
INSERT INTO chfNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jinq'uinba, q'uen u xe tä ajtä machca u xe tä sujtä tu patob. U xe tä ajtä q'uen machca u yäq'ue' tä c'äbä u lot. U xe tä ajtä q'uen machca u maläc cräxna'tan ubajob t'oc u lot. ");
INSERT INTO chfNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y u xe tä ch'oye jimba q'uin jini q'uen ajjop'ojti'ob u yäle' cache' ajt'an ta Dios, y q'uen machca u xe u sucpecän. ");
INSERT INTO chfNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Uc'a u xe tä c'ac'a' q'ue'nan ni malujle pancab, jin uc'a q'uen u xe u yäctan u yajna'tan ubajob. ");
INSERT INTO chfNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Machca u c'älen upete ni jini ixta tu xupiba, sin sujlec tu pat, Dios u xe u japän. ");
INSERT INTO chfNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","U xe tä tz'ayquinte cachichcada pancab cache'da an bajca u chen manda Dios tuba u yubinob upete a'ajtä pancab. Ji'pat de jinda, u xe tä c'ote u xupiba q'uin pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’A xe a chänenla u yute cua' chichca mach utz tama ni ch'u'ul otot ixta u yäq'ue'ob cua' chichca tuba ch'u'ul c'ajti'cac en lugar de Dios, jini que mach yo Dios u chänenba. Jin une ni u yäli aj Daniel, ajt'an ta Dios oniba cache' u xe u chen pasa ―machca u tzique', c'änä u chen entende―. ");
INSERT INTO chfNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jinq'uinba, machcatac ya'an tan noj cab tä Judea, c'änä pasic tä putz'ejob pan noj tz'ic. ");
INSERT INTO chfNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Machca ya'an tu pam u cha'täq'uib otot isqui, mach ni' sujlec tan yotot u ch'e' cua' chichca. ");
INSERT INTO chfNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Machca ya'an tä patan tan pimi, mach ni' sujlec u ch'e' u buc tan yotot. ");
INSERT INTO chfNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ac'ä tä' lástimajob ni ixictac machcatac c'ojo t'oc u tz'isaba jimba q'uinob jini, y machcatac ch'oc to u bijch'ocba. ");
INSERT INTO chfNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","C'atbenla Dios jiq'uin, que mach u chen pasa tu q'uini sisi, ni tu q'uini ch'ämbäji jinq'uin c'änä pasiquet tä putz'ela. ");
INSERT INTO chfNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Uc'a jimba q'uinob jiniba u xe tä ajtä noj gran tz'ibajtesia, jini que mach bay ajni desde jinq'uin uti u pancabba ixta bada, y mach uxin tä sujtä tä ajtä ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Si fuera Dios mach u tz'ita'esan ica ni q'uin jini, niuntu mach uxin u japän uba t'oc chämo. Pero uc'a machcatac u yaqui Diosba, u xe chich u tz'ita'esan ni q'uinob jini. ");
INSERT INTO chfNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Si machca chichca u yälbenetla jiq'uin ca'da: “Iranla, ya'anda naj Cristo”, o “Iranla, ya'an nanti”, mach a tz'onänla. ");
INSERT INTO chfNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Uc'a u xe tä te machca u päpä' äle' cache' une naj Cristo, o cache' une ajt'an ta Dios, y u xe u chenob q'uen cua' chichca ta chänintic, y q'uen milagros tuba u jiran si u chen trebe u sucpecänob täcä ixta jini machcatac yäcä an uc'a Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bada jiq'uin, acä worin älbetla. ");
INSERT INTO chfNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jin uc'a jiq'uin, si u yälbenetla machca chichca ca'da: “Ubinla, ya'an nanti bajca mach cuxu niuntu ni aj Cristo”, mach xiquet a chänenla. O si u yälbenetla: “Ya'an mucu tama ump'e otot”, mach a tz'ombenla. ");
INSERT INTO chfNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Uc'a ca' chich a chänenla u lem ni chawäc u pase tä weti q'uin u chictan ixta tä pomi q'uin, ca' jini täcä u xe u chen pasa jinq'uin cä xe tä te no'on, que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Uc'a cachichcada ajnic cua' chichca chämen, ya'i chich u xe u motlan uba ni ajma' tuba u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Cuanta laj tz'äcti u chen pasa ni tz'ibajtesia jiniba, seb u xe tä it'obnan ni q'uin. Ni uj mach uxin u chictan. Ajlucerojob tä cielo u xe tä yälo. Upete ni ya'an tä cielo q'uen u muc'obba u xe tä laj niquinte. ");
INSERT INTO chfNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jinq'uin u xe tä chectan tä cielo cache' ya' cä te no'on que sutwänon de winic. Jinq'uinba, upete a'ajtäjob pancab u xe u chen uq'uejob. U xe u chänenonjob, no'on que sutwänon de winic, cache' cä xe tä te tama ump'e noj bucla tä cielo t'oc cä poder y t'oc cä noj pitzilan. ");
INSERT INTO chfNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cä xe cä täscun cä ángelojob t'oc noj corneta tuba u mote'ob ni machcatac yäcäjtac uc'a Diosba, cachichcada ajnicob ixta tu chämp'elma u jo u pancab, desde tu jo cielo ixta tunxe u jo cielo. ");
INSERT INTO chfNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Tic ta' c'ajalinla cua' u ye'benetla ni te' higo. Jinq'uin a chänenla u pase u nuc', y u ch'oc yopin, a wila chich cache' mach ni' q'uen yo ta wa'lec noj ticäw q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Che' chich täcä, jinq'uin a chänenla que u chen pasa upete ni jini, a xe a wina'tanla que jin ni mero u q'uini ta sujlecon. ");
INSERT INTO chfNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Totojtoj cälbenetla que mach to laj cham ni gente ya'an badaba jinq'uin u xe u chen pasa upete ni jini. ");
INSERT INTO chfNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ni cielo y u pancab u xe tä xupo. Ni cä t'anba mach uxin tä colan niump'e sin que mach laj utic cumpli. ");
INSERT INTO chfNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Niuntu mach yuwi camba q'uin ni camba hora u xe u chen pasa ni jinijob. Ni ángelojob ta Dios täcä ya'an tä cieloba mach yuwijob. Seq'uen cä Pap une ya'an tu c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ca' chich u chi pasa tu q'uini aj Noé, che' chich u xe u chen pasa täc xe tä te no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jinq'uin mach to an ni noj lup, ni a'ajtäjob pancab u c'uxnanob, u buc'ajob, u lotojanob, y u yäq'ue' u jixic ch'ocjob tä lotojan, ixta jimba q'uin que ochi aj Noé tama u noj jucub. ");
INSERT INTO chfNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mach se'in ti tu c'ajalinob cua' u xe u chen pasa ixta que jimba q'uin jini que c'oti chich ni noj lup y u laj tzämsi chich upetejob. Ca' jini u xe u chen pasa täc xe tä te no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jimba q'uin jini cha'tu winic u xe tä ajtä tä patan; untu u xe tä ch'ämcan, y untuba u xe tä colescan. ");
INSERT INTO chfNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cha'tu ixic u xe tä ajtä tä juch'ob. Untu u xe tä ch'ämcan y untuba u xe tä colescan. ");
INSERT INTO chfNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Wäybetanla jiq'uin, uc'a mach a wila cua' hora u xe tä te ni a Wajnojala. ");
INSERT INTO chfNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tic ta' c'ajalinla, jiq'uin, si fuera u yum ump'e otot yuwina'tan ica cua' hora u xe tä c'ote ajxuch', uneba u wäybetan y mach u yäcta ochic ni ajxuch' tan yotot. ");
INSERT INTO chfNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jin uc'a cälbenetla anela täcä cache' c'änä ajniquetla listo, uc'a no'on que sutwänon de winic cä xe tä te ump'e hora que anela mach a wina'tala. ");
INSERT INTO chfNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Caxcaba ajpatan jiq'uin, que u paq'uin chen ca' chich u yälbinte u chen, y an u c'ajalin? Jin une u yum otot u yäc'bi tu c'äb upete cua' chichca tuba u yäc'ben cua' u c'uxe' ni otros ajpatanob tu horäji. ");
INSERT INTO chfNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Noj ch'a'aljin tuba ni ajpatan jini jinq'uin u c'ote u chänen u yum otot cache' mu' u chen ca' chich u yäc'bi u chenba. ");
INSERT INTO chfNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Totojtoj cälbenetla cache' niump'e cua' mach uxin tä colan sin que mach u yäc'ben tu c'äb jini u yajpatan tuba u chen manda. ");
INSERT INTO chfNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero si mach utz u c'ajalin jini ajpatan y u yäle' tan u pixan ca'da: “Cä yumba mach to uxin tä se'in te”, ");
INSERT INTO chfNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y si u täq'ue' u cune' ni otros ajpatanob, y u bon chibälnan t'oc ajchibajob y u bon c'uxnanob t'oc, ");
INSERT INTO chfNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","u yum ni ajpatan jini u xe tä te ump'e q'uin jini que mach mu' u pijnan, y ump'e hora que mach yuwi une. ");
INSERT INTO chfNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Y u xe u yäc'ben ump'e noj toji'tanä tä' c'uxba. U xe u chen castiga nämte' t'oc ni ajsusuccheriajob. Ya' jini u xe u chen uq'ue, y u xe u chen cäch'äcne yej. ");
INSERT INTO chfNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’U manda ni Dios ya'an tä cieloba u xe tä ajtä ca'da une: Ajni diez telomilba que ya'an u pijnanob ajlotojan t'oc u candil tu c'äbob. ");
INSERT INTO chfNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco de unejobba q'uen u c'ajalinob, y cinco de unejobba mach totoj an u c'ajalinob. ");
INSERT INTO chfNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jini mach totoj an u c'ajalinobba u bisijob u candil, pero mach u bisijob más gas. ");
INSERT INTO chfNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jini q'uen u c'ajalinobba u bisijob u candil y u bisijob täcä u botella de gas. ");
INSERT INTO chfNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","C'ac'a' jäläcni najlotojan, mach se'in c'oti. Ti wäye tu jutob y laj wäyijob. ");
INSERT INTO chfNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tänxin ac'äb u yubijob ump'e noj t'an ca'da: “¡Iranla, ya' u te ni ajlotojan! Seb xiquet a nuc'tanla”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jinq'uin u yubijob, ch'oyijob ni telomilba jini u chen listujob u candil. ");
INSERT INTO chfNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ni mach totoj an u c'ajalinobba, u yälbijob ni más q'uen u c'ajalinob ca'da: “Benon t'ocob tz'ita' a gasla, uc'a mu' u täpo ni cä candil t'ocob”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jini q'uen u c'ajalinobba u p'albijob ca'da: “Cux mänä ta'ala bajca u choncan uc'a mach xic u chen falta täc'a t'ocob ni ta'ala täcä”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mientras bixi u mäne'ob ni gas, c'oti ajlotojan. Jini listo ayan u pijnanobba ochijob t'oc nämte' najlotojan tama otot bajca u xe tä c'uxnanob. De ya'i mäcbinti u ti' ni otot. ");
INSERT INTO chfNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ji'pat c'otijob täcä ni telomilba bixi u mäne' u gasba, u yäle' ca'da: “¡Cajnoja, Cajnoja! Jäbbenon t'ocob ti' ni otot”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ni ajlotojan u p'ali ca'da: “Totojtoj cälbenetla, anelaba mach cä chet conocela”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","De ya'i aj Jesús u yälbijob ca'da: ―Wäybetanla jiq'uin, uc'a anela mach a wila camba q'uin ni cua' hora cä xe tä sujtä, no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ni gente que ya'an tu manda ni Dios ya'an tä cieloba, es ca' u yajpatanob untu winic. Jini winic tu bixe nat u joq'ui u yajpatanob, y u yäc'bi tu c'äbob u taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Untu u yäc'bi cinco mil de säsäc taq'uin. Otro untu u yäc'bi chap'e mil. Otro untu u yäc'bi ump'e mil. U yäc'bi cada juntu ca' chich an u c'ajalin tuba u q'ue'nesan ni taq'uin. De ya'i bixi nat ni winic. ");
INSERT INTO chfNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jini u ch'i cinco mil de säsäc taq'uinba, bixi u sacän cua' u chen t'oc ni taq'uin. U chi gana t'oc otros cinco mil más. ");
INSERT INTO chfNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Che' chich täcä u chi ni u ch'i chap'e milba. U chi gana täcä otros chap'e. ");
INSERT INTO chfNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jini u ch'i ump'e milba, bixi t'oc y u chi ump'e noj ch'en tuba u muque' ni taq'uin u yäc'bi u yumba. ");
INSERT INTO chfNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Cuantu c'ac'a' jäläcni u bixe u yum ni ajpatanob jini, sujli tä cha'num, u jiran cua'tac u chi ni ajpatanob t'oc jini taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jinq'uin c'oti jini u ch'i cinco mil de säsäc taq'uinba, u täsi otros cinco mil, u yäle' ca'da: “Cä yum, cinco mil de säsäc taq'uin a wäc'bonba, iran ya'anda otros cinco mil acä chi gana t'oc”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","U yum u yälbi ca'da: “Utz chich, mejor cajpatanet, a chi chich tu toja. T'oc tz'ita' a chi tu toja. Bada q'uen cä xe cä'benet ta' c'äb, ch'a'alesan ajin ca' chich ch'a'a cäjin no'on”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","C'oti täcä jini u ch'i chap'e milba u yäli ca'da: “Cä yum, ni chap'e mil de säsäc taq'uin que a'bonba, iran cache' acä chi gana t'oc otros chap'e”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","U yum u yälbi ca'da: “Utz chich, mejor cajpatanet, a chi chich tu toja. T'oc tz'ita' a chi tu toja. Bada q'uen cä xe cä'benet ta' c'äb, ch'a'alesan ajin ca' chich ch'a'a cäjin no'on”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ji'pat c'oti täcä ni u ch'i ump'e milba u yäli ca'da: “Cä yum, ti täj c'ajalin cache' tä' cäräxet, a laj ch'ämben u jut ni päc'äbi que u päq'ui a wajpatanob, bajca mach a päq'ui cua' y bajca mach a t'it'i cua'. ");
INSERT INTO chfNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jin uc'a bäc'ton y cä ch'i ni taq'uin que a'bonba cä muqui yaba cab. Badaba cä täsbet uc'a ta'a chich une”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","U p'ali u yum ni ajpatan, u yälbi ca'da: “Aneba, tz'ubet, mach a che servi ta cajpatan. Ti ta' c'ajalin cache' no'on cä laj ch'ämben u jut bajca mach cä päq'ui, y bajca mach cä t'it'i cua'. ");
INSERT INTO chfNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jin uc'a yoli a wäq'ue' cä taq'uin ti'o banco, uc'a bada que asujlonba cä pa'sen une con to'o ni u chi gana ya'iba”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","De ya'i u yum ni ajpatan u yälbi machcatac ya'anob nämte' t'oc ca'da: “Jajbenla jiq'uin ni taq'uin, y äc'benla ni machca u cänäntan diez milba. ");
INSERT INTO chfNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Uc'a machca u cänäntanba, u xe tä äc'binte más, y mach uxin u chen falta tuba. Ni machca mach u cänäntaba, ixta lo que u cänäntanba u xe tä pa'säbinte. ");
INSERT INTO chfNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pa'senla jini ajpatan que mach u che serviba. Julula päti tan it'obni. Ya'i u xe u chen uq'ue y u xe u chen cäch'äcne yej”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Täc te no'on que sutwänon de winic, t'oc cä noj pitzilan y t'oc upete ni ch'u'ul ángelojob ta Dios, cä xe tä chumtä tä manda t'oc noj poder. ");
INSERT INTO chfNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","De ya'i u xe u laj woye' uba täc pänte' upete ni a'ajtäjob pancab. Y no'on cä xe cä laj jec'lanob, ca' chich u jeq'ue' u oveja t'oc ajchibu ni ajcänänya. ");
INSERT INTO chfNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cä xe cäq'ue' ni oveja täc noj, ni ajchibu täc tz'ej. ");
INSERT INTO chfNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jinq'uin no'on de Ajnojalon cä xe cälbenob ni an täc nojba: “La'ixla, anela que cä Pap u ch'u'ul chetla. Ta'ala chich une bajca u chen manda ni Dios, jini u worin tusbetla desde jinq'uin uti u pancabba. ");
INSERT INTO chfNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Uc'a cä na'ti jitz'o, y a c'uxnesonla. Cä na'ti tiquin ti'a, y a buc'sonla. Numon ca' untu ajpäpä'cab, y a wosonla tan a wotot. ");
INSERT INTO chfNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ajnon sin buc, y a wäc'bonla cä buc. Ajnon c'ojo, ajnet a wiranonla. Ajnon tä cárcel, ajnet a chänenonla”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","De ya'i ni machcatac an tu tojajobba u xe u yäle'ob ca'da: “Cajnoja, ¿caxca q'uin cä chänet t'ocob a na'ti jitz'o y cä'bet t'ocob cua' a c'uxe'? ¿O a na'ti tiquin ti'a y cä'bet t'ocob cua' a wuch'en? ");
INSERT INTO chfNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O ¿caq'uin cä chänet t'ocob ca' untu ajpäpä'cab y coset t'ocob tan cotot? ¿O sin buc y cä'bet t'ocob a buc? ");
INSERT INTO chfNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O ¿caq'uin cä chänet t'ocob c'ojo o tä cárcel y ajnon quiranet t'ocob?” ");
INSERT INTO chfNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y no'on ni Ajnojalonba cä xe cä p'albenob ca'da: “Totojtoj cälbenetla, jinq'uin a ch'ämbila yajin untu de ni quermanojobda ni más u ch'och'ocajobba no'on chich une a ch'ämbonla yajin”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’De ya'i cä xe cälbenob täcä ca'da ni machcatac ya'an täc tz'ejba: “Tz'eje abala t'oc no'on. Anela choco anetla uc'a Dios. Cuxla tama ni noj c'ac' que mach uxin tä täpo nuncaba, jini worin uti tuba aj Satanás con to'o u yajc'äncanobba. ");
INSERT INTO chfNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Uc'a cä na'ti jitz'o, y mach a'bonla cua' cä c'uxe'. Cä na'ti tiquin ti'a, y mach a'bonla cua' cuch'en. ");
INSERT INTO chfNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Numon de ajpäpä'cab y mach a wosonla tan a wotot. Ajnon sin buc y mach a'bonla cä buc. Ajnon c'ojo y ajnon tä cárcel, y mach ajnet a wiranonla”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Unejob täcä u xe u p'alän ca'da: “Cajnoja, ¿caxca q'uin cä chänet t'ocob a na'tan jitz'o, a na'tan tiquin ti'a, o numet de ajpäpä'cab o ajnet sin buc, ajnet c'ojo, o tä cárcel, y mach cä cherbet t'ocob lo que c'änä cherbintiquet?” ");
INSERT INTO chfNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","No'on cä xe cä p'albenob ca'da: “Totojtoj cälbenetla, jinq'uin mach a cherbila untu de ni más ajch'och'ocajobdaba lo que c'änä cherbintic, no'on täcä mach a cherbonla”. ");
INSERT INTO chfNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Unejobba u xe tä äc'binte ni toji'tanä que mach uxup nuncaba. Y ni machcatac an tu tojaba u xe tä äc'binte paq'uin cuxlecob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jinq'uin aj Jesús u tzupsi u yäle' upete ni t'anda, u yälbi u yacänt'anob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―A wila chich cache' chabi u tä'can ni q'uin ch'uje ta paxcu', y no'on que sutwänon de winicba cä xe tä äc'can tä c'äbä tuba äc'cacon tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jinchichba q'uin jini ni ajnojajob pale, y jini que tä' yuwijob ni ley taj Moisésba y ajt'äbälajob tuba ni caj u woyi ubajob pan otot tuba ni mero no' ajnoja pale u c'aba' aj Caifásba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Cayi u ch'e' u c'ajalinob tuba u jiran cache' u ch'e' u q'ueche' aj Jesús t'oc sucpecya y u tzämsenob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","U yälijob täcä: ―Mach yo cä q'ueche'la tama ni noj q'uin ch'ujeba, uc'a mach xic u jobän uba ni caj. ");
INSERT INTO chfNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ya'an aj Jesús tä Betania, tama yotot jini aj Simón, jini ajni c'ojo t'oc c'unen pächiba, ni yaj u c'aba' lepraba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","C'oti bajca an aj Jesús untu ixic t'oc untz'it yoc botella de pitzil ji'tun tu c'äb, tulu t'oc jätz'äcnib tä' choj u valorba. U ch'i u colbi tan u pam aj Jesús bajca chumca tä c'uxnan. ");
INSERT INTO chfNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jinq'uin u chäni u yajcänt'anob cua' uti, cäräx'ijob, u yälijob ca'da: ―¿Cua' uc'a cräx uti ni jätzäcnib jini? ");
INSERT INTO chfNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Uc'a ni jini u yoli choncac choj ca' chich u chen valeba y pucbintic u taq'uini ni pobrejilba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yuwi chich aj Jesús cua' mu' u yäle'ob, u yälbijob ca'da: ―¿Cua' uc'a a jaq'uesben ujin ni ixicda? Tä' utz ni cua' u cherbonba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Uc'a ni pobrejilba, ya' chich paq'uin an t'oc anela. No'onba mach paq'uin anon t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Uc'a jinq'uin u coli ni jätz'äcnib jini täjcac'o, u worin chi une ca' jini tuba jinq'uin cä xe tä mujcan. ");
INSERT INTO chfNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Totojtoj cälbenetla, cachichcada tu pancab tz'ayquintic ni t'an ta Diosba, ya' chich u xe tä tz'ayquinte täcä cua' u chi ni ixicda. ");
INSERT INTO chfNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Untu de ni doce u yajcänt'an aj Jesús u c'aba' aj Judas Iscarioteba, bixi bajca an u yajnojajob pale. ");
INSERT INTO chfNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","U yälbijob ca'da: ―¿Jäyp'e a wo a wäc'benonla tuba cä'benetla ta' c'äb aj Jesús? Unejob u tzicbi treinta säsäc taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Desde jimba hora jini aj Judas cayi u sacän cache'da u yäq'ue' tä c'äbä aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Primer q'uin de ni q'uin ch'uje, jini q'uin que u c'uxe'ob ni waj sin jusonibba, u natz'i u yajcänt'anob aj Jesús u yälbenob ca'da: ―¿Cada a wo cä tuse' t'ocob tuba a c'uxe' ni cua' tä c'uxcan ta paxcu'? ");
INSERT INTO chfNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Uneba u yäli ca'da: ―Cuxla tan caj tu yotot untu winic, y älbenla ca'da: “Ni Maestro u yäle' ca'da: Tz'ita' yo ta tz'äctac ni q'uin tuba tzämsinticon. Ta' wotot cä xe cä c'uxe' ni cua' tä c'uxcan ta paxcu' t'oc cajcänt'anob”. ");
INSERT INTO chfNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ni ajcänt'anob u chijob chich ca' chich u yälbi aj Jesús u chenob, y u tusijob ni cua' tä c'uxcan ta paxcu'. ");
INSERT INTO chfNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cuanta ochi ac'äb, chunwäni tä c'uxnan t'oc ni doce u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mu'to u c'uxnanobba, u yäli ca'da: ―Totojtoj cälbenetla, untu de anela u xe u yäq'ue'on tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","C'ac'a' ch'ocomi u pixanob, u täq'ui u juntu äle'ob ca'da: ―¿No'on wäreca, Cajnoja? ");
INSERT INTO chfNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aj Jesús u p'ali ca'da: ―Jini nämte' u jup'e' u c'äb t'oc no'on tan platoba, une ni u xe u yäq'ue'on tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Toj chich une, no'on que sutwänon de winicba cä xe tä cherbinte ca' chich u yäle' ni jun ta Dios tz'ibiba. Pero ¡ac'ä tä' lástima jini winic u xe u yäq'ue'on tä c'äbäba! Más utzica tuba jini winic si fuera mach päncäbac. ");
INSERT INTO chfNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","De ya'i aj Judas jini que u xe chich u yäq'ue' tä c'äbäba, u yäli ca'da: ―¿No'on wäreca, Maestro? Aj Jesús u yälbi: ―Ane chich a totoj äli. ");
INSERT INTO chfNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jinq'uin mu'to u c'uxnanobba, aj Jesús u ch'i ni waj, u ch'u'ul chi. De ya'i u taji, u yäc'bi u yajcänt'anob, u yälbijob ca'da: ―Da, c'uxula. Jindaba cä cuerpo une. ");
INSERT INTO chfNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","U ch'i täcä ni vaso, u ch'u'ul chi, u yäc'bijob, u yälbijob ca'da: ―Uch'enla apetela ni jinda. ");
INSERT INTO chfNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Jindaba cä ch'ich'e une, u ye'e' cua' u xe u chen Dios por anela, ca' chich u yäli jinq'uin u yäc'bonla ni tzijib t'an. Jini ch'ich'daba u xe tä ancäran uc'a pa'säbintic u tanäjob q'uen a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Bada cälbenetla cache' mach uni' xon cuch'en cha'num u c'ab ni jut uvada, ixta jimba q'uin jini jinq'uin cä xe cuch'enla ni tzijib c'äb uva ya'i bajca an u chen manda cä Papba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cuanta u chijob c'ay pasijob ya'i, bixijob tu pam ni noj tz'ic u c'aba' Olivas. ");
INSERT INTO chfNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","De ya'i aj Jesús u yälbijob ca'da: ―Apetela a xe a waläctanonla jimba ac'äbda. Uc'a tz'ibi chich ayan ca'da: “Cä xe cä tzämsen najcänän oveja y ni u oveja u xe u laj puclan uba”. ");
INSERT INTO chfNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Y cuanta cuxponba, cä xe tä c'ote tä Galilea najtäcä no'on; anelaba ji'pat. ");
INSERT INTO chfNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aj Pedro u p'ali, u yälbi ca'da: ―Mach u che si upete u waläctanetob, pero no'onba mach bay uxon cä waläctanet. ");
INSERT INTO chfNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aj Jesús u yälbi ca'da: ―Totojtoj cälbenet: Jimba ac'äbdaba, antes de u chen uq'ue ajtze, ane a xe a wäle' uxpetz' que mach a chon conoce. ");
INSERT INTO chfNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Aj Pedro u yäli ca'da: ―Mach u che si tzämsinticon t'oc ane, pero mach uxon cäle' que mach cä chet conoce. Che' chich u yäli upete u yajcänt'anob ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","De ya'i c'oti aj Jesús t'oc u yajcänt'anob tama ump'e bojte' bajca an päc'äbi. U c'aba' ya'i Getsemaní. U yälbijob ca'da: ―Chumi'ixtola wida, no'onba cä ne' xe nanti cä chen c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","U bisi aj Pedro y u cha'tuma u ch'ocob aj Zebedeo. U täq'ui tä c'ac'a' ch'ocoman u pixan ixta uc'ni u pixan. ");
INSERT INTO chfNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aj Jesús u yälbijob ca'da: ―Ac'ä mäx u ch'ocoman cä pixan uc'a cä na'tan cache' cä xe tä chämo. Colenla wida, wäybetanla t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bixi más pänte' tz'ita', de ya'i nocwäni u chinjatz'i u pam tä cab u chen c'änti'ya, u yäle' ca'da: ―Cä Pap, si u ch'e', japänon t'oc ni tz'ibajtesiada, sin que cä ch'e'. Pero mach utic ca' co no'onba; utic chich ca' a wo aneba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","De ya'i sujli bajca an u yajcänt'anob, y u chänijob cache' mu' u wäye. U yälbi aj Pedro ca'da: ―¿Niump'e hora mach a chi trebe a wäybetanla t'oc no'on? ");
INSERT INTO chfNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wäybetanla jiq'uin, y chen c'änti'yala, uc'a mach tic ta'wac'ola cua' u yäc'benet a säte'la. A pixanlaba yo chich u chen tu toja, pero a cuerpola mäx u säte'. ");
INSERT INTO chfNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bixi tä cha'num u chen c'änti'ya, u yäle' ca'da: ―Cä Pap, si mach u ch'ä a japänon t'oc ni tz'ibajtesiada sin que mach cä ch'e', chen ca' chich a wo ane. ");
INSERT INTO chfNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sutwäni tä cha'num aj Jesús y u chänijob cache' ya'anob tä wäye, uc'a tä' wäye yo u jutob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","U yäcti tä wäyejob, bixi u chen c'änti'ya u yuxpetz'ib. U yäle' tan u c'änti'ya ca' chich u yäli najtäcä. ");
INSERT INTO chfNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","De ya'i sutwäni tä cha'num bajca an u yajcänt'anob, u yälbijob ca'da: ―Wäyenla bada y ch'ä abala. ¡Iranla! Bada ac'oti u horäji tuba äc'cacon tu c'äb ajcherajtanäjob no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ch'oyenla, cola. Iranla, ya' u te jini machca u xe u yäq'ue'on tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","T'an to u chen aj Jesús, c'oti aj Judas, untu de ni docejobba. C'oti nämte' t'oc une noj q'uenel gente t'oc u machit y t'oc u te' tu c'äb. Ni gente jiniba ajnojajob ta pale y ni ajt'äbäla ta caj u täsquijob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aj Judas, jini u yäq'ui tä c'äbä aj Jesúsba, u worin älbijob ni gente ca'da: ―Machca a chänenla cä xe cä tz'utz'änba jin une. Q'uechela. ");
INSERT INTO chfNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","De ya'i seb u natz'i aj Jesús, u yälbi ca'da: ―Tanet, Maestro. Y u tz'utz'i. ");
INSERT INTO chfNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aj Jesús u yälbi ca'da: ―Cä lot, ¿cua' a t'an atet ane? De ya'i c'oti noj q'uenel gente u juli uba tuyac'ojob aj Jesús y u q'uechijob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Untu de ni ya'anob t'oc aj Jesúsba u jup'i u c'äb u päye' u machit bajca an tu pat, u yäc'bi t'oc untu u yajpatan ni mero no' ajnoja pale. U chunjätz'bi u chiquin. ");
INSERT INTO chfNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aj Jesús u yälbi ca'da: ―Suti' äc'ä na machit tu pat, uc'a upete machcatac u tzämsen u lot t'oc machitba, t'oc machit u xe tä tzämsinte täcä. ");
INSERT INTO chfNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A wäle' quira cache' mach u ch'ä cä c'atben cä Pap bada tuba u täscun más de doce mil ángelojob u japänon? Si cä c'atben ica, u täscun chich. ");
INSERT INTO chfNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero si ca' jini, ¿cache'da jiq'uin a wäle'la que u xe tä tz'äctan tä ute jini worin tz'ibi tama u jun Dios cache' c'änä tz'ibajtescaconba? ");
INSERT INTO chfNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jinchichba rato jini aj Jesús u yälbijob ni gente ca'da: ―¿A wäle'la quira cache' ajxuch'on jin uc'a atetla t'oc a machit y t'oc a te'la ta' c'äb tuba a q'ueche'on? Upete q'uin acä chumtä tama noj ch'u'ul otot cä ye'e' u t'an Dios y mach a q'uechonla. ");
INSERT INTO chfNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero upete mu' u chen pasa ca'da uc'a tz'äctac tä ute ca' chich u tz'ibi ajt'anob ta Dios oniba. De ya'i upete u yajcänt'anob aj Jesús u waläctijob y laj putz'ijob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ni machcatac u q'uechi aj Jesúsba u bisijob tu yotot aj Caifás, mero noj ajnoja pale. Ya'i chich worin woyo ayanob täcä jini que tä' yuwijob ni ley taj Moisésba y ni ajt'äbälajob ta caj. ");
INSERT INTO chfNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aj Pedroba u natil tzäypäti aj Jesús ixta que c'oti can yotot mero no' ajnoja pale. Jinq'uin ochi ya'i pan otot, chunwäni nämte' t'oc ni ajcänän ch'u'ul ototob tuba u chänen cua'tac u xe u chen pasa. ");
INSERT INTO chfNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ni noj ajnojajob pale, y ni ajt'äbälajob, y upete ni aj äc'c'ajalinob u sacänob machca u sube' t'oc ump'e jop'ojti' tuba u yäq'ue' tä tzämsinte aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","C'otijob chich q'uen u yäle' ni jop'ojti', pero mach u pojlijob niump'e que u yäq'ue' chämic. Ji'pat c'oti cha'tu u yäle' ump'e jop'ojti'. ");
INSERT INTO chfNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","U yälijob ca'da: ―Ni winicda u yäli ca'da: “No'on cä chen trebe cä jinesan ni noj ch'u'ul otot ta Dios, y uxp'e q'uin cä sujtä cä tz'osen”. ");
INSERT INTO chfNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wa'wäni mero no' ajnoja pale, u yälben aj Jesús ca'da: ―¿Mach a pojle cache' a xe a p'alän? ¿Mu' a ubin cache' mu' u yäle'ob tuba u sube'etob t'oc? ");
INSERT INTO chfNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aj Jesúsba mach u p'ali niump'e cua' une. Ni mero no' ajnoja pale u yälbi ca'da: ―Ni Dios cuxuba mu' u chänen. Totoj älbenon t'ocob si ane ni aj Cristojet, u Yajlo'et Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aj Jesús u p'ali ca'da: ―Ane chich a wäle' que jinon. Co cälbenetla täcä cache' a xe chich a chänenonla, no'on que sutwänon de winic, cache' cä xe tä chumtä tu noj ni Dios an u poderba, y cache' cä xe tä te täcä tama ump'e bucla tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jinq'uin u yubi ca' jini, ni mero no' ajnoja pale u tzili u buc de cräxle u yäle' ca'da: ―Tanä chich uc'a u yäli cache' mero u Yajlo' Dios. ¿Cua' tuba c'änä cäc'ala más machca u sube'? Iranla jiq'uin bada, anela chich a ubila u tanä. ");
INSERT INTO chfNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Cache' a wäle'la ane? Unejob u p'ali: ―C'änä chich tzämsintic une. ");
INSERT INTO chfNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","De ya'i u tubbijob u jut y u jätz'ijob, y otros u cunijob. ");
INSERT INTO chfNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","U yälbenob ca'da: ―Ane que a wäle' cache' aj Cristojet, pa'sen ta' c'ajalin caxca une u cunet. ");
INSERT INTO chfNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aj Pedroba ya' chumca päti pan ni otot. C'oti untu ixpatan bajca an une u yälben ca'da: ―Ane täcä nämte' ajnet t'oc aj Jesús ni u cab tä Galileaba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aj Pedro tu pänte' upete machca u yubinob u yäli que mach toj. U yäli ca'da: ―Mach cuwi cua' jini mu' a wäle'. ");
INSERT INTO chfNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pasi tä wa'tä ti' bojte'. Ya' jini otro untu ixic u chäni. Ni ixic u yälbi ni machcatac ya'an ya'i ca'da: ―Jini winicda täcä nämte' ajni t'oc aj Jesús jini u cäji tä Nazaretba. ");
INSERT INTO chfNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aj Pedro u yäli tä cha'num cache' mach toj ixta u c'ajti'bi u c'aba' Dios uc'a tz'onintic. U yäli ca'da: ―Mach cä che conoce ni winic jini. ");
INSERT INTO chfNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ji'pat tz'ita' machcatac ya'anob ya'i u natz'ijob aj Pedro u yälbenob ca'da: ―Totojtoj chich, ane täcä es untu de unejob. A t'an u ye'e' cache' jinet. ");
INSERT INTO chfNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","De ya'i aj Pedro u täq'ui cräxt'an ixta u c'ajti'ben u c'aba' Dios uc'a tz'onintic cache' mach toj. U yäli ca'da: ―Mach cä che conoce ni winic jini. Jimba rato u yäli ca' jini u chi uq'ue ajtze. ");
INSERT INTO chfNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","De ya'i aj Pedro ti tu c'ajalin u t'an aj Jesús ni u yälbi ca'daba: “Mach to u che uq'ue ajtze, aneba a xe a wäle' uxpetz' cache' mach a chon conoce”. De ya'i pasi päti aj Pedro y u c'ac'a' chi uq'ue. ");
INSERT INTO chfNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Päscab ic'sapan upete ni ajnoja palejob y ni ajt'äbälajob ta caj u woyli ubajob tuba u ch'e' u c'ajalinob cache' u xe u yäq'ue' aj Jesús tä tzämsinte. ");
INSERT INTO chfNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Cächä u bisijob aj Jesús bajca an ni gobierno, u c'aba' aj Poncio Pilato. ");
INSERT INTO chfNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","De ya'i aj Judas, jini machca u yäq'ui tä c'äbäba, jinq'uin u chäni cache' u xe tä tzämsinte aj Jesús, ch'ocomi u pixan y sutwäni u sutatz'ben ni treinta säsäc taq'uin ni no' ajnoja palejob y ni ajt'äbälajob ta caj. ");
INSERT INTO chfNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","U yälbenob ca'da: ―Ump'e noj tanä chich acä chi, cäq'ue' tä tzämsinte untu que mach u chi u tanä. Unejob u p'albijob ca'da: ―¿Cua' päq'uin täc'a t'ocob? ¿Caxto une u chet manda a chen ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","U jinjuli tä cab ni säsäc taq'uin tama noj ch'u'ul otot. Pasi une, bixi u ch'uy cäche' uba tu luc'ub tuba chämic. ");
INSERT INTO chfNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ni noj ajnoja palejob u ch'i ni treinta säsäc taq'uin, u yälijob ca'da: ―Mach utz cäq'ue'la ni taq'uinda tama bajca u yälo taq'uin tan ch'u'ul otot, uc'a u tojquiba une machca u yäq'ui tä tzämsinte untu winic. ");
INSERT INTO chfNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","U ch'i u c'ajalinob u mäne' ni cab bajca u yälbinte cache' u cab ajpätp'etba tuba u muclibajob ajtejob nat que u chämojob ya'iba. ");
INSERT INTO chfNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jin uc'a jini cab u ch'i u c'aba' Ch'ich' y che' chich u yälbinte ixta bada. ");
INSERT INTO chfNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ca' jini tz'äcti tä ute ni t'an u yäli ajt'an ta Dios oni u c'aba' aj Jeremíasba, jinq'uin u yäli ca'da: “U ch'ijob ni treinta säsäc taq'uin u valor ni winic chonquiba. Uc'a ca' chich jini u yälijob aj Israel que u xe u toje'ob. ");
INSERT INTO chfNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","U ch'ijob ni taq'uin y u mänijob t'oc ni cab bajca u yälbinte cache' u cab ajpätp'et. Ca' jini uti ca' chich u yälbon Cajnojala utic”. ");
INSERT INTO chfNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wa'ca aj Jesús tu pänte' ni gobierno, y ni gobiernoba u c'atbi ca'da: ―¿Ane quira ni Ajnojalet tuba aj judíosob? Aj Jesús u p'ali ca'da: ―Toj chich une, ane chich a wäli. ");
INSERT INTO chfNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jinq'uin u c'ac'a' sube'ob ni ajnojajob ta pale y ni ajt'äbälajob ta caj, uneba mach u p'ali niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","De ya'i aj Pilato u yälbi ca'da: ―¿Mach quira a ubi cua'tac u yäle'ob tuba u sube'etob? ");
INSERT INTO chfNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aj Jesúsba mach u p'ali niump'e t'an. Jin uc'a ni gobierno tajch'icwäni u jut u chänen ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ni gobierno nämä u chaje' untu preso tama ni q'uin ch'uje ta paxcu', cachichcone que u c'atän ni caj chajcac. ");
INSERT INTO chfNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ajni mäcä jimba q'uinob jini untu winic u c'aba' aj Barrabás, que upete yuwi cua'tac u chi. ");
INSERT INTO chfNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jinq'uin moto ayanob ni gente, aj Pilato u yälbijob ca'da: ―¿Caxcamba winic a wo cä chajbenetla, aj Barrabás o aj Jesús, ni u yälbinte aj Cristoba? ");
INSERT INTO chfNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Uc'a yuwi chich aj Pilato cache' u yäc'bijob aj Jesús tu c'äb uc'a mach yo u chänenob. ");
INSERT INTO chfNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jinq'uin ya' chumca aj Pilato bajca u chen manda, jit'oc u täscäbi tä älbinte ca'da: “Aneba mach a jup'e' aba a cherben cua' chichca ni winic jini que ayan tu tojaba, uc'a cä najli ni winic jini sami ac'äb, y c'ac'a' ch'ocomi cä pixan”. ");
INSERT INTO chfNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero ni ajnojajob ta pale y ni ajt'äbälajob ta caj u yäc'ben c'ajalinob ni gente que u c'atänob chajcac aj Barrabás, y aj Jesúsba tzämsintic. ");
INSERT INTO chfNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","De ya'i u yäli tä cha'num ni gobierno ca'da: ―¿Caxcamba de ni cha'tujobba a wola cä chajbenetla? Ni gente u yälijob ca'da: ―Aj Barrabás co t'ocob a chajbenon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aj Pilato u yälbijob ca'da: ―¿Cuaxca cä xe cä chen jiq'uin t'oc jini aj Jesús ni u yälbinte aj Cristoba? Upete u p'alijob ca'da: ―¡Tzämsintic tä cruz! ");
INSERT INTO chfNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ni gobierno u yäli: ―¿Caba tanä jiq'uin u chi? Unejob u chi más muc' noj t'an, u bon äle'ob ca'da: ―¡Tzämsintic tä cruz! ");
INSERT INTO chfNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","U chäni aj Pilato cache' mach u che trebe u japän, y upete lo que u chenba u yäc'ben u jobän uba más ni gente. Jinq'uin u chäni ca' jini, u ch'i ja' tuba u poque' u c'äb tu jut ni gente, u yäle' ca'da: ―Mach cä jup'u cäba no'on cäq'ue' tä tzämsinte ni winicda que an tu tojaba. Iranla ane cua' a cherbenla. ");
INSERT INTO chfNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","U p'ali upete ni gente, u yäli ca'da: ―Si ayan u tojquiba u chämo ni winic jini, tan u yälo täjcac'o t'ocob y tuyac'o cä ch'ocob t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","De ya'i ni gobierno u chajbijob aj Barrabás. U yäq'ui tä jätz'can aj Jesús, de ya'i u yäc'bijob tu c'äb ni soldadojob tuba u yäq'ue'ob tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","De ya'i ni soldadojob ta ni gobierno u bisijob aj Jesús tama u yotot jini gobierno, y upete ni soldadojob u woyli ubajob u junxoyma de une. ");
INSERT INTO chfNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","U laj pa'säbi u bucob aj Jesús tuyac'o, u xojbijob tuyac'o ump'e u noj chäclowen buc. ");
INSERT INTO chfNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","U yäc'bijob tan u pam ump'e u corona de jit'ib ch'ix, y u yäc'bijob untz'it oj u q'ueche' t'oc u noj. U noctäjob tu pänte', u susuc ch'u'ul c'ajti'inob, u yälbenob ca'da: ―¡Cä ch'u'ul c'ajti'inet ane, Ajnoja tuba aj judíosob! ");
INSERT INTO chfNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","U tubänob y u ch'ämbenob ni oj ya'an tu c'äbba, u yäc'benob t'oc tan u pam. ");
INSERT INTO chfNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cuantu xiq'uijob, u pa'säbijob tuyac'o ni u noj chäclowen buc, y u xojbijob ni u buc tuba chichba. De ya'i u bisijob tuba u yäq'ue'ob tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jinq'uin bixe u chenob, u nuc'tijob untu winic, tä Cirene u cab, u c'aba' aj Simón. U cocoj äc'bijob u bisben u cruz aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","C'otijob bajca ni u yälbinte cache' Gólgotaba, ni u yäle' tä yocot'an cache' bajca u yajtä u bäcpam ajchäme. ");
INSERT INTO chfNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jinq'uin c'otijob, u yäc'bijob aj Jesús vino xäbä t'oc ch'ajäl ja' tuba u yuch'en. Uneba u mitz'ti'i, y mach u ni' oli u yuch'en. ");
INSERT INTO chfNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cuanta u yäq'uijob tä cruz, u puclijob u buc, y u yäläsijob u jiran caxca une u xe u ch'e'. Jinq'uin u chijob ca' jini, pasi toj jini u yäli ajt'an ta Dios oni jinq'uin u yäli ca'daba: “U puclijob ni cä buc, y u yäläsijob tuba u jiran caxca une u xe u ch'e' ni cä buc tu pamba”. ");
INSERT INTO chfNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","De ya'i chunwäni ni soldadojob u cänäntanob. ");
INSERT INTO chfNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","U tz'ibijob bajca u yäle' cua' uc'a tzämsinti y u yäc'bijob tu pam u cruz u yäle' ca'da: “Jindaba aj Jesús ni Ajnoja tuba aj judíosob”. ");
INSERT INTO chfNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","U yäq'uijob täcä tä cruz cha'tu ajxuch' nätz'ä bajca an une, untu tu noj y untu tu tz'ej. ");
INSERT INTO chfNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Machcatac u numejob ya'i u xiq'ue'ob, u cherben u pamob, ");
INSERT INTO chfNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","u yäle'ob ca'da: ―Ane a wäle' cache' a jinesan ni noj ch'u'ul otot, y uxp'e q'uin a tz'osen cha'num, japän aba jiq'uin. Si totoj u yajlo'et Diosba, jaquen bajca anet tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ca' chichda täcä ni ajnojajob ta pale, y jini machcatac tä' yuwi ni ley taj Moisésba, y ni aj fariseojob, y ni ajt'äbälajob ta caj u bon xiq'ue'ob, u yäle'ob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Otrosjob u japi, y uneba mach u ch'ä u japän uba. Si totoj Ajnoja tuba aj Israel, jaquic jiq'uin bajca an tä cruz bada, uc'a cä tz'ombenla chich. ");
INSERT INTO chfNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U yäq'ui uba tu c'äb Dios, tax u japän bada jiq'uin si tä' yo Dios t'oc une, uc'a une chich u yäli ca'da: “No'on u Yajlo'on chich Dios”. ");
INSERT INTO chfNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ca' jini chich täcä u bon xiq'ue'ob ni ajxuch'ob, ni ya'anob nämte' t'oc tä cruzba. ");
INSERT INTO chfNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Desde tänxin q'uin ixta ochiq'uin yäli it'obni tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jinq'uin ochiq'uin aj Jesús u chi noj gran t'an, u yäle' ca'da: ―Elí, Elí, ¿lama sabactani? ―ni t'andaba ca'da u yäle' une: Cä Dios, cä Dios, ¿cua' uc'a a waläcton? ");
INSERT INTO chfNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tulaj ayanob ya'i machcatac u yubi ca' jini, u yälijob ca'da: ―Aj Elías une mu' u joq'ue', ni ajt'an ta Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jinchichba rato jini, ancäri untu de unejob tuba u ch'e' ump'e tz'u'i' ja'. U maji tama pajäl vino. De ya'i u läqui tuyac'o untz'it oj, u yäc'bi tu ti' aj Jesús tuba u yuch'en. ");
INSERT INTO chfNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Otrojobba u yäli ca'da: ―Äctaxtola quiranla si u te aj Elías u japän. ");
INSERT INTO chfNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aj Jesús u chi noj gran c'ämbäl awät cha'num, y chämi. ");
INSERT INTO chfNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jinchichba rato jini ni noj noc' tama ni ch'u'ul otot jini u ch'äcmäque' tamaba tajqui tänxin, desde isqui ixta emä. Noj ajchaban u niqui u pancab, y ni ji'tun laj tzali u juntuma. ");
INSERT INTO chfNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","U jäbi uba u mucliba ajchämejob. Q'uen machcatac chämi oni que tuba chich Diosba cuxpijob. ");
INSERT INTO chfNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pasijob tan u muclibajob cuanta cuxpi aj Jesús, y c'otijob tama ni noj ch'u'ul caj tä Jerusalén. Q'uen machcatac u chänijob. ");
INSERT INTO chfNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ni ajmanda tuba cien soldadojob, t'oc ni soldadojob que ya'an nämte' t'oc u cänäntanob aj Jesús, jinq'uin u chänijob upete cua' chichca que u chi pasa y ni noj ajchaban, c'ac'a' bäc'tijob, u yäle'ob ca'da: ―Totojtoj chich ni winicda u Yajlo' chich Dios. ");
INSERT INTO chfNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ya' ajnijob ya'i täcä q'uen ixictacob u natil chänenob, jini que u tzäypätijob chich aj Jesús desde tä Galilea, jini nämäjob u cherben cua'tac c'änä uc'aba. ");
INSERT INTO chfNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ajni tama ni ixictacob jini täcä ix María Magdalena, y ix María jini u na' aj Jacobo y aj Joséba, y ajni täcä u na' u ch'ocob aj Zebedeo. ");
INSERT INTO chfNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tu pome q'uin c'oti untu winic ajtaq'uini u c'aba' aj José, u cab tä Arimatea. Jini winic täcä ajni de u yajcänt'an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","C'oti une bajca an aj Pilato, u c'atben si u yäc'ben u cuerpo c'äsi' aj Jesús. De ya'i aj Pilato u yäq'ui tä äc'binte ni cuerpo. ");
INSERT INTO chfNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","De ya'i aj José u ch'i ni cuerpo, u tz'oti t'oc ump'e noj säsäc noc'. ");
INSERT INTO chfNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","U muquí tama ump'e noj tzijib mucliba, que une chich u yäq'ui tä ute tu näc' noj ji'tun tuba mujcac une. U cuqui ump'e noj ji'tun, u mäcbi t'oc u ti' ni mucliba. De ya'i bixi tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ya' ajni ya'i ix María Magdalena, y otra ix María täcä, chumujob tu pänte' ni mucliba. ");
INSERT INTO chfNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Päscab, ji'pat que numi jini q'uin que u tuse' ubajob tuba ni q'uin ch'ämbäji u woyli ubajob ni ajnojajob pale nämte' t'oc aj fariseojob bajca an aj Pilato. ");
INSERT INTO chfNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","U yälbijob ca'da: ―Noxi' winic, cä c'ajti'in t'ocob cache' jini ajjop'ojti', jinq'uin cuxutoba, u yäli ca'da: Cä xe tä chämo, y u yuxp'elib q'uin cä xe tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Täscun jiq'uin machca u cänäntanob u ti' ni mucliba ixta que tz'äctac uxp'e q'uin, uc'a mach me'ixto tic u yajcänt'anob ac'äb u xuch'änob ni cuerpo y xic u yälbenob ni caj ca'da: “Acuxpi tan ajchämejob”. Ca' jini u xe tä ch'oye otro ump'e noj jop'ojti' más peor que ni najtäcäba. ");
INSERT INTO chfNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aj Pilato u yälbijob: ―Ya'an jini ni ajcänänyajob. Correla y chenla ca' chich a chen pensala ane uc'a c'alin cänäntintic utz u ti' ni mucliba. ");
INSERT INTO chfNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Unejob bixijob u c'alin mäcben utz u ti' ni mucliba, u sanäjcäche' uc'a mach xic u jäbe' niuntu, y u yäq'uijob ni ajcänänya täcä tuba u c'alin cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jinq'uin numi ni q'uin ta ch'ämbäji, c'otijob ix María Magdalena nämte' t'oc otro ix María u chänenob ni mucliba. Mu'to u junch'äcnan ni najtäcäl q'uin ta semana. ");
INSERT INTO chfNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ajni ump'e noj gran ajchaban, uc'a jaqui untu ángelo tuba ajnoja, que ya' ti tä cielo. C'oti bajca mujqui aj Jesús, u pa'sen ni noj ji'tun y chunwäni tu pam. ");
INSERT INTO chfNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U chen chanä u jut ca' u lem chawäc. U bucba taj säctz'ucan. ");
INSERT INTO chfNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ni ajcänänyajob, jinq'uin u chänijob ni ángelo jini, chicchicnajob ixta choc chämijob de bac'ät. ");
INSERT INTO chfNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jini ángelo u yälbijob ni ixictac ca'da: ―Mach bäc'taquet anelaba. No'on cuwi cache' a sacänla aj Jesús, jini tzämsinti tä cruzba. ");
INSERT INTO chfNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mach ni' an wida, uc'a san cuxpi, ca' chich u yäliba. La'ixla y chänenla bajca ajni ni Cajnojala. ");
INSERT INTO chfNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Seb correla jiq'uin y älbenla u yajcänt'anob cache' acuxpi tan ajchämejob. Une u xe tä c'ote najtäcä que anela tä Galilea. Ya' jini a xe a chänenla. Jin chich namás cä t'an aton. ");
INSERT INTO chfNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","De ya'i ni ixictac seb pasijob bajca an ni mucliba c'äs bäc'tajob to y t'oc noj ch'a'aljin. Bixijob t'oc noj ancäre u tz'aycäbenob ni u yajcänt'an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jinq'uin bixe to u chenobba, pasi aj Jesús tä bij u nuc'tanob. Une u pequijob. Ni ixictacobba u natz'ijob. Nocyälijob u mec'ben yoc y u ch'u'ul c'ajti'inob. ");
INSERT INTO chfNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","De ya'i aj Jesús u yälbijob ca'da: ―Mach bäc'taquetla. Corre cuxla y älben ni quermanojob que bixicob tä Galilea. Ya' jini u xe u chänenonjob. ");
INSERT INTO chfNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jinq'uin bixe to u chenobba, tulaj pasi ni ajcänänyajob tuba mucliba y bixijob tan caj u tz'aycäbenob ni no' ajnojajob pale upete cua' u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ni no' ajnojajob pale u woyli ubajob t'oc ni ajt'äbälajob ta caj tuba u c'alin ch'e' u c'ajalinob cua' u xe u chenob. U yäc'bijob q'uen taq'uin ni soldadojob, u yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","―Anelaba a xe a wäle'la ca'da: “U yajcänt'anob aj Jesús c'otijob ac'äb jinq'uin mu' cä wäye t'ocob y u xuch'ijob ni u cuerpo”. ");
INSERT INTO chfNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Si u yubin ni gobierno ca' jini y cäräx'ac t'oc anelaba, no'on t'ocob cä xe cä sis'esben u c'ajalin t'ocob uc'a cä japänetla. ");
INSERT INTO chfNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ni soldadojobba u sapijob ni taq'uin y u chijob ca' chich c'alin älbintijobba. Y ni t'an jiniba u tz'aycun aj judíosob ixta bada. ");
INSERT INTO chfNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ni once ajcänt'anobba bixijob tä Galilea tu pam ni noj tz'ic bajca chich u worin älbi aj Jesús xicjobba. ");
INSERT INTO chfNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jinq'uin u chänijob, u ch'u'ul c'ajti'ijob. Tulaj ajnijob täcä que mach u totoj tz'onijob si une. ");
INSERT INTO chfNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","De ya'i aj Jesús u natz'ijob, y u pequijob, u yälbenob ca'da: ―Äc'binton upete poder tuba cä chen cua' chichca tä cielo y tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jin uc'a cälbenetla bada que xiquetla cachichcada tä cabil cab tu pancab tuba a tz'aycunla cä t'an uc'a u tz'onänob. C'ablesanla t'oc u c'aba' cä Papla, t'oc u c'aba' u Yajlo' cä Papla, y t'oc u c'aba' ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Älbenob cache' c'änä u laj tz'onänob upete ni cä manda cälbetlaba. C'ajti'inla que ya' chich anon t'oc anela upete q'uin ixta tu xupiba u pancab. Che' chich ajnic.");
INSERT INTO chfNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ca'da tä'qui tä ute upete lo que u chi aj Jesucristo tuba u japänonla, jini u Yajlo' Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ca' chich u tz'ibi aj Isaías, ajt'an ta Dios oniba, ni u yäle' ca'daba: Ubixto, no'on cä täscun cajc'äncan xic najtäcä tuba u tuse' a biji bajca a xe tä nume. ");
INSERT INTO chfNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","U yubcan u noj t'an untu bajca mach cuxu niuntu, que u yäle' ca'da: “Tusbenla u biji Ajnoja. To'esbenla u biji”. ");
INSERT INTO chfNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","C'oti aj Juan u chen c'ablesia bajca mach cuxu niuntu. U yälbijob que u q'uexe' u c'ajalinob tuba pa'säbintic u tanäjob, y de ya'i c'ablacob. ");
INSERT INTO chfNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","C'otijob bajca an aj Juan q'uen machcatac cuxujob tama ni cab tä Judea, c'otijob täcä aj Jerusalénob. Tä ja' tu ti' río Jordán u c'ablesi upete machcatac u laj subi uba t'oc u tanä tu jut Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Aj Juan xojo uc'a u buc de u tzutze ajcamello y t'oc u cächi' näc' de pächi u junxoyma u näc'. U c'uxba, ajsäp' y te'el chab. ");
INSERT INTO chfNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U chi t'an, u yäle' ca'da: ―U te täc pat untu más q'uen u poder que no'on. No'onba mach jin niump'e cua'on tuba cä p'ämben u täbi u pächi'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Toj chich cache' no'on cä c'ablesetla t'oc ja'. Pero uneba u xe u c'ablesanetla t'oc Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jimba q'uinob jini aj Jesús ya' ti tä Nazaret tama ni cab tä Galilea. C'oti bajca an aj Juan, y aj Juan u c'ablesi tä ja' tu ti' río Jordán. ");
INSERT INTO chfNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tu t'äbo tä cab, u chäni cache' u jäbi uba cielo, y ni Ch'u'ul Pixan jaqui tuyac'o ca' ixsäcpäcä. ");
INSERT INTO chfNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ubqui ump'e t'an tä cielo u yäle' ca'da: ―Ane cä yajben Ajlo'et. T'oc ane u ch'a'alan cäjin. ");
INSERT INTO chfNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","De ya'i ni Ch'u'ul Pixan u bisi aj Jesús bajca mach cuxu niuntu. ");
INSERT INTO chfNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ajni ya' jini bajca mach cuxu niuntu cuarenta día y cuxli t'oc nämte' ni cäräx te'el animajob. Aj Satanás c'oti u jiran cache' u yäc'ben u säte' t'oc Dios. Dios u täsqui u yajc'äncanob tuba u täclen aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Aj Juanba äc'qui tä cárcel, y ji'pat de jini aj Jesús c'oti tä Galilea u yäle' u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","U yäle' ca'da: ―Anatz'äli q'uin u nonoj chen manda Dios bajca anetla. Q'uexe a c'ajalinla y tz'onänla u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tu nume tu ti' jini nab u c'aba' Galilea u chäni aj Simón y aj Andrés, u jitz'in chich aj Simónba, mu' u jule'ob u chim tä ja', uc'a unejobba ajq'uechbuch'ob une. ");
INSERT INTO chfNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aj Jesús u yälbijob ca'da: ―La'ixla täc pat. Ajq'uechbuch'etla bada, pero no'on cä xe cä'benetla a sacän winicob tuba u tz'omben u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jinchichba rato jini u yäcti u chimob y u tzäypätijob. ");
INSERT INTO chfNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tu nume ya'i pänte' tz'ita' u chäni aj Jacobo, u yajlo' aj Zebedeo, t'oc aj Juan u jitz'in chich aj Jacobo. Unejob täcä ya'an tan jucub u tzutzänob u chim ta q'uechi' buch'. ");
INSERT INTO chfNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aj Jesús u joq'uijob täcä. Unejob seb u yäctijob täcä tama jucub aj Zebedeo, u papob chichba nämte' t'oc u yajpatanob. Bixijob tu pat aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","C'otijob tä Capernaum. De ya'i tu q'uini ch'ämbäji aj Jesús ochi tama ni ch'uj tuba aj judíosob y u täq'ui u ye'benob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ni gente tajch'icwäni u jut u yubinob u t'an aj Jesús, uc'a tä' pitzi cua' u ye'benob. U c'alin ye'e' une t'oc u poder Dios y mach ca' u ye'e'job machcatac tä' yuwi ni ley taj Moisés. ");
INSERT INTO chfNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ajni tan ni ch'uj jini taj judíosob untu winic que u cänäntan tzuc pixan tuyac'o. Jini winic u chi noj t'an, u yäle' ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Cua' atet a cherbenon t'ocob, Jesús, aneba que a cab tä Nazaret? ¿A xe quira a säte'on t'ocob? No'on cuwi chich machcajet aneba. Ch'u'ul Ajlo'et ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aj Jesús u q'uejpi ni tzuc pixan. U yälben ca'da: ―Ch'in ajni'. Pasen tuyac'o ni winic jini. ");
INSERT INTO chfNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ni tzuc pixan u yäc'bi sätic u c'ajalin ni winic, y u yäc'bi u chen u noj muc' täcä, y t'oc noj awät pasi tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Upetejob tajch'icwäni u jutob y u maläc äle'ob ca'da: ―¿Cua' jini mu' u chen pasa? ¿Cua' tzijib t'an jini mu' u ye'can? Ni winicda ayan u poder tuba u chen manda ni tzuc pixan y u tz'ombenob. ");
INSERT INTO chfNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Seb c'oti tä tz'ayquinte tama cab tä Galilea cua' u chi aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","De ya'i pasijob tama ch'uj tuba aj judíosob. Aj Jesús bixi t'oc aj Jacobo y aj Juan tu yotot aj Simón y aj Andrés. ");
INSERT INTO chfNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","U na' jit'oc aj Simón ya' ch'a'a t'oc u ticwa. Seb u pequijob aj Jesús tuba u tz'äcälin jini ixc'ojpan. ");
INSERT INTO chfNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jinq'uin c'oti aj Jesús, u q'uechbi tu c'äb y u tz'osi. Jinchichba rato jini, u yäcti ticwa ni ixc'ojpan y ch'oyi u cherben cua' chichca c'änä uc'ajob. ");
INSERT INTO chfNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jinq'uin pomi q'uin, u täsijob bajca an aj Jesús upete ajc'ojpanob y jini que u cänäntan tzuc pixanob täcäba. ");
INSERT INTO chfNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Upete ni gente tama caj u woyli ubajob tu ti' otot. ");
INSERT INTO chfNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aj Jesús u tz'äcäli q'uen machcatac c'ojo t'oc cua' chichca yaj. Pa'säbinti tuyac'ojob q'uen machca u cänäntan tzuc pixanob. Aj Jesús mach u yäctajob u yäle' ni tzuc pixan caxca une, uc'a ni tzuc pixan yuwi caxca une aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ic'sapanto, jinq'uin mach to u junch'äcna, ch'oyi aj Jesús, pasi y bixi bajca u ch'e' ajnic u juntuma tuba u chen c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aj Simón y u lotob bixi u sacänob. ");
INSERT INTO chfNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jinq'uin u nuc'tijob, u yälbijob ca'da: ―Upete mu' u sacänet. ");
INSERT INTO chfNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero aj Jesús u yälbijob ca'da: ―Cola bajca an otro caj nätz'ä tuba cä tz'aycäbenob täcä u t'an Dios ya' jini, uc'a jin tuba aton. ");
INSERT INTO chfNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Numi tama entero ni cab tä Galilea u tz'aycun u t'an Dios tama ni ch'uj taj judíosob, y u pa'säben tzuc pixan tuyac'ojob machca u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","C'oti täcä bajca an aj Jesús untu winic c'ojo t'oc ump'e yaj que u c'u'nesben u bec'ta, u c'atän u cherben ump'e favor. Nocwäni tä cab u yälben ca'da: ―Si a wo a tz'äcälinon, co que a pa'säbenon jini yajda, uc'a cuwi chich cache' ayan a poder tuba a chen. ");
INSERT INTO chfNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aj Jesús u ch'ämbi chich yajin. U sätz'i u c'äb u täle' y u yälbi ca'da: ―Co chich que pasic jini yaj ta'wac'o. ");
INSERT INTO chfNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","T'oc jini t'an que u chi aj Jesúsba seb pasi tuyac'o jini yaj y u pojli chich uba. ");
INSERT INTO chfNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aj Jesús u yälbi jini winic que mach xic u tz'aycun, y u täsqui bixic. U yälbi ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Iran, mach xiquet a wälben niump'e cua' niuntu. Ni c'änä a chenba, cux ye'e aba bajca an ni pale taj judíosob. Uc'a a pojli aba subben u matän Dios ca' chich u yäli aj Moisés que äc'binticba. Ca' jini u xe u chänen ni gente täcä cache' a totoj pojli chich aba. ");
INSERT INTO chfNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero jinq'uin pasi jini winic, u täq'ui u tz'aycäben upetejob cache' atz'äcälqui. Jin uc'a aj Jesús mach u ch'ä ochic mach mucu tama niump'e caj. Une coli bajca mach'an otote, pero q'uen gente c'oti bajca an, que ya' tijob cachichcada. ");
INSERT INTO chfNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ji'pat tz'ita' aj Jesús sujli tä cha'num tama jini caj tä Capernaum. Ni gente u yubijob cache' ya'an tama ump'e otot ya' jini. ");
INSERT INTO chfNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Seb u woyli ubajob q'uen gente bajca an une, ixta mach u ni' tawä otot. Aj Jesús u ye'benob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","De ya'i c'oti chäntu winic bajca an aj Jesús, y u c'osijob untu winic chämen yoc. ");
INSERT INTO chfNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mach u ch'ä c'oticob mero bajca an aj Jesús, uc'a mäx q'uen ni gente. Lo que u chijobba, t'äbijob tu pat otot isqui y u jobíjob mero bajca an aj Jesús. Ya'i u jäcsijob ni ajc'ojpan con to'o u yoc tz'en. ");
INSERT INTO chfNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jinq'uin aj Jesús u chäni cache' u tz'onänob ni winicob jini, u yälbi ni ajc'ojpan ca'da: ―Cä ch'oc, a tanä alaj uti perdona. ");
INSERT INTO chfNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ya' chumcajob ya' jini machcatac u ye'e' ni ley taj Moisés. Unejob u yäle' tan u c'ajalinob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Cua' uc'a u yäle' ca' jini? Mach utz u yäle' ca' jini, uc'a mu' u chen uba ca' Dios. Uc'a niuntu mach u ch'ä u chen perdona tanä, sec' Dios namás”. ");
INSERT INTO chfNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aj Jesúsba yuwi chich cua' mu' u yäle'ob tan u c'ajalin, jin uc'a u yälbijob ca'da: ―¿Cua' uc'a a wäle'la cua' chichca tan a c'ajalinla? ");
INSERT INTO chfNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Caxcamba jiq'uin más u ch'e' cälben ni ajc'ojpan: “A tanä a'uti perdona”, o cälben ca'da: “Ch'oyen, ch'ä a ch'a'lib, y corre cux”? ");
INSERT INTO chfNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero cä xe cä ye'benetla cache' no'on que sutwänon de winic ayan chich cä poder tuba cä chen perdona tanä tu pancab. Jin uc'a u yälbi ni winic que chämen yocba ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ane c'ol winic, cälbenet, ch'oyen, ch'ä a ch'a'lib y corre cux ta' wotot. ");
INSERT INTO chfNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","De ya'i ni winic seb ch'oyi, u ch'i u ch'a'lib, y pasi ya'i tama ni noj q'uenel gente. Jin uc'a ni gente tajch'icwäni u jut u chänen cua' uti, y cayi u ch'u'ul c'ajti'inob Dios, u yäle'ob ca'da: ―Mach bay acä chänila utic cua' chichca ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","De ya'i aj Jesús pasi tä cha'num, bixi ti' nab. Jinq'uin c'oti noj q'uenel gente bajca an, cayi u ye'benob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nume u chen ya' jini, u chäni aj Leví, ajlo' taj Alfeo, ya' chumca bajca u ch'uch'inte ni taq'uin tuba ni caj, y u yälbi ca'da: ―Tzäypätinon. De ya'i aj Leví seb ch'oyi, y bixi tu pat. ");
INSERT INTO chfNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","U chi pasa que aj Jesús ya'an tä c'uxnan tu yotot aj Leví nämte' t'oc ni ajcojtaq'uinob tuba ni caj, y otros ajcherajtanäjob täcä ya' chumcajob nämte' t'oc aj Jesús y nämte' t'oc u yajcänt'anob aj Jesús. Uc'a mäx q'uenob u nume tu pat aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jinq'uin ni machca u ye'e'ob ni ley taj Moisés, y aj fariseojob, u chäni cache' aj Jesús mu' u c'uxnan nämte' t'oc ajcherajtanäjob y ajcojtaq'uinob ta caj u yälbi u yajcänt'anob ca'da: ―¿Cua' uc'a ni a maestrola u c'uxnan y u buc'a nämte' t'oc ajcojtaq'uinob ta caj y ajcherajtanäjob? ");
INSERT INTO chfNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jinq'uin aj Jesús u yubi cua' u yälijob, u yälbijob ca'da: ―Mach c'änä uc'a ajtz'ac jini mach c'ojoba, jini que ayan u yutziba. Sec' jini c'ojojtacba c'änä uc'a ajtz'ac. Y no'onba mach aton cä sacän machcatac u chen tu toja. Aton cä sacän sec' ajcherajtanäjob. ");
INSERT INTO chfNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","U yajcänt'anob aj Juan y tuba aj fariseojob u chenob su'q'uin. Jin uc'a tulaj c'otijob u yälbenob aj Jesús ca'da: ―¿Cua' uc'a u yajcänt'anob aj Juan y tuba aj fariseojob u chenob su'q'uin y a wajcänt'an ane mach u chejob? ");
INSERT INTO chfNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aj Jesús u p'albijob: ―¿U ch'e' quira u chenob su'q'uin jini machcatac ya'an can lotojan jinq'uin ni ajlotojan ya'an nämte' t'oc unejob? Uc'a jinq'uin ya'an ni ajlotojan nämte' t'oc unejobba, mach u ch'ä u chen su'q'uinob. ");
INSERT INTO chfNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero u xe tä ajtä ump'e q'uin jinq'uin ni ajlotojan u xe tä pa'sinte bajca anob. Jinq'uinba u xe u ch'e' u chen su'q'uinob. ");
INSERT INTO chfNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aj Jesús u yoli u ye'e' cache' niuntu mach u ch'ä u tz'onän jini u ye'e' uneba si ya'to u tz'onän otro t'an que mach uyal t'oc u t'an uneba. Jin uc'a u yäle' ca'da: ―Niuntu mach u tzutzä u jelem buc t'oc tzib noc'. Uc'a ni tzib noc' u xet'e' más ni jelem noc', y ca' jini más u no'an u xet'ita. ");
INSERT INTO chfNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Che' chich täcä niuntu mach u yäc'ä chij tzijibba tama ump'e jelem pächil ch'ujliba, uc'a si utic ca' jiniba, ni chij u xe u tzalesan jini pächi, y u chap'elma u xe tä säto. Jin uc'a ni chij tzijibba c'änä äc'cac tama ni pächil ch'ujliba tzijibba. ");
INSERT INTO chfNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ump'e u q'uini ch'ämbäji, aj Jesús nume u chen bajca an u caba päc'äbi. U yajcänt'anob cayi u c'äsbenob u jut ni päc'äbi tu numejob. ");
INSERT INTO chfNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jinq'uin u chänijob aj fariseojob ca' jini, u yälbijob ca'da: ―Ubixto, ¿cua' uc'a u chenob ca' jini a wajcänt'anob, jini que mach utz utic tu q'uini ch'ämbäji? ");
INSERT INTO chfNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero aj Jesús u yälbijob ca'da: ―¿Mach to quira bay a tziquila tan u jun Dios cua' u chi aj David y u lotob jinq'uin u na'ti jitz'o ump'e q'uin? ");
INSERT INTO chfNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aj David ochi tama ch'uj ta Dios jinq'uin aj Abiatar une ni ajnoja tuba ni palejob, y u c'uxi jini ch'u'ul waj, jini waj que sec' palejob u ch'e' u c'uxe'ba. Y u yäc'bi täcä ni u lotob que u bixe t'oc nämte'ba. ");
INSERT INTO chfNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aj Jesús täcä u yälbijob ca'da: ―Ni u q'uin ch'ämbäji uti tuba u ch'e' uba winic. Winic uti najtäcä, y mach u q'uin ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jin uc'a no'on que sutwänon de winic cä cänäntan chich poder tuba cäle' cua' u ch'e' cä chenla tu q'uini ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Aj Jesús ochi tä cha'num tama ch'uj tuba aj judíosob. Ya' ajni ya' jini untu winic que tiquin untz'it u c'äb. ");
INSERT INTO chfNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Machcatac ya'anob ya' jini u ch'ucänob aj Jesús, uc'a u jiranob si u xe u tz'äcälin tu q'uin ch'ämbäji, uc'a si u tz'äcälinba, ca' jini ajnic cua' u sube'ob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pero aj Jesús u yälbi jini winic que tiquin untz'it u c'äbba ca'da: ―Ch'oyen, y wa'i' wida tänxin ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","De ya'i u c'atbijob ni gente ca'da: ―¿Cua' une u ch'e' utic tu q'uini ch'ämbäji, ni cua' chichca utzba o ni cua' chichca mach utzba? ¿Tz'äcälcac untu o tzämsintic untu? Pero unejobba mach u p'alijob cua'. ");
INSERT INTO chfNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","De ya'i aj Jesús u chämbi u jutob t'oc cräxle, y t'oc noj tristejle uc'a tzätz u pamob. U yälbi ni winic ca'da: ―Sätz'ä a c'äb. Jini winic u sätz'i u c'äb, y jinchichba rato u pojli uba. ");
INSERT INTO chfNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","De ya'i pasi aj fariseojob y cayi u ch'e' u c'ajalinob nämte' t'oc ni gente tuba aj Herodes tuba u tzämsenob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Aj Jesúsba bixi nämte' t'oc u yajcänt'anob tu ti' nab. Q'uen aj Galileajob y aj Judeajob bixi tu pat. ");
INSERT INTO chfNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Che' chich täcä aj Jerusalénob y aj Idumeajob y jini que ya' tijob tunxe río Jordán, y jini que ya' tijob täcä tama cab tä Tiro y tä Sidón. Noj q'uenel gente c'otijob bajca an, uc'a u yubijob cache' mäx q'uen cua' chichca u chi aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Uc'a mäx q'uen ni gente que c'oti bajca an, u yälbi u yajc'äncanob que ajnic listo ump'e jucub tuba ochic tama, uc'a mach u yoli que u net'e'ob ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Uc'a q'uen machcatac u tz'äcäli, jin uc'a q'uen ajc'ojpanob u c'ote bajca an aj Jesús tuba u täle'ob uc'a u pojlen ubajob. ");
INSERT INTO chfNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jinq'uin u c'ote bajca an aj Jesús jini machcatac t'oc tzuc pixan, u noctä tä cab tu pänte', y ni tzuc pixan u chen noj t'an u yäle' ca'da: ―¡Aneba u Yajlo'et chich Dios! ");
INSERT INTO chfNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero aj Jesúsba u q'uejpanob uc'a mach u yäle'ob caxca une. ");
INSERT INTO chfNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ji'pat aj Jesús t'äbi tu pam ump'e tz'ic. U joq'ui tuba xic bajca an machca chichca que une u yoli u joq'ue', y c'otijob chich bajca an. ");
INSERT INTO chfNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","U yaquijob doce winicob tuba paq'uin ajnic nämte' t'oc une y tuba u täscun u tz'aycun u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","U yäc'bi u poder ni doce winicob jini tuba u tz'äcälin ajc'ojpanob y tuba u pa'sen tzuc pixan tuyac'o machca chichca que u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jinda ni doce winicob jiniba: aj Simón, jini u chap'elib u c'aba' aj Pedroba, ");
INSERT INTO chfNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","aj Jacobo, y aj Juan u jitz'in chichba. Jini cha'tujobdaba u ch'ocob aj Zebedeo une. Aj Jesús u yäc'bi u chap'elib u c'aba'job cache' aj Boanerges. Ni t'andaba u yäle' cache' ca' a wälä u ch'ocob chawäcjob. ");
INSERT INTO chfNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aj Andrés, aj Felipe, aj Bartolomé, aj Mateo, aj Tomás, aj Jacobo jini ajlo' taj Alfeoba, y aj Tadeo, y aj Simón ni aj cananitaba, ");
INSERT INTO chfNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y aj Judas Iscariote, jini que ji'pat u yäq'ui aj Jesús tä c'äbäba. De ya'i aj Jesús ochi tama ump'e otot nämte' t'oc jini u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","U moti uba q'uen gente tä cha'num ixta mach'an cache' c'uxnac aj Jesúsob. ");
INSERT INTO chfNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jinq'uin u yubi u familiajob aj Jesús, u yoli u bisanob uc'a u yälijob cache' jobo an u c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jini que u ye'e'ob ni ley taj Moisés, que ya' tijob tä Jerusalénba, u yäle'ob täcä ca'da: ―Ni winicda ya'an aj Beelzebú tuyac'o, jini ajnoja tuba tzuc pixanobba, y une chich u yäc'ben poder tuba u pa'sen tzuc pixan tuyac'o machca chichca u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","De ya'i aj Jesús u pequijob y u yälbijob ca'da: ―¿Cache'da u ch'e' u jule' uba aj Satanás tuyac'o mismo aj Satanás? ");
INSERT INTO chfNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Si untu ajmanda u jec'lan uba u gente u jule' uba tuyac'o mismo u lot, mach u ch'ä paq'uin colac ni ajmanda jini. ");
INSERT INTO chfNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Si ump'e familia u jec'lan uba tä buya, mach u ch'ä paq'uin colac tomp'e ni familia jini. ");
INSERT INTO chfNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Si aj Satanás u jule' uba tuyac'o mismo aj Satanás, mach u ch'ä paq'uin colac. U xe chich tä xupo une. ");
INSERT INTO chfNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Niuntu mach u ch'ä ochic tama yotot untu winic que q'uen u muc'ba tuba u ch'ämben cua' chichca que u cänäntan sin que u cäche' najtäcä jini winic, uc'a si u cäche' najtäcäba, u ch'e' u ch'ämben cua' chichca que u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Totojtoj cälbenetla cache' u ch'e' chich cherbinte perdona u tanä untu winic y upete cua' chichca mach utz que u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero jini que u yälben ump'e tzuc t'an jini Ch'u'ul Pixanba, mach ucherbinti perdona une. U paq'uin xe chich tä äc'binte u toje' jini tanä. ");
INSERT INTO chfNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ca'da u yäli aj Jesús uc'a xi u yäle'ob cache' une u cänäntan tzuc pixan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","De ya'i c'oti u na' y u jitz'inob aj Jesús bajca an, pero ya' colijob päti y u täsqui tä jo'canob. ");
INSERT INTO chfNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ni noj q'uenel gente que ya' chumu bajca an aj Jesúsba u yälbijob ca'da: ―A na' y a witz'inob ya'anob päti u sacänet. ");
INSERT INTO chfNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aj Jesús u p'albijob: ―¿Caxca une ni cä na', y caxca une ni quitz'inob? ");
INSERT INTO chfNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","De ya'i aj Jesús u yälbijob ni gente que ya' chumu bajca an uneba ca'da: ―Jindajob täcä es ca' cä na' y quitz'inob. ");
INSERT INTO chfNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Uc'a upete machca chichca que u chen ca' chich yo Diosba, unejob une ni quitz'inob y ni cä na'. ");
INSERT INTO chfNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aj Jesús u täq'ui tä cha'num u ye'e' u t'an Dios ti' nab. U moti uba noj q'uenel gente bajca ayan une. Tä' q'uen ni gente que u moti uba, ixta mach'an cache' ajnic aj Jesús ya' jini. Jin uc'a ochi tä chumtä tama ump'e jucub, y ni gente colijob tu ti' nab. ");
INSERT INTO chfNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","De ya'i u ye'bijob u t'an Dios t'oc ump'e tz'aji, u yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ubinla ni tz'ajida: Untu ajpäc'äb bixi u päc'ben u jut päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ca'da u päq'ue' une: U t'it'ben tä cab bajca u xe u ch'e' cab. Jini u t'it'iba ximlaj yäli tan bij, y de ya'i c'oti mut u laj buq'ue'. ");
INSERT INTO chfNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ximlaj yäli täcä tama ji'tun, bajca mach'an q'uen cab. Y jini u jut päc'äbi seb weti, uc'a mach xi tam tä cab. ");
INSERT INTO chfNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","De ya'i, jinq'uin pasi noj ticäw q'uin, u puli jini päc'äbi uc'a mach'an tam u wi' tä cab. Jin uc'a tiqui. ");
INSERT INTO chfNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ximlaj yäli täcä tama ch'ix, y jini ch'ix c'ac'a' ch'iji, y u bisi yaba jini päc'äbi. Jin uc'a mach u yäq'ui u jut. ");
INSERT INTO chfNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ximlaj yäli täcä bajca an cab utzba, y weti ni päc'äbi, y ch'iji, y u yäq'ui q'uen u jut. Untec u yäq'ui treinta u jut, otro untec u yäq'ui sesenta u jut, y otro untec u yäq'ui cien u jut. ");
INSERT INTO chfNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","De ya'i u yälbijob ca'da: ―Machca an u chiquin tuba u yubin, tax u yubin. ");
INSERT INTO chfNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ji'pat, jinq'uin coli aj Jesús u juntuma t'oc ni doce u yajcänt'anob y t'oc ni tulaj colijob ya' jiniba, u c'atbijob cua' u yoli u yäle' t'oc ni tz'aji jini. ");
INSERT INTO chfNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aj Jesús u yälbijob: ―Anelaba Dios u yäc'bet a wina'tanla jini mach uyut entende ajniba, cache'da u xe u nonoj chen manda Dios bajca anetla. Otrosjob u yälbintejob t'oc tz'aji. ");
INSERT INTO chfNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Uc'a tu chänenob ca' a wälä mach u chänejob cua', y tu yubinob mach u chen entendejob, y ca' jini mach u q'uexe' u c'ajalinob tuba cherbintic perdona u tanäjob. ");
INSERT INTO chfNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aj Jesús u yälbijob täcä: ―¿Mach quira a che entendela ni tz'ajida? ¿Cache'da jiq'uin a xe a chen entendela los demás tz'aji? ");
INSERT INTO chfNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ni ajpäc'äb que u päq'ue' u jut päc'äbiba es ca' untu winic que u tz'aycun u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tulaj ayan que u tz'aycäbinte u t'an Dios que u c'otejob t'oc ca' ni päc'äbi que yäli tan bij. U yubinob chich u t'an Dios, pero seb u te aj Satanás u pa'säben tan u pixanob ni t'an u yubijobba. ");
INSERT INTO chfNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Otrosjob que u tz'aycäbinte u t'an Dios u c'otejob t'oc ca' ni jut päc'äbi ni yäli tan ji'tunba. U yubinob chich u t'an Dios y u sapänob t'oc ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero mach unonoj col tan u pixan. Tä' seb u pase, uc'a jinq'uin u te cua' chichca u bäc'tesben u pixan o cua' chichca tz'ibajtesia uc'a u sapi ni t'an jiniba, ca' jini seb u sujtä tu pat. ");
INSERT INTO chfNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Otrosjob que u tz'aycäbinte u t'an Dios u c'otejob t'oc ca' ni jut päc'äbi ni yäli tama ch'ix. U yubinob chich u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","De ya'i u sinlaj chen pensa q'uen cua' chichca, y u c'upän ajnic q'uen u taq'uin, y u c'upänob q'uen cua' chichca jini täcä. Más u yäq'ue' tu c'ajalin upete ni jini que u t'an Dios, y ca' jini mach u ch'ä u chenob niump'e cua' ca' yo Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Otrosjob que u tz'aycäbinte u t'an Dios u c'alin tz'onänob chich. Ni jinijob u c'otejob t'oc ca' ni jut päc'äbi que yäli bajca an cab utz. Ca' jini u t'an Dios u yäq'ue' que u c'alin chenob ca' yo Dios. Es ca' a wälä untec päc'äbi que u yäq'ue' q'uen u jut. Untec u yäq'ue' cien u jut. Otro u yäq'ue' sesenta u jut. Otro u yäq'ue' treinta u jut. ");
INSERT INTO chfNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Aj Jesús u yälbijob täcä ca'da: ―¿U tz'äbcan quira ump'e candil tuba äc'cac tu yaba cajón o tu yaba tz'en? Acäle' que mach. Ump'e candil u tz'äbcan tuba äc'cac isqui tuba u chictan utz. ");
INSERT INTO chfNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Uc'a mach'an niump'e cua' mucu que mach chectac, y mach'an niump'e cua' que mucu ajni que mach wina'tintic. ");
INSERT INTO chfNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Anela que an a chiquin tuba a ubinla, ubinla. ");
INSERT INTO chfNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","U yälbijob täcä: ―Äc'ä ta' c'ajalinla lo que a ubinlaba. Ca' chich a p'isän cua' chichca tuba a wäc'ben a lot, che' chich täcä Dios u xe u p'isbenet lo que a xe tä äc'bintela, y más a xe tä äc'bintela ane que a ubila u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Machca chichca que u yäq'ue' u c'ajalin tuba u yubin cua' chichca jini, Dios u xe u yäc'ben u cäne' más. Machca chichca que mach u yäc'ä u c'ajalin tuba u yubin, ixta lo que u cäni u xe tä laj äc'binte u najyesan. ");
INSERT INTO chfNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aj Jesús u yäli täcä ca'da: ―U manda Dios es ca' untu winic que u päc'ben u jut ni päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cuanta u päc'bi jini jut päc'äbi u bixe tä wäye y päscab isapan u ch'oye, u nume q'uinil ac'äb, y ji'pat u wete ni jut päc'äbi, y u ch'ije, pero uneba mach yuwi cache' u ch'ije. ");
INSERT INTO chfNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","U ch'ije ni päc'äbi jini uc'a cab chich u ch'ijesan. Najtäcä u pase u yopo, de ya'i u nich y de ya'i u pase u jut bajca an u nich. ");
INSERT INTO chfNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cuanta c'ä'ni u jutba, u xe tä ch'uch'inte uc'a ac'oti chich u q'uini tuba ch'uch'intic. ");
INSERT INTO chfNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aj Jesús u yälbijob täcä ca'da: ―¿Cuaxca jini u c'ote t'oc u manda Dios? ¿Cua' tz'aji u ch'e' cäle' cache'da an u manda Dios? ");
INSERT INTO chfNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","U manda Dios es ca' unxim u bec' mostaza que u pä'can tä cab. Más p'i' une de upete u jut päc'äbi que ayan pancab. ");
INSERT INTO chfNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero jinq'uin u pä'canba, u c'ac'a' ch'ije u sujtä de noj gran te' más noj que otros päc'äbi, y q'uen u c'äb jini te' ixta mutob ajwile isquiba u chen u c'ub tama jini u c'äb ni te' tuba u ch'e' uba. ");
INSERT INTO chfNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aj Jesús ca' jini u ye'bijob u t'an Dios ni gente t'oc q'uen tz'aji, ixta bajca tzäcä u chen entendejob. ");
INSERT INTO chfNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mach bay u ye'bijob u t'an Dios si mach t'oc tz'aji, pero u yajcänt'anobba u laj älbenob cua' yo u yäle' t'oc ni tz'ajijob jini. ");
INSERT INTO chfNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jinchichba q'uin jini, jinq'uin ochi ac'äb, u yälbi u yajcänt'anob ca'da: ―Cola tunxe nab. ");
INSERT INTO chfNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","U colesijob ni gente ya'i tu ti' pa', y aj Jesúsba u bisijob tama jinchichba jucub bajca ayan, y bixi täcä t'oc unejob otros jucub. ");
INSERT INTO chfNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tajtzäc pasi ump'e noj gran ic' tama ni nab. Ni t'olja' u yoche tan jucub, y ni jucub cayi tä tule t'oc ja'. ");
INSERT INTO chfNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aj Jesúsba ya'an tu pam jucub tä wäye, ya' ch'a'a tu pan c'änjo. De ya'i u yajcänt'anob u p'isíjob, u yälbijob ca'da: ―¡Maestro! ¿Mach quira a chäne cache' acä chen tä jomela? ");
INSERT INTO chfNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","De ya'i aj Jesús ch'oyi y u q'uejpi jini noj ic', y che' chich täcä ni nab. U yälbi ca'da: ―¡Ch'ijcäbenla! ¡Mach ajniquetla tä ju'läwe! Y jini noj ic' ch'ijcäbi chich, y upetejob coli ch'ijcab. ");
INSERT INTO chfNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","De ya'i aj Jesús u yälbi u yajcänt'anob ca'da: ―¿Cua' uc'a tä' bäc'tetla? ¿Cua' uc'a mach a totoj tz'onäla? ");
INSERT INTO chfNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Y unejob tajch'icwäni u jutob de bac'ät, y cayi u yäle'ob tan u c'ajalin ca'da: ―¿Caxca une wäre ni winicda, que ixta ic' y nab u tz'omben u t'an? ");
INSERT INTO chfNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","De ya'i c'otijob tunxe nab bajca an jini cab u c'aba' Gadara. ");
INSERT INTO chfNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pase u chen aj Jesús tama jucub, c'oti untu winic t'oc tzuc pixan tuyac'o que ya' ati bajca an u mucliba ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ni winic jiniba ya' chich paq'uin cuxu bajca an u mucliba ajchämejob, y niuntu mach u che trebe u cäche' t'oc cadena. ");
INSERT INTO chfNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Uc'a mach unnum cächqui t'oc cadena, tu yoc y tu c'äb, pero jini winic u laj ch'äctuc'än. Niuntu mach u che trebe u q'ueche'. ");
INSERT INTO chfNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","T'oc q'uin y t'oc ac'äb u paq'uin nume tä awät tu pan tz'ic y bajca an u mucliba ajchäme, y u bon jätz'e' uba tuyac'o ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jinq'uin u chäni cache' ya' u te nat aj Jesús, c'oti t'oc ancäre tä nocyälo tu pänte'. ");
INSERT INTO chfNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","U chi noj t'an, u yäle' ca'da: ―¿Cua' atet a cherbenon, Jesús, Ajlo'et tuba ni Dios ya'an isquiba? Cä cocoj älbenet por Dios que mach a tz'ibajtesanon. ");
INSERT INTO chfNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jinda u yäli uc'a aj Jesús san chich u yälbi ca'da: ―Tzuc pixan, pasen tuyac'o ni winic jini. ");
INSERT INTO chfNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aj Jesús u c'atbi ni tzuc pixan: ―¿Cua' a c'aba'? Ni tzuc pixan u p'ali: ―Aj Legión cä c'aba', uc'a q'uenon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ni tzuc pixan u cocoj c'atben aj Jesús que mach xic u yancäresan nat de ni cab jini. ");
INSERT INTO chfNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nätz'ä ya' jini tu pam ump'e tz'ic ya'an tä c'uxnan noj q'uenel chitam. ");
INSERT INTO chfNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ni tzuc pixanob u cocoj älbi aj Jesús ca'da: ―Täscunon t'ocob bajca an ni chitamob jini, y äctan ochicon t'ocob tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","De ya'i aj Jesús u yäctijob chich xic. Ni tzuc pixanob pasi tuyac'o jini winic y ochijob tuyac'o ni chitamob. Ajni como dos mil chitam ya'i. Ji'pat que ochi ni tzuc pixan tuyac'ojob, ni noj q'uenel chitam bixijob t'oc noj ancäre tu pam ump'e tz'ic tu ti' ni nab y ya'i laj yälijob tama ni nab y laj chämijob tä ja'. ");
INSERT INTO chfNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","De ya'i ni ajcänänchitamob putz'ijob de bac'ät y bixijob t'oc ancäre u tz'aycunob tä bij y tan caj cua' u chi pasa. De ya'i c'oti noj q'uenel gente u chänen cua' u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jinq'uin c'oti ni gente bajca an aj Jesús, u chänijob jini winic que ajni tzuc pixan tuyac'oba, cache' ya' chumca tu yoc aj Jesús t'oc u buc tuyac'o y tz'äcä u c'ajalin. Yäli bac'ät tuyac'o ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Y jini machcatac u chäni cua' utiba, u tz'aycäbijob ni gente cache'da tz'äcälqui ni winic que u cänänti tzuc pixan tuyac'oba, y cache' u chi pasa täcä t'oc ni chitamob. ");
INSERT INTO chfNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","De ya'i ni gente cayi u cocoj älbenob aj Jesús que pasic tama u cäjijob. ");
INSERT INTO chfNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jinq'uin oche u chen aj Jesús tama ni jucub, ni winic que u cänänti tzuc pixan tuyac'oba u cocoj älbi que u yäctan bixic nämte' t'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aj Jesúsba mach u yäcti xic t'oc. U yälbi ca'da: ―Corre cux ta' wotot bajca an a familiajob, y tz'aycäbenob upete cua' u chi Ajnoja t'oc ane, y cache' u ch'ämbet yajin. ");
INSERT INTO chfNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bixi jini winic, y u täq'ui u tz'aycun tama ni cajob tä Decápolis upete cua' u chi aj Jesús por une. Y upete ni gente u tajch'ictä u jut u yubinob. ");
INSERT INTO chfNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jinq'uin sujli cha'num aj Jesús tä jucub tunxe ni nab, c'oti noj q'uenel gente bajca an, y uneba ya' chich coli tu ti' pa'. ");
INSERT INTO chfNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","De ya'i untu ajnoja tuba ni ch'uj taj judíosob u c'aba' aj Jairo, jinq'uin c'oti bajca an aj Jesús, nocyäli tu yoc. ");
INSERT INTO chfNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","U ch'oc chen uba t'oc, u yälben ca'da: ―Quixic ch'oc chämo u chen. Cola tuba a wäq'ue' a c'äb tu pam uc'a u pojlen uba y cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","De ya'i aj Jesús bixi chich t'oc. Noj q'uenel gente u bixe tu patob, ixta u net'e'ob. ");
INSERT INTO chfNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tama ni gente ajni untu ixic que u cänäntan doce año c'ojo t'oc ump'e yaj de ch'ich'. ");
INSERT INTO chfNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","C'ac'a' jäläcni t'oc jini yaj y q'uen ajtz'ac numi t'oc ixta u laj säti upete lo que u cänäntan, pero mach u pojle uba. Jini ixic más u c'ac'a' c'ojpesan jini yaj. ");
INSERT INTO chfNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jinq'uin u yubi cache' ya' u te aj Jesús, ni ixic jini c'oti tu pat aj Jesús tama noj q'uenel gente y u tälbi u buc. ");
INSERT INTO chfNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Uc'a ti tu c'ajalin ca'da: “Si cä chen trebe cä tälben u bucba, cä xe cäq'ue' cäba”. ");
INSERT INTO chfNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jinchichba rato que u tälbi u bucba, numi jini yaj. Y ni ixic jini täcä u yubi tuyac'o cache' u pojli uba t'oc jini yaj. ");
INSERT INTO chfNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aj Jesúsba ti tu c'ajalin cache' u tz'äcäli untu t'oc u poder, jin uc'a u suti u jut tu pat u chänen ni gente, u c'atän ca'da: ―¿Caxca une u täli cä buc? ");
INSERT INTO chfNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","De ya'i u yajcänt'anob u yälbijob ca'da: ―Mu' a chänen que q'uen ni gente u net'e'et, ¿y ane a c'atän caxca u tälet? ");
INSERT INTO chfNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero aj Jesúsba cayi u chänen u junxoyma de une tuba u jiran caxca une u täli. ");
INSERT INTO chfNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","De ya'i ni ixic chicchicna t'oc bac'ät uc'a yuwi chich cua' jini u chi pasa. Nocyäli tu yoc aj Jesús, y u yälbi upete tu toja lo que u chi. ");
INSERT INTO chfNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aj Jesús u yälbi ca'da: ―Cä ch'oc, uc'a a tz'oni, a pojli aba. Corre cux, ch'a'alesan ajin, uc'a a pojli chich aba t'oc ni yaj jini. ");
INSERT INTO chfNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ya'to an tä t'an aj Jesús t'oc ni ixic jini, c'oti untu winic que ya' ati tu yotot ni ajnoja tuba ni ch'uj tuba aj judíosob. C'oti u yälben u pap ni yoc ixoc ca'da: ―A yoc ixoc san chämi. Mach a ni' jaq'uesben ujin ni noxi' winic. ");
INSERT INTO chfNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aj Jesúsba mach u chi caso lo que u yäli jini winic. Ca'da u yälbi ni ajnoja tuba ni ch'uj taj judíosob: ―Mach bäc'taquet. Toc'a a tz'onän. ");
INSERT INTO chfNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aj Jesús mach u yäcti xic niuntu tu pat, sec' aj Pedro, aj Jacobo y aj Juan, u jitz'in chich aj Jacoboba. ");
INSERT INTO chfNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jinq'uin c'otijob tu yotot ni ajnoja tuba ni ch'uj tuba aj judíosob, u chänijob cache' ya'an noj q'uenel gente tä ju'läwe, y u chen noj uq'uejob. ");
INSERT INTO chfNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aj Jesús ochi tan otot y u yälbijob ca'da: ―¿Cua' uc'a ju'lawjetla tä uq'ue? Ni yoc ixocda mach chämen. Wäye u chen. ");
INSERT INTO chfNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ni gente u tze'tijob cua' u yäli. De ya'i aj Jesús u yäq'ui tä pa'sinte ni gente tan otot. Ochi t'oc u pap y u na' ni yoc ixoc y jini que c'oti t'oc nämte'ba mero bajca an ni yoc ixoc. ");
INSERT INTO chfNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Aj Jesús u q'uechbi tu c'äb ni yoc ixoc y u yälbi ca'da: ―Talita, cumi ―ni t'andaba u yäle' ca'da: Xoc, no'on cälbenet que ch'oyiquet. ");
INSERT INTO chfNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jinchichba rato jini ch'oyi jini yoc ixoc y u chi xämba. Jini yoc ixoc u cänäntan doce año. Ni gente tajch'icwäni u jut u chänenob cua' uti. ");
INSERT INTO chfNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aj Jesús u cocoj älbijob que mach xic u tz'aycäbenob niuntu cua' uti, y u yälbijob täcä que u yäc'benob cua' u c'uxe' ni yoc ixoc. ");
INSERT INTO chfNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aj Jesús pasi ya'i, bixi tu cab. U yajcänt'anob bixi nämte' t'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tu q'uini ch'ämbäji u täq'ui u ye'e' u t'an Dios tama ch'uj taj judíosob. Tajch'icwäni u jut ni gente u yubinob, y u yäle'ob ca'da: ―¿Cada wäre u cäni ni winicda upete jini u ye'e'ba? ¿Caxca une wäre u yäc'bi jini c'ajalin? ¿Caxca une u yäc'bi poder tuba u chen jini que mach bay uchänintiba? ");
INSERT INTO chfNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ni winicdaba ajpälte' une, u yajlo' ix María. U jitz'inobba, aj Jacobo, aj José, aj Judas y aj Simón, y u jitz'inob de ixictac täcä ya' chich cuxujob täcä wida nämte' t'oc no'onla. Jin uc'a mach u ni' oli u yubinob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aj Jesúsba u yälbijob ca'da: ―Upetejob u yubinob u t'an untu ajt'an ta Dios. Pero tu cabba, mach yo u yubinob u t'an. Che' chich täcä u familiajob untu ajt'an ta Dios y machcatac cuxu tan yotot, unejob täcä mach yo u yubinob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mach u ch'i u chen niump'e cua' ya'i que mach bay uchäninti, sec' toc'a u tz'äcäli cha'tu uxtu ajc'ojpanob, namás u täle' t'oc u c'äb y u pojlen ubajob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tajcolobi u chänen cache' mach u tz'onäjob. Ji'pat aj Jesús bixi u tz'aycun u t'an Dios tä cabil cab. ");
INSERT INTO chfNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","De ya'i u joq'ui ni doce u yajcänt'anob y cayi u täscun a chacha'tu tuba bixicob u tz'aycun u t'an Dios. U yäc'bi u poderjob tuba u pa'sen tzuc pixan tuyac'o machca chichca que u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","U yälbijob täcä que mach u bisan niump'e cua' que c'änä uc'ajob tä bij sec' u bordón namás c'änä u bisanob. Mach u bisanob u bolsa, ni waj, y ni taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","U bisan u pächi'ocjob tu yoc, y tomp'emp'e u buc tuyac'ojob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Y u yälbijob täcä ca'da: ―Ta' wochela tama ump'e otot, colenla ya'i ixta que pasiquetla tama jini caj. ");
INSERT INTO chfNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Si c'otiquetla tama ump'e caj y mach sapintiquetla y mach ubcac a t'anla, pasenla tama ni caj jini. Ta' pasela, ixta jini pupuc ya'an ta' woclaba ticänla, uc'a ca' jini a ye'e'la que mach jin a tanäla säticob. Totojtoj cälbenetla tu xe tä äc'can jini toji'tanä, más tz'ita' u xe tä äc'bintejob aj Sodoma y aj Gomorrajob que ni cajob jini que mach u sapetlaba. ");
INSERT INTO chfNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","De ya'i ni ajcänt'anob jini bixijob u tz'aycun u t'an Dios, u yäle'ob cache' c'änä u q'uexe' u c'ajalinob tuba cherbintic perdona u tanäjob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","U pa'sijob täcä tzuc pixan tuyac'o machca chichca que u cänäntan, y u tatz'ijob t'oc aceite ni ajc'ojpanob y u tz'äcälijob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jini ajmanda u c'aba' aj Herodesba u yubi tz'aji de aj Jesús, uc'a cachichcada u tz'ayquinte cua' u chen. Aj Herodes u yäli ca'da: ―Aj Juan ajc'ablesiaba acuxpi tan ajchämejob, jin uc'a u cänäntan q'uen u poder. ");
INSERT INTO chfNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Otrosjob u yäle' cache' aj Elías ajt'an ta Dios. Y otrosjob u yäle' cache' untu ajt'an ta Dios ca' chich ni cuxlijob oniba. ");
INSERT INTO chfNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jinq'uin u yubi aj Herodes ca'da, u yäli: ―Jindaba aj Juan chich une, ni cäq'ui tä chunjätz'binte u pamba, y bada cuxpi tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Uc'a najtäcä de ni jini aj Herodes chich u yäq'ui tä äc'can preso aj Juan, y u yäq'ui tä cächcan t'oc cadena tama cárcel uc'a ix Herodías. Ix Herodíasba, najtäcä ajni de jit'oc aj Felipe, u jitz'in chich aj Herodes, pero aj Herodes u ch'i tuba jit'oc täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Aj Juanba u yälbi aj Herodes ca'da: ―Mach utz a ch'ämben jit'oc a witz'in tuba a wit'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jin uc'a ix Herodíasba mäx u cräxna'tan aj Juan, y tä' u yoli u tzämsen, pero mach u pojle cache'da. ");
INSERT INTO chfNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Aj Herodesba yuwi chich cache' aj Juan es untu winic que u chen tu toja, y bäc'ta u tzämsen. Jin uc'a mach u yäcta täcä que ix Herodías u tzämsen. Jinq'uin aj Juan u tz'aycäben u t'an Dios aj Herodes, mach uyoch tu c'ajalin, pero u c'alin ubin chich. ");
INSERT INTO chfNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero ix Herodías u pojli chich cache' u tzämsen jinq'uin aj Herodes u chi ump'e q'uin ch'uje tuba u q'uin. U yäq'ui q'uen cua' tä c'uxcan tuba u ch'och'oca ajmandajob, y ajnojajob tuba jo'yan, y ajt'äbälajob tuba ni noj cab tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","De ya'i jixic ch'oc ix Herodías ochi tä ac'ot bajca an ni gente tä c'uxnan. Jini ac'ot tä' utz yäli tu c'ajalin aj Herodes y ni gente ya'an tä c'uxnan t'ocba. Aj Herodes u yälbi ni telom ca'da: ―C'atän lo que a wo, y cä xe chich cä'benet. ");
INSERT INTO chfNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ixta ump'e t'an u yäli tuba tz'onintic cache' u xe chich u yäc'ben cua' chichca que u c'atän. U yälbi täcä: ―Ixta lamita de ni cab que cä chen mandaba u ch'e' cä'benet. ");
INSERT INTO chfNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ni telom bixi u yälben u na' ca'da: ―¿Cua' jini cä c'atän? Ni ixic u yälbi: ―C'atän äc'bintiquet u pam aj Juan ajc'ablesia. ");
INSERT INTO chfNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jini telom ochi cha'num bajca an aj Herodes y u yälbi ca'da: ―Co bada a wäc'benon tama ump'e plato u pam aj Juan ajc'ablesia. ");
INSERT INTO chfNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jinq'uin u yubi aj Herodes ca' jini, coli mäx triste, pero uc'a ni t'an que u yäli tuba tz'oninticba, y uc'a täcä upete ni u jula' u yubi, jin uc'a mach u yoli u yäle' que mach. ");
INSERT INTO chfNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jinchichba rato jini aj Herodes u täsqui untu soldado tuba u chunjätz'ben u pam aj Juan. Bixi ni soldado tan cárcel y u chunjätz'bi u pam aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","De ya'i c'oti t'oc u pam aj Juan tama ump'e plato, y u yäc'bi ni telom. Y ni telom u yäc'bi u na'. ");
INSERT INTO chfNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jinq'uin u yajcänt'anob aj Juan u yubi cua' u chi pasa, u ch'ämbijob u cuerpo aj Juan y u bisijob tuba u muque'. ");
INSERT INTO chfNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ji'pat ni ajcänt'anob tuba aj Jesús u woyli ubajob bajca an, y u tz'aycäbijob cua'tac u chijob y cua'tac u ye'ijob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aj Jesús u yälbijob: ―Cola cä ch'e' cäbala tz'ita' bajca mach'an gente. Uc'a mäx q'uen gente u c'ote bajca anob ixta mach'an lugar ta c'uxnacob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","De ya'i aj Jesús y u yajcänt'anob sec' unejob namás ochijob tama ump'e jucub y bixijob bajca mach'an gente. ");
INSERT INTO chfNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero q'uen ni gente u chänijob cache' aj Jesús ni bixe u chenba, y t'oc noj ancäre bixijob u pijnan bajca u xe tä c'ote. Bixijob täcä q'uen gente que ya' ti cachichcada, y c'otijob najtäcä que aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jinq'uin aj Jesús pasi tama jucub, u chäni noj q'uenel gente, y u ch'ämbi yajin upetejob uc'a ni gentejob jini es ca' a wälä oveja que mach'an machca u cänäntan. U täq'ui u ye'benob q'uen cua' chichca de u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pome u chen q'uin u yajcänt'anob aj Jesús u yälbijob ca'da: ―Atarde'i y wida mach'an otote. ");
INSERT INTO chfNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Älben ni genteda que bixicob bajcatac an otote nätz'ä, y bajcatac an caj tuba u mäne' u pa' wajob, uc'a mach'an cua' u c'uxe'ob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aj Jesús u yälbijob ca'da: ―Äc'benla ane cua' u c'uxe'. Unejob u p'ali: ―Si cä mäne' t'ocob doscientos taq'uin ni u yälbinte cache' denarioba de puro waj mach u yäc'ä tuba c'uxnac upete. ");
INSERT INTO chfNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aj Jesús u yälbijob: ―¿Jäyp'e waj a cänäntanla ane? Corre iranla. Jinq'uin u jirijob jäyp'e waj ya'an, u yälbijob ca'da: ―Cinco waj y cha'tu buch' cä cänäntan t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","De ya'i u yäq'ui que chumlec ni gente ajuntom ajuntom tu pan yäyäx bänäla. ");
INSERT INTO chfNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chunwänijob ajump'e grupo de a cien y ajump'e grupo de a cincuenta. ");
INSERT INTO chfNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","De ya'i aj Jesús u ch'i jini cinco waj y cha'tu yoc buch', u t'äbsi u jut tä cielo, u yälbi Dios que uc'adios u chi, de ya'i u taji jini waj. U yäc'bi u yajcänt'anob tuba u pucben ni gente. U pucbijob täcä ni gente ni cha'tu yoc buch'. ");
INSERT INTO chfNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Upete laj c'uxnijob, y laj na'ijob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","De ya'i u tulesijob doce chach de u colob ni waj y ni buch'. ");
INSERT INTO chfNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Y jini gente que c'uxnijobba, ca' ta cinco mil wincäre. ");
INSERT INTO chfNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","De ya'i aj Jesús u yäq'ui ochic u yajcänt'anob tama ni jucub tuba c'axicob tunxe nab najtäcä que une, y xicob tama jini caj u c'aba' Betsaida. Y uneba coli to u laj täscun ni gente bixic tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cuanta u laj tzupsi u täscun tu yotot ni gente, bixi une tu pam ump'e tz'ic u chen c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jinq'uin ochi ac'äb ni jucub ya'to u xe tänxin nab, y aj Jesúsba ya'to an tä cab u juntuma. ");
INSERT INTO chfNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","U chäni cache' a la fuerza u bixe u babän ni jucub uc'a ni ic' u yustan tuyac'ojob. Tu chämp'elib u yuq'ue piyo' u natz'ijob t'oc xämba tu pan ja'. U yoli u jelänob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jinq'uin u chänijob cache' ya' u te tu pan ja', u yäli cache' ajbäc'tesia, y u chijob noj awät. ");
INSERT INTO chfNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Upetejob u chänijob y c'ac'a' bäc'tijob. Pero aj Jesús u pequijob u yälbijob ca'da: ―Mach bäc'taquetla. No'on chich. Mach ayan cua'. ");
INSERT INTO chfNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","De ya'i ochi tama ni jucub bajca anob, y ch'ijcäbi jini noj ic'. Upete tajch'icwäni u jutob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Unejobba mach to u totoj och tu c'ajalinob cua' u yoli u ye'e' t'oc jini waj, uc'a mäx tzätz to u pixanob. ");
INSERT INTO chfNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","C'axijob tunxe nab y c'otijob bajca an jini cab u c'aba' Genesaret. Ya'i u cächijob u jucub tu ti' nab. ");
INSERT INTO chfNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jinq'uin pasijob tama jini jucub, ni gentejob u chäni cache' aj Jesús ac'oti. ");
INSERT INTO chfNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","De ya'i bixijob t'oc ancäre tä cabil cab y u täq'ui u täsenob c'ol winic tu pan u tz'en bajca an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Cachichcada que u bixe aj Jesús bajca an bit caj, nuc caj, y tä bij, ni gentejob u yäq'ue' ni c'ol winic tu ch'ejpa bij, y u ch'oc chen ubajob t'oc aj Jesús que u yäctan uba tuba u tälben u bucob ni c'ol winic uc'a u pojlen uba. Y upete machcatac u tälbi chich u bucba, u laj pojli chich uba. ");
INSERT INTO chfNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","De ya'i c'oti bajca an aj Jesús aj fariseojob y jini machcatac u ye'e' ni ley taj Moisésba. Unejobba ya' tijob tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","U chänijob cache' u yajcänt'anob aj Jesús u c'uxnan sin que u poque' u c'äbob, y ca' jini mach u chejob ca' chich u yäle' ni ajt'äbälajob utic, jin uc'a u tze'tanob. ");
INSERT INTO chfNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Uc'a ni aj fariseojobba, y upete ni aj judíosob, mach u c'uxnajob sin que u c'alin poque' u c'äbob najtäcä, uc'a ca' jini u yäle' ni ajt'äbälajob que utic. ");
INSERT INTO chfNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jinq'uin u tejob u chen u man, mach u c'uxnajob sin que u poque' u c'äbob. Y q'uen cua' chichca u chenob ca' chich u yäle' ni ajt'äbälajob, u poque' u t'ubob, u poque' u p'u, u poque' u p'etjob de palib, y u poque' u tz'enob. ");
INSERT INTO chfNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De ya'i ni aj fariseojob y jini u ye'e' ni ley taj Moisés u yälbijob ca'da: ―¿Cua' uc'a a wajcänt'an mach u che ca' chich u yäle' ni ajt'äbäla que utic y u c'uxnanob sin que u poque' u c'äb? ");
INSERT INTO chfNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aj Jesús u p'albijob: ―¡Ajsusuccheriajetla! De anela une ni u yäli aj Isaías, ajt'an ta Dios oniba, y toj chich u yäli jinq'uin u tz'ibi ca'daba: Jini genteda sec' t'oc u ti' u ch'u'ul c'ajti'inon, pero u pixanba mach totoj ayan t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","U päpä' c'ajti'inonob chich namás. U ye'e'job cache' jin u toja ni u yäq'ue' winicob tä uteba. ");
INSERT INTO chfNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anelaba a wäctanla ni mero u manda Diosba tuba a chenla ca' chich u yäle' ni gente: a poque' a p'etla, a poque' a t'ubla bajca a buc'alaba, y q'uen cua' chichca ca' jini a chenla. ");
INSERT INTO chfNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","U yälbijob täcä: ―Uc'a a chenla ca' chich u yäle' ni ajt'äbälajobba, jin uc'a a wäctan a chenla ca' chich u yäle' ni Dios que uticba. ");
INSERT INTO chfNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Uc'a aj Moisésba u yäli ca'da: “Tz'omben u t'an a pap y a na'”, y “Machca chichca que u cäräx älben u pap y u na'ba, c'änä tzämsintic”. ");
INSERT INTO chfNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero anelaba a wäle'la cache' untu winic u ch'e' u yälben u pap y u na' ca'da: “Mach u ch'ä cä täclenet, uc'a upete lo que cä cänäntanba acä laj subbi de u matän Dios”. ");
INSERT INTO chfNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Si untu winic u yäle' ca' jiniba, anelaba a wäle'la que mach ni' c'änä u täclen u pap y u na'. ");
INSERT INTO chfNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ca' jini cheque cache' a wäctan a chenla ca' chich yo Dios que uticba uc'a a chenla ca' chich u yäle' ni ajt'äbälajob. Q'uen cua' chichca täcä ca' jini a chenla. ");
INSERT INTO chfNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aj Jesús u pequijob tä cha'num ni gente, u yälbijob ca'da: ―Anela apetela, ubin cua' cä xe cälbenetla, y ochic ta' c'ajalinla. ");
INSERT INTO chfNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mach jin cua' u c'uxe' untu winic que u yäc'ben que mach ajnic tu toja. Ni u yäc'ben que mach ajnic tu toja untu winicba, jini u pase tu c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Anela que an a chiquinla, ubinla. ");
INSERT INTO chfNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jinq'uin aj Jesús u tz'eji ubajob t'oc ni gente y ochi tan otot, y u yajcänt'anob u c'atbijob cua' jini yo u yäle' t'oc ni t'an que u yäliba. ");
INSERT INTO chfNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aj Jesús u yälbijob: ―¿Mach quira a che entendela täcä? ¿Mach quira a wila cache' upete cua' u c'uxe' winic mach jin lo que u yäc'ben mach ajnic tu toja? ");
INSERT INTO chfNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Uc'a jini mach uxin tan u pixan, ya' u xe tan u näc', y ji'pat u pase. Jinda u yäli uc'a wina'tintic cache' upete cua' tä c'uxcan utz chich. ");
INSERT INTO chfNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","U yäli täcä: ―Jini u pase tan u c'ajalin winicba, jin une ni u yäq'ue' que mach ajnic tu toja. ");
INSERT INTO chfNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Uc'a tu c'ajalin o tu pixan winic u pase q'uen cua' chichca que mach utz, tzuc c'ajalin, cherajtz'ijte', c'upom de ixic, tzämsa, ");
INSERT INTO chfNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","xuch', c'upom de cua' chichca que u cänäntan u lot, malujle, jop'ojti', pa'sajquisin, jaq'uinle jinq'uin cä chänenla cache' cä lotla u cänäntan cua' chichca, päpä' tz'aji tuba u lot, jinq'uin u chen uba fama untu y sin c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Upete ni jini que mach utzba ya' u pase tan u pixan winic, y u yäq'ue' que mach ajnic tu toja. ");
INSERT INTO chfNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Aj Jesús pasi ya' jini, bixi tä Tiro nätz'ä t'oc tä Sidón. Ochi tama ump'e otot ya' jini uc'a mach u yoli que yuwina'tan niuntu si ac'oti ya'i. Pero mach ajni cache' u muque' uba. ");
INSERT INTO chfNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uc'a seb u yubi untu ixic que u cänäntan untu u jixic ch'oc t'oc tzuc pixan tuyac'o, y c'oti tä nocyälo tu yoc aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ni ixic jiniba ixpäpä'cab une, ya' päncäbi tä Sirofenicia. C'oti u c'atben aj Jesús que u pa'säben tzuc pixan tuyac'o jixic ch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aj Jesús u p'albi: ―Äctan que ni bijch'oc c'uxnac najtäcä, uc'a mach utz jajbintic u pa' waj ni bijch'oc y äc'bintic wichu'. ");
INSERT INTO chfNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ni ixic u p'ali: ―Toj chich une, Cajnoja. Pero ixta ni wichu' que ya'an yaba mesaba u c'uxe' ni xixom waj que u yäctan yälic ni bijch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","De ya'i aj Jesús u yälbi ca'da: ―Utz chich cua' a wäli. U ch'e' bixiquet ta' wotot. Ni tzuc pixan san chich apasi tuyac'o a wixic ch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jinq'uin c'oti tu yotot, c'oti u pojlen ni yoc ixoc que ya' ch'a'a pan tz'en. Ni tzuc pixan san chich apasi tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aj Jesús pasi tä Tiro, bixi tä Sidón. De ya'i numi tama ni cajob tä Decápolis y c'oti bajca an ni nab tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ya'i u c'osbijob untu winic ajcoc y a'uma', y u c'atbijob que u täle' t'oc u c'äb tuba u pojlen uba. ");
INSERT INTO chfNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aj Jesús u tz'eji ni winic bajca an ni gente, de ya'i u jup'i u ni'c'äb tan u chiquin. U chi u tub y u tälbi u yac'. ");
INSERT INTO chfNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","De ya'i u t'äbsi u jut tä cielo, u sapi ic' y u yäli ca'da: ―¡Efata! ―ni t'andaba u yäle' ca'da: ¡Jäbä aba! ");
INSERT INTO chfNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jinchichba rato jini u jäbi uba u chiquin ni ajcoc, u yäq'ui uba yac', y cayi u chen t'an utz. ");
INSERT INTO chfNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aj Jesús u yälbi ni gente que mach xic u tz'aycun cua' u chi pasa. Pero mach u tz'onijob cua' älbinti. Unejobba más u c'ac'a' tz'aycunob. ");
INSERT INTO chfNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Upete u tajch'ictä u jut u yubinob, y u yäle'ob ca'da: ―Tä' utz cua' u chen ni winic jini. Ixta u yäc'ben u yubin t'an ajcoc y u yäc'ben u chen t'an a'uma'. ");
INSERT INTO chfNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jimba q'uinob jiniba q'uen gente u motli uba bajca an aj Jesús, y mach ajni cua' u c'uxe'ob. De ya'i aj Jesús u yälbi u yajcänt'anob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Mäx acä ch'ämben yajin ni genteda uc'a u cänäntan uxp'e q'uin que ya'anob wida bajca anon y mach'an cua' u c'uxe'ob. ");
INSERT INTO chfNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Si cä täscun tu yototob sin c'uxba, u xe tä säto u c'ajalinob tä bij de jitz'o uc'a q'uen de unejob nat u cabob. ");
INSERT INTO chfNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","U yajcänt'anob u p'ali ca'da: ―¿Cache'da u ch'e' c'uxnescac ni genteda wida bajca mach cuxu niuntu? ");
INSERT INTO chfNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aj Jesús u c'atbijob: ―¿Jäyp'e waj a cänäntanla ane? Unejob u p'ali: ―Siete waj. ");
INSERT INTO chfNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","De ya'i u yälbi ni gente que chumlecob tä cab. U ch'i ni waj y u yäc'bi u c'aba' Dios. De ya'i u taji y u yäc'bi u yajcänt'anob, y unejob u pucbi ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","U cänäntijob täcä cha'tu uxtu yoc buch'. Aj Jesús u ch'u'ul chi y u yäq'ui que pucbintic ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Upete c'uxnijob y laj na'ijob. De ya'i u ch'uch'ijob u colob, siete nuc chach tulu. ");
INSERT INTO chfNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ni gente que c'uxniba, ca' ta cuatro mil persona u q'ue'nanob. ");
INSERT INTO chfNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","De ya'i aj Jesús u täsquijob bixic. Aj Jesús ochi tan jucub t'oc u yajcänt'anob y bixi bajca an jini cab u c'aba' Dalmanuta. ");
INSERT INTO chfNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","De ya'i c'oti aj fariseojob bajca an aj Jesús y u täq'uijob u chen t'an t'oc une. Tuba u jiranob si toj u t'an, u c'atbijob que u yäq'ue' ump'e seña tä cielo, jini mach bay chänintiba, tuba u chänenob. ");
INSERT INTO chfNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aj Jesús u sapi ic', y u yäli ca'da: ―¿Cua' uc'a u c'atän ni genteda ump'e seña que mach bay uchänintiba tuba u chänenob? Totojtoj cälbenetla que mach uxet tä äc'bintela niump'e seña tuba a chänenla. ");
INSERT INTO chfNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","De ya'i u yäctijob ni gente jini, ochi cha'num tan jucub y bixi tunxe nab. ");
INSERT INTO chfNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","U yajcänt'anob aj Jesús najyi uc'a cua' u c'uxe'ob, y sec' ump'e waj u bisanob tama ni jucub. ");
INSERT INTO chfNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","De ya'i aj Jesús u yälbijob ca'da: ―Ubinla, cänäntan abala, mach a ch'e'la jini jusonib ta waj que u c'äne' aj fariseojob, y jini que u c'äne' aj Herodes täcäba. ");
INSERT INTO chfNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ni ajcänt'anob cayi u maläc äle'ob ca'da: ―Jinda mu' u yäle' uc'a mach acä täsi cä pa' wajla. ");
INSERT INTO chfNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aj Jesúsba yuwi chich cua' mu' u yäle'ob y u yälbi ca'da: ―¿Cua' uc'a a wäle'la que mach a täsi wajla? ¿Mach to quira uyoch ta' c'ajalinla y mach to a che entendela? Tä' tzätz a pamla. ");
INSERT INTO chfNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Mach quira a chäne t'oc a jutla? ¿Y mach quira a ubi t'oc a chiquinla? ¿Mach quira a ni' c'ajti'ila täcä? ");
INSERT INTO chfNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jinq'uin cä puqui cinco waj tuba c'uxnacob cinco mil winicob, ¿jäyp'e chach a ch'uch'ila de u colob? Unejob u p'ali: ―Doce chach. ");
INSERT INTO chfNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Jinq'uin cä puqui siete waj tuba cuatro milobba, ¿jäyp'e chach a ch'uch'ila de u colob? Unejob u p'ali: ―Siete chach. ");
INSERT INTO chfNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","De ya'i u yälbijob: ―¿Mach to quira a laj che entendela cache' ayan cä poder? ");
INSERT INTO chfNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ji'pat de jini bixijob tä Betsaida. Jinq'uin c'otijob u bisijob untu ajchoc' bajca an aj Jesús, y u yälbijob que u täle' tuba u pojlen uba. ");
INSERT INTO chfNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","De ya'i u q'uechbi tu c'äb ni ajchoc', u pa'si tama caj. U ch'i u tub u tatz'bi tu jut, y u yäc'bi u c'äb tu jut, y u c'atbi si u chänen tz'ita'. ");
INSERT INTO chfNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jini ajchoc' cayi u jiran si u ch'e' u chen chanä, y u yäli: ―Mu' cä chänen winicob, ca' a wälä te', pero u chen xämba. ");
INSERT INTO chfNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","De ya'i aj Jesús u yäc'bi u c'äb cha'num tu jut. Jini winic u chi chanä y u pojli uba u jut. Upete u chänen utz. ");
INSERT INTO chfNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","De ya'i aj Jesús u täsqui tu yotot, y u yälbi: ―Mach ochiquet tama caj, y mach a tz'aycäben niuntu cua' u chet pasa. ");
INSERT INTO chfNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ji'pat de ni jini aj Jesús bixi t'oc u yajcänt'anob tama ni cajob tä Cesarea tä Filipo. Bixe to u chen tä bij u c'atbi u yajcänt'anob ca'da: ―¿Caxcajon u yäle' ni gente? ");
INSERT INTO chfNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Unejob u p'ali: ―Ayan machca u yäle' cache' aneba aj Juan ajc'ablesialet. Otrosjob u yäle' cache' aj Elíaset. Y otrosjob u yäle' cache' ajt'anet tuba Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","De ya'i u c'atbijob tä cha'num ca'da: ―¿Anelaba, caxcajon a wäle'la? Aj Pedro u p'ali: ―Aneba aj Cristojet, que u täsquet Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aj Jesús u yälbijob que mach xic u tz'aycäbenob niuntu. ");
INSERT INTO chfNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","De ya'i u täq'ui u yälbenob cache' une que sutwäni de winic c'änä c'ac'a' tz'ibajtescac, y che' chich täcä ajt'äbälajob ta ni caj y ajnojajob ta palejob y machcatac u ye'e' ni ley taj Moisés mach uxin u sapänob. U yälbijob täcä que u xe tä tzämsinte, pero u yuxp'elib q'uin u xe tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jintacda u laj älbijob. De ya'i aj Pedro u tz'eji uba nämte' t'oc tz'ita', y u täq'ui u yälben que mach yo que u chen pasa ca' u yäli. ");
INSERT INTO chfNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","De ya'i aj Jesús u suti uba u chänen bajca an u yajcänt'anob y cayi u q'uejpan aj Pedro, u yäle' ca'da: ―¡Tz'eje aba, Satanás, t'oc no'on! Uc'a ane mach'an ta' c'ajalin lo que yo Dios utic. Ni ya'an ta' c'ajalinba, sec' ni yo winic uticba. ");
INSERT INTO chfNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","De ya'i aj Jesús u pequi u yajcänt'anob y ni gente, u yälbijob ca'da: ―Machca chichca yo ochic de cajcänt'anba c'änä u yäctan u chen uba manda u juntuma. C'änä u c'älen cua' chichca tz'ibajtesia ca' chich cä c'älen no'on y u chen ca' chich cäle' no'onba. ");
INSERT INTO chfNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Uc'a machca chichca u sacän cache' cuxlec utz pancab, u xe u säte' upete ni jini. Upete machca mach u sacä tuba cuxlec utz pancab uc'a u tz'ombon cä t'an y uc'a u tz'aycun u t'an Dios täcä, u xe chich tä äc'binte paq'uin cuxlec más utz. ");
INSERT INTO chfNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Cua' u pa'se untu winic si u c'ac'a' mote' pancab q'uen cua' chichca tuba cuxlec utz, y de ya'i sätic u pixan? ");
INSERT INTO chfNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Jäyp'e u ch'e' u toje' untu winic tuba u japän u pixan? ");
INSERT INTO chfNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Machca chichca u quisnäjan t'oc no'on, y t'oc u t'an Dios bajca an ni genteda que mach u tz'onä y ajcherajtanäjob, no'on täcä que sutwänon de winicba, cä xe tä quisnäjan t'oc unejob täc xe tä te t'oc u pitzilan cä Pap y t'oc u ch'u'ul ángelojob. ");
INSERT INTO chfNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aj Jesús u yälbijob täcä: ―Totojtoj cälbenetla täcä cache' ayan machca chichca wida que mach uxin tä chämojob ixta que u chänen cache' Dios u xe u chen manda t'oc u poder bajca anetla. ");
INSERT INTO chfNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis día ji'pat bixi aj Jesús isqui tu pam ump'e noj tz'ic sec' t'oc aj Pedro, aj Jacobo y aj Juan. Ya'i u yäni uba u jut tu pänte'ob. ");
INSERT INTO chfNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","U chen chanä u buc de säc, que niuntu wida pancab mach u che trebe u säq'uesan u buc ca' jini jinq'uin u jutz'e'. ");
INSERT INTO chfNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","U chänijob täcä cache' ya'an aj Elías y aj Moisés tä tz'aji t'oc aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","De ya'i aj Pedro u yälbi aj Jesús ca'da: ―Maestro, utz chich que ya'anonla wida. C'änä cä chen t'ocob uxp'e boch', ump'e ta'a, ump'e taj Moisés, y ump'e taj Elías. ");
INSERT INTO chfNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ni ajcänt'anobba laj bäc'tijob, jin uc'a aj Pedro mach yuwi cua' mu' u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","De ya'i jaqui ump'e noj bucla y u laj bälijob. Y tama jini bucla ubqui ump'e t'an que u yäle' ca'da: ―Jinda cä yajben Ajlo', ubinla u t'an une. ");
INSERT INTO chfNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jinchichba rato jini, jinq'uin u suti u jut bajca an aj Jesús u chänijob cache' mach ni' an machca. Sec' u juntuma acoli. ");
INSERT INTO chfNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jinq'uin jaque u chenob tu pam ni tz'ic, aj Jesús u yälbijob que mach xic u tz'aycäbenob niuntu cua' u chänijob. Ixta ji'pat to u ch'e' u tz'aycunob, cuanta cuxpi une tan ajchäme. ");
INSERT INTO chfNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jin uc'a mach u tz'ayquijob cua' u chänijob, pero u maläc c'atänob cua' jini u yäli, que u xe tä cuxpan tan ajchämeba. ");
INSERT INTO chfNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","De ya'i u c'atbijob aj Jesús ca'da: ―¿Cua' uc'a u yäle' jini que u ye'e'ob ley taj Moisésba cache' aj Elías u te najtäcä? ");
INSERT INTO chfNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Une u p'albijob: ―Toj chich que aj Elías u xe tä te najtäcä. U xe u laj äq'ue' tu toja upete cua' chichca. ¿Cua' u yäle' jini t'an ta Dios tz'ibiba, cache' cä xe cä chen pasa no'on que sutwänon de winicba? Ni t'an jini u yäle' cache' cä xe tä tz'ibajtescan y cache' mach uxin u sapänonjob. ");
INSERT INTO chfNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","No'on cälbenetla cache' aj Elías ajni chich, y u cherbijob ca' chich u yoli u cherbenob, y ca' chich u yäle' ni t'an ta Dios tz'ibiba, cache' u xe tä cherbinte. ");
INSERT INTO chfNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","De ya'i c'otijob bajca an los demás ajcänt'anob, y u chänijob cache' ya'an q'uen gente bajca anob. Ya'anob tä t'an t'oc machcatac u ye'e' ni ley taj Moisésba. ");
INSERT INTO chfNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jinq'uin u chänijob aj Jesús, upete tajch'icwäni u jutob, y bixijob u pecänob. ");
INSERT INTO chfNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Une u c'atbijob ca'da: ―¿Cua' jini mu' a wäle'la? ");
INSERT INTO chfNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Y untu de unejob u p'ali ca'da: ―Maestro, acä täsbet cajlo', que u paq'uin oche tzuc pixan tuyac'o y u colesi a'uma'. ");
INSERT INTO chfNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cachichcada que u nuc'tan ni tzuc pixan u yoche tuyac'o y u yäsen tä cab. U chen q'uen u yomti' y u chen cächäcne yej. De ya'i tich'im u colan u cuerpo. Acä c'atbi a wajcänt'anob que u pa'säben jini tzuc pixan, pero mach u che trebejob. ");
INSERT INTO chfNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aj Jesús u p'albi: ―Anela mach a tz'ombela u t'an Dios. ¿Ixta ca ti q'uin cä xe tä ajtä t'oc anela? ¿Ixta cax ti amba q'uin c'änä ajnic sis cä c'ajalin t'oc anela? Täsenla wida jini ajlo'. ");
INSERT INTO chfNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","De ya'i u täsbijob. Jinq'uin ni tzuc pixan u chäni aj Jesús, u yäc'bi que sätic u c'ajalin jini ajlo'. Yäli tä cab tä cucajtäne y u chen noj q'uenel yom ti'. ");
INSERT INTO chfNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","De ya'i aj Jesús u c'atbi u pap ni ajlo' jäyp'e q'uin u cänäntan que u q'uechi jini yaj. U pap ni yoc ajlo' u p'ali: ―Desde p'i' to. ");
INSERT INTO chfNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Y mach unnum ni tzuc pixan u yäsi tan c'ac' y u yäsi tä ja' uc'a u yoli u tzämsen. Jin uc'a cälbenet si a chen trebe a tz'äcälin, ch'ämbenon lástima t'ocob y täclenon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aj Jesús u yälbi: ―Si a totoj tz'onänba, u ch'e' chich, uc'a machca u totoj tz'onänba, u ch'e' chich cä cherben upete cua' chichca. ");
INSERT INTO chfNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","De ya'i u pap jini yoc ajlo' u chi noj t'an u yäle' ca'da: ―¡Acä tz'onän chich! Täclenon cä totoj tz'onän más. ");
INSERT INTO chfNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jinq'uin aj Jesús u chäni cache' u mote' uba noj q'uenel gente, u yälbi ni tzuc pixan ca'da: ―Tzuc pixan a'uma' y ajcoc, cälbenet que pasiquet tuyac'o ni ajlo' jini y mach ni' sujlequet tä oche tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y jini tzuc pixan u chi noj awät u yäc'bi que sätic u c'ajalin jini ajlo', y u chen u noj muc'. De ya'i pasi tuyac'o. U colesi jini ajlo' ca' a wälä chämen, jin uc'a q'uen u yäle'ob cache' san chämi. ");
INSERT INTO chfNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aj Jesúsba u q'uechbi tu c'äb tuba u tz'osen, y jini ajlo' wa'wäni. ");
INSERT INTO chfNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","De ya'i aj Jesús ochi tama ump'e otot y u yajcänt'anob u c'atbijob u juntuma ca'da: ―¿Cua' uc'a mach cä chi trebe cä pa'sen t'ocob jini tzuc pixan? ");
INSERT INTO chfNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aj Jesús u yälbijob: ―Jini tzuc pixandaba mach upas si mach a chela c'änti'ya y su'q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jinq'uin pasijob ya'i, bixijob tä Galilea. Aj Jesús mach u yoli que niuntu yuwina'tan si une ya'an ya'i. ");
INSERT INTO chfNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Uc'a aj Jesúsba ya'an u ye'ben u t'an Dios u yajcänt'anob y u yälbenob täcä cache' une que sutwäni de winicba u xe tä äc'can tu c'äb winicob y u xe u tzämsenob. Pero u yuxp'elib q'uin ji'pat que u tzämsinteba u xe tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ni ajcänt'anobba mach uyoch tu c'ajalinob cua' u yälben, y bäc'ta u c'atbenob täcä cua' jini. ");
INSERT INTO chfNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","De ya'i c'otijob tama ni caj tä Capernaum. Jinq'uin ya'anob tama ump'e otot, aj Jesús u c'atbijob ca'da: ―¿Cua' jini a maläc äle'la jinq'uin a tela tä bij? ");
INSERT INTO chfNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Unejob tajcolijob ch'ijcab, uc'a jinq'uin u tejob tä bij u maläc c'atänob caxca une wäre más ajnoja de unejob. ");
INSERT INTO chfNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","De ya'i aj Jesús chunwäni, u joq'ui ni doce u yajcänt'anob y u yälbijob ca'da: ―Machca chichca yo xic más ajnojaba, c'änä xic más ajch'och'oca, y u cherben cua' chichca c'änä uc'a upete. ");
INSERT INTO chfNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","De ya'i u ch'i untu ch'oc y u yäq'ui tänxin de unejob. U ch'i u meq'ue' jini ch'oc y u yälbijob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Machca chichca u sapän ni ch'ocda täj c'aba', no'on chich u sapänon. Y machca u sapänon no'on, mach sec' no'on u sapänon, u sapän täcä machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","De ya'i aj Juan u yälbi ca'da: ―Maestro, cä chäni t'ocob untu winic u pa'sen tzuc pixan tuyac'o machca chichca t'oc a c'aba', pero ni winic jini mach'an t'oc no'onla. Jin uc'a cälbi t'ocob que mach u ni' chen ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aj Jesús u yälbi: ―Mach a wälbenla que mach u ni' chen ca' jini, uc'a mach'an niuntu que u chen täj c'aba' cua' chichca jini t'oc poder que niuntu mach u che trebe u chen, y de ya'i u sutän uba u cäräx älbenon. ");
INSERT INTO chfNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Uc'a machca mach'an contra de no'onla t'oc chich no'onla ayan. ");
INSERT INTO chfNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y machca chichca u yäc'benetla ump'e pote de ja' täj c'aba' uc'a tubaletla aj Cristo, Dios u totoj xe chich u yäc'benob u matän. ");
INSERT INTO chfNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Y machca chichca que u yäc'ben sätic untu de ni bijch'ocda que u tz'ombenonba, mejorica cächbintic ump'e noj cha' de juch'i' buc'a tu luc'ub y julcac tan nab. ");
INSERT INTO chfNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Si untz'it a c'äb u yäc'benet a chen a tanä, seq'ue, uc'a más utz ochiquet bajca a xe tä äc'binte paq'uin cuxlequet tontz'it a c'äb y mach julcaquet tama noj c'ac' tä infierno t'oc chatz'it a c'äb, tama jini noj c'ac' bajca mach bay uxin tä täpo. ");
INSERT INTO chfNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Uc'a ya'i u noc'a ajchäme mach ucham y ni c'ac' mach bay uxin tä täpo. ");
INSERT INTO chfNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Si untz'it a woc u yäc'benet a chen a tanä, seq'ue täcä, uc'a más utz ochiquet tontz'it a woc bajca a xe tä äc'binte paq'uin cuxlequet y mach julcaquet tama noj c'ac' tä infierno t'oc chatz'it a woc, tama jini noj c'ac' que mach bay uxin tä täpo. ");
INSERT INTO chfNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Uc'a ya'i u noc'a ajchäme mach ucham y ni c'ac' mach bay uxin tä täpo. ");
INSERT INTO chfNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y si unxim a jut u yäc'benet a chen a tanä, pa'sen, uc'a más utz ochiquet tonxim a jut bajca u chen manda Dios y mach julcaquet tama noj c'ac' tä infierno t'oc cha'xim a jut. ");
INSERT INTO chfNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Uc'a ya'i u noc'a ajchäme mach ucham y ni c'ac' mach bay uxin tä täpo. ");
INSERT INTO chfNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Apetela a xe tä utela tu toja t'oc tz'ibajtesia, ca' chich ni we'e u yäc'binte atz'am uc'a ajnic jätz'äcna. ");
INSERT INTO chfNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ni atz'amba utz chich une. Pero si sätic u ch'och'anba, ¿cache'da u ch'e' u ch'och'esan cua' chichca? Ajniquetla jiq'uin ca' atz'am, y cuxlequetla ch'ijcab a c'ajalinla t'oc upete a lotla. ");
INSERT INTO chfNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aj Jesús pasi tä Capernaum y bixi tä Judea, y c'axi tunxe río Jordán. Ya'i u motli uba tä cha'num q'uen gente bajca ayan une, y cayi u ye'benob u t'an Dios ca' chich nämä u chen. ");
INSERT INTO chfNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","De ya'i tulaj c'otijob aj fariseo bajca an aj Jesús tuba u jiran si u yäc'ben u säte'ob. U c'atbijob si utz que untu winic u waläctan jit'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Une u p'albijob ca'da: ―¿Cache'da u yälbetla aj Moisés? ");
INSERT INTO chfNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Unejob u yäli: ―Aj Moisésba u yäli que äc'bintic ump'e jun ni ixic, y ca' jini u ch'e' waläctintic. ");
INSERT INTO chfNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","De ya'i aj Jesús u yälbijob: ―Aj Moisés u yälbet a chenla ca'da uc'a mäx tzätz a pamla apetela. ");
INSERT INTO chfNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero chäcäl najtäcäba jinq'uin Dios u chi upete cua' chichca, “u chi täcä winic y ixic”. ");
INSERT INTO chfNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Jin uc'a u yäctan u pap y u na' untu winic tuba ajnic tomp'e t'oc jit'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Y u cha'tumajob u colan ca' a wälä tontujob”. Ca' jini ca' a wälä mach cha'tujob. Tontujob une. ");
INSERT INTO chfNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jin uc'a, jini que Dios u yäc'bi ajnic tomp'e t'oc jit'ocba, mach'an cua' uc'a u tz'eje' ubajob. ");
INSERT INTO chfNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","De ya'i, jinq'uin ya'anob tama ump'e otot, u yajcänt'anob sujli u c'atbenob cache'da jini u yäliba. ");
INSERT INTO chfNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aj Jesús u yälbijob: ―Jini winic que u waläctan jit'oc y lotojac t'oc otroba, u chen u tanä de cherajtz'ijte'. ");
INSERT INTO chfNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y si ixic u yäctan jit'oc y lotojac täcä t'oc otro winicba, u chen u tanä de cherajtz'ijte' täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","De ya'i u täsijob bijch'oc bajca an aj Jesús tuba u täle' t'oc u c'äb, pero u yajcänt'anob cayi u q'uejpanob jini machca u täsenob ni bijch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jinq'uin u chäni aj Jesús ca' jini, cäräx'i y u yälbijob ca'da: ―Äctanla tic ni bijch'oc bajca anon. Mach a ch'acbenla u biji, uc'a bajca u chen manda Dios tä cielo, tubajob une jini machcatac ca' a wälä ni bijch'ocda. ");
INSERT INTO chfNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Totojtoj cälbenetla, machcatac mach u sapä Dios tuba ajnic de u Yajnoja ca' chich untu bijch'oc u sapän Dios, mach uxin tä oche bajca u chen manda. ");
INSERT INTO chfNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","De ya'i u ch'i u meq'ue' ni bijch'oc tu c'äb y u ch'u'ul chi, y u yäc'bi u c'äb tan u pamob. ");
INSERT INTO chfNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jinq'uin aj Jesús u chi segui xämba tutz'i untu winic t'oc noj ancäre y c'oti tä nocyälo tu yoc. U c'atben ca'da: ―Maestro, utz a c'ajalin. ¿Cua' u ch'e' cä chen tuba paq'uin cuxlecon? ");
INSERT INTO chfNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aj Jesús u p'albi: ―¿Cua' uc'a a wälbenon cache' utz cä c'ajalin? Niuntu mach'an utz u c'ajalin, seq'uen Dios une. ");
INSERT INTO chfNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A wi chich ni manda ta Dios, ni u yäle' ca'daba: “Mach a sacän a tz'ijte'. Mach a chen tzämsa. Mach a chen xuch'. Mach a wäle' que u chi cua' chichca a lot si mach toj. Mach a sucpecän a lot. Tz'omben u t'an a pap y a na'”. ");
INSERT INTO chfNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ni winic u p'ali: ―Maestro, upete ni jini cä laj chi chich cumpli desde p'i'on to. ");
INSERT INTO chfNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aj Jesús u chämbi u jut t'oc yajin y u yälbi ca'da: ―Ump'e namás acoli que mach to a che cumpli. Corre chono upete lo que a cänäntan y laj sijben pobrejilba ni u taq'uini. De ya'i la'ix täc pat a chen ca' chich cä chen no'onba, y a xe a cänäntan q'uen cua' chichca choj u valor ni ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jinq'uin u yubi ca' jini jini winic, c'ac'a' ch'ocomi u pixan y bixi mäx triste, uc'a jini winic mäx q'uen cua' chichca u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","De ya'i aj Jesús u chäni u junxoyma de une y u yälbi u yajcänt'anob ca'da: ―Mach u totoj ch'ä ochic untu ajtaq'uini bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","U yajcänt'anob tajch'icwäni u jut u yubin cua' u yäle'. Pero aj Jesús sujli u yälbenob ca'da: ―Cä bijch'oc, mach u totoj ch'ä ochic bajca u chen manda Dios jini que mäx u yajna'tan u taq'uinba. ");
INSERT INTO chfNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más u ch'e' numic untu ajcamello tu jut untz'it putz' que ochic untu ajtaq'uini bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jinq'uin u yubijob ca'da, más tajch'icwäni u jutob, y cayi u maläc c'atben u lotob ca'da: ―¿Caxca une jiq'uin u ch'e' u japän uba? ");
INSERT INTO chfNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aj Jesús u chämbi u jutob y u yälbijob ca'da: ―Ni winicba mach u ch'ä u japän uba u juntuma, pero Diosba u ch'e' u japänob. Uc'a Diosba mach'an niump'e cua' que mach u chen trebe u chen. ");
INSERT INTO chfNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","De ya'i aj Pedro u yälbi ca'da: ―Cajnoja, no'on t'ocobba cäcti t'ocob upete cua' chichca cä cänäntan t'ocob tuba cä tzäypätinet t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Aj Jesús u p'albi: ―Totojtoj cälbenet, machca chichca que u yäctan yotot, u säcun, u chich, u jitz'inob, u pap, u na', u ch'ocob o u cab uc'a u tz'ombenon y uc'a u tz'onän u t'an Dios, ");
INSERT INTO chfNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","u xe chich tä äc'binte wida pancab cien veces más q'uen que ni u yäctiba. U xe tä äc'binte yotot, u säcun, u chich, u jitz'inob, u na', u ch'ocob y u cab. U xe tä äc'binte tz'ibajtesia täcä. Y ji'pat u xe tä äc'binte paq'uin cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero q'uen chich machcatac ajt'äbälajob bada u xe tä ajtä más ajch'och'oca ya'i tä cielo, y q'uen chich machcatac ajch'och'oca bada u xe tä ajtä más ajnoja ya'i tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tä bij to u bixejob jinq'uin ya' u xejob tä Jerusalénba, aj Jesús u bixe pänte' de u yajcänt'anob. Ni ajcänt'anobba mach u totoj ta tu c'ajalinob cua' u yubijob, y c'äsbäc'ta u bixe tu patob. De ya'i aj Jesús sujli u joq'ue' ni ajcänt'anob ump'e la'o de ni gente y u täq'ui u yälben cua' jini u xe u chen pasa. ");
INSERT INTO chfNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","U yälbijob ca'da: ―Ca' chich a chänenla, bada bixe acä chenla tä Jerusalén. Ya'i no'on que sutwänon de winicba cä xe tä äc'can tu c'äb ni ajnojajob tuba palejob, y jini que u ye'e'ob ni ley taj Moisésba. Cä xe tä tzämsinte y cä xe tä äc'can tu c'äb ajpäpä'cabob. ");
INSERT INTO chfNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Unejob u xe u tze'tanonjob, u xe u cune'onjob, u xe u tubänonjob, y u xe u tzämsenonjob. Pero u yuxp'elib q'uin cä xe tä cuxpan tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","De ya'i aj Jacobo y aj Juan, u ch'ocob aj Zebedeoba, u natz'ijob aj Jesús u yälbenob ca'da: ―Maestro, co que a cherbenon t'ocob jini favor cä xe cä c'atbenetba. ");
INSERT INTO chfNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Une u c'atbijob: ―¿Cua' a wo cä cherbenetla? ");
INSERT INTO chfNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Unejob u p'ali: ―Co t'ocob que ta' chumtä bajca a xe a chen manda chumlecon t'ocob untu ta' noj y untu ta' tz'ej. ");
INSERT INTO chfNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","De ya'i aj Jesús u yälbijob: ―Anelaba mach a wi cua' a c'atänla. ¿U ch'e' quira a ch'e'la jini tz'ibajtesia que cä xe cä ch'e' no'onba, y c'ablaquetla ca' chich cä xe tä c'ablan? ");
INSERT INTO chfNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Unejob u p'ali: ―U ch'e' chich. Aj Jesús u yälbijob: ―Toj chich, a xe a ch'e'la ni tz'ibajtesia que cä xe cä ch'e' no'onba y a xe tä c'ablanla ca' chich cä xe tä c'ablan. ");
INSERT INTO chfNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero chumlequetla täc noj y täc tz'ejba, mach no'on cä xe cäq'ue' une. Dios une u xe u yäc'ben machcatac yäcä uc'a tuba chumlec ya' jini. ");
INSERT INTO chfNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jinq'uin u yubijob ca' jini ni diez ajcänt'anobba, cäräx'ijob t'oc aj Jacobo y aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero aj Jesús u pequijob y u yälbijob ca'da: ―A wila chich cache' untu ajmanda tama ump'e noj cab, tu manda chich ayan upete gente. Nuc ajt'äbälajobba ayan chich u poder tuba u cocoj äc'ben ni gente u tz'omben u t'an. ");
INSERT INTO chfNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero anelaba mach uxet a chenla ca' jini. Machca chichca de anela que yo u chen uba de ajnoja, c'änä sujlec de a wajc'äncanla. ");
INSERT INTO chfNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y machca chichca de anela que yo xic de ajmanda, c'änä sujlec ca' a wälä de a wajpatanla. ");
INSERT INTO chfNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Uc'a no'on que sutwänon de winicba mach aton tuba cherbinticon cua' chichca que c'änä cäc'a. Aton tuba cä cherben cua' chichca que c'änä uc'a otro, y tuba cäq'ue' cäba tä chämo tuba ajnicon de u tojquiba tanä uc'a u japän uba q'uenob. ");
INSERT INTO chfNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","De ya'i c'otijob tä Jericó. Y jinq'uin aj Jesús pase u chen tama ni caj jini nämte' t'oc u yajcänt'anob y t'oc noj q'uenel gente, u nuc'tijob untu ajchoc' u c'aba' aj Bartimeo ajlo' taj Timeo. Ya' chumca tu ch'ejpa bij u c'atän äc'bintic u matän. ");
INSERT INTO chfNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jinq'uin u yubi cache' nume u chen ni aj Jesús u cab tä Nazaretba, jini ajchoc' u täq'ui noj t'an u yäle' ca'da: ―Jesús, natil ch'oquet taj David, ch'ämbenon yajin. ");
INSERT INTO chfNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Q'uen machca u q'uejpan tuba ch'ijcäbac, pero une más noj t'an u chen: ―Ane natil ch'oquet taj David, ch'ämbenon yajin. ");
INSERT INTO chfNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","De ya'i aj Jesús tajwa'wäni, u yäli: ―Älbenla que tic. U joq'uijob jini ajchoc' y u yälbijob: ―Mach bäc'taquet. Ch'oyen uc'a mu' u joq'ue'et. ");
INSERT INTO chfNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","De ya'i u juli u buc tä cab y t'oc wanajtäne bixi u natz'än aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aj Jesús u yälbi ca'da: ―¿Cua' a wo cä cherbenet? Jini ajchoc' u p'ali: ―Maestro, co que a tz'äcälin cä jut. ");
INSERT INTO chfNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aj Jesús u yälbi: ―U ch'e' bixiquet. Uc'a a tz'oni, a pojli chich aba. Jinchichba rato jini, jini ajchoc' u chi chanä, y u tzäypäti aj Jesús bajca u bixe. ");
INSERT INTO chfNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jinq'uin c'otijob nätz'ä bajca an ni caj tä Jerusalén, ya'i bajca an ni cajob tä Betfagé y tä Betania, tu pänte' ni noj tz'ic u c'aba' Olivos, aj Jesús u täsqui cha'tu u yajcänt'anob u yälbijob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Cuxla ane más pänte' bajca an ump'e yoc caj. Ta' ochela ya'i a xe a pojlenla untu yoc tzimim cächä. Jini tzimim mach to bay u chumta niuntu. P'änäla y täsenla. ");
INSERT INTO chfNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Machca chichca u c'atän: “¿Cua' uc'a a p'äne'la?”, älbenla cache' Ajnoja c'änä uc'a, y ji'pat u xe u sutatz'än. ");
INSERT INTO chfNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Unejob bixi y u pojlijob jini tzimim que ya' cächä tu ti' bojte' tan bij, y u p'änijob. ");
INSERT INTO chfNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jini machcatac ya'anob ya'iba u yälbijob ca'da: ―¿Cua' a chenla? ¿Cua' uc'a a p'äne'la jini tzimim? ");
INSERT INTO chfNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Unejob u p'ali ca' chich u yälbijob aj Jesús que u p'alän. De ya'i ni winicob jini u yäctijob chich u bisan ni tzimim. ");
INSERT INTO chfNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","U bisijob jini tzimim bajca an aj Jesús y u läcbijob u buc tu pat, y aj Jesús u chumti ni tzimim. ");
INSERT INTO chfNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Q'uenob u laj jäyi u bucob tan bij y otrosjob u c'äse'ob u c'äb te' u laj äq'ue'ob tan bij bajca u xe tä nume aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Machcatac u tejob pänte' y machcatac u tejob pati u täq'ui u chenob noj t'an u yäle'ob ca'da: ―¡Ch'u'ul c'ajti'cac Dios! ¡Ch'u'ul ayan jini que Cajnojala Dios u täsquiba! ");
INSERT INTO chfNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ch'u'ul ayan bajca u xe u chen manda Dios, jini u manda Dios ca' chich ni manda u cänänti cä najtäcäl noxi'papla aj Davidba! ¡Ch'u'ul c'äycac u c'aba' Dios tä cielo! ");
INSERT INTO chfNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","De ya'i aj Jesús ochi tama jini caj tä Jerusalén, y ochi täcä tama ni noj ch'u'ul otot taj judíosob. Cuanta u chäni cua' an tama jini ch'uj, pasi ya'i bixi tä Betania nämte' t'oc ni doce u yajcänt'anob, uc'a atarde'i. ");
INSERT INTO chfNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Päscab jinq'uin pasijob tä Betania aj Jesús u na'ti jitz'o. ");
INSERT INTO chfNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nat to u chäni untec te' higo que cuxu u yopo. Bixi u jiran si ayan u jut ni te' higo, pero mach u pojli niump'e cua', sec' u yopo, uc'a mach jin u q'uini ni higo. ");
INSERT INTO chfNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","De ya'i aj Jesús u yälbi ni te' higo ca'da: ―Niuntu mach bay uxin u c'uxe' a jut. Ni ajcänt'anob u yubi cua' u yäli. ");
INSERT INTO chfNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ji'pat c'otijob tä Jerusalén. Jinq'uin ochi aj Jesús tama jini noj ch'u'ul otot, u täq'ui u pa'senob machcatac ya'anob tä chono y tä manob ya'i. U t'eljulbi u mesa ajq'uextaq'uinob y u t'eljulbijob täcä u chumlib ajchon ixpalomajob. ");
INSERT INTO chfNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y mach u yäcta que niuntu ochic t'oc u cuch tan ni noj ch'u'ul otot. ");
INSERT INTO chfNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","U täq'ui u ye'benob u t'an Dios ca'da: ―Ni jun ta Dios u yäle': “Cototba u xe tä älcan cache' otot ta c'änti'ya, uc'a ya'i u xe u chen c'änti'ya upete gente”. Pero anelaba a chila de u yajliba ajxuch'ob. ");
INSERT INTO chfNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ajnojajob tuba palejob y jini machca u ye'e' ni ley taj Moisésba u yubijob cua' u chi, y u täq'ui u sacänob cache' u ch'e' u tzämsenob. Bäc'tajob t'oc uc'a ni gente tajch'icwäni u jut u yubin cua' u ye'e'. ");
INSERT INTO chfNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jinq'uin ochi ac'äb aj Jesús pasi ya'i tama ni caj. ");
INSERT INTO chfNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Päscab ic'sapanto numijob bajca an ni te' higo y u chänijob cache' atiqui ixta tu wi'. ");
INSERT INTO chfNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","De ya'i aj Pedro ti tu c'ajalin cua' u yäli aj Jesús, y u yälbi ca'da: ―Maestro, iran. Jini te' higo a q'uejpiba atiqui. ");
INSERT INTO chfNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aj Jesús u p'ali: ―Tz'ombenla Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Totojtoj cälbenetla, machca chichca u yälben jini tz'icda: “Pasen wida, julu aba tan nab”, y si mach ajnic tu c'ajalin cache' Dios mach u che trebe u chen, si u totoj tz'onän cache' u xe chich tä ute ca' u yäliba, che' chich u xe u chen pasa. ");
INSERT INTO chfNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jin uc'a cälbenetla cache' upete cua' chichca a c'atänla t'oc c'änti'ya y a tz'onän cache' a xe chich tä äc'binteba, Dios chich u totoj xe u yäc'benetla. ");
INSERT INTO chfNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jinq'uin mu' a c'änti'yala, si tic ta' c'ajalinla cache' cäräxet t'oc a lot, c'änä a chen perdonala uc'a ca' jini täcä ni cä Papla ya'an tä cieloba u chen perdona a tanäla. ");
INSERT INTO chfNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Si anela mach a chen perdona a lotlaba, ni cä Papla ya'an tä cieloba mach uxin u chen perdona a tanäla täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","De ya'i sutwänijob tä Jerusalén. Jinq'uin aj Jesús ochi tama ni noj ch'u'ul otot, c'otijob bajca an une u yajnojajob palejob, y machcatac u ye'e' ni ley taj Moisés, y noxibilba ta caj. ");
INSERT INTO chfNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","U c'atbijob ca'da: ―¿Caxcone u yäc'bet poder tuba a chen upete jini a chenba? ¿Caxcone u yälbet a chen ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aj Jesús u p'ali: ―No'on täcä cä xe cä c'atbenetla ni jinda, si ane a wälbenonla tu tojaba, no'on täcä cä xe cälbenetla caxca une u yäc'bon poder ta cä chen jini cä chenba. ");
INSERT INTO chfNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Caxca une u täsqui aj Juan u chen c'ablesia, Dios quira o winicob? Co que a wälbenonla. ");
INSERT INTO chfNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","De ya'i u täq'ui u maläc äle'ob ca'da: ―Si cäle'la cache' Dios, u xe u p'albenonla ca'da: “¿Cua' uc'a jiq'uin mach a tz'ombila?” ");
INSERT INTO chfNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mach u ch'ä cäle'la täcä cache' winic u täsqui. Ca' jini u yälijob uc'a unejobba bäc'tajob t'oc ni gente. Yuwijob täcä cache' q'uenob u yäle' cache' aj Juanba totoj ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jin uc'a u p'albijob aj Jesús ca'da: ―Mach cuwi t'ocob. Aj Jesús u p'ali täcä: ―Ni no'on täcä mach uxon cälbenetla caxca une u yäc'bon poder ta cä chen upete ni cua' cä chenba. ");
INSERT INTO chfNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","De ya'i aj Jesús u täq'ui u ye'benob u t'an Dios t'oc tz'aji que mach totoj cheque cua' u yäle' ni tz'aji. U yälbijob ca'da: ―Ajni untu winic que u päq'ui uva tan u cab, y u bojte'i u junxoyma. U chi ump'e ch'en bajca u xe u yätz'e' jini uva, y u tz'osi täcä ump'e noj torres bajca u yajtä tu pam uc'a u cänäntan ni päc'äbi jini. ’De ya'i u yäc'bi tu c'äb otro ajpatanob ni cab jini tuba u cänäntäben, y une bixi nat. ");
INSERT INTO chfNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jinq'uin c'oti u q'uini tuba c'ä'nac u jut ni päc'äbi, u täsqui untu u yajc'äncan tuba u c'atben ni ajpatanob jini tz'ita' u jut ni päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero ni ajpatanob jiniba u q'uechi ni ajc'äncan jini, u bon cunijob y u täsquijob que bixic y mach u yäc'bijob niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","De ya'i u yum u caba ni päc'äbi sujli u täscun otro u yajc'äncan. Jinda täcä u bon cunijob t'oc ji'tun, u tzepbijob tan u pam y u bon cäräx älbijob. ");
INSERT INTO chfNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ni u yum u caba ni päc'äbi sujli u täscun otro u yajc'äncan. Ni jindaba u tzämsijob. Ji'pat u chi segui u bon täscun otros u yajc'äncan. Ni ajc'äncanob jini, ayan machca u cunijob y ayan machca u tzämsijob. ");
INSERT INTO chfNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’De ya'i ajni untu u yajlo' que mäx u yajna'tan, y u täsqui täcä, uc'a ti tu c'ajalin ca'da: “Bay cajlo'ba u xe chich u tz'ombenob u t'an”. ");
INSERT INTO chfNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero ni ajpatanob jini u maläc älijob ca'da: “Ni ajlo'daba une u xe tä colan ji'pat de u yum ni cabda. Cola cä tzämsenla jiq'uin, uc'a ca' jini colac täc'ala ni cabda”. ");
INSERT INTO chfNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jin uc'a u q'uechijob y u tzämsijob y u pa'sijob jini ajchäme tama u caba ni päc'äbi jini. ");
INSERT INTO chfNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","De ya'i aj Jesús u yälbijob: ―¿Cua' a wäle'la u xe u chen u yum ni u caba päc'äbi jini? Cäle' que u xe tä te, u xe u tzämsen ni ajpatanob jini y u xe u yäc'ben u caba jini päc'äbi otros ajpatanob. ");
INSERT INTO chfNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Mach to quira a tziquila cache' u yäle' ni jun ta Dios tz'ibiba? U yäle' ca'da: Ni ji'tun que u yäli ajcheraj otot que mach utzba, jin une ch'ämqui tuba xic mero u ch'ixma otot. ");
INSERT INTO chfNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jindaba Ajnoja chich u chi ca' jini, y tä' pitzi cua' u chi. ");
INSERT INTO chfNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","De ya'i jinijob que mach yo u chänen aj Jesúsba u yolijob u q'ueche' u yäq'ue' preso, uc'a ti tu c'ajalinob cache' ni tz'aji que u yäliba, de unejob une u yäli. Pero bäc'tajob t'oc ni caj, jin uc'a mach u q'uechijob. De ya'i bixijob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ji'pat ajt'äbälajob tuba aj judíosob u tulaj täsquijob aj fariseojob bajca an aj Jesús, y che' chich täcä aj Herodesjob tuba u jiranob si u ch'e' u yäc'ben u säte' uc'a u sube'ob. ");
INSERT INTO chfNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ni winicobdaba c'otijob bajca an aj Jesús y u yälbijob ca'da: ―Maestro, cuwi t'ocob que aneba upete a wäle' tu toja, y mach u che cua' u yäle' ni gente, uc'a cachichca une a ye'ben chich u t'an Dios tu toja, y a ye'ben cache'da u ch'e' u bisan bij t'oc Dios. ¿Cache'da a wäle' ane? ¿Utz quira äc'bintic ni ajmanda tuba aj romanojob jini taq'uin que u c'atänba, o mach utz? ¿Cä'benla quira, o mach cä'benla? ");
INSERT INTO chfNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aj Jesúsba yuwi chich cua' an tu c'ajalinob, y u yälbijob ca'da: ―¿Cua' uc'a a sacänla cache' a wäc'benon cä säte'? Täsenla wida ump'e taq'uin uc'a cä chänen. ");
INSERT INTO chfNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Unejob u yäc'bijob. Jinq'uin u chäni aj Jesús jini taq'uin, u c'atbijob ca'da: ―¿Caxca u retrato ni jinda, y caxca u c'aba' ya' tz'ibi tuyac'o? Unejob u p'ali: ―Tuba aj César. ");
INSERT INTO chfNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","De ya'i aj Jesús u yälbijob ca'da: ―Äc'benla aj César jini tuba chich aj Césarba, y äc'benla Dios jini tuba chich Diosba. Y upete tajch'icwäni u jutob u yubin cache'da u p'ali. ");
INSERT INTO chfNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","De ya'i c'oti bajca an aj Jesús aj saduceojob. Ni winicobdaba u yäle'ob cache' mach u cuxpa ajchäme. Jin uc'a u yälbijob aj Jesús ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, aj Moisés u colesi tz'ibi tuyac'o jun cache' si untu winic chämicba, y u colesan jit'oc sin u bijch'oc, c'änä lotojac jini ixic t'oc jitz'in ni c'äsi' winic, uc'a tu tz'isen u bijch'oc ni neba' ixicba, es ca' a wälä u bijch'oc ni winic que chämiba. ");
INSERT INTO chfNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ajni untu winic que u cänänti siete u yajlo'. Ni najtäcäba lotoji, pero chämi sin que ajnic u bijch'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","De ya'i ni neba' ixic lotoji t'oc u cha'tulib, pero chämi täcä sin que ajnic u bijch'oc. Che' chich u chi pasa täcä u yuxtulib. ");
INSERT INTO chfNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ni siete u ch'ocob ni winic jini laj lotojijob t'oc ni ixic jini, pero laj chämijob sin que ajnic u bijch'oc. Ji'pat chämi täcä ni ixic. ");
INSERT INTO chfNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tu xe tä cuxpanob jinq'uin u xe tä cuxpan ajchämejobba, ¿caxcamba de ni siete winicob jini u xe tä colan de jit'oc? Uc'a upetejob laj ajni chich de jit'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aj Jesús u p'albijob ca'da: ―Anelaba mach a wi cua' a wäle'la, uc'a mach a che entendela cua' u yäle' ni jun ta Dios tz'ibiba y cache'da an ni poder ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Uc'a jinq'uin u xe tä cuxpan ajchämejobba, mach uxin tä lotojanob, y mach uxin u yäq'ue' jixic ch'ocob tuba lotojac, uc'a unejobba u xe tä ajtä ca' chich ni ángelojob que ya'an tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Badaba co cälbenetla cache' u xe chich tä cuxpan ajchäme. ¿Mach to quira a tziquila cua' u yäle' tama ni jun que u tz'ibi aj Moisésba? Ni jun jini u yäle' cache' Dios c'oti tama noj chäcch'ix u pecän aj Moisés, jinq'uin c'oti aj Moisés u chänen cua' uc'a ayan c'ac' tama ni chäcch'ix y mach upul. U yälbi ca'da: “No'on ni Dioson tuba aj Abraham, tuba aj Isaac, y tuba aj Jacob”. ");
INSERT INTO chfNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uc'a Diosba mach jin Dios tuba ajchämejob. Dios une tuba machcatac cuxu ayan. Uc'a unejob totoj cuxu ayanob tu jut Dios. Anelaba mach a wi cua' mu' a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","C'oti täcä bajca an aj Jesús untu jini que u ye'e' ni ley taj Moisés, y u yubi cua' jini mu' u yäle'ob t'oc aj Jesús, y u yubi täcä cache' u p'ali tu toja. Y une u c'atbi ca'da: ―¿Camba ni manda más c'änä cä tz'onänla que u yäq'ui Diosba? ");
INSERT INTO chfNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aj Jesús u p'albi: ―Ni manda más c'änä cä tz'onänla de upete mandaba, jinda une: “Ubinla, lo' Israel. Ni Cajnojala Diosba, tontuntu une. ");
INSERT INTO chfNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yajna'tanla a Wajnojala Dios con to'o a ch'a'aljinla uc'a tä' a wo a chenla, con to'o a pixanla, con to'o a c'ajalinla, y con to'o a muc'la”. Jinda ni manda más c'änä cä tz'onänlaba. ");
INSERT INTO chfNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","U chap'elibba es ca' chich jini täcä: “Yajna'tan a lot ca' chich a yajna'tan aba ane”. Mach'an niump'e otro manda más c'änä cä tz'onänla que jindajob. ");
INSERT INTO chfNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","De ya'i jini que u ye'e' ni ley taj Moisésba u yäli ca'da: ―Utz chich cua' a wäli, Maestro. Toj chich cua' a wäli, cache' tontuntu Dios ayan, y mach'an otro dios ca' une. ");
INSERT INTO chfNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Y si cä yajna'tanla Dios con to'o cä ch'a'aljinla uc'a tä' co cä chenla, y con to'o cä c'ajalinla, con to'o cä pixanla, y con to'o cä muc'la, si cä yajna'tanla täcä cä lotla ca' chich cä yajna'tan cäbala no'onlaba, más utz une que cua' chichca jini que u subbinte Diosba, y más utz täcä que cua' chichca matän que u pulcan pan alta tuba subbintic Diosba. ");
INSERT INTO chfNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jinq'uin u yubi aj Jesús cache' tu toja u p'ali jini winic, u yälbi ca'da: ―Tz'ita' yo tuba a sapän ajniquet tu manda Dios. De ya'i niuntu mach u ni' oli u c'atben niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Aj Jesús ya'an u ye'benob u t'an Dios tama noj ch'u'ul otot, u yälbenob ca'da: ―¿Can uc'a u yäle'ob ni machca u ye'e' ley taj Moisésba cache' aj Cristo u yajlo' aj David? ");
INSERT INTO chfNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ni Ch'u'ul Pixan u yäc'bi aj David u yäle' ca'da: Ajnoja Dios u yälbi Cajnoja: “Chumi' täc noj ixta que cä'benet a xäc'teq'ue' jini machcatac mach yo u chänenetba”. ");
INSERT INTO chfNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Bada jiq'uin, ixta aj David u yälben aj Cristo cache' u Yajnoja. ¿Cache'da a wäle'la jiq'uin cache' aj Cristo es u yajlo' aj David? Ni noj q'uenel gente que ya'an bajca an aj Jesúsba u c'alin ubinob cua' u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aj Jesús u ye'bijob täcä ca'da: ―Cänäntan abala t'oc machcatac u ye'e' ni ley taj Moisésba. Unejobba tä' yojob numic t'oc u noj tamäl buc tuyac'o, y tä' yojob que ni gente tä calle u chen saludajob. ");
INSERT INTO chfNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Unejobba tä' yojob chumlecob tu pan ni chumlib bajca u chumtä ajt'äbälajob tuba ni ch'uj tuba aj judíosob y che' chich täcä bajca u c'uxnanob yojob chumlec tu pam jini chumlib más utzba. ");
INSERT INTO chfNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Unejobba u jajbenob u yotot neba'täc ixictac y u susuc chenob noj tamäl c'änti'ya. Unejobba, más q'uen castigo u xe u yäc'ben Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Unnum aj Jesús ya' chumca tama noj ch'u'ul otot tu ch'ejpa jini cajón bajca u yälo taq'uin, u chänen cache' ni gente u yäq'ue' taq'uin. C'otijob ajtaq'uini täcä u yäq'ue' q'uen taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jimba rato jini c'oti untu neba' ixic y u yäq'ui tama jini cajón chap'e yoc bit taq'uin que mach mäx choj u valor. ");
INSERT INTO chfNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","De ya'i aj Jesús u joq'ui u yajcänt'anob y u yälbijob ca'da: ―Totojtoj cälbenetla cache' ni pobre neba' ixicdaba más u chen vale lo que u yäq'ui que jini taq'uin que u yäq'ui otrosjobba. ");
INSERT INTO chfNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Uc'a unejobba u yäq'uijob tz'ita' u colob de lo que u cänäntanob. Pero ni ixicdaba u yäq'ui upete lo que u cänäntan, ixta mach acoli tuba u mäne' t'oc cua' u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jinq'uin pasi aj Jesús tama ni noj ch'u'ul otot, untu de u yajcänt'anob u yälbi ca'da: ―Maestro, chänen jini ji'tun ta otot de pitzijtac, y de pitzijtac täcä jini otote. ");
INSERT INTO chfNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","De ya'i aj Jesús u p'albi: ―¿A chänenla ni otote jini tä' pitzijtacba? Mach uxin tä colan niump'e ji'tun tuba ni ototob jini ajnic tz'äjca tu pam u lot sin que mach jinescac, uc'a upete ni otote jini u xe tä laj jinescan. ");
INSERT INTO chfNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","De ya'i bixijob tu pam ni tz'ic u c'aba' Olivos. Ni tz'ic jiniba ayan tu pänte' ni noj ch'u'ul otot. Jinq'uin aj Jesús chumwäni ya'i, aj Pedro, aj Jacobo, aj Juan y aj Andrés u mucul c'atbi ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Co que a wälbenon t'ocob caq'uin u xe tä ute ni a wäliba, y cache'da u xe tä wina'tinte si ac'oti u q'uini tuba u chen pasa ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aj Jesús u p'albijob: ―Cänäntan abala, mach me'ixto ajnic machca u sucpecänetla. ");
INSERT INTO chfNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Uc'a q'uen u xe tä te täj c'aba' u yäle' ca'da: “No'on ni aj Cristojon”; y q'uen u xe u sucpecänob. ");
INSERT INTO chfNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Pero anelaba, jinq'uin a ubinla cache' atä'qui jo'yan, o a ubinla u tz'ayquinte cache' u xe tä ajtä jo'yan, mach bäc'taquetla, uc'a ca' chich jini u xe u chen pasa. Pero mach to jin u xupiba u pancab. ");
INSERT INTO chfNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Uc'a najtäcä u xe u chen jo'yan ump'e noj cab t'oc otro noj cab y ump'e caj t'oc otro caj, y u xe tä ajtä ajchaban cachichcada pancab. U xe tä ajtä wi'na, y u xe tä ajtä jobole. Upete ni jindajobba u tä'quiba to ni tz'ibajtesia que u xe tä ajtä. ");
INSERT INTO chfNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Cänäntan abala ane jiq'uin, uc'a a xe tä äc'canla tu c'äb ajmandajob ta caj, a xe tä cuncanla tama ch'uj taj judíosob. Anelaba c'änä bisintiquetla bajca an ni ajmandajob y ni ajnojajob tuba caj uc'a a tz'ombenonla. Pero ca' jini u xe u ch'e' a tz'aycäbenla täcä u t'an Dios ni ajmandajob jini. ");
INSERT INTO chfNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Uc'a u t'an Dios c'änä tz'aycäbinticob najtäcä upete machcatac cuxu pancab, y ji'pat u xe tä xupo u pancab. ");
INSERT INTO chfNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jinq'uin a xe tä bisintela tuba äc'caquetla tu c'äb ni ajmandajob ta caj, mach bäc'taquetla, y mach a chen pensala cua' a xe a wäle' y mach c'änä a ch'e' a c'ajalinla täcä. Äläla jini u xe u yäc'benetla Dios a wäle'la jimba rato jiniba, uc'a mach anela ni a xe a chen t'anla. Ni u xe u chen t'anba, jin une ni Ch'u'ul Pixan que ya'an ta'wac'olaba. ");
INSERT INTO chfNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ni winicob u xe u yäq'ue' u säcunob tä tzämsinte. Che' chich u xe u chen täcä u pap untu t'oc u ch'ocob, y ni u ch'ocob u xe u jule' uba tuyac'o u pap ixta u yäq'ue' tä tzämsinte. ");
INSERT INTO chfNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Upete machcatac cuxu pancab mach uxin u yolin u chänenetla uc'a a tz'ombenonla, pero machca mach u yäcta u tz'ombenon ixta tu xupiba u pancabba uneba u xe chich u japän uba. ");
INSERT INTO chfNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Jinq'uin a xe a chänenla u yute cua' chichca mach utz tama ni ch'u'ul otot ixta u yäq'ue'ob cua' chichca bajca mach utz äc'cac tuba ch'u'ul c'ajti'cac en lugar de Dios, jini que mach yo Dios u chänenba, wina'tanla que jin une ni u yäli aj Daniel, ajt'an ta Dios oniba cache' u xe u chen pasa―machca u tzique', c'anä u chen entende―. Jinq'uinba, machcatac ya'an tama ni cab tä Judea c'änä bixic tä putz'e pan tz'ic. ");
INSERT INTO chfNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Machcatac ya'an pat yotot isqui jimba q'uinba, mach ni' jaquic tuba u ch'e' cua' chichca tan yotot. ");
INSERT INTO chfNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Machcatac ya'an tan pimi mach sujlec tu yotot tuba u ch'e' u buc. ");
INSERT INTO chfNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Lástimajob jini ixictac jini c'ojojtac t'oc u bijch'oc y jini ch'oc to u bijch'oc jimba q'uinob jiniba! ");
INSERT INTO chfNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","C'atbenla Dios jiq'uin que mach u chen pasa ca' jini tu q'uini sisi. ");
INSERT INTO chfNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Uc'a ni q'uinob jiniba, u xe tä ajtä noj gran tz'ibajtesia que mach bay ajni oni desde que Dios u chi u pancab ixta bada, y mach uxin tä ajtä täcä otro tz'ibajtesia ca' jini ji'pat. ");
INSERT INTO chfNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Si Cajnojala mach u tz'ita'esan ni q'uin jini, machica u japä uba niuntu. Pero une chich u tz'ita'esan uc'a mäx u yajna'tan jini u yaqui tuba ajnic sec' tubaba. ");
INSERT INTO chfNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Jin uc'a, si machca chichca u yälbenetla ca'da: “Iranla, ya'anda ni aj Cristo”, o “Iranla, ya'an nanti”, mach a tz'onänla. ");
INSERT INTO chfNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Uc'a u xe tä te q'uen ajjop'ojti'job que u xe u yäle'ob cache' une ni aj Cristo, y u xe u yäle'ob cache' ajt'anob ta Dios täcä. U xe u chenob q'uen cua' chichca tuba chänintic jini que mach u che trebe u chen untu winicba. U xe u chen q'uen cua' chichca t'oc poder tuba u sucpecänob q'uen gente. Ixta jini yäcä uc'a Diosba u xe u jiran si u ch'e' u sucpecänob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero anelaba acä worin älbetla cua' u xe u chen pasa. Jin uc'a cänäntan abala. ");
INSERT INTO chfNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Jimba q'uinob jiniba, cuanta numi jini tz'ibajtesia acäliba, ni q'uin u xe tä it'obnan. Ni uj mach uni' xin u chictan. ");
INSERT INTO chfNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ajlucerojob u xe tä te tä cielo tuba yälic tä cab, y upete ni ya'anob tä cielo que ayan u muc'ba u xe u laj nicän uba. ");
INSERT INTO chfNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","De ya'i u xe u chänenonjob no'on que sutwänon de winicba, cache' cä xe tä te tama ump'e noj bucla t'oc cä poder y t'oc cä pitzilan. ");
INSERT INTO chfNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","De ya'i cä xe cä täscun cä ángelojob tuba u woye' upete machcatac yäcä an uc'a Dios tuba ajnic sec' tubaba cachichcada tu pancab, mach u che si ixta tu jo u pancab, o ixta tu jo cielo. ");
INSERT INTO chfNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Tic ta' c'ajalinla cua' u ye'e' ni te' higo. Jinq'uin a chänenla cache' ch'oc u te'e y cache' u pase u ch'oc yopo, a wila chich que mach ni' q'uen yo tuba wa'lec q'uin. ");
INSERT INTO chfNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ca' chich jini täcä c'änä tic ta' c'ajalinla, jinq'uin a chänenla u laj chen pasa upete ni acäliba, wina'tanla cache' mach ni' q'uen yo tuba xupic u pancab. ");
INSERT INTO chfNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Totojtoj cälbenetla mach to u laj cham ni gente ya'an pancabba jinq'uin u xe u laj chen pasa jinda. ");
INSERT INTO chfNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ni cielo y u pancab u xe tä laj xupo, pero upete ni t'an que cäle' no'onba mach uxin tä colan niump'e sin que mach utic cumpli. ");
INSERT INTO chfNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Niuntu mach yuwi camba q'uin o camba hora u xe u chen pasa ni jini. Ángelojob tä cielo y u Yajlo' Dios mach yuwijob täcä. Sec' cä Pap une yuwi. ");
INSERT INTO chfNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Jin uc'a cälbenetla cache' c'änä a wäybetan abala y paq'uin chen c'änti'yala, uc'a mach a wila cua' hora u xe u chen pasa ni jini. ");
INSERT INTO chfNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ca' chich untu winic jinq'uin u bixe nat, mach to upas tan yotot u laj älben u yajpatan cua' u xe u chen, y cada juntu u yäc'ben ni patan que u xe u chenobba. Che' chich täcä u yälben ni ajcänän ti'bojte' que u cänäntan utz. ");
INSERT INTO chfNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ajniquetla jiq'uin p'ixi, uc'a mach a wila caq'uin u xe tä jule ni ajnoja tuba ni otot. Bay tu yoche ac'äb o tänxin ac'äb o tu yuq'ue piyo' o tu junch'äcnan u xe tä jule. ");
INSERT INTO chfNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mach me'ixto tajtzäc julic y u nuc'tanetla que ya'anetla tä wäye. ");
INSERT INTO chfNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ni cälbenetlaba, jin chich acälben upetejob: Ajniquetla p'ixi. ");
INSERT INTO chfNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chap'e q'uin yo tuba utic ni q'uin ch'uje ta paxcu', jinq'uin u c'uxcan ni waj sin jusonibba. Ni ajnojajob ta pale y jini machca u ye'e' ni ley taj Moisésba cayi u sacänob cache'da u ch'e' u q'ueche' aj Jesús t'oc jop'ojti' tuba u tzämsenob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","U yäle'ob ca'da: ―Mach cä chenla ca' jini tan mero q'uin ch'uje, uc'a mach xic u jobän uba ni gente. ");
INSERT INTO chfNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Aj Jesúsba ya'an tä Betania tu yotot aj Simón, jini aj Simón que u cänänti jini yaj que u c'u'nesben u bec'taba. Jinq'uin ya'to chumca tä c'uxnanba, c'oti untu ixic t'oc untz'it yoc botella que uti de pitzil ji'tun u c'aba' alabastro. Jini botella tulu ayan t'oc jätz'äcnib u c'aba' nardo. Ni jätz'äcnib jiniba tä' choj u valor. Ni ixic u t'oxi jini yoc botella y ni jätz'äcnib ajni tan botellaba u colbi tan u pam aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tulaj ajni ni ya'anob ya'iba que cäräx'ijob, y u maläc älijob ca'da: ―¿Cua' uc'a cräx uti ni jätz'äcnib jini? ");
INSERT INTO chfNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mejorica si fuera choncac por más de trescientos taq'uin u c'aba' denarioba tuba täclintic t'oc ni pobrejilba. U q'uejpijob ni ixic jini. ");
INSERT INTO chfNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aj Jesúsba u yälbijob ca'da: ―Mach a ni' q'uejpanla ni ixic jini, y mach a ni' jaq'uesben ujinla. Uc'a ni jinda que u cherbonba, tä' utz une. ");
INSERT INTO chfNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Uc'a ni pobrejilbaba ya' chich paq'uin an t'oc anela, y u ch'e' chich a täclenla cachichcamba q'uin que a wolin a täclenla. Pero no'onba mach uxon tä paq'uin ajtä t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ni ixicda u chi lo que u chi trebe u chen por no'on, uc'a une u jätz'äcnesi cä cuerpo antes de mujcacon. ");
INSERT INTO chfNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Totojtoj cälbenetla, cachichcada tz'ayquintic ni t'an ta Dios que u yäle' cache' u japän uba untuba, ya' chich u xe tä tz'ayquinte täcä cua' u chi ni ixicda, y ca' jini u xe tä paq'uin c'ajti'can täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","De ya'i aj Judas Iscariote, untu de ni doce u yajcänt'an aj Jesúsba, bixi u pecän ni ajnoja tuba palejob uc'a u subän uba tuba u yäq'ue' aj Jesús tu c'äbob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jinq'uin u yubijob ni ajnoja ta paleba, c'ac'a' ch'a'ali ujinob y u yälbijob que u xe u yäc'benob taq'uin u tojquiba u patan. De ya'i aj Judas cayi u sacän cache'da u xe u yäq'ue' tä c'äbä aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jini najtäcäl q'uin tuba ni q'uin ch'ujeba jinq'uin u c'uxcan ni waj sin jusonibba, y jinq'uin u tzämsinte ni ch'oc oveja tuba ni paxcu'ba, ni ajcänt'anob taj Jesús u c'atbijob ca'da: ―¿Caxcada a wo xicon cä tuse' t'ocob ni cua' tä c'uxcan ta paxcu' tuba cä c'uxe'la? ");
INSERT INTO chfNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","De ya'i aj Jesús u täsqui cha'tu u yajcänt'an y u yälbi ca'da: ―Cuxla tama jini caj y ya'i a xe a nuc'tanla untu winic que u bisan ump'e p'u de ja'. Tzäypätinla. ");
INSERT INTO chfNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bajca u xe tä oche, ochenla täcä, y älbenla u yum ni otot ca'da: “Ni Maestro u yäle' ca'da: ¿Caxcada an ni cuarto bajca cä xe cä c'uxe' ni cua' tä c'uxcan ta paxcu' nämte' t'oc cajcänt'anobba?” ");
INSERT INTO chfNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","De ya'i ni winic u xe u ye'benetla ump'e noj cuarto tu cha'täq'uib otot isqui que worin tusu ayan. Chenla ya'i ni cua' tä c'uxcan tuba cä c'uxe'la. ");
INSERT INTO chfNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ni ajcänt'anob pasi, bixijob tama jini caj, y c'oti chich u pojlenob ca' chich u worin älbijob aj Jesús. Ya'i u chijob ni cua' tä c'uxcan ta paxcu'. ");
INSERT INTO chfNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cuanta ochi ac'äb c'oti aj Jesús nämte' t'oc ni doce u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jinq'uin ya'an tä mesajob tä c'uxnanba, aj Jesús u yälbijob ca'da: ―Totojtoj cälbenetla cache' untu de anela que ya'an tä c'uxnan nämte' t'oc no'on badaba u xe u yäq'ue'on tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","De ya'i ni ajcänt'anob ch'ocomi u pixanob, y u täq'ui u juntu äle'ob ca'da: ―¿No'on wäreca? Otrojob täcä u yäle': ―¿No'on wäreca? ");
INSERT INTO chfNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aj Jesús u p'albijob: ―Untu de ni doce cajcänt'anob, jini que ya'an tä c'uxnan nämte' t'oc no'on tama jinchichba platoda, une chich une. ");
INSERT INTO chfNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bada jiq'uin cälbenetla cache' no'on que sutwänon de winicba cä xe tä cherbinte ca' chich u yäle' ni jun ta Dios tz'ibiba, pero ¡tä' lástima ni winic u xe u yäq'ue'on tä c'äbäba! Mejorica ajni mach päncäbac ni winic jini. ");
INSERT INTO chfNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mu'to u c'uxnanobba, aj Jesús u ch'i ni waj tu c'äb y u yälbi Dios que uc'adios u chi. De ya'i u taji jini waj u yäc'bi u yajcänt'anob, y u yälbijob ca'da: ―C'uxula ni wajda. Ni wajdaba cä cuerpo une. ");
INSERT INTO chfNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","De ya'i u ch'i tu c'äb täcä ni vaso. Cuanta u yälbi Dios que uc'adios u chi, u yäc'bi u yajcänt'anob y upetejob u mul uch'ijob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aj Jesús u yälbijob ca'da: ―Jindaba cä ch'ich'e une. U ye'e' cua' u xe u chen Dios por anela. Jini ch'ich'daba u xe tä ancäran tuba pa'säbintic u tanäjob q'uen a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Totojtoj cälbenetla, mach uni' xon cuch'en ni c'äb uva ixta jimba q'uin jini que cä xe cuch'en tä cha'num t'oc anela ni tzijib c'äb uva bajca u chen manda Dios tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cuanta u c'äyijob ump'e c'ay ta Dios bixijob tu pam jini tz'ic u c'aba' Olivos. ");
INSERT INTO chfNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","De ya'i aj Jesús u yälbijob ca'da: ―Apetela u xe tä ch'ocoman a pixanla jimba ac'äbda uc'a a xe a chänenla cua' acä xe tä cherbinte, uc'a tan ni jun ta Dios tz'ibiba u yäle' ca'da: “Cä xe cä tzämsen jini ajcänän oveja, y ni ovejajobba u xe u puclan uba”. ");
INSERT INTO chfNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero cuanta cuxponba, cä xe tä c'ote najtäcä tä Galilea, anelaba ji'pat. ");
INSERT INTO chfNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","De ya'i aj Pedro u yälbi ca'da: ―Mach u che si upete sujlecob tu pat, pero no'onba mach uxon tä sujtä täc pat. ");
INSERT INTO chfNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aj Jesús u yälbi: ―Totojtoj cälbenet: Jinchichba ac'äbda mach to u che uq'ue ajtze cha'petz' ane a xe a wäle' uxpetz' que mach a chon conoce. ");
INSERT INTO chfNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aj Pedro sujli u yäle' cha'num: ―Mach u che si c'änä chämicon nämte' t'oc ane, pero mach uxon cäle' que mach cä chet conoce. Ca' chich jini u yälijob täcä ni otrosjobba. ");
INSERT INTO chfNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","De ya'i c'otijob bajca u yälbinte cache' u c'aba' Getsemaníba, y aj Jesús u yälbi u yajcänt'anob ca'da: ―Chumi'la wida, no'onba ya cä xe cä chen c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","U bisi aj Pedro, aj Jacobo y aj Juan t'oc une. De ya'i cayi u na'tan bac'ät y u ch'ocoman u pixan. ");
INSERT INTO chfNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y u yälbijob ca'da: ―Mäx u ch'ocoman cä pixan uc'a cä na'tan cache' cä xe tä chämo. Colenla wida y ajniquetla p'ixi. ");
INSERT INTO chfNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","De ya'i aj Jesús bixi más pänte' tz'ita' y nocwäni tä cab. U täq'ui u c'atben Dios si u ch'e'icaba que mach äc'bintic jini tz'ibajtesia que u xe tä äc'binteba jimba hora jini. ");
INSERT INTO chfNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tan u c'änti'ya u yäle' ca'da: ―Cä Pap, aneba upete u ch'e' a chen. Japänon t'oc ni tz'ibajtesia que cä xe tä äc'binte. Pero mach co que utic ca' co no'on, sino que utic ca' chich a wo ane. ");
INSERT INTO chfNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","De ya'i bixi bajca an u yajcänt'anob y c'oti u chänen cache' mu' u wäyejob. U yälbi aj Pedro ca'da: ―Simón, ¿mu' a wäye? ¿Mach quira a c'äle ajniquet niump'e hora p'ixi? ");
INSERT INTO chfNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ajniquetla p'ixi jiq'uin, y chen c'änti'yala uc'a mach ajnic cua' u yäc'benet a säte'la t'oc Dios. A pixanlaba totoj yo chich u chen tu toja, pero a cuerpolaba mäx u säte'. ");
INSERT INTO chfNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","De ya'i bixi tä cha'num u chen c'änti'ya y tan u c'änti'ya u yäle' ca' chich u yäli najtäcäba. ");
INSERT INTO chfNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sujli tä cha'num bajca an u yajcänt'anob, y u chäni cache' mu' u wäyejob, uc'a tä' yo wäye u jutob. Ni ajcänt'anob mach u pojle cua' u yälbenob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","De ya'i sujli cha'num u yuxpetz'ib bajca anob y u yälbijob ca'da: ―¿Mu'to a wäyela y a ch'e' abala? An t'oc bada. Ac'oti hora tuba äc'cacon tu c'äb ajcherajtanäjob no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ch'oyenla jiq'uin y cola. Ya' u te, jini que u xe u yäq'ue'on tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ya' chich to an tä t'an aj Jesúsba jinq'uin c'oti aj Judas, untu de ni doce u yajcänt'anob. C'oti t'oc noj q'uenel gente t'oc u machit y u te' tu c'äb. Ni gente jiniba ajnojajob pale y machcatac u ye'e' ni ley taj Moisés y ajt'äbälajob ta caj u täsquijob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aj Judas, jini u yäq'ui tä c'äbä aj Jesúsba, u worin älbijob cua' jini u xe u chen tuba u ye'e' camba aj Jesús, u yälbijob ca'da: ―Jini a chänenla cä xe cä tz'utz'änba, jin une. Q'uechela, cächäla, y bisanla. ");
INSERT INTO chfNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jinq'uin c'oti, u natz'i aj Jesús, u yälbi ca'da: ―Maestro, Maestro. De ya'i u tz'utz'i. ");
INSERT INTO chfNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jinchichba rato jini u q'uechijob aj Jesús, u bisijob preso. ");
INSERT INTO chfNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Untu de ni ya'an t'oc aj Jesúsba u pa'si u machit, u chunjätz'bi u chiquin untu u yajpatan ni ajnoja ta palejob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","De ya'i aj Jesús u yälbi ni gente ca'da: ―¿Cua' uc'a atetla t'oc a machit y a te' tuba a bisanonla preso, ca' a wälä ajxuch'on? ");
INSERT INTO chfNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Upete q'uin ajnon bajca anetla tuba cä ye'e' u t'an Dios tama noj ch'u'ul otot, y mach bay a bisonla preso. Pero jindaba mu' u chen pasa tuba pasic toj ca' chich u yäle' ni jun ta Dios tz'ibiba. ");
INSERT INTO chfNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","De ya'i upete ni ajcänt'anob u yäctijob u juntuma aj Jesús y laj putz'ijob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Untu ch'oc ajlo' u tzäypätijob t'unu t'oc ump'e säsäc noc'. U q'uechijob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero jini ajlo' u japi uba, y u yäcti jini säsäc noc' tu c'äbob, y uneba putz'i sin noc'. ");
INSERT INTO chfNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","U bisijob aj Jesús bajca an ni ajnoja tuba palejob, y u woyli ubajob upete ni ajnojajob ta pale y ajt'äbälajob ta caj y jini machcatac u ye'e' ni ley taj Moisésba. ");
INSERT INTO chfNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Y aj Pedroba u tzäypäti nat nat t'oc unejob y c'oti ixta pan otot tuba ni ajnoja tuba palejob. Ya' chunwäni tu ch'ejpa ni ajcänänya ta noj ch'u'ul otot tuba u ch'ixän c'ac'. ");
INSERT INTO chfNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ni ajnojajob ta pale y upete ni nuc ajmandajob u sacänob cache'da u sube'ob aj Jesús tuba u yäq'ue'ob tä tzämsinte, pero mach u pojlejob cache'da. ");
INSERT INTO chfNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Q'uenob machcatac u yäle' jop'ojti' tuyac'o aj Jesús, pero mach tomp'e cua' u yäle'ob t'oc jini jop'ojti'. ");
INSERT INTO chfNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","De ya'i ajni machcatac wa'wäni u sube' t'oc jop'ojti', u yäle' ca'da: ");
INSERT INTO chfNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―No'on t'ocobba cubi t'ocob u yäle': “Cä xe cä jinesan ni noj ch'u'ul ototda que winic u chiba, y u yuxp'elib q'uin cä xe cä tz'osen otro noj ch'u'ul otot que mach jin winic u chiba”. ");
INSERT INTO chfNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ixta t'oc ni t'an jini täcä mach'an tomp'e u c'ajalinob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","De ya'i ni ajnoja ta pale wa'wäni tänxin ni gente, u yälbi aj Jesús ca'da: ―¿Cua' uc'a mach a p'alä niump'e cua'? ¿Mach quira a ubi cua' mu' u sube'etob t'oc? ");
INSERT INTO chfNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero aj Jesúsba coli ch'ijcab, y mach u p'ali niump'e cua'. Jini ajnoja tuba ni palejob sujli u c'atben ca'da: ―¿Ane quira ni aj Cristojet, Ajlo' ta Dios, jini ch'u'ul ayanba? ");
INSERT INTO chfNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aj Jesús u yäli: ―Jinon chich. Anela chich täcä a xe a chänenonla no'on que sutwänon de winicba cache' ya' chumcalon tu noj ni Dios an u poderba, y a xe a chänenonla täcä cache' cä xe tä te tä cielo tama ump'e bucla. ");
INSERT INTO chfNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","De ya'i ni ajnoja ta palejob u xet'i u buc de cräxle u yäli ca'da: ―¿Cua' tuba cä sacänla machca u sube'? ");
INSERT INTO chfNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anela chich a ubila t'oc a chiquinla cache' u chen uba ca' Dios. ¿Cache' a wäle'la ane? Upetejob u yäli cache' c'änä tzämsintic. ");
INSERT INTO chfNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","De ya'i u täq'ui u tubänob y u mäcben u jutob, u cune'ob, u yälbenob ca'da: ―¡Älä caxca une u cunet! Ni soldadojob u bon cunijob tu jut täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aj Pedroba ya'an emä tu pan otot. Jimba rato jini c'oti untu u jixpatan ni ajnoja ta palejob. ");
INSERT INTO chfNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jinq'uin u chäni cache' ya'an u ch'ixän c'ac' aj Pedro, tajwa'wäni u chämben u jut y u yälbi ca'da: ―Ane täcä ajnet nämte' t'oc jini aj Jesús u cab tä Nazaretba. ");
INSERT INTO chfNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aj Pedroba u yäli que mach. U yäli ca'da: ―Mach cä che conoce ni winic jini que mu' a wäle'ba. De ya'i pasi aj Pedro päti tu ti' otot. Jimba rato jini u chi uq'ue ajtze. ");
INSERT INTO chfNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ni ixpatan sujli u chämben u jut tä cha'num aj Pedro, y cayi u yälbenob ni machcatac ya'an ya'iba ca'da: ―Ni winicdaba es untu u lotob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aj Pedro sujli u yäle' cha'num que mach. Ji'pat tz'ita' jini machcatac ya'anob ya'iba u yälbijob tä cha'num aj Pedro ca'da: ―Totojtoj chich, ane täcä es untu de unejob uc'a a cab tä Galilea y a chen t'an ca' chich u chenob une. ");
INSERT INTO chfNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","De ya'i aj Pedro u täq'ui u yäle' cache' mach toj ixta u chen cräxt'an uc'a tz'ombintic u t'an. U yäle' ca'da: ―Mach cä che conoce jini winic que a wäle'laba. ");
INSERT INTO chfNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jinchichba rato jini u chi uq'ue ajtze u cha'petz'ib. De ya'i aj Pedro ti tu c'ajalin cache' aj Jesús u yälbi ca'da: “Mach to u che uq'ue ajtze cha'petz'ba, aneba a xe a wäle' que mach a chon conoce uxpetz'”. Jinq'uin ti tu c'ajalin jinda, cayi tä uq'ue. ");
INSERT INTO chfNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tu junch'äcnan ni ajnoja tuba palejob u motli ubajob tuba u ch'e' u c'ajalinob nämte'ob t'oc ajt'äbälajob ta caj y machcatac u ye'e' ni ley taj Moisésba, y che' chich täcä upete ajmandajob. Cächä u bisijob aj Jesús bajca an aj Pilato. ");
INSERT INTO chfNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aj Pilato u c'atbi ca'da: ―¿Ajnojalet quira tuba aj judíosob? Aj Jesús u p'ali: ―Jinon chich, ca' chich mu' a wäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ni ajnojajob tuba pale u bon sube'ob t'oc cua' chichca. ");
INSERT INTO chfNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","De ya'i aj Pilato sutwäni u yälben ca'da: ―¿Cua' uc'a mach a p'alä niump'e cua'? Iran cache' mäx q'uen cua' chichca mu' u sube'etjob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aj Jesúsba mach u p'ali ni tz'ita'. Jin uc'a aj Pilato mach yuwi cua' u xe u chen. ");
INSERT INTO chfNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aj Pilatoba nämä u chaje' untu preso tama q'uin ch'uje, cachichca une que ni gente u c'atän chajcac. ");
INSERT INTO chfNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ajni tä cárcel untu winic u c'aba' aj Barrabás, nämte' t'oc otrosjob que u bon chi tzämsajob tama ump'e buya. ");
INSERT INTO chfNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","De ya'i c'oti ni gente bajca an aj Pilato y u c'atbenob que u chen ca' chich nämä u chenba. ");
INSERT INTO chfNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aj Pilato u p'ali ca'da: ―¿A wola quira cä chaje' jini ajnoja tuba aj judíosob? ");
INSERT INTO chfNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Uc'a aj Pilatoba yuwi chich cache' ni ajnoja tuba palejob u bisbijob aj Jesús uc'a unejob mach yo u chänenob. ");
INSERT INTO chfNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero ni ajnojajob tuba paleba cayi u jobben u c'ajalinob ni gente y u yälbenob cache' mejor chajcac aj Barrabás. ");
INSERT INTO chfNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","De ya'i aj Pilato u c'atbijob ca'da: ―¿Cuaxca a wola cä chen t'oc jini a wälbenla cache' Ajnoja taj judíosobba? ");
INSERT INTO chfNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ni gente u p'alijob t'oc noj t'an: ―¡Baja tä cruz! ");
INSERT INTO chfNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aj Pilato u yäli: ―¿Cuaxca tanä u chi? Ni gente sujli u yäle' t'oc noj t'an tä cha'num: ―¡Baja tä cruz! ");
INSERT INTO chfNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","De ya'i aj Pilato uc'a mach u yoli cäräx'ac ni gente t'oc une, jin uc'a u chaji aj Barrabás. De ya'i u yäq'ui tä jätz'can aj Jesús y ji'pat u yäq'ui tä äc'can tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ni soldadojob u bisi aj Jesús tu pat palacio, y u motli ubajob q'uen soldadojob. ");
INSERT INTO chfNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","U xojbi u ic'puq'uen buc tuyac'o, y u yäc'bijob ump'e corona de jit'ib ch'ix tan u pam. ");
INSERT INTO chfNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","De ya'i u täq'ui u yäle'ob t'oc noj t'an ca'da: ―¡Cä ch'u'ul c'ajti'inet, ane ni Ajnojalet tuba aj judíosob! ");
INSERT INTO chfNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","U yäc'benob tan u pam t'oc untz'it te', u tubänob, u noctäjob tu pänte' tuba u susuc ch'u'ul c'ajti'in. ");
INSERT INTO chfNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cuanta u c'alin tze'tijobba, u pa'säbijob u ic'puq'uen buc tuyac'o y u yäc'bijob tuyac'o jini buqui tuba chichba. De ya'i u bisijob tuba u yäq'ue'ob tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Untu winic c'ote u chen tu yotot ya' ti tan pimi. Jini winic ya' u cab tä Cirene u c'aba' aj Simón, u pap aj Alejandro y aj Rufo. Jinq'uin numijob ya' jini, u cocoj äc'bijob u bisben u cruz aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","U bisijob aj Jesús bajca an ump'e lugar u c'aba' Gólgota. Jini t'an Gólgotaba u yäle' une cache' bajca u yajtä u bäcpam ajchäme. ");
INSERT INTO chfNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","U yäc'bijob vino u yuch'en xäbä t'oc mirra, pero aj Jesúsba mach u yuch'i. ");
INSERT INTO chfNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","De ya'i u bajijob tä cruz. Y ni soldadojob u yäläsijob u buc aj Jesús tuba u jiranob caxcatac une u xe u ch'e'. ");
INSERT INTO chfNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jinq'uin u yäq'uijob tä cruz aj Jesús, at'äbi q'uin une. ");
INSERT INTO chfNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jini u tz'ibi aj Pilato tuba u yäle' cua' uc'a tzämsintiba u yäle' ca'da: “Jinda Ajnoja taj judíosob”. ");
INSERT INTO chfNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","U yäq'uijob tä cruz täcä cha'tu ajxuch', untu tu noj y untu tu tz'ej. ");
INSERT INTO chfNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ca' jini pasi toj jini u yäle' ni t'an ta Dios tz'ibiba, ni u yäle' ca'daba: “Nämte' t'oc ajmalujlejob tzämsinti”. ");
INSERT INTO chfNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Machcatac u numejob ya'i u cäräx älbenob, u cherben u pamob, u yälbenob ca'da: ―¡Ane que a wäli a jinesan noj ch'u'ul otot y uxp'e q'uin a tz'osen tä cha'num! ");
INSERT INTO chfNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Japän aba jiq'uin, y jaquen bajca bajalet tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ni ajnoja ta palejob täcä y ni machcatac u ye'e' ni ley taj Moisés u bon tze'tanob täcä, y u maläc äle'ob ca'da: ―Otro u japijob. ¿Mach quira u che trebe u japän uba? ");
INSERT INTO chfNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si aj Cristojet, y si Ajnojalet tuba aj Israelobba, co cä chänen t'ocob jaquiquet bajca anet tä cruz. Ca' jiniba cä xe cä tz'ombenet t'ocob. Ixta jini que ya' bajajob nämte' t'oc tu cruzobba u cäräx älbenob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jinq'uin u ch'i tänxin q'uin yäli noj it'obni entero tu pancab, y jini it'obni jäläcni ixta ochiq'uin. ");
INSERT INTO chfNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jimba hora jini aj Jesús u chi noj t'an, u yäle' ca'da: ―Eloi, Eloi, ¿lama sabactani? ―ni t'andaba u yäle' ca'da: Cä Dios, cä Dios, ¿cua' uc'a a waläctanon? ");
INSERT INTO chfNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ni machcatac ya'an ya'iba u yubijob cua' u yäli, y u yälijob ca'da: ―Ubinla, mu' u joq'ue' aj Elías, ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","De ya'i untu de unejob bixi t'oc ancäre u ch'e' ump'e tz'u'i' ja' y u maji tan pajäl vino mäx pajba, u yäq'ui tuyac'o untz'it te', de ya'i u t'äbsi tu ti' aj Jesús uc'a u tz'u'än jini ja', u yäle' ca'da: ―Äctan quiranla si u te aj Elías u jäcsen. ");
INSERT INTO chfNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","De ya'i aj Jesús u chi ump'e noj gran awät y chämi. ");
INSERT INTO chfNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ni noj noc' tama noj ch'u'ul ototba tajqui desde isqui ixta emä. ");
INSERT INTO chfNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ni ajnoja tuba soldado taj romanojobba ya' wa'ca bajca an aj Jesús u chänen. Jinq'uin u chäni cache' u chi noj awät y chämiba, u yäli ca'da: ―Totojtoj chich, ni winicda u Yajlo' chich Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ajni täcä nanat ya' jini u chänen cha'tu uxtu ixictac. Tama ni ixictacob jini ya' ajni ix María Magdalena, ix María u na' aj José y u na' aj Jacobo, ajch'och'ocaba, y ajni täcä ix Salomé. ");
INSERT INTO chfNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ni ixictacobdaba numi nämte'ob t'oc aj Jesús y u täclijob jinq'uin ajni tä Galilea. Ajni täcä ya' jini otros ixictacob que c'otijob tä Jerusalén nämte' t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jinq'uin pomi q'uin jimba q'uin jiniba u tuse' ubajob tuba u q'uin ch'ämbäji päscab. ");
INSERT INTO chfNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","C'oti aj José ya' u cab tä Arimatea. Uneba es untu de ni mero ajmandajob tuba ni caj. Une täcä u pijnan julic ni Dios que u xe u chen mandaba. Sin niump'e bac'ät ochi bajca an aj Pilato u c'atben u cuerpo c'äsi' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Aj Pilato tajch'icwäni u jut u yubin cache' san chämi. U joq'ui ni ajnoja tuba soldadojob tuba u c'atben si san chich achämi. ");
INSERT INTO chfNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jinq'uin ni ajnoja ta soldadojob u yäli cache' achämiba, aj Pilato u yäc'bi chich jini cuerpo aj José. ");
INSERT INTO chfNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","De ya'i aj José u mäni ump'e säsäc noc' de mejorba, u jäcsi u cuerpo aj Jesús, u tz'oti t'oc jini noc'. De ya'i u yäq'ui tama ump'e u mucliba ajchäme que uti tu näc' tz'ic, y u mäcbi u ti' ni mucliba t'oc ump'e ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ix María Magdalena, ix María u na' aj José u chänijob cada mujqui. ");
INSERT INTO chfNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jinq'uin numi ni q'uin ta ch'ämbäji, ix María Magdalena, ix María u na' aj Jacobo y ix Salomé u mänijob jätz'äcnib tuba xic u yäc'benob tu cuerpo aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ic'sapanto ni najtäcäl q'uin tuba semana bixijob bajca an ni mucliba. Pase u chen q'uin c'otijob. ");
INSERT INTO chfNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tä bij u maläc äle'ob: ―¿Caxca une u xe u pa'sen ni ji'tun tu ti' mucliba? ");
INSERT INTO chfNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero jinq'uin c'otijob u chänenba, ni noj ji'tun mach ni' an tu ti' mucliba. Apa'sinti ya'i. ");
INSERT INTO chfNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ochijob tama ni mucliba y u chänijob cache' ya' chumca untu ch'oc ajlo' tu noj bajca mujqui ni aj Jesús, t'oc u noj tamäl säsäc buc tuyac'o. Ni ixictac bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ni ch'oc ajlo' u yälbijob ca'da: ―Mach bäc'taquetla. Anelaba a sacän aj Jesús ni u cab tä Nazaret, jini que tzämsinti tä cruzba. Mach ni' an wida une. San cuxpi. Chänenla bajca ajni u cuerpo. ");
INSERT INTO chfNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cuxla älbenla u yajcänt'anob y aj Pedro cache' uneba u xe tä c'ote najtäcä de anela tä Galilea. Ya'i a xe a chänenla, ca' chich u worin älbetlaba. ");
INSERT INTO chfNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","De ya'i ni ixictacob jini pasijob tä putz'e bajca an ni mucliba, uc'a ixta chicchicnajob de bac'ät. Mach u yälbijob niump'e cua' niuntu uc'a bäc'tajob u tz'aycun. ");
INSERT INTO chfNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ji'pat que cuxpi aj Jesús, tu junch'äcnan ni najtäcäl q'uin ta semana, u ye'i uba najtäcä bajca an ix María Magdalena, jini ix María que u pa'säbi siete tzuc pixan tuyac'oba. ");
INSERT INTO chfNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jinq'uin u chäni ix María, bixi u yälben u yajcänt'anob aj Jesús. Ni ajcänt'anobba ya'anob tä uq'ue uc'a tä' tristejob. ");
INSERT INTO chfNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jinq'uin u yubijob cache' aj Jesús cuxu ayan, y cache' ix María u chäniba, mach u tz'onijob. ");
INSERT INTO chfNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ji'pat de jinda aj Jesús u ye'i uba tä cha'num yänä u jut bajca u bixe cha'tu tä bij. ");
INSERT INTO chfNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Unejob bixi u yälbenob ni otros ajcänt'anob, pero mach u tz'ombijob täcä. ");
INSERT INTO chfNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ji'pat aj Jesús u ye'i uba bajca an ni once u yajcänt'anob, jinq'uin unejob ya' chumcajob tä mesa tä c'uxnan. U q'uejpijob uc'a mach u totoj tz'onäjob y mäx tzätz u pixanob, y uc'a mach u tz'ombijob täcä jini machcatac u chäni cache' cuxpiba. ");
INSERT INTO chfNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","De ya'i u yälbijob ca'da: ―Cuxla cachichcada tu pancab y tz'aycäbenla u t'an Dios upete a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Machca chichca u tz'onän y c'ablacba, u xe u japän uba. Y machca mach u tz'onän mach uxin u japän uba. ");
INSERT INTO chfNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jintacda u xe u chen machcatac u tz'onän: T'oc cä c'aba' u xe u pa'sen tzuc pixan tuyac'o machca u cänäntan, y u xe u chenob yänäl t'an. ");
INSERT INTO chfNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","U xe u q'ueche' ni chan t'oc u c'äb sin que u c'uxe'. Si u yuch'en cua' chichca veneno mach uxin u cherben niump'e cua'. Che' chich täcä u xe u yäq'ue' u c'äbob tu pam ni c'ol winic y ni c'ol winic u xe u pojlen uba. ");
INSERT INTO chfNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cuanta u tzupsi u chen t'anob t'oc, ni Cajnojala aj Jesús bisinti tä cielo, y chunwäni tu noj Dios. ");
INSERT INTO chfNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ni ajcänt'anob bixijob u tz'aycun u t'an Dios cachichcada. Cajnojala chich u täclenob y u yäq'ue' que tz'onintic jini t'an uc'a ni cua' chichca u chenob t'oc poderba y jini u chenob que mach u che trebe u chen niuntu winicba. Ca' chich jini uti.");
INSERT INTO chfNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cä yajben lot, Teófilo: Q'uen ayan machcatac u tz'ibijob tä jun cua'tac u totoj chi pasa bajca anonla tan cä cabla. ");
INSERT INTO chfNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","U tz'ibijob upete cua'tac ajni, ca' chich u tz'aycäbon t'ocob ni winicob que desde chäcäl najtäcä u chänijob cua'tac u chi pasaba. Jini winicob que u chänijobba äc'binti u tz'aycunob ni t'an tuba aj Jesucristo. ");
INSERT INTO chfNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Cäli cache' utz täcä si no'on cä laj tz'ibbenet tä jun upete, uc'a no'onba najtäcä cä c'alin cäni tz'äcä tz'äcä cua'tac u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Cä chi ca' jini uc'a u ch'e' a wina'tan aneba cache' toj cua'tac a'utet tä tz'aycäbinte de lo que u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ajni untu rey u c'aba' aj Herodes ya'i tama ni noj cab tä Judea. Ajni täcä jinq'uin untu pale tuba aj judíosob u c'aba' aj Zacarías. Nämte' u chen patan t'oc seq'uen u bajnimajob ni palejob que u ch'ämbi u c'aba' aj Abíasba, uc'a une täcä es untu de unejob. Jit'oc aj Zacaríasba u c'aba' ix Elisabet, y uneba es untu de u natil ch'ocob ni pale aj Aarón. ");
INSERT INTO chfNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","U cha'tumajob u chenob tu toja tu jut Dios. U tz'ombenob u t'an cä Yumla Dios. U chenob upete lo que u yäq'ui tä ute sin que u säte'ob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mach u cänäntijob niuntu u ch'ocob uc'a ix Elisabet mach u ch'ä u mätan u tz'isa, y u cha'tuma anoxibijob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ump'e q'uin ya'an aj Zacarías tä patan t'oc u lotob tama ni noj ch'u'ul otot tuba aj judíosob, uc'a ac'oti q'uin u chen patanob seq'uen u bajnimajob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ni palejob nämäjob u pa'sen suerte tuba u jiranob caxca une u xe tä oche tama ni noj otot tuba cä Yumla Dios bajca ch'u'ul ayanba uc'a u pule' ni pom, y jinchichba q'uin jini u chi toca aj Zacarías ochic. ");
INSERT INTO chfNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jimba hora que mu' u pulcan ni pomba ya'an upete ni noj q'uenel gente päti u chen c'änti'yajob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tajtzäc tutz'i untu ángelo ta Dios bajca an aj Zacarías u juntuma. C'oti tä wa'tä tu noj tu ch'ejpa ni pulbenib. ");
INSERT INTO chfNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jinq'uin aj Zacarías u chäni ni ángelo jini, ti tu c'ajalin cua' ti jini y c'ac'a' bäc'ti. ");
INSERT INTO chfNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","De ya'i ni ángelo u yälbi ca'da: ―Zacarías, mach bäc'taquet; uc'a Dios u yubi na c'änti'ya, y a wit'oc ix Elisabet u xe u päncäbesan untu a wajlo'. Aj Juan a xe a wäc'ben u c'aba'. ");
INSERT INTO chfNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ane u xe tä c'ac'a' ch'a'alan ajin y q'uenob u xe tä ch'a'alan ujinob täcä tu xe tä päncäban; ");
INSERT INTO chfNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","uc'a na wajlo' jiniba Dios u xe u chänen cache' tu toja chich u chen. Mach uxin u yuch'en vino ni chij. Desde jinq'uin mu'to u päncäbanba ya' chich c'ac'a' an Ch'u'ul Pixan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Uneba u xe u yäc'benob q'uen de u natil ch'ocob aj Israel sutwänicob u tz'ombenob tä cha'num u Yumob, jini Dios tubajobba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aj Juan u xe tä c'ote najtäcä tuba u tz'aycun ni Ajnoja que ya' u te tu patba. U xe tä c'ote u c'ajalin ca' taj Elías, ni ajt'an ta Diosba. U xe u chen t'an t'oc poder täcä ca' chich u chi aj Elías. Ca' jini u xe u yäc'ben ajnic tomp'e u c'ajalinob machcatac u chen buya t'oc u ch'ocob, y jini machcatac mach u tz'onäjobba u xe u yäc'ben sutwänic u c'ajalin ca' chich ayan u c'ajalin machcatac u chen utzba. Ca' jini u xe u to'esan u c'ajalinob ni gente tuba u c'alin sapänob u Yajnojajob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","De ya'i aj Zacarías u chi t'an u yälben ni ángelo ca'da: ―¿Cache'da cä xe cuwina'tan si toj ni jini a wäle'ba? Uc'a no'onba anoxibon y quit'oc täcä ach'upimi. ");
INSERT INTO chfNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ni ángelo u yälbi ca'da: ―No'onba aj Gabrielon. Paq'uin ayanon tu pänte' Dios tuba cä cherben lo que yo Uneba. No'on täsquinte acä chi cä lotänet tuba cä'benet ni razónda que u xe u yäc'benet ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero badaba, a xe tä colan a'uma', mach uni' xet a chen trebe a chen t'an ixta que mach c'otic q'uin tuba utic ni cälbetba, uc'a mach a tz'ombon cä t'an. U xe chich tä ute lo que cälbet jinq'uin u c'ote q'uin ta utic. ");
INSERT INTO chfNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ni gentejob ya'an u pitänob aj Zacarías. Uneba bon jäläcni tama ni ch'u'ul otot y ni gente u ch'e' u c'ajalin cua' uc'a wäre mach to pas. ");
INSERT INTO chfNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jinq'uin pasi mach u ni' ch'ä u chen t'an tuba u pecänob. U yäc'bi uba cuentajob que Dios u jäbtesbi u jut tuba u chänen ump'e cosa tama ni noj ch'u'ul otot. U cherben u c'äb u lotänob, pero mach u ni' ch'ä u chen t'an. ");
INSERT INTO chfNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jinq'uin c'oti q'uin u tzupsen u patan, bixi tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ji'pat de ni q'uinob jini ix Elisabet, jit'ocba, u mäti u tz'isa. De ya'i coli tan yotot cinco mes, mach uni' pas bajca. ");
INSERT INTO chfNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ix Elisabet u yäli tu c'ajalin ca'da: “Cajnoja u cherbon ca'da, uc'a badaba u ch'ämbon yajin tuba u pa'säbenon ni quisinle cä cänäntan tama ni cajda”. ");
INSERT INTO chfNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tz'ita' yo tuba c'otic seis mesba, u täsqui Dios untu ángelo u c'aba' aj Gabriel xic ump'e caj tama ni noj cab tä Galilea u c'aba' tä Nazaret. ");
INSERT INTO chfNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","U täsqui u lotän untu telom c'ätä an uc'a untu winic u c'aba' aj José. Aj José es untu de u natil ch'ocob ni rey aj David, y ni telomba u c'aba' ix María. ");
INSERT INTO chfNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ni ángelo ochi bajca ayan ix María u yälben ca'da: ―¡Tanet, mäx ti'i u c'ajalin Dios t'oc ane! Ane ayanet t'oc cä Yumla y une chich u xe u täclenet. Más ch'a'aljin a xe a cänäntan que otros ixictacob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jinq'uin u chäni c'äsbäc'ti uc'a u yubin cua' u yäli, y u ch'i u c'ajalin cua' uc'a wäreca u lotän ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","De ya'i ni ángelo u yälbi ca'da: ―María, mach bäc'taquet, uc'a mäx ti'i u c'ajalin Dios t'oc ane. ");
INSERT INTO chfNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ubixto, a xe a mätan a tz'isa, y a xe a päncäbesan untu a wajlo' y a xe a wäc'ben u c'aba' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Uneba u xe de Ajnoja uc'a une chich u Yajlo' ni Dios, jini más Ajnoja que ayanba. Cä Yumla Dios u xe u yäc'ben ajnic de ajmanda ca' chich u najtäcäl noxi'pap oni, jini rey u c'aba' aj Davidba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Une u xe tä nonoj colan u chen manda upete ni u noj q'uenel natil ch'ocob aj Jacob. Mach uxin tä xupo nunca u manda uneba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","De ya'i ix María u yälbi ni ángelo ca'da: ―¿Cache' ti da u xe tä ute cua' a wäle'ba? Uc'a no'onba mach'an quit'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","U p'albi ni ángelo ca'da: ―Ni Ch'u'ul Pixan u xe tä jaque ta'wac'o, y u poder ni Dios más Ajnojaba u xe u yäc'benet a mätan a tz'isa. Jin uc'a ni Ch'u'ul Ch'oc a xe a päncäbesanba, u Yajlo' chich Dios une. ");
INSERT INTO chfNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ubixto, a prima ix Elisabet täcä u mäti untu yajlo' tu ch'upimle. Ni ixic jiniba u yälcan que mach u ch'ä u mätan u tz'isa, y badaba u cänäntan seis mes c'ojo t'oc u bijch'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Uc'a Diosba u ch'e' u chen upete cua' chichca. ");
INSERT INTO chfNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","De ya'i u yäli ix María ca'da: ―No'onba ixpatanon chich tuba cä Yumla. Tan u chen Dios t'oc no'on ca' a wäle'ba. De ya'i ni ángelo pasi ca'an une y bixi. ");
INSERT INTO chfNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jinchichba q'uinob jini ch'oyi ix María, y seb bixi ump'e caj tä isquil cab ya'i tama ni noj cab tä Judea. ");
INSERT INTO chfNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ya'i ochi tan yotot aj Zacarías u yäc'ben u c'aba' Dios ix Elisabet. ");
INSERT INTO chfNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jinq'uin ix Elisabet u yubi u c'aba' Dios que c'oti u yäc'ben ix Maríaba, u niqui uba ni ch'oc tuyac'o ix Elisabet, y uneba c'ac'a' ochi Ch'u'ul Pixan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ix Elisabet u chi noj t'an u yäle' ca'da: ―Ane Dios u yaquet tuba ajnic más a ch'a'aljin que otros ixictacob, y Dios u yaqui täcä ni a Wajlo' a xe a päncäbesanba y u ch'u'ul chi. ");
INSERT INTO chfNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Caxcajon no'onba tuba tiquet a chänenon, ane que a xe de u na' Cajnoja? ");
INSERT INTO chfNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jinq'uin cubi cache' a wäc'benon u c'aba' Dios, tajtzäc u niqui uba ni ch'oc t'oc ch'a'aljin täjcac'o. ");
INSERT INTO chfNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ch'a'a ajin aneba uc'a a tz'oni cache' u xe tä pase toj chich lo que cä Yumla u täsquet tä älbinte. ");
INSERT INTO chfNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","De ya'i ix María u yäli ca'da: Tan cä pixan cä c'alin ben u c'aba' Dios uc'a lo que u cherbon. ");
INSERT INTO chfNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ni Dios Cajjäpomba, jin une u yäc'ben ch'a'alac ujin cä pixan, ");
INSERT INTO chfNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","uc'a une u ch'ämbon yajin, no'on que ixpatanon tubaba que mach jin cua'on une. Desde badaba upete ajji'pät ch'ije u xe u yäle'ob cache' mäx q'uen cä ch'a'aljin, ");
INSERT INTO chfNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","uc'a Dios, jini tä' q'uen u poderba, machtajda u chi por no'on. Ch'u'ul ayan u c'aba' uneba uc'a mach'an niump'e u tanä. ");
INSERT INTO chfNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Upete machcatac mach yo u säte' t'oc Diosba, une chich u ch'ämbenob yajin. Che' chich u chi oni y che' chich u chen bada. ");
INSERT INTO chfNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ca' untu winic u ye'e' u muc' t'oc u c'äbba, ca' jini Dios u ye'i u poder. Y ca' untu winic u puc'jule' cua' chichca mach utzba, ca' jini Dios u yäc'bi u puclan ubajob jini machcatac u yäle' tan u c'ajalinob cache' q'uen u c'ajalinobba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dios u pa'säbijob u poder nuc ajnojajob y u yäc'bijob u poder machcatac ch'oc u pixanob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Machca jitz'o u chen c'änä äc'bintic cua' u c'uxe' ixta que c'alin na'ac. Ca' chich jini täcä machcatac que tä' yo que Dios u täclenob, Dios u c'alin täclijob chich. Machca q'uen u taq'uin mach ni' c'änä uc'a äc'bintic más. Ca' chich jini täcä machcatac u yäle' tu c'ajalinob que mach c'änä uc'a u täclen Dios, Dios chich mach u yäc'bijob niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Dios u täcli aj Israelob, ni machcatac u tz'omben u t'anba. Dios u c'ajti'in cache' une u worin älbi cä najtäcäl noxi'papla que une u xe u ch'ämbenob yajin. U yälbijob que une u xe u paq'uin ch'ämben yajin aj Abraham y upete u natil ch'ocob. Ca' jini u yäli ix María. ");
INSERT INTO chfNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ix María coli ya'i tu yotot ix Elisabet ca' ta uxp'e mes y de ya'i bixi tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","C'oti q'uin tä c'ojpan ix Elisabet, y u päncäbesi untu yoc ajlo'. ");
INSERT INTO chfNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","U yajnätz'älajob y u familiajob u yubijob cache' Dios u c'ac'a' ch'ämbi yajin ix Elisabet y ch'a'ali ujinob t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jinq'uin tz'äcti ocho día, c'otijob u yäq'ue' ni ch'oc tä äc'binte ni seña tu cuerpo, jini u c'aba' circuncisiónba. De ya'i u yäli u yäc'benob u c'aba' u pap, aj Zacarías. ");
INSERT INTO chfNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero u na' u yäli que mach. Aj Juan u xe u c'aba'. ");
INSERT INTO chfNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Unejob u yälbi ca'da: ―¿Cua' uc'a? Mach'an niuntu a familia u c'aba' ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","De ya'i u cherbi u c'äbob tuba u c'atben u pap cache'da yo uneba que xic u c'aba'. ");
INSERT INTO chfNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aj Zacarías u chi ump'e seña tuba u c'atän jun, y u tz'ibi ca'da: “Aj Juan u c'aba'”. De ya'i upete tajch'icwäni u jutob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jinchichba rato u jäbi uba u t'an y u täq'ui u nicän uba yac' y u chi t'an u ch'u'ul c'ajti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Upete u yajnätz'älajob c'ac'a' bäc'tijob, y tama ni noj cab tä Judea cachichcada tä isquil cab u tz'ayquinte upete cua'tac u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Upete machcatac u laj ubijob cua'tac atz'ayquinti u muque' tan u pixanob. U maläc älijob ca'da: ―¿Caba winic wäreca u xe ni yoc ajlo' jini? Uc'a Dios ayan t'oc ni yoc ajlo' jini u täclen t'oc u poder. ");
INSERT INTO chfNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aj Zacarías, u pap ni yoc ajlo'ba, c'ac'a' ajni Ch'u'ul Pixan tuyac'o y u chi t'an ca' untu ajt'an ta Dios, u yäle' ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ch'u'ul ajnic cä Yumla, ni Dios tuba aj Israelobba, uc'a ati u jiranob u gente y u japänob. ");
INSERT INTO chfNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Une u yäc'bonla untu Ajjäpom mäx q'uen u poderba, que es tuba u natil familiajob ni rey aj David, jini que ajni de u yajpatan Diosba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Upete ni jiniba u yäc'bi Dios u yäle' u ch'u'ul ajt'anob, ni ajnijob oniba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","U yälijob cache' ni Ajjäpom jini u xe u japänonla t'oc machcatac u cräxna'tanonla y tu c'äb jini machcatac mach yo u chänenonla. ");
INSERT INTO chfNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Dios u xe u chen ca' jini uc'a u ch'ämben yajinob cä najtäcäl noxi'papla, uc'a che' chich u worin älbijob que u xe u chen. U xe u chen ca' jini täcä uc'a u c'ajti'in ni ch'u'ul t'an u chiba, jini t'an que u totoj älbi cä papla aj Abraham que u xe u chenba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Dios u yälbi aj Abraham que najtäcä u xe u pa'senonla tu c'äb machcatac u cräxna'tanonla. De ya'i u ch'e' cä cherbenla Dios lo que yo cherbintic sin que cä bäc'tanla niump'e cua', ");
INSERT INTO chfNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y u ch'e' cä ch'u'ul c'ajti'inla Dios y cä chenla tu toja tu jut ixta que mach chämiconla. ");
INSERT INTO chfNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Che' chich täcä aneba, cä ch'oc, a xe de ajt'anet tuba Dios, ni más Ajnoja que ayanba, uc'a ane a xe tä c'ote najtäcä de Cajnojala tuba a wäc'ben u to'esan u c'ajalinob ni gentejob, uc'a u sapänob ni Cajnojala tu xe tä teba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ane a xe a ye'benon t'ocob cache' u ch'e' utic perdona cä tanäla tuba cä japän cäbala, no'on que u yaconla Diosba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Uc'a Dios mäx tä' u ch'ämbenonla yajin, u xe u täscäbenonla untu aj Ajtä tä cielo tuba u täclenonla. Uneba u c'ote t'oc ca' a wälä ump'e noj junch'äcni tuba u chictäben u biji untu tan it'obni. Ca' jini u xe u ye'benonla cua' c'änä cä chenla tuba c'oticonla tä cielo täc xe tä chämola. U xe u ye'benonla cache'da u ch'e' ajnic sis u c'ajalin Dios t'oc no'onla. Jinda tzäcä ni t'an u yäli aj Zacaríasba. ");
INSERT INTO chfNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","De ya'i ni yoc ajlo' jini ch'iji y c'ac'a' q'ue'ni u c'ajalin. Cuxli bajca mach cuxu niuntu ixta que mach c'otic q'uin tuba u ye'e' uba tama ni gente tä Israel. ");
INSERT INTO chfNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jimba q'uinob jini ni rey u c'aba' aj Augusto César u yäq'ui tä ute ump'e ley que upete ni gente tä cabil cab c'änä xic u yäq'ue' tä tz'ibinte u c'aba'job. ");
INSERT INTO chfNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A'uti ni najtäcäl censo jiniba jinq'uin ajni aj Cirenio de gobierno tä Siria. ");
INSERT INTO chfNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","De ya'i upetejob bixijob u yäq'ue' tä tz'ibinte u c'aba'job bajcatac ayan u cäjijob. ");
INSERT INTO chfNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aj José täcä pasi tä Nazaret tama ni noj cab tä Galilea y bixi tu cäji aj David u c'aba' tä Belén, ya'i tä isquil cab tama ni noj cab tä Judea. Bixi ya'i uc'a aj José es untu u natil ch'oc ni rey aj David. ");
INSERT INTO chfNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bixi nämte' t'oc ix María, c'ätä an uc'a uneba, tuba u yäq'ue' tä tz'ibinte u c'aba'job. Ix Maríaba c'ojo t'oc u bijch'oc une. ");
INSERT INTO chfNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jinq'uin ya'anob ya'iba c'oti q'uin tä c'ojpan t'oc u tz'isa. ");
INSERT INTO chfNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","U päncäbesi u yäxch'oc, untu ajlo'. De ya'i u tz'oti u na' t'oc ump'e welom noc', y u ch'a'atz'i tama bajca u c'uxnan beq'uet, uc'a mach ni' ajni lugar tama otot tuba u chen posajob. ");
INSERT INTO chfNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nätz'ä t'oc ni caj jini ya'anob ajcänän oveja u wäybetanob u yanima bajca tomca tä wäye ac'äb. ");
INSERT INTO chfNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tajtzäc untu ángelo tuba cä Yumla Dios tutz'i bajca anob, y u pitzilan Dios u chicti bajca anob ca' a wälä ump'e junch'äcni, y c'ac'a' bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","De ya'i ni ángelo jini u yälbijob ca'da: ―Mach bäc'taquetla uc'a aton cälbenetla ump'e t'an cache' noj gran ch'a'aljin u xe tä äc'bintejob upete a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Uc'a sami apäncäbi tu cäji aj David untu Ajjäpom ta'ala. Une ni Cristo, jini u yaqui Dios tuba Ajnojaba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Uc'a a wina'tanla que toj ni mu' cälbenetlaba, a xe a pojlenla untu ch'oc tz'oto t'oc ump'e welom noc' ya' ch'a'ca tama bajca u c'uxnan beq'uet. ");
INSERT INTO chfNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","De ya'i tajtzäc ajni nämte' t'oc ni ángelo ta Dios jiniba q'uen a'ajtäjob tä cielo u ch'u'ul c'äyben u c'aba' Dios u yäle'ob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cä ch'u'ul c'ajti'inla Dios ya'an isqui tä cieloba; tu pancabba u xe tä ajtä sis u c'ajalinob ni winicob que Dios tä' u yajna'tan! ");
INSERT INTO chfNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jinq'uin ni ángelojob pasi bajca anob bixijob tä cielo, ni ajcänän ovejajob u maläc älijob ca'da: ―Cola bada tä Belén cä chänenla jini u chi pasaba, ca' chich cä Yumla Dios u täscäbon tä älbintela. ");
INSERT INTO chfNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","De ya'i seb bixijob y u pojlijob ix María y aj José. Ya'an ya'i täcä ni ch'oc ya' ch'a'ca tama bajca u c'uxnan beq'uet. ");
INSERT INTO chfNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jinq'uin u chänijob ni ch'oc u tz'ayquijob cua'tac älbintijob tuba ni ch'oc jini. ");
INSERT INTO chfNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Upete machcatac u yubijob cua'tac u yäle'ob ni ajcänän ovejajob, tajch'icwäni u jut u yubinob. ");
INSERT INTO chfNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ix Maríaba u laj äq'ui tu pixan upete ni t'an u yubiba, y u paq'uin c'ajti'in. ");
INSERT INTO chfNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","De ya'i ni ajcänän ovejajob sutwänijob bajca an u ovejajob u ch'u'ul c'ajti'inob Dios y u c'äybenob u c'aba' Dios uc'a upete ni u yubijob, upete ni u chänijob. Pasi toj ca' chich älbintijob. ");
INSERT INTO chfNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jinq'uin tz'äcti ocho día u yäq'uijob ni ch'oc tä äc'binte ni seña tu cuerpo, jini u c'aba' circuncisiónba. U yäc'bijob u c'aba' jini ch'oc, aj Jesús. Jimba c'aba' jini u yäc'bi ni ángelo antes que u mätan tuyac'o u na'. ");
INSERT INTO chfNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jinq'uin tz'äcti q'uin tuba u chenob ca' chich u yäq'ui tä ute aj Moisés tama ni jun que u tz'ibiba, u bisijob ni ch'oc tä Jerusalén tuba u yäc'benob tu c'äb cä Yumla Dios ni ch'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","U chijob ca' jini uc'a tz'ibi ayan tama ni ley tuba cä Yumla ca'daba: “Upete ajlo'ilba yäx ch'ocba y upete u yäx al animajob ajlo'ba, c'änä äc'bintic tu c'äb cä Yumla Dios”. ");
INSERT INTO chfNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bixijob tä Jerusalén täcä tuba u subben Dios ni matän ca' chich ni ley taj Moisés u yäle' uticba. Ni ley jini u yäle' que subbintic cha'tu ixsäcpäcä, o si mach, cha'tu ixpaloma. ");
INSERT INTO chfNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ya' cuxli tä Jerusalén untu winic jinq'uin u c'aba' aj Simeón. Ni winic jiniba u chen tu toja y mäx u ch'u'ul c'ajti'in Dios. Une u c'alin pitän julic ni machca u yaqui Dios tuba u japän aj Israelobba, y ni Ch'u'ul Pixan ya'an t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ni Ch'u'ul Pixan u yäc'bi u wina'tan que une mach ucham antes de u chänen ni Cristo, jini u yaqui cä Yumla Dios tuba ajnic de Ajnojaba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","De ya'i aj Simeón bixi, ochi tama ni noj ch'u'ul otot tuba aj judíosob, uc'a ni Ch'u'ul Pixan u yäc'bi u chen ca' jini. De ya'i aj José y ix María u c'osijob ni ch'oc aj Jesús tama ni noj ch'u'ul otot jini tuba u subän ni ch'oc tu c'äb Dios ca' chich ni ley u yäq'ue' tä ute. ");
INSERT INTO chfNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","De ya'i aj Simeón u ch'ämbi tu c'äb ix María ni ch'oc tuba u meq'ue', y u ch'u'ul c'ajti'i Dios u yäle' ca'daba: ");
INSERT INTO chfNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Bada Cajnoja, no'on que a wajpatanonba, u ch'e' chämicon t'oc ch'a'aljin uc'a pasi toj lo que a wäliba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Uc'a bada acä chäni t'oc cä jut machca u xe u japänon t'ocob, ");
INSERT INTO chfNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","jin a wäq'ui tuba u chänenob upete a'ajtäjob pancabba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uneba u c'ote ca' ump'e junch'äcni tuba u ye'benob ni u toja ni gente que mach jin aj Israelob, y tuba ajnic olojob tä chäninte ni gente ta'aba, ni aj Israelobba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aj José y u na' ni ch'oc tajch'icwäni u jutob jinq'uin u yubijob cua'tac u yälcan de ni ch'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","De ya'i aj Simeón u c'atbi Dios que ajnic u yutzijob y u yälbi ix María, jini u na' aj Jesúsba, ca'da: ―Ubixto, ni ch'ocdaba Dios u yäq'ui tuba säticob q'uen gente tä Israel, uc'a tu xe u chänenob mach uxin u sapänob. Q'uen u xe u japän ubajob täcä, uc'a u xe u sapänob une. ");
INSERT INTO chfNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ca' jini u xe tä chectan cua'tac ayan tan u c'ajalinob q'uen ni gentejob. Y aneba täcä, María, u xe tä c'ac'a' ch'ocoman a pixan. Es ca' a wälä u c'uxcan u xeq'uita untz'it turutz'ni' machit que u xeq'ue' untu ixta tunxe u numeba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ajni ya' jini täcä ix Ana, untu ixt'an ta Dios. Uneba jixic ch'oc c'äsi' aj Fanuel de u familiajob aj Aser. Uneba ac'ac'a' ch'upimi. ");
INSERT INTO chfNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Loto ajni oni t'oc jit'oc u chi vida t'oc siete años namás, y chämi jit'oc. Coli neba'. Badaba u cänäntan ochenta y cuatro años. Mach u tz'eji uba tä noj ch'u'ul otot tuba aj judíosob. T'oc q'uin y t'oc ac'äb u c'ajti'in Dios y u chen c'änti'ya sin buc'a. ");
INSERT INTO chfNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jinchichba rato c'oti ix Ana bajca anob u yäc'ben u c'aba' Dios. De ya'i u täq'ui u chen t'an t'oc upete a'ajtäjob tä Jerusalén, jini machcatac u pijnanjob c'otic q'uin tuba japinticobba. Une u tz'aycäbenob cache'da u xe ni ch'oc jini. ");
INSERT INTO chfNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jinq'uin u tzupsi u chenob t'oc ni ch'oc upete cua'tac ni ley tuba cä Yumla u yäle' uticba, sutwänijob tu cäji tä Nazaret tama ni noj cab tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ch'iji ni ch'oc y q'ue'ni u muc' y q'ue'ni u c'ajalin. Mäx utz u c'ajalin Dios t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","U papjobba nämäjob xicob cada año tä Jerusalén tuba u numsenob ni q'uin ch'uje ta noj paxcu', jini q'uin ch'uje tuba aj judíosobba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jinq'uin aj Jesús u tz'äctesi doce añoba bixijob tä q'uin ch'uje tä Jerusalén ca' chich nämä u chenob. ");
INSERT INTO chfNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jinq'uin numi ni q'uin ch'uje jini, sujtä u chenob tu yotot, y aj Jesúsba coli tä Jerusalén, pero aj José y ix María mach yuwijob si coli ya'i. ");
INSERT INTO chfNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Unejob u yäli tan u c'ajalinob que aj Jesús ya' u te t'oc ni gente, y u chijob entero ump'e q'uin tä xämba. De ya'i u täq'uijob u sacänob t'oc u familiajob y t'oc machcatac u chen conoceba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jinq'uin mach u pojlijob, sutwänijob tä cha'num tä Jerusalén u sacänob ya' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","De ya'i, jinq'uin tz'äcti uxp'e q'uin u te u sacänob, u pojlijob tama ni noj ch'u'ul otot tuba aj judíosob. Uneba ya' chumca tänxinob machcatac u ye'e' ni ley taj Moisés u yubin cua'tac u yäle'ob, y aj Jesús u c'atbenob cua'tac jini yo u yubin uneba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Upete machcatac u yubijob cua' u yäle' aj Jesús tajch'icwäni u jut u yubinob cache' u p'alän y cache' q'uen u c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jinq'uin aj José y u na' u chäni, c'äsbäc'tijob, y u na' u yälbi ca'da: ―Cä ch'oc, ¿cua' uc'a a cherbon t'ocob ca' jini? A pap y no'on c'ac'a' ch'ocomi cä pixan tuba cä sacänet t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","De ya'i aj Jesús u yälbi: ―¿Cua' uc'a a bon saconla? ¿Mach quira a wila cache' c'änä cä cherben u patan ni cä Pap ya'an tä cieloba? ");
INSERT INTO chfNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Unejob mach u chi entendejob lo que u yälbijobba. ");
INSERT INTO chfNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","De ya'i bixijob t'oc tä Nazaret, y u laj tz'ombi u t'an u na' y u pap. U na'ba u laj äq'ui tu pixan upete cua'tac ajni. ");
INSERT INTO chfNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","De ya'i aj Jesús q'ue'ni u c'ajalin y no'i. Dios tä' yoba t'oc une y ni gentejob tä' nämtijob t'oc une täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jinq'uin quince años u bixe u chen manda aj Tiberio César, jini mero ajnojaba, ya'an täcä aj Poncio Pilato u chen manda de gobierno tama ni noj cab tä Judea. Jinchichba q'uinob täcä ya'an aj Herodes u chen manda de rey tama ni noj cab tä Galilea, y aj Felipe, u yermano aj Herodesba, ya'an u chen manda de rey tama chap'e cab, u c'aba' tä Iturea y tä Traconite. Aj Lisaniasba, une ni rey tama ni noj cab tä Abilinia. ");
INSERT INTO chfNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jinchichba año täcä aj Anás y aj Caifás ya'anob de u yajnojajob pale tuba aj judíosob. Jimba q'uinob jini Dios u loti aj Juan, u yajlo' aj Zacarías, bajca ayan bajca mach cuxu niuntu. ");
INSERT INTO chfNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","De ya'i aj Juan bixi tä cabil cab nätz'ä t'oc ni río u c'aba' Jordán. Ya' jini u tz'aycäbijob ni gente cache' c'änä u q'uexe' u c'ajalinob tuba mach u ni' chen u tanäjob, y de ya'i c'ablacob uc'a utic perdona u tanäjob. ");
INSERT INTO chfNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Une u chi ca' jini tuba pasic toj lo que u tz'ibi tä jun ni ajt'an ta Dios oni u c'aba' aj Isaías bajca u yäle' ca'daba: Ya'an untu winic u chen noj t'an bajca mach cuxu niuntu y u yäle' ca'da: “Tusbenla u biji bajca u te tä nume Cajnojala, to'esbenla u biji. Ca' a wälä ca' jini a to'esan a pixanla tuba a sapänla ni Cajnojala tu xe tä teba. ");
INSERT INTO chfNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","C'änä mulcac upete ch'en cab. Upete tz'ic y t'uchlom cab u xe tä jinescan. Ni bij locojtacba u xe tä colescanob tajtoj, y ni bij chelejtacba u xe tä jochinte tuba parejo'escac. ");
INSERT INTO chfNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Upete machca chichca pancab u xe u chänenob ni Ajjäpom que u täsqui Dios tuba u japänonlaba”. ");
INSERT INTO chfNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Q'uen gente bixijob tuba u c'ablesan aj Juan, y une u yälbijob ca'da: ―Anela ca' a wälä yal chanetla que u pase tä putz'e jinq'uin ya'an noj pule. ¿Caxca wäreca u yälbetla que a putz'tanla ni toji'tanä que Dios u xe u yäq'ue'ba? ");
INSERT INTO chfNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Chenla cua' chichca utztacba ta chänintic que si a totoj q'uexi a c'ajalinla tuba mach a ni' chen a tanäla. Mach a täq'ue' a wäle'la tan a c'ajalinla cache' a xe a japän abala uc'a a papla ane aj Abraham, uc'a cälbenetla que Dios, si u yolinicaba, u ch'e' u sutjatz'än ni ji'tunobda de u ch'ocob aj Abrahamba, jini machcatac u chenob ca' chich u chi uneba. ");
INSERT INTO chfNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Cälbenetla täcä que badaba u chen tä c'ote u q'uini tuba äc'bintiquetla a toje' a tanäla si mach a chila tu toja. Es ca' a wälä untec te' que tz'ita' yo ta julcac tä cab. Uc'a upete ni te' que mach u che u jut utzba u xe tä tzepcan y u xe tä julcan tama c'ac'. ");
INSERT INTO chfNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","De ya'i ni gente u c'atbijob ca'da: ―¿Cua' cä xe cä chen t'ocob jiq'uin? ");
INSERT INTO chfNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aj Juan u p'albijob ca'da: ―Machca u cänäntan chap'e u buc c'änä u yäc'ben ump'e machca mach u cänänta niump'e, y machca u cänäntan cua' tä c'uxcan c'änä u jeq'ue' tuba u yäc'ben machca mach u cänänta. ");
INSERT INTO chfNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","C'otijob ajcojtaq'uinob tuba u c'ablesanob aj Juan, y u yälbijob ca'da: ―Cä Maestro, ¿cua' c'änä cä chen t'ocob? ");
INSERT INTO chfNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aj Juan u yälbijob ca'da: ―Mach a coje'la más de lo que u yäle' ni ley tuba ni caj. ");
INSERT INTO chfNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ni soldadojob täcä u c'atbijob ca'da: ―No'on t'ocobba, ¿cuaxca c'änä cä chen t'ocob? Aj Juan u yälbijob ca'da: ―Mach a xuch'benla niuntu niump'e cua'. Mach a päpä' sube'la niuntu t'oc ni mach tojba. Ajnic ch'a'a ajinla t'oc lo que a tojcanla. ");
INSERT INTO chfNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ni gente ya'an u c'alin pitänob cua' u xe tä ute y u ch'e' u c'ajalinob que bay aj Juan ni Cristo, jini u yaqui Dios tuba ajmandaba. ");
INSERT INTO chfNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jin uc'a aj Juan u yälbi upetejob ca'da: ―Mach jinon no'on na wäle'la. No'on toj chich cä c'ablesanetla t'oc ja', pero u te untu täc pat más Ajnoja que no'on. No'onba mach jinon niump'e cua' tuba cä p'ämben u täbi u pächi'oc. Une u xe u c'ablesanetla t'oc Ch'u'ul Pixan, y u xe u to'esan a bijila bajca a chi a tanäla, ca' a wälä t'oc ump'e c'ac' que u pule'etla. ");
INSERT INTO chfNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ca' untu winic u sisän ni trigo t'oc u p'osi, ca' chich jini u chen u täq'ue' Cajnojala u jiran t'oc upete a'ajtäjob pancab. Ca' ni trigo que u tuscan tan u yajliba, ca' chich jini machcatac ayan tu tojaba u xe u bisan Cajnojala ca'an une. Jini machcatac mach'an tu tojaba, ca' chich u p'osi ni trigo, u xe tä julcanob tama ni c'ac' que mach u jira täpoba. ");
INSERT INTO chfNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uen t'an täcä u ye'bijob aj Juan ni gente tuba u ch'e' u c'ajalinob y u yälbijob ni t'an utz ta Diosba. ");
INSERT INTO chfNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jinchichba q'uinob aj Juan u q'uejpi ni rey u c'aba' aj Herodes uc'a u ch'i tuba jit'oc ix Herodías u jit'oc aj Felipe, jitz'in chich aj Herodesba. Aj Juan u q'uejpi täcä uc'a upete ni tanä que u chiba. ");
INSERT INTO chfNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aj Herodes u q'ue'nesi u tanä täcä uc'a u yäq'ui tä q'uechcan aj Juan u jup'e' tä cárcel. ");
INSERT INTO chfNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jinq'uin upete ni gente c'ablesquintijob, che' chich täcä aj Jesús c'abli. Mu'to u chen c'änti'ya aj Jesúsba jinq'uin ni cielo u jäbi uba, ");
INSERT INTO chfNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y jaqui ni Ch'u'ul Pixan tuyac'o, ca' a wälä untu ixsäcpäcä. De ya'i ubqui cache' Dios u chi ump'e noj t'an tä cielo u yäle' ca'daba: ―Ane cä yajben Ajlo'et. Ch'a'a cäjin t'oc ane. ");
INSERT INTO chfNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jinq'uin u täq'ui aj Jesús u chen lo que täsquinti u chenba, u cänäntan ca' treinta años u edad. Ca' chich u yälcan, aj Jesúsba ajlo' taj José. Aj Joséba ajlo' tuba aj Elí, ");
INSERT INTO chfNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","aj Elí ajlo' tuba aj Matat, aj Matat u yajlo' aj Leví, aj Leví u yajlo' aj Melqui, aj Melqui u yajlo' aj Jana, aj Jana u yajlo' aj José, ");
INSERT INTO chfNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","aj José u yajlo' aj Matatías, aj Matatías u yajlo' aj Amós, aj Amós u yajlo' aj Nahum, aj Nahum u yajlo' aj Esli, aj Esli u yajlo' aj Nagai, ");
INSERT INTO chfNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","aj Nagai u yajlo' aj Maat, aj Maat u yajlo' aj Matatías, aj Matatías u yajlo' aj Semei, aj Semei u yajlo' aj José, aj José u yajlo' aj Judá, ");
INSERT INTO chfNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","aj Judá u yajlo' aj Joana, aj Joana u yajlo' aj Resa, aj Resa u yajlo' aj Zorobabel, aj Zorobabel u yajlo' aj Salatiel, aj Salatiel u yajlo' aj Neri, ");
INSERT INTO chfNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","aj Neri u yajlo' aj Melqui, aj Melqui u yajlo' aj Adi, aj Adi u yajlo' aj Cosam, aj Cosam u yajlo' aj Elmodam, aj Elmodam u yajlo' aj Er, ");
INSERT INTO chfNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","aj Er u yajlo' aj Josué, aj Josué u yajlo' aj Eliezer, aj Eliezer u yajlo' aj Jorim, aj Jorim u yajlo' aj Matat, ");
INSERT INTO chfNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","aj Matat u yajlo' aj Leví, aj Leví u yajlo' aj Simeón, aj Simeón yajlo' aj Judá, aj Judá u yajlo' aj José, aj José u yajlo' aj Jonán, aj Jonán u yajlo' aj Eliaquim, ");
INSERT INTO chfNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","aj Eliaquim u yajlo' aj Melea, aj Melea u yajlo' aj Mainán, aj Mainán u yajlo' aj Matata, aj Matata u yajlo' aj Natán, ");
INSERT INTO chfNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","aj Natán u yajlo' aj David, aj David u yajlo' aj Isaí, aj Isaí u yajlo' aj Obed, aj Obed u yajlo' aj Booz, aj Booz u yajlo' aj Salmón, aj Salmón u yajlo' aj Naasón, ");
INSERT INTO chfNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","aj Naasón u yajlo' aj Aminadab, aj Aminadab u yajlo' aj Aram, aj Aram u yajlo' aj Esrom, aj Esrom u yajlo' aj Fares, aj Fares u yajlo' aj Judá, ");
INSERT INTO chfNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","aj Judá u yajlo' aj Jacob, aj Jacob u yajlo' aj Isaac, aj Isaac u yajlo' aj Abraham, aj Abraham u yajlo' aj Taré, aj Taré u yajlo' aj Nacor, ");
INSERT INTO chfNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","aj Nacor u yajlo' aj Serug, aj Serug u yajlo' aj Ragau, aj Ragau u yajlo' aj Peleg, aj Peleg u yajlo' aj Heber, aj Heber u yajlo' aj Sala, ");
INSERT INTO chfNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","aj Sala u yajlo' aj Cainán, aj Cainán u yajlo' aj Arfaxad, aj Arfaxad u yajlo' aj Sem, aj Sem u yajlo' aj Noé, aj Noé u yajlo' aj Lamec, ");
INSERT INTO chfNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","aj Lamec u yajlo' aj Matusalén, aj Matusalén u yajlo' aj Enoc, aj Enoc u yajlo' aj Jared, aj Jared u yajlo' aj Mahalaleel, aj Mahalaleel u yajlo' aj Cainán, ");
INSERT INTO chfNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","aj Cainán u yajlo' aj Enós, aj Enós u yajlo' aj Set, aj Set u yajlo' aj Adán, aj Adánba Dios u chi. ");
INSERT INTO chfNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Aj Jesús mäx an t'oc Ch'u'ul Pixan y pasi ya' jini bajca an ni río u c'aba' Jordán. Ni Ch'u'ul Pixan u bisi bajca mach cuxu niuntu. ");
INSERT INTO chfNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cuarenta q'uin aj Satanás u jiri si u chen trebe u yäc'ben u säte' aj Jesús. Aj Jesús mach u c'uxi niump'e cua' jimba q'uinob jini y ji'pat jitz'o u chen. ");
INSERT INTO chfNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","De ya'i aj Satanás u yälbi ca'da: ―Si ane es u Yajlo'et Dios, älben ni ji'tunda sutwänic de waj tuba a c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aj Jesús u p'albi ca'da: ―Tz'ibi ayan tuyac'o u jun Dios ca'da: “Mach sec' t'oc waj u yäc'binte cuxlec untu. U yäc'binte cuxlec täcä por u tz'omben upete u t'an Dios”. ");
INSERT INTO chfNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","De ya'i aj Satanás u bisi tu pam ump'e tz'ic nojba, y seb u laj ye'bi upete caj tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aj Satanás u yälbi ca'da: ―No'on cä xe cä'benet upete ni poder jini y ni pitzilan tubajob uc'a a'binton cä cänäntan no'on, y machca colin cä'benba, acä'ben chich. ");
INSERT INTO chfNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Si a noctä täc pänte' a ch'u'ul c'ajti'inonba upete u xe tä colan ta'a. ");
INSERT INTO chfNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aj Jesús u p'albi ca'da: ―Tz'eje aba t'oc no'on uc'a tz'ibi ayan tuyac'o u jun Dios ca'da: “A Wajnoja Dios a xe a ch'u'ul c'ajti'in y seq'uen Une a xe a cherben lo que yo utic”. ");
INSERT INTO chfNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","De ya'i aj Satanás u bisi tä Jerusalén y u yäq'ui isqui tu pat ni noj ch'u'ul otot tuba aj judíosob y u yälbi ca'da: ―Si ane u Yajlo'et Diosba, julu aba tä cab. Mach uxin u chenet pasa niump'e cua', ");
INSERT INTO chfNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","uc'a tz'ibi ayan tuyac'o u jun Dios ca'da: Dios u xe u täscun u ángelojob tuba u cänäntanet. ");
INSERT INTO chfNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tz'ibi ayan täcä ca'da: T'oc u c'äbob u xe u ch'uye'et uc'a mach a jätz'e' a woc t'oc ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aj Jesús u p'albi ca'da: ―Tz'ibi ayan täcä tuyac'o u jun Dios ca'da: “Mach a wiran si a wäc'ben u säte' a Wajnoja Dios”. ");
INSERT INTO chfNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jinq'uin aj Satanás u tzupsi u jiran si u yäc'ben u säte' aj Jesúsba u tz'eji uba t'oc une, u pitän caq'uin u ch'e' u jiran t'oc tä cha'num, bay u totoj äc'ben u säte'. ");
INSERT INTO chfNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","De ya'i aj Jesús sutwäni tama ni noj cab tä Galilea, y ajni u poder ni Ch'u'ul Pixan t'oc une. Cua'tac u chi aj Jesús laj ubqui tu junxoyma ni cab jini tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","U ye'i u t'an Dios tama upete ni ch'uj taj judíosob ya'i tä Galilea, y upetejob u yäle'ob cache' mäx utz cua' u chen. ");
INSERT INTO chfNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","C'oti tä Nazaret bajca ti tä ch'ije. Ca' chich nämä u chen, ochi tama ni ch'uj taj judíosob tu q'uini ch'ämbäji y ch'oyi u tzicbenob u jun Dios machcatac ya'an ya'i. ");
INSERT INTO chfNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","De ya'i äc'binti ni jun u tz'ibi ni ajt'an ta Dios u c'aba' aj Isaíasba. U jobi ni jun jini y u pojli jini parte bajca tz'ibi ayan ca'daba: ");
INSERT INTO chfNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ni Ch'u'ul Pixan tuba cä Yumla Dios ya'an täjcac'o, uc'a u yacon tuba cä tz'aycäbenjob pobrejilba ni t'an utzba ta Dios. U täscon tuba cä ch'a'alesben ujin machcatac triste u pixanob. U täscon tuba cä tz'aycäben machcatac ayan preso cache'da u xe tä chajcanob. U täscon tuba cä laj äc'ben u chen chanä ajchoc'. U täscon tuba cä japänob machcatac u tz'ibajtesan u yumob. ");
INSERT INTO chfNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","U täscon tuba cäq'ue' tä wina'tinte cache' c'oti q'uin que u xe tä ajtä ti'i u c'ajalin cä Yumla Dios tuba u japän machcatac sätä ayanobba. ");
INSERT INTO chfNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","De ya'i u tupi ni jun y u yäc'bi ni ajtäclaya, y ji'pat chunwäni u ye'e' u t'an Dios. Upetejob tama ni ch'uj tajch'icwäni u jut tuyac'o aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aj Jesús u täq'ui u chen t'an u yälbenob ca'da: ―Jini t'an ta Dios a totaj ubilaba, bada apasi toj chich. ");
INSERT INTO chfNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Upetejob u yäle'job cache' ti'i u pixan aj Jesús, y ch'icwäni u jutob u yubinob jini t'an mäx pitzi que u yäle'ba, pero u yälijob ca'da: ―¿Mach quira jinda winic u yajlo' aj José? ");
INSERT INTO chfNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","De ya'i aj Jesús u yälbijob ca'da: ―Anela a xe chich a wälbenonla ni t'an u yäle' ca'daba: “Ajtz'ac, tz'äcälin aba a juntuma”. Ixti a xe a wälbenonla täcä: “Upete lo que acubi t'ocob que a chi tä Capernaum, chen ca' jini täcä wida tan a cab”. ");
INSERT INTO chfNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","De ya'i u yäli täcä ca'da: ―Toj cälbenetla que niuntu ajt'an ta Dios mach utz'ombinti cua' u yäle' tan u cabba. ");
INSERT INTO chfNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Toj chich cälbenetla que ajni q'uen neba'täc ixictac tama ni cab tä Israel jinq'uin cuxu to aj Elías, jinq'uin mach u ni' äc'bi ja' tres año y seis mesba, jinq'uin ajni noj gran wi'na de jitz'o tu pancabba. ");
INSERT INTO chfNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero aj Elías mach täsquinti bajca an ni neba'täc ixictacob jiniba, namás tasquinti tuba u täclen untu neba' ixic que u chen vivi tä Sarepta tama ni noj cab tä Sidón. ");
INSERT INTO chfNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Che' chich täcä ajnijob q'uen tama ni cab tä Israel t'oc ni yaj u c'aba' lepra jinq'uin cuxu to ni ajt'an ta Dios aj Eliseoba, pero aj Eliseo mach u tz'äcäli niuntu de unejob seq'uen aj Naamán, u cab tä Siriaba. ");
INSERT INTO chfNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jinq'uin u yubijob ca' jiniba, upete ni ya'anob tama ni ch'uj jiniba, c'ac'a' cäräx'ijob. ");
INSERT INTO chfNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","De ya'i ch'oyijob u pa'senob tama ni caj. Ni caj jini ya' u chijob tu pam ump'e tz'ic, y u bisijob aj Jesús bajca an ni parte más isquiba tuba u tenjule'ob tu jäbtä ni tz'ic. ");
INSERT INTO chfNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero mach u chi trebejob uc'a aj Jesús numi tänxin unejob y bixi. ");
INSERT INTO chfNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","De ya'i aj Jesús jaqui bajca an ni caj tä Capernaum, ya'i tama ni noj cab tä Galilea, y cada u q'uini ch'ämbäjiba u ye'bijob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ch'icwäni u jut u yubinob cua' u ye'e', uc'a u chi t'an ca' machca c'alin yuwi cua' u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ya'an tan ni ch'uj jinq'uin untu winic t'oc untu tzuc pixan tuyac'o y u chen noj gran awät. U yäle' ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Lo', äctanon t'ocob. ¿Cua' a xe a cherbenon t'ocob, Jesús aj nazarenojet? ¿Atet quira tuba a säte'on t'ocob? No'on cuwi chich machcajet aneba. Ane Ch'u'ul Winiquet ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aj Jesús u q'uejpi y u yälbi ca'da: ―¡Ch'in ajni', pasen tuyac'o ni winicda! De ya'i ni tzuc pixan u tenjuli ni winic tä cab tama ni gente y pasi tuyac'o sin que u chen lastima. ");
INSERT INTO chfNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Upetejob c'äsbäc'tijob y u maläc äle'ob ca'da: ―¿Cua' wäreca t'an u chen ni winic jini? Une u chen manda tzuc pixanob t'oc poder y ca' untu totoj ajmandaba, y u tz'onänob chich pasic tuyac'o untu. ");
INSERT INTO chfNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Cua'tac u chi aj Jesús laj ubqui tama upete cabil cab nätz'ä t'oc ni caj ya' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","De ya'i aj Jesús pasi tama ni ch'uj. Bixi y ochi tan yotot aj Simón. U nojna' aj Simónba c'ojo ayan t'oc noj gran ticwa, y u ch'oc chen ubajob t'oc aj Jesús bay u yäc'be u pojlen uba. ");
INSERT INTO chfNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tinwäni aj Jesús ca'an ni ixic u pa'säben tuyac'o ni ticwa, y u yäcti chich. Seb ch'oyi ni ixic jini y u cherben cua' u c'uxe'job y u yäc'benob. ");
INSERT INTO chfNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tu xe tä pome q'uin upete machcatac u cänäntan ajc'ojpanob t'oc cua' chichca yaj jini u bisbijob aj Jesús. Aj Jesúsba u yäq'ui u c'äb tuyac'ojob y ca' jini u tz'äcälijob. ");
INSERT INTO chfNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pasi tzuc pixanob tuyac'o q'uen de ni ajc'ojpanob jini täcä u chen noj awätob u yäle'ob ca'da: ―Ane u Yajlo'et Dios. Pero une u q'uejpijob, mach u yäc'bejob u chen t'an, uc'a u chi conocejob que une ni Cristo, jini u yaqui Dios tuba ajmandaba. ");
INSERT INTO chfNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Päscab tu junch'äcnanba aj Jesús pasi y bixi ump'e lugar bajca mach cuxu niuntu. Ni gente u saquijob y jinq'uin c'otijob bajca an u yolijob u yäc'ben nonoj colac t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","De ya'i une u yälbijob ca'da: ―C'änä xicon otro cajob täcä cä laj älbenob ni t'an utzba tuba u manda Dios, uc'a jin tuba atäsquinton. ");
INSERT INTO chfNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","De ya'i aj Jesús u tz'aycäbijob u t'an Dios tama ni ch'uj taj judíosob cachichcada tama ni noj cab tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jinq'uin aj Jesús ya'an tu ti' ni nab u c'aba' Galilea, noj q'uenel gente u múlijob tuba u yubin u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aj Jesús u chäni que ya'an chap'e noj re'i jucub nätz'ä tu ti' ni nab, y ajq'uechbuch'obba mach'an tama ni jucub, san laj jaquijob u poque' u chimob. ");
INSERT INTO chfNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","De ya'i aj Jesús ochi tama ump'e jucub, ni tuba aj Simónba, y u yälbi que u noje' tz'ita' tä ja'. De ya'i chunwäni tama ni jucub u ye'benob ni gente u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jinq'uin u tzupsi u chen t'anba u yälbi aj Simón ca'da: ―Nojola ni jucub bajca tam ni ja' y julula ni chim tä ja' tuba a q'ueche'la ni buch'. ");
INSERT INTO chfNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aj Simón u p'albi ca'da: ―Cajnoja, entero ac'äb cä chi chäyba t'ocob, y mach acä q'uechi t'ocob cua', pero si ane a wäle'ba cä xe chich cä jule' tä ja' tä cha'num ni chim. ");
INSERT INTO chfNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jinq'uin u chijob ca' jiniba u c'ac'a' mäquijob noj q'uenel buch' ixta u täq'ui u xet'e' uba ni chim. ");
INSERT INTO chfNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","De ya'i u cherbijob u c'äb u lotob u joq'ue'ob, jini ya'anob tama otro jucubba, uc'a xicob u täclenob, y xijob chich y u c'ac'a' tulesijob u chap'elma ni jucub. Tulescac otro tz'ita'ba, u jome. ");
INSERT INTO chfNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jinq'uin u chäni aj Simón Pedro cua' uti, nocwäni tu yoc aj Jesús u yälben ca'da: ―Cajnoja, mach'an cua' uc'a a natz'änon, uc'a no'onba ajcherajtanäjon. ");
INSERT INTO chfNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","C'äsbäc'ti aj Simón Pedro y machcatac ya'an t'oc une uc'a u q'uechijob noj q'uenel buch'. Jin uc'a u yäli ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","C'äsbäc'tijob täcä u lotob aj Simónba, aj Jacobo y aj Juan, u cha'tumajob u ch'ocob aj Zebedeo. Aj Jesús u yälbi aj Simón ca'da: ―Mach bäc'taquet. Ajniba ajq'uechbuch'et, pero desde badaba cä'benet a sacän winicob tuba u tz'ombenonjob cä t'an, ca' a wälä ni buch' u q'uechcanba. ");
INSERT INTO chfNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jinq'uin u täsijob tä cab ni jucub u laj äctijob u patan y upete cua' u cänäntan y u tzäypätijob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ji'pat, jinq'uin aj Jesús ya'an tan ump'e caj c'oti untu winic mäx c'ojo t'oc ni yaj u c'aba' lepra, y jinq'uin u chäni aj Jesús nocwäni tu yoc y u chinjatz'i u pam tä cab u ch'oc chen uba t'oc. U yälbi ca'da: ―Noxi' winic, si a wolinicaba u ch'e' a tz'äcälinon. ");
INSERT INTO chfNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","De ya'i aj Jesús u sätz'i u c'äb u täle' y u yälbi ca'da: ―Co chich cä tz'äcälinet, y bada a wäq'ui aba. Tajtzäc pasi ni yaj tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","De ya'i aj Jesús u yälbi que mach u yälben niump'e cua' niuntu cua' uti t'oc une. Jini a xe a chenba, a xe a ye'e' aba tu jut ni pale tuba aj judíosob y a subben Dios ni matän jini u ye'e' cache' a pojli ababa, ca' chich u yäli aj Moisés uticba, uc'a u yuwina'tanob ni gente cache' a pojli chich aba. ");
INSERT INTO chfNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mäx u chi segui tä ubcan más pänte' cua'tac u chi aj Jesús. Jin uc'a u woyli ubajob noj q'uenel gente tuba u yubinob u t'an y tuba tz'äcälcacob t'oc cua' chichca yaj que u cänäntanobba. ");
INSERT INTO chfNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero aj Jesús u paq'uin tz'eje' uba u bixe bajca mach'an machca tuba u chen c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","De ya'i ump'e q'uin jinq'uin ya'an aj Jesús u ye'e' u t'an Dios, ya' chumcajob nätz'ä t'oc une aj fariseojob y machcatac u ye'e' ni ley que u tz'ibi aj Moisés. Jin jinijob ya' tijob tä cabil cabob tä Galilea y tä Judea y tama ni noj caj tä Jerusalén. U poder cä Yumla Dios ya'an tuyac'o aj Jesús tuba u tz'äcälin ajc'ojpanob. ");
INSERT INTO chfNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","De ya'i yebejob c'otijob t'oc untu ajc'ojpan chämen u cuerpoba ch'uyu uc'ajob tu pam ump'e u yoc ch'a'liba. U yoli u c'osenob u yäq'ue'ob tu pänte' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mach u pojlijob cache'da u ch'e' u yosenob uc'a mäx q'uen ni gente. De ya'i t'äbijob tu pat ni otot isqui u lowe'job, y u jäcsijob con to'o u ch'a'liba tänxin ni gente mero bajca ayan aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jinq'uin u chäni aj Jesús cache' u tz'onänjobba u yälbi ni winic ca'da: ―Lo', a tanä alaj uti perdona. ");
INSERT INTO chfNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","De ya'i jini machcatac u ye'e' ni ley que u tz'ibi aj Moisés, nämte' t'oc aj fariseojobba, u täq'uijob u yäle' tu c'ajalinob ca'da: “Ni winic jini u päpä' chen uba cache' une ni Dios. U susuc äle' cache' u ch'e' u chen perdona u tanä untu”. ");
INSERT INTO chfNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aj Jesús yuwi cua' mu' u yäle' tan u c'ajalinob, y u yälbi ca'da: ―¿Cua' uc'a a päpä' chen pensala ca' jini tan a pixanla? ");
INSERT INTO chfNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Caxcamba quira más u ch'e' cälben ni ajc'ojpan, que u tanä a'uti perdona, o cälben que ch'oyic y u chen xämba? ");
INSERT INTO chfNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Co que a wina'tanla cache' no'on que sutwänon de winicba cä cänäntan poder pancab tuba cä cherben perdona u tanä untu. De ya'i aj Jesús u yälbi najc'ojpan ca'da: ―Ane cälbenet, ch'oyen, ch'ä a ch'a'lib y corre cux ta' wotot. ");
INSERT INTO chfNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ni winic que chämen u cuerpoba tajtzäc u yäq'ui uba y wa'wäni tu pänte' ni gente y u ch'i ni u ch'a'lib, jini u ch'a'tiba, y bixi tu yotot u ch'u'ul c'ajti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Upetejob mäx ch'icwäni u jut u chänenob y u ch'u'ul c'ajti'inob Dios. C'äsbäc'tijob y u yäle'ob ca'da: ―Mach bay ti täj c'ajalinla que si u ch'e' utic jini cä chänila samiba. ");
INSERT INTO chfNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ji'pat de ni jini pasi aj Jesús y u chäni untu ajcojtaq'uin u c'aba' aj Leví ya' chumca bajca u cojcan taq'uin. U yälbi ca'da: ―Tzäypätinon. ");
INSERT INTO chfNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","De ya'i u yäcti u patan y upete cua' u cänäntan, ch'oyi y u tzäypäti. ");
INSERT INTO chfNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ji'pat, aj Leví u cherbi aj Jesús ump'e noj c'ux tu yotot. Ajnijob täcä q'uen ajcojtaq'uinob y otrosjob ya' chumca tä mesa nämte' t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jini machcatac u ye'e' ni ley que u tz'ibi aj Moisés y aj fariseojob u cäräx älbijob u yajcänt'anob aj Jesús y u yälbijob ca'da: ―¿Cua' uc'a a chenla ni mach utzba? ¿Cua' uc'a a c'uxnanla y a buc'ala t'oc ajcojtaq'uinob y ajcherajtanäjob? ");
INSERT INTO chfNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aj Jesús u p'albijob ca'da: ―Jini machcatac t'oc u yutziba mach c'änä uc'ajob ajtz'ac, seq'uen ni c'ojojtacba c'änä uc'a ajtz'ac. ");
INSERT INTO chfNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mach aton cä joq'ue' jini machcatac u päpä' äle' tu c'ajalinob que ayanob tu tojaba tuba u q'uexe' u c'ajalinob uc'a mach u ni' chenob u tanä. No'on aton cä joq'ue' ajcherajtanäjob tuba u q'uexe' u c'ajalinob uc'a mach u ni' chen u tanä. ");
INSERT INTO chfNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","De ya'i unejob u yälbi ca'da: ―U yajcänt'anob aj Juan ayan q'uen q'uin que mach u buc'ob mach u c'uxnajob, u chenob c'änti'ya, y che' chich täcä u yajcänt'anob aj fariseojob. A wajcänt'anob aneba u c'uxnanob y u buc'ajob chich upete q'uin. ¿Cua' uc'a a chenla ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aj Jesús u yälbijob ca'da: ―¿U ch'e' quira a wäc'benla mach c'uxnacob mach buq'uicob ajmajnintejob ca'an ump'e lotojan jinq'uin ya'to an ajlotojan t'oc unejob? Mach une. ");
INSERT INTO chfNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero u xe tä c'ote q'uin que u xe tä pa'sinte bajca anob ni ajlotojan y u bisinte. Jinq'uinba u xe tä p'elaj ajtä q'uin que mach uxin tä c'uxnanob ni tä buc'ajob. ");
INSERT INTO chfNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Che' chich täcä u yälbijob chap'e uxp'e t'an ca'da: ―Niuntu mach u seq'ue ump'e buc tzijibba tuba u tzutzän t'oc ump'e buqui jelemba, uc'a si u chen ca' jini, ni tzijibba mach uni' xin tä colan utz, y che' chich täcä ni u tzutzquiba mach uyal t'oc ni jelemba uc'a mach jin u lot. ");
INSERT INTO chfNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y niuntu mach u colo ni vino tzijibba tama ump'e pächi jelemba tuba u ch'ujnan, uc'a ni vino tzijibba u xe u tzalesan ni pächi jelemba y ni vino u xe tä wech'can tä cab y ni pächi u xe tä laj säto. ");
INSERT INTO chfNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","C'änä colcac ni vino tzijibba tama ni pächi tzijibba tuba mach sätic u chap'elma. ");
INSERT INTO chfNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y machca u yuch'en ni vino que a'onob'iba mach ni' yo u yuch'en ni tzijibba, uc'a u yäle' cache' más jätz'äcna jini que a'onob'iba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ump'e u q'uini ch'ämbäji aj Jesús nume u chen bajca päc'ä ni trigo y u yajcänt'anob u c'äsbijob u jut ni trigo y u jaxi tan u pechc'äbob tuba u pa'säben u sulob y u c'uxe'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yebe aj fariseojob u yälbijob ca'da: ―¿Cua' uc'a a chenla lo que ni ley taj Moisés u yäle' que mach u ch'ä utic tu q'uini ch'ämbäji? ");
INSERT INTO chfNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aj Jesús u p'albijob ca'da: ―¿Mach to quira a tziquila cua' u chi aj David y u lotob u nume t'ocba, jinq'uin jitz'o u chenobba? ");
INSERT INTO chfNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aj David ochi tama ni otot ta Dios y u ch'i ni waj u subbinte Diosba u c'uxe' y u yäc'bi täcä u c'uxe' machcatac ayan t'oc une. Ni ley que u tz'ibi aj Moisés u yäle' que mach u ch'ä u c'uxe' niuntu seq'uen palejob namás, pero aj David mach ajni u tanä uc'a u chijob ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","U yälbijob täcä ca'da: ―No'on que sutwänon de winicba ajnojalon chich täcä tuba cäle' cua' u ch'e' utic y cua' jini mach u ch'ä utic tu q'uini ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Otro ump'e u q'uini ch'ämbäjiba aj Jesús ochi tama ni ch'uj taj judíosob u ye'e' u t'an Dios, y ya'an ya' jini untu winic que tz'u'mi untz'it u c'äb, ni u nojba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","De ya'i jini machcatac u ye'e' ni ley y aj fariseojob täcä u ch'ucänob u jiranob si u xe u tz'äcälin ni winic jini tuyac'o u q'uini ch'ämbäji, uc'a ajnic cache' u ch'e' u sube'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero aj Jesús yuwi cua' an tu c'ajalinob y u yälbi ni winic que tz'u'mi u c'äbba ca'da: ―Ch'oyen, la'ix wida bajca anon t'ocob tä wa'tä. Ch'oyi y wa'wäni ya' jini ca' chich älbinti. ");
INSERT INTO chfNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","De ya'i aj Jesús u yälbijob ca'da: ―Ump'e cosa cä xe cä c'atbenetla. ¿U yäle' quira ni ley que u tz'ibi aj Moisés cache' c'änä cä chenla cua' chichca utzba tu q'uini ch'ämbäji, o ni mach utzba? ¿U yäle' quira tz'äcälcac untu uc'a mach chämic, o äctintic untu tä chämo? ");
INSERT INTO chfNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","U chämbi u jut upetejob tu junxoyma, y de ya'i u yälbi ni winic ca'da: ―Sätz'ä a c'äb. Une u sätz'i u c'äb y u pojli uba jinchichba rato. Coli utz ca' chich ni otro untz'itba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Unejob c'ac'a' cäräx'ijob u maläc ch'e' u c'ajalinob cua' u ch'e' u cherbenob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jimba q'uinob jini aj Jesús bixi tu pam tz'ic u chen c'änti'ya, y u numsi ac'äb u c'änti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jinq'uin t'äbi q'uin u joq'ui u yajcänt'anob, y u yaqui doce de unejob. Ni jinijob u yälbijob cache' ajc'äncanob tuba, jini u yälbinte cache' apóstolesjobba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","U yaqui aj Simón, jini u yäc'bi u c'aba' aj Pedro täcä; y aj Andrés, jitz'in aj Pedroba. U yaquijob täcä aj Jacobo y aj Juan, y aj Felipe, y aj Bartolomé, ");
INSERT INTO chfNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","y aj Mateo, y aj Tomás, y aj Jacobo jini u yajlo' aj Alfeoba, y aj Simón jini u yäläs c'aba' aj Zeloteba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Che' chich täcä aj Judas jini u jitz'in aj Jacoboba, y aj Judas Iscariote que ji'pat u yäq'ui tä c'äbä aj Jesúsba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","De ya'i jaqui t'oc unejob y c'oti tä wa'tä bajca parejo ni cab. Ya'an ya' jini täcä q'uen u yajcänt'anob y noj q'uenel gente que ya' tijob tä cabil cab tä Judea, y tama noj caj tä Jerusalén, y tu ti' nab tama ni cabob tä Tiro y tä Sidón. Unejob c'oti tuba u yubinob u t'an aj Jesús y tuba tz'äcälcacob t'oc ni yaj que u cänäntanobba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Machcatac ajäläcni u tz'ibajtesanob cua' chichca tzuc pixanob tz'äcälquintijob täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Upetejob u yolijob u täle' aj Jesús uc'a tuyac'o une u cänäntan jini poder tuba u tz'äcälin ajc'ojpanobba, y u tz'äcäli chich upetejob. ");
INSERT INTO chfNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","De ya'i aj Jesús u chämbi u jut u yajcänt'anob y u yälbijob ca'da: ―Ayan ump'e ch'a'aljin ta'ala anela pobrejilba uc'a a sapila Dios tuba u chenetla manda. ");
INSERT INTO chfNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ayan ump'e ch'a'aljin ta'ala anela que badaba a cänäntanla jitz'o uc'a a xe tä na'escanla. ’Ayan ump'e ch'a'aljin ta'ala anela que badaba a chen uq'uela uc'a a xe a chen tze'nela. ");
INSERT INTO chfNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ayan ump'e ch'a'aljin ta'ala anela jinq'uin winicob u cräxna'tanetla y u tz'eje' ubajob t'oc anela y u tz'ibajtesanetla, y jinq'uin winicob u yäle'ob que anela mach jin cua'etla, ca' a wälä untu ajmalujle. U xe u chenob ca' jini uc'a a tz'ombenonla cä t'an no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jinq'uin a xe tä cherbintela ca' jini ch'a'alesan ajinla, c'alin ac'ojnenla de ch'a'aljin, uc'a tä cieloba a xe tä äc'bintela ump'e noj gran matän tuba u jelo lo que cherbintetla. Ca' chich mu' u tz'ibajtesanetla, che' chich täcä jinchichba u yajcäbnajob oni u tz'ibajtesijob ajt'anob ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Anela ajtaq'uini, tä' lástimajetla uc'a badaba a nonoj cänäntila chich upete a ch'a'aljinla. ");
INSERT INTO chfNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Anela machcatac mach u cherbet faltala niump'e cua' bada, tä' lástimajetla uc'a a xe tä jitz'anla. ’Anela machcatac a chen tze'nela bada, tä' lástimajetla uc'a u xe tä ch'ocoman a pixanla y a xe a chen uq'uela. ");
INSERT INTO chfNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Lástimajetla si upetejob u yäle'ob cache' utz cua'tac a chenla. Ca' chich u yäle'ob cache' utz cua'tac a chenla, che' chich täcä jinchichba u yajcäbnajob oni u yälbijob jini machcatac u päpä' äle'ob cache' ajt'an ta Dios, y mach jin. ");
INSERT INTO chfNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Pero anela que mu' a ubinla cua' acäle'ba cälbenetla ca'da: Yajna'tanla machcatac u cräxna'tanetla. Cherbenla utz machcatac mach yo u chänenetla. ");
INSERT INTO chfNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","C'atben Dios que ajnic u yutzi jini machcatac u cäräx älbenetla. C'änti'ben Dios tuba machcatac u tz'ibajtesanetla. ");
INSERT INTO chfNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Machca u cune'et ta' chojba sutän otro la'o a choj uc'a u cune' u chap'elma la'o a choj. Machca u jajbenet a jeli' sisi mach a wäle' que mach a wäc'be a buc täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Machca chichca une u c'atbenet cua' chichca, äc'ben lo que u c'atän, y machca u ch'ämbenet cua' a cänäntanba, mach a cocoj c'atän u sutjatz'benet tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ca' chich a wola que u cherbenetla machca chichca une cua' chichca utz, ca' jini c'änä a cherbenob täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Si anela a yajna'tanla machcatac u yajna'tanetla namásba mach jin cua' une ta'ala, uc'a ajmalujlejob u yajna'tanob chich täcä machcatac u yajna'tanob unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Si namás a cherbenla favor machcatac u cherbenetla favorba mach jin cua' une ta'ala, uc'a ca' chich jini u chenob täcä ajmalujlejob. ");
INSERT INTO chfNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si namás a wäc'benla u majnanob cua' chichca jini machcatac que a wäle'la que u xe u sutjatz'benetla tä cha'numba, mach jin cua' une ta'ala. Ajmalujlejob täcä u yäc'ben u majnanob cua' chichca jini u lotob, uc'a u yäle'ob cache' u xe tä sutjatz'bintejob tz'äcä lo que u yäq'uijob tä majninte. ");
INSERT INTO chfNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yajna'tanla jini machcatac mach yo u chänenetla. Chenla utz y äc'äla tä majninte cua' chichca sin que a pitänla äc'bintiquet a majnanla cua' chichca tuba u jelo. Si a chenla ca' jiniba Dios u xe u yäc'benetla ump'e a noj gran matänla. A xe a ye'e'la cache' u ch'ocobetla Dios, jini más Ajnoja que ayanba, uc'a uneba ti'i u pixan t'oc machcatac tzätz u pixan, y t'oc ajmalujlejob. ");
INSERT INTO chfNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ch'ämbenla yajin upetejob ca' chich cä Papla Dios u ch'ämben yajin upetejob. ");
INSERT INTO chfNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Mach a chenla ca' untu juez y a wäle'la cache' mach utz cua' u chen a lot, uc'a si a chenla ca' jiniba che' chich u xe u cherbenetla täcä Dios. Mach a wäc'benla u toje' u tanä a lot, uc'a si a chenla ca' jiniba Dios u xe u yäc'benet a toje' a tanäla täcä. Chenla perdona a lot uc'a u chenetla perdona täcä Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chenla sij y Dios u xe u yäc'benet a matänla täcä. Ca' untu winic u yäq'ue' ump'e medida de ixim tz'äcäba y u c'alin but'e' y u chec'än tuba u bisan más u belba ixta que mach u t'it'än uba tä cab, ca' chich jini Dios u xe u yäc'benet a matänla täcä. Ca' chich a p'isänla cua' chichca que a wäq'ue'laba, che' chich a xe tä p'isbintela cua' chichca que a mätanla. ");
INSERT INTO chfNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aj Jesús u yälbijob ump'e t'an täcä ca'da: ―¿U ch'e' quira untu ajchoc' u päyben u c'äb otro ajchoc'? ¿Mach quira u cha'tumajob u xe tä yälo tama ch'en? ");
INSERT INTO chfNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ca' chich jini täcä, machca u cäne' cua' chichca mach jin más ajnoja que jini machca u ye'benba, pero machca u c'alin cäni upeteba u xe tä colan ca' chich machca u ye'biba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Cua' uc'a a wäle' cache' a chen trebe a chänen cache' tz'ita' u säte' a lot t'oc ump'e u tanä si ane mach a wäc'be aba cuenta cache' mäx malo cua' a chen aneba? Es ca' a wälä tan u jut a lot ya'an unlip' yoc xixom p'os, y tan a jut aneba ca' a wälä ya'an untz'it noj re'i jäyte'. ");
INSERT INTO chfNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ane mach u ch'ä a wälben a lot que a xe a täclen uc'a mach u ni' säte' si ane mach a wi cache' mäx malo cua' a chen aneba. Es ca' a wälä a wo a pa'säben jini xixom p'os que ya'an tan u jut, pero ane mach a chäne jini noj re'i jäyte' que ya'an tan a jut aneba. ¡Aneba ajsusutcheriajet! Najtäcä äctan a chen ni mach utzba tuba a chen tu toja y de ya'i a xe a chen trebe a täclen a lot u chen tu toja täcä. Es ca' a wälä najtäcä a pa'sen ane ni jäyte' tan a jut y de ya'i a xe a chen chanä utz tuba a chen trebe a pa'säben ni xixom p'os ya'an tan u jut a lotba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Untec te' utzba mach bay u yäc'ä u jut que mach utztacba, y untec te' que mach utzba mach bay u yäc'ä täcä u jut utztacba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cada te' u yute conoce por u jut. Mach u ch'ä a pojlen ni higo tuyac'o te' ch'ix, y ni uva mach u ch'ä a pojlen tuyac'o chäcch'ix. ");
INSERT INTO chfNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ca' chich jini täcä, untu winic que ayan tu toja u yäle' ni utzba, uc'a ca' a wälä ch'uju ayan tu pixan cua' chichca utztacba, y ni winic mach'an tu tojaba u yäle' ni mach utzba, uc'a ca' a wälä ch'uju ayan tu pixan cua' chichca mach utz. ");
INSERT INTO chfNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Cua' uc'a a wälbenon cache' a wajnojalon y mach a che ca' chich cälbenet? ");
INSERT INTO chfNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cä xe cälbenetla cua' u c'ote t'oc untu winic que u te bajca anon u yubin cä t'an y u chen ca' chich cälbenba. ");
INSERT INTO chfNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","U c'ote t'oc ca' untu winic ajcheraj otot u joc'än mäx tam ni cab y u yäc'ben u chumliba ni otot tu pam ji'tun. De ya'i jinq'uin u te ump'e noj but'o y noj yocja' u jätz'e' uba tuyac'o ni otot y mach u che trebe u nicän, uc'a ya' chumca ni otot tu pam ni ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero jini machca u yubin cä t'an y mach u che ca' chich cälbenba u c'ote t'oc ca' ni winic que u chi yotot taj chumu tu pancab. Mach u jóq'ui bajca u xe u yäc'ben u chumliba ni otot. De ya'i ti ump'e noj gran yocja' muc'ba y u jätz'i uba tuyac'o ni otot y seb yäli tä cab. Nonoj xupi tä jine ni otot jini. ");
INSERT INTO chfNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jinq'uin aj Jesús u tzupsi u yälbenob ni t'an jiniba tuba u yubinob ni gente, ochi tama caj tä Capernaum. ");
INSERT INTO chfNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ya'an ya'i jinq'uin untu ajnoja ta cien soldadojob que u cänäntan untu u yajpatan que mäx yaj u yubin. Ni ajpatan jiniba c'ojo ayan, tz'ita' yo ta chämic. ");
INSERT INTO chfNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jinq'uin ni ajnoja jini u yubi u yälcan de aj Jesús, u täsquijob ajt'äbälajob tuba aj judíosob bajca an aj Jesús u ch'oc chen uba t'oc u yälben si u xe u tz'äcälben u yajpatan jini ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jinq'uin c'otijob ca'an aj Jesús u ch'oc chi ubajob t'oc u yälbenob ca'da: ―Co t'ocob a tz'äcälben u yajpatan uc'a mäx ti'i u pixan ni ajnoja jini. ");
INSERT INTO chfNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Uneba u yajna'tan cä lotobla täj cabil cabla y u cherbon t'ocob ump'e ch'uj. ");
INSERT INTO chfNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","De ya'i aj Jesús bixijob t'oc, y jinq'uin natz'äjbäli bajca an ni otot, ni ajnoja jini u täsqui cha'tu uxtu u lotob xic u yälben aj Jesús ca'da: ―Cajnoja, mach a tz'ibajtesan aba tiquet, uc'a mach jin cua'on tuba ochiquet tan cotot. ");
INSERT INTO chfNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jin uc'a cäli que mach u ch'ä xicon no'on ca'anet täcä. Namás chen ump'e t'an y ca' jini cajpatan u xe u yäq'ue' uba. ");
INSERT INTO chfNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Cuwi chich que u xe tä ute lo que a wäle' aneba, uc'a ixta no'on ayan soldadojob täj c'äb tuba cä chen mandajob. Untu cälben xic y u xe. Otro untuba cälben tic y u te. Cälben cajpatan que u chen cua' chichca patan y u chen chich, pero ayan machca u chenon manda täcä no'on. ");
INSERT INTO chfNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ch'icwäni u jut aj Jesús jinq'uin u yubi cua' u yäli ni ajnoja jini. De ya'i u suti uba bajca u tejob ni gente tu pat y u yälbijob ca'da: ―Cälbenetla cache' mach to cä pojle niuntu winic tama ni gente tuba aj Israelob que tä' u tz'onän ca' ni winicda. ");
INSERT INTO chfNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jinq'uin sutwänijob tan otot jini machcatac u täsqui ajnoja ta cien soldadoba, c'otijob u pojlen cache' u c'alin pojli uba najpatan jini que ajni c'ojoba. ");
INSERT INTO chfNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ji'pat tz'ita' aj Jesús bixi ump'e caj u c'aba' tä Naín. Bixi nämte' t'oc u yajcänt'anob y t'oc noj q'uenel gente. ");
INSERT INTO chfNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jinq'uin anatz'älijob tu ti' ni caj u chänijob cache' pase u chenob t'oc untu ajchäme u bisanob tuba u muque'. Ni ajchäme jini u juntul ajlo' u na', y uneba neba' ixic une. U tejob t'oc u lotin noj q'uenel gente ta ni caj. ");
INSERT INTO chfNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jinq'uin Cajnojala u chäni ni ixic jini, u ch'ämbi yajin y u yälbi ca'da: ―Mach a chen uq'ue. ");
INSERT INTO chfNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","De ya'i aj Jesús bixi u natz'än u täle' ni cajón. Jini machcatac u bisan ni ajchämeba wa'wänijob y aj Jesús u yälbi ni ajchäme ca'da: ―Lo', cälbenet: Ch'oyen. ");
INSERT INTO chfNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","De ya'i ch'oyi tä chumtä ni ajchäme y u täq'ui u chen t'an y aj Jesús u yäc'bi tu c'äb u na'. ");
INSERT INTO chfNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Upetejob bäc'tijob y u ch'u'ul c'ajti'ijob Dios u yäle'ob ca'da: ―Untu mero no' ajt'an ta Dios ajuli bajca anonla. U yälijob täcä ca'da: ―Dios u ch'ämbi yajin ni gente tubaba uc'a mäx ti'i u c'ajalin t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ni t'an jiniba que u yälijob ni gente de lo que u chi aj Jesús laj ubqui tama upete ni cab tä Judea, y upete cabil cab tu junxoyma ya' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","De ya'i u yajcänt'anob aj Juan c'otijob u yälben cua'tac ajni. ");
INSERT INTO chfNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Aj Juanba u joq'ui cha'tu u yajcänt'an y u täsquijob ca'an aj Jesús tuba u c'atbenob ca'da: “¿Ane chich quira ni u yälcan cache' Dios u xe u täscunba, o c'änä cä pitän t'ocob otro?” ");
INSERT INTO chfNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jinq'uin c'otijob ni winicob ca'an aj Jesús u yälbijob ca'da: ―Aj Juan ajc'ablesiaba u täscon t'ocob cä c'atbenet si ane chich quira ni u yälcan cache' Dios u xe u täscunba, o si c'änä cä pitän t'ocob otro. ");
INSERT INTO chfNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jinchichba hora aj Jesús u tz'äcäli q'uen ajc'ojpanob y jini machcatac u cänäntanob toyoben yaj. U pa'säbi tzuc pixan tuyac'o machcatac u cänäntan, y q'uen machcatac ajchoc' u tz'äcälbi u jut tuba u chen chanä. ");
INSERT INTO chfNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","U p'ali aj Jesús u yälbenob ca'da: ―Corre cuxla älben aj Juan cua'tac a chänila y cua'tac a ubila: ajchoc' a'äc'bintijob u chen chanä, ajc'ol'oc a'äc'bintijob u chen xämba, machcatac c'ojojtac t'oc ni yaj u c'aba' lepra u colescanob limpio u pächi, ajcoc a'äc'bintijob u yubin t'an, ajchämejob u yäc'binte sutwänicob tä cuxpan cha'num, y ni pobrejilba u tz'aycäbintejob ni t'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ch'a'a ujin jini machca u tz'onän y mach u cänänta jaq'uinle uc'a no'on. ");
INSERT INTO chfNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jinq'uin bixijob ni ajc'äncanob tuba aj Juan, aj Jesús u täq'ui u tz'aycäben ni gente de aj Juan ca'da: ―¿Cua' jini apaset a chänenla bajca mach cuxu niuntu? ¿Untu winic quira chap'e u c'ajalinba, ca' a wälä untz'it oj u nicän uba t'oc ni ic'? Cälbenetla que mach. ");
INSERT INTO chfNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Cua' jini ajnet a chänenla jiq'uin? ¿Untu quira winic c'alin jele t'oc u buc finoba? Cälbenetla que mach. Ubixto, machcatac u cänäntan u buc mäx pitziba y u numsen q'uin t'oc lo que u ch'a'alesben ujinba ya'anob tan yotot bajca cuxujob rey. ");
INSERT INTO chfNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Cua' jini ajnet a chänenla jiq'uin? ¿Untu quira ajt'an ta Dios? Toj chich, y cälbenetla que uneba täcä es más ajnoja que untu ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tz'ibi ayan tan u jun Dios cua' u xe u chen aj Juan bajca u yäle' ca'daba: Ubixto, cä täscun ni cajc'äncan xic najtäcä que ane. Ca' untu winic u tuse' ni bij bajca u xe tä nume u yajnoja, ca' jini une u xe u yäc'ben u q'uexe' u c'ajalinob ni gente antes que tiquet uc'a mach u ni' chen u tanäjob. Ca' jini u yäle' ni an tz'ibiba. ");
INSERT INTO chfNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","No'on cälbenetla que tu pancabba niuntu ajt'an ta Dios más ajnoja que aj Juan ajc'ablesiaba, mach'an, pero desde badaba ni más ajch'och'ocaba que u sapän ochic tu manda Dios es más ajnoja une que aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jinq'uin u yubijob ca' jini upete ni gente y ajcojtaq'uinob u yäc'bi uba cuentajob cache' Dios u chen tu toja. Jin uc'a c'ablijob t'oc ni c'ablesia u chi aj Juanba. ");
INSERT INTO chfNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aj fariseojobba y machcatac u ye'e' ni ley mach u sapijob ni c'ajalin que Dios u yoli u yäc'benob uc'a mach u yäq'ui ubajob u c'ablesan aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","De ya'i Cajnojala u yäli ca'da: ―¿Cua' une u ch'e' cäle' que ca' jini ayanob ni gente ayan pancab badaba? ¿Cua' une u c'otejob t'oc? ");
INSERT INTO chfNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","U c'otejob t'oc ca' ni bijch'oc chumu tä cab tan bij tä alas u maläc joc'lan ubajob y u yäle'ob ca'da: “Custäbet t'ocob ämäy y mach a chila ac'ot. Cä c'äybet t'ocob ch'ocäl c'ay tajchäme y mach a chi uq'uela”. ");
INSERT INTO chfNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ca' chich jini täcä aj Juan ajc'ablesia juli y mach u c'uxi waj y mach u yuch'i vino y ane a wäle'la cache' u cänäntan tzuc pixan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","No'on que sutwänon de winicba julon pancab. Cä c'uxnan y cä buc'a y ane a wäle'la ca'da: “Chänenla untu winic mäx q'uen u c'uxnan y u chibälnan. Uneba mäx nämäjob t'oc ajcojtaq'uinob y ajcherajtanäjob”. Ca' jini a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Machcatac an q'uen u c'ajalin t'oc lo que u chenob u ye'e' cache' utz chich ni c'ajalin u cänäntanobba. ");
INSERT INTO chfNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","De ya'i untu aj fariseo u c'aba' aj Simón u yälbi aj Jesús xic tä c'uxnan t'oc une. Aj Jesús ochi tan yotot ni aj fariseo jini y t'elwäni tä mesa, uc'a che' chich nämäjob tä c'uxnan ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ajni untu ixic ixcherajtanä que cuxli tama ni caj jini. Jinq'uin u yubi cache' aj Jesús ya'an tä c'uxnan tu yotot ni aj fariseo, u täsi jätz'äcnib tama ump'e botella que pätqui de ni ji'tun u c'aba' alabastroba. ");
INSERT INTO chfNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","C'oti tä wa'tä tu pat bajca sätz'ä yoc u chen uq'ue. U t'ulesan u c'äbjut tu yoc y de ya'i u sucbi t'oc u tzuc y u tz'utz'ben yoc y u tatz'ben t'oc ni jätz'äcnib. ");
INSERT INTO chfNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jinq'uin u chäni ni aj fariseo u joq'ui tä c'uxnanba, u yäli tu c'ajalin uneba ca'da: “Si fuera mero ajt'an ta Dios ni winicda u chenica conoce machca une ni ixic que mu' u täle'ba, y cua'tac u chen, uc'a uneba ixcherajtanä”. ");
INSERT INTO chfNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","De ya'i aj Jesús u yälben ca'da: ―Simón, ya'an cua' cä xe cälbenet. Une u p'ali: ―Älä jiq'uin, Cajnoja. ");
INSERT INTO chfNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aj Jesús u yäli ca'da: ―Cha'tu winic u cherben debe untu machca u yäq'ue' tä q'uexcan u taq'uin. Untuba u cherben debe quinientos denarios y ni otro untuba u cherben debe cincuenta. ");
INSERT INTO chfNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mach'an cua' t'oc u toje'ob y une u chi perdona u cha'tumajob. Älbenon jiq'uin caxcamba de unejob u xe u yajna'tan más ni u yum ni taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aj Simón u p'ali ca'da: ―Cäle' que ni cherbinti perdona másba. Aj Jesús u yälbi ca'da: ―Toj chich a wäli. ");
INSERT INTO chfNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","De ya'i aj Jesús u suti u jut ca'an ni ixic y u yälben aj Simón ca'da: ―¿A chänen ni ixicda? Ochon tan a wotot y mach a wäc'bon ja' tuba cä poque' t'oc coc, pero uneba u poqui coc t'oc u c'äbjut, y u suqui t'oc u tzuc. ");
INSERT INTO chfNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aneba mach a tzucti'i cä c'äb, pero ni ixicda mach u yäcti u tz'utz'benon coc desde a'ochon. ");
INSERT INTO chfNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aneba mach a taybon cä pam t'oc loción, pero ni ixicdaba u taybon coc t'oc jätz'äcnib. ");
INSERT INTO chfNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jin uc'a cälbenet cache' a'uti perdona u noj q'uenel tanä u chiba uc'a mäx u yajna'tanon, pero jini machca u yute perdona tz'ita'ba, tz'ita' u yajna'tanon. ");
INSERT INTO chfNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","De ya'i u yälbi ni ixic ca'da: ―A tanä alaj uti perdona. ");
INSERT INTO chfNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Machcatac ya' chumca t'oc tä mesa u täq'uijob u maläc äle'ob ca'da: ―¿Caxcaba winic wäre ni jinda que u chen perdona täcä u tanä untu? ");
INSERT INTO chfNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","De ya'i u yälbi ni ixic ca'da: ―Uc'a a tz'oni, a japi chich aba. Corre cux, y mach a ni' chen pensa cua'. ");
INSERT INTO chfNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ji'pat aj Jesús numi tama upete noj caj y bit caj u tz'aycun u t'an Dios y u yäq'ue' tä ute conoce ni t'an utzba tuba u manda Dios. Ni doce winicob u yaquiba nämte' u numejob t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tulaj ayanob täcä t'oc une ixictacob, jini pa'säbinti tzuc pixan tuyac'ojobba, jini tz'äcälquijob t'oc yajba. Ajni ix María, u cab tä Magdala, uneba pa'säbinti siete tzuc pixan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ajni ix Juana, jit'oc aj Chuza, untu ajnoja tajpatan tuba aj Herodes. Ajni ix Susana y q'uen otrosob täcä que u yäc'bijob aj Jesús y ni doce u yajc'äncanob cua' chichca jini que u cänäntanob tuba u täclenob. ");
INSERT INTO chfNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","De ya'i u woyli ubajob noj q'uenel gente, y ya'to u tejob cada cabil cab tuba xicob ca'an aj Jesús. Une u ye'bijob u t'an Dios t'oc ump'e tz'aji ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Untu winic bixi u päq'ue' u päc'äbi. Mu'to u päq'ue'ba, ximaj yäli tan bij y ajnumejob u potz'ojteq'uijob, y ti ni mut u buq'ue'. ");
INSERT INTO chfNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ximaj yäli pan ji'tun cab y jinq'uin wetiba tiqui, uc'a mach ach' u caba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ximaj yäli tan ch'ix y ni ch'ixba nämte' ti tä ch'ije t'oc y u bisi yaba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ximaj yäli bajca an cab mejorba, y jinq'uin weti u c'ac'a' chi u jut. Por unxim que pä'quiba u yäq'ui cien u jut. Cuanta u tzupsi u yäle' aj Jesús ni jiniba, u chi ump'e noj t'an u yäle' ca'da: ―Machca u cänäntan u chiquin tuba u yubin c'änä chich u yäq'ue' u chiquin tuba u yubin cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","De ya'i u yajcänt'anob u c'atbijob cua' jini u yäle' ni tz'aji jini. ");
INSERT INTO chfNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Une u yäli ca'da: ―Anela äc'bintetla a wina'tanla cache'da an u manda Dios, jini mach bay älbinti niuntuba. Otrosjob u yälbinte t'oc tz'aji cache'da an u manda Dios, uc'a jinq'uin u chänen cua' cä chenba mach uxin u yäc'ben uba cuentajob cua' jini, y jinq'uin u yubinob cä t'an mach uxin u chen entendejob. ");
INSERT INTO chfNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ni tz'aji jini u c'ote t'oc ca'da: Ni semillaba es u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jini ximaj yäli tama bijba u c'otejob t'oc ca' machcatac u yubinob u t'an Dios y de ya'i u te ni tzuc pixan y u pa'säben ni t'an jini tu pixanob tuba mach u tz'onänob y u japän ubajob. ");
INSERT INTO chfNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jini ximaj yäli tu pam ji'tunba u c'otejob t'oc ca' machcatac que jinq'uin u yubinob u t'an Diosba u sapänob t'oc ch'a'aljin. Jindajob ca' a wälä ni päc'äbi jini que mach'an u wi'. U tz'onänob chap'e uxp'e q'uin, pero jinq'uin u yajtä cua' u bäc'tesanobba u sujtä tu pat. ");
INSERT INTO chfNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jini ximaj yäli tan ch'ixba u c'otejob t'oc ca' machcatac u yubinob. De ya'i u ch'e' u bijijob. Ji'pat u jobän uba u c'ajalinob uc'a cua' chichca jini que c'änä u chenob. Tä' yojob u cänäntan q'uen u taq'uin. Tä' yojob u ch'a'alesan ujin t'oc cua' chichca pancab. Más u yäq'ue' tu c'ajalinob ni jini que u t'an Dios. Ca' chich ni päc'äbi que u ch'ije tan ch'ixba mach u c'ä'na u jut, che' chich täcä unejob mach u tä' tz'onäjob. ");
INSERT INTO chfNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jini ximaj yäli bajca an ni cab utzba u c'otejob t'oc ca' machcatac ti'i u pixan y tomp'e u c'ajalin, y jinq'uin u yubinob u t'an Dios u laj äq'ue' tu pixanob y mach u yäcta u chenob cua' chichca utztacba. Ni jinijob es ca' a wälä ni päc'äbi que mach u yäcta jutinba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Machca u tz'äbe' ump'e candil mach bay u nuquí t'oc ump'e p'et. Mach u jup'u täcä tu yaba tz'en. U yäq'ue' tu pam u chumliba. Ca' jini machcatac u yoche tama ni ototba u ch'e' u chänen u c'ac'a. ");
INSERT INTO chfNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ca' chich jini täcä, mach'an niump'e cua' mucu que mach pojlintic ji'pat, y mach'an niump'e mucul t'an que mach ubcac y tz'ayquintic cua' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ubinla utz jiq'uin, uc'a machca chichca u cänäntan cua' chichca u xe tä äc'binte más y machca chichca mach u cänänta cua'ba, ixta lo que u chen pensa que u cänäntanba u xe tä pa'säbinte. ");
INSERT INTO chfNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","De ya'i c'oti u na' aj Jesús y jitz'inob bajca an, pero mach u chi trebe c'oticob ca'an une uc'a mäx net' net' t'oc noj q'uenel gente. ");
INSERT INTO chfNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Älbinti aj Jesús ca'da: ―A na' y a witz'inob ya'anob päti y yojob u chen t'an t'oc ane. ");
INSERT INTO chfNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Une u yälbijob ca'da: ―Machcatac u yubinob u t'an Dios y u tz'onänob, unejobba ca' a wälä ni cä na' y ni quitz'inob. ");
INSERT INTO chfNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","De ya'i ump'e q'uin aj Jesús ochi tama ump'e jucub t'oc u yajcänt'anob y u yälbijob ca'da: ―Cola tunxe nab. De ya'i pasijob ta bixicob. ");
INSERT INTO chfNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bixe to u chenobba, u q'uechi wäye aj Jesús. Tajtzäc pasi ump'e noj gran ic' tama ni nab y u täq'ui tule de ja' ni jucub. Por otro tz'ita'ba u jomesan. ");
INSERT INTO chfNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bixijob ca'an aj Jesús u p'isanob u yälbenob ca'da: ―¡Cajnoja, Cajnoja, acä chämola tä ja'! De ya'i p'ixi y u q'uejpi ni ic' y ni t'olja'. Ni ic' mach u ni' usti y ni t'olja' mach u ni' niqui uba. Colijob ch'ijcab. ");
INSERT INTO chfNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Une u yälbijob ca'da: ―¿Cua' uc'a mach a tz'ombonla? Unejob c'ac'a' bäc'tijob y ch'icwäni u jutob. U maläc äle'ob ca'da: ―¿Caxcaba winic wäreca ni jinda que ixta ic' y ja' u chen manda y u tz'omben u t'an? ");
INSERT INTO chfNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","De ya'i c'otijob tu cab aj gadarenojob, ni an tunxe nab tä Galileaba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jinq'uin t'äbo u chen tä cab u nuc'ti untu winic que ya' ti tama ni caj. Ni winic jini u cänäntan q'uen tzuc pixan tuyac'o. Anät'i q'uin que mach u ni' äc'ä u buc tuyac'o y mach ni' cuxu tan otot. Ni winic jini sec' bajca an u mucliba ajchämejob cuxu. ");
INSERT INTO chfNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jinq'uin u chäni aj Jesús, u chi awät y nocwäni tu pänte' u chen ump'e noj t'an u yäle' ca'da: ―¿Cuaxca a wo t'oc no'on, Jesús, ane u Yajlo'et ni mero Dios Ajnojaba? Cä cocoj c'atbenet que mach a tz'ibajtesanon. ");
INSERT INTO chfNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Une u yäli ca' jini uc'a aj Jesús san chich u yälbi ni tzuc pixan que pasic tuyac'o ni winic. Ajniba cua' chichca hora u q'ueche', y u cänäntinte cächä t'oc cadena, pero une u ch'äctuc'än ni cadena y ni tzuc pixan u bisan bajca mach cuxu niuntu. ");
INSERT INTO chfNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aj Jesús u c'atbi cuaxca u c'aba'. Une u yäli cache' aj Legión. Ca' jini u c'aba' uc'a q'uen tzuc pixanob ya'an tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","U ch'oc chi ubajob t'oc aj Jesús ni tzuc pixanob que mach u täscun xicob tu yajlibajob tama ni noj ch'en tä' tamba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ajni ya' jini noj q'uenel chitam que u c'uxnanob tu näc' ni tz'ic. Ni tzuc pixan u c'ac'a' c'atbijob aj Jesús que u yäctan ochicob tuyac'o ni chitam. U yäc'bijob chich ochicob tuyac'ojob ni chitam. ");
INSERT INTO chfNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","De ya'i ni tzuc pixanob pasijob tuyac'o ni winic y ochijob tuyac'ojob ni chitam. Jini u tomtä chitam jiniba t'oc noj ancäre jaquijob bajca chele ni tz'ic, bixijob tama nab y laj chämijob tä ja'. ");
INSERT INTO chfNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jinq'uin ajcänänchitamob u chänijob cua' ajni, pasijob tä putz'e u laj äle'ob tan caj y tä bij cua' u chi pasajob ni chitam. ");
INSERT INTO chfNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","De ya'i bixijob ni gente u chänenob cua' ajni y c'otijob ca'an aj Jesús. C'oti u pojlenob ni winic que ajnijob tzuc pixan tuyac'oba ya' chumca tu yoc aj Jesús u yubin u t'an. Ya'an u buc tuyac'o y tz'äcä u c'ajalin. C'ac'a' bäc'tijob ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Machcatac u chänijob cache'da tz'äcälqui jini winic u cänänti tzuc pixan tuyac'oba u tz'aycäbijob ni ajc'otejobba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","De ya'i upete ni gente tama upete ni cabil cab jini tuba aj gadarenojob u cocoj älbijob aj Jesús que u tz'eje' uba t'oc unejob, uc'a u c'ac'a' q'uechijob noj gran bac'ät. De ya'i aj Jesús ochi tama ni jucub y sutwäni cha'num bajca ati. ");
INSERT INTO chfNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ni winic que pasi tzuc pixan tuyac'oba u ch'oc chi uba t'oc aj Jesús u c'atben si u ch'e' colac nämte' t'oc une, pero aj Jesús u täsqui bixic u yälben ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Suti' ta' wotot y tz'aycäbenob cache' ac'ä mäx q'uen cua' chichca u chi Dios por ane. De ya'i une bixi u laj tz'aycun tama entero ump'e ni caj cache' ac'ä mäx q'uen cua' chichca u chi aj Jesús por une. ");
INSERT INTO chfNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jinq'uin sutwäni aj Jesús bajca chich ajniba ni noj q'uenel gente u chi recibijob t'oc ch'a'aljin uc'a upetejob ya'an u pitänob. ");
INSERT INTO chfNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","De ya'i untu winic u c'aba' aj Jairo, ajnoja tama ni ch'uj taj judíosob, c'oti tä noctä tu yoc aj Jesús u ch'oc chen uba t'oc u yälben que xic tu yotot, ");
INSERT INTO chfNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","uc'a u cänäntan untuntu jixic ch'oc de doce año u edad, y chämo u chen. Bixe u chen aj Jesús y noj q'uenel gente u net'e'ob bajca u bixe tä xämba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ajni tama ni gente untu ixic que u cänäntan doce año c'ojo t'oc ump'e yaj de ch'ich', y mach u chunwan ni ch'ich'. U laj säti upete u taq'uin t'oc ajtz'acob y mach u chi trebe u tz'äcälin niuntu. ");
INSERT INTO chfNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ni ixic jini ti tu pat aj Jesús u tälben u ti' u buc, y jinchichba hora que u tälbiba chunwäni ni ch'ich'. ");
INSERT INTO chfNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","De ya'i aj Jesús u yäli ca'da: ―¿Caxca u tälon? Jinq'uin upete u yälijob que unejob mach u täli, aj Pedro y u lotob u yälijob ca'da: ―Cajnoja, mäx q'uen ni gente ya'anob junxoyma de ane u net'e'et, ¿y aneba a c'atän caxca u tälet? ");
INSERT INTO chfNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero aj Jesús u yäli ca'da: ―Ajni untu machca u tälon, uc'a cuwi chich cache' pasi täjcac'o poder. ");
INSERT INTO chfNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jinq'uin ni ixic u chäni cache' mach u ch'ä colac mucu, t'oc chicchicne c'oti tä noctä tu yoc aj Jesús u laj äle' tu pänte' upete ni gente cua' uc'a u täli, y cache' jinchichba hora jini u yäq'ui uba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","De ya'i aj Jesús u yälbi ca'da: ―Cä ch'oc, uc'a a tz'ombon, a wäq'ui aba. Corre cux y ajnic ch'ijcab a c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jinq'uin mu'to u t'an aj Jesús c'oti untu winic que ya' ti tu yotot aj Jairo, ni ajnoja tuba ni ch'uj taj judíosob. U yälbi aj Jairo ca'da: ―San achämi a wixic ch'oc. Mach a ni' jaq'uesben ujin Cajnojala. ");
INSERT INTO chfNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jinq'uin u yubi aj Jesús cua' mu' u yälcan u yälbi aj Jairo ca'da: ―Mach bäc'taquet, toc'a a tz'ombenon y u xe u pojlen uba. ");
INSERT INTO chfNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jinq'uin c'oti aj Jesús tu yotot aj Jairo, mach u yäcti ochic niuntu t'oc une seq'uen aj Pedro, aj Jacobo, aj Juan, y u pap y u na' ni yoc ixoc. ");
INSERT INTO chfNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Upetejob u yuc'tanob u chen uq'uel awätob, pero aj Jesús u yälbijob ca'da: ―Mach a chen uq'uela uc'a mach chämen ayan, wäye u chen. ");
INSERT INTO chfNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Unejob u tze'tanob uc'a yuwijob chich que chämen ayan. ");
INSERT INTO chfNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero aj Jesús u q'uechbi tu c'äb y t'oc noj t'an u yälbi ca'da: ―Xoc, ch'oyen. ");
INSERT INTO chfNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sutwäni chich u pixan tuyac'o y seb ch'oyi. De ya'i aj Jesús u yälbijob que u yäc'ben cua' u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","U pap y u na' tajch'icwäni u jutob, pero aj Jesús u yälbijob que mach u yälben niuntu cua' u chi. ");
INSERT INTO chfNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","De ya'i u joq'ui ni doce u yajcänt'anob y u yäc'bijob poder tuba u chen trebe u pa'senob upete tzuc pixanob tuyac'o machcatac u cänäntan y tuba u tz'äcälin ni gente t'oc cua' chichca yaj jini u cänäntanobba. ");
INSERT INTO chfNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","De ya'i u täsqui bixicob u tz'aycunob cache'da an u manda Dios, y u tz'äcälin ajc'ojpanob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","U yälbijob ca'da: ―Mach a bisanla niump'e cua' tä bij, ni xojte', ni morral, ni waj, ni taq'uin, y mach a bisanla chap'e a bucla. ");
INSERT INTO chfNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Cachichcamba otot ochiquetlaba colenla ya'i ixta que mach bixiquetla. ");
INSERT INTO chfNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Cachichcada que mach yo u yosenetla, jinq'uin a xe tä pasela tama ni caj jini ticän ni pupujcab ya'an ta' woclaba tuba subcacob t'oc, uc'a ca' jini a xe a ye'e'la que ni caj jini mach u yolijob u tz'onän lo que a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","De ya'i pasijob y bixijob tä cabil cab u tz'aycunob cachichcada ni t'an utzba cache'da an u manda Dios, y u tz'äcälin ajc'ojpanob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ni rey aj Herodes jinq'uin u yubi cua'tac u chi aj Jesús, u jobi uba u c'ajalin, uc'a ya'an machca u yäle'ob cache' c'äsi' aj Juan acuxpi tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Otrosjob u yälijob cache' ni ajt'an ta Dios aj Elías ajuli tä cha'num y otrosjob u yälijob cache' untu ajt'an ta Dios cuxli oniba acuxpi tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","U yäli aj Herodes ca'da: ―No'on cäq'ui tä chunjätz'binte u pam aj Juan. ¿Caxca une ni winic jini jiq'uin que acubin u chen cua' chichca jini? Une tä' u yoli u chänen aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jinq'uin sutwänijob tä cha'num ni ajc'äncanob bajca an aj Jesús u yälbijob cua'tac u chijob. De ya'i u ch'i u yajc'äncanob u tz'eji ubajob t'oc sec' unejob. Bixijob ump'e lugar bajca mach cuxu niuntu nätz'ä t'oc ump'e caj u c'aba' tä Betsaida. ");
INSERT INTO chfNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jinq'uin ni noj q'uenel gente u yubijob cache' ya'anob ya'i u tzäc'bijob u pat. Aj Jesús u yosijob bajca an y u yälbijob cua' an bajca u chen manda Dios, y u tz'äcäli machcatac c'änä uc'a tz'äcälcacob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jinq'uin pome u chen q'uin ni doce u yajc'äncanob c'otijob u yälbenob ca'da: ―Täscun bixicob ni gente uc'a xicob tä cabil cab y tä otote nätz'äba tuba u pojlen posa'a tuba wäyicob y tuba u sacän cua' u c'uxe'ob, uc'a wida bajca anonlaba mach'an otote. ");
INSERT INTO chfNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aj Jesús u yälbijob ca'da: ―Äc'benla anela cua' u c'uxe'ob. Unejob u yälijob ca'da: ―Sec' cinco waj namás y cha'tu yoc buch' cä cänäntan t'ocob. Jinda mach u yäc'ä tuba upete ni genteda si mach bixicon cä mäne' t'ocob cua' u xe u c'uxe' ni gentejobda. ");
INSERT INTO chfNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","U q'ue'najob ni gente jini, ca' tuba cinco mil ajni seq'uen winicob. De ya'i u yälbi u yajcänt'anob ca'da: ―Äc'ben chunwänicob a cincuenta a cincuentajob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ca' chich jini u chijob, u yäc'bijob chunwänic upetejob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","De ya'i aj Jesús u ch'i ni cinco waj y cha'tu buch' y u t'äbsi u jut isqui tä cielo u ch'u'ul chen ni waj. U taji y u yäc'bijob u yajcänt'anob tuba u yäc'benob ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Laj c'uxnijob upete y laj na'ijob. De ya'i u woyijob doce chach u colob ni waj y buch'. ");
INSERT INTO chfNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ji'pat ya'an aj Jesús tä c'änti'ya c'äsmucu y u yajcänt'anob ya'an t'oc une. Jinq'uin u tzupsiba, u c'atbijob ca'da: ―¿Caxcajon no'onba u yäle'ob ni gente? ");
INSERT INTO chfNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Unejob u p'alijob ca'da: ―Aj Juanet, a'i, ni ajc'ablesiaba. Otrosjob u yäle' cache' aj Elíaset, y otrosjob u yäle' cache' aneba untu ajt'anet ta Dios que ajni oniba y bada acuxpet tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","De ya'i u yälbijob ca'da: ―¿Caxcajon a wäle' anelaba? Aj Pedro u p'ali ca'da: ―Ane ni Cristojet, ni u yaquet Dios tuba ajmandaba. ");
INSERT INTO chfNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","De ya'i aj Jesús u c'ac'a' älbijob que mach u yälbenob niuntu si une chich ni aj Cristo. ");
INSERT INTO chfNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","U yälbijob ca'da: ―No'onba que sutwänon de winic c'änä c'ac'a' tz'ibajtescacon. Ajt'äbälajob, u no' ajnojajob pale y machcatac u ye'e' ni ley u xe u yänäl chänenon. Cä xe tä tzämsinte y u yuxp'elib q'uin cä xe tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ji'pat aj Jesús u yälbi upetejob ca'da: ―Si ayan machca chichca de anela que a wo a ch'e' ni bij täc'aba, c'änä a wäctan a chen aba manda a juntuma y a täq'ue' a chen ca' chich co no'onba. C'änä a c'älenla upete q'uin cua' chichca tz'ibajtesia que a wäc'binte uc'a a tz'ombenon. Es ca' a wälä mach a bäc'ta a chen sufri ca' chich u chen sufri untu tuyac'o cruz. ");
INSERT INTO chfNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Uc'a upete machca yo u chen uba manda u juntuma u xe tä säto, y upete machca u yäq'ue' uba täj c'äb tuba cä chen mandaba, une u japän uba. ");
INSERT INTO chfNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Cuaxca u pa'se t'oc untu winic si u laj chen gana upete cua' chichca ayan pancab, y uneba u nonoj säto u pixan? ");
INSERT INTO chfNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Uc'a machca u quisnäjan t'oc no'on y uc'a ni cäle'ba, no'on que sutwänon de winicba cä xe tä quisnäjan t'oc une täcä jinq'uin cä xe tä te y u xe tä chäninte cä pitzilan, y u pitzilan cä Pap y u pitzilan ni ch'u'ul ángelojob ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cä totoj älbenetla que tulaj ayan widaba machcatac que mach uxin tä chämo ixta que mach u chänenob najtäcä u manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","U cänäntan ca' tuba ocho día ji'pat de ni t'anda que u chi aj Jesúsba, u bisijob aj Pedro, aj Juan y aj Jacobo y t'äbi tu pam ump'e tz'ic tuba u chen c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jinq'uin mu'to u chen c'änti'ya u yäni uba u jut y u buc sutwäni säc y c'äntz'alan. ");
INSERT INTO chfNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tajtzäc u chänijob cache' ya'an cha'tu winic u chen t'an t'oc une, untu aj Moisés y ni otro untuba aj Elías. ");
INSERT INTO chfNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tutz'ijob t'oc ump'e noj junch'äcni junxoyma de unejob, y u chi t'anob u yäle'ob cache' aj Jesús u xe tä tzämsinte tä Jerusalén antes de bixic tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aj Pedro y upetejob machcatac ya'an t'oc une tä' yojob wäye, pero mach chich uwayob, y u chänijob u pitzilan aj Jesús y u chänijob ni cha'tu winic que ya'anob t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jinq'uin ni winicob jini mu'to u tz'eje' ubajob t'oc aj Jesús, aj Pedro u yälbi ca'da: ―Cajnoja, utz chich ajniconla wida. Cola cä chenla uxp'e boch': ump'e ta'a, ump'e taj Moisés y ump'e tuba aj Elías. Aj Pedroba mach yuwi cua' u yäli. ");
INSERT INTO chfNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jinq'uin mu'to u yäle' ni t'anda jaqui ump'e bucla bajca anob y u laj bälijob. Tu yochejob tama ni bucla bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","De ya'i ubqui ump'e t'an tama jini bucla que Dios u yäle' ca'da: ―Jinda cä yajben Ajlo'. Ubinla u t'an uneba. ");
INSERT INTO chfNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jinq'uin ch'ijcäbi ni t'an u chänijob cache' aj Jesús coli u juntuma. Unejob mach u tz'ayqui ni tz'ita' y mach u yälbi niuntu jimba q'uinob jiniba cua'tac u chänijob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","De ya'i päscab, jinq'uin jaquijob bajca ajnijob tu pam ni tz'ic, pasijob noj q'uenel gente u nuc'tanob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tajtzäc untu winic tama ni gente u chi noj t'an ca'da: ―Maestro, tä' coba que a wiran cajlo'. Uneba untuntuba cajlo' cä cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","U taj tutz'e untu tzuc pixan u q'ueche' y tajtzäc u chen awät jini cajlo', y u cucän tä cab ni tzuc pixan u yäc'ben u chen u yomti'. U c'ac'a' c'ojpesan y a la fuerza u tz'eje' uba t'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cälbijob a wajcänt'anob que u pa'säbenob tuyac'o, pero mach u chi trebe u chenob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","U p'ali aj Jesús u yälben ca'da: ―¡Anela que ayanetla pancab badaba mach a tz'onäla cua' y mach utz cua' a chenla! ¿Ixta ca ti q'uin cä xe tä ajtä t'oc anela y ajnic sis cä c'ajalin t'oc anela tuba a tz'onänla? Täsen a wajlo' wida. ");
INSERT INTO chfNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jinq'uin ya'to u te ni yoc ajlo' ni tzuc pixan u juli tä cab y u c'ac'a' cuqui. De ya'i aj Jesús u q'uejpi ni tzuc pixan, u tz'äcäli ni yoc ajlo' y u sutjatz'bi u pap. ");
INSERT INTO chfNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Upetejob tajch'icwäni u jutob u chänenob cua'tac u ch'e' u chen Dios. Upetejob ju'lawujob to uc'a u chänijob upete cua'tac u chi aj Jesús, jinq'uin une u yälbi u yajcänt'anob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Äc'ä a chiquinla tuba a c'alin ubinla ni cä xe cälbenetlaba: No'on que sutwänon de winicba cä xe tä ä'can tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero unejob mach u chi entendejob ni t'an jini. Ca' a wälä u yälbijob ump'e bälä' t'an tuba mach u chen entendejob, y bäc'tajob u c'atben cuaxca u yäle' upete ni t'an u yäliba. ");
INSERT INTO chfNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","De ya'i u täq'uijob najcänt'anob u maläc c'atänob caxca une wäreca de unejob más ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aj Jesús, uc'a yuwi chich cua' mu' u yäle' tan u c'ajalinob, u ch'i untu ch'oc u yäq'ue' tu ch'ejpa une. ");
INSERT INTO chfNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","U yälbijob ca'da: ―Machca chichca u sapän ni ch'ocda que u tz'ombenon cä c'aba', es ca' a wälä no'on u sapänon täcä, y machca chichca u sapänon no'onba, ca' a wälä u sapän machca u täsconba täcä, uc'a ni más ajch'och'oca de anelaba, une chich ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","De ya'i aj Juan u yäli ca'da: ―Maestro, cä chäni t'ocob untu que u c'ajti'benet a c'aba' jinq'uin u pa'sen tzuc pixan tuyac'o machca chichca jini, y no'on t'ocobba mach cä ni' äc'bi t'ocob u chen, uc'a une mach ayan t'oc no'on t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aj Jesús u yälbi ca'da: ―Mach a wälben que mach u ch'ä u chen ca' jini, uc'a machca mach u julu uba täjcac'olaba, t'oc no'onla ayan une. ");
INSERT INTO chfNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jinq'uin u chen tä tz'äctan q'uin tuba bixic isqui tä cielo, yuwi chich que c'änä bixic tajtoj tä Jerusalén, y bixi chich. ");
INSERT INTO chfNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","U täsqui u yajc'äncanob bixic pänte' bajca u xe tä nume. Unejob bixijob y ochijob tama ump'e caj tuba aj samaritanojob tuba u tuse'ob bajca u xe tä colan aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ni aj samaritanojob jini mach u yosijob tan u cäji uc'a yuwijob cache' aj Jesús ya' u xe tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jinq'uin u yajcänt'anob aj Jesús, jini u c'aba' aj Jacobo y aj Juanba, u chänijob ca' jini u yälijob ca'da: ―Cajnoja, ¿a wo quira cä chen manda t'ocob que tic c'ac' tä cielo y yälic tuyac'ojob u laj pule'ob, ca' chich u chi aj Elías oni? ");
INSERT INTO chfNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","De ya'i aj Jesús u suti uba u q'uejpanob u yäle' ca'da: ―Anela mach a wila caxcamba pixan u yäc'benet a wäle'la ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Uc'a no'on que sutwänon de winicba mach aton tuba cä'ben sätic u pixan winicob, aton tuba cä japänob. De ya'i bixijob otro caj. ");
INSERT INTO chfNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jinq'uin bixe u chenob tä bij untu winic u yälbi ca'da: ―Cajnoja, acä tzäypätinet cachichcada xiquet. ");
INSERT INTO chfNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aj Jesús u yälbi ca'da: ―A'uch ayan u ch'ena y mutob an u c'ub, pero no'on que sutwänon de winicba mach cä cänänta niump'e cotot bajca u ch'e' wäyicon no'on. ");
INSERT INTO chfNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","U yälbi aj Jesús otro untu ca'da: ―Tzäypätinon. Une u yälbi ca'da: ―Cajnoja, äctanon xicon cä muque' cä pap najtäcä. ");
INSERT INTO chfNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aj Jesús u yälbi ca'da: ―Äctan u muque' u yajchämejob jini machcatac mach äc'binti paq'uin cuxlecob, jini ca' a wälä ajchämejobba. Aneba, xiquet a tz'aycun cache'da an u manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Otro untu u yäli täcä ca'da: ―Cajnoja, co cä tzäypätinet, pero äctanon xicon najtäcä cälbenob machcatac ya'an täj cotot que acä bixe. ");
INSERT INTO chfNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Aj Jesús u yälbi ca'da: ―Machca u chen ara ump'e cab y yo u bisan tajtoj ni aradoba, mach u ch'ä u sutän u jut tu pat ―aj Jesús u yälbi ca' jini tuba tic tu c'ajalin cache' c'änä ajnic tomp'e u c'ajalin machca yo u cherben u patan Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ji'pat de ni jinda Cajnojala u yaqui otros setenta winicob y u täsquijob bixic najtäcä bajca u xe tä nume uneba täcä. A chacha'tu u täsquijob cada caj y upete cabil cab bajca u xe uneba ji'pat. ");
INSERT INTO chfNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jinq'uin mach to bixjobba aj Jesús u yälbijob ca'da: ―Q'uen ayan machcatac u xe u tz'ombenon, pero mach jäytu ayan machcatac u tz'aycun cä t'an. Es ca' a wälä jinq'uin u c'ä'nan ump'e cho y ni ajc'ajbajob mach u che trebe u laj c'aje' uc'a mach jäytujob. Ca' chich u yum ni cho u täscun ajpatanob u laj c'aje' ni cho, ca' jini c'atbenla Dios que u täscun machcatac u xe u tz'aycäbenob cä t'an ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Corre cuxla. Ubixtola, cä täscunetla a tz'aycunla cä t'an bajca an winicob que mach yo u chänenetla, jini machcatac ca' a wälä ajlobo. Anelaba ca' a wälä ch'oc ovejajetla y unejob u xe u yolinob u tzämsenetla ca' ni ajlobo u tzämsen ni ch'oc oveja. ");
INSERT INTO chfNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mach a bisanla ch'uji' taq'uin, ni morral, ni pächi'oc, y niuntu mach a lotän tä tz'aji tä bij. ");
INSERT INTO chfNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cachichcamba otot ochiquetla, najtäcä a wäle'la ca'da: “Que Dios u yäc'benetla ajnic a wutzila tama ni ototda”. ");
INSERT INTO chfNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Si ajnic ya' jini untu que tä' yoba u yubin cache' u ch'e' ajnic sis u c'ajalin Dios t'oc une, une u xe u sajbenet a t'anla. Si mach'an machca yo u yubin cache' u ch'e' ajnic sis u c'ajalin Dios t'oc uneba, mach u sajbet a t'anla. ");
INSERT INTO chfNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Colenla tama jinchichba otot que ochiquetla y c'uxula y uch'enla lo que u yäc'benetla u yum ni otot, uc'a najpatan c'änä tojcac lo que u chen gana. Mach numiquetla tä otote a sacänla otro posa'a. ");
INSERT INTO chfNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cachichcamba caj ochiquetla y ajnic machca u yosenetlaba, c'uxula lo que u yäc'benet a c'uxe'la. ");
INSERT INTO chfNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tz'äcälinla najc'ojpanob que ayan ya' jiniba y älbenob ca'da: “Ac'oti q'uin tuba u chen manda Dios bajca anetla”. ");
INSERT INTO chfNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Cachichcamba caj ochiquetla y mach ajnic machca u yosenetla, numenla tä callejob tan ni caj jini y äläla ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ixta ni pupujcab tan a cäjila que u tz'uyi coc t'ocobba, cä ticän t'ocob tuba subcaquetla t'oc, pero wina'tanla cache' ac'oti q'uin tuba u chen manda Dios bajca anetla”. Ca' jini a xe a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Cälbenetla cache' jinq'uin u xe tä c'ote q'uin que Dios u yäc'ben u toje' u tanä a'ajtäjob pancab, ni gente que ajnijob tama ni caj tä Sodoma más tz'ita' u xe tä äc'binte u toje' u tanä que ni gente tama ni caj jiniba. ");
INSERT INTO chfNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ac'ä mäx q'uen ni castigo ta'ala anela tä Corazín! ¡Ac'ä mäx q'uen ni castigo ta'ala anela tä Betsaida! Si fuera utic ica oni tama ni cajob tä Tiro y tä Sidón cua' chichca tuba chänintic u poder Diosba, ca' chich uti tama a cäjila, unejobba seb chunwänijob ica tu pam tz'i'tan y u xojijob ica u bucob de costal tuyac'o tuba u ye'e' cache' u q'uexi u c'ajalinob tuba mach u ni' chen u tanäjob. ");
INSERT INTO chfNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jin uc'a, jinq'uin u xe tä c'ote u q'uini toji'tanä, más tz'ita' u xe tä äc'binte u toje' u tanäjob ni gente tä Tiro y tä Sidón que anela. ");
INSERT INTO chfNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Anela tä Capernaum, ¿a wäle'la quira cache' más utzetla que niump'e caj tu jut Dios? Cälbenetla que anela con to'o a cäjila a xe tä xupola t'oc quisinle. ");
INSERT INTO chfNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","U chi segui u yälben jini setenta u yajcänt'anob ca'da: ―Machca u yubin a t'anlaba, no'on une u yubin cä t'an täcä. Machca tz'eje u nume t'oc anela, tz'eje u nume t'oc no'on täcä, y machca tz'eje u nume t'oc no'onba tz'eje u nume t'oc Dios, ni u täsconba. ");
INSERT INTO chfNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sutwänijob ni setentajobba jini t'oc ch'a'aljin bajca an aj Jesús y u yäle'ob ca'da: ―Cajnoja, ixta ni tzuc pixan u tz'ombenon cä manda t'ocob uc'a cä c'ajti'in t'ocob a c'aba' aneba. ");
INSERT INTO chfNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aj Jesús u yälbijob ca'da: ―Toj chich une, no'on cä chäni chich aj Satanás que ya' ti isqui tä cielo ca' a wälä u lem chawäc tajjäplaw yäli tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ubixtola, no'on cä'betla poder a xac'äjteq'ue'la chan y sina, y a tzupsäben upete u muc' jini que mach yo u chänenetlaba, y niump'e cua' mach uxin u cherbenetla cua' chichca mach utzba. ");
INSERT INTO chfNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero mach a ch'a'alesan ajinla uc'a ni tzuc pixanob u tz'ombenetla a manda. Ch'a'alesan ajinla uc'a a c'aba'la ya' tz'ibi ayan tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jinchichba hora jini ni Ch'u'ul Pixan u yäc'bi ch'a'alac ujin aj Jesús. Y aj Jesús u yäli ca'da: ―No'on cä'benet uc'adios cä Pap, Ajnojalet tä cielo y tu pancab, uc'a a mucbijob ni cosajobda machcatac q'uen u c'ajalinob, machcatac mäx yuwijob cua' chichca, y a chectesbijob bijch'oc. Utz'an cä Pap, uc'a ca' jini a woli a chen. ");
INSERT INTO chfNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Cä Pap u yäc'bon upete cua' chichca täj c'äb. Niuntu u juntuma u ch'e' yuwina'tan caxcajon no'onba; cä Pap namás yuwi. Y niuntu u juntuma u ch'e' yuwina'tan caxcamba cä Pap; no'on namás cuwi. U ch'e' yuwina'tanob täcä caxcamba cä Pap jini machcatac co cä'ben yuwina'tanobba. ");
INSERT INTO chfNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","De ya'i u suti u jut bajca an u yajcänt'anob u yälbenob u juntumajob ca'da: ―Ch'a'a ajinla ane uc'a mu' a chänenon y cua'tac acä chen. ");
INSERT INTO chfNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Uc'a cälbenetla cache' q'uen ajt'anob ta Dios oni y ajnojajob que u chi mandajob tan a cabla u yolijob u chänenon ca' chich ane mu' a chänenonla y mach u chänonob. U yoli u yubinob cä t'an ca' chich ane mu' a ubinla cä t'an y mach u yubijob. ");
INSERT INTO chfNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","De ya'i untu winic machca yuwi leyba, wa'wäni u jiran cache' u p'alän aj Jesús uc'a u ch'e' u sube'. U c'atbi ca'da: ―Maestro, ¿cua' c'änä cä chen tuba paq'uin cuxlecon? ");
INSERT INTO chfNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aj Jesús u p'albi ca'da: ―¿Cua' une tz'ibi ayan tan ni ley? ¿Cache'da a tzique' ane? ");
INSERT INTO chfNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Une u p'ali ca'da: ―“C'änä a yajna'tan a Wajnoja Dios con to'o a ch'a'aljin, con to'o a pixan, con to'o a muc' y con to'o a c'ajalin, y c'änä a yajna'tan a lot ca' chich a yajna'tan aba”. ");
INSERT INTO chfNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aj Jesús u yälbi ca'da: ―Utz chich a p'ali. Chen ni jinda, y a xe tä paq'uin ajtä cuxu. ");
INSERT INTO chfNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero une mach u yoli u säte' t'oc u t'an y u yälbi aj Jesús ca'da: ―¿Caxca une ni cä lot? ");
INSERT INTO chfNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aj Jesús u p'ali ca'da: ―Untu winic ti tä isquil cab tä Jerusalén, jaqui tä Jericó y u q'uechijob ajxuch'. U jajbijob u buc, u bon cunijob u choc tzämsijob, y de ya'i u yäctijob ca' jini y bixijob. ");
INSERT INTO chfNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ji'pat, u chi pasa que jaqui jimba bij jini untu pale, y jinq'uin u chäni, numi tunxe bij u jelän. ");
INSERT INTO chfNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Che' chich täcä untu aj levita, jinq'uin c'oti nätz'ä ya' jini, u chäni, y numi tunxe bij u jelän. ");
INSERT INTO chfNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero untu winic u cab tä Samaria que bixe u chen tu biji c'oti nätz'ä bajca an jini winic, y jinq'uin u chäni u ch'ämbi yajin. ");
INSERT INTO chfNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bixi u natz'än u bäc'ben u yaj y u colben tama u yaj aceite y vino. De ya'i u yäq'ui tu pat u tzimim y bixi t'oc ca'an ump'e otot bajca u chen posa untu y u c'alin cänänti. ");
INSERT INTO chfNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Päscab jinq'uin bixe u chen u pa'si chap'e taq'uin u c'aba' denario, u yäc'bi u yum otot y u yälbi ca'da: “Cänäntäbenon ni ajc'ojpanda, y upete lo que a chen gasta de másba, täc sujtä cä xe cä tojbenet”. ");
INSERT INTO chfNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","De u yuxtumajob de ni jinijobba, ¿caxcamba a wäle' ni mero u lot tuba ni jini u q'uechijob ajxuch'ba? ");
INSERT INTO chfNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ni winic yuwi leyba u yälbi ca'da: ―Jini machca u ch'ämbi yajin. De ya'i aj Jesús u yälbi ca'da: ―Corre cux, chen ca' chich jini täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jinq'uin bixe to u chenob tä bij aj Jesús ochi tama ump'e caj y untu ixic u c'aba' ix Marta u yosi tan yotot. ");
INSERT INTO chfNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ni ixicda u cänäntan untu u jitz'in u c'aba' ix María. Ix María chunwäni tu yoc aj Jesús u yubin u t'an. ");
INSERT INTO chfNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ix Martaba mäx q'uen u patan y c'oti u natz'än aj Jesús u yälben ca'da: ―Cajnoja, ¿a wäle' quira que utz cua' u chi quitz'in, u yäcton cä juntuma cä laj chen ni patan? älben jiq'uin que u täclenon. ");
INSERT INTO chfNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aj Jesús u p'albi ca'da: ―Marta, Marta, mäx a chen pensa y mäx jac' ajin uc'a q'uen cua' chichca a chen. ");
INSERT INTO chfNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Namás ump'emp'e cosa c'änä a chen. Ix María u yaqui jini más rete utzba. Jini u yaqui uneba niuntu mach uxin u pa'säben. ");
INSERT INTO chfNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Unnum aj Jesús ya'an u chen c'änti'ya ump'e lugar, y jinq'uin u tzupsiba untu u yajcänt'an u yälbi ca'da: ―Cajnoja, ye'benon t'ocob cache' u yute c'änti'ya ca' chich aj Juan u ye'bi u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Une u yälbijob ca'da: ―Jinq'uin a chen c'änti'yala, äläla ca'da: Cä Pap, bajca anet tä cielo, ch'u'ul ajnic a c'aba'. La'ix de Ajnoja, utic ca' chich a wo, cama' tä cielo, che' chich täcä pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Benon t'ocob bada cä pa' waj cama' upete q'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chen perdona cä tanä t'ocob uc'a no'on t'ocob täcä cä chen perdona t'ocob upete machcatac u säte' t'oc no'on t'ocob. Mach a wäq'ue'on cä chen cä tanä t'ocob. Tz'eje'on t'ocob t'oc jini mach utzba. ");
INSERT INTO chfNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aj Jesús u yälbijob täcä ca'da: ―Si untu de anela ajnic untu a lot y xiquet ca'an tänxin ac'äb y a wälben ca'da: “Cä lot, äc'benon cä majnan uxq'ue waj, ");
INSERT INTO chfNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","uc'a untu camigo que bixe u chen tä viaje numi täj cotot y mach'an cua' cä'ben u c'uxe'”. ");
INSERT INTO chfNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Desde tan otot u xe u p'alän ca'da: “Mach ajniquet a lotänon uc'a ni ti' otot mäcä ayan y cä bijch'oc ya'anob nämte' t'oc no'on tan cä wäyiba. Mach u ch'ä ch'oyicon cä'benet”. ");
INSERT INTO chfNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","De ya'i u yäli aj Jesús ca'da: ―No'on cälbenetla que mach uxin tä ch'oye u yäc'ben ni waj aunque es u yamigo. Pero u xe chich tä ch'oye u yäc'ben cua' chichca c'änä uc'a, uc'a u bon c'atben. ");
INSERT INTO chfNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y no'on cälbenetla ca'da: Bon c'atbenla Dios cua' chichca jini y une u xe u yäc'benetla chich. C'änä a chenla ca' u chen machca u bon sacän cua' chichca ixta que mach u pojlen, y Dios u xe u yäc'benetla chich lo que a c'atbenlaba. C'änä a chenla ca' u chen machca u bon jätz'e' ti' ump'e otot ixta que mach jäbbintic, y Dios u xe u yäc'benetla chich lo que a c'atbenlaba. ");
INSERT INTO chfNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Uc'a upete machca u c'atänba u yäc'binte chich, y machca u sacän u pojlen, y machca u jätz'e' ti' otot u xe tä jäbbinte. ");
INSERT INTO chfNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Si a wajlo' u c'atbenet u pa' wajba, a xe quira a wäc'ben ump'e ji'tun? Mach une. ¿Si u c'atbenet untu u pa' buch', en lugar de buch'ba, a xe quira a wäc'ben untz'it chan? Mach chich täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O si u c'atbenet ump'e u pa' säctoc'ba a xe a súbben quira untu sina? Mach chich uxet a chenla ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Anela malojetla y a wila chich cache' u ch'e' a wäc'benla a bijch'ocla cua' chichca jini utztacba. ¿Mach quira cä Papla Dios täcä más u xe u yäc'ben Ch'u'ul Pixan machcatac u c'atben? ");
INSERT INTO chfNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","De ya'i ya'an aj Jesús u pa'sen untu tzuc pixan tuyac'o untu winic que u colesi a'uma'. Jinq'uin pasi ni tzuc pixan tuyac'o ni a'uma', u chi t'an y ni gente tajch'icwäni u jutob u chänen. ");
INSERT INTO chfNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yebe de unejob u yälijob ca'da: ―Une u pa'sen tzuc pixan tuyac'o untu uc'a aj Beelzebú, jini ajnoja tuba tzuc pixanob, u yäc'ben u poder. ");
INSERT INTO chfNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Otrosjob, tuba ajnic cua' t'oc u sube'job, u c'atbijob que u ye'benob ump'e seña que u te tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero une yuwi cua' an tu c'ajalinob y u yälbijob ca'da: ―Cachichcamba rey u xe tä xupo bajca u chen manda si jini machcatac u chen mandaba u jec'lan ubajob tä buya, y tan ump'e otot bajca u jec'lan ubajob tä buya mach u ni' ch'ä ajnicob tomp'e. ");
INSERT INTO chfNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Si jini machcatac ya'an t'oc aj Satanásba u jec'lan ubajob tä buya, mach u ni' ch'ä u chen mandajob tomp'e. Jinda cälbenetla uc'a anela a wäle'la cache' cä pa'sen tzuc pixan tuyac'o untu uc'a aj Beelzebú u yäc'benon poder. ");
INSERT INTO chfNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Si no'on cä pa'sen tzuc pixan tuyac'o untu uc'a aj Beelzebú u yäc'benon ni poderba, ¿caxca une jiq'uin u yäc'ben poder a wajcänt'anla tuba u pa'sen tzuc pixan? Jin uc'a unejob chich u xe u ye'benetla cache' mach toj cua' a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero si no'on cä pa'sen tzuc pixan tuyac'o untu uc'a Dios u yäc'benon poderba, ca' jini u ch'e' a wina'tanla que Dios u täq'ui bada u chen manda bajca anetla. ");
INSERT INTO chfNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Jinq'uin untu winic q'uen u muc'ba y t'oc u tz'ombaba ya'an u cänäntan yotot, mach'an machca u täle' lo que u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero jinq'uin u te untu más an u muc' que uneba y u säte' une, u xe u jajben u tz'omba, jin u yäle' u japän uba t'ocba, y u pucän lo que u pa'säbi. ");
INSERT INTO chfNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Machca mach'an t'oc no'onba contra de no'on ayan; y machca mach u täclon cä sacän winicob tuba u tz'omben Dios, une u yäc'ben u puclan ubajob. ");
INSERT INTO chfNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Jinq'uin ni tzuc pixan u pase tuyac'o untu winic u nume bajca mach'an machca u sacän bajca u ch'e' uba, y uc'a mach u pojleba u yäle' ca'da: “Acä sujtä tä oche bajca pason, ca' a wälä täj cotot”. ");
INSERT INTO chfNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jinq'uin u c'ote, u pojlen ni winic ca' a wälä ump'e otot que misi ayan y tusu an upete. ");
INSERT INTO chfNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","De ya'i u bixe y u täsen otros siete tzuc pixan más malo que une. U yochejob tuyac'o ni winic y u paq'uin ajtäjob ya' jini, y ji'pat ni winic jini u xe tä ajtä más peor que ajni najtäcäba. ");
INSERT INTO chfNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jinq'uin mu'to u yäle' ni jiniba, untu ixic tama ni noj q'uenel gente u chi ump'e noj t'an u yäle' ca'da: ―¡Ch'a'a ujin machca u päncäbeset, y u tzu'set! ");
INSERT INTO chfNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Une u yäli ca'da: ―¡Más ch'a'a ujinob machcatac u yubin u t'an Dios, y u tz'onän! ");
INSERT INTO chfNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jinq'uin u c'ac'a' woyli uba ni gente net' net', aj Jesús u täq'ui u yäle' ca'da: ―Anela que cuxuletla badaba mäx malojetla. A c'atän cä ye'benetla cua' chichca uc'a a chänenla y a tz'onänla cache' u Yajlo' Dioson. Seq'uen jinda cä xe cä chen tuba a chänenla. Cä xe cä chen ca' chich Dios u chi t'oc aj Jonás. ");
INSERT INTO chfNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Uc'a ca' chich Dios u chi t'oc aj Jonás tuba u chänenob a'ajtäjob tä Nínive oniba, ca' a wälä ca' jini Dios u xe u chen t'oc no'on täcä que sutwänon de winicba, tuba a chänenla anela que cuxuletla badaba. ");
INSERT INTO chfNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tu xe tä c'ote u q'uini ni toji'tanä, jinq'uin anela que cuxuletla badaba a xe tä ajtäla tu pänte' Dios tuba a ubinla cua'tac a xe tä äc'binte a toje'la, u xe tä c'ote ya' jini täcä jini ixmanda ajni oniba que u chen manda tama ump'e cab tä sur. U xe u yälbenetla cache' a sätila uc'a uneba ati ta tu xupiba u pancab tuba u yubin ni c'ajalin que u yäq'ue' ni rey aj Salomónba. Ubixtola, no'onba ya'anon wida, y más ajnojalon que ni rey aj Salomón. ");
INSERT INTO chfNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tu xe tä c'ote u q'uini ni toji'tanä, jinq'uin anela que cuxuletla badaba a xe tä ajtäla tu pänte' Dios tuba a ubinla cua'tac a xe tä äc'binte a toje'la, u xe tä c'ote ya' jini täcä jini a'ajtäjob tä Nínive. U xe u yälbenetla cache' a sätila uc'a unejob u q'uexi u c'ajalinob tuba mach u ni' chen u tanäjob jinq'uin aj Jonás u tz'aycäbijob u t'an Dios. Ubixtola, no'onba ya'anon wida, y más ajnojalon que aj Jonás. ");
INSERT INTO chfNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aj Jesús u chi t'an tä cha'num u yäle' cache' u t'an uneba y cua'tac u chenba u c'ote t'oc ca' a wälä ump'e junch'äcni. U yäli ca'da: ―Niuntu mach u mucu ump'e candil tz'äbäba uc'a mach chänintic, y mach u yäc'ä yaba cajón täcä. U yäq'ue' tu chumliba tuba u chänenob u c'ac'a ni candil machca u yoche. ");
INSERT INTO chfNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","T'oc cä jutla u ch'e' cä chänenla ni junch'äcni. Si mach'an u cuenta cä jutla cä chen chanäla utz. Si choc' cä jutlaba mach cä chänela niump'e cua'. A pixanla ca' chich jini täcä. Si a wäq'ue' cua' chichca utz tan a pixanla, es ca' a wälä ya'anetla tan junch'äcni. Si a wäq'ue' cua' chichca mach utz tan a pixanla es ca' a wälä ya'anetla tan it'obni. ");
INSERT INTO chfNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jin uc'a, c'änä a chenla cua' chichca utzba uc'a ajnic junch'äcni tan a pixanla. Mach a täq'ue'la a chenla ni mach utzba y ca' jini a wäc'ben ni junch'äcni tan a pixanla sutwänic de it'obni. ");
INSERT INTO chfNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Si a totoj chenla cua' chichca utzba sin que a chenla niump'e cua' mach utz, u xe tä c'ac'a' ajtä junch'äcni tan a pixanla. Es ca' a wälä ump'e candil ya' tz'äbäba que u chictanetla t'oc u c'ac'a. ");
INSERT INTO chfNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jinq'uin u tzupsi u chen t'anba untu aj fariseo u yälbi si yo c'uxnac t'oc, y ochi aj Jesús tan otot y chunwäni tä mesa tä c'uxnan. ");
INSERT INTO chfNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","De ya'i aj fariseo tajch'icwäni u jut u chänen que aj Jesús mach u poqui u c'äb tu xe tä c'uxnan, ca' chich u tz'onänob aj fariseojob que c'änä u chenob tu xejob tä c'uxnan. ");
INSERT INTO chfNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Cajnojala u yälbi ca'da: ―Anela lo' fariseo, seq'uen a pächi a poque'la ca' chich a poque' ump'e pote o ump'e plato. Tan a pixanlaba xuch' namás a chen pensala y q'uen malujle ayan. ");
INSERT INTO chfNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Anela mach'an a c'ajalinla. Jini machca u chi cua'tac ayan pancab, ¿mach quira une chich u chi täcä a pixanla? ");
INSERT INTO chfNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Chenla utz t'oc cua' chichca a cänäntanla, y de ya'i u xe tä ajtä limpio a pixanla. ");
INSERT INTO chfNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Tä' lástimajetla lo' fariseo!, uc'a a chenla cua' chichca mach tä' c'änä uticba, y jini tä' c'änä uticba mach a chela. De cada diez mazo de yerba buena ump'e a wäc'ben Dios. Che' chich a chenla täcä t'oc ni tiscoc y upete bänäla ta tz'acba, pero mach a che casola a chenla tu toja, y ni Dios täcä mach a yajna'tala. Jinda u yoli a chenla sin que a wäctanla a chenla ni najtäcäba. ");
INSERT INTO chfNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Tä' lástimajetla lo' fariseo!, uc'a a wola äc'bintiquetla ni najtäcäl chumlib ya'an tu pänte'ba tama ni ch'uj taj judíosob y a wola u c'alin äc'benetla u c'aba' Dios cachichca une que u nuc'tanetla tan caj. ");
INSERT INTO chfNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Tä' lástimajetla anela que a wila ni ley, y anela lo' fariseo! ¡Anela ajsusutcheriajetla! Anelaba ca' a wälä muclibaletla tajchäme que mach cheque bajca an, y winicob u numejob tu pam y mach yuwijob si u mucliba ajchäme, y ca' jini u xac'än ubajob. Ca' chich jini täcä mach cheque ni malujle que ayan tan a pixanla, y machcatac u yole' uba t'oc anela, ca' a wälä u päc'chin uba t'oc a tanäla ane sin que yuwina'tanob. ");
INSERT INTO chfNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","De ya'i u p'ali untu machca yuwi ni ley u yälben aj Jesús ca'da: ―Cajnoja, jinq'uin a wäle' ca' jiniba, ixta no'on t'ocob mach uyal utz täj c'ajalin t'ocob täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aj Jesús u yäli ca'da: ―¡Tä' lástimajetla täcä anela que a wila ni ley! Uc'a a q'ue'nesanla lo que u yäle' ni ley utic. Niuntu mach a täclela täcä tuba u chen lo que a wäle'la que c'änä uticba. Es ca' a wälä a wäc'benla ump'e cuch tu pat winicob que mach u c'äleba, y anela chich mach a tälbenla u cuchob, pero t'oc niuntz'it a ni'c'äbla tuba a täclenla u bisinte. ");
INSERT INTO chfNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Tä' lástimajetla!, uc'a anela a cherben u noj pitzil boberajob tu pam bajca mujqui ni ajt'anob ta Dios, y a c'äsi' noxi'papla oni ni u tzämsijobba. ");
INSERT INTO chfNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Anela a wila chich cua' u chijob a c'äsi' noxi'papla oni, y tan a pixanlaba a wäle'la cache' utz chich cua' u chijob, uc'a toj chich que unejob u tzämsijob ni ajt'anob ta Dios y anelaba a cherben u noj pitzil boberajob tu pam bajca mujqui. ");
INSERT INTO chfNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Diosba yuwi chich upete cua'tac ayan. Jin uc'a u worin äli ca'da: “Cä xe cä täscäbenob ajt'anob y ajc'äncanob täc'a, y yebe de unejob u xe u tulaj tzämsenob y u xe u tulaj tz'ibajtesanob”. ");
INSERT INTO chfNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Uc'a machcatac cuxujtac badaba u xe tä äc'binte u tojbenob u tanä jini machcatac u tzämsijob upete najt'anob ta Dios desde uti u pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Machcatac de anela cuxuletla badaba a xe tä äc'binte a tojbenla u tanä machcatac u tzämsijob ni ajt'anob ta Dios desde jinq'uin tzämsinti aj Abel y upete machcatac ti tä tzämsintejob ji'pat ixta que tzämsinti aj Zacarías. Aj Zacaríasba tzämsinti une tänxin de ni noj ch'u'ul otot t'oc bajca an ni alta bajca u pulcan cua' chichca matän ta subbintic Diosba. ");
INSERT INTO chfNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Tä' lástimajetla anela que a wila ni ley!, uc'a anela chich mach a wäctala ni gente u cäne'ob ni totoj c'ajalin utzba, jini t'an ta Diosba. Anela mach a cänila, y machcatac u yolijob u cäne'jobba anela mach a wäc'bila u cäne'job. ");
INSERT INTO chfNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jinq'uin aj Jesús mu'to u yäle' ni jindaba, naj fariseojob y machcatac yuwi ni ley u tz'ibi aj Moisés u täq'uijob u yälben cua' chichca jini y u sacänob tä buya tuba u yäc'ben u yäle' q'uen cua' chichca jini. ");
INSERT INTO chfNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","U yolijob u yäc'ben u yäle' cua' chichca mach jin u tojaba, y u pitänob ixta que mach ajnic cua' t'oc u sube'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jinq'uin u woyli ubajob jäyp'exti mil de gente que u maläc lubnojlan ubajob, u täq'ui aj Jesús u yälben u yajcänt'anob najtäcä ca'da: ―Cänäntan abala t'oc ni aj fariseojob uc'a unejob ajsusutcheriajob. Machcatac u sapän cua'tac u ye'e'obba u sujtäjob de ajsusutcheriajob täcä ca' chich an unejob. Es ca' a wälä unlip' jusonib que u yä'can tama ni juch'ub waj de trigo y u laj xabän upete. ");
INSERT INTO chfNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mach ajniquetla ca' an unejob, jiq'uin, uc'a mach'an niump'e cua' que a chila mucu que mach uxin tä chectan, y jini a wälila que mach yuwi niuntu u xe tä laj wina'tinte chich. ");
INSERT INTO chfNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jin uc'a cua' chichca a wälila tama it'obni u xe tä ubcan tama junch'äcni, y lo que a wälbila t'oc sajab t'an tu chiquin untu tama otot u xe tä c'alin tz'ayquinte cachichcada tä otote. ");
INSERT INTO chfNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Cälbenetla cä lot, mach a bäc'tanla machca u tzämsenetla y ji'patba mach ni' an cua' u cherbenetla más. ");
INSERT INTO chfNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cä xe cälbenetla camba ni u ch'e' a bäc'tanlaba. Bäc'tanla Dios, uc'a une an u poder u pa'säbenet a vidala, y ji'pat tuba u jule'etla tama noj ticäw c'ac' tä ute castiga. Une chich c'änä a bäc'tanla. ");
INSERT INTO chfNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Mach quira cinco bit mut biq'uitba u choncan tuba chap'e bit centavo? Pero Dios mach u najyesa niuntu de unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ixta a tzucla tan a pamla tziquijtac ayan uc'a Dios upete. Mach bäc'taquetla, uc'a más a chen valela que noj q'uenel mutob. ");
INSERT INTO chfNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Cälbenetla que upete machcatac u yäle' tu jut winicob cache' u chenon conoceba, no'onba que sutwänon de winicba cä xe cälbenob ni ángelojob ta Dios cache' cä chen conoce une täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Machca u yäle' tu jut winicob que mach u chon conoceba, no'on cä xe cälben ni ángelojob ta Dios que no'on mach cä che conoce ni winic jini. ");
INSERT INTO chfNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Upete machcatac u cäräx älbenon no'on que sutwänon de winicba u xe tä ute perdona, pero machca u cäräx älben ni Ch'u'ul Pixan mach uxin tä ute perdona. ");
INSERT INTO chfNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Jinq'uin u xe u päye'etla tu pänte' ajt'äbälajob tama ni ch'uj taj judíosob, y tu pänte' juezob y ajnojajob ta caj, mach a chen pensala cache'da a xe a p'alänla, ni cua' u ch'e' a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Uc'a ni Ch'u'ul Pixan u xe u yäc'benetla ta' c'ajalinla jinchichba hora cua' jini c'änä a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","De ya'i untu winic tama ni gente u yälbi aj Jesús ca'da: ―Cajnoja, älben cä säcun que u jeq'ue' t'oc no'on u taq'uini ni cab u colesbon cä c'äsi' pap t'ocobba. ");
INSERT INTO chfNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aj Jesús u yälbi ca'da: ―Lo', ¿caxca une u yäc'on de juez ta'ala o tuba cä pucbenetla cua' chichca jini que colesbintetla? ");
INSERT INTO chfNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aj Jesús u yäli täcä ca'da: ―Iranla que mach a c'upänla upete cua' chichca jini. Q'uen cua' chichca jini que u cänäntan untu winic mach jin lo que u yäc'ben cuxlec pancab t'oc ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","De ya'i u tz'aycäbijob ump'e tz'aji u yäle' ca'da: ―U cab untu winic ajtaq'uini u yäq'ui c'ac'a' c'ä'nac u päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Najtaq'uini u yäli tu c'ajalin ca'da: “¿Cua' acä xe cä chen? Uc'a mach'an cada cä c'ac'a' ch'ujnan u jut cä päc'äbi”. ");
INSERT INTO chfNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","De ya'i u yäli tu c'ajalin ca'da: “Bada cuwi chich cua' acä xe cä chen. Cä xe cä jinesan u yototi u jut ni päc'äbi y cä xe cä tz'osen más nojba, y ya' jini cä xe cä ch'ujnan upete u jut cä päc'äbi y cua' chichca cä cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","De ya'i cä xe cäle' ca'da: Q'uen cua' chichca jini cä cänäntan y mach uxin tä se'en xupo. Cä xe cä ch'e' cäba, cä xe tä c'uxnan, cä xe tä buc'a, cä xe cä ch'a'alesan cäjin”. ");
INSERT INTO chfNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios u yälbi ca'da: “Aneba mach'an a c'ajalin. Jimba ac'äbda a xe tä chämo y a pixanba u xe tä bisinte. De ya'i ¿caxca tuba wäre u xe tä colan ni a ch'ujniba?” ");
INSERT INTO chfNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Machca u woye' q'uen cua' chichca jini tubaba y mach u bisa bij t'oc Dios, uneba es ca' ni winic tama ni tz'ajidaba. ");
INSERT INTO chfNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","De ya'i aj Jesús u yälbi u yajcänt'anob ca'da: ―Jin uc'a cälbenetla que mach a chen pensala por a vidala, cache' a xe a pojlen cua' a c'uxe'la; ni mach a chen pensala por a cuerpola, cache' a xe a pojlen a bucla tuba a wäq'ue' ta'wac'olaba. ");
INSERT INTO chfNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A vidala más u chen vale que cua' a c'uxe'la y a cuerpola más u chen vale que ni a bucla. ");
INSERT INTO chfNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Iranla jini mut u c'aba' ajtz'inub, mach u päc'ä cua' chichca de päc'äbi y mach u c'ä'nesa cua'. Mach u cänänta troja ni ch'uji' cua' chichca y Dios u yäc'benob cua' u c'uxe'. ¿Mach quira a chen valela más tu jut Dios que ni mutob jini? ");
INSERT INTO chfNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Niuntu de anela mach u ch'ä a q'ue'nesan a vidala chap'e uxp'e q'uin pancab uc'a a päpä' chen pensa ta' c'ajalinla ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Si mach a che trebe ni a wäle'la ixta ca jun tzäcä a xe a chen vidala, ¿cua' uc'a a päpä' chen pensa ta' c'ajalinla cua' a c'uxe'la y cua' a xoje' ta'wac'ola? ");
INSERT INTO chfNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Iranla cache' u ch'ije ni te'el rosa, mach u che patan y mach u jälä noc', pero cälbenetla que ni rosa jiniba más pitzi une que u pitzilan ni rey aj Salomón jinq'uin u c'ac'a' jeli uba. ");
INSERT INTO chfNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Si ca' jini Dios u yäc'ben u pitzilan ni bänäla que bada ya'an tä campo y ic'äba u julcan tama ni c'ac' tä pule, ¿mach quira más u xe u yäc'benet a bucla tuba a jele' abala t'oc? Anela mäx tz'ita' a tz'onänla. ");
INSERT INTO chfNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mach a chen pensala jiq'uin, por cua' a xe a c'uxe'la y cua' a xe a wuch'enla. Mach ajnic niump'e jaq'uinle ta' pixanla. ");
INSERT INTO chfNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Uc'a upete ni jiniba, jin chich u sacänob ni gente pancab que mach u che conoce Diosba, pero a Papla Dios yuwi que c'änäjtac ac'ala cua' a c'uxe'la y cua' a jele' abala t'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pero anelaba, nonoj äc'ä abala tu c'äb Dios tuba u chenet mandala, y de ya'i upete cua' chichca jini c'änäjtac ac'ala a xe chich tä äc'bintela täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Anelaba tz'ita'etla, ca' a wälä ump'e u p'i' tomtä oveja, pero mach a bäc'tanla jini machcatac mach yo u chänenetlaba, uc'a a Papla Dios u yajna'tanetla y u yaquetla tuba ochiquetla tu manda. ");
INSERT INTO chfNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chonola cua'tac a cänäntanla y sijbenla u taq'uini ni pobrejilba. Sacänla cua' chichca u yäq'ue' Diosba, jini que mach uxin tä xupoba. Jintac une mäx choj u valor que mach uxupba a xe a woye'la tä cielo bajca mach uc'ot ajxuch' y bajca mach'an u wincäre tuba u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Uc'a jini cua' chichca a bon c'upänlaba, sec' jin chich a xe a chen pensala. ");
INSERT INTO chfNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ajniquetla ca' gente u laj tusi ubajob y tz'äbä ayan u candil u pijnan cua' chichca jini. ");
INSERT INTO chfNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ajniquetla ca' winicob que u pitänob sujlec u yajnoja que ya' xi bajca an lotojanba, uc'a tu xe tä c'oteba y u jätz'e' ti' ototba, tä' seb u xe u jäbbenob ti' otot. ");
INSERT INTO chfNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ch'a'a ujinob ni ajpatanob jini machcatac u yajnoja u xe u pojlen cache' p'ixijtac ayanob u pijnan tu xe tä c'ote uneba. Totojtoj cälbenetla u xe u xoje' u ch'icnäc' y u xe u yäc'ben chunwänicob tä mesa y de ya'i u xe u yäc'benob cua' u c'uxe'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ch'a'a ujinob ni ajpatanob jini si tic u yajnojajob y u pojlenob p'ixijtacob u pitänob cua' chichca hora jini que julicba. Mach u che cua' si u jule ac'äb a las diez o si julic tänxin ac'äb, unejob ya' chich an u pitänob. ");
INSERT INTO chfNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wina'tanla que si fuera u yum otot u wina'tan cua' hora u xe tä c'ote najxuch'ba, u totoj cänäntan ica y mach ica u yäcta tä oche ajxuch' tan yotot. ");
INSERT INTO chfNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Anela täcä c'änä ajniquetla p'ixi a pijnanonla, uc'a no'on que sutwänon de winicba cä xe tä jule ump'e hora que anela mach a wila. ");
INSERT INTO chfNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","De ya'i aj Pedro u c'atbi ca'da: ―Cajnoja, ¿seq'uen no'on t'ocob quira a wälbenon t'ocob ni t'anda, o upetejob mu' a wälben? ");
INSERT INTO chfNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Cajnojala u yäli ca'da: ―Jinda cäli tuba u yubinob upete machca u cänäntan u cargo ca' untu ajnoja ta patan que tä' q'uen u c'ajalinba y u chen ca' chich u yum u yäc'ben u chenba. Ni ajpatan que u chen ca' jiniba u yum u xe u yäc'ben u chen manda upete u yajpatanob tu yotot y tuba u yäc'benob cua' u c'uxe'ob tu horäji c'uxnan. ");
INSERT INTO chfNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ch'a'a ujin jini ajpatan jinq'uin u xe tä te u yajnoja u nuc'tan que mu' chich u chen patan ca' chich äc'binti u chen. ");
INSERT INTO chfNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Totojtoj cälbenetla, une u xe u yäc'ben ni ajpatan jini u jiran upete cua'tac u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero si ni ajpatan jini u yäle' tan u c'ajalin que u yajnoja mach uxin tä se'en te, y de ya'i u täq'ue' u jätz'e' ni ajpatanob y ni ixpatanob, y uneba u c'uxnan y u buc'a y u chibälnan, ");
INSERT INTO chfNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","u yajnoja najpatan jiniba u xe tä c'ote ump'e q'uin jinq'uin mach'an u pitänba, ump'e hora que une mach yuwiba, y u xe u c'ac'a' äc'ben jatz' y u xe u yäq'ue' tä ute castiga nämte' t'oc machcatac que mach u tz'ombe u t'an uneba. ");
INSERT INTO chfNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Untu ajpatan que yuwi lo que yo ni U yajnoja u chenba, pero si mach u chi jini patan y mach u tz'oni u chen ca' chich u yajnoja u yoli uticba, u xe tä c'ac'a' äc'binte jatz'. ");
INSERT INTO chfNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero jini machca mach yuwi lo que yo utic u yajnojaba, y u chen cua' chichca jini tuba utic castigaba, u xe tä jätz'can tz'ita'. Upete machca chichca u yäc'binte q'uen, q'uen chich u xe tä c'atbinte täcä y jini machca chichca u yäc'binte q'uen cua' chichca tu c'äb tuba u cänäntanba, más q'uen u xe tä c'atbinte. ");
INSERT INTO chfNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Jini aton cä chen no'onba es ca' a wälä aton cä tz'äbe' ump'e c'ac' tu pancab. Ni c'ac' jini ca' a wälä u xe u laj pule' cua' chichca mach utzba. Tä' coba cä tz'äbe' ni c'ac' jini mäx seb. ");
INSERT INTO chfNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","C'änä cä numsen ump'e noj gran tz'ibajtesia y mäx u ch'ocoman cä pixan ixta tu xupiba de upete cua' acä xe tä cherbinteba. ");
INSERT INTO chfNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A wäle'la quira que no'on aton tuba cä'ben ch'in ajnicob a'ajtäjob pancab? Cälbenetla que mach, no'onba aton tuba cä'benob u maläc tz'osen buyajob. ");
INSERT INTO chfNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Uc'a desde badaba cincojob tan ump'e otot u xe u chenob buya, ni uxtuba tuyac'o ni cha'tu y ni cha'tuba tuyac'o ni uxtu. ");
INSERT INTO chfNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","U pap untu u jule' uba tuyac'o u yajlo', y u yajlo'ba tä buya t'oc u pap; u na' untu tä buya t'oc jixic ch'oc y u jixic ch'ocba tä buya t'oc u na'; y u nojna' untu tä buya t'oc u yälib y u yälibba tä buya t'oc u nojna'. ");
INSERT INTO chfNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","U yälbi ni gente täcä ca'da: ―Jinq'uin a chänenla ni bucla que u ch'oye bajca u pome q'uinba anela seb a wäle'la que ya' u te ja', y che' chich u xe u chen ca' a wäle'laba. ");
INSERT INTO chfNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y jinq'uin u yustan ni ic' tä sur a wäle'la que mäx u xe tä ajtä p'ulewa, y toj chich une. ");
INSERT INTO chfNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Anela ajsusutcheriajetla. A wila si u xe u yäc'ben ja' o si u xe tä ajtä p'ulewa jinq'uin a chänenla cache' u ch'oye bucla o cache' u yustan ic'. ¿Cua' uc'a mach uta ta' c'ajalinla jiq'uin cua' u xe tä ajtä t'oc ni cä ye'betla no'onba? ");
INSERT INTO chfNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Cua' uc'a mach a che trebe a juntumala a wäle'la caxcamba u toja que Dios yo que a chenla? ");
INSERT INTO chfNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","C'änä a worin iranla cache'da u ch'e' ajniquetla utz tu jut Dios tuba mach u yäc'benet a toje' a tanäla. Es ca' a wälä mu'to a xe tä juez t'oc machca u sube'etba y a wiran si u ch'e' a tuse' t'oc tä bij, mach me'ixto xic u päye'et tä juez y ni juez u yäq'ue'et tu c'äb ni policía y ni policía u jup'e'et tä cárcel. ");
INSERT INTO chfNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cälbenet que si u chenet pasa ca' jiniba mach uxet tä pase ya'i ixta que mach a laj säte' upete a taq'uin a toje' t'oc multa. ");
INSERT INTO chfNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jinchichba q'uin ajni ya' jini cha'tu uxtujob machcatac u tz'aycäbijob aj Jesús cua' jini cherbintijob yebe aj galileojob. U tz'aycäbijob cache' jinq'uin mu'to u tzämsen animajob ni aj galileojob jini tuba u súbben Dios, ni gobierno aj Pilatoba u täsqui tä tzämsintejob y u ch'ich'eba u xac'bi t'oc u ch'ich'e ni animajob. ");
INSERT INTO chfNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","U p'ali aj Jesús u yälbijob ca'da: ―¿A wäle'la quira cache' naj galileojob jiniba cherbintijob ca' jini uc'a más q'uen u tanä u chijob que otros aj galileojob? ");
INSERT INTO chfNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cälbenetla que mach, y mach u chijob más q'uen u tanä täcä que anela. Pero si mach a q'uexe' a c'ajalin anelaba uc'a mach a ni' chen a tanäla, apetela a xe tä äc'bintela a toje' a tanäla täcä ta' xe tä chämola. ");
INSERT INTO chfNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O jini dieciochojobba, jini yäli noj isquil otot tu pamob tä Siloéba u tzämsijob, a wäle'la quira que más an u tanäjob que upete winicob que cuxlijob tä Jerusalénba? ");
INSERT INTO chfNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cälbenetla que mach, y mach u chijob más q'uen u tanä täcä que anela. Pero si mach a q'uexe' a c'ajalin anelaba uc'a mach a ni' chen a tanäla, apetela a xe tä äc'bintela a toje' a tanäla täcä ta' xe tä chämola. ");
INSERT INTO chfNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aj Jesús u yäli täcä ump'e t'an tuba u ye'e' cache' machcatac mach u tz'ombe u t'anba u c'ote t'oc ca' a wälä untec te' higo que mach u che u jutba. U yäli ca'da: ―Untu winic u cänänti untec te' higo päc'ä uc'a tan u caba u päc'äbi, y ati u sacben u jut y mach u pojli cua'. ");
INSERT INTO chfNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","De ya'i u yälbi u yajsispäc'äbi ca'da: “Ubixto, u cänäntan uxp'e año acajne cä sacben u jut ni te' higoda y mach cä pojläbi cua'. Julu tä cab. ¿Cua' uc'a päpä' ajnic u cräx päc'chin cä cab?” ");
INSERT INTO chfNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ajsispäc'äbi u yälbi ca'da: “Cajnoja, tan u yajtä jimba añoda täcä y cä xe cä cujben tu junxoyma u chun y cä'ben u ta' anima tuba äc'bintic u muc' ni cab, bay ca' jini u yäq'ue' u jut. ");
INSERT INTO chfNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Si u yäq'ue' u jut unjabba utz chich, y si machba u ch'e' a jule' tä cab ji'pat”. ");
INSERT INTO chfNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tuyac'o ump'e q'uin ch'ämbäji aj Jesús ya'an u ye'e' u t'an Dios tan ump'e ch'uj taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ajni ya' jini untu ixic que u cänäntan dieciocho años c'ojo t'oc ump'e chere'yaj ta tzuc pixan. C'omocna u chen xämba, y mach u chi trebe ni tz'ita' wa'wänic tajtoj. ");
INSERT INTO chfNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jinq'uin u chäni aj Jesús ni ixic jiniba u joq'ui u yälbi ca'da: ―Xoc, mach ni' an ta'wac'o ni yaj que a cänäntanba. ");
INSERT INTO chfNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","De ya'i aj Jesús u yäq'ui u c'äb tuyac'o ni ixic tuba u tz'äcälin y seb u to'esi uba u ch'u'ul c'ajti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ni ajnoja tuba ni ch'uj taj judíosob cäräx'i uc'a aj Jesús u tz'äcäli untu ixic tu q'uini ch'ämbäji, y u yälbi ni gente ca'da: ―Ya'an seis q'uin ta semana jinq'uin u ch'e' utic patan. Tiquetla jiq'uin tu q'uini patanba tuba tz'äcälcaquetla y mach tuyac'o u q'uini ch'ämbäjiba. ");
INSERT INTO chfNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","De ya'i Cajnojala aj Jesús u p'albi ca'da: ―Ajsusutcheriajetla, ¿mach quira toj que cada juntu de anela a p'äne'la a beq'uet o a tzimim tu yajliba tu q'uini ch'ämbäji y a bisanla bajca u yäc'binte ja' u yuch'en? ");
INSERT INTO chfNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jinda ixic untu u natil ch'oc aj Abraham, ni yäcä uc'ajob Diosba. U cänänti dieciocho años c'ojo t'oc jinda yaj, es ca' a wälä cächä an uc'a aj Satanás. ¿Mach quira u ch'ä tz'äcälcac t'oc ni yaj u cänäntiba tu q'uini ch'ämbäji? ");
INSERT INTO chfNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jinq'uin u yäli aj Jesús ni t'anob jiniba u ch'i quisinob machcatac mach yo u chänenba, pero upete ni gente ch'a'ali ujinob uc'a upete cua' chichca tan pitzi que u chi aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","De ya'i aj Jesús u yäli ca'da: ―Cä xe cälbenetla cache'da ayan u manda Dios. Cä xe cälbenetla cua' une ayan pancab que u c'ote t'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","U c'ote t'oc ca' a wälä unxim u yoc tz'utz' bec' mostaza que u ch'i untu winic tuba u päq'ue' tan u caba u päc'äbi. Ch'iji y c'oti ca' untec noj gran te'. Ji'pat ni mut ajwilejob isqui u chijob u c'ub tuyac'o u c'äb. ");
INSERT INTO chfNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sutwäni u yäle' tä cha'num ca'da: ―Cä xe cälbenetla cua' une ayan pancab que u c'ote t'oc u manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","U c'ote t'oc ca' a wälä ni jusonib ta waj que u ch'i untu ixic y u yäq'ui tama ca' tuba cincuenta kilo de harina y u laj jusesi upete. ");
INSERT INTO chfNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ji'pat bixe u chen aj Jesús tä xämba tuba bixic tä Jerusalén y numi tama noj caj y bit caj u ye'e' u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","De ya'i ajni untu machca u c'atben ca'da: ―Cajnoja, ¿mäx tz'ita' quira machcatac u xe u japän uba? Aj Jesús u p'ali ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Ch'o'olesan abala a tz'ombenla Dios tuba a japän abala, uc'a cälbenetla q'uen machcatac u xe u yolin ochicob y mach uni' xin u chen trebejob. Es ca' a wälä a wo ochiquetla tama ump'e otot, pero u ti' ni ototba mäx p'i' u tan y c'änä a sacän cache'da u ch'e' ochiquet. ");
INSERT INTO chfNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jinq'uin u xe tä ch'oye u yum ni otot u mäque' u ti' ni otot, anela a xe tä colanla päti y a täq'ue'la a jätz'e'la u ti' ni otot y a wäle'la ca'da: “Cajnoja, jäbbenon t'ocob u ti' ni otot”. Pero une u xe u p'alän u yälbenetla ca'da: “Mach cä chet conocela, mach cuwi cada atetla”. ");
INSERT INTO chfNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","De ya'i ane a xe a täq'ue' a wäle'la ca'da: “Ta' pänte' aneba c'uxnon t'ocob y buc'on t'ocob, y ane a ye'i u t'an Dios tä calle tan cä cäji t'ocob”. ");
INSERT INTO chfNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero une u xe u p'alän u yälbenetla ca'da: “Cälbenetla mach cä chet conocela, mach cuwi cada atetla, tz'eje abala t'oc no'on anela ajmalujlejetla”. Ca' jini a xe tä älbintela. ");
INSERT INTO chfNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Anela a xe tä jup'canla tu yajliba ni toji'tanä y ya' jini a xe a c'ac'a' chen uq'uela y a cäch'äcnesan a wejla uc'a a xe a chänenla cache' aj Abraham y aj Isaac y aj Jacob y upete najt'anob ya' laj anob bajca u chen manda Dios. U bajnimajob unejob Dios u yaqui najtäcä y anelaba u natil ch'ocobetla. ");
INSERT INTO chfNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","U xe tä tejob gente täcä que mach yäcä uc'ajob Dios ajniba. U xe tä tejob bajca u pase q'uin y bajca u pome q'uin y tä norte y tä sur, y u xe tä chumtäjob tä c'uxnan bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ubinla, ayan machcatac u joq'ui Dios najtäcä, pero ji'pat mach uxin tä äc'binte ochicob bajca u chen manda Dios. Ayan täcä jini machcatac mach u joq'ui Dios najtäcä, pero ji'patba u xe chich tä osintejob bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jinchichba q'uin jini yebe aj fariseojob c'otijob u yälbenob aj Jesús ca'da: ―Corre cux, pasen wida uc'a aj Herodes yo u tzämsenet. ");
INSERT INTO chfNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Une u yälbijob ca'da: ―Xiquetla y älbenla ni a'uch jini ca'da: “Ubixto, dali y ic'ä no'on acä pa'säben tzuc pixan tuyac'o machcatac u cänäntan y acä tz'äcälin ajc'ojpanob, y chabi to cä tzupsen cä patan”. ");
INSERT INTO chfNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero no'on c'änä cä chen segui cä biji dali, ic'ä y chabi, uc'a mach'an cua' uc'a tzämsintic ajt'an ta Dios otro cab, seq'uen tama ni caj tä Jerusalén c'änä tzämsintic. ");
INSERT INTO chfNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Anela cä lot tan caj tä Jerusalén, a tzämsenla ajt'anob ta Dios y a wäc'benla t'oc ji'tun machcatac u täsquintejob bajca anetla. ¡Jäypetz'ixti coli cä woye'etla ca'anon ca' ni na' piyo' u woye' yal tu yaba u wich', y mach a wolila! ");
INSERT INTO chfNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ubinlaba, Dios u waläcti bada ni noj ch'u'ul otot bajca a ch'u'ul c'ajti'ilaba. Cälbenetla que mach uni' xet a chänenonla ixta que mach c'otic q'uin jinq'uin a xe a wälbenonla ca'da: “Ch'u'ul ayan jini machca u teba, jini machca u täsqui cä Yumla Diosba”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ump'e u q'uini ch'ämbäji aj Jesús ochi tä c'uxnan tan yotot untu ajnoja tuba aj fariseojob, y ni aj fariseojobba u ch'ucänob. ");
INSERT INTO chfNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","De ya'i c'oti tu pänte' aj Jesús untu winic c'ojo t'oc ump'e yaj que u sit'esben u cuerpoba. ");
INSERT INTO chfNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aj Jesús u c'atbijob machcatac yuwi ni ley y aj fariseojob ca'da: ―¿U yäle' quira ni ley si u ch'e' tz'äcälcac untu ajc'ojpan tu q'uini ch'ämbäji? ");
INSERT INTO chfNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Unejob tajch'ijcolobijob. De ya'i une u täli najc'ojpan u tz'äcälin y ji'pat u täsqui bixic. ");
INSERT INTO chfNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","De ya'i aj Jesús u yälbi naj fariseojob ca'da: ―Si anela a cänäntanla untu beq'uet ta patanba o untu tzimim que yälic tan ch'enba, ¿mach quira seb a xe a pa'senla, mach u che si es u q'uini ch'ämbäji? ");
INSERT INTO chfNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Unejob mach u pojli cua' u yälbenob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aj Jesús u yälbijob ump'e t'an machcatac jo'qui tä c'uxnan jinq'uin u chäni cache' u yaquijob jini chumlib tuba machcatac más oloba. ");
INSERT INTO chfNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","U yälbijob ca'da: ―Jinq'uin ayan machca u joq'ue'et bajca an ump'e lotojan, mach numiquet tä chumtä bajca u xe tä chumtäjob machcatac más oloba, mach me'ixto ajnic otro joc'o täcä que más olo tä chäninte que aneba. ");
INSERT INTO chfNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","De ya'i jini machca u joq'uetla a cha'tumala u te u yälbenet ca'da: “Äc'ben ni winicda jini chumlib a ch'iba”. De ya'i t'oc quisinle a xe tä nume tä chumtä bajca u chumtäjob machcatac mach tä' oloba. ");
INSERT INTO chfNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jinq'uin a jo'can bajca an lotojanba, xiquet tä chumtä bajca u chumtäjob machcatac mach tä' oloba, uc'a jinq'uin tu te machca u joq'uetba u yälbenet ca'da: “Cä lot, numen tä chumtä bajca u chumtäjob machcatac más oloba”. Ca' jini a xe tä c'alin olcan tu pänte' upete machcatac chumujtac t'oc ane tä mesa. ");
INSERT INTO chfNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Uc'a upete machca u chäcäl chen uba cache' une es untu noj don winicba, u xe tä äc'binte xic de ajch'och'oca, y jini machca u yolin xic de ajch'och'ocaba u xe tä äc'binte xic de untu noj don winic. ");
INSERT INTO chfNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aj Jesús u yälbi täcä ni winic, jini u joq'ui tä c'uxnanba, ca'da: ―Jinq'uin a wäq'ue'la cua' tä c'uxcan o cua' tä uch'can, mach a joq'ue'la seq'uen a lotob, ni a witz'inob, ni a säcunob, ni a familiajob, ni a wajnätz'äla, jini machcatac an u taq'uinba, bay u xe tä sujtä u joq'ue'etob tä c'uxnan täcä, y ca' jini u sutjatz'benet u jelo. ");
INSERT INTO chfNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jinq'uin a tuse'la cua' tä c'uxcan joc'o ni pobrejilba, y machcatac balda'ojtac, y ajc'ol'oc y ajchoc'. ");
INSERT INTO chfNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ca' jini a xe a cänäntan ch'a'aljin, uc'a unejob mach u ch'ä u sutjatz'benet u jelo. Jin to q'uin a xe tä sutjatz'binte u jelo tu xe tä cuxpescan machcatac ni an tu tojaba ta paq'uin cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jimba u yubi ca' jini untu machca chumu tä mesa nämte' t'oc uneba, y u yälbi aj Jesús ca'da: ―Ch'a'a ujinob chich machca u yochejob tä c'uxnan jinq'uin u xe tä ute ni noj gran c'ux bajca u chen manda Dios tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero aj Jesús u yälbi ca'da: ―Untu winic u worin täsqui tä älbinte q'uen u lotob cache' u xe u tuse' ump'e noj gran c'ux. ");
INSERT INTO chfNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tu c'ote ni hora tuba c'uxnacob u täsqui untu u yajc'äncan u yälben machcatac jo'quiba ca'da: “Xiquetla bada, a'i, uc'a san chich a'uti ni cua' tä c'uxcan”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Upetejob u täq'uijob u yäle' cua' uc'a mach u ch'ä xic. Untu, ni najtäcäba u yäli ca'da: “No'on cä mäni ump'e cab y c'änä xicon cä chänen; cälbenet a chenon perdona que mach uxon”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Otro untu u yäli ca'da: “No'on cä mäni cinco par de beq'uet ta patanba, y cä xe quiran si u chenob patan utz; cälbenet a chenon perdona que mach uxon”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Otro untuba u yäli ca'da: “Atotaj lotojon to, y jin uc'a mach u ch'ä xicon”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jinq'uin sutwäni ni ajc'äncan jini u yäc'bi u wina'tan u yajnoja upete cache'tacda u yälijob ni machcatac jo'quiba. De ya'i cäräx'i najnoja ta ni otot jini y u yälbi u yajc'äncan ca'da: “Seb xiquet tänxin caj y papat caj y täsen wida pobrejilba, machcatac balda'ojtac, machcatac ajc'ol'oc y machcatac ajchoc'”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ji'pat najc'äncan u yäli ca'da: “Cajnoja, no'on acä chi ca' chich a wälbon y mach to laj tul otot”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Najnoja u yälbi u yajc'äncan ca'da: “Corre cux tä noj bijob y tan pimi bajca an bit otote y a cocoj älben que ticob uc'a tulic cotot. ");
INSERT INTO chfNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Uc'a cälbenetla cache' niuntu de ni winicob cä täsqui tä jo'canba mach uni' xon cä'ben ni tz'ita' u c'uxe'ob ni cua' tä c'uxcan jini”. ");
INSERT INTO chfNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Noj q'uenel gente u bixe t'oc aj Jesús y une u suti u jut u chänenob u yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Machca chichca une u te bajca anon mach u ch'ä xic de ajcänt'an täc'a si mach u yolinon más que u yolin u pap y u na' y jit'oc y u bijch'oc y u jitz'inob y u säcunob y u chichob. Une täcä mach u ch'ä u bäc'tan chämo uc'a no'on. ");
INSERT INTO chfNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Machca chichca une que mach yo u chen sufri ca' chich u chen sufri untu tuyac'o cruz mach u ch'ä xic de ajcänt'an täc'a. Machca chichca une que mach yo u ch'e' cä biji mach u ch'ä xic de ajcänt'an täc'a täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Machca chichca de anela, si a wo a tz'osen ump'e isquil otot, ¿mach quira a chumtä najtäcä a pa'sen jäyp'e u xe u bisan uc'a a wiran si a cänäntan ni taq'uin tuba a tzupsen t'ocba? ");
INSERT INTO chfNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Uc'a mach me'ixto a taj äc'ben u chumliba ni otot y mach a chen trebe a tzupsen. De ya'i upete machcatac u chänenba u xe u täq'ue' u tze'tanet. ");
INSERT INTO chfNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","U xe u yäle'ob ca'daba: “Ni winicda u täq'ui u tz'osen ump'e isquil otot y mach u chi trebe u tzupsen”. Che' u xe u yäle'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Si untu rey u xe u chen jo'yan t'oc otro reyba, ¿mach quira najtäcä u chumtä u ch'e' u c'ajalin si t'oc diez mil soldadojob u chen trebe u yäc'ben uba t'oc ni jini u te tuyac'o t'oc veinte milba? ");
INSERT INTO chfNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y si mach u che trebeba, jinq'uin ni otro untu ya'to an natba u täscun ajc'äncanob u ch'oc chen ubajob t'oc u c'atben cuaxca ni yo uc'a mach ni' utic ni jo'yan. ");
INSERT INTO chfNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Che' chich täcä, si anela a wo xiquetla de ajcänt'an täc'a, c'änä a bon ch'e' a c'ajalinla najtäcä ca' chich u chijob ni cha'tu winic, ni cäli samiba, uc'a jini machca mach u laj äctan upete cua' chichca u cänäntanba mach u ch'ä xic de ajcänt'an täc'a. ");
INSERT INTO chfNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ni mero atz'amba mäx utz une. Ayan lo que mach jin mero atz'am que u säto u ch'och'anba. Si sätic u ch'och'anba mach'an cache'da äc'bintic u ch'och'an tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mach u ni' che servi tuba niump'e cua'. Mach u che servi ni tuba ä'cac tu pam ni cab, ni tuba xabintic t'oc ni cab tuba u yäc'ben u muc' ni cab. Tä chojcan u xe. Co que ni cajcänt'anobba ajnicob ca' a wälä mero atz'am. Machcatac an u chiquin tuba u yubinba, c'änä u yäq'ue' u chiquin tuba u yubin cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ji'pat, mu' u natz'änob aj Jesús upete ajcojtaq'uinob y machcatac u säte'ob t'oc ni ley u tz'ibi aj Moisés tuba u yubinob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Y aj fariseojob y machcatac yuwijob ni ley u patil älben aj Jesús ca'da: ―Jinda winic u sapän machcatac u säte'ob t'oc ni ley u tz'ibi aj Moisés y u c'uxnan nämte' t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jin uc'a aj Jesús u yälbijob ni t'anda: ");
INSERT INTO chfNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Si untu de anela a cänäntan cien oveja y sätic untuba, ¿mach quira a xe a colesan ni noventa y nueveba tä campo y a bixe a sacän ni asätiba ixta que mach a pojlen? ");
INSERT INTO chfNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta' xe a pojlenba a xe a wäq'ue' ta' p'ixte' t'oc ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","De ya'i ta' c'ote ta' wototba a xe a täscun tä jo'can a lotob y a wajnätz'älajob y a wälben ca'da: “Ch'a'alac ajinla t'oc no'on uc'a cä pojli cä oveja ni sätiba”. ");
INSERT INTO chfNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","De ya'i aj Jesús u yäli ca'da: ―Cälbenetla que ca' jini täcä ayan más ch'a'aljin tä cielo uc'a untu ajcherajtanä que u q'uexe' u c'ajalin tuba mach u ni' chen u tanäba que ni noventa y nueve ya' chich an tu tojaba que mach c'änä u q'uexe'ob u c'ajalinba. ");
INSERT INTO chfNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Untu ixic que u cänäntan diez säsäc taq'uin, si u säte' ump'eba, ¿mach quira u xe u tz'äbe' gas y u misän tan otot tuba u c'alin sacän ixta que mach u pojlen? ");
INSERT INTO chfNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tu xe u pojlenba u xe u täscun tä jo'can u lotob y u jixnätz'älajob y u xe u yälben ca'da: “Ch'a'alac ajinla t'oc no'on uc'a cä pojli ni taq'uin cä sätiba”. ");
INSERT INTO chfNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ca' jini cälbenetla que ayan ch'a'aljin tu pänte' ajc'äncanob ta Dios uc'a untu ajcherajtanä u q'uexe' u c'ajalin tuba mach u ni' chen u tanäba. ");
INSERT INTO chfNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aj Jesús u yäli täcä ca'da: ―Untu winic u cänänti cha'tu u yajlo'. ");
INSERT INTO chfNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","U ch'och'oca de unejob u yälbi u pap ca'da: “Cä pap, äc'benon ni cä parte no'onba de upete cua' chichca a cänäntan”. De ya'i ni winic u pucbijob u cha'tumajob cua'tac u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chap'e uxp'e q'uin ji'pat ni u ch'och'oca yajlo'ba u laj woyi u taq'uini de upete cua' chichca äc'binti y pasi bixi bajca an ump'e cab natba. Ya' jini u laj säti u taq'uin t'oc cua' chichca mach utz u chenba. ");
INSERT INTO chfNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jinq'uin u laj sätiba tutz'i ump'e noj wi'na de jitz'o ya'i jimba cab jini, y u täq'ui u na'tan jitz'o. ");
INSERT INTO chfNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","De ya'i bixi u ch'oc chen uba t'oc untu ajcäbna jimba cab jini uc'a u yäc'ben patan. Ni winic u täsqui tama u cab tuba u cänäntäben u chitam. ");
INSERT INTO chfNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Uneba tä' u yoli u c'uxe' jini cua' u c'uxe' ni chitam uc'a na'ac, uc'a niuntu mach u yäc'be cua' u c'uxe' une. ");
INSERT INTO chfNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","De ya'i u ch'i u c'ajalin u yäle' ca'da: “¡Jäytu ti ajpatan ya'an tu yotot cä pap u cänäntan q'uen cua' u c'uxe', y no'onba ya'anonda tä chämo t'oc jitz'o! ");
INSERT INTO chfNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cä ch'oye bada cä bixe bajca an cä pap y cä xe cälben ca'da: Cä pap, acä säti t'oc Dios tä cielo y t'oc ane. ");
INSERT INTO chfNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mach u ni' ch'ä a wäle' cache' a wajlo'on; chenon ca' a wälä untu a wajpatan”. ");
INSERT INTO chfNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","De ya'i ch'oyi y bixi ca'an u pap. ’Jinq'uin ya'to u te natba u pap u chäni y u ch'ämbi yajin. Pasi u pap t'oc noj ancäre u mec'ben u luc'ub y u tz'utz'än. ");
INSERT INTO chfNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","U yajlo' u yälbi ca'da: “Cä pap, acä säti t'oc Dios tä cielo y t'oc ane. Mach u ni' ch'ä a wäle' cache' a wajlo'on”. ");
INSERT INTO chfNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero u pap u yälbi u yajpatanob ca'da: “Seb täsenla ni buqui más pitziba y xojbenla tuyac'o. Äc'benla ump'e mopc'äb tu ni'c'äb y zapato tu yoc. ");
INSERT INTO chfNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Täsenla ni ch'oc najom beq'uet poc'omba y tzämsenla tuba cä c'uxe'la, y cä ch'a'alesan cäjinla t'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Uc'a ni cajlo'da cäli cache' chämi, y bada ca' a wälä cuxpi tä cha'num; sätä ajni y bada apämi”. De ya'i u täq'uijob u ch'a'alesan ujinob. ");
INSERT INTO chfNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’U yajlo' u nojaba ajni tä patan, y tu xe tä c'ote nätz'ä bajca an yotot u yubi ni c'ay y ac'ot. ");
INSERT INTO chfNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","De ya'i u joq'ui untu ajpatan u c'atben cua' jini mu' u yute. ");
INSERT INTO chfNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Une u yälbi ca'da: “A witz'in ajuli, y a pap u tzämsi ni ch'oc najom beq'uet mäx poc'omba uc'a juli tä cha'num t'oc u yutzi y mach'an cua' u cäle'”. ");
INSERT INTO chfNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","De ya'i cäräx'i y mach u yoli ochic. Jin uc'a pasi u pap päti u ch'oc chen uba t'oc uc'a ochic. ");
INSERT INTO chfNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Une u p'ali u yälben u pap ca'da: “Ubixto cä pap, jäyp'exti año cä te cä täclenet; mach bay cäli si mach cä tz'ombenet a t'an. Niunum mach bay a'bon untu ch'oc ajchibu tuba cä c'uxe' t'oc cä lotob. ");
INSERT INTO chfNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ni a wajlo' jini u laj sätbet u taq'uini a cab t'oc u lot ixictacba, y bada tu jule a tzämsäbi untu ch'oc najom beq'uet poc'omba”. ");
INSERT INTO chfNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","De ya'i u pap u yälbi ca'da: “Cä ch'oc, aneba paq'uin ayanet chich t'oc no'on; upete cua'tac cä cänäntanba es ta'a chich. ");
INSERT INTO chfNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","C'änä utic ump'e q'uin ch'uje y ch'a'alac cäjinla, uc'a ni a witz'inda, cäli cache' chämi, y bada ca' a wälä cuxpi tä cha'num; sätä ajni y bada apämi”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aj Jesús u yälbi u yajcänt'anob täcä ca'da: ―Ajni untu ajtaq'uini que u cänäntan untu ajnoja tuba u patan. Subqui tu pänte' u yum que mu' u laj sätben u taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","De ya'i u joq'ui u yälben ca'da: “¿Cuaxca jini acubin a chenba? äc'benon ni jun bajca a laj tz'ibi upete cua'tac a chi t'oc cä taq'uin, uc'a ane mach uni' xon cä'benet xiquet de ajnoja ta patan täc'a”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","De ya'i ni ajnoja ta patan u yäli tan u c'ajalin ca'da: “¿Cua' acä chen bada uc'a cä yum u pa'säbenon cä patan? Mach'an cä muc' tuba cä cujän cab, y u yäc'benon quisin ta xicon tä tentenbäji. ");
INSERT INTO chfNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bada cuwi chich cua' acä xe cä chen täc xe tä pa'säbinte cä patan tuba u yosenonjob tama u yototob u yajmanob cä yum”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","De ya'i u täsqui tä jo'can juntu ajuntu machcatac u cherben debe u yumba. U c'atbi ni najtäcäba ca'da: “¿Jäyp'e a cherben debe cä yum?” ");
INSERT INTO chfNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Une u yälbi cache' cien barril de aceite. De ya'i u yälbi ca'da: “Ya'anda ni jun bajca tz'ibi na betba; seb chumi' y tz'ibän cache' cincuenta namás a cherben debe”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ji'pat u c'atbi otro untu ca'da: “¿Aneba, jäyp'e a chen debe?” Une u yäli cache' cien costal de trigo. De ya'i u yälbi ca'da: “Ya'anda ni jun bajca tz'ibi na betba; tz'ibän cache' ochenta namás a chen debe”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jini u yum u yälbi u yajnoja ta patan, jini u patil xuch'bi u taq'uinba cache' mäx q'uen u c'ajalin uc'a u pojli cache' u chen tuba utic mantene jinq'uin pa'säbintic u patan. No'on cälbenetla que ni gente pancab que mach u tz'ombe u t'an Diosba más an u c'ajalin cache'da u yajna'tan uba t'oc u lotob que u ch'ocob Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’No'on cälbenetla ca'da: Ni taq'uin pancab a'uti tä sätcan t'oc cua' chichca mach utzba, pero anela, chenla patanla t'oc a taq'uinla ca' chich c'änä a chenla tuba totoj ajnic a ch'a'aljinla tä cielo jinq'uin a xe tä chämola y a wosintela tama ni otote bajca a xe tä paq'uin ajtäla. Es ca' a wälä a chenla ca' chich u chi ni winic tä' q'uen u c'ajalinba tuba ajnic u yamigojob jinq'uin pa'säbinti u patanba. ");
INSERT INTO chfNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Jini machca u chen tu toja t'oc jini mach u totoj che vale cua'ba u xe u chen tu toja täcä t'oc jini choj u valorba, y jini machca mach u che tu toja t'oc jini mach u totoj che vale cua'ba mach uxin u chen tu toja täcä t'oc jini choj u valorba. ");
INSERT INTO chfNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jin uc'a, si mach a chila tu toja t'oc jini taq'uin que a'uti tä sätcan t'oc cua' chichca mach utzba, Dios mach uxin u yäc'benet ta' c'äbla cua' chichca utztac que mach uxupba. ");
INSERT INTO chfNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Si mach a chila tu toja t'oc cua' chichca ta Dios que ya'an ta' c'äblaba, une mach uxin u yäc'benetla jini cua' chichca que u xe tä nonoj colan ta'alaba. ");
INSERT INTO chfNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Untu winic mach u ch'ä u yäq'ue' u pixan t'oc cha'tu u yum, uc'a untuba u xe u säte' t'oc y ni untuba u xe u yajna'tan. Untu u xe u tz'omben u t'an y ni untuba mach uxin u cherben caso. Mach u ch'ä a c'ajti'in Dios y a c'upän taq'uin täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aj fariseojob, jini u c'upänob taq'uinba, u yubijob upete ni u yäli aj Jesús y u tze'tijob. ");
INSERT INTO chfNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","De ya'i aj Jesús u yälbijob ca'da: ―Anela a susut chenla cua' chichca jini tu pänte' winicob tuba a wäc'ben u yäle'ob que tu toja a chenla, pero Diosba yuwi cache'da an a pixanla. Ayan jini lo que winicob tä' yoba u chänenob utic pero Diosba mach yo u chänen ni tz'ita'. ");
INSERT INTO chfNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Oni ajni ni ley que u tz'ibi aj Moisés y cua'tac u tz'ibi ajt'anob ta Dios tuba u ch'e' cuwina'tanla lo que Dios yo utic. De ya'i c'oti aj Juan ajc'ablesiaba. Desde jinq'uinba u tz'ayquinte u t'an Dios y cache'da an u manda Dios; y q'uen ayan que u chen uba purajob u tz'omben Dios tuba ajnic tu manda uneba. ");
INSERT INTO chfNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’U xe chich tä xupo ni cielo y u pancab. Pero jini ley ta Diosba mach uxin tä c'ote q'uin que mach u ni' chen vale. ");
INSERT INTO chfNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Upete machca chichca u waläctan jit'oc y lotojac t'oc otro ixicba u jup'e' u tanä de cherajtz'ijte', y machca chichca u lotojan t'oc ni ixic u waläcti jit'ocba u jup'e' u tanä de cherajtz'ijte' täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Ajni untu winic ajtaq'uini que u jele' uba t'oc ic'puq'uen noc' y t'oc noc' utz u c'aba' linoba, y upete q'uin u tuse' q'uen cua' tä c'uxcan utztacba. ");
INSERT INTO chfNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ajni täcä untu winic u c'aba' aj Lázaro tenten uba t'oc noj q'uenel yaj tu pächi. Une ya' ch'a'ca ti' yotot najtaq'uini, ");
INSERT INTO chfNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","uc'a tä' yo u c'uxe' ni u xixoma cua' tä c'uxcan que u yälo tä cab bajca an najtaq'uini tä c'uxnan. Ixta wichu' u te u lec'ben u yaj. ");
INSERT INTO chfNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","De ya'i u chi pasa que chämi ni winic u nume tä tentenbäjiba y ángelojob ta Dios u bisijob bajca an aj Abraham. Chämi täcä najtaq'uini y mujqui. ");
INSERT INTO chfNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jinq'uin najtaq'uini ya'an tä pule tu yajliba ajchämejob u t'äbsi u jut y u chäni nat cache' ya'an aj Abraham nämte' t'oc aj Lázaro. ");
INSERT INTO chfNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","De ya'i u chi awät u yäle' ca'da: “Cä pap Abraham, ch'ämbenon yajin y täscun aj Lázaro u maje' u ni'c'äb tama ja' tuba u sis'esbenon cac', uc'a mäx c'ux acubin bajca u pule'on ni wele c'ac'da”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero aj Abraham u yälbi ca'da: “Cä ch'oc, c'ajna'tan jinq'uin cuxulet toba äc'bintet upete cua' chichca tuba ajniquet utz, y che' chich täcä aj Lázaroba äc'binti upete cua' chichca mach utz. Badaba une u ch'a'alan ujin wida y ane a chen sufri ya'i. ");
INSERT INTO chfNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ya'an täcä ump'e noj gran ch'en entre de no'on t'ocob y anela, uc'a si ajnic machca u yolin pasic wida y c'axic bajca anet mach uxin u chen trebe, y niuntu mach u ch'ä pasic bajca anet y tic wida täcä”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","De ya'i najtaq'uini u yälbi ca'da: “Mäx cä c'atbenet jiq'uin, cä pap, que a täscun aj Lázaro tu yotot cä pap, ");
INSERT INTO chfNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","uc'a cä cänäntan cinco quitz'inob. Aj Lázaro u ch'e' u yälbenob cua' c'änä u chenob tuba mach ticob täcä wida tä tz'ibajtescanob”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aj Abraham u yälbi ca'da: “Unejob u cänäntan ni jun u tz'ibi aj Moisés y ni jun u tz'ibijob ajt'anob ta Dios. Jin u ch'e' u jiranob cua' u yäle' tuba u tz'onänob”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Une u yäli jiq'uin ca'da: “Toj chich une cä pap Abraham, pero si cuxpac untu ajchäme y xic ca'anob u xe u q'uexe' u c'ajalinob uc'a mach u ni' chen u tanäjob”. ");
INSERT INTO chfNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aj Abraham u yälbi ca'da: “Si mach u tz'ombejob jini u t'an Dios u tz'ibi aj Moisés y ajt'anob ta Diosba, mach uxin u tz'onänob täcä si cuxpac untu tan ajchämejob”. ");
INSERT INTO chfNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aj Jesús u yälbi u yajcänt'anob ca'da: ―U xe chich tä ajtä machcatac u chen cua' chichca tuba u yäc'ben u säte' u biji untu, pero ac'ä mäx c'ux ni castigo u xe tä äc'binte jini machca u yäc'ben u säte' u biji untuba. ");
INSERT INTO chfNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mejorica u xe tuba si cächbintic ump'e cha' ta juch'i' buc'a tu luc'ub y julcac tama nab y mach u yäc'ben u säte' u biji untu machca mu'to u totaj tz'omben to u t'an Diosba. ");
INSERT INTO chfNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Iran abala. ’Si a wermano u säte' t'oc ane q'uejpan. Y si u sujtä u q'uexe' u c'ajalinba, chen perdona. ");
INSERT INTO chfNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Si siete vez ump'e q'uin u säte' t'oc aneba y siete vez u sujtä u yälbenet cache' u q'uexi u c'ajalin bajca u säti t'oc ane, c'änä chich a chen perdona. ");
INSERT INTO chfNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","De ya'i u yajc'äncanob Cajnojala u yälbijob ca'da: ―Täclenon t'ocob cä tz'onän t'ocob más. ");
INSERT INTO chfNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Cajnojala u yälbijob ca'da: ―Unxim bec' mostaza mäx tz'utz', pero u c'ac'a' ch'ije. Si a tz'onänla icaba, mach u che si mäx tz'ita' ca' a wälä unxim bec' mostazaba, u ch'e' a wälbenla ica ni te' sicómoroda: “Boco aba tä cab y xiquet a päq'ue' aba tä ja' tama ni nab”, u tz'ombenetla ica. ");
INSERT INTO chfNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Si a cänäntanla untu ajpatan u cujän cab o u cänäntan ovejaba, jinq'uin u te tä jam u sujtä tan ototba, ¿a xe quira a wälben ca'da: “La'ix bada tä c'uxnan tä mesa”? Mach a chela ca' jini une. ");
INSERT INTO chfNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Mach quira a xe a wälben ca'da: “Cherbenon cua' tä c'uxcan, y de ya'i a xe a tuse' aba y a xe a wäc'benon cua' cä c'uxe' ixta que mach cä tzupsen c'uxnacon y buq'uicon, y ji'pat a xe tä c'uxnan aneba y tä buc'a”? ");
INSERT INTO chfNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿A wälben quira uc'adios u chi najpatan jini uc'a u chi lo que a wäc'bi u chen? Cäle' que mach. ");
INSERT INTO chfNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ca' jini täcä anela, jinq'uin a tzupsen a chenla upete cua'tac a'bintet a chenla, c'änä a wäle'la ca'da: “Ajpatanon t'ocob mach utzba, uc'a cä chi t'ocob jin chich lo que äc'binton cä chen t'ocob namás”. ");
INSERT INTO chfNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jinq'uin aj Jesús bixe u chen tä Jerusalén, numi tama ni cabob tä Samaria y tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tu yoche tama ump'e yoc p'i' caj c'otijob u nuc'tan diez wincärejob c'ojojtac t'oc ni yaj u c'aba' lepra, y colijob nat tä wa'tä. ");
INSERT INTO chfNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","U chijob noj t'an u yäle' ca'da: ―¡Jesús, Ajnojalet, ch'ämbenon yajin t'ocob! ");
INSERT INTO chfNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jinq'uin une u chäni u yälbijob ca'da: ―Corre cuxla ye'e abala tu pänte' ni palejob tuba aj judíosob. Jinq'uin bixe to u chenobba, laj pasi ni yaj tuyac'ojob. ");
INSERT INTO chfNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","De ya'i untu de unejob, jinq'uin u chäni que u yäq'ui ubaba, sutwäni y u ch'u'ul c'ajti'ben u c'aba' Dios t'oc noj gran t'an. ");
INSERT INTO chfNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nocwäni tu yoc aj Jesús u chinjatz'i u jut tä cab u yälben uc'adios u chi. U cab uneba tä Samaria. ");
INSERT INTO chfNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","De ya'i aj Jesús u yälbi ca'da: ―¿Mach quira diez ni tz'äcälquiba? ¿Cada an ni nueveba? ");
INSERT INTO chfNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Mach quira ajni machca sutwänic u ch'u'ul c'ajti'ben u c'aba' Dios seq'uen ni ajpäpä'cabda? ");
INSERT INTO chfNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","De ya'i u yälbi ni winic ca'da: ―Ch'oyen, corre cux, uc'a a tz'oni, jin uc'a a wäq'ui aba. ");
INSERT INTO chfNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ji'pat aj fariseojob u c'atbijob aj Jesús caq'uin u xe tä c'ote q'uin u chen manda Dios pancab. Une u p'albijob ca'da: ―U manda Dios pancab mach uc'ot t'oc cua' chichca jini tuba a chänenla, ca' chich jinq'uin u c'ote untu rey. ");
INSERT INTO chfNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Niuntu mach uxin u yäle' que si wida ayan o nanti ya'an, uc'a u täq'ui chich bada u chen manda Dios bajca anetla. ");
INSERT INTO chfNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","De ya'i u yälbi u yajcänt'anob ca'da: ―U xe tä c'ote q'uin a xe a wolin a chänenonla ca' chich a xe a chänenonla jinq'uin cä xe tä sujtä tä cha'num, no'on que sutwänon de winicba, pero mach to uxet a chänenonla. ");
INSERT INTO chfNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","U xe u yälbenetob anela ca'da: “Chänenla, ya'an wida”, o “Chänenla, ya'an jini”. No'on cälbenetla que mach xiquetla, y mach a tzäypätinla. ");
INSERT INTO chfNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Uc'a ca' u lem chawäc u chictan de ump'e la'o tä cielo ta tunxeba, ca' chich jini täcä cä xe cä ye'e' cäba täc jule no'onba que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero najtäcäba c'änä bon tz'ibajtescacon y ni winicob cuxujtac badaba mach uxin u sapänon. ");
INSERT INTO chfNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ca' chich ajni jinq'uin cuxu to aj Noé, che' chich u xe tä ajtä jinq'uin u xe tä c'ote q'uin sujlecon cha'num, no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","C'uxnijob, buq'uijob, lotojijob, y u yäq'uijob u ch'ocob tä lotojan ixta que jinq'uin c'oti q'uin tuba ochic aj Noé tama ni noj re'i jucub u c'aba' arca. De ya'i ti noj but'o u laj tzämsenob upete. ");
INSERT INTO chfNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ca' chich jini täcä ajni jinq'uin cuxu to aj Lot. C'uxnijob, buq'uijob, u chi manob, u chonijob cua' chichca, u päq'uijob u päc'äbijob y u chijob otote. ");
INSERT INTO chfNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero jimba q'uin jini que aj Lot pasi ya'i tä Sodoma yäli ump'e c'ac' y azufre que ya' ti tä cielo y u laj tzämsijob upete. ");
INSERT INTO chfNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ca' chich jini u xe u chen pasa täcä jinq'uin tajtzäc cä xe tä sujtä tä cha'num, no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Jimba q'uin jini machca mach'an tan yotot, y u c'ämbita ya'an tan ototba, mach ni' sutwänic tan otot u ch'e' u c'ämbita. Che' chich täcä machca ya'an tan pimi mach ni' sutwänic tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","C'ajna'tanla cache' jit'oc aj Lot, jinq'uin u suti uba u chänen tu patba, sutwäni de atz'am. ");
INSERT INTO chfNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Machca chichca yo u japän uba u xe chich tä chämo, y machca chichca mach u bäc'ta chämoba u xe u japän uba. ");
INSERT INTO chfNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Cälbenetla que jimba ac'äb jini täc xe tä sujtäba, cha'tu ajwäyejob u xe tä ajtä pan ump'e tz'en. Untu u xe tä ch'ämcan y ni otro untuba u xe tä colescan. ");
INSERT INTO chfNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cha'tu ixic u xe tä ajtä tä juch' nämte'. Untu u xe tä ch'ämcan y ni otro untuba u xe tä colescan. ");
INSERT INTO chfNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cha'tu u xe tä ajtä tan pimi y untu u xe tä ch'ämcan y ni otro untuba u xe tä colescan. ");
INSERT INTO chfNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jinq'uin u yubijob ca' jini, u yajcänt'anob u c'atbijob ca'da: ―Cajnoja, ¿cada u xe tä ajtäjob jini machcatac u colescanob? Une u yälbijob ca'da: ―U ch'e' a wina'tanla que anatz'äjbäli q'uin tuba äc'bintic u toje' u tanäjob machcatac que mach u ni' tz'ombe Diosba cachichcada que ajnicob, ca' chich ni ajma' u woylan ubajob cachichcada que ajnic najchämeba tuba u buq'ue'. ");
INSERT INTO chfNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","De ya'i aj Jesús u yälbijob ump'e tz'aji tuba u ye'benob cache' c'änä u paq'uin chenob c'änti'ya sin que jaq'uic ujinob. ");
INSERT INTO chfNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","U yälbijob ca'da: ―Ajni untu juez tan ump'e caj que mach u c'ajti'i Dios y niuntu winic mach u bäc'ta. ");
INSERT INTO chfNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ajni täcä tama ni caj jini untu neba' ixic que u bon ajne ca'an ni juez u yälben ca'da: “Japänon tu c'äb machca mu' u tz'ibajtesanon”. ");
INSERT INTO chfNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ni juez mach u yoli u chen ca' jini najtäcä, pero ji'pat tz'ita'ba ati tu c'ajalin ca'da: “Mach cä c'ajti'i Dios y niuntu winic mach cä bäc'ta täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero ni neba' ixicda u jaq'uesan cäjin. Jin uc'a cä xe cä japän tu c'äb machca u tz'ibajtesan, uc'a si machba, u xe u chen segui u bon sujtä u ticwesbenon cä c'ajalin”. ");
INSERT INTO chfNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","De ya'i Cajnojala u yäli ca'da: ―Ca' jini u yäli ni juez que mach u che tu tojaba. ");
INSERT INTO chfNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Mach quira u cherbejob tu toja Dios jini machcatac u yaquiba, jini machcatac u c'ajti'benob u c'aba' t'oc q'uin y ac'äb? U cherbenob chich tu toja. ¿U jäläcnan quira tuba u yäc'benob cua' u c'atänob? Mach ujäläcna. ");
INSERT INTO chfNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cälbenetla que seb u xe u cherbenob tu toja. Pero jinq'uin cä xe tä sujtä, no'on que sutwänon de winic, ¿cä xe wäre cä pojlen machcatac u tz'onänob pancab? ");
INSERT INTO chfNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ajni yebejob machcatac u tz'onijob que unejob ayanob tu toja, y otrosjobba mach yo u chänenob. Jin jinijob aj Jesús u yälbijob ni t'anda: ");
INSERT INTO chfNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Cha'tu winic bixijob tama ni noj ch'u'ul otot taj judíosob tuba u chen c'änti'yajob. Untuba aj fariseo y ni otro untuba ajcojtaq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Naj fariseoba ya' wa'ca une u chen c'änti'ya u juntuma ca'da: “Cälbenet uc'adios uc'a no'onba mach jinon ca' otros winicob, ajxuch'obba, ajmalujlejobba, ajcherajtz'ijte'ba, y mach jinon ca' najcojtaq'uin jini täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cha'petz' cada semana mach uc'uxnon y mach ubuc'on tuba cä c'ajti'in Dios. Upete lo que acä chen ganaba, de cada diez cua' chichca, ump'e acä'ben Dios”. Jintacda u yäli naj fariseo. ");
INSERT INTO chfNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Najcojtaq'uinba ya' wa'ca nat y mach u yoli u t'äbsen u jut tä cielo. Namás u bon jätz'e' u pecho tuba u ye'e' cache' ch'ocomi u pixan uc'a u tanä, y u yäle' ca'da: “¡Dios, ch'ämbenon yajin ajcherajtanäjon!” ");
INSERT INTO chfNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Cälbenetla que jinda winic Dios u yäc'bi colac tu toja tu bixe tu yotot, y ni otroba mach une, uc'a upete machca chichca u chen uba fama cache' u chen tu toja u xe tä quisnäjescan y machca u chen uba de ajch'och'ocaba u xe tä äc'binte xic de untu ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","De ya'i ajni machcatac u täsbijob aj Jesús bijch'oc tuba u yäq'ue' u c'äb tuyac'o u ch'u'ul chenob, pero jinq'uin u yajcänt'anob u chänijob ca' jini u q'uejpijob. ");
INSERT INTO chfNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero aj Jesús u joq'uijob ni bijch'oc bajca an y u yäli ca'da: ―Äctanla ticob ni bijch'oc bajca anon y mach a ch'acbenla u biji uc'a ca' jinijob machca u yochejob t'oc Dios tuba utic manda. ");
INSERT INTO chfNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cälbenetla que si mach a sapäla u manda Dios ca' u sapän untu bijch'ocba mach uxet tä ochela t'oc Dios tuba u chenet mandala. Toj une ni cälbenetlaba. ");
INSERT INTO chfNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","De ya'i untu ajnoja tuba aj judíosob u yälbi ca'da: ―Maestro, utz a c'ajalin ane. ¿Cua' une c'änä cä chen tuba paq'uin cuxlecon? ");
INSERT INTO chfNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aj Jesús u yälbi ca'da: ―¿Cua' uc'a a wälbenon cache' utz cä c'ajalin? Niuntu mach'an utz u c'ajalin seq'uen Dios une. ");
INSERT INTO chfNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A wi chich cua' u yäle' ni ley ta Dios: “Mach a cänäntan a tz'ijte'; mach a chen tzämsa; mach a chen xuch'; mach a sube' a lot t'oc jop'ojti'; olin a pap y a na'”. ");
INSERT INTO chfNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Une u yäli ca'da: ―Upete ni jindaba cä laj tz'oni desde jinq'uin ch'ocon toba ixta bada. ");
INSERT INTO chfNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jinq'uin u yubi aj Jesús ca' jiniba u yälbi ca'da: ―U colan to ump'e cosa a chen: chono upete lo que a cänäntan y laj pucben u taq'uini pobrejilba y a xe a cänäntan q'uen a matän tä cielo tä' choj u valorba, y la'ix bada tzäypätinon. ");
INSERT INTO chfNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jinq'uin u yubi ca' jini coli mäx triste uc'a tä' q'uen u taq'uin jini winic. ");
INSERT INTO chfNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jinq'uin aj Jesús u chäni cache' coli mäx triste u yäli ca'da: ―¡Mäx cach tuba ochic untu ajtaq'uini bajca u chen manda Dios! ");
INSERT INTO chfNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Untu ajcamello más seb u nume tu jut untz'it putz' que ochic untu ajtaq'uini bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Machcatac u yubijob jini que u yäli aj Jesús u yälijob ca'da: ―¿Caxca une u xe u ch'e' u japän uba jiq'uin? ");
INSERT INTO chfNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aj Jesús u yälbijob ca'da: ―Lo que mach u ch'ä u chenob winicobba, Dios u ch'e' u chen. ");
INSERT INTO chfNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aj Pedro u yälbi ca'da: ―Ubixto, no'on t'ocob acä waläcti upete lo que cä cänäntan t'ocob tuba cä tzäypätinet t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","De ya'i une u yälbijob ca'da: ―Totojtoj cälbenetla que machca u yäcti yotot o u pap y u na', o u jitz'inob y u säcunob, o jit'oc o u bijch'oc uc'a u manda Dios, ");
INSERT INTO chfNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","u xe tä äc'binte q'uen más bada tu pancabba de lo que u yäctiba, y jini q'uin que u xe tä c'oteba u xe tä äc'binte paq'uin cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","De ya'i aj Jesús u ch'i ni docejob u yajcänt'anob y u yälbijob ca'da: ―Ubixtola, bada cä bixela tä Jerusalén. Ya'i upete lo que u tz'ibijob ajt'anob ta Dios que u xe u chenon pasa no'on que sutwänon de winicba, u xe tä pase toj ca' chich tz'ibintiba. ");
INSERT INTO chfNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Uc'a cä xe tä äc'can tu c'äb ni gente que mach jin aj judíosob y cä xe tä xic'can y tä tz'ibajtescan y cä xe tä tubinte. ");
INSERT INTO chfNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","U xe u jätz'e'onob y de ya'i u xe u tzämsenonjob y u yuxp'elib q'uin cä xe tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ni doceba mach u chi entendejob niump'e cua' de lo que u yäliba uc'a ca' a wälä mäcbinti u c'ajalinob, y mach u yäc'bi uba cuentajob lo que älbintijob. ");
INSERT INTO chfNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jinq'uin aj Jesús c'oti nätz'ä tä Jericó ya'an untu ajchoc' que ya' chumca tu ch'ejpa bij tä tentenbäji. ");
INSERT INTO chfNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jinq'uin ni ajchoc' u yubi cache' nume u chen noj q'uenel gente bajca anba, u c'ati cua' jini ayan. ");
INSERT INTO chfNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ni gente u yälbijob cache' nume u chen aj Jesús, jini u cab tä Nazaretba. ");
INSERT INTO chfNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","De ya'i ni ajchoc' u chi noj awät u yäle' ca'da: ―¡Jesús, ane que u natil ch'oquet tuba ni rey aj David, ch'ämbenon yajin! ");
INSERT INTO chfNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Machcatac u bixe pänte'ba u q'uejpijob uc'a ch'ijcäbac, pero une más noj gran awät u chen u yäle' ca'da: ―¡Ane que u natil ch'oquet tuba ni rey aj David, ch'ämbenon yajin! ");
INSERT INTO chfNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","De ya'i aj Jesús tajwa'wäni y u täsqui tä ch'ämcan, y jinq'uin c'oti ca'anba u c'atbi ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Cua' a wo cä cherbenet? Ni ajchoc' u p'ali ca'da: ―Cajnoja, co äc'binticon cä chen chanä. ");
INSERT INTO chfNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aj Jesús u yälbi ca'da: ―¡Chänen jiq'uin! U jäbi uba a jut uc'a a tz'oni. ");
INSERT INTO chfNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","De ya'i seb u chi chanä y u tzäypäti aj Jesús u ch'u'ul c'ajti'in Dios, y upete ni gente u chänijob y u ch'u'ul c'ajti'bijob u c'aba' Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","De ya'i aj Jesús ochi tä Jericó y nume u chen tama ni caj jini. ");
INSERT INTO chfNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ajni ya'i untu winic u c'aba' aj Zaqueo, ajnoja une tajcojtaq'uinob y mäx q'uen u taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Une tä' yoba u chänen caxcamba naj Jesús, pero mach u ch'ä u chänen uc'a ayan noj q'uenel gente y uc'a uneba com yoc. ");
INSERT INTO chfNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","De ya'i u chi ancäre pänte' y t'äbi tuyac'o untec te' u c'aba' sicómoro tuba u chänen aj Jesús, uc'a ya' jini u xe tä nume. ");
INSERT INTO chfNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jinq'uin aj Jesús c'oti ya' jini u chäni isqui u yälbi ca'da: ―Zaqueo, seb jaquen uc'a dali c'änä colacon ta' wotot. ");
INSERT INTO chfNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","De ya'i une seb jaqui y u sapi t'oc ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jinq'uin u chänijob, upetejob u ju'läwanob tä t'an u yäle'ob cache' aj Jesús c'oti tä wawa'ne tu yotot untu winic ajcherajtanäba. ");
INSERT INTO chfNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","De ya'i aj Zaqueo wa'wäni y u yälbi najnoja ca'da: ―Ubin, Cajnoja, la mitad lo que cä cänäntanba cä xe cä'ben pobrejilba y si ayan machca chichca une cä'bi u toje' más de lo que c'änä u toje'ba, cä xe cä sutjatz'ben chämpetz' más de lo que cä ch'ämbiba. ");
INSERT INTO chfNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aj Jesús u yälbi ca'da: ―Bada machcatac ya'an tan yotot aj Zaqueo jäpä chich ayanob, uc'a aj Zaqueo u tz'ombi Dios ca' chich u tz'ombi Dios aj Abraham, u natil mam oniba. ");
INSERT INTO chfNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","No'on que sutwänon de winicba aton tuba cä sacän y cä japän machcatac sätä ayanobba. ");
INSERT INTO chfNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ni gente u yubijob cua'tac u yäli aj Jesús, y de ya'i u täq'ui aj Jesús u yäle' ump'e t'an, uc'a nätz'ä ayan tä Jerusalén y uc'a ya'an tu c'ajalinob ni gente que tajtzäc u xe tä chectan cache' Dios u xe u chen manda ya'i. ");
INSERT INTO chfNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jin uc'a u yäli ca'da: ―Ajni untu ch'unic bixi ump'e cab nat tuba äc'cac de rey tuba u chen manda tu cab tu sujtä tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Najtäcä u joq'ui diez u yajpatan, y cada juntu u yäc'bijob ump'e taq'uin u yälbenob ca'da: “Chenla patanla t'oc ni jini ixta que sutwänicon tä cha'num”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero u yajcäbnajob mach yojob t'oc y u täsquijob tu pat machcatac u xe u yäle' ca'da: “No'on t'ocob mach co t'ocob que ni winic jini xic de ajmanda täc'a t'ocob”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ji'pat, jinq'uin äc'qui de rey sutwäni tä cha'num y u yäq'ui tä jo'can u yajpatanob, jini machcatac u yäc'bi ni taq'uinba, tuba yuwina'tan jäyp'exca u chi ganajob t'oc ni taq'uin jini cada juntu. ");
INSERT INTO chfNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","C'oti bajca an ni u täsqui tä jo'can najtäcäba u yäle' ca'da: “Cajnoja, na taq'uin u chi gana diez veces u q'ue'nan lo que a'bonba”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Une u yälbi ca'da: “Utz cua' a chi. Ane untu ajpatanet utz. Uc'a a chi ca' chich c'änä a chen t'oc jini tz'ita' cä colesbetba, acä xe cä'benet ta' c'äb diez caj tuba a chen manda”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","De ya'i c'oti otro untu u yäle' ca'da: “Cajnoja, na taq'uin u chi gana cinco veces u q'ue'nan lo que a'bonba”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ni winic jini täcä u yälbi ca'da: “Ane a xe a chen manda täcä cinco caj”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Otro untu c'oti u yäle' ca'da: “Cajnoja, ya'anda na taq'uin cä ch'ujni tan ump'e payu. ");
INSERT INTO chfNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mäx bäc'ton t'oc ane uc'a ane untu winiquet que mach a ch'ämbe yajin a wajpatanob. A japän ni patan que u chi a lot, y a ch'uch'än lo que mach a päq'ui”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","De ya'i une u yälbi ca'da: “Ane untu ajpatanet mach utzba. T'oc jinchichba t'an a wäle'ba cä xe cälbenet si ayanet chich tu toja. Ane a wi cache' mach cä ch'ämbe yajin cajpatan, cache' cä japän ni patan que u chi cä lot y cä ch'uch'än lo que mach cä päq'uiba. ");
INSERT INTO chfNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Cua' uc'a jiq'uin mach a wäq'ui cä taq'uin tä banco, uc'a bada que asutwänonba cä ch'e' con to'o u gana?” ");
INSERT INTO chfNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","De ya'i u yälbijob machcatac ya' wa'cajob ya' jini ca'da: “Pa'säbenla ni taq'uin y äc'benla jini machca u cänäntan diez veces más de lo que äc'bintiba”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Unejob u yälbijob ca'da: “Cajnoja, ¿cua' uc'a? Uneba u cänäntan diez veces más taq'uin bada de lo que äc'bintiba”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ni rey u p'ali ca'da: “Cälbenetla que upete machca u cänäntanba u xe tä äc'binte más, y jini machca mach u cänänta cua'ba, ixta lo que u cänäntanba u xe tä pa'säbinte. ");
INSERT INTO chfNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pero jini machcatac cäräx t'oc no'onba, jini machcatac mach u yolijob xicon de rey tubajobba, täsenla wida y chunjätz'benla u pamob täc pänte'”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jinq'uin u tzupsi u yäle' ni t'anda aj Jesús pasi bixi pänte' de u yajcänt'anob tuba u chen segui u biji tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jinq'uin c'oti nätz'ä t'oc ni cajob tä Betfagé y tä Betania bajca an ni tz'ic u c'aba' Olivos, u täsqui pänte' cha'tu u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","U yälbijob ca'da: ―Cuxla tama ni caj ya'an pänte' jiniba. Ta' wochela ya'i a xe a pojlenla untu ch'oc burro cächä. Niuntu winic mach bay u chumti. P'änäla y täsenla wida. ");
INSERT INTO chfNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si ajnic machca u c'atbenetla cua' uc'a a p'äne'la, a xe a p'albenla ca'da: “Cajnojala c'änä uc'a”. ");
INSERT INTO chfNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Machcatac täsquintiba bixijob y u pojlijob ca' chich aj Jesús u yälbijob. ");
INSERT INTO chfNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jinq'uin mu'to u p'äne'ob ni ch'oc burroba, u yumob u yälbijob ca'da: ―¿Cua' uc'a a p'äne'la ni ch'oc burro? ");
INSERT INTO chfNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Unejob u p'alijob ca'da: ―Cajnojala c'änä uc'a. ");
INSERT INTO chfNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","U täsbijob aj Jesús, y u jeli' sisijob u yäc'bijob tu pat ni ch'oc burro, y u yäc'bijob u chumtan aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bajca u te tä nume aj Jesús ni gente u jäyijob u jeli' sisijob tan bij. ");
INSERT INTO chfNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jinq'uin c'otijob nätz'ä tu cheltä ni bij bajca u jaque untu tu pam ni tz'ic u c'aba' Olivos, upete u q'ue'nan u yajcänt'an u täq'uijob u ch'a'alesan ujinob y u ch'u'ul c'ajti'ben u c'aba' Dios t'oc noj gran t'an uc'a upete cua' chichca u chänijob que seq'uen Dios u ch'e' u chenba. ");
INSERT INTO chfNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","U yälijob ca'da: ―¡Ch'u'ul chere ayan ni reydaba que u täsqui cä Yumla Diosba! Uc'a uneba, sis'i u c'ajalinob aj Ajtä tä cielo t'oc no'onla. Ch'u'ul c'ajti'cac u c'aba' Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","De ya'i yebe aj fariseojob tama u q'ue'nan ni gente u yälbijob ca'da: ―Maestro, q'uejpan a wajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Une u p'albijob ca'da: ―Cälbenetla que si jindajob ch'ijcäbacobba, ni ji'tun mäx seb u xe u chen awätob. ");
INSERT INTO chfNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jinq'uin c'oti aj Jesús nätz'ä u chänen ni caj, uc'ni uc'a ni caj jini. ");
INSERT INTO chfNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","U yäli ca'da: ―¡Anela tä Jerusalén, mäx coli que a wina'tanla bada cache'da u ch'e' ajnic sis u c'ajalin Dios t'oc anela por no'on! Pero mach a tz'onäla; jin uc'a mach u ch'ä a chen entendela. Es ca' a wälä bälbintet a jutla. ");
INSERT INTO chfNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","U xe tä c'ote q'uinob jinq'uin machcatac cäräxtac t'oc anela u xe u tz'osenob ump'e bojte' titiqui caj, u xe u xoymäque'etla y u xe u cänäntanetla junxoyma uc'a mach ajnic cada pasiquetla. ");
INSERT INTO chfNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A cäjila u xe u laj jinesanob y upete machcatac ayan tama u xe u laj tzämsenob. Niump'e ji'tun tama ni caj mach uxin u colesanob tz'äjca tu pam u lot. U xe u chenob ca' jini uc'a anela mach a wina'tila caq'uin ajni ni Dios ca'anetla tuba u ch'ämbenet yajinla. ");
INSERT INTO chfNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","De ya'i ochi tan u bojte'i ni noj ch'u'ul otot taj judíosob y u täq'ui u pa'senob päti upete machcatac u chen chonojob y machcatac u chen manob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","U yälbijob ca'da: ―Dios u yäq'ui tä tz'ibinte tä jun ca'da: “Cototba es tuba bajca u yute c'änti'ya”; pero anelaba a chila ca' a wälä u yajliba ajxuch'. ");
INSERT INTO chfNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aj Jesús u ye'bijob u t'an Dios ni gente upete q'uin tu pam noj ch'u'ul otot taj judíosob. U yajnojajob pale y machcatac yuwi ni ley y ajt'äbälajob tuba ni gentejob u sacänob cache'da u ch'e' u tzämsenob. ");
INSERT INTO chfNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mach u pojlijob cache'da u ch'e' u tzämsenob, uc'a upete ni gente u yäq'ue' u chiquin u c'alin ubinob u t'an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ump'e q'uin aj Jesús mu'to u ye'benob ni gente tu pam noj ch'u'ul otot taj judíosob y u tz'aycun ni t'an utzba ta Dios jinq'uin c'otijob ajnojajob palejob y machcatac yuwijob ni ley. C'otijob t'oc täcä ni noxibilbajob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Unejob u yälbijob ca'da: ―Älbenon t'ocob caxca une u yäc'bet a chen upete ca' ni mu' a chenba. ¿Machca une u yälbet que u ch'e' a chen ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Une u p'albijob ca'da: ―Cä xe cä c'atbenetla täcä ump'e cosa. ");
INSERT INTO chfNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Älbenon si Dios u yäc'bi aj Juan u chen c'ablesia, o si winicob u yäc'bijob u chen c'ablesia. ");
INSERT INTO chfNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Unejob u maläc ch'i u c'ajalin u juntumajob u yäle'ob ca'da: ―Si cäle'la cache' Dios u yäc'bi u chenba, une u xe u yälbenonla cua' uc'a mach cä tz'ombila. ");
INSERT INTO chfNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Si cäle'la cache' winicob u yäc'bi u chen, upete ni caj u xe u yäc'benonla t'oc ji'tun uc'a unejob u totoj tz'onänob que c'äsi' aj Juan untu ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Unejob u p'alijob que mach yuwijob caxca une u yäc'bi aj Juan u chen c'ablesia. ");
INSERT INTO chfNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aj Jesús u yälbijob ca'da: ―Ni no'on täcä mach uxon cälbenetla caxca une u yälbon que u ch'e' cä chen upete ni mu' cä chenba. ");
INSERT INTO chfNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","De ya'i aj Jesús u täq'ui u yälbenob ni gente u t'an Dios t'oc ni tz'ajida: ―Untu winic u päq'ui noj q'uenel te'uva y u yäc'bijob tu c'äb machcatac u xe u cänäntäben, y une pasi bixi otro cab y jäläcni ya'i. ");
INSERT INTO chfNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jinq'uin c'oti q'uin ta c'ä'nac u jut ni te'uva u täsqui untu u yajpatan xic u c'atben ajcänän te'uvajob que u yäc'ben u parte de u jut ni te'uva. Ni ajcänän te'uvaba u cunijob ni machcatac c'oti u c'atänba y u täsquijob bixic sin que u yäc'ben niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","De ya'i u täsqui otro untu u yajpatan. Une täcä u cunijob y u cäräx älbijob y u yancäresijob sin que u yäc'ben niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","De ya'i u täsqui u yuxtulib u yajpatan, y unejob u chi lastimajob y u pa'sijob tama ni päc'äbi. ");
INSERT INTO chfNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’De ya'i u yum ni te'uva u yäli ca'da: “¿Cua' cä xe cä chen? Cä xe cä täscun cä yajben ajlo', bay toca tu chänenob u xe u tz'ombenob u t'an”. ");
INSERT INTO chfNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero jinq'uin ajcänän te'uvajob u chänijob jini ajlo' u maläc älijob ca'da: “Ni ajlo'daba u xe tä colan de u yum ni cabda cuanta chämi u pap. Cola cä tzämsenla uc'a colac täc'ala u caba ni te'uva”. ");
INSERT INTO chfNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","De ya'i u pa'sijob tama u caba ni päc'äbi y u tzämsijob. ¿Cache'da a wäle'la jiq'uin u xe u cherbenob ni ajpatanob jini u yum ni te'uva? ");
INSERT INTO chfNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U xe tä te u tzämsen najcänän te'uva jini y u yäc'ben tu c'äb otrosjob u caba ni te'uva. Jinq'uin u yubijob jinda, ni gente u yälijob ca'da: ―¡Dios mach a wira u yäq'ue' utic ca' jini! ");
INSERT INTO chfNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","De ya'i aj Jesús u chämbi u jutob u yäle' ca'da: ―¿Cua' ti jini ya'an tz'ibi tan u jun Dios jiq'uin, jini u yäle' ca'daba?: Jini ji'tun que u sutjatz'ijob ni ajcheraj ototob, jin une Dios u yäq'ui xic de u ch'ixma yoc otot. Ca' jini tz'ibi ayan tan u jun Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Machca chichca une que yälic tuyac'o ni ji'tun jini u xe tä xulujtan u bäque, pero si ni ji'tun yälic tuyac'o machca chichca une u xe u juch'än. ");
INSERT INTO chfNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","U yajnojajob palejob y machcatac yuwi ni ley u yolijob u q'ueche'ob jinchichba rato uc'a u yäc'bi uba cuentajob que aj Jesús u yäli ni tz'aji jini tuba u ye'benob que unejob u c'otejob t'oc ca' a wälä ni ajcänän te'uva malojobba. Mach u chijob ca' jini uc'a u bäc'tanob ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","De ya'i u täsquijob machcatac u ch'ucänob, jini machcatac u susut chen ubajob que u chenob tu tojaba. U ch'uquijob tuba u jiranob si u xe u yäle' ump'e t'an tuba u sube'ob t'ocba, uc'a ca' jini u ch'e' u yäc'ben tu c'äb ajmandajob ta gobiernoba. ");
INSERT INTO chfNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jin uc'a u c'atbijob ca'da: ―Maestro, cuwi t'ocob que a wäle' y a ye'e' tu toja y mach a yänäl chäne niuntu. A ye'e' u biji Dios tu toja. ");
INSERT INTO chfNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Älbenon t'ocob: ¿U ch'e' quira cä tojbenla derecho ni mero ajnoja rey, aj César, o mach? ");
INSERT INTO chfNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aj Jesús u yäc'bi uba cuenta que unejob u susut c'atbenob y u yälbijob ca'da: ―¿Cua' uc'a a wola a wäc'benon cä säte'? ");
INSERT INTO chfNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ye'benon ump'e ch'oc taq'uin. ¿Caxca u jut y u c'aba' ya'an tuyac'o? Unejob u p'alijob que tuba aj César. ");
INSERT INTO chfNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","De ya'i u yälbijob ca'da: ―Tojbenla aj César jiq'uin lo que es tuba, y äc'benla Dios lo que es tuba Diosba. ");
INSERT INTO chfNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mach u chi trebejob u yäc'ben u säte' t'oc u t'an tu pänte' ni gente. Tajch'icwäni u jutob u yubinob cache' u p'alän, y ch'ijcäbijob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","De ya'i c'otijob yebe aj saduceojob, jini machcatac u yäle' que mach uxin tä cuxpan ajchämejobba. Jin uc'a u c'atbijob aj Jesús ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, aj Moisés u yälbenonla tama ni jun u tz'ibiba que si chämic u yermano untu winic y u colesan jit'oc, pero mach'an u ch'ocobba, ni winic jini c'änä u ch'ämben jit'oc u c'äsi' hermano y u yäc'ben u mätan u tz'isa ni ixic tuba u tz'isben u bijch'oc, ca' a wälä tuba u yermano. ");
INSERT INTO chfNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ajni siete hermanojob. Ni hermano ajnojaba lotoji t'oc untu ixic, y ji'pat chämi y mach'an u ch'ocob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","U cha'tulib u ch'i y chämi täcä sin que ajnic u ch'ocob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","U ch'i täcä u yuxtulib, y che' chich täcä upete ni sietejob u ch'ijob ni ixic, y chämijob sin que u yäctan niuntu u ch'ocob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ji'pat chämi ni ixic täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tu xe tä cuxpan ajchämejob, jiq'uin, ¿caxcamba de unejob u xe u ch'e' de jit'oc ni ixic jini, uc'a upete ni sietejob u cänäntijob de jit'oc? ");
INSERT INTO chfNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","De ya'i aj Jesús u p'albijob ca'da: ―Winicob y ixictacob pancab badaba u lotojanob y u lotojescanob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tu xe tä c'ote q'uin tuba cuxpac tan ajchämejob uc'a bixic tä cielo jini machcatac yäcä ayanobba, mach uni' xin tä lotojanob y mach uni' xin tä lotojescanob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mach u ni' ch'ä chämic tä cha'num, uc'a ca' a wälä u xe tä c'otejob t'oc ni ángelojob ta Dios. Unejob u ch'ocob Dios uc'a u xe tä cuxpanob tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aj Moisés u tz'ibi tä jun cache' jinq'uin ajni bajca an ni chäcch'ix que ya'an tä puleba, u yäli que ni cä Yumla es u Dios aj Abraham, u Dios aj Isaac y u Dios aj Jacob. Jinq'uin u yäli ca' jini, une chich täcä u ye'i que ajchämejob u xe tä cuxpanob. ");
INSERT INTO chfNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Uc'a Diosba mach jin Dios tuba ajchämejob. Uneba Dios tuba machcatac cuxuba. Uc'a unejob totoj cuxu ayanob tu jut Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","De ya'i yebe machcatac yuwijob ni ley u yälbijob ca'da: ―Maestro, utz chich a wäli. ");
INSERT INTO chfNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","U yälbijob ca' jini uc'a mach u ni' olijob u c'atbenob niump'e cua' más. ");
INSERT INTO chfNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","De ya'i aj Jesús u yälbijob ca'da: ―¿Cache'da u ch'e' u yäle'ob que ni Cristo, jini u yaqui Dios tuba ajmandaba, es u natil ch'oc ni rey aj David? ");
INSERT INTO chfNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Uc'a tama ni jun u c'aba' Salmoba aj David chich u yäle' ca'da: Cä Yumla Dios u yälbi Cajnoja ca'da: “Chumi' täc noj, bajca c'änä chumlec machca olo tä chäninteba, ");
INSERT INTO chfNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ixta que mach cä'benet ta' c'äb upete machcatac que mach yo u chänenetob”. ");
INSERT INTO chfNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aj David u yäle' ca' jini cache' ni Cristo es u Yajnoja une. ¿Cache'da jiq'uin es u natil ch'oc täcä? ");
INSERT INTO chfNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Upete ni gente ya'an u yubinob jinq'uin aj Jesús u yälbijob u yajcänt'anob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Cänäntan abala t'oc machcatac yuwi ni ley, jini machcatac yo numicob t'oc u noj tamäl bucobba, jini machcatac tä' yojob äc'binticob u c'aba' Dios tan cajba. Unejob yojob chumlecob tuyac'o ni primer chumlib tama ni ch'uj tuba aj judíosob, y yojob numicob najtäcä tä c'uxnan bajca u yä'can ump'e c'uxba. ");
INSERT INTO chfNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Unejob u jajbenob u yototob neba'täc ixictac y de ya'i u susuc jäläcnanob tä c'änti'ya tuba ajnic u famajob cache' tu toja ayanob. Jin jinijob más q'uen u xe tä äc'binte u castigojob uc'a ni tanä u chijobba. ");
INSERT INTO chfNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","De ya'i u t'äbsi u jut aj Jesús u chänen najtaq'uinijob que u yäq'ue'ob u matän bajca u yälo ni taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","U chäni täcä untu neba' ixic mäx pobreba u yäq'ue' chap'e ch'oc taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","De ya'i aj Jesús u yäli ca'da: ―Totojtoj cälbenetla que ni pobre neba' ixic jiniba, ca' a wälä u yäq'ui más q'uen une que niuntu de unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Uc'a upete unejob u yäq'ui tz'ita' de lo que u chi sobrajob, pero ni ixic jini que mach u cänänta cua'tac c'änä uc'a, u laj äq'ui upete lo que u cänäntan tuba u numsen t'oc q'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ajni machcatac u yäle'ob cache' ni noj ch'u'ul otot tuba aj judíosob jele ayan t'oc pitzil ji'tun y cua' chichca matän u sijijob ni gente. De ya'i aj Jesús u yälbijob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Jini que mu'to a chänenla badaba u xe tä c'ote q'uin que mach uxin tä colan niump'e ji'tun tz'äjca tu pam u lot. Upete u xe tä laj jinescan. ");
INSERT INTO chfNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Unejob u c'atbijob ca'da: ―Maestro, ¿caq'uin u xe tä ajtä na wäliba? ¿Y cua' u xe tä chäninte tuba wina'tintic si anatz'äjbäli q'uin tuba utic? ");
INSERT INTO chfNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Une u yäli ca'da: ―Iranla que mach sucpequintiquetla, uc'a q'uen u xe tä tejob täj c'aba' u yäle' ca'da: “No'on ni Cristojon, ni u yacon Dios tuba ajmandaba”. U xe u yäle'ob täcä cache' anatz'äjbäli u xupiba q'uin. Mach me'ixto a tz'ombenla u t'anob. ");
INSERT INTO chfNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jinq'uin a ubinla que ayan jo'yan y buya, mach bäc'taquetla, uc'a upete ni jinda c'änä ajnic najtäcä, pero u xupiba upete mach to xin tä se'en te jinq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","De ya'i u yälbijob ca'da: ―Q'uen cabil cab u xe u t'äbsen ubajob tä buya t'oc u lot. Y reyjob u xe u t'äbsen ubajob tä buya tuyac'o otro reyjob. ");
INSERT INTO chfNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","U xe tä ajtä noj gran ajchaban, y cachichcada u xe tä ajtä jitz'o y toyoben yaj. U xe tä ajtä noj gran bac'ät y noj q'uenel seña tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero najtäcä de upete ni jinijobba a xe tä q'uechcanla y a xe tä tz'ibajtescanla y a xe tä äc'bintela tu c'äbob ajnojajob tama ni ch'uj tuba aj judíosob y a xe tä jup'canla tä cárcel. A xe tä bisintela tu pänte' reyjob y gobiernojob uc'a a tz'ombenonla cä c'aba' no'on. ");
INSERT INTO chfNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jinq'uin u xe u chenet pasalaba u ch'e' a wäle'la cache' no'on täsquinton tuba cä japän machcatac u tz'onän. ");
INSERT INTO chfNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ch'ä a c'ajalinla jiq'uin que mach a worin chen pensala cache'da a xe a p'alänla. ");
INSERT INTO chfNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Uc'a no'on cä xe cä'benetla ta' c'ajalinla cache'da u ch'e' a p'alänla utz. Ca' jini machcatac u t'äbsi ubajob ta'wac'ola mach uxin u pojlenob cua' u yäle'ob. Mach uxin u chen trebejob täcä u yäle' que mach toj cua' a wäle'la. ");
INSERT INTO chfNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ixta a paplajob täcä, a säcunob, a witz'inob, a parientejob y a lotob u xejob u yäq'ue'etla tä c'äbä, y yebe de anela a xe tä tzämsintela. ");
INSERT INTO chfNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Upetejob u xe u cräxna'tanetla uc'a a tz'onänla cä c'aba'. ");
INSERT INTO chfNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero niuntz'it a tzuc tan a pamla mach uxin tä säto. ");
INSERT INTO chfNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Si a c'älenla, u xe tä japinte a pixanla. ");
INSERT INTO chfNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Jinq'uin a xe a chänenla noj q'uenel soldadojob tu junxoyma ni caj tä Jerusalén, wina'tanla que ac'oti u q'uini tä jinescan. ");
INSERT INTO chfNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jimba hora jini c'änä bixicob tu pam tz'ic tä putz'ejob machcatac ya'an tama ni cab tä Judea. Machcatac ya'an tama ni cajba c'änä pasicob, y mach ni' ochicob tama ni caj machcatac ya'an tä campoba. ");
INSERT INTO chfNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jimba q'uinob jiniba u xe tä sutjatz'bintejob u jelo por lo que u chijobba uc'a tz'äctac tä ute upete lo que tz'ibi ayanba. ");
INSERT INTO chfNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ac'ä lástima machcatac an u tz'isa y machcatac mu'to u tzu'sen u ch'oc jimba q'uinob jini! Uc'a u xe tä ajtä noj gran tz'ibajtesia tama ni cab jini, y Dios u xe u ye'e' u cräxle t'oc ni gentejob jiniba. ");
INSERT INTO chfNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","U xe tä tulaj tzämsintejob t'oc machit, y machcatac u q'uechcanob u xe tä cocoj bisintejob cada cabil cab. Jini machcatac mach jin aj judíosob u xe u c'alin chen mandajob ni caj tä Jerusalén ixta que mach tz'äctac q'uin que mach uni' xin u chen mandajob u pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’U xe tä ajtä señajob tuyac'o ni q'uin, tuyac'o ni uj y tuyac'o ajlucerojob, y tu pancabba u xe tä ajtä ump'e noj gran bac'ät cada cabil cab. U xe u sinlaj chen pensajob cua' chichca jini uc'a ni noj gran bänäcne u chen ni mar y ni t'olja'. ");
INSERT INTO chfNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Winicob u xe tä choc chämojob t'oc bac'ät y por u chänenob cua'tac u te tuyac'o u pancab, uc'a upete cua'tac ayan u chictanob tä cielo u xe u laj säte' u bijijob. ");
INSERT INTO chfNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","De ya'i u xe u chänenonjob, no'on que sutwänon de winicba. Cä xe tä te tama ump'e bucla t'oc poder y q'uen cä pitzilan. ");
INSERT INTO chfNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jinq'uin ni jinijobba u täq'ue' u chen pasa, ch'a'alesan ajinla y mach bäc'taquetla, uc'a anatz'äjbäli q'uin tuba japintiquetla. ");
INSERT INTO chfNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","De ya'i u yälbijob ump'e tz'aji ca'da: ―Chänenla ni te' higo y upete ni te'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Jinq'uin a chänenla u q'uexe' uba u yopoba, anela chich a wila que ya mero tuba wa'lec ni q'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Che' chich täcä anela, jinq'uin a chänenla que mu' u yute ni cosajob jiniba, wina'tanla que u manda Dios anatz'äjbäli. ");
INSERT INTO chfNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Totojtoj cälbenetla que ni gente cuxujtac jimba tiempo jiniba mach uxin tä laj chämojob ixta que mach laj utic upete ni jindaba. ");
INSERT INTO chfNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ni cielo y u pancabba u xejob tä xupo, pero ni cä t'an no'onba mach uxin tä xupo une. ");
INSERT INTO chfNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cänäntan abala, uc'a si machba, tajtzäc u xe tä c'ote ni q'uin jini y u xe u chenet pasala cua'tac ni cäli samiba. Es ca' a wälä ump'e cajquiba que tajtzäc u q'ueche' untu animal. Jin uc'a mach me'ixto a täq'ue' chibälnaquetla, ni a ch'a'alesan ajinla t'oc cua' chichca mach utz, ni a jaq'uesan ajinla täcä t'oc cua' chichca que c'änä utic, y ca' jini xiquet a yäne' a c'ajalinla. ");
INSERT INTO chfNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Uc'a ni q'uin jini u xe tä c'ote tuyac'ojob upete a'ajtäjob tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Paq'uin ajniquet a c'alin pitänla y paq'uin chen c'änti'yala tuba a chen trebe a japän abala t'oc upete ni jini que u xe tä teba, y tuba wa'wäniquetla täc pänte' no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tä q'uin aj Jesús u ye'bijob u t'an Dios tama ni noj ch'u'ul otot tuba aj judíosob, y ac'äbba u pase u colan tu pam ni tz'ic u c'aba' Olivosba. ");
INSERT INTO chfNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ic'sapanto upete ni caj u te ca'an une tama ni noj ch'u'ul otot tuba aj judíosob tuba u yubinob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Anatz'äjbäli ni q'uin ch'uje jinq'uin u c'uxcan ni waj que mach jusuba. Ni q'uin ch'uje jiniba u c'aba' Noj Paxcu'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","De ya'i u yajnojajob pale y machcatac yuwijob ni ley u saquijob cache'da u ch'e' u tzämsenob aj Jesús mucu uc'a bäc'tajob t'oc ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","De ya'i aj Satanás ochi tuyac'o aj Judas, jini u chap'elib u c'aba' aj Iscarioteba. Uneba es untu de ni doce ajcänt'anob taj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Une bixi u lotän ajnojajob pale y ajnojajob tajcänänyajob tuba ni noj ch'u'ul otot cache'da u ch'e' u yäc'ben tu c'äbob. ");
INSERT INTO chfNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Unejob ch'a'ali ujinob y u tuslijob que u xe u yäc'benob taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Une u yäli que utz'an y u täq'ui u sacän cache'da u ch'e' u yäc'ben tu c'äbob jinq'uin mach'an gente ya' jini. ");
INSERT INTO chfNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","De ya'i c'oti q'uin jinq'uin u c'uxcan ni waj mach jusuba. Jimba q'uin jini c'änäli tzämsintic untu ch'oc oveja tuba u yäc'benob ni u matän Dios tan ni paxcu'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aj Jesús u täsqui aj Pedro y aj Juan u yälbenob ca'da: ―Corre cuxla, cherbenonla ni ch'oc oveja tuba ni paxcu' uc'a cä c'uxe'la. ");
INSERT INTO chfNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Unejob u c'atbijob ca'da: ―¿Cada a wo cä chen t'ocob upete ni jini? ");
INSERT INTO chfNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aj Jesús u p'albijob ca'da: ―Ta' wochela tama ni caj a xe a nuc'tanla untu winic que u bisan ump'e p'u de ja'. Tzäypätinla ixta tama ni otot bajca u xe tä ocheba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","A xe a wälbenla u yum ni otot ca'da: “Ni Maestro u yälbenet ca'da: ¿Cada an ni cuarto bajca cä xe cä c'uxe' ni ch'oc oveja tuba ni paxcu' t'oc cajcänt'anob?” ");
INSERT INTO chfNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","De ya'i une u xe u ye'benetla ump'e noj cuarto tama u cha'täq'uib otot isqui. Ya'an upete ni c'ämbita tama. Ya' jini a xe a chenla. ");
INSERT INTO chfNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","De ya'i bixijob y u pojlijob ca' chich u yälbijob aj Jesús, y u chijob ni oveja tuba ni paxcu'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jinq'uin c'oti hora, aj Jesús chunwäni tä mesa. Chunwänijob nämte' t'oc une ni doce ajc'äncanob, jini u yälbinte apóstolesjobba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","De ya'i aj Jesús u yälbijob ca'da: ―¡Mäx coli cä c'uxe' jini ch'oc oveja tuba ni paxcu' nämte' t'oc anela antes de tzämsinticon! ");
INSERT INTO chfNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Uc'a cälbenetla que mach uni' xon cä c'uxe' ixta que mach c'otic u q'uini u chen manda Dios y u chectesan cua' uc'a u yäq'ui tä ute ni q'uin ch'uje u c'aba' Noj Paxcu'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","De ya'i u ch'i ni pote de c'äb uva, u yäc'bi u c'aba' Dios y u yäli ca'da: ―Dala, mul uch'enla. ");
INSERT INTO chfNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Uc'a cälbenetla que mach uni' xon cuch'en ni c'äb uva ixta que mach c'otic u q'uini u laj chen manda Dios upete machcatac cuxujob pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","De ya'i u ch'i ni waj, u yäc'bi u c'aba' Dios, u taji y u yäc'bijob. U yäli ca'da: ―Jindaba cä cuerpo une que u yäc'can tuba tzämsintic por anela. Ca'da a xe a chenla tuba a c'ajti'inonla. ");
INSERT INTO chfNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Najtäcä c'uxnijob y ji'pat aj Jesús u ch'i ni pote de c'äb uva täcä u yäle' ca'da: ―Jini c'äb uvadaba cä ch'ich'e une que u xe tä ancäran por anela. Cä ch'ich'e u xe u ye'e' cache' toj une jini Dios u yäli que u xe u yäq'ue' tä ute tzijibba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Ubixtola, machca u xe u yäq'ue'on tä c'äbäba ya'anda nämte' t'oc no'on tä mesa. ");
INSERT INTO chfNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","No'on que sutwänon de winic cä xe tä chämo ca' chich ti tu c'ajalin Dios chämicon; pero ¡ac'ä mäx c'ux ni castigo u xe tä äc'binte ni winic que u xe u yäq'ue'on tä c'äbäba! ");
INSERT INTO chfNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","De ya'i u yajcänt'anob u täq'uijob u maläc c'atänob caxcamba de unejob u xe u chen ni jini que u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ji'pat ajni täcä ump'e jobole de t'an entre de ni ajcänt'anob tuba u jiranob caxca une wäre de unejob u xe más ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aj Jesús u yälbijob ca'da: ―Reyjob tu pancab u chen ca' chich yo u cherbenob ni machcatac mu' u chen manda. Unejob que u chen mandajob ni genteba u yälcan cache' utz cua'tac u cherbenob ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero anela mach uxet a chenla ca' jini. Jini más ajt'äbäla de anelaba c'änä ajnic ca' ni más ajch'och'ocaba. Jini más ajnoja de anelaba c'änä ajnic ca' ni machca u cherben u patan u lotba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Camba más ajnoja, machca u chumtä tä mesa tä c'uxnan, o jini machca u täsben cua' u c'uxe'ba? Jini machca u chumtä tä mesa es más ajnoja, pero no'onba ya'anon t'oc anela ca' jini machca u täsen cua' tä c'uxcanba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Anelaba paq'uin ajnetla t'oc no'on jinq'uin u chon pasa cua' chichca jini. ");
INSERT INTO chfNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jin uc'a no'on cä xe cä'benetla a chen mandala ca' chich cä Pap u yäc'bon no'on cä chen manda. ");
INSERT INTO chfNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","A xe chich tä c'uxnanla y tä buc'ala täc mesa bajca cä chen manda. A xe tä chumtäla y a xe a chen mandala u natil ch'ocob jini doce u yajlo' aj Israel ca' chich u chen manda untu rey. ");
INSERT INTO chfNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","De ya'i u yäli täcä Cajnojala ca'da: ―Simón, Simón, ubixto, anela c'ätä uc'aletla aj Satanás. Uneba yo u jiran si u ch'e' u yäq'ue'etla tä säto. Yo u jiran si a xe tä colanla ca' a wälä u p'osi ni trigo que u sisinteba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero no'on cä chi c'änti'ya por ane que mach a wäctan a tz'ombenon. Jinq'uin a xe tä sujtä t'oc no'on tä cha'numba, a wäc'ben a wermanojob que u c'alin tz'onänob más. ");
INSERT INTO chfNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aj Simón u yälbi ca'da: ―Cajnoja, mach u che cua' t'oc no'on si bixicon nämte' t'oc ane tä cárcel o tzämsinticonla nämte'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aj Jesús u yälbi ca'da: ―Pedro, cälbenet que ajtze mach uxin u chen uq'ue dali ixta que mach a wäle' uxpetz' que mach a chon conoce. ");
INSERT INTO chfNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","De ya'i aj Jesús u yälbijob ca'da: ―Jinq'uin cä täsquetla sin ch'uji' taq'uin, sin morral y sin pächi'oc, ¿u chet quira faltala cua' chichca jini? Unejob u yälbi que mach u chi faltajob cua'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Une u yälbijob ca'da: ―Pero badaba si a cänäntanla ch'uji' taq'uinba bisanla, y che' chich täcä a morral. Machca mach u cänänta untz'it machitba c'änä u chone' u jeli' sisi y u mäne' untz'it machit tuba u japän uba t'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Uc'a cälbenetla cache' c'änä laj utic cumpli jini tz'ibi ayan tan u jun Dios de no'onba, jini u yäle' ca'daba: “Älqui cache' u xe tä cherbinte uneba ca' chich u cherbinte machcatac mach u tz'onä u manda Diosba”, uc'a lo que tz'ibi ayan de no'onba c'änä laj utic ca' chich u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Unejob u yälbi ca'da: ―Cajnoja, ya'anda chatz'it machit. Une u yälbijob que an t'oc. ");
INSERT INTO chfNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","De ya'i pasi tama ni caj y bixi bajca an ni tz'ic u c'aba' Olivos, ca' chich nämä u paq'uin chenba. U yajcänt'anob u tzäypätijob. ");
INSERT INTO chfNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jinq'uin c'oti ya' jini u yälbijob ca'da: ―Chen c'änti'yala tuba a japän abala t'oc cherajtanä. ");
INSERT INTO chfNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","De ya'i u tz'eji uba t'oc unejob u nät'an ca' bajca u ch'e' julcac ump'e ji'tun. Nocwäni ya' jini u chen c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","U yäli ca'da: ―Cä Pap, si a woba, pa'säbenon ni tz'ibajtesiada, pero mach a chen cama' co no'onba, chen cama' chich a wo aneba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","De ya'i tutz'i untu ángelo que ya' ti tä cielo u yäc'ben u muc'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","C'ac'a' ch'ocomi u pixan, ca' a wälä chämo u chenba, y más u c'ac'a' chen c'änti'ya. De ya'i c'ac'a' xi tä bulich'an y u t'ule tä cab jini bulich ca' a wälä noj q'uenel ch'ich'. ");
INSERT INTO chfNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jinq'uin u tzupsi u chen c'änti'ya, ch'oyi y bixi bajca an u yajcänt'anob. C'oti u pojlen que wäye u laj chenob uc'a ch'ocomi u pixanob. ");
INSERT INTO chfNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aj Jesús u yälbijob ca'da: ―¿Cua' uc'a a wäyela? Ch'oyenla y chen c'änti'yala uc'a a japän abala t'oc ni cherajtanä. ");
INSERT INTO chfNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jinq'uin mu'to u t'anba c'oti noj q'uenel gente. C'oti täcä jini winic u c'aba' aj Judasba, uneba untu de ni docejob, u bixe pänte' tuba u ye'ben u bijijob ni noj q'uenel gente. U natz'i aj Jesús tuba u tz'utz'än. ");
INSERT INTO chfNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero aj Jesús u yälbi ca'da: ―Judas, ¿t'oc ump'e tz'utz'om a wäq'ue'on quira tä c'äbä, no'on que sutwänon de winic? ");
INSERT INTO chfNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Machcatac ya'an t'oc aj Jesús, jinq'uin u chänijob cua' u xe u chen pasaba u c'atbijob aj Jesús ca'da: ―Cajnoja, ¿cä'ben t'ocob quira t'oc machit? ");
INSERT INTO chfNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","De ya'i untu de unejob u tzepi untu u yajpatan u noj ajnoja pale y u chunjätz'bi u chiquin tu nojba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero aj Jesús u yäli ca'da: ―An t'oc, äctanla. Y u tälbi u chiquin y u yäq'ui uba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","De ya'i aj Jesús u pequi ajnojajob pale y ajnojajob tajcänän ch'u'ul otot tuba aj judíosob y ajt'äbälajob, jini machcatac tijob u q'ueche'ob. U yälbijob ca'da: ―¿Apasetla t'oc machit y t'oc te' täjcac'o ca' machca u pase u q'ueche' ajxuch'ba? ");
INSERT INTO chfNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jinq'uin ajnon nämte' t'oc anela cada q'uin tama ni noj ch'u'ul otot mach a sätz'i a c'äbla a q'ueche'onla. Pero badaba c'oti hora tuba a chenla lo que a wola. Jinda ni hora tuba u ye'e' u poder jini ajnoja tuba it'obniba, jini aj Satanásba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","De ya'i unejob u q'uechijob u bisanob tu yotot mero ajnoja palejob. Aj Pedro u tzäypäti, pero nat. ");
INSERT INTO chfNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","De ya'i ajni machcatac u tz'äbijob c'ac' nätz'ä pan otot y chunwänijob u junxoyma. Aj Pedro chunwäni täcä nämte' t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","De ya'i untu ixpatan u chäni aj Pedro bajca chumca ti' c'ac'. Une ch'icwäni u jut tuyac'o y u yäli ca'da: ―Jinda winic ajni nämte' t'oc aj Jesús täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aj Pedro u yäli que mach toj. U yäli ca'da: ―Ixic, mach cä che conoce. ");
INSERT INTO chfNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ji'pat tz'ita' otro untu u chäni y u yäli ca'da: ―Ane es untu de unejob. Aj Pedro u yäli ca'da: ―Lo', mach jinon. ");
INSERT INTO chfNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ji'pat ca' ump'e hora, otro untu u totoj äli ca'da: ―Toj chich, jinda winic ajni t'oc une nämte', uc'a u cab une tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aj Pedro u yäli ca'da: ―Lo', mach cuwi cua' a wäle'. Jinq'uin mu'to u t'an aj Pedro, u chi uq'ue ajtze. ");
INSERT INTO chfNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","De ya'i Cajnojala u suti uba u chänen aj Pedro, y aj Pedro u c'ajti'i jini t'an u yälbi Cajnojala ca'daba: “Antes que u chen uq'ue ajtze a xe a wäle' uxpetz' que mach a chon conoce”. ");
INSERT INTO chfNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aj Pedro pasi päti y u c'ac'a' chi uq'ue. ");
INSERT INTO chfNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Machcatac ya'an u cänäntan aj Jesús u tze'tijob y u jätz'ijob. ");
INSERT INTO chfNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","U mäcbijob u jut t'oc payu, u cunijob tu jut y u yälbenob ca'da: ―Si ajt'anet ta Dios älä machca u cunet. Ca'da u yälbijob. ");
INSERT INTO chfNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","U bon chijob tzuc t'an u cäräx älbenob. ");
INSERT INTO chfNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jinq'uin junch'äcniba u laj woyi ubajob ni noxibilbajob tuba ni caj y ajt'äbälajob ta pale y machcatac yuwijob ni ley y u bisijob bajca an a'äc'c'ajalinob tubajob. U c'atbijob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿Ane quira ni Cristojet, jini u yaquet Dios tuba a chen manda aj Israelobba? älbenon t'ocob. Une u p'albijob ca'da: ―Si cälbenetla cache' jinon mach uxet a tz'onänla. ");
INSERT INTO chfNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y si no'on cä c'atbenetla si jinonba, mach uxet a p'albenonla y mach uxet a chaje'onla. ");
INSERT INTO chfNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero desde badaba no'on que sutwänon de winic cä xe tä chumtä tu ch'ejpa Dios, jini an u poderba. Cä xe tä chumtä tu noj bajca c'änä chumlec untu que tä' olo tä chäninteba. ");
INSERT INTO chfNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Upete u c'atbijob ca'da: ―¿Ane quira u Yajlo'et Dios jiq'uin? Aj Jesús u p'albijob ca'da: ―Anela a totoj äle'la cache' u Yajlo'on Dios. Jinon chich. ");
INSERT INTO chfNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","De ya'i unejob u yälijob ca'da: ―¿Cua' tuba c'änä cä sacänla más ajsubob? Watoda acubila cache' une u yäli t'oc u ti'. ");
INSERT INTO chfNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","De ya'i ch'oyijob upete ni gente y u bisijob aj Jesús tu c'äb aj Pilato. ");
INSERT INTO chfNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ya'i u täq'uijob u sube'ob u yäle'ob ca'da: ―Ni winicda cä pojli t'ocob u ye'benob ni gentejob tan cä cabla ump'e bij que mach utzba. U yäle' que mach utz cä tojbenla derecho cä reyla aj César. U yäle' que uneba ni Cristo, jini rey que Dios u yaqui tuba u chen manda aj Israelob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","De ya'i aj Pilato u c'atbi aj Jesús ca'da: ―¿Ane quira ni reyjet tuba aj judíosob? Une u p'albi ca'da: ―Jinon chich ca' mu' a wäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","De ya'i aj Pilato u yälbijob ajnojajob palejob y ni noj q'uenel gente ca'da: ―No'on mach cä pojläbe niump'e u tanä ni winicda. ");
INSERT INTO chfNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Unejob más u c'ac'a' sube'ob u yäle'ob ca'da: ―Une u jobben u c'ajalinob ni gente. U ye'benob ump'e bij que mach utz tama upete ni cab tä Judea desde tä Galilea ixta wida tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jinq'uin aj Pilato u yubi cache' u yälijob ni t'an jini, Galilea, u c'ati si ya' chich u cab ni winic jini. ");
INSERT INTO chfNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jinq'uin u yubi aj Pilato cache' tä Galilea chich u cab aj Jesús, u täsqui bajca an aj Herodes, uc'a aj Herodesba, une ni u chen manda ya'i tä Galilea. Aj Herodes ya'an tä Jerusalén täcä jimba q'uinob jini tä wawa'ne. ");
INSERT INTO chfNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jinq'uin aj Herodes u chäni aj Jesús mäx ch'a'ali ujin, uc'a anät'i q'uin que tä' yoba u chänen. A'uti u yubin q'uen cua' chichca que u chen ni winic jini y u yoli u chänen jini que u chen aj Jesús que niuntu winic mach u ch'ä u chenba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aj Herodes u bon c'atbi q'uen cua' chichca jini, pero aj Jesús mach u p'albi cua'. ");
INSERT INTO chfNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","U yajnojajob palejob y machcatac yuwi ni ley ya' wa'ca ayanob täcä u bon sube'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aj Herodes y u soldadojob täcä u tze'tijob y u xiq'uijob. De ya'i u xojbijob ump'e u noj buc c'äntz'alanba ca' u c'äne' untu rey y u täsquijob tä cha'num ca'an aj Pilato. ");
INSERT INTO chfNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jimba q'uin jini aj Herodes y aj Pilato sis'i u c'ajalinob, uc'a ajniba u maläc cräxna'tan ubajob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","De ya'i aj Pilato u täsqui tä jo'canob ajnojajob pale y ajt'äbälajob y upete ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","U yälbijob ca'da: ―Anela a täsbonla ni winicda uc'a a wälila cache' u ye'ben ni gente ump'e bij mach utzba. No'on cä bon c'atbi cua' chichca ta' pänte'la y mach cä pojläbi niump'e u tanä cama' a sube'laba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aj Herodes täcä mach u pojläbi niump'e u tanä. Jin uc'a u täsqui bajca anonla tä cha'num. Ubixtola, ni winicda mach'an u tanä ta tzämsintic. ");
INSERT INTO chfNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Acä xe cäq'ue' tä jätz'can jiq'uin, y ji'pat cä xe cä chaje'. ");
INSERT INTO chfNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cada q'uin ch'uje aj Pilato c'änä u chaje' untu de ni ya'anob tä cárcelba, jini machca u c'atän gente chajcacba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero upete ni gente tomp'e u chi noj gran t'anob u yäle'ob ca'da: ―¡Bisan ni winicda tä tzämsinte! ¡Co t'ocob que a chaje' aj Barrabás! ");
INSERT INTO chfNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aj Barrabásba ya'an tä cárcel uc'a u t'äbsi buya tuyac'o machcatac u chen manda ni caj jini y uc'a u chi tzämsa. ");
INSERT INTO chfNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jin uc'a aj Pilato u yoli u chaje' aj Jesús, y u pequijob tä cha'num ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero más muc' u chi noj gran t'anob ni gente u yäle' ca'da: ―¡Tzämsintic tä cruz! ¡Tzämsintic tä cruz! ");
INSERT INTO chfNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","De ya'i aj Pilato u yälbijob u yuxpetz'ib ca'da: ―¿Cua' uc'a? ¿Cuaxca u chi? Mach cä pojläbi niump'e u tanä ta tzämsintic. Jin uc'a acä xe cäq'ue' tä jätz'can y ji'pat cä chaje'. ");
INSERT INTO chfNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","U c'ac'a' chijob t'anob u c'atänob tzämsintic tä cruz. Ni gente y ajnojajob pale u c'ac'a' chi awätob ixta que mach ch'ijcäbac aj Pilato. ");
INSERT INTO chfNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","De ya'i aj Pilato u yäq'ui tä ute ca' chich u c'atänob upete ni gente. ");
INSERT INTO chfNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","U chaji ni winic que u c'atijob chajcacba, jini ajni tä cárcel uc'a u t'äbsi buya tuyac'o machcatac u chen manda ni cajba, y uc'a u chi tzämsaba. Aj Pilato u yäq'ui aj Jesús tu c'äbob tuba u cherbenob ca' chich yojob u cherbenba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jinq'uin mu'to u bixejob t'ocba u q'uechijob untu winic u c'aba' aj Simón, u cab tä Cirene. Ya' ati tan pimi, bixe u chen tu yotot. U yäc'bijob u bisan tu pechquem u cruz aj Jesús. Aj Jesús u bixe pänte', y une u te pati t'oc ni cruz. ");
INSERT INTO chfNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Noj q'uenel gente u bixe tu pat aj Jesús. Noj q'uenel ixictac täcä u bixejob u yuc'tanob. C'ac'a' ch'ocomi u pixanob uc'a aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Aj Jesús u suti uba u chänenob u yälbenob ca'da: ―Anela ixictac tä Jerusalén, mach a wuc'tanonla, uc'tan abala y uc'tan a bijch'ocla. ");
INSERT INTO chfNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Uc'a u xe tä c'ote q'uin que u xe tä älcan ca'da: “Más utz tubajob ni ixictac que mach u ch'ä u mätan u tz'isa, jini machcatac mach'an u bijch'ocba, jini machcatac mach bay u tzu'si niuntu u ch'ocba”. Ca' jini u xe tä älcan uc'a ni noj gran tz'ibajtesia que u xe tä yälo tuyac'o a cäjila. ");
INSERT INTO chfNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jimba q'uinob jini gente u xe u yälbenob ni nuc tz'icjob ca'da: “Yäliquetla täjcac'o t'ocob uc'a a tzämsenon t'ocob”. Bit tz'icob u xe u yälbenob ca'da: “Mule'on t'ocob”. ");
INSERT INTO chfNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Si no'on mach'an cä tanä, ca' a wälä untec te'on cuxuba, y u cherbenonjob ca'da, ¿cua' jini a wäle'la u xe tä cherbinte machcatac tä' malojobba, jini ca' a wälä untec te'job chäc tiquinba? ");
INSERT INTO chfNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","U bisijob otros cha'tu winic täcä nämte' t'oc aj Jesús tuba u tzämsenob, uc'a unejob u c'ac'a' sätijob t'oc ni ley tuba ni cab jini. ");
INSERT INTO chfNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tu c'otejob ya'i bajca u yälbinte u c'aba' tä Calavera u sämbijob u c'äb aj Jesús tä cruz. Che' chich täcä u chijob t'oc jini que u c'ac'a' sätijob t'oc ni ley tuba ni cajba. U yäq'uijob untu tu noj aj Jesús y otro untuba tu tz'ej. ");
INSERT INTO chfNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","De ya'i aj Jesús u yäli ca'da: ―Cä Pap, cherbenob perdona u tanäjob jini machcatac mu' u tz'ibajtesanonjobba, uc'a mach yuwijob cua' mu' u chenob ―ca'da u yäli aj Jesús. U bucla aj Jesúsba u yäläsijob uc'a u jiranob caxcatac une u xe u ch'e'. ");
INSERT INTO chfNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ya' wa'cajob ni gente u chänenob. Jini ajt'äbälajob u tze'tijob aj Jesús u yäle'ob ca'da: ―U japi otrosjob. Quiranla si u japän uba u juntuma si toj cache' une ni Cristo, jini u yaqui Diosba tuba u chen manda aj Israelob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ni soldadojob täcä u te u natz'änob tuba u susuc subbenob c'äb pajäla tuba u yuch'en. Ca' jini u bon xiq'uijob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","U yälbijob ca'da: ―Si reyjet ane tuba aj judíosob, japän aba jiq'uin a juntuma. ");
INSERT INTO chfNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ajni täcä tu pam ni u cruz aj Jesús unq'ue jun tz'ibi tä griegojt'an, tä latin y tä hebreojt'an u yäle' ca'da: “Jinda ni Rey tuba aj judíosob”. ");
INSERT INTO chfNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Untu de ni winic que u tä' säti t'oc ni ley tuba ni cab jiniba, bajca ch'uyca tä cruz u täq'ui u bon cäräx älben aj Jesús. U yäli ca'da: ―Si aneba ni Cristojet que u yaquet Dios tuba a chen mandaba, japän aba jiq'uin a juntuma y japänon t'ocob täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ni otro untuba u q'uejpi u yälben ca'da: ―¿Ni ane mach a bäc'tan Dios? ¿Mach quira mu' a wute castiga cama' mu' u yute uneba? ");
INSERT INTO chfNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","No'onla utz chich ayan tz'ibajtescaconla ca'da uc'a mu' cä'binte cä toje'la jini cua' chichca cä chila mach utzba, pero ni winicda niump'e cua' mach u chi que mach utzba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","De ya'i jini winic u yälbi aj Jesús ca'da: ―C'ajti'inon ta' xe tä te a chen mandaba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","De ya'i aj Jesús u yälbi ca'da: ―Totojtoj cälbenet que daliba q'uin a xe tä ajtä nämte' t'oc no'on bajca ni u yälbinte u c'aba' tä paraísoba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Desde tänxin q'uin hasta las tres de la tarde yäli ump'e noj gran it'obni tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","U bäli uba u jut q'uin y tajqui u noq'ui ni noj ch'u'ul otot tuba aj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","De ya'i aj Jesús u chi noj gran t'an u yäle' ca'da: ―Cä Pap, cä'benet ta' c'äb cä pixan. Jimba rato que u yäli ni t'an jini, chämi. ");
INSERT INTO chfNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tu chänen ni ajnoja ta cien soldadoba cua'tac ajni u täq'ui u ch'u'ul c'ajti'ben u c'aba' Dios. U yäli ca'da: ―Totojtoj jinda winic mach ajni niump'e u tanä. ");
INSERT INTO chfNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Upete ni gente que c'otijob tä chanä, jinq'uin u chänijob cua'tac u chi pasa, sutwänijob tu pat u jätz'e' u pechojob uc'a ach'ocomi u pixanob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Upete machcatac u chen conoce aj Jesús, y che' chich täcä ni ixictac, jini machcatac ti tu patob desde tä Galileaba, nat wa'cajob u chänen cua'tac u yute. ");
INSERT INTO chfNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ajni untu winic u c'aba' aj José que u chen vivi tä Arimatea, ump'e caj tama ni noj cab tä Judea. Uneba untu a'äc'c'ajalinob tuba aj judíosob y es untu winic utz u c'ajalin y tu toja u chen. ");
INSERT INTO chfNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Une u pitän u chänen u manda Dios, y mach u tz'oni u chen täcä ca' chich u yäli u lotob u cherbenob aj Jesús. Une u yäli que mach utz cua' u chijob. ");
INSERT INTO chfNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Une bixi ca'an aj Pilato u c'atän si u yäc'ben u cuerpo c'äsi' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","De ya'i aj José u jäcsäbi u cuerpo tä cruz, u tz'oti t'oc ump'e noj welom noc' y u yäq'ui tama ump'e mucliba que ya' lowo tu näc' ump'e tz'ic de ji'tun. Tama ni mucliba jini mach to bay umujca niuntu. ");
INSERT INTO chfNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","U muquijob tuyac'o ni q'uin que u tuse' ubajob tuba u q'uini paxcu' päscab, y u chen tä c'ote u horäji u tä'can u q'uini ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ni ixictacob, jini machca tijob tu pat aj Jesús desde tä noj cab tä Galileaba, bixijob tu pat aj José u chänen ni mucliba, y cache' ch'a'atz'inti u cuerpo c'äsi' aj Jesús tama ni mucliba. ");
INSERT INTO chfNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","De ya'i ni ixictacob sutwänijob tu pat, y c'otijob u chenob jätz'äcnib y cua' chichca u tz'aca tuba u tatz'benob t'oc u cuerpo untu ajchäme. De ya'i u ch'i ubajob tu q'uini ni ch'ämbäji ca' chich u yäle' utic ni ley taj Moisés. ");
INSERT INTO chfNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ni najtäcäl q'uin ta semana mäx ic'sapanto c'otijob t'oc otros ixictacob täcä bajca an ni mucliba. U bisijob jini jätz'äcnib que u chijobba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","C'oti u chänenob cache' aquitz'qui ni noj ji'tun tu ti' mucliba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ochijob y mach u pojlijob u cuerpo ni Cajnojala aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mu'to u bäc'täl ch'e' u c'ajalinob cua' ajni jinq'uin c'oti tä wa'tä tu ch'ejpajob cha'tu ángelojob, ca' a wälä winic, t'oc u säsäc buc c'äntz'alanba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","C'ac'a' bäc'tijob ni ixictacob y u chinjatz'i u pam u chänen tä cab. De ya'i ni ángelojob u yälbijob ca'da: ―¿Cua' uc'a a sacänla tan ajchämejob ni machca cuxu anba? ");
INSERT INTO chfNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mach ni' an wida; acuxpi une. C'ajti'inla cua'tac u yälbetla jinq'uin ya'to an tama ni noj cab tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","U yäli cache' une que sutwäni de winicba c'änä äc'cac tu c'äbob ajcherajtanäjob, tzämsintic tä cruz y de ya'i u xe tä cuxpan u yuxp'elib q'uin. Ca' jini u yäli. ");
INSERT INTO chfNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","De ya'i ni ixictacob u c'ajti'ijob ni t'anob jini que u yäli aj Jesúsba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","De ya'i pasijob ya'i bajca an ni mucliba y bixijob u tz'aycäbenob ni once ajcänt'anob upete ni jini que a'utiba. U yälbijob täcä upete ni otrosjob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ix María, u cab tä Magdalaba, ix Juana, ix María, u na' aj Jacoboba y otros ixictacob nämte' t'oc unejob, jimba ixictacobda unejob machcatac u tz'aycäbijob ni u yajc'äncanob aj Jesús cua'tac u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","U yajc'äncanob aj Jesús u yäli tan u c'ajalinob cache' päpä' t'an u chenob jini ixictacob jini y mach u tz'ombijob cua' u yäle'ob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lo que u chi aj Pedroba, ch'oyi bixi t'oc ancäre bajca an ni mucliba. Jinq'uin u jup'i u pam u chänen tama, niump'e cua' mach u chäni sec' jini säsäc welom noc'. Sutwäni tu yotot u bäc'täl ch'e' u c'ajalin uc'a cua' ti jini ajni. ");
INSERT INTO chfNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jinchichba q'uin jini cha'tu u yajcänt'anob aj Jesús bixe u chenob bajca an ump'e p'i' caj u c'aba' tä Emaús. U nät'an ni caj jini t'oc tä Jerusalén ca' ta chap'e hora de xämba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tä bij u bixe tä tz'ajijob u tz'aycunob cua'tac alaj uti. ");
INSERT INTO chfNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jinq'uin tz'aji to u chenob y u maläc ch'e' u c'ajalinob cua' ajni, aj Jesús chich u natz'ijob u bixe nämte' t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Unejobba ca' a wälä bälbinti u jutob uc'a mach u chen conocejob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aj Jesús u c'atbijob ca'da: ―¿Cua' tz'aji na bixe a chenla por to'o bij? ¿Cua' uc'a triste anetla? ");
INSERT INTO chfNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Untu de unejob, jini u c'aba' aj Cleofasba, u p'albi ca'da: ―¿De upete ajpäpä'cabob que ayan tä Jerusalén, sec' ane quira colet que mach a wi cua'tac u chi pasa ya'i jimba q'uinobda? ");
INSERT INTO chfNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","De ya'i aj Jesús u yälbijob ca'da: ―¿Cua' une u chi pasa? Unejob u yälbijob ca'da: ―Ajni untu winic u c'aba' aj Jesús, u cab tä Nazaret. Uneba untu ajt'an ta Dios. Dios y upete ni gente u chänijob cache' q'uen u poder tuba u chen cua' chichca, y cua' chichca u yäle'ba t'oc poder chich täcä. ");
INSERT INTO chfNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","De ya'i ajnojajob ta pale täc'ala y ajt'äbälajob täc'ala u yäq'uijob tä tzämsinte y u tzämsijob chich tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","No'on t'ocobba cäli t'ocob cache' une u xe u japän aj Israelob tu c'äb machcatac mach yo u chänenobba. Badaba, sami atz'äcti uxp'e q'uin que u yute upete ni jinda cäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Che' chich täcä yebe de cä lot t'ocob ixictacobba u c'äsbäc'teson t'ocob. Bixijob sami tu junch'äcnan bajca an u mucliba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mach u pojläbijob u cuerpo c'äsi' aj Jesús. Jin uc'a sutwänijob ca'anon t'ocob u yäle'ob cache' u chänijob ángelojob que u ye'i ubajob tu pänte'job u yälbenob cache' cuxu ayan. ");
INSERT INTO chfNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tulaj bixi cä lot t'ocob bajca an ni mucliba. U pojlijob chich que toj ca' chich u yäli ni ixictacob jini, pero aj Jesúsba mach u chänijob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","De ya'i aj Jesús u yälbijob ca'da: ―Tzätz a pamla. Mach u se'en och tan a c'ajalinla tuba a tz'onänla upete cua'tac u yälijob ajt'anob ta Dios oni. ");
INSERT INTO chfNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mach quira c'änäli tz'ibajtescac ca' jini ni machca u yaqui Dios tuba u chen mandaba, y ji'pat u ch'e' jini poder que u xe u cänäntanba? ");
INSERT INTO chfNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","De ya'i u laj chectesbijob cua'tac tz'ibinti tan u jun Dios, jini u yäle' cache'da u xe u chen pasa uneba. Najtäcä u täq'ui u yälbenob cua' u tz'ibi aj Moisés, y de ya'i u chi segui u yälbenob cua' u tz'ibi upete ajt'anob ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","De ya'i c'ote u chenob ca'an ni caj bajca u xejobba, y aj Jesús u chi uba cache' ya' u xe más pänte'. ");
INSERT INTO chfNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Unejob u cocoj älbijob ca'da: ―Colen t'oc no'on t'ocob uc'a mäx a'ochiq'uin y u chen tä pome q'uin. De ya'i ochi tan otot y coli t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ji'pat chunwäni aj Jesús nämte' t'oc unejob tä c'uxnan. U ch'i ni waj u c'atben Dios que u ch'u'ul cherben ni waj jini. De ya'i u taji ni waj y u pucbijob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jimba rato jiniba u chi conocejob que es aj Jesús. Es ca' a wälä u jäbi uba u jutob uc'a u chänen. Seb ch'äbsäti tu jutob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Unejob u maläc älijob ca'da: ―¿Mach quira yäli ump'e sisicne täc pixanla jinq'uin u lotonla täc tela t'oc tä bij nämte', jinq'uin u chectesbonla cua' u yäle' ni jun ta Dios? ");
INSERT INTO chfNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jinchichba hora ch'oyijob y sutwänijob tä Jerusalén. U pojlijob cache' woyo ayanob ni once ajc'äncanob taj Jesucristo y machcatac ayan t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Upetejob u yäle'ob ca'da: ―Totojtoj chich cache' acuxpi Cajnojala y u ye'i uba bajca an aj Simón. ");
INSERT INTO chfNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","De ya'i ni cha'tujobba u tz'ayquijob cua' u chi pasajob tä bij y cache' u chi conocejob aj Jesús jinq'uin u taji ni waj. ");
INSERT INTO chfNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jinq'uin mu'to u maläc tz'aycunob jini cua'tac ajni, tajtzäc wa'yäli aj Jesús tänxin de unejob. U yälbijob ca'da: ―Tanetla, ajnic a wutzila. ");
INSERT INTO chfNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Unejob sispomi u cuerpojob uc'a c'ac'a' bäc'tijob. Ti tu c'ajalinob cache' mu' u chänenob untu päpä' pixan. ");
INSERT INTO chfNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aj Jesús u yälbijob ca'da: ―¿Cua' uc'a bäc'tetla? ¿Cua' uc'a a sinlaj chen pensala cua' chichca jini? ");
INSERT INTO chfNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chänenla cä c'äb y coc cache' no'on chich. Täle'onla y chänenla, uc'a untu päpä' pixan mach u cänänta u bec'ta ni u bäque ca' chich a chänenla cä cänäntan no'onba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jinda u yäli y de ya'i u ye'bijob u c'äb y yoc bajca bajli. ");
INSERT INTO chfNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tä' ch'a'a ujinob y tajch'icwäni u jutob, pero mach u se'en tz'onijob si es aj Jesús chich, uc'a u yälijob bay mach toj. De ya'i aj Jesús u c'atbijob ca'da: ―¿A cänäntanla quira cua' tä c'uxcan wida? ");
INSERT INTO chfNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","De ya'i unejob u yäc'bijob unxot' ch'atä' buch' y ump'e u p'ul te'el chab. ");
INSERT INTO chfNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aj Jesús u ch'i u c'uxe' tu jutob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","De ya'i u yälbijob ca'da: ―Jinq'uin ya'to anon nämte' t'oc anela cälbetla ni t'anda: C'änä pasic toj upete jini ayan tz'ibi tan u jun Dios que u yäle' cache'da cä xe cä chen pasa no'on, jini u tz'ibi aj Moisés y ajt'anob ta Diosba, y ca' chich u yäle' täcä ni jun u c'aba' Salmoba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","De ya'i u jäbtesbi u c'ajalinob uc'a u chen entendejob ni u t'an Dios que tz'ibi ayanba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","U yälbijob ca'da: ―Ca' jini ayan tz'ibi que c'änä chich bon tz'ibajtescac jini u yaqui Dios tuba ajmandaba y cuxpac tan ajchämejob u yuxp'elib q'uin. ");
INSERT INTO chfNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tz'ibi ayan chich täcä cache' c'änä tz'ayquintic u c'aba' aj Jesucristo uc'a u q'uexe' u c'ajalin untu tuba mach u ni' chen u tanä, y cache' u cherbinte perdona u tanä machca u tz'onän. U xe tä tä'can u tz'ayquinte tä Jerusalén y de ya'i u xe tä tz'ayquinte upete cabil cab tu pancab. ");
INSERT INTO chfNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Upete ni jindaba a totoj chänila chich t'oc a jutla. ");
INSERT INTO chfNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ubixtola, no'on chich cä xe cä täscäbenetla jini machca u yäli cä Pap que u xe u täscäbenetlaba. Colenla jiq'uin tama ni noj caj tä Jerusalén ixta que mach a mätan ta'wac'ola ni poder que u te tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","De ya'i pasijob tä Jerusalén y aj Jesús u bisijob ixta tu bijle tä Betania. De ya'i u t'äbsi u c'äb u ch'u'ul chenob. ");
INSERT INTO chfNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jinq'uin mu'to u ch'u'ul chenobba u täq'ui t'äbo isqui y che' chich bisinti tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Unejob u ch'u'ul c'ajti'ijob y ji'pat sutwänijob tä Jerusalén t'oc noj gran ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","U paq'uin woyli ubajob tama ni noj ch'u'ul otot tuba aj judíosob u c'äybenob u c'aba' Dios y u yälbenob que uc'adios u chi por unejob. Ya' tzäcä ni junda.");
INSERT INTO chfNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Chäcäl najtäcä ajni untu que u yälbinte cache' ni T'an, que u yäle' cache'da an Dios. Ni T'an jini ajni t'oc Dios, ni T'an Dios chich täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jinda T'an ajni chäcäl najtäcä t'oc Dios jinq'uin mach to an u pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Une nämte' t'oc Dios u chi upete cua' chichca que ayanba. Jini que utiba, si fuera mach por une, machica uti niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Une chich u yäq'ue' cuxleconla. Jini u yäq'ue' cuxleconlaba, une chich ni junch'äcni tuba cäpetela. ");
INSERT INTO chfNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tan it'obni tutz'i ni junch'äcni jini. It'obni mach u täpi u jut ni junch'äcni. ");
INSERT INTO chfNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios u täsqui untu winic u c'aba' aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aj Juanba c'oti u yäle' camba u toja, u yäq'ue' tä ute conoce caxca une ni junch'äcni, uc'a ca' jini u tz'onänob upete uc'a ni t'an que u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aj Juanba mach une ni junch'äcni; uneba c'oti tuba u yäle' caxcamba ni junch'äcni. ");
INSERT INTO chfNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jini totoj junch'äcni c'oti pancabba, jin une ni u chictan upetejob. ");
INSERT INTO chfNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ajni pancab, une u chi u pancab, pero machcatac cuxujob pancab mach yuwijob caxca une. ");
INSERT INTO chfNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","C'oti tu cab, pero u yajcäbnajob mach u sapijob. ");
INSERT INTO chfNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Upete machcatac u sapi, u yäc'bijob sutwänic de u ch'ocob Dios, machcatac u tz'ombi u c'aba'. ");
INSERT INTO chfNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jindajob u sujtäjob de u ch'ocob Dios uc'a u cha'num päncäban, mach ca' u päncäban untu ch'oc pancab, mach uc'a yoli u pap y u na', mach uc'a yoli winic, sec' uc'a Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jini T'an sutwäni de winic, tä' utz u c'ajalin y tä' toj u t'an. Cuxli t'oc no'onla. Cä chänila u pitzilan. Cä Papla Dios u yäc'bi u pitzilan u juntul Ajlo'. ");
INSERT INTO chfNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aj Juan u yäq'ui tä ute conoce, t'oc noj t'an u yäli ca'da: ―Jinda ni cäliba: “Machca ni u te ji'pat que no'on más ajnoja que no'on, uc'a une más najtäcä que no'on”. ");
INSERT INTO chfNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cäpete cä mätanla cua' chichca que an tu c'äb une, jini mach uxupba. Tä' re'i utz u c'ajalin t'oc no'onla. ");
INSERT INTO chfNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Uc'a ni leyba aj Moisés u yäc'bonla. Aj Jesucristo u ye'bonla ni mero u tojaba. Uneba tä' utz u c'ajalin t'oc no'onla. ");
INSERT INTO chfNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Niuntu mach bay u chäni Dios. U juntul Ajlo', jini tä' yo u Papba, une u yälbonla cache'da an Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tu toja u yäli aj Juan jinq'uin aj judíosob u täsqui aj Jerusalénob ni palejobba y aj levitasob tuba u c'atbenob: ―¿Caxcajet ane? ");
INSERT INTO chfNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","U p'ali, mach u muquí. U yäli tu toja: ―Mach no'on ni aj Cristojon que u xe u täscun Diosba. ");
INSERT INTO chfNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","De ya'i u c'atbijob tä cha'num: ―¿Caxcajet jiq'uin? ¿Ane quira aj Elíaset? U yäli: ―Mach jinon. ―¿Ane quira ni ajt'anet ta Dios jini que u xe tä teba? U p'ali: ―Mach jinon täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","U c'atbijob tä cha'num: ―Älbenon t'ocob caxcajet jiq'uin uc'a cälben t'ocob machca u täscon t'ocob. ¿Cache'da a wäle' ane, caxcajet? ");
INSERT INTO chfNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Une u yäli: ―No'on ni ajt'anon que cä chen noj t'an bajca mach cuxu niuntu. Ca' chich u yäli aj Isaías, ajt'an ta Diosba, no'on täcä cälbenetla ca'da: “To'esbenla u biji Ajnoja”. ");
INSERT INTO chfNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jini machcatac c'oti bajca an aj Juanba, aj fariseojob u täsqui une. ");
INSERT INTO chfNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","De ya'i u c'atbijob ca'da: ―¿Can uc'a jiq'uin a chen c'ablesia si mach jin aj Cristojet, si mach jin aj Elíaset, si mach jin ni ajt'anet ta Dios? ");
INSERT INTO chfNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aj Juan u yälbijob: ―No'on cä chen c'ablesia t'oc ja'. Tänxin de anela ya'an untu que mach a che conocela. ");
INSERT INTO chfNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jinda ni u te ji'pat que no'on, jini más ajnoja que no'onba, ixta no'onba mach jin niump'e cua'on tuba cä p'ämben u täbi u pächi'oc. ");
INSERT INTO chfNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Upete ni jinda ya' uti tä Betábara tunxe río Jordán bajca u chi c'ablesia aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Päscab aj Juan u chäni cache' ya' u te aj Jesús bajca an une, u yäli ca'da: ―Chänen ni winic u täsqui Dios tuba u pa'säbenob u tanä a'ajtäjob pancab. Une chich ca' a wälä ni ch'oc oveja que u tzämsinte tuba subbintic Diosba. ");
INSERT INTO chfNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jinda ni cäliba: “U te ji'pat que no'on untu winic más ajnoja que no'on, uc'a une más najtäcä que no'on”. ");
INSERT INTO chfNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","No'on mach cä chi conoce. No'on aton cä chen c'ablesia t'oc ja', uc'a ca' jini cä ye'benob aj Israel ni winicda. ");
INSERT INTO chfNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aj Juan u yäli tu toja jinq'uin u yäli ca'da: ―Cä chäni ni Ch'u'ul Pixan cache' ya' ti tä cielo y jaqui ca' untu ixsäcpäcä. C'oti tä wa'tä tan u pam aj Jesús y ya' chich coli. ");
INSERT INTO chfNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","No'onba mach cä chi conoce. Machca u täscon cä chen c'ablesia t'oc ja', une u yälbon ca'da: “Jini a chänen u jaque Ch'u'ul Pixan tuyac'o y u colan tuyac'oba, une ni u chen c'ablesia t'oc Ch'u'ul Pixan”. ");
INSERT INTO chfNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","No'on cä chäni, jin uc'a cä totoj äli cache' jinda u Yajlo' chich Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Päscab tä cha'num ya'an aj Juan t'oc cha'tu u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aj Juan u chäni cache' nume u chen aj Jesús ya'i, u yäli ca'da: ―Chänen ni winic ni ca' a wälä Ch'oc Oveja ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ni cha'tu ajcänt'anob jiniba, jinq'uin u yubi cache' u yäli aj Juan, bixijob tu pat aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","U suti uba aj Jesús u chänen cache' ya' u tejob tu pat, u yälbijob ca'da: ―¿Cua' a sacänla? Unejob u p'albi: ―Maestro, ¿cada cuxulet? ");
INSERT INTO chfNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Une u yälbijob: ―La'ixla, chänenla. Bixijob chich u chänen bajca cuxu. Colijob nämte' t'oc une jimba q'uin jini, uc'a ochiq'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Untu ni machca u yubi cua' u yäli aj Juan y bixi tu pat aj Jesúsba aj Andrés une, u jitz'in aj Simón Pedro. ");
INSERT INTO chfNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aj Andrés une ni bixi u sacän najtäcä aj Simón u säcun chichba, u yälbi ca'da: ―Acä pojli t'ocob ni Mesías ―ni t'andaba u yäle' ca'da: Aj Cristo une, ni u täsqui Diosba. ");
INSERT INTO chfNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","De ya'i u bisi bajca an aj Jesús. Jinq'uin aj Jesús u chäni, u yälbi ca'da: ―Aneba aj Simónet u yajlo'et aj Jonás. Ane u xe a c'aba' aj Cefas ―ni c'aba'daba aj Pedro une tä griegojt'an. ");
INSERT INTO chfNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Päscab ti tu c'ajalin aj Jesús xic tä Galilea. U nuc'ti aj Felipe, u yälbi ca'da: ―Tzäypätinon. ");
INSERT INTO chfNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aj Felipeba tä Betsaida u cab, ya' chich u cäji aj Andrés y aj Pedro täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aj Felipe u nuc'ti aj Natanael u yälbi ca'da: ―Acä chäni t'ocob ni winic u worin äli aj Moisés tan ni jun u tz'ibiba cache' u xe tä te, jini u yäli täcä ajt'anob ta Dios. Uneba aj Jesús u yajlo' aj José tä Nazaret. ");
INSERT INTO chfNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aj Natanael u yäli: ―¿U xe wäreca tä pase ajt'an ta Dios tä Nazaret? Aj Felipe u yäli: ―La'ix uc'a a chänen. ");
INSERT INTO chfNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jinq'uin aj Jesús u chäni cache' ya' u te aj Natanael bajca an, u yäli ca'da: ―Chänen ya' u te untu totoj aj Israel, uneba mach u che jop'ojti'. ");
INSERT INTO chfNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aj Natanaelba u yäli ca'da: ―¿Cada a chon conoce? Aj Jesús u p'ali: ―Machto u pequet aj Felipe, jinq'uin ya'to anet yaba te' higo, cä chänet. ");
INSERT INTO chfNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aj Natanael u yäli: ―Maestro, ane chich u Yajlo'et Dios, aneba u Yajnojalet aj Israelob. ");
INSERT INTO chfNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aj Jesús u yälbi: ―¿Uc'a quira cälbet cache' cä chänet yaba te' higo a tz'onän? Ya'to a xe a chänen q'uen cua' chichca más pitzi que jinda. ");
INSERT INTO chfNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aj Jesús u yälbi täcä ca'da: ―Totojtoj cälbenetla, cache' ya'to a xe a chänenla jäbä ni cielo y cache' ajc'äncanob ta Dios u t'äbo y u jaque bajca anon no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tu yuxp'elib q'uin ji'pat ajni ump'e lotojan tan caj tä Caná ya'i chich tä Galilea. Ya' ajni täcä u na' aj Jesús ya'i. ");
INSERT INTO chfNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jo'qui täcä aj Jesús bajca an ni lotojan, con to'o u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jinq'uin xupi u pa' vinojob, u na' aj Jesús u yälbi ca'da: ―Axupi u pa' vinojob. ");
INSERT INTO chfNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aj Jesús u yälbi: ―Cä na', ¿cua' uc'a a wälbenon no'on? Mach to c'ot q'uin cä ye'e' cä poder. ");
INSERT INTO chfNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero u na' u yälbi machcatac ya'an tä pucob: ―Chenla upete ca' chich u xe u yälbenetla. ");
INSERT INTO chfNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ajni ya'i seis nuc but'i' ja' de ji'tun t'oc jini ja' que u c'äne'ob aj judíosob tuba ajnic limpio, ca' chich nämä u chenobba. Cada jump'e u tawän chap'e uxp'e nuc p'u de ja'. ");
INSERT INTO chfNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aj Jesús u yälbijob: ―Tulesanla ni but'i' ja' t'oc ja'. De ya'i u chäctulesijob ixta tu ti'. ");
INSERT INTO chfNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","De ya'i aj Jesús u yälbijob: ―Lupänla bada, y äc'benla u noja ajpuc vino. Ca' jini chich u chijob. ");
INSERT INTO chfNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jinq'uin u noja ajpuc vino u cha'uch'i ni ja' que sutwäni de vinoba, une mach yuwi cache'da uti. Jini ajpucob u but'i ja'ba yuwijob cache'da uti. De ya'i u noja ajpuc vino u joq'ui ajlotojan, ");
INSERT INTO chfNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","u yälbi ca'da: ―Upete winic najtäcä u yäc'ben ajlotayajob jini vino utzba, y cuanta u bon uch'ijobba, u yäq'ue' ni mach yoco utzba. Aneba mach che' a chi. Aneba a ch'ujni ni vino utzba tuba uch'cac ji'pat. ");
INSERT INTO chfNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jinda que u chi aj Jesús tan caj tä Caná ya'i chich tä Galileaba, jin une ni najtäcäl patan que u chi tuba u ye'e' u poder, y tuba u ye'e' u pitzilan u patan. U yajcänt'anob u tz'ombijob une. ");
INSERT INTO chfNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ji'pat bixi tä Capernaum. Bixi nämte' t'oc une u na', u jitz'inob y u yajcänt'anob. Mach tä' jäläcnijob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jinq'uin natz'äli paxcu' taj judíosob, aj Jesús bixi tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tama noj ch'u'ul otot u chäni ajchon beq'uetob, ajchon ovejajob, ajchon ixsäcpäcäjob y ajq'uex taq'uinob ya' chumujtacob. ");
INSERT INTO chfNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aj Jesús u chi untz'it jätz'onib de ch'ajan. De ya'i u laj pa'sijob upete tama noj ch'u'ul otot, con to'o oveja, con to'o beq'uet, y u laj t'it'bi u taq'uin ajq'uex taq'uinob u t'elejulbi u mesajob. ");
INSERT INTO chfNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","U yälbi ajchon ixsäcpäcäjob ca'da: ―Pa'senla jinda wida. Mach a chen ca'da u yotot cä Pap ca' otot tuba chono. ");
INSERT INTO chfNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ti tu c'ajalin u yajcänt'anob cache' tz'ibi chich ayan tama u jun Dios ni u yäle' ca'daba: “Tä' re'i coba cä cänäntäbenet a wotot”. ");
INSERT INTO chfNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aj judíosob u yälbijob ca'da: ―¿Cua' jini a xe a chen tuba cä chänen t'ocob si ä'bintet chich a chen ca' jini? ");
INSERT INTO chfNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aj Jesús u yälbijob ca'da: ―Jinesanla ni noj ch'u'ul ototda, y uxp'e q'uin acä tz'osen tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aj judíosob u yäli: ―Cuarenta y seis año jäläcni ta utic jinda noj ch'u'ul otot, ¿y ane a wäle' que uxp'e q'uin a xe a tz'osen? ");
INSERT INTO chfNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jinq'uin u yäli ca'da, mach jin de ni ch'u'ul otot mu' u yäle'. De une chich ni mu' u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jinq'uin aj Jesús cuxpi tan ajchämeba, u yajcänt'an u c'ajti'ijob jini t'an u yäliba. U tz'onijob ni t'an ta Dios tz'ibiba, y ni t'an u yäli aj Jesúsba. ");
INSERT INTO chfNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jinq'uin ya'an tä Jerusalén tan ni q'uin ch'uje tuba paxcu', q'uen u tz'ombijob uc'a u chänijob cua'tac u chi tuba u ye'e' u poder. ");
INSERT INTO chfNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aj Jesús mach u sapi cache' u totoj tz'onänjob, uc'a yuwi chich cache'da an u pixan upetejob. ");
INSERT INTO chfNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mach c'änä uc'a machca u yälben cache'da an u pixan winic, uc'a une chich yuwi cache'da an. ");
INSERT INTO chfNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ajni untu aj fariseo, u c'aba' aj Nicodemo, uneba ajnoja taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ni winicdaba c'oti bajca an aj Jesús ac'äb, u yälbi ca'da: ―Maestro, cuwi t'ocob cache' ane atet bajca an Dios tuba a ye'benon t'ocob u t'an, uc'a niuntu mach u ch'ä u chen ca' a chen aneba t'oc poder si Dios mach'an t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aj Jesús u yälbi ca'da: ―Totojtoj cälbenet, machca mach u cha'num päncäba, mach u ch'ä u chänen bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aj Nicodemo u c'atbi: ―¿Cache'da u ch'e' päncäbac noxib cha'num? ¿U ch'e' quira ochic cha'num tuyac'o u na' uc'a päncäbac? ");
INSERT INTO chfNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aj Jesús u p'ali: ―Totojtoj cälbenet, machca mach uc'abla t'oc ja' y mach u mäta ni Ch'u'ul Pixan tuyac'o, ca' a wälä u c'ablan t'ocba, mach u ch'ä ochic bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jini u päncäban uc'a winic, winic chich; jini u päncäban uc'a u poder ni Ch'u'ul Pixan, pixan chich. ");
INSERT INTO chfNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mach ch'icwänic a jut uc'a cälbet cache' c'änä cha'num päncäbaquet. ");
INSERT INTO chfNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ic' u yustan cachichcada. Ane a ubin, pero mach a wi cada u te, y mach a wi cada u xe. Che' chich täcä machca u päncäban uc'a u poder Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aj Nicodemo sujli u c'atben aj Jesús: ―¿Cache'da u ch'e' utic jinda? ");
INSERT INTO chfNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aj Jesús u yälbi: ―¿Ane maestrojet taj Israel y mach a wi jinda? ");
INSERT INTO chfNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Totojtoj cälbenet, ni cuwi t'ocobba acäle', ni cä chäni t'ocobba acä tz'aycun, y anelaba mach a sapäla ni cä t'an t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Si cälbet cua' chichca tuba u pancab y mach a tz'onä, ¿cache'da a xe a tz'onän si cälbenet cua' chichca que ayan tä cielo? ");
INSERT INTO chfNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Niuntu mach bay t'äbi tä cielo, sec' jini que ya' pasi tä cielo y jaquiba, no'on une que sutwänon de winic. Ya' chich cä cäji tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ca' chich aj Moisés u t'äbsi chan bajca mach cuxu niuntu, che' chich c'änä t'äbsinticon tä cruz no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Cä xe tä t'äbsinte tä cruz uc'a upete machca u tz'ombenonba mach sätic, unejob paq'uin cuxlecob. ");
INSERT INTO chfNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Dios tä' u yajna'tan upetejob pancab, jin uc'a u yäq'ui u juntul Ajlo' uc'a upete machcatac u tz'omben uneba mach sätic, unejob paq'uin cuxlecob. ");
INSERT INTO chfNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Uc'a Dios mach u täsqui u Yajlo' pancab tuba u yäc'benob u toje' u tanä a'ajtäjob pancab, u täsqui tuba u japän a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Machca u tz'omben uneba, mach u yäc'binti u toje' u tanä. Machca mach u tz'ombeba, u yäc'binte u toje' u tanä, uc'a mach u tz'ombi u c'aba' u juntul Ajlo' Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","U yäc'binte u toje' u tanäjob, uc'a c'oti pancab aj Jesucristo, ni junch'äcni ta Diosba, pero a'ajtäjob pancab más u yajna'tijob it'obni que ni junch'äcni, uc'a ni cua' u chenobba mach utz. ");
INSERT INTO chfNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Uc'a upete machca u chen cua' chichca mach utz, mach yo u chänen ni junch'äcni, y mach utajob bajca an junch'äcni täcä tuba mach q'uejpinticob uc'a ni u chenob mach utzba. ");
INSERT INTO chfNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Machca u chen tu toja u te bajca an junch'äcni uc'a chänintic cache' upete jini u chenba, Dios chich u täclen u chen. ");
INSERT INTO chfNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ji'pat aj Jesús c'oti t'oc u yajcänt'anob tama cab tä Judea; colijob t'oc ya'i u chen c'ablesia. ");
INSERT INTO chfNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aj Juan täcä ya'an u chen c'ablesia tä Enón nätz'ä t'oc tä Salim uc'a ya'i an q'uen ja'. Q'uen gente c'otijob ya'i tä c'ablescan. ");
INSERT INTO chfNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aj Juanba mach to u yä'ca tä cárcel jimba q'uinob jini. ");
INSERT INTO chfNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","U yajcänt'anob aj Juan ajni tä t'an t'oc aj judíosob uc'a jini aj judíosob u yoli u yubin si jini c'ablan taj Juan más u yäq'ue' untu tu toja. ");
INSERT INTO chfNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jini u yajcänt'an aj Juan c'otijob ca'an aj Juan u yälbenob: ―Maestro, jini ajni t'oc ane tunxe Jordánba, ni a wäq'ui tä ute conoceba, ya'an u chen c'ablesia, y upete u c'ote bajca an. ");
INSERT INTO chfNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aj Juan u yäli: ―Niuntu mach u ch'ä u chen niump'e cua' si Dios mach u yäc'ben u chen. ");
INSERT INTO chfNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Anela a wila cache' cäli: No'on mach jinon ni aj Cristojon. No'on täsquinton najtäcä. ");
INSERT INTO chfNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ixlotojan jit'oc chich ajlotojan. Ajlotaya tajlotojan tä' ch'a'a ujin jinq'uin u yubin u t'an jini ajlotojan. Che' chich täcä no'on bada tä' ch'a'a cäjin uc'a juli aj Cristo y upete u yubinob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Une c'änä xic más ajnoja, y no'onba c'änä ajnicon más ajch'och'ocalon. ");
INSERT INTO chfNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jini u te tä cieloba, ajnoja une tuba upete. No'onla que päncäbonla pancab, tuba chich u pancabonla, y sec' jini ayan pancab, jin chich cä tz'aycunla, pero jini u te tä cieloba, ajnoja chich tuba upete. ");
INSERT INTO chfNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Cua'tac u chäni, y cua'tac u yubi tä cielo, jin chich u tz'aycun, pero niuntu mach u tz'ombe u t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Machca chichca que u tz'omben u t'an, u ye'e' cache' jini t'an que u tz'ayquiba, u t'an chich Dios une, y cache' toj chich. ");
INSERT INTO chfNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Machca Dios u täsqui, u t'an chich Dios u yäle'. Diosba mach u yäc'ä p'isi ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cä Papla Dios u yajna'tan u Yajlo', y u yäc'bi upete cua' chichca tu c'äb. ");
INSERT INTO chfNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Machcatac u tz'omben u Yajlo' Dios, paq'uin cuxu ayan; machcatac mach u tz'ombe u Yajlo' Diosba mach uxin tä äc'binte paq'uin cuxlec, uc'a Dios chich u xe u yäc'ben u noj toji'tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aj fariseojobba u yubijob cache' aj Jesús u yosi más ajcänt'an que aj Juan, y cache' u chi más c'ablesia que aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aj Jesúsba mach u chi c'ablesia, u yajcänt'anob une ni u chi c'ablesiaba. ");
INSERT INTO chfNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jinq'uin aj Jesús u yubi ca' jini, pasi tä Judea, bixi cha'num tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","C'änäli numic tä Samaria. ");
INSERT INTO chfNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","C'oti tama ni cab tä Samaria, tama ump'e yoc caj u c'aba' Sicar, nätz'ä t'oc u cab aj Jacob, jini u yäc'bi u yajlo' aj José oniba. ");
INSERT INTO chfNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ya'an ya'i ni ch'en que u chi aj Jacob. C'oti aj Jesús ya' jini tänxin q'uin, y chunwäni ti' ch'en, uc'a bo'o ujin t'oc xämba. ");
INSERT INTO chfNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","C'oti untu ix Samaria u lupän ja'. Aj Jesús u yälbi: ―Benon cuch'en tz'ita' ja'. ");
INSERT INTO chfNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","U yajcänt'anobba san bixijob tan caj u mäne' cua' tä c'uxcan. ");
INSERT INTO chfNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jini ixic u yälbi aj Jesús ca'da: ―Aneba aj judíoset, ¿cua' ti uc'a a c'atbenon ja'? Uc'a no'on ix Samariajon. U yäli ca' jini uc'a aj judíosobba mach u bisa bijob t'oc aj Samariajob. ");
INSERT INTO chfNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aj Jesús u yälbi: ―Si a wina'tan ica cua' une ni matän u yäq'ue' Diosba, y si a chen conoce ica ni machca u yälbenet: “Benon cuch'en tz'ita' ja'ba”, ane u ch'e' a c'atben ja' tuba paq'uin cuxlequet, y une u yäc'benet chich. ");
INSERT INTO chfNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jini ixic u yälben: ―Noxi' winic, tam ni ch'en, y mach'an cua' t'oc a lupän. ¿Cada an ac'a jiq'uin jini ja' ta paq'uin cuxleconba? ");
INSERT INTO chfNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ane quira más ajnojalet que cä najtäcäl noxi'papla aj Jacob, ni u yäc'bon t'ocob ni ch'endaba? Jinchichba ja'da u yuch'i une, u ch'ocob, y u yäläq'ui. ");
INSERT INTO chfNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aj Jesús u yälbi: ―Machca chichca u yuch'en ni ja' jini, u sujtä tä tiquin u ti'. ");
INSERT INTO chfNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Machca u yuch'en ni ja' acä'ben no'onba, mach uni' sutwan tä tiquin u ti'. Ni ja' acä'ben no'on, u xe tä ajtä tuyac'o ca' ump'e ch'en que mach uxup u jä'le, u te tä ancäre tuba u paq'uin äc'ben cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ni ixic u yälben: ―Noxi' winic, äc'benon ni ja' jini, tuba mach ni' tiquic cä ti', y tuba mach ni' ticon wida cä ch'e' ja' täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aj Jesús u yälbi: ―Cux joc'o a wit'oc, y la'ix t'oc wida. ");
INSERT INTO chfNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ni ixic u p'ali ca'da: ―Mach'an quit'oc. Aj Jesús u yälbi: ―Tu toja chich a wäli cache' mach'an a wit'oc. ");
INSERT INTO chfNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Uc'a cinco a wit'oc ajnet t'oc, y jini ya'an badaba mach jin a wit'oc. Toj chich lo que a wäli. ");
INSERT INTO chfNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jini ixic u yälbi: ―Noxi' winic, acäle' cache' aneba ajt'anet ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Cä najtäcäl noxi'pap t'ocob u ch'u'ul c'ajti'ijob Dios pan jini tz'ic. Anelaba a wäle'la cache' tä Jerusalén c'änä ch'u'ul c'ajti'cac. ");
INSERT INTO chfNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aj Jesús u yälbi: ―Ixic, tz'ombenon jini cä xe cälbenetba. U xe tä c'ote q'uin jinq'uin mach uxet a ch'u'ul c'ajti'inla cä Papla Dios tu pam jini tz'ic; y mach uxet a ch'u'ul c'ajti'inla tä Jerusalén täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Anelaba mach a wila cua' a ch'u'ul c'ajti'inla. No'on t'ocobba cuwi chich t'ocob cua' cä ch'u'ul c'ajti'in t'ocob, uc'a ni Ajjäpomba u xe tä te tan ni aj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","U xe tä c'ote q'uin, y bada ac'oti chich ni q'uin jini que u xe tä c'oteba, jinq'uin machcatac u totoj ch'u'ul c'ajti'in cä Papla Dios u xe u totoj ch'u'ul c'ajti'in t'oc u pixan y tu tojaba, uc'a ni cä Papla Dios jin chich u sacän machcatac u ch'u'ul c'ajti'in ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosba es pixan une. Machcatac u ch'u'ul c'ajti'in, c'änä u ch'u'ul c'ajti'in t'oc u pixan y tu toja. ");
INSERT INTO chfNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ni ixic u yälben ca'da: ―Cuwi chich cache' u xe tä te ni Mesías, jini u yälbinte aj Cristoba. Tu te uneba, u xe u yälbenonla upete cua' yo Dios utic. ");
INSERT INTO chfNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aj Jesús u yälbi: ―No'on chich ni aj Cristojon, mu' cä chen t'an t'oc ane. ");
INSERT INTO chfNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mu'to u yäle' ca' jini jinq'uin c'oti u yajcänt'anob. Ch'icwäni u jutob u chänen cache' ya'an tä t'an t'oc ixic. Niuntu mach u yäli niump'e cua'. Mach u c'atbijob cua' mu' u yäle', y mach u c'atbijob cua' uc'a u pecän. ");
INSERT INTO chfNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","De ya'i ni ixic u colesi u p'u ti' ch'en, bixi tan caj u yälben u lotob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―La'ixla chänen ya'anda untu winic u yälbon upete cua' acä chiba. ¿Mach wäreca jinda ni aj Cristo? ");
INSERT INTO chfNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","De ya'i machcatac u yubijobba pasijob tan caj bixijob bajca an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jinq'uin ni ixic bixi tan cajba, u yajcänt'anob u ch'oc chen ubajob t'oc, u yälben: ―Maestro, c'uxnen. ");
INSERT INTO chfNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aj Jesús u yälbijob: ―No'on cä cänäntan cua' cä c'uxe', anelaba mach a wila. ");
INSERT INTO chfNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","U yajcänt'anob u maläc äle'ob ca'da: ―¿Täsbinti wäre cua' u c'uxe'? ");
INSERT INTO chfNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aj Jesús u yälbijob: ―Jinq'uin cä chen ca' chich yo machca u täsconba y cä tzupsäben u patan, es ca' a wälä san c'uxnon. ");
INSERT INTO chfNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Mach quira a wäle'la: “Acoli chämp'e mes tuba ch'uch'intic u jut päc'äbi”? Ubixto, no'on cälbenetla: T'äbsen a jutla, y chänen bajca an ni päc'äbi, ac'ä'ni u jut ni päc'äbi tuba ch'uch'intic. ");
INSERT INTO chfNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Machca u xe u ch'uch'än, u tojcan. Jini jut päc'äbi, jin une ni machcatac u yosinte tuba paq'uin cuxlec. Ca' jini u mul ch'a'alan ujinob machca u tz'aycäben u t'an Dios najtäcä y machca u yäc'ben u tz'onänob ji'pat. ");
INSERT INTO chfNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Uc'a che' chich u yälcan y toj chich: “Untu u päq'ue', y otro untu machca u xe u ch'uch'än”. ");
INSERT INTO chfNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Cä täsquetla a ch'uch'änla bajca anela mach a chi patanla; otrojob u chi patan, anelaba ochetla a ch'uch'änla bajca u chi patanob. ");
INSERT INTO chfNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Q'uen aj Samariajob tama jini caj u tz'ombijob aj Jesús uc'a jini ixic u yäli ca'da: “U yälbon upete cua' cä chi”. ");
INSERT INTO chfNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jinq'uin aj Samariajob c'otijob bajca an aj Jesús, u ch'oc chi ubajob t'oc, u yälbenob colac ya'i. Coli chich ya'i chap'e q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Q'uen täcä u tz'onijob uc'a u yubijob cua' u yäli aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","U yälbijob ni ixic: ―Bada cä tz'onän t'ocob mach uc'a a t'an aneba, cä tz'onän t'ocob uc'a no'on chich acubi t'ocob u t'an aj Jesús, y bada cuwi chich t'ocob cache' jinda ni Ajjäpom tuba a'ajtäjob pancab, ni aj Cristoba. ");
INSERT INTO chfNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chap'e q'uin ji'pat, pasi ya'i aj Jesús tä Samaria, bixi tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Uc'a aj Jesús chich u yäli cache' untu ajt'an ta Dios mach u tz'ombinti u t'an tan u cab. ");
INSERT INTO chfNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tu c'ote tä Galilea, aj galileojob u yosijob chich, uc'a u chänijob upete cache' u chi tä Jerusalén tan q'uin ch'uje. Unejob täcä ya' chich ajnijob tan jini q'uin ch'uje. ");
INSERT INTO chfNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","C'oti cha'num aj Jesús tan caj tä Caná ya'i chich tä Galilea, bajca u yäc'bi sujlec de vino ni ja'. Ajni tan ni caj tä Capernaum, ya'i chich tä Galilea, untu ajtäclaya tuba ni ajnoja que c'ojo u yajlo'. ");
INSERT INTO chfNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jinq'uin u yubi cache' aj Jesús pasi tä Judea y c'oti tä Galilea, bixi u nuc'tan u ch'oc pecän aj Jesús tuba xic u tz'äcälben u yajlo', uc'a chämo u chen. ");
INSERT INTO chfNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aj Jesús u yälbi: ―Si mach a chänenla cua' chichca cä chen tuba cä ye'e' cä poder, y si mach a chänenla jini cä chen que mach u che trebe u chen niuntu winicba, mach a tz'onäla. ");
INSERT INTO chfNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ajtäclaya tajnoja u yälbi: ―Noxi' winic, seb cola uc'a mach chämic cajlo'. ");
INSERT INTO chfNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aj Jesús u yälbi: ―Cux, a wajlo' san chich u pojli uba. Jini winic u tz'ombi u t'an aj Jesús, bixi. ");
INSERT INTO chfNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jinq'uin u chen tä c'ote tu yotot, u yajpatanob bixi u nuc'tanob, u yälbijob ca'da: ―A wajlo' u pojli uba. ");
INSERT INTO chfNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","De ya'i une u c'atbijob cua' hora u täq'ui u pojlen uba. Unejob u yälbi: ―Äc'bi numi tänxin q'uin tz'ita' täpi u ticwa. ");
INSERT INTO chfNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jimba rato jini ti tu c'ajalin u pap jini ajyaj cache' jimba hora jini u yälbi aj Jesús ca'da: “A wajlo' san u pojli uba”. Une u tz'oni, y upetejob tan yotot. ");
INSERT INTO chfNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jinda u cha'petz'ib u chi aj Jesús tuba u ye'e' u poder jinq'uin pasi tä Judea c'oti tä Galileaba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ji'pat ajni ump'e q'uin ch'uje tuba aj judíosob. Jimba q'uin jini aj Jesús sujli tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tä Jerusalén ya'an ump'e u ti' ni caj que u yälbinte cache' u yochiba oveja. Nätz'ä ya'i ya'an ump'e u noj yajliba ja' u c'aba' tä hebreojt'an Betesda. Bajca an jini ja' ya'an cinco boch'. ");
INSERT INTO chfNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ya' ajnijob ch'a'a tu yaba ni boch' q'uen ajc'ojpanob, ajchoc', machcatac mach u ch'ä u chen xämba utz, ajchämen c'äb, ajchämen oc, u pitänob u nicän uba ja'. ");
INSERT INTO chfNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Uc'a untu ángelo ta Dios u p'elaj q'uin jaque tama u yajliba ja' u nicän ja'. Machca najtäcä u jaque tama ni ja' cuanta aniquintiba, u pojlen uba t'oc cua' chichca yaj que u cänäntan tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ajni ya'i untu winic u cänäntan treinta y ocho año c'ojo. ");
INSERT INTO chfNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jinq'uin aj Jesús u chäni cache' ya' ch'a'a, yuwi chich cache' ajäläcni c'ojo ni winic jini y u yälbi ca'da: ―¿A wo quira a pojlen aba? ");
INSERT INTO chfNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ajc'ojpan u p'ali: ―Noxi' winic, mach'an machca u yäq'ue'on tama jini ja' jinq'uin u niquinte ni ja'. Uc'a mu'to cä jaque no'onba, otroba san chich ajaqui. ");
INSERT INTO chfNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aj Jesús u yälbi: ―Ch'oyen, ch'ä a ch'a'lib, chen xämba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Seb u pojli uba jini winic, u ch'i u ch'a'lib, bixi tä xämba. Tu q'uin ch'ämbäji une jinq'uin aj Jesús u tz'äcäli. ");
INSERT INTO chfNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","De ya'i aj judíosob u yälbi ni machca tz'äcälquiba: ―U q'uin ch'ämbäji sami. Mach utz a bisan a ch'a'lib, uc'a ley u yäle' que mach u ch'ä cä chen patanla tu q'uini ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Une u p'ali: ―Machca u tz'äcälon, une chich u yälbon: “Ch'ä a ch'a'lib y chen xämba”. ");
INSERT INTO chfNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ni aj judíosob u c'atbijob: ―¿Caxcone u yälbet: “Ch'ä a ch'a'lib y chen xämba”? ");
INSERT INTO chfNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Machca tz'äcälquiba mach yuwi caxca une, uc'a aj Jesús u tz'eji uba bajca an ni noj q'uenel gente. ");
INSERT INTO chfNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ji'pat aj Jesús u chäni cha'num ni winic tan noj ch'u'ul otot, y u yälbi ca'da: ―Ubixto, bada a pojli aba, mach a ni' chen a tanä uc'a mach tic ta'wac'o ump'e cosa peor. ");
INSERT INTO chfNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jinq'uin u yubi jini winic, bixi u yälben aj judíosob cache' aj Jesús une ni u tz'äcäliba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jin uc'a aj judíosob u sacänob cache'da u tz'ibajtesan aj Jesús y u tzämsenob, uc'a u chi ca' jini tu q'uini ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aj Jesús u yälbijob: ―Cä Pap ixta bada u chen u patan, jin uc'a no'on täcä cä chen cä patan. ");
INSERT INTO chfNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jin uc'a aj judíosob tä' u yoli u tzämsenob, mach sec' uc'a mach u cänänta u q'uini ch'ämbäji, uc'a täcä u yäle' cache' u Papba Dios une, y ca' jini u chen uba cache' Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Aj Jesús u yälbijob: ―Totojtoj cälbenetla: Mach u ch'ä u chen u Yajlo' Dios niump'e cua' si mach äc'bintic u chen. Ca' chich u chäni u chen u Pap, che' chich u chen täcä, uc'a upete jini u chen u Papba, che' chich u chen täcä u Yajlo' Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Uc'a cä Papla Dios tä' yoba u Yajlo', jin uc'a u ye'ben upete cua' u chen; y más noj patan u xe u ye'ben u chen une, ixta anela u xe tä tajch'ictä a jutla. ");
INSERT INTO chfNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Uc'a ca' chich cä Papla Dios u tz'osen ajchämejob, y u yäc'ben cuxlecob, che' chich täcä u Yajlo' Dios u yäc'ben cuxlec machca yo u yäc'benba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Uc'a cä Papla Dios mach u yälä catac an tu toja, catac mach'an tu toja. Une u yäc'bi u Yajlo' u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Uc'a cä Papla Dios yo que upetejob u yajna'tan u Yajlo', ca' chich u yajna'tinte uneba. Machca mach u yajna'ta u Yajlo' Dios ni u täsquiba, mach u yajna'ta cä Papla Dios täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Totojtoj cälbenetla: Machca u yubin cä t'an, y machca u tz'omben machca u täsconba, paq'uin cuxu ayan; mach u yäc'binti u toje' u tanä. Ca' a wälä chämen ajni, y bada cuxpi cha'num. ");
INSERT INTO chfNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Totojtoj cälbenetla: U xe tä c'ote q'uin y bada chich ac'oti ni q'uin jini que u xe tä c'oteba, jinq'uin ajchämejob u xe u yubin u t'an u Yajlo' Dios, y machcatac u yubin u xe tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Uc'a ca' chich cä Papla Dios u juntuma chich cuxu, y mach c'änä machca u yäc'ben cuxlec, che' chich täcä u yäc'bi u Yajlo' ajnic ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","U yäc'bi täcä u poder tuba u yäle' catac an tu toja, catac mach'an tu toja, uc'a une ni sutwäni de winicba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mach ch'icwänic a jutla uc'a mu' a ubinla ca' jini, uc'a u xe tä c'ote q'uin jinq'uin upete machcatac ya'an tu muclibajob u xe u yubinob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","U xe tä pasejob tan u mucliba, y machcatac u chi utz u xe tä tz'osintejob tuba cuxlecob, y machcatac mach u chi utzba u xe tä tz'osintejob tuba äc'bintic u toje' u tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Mach u ch'ä cä chen niump'e cua' si mach äc'binticon cä chen. Ca' chich acubin, che' chich acäle' catac an tu toja, catac mach'an tu toja. Tu toja cä chen upete. Uc'a mach cä che ca' chich co no'onba. Cä chen ca' chich yo machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Si no'on cäle' machcajon, mach'an cua' uc'a tz'onintic ni cäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Otro une ni u yäle' machcajonba, cuwi chich cache' toj jini u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Anela a täsquila tä c'atbinte aj Juan machcajon, y une u yäli tu toja. ");
INSERT INTO chfNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","No'onba mach c'änä cäc'a niuntu tuba u yäle' caxcajon, pero ni mu' cäle'ba es tuba a tz'onänla y ca' jini a japän abala. ");
INSERT INTO chfNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Aj Juanba ca' a wälä ump'e chictaya une, que u tile u c'ac'a y u chictan; anelaba ch'a'ali tz'ita' ajinla bajca u chictan. ");
INSERT INTO chfNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ya'an cua' u yäle' más tu toja machcajon que ni u yäle' aj Juanba. Ni patan u yäc'bon cä Pap cä tzupsenba, jinchichba patan u ye'e' cache' cä Pap u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni cä Pap Dios que u täsconba, une chich täcä u yäli machcajon. Uneba mach bay a ubila u t'an, y mach bay a chämbila u jut. ");
INSERT INTO chfNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","U t'an uneba mach u yoch ta' c'ajalinla, uc'a mach a tz'ombela jini u täscun uneba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","A bon tzique'la ni u t'an Dios tz'ibiba, uc'a a wäle'la cache' ca' jini a xe tä äc'binte paq'uin cuxlequetla. Jinchichba u t'an Dios u yäle' machcajon. ");
INSERT INTO chfNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero mach a wo a sapänonla tuba bintiquet paq'uin cuxlequetla. ");
INSERT INTO chfNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Mach co que winic u yäle' cache' tä' utz cua' cä chen. ");
INSERT INTO chfNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Cuwi chich cache'da anetla, y cache' anelaba mach a yajna'tala Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","No'onba aton uc'a cä Pap Dios u täscon, y mach a saponla. Si tic otro sin que Dios u täscunba, jiniba a sapänla. ");
INSERT INTO chfNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Cache' u ch'e' a tz'ombenla u t'an Dios jinq'uin a wola u yäle' a lotla cache' pitzi cua' a chen, y mach a sapäla jini u yäle' Dios cache' utzba? ");
INSERT INTO chfNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mach a wäle'la cache' no'on acä xe cä sube'etla bajca an cä Pap Dios. Ni u xe u sube'etlaba, aj Moisés chich une, jini que tä' a wo a tz'ombenla u t'anba. ");
INSERT INTO chfNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Si fuera a totoj tz'ombenla u t'an aj Moisésba, a tz'ombenonla ica täcä, uc'a ni jun u tz'ibi aj Moisésba u yäle' caxcajon. ");
INSERT INTO chfNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Si mach a tz'onäla ni t'an u tz'ibi aj Moisésba, ¿cache'da a xe a tz'onänla cä t'an? ");
INSERT INTO chfNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ji'pat aj Jesús bixi tunxe nab tä Galilea, u c'aba' täcä Tiberias. ");
INSERT INTO chfNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Noj q'uelen gente u bixejob tu pat, uc'a u chänijob cache' an u poder tuba u tz'äcälin ajc'ojpanob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aj Jesús t'äbi pan tz'ic tä chumtä nämte' t'oc u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Anatz'äli ni noj paxcu', jini q'uin ch'uje taj judíosobba. ");
INSERT INTO chfNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jinq'uin aj Jesús u t'äbsi u jut u chäni cache' ya' u te noj q'uelen gente bajca an, y u yälbi aj Felipe ca'da: ―¿Cada cä mäne'la waj tuba cä'benla u c'uxe' ni gente que ya' u tejob jini? ");
INSERT INTO chfNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jinda u yäli tuba u yubin cache' u xe u p'alän aj Felipe, uc'a uneba yuwi chich cua' u xe u chen. ");
INSERT INTO chfNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aj Felipe u p'ali: ―Doscientos taq'uin de waj mach u yäc'ä tuba äc'binticob que sea tz'ita' cua' tä c'uxcan upete ni genteda. ");
INSERT INTO chfNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Untu u yajcänt'an aj Jesús u c'aba' aj Andrésba, jitz'in aj Simón Pedroba, u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ya'anda untu ajlo' que u cänäntan cinco cebadaj waj, y cha'tu yoc buch'. ¿Cua' tuba jinda, mach u yäc'ä tuba upete? ");
INSERT INTO chfNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aj Jesús u yäli: ―Äc'ben chunwänicob ni gente. Ayan q'uen tz'utz' bänäla bajca anob. Chunwänijob ca' cinco mil wincärejob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Aj Jesús u ch'i jini waj u yälbi Dios que uc'adios u chi. De ya'i u yäc'bi u yajcänt'anob, y u yajcänt'anobba u pucbi machcatac ya' chumujtacba. Che' chich täcä u chijob t'oc ni buch', u pucbijob bäyexca u yolijob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jinq'uin na'ijob, aj Jesús u yälbi u yajcänt'anob: ―Woyola u colob uc'a mach sätic niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","U woyijob chich u colob, y u tulesijob doce chach de u colob ni cebadaj waj, jin une ni coli bajca c'uxnijob upete ni gente. ");
INSERT INTO chfNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jinq'uin jini gentejob u chäni cua' u chi aj Jesús tuba u ye'e' u poder, u yälijob ca'da: ―Totoj jinda ni ajt'an ta Dios u xe tä te pancabba. ");
INSERT INTO chfNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aj Jesúsba yuwi chich cache' u xe tä tejob ni gente u cocoj ch'e'ob tuba u yosen de ajnoja, jin uc'a bixi u juntuma pan tz'ic. ");
INSERT INTO chfNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ochiq'uin u yajcänt'anob jaquijob tu ti' nab. ");
INSERT INTO chfNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ochijob tan jucub tuba bixicjob tunxe nab tä Capernaum. A'it'obni, y aj Jesúsba machto c'ot bajca anob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ch'oyi noj t'olja' tama ni nab uc'a noj gran ic' u yustan. ");
INSERT INTO chfNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Unejobba anät'ijob tä bab ca' tuba seis kilómetros. De ya'i u chänijob aj Jesús cache' ya' u te tä xämba pan ja' u natz'än jucub, y bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aj Jesús u yälbijob: ―¡No'on chich! ¡Mach bäc'taquetla! ");
INSERT INTO chfNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Unejob ch'a'a ujinob y u yosijob tan jucub; y seb c'oti ni jucub tä cab bajca u xejob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Päscab jini noj q'uenel gente colijob tunxe nabba ti tu c'ajalinob cache' ump'emp'e jucub ajni ya'i, y cache' aj Jesús täcä mach ochi tama jini jucub, sec' u yajcänt'anob namás bixijob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jimba q'uin jini c'otijob otros jucub nätz'ä bajca u c'uxijob ni wajba, ya'i chich bajca Cajnojala u yälbi Dios que uc'adios u chi. Ni jucub jini ya' tijob tä Tiberias. ");
INSERT INTO chfNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jinq'uin ni gente u chäni cache' mach'an aj Jesús, y mach'an u yajcänt'anob täcä, ochijob tama jini jucub y bixijob tä Capernaum u sacän aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jinq'uin u pojlijob tunxe nab, u c'atbijob: ―Maestro, ¿caq'uin julet wida? ");
INSERT INTO chfNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aj Jesús u p'albijob: ―Totojtoj cälbenetla, a sacänonla mach uc'a a chänila cache' cä ye'i cä poder. A sacänonla uc'a a c'uxila a pa' wajla y bon na'étla. ");
INSERT INTO chfNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Chen patanla mach tuba a sacänla ni cua' tä c'uxcan que u sätoba. Chenla tuba a sacänla ni cua' tä c'uxcan que u yäq'ue' paq'uin cuxlequetlaba, jin ni cä xe cä'benetla no'on que sutwänon de winicba, uc'a jin chich u yäc'bon cä chen cä Papla Dios, y une u yäle' cache' utz ni cua' cä chen. ");
INSERT INTO chfNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Unejob u yälbi: ―¿Cua' patan u ch'e' cä chen t'ocob tuba cä cherben t'ocob u patan Dios? ");
INSERT INTO chfNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aj Jesús u yälbijob: ―Jinda ni Dios yo que a chenlaba, a tz'ombenla ni machca Dios u täsquiba. ");
INSERT INTO chfNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Unejob u yälbi: ―¿Cua' jini a chen ane tuba a ye'e' a poder, uc'a cä chänen t'ocob y cä tz'onän t'ocob? ¿Cuaxca patan a cherben Dios? ");
INSERT INTO chfNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Cä papla oni u c'uxijob maná bajca mach cuxu niuntu, ca' chich tz'ibi tan u jun Dios, ni u yäle' ca'daba: “Waj ti tä cielo une Dios u yäc'bijob tuba u c'uxe'ob”. ");
INSERT INTO chfNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aj Jesús u yälbijob: ―Totojtoj cälbenetla: Aj Moisés mach u yäc'betla ni mero waj que u te tä cieloba. Cä Papla Dios ni u yäc'benetla ni totoj waj que u te tä cieloba. ");
INSERT INTO chfNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Uc'a jini waj que Dios u yäq'ue'ba, jin une ni ya' ti tä cieloba, jini que u yäq'ue' cuxlec a'ajtäjob pancabba. ");
INSERT INTO chfNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Unejob u yälbi: ―Cajnoja, paq'uin äc'benon t'ocob jini waj. ");
INSERT INTO chfNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aj Jesús u yälbijob: ―No'on ni wajon tuba cuxlequetla. Machca u te bajca anon mach uni' xin tä jitz'an, machca u tz'ombenon mach uni' xin tä tiquin u ti'. ");
INSERT INTO chfNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bada cälbenetla cache' a chänonla pero mach a tz'onäla. ");
INSERT INTO chfNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Upete machcatac u yäc'benon cä Papba u te bajca anon; y machca u te bajca anon mach cä pa'se. ");
INSERT INTO chfNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Uc'a jacon tä cielo mach tuba cä chen cua' co no'on, aton cä chen ca' chich yo cä chen ni machca u täsconba. ");
INSERT INTO chfNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jinda yo cä chen cä Pap jini que u täsconba, cä cuxpesan tu xupiba q'uin upete ni u yäc'bon, y mach sätic niuntu. ");
INSERT INTO chfNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jinda yo ni machca u täsconba, paq'uin cuxlecob upete machcatac u chänen u Yajlo' y u tz'omben, y no'on cä xe cä cuxpesan tu xupiba q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aj judíosob bänäcnajob tä t'an tuyac'o uc'a u yäli: “No'on ni wajon que pason tä cielo jacon pancabba”. ");
INSERT INTO chfNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","U yäle'ob ca'da: ―¿Mach quira jinda ni aj Jesús, u yajlo' aj José, u pap y u na' cä chen conocela? ¿Can uc'a jiq'uin u yäle': “Pason tä cielo jacon pancabba”? ");
INSERT INTO chfNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Aj Jesús u yälbijob: ―Mach ajniquetla tä bänäcne tä t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Niuntu mach u ch'ä tic bajca anon si mach u yäc'be tic cä Pap ni u täsconba, y ca' jini no'on cä xe cä cuxpesan tu xupiba q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ajt'anob ta Dios u tz'ibi ca'da: “Dios chich u xe u ye'benob upetejob u t'an”. Jin uc'a upete machcatac u yubi u t'an cä Papla Diosba y machcatac u cäni, u te chich bajca anon. ");
INSERT INTO chfNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Niuntu mach bay u chäni cä Papla Dios, sec' machca ti bajca an Diosba. Une ni u chäni cä Papla Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Totojtoj cälbenetla: Machca u tz'ombenon, paq'uin cuxu u xe tä ajtä. ");
INSERT INTO chfNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","No'on ni wajon que u yäq'ue' paq'uin cuxlec untu. ");
INSERT INTO chfNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A papla ajni oniba u c'uxijob ni maná bajca mach cuxu niuntu. Mach uc'a ca' jini äc'binti paq'uin cuxlec. Laj chämijob chich. ");
INSERT INTO chfNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero machca u c'uxe' ni waj que pasi tä cielo y jaqui pancabba mach ucham une. ");
INSERT INTO chfNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","No'on une ni wajon que pason tä cielo y jacon pancabba. No'on une cäq'ue' paq'uin cuxlec untuba. Machca u c'uxe' ni wajdaba, u xe tä ajtä paq'uin cuxu. Ni waj cäq'ue' no'onba, cä bec'ta une, acäq'ue' tuba cuxlec a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aj judíosob u maläc täq'uijob päpä' t'an, u yäle'ob: ―Jinda winic ¿cache'da u ch'e' u yäc'benonla u bec'ta tuba cä c'uxe'la? ");
INSERT INTO chfNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aj Jesús u yälbijob: ―Totojtoj cälbenetla si mach a c'uxe'la cä bec'ta no'on que sutwänon de winic, y si mach a wuch'enla cä ch'ich'e, mach uxet tä äc'bintela paq'uin cuxlequetla. ");
INSERT INTO chfNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Machca u c'uxe' cä bec'ta, machca u yuch'en cä ch'ich'e, paq'uin cuxu ayan; y no'on cä xe cä cuxpesan tu xupiba q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Uc'a cä bec'ta ni totoj we'e, cä ch'ich'e ni totoj buc'a. ");
INSERT INTO chfNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Machca u c'uxe' cä bec'ta, machca u yuch'en cä ch'ich'e, une paq'uin t'oc no'on ayan, y no'on paq'uin t'oc une ayanon. ");
INSERT INTO chfNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ca' chich u täscon cä Papla Dios ni cuxu ayanba, y no'on täcä cuxulon uc'a une, che' chich täcä machca u c'uxe' cä bec'ta, une täcä u xe tä ajtä cuxu, uc'a no'on cä xe cä'ben cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","No'on une ni waj que pason tä cielo y jacon pancabba, mach ca' ni maná u c'uxijob a papla que ajni oniba, jini que chämen ayanob badaba. Machca u c'uxe' ni wajdaba u xe tä ajtä paq'uin cuxu. ");
INSERT INTO chfNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jintacda u yäli tan ch'u'ul otot, bajca u ye'e' u t'an Dios tä Capernaum. ");
INSERT INTO chfNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Q'uen u yajcänt'anob, tu yubinob ca' jini, u yälijob: ―Cach ni t'an jini, ¿caxca une u xe u tz'onän? ");
INSERT INTO chfNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aj Jesús yuwi chich tan u pixan cache' u yajcänt'anob bänäcnajob tä t'an uc'a jini u yäliba, y u yälbijob ca'da: ―¿U yäc'benetla quira sujlequetla ta' pat ni acäliba? ");
INSERT INTO chfNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Cua' ti jini a xe a chenla si a chänenla jiq'uin cache' no'on que sutwänon de winic t'äbicon tä cielo bajca ajnon najtäcä? ");
INSERT INTO chfNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pixan u yäq'ue' cuxlec untu, cuerpoba mach u yäc'ä. Jini t'an acälbetlaba tuba a pixanla une, y tuba paq'uin cuxlequetla. ");
INSERT INTO chfNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tulaj anetla que mach a tz'onäla. Jinda u yäli uc'a aj Jesús worin yuwi chich machcatac mach u tz'onä, y machca u xe u yäq'ue' tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aj Jesús u yäli täcä: ―Jin uc'a cälbetla que niuntu mach u ch'ä tic bajca anon si mach u yäc'be tic cä Papla Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Uc'a ni t'anda que u yäliba, q'uen u yajcänt'anob sutwänijob tu pat, y mach uni' numob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","De ya'i aj Jesús u yälbijob ni doceba ca'da: ―¿A wola quira bixiquetla täcä? ");
INSERT INTO chfNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Aj Simón Pedro u p'albi: ―Cajnoja, ¿caxca t'oc jiq'uin cä xe t'ocob? A t'an ane u yäq'ue' paq'uin cuxlecon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","No'on t'ocob cä tz'onän t'ocob, y cuwi t'ocob cache' ane aj Cristojet, u Yajlo'et ni Dios cuxuba. ");
INSERT INTO chfNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Aj Jesús u yälbi: ―¿Mach quira cä yaquetla anelaba doce, y untu de anelaba tuba ni diablo une? ");
INSERT INTO chfNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jinda u yäli uc'a aj Judas Iscariote, u yajlo' aj Simón, u xe u yäq'ue' tä c'äbä, y uneba untu de ni docejobba. ");
INSERT INTO chfNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ji'pat coli aj Jesús tä Galilea, mach u yoli xic tä Judea uc'a aj judíosob u sacänob cache'da u tzämsen. ");
INSERT INTO chfNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Anatz'äli q'uin ch'uje taj judíosob, jini q'uin ch'uje ta boch'. ");
INSERT INTO chfNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","U jitz'inob aj Jesús u yälbijob ca'da: ―Pasen wida cux tä Judea tuba u chänenob a wajcänt'anob ya'iba cua' patan a chen. ");
INSERT INTO chfNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Machca yo ubcac cua' u chen, mach mucu u chen u patan. Si ane a chen cua' chichca tuba chäninticba, chen tuba u chänen upete. ");
INSERT INTO chfNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","U jitz'inob u yälijob ca'da uc'a unejob täcä mach u tz'onä. ");
INSERT INTO chfNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aj Jesús u yälbijob: ―Mach to c'ot q'uin ta xicon. Anelaba u ch'e' xiquetla cachichcamba q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A'ajtäjob pancab mach u cräxna'tetla. No'onba u cräxna'tanonob uc'a cäle' tu toja cache' mach utz cua' u chenob. ");
INSERT INTO chfNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Anelaba cuxla tä q'uin ch'uje. No'onba mach to xon bajca an ni q'uin ch'uje jini uc'a mach to c'ot q'uin xicon. ");
INSERT INTO chfNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cuantu yälbijob ca'da, une coli tä Galilea. ");
INSERT INTO chfNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ji'pat que bixi u jitz'inob tä q'uin ch'uje, bixi täcä c'äs mucu, y mach u ye'i uba. ");
INSERT INTO chfNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aj judíosob cayi u sacänob tan q'uin ch'uje, u yäle'ob ca'da: ―¿Cada wäre an jini winic? ");
INSERT INTO chfNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ni noj q'uenel gente ju'lawjob uc'a u tulaj äle'ob ca'da: “Utz u chen jini winic”. Y otrosjob u yäle'ob ca'da: “Mach une. Ni winic jiniba u sucpecänonla”. ");
INSERT INTO chfNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Niuntu mach yo u tz'aycun aj Jesús uc'a u bäc'tanob aj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","La mitad to u colan ta xupic ni q'uin ch'uje, aj Jesús ochi tan noj ch'u'ul otot u ye'e' u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aj judíosob tajch'icwäni u jutob u yubin cua' u yäle', y u yäle'ob ca'da: ―¿Cache'da yuwi q'uen cua' chichca jini winic, y mach ajni u cäne'? ");
INSERT INTO chfNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aj Jesús u yälbijob: ―Jini cä ye'e'ba mach jin cä t'an une. Cä ye'e' u t'an machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Machca chichca yo u chen cua' yo Dios, u xe chich yuwina'tan si ni cä ye'e'ba tuba Dios, o si no'on chich acä pa'si täj c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Machca u yäle' jini u te tu c'ajalinba, une chich u sacän älbintic cache' pitzi cua' u chen. Pero machca u sacän cache' ch'u'ul c'ajti'cac ni Dios u täsquiba, jin une ni u tojaba. Y mach'an jop'ojti' t'oc. ");
INSERT INTO chfNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Mach quira u yäc'betla ni ley aj Moisés? Y niuntu de anela mach a chela tu toja ca' u yäle' jini ley. ¿Cua' uc'a a sacänla cache' a xe a tzämsenonla? ");
INSERT INTO chfNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ni gente u yälbijob ca'da: ―Ane a cänäntan tzuc pixan ta'wac'o. ¿Caxcone u sacän u tzämsenet? ");
INSERT INTO chfNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aj Jesús u yälbijob: ―Tajch'icwäni a jutla a chänen jini cä chi t'oc poder tu q'uini ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Aj Moisés u yäc'betla ni circuncisión, mach uc'a aj Moisés u yäq'ui, a najtäcäl noxi'papla u yäq'ui; y tu q'uini ch'ämbäji a wäq'ue' tä ute circuncisa untu. ");
INSERT INTO chfNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Si anela a chen circuncisa untu ch'oc tu q'uini ch'ämbäji uc'a mach a säte'la t'oc ni ley taj Moisés, ¿cäräxetla quira t'oc no'on uc'a tu q'uini ch'ämbäji cä tz'äcäli untu winic? ");
INSERT INTO chfNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mach a päpä' äle'la si mach tu toja cua' u chen untu jinq'uin a taj chänenla y mach totoj a wila. Äläla jinq'uin a wila chich si tu toja o mach tu toja. ");
INSERT INTO chfNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Aj Jerusalénob u tulaj älijob ca'da: ―¿Mach quira jinda ni mu' u saquinte ta tzämsinticba? ");
INSERT INTO chfNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chänen cache' u chen t'an tuba u yubin upete, y mach u yälbinti cua'. ¿Yuwijob wäreca ajnojajob cache' totoj jinda naj Cristo, ni u xe u täscun Diosba? ");
INSERT INTO chfNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero ni winicdaba cuwila chich cada an u cäji. Jinq'uin u xe tä te aj Cristoba, niuntu mach uxin u wina'tan cada u xe tä te. ");
INSERT INTO chfNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aj Jesúsba t'oc noj t'an u ye'e' u t'an Dios tan noj ch'u'ul otot, u yäle' ca'da: ―¡No'onba a chenonla conoce, a wila chich cada an cä cäji! Pero mach uc'a cä pa'si täj c'ajalin no'on ticon, täsquinte acä chi. Machca u täsconba, une ni mero Dios. Anela mach a che conocela. ");
INSERT INTO chfNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","No'onba acä chen conoce uc'a ya' aton bajca an, y une u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","De ya'i u sacänob cache' u q'ueche'. Pero niuntu mach u jup'i u c'äb u q'ueche' uc'a mach to c'ot q'uin ta q'uechcac. ");
INSERT INTO chfNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Q'uen machca u tz'ombijob, y u yäle'ob ca'da: ―Jinq'uin u xe tä te aj Cristoba, ¿u xe u ye'e' más u poder a wäle' que jinda winic? ");
INSERT INTO chfNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aj fariseojob u yubijob cache' ni gente bänäcnajob tä t'an u tz'aycunob aj Jesús. Ajnojajob ta palejob y aj fariseojob u täsqui u yajc'äncanob tuba u q'ueche'. ");
INSERT INTO chfNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aj Jesús u yäli: ―Cä xe tä ajtä chap'e uxp'e q'uin t'oc anela, de ya'i cä xe tä bixe bajca an machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A xe a sacänonla, y mach uxet a pojlenonla. Bajca cä xe tä ajtä, anelaba mach u ch'ä xiquetla. ");
INSERT INTO chfNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","De ya'i aj judíosob u maläc älijob: ―¿Cada u xe jinda winic que mach cä pojlenla? ¿Ya' wäre u xe bajca nonoj bixijob aj judíos ca'an aj griegojob tuba u ye'benob u t'an Dios aj griegojob? ");
INSERT INTO chfNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Cua' ti jini u yäli: “A xe a sacänonla, mach uxet a pojlenonla; bajca cä xe tä ajtä, anela mach u ch'ä xiquetla”. ");
INSERT INTO chfNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tu xupiba q'uin ta ni q'uin ch'uje, jini mero q'uin tuba ni q'uin ch'ujeba, aj Jesús wa'wäni y t'oc noj t'an u yäli: ―Machca chichca tiquin u ti', tic bajca anon tä buc'a. ");
INSERT INTO chfNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Machca u tz'ombenon cä t'an ca' chich u yäle' ni jun ta Dios tz'ibiba, ca' a wälä noj q'uelen ja' u xe tä pase tu pixan tuba u yäc'ben paq'uin cuxlec y tuba cuxlec täcä u lotob. ");
INSERT INTO chfNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jinda u yäli cache' Ch'u'ul Pixan u xe tä äc'bintejob machcatac u tz'omben uneba; uc'a mach to jul ni Ch'u'ul Pixan uc'a aj Jesús mach to bix tä cielo tuba äc'bintic u pitzilan. ");
INSERT INTO chfNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jinq'uin u yubijob ni t'anda, u tulaj älijob: ―Totoj jinda ni ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Otros u yälijob: ―Jinda ni aj Cristo. Otros u yälijob: ―¿Tä Galilea quira u xe tä te ni aj Cristo? ");
INSERT INTO chfNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Mach quira u yäle' ni jun ta Dios tz'ibiba cache' aj Cristo u xe tä te de u familiajob aj David, tä Belén bajca u cäji aj David? ");
INSERT INTO chfNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ni gente u jec'li ubajob tä t'an uc'a aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ajni machca u yolijob u q'ueche', pero niuntu mach u jup'i u c'äb u q'ueche'. ");
INSERT INTO chfNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ajc'äncanob c'otijob bajca an ajnojajob ta palejob y bajca an aj fariseojob. Unejob u yälbi ni ajc'äncanob: ―¿Can uc'a mach a täsila? ");
INSERT INTO chfNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ajc'äncanob u p'ali: ―¡Mach bay u chi t'an niuntu winic ca' u chen ni winicba jini! ");
INSERT INTO chfNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aj fariseojob u p'ali: ―¿U sucpequetla quira anela täcä? ");
INSERT INTO chfNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Mach quira a chänila cache' mach'an niuntu ajnojajob o aj fariseojob que u tz'ombijob? ");
INSERT INTO chfNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jini gente que mach yuwijob ni leyba, mach jin tuba Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aj Nicodemo, jini aj Nicodemo c'oti bajca an aj Jesús ac'äbba, une täcä es untu de ni ajnojajob, une u yälbenob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿Ni ley täc'ala, u yäc'ben quira u toje' u tanä untu si mach to cheque cua' u chi? Mach une. ");
INSERT INTO chfNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Unejob u yälbijob: ―¿Ane täcä aj galileojet quira? Sacän tan u jun Dios, iran cache' tä Galilea mach bay pasi niuntu tuba xic de ajt'an ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","De ya'i cada juntu laj bixijob tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aj Jesús bixi tu pam jini tz'ic u c'aba' Olivas. ");
INSERT INTO chfNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Päscab isapan sutwäni tan noj ch'u'ul otot. Upete ni gente c'otijob bajca an. Chunwäni u ye'benob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jinq'uin jini que u ye'e' ni leyba nämte' t'oc aj fariseojob u c'osbijob untu ixic q'uechqui t'oc winic; u yäq'uijob tänxin gente. ");
INSERT INTO chfNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","U yälbenob aj Jesús: ―Maestro, jinda ixic aq'uechqui t'oc winic y mach jin jit'oc. ");
INSERT INTO chfNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aj Moisés u yäli tuyac'o ley tzämsintic t'oc ji'tun machca u chen ca' jini. ¿Aneba, cache' a wäle'? ");
INSERT INTO chfNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jinda u yälijob uc'a u yubinob cache' u xe u p'alän, tuba ajnic cache'da u sube'ob aj Jesús si mach u p'alä tu toja. Aj Jesús tinwäni u tz'ibän t'oc u ni'c'äb tä cab. ");
INSERT INTO chfNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Uc'a u bon c'atbenob, wa'wäni aj Jesús u yälbenob: ―Machca de anelaba mach'an u tanä u julben najtäcä ni ji'tun tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tinwäni tä cha'num u tz'ibän tä cab. ");
INSERT INTO chfNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jinq'uin u yubijob ca' jini, u ch'i quisin tu c'ajalinob, u täq'uijob tulaj bixe noxibilba ixta que laj bixi upetejob. Coli u juntuma aj Jesús t'oc jini ixic que u yäq'uijob tänxinba. ");
INSERT INTO chfNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Wa'wäni aj Jesús u chänen cache' mach'an machca sec' ixic u juntuma, u yälbi jini ixic: ―¿Cada an machcatac u sube'et? ¿Mach quira coli niuntu machcatac u c'atän a toje' a tanä? ");
INSERT INTO chfNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Une u yäli: ―Noxi' winic, mach ni' an niuntu. Aj Jesús u yälbi: ―Ni no'on täcä mach cä'bet a toje' a tanä. Cux, mach a ni' chen a tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ji'pat aj Jesús u pequijob ni gente tä cha'num, u yälbijob: ―No'on ni junch'äcnilon tuba machcatac cuxujob pancab. Machca u tzäypätinon mach uxin tä nume tan it'obni, une u xe u cänäntan junch'äcni ta paq'uin cuxlec. ");
INSERT INTO chfNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jinq'uin aj fariseojob u yälbi: ―Ane chich mu' a wäle' machcajet. Jini a wäle'ba mach toj une. ");
INSERT INTO chfNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aj Jesús u yälbijob: ―Mach u che si no'on chich acäle' machcajon, jini acäle'ba toj une, uc'a cuwi cada ton y cada cä xe. Anelaba mach a wila cada ton, y mach a wila cada cä xe. ");
INSERT INTO chfNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jinq'uin a wäle'la catac an tu toja, catac mach'an tu toja, ta' c'ajalinla chich a pa'senla. No'onba mach cälä catac an tu toja, catac mach'an tu toja. ");
INSERT INTO chfNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y si no'on cäle' catac an tu toja, catac mach'an tu toja, ni cäle'ba toj une; uc'a mach sec' no'on cäle'. Cä Pap, ni u täsconba, che' chich u yäle' täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ya' chich tz'ibi tuyac'o ley ta'ala ni u yäle' ca'daba: “U t'an cha'tu winicba toj une”. ");
INSERT INTO chfNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","No'on chich cäle' machcajon y cä Pap täcä, ni u täsconba, u yäle' machcajon. ");
INSERT INTO chfNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","De ya'i u c'atbijob: ―¿Cada an a Pap? Aj Jesús u p'ali: ―Mach a chon conocela; cä Pap täcä mach a che conocela. Si fuera no'on a chenon conocela, cä Pap täcä a chen conocela ica. ");
INSERT INTO chfNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jinda t'an u yäli aj Jesús bajca u yälo taq'uin jinq'uin ya'an u ye'e' u t'an Dios tan noj ch'u'ul otot. Niuntu mach u q'uechi uc'a mach to c'ot q'uin ta q'uechcac. ");
INSERT INTO chfNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aj Jesús u yälbijob tä cha'num: ―No'on acä bixe, y a xe a sacänonla. T'oc a tanäla a xe tä chämola; bajca cä xe no'onba, anelaba mach u ch'ä xiquetla. ");
INSERT INTO chfNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aj judíosob u yälijob ca'da: ―¿U xe wäreca u tzämsen uba, jin uc'a u yäle': “Bajca cä xe, anela mach u ch'ä xiquetla”? ");
INSERT INTO chfNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Une u yälbijob: ―Anela päncäbetla pancab, no'on ton tä cielo; anela tuba jinda u pancabetla, no'on mach tuba jinda u pancabon. ");
INSERT INTO chfNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jin uc'a cälbetla a xe tä chämola t'oc a tanä, uc'a si mach a tz'onäla cache' no'on aj Cristojon a xe tä chämola t'oc a tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Unejob u c'atbenob: ―¿Caxcajet ane? Aj Jesús u yälbijob: ―Jin chich na cälbetla najtäcäba. ");
INSERT INTO chfNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Q'uen ayan cua' cäle' y quiran si tu toja ayanetla. Machca u täsconba, toj u t'an une; jin acubi u yäle' uneba, jin chich acäle' pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mach u chi entendejob cache' jini u yäliba de cä Papla Dios une. ");
INSERT INTO chfNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aj Jesús u yälbijob: ―Jinq'uin a xe a t'äbsenonla tä cruz no'on que sutwänon de winic, jinq'uin u xe tä te ta' c'ajalinla cache' no'on ni aj Cristojon, ni u täscon Diosba, y u xe tä te ta' c'ajalinla cache' no'on mach cä che niump'e cua' si mach a'binton cä chen. Ca' chich u ye'bon cä Pap, jin chich acäle'. ");
INSERT INTO chfNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Uc'a machca u täscon ya' chich an t'oc no'on. Cä Pap mach u yäcton cä juntuma uc'a no'on cä paq'uin chen cua' chichca yo. ");
INSERT INTO chfNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tu yäle' jinda t'an, q'uen u tz'ombijob. ");
INSERT INTO chfNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aj Jesús u yälbijob aj judíosob jini que u tz'onijobba: ―Si anela paq'uin colaquetla t'oc cä t'an, anela chich totoj cajcänt'anetla. ");
INSERT INTO chfNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A xe a wina'tanla camba u toja, y jini u t'an Dios tojba u xe u pa'senetla tu c'äb a yumla. ");
INSERT INTO chfNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Unejob u p'ali: ―U ch'ocob aj Abrahanon t'ocob, mach bay ajnon t'ocob tu c'äb cä yum t'ocob. ¿Cua' uc'a a wäle' ca' jini: “A xe tä pa'sintela tu c'äb a yumla”? ");
INSERT INTO chfNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aj Jesús u yälbijob: ―Totojtoj cälbenetla, upete machcatac u chen u tanä, u tanä chich u chen manda, ca' a wälä u yum. ");
INSERT INTO chfNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","U yajpatan untu winic mach u nonoj col tan yotot u yum; u yajlo' jini winicba u colan une. ");
INSERT INTO chfNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jin uc'a si u Yajlo' Dios u pa'senetla tu c'äb a yumla, totoj pa'sintetla chich. ");
INSERT INTO chfNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Cuwi cache' u ch'ocob aj Abrahanetla, pero a sacän cache' a tzämsenonla uc'a mach uyoch cä t'an ta' c'ajalinla. ");
INSERT INTO chfNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","No'on cäle' cua' acä chäni bajca an cä Pap, anelaba a chenla cua' a ubila t'oc a papla. ");
INSERT INTO chfNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Unejob u p'albijob: ―Cä pap t'ocob aj Abraham une. Aj Jesús u yälbijob: ―Si toj ica cache' u ch'ocobetla aj Abraham, ca' chich u chi aj Abraham, che' chich ica a chenla täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero anelaba a sacänla cache' a tzämsenonla, no'on une ni cälbetla u toja, jin acubi t'oc Diosba. Aj Abraham mach u chi ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Anela a chenla ca' chich u chen a papla. Jinq'uin unejob u yälbi ca'da: ―Mach jin u ch'ocobon t'ocob ajtz'ijte'ba; tontu cä pap t'ocob, Dios une. ");
INSERT INTO chfNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aj Jesús u yälbijob: ―Si toj ica cache' Dios a paplaba, a yajna'tanonla ica, uc'a no'on bajca an Dios apason, ya' chich aton. Mach uc'a no'on cä pa'si täj c'ajalin ticon. Une u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Cua' uc'a mach a che entendela cua' cäle'? Uc'a mach a wo a ubinla cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","A papla anelaba diablo une; ca' chich yo a pap, che' chich a wo a chenla. Uneba ajtzämsa chäcäl najtäcä, y mach u chi tu toja, uc'a mach t'oc u toja ayan. Jinq'uin u chen jop'ojti', u chen uc'a che' chich nämä u chen, uc'a ajjop'ojti' une; uneba es ca' a wälä u papob ajjop'ojti' uc'a une u yäq'ui ajnic ajjop'ojti'job. ");
INSERT INTO chfNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","No'onba uc'a cäle' tu toja, mach a tz'ombonla. ");
INSERT INTO chfNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Caxca une de anela u ch'e' u yäle' cache' an cä tanä? Si toj ni cäle'ba, ¿cua' uc'a mach a tz'ombonla? ");
INSERT INTO chfNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Machca ta Diosba, u t'an Dios u yubin. Jin uc'a anelaba mach a ubila, uc'a mach ta Diosetla. ");
INSERT INTO chfNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jinq'uin u p'albijob aj judíosob u yälbi ca'da: ―¿Mach ca toj cäli t'ocob cache' ane aj samaritanojet, a cänäntan tzuc pixan ta'wac'o? ");
INSERT INTO chfNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aj Jesús u p'ali: ―Mach cä cänänta tzuc pixan täjcac'o. No'onba cäle' cache' utz cua' u chen cä Pap. Pero anelaba mach a wäläla cache' utz cua' cä chen. ");
INSERT INTO chfNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","No'onba mach cä sacä älbinticon cache' utz cua' cä chen. Ya'an machca u yäle', y une chich u xe u yäle' camba u toja. ");
INSERT INTO chfNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Totojtoj cälbenetla, machca u tz'ombenon cä t'an, mach bay uni' xin u jiran chämo. ");
INSERT INTO chfNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","De ya'i aj judíosob u yälbijob: ―Bada cuwi chich t'ocob cache' a cänäntan tzuc pixan ta'wac'o. Aj Abraham chämi, ajt'anob ta Dios chämijob täcä, y aneba a wäle' ca'da: “Machca u tz'ombenon cä t'an, mach bay uni' xin u jiran chämo”. ");
INSERT INTO chfNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ane quira más ajnojalet que cä papla aj Abraham ni chämiba? Ajt'anob ta Dios chämijob täcä. ¿Aneba jiq'uin, caxcajet a wäle'? ");
INSERT INTO chfNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aj Jesús u p'ali: ―Si no'on cäle' cache' pitzi cua' mu' cä chenba, ni cäle'ba mach u che vale cua' une. Cä Pap une ni u yäle' cache' pitzi cua' mu' cä chenba, jini a wäle'la cache' a Dioslaba. ");
INSERT INTO chfNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mach a che conocela. No'onba cä chen conoce. Si fuera cäle' cache' mach cä che conoce, ajjop'ojti'on ica täcä ca' chich anela. No'onba cä chen chich conoce y no'on cä tz'omben u t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A papla aj Abraham ch'a'a ujin u pitän ticon pancab. Ch'a'ali chich ujin uc'a u chäni cache' julon. ");
INSERT INTO chfNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","De ya'i aj judíos u yälbijob: ―Aneba mach to a cänänta cincuenta año, ¿y a wäle' que a chäni aj Abraham? ");
INSERT INTO chfNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aj Jesús u yälbijob: ―Totojtoj cälbenetla, mach to an aj Abraham, no'onba ya' chich anon. ");
INSERT INTO chfNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","U ch'ijob ji'tun tuba u jule'ob t'oc, pero aj Jesús mucu pasi tan noj ch'u'ul otot, numi tänxin de unejob y bixi. ");
INSERT INTO chfNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Bajca u nume aj Jesús u chäni untu ajchoc'. Jini ajchoc' che' chich päncäbi. ");
INSERT INTO chfNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","U yajcänt'anob u c'atbijob ca'da: ―Maestro, ¿caxca une an u tanä tuba päncäbac ni winicda de ajchoc'? ¿Ayan quira u tanä u pap y u na', o ayan u tanä uneba? ");
INSERT INTO chfNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aj Jesús u p'ali: ―Mach uc'a an u tanä ni winicda, mach uc'a an u tanä u pap y u na'. Päncäbi de ajchoc' sec' uc'a chäncac cache' Dios u ch'e' u tz'äcälin. ");
INSERT INTO chfNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","C'änä cä cherben u patan machca u täscon, bada que an to q'uin. U xe tä oche ac'äb jinq'uin niuntu mach u ch'ä u chen patan. ");
INSERT INTO chfNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ya'to anon pancab, junch'äcnilon tuba a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jinda u yäli y de ya'i u chi u tub tä cab, u chi pusu t'oc u c'äbti', y u tatz'bi tu jut ajchoc'. ");
INSERT INTO chfNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","U yälbi: ―Cux poco tan ni u yajliba ja' Siloé ―ni t'an Siloéba u yäle' ca'da: Täsquinti une. Bixi u poque'. Jinq'uin sutwäniba, u chen chanä. ");
INSERT INTO chfNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jinq'uin u yajnätz'älajob, y machcatac u chäni najtäcä cache' ajchoc' jini winic, u yälijob: ―¿Mach quira jinda ni u chumtä u c'atän u matänba? ");
INSERT INTO chfNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","U tulaj älijob: ―Une chich. Otrosjob u yäli: ―Jin chich u jut a wälä. Pero uneba u yäli: ―No'on chich. ");
INSERT INTO chfNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Unejob u yälben: ―¿Caxca u yäc'bet a chen chanä? ");
INSERT INTO chfNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Une u yäli: ―Ni winic u c'aba' aj Jesúsba u chi pusu, u tatz'bon cä jut, u yälbon: “Cux tä Siloé poco”. Ajnon cä poque', y u jäbi uba cä jut. ");
INSERT INTO chfNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","De ya'i u yälbijob: ―¿Cada an ni winic jini? Une u yäli: ―Mach cuwi. ");
INSERT INTO chfNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","U bisijob bajca an aj fariseojob jini winic que ajchoc' ajniba. ");
INSERT INTO chfNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","U q'uin ch'ämbäji jinq'uin aj Jesús u chi jini pusu, y u yäc'bi u chen chanä ni ajchoc'. ");
INSERT INTO chfNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Aj fariseojob täcä sutwäni u c'atbenob cache'da jäbqui u jut. Une u yälbijob: ―U yäq'ui pusu täc jut, cä poqui, y bada cä chen chanä. ");
INSERT INTO chfNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jinq'uin u tulaj äle'ob aj fariseojob: ―Jinda winic mach ta Dios, uc'a mach u cänänta u q'uin ch'ämbäji. Otrosjob u yäle'ob: ―¿Cache' u ch'e' untu winic ajcherajtanä u chen ca'da? U jec'li ubajob tä t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sutwäni u yälbenob ajchoc' ca'da: ―Aneba, ¿cache' a wäle' t'oc ni machca u jäbbet a jutba? Une u yäli: ―Ajt'an ta Dios acäle'. ");
INSERT INTO chfNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aj judíosob mach u tz'onijob cache' jini winic ajni de ajchoc', y cache' äc'binti u chen chanä, ixta que u joc'bijob u pap y u na' ni machca äc'binti u chen chanäba. ");
INSERT INTO chfNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","U c'atbijob ca'da: ―¿Jinda quira na wajlo', a wäle'la cache' päncäbi ajchoc'ba? ¿Cache'da jiq'uin u chen chanä badaba? ");
INSERT INTO chfNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","U pap y u na' u yäli: ―Cuwi chich t'ocob cache' jinda ni cajlo' y que päncäbi ajchoc'ba. ");
INSERT INTO chfNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bada u chen chanä, mach cuwi t'ocob cache'da, mach cuwi t'ocob caxca u jäbbi u jut. Uneba noxi' winic, u ch'e' a c'atbenla. Une chich u xe u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ca'da u yäli u pap y u na' uc'a bäc'tajob t'oc aj judíosob; uc'a aj judíosob u worin älijob cache' u xe tä pa'sinte tan ch'u'ul otot machca u yäle' cache' aj Jesús ni Mesías, jini u xe u täscun Diosba. ");
INSERT INTO chfNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jin uc'a u pap y u na' u yäli ca'da: “Uneba noxi' winic, u ch'e' a c'atbenla”. ");
INSERT INTO chfNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","U joq'uijob cha'num ni winic ajni de ajchoc'ba, u yälbijob: ―C'ajti'in Dios. Cuwi chich t'ocob cache' ni winic jini ajcherajtanä. ");
INSERT INTO chfNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Une u yäli ca'da: ―Mach cuwi si ajcherajtanä. Ni cuwiba, cache' no'on ajchoc' ajnon, bada acä chen chanä. ");
INSERT INTO chfNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sutwänijob u cha'num c'atben: ―¿Cache' u cherbet? ¿Cache'da u jäbbet a jut? ");
INSERT INTO chfNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Une u p'ali: ―San cälbetla, y mach a ubila. ¿Cua' uc'a a wo a ubinla tä cha'num? ¿A wola quira täcä xiquet de u yajcänt'an? ");
INSERT INTO chfNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Unejob u q'uejpijob, u yälbenob ca'da: ―Aneba u yajcänt'anet. No'on t'ocobba ajcänt'anon t'ocob taj Moisés. ");
INSERT INTO chfNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Cuwi chich t'ocob cache' Dios u pequi aj Moisés. Jindaba, mach cuwi t'ocob cada ti. ");
INSERT INTO chfNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","U p'ali jini winic, u yälbijob: ―Mach bay u yubca ca' jini, a wäle'la cache' mach a wila cada ti, y une u jäbbon cä jut. ");
INSERT INTO chfNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cuwila cache' Dios mach u yubi u c'änti'ya ajcherajtanäjob. Machca u tz'omben Dios, machca u chen ca' chich yo Diosba, jin une u yubin u c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mach bay ubqui pancab ajnic machca u jäbben u jut machca päncäbi ajchoc'. ");
INSERT INTO chfNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Si jini winic mach ajnic ica t'oc Dios, mach u ch'ä u chen ica niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Unejob u yälbi: ―Ane päncäbet t'oc a noj q'uenel tanä, ¿y a ye'benon t'ocob u t'an Dios? De ya'i u pa'sijob tan noj ch'u'ul otot. ");
INSERT INTO chfNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jinq'uin aj Jesús u yubi cache' pa'sinti, bixi u nuc'tan, u yälbi ca'da: ―¿A tz'omben ane u Yajlo' Dios? ");
INSERT INTO chfNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Une u p'ali: ―¿Caxcone, noxi' winic, uc'a cä tz'onän? ");
INSERT INTO chfNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aj Jesús u yälbi: ―A chäni chich y une chich mu' u t'an t'oc ane. ");
INSERT INTO chfNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Une u yäle': ―Cä tz'onän chich, Cajnoja. Y u ch'u'ul c'ajti'i. ");
INSERT INTO chfNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aj Jesús u yäli: ―No'on aton pancab cäle' catac an tu toja, catac mach'an tu toja, uc'a machcatac mach u che chanäba u chen chanä, y machcatac u chen chanä sutwänic ca' ajchoc'. ");
INSERT INTO chfNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jinq'uin u yubi jinda, aj fariseojob ni ya'an t'ocba u tulaj älijob: ―¿Ajchoc'on quira t'ocob täcä? ");
INSERT INTO chfNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aj Jesús u yälbijob: ―Si fuera ajchoq'uetla icaba, mach ica an a tanäla. Bada uc'a a wäle'la a chen chanäla, jin uc'a ya'to an a tanäla. ");
INSERT INTO chfNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Totojtoj cälbenetla, machca mach uyoch tu ti' bojte' tuba oveja ajxuch' une. U yoche bajca mach'an u ti' bojte' tuba u ch'e' ni mach jin tubaba. ");
INSERT INTO chfNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Machca u yoche tu ti' bojte'ba, ajcänän oveja une. ");
INSERT INTO chfNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ajcänän ti' bojte' u jäbben tuba ochic ni ajcänän oveja. Ovejajob u yubin u t'an ni ajcänän oveja. U joq'ue' tu c'aba' u ovejajob tuba u pa'sen. ");
INSERT INTO chfNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cuanta u laj pa'si ni tubaba, une u nume pänte', y oveja u bixejob tu pat uc'a u cherben conoce u t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Päpä' winicba mach ubixob ni oveja tu pat; u putz'tan une uc'a mach u cherbe conoce u t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jinda tz'aji aj Jesús u cherbijob. Unejob mach u chi entendejob cua' uc'a u yälbijob ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aj Jesús u yälbijob tä cha'num: ―Totojtoj cälbenetla: Machcatac u tz'ombenonba ca' a wälä ovejajob une, y no'onba ca' a wälä u ti'on ni bojte' bajca u yoche ni oveja. ");
INSERT INTO chfNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Upete machcatac juli najtäcä que no'on ajxuch' une, u ch'e' ni mach jin tubaba. Ovejajob mach u yubijob u t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","No'on u ti'on ni bojte'; machca u yoche t'oc no'on, u xe tä japinte; u yoche, u pase, y u pojlen cua' u c'uxe'. ");
INSERT INTO chfNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ajxuch' u te chich tä xuch', tä tzämsa, tuba u tzupsen cua'tac ayan. No'onba aton tuba cä'ben cuxlecob machcatac u tz'ombenon, y c'alin cuxlecob. ");
INSERT INTO chfNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","No'on une ni ajcänän ovejajon utzba; ni ajcänänya utzba u yäq'ue' uba tä chämo uc'a u japän u ovejajob. ");
INSERT INTO chfNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jini winic u tojcanba mach jin mero ajcänän oveja. Jinq'uin u chänen que ya' u te ajlobo tu pat oveja, une u yäctan oveja u pase tä putz'e, uc'a mach jin mero u yum oveja. Ajlobo u nume u q'ueche' oveja, y oveja u puclan ubajob. ");
INSERT INTO chfNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jini winic u tojcanba u putz'e, uc'a ajgana une, mach u cänänta utz jini oveja. ");
INSERT INTO chfNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’No'on ni ajcänän ovejajon utzba, cä chen conoce cä ovejajob, unejob täcä u chenon conoce. ");
INSERT INTO chfNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ca' chich u chenon conoce cä Pap, che' chich täcä no'on cä chen conoce cä Pap. Cäq'ue' cäba tä chämo uc'a cä japän ni ovejajob. ");
INSERT INTO chfNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Cä cänäntan täcä otro ovejajob que mach'an tama jinda bojte'. Unejob täcä c'änä chich cä täsen. U xe u yubinob cä t'an; u xe tä ajtäjob tomp'e t'oc untu machca u cänäntanob. ");
INSERT INTO chfNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Jin uc'a u yajna'tanon cä Pap, uc'a no'on acäq'ue' cäba tä chämo tuba sutwänicon tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Niuntu mach u tzämson, no'on chich cäq'ue' cäba tä chämo. An cä poder cäq'ue' cäba tä chämo, an cä poder ta cuxpacon tä cha'num. Jin chich u yäc'bon cä Pap cä chen. ");
INSERT INTO chfNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sutwäni cha'num u jec'lan ubajob aj judíosob uc'a ni t'anda que u yäliba. ");
INSERT INTO chfNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Q'uen u yäle'ob: ―Tzuc pixan ya'an tuyac'o; ajsinc'ajalin une. ¿Cua' tuba cubinla u t'an? ");
INSERT INTO chfNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","U tulaj äle'ob: ―Jinda t'an mach u yälä machca u cänäntan tzuc pixan tuyac'o. ¿U ch'e' quira tzuc pixan u jäbben u jut ajchoc'? ");
INSERT INTO chfNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jinq'uin ajni q'uin ch'uje tä Jerusalén tuba c'ajti'cac cache' ch'u'ul cherqui noj ch'u'ul otot, tu q'uini sisi une. ");
INSERT INTO chfNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jinq'uinba, aj Jesús u nume tan noj ch'u'ul otot tä corredor taj Salomón. ");
INSERT INTO chfNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aj judíosob u woyi ubajob bajca an, u yälbijob ca'da: ―¿Ca jun q'uin a wäctan a jobän cä c'ajalin t'ocob? Si ane aj Cristojet, älbenon t'ocob tu toja. ");
INSERT INTO chfNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aj Jesús u yälbijob: ―Acälbetla chich, pero anela mach a tz'onäla. Ni patan cä chenba cä Pap u yäc'bon cä chen une, y jinda u ye'e' tu toja machcajon. ");
INSERT INTO chfNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Anela mach a tz'onäla uc'a mach jin cä ovejajetla, ca' chich cälbetlaba. ");
INSERT INTO chfNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Cä ovejajob u yubinob cä t'an, no'on cä chen conocejob täcä, y unejob u bixejob täc pat. ");
INSERT INTO chfNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","No'on cä'ben paq'uin cuxlecob; mach uni' xin tä sätojob, y niuntu mach uxin u pa'senob täj c'äb täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Cä Pap ni u yäc'bonba, une más ajnoja que upete; niuntu mach u ch'ä u pa'senob tu c'äb cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","No'on t'oc cä Pap tontulon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","De ya'i u ch'ijob cha'num ji'tun aj judíosob tuba u jule'ob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Aj Jesús u yälbijob: ―Q'uen cä patan utzba acä ye'betla, u patan cä Pap une. ¿Caxcamba de ni patanda utzba que cä chi, y jin uc'a a wo a jule'onla t'oc ji'tun? ");
INSERT INTO chfNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aj judíosob u p'ali: ―Mach uc'a a patan utz acä jule'et t'ocob t'oc ji'tun, sec' uc'a a tzuc t'an. Ane winiquet, y a chen aba cache' Dioset. ");
INSERT INTO chfNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aj Jesús u p'albijob: ―¿Mach quira a wila cache' ya' tz'ibi tama ni ley ta'ala ca'da: “Cäli cache' diosetla”? ");
INSERT INTO chfNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","U yälbijob cache' diosob machcatac binti u t'an Dios, y ni tz'ibiba mach u ch'ä älcac cache' mach toj. ");
INSERT INTO chfNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Cä Pap u yäc'bon ch'u'ul ajnicon u täscon pancab. ¿A wäle'la quira cache' tzuc t'an cä chen uc'a no'on cäli cache' u Yajlo' Dioson? ");
INSERT INTO chfNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si mach jin u patan cä Pap cä chenba, mach a tz'ombenonla. ");
INSERT INTO chfNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Si u patan cä Pap cä chenba, y no'on mach a tz'ombonla, tz'onänla jini patan, uc'a a wina'tanla y a tz'onänla cache' cä Pap ya'an t'oc no'on, y no'on t'oc cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","U sacänob tä cha'num cache' u q'ueche', pero une pasi bajca anob. ");
INSERT INTO chfNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Bixi tä cha'num tunxe río Jordán bajca u chi c'ablesia aj Juan najtäcä; ya' coli ya'i. ");
INSERT INTO chfNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Q'uen c'otijob bajca an, u yäle'ob: ―Aj Juan niump'e cua' mach u chi tuba u ye'e' u poder, pero upete cua' u yäli aj Juan de jini winicdaba, toj une. ");
INSERT INTO chfNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Q'uen machcatac u tz'ombijob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ajni untu winic c'ojo, u c'aba' aj Lázaro. Tä Betania u cäji. Ya'an t'oc u cha'tuma u chich, ix María y ix Marta. ");
INSERT INTO chfNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ni ix Maríada c'ojo jitz'inba, jin une u tatz'i Ajnoja t'oc jätz'äcnib, y u sucbi yoc t'oc u tzuc. ");
INSERT INTO chfNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ni u chichob aj Lázaroba u täsqui tä älbintejob aj Jesús: ―Cajnoja, ubixto, jini a yajna'tanba c'ojo ayan une. ");
INSERT INTO chfNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jinq'uin u yubi aj Jesús, u yäli ca'da: ―Jinda yaj mach tuba u tzämsen; ni yajdaba tuba chäncac u pitzil patan Dios, y uc'a chänintic täcä cua' u xe u chen u Yajlo' Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Aj Jesús u yajna'tan ix Marta, y u jitz'in ix María, y aj Lázaro. ");
INSERT INTO chfNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jinq'uin u yubi cache' c'ojo, coli to chap'e q'uin bajca ayan. ");
INSERT INTO chfNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ji'pat u yälbi u yajcänt'anob: ―Cola tä Judea tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","U yajcänt'anob u yälbi: ―Maestro, mach to nat' q'uin aj judíosob u yäli u tzämsenetob t'oc ji'tun, ¿y a xe cha'num ya'i? ");
INSERT INTO chfNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aj Jesús u p'ali: ―¿Mach quira u cänänta doce hora ni q'uin? Machca u nume tä q'uin, mach u päcteq'ue cua', uc'a u chänen ni junch'äcni tuba jinda u pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Machca u nume ac'äb u päcyälo uc'a mach'an junch'äcni bajca an une. ");
INSERT INTO chfNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cuanta u yäli ca'da, u yälbijob tä cha'num: ―Cä lotla aj Lázaro mu' u wäye; acä xe cä p'isan bajca an tä wäye. ");
INSERT INTO chfNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","De ya'i u yajcänt'anob u yälbi: ―Cajnoja, si wäye u chen u xe u pojlen uba. ");
INSERT INTO chfNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ni u yäli aj Jesúsba, cache' achämi chich; unejobba u yäli tan u c'ajalin cache' ni u yäliba mu' u totoj ch'e' uba tä wäye. ");
INSERT INTO chfNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","De ya'i aj Jesús u chectesbijob: ―Aj Lázaro achämi une. ");
INSERT INTO chfNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ch'a'a cäjin mach anon ya'i achämi, uc'a ca' jini ajnic cache' a tz'onänla más. Bada cola bajca an. ");
INSERT INTO chfNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jinq'uin aj Tomás, jini u yälbinte ajwacu'ba, u yälbi u lotob: ―Cola täcä uc'a chämiconla nämte' t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jinq'uin c'oti aj Jesús, u yubi cache' u cänäntan chämp'e q'uin u mujcan aj Lázaro. ");
INSERT INTO chfNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania nätz'ä t'oc Jerusalén, ca' tuba uxp'e kilómetros u nät'an. ");
INSERT INTO chfNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Q'uen aj judíosob c'otijob bajca an ix Marta y ix María u ch'a'alesbenob ujin uc'a chämi jitz'in. ");
INSERT INTO chfNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jinq'uin ix Marta u yubi cache' ya' u te aj Jesús, pasi u nuc'tan. Ix Maríaba coli tä chumtä tan otot. ");
INSERT INTO chfNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ix Marta u yälbi aj Jesús: ―Cajnoja, si ajniquet ica wida, mach ica chämi quitz'in. ");
INSERT INTO chfNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Cuwi chich täcä bada upete cua' a c'atben Dios, Dios chich u yäc'benet. ");
INSERT INTO chfNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aj Jesús u yälbi: ―U xe tä cuxpan a witz'in. ");
INSERT INTO chfNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ix Marta u yälbi: ―Cuwi chich cache' u xe tä cuxpan tu cuxpan upete tu xupiba q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aj Jesús u yälbi: ―No'on ni ajcuxpesialon, no'on cäq'ue' cuxlec untu. Machca u tz'ombenon, si chämic u sujtä tä cuxpan. ");
INSERT INTO chfNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Upete machca cuxu y u tz'ombenon mach bay uxin tä chämo. ¿A tz'onän jinda? ");
INSERT INTO chfNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Une u yälbi: ―Cajnoja, acä tz'onän chich cache' ane aj Cristojet, u Yajlo' Dioset atet pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jinq'uin u yäli jinda, bixi u joq'ue' mucu jitz'in ix María u yälben: ―Cä Maestrola ya'anda, u joq'ue'et. ");
INSERT INTO chfNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jinq'uin u yubi ix María, seb ch'oyi bixi bajca an aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Aj Jesús mach to yoch tan caj, ya'to an bajca u nuc'ti ix Marta. ");
INSERT INTO chfNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ni aj judíosob ya'an tan otot t'oc uneba u ch'a'alesbenob ujinba, jinq'uin u chäni cache' seb ch'oyi ix María bixi, bixijob tu pat uc'a u yäle'ob cache' ya' u xe bajca mujqui u yuc'tan ya'i. ");
INSERT INTO chfNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jinq'uin ix María c'oti bajca an aj Jesús, nocwäni tu yoc, u yälbi: ―Cajnoja, si ajniquet ica wida, mach ica chämi quitz'in. ");
INSERT INTO chfNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jinq'uin aj Jesús u chäni cache' mu' u yuq'ue, y aj judíosob c'oti t'oc täcäba tä uq'uejob täcä, ch'ocomi u pixan, y triste'i. ");
INSERT INTO chfNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","U c'ati: ―¿Cada a wäq'uila? Unejob u yälben: ―Cajnoja, la'ix chänen. ");
INSERT INTO chfNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jinq'uin u chäni aj Jesús, u chi uq'ue. ");
INSERT INTO chfNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","De ya'i aj judíosob u yälijob: ―Chänen cache' tä' u yajna'tan. ");
INSERT INTO chfNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","U tulaj älijob: ―Ni winicda u jäbbi u jut ajchoc'ba, ¿mach wäreca u ch'ä u yäq'ue' que mach chämic aj Lázaro? ");
INSERT INTO chfNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aj Jesús ch'ocomi u pixan tä cha'num, c'oti bajca mucu aj Lázaro. Bajca mucuba, ump'e ch'en une tu näc' tz'ic t'oc ump'e ji'tun tu ti'. ");
INSERT INTO chfNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aj Jesús u yäli: ―Pa'senla ni ji'tun. Ix Marta, u chich najchämeba, u yälben: ―Cajnoja, u chi uba yutz'u, u cänäntan chämp'e q'uin u chämo. ");
INSERT INTO chfNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aj Jesús u yälbi: ―¿Mach quira cälbet, si a tz'onän a xe a chänen u poder Dios? ");
INSERT INTO chfNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","De ya'i u pa'sijob ni ji'tun bajca äc'qui ajchäme. Aj Jesús u t'äbsi u jut isqui y u yäli: ―Cä Pap, cälbenet uc'adios uc'a a ubi cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Cuwi chich cache' a paq'uin ubin cä t'an; pero uc'a ni noj q'uenel gente ya'andaba, jin uc'a cäli ca' jini, tuba u tz'onänob cache' ane a täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cuanta u yäli jinda, u yäli t'oc noj t'an: ―¡Lázaro, pasen ya'i bajca anet! ");
INSERT INTO chfNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Machca ajni chämenba pasi, tz'otojtac u c'äb, yoc, t'oc noc'; t'unu u jut t'oc ump'e noc'. Aj Jesús u yälbijob: ―P'ämbenla, äctan bixic. ");
INSERT INTO chfNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jinq'uin q'uen aj judíosob ni ajnijob bajca an ix Maríaba u chänijob cua' u chi aj Jesús, u tz'ombijob. ");
INSERT INTO chfNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tulaj bixijob bajca an aj fariseojob tuba u yälbenob cua' u chi aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ajnojajob ta palejob y aj fariseojob u woyi ubajob tomp'e t'oc ajt'äbäla a'äc'c'ajalinob. U yälijob ca'da: ―¿Cache' cä xe cä chenla? Uc'a jinda winic q'uen cua' u chen tuba u ye'e' u poder. ");
INSERT INTO chfNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si cäctanla ca'da, upete u xe u tz'omben. U xe tä te aj romanojob u jajbenonla cä ch'u'ul ototla y cä cäjila. ");
INSERT INTO chfNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aj Caifás, untu no' ajnoja pale tuba jini año, u yälbijob ca'da: ―Mach a wila cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mach uta ta' c'ajalinla cache' c'änä chämic untu winic uc'a caj, y mach sätic upete. ");
INSERT INTO chfNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jinda u yäli mach uc'a une u pa'si tu c'ajalin. Uneba no' ajnoja pale tuba jini año, jin uc'a Dios u worin äc'bi u yäle' cache' aj Jesús u xe tä chämo uc'a caj. ");
INSERT INTO chfNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y mach sec' uc'a jini caj u xe tä chämo, uc'a täcä woycac tomp'e u ch'ocob Dios bajcatac ayanob. ");
INSERT INTO chfNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","De ya'i jinchichba q'uin u täq'ui u maläc ch'e' u c'ajalinob cache' u xe u tzämsenob. ");
INSERT INTO chfNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jin uc'a aj Jesús mach uni' num tu jut aj judíosob. Pasi ya'i bixi bajca an jini cab nätz'ä bajca mach cuxu niuntu, bajca an jini caj u c'aba' Efraín. Ya'i coli t'oc u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Anatz'äli noj paxcu' taj judíosob. Q'uen pasijob tä cabil cab bixijob tä Jerusalén antes de tä'cac jini q'uin ch'uje ta paxcu', uc'a c'änä u chenob jini u yäle' noxibilba uticba tuba ajnicob tu toja. ");
INSERT INTO chfNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Cayi u sacänob aj Jesús. U maläc äle'ob machcatac ya'an tan noj ch'u'ul otot: ―¿Cache' a wäle'la, mach wäreca uta wida tä q'uin ch'uje? ");
INSERT INTO chfNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ajnojajob ta palejob y aj fariseojob u yälijob si machca chichca yuwi caxcada ayan, u yäle', uc'a xic tä q'uechcan. ");
INSERT INTO chfNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yo to seis día tuba c'otic u q'uini paxcu', c'oti aj Jesús tä Betania. Ya' jini u cäji aj Lázaro ni chämiba, jini que cuxpi tan ajchämeba. ");
INSERT INTO chfNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ya'i cherbinti cua' u c'uxe'. Ix Marta u tuse' ni cua' tä c'uxcan. Aj Lázaro täcä chunwäni nämte' t'oc aj Jesús tä mesa. ");
INSERT INTO chfNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","De ya'i ix María u ch'i unxot' botella de jätz'äcnib u c'aba' nardo, tä' choj u valor. U numsäbi tu yoc aj Jesús, u sucbi yoc t'oc u tzuc. De ya'i u laj puqui uba u yutz'u ni jätz'äcnib tan otot. ");
INSERT INTO chfNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aj Judas, u yajlo' aj Simón Iscariote, untu u yajcänt'an aj Jesús, jini u xe u yäq'ue' tä c'äbäba, u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Cua' uc'a mach achonqui jini jätz'äcnib por tres cientos taq'uin tuba pucbintic pobrejilba ni taq'uin? ");
INSERT INTO chfNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ni u yäliba, mach uc'a u ch'ämben yajin pobrejilba, u yäli uc'a ajxuch' une; une u cänäntan ni ch'uji' taq'uin, y u xuch'än jini taq'uin que u yä'can tamaba. ");
INSERT INTO chfNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aj Jesús u yäli: ―Mach a jaq'uesben ujin ni ixic. Uneba u worin chi ni jini tuba jinq'uin cä xe tä mujcan. ");
INSERT INTO chfNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pobrejilba ya' chich paq'uin an t'oc anela, pero no'onba mach paq'uin anon t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Q'uen aj judíosob u yubi cache' ya'an ya'i; c'otijob mach sec' uc'a u chänenob aj Jesús, uc'a täcä u chänenob aj Lázaro, jini u cuxpesi tan ajchämejobba. ");
INSERT INTO chfNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ajnoja palejob u ch'ijob u c'ajalin tuba u tzämsenob täcä aj Lázaro, ");
INSERT INTO chfNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","uc'a q'uen aj judíosob u tz'eji ubajob t'oc u lot tuba u tz'omben aj Jesús, uc'a cuxpi aj Lázaro. ");
INSERT INTO chfNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Päscab ni noj q'uenel gente que c'otijob tä q'uin ch'ujeba, jinq'uin u yubijob cache' aj Jesús ya' u te tä Jerusalén, ");
INSERT INTO chfNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","u ch'ijob c'äb xan, bixijob u nuc'tan. T'oc noj t'an u yäle'ob: ―¡Hosanna! ¡Ch'u'ul c'ajti'cac jini u te tu c'aba' Cajnojala Dios, jini Ajnoja taj Israelobba! ");
INSERT INTO chfNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Aj Jesús u pojli untu yoc p'i' tzimim. U chumti, uc'a che' chich u yäle' ni jun ta Dios tz'ibiba: ");
INSERT INTO chfNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mach bäc'taquetla, anela tä Sión; chänen, a Wajnojala u te chumu tu pat untu p'i' tzimim. ");
INSERT INTO chfNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jinda mach u se'in chi entendejob u yajcänt'anob. Jinq'uin cuxpi aj Jesús, jinq'uinba ti tu c'ajalinob cache' jinda ya' chich tz'ibi tan u jun Dios que u xe tä cherbinte. ");
INSERT INTO chfNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jini gente que ajni jinq'uin jo'qui aj Lázaro bajca ajni tan ch'en y cuxpesqui tan ajchämejobba, unejob u yälijob tu toja cache' u chi aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jin uc'a noj q'uenel gente bixi u nuc'tan, uc'a u yubijob cache' u chi jinda tuba u ye'e' u poder. ");
INSERT INTO chfNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aj fariseojob u maläc älijob: ―¿A chänila cache' mach a chela cua'? Iranba, upete u bixejob tu pat. ");
INSERT INTO chfNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tulaj c'otijob täcä aj griego tuba u ch'u'ul c'ajti'in Dios tama jini q'uin ch'uje. ");
INSERT INTO chfNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jinijob c'oti bajca an aj Felipe, jini aj Felipe u cab tä Betsaida tama noj cab tä Galileaba. U c'atänob: ―Noxi' winic, tä' co cä chänen t'ocob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Bixi aj Felipe u yälben aj Andrés. Aj Andrés t'oc aj Felipe u yälbenob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aj Jesús u yälbijob: ―Ac'oti q'uin ta ch'u'ul c'ajti'cacon, no'on que sutwänon de winic. ");
INSERT INTO chfNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Totojtoj cälbenetla, si unxim trigo mach pä'cac tä cab tuba la'mac u bec'ta, u colan u juntuma. Si la'macba y wetic jini u cha', u yäq'ue' q'uen u jut. ");
INSERT INTO chfNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Machca tä' yoba cuxlec utz pancab u xe tä säto. Machca mach u yajna'ta cuxlec tuyac'o jinda u pancabba, u xe tä ajtä paq'uin cuxu. ");
INSERT INTO chfNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Machca yo xic tuba cajpatan, tic täc pat. Bajca cä xe tä ajtä, ya' chich u xe tä ajtä cajpatan täcä. Cä Papla Dios u xe u yäle' cache' utz cua' u chen jini cajpatan. ");
INSERT INTO chfNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Bada u ch'ocoman cä pixan. ¿Cache' cä xe cäle'? ¿Cä xe quira cälben cä Pap ca'da: “Cä Pap, japänon t'oc jini u te täjcac'o jimba horada”? Mach uxon cälben ca' jini, uc'a jin chich tuba aton jimba horada. ");
INSERT INTO chfNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Cä Pap, äc'ä tä ch'u'ul c'ajti'can a c'aba'. De ya'i ubqui ump'e t'an tä cielo, u yäle' ca'da: ―No'on chich acäq'ui tä ch'u'ul c'ajti'can cä c'aba', y acä xe cäq'ue' tä ch'u'ul c'ajti'can tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ni noj q'uenel gente que u yubijobba u yälijob cache' chawäc. Otrosjob u tulaj älijob cache' ángelo ta Dios u pequi. ");
INSERT INTO chfNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aj Jesús u yäli: ―A'uti ni t'an jini tuba a ubinla ane, mach uc'a c'änä cubin no'onba. ");
INSERT INTO chfNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bada u xe tä chectan jini u chenob a'ajtä pancab que mach utzba, bada ni ajnoja tuba jinda u pancab u xe tä pa'sinte. ");
INSERT INTO chfNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Si no'on äc'cacon tä cruz q'uen u xe u tz'ombenonjob. ");
INSERT INTO chfNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jinda u yäli uc'a u yäle' cache'da u xe tä chämo. ");
INSERT INTO chfNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","U p'albijob ni gente: ―Acubi t'ocob cache' u yäle' ni ley cache' aj Cristo paq'uin ayan. ¿Cuaxca uc'a a wäle' aneba cache' jini sujli de winicba c'änä äc'cac tä cruz? ¿Caxcone jini sujli de winicba? ");
INSERT INTO chfNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aj Jesús u yälbijob: ―Acoli tz'ita' q'uin tuba ajnicon t'oc anela de junch'äcni. Numenla t'oc no'on ni junch'äcnilon ya'toca anon t'oc anela, uc'a mach u q'ueche'etla it'obni. Uc'a machca u nume tan it'obni mach yuwi cada u xe. ");
INSERT INTO chfNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ya'toca anon t'oc anela de junch'äcni, tz'ombenonla uc'a ajniquetla de cä ch'ocob. Jintacda u yäli aj Jesús, pasi bajca anob, u muquí uba. ");
INSERT INTO chfNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Q'uen cua'tac u chi tu jutob tuba u ye'e' u poder. Unejob mach u tz'onijob. ");
INSERT INTO chfNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ca' jini pasi toj ca' chich u worin äli aj Isaías, ajt'an ta Diosba: Cajnoja, niuntu mach u tz'oni cä t'anla. Mach uta tu c'ajalinob cache' an a poder. ");
INSERT INTO chfNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jin uc'a mach u ch'ä u tz'onänob, uc'a aj Isaías chich u yäli täcä ca'da: ");
INSERT INTO chfNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios u mäcbi u jutob, u tzätz'esbi u pixanob uc'a mach u chen chanä t'oc u jutob y uc'a mach u sapän tu pixanob y uc'a mach u q'uexe' u c'ajalinob tuba japintic. ");
INSERT INTO chfNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jinda u yäli aj Isaías jinq'uin u chämbi u pitzilan Cajnojala y u yäli cache' an une. ");
INSERT INTO chfNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero q'uen ajnojajob chich u tz'ombijob aj Jesús. Mach yo u yäle'ob uc'a bäc'ta t'oc aj fariseojob, uc'a mach xic tä pa'sintejob tan ch'u'ul otot. ");
INSERT INTO chfNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Uc'a más u yoli que u lotob u yäle' cache' tä' pitzi cua' u chenob, y mach u che t'oc unejob si Dios u yäle' cache' pitzi cua' u chenob. ");
INSERT INTO chfNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Aj Jesús u chi noj t'an u yäli: ―Machca u tz'ombenon, mach sec' no'on u tz'ombenon, u tz'omben täcä machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Machca u chänenon, u chänen machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tuba ajnicon de junch'äcni, jin uc'a aton pancab, uc'a upete machcatac u tz'ombenon mach colac tan it'obni. ");
INSERT INTO chfNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Machca u yubin cä t'an y mach u tz'onä, no'onba mach cä'be u toje' u tanä, uc'a mach aton cä'ben u toje' u tanä a'ajtäjob pancab, aton cä japän a'ajtäjob pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Machca u quitz'e' uba t'oc no'on y mach u sapä cä t'an, ya'an machca u yäc'ben u toje' u tanä. Ni t'an cäliba, jinda u xe u yäc'ben u toje' u tanä tu xupiba q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ni t'anda cäliba mach no'on cä pa'si täj c'ajalin. Cä Pap ni u täsconba, une u yäc'bon cua' cäle' y cache'da cä xe cäle'. ");
INSERT INTO chfNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Cuwi chich cache' u t'an uneba u yäq'ue' paq'uin cuxlequetla. Jin uc'a jini t'an acäle'ba, ca' chich u yälbon cä Pap, che' chich acäle'. ");
INSERT INTO chfNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mach to c'ot q'uin ch'uje ta paxcu', aj Jesús yuwi chich cache' ac'oti q'uin pasic une pancab, bixic ca'an u Pap; u yajna'ti ni tubajobba ni ya'anob pancabba, y mäx u yajna'tan ixta tu xupiba q'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jinq'uin ya'anob tä c'uxnan, ni diabloba san chich u yäc'bi u c'ajalin aj Judas u yajlo' aj Simón Iscariote tuba u yäq'ue' tä c'äbä aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aj Jesús yuwi cache' u Pap u yäc'bi upete tu c'äb y yuwi täcä cache' une pasi ca'an Dios, y ya' chich u sujtä ca'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ch'oyi bajca an tä c'uxnan, u pochi u buc, u ch'i ump'e noc' u cächi tu näc'. ");
INSERT INTO chfNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","De ya'i u yäq'ui ja' tama ump'e c'ämbita, u täq'ui u pocben yoc u yajcänt'anob u sucbenob t'oc ni noc' ya' cächä tu näc'ba. ");
INSERT INTO chfNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","C'oti bajca an aj Simón Pedro. Aj Simón Pedro u yälben ca'da: ―Cajnoja, ¿ane quira a pocbenon coc? ");
INSERT INTO chfNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aj Jesús u yälbi: ―Jini cä chen no'onba, mach a wi une bada. Ji'pat to a xe a wina'tan. ");
INSERT INTO chfNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aj Pedro u yälbi: ―No'on mach bay uxet a pocbenon coc. Aj Jesús u p'ali: ―Si mach a wäcta cä pocbenet a woc, mach anet t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aj Simón Pedro u yälbi: ―Cajnoja, mach seq'uen coc, cä c'äb y cä pam täcä co a pocbenon. ");
INSERT INTO chfNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aj Jesús u yälbi: ―Machca múqui, mach ni' c'änä muquic, sec' u poque' yoc, poco an entero untu. Anelaba poco anetla, pero mach apetela. ");
INSERT INTO chfNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Uc'a une yuwi caxcone u xe u yäq'ue' tä c'äbä. Jin uc'a u yäli: “Mach poco anetla apetela”. ");
INSERT INTO chfNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Cuanta u pocbijob yoc, u xoji u buc, chunwäni tä cha'num tä mesa, u yälbijob: ―¿A wila cua' acä cherbetla? ");
INSERT INTO chfNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Anela a wälbenonla cache' Maestrojon y Ajnojalon. Utz chich cua' a wäle'la, uc'a jinon chich. ");
INSERT INTO chfNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Si no'on a Maestrojon y a Wajnojalon acä pocbet a wocla, che' chich c'änä a chenla täcä, a maläc poque' a wocla. ");
INSERT INTO chfNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jin uc'a cä ye'betla ca' jini, uc'a ca' chich acä cherbetla, che' chich a chenla täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Totojtoj cälbenetla, ajpatan mach jin más ajnoja que u yum; ajtäsquinte mach jin más ajnoja que machca u täsqui. ");
INSERT INTO chfNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ya'an ch'a'aljin ta'ala si a wila jinda y si a chenla. ");
INSERT INTO chfNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mach cälä jinda tuba apetela. No'on cuwi machcatac acä yaqui. C'änä pasic toj ca' chich tz'ibi tä jun ni u yäle' ca'daba: “Machca u mul c'uxe' waj t'oc no'on ca' a wälä u t'äbsi u tun'oc u juli täjcac'o”. ");
INSERT INTO chfNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Bada cä worin älbenetla cua' u xe u chen pasa, uc'a jinq'uin u xe u chen pasa, a tz'onänla cache' no'on chich ni aj Cristojon. ");
INSERT INTO chfNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Totojtoj cälbenetla, machca u sapän ni cä täscunba, no'on une ni u sapänon, y machca no'on u sapänon u sapän täcä machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jinq'uin aj Jesús u yäli ca'da, ch'ocomi u pixan, u yäli: ―Totojtoj cälbenetla, untu de anelaba a xe a wäq'ue'on tä c'äbä. ");
INSERT INTO chfNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","De ya'i u yajcänt'anob u maläc chänen u jutob, uc'a mach yuwijob caxcone u yälbinte. ");
INSERT INTO chfNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Untu u yajcänt'an aj Jesús ni tä' u yajna'tanba ya' t'ele an tu ch'ejpa aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Aj Simón Pedro u cherbi u c'äb najcänt'an ya'an tu ch'ejpa aj Jesúsba tuba u c'atben aj Jesús caxca une ni mu' u yälben. ");
INSERT INTO chfNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jinq'uin ni ya' t'ele tu ch'ejpaba u c'atbi ca'da: ―Cajnoja, ¿caxca une? ");
INSERT INTO chfNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aj Jesús u p'ali: ―Jin une, machca cä xe cä'ben maja' waj. De ya'i u maji waj, u yäc'bi aj Judas ajlo' taj Simón Iscariote. ");
INSERT INTO chfNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Cuanta u c'uxi jini waj, ochi aj Satanás tuyac'o. Jinq'uin aj Jesús u yälbi: ―Ni a xe a chenba, seb a nonoj chen. ");
INSERT INTO chfNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Niuntu ni ya'an tä mesaba mach yuwijob cua' uc'a u yälbi ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","U tulaj äli tu c'ajalinob cache' aj Jesús u yälbi que u mäne' cuaxca c'änä ta q'uin ch'uje o u yäc'ben cua' chichca pobrejilba, uc'a une u cänäntan ni ch'uji' taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cuanta u c'uxi jini waj, seb bixi; ac'äb une. ");
INSERT INTO chfNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jinq'uin bixiba, aj Jesús u yäli: ―Bada u xe tä chäninte cä poder, no'on que sutwänon de winic, y u xe tä chäninte u poder Dios täjcac'o. ");
INSERT INTO chfNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si u chäninte u poder Dios täjcac'oba, Dios chich täcä u xe u yäq'ue' tä chäninte jini poder que cä cänäntanba, y seb u xe u yäq'ue' tä chäninte jini poder. ");
INSERT INTO chfNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cä bij ch'oc, acolobi tz'ita' q'uin tuba ajnicon t'oc anela. A xe a sacänonla. Ca' chich cälbi aj judíosob: Bajca cä xe no'onba, anela mach u ch'ä xiquetla. Che' chich acälbenetla täcä bada. ");
INSERT INTO chfNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ump'e tzib manda acä'benetla, a maläc yajna'tan abala, ca' chich acä yajna'tetla, che' chich anela täcä a maläc yajna'tan abala. ");
INSERT INTO chfNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ca' jini u xe u wina'tan upete cache' cajcänt'anetla, si a maläc yajna'tan abala. ");
INSERT INTO chfNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Aj Simón Pedro u yälbi: ―Cajnoja, ¿cada a xe? Aj Jesús u p'albi: ―Bajca cä xe no'on, mach u ch'ä xiquet bada täc pat; ji'pat to a xe a tzäypätinon. ");
INSERT INTO chfNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Aj Simón Pedro u yälbi: ―Cajnoja, ¿cuaxca uc'a mach u ch'ä cä tzäypätinet bada? Ixta cäq'ue' cäba tä chämo uc'a ane. ");
INSERT INTO chfNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aj Jesús u p'albi: ―¿A wäq'ue' aba tä chämo uc'a no'on? Totojtoj cälbenet, mach to u che uq'ue ajtze, a xe a wäle' uxpetz' cache' no'on mach a chon conoce. ");
INSERT INTO chfNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Mach ch'ocomac a pixanla. Tz'ombenla Dios, y tz'ombenonla täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tan yotot cä Pap q'uen cuxliba ayan. Si mach ica ajnic, mach ica cälbetla. Acä xe cä tuse' bajca a xe tä ajtäla. ");
INSERT INTO chfNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Si bixicon cä tuse' bajca a xe tä ajtäla, no'on chich acä sujtä tä cha'num cä ch'e'etla, uc'a ajniquetla täcä bajca anon. ");
INSERT INTO chfNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A wila chich cada cä xe, a wila chich bij. ");
INSERT INTO chfNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aj Tomás u yälbi: ―Cajnoja, mach cuwi t'ocob cada a xe. ¿Cache' cä xe cuwina'tan t'ocob ni bij? ");
INSERT INTO chfNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aj Jesús u yälbi: ―No'on ni bijon, no'on u tojalon, no'on une cäq'ue' cuxlequetla. Niuntu mach uta ca'an cä Pap si mach uc'a no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si no'on ica a chon conocela, a chi conocela ica täcä cä Pap. Pero bada a chen chich conocela y a chänila chich. ");
INSERT INTO chfNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aj Felipe u yälbi: ―Cajnoja, ye'benon t'ocob ni cä Papla, y an t'oc. ");
INSERT INTO chfNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aj Jesús u yälbi: ―Abon jäläcnon t'oc anela, ¿y mach quira a chon conoce, Felipe? Machca no'on u chänon, cä Pap täcä u chäni. ¿Cua' uc'a a wäle' aneba: “Ye'benon t'ocob cä Papla”? ");
INSERT INTO chfNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mach quira a tz'onä cache' no'on anon t'oc cä Pap, y cä Pap t'oc no'on? Jini t'an ni cälbenetlaba, mach no'on acä pa'si täj c'ajalin. Cä Pap ya'an t'oc no'onba, une u chen upete cua' chichca. ");
INSERT INTO chfNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tz'ombenon cache' no'on anon t'oc cä Pap, y cä Pap t'oc no'on. Tz'ombenon uc'a täcä ni cua' chichca cä chenba. ");
INSERT INTO chfNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Totojtoj acälbenetla, machca no'on u tz'ombenon, jini cua' chichca que cä chenba, une täcä u xe u chen; más pitzi cua' u xe u chen une uc'a no'onba cä xe ca'an cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Upete cua'tac a c'atbenla cä Pap täj c'aba', jin chich acä xe cä chen, tuba ch'u'ul c'ajti'cac cä Pap uc'a no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Cuaxca a c'atän täj c'aba', no'on chich cä xe cä chen. ");
INSERT INTO chfNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Si a yajna'tanon, tz'ombenon cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Cä xe cä c'atben cä Pap que une u yäc'benetla otro untu Ajlotaya uc'a paq'uin ajnic t'oc anela. Jin une ni Ch'u'ul Pixan que u ye'e' ni u tojaba. ");
INSERT INTO chfNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Machcatac cuxujob pancab mach u ch'ä u sapän, uc'a mach u chänejob, y mach u che conocejob täcä. Anelaba a chenla conoce, uc'a ya'an t'oc anela, y u xe tä ajtä ta'wac'ola. ");
INSERT INTO chfNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mach uxon cäctanetla ca' neba' ch'oc. Acä te chich bajca anetla. ");
INSERT INTO chfNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Acolobi tz'ita' q'uin a'ajtäjob pancab mach uni' sutwan u chänenon; anelaba a xe a chänenonla. Uc'a no'on cuxulon, anela täcä a xela tä ajtä cuxu. ");
INSERT INTO chfNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jinq'uinba a xe a wina'tanla cache' no'on anon t'oc cä Pap, anela t'oc no'on, no'on t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Machca u sapi cä t'an y u tz'onän, jin une ni u yajna'tanon; machca u yajna'tanon, cä Pap u xe u yajna'tan täcä, y no'on cä xe cä yajna'tan, y cä xe cä ye'e' cä poder bajca an. ");
INSERT INTO chfNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Aj Judas, ni mach jin aj Iscarioteba, u yälben: ―Cajnoja, ¿can uc'a a xe a ye'e' a poder bajca anon t'ocob, y mach bajca an jini que tubajob u pancab? ");
INSERT INTO chfNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aj Jesús u yälbi: ―Machca u yajna'tanon, u xe u tz'ombenon cä t'an; cä Pap täcä u xe u yajna'tan; acä xe tä te t'ocob bajca an, cä xe tä ajtä t'ocob tomp'e t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Machca mach u yajna'ton, mach u tz'onä cä t'an. Ni t'an a ubilaba mach jin täc'a, tuba cä Pap une ni u täsconba. Une u yäc'bon cäle'. ");
INSERT INTO chfNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Jinda ni acälbenetla ya'toca anon t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ni Ajlotayaba, ni Ch'u'ul Pixanba, jini que u xe u täscun cä Pap täj c'aba'ba, une u xe u ye'benetla upete, u xe u c'ajti'benetla upete cua'tac cälbetla. ");
INSERT INTO chfNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Cä'benetla ajnic ch'ijcab a c'ajalinla. Ca' chich ch'in an cä c'ajalin, che' chich acä'benetla ajniquetla. Mach ca' u yäq'ue' a'ajtäjob pancab, acä'benetla no'onba. Mach ch'ocomac a pixanla, mach bäc'taquetla. ");
INSERT INTO chfNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A ubila chich cache' cälbenetla, acä bixe, y acä sujtä bajca anetla. Si a yajna'tanonla u totoj ch'a'alan chich ajinla uc'a cäli cä xe ca'an cä Pap, uc'a cä Papba más ajnoja que no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bada cä worin älbetla cua' u xe u chen pasa antes que utic, uc'a jinq'uin u xe tä ute, a tz'onänla chich. ");
INSERT INTO chfNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mach uni' xon cä chen q'uen t'an t'oc anela, uc'a ajnoja tuba jinda u pancab ya' u te. Uneba mach u cänänta cua' t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ca' chich u yälbon cä Pap, che' chich acä chen uc'a yuwina'tanob pancab cache' acä yajna'tan cä Pap. Ch'oyenla, cola tä pasela wida bajca anonla. ");
INSERT INTO chfNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’No'on ni ca' a wälä totoj te'uvajon, cä Pap ni ajsis'uva. ");
INSERT INTO chfNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Upete cä c'äb ya'an täjcac'oba ni mach u che u jutba, u pa'sen. Upete ni u chen u jutba, u sisän, uc'a u chen más q'uen u jut. Ca' jini ayan machcatac u tz'ombenon. ");
INSERT INTO chfNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bada anelaba ca' a wälä sisi ayanetla, uc'a a sapila ni cä t'an cälbetlaba. ");
INSERT INTO chfNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ajniquetla t'oc no'on y no'on t'oc anela. Ca' ni c'äb te' mach u ch'ä u chen u jut u juntuma si mach ajnic tuyac'o u te'e, che' chich anela täcä mach u ch'ä a chen niump'e cua' si mach ajniquetla t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’No'on ca' a wälä ni te'uvajon, anelaba ca' a wälä cä c'äb. Machca ya'an täjcac'o, y no'on tuyac'o, jinda ni u yäq'ue' q'uen u jut. Si mach ajniquetla t'oc no'on, mach u ch'ä a chenla niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Machca mach'an t'oc no'on, u chojcan ca' cäb te' tä tiquin; y de ya'i u ch'ämcan ta julcac tan c'ac' tä pule. ");
INSERT INTO chfNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Si ajniquetla t'oc no'on, y cä t'an ajnic ta' pixanla, c'atänla upete cua'tac a wola y a xe chich tä ä'bintela. ");
INSERT INTO chfNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ca' jini u xe chich tä ch'u'ul c'ajti'can cä Pap, si a chenla q'uen cua' yo Dios a chenla. Ca' jini cheque cache' mero cajcänt'anetla. ");
INSERT INTO chfNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ca' chich u yajna'tanon cä Pap, che' chich täcä acä yajna'tanetla. Co que ajniquetla t'oc no'on uc'a cä paq'uin yajna'tanetla. ");
INSERT INTO chfNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si a tz'ombenonla cä t'an, ya' chich anetla t'oc no'on y cä paq'uin yajna'tanetla, ca' chich no'on täcä cä tz'ombi u t'an cä Pap, y ya'anon t'oc une y une u paq'uin yajna'tanon. ");
INSERT INTO chfNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Jinda cälbetla uc'a ajniquetla tä' ch'a'a ajinla ca' chich no'on tä' ch'a'a cäjin. ");
INSERT INTO chfNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jinda ni manda cä'benetla: Maläc yajna'tan abala ca' chich cä yajna'tetla. ");
INSERT INTO chfNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Machca u yäq'ue' uba tä chämo uc'a mach chämic u lot, ca' jini cheque cache' tä' u yajna'tan jini u lot. Mach'an cua' más u ch'e' u chen tuba u ye'e' cache' u yajna'tan u lot. ");
INSERT INTO chfNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Anela cä lotetla si a chenla ca' acälbenetla. ");
INSERT INTO chfNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mach uni' xon cälbenetla cache' cajpatanetla, uc'a ajpatanba mach yuwi cua' u chen u yum. Cä xe cälbenetla cache' cä lotetla, uc'a upete ni cubi t'oc cä Papba, jin chich acälbetla. ");
INSERT INTO chfNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Anela mach a yaconla. No'on ni cä yaquetla, cä'bet xiquetla a chen u patan Dios, y que upete jini a chenlaba ajnic utz tu jut Dios, uc'a upete cua' a c'atbenla cä Pap täj c'aba'ba, une u yäc'benetla. ");
INSERT INTO chfNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jinda cälbenetla: maläc yajna'tan abala. ");
INSERT INTO chfNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Si a'ajtäjob pancab u cräxna'tanetla, a wila chich cache' no'on täcä u cräxna'tonob najtäcä. ");
INSERT INTO chfNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Si fuera tuba u pancabetla, a'ajtäjob pancab u yajna'tanetla ica, uc'a unejob chich u maläc yajna'tan ubajob. A'ajtäjob pancab u cräxna'tanetla uc'a mach tuba u pancabetla, no'onba cä yaquetla uc'a mach ni' ajniquetla tuba u pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","C'ajna'tanla ni cä t'an cälbetlaba: “Ajpatan mach jin más ajnoja que u yum”. Si no'on u tz'ibajtesonob, anela täcä u xe u tz'ibajtesanetla. Si u tz'onijob cä t'an, che' chich u xe u tz'onänob ta'ala täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Upete jinda u xe u cherbenetla uc'a a tz'ombenonla, uc'a mach u che conocejob machca u täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Si machica ticon cälbenob, machica an u tanä; bada mach'an cache' u japän ubajob t'oc u tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Machca no'on u cräxna'tanon, u cräxna'tan täcä cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Si machica cä chen niump'e cua' bajca anob que niuntu mach bay u chi, machica an u tanäjob; pero bada u chänijob cua' cä chi, y u cräxna'tanonjob y cä Pap täcä u cräxna'tanob. ");
INSERT INTO chfNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","U chi pasa ca'da uc'a pasic toj ca' chich tz'ibi tama ley tubajob jini u yäle' ca'daba: “U cräxna'tanonjob, pero mach'an cua' uc'a”. ");
INSERT INTO chfNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cuanta juli jini Ajlotaya, jini que u xe u yäc'benon cä Pap ta cä täscäbenetlaba, jini Ch'u'ul Pixan que u ye'e' ni u tojaba, jini u te ca'an cä Papba, une u xe u yäle' machcajon. ");
INSERT INTO chfNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Anela täcä a xe a wäle'la machcajon, uc'a ajnetla t'oc no'on najtäcä ixta bada. ");
INSERT INTO chfNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Jinda cälbetla uc'a mach sujlequet ta' patla. ");
INSERT INTO chfNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A xe tä pa'sintela tama ch'uj tuba aj judíosob. U xe tä c'ote q'uin jinq'uin machcatac u tzämsenetla u xe u yäle' cache' tuba Dios u chen. ");
INSERT INTO chfNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jinda u xe u cherbenetob uc'a mach u che conocejob cä Pap, ni no'on täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jinda cälbetla, uc'a tu c'ote q'uin utic ca' jini a c'ajna'tanla cache' che' chich acälbetla. ’Jinda mach cälbetla najtäcä uc'a ya'to anon t'oc anela. ");
INSERT INTO chfNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bada cä xe bajca an machca u täsconba. Niuntu de anela mach a ni' c'atbonla: “¿Cada a xe?” ");
INSERT INTO chfNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Uc'a cälbetla ca' jini, tä' triste an a pixanla. ");
INSERT INTO chfNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","No'onba cälbenetla tu toja: Mäx c'änä bixicon. Si no'on mach bixicon, Ajlotaya mach uta bajca anetla. Bixiconba, cä täscun bajca anetla. ");
INSERT INTO chfNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tu te uneba, u xe u chectesbenob a'ajtäjob pancab cua' jini u tanäjob, camba ni u toja, y cua' une ni toji'tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","U xe u chectesbenob ni u tanäjobba uc'a mach u tz'ombonob une. ");
INSERT INTO chfNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","U xe u ye'e' camba ni u toja, uc'a cä xe ca'an cä Pap, y mach uni' sutwanet a chänenonla. ");
INSERT INTO chfNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","U xe u ye'e' cua' une ni toji'tanä, uc'a ajnoja tuba jinda u pancab u xe chich tä äc'binte u toje' u tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ya'to an q'uen cua' cälbenetla, pero mach to u ch'ä ochic ta' c'ajalinla bada. ");
INSERT INTO chfNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tu te ni Ch'u'ul Pixanba, une u xe u ye'benetla upete ni u tojaba; uc'a mach tu c'ajalin u pa'sen cua' jini u xe u yäle'; upete cua' u yubinba, jini u xe u yäle'; u xe u worin älbenetla cua'tac u xe tä ajtä. ");
INSERT INTO chfNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Une u xe u yäq'ue' que ch'u'ul c'ajti'cacon, uc'a cä t'an chich u xe u yäc'benet a wina'tanla. ");
INSERT INTO chfNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Upete ni t'an tuba cä Papba, täc'a chich täcä, jin uc'a cäli cache' ni Ch'u'ul Pixan chich u xe u yäc'benet a wina'tanla cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Acoli tz'ita' q'uin ta bixicon, y mach uxet a chänenonla; pero otros tz'ita' q'uin tä cha'num a xe chich a chänenonla, uc'a no'on ya' cä xe ca'an cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","De ya'i u tulaj maläc älijob u yajcänt'anob: ―¿Cua' wäre jini u yälbenonla? U yäle' cache' acoli tz'ita' q'uin ta bixic y mach uxon cä chänenla; pero otros tz'ita' q'uin tä cha'num cä xe cä chänenla une, uc'a u xe ca'an u Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Cua' wäre jini u yäle' jinq'uin u yäli ca'da: “Acoli tz'ita'”? Mach cä che entendela cua' jini u yäli. ");
INSERT INTO chfNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aj Jesús yuwi chich cache' yo u c'atbenob cua' jini u yäle', jin uc'a u yäli ca'da: ―¿A maläc c'atben abala quira cua' jini ni acäli: “Acoli tz'ita' q'uin ta bixicon y mach uxet a chänenonla, pero otros tz'ita' q'uin tä cha'num a xe a chänenonla”? ");
INSERT INTO chfNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Totojtoj cälbenetla, anela a xe tä uc'nanla, y tä ch'ocoman a pixanla, pero jini que tuba u pancabba u xe tä ch'a'alan ujinob. Anela a xela tä triste'anla, pero jini tristejle ta'alaba u xe tä sujtä de ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ixic jinq'uin ac'oti hora ta c'ojpac, u na'tan c'uxe. Pero cuanta päncäbi jini ch'oc, mach u ni' c'ajna'ta jini c'uxe. U ch'a'alan ujin uc'a san päncäbi untu ch'oc pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bada anela täcä triste anetla, pero täc te cä chänenetla tä cha'num, u xe tä ch'a'alan ujin a pixanla, y niuntu mach uxin u pa'säbenetla jini ch'a'aljin. ");
INSERT INTO chfNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Jinq'uinba, mach uxet a c'atbenonla niump'e cua'. Totojtoj cälbenetla, upete cua' a c'atbenla cä Pap täj c'aba', u xe chich u yäc'benetla. ");
INSERT INTO chfNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Badaba mach to a c'atäla niump'e cua' täj c'aba'. C'atänla y a xe chich tä ä'bintela tuba paq'uin ajnic a ch'a'aljinla. ");
INSERT INTO chfNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Jintacda cälbetla t'oc balä' tz'aji. U xe tä c'ote q'uin mach uni' xon cälbenetla t'oc balä' tz'aji. Cä xe cä totoj chectesbenetla cache'da ayan cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jinq'uinba a xe a c'atänla täj c'aba'. Mach ni' c'änä ajnicon de ajnumsajt'an ta'ala t'oc cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Uc'a cä Pap chich u yajna'tanetla, uc'a anela täcä a yajna'tonla y a tz'onila cache' ya' aton bajca an Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ya' chich aton bajca an cä Pap, julon pancab. Bada cha'num cäctan u pancab y cä bixe bajca an cä Pap. ");
INSERT INTO chfNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","U yajcänt'anob u yäle': ―Bada cheque chich cua' a wäle'. Niump'e balä' tz'aji mach a ni' che. ");
INSERT INTO chfNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bada cuwi t'ocob cache' a wi chich upete, y mach c'änä cä ni' c'atbenet t'ocob cua' a wäle'. Jin uc'a acä tz'onän t'ocob cache' ya' chich atet bajca an Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Aj Jesús u yälbijob: ―¿Bada a totoj tz'onänla? ");
INSERT INTO chfNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ubinla, u xe tä c'ote q'uin, y bada ac'oti chich jini q'uin jinq'uin a xe a puclan abala, y a xe tä bixela cachichcada. A xe a wäctanonla cä juntuma täcä, pero mach cä juntuma cä xe tä colan, uc'a cä Pap ya'an t'oc no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jinda cälbetla uc'a co cä'benetla ajnic ch'ijcab a c'ajalinla. Tu pancab a xe tä tz'ibajtescanla, pero mach bäc'taquetla, no'onba acä chi trebe cä tzupsäben u poder jini ajnoja tuba u pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jintacda u yäli aj Jesús, de ya'i u t'äbsi u jut tä cielo u yäli ca'da: ―Cä Pap, ac'oti q'uin, äc'ä tä chäninte cä poder, no'on a Wajlo'on, uc'a ca' jini cäq'ue' tä chäninte a poder täcä. ");
INSERT INTO chfNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Uc'a ane a wäc'bon täj c'äb upetejob machcatac a yaquijob pancab tuba cä'ben paq'uin cuxlecob. ");
INSERT INTO chfNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Upete machcatac u chenet conoce y u chenon conoce täcä, jin une ni paq'uin cuxu ayanob, uc'a ane ni mero Dioset y no'on ni aj Jesucristo que a täsconba. ");
INSERT INTO chfNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Cäq'ui tä chäninte pancab cache' an a poder. Acä tzupsi ni patan a'bon cä chenba. ");
INSERT INTO chfNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bada cä Pap, äc'ä tä chäninte cache' ayan chich cä poder bajca ayanet täcä, jinchichba poder que cä cänänti jinq'uin ya'anon bajca anet jinq'uin mach to an u pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Cä chectesbijob chich jini winicob a yaqui pancabba cache' ane ni Dioset. Ta'ajob chich, y a'bon täj c'äb, y u tz'onijob a t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bada yuwijob cache' ta' c'äb ati upete cua'tac a'bon. ");
INSERT INTO chfNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Uc'a ni t'an a'bonba, cä ye'bijob. Unejob u sapi, y bada yuwijob chich cache' aton bajca anet, y u tz'onijob cache' ane a täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Cä c'atän que a täclenob, mach cä c'atä tuba jini que tuba u pancabobba. Cä c'atän tuba machcatac a'bonba, uc'a ta'ajob chich. ");
INSERT INTO chfNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Upetejob jini täc'aba, ta'a chich; y upetejob jini ta'aba, täc'a chich. Ca' jini cä ch'u'ul c'ajti'can, uc'a lo que u chenob. ");
INSERT INTO chfNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Mach uni' xon tä ajtä pancab. Jindajobba ya'to anob pancab, y no'onba cä te bajca anet. Cä ch'u'ul Pap, cänäntanob t'oc a poder ni a'bonba uc'a ajnicob tomp'e t'oc ane ca' chich anonla. ");
INSERT INTO chfNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jinq'uin ya'to anon t'oc unejob pancab, cä cänäntijob t'oc a poder; machcatac a'bonba, cä cänäntijob chich, y niuntu mach säti sec' jini ajlo' tuba chich ajsätoba, uc'a pasic toj ca' chich tz'ibi tama a jun. ");
INSERT INTO chfNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Bada cä te bajca anet. Jinda cäle' ya'toca anon pancab uc'a ajnicob tä' ch'a'a ujinob ca' chich no'on tä' ch'a'a cäjin. ");
INSERT INTO chfNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","No'on cälbijob a t'an. Jinijob tubajob u pancabba u cräxna'tijob uc'a mach tuba u pancabob, ca' chich no'on täcä mach tuba u pancabon. ");
INSERT INTO chfNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mach cä c'atä a pa'senob pancab, cä c'atbenet a cänäntanob uc'a mach u cherbenob cua' tzuc pixan. ");
INSERT INTO chfNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Unejob mach tuba u pancabob, ca' chich no'on mach tuba u pancabon. ");
INSERT INTO chfNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Äc'ben ochic a t'an tu c'ajalinob, y ca' jini ajnicob seq'uen ta'a y tu toja; a t'an aneba toj chich. ");
INSERT INTO chfNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ca' chich ane a täscon cäle' a t'an pancab, che' chich täcä cä täscunob u yäle' a t'an pancab. ");
INSERT INTO chfNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cäq'ue' cäba ajnicon seq'uen ta'a, uc'a unejob totoj ajnicob seq'uen ta'a. ");
INSERT INTO chfNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Mach sec' tuba jinijob cä c'atbenet. Cä c'atbenet täcä tuba machcatac u xe u tz'ombenonob uc'a u t'anob. ");
INSERT INTO chfNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Uc'a upetejob ajnic tomp'e, ca' chich ane cä Pap tomp'e ayanet t'oc no'on, y no'on t'oc ane, y ajnicob täcä tomp'e t'oc no'onla, tuba u tz'onänob a'ajtäjob pancab cache' ane a täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ni poder a'bonba, jin chich acä'bijob uc'a ajnicob tomp'e, ca' chich anonla tomp'e. ");
INSERT INTO chfNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","No'on tomp'e ayanon t'oc unejob, y ane t'oc no'on, tuba nonoj ajnicob tomp'e t'oc no'onla, uc'a ca' jini yuwina'tanob a'ajtäjob pancab cache' ane a täscon, y cache' ane a yajna'tanob, ca' chich no'on a yajna'ton. ");
INSERT INTO chfNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Cä Pap, machcatac a'bon co ajnicob täcä t'oc no'on bajca anon uc'a u chänenob cä poder a'bonba, uc'a mach to an u pancab a yajna'tanon. ");
INSERT INTO chfNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Cä Pap que a chen tu tojaba, a'ajtäjob pancab mach u chet conoce; no'onba cä chenet chich conoce; y jindajob yuwijob cache' ane a täscon. ");
INSERT INTO chfNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","No'on cä chectesbijob cache'da anet aneba, y cä xe chich cä chectesbenob más, uc'a yuwina'tanob cache' a yajna'tanob ca' chich ane a yajna'tanon, y uc'a ca' jini ajnicon tu pixanob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cuanta u yäli jinda aj Jesús, bixi t'oc u yajcänt'anob tunxe ni pa' u c'aba' Cedrón, c'oti bajca an ump'e bojte' ta päc'äbi. Ya'i ochi aj Jesús t'oc u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aj Judas ni u yäq'ui tä c'äbä aj Jesúsba, yuwi chich täcä cada an ni päc'äbi jini, uc'a aj Jesús a'uti u woylan ubajob ya'i t'oc u yajcänt'anob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Aj Judas u woyli uba t'oc noj q'uenel soldado y ajc'äncanob täcä tuba u yajnojajob pale y tuba aj fariseojob, c'otijob ya'i t'oc u chictaya, t'oc u te' y t'oc u machitob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Aj Jesúsba yuwi chich upete cua'tac u te tuyac'o, pänte'i u c'atbenob: ―¿Caxcone a sacänla? ");
INSERT INTO chfNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","U p'alijob: ―Aj Jesús aj nazarenoba. Aj Jesús u yälbenob: ―No'on une. Aj Judas ni u yäq'ui tä c'äbäba ya' chich an täcä t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Uc'a u yäli aj Jesús: “No'on une”, sutwäni tu patob, yälijob tä cab. ");
INSERT INTO chfNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","De ya'i aj Jesús sutwäni u c'atbenob: ―¿Caxcone a sacänla? Unejob u yäli: ―Aj Jesús aj nazarenoba. ");
INSERT INTO chfNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aj Jesús u p'ali: ―San cälbetla cache' no'on chich; si no'on a sacänonla, äctanla tä bixe jindajob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","U yäli ca' jini uc'a pasic toj ca' chich u yäli uneba: “Niuntu mach cä säti ni a'bonba”. ");
INSERT INTO chfNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","De ya'i aj Simón Pedro u pa'si u machit tama u pat u chunjätz'bi u chiquin tu nojba u yajpatan no' ajnoja pale. U c'aba' ni ajpatan jini aj Malco. ");
INSERT INTO chfNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","De ya'i aj Jesús u yälbi aj Simón Pedro: ―Äc'ä a machit tan u pat. Ni tz'ibajtesia que u yäq'ui cä Pap äc'binticonba, ¿a wäle' quira que mach uxon cä ch'e'? ");
INSERT INTO chfNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","De ya'i jini soldadojob y ajnoja ta soldadojob y u yajc'äncanob aj judíosob u q'uechijob aj Jesús y u cächijob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Najtäcä u bisijob bajca an aj Anás, uc'a aj Anásba jichan aj Caifás. Aj Caifásba no' ajnoja pale jimba año jini. ");
INSERT INTO chfNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Aj Caifás une ni u yäc'bi c'ajalin aj judíosob cache' c'änä chämic untu uc'a mach sätic entero caj. ");
INSERT INTO chfNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Aj Simón Pedro bixi tu pat aj Jesús t'oc otro untu ajcänt'an. Jini ajcänt'an u chen chich conoce no' ajnoja pale. Jin uc'a ochi t'oc aj Jesús tan yotot no' ajnoja pale. ");
INSERT INTO chfNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Aj Pedroba ya' coli tä wa'tä päti ti' otot. Pasi jini ajcänt'an u chen conoce no' ajnoja paleba, y u pequi ixcänän ti'otot tuba u yosen aj Pedro. ");
INSERT INTO chfNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ixcänän ti'otot u yälbi aj Pedro ca'da: ―¿Mach quira ane täcä ajcänt'anet tuba jinda winic? Une u yäli: ―Mach jinon. ");
INSERT INTO chfNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ajpatanob y ajc'äncanob tuba aj judíosob u tz'äbijob c'ac' uc'a sis. Wa'wänijob ti' c'ac' u ticwesan ubajob. Ya' wa'ca aj Pedro täcä t'oc unejob u ticwesan uba. ");
INSERT INTO chfNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","No' ajnoja pale u c'atbi aj Jesús si an u yajcänt'anob y cua'tac u ye'e'. ");
INSERT INTO chfNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aj Jesús u p'ali: ―No'on mach mucu cä chi t'an pancab. No'on cä paq'uin ye'i u t'an Dios tama ch'uj taj judíosob y tama noj ch'u'ul otot bajca u woylan uba upete aj judíosob. Mach cäli niump'e cua' mucu. ");
INSERT INTO chfNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Can uc'a a c'atbenon no'on? C'atbenob machcatac u yubi cua'tac cälbijob. Unejob chich yuwi cua'tac cäli. ");
INSERT INTO chfNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Uc'a xi u yäle' ca'da, untu soldado que ya' wa'ca ya'i u t'äbsi u c'äb y u cuni aj Jesús, u yäli ca'da: ―¿Ca' jini a xe a p'alben u t'an no' ajnoja pale? ");
INSERT INTO chfNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aj Jesús u p'ali: ―Si mach utz cua' acäli, älä cache'da mach utz. Y si utzba, ¿cua' uc'a a cune'on? ");
INSERT INTO chfNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","De ya'i aj Anás u täsqui cächä aj Jesús bajca an aj Caifás, no' ajnoja pale. ");
INSERT INTO chfNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Aj Pedro ya'to wa'ca u ticwesan uba. U yälbijob ca'da: ―¿Mach quira ane täcä u yajcänt'anet? Une u yäli: ―Mach jinon. ");
INSERT INTO chfNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Untu u yajpatan no' ajnoja pale, u familia chich ni u chunjätz'bi u chiquin aj Pedroba, u yälbi täcä ca'da: ―¿Mach quira cä chänet t'oc tan bojte' ta päc'äbi? ");
INSERT INTO chfNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aj Pedro u yäli tä cha'num cache' mach toj. De ya'i seb u chi uq'ue ajtze. ");
INSERT INTO chfNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Isapanto u pa'sijob aj Jesús tu yotot aj Caifás, u bisijob tu yotot aj Pilato. Aj judíosob mach ochijob tan yotot aj Pilato uc'a mach u xac'än ubajob t'oc aj gentil, uc'a ca' jini u ch'e' c'uxnacob ta noj paxcu'. ");
INSERT INTO chfNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","De ya'i aj Pilato pasi päjna bajca anob u yäli ca'da: ―¿Cua' sub a täsila tuyac'o jinda winic? ");
INSERT INTO chfNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Unejob u yäli ca'da: ―Si fuera mach ajnic u tanä, machica cä täsbet t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aj Pilato u yälbijob: ―Ch'äla anela, cherbenla ca' chich an tuyac'o ley ta'ala. Aj judíosob u yäli: ―Mach u ch'ä cäq'ue' t'ocob tä tzämsinte niuntu. ");
INSERT INTO chfNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Upete ni jini u chi pasa uc'a pasic toj ca' chich u worin äli aj Jesús, jinq'uin u yäli cache'da u xe tä chämo. ");
INSERT INTO chfNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","De ya'i aj Pilato ochi cha'num tan yotot, u joq'ui aj Jesús u c'atben: ―¿Ane quira ni Ajnojalet taj judíosob? ");
INSERT INTO chfNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aj Jesús u p'ali: ―¿Ane chich ta' c'ajalin quira a pa'si jinda, o älbinte a chi caxcajon? ");
INSERT INTO chfNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aj Pilato u p'ali: ―¿Aj judíojon quira no'on? A wajcäbnajob y ajnojajob ta pale u yäq'uetob täj c'äb. ¿Cuaxca tanä a chi? ");
INSERT INTO chfNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aj Jesús u p'ali: ―Bajca cä chen manda no'onba mach pancab. Si fuera jimba u pancabda cä chen mandaba, cajpatanob u chen ica jo'yan u japänon tu c'äb aj judíosob. Jin uc'a bajca cä chen manda no'onba mach wida une. ");
INSERT INTO chfNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","De ya'i aj Pilato u yälbi: ―¿Ajnojalet quira ane? Aj Jesús u p'ali: ―Jinon chich, ca' chich mu' a wäle' cache' ajnojalon. Jin tuba päncäbon, jin tuba ton pancab, tuba cäle' ni u tojaba. Upete machcatac ayan t'oc ni u tojaba u yubin cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aj Pilato u yälbi: ―¿Cua' jini ni u tojaba? Jinq'uin u yälbi jinda t'an, pasi cha'num aj Pilato u pecän aj judíosob, u yälbenob ca'da: ―Mach cä pojläbe niump'e u tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Anelaba nämäletla cä chajbenetla untu tan paxcu'. ¿A wola quira cä chajbenetla Ajnoja taj judíosob? ");
INSERT INTO chfNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Upetejob u chijob noj t'an tä cha'num, u yäle'ob: ―¡Mach a chaje' jindaba! ¡Chajbenon t'ocob aj Barrabás! Aj Barrabásba ajxuch' une. ");
INSERT INTO chfNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","De ya'i aj Pilato u ch'i aj Jesús u yäq'ui tä jätz'can. ");
INSERT INTO chfNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldadojob u jit'bi u corona de ch'ix, u yäc'bijob tan u pam, u xojbijob ump'e u ic'puq'uen buc tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","U tze'tanob y u yälbenob ca'da: ―¡Ch'u'ul c'ajti'caquet, Ajnoja taj judíosob! Y u cune'ob t'oc u c'äb. ");
INSERT INTO chfNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Aj Pilato pasi cha'num päti u yälbenob ni gente: ―Ubixtola, cä xe cä täsbenetla päti uc'a a wina'tanla cache' mach cä pojläbe niump'e u tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aj Jesús pasi päti t'oc u ch'ixil corona tan u pam y t'oc u ic'puq'uen buc. Aj Pilato u yälbenob ca'da: ―¡Ya'anda ni winicda! ");
INSERT INTO chfNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jinq'uin ajnojajob ta pale y ni soldadojob u chänijob, t'oc noj t'an u yälijob: ―¡Äc'ä tä cruz! ¡äc'ä tä cruz! Aj Pilato u yälbenob: ―Ch'äla anela äc'äla tä cruz, uc'a mach cä pojläbe no'on niump'e u tanä. ");
INSERT INTO chfNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aj judíosob u p'ali: ―Ya'an cä ley t'ocob, cä ley t'ocob u yäle' chämic, uc'a une u chi uba ca' u Yajlo' Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jinq'uin aj Pilato u yubi jinda t'an, más bäc'ti. ");
INSERT INTO chfNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ochi cha'num tan yotot u c'atbi aj Jesús: ―¿Caxcadajet ane? Aj Jesús mach u p'ali cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","De ya'i aj Pilato u yälbi: ―¿Cua' uc'a mach a p'alä cä t'an? ¿Mach quira a wi cache' no'on an cä poder cäq'ue'et tä tzämsinte tä cruz y an cä poder cä chaje'et? ");
INSERT INTO chfNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Aj Jesús u p'ali: ―Ane mach u ch'ä a chen niump'e cua' täjcac'o si mach u yäc'bet Dios tä cielo a chen. Jin uc'a más an u tanä machca u yäc'on ta' c'äb. ");
INSERT INTO chfNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Desde jimba hora jini aj Pilato u sacän cache' u xe u chaje'. Pero aj judíosobba t'oc noj t'an u yälijob: ―¡Si jinda winic a chaje', mach anet t'oc aj César! ¡Machca chichca u chen uba de ajnoja ca' u chi ni winic jini, u jule' uba tuyac'o aj César! ");
INSERT INTO chfNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jinq'uin aj Pilato u yubi jinda t'an, u pa'si päjna aj Jesús, chunwäni tu chumlib juez bajca u c'aba' ya'i tä hebreoba Gabata. Jini t'an yo u yäle' cache' puro ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jimba q'uindaba, tusbäji ta noj paxcu', u chen tä c'ote tänxin q'uin. U yälbi aj judíosob: ―¡Ya'anda ni a wajnojala! ");
INSERT INTO chfNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Unejob t'oc noj t'an u yälijob: ―¡Pa'sen! ¡Pa'sen! ¡äc'ä tä cruz! Aj Pilato u yälbenob: ―¿A wola quira cäq'ue' tä cruz ni a wajnojala? Ajnojajob ta pale u yälijob: ―Mach'an otro cajnoja t'ocob, sec' aj César une. ");
INSERT INTO chfNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","De ya'i aj Pilato u yäc'bi tu c'äbob tuba u yäq'ue' tä cruz. Ni gente u ch'ijob aj Jesús y u bisijob. ");
INSERT INTO chfNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Aj Jesús pasi t'oc u cruz u bisi bajca u yälbinte tä bäc pam tiquinba, tä hebreojt'anba Gólgota. ");
INSERT INTO chfNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ya'i u yäq'uijob tä cruz. U yäq'uijob tu cruzob täcä otros cha'tu bajca an une, untu tu noj, untu tu tz'ej, aj Jesús tänxin. ");
INSERT INTO chfNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aj Pilato u tz'ibi ump'e c'aba' täcä, u yäq'ui tu pam u cruz aj Jesús. Tz'ibi ca'da: “Aj Jesús aj nazareno, Ajnoja taj judíosob”. ");
INSERT INTO chfNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Q'uen aj judíosob u tziquijob jini c'aba', uc'a nätz'ä t'oc caj bajca äc'qui tä cruz aj Jesús. Tz'ibi tä hebreo, tä griego, y tä latín. ");
INSERT INTO chfNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ajnojajob pale taj judíosob u yälbijob aj Pilato: ―Mach a tz'ibän: “Ajnoja taj judíosob”. Tz'ibän ca'da: “Jinda winic u yäli cache' une Ajnoja taj judíosob”. ");
INSERT INTO chfNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aj Pilato u p'ali: ―Ni cä tz'ibiba, acä tz'ibi chich une y mach uxon cä q'uexe'. ");
INSERT INTO chfNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ni chäntu soldadojob, cuanta u yäq'ui tä cruz aj Jesús, u ch'ämbijob u buc, u puclijob ajump'e juntu. U ch'ämbijob täcä u buc tu pamba. Jini u buc tu pamba mach chuyu une, jit'i une entero ump'e desde isqui ixta emä. ");
INSERT INTO chfNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","U maläc älijob: ―Mach cä tajala, cola cä pa'senla suerte quiranla caxca une u xe u ch'e'. Jinda u chijob tuba pasic toj ca' chich tz'ibi tama u jun Dios ca'da: “U puclijob cä buc. Ni cä buc tu pamba u yäläsijob tuba u jiran caxca une u xe u ch'e'”. Che' chich u chi ni soldadojob. ");
INSERT INTO chfNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ya' wa'ca u na' aj Jesús bajca an tä cruz. Ya'anob ya'i täcä u chich u na', ix María jit'oc aj Cleofas, y ix María Magdalena. ");
INSERT INTO chfNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jinq'uin aj Jesús u chäni u na' y jini u yajcänt'an tä' u yajna'tanba ya' wa'cajob t'oc, u yälbi u na' ca'da: ―Cä na', ya'an jini a wajlo'. ");
INSERT INTO chfNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","De ya'i u yälben u yajcänt'an: ―Ya'an jini a na'. Jinchichba hora jini ni ajcänt'an u ch'i ni ixic jini u bisi tu yotot. ");
INSERT INTO chfNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","De ya'i aj Jesús yuwi chich cache' axupi tä ute upete lo que Dios u yäc'bi u chen. U yäli: ―Tiquin cä ti'. Ca' jini u yäli uc'a pasic toj ca' chich tz'ibi tan u jun Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ajni ya'i ump'e jotz tulu t'oc pajäl c'äb uva. U majijob ump'e tz'u'i' ja' tama jini pajäl c'äb uva, u yäq'uijob tuyac'o untz'it te', y u yäc'bijob tu ti'. ");
INSERT INTO chfNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cuanta u yuch'i jini pajäl c'äb uva, aj Jesús u yäli ca'da: ―Acä tzupsi cä chen upete ca' chich u yäc'bon Dios cä chen. De ya'i u chinjatz'i u pam y chämi. ");
INSERT INTO chfNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","De ya'i aj judíosob, uc'a u q'uini tusbäji ta paxcu', u c'atbijob aj Pilato xulcac yoc u yuxtumajob y pa'sintic tä cruz cuanta chämijob, uc'a mach colacob tä cruz tu q'uin ch'ämbäji, uc'a jini q'uin ch'ämbäji noj q'uin ch'uj une. ");
INSERT INTO chfNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","C'otijob soldadojob, u xulbijob yoc untu che' chich täcä ni otro untuba, ni äc'qui tä cruz jinq'uin äc'qui tä cruz aj Jesúsba. ");
INSERT INTO chfNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jinq'uin c'otijob bajca an aj Jesús, u chänijob cache' san chämi. Jin uc'a mach u xulbijob yoc. ");
INSERT INTO chfNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Untu soldado u xec'bi tu ch'ejpa t'oc untz'it xec'onib, seb pasi ch'ich' y ja'. ");
INSERT INTO chfNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","No'on aj Juanon cäle' tu toja cache'da uti, uc'a no'on chich cä chäni, y jini cäle'ba, toj une. Cuwi chich cache' toj cua' cäle', uc'a a tz'onänla täcä anela. ");
INSERT INTO chfNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jinda uti uc'a pasic toj ca' chich tz'ibi tama u jun Dios ni u yäle' ca'daba: “U bäque mach uxin tä xulcan”. ");
INSERT INTO chfNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","U yäle' täcä ca'da: “U xe chich u chänenob jini winic que xec'quiba”. ");
INSERT INTO chfNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ji'pat aj José, u cab tä Arimatea, c'oti u c'atben aj Pilato si u ch'e' u pa'sen u cuerpo c'äsi' aj Jesús tu cruz tuba u muque'. Aj José u yajcänt'an aj Jesús, pero mach u yälä si ayan t'oc, uc'a u bäc'tan aj judíosob. Aj Pilato u yäc'bi chich u pa'sen. De ya'i c'oti u pa'sen u cuerpo c'äsi' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","C'oti täcä aj Nicodemo, jini ajni najtäcä bajca an aj Jesús ac'äbba, u c'osi ump'e jätz'äcnib u c'aba' mirra xäbä t'oc áloes, ca' ta treinta kilos. ");
INSERT INTO chfNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","U ch'ijob c'äsi' aj Jesús, u tz'otijob t'oc noc' y u tatz'ijob t'oc jini jätz'äcnib, ca' chich u muque' ajchäme aj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nätz'ä bajca äc'qui tä cruz ajni ump'e bojte' ta päc'äbi. Tama jini bojte' ajni ump'e u ch'ena ajchäme tzijib que uti tuyac'o ji'tun tu näc' tz'ic, mach to u yä'ca niuntu tama. ");
INSERT INTO chfNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ya'i jiq'uin u yäq'uijob u cuerpo c'äsi' aj Jesús, uc'a jini u ch'ena ajchäme nätz'ä ayan. Jimba q'uin jiniba, tusbäji ta paxcu' taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Najtäcäl q'uin ta semana, isapanto, jinq'uin mach to junch'äcna c'oti ix María Magdalena bajca mujqui aj Jesús. U chäni cache' apa'sinti ni ji'tun tu ti' ch'en bajca mujquiba. ");
INSERT INTO chfNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bixi t'oc ancäre, c'oti ca'an aj Simón Pedro t'oc jini otro ajcänt'an tä' u yajna'tan aj Jesúsba, u yälbenob: ―Ach'ämqui Cajnojala bajca mujqui, mach cuwila cada u yäq'uijob. ");
INSERT INTO chfNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pasi aj Pedro t'oc jini otro ajcänt'an, bixijob bajca mujqui aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","U cha'tumajob tä ancäre; ni ajcänt'an untuba más seb ancäri que aj Pedro, c'oti najtäcä ti' ch'en bajca mujqui. ");
INSERT INTO chfNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tinwäni u chänen, u chäni ya'an noc' tan ni mucliba y mach ochi. ");
INSERT INTO chfNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aj Simón Pedro c'oti ji'pat. Uneba ochi tama ni mujquiba u chäni cache' ya'an ni noc' t'unqui t'oc aj Jesúsba. ");
INSERT INTO chfNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ni noc' ajni cächä t'oc u pam c'äsi' aj Jesúsba mach ajni tomp'e, yänä ajni tupu. ");
INSERT INTO chfNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jinq'uin ochi täcä ni otro ajcänt'an, jini c'oti najtäcä bajca an ni mujquibaba, u chäni, y u tz'oni. ");
INSERT INTO chfNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Uc'a ixta jinq'uin mach to u che entendejob ni jun ta Dios tz'ibiba, ni u yäle' cache' c'änä cuxpac tan ajchämejobba. ");
INSERT INTO chfNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","De ya'i jini ajcänt'anob sutwänijob tu yototob. ");
INSERT INTO chfNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ix Maríaba ya'an tä uq'ue nätz'ä bajca mucli, t'oc uq'ue tinwäni u chänen tan ch'en. ");
INSERT INTO chfNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","U chäni cha'tu ángelo ta Dios, t'oc u säsäc bucob ya' chumcajob, untu tu pam, untu tu yoc bajca ajni c'äsi' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","U yälbijob: ―Ixic, ¿cua' uc'a a chen uq'ue? Une u yäli: ―Uc'a u bisijob Cajnoja, y mach cuwi cada u yäq'uijob. ");
INSERT INTO chfNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cuanta u yäli jinda, u suti uba y u chäni cache' ya' wa'ca aj Jesús. Uneba mach yuwi si aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aj Jesús u yälbi: ―Ixic, ¿cua' uc'a a chen uq'ue? ¿Caxcone a sacän? Une u yäli tan u c'ajalin cache' bay ajcänän päc'äbi, y u yälbi: ―Noxi' winic, si ane a bisi, älbenon cada a wäq'ui, uc'a cä bisan no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aj Jesús u yälbi: ―¡María! Une u suti uba u yälben: ―¡Raboni! ―uc'a a wina'tan tä yocot'anba: Maestro. ");
INSERT INTO chfNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aj Jesús u yälbi: ―Mach a täle'on uc'a mach to t'abon ca'an cä Pap. Cux ane bajca an ni hermanojob que u tz'ombi u t'an Diosba, y älbenob ca'da: “Cä t'äbo ca'an cä Pap, y ca'an a Papla, ca'an cä Dios, y ca'an a Diosla”. ");
INSERT INTO chfNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ix María Magdalena bixi u yälben u yajcänt'anob cache' u chäni Ajnoja, y cua'tac u yälbi. ");
INSERT INTO chfNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jinchichba q'uin jini, ochiq'uin, najtäcäl q'uin ta semana, mäcä uc'ajob ti' otot bajca an ni ajcänt'anob uc'a u bäc'tan aj judíosob. C'oti aj Jesús tä wa'tä tänxin de unejob. U yälbijob ca'da: ―Ajnic ch'ijcab a c'ajalinla. ");
INSERT INTO chfNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cuanta u yäli jinda, u ye'bijob u c'äb y u ch'ejpa. U yajcänt'anob ch'a'ali ujinob u chänenob ni Ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aj Jesús u yälbijob tä cha'num: ―Ajnic ch'ijcab a c'ajalinla. Ca' chich u täscon cä Pap cä tz'aycäben u t'an, che' chich täcä acä täscunetla a tz'aycunla u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Cuanta u yäli jinda, u yustijob y u yälbijob: ―Ch'äla ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Machca chichca a wäle'la que perdonado ayan u tanä, Dios chich u chen perdona. Y machca chichca a wäle'la que mach perdonado an u tanä, Dios mach u cherbe perdona. ");
INSERT INTO chfNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aj Tomás mach ajni ya'i jinq'uin c'oti aj Jesús. Une untu de ni docejob, ni u yälbinte cache' ajwacu'ba. ");
INSERT INTO chfNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","U yälbijob jini ajcänt'anob u lotobba: ―Cajnojala acä chäni t'ocob. Une u yälbijob ca'da: ―Si mach cä chänen tu c'äb bajca ajni clavo, si mach cä jup'e' cä ni'c'äb bajca u lowi clavo, si mach cä jup'e' cä c'äb tan u ch'ejpa, mach cä tz'onä. ");
INSERT INTO chfNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho día ji'pat, ya'anob tä cha'num tan otot u yajcänt'anob. Jinq'uinba, aj Tomás täcä ya'an t'oc unejob. Mäcä ti' otot bajca anob, c'oti aj Jesús tä wa'tä tänxin bajca anob, u yäli ca'da: ―Ajnic ch'ijcab a c'ajalinla. ");
INSERT INTO chfNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","De ya'i aj Jesús u yälbi aj Tomás: ―Jup'u a ni'c'äb wida, chänen cä c'äb, sätz'ä a c'äb jup'u täc ch'ejpa. Mach a wäle' que mach a tz'onä, tz'onän chich. ");
INSERT INTO chfNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","De ya'i aj Tomás u yäli ca'da: ―¡Cajnojalet y cä Dioset! ");
INSERT INTO chfNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aj Jesús u yälbi: ―¿Uc'a quira a chänon, Tomás, a tz'onän bada? Ch'a'a ujinob machca mach u chänonjob, y u tz'onijob. ");
INSERT INTO chfNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Aj Jesús u chi täcä tu jut u yajcänt'anob q'uen cua' chichca tuba u ye'e' u poder que mach tz'ibi tama jinda jun. ");
INSERT INTO chfNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jindaba tz'ibinti uc'a a tz'onänla cache' aj Jesús aj Cristo une, u Yajlo' Dios, uc'a si a tz'onänlaba, a xe tä paq'uin ajtäla cuxu nämte' t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ji'pat aj Jesús u ye'i uba tä cha'num bajca an u yajcänt'anob ti' nab u c'aba' Tiberias. Ca'da u chi pasa jinq'uin u ye'i uba: ");
INSERT INTO chfNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Aj Simón Pedro, aj Tomás jini u yälbinte cache' ajwacu'ba, y aj Natanael jini u cab tä Caná tama noj cab tä Galileaba, y u ch'ocob aj Zebedeo, y otros cha'tu u yajcänt'an ajnijob tomp'e jimba q'uin jini. ");
INSERT INTO chfNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Aj Simón Pedro u yälbi u lotob: ―Ya cä xe no'on tä q'uechbuch'. U lotob täcä u yäli: ―Acä xe t'ocob täcä t'oc ane. Bixijob, ochijob tama ump'e jucub. Jini ac'äb mach u q'uechijob cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mu' u junch'äcnan c'oti aj Jesús tä wa'tä ti' nab. U yajcänt'anobba mach yuwijob si aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","U yälbijob ca'da: ―Cä bijch'oc, ¿a q'uechila quira cua' tä c'uxcan? U p'alijob: ―Mach acä q'uechi t'ocob cua'. ");
INSERT INTO chfNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aj Jesús u yälbijob: ―Julula chim ta' noj, y a xe a q'ueche'la. U julijob chich. De ya'i mach u chi trebejob u ch'o'e' uc'a tä' q'uen ni buch' ochi tama. ");
INSERT INTO chfNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jini u yajcänt'an aj Jesús tä' u yajna'tanba u yälbi aj Pedro: ―Cajnojala une. Aj Simón Pedro, jinq'uin u yubi cache' Ajnoja, u xoji u buc uc'a sin buc ayan, y u juli uba tä ja' tuba c'otic bajca an. ");
INSERT INTO chfNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ni otro u yajcänt'anobba c'otijob tä cab t'oc jucub, uc'a mach nat t'oc cab bajca ayanob, ca' ta cien metros u nät'an, u täsen u jolänob ni chim t'oc buch'. ");
INSERT INTO chfNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jinq'uin t'äbijob tä cab, u chänijob cache' ya'an jut c'ac', ya'an buch' y waj tu pam ni jut c'ac'. ");
INSERT INTO chfNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aj Jesús u yälbijob: ―Täsen tz'ita' ni buch' a totaj q'uechilaba. ");
INSERT INTO chfNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aj Simón Pedro ochi tan jucub u jolän ni chim tä cab, tulu t'oc nuc buch'. Ajni ciento cincuenta y tres buch' tama ni chim. Tä' q'uen, y mach xet'qui ni chim. ");
INSERT INTO chfNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Aj Jesús u yälbijob: ―La'ixla tä c'uxnan. Pero niuntu u yajcänt'an mach u yoli u c'atben ca'da: “¿Caxcajet ane?” Uc'a yuwijob chich cache' Ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Aj Jesús u ch'i ni waj u yäc'benob, che' chich täcä ni buch'. ");
INSERT INTO chfNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jinda u yuxpetz'ib u ye'i uba aj Jesús bajca an u yajcänt'anob desde jinq'uin cuxpi tan ajchäme. ");
INSERT INTO chfNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cuanta ac'uxnijob, aj Jesús u yälbi aj Simón Pedro: ―Simón, ane ajlo'et taj Jonás, ¿a yajna'tanon quira más que jindajob? Une u p'ali: ―Cajnoja, a wi chich cache' tä' colet. Aj Jesús u yälbi: ―C'uxnesan cä ch'oc ovejajob, jini machcatac u tz'ombenonjob. ");
INSERT INTO chfNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aj Jesús sutwäni u c'atben tä cha'num: ―Simón, ajlo'et taj Jonás, ¿a yajna'tanon? Une u p'ali: ―Cajnoja, a wi chich cache' tä' colet. Aj Jesús u yälben: ―Cänäntan cä ovejajob. ");
INSERT INTO chfNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","U c'atben u yuxpetz'ib: ―¿Simón, ajlo'et taj Jonás, a wolon? Aj Pedro triste'i uc'a xi u c'atben u yuxpetz'ib si u yoli. U yälben: ―Cajnoja, ane a wi upete cua' chichca. A wi chich cache' tä' colet. Aj Jesús u yälben: ―C'uxnesan cä ovejajob. ");
INSERT INTO chfNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Totojtoj cälbenet jinq'uin ch'oc ajlo'et to, ane chich a xoji a buc, y a bixe cachichcada a woli. Pero cuanta noxibétba, a xe a tech'e' a c'äb, otro u xe u xojbenet a buc, y u xe u bisanet bajca mach uxet a wolin xiquet. ");
INSERT INTO chfNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jinda u yäli, uc'a u yälben cache'da u xe tä chämo tuba u yäq'ue' tä chäncan u poder Dios. De ya'i u yälbi täcä: ―Tzäypätinon y chen ca' chich cä chen no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","U suti uba aj Pedro u chänen jini ajcänt'an tä' u yajna'tan aj Jesúsba cache' u te tu patob, jini ajni t'ele tu ch'ejpa aj Jesús jinq'uin ya'anob tä c'uxnanba, jini que u yälbi täcä ca'daba: “Cajnoja, ¿caxca une ni u xe u yäq'ue'et tä c'äbäba?” ");
INSERT INTO chfNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aj Pedro, jinq'uin u chäni jinda winic, u yälbi aj Jesús ca'da: ―Cajnoja, ¿jindaba, cache'da u xe u chen pasa une? ");
INSERT INTO chfNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aj Jesús u yäli: ―Si co colac ixta sujlecon, ¿cua' u chi t'oc ane? Tzäypätinon ane y chen ca' chich cä chen no'on. ");
INSERT INTO chfNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jin uc'a älqui tan u lotob cache' jini ajcänt'an mach uxin tä chämo. Aj Jesúsba mach u yälbi cache' mach uxin tä chämo, sec' u yälbi ca'da: “Si co colac ixta que sujlecon, ¿cua' u chi t'oc ane?” ");
INSERT INTO chfNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","No'on une ni ajcänt'anon que cäle' cache'da xi upete ni jindaba, no'on chich cä tz'ibi täcä ni junda. Cuwi chich cache' toj upete lo que cäli. ");
INSERT INTO chfNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Q'uen cua'tac u chi aj Jesús täcä, si tz'ibintic tä jun upete cua'tac u chi, cäle' tan cä c'ajalin cache' mach u tawä tu pancab upete ni jun tz'ibinticba. Che' chich ajnic.");
INSERT INTO chfNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tama ni jun cä tz'ibi najtäcäba, Teófilo, cä tz'ibi upete jini u täq'ui aj Jesús u chen y u ye'e' ixta que jinq'uin bixi isqui tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jinq'uin mach to ubix isqui tä cieloba, aj Jesús t'oc u poder ni Ch'u'ul Pixan u yälbi ni ajc'äncanob que u yaquijobba cua' u xe u chenob. ");
INSERT INTO chfNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Uneba tzämsinti tä cruz, de ya'i cuxpi, y u ye'i uba cuxu bajca an u yajc'äncanob. U bon totoj ye'i uba uc'a tz'onintic. U yajne u ye'e' uba bajca anob ixta que tz'äcti cuarenta día. U tz'aycäbijob täcä cua' an bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jinq'uin ya'an t'oc unejob tomp'e, u yälbijob ca'da: ―Mach pasiquetla tä Jerusalén; pitänla najtäcä jini matän u yäli u xe u täscun cä Papba, jini cälbetlaba. ");
INSERT INTO chfNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Uc'a aj Juanba toj chich cache' u chi c'ablesia t'oc ja'; anelaba a xe tä c'ablescanla t'oc Ch'u'ul Pixan. Mach ni' q'uen yo ta c'ablaquetla ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jini u woyi ubajobba u c'atbijob ca'da: ―Cajnoja, ¿bada a sujtä quira a'benob tu c'äb aj Israelob u chen manda? ");
INSERT INTO chfNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Une u yälbijob: ―Mach'an cua' uc'a a wina'tanla caq'uin u c'ote q'uin u chen Dios lo que u yäli u xe u chen. Sec' cä Papla une yuwi caq'uin u xe u chen, uc'a sec' une an u poder. ");
INSERT INTO chfNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero anela a xe tä äc'bintela poder tu c'ote Ch'u'ul Pixan ta'wac'ola. Cua'tac acä chi no'onba, anela a xe a tz'aycunla tä Jerusalén, cachichcada tä Judea, tä Samaria, ixta tu jo u pancab. ");
INSERT INTO chfNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cuanta u yäli ca' jini, tu jutob chich bixi isqui tä cielo. Ochi tan bucla, säti tu jutob. ");
INSERT INTO chfNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ch'icwäni u jutob u chänen tu bixe tä cielo. Tajtzäc c'oti tä wa'tä bajca anob cha'tu winic t'oc u säsäc buc. ");
INSERT INTO chfNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jini cha'tu u yälbijob ca'da: ―Anela lo' galileo, ¿cua' uc'a a chänenla tä cielo? Jinchichba Jesús ni ajni t'oc anela abixi tä cieloba, ca' chich a chänila bixi tä cielo, che' chich u xe tä sujtä tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pasijob bajca an jini tz'ic u c'aba' Olivos, sutwänijob tä Jerusalén. U nät'an ni tz'ic jini t'oc tä Jerusalén ca' ta chap'e kilómetro, jin u nät'an que u ch'e' u chen xämba untu tu q'uin ch'ämbäji, ca' chich u yäle' ni ley. ");
INSERT INTO chfNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ochijob tan caj, t'äbijob tama u cha'täq'uib otot isqui bajca cuxlijob jinq'uin. Ajnijob ya' jini aj Pedro, aj Jacobo, aj Juan, aj Andrés, aj Felipe, aj Tomás, aj Bartolomé, aj Mateo, aj Jacobo ni ajlo' taj Alfeoba, aj Simón ni aj Zeloteba, y aj Judas ni u jitz'in aj Jacoboba. ");
INSERT INTO chfNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Upete ni jinijob ayan tomp'e u c'ajalinob, mach u yäcta u c'ajti'inob Dios y u c'änti'inob. Ajnijob ya'i täcä ixictacob. Ajni ix María u na' aj Jesúsba, t'oc täcä u jitz'inob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","De ya'i ch'oyi aj Pedro tänxin u lotob, ca' ciento veinte u q'ue'nanob, y u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Anela hermanos, c'änä pasic toj ca' chich tz'ibi tä jun, jini u worin äc'bi Ch'u'ul Pixan aj David u tz'ibänba, jini u tz'ibi cache' u xe u chen aj Judas ajye'bij tuba machcatac u xe u q'ueche' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aj Judas yaquinti täcä nämte' t'oc no'on t'ocob, äc'binti täcä u patan t'oc no'on t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jini winic u mäni ump'e cab t'oc jini taq'uin u tojquiba ni noj tanä que u chiba bajca u yäq'ui tä c'äbä aj Jesucristo. Ya'i chich u tzämsi uba. Ti isqui, bich'i yäli tä cab, pa'tajqui, laj pasi u bel u näc'. ");
INSERT INTO chfNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Upete aj Jerusalénob u yubijob cua' u chi pasa. Jin uc'a ni cab jini u ch'i u c'aba' tu t'anob unejobba Acéldama. U c'aba' jini cab tä yocot'anba Ch'ich' une. ");
INSERT INTO chfNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Uc'a ya' chich tz'ibi tä jun tä salmoba ca'da: Waläctintic bajca cuxli, mach ajnic machca cuxlec ya'i. U yäle' täcä ca'da: Ajnic otro u ch'ämben u patan. ");
INSERT INTO chfNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Ayanob wida machcatac paq'uin numi t'oc no'on t'ocob jinq'uin Cajnojala aj Jesús u yajne y u pase bajca anonla. ");
INSERT INTO chfNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jini ajnijob t'oc no'on t'ocob desde jinq'uin u chi c'ablesia aj Juan ixta que jinq'uin bixi aj Jesús isqui tä cielo täc jutlaba. C'änä ochic t'oc no'on t'ocob untu de ni jinijob tuba u yäle' cache' cuxpi chich aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","De ya'i u yäc'bijob wa'lec cha'tu: untuba aj José, u yälbinte täcä aj Barsabás, u chap'elib u c'aba' aj Justo, y ni untuba aj Matías. ");
INSERT INTO chfNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","U c'änti'ijob Dios, y u c'atbijob ca'da: ―Ane Cajnoja, a wi chich cache' an u pixan upete. Ye'benon t'ocob camba de ni cha'tudaba a wo ane xic de u jelo aj Judas, ");
INSERT INTO chfNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tuba ochic de a wajc'äncan y u ch'e' jini patan que u cänänti aj Judasba, uc'a aj Judas u tz'eji uba t'oc ni patan jini uc'a u tanä, tuba bixic une tu yajliba bajca u xe u ch'e' u castigo. ");
INSERT INTO chfNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","De ya'i u yäläsijob tuba u jiran machca u xe. Yäli tu c'äb aj Matías. Jin uc'a aj Matías äc'binti ochic t'oc ni otros once apóstolesjobba. ");
INSERT INTO chfNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jinq'uin c'oti ni q'uin ta utic jini q'uin ch'uje u c'aba' Pentecostés, upete machcatac u tz'omben u t'an aj Jesús u woyi ubajob tomp'e. ");
INSERT INTO chfNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tajtzäc ti tä cielo ca' ump'e noj gran ic' tä bänäcne, ubqui tama entero ump'e ni otot bajca chumcajob. ");
INSERT INTO chfNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","U chänijob q'uen ac' ca' a wälä c'ac' bajca anob, y u pucli uba tuyac'ojob. ");
INSERT INTO chfNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","De ya'i Ch'u'ul Pixan ochi tuyac'ojob tuba u chen lo que yo u chen t'oc unejob. U täq'uijob u chen tzoqui' t'an, ca' chich u yäc'benob u yäle' ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jimba q'uin jini ajnijob tä Jerusalén aj judíosob jini que mach u yäctajob u c'ajti'inob Diosba, ajtejob tä cabil cab. ");
INSERT INTO chfNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jinq'uin u yubijob tajbänäcna, u laj woyi ubajob ni noj q'uenel gente, y c'äsbäc'tijob, u yäle'ob cua' ti jini u chen pasa, uc'a u yubijob cache' cada juntu t'oc t'oc u t'anob. ");
INSERT INTO chfNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tajcolobijob, ch'icwäni u jutob, u yäle'ob: ―¿Mach quira aj galileojob upete ni jinda que mu' u t'anob? ");
INSERT INTO chfNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cache'da jiq'uin acubinla no'onlaba cache' u chenob jini t'an que ch'ijonla t'ocba? ");
INSERT INTO chfNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","No'onla ajtelonla tä cabil cab, tä Partia, tä Media, tä Elam, tä Mesopotamia, tä Judea, tä Capadocia, tä Ponto, tä Asia, ");
INSERT INTO chfNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","tä Frigia, tä Panfilia, tä Egipto, tä Africa jini nätz'ä t'oc tä Cireneba. Ajtelonla tä Roma, aj judíojonla t'oc täcä ajtzib ochejob. ");
INSERT INTO chfNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ajtelonla tä Creta y tä Arabia. Cäpetela t'oc t'oc cä t'anla cä laj ubila cache' u chi Dios tan pitzi. ");
INSERT INTO chfNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Upetejob tajch'icwäni u jutob, jobo u c'ajalinob, u maläc äle'ob ca'da: ―¿Cua' wäreca jinda? ");
INSERT INTO chfNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ajni täcä yebe que u tze'tanob, u yäle'ob ca'da: ―Ac'ac'a' chibälnijob. ");
INSERT INTO chfNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","De ya'i aj Pedro wa'wäni t'oc ni oncejobba, t'oc noj t'an u yäli: ―Anela lo' judíos, y apetela tä Jerusalén, äc'ä a chiquinla, ubinla cua' cä xe cälbenetla. ");
INSERT INTO chfNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mach ajchibalon t'ocob ca' a wäle'la ane, uc'a u totaj ch'i a las nueve isapan. ");
INSERT INTO chfNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jinda ni u yäli aj Joel, ajt'an ta Dios oniba, ni u yäli ca'daba: ");
INSERT INTO chfNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cä xe cä chen tu xupiba q'uin, u yäle' Dios ca'da, cä xe cä pucben cä Pixan tuyac'o upetejob. A ch'ocob wincäre, a ch'ocob ixictac u xe u yäle'ob u t'an Dios. Ch'oc ajlo'ilba ca' a wälä u chänen cua' chichca, noxibilba u xe u chen naja tan u wäye. ");
INSERT INTO chfNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jimba q'uin jini täcä cä xe cä pucbenob cä Pixan tuyac'o cajpatanob y tuyac'o quixpatanob; u xe u yäle'ob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cä xe cäq'ue' seña isqui tä cielo, y seña pancab: ch'ich' y c'ac' y butz' ca' yowox. ");
INSERT INTO chfNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Q'uin u xe tä it'obnan, uj u sujtä ca' a wälä ch'ich'. Jinda u xe u chen pasa antes que c'otic jini q'uin que u xe tä te Cajnojala t'oc u noj poder. ");
INSERT INTO chfNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jinq'uinba, upete machcatac u c'atben Cajnojala que u japänba, u xe chich u japän. ");
INSERT INTO chfNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Aj Pedro u yäli tä cha'num ca'da: ―Anela lo' Israel, ubinla ni t'anda: Jini winic aj Jesús aj Nazaretba, Dios chich u ye'betla cache' une u täsqui, uc'a u chi q'uen cua' chichca t'oc u poder, y u chi q'uen cua' chichca que mach bay u chi trebe u chen niuntu winic, y u chi täcä cua' chichca tuba chänintic. Dios chich u yäc'bi u chen ca' jini bajca anetla, ca' chich anela täcä a wila. ");
INSERT INTO chfNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jinchichba Jesús äc'qui ta' c'äbla ca' chich u yäq'ui Dios utic, uc'a che' chich worin ajni tu c'ajalin. Anelaba a q'uechila, a wäq'uila tu c'äb ajmalujlejob tuba u tzämsenob baja tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Une chich ni u tz'osi Dios tan ajchämejob, y u pa'säbi u poder chämo tuyac'o uc'a mach u ch'ä colac paq'uin chämen. ");
INSERT INTO chfNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Aj Jesús chich une ni u tz'aycun aj David oni jinq'uin u yäli ca'daba: Acä paq'uin chäni Ajnoja cache' ayan t'oc no'on. Uc'a ya'an täc noj, mach'an cua' u jobän cä c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jin uc'a ch'a'ali cäjin tan cä pixan, y ch'a'a cäjin cä chen t'an. Cä cuerpo täcä u c'alin pitän u q'uini que a xe a tz'osen tan ajchäme. ");
INSERT INTO chfNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Uc'a ane mach uxet a wäctan cä pixan tu yajliba ajchämejob. Ane mach uxet a wäq'ue' tä c'u'nan cä cuerpo täcä, no'on que a Ch'u'ul Winiconba. ");
INSERT INTO chfNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ane a ye'bon jini bij que u bixe bajca paq'uin cuxlec untu. Ane a xe a c'alin ch'a'alesbenon cäjin ajnicon bajca anet. ");
INSERT INTO chfNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Anela cä lot, a wila chich cache' cä papla aj David chämi, mujqui, y ya'to an u mujquiba bajca anonla bada. ");
INSERT INTO chfNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Uneba ajt'an ta Dios une, y yuwi chich cache' toj cua' u yälbi Dios. Dios u totoj älbi aj David cache' u xe u yäq'ue' untu de u natil ch'oc aj David ochic de ajnoja, ca' chich uneba. Jindaba aj Cristo une. ");
INSERT INTO chfNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Aj David worin yuwi ni jini, jin uc'a u yäli cache' aj Cristo u xe tä cuxpan, y u pixan mach uxin tä äctinte tan u yajliba ajchämejob, y u cuerpo mach uxin tä c'u'nan. ");
INSERT INTO chfNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jinchichba Jesús Dios u cuxpesi, cäpete t'ocob cä chäni t'ocob cache' toj. ");
INSERT INTO chfNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dios chich u bisi tä cielo t'oc u poder. Y u ch'i tu c'äb u Pap ni Ch'u'ul Pixan ca' chich älbintiba, jin uc'a u puqui jini a chänila samiba, jini a ubilaba. ");
INSERT INTO chfNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mach jin aj David ni t'äbi tä cieloba. Uneba u yäli ca'da: Ajnoja Dios u yälbi Cajnoja: “Chumi' täc noj. ");
INSERT INTO chfNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Pijnan cä'benet a tzupsäben u poder jini que mach yo u chänenetob. Ca' a wälä a xäc'teq'ue' t'oc a woc”. ");
INSERT INTO chfNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Wina'tanla jiq'uin tu toja apetela, lo' Israel, cache' jinchichba Jesús que a tzämsilaba, Dios u yäc'bi ajnic de Ajnoja y de Cristo, jini cä pitänlaba. ");
INSERT INTO chfNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jinq'uin u yubijob ca'da, ch'ocomi u pixanob y u yälbijob aj Pedro t'oc ni otros ajc'äncanob tuba aj Jesucristoba ca'da: ―Cä lot, ¿cua' c'änä cä chen t'ocob jiq'uin? ");
INSERT INTO chfNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Aj Pedro u yälbijob: ―Q'uexe a c'ajalinla tuba mach a ni' chen a tanäla, laj c'ablaquetla t'oc u c'aba' aj Jesucristo tuba pa'säbintiquetla a tanäla, y a xe a mätanla ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Uc'a ta'ala une jini u yäli Dios u xe u yäq'ue'ba, tuba a ch'ocob, tuba täcä upetejob machcatac an natba, upete machcatac Cajnojala Dios u xe u yacän tuba u japän uba. ");
INSERT INTO chfNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Q'uen otros t'an täcä u bon älbijob, y u yäc'bijob c'ajalin ca'da: ―Tz'eje abala t'oc ni genteda que mach unum tu tojaba. ");
INSERT INTO chfNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Machcatac u tz'ombi u t'an Dios jini u yäli aj Pedroba, c'ablesquintijob. Jinchichba q'uin ca' tuba uxp'e mil machcatac ochijob t'oc machcatac u tz'onänobba. ");
INSERT INTO chfNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","U nonoj sapijob ni c'ajalin u yäq'ui ni apóstoljobba, tomp'e u pixanob u lip'ijtanob waj tuba u c'ajti'inob cache' tzämsinti aj Jesús, y u c'änti'inob Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ch'icwäni u jut upetejob uc'a u chänenob cache' ni apóstoljob u chenob q'uen cua' chichca t'oc u poder Dios tuba chänintic. ");
INSERT INTO chfNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Upete machcatac u tz'ombi u t'an Dios tomp'e ayan u c'ajalinob y mul tubajob upete cua' chichca que u cänäntanob. ");
INSERT INTO chfNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","U chone'ob cua' chichca que u cänäntanob, y u cabob. U puclanob t'oc upete machcatac c'änäjtac uc'a. ");
INSERT INTO chfNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","U paq'uin ajnejob upete q'uin tan noj ch'u'ul otot, y u mul lip'ijtanob waj tu yototob tuba u c'ajti'inob cache' tzämsinti aj Jesús. Tomp'e u c'uxnanob t'oc ch'a'aljin, y mach'an cua' que mach utz tu pixanob. ");
INSERT INTO chfNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","U ch'u'ul c'ajti'inob Dios. Upetejob ni gente yo u chänenob. Ajnoja u yäq'ue' q'ue'nac upete q'uin machcatac mu' u japän uba. ");
INSERT INTO chfNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Aj Pedro nämte' t'oc aj Juan u bixejob tan noj ch'u'ul otot u horäji u c'änti'can Dios, tu yoche q'uin. ");
INSERT INTO chfNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ajni untu winic ajc'ol'oc que mach u ch'ä u chen xämba, uc'a che' chich u päncäbesi u na'. U lotob u täsen jini winic u yäq'ue'ob upete q'uin tu ti' noj ch'u'ul otot, u c'aba' u ti' jini noj ch'u'ul ototba Pitzi. U täsenob tuba u c'atben u matän jini machcatac u yoche tama noj ch'u'ul ototba. ");
INSERT INTO chfNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Jini winic u chäni cache' ya' u te aj Pedro y aj Juan, y u xe tä ochejob tama noj ch'u'ul otot. U c'atbenob que u yäc'ben u matän. ");
INSERT INTO chfNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aj Pedro y aj Juan u chämbenob u jut, y aj Pedro u yäli ca'da: ―Chänenon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Uneba ch'icwäni u jut tuyac'o, u pitän cua' u xe tä äc'binte. ");
INSERT INTO chfNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aj Pedro u yäli: ―Mach cä cänänta säsäc taq'uin ni c'änc'än taq'uin ta cä'benet. Jini acä cänäntanba, acä'benet: t'oc u poder u c'aba' aj Jesucristo aj Nazaret, ch'oyen, chen xämba. ");
INSERT INTO chfNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","U q'uechbi tu c'äb tu nojba, u wa'atz'i. Seb laj ajni u muc' yoc. ");
INSERT INTO chfNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Uneba wa'wäni tä sip'ajtäne y u chi xämba. Ochi t'oc unejob tan noj ch'u'ul otot. U chen xämba, u chen sip'ajtäne y u ch'u'ul c'ajti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Upetejob u chänijob cache' u chen xämba, y cache' u ch'u'ul c'ajti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Yuwijob chich cache' jinchichba winic ni u chumtä u c'atän u matän ti' ni noj ch'u'ul ototba, jini u c'aba' Pitziba. C'ac'a' bäc'tijob, ch'icwäni u jutob u chänenob cua' u chi pasa ni winic. ");
INSERT INTO chfNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jini winic que tz'äcälquiba ya' q'ueche u c'äb t'oc aj Pedro y aj Juan. Upetejob u woyli ubajob bajca anob pan noj ch'u'ul otot, bajca u yälcan cache' taj Salomón. Laj bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","U jiri ca' jini aj Pedro, u yälbijob ni gente ca'da: ―Anela lo' Israel, ¿cua' uc'a a bäc'tanla jinda? ¿Cua' uc'a a ch'icjatz'än a jutla täjcac'o t'ocob? ¿A wäle'la quira cache' t'oc cä poder t'ocob, o uc'a utzon t'ocob, cä'bi t'ocob u chen xämba jini winic? ");
INSERT INTO chfNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","U Dios aj Abraham, jinchichba Dios taj Isaac, taj Jacob y tuba upete cä noxi'paplajobba u yäq'ui tä chäncan u poder u Yajlo', aj Jesús une, jini a wäq'uila tä c'äbäba, jini mach a sapilaba jinq'uin aj Pilato u yoli u chaje'. ");
INSERT INTO chfNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Anela mach a sapila jini Ch'u'ul Winic que ayan tu tojaba. A c'atila chajbintiquetla untu ajtzämsa. ");
INSERT INTO chfNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A tzämsila ni machca u yäq'ue' cuxleconla. Ni jiniba Dios u cuxpesi tan ajchämejob. Cäpete cä chäni t'ocob cache' toj. ");
INSERT INTO chfNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ni winicda mu' a chänenla y a wila machca une, tz'äcälqui t'oc u c'aba' aj Jesús, uc'a u tz'ombi ca' chich aj Jesús u yäc'benonla cä tz'ombenla. Jin uc'a jini winic u c'alin pojli uba ca' chich mu' a chänenla apetela. ");
INSERT INTO chfNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Y bada cä lot, no'on cuwi cache' uc'a mach'an a c'ajalinla a chila ca' jini. Jin uc'a che' chich u chijob täcä a wajnojala. ");
INSERT INTO chfNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dios u yäq'ui tä ute ca' chich u yälbi u worin äle'ob u yajt'anob oni, cache' aj Cristo, ni yaquinti tuba ajmandaba, u xe tä tz'ibajtescan. ");
INSERT INTO chfNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Q'uexe a c'ajalinla jiq'uin, q'uexe a bijila, uc'a pa'säbintiquetla a tanäla y ca' jini ajnic ch'a'aljin ta' pixanla, jini u yäq'ue' Cajnojala Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Une u xe u täscun tä cha'num aj Jesucristo, jini a ubila cache' u xe tä teba. ");
INSERT INTO chfNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Aj Jesucristo c'änä ajnic tä cielo ixta que c'otic q'uin tuscac upete tu toja, ca' chich Dios u yäc'bi u yäle'ob upete u ch'u'ul ajt'anob, desde onijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Aj Moisés u yälbi cä noxi'paplajob oni ca'da: “A Wajnojala Dios u xe u yäc'benetla untu u yajt'an, untu de a lotla, ca' chich u yäc'on. Anela a xe a ubinla upete cua'tac u xe u yälbenetla. ");
INSERT INTO chfNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Machca chichca une que mach u tz'ombe jini u yajt'an Dios, u xe tä tzämsinte, mach u colesca t'oc u lotob”. ");
INSERT INTO chfNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ajt'an ta Dios u c'aba' aj Samuelba y upete ni ajt'anob ji'pät tijobba u yäli cua' u xe tä ajtä jimba q'uinobda. ");
INSERT INTO chfNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Upete ni u yäc'bi Dios u yäle' u yajt'anob cache' u xe u yäq'ue'ba, ta'ala une. Dios u tusi t'oc cä noxi'papla cua' u xe u cherbenetla jinq'uin u yälbi aj Abraham ca'da: “U xe tä ch'u'ul chercan upetejob pancab, uc'a untu a natil ch'oc”. ");
INSERT INTO chfNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios u täsqui u Yajlo' najtäcä bajca anetla anelaba tuba u ch'u'ul chenetla, tuba u yäc'benetla a q'uexe' a bijila y tuba u tz'eje'etla t'oc ni a chenla mach utzba. ");
INSERT INTO chfNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aj Pedro y aj Juan mu'to u t'an t'oc caj, c'oti palejob taj judíosob bajca anob, c'oti u noja ajcänänya tuba noj ch'u'ul otot, c'otijob täcä aj saduceojob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Cäräx'ijob uc'a xi tä älbinte caj cache' cuxpi aj Jesús, y che' chich u xe tä cuxpan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","U q'uechijob, u mäquijob preso ta päscab to, uc'a a'ochiq'uin. ");
INSERT INTO chfNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Q'uen machcatac u yubijob ni t'an jini u tz'onijob, c'oti ca' tuba cinco mil wincäre. ");
INSERT INTO chfNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Päscab u woyli ubajob tä Jerusalén ajnojajob tuba aj judíosob, y noxibilbajob, y machcatac yuwijob ni ley. ");
INSERT INTO chfNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","U woyli ubajob nämte' t'oc unejob täcä aj Anás u no' ajnoja pale, y aj Caifás, y aj Juan, y aj Alejandro y upete ni palejob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","U yäq'uijob tänxin unejob aj Pedro y aj Juan, u c'atbijob ca'da: ―¿Caxca t'oc u poder a tz'äcälila jini ajc'ol'oc? ¿Caxca u yäc'bet a chenla? ");
INSERT INTO chfNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aj Pedro, mäx ayan t'oc Ch'u'ul Pixan, u yälbijob: ―Anela ajnoja tuba caj, anela noxibilba tuba aj Israelob, ");
INSERT INTO chfNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","si jin uc'a a joc'on t'ocob, uc'a cä chi t'ocob utz t'oc untu c'ol winic, y si a wo a ubinla cache'da u pojli uba, ");
INSERT INTO chfNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","wina'tanla apetela jiq'uin, y co que u wina'tan täcä upete aj Israel, cache' t'oc u poder u c'aba' aj Jesucristo aj Nazaret, jini a tzämsila tä cruzba, jini Dios u cuxpesi tan ajchämejobba, jin uc'a an jinda winic que mu' a chänenlaba t'oc u yutzi. ");
INSERT INTO chfNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Aj Jesús une ni ji'tun que anela ca' ajcheraj ototetla a choquilaba, y bada ca' a wälä ch'ämqui tuba äc'cac de mero u ch'ixma yoc otot. ");
INSERT INTO chfNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mach'an niuntu otro u ch'e' u japänonla, uc'a mach'an niump'e otro c'aba' tu yaba cielo cä'bintela tuba cä japän cäbala. ");
INSERT INTO chfNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jinq'uin u chänijob cache' mach bäc'tajob aj Pedro y aj Juan, yuwijob täcä cache' mach ajnijob u laj cäne' u t'an Dios ni tz'ibiba, y mach tä' yuwijob cua' chichca, tajch'icwäni u jutob u chänen. Ti tu c'ajalinob täcä cache' jini winicob jini nämte' ajnijob t'oc aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","U chänijob täcä ni winic tz'äcälquiba cache' ya' wa'cajob t'oc, jin uc'a mach u pojlijob cua' u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","De ya'i u yälbijob pasic bajca woyojob, colobijob u maläc ch'e' u c'ajalinob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","U yäle'ob ca'da: ―¿Cache' cä xe cä cherbenla ni winicob jini? Uc'a upete aj Jerusalénob u yubijob cua' u chijob t'oc poder, y jinda mach u ch'ä cäle'la cache' mach toj. ");
INSERT INTO chfNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Cola cä bäc'tesanla uc'a mach u ni' tz'aycunob aj Jesús, uc'a mach u ni' wina'tanob otrojob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","U joq'uijob tuba u yälbenob que mach u ni' äle'ob, y mach u ni' ye'e'ob ni tz'ita' u t'an Dios tu c'aba' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aj Pedro y aj Juan u p'alijob: ―Äläla anelaba, ¿caxca une yo Dios cä tz'omben t'ocob, anela quira o Dios? ");
INSERT INTO chfNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mach u ch'ä cäctan cäle' t'ocob cua'tac cä chäni, y cua'tac cubi t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sujli u yälbenob tä cha'num que mach u ni' tz'aycunob aj Jesús, uc'a u yolijob u bäc'tesanob. De ya'i u chajijob bixic. Mach u pojlijob cua' u cherbenob uc'a bäc'tajob t'oc caj, uc'a upetejob täcä u ch'u'ul c'ajti'inob Dios uc'a ni u chijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ni winicda que tz'äcälqui t'oc u poder Diosba, noxi' winic une, u cänäntan más de cuarenta año u edad. ");
INSERT INTO chfNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cuanta chajquintijob aj Pedro y aj Juan, sujnijob bajca an u lotob y u laj tz'aycäbijob upete cua'tac älbintijob, y cua'tac u yälijob u yajnojajob pale y noxibilba. ");
INSERT INTO chfNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jinq'uin u yubijob, tomp'e u c'ajalinob u chijob noj c'änti'ya uc'a u yubin Dios, u yälijob ca'da: ―Cajnoja, ane ni Dioset, ane a chi cielo y u pancab, ane a chi nab y upete cua'tac ayan. ");
INSERT INTO chfNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ane a wälbi u yäle' aj David a wajpatan oniba ca'da: ¿Cua' uc'a cäräx u numejob ni gente, y ni caj u päpä' äle'ob cua' chichca tan u c'ajalin? ");
INSERT INTO chfNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ajnojajob tuba u pancab u woyli ubajob nämte' t'oc nuc ajt'äbäla tomp'e tuyac'o Ajnoja Dios, y tuyac'o aj Cristo täcä, ni u täsquiba. ");
INSERT INTO chfNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Uc'a toj chich cache' aj Herodes y aj Poncio Pilato nämte' t'oc aj gentilob y aj Israelob u woyli ubajob tama ni noj cajda tuba u jule' uba tuyac'o a Ch'u'ul Ajlo' aj Jesús, jini ane a yaquiba. ");
INSERT INTO chfNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","U woyli ubajob tuba u chenob ca' chich a woli ane uticba, y ca' chich worin ajni ta' c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bada Cajnoja, iran cache' yo u bäc'tesanon t'ocob. No'on que a wajpatanon t'ocob, äc'benon mach bäc'tacon cäle' t'ocob a t'an. ");
INSERT INTO chfNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Aneba sätz'ä a c'äb tuba a tz'äcälin c'ol winic, äc'ä tä ute cua' chichca t'oc poder y cua' chichca tä chäninte t'oc u c'aba' a Ch'u'ul Ajlo' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cuanta u chijob c'änti'ya, jini otot bajca u woyli ubajobba u niqui uba. Mäx ayanob t'oc Ch'u'ul Pixan, y mach u bäc'tijob u yäle' u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Upetejob machcatac u tz'ombijob u t'an Dios tomp'e u c'ajalinob y tomp'e u pixanob. Niuntu mach u yälä si juntu tuba, cua' chichca que u cänäntan. Upete cua' chichca mul tubajob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","T'oc noj poder ni apóstoljob u tz'aycunob cache' cuxpi Cajnojala aj Jesús, y Dios u bon ch'u'ul chenob upetejob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Niuntu de unejob mach c'änä uc'ajob niump'e cua', uc'a upetejob machcatac u cänäntan u cab, machcatac u cänäntan yotot, u chone', y ca' chich u chone'ob, che' chich u c'osenob u taq'uini. ");
INSERT INTO chfNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jini taq'uin u yäc'ben tu c'äb apóstoljob tuba u pucbenob machcatac c'änä uc'ajob. ");
INSERT INTO chfNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Untu aj levita, u c'aba' aj José, tä Chipre u cab. Ni apóstoljobba u q'uexbijob u c'aba' u yäc'bijob u c'aba' aj Bernabé. Ni c'aba'daba u yäle' tä yocot'an ca'da: untu winic ajch'a'alesiajin une. ");
INSERT INTO chfNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Uneba u cänänti ump'e u cab. U choni, y u täsi jini taq'uin tuba u yäc'ben tu c'äb ni apóstoljob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Untu winic u c'aba' aj Ananías t'oc jit'oc u c'aba' ix Safira u chonijob ump'e u cab. ");
INSERT INTO chfNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nämte' t'oc jit'oc u jeq'ui tz'ita' u taq'uini jini cab. Jin uc'a mach tz'äcä u bisijob tuba u yäc'ben tu c'äb ni apóstoljob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aj Pedro u yälbi ca'da: ―¿Cua' uc'a aj Satanás u yäc'bet ta' pixan a cherben jop'ojti' ni Ch'u'ul Pixan, y mach a wäq'ui tz'äcä u taq'uini ni cab? ");
INSERT INTO chfNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Mach quira ta'a chich ajni najtäcä? Jinq'uin a choni, ¿mach quira ta' c'äb ajni u taq'uini tuba a chen t'oc lo que a woli a chen? ¿Cua' uc'a jiq'uin ati ta' c'ajalin a chen ca' jini? Mach winicob a wälbi ni jop'ojti', Dios a cherbi jini jop'ojti'. ");
INSERT INTO chfNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jinq'uin u yubi ni t'anda aj Ananías, tenyäli tä cab, y chämi. Yäli noj bac'ät tuyac'o upete machcatac u yubi. ");
INSERT INTO chfNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ch'oyijob ni ch'octäc ajlo', u ch'ijob ni ajchäme u bisijob u muque'. ");
INSERT INTO chfNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","U chi ca' tuba uxp'e hora, de ya'i ochi jit'oc aj Ananías. Uneba mach yuwi cua' u chi pasa. ");
INSERT INTO chfNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aj Pedro u c'atbi täcä ca'da: ―Älbenon, ¿ca' chichda quira a choni ni cab? Une u yäli: ―Ca' chich jini. ");
INSERT INTO chfNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Aj Pedro u yälbi cha'num: ―¿Cua' uc'a a tusila ca' jini a cha'tumala a wälila a sucpecän u Ch'u'ul Pixan Ajnoja Dios? Ubin u xämba ya' u te ti' otot machcatac ajni u muque' a wit'oc, u xe u bisanetob täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Seb tenyäli jini ixic tu yoc aj Pedro, y chämi. Ni ch'octäc ajlo' ochijob u chänen cache' san chich achämi täcä. De ya'i u bisijob u muque' tu ch'ejpa jit'oc. ");
INSERT INTO chfNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Upete machcatac a'uti u woylan ubajob y upete machcatac u yubijob cua' u chi pasa, laj bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ni apóstoljob u chi q'uen cua' chichca t'oc poder y q'uen cua' chichca tä chäninte tan caj. Upetejob tomp'e u c'ajalinob u woylan ubajob tu pan jini noj ch'u'ul otot jini, bajca u yälbinte cache' taj Salomónba. ");
INSERT INTO chfNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Otrojob mach totoj yo ochicob t'oc. Cajba u yäle' cache' mäx utz cua' u chenob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Q'ue'nijob machcatac u tz'onän Cajnojala. C'ac'a' q'ue'nijob wincäre, che' ixictac. ");
INSERT INTO chfNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jin uc'a u yäq'ue'ob c'ol winic tan bij, u yäq'ue'ob t'oc u tz'en u yäq'ue'ob t'oc u ch'a'lib, bay toca tu nume aj Pedro u tulaj q'ueche'ob u bo'oy ni ajc'ojpan y ca' jini u pojlen ubajob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","C'otijob täcä tä Jerusalén q'uen ajnätz'älajob tä yänäl caj u c'osenob machcatac c'ojojtac y machcatac mu' u tz'ibajtesanob tzuc pixan. Upetejob u pojli ubajob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","De ya'i cäräx'ijob u no' ajnoja pale y upete machca ya'anob t'oc, ni jinijobba aj saduceojob. Cäräx'ijob uc'a mach yojob u chänen cua' u chen ni apóstoljob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","U q'uechijob ni apóstoljob, u yäq'uijob tä mäjcan tan cárcel ta caj. ");
INSERT INTO chfNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Jimba ac'äb untu ángelo tuba Ajnoja Dios u jäbbi u ti' bajca mäcäjob, u pa'sijob y u yälbijob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Correla tama noj ch'u'ul otot, y älben upetejob machcatac ayan ya'i jini t'an que u yäle' cache' u ch'e' paq'uin cuxlecob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","U yubijob ca' jini, tu junch'äcnan ochijob tan noj ch'u'ul otot u ye'e' u t'an Dios. C'oti no' ajnoja pale y machcatac ya'an t'oc une, y u woyijob täcä ajt'äbälajob jini a'äc'c'ajalinob tuba aj judíosobba, che' chich täcä noxibilbajob. U täsquijob tä ch'ämcan ni machca mäjquijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","C'otijob ni ajc'äncanob bajca mäcä, pero mach u pojlijob. De ya'i sujnijob u yäle' cache' mach'anob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","U yälijob ca'da: ―Mäcä chich u ti' ni cárcel bajca mäjquijobba y ni ajcänänyajob ya' chich anob tu ti' täcä. Pero jinq'uin cä jäbi t'ocob, mach cä pojli t'ocob niuntu tama. ");
INSERT INTO chfNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jinq'uin u yubijob ni t'anda ni no' ajnoja ta pale, y u noja ajcänänya tuba noj ch'u'ul otot, y che' chich täcä ajt'äbälajob ta pale, u yälijob ca'da: ―Cache' to ti da u xe tä colan jinda. ");
INSERT INTO chfNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","C'oti untu bajca anob u yäle': ―Ubixtola, ni winicob a wäq'uila tä mäjcanba ya'anob tan noj ch'u'ul otot u ye'benob caj u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","De ya'i bixi ajnoja t'oc ajc'äncanob tuba u ch'e'ob y u täsenob bajca anob. Mach u cherbijob cua', uc'a bäc'tajob t'oc caj, mach xic tä julcanob t'oc ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","U täsijob u yäq'uijob tu pänte' ajt'äbälajob jini a'äc'c'ajalinobba. De ya'i u no' ajnoja pale u c'atbijob: ");
INSERT INTO chfNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Mach quira cälbet t'ocob mach a ni' c'ajti'benla gente ni tz'ita' u t'an aj Jesús? Bada a laj ye'bila upete aj Jerusalénob. A wola a wäle'la cache' no'on t'ocob cä tzämsi t'ocob ni winic jini. ");
INSERT INTO chfNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aj Pedro y los demás apóstoljob u p'alijob ca'da: ―Más c'änä cä tz'omben t'ocob Dios que winicob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","U Dios cä paplajob oni u cuxpesi aj Jesús, jin chich ni a tzämsilaba, jini a sämbila u c'äb tä cruzba. ");
INSERT INTO chfNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uneba Dios u yäc'bi u poder tuba xic de Ajnoja y Ajjäpom, tuba u yäc'benob aj Israel u q'uexe' u c'ajalinob y tuba u pa'säben u tanäjob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Une u yacon t'ocob tuba cäle' t'ocob cache' toj chich upete u t'an. Jin chich täcä u yäq'ue' tä wina'tinte ni Ch'u'ul Pixan, jini Dios u yäc'bi tuyac'ojob machcatac u tz'ombenba. ");
INSERT INTO chfNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jinq'uin u yubijob ca'da, c'ac'a' cäräx'ijob, y u yoli u tzämsenob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ch'oyi tänxin ajt'äbälajob jini a'äc'c'ajalinobba untu aj fariseo u c'aba' aj Gamaliel. Uneba u ye'e' ni t'an ta Dios tz'ibiba. Tä' olo u chänenob upetejob. Une u yäq'ui tä nebaj pa'sintejob ni apóstoljob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","De ya'i u yälbi u lotob ca'da: ―Anela lo' Israel, ch'ä a c'ajalinla utz cua' a xe a chenla t'oc ni winicob jini. ");
INSERT INTO chfNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","A wila cache' najtäcä ch'oyi aj Teudas u yäli cache' une ajnoja, ca' tuba cuatrocientos winicob u woyi ubajob t'oc une. De ya'i uneba tzämsinti, y upete machcatac u tz'ombi u laj pucli ubajob, y laj xupijob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ji'pat ch'oyi aj Judas u cab tä Galilea. Jimba q'uin jini mu' u laj tz'ibinte u c'aba' ni gente tuyac'o jun, y q'uen u bisi tu pat. De ya'i chämi une, y upete machcatac ajnijob t'oc u laj pucli ubajob täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Y bada cälbenetla, a wäctanla ni winic jini, y mach a cherbenla cua'. Si tuba winicob ni c'ajalin jini que u yäq'ue'obba, y ni patan que u chenobba, u xe chich tä xupo une. ");
INSERT INTO chfNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Si tuba Diosba, mach uxet a chenla cua'. Iranla mach me'ixto xiquetla a jule' abala tuyac'o Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","U tz'ombijob u t'an aj Gamaliel. De ya'i u joq'uijob ni apóstoljob, u jätz'ijob, y u yälbijob que mach u ni' tz'aycunob aj Jesús, y u chajijob. ");
INSERT INTO chfNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ni apóstoljob pasijob bajca an ajt'äbälajob, ch'a'a ujinob uc'a äc'quijob tä tz'ibajtescan uc'a u tz'ombenob aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Upete q'uin tan noj ch'u'ul otot, y tä otote, mach u yäctajob u yäle' y u ye'e' ni t'an tuba aj Jesucristoba. ");
INSERT INTO chfNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jinq'uin q'ue'nijob machcatac u tz'omben Dios, aj griegojob cäräx'ijob t'oc aj hebreojob u yäle'ob que mach u chejob tu toja uc'a ni neba' ixictac tubajob mach u totoj äc'bintijob cua' chichca que u puquinte upete q'uin. ");
INSERT INTO chfNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jin uc'a ni doce apóstoljob u woyijob upete machcatac u tz'omben Dios y u yälbijob ca'da: ―Mach'an cua' uc'a cäctan t'ocob cä tz'aycun u t'an Dios uc'a ajnicon t'ocob cä pucän cua' chichca jini. ");
INSERT INTO chfNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bada jiq'uin cä lot, yacänla siete winic de a lotla, jini a wäle'la cache' utz u c'ajalinba, jini mäx ayanob t'oc ni Ch'u'ul Pixanba, jini mäx q'uen u c'ajalinobba, uc'a cä'ben t'ocob u chen jini patanda. ");
INSERT INTO chfNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","No'on t'ocobba cä xe cä chen segui cä chen t'ocob c'änti'ya, y cä paq'uin ye'benetla u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Upete tä' u yoli u yubinob ca' jini. Jin uc'a u yaquijob aj Esteban, untu winic mäx u tz'omben u t'an Dios y mäx ayan t'oc ni Ch'u'ul Pixan. U yaquijob täcä aj Felipe, aj Prócoro, aj Nicanor, aj Timón, aj Parmenas, y aj Nicolás, une ajji'pät oche t'oc aj judíosob une, ya' ti tä Antioquía. ");
INSERT INTO chfNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","U c'osijob ni winicob jini bajca an apóstoljob. De ya'i ni apóstoljob u c'änti'ijob Dios, y u yäq'uijob u c'äb tuyac'ojob. ");
INSERT INTO chfNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Q'ue'ni machcatac u yubi u t'an Ajnoja, y c'ac'a' q'ue'ni machcatac u tz'ombi Dios tä Jerusalén. Q'uen palejob täcä u tz'ombijob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aj Estebanba, tä' utz u c'ajalin y q'uen u poder Dios tuyac'o. U chi q'uen cua' chichca ta chänintic y q'uen cua' chichca tuba u ye'e' u poder Dios tan caj. ");
INSERT INTO chfNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ch'oyi tä t'an t'oc aj Esteban yebe machcatac u woylan ubajob tama ni ch'uj taj judíosob, jini u yälbinte cache' aj libertinojobba. Che' chich täcä aj Cirenejob, aj Alejandríajob, aj Ciliciajob, y aj Asiajob. ");
INSERT INTO chfNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Unejob mach uta tu c'ajalinob cache' u p'albenob u t'an aj Esteban, uc'a uneba q'uen u c'ajalin une, y ni Ch'u'ul Pixan u yäc'bi c'ajalin cua' u xe u yäle'. ");
INSERT INTO chfNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Unejob jiq'uin u yäc'bijob c'ajalin yebe tuba u chen jop'ojti' u yäle' ca'da: ―Acubi t'ocob cache' ni winicda u yäle' tzuc t'an tuyac'o aj Moisés, y tuyac'o Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","U jóbijob caj y noxibilbajob y jini machcatac yuwi ni ley taj Moisésba, y u juli ubajob tuyac'o aj Esteban. U q'uechijob, y u täsijob bajca an ajt'äbälajob jini a'äc'c'ajalinobba. ");
INSERT INTO chfNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","U c'osijob täcä ni ajjop'ojti' tuba u yäle'ob ca'da: ―Jini winicda mach u yäcta u chen tzuc t'an tuyac'o jinda ch'u'ul otot y tuyac'o ni t'an tz'ibi uc'a aj Moisésba. ");
INSERT INTO chfNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Cubi t'ocob u yäle' cache' jini aj Jesús aj Nazaretba u xe u jinesan jinda ch'u'ul otot y u xe u q'uexe' ni cua'tac u yäc'bonla cä chen aj Moisésba. ");
INSERT INTO chfNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Upete ajt'äbäla machca ya' chumcajob, ch'icwäni u jutob tuyac'o aj Esteban, y u chänijob cache' u jut es ca' u jut untu ángelo ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","U no' ajnoja pale u c'atbi ca'da: ―¿Toj quira ni mu' u yäle'obba? ");
INSERT INTO chfNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Une u yäli: ―Anela cä lot wincäre, anela ajt'äbäla, ubinla. Ni Dios ayan u poderba, c'oti bajca an cä papla aj Abraham oni jinq'uin ya'to an tä Mesopotamia, machto c'ax tä Harán. ");
INSERT INTO chfNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","U yälbi ca'da: “Pasen tama jini cabda, bajca an a familiajob, la'ix bajca cä xe cä ye'benet”. ");
INSERT INTO chfNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Une pasi tu cab aj Caldeojob, cuxli tä Harán. Ya'i chich chämi u pap. De ya'i Dios u yäc'bi c'axic wida bajca cuxuletla bada. ");
INSERT INTO chfNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mach u yäc'bi ni tz'ita' cab wida tuba nonoj colac tu c'äb, ni unlip' tuba wa'lec t'oc untz'it yoc. Ni u yälbiba, cache' u xe chich u yäc'ben une, y ji'pat u xe chich tä colan tuba u ch'ocob cuanta chämi une. Machto an u ch'ocob jinq'uin u yälbi ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios u worin älbi cache' u natil ch'ocob u xejob tä cuxtä nat tä yänäl cab. Ya'i u xe tä ajtäjob de ajpatan t'oc u yum, y u xe tä tz'ibajtescanob cuatrocientos años. ");
INSERT INTO chfNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Dios u yäli täcä ca'da: “No'on cä xe cä'ben u toje' u tanäjob u yumob bajca u tz'ibajtesanob. Ji'pat u xe tä pasejob y u xe u ch'u'ul c'ajti'inonob wida”. ");
INSERT INTO chfNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios u yälbi aj Abraham cua' u xe u chen por une. U yälbi u chen uba circuncisa tuba u ye'e' cache' u totoj tz'onän cua' u yäli Dios. Jin uc'a aj Abrahamba cuanta päncäbi aj Isaac u yajlo'ba, u chi circuncisa jinq'uin u tz'äctesi ocho día u päncäban. De ya'i aj Isaacba u pap aj Jacob, y aj Jacobba u pap ni doce cä noxi'paplajob oni. ");
INSERT INTO chfNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ni cä noxi'paplajob onidaba, cäräx'ijob, y mach u yoli u chänenob untu u jitz'in u c'aba' aj José. Jin uc'a u chombijob aj Egiptojob. Pero Diosba ya' chich ajni t'oc aj José. ");
INSERT INTO chfNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dios u japi t'oc upete tz'ibajtesia, u yäc'bi ajnic q'uen u c'ajalin tu pänte' aj Faraón, ajnoja tä Egipto. Aj Faraón tä' yoba u chänen. Jin uc'a aj Faraón u yäc'bi xic de ajch'och'oca ajnoja tä Egipto, y de ajch'och'oca ajnoja tan yotot täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Jimba q'uinob jini ajni noj wi'na tä Egipto y tä Canaán täcä, y noj gran jitz'o. Cä noxi'paplajob mach u pojlijob niump'e cua' tä c'uxcan. ");
INSERT INTO chfNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jinq'uin u yubi aj Jacob cache' ayan tä choncan trigo tä Egipto, u täsqui cä noxi'paplajob u mäne'. Jindaba primer to bixijob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jinq'uin bixijob tä cha'num, u säcunob u chi conoce aj José. Ca' jini aj Faraón u yubi caba familia ni aj José. ");
INSERT INTO chfNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","De ya'i aj José u täsqui tä jo'can tuba ticob tä Egipto aj Jacob u pap chichba, t'oc upete u familiajob, u q'ue'nanob setenta y cincojob. ");
INSERT INTO chfNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jin uc'a bixi aj Jacob tä Egipto. Ya'i chämi une, y cä noxi'paplajob täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jinq'uin chämijob bisintijob tä mujcan tä Siquem. Ya' mujqui tama jini cab que aj Abraham u mämbijob t'oc taq'uin u ch'ocob aj Hamor aj Siquemba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Jinq'uin anatz'äli q'uin tuba u chen Dios ni u yäliba, jini u totoj älbi aj Abraham cache' u xe u chenba, c'ac'a' q'ue'nijob chich u gente Dios tä Egipto. ");
INSERT INTO chfNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","De ya'i ch'oyi otro ajnoja que mach yuwi caxca une aj José. ");
INSERT INTO chfNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jini ajnoja uc'a mach utz u c'ajalin u tz'ibajtesi cä noxi'paplajob, y u cocoj äc'bijob u choque' u bijch'oc uc'a chämic y uc'a mach ni' q'ue'nacob. ");
INSERT INTO chfNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jimba q'uinob jini, päncäbi aj Moisés. Dios u chäni cache' pitzi ni ch'oc jini. Uxp'e mes tz'isinti tan yotot u pap. ");
INSERT INTO chfNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jinq'uin chojquiba, u jixic ch'oc aj Faraón u ch'i, y u tz'isi ca' mero u yajlo'. ");
INSERT INTO chfNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Aj Moisés u laj cäni upete c'ajalin taj Egiptojob. Tä' pitzi u t'an y tä' utz cua'tac u chen. ");
INSERT INTO chfNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Jinq'uin u tz'äctesi cuarenta año, ti tu c'ajalin xic u chänen u lotob, ni aj Israelobba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jinq'uin u chäni cache' untu u lot mu' u tz'ibajtesan aj Egipto, u japi. Tuba u japän, u tzämsi jini aj Egipto. Ca' jini u sutatz'bi u jelo jini que mu' u chenba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Aj Moisésba u yäli tan u c'ajalin cache' jini u lotob yuwijob cache' Dios u yäc'bi u japänob. Pero unejobba mach yuwi si ca' jini. ");
INSERT INTO chfNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Päscab c'oti bajca an cha'tu aj Israelob que mu' u buyajob. U yoli u yäq'ue' que mach u chenob buya, u yälbijob ca'da: “Cä lot, anelaba tomp'emp'e familiajetla. ¿Cua' uc'a a maläc tz'ibajtesan abala?” ");
INSERT INTO chfNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ni machca mu' u tz'ibajtesan u lotba u xälnoji aj Moisés, u yälbi ca'da: “¿Caxca u yäq'uet ane de ajnoja y de juez täc'a t'ocob? ");
INSERT INTO chfNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A wo quira a tzämsenon täcä ca' a tzämsi aj Egipto äc'bi?” ");
INSERT INTO chfNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jinq'uin u yubi ni t'an jini, putz'i aj Moisés tä yänäl cab u c'aba' Madián. Ya'i päncäbi cha'tu u yajlo'. ");
INSERT INTO chfNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Jinq'uin tz'äcti cuarenta año u chen vida aj Moisés ya'i, ump'e q'uin ya'an bajca an jini tz'ic u c'aba' Sinaí, bajca mach cuxu niuntu. U chäni cache' ca' a wälä mu' u pule ump'e chäcch'ix, y tama jini noj c'ac' untu ángelo ta Dios u pequi. ");
INSERT INTO chfNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jinq'uin u chäni aj Moisés jini c'ac', tajch'icwäni u jut. U natz'i tuba u chänen utz, y ya'i u yubi u t'an Ajnoja Dios, u yäle' ca'da: ");
INSERT INTO chfNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“No'on ni u Dioson a noxi'paplajob, u Dioson aj Abraham, aj Isaac y aj Jacob”. Jinq'uin u yubi aj Moisés chicchicna t'oc bac'ät y mach u ni' oli u chänen. ");
INSERT INTO chfNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ajnoja Dios u yälbi ca'da: “Pocho a pächi'oc ta' woc uc'a bajca ya' wa'caletba ch'u'ul cab une. ");
INSERT INTO chfNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","No'on acä chäni chich cache' mu' u tz'ibajtescanob cä ch'ocob ni ya'an tä Egiptoba. Acubi täcä u c'ämbajob, jin uc'a jacon cä japänob. Bada jiq'uin la'ix, cä xe cä täscunet tä Egipto”. ");
INSERT INTO chfNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Jini aj Moisés mach u sapijobba, jini que u yälbijob ca'daba: “¿Caxca u yäq'uet de ajnoja y de juez täc'a t'ocob?”, jin une u täsqui Dios de ajnoja y de ajjäpom. Dios u täsqui u ángelo tuba u yälben cua' u xe u chen, jini que ajni tan chäcch'ix u pecänba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jimba aj Moisés u pa'si aj Israelob tä Egipto. Jinchichba aj Moisés u chi q'uen cua' chichca t'oc poder ta chänintic tä Egipto, y tama nab u c'aba' Chäcba y bajca ajnijob cuarenta año bajca mach cuxu niuntu. ");
INSERT INTO chfNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jinchichba aj Moisés ni u yälbi aj Israelob ca'daba: “Cajnojala Dios u xe u yäc'benetla untu u yajt'an, untu de a lotla, ca' chich u yäc'on no'onba. Une c'änä a tz'ombenla u t'an”. ");
INSERT INTO chfNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Une chich ni u pequi ni ángelo ta Dios bajca an ni tz'ic tä Sinaí jinq'uin ajni t'oc ni noj q'uenel gente bajca mach cuxu niuntu, jini cä najtäcäl noxi'paplajobba. Une ni äc'binti ni t'an ta Dios tuba u yäc'benonla, jini t'an que u yäle' cache' u ch'e' paq'uin cuxleconlaba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Cä noxi'paplajob mach u yolijob u tz'omben u t'an aj Moisés, y mach u sapijob. Tan u pixanob ayan ca' yo sujlecob tä Egipto. ");
INSERT INTO chfNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","U yälbijob aj Aarón ca'da: “Chen untu cä diosla tuba xic pänte' de no'onla, uc'a mach cuwila cada an jini aj Moisés u pa'sonla tä Egiptoba, jini u täsonla widaba”. ");
INSERT INTO chfNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","De ya'i u pätijob ca' untu ch'oc beq'uet tuba ajnic de u diosob. U cherbijob cherajbuc'a y ch'a'ali ujinob t'oc jini u dios que u chijob t'oc u c'äbba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jin uc'a Dios u tz'eji uba t'oc unejob, y u yäcti que u päpä' c'ajti'inob jini uj y q'uin y ajlucerojob ya'an tä cieloba. Ca' jini pasi toj jini u tz'ibi ajt'anob ta Dios oniba, ni u yäle' ca'daba: Anela lo' Israel, ¿no'on quira ni a cherbonla ni cherajbuc'a jini a chila ca' ta cuarenta año bajca mach cuxu niuntu? ¿Uc'a quira a wäc'benon no'on a tzämsila ni äläq'ui? ");
INSERT INTO chfNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mach une. Anelaba cachichcada que numetla a bisila u yoc ch'uj aj Moloc, y u yajlucero a diosla Renfán jini a päpä' chila tuba a c'änti'inla. Jin uc'a cä xe cäq'ue' bisintiquetla más pänte' de Babilonia. ");
INSERT INTO chfNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Bajca mach cuxu niuntu ajni täcä tu c'äb cä noxi'paplajob oni jini ch'u'ul otot de noc' bajca u totoj chen t'an Diosba. Dios u yäq'ui tä ute, u yälbi aj Moisés u chen ca' chich ni u ye'biba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jini ch'u'ul otot de noc' äc'bintijob cä noxi'paplajobba, unejob chich u täsijob wida jinq'uin t'oc aj Josué u pa'si aj gentilob tan u cabob. Dios u pa'si aj gentilob tu jut cä noxi'paplajob. Ya'i coli ni ch'u'ul otot de noc' ixta u q'uini aj David. ");
INSERT INTO chfNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios ch'a'ali ujin t'oc aj David. Aj David u c'ati bintic u chen ump'e ch'u'ul otot tuba Dios, jinchichba Dios que u ch'u'ul c'ajti'i täcä aj Jacobba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero aj Salomón une ni äc'binti u cherben u yotot Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ajt'an ta Dios oni u yäli cache' Cajnojala Isqui mach u yajwan tama otot jini u yute t'oc u c'äb winicba. U yäli cache' Dios u yäle' ca'da: ");
INSERT INTO chfNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Cielo cä chumlib bajca cä chen manda, y u pancab ca' a wälä u läjquiba coc. ¿Cuaxca otot a xe a cherbenon? ¿Caxcada cä xe cä ch'e' cäba? Ca'da u yäle' Cajnojala Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","U yäle' täcä Cajnojala ca'da: ¿Mach quira no'on cä chi t'oc cä c'äb upete jinda? ");
INSERT INTO chfNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","U chi segui aj Esteban u yälbenob ca'da: ―Tzätz a pamla, y mach a tz'onäla t'oc a pixanla. Mach a ubila t'oc a chiquinla. Anelaba mach a tz'ombela ni Ch'u'ul Pixan. Ca' chich u chi a noxi'paplajob, che' chich a chenla täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Caxcamba ajt'an ta Dios mach u tz'ibajtesi a noxi'paplajob? U tzämsijob chich machcatac u worin äli cache' u xe tä te untu totoj Ajt'an ta Dios, jin une ni a wäq'uila tä c'äbäba y a tzämsila. ");
INSERT INTO chfNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Anela ya'an ta' c'äbla u t'an Dios, uc'a ángelo ta Dios u yäc'bi a noxi'papla, y anela mach a tz'ombila. ");
INSERT INTO chfNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jinq'uin u yubijob ca'da, c'ac'a' cäräx'ijob, cäch'äcna yejob t'oc cräxle tuyac'o aj Esteban. ");
INSERT INTO chfNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aj Estebanba mäx ayan t'oc Ch'u'ul Pixan. Ch'icwäni u jut tä cielo, u chäni cache' tä' pitzi bajca an Dios, u chäni täcä aj Jesús ya' wa'ca tu noj Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","U yäli ca'da: ―Ubinla, mu' cä chänen cache' jäbä ayan cielo, y u Yajlo' Dios que sutwäni de winicba ya' wa'ca tu noj Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Unejob u chi noj t'anob de cräxle. U mäqui u chiquinob, y upetejob u juli ubajob tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","U bisijob tu pat caj, u bon julijob t'oc ji'tun. Jin chich ni machcatac u julijob aj Esteban t'oc ji'tunba, u yäq'uijob u buc tu yoc untu winic u c'aba' aj Saulo. ");
INSERT INTO chfNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jinq'uin mu' u julcan aj Esteban t'oc ji'tun, une u c'änti'in Dios, u yäle' ca'da: ―Cajnoja Jesús, sapän cä pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nocwäni y u chi noj t'an ca'da: ―Cajnoja, mach a'benob u toje' ni tanäda. Jinq'uin u yäli ca'da, chämi. ");
INSERT INTO chfNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Aj Saulo u yäli tan u c'ajalin cache' utz chich tzämsintic aj Esteban, y mach u japi. Jimba q'uin jini ajni noj tz'ibajtesia tuba machcatac u tz'omben Cajnojala Dios tä Jerusalén. Upete laj bixijob tä putz'e tä Judea y tä Samaria, sec' apóstoljob coli. ");
INSERT INTO chfNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ni winicob tä' u c'ajti'in Diosba tulaj c'otijob tuba u bisan u muque' c'äsi' aj Esteban, y u bon uc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aj Sauloba u c'ac'a' tz'ibajtesi machcatac u tz'omben Cajnojala Dios. U yoche tama otote, u cocoj bisan wincäre, che' ixictacob, y u mäque' tä cárcel. ");
INSERT INTO chfNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Machcatac pasijob tä putz'e, cachichcada u bixejob u tz'aycun u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Aj Felipeba bixi tä Samaria, y une u tz'aycäbenob ya'i cache' aj Cristo ni Ajjäpom. ");
INSERT INTO chfNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Upetejob tomp'e u c'ajalinob u c'alin ubinob cua' u yäle' aj Felipe. U yubinob u t'an y u chänenob cua'tac u chen aj Felipe t'oc u poder Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Machcatac u cänänti tzuc pixan tuyac'o, t'oc noj t'an pasi jini tzuc pixan. Q'uen machcatac ca' chämen u cuerpo y machcatac mach u ch'ä u chen xämba, upete ni jini u laj tz'äcäli aj Felipe. ");
INSERT INTO chfNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jin uc'a ayan noj ch'a'aljin tuba ni gente tama ni caj jini. ");
INSERT INTO chfNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ajni untu winic tama jini caj u c'aba' aj Simón. Uneba ajtz'a'taya. U sucpequijob aj Samariajob, uc'a u tz'aycun uba cache' tä' q'uen u c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Upetejob u tz'ombijob u t'an, bijch'oc y ajt'äbäla, u yäle'ob ca'da: ―Jinda winic machtajda u yäc'bi u poder Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Upete u tz'ombijob uc'a bon jäläcni tama jini caj u sucpecänob t'oc u tz'a'taya. ");
INSERT INTO chfNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero jinq'uin c'oti aj Felipe u tz'aycäbenob u t'an Dios y u yälbenob cache' Dios ni mero Cajnojala y cache' aj Jesucristo u japänob, u tz'onijob y c'ablijob, wincäre y che' ixictacob. ");
INSERT INTO chfNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Aj Simón täcä u tz'oni ca' jini, c'abli, y u nume tu pat aj Felipe. Tajch'icwäni u jut u chänen cua' u chen y cua' u ye'e'. ");
INSERT INTO chfNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jinq'uin u yubijob ni apóstoljob ya'an tä Jerusalénba, cache' tä Samaria tz'ombinti u t'an Dios, u täsquijob ya'i aj Pedro t'oc aj Juan. ");
INSERT INTO chfNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jinq'uin c'otijob ya'i, u c'atbijob Dios que u yäc'benob aj Samariajob ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Uc'a mach to jac ni Ch'u'ul Pixan tuyac'o niuntu ya'i, sec' c'ablijob tu c'aba' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jinq'uin u yäc'bijob u c'äb tan u pamob, u ch'ijob chich ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jinq'uin u chäni aj Simón cache' tu yäc'ben u c'äbob ni apóstoljob tan u pam ni gente u ch'e'ob ni Ch'u'ul Pixan, u subbijob taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","U yäle' ca'da: ―Äc'benonla täcä cä chen ca' jini, uc'a machca chichca cä'ben täcä cä c'äb tan u pam u ch'e' Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aj Pedro u yälbi ca'da: ―Xupic a taq'uin t'oc ane, a wäle' ixti cache' matän ta Dios u tojcan t'oc taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ane mach a'bintet a wina'tan cache'da u yute jinda patan, uc'a a pixan mach tajtoj ayan tu jut Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Q'uexe a c'ajalin y äctan jinda a tanä, c'atben Dios, bay toca u pa'säbet ni a tanä jini ati ta' c'ajalinba. ");
INSERT INTO chfNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Uc'a aquiran que a cänäntan ump'e c'ajalin mach utz, ca' a wälä ump'e cosa tä' ch'aj, y ca' a wälä cächä anet t'oc a noj tanä. ");
INSERT INTO chfNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jinq'uin aj Simón u p'ali, u yäli ca'da: ―C'atbenla Cajnojala uc'a no'on, uc'a mach tic täjcac'o niump'e cua' ni a wäliba. ");
INSERT INTO chfNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jinq'uin ni apóstoljob u c'alin tz'ayqui u t'an Dios, sujlijob tä cha'num tä Jerusalén. Bajcatac numijob tama ni cab tä Samaria u tz'ayquijob cache' aj Jesucristo u ch'e' u japänob. ");
INSERT INTO chfNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Untu ángelo tuba Ajnoja Dios u pequi aj Felipe u yälben ca'da: ―Ch'oyen, cux bajca an jini bij tä sur, bajca mach cuxu niuntu, jini bij u te tä Jerusalén ixta tä Gazaba. ");
INSERT INTO chfNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aj Felipe ch'oyi, y bixi. U nuc'ti untu winic, u cab tä Etiopía. Uneba eunuco une, ajmanda tix Candace, ixnoja tuba aj Etiopíajob. Uneba u cänäntäben upete cua' chichca u cänäntan ni ixnoja jini. Ya' ati u ch'u'ul c'ajti'in Dios tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Sujtä u chen chumu tama u wawa'nib u tzique' jini jun u tz'ibi aj Isaías, ajt'an ta Dios oniba. ");
INSERT INTO chfNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ch'u'ul Pixan u yälbi aj Felipe ca'da: ―Cux, natz'än jini wawa'nib. ");
INSERT INTO chfNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aj Felipe seb c'oti t'oc ancäre bajca an, y u yubi cache' mu' u tzique' jini jun u tz'ibi aj Isaías, ajt'an ta Dios oniba. U c'atbi ca'da: ―¿A chen entende cua' mu' a tzique'? ");
INSERT INTO chfNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Une u yäli ca'da: ―¿Cache' cä xe cä chen entende si mach'an machca u ye'benon? De ya'i u yäc'bi aj Felipe ochic tä chumtä tu ch'ejpa. ");
INSERT INTO chfNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jini jun u tzique'ba u yäle' ca'da une: Bisinti une tä tzämsinte ca' untu oveja, y ca' ch'oc oveja mach u che t'an tu pänte' ni machca u susben u tzutze, ca' jini une täcä mach u yäli niump'e cua'. ");
INSERT INTO chfNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Une sojpätesqui, y mach cherbinti niump'e cua' tu toja. ¿Caxca une u xe u yäle' cache' utz cua' u chi a'ajtä pancab? Uc'a uneba tzämsinti. ");
INSERT INTO chfNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Aj eunuco u yälben aj Felipe ca'da: ―Älbenon, ¿caxcone ni ca' ch'oc oveja, jini u yäli aj Isaíasba? ¿Une chich quira, o otro? ");
INSERT INTO chfNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","De ya'i aj Felipe u täq'ui u tz'aycun ni t'an jini ya' tz'ibiba. Ca' jini xi u yälben ni aj eunuco ni t'an tuba aj Jesucristo. ");
INSERT INTO chfNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tu bixejob tä bij, c'otijob bajca an ja'. Aj eunuco u yäli ca'da: ―Ya'anda ja'. ¿U ch'e' quira c'ablacon bada? ");
INSERT INTO chfNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Aj Felipe u yäli ca'da: ―Si a totoj tz'onän t'oc a pixan aj Jesucristoba, u ch'e' chich. Une u p'ali: ―No'onba acä tz'onän chich cache' aj Jesucristo u Yajlo' Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","De ya'i u yäq'ui wa'lec ni wawa'nib, y u cha'tuma jaquijob tä ja'. Aj Felipe u c'ablesi jini aj eunuco. ");
INSERT INTO chfNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","T'äbijob tä cab. De ya'i ni Ch'u'ul Pixan tajnoja u ch'i aj Felipe u bisi. Aj eunuco mach ni' sujli u chänen. Ch'a'a ujin u chi segui u biji. ");
INSERT INTO chfNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Aj Felipeba c'oti tä Azoto. Pasi ya'i, bixi tä cabil cab u tz'aycun cache' aj Jesucristo u japän untu ixta que c'oti tä Cesarea. ");
INSERT INTO chfNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Aj Saulo cada u sapän ic'ba, u yoli u bäc'tesan y u tzämsen machcatac u tz'onän Cajnojala Dios. De ya'i c'oti bajca an u no' ajnoja pale. ");
INSERT INTO chfNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","U c'atbi jun tuba u bisan bajca an ch'u'ul ototob ya'i tä Damasco tuba u jiran si u pojlen machcatac u bisan ni bij jini, winic o ixic, tuba u täsen cächä tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","C'ote u chen tä Damasco, tajtzäc u chicti ump'e noj junch'äcni tä cielo bajca u bixe tä bij. ");
INSERT INTO chfNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Päcyäli tä cab, y u yubi ump'e t'an que u yälben ca'da: ―Saulo, Saulo, ¿cua' uc'a a tz'ibajtesanon? ");
INSERT INTO chfNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Une u yäli: ―Cajnoja, ¿caxcaba winiquet ane? Machca u chi t'an u yäli: ―No'on aj Jesúson jini a tz'ibajtesanonba. A sacän chich a yaj si a lomteq'ue' xec'onib. ");
INSERT INTO chfNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Chicchicna t'oc bac'ät, aj Saulo u yäli: ―Cajnoja, ¿cuaxca a wo cä chen? Ajnoja u yälbi ca'da: ―Ch'oyen, cux tan caj. Ya'i a xe tä älbinte cua' c'änä a chen. ");
INSERT INTO chfNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","U lotob u xe t'oc aj Sauloba tajcolijob tä wa'tä sin t'an. U yubijob t'an, y mach cheque caxca najt'an. ");
INSERT INTO chfNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ch'oyi aj Saulo tä cab, u jäbi u jut, mach u ni' che chanä. Päyä u c'äb u bisijob tä Damasco. ");
INSERT INTO chfNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ajni ya'i uxp'e q'uin mach u che chanä, mach c'uxni y mach buq'ui. ");
INSERT INTO chfNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jimba q'uin jini ajni tä Damasco untu ajcänt'an ta Dios u c'aba' aj Ananías. Ajnoja Dios u pequi ca' tan u naja u yälbi ca'da: ―Ananías. Une u p'ali: ―Ya'anonda, Cajnoja. ");
INSERT INTO chfNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ajnoja u yälbi ca'da: ―Ch'oyen, cux tä calle u c'aba' Tajtojba, sacän tu yotot aj Judas untu winic u c'aba' aj Saulo, u cab tä Tarso, uc'a une mu' u chen c'änti'ya, ");
INSERT INTO chfNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","y mu' u chänen ca' tan u naja untu winic u c'aba' aj Ananías cache' u yoche u yäc'ben u c'äb tan u pam tuba sujlec u chen chanä. ");
INSERT INTO chfNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Aj Ananías u p'ali: ―Cajnoja, q'uen machcatac u yälbon cache' jini winic q'uen malujle u cherbijob machcatac u tz'ombenetob tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y ajnoja tuba palejob u yäc'bi u q'ueche' upete machcatac u ch'u'ul c'ajti'in a c'aba'. ");
INSERT INTO chfNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ajnoja Dios u yälbi ca'da: ―Cux, uc'a uneba acä yaqui tuba cajc'äncan, tuba u tz'aycun cä t'an bajca an aj gentilob, bajca an ajnojajob, y bajca an aj Israelob. ");
INSERT INTO chfNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Uc'a cä xe cä ye'ben cache' u bon xe tä tz'ibajtescan uc'a u tz'aycun cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Aj Ananías bixi, ochi tan otot, y u yäc'bi u c'äb tan u pam, u yälbi ca'da: ―Hermano Saulo, Cajnoja aj Jesús, jin chich ni u ye'i uba bajca atet tä bijba, u täscon uc'a u jäbe' uba a jut y a chen chanä, y mäx ajniquet t'oc Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jinchichba rato jini yäli ca' u sul u jut, y sujli u chen chanä. De ya'i ch'oyi, y c'ablesqui. ");
INSERT INTO chfNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","C'uxni, u ch'i u muc' tä cha'num. Jäläcni tz'ita' aj Saulo bajca an ajcänt'anob ta Dios tä Damasco. ");
INSERT INTO chfNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","De ya'i aj Saulo seb u täq'ui ajne tan ch'u'ul otot tubajob, u yäle' cache' aj Jesúsba Ajlo' ta Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Upete machcatac u yubi u t'an tajch'icwäni u jutob u yubin, u yäle'ob ca'da: ―¿Mach quira jinda u tz'ibajtesijob tä Jerusalén machcatac u c'ajti'inob jini c'aba' taj Cristo, y jin uc'a ti wida, tuba u q'ueche' u bisan bajca an ajnojajob ta pale? ");
INSERT INTO chfNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aj Sauloba q'ue'ni u poder u yäle' u t'an Dios, u jobbijob u c'ajalin aj judíosob ni ya' laj cuxli tä Damascoba, uc'a u totoj ye'benob cache' aj Jesús ni aj Cristo que u täsqui Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ji'pat aj judíosob u maläc ch'i u c'ajalinob tuba u tzämsen. ");
INSERT INTO chfNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aj Saulo u yubi cua' u yoli u cherbenob. Unejob u ch'uquijob tä q'uin y tä ac'äb tu ti' ni caj jini, tuba u tzämsenob. ");
INSERT INTO chfNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","De ya'i ac'äb u yajcänt'anob Dios u jäcsijob aj Saulo pat u bojte'i caj tan chach. ");
INSERT INTO chfNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jinq'uin c'oti aj Saulo tä Jerusalén, u yoli ochic t'oc machcatac u tz'omben Dios ya'i. Unejobba bäc'tajob t'oc, uc'a mach u tz'onä si une täcä u tz'omben Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","U ch'i aj Bernabé u bisi bajca an ni apóstoljob, u tz'aycäbijob cache' aj Saulo u chäni Ajnoja tä bij y cache' u pequi, y cache' tä Damasco mach bäc'ti u tz'aycun aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","De ya'i u yajnejob t'oc cachichcada tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Une mach bäc'ta u chen t'an tu c'aba' Cajnojala aj Jesús, u yajne täcä tä t'an t'oc jini aj judíosob que u chen griegojt'an. Unejobba u sacän cache' u tzämsenob. ");
INSERT INTO chfNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jinq'uin u yubi ca' jini u lotob, nämte' bixijob t'oc tä Cesarea. De ya'i u täsquijob tä Tarso. ");
INSERT INTO chfNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mach ni' an machca u tz'ibajtesan machcatac u tz'ombenob u t'an Dios tä Judea, tä Galilea, y tä Samaria täcä. Colijob ch'ijcab. U c'alin cänijob, y u numejob u ch'u'ul c'ajti'in Cajnojala. U ch'a'alesbijob ujin ni Ch'u'ul Pixan, y q'ue'nijob. ");
INSERT INTO chfNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jinq'uin aj Pedro u nume cachichcada u jiran machcatac u tz'omben u t'an Dios, c'oti täcä tä Lida u jiranob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","U nuc'ti ya'i untu winic u c'aba' aj Eneas, ocho año ya'an tä tz'en, mach u ch'ä u nicän uba. ");
INSERT INTO chfNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Aj Pedro u yälbi ca'da: ―Eneas, aj Jesucristo u tz'äcälinet. Ch'oyen, ticän a tz'en. Une seb ch'oyi. ");
INSERT INTO chfNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Upete aj Lidajob y aj Sarónob u chänijob, y u ch'ämbijob u biji Cajnojala. ");
INSERT INTO chfNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ajni tä Jope untu ixic que u tz'omben u t'an Dios, u c'aba' ix Tabita. Tä griegojt'anba, ix Dorcas une. Jinda ixic utz cua' u paq'uin chen, y u täclen machca chichca une c'änä uc'a. ");
INSERT INTO chfNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jimba q'uinobda u q'uechi yaj, chämi. U mucsijob y u yäq'uijob tama u cha'täq'uib otot isqui. ");
INSERT INTO chfNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Machcatac u tz'omben u t'an Dios u yubijob cache' ya'an aj Pedro tä Lida, mach nat t'oc tä Jope. U täsquijob cha'tu ajc'äncan u ch'oc pecän u yälben ca'da: ―Seb tiquet bajca anon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ch'oyi aj Pedro, bixi t'oc unejob. Jinq'uin c'oti ya'i, u bisijob isqui tan otot. U xóyijob neba'täc ixictac tä uq'uejob, u ye'benob aj Pedro u buclajob jini u chuybijob ix Dorcas jinq'uin ya'to an t'oc unejobba. ");
INSERT INTO chfNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Aj Pedro u yäq'ui tä pase upete, nocwäni u c'änti'in Dios. De ya'i u suti uba u chänen ixchäme, u yälben: ―Tabita, ch'oyen. Une u jäbi u jut, u chänen aj Pedro, ch'oyi tä chumtä. ");
INSERT INTO chfNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Une u q'uechbi tu c'äb, u tz'osi. De ya'i u joq'ui machcatac u tz'omben u t'an Dios y neba'täc ixictac, u ye'benob cache' acuxpi. ");
INSERT INTO chfNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Upetejob tä Jope u yubijob cua' uti. Q'uen machcatac u tz'onijob Cajnojala. ");
INSERT INTO chfNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ya' jini jäläcni aj Pedro tä Jope tu yotot aj Simón untu ajtz'äcäl pächi. ");
INSERT INTO chfNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ajni untu winic tä Cesarea u c'aba' aj Cornelio, une ajnoja tuba cien soldado, jini u yälbinte aj Italianojobba. ");
INSERT INTO chfNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Uneba tä' u c'ajti'in Dios, y mach yo u säte' t'oc Dios, y che' chich täcä upete machcatac ayan t'oc tan yotot. Uneba q'uen cua' chichca jini u sijbenob machcatac c'änä uc'ajob tan caj, y u paq'uin c'änti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uneba u totoj chäni ca' tan u naja cache' tu yoche q'uin untu ángelo tuba Dios ochi bajca an, u pecän ca'da: ―Cornelio. ");
INSERT INTO chfNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Uneba ch'icwäni u jut u chänen, bäc'ti, u yäli ca'da: ―¿Cuaxca jini, Cajnoja? Ni ángelo u yälbi: ―A c'änti'ya y cua'tac a sijbi a lot u yubi chich Dios, jin uc'a u c'ajti'inet. ");
INSERT INTO chfNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bada jiq'uin täscun tä Jope ajc'äncanob u yälben tic aj Simón, jini u c'aba' täcä aj Pedroba. ");
INSERT INTO chfNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ya' cuxu tu yotot aj Simón ni ajtz'äcäl pächi, jini ya'an yotot ti' nabba. Une u xe u yälbenet cua'tac c'änä a chen. ");
INSERT INTO chfNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bixi jini ángelo ta Dios u pequi aj Cornelioba. Aj Cornelio u joq'ui cha'tu u yajpatan y untu u soldado ni chäcäl ch'o'o t'oc Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","U laj tz'aycäbijob upete cua'tac u chäni, de ya'i u täsquijob xic tä Jope. ");
INSERT INTO chfNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Päscab, jinq'uin xämba to u chenob tä bij ni ajc'äncan, tz'ita' yo ta c'oticob ti' caj, aj Pedroba t'äbi pat otot isqui tänxin q'uin tä c'änti'ya. ");
INSERT INTO chfNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tä' jitz'o u chen, u yoli c'uxnan. Mu'to u yute cua' u c'uxe'. De ya'i u chäni ca' tan u naja ");
INSERT INTO chfNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","cache' cielo jäbä. Ya' jini u te tä jaque ca' a wälä ump'e noj noc', t'oc chäntz'it u täbi tu ch'ixma jäcsinti tä cab. ");
INSERT INTO chfNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tama jini noc' ya'an upete ajchäntec oc, y ni u jolän uba tä cab täcäba, y mut ajwile isqui. ");
INSERT INTO chfNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","U yubi ump'e t'an que u yälben ca'da: ―Ch'oyen Pedro, tzämsen, y c'uxu. ");
INSERT INTO chfNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aj Pedro u yäli: ―Mach une Cajnoja. Mach bay cä c'uxi niump'e cua' mach utz c'uxcacba, niump'e cua' xilaw. ");
INSERT INTO chfNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sutwäni u yubin ni t'an tä cha'num u yälben ca'da: ―Jini Dios u yäle' que utz c'uxcacba, mach a wäle' ane cache' xilaw. ");
INSERT INTO chfNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ca'da uti uxpetz'. De ya'i jini noj noc' ch'ämqui cha'num tä cielo. ");
INSERT INTO chfNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Aj Pedro mu'to u ch'e' u c'ajalin cua' ti jini ni u chäniba, ajc'äncanob jini u täsquijob aj Cornelioba, tä bij tä bij ti u c'atänob ixta que c'otijob tu yotot aj Simón. ");
INSERT INTO chfNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","C'otijob u pecän ti' otot, u c'atänob si ya'an ya'i untu aj Simón u chap'elib u c'aba' aj Pedroba. ");
INSERT INTO chfNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Aj Pedro mu'to u ch'e' u c'ajalin cuaxca jini u chäni, u yälbi ni Ch'u'ul Pixan ca'da: ―Ya'an uxtu winic u sacänet. ");
INSERT INTO chfNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ch'oyen, jaquen. Mach a wäle' mach xiquet t'oc. No'on acä täsquijob. ");
INSERT INTO chfNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jaqui aj Pedro bajca an ni winicob u täsqui aj Cornelioba u yälbijob ca'da: ―No'on ni a sacänonlaba. ¿Cua' a t'an atetla? ");
INSERT INTO chfNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Unejob u p'alijob: ―Cajnoja t'ocob, aj Cornelio une, ajmanda ta cien soldado. Uneba untu winic que u chen tu toja, y mach yo u säte' t'oc Dios. Upete aj judíosob u yäle'ob cache' utz u c'ajalin. Untu ch'u'ul ángelo ta Dios u yälbi u täscunet tä jo'can tu yotot uc'a u yubin a t'an ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","U yälbijob ochic u ch'e' ubajob. Päscab ch'oyi, bixijob t'oc une. U lotob tä Jope tulaj bixijob t'oc, u lotin. ");
INSERT INTO chfNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Päscab c'otijob tä Cesarea. Aj Cornelio u woyi u familiajob y jini u lotob mäx nämä t'ocba u pijnanob aj Pedro. ");
INSERT INTO chfNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tu c'ote aj Pedro, pasi aj Cornelio u nuc'tan. Nocwäni tu yoc u c'änti'in. ");
INSERT INTO chfNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aj Pedro u yälbi ca'da: ―Ch'oyen. No'on täcä winicon chich, mach a c'änti'inon. ");
INSERT INTO chfNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","De ya'i ochi t'oc tä tz'aji. C'oti u chänen cache' q'uen woyo ayan. ");
INSERT INTO chfNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","U yälbijob ca'da: ―Anela a wila chich cache' aj judíosob mach u ch'ä u natz'än y mach u ch'ä xic bajca an machcatac ajpäpä'cabob. Diosba u yälbon que mach cä chen ca' jini, mach cälben niuntu cä lot cache' mach utz. ");
INSERT INTO chfNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jin uc'a jinq'uin a joc'on mach acäli mach ticon. Cä c'atbenet jiq'uin, ¿cuaxca tuba a täscon tä jo'can? ");
INSERT INTO chfNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","De ya'i aj Cornelio u yäli ca'da: ―Sami chämp'e q'uin ca' horada ochiq'uin ya'anon tä c'änti'ya täj cotot sin buc'a. Untu winic tutz'i bajca anon t'oc u c'äntz'alen buc. ");
INSERT INTO chfNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","U yälbon ca'da: “Cornelio, a c'änti'ya a'ubqui. Cua'tac a sijiba ya'an tu c'ajalin Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Täscun tä Jope tä ch'ämcan untu aj Simón, u chap'elib u c'aba' aj Pedro, ya' cuxu tu yotot aj Simón, jini ajtz'äcäl pächiba, nätz'ä ti' nab yotot. Tu te uneba a xe a ubin cua' u xe u yäle'”. ");
INSERT INTO chfNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jin uc'a seb cä täsquet tä ch'ämcan. Utz chich atet. Jin uc'a ya'anon t'ocob cäpete t'ocob bada tu pänte' Dios, tuba cubin t'ocob upete cua'tac u yäc'bet a wäle' Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","De ya'i u täq'ui t'an aj Pedro, u yäli ca'da: ―U te täj c'ajalin cache' toj que Dios mach u yänäl chäne untu pancab. ");
INSERT INTO chfNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Cachichcaba cab machca u ch'u'ul c'ajti'in une y u chen tu toja, uneba u sapän chich. ");
INSERT INTO chfNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios u täsqui tä älbinte aj Israelob jinda t'an, cache' aj Jesucristo une jini u yäq'ue' ch'a'aljinba. Uneba Ajnoja tuba upete. ");
INSERT INTO chfNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Anela a wila chich jinda t'an, cua'tac laj numi tä älcan tä Judea. Najtäcä u yäli aj Juan cache' c'änä c'ablacob upete. De ya'i tä'qui tä älcan tä Galilea jinda t'an, ");
INSERT INTO chfNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","cache' Dios u yaqui aj Jesús aj Nazaret, y u yäc'bi u Ch'u'ul Pixan tuyac'o, u yäc'bi poder täcä. Une numi u chen utz t'oc upete, u tz'äcäli machcatac u tz'ibajtesan tzuc pixan, uc'a Dios ya' chich an t'oc une. ");
INSERT INTO chfNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","No'on cä chäni t'ocob upete cua'tac u chi tä Judea y tä Jerusalén. Jin une ni u tzämsijob, u sämbijob u c'äb tä cruz. ");
INSERT INTO chfNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ni jini u cuxpesi Dios u yuxp'elib q'uin, u yäq'ui tä totoj chäncan cache' cuxpi chich. ");
INSERT INTO chfNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mach upete u chänijob, sec' machcatac Dios u worin äli cache' u xe u chänen. No'on cä chäni t'ocob, nämte' c'uxnon y buc'on t'ocob t'oc cuanta cuxpi tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aj Jesús u täscon cälben t'ocob upete caj u t'an Dios. U täscon cäle' t'ocob tu toja cache' une ni u yäq'ui Diosba tuba u yäle' catac an tu toja catac mach'an tu toja, ni cuxujobba y ni achämijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jinda une ni u yälijob upete ajt'anob ta Dios oniba, cache' upete machcatac u tz'ombenba, u xe tä pa'säbintejob u tanä t'oc u c'aba' aj Jesucristo. ");
INSERT INTO chfNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ya'to an tä t'an aj Pedro, ni Ch'u'ul Pixan ochi tuyac'o upete machcatac mu' u yubin jinda u t'an Dios que u yäle'ba. ");
INSERT INTO chfNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ni aj judíosob que u tz'omben Diosba, jini u lotob aj Pedro ti t'ocba, tajch'icwäni u jutob u chänen cache' Dios u yäc'bi aj gentilob ni Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Uc'a u yubijob cache' u chen yänäl t'anob y cache' u yäle'ob que utz cua' u chen Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Aj Pedro u yäli ca'da: ―¿Caxca une u xe u yäle' mach utz c'ablacob t'oc ja' jindajob que äc'bintijob Ch'u'ul Pixan ca' chich bintonla? ");
INSERT INTO chfNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","U yäq'ui tä c'ablanob tu c'aba' Cajnojala aj Jesús. Jini aj gentilob u yälbijob colac aj Pedro chap'e uxp'e q'uin ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ni apóstoljob y machcatac u tz'onijob ni ya'an tä Judeaba u yubijob cache' aj gentilob u sapijob täcä u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jinq'uin aj Pedro c'oti tä Jerusalén, aj judíosob u täq'ui u q'uejpanob aj Pedro. ");
INSERT INTO chfNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","U yäle'ob ca'da: ―¿Cua' uc'a ochet tan yotot ni winic mach jin aj judíosba? ¿Cua' uc'a c'uxnetob t'oc? ");
INSERT INTO chfNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aj Pedro u laj tz'ayqui tu toja upete cua'tac u chäni, u yäli ca'da: ");
INSERT INTO chfNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―No'on ya'anon tä Jope tä c'änti'ya, y cä chäni ca' tan cä naja cache' jaqui ump'e noj noc', t'oc chäntz'it u täbi tu ch'ixma, jäcsinti tä cielo, c'oti bajca anon. ");
INSERT INTO chfNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tajch'icwäni cä jut cä chänen. Cä chäni tama ajchäntec oc tuba u pancab, y te'el animajob, y jini u jolän uba tä cabba, y mut ajwile isqui. ");
INSERT INTO chfNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Cubi ump'e t'an que u yälbenon ca'da: “Ch'oyen, Pedro, tzämsen, c'uxu”. ");
INSERT INTO chfNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","No'on cäli: “Mach une, Cajnoja. Mach bay cäq'ui tan cä ti' niump'e cua' mach utz c'uxcacba, niump'e cua' xilawba”. ");
INSERT INTO chfNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Machca u chi t'an tä cielo u p'ali tä cha'num: “Jini Dios u yäle' que utz c'uxcacba, mach a wäle' ane cache' xilaw”. ");
INSERT INTO chfNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Uxpetz' uti ca' jini. De ya'i ch'ämqui tä cielo tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jinchichba rato c'oti tan otot bajca anon uxtu winic aj Cesareajob que täsquintijob u pecänon. ");
INSERT INTO chfNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ni Ch'u'ul Pixan u yälbon xicon t'oc, mach xicon cäle' cache' mach uxon. Ni seis winicobdaba ajnijob nämte' t'oc no'on, ochon t'ocob tan yotot jini winic. ");
INSERT INTO chfNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Une u tz'aycäbon t'ocob cache' u chäni untu ángelo ta Dios ya' wa'ca tan yotot. Jini ángelo ta Dios u yälbi ca'da: “Täscun tä Jope tä ch'ämcan aj Simón jini u c'aba' täcä aj Pedroba. ");
INSERT INTO chfNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Une u xe u yälbenet cache'da a xe a japän aba, aneba y upete machcatac an tan a wotot”. ");
INSERT INTO chfNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jinq'uin no'on cä täq'ui cä chen t'an, c'oti ni Ch'u'ul Pixan tuyac'ojob, ca' chich c'oti najtäcä täjcac'ola. ");
INSERT INTO chfNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jinq'uin cä c'ajna'ti u t'an Cajnojala, cache' u yäli ca'da: “Aj Juanba toj u chi c'ablesia t'oc ja'; anelaba a xe tä c'ablescanla t'oc Ch'u'ul Pixan”. ");
INSERT INTO chfNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dios u yäc'bijob jinchichba matän ca' chich u yäc'bonla jinq'uin cä tz'ombila Cajnojala aj Jesucristo. ¿Caxcajon no'onba tuba cäle' cache' mach utz cua' u chen Dios? ");
INSERT INTO chfNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jinq'uin u yubijob ca'da, tajch'icwäni u jutob, y u yälijob cache' utz cua' u chi Dios. U yälijob ca'da: ―¡Dios u yäc'bijob jiq'uin aj gentilob täcä u q'uexe' u c'ajalinob tuba paq'uin cuxlecob! ");
INSERT INTO chfNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Machcatac putz'ijob uc'a ni tz'ibajtesia jinq'uin tzämsinti aj Estebanba c'otijob ixta tä Fenicia, tä Chipre, y tä Antioquía. Mach u yälbijob machca ni t'an, sec' aj judíosob u yälbijob. ");
INSERT INTO chfNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tama jini machcatac putz'ijobba ajni aj Chiprejob y aj Cirenejob. Jinq'uin c'otijob tä Antioquía, u tz'aycäbenob täcä jini que mach jin aj judíosobba ni t'an utzba tuba Cajnojala aj Jesucristo. ");
INSERT INTO chfNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","U poder Cajnojala Dios ya'an t'oc unejob. Q'uen machcatac u tz'onijob, u ch'ämbi u biji Cajnojala. ");
INSERT INTO chfNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Cua'tac uti c'oti tu chiquinob aj Jerusalénob ni machcatac a'uti u woylan ubajobba. U täsquijob aj Bernabé xic tä Antioquía. ");
INSERT INTO chfNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jinq'uin c'oti u chänen cache' utz u c'ajalin Dios t'oc unejob, ch'a'ali ujin. U c'alin äc'bijob c'ajalin upetejob. U yälbijob u c'alin äq'ue' u c'ajalinob t'oc Cajnojala, y paq'uin ajnicob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Uc'a uneba untu winic utz u c'ajalin y mäx ayan t'oc Ch'u'ul Pixan, y mäx u tz'omben Dios täcä. Q'ue'nijob machcatac ochijob t'oc Cajnojala. ");
INSERT INTO chfNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ji'pat bixi aj Bernabé tä Tarso u sacän aj Saulo. U nuc'ti, y u täsi tä Antioquía. ");
INSERT INTO chfNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ump'e año u chijob t'oc machcatac a'uti u woylan ubajob ya'i, tä tz'ajijob t'oc, u ye'benob u t'an Dios u noj q'ue'na gente. Machcatac u tz'ombijob u t'an aj Cristo äc'binti u c'aba' cristianojob tä Antioquía najtäcä. ");
INSERT INTO chfNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jimba q'uinob jini ajt'anob ta Dios tä Jerusalén bixijob tä Antioquía. ");
INSERT INTO chfNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","De ya'i wa'wäni untu de unejob u c'aba' aj Agabo. U yäc'bi ni Ch'u'ul Pixan u yäle' cache' u xe tä te noj gran wi'na tu pancab. Che' chich ajni, jinq'uin aj Claudio ajnoja. ");
INSERT INTO chfNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Machcatac u tz'omben u t'an Dios u ch'ijob u c'ajalin tuba u täscunob tä täclintejob u lotob tä Jerusalén, u yäq'ue'ob bäye chichca u ch'e' u yäq'ue'. ");
INSERT INTO chfNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Che' chich u chijob. U täsquijob t'oc aj Bernabé y aj Saulo tuba u yäc'benob noxibilba tuba machcatac u tz'onän ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jimba q'uinob jini aj Herodes ajnojaba u jup'i u c'äb u tz'ibajtesan yebejob machcatac a'uti u woylan ubajob. ");
INSERT INTO chfNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","U yäq'ui tä tzämsinte aj Jacobo, u säcun aj Juan, t'oc untz'it cuchillo. ");
INSERT INTO chfNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","U chäni cache' ch'a'ali ujinob aj judíosob uc'a u chi ca' jini, u täsqui tä q'uechcan täcä aj Pedro, tan ni q'uin ch'uje jinq'uin u c'uxcan ni waj mach jusuba. ");
INSERT INTO chfNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","U q'uechi, u jup'i tä cárcel, u yäq'ui chänwoy de achänchäntu ajcänänya tuba u cänäntan. U yoli u pa'sen tu nume paxcu', tuba u jiran ni gente si ayan u tanä y u tzämsen. ");
INSERT INTO chfNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aj Pedro ya' mäcä tä cárcel, machcatac a'uti u woylan ubajobba mach u yäctijob u c'änti'in Dios uc'a aj Pedro. ");
INSERT INTO chfNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Päscab tu xe u pa'sen aj Herodesba, jinchichba ac'äb ya'an aj Pedro tä wäye tänxin cha'tu ajcänänya. Cächä ayan t'oc chatz'it u cächquiba. Ya'an täcä ajcänänyajob tu ti' cárcel u cänäntan. ");
INSERT INTO chfNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","U ángelo Ajnoja Dios c'oti ca'an, y ump'e noj junch'äcni u chicti tama cárcel. Jini ángelo ta Dios u niqui muc' tu ch'ejpa aj Pedro, u p'ixtesi u yälbi: ―Seb, ch'oyen. U cächquiba ajni tu c'äbba laj yäli tä cab. ");
INSERT INTO chfNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ni ángelo ta Dios u yälbi: ―Äc'ä a cächi' näc', äc'ä a pächi'oc. Che' chich u chi. U yälbi täcä: ―Äc'ä a buc tu pamba, la'ix täc pat. ");
INSERT INTO chfNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pasi, y bixi tu pat. Mach yuwi si toj ni u chi ni ángelo ta Diosba, u yäli bay u päpä' chäni. ");
INSERT INTO chfNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Numijob bajca an najtäcäl ajcänänyajob, u jeli. Numijob bajca an u chap'elib ajcänänyajob, u jeli täcä. C'otijob tu ti' cárcel ni de palibba, jini u xe tan cajba, u juntu jäbi uba. Pasijob, u numsi untz'it calle. Jinq'uin ni ángelo ta Dios u yäcti. ");
INSERT INTO chfNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","U ch'i u c'ajalin aj Pedro, u yäli: ―Bada cuwi chich cache' Ajnoja Dios u täsqui u ángelo, y u pa'son tu c'äb aj Herodes, u pa'son tu c'äb upete aj judíosob, jini u pijnanob cua' cä xe tä cherbinteba. ");
INSERT INTO chfNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Jinq'uin ti tu c'ajalin, bixi tu yotot ix María, u na' aj Juan; u chap'elib u c'aba' aj Juanba aj Marcos. Ya'i ya'an q'uen machcatac u woyi ubajob u c'änti'in Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Aj Pedro c'oti u jätz'e' ti' bojte' päti. Pasi untu telom u yubin, u c'aba' ix Rode. ");
INSERT INTO chfNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Jinq'uin u yubi cache' u t'an aj Pedro, uc'a ch'a'a ujin mach u jäbi ti' bojte'. Sutwäni t'oc ancäre tan otot, u yäle' cache' aj Pedro ya'an ti' bojte'. ");
INSERT INTO chfNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Unejob u yälbi: ―Mach'an a c'ajalin. Uneba u yäle' cache' toj chich ni mu' u yäle'ba. De ya'i unejob u yäli: ―Untu ángelo ti que Dios u täsqui tuba u cänäntan aj Pedro. ");
INSERT INTO chfNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Aj Pedro u bon pecänob. Jinq'uin u jäbijob y u chänijob cache' uneba, bäc'tijob. ");
INSERT INTO chfNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Uneba u chen u c'äb uc'a u ch'inajnesanob, u tz'aycäbenob cache' Ajnoja Dios u pa'si tä cárcel, u yäli: ―Täscunla tä älbinte täcä aj Jacobo y cä lotla. De ya'i pasi aj Pedro, bixi. ");
INSERT INTO chfNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tu t'äbo q'uin mach medio noj jobole ajni bajca an ajcänänyajob, u yäle'ob cada wäreca axi aj Pedro. ");
INSERT INTO chfNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Aj Herodes u täsqui tä saquinte aj Pedro, y mach pämi. Cuanta u c'atbijob ni ajcänänyaba, u täsqui tä tzämsintejob. Aj Herodes pasi tä Judea bixi tä Cesarea, y coli ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Aj Herodes cäräx t'oc aj Tirojob, y t'oc aj Sidónob. Unejob tomp'e u c'ajalin c'otijob tu yotot aj Herodes. Najtäcä u ch'oc pequijob aj Blasto, untu mero u yajnoja ajpatan tuba aj Herodes. Unejobba u c'atänob mach ni' cäräx'ac aj Herodes t'oc unejob. Uc'a tu cäji jini ajmanda ya' u ch'e'ob upete cuaxca c'änä uc'ajob. ");
INSERT INTO chfNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Aj Herodes u yaqui ump'e q'uin tuba u xoje' u pitzil buc y chunwänic tu noj chumlib u chen t'an tuba u yubin caj, y che' chich u chi. ");
INSERT INTO chfNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Upetejob ni gente u yäli: ―Dios une ni mu' u t'anba, mach jin winic. ");
INSERT INTO chfNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Seb ni ángelo tajnoja Dios u yäc'bi aj Herodes u yaj uc'a mach u c'ajti'i Dios. U laj c'uxbi u bec'ta noc', y chämi. ");
INSERT INTO chfNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ubqui u t'an Cajnojala cachichcada y c'ac'a' q'ue'ni machcatac u tz'onijob. ");
INSERT INTO chfNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Aj Bernabé y aj Saulo pasijob tä Jerusalén, uc'a u tzupsi cua' u chenob ya'i, c'otijob cha'num tä Antioquía. U bisijob täcä tu patob aj Juan, jini u chap'elib u c'aba' aj Marcosba. ");
INSERT INTO chfNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ajnijob t'oc täcä machcatac a'uti u woylan ubajob tä Antioquía ajt'anob ta Dios y ajye't'anob ta Dios: aj Bernabé, y aj Simón jini u yälbinte u c'aba' aj Nigerba, y aj Lucio jini u cab tä Cireneba, y aj Manaén jini ch'iji t'oc aj Herodes ajmanda tä Galileaba, y aj Saulo. ");
INSERT INTO chfNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jinq'uin unejob mu' u c'ajti'inob Dios sin buc'a, ni Ch'u'ul Pixan u yälbijob ca'da: ―Tz'ejbenon aj Bernabé y aj Saulo tuba u chen jini patan cä'bijob u chenba. ");
INSERT INTO chfNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Najtäcä ajni c'änti'ya sin buc'a, y ji'pat u yäc'bijob u c'äb tan u pamob aj Bernabé y aj Saulo, y u täsquijob bajca u xe. ");
INSERT INTO chfNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Cuanta u täsquijob ni Ch'u'ul Pixan, bixijob tä Seleucia. Pasijob ya'i, c'axijob tu pat nab c'otijob tama cab tä Chipre. ");
INSERT INTO chfNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Cuanta c'otijob tama ni caj tä Salamina, u täq'ui u yäle'ob u t'an Dios tan u ch'u'ul ototob aj judíosob ya'i, aj Juan täcä u täclenob t'oc jini patan. ");
INSERT INTO chfNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Numijob tama ni cab tä Chipre tama jini nab, ixta que c'otijob tä Pafos. Ya'i u nuc'tijob untu winic ajtz'a'taya, ajpäpä't'an u chen uba ca' totoj ajt'an ta Dios. Uneba aj judío une, u c'aba' aj Barjesús. ");
INSERT INTO chfNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jini winic ya'an t'oc ni ajmanda u c'aba' aj Sergio Paulo. Ni ajmanda jiniba, q'uen u c'ajalin une. Aj Sergio Paulo u joq'ui aj Bernabé y aj Saulo uc'a yo u yubin u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero aj Elimas, jini ajtz'a'tayaba, uc'a che' u pase u c'aba' täcä, u juli uba tuyac'ojob, mach yo u chänenob, y u yälben aj Sergio Paulo que mach u tz'omben u t'anob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Aj Saulo, jini u c'aba' täcä aj Pabloba, mäx ayan t'oc Ch'u'ul Pixan, y u chämben u jut. ");
INSERT INTO chfNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","U yälbi aj Elimas ca'da: ―Aneba q'uen a c'ajalin tuba a chen sucpecya, tuba a chen cua' chichca jini que mach utz, u yajlo'et diablo, mach a wo utic tu toja. Ane mach uxet a wäctan xic tajtoj ni bij tuba Ajnoja Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bada Ajnoja Dios t'oc u poder u xe u chenet castiga. A xe tä sujtä ajchoc', mach uni' xet a se'in chänen q'uin. De ya'i seb chich u bäli uba u chanä, sujli de ajchoc', pamajtan u nume u sacän caxca u päyben u c'äb. ");
INSERT INTO chfNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jini ajmanda u chäni cua' uti, u tz'oni. Tajch'icwäni u jut u yubin jinq'uin u ye'binte u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Aj Pablo pasi t'oc u lotob tä Pafos, bixijob tunxe nab tä Perge tama cab tä Panfilia. Jinq'uin aj Juan u yäctijob, sutwäni une tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Aj Pablojobba pasijob tä Perge, c'otijob tä Antioquía tama cab tä Pisidia. Tu q'uin ch'ämbäji ochijob tan ch'u'ul otot tä chumtä u yubin u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Najtäcä tzijqui ni ley y u t'an ajt'anob ta Dios oni, y ji'pat ajnojajob tuba ni ch'u'ul otot u täsqui tä c'atbintejob: ―Cä lot, si anela a wo a wäle'la cua' chichca jini tuba u yubinob ni caj, äläla. ");
INSERT INTO chfNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aj Pablo ch'oyi, u cherbi u c'äb ch'ijcäbacob, u yälbenob ca'da: ―Anela cä lot Israel y apetela machcatac a c'ajti'inla Dios, ubinla: ");
INSERT INTO chfNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","U Dios aj Israelob u yaqui cä paplajob, u q'ue'nesijob ya'to anob tan yänäl cab tä Egipto. Une u pa'sijob t'oc u poder ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ca' ta cuarenta año Dios u chi casujob bajca mach cuxu niuntu. ");
INSERT INTO chfNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Dios u tzupsi siete ajnojajob con to'o machcatac ayanob t'oc tama cab tä Canaán, u pucbijob aj Israel ni cab jini. ");
INSERT INTO chfNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Y de ya'i u yäq'ui ajnic juezob ca' cuatrocientos cincuenta año ixta que juli aj Samuel pancab, jini ajt'an ta Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jinq'uin u c'atbijob Dios ajnic untu mero u yajmanda. Dios u yäc'bijob aj Saúl, u yajlo' aj Cis, untu winic tuba u familia aj Benjamín tuba ajnic cuarenta año de u yajmandajob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","De ya'i Dios u pa'si ni jini, u yäq'ui aj David tuba xic de u yajmandajob. Dios u yäli cache'da ayan aj David jinq'uin u yäli ca'da: “Cä chäni cache' aj David u yajlo' aj Isaí untu winic tä' coba t'oc. U xe u chen upete ca' chich co no'on u chen”. ");
INSERT INTO chfNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","De u natil ch'ocob aj David Dios u yäq'ui aj Jesús tuba xic de Ajjäpom tuba aj Israelob, ca' chich u yäli u xe u chenba. ");
INSERT INTO chfNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mach to c'ot aj Jesús, aj Juan u yälbijob upete aj Israelob u q'uexe' u c'ajalinob tuba c'ablacob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jinq'uin aj Juan u chen u tzupsen u patan pancab, u yäli: “¿Caxcajon no'onba a wäle'la? Mach no'on une ni a wäle'laba. U te ji'pat que no'on untu, mach jinon niump'e cua' tuba cä p'ämben u täbi u pächi'oc”. ");
INSERT INTO chfNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Anela cä lot, u natil ch'ocob aj Abrahametla, machcatac de anela a ch'u'ul c'ajti'inla Dios, Dios chich u täscäbetla jinda t'an tuba a japän abala. ");
INSERT INTO chfNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Aj Jerusalénob y u yajnojajob mach yuwijob caxca une aj Jesús, y mach u chi entendejob u t'an ajt'anob ta Dios, jini u tzijcan upete q'uin ch'ämbäjiba. Jin uc'a u yäq'uijob tä chämo aj Jesús. Ca' chich ayan tz'ibi tä junba, che' chich u chijob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mach chich u pojläbijob niump'e u tanä tuba tzämsintic, pero u c'atbijob aj Pilato tuba u yäq'ue' tä tzämsinte. ");
INSERT INTO chfNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jinq'uin tz'äcti tä ute upete ca' tz'ibi tä jun de uneba, u pa'sijob tä cruz, y u muquíjob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero Dios u cuxpesi tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jini machcatac pasi t'oc aj Jesús tä Galilea c'oti t'oc tä Jerusalénba u bon chänijob chich cache' aj Jesúsba cuxu ayan. Unejob u yälbenob gente tu toja cache' u chänijob que cuxu ayan tä cha'num. ");
INSERT INTO chfNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’No'on t'ocob täcä cälbenetla jini t'an utzba, cache' Dios u chi chich ca' chich u yälbi cä noxi'paplajob u xe u chenba. ");
INSERT INTO chfNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ca' chich u yäli u xe u chen, u cherbonla bada uc'a u ch'ocobonla. U cuxpesi aj Jesús, ca' chich tz'ibi tama u chap'elib Salmo ni u yäle' ca'daba: “Ane Cajlo'et. Ane cä'bet cuxlequet bada”. ");
INSERT INTO chfNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios u yäli täcä cache' u xe u cuxpesan tan ajchämejob uc'a mach xic tä c'u'nan u cuerpo, jinq'uin u yäli ca'da: “No'on cä xe cä ch'ämbenetla yajin ca' chich cä totoj älbi aj David cache' cä xe cä chenba”. ");
INSERT INTO chfNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jin uc'a u yäle' täcä otro Salmo ca'da: “Mach uxet a'ben c'u'nac a Ch'u'ul Winic”. ");
INSERT INTO chfNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Toj chich aj David u chi pancab ca' chich u yoli Dios, de ya'i chämi, mujqui bajca mujqui u papob, y c'u'ni chich. ");
INSERT INTO chfNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jini u cuxpesi Diosba mach c'u'ni une. ");
INSERT INTO chfNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Äc'ä ta' c'ajalinla, cä lot, ni cälbenetla, cache' une chich ni u pa'sen a tanälaba. ");
INSERT INTO chfNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Une chich u yäq'ue' tu toja upete machcatac u tz'onän, uc'a mach colac t'oc niump'e u tanä. Ni ley taj Moisés mach u ch'ä u chen ca' jini, uc'a mach u ch'ä u yäq'ue' tu toja niuntu. ");
INSERT INTO chfNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iranla me'en, mach tic ta'wac'ola jini u yälijob ajt'anob ta Dios oniba, jinq'uin u yälijob ca'daba: ");
INSERT INTO chfNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Iranla, anela que mach a wo a tz'ombenla Dios, ch'icwänic a jutla, y cuxla tä säto; uc'a no'on cä xe cä chen ump'e cua' chichca t'oc poder bajca anetla, que anela mach uxet a tz'onänla jinq'uin ajnic machca u tz'aycäbenetla. Ca'da u yäli Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tu pasejob aj Pablo tan ni ch'u'ul otot tuba aj judíosob, aj gentilob u ch'oc chi ubajob t'oc uc'a tz'aycäbinticob tä cha'num ni t'an jini tu yälo u q'uin ch'ämbäji. ");
INSERT INTO chfNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tu bixejob machcatac u woyli ubajob, q'uen aj judíosob y ajtzib ochejob t'oc jini aj judíosob, jini mäx u c'ajti'in Diosba, bixijob tu pat aj Pablo y aj Bernabé. Aj Pablo y aj Bernabé u chi t'anob t'oc, u bon älbijob u paq'uin tz'onänob Dios, uc'a utz u c'ajalin t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tu c'ote u q'uin ch'ämbäji tä cha'num, u woyli ubajob casi upete a'ajtäjob tan caj tuba u yubinob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Jinq'uin u chänijob ca' jini aj judíosob, c'ac'a' cäräx'ijob, mach yo u chänenob cua' u chen aj Pablo. U juli ubajob tuyac'o, u yälijob cache' mach toj lo que u yäle'. U yälbijob tzuc t'an täcä tuyac'o. ");
INSERT INTO chfNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Aj Pablo y aj Bernabé sin bac'ät u yälbijob: ―Anela najtäcä älbintetla u t'an Dios, uc'a che' u yäq'ui Dios que utic. Anelaba mach a wo a ubinla, mach a wo äc'bintiquetla paq'uin cuxlequetla. Bada cä xe t'ocob bajca an aj gentilob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Uc'a ca'da u yälbon t'ocob Ajnoja Dios: Cä'bet ajniquet ca' a wälä ajchictaya tuba aj gentilob, tuba a wälben cache' u ch'e' u japän ubajob upete a'ajtä pancab. ");
INSERT INTO chfNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","U yubijob ca' jini aj gentilob, ch'a'ali ujinob, u yälijob cache' utz u t'an Dios. Upete machcatac worin yaquinti tuba paq'uin cuxlecob u tz'onijob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","U t'an Ajnoja Dios ubqui tama upete ni cab jini. ");
INSERT INTO chfNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Aj judíosobba u yäc'bijob c'ajalin ixictac jini mäx u c'ajti'in Diosba, jini toj u t'anba y noxibilbajob tan jini caj que mach u tz'ombenob u t'an aj Pablo. U yäq'uijob tä tz'ibajtescan aj Pablo y aj Bernabé, u pa'sijob tan u cabob. ");
INSERT INTO chfNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Unejob u tiquijob yoc t'oc pupuj cab tuba u ye'e' cache' ni gente tama ni caj jini mach u sapijob u t'an Dios, bixijob tä Iconio. ");
INSERT INTO chfNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mäx ch'a'a ujinob machcatac u tz'ombijob chich u t'an Dios, y mäx ayanob t'oc Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tä Iconio ochijob aj Pablo y aj Bernabé tan ch'u'ul otot taj judíosob, u tz'aycunob u t'an Dios. Jin uc'a q'uen aj judíosob u tz'onijob, u tz'onijob täcä aj griegojob. ");
INSERT INTO chfNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ni aj judíosob mach u tz'onijobba u jobbijob u c'ajalin aj gentilob u yäc'bijob ajnic jac' ujinob t'oc u lotob jini machca u tz'onijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mach uc'a jini bixicob. Tä' jäläcnijob ya'i. Mach u bäc'tijob u yäle' u t'an Ajnoja Dios, cache' utz u c'ajalin t'oc no'onla. Dios u ye'e' cache' toj u t'anob uc'a u yäc'bijob u chenob q'uen cua' chichca ta chänintic y tuba u ye'e' cache' an u poder Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","U jec'li ubajob cha'jec' ni caj. Unjec' ayan t'oc aj judíosob, y unjec' ayan t'oc ni apóstolesjob. ");
INSERT INTO chfNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","De ya'i aj judíosob y aj gentilob t'oc täcä u yajnojajob u yoli u tz'ibajtesanob y u jule'ob t'oc ji'tun. ");
INSERT INTO chfNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","U yubijob aj Pablo ca' jini, putz'ijob, y bixijob tä Listra y tä Derbe, jini chap'e caj jiniba ya'i chich tä Licaonia, y bixijob tu junxoyma cab. ");
INSERT INTO chfNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ya'i u tz'aycunob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ajni untu winic tä Listra, mach u ch'ä u chen xämba. Paq'uin chumu ayan. Che' chich u päncäbesi u na'. Mach bay u chi xämba. ");
INSERT INTO chfNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jinda winic u yubi u t'an aj Pablo. Aj Pablo u chämbi u jut, u chäni cache' u tz'onän tuba u yäq'ue' uba. ");
INSERT INTO chfNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","U yäli t'oc noj t'an: ―Ch'oyen, wa'i'. Seb ch'oyi jini winic, y u chi xämba. ");
INSERT INTO chfNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jinq'uin u noj q'ue'na gente u chänijob cua' u chi aj Pablo, u yälijob t'oc noj t'an, tu t'anob aj Licaoniajob: ―¡Dios jaquijob bajca anon t'ocob, ca' winic! ");
INSERT INTO chfNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Aj Bernabéba u yälijob cache' dios Júpiter, y aj Pabloba u yälijob cache' dios Mercurio uc'a une ni mero ajt'an. ");
INSERT INTO chfNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","De ya'i ni pale tuba ni dios Júpiter, jini u ch'uju ya'an ti' cajba, u täsi beq'uet y jit'i' nich te' tu ti' ch'uj uc'a u yoli une u chen cherajbuc'a t'oc caj tuba aj Pablo y aj Bernabé. ");
INSERT INTO chfNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jinq'uin u yubijob ca' jini aj Pablo y aj Bernabé, ni apóstolesjobba, u xet'ijob u buc, bixijob t'oc noj ancäre tama u noj q'ue'na gente. T'oc noj t'an u yälijob ca'da: ");
INSERT INTO chfNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Cä lot! ¿Cua' uc'a a xe a chenla ca'da? No'on t'ocob winicon t'ocob ca' chich anela. Cälbenetla a wäctanla jini a päpä' chenlaba. Tz'ombenla ni Dios cuxuba, jini u chi cielo, u pancab y nab, y upete cua' chichca ayan. ");
INSERT INTO chfNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ajniba Dios u yäctijob upetejob tuba u päpä' ch'e' u bijijob. ");
INSERT INTO chfNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero mach u yäcti u ye'e' cache' une ni Dios y u paq'uin chen utz t'oc no'onla. U yäc'benonla ja' isqui, u yäc'ben päc'äbi u chen u jut, u yäc'benonla na'aconla, y u tä' benonla ch'a'alac cäjinla. ");
INSERT INTO chfNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jinq'uin u yäli ca' jini aj Pablo y aj Bernabé, a la fuerza u q'uexbi u c'ajalinob tuba mach u cherbenob ni cherajbuc'a. ");
INSERT INTO chfNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Yebe aj judíosob ya' tijob tä Antioquía y tä Iconio c'otijob tä Listra u yäc'ben c'ajalinob u noj q'ue'na gente. U yäc'bijob t'oc ji'tun aj Pablo, jolo u pa'sijob tan caj uc'a u yälijob cache' san chämi. ");
INSERT INTO chfNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Machcatac u tz'ombi u t'an Dios u xóyijob aj Pablo. Une ch'oyi, ochi tan caj. Päscab bixi t'oc aj Bernabé tä Derbe. ");
INSERT INTO chfNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","U tz'ayquijob tama jini caj ni t'an ta Dios, y q'uen machcatac u tz'onijob. De ya'i sujnijob tä Listra, tä Iconio y tä Antioquía. ");
INSERT INTO chfNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","U yäc'bijob c'ajalin machcatac u tz'ombi u t'an Dios que mach bäc'tacob y mach sujlecob tu pat. U yälbijob täcä cache' c'änä tz'ibajtescaconla, uc'a ca' jini cochela bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Cachichcada tä cabil cab u yäq'uijob ajt'äbälajob tuba u chen mandajob machcatac u tz'omben u t'an Dios. U c'änti'ijob Dios najtäcä sin buc'a, u yäc'bijob tu c'äb Ajnoja jini u tz'ombijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Numijob tä Pisidia, c'otijob tä Panfilia. ");
INSERT INTO chfNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","U tz'ayquijob u t'an Dios tä Perge, de ya'i bixijob tä Atalia. ");
INSERT INTO chfNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ya'i c'axijob tunxe nab tä Antioquía, bajca pasijob najtäcäba, bajca äc'quijob tu c'äb Dios uc'a ajnic utz u c'ajalin Dios t'oc unejob tuba jini patan. Y bada sujlijob uc'a u tzupsijob chich ni patan jini. ");
INSERT INTO chfNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jinq'uin c'otijob, u woyijob machcatac a'uti u woylan ubajob, u tz'aycäbijob cache'da u chi Dios t'oc unejob y cache' mäx q'uen cua' jini u chi. U tz'aycäbijob täcä cache' Dios u yäq'ui täcä que aj gentilob u tz'onän. ");
INSERT INTO chfNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aj Pablo y aj Bernabé tä' jäläcnijob ya'i t'oc machcatac u tz'omben Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yebejob tijob tä Judea c'otijob tä Antioquía u yälbenob ni machcatac a'uti u woylan ubajobba: “Si mach a wäq'ue' aba tä ute circuncisala ca' chich tz'ibi uc'a aj Moisés, mach u ch'ä a japän abala”. ");
INSERT INTO chfNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Aj Pablo y aj Bernabé u bon chi t'an t'oc unejob. Machcatac a'uti u woylan ubajob u ch'i u c'ajalinob u täscunob aj Pablo y aj Bernabé tä Jerusalén, t'oc otrojob täcä, tuba u pecänob ni apóstolesjob y noxibilbajob uc'a u yubin si c'änä utic ca' u yäle'obba. ");
INSERT INTO chfNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Machcatac a'uti u woylan ubajob bixi u yäctanob tä bij. Unejob numijob tä Fenicia y tä Samaria, u tz'aycunob cache' aj gentilob u ch'ämbi u biji Dios. Upete machcatac u tz'omben u t'an Dios laj ch'a'ali ujinob u yubinob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","C'otijob tä Jerusalén. Machcatac a'uti u woylan ubajob ya'i y apóstolesjob y noxibilbajob tuba machcatac u tz'onän u yosijob bajca anob. Unejob u tz'aycäbijob upete cua' u chi Dios, jini que Dios u yäc'bi u chenobba. ");
INSERT INTO chfNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Yebe aj fariseojob machcatac u tz'onijobba ch'oyijob u yäle' ca'da: ―C'änä a'benob u chen ubajob circuncisa jini que mach jin aj judíosob, y a wälbenla u chenob ca' chich tz'ibi tama u jun aj Moisés. ");
INSERT INTO chfNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","U woyli ubajob ni apóstolesjob y noxibilbajob tuba u ch'e' u c'ajalinob cache'da u xe u chenob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Najtäcä u bon chi t'anob. De ya'i ch'oyi aj Pedro, y u yäli ca'da: ―Anela cä lot, a wila chich cache' oni Dios u yacon cäle' ni t'an ta Diosba uc'a u yubin aj gentilob y uc'a u tz'onänob täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios yuwi cache' ayan cä pixanla. Une u ye'i cache' u totoj tz'onijob uc'a u yäc'bijob ni Ch'u'ul Pixan ca' chich u yäc'bonla. ");
INSERT INTO chfNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios mach u yänäl chänonla t'oc unejob. Dios u pocbijob u pixanob uc'a u tz'onijob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bada jiq'uin, ¿cua' uc'a a wola a jaq'uesbenla ujin Dios, ca' a wälä a'benla tu p'ixte' machcatac u tz'omben uneba ump'e u cuch, jini ni cä paplajob mach bay u chi trebe u cuche' ni no'onla täcä? ");
INSERT INTO chfNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","No'onla cä tz'onänla cache' cä japintela uc'a utz u c'ajalin Cajnojala aj Jesús t'oc no'onla y che' chich täcä t'oc aj gentilob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Upetejob ch'ijcäbijob tuba u yubinob u t'an aj Bernabé y aj Pablo. Unejob u tz'ayquijob cua' u chi Dios, jini u yäc'bijob u chenob bajca an aj gentilobba, machtajda cua' chichca ta chänintic y cua' chichca jini u ye'e' u poder Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jinq'uin u tzupsi t'an aj Pablo y aj Bernabé, aj Jacobo u p'ali, u yäli ca'da: ―Anela cä lot, ubinla cä t'an. ");
INSERT INTO chfNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Aj Simón Pedro u tz'ayqui cache' Dios u täq'ui u ch'ämben yajin aj gentilob tuba u sacän tamajob machcatac u xe u tz'omben. ");
INSERT INTO chfNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ca'da u pase toj ni u tz'ibi ajt'anob ta Dios oniba, jini u yäle' ca'daba: ");
INSERT INTO chfNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ji'pat, cuanta u tz'ombon aj gentilobba, cä xe tä sujtä cä ch'ämben yajin aj Israelob tä cha'num. Cä xe cä tzijibesan u yotot aj David, ni yäliba, cä xe cä tzutzän bajca mach utzba. Cä xe cä cha'num tz'osen. ");
INSERT INTO chfNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Uc'a ca' jini upetejob u ch'e' u sacän Ajnoja, y upete aj gentilob u xe tä äc'binte u ch'u'ul c'ajti'inon. ");
INSERT INTO chfNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ca'da u yäle' Ajnoja Dios, jini machca u chen upete cua' chichcaba. Yuwi chich Dios chäcäl najtäcä cuaxca u xe u chen. ");
INSERT INTO chfNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Jin uc'a no'on acäle' mach c'änä cä jaq'uesbenla ujinob aj gentilob, jini u ch'ämbi u biji Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Cä tz'ibänla jun tuba cälbenobla namás que u tz'eje' ubajob t'oc santu uc'a mach u päc'chin u pixanob t'oc, y u tz'eje' ubajob t'oc cherajtz'ijte', y mach u c'uxe' jini u chämo yätz'ä u luc'ubba, y mach u c'uxe'ob ch'ich'. ");
INSERT INTO chfNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","C'änä u chenob ca' jini uc'a aj Moisés desde oni ayan uc'a upete caj machca u ye'e' u t'an tama ch'u'ul otot, y u tzijcan u t'an upete u q'uin ch'ämbäji ―ca'da u yäli aj Jacobo. ");
INSERT INTO chfNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","De ya'i ni apóstolesjob y noxibilba y upete machcatac a'uti u woylan ubajob u yälijob cache' utz yaquintic machca u xe tä täsquinte tä Antioquía t'oc aj Pablo y aj Bernabé. U täsquijob aj Judas, jini u chap'elib u c'aba' aj Barsabásba, y aj Silas, uc'a unejob más an u c'ajalinob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ni jun u tz'ibijob tuba u bisanobba u yäle' ca'da: “No'on t'ocob apóstolon t'ocob t'oc noxibilbajob y t'oc machcatac a'uti u woylan ubajob wida, cä täscäbenet t'ocob ni junda t'oc u c'aba' Dios. Ajnic a wutzila, anela cä lot gentil bajca anetla tä Antioquía, y tä Siria y tä Cilicia. ");
INSERT INTO chfNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Cubi t'ocob cache' yebejob pasijob wida c'otijob ya'i u jaq'uesan ajinla t'oc noj t'an, u jobbet a c'ajalinla u yälbetla cache' c'änä utiquetla circuncisa y a tz'ombenla ni ley taj Moisés. Unejobba mach no'on cä täsqui t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Cä woyli cäba cä ch'e' cä c'ajalin t'ocob tuba cä yacän machca cä xe cä täscun t'ocob bajca anetla uc'a xicob nämte' t'oc aj Bernabé y aj Pablo cä yajben lotla. ");
INSERT INTO chfNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jinijob mach bäc'tijob tzämsinticob uc'a u tz'aycun Cajnojala aj Jesucristo. ");
INSERT INTO chfNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jin uc'a cä täsqui t'ocob aj Judas y aj Silas uc'a u yälbenetla t'oc u ti' täcä ca' chich tz'ibi tuyac'o ni jundaba. ");
INSERT INTO chfNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ni Ch'u'ul Pixan u yäli, y che' chich acäli t'ocob täcä, cache' utz mach bintiquetla ca' a wälä a noj cuchla. Sec' jinda ni c'änä a chenlaba: ");
INSERT INTO chfNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tz'eje abala t'oc cherajbuc'a y mach a c'uxe'la ch'ich', y jini u chämo yätz'ä u luc'ubba, y tz'eje abala t'oc cherajtz'ijte'. Si a tz'eje' abala t'oc jini acäle'ba, utz chich cua' a chenla. Jin chich namás cälbenetla”. ");
INSERT INTO chfNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","De ya'i täsquintijob ni ajc'äncanob, c'otijob tä Antioquía. U yäc'bi u woye' ubajob ya'i, y u yäc'bijob ni jun jini tuba u tzique'ob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","U tziquijob, ch'a'ali ujinob t'oc ni c'ajalin täscäbintijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Aj Judas y aj Silas, uc'a unejob täcä ajt'anob ta Dios, u c'alin äc'bijob c'ajalin u lotob y u ch'a'alesbijob ujin t'oc ni noj q'uelen t'an u chijobba. ");
INSERT INTO chfNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chap'e uxp'e q'uin u chijob ya'i. U lotob ya'i u täsquijob tä cha'num bixic t'oc ch'a'aljin bajca an ni apóstolesjob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Aj Silasba u yoli colac ya'i, y coli chich. ");
INSERT INTO chfNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Aj Pablo y aj Bernabé täcä ya' colijob tä Antioquía u ye'e' u t'an Cajnojala, y nämte' t'oc q'uen u lotob u tz'aycun u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ji'pat tz'ita', aj Pablo u yälbi aj Bernabé ca'da: ―Cola quiranla tä cha'num ni cä lotla, y upete caj bajcatac anumon cä tz'aycunla u t'an Cajnojala, quiranla cache' ayanob machcatac u tz'oni. ");
INSERT INTO chfNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Aj Bernabé yoli u bisan aj Juan, jini u chap'elib u c'aba' aj Marcosba. ");
INSERT INTO chfNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Aj Pabloba mach u yoli u bisan, uc'a une u yäctijob tä Panfilia sutwäni tu pat, mach u yoli xic t'oc unejob u chen ni patan jini. ");
INSERT INTO chfNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mach tomp'e u c'ajalinob, jin uc'a u jeq'ui ubajob. Aj Bernabé u ch'i aj Marcos, bixi t'oc, c'axi tunxe nab tä Chipre. ");
INSERT INTO chfNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Aj Pablo u yaqui aj Silas, bixi t'oc. Najtäcä u lotob u yäc'bijob tu c'äb Ajnoja uc'a u cänäntanob, uc'a ajnic utz u c'ajalin Dios t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Numi tama noj cab tä Siria y tä Cilicia uc'a u yäc'benob c'ajalin machcatac a'uti u woylan ubajob, uc'a ca' jini u c'alin tz'onänob. ");
INSERT INTO chfNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ji'pat c'oti tä Derbe y tä Listra. Ajni ya'i untu que u tz'omben u t'an Dios u c'aba' aj Timoteo, u yajlo' untu ix judía, untu ixic que u tz'omben u t'an Dios täcä. U papba aj griego une. ");
INSERT INTO chfNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","U lotob tä Listra y tä Iconio u yäle'ob cache' jini aj Timoteo u chen tu toja. ");
INSERT INTO chfNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Jinda yo aj Pablo u bisan tu pat. U chi circuncisa uc'a ca' jini yojob utic ni aj judíosob ya'anob ya'iba, uc'a upete yuwi cache' u pap aj griego. ");
INSERT INTO chfNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tu numejob upete caj, u yäc'bijob u chenob ca' chich u yälijob utic ni apóstolesjobba y noxibilbajob tä Jerusalén. ");
INSERT INTO chfNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","U yäc'bijob u c'alin tz'onänob machcatac a'uti u woylan ubajob, y u bon q'ue'nanob upete q'uin. ");
INSERT INTO chfNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Numijob tä Frigia y tä Galacia uc'a ni Ch'u'ul Pixan mach u yäc'bijob u yäle' u t'an Dios tä Asia. ");
INSERT INTO chfNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","C'otijob tä Misia, u yoli xicob tä Bitinia. Ni Ch'u'ul Pixan mach u yäc'bijob xic ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Numijob ti' cab tä Misia, bixijob tä Troas. ");
INSERT INTO chfNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Binti u chänen aj Pablo ac'äb ca' tan u naja, untu winic, u cab tä Macedonia, que ya' wa'ca bajca an. Jini winic u ch'oc pecän, u yälben: “Tiquet tä Macedonia tuba a täclenon t'ocob”. ");
INSERT INTO chfNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Jinq'uin u chäni ca'da, seb cä saqui cache' bixicon t'ocob tä Macedonia, uc'a cä ch'i cä c'ajalin t'ocob cache' Dios yo que cälben t'ocob u t'an Dios machcatac ayan ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pason t'ocob tä Troas, cä ch'i t'ocob bij tajtoj tunxe nab tä Samotracia, y päscab c'oton t'ocob tä Neápolis. ");
INSERT INTO chfNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De ya'i c'oton t'ocob tä Filipos, noj caj ya'i tä Macedonia que u yute manda tä Roma. Jäläcnon t'ocob chap'e uxp'e q'uin ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tuyac'o ump'e q'uin ch'ämbäji pason t'ocob tan caj bixon t'ocob ti' pa', bajca u yute c'änti'ya. Chunwänon t'ocob, cä tz'aycäbi t'ocob u t'an Dios jini ixictac u woyli ubajobba. ");
INSERT INTO chfNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Untu ixic u c'aba' ix Lidia ya'an u yubin. Uneba ixchon ic'puq'uen noc', ya' ti tä Tiatira, y u ch'u'ul c'ajti'in Dios. Cajnojala u jäbbi u pixan ni ixic jini tuba u yäq'ue' u c'ajalin u yubin cua'tac u yäle' aj Pablo. ");
INSERT INTO chfNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","C'abli t'oc machcatac an tan yotot. U ch'oc pecon t'ocob, u yäli: ―Si a wäle'la cache' cä totoj tz'ombi Cajnojala, xiquetla täj cotot, ya' chich u ch'e' colaquetla. U cocoj bison t'ocob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ump'e q'uin täc bixe t'ocob bajca u yute c'änti'ya pasi u nuc'tanon t'ocob untu telom ya'an untu tzuc pixan tuyac'o tuba u yäle' cua' u xe tä ajtä. U yumob q'uen u chen gana uc'a ni ixic jini, uc'a jini ixic u pa'sen suerte. ");
INSERT INTO chfNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Jini ixic bixi tu pat aj Pablo y täc pat t'ocob, t'oc noj t'an u yäle' ca'da: ―Jinda winicob u yajpatanob ni Dios an isquiba, u yälbenetla camba ni bij tuba a japän abala. ");
INSERT INTO chfNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Che' chich u bon chi upete q'uin. Jaq'ui ujin aj Pablo, u suti uba u yälben ni tzuc pixan ca'da: ―Cälbenet t'oc u c'aba' aj Jesucristo, pasen tuyac'o ni ixic jini. Pasi jinchichba rato. ");
INSERT INTO chfNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","U yumob ni ixic u chänijob cache' mach ni' an modo u chen gana, u q'uechijob aj Pablo y aj Silas, u bisijob tänxin caj bajca an ajmandajob. ");
INSERT INTO chfNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","U yäq'uijob tu pänte' ajmandajob, u yälbenob: ―Jinda winicob, aj judíosob, u jobben u c'ajalin cä lotla tan caj. ");
INSERT INTO chfNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","U yäle'ob cua' chichca jini utic que mach u ch'ä cä sapänla y ni cä chenla uc'a aj romanojonla. ");
INSERT INTO chfNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","De ya'i caj u juli uba tuyac'ojob. Ajmandajob u tzilbi u buc y u pa'säbijob tuyac'o, u täsquijob tä äc'binte t'oc te'. ");
INSERT INTO chfNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Najtäcä u c'ac'a' bijob t'oc te', ji'pat u yäq'uijob tan cárcel, u yälbi ajcänän cárcel u c'alin cänäntanob uc'a mach xicob tä putz'e. ");
INSERT INTO chfNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cuanta älbinti ca' jini, u ch'i aj Pablo u yäq'uijob tama jini cárcel que ya'an más tama ni noj cárcelba, u net'bijob yoc tama lowo' te'. ");
INSERT INTO chfNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tänxin ac'äb aj Pablo y aj Silas ya'an tä c'änti'yajob y u chenob c'ay tuba Dios; machcatac ya' mäcäjob u yubijob. ");
INSERT INTO chfNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tajtzäc numi ump'e noj re'i ajchaban, u niqui uba mero u ch'ixma yoc ni cárcel, upete u mäcti' seb u laj jäbi uba. U laj p'äni uba täcä u cächquibajob upete. ");
INSERT INTO chfNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","P'ixi ajcänän cárcel u chänen cache' jäbäjtac u ti' cárcel, u päyi u machit u xe u tzämsen uba, uc'a u yäli cache' san laj putz'i machcatac mäcä. ");
INSERT INTO chfNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Aj Pablo t'oc noj t'an u yäli: ―Mach a xeq'ue' aba, uc'a cäpete t'ocob ya'anon t'ocobda. ");
INSERT INTO chfNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ajcänän cárcel u c'ati cua' t'oc u chictan, de ya'i ochi tama cárcel, liclicna t'oc bac'ät, nocyäli tu yoc aj Pablo y aj Silas. ");
INSERT INTO chfNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","U nebaj pa'sijob u yälbenob ca'da: ―Anela cä lot, ¿cua' c'änä cä chen tuba cä japän cäba? ");
INSERT INTO chfNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Unejob u yäli: ―Tz'omben Cajnojala aj Jesucristo y une u xe u japänet, aneba y che' chich täcä machcatac an tan a wotot. ");
INSERT INTO chfNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","U tz'aycäbijob u t'an Cajnojala tuba u yubin uneba y upete machcatac an tan u yotot täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jinchichba hora jini ac'äb u bisijob, y u pocbenob u yaj bajcatac u ch'ijob t'oc te'. Uneba c'ablesquinti y upete machcatac ya'anob tan yototba. ");
INSERT INTO chfNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","U bisijob tu yotot, y tusbinti cua' u c'uxe'ob. Ch'a'a ujin une y upete machcatac an tan yotot, uc'a u tz'ombijob Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tu t'äbo q'uin ajmandajob u täsquijob ajc'äncan u yälben ni ajcänän cárcel ca'da: ―Äctanob tä bixe ni winicob jini. ");
INSERT INTO chfNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ajcänän cárcel bixi u yälben aj Pablo ni t'anda: ―Ajmandajob u täsqui ajc'äncan u yälbenon cä pa'senetla. Bada jiq'uin ch'ä a bijila y pasenla, mach ni' an cua'. ");
INSERT INTO chfNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","De ya'i aj Pablo u yäli: ―Unejob u jätz'on t'ocob tänxin caj sin niump'e cä tanä t'ocob, aj romanojon t'ocob, u yäc'on t'ocob tan cárcel. ¿Bada yojob quira pasicon t'ocob mucu? Mach uxon tä pase t'ocob ca' jini. C'änä ticob une u pa'senon t'ocob. ");
INSERT INTO chfNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ajc'äncanob sujnijob u yälben ajmandajob. Bäc'tijob uc'a u yubijob cache' aj romanojob. ");
INSERT INTO chfNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","C'otijob ni ajmandajob u c'atben que u chen perdona t'oc lo que u cherbijob. U pa'senob, u ch'oc chen ubajob t'oc, u yälbenob que pasic tama ni noj caj jini. ");
INSERT INTO chfNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","De ya'i pasijob tama ni cárcel, bixijob tix Lidia. Aj Pablojob u chäni machcatac u tz'omben Dios, u yäc'bijob c'ajalin tuba u c'alin tz'onänob más, y pasijob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Numijob tä Anfípolis y tä Apolonia, c'otijob tä Tesalónica, bajca an ch'u'ul otot taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Aj Pablo, ca' chich nämä u chen, ochi tama ni ch'u'ul otot tuba ni aj judíosob. Uxp'e u q'uini ch'ämbäji ajni tä tz'ajijob t'oc, u c'ajti'benob ni ya' tz'ibi tan u jun Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","U yälbenob y u ye'benob bajca tz'ibi tä jun cache' c'änäli tz'ibajtescac aj Cristo, y cuxpac tan ajchämejob. U yälbijob täcä: ―Jini aj Jesús mu' cälbenetlaba, aj Cristo une ni u täsqui Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yebe aj judíos u tz'onijob, y u yoli ubajob t'oc aj Pablo y aj Silas. Tä' q'uen aj griegojob, jini nämäjob u c'ajti'in Diosba, y machtajda ixictac ixt'äbälajob tuba caj täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Aj judíosob ni machcatac mach u tz'onäjobba cäräxtacob, mach yojob u chänen ca' jini. U saquijob ajmech'lejob jini wa'ajtan u numejobba y u woyijob q'uen. U jobbijob u c'ajalin caj y u xóybijob yotot aj Jasón uc'a u pa'senob aj Pablo y aj Silas tuba u bisbenob caj. ");
INSERT INTO chfNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mach u nuc'tijob aj Pablojob. U bisijob aj Jasón t'oc u lotob tä juezob ta caj, t'oc noj t'an u yälijob: ―Ni machcatac u jobben u c'ajalinob a'ajtä pancabba ajulijob täcä wida. ");
INSERT INTO chfNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ni winicob jini, aj Jasón u yosijob tan yotot. Unejob upetejob mach u tz'ombejob u t'an aj César, u yäle'ob cache' an otro ajnoja u c'aba' aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jinq'uin u yubijob ca' jini, ni juezob y ni caj jobo ayan u c'ajalinob uc'a bäc'tajob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","U yäc'bijob u yäq'ue' taq'uin aj Jasón y u lotob uc'a mach xicob preso, y chajquijob chich. ");
INSERT INTO chfNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jin uc'a jimba ac'äb jini u lotob u täsqui aj Pablo y aj Silas bixicob tä Berea. C'otijob ya'i, ochijob tan ch'u'ul otot taj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Unejobba más ti'i u c'ajalinob que ni ya'anob tä Tesalónicaba. U c'alin sapijob u t'an Dios y upete q'uin u sacän tama ni jun tz'ibiba u jiranob si che' chich tz'ibi. ");
INSERT INTO chfNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jin uc'a q'uen u tz'onijob, ix griegajob jini ixt'äbälajob ta caj y machtajda wincäre täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Jinq'uin u yubijob aj judíosob tä Tesalónica cache' aj Pablo ya'an täcä tä Berea u tz'aycun u t'an Dios, bixijob täcä ya'i, y u yäc'bi u jobän ubajob ni caj. ");
INSERT INTO chfNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jini machcatac u tz'omben u t'an Diosba seb u täsquijob aj Pablo tu ti' nab. Aj Silas y aj Timoteo colijob ya'i. ");
INSERT INTO chfNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Machcatac xi u yäctan aj Pablo u bisijob tä Atenas. A'äctayajob älbinti u yälbenob aj Silas y aj Timoteo seb bixicob bajca an Pablo. U yubijob ca' jini, seb pasijob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Aj Pablo ya'to an u pijnanob tä Atenas, jaq'ui ujin tan u pixan uc'a u chänen cache' jini caj tä' q'uen u santujob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jin uc'a tan ch'u'ul otot u tz'aycäbenob u t'an Dios aj judíosob y machcatac nämäjob u ch'u'ul c'ajti'in Dios. U tz'aycäben u t'an Dios täcä machcatac u nuc'tan upete q'uin tänxin caj. ");
INSERT INTO chfNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yebe ni machca tä' yo u yäle' cache'da u xe u pancabba, aj epicúreojob y aj estoicojob tä t'anob t'oc une. Yebe u yäle'ob: ―¿Cua' ti yo u yäle' ni ajt'an jini que mäx q'uen cua' u yäle'? Yebe u yäle'ob: ―Ca' a wälä ajt'an tuba tzijib diosob. Uc'a une u tz'aycäbenob aj Jesús y cache' u xe tä cuxpan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","U bisijob tä Areópago u yälbenob: ―¿U ch'e' quira cuwina'tan t'ocob cua' jini ni tzijib t'an a ye'e'ba? ");
INSERT INTO chfNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Uc'a ane a'bon cubin t'oc cä chiquin t'ocob ni mach bay cubi t'ocobba. Co cuwina'tan t'ocob cuaxca ni jini. ");
INSERT INTO chfNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Uc'a upete aj Atenasob y ajtejob nat ni ya' cuxujob ya'iba u numsen q'uin tä t'an, u yäle'ob o u yubinob cuaxca an tzijibba. ");
INSERT INTO chfNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Aj Pablo wa'wäni tänxin Areópago, u yäli: ―Anela aj Atenas, aquiran cache' anela tä' a tz'onänla upete cua' chichca jini. ");
INSERT INTO chfNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Uc'a täc nume tan caj cä chäni a ch'ujla, cä chäni täcä ya'an ump'e alta bajca tz'ibi tuyac'o ca'da: “Tuba ni dios mach uyut conoceba”. Jini a c'ajti'inla y mach a wila caxca uneba, jin une cä tz'aycäbenetla no'onba cache' ayan. ");
INSERT INTO chfNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Jini Dios ni u chi u pancab y upete cua' anba, uc'a une Ajnoja tuba cielo y tuba u pancab, mach u yajwan tama ch'uj uti uc'a winicba. ");
INSERT INTO chfNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mach c'änä uc'a niump'e cua' äc'bintic uc'a winicob. Uneba u yäc'ben upetejob cuxlec, y u sapän ic', y upete cua' chichca täcä. ");
INSERT INTO chfNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Uc'a Dios u yäq'ui sec' untu u pap a'ajtä pancab tuba cuxlecob tu pan entero ump'e u pancab. Une u yäq'ui cada tzäcä u jäläcnan untu pancab, y cada tzäcä u c'ote u cabob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Bay toca u sacänob cache' u tz'omben Dios. Uneba mach chich nat an t'oc no'onla cäpetela. ");
INSERT INTO chfNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Uc'a une cuxulonla, cä chen xämbala, y anonla. Ca' chich u yälijob täcä yebe ajtz'ib t'an ta'ala jini u yälijob ca'daba: “U ch'oconla Dios une”. ");
INSERT INTO chfNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Si no'onla u ch'ocobonla Dios, mach utz cäle'la que Dios u c'ote t'oc ca' santo uti de c'änc'än taq'uin o de säsäc taq'uin o de ji'tun jini u chen winicba, jini ti tu c'ajalin winic cache' u chenba. ");
INSERT INTO chfNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dios mach se'en cäräx'i jinq'uin mach yuwijob cua' u chijob a'ajtä pancab. Bada u yälbenob upete a'ajtäjob pancab cachichcada ayanob cache' c'änä u q'uexe' u c'ajalinob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Uc'a Dios u yaqui ump'e q'uin jinq'uin u xe u totoj iran catac an tu toja catac mach'an tu toja pancab. U yäq'ui u chen jini patan jini winic u yaqui uneba. U ye'bonla cache' toj u t'an jinq'uin u cuxpesi tan ajchämejob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Jinq'uin u yubijob cache' u yäle', que acuxpi untu winic tan ajchämejob, yebe u tze'tanob, yebe u yäle'ob: ―Ta cä sujtä to cubin t'ocob a t'an cha'num. ");
INSERT INTO chfNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","De ya'i aj Pablo pasi bajca anob. ");
INSERT INTO chfNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yebe u tz'onijob, u yoli ubajob t'oc une. Aj Dionisio täcä jini a'äc'c'ajalin tama ni aj areópagojobba, y untu ixic u c'aba' ix Dámaris, y otrojob täcä u tz'onijob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ji'pat aj Pablo pasi tä Atenas c'oti tä Corinto. ");
INSERT INTO chfNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","U nuc'ti untu aj judío u c'aba' aj Aquila, tä Ponto u cab, mach to jäläcna pasi tä Italia t'oc ix Priscila jit'oc chichba, uc'a aj Claudio ni ajnoja tuba ni cab jini u yäq'ui tä pase upete aj judíosob tä Roma. Aj Pablo c'oti bajca anob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ya' cuxli t'oc unejob, tä patanob t'oc, uc'a jinchichba patan u chen aj Pablo, u chenob täcä. Uc'a u patan unejobba cheraj boch' de noc' une. ");
INSERT INTO chfNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Upete u q'uin ch'ämbäji ajni tä t'an tan ch'u'ul otot, tuba u yäc'ben u tz'onänob aj judíosob y aj griegojob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Jinq'uin c'otijob aj Silas y aj Timoteo, ya' tijob tä Macedonia, aj Pablo tomp'e u c'ajalin u yälbenob aj judíosob cache' aj Jesúsba aj Cristo une, ni u täsqui Diosba. ");
INSERT INTO chfNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Aj judíosob u juli ubajob tuyac'o tä t'an, u yälbenob cua' chichca tzuc t'an. Aj Pablo u ch'i u buc tuyac'o u ticän, u yälbijob: ―Mach jin cä tanä chämiquetla, a tanäla chich. Bada cä bixe bajca an aj gentilob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pasi ya'i, bixi tu yotot untu winic u c'aba' aj Justo. Uneba mäx u c'ajti'in Dios. Ya'an yotot tu ch'ejpa ni ch'u'ul otot tuba aj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Aj Crispo, une ajnoja ta ni ch'u'ul otot, u tz'ombi u t'an Cajnojala Dios, t'oc upete machcatac an tan yotot. Q'uen aj corintiosob täcä u yubijob, u tz'onijob, y c'ablijob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","De ya'i Cajnojala Dios u yälbi ac'äb aj Pablo ca' tan u naja: ―Mach bäc'taquet a tz'aycun cä t'an, mach ch'in ajniquet. ");
INSERT INTO chfNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Uc'a no'on ya'anon t'oc ane, niuntu mach u ch'ä u cherbenet niump'e cua'; uc'a q'uen ya'an cäc'ajob tama ni caj jini que u xe u tz'ombenon. ");
INSERT INTO chfNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","U chi ya'i ump'e año y seis mes u ye'benob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Jinq'uin aj Galión juez tä Acaya, aj judíosob tomp'e ch'oyijob tuyac'o aj Pablo, u q'uechijob u bisijob ta juez. ");
INSERT INTO chfNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","U yäle'ob ca'da: ―Jinda winic u yäq'ue' tä päpä' c'ajti'can Dios, y mach ca' tz'ibi tan ley taj Moisés. ");
INSERT INTO chfNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tu xe u täq'ue' t'an aj Pablo, aj Galión u yälbi aj judíosob: ―Anela judíos, si fuera ayan u noj tanä, y si u chi cua' chichca malujle, ayan chich cua' uc'a tiquetla uc'a cubin. ");
INSERT INTO chfNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero si tuba t'an, o tuba c'aba', o tuba ni ley ta'ala, iran anela ya'i si u chen tu toja, uc'a no'on mach co xicon de juez tuba ni cosa jini. ");
INSERT INTO chfNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Jin uc'a u pa'sijob tan yotot. ");
INSERT INTO chfNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","De ya'i upete aj griegojob u ch'ijob aj Sóstenes, ajnoja ta ch'u'ul otot, u jätz'ijob tu pänte' yotot juez. Aj Galión mach u chi caso. ");
INSERT INTO chfNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Aj Pablo jäläcni ya'i. De ya'i u laj äc'bi u c'aba' Dios machcatac u tz'omben u t'an Dios ya'i uc'a u bixe. Bixi tu pat nab tä Siria nämte' t'oc ix Priscila y aj Aquila. Tä Cencrea susinti aj Pablo, coli ajcotzompam, uc'a u chi ump'e promesa tu pänte' Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","C'oti tä Efeso. Ya'i aj Pablo u yäcti ix Priscila y aj Aquila. Une ochi tan ch'u'ul otot tä t'an t'oc aj judíosob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","U ch'oc chen ubajob t'oc uc'a colac t'oc unejob ya'i; une u yäli que mach ucol. ");
INSERT INTO chfNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tu bixe uneba u yäc'bijob u c'aba' Dios, u yälbenob ca'da: ―Tä' c'änä xicon cä numsen ni q'uin ch'uje tä Jerusalén u xe tä ajtäba. No'on cä xe tä sujtä bajca anetla, si Dios yo. De ya'i pasi tä Efeso. ");
INSERT INTO chfNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","C'oti tä Cesarea, pasi, bixi tä Jerusalén. U pequijob machcatac a'uti u woylan ubajob ya'i, de ya'i bixi tä Antioquía. ");
INSERT INTO chfNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Jäläcni ya'i tz'ita', pasi, y u nume cada caj tä Galacia y tä Frigia u yäc'benob u c'alin tz'onänob upete machcatac u tz'omben Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","C'oti tä Efeso untu winic aj judío, u c'aba' aj Apolos, ya' päncäbi tä Alejandría, q'uen u c'ajalin tuba u tz'aycun u t'an Dios, c'alin yuwi täcä u jun Dios ni tz'ibiba. ");
INSERT INTO chfNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jinda winic u cäni ni bij tuba Cajnojala. Tä' ch'o'o u yäle' y u c'alin ye'e' jini t'an tuba Cajnojala, sec' ni c'ablesia taj Juanba yuwi. ");
INSERT INTO chfNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","U täq'ui t'an sin bac'ät tama ch'u'ul otot. Jinq'uin u yubijob ix Priscila y aj Aquila, u bisijob tu yotot u ye'ben tu toja ni bij tuba Cajnojala. ");
INSERT INTO chfNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jinq'uin u yäli xic tä Acaya, u lotob u täclijob, u yäc'bijob u bisan jun tuba machcatac u tz'omben u t'an Dios ya'i tuba osintic. C'oti une ya'i, u täclijob tuba u c'alin cäne'ob machcatac u tz'oni uc'a utz u c'ajalin Dios t'oc unejob. ");
INSERT INTO chfNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Une mach mucu u ye'benob aj judíosob bajca tz'ibi tama u jun Dios cache' aj Jesús aj Cristo une; unejobba mach u pojli niump'e cua' u p'alänob, uc'a une q'uen u c'ajalin. ");
INSERT INTO chfNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ya'to an aj Apolo tä Corinto, aj Pablo numi bajca an isquil cab c'oti tä Efeso. Ya'i u nuc'tijob machcatac u tz'omben u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","U yälbijob: ―¿A ch'ila quira ni Ch'u'ul Pixan jinq'uin a tz'onila? Unejob u p'ali: ―Mach to cubi t'ocob si ya'an Ch'u'ul Pixan. ");
INSERT INTO chfNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Une u c'atbijob: ―¿Cache'da c'abletla jiq'uin? Unejob u yäli: ―C'ablon t'ocob ca' chich u yäli aj Juan c'ablac untu. ");
INSERT INTO chfNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Aj Pablo u yäli: ―Aj Juan u chi ni c'ablesia jini tuba machcatac u q'uexe' u c'ajalinob, u yäli tz'ombintic jini ajte patiba, uc'a a wina'tanla machca une, aj Jesús une ni Cristoba. ");
INSERT INTO chfNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","U yubijob ca' jini, c'ablijob t'oc u c'aba' Cajnojala aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Jinq'uin aj Pablo u yäq'ui u c'äb tan u pamob, c'oti tuyac'ojob ni Ch'u'ul Pixan. U chijob yänäl t'an y u yälijob u t'an Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ni jinijob ca' doce winicob. ");
INSERT INTO chfNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","De ya'i aj Pablo ochi tan ch'u'ul otot. Sin bac'ät u yajne tä t'an ya'i uxp'e mes. U yälbenob tuba u tz'onänob cache'da ayan bajca u chen manda Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yebe tzätz'i u pixanob, mach u tz'onäjob. U cäräx älbenob u t'an Dios bajca an u yubin u noj q'ue'na gente. Jin uc'a aj Pablo u tz'eji uba bajca anob, u bisijob täcä machcatac u tz'omben u t'an Dios, y u ye'benob u t'an Dios upete q'uin tan ni escuela tuba untu winic u c'aba' aj Tiranno. ");
INSERT INTO chfNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ya'i u chi dos año u ye'e' ni t'an ta Dios. Jin uc'a upete machcatac cuxujob tä Asia, aj judíosob y aj griegojob, u yubijob jini t'an, cua' u chi y cua' u yäli Cajnojala aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios u yäc'bi aj Pablo u chen q'uen cua' chichca jini mach bay achänintiba. ");
INSERT INTO chfNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Uc'a bisbintijob c'ol winic payu y ch'icnäc' jin chich ni u täli aj Pabloba, y u pojli ubajob, y tzuc pixanob pasi tuyac'ojob. ");
INSERT INTO chfNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yebe aj judíosob, ajwa'ajtänejob ni u yäle'ob cache' u ch'e' u pa'sen tzuc pixan tuyac'o untuba, u c'ajti'bijob u c'aba' aj Jesús Ajnojaba uc'a yojob u pa'sen tzuc pixan tuyac'o machca u cänäntan, u yäle'ob ca'da: ―Cälbenet pasiquet uc'a u c'aba' aj Jesús jini u yäle' aj Pabloba. ");
INSERT INTO chfNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ajni siete u yajlo' untu winic aj judío u c'aba' aj Esceva, uneba ajnoja tuba palejob, jin une ni u chenob ca'daba. ");
INSERT INTO chfNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero ni tzuc pixanba u p'alänob ca'da: ―Cä chen conoce aj Jesús, cuwi camba aj Pablo. Anelaba, ¿caxcajetla? ");
INSERT INTO chfNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ni winic ya'an ni tzuc pixan tuyac'oba sip'yäli tuyac'ojob u q'ueche'ob, y más q'uen u muc' que unejob. Jin uc'a unejob pasijob tä putz'e tama ni otot jini sin buc y cho'ojtac u pächijob. ");
INSERT INTO chfNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Upetejob machcatac cuxujtac tä Efeso u yubijob cua' uti, aj judíosob y aj griegojob täcä. Upetejob yäli bac'ät tuyac'ojob. Jin uc'a u ch'u'ul c'ajti'can u c'aba' Cajnojala aj Jesús. ");
INSERT INTO chfNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Q'uen machcatac u tz'onijob u c'otejob u sube' u tanäjob u yäle' cua'tac u chijob. ");
INSERT INTO chfNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Q'uen ajtz'a'tayajob täcä u täsijob u jun u pulijob tu jut upetejob. U pa'sijob cuenta jäyp'e u valor ni jun puliba, c'oti ca' cincuenta mil säsäc taq'uin. ");
INSERT INTO chfNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Jin uc'a c'ac'a' q'ue'ni machcatac u yubi u t'an Cajnojala, u c'alin äq'ui u c'ajalinob t'oc. ");
INSERT INTO chfNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ji'pat aj Pablo yo xic tä Jerusalén. U ch'i u c'ajalin cache' najtäcä c'änä numic tä Macedonia y tä Acaya, jin uc'a u yäli ca'da: “Najtäcä cä xe ya'i, y ji'pat c'änä xicon tä Roma”. ");
INSERT INTO chfNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","U täsqui tä Macedonia cha'tu u yajtäclayajob, aj Timoteo y aj Erasto, uneba coli chap'e uxp'e q'uin tä Asia. ");
INSERT INTO chfNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ya'i ajni ump'e noj jobole machtajda uc'a ni t'an tuba Dios. ");
INSERT INTO chfNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uc'a ajni untu ajcheraj ch'uj t'oc yoco taq'uin, u c'aba' aj Demetrio. Une u cherben u p'i' ch'uj ix Diana. Ni patan jiniba, q'uen taq'uin u chen gana t'oc, y che' chich täcä u yajpatanob. ");
INSERT INTO chfNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","U woyijob u yajpatanob y machcatac jin chich u patan, u yälbijob: ―Cä lot, a wila cache' t'oc jini patanda u yajtä cä taq'uinla. ");
INSERT INTO chfNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","A chänila y a ubila cache' aj Pablo q'uen u yäc'bi u q'uexe' u c'ajalinob y u tz'eje' ubajob t'oc ni ch'uj jini, mach seq'uen aj efesiojob, q'uen täcä a'ajtä entero tä Asia, u yälbenob cache' mach jin dios jini u yute t'oc u c'äb winicba. ");
INSERT INTO chfNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mach utz u chenob ca' jini, cä patanla mach me'ixto mach olcac, u ch'uj cä noj diosla ix Diana mach me'ixto xic tä waläctinte, mach me'ixto xic tä pa'sinte bajca an de ixnoja. Upete aj Asiajob y upete a'ajtäjob pancab u yajna'tanob jini quixnojala. ");
INSERT INTO chfNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Jinq'uin u yubijob ca' jini, c'ac'a' cäräx'ijob, u yälijob t'oc noj gran t'an: ―¡Mero noj ixnoja ix Diana tuba aj efesiojob! ");
INSERT INTO chfNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","U laj jobi uba caj, tomp'e bixijob t'oc noj ancäre tu yototi caj bajca u yajtä chanä, u cocoj bisijob aj Gayo y aj Aristarco, aj Macedoniajob, u lotob aj Pablo. ");
INSERT INTO chfNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Aj Pablo yoli xic bajca anob, pero u yajcänt'anob mach u yäctijob xic. ");
INSERT INTO chfNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Yebe aj Asiajob, ajnojajob, u lotob chich aj Pablo, u täsquijob tä cocoj älbinte mach xic tama u yototi caj. ");
INSERT INTO chfNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Yebe u yäle' ump'e cosa, yebe u yäle' otra cosa, uc'a jobo u c'ajalinob machcatac woyojtac. U tajwoyi ubajob, q'uen mach yuwijob cua' uc'a u woyi ubajob. ");
INSERT INTO chfNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ch'ämqui aj Alejandro t