﻿USE sofia;
DROP TABLE IF EXISTS sofia.chdNT_vpl;
CREATE TABLE chdNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES chdNT_vpl WRITE;
INSERT INTO chdNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jifa'a iƚniya ƚiƚpuftine litatahueló Jesucristo ƚecui'impa ƚi'hua cal rey David: Abraham itatahuelo David. ");
INSERT INTO chdNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham i'ailli' Isaac. Isaac i'ailli' Jacob. Jacob iƚ'ailli' Judá jouc'a lipimaye. ");
INSERT INTO chdNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá iƚ'ailli' Fares y Zara, quiƚ'máma' iƚniya cuftine Tamar. Fares i'ailli' Esrom. Esrom i'ailli' Aram. ");
INSERT INTO chdNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram i'ailli' Aminadab. Aminadab i'ailli' Naasón. Naasón i'ailli' Salmón. ");
INSERT INTO chdNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón i'ailli' Booz. Qui'máma' Booz cuftine Rahab. Booz i'ailli' Obed. Qui'máma' Obed cuftine Rut. Obed i'ailli' Isaí. ");
INSERT INTO chdNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí i'ailli' cal rey David. David i'ailli' Salomón. Qui'máma' Salomón iƚque ƚaca'no' ate'a ilecopa cal xans Urías. ");
INSERT INTO chdNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón i'ailli' Roboam. Roboam i'ailli' Abías. Abías i'ailli' Asa. ");
INSERT INTO chdNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa i'ailli' Josafat. Josafat i'ailli' Joram. Joram i'ailli' Uzías. ");
INSERT INTO chdNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías i'ailli' Jotam. Jotam i'ailli' Acaz. Acaz i'ailli' Ezequías. ");
INSERT INTO chdNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías i'ailli' Manasés. Manasés i'ailli' Amón. Amón i'ailli' Josías. ");
INSERT INTO chdNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías iƚ'ailli' Jeconías jouc'a lipimaye. Lan xanuc' iƚniya quiyouyomma ƚamats' Babilonia ilecom'mola' cal rey Jeconías jouc'a lixanuc', icuai'entsola' ƚamats' Babilonia. ");
INSERT INTO chdNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías i'ailli' Salatiel, iƚque nipajnyota ƚamats' Babilonia. Salatiel i'ailli' Zorobabel. ");
INSERT INTO chdNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel i'ailli' Abiud. Abiud i'ailli' Eliaquim. Eliaquim i'ailli' Azor. ");
INSERT INTO chdNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor i'ailli' Sadoc. Sadoc i'ailli' Aquim. Aquim i'ailli' Eliud. ");
INSERT INTO chdNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud i'ailli' Eleazar. Eleazar i'ailli' Matán. Matán i'ailli' Jacob. ");
INSERT INTO chdNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob i'ailli' José. Iƚque José ipe'ailli' María. Maƚque María ƚipo'nopa Jesús, iƚque cuftine cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Toxhuej'metsola' liƚputine litatatahueló cal Cristo, iƚne liniƚiya jifa'a, toxhuej'me'mola' oquej nuxans oquexi'. Topangocoƚa' Abraham, cocuaiya cal rey David, joupa oxhuej'mepola' imbamaj malujxi litatahueló cal Cristo. Ti'hua toxhuej'metsola', topangococonƚa' David, cocuaiya petsi loya'apa: “… ilecom'mola' cal rey Jeconías jouc'a lixanuc', icuai'entsola' ƚamats' Babilonia”. Jiƚpe joupa oxhuej'mepola' ocuenaye imbamaj malujxi litatahueló cal Cristo. Tijouƚa' topangococonƚa' petsi liniƚiya: “… ilecom'mola'… icuai'entsola' ƚamats' Babilonia”, ti'hua toxhuej'metsola', cocuaiya liniƚiya loya'apa: “… María ƚipo'nopa Jesús, iƚque cuftine cal Cristo”, jiƚpiya joupa oxhuej'mepola' ocuenaye imbamaj malujxi litatahueló cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Itsiya cu'i'molhuo' li'ipa licuai'ma Jesucristo fa'a li'a ƚamats'. María ti'i'ma qui'máma' Jesús. Iƚquiya joupa epi'ipa cataiqui' José. Iƚniya aiquejonƚiyoƚtsi. María ma' ahuats', iximpoxi innay. Toƚta'a li'e'epa cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José liximpa innay María, ¿te co'eya? Iƚque José tihuequi lataiqui' locuxepa ȽanDios. Iƚe lataiqui' ticua: “Iƚniya lan xujc'a cacaƚ'no' tocuftsola'”. José ixim'ma cuanuc' María, aimicua micufya. Ticua: “A'i cacufya. Aicuya'aya. Ma le'a aicalecoya.” ");
INSERT INTO chdNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Micua toƚta'a lipicuejma' José ipaiyo'ma. Imaxcaitsi anuli ƚepaluc ȽanDios. Iƚque ƚapaluc timi: ―José, ima' otatahuelo cal rey David. Itsiya camihuo': Aimoxhueƚmot'ƚe'ma. Tapenufla' María copeno. A'i xans ƚitai'ipa María. Ma cal Espíritu Santo itai'ipa. ");
INSERT INTO chdNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tipo'no'ma ƚi'hua amijcano. Ima' tacui'i'ma Jesús. Iƚque tunƚu'e'mola' lixanuc'. ȽanDios aimecani'eyacola'. Iƚe lipuftine lofmecui'iya tuhuaƚquemma: Ƚonƚu'eyale. ");
INSERT INTO chdNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iƚe li'ipa María enanƚpa lataiqui' linespa cal profeta luya'apa linespa ȽanDios, tuya'e': ");
INSERT INTO chdNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","¡Toƚcuejle! Ƚahuats' ti'i'ma quinnay, tipo'no'ma qui'hua. Iƚque ƚi'hua tecui'im'me Emanuel. Lipuftine lacui'inyacu tuhuaƚquemma: Fa'a tipa'a ȽanDios, aƚmana' anuli. ");
INSERT INTO chdNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José imaf'i'ma, itsahuemma, i'e'ma ma to limipa ƚepaluc ȽanDios. Epenuf'ma María. Ileco'ma lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mi'huaijma tipajntsi cal te'a qui'hua María, tama imajm'me anuli lajut'ƚ, aiqui'eyoƚtsi anuli. Lipajntsi ƚamijcano, José ecui'i'ma lipuftine Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iƚniya ƚitiné, micuxe cal rey Herodes, Jesús ipajnyotsi liƚya' cuftine Belén, lopa'a al distrito Judea. Maƚniya ƚitiné lan xanuc' linxingufale icuaitsa al distrito Judea, al cuecaj quiƚya' Jerusalén. (Iƚniya tecui'innila' lam Mago.) Quiyouyomma ƚilemats' pe liyuf'maj 'ora. ");
INSERT INTO chdNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Icuitsuf'me. Timinnila' lan xanuc' nomana' Jerusalén: ―Imanc' unc'ijudío, ¿pe copa'a ƚamijcano iƚque ƚoƚrey? Aƚsimpá liyuf'ma ƚixamna ƚoya'apa joupa ipajnta iƚque cal rey. Aƚcuai'me laxc'onƚingoƚai'me. ");
INSERT INTO chdNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Licuej'ma iƚe lataiqui' cal rey ixhueƚconni. Jouc'a ixhueƚconca jahuay lan xanuc' nomana' jiƚpe liƚya' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Cal rey ijoc'i'mola' lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. Icuis'e'mola', timila': ―Al Paxi Liniƚingiya, ¿te quicuapa? ¿Pe copajnyoya cal Cristo? ");
INSERT INTO chdNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iƚniya timiyi: ―Cal Cristo tipajnyota liƚya' Belén, lopa'a al distrito Judea. Toƚta'a licuapa cal profeta liniƚpa linespa ȽanDios, tuya'e': ");
INSERT INTO chdNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ima' Belén, miƚya' lofpa'a al distrito Judea, aimetets'i'mo' iƚne nocuxempola' lan xanuc' nomana' ƚamats' Judá. Ima' ti'i'mo' quipiƚya' anuli cal cuecaj nocuxeya. Iƚque ac'a ticuxe'mola' laixanuc', iƚniya lixanuc' Israel. ");
INSERT INTO chdNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes i'e'moxi ch'ix. Ijoc'i'mola' iƚne linxingufale, iƚne lam Mago, timila': ―¿Te quitine limaxcaita cal xamna? Lu'iƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iƚniya u'i'me. Cal rey Herodes umme'mola' tiyeƚe liƚya' Belén. Timila': ―Tonƚeƚe, jiƚpe liƚya' tolahuetsa ƚamijcano. Litine toƚsintsa, alu'i'ma. Iya' jouc'a ca'hua'ma. Caxc'onƚingaita. ");
INSERT INTO chdNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Lam Mago iquimf'e'me cal rey limipola', iye'me. Miƚmana' ƚilemats' iƚne iximpá limaxcaita cal xamna. Itsiya maƚque cal xamna i'huaj'me'mola'. Licuaitsi lajut'ƚ pe lopa'a ƚamijcano, imaxcaiconno, ecaxemma al toncay. ");
INSERT INTO chdNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ixoconni quileta lam Mago lixim'me cal xamna. ");
INSERT INTO chdNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Itsulfoƚai'me lajut'ƚ, ixim'me ƚamijcano jouc'a María, iƚque i'máma'. Exc'onƚingoƚai'me ƚamijcano. Exi'e'me liƚcaxax, icuf'i'me ƚamijcano liƚtaic'. Tipa'a al 'oro, tipa'a al 'incienso, tipa'a laceite ipitali juaiconapa, tujuej c'a, lipuftine mirra. ");
INSERT INTO chdNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lam Mago ipaiyo'me. ȽanDios timila': ―Aimoluyalaiconata pe lopa'a cal rey Herodes. Licuej'me toƚta'a, ocuena cane iyena'me, icuainatsa liƚpiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Liyena'me lam Mago, José ipaiyocona'ma. Ixim'ma anuli ƚepaluc ȽanDios. Ƚapaluc timi: ―Totsahuenni. Tolecotsola' ƚamijcano jouc'a qui'máma'. Iƚque cal rey Herodes tumme'mola' lixanuc' tehue'me ƚamijcano tima'anƚe. Aimicoƚ'molhuo' tonƚeƚe ƚamats' Egipto. Toƚmajntsa jiƚpiya. Iya' cu'ito' te quitine toƚpailinacu. ");
INSERT INTO chdNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José itsahuenni iƚe lipuqui', ileco'mola' ƚacamijcano jouc'a qui'máma'. Iye'me, icuaitsa ƚamats' Egipto. ");
INSERT INTO chdNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jiƚpe imajnhuo'me. Timanƚa' cal rey Herodes iƚne tipailinacu, ticuainata ƚilemats'. Iƚe lo'iya tenanƚ'ma luya'apa cal profeta, iƚque uya'apa locuapa ȽanDios, ticua: “Aijoc'ipa ƚai'hua, tipanni jiƚpe ƚamats' Egipto”. ");
INSERT INTO chdNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lixim'ma cal rey Herodes lam Mago lifel'mipa, ixtunni juaiconapa. I'nujuaitsi lu'i'me lam Mago. Iƚne ines'me: “Itsiya joupa uyaipa to oquej camats' laƚsimpa limaxcaita cal xamna”. Cal rey umme'mola' lixanuc' tima'antsola' lan tsocay camijcanó limajnyota liƚya' Belén jouc'a ƚiƚeloƚya' lomana' huejnca. Tima'antsola' jahuay laicamijcanó, ja'ni lixhuaitola' oquej camats', o ja'ni aiquixhuaiyila', ma' anuli tima'antsola'. ");
INSERT INTO chdNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Toƚta'a enanƚ'ma linespa cal profeta Jeremías, tuya'e': ");
INSERT INTO chdNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Jiƚpe ƚamats' Ramá ticuequinni anuli ƚaca'no' tijoqui, tija'e'. Iƚquiya Raquel, tijoqui, tixhueƚma li'ipola' linaxque'. Aimicua miƚonc'e'enyacu lipixhuejma', linaxque' joupa ima'ampola'. ");
INSERT INTO chdNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","José mipa'a ƚamats' Egipto imana'ma Herodes. Ipaiyocona'ma, ixim'ma anuli ƚepaluc ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ƚapaluc timi: ―Totsahuenni. Tolecotsola' ƚamijcano jouc'a qui'máma'. Toƚpailinanca, tonƚenƚe ƚolamats' Israel. Joupa imanapola' iƚne nehuepá tima'anƚe ƚamijcano. ");
INSERT INTO chdNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José itsahuenni, ileco'mola' ƚamijcano jouc'a qui'máma'. Ipailinanca, ticuainata ƚilemats' Israel. ");
INSERT INTO chdNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Licuaitsa jiƚpe José icuej'ma: “Arquelao, ƚi'hua Herodes, ticuxe al distrito Judea”. Ixpaiconni. Ticua: “Jiƚpe al distrito Judea, aimi'iya maƚeyacu”. Ipaiyocona'ma. ȽanDios u'i'ma lo'eya. Iye'me, ticuainata al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Icuaitsa, iye'me liƚya' Nazaret, jiƚpe imanenca. Toƚta'a enanƚco'ma linespa lam profeta, iƚne uya'apá loyaicoya Jesús. Icuapá: “Iƚque tecui'im'me ƚas Nazaret”. ");
INSERT INTO chdNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Iƚniya ƚitiné Juan Bautista icuaitsi al distrito Judea, ipajm'ma pe ailopa'a quiƚya'. Jiƚpe tuya'e', ");
INSERT INTO chdNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","tu'ila' lan xanuc': ―Imanc' toƚsuej'menanca, ȽanDios cal Rey icuaico'ma, timajm'me anuli lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cal profeta Isaías inesco'ma Juan Bautista ƚocuaicoya, tuya'e': Petsi ailopa'a quiƚya' tuya'e' anuli cal xans, tu'ila' lan xanuc': “Toƚƚanc'eƚe lipene ƚaƚPoujna. Toƚ'e'eƚe aƚijca lane pe loyaicoya.” ");
INSERT INTO chdNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lipijahua' Juan ipuficoya ipimij camello. Lifi'ecoyoxi ixmi. Ƚitejua' axa'mut'ƚ, acujua c'ec. ");
INSERT INTO chdNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Axpela' lan xanuc' itsehuo'me pe lopa'a Juan. Iƚniya lan xanuc' quiyouyomma liƚya' Jerusalén, jouc'a quiyouyomma locuenaye quiƚeloƚya' al distrito Judea, jouc'a quiyouyomma jiƚpe lihuojma' al cuecaj pana' Jordán. Icuaitsa pe lopa'a Juan. ");
INSERT INTO chdNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Luya'a'me liƚjunac', Juan epo'i'mola' al pana' Jordán. ");
INSERT INTO chdNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Axpela' lan xanuc' fariseo jouc'a lan saduceo icuaitsa pe lapo'iyaleyopa Juan. Lixim'mola' Juan timila': ―Imanc ti'onƚcospolhuo' to lacaƚpo', a'ijc'a loƚ'ejma'. ¿Te ja'ni u'impolhuo': “Tolapoliƚe. Toƚta'a aimoƚteƚcoyacu al cueca' cateƚcoya locuaicoya”? ");
INSERT INTO chdNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Iya' camilhuo': A'i toƚta'a molunƚulyacu. Ticuicomma tonƚ'eƚe al c'a, ma to mi'eyi iƚniya nixhuej'menamma. ");
INSERT INTO chdNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","’Imanc' toƚcuayi: “Abraham aƚtatahuelo. Illanc' ixanuc' ȽanDios. Iƚquiya aimalacani'eyaconga'.” Iya' camilhuo': ȽanDios aimehue'eyacola' quixanuc'. Iƚna'a lapic' nipajnya ti'e'e'mola' quinaxque' Abraham. ");
INSERT INTO chdNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ȽanDios ti'onƚicolhuo' to al 'ec. Joupa ipo'nompa cal hacha huejnca ƚime al 'ec. Ja'ni ti'atsi a'ijc'a ƚi'as, tetequinam'me, tixanc'onnata ƚunga. ");
INSERT INTO chdNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Ja'ni joupa oƚsuej'menamma lixcay lonƚ'epa, iya' capo'ico'molhuo', capaxneco'molhuo' aja'. Ticuaihuo ocuenaj cal xans, iƚque xonca acueca'. Iya' aimaƚ'onƚspa iƚque, ni aimi'iya catac'ueya lic'eji'. Iƚque tepo'iyaleco'ma cal Espíritu Santo jouc'a ƚunga. ");
INSERT INTO chdNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iƚque ticuaiyunni ti'onƚcospa to cal xans tifus'ma ƚitrigo. Ti'noƚ'ma lofuscoya, tequeyof'ma ƚitrigo, tiƚojm'ma ƚipifuc cal trigo. Cal c'a trigo ti'huejnata lihua. Ƚipifuc tipi'enghua petsi ƚunga aimipica. ");
INSERT INTO chdNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús lipanni al distrito Galilea icuaitsi al pana' Jordán, jiƚpe copa'a Juan Bautista. Timi: ―Lapo'iƚa'. Juan aimicua. Ticua aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Timi Jesús: ―Ticuicomma ima' lapo'iƚa' iya'. ¿Te co'iya caifnepo'icoyaco' ima'? ");
INSERT INTO chdNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús italai'e'e'ma, timi: ―Itsiya' to'eƚa' laifxahue'epo'. Jahuay al c'a laƚcuxe'eponga' ȽanDios laƚ'eyacu ticuicomma lanant'ƚiƚe. Juan i'e'ma lixahue'e'ma Jesús. Epo'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lijoupa lepopa Jesús aiquicoƚ'ma, ipanni laja'. Maƚpe 'hora itsaƚquenni lema'a. Ixim'ma cal Espíritu Santo ti'onƚcospa to anuli cal ja'mu', icuaico'ma timumma tihuoxaf'caita. ");
INSERT INTO chdNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tipalay jipu'hua lema'a, ƚamats' icuequim'me, ticua: ―Iƚca'a ai'Hua, ca'ay capic'a juaiconapa. Latenƚma lipicuejma' jouc'a li'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Cal Espíritu Santo i'hua'a'ma Jesús, icuai'etsi pe ailopa'a quiƚya', ailopa'a xanuc'. Jiƚpiya ƚonta'a Satanás ehuaitsi. ");
INSERT INTO chdNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Micoƚi oquej nuxans quitine, oquej nuxans quipuqui', aimitesma, ixnet'ƚ'ma. Lixhuaitsi iƚne ƚitiné, unle'enni juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Licuaitsi ƚonta'a, iƚque ƚinahuaiyalepa, timi: ―Ima' ja'ni i'Hua ȽanDios tocuxe'etsola' iƚna'a lapic'. Tomitsola': “Ti'itsolhuo' ca'i”. ");
INSERT INTO chdNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús italai'e'e'ma, timi: ―Al Paxi Liniƚingiya ticua: “Ƚoteja cal xans aimites'miya lipitine. Ticuicomma jouc'a Litaiqui' ȽanDios, jahuay lonespa iƚque.” ");
INSERT INTO chdNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ƚonta'a ileco'ma al Paxi Quiƚya' Jerusalén. Icuai'etsi pe lopa'a al cuecaj xoute', xonca al toncay. Jiƚpe ecaxu'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Timi: ―Ima' ja'ni i'Hua ȽanDios, taiyuƚa' al 'ocay. Al Paxi Liniƚingiya ticua: ȽanDios tumme'mola' lepaluc' titoc'i'mo'. Tipulnuf'mo' liƚmane, toƚta'a lapic' cane ailopa'a co'eyaco'. Aimixcai'eyaco'. ");
INSERT INTO chdNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús timi: ―Al Paxi Liniƚingiya jouc'a ticua: “Aimahuai'ma ȽanDios iƚque omenDios”. ");
INSERT INTO chdNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ƚonta'a ehuaicona'ma. I'hua'a'ma al toncay anuli ƚijuala xonca i'nof'quiya. Imuc'i'ma jahuay lan nación jouc'a ƚiƚ'huexi. ");
INSERT INTO chdNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Timi Jesús: ―Laxc'onƚingaiƚa'. Iya' capi'ina'mo' comane. Tocuxena'ma jahuay iƚiya. ");
INSERT INTO chdNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús timi: ―Ima' monta'a to'huanƚa'. Aƚpo'noƚa' caituca'. Al Paxi Liniƚingiya ticua: “Taxc'onƚingaiƚa' ȽanDios iƚque omenDios. Ma le'a iƚque tomi'ma: Ima' unCueca'.” ");
INSERT INTO chdNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ƚonta'a i'huana'ma. Ipanenni quituca' Jesús. Icuaiyunca lapaluc' quema'a. Itoc'i'me, ites'mi'me. ");
INSERT INTO chdNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Licuej'ma Jesús: “Juan Bautista itats'iya”, itsecona'ma Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ux'maspa lipiƚya' Nazaret, i'hua'ma ipajntsi jiƚpe liƚya' cuftine Capernaum. Iƚe liƚya' copa'a ƚema al cuecaj quin'nuhua', jiƚpe ƚilemats' Zabulón y Neftalí. ");
INSERT INTO chdNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Toƚta'a enanƚpa linespa cal profeta Isaías. ");
INSERT INTO chdNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Iƚque inescopa lo'iya jiƚpiya “… ƚilemats' Zabulón y Neftalí, lane lotsepa ƚema caja, ƚamats' locuena quiju' al pana' Jordán, Galilea pe lomana' lan xanuc', iƚne pe aimimetsaicoyi ȽanDios”. ");
INSERT INTO chdNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jouc'a ticua: Lan xanuc' nomana' jiƚpiya tocomma tiyelocoyi al muf, iƚne ixim'me al cueca' quepalc'o'. Jiƚpe ƚamats' ti'hua lamaya, tunxamu'ela', tixpaic'ela'. Itsiya iƚic'enapa, epalc'onapola'. ");
INSERT INTO chdNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Licuaitsi jiƚpiya al distrito Galilea, Jesús ipango'ma uya'a'ma Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Timila' lan xanuc': ―¡Toƚsuej'menanca! Itsiya icuai'ma cal Cuecaj Rey Nopa'a lema'a. Ticuxela' lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Anuli litine Jesús ti'hua ƚema al cuecaj quin'nuhua' Galilea. Ixim'mola' loquexi' lapimaye, Simón y Andrés. Iƚque Simón ƚecui'impa Pedro. Iƚne in'noƚpá catuye. Tecajm'miyi ƚiƚxami lin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús timila': ―¡Lihuejla'! Itsiya toƚ'noƚyi catuye. Iya' capi'i'molhuo' ocuena coƚpenic'. Tolahuetola' lan xanuc', iƚniya lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pedro y Andrés aiquicoƚ'mola'. Ipo'no'me ƚiƚxami, ihuej'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesús uyai'ma nihuata, ixim'mola' ocuenaye oquexi' lapimaye, iƚniya inaxque' Zebedeo. Liƚpuftine Jacobo y Juan. Iƚniya quiƚ'ailli' Zebedeo ticusc'oƚanna al barco. Tenaj'mot'ƚiyi ƚiƚxami ti'noƚcota latuye. Jesús ijoc'i'mola', timila': ―¡Lihuejla'! ");
INSERT INTO chdNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aiquicoƚ'mola'. Ipo'no'me al barco jouc'a quiƚ'ailli'. Ihuej'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ti'huaf'cay jahuay al distrito Galilea. Ti'hua timuc'iyale jiƚpiya ƚajut'ƚi pe lafoƚyomma. Tuya'e' te ts'i'ic' lixpic'epa ȽanDios, iƚe lataiqui' loya'apa al c'a. Tixaƚ'mela' lan xanuc' jahuay liƚpumla, jahuay liƚcuana. Iƚe litaiqui' loya'apa ticua: “Icuai'ma ȽanDios cal Rey. Timajm'me anuli lixanuc'.” ");
INSERT INTO chdNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jahuay ƚamats' Siria lan xanuc' icuej'me lo'epa Jesús. Icuai'enca jahuay lilefcualƚay, jouc'a noxingufcopá ƚiƚpumla, jouc'a litsuflai'ila' contahue, jouc'a lan mac'ojay, jouc'a luhuaƚqueya. Jesús ixaƚ'mena'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ihuej'me axpela' lan xanuc' lun Galilea, jouc'a lan xanuc' ƚiƚpiƚeloƚya' cuftine lan Decápolis, jouc'a lun Jerusalén, jouc'a lan xanuc' nomana' ni petsi al distrito Judea, jouc'a nomana' locuena quiju' el cuecaj pana' Jordán. ");
INSERT INTO chdNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús ixim'mola' axpela' lan xanuc' tihuejyi, if'aj'ma ƚijuala. Jiƚpiya icutshuai'ma. Iƚoc'oƚai'me ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ipango'ma imuc'i'mola', timila': ");
INSERT INTO chdNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Lan xanuc' ts'iƚsina' tehue'ela' juaiconapa, iƚne ƚinca tuyalaicoyi al c'a. Maƚniya timajm'me anuli ȽanDios ƚiƚRey. ");
INSERT INTO chdNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Lan xanuc' nohuotsopá, iƚne ƚinca tuyalaicoyi al c'a. Maƚniya tiƚonc'e'em'mola' liƚpixhuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Lan xanuc' pe aimi'e'eyoƚtsi tsila', iƚne ƚinca tuyalaicoyi al c'a. Maƚniya ixanuc' ȽanDios, iƚque tepi'i'mola' quiƚmane ticuxe'me fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Lan xanuc' nojanajpá latenƚcocopa ȽanDios, nocuapá: “ȽanDios aƚ'e'etsonga' ƚijca laƚpicuejma'”, iƚne ƚinca tuyalaicoyi al c'a. Maƚniya ti'e'em'mola' ƚijca liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Lan xanuc' noximpá cuanuc' liƚpimaye, iƚne ƚinca tuyalaicoyi al c'a. Maƚniya tixinim'mola' acuanuc'la. ");
INSERT INTO chdNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Lan xanuc' ts'anuli liƚpicuejma', iƚne ƚinca tuyalaicoyi al c'a. Maƚniya tixim'me ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Lan xanuc' nocuapá: “Catoc'i'ma ƚaipima. Tuyaiƚa' al c'a iƚque”, iƚne ƚinca tuyalaicoyi al c'a. Maƚniya timetsaicom'mola' inaxque' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Lan xanuc' noteƚcopá mihuejyi al ƚijca cane, iƚne ƚinca tuyalaicoyi al c'a. Maƚniya timajm'me anuli ȽanDios ƚiƚRey. ");
INSERT INTO chdNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Imanc' ts'alihuequi, ja'ni lan xanuc' titaletsolhuo', ja'ni timilojtsolhuo' cataiqui', ja'ni titeƚ'mitsolhuo', ja'ni tinesc'etsolhuo' ma mifel'miyaleyi, imanc' ƚinca tuluyalaicoyi al c'a. ");
INSERT INTO chdNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Toƚta'a imanc' ti'onƚcotolhuo' to lam profeta. Luyaipa quitine ma toƚiya liteƚcopa iƚniya. ¡Toliyuc'tseƚe tixojla' cunlata! Jipu'hua lema'a tipa'a al cueca' lapi'inyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Imanc' ma moƚmana' li'a ƚamats' ti'onƚcospolhuo' to ƚo'hue. ¡Toƚe tipajnla'! Aimi'i'molhuo' to ƚo'hue ƚuyaipa lic'a. Iƚque ƚo'hue aimi'iya milajn‑naya. Lan xanuc' tejuajaispá ƚuna, ti'huailequinna. ");
INSERT INTO chdNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Moƚmana' fa'a li'a ƚamats' imanc' ti'onƚcospolhuo' to lepalc'o', ti'onƚcospolhuo' to liƚya' lilajmpa al toncay ƚijuala, aiquemiya. ");
INSERT INTO chdNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Munai'im'me lepalc'o' aimic'ommumiquinni anuli c'ec. Tipo'nonni pe lopiyopa. Toƚta'a tepalc'o'ila' jahuay nomana' lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma toƚta'a ti'iƚa' loƚ'ejma' imanc'. Tolapalc'o'itsola' loƚf'as xanuc'. Tonƚ'e'etsola' al c'a. Toƚta'a ticua'me: “Acueca' conƚ'Ailli' Nopa'a lema'a. Ac'a iƚque.” ");
INSERT INTO chdNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’¿Te aga toƚnesyi: “Jesús icuaicoco'ma fa'a li'a ƚamats' teteƚƚa' locuxepa ȽanDios, iƚe lataiqui' liniƚijmpa Moisés, jouc'a liniƚijmpa lam profeta”? A'i. Aicuaicoco'ma canant'ƚiƚa' locuxepa ȽanDios, aicateƚya. ");
INSERT INTO chdNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iya' camilhuo' al ƚinca: Ma mipa'a lema'a li'a ƚamats', aimehue'eya ni anuli ƚainila' xonca ƚaca'hua, ni toƚta'a anuli ƚacumi. Iƚe litaiqui' ȽanDios jahuay tipanehuo. Ma' mi'hua menanƚi lixpic'epa ȽanDios, jouc'a ti'hua tipanehuo litaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Anuli cal xans ja'ni aimihuejma iƚiya litaiqui' ȽanDios locuxepa, tama lataiqui' xonca aca'hua, ja'ni timuc'itsola' toƚta'a lif'as xanuc', iƚque cal xans tixinim'me xonca aca'hua pe lomana' lan xanuc' naihuejcopá cal Rey Nopa'a lema'a. Ƚocuena cal xans naihuejcopa ȽanDios, timuc'itsola' lan xanuc' tihuejcoƚe, iƚque tixinim'me acuecaj xans pe lomana' lan xanuc' naihuejcopá ȽanDios cal Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","’Iya' camilhuo': Aimoƚ'onƚico'moƚtsi to lam fariseo ni lomxiye nomuc'iyalepá locuxepa ȽanDios. Tonƚ'eƚe xonca al c'a. Ti'iƚa' xonca al ƚijca loƚ'ejma'. Ja'ni a'i, aimoƚtsuflaiyacu pe lomana' naihuejcopá ȽanDios, iƚque cal Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Imanc' oƚsina' lataiqui' lu'impola' lan xanuc' iƚniya nimajmpá luyaipa quitine. U'impola': “Aimoƚma'ahuale'me. Naitsi noma'ahualepa titai'ma lijunac'. Tecani'em'me.” ");
INSERT INTO chdNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Iya' camilhuo': Cal xans ja'ni ti'hua tixtuc'o ƚipima, titai'ma lijunac'. Cal xans ja'ni timilojla' cataiqui' ƚipima, tilecom'me pe lafoƚyomma lan xanuc' noxpijpá lataiqui'. Cal xans ja'ni tetets'iƚa' ƚipima, timiƚa': “Ima' uncue camac'ta”, iƚque titeƚcota ƚunga pe lopa'a al muf. ");
INSERT INTO chdNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Tocuaitsi pe lotsufcoyompa ȽanDios, ma mopa'a jiƚpiya pe loftsufcoyoya, ja'ni to'nujuaitsi ƚopima tixtuc'ohuo', ");
INSERT INTO chdNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","topo'noƚa' jiƚpiya ƚoftsufcoya, to'huaƚa' toxintsi ƚopima. Topac'etsi lipoyac' ƚopima, toƚmajnle al c'a, toƚpac'enatsoƚtsi. Tijouƚa' topainanni, tocuainata pe loftsufcoyoya, totsufcoƚa' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Iƚque naixtuc'opo' ja'ni ti'hua'atso' cal juez, aimicoƚ'mo', topac'eƚa'. Topalaic'oƚa' ma monƚeyi lane. Ja'ni a'i, iƚque ticufto' cal juez, cal juez ticuto', lapaluc' titats'e'mo'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iya' camihuo' al ƚinca: Ma mi'hua cotaiyinge, tama tutani le'a, jiƚpiya topajnta, aimaipaya. ");
INSERT INTO chdNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Imanc' oƚsina' lu'impola' lan xanuc' nimajmpá luyaipa quitine. U'impola': “Aimoxhuico'ma ƚipeno ƚof'as xans”. ");
INSERT INTO chdNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Iya' camilhuo': Cal xans mehuelonge anuli ƚaca'no', ja'ni ticua lipicuejma': “Caxhuicoƚa'”, iƚque cal xans joupa itaipa lajunac'. Tocomma to joupa ixhuicopa. ");
INSERT INTO chdNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Camihuo': Ja'ni iƚe lofmehuelojmpa timenac'ihuo', topulcufla' lo'u, taca'niƚa' aculi', tama iƚiya lo'u al c'a camane. Toƚta'a ma le'a anuli lo'u tejac'ma aimimef'minyaco' ƚunga. ");
INSERT INTO chdNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ja'ni lomane timenac'ihuo', tama iƚiya al c'a comane, tatejla', taca'niƚa' aculi'. Toƚta'a ma le'a anuli lomane tejac'ma, aimimef'minyaco' ƚunga. ");
INSERT INTO chdNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Luyaipa quitine uya'ampá: “Cal xans nixpic'epa tux'masla' ƚipeno, tepi'iƚa' lije'e, tijouƚa' tux'masnaƚa'”. ");
INSERT INTO chdNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iya' camilhuo': A'i. Cal xans aimi'iya mux'masya ƚipeno. Ja'ni ƚaca'no' joupa ihuejpa ocuenaj xans, ƚipe'ailli' nipajnya tux'masla'. Ja'ni a'i aimi'iya. Iƚque ƚaca'no' joupa ƚux'masquimpa ja'ni tihuejla' ocuenaj xans, titai'ma lajunac'. Naitsi nolecoya ƚaca'no' jouc'a titai'ma lajunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Jouc'a oƚsina' lu'impola' lan xanuc' nimajmpá fa'a luyaipa quitine, ticuayi: “Ja'ni o'epa jurar, aimopai'i'ma jiƚiya lotaiqui'. Lotaiqui' joupa o'epa jurar ȽanDios, tanant'ƚi'ma. Ja'ni aimanant'ƚi, totai'ma lajunac'.” ");
INSERT INTO chdNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iya' camilhuo': Aimo'e'ma jurar. Aimocua'ma: “Por lema'a”. Jiƚpiya ticutsu ȽanDios cal Cuecaj Juez. ");
INSERT INTO chdNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aimocua'ma: “Por li'a ƚamats'”. Li'a ƚamats' tocomma to ƚipitas ȽanDios lacaxaf'i'ipa li'mitsi'. Aimocua'ma: “Por al cuecaj quiƚya' Jerusalén”. Jiƚpiya ipiƚya' ȽanDios cal Rey. ");
INSERT INTO chdNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jouc'a aimocua'ma: “Por ƚaijuac”. Ima' cotuca' aimi'iya mocuxe'eya ƚojuac. Anuli lajuac lumi aimi'iya mo'eya fujca. Jouc'a lajuac al fujca aimi'iya mo'eya umi. ");
INSERT INTO chdNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aimo'e'ma jurar. Ma le'a tocua'ma: “Toƚta'a ca'e'ma”, o “A'i, aica'eya”. Aimoƚof'i'ma cataiqui'. Ja'ni toƚof'i cataiqui' a'i ȽanDios micuxe'ehuo' iƚiya lofnespa. Ma le'a ƚonta'a ticuxe'ehuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Oƚsina' luya'ampá luyaipa quitine, ticuayi: “Anuli cal xans ja'ni joupa ipa'empá anuli li'u, iƚque mipai'iconghua, tipa'econa'ma ma le'a anuli li'u. Ja'ni anuli cal xans tipa'em'me anuli li'ay, iƚque mipai'iconghua, tipa'econa'ma ma le'a anuli li'ay.” ");
INSERT INTO chdNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iya' camilhuo': Ja'ni a'ijc'a lo'epo', aimocuanaj'moxi. Ja'ni tuntafhuo' lopeque al c'a camane, tocufiƚa' lopeque loxa camane tuntafcontso'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ja'ni ticuxecotso', texic'e'mo' lotsamalo, tommi'iƚa' lotsamalo jouc'a tommi'iƚa' lopuquiya. ");
INSERT INTO chdNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ja'ni ts'ipenic' ticuxe'etso' timitso': “Lacanumf'eta cane oquej kilometro. Aƚtoc'iƚa' ƚainitay”, ima' tacanumf'eta amalpu kilometro. ");
INSERT INTO chdNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Naitsi noxahue'epo', tapi'iƚa'. Ja'ni tixahue'etso', timitso': “Lapi'iƚa', tijouƚa' cacuai'enaco'”, aimocuanaj'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Imanc' oƚsina' luya'ampá luyaipa quitine, ticuayi: “To'e'ma capic'a ƚopima. Aimo'e'ma capic'a naixtuc'opo'. Iƚque to'e'ma laic'.” ");
INSERT INTO chdNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Iya' camilhuo': Tonƚ'e'mola' capic'a naixtuc'opolhuo'. Toƚsahue'eƚe ȽanDios titoc'itsola' iƚniya noteƚ'mipolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ja'ni toƚe loƚ'ejma' aƚinca ti'i'molhuo' inaxque' ȽanDios, iƚque coƚ'Ailli' Nopa'a lema'a. Iƚque ticuxe'e ƚi'ora tepalc'o'itsola' jahuay lan xanuc'. Ja'ni lan c'a xanuc', ja'ni lixcay xanuc' tepalc'o'ila'. Jouc'a ticuxe'e ticuiƚa' ni petsi lomana' lan xanuc', petsi no'epá al c'a, jouc'a petsi no'epá lixcay, ma' anuli ticui'e. ");
INSERT INTO chdNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ja'ni toƚ'etsola' capic'a ma le'a iƚne no'epolhuo' capic'a, ¿te cululijpa? Ma toƚta'a mi'eyi lin'najts'i'iyale. ");
INSERT INTO chdNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ja'ni ma le'a toƚnonnila' loƚpimaye, ¿te ma tonƚ'eyi xonca al c'a? A'i. Lan xanuc' pe aimimetsaicoyi ȽanDios toƚe mi'eyi. ");
INSERT INTO chdNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Coƚ'Ailli' Nopa'a lema'a ti'ay pangay al c'a. Imanc' jouc'a tonƚ'eƚe pangay al c'a. ");
INSERT INTO chdNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ja'ni imanc' tolapi'i'mola' lan xanuc' quiƚtomí, aimoƚcua'me: “Aƚsintsonga' lan xanuc'. Limetsaico'monga' ninc'ic'a xanuc'.” Ja'ni toƚe toƚcuayi ailopa'a capi'iyacolhuo' coƚ'Ailli' Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Monlapi'ila' quiƚtomí lan xanuc' pe aiquiƚ'hueca, aimoƚ'e'me to mi'eyi lan xanuc' iƚne no'e'epoƚtsi to joupa ixanghuaitola' liƚpicuejma'. Iƚne micu'me al tomí tifus'miyi liƚtrompeta, ticuayi: “¡Aƚsinƚa'! Iya' capi'i'ma quitomí iƚca'a cal xans, iƚque aiqui'hueca.” Toƚta'a mi'eyi mimana' ƚajut'ƚi pe lafoƚyomma lan xanuc' o miyeyi lexpats'qui cane, toƚta'a mi'eyi. Iƚniya ticuayi: “Alimetsaicontsonga' xonca ac'a laƚpicuejma', laƚ'ejma'”. Iya' camilhuo': Ne', ¡toƚe timetsaicontsola'! Ailopa'a capi'iyacola' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ima' toƚta'a aimo'e'ma. Ja'ni tapi'itsola' quiƚtomí lan xanuc' pe aiquiƚ'hueca, to'eƚa' ch'ixca. Aimoya'a'ma lof'eya. Ni ima' cotuca' aimo'nujuais'ma locupa. Ni loxa camane mixim'ma lo'epa al c'a camane. ");
INSERT INTO chdNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Toƚta'a aimixininyaco' motoc'ila' iƚne lan cuanuc'la. Co'Ailli' Nopa'a lema'a iƚque ƚinca tehuelojnhuo' iƚe lof'epa jiƚpe petsi aimehuelojnhuo' lan xanuc'. Iƚque tepi'i'mo' lofmulijya. ");
INSERT INTO chdNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ma' moƚpalaic'oyi ȽanDios, aimoƚ'e'e'moƚtsi to iƚniya lan xanuc' no'e'epoƚtsi to joupa ixanghuaitola' liƚpicuejma'. Iƚniya mipalaic'oyi ȽanDios tecaxoƚanna jiƚpiya ƚajut'ƚi pe lafoƚyomma lan xanuc'. Jouc'a tipalaic'oyi ȽanDios mecaxingoƚaiyi pe ƚatenuficopa ƚaneya. Ma toƚta'a iƚpic'a. Ticuayi: “¡Aƚsintsonga' lan xanuc' maƚpalaic'oyi ȽanDios!” Iya' camilhuo': Ne'. Joupa ixinimpola'. Joupa tipa'a lolijyacu. Ailopa'a xonca. ");
INSERT INTO chdNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ima' aimo'e'ma to iƚniya. Ja'ni topalaic'o'ma ȽanDios totsufai'ma lomejut'ƚ, tati'i'ma lopuerta. Jiƚpiya cotuca' topalaic'o'ma co'Ailli', iƚque Nopa'a petsi lan xanuc' aimi'iya mixinyacu. Iƚque co'Ailli' ƚinca tehuelojnhuo' lof'epa, iƚe to'ay petsi aimehuelojnhuo' lan xanuc'. Ma' iƚque tepi'i'mo' lofmulijya. ");
INSERT INTO chdNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Imanc' moƚpalaic'oyi ȽanDios aimoƚ'e'me to mi'eyi lan xanuc' pe aimimetsaicoyi ȽanDios. Iƚne mixahue'eyi lilendiosla' timiyi axpe' cataiqui'. Aiquiƚsina' te locuapa. Ticuayi: “Aƚmitsola' axpe' cataiqui', toƚta'a lalandiosla' aƚquimf'e'monga'”. ");
INSERT INTO chdNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Imanc' aimoƚ'onƚico'moƚtsi to liƚ'ejma' iƚnu'hua. Coƚ'Ailli' ixina' iƚe lahue'epolhuo' ai'a toƚsahue'e'me. ");
INSERT INTO chdNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Moƚpalaic'oyi ȽanDios toƚmiƚe: Ima' aƚ'Ailli' cofpa'a lema'a, timetsaicontso' apaxi lopuftine. ");
INSERT INTO chdNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ticuaitsi litine petsi jahuay lan xanuc' timetsaicotso' ima' iƚRey. Pu'hua lema'a jahuay tihuejcohuo', toƚta'a tihuejcotso' fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ƚaƚtepa itine itine, lapi'itsonga' itsiya. ");
INSERT INTO chdNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Illanc' joupa limenc'e'ecopola' iƚne ts'aƚtaiyinc'enga'. Ima' jouc'a limenc'e'ecotsonga' iƚe laƚtaiyinc'ehuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aimaƚƚeco'monga' petsi lalahuaiyonyaconga'. Ja'ni tiƚoc'huai'ma pe laƚmana' ƚixcay xans, ¡ima' lunƚu'etsonga'! ");
INSERT INTO chdNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Imanc', ja'ni tolimenc'e'ecotsola' loƚf'as xanuc' iƚe lo'epolhuo', jouc'a coƚ'Ailli' Nopa'a lema'a timenc'e'eco'molhuo' iƚe lixcay lonƚ'epa. ");
INSERT INTO chdNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ja'ni imanc' aimolimenc'e'ecola' loƚf'as xanuc' lo'epolhuo', coƚ'Ailli' Nopa'a lema'a jouc'a aimimenc'e'ecoyacolhuo' lixcay lonƚ'epa. ");
INSERT INTO chdNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Imanc' moƚsnet'ƚyi aimoƚtetsoyi, aimonƚ'e'me to lan xanuc' iƚne no'e'epoƚtsi to joupa ixanghuaitola' liƚpicuejma'. Iƚne mixnet'ƚyi aimitetsoyi, ti'e'eyoƚtsi to nohuotsopá. Tupaxc'eyoƚtsi liƚ'a, tixinintsola' lan xanuc' tixnet'ƚyi iƚniya. Iya' camilhuo': Ne'. Joupa ixinimpola' toƚiya. Joupa tipa'a lolijyacu. Ailopa'a xonca. ");
INSERT INTO chdNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ima' moxnet'ƚqui, to'huaƚcufla' al c'a ƚojuac, to'ot'ƚiƚa' laceite, tapajla' lo'a. ");
INSERT INTO chdNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Toƚta'a tixinim'mo' to aimoxnet'ƚqui, tocomma ma totesma. Ma le'a co'Ailli' tixina, iƚque Nopa'a pe lan xanuc' aimi'iya mixinyacu. Iƚque ƚinca tehuelojnhuo' lof'epa jiƚpe petsi aimixinghuo' lan xanuc'. Ma' iƚque' tepi'i'mo' lofmulijya. ");
INSERT INTO chdNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Imanc' aimolafot'ƚe'me coƚ'huexi fa'a li'a ƚamats'. Jifa'a iƚe ƚoƚ'huexi tijouna'ma. Lan huoxmi tite'me o tunxilai'ma, o lan namats' titsuflai'me lomejut'ƚ, tinantsej'mo'. ");
INSERT INTO chdNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma moƚmana' fa'a li'a ƚamats' xonca tonƚ'eƚe ti'iƚa' ƚoƚ'huexi jipu'hua lema'a. Jiƚpe aimiteji lan huoxmi, ailopa'a. Aimunxilaiya. Ni lan namats' aimitsuflaiyacu lomejut'ƚ minantsejyaco'. Jiƚpiya ailopa'a. ");
INSERT INTO chdNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pe lopa'a ƚoƚ'huexi maƚpiya copa'a loƚpixojma cata. ");
INSERT INTO chdNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Lo'u tepalc'o'ihuo'. Ja'ni ac'a lo'u toxim'ma pe lof'huaya, toxim'ma iƚe lof'epa. ");
INSERT INTO chdNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ja'ni a'ijc'a lo'u topanehuo al muf. Ma' anuli ja'ni to'ehuale laic', joupa i'ipa a'ijc'a lopicuejma', aimepalc'o'ihuo'. Ja'ni joupa imufc'opa lopicuejma', ¡acueca' juaiconapa iƚe al muf! ");
INSERT INTO chdNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Cal xans ticuicomma ma le'a anuli ƚipoujna. Ja'ni oquexi' tixtuc'o'ma anuli, ƚocuena ti'e'ma capic'a. O tixinc'ne'ma anuli, tetets'i'ma ƚocuena. Imanc' jouc'a ticuicomma ma le'a anuli ƚoƚPoujna, iƚque ȽanDios. Aimi'iya molihuejcoyacu al tomí jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Iya' camilhuo': Aimoƚsueƚmot'ƚe'me lonluyalaicoyacu lapajnya fa'a li'a ƚamats', ja'ni ti'i'ma o aimi'iya. Aimoƚcua'me: “¿Te caƚtejacu? ¿Te caƚsnayacu? ¿Te caƚju'ecoyacoƚtsi?” Loƚcuerpo ƚinca xonca acueca' lipitali, loƚju'ecoyacoƚtsi aijtine. Jouc'a ƚoƚ'alma xonca acueca' lipitali, ƚoƚtejacu aijtine. ");
INSERT INTO chdNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Toƚsinƚe lacaƚ'hui naiyulpá lema'a. Iƚniya aimifayi, aimefot'ƚeyi, ailopa'a quiƚ'huecoƚma mi'huejyacu ƚotejacu. Coƚ'Ailli' Nopa'a lema'a tites'mila'. Iƚque, ¿ja'ni aimi'nujuaitsilhuo' imanc'? Ƚinca, xonca ti'nujuaitsilhuo', tixinnilhuo' xonca acueca' loƚpitali. ");
INSERT INTO chdNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Imanc' tama toƚsueƚ'mecoyi juaiconapa, ¿te aga ti'i'ma tonƚ'e'e'moƚtsi xonca unc'itoƚqui? A'i. Aimi'iya ni huata. ");
INSERT INTO chdNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Te coƚsueƚcocopa? Toƚcuayi: “¿Te quijahua' caƚpo'noyacu?” Toƚsinƚe ƚaiquitamqui ƚotojpa cal 'ec'. Tipa'a ƚaiquiƚpipa'. Iƚne ƚaiquitamqui aimucuiyi, aimi'eyi canic'. ");
INSERT INTO chdNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma ȽanDios tiju'ecojma ƚaiquipipa'. Iya' camilhuo': Cal cuecaj rey Salomón, lipo'nopa al c'a lipijahua', tama i'huáqui juaiconapa acueca' quincuxepa, iƚquiya aiqui'onƚi to ƚaiquipipa' ƚaiquitamqui. ");
INSERT INTO chdNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ȽanDios tiju'e'ela' juaiconapa ac'a ƚaiquitamqui cal 'ec'. Iƚne ƚaiquitamqui aimicoƚila'. Anuli litine titoquila' ac'a, locuena quitine tiyaxquemma, tipi'enni lapa. Imanc', ¿te ȽanDios aimiju'eyacolhuo'? Ah imanc', huata toƚ'huaiyijnyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","’Aimoƚsueƚco'me. Aimoƚnes'me: “¿Petsi caƚsi'neyacu caƚtejacu, caƚsnayacu? ¿Petsi caƚsi'neyacu caƚpijahua'?” ");
INSERT INTO chdNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Lan xanuc' pe aimimetsaicoyi ȽanDios tuyalaicoyi lapajnya tehueyi iƚna'a. Coƚ'Ailli' Nopa'a lema'a ixina' te ts'i'ic' lahue'epolhuo'. Iƚque tepi'i'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Toƚpo'noƚe loƚpicuejma' tolihuejcoƚe ȽanDios cal Cuecaj Rey, tonƚ'eƚe al c'a ma to locuxe'epolhuo'. Tijouƚa' tepi'i'molhuo' jahuay. Aimehue'eyacolhuo', ni toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","’Aimoƚsueƚmot'ƚe'me. Aimoƚcua'me: “¿Te caluyalaicoyacu mouqui?” Mouqui toƚsim'me lo'iyacolhuo'. Ma' itsiya tipa'a loƚteƚcopa. Ja'ni toƚsueƚcoyi lo'iya mouqui xonca ipime toƚsim'me itsiya. ");
INSERT INTO chdNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Imanc' aimoƚnesc'e'mola' loƚf'as xanuc', toƚta'a aiminesc'econayacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ma to imanc' toƚpalaicola' loƚf'as xanuc' ma toƚta'a tipalaicom'molhuo'. Ma to moƚspif'caleyi, ma toƚta'a tixpif'quim'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ima', ¿te cofmehuelojncopa ƚopima mipa'a anuli ƚaquifuc li'u? Ima' aicoxina' to jipu'hua anuli laxma tipa'a lo'u. ");
INSERT INTO chdNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mipa'a laxma jiƚpe lo'u, ¿te cofmicoya ƚopima: “Lapi'iƚa' lane quipa'e'e'mo' ƚaquifuc ƚopa'a lo'u”? ");
INSERT INTO chdNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ma le'a to'e'eyoxi xonca unc'a. Ate'a' taipa'aƚa' laxma lopa'a lo'u. Tijouƚa' ja'ni joupa mipa'apa, ti'i'ma toxim'ma ƚaquipifuc ƚopa'a li'u ƚopima, taipa'e'ena'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Aimolapi'i'mola' lan tsiƚqui ƚi'huexi ȽanDios. Lajune' lilanc'ecompa aperla, iƚniya acueca' lipitali, aimolacani'i'mola' lijná. Iƚniya ti'huailej'me lam perla, tijouƚa' tits'aletsuftolhuo' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ti'hua toƚsa'hueƚe, tijouƚa' tepi'im'molhuo'. Ti'hua tolahueƚe, tijouƚa' toƚsim'me. Ti'hua tolumf'asle al puerta, tijouƚa' texi'em'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lan xanuc' noxa'huepá, tepi'im'me. Jouc'a nahuepá, tixim'me. Jouc'a nomf'axpá, texi'em'me. ");
INSERT INTO chdNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Imanc' unc'ixanuc', ja'ni tixahue'etsolhuo' ƚa'i loƚnaxque', ¿te tolapi'i'mola' ƚapic? ");
INSERT INTO chdNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ja'ni tixahue'etsolhuo' ƚatu, ¿te tolapi'i'mola' ƚainofaƚ? Ƚinca ailopa'a no'eya toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Imanc', tama tipa'a loƚjunac', tipa'a loƚpicuejma', tonlapi'i'mola' al c'a loƚnaxque'. Conƚ'Ailli' Nopa'a lema'a, xonca acueca' iƚque lipicuejma'. Toƚta'a tepi'i'molhuo' al c'a ja'ni toƚsahue'eƚe. ");
INSERT INTO chdNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ja'ni aimetenƚcocolhuo' lo'e'epolhuo' loƚf'as xanuc', aimoƚ'e'me jouc'a imanc' toƚiya. Ma toƚta'a loya'apa locuxepa ȽanDios, jouc'a lomuc'iyalepa lam profeta. ");
INSERT INTO chdNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Toƚtsulfoƚaitsa iƚe al tansca al puerta. Tipa'a ocuena al puerta, jiƚiya expats'qui, jiƚpiya copa'a lotsufaicopa lexpats'qui cane. Jiƚe lane lotsepa pe lajac'eyacola'. Iƚe al puerta lexpats'qui axpela' noximpá. ");
INSERT INTO chdNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma le'a oquexi' afantsi noximpá locuenaj al puerta, iƚiya atansca, lotsufaicopa al tansca cane. Jiƚe lane lotsepa pe lolijyacu al ts'e liƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’¡Toƚ'e'etsoƚtsi cuenna! Ticuaicu pe loƚmana' lam profeta nofelaiquepá. Iƚniya ti'onƚcospola' to lam mot'ƚ. Tocomma ailopa'a co'epa iƚniya. A'ij ƚinca. Ituca' liƚ'ejma'. Iƚniya oyac'la to lan lobo, iƚne linneja notepá lam mot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Iƚne liƚ'ejma' timuc'i'molhuo' te ts'i'ic' liƚpicuejma'. Al 'ec ƚi'as timuc'i'molhuo' jale c'ec iƚta'a. ¿Te litac cantsinni ti'as'ma a'uva? ¿Te litac al xumi ti'as'ma a'higo? A'i, aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jahuay al c'a c'ec mi'atsi, ac'a ƚi'as. Lixcay c'ec mi'atsi, ixcay ƚi'as. ");
INSERT INTO chdNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Al c'a c'ec aimi'iya mi'asya ƚixcay qui'as. Lixcay c'ec aimi'iya mi'asya cal c'a qui'as. ");
INSERT INTO chdNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Al 'ec, ja'ni a'ijc'a ƚi'as, tetequim'me, tixanc'onna ƚunga, tipi'enna. ");
INSERT INTO chdNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iya' camilhuo': Tolahuelojntsola' iƚne lam profeta te ts'i'ic' liƚ'ejma'. Toƚta'a tolimetsaicona'mola' infel'miyale. ");
INSERT INTO chdNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Lan xanuc' tama aƚmiƚa': “¡MaiPoujna, maiPoujna!”, a'i jahuay iƚniya mitsuflaiyacu pe locuxeyopa ȽanDios, iƚque Nopa'a lema'a. Pe naihuejcopá lixpic'epa cai'Ailli' Nopa'a lema'a, iƚne ƚinca titsuflaita. Locuenaye aimitsuflaiyacu. ");
INSERT INTO chdNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ticuaitsi iƚe al Cuecaj Quitine axpela' aƚmi'ma: “¡MaƚPoujna, maƚPoujna! Illanc' oxanuc', toƚta'a aluya'apá lonespa ȽanDios, jouc'a lipa'apola' lontahue, jouc'a aƚ'epá axpe' acueca'.” ");
INSERT INTO chdNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iya' catalai'e'e'mola', cami'mola': “Iya' aicainimetsaicolhuo'. ¡Tonƚeƚe! ¡Tonƚolijnle! Imanc' aimonƚ'eyi locuxepa ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Cal xans ƚaƚquimf'epa laitaiqui' jouc'a lihuejma, iƚque ipicuejma' cal xans. Ca'onƚico'ma to cal xans nolanc'epa lejut'ƚ. Ipucufpa qui'huajcopa ƚapic, jiƚpiya itsahue'emma lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lijoupa lilanc'epa lejut'ƚ icui'ma juaiconapa. Ixpe'ma laja' cal panay, ipac'o'ma. I'hua'ma ƚahua'. I'hua'ma ujfxi, unajm'ma lajut'ƚ. Iƚe lajut'ƚ aits'ifentsi, aiquecangenni. Joupa ilajmpa pe litsahueyomma apic. Ailopa'a qui'ipa. ");
INSERT INTO chdNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","’Cal xans ƚaƚquimf'epa laitaiqui', ja'ni aimalihuejma, iƚque a'i quipicuejma' cal xans. Ca'onƚico'ma to cal xans nilanc'epa lejut'ƚ litsahueyomma acuixa. ");
INSERT INTO chdNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Icui'ma juaiconapa. Ixpe'ma laja' cal panay, ipac'o'ma. I'hua'ma ujfxi ƚahua', unajm'ma lajut'ƚ. Eteƚquemma. Ecanipa nulemma. ");
INSERT INTO chdNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lijou'ne'ma Jesús iƚna'a ƚitaiquí lan xanuc' ticuayi: ―Ƚinca acueca' iƚe litaiqui' laƚmuc'iponga'. ");
INSERT INTO chdNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Lomxiye nomuc'iyalepá locuxepa ȽanDios a'i mimuc'iyaleyi to lomuc'iyalepa Jesús. Iƚque ƚinca joupa epi'impa limane timuc'iyaletsi, iƚniya a'i. ");
INSERT INTO chdNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Limunanni ƚijuala Jesús ihuej'me axpela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Icuaiyunni anuli cal xans iteca cahui. Iƚe al cuana cuftine lepra. Exc'onƚingai'ma Jesús, timi: ―Maipoujna, ima' nipajnya latufc'enƚa', caxinxoxi aƚ'inƚa' limpio. ¿Ja'ni to'e'ma? ");
INSERT INTO chdNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús i'nij'ma limane, iƚaf'ma ƚafcuana, timi: ―Ca'e'ma. Ti'intso' limpio. Aiquicoƚ'ma, iƚojn‑na'ma lehui. I'ina'ma limpio. ");
INSERT INTO chdNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús timi: ―Aimoya'a'ma iƚe lai'e'epo'. ¡To'huanƚa'! Jiƚpe al cuecaj xoute' tomujtoxi ƚa'ailli'. Totsufcota ma to licuxepa Moisés. Toƚta'a aƚsim'monga' illanc' lihuejcoyi iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús itsufai'ma liƚya' Capernaum, icuaiyunni anuli nocuxepola' amaxnu lisoldado. Tixa'hue Jesús titoc'iƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Timi: ―Maipoujna, ƚaimozo textafque, tunouya lainejut'ƚ. Joupa uhuaquemma. Tixina acueca' cumla. ");
INSERT INTO chdNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús timi: ―Ai'huapa, caxaƚ'menna. ");
INSERT INTO chdNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Iƚque nocuxepola' lisoldado timi: ―Maipoujna, aimo'e'ma toƚta'a. A'i caxa'huehuo' mo'huaya motsufaiya lainejut'ƚ. Iya' caxinyoxi juaiconapa na'hua xans. Ma le'a tocuaƚa': “Tixaƚconaƚa' ƚomozo”, tijouƚa' ma tixaƚcona'ma. Toƚta'a aixina'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iya' jouc'a quihuejma ƚaƚcuxepa, cacuxela' laisoldado. Cami'ma anuli: “To'huaƚa'”, iƚque ti'hua'ma. Ƚocuena cami'ma: “To'huanni”, iƚque ti'huamma. Cami'ma ƚaimozo: “To'eƚa'”, iƚque ti'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Licuejpa Jesús toƚta'a linespa ƚincuxepa, etenƚcoco'ma juaiconapa. Timila' iƚne ts'iƚenc'e: ―Imanc' ixanuc' Israel olimetsaijma ȽanDios. Iƚca'a cal xans lixanuc' aimimetsaicoyi ȽanDios. Camilhuo' al ƚinca: Ni anuli imanc' caixina to iƚca'a cal xans. Iƚca'a ƚinca xonca ti'huaiyinge ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Camilhuo': Ticuaita locuenaye lan xanuc', iƚniya nomana' pe liyuf'ma cal 'ora, jouc'a lan xanuc' nomana' pe lof'acaiyopa cal 'ora. Jouc'a loƚtatahueló Abraham, Isaac, y Jacob, ticutsoƚaita anuli pe locuxeyopa ȽanDios, iƚque cal Cuecaj Rey. ");
INSERT INTO chdNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ituca' lo'iyacola' iƚniya nocuapá: “Ma' illanc' inaxque' ȽanDios cal Rey”. Iƚne tihuescufinnola' ƚuna, jiƚpiya al muf. Maƚpe tijolijta, ti'ilc'ta liƚ'ay. ");
INSERT INTO chdNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Timi nocuxepola' lisoldado: ―Ima' aƚ'huaiyijmpa, tonesqui: “Tixaƚcona'ma ƚaimozo”. To'huaƚa'. Ma to lonespa, toƚta'a ti'iƚa'. Maƚe 'hora ixaƚcona'ma ƚimozo iƚque nocuxepola' lisoldado. ");
INSERT INTO chdNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús icuaitsi lejut'ƚ Pedro, jiƚpe ixim'ma ƚi'maco Pedro tunouya textafque, tepi'i quinu'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús i'noƚ'e'e'ma limane. Iƚojn‑na'ma ƚipinu'. Iƚque ƚaca'no' itsahuenanni, ites'mi'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lummuhuaitsi i'hua'am'mola' pe lopa'a Jesús axpela' lan xanuc' litsuflai'ila' contahue. Jesús ma le'a icuxe'e'mola' lontahue tipalunca, iƚniya ipalumma. Jouc'a ixaƚ'mena'mola' jahuay lafcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Toƚta'a enanƚcopa linespa cal profeta Isaías luya'apa: “Ma iƚque aƚsaƚ'meponga' laƚtafc'eponga', liƚonc'e'enaponga' laƚcuana”. ");
INSERT INTO chdNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lixim'mola' axpela' lan xanuc' ts'iƚenc'e, Jesús timila' ts'ilihuequi: ―Ƚepá, aƚquiepá al cueca' quin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ai'a tiye'me icuaitsi anuli ƚomxi nomuc'iyalepa locuxepa ȽanDios, timi Jesús: ―Momxi, ni petsi loftseya, iya' jouc'a quihuej'mo'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús timi: ―Lan t'ƚeya tipa'a liƚpunts'ejay. Lacaƚ'hui naiyulpá lema'a tipa'a liƚpuxiƚ'na. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a, iya' ailopa'a caifxmai'eya. ");
INSERT INTO chdNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ocuena cal xans mihuequi Jesús timi: ―Momxi, lapi'iƚa' lane ca'hua'ma. Quimaf'i cai'ailli' capajnta jiƚpe lainejut'ƚ. Tijouƚa timanƚa', caminna, quihuejcona'mo'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús timi: ―Lihuejla' itsiya. Lomapola' ti'i'ma temitsa liƚf'as lomapola'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Itsufai'ma al barco. Ts'ilihuequi itsuflai'me jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Muyalaicoyi ipanni ujfxi ƚahua'. Ƚaja titsahuemma, tuyanc'ne al barco. Tixc'uaf'caispa caja'. Jesús tixmay. ");
INSERT INTO chdNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ts'ilihuequi Jesús icuaiyunca, ummef'me, timiyi: ―Maƚpoujna, ¡lunƚu'etsonga'! ¡Aƚma'monga'! ");
INSERT INTO chdNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús timila': ―Ah imanc', ¿te coxpailijcopolhuo'? Ma' ahuata aƚ'huaiyinge. Itsahuenni, itale'mola' ƚahua', ƚaja. Jahuay i‑ch'ixco'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ts'ilihuequi ixim'me acueca' iƚe li'epa Jesús. Timiyoƚtsi: ―¿Naitsi iƚca'a cal xans? Ticuxe'ela' ƚahua', ƚaja, tihuejcoyi. ");
INSERT INTO chdNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Icuaitsa locuena quiju' al cueca' quin'nuhua'. Jiƚpiya ilemats' iƚne lan xanuc' gadareno. Oquexi' ipalunca pe lamu'empola' lomapola', icuai'me pe lopa'a Jesús. Lontahue joupa itsuflaipá iƚne loquexi'. I'ipola oyac'la. Lan xanuc' aimi'iya muyalaicoyacu jiƚe lane. ");
INSERT INTO chdNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iƚniya loquexi' tija'ayi, timiyi Jesús: ―Ima' i'Hua ȽanDios, ¿te cocuaiyoco'ma fa'a laƚmana'? ¿Te ts'opic'a? Itsiya aimaƚteƚ'miyaconga' ȽanDios. Aiquicuaiya litine, tehue'e. ¿Te itsiya ima' aƚteƚ'mi'monga'? ");
INSERT INTO chdNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A'ij culi' jiƚpiya timana' axpela' lijná titeji quiƚpitamqui. ");
INSERT INTO chdNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lontahue ixa'hue'me Jesús, timiyi: ―Ja'ni lipa'a'monga' iƚniya lan xanuc', lapi'itsonga' lane aƚtsuflaita iƚne lijná. ");
INSERT INTO chdNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús timila': ―Ne', tonƚeƚe. Lontahue ipalunca lan xanuc', itsuflai'me lijná. Jahuay iƚniya lijná inul'me liculhuo, i'nijmoƚaitsa laja', unxaƚac'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nohuic'ipola' lijná inul'me. Iyena'me, icuaitsa liƚya', uya'atsa jahuay li'ipa, iƚe li'ipola' loquexi' lan xanuc' litsuflai'ila' contahue. ");
INSERT INTO chdNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Licuej'me jiƚiya, ipalunca jahuay lan xanuc' nomana' liƚya', italefcuftsa Jesús. Lixim'me, ixa'hue'me ti'huanƚa', tipananni ƚilemats'. ");
INSERT INTO chdNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús if'aj'ma al barco, uyaicona'ma al cueca' quin'nuhua'. Icuaitsi lipiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jiƚpiya icuai'entsa anuli cal xans textafque, uhuaquemma licuerpo. Tunafya cal huijm‑ma'. Jesús ixim'mola' iƚne lan xanuc' ti'huaiyijnyi, timi ƚuhuaqueya: ―Mai'hua, aimoxhueƚmot'ƚe'ma. Joupa iƚojn‑napa lojunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Licuej'me toƚta'a lonespa Jesús oquexi' afantsi lomxiye nomuc'iyalepá locuxepa ȽanDios timiyoƚtsi: “Iƚque cal xans Jesús ti'e'eyoxi to ȽanDios”. ");
INSERT INTO chdNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús ixina' locuapa jiƚpe liƚpicuejma' iƚne lan xanuc', timila': ―Imanc', ¿te coƚcuacopa quixcay jiƚpe loƚpicuejma'? ");
INSERT INTO chdNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ja'ni toƚsinyi ipime iƚiya laimipa cal xans: “Lojunac' joupa iƚojn‑napa”? Ja'ni camiƚa': “Totsahuenni, to'huaƚa'”, ¿te toƚsim'me a'i quipime iƚe lataiqui'? ");
INSERT INTO chdNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Itsiya camuc'i'molhuo' icueya laimane. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ma capa'a fa'a li'a ƚamats' nipajnya quiƚonc'e'e'mola' lan xanuc' liƚjunac'. Timi ƚuhuaqueya: ―Totsahuenni, tonif'la' ƚohuijm‑ma'. To'huanƚa' lomejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cal xans itsahuenni. I'hua'ma lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lan xanuc' ixim'me acueca' iƚe li'epa Jesús. Tix'najtsi'iyi ȽanDios, ticuayi: ―Ƚinca, ȽanDios epi'ipa toƚta'a limane iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús tuyaipa jiƚpiya. Mi'hua lane ixim'ma anuli cal xans lipuftine Mateo. Ticutsu pe lo'najtsi'iyaleyompa. Jesús timi: ―¡Lihuejla'! Mateo itsahuenni, ihuej'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús jouc'a ts'ilihuequi icuai'me lejut'ƚ Mateo. Jiƚpiya titetsoyi anuli axpela' lan xanuc', iƚniya in'najtsi'iyale jouc'a ocuenaye xanuc' pe aimihuejcoyi locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lan xanuc' fariseo ixim'me Jesús ticutsu jiƚpe. Icuis'e'me, timinnila' ts'ilihuequi Jesús: ―Imanc' ƚoƚpomxi, ¿te cotetsocopa anuli iƚniya lan xanuc'? Iƚne in'najtsi'iyale jouc'a ocuenaye xanuc' pe aimihuejcoyi locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús icuej'mola' iƚne laicuitsufpa, timila': ―Lan xanuc' pe ailopa'a quiƚcuana aimicuicomma no'eyacola' cafxi. Laxtafpola' ƚinca ticuicomma no'eyacola' cafxi. ");
INSERT INTO chdNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Imanc' tonƚenƚe, tolihuic'itsa lohuaƚquemma iƚe lataiqui' liniƚiya loya'apa lonespa ȽanDios, ticua: Imanc' ti'hua aƚtsufma loƚpinneja loƚma'apola'. Iya' xonca latenƚcoco'ma toƚtsintsola' cuanuc'la iƚne loƚf'as xanuc'. Iya' aicuaicoco'ma fa'a li'a ƚamats' cajoc'itsola' pe ts'iƚtaic' quiƚjunac', tixhuej'menanca. Aicajoc'ila' pe ailopa'a quiƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ts'ilihuequi Juan Bautista icuaitsa pe lopa'a Jesús, timiyi: ―Illanc' aƚsnet'ƚyi, aimaƚtetsoyi. Ma' anuli liƚ'ejma' lan xanuc' fariseo. Iƚniya lihuejhuo', ¿te cotetsocopa, aimixnet'ƚyi? ");
INSERT INTO chdNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús italai'e'e'mola', timila': ―Mipa'a ƚamijcano lijuic lipemaná, iƚniya lijoc'impola', ¿te tihuotso'me? Ticuaitsi litine texic'e'entsola' ƚamijcano namaneya, iƚe litine ƚinca tihuotso'me, aimitetsoyacu, tixnet'ƚ'me. ");
INSERT INTO chdNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ja'ni tanajmot'ƚiƚa' anuli lafane quijahua', aimi'iya moxhuicoya al ts'e quijahua'. Lafane quijahua' aimi'ommaiya. Tits'aƚquemma xonca. ");
INSERT INTO chdNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Al ts'ej vino aimoc'ej'miya lafane pontalay quixmi. Ja'ni toƚta'a lof'epa tits'aƚ'mola' lam pontalay quixmi, tic'ejaiquehuo al vino, timinsco'mola' ƚixmi. Al ts'ej vino toc'ej'mi'ma al ts'e ponta quixmi. Toƚta'a aimecaniyacola' al vino ni al ponta quixmi. ");
INSERT INTO chdNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús mipalay toƚta'a icuaitsi anuli cal xans, iƚque nocuxepa lajut'ƚ pe lafoƚyomma lan xanuc'. Exc'onƚingai'ma pe lopa'a Jesús, timi: ―Ƚai'hua caca'no' ji'hua imanapa. Ƚepá. Toxpayaf'ta lomane, timaf'inna. ");
INSERT INTO chdNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús itsahuenni, iyejmale'me cal xans jouc'a ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Miyeyi lane icuaiyunni anuli ƚaca'no' textafque. I'ipa imbama' coque' camats' ti'hua cajuats' licu'u. Iƚoc'huai'ma lixpula' Jesús. Iƚafc'e'e'ma laquiju' lipijahua'. ");
INSERT INTO chdNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ticua: “Ja'ni caƚafc'e'eƚa' Jesús, ma le'a laquiju' lipijahua', aƚsaƚcona'ma”. ");
INSERT INTO chdNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús ipai'e'moxi, ehuelojm'ma ƚaca'no', timi: ―Mai'hua, aimoxhueƚmot'ƚe'ma. Aƚ'huaiyinge, toƚta'a ixaƚconapo'. Maƚe 'hora ƚaca'no' ixaƚconapa. ");
INSERT INTO chdNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús icuaitsi lejut'ƚ ƚincuxepa. Ixim'mola' lo'epa lan xanuc' nomana' jiƚpiya lajut'ƚ. Tunayi, tijolijyi, tixingufcoyi al cueca' quixhuejma', tija'ayi. ");
INSERT INTO chdNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Timila': ―Tolipalunca imanc', ƚahuats' aiquimac'. Ma le'a tixmay. Lan xanuc' ixoco'me. ");
INSERT INTO chdNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús ipa'a'mola' lan xanuc'. Itsufai'ma pe lopa'a ƚahuats'. I'noƚ'e'e'ma limane. Ƚahuats' itsahuenanni, imaf'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ni petsi jiƚpe ƚamats' lan xanuc' icuej'me li'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús jiƚpiya ipayomma, ti'hua lane. Ihuej'me oquexi' lan fohue. Tija'ayi, timiyi: ―Ima', ƚacui'impo' i'Hua David, aƚsintsonga' ninc'icuanuc'la. ");
INSERT INTO chdNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús itsufai'ma lajut'ƚ. Lan fohue ihuej'me, itsuflai'me jouc'a. Jesús icuis'e'mola', timila': ―¿Te imanc' aƚ'huaiyinge? ¿Ja'ni toƚcuayi: “Ƚinca Jesús aƚtoc'i'monga', aƚsaƚ'me'monga' laƚ'u'”? Iƚniya italai'e'e'me, timiyi: ―Maƚpoujna, aƚ'huaiyijnhuo'. Ti'i'ma to'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesús iƚafc'e'e'mola' liƚ'u', timila': ―Imanc' aƚ'huaiyinge. Ma to loƚcuapa toƚta'a ti'itsolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ixaƚ'me'mola' liƚ'u'. Jesús ixc'ai'i'mola' juaiconapa, timila': ―Aimoluyout'ƚe'me iƚe lai'e'epolhuo'. Aimicuej'me lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iƚniya ipalunca, ni petsi jiƚpe ƚamats' tuya'ayi li'e'epola' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mipalumma iƚniya, icuai'entsa pe lopa'a Jesús anuli cal xans ƚitsufaipa anuli ƚiponta'a Satanás. Iƚque cal xans aimi'i mipalay. ");
INSERT INTO chdNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lijoupa lipa'apa Jesús ƚiponta'a Satanás cal xans tipalay. Lan xanuc' etenƚcoco'mola', ticuayi: ―¡Xinƚa'! Acueca' lo'epa Jesús. Fa'a ƚalamats' illanc' ixanuc' Israel, a'i caƚsina' toƚta'a, ni anulemma. ");
INSERT INTO chdNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lan xanuc' fariseo a'i metenƚcocola' lo'epa Jesús, timiyoƚtsi: ―Iƚque Jesús tipa'ala' lontahue. Ma ƚincuxepa contahue lepi'ipa limane ti'eƚa' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ti'huaf'cay jahuay ƚiƚeloƚya' al distrito Galilea, lan tsila' quiƚeloƚya' jouc'a lan tsocay quiƚeloƚya'. Timuc'iyale jiƚpe ƚajut'ƚi pe lafoƚyomma lan xanuc'. Tuya'e' lixpic'epa ȽanDios. Iƚe lataiqui' loya'apa al c'a, tuya'e' te ts'i'ic' micuxe ȽanDios cal Rey. Ixaƚ'me'mola' lan xanuc', jahuay liƚcuana, jahuay liƚpumla. ");
INSERT INTO chdNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ixim'mola' juaiconapa axpela' lan xanuc' ihuej'me. Tixinnila' acuanuc'la. Ixim'mola' tihuotsoyi, titafquemmola'. Ti'onƚcospola' to lam mot'ƚ, iƚne lam mot'ƚ lahue'epola' quiƚpoujna, ailopa'a. Ailopa'a no'eyacola' cuenna. ");
INSERT INTO chdNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Timila' ts'ilihuequi: ―Ƚinca acueca' ƚafoƚya. Tehue'ela' nafot'ƚeyacu. ");
INSERT INTO chdNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Camilhuo': Toƚsa'hueƚe ƚiPoujna caifa. Toƚmiƚe: “Ima' tommetsola' no'eyacu canic' jiƚpe ƚomemats'”. ");
INSERT INTO chdNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús ijoc'i'mola' limbamaj coquexi' ts'ilihuequi ticuaiyunca pe lopa'a. Epi'i'mola' liƚmane tipa'antsola' lontahue, jouc'a tixaƚ'mentsola' lafcualƚay, jahuay liƚcuana, jahuay liƚpumla. ");
INSERT INTO chdNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iƚniya limbamaj coquexi' lecui'impola' lan Apóstole. Jifa'a iniƚiya liƚpuftine: Cal te'a Simón, iƚque ƚecui'impa Pedro, jouc'a Andrés iƚque ipima Simón. Jacobo i'hua Zebedeo, jouc'a Juan, iƚque ipima Jacobo. ");
INSERT INTO chdNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, jouc'a Bartolomé, Tomás, jouc'a Mateo iƚque in'najtsi'iyalepa. Jacobo i'hua Alfeo, jouc'a Tadeo. ");
INSERT INTO chdNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ƚocuena Simón, ai'a tihuej'ma Jesús iƚque anuli liƚpicuejma' lan xanuc' nocuapá: “Lunƚu'e'me ƚalamats'”, jouc'a Judas Iscariote, iƚque nocuya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús umme'mola' iƚniya limbama' coquexi'. U'i'mola' lo'eyacu. Timila': ―Aimonƚe'me petsi aimimetsaicoyi ȽanDios. Aimoƚtsuflai'me ƚiƚpiƚeloƚya' lun Samaria. ");
INSERT INTO chdNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tonƚeƚe pe lomana' lixanuc' Israel, iƚniya laƚpimaye ti'onƚcospola' to lam mot'ƚ lejac'pola'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tulu'itola': “ȽanDios cal Cuecaj Rey Nopa'a lema'a itsiya ti'hua tijoc'ila' lixanuc'. Tolapenufle.” ");
INSERT INTO chdNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Imanc' toƚsaƚ'metola' lafcualƚay, toƚmaf'i'itola' limanapola'. Toƚsaƚ'metola' litejpola' cahui lepra, timanenca limpio. Tolipa'atola' lontahue iƚne litsuflaipá lan xanuc'. Iya' nepi'ipolhuo' loƚmane. A'i cai'najtsi'ilhuo'. Imanc' jouc'a aimoƚ'najtsi'i'mola' lan xanuc', ma le'a toƚsaƚ'metola'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Jiƚpe loƚfi'ejma' loƚxinidoƚ, aimoƚtai'me tomí, ni axpe', ni huata. ");
INSERT INTO chdNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Aimoƚtai'me ponta lane. Aimoƚtai'me oque' loƚtsamalo. Aimoƚtai'me coƚc'eji'. Aimoƚtai'me colummejcofcoyacu. Ticuanni: “No'epa canic' tepi'im'me ƚoteja”. Jouc'a imanc' aimehue'eyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ni petsi quiƚya' loƚtsuflaiyacu, ja'ni al cueca' quiƚya' o ja'ni a'hua quiƚya', tolahueta lejut'ƚ anuli cal c'a xans. Moƚmana' jiƚpe liƚya' ma le'a jiƚpe lajut'ƚ toƚmajnta. ");
INSERT INTO chdNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Moƚtsuflai'me lajut'ƚ toƚnontsola' lan xanuc' nomana' jiƚpiya. Toƚmitsola': “ȽanDios tipaxnetsolhuo'”. ");
INSERT INTO chdNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ja'ni jiƚpe timana' lan c'a xanuc' ȽanDios tipaxne'mola'. Ja'ni a'i, ȽanDios tipaxne'molhuo' ma le'a imanc'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ni petsi liƚya' o ni petsi lajut'ƚ ja'ni aimepenufinnilhuo', aimiquimf'ennilhuo', tolipalunca jiƚpiya. Tolunafle loƚ'mitsi', aimitaƚijm'molhuo' loƚ'mitsi' ni toƚta'a ƚepi camats'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iya' camilhuo' al ƚinca: Ticuaihuo al Cuecaj Quitine titeƚ'mim'mola' lan xanuc' nimajmpá Sodoma y Gomorra, iƚniya lixcay quiƚeloƚya'. Iƚe Litine xonca titeƚ'mim'mola' lan xanuc' nomana' ƚiƚeloƚya' petsi aimepenufinnilhuo' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Imanc' laixanuc' ti'onƚcospolhuo' to lam mot'ƚ, iƚne aimi'iya mipa'neyacoƚtsi. Iya' cummelhuo' tonƚe'me pe lomana' lan xanuc' lo'onƚcospola' to lan lobo, iƚne oyac'la quinneja. Toƚta'a ticuicomma ti'iƚa' acueca' loƚpicuejma' to ƚainofaƚ. Ƚinca aimi'onƚcotolhuo' loƚ'ejma' to lainofat'ƚ liƚ'ejma'. Imanc' xonca ti'onƚcotsolhuo' to lam paloma, iƚniya aimi'eyi quixcay. ");
INSERT INTO chdNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","’Tonƚ'e'etsoƚtsi cuenna. Aimoƚ'huaiyijm'mola' loƚf'as xanuc'. Iƚne ticu'molhuo' ticuaita quiƚmane lan xanuc' noxpijpá lataiqui'. Tileco'molhuo' ƚajut'ƚi petsi lafoƚyomma. Jiƚpe titeƚ'mitolhuo', titajncotolhuo' ixmi. ");
INSERT INTO chdNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Imanc' ts'alihuequi, tileconnolhuo', ticuai'ennolhuo' pe lomana' nocuxepá, jouc'a pe lomana' lan tsila' quincuxepá. Imanc' tolu'itola' naitsi iya'. Toƚta'a tolu'itola' locuenaye xanuc' pe aimimetsaicoyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ja'ni ticutsolhuo' aimoƚsueƚmot'ƚe'me, aimoƚcua'me: “¿Te caƚmiyacola' iƚniya? ¿Te caƚtalai'ecoyacu?” Ticuaitsi al 'hora loƚpalaiyacu, maƚpe 'hora, tolapenuf'me coƚtaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iƚe lataiqui' loƚpalaiyacu a'i coƚtaiqui' imanc', toƚpalai'me lataiqui' lomiyacolhuo' ƚi'Espíritu Santo coƚ'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ƚapima ticu'ma ƚipima tima'anƚe. Cal xans ticu'ma ƚi'hua. Lanaxque' titsolicu ti'e'me laic' quiƚ'ailli' quiƚ'máma', ticu'me, lan xanuc' tima'antsola'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ni petsi loƚmanc'eyacu ti'e'molhuo' laic', imanc' ts'alihuequi. Toƚ'ommoƚaitsa lo'iyacolhuo', ti'hua toƚ'ommoƚaitsa, tijouƚa' tolunƚul'me. ");
INSERT INTO chdNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ja'ni jiƚpe anuli liƚya' tihuetsoquinnilhuo', ti'ennilhuo' lixcay, aimicoƚ'molhuo' tunƚeƚe locuena quiƚya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Camilhuo' al ƚinca: Aimoƚ'ommaiyacu moƚcuaiyacu jahuay ƚipiƚeloƚya' ƚamats' Israel, ma mehue'e cacuaiconanni. ");
INSERT INTO chdNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Cal xans mihuequi ƚipomxi, ja'ni iƚque ƚomxi titeƚcoƚa', cal xans jouc'a titeƚco'ma. Jouc'a ƚapoujna y ƚimozo ma' anuli tuyalaico'me. ");
INSERT INTO chdNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ja'ni tuyaicoƚa' ma to muyaicojma ƚipomxi, tixoj'ma queta iƚque cal xans. Jouc'a cal mozo, tixoj'ma queta ja'ni tuyaicoƚa' ma to muyaicojma ƚipoujna. Ja'ni timinƚe ƚapoujna cajut'ƚ: “Ima' monta'a Beelzebú”, ƚinca xonca lixcay tinesc'e'em'mola' lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Aimoƚsueƚmot'ƚe'me. Aimoƚcua'me: “Lan xanuc', ¿te caƚ'eyaconga'?” Ticuaita litine texiquim'me letamuyiya, tixim'me jahuay lemiya. ");
INSERT INTO chdNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iƚe laifmipolhuo' lipuqui' imanc' toluya'aƚe litine. Iƚe loƚquimf'epa mixolai'innilhuo', imanc' toluya'aƚe ujfxi al toncay ƚajut'ƚi. ");
INSERT INTO chdNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aimoƚsueƚmot'ƚe'me. Aimoƚcua'me: “¿Te caƚ'eyaconga' lan xanuc', ilne noma'ahualepá?” Iƚniya ma le'a tima'ayi al cuerpo. Ƚoƚ'alma aimi'iya mima'ayacu. Toƚspaic'eƚe iƚque ƚacani'eyacola' lan xanuc' jipu'hua ƚunga. Jiƚpe timajnta, liƚcuerpo jouc'a ƚiƚ'alma. ");
INSERT INTO chdNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Oquexi' lan gorrión ticuquinnila' ma le'a to oquej centavo. Tama ahuata liƚpitali iƚne lacaƚ'hui coƚ'Ailli' aimetets'ila'. Ja'ni anuli tecangemma ƚamats' coƚ'Ailli' ixina' iƚe li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xonca ti'nujuaitsilhuo' imanc'. Joupa ixhuej'meya tojua mipa'a ƚajuac quitefque ƚoƚjuac, ixina' ja'ni tecangemma anuli. ");
INSERT INTO chdNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aimoƚsueƚmot'ƚe'me, aimixpailij'molhuo' lo'iyacolhuo'. ȽanDios tixinnilhuo' acueca' loƚpitali. Tama axpela' lacaƚ'hui aimi'iya mulijyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ja'ni anuli cal xans timitsola' lif'as xanuc': “Iya' nimetsaijma Jesús”, iya' ninJesús jouc'a quimetsaico'ma iƚque cal xans. Camita cai'Ailli', iƚque Nopa'a lema'a: “Iƚque lihuequi iya'”. ");
INSERT INTO chdNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ja'ni anuli cal xans timitsola' lif'as xanuc': “Iya' aicainimetsaijma Jesús”, iya' jouc'a aiquimetsaicoya iƚque cal xans. Camita cai'Ailli', iƚque Nopa'a lema'a: “Iƚque aicalihuequi iya'”. ");
INSERT INTO chdNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Aimoƚcua'me: “Iƚque Jesús icuaicoco'ma fa'a li'a ƚamats' ti'e'e'mola' anuli lan xanuc'”. A'i. Aicuaicoco'ma tifuli'i'moƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aicuaicoco'ma tenajtsoƚtsi. Cal xans tixtuc'o'ma qui'ailli'. Ƚahuats' tixtuc'o'ma qui'máma'. Ƚahuahua tixtuc'o'ma ƚihuahua. ");
INSERT INTO chdNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Cal xans, ma lipimaye tixtuc'o'me, ti'e'me laic'. ");
INSERT INTO chdNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Cal xans xonca no'epola' capic'a qui'ailli', qui'máma', iƚque aimi'iya malihuejya. Jouc'a ja'ni xonca no'epola' capic'a ƚi'hua camijcano o ƚi'hua cahuats' aimi'iya malihuejya. ");
INSERT INTO chdNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iya' ƚinca cateƚco'ma. Cal xans noxpic'epa aimiteƚco'ma, iƚque nocuapa: “Aicapenufya lainencruz”, iƚque aimi'iya malihuejya. ");
INSERT INTO chdNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cal xans ts'ipic'a tixinƚa' al c'a capajnya iƚque tejac'ma lipitine. Cal xans ƚalihuequi tama tima'anƚe, iƚque tulij'ma lipitine. ");
INSERT INTO chdNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Cal xans ƚapenufpolhuo' lapenufinga' iya'. Iƚque ƚalapenufpa lapenufinga' iƚque Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Lapi'inyacu anuli cal profeta, ma' anuli tepi'im'me cal xans ƚepenufpa cal profeta, ticua: “Iƚque tuya'e' lonespa ȽanDios”. Lapi'inyacu cal xans naihuejpa lataiqui' locuxepa ȽanDios ma' anuli tepi'im'me iƚque ƚepenufpa. ");
INSERT INTO chdNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cal xans nopalaicopola' iƚna'a lan tsocay, nocuapa: “Iƚna'a ilihuequi Jesús”, tijouƚa' tuhui'i al c'a caja' tixnaƚa' anuli iƚniya, iƚque nocupa caja' ƚinca ti'najtsem'me. Al ƚinca iƚta'a laifmipolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús ixc'ai'i'mola' limbamaj coquexi' ts'ilihuequi ipanni jiƚpiya. Ti'huaf'caita locuenaye quiƚeloƚya' Galilea. Timuc'itola' lan xanuc', tuya'ata te ts'i'ic' lixpic'epa ȽanDios, iƚe lataiqui' ac'a loya'apa. ");
INSERT INTO chdNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iƚne ƚitiné Juan Bautista itats'iya. Icuej'ma lo'epa cal Cristo. Umme'mola' oquexi' ts'ilihuequi, timila': ―Tonƚeƚe. ");
INSERT INTO chdNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tolicuis'etsa Jesús, toƚmitsa: “Itsiya aƚ'huaicoyi ƚocuaiya anuli Ƚommeya ȽanDios. ¿Te ma' ima'? o ¿te ti'hua aƚ'huaico'me ƚocuaiya?” ");
INSERT INTO chdNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Toƚta'a icuis'e'me Jesús. Iƚque italai'e'e'mola', timila': ―Ne'. Tonƚeƚe, toƚcuaitsa pe lopa'a Juan tolu'itsa loƚcuejpa, loƚsimpa. Toƚmitsa: ");
INSERT INTO chdNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tehuetsaleyi lan fohue, tiyenayi lan coxo, tixaƚconnala' ts'ilehui lepra, ti'inala' limpio, ticuejnayi lan taƚpe, timaf'inayi limanapola', lan xanuc' pe aiquiƚ'hueca tu'innila' Lataiqui', iƚe loya'apa al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jouc'a toƚmitsa Juan: “Cal xans natenƚcocopa lai'ejma', iƚque ƚinca ac'a loyaicoya”. ");
INSERT INTO chdNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iyena'me loquexi' ts'ilihuequi Juan. Jesús ipango'ma ipalaico'ma iƚquiya. Timila': ―¿Te coƚtsecohuo'me jipu'hua pe ailopa'a quiƚya'? ¿Te coƚsinhuo'me jiƚpiya? ¿Te oƚnespá oƚsinhuo'me anuli al jaxa tife'ne ƚahua'? ");
INSERT INTO chdNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ja'ni a'i, ¿te coƚtsecohuo'me? ¿Naitsi coƚsinhuo'me jiƚpiya? ¿Te oƚsinhuo'me anuli cal xans nopo'nopa al c'a lipijahua', acueca' lipitali? A'i. Lan xanuc' nopo'nopá liƚpijahua' acueca' al c'a timajnyi ƚilejut'ƚi lan rey. ");
INSERT INTO chdNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","’¿Te coƚtsecohuo'me? ¿Naitsi coƚsinhuo'me? ¿Te oƚsinhuo'me anuli cal profeta? Aƚinca oƚsinhuo'me anuli cal profeta, iƚque Juan. Iƚque tuliquila' lam profeta, xonca acuecaj xans. ");
INSERT INTO chdNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Al Paxi Liniƚingiya joupa ipalaicopa Juan ticuaihuo. Ticua: ¡Aƚquimf'eƚa'! Cumme'ma ƚainepaluc. Iƚque ti'huaj'me'mo', tuya'a'ma ima' tocuaihuo. Tilanc'e'e'mo' lopene, pe lofmuyaicoya. ");
INSERT INTO chdNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Camilhuo' al ƚinca: Iƚque Juan acueca' xans. Ailopa'a caca'no' quipo'nopa ƚi'hua to iƚquiya. Tama aimi'iya mi'onƚyacola' to Juan, ja'ni joupa itsufaipa petsi locuxeyopa ȽanDios Nopa'a lema'a, tama xonca aca'hua xans, iƚque cal xans joupa ulijnapa Juan. ");
INSERT INTO chdNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Lan xanuc' niquimf'epá loya'apa Juan Bautista ehue'me te co'iya mepenufyacola' ȽanDios cal Rey Nopa'a lema'a. Itsiya ma' anuli tehueyi, iƚpic'a tepenuftsola'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Li'huamma Juan enanƚcopa lataiqui' loya'apa lo'iya, iƚe liniƚijmpa Moisés jouc'a liniƚijmpa lam profeta. ");
INSERT INTO chdNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iniƚijmpá: “Ticuaicohuo cal profeta Elías”. Joupa enanƚpa iƚe lataiqui'. Juan Bautista ma' iƚque Elías. Ja'ni tolapenuf'me laifmipolhuo' toƚsim'me toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Naitsi nocuejpa aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Te caif'onƚicoyacolhuo' imanc' moƚmana' itsiya'? ¿Te ts'i'ic' loƚ'ejma'? Ca'onƚico'molhuo' to jipu'hua laica'uhuay nocutshuoƚanna pe locucaleyompa. Tijoc'iyi, timinnila' liƚf'as ca'uhuay: ");
INSERT INTO chdNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Illanc' aƚfus'mipá laƚjaxa, aƚpic'a toƚsouƚe. Aicoƚsahua'. Lunac'lipá ihuotsoqueya, aicoƚjoliqui'.” ");
INSERT INTO chdNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","’Ma toƚta'a imanc' loƚ'ejma'. Ailopa'a catenƚcocoyacolhuo'. Juan Bautista aimitesma to moƚtetsoyi, aimixnay vino. Toƚcuayi: “Iƚque itsufaipa ƚiponta'a Satanás”. ");
INSERT INTO chdNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iya' aicuai'ma fa'a li'a ƚamats' catesma to moƚtetsoyi imanc', caxnay al vino. Imanc' aƚnesc'e'e, toƚcuayi: “¡Toƚsinƚe! Iƚca'a cal xans intetsopa, in‑xnatsaipa. Liƚejmale in'najtsi'iyale jouc'a locuenaye lan xanuc' pe aimihuejcoyi locuxepa ȽanDios.” ’Ƚinca ȽanDios acueca' ac'a lipicuejma', toƚta'a timujyi iƚne pe naihuejcopá, jouc'a acueca' ac'a liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús ipango'ma inesco'mola' iƚne ƚiƚeloƚya' petsi li'ehuo'ma axpe' acueca'. Ipalaico'mola' iƚne lan xanuc' pe aiquiƚsuej'meya. Ines'ma te ts'i'ic' loyalaicoyacu. Ticua: ");
INSERT INTO chdNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Ima' miƚya' Corazín, ¡acueca' lofteƚcoya! Jouc'a ima' miƚya' Betsaida, ¡acueca lofteƚcoya! Jiƚpiya loƚxanuc' ixim'me al cueca' lo'epa ȽanDios, aiquiƚsuej'meya. Luyaipa quitine lan xanuc' nomana' ƚiƚeloƚya' Tiro y Sidón ja'ni coƚa' ixim'me toƚta'a iƚniya coƚa' tixhuej'menacu, tipo'no'me liƚpijahua' ayolca, timet'ƚi'me capi' liƚ'a, timujco'moƚtsi ixhuej'menamma liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Al Cuecaj Quitine Locuaicoya ȽanDios titeƚ'mi'mola' iƚne ƚiƚeloƚya' Tiro y Sidón jouc'a liƚxanuc', xonca titeƚ'mi'molhuo' imanc' miƚeloƚya' Corazín y Betsaida. ");
INSERT INTO chdNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","’Ima' miƚya' Capernaum, ¿te to'nof'e'moxi xonca al toncay? ¿Te ti'onƚcoto' to ȽanDios? A'i. Ti'oc'em'mo'. Toxinnoxi jiƚpe al muf. Jiƚpe liƚya' loƚxanuc' ixim'me al cueca' lo'epa ȽanDios, aiquiƚsuej'meya. Luyaipa quitine lan xanuc' nimajm'me liƚya' Sodoma, ja'ni coƚa' ixim'me toƚta'a iƚniya tixhuej'menacu, coƚa' a'i mecaniya liƚpiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iya' camilhuo': Al Cuecaj Quitine Locuaicoya, ȽanDios titeƚ'mi'mola' liƚya' Sodoma jouc'a lixanuc', jouc'a titeƚ'mi'molhuo' ima' miƚya' Capernaum jouc'a loxanuc', xonca titeƚ'mi'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iƚniya ƚitiné Jesús ipalaic'opa qui'Ailli', timi: ―Mai'Ailli', ima' iƚPoujna lema'a y li'a ƚamats'. Cax'najtsi'ihuo' lof'epa. Tomuc'ila' laixanuc', iƚne lo'onƚcospola' to la'uhuay. Mepi'ipola' liƚpicuejma', ticuec'eƚe laitaiqui'. Lan xanuc' ts'iƚsina', xonca nixhuepá, aicomepi'ila' toƚta'a liƚpicuejma'. Iƚniya iximpá ipime laitaiqui', to emiya. Aimi'i muhuaƚcufyi. ");
INSERT INTO chdNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aƚinca mai'Ailli', toƚta'a loxpic'epa, toƚiya latenƚcocopo'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Cai'Ailli' jahuay lapi'ipa cacuxe'etsola'. Iya' i'Hua ȽanDios lan xanuc' aimi'iya maƚsingufya iya' laipicuejma'. Ma le'a cai'Ailli' aƚsingufi. Lan xanuc' jouc'a aimi'iya mixingufyacu cai'Ailli' te ts'i'ic' lipicuejma'. Ma le'a iya' ƚi'Hua aixingufi. Iya' caxpic'e naiƚne laifmuc'iyacola', iƚne camuc'ila' te ts'i'ic' lipicuejma' cai'Ailli'. Iƚne ƚinca timetsaicoyi cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Imanc', ja'ni joupa ixojtolhuo', ja'ni toƚsinyi ipime lapajnya, tonƚouyunca, capenuf'molhuo'. Iya' cunxac'i'molhuo'. Tuyai'ma ƚoƚpixoqui. Cunxoc'i'molhuo' cunlata. ");
INSERT INTO chdNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lihuejcoƚa', iya' camuc'i'molhuo'. Iya' a'i noyac'. Iya' nin manxu. Catinu'ena'molhuo' ƚolunxajma'. Aimoƚsinconayacu ipime ni acumta lapajnya. ");
INSERT INTO chdNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iƚe laitaiqui' laifcuxe'eyacolhuo' a'ij cumta, jouc'a laifmuc'iyacolhuo' a'i quipime lananƚcoya. ");
INSERT INTO chdNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iƚniya ƚitiné, anuli litine conxajya, Jesús jouc'a ts'ilihuequi tuyalaicoyi jiƚpe lifayiya cal trigo. Ts'ilihuequi tunle'eyi. Ipango'me ipa'a'me ƚixpaj trigo, titeji. ");
INSERT INTO chdNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lan xanuc' fariseo ixim'me, timiyi Jesús: ―¡Toxinƚa' lo'epa ts'ihuejhuo'! ¿Nai lepi'ipola' lane ti'e'me toƚta'a? Itsiya litine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús timila': ―Imanc', ¿te a'i coƚsuec' li'epa cal rey David, munle'eyi juaiconapa iƚque jouc'a liyejmalepá? ");
INSERT INTO chdNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David itsufai'ma lejut'ƚ ȽanDios, itepa lam paxi ca'í ƚopa'a jiƚpe, epi'i'mola' ƚa'i liƚejmale, itepá jouc'a. Iƚque ƚa'i ma' i'huexi ȽanDios. Aimi'iya mitejnyacu. Ma le'a la'aillí notepá. ");
INSERT INTO chdNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","’Al Paxi Ƚiniƚingiya tuya'e' lo'eyacu la'aillí litine conxajya. Imanc', ¿te aicoƚsuec' iƚe lataiqui'? Itine conxajya iƚniya ti'eyi canic'. Tama itine conxajya ailopa'a quiƚjunac', maƚpe al cuecaj xoute' ti'eyi canic'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iya' camilhuo': Fa'a tipa'a anuli xonca acueca'. Iƚque tuliqui al cuecaj xoute'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","’Imanc' aicoƚcueca litaiqui' ȽanDios lonespa: Imanc' tama toƚma'ala' linneja, aƚsufco'ma, aimalatenƚcocojma iƚe lonƚ'epa. Xonca aipic'a toƚsintsola' cuanuc'la loƚf'as xanuc'. Coƚa' oƚcuej'me jiƚiya lataiqui' aimoƚcufyacola' lalihuequi, iƚniya ailopa'a toƚta'a quiƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ma iya' cacuxe litine conxajya. Ti'hua laimane cu'itsola' laixanuc' lo'eyacu iƚe litine. ");
INSERT INTO chdNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús uyaico'ma jiƚpiya. Icuaitsi lajut'ƚ pe lafoƚyomma lan xanuc', itsufai'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jiƚpe tipa'a anuli cal xans ijuƚpa limane. Jouc'a timana' lan xanuc' tehueyi te co'iya micufyacu Jesús. Iƚne icuis'e'me, timiyi: ―Litine conxajya, ¿te ȽanDios ticu lane tixaƚ'mentsola' lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús timila': ―Anuli imanc', ja'ni ƚimoƚ timefmaitsi al pu'hua litine conxajya, ¿te a'i mipa'aya? Ƚinca tipa'a'ma. Tama itine conxajya ailopa'a nonesya, aimiminyacu: “Aimi'iya”. ");
INSERT INTO chdNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Cal xans aimi'onƚspa to cal moƚ, xonca ipitali iƚque. Litine conxajya ƚinca tipa'a lane aƚ'eƚe al c'a. ");
INSERT INTO chdNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lijoupa linespa toƚta'a, timi cal xans: ―To'nijla' lomane. Cal xans i'nij'ma limane. Ixaƚcona'ma. Ilajn‑na'ma limane, ma to locuena limane. ");
INSERT INTO chdNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lan xanuc' fariseo ipalunca jiƚpe lajut'ƚ. Efot'ƚe'moƚtsi, tixpic'eyi lo'eyacu tima'anƚe Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús ixina' lonespa iƚne lam fariseo, i'huana'ma. Axpela' lan xanuc' ihuej'me. Ixaƚ'mena'mola' jahuay lafcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ixc'ai'i'mola', timila': ―Aimoluyout'ƚe'me lai'e'epolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iƚe li'ejma' Jesús tenanƚi lataiqui' loya'apa cal profeta Isaías, iƚe lataiqui' tuya'e' lonespa ȽanDios, ticua: ");
INSERT INTO chdNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jifa'a ƚai'huijf'epa, iƚca'a ƚo'epa laipenic'. Ma iƚca'a ca'ay capic'a, latenƚcocojma lipicuejma'. Capi'i'ma ƚai'Espíritu Santo. Tuya'a'ma pe lomana' locuenaye lan xanuc', iƚne aicalimetsaijma, tu'i'mola' pe lopa'a al ƚijca cane. ");
INSERT INTO chdNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aimifulecoya cataiqui' ni aimipalaiya ujfxi. Aimicaxhuaiya lane mija'aya ujfxi. ");
INSERT INTO chdNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iƚque juaiconapa amanxu, aimunƚajyacola' nulemma iƚniya lo'onƚcospola' to lix'meya jaxa. Jouc'a aimipic'eyacola' liƚpepalc'o' tama timufqui. Ma muliquila' no'epá laic', timuj'ma nulemma te ts'i'ic' al c'a cane. ");
INSERT INTO chdNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Itsiya timana' lan xanuc' a'i calimetsaijma, iƚniya ti'huaiyijm'me iƚca'a ƚai'huijf'epa, tines'me: “Iƚca'a ƚinca lunƚu'e'monga'”. Toƚta'a luya'apa cal profeta Isaías. ");
INSERT INTO chdNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ilec'mentsa Jesús anuli cal xans ƚitsufaipa anuli ƚiponta'a Satanás. Ƚonta'a i'e'epa cal xans afo', jouc'a aimipalay. Jesús ixaƚ'mena'ma cal xans. Ipalaina'ma, ehuetsalena'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lan xanuc' ixoconni quileta. Ticuayi: ―¡Xinƚa'! Iƚque Jesús ti'ay al cueca'. ¿Te aga iƚque ƚacui'impa ƚi'Hua David? ");
INSERT INTO chdNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lan fariseo icuej'me iƚe lonespa lan xanuc', ticuayi: ―Iƚque cal xans, epi'ipa limane nocuxepola' lontahue cuftine Beelzebú, toƚta'a tipa'ala' lontahue. ");
INSERT INTO chdNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús ixina' locuapa liƚpicuejma', timila': ―Anuli al cuecaj nación, ja'ni tenajtsoƚtsi lixanuc', iƚiya al nación tejac'ma. Jouc'a anuli liƚya', o anuli lajut'ƚ, ja'ni tenajtsoƚtsi liƚsanuc', iƚiya liƚya' o jiƚniya lan xanuc' aimipajnya quiƚpujfxi, tijou'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","’Ma' anuli Satanás ja'ni iƚque tipa'ala' lipontahue joupa enajpoƚtsi iƚniya. Coƚa' aimipajnya quipujfxi. Ja'ni toƚta'a li'ipa, ¿tej co'huacopa limane itsiya? ");
INSERT INTO chdNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","’Iya' ja'ni iƚque Beelzebú nalapi'ipa laimane, ja'ni toƚta'a quipa'ala' lontahue, ¿naitsi nepi'ipola' liƚmane iƚne loƚxanuc' naipa'apá lontahue? Ma iƚniya loƚxanuc' timuc'i'molhuo' imanc' imenajpolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","O ¿te ja'ni ȽanDios nalapi'ipa ƚi'Espíritu quipa'atsola' lontahue? Ja'ni toƚta'a laimane, ti'iƚa' coƚsina' jifa'a tipa'a ȽanDios cal Cuecaj Rey. Iƚque ticuxe. ");
INSERT INTO chdNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Nij naitsi mi'iya mitsufaiya lejut'ƚ cal xans ts'ipujfxi, miƚonc'e'eya ƚi'hueca. Ate'a tifi'e'mola' limane', li'mitsi' iƚque cal xans ts'ipujfxi. Tijouƚa', ƚinca nipajnya titsufai'ma lejut'ƚ, tiƚonc'e'e'ma ƚi'hueca. ");
INSERT INTO chdNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Naitsi aicalihuequi, iƚque aƚ'ay laic'. Naitsi aimefot'ƚela' lan xanuc' to laif'epa, iƚque tica'nennala'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Iya' camilhuo': Jahuay lixcay li'epa, jahuay linesc'epoƚtsi lan xanuc', ti'i'ma timenc'e'ecom'mola'. Le'a nonesc'epá cataiqui' cal Espíritu Santo aimi'iya mimenc'e'econyacola'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cal xans naƚnesc'e'epa cataiqui', ti'i'ma timenc'e'ecom'me. Cal xans nonesc'epa cataiqui' cal Espíritu Santo, iƚque aimimenc'e'econyacu. Mipa'a fa'a li'a ƚamats' o jipu'hua locuenaj quitine, iƚquiya titai'ma lijunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ja'ni tolimetsaicoyi ac'a ƚi'as, jouc'a tolimetsaicoƚe ac'a al 'ec. O ja'ni tolimetsaicoyi a'ijc'a ƚi'as, jouc'a tolimetsaicoƚe a'ijc'a al 'ec. Al 'ec ƚi'as timuj'ma te ts'i'ic' iƚe al 'ec, ja'ni ac'a c'ec o a'ijc'a. ");
INSERT INTO chdNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Imanc' loƚpicuejma' ti'onƚcospa to lipicuejma' ƚacaƚpo'. Imanc' unc'ixcay xanuc'. ¿Te co'iya moƚpalaiyacu al c'a cataiqui'? Ma to lipicuejma' cal xans, ja'ni al c'a o ixcay, ma toƚta'a lopalaicoya. ");
INSERT INTO chdNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Cal c'a xans tipalaijma al c'a litaiqui', ma to mipa'a lipicuejma'. Cal xans ts'ixcay quipicuejma' tipalaijma ixcay litaiqui' ma to mipa'a lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","’Iya' camilhuo': ¡Toƚpo'noƚe cuenna te ts'i'ic' loƚnesyacu! Ticuaitsi al Cuecaj Quitine ȽanDios cal Juez ticuis'etolhuo' anuli anuli, timitolhuo': “¿Te coƚnescopa toƚta'a?” ");
INSERT INTO chdNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ja'ni oƚnes'me al c'a, ȽanDios tepenuftolhuo', tixinnolhuo' unc'ic'a xanuc'. Ja'ni oƚnes'me lixcay, ȽanDios aimepenufyacolhuo', tixinnolhuo' a'ijc'a. ");
INSERT INTO chdNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oquexi' afantsi lan xanuc' fariseo, oquexi' afantsi lomxiye nomuc'iyalepá locuxepa ȽanDios, italai'e'e'me Jesús, timiyi: ―Momxi, aƚpic'a aƚsinƚe ja'ni aƚinca lepi'ipo' lomane ȽanDios. Aƚmihuo': To'eƚa' al cueca'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús italai'e'e'mola', timila': ―Lixcay xanuc' pe necanujpá ȽanDios, pe aimihuejyi, ma le'a iƚpic'a aƚsinƚa' ca'eƚa' al cueca'. Ma toƚta'a imanc' loƚ'ejma'. Ailopa'a caifmuc'iyacolhuo'. To li'ipa cal profeta Jonás luyaipa quitine, ma toƚta'a aƚ'i'ma iya'. Iƚe ƚinca toƚsim'me. ");
INSERT INTO chdNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás icoƚ'ma afane quitine afane quipuqui' jiƚpe licu'u cal cueca' catu ƚinuc'ma. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aƚcoƚta afane quitine afane quipuqui' licu'u ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","’Ticuaitsi al Cuecaj Quitine imanc' tolacaxingoƚaita ȽanDios cal Cuecaj Juez. Jouc'a tecaxingoƚaita lan xanuc' nimajmpá liƚya' Níneve, jiƚpiya Jonás luya'ahuo'ma litaiqui' ȽanDios. Iƚniya lun Níneve ticuftolhuo'. Iƚne iquimf'e'me lu'i'mola' Jonás, ixhuej'menanca. Itsiya imanc' toƚquimf'eyi anuli xonca cal cueca', aimoƚsuej'memma. ");
INSERT INTO chdNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","’Jiƚpe al Cuecaj Quitine lan xanuc' tecaxingoƚaita ȽanDios cal Cuecaj Juez. Imanc' tolacaxingoƚaita. Jouc'a tecaxhuaita ƚaca'no' nicuxepa anuli ƚamats' juaiconapa aculi' al 'ocay. Iƚque ƚaca'no' ticuftolhuo'. Xonca al c'a li'ejma' iƚque. I'hua'ma juaiconapa itoqui lane. Icuaitsi icuej'ma locuapa cal rey Salomón. Iƚque acueca' lipicuejma'. Itsiya, imanc' tama toƚquimf'eyi anuli cal cueca' xonca, tolatets'iyi. ");
INSERT INTO chdNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Anuli ƚixcay conta'a, lipanni licuerpo cal xans, ti'hualeco'ma pe ailopa'a caja'. Tehue petsi conxac'eya, aimixina. ");
INSERT INTO chdNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ticua: “Aipainamma. Ai'huanapa lainejut'ƚ pe lainipayomma.” Licuaitsi jiƚpiya tixim'ma ixcuajma', itaf'uyiya, i'huáqui al c'a. ");
INSERT INTO chdNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tixinƚa' toƚta'a ti'hua'ma, tilecotola' ocuenaye acaitsi lontahue xonca ixcay. Titsuflai'me jiƚpiya licuerpo cal xans, timajm'me. Toƚta'a xonca acueca' loyaicoya iƚque cal xans. Al te'a le'a anuli ƚonta'a i'hueca, tijouƚa' ti'i'mola' apaico lontahue. Toƚta'a loluyalaicoyacu imanc' moƚmana' itsiya. A'ij ƚijca loƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús mipalaic'ola' lan xanuc', icuaiyunca qui'máma' jouc'a lipimaye. Ecaxoƚ'me ƚuna. Iƚpic'a tipalaic'oƚe. ");
INSERT INTO chdNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","U'im'me Jesús, imim'me: ―Icuai'me co'máma' jouc'a lopimaye. Tecaxoƚanna ƚuna. Iƚpic'a tipalaic'otso'. ");
INSERT INTO chdNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús italai'e'e'ma, timi: ―Fa'a, ¿ja'ni ailopa'a cai'máma', ailomana' laipimaye? ");
INSERT INTO chdNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tenats'ila' ts'ilihuequi, ticua: ―Jifa'a comana' cai'máma' jouc'a laipimaye. ");
INSERT INTO chdNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iƚque naihuejcopa Cai'Ailli' Nopa'a lema'a, ma jiƚque aipima o ai'máma'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Maƚpiya litine Jesús ipanni jiƚpe lajut'ƚ, icutshuai'ma ƚema al cueca' quin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Axpela' lan xanuc' icuaitsa pe lopa'a Jesús. Iƚque if'aj'ma anuli al barco, icutsmai'ma jiƚpiya. Iƚe al barco tecaxc'o jiƚpe laja', jahuay lan xanuc' tecaxoƚanna ƚema al cueca' quin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús axpe' i'onƚico'ma lo'epa ȽanDios fa'a li'a ƚamats'. Timila': ―Cal xans ipanni ica'nehuo'ma lam fanuj trigo. ");
INSERT INTO chdNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mica'ne lam fanu' hualca ecangoƚaitsa lane. Lacaƚ'hui naiyulpá lema'a icuaitsa, itejn‑na'me. ");
INSERT INTO chdNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","’Hualca lam fanu' i'nif'coƚaitsa jiƚpiya ƚixmi capic, tejuaf'ya huata ƚacamats'. Ma axolof ƚacamats' aiquicoƚ'ma, lam fanu' ila'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lif'aj'ma cal 'ora, epatsi ƚinu', lam fanu' lilapa ipi'e'mola'. Huata ilanc'epoxi ƚaiquime, ijuƚna'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","’Hualca lam fanu' itsuc'huaita pe lopa'a ƚitac'. Iƚque ƚitac' itoj'ma, ejec'ona'ma ƚilapa cal trigo. ");
INSERT INTO chdNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","’Hualca lam fanu' etojmoƚaitsa cal c'a camats'. Iƚne ƚinca ila'ma, itoj'mola', ipanni ƚixpa. Anuli ipammaitsi amaxnu, ocuena ipammaitsi afanej nuxans, ƚocuena ipammaitsi anuxans quimbama'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","’Naitsi nocuejpa, aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ts'ilihuequi Jesús iƚoc'oƚai'me. Icuis'e'me, timiyi: ―Ima', ¿te cofmuc'icopola' toƚiya? Aimo'ila' acuajmaica cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús italai'e'e'mola', timila': ―Imanc' ȽanDios epalc'o'ipolhuo' loƚpicuejma'. Oƚcueca lipime cataiqui'. Oƚcueca lo'iya jiƚpiya petsi lan xanuc' tihuejcoyi ȽanDios, iƚque cal Cuecaj Rey Nopa'a lema'a. Locuenaye lan xanuc' aiquiƚcueca. ");
INSERT INTO chdNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Cal xans ja'ni ticueca, xonca ticuej'ma, tuyaf'ma lipicuejma'. Cal xans ja'ni aiquicueca, tejac'e'ma iƚe lixina'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iƚne: “Tama tehuelojnyi, aimixinyi; tama tiquimf'eyi, aimicuejyi.” Toƚiya laifpalaic'opola' iƚniya a'ij cuajmaica cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jiƚne lo'ipola' enanƚcopa luya'apa cal profeta Isaías, ticua: Toƚquimf'e'me, ti'hua toƚquimf'eyi, aimoƚcuec'eyacu. Tolahuelojm'me, ti'hua tolahuelojnyi, aimoƚsinyacu. ");
INSERT INTO chdNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Al ƚinca liƚpicuejma' iƚne lan xanuc' i'ipa ta. Tama tipa'a liƚs'mats'i', afule micuec'eyi. Ixpoƚ'mipá liƚ'u'. Ja'ni coƚa' aimi'e'me toƚta'a tixingo'me liƚ'u', tiquimf'eco'me liƚs'mats'i', laitaiqui' titsufai'ma liƚpicuejma', aƚcuec'e'ma, tipailinacu, titsuflaina'me al c'a cane, toƚta'a caxaƚ'mena'mola', quiƚonc'e'ena'mola' liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Imanc' ƚinca tuluyalaicoyi al c'a. Toƚsinyi, toƚquimf'eyi. ");
INSERT INTO chdNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iya' camilhuo' al ƚinca: Luyaipa quitine axpela' lan xanuc' tijanajyi coƚa' tixinƚe iƚe loƚsimpa itsiya imanc'. Iƚniya lam profeta jouc'a locuenaye lan xanuc' naihuejpá locuxepa ȽanDios, aiquixim'me. Tijanajyi coƚa' tiquimf'eƚe iƚe loƚquimf'epa itsiya imanc'. Aicu'innila' iƚiya lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Aƚquimf'eƚa'. Cuhuaƚc'e'e'molhuo' lataiqui' loya'apa te ts'i'ic' li'ipa jiƚpiya leca'nimpa cal trigo. ");
INSERT INTO chdNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Itsiya ȽanDios cal Rey Nopa'a lema'a tijoc'ila' lan xanuc' tihuejcoƚe. Cal xans noquimf'epa iƚe lataiqui' ja'ni aimicueca ti'i'ma to li'ipa jiƚpiya ƚecangemma lane lam fanu'. Ticuaihuo ƚonta'a, tipa'ena'ma lataiqui', iƚiya lifapa lipicuejma' cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","’Iƚe huata ƚacamats' lifaf'impa jiƚpe ƚixmi capic ti'onƚcospa to cal xans micuej'ma lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios, tepenuf'ma, tixojco'ma queta. ");
INSERT INTO chdNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iƚque tihuequi le'a oque' fane' quitine, lataiqui' aimif'acay ƚime jiƚpe lipicuejma'. Ticuaitsi lixhuejma', o lan xanuc' tixtuc'oyi mihuequi iƚe lataiqui', iƚque aimihuejcoya, tenaj'moxi. ");
INSERT INTO chdNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","’Ƚamats' lifampa jiƚpiya litojpa ƚitac' ti'onƚcospa to ƚocuena cal xans. Iƚque tiquimf'e lataiqui' loya'apa al c'a lixpic'epa ȽanDios. Tijouƚa' tixhueƚma juaiconapa, ticua: “¿Te caifnuyaicoya laipitine?” O tifel'mi'moxi quituca', tijanaca tulijla' axpe' qui'huexi. Iƚe lataiqui' lopa'a lipicuejma' ejec'opa, aiquipammaic'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","’Cal c'a camats' lifampa ti'onƚcospa to ƚocuena cal xans, iƚque tiquimf'e lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios, ticueca. Iƚe lataiqui' ipammaita. Iƚque cal xans lo'iya ti'onƚcospa to li'ipa cal fanuj trigo ƚipammaita amaxnu, o ƚipammaita afanej nuxans, o ƚipammaita anuxans quimbama'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús i'onƚiconapa lo'epa ȽanDios fa'a li'a ƚamats', timila': ―Anuli cal xans eca'ni'ma lan c'a fanuj trigo ƚemats', li'ipa jiƚpe ti'onƚcospa to lo'iya petsi ȽanDios tijoc'ila' lan xanuc' tihuejcoƚe. Iƚque cal Cuecaj Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Joupa eca'nipa lan c'a fanuj trigo, mixmaiyi lan xanuc', icuaitsi no'epa laic' iƚque cal xans, eca'ni'ma ocuenaj fanu'. Iƚque ƚixcay fanu' eca'ni'ma maƚpe pe leca'nimpa lan c'a fanuj trigo. I'huana'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","’Itoj'mola' cal trigo jouc'a ƚixcay quitamqui. Lipanni ƚixpa imetsaicom'me uhuantsi ƚixcay quitamqui. ");
INSERT INTO chdNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Icuaitsa limozó ƚipoujna camats'. Icuis'e'me ƚiƚpoujna, timiyi: “Maƚpoujna, ¿te aicomeca'ni cal c'a fanuj trigo ƚomemats'? ¿Pe qui'huayomma iƚquiya ƚixcay quitamqui?” ");
INSERT INTO chdNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ƚapoujna italai'enni, timila': “Toƚta'a li'epa naƚ'epa laic'”. Limozó icuis'e'me, timiyi: “¿Te caƚ'eyacu? ¿Te aƚyaxta iƚque ƚixcay quitamqui?” ");
INSERT INTO chdNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ƚiƚpoujna timila': “A'i, aimi'iya. Ja'ni toƚyaxtsa, jouc'a tiyaxc'ehuo cal trigo. ");
INSERT INTO chdNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ma toƚe tipanenni. Titojtsola' ma' anuli cal trigo jouc'a ƚixcay quitamqui. Ticuaitsi litine tefot'ƚenƚe, iya' cami'mola' no'eyacu canic': Tonƚeƚe, ate'a toƚyaxtsa jiƚe ƚixcay quitamqui, toƚfi'ot'ƚetsa atotsa atotsa tipi'em'me. Tijouƚa', tolafot'ƚetsa cal trigo, toƚ'hua'anca fa'a lainejut'ƚ.” ");
INSERT INTO chdNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús ti'hua ti'onƚiconghua lo'epa ȽanDios fa'a li'a ƚamats'. Timila': ―Anuli cal xans itai'ma anuli ƚajfanu' juaiconapa aca'hua cuftine sinapí, ifatsi ƚemats'. Li'i'ma iƚque cal fanu' ti'onƚcospa to lo'iya petsi ȽanDios cal Cuecaj Rey tijoc'ila' lan xanuc' tihuejcoƚe. ");
INSERT INTO chdNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iƚque cal fanu' xonca aca'hua, titoj'ma tulij'ma jahuay lofampa jiƚpe ƚaqueya. Iƚque xonca titoqui. Ti'i'ma to al 'ec. Lacaƚ'hui naiyulpá lema'a jiƚpe al 'ec tilanc'e'me liƚpuxi'na, timajm'me. ");
INSERT INTO chdNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús ti'hua ti'onƚiconghua lo'epa ȽanDios fa'a li'a ƚamats'. Timila': ―Anuli ƚaca'no' ilai'i'ma ƚilevadura axpe' ƚi'harina. Li'i'ma cal harina ƚilai'ipa cal levadura ti'onƚcospa to lo'iya petsi ȽanDios cal Cuecaj Rey Nopa'a lema'a tijoc'ila' lan xanuc' tihuejcoƚe. Iƚe cal levadura ti'hua tilai'i cal harina. Lijou'ma umfunni jahuay ƚax'e. ");
INSERT INTO chdNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Toƚta'a limuc'iyalepa Jesús. Ma le'a i'onƚicopa lo'epa ȽanDios. Aimimuc'ila' acuajmaica cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Toƚta'a enanƚcopa linespa cal profeta. Iƚque uya'a'ma linespa caƚ'Ailli', ticua: Capalaic'o'mola' lan xanuc', ca'onƚico'ma lo'epa ȽanDios. Lilajnyopa li'a ƚamats', emiya iƚiya lataiqui'. Itsiya cu'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús ipo'no'mola' lan xanuc' nomana' jiƚpiya. Ts'ilihuequi iƚoc'oƚai'me, timiyi: ―Lu'itsonga', luhuaƚc'etsonga' lataiqui', iƚe loya'apa te ts'i'ic' li'ipa jiƚpe ƚemats' cal xans pe litojyopa ƚixcay quitamqui. ");
INSERT INTO chdNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iya' aƚ'onƚcospa to iƚque cal xans neca'nipa lan c'a fanu'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","To ƚemats' lifapa cal xans toƚe ti'onƚcospa iƚca'a li'a ƚamats'. Naihuejcopá ȽanDios, iƚque cal Cuecaj Rey, iƚne ti'onƚcospola' to lan c'a fanu'. Naihuejcopá ƚonta'a, iƚne ti'onƚcospola' to ƚixcay quitamqui, iƚe ƚitamqui lifapa iƚque ƚin'ehuale laic' cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ƚonta'a Satanás, iƚque ƚin'ehuale laic'. Li'i'ma litine lafot'ƚeya ti'onƚcospa to lo'iya Lijoujma Quitine. Nefot'ƚepá trigo, iƚne ti'onƚcospola' to lapaluc' quema'a, maƚniya tefot'ƚem'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","’Ma to miyaxquim'me ƚixcay quitamqui, tipi'em'me, ma toƚta'a lo'iya Lijoujma Quitine. ");
INSERT INTO chdNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iya' cumme'mola' lainepaluc' quema'a. Ma to miyaxquim'me ƚixcay quitamqui, toƚta'a tepa'am'mola' lomints'eyalepá liƚpicuejma' lan xanuc'. Jouc'a tipa'am'mola' pe aimihuejcoyi locuxepa ȽanDios. Iƚniya aimimajnyacu anuli naihuejcopá ȽanDios, iƚque cal Cuecaj Rey. ");
INSERT INTO chdNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iƚne lixcay xanuc' ti'nij'mim'mola' al cuecaj capa lonajpa ƚunga. Jiƚpiya lan xanuc' tijolijta, ti'ilc'ta liƚ'ay, tixinna acuecaj cumla. ");
INSERT INTO chdNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Lan xanuc' naihuejcopá locuxepa ȽanDios, ma iƚniya timanecu pe locuxeyopa ȽanDios iƚque quiƚ'Ailli'. Jiƚpiya ti'huájtola' to mi'huájta cal 'ora tuyaiƚa' ƚummahuay. ’Naitsi nocuejpa, aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’To li'epa anuli cal xans liximpa axpe' al tomí lemuyiya ƚamats', toƚta'a ti'onƚcospa to lo'eyacu lan xanuc' noquimf'epá, naihuejcopá ȽanDios lojoc'ipola', iƚque cal Cuecaj Rey. Cal xans liximpa iƚe al tomí emucona'ma. Tixoqui queta i'hua'ma icujtsi jahuay ƚi'huexi. Iƚe lulij'ma i'naco'ma ƚamats' jiƚpe lamuya al tomí. ");
INSERT INTO chdNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’To li'epa anuli cal xans ƚincucale mehuay lam perla, iƚniya acueca' liƚpitali, toƚta'a ti'onƚcospa to lo'eyacu lan xanuc' noquimf'epá, naihuejcopá ȽanDios lojoc'ipola', iƚque cal Cuecaj Rey. ");
INSERT INTO chdNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cal xans iximpa anuli cal perla acueca' lipitali, i'hua'ma icujtsi jahuay ƚi'huexi. Iƚe lulij'ma i'naco'ma iƚque cal perla. ");
INSERT INTO chdNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’To li'ipa petsi lin'noƚpá catuye lecajm'mi'me ƚiƚxami al cuecaj quin'nuhua', toƚta'a ti'onƚcospa to lo'iyacola' lan xanuc' noquimf'epá, naihuejcopá ȽanDios lojoc'ipola', iƚque cal Cuecaj Rey. Iƚque cal xami i'noƚpola' jahuay latuye, iƚne lotempola' jouc'a pe aimitejn‑nila'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Namma i'i'ma cal xami, lin'noƚpá catuye ipa'a'me laja'. Icuscoƚenca, i'huijf'e'me lan c'a catuye, ti'nij'miyi liƚtsiquihuit'ƚ. Locuenaye latuye, iƚne pe aimitejn‑nila', eca'ni'me. ");
INSERT INTO chdNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Toƚta'a ti'i'ma Lijoujma Quitine. Ticuaicu lapaluc' quema'a, tenaj'mola' lan xanuc'. Ti'huijf'e'mola' lan xanuc' naihuejcopá locuxepa ȽanDios. Lixcay xanuc' tipa'am'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tecajm‑mim'mola' lapa petsi lonajpa ƚunga. Jiƚpe lan xanuc' tijolijta, ti'ilc'ta liƚ'ay. ");
INSERT INTO chdNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús icuis'e'mola', timila': ―¿Te oluhuaƚpá lainu'ipolhuo'? Iƚne italai'e'e'me, timiyi: ―Ma luhuaƚpá. ");
INSERT INTO chdNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Timila': ―Imanc' unc'omxiye, joupa olihuic'ipá te ts'i'ic' lo'iya petsi ȽanDios timujyoxi, iƚque cal Cuecaj Rey Nopa'a lema'a. Toƚiya ti'onƚcospolhuo' to lapoujnalá cajut'ƚi. Iƚque ƚapoujna cajut'ƚ tipa'e, timuqui ƚi'huexi. Tipa'e ƚafane ƚi'huexi, jouc'a tipa'e cal ts'e, timuc'ila' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lijoupa limuc'iyalepa iƚne ƚataiquí, ipanni jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Icuaitsi lipiƚya' pe litojyopa. Ipango'ma imuc'i'mola' lan xanuc' jiƚpe lajut'ƚ pe lafoƚyomma. Iƚne lan xanuc' ticuayi: ―¡Xinƚa'! Acueca' juaiconapa lonespa jouc'a lo'epa. Iƚque cal xans, ¿naitsi nimuc'ipa? Juaiconapa ixina'. ¿Naitsi nepi'ipa limane ti'eƚa' toƚta'a? Iƚque ti'ay acueca' to lo'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iƚque i'hua cal xans ƚinc'alhuaƚpa, María i'máma'. Jacobo, José, Simón y Judas ipimaye. ");
INSERT INTO chdNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lipimaye cacaƚ'no' jouc'a timana' fa'a. ¿Naitsi nimuc'ipa lonespa? ¿Naitsi nepi'ipa limane? ");
INSERT INTO chdNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iƚne ixim'me Jesús to jipu'hua ni naitsi xans. Ixtulenca. Aimicuayi mepenufyacu. Jesús timila': ―Cal profeta mipa'a lipiƚya' o lejut'ƚ, jiƚpiya aimepenufyacu. Ja'ni ti'hua'ma ocuena quiƚya', jiƚpe ƚinca tepenufta. ");
INSERT INTO chdNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma' ahuata al cueca' li'e'ma Jesús jiƚpe lipiƚya'. Lan xanuc' aiquiƚ'huaiyinge. ");
INSERT INTO chdNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Iƚniya ƚitiné Herodes icuejpa lo'epa Jesús. Jiƚque Herodes ticuxe jiƚpe ƚamats' Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Timila' lixanuc': ―Iƚque aJuan Bautista. Imaf'inapa, ipanamma pe lomana' lamizhua. Toƚiya tipa'a limane, ti'ay al cueca'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Toƚta'a licuapa Herodes i'nujuaitsi li'e'epa Juan. Iƚque Herodes ilecopa ƚi'maxi cuftine Herodías, exic'e'epa ƚipima Felipe. Juan Bautista italepa Herodes. Timi: “Ima' o'epa lixcay. Aimoƚmajncona'me anuli ima' ƚaca'no'.” Herodes aits'etenƚcoco'ma iƚiya lines'ma Juan Bautista. Ixtuc'opa, i'noƚpa, ifi'ecopa acadena, i'nicopa lacarza. ");
INSERT INTO chdNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ticua: “Cama'a'ma”. Aiquima'e. Tixpaic'ela' lan xanuc' aga tixtulecu. Jahuay ticuayi: “Juan aprofeta. ȽanDios ummepa.” ");
INSERT INTO chdNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ixhuaitsi ƚemats' Herodes i'e'ma juic. Jiƚpe efoƚyomma Herodes lijoc'ipola'. Ixou'ma ƚi'hua caca'no' Herodías. Juaiconapa icuaitsi quipic'a Herodes. ");
INSERT INTO chdNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Icuaj'mipa ȽanDios, epi'ipa cataiqui', timi ƚahuats': “Itsiya, ¿te caifnepi'iyaco'? Aƚsahue'eƚa'.” ");
INSERT INTO chdNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ƚahuats' ihuejco'ma qui'máma' lixc'ai'i'ma, timi: “Aƚtai'etsi ƚijuac Juan Bautista. Tipo'nof'intsa laxpef' pime.” ");
INSERT INTO chdNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes ixhueƚconni. ¿Te co'eya? Joupa icuaj'mipa ȽanDios, icupa cataiqui'. Lijoc'ipola' jouc'a icuejco'me licuaj'mipa. Aimi'iya micuanac'eya ƚahuats'. Icuxe'ma ti'enƚe to lixahue'epa ƚahuats'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Umme'ma anuli cal soldado pu'hua lacarza tetec'entsa ƚejoc' Juan. ");
INSERT INTO chdNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ipo'nof'intsa ƚijuac laxpef' pime, i'hua'anni, uhui'itsi ƚahuats'. Iƚque itai'ma, uhui'itsi qui'máma'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Icuaiyunca ts'ilihuequi Juan. Itaina'me licuerpo emunatsa. Iye'me u'itsa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús, licuej'ma li'ipa Juan, if'aj'ma al barco, i'hua'ma petsi ailopa'a quiƚya' ni cajut'ƚ. Aicu'ila' lan xanuc'. Li'i'ma quiƚsina' lan xanuc', iƚne ipalunca ƚiƚpiƚeloƚya', iye'me liƚ'mis. Ticuaitsa pe licuaita Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús iquie'ma al cueca' quin'nuhua', icuaitsi locuena liju'. Lipanni al barco ixim'mola' axpela' lan xanuc' joupa icuaita jiƚpiya. Ixim'mola' acuanuc'la. Ixaƚ'mena'mola' lilefcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Joupa ummuhuita, ts'ilihuequi Jesús iƚoc'oƚai'me. Timiyi: ―Jifa'a ailopa'a quiƚya', ailopa'a cajut'ƚ. Joupa ummuhuita. Toxc'ai'itsola' lan xanuc'. Tomitsola' tiyenƚe ƚaiquiƚeloƚya', ti'natsa ƚotejacu. ");
INSERT INTO chdNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús timila': ―¿Te coyecoyacu? Imanc' toƚtes'mitsola'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iƚniya timiyi: ―Jifa'a tipa'a ma le'a amaque' la'í y oquexi' latuye. ");
INSERT INTO chdNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Timila': ―Toƚ'hua'anca fa'a. I'hua'a'me. ");
INSERT INTO chdNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús icuxe'e'mola' lan xanuc' ticutsoƚaiƚe ƚaiquitamqui. Epef'mola' lam maque' la'í, loquexi' latuye. Ehuelojm'ma al toncay lema'a, ix'najtsi'i'ma ȽanDios. Ixquenuf'mola' la'í, epi'i'mola' ts'ilihuequi. Ts'ilihuequi eca'nem'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jahuay itetso'me ixhuaitsola'. Ts'ilihuequi Jesús efot'ƚe'me ƚaijhualcay ƚipanecomma. Ima'ni'me imbama' coque' lan tsiquihuit'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iƚniya litetso'me tixhuaispola' oquej nuxans quimbama' maxnu lan xanuc'. Jouc'a itetso'me lacaƚ'no' jouc'a la'uhuay. ");
INSERT INTO chdNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aiquicoƚ'ma. Jesús icuxe'e'mola' ts'ilihuequi, timila': ―Toƚf'ajliƚe al barco. Toƚquieƚe al cuecaj lin'nuhua'. Iƚque tipanenni tixc'ai'ila' lan xanuc' tiyenƚe ƚilejut'ƚi. ");
INSERT INTO chdNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Lijoupa lixc'ai'ipola' lan xanuc' Jesús if'aj'ma quituca' ƚijualay, tipalaic'otsi ȽanDios. I'ipa quipuqui', tipa'a quituca' jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ts'ilihuequi noyecopá al barco joupa icuaita aculi'. Ƚamats' canujnca ailopa'a. Afule mi'hua al barco. Ƚahua' ti'hua titalecufi. Itsahuemma laja', ujfxi tipange al barco. ");
INSERT INTO chdNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Liƚic'ejma icuainatsi jiƚpiya Jesús, ti'huailetsaf'que laja'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ts'ilihuequi ixim'me mi'huayaf'que laja'. Juaiconapa ixpailij'mola'. Tija'ayi, ticuayi: ―Icuaico'ma cal cueca' quinxpaic'ale. Tija'ayi caxpaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aiquicoƚ'ma. Jesús ipalaic'o'mola', timila': ―Aimixpailij'molhuo'. Ma' iya'. Aimoƚsueƚmot'ƚe'me. Ailopa'a tintsi. ");
INSERT INTO chdNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro timi: ―Maipoujna, ja'ni aƚinca ima', aƚmiƚa': “To'huanni”. Iya' ca'hua'ma, ca'huailetsaf'la' laja', cacuaitsi pe lofpa'a. ");
INSERT INTO chdNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús timi: ―To'huanni. Pedro emunni al barco, i'huailetsaf'tsi laja' ticuaitsi pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lixim'ma ƚahua' ti'hua juaiconapa ipujfxi, ixpaiconni. Ipango'ma if'acaina'ma laja'. Ija'a'ma, timi Jesús: ―Maipoujna, ¡lunƚu'eƚa'! ");
INSERT INTO chdNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aiquicoƚ'ma. Jesús i'nij'ma limane, i'noƚ'ma Pedro, timi: ―Ima' le'a ahuata aƚ'huaiyinge. ¿Te qui'ico'po' a'ij nuli lopicuejma'? ");
INSERT INTO chdNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesús jouc'a Pedro if'ajli'me al barco. Ipanenanni ƚahua'. ");
INSERT INTO chdNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iƚne nomana' al barco exc'onƚingoƚai'me Jesús, timiyi: ―Ima' ma' i'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ti'hua tiquieyi al cueca' lin'nuhua'. Icuaitsa ƚamats' Genesaret. ");
INSERT INTO chdNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iƚne lun Genesaret imetsaico'me Jesús, ummem'mola' lilepaluc' tiyeƚe ni petsi jiƚpiya ƚamats', tuya'atsa joupa icuai'ma Jesús. Licuej'me toƚta'a lan xanuc' icuai'enca jahuay lilefcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ixa'hue'me ma le'a tiƚafc'eƚe ƚema lipijahua' lafcualƚay. Jahuay niƚafc'e'me ixaƚcona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lan xanuc' fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, quiyouyomma Jerusalén, icuaitsa pe lopa'a Jesús. Icuis'e'me, timiyi: ");
INSERT INTO chdNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Iƚniya laƚtatahueló tipa'a liƚ'ejma' tulouyi liƚmane ai'a titetso'me. Ts'ihuejhuo', ¿te aimulouyi liƚmane? ¿Te co'ecopa toƚta'a? ¿Te aimihuejcoyi liƚ'ejma' laƚtatahueló? ");
INSERT INTO chdNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús italai'e'e'mola', timila': ―Imanc' xonca tolihuejyi liƚ'ejma' loƚtatahueló, oƚpic'a. Toƚta'a tolatets'iyi locuxepa ȽanDios. ¿Te conƚ'ecopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ȽanDios ticuxe, ticua: “Taihuejco'mola' co'ailli', co'máma'. Totoc'i'mola'.” Jouc'a ticua: “Cal xans nomipola' cataiqui' qui'ailli' qui'máma' tipa'a lijunac'. Tima'anƚe.” ");
INSERT INTO chdNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","’Ituca' loƚcuapa imanc'. Toƚcuayi: “Cal xans a'i mitoc'i'mola' qui'ailli' qui'máma'. Ma le'a timitsola': Aimi'iya catoc'iyacolhuo'. Iƚe ƚai'hueca coƚa' catoc'icotsolhuo' joupa nenajpa, catsufcota ȽanDios.” Ƚinca tolihuejyi liƚ'ejma' loƚtatahueló. Litaiqui' ȽanDios locuxepa aimolanant'ƚiyi. Toƚ'e'eyi to ni naitsi cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","’Imanc' aijc'a loƚ'ejma'. Ma le'a toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. Cal profeta Isaías inescopolhuo'. Iƚe litaiqui' tuya'e' lonespa ȽanDios, ticua: ");
INSERT INTO chdNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Iƚniya lan xanuc' aƚmi: “Ima' alanDios, ima' unCueca'”. Jiƚpe ƚilunxajma' latets'i, aimalihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lataiqui' lomuc'iyalepa iƚniya, a'i laitaiqui'. Timuc'iyaleyi iƚiya locuxepa lan xanuc'. Tama alaxc'onƚingaiƚa', aimalatenƚma iƚe liƚ'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús ijoc'i'mola' lan xanuc' ticuaiyunca, timila': ―¡Aƚquimf'eƚa'! ¡Aƚcuec'eƚa' iƚe laifmipolhuo'! ");
INSERT INTO chdNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Cal xans lo'nicoya lico, iƚe aimi'iya mixis'meya. Laipayomma lico, iƚe litaiqui' locuapa, ja'ni ixcay cataiqui', iƚe ƚinca tixis'me'ma cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ts'ilihuequi icuaiyunca pe lopa'a Jesús, timiyi: ―¿Te conescopa toƚta'a? Lan xanuc' fariseo juaiconapa ixtuc'opo'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús italai'e'e'mola', timila': ―Al 'ec pe aiquifac' cai'Ailli', iƚque Nopa'a lema'a, iƚe al 'ec tiyaxquim'me. ");
INSERT INTO chdNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Timajnle. Aimoƚquimf'e'mola'. Iƚne afohue, ti'huaj'me'eyi liƚf'as fohue. Ja'ni cal fo' ti'huaj'me'eƚa' ƚif'as fo', loquexi' timefmoƚaita lina. ");
INSERT INTO chdNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro timi: ―Luhuaƚc'e'etsonga' iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús timila': ―Imanc' jouc'a, ¿te ailopa'a coƚpicuejma'? ");
INSERT INTO chdNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Cal xans lo'nicopa lico, iƚe aimitsufaiya lipicuejma', titsufay licu'u, tijouƚa' tipanamma. ¿Te aicoƚsina' toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Laipayomma lico cal xans, iƚe lataiqui' qui'huayomma lipicuejma', iƚe ƚinca tixis'me'ma iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","’Jahuay lonespa, lo'epa cal xans tipayomma lipicuejma'. Maƚpiya qui'huayomma jahuay lixcay. Jiƚpe liƚpicuejma' lan xanuc' tixpic'eyi ti'eƚe lixcay. Tixpic'eyi tima'ahuale'me. Tixpic'eyi tif'iltsaicoƚe ƚipeno ƚiƚf'as xans. Tixpic'eyi tixhuico'mola' locuenaye cacaƚ'no' a'i ƚiƚpeno. Tixpic'eyi tinantse'me. Tixpic'eyi tifelƚaique'me. Tixpic'eyi tixahuale'me. ");
INSERT INTO chdNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","’Jahuay iƚna'a ti'e'e'mola' xujc'a, toƚta'a tixis'me'mola'. Cal xans ja'ni aimulouhuo limane to liƚ'ejma' litatahueló, ma le'a titetso'ma, a'i toƚta'a mixis'meya. ");
INSERT INTO chdNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús ipanni jiƚpiya. I'hua'ma ƚilemats' iƚne ƚiƚeloƚya' Tiro y Sidón. ");
INSERT INTO chdNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Icuaiyunni pe lopa'a Jesús anuli ƚaca'no' qui'huayomma jiƚpe ƚamats'. Iƚque a'ij judía. Litatahueló cuftine lan cananeo. Lan xanuc' judío tetets'innila' iƚne lan cananeo. Ticuayi: “Atsiƚqui iƚniya”. Ƚaca'no' tija'e', timi Jesús: ―Maipoujna, ima' tecui'inghuo' i'Hua David, ¡aƚsinƚa' nincuanuc'! Ƚai'hua caca'no' titeƚma juaiconapa. Itsufaipa anuli ƚiponta'a Satanás. ");
INSERT INTO chdNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús aiquitalai'e'. Ts'ilihuequi iƚoc'oƚai'me, timiyi: ―Iƚca'a ƚaca'no' ti'hua tija'e' lihuequinga'. Tocuxe'eƚa' ti'huanƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús italai'e'ma, timi ƚaca'no': ―ȽanDios lummepa catoc'itsola' lixanuc' Israel, iƚne lo'onƚcospola' to lam mot'ƚ lejac'pola'. Aimi'iya catoc'iyacola' locuenaye lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ƚaca'no' iƚoc'huai'ma exc'onƚingai'ma, timi: ―Maipoujna, ¡aƚtoc'iƚa'! ");
INSERT INTO chdNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús italai'e'e'ma, timi: ―Aimi'iya miƚonc'e'enyacola' ƚile'i la'uhuay, meca'ni'enyacola' lan tsiƚqui. ");
INSERT INTO chdNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ƚaca'no' timi: ―Maipoujna, al ƚinca lotaiqui'. Iya' cacua: Iƚniya lan tsiƚqui, tama atsiƚqui, iƚne titeji laijhualcay ca'i lacangemma limesa ƚiƚpoujna. ");
INSERT INTO chdNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Licuej'ma jiƚiya lataiqui' Jesús timi: ―Maca'no', acueca' aƚ'huaiyijmpa. Ma to laƚsahue'epa, toƚe ti'iƚa'. Maƚe 'hora ixaƚcona'ma ƚi'hua ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús ipanni jiƚpiya. Ti'hua ƚema al cuecaj quin'nuhua' Galilea. If'aj'ma ƚijualay, licuaitsi icutshuai'ma jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Icuaiyunca axpela' lan xanuc'. Icuai'etsa axpela' lilefcualƚay, iƚne lan coxo, latumane, lan fohue, jouc'a ocuenaye lan xanuc' iƚne aimi'i mipalaiyi, jouc'a ocuenaye lafcualƚay. Ipo'nom'mola' huejnca li'mitsi' Jesús. Iƚque ixaƚ'mena'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lan xanuc' ixim'me iƚe li'ipola' lafcualƚay. Iƚne pe aimipalaiyi ipalaina'me. Iƚne latumane joupa ixaƚconapola'. Lan coxo tiyenayi. Lan fohue tixinalenayi. Lixim'me toƚta'a lan xanuc' timiyoƚtsi: ―¡Xinƚa' ja'a! Iƚque Jesús ti'ay al cueca'. Ix'najtsi'i'me ȽanDios, ƚilenDios iƚne lan xanuc' Israel. ");
INSERT INTO chdNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ijoc'i'mola' ts'ilihuequi, ticuainanca. Timila': ―Iya' caxinnila' cuanuc'la iƚna'a lan xanuc'. Ixhuaita afane' quitine maƚmana' anuli fa'a. Ailopa'a cotejacu. Aimi'iya cummeyacola' toƚta'a. Aimi'iya miyeyacu ƚiƚpiƚeloƚya'. Titafquecola' lane. ");
INSERT INTO chdNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ts'ilihuequi timiyi Jesús: ―Jifa'a ailopa'a quiƚya'. ¿Petsi caƚsi'neyacu ƚa'i ƚotejacu iƚna'a axpela' lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús icuis'e'mola' ts'ilihuequi, timila': ―¿Tojua mipa'a ƚola'i? Timiyi: ―Acaitsi la'í, oquexi' afantsi latuye. ");
INSERT INTO chdNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesús timila' lan xanuc': ―Toƚcutsoƚaiƚe ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Epef'mola' lan caitsi la'í jouc'a latuye. Ix'najtsi'i'ma ȽanDios. Ixquenuf'mola', epi'i'mola' ts'ilihuequi. Ts'ilihuequi eca'neyale'me. ");
INSERT INTO chdNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jahuay itetso'me, ixhuaitsola'. Ts'ilihuequi efot'ƚe'me lan hualcay lipanecomma. Imantsi acaitsi cal tuc'pay. ");
INSERT INTO chdNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lan xanuc' nitetsopá tixhuaispola' oquej nuxans maxnu. Lacaƚ'no', la'uhuay itetsopá jouc'a, aiquixhuej'mem'mola' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús ixc'ai'ina'mola' lan xanuc' tiyenƚe ƚiƚpiƚeloƚya'. If'aj'ma al barco, i'hua'ma ƚamats' pe lopa'a liƚya' cuftine Magdala. ");
INSERT INTO chdNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Lam fariseo jouc'a lan saduceo icuaitsa pe lopa'a Jesús. Ehuai'me. Timiyi: ―To'eƚa' al cueca' to lo'eya ȽanDios, iƚque Nopa'a lema'a. Toƚta'a aƚ'huaiyijm'mo'. ");
INSERT INTO chdNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús italai'e'e'mola', timila': ―Mif'acai'ma cal 'ora, ja'ni tunxaƚc'o lema'a, toƚcuayi: “Mouqui ti'i'ma ac'a quitine”. ");
INSERT INTO chdNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mi'i'ma quitine toƚcuayi: “Xinƚa', tunxaƚc'o lema'a, unxamuhua, ti'hua'ma ƚahua', ticui'ma”. Imanc' a'i cunc'ic'a xanuc', ma le'a tonƚ'e'eyoƚtsi. Toƚsuef'yi lema'a, tijouƚa', aimi'iya coƚsina' te ts'i'ic' lomuc'ipolhuo' ȽanDios itsiya litine. ");
INSERT INTO chdNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","’Lan xanuc' nomana' itsiya ux'maspá lipene ȽanDios. Mi'eyi al xujc'a timiyi: “Aƚmuc'itsonga' al cueca'”. A'i mimuc'inyacola'. Ƚinca ti'i'ma to li'ipa cal profeta Jonás mipa'a luyaipa quitine. Iƚiya lo'iya tixim'me. Ipo'no'mola' i'huana'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iquiecona'me al cueca' quin'nuhua' Jesús jouc'a ts'ilihuequi. Jiƚniya ts'ilihuequi aiquiƚtaic' quile'i, imenc'ecopá. ");
INSERT INTO chdNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús timila': ―Toƚpo'noƚe cuenna. Aimolapenuf'me liƚƚevadura lam fariseo, ni aimolapenuf'me liƚƚevadura lan saduceo. ");
INSERT INTO chdNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iƚniya timiyoƚtsi: ―¿Te caƚmicoponga' toƚta'a? O ¿iƚque inescopa aicaƚtaic' cala'i? ");
INSERT INTO chdNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús ixina' locuapa iƚniya, timila': ―¿Te coƚmicopoƚtsi: “Illanc' aicaƚtaic' cala'i. ¿Te caƚ'eyacu?”? Imanc' huata aƚ'huaiyinge. ");
INSERT INTO chdNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Te olimenc'ecopá lam maque' la'í litempa loquej nuxans quimbama' maxnu lan xanuc'? ¿Te olimenc'ecopá tojua lan tsiquihuit'ƚ loƚma'ne'mola' cal hualcay ca'i ƚipanecomma? ");
INSERT INTO chdNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Te jouc'a olimenc'ecopá lacaitsi la'í litempa lam malpuj mil lan xanuc'? ¿Te olimenc'ecopá tojua lan tuc'pay loƚma'ne'mola' cal hualcay ca'i ƚipanecomma? ");
INSERT INTO chdNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Te aimoƚcuejcoyi laitaiqui' laimipolhuo'? Iƚe laitaiqui' laimipolhuo': “Toƚpo'noƚe cuenna. Aimolapenuf'me liƚƚevadura lam fariseo. Ni aimolapenuf'me liƚƚevadura lan saduceo”, iya' aicapalaijma ƚa'i. ");
INSERT INTO chdNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Itsiya ts'ilihuequi Jesús iƚcueca iƚque limipola'. Jesús tipalaicola' lam fariseo jouc'a lan saduceo lomuc'iyalepa. Aimipalaijma cal levadura iƚe ƚolai'impa cal harina milanc'em'me ƚa'i. ");
INSERT INTO chdNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús jouc'a ts'ilihuequi icuaitsa ƚemats' iƚe liƚya' cuftine Cesarea de Filipo. Jiƚpe Jesús icuis'e'mola' ts'ilihuequi, timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a, ¿te limetsaijma lan xanuc'? ¿Te cocuapa iƚniya? ¿Naitsi iya'? ");
INSERT INTO chdNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iƚniya timiyi: ―Timana' iƚne nocuapá ima' unJuan Bautista. Ocuenaye ticuayi ima' umprofeta Elías. Locuenaye ticuayi ima' umprofeta Jeremías o mocuenaj profeta. ");
INSERT INTO chdNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús timila': ―Imanc', ¿te coƚcuapa? ¿Naitsi iya'? ");
INSERT INTO chdNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pedro italai'e'e'ma, timi: ―Ima' unCristo, ƚummepo' ȽanDios. Ima' i'Hua ȽanDios Ƚimaf'i'. ");
INSERT INTO chdNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús timi: ―CunSimón, i'hua Jonás, ima' ipaxnepo' ȽanDios. A'ij xans ƚimuc'ipo' toƚta'a. Ma le'a cai'Ailli' Nopa'a lema'a, iƚque ƚinca imuc'ipo'. ");
INSERT INTO chdNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Iya' camihuo': Ima' umPedro. Iƚe lopuftine ja'ni tuhuaƚcufinƚe, tecui'im'me Apic. Itsiya omujpoxi to ƚapic petsi laifpo'nof'iya lainejut'ƚ, iƚe lolanc'ecoya axanuc' pe laifnefot'ƚeyacola'. Iƚniya ni lamaya aimulijyacola' nulemma. ");
INSERT INTO chdNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Capi'i'mo' lomane tomuc'itsola' lan xanuc' ti'iƚa' quiƚsina' pe loƚtsuflaiyacu, tiyenƚe lipene ȽanDios, ticuaitsa pe locuxeyopa ȽanDios, iƚque Nopa'a lema'a. Pu'hua lema'a ja'ni ticuanni: “Ailopa'a lane, aimi'e'me”, toƚta'a ima' jouc'a tomi'mola' lof'as xanuc': “Aimo'e'ma. Ailopa'a lane. Aimi'iya mo'eya toƚta'a.” Pu'hua lema'a ja'ni ticuanni: “Ne', ti'i'ma ti'e'me”, ima' jouc'a tomi'mola' lof'as xanuc': “Ti'i'ma to'e'ma, tipa'a lane. Ne', to'eƚa'.” ");
INSERT INTO chdNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ixc'ai'i'mola' ts'ilihuequi, timila': ―Aimonluya'a'me naitsi iya', iya' ninCristo. ");
INSERT INTO chdNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ipangocopa iƚe litine Jesús tu'ila' ts'ilihuequi te ts'i'ic' lo'iya. Tu'ila' ticuicomma titeƚco'ma, ti'huana'ma Jerusalén. Jiƚpiya iƚniya lan xanuc' noxpijpá lataiqui', lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, titeƚ'mita juaiconapa. Tima'ata. Afane' quitine timaf'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro aiquetenƚcoco'ma iƚe lines'ma Jesús. Ileco'ma lijuqueya, itale'ma, timi: ―Maipoujna, aimocua'ma toƚta'a. Aimi'iya mi'iyaco' toƚiya. ");
INSERT INTO chdNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús ipai'e'moxi, timi Pedro: ―¡To'huanƚa'! ¡Tanajxoxi fa'a! Ima' monta'a. Ima' opic'a aƚsnic'e'eta laipene. Ima' toxpic'e to mixpic'eyi lan xanuc'. Ituca' tixpic'e ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesús tipalaic'ola' ts'ilihuequi, timila': ―Cal xans, ja'ni lihuejla', aimicuxeyacoxi quituca'. Iya' lapaƚts'inginna lancruz. Naitsi nalihuejya titaiƚa' lencruz jouc'a. Tixpic'eƚa' tixnet'ƚƚa' lateƚcoya. Toƚta'a lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Naitsi no'epoxi cuenna juaiconapa, ja'ni aimicua miteƚcoya, iƚque cal xans tecani'e'moxi. Naitsi nocuyacoxi lateƚcoya, nalihuejya, tama tima'anƚe, iƚque tulij'ma lipitine, iƚe al ts'e lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Cal xans nulijpa jahuay lopa'a fa'a li'a ƚamats', ja'ni tecani'exoxi ¿te tixhuico'ma iƚe lulijpa? A'i, aimi'iya. ¿Te ti'i'ma ti'najtse'ma, ti'e'econa'moxi ac'a lipicuejma'? A'i. Aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","’Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cacuaiconanni jifa'a li'a ƚamats', aƚejmalecu lainepaluc' quema'a. Toƚta'a aƚsim'ma iya' nincueca', aƚ'onƚcota to ȽanDios cai'Ailli'. Iƚe litine iya' ca'najtse'mola' lan xanuc'. Anuli anuli tepenuf'me lolijpa, ja'ni al c'a o lixcay. To li'epa jifa'a li'a ƚamats' ma toƚta'a ca'najtse'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iya' camilhuo' al ƚinca: Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a, cacuxe'mola' lan xanuc'. Hualca imanc' nolacaxhuoƚanna fa'a itsiya, ai'a timana'molhuo' toƚsim'me toƚta'a laif'epa. ");
INSERT INTO chdNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Uyai'ma acamts'us quitine Jesús ileco'mola' Pedro jouc'a loquexi' capimaye Jacobo jouc'a Juan. If'ajli'me quiƚtuca' ƚi'nof'quiya ƚijuala. ");
INSERT INTO chdNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Licuaitsa jiƚpe ipaico'ma lixans Jesús. Iƚne ts'ilihuequi ixim'me li'a tunts'ifi to cal 'ora. Lipijahua' i'i'ma afujca, ti'onƚcospa to lipepalc'o' litine. ");
INSERT INTO chdNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ixim'me imaxcaitsola' Moisés y Elías. Ts'ilihuequi ixim'me mipalaic'oyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro timi Jesús: ―Maipoujna, ma jifa'a aƚmanecu. Toƚta'a luyalaico'me al c'a. Ja'ni opic'a calanc'e'ma afane' lihuoxqui, anuli ima', anuli Moisés, anuli Elías. ");
INSERT INTO chdNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mipalay Pedro, imunni ƚummahuay, ummaf'cai'mola'. Ƚummahuay tunts'ifi. Ts'ilihuequi Jesús icuej'me tipalay nolojmay cummahuay, timila': ―Iƚca'a ai'Hua, ca'ay capic'a juaiconapa, latenƚma lipicuejma'. ¡Toƚquimf'eƚe! ");
INSERT INTO chdNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Licuej'me iƚiya lataiqui', ts'ilihuequi Jesús ixpailij'mola' juaiconapa. Ixpats'huoƚai'me ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús icuaitsi pe loxpats'huoƚanna, iƚaf'mola', timila': ―Toƚtsolinanca. Aimixpailij'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iƚniya ehuelojm'me. Ixim'me ma le'a quituca' Jesús. Moisés y Elías ailomana'. ");
INSERT INTO chdNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mimulnamma ƚijuala, Jesús ixc'ai'i'mola', timila': ―Itsiya aimoluyout'ƚe'me loƚsimpa. Nij naitsi nocuejya. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ticuaitsi litine camaf'inƚa', quipayonahuo pe lomana' lamizhua, iƚe litine tolu'i'mola' lan xanuc' loƚsimpa. ");
INSERT INTO chdNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ts'ilihuequi icuis'e'me, timiyi: ―Lomxiye nomuc'iyalepá locuxepa ȽanDios tinesyi: “Elías ticuaiconahuo ate'a, tijouƚa' ticuaihuo cal Cristo”. ¿Te conescopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús italai'e'e'mola', timila': ―Al ƚinca lonespa iƚniya: “Elías ticuaiconahuo ate'a”. Iƚque tixanu'ma jahuay. ");
INSERT INTO chdNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Iya' camilhuo': Elías joupa icuai'ma. Iƚniya aiquilimetsaijma. Iteƚ'mipá, i'e'epá ma to ts'iƚpic'a. Ma toƚta'a to ts'iƚpic'a, aƚteƚ'mi'ma iya' jouc'a. Iya iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ts'ilihuequi Jesús icuec'e'me tipalaijma Juan Bautista, iƚque ti'onƚcospa to Elías. ");
INSERT INTO chdNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Icuainatsa pe lomana' axpela' lan xanuc' lafoƚyomma. Anuli cal xans icuaitsi pe lopa'a Jesús, exc'onƚingai'ma, timi: ");
INSERT INTO chdNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Maipoujna, toxinƚa' cuanuc' ƚai'hua. I'huajcopa mac'ojay. Titeƚma juaiconapa. Camna tecajm‑maispa ƚunga, o camna tecajm‑maispa laja'. ");
INSERT INTO chdNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aicuai'e'ma pe lomana' ts'ihuejhuo'. Iƚne aimi'i mixaƚ'meyi. ");
INSERT INTO chdNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús italai'e'ma, ticua: ―¡Ah imanc'! Aimoƚ'huaiyijnyi ȽanDios, a'ij ƚijca loƚpicuejma'. ¡Coƚa' aicapajncona'ma pe loƚmana'! ¿Te iya' ti'hua caxnet'ƚ'ma xonca? Timi cal xans: ―Aƚƚec'metsi ƚo'hua. ");
INSERT INTO chdNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús itale'ma ƚiponta'a Satanás, iƚque ƚitsufaipa ƚamijcano. Ipanni. Aiquicoƚ'ma, ixaƚcona'ma ƚi'hua cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ts'ilihuequi icuaitsa quiƚtuca' pe lopa'a Jesús, timiyi: ―Illanc', ¿te aiqui'ic' calipa'e ƚonta'a? ");
INSERT INTO chdNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús timila': ―Imanc' aicoƚ'huaiyinge ȽanDios. Toƚta'a aiqui'ic' colipa'e ƚonta'a. Iya' camilhuo' al ƚinca: Tama ajhuata iƚe loƚ'huaiyijncopa ȽanDios, tama ti'onƚcospa to anuli cal fanu' xonca aca'hua, ja'ni toƚ'huaiyijnyi ti'i'ma toƚ'e'me al cueca'. Toƚcuxe'e'me iƚque ƚijuala, toƚmi'me: “Aimopajm'ma xonca fa'a. To'huanƚa' pu'huanni.” Ma toƚta'a ti'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jouc'a camilhuo': Lontahue to iƚcu'hua afule mipalumma. Ticuicomma toƚsnet'ƚƚe, toƚsa'hueƚe ȽanDios, toƚta'a tolipa'e'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Miyelocoyi al distrito Galilea, Jesús jouc'a ts'ilihuequi, iƚque timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a, aƚcunna. Lan xanuc' aƚ'e'eta to mixpic'eyi liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aƚma'ata. Afane' quitine camaf'ina'ma, quipayohuo pe lomana' lamizhua. Licuej'me jiƚiya lataiqui' ts'ilihuequi Jesús ixhueƚconca juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Icuaitsa liƚya' Capernaum. Jiƚpe iyouyunca lin'najtsi'iyalepá al cuecaj xoute'. Icuis'e'me Pedro, timiyi: ―Ƚopomxi, ¿te ti'najtse'e loxa'huempa al cuecaj xoute' o a'i? ");
INSERT INTO chdNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro italai'e'e'mola', timila': ―Ti'najtse'e. Icuaitsi lajut'ƚ. Jesús ixina' licuis'epa iƚne lin'najtsi'iyale. Ipalaic'o'ma Pedro, timi: ―Simón, ¿naitsi iƚne no'najtsepá impuesto? Iƚe al tomí lapenufyacu lincuxepá nomana' fa'a li'a ƚamats', ¿te liƚnaxque' lincuxepá ti'najtseyi? o ¿locuenaye lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro timi: ―Locuenaye lan xanuc' no'najtsepá, liƚnaxque' a'i. Jesús timi: ―Al ƚinca lofcuapa. Liƚnaxque' aimi'najtseyi. ");
INSERT INTO chdNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Iya' i'Hua ȽanDios, iƚne aimi'iya maƚmiya: “To'najtseƚa' lejut'ƚ ȽanDios”, iƚe ejut'ƚ cai'Ailli'. Tama al ƚinca iƚe laifcuapa, itsiya camihuo': Aƚ'najtse'me. Ja'ni a'i ticua'me latets'ila'. To'huaƚa' al cuecaj quin'nuhua', tacajm'mitsi ƚomecuxa. Cal te'a catú tinuc'la' ƚacuxa, to'noƚƚa'. Tacuaf'etsi lico, taipa'atsi al tomí lopa'a jiƚpe lico ƚatu. Totaitsi, to'najtse'etsola' iƚe laƚsahue'emponga'. ");
INSERT INTO chdNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iƚne ƚitiné ts'ilihuequi Jesús icuaitsa, icuis'e'me Jesús, timiyi: ―Jiƚpiya pe lomana' iƚniya naihuejcopá cal Rey Nopa'a lema'a, ¿naitsi xonca cal cueca'? ");
INSERT INTO chdNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús ijoc'i'ma anuli ƚahuac'hua. Ecaxu'e'mola' ts'ilihuequi, ");
INSERT INTO chdNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","timila': ―Iya' camilhuo' al ƚinca: Ticuicomma toƚsuej'menca, toƚ'etsoƚtsi to jiƚca'a ƚacahuac'hua. Ja'ni a'i, aimoƚsuflaiyacu pe lomana' naihuejcopá ȽanDios, cal Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ja'ni cal xans ti'oc'exoxi, ti'onƚicoxoxi to iƚca'a ƚacahuac'hua, iƚque cal xans ti'i'ma xonca cal cueca' pe lomana' naihuejcopá cal Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Cal xans nocuapa: “Jesús ti'ela' capic'a la'uhuay”, tijouƚa' tepenufi anuli iƚna'a, iƚque cal xans lapenufinga' iya'. ");
INSERT INTO chdNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Cal xans naimenac'iya anuli iƚna'a laica'uhuay naƚ'huaiyijmpa, acueca' titeƚ'mim'me. Iƚque coƚa' ifi'em'me ƚejoc', coƚa' ifinc'im'me cal cuecaj capic, ecajm'mintsa lin'nuhua' coƚa' unxaƚac'ma, ima'ma. Toƚta'a ticuicomma lo'iya iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Micoƚi li'a ƚamats' ti'hua timajm'me lan xanuc' naimenac'iyacu liƚf'as xanuc', toƚta'a aimunƚuya li'a ƚamats', titeƚ'mim'me. Ma' anuli cal xans naimenac'iya ƚif'as xans a'ijc'a loyaicoya, jouc'a aimunƚuya. ");
INSERT INTO chdNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ja'ni lomane o lo'mis timenac'ihuo' najmay tatejla', taca'niƚa'. Ja'ni tecajm'minno' petsi aimipica ƚunga, ¿te cof'ecoyacola' oque' lomane, oque' lo'mitsi'? Najmay totsufaitsi jiƚpiya pe lotsuflaiyacu iƚne nepenufpá al ts'e liƚpitine aimijouya, tama le'a anuli lomane o anuli lo'mis. ");
INSERT INTO chdNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ja'ni anuli lo'u timenac'ihuo', taipa'aƚa', taca'niƚa' aculi'. Ja'ni tecajm'minno' al muf pe lonajpa ƚunga, ¿te cof'ecoyacola' oque' lo'u'? Najmay totsufaitsi jiƚpiya pe lotsuflaiyacu iƚne nepenufpá al ts'e liƚpitine aimijouya, tama le'a anuli lo'u. ");
INSERT INTO chdNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Imanc' toƚpo'noƚe cuenna. Aimonlatets'i'mola' iƚna'a laica'uhuay. Iya' camilhuo', jiƚpe lema'a timana' lilepaluc' iƚna'a laica'uhuay. Iƚne lapaluc' quema'a itine itine timana' anujnca cai'Ailli', iƚque Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aicuaicoco'ma fa'a li'a ƚamats' cunƚu'e'mola' lan xanuc' lejac'pola'. Iƚe ma' aipenic'. ");
INSERT INTO chdNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Te coƚcuapa? Anuli cal xans timana' amaxnu limot'ƚ, ja'ni anuli tejac'la', ¿te co'eya? Iƚque tipo'no'mola' lam malpuj nuxans quimbamaj pelƚa jiƚpiya ƚimuc'o, ti'hua'ma tehueta ƚejac'pa. ");
INSERT INTO chdNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ƚinca lam malpuj nuxans quimbamaj pelƚa limot'ƚ, iƚne pe aiquejac'ila', iƚniya tixoc'iyi queta cal xans. Tixinnatsi ƚimoƚ ƚejac'pa, xonca tixoc'i'ma queta. ");
INSERT INTO chdNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Toƚta'a lipicuejma' coƚ'Ailli', iƚque Nopa'a lema'a. Iƚque ticua: Aimejac'mola' laitsocay ca'uhuay, ni anuli. ");
INSERT INTO chdNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Ja'ni a'ijc'a li'epo' ƚopima, to'huaƚa' ima' cotuca' pe lopa'a iƚque. Tomitsi: “¿Te caƚ'ecopa toƚta'a?” Ja'ni ticueca joupa oxanu'epa. Toƚpalaic'ona'moƚtsi, ailopa'a tintsi. ");
INSERT INTO chdNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ja'ni aimicueca, topo'noƚa', to'huaƚa', tahuetsola' anuli o oquexi' lapimaye. Tolecotsola' pe lopa'a ƚopima. Toƚta'a to'e'ma ma to loya'apa al Paxi Liniƚingiya, ticua: “Ticuicomma oquexi' afantsi lan xanuc' ticuejcota lotalai'ecoya anuli cal xans”. ");
INSERT INTO chdNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ja'ni iƚque ƚopima aimicueca, ja'ni aimiquimf'ela' iƚniya, to'hua'ma, to'itola' lapimaye jiƚpiya pe lafot'ƚeyopoƚtsi. Ja'ni ti'hua aimicueca, aimiquimf'ela', ima' aimaimetsaico'ma xonca, jiƚque cal xans a'i copima. Ima' aimonƚejmaleyacu lan xanuc' pe aimimetsaicoyi ȽanDios, jouc'a pe aimihuejcoyi locuxepa ȽanDios aimonƚejmaleyacu. Ma toƚta'a aimonƚejmalecona'me iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Iya' camilhuo' al ƚinca: Pu'hua lema'a ja'ni ticuanni: “Ailopa'a lane, aimi'e'me”, toƚta'a imanc' jouc'a toƚmi'mola' loƚf'as xanuc': “Aimo'e'ma. Ailopa'a lane. Aimi'iya mo'eya toƚta'a.” Pu'hua lema'a ja'ni ticuanni: “Ne', ti'i'ma ti'e'me”, imanc' jouc'a toƚmi'mola' loƚf'as xanuc': “Ti'i'ma to'e'ma, tipa'a lane. Ne', to'eƚa'.” ");
INSERT INTO chdNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Jouc'a camilhuo': Moƚmana' fa'a li'a ƚamats', ja'ni oquexi' imanc' ti'iƚa' anuli loƚpicuejma', ja'ni toƚsahue'eƚe cai'Ailli' Nopa'a lema'a tepi'itsolhuo', iƚque tepi'i'molhuo' iƚe loƚsahue'epa. ");
INSERT INTO chdNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Petsi lafoƚyomma oquexi' afantsi lan xanuc' naƚ'huaiyijmpa, iya' jouc'a capa'a. ");
INSERT INTO chdNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro i'hua'ma pe lopa'a Jesús, icuis'e'ma, timi: ―Maipoujna, ¿tojua quimenc'e'eco'ma lijunac' ƚaipima, iƚque a'ijca' ƚaƚ'e'epa? Iya' cacua tixhuaitsi acaitsi. ");
INSERT INTO chdNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús timi Pedro: ―Iya' camihuo': A'i nica acaitsi taimenc'e'eco'ma li'e'epo' lixcay ƚopima. Cojouya lan caitsi ti'hua taimenc'e'eco'ma afanej nuxans quimbama', tijouƚa' ti'hua taimenc'e'eco'ma, aimi'iya moxhuej'meya. ");
INSERT INTO chdNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Micuxe ȽanDios cal Cuecaj Rey Nopa'a lema'a, iƚque li'ejma' ti'onƚcospa to li'ejma' anuli cal cuecaj quincuxepa. Iƚque ixpic'epa ti'najtsi'itsola' limozó. ");
INSERT INTO chdNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lipangopa li'najtsi'ipola' limozó, ate'a icuai'entsa anuli cal mozo xonca itaiyinge acueca'. ");
INSERT INTO chdNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Iƚque cal mozo aimi'iya mi'najtseya. Ƚipoujna, iƚque cal cuecaj quincuxepa, icuxe'ma ticuquintsa ƚimozo. Jouc'a ticuquintsola' ƚipeno, linaxque', jahuay ƚi'huexi. Toƚta'a ti'najtseco'ma litaiyinc'e. ");
INSERT INTO chdNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Cal mozo exc'onƚingai'ma, ixa'hue'ma ƚipoujna, timi: “Ti'iƚa' c'a ƚomunxajma'. Aƚ'huaicoƚa'. Ca'najtse'ena'mo' jahuay laitaiyinc'ehuo'.” ");
INSERT INTO chdNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ƚapoujna ixim'ma acuanuc' ƚimozo. Imenc'e'ecopa litaiyinc'enni. Ux'mas'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Ipanni cal mozo ƚimenc'e'ecompa litaiyinge. Italecuf'ma anuli ƚif'as mozo. Iƚque itaiyinc'e huata. Cal mozo ƚimenc'e'ecompa litaiyinge i'noƚ'ma ƚif'as mozo. Ipango'ma ummit'ƚe'e'ma ƚejoc', tija'e', timi: “¡Aƚ'najts'e'eƚa' laƚtaiyinc'e!” ");
INSERT INTO chdNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ƚif'as mozo exc'onƚingai'ma, tixahue'e, timi: “Ti'iƚa' c'a ƚomunxajma'. Aƚ'huaicoƚa'. Ca'najtse'ena'mo' jahuay laitaiyinc'ehuo'.” ");
INSERT INTO chdNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Iƚque cal mozo aiquicuac'. I'hua'ma icuxe'ma titats'entsa, tipajntsi lacarza. Ticua: “Ma caƚtaiyinc'e tipajnla' jiƚpiya”. ");
INSERT INTO chdNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","’Locuenaye lam mozó ixim'me li'i'ma. Ixhueƚco'me. Iye'me u'itsa ƚiƚpoujna jahuay li'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ƚapoujna, iƚque cal cuecaj quincuxepa, ijoc'i'ma cal mozo, iƚque ƚimenc'e'ecompa litaiyinge, itale'ma, timi: “Ima' mixcay mozo. Ima' aƚsa'huepa, iya' nimenc'e'ecopo' lotaiyinge jahuay. ");
INSERT INTO chdNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Iya' aiximpo' uncuanuc'. Ima', ¿te aicoxina' cuanuc' ƚof'as mozo?” ");
INSERT INTO chdNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ƚapoujna ixtuc'o'ma juaiconapa iƚque ƚimozo. Icuxe'mola' ti'hua'anƚe pe lomana' lin'noƚale ti'noƚta, titeƚ'minna. Ma mi'hua mitaiyinge, ti'hua titeƚ'minna. ¡Ti'najtse'eƚa' jahuay litaiyinc'e! ");
INSERT INTO chdNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Imanc' jouc'a ja'ni aimolimenc'e'ecoyacola' nulemma loƚpimaye li'e'epolhuo', toƚiya titeƚ'mi'molhuo' cai'Ailli' Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lijoupa lu'ipola' iƚiya lataiqui', Jesús ipanni jiƚpe al distrito Galilea, i'hua'ma ƚamats' lopa'a locuenaj liju' al pana' Jordán. ");
INSERT INTO chdNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Axpela' lan xanuc' tihuejyi, jiƚpe ixaƚ'me'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Icuaitsa lan xanuc' fariseo tehuaiƚe. Icuis'e'me, timiyi: ―Cal xans, ja'ni ƚipeno tipa'a li'epa, ¿te tipa'a lane tecanai'ma iƚque ƚaca'no'? O ¿aimi'iya? ");
INSERT INTO chdNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús italai'e'e'mola', timila': ―¿Te aicoƚsuec' iƚe li'epa ȽanDios lilanc'epa li'a ƚamats'? Ilanc'epola' oquexi', anuli cal xans anuli ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Lijoupa lilanc'epola' iƚne loquexi', ȽanDios uya'a'ma: “Cal xans tipo'no'mola' quiƚtuca' qui'ailli' qui'máma', tileco'ma ƚipeno. Ti'e'e'moƚtsi anuli.” ");
INSERT INTO chdNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ai'a tileco'moƚtsi timana' oquexi'. Lijou'ma i'i'mola' anuli. ȽanDios toƚta'a ejonƚipola'. Imanc' unc'ixanuc', aimonlanaj'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lan xanuc' fariseo icuis'e'me, timiyi: ―Moisés inesco'ma: “Cal xans tiniƚ'ma al je'e lacanaicoya ƚipeno, tijouƚa' ti'i'ma tecanai'ma”. Ja'ni cal xans aimi'iya mecanaiya ƚipeno, ¿te quinescopa toƚta'a Moisés? ");
INSERT INTO chdNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús italai'e'e'mola', timila': ―Moisés iximpolhuo' imanc' loƚpicuejma'. Imanc' unc'incuejlocale. Toƚta'a epi'ipa lane cal xans tecanaiƚa' ƚipeno. Al te'a a'i toƚta'a licuxepola' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","’Iya' camilhuo', cal xans aimi'iya mecanaiya ƚipeno. Tipa'a lane tecanaiƚa' ma le'a ja'ni ƚaca'no' ihuejpa ocuena' cal xans. Ja'ni a'i, aimi'iya mecanaiya. Cal xans necanaipa ƚipeno, ja'ni ilecopa ocuenaj caca'no', iƚque cal xans i'epa lixcay, titai'ma lijunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ts'ilihuequi Jesús timiyi: ―Ja'ni toƚta'a cal xans aimi'iya mecanaiya ƚipeno, xonca ac'a loyaicoya cal xans ja'ni aimilecoya caca'no'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús timila': ―A'i jahuay lan xanuc' mi'iya mepenufyacu iƚe lataiqui' loƚnescopa. Tepenuf'me iƚne lan xanuc' joupa lepi'ipola' toƚta'a liƚpicuejma' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","’Timana' iƚne aimilecoyi caca'no', toƚta'a liƚsans. Ocuenaye, liƚf'as xanuc' i'e'empola', toƚta'a aimi'iya milecoyacu caca'no'. Jouc'a timana' iƚniya quiƚtuca' ixpic'epá aimileco'me caca'no', inespá: “Capajm'ma caituca'. Toƚta'a xonca ca'e'ma lipenic' ȽanDios cal Cuecaj Rey Nopa'a lema'a.” ’Naitsi ti'i'ma tepenuf'ma iƚta'a lataiqui', ne', tepenufla'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Icuai'entsola' la'uhuay pe lopa'a Jesús. Ticuayi tixpayaf'tsola' Jesús limane ƚiƚjuac la'uhuay, tixa'hueƚa' ȽanDios titoc'itsola'. Ts'ilihuequi ixtulenca, italem'mola' iƚniya nocuai'espá liƚnaxque'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús timila': ―Tolapi'itsola' lane tiyouyunca la'uhuay pe laifpa'a. Aimoƚcuanac'e'mola'. Pe lo'onƚcospola' to iƚna'a la'uhuay, iƚne ƚinca titsuflai'me pe locuxeyopa cal Cuecaj Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ixpayaf'mola' limane. Lijou'ma ti'hua tuyaipa. ");
INSERT INTO chdNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Anuli cal xans icuaitsi pe lopa'a Jesús, icuis'e'ma, timi: ―Momxi, aipic'a culijla' al ts'e laipitine pe aimijouya. ¿Tej c'a caif'eya? ");
INSERT INTO chdNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús italai'e'e'ma, timi: ―Ima', ¿te calicuis'ecopa te ts'i'ic' al c'a? Anuli ma le'a cal C'a, iƚque ȽanDios. Ja'ni totsufai'ma pe lofmepenufya al ts'e lopitine aimijouya, taihuejcoƚa' locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Cal xans icuis'e'ma, timi: ―Iƚne ƚataiquí loya'apa locuxepa ȽanDios, ¿jale iƚe caifnihuejcoya? Jesús timi: ―“Aimoma'ahuale'ma. Aimoxhuico'ma ƚipeno ƚof'as xans, ma le'a quituca' ƚopeno toxhuico'ma. Aimonantse'ma. Ja'ni topalaicotsola' lof'as xanuc' tonesla' al ƚinca, aimofel'miyale'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Taihuejco'mola' co'ailli', co'máma', totoc'i'mola'. Ima' to'eyoxi capic'a, ma toƚta'a to'eƚa' capic'a ƚof'as xans, naitsi ƚoftalecufya.” ");
INSERT INTO chdNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ƚamijcano timi: ―Laƚtojyomma iƚe lataiqui' canant'ƚi, ti'hua canant'ƚi. ¿Te calahue'epa? ");
INSERT INTO chdNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús timi: ―Ja'ni ma tanant'ƚi'ma locuxepa ȽanDios, to'huanƚa', tocujtsi ƚo'huexi, iƚiya al tomí lofmulijya tapi'itsola' lan xanuc' pe ailopa'a quiƚ'hueca. Toƚta'a ti'i'ma acueca' ƚo'huexi jipu'hua lema'a. To'eƚa' ma to laifmipo', tijouƚa' topaiconanni, lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Licuej'ma jiƚiya lataiqui', ƚamijcano ihuotsonni, i'hueca juaiconapa ƚi'huexi. I'huana'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús timila' ts'ilihuequi: ―Iya' camilhuo' al ƚinca: Cal xans ts'i'hueca acueca' tixim'ma ipime mitsufaiya pe locuxeyopa ȽanDios cal Cuecaj Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","’Ticuanni: “Cal camello, iƚque inneja juaiconapa acueca', jiƚquiya aimi'iya muyaicoya laquipihuo ƚacuxa”. Iya' camilhuo' ocuenaj cataiqui': Xonca ipime cal xans ts'i'hueca acueca' mitsufaiya pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Licuej'me iƚiya lataiqui' ts'ilihuequi Jesús juaiconapa ixpailij'mola'. Timiyoƚtsi, icuis'e'moltsi: ―¿Te caƚmicoponga' toƚta'a? Aicaƚcueca. ¿Te ailopa'a conƚuya? ");
INSERT INTO chdNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús ehuelojm'mola', timila': ―Lan xanuc' quiƚtuca' aimi'iya munƚu'eyacoƚtsi. ȽanDios ƚinca nipajnya tunƚu'e'mola'. Nipajnya ti'e'ma jahuay. ");
INSERT INTO chdNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro italai'e'e'ma, timi Jesús: ―¡Toxinƚa'! Illanc' aƚpo'nopá jahuay ƚaƚ'huexi, lihuejnahuo'. ¿Te calapi'inyaconga'? ");
INSERT INTO chdNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús timila': ―Iya' camilhuo' al ƚinca. Ticuaihuo litine jahuay tipaico'ma, ti'i'ma al ts'e. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cacutsai'ma laicuecaj asiento, cacuxena'ma to ȽanDios. Jiƚpe ti'i'mola' locuenaye limbamaj coque' lan cuecaj asiento. Jiƚpe toƚcutsoƚaita imanc' ts'alihuequi. Toƚspijta cataiqui', toƚcuxe'mola' loƚpimaye iƚne jouc'a liƚxanuc' limbamaj coquexi' linaxque' Israel. ");
INSERT INTO chdNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","’Cal xans ninespa: “Iya' quihuej'ma Jesús”, ja'ni ux'maspola' lejut'ƚ o lipimaye, o qui'ailli' o qui'máma', o linaxque' o ƚemats', iƚque cal xans tulij'ma xonca axpela' iƚna'a, jouc'a tulij'ma al ts'e lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","’Itsiya timana' lan xanuc' tocomma xonca lan tet'ƚa. Locuaicoya quitine axpela' iƚniya ti'i'mola' lijoucola'. Jouc'a itsiya timana' iƚne tocomma lijoucola'. Locuaicoya quitine axpela' iƚniya ti'i'mola' lan tet'ƚa. ");
INSERT INTO chdNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Toƚta'a micuxe ȽanDios, iƚque cal Cuecaj Rey Nopa'a lema'a. Iƚque li'ejma' ti'onƚcospa to li'ejma' anuli cal xans ehue'mola' no'eyacu canic'. Iƚque cal xans apoujna, tipa'a ƚemats', ifapa cal 'uva. Li'i'ma quitine ipanni, ixim'mola' lan xanuc' tehueyi quiƚpenic'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Imi'mola': “Ca'najtse'molhuo' to muliqui anuli litine cal xans no'epa canic'”. Umme'mola' ti'etsa canic' jiƚpiya pe lifayiya ƚi'uva. ");
INSERT INTO chdNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","’Joupa uyaipa ma to afanej 'hora ipaiconanni. Ixim'mola' ocuenaye tecaxoƚanna locucaleyompa. Tecaxoƚanna le'a, ailopa'a quiƚpenic'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Timila': “Imanc' jouc'a tonƚeƚe, tonƚ'etsa canic' jiƚpiya pe ƚaifapa ƚai'uva. Iya' ca'najtse'molhuo' to mi'najtsenni.” Iye'me. ");
INSERT INTO chdNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","’Al menac'o ipaiconanni ƚapoujna, jouc'a ipaiconanni mexaiƚma cal 'ora. Ixim'mola' no'eyacu canic', imipola' jouc'a: “Ca'najtse'molhuo' to mi'najtsenni”. ");
INSERT INTO chdNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","’Tehue'e anulij hora tif'acai'ma cal 'ora. Ipaiconanni. Ixim'mola' ocuenaye tecaxoƚanna. Icuis'e'mola', timila': “Imanc' tunlacaxoƚanna fa'a jahuay litine. ¿Ailopa'a coƚpenic'?” ");
INSERT INTO chdNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Italai'e'e'me, timiyi: “Nij naitsi naƚmiponga': Toƚ'eta canic'.” Ƚapoujna timila': “Jouc'a imanc' tonƚeƚe, tonƚ'etsa canic' jiƚpiya ƚifafiya ƚai'uva. Ca'najtse'molhuo' to mi'najtsenni.” ");
INSERT INTO chdNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Joupa if'acoƚaipa. Ƚapoujna camats' petsi ƚifayiya ƚi'uva, ijoc'i'ma nocuxepola' lam mozó, timi: “Tojoc'itsola' no'epá canic'. Aƚ'najtse'mola', lapi'i'mola' quiƚtomí. Lijoucola' aƚ'najtse'mola' ate'a, lan tet'ƚa aƚ'najtse'mola' tijouco'ma.” ");
INSERT INTO chdNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","’Icuaiyunca iƚne nitsuflaipá lanic' ma mehue'e anulij hora tif'acai'ma cal 'ora, i'epá canic' le'a anulij hora. I'najtse'mola', epi'i'mola' to lo'najtsempa no'epá canic' anuli litine. ");
INSERT INTO chdNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","’Lijou'ma icuaiyunca lan tet'ƚa. Iƚniya ticuayi: “Xonca aƚ'najtse'monga'”. I'najtse'mola' to lepi'ipola' lijoucola'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lepenuf'me liƚtomí aiquetenƚcoco'mola'. Timiyi ƚapoujna: ");
INSERT INTO chdNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Illanc' xonca lulijle. Aƚ'epá canic' jahuay litine. Aƚsnet'ƚpá ƚinu'. Iƚniya lijoucola' i'epá canic' ma le'a anulij hora, o'najtsepola' ma to lalulijpa illanc'.” ");
INSERT INTO chdNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ƚapoujna italai'e'e'ma anuli jiƚne lan tet'ƚa, timi: “Maipima, aicafel'mihuo'. Aimipo': To'huaƚa', to'etsi canic'. Ca'najtse'mo' to muliqui anuli litine cal xans no'epa canic'. Ima' aƚmipa: Ne', ai'huapa. Ca'eta canic'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tapenufla' lotomí, to'huanƚa' lomejut'ƚ. Joupa ai'epa iƚe laixpic'epa. Ai'najtsepa ƚijoujma ma to lai'najtsepo' ima'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Te iya' aimi'iya caxpic'eya te ts'i'ic' caxhuicoya laitomí? O, iƚe laif'epa al c'a, ¿te ima' aƚ'e'e laic'?” ");
INSERT INTO chdNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Toƚta'a lo'iya. Lijoucola' ti'i'mola' lan tet'ƚa, lan tet'ƚa ti'i'mola' lijoucola'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús tiyeyi lane jouc'a ts'ilihuequi, ticuaita al cuecaj quiƚya' Jerusalén. Miyeyi lane Jesús ileco'mola' limbamaj coquexi' ts'ilihuequi, ipalaic'o'mola' quiƚtuca', timila': ");
INSERT INTO chdNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Itsiya aƚf'ajlijyi liƚya' Jerusalén. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Jiƚpiya liƚya' Jerusalén aƚcunna. Iƚne lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, aƚ'eta to mixpic'e liƚpicuejma', aƚcuxecota aƚma'anƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aƚcunna, aƚtaluntseta, luntafquinna quixmi laixpula' iƚne lan xanuc' pe aimimetsaicoyi ȽanDios. Tijouƚa' lapaƚts'ijnta lancruz, aƚma'ata. Afane' quitine camaf'ina'ma, quipayonahuo pe lomana' lamizhua. ");
INSERT INTO chdNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Icuaitsi quiƚ'máma' Jacobo y Juan, iƚne inaxque' Zebedeo. Quiƚ'máma' ilecola' loquexi', exc'onƚingai'ma Jesús, tixa'hue'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús timi ƚaca'no': ―¿Te ts'opic'a? Ƚaca'no' timi: ―Aipic'a tapi'itsola' lainaxque' quiƚpenic'. Ima' tocuxe'ma to cal Cuecaj Rey. Ticuxeƚe jouc'a iƚna'a. Anuli ticutsai'ma al c'a camane, ƚocuena ticutsai'ma loxa camane. ");
INSERT INTO chdNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús ipalaic'o'mola' loquexi' lapimaye, timila': ―Imanc' aimoƚcuejyi te ts'i'ic' iƚe laƚsahue'epa. ¿Te nipajnya toƚteƚco'me ma to iya' cateƚco'ma? ¿Te nipajnya toƚsnet'ƚ'me lateƚcoya? Timiyi: ―Nipajnya. ");
INSERT INTO chdNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús timila': ―Ma to iya' laifteƚcoya, ma toƚta'a imanc' toƚteƚco'me. Iya' aimi'iya camiyacolhuo': “Aƚcutsingaiƚa', ima' al c'a camane, ƚopima loxa camane”. Aimi'iya caxpic'eya toƚta'a. Cai'Ailli' joupa ixpic'epa naitsi iƚne nocutsoƚaiyacu jiƚpe. Toƚta'a tepi'i'mola' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Locuenaye limbamaj ts'ilihuequi Jesús iƚsina' iƚe loxahue'epa Jacobo y Juan. Ixtuc'om'mola' iƚne loquexi' lapimaye. ");
INSERT INTO chdNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús ijoc'i'mola' jahuay iƚniya ts'ilihuequi, timila': ―Imanc' oƚsina' lo'ipa jiƚpiya petsi lan xanuc' aimimetsaicoyi ȽanDios. Liƚpincuxepá ti'e'eyoƚtsi to jipu'hua quiƚpoujnalá, lan tsila' quiƚpenic' ticuxenai'ennila' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Imanc', aimonƚ'e'me toƚta'a. Ja'ni anuli imanc' tixpic'e ti'e'exoxi cal cueca', iƚque titoc'itsola' lipimaye. ");
INSERT INTO chdNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ja'ni anuli imanc' tixpic'e ti'e'exoxi cal te'a, iƚque ti'e'exoxi to cal mozo. ");
INSERT INTO chdNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Imanc' tonƚ'eƚe to laif'epa. Iya' aicuaicoco'ma jifa'a li'a ƚamats' catoc'itsola' lan xanuc'. Aicainesqui: Aƚtoc'iƚa' iya'. Aicuaicoco'ma cacuƚa' laipitine, ca'najtseƚa' liƚjunac' axpela' lan xanuc', cunƚu'etsola'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús jouc'a ts'ilihuequi ipalunca jiƚpe liƚya' Jericó. Ihuej'me axpela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jiƚpe liju' cane ticutsoƚanna oquexi' lam fohue. Icuej'me tuyaipa Jesús. Ija'a'me, timiyi: ―¡Maƚ'ailli', ima' ƚacui'impo' i'Hua cal rey David, aƚsintsonga' ninc'icuanuc'la! ");
INSERT INTO chdNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lan xanuc' ixtulenca. Timinnila' lam fohue: ―¡Ti‑ch'ixcotsolhuo'! Iƚniya ti'hua tija'ayi, timiyi: ―¡Maƚ'ailli', ima' ƚacui'impo' i'Hua cal rey David, aƚtsintsonga' ninc'icuanuc'la! ");
INSERT INTO chdNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús ecaxhuenni, ijoc'i'mola' lam fohue, timila': ―¿Te ts'oƚpic'a? ¿Te caif'e'eyacolhuo'? ");
INSERT INTO chdNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Timiyi: ―Maƚ'ailli', ¡alaxi'enatsonga' laƚ'u'! ¡Alahuetsaleƚe! ");
INSERT INTO chdNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús ixim'mola' acuanuc'la juaiconapa. Iƚafc'e'mola' liƚ'u'. Aiquicoƚ'ma, ehuetsalena'me. Ihuej'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Icuaitsa liƚya' Betfage jiƚpiya ƚijuala cuftine Ƚijuala Olivo. Jerusalén ahuejnca. Jesús umme'mola' oquexi' ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Timila': ―Tonƚeƚe liƚya' lehuoc'ocojma. Toƚtsuflaitsa, toƚsinna tifijnya anuli ƚacaca'no' burro, jouc'a ƚi'hua tecaxijnya liju'. Toluhuaiƚta ƚaca'no' burro, aƚƚec'me'etsi jouc'a ƚi'hua. ");
INSERT INTO chdNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ja'ni tinanc'ontsolhuo', toƚtalai'eta, toƚmita: “Ƚiƚpoujna ipicuicoya. Tijouƚa' tixhuicotsi ticuai'enacola', aimicoƚya.” ");
INSERT INTO chdNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ti'iƚa' toƚta'a tenanƚ'ma locuapa cal profeta, iƚque luya'apa linespa ȽanDios, ticua: ");
INSERT INTO chdNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tomitsola' lan xanuc' nomana' liƚya' Sión: “¡Toƚsinƚe! Icuai'ma fa'a ƚoƚRey. Iƚque amanxu, enaf'caic' cal burro, i'hua ƚinneja ƚintaipa caitay.” ");
INSERT INTO chdNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iye'me ts'ilihuequi. I'e'me to lixc'ai'i'mola' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ilecotsa ƚaca'no' burro jouc'a ƚi'hua. Ixpef'i'me liƚpuquiya ƚaca'hua burro. Jesús enaf'cai'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Axpela' lan xanuc' ixpou'me lane liƚpuquiya. Ocuenaye etej'me limane' cal 'ec' ixpou'me lane jiƚpe pe loyaicoya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lanxpela' ts'iƚejme, jouc'a lanxpela' ts'iƚenc'e tija'ayi ma' anuli timiyi: ―¡Hosana! ¡ȽanDios tunƚu'enatso'! Ima' ƚacui'impo' i'Hua cal rey David. Joupa lu'iponga' tocuaihuo ima', aƚminga' ma ȽanDios ƚaƚPoujna tummeto'. Itsiya ocuai'ma. ¡Aƚs'najtsi'ihuo' juaiconapa! Iƚne nomana' lema'a xonca al toncay tinesle: ¡Hosana! ¡ȽanDios tunƚu'enatso'! ");
INSERT INTO chdNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús itsufai'ma Jerusalén. Jiƚpiya jahuay lan xanuc' tipailoyi, ticuitsufyi: ―¿Naitsi iƚca'a? ");
INSERT INTO chdNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Liƚejmale Jesús italai'enca, timinnila': ―Iƚca'a cal profeta Jesús, qui'huayomma liƚya' Nazaret, jiƚpe al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús itsufai'ma pe lopa'a al cuecaj xoute'. Ihuescuf'mola' jahuay iƚniya no'najualepá jouc'a nocucalepá nomana' jiƚpe. Ejualaif'e'e'mola' liƚmesa pe nopai'ipaj tomí, jouc'a liƚbanco nocujpá paloma. ");
INSERT INTO chdNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Timila': ―Al Paxi Liniƚingiya tuya'e': “Lainejut'ƚ tecui'im'me: Lajut'ƚ petsi lan xanuc' tipalaic'oyo'me ȽanDios”, itsiya imanc' toƚ'onƚicoyi iƚta'a lajut'ƚ to jipu'hua lafoƚyomma lan namats'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mipa'a Jesús jiƚpe pe lopa'a al cuecaj xoute' icuaitsa lam fohue, jouc'a lan coxo, ixaƚ'mena'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jiƚpe timana' la'uhuay tija'ayi, timiyi Jesús: “¡Hosana! ¡ȽanDios tunƚu'enatso'! Ima' ƚacui'impo' i'Hua cal rey David.” Lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios ixim'me acueca' lo'epa Jesús, iquimf'e'me la'uhuay noja'apá, ixtulenca. ");
INSERT INTO chdNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Itale'me Jesús, timiyi: ―¿Te ima' aimocueca locuapa jiƚnu'hua la'uhuay? Jesús italai'e'e'mola', timila': ―Cacueca. Imanc', ¿te aicoƚsuec' al Paxi Liniƚingiya loya'apa? Ticua: Iƚniya la'uhuay jouc'a lan tsocay notupá, ima' ManDios ocuxe'epola' tunac'cotso'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesús ipo'no'mola' quiƚtuca'. Ipanni jiƚpe liƚya'. I'hua'ma liƚya' Betania. Jiƚpe ipanenni lipuqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Liƚic'ejma ipaiconanni, i'huacona'ma Jerusalén. Mi'hua lane tunle'e. ");
INSERT INTO chdNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ixim'ma anuli al 'ec icux jiƚpe liju' cane. Iƚoc'huai'ma. Ixim'ma alilopa'a qui'as, pangay quipela. Timi al 'ec icux: ―Aimi'ascona'mo'. Aiquicoƚ'ma, al 'ec icux ijuƚna'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ts'ilihuequi Jesús lixim'me jiƚe al 'ec icux, timiyi: ―¡Xinƚa'! Jiƚiya al 'ec icux aiquicoƚi, joupa ijuƚnapa. ¿Te qui'ipa? ");
INSERT INTO chdNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús timila': ―Iya' camilhuo' al ƚinca: Imanc' ja'ni aimoƚnesyi: “¿Te ti'i'ma o aimi'iya?”, ja'ni toƚ'huaiyijnle ȽanDios, jouc'a nipajnya tonƚ'e'me to lai'e'epa al 'ec icux. Xonca al cueca' tonƚ'e'me. Ja'ni toƚmi'me iƚca'a ƚijuala: “To'huanƚa', to'nij'mixoxi ƚaja”, ma toƚta'a ti'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Moƚjoc'iyi ȽanDios ja'ni toƚ'huaiyijnle, jahuay loƚxahue'epa tepi'im'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús itsufaicona'ma pe lopa'a al cuecaj xoute'. Mimuc'ila' lan xanuc' icuaitsa lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui'. Icuis'e'me, timiyi: ―¿Naitsi nepi'ipo' lomane toƚta'a to'e'ma? ¿Naitsi nummepo'? ");
INSERT INTO chdNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús italai'e'e'mola', timila': ―Iya' jouc'a tipa'a laifnicuis'e'eyacolhuo'. Aƚtalai'eƚa', tijouƚa' cu'i'molhuo' naitsi nalapi'ipa laimane ca'eƚa' toƚta'a laif'epa. ");
INSERT INTO chdNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Naitsi nummepa Juan tepo'itsola' lan xanuc'? ¿Te ȽanDios o cal xans nummepa? Iƚne ipalaic'o'moƚtsi quiƚtuca', timiyoƚtsi: ―¿Te caƚmiyacu? Ja'ni aƚmiƚe: “ȽanDios ummepa”, iƚque alicuis'e'monga', aƚmi'monga': “Imanc' ¿te aicolapenufi?” ");
INSERT INTO chdNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ja'ni aƚmiƚe: “Cal xans nummepa”, tixtulecu lan xanuc'. Jahuay ticuayi Juan aprofeta, ȽanDios ummepa. ");
INSERT INTO chdNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Timiyi Jesús: ―Illanc' aicaƚsina'. Jesús timila': ―Iya' jouc'a aicu'iyacolhuo' naitsi nalapi'ipa laimane ca'eƚa' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","’Imanc' aƚquimf'eƚa' laifnu'iyacolhuo'. Tijouƚa' alu'iƚa' te coƚcuayacu. ’Anuli cal xans timana' oquexi' linaxque'. I'hua'ma pe lopa'a cal te'a qui'hua, timi: “Mai'hua, itsiya to'huaƚa' to'etsi canic' jiƚpe ƚainemats' pe ƚaifapa ƚai'uva”. ");
INSERT INTO chdNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“A'i, aica'huaya”, timi. Lijou'ma lixhuej'menni, i'hua'ma i'etsi canic'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","’Qui'ailli' i'hua'ma pe lopa'a ƚocuena qui'hua, ma' anuli lataiqui' imitsi. Iƚque italai'e'ma: “Ne', mai'ailli', ai'huapa”. Aiqui'huac'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","’Itsiya lu'iƚa', iƚne loquexi' linaxque' cal xans, ¿naitsi ni'e'ma licuxe'epola' quiƚ'ailli'? Italai'e'e'me, timiyi: ―Cal te'a. Jesús timila': ―Iya' camilhuo' al ƚinca. Itsiya timana' lan xanuc' jouc'a lacaƚ'no' tuliquilhuo' imanc'. Iƚniya lan xanuc' lin'najtsi'iyale jouc'a lacaƚ'no' notepá liƚcuerpo, maƚniya tihuejconayi ȽanDios, titsuflaiyi petsi locuxeyopa cal Cuecaj Rey Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","’Icuai'ma Juan Bautista imuc'i'molhuo' al c'a lane, aicolapenufi imanc'. Lin'najtsi'iyale jouc'a lacaƚ'no' notepá liƚcuerpo, iƚniya ƚinca epenufpá. Imanc' oƚsimpola' iƚnu'hua iƚsuej'menamma, aimoƚsuej'memma, aicolapenufi Juan. ");
INSERT INTO chdNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Aƚquimf'eƚa'. Ca'onƚicocona'ma lo'epa ȽanDios fa'a li'a lamats'. ’Anuli cal xans ƚipoujna camats', ifapa cal 'uva. Eti'icopa apic. Ipupa pe lotsuj'miyacu, loxoc'eyonyacu lan 'uva, tipa'a'me laquija'. Lijou'ma ilanc'e'ma anuli litoqui cajut'ƚ, jiƚpe tipajm'ma no'epa cuenna ƚamats'. Lijou'ma icu'ma ƚemats', epi'i'mola' lan xanuc' ti'eƚe canic'. Ƚaipammaiya tepi'im'me onƚca. Lijou'ma i'hua'ma aculi' camats'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Joupa tixpinaf'quiya litine timaj'ma lan 'uva. Ƚapoujna umme'mola' limozó pe lomana' no'epá canic', titaita ƚo'iya onƚca. ");
INSERT INTO chdNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Iƚniya no'epá canic' i'noƚ'e'e'me lummepola'. Untaf'me anuli, ocuena ima'a'me, ƚocuena ipa'me capic, ima'a'me. ");
INSERT INTO chdNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","’Lijou'ma ƚapoujna ummecona'mola' ocuenaye xonca axpela'. Iye'me pe lomana' no'epá canic', i'econa'me ma' anuli. ");
INSERT INTO chdNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Lijouco'ma umme'ma ƚi'hua. Ticua: “Iƚca'a ai'hua. Ƚinca tixpaic'eta.” ");
INSERT INTO chdNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","’No'epá canic' lixim'me icuaico'ma ƚi'hua ƚapoujna camats' timiyoƚtsi: “Iƚca'a tulij'ma jahuay ƚemats' qui'ailli', iƚque ƚapoujna camats'. ¡Ƚepá! ¡Aƚma'ata! Iƚque ƚamats' tipanenno, alulijna'me illanc'.” ");
INSERT INTO chdNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","I'noƚ'me, eca'ni'me lixpula' leti'icoya ƚamats' pe ƚifayiya 'uva, ima'a'me. ");
INSERT INTO chdNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Ticuaiyunni ƚipoujna camats' petsi ƚifayiya 'uva, ¿te co'e'eyacola' iƚne no'epá canic'? ");
INSERT INTO chdNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Timiyi: ―Tima'atola', tijou'netola' nulemma iƚniya lixcay xanuc'. Ƚemats' joupa ifayiya cal 'uva, tepi'i'mola' ocuenaye xanuc', tixhuico'me ƚamats', tepi'i'me ƚo'iya onƚca ƚaipammaiya. ");
INSERT INTO chdNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús timila': ―Imanc', ¿te aicoƚsuec' te loya'apa al Paxi Liniƚingiya? Iƚe tuya'e': Ƚapic ƚetets'ipa nolanc'epá lajut'ƚ joupa i'ipa xonca ƚaicuicoya. Iƚque ƚapic xonca tilanc'e ƚaitaƚ, aimecangeya lajut'ƚ. ȽanDios ƚaƚPoujna iƚta'a ƚecuej'micopa. Illanc' aƚsinyi acueca' iƚe li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Camilhuo': Ƚinca ȽanDios joupa epi'ipolhuo' loƚpenic', icuxe'epolhuo' toluya'aƚe: “Maƚque ȽanDios cal Cuecaj Rey ticuxela' lan xanuc'”. Itsiya texic'e'molhuo' iƚe loƚpenic'. Aimoƚtsuflaiyacu pe locuxeyopa ȽanDios, iƚque Nopa'a lema'a. Iƚe loƚpenic' tepi'i'mola' locuenaye. Iƚniya ƚinca tenant'ƚi'me iƚe lataiqui' locuxe'eyacola'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","’Cal xans ja'ni tixc'uaƚaf'caitsi, tecanaf'caitsi cal Cuecaj Capic, iƚque cal xans tixquelequehuo. Ja'ni Ƚapic tecangenni tetof'caitsi cal xans, iƚque cal xans tuxpats'i'ma nulemma. ");
INSERT INTO chdNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Toƚta'a i'onƚico'ma Jesús lo'epa ȽanDios. Licuej'me iƚiya litaiqui' lixanuc' cal cuecaj ca'ailli' jouc'a lan xanuc' fariseo i'i'ma quiƚsina' Jesús ma tinescola'. ");
INSERT INTO chdNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ehuepá te co'iya mi'noƚyacu. Aiquiƚ'noƚi. Tixpaic'ennila' lan xanuc', iƚne ticuayi: “Jesús aprofeta. ȽanDios ummepa”. ");
INSERT INTO chdNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ti'hua ti'onƚijma. Timila': ");
INSERT INTO chdNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―ȽanDios cal Cuecaj Rey Nopa'a lema'a, licuxejma ti'onƚcospa to li'ejma' anuli cal cuecaj quincuxepa nopa'a fa'a li'a ƚamats'. ’Litine lemane'ma ƚi'hua, ƚincuxepa icuxe'ma imac'ot'ƚem'me ƚotejacu al juic. ");
INSERT INTO chdNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Umme'mola' limozó iye'me tilecontsola' lijoc'ipola'. Iƚniya lijoc'ipola' aiquiƚcuac', aiquicuaiyunca al juic. ");
INSERT INTO chdNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","’Ummecona'mola' locuenaye limozó. Timila': “Tonƚeƚe, toƚƚecotsola' laijoc'ipola'. Tolu'itsola': Joupa ima'ampola' laihuacax jouc'a locuenaye linneja lifujmpola'. Aimac'epa ƚaƚtejacu. Ailopa'a cahue'epa. Tonƚouyunca al juic temane'ma ƚai'hua.” ");
INSERT INTO chdNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","’Iƚniya lijoc'ipola' aiquiƚcueca. Iyena'me ocuena cane. Anuli i'hua'ma ixintsi ƚemats'. Ƚocuena i'hua'ma petsi locucaleyopa. ");
INSERT INTO chdNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Locuenaye i'noƚ'e'e'me limozó ƚincuxepa, ixcai'em'mola', ima'am'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","’Ƚincuxepa ixtuc'o'mola'. Umme'mola' lisoldado tima'antsola' iƚne linma'ahuale, tipi'entsa liƚcuecaj quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Timila' limozó: “Joupa imacoƚpa ƚaƚtejacu lijuic ƚamaneya ƚai'hua. Laijoc'ipola' joupa imujpoƚtsi a'ijc'a xanuc'. Etets'ipá ƚaitejua'. Aiquiƚcuaiya. ");
INSERT INTO chdNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Itsiya tonƚeƚe lotalejmaleyopa ƚaneya. Jahuay lan xanuc' loƚsinyacola' toƚjoc'itsola', toƚmitsola': Ƚepá lejut'ƚ ƚincuxepa, ti'i juic, temane'ma ƚi'hua.” ");
INSERT INTO chdNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","’Lam mozó ipalunca ipa'netsa ƚaneya. Efot'ƚem'mola' iƚne lixinim'mola', ja'ni lan c'a xanuc', ja'ni lixcay xanuc', ma' anuli efot'ƚem'mola'. Lajut'ƚ imantsi xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Itsufai'ma ƚincuxepa tixinguftsola' iƚne notetsopá jiƚpiya. Ixim'ma anuli cal xans a'i quetejyoxi, aiquipo'nohuo al ts'e lipijahua' to liƚpo'nohuo iƚne nomana' jiƚpe al juic ƚamanepa. ");
INSERT INTO chdNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Icuis'e'ma, timi: “Maipima, aicopo'nohuo al ts'e lopijahua' to liƚpo'nohuo iƚne nomana' fa'a al juic. ¿Te qui'ipa lotsufaiyumma fa'a?” Cal xans aiquitalai'e. Ailopa'a quitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ƚincuxepa ijoc'i'mola' limozó no'huapá pime maƚpe al juic. Timila': “Iƚque cal xans toƚfi'eƚe limane li'mitsi'. Tolaca'nitsa jipu'hua al muf. Jiƚpe lan xanuc' tijolijta, ti'ilc'ta liƚ'ay.” ");
INSERT INTO chdNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’Ƚinca, axpela' lijoc'impola', ahuata li'huijf'empola'. ");
INSERT INTO chdNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iye'me lam fariseo. Ixpic'e'me te co'iya mi'noƚyacu Jesús. Timiyoƚtsi: ―Licuis'e'me, aƚtalai'e'monga', toƚta'a aƚcufta. ");
INSERT INTO chdNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ummem'mola' liyejmalepá. Jouc'a iye'me lixanuc' cal rey Herodes. Icuaitsa pe lopa'a Jesús, timiyi: ―Momxi, aƚsina' ima' tocua al ƚinca, a'i ma le'a metenƚcoyacola' lan xanuc'. Tomuc'iyale lipene ȽanDios. Ma' anuli topalaic'ola' jahuay. Aimahuelongila' ja'ni ts'iƚ'hueca o aiquiƚ'hueca. ");
INSERT INTO chdNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Itsiya lu'itsonga'. ¿Te cofcuapa? ¿Te aƚ'najtse'me cal cuecaj quincuxepa César? ¿Aƚcu'me al tomí laƚsahue'eponga'? o ¿aimaƚcuyacu? ¿Nipajnya o aimi'iya? ");
INSERT INTO chdNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús imetsaico'mola' ixcay liƚpicuejma', timila': ―¡Imanc' cunc'infel'miyale! ¿Te caƚmicuapa toƚta'a? Aixina' le'a lahuaijma. ");
INSERT INTO chdNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aƚmuc'iƚa' anuli al tomí loƚcuyacu. Imuc'i'me al tomí. ");
INSERT INTO chdNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Icuis'e'mola', timila': ―¿Naitsi iƚca'a ts'i'a? ¿Naitsi iƚta'a ts'ipuftine? ");
INSERT INTO chdNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Iƚniya italai'e'e'me, timiyi: ―Li'a César, lipuftine César. Timila': ―Ja'ni i'huexi César, tonlapi'iƚe César; ja'ni i'huexi ȽanDios, tonlapi'iƚe ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Licuej'me toƚta'a iƚniya icuapá: ―¡Xinƚa'! Iƚque Jesús acueca' lipicuejma'. Ipo'no'me quituca', iyena'me. ");
INSERT INTO chdNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Maƚe litine lan xanuc' saduceo icuaitsa pe lopa'a Jesús. Iƚniya lan xanuc' saduceo ticuayi: “Lan xanuc' timala' anulemma, aimimaf'iconayacu”. Iƚniya tehuaiyi Jesús, ticuis'eyi, ");
INSERT INTO chdNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","timiyi: ―Momxi, Moisés uya'apa: “Timaƚa' cal xans ja'ni ailopa'a qui'hua, ƚimanapa ƚipima tileco'ma ƚi'maxi. Tipajntsi cal te'a quiƚ'hua, iƚque tecui'i'me to lipuftyne ƚimapa. Ti'i'ma ma to qui'hua ƚimapa, ƚi'huexi ƚimapa tulij'ma.” ");
INSERT INTO chdNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","’Illanc' alimetsaicola' acaitsi lapimaye. Cal te'a emanepa, imapa, aiquixina' qui'hua. Ƚimapa ƚipima ileco'ma ƚi'maxi. ");
INSERT INTO chdNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ma to li'ipa cal te'a, ma toƚta'a li'ipa ƚipima, jouc'a toƚta'a li'ipa ƚocuena. Ma' anuli li'i'mola' lan caitsi. ");
INSERT INTO chdNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lijou'ma imana'ma ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","’Lan caitsi capimaye ilecopá anuli ƚaca'no'. Ticuaitsi litine timaf'iconƚe limanapola', ¿naitsi co'iya ƚipe'ailli' ƚaca'no'? ");
INSERT INTO chdNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús italai'e'e'mola', timila': ―Imanc' timenaquilhuo'. Aicoƚsina' loya'apa al Paxi Liniƚingiya, aicolimetsaijma al cueca' lo'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","’Jiƚpe litine timaf'inƚe limanapola', aimemalƚiyacu, ni lan xanuc' ni lacaƚ'no'. Ti'onƚcotola' to lapaluc' quema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Imanc' toƚcuayi aimimaf'iyacu limanapola'. ¿Te aicoƚsuec' lomipolhuo' ȽanDios jiƚpe Lipaxi Liniƚingiya? Jiƚpe tuya'e': ");
INSERT INTO chdNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Iya' NanDios, ilenDios Abraham, Isaac, Jacob”. Ja'ni anulemma imanapola' Abraham, Isaac, Jacob, ȽanDios aiminesya: “Iya' ilenDios iƚniya”. ȽanDios ilenDios ts'iƚmaf'i', a'i limanapola' nulemma. ");
INSERT INTO chdNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Licuej'me jiƚiya licua'ma Jesús, lan xanuc' ticuayi: ―¡Xinƚa'! Acueca' litaiqui' lomuc'iyalepa iƚque Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lan xanuc' fariseo icuej'me Jesús i‑ch'ixc'epola' lan xanuc' saduceo. Lijou'ma, lam fariseo efot'ƚe'moƚtsi, iye'me pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Anuli iƚniya, iƚque ƚomxi nomuc'iyalepa locuxepa ȽanDios, ehuai'ma Jesús, icuis'e'ma, timi: ");
INSERT INTO chdNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Momxi, jiƚpe litaiqui' locuxepa ȽanDios, ¿te t'ƚe cataiqui' xonca al cueca'? ");
INSERT INTO chdNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús italai'e'e'ma, timi: ―“To'nujuaisla' ȽanDios ƚoPoujna, iƚque omenDios. Taihuejla' jahuay ƚomunxajma', jahuay ƚo'alma, jahuay lopicuejma'.” ");
INSERT INTO chdNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Toƚta'a loya'apa al te'a litaiqui', iƚiya xonca al cueca' cataiqui' locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Locuena lataiqui' lihuequi ma' anuli ti'onƚspa, ticua: “Ima' to'eyoxi capic'a. Ma toƚta'a to'eƚa' capic'a ƚof'as xans, naitsi ƚoftalecufya.” ");
INSERT INTO chdNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ja'ni tolihuejcoyi jiƚta'a loque' ƚataiquí, ƚinca tolanant'ƚiyi jahuay locuxepa ȽanDios, jahuay linespa lam profeta. ");
INSERT INTO chdNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mefot'ƚeyoƚtsi jiƚpe lan xanuc' fariseo, ");
INSERT INTO chdNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús icuis'e'mola', timila': ―Imanc', ¿te coƚcuapa? Cal Cristo, ¿naitsi ƚitatahuelo? Iƚniya italai'e'e'me, timiyi: ―David itatahuelo cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús timila': ―Maƚque David inescopa cal Cristo, ticua “… ƚaiPoujna”. Ja'ni David itatahuelo cal Cristo, ¿te quinescopa toƚta'a? Cal Espíritu Santo icuxe'epa toƚta'a licuapa, luya'apa, ticua: ");
INSERT INTO chdNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ȽanDios tipalaic'o ƚaiPoujna, timi: “Tocutsaiƚa' jifa'a al c'a camane. Topanehuo jifa'a, iya' mi'hua culiquila' lo'epo' laic'. Tijouƚa', ima' tocuxena'mola'.” ");
INSERT INTO chdNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ja'ni David itatahuelo cal Cristo, ¿te quinescopa, ticua “… ƚaiPoujna”? ");
INSERT INTO chdNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ailopa'a cotalai'ecoyacu, ni anuli lataiqui'. Lipangopa jiƚe litine aimicuis'mot'ƚeconayacu. Iƚsina' tulijna'mola' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús ipalaic'o'mola' lan xanuc' jouc'a ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Timila': ―Lomxiye nomuc'iyalepá locuxepa ȽanDios, jouc'a lan xanuc' fariseo, tipa'a liƚmane timuc'iyale'me licuxepa Moisés. ");
INSERT INTO chdNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Imanc' tolihuejcoƚe jahuay locuxe'epolhuo'. Liƚ'ejma' iƚniya aimolihuej'me. Iƚniya ma le'a tinesyi, aimi'eyi. ");
INSERT INTO chdNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","’Tetonc'iyi lataiqui' locuxepa ȽanDios. Ticuxennila' lan xanuc' tenant'ƚiƚe jahuay iƚta'a liƚtaiqui'. Lan xanuc' tixinyi ipime jiƚiya liƚtaiqui'. Ti'onƚcospa to cal cumta caitay lipo'no'impola' liƚspula'. Afule mixnet'ƚyi. Maƚniya lomxiye jouc'a lan xanuc' fariseo aimenant'ƚiyi lataiqui' locuxepa tenant'ƚiƚe liƚf'as xanuc'. Tixinyoƚtsi to ailopa'a nocuxeyacola'. Ticuxeyoƚtsi quiƚtuca'. ");
INSERT INTO chdNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","’Jahuay lo'epa iƚniya ti'eyi ma le'a tehuelojnle lan xanuc', tixinintsola' lan c'a xanuc'. Iƚpic'a tixinintsola' menant'ƚiyi locuxepa ȽanDios. Iƚniya lomxiye jouc'a lam fariseo tilanc'eyi xonca lexpats'qui iƚe laca'hua caxax lofi'ecopa liƚmane o ƚilepali. Jiƚpe lacaxax ti'nico hualca al Paxi Liniƚingiya. Ti'e'eyi itoqui ƚocuits' ƚema liƚpijahua'. Ticuayi liƚpicuejma': “Lan xanuc' aƚsintsonga' ninc'itsila' comxiye”. ");
INSERT INTO chdNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","’Mixmucota ticutsoƚaita jiƚpe petsi locutsoƚaiyacu lan tsilaj xanuc'. Toƚta'a iƚpic'a. Ƚajut'ƚi pe lafoƚyomma lan xanuc', iƚne ticutsoƚaita lan tet'ƚa asiento. ");
INSERT INTO chdNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Miyelocoyi locucaleyompa iƚpic'a lan xanuc' tinonintsola', timintsola': “¡Rabí, Rabí!” (Iƚe lataiqui' lohuaƚcuf'ipa ticua: Nomuc'iyalepa.) ");
INSERT INTO chdNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Imanc' aimecui'im'molhuo' “Rabí.” Tipa'a ma le'a anuli Nomuc'ipolhuo', imanc' unc'apimaye. ");
INSERT INTO chdNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Fa'a li'a ƚamats', ja'ni anuli cal xans a'i coƚ'ailli', aimoƚmi'me “Mai'ailli'”. Tipa'a ma le'a anuli coƚ'Ailli', iƚque Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aimecui'im'molhuo' imanc' “Momxi”. Imanc' a'i cunc'omxiye. Ma le'a iya' ƚoƚpomxi, iya' ninCristo. ");
INSERT INTO chdNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Imanc', naitsi xonca cal cueca' ti'iƚa' to cal mozo, titoc'itsola' lipimaye. ");
INSERT INTO chdNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cal xans no'e'epoxi acueca', iƚquiya ti'oc'em'me. Naitsi no'e'epoxi aca'hua, ti'e'em'me xonca acueca'. ");
INSERT INTO chdNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’A'ijc'a lo'iyacolhuo' cunc'omxiye, imanc' noƚmuc'iyalepá locuxepa ȽanDios, jouc'a imanc' cunc'ixanuc' fariseo. Le'a toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. Miquimf'ennilhuo' loƚmuc'iyalepa, lan xanuc' tixinyi to joupa eti'iya al puerta. Tixinyi aimi'iya mitsuflaiyacu jiƚpe pe locuxeyopa ȽanDios cal Cuecaj Rey Nopa'a lema'a. Ƚinca imanc' aimoƚtsuflaiyi, jouc'a aimolapi'ila' lane lan xanuc'. Iƚne ts'iƚpic'a titsuflaiƚe, imanc' toƚpa'nela'. ");
INSERT INTO chdNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’A'ijc'a lo'iyacolhuo' imanc' cunc'omxiye noƚmuc'iyalepá locuxepa ȽanDios, jouc'a imanc' unc'ixanuc' fariseo. Le'a toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. Imanc' tolaxic'ela' ƚiƚ'huexi lam potsateya cacaƚ'no'. Moƚ'eyi toƚta'a ticoƚilhuo' moƚpalaic'oyi ȽanDios. Toƚcuayi: “Aƚsinintsonga' illanc' lihuejcoyi ȽanDios”. Imanc' xonca acueca' loteƚminyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’A'ijc'a lo'iyacolhuo' imanc' cunc'omxiye noƚmuc'iyalepá locuxepa ȽanDios, jouc'a imanc' cunc'ixanuc' fariseo. Le'a toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. Imanc' tolahuela' lan xanuc' tihuequintsolhuo'. Tonƚeyi ni petsi li'a ƚamats', toƚqueyi ƚaja. Toƚsintsa ma le'a anuli cal xans naihuejyacolhuo' tolixoc'i'moƚtsi conlata. Tijouƚa' iƚque tulij'molhuo'. Imanc' loƚpicuicoya tonƚe'me pu'hua al cuecaj capa. Iƚque xonca lipicuicoya ti'huaƚa' pu'hua. ");
INSERT INTO chdNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’A'ijc'a lo'iyacolhuo' imanc' unc'ifohue. Imanc' aimi'iya moƚmuc'iyacola' lan xanuc' al c'a cane. Imanc' toƚcuayi: “Cal xans nocuaj'mipa al cuecaj xoute' ja'ni aimenant'ƚi litaiqui' ailopa'a tintsi. Ƚocuenaj cal xans nocuaj'mipa al oro lopa'a jiƚpe al cuecaj xoute', ƚinca tenant'ƚiƚa' litaiqui', ja'ni a'i titai'ma lijunac'.” ");
INSERT INTO chdNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","’¡Imanc' unc'ifohue! Tocomma ailopa'a coƚpicuejma'. ¿Te jale xonca al cueca', ja'ni al oro o al cuecaj xoute'? Aƚinca xonca acueca' al xoute'. Iƚe al oro ja'ni ailopa'a jiƚpe al cuecaj xoute' aimi'iya qui'huexi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jouc'a toƚcuayi: “Cal xans nocuaj'mipa cal altar, ja'ni aimenant'ƚi litaiqui' ailopa'a tintsi. Ƚocuena cal xans nocuaj'mipa lotsufcompa jiƚpe cal altar, ƚinca tenant'ƚiƚa' litaiqui', ja'ni a'i titai'ma lijunac'.” ");
INSERT INTO chdNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Imanc' unc'ifohue! ¿Te jale xonca al cueca', lotsufcompa o cal altar? Ƚinca xonca acueca' cal altar. Ja'ni lotsufcompa ailopa'a jiƚpe cal altar aimi'iya qui'huexi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Cal xans nocuaj'mipa cal altar jouc'a tipalaijma jahuay lopa'a jiƚpiya cal altar. ");
INSERT INTO chdNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ja'ni icuaj'mipa al cuecaj xoute', jouc'a tipalaijma ȽanDios iƚque Nopa'a jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ja'ni nocuaj'mipa lema'a tipalaijma lema'a pe locutsaf'ya ȽanDios jouc'a tipalaijma ȽanDios iƚque Nocutsaf'ya jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’A'ijc'a lo'iyacolhuo' imanc' cunc'omxiye noƚmuc'iyalepá locuxepa ȽanDios jouc'a imanc' cunc'ixanuc' fariseo. Ma le'a tonƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. Imanc' jahuay ts'oƚ'hueca tipa'a loƚtsufcoyacu ȽanDios. Ja'ni ti'iƚa' amaxnu, toƚtsufcoyi imbama', ja'ni ti'iƚa' imbama' toƚtsufcoyi anuli. Toƚta'a monƚ'eyi, tama ƚaiquitamqui xonca atsocay, ja'ni al xaimu, ja'ni al anís, ja'ni al comino, toƚtsufcoyi anuli ȽanDios. Lataiqui' locuxepa ȽanDios ticuxe'elhuo' tonƚ'eƚe al c'a xonca al cueca'. Ticuxe'elhuo' tonƚ'eƚe al ƚijca, toƚsintsola' cuanuc'la loƚpimaye, tonlanant'ƚiƚe loƚnesyacu. Iƚe lataiqui' aimonlihuejyi. Ƚinca ac'a lonƚ'epa moƚtsufcoyi ƚaiquitamqui. Ticuicomma tolanant'ƚiƚe jahuay locuxe'epolhuo' ȽanDios, tonƚ'eƚe al c'a xonca. ");
INSERT INTO chdNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imanc' aimi'iya moƚmuc'iyacola' lan xanuc' al c'a cane. ¡Unc'ifohue! Tipa'a lataiqui' loya'apa: “Toƚtsaic'oyi al vino aimoƚnuc'me calxc'huiƚ. Tijouƚa' aimoƚsinyi cal cuecaj quinneja, iƚque cal camello, toƚnuc'yi.” Toƚta'a ma ti'onƚcospolhuo' to loƚ'ejma' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’A'ijc'a lo'iyacolhuo' imanc' cunc'omxiye noƚmuc'iyalepá locuxepa ȽanDios, jouc'a imanc' cunc'ixanuc' fariseo. Ma le'a toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. A'ijc'a loƚpicuejma'. Ti'hua toƚjanajyi tepi'intsolhuo' xonca. Tonlaxic'ela' liƚtomí loƚf'as xanuc', toƚta'a toƚma'neyi loƚtaza, loƚpime. Tijouƚa', ma to moƚ'eyi, tolapajyi liƚspula' loƚtaza, loƚpime. ");
INSERT INTO chdNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ima' umfo' fariseo, ate'a taipa'aƚa' al xujc'a lopa'a jiƚpe licu'u lotaza, lopime. Tijouƚa' liƚspula' ti'i'ma limpio jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’A'ijc'a lo'iyacolhuo' imanc' cunc'omxiye noƚmuc'iyalepá locuxepa ȽanDios, jouc'a imanc' cunc'ixanuc' fariseo. Le'a toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. Ti'onƚcospolhuo' to cal puƚ'hua li'e'empa afujca juaiconapa. Licu'u al pu'hua imanna quecala camizhua, imanna axisca. ");
INSERT INTO chdNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ma' anuli imanc'. Tocomma to tolihuejcoyi locuxepa ȽanDios. A'ij ƚinca. Ma le'a ixcay loƚpicuejma'. Jiƚpe toƚspic'eyi toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc', aimolihuejcoyi locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’A'ijc'a lo'iyacolhuo' imanc' cunc'omxiye noƚmuc'iyalepá locuxepa ȽanDios jouc'a imanc' cunc'ixanuc' fariseo. Le'a toƚ'e'eyoƚtsi, imanc' a'i cunc'ic'a xanuc'. Imanc' toƚƚanc'e'ela' liƚpu'hua limanapola' iƚne lam profeta jouc'a lan xanuc' naihuejcopá locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Imanc' toƚcuayi: “Laƚtatahueló ima'a'me lam profeta. Ja'ni coƚa' illanc' aƚmana' jiƚpe litine, aimaƚ'eyacu toƚta'a.” ");
INSERT INTO chdNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Moƚnesyi “Laƚtatahueló…”, le'a toƚcufyoƚtsi, tonlimetsaicoyoƚtsi imanc' iƚnaxque' iƚniya nima'a'me iƚne lam profeta. ");
INSERT INTO chdNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ne'. ¡Ti'hua monƚ'eyi jiƚiya lixcay to li'epá loƚtatahueló! ¡Toƚjou'neƚe nulemma! ");
INSERT INTO chdNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Imanc' ti'onƚcospolhuo' to lacaƚpo'. Imanc' loƚpicuejma' ti'onƚcospa to lipicuejma' ƚainofaƚ. Ƚinca tejac'ennolhuo', tecajm'minnolhuo' ƚunga ƚopa'a al muf. O ¿te ti'i'ma tolunƚulta? A'i. Aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cumme'elhuo' lam profeta, iƚne noya'apá loxpic'epa ȽanDios. Cumme'elhuo' lan xanuc' acueca' liƚpicuejma'. Cumme'elhuo' lomxiye. Imanc' toƚma'a'mola' hualca iƚniya lan xanuc', tolapaƚts'ijm'mola' lancruz. Locuenaye toƚƚeco'mola' ƚajut'ƚi pe lafoƚyomma lan xanuc', jiƚpe toluntaf'e'e'mola'. Tolihuejtso'mola' iƚya' iƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Toƚta'a imanc' toƚtai'me liƚjunac' iƚne loƚxanuc' nima'a'me naihuejcopá locuxepa ȽanDios. Cal te'a ƚima'ampa iƚque cal c'a xans Abel, ƚijoujma Zacarías ƚi'hua Berequías, ƚima'ayompa jiƚpe al cuecaj xoute' lixpula' cal altar, jiƚpe lotsuflaiyacu al Paxi Lugar. ");
INSERT INTO chdNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iya' camilhuo' al ƚinca: Jahuay iƚe lajunac' toƚtai'me imanc' noƚmana' fa'a itsiya litine. ");
INSERT INTO chdNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Miƚya' Jerusalén! ¡Miƚya' Jerusalén! Loxanuc' inma'ahuale, ima'a'me lam profeta, tipannila' capic', tima'ayi lixanuc' ȽanDios, iƚniya lummepola' jiƚpiya. Iya' axpe' canesqui: Cafot'ƚe'mola' jahuay loxanuc' ma to mi'ay cal tsana mefot'ƚe'mola' laiquipuyu, mipuxc'i'mola' lixaƚ. Ima' aicocuac'. ");
INSERT INTO chdNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Miƚya', ¡tahuelojnla' locuecaj xoute'! ȽanDios ipo'nopa quituca'. Tocomma joupa eteƚquemma. ");
INSERT INTO chdNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iya' camilhuo' lo'iya. Ticuaitsi litine aƚmiƚa': “Ima' unC'a. ȽanDios ƚaƚPoujna ƚinca ummepo'”, iƚe litine aƚsingona'ma. Ai'a ticuaita iƚe litine aimaƚsingonaya. ");
INSERT INTO chdNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús ipayonni jiƚpe al cuecaj xoute', icuaitsa ts'ilihuequi. Iƚniya ts'ilihuequi ipalaico'me ƚajut'ƚi al cuecaj xoute'. Timiyi: ―Toxintsola' ilangila' juaiconapa iƚna'a ƚajut'ƚi. ");
INSERT INTO chdNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús italai'e'mola', timila': ―Itsiya tolahuelojnyi ƚajut'ƚi iƚniya ilangila'. Iya' camilhuo' al ƚinca: Ticuaihuo litine jahuay teteƚquehuo. Ni anuli ƚapic mi'nif'queya ƚipima capic. ");
INSERT INTO chdNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Micutsuya Jesús ƚijuala Olivo, icuaitsa quiƚtuca' ts'ilihuequi, icuis'e'me, timiyi: ―Lu'itsonga', ¿tej hora mi'iya toƚta'a? ¿Te co'iya maƚsinyacu ja'ni ima' tocuaiconahuo? ¿Te co'iya maƚsinyacu ja'ni tijou'ma li'a ƚamats'? ");
INSERT INTO chdNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús italai'e'mola', timila': ―Toƚpo'noƚe cuenna. Ja'ni aimoƚpo'noyi cuenna tifel'mim'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ticuaicu axpela' linfel'miyale. Anuli anuli tines'ma: “Iya' ƚinca cunƚu'e'molhuo'. Iya' ninCristo. ȽanDios alummepa.” Iƚniya tifel'miyale'me axpela'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Litine toƚcuejle: “Pu'hua tifulenni”, o “Ƚu'hua tifulem'me”, aimixpailij'molhuo'. Toƚta'a lo'iya. Ticoƚ'ma locuaicoya Lijoujma Quitine. ");
INSERT INTO chdNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lan xanuc' anulij nación tixtuc'om'moƚtsi locuenaj nación, tifule'me. Lan tsilaj quincuxepá tixtuc'om'moltsi, tifule'me. Ni petsi tixim'me cumemma, tinu'ma ƚunanto. ");
INSERT INTO chdNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iƚe lateƚcoya ti'onƚcota to ƚaca'no' ƚinnay ƚipumla. Tumlej'ma ate'a, tijouƚa' tipajnta cal ts'e qui'hua. Fa'a li'a ƚamats' ate'a tipango'ma lateƚcoya, tijouƚa' ti'i'ma al ts'e lema'a, ti'i'ma al ts'e li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Imanc', ticum'molhuo', ticuaita quiƚmane lan xanuc', iƚne titeƚmi'molhuo', tima'a'molhuo'. Imanc' ts'alihuequi, toƚiya ni petsi loƚmanc'eyacu fa'a li'a ƚamats' lan xanuc' tixtuc'o'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Axpela' ts'alihuequi tipai'i'me liƚpicuejma', ti'e'moƚtsi laic' liƚpimaye ts'alihuequi. Ticuf'me. ");
INSERT INTO chdNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ticuaicu axpela' lam profeta nofelƚaiqueyacu, tifel'miyale'me axpela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lan xanuc' xonca tenaj'moƚtsi, aimihuej'me lataiqui' locuxepa ȽanDios. Ti'e'me ma le'a lixcay. Aimipalaic'oyacoƚtsi to li'ipa, aimi'eyoƚtsi capic'a. ");
INSERT INTO chdNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Cal xans ja'ni tixnet'ƚƚa' lateƚcoya, ja'ni ti'hua tihuejla', iƚque ƚinca tunƚu'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jahuay li'a ƚamats' tuya'ata lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Ni petsi lomana' lan xanuc' tuya'ata te co'iya mitsuflaiyacu pe lopa'a ȽanDios, iƚque cal Cuecaj Rey Nopa'a lema'a. Tijouƚa' ticuaihuo Lijoujma Quitine. ");
INSERT INTO chdNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ma to luya'apa cal profeta Daniel luyaipa quitine toƚta'a toƚsim'me lo'iya. Iƚe pe ȽanDios tilaiqui topo'nom'me al cuecaj xoute'. Tijouƚa' ȽanDios tipo'no'ma quituca' iƚe al cuecaj xoute'. Naitsi noxhuef'iyacola' lipimaye jiƚta'a lataiqui' ticuec'eƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","’Iƚniya ƚitiné ja'ni toƚmana' al distrito Judea tolinul―le, toƚf'ajliƚe ƚijualay. ");
INSERT INTO chdNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ja'ni cof'nif'ya al toncay lomejut'ƚ, aimicoƚ'mo'. Aimaipa'a'ma iƚe lopa'a lomejut'ƚ, le'a taimunni, tainuƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ja'ni to'ay canic' jiƚpe ƚimuc'o', aimopaiconahuo mommaiya lopuquiya, ma tainuƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","’Iƚniya ƚitiné juaiconapa titeƚco'me linnaila cacaƚ'no', jouc'a lacaƚ'no' notu'ipá liƚnaxque'. Iƚniya afule minulyacu. ");
INSERT INTO chdNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Toƚsahue'eƚe ȽanDios ticuaitsi lateƚcoya aimi'i'ma ƚitiné caxita, ni litine conxajya. Jiƚpiya aimi'iya molinulyacu. ");
INSERT INTO chdNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lan xanuc' nomana' fa'a li'a ƚamats' aiquiƚsingufma lateƚcoya to loxinyacu jiƚpiya litine. Tijouƚa' jiƚta'a lateƚcoya aimixinconayacu lateƚcoya to jiƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ȽanDios tixinnila' cuanuc'la lixanuc', jiƚne li'huijf'epola', toƚiya ixpic'epa aimicoƚya jiƚe lateƚcoya, tetec'oyehuo. Ja'ni coƚa' ticoƚ'ma iƚe lateƚcoya, ailopa'a conƚuya, coƚa' jahuay tima'mola'. Aimicoƚya lateƚcoya. ");
INSERT INTO chdNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Iƚniya ƚitiné ja'ni timintsolhuo': “¡Toƚsinƚe! Jifa'a icuai'ma cal Cristo”, o “Jiƚpe icuaita”, aimolapenuf'me iƚiya lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ticuaicu linfel'miyale. Tecui'i'moƚtsi: “Iya' ninCristo”, o “Iya' ninprofeta, cuya'e' lixpic'epa ȽanDios”. Iƚniya ti'e'me al cueca', axpe' timuj'me. Tines'me: “Lan xanuc' limetsaicotsonga' ȽanDios lummeponga'”. Ma le'a tifel'miyaleyi. Coƚa' tifel'mintsola' jouc'a li'huijf'epola' ȽanDios. Aimi'iya mifel'minyacola'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","’Joupa aimipolhuo' iƚe lo'iya. Aimolimenc'eco'me iƚe laimipolhuo'. Ma to lo'iya, toƚta'a nu'ipolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ja'ni timintsolhuo': “Icuaita cal Cristo pu'hua. Tipa'a petsi ailopa'a quiƚya'”, aimonƚe'me pu'hua. O ja'ni ticuanni: “Icuai'ma fa'a, itsufaipa lajut'ƚ”, imanc' aimolihuejco'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","’Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cacuaiyoconanni jahuay aƚsim'ma ma to moƚsinyi lixcuaflay mixcuaf'ma jiƚpiya liyuf'maj 'ora. Lixcuaflay tepalc'o'i a'i ma le'a jiƚpe liyuf'maj 'ora. Lepalc'o' ticuaita pe lof'acaiyopa cal 'ora. ");
INSERT INTO chdNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pe lopa'a ƚimac' jiƚpiya tefot'ƚe'moƚtsi lapote. ");
INSERT INTO chdNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Tuyaiƚa' iƚniya ƚitiné lateƚcoya: Timufco'ma cal 'ora, cal mut'ƚa aimepalc'o'iya, lan xamna nomana' lema'a tecangoƚecu ƚamats', jahuay lopa'a jiƚpe lema'a tife'nem'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iya' iƚque Cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iƚe litine jipu'hua lema'a lan xanuc' tixim'me iƚe lomuc'iyacola' joupa aicuaicocona'ma. Ni petsi li'a ƚamats' lan xanuc' tijolij'me, aƚsim'ma cacuaiconno cacutsafya ƚummahuay quimumma. Aƚsim'ma iya' ninCuecaj Rey, aƚ'onƚcospa to ȽanDios. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iƚe litine tifus'mi'me al cuecaj trompeta, iya' cumme'mola' lainepaluc' tiyeƚe tefot'ƚentsola' laixanuc' lai'huijf'epola'. Ni petsi lomana' tileconnola': Iƚniya nomana' layuf'maj 'ora, iƚniya nomana' lof'acaiyopa cal 'ora, iƚniya nomana' pe lo'huayomma ƚahua', iƚniya nomana' pe lotsepa ƚahua', ni petsi canumicay li'a ƚamats' tileconnola' laixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","33","’Ja'ni toƚpo'noƚe cuenna iƚe lo'ipa al 'icux ti'i'ma coƚsina' icuaico'ma ƚinu'. Toƚta'a timuc'i'molhuo' al 'icux tuxcuaf'eƚa' limane', tilaƚa' laxhuaica lipela. Ma' anuli ja'ni toƚpo'noƚe cuenna iƚe lo'iya fa'a li'a ƚamats' ti'i'ma coƚsina' joupa cacuaiconno. Ti'iƚa' ma to laimipolhuo', joupa aicuai'ma al puerta. ");
INSERT INTO chdNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iya' camilhuo' al ƚinca: Litine ti'iƚa' to laimipolhuo', lan xanuc' nomajnyacu fa'a li'a ƚamats' ti'i'ma liƚ'ejma' to liƚ'ejma' lan xanuc' nomana' fa'a itsiya litine. ");
INSERT INTO chdNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lema'a y li'a ƚamats' tipaico'mola'. Laitaiqui' aimipaiya, tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Nij naitsi ts'ixina' litine ni al 'hora cacuaicoconanni li'a ƚamats'. Jouc'a lapaluc' quema'a aiquiƚsina'. Jouc'a iya' i'Hua ȽanDios, aicaixina'. Ma le'a cai'Ailli', iƚque ƚinca ixina'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ma to li'ipa luyaipa quitine mipa'a Noé fa'a li'a ƚamats', toƚta'a lo'iya litine cacuaicohuananni li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Milanc'e Noé al arca, lan xanuc' tuyalaicoyi liƚpepajnya ma to mi'eyi. Titetsoyi, tixnayi, temalƚiyi, ticuyi liƚnaxque' temalƚiƚe. Litine Noé litsufai'ma al barco toƚta'a ti'eyi. ");
INSERT INTO chdNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Iƚne aiquiƚsina' lo'iyacola', ticui'ma. Ma' icui'ma ƚaxpaiqui' cacui. Ƚacui ileco'mola', ima'a'mola'. ’Iƚe li'ipa ti'onƚcospa to lo'iya cacuaiconanni iya'. Lan xanuc' aimi'iya quiƚsina' lo'iyacola'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Oquexi' lan xanuc' timajm'me ƚimuc'o'. Anuli tilecom'me, ƚocuena tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Oquexi' lacaƚ'no' tutsi'me anuli. Anuli tilecom'me, ƚocuena tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Imanc' toƚ'huaicoƚe, toƚpo'noƚe cuenna. Aicoƚsina' te quitine ticuaihuo ƚoƚPoujna. ");
INSERT INTO chdNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ƚipoujna cajut'ƚ ja'ni ixina' tej hora ticuaihuo cal namas, iƚque ƚapoujna aimixmaiya, tipo'no'ma cuenna, ticuanajco'ma lejut'ƚ, cal namas aimi'iya mitsufaiya. ");
INSERT INTO chdNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Imanc' toƚpo'noƚe cuenna. Ticuaitsi al 'hora aimoƚ'huaicoyi, toƚnesyi: “Aimicuaiya”, maƚpe al 'hora cacuaihuo. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Ƚapoujna ti'huaƚa' aculi', tepi'i'ma quipenic' ƚimozo. ¿Te co'eya iƚque cal mozo? Ja'ni cal c'a mozo, ja'ni tipa'a lipicuejma', tenant'ƚi'ma lipenic', iƚe lipo'no'ipa ƚipoujna. Ti'e'mola' cuenna locuenaye lam mozó nomana' jiƚpe lajut'ƚ. Ti'huajcoƚa' al 'hora, tites'mi'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ticuainatsi ƚipoujna, tixim'ma ƚimozo ti'ay to licuxe'epa. Iƚque cal mozo loyaicoya al c'a. ");
INSERT INTO chdNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Camilhuo' al ƚinca: Ƚipoujna tepi'i'ma xonca al cueca' lanic'. Tepi'i'ma quimane ticuxeƚa' jahuay ƚi'huexi. ");
INSERT INTO chdNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ja'ni ixcay xans, cal mozo timi'moxi: “Ƚaipoujna ticoƚi, aimicuaiya”. ");
INSERT INTO chdNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tipango'ma tifule'ma, tuntaf'mola' lif'as mozó. Titetsoyi, tixnayi anuli lif'as quisnaye. ¿Te co'iya iƚque cal mozo? ");
INSERT INTO chdNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Anuli litine, jiƚpe litine aimi'huaijma ƚipoujna, jiƚe al 'hora aimixhueƚma, ticuainahuo ƚipoujna. ");
INSERT INTO chdNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tetetsuf'ma, tecajm'mita pe lomana' linfel'miyale, jiƚpe tijolijta, ti'iƚc'ta liƚ'ay. ");
INSERT INTO chdNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Licuaitsi litine ticuaihuo cal Cuecaj Rey Nopa'a lema'a, tepenuftsola' lixanuc', iƚne naihuejcopá, ti'i'ma to li'ipa litine lipalunca imbama' lahuats'la. Iƚe litine titalecufta, tecanna ƚamaneya, ticuai'ecu jiƚpiya lo'iyoya lijuic lamaneyoya. Anuli anuli iƚtaic' liƚpepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Amajxi lahuats'la ts'iƚpicuejma', locuenaye amajxi lahuats'la ailopa'a quiƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lamac'ta lahuats'la, litai'me liƚpepalc'o' aiquiƚtaic' quileceite timanumf'eta liƚpepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lahuats'la ts'iƚpicuejma' itai'me liƚpepalc'o' jouc'a iƚtaic' lileceite. ");
INSERT INTO chdNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ticoƚi ƚamaneya, aiquicuaiyunni. Jahuay lahuats'la icuinni quilehui, ixmai'me. ");
INSERT INTO chdNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Nolojmay quipuqui' icuej'me tija'anni, ticuayi: “Icuaico'ma fa'a ƚamaneya. Tunƚouyunca, aƚtalecufta.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jahuay lahuats'la imaf'i'me. Etuf'me liƚpepalc'o', inai'i'me. ");
INSERT INTO chdNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Lamac'ta lahuats'la ipalaic'om'mola' ts'iƚpicuejma', timinnila': “¡Toƚsinƚe! Iƚna'a laƚpepalc'o' joupa tipica. Aƚc'i'itsonga' tutani calaceite.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lahuats'la ts'iƚpicuejma' italai'e'me, timinnila': “A'i. Aimi'iya. Ja'ni aƚc'i'itsolhuo' illanc' lahue'e'monga'. Tonƚeƚe petsi locuquimpá, toƚ'natsa colaceite.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Miyeyi ti'nata quileceite, icuaiyunni ƚamaneya. Lahuats'la ts'iƚpicuejma' iyejmale'me ƚamaneya. Itsuflai'me jouc'a lamaneyoya. Ix'nifcom'me al puerta. ");
INSERT INTO chdNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Icuaitsa locuenaye lahuats'la. Ija'a'me, timiyi: “Maƚpoujna, maƚpoujna, laxi'e'etsonga' lopuerta”. ");
INSERT INTO chdNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ƚamaneya timila': “Iya' camilhuo' al ƚinca: Aicainimetsaicolhuo'.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús timila' ts'ilihuequi: ―Imanc' ti'hua toƚpo'noƚe cuenna. Aicoƚsina' ni litine ni al 'hora cacuaiconanni. ");
INSERT INTO chdNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Lo'iya ti'onƚcospa to li'ipa ti'hualecotsi aculi' anuli cal xans. Ai'a ti'hua'ma ijoc'i'mola' limozó ticuaiyunca. Epi'i'mola' quiƚ'huexi, iƚne tixinƚe lo'e'eyacu. ");
INSERT INTO chdNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Anuli epi'i'ma amaquej tomí, ƚocuena epi'i'ma oquej tomí, ƚocuena epi'i'ma ma le'a anuli, ma to mipa'a liƚpicuejma'. Lijou'ma ipanni, i'hua'ma aculi'. ");
INSERT INTO chdNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","’Cal mozo ƚepenufpa amaquej tomí ixhuico'ma al tomí, ulij'ma i'nif'caitsi amaquej tomí. ");
INSERT INTO chdNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Cal mozo ƚepenufpa oquej tomí jouc'a i'nif'caitsi oquej tomí. ");
INSERT INTO chdNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Cal mozo ƚepenufpa anuli al tomí itai'ma, i'hua'ma, ipu'ma ƚamats', emu'ma iƚe al tomí lepi'ipa ƚipoujna. ");
INSERT INTO chdNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Axpe' quitine icoƚhuo'ma ƚiƚpoujna lam mozó. Lijou'ma icuainanni. Icuis'e'mola', timila': “¿Te conƚ'ecopa al tomí lainepi'ipolhuo'?” ");
INSERT INTO chdNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cal mozo ƚepenufpa amaquej tomí itaic' imbamaj tomí. Timi ƚipoujna: “Maipoujna, alapi'ipa amaque' al tomí. ¡Toxinƚa'! Nulijpa amaque', i'ipa imbama'.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ƚipoujna timi: “Ac'a lo'epa. Ima' unc'a mozo. Latenƚcocopa ima' lo'ejma'. Tama ahuata lainepi'ipo', ac'a oxhuicopa. Itsiya capi'i'mo' comane tocuxeƚa' xonca axpe'. Iya' tixoqui neta juaiconapa. To'huanni. Jifa'a aƚmajm'me anuli. Tixoj'ma calata.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Icuaitsi cal mozo ƚepenufpa oquej tomí. Timi ƚipoujna: “Maipoujna, alapi'ipa oquej tomí. ¡Toxinƚa'! Nulijpa oque', i'ipa amalpu'.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ƚipoujna timi: “Ac'a lo'epa. Ima' unc'a mozo. Latenƚcocopa ima' lo'ejma'. Tama ahuata lainepi'ipo', ac'a oxhuicopa. Itsiya capi'i'mo' comane tocuxeƚa' xonca axpe'. Iya' tixoqui neta juaiconapa. To'huanni. Jifa'a aƚmajm'me anuli. Tixoj'ma calata.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Lijoujma icuaitsi cal xans ƚepenufpa anuli al tomí. Timi ƚipoujna: “Maipoujna, ima' aiximhuo' te ts'i'ic' lopicuejma'. Aiximhuo' ima' untá xans. Aimoxina' cuanuc'. Ima' aimofaya, tijouƚa' tapenuf'ma jahuay ƚaipa'ampa. Aimaca'neya cal trigo, tijouƚa' jahuay lafot'ƚeya tapenuf'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Lai'nujuaitsi toƚta'a lo'ejma', iya' aƚspaicunni, ai'hua'ma nemutsi ƚamats' al tomí, iƚe lalapi'ipa. ¡Toxinƚa'! Iƚta'a ja'a lotomí. Tapenufnaƚa'.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ƚapoujna timi ƚimozo: “Ima' mixcay mozo. Mahui. ¿Te aƚinca oxina' aicafaya, tijouƚa' capenuf'ma jahuay ƚaipa'ampa? ¿Te oxina' aicaca'neya cal trigo, tijouƚa' jahuay lafot'ƚeya capenuf'ma? ");
INSERT INTO chdNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ne', ne'. ¿Te comemucopa laitomí? Najmay mecantsi al banco. Toƚta'a capainanni, capenufna'ma jouc'a lulijpa laitomí. ");
INSERT INTO chdNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","¡Texic'enaƚe al tomí! Tepi'inaƚe iƚque ts'i'hueca imbama' al tomí. ");
INSERT INTO chdNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pe ts'i'hueca iƚe lulijpa, xonca tepi'im'me. Iƚque ti'huej'ma xonca. Pe aiqui'hueca, aiculiqui, texic'em'me iƚe lepi'impa. ");
INSERT INTO chdNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iƚca'a cal mozo pe aiqui'aic' canic', tolacanguf'me pe lopa'a al muf. Jiƚpe tijolijta, ti'ilc'ta liƚ'ay.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Iya' iƚque cal Xans Ƚiximpa cal profeta, cacuaiconanni aƚsim'ma aƚ'onƚcota to ȽanDios. Jahuay lainepaluc' aƚejmalecu. Cacutshuai'ma laicuecaj asiento, iya' ninCuecaj Juez. ");
INSERT INTO chdNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jiƚpiya tefot'ƚena'moƚtsi lan xanuc' quiyouyomma ni petsi li'a ƚamats', jahuay lan nación. Ma to ƚapoujna mot'ƚ tenaquila' lipinneja, iƚne ihuantseyoƚtsi lam mot'ƚ jouc'a lan chivo, ma toƚta'a iya' canaj'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Al c'a camane capo'no'mola' lam mot'ƚ. Loxa camane capo'no'mola' lan chivo. ");
INSERT INTO chdNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tijouƚa' iya' ninRey capalaic'o'mola' iƚniya nomana' al c'a camane, cami'mola': “Imanc', cai'Ailli' joupa ipaxnepolhuo'. Tunƚouyunca. Tolapenufle lapi'iyacolhuo' ȽanDios. Tepi'i'molhuo' loƚmane toƚcuxeƚe. Lilanc'epa li'a ƚamats' toƚta'a joupa ixpic'epa ȽanDios. Itsiya tepi'i'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Luyaipa quitine aƚtoc'ipa, itsiya lo'iyacolhuo' al c'a. Iya' ma cunle'e, imanc' aƚtes'mipa. Iya' micui caija', imanc' aluhui'ipa caija', aixnapa. Iya' nipayomma aculi', laicuaita loƚpiƚya' imanc' lapi'ipa cainejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Iya' ma lahue'e' caipijahua', imanc' alummi'ipa caipijahua', aipo'nopa. Iya' lalaxtafpa, imanc' aƚ'epa cuenna. Iya' ma capa'a lacarza, imanc' alahuejnhuo'ma.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Iƚne lan xanuc' naihuejcopá locuxepa ȽanDios aƚmi'ma: “Maƚpoujna, ¿te quitine laƚsimpoƚtsi ima' tonle'e, aƚtes'mipo'? ¿Te quitine laƚsimpoƚtsi ima' ticui coja', luhui'ipo', oxnapa coja'? ");
INSERT INTO chdNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Te quitine laƚsimpoƚtsi ima' mipayomma aculi', locuaita laƚpiƚya' lapi'ipo' comejut'ƚ? ¿Te quitine laƚsimpoƚtsi ima' ailopa'a copijahua', lummi'ipo' copijahua' opo'nopa? ");
INSERT INTO chdNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Te quitine laƚsimpoƚtsi ima' textafhuo' o topa'a lacarza lahuejnhuo'mo'?” ");
INSERT INTO chdNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Iya' ninRey catalai'e'e'mola', cami'mola': “Iya' camilhuo' al ƚinca: Imanc' loƚtoc'ipola' iƚna'a laipimaye, tama anuli xonca aca'hua iƚque ƚoƚtoc'ipa, ƚinca aƚtoc'iponga' iya'.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Tijouƚa' iya' capalaic'o'mola' iƚne nomana' loxa camane, cami'mola': “Imanc' joupa ecanipolhuo'. Tonƚolijle pe laifpa'a. Tonƚeƚe petsi ƚunga aimipica. Ti'hua tunaqui. Iƚque ƚunga ȽanDios ipo'nopa titeƚ'mitsola' ƚonta'a Satanás jouc'a lepaluc'. ");
INSERT INTO chdNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Imanc' aicaƚtoc'i, itsiya ixcay lo'iyacolhuo'. Iya' ma cunle'e, imanc' aicaƚtes'mi. Iya' micui caija', imanc' aicaluhui'i. ");
INSERT INTO chdNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Iya' nipayomma aculi', laicuaita loƚpiƚya' aicalapi'i cainejut'ƚ. Lahue'e' caipijahua', imanc' aicalummi'i. Iya' ma laxtafpa, ma capa'a lacarza, imanc' aicalahuenge.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Iƚne lan xanuc' titalai'e'me, aƚmi'ma: “Maƚpoujna, ¿te quitine laƚsimpoƚtsi ima' tonle'e, o ticui coja'? ¿Te quitine laƚsimpoƚtsi ima' o'huayomma aculi', ocuaita laƚpiƚya', o ailopa'a copijahua', o textafhuo', o topa'a lacarza, y aicaƚtoc'ihuo'?” ");
INSERT INTO chdNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Iya' catalai'e'e'mola', cami'mola': “Iya' camilhuo' al ƚinca: Imanc' olatets'ipola' iƚna'a laipimaye, aicoƚtoc'ila', toƚta'a latets'iponga' iya'. Tama xonca aca'hua iƚque ƚolatets'ipa, ma latets'iponga' iya'.” ");
INSERT INTO chdNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iƚniya tiyena'me petsi lateƚcoya aimijouya. Lan xanuc' naihuejcopá locuxepa ȽanDios, ituca' loyalaicoyacu iƚniya. Jiƚne titsuflai'me petsi liƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús lijoupa limipola' ts'ilihuequi iƚniya ƚataiquí, ipalaic'ocona'mola', timila': ");
INSERT INTO chdNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Joupa oƚsina' tehue'e' oquej quitine ti'i'ma al juic Pascua. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aƚcu'ma, lapaƚts'inginna lancruz. ");
INSERT INTO chdNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui' efot'ƚe'moƚtsi lejut'ƚ cal cuecaj ca'ailli' cuftine Caifás. ");
INSERT INTO chdNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jiƚpe ixpic'e'me lataiqui' tifel'mi'me Jesús, ti'noƚƚe, tima'anƚe. ");
INSERT INTO chdNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ticuayi: ―Mi'i juic aimaƚ'noƚyacu, tixtulecu lan xanuc', titsolhuicu. ");
INSERT INTO chdNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús tipa'a liƚya' Betania, lejut'ƚ Simón, iƚque ƚixaƚconapa lehui lepra. ");
INSERT INTO chdNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jiƚpe anuli ƚaca'no' icuaitsi pe lopa'a Jesús. Itaic' lipulu ilajncopa apic cuftine alabastro. Iƚe lipulu tinango laceite tujuej c'a, acueca' lipitali. Micutsuya Jesús titesma ƚaca'no' iƚoc'huai'ma, ic'ef'i'i'ma ƚijuac iƚe laceite. ");
INSERT INTO chdNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lixim'me toƚta'a lo'epa ƚaca'no', ts'ilihuequi Jesús ixtulenca. Ticuayi: ―¿Te quecani'ecopa laceite? Acueca' lipitali. ");
INSERT INTO chdNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Coƚa' icule'ma. Jiƚe al tomí lolijya tepi'im'mola' lan xanuc' pe aiquiƚ'hueca. ");
INSERT INTO chdNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús ixina' lonespa. Timila': ―¿Te coƚsueƚ'micopa ƚaca'no'? Ac'a iƚta'a li'epa. Latenƚma. ");
INSERT INTO chdNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jahuay ƚitiné ma fa'a timana' lan xanuc' pe aiquiƚ'hueca. Iya' aicapajnconaya. Aimaƚmajnconayacu anuli. ");
INSERT INTO chdNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Laƚc'if'ipa iƚta'a laceite lojuepa ac'a, joupa enanƚpa iƚe laƚ'e'enya ai'a laminna. ");
INSERT INTO chdNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iya' camilhuo' al ƚinca: Aimimenc'ecoyacu li'epa iƚca'a ƚaca'no'. Ni petsi li'a ƚamats' loya'anyacu Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios, tuya'am'me jouc'a iƚe li'epa iƚca'a ƚaca'no'. Lan xanuc' ti'nujuaisnata. ");
INSERT INTO chdNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Anuli iƚniya limbamaj coquexi' ts'ilihuequi Jesús, iƚque cuftine Judas Iscariote, i'hua'ma, icuaitsi pe lomana' lixanuc' cal cuecaj ca'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Timila': ―¿Tojua lapi'i'ma ja'ni cacu'ma Jesús? Imanc' toƚ'noƚta. Iƚniya inefo'me ti'najtse'e'me anuxans quimbamaj tomí aplata. ");
INSERT INTO chdNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Maƚpe 'hora Judas ipango'ma ehue'me te co'eya micuya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Joupa icuai'ma litine titem'me ƚa'i aiquilajncojma levadura. (Toƚta'a mi'i al juic Pascua.) Ts'ilihuequi icuaitsa pe lopa'a Jesús, icuis'e'me, timiyi: ―¿Petsi caƚƚanc'eyoyacu caƚsmocoyoyacu al juic Pascua? ¿Te cofcuapa? ");
INSERT INTO chdNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Timila': ―Tonƚeƚe liƚya' Jerusalén, lejut'ƚ anuli cal xans, toƚmitsa: “Ƚaƚpomxi timihuo': Joupa icuaico'ma laifteƚcoya. Lomejut'ƚ aƚsmocoyo'me al juic Pascua, iya' jouc'a ts'alihuequi.” ");
INSERT INTO chdNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ts'ilihuequi i'ehuo'me to licuxe'e'mola' Jesús. Ilanc'ehuo'me calxmocojma al juic Pascua. ");
INSERT INTO chdNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Joupa ummuhuita, Jesús tixmocoyi jouc'a limbamaj coquexi' ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mitetsoyi, Jesús timila': ―Iya' camilhuo' al ƚinca: Anuli imanc' aƚcu'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iƚniya ixhueƚconca juaiconapa, ihuotsonca. Anuli anuli timiyi: ―Maipoujna, ¿te iya'? Iya' a'i. ");
INSERT INTO chdNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús italai'e'e'mola', timila': ―Ma maƚtetsoyi nalacajm'miyacu laƚmane al pime anuli, iƚque ƚaƚcuya. ");
INSERT INTO chdNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Tama ca'hua'ma laipene ma to loya'apa al Paxi Liniƚingiya, iƚque cal xans ƚaƚcuya, a'ijc'a loyaicoya. Juaiconapa acueca' titeƚco'ma iƚque, ticuaj'moxi, ticua'ma: “Coƚa' aicaipajntsi iya'”. ");
INSERT INTO chdNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, iƚque ƚocuya Jesús timi: ―Momxi, ¿te iya'? Jesús italai'e'e'ma, timi: ―Al ƚinca lofcuapa. ");
INSERT INTO chdNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mitetsoyi Jesús epef'ma ƚa'i, ix'najtsi'i'ma ȽanDios, ixquetsuf'ma, epi'i'mola' ts'ilihuequi, timila': ―Tolapenufle. Toƚteƚe. Iƚta'a aicuerpo. ");
INSERT INTO chdNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Uhuaf'ma al vaso, ix'najtsi'icona'ma, uhui'i'mola' ts'ilihuequi, timila': ―Toƚsnaƚe jahuay imanc'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iƚta'a aijuats' tiƚinc'i'ma al ts'e cataiqui' ȽanDios lopo'no'ipola' lixanuc'. Caxcuajai'ma laijuats' toƚta'a cunƚu'e'mola' axpela' lan xanuc', tiƚonc'e'em'mola' liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iya' camilhuo', jifa'a li'a ƚamats' aicaxnaconaya al vino. Litine tixinƚe cai'Ailli' ȽanDios ticuxe, iƚe litine caxnaconna. Iƚiya al ts'e vino aƚsnata anuli. ");
INSERT INTO chdNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Unac'li'me anuli al salmo, ipalunca. Iye'me ƚijuala Olivo. ");
INSERT INTO chdNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús timila' ts'ilihuequi: ―Iƚta'a lipuqui' imanc' tonlanaj'moƚtsi. Aƚpo'no'ma caituca'. Ti'i'ma to muya'e' al Paxi Liniƚingiya, ticua: “Caxcai'e'ma ƚiƚpoujna lam mot'ƚ, iƚque tima'ma. Lam mot'ƚ tica'ne'moƚtsi.” ");
INSERT INTO chdNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Camaf'ina'ma. Tijouƚa' ti'iƚa' toƚta'a ca'hua'ma al distrito Galilea. Jiƚpe ca'huaicotolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro timi Jesús: ―Tama tixtuc'otso' jahuay laipimaye, tenajtsoƚtsi, iya' a'i. Iya' ma quihuej'mo'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús italai'e'e'ma, timi: ―Iya' camihuo' al ƚinca: Iƚta'a lipuqui', ai'a tija'a'ma ƚangiti, ima' tones'ma afanemma: “Aicainimetsaijma Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro timi: ―Tama aƚma'atsonga' anuli, aicanesya: “Aicainimetsaijma Jesús”. Ma' anuli licua'me jahuay locuenaye ts'ilihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús jouc'a ts'ilihuequi icuaitsa jiƚpe cuftine Getsemaní. Jesús timila': ―Imanc' toƚcutsoƚaiƚe jifa'a. Iya' ai'huapa ƚu'hua, capalaic'ota cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ileco'mola' Pedro jouc'a loquexi' linaxque' Zebedeo. Ipango'ma ihuotso'ma. Tixina ipime jiƚe lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Timila': ―Juaiconapa cahuosma, tocomma aƚma'a'ma lixhuejma'. Toƚmanenca fa'a. Jiƚpe capalaic'ota ȽanDios. Imanc' aƚtoc'i'ma. Ma fa'a toƚpalaic'o'me ȽanDios jouc'a. Aimoƚsmai'me. ");
INSERT INTO chdNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Uyai'ma nihuata, ixpats'huai'ma ƚamats', tixa'hue ȽanDios, timi: ―Mai'Ailli', ja'ni nipajnya ti'i'ma liƚonc'e'eƚa' iƚta'a laifteƚcopa. Ja'ni aimi'iya, ne', ti'iƚa' lofxpic'epa, a'i to iya' lalatenƚcocopa. ");
INSERT INTO chdNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ipainanni, icuai'ma pe lomana' ts'ilihuequi. Ixim'mola' tixmaiyi. Timi Pedro: ―¿Te ailopa'a coƚpujfxi? ¿Ni' anulij hora aimi'iya moƚmaf'iyacu? ¿Te aimi'iya maƚtoc'iya? ");
INSERT INTO chdNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Toƚmaf'iƚe. Aimoƚsmai'me. Toƚsahue'eƚe ȽanDios titoc'itsolhuo', aimehuaiyim'molhuo'. Imanc' toƚcuayi: “Aƚsnet'ƚ'me”. A'i, loƚcuerpo aimitoc'ilhuo'. Aimi'iya mijucoya. ");
INSERT INTO chdNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","I'huacona'ma, ixa'huecona'ma ȽanDios, timi: ―Mai'Ailli', ja'ni aimi'iya maliƚonc'e'eya laifteƚcopa, ja'ni joupa oxpic'epa cateƚco'ma, ma toƚta'a ti'iƚa'. Ne', tixhuaitsi laifteƚcopa. ");
INSERT INTO chdNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ipaiconamma pe lomana' ts'ilihuequi. Ixingona'mola' tixmaiconayi. Tixinyi timufquemma liƚ'u'. Ticui quilehui. ");
INSERT INTO chdNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ipo'nocona'mola' quiƚtuca'. Joupa i'ipa afanemma mipalaic'o ȽanDios. Ma' anuli tixa'hue. ");
INSERT INTO chdNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Icuaiconanni pe lomana' ts'ilihuequi. Timila': ―¿Te ti'hua toƚsmaiyi? ¿Te ti'hua tulunxajyi? ¡Toƚsinƚe! Joupa icuai'ma lai'hora. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a, joupa aƚcumpa. Icuaita quiƚmane lan xanuc' pe aimihuejcoyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Toƚsolinca! ¡Ƚenapá! Toƚsinƚe jiƚcu'hua icuaico'ma ƚaƚcuya. ");
INSERT INTO chdNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mipalay Jesús icuaitsi Judas, iƚque anuli iƚniya limbamaj coquexi' ts'ilihuequi Jesús. Ilecola' axpela' lan xanuc', iƚtaic' liƚ'espada, liƚ'ec. Ummempola' lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iƚque nocuya Jesús joupa imipola' iƚne lan xanuc': “Iya' camuc'itolhuo' naitsi Jesús. Iƚque ƚaiftuc'oya maƚque Jesús. ¡Toƚ'noƚƚe!” ");
INSERT INTO chdNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aiquicoƚ'ma. Judas icuaitsi pe lopa'a Jesús, inom'ma, timi: ―¡Momxi! Ituc'o'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús timi: ―Maipima, iƚe lof'eya, ¡to'eƚa'! Lan xanuc' icuaitsa, i'noƚ'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anuli ƚiƚejmale Jesús ipa'a'ma li'espada, ixcai'e'ma ƚimozo cal cuecaj ca'ailli', etec'e'e'ma lix'mas. ");
INSERT INTO chdNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús timi: ―Tamuf'minƚa' lo'espada licubierta. Jahuay noma'ahualecopá a'espada, iƚne tima'acom'mola' jouc'a a'espada. ");
INSERT INTO chdNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Iya' nipajnya cajoc'i'ma cai'Ailli', iƚque aimicoƚya, tumme'mola' lepaluc' quema'a, ticuaicu pe laifpa'a. Juaiconapa axpela' tumme'mola', tixhuaispola' to imbamaj coquexi' lincuxepa jouc'a lanxpela' lilepaluc', o xonca. Lunƚu'ena'ma. ¿Te aicoƚsina' toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Iya' aicajoc'iya cai'Ailli'. Ja'ni cajoc'iƚa', ¿te co'iya menanƚya al Paxi Liniƚingiya loya'apa? Iƚe lataiqui' tuya'e' toƚta'a laƚ'iya. ");
INSERT INTO chdNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesús ipalaic'o'mola' lanxpela' xanuc' licuaiyunca ti'noƚƚe. Timila': ―¿Te coƚcuaiyoco'me fa'a oƚtaic' loƚ'espada, loƚ'ec aƚ'noƚƚa'? ¿Te toƚcuayi iya' ninma'ahuale, nin‑namas? Itine itine cacutsay pe lopa'a al cuecaj xoute', camuc'ila' lan xanuc', a'i caƚ'noƚi. ");
INSERT INTO chdNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ne'. Tenanƚƚa' liƚtaiqui' luya'apa lam profeta. Iƚniya joupa uya'apá laƚ'iya toƚta'a. Lixanuc' Jesús inulai'me, ipo'no'me Jesús quituca'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lan xanuc' li'noƚ'me Jesús ileco'me pe lopa'a cal cuecaj ca'ailli' cuftine Caifás. Jiƚpe joupa efot'ƚeyoƚtsi lomxiye nomuc'iyalepá locuxepa ȽanDios, jouc'a lan tsilaj xanuc' noxpijpá lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro ihuej'ma aculi'. Licuaitsi lejut'ƚ cal cuecaj ca'ailli' itsufai'ma ƚipuna quejut'ƚ, icutsingai'mola' lepaluc' al cuecaj xoute'. Ti'huaico'ma lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui' iƚpic'a tixpic'enƚe tima'anƚe Jesús. Tehuennila' nofelƚaiquepá ticufle, tinesle: “Toƚta'a, toƚta'a lo'epa”. ");
INSERT INTO chdNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Axpela' linfel'miyale icuf'me Jesús. Iƚniya aiqui'ic' quilecani'e. Icuaitsa oquexi' linfel'miyale. ");
INSERT INTO chdNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Iƚniya icuf'me Jesús, ines'me: ―Iƚca'a cal xans icuapa: “Iya' cateƚ'ma lejut'ƚ ȽanDios. Ti'iƚa' afane' quitine, iya' joupa ailanc'enapa.” ");
INSERT INTO chdNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ecax'ma cal cuecaj ca'ailli', timi Jesús: ―Iƚne lan xanuc' ticufhuo'. ¿Te aimotalai'eyacola'? ");
INSERT INTO chdNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús i‑ch'ixco'ma. Cal cuecaj ca'ailli' timi: ―ȽanDios Ƚimaf'i' joupa lapi'ipa laimane cacuxe'e'mo', lu'itsonga'. Aƚmiƚa' ¿te ima' unCristo i'Hua ȽanDios? ");
INSERT INTO chdNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús timi: ―Al ƚinca lofcuapa. Iya' camilhuo' jahuay imanc', ticuaihuo litine imanc' aƚsim'ma ma cacutsu al c'a camane cal Cuecaj CanDios. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Imanc' aƚsim'ma quimuhuo lema'a, cacuaiyoconno ƚamats' nolojmay cummahuay lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Licuej'ma jiƚiya licuapa Jesús, cal cuecaj ca'ailli' its'aƚ'ma lipijahua'. Toƚta'a imujpa lipoyac'. Aiquetenƚcoco'ma licuapa Jesús. Ipalaic'o'mola' lixanuc', iƚne nomana' jiƚpe, timila': ―Iƚque cal xans tetets'i ȽanDios. Ixcay linespa. ¿Te calahuecoyacola' ocuenaye xanuc' ticufle? Joupa oƚcuejpá imanc' linespa, etets'ipa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Imanc', ¿te coƚcuapá? Iƚne italai'e'e'me timiyi: ―Tipa'a lijunac'. ¡Tima'anƚe! ");
INSERT INTO chdNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ipango'me itsuƚco'me li'a, untaf'me, ete'me. ");
INSERT INTO chdNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Timiyi: ―Ima' unCristo, tocua'aƚa' naitsi luntafpo'. Ima' lu'itsonga'. ");
INSERT INTO chdNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro ticutsu ƚuna. Iƚoc'huai'ma anuli ƚahuats', timi: ―Ima' jouc'a unƚejmale Jesús ƚas Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro icuanaj'ma, timi: ―Aicaicueca lofnespa. Lan xanuc' nomana' jiƚpiya icuej'me locuapa. ");
INSERT INTO chdNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro enaj'moxi, i'hua'ma jiƚpiya lotsufaicompa lane. Jiƚpe ocuena ƚahuats' ixim'ma. Iƚque ipalaic'o'mola' lan xanuc' nacaxoƚanna, timila': ―Iƚque cal xans iyejmalepa Jesús ƚas Nazaret. ");
INSERT INTO chdNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro inescona'ma, icuanajcona'ma. I'e'ma jurar, timi: ―Aicainimetsaijma iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Uyai'ma nihuata. Iƚne nacaxoƚanna iƚoc'huai'me maƚpe lacaxu Pedro. Timiyi: ―Ma' aƚinca ima' onƚejmale Jesús. Ma to mipalaiyi lun Galilea, jouc'a ima' topalay. Ima' mas Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro i'econa'ma jurar, timila': ―Iya' camilhuo' al ƚinca. Ja'ni a'i, aƚma'aƚa' ȽanDios. Aicainimetsaijma iƚque cal xans. Aiquicoƚ'ma. Ija'a'ma ƚangiti. ");
INSERT INTO chdNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedro i'nujuaitsi iƚe lu'i'ma Jesús, limi'ma: “Ai'a tija'a'ma ƚangiti, ima' tones'ma afanemma: Aicainimetsaijma Jesús.” Ipanni, ijojpa talay ƚunxajma'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Li'ipa quitine, lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui' efot'ƚecona'moƚtsi. Ixpic'e'me tima'anƚe Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ifi'e'me Jesús, ileco'me jiƚpiya pe lopa'a cal gobernador romano cuftine Pilato. ");
INSERT INTO chdNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ƚicupa Jesús, cuftine Judas, lixim'me tima'anna Jesús, ixhuej'menni li'epa. Itai'ma al nuxans quimbama' tomij plata, icuaitsi pe lomana' lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc'. Icufintsola' liƚtomí. ");
INSERT INTO chdNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Timila': ―Aiximpa ixcay lai'epa. Aicupa iƚque cal xans tima'anƚe. Ailopa'a quijunac'. Iƚne italai'e'e'me, timiyi: ―Illanc', ¿te caƚ'eyacu? Ima' cotuca' o'epa. ¡Toxinƚa' ima'! ");
INSERT INTO chdNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas eca'nipa al tomí al cuecaj xoute'. Ipanni, i'hua'ma ijujnyoxi. ");
INSERT INTO chdNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lixanuc' cal cuecaj ca'ailli' epef'napá liƚtomí. Timiyoƚtsi: ―¿Te caƚ'e'eyacu iƚta'a al tomí? Iƚta'a aƚ'najtse'ecopá Judas ticuƚa' Jesús tima'anƚe. Aimi'iya maƚ'huantsiyacu al tomí ƚi'huexi al cuecaj xoute'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","I'e'moƚtsi anuli liƚpicuejma'. Timiyoƚtsi: ―Iƚta'a al tomí aƚ'naco'me ƚemats' ƚintalhuaƚpa capixu. Jiƚpe lamutola' lan xanuc' noyouyomma ocuenaye nación. ");
INSERT INTO chdNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jiƚpe ƚamats' ecui'impá ocuena quipuftine, ecui'ipá: Amats' cajuats'. Itsiya litine toƚta'a tecui'inni. ");
INSERT INTO chdNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Toƚta'a enanƚpa licuapa cal profeta Jeremías luya'apa: “Epef'na'me al nuxans quimbama' tomij plata. Jiƚpiya pe lomana' lan xanuc' Israel iƚiya al tomí ti'ommaita lo'nacompa anuli cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Lijou'ma maƚe al tomí i'nacopá ƚemats' ƚintalhuaƚpa capixu. Toƚe laƚcuxe'epa ƚaƚPoujna ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús tecaxu pe lopa'a Pilato, cal gobernador romano. Iƚque icuis'e'ma, timi: ―¿Te ima' unrey? ¿Te ima' tocuxe'mola' lan xanuc' judío? Jesús italai'enni, timi: ―Al ƚinca lofcuapa. ");
INSERT INTO chdNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui' icuf'me Jesús. Iƚquiya aiquipalaic', aiquitalai'e. ");
INSERT INTO chdNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato icuis'e'ma, timi: ―¿Te aimocueca locuapa iƚniya? Juaiconapa ticufhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús aiquitalai'e. Ailopa'a quitaiqui'. Pilato ixhueƚco'ma. Icuapa lipicuejma': “Iƚca'a Jesús, ¿te qui'icopa aimitalai'e?” ");
INSERT INTO chdNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ajuic ajuic Pascua cal gobernador romano tux'masqui anuli ƚitats'iya, to mixahue'eyi lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Iƚe litine tipa'a anuli cal xans ƚitats'iya cuftine Barrabás. Iƚque jahuay imetsaiconni. ");
INSERT INTO chdNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lijoupa lefoƚunni, Pilato icuis'e'mola', timila': ―¿Naitsi caifnux'masya? ¿Naitsi ts'oƚpic'a? ¿Oƚpic'a Barrabás? O ¿oƚpic'a Jesús, iƚque ƚacui'impa cal Cristo? ¿Te coƚcuapa? ");
INSERT INTO chdNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Toƚta'a licuapa Pilato, timetsaicola' iƚniya lan xanuc' liƚpicuejma', iƚne nicuai'eta Jesús. Ixina' ma ti'eyi laic'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Micutsu Pilato ti'ay lipenic' to cal juez, ƚipeno umme'ma cataiqui', ticua: “Ima' topo'noxoxi cuenna. Iƚque cal xans ailopa'a quijunac', aimo'e'e'ma ni tintsi. Lipuqui' aipaiyocopa iƚquiya. Aƚspaijpa juaiconapa.” ");
INSERT INTO chdNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc', joupa ixc'ai'impola' lan xanuc', imimpola': ―Toƚsahue'eƚa' Pilato, toƚmiƚe: “Tox'masla' Barrabás, tocuxeƚa' tima'anƚe Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato icuis'e'mola', timila': ―Iƚna'a loquexi' litats'ila', ¿naitsi caifnux'masya? ¿Nai ts'oƚpic'a? Italai'enca, timiyi: ―¡Barrabás! ");
INSERT INTO chdNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato icuis'econa'mola', timila': ―¿Te caif'e'eya Jesús, iƚque ƚacui'impá cal Cristo? Jahuay italai'enca, timiyi: ―¡Tapaƚts'ijnla' lancruz! ");
INSERT INTO chdNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato icuis'econa'mola', timila': ―¿Te qui'epa? ¿Te caifnepaƚts'ijncoya lancruz? Lan xanuc' xonca ujfxi ija'a'me, timiyi: ―¡Tapaƚts'ijnla' lancruz! ");
INSERT INTO chdNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato ixina' aimulijya. Ixim'mola' ixtulenca, epat'ƚ‑tola' liƚpicuejma'. Icuxe'ma ti'hua'anca quija' tulouco'ma, tixinƚe lan xanuc' iƚe lo'eya. Timila': ―Ja'ni imanc' toƚspic'eyi tima'anƚe iƚca'a cal ƚijca xans, iya' aicataiyinge lajunac'. Imanc' ƚinca toƚtaiyijm'me loƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jahuay italai'enca, timiyi: ―Ne'. Aƚtaiƚe laƚjunac' illanc' jouc'a laƚnaxque'. ¡Tima'anƚe! ");
INSERT INTO chdNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato ux'masna'ma Barrabás, ma to lixahue'e'me lan xanuc'. Icuxe'ma tipaƚe Jesús. Lijou'ma icu'ma Jesús tileco'me lan soldado, tepaƚts'ijnta lancruz. ");
INSERT INTO chdNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iƚniya lisoldado cal gobernador ileco'me Jesús, itsufai'e'me lejut'ƚ Pilato. Jiƚpiya efot'ƚe'moƚtsi jahuay liƚf'as soldado. ");
INSERT INTO chdNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ipa'e'me lipijahua', ipo'no'i'me anuli litoqui lijahua' unxali, to lopo'nopa lan rey. ");
INSERT INTO chdNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ipuf'me anuli al corona quitac, ic'ommof'i'i'me ƚijuac. Al c'a camane i'noƚ'i'i'me anuli al jaxa. Exc'onƚingai'me, ixoco'me, timiyi: ―Aƚnonghuo', ima' unrey. Ima' tocuxe'mola' lan xanuc' judío. ");
INSERT INTO chdNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Itsuƚco'me. Exic'e'ena'me al jaxa, ipango'me untaf'e'eco'me al jaxa ƚijuac. ");
INSERT INTO chdNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lijoupa lixocopa, ipa'ana'me lijahua', ipo'no'icona'me ma lipijahua'. Ileco'me petsi lapaƚts'ijnyoyacu lancruz. ");
INSERT INTO chdNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lipalunca, licuaitsa lane, italecuf'me anuli cal xans cuftine aSimón. Iƚque cal xans a'i quipiƚya' jiƚpe Jerusalén. Lipiƚya' lipuftine Cirene. Iƚque icuxe'e'me titaiƚa' lencruz Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Icuaitsa petsi cuftine Gólgota, iƚta'a lataiqui' lohuaƚquemma: Pe lopa'a ƚecoye. ");
INSERT INTO chdNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jiƚpiya icufim'me Jesús al vino uhuantsi acuaj c'ec. Tixnaƚa' iƚe al vino aijtine mixingufcoya ƚumla. Jesús ixnac'opa, lijoupa aiquixnaic'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Epaƚts'ingim'me lencruz. Iƚniya lan soldado no'epaj cuenna Jesús if'ilco'me, ixim'me naitsi nolijya lipijahua'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Icutsoƚai'me, i'e'me cuenna. ");
INSERT INTO chdNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Al toncay ƚijuac Jesús epaƚts'ingimpa lacaxma, jiƚiya iniƚiya licufcopa. Tuya'e': “Iƚca'a Jesús, ƚiƚrey lan xanuc' judío”. ");
INSERT INTO chdNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jouc'a Jesús epaƚts'ingila' oquexi' lan namats'. Anuli tipa'a al c'a camane, ƚocuena loxa camane. ");
INSERT INTO chdNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lan xanuc' luyalaico'me jiƚpiya imiloj'me cataiqui', ife'ne'me ƚiƚjuac, ");
INSERT INTO chdNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","timiyi: ―Ima' nofmeteƚya al cuecaj xoute', tuyaiƚa' afane' quitine joupa olanc'enapa, ¡itsiya tonƚu'exoxi! Ja'ni ima' i'Hua ȽanDios, ¡taimunni lancruz! ");
INSERT INTO chdNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Toƚiya ixoco'me jouc'a lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, jouc'a lan tsilaj xanuc' noxpijpá lataiqui', tinesyi: ");
INSERT INTO chdNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Iƚquiya unƚu'e'mola' locuenaye. Itsiya aimi'i munƚu'eyoxi. Illanc' ixanuc' Israel, ja'ni iƚque aƚrey, ¡timunni lancruz! Toƚe ƚinca lapenuf'me. ");
INSERT INTO chdNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iƚquiya ti'huaiyinge ȽanDios. Ticua: “Iya' i'Hua ȽanDios”. Ne'. Ja'ni ȽanDios timetsaicojma, tunƚu'eƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Loquexi' lan namats' lepaƚts'ingila' jouc'a, iƚniya ixoco'me. ");
INSERT INTO chdNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Al menac'o imufc'o'ma lema'a. Ni petsi jiƚpiya ƚamats' tocomma ipuqui'. Afanej hora icoƚpa al muf. ");
INSERT INTO chdNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ixhuaitsi to al fanej hora, Jesús ija'a'ma ujfxi, ticua: ―Elí, Elí, ¿lama sabactani? Iƚiya lataiqui' luhuaƚquemma: Ima' mainenDios, ¿te calacanujcopa? ");
INSERT INTO chdNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lan xanuc' nacaxhuoƚanna jiƚpiya, oquexi' afantsi iƚniya icuej'me lines'ma Jesús, ines'me: ―Tijoc'i' cal profeta Elías. ");
INSERT INTO chdNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Anuli iƚniya aiquicoƚ'ma, inu'ma, itaitsi anuli al esponja, ijac'eco'ma al cuxac vino, icants'i'ma lupa al jaxa, i'nof'e'ma, icuai'etsi lico Jesús, titsif'la'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ocuenaye ticuayi: ―¡Toƚe! Aƚsim'me ja'ni ticuaihuo Elías tunƚu'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús ija'acona'ma ujfxi. Ummena'ma ti'huanƚa' ƚi'espíritu, imana'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jiƚpe al cuecaj xoute' al paxi lajut'ƚ lotsufaicompa etemf'icoya anuli lijahua'. Limana'ma Jesús, iƚe lijahua' its'aƚnuf'i'ma, ijof'ico'ma al toncay, xejmay i'i'ma. Inu'ma ƚunanto, ixquetsuf'i'ma lapic'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Iƚna'a liƚpu'hua limanapola' exinni. Axpela' limapola' imaf'ina'me, iƚne ma li'huijf'epola' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iƚne ipalunca liƚpu'hua. Limaf'ina'ma Jesús iƚniya itsuflaipá Jerusalén, iƚe al paxi quiƚya'. Axpela' lan xanuc' ixinim'mola' iƚniya nimaf'inapá. ");
INSERT INTO chdNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ƚiƚpincuxepa lan soldado, jouc'a lan soldado iƚne no'epá cuenna Jesús, lixingufco'me ƚunanto, jouc'a jahuay li'i'ma, tixpailiquila' juaiconapa, timiyoƚtsi: ―Ma aƚinca iƚca'a cal xans i'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jiƚpe timana' axpela' lacaƚ'no'. Huata caj culi' tecaxoƚanna, tehuelojnyi lo'ipa. Iƚne lacaƚ'no' itoc'ipá Jesús. Ipalunca al distrito Galilea, ihuej'me Jesús, icuaitsa Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Anuli iƚniya lipuftine María ƚas Magdala, ƚocuena cuftine María, iƚque iƚ'máma' Jacobo y José. Jouc'a tipa'a quiƚ'máma' Jacobo y Juan, iƚniya loquexi' quiƚ'ailli' Zebedeo. ");
INSERT INTO chdNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","If'acoƚaipa. Icuaitsi anuli cal xans ƚas Arimatea, cuftine aJosé. Iƚque cal xans acueca' qui'huexi. Ihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I'hua'ma pe lopa'a Pilato. Ixahue'etsi tepi'inƚe licuerpo Jesús. Pilato icuxe'ma tepi'inaƚe. ");
INSERT INTO chdNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José epenuf'ma licuerpo Jesús, iju'e'ma anuli al ts'e lijahua' ipuficoya alino. ");
INSERT INTO chdNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","I'hua'a'me lamu'enyacu Jesús, iƚe unts'eja', ats'e. Maƚque José ipuc'opa ƚapic, ilanc'epa ƚunts'eja'. Jiƚpiya i'nicotsi Jesús. Imelfai'etsi anuli cal cuecaj capic teti'ico'ma lico cunts'eja'. I'huana'ma. ");
INSERT INTO chdNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jiƚpe ticutsoƚanna María ƚas Magdala y ƚocuena María, tehuelojnyi al pu'hua cunts'eja'. ");
INSERT INTO chdNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jiƚpe litine avispera. Lihuequi litine ti'i'ma itine conxajya. Iƚe litine conxajya lixanuc' cal cuecaj ca'ailli' jouc'a lam fariseo iyehuo'me, ixintsa Pilato. ");
INSERT INTO chdNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Timiyi: ―Maƚpoujna, aƚ'nujuaisyi linespa iƚque ƚinfel'miyale. Mipa'a iƚque ines'ma: “Tuyaiƚa' afane' quitine camaf'ina'ma, quipayonno pe lomana' lamizhua”. ");
INSERT INTO chdNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Itsiya aƚsahue'ehuo' tocuxeƚa' tiyeƚe ƚunts'eja', ti'entsa cuenna afane' quitine. Ja'ni a'i, aga tiye'me lipuqui' ts'ilihuequi tinantsenna, tipa'anna. Tijouƚa' tu'innola' lan xanuc': “Iƚque imaf'inapa, ipanamma pe lomana' lamizhua”. ");
INSERT INTO chdNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato timila': ―Ne'. Tonƚenƚe. Toƚsinna loƚ'eyacu. Toƚƚecoƚe coƚsoldado. Ti'etsa cuenna jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iye'me. Jiƚpe ƚapic ƚopa'a lico cunts'eja' ipa'ninc'itsa ƚisello cal gobernador romano. Imanenca lan soldado i'e'me cuenna. Ticuayi: ―Aimexi'em'me. ");
INSERT INTO chdNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Joupa uyaipa litine conxajya. I'ipa quitine al te'a quitine al xamano. María ƚas Magdala jouc'a ƚocuenaj María iye'me ixintsa ƚunts'eja'. ");
INSERT INTO chdNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Licuaitsa nungay ƚunts'eja' iximpá joupa inupa acuecaj cunanto. Li'ipa ƚiya imunni lema'a anuli ƚepaluc ƚaƚPoujna ȽanDios. Iƚque ƚapaluc quema'a joupa icuaita pe lopa'a ƚunts'eja', iƚonc'epa ƚapic ƚeti'icompa lico cunts'eja', icutsafcaic'. ");
INSERT INTO chdNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Li'a tunts'ifi to lixcuaflay. Lipijahua' ma afujca to cal nieve. ");
INSERT INTO chdNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lixim'me lan soldado ixpailij'mola', iyu'mola', imanenca to limac'la. ");
INSERT INTO chdNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Licuaitsa jiƚpe lacaƚ'no', ƚapaluc quema'a ipalaic'o'mola', timila': ―Aimixpailij'molhuo'. Aixina' naitsi conlahuepa. Tolahueyi Jesús, iƚque ƚepaƚts'ingimpa lancruz. ");
INSERT INTO chdNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Fa'a ailopa'a. Ma to luya'apa joupa imaf'inapa. Tonƚouyunca. Toƚsinna pe lipo'no'empa. ");
INSERT INTO chdNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tijouƚa' aimicoƚ'molhuo' tonƚeƚe pe lomana' ts'ilihuequi. Toƚmitsola': “Jesús imaf'inapa. Ipayonamma pe lomana' lamizhua. I'huanapa Galilea. Imanc' tonƚeƚe jiƚpiya. Toƚsinnata.” Toƚta'a laitaiqui', joupa nu'ipolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lacaƚ'no' aits'icoƚ'mola' jiƚpiya ƚunts'eja', ipailinanca. Iye'me tinulyi tu'innola' ts'ilihuequi Jesús. Tama tixpailiquila' tixoqui quileta. ");
INSERT INTO chdNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Miyeyi lane italecuf'mola' Jesús. Iƚque inom'mola' ma to mi'ay. Lacaƚ'no' iƚoc'oƚai'me, exc'onƚingoƚai'me, i'noƚ'e'e'me li'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús timila': ―Aimixpailij'molhuo'. Tonƚeƚe. Toƚmitsola' laipimaye tiyeƚe Galilea. Jiƚpiya aƚsinnoƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lan soldado, iƚne ni'epá cuenna ƚunts'eja', joupa iyenapá. Miyeyi lacaƚ'no' hualca iƚniya lan soldado icuainatsa ate'a Jerusalén. Jiƚniya ipalaic'om'mola' lixanuc' cal cuecaj ca'ailli', uya'a'me jahuay liximpa. ");
INSERT INTO chdNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui' efot'ƚepoƚtsi. Ixpic'e'me lo'eyacu. Epi'im'mola' lan soldado acuecaj tomí. ");
INSERT INTO chdNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Icuxe'em'mola', timinnila': ―Toluya'a'me: “Li'ipa lipuqui' icuaita ts'ilihuequi Jesús, ipa'ahuona'me. Illanc' aƚsmaipá.” ");
INSERT INTO chdNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Cal gobernador romano, ja'ni ticuejla' imanc' oƚsmaipá, illanc' aƚpalaic'ota. Imanc' ailopa'a co'e'eyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Lan soldado epenuf'me al tomí, uya'a'me ma licuxe'empola'. Itsiya litine ma' anuli tinesyi lan xanuc' judío. ");
INSERT INTO chdNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Limbamaj nuli ts'ilihuequi Jesús iye'me Galilea, icuaitsa ƚijuala petsi iƚque limipola' tiyeƚe. ");
INSERT INTO chdNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jiƚpiya ixim'me Jesús. Jahuay exc'onƚingoƚai'me. Hualca ixhueƚco'me, ticuayi: “¿Te maƚque Jesús o ocuena?” ");
INSERT INTO chdNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús iƚoc'ai'mola', timila': ―Joupa lapi'impa laimane, cacuxe jahuay lopa'a lema'a, jahuay lopa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Itsiya camilhuo': Tonƚeƚe jahuay li'a ƚamats'. Ni petsi lomanc'eyacu lan xanuc' tolu'itsola' laitaiqui', lihuejla'. Tolapo'itsola' ti'itsola' ixanuc' cai'Ailli' ȽanDios, jouc'a aixanuc', iya' i'Hua ȽanDios, jouc'a ixanuc' cal Espíritu Santo. Toƚiya toƚcuaj'mi'me lam fane' ƚaftine. ");
INSERT INTO chdNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Toƚmuc'itsola' tihuejcoƚe jahuay ƚataiquí laicuxe'epolhuo'. Aicapo'noyacolhuo' coƚtuca'. Itine itine aƚmajm'me anuli. Ticuaitsi Lijoujma Quitine ma toƚta'a aƚmajm'me.");
INSERT INTO chdNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Fa'a tipa'a liniƚiya lixpic'epa ȽanDios. Iƚe lataiqui' ac'a loya'apa, tipalaijma Jesucristo, iƚque ƚi'Hua ȽanDios. Cu'i'molhuo' te ts'i'ic' lipangopa luya'ampá iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jiƚpe lije'e cal profeta Isaías iniƚijmpa lo'iya. Iƚe liniƚpa tuya'e' te ts'i'ic' linespa ȽanDios, ticua: ¡Aƚquimf'eƚa'! Iya' cumme'ma ƚainepaluc, iƚque ticuaita ate'a, tilanc'e'eto' lopene. ");
INSERT INTO chdNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pe ailopa'a quiƚya' iƚque tuya'ata, tu'itola' lan xanuc' lafot'ƚeyacoƚtsi, tu'itola': “Toƚƚanc'e'eƚe lipene ƚaƚPoujna. Toƚ'e'eƚe aƚijca lane pe loyaicoya.” ");
INSERT INTO chdNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Licuaiyunni Juan Bautista enanƚpa iƚe lataiqui'. Maƚque Juan epaluc ȽanDios ƚipalaicopa Isaías. Icuaitsi Juan al pana' Jordán pe ailopa'a quiƚya'. Jiƚpe tepo'iyale. Tu'ila' tixhuej'menanca lo'epa lixcay. Tepoliƚe. ȽanDios tiƚonc'e'e'mola' liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lan xanuc' ni petsi lomana' al distrito Judea, jouc'a jahuay lan xanuc' nomana' liƚya' Jerusalén, ipalunca ƚiƚpiƚeloƚya', iye'me, icuaitsa pe lopa'a Juan. Uya'a'me li'epa lixcay. Ticuayi: “Aƚsuej'menamma”. Juan epo'i'mola' al pana' Jordán. ");
INSERT INTO chdNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iƚque Juan lipijahua' ipufcompa ipimij camello. Lifi'ejma ixmi. Ƚitejua' ƚotepa axa'muƚ y acujua c'ec. ");
INSERT INTO chdNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tuya'e', tu'ila': ―Iya' aicuai'ma ate'a. Tijouƚa' ticuaihuo ocuena xonca acueca'. Iya' aimaƚ'onspa to iƚque, caxina alaic'ata, aimi'iya cuhuaƚc'eya lic'eji'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iya' capo'icolhuo' aja', iƚque ticuaiyunni tepo'ico'molhuo' cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Iƚne ƚitiné Jesús ipanni al distrito Galilea, jiƚpe liƚya' Nazaret. Icuaitsi al pana' Jordán jiƚpe Juan epo'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lipanni Jesús laja', ixim'ma eximma lema'a, ixim'ma cal Espíritu Santo ti'onƚcospa to cal fujca ja'mu', imunni, icuaitsi pe lacaxu, ihuoxaf'caitsi. ");
INSERT INTO chdNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jesús icuej'ma jiƚpe lema'a tipalay, timi: ―Ima' mai'Hua, ca'ehuo' capic'a juaiconapa. Latenƚma lopicuejma' jouc'a lo'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lijou'ma aiquicoƚ'ma, cal Espíritu Santo i'hua'a'ma Jesús, icuaitsi pe ailopa'a quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jiƚpiya ipajntsi oquej nuxans quitine pe lomana' lan ximalo quinneja. Ƚonta'a Satanás ehuai'ma. Icuaitsa lapaluc' quema'a, itoc'i'me. ");
INSERT INTO chdNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lijoupa litats'empa Juan Bautista, Jesús ipanni al distrito Judea. I'hua'ma al distrito Galilea. Jiƚpe tuya'e' lixpic'epa ȽanDios, iƚe lataiqui' ac'a loya'apa. ");
INSERT INTO chdNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tu'ila' lan xanuc': ―Fa'a li'a ƚamats' ȽanDios cal Cuecaj Rey ticuxela' lixanuc'. Toƚsuej'menca. Tolapenufle Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Anuli litine Jesús ti'hua ƚema al cuecaj quin'nuhua' cuftine Galilea. Ixim'mola' Simón jouc'a Andrés, iƚque ipima Simón. Iƚne lapimaye in'noƚpá catuye, tecajm'miyi ƚiƚxami ƚaja. ");
INSERT INTO chdNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús timila': ―¡Lihuejla'! Capi'i'molhuo' ocuena coƚpenic'. Aimolahueconayacola' latuye. Tolahuetola' lan xanuc' lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aits'icoƚ'mola'. Simón jouc'a Andrés ipo'no'me ƚiƚxami. Ihuej'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iye'me nihuata, Jesús ixim'mola' Jacobo i'hua Zebedeo, jouc'a Juan, iƚque ipima Jacobo. Iƚne ticusc'oƚanna al barco, tipufmot'ƚeyi ƚiƚxami. ");
INSERT INTO chdNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aiquicoƚ'ma, Jesús ijoc'i'mola'. Iƚniya ipo'nom'mola' Zebedeo quiƚ'ailli' jouc'a no'epá canic' imanenca al barco. Ihuej'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iye'me liƚya' Capernaum. Litine conxajya i'hua'ma Jesús lajut'ƚ pe lafoƚyomma. Jiƚpiya imuc'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iƚne lan xanuc' ixim'me ac'a lomuc'iyalepa Jesús, ixim'me icueya limane. Ticuayi: ―Acueca' iƚque litaiqui'. Laƚpomxiye nomuc'iyalepá locuxepa ȽanDios, iƚne aimi'onƚspola' to Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jiƚpiya pe lafoƚyomma tipa'a anuli cal xans ƚitsufaipa conta'a. Cal xans ija'a'ma ujfxi. ");
INSERT INTO chdNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Timi: ―Ima' conJesús mas Nazaret, ¿te cof'epa? ¿Te cotsufaicomma ima' fa'a pe laƚmana'? ¿Te aga ocuai'ma fa'a ma le'a aƚjou'ne'monga'? Iya' nimetsaicohuo'. Ima' umPaxi, o'huayomma ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús itale'ma, timi: ―¡Ti‑ch'ixcotso'! ¡Taipanni iƚca'a cal xans! ");
INSERT INTO chdNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ƚonta'a ife'ne'ma ujfxi cal xans, ija'a'ma ujfxi, ipananni. ");
INSERT INTO chdNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lan xanuc' nomana' jiƚpe lajut'ƚ ixim'me acueca' li'ipa. Icuis'e'moltsi, timiyoltsi: ―¿Te jale iƚta'a lataiqui'? Iƚca'a Jesús ituca' lomuc'iyalepa. Icueya limane, jouc'a lontahue ticuxela', iƚne ticuec'eyi. ");
INSERT INTO chdNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aiquicoƚ'ma. Ixpehuaitsi lataiqui' loya'apa li'epa Jesús. Ni petsi al distrito Galilea icuej'me li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús jouc'a ts'ilihuequi, iƚniya Simón, Andrés, Jacobo y Juan, ipalunca lajut'ƚ pe lafoƚyomma, iye'me lilejut'ƚ Simón y Andrés. ");
INSERT INTO chdNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ƚi'maco Simón tunouya textafque. Tepi'i quipinu'. Aiquicoƚ'ma, u'i'me Jesús textafque ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús iƚoc'huai'ma pe lopa'a ƚaxtafpa. I'noƚ'e'ma limane. Icutsu'ma ƚafcuana. Iƚojn‑na'ma ƚipinu'. Ixaƚcona'ma. Itsahuenanni, ites'mi'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Iƚe litine joupa if'acoƚaipa i'ipa ipuqui', lan xanuc' iƚtaic' lilefcualƚay, jouc'a litsuflaiyila' contahue. ");
INSERT INTO chdNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jahuay lan xanuc' nomana' liƚya' icuaiyunca, efoƚunni lico lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús ixaƚ'mena'mola' axpela' lan xanuc', axpej cuana. Jouc'a icuxe'mola' lontahue tipalnanca lan xanuc'. Lontahue imetsaico'me Jesús. Iƚque ticua: “Lontahue aimuya'acona'me”. Toƚiya i‑ch'ixc'e'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Icuaitsi liƚic'ejma ma' aquipuqui', Jesús itsahuenni, ipanni liƚya', i'hua'ma petsi ailopa'a quiƚya'. Jiƚpe ipalaic'o'ma ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón jouc'a liƚejmale ehue'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ixim'me, timiyi: ―Lan xanuc' tehuehuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús timila': ―Ƚepá. Ƚepá ƚaiquiƚeloƚya' lan huejnca lomana'. Ticuicomma cu'itsola' jouc'a iƚniya Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ti'huaf'cay jahuay al distrito Galilea, ƚajut'ƚi pe lafoƚyomma lan xanuc', jiƚpe tu'iyale iƚe Lataiqui'. Tipa'e'ela' lan xanuc' liƚpontahue. ");
INSERT INTO chdNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Anuli litine icuaitsi pe lopa'a Jesús anuli cal xans iteca cahuí, iƚe al cuana cuftine al lepra. Iƚque exc'onƚingai'ma. Tixahue'e, timi: ―Ja'ni ima' opic'a, nipajnya aƚsaƚ'mena'ma laicuana. Aƚ'inƚa' limpio. ");
INSERT INTO chdNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ixim'ma acuanuc' ƚafcuana. I'nij'ma limane. Ixpayaf'ma, timi: ―Ne', aipic'a. Iya' caxaƚ'me'mo'. ¡Tixaƚcontso'! ¡Ti'intso' limpio! ");
INSERT INTO chdNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aiquicoƚ'ma, iƚojn‑na'ma lehui, ixaƚcona'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aiquicoƚ'ma, Jesús ixc'ai'i'ma, ");
INSERT INTO chdNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","timi: ―Aimo'itola' lan xanuc' iƚe lai'e'epo'. Aimoyout'ƚe'ma. Nij naitsi nocuejya. To'huanƚa', tomujxoxi pu'hua ƚa'ailli'. Totsufcota ȽanDios to Moisés licuxe'epola' ts'iƚƚepra, iƚne joupa i'inapola' limpio. Toƚta'a aƚsim'monga' lihuejcoyi iƚe litaiqui' Moisés. ");
INSERT INTO chdNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iƚque ƚixaƚconapa i'hua'ma, ipango'ma uya'a'ma li'e'epa Jesús. Toƚta'a Jesús aimi'iya mitsufaiya ƚiƚeloƚya'. Tipanemma petsi ailopa'a quiƚya'. Lan xanuc' quiyouyomma ni petsi ƚiƚeloƚya', tiƚcuaiyumma pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lijoupa luyaipa oquej fanej quitine, Jesús ipainanni, itsufaicona'ma liƚya' Capernaum. Lan xanuc' icuej'me Jesús tipa'a lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aiquicoƚ'ma icuaiyunca axpela' lan xanuc', efot'ƚe'moƚtsi. Imantsi lajut'ƚ jouc'a lico cajut'ƚ. Jesús tu'ila' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ocuenaye lan xanuc' icuaiyunca jiƚpe ƚuna. Amalujxi iƚniya iƚtaic' anuli ƚuhuaqueya xans. ");
INSERT INTO chdNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ipa'ne'mola' lefoƚya, aimi'iya muyalaicoyacu, micuaiyacu pe lopa'a Jesús. If'ajli'me lajut'ƚ, enai'e'me luhua'e lajut'ƚ jiƚpe al toncay pe lacaxu Jesús. Maƚpiya ecajm'mi'me cal xans ƚonafya ƚihuijm‑ma', ipo'ningaitsi li'mitsi' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús ixim'mola' iƚniya ti'huaiyijnyi, ticuayi: “Tixaƚ'mena'ma”. Timi ƚuhuaqueya: ―Mai'hua, joupa iƚojn‑napa lojunac'. ");
INSERT INTO chdNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ticutshuoƚanna jiƚpiya hualca lomxiye nomuc'iyalepá locuxepa ȽanDios. Iƚniya ticuayi liƚpicuejma': ");
INSERT INTO chdNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Iƚque cal xans, ¿te conescopa toƚta'a? Ma le'a quituca' ȽanDios nipajnya tiƚonc'e'e'mola' liƚjunac' lan xanuc'. Iƚque ti'onƚicoyoxi to ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús aiquicoƚ'ma i'i'ma quixina' te lonespa lan xanuc'. Timila': ―Imanc', ¿te coƚnescopa toƚta'a loƚpicuejma'? ");
INSERT INTO chdNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Pe copa'a xonca lipime? ¿Te cataiqui' caifmiya ƚafcuana? ¿Camiƚa': “Lojunac' joupa iƚojn‑napa”, o camiƚa': “Totsahuenanni, tonif'naƚa' ƚohuijm‑ma', to'huanƚa'”? ");
INSERT INTO chdNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Itsiya camuc'i'molhuo' icueya laimane. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ma capa'a fa'a li'a ƚamats' ti'i'ma quimenc'e'eco'mola' liƚjunac' lan xanuc'. Ipalaic'o'ma ƚuhuaqueya, timi: ");
INSERT INTO chdNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Iya' camihuo', totsahuenanni, tonif'naƚa' ƚohuijm‑ma', to'huanƚa' lomejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ƚuhuaqueya aiquicoƚ'ma itsahuenanni, inif'ma ƚihuijm‑ma'. Mehuelojnyi lan xanuc', ixim'me ipanni, i'huana'ma. Ixpailij'mola', tinesyi: ―Acueca' juaiconapa li'epa ȽanDios. Toƚta'a li'ipa aicaƚsina', ni anulemma. ");
INSERT INTO chdNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","I'huacona'ma Jesús ƚema al cuecaj quin'nuhua'. Jahuay lan xanuc' iye'me pe lopa'a. Timuc'ila'. ");
INSERT INTO chdNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lijoupa limuc'iyalepa, ti'hua tuyaipa, ixim'ma anuli cal xans cuftine Leví, i'hua Alfeo. Iƚque Leví ticutsu petsi lo'najts'i'iyaleyompa. Jesús timi: ―Lihuejla'. Leví itsahuenni, ihuej'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús jouc'a ts'ilihuequi icuaitsa lejut'ƚ Leví, ticutshuoƚanna, titetsoyi. Titetsoyi jouc'a axpela' lin'najtsi'iyale jouc'a ocuenaye lan xanuc'. Jahuay iƚniya a'i mihuejyi locuxepa ȽanDios. Axpela' iƚniya tihuejyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lomxiye nomuc'iyalepá locuxepa ȽanDios jouc'a lan xanuc' fariseo ehuelojm'me Jesús titetsoyi anuli lin'najts'i'iyale y locuenaye lan xanuc'. Imetsaiconnila' iƚne aimihuejyi locuxepa ȽanDios. Timinnila' ts'ilihuequi Jesús: ―Toƚsinƚe, ƚoƚpomxi titetsoyi anuli lin'najts'i'iyale y locuenaye lan xanuc'. Jahuay iƚniya aimihuejyi locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús icuej'ma lonespa iƚniya. Timila': ―Lan xanuc' ja'ni a'i mextafquila' aimicuicomma mi'e'enyacola' cafxi. Lafcualƚay ƚinca ticuicomma no'eyacola' cafxi. Iya' aicuaicoco'ma cajoc'i'mola' ts'iƚjunac'. Aicajoc'iyacola' petsi ailopa'a quiƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Anuli litine tixnet'ƚyi aimitetsoyi ts'ilihuequi Juan Bautista jouc'a lan xanuc' fariseo. Icuaitsa lan xanuc' pe lopa'a Jesús, timiyi: ―Ts'ilihuequi Juan jouc'a lan fariseo tixnet'ƚyi, aimitetsoyi. Iƚne lihuejhuo', ¿te aimixnet'ƚyi? ");
INSERT INTO chdNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús italai'e'e'mola', timila': ―Ma mipa'a ƚamijcano ƚamaneya, ¿te tixnet'ƚ'me, aimitetsoyacu ts'iƚejmale? A'i. Anuli miƚmana' ƚamaneya, aimi'iya mixnet'ƚyacu. ");
INSERT INTO chdNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ticuaihuo litine aimimajnconayacu anuli, iƚe litine ƚinca tixnet'ƚ'me. ");
INSERT INTO chdNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Al ts'e quijahua' aimi'iya manajmot'ƚicoya lafane quijahua'. Ja'ni toƚta'a to'eƚa', al ts'e quijahua' tetehuo, tijouƚa' lafane quijahua' tits'aƚquehuo xonca. ");
INSERT INTO chdNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aimoc'ej'miya al ts'e vino petsi lafanej ponta quixmi. Ja'ni to'etsi toƚta'a, al ponta quixmi tits'aƚquehuo, timinsco'ma al vino, timinsco'ma jouc'a al ponta quixmi. Al ts'e vino tic'ej'minni al ts'e ponta quixmi. ");
INSERT INTO chdNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Anuli litine conxajya, Jesús jouc'a ts'ilihuequi tuyalaicoyi nolojmay cal trigo. Muyalaicoyi, ts'ilihuequi ipango'me ipa'a'me ƚixpaj trigo. ");
INSERT INTO chdNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lam fariseo timiyi Jesús: ―¡Toxintsola' lihuejhuo'! Itsiya itine conxajya. Ailopa'a lane mi'eyacu toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús timila': ―Imanc', ¿te a'i coƚsuec' liniƚiya loya'apa li'epa cal rey David? Icuaitsi litine unle'enca iƚque jouc'a liƚejmale, ailopa'a cotejacu. ");
INSERT INTO chdNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David itsufai'ma lejut'ƚ ȽanDios. Jiƚpe tipa'a lam paxi ca'í. Iƚne la'í tipa'a lane tite'me ma le'a la'aillí, a'i lan xanuc'. David ite'ma jouc'a epi'i'mola' liƚejmale, ite'me. Toƚta'a i'ipa mipa'a Abiatar cal cuecaj ca'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús ti'hua tipalaic'ola' lan xanuc', timila': ―ȽanDios ate'a ilanc'epa cal xans, lijou'ma enaj'ma litine tunxajla' cal xans. A'i quenaqui litine ate'a. ");
INSERT INTO chdNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iya' cacuxe'ela' laixanuc' te lo'eyacu iƚe litine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ocuena quitine conxajya, Jesús itsufaicona'ma lajut'ƚ petsi lafoƚyomma lan xanuc'. Jiƚpe tipa'a anuli cal xans ijuƚpa limane. ");
INSERT INTO chdNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lam fariseo tehuelojnyi Jesús. Ti'huilaic'oyi ja'ni tixaƚ'me'ma cal xans iƚe litine conxajya. Tehueyi te co'iya micuxecoyacu. ");
INSERT INTO chdNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús ipalaic'o'ma cal xans, iƚque ts'ijuƚ quimane. Timi: ―To'huanni fa'a. Tacaxla', tahuoc'ocotsola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Icuis'e'mola' lam fariseo, timila': ―Lu'iƚa', litine conxajya, ¿te lapi'inga' lane aƚ'eƚe al c'a? O ¿aƚcuxe'enga' aƚ'eƚe lixcay? ¿Nipajnya lunƚu'e'me lipitine cal xans o aƚma'a'me? Iƚniya aiquiƚtalai'e. Ch'ix le'a. ");
INSERT INTO chdNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús ehuelojm'mola' iƚne lam fariseo. Tixtuc'ola'. Tixhueƚma, ixina' iƚniya joupa ipo'nopá liƚpicuejma', aiquiƚcueca. Jesús timi cal xans: ―To'nijla' lomane. Cal xans i'nij'ma limane. Ixaƚcona'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lam fariseo aiquicoƚ'mola', ipalunca, iye'me ipalaic'otsa lixanuc' cal rey Herodes. Tehueyi te co'iya mima'ayacu Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús i'huana'ma. Iƚque jouc'a ts'ilihuequi iye'me al cuecaj quin'nuhua'. Iyenc'e'me axpela' lan xanuc' quiyouyomma al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Lan xanuc' ni petsi lomana' icuej'me al cueca' lo'epa Jesús. Icuej'me iƚne nomana' al distrito Judea jouc'a nomana' al cuecaj quiƚya' Jerusalén, jouc'a nomana' ƚamats' Idumea, jouc'a nomana' ƚu'hua quiyay al pana' Jordán, jouc'a nomana' ƚilemats' ƚiƚeloƚya' Tiro y Sidón. Axpela' iƚniya icuaiyunca pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lixim'mola' axpela' quefoƚya Jesús icuxe'e'mola' ts'ilihuequi ti'hua'anca anuli al barco, tipo'noƚe ƚema al cuecaj quin'nuhua'. Ja'ni lan xanuc' tipango'me titantsi'me Jesús, iƚque titsufai'ma al barco. ");
INSERT INTO chdNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Joupa axpela' ixaƚ'mepola', toƚiya itsiya jahuay lafcualƚay, axpej cuana, tummetsaiyoƚtsi, tiyeƚe ahuejnca Jesús, tiƚafle. ");
INSERT INTO chdNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lan xanuc' pe litsufaiyila' contahue, lixim'me Jesús, ecanghuoƚaitsa li'mitsi'. Lontahue tija'ayi, timiyi: ―Ima' i'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús itale'mola' ujfxi. Timila': ―Aimunlu'itola' lan xanuc' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lijou'ma if'aj'ma ƚijuala. Joupa ixpic'epa naiƚniya ts'ilihuequi tiyouyunca. Ijoc'i'mola'. Icuaitsa pe lopa'a. ");
INSERT INTO chdNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I'huijf'e'mola' imbamaj coquexi' timajnle anuli. Tumme'mola' tuya'ata Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Epi'i'mola' liƚmane tipa'ata lontahue litsufaiyila' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jifa'a tipa'a liƚpuftine iƚniya limbamaj coquexi': Simón, ƚecui'impa Pedro, ");
INSERT INTO chdNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo y Juan, inaxque' Zebedeo. Iƚne loquexi' Jesús lecui'ipola' Boanerges. Iƚe laftine locuajmaispa: Iƚne noquimf'epá, nocuec'epá lonespa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés y Felipe, Bartolomé y Mateo, Tomás y ƚocuena Jacobo, iƚque i'hua Alfeo, Tadeo y ƚocuena Simón, iƚque ƚecui'impa cal cananeo, ");
INSERT INTO chdNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jouc'a Judas Iscariote, iƚque nocuya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesús itsufaipa anuli lajut'ƚ. Efot'ƚecona'moƚtsi axpela' lan xanuc'. Jesús jouc'a ts'ilihuequi aiqui'i'ma quitetso'me. ");
INSERT INTO chdNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Licuejpá lipimaye Jesús toƚta'a li'ipa, ines'me: Jesús iminscopa lipicuejma'. Ipalunca, iye'me, tileconna Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jiƚpe pe lopa'a Jesús timana' hualca lomxiye nomuc'iyalepá locuxepa ȽanDios, quiyouyomma liƚya' Jerusalén. Iƚniya ticuayi: ―Jesús itsufaipa ƚonta'a cuftine Beelzebú. Iƚque nocuxepola' contahue epi'ipa limane Jesús tipa'atsola' lontahue. ");
INSERT INTO chdNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús ijoc'i'mola' iƚniya lomxiye, timila': ―¿Te caƚtalai'e'eya imanc'? ¿Te aga ƚonta'a Satanás tihuescuf'ma ƚipima conta'a? Ti'hua tipalaic'ola'. I'onƚicopa to lo'ipa. Timila': ");
INSERT INTO chdNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","―Ja'ni tenajtsoƚtsi lan xanuc' anuli al nación, ja'ni ti'etsoƚtsi oque', iƚe al nación tijou'ma lipujfxi. ");
INSERT INTO chdNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ja'ni lan xanuc' nomana' anuli lajut'ƚ tenajtsoƚtsi, ja'ni ti'etsoƚtsi oque', aimimajnconayacu anuli, jiƚpe teca'nena'moƚtsi, ailopa'a co'eyacu. ");
INSERT INTO chdNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ƚonta'a Satanás ja'ni joupa ehuoc'huaipola' lif'as contahue, itsiya coƚa' aimi'hua limane. ");
INSERT INTO chdNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ja'ni anuli cal xans ixpic'epa titsufaiƚa' lejut'ƚ ocuena cal xans juaiconapa ipujfxi, ja'ni ixpic'epa tiƚonc'e'eƚa' ƚi'huexi, iƚque notsufaiya, ate'a tifi'eƚa' iƚque cal xans ts'ipujfxi, tijouƚa' nipajnya titsufai'ma, tiƚonc'e'eta ƚi'huexi. Ja'ni aimifi'e, aimi'iya mitsufaiya lajut'ƚ, miƚonc'e'eya ƚi'huexi. ");
INSERT INTO chdNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Iya' camilhuo' al ƚinca: Jahuay lo'epa o lonespa cal xans, ti'i'ma timenc'e'ecom'me. ");
INSERT INTO chdNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma le'a ja'ni aimimetsaicoyi lo'epa cal Espíritu Santo, iƚniya aimiƚonc'e'enyacola' liƚjunac'. Titai'me nulemma. ");
INSERT INTO chdNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Toƚta'a Jesús limipola' iƚniya nonespá: “Jesús itsufaipa conta'a”. ");
INSERT INTO chdNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Icuaiyunca qui'máma' jouc'a lipimaye Jesús. Ecaxoƚ'me ƚuna. Iƚojf'i'me anuli cal xans tijoc'itsi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesús ticusc'o nolojmay cajut'ƚ, timuc'iyale. Jiƚpiya timana' axpela' lan xanuc' ticutshuoƚanna tiquimf'eyi lomuc'ipola' Jesús. Timiyi: ―Co'máma' jouc'a lopimaye timana' ƚuna tehuehuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús timila': ―¿Naitsi cai'máma'? ¿Naiƚne caipimaye? ");
INSERT INTO chdNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ehuelojm'mola' lan xanuc' nocutshuoƚanna, ticua: ―¡Toƚcuejle! Jifa'a ticutshuoƚanna cai'máma' jouc'a laipimaye. ");
INSERT INTO chdNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pe naihuejcopa ȽanDios, iƚquiya aipima xans, o aipima caca'no', o ai'máma'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mipa'a Jesús ƚema al cuecaj quin'nuhua', ipango'ma imuc'icona'mola' lan xanuc'. Efoƚunni juaiconapa axpela'. Jesús if'aj'ma anuli al barco. Icutshuai'ma jiƚpiya. Al barco texpef'que. Lan xanuc' efoƚumma ƚema caja. ");
INSERT INTO chdNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Juaiconapa imuc'i'mola' lan xanuc'. Ipalaico'ma lo'epa ȽanDios fa'a li'a ƚamats'. I'onƚico'ma. Timila': ");
INSERT INTO chdNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Aƚquimf'eƚa' imanc': ’Icuai'ma litine cafaya, i'hua'ma cal xans tifata. Eca'nitsi lam fanuj trigo. ");
INSERT INTO chdNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Meca'ni lam fanuj trigo, oquej afane' lam fanu' ecangenni lane. Icuaiyunca lacaƚ'hui naiyulpá, itejn‑na'me. ");
INSERT INTO chdNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","’Oquej afane' lam fanu' i'nif'coƚaitsa ƚixmi capic, tipa'a ahuata ƚacamats'. Lam fanu' aiquicoƚ'mola' ila'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lijou'ma ipammaiyunni cal 'ora, ƚinu' ipi'epola' lilapola' lam fanu'. Ijuƚnapola'. Aiquif'acaic' ƚime. ");
INSERT INTO chdNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","’Hualca lam fanu' itsuc'huaita jiƚpe ƚitac'. Litoj'ma ƚitac', ejec'opola' laifa'. Aiquixpaj'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","’Ocuenaye lam fanu' etojmoƚaitsa cal c'a camats'. Ila'mola', itoj'mola', i'ipola' quixpa. Anuli ƚajfanu' ipammaitsi anuxans quimbama', ocuena cal fanu' ipammaitsi afanej nuxans, ocuena'ya ipammaitsi amaxnu. ");
INSERT INTO chdNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lijoupa luya'apa iƚe litaiqui', Jesús timila': ―Naitsi nocuejpa, aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lijoupa liyeyoƚnapá lan xanuc', imanenca Jesús jouc'a limbamaj coquexi' y locuenaye ts'ilihuequi. Iƚniya ixa'hue'me Jesús, timiyi: ―Lu'itsonga', luhuaƚc'e'etsonga' iƚe lotaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús timila': ―ȽanDios epalc'o'ipolhuo' imanc' loƚpicuejma', toƚta'a toƚcuec'eyi lipime cataiqui'. Iƚe lataiqui' tuya'e' lo'ipa petsi lan xanuc' tihuejcoyi ȽanDios, iƚque cal Cuecaj Rey. Ocuenaye lan xanuc' petsi aimihuejcoyi ȽanDios, iƚne ma le'a tiquimf'eyi. Iƚe lataiqui' lo'onƚicopa lo'epa ȽanDios iƚne lan xanuc' aimi'iya mihuaƚc'eyacu. ");
INSERT INTO chdNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Toƚta'a ti'iƚa' to loya'apa al Paxi Liniƚingiya, ticua: Ti'hua tehuelojnle, tijouƚa' aimixinyacu. Ti'hua tiquimf'eƚe, tijouƚa' aimicuejyacu. Ja'ni a'i toƚta'a liƚ'ejma' tixhuej'menacu, ȽanDios timenc'e'eco'mola' lixcay li'epá. ");
INSERT INTO chdNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús ti'hua tipalaic'ola', timila': ―Ja'ni aicoƚcueca iƚe laitaiqui' lai'onƚicopa lo'epa ȽanDios fa'a li'a ƚamats', ¿te co'iya moƚcuec'eyacu ja'ni ca'onƚico'ma xonca lo'epa ȽanDios? ");
INSERT INTO chdNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","’Cal xans nofapa ti'onƚcospa to iƚquiya noya'apa litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ƚamats' lane pe lecangeyonni lam fanu' ti'onƚcospa to lan xanuc' iƚniya ma le'a tiquimf'eyi litaiqui' ȽanDios. Aimicoƚya ƚonta'a Satanás. Ticuaihuo, tiƚonc'e'e'mola' lataiqui' lifayipa liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","’Ƚaj huata ƚacamats' ƚopa'a ƚixmi capic ti'onƚcospa to locuenaye lan xanuc' miquimf'eyi litaiqui' ȽanDios tixoqui quileta tepenufyi. ");
INSERT INTO chdNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Iƚe Lataiqui' aimifayiya liƚpicuejma', oquej fanej quitine tihuejcoyi. Ticuaitsi lixhuejma', o liƚf'as xanuc' tixtuc'ontsola' iƚniya naihuejpá litaiqui' ȽanDios, iƚne aimicoƚyacola', tenajna'moƚtsi, aimihuejconayacu. ");
INSERT INTO chdNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Ƚamats' pe ƚopa'a ƚitac' litsuc'huaita lam fanu' ti'onƚcospa to locuenaye lan xanuc' noquimf'epá litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Iƚne xonca tixhuej'mecoyi te co'iya muyalaiyacu lapajnya. Tifel'miyoƚtsi, ticuayi: “Lulijle acuecaj caƚtomi. Toƚta'a luyalaico'me al c'a.” O tixhuej'mecoyi te co'iya mulijyacu xonca quiƚ'huexi. Ma to ƚitac' ejec'opola' ƚaifa', a'i quixpaj'ma, ma toƚe iƚne lan xanuc' li'ipola'. Tama joupa ifapa liƚpicuejma' litaiqui' ȽanDios, tiƚmanemma toƚta'a, tocomma a'i quilepenufi iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","’Cal c'a camats' pe lifampa ti'onƚcospa to locuenaye lan xanuc' noquimf'epá litaiqui' ȽanDios. Iƚne tepenufyi iƚe lataiqui', tipammoƚaispa liƚpepajnya. Hualca ti'onƚcospa to ƚamats' petsi cal fanu' ƚipammaita anuxans quimbama', locuenaye petsi ƚipammaita afanej nuxans, locuenaye petsi ƚipammaita amaxnu. ");
INSERT INTO chdNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jouc'a timila': ―Imanc' molunai'i'me loƚpepalc'o', aimoƚc'ommumijyacu alxpicoƚma c'ec, ni aimoƚ'nicoyacu licu'u hualfa. Toƚ'nof'e'me pe loƚxu'epa. ");
INSERT INTO chdNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ticuaihuo litine ti'huájta lemiya, jouc'a ti'huájnata letemiquiya, tixinim'me. ");
INSERT INTO chdNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","’Naitsi nocuejpa, aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ti'hua timuc'iyale, tu'ila': ―Toƚpo'noƚe cuenna laifmipolhuo': Imanc' iƚe loƚspic'ecopola' locuenaye, toƚta'a iƚniya tepi'icona'molhuo'. Xonca axpe' tepi'im'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Cal xans ts'i'hueca, xonca tepi'im'me. Ƚocuena, ja'ni aiqui'hueca, texic'ena'me. ");
INSERT INTO chdNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jouc'a tu'ila': ―Iƚe li'ipa anuli cal xans ƚeca'nipa lam fanuj trigo ƚemats', ti'onƚcospa to lo'ipa petsi ȽanDios cal Cuecaj Rey tijoc'ila' lan xanuc' tihuejle. ");
INSERT INTO chdNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lijoupa leca'nipa ƚitrigo, cal xans ti'hua tuyaijma lapajnya. Lipuqui' tixmay, litine titsahuemma, lam fanu' tilá, titoqui ƚaifa'. Cal xans aiquixina' te co'ipa mitoj'ma ƚaifa'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ƚamats' quituca' timaf'i'i' ƚaifa'. Ate'a titoqui, tijouƚa' tixpaqui, tijouƚa' tumfumma lixpa, titoqui ƚifanu'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lunta'amma lixpa cal xans ixina' joupa icuai'ma litine tefot'ƚeta cal trigo. Aimicoƚya, tetejta. ");
INSERT INTO chdNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jouc'a tu'ila': ―¿Te caƚ'onƚicoyacu lo'ipa petsi ȽanDios tijoc'ila' lan xanuc' timetsaicoƚe, tihuejle iƚque cal Cuecaj Rey? ¿Te ts'i'ic' maƚ'onƚicoyacu? ");
INSERT INTO chdNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","’Lo'ipa jiƚpe ti'onƚcospa to lo'ipa cal fanu' sinapí. Mifam'me, i'huáqui tuquini ƚajfanu'. Petsi jahuay cal fanu' ƚofampa ƚamats', ailopa'a xonca caca'hua. ");
INSERT INTO chdNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lijoupa lifampa tila'ma, titoj'ma acueca' ƚaifa'. Ailopa'a quitamqui mitoqui to iƚta'a lifampa. Ƚimané itoqui, atsila'. Lacaƚ'hui naiyulpá tunxajyoyi jiƚpe lipunxahua. ");
INSERT INTO chdNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ma to iƚna'a ƚataiquí toƚta'a juaiconapa i'onƚico'ma lo'epa fa'a li'a ƚamats' ȽanDios cal Cuecaj Rey. Lo'huajcocoyacola' liƚpicuejma' toƚta'a timuc'ila' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ti'hua ti'onƚijma iƚe lo'epa ȽanDios. Aimipalay acuajmaica. Jesús y ts'ilihuequi limanenca quiƚtuca', iƚque tuhuaƚc'e'ela' lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Maƚe litine joupa if'acoƚaipa timila' ts'ilihuequi: ―Aƚqueƚe al cuecaj quin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesús joupa icutshuaipa al barco. Ts'ilihuequi Jesús ipo'nom'mola' lan xanuc' lefoƚya jiƚpiya, if'ajli'me jouc'a al barco. Ipango'me iquie'me al cuecaj quin'nuhua'. Ocuenaye lam barco jouc'a tiquieyi. ");
INSERT INTO chdNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aiquicoƚ'ma, i'hua'ma ujfxi ƚahua'. Itsahuenni laja', ic'ejmaitsi caja', imantsi al barco. ");
INSERT INTO chdNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús tunouya lipo al barco. Tixmay, unaf'caipa al ponta quijahua'. Ts'ilihuequi ummef'me, timiyi: ―Momxi, aƚma'a'monga' laja'. ¿Te aimaƚsueƚcoconga'? ");
INSERT INTO chdNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús itsahuenni, itale'ma ƚahua', timi laja': ―Ch'ixca. Aimofe'necona'ma. I‑ch'ixco'ma ƚahua'. Ipanenni. ");
INSERT INTO chdNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús timila' ts'ilihuequi: ―¿Te coxpailijcopolhuo'? ¿Te qui'ipolhuo'? ¿Te aimaƚ'huaiyinge? ");
INSERT INTO chdNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ixpailijpola' juaiconapa iƚniya ts'ilihuequi. Timiyoƚtsi: ―¿Naitsi xans iƚca'a? ¡Jouc'a ƚahua', ƚaja ticuec'eyi iƚque locuxe'epola'! ");
INSERT INTO chdNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Icuaitsa ƚocuena ƚema caja jiƚpe ƚilemats' lan xanuc' gadareno. ");
INSERT INTO chdNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ipanni Jesús al barco. Aiquicoƚ'ma, icuaico'ma anuli cal xans qui'huayomma jiƚpiya lamuhuoƚanna lomanapola'. Iƚque cal xans ƚitsufaipa conta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lipanga jiƚpe lamu'empola' lomanapola'. Aimi'iya mifi'enyacu ni cadena catejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tifi'econni acadena, inic'e'econni atejma' limane li'mitsi'. Iƚque tits'aƚquinghua lan cadena, tixquetsufinghua latejma'. Ailopa'a cal xans ts'ipujfxi xonca. Ailopa'a nolijya. ");
INSERT INTO chdNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ipuqui' itine tipa'a pe lamu'empola' lomanapola', jouc'a pe ƚijualay, tija'e', tits'aƚyoxi capic, tixcai'eyoxi. ");
INSERT INTO chdNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cal xans ixim'ma icuaico'ma Jesús aculi'. Aiquicoƚ'ma, i'hua'ma italecuftsi, exc'onƚingai'ma li'mitsi' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ija'a'ma ujfxi, timi: ―Jesús, ima' i'Hua cal Cuecaj ȽanDios Nopa'a lema'a, ¿te cocuaiyoco'ma? ¿Te ts'opic'a fa'a? Iya' cacuaj'mi'ma lipuftine ȽanDios, caxa'huehuo' aimaƚteƚ'mi'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Toƚta'a linespa ƚonta'a. Jesús joupa imipa: ―¡Ima' monta'a, taipanni iƚca'a cal xans! ");
INSERT INTO chdNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús icuis'e'ma, timi: ―¿Te muftine? Italai'e'e'ma, timi: ―Laipuftine Legión. Illanc' ninc'xpela'. (Lataiqui' “legión” tuya'e', ticua: Axpela'.) ");
INSERT INTO chdNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Juaiconapa tixa'hue Jesús, timi: ―Aimalipa'a'monga' jifa'a. ");
INSERT INTO chdNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jiƚpe ƚaquemala timana' juaiconapa axpela' lijná tehueyi quiƚtejua'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lontahue ixahue'me Jesús, timiyi: ―Lummetsonga' pe lomana' iƚne lijná. Jiƚpe aƚtsuflaita lijná. ");
INSERT INTO chdNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús epi'i'mola' lane. Lontahue ipalunca iƚque cal xans, itsuflai'me lijná. Iƚniya lijná timana' to oquej mil. Inul'me, imul'me al'ocay. If'alcoƚai'me laja'. Unxaƚac'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lan xanuc' linhuic'ipola' quijná inul'me. Jiƚpe liƚpiƚya' jouc'a calx'huiyaƚma' uya'atsa iƚe' li'ipa. Lan xanuc' ipalunca tehuelojnta. ");
INSERT INTO chdNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Icuaitsa pe lopa'a Jesús, ixim'me cal xans, iƚque coƚta ƚitsufaipa axpela' contahue, ticutsu, ipo'nohuo lipijahua', i'inapa lipicuejma'. Lan xanuc' ixpailij'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Iƚne niximpá li'ipa uya'a'me te qui'ipa lixaƚconapa cal xans, iƚque ƚitsufaipa contahue. Uya'a'me te qui'ipola' lijná. ");
INSERT INTO chdNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lan xanuc' ipango'me ixa'hue'me Jesús tipanni ƚilemats', ti'huanƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús if'ajna'ma al barco, ti'huana'ma. Cal xans li'ipa ƚitsufaipa contahue tixa'hue, timi: ―Aƚƚecoƚa' jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús aiquepi'i' lane. Timi: ―To'huanƚa' lomejut'ƚ, jiƚpe lomana' lopimaye. To'itsola' al cueca' li'e'epo' ȽanDios. Tomitsola' te ts'i'ic' liximpo' cuanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Cal xans i'huana'ma, itsehuo'ma petsi lecui'impa: Limbamaj Quiƚeloƚya'. Jiƚpiya u'i'mola' lan xanuc' li'e'epa Jesús. Lan xanuc' ixim'me acueca' li'epa Jesús, ixpailij'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús iquiecona'ma al cuecaj quin'nuhua'. Licuaiyocontsi al barco ƚocuena ƚema, icuaitsa axpela' lan xanuc', efot'ƚe'moƚtsi anuli Jesús ƚema caja. ");
INSERT INTO chdNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jiƚpiya icuaitsi anuli cal xans ipenic' lajut'ƚ pe lafoƚyomma lan xanuc'. Cuftine Jairo. Lixim'ma Jesús, exc'onƚingai'ma li'mitsi', ");
INSERT INTO chdNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tixa'hue juaiconapa, timi: ―Ƚai'hua cahuats' juaiconapa textafque. Timana'ma. Ƚepá. Ma le'a toxpayaf'ta lomane, toxaƚ'menna, ti'hua tipajnla'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iye'me Jesús jouc'a Jairo. Axpela' lan xanuc' ihuej'me. I'i'mola' atansca, titantsinni Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jiƚpe tipa'a anuli ƚaca'no' textafque. Imbamaj coque' camats' ti'hua cajuats' licu'u. ");
INSERT INTO chdNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iteƚcopa juaiconapa. Axpela' lin'e'ehuale cafxi iteƚ'mipá. I'najtsepola' iƚniya, joupa ijou'nenapa li'hueca. Aiquixaƚma. Ti'hua titsípa licuana. Iƚque ƚaca'no' icuejpa lo'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nolojmay xanuc' iƚoc'huaipa lixpula' Jesús. Iƚafc'e'e'ma lipijahua'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iƚque tinesqui lipicuejma': “Ma le'a lipijahua' caƚafla', toƚe aƚsaƚcona'ma”. Tot'ƚiya iƚafc'e'epa lipijahua' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aiquicoƚ'ma, ipanenni licu'u. Ixim'moxi ixaƚconapa. Aimiteƚcoconaya. ");
INSERT INTO chdNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aiquicoƚ'ma, Jesús ixingufco'ma lipaxi ixaƚ'meyalepa. Ipai'e'moxi nolojmay xanuc', icuis'e'mola', timila': ―¿Naitsi ƚaƚ―lafpa? ");
INSERT INTO chdNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ts'ilihuequi italai'e'e'me, timiyi: ―Ima' oxina' jifa'a axpela' lan xanuc' titantsihuo', ¿te cofmicuitsufcopa: “¿Naitsi ƚaƚ―lafpa?”? ");
INSERT INTO chdNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús ti'hua tehuetsale ƚijuihuay. Tehuay naitsi iƚque ƚiƚafpa. ");
INSERT INTO chdNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ƚaca'no' tixpaiqui juaiconapa, tiyu, iximpoxi ailopa'a quicuana. Iƚoc'huai'ma, exc'onƚingai'ma li'mitsi' Jesús. Imi'ma Jesús al ƚinca. Tuya'e' te ts'i'ic' lixaƚconapa, timi: ―Aiƚafpo' lopijahua'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús timi: ―Mai'hua, aƚ'huaiyijmpa, toƚiya ixaƚconapo'. Aimoxhueƚmot'ƚe'ma. Iƚe al cuana aimiteƚ'miconayaco'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma mipalaic'o ƚaca'no', icuaiyunca lan xanuc' quiyouyomma lejut'ƚ Jairo, iƚque ts'ipenic' lajut'ƚ pe lafoƚyomma lan xanuc'. Timiyi Jairo: ―Joupa imanapa ƚo'hua. ¿Te ti'hua cofxoc'icoya ƚomxi? ");
INSERT INTO chdNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús icuej'ma lu'impa Jairo. Timi: ―Aimixpaij'mo'. Ma le'a aƚ'huaiyijnla'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús ileco'mola' Pedro, Jacobo, jouc'a Juan, iƚque ipima Jacobo. Timila' locuenaye xanuc' aimiyoucu. ");
INSERT INTO chdNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Icuaitsa lejut'ƚ cal xans, iƚque ts'ipenic' lajut'ƚ pe lafoƚyomma lan xanuc', Jesús ehuelojm'mola' lo'epa lan xanuc', tijolijyi, tija'ayi. ");
INSERT INTO chdNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Itsufai'ma lajut'ƚ, timila': ―¿Te coƚja'acopa? ¿Te coƚjolijcopa? Ƚahuats' aiquimac', ma le'a tixmay. ");
INSERT INTO chdNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aiquiƚ'aic' ƚinca. Ma le'a ixoco'me. Jesús timila': ―Jahuay imanc' tolipalunca. Ileco'mola' qui'ailli', qui'máma' ƚahuats', jouc'a lam fantsi ts'ilihuequi. Itsuflai'me pe lonouya ƚahuats'. ");
INSERT INTO chdNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesús i'noƚ'e'e'ma limane ƚahuats', timi: ―Talitá kumi. (Iƚe lataiqui' lohuaƚquemma ticua: Macahuats', camihuo', totsahuenni.) ");
INSERT INTO chdNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aiquicoƚ'ma, ƚahuats' itsahuenanni, ipango'ma i'hua'ma. Ixhuaita imbamaj coquej ƚemats'. Iƚne lan xanuc' lixim'me li'ipa ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús juaiconapa ixc'ai'i'mola', timila': ―Aimoluya'ata lai'e'epa ƚahuats'. Nij naitsi nocuejya. Lijoupa limipola' toƚta'a, icuxe'e'mola', timila': ―Toƚtes'miƚe ƚahuats'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús ipanni jiƚpiya, icuaitsi lipiƚya'. Jouc'a ts'ilihuequi iye'me. ");
INSERT INTO chdNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Licuaitsi litine conxajya itsufai'ma lajut'ƚ pe lafoƚyomma lan xanuc'. Jiƚpe ipango'ma imuc'iyale'ma. Licuej'me iƚe litaiqui', axpela' lan xanuc' etenƚcoco'mola', timiyoƚtsi: ―Iƚque cal xans, ¿naitsi lepi'ipa lipicuejma'? ");
INSERT INTO chdNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Te maƚque ƚinc'alhuaƚpa? O ¿a'i iƚque? ¿Te iƚque i'hua María? ¿Te a'i iƚquiya iƚpima Jacobo, José, Judas y Simón? Fa'a jouc'a timana' lipimaye cacaƚ'no'. Iƚniya lan xanuc' aiquicuaitsi quiƚpic'a lo'epa Jesús, etets'i'me. ");
INSERT INTO chdNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús timila': ―Anuli cal xans ƚummepa ȽanDios, mipa'a ocuena quiƚya' pe lomana' locuenaye lan xanuc', iƚniya ticuaispa quiƚpic'a lo'epa iƚque. Tipainanni, ticuaitsi lipiƚya' pe lomana' lixanuc', lopa'a lejut'ƚ, jiƚpe ƚinca tetets'ita. ");
INSERT INTO chdNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mipa'a Jesús lipiƚya' aiqui'aic' cueca' jiƚpe. Ma le'a ixpayaf'mola' oquexi' afantsi lafcualƚay, ixaƚ'me'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ixim'mola' iƚne lipiƚya' xanuc' aiquiƚ'huaiyinge. Ixhueƚco'ma juaiconapa. I'hua'ma ehuentsola' ƚaiquiƚeloƚya' anujnca. Jiƚpe imuc'itsola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iƚne ƚitiné ijoc'i'mola' limbamaj coquexi' ts'ilihuequi. Iƚne icuaiyunca, ipango'ma umme'mola' tiyeƚe oquexi' oquexi'. Epi'i'mola' liƚmane tipa'atsa lontahue. ");
INSERT INTO chdNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tixc'ai'ila', timila': ―Tonƚeƚe, toƚtai'me ma le'a loƚpaluc. Aimoƚtai'me cumla'i. Aimoƚ'nij'mi'me tomí jiƚpe loƚfi'ejma loƚcu'u. ");
INSERT INTO chdNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Toƚc'uaicoƚe ƚoƚc'ejí. Aimoƚpo'no'me oque' loƚtsamalo, ma le'a anuli. ");
INSERT INTO chdNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Lajut'ƚ petsi tepenuftsolhuo', moƚmana' jiƚpiya liƚya', maƚpe toƚmajntsa. ");
INSERT INTO chdNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ja'ni toƚcuaitsa petsi aimepenufinnilhuo', ni aimiquimf'ennilhuo', imanc' tulunafle loƚ'mitsi', tipanni iƚque ƚamats' ƚitaƚijmpa loƚc'eji'. Toƚta'a ti'iƚa' quiƚsina' ma iƚne quiƚtuca' ti'najtse'me liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ts'ilihuequi ipalunca, uya'a'me Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. U'iyale'me tixhuej'menanca lixcay lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ipa'a'me axpela' lontahue. I'ot'ƚi'me laceite axpela' lafcualƚay. Iƚniya ixaƚcona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ni petsi lomana' lan xanuc' tipalaicoyi lo'epa Jesús. Cal rey Herodes jouc'a icuej'ma lo'epa. Timana' lan xanuc' nocuapá: ―Jesús iƚquiya aJuan Bautista, joupa imaf'inapa ipanamma pe lomana' limanapola'. Toƚta'a juaiconapa apaxi iƚque, ti'ay acueca'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ocuenaye ticuayi: ―Iƚque aElías, icuaiyocona'ma fa'a li'a ƚamats'. Ocuenaye ticuayi: ―Iƚque aprofeta ƚummepa ȽanDios, ti'onƚcospa to lam profeta limajmpá fa'a luyaipa quitine. ");
INSERT INTO chdNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Li'i'ma quixina' Herodes iƚe lonespa lan xanuc', iƚque ines'ma: ―Iƚque ma Juan Bautista. Ƚinca aicuxe'ma etec'em'me ƚejoc', joupa imaf'inapa. ");
INSERT INTO chdNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodes joupa exic'e'epa ƚipeno ƚipima Felipe. Iƚquiya ƚaca'no' cuftine Herodías. Ilecopa. Juan timi Herodes: “O'epa quixcay. ¿Te comexic'e'ecopa ƚipeno ƚopima? ¿Te colecocopa? Iƚque a'i copeno. Ipeno ƚopima.” Juan limi'ma toƚta'a ixtunni Herodes. Icuxepa i'noƚintsa, ifi'entsa, itats'entsa. ");
INSERT INTO chdNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ƚaca'no' Herodías ti'ay quipilaic' Juan. Ijanaj'ma tima'anƚe. Aiqui'ic'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Cal rey Herodes tixpaic'e Juan. Imetsaico'ma ac'a xans. I'epa cuenna. Ti'hua tiquimf'e lonespa Juan. Tama aiquicueca, ticuaispa quipic'a litaiqui' Juan. ");
INSERT INTO chdNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodías joupa iximpa lo'eya tima'anƚe Juan. Herodes lixhuaita ƚemats' i'e'ma juic. Iƚiya lipuqui' titetsoyi anuli lijoc'ipola', iƚne lan tsila' quiƚpenic', jouc'a lincuxepá soldado, jouc'a lan tsila' xanuc' nomana' al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jiƚpiya lefoƚya itsufai'ma ƚi'hua caca'no' Herodías. Ixau'ma. Icuaitsi quiƚpic'a Herodes jouc'a lijoc'ipola', iƚne nocutshuoƚanna jiƚpiya. Cal rey timi ƚahuats': “Aƚsahue'eƚa' jale ts'opic'a, capi'i'mo'”. ");
INSERT INTO chdNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","I'e'ma jurar, icuaj'moxi: “Iƚe laƚsahue'eya, tama ti'iƚa' onƚca laifcuxepa, capi'i'mo'”. ");
INSERT INTO chdNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ipanni ƚahuats'. I'hua'ma, icuaitsi pe lopa'a qui'máma', timi: “¿Te caifxahue'eya?” Qui'máma' timi: “Toxahue'etsi tepi'intso' ƚijuac Juan, tetoj'minƚe al cuecaj pime”. ");
INSERT INTO chdNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aiquicoƚ'ma, ƚahuats' ipanni, i'huacona'ma ixintsi cal rey. Ixahue'e'ma, timi: “Lapi'iƚa' ƚijuac Juan Bautista, to'nij'miƚa' anuli al pime”. ");
INSERT INTO chdNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cal rey ixhueƚconni juaiconapa. ¿Te co'eya? Aimi'iya micuanac'eya loxahue'epa ƚahuats'. Lan xanuc' nocutshuoƚanna jiƚpiya joupa icuejpá licuajpoxi. ");
INSERT INTO chdNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aiquicoƚ'ma, umme'ma anuli ƚisoldado, icuxe'ma, timi: “Totaitsi ƚijuac Juan”. Cal soldado i'hua'ma, icuaitsi la carza, etec'etsi ƚejoc' Juan, ");
INSERT INTO chdNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","i'nij'mitsi al pime ƚijuac, uhui'i'ma ƚahuats'. Ƚahuats' i'hua'ma pe lopa'a qui'máma', uhui'itsi. ");
INSERT INTO chdNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ts'ilihuequi Juan icuej'me toƚta'a li'ipa. Icuaitsa pe lima'ayompa Juan, itaina'me licuerpo, emunatsa. ");
INSERT INTO chdNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ts'ilihuequi Jesús icuainanca pe lopa'a Jesús, efot'ƚecona'moƚtsi. Joupa iyehuo'me uya'a'huo'me Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. U'i'me jahuay li'ehuo'me, jahuay limuc'iyalehuo'me. ");
INSERT INTO chdNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús timila': ―Ƚepá illanc' caƚtuca'. Ƚepá pu'huanni pe ailopa'a quiƚya'. Lunxajta. Jiƚpe pe lomana' Jesús jouc'a ts'ilihuequi, lan xanuc' tiƚcuaispa, tiyenayi. Aimi'iya mitetsoyacu, ni Jesús ni ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","If'ajli'me anuli al barco, iye'me quiƚtuca' ticuaitsa pe ailopa'a quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Axpela' lan xanuc' quiyouyomma jahuay ƚiƚeloƚya' ixinim'mola' lif'ajli'me al barco. Imetsaico'mola'. Iƚne lan xanuc' iye'me, inul'me, icuaitsa ate'a pe lotseyacu Jesús jouc'a ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús jouc'a ts'ilihuequi icuaitsa ƚocuena quema caja, ipalunca al barco. Jesús lixim'mola' iƚne axpela' lan xanuc' efot'ƚeyoƚtsi jiƚpiya, ixim'mola' acuanuc'la. Ixim'mola' to lam mot'ƚ, iƚne lam mot'ƚ lahue'epola' quiƚpoujna. Ailopa'a nohuic'iyacola'. Ipango'ma imuc'i'mola'. Axpe' ƚataiquí imuc'i'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Joupa if'acoƚaipa, ts'ilihuequi Jesús iƚoc'oƚai'me, timiyi: ―Jif'a'a ailopa'a quiƚya'. Joupa if'acoƚaipa. ");
INSERT INTO chdNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tommetsola' lan xanuc' tiyeƚe. Pu'huanni calx'uiyaƚma' o ƚiƚeloƚya' ti'nata ƚotejacu. ");
INSERT INTO chdNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús timila': ―Imanc' toƚtes'mitsola'. Italai'e'e'me, timiyi: ―Ticuicomma axpe' ƚa'i, lipitali to lolijya cal xans no'eya canic' apaicoj mut'ƚa. ¿Te tipa'a caƚtomí aƚ'nacota toƚta'a ƚa'i? Aimi'iya maƚtes'miyacola'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús icuis'e'mola', timila': ―¿Tojua tipa'a ƚa'i? Tonƚeƚe, toƚsintsa. Iye'me, ixintsa. U'icona'me, timiyi: ―Tipa'a amaque' la'í, jouc'a oquexi' latuye. ");
INSERT INTO chdNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús icuxe'e'mola' ts'ilihuequi ticuxe'entsola' lan xanuc' ticutsoƚaiƚe jahuay jiƚpe calxhuaica pajac. ");
INSERT INTO chdNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Enaj'moƚtsi lan xanuc' amaxnu amaxnu, jouc'a oquej oquej nuxans quimbama', icutshuoƚai'me. ");
INSERT INTO chdNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús epef'ma lan maquej la'í jouc'a loquexi' latuye, ehuenaf'ma lema'a, ix'najtsi'i'ma ȽanDios. Ixquenuf'ma ƚa'i, epi'i'mola' ts'ilihuequi, iƚne eca'nem'mola' lan xanuc'. Jouc'a loquexi' latuye ixquenuf'mola', epi'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jahuay itetso'me, ixhuaitsola'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ts'ilihuequi efot'ƚena'me lipanecomma ƚa'i jouc'a latuye. Imantsi imbamaj coque' lan tsiquihuit'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lan xanuc' litetso'me tixhuaispola' oquej nuxans quimbamaj maxnu. Jouc'a timana' lacaƚ'no', la'uhuay. ");
INSERT INTO chdNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aiquicoƚ'ma, Jesús icuxe'e'mola' ts'ilihuequi tif'ajliƚe al barco, tiquieƚe al cuecaj quin'nuhua', ticuaitsa pe lopa'a liƚya' Betsaida. ");
INSERT INTO chdNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iƚque ixc'ai'ina'mola' lan xanuc', if'aj'ma ƚijuala, tipalaic'ota ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Muyalaicoyi ts'ilihuequi icuaitsa nolojmay quin'nuhua' imufc'o'ma. Jesús tipa'a ƚamats' quituca'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jiƚpe ehuelojm'mola' ts'ilihuequi nomana' al barco. Ixim'mola' juaiconapa tipa'ayi cafxi tiquieƚe, aimi'i miquieyi. Italecuf'me ƚujfxi cahua'. Al fanej hora lipuqui' joupa uyaipa, tehue'e' micuaiya al camts'us 'hora. Icuaico'ma Jesús ti'huayaf'que laja'. Icuaitsi pe lopa'a al barco, ti'hua mi'hua, tocomma tuyaicota. ");
INSERT INTO chdNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ts'ilihuequi ixim'me, ticuayi: “Acuecaj quinxpaic'ale”. Ija'a'me. ");
INSERT INTO chdNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jahuay ixim'me. Ixpailij'mola' juaiconapa. Jesús aiquicoƚ'ma, ipalaic'o'mola', timila': ―Aimixpailij'molhuo'. Toƚ'etsoƚtsi acueca' ƚolunxajma'. Ma iya'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","If'aj'ma al barco pe lomana' ts'ilihuequi. I‑ch'ixcona'ma ƚahua'. Ixim'me acueca' iƚe li'epa Jesús. Aiquiƚcueca. ");
INSERT INTO chdNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tama joupa iximpá al cuecaj li'epa Jesús iƚe litine lites'mi'mola' lan xanuc', ite'me ƚa'i, iƚne ts'ilihuequi aimicuec'eyi. Amuf liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lijou'ma liquie'me al cuecaj quin'nuhua', icuaitsa ƚamats' Genesaret. Jiƚpiya ifijm'me al barco. ");
INSERT INTO chdNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ipalnanca. Aiquicoƚ'ma, lan xanuc' imetsaico'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ni petsi jiƚpe ƚamats' icuej'me lan xanuc': “Icuai'ma Jesús, pu'hua o ƚu'hua tipa'a”. Iyec'oƚaitsa tehueyi Jesús, iƚtaic' lilefcualƚay tunaf'coƚanna liƚpuxcuif'que. ");
INSERT INTO chdNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jiƚpiya lan tsocay quiƚeloƚya', o lan tsila' quiƚeloƚya', o calx'huiyaƚma', ni petsi licuaitsi Jesús, lan xanuc' iƚtaic' lilefcualƚay jiƚpe pe lafoƚyoya. Tixahue'eyi Jesús tepi'itsola' lane lilefcualƚay tiƚafle, tama ma le'a lipijahua'. Jahuay niƚafpá, tixaƚconala'. ");
INSERT INTO chdNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lam fariseo icuaitsa pe lopa'a Jesús, jouc'a icuaitsa lomxiye nomuc'iyalepá locuxepa ȽanDios. Iƚne quiyouyomma al cuecaj quiƚya' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ti'huilaic'oyi lo'epa ts'ilihuequi Jesús. Ticuayi: “Iƚne titetsoyi aiquilulahua al c'a liƚmane'. Aimepenufyacola' ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Lan xanuc' fariseo tihuejyi liƚtatahueló liƚ'ejma'. Tepajyi liƚmane' ticuaispa liƚƚuxluc. ");
INSERT INTO chdNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Miye'me laplaza, miyelocota, micuainacu lilejut'ƚ ate'a tepo'me, tijouƚa' titetso'me. Tihuejyi axpe' quiƚ'ejma'. Tipa'a liƚ'ejma' mepaj'me liƚpime, liƚcatsitu, ƚilepixú, lolanc'ecompa atejma' cuftine acobre, jouc'a liƚhualfa. Ticuayi: “Toƚta'a ipic'a ȽanDios”. ");
INSERT INTO chdNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iƚne icuis'e'me Jesús, timiyi: ―Iƚne lihuejhuo', ¿te co'ecopa aimihuejyi laƚ'ejma' iƚe laƚmuc'iponga' laƚtatahueló? Mane titetsoyi, aimepajyi al c'a liƚmane'. ");
INSERT INTO chdNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús italai'e'e'mola', timila': ―Imanc' ma le'a tonƚ'e'eyoƚtsi to unc'ic'a xanuc'. Luyaipa quitine cal profeta Isaías uya'a'ma linespa ȽanDios te ts'i'ic' loƚpicuejma'. Ticua: Iƚne lan xanuc' aƚmi: “Ima' malanDios”, ma le'a tipaloƚaiyi. Iƚniya aimaƚcuec'e, ma ti'eyi quiƚtuca' ts'iƚpic'a. ");
INSERT INTO chdNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tama laxc'onƚingaiƚa' aicapenufila', iƚne timuc'iyaleyi ma le'a locuxepa lan xanuc', a'i laifcuxepa. ");
INSERT INTO chdNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Toƚe loƚpicuejma' imanc', tolatets'iyi ȽanDios, tolihuequila' lan xanuc' liƚ'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jouc'a timila': ―Imanc' xonca tolihuequila' loƚtatahueló liƚ'ejma', toƚta'a tolatets'iyi litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","’Moises icuxepa: “Taihuejco'mola' co'ailli', co'máma', totoc'i'mola'”. Jouc'a icuxepa: “Cal xans nomipola' cataiqui' qui'ailli' qui'máma', tipa'a lijunac'. ¡Tima'anƚe!” ");
INSERT INTO chdNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","’Imanc' ituca' loƚmuc'iyalepa. Ja'ni anuli cal xans timitsola' qui'ailli', qui'máma': “Aimi'iya catoc'iyacolhuo'. Jahuay ƚai'huexi joupa nenajpa, iƚe catsufco'ma ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Imanc' toƚcuayi: “Ne', iƚque aimitoc'i'mola' qui'ailli' qui'máma'”. ");
INSERT INTO chdNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","’Iƚe lataiqui' lolihuejpa ma le'a liƚtaiqui' loƚtatahueló limuc'ipolhuo', iƚiya coƚmuc'ipola' lan xanuc'. Ma' anuli toƚta'a axpe' tonƚ'eyi. Litaiqui' locuxepa ȽanDios toƚsinyi to nij naitsi cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","U'icona'mola' lan xanuc' lefot'ƚepoƚtsi jiƚpiya, timila': ―¡Aƚquimf'eƚa' anuli anuli imanc'! ¡Aƚcuec'eƚa'! ");
INSERT INTO chdNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fa'a li'a ƚamats' tipa'a iƚe pe imanc' lolacui'ipa axujc'a. Iya' cacua a'i. Ja'ni anuli cal xans titeƚa', ti'nicoƚa' lico, tinuc'la', ailopa'a co'iya, aimixis'meyacoxi. Al xujc'a laipa'aya lipicuejma' cal xans, iƚe ƚinca tixis'me'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Naitsi nocuejpa, aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús ipo'no'mola' quiƚtuca' lan xanuc', itsufai'ma lajut'ƚ. Ts'ilihuequi ixa'hue'me tuhuaƚc'e'etsola' iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Timila': ―¿Te imanc' jouc'a ailopa'a coƚpicuejma'? Cal xans no'nicopa lico al xujc'a, tinuc'a, aimixis'meyacoxi toƚta'a. ¿Te aicoƚcueca? ");
INSERT INTO chdNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Iƚe loyaicopa lico, aimitsufaiya lipicuejma'. Ticuaispa licu'u, tijouƚa' tipanamma. Minesqui toƚta'a Jesús ipalaicopa ƚotempa fa'a li'a ƚamats'. Ticua jahuay iƚe ac'a. Aimi'iya minesyacu: “Iƚe axujc'a, aimi'iya catec'oya”. ");
INSERT INTO chdNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ti'hua timila': ―Al xujc'a laipa'apa lipicuejma', iƚe ƚinca tixis'me'ma cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Jiƚpe liƚpicuejma', lan xanuc' tixpic'eyi ti'eƚe al xujc'a. Tihuennaiquila' cacaƚ'no', tinantseyi, tima'ahualeyi, tixhuicoyi liƚpenoye liƚf'as xanuc', ");
INSERT INTO chdNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tijanajyi ti'huejle xonca, ti'eyi al xujc'a liƚf'as xanuc', tifel'miyaleyi, tipalaiyi o ti'eyi petsi aimetenƚcocojma, ti'e'ehualeyi laic', tinescoyi liƚf'as xanuc', tetets'iyaleyi, tixinyoƚtsi xonca lan tsila' xanuc', ti'eyi pangay camac'ta. ");
INSERT INTO chdNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jahuay iƚna'a tipa'a liƚpicuejma'. Ja'ni tipa'aƚe, ti'eƚe toƚta'a, tixis'me'moƚtsi, ti'e'e'moƚtsi xujc'a. ");
INSERT INTO chdNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús ipanni jiƚpiya. I'hua'ma icuaitsi ƚamats' huejnca liƚya' cuftine Tiro. Itsufai'ma anuli lajut'ƚ. Ticua: Nij naitsi nocuejya. ");
INSERT INTO chdNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Anuli ƚaca'no' icuej'ma jiƚpe tipa'a Jesús. Icuaitsi, exc'onƚingai'ma li'mitsi' Jesús. Iƚque ƚaca'no' tipa'a ƚi'hua cahuats' ƚitsufaipa conta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ƚaca'no' a'i judía, qui'huayomma maƚpiya ƚamats' cuftine Sirofenicia. (Lan xanuc' judío tetets'innila' iƚniya lun Sirofenicia. Tecui'innila' atsiƚqui.) Ƚaca'no' tixahue'e tipa'aƚa' ƚonta'a, tixaƚ'meƚa' ƚi'hua. ");
INSERT INTO chdNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús timi: ―Ate'a aƚtes'mi'mola' laƚnaxque'. Aƚtoc'itsola' laƚxanuc'. ¿Te ja'ni ac'a laƚ'eyacu laxic'e'mola' ƚile'i la'uhuay, tijouƚa' laca'ni'i'mola' lan tsiƚqui? ");
INSERT INTO chdNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ƚaca'no' titalai'e'e, timi: ―Mapoujna, tama al ƚinca lofnespa, iya' cacua lan tsiƚqui titeji ƚaiquepi' ca'i ƚopa'a licu'uj mesa, loc'aiƚpa la'uhuay. ");
INSERT INTO chdNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús timi ƚaca'no': ―Iƚta'a laƚmipa icuaicota caipic'a. Ma to'huanƚa'. Ƚonta'a joupa ipanamma ƚo'hua. ");
INSERT INTO chdNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ƚaca'no' i'huana'ma, icuainatsi lejut'ƚ ixim'ma ƚi'hua tunouya. Ƚonta'a joupa ipanamma. ");
INSERT INTO chdNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús ipanni pe lopa'a liƚya' Tiro, uyaicotsi liƚya' Sidón, jouc'a pe lopa'a Limbama' Quiƚeloƚya'. Icuaicontsi al cuecaj quin'nuhua' Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jiƚpiya i'hua'a'me anuli cal xans atape, afule mipalay, ata'ay. Ixa'hue'me Jesús tixpayaf'la' iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús ileco'ma lijuqueya jiƚpe pe ailopa'a xans. Ecajm'mi'ma lidedó anuli anuli lix'mats'i' cal xans. Itsuƚof'i'ma ƚipaƚ cal xans. ");
INSERT INTO chdNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ehuenaf'ma lema'a, ixnalif'ma acueca' timi: ―¡Efata! Iƚe lataiqui' locuajmaispa ticua: ¡Texinanni! ");
INSERT INTO chdNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aiquicoƚ'ma. Cal xans iximpoxi exinamma lix'mats'i', ux'masquenanni ƚipaƚ. Ipango'ma ipalai'ma ac'a. ");
INSERT INTO chdNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús icuxe'e'mola' lan xanuc' aimuyout'ƚe'me. Nij naitsi nocuejya. Iƚniya aimicuec'eyi. Tama Jesús timila': “Aimuluyout'ƚe'me, nij naitsi locuejya”, iƚne lan xanuc' xonca tuya'ayi lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Imetsaico'me acueca' juaiconapa lo'epa Jesús. Ticuayi: ―¡Toƚsinƚe! Tixaƚ'menala' lan taƚpe iƚne ticuejnayi. Tixaƚ'menala' jouc'a lan ta'ay, iƚne tipalainayi ac'a. Jahuay lo'epa juaiconapa ac'a. ");
INSERT INTO chdNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jiƚne ƚitiné lan xanuc' efoƚconanni pe lopa'a Jesús. Ailopa'a cotejacu. Jesús ijoc'i'mola' ts'ilihuequi, timila': ");
INSERT INTO chdNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Iya' caxinnila' cuanuc'la iƚne lan xanuc'. Joupa ixhuaita afane' quitine maƚmana' fa'a, iya' jouc'a iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Timana' quiyouyomma aculi'. Aiquiƚtesma. Aimi'iya miyeyacu. A'i cummeyacola'. Ticuaitsa nolojmay cane timatola' cumemma. ");
INSERT INTO chdNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ts'ilihuequi italai'e'e'me, timiyi: ―Jifa'a ailopa'a quiƚya'. ¿Petsi caƚtac'ueyacu ƚa'i tinajntsola' iƚniya lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús icuis'e'mola', timila': ―Imanc', ¿tojua mimana' lola'í? Iƚne italai'enca, timiyi: ―Tipa'a acaitsi lala'í. ");
INSERT INTO chdNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús icuxe'e'mola' lan xanuc' ticutshuoƚaiƚe ƚamats'. Epenuf'ma lan caitsi la'í, ix'najtsi'i'ma ȽanDios, ixquenuf'ma ƚa'i, epi'i'mola' ts'ilihuequi. Iƚniya eca'nem'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Timana' jouc'a oquexi' afantsi laicatuye. Jesús ix'najtsi'icona'ma ȽanDios, timila' ts'ilihuequi: ―Tolaca'netsola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jahuay itetso'me. Inajntsola' al c'a. Lefot'ƚe'me lipanecomma, imantsi acaitsi lan tsangay. ");
INSERT INTO chdNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iƚne lan xanuc' litetso'me tixhuaispola' to oquej nuxans maxnu. Jesús ixc'ai'ina'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aiquicoƚ'ma, if'ajli'me al barco jouc'a ts'ilihuequi. Iye'me icuaitsa ƚemats' liƚya' cuftine Dalmanuta. ");
INSERT INTO chdNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Icuaiconanca lan xanuc' fariseo. Ipango'me icuis'mot'ƚecona'me Jesús. Ixa'hue'me ti'eƚa' al cueca', iƚe to lo'eya ȽanDios. Tehuaiyi. ");
INSERT INTO chdNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús ixnalif'ma acueca', ticua: ―Lan xanuc' nomana' itsiya, ¿te caƚsa'huecopa ca'eƚa' al cueca'? Iya' cacua: Ƚinca aicamuc'iyacola', ni toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ipo'no'mola' quiƚtuca', if'ajcona'ma al barco. Iye'me, iquie'me al cuecaj quin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ts'ilihuequi aiquiƚtaic' ca'i. Imenc'ecopá. ");
INSERT INTO chdNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús ixc'ai'i'mola' iƚniya, timila': ―Toƚpo'noƚe cuenna. Aimolapenuf'me ƚiƚƚevadura lan xanuc' fariseo, ni ƚilevadura cal rey Herodes. ");
INSERT INTO chdNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iƚne aiquiƚcueca iƚe limipola' Jesús. Timiyoƚtsi: ―¿Te caƚmicoponga' toƚta'a? O ¿aƚminga': “Imanc' olimenc'ecopá, aicoƚtaic' ca'i”? ");
INSERT INTO chdNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús ixina' lonespa, timila': ―Imanc', ¿te coƚnescopa: “Ailopa'a cala'i”? ¿Teaicoƚcueca laimipolhuo'? ¿Te aicolapaic' cuenna lai'epa? O ¿i'ipolhuo' muf loƚpicuejma'? ");
INSERT INTO chdNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Te unc'ifohue? ¿Te aimoƚsinyi loƚ'u'? ¿Te unc'itaƚpe? ¿Te aimoƚcuejyi loƚs'mats'i'? ¿Te olimenc'ecopá lai'epa? ");
INSERT INTO chdNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Lu'iƚa': Jiƚpe litine laixquenuf'ma lam maque' la'í lolaca'nepola' iƚne lam maquej mil lan xanuc', ¿tojua lan tsiquihuit'ƚ loƚma'ne'me lipaneconni? Italai'e'e'me, timiyi: ―Imbamaj coque'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Laixquenuf'ma lan caitsi la'í lolaca'nepola' lam malpuj mil lan xanuc', ¿tojua lan tsangay loƚma'ne'me lipaneconni? Italai'e'e'me: ―Acaitsi. ");
INSERT INTO chdNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Timila': ―Itsiya, ¿te aimi'iya moƚcuec'eyacu? ");
INSERT INTO chdNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Icuaitsa liƚya' Betsaida. Icuai'e'entsa Jesús anuli cal fo'. Ixa'hue'me tixpayaf'la' li'u' cal fo'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús exaƚ'ma cal fo', iye'me lema quiƚya'. I'otƚi'ma ƚitsulu li'u', ixpayaf'ma limane, icuis'e'ma, timi: ―Itsiya, ¿te nipajnya tahuetsale? ¿Toxina? ");
INSERT INTO chdNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Cal xans ipango'ma ehuetsale'ma, timi: ―Caxinnila' lan xanuc', tiyelocoyi. Ti'onƚcospola' to lan 'ec'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús ixpayaf'cona'ma li'u' cal xans. Iƚque ixim'moxi exilinamma li'u'. Ehuetsale'ma. Tehuelonge jahuay. ");
INSERT INTO chdNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús umme'ma ti'huanƚa' lejut'ƚ, timi: ―Aimotsufai'ma liƚya'. Aimo'itola' lan xanuc'. Nij naitsi nocuejya li'ipo'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús jouc'a ts'ilihuequi iye'me, ticuaitsa ƚaiquiƚeloƚya' lomana' jiƚpe al distrito cuftine Cesarea de Filipo. Miyeyi lane Jesús ticuis'ela', timila': ―¿Te conespa lan xanuc'? ¿Naitsi iya'? ");
INSERT INTO chdNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Italai'e'e'me: ―Timana' nocuapá ima' umJuan Bautista. Ocuenaye ticuayi ima' umprofeta Elías. Ocuenaye tinesyi ima' mocuenaj profeta. ");
INSERT INTO chdNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Icuis'econa'mola': ―Imanc', ¿te coƚnespa? ¿Te coƚcuapa? ¿Naitsi iya'? Pedro italai'e'e'ma, timi: ―Ima' unCristo. ȽanDios ummepo'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús u'i'mola': ―Aimolu'i'mola' lan xanuc'. Nij naitsi nocuejya. ");
INSERT INTO chdNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ipango'ma imuc'i'mola' loyaicoya. Timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cateƚco'ma juaiconapa. Lan tsila' xanuc' noxpijpá lataiqui', jouc'a lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, iƚniya latets'i'ma, aƚcu'ma aƚma'anƚa'. Afanej quitine camaf'ina'ma, catsahueno. ");
INSERT INTO chdNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Acuajmaica u'ipola': “Aƚma'a'ma”. Pedro aiquicuaitsi quipic'a iƚe lines'ma Jesús. Ixoulai'ipa, itale'ma, timi: ―¿Te cofnescopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús ipai'e'moxi, ehuelojm'mola' ts'ilihuequi, itale'ma Pedro, timi: ―To'huanƚa'. Tanajxoxi fa'a. Ima' topalay ma to minesqui ƚonta'a Satanás. Ima' toxpic'e to mixpic'eyi lan xanuc'. Ituca' tixpic'e ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ijoc'i'mola' lan xanuc' jouc'a ts'ilihuequi tiquimf'eƚe, timila': ―Cal xans ja'ni ipic'a lihuejla', aimicuxe'moxi quituca'. Iya' lapaƚts'inginna lancruz. Naitsi nalihuejya titaiƚa' lencruz jouc'a. Tixpic'eƚa' ticuxoxi titeƚcoƚa'. Toƚta'a lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Cal xans ja'ni ti'exoxi cuenna juaiconapa, ja'ni aimicua miteƚcoya, iƚque cal xans tecani'e'moxi. Cal xans ts'ipic'a tihuejla' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios, toƚta'a lihuej'ma iya', iƚque ƚinca ticu'moxi lateƚcoya. Tama tima'anƚe, iƚque tulij'ma lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cal xans nolijpa jahuay lopa'a fa'a li'a ƚamats', tijouƚa' tecani'exoxi, ¿te tixhuico'ma iƚe lulijpa? ");
INSERT INTO chdNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Nipajnya ti'najtse'ma tunƚu'eƚa' ƚi'alma? A'i, aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","’Itsiya litine lan xanuc' enajpoƚtsi ȽanDios, ti'eyi al xujc'a. Cal xans noximpa calaic'ata, ja'ni tinesla': “Iƚne laif'as xanuc' lahuelonge, aiquihuejya Jesús, aicapenufya litaiqui', aimi'iya”; litine cacuaiconanni fa'a li'a ƚamats', iya' jouc'a aicapenufya iƚque cal xans. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a'. Cacuaiyoconno. Aƚcuaiconacu iya' jouc'a lam paxi capaluc' quema'a. Jiƚpe litine aƚsim'ma ninCueca' ma to ȽanDios cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ti'hua timila': ―Iya' camilhuo' al ƚinca: Jifa'a timana' lan xanuc' tixim'me, timetsaico'me lo'eya ȽanDios micuxe fa'a li'a ƚamats'. Toƚta'a tixim'me ai'a tima'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Luyaipa acamts'us quitine Jesús ileco'mola' Pedro, Jacobo jouc'a Juan. Tiyeyi ma quiƚtuca'. If'ajli'me ƚi'nof'quiya ƚijuala. Mehuelojnyi Jesús iƚque ipaicomma lixans. ");
INSERT INTO chdNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lipijahua' i'i'ma afujca juaiconapa, tunts'iflay. Fa'a li'a ƚamats' tama tepajle lijahua' aimi'iya mi'onƚiyacu toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ts'ilihuequi Jesús ixim'me imaxcaitsola' lam profeta Moisés jouc'a Elías. Tipalaic'oyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro timi Jesús: ―Momxi, ¡ac'a fa'a maƚmana'! Aƚƚanc'e'me afanej lihuoxqui, anuli ima', anuli Moisés, locuena Elías. ");
INSERT INTO chdNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro aiquixina' te ts'i'ic' iƚe licuapa, ma le'a tipalay. Iƚne lam fantsi ts'ilihuequi Jesús ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ixim'me ipoxc'i'mola' cummahuay. Icuej'me tipalay maƚpe ƚummahuay, timila': ―Iƚca'a ai'Hua, ca'ay capic'a juaiconapa. Toƚquimf'eƚe iƚque lonespa. ");
INSERT INTO chdNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ehuelojncona'me Jesús, iƚque tecaxu quituca'. Moisés y Elías ailomana'. Ma ejac'na'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mimulnamma ƚijuala Jesús ipalaic'ocona'mola', timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a, ma capa'a fa'a li'a ƚamats' aimoluya'ata loƚsimpa jiƚpe ƚijuala. Nij naitsi nocuejya. Aƚma'a'ma, catsahuenahuo quipayonahuo pe lomana' limapola', tijouƚa' ti'iƚa' toƚta'a tolu'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iƚne ts'ilihuequi Jesús ma quiƚtuca' tipalaic'oyoƚtsi, i'nujuaista iƚe lixinghuo'me ƚijuala. Ticuis'eyoƚtsi: ―¿Te cataiqui' lonespa Jesús? Ticua: “Catsahuenahuo, quipano pe lomana' limapola'”. ");
INSERT INTO chdNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Icuis'e'me Jesús, timiyi: ―Lomxiye nomuc'iyalepá locuxepa ȽanDios ticuayi: “Ate'a Elías ticuaiyoconno fa'a li'a ƚamats'. Tijouƚa' ticuaihuo cal Cristo.” ¿Te conescopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús timila': ―Al ƚinca lonespa iƚniya lomxiye iƚne nocuapá: “Ate'a ticuaihuo Elías. Iƚque tixanu'ma jahuay.” Jouc'a tipa'a liniƚiya loya'apa te ts'i'ic' laifnuyaicoya iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Tuya'e' iya' cateƚco'ma juaiconapa, lan xanuc' latets'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","’Iya' camilhuo', joupa i'huamma Elías. Lan xanuc' ma to lixpic'epa toƚta'a i'e'epá iƚque. I'e'epá ma to muya'e' jiƚpe al Paxi Cataiqui' Liniƚingiya. ");
INSERT INTO chdNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Icuaitsa pe lomana' locuenaye ts'ilihuequi Jesús, jiƚpe ixim'me juaiconapa axpela' lan xanuc' efot'ƚeyoƚtsi canumicay. Jouc'a timana' lomxiye nomuc'iyalepá locuxepa ȽanDios. Iƚne lomxiye tifuli'iyi cataiqui' ts'ilihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Lixim'me Jesús lan xanuc' ixoconni quileta. Aiquicoƚ'mola', iyouyunca, inontsa. ");
INSERT INTO chdNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús icuis'e'mola' lomxiye nomuc'iyalepá locuxepa ȽanDios, timila': ―Imanc', ¿te colicuis'epola' iƚne lalihuequi? ");
INSERT INTO chdNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jiƚpiya lefoƚya anuli cal xans ipalai'ma, timi Jesús: ―Momxi, ailec'mehuo' ƚai'hua. Itsufaipa conta'a. Iƚque ƚonta'a i'e'epa ata'ay. ");
INSERT INTO chdNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ƚonta'a mulij'ma ƚai'hua tecanghuaispa. Tijouƚa' ƚai'hua ti'i quipehuoxco lico, ti'ilc'a li'ay, tuhuaquemma. Aixa'hue'mola' lihuejhuo' tipa'aƚe ƚonta'a. Aiqui'ic' quilipa'e. ");
INSERT INTO chdNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús italai'e'ma, ticua: ―Itsiya litine imanc' noƚmana' fa'a li'a ƚamats' aimoƚ'huaiyijnyi ȽanDios, olanajpoƚtsi. Iya' cacua, coƚa' aicapajncona'ma pe loƚmana'. ¿Te iya' ti'hua caxnet'ƚ'ma? Aƚƚec'metsi ƚo'hua. ");
INSERT INTO chdNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ilecontsa ƚamijcano. Aiquicoƚ'ma, lixim'ma ƚonta'a Jesús, ife'ne'ma ujfxi ƚamijcano. Iƚque ecanghuaitsi, ti'huaƚtsay, ipa'a'ma ipehuoxco lico. ");
INSERT INTO chdNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús icuis'e'ma qui'ailli' ƚamijcano, timi: ―¿Tojua camats' toƚta'a mi'i ƚo'hua? Italai'e'e'ma timi: ―Caca'hua. ");
INSERT INTO chdNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ƚonta'a tummetsay, tecajm‑maispa laja' jouc'a titanc'aispa ƚunga. Tehuay te co'iya mima'aya. Itsiya ja'ni nipajnya, ¡aƚtoc'itsonga'! ¡Aƚsintsonga' ninc'icuanuc'la! ");
INSERT INTO chdNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús timi cal xans: ―¿Te caƚmicopa: “Ja'ni nipajnya”? Ja'ni ima' aƚ'huaiyijnla', ti'i'ma. Naiƚne laƚ'huaiyijmpa aƚsim'ma iya' nipajnya, aƚsim'ma jahuay ti'i'ma ca'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aiquicoƚ'ma, qui'ailli' ƚamijcano ija'a'ma ujfxi, timi Jesús: ―Ca'huaiyijnhuo', ¡aƚtoc'iƚa' ca'huaiyijntso' xonca! ");
INSERT INTO chdNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ixim'mola' Jesús tiƚoc'oƚaiyumma xonca lan xanuc', itale'ma ƚonta'a, timi: ―Ima' monta'a, ima' o'e'epa atape y ata'ay iƚca'a ƚamijcano. Iya' cacuxe'ehuo', ¡taipanni iƚca'a ƚamijcano! Aimotsufaicona'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ƚonta'a ija'a'ma. Ife'ne'ma ujfxi ƚamijcano. Ipananni. Ƚamijcano i'i'ma to ƚomapa. Axpela' lan xanuc' ticuayi: “Joupa imanapa”. ");
INSERT INTO chdNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús i'noƚ'e'ma limane icutsu'ma ƚamijcano, iƚque ecaxna'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lijou'ma litsuflai'me lajut'ƚ Jesús jouc'a ts'ilihuequi, mimana' quiƚtuca' iƚne icuis'e'me, timiyi: ―Illanc', ¿te caƚ'icoponga' aicalipa'e ƚonta'a? ");
INSERT INTO chdNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Italai'e'e'mola', timila': ―Ticuicomma toƚsa'hueƚe ȽanDios, aimoƚtetso'me, toƚsnet'ƚƚe. Ja'ni a'i, aimi'iya molipa'ayacola' iƚniya lontahue. ");
INSERT INTO chdNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ipalunca jiƚpiya. Tuyalaicoyi al distrito Galilea. Jesús ticua: “Aimicuej'me lan xanuc' pe laifpa'a”. Ipic'a timajnle quiƚtuca' iƚque y ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mimuc'ila' timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aƚcu'ma, aƚ'noƚ'ma lan xanuc', aƚma'a'ma. Afane' quitine, camaf'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iƚne aiquiƚcueca iƚe lonespa Jesús. Aiquilicuis'e. Tixpailiquila'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Icuaiyocontsa liƚya' Capernaum. Mimana' lajut'ƚ, Jesús icuis'e'mola' ts'ilihuequi, timila': ―¿Te cataiqui' coƚfuli'icopoƚtsi maƚeyi lane? ");
INSERT INTO chdNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Iƚniya aiquiƚtalai'e. Miyeyi lane tifuli'iyoƚtsi cataiqui' naitsi iƚque xonca cal te'a. ");
INSERT INTO chdNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús icutshuai'ma, ijoc'i'mola' limbamaj coquexi', timila': ―Cal xans ts'ipic'a ti'iƚa' cal te'a, ti'e'exoxi ƚaquijoujma, ti'e'exoxi to ƚaquintahuaicopa lif'as xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Exaƚ'u'ma anuli ƚahuac'hua. Ecaxu'e'mola' ts'ilihuequi. Ipulc'o'ma, timila' ts'ilihuequi: ");
INSERT INTO chdNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Naitsi napenufya anuli ƚahuac'hua to iƚca'a, ja'ni tinesla': “Jesús ti'ay capic'a iƚca'a ƚahuac'hua, iya' jouc'a capenuf'ma”, iƚque ƚinca lapenufi iya'. Naitsi nalapenufpa iya' a'i ma le'a iya' lapenufi, lapenufinga' jouc'a Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan timi Jesús: ―Momxi, aƚsimpá anuli cal xans tipa'ala' lontahue. Iƚque ticuaj'mi lopuftine. Illanc' aƚcuanac'epá. Iƚque a'i caƚejmale. ");
INSERT INTO chdNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús timila': ―Aimoƚcuanac'e'me. Anuli cal xans no'epa acueca' micuaj'mi laipuftine, iƚque cal xans aimaƚnesc'eya cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iƚne lan xanuc' ja'ni aimaƚ'enga' laic' tama a'i maƚejmaleyi, iƚne ƚinca aƚtoc'inga'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","’Iya' camilhuo' al ƚinca: Cal xans naimetsaicopolhuo' imanc' alihuequi iya', ja'ni tinesla': “Iƚne ilihuequi cal Cristo. Cuhui'i'mola' quiƚja'”, iƚque cal xans tipa'a lolijya, ȽanDios tipaxne'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’A'ijc'a loyaicoya cal xans naimenac'iya anuli iƚna'a la'uhuay, iƚne aƚ'huaiyinge iya'. Coƚa' ifinc'im'me ƚejoc' anuli cal cuecaj capic molino, coƚa' ecajm'mim'me ƚaja. Coƚa' ima'ma ate'a ai'a ti'e'ma iƚiya lixcay. ");
INSERT INTO chdNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","’Ja'ni lomane ti'e'ma lixcay, ¡tatejla' nulemma! Ja'ni tocuaitsi al muf petsi ƚunga aimipica, ¿te cof'ecoya oque' lomane'? Tama le'a anuli lomane, ja'ni ti'i'ma totsufaita petsi lopitine aimijouya, xonca al c'a toyaicota. ");
INSERT INTO chdNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","46","’Ja'ni lo'mis ti'hua'a'mo' petsi to'e'ma lixcay, ¡tatejla' nulemma! Ja'ni tecajm‑mitso' al muf, ¿te cof'ecoya oque' lo'mitsi'? Tama le'a anuli lo'mis, ja'ni ti'i'ma totsufaita petsi lopitine aimijouya, xonca al c'a toyaicota. ");
INSERT INTO chdNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","’Ja'ni lo'u timenac'ihuo', ¡taipa'aƚa'! Ja'ni tecajm'mitso' al muf petsi lapimí aimimala', ti'hua titeji, petsi aimijaf'que lateƚcoya, aimipica ƚunga, ¿te cof'ecoya oque' lo'u'? Tama ma le'a anuli lo'u, ja'ni ti'i'ma totsufaita petsi tihuejcoyi ȽanDios, iƚque cal Cuecaj Rey, xonca al c'a toyaicota. ");
INSERT INTO chdNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Jahuay ƚotsufconyacu ȽanDios ticuicomma tetenƚinƚe, toƚiya ti'em'me co'hue, toƚe ȽanDios tepenuf'ma. Jouc'a lan xanuc' liƚpicuejma' ticuicomma tetenƚintsola', ticuicomma titeƚco'me, toƚe ȽanDios tepenufna'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ƚo'hue ipenic'. Ja'ni tejac'la' lic'a, ¿te conƚ'ecoyacu ƚo'hue? Imanc' aimi'i'molhuo' to iƚque ƚo'hue ƚejac'pa lic'a. Aimoƚfuli'i'moƚtsi cataiqui'. Toƚnanc'otsoƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús ipanni al distrito Galilea, icuaitsi al distrito Judea. Iƚe ƚamats' locuena liju' al cuecaj panaj Jordán. Icuaiyocona'me axpela' lan xanuc' jiƚpe pe lopa'a Jesús. Iƚque ma to mi'ay timuc'iyale. ");
INSERT INTO chdNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Icuaiyunca jouc'a lam fariseo. Ehuaicona'me, icuis'e'me: ―¿Te cal xans nipajnya tecanai'ma ƚipeno, o aimi'iya? ");
INSERT INTO chdNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús italai'e'e'mola', timila': ―¿Te quiniƚpa Moisés? ¿Te coya'apa lonƚ'eyacu? ");
INSERT INTO chdNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Italai'e'e'me, timiyi: ―Moisés iniƚpa: “Cal xans tiniƚƚa' anuli lije'e lacanaicoya ƚipeno. Tijouƚa' tecanai'ma.” ");
INSERT INTO chdNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús timila': ―Moisés ixina' ata loƚpicuejma' imanc', toƚta'a quiniƚcopa. ");
INSERT INTO chdNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Al te'a a'i toƚta'a licuxeyalepa ȽanDios. Lilanc'epa li'a ƚamats' ȽanDios ilanc'e'mola' “… cal xans y ƚaca'no'”. ");
INSERT INTO chdNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Icua'ma: “Cal xans tipo'no'mola' qui'ailli' qui'máma', tileco'ma ƚipeno. Tejonƚi'moƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Loquexi' ti'e'e'moƚtsi to anuli le'a.” Toƚta'a i'ipola' anuli, a'i oquexi'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ȽanDios ixpic'epa toƚta'a tejonƚi'mola', toƚta'a ti'e'e'mola' anuli. Lan xanuc' aimi'iya menajyacola'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Licuaitsa lajut'ƚ ts'ilihuequi Jesús icuis'e'me to joupa licuis'epa lan xanuc' fariseo. ");
INSERT INTO chdNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús timila': ―Tama cal xans tecanaiƚa' ƚipeno, ma' ipeno. Ja'ni tilecoƚa' ocuena caca'no', ixcay iƚe lo'eya. Ma' anuli lo'eya to iƚne nahuepá quilecaƚ'no'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jouc'a ƚaca'no'. Tama tecanaiƚa' ƚipe'ailli', ma' ipe'ailli'. Ja'ni tihuejla' ocuenaj xans ixcay iƚe lo'eya. Ma' anuli lo'eya to lacaƚ'no' nahuepá quiƚxanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jiƚpiya pe lopa'a Jesús ticuai'enspola' la'uhuay. Tixa'hueyi tixpayaf'tsola', tipaxnetsola'. Ts'ilihuequi Jesús italem'mola' iƚniya ts'iƚejma quiƚnaxque'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús lixim'mola' ts'ilihuequi toƚta'a lo'epa aiquetenƚcocojma, ixtuc'o'mola'. Timila': ―Aimoƚpa'ne'mola' la'uhuay. Tiyouyunca pe laifpa'a. Lan xanuc' notsuflaiyacu pe locuxeyopa ȽanDios ti'onƚcospola' to iƚna'a la'uhuay. ");
INSERT INTO chdNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iya' camilhuo' al ƚinca: Cal xans ja'ni jahuay ƚunxajma' tihuequi litaiqui' ȽanDios locuxepa, ma to laihuejpa la'uhuay, iƚque cal xans titsufai'ma pe lopa'a ȽanDios. Ja'ni a'i, aimitsufaiya. ");
INSERT INTO chdNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesús ipulc'o'mola' la'uhuay, ixpayaf'mola', ipaxne'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ipango'ma ti'hua'ma Jesús, icuaico'ma anuli cal xans tinu. Exc'onƚingai'ma Jesús, icuis'e'ma: ―Cunc'a comxi, ¿te caif'eya culijla' laipitine aimijouya? ");
INSERT INTO chdNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús timi cal xans: ―¿Te caƚmicopa iya' ninc'a? Le'a ȽanDios copa'a cal C'a. Ailopa'a cocuena. ");
INSERT INTO chdNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ima' oxina' locuxepa ȽanDios. Iƚe lataiqui' tuya'e': “Aimoxhuico'ma ocuena caca'no', ma le'a ƚopeno. Aimoma'ahuale'ma. Aimonantse'ma. Ja'ni topalaicotsola' lof'as xanuc' tonesla' al ƚinca, aimofel'miyale'ma. Taihuejco'mola', totoc'i'mola', co'ailli', co'máma'.” ");
INSERT INTO chdNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Cal xans timi Jesús: ―Momxi, caƚtojyomma ca'ay toƚta'a, jahuay iƚiya. ");
INSERT INTO chdNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús ehuelojm'ma cal xans, etenƚcoco'ma lipicuejma', timi: ―Ƚinca, tipa'a lahue'epo'. To'huanƚa', tocujtsi jahuay ƚo'hueca. Al tomí lofmulijya tapi'itsola' pe lahue'epola'. Toƚta'a ti'i'ma co'huexi jipu'hua lema'a. Tijouƚa' tocuaicoconno pe laifpa'a, lihuej'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Licuej'ma jiƚe lataiqui' ic'ommai'ma. Acueca' juaiconapa ƚi'huexi. I'huana'ma tixhueƚma. ");
INSERT INTO chdNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús ehuelojm'mola' ts'ilihuequi, timila': ―Lan xanuc' ts'iƚ'hueca juaiconapa afule mitsuflaiyacu pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ts'ilihuequi aiquiƚcueca jiƚe lines'ma Jesús. Ticuayi: “¿Te conescopa toƚta'a?” Jesús timiconala': ―Cunc'ainaxque', lan xanuc' no'huaiyijmpá ƚiƚ'huexi afule mitsuflaiyacu pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","¿Te aga cal camello tuyaico'ma laquipihuo ƚacuxa? Iya' camilhuo': Cal xans ts'i'hueca juaiconapa tixim'ma xonca lipime mitsufaiya pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Licuej'me toƚta'a ts'ilihuequi Jesús ixim'me ipime juaiconapa iƚe lataiqui'. Imicona'moƚtsi: ―Aicaƚcueca iƚe lataiqui'. ¿Te ailopa'a conƚuya? ");
INSERT INTO chdNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús ehuelojm'mola', timila': ―Lan xanuc' quiƚtuca' aimi'iya monƚu'eyacoƚtsi. ȽanDios ƚinca nipajnya tunƚu'e'mola'. Iƚquiya jahuay nipajnya ti'e'ma, aimixina quipime. ");
INSERT INTO chdNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro timi Jesús: ―Illanc' aƚpo'nonapá jahuay, lihuejhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús italai'e'e'mola' ts'ilihuequi, timila': ―Iya' camilhuo' al ƚinca: Cal xans nocuapa: “Quihuequi Jesús, jouc'a quihuequi Lataiqui' loya'apa lixpic'epa ȽanDios”, ja'ni joupa ipo'nopa lejut'ƚ, ipo'nopola' lipimaye o qui'máma' qui'ailli' o linaxque' o ƚemats', ");
INSERT INTO chdNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","iƚque cal xans mipa'a fa'a li'a ƚamats' tulij'ma amaxnu xonca. Tama tihuetsoquinƚe tulij'mola' axpela' qui'máma', quipimaye, quinaxque', quejut'ƚi, quemats'. Ticuaitsi locuaicoya quitine tulij'ma lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Axpela' lan tet'ƚa xanuc' ti'i'mola' lijoucola'. Jouc'a lijoucola', axpela' iƚniya, ti'i'mola' lan tet'ƚa. ");
INSERT INTO chdNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Miyeyi lane tif'ajliyi Jerusalén Jesús i'huaj'me'mola' ts'ilihuequi, iyenc'e'me iƚniya. Tixhueƚmot'ƚeyi, ticuayi liƚpicuejma': “¿Te co'iya Jesús?” Lan xanuc' locuenaye tihuejyi tixpailiquila'. Jesús iƚojf'i'mola' limbamaj coquexi', u'i'mola' loyaicoya maƚque quituca'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Timila': ―Imanc' oƚsina' aƚf'ajliyi al cueca' quiƚya' Jerusalén. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Jiƚpiya aƚcunna. Lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, alacani'eta aƚma'anƚa' locuenaye xanuc', iƚniya a'i judío. ");
INSERT INTO chdNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Iƚniya aƚtaluntseta, aƚtsuƚc'ota lai'a, luntafquinna, aƚma'ata. Afanej quitine camaf'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo jouc'a Juan, iƚne linaxque' Zebedeo, iƚoc'oƚai'me pe lopa'a Jesús, timiyi: ―Momxi, aƚpic'a ima' lapi'itsonga' ma to laƚsahue'eyaco'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús timila': ―¿Te ts'oƚpic'a? ¿Te caifnepi'iyacolhuo'? ");
INSERT INTO chdNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iƚniya timiyi: ―Lapi'itsonga' lane aƚcuxeta anuli ima'. Aƚcutsingaito', anuli illanc' al c'a camane, ƚocuena loxa camane. ");
INSERT INTO chdNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus timila': ―Imanc' aicoƚsina', aicoƚcueca iƚe laƚsahue'epa. Aƚmiƚa': ¿Te imanc' nipajnya toluyalaico'me to iya' laifnuyaicoya? ¿Te nipajnya toƚteƚco'me to laifteƚcoya? ");
INSERT INTO chdNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iƚniya timiyi: ―Nipajnya. Jesús timila': ―Ma' aƚinca imanc' toluyalaico'me to iya' laifnuyaicoya. Toƚteƚco'me to iya' laifteƚcoya. ");
INSERT INTO chdNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Iya' aimi'iya camiyacolhuo': “Aƚcutsingaita anuli al c'a camane, ƚocuena loxa camane”. Ailopa'a toƚta'a laimane. ȽanDios joupa ixpic'epa naiƚne nocutsoƚaiyacu jiƚpiya. Ma' iƚniya ticutsoƚaita. ");
INSERT INTO chdNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Locuenaye limbama' ts'ilihuequi Jesús icuej'me loxahue'epa Jacobo y Juan. Ipango'me ixtulenca. ");
INSERT INTO chdNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús ijoc'i'mola', timila': ―Imanc' oƚsina' liƚ'ejma' lan xanuc' pe aimimetsaicoyi ȽanDios. Iƚne liƚpincuxepá ti'e'eyoƚtsi to lapoujnalá. Ts'iƚpenic' ticuxenaiyi juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Imanc' aimonƚ'e'me toƚta'a. Ja'ni anuli imanc' ipic'a ti'e'exoxi xonca acueca', iƚque titoc'itsola' lipimaye. ");
INSERT INTO chdNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ja'ni anuli imanc' ipic'a ti'e'exoxi cal te'a, tixpic'eƚa' titoc'itsola' jahuay lif'as xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Laicuai'ma fa'a li'a ƚamats' aicanesqui: “Lan xanuc' aƚtoc'iƚa' iya'”. Aicuaicoco'ma catoc'itsola', cacuƚa' laipitine. Ca'najcuf'mola' liƚjunac' axpela' lan xanuc', cunƚu'e'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Icuaitsa liƚya' Jericó. Uyalaico'me liƚya', ipalunca. Axpela' lan xanuc' tihuejyi Jesús. Jiƚpe lema cane ticutsu anuli cal fo'. Tixa'hue quitomí. Iƚque cuftine Bartimeo, i'hua Timeo. ");
INSERT INTO chdNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Icuej'ma tinesyi lan xanuc': “Icuaico'ma Jesús ƚas Nazaret”. Cal fo' ipango'ma ija'a'ma, timi: ―¡Jesús, ima' otatahuelo cal rey David! ¡Aƚsinƚa' nincuanuc'! ");
INSERT INTO chdNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Axpela' lan xanuc' itale'me, timiyi: ―¡Ti‑ch'ixcotso'! Tija'e' xonca ujfxi, ticua: ―¡Ima', otatahuelo cal rey David! ¡Aƚsinƚa' nincuanuc'! ");
INSERT INTO chdNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús ecax'ma, icuxe'e'mola' lan xanuc', timila': ―Toƚjoc'iƚe cal fo'. Ijoc'i'me, timiyi: ―Aimixpaij'mo', aimoxhueƚmot'ƚe'ma. Totsahuenni. Tijoc'ihuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Cal fo' eca'ni'ma lipuquiya, iyuf'conni, ecax'ma. I'hua'ma icuaitsi pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús icuis'e'ma cal fo', timi: ―¿Te caif'e'eyaco'? ¿Te ts'opic'a? Cal fo' timi: ―Momxi, aipic'a cahuetsaleƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús timi: ―To'huanƚa'. Joupa aƚ'huaiyijmpa, ixaƚconapo'. Aiquicoƚ'ma, exilinanni li'u'. Ipango'ma ihuej'ma Jesús pe lotsepa. ");
INSERT INTO chdNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tiyeyi lane ticuaita Jerusalén. A'ij culi' iƚe liƚya'. Icuaitsa ƚijuala Olivo pe lopa'a ƚiƚeloƚya' Betfagé jouc'a Betania. Jesús umme'mola' oquexi' ts'ilihuequi, ");
INSERT INTO chdNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","timila': ―Tonƚeƚe liƚya' lehuoc'ocojma. Jiƚpe loƚtsuflaiyacu liƚya' toƚsinna tifijnya anujnca anuli ƚa'hua burro. Iƚque cal burro aiquenafcaiyinni. Toluhuaƚtsa. Toƚ'hua'anca. ");
INSERT INTO chdNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ja'ni ticuis'entsolhuo', timintsolhuo': “¿Te culuhuaƚcopa cal burro?”, imanc' toƚtalai'e'e'me, toƚmi'me: “ȽaƚPoujna ipicuiya tixhuicota. Tijouƚa' ticuai'enacu.” ");
INSERT INTO chdNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iye'me ts'ilihuequi. Ixintsa ƚa'hua burro tifijnya lane pe lopa'a al puerta. Uhuaƚ'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Oquexi' afantsi tecaxoƚanna jiƚpiya icuis'e'me, timinnila': ―Imanc', ¿te culuhuaƚcopa cal burro? ");
INSERT INTO chdNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ts'ilihuequi Jesús italai'enca ma to limipola'. Lan xanuc' icu'me lane, ileco'me. ");
INSERT INTO chdNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Icuai'etsa ƚa'hua burro pe lopa'a Jesús. Ixpefi'me liƚpijahua' lixpula' cal burro. Jesús icutsafcai'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Axpela' lan xanuc' ixpou'me lane liƚpijahua', ocuenaye ixpou'me imane' c'ec joupa ixquejpá. ");
INSERT INTO chdNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lan xanuc' iƚej'me jouc'a ts'iƚenc'e tija'ayi, ticuayi: ―¡Hosana! ¡ȽanDios tunƚu'enatso', tipaxnetso'! ȽanDios ummepo'. ");
INSERT INTO chdNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ima' aƚcuxe'monga' al c'a! ¡Aƚcuxe'monga' to cal rey David licuxepola' laƚtatahueló! ¡Toƚta'a aƚpaxne'monga' ȽanDios! Iƚne nomana' lema'a jouc'a tinesle: “¡ȽanDios tunƚu'enatso'!” ");
INSERT INTO chdNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús itsufai'ma liƚya' Jerusalén. I'hua'ma al cuecaj xoute'. Joupa if'acoƚaipa. Ehuelojm'mola' lan xanuc', te ts'i'ic' lo'epa jiƚpiya. Ipanni. Jouc'a limbamaj coquexi' ts'ilihuequi iye'me lane liƚya' Betania. ");
INSERT INTO chdNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lihuequi litine ipalunca jiƚpe liƚya Betania ipailiconamma Jerusalén. Miyeyi lane Jesús tunle'e. ");
INSERT INTO chdNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tehuelonge aculi' ixim'ma anuli la'icux. Ixim'ma tipa'a ƚipela. I'hua'ma ixintsi al 'ec. Licuaitsi pe lopa'a al 'ec ixim'ma le'a ipela. Aiquicuaiya litine mimaqui ƚi'as icux. ");
INSERT INTO chdNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús timi la'icux: ―Nij naitsi noteja ƚo'as icux. Aimi'ascona'mo'. Ts'ilihuequi Jesús icuej'me lines'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Licuaicontsa Jerusalén Jesús itsufaicona'ma pe lopa'a al cuecaj xoute'. Jiƚpiya ipango'ma ipa'a'mola' nocucalepá jouc'a no'najualepá. Ejualaif'e'e'mola' liƚmesa iƚne nopai'ipaj tomí. Jouc'a nocujpá lan cucú ejualaif'e'e'mola' liletayats'. ");
INSERT INTO chdNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iƚne liƚtaic' locujyacu aiquepi'ila' lane muyalaiyacu ƚuna xoute'. ");
INSERT INTO chdNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Timuc'ila' lan xanuc' nomana' jiƚpiya, timila': ―Lataiqui' loya'apa locuxepa ȽanDios ticua: “Jiƚpe lainejut'ƚ ticuaicu lan xanuc', iƚne tiyouyunca ni petsi li'a ƚamats', jiƚpe aƚpalaic'o'ma”. ȽanDios ecuej'micopa iƚta'a lejut'ƚ. Itsiya tocomma a'i quejut'ƚ ȽanDios. Ti'onƚcospa to ƚunts'eja' pe lafoƚyomma lan namats'. Toƚta'a lonƚ'epa imanc'. ");
INSERT INTO chdNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios icuej'me locuapa Jesús. Tixpaic'eyi Jesús, ticuayi: ―Jahuay lan xanuc' iƚpic'a lomuc'iyalepa iƚque. Ehue'me te co'iya mima'ayacu. ");
INSERT INTO chdNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lif'acoƚaijma Jesús jouc'a ts'ilihuequi ipalconanca liƚya'. ");
INSERT INTO chdNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lihuequi litine uyalaicocona'me maƚe lane. Ixim'me la'icux joupa ijuƚnapa jouc'a ƚime. ");
INSERT INTO chdNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro i'nujuaitsi lines'ma Jesús, timi: ―Momxi, ¡toxinƚa' la'icux! Ima' omi'ma cataiqui', joupa ijuƚnapa. ");
INSERT INTO chdNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús italai'enni, timila' ts'ilihuequi: ―Imanc', ti'hua toƚ'huaiyijnle ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iya' camilhuo': Cal xans no'huaiyijmpa ȽanDios nipajnya ticuxe'ma iƚca'a ƚijuala, timiƚa': “To'huaƚa', to'nij'mixoxi ƚaja”. Ja'ni ma ti'huaiyinge, ja'ni ailopa'a conesya, iƚque tixim'ma ti'i'ma ma to licuxe'epa. ");
INSERT INTO chdNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iya' camilhuo': Ja'ni toƚ'huaiyijnyi ȽanDios, ja'ni toƚcuayi: “Joupa lapi'iponga' laƚsahue'epa”, iƚiya ƚinca tepi'i'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","’Moƚpalaic'oyi ȽanDios, ja'ni tolixtuc'oyi anuli ƚoƚpima aimi'hua molixtuc'ocona'me. Iƚque ƚoƚpima tolimenc'e'ecoƚe lixcay li'e'epolhuo'. Toƚta'a coƚ'Ailli' Nopa'a lema'a timenc'e'eco'molhuo' jouc'a lixcay loƚ'epa. ");
INSERT INTO chdNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ja'ni aimolimenc'e'ecoyi, coƚ'Ailli' Nopa'a lema'a jouc'a aimimenc'e'eyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Icuaiyocontsa liƚya' Jerusalén Jesús ti'hua jiƚpe ƚuna al cuecaj xoute'. Lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, jouc'a lan xanuc' noxpijpá lataiqui', iƚoc'oƚai'me pe lopa'a Jesús, ");
INSERT INTO chdNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","timiyi: ―¿Naitsi nummepo' to'eƚa' toƚta'a? ¿Naitsi nepi'ipo' lane? ");
INSERT INTO chdNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús timila': ―Iya' quicuis'e'molhuo' jouc'a. Aƚtalai'eƚa'. Tijouƚa' cami'molhuo' naitsi nalapi'ipa laimane ca'eƚa' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lu'iƚa': ¿Naitsi nepi'ipa limane Juan tepo'itsola' lan xanuc'? ¿Ja'ni ȽanDios nepi'ipa o ma le'a lan xanuc' epi'i'me? ");
INSERT INTO chdNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iƚniya ticuis'eyoƚtsi, timiyoƚtsi: ―Ja'ni aƚmiƚe: “ȽanDios epi'ipa limane”, Jesús aƚmi'monga': “¿Te aicolapenufi iƚque?” ");
INSERT INTO chdNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O ¿aƚmiƚe: “Lan xanuc' epi'ipá limane”? A'i, aimi'iya maƚmiyacu toƚta'a. Lixtuc'o'monga' lan xanuc'. Iƚne lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios tixpailiquila'. Lan xanuc' ticuayi: “Juan Bautista aprofeta, ȽanDios ummepa”. ");
INSERT INTO chdNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Italai'e'e'me Jesús, timiyi: ―Aicaƚsina'. Jesús timila': ―Iya' jouc'a aicamiyacolhuo' naitsi nalapi'ipa laimane. ");
INSERT INTO chdNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús ipango'ma i'onƚico'ma lo'epa ȽanDios fa'a li'a ƚamats'. Timila': ―Anuli cal xans ifapa ƚemats' ƚaifa' uva. Eti'ico'ma aitaƚ. Ipupa pe lotsuj'miyacu loxoc'eyonyacu lan 'uva, tipa'a'me laquija'. Ilanc'e'ma anuli li'nof'quiya lajut'ƚ, jiƚpiya tipajm'ma no'eya cuenna lan 'uva. Icu'ma ƚemats' lan xanuc' ti'etsa canic', tulij'me onƚca ƚaipammaiya. Aculi' i'hua'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Licuaitsi litine lipammaitsi lan 'uva umme'ma anuli ƚimozo. Timitola' lin'epá canic': “Lapi'iƚa' ƚi'huexi ƚaipoujna”. ");
INSERT INTO chdNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lin'epá canic' i'noƚ'me cal mozo. Ummena'me. Aiquilepi'i. ");
INSERT INTO chdNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ƚapoujna ummecona'ma ocuena quimozo. Licuaitsi jiƚpiya lin'epá canic' ixcai'e'me ƚijuac, imiloj'me cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ummecona'ma ocuenaj mozo. Iƚque cal mozo ima'a'me. Ummecona'mola' axpela' ocuenaye. Untafem'mola' jouc'a ima'am'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ipanenni ma le'a anuli naitsi ƚommeya. Iƚque i'hua, ti'ay capic'a juaiconapa. Umme'ma. Icua'ma: “Tixpaic'eta ƚai'hua”. ");
INSERT INTO chdNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lin'epá canic' timiyoƚtsi: “Iƚque i'hua ƚipoujna camats'. Aƚma'aƚe. Tijouƚa' aƚma'aƚe illanc' ticuainata caƚmane cal 'huexi.” ");
INSERT INTO chdNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Iƚne i'noƚ'me ƚamijcano, lima'a'me, ipa'a'me iƚe ƚamats' pe lifapa ƚaifa'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Ƚipoujna camats', ¿te co'e'eyacola' iƚne lin'epá canic'? Iya' camilhuo': Ƚapoujna ti'hua'ma pe lomana' iƚniya lan xanuc', tima'atola'. Ƚemats' lifapa ƚaifa' uva tepi'i'mola' ocuenaye lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Te a'i coƚsuec' al Paxi Liniƚingiya loya'apa te ts'i'ic' lo'iya? Ticua: Ƚapic ƚetets'ipa nolanc'epá lajut'ƚ, i'ipa xonca ƚaicuicoya. Iƚque ƚapic xonca tilanc'e ƚaitaƚ aimecangeya lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ȽanDios ƚaƚPoujna toƚta'a ƚecuej'micopa. Illanc' aƚsinyi acueca' iƚe li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios ixtuc'o'me Jesús, ticuayi: “Iƚque Jesús aƚ'onƚiconga' to iƚne lixcay lin'epá canic' jiƚpe ƚamats' lifampa cal 'uva”. Ehue'me te co'iya mi'noƚyacu Jesús. Ailopa'a qui'e'epa. Tixpaic'ennila' lan xanuc'. Ipo'no'me jiƚpe. Iyena'me. ");
INSERT INTO chdNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ummem'mola' lan xanuc' fariseo jouc'a lixanuc' cal rey Herodes. Ticuis'mot'ƚeta Jesús. Tehuaita. Ehue'me te co'iya micufyacu. ");
INSERT INTO chdNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Icuaitsa, timiyi Jesús: ―Momxi, aƚsina' ima' tonesqui al ƚinca. Aimahuay latenƚcocopola' lan xanuc'. Ma' anuli topalaic'ola' jahuay. Aimahuelongila' ja'ni i'hueca o aiqui'hueca. Tomuc'iyale lipene ȽanDios. Itsiya licuis'ehuo', ¿te aƚ'najtse'eta al tomí laƚsahue'eyaconga' cal cuecaj quincuxepa, iƚque César? O ¿aimaƚ'najtse'eyacu? Alu'itsonga', ¿nipajnya o aimi'iya? ");
INSERT INTO chdNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús ixina' te ts'i'ic' liƚpicuejma' iƚniya. Iƚpic'a tifel'miƚe. Ma le'a ti'e'eyoƚtsi to lan c'a xanuc'. Timila': ―¿Te calahuaicopa? Aƚtai'etsi anuli al tomí, caxinƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Itai'etsa. Jesús icuis'e'mola', timila': ―Iƚta'a al tomí, ¿naitsi iƚca'a ts'i'a? ¿Naitsi iƚta'a ts'ipuftine? ");
INSERT INTO chdNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Italai'e'e'me, timiyi: ―Li'a César, lipuftine César. Jesús timila': ―Ja'ni i'huexi César, tolapi'iƚe César. Ja'ni i'huexi ȽanDios, tolapi'iƚe ȽanDios. Licuej'me Jesús litalai'epola' icuapá: ―¡Xinƚa'! Acueca' lipicuejma' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lijou'ma icuaitsa pe lopa'a Jesús lan xanuc' saduceo. Iƚne naihuejpá lataiqui' loya'apa: “Lan xanuc' tima'mola' nulemma, aimimaf'iyacu”. Jouc'a tehuaiyi Jesús, icuis'e'me, timiyi: ");
INSERT INTO chdNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Momxi, pe liniƚpa Moisés aƚcuxenga', tuya'e': “Cal xans timaƚa', ma' imaf'i' ƚipeno ailopa'a qui'hua, ƚipima tileco'ma ƚi'maxi. Tipajntsi quiƚ'hua tecui'i'me lipuftine ƚimanapa. Timetsaicom'me to qui'hua ƚimanapa. Tepi'im'me ƚi'huexi ƚimanapa.” ");
INSERT INTO chdNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Itsiya lu'i'mo' li'ipa. ’Timana' acaitsi lapimaye. Cal te'a ileco'ma ƚipeno. Ailopa'a quiƚ'hua. Imanapa. ");
INSERT INTO chdNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ƚipima ƚimanapa ileco'ma ƚi'maxi. Ailopa'a quiƚ'hua, jouc'a imana'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jouc'a ƚocuena ƚipima ileco'ma ƚi'maxi. Ma' anuli uyaico'ma. Locuenaye amalujxi lipimaye ma toƚta'a luyalaico'me. Jouc'a ileco'me ƚiƚ'maxi, anuli anuli imana'mola'. Aiquiƚsina' quiƚ'hua. Lijou'ma imana'ma ƚaca'no' jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lan caitsi joupa ilecopá ƚaca'no'. Itsiya lu'itsonga': Ticuaitsi litine timaf'inaƚe limanapola', ¿naitsi co'iya ƚipe'ailli'? ");
INSERT INTO chdNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús timila': ―Imanc' timenaquilhuo'. Aicoƚsina' loya'apa al Paxi Liniƚingiya, aicolimetsaijma al cuecaj lo'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Timaf'inƚe lan xanuc' tipalnacu pe lomana' limanapola', iƚniya aimemalƚiyacu, ni lacuƚhue ni lacaƚ'no'. Ti'onƚcotola' to lapaluc' quema'a. ");
INSERT INTO chdNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","’Imanc' toƚcuayi: “Aimimaf'iyacu limanapola'”. ¿Te aicoƚsuec' liniƚpa Moisés? Jiƚpe tuya'e' li'ipa litine lonajpa lac'ec. Iƚe litine ȽanDios timi: “Iya' NanDios, ilenDios Abraham, Isaac y Jacob”. ");
INSERT INTO chdNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ȽanDios a'i quilenDios limanapola'. Iƚque ilenDios ts'iƚmaf'i'. Imanc' juaiconapa timenaquilhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jiƚpe tipa'a anuli ƚomxi nomuc'iyalepa locuxepa ȽanDios. Tiquimf'e iƚnu'hua laicuis'mot'ƚepa Jesús, ticueca Jesús titalai'e'ela' al c'a. Ipalaic'o'ma Jesús icuis'e'ma, timi: ―¿Te copa'a xonca al cueca' lataiqui' locuxepa ȽanDios? ");
INSERT INTO chdNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús italai'e'ma, timi: ―Iƚe lataiqui' xonca al cueca' tuya'e': “Aƚquimf'eƚa', imanc' ixanuc' Israel. ȽanDios, ƚalanDios, ma' iƚque anDios. Ailopa'a cocuena. ");
INSERT INTO chdNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ima' to'nujuaitsi ȽanDios ƚoPoujna. Iƚque omenDios. Taihuejla' jahuay ƚomunxajma', jahuay ƚo'alma, jahuay lopicuejma', jahuay lopujfxi.” ");
INSERT INTO chdNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Locuena lataiqui' locuxepa ȽanDios tuya'e': “Ima' to'eyoxi capic'a. Ma toƚta'a to'eƚa' capic'a ƚof'as xans, naitsi ƚoftalecufya.” Iƚna'a atsila' cataiquí. Xonca atsila' ailopa'a. ");
INSERT INTO chdNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ƚomxi timi: ―Momxi, ac'a lotaiqui' lonespa. Ma' al ƚinca lofcuapa. Tipa'a anuli ȽanDios, ailopa'a cocuena. ");
INSERT INTO chdNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aƚ'nujuaisle ȽanDios, alihuejle jahuay ƚalunxajma', jahuay laƚpicuejma', jahuay laƚpujfxi. Aƚ'etsola' capic'a laƚf'as xanuc' ma to maƚ'eyoƚtsi capic'a. Ja'ni toƚta'a aƚ'eyi, ticuaispa quipic'a ȽanDios. Ja'ni aimaƚ'eyacola' capic'a laƚf'as xanuc', tama aƚtsufcoƚe lopi'epa jiƚpe al altar, iƚe laƚ'ejma' aimicuaispa quipic'a ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús ixim'ma ƚomxi ac'a lipicuejma'. Italai'e'e'ma, timi: ―Ahuata lahue'epo' motsufaiya pe locuxeyopa ȽanDios, iƚque cal Cuecaj Rey. Lijou'ma ailopa'a quicuis'epa, ni anuli. Iƚsina' tulijna'mola' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mipa'a Jesús pe lopa'a al cuecaj xoute' ti'hua timuc'ila' lan xanuc'. Timila': ―Lomxiye nomuc'iyalepá locuxepa ȽanDios ticuayi: “Cal rey David itatahuelo cal Cristo”. ¿Te conescopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ituca' lonespa iƚque cal rey David. Muya'e' lataiqui' lu'ipa cal Espíritu Santo tuya'e': ȽanDios ipalaic'o'ma ƚaiPoujna, timi: “Tocutsaiƚa' jifa'a al c'a camane. Topanehuo fa'a, iya' mi'hua culiquila' lo'epo' laic'. Tijouƚa', ima' tocuxena'mola'.” ");
INSERT INTO chdNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Maƚque David inesco'ma cal Cristo, ticua “… ƚaiPoujna”. Ja'ni David itatahuelo cal Cristo, ¿te conescopa toƚta'a? Axpela' lan xanuc' noquimf'epá lomuc'iyalepa Jesús icuaitsi quiƚpic'a juaiconapa litaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mimuc'iyale Jesús tu'ila': ―Toƚpo'noƚe cuenna, aimifel'mi'molhuo' lomxiye nomuc'iyalepá locuxepa ȽanDios. Iƚniya iƚpic'a tipo'noƚe liƚpijahua' axehuay, tiyelocota to lan tsilaj xanuc'. Miyelocota jipu'hua pe lomana' axpela' lan xanuc', iƚpic'a tinonintsola'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ƚajut'ƚi pe lafoƚyomma lan xanuc' iƚpic'a ticutsoƚaiƚe xonca jipu'hua li'huáqui. Ja'ni tijoc'innila' tixmocota iƚpic'a ticutsoƚaiƚe petsi locutsoƚaiyacu lan tsilaj xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tijoutsaf'ennila' ƚiƚ'huexi lacaƚ'no' lam potsateya. Mi'eyi toƚta'a ti'e'eyoƚtsi to lan c'a xanuc'. Ticoƚi tipalaic'oyi ȽanDios. Tijouƚa', xonca titeƚ'mi'mola' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús ticutsu al cuecaj xoute' tehuelongila' lan xanuc' mi'nij'mi'me liƚtomí jiƚpe al caxax. Axpela' lan xanuc' ts'iƚ'hueca xonca ti'nij'miyi acueca'. ");
INSERT INTO chdNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Icuaitsi jiƚpiya anuli ƚaca'no' apotsate. Ailopa'a caquitomí. I'nij'mi'ma oque' al tomí acobre. Ailopa'a quipitali. ");
INSERT INTO chdNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús ijoc'i'mola' ts'ilihuequi, timila': ―Iya' camilhuo' al ƚinca: Iƚque cal potsate, aiqui'hueca, ulijpola' locuenaye. Etoj'mipa xonca. ");
INSERT INTO chdNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Locuenaye ni'nij'mipá liƚtomí jiƚpe, iƚniya aimehue'ela'. Tipanemma acueca' liƚtomí. Iƚquiya ƚaca'no' ailopa'a quipaneya, etoj'mipa jahuay, ailopa'a co'nacoya ƚoteja. ");
INSERT INTO chdNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mipalumma al cuecaj xoute' Jesús jouc'a ts'ilihuequi, anuli ts'ihuequi timi Jesús: ―Momxi, ¡toxinƚa'! ¡Atsila' iƚne lapic' lilanc'ecompa al xoute'! ¡Atsila' ƚajut'ƚi! ");
INSERT INTO chdNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús timi: ―Itsiya toxina iƚnu'hua atsila' ƚajut'ƚi. Ticuaihuo litine jahuay teteƚquehuo. Ni anuli ƚapic mipo'nof'queya ƚocuena capic. ");
INSERT INTO chdNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Micutsu Jesús ƚijuala Olivo, al huenajmay al cuecaj xoute', Pedro, Jacobo, Juan jouc'a Andrés iƚoc'oƚai'me pe lopa'a. Icuis'e'me, timiyi: ");
INSERT INTO chdNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Lu'itsonga', ¿te quitine mi'iya lofnespa? ¿Te co'iya mi'iya caƚsina' aimicoƚya lo'iya iƚiya? ¿Te jale maƚsinyacu? ");
INSERT INTO chdNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús ipango'ma u'i'mola' timila': ―Toƚpo'noƚe cuenna. Ja'ni a'i tifel'mi'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ticuaicu axpela' linfel'miyale, tines'me anuli anuli: “Iya' ninCristo, ȽanDios alummepa”. Iƚniya tifel'miyale'me. Axpela' lan xanuc' tepenuf'me liƚtaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Imanc' toƚcuej'me tifulenni jouc'a tifulem'me. Aimixpailij'molhuo'. Ma toƚta'a ti'i'ma. Ticoƚ'ma locuaicoya Lijoujma Quitine. ");
INSERT INTO chdNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lan xanuc' nomana' anuli al nación tixtuc'o'me, tifule'me lan xanuc' locuenaj nación. Lixanuc' anuli cal cuecaj quincuxepa tifule'me lixanuc' ƚocuena cal cuecaj quincuxepa. Ni petsi tinu'ma ƚunanto, ti'i'ma cumemma. Ma ti'onƚcota to ƚipumla ƚaca'no', toƚta'a tipango'ma al cueca' lateƚcoya. ");
INSERT INTO chdNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Toƚpo'noƚe cuenna. Ticum'molhuo', ticuaita liƚmane lan tsilaj xanuc' noxpijpá lataiqui'. Tilecom'molhuo' ƚajut'ƚi pe lafoƚyomma lan xanuc'. Jiƚpe tipam'molhuo'. Imanc' ts'alihuequi, toƚta'a lan xanuc' tixtuc'o'molhuo'. Tilecom'molhuo' pe lomana' lincuxepá jouc'a pe lomana' lan rey. Toƚta'a iƚne lan xanuc' ti'iƚa' quiƚsina' naitsi iya'. Imanc' tulu'i'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","’Ai'a ticuaihuo Lijoujma Quitine ni petsi li'a ƚamats' tuya'am'me te ts'i'ic' lixpic'epa ȽanDios, iƚe lataiqui' ac'a loya'apa. ");
INSERT INTO chdNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Litine ti'noƚintsolhuo', tilecotsolhuo' pe lomana' lincuxepá, aimoƚsueƚmot'ƚe'me. Aimoƚcua'me loƚpicuejma': “¿Te caƚtalai'e'ecoyacu?” Maƚpe al 'hora ȽanDios tepi'i'molhuo' loƚpicuejma' toƚtalai'eco'me al c'a. Iƚe loƚnesyacu a'i coƚtaiqui' imanc', ma' itaiqui' cal Espíritu Santo. Iƚque tipo'no'i'molhuo' loƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Ƚapima ticu'ma ƚipima tima'anƚe. Cal xans ticu'ma ƚi'hua. La'uhuay titsolicu, tixtuc'o'me quiƚ'ailli' quiƚ'máma'. Ticu'moƚtsi, tima'antsola'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Imanc' ts'alihuequi ni petsi loƚmanc'eyacu lan xanuc' ti'ejco'molhuo' laic'. Ja'ni toƚsnet'ƚ'me, ticuaitsi Lijoujma Quitine tolunƚul'me. ");
INSERT INTO chdNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ma to luya'apa cal profeta Daniel toƚta'a lo'iya. Iƚe pe ȽanDios tilaiqui tipo'nom'me petsi ailopa'a lane mipo'nonyacu. (Naitsi noxhuef'iyacola' iƚta'a lataiqui' ticuec'eƚa'.) ’Ti'iƚa' toƚta'a lo'iya, ja'ni toƚmana' al distrito Judea, tolinul―le, toƚf'ajle ƚijualay. ");
INSERT INTO chdNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ja'ni topa'a al toncay lomejut'ƚ aimaimuhuo motsufai'ma lomejut'ƚ. Aimocua'ma: “Tipa'a laifpa'aya”. Aimicoƚ'mo'. Ma tainuƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ja'ni topa'a pu'huanni cal 'ec, aimopaiconahuo mommaf'huo lopuquiya. Ma tainuƚa'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","’Acuanuc'la lacaƚ'no' linnaila' jouc'a notoc'alepá. Iƚe litine juaiconapa titeƚco'me. ");
INSERT INTO chdNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Toƚsa'hueƚe ȽanDios aimicuaihuo lateƚcoya ƚitiné caxita. ");
INSERT INTO chdNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","’Li'a ƚamats' tama joupa ixhuaita axpe' camats' mipa'a, lan xanuc' nomana' aiquiteƚma to loteƚcoyacu iƚe locuaicoya quitine. Tijouƚa' aimiteƚcoconayacu toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja'ni ȽanDios tixpic'eƚa' ticoƚtsola' iƚne ƚitiné ailopa'a conƚuya. Joupa ixpic'epa aimicoƚyacola' iƚne ƚitiné. Tixinnila' cuanuc'la lixanuc' jiƚne li'huijf'epola', ipic'a tunƚul―le. ");
INSERT INTO chdNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Jiƚne ƚitiné ja'ni timintsolhuo': “¡Toƚsinƚe! Jifa'a icuai'ma cal Cristo”, o “Jipu'hua icuaita”, aimoƚ'e'me ƚinca liƚtaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ticuaicu lan xanuc' nonespá: “Iya' ninCristo”, o “Iya' ninprofeta. Iya' canesqui lalu'ipa ȽanDios.” Iƚniya infel'miyale. Ti'e'me al cueca'. Iƚpic'a tinesle lan xanuc': “Iƚque ƚinca ummepa ȽanDios”. Ma le'a tifel'miyaleyi. Coƚa' tifel'mintsola' jouc'a li'huijf'epola' ȽanDios. Aimi'iya mifel'minyacola'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Toƚpo'noƚe cuenna. Joupa nu'ipolhuo' jahuay iƚe lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Tijoutsola' iƚne ƚitiné cateƚcoya ticuaihuo litine: “Timufc'o'ma cal 'ora, cal mut'ƚa aimepalc'o'iya. ");
INSERT INTO chdNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Lan xamna timefcoƚecu lema'a, jahuay lopa'a jiƚpe lema'a tife'nem'mola'.” ");
INSERT INTO chdNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tijouƚa' aƚsim'ma iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cacuaiconanni ƚummahuay quimuyohuo. Aƚsim'ma ninCuecaj Rey. Aƚsim'ma aƚ'onƚspa ma to ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jiƚe litine cumme'mola' lainepaluc' quema'a tiyeƚe tefot'ƚentsola' laixanuc' lai'huijf'epola'. Tileconnola' ni petsi lomana', iƚne nomana' lo'huayomma ƚahua', nomana' lotsepa ƚahua', nomana' pe liyuf'ma cal 'ora, nomana' pe lof'acaiyopa cal 'ora. Jahuay lipitoqui lipexpats'qui li'a ƚamats' tileconnola'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Lo'ipa al 'ec 'icux ti'onƚcospa to lo'iya. ¡Toƚcuejle! Toƚsinƚe tuxcuaf'eƚa' limane' al 'ec 'icux ti'i'ma coƚsina' icuaico'ma ƚinu'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jouc'a litine toƚsinƚe lo'ipa ma to lainu'ipolhuo' ti'iƚa' coƚsina' joupa aicuaico'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iya' camilhuo' al ƚinca: Ƚitiné ti'iƚa' to laifmipolhuo', lan xanuc' nomajnyacu fa'a li'a ƚamats' ti'onƚtola' to lan xanuc' nomana' fa'a itsiya litine. Anuli ti'i'ma liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lema'a jouc'a li'a ƚamats' tijou'mola'. Laitaiqui' aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Nij naitsi ts'ixina' litine ni al 'hora cacuaiconaya. Aiquiƚsina' lapaluc' quema'a, ni iya' i'Hua ȽanDios aicaixina' jouc'a. Ma le'a cai'Ailli' ƚinca ixina'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Imanc' toƚpo'noƚe cuenna. Ti'hua toƚmaf'iƚe. Aimi'i'molhuo' to noxmaipá. Tipantsi cumlata. Ti'hua toƚsa'hueƚe ȽanDios. Aicoƚsina' te quitine cacuaiyoconno. ");
INSERT INTO chdNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Itsiya lo'ipolhuo' imanc' ti'onƚcospa to li'ipola' lam mozó mi'huana'ma ƚiƚpoujna. Iƚque ƚapoujna epi'ipola' liƚmane ti'eƚe cuenna lajut'ƚ. Epi'ipola' liƚpenic', anuli anuli. Anuli ixc'ai'ipa ti'eƚa' cuenna al puerta, timi: “Aimoxmai'ma”. ");
INSERT INTO chdNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Jouc'a imanc' aimoƚsmai'me. Toƚpo'noƚe cuenna. Ja'ni a'i cacuaiyunni ca'huajcoco'molhuo' toƚsmaiyi. Aicoƚsina' te quitine cacuaiyoconno iya' oƚPoujna. Aicoƚsina' te 'hora, ja'ni if'acoƚaipa, ja'ni nolojmay quipuqui', ja'ni mija'a'ma ƚangiti, ja'ni liƚic'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","’Ma to laifmipolhuo' imanc' jouc'a laifnu'ipola' jahuay, camila': “Tipantsi cumlata, aimoƚsmai'me”. ");
INSERT INTO chdNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tehue'e ma le'a oquej quitine ti'i'ma al juic Pascua. Iƚne ƚitiné titem'me ƚa'i petsi aiquilai'inni levadura. Lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios ixpic'e'me tifel'miyale'me. Tehueyi te co'iya mi'noƚyacu Jesús, tima'aƚe. ");
INSERT INTO chdNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ticuayi: ―Tijouƚa' al juic. Itsiya efoƚumma axpela' lan xanuc', tixtulecu. ");
INSERT INTO chdNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús tipa'a liƚya' Betania lejut'ƚ Simón, iƚque ƚixaƚconapa licuana cuftine lahui lepra. Ticutsu Jesús titesma. Icuaitsi anuli ƚaca'no' itaic' al pulu capic alabastro. Al pulu tinango laceite tujuej c'a ilanc'ecompa anardo, acueca' lipitali. Ƚaca'no' ixquej'ma ƚejoc' al pulu. Ixcua'fi'ma laceite ƚijuac Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Oquexi' afantsi mimana' jiƚpe ixtulenca, timiyoƚtsi: ―Joupa ejac'pa laceite. ¿Te qui'ecopa toƚta'a ƚaca'no'? ");
INSERT INTO chdNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Acueca' lipitali, to mulij'ma cal xans no'epa canic' afane' maxnu quitine. Ja'ni coƚa' icuj'ma, coƚa' epi'i'mola' lan xanuc', iƚne petsi aiquiƚ'hueca. Tipalaicoyi quixcay ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús timila': ―Toƚe ti'iƚa'. ¿Te coƚpo'nocopa quixhuejma' ƚaca'no'? Iƚque i'epa al c'a. Latenƚcocopa li'epa. ");
INSERT INTO chdNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Imanc' tiƚmana' loƚpiƚya' xanuc' petsi aiquiƚ'hueca. Aimijouyacola' iƚniya. Jahuay ƚitiné ti'i'ma toƚspic'e'me te co'iya moƚtoc'iyacola'. Iya' a'i. Iya' aimaƚcoƚya capajnconaya fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iƚca'a ƚaca'no' i'epa ma to li'ommaita. Ai'a aƚma'ma aƚ'huaf'impa laceite laicuerpo. Joupa aƚƚanc'epa ai'a laminna. ");
INSERT INTO chdNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iya' camilhuo' al ƚinca: Ni petsi loya'anyacu Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios, jouc'a tuya'acom'me li'epa iƚca'a ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, iƚque anuli limbamaj coquexi' ts'ilihuequi Jesús, i'hua'ma pe lomana' lixanuc' cal cuecaj ca'ailli', ticuta Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iƚniya la'aillí licuej'me locuapa Judas ixoconni quileta juaiconapa. Epi'i'me cataiqui' ti'najtse'me. Judas ipango'ma ehue'ma te co'iya micuya Jesús, ticuaita quiƚmane la'aillí. ");
INSERT INTO chdNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Icuaitsi al te'a litine al juic. Iƚiya al juic titem'me ƚa'i aiquilai'inni levadura. Jiƚe litine tite'me lam mot'ƚ loma'anyacola' jiƚpe al juic. Ts'ilihuequi Jesús timiyi: ―¿Pe ts'opic'a caƚsmocoyoyacu al juic Pascua? Aƚƚanc'eta jahuay. ");
INSERT INTO chdNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesús umme'mola' oquexi' ts'ilihuequi, timila': ―Tonƚeƚe al cueca' quiƚya' Jerusalén. Jiƚpiya toƚtalecufta anuli cal xans itaic' lijuti caja'. Tolihuejtsa. ");
INSERT INTO chdNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Iƚque titsufaitsi anuli lajut'ƚ, imanc' jouc'a toƚsuflaitsa. Toƚmita ƚipoujna cajut'ƚ: “ȽaƚPomxi ticuis'ehuo': ¿Pe copa'a lajcuarto pe laƚsmocoyoyacu al juic Pascua, iya' jouc'a ts'alihuequi?” ");
INSERT INTO chdNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Timuc'itolhuo' anuli al cuarto lopa'a al toncay, joupa ixhueya. Imanc' toƚtaita ƚaƚtejacu, jiƚpiya aƚsmocota. ");
INSERT INTO chdNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iye'me ts'ilihuequi, itsuflai'me al cuecaj quiƚya', ixim'me jahuay to limipola' Jesús. Ilanc'e'me ƚotejacu alxmocojma al juic. ");
INSERT INTO chdNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lif'acoƚaipa icuaiyunca Jesús jouc'a limbamaj coquexi' ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Micutsoƚanna, mixmocoyi, Jesús timila': ―Camilhuo' al ƚinca: Anuli imanc' aƚcuna'ma, anuli jifa'a ƚoxmocopa. ");
INSERT INTO chdNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ts'ilihuequi ixhueƚmot'ƚe'me. Anuli anuli icuitsuf'ma, timiyi: ―¿Te aga iya'? Iya' a'i. ");
INSERT INTO chdNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús timila': ―Unc'imbamaj coquexi' anuli imanc' aƚcu'ma. Iƚque aƚjac'eyi ƚala'i anuli al pime. ");
INSERT INTO chdNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cuyaico'ma ma to micua al Paxi Liniƚingiya. Tama toƚta'a laifnuyaicoya, cal xans ƚaƚcuya a'ijc'a loyaicoya iƚque. Juaiconapa acueca' titeƚco'ma, ticua'ma: “Coƚa' aicaipajntsi iya'”. ");
INSERT INTO chdNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mitetsoyi Jesús epef'ma anuli ƚa'i, ix'najtsi'i'ma ȽanDios, ixquenuf'ma. Epi'i'mola' ts'ilihuequi, timila': ―Toƚteƚe. Iƚta'a aicuerpo. ");
INSERT INTO chdNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ihuof'ma al vaso. Lix'najtsi'i'ma ȽanDios, uhui'i'mola' ts'ilihuequi. Jahuay ixna'me. ");
INSERT INTO chdNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Timila': ―Iƚta'a aijuats', tiƚinc'i'ma al ts'e quitaiqui' ȽanDios lopo'no'ipola' lixanuc'. Iya' caxcuajai'ma laijuats' tunƚul―le axpela'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iya' camilhuo' al ƚinca: Jifa'a li'a ƚamats' aicaxnaconaya vino. Ticuaitsi litine lan xanuc' tixinƚe ȽanDios micuxe, jiƚe litine caxnacona'ma al ts'e vino. ");
INSERT INTO chdNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lijoupa lunac'copa ȽanDios ipalunca. Iye'me ƚijuala Olivo. ");
INSERT INTO chdNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús timi ts'ilihuequi: ―Iƚta'a lipuqui' imanc' tolanaj'moƚtsi, aƚpo'no'ma caituca'. Ti'i'ma to muya'e' al Paxi Liniƚingiya, ticua: “Caxcai'e'ma ƚiƚpoujna lam mot'ƚ, iƚque tima'ma. Lam mot'ƚ teca'ne'moƚtsi.” ");
INSERT INTO chdNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tijouƚa' camaf'inaƚa' ca'hua'ma al distrito Galilea. Ca'huaicotolhuo' jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro timi Jesús: ―Tixtuc'otso' jahuay laipimaye, tama tenajtsoƚtsi, iya' a'i. ");
INSERT INTO chdNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús timi Pedro: ―Cami'mo' al ƚinca: Itsiya lipuqui' ai'a tija'a'ma ƚangiti oquemma, ima' tones'ma afanemma: “Aicainimetsaijma Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro ti'hua tipalaic'o Jesús, ihui'ipa, timi: ―Tama aƚma'atsonga' iya' ima', aicanesya: Aicainimetsaijma Jesús. Ni anulemma canesya toƚta'a. Ma' anuli ines'me jahuay locuenaye. ");
INSERT INTO chdNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Icuaitsa al lugar cuftine Getsemaní. Jesús timila' ts'ilihuequi: ―Imanc' toƚcutsoƚaiƚe fa'a. Iya' capalaic'ota ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ileco'mola' Pedro, Jacobo jouc'a Juan. Ipango'ma tixina acueca' juaiconapa iƚe lo'iya, tixhueƚma juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Timila' lam fantsi: ―Juaiconapa cahuosma, ma tocomma aƚma'ma quixhuejma'. Toƚmanenca jifa'a. Aimoƚsmai'me. ");
INSERT INTO chdNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Uyai'ma huata, ixpats'huai'ma ƚamats'. Tixa'hue ȽanDios ja'ni ti'i'ma tuyaicotsi jiƚe al 'hora. ");
INSERT INTO chdNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Timi: ―Abba, mai'Ailli', ima' jahuay nipajnya to'e'ma. Liƚonc'e'eƚa' iƚta'a laifteƚcopa. Ma caxa'huehuo' toƚta'a jouc'a camihuo': Ti'iƚa' lofxpic'epa ima', a'i latenƚcocopa iya'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ipaiconanni, icuaitsi pe lomana' lam fantsi ts'ilihuequi. Ixim'mola' tixmaiyi. Timi Pedro: ―Simón, ¿ima toxmay? ¿Te aimi'iya momaf'iya ni anulij hora? ");
INSERT INTO chdNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Toƚmaf'iƚe jahuay imanc'. Toƚsa'hueƚe ȽanDios titoc'itsolhuo' aimehuaiyim'moƚhuo'. Imanc' toƚcuayi: “Aƚsnet'ƚ'me”. A'i, aimi'iya. Loƚcuerpo ailopa'a quipujfxi. ");
INSERT INTO chdNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","I'huacona'ma, tixa'hueconata ȽanDios. Ma' anuli ixahue'econa'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ipaiconanni icuaiyocontsi pe lomana' lam fantsi, ixingona'mola' tixmaiconayi. Tixinyi timufquemma liƚ'u'. Ticui quilehui. Aiquiƚsina' te cotalai'e'eyacu Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","I'huacona'ma. Ipaiconanni. Joupa i'ipa afanemma. Icuaiyocontsi pe lomana' lam fantsi. Timila': ―Imanc', ¿ti'hua toƚsmaiyi? ¿Tolunxajyi? Ne', ti'iƚa'. Ixhuaita lai'hora. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ¡Toƚsinƚe! Aƚcu'ma. Aƚ'noƚ'ma lan xanuc', iƚne aimimetsaicoyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Toƚsolinca! ¡Ƚepá! Joupa icuaico'ma iƚquiya ƚaƚcuya. ");
INSERT INTO chdNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mipalay Jesús icuaitsi Judas, iƚque anuli limbamaj coquexi' ts'ilihuequi Jesús. Ilecola' axpela' lan xanuc' iƚtaic' liƚ'espada jouc'a liƚ'ec. Iƚne lan xanuc' ummempola' lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, jouc'a lan tsilaj xanuc' noxpijpá lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iƚque ƚocuya Jesús joupa u'ipola' te ts'i'ic' mimetsaicoyacu Jesús. Joupa imipola': “Cal xans ƚaiftuc'oya jiƚque toƚ'noƚƚe. Toƚƚecoƚe. Aiminuc'e'molhuo'.” ");
INSERT INTO chdNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Licuaitsi jiƚpiya Judas aiquicoƚ'ma iƚoc'huai'ma pe lopa'a Jesús, timi: ―¡Momxi! Ituc'o'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lan xanuc' i'noƚ'me Jesús. Aicux'mas'me. ");
INSERT INTO chdNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tipa'a anuli ts'ihuequi Jesús tecaxu jiƚpe. Iƚque ipa'a'ma li'espada, ixcai'e'ma ƚimozo cal cuecaj ca'ailli', etec'e'e'ma lix'mas. ");
INSERT INTO chdNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús ipalaic'o'mola' iƚniya licuai'me ti'noƚƚe, timila': ―¿Te coƚcuaiyoco'me fa'a oƚtaic' loƚ'espada jouc'a lonƚ'ec? ¿Ja'ni toƚna'a aƚ'noƚƚa'? ¿Aga toƚcuayi: “Iƚque inma'ahuale”? ");
INSERT INTO chdNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Itine itine aƚmajmpá anuli jiƚpe al cuecaj xoute', aicaƚ'noƚi. Ne', ti'iƚa' ma to loya'apa al Paxi Liniƚingiya. Ticuicomma tenanƚƚa' jahuay iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lixanuc' Jesús inulai'me, ipo'no'me Jesús quituca'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jiƚpe tipa'a anuli ƚamijcano ihuequi Jesús. Iƚque ƚamijcano iju'eyoxi ma le'a lisábana. Jouc'a i'noƚim'me. ");
INSERT INTO chdNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ƚamijcano ipanenni lisábana, inu'ma amila. ");
INSERT INTO chdNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ileco'me Jesús pe lopa'a cal cuecaj ca'ailli'. Jiƚpiya efot'ƚe'moƚtsi lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro i'huanc'e'ma aculi'. Itsufai'ma ƚipuna quejut'ƚ cal cuecaj ca'ailli'. Jiƚpe icutsingai'mola' lepaluc' cal cuecaj ca'ailli'. Jiƚpe ƚunga tifununc'eyoƚtsi anuli. ");
INSERT INTO chdNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lixanuc' cal cuecaj ca'ailli' jouc'a jahuay noxpijpá lataiqui' tehueyi naitsi nocufya Jesús. Toƚta'a ti'i'ma tima'anƚe. Aiqui'ic'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Axpela' lan xanuc' tuyout'ƚecoyi Jesús, ma le'a tifelƚaiqueyi. Anuli anuli, ituca' ituca' tinesqui. Aiqui'ic' anuli liƚtaiqui' lonespa. ");
INSERT INTO chdNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oquexi' afantsi itsolinca uya'a'me ocuena lafelƚaiqueya, timiyi: ");
INSERT INTO chdNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Illanc' aƚcuejpá iƚque linespa, ticua: “Iya' nulemma cateƚ'ma iƚta'a al cuecaj xoute' lilanc'epa lan xanuc'. Tuyaiƚa' afane' quitine iya' joupa ailanc'econapa ocuena. Iƚe a'i quiƚƚanc'e'e lan xanuc'.” ");
INSERT INTO chdNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni iƚne nonespá aiqui'ic' anuli liƚtaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Itsahuenni cal cuecaj ca'ailli', icuis'e'ma Jesús, timi: ―¿Te ima' aimotalai'ecoyacoxi? ¿Te onespa iƚe lataiqui', o aiconesqui? ");
INSERT INTO chdNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aiquitalai'e. Ailopa'a quitaiqui'. Cal cuecaj ca'ailli' icuis'econa'ma, timi: ―¿Te ima' unCristo? ¿Te ima' i'Hua cal Paxi CanDios? ");
INSERT INTO chdNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús timi: ―Ma' iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Imanc' aƚsim'ma cacutsuya al c'a camane cal Cuecaj Rey. Aƚsim'ma quimuyohuo lema'a, cacuaiyoconno ƚamats' nolojmay cummahuay lema'a. ");
INSERT INTO chdNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Cal cuecaj ca'ailli its'aƚ'ma lipijahua', imujpa lipoyac'. Aiquetenƚcocojma locuapa Jesús. Timila' lixanuc': ―Itsiya, ¿te calahuecoyacola' ocuenaye lan xanuc' ticufle? ");
INSERT INTO chdNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Imanc' oƚcuejpá lonespa. Etets'ipa ȽanDios. ¿Te coƚcuapa imanc'? Jahuay icuxeco'me Jesús, ticuayi: ―Tipa'a lijunac'. ¡Tima'anƚe! ");
INSERT INTO chdNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Oquexi' afantsi ipango'me itsuƚco'me, ifi'e'eco'me ijahua' li'u', untaf'me li'a, ipa'me, timiyi: ―Tocua'aƚa', ¿naitsi lipa'mo'? Lepaluc' cal cuecaj ca'ailli' ipets'me camane jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ipanenni al 'ocay, ticutsu ƚuna. Uyai'ma anuli ƚicriada cal cuecaj ca'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ixim'ma Pedro tifununc'eyoxi jiƚpe ƚunga. Ehuelojm'ma, timi: ―Ima' jouc'a omihuequi cal xans ƚas Nazaret, iƚque Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro icuanajpa, timi: ―Aicaixina'. Aicaicueca lofnespa. Ipanni, ecax'ma pe lopa'a al puerta. Ija'a'ma ƚangiti. ");
INSERT INTO chdNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ƚajcriada nopa'a jiƚpe ixim'ma Pedro. Ipalaic'o'mola' nacaxhuoƚanna, timiconala': ―Iƚca'a anuli iƚniya ts'ilihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro icuanajcona'ma. Uyai'ma ni huata, iƚne nacaxhuoƚanna jiƚpiya timiyi Pedro: ―Ima' jouc'a mihuequi Jesús. Ima' mas Galilea. ");
INSERT INTO chdNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro ipango'ma i'e'ma jurar, timila': ―Iya' camilhuo' al ƚinca. Ja'ni a'i, ¡aƚma'aƚa' ȽanDios! Iya' aicainimetsaijma iƚque cal xans ƚoƚpalaicopa. ");
INSERT INTO chdNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aiquicoƚ'ma, ija'acona'ma ƚangiti. Pedro i'nujuaitsi limipa Jesús: “Ai'a tija'a'ma oquemma ƚangiti, ima' tones'ma afanemma: Aicainimetsaijma Jesús.” Li'nujuaitsi iƚe lataiqui' Pedro ijoj'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Liƚic'ejma lixanuc' cal cuecaj ca'ailli', lan tsilaj xanuc', lomxiye nomuc'iyalepá locuxepa ȽanDios jouc'a jahuay noxpijpá lataiqui' ixpic'e'me lo'e'eyacu Jesús. Aiquicoƚ'ma, ifi'e'me, ileco'me pe lopa'a Pilato, iƚque incuxepa romano. Jiƚpe icu'me. ");
INSERT INTO chdNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato icuis'e'ma Jesús, timi: ―¿Ima' iƚrey lan xanuc' judío? Jesús italai'e'e'ma, timi: ―Al ƚinca lofcuapa. ");
INSERT INTO chdNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lixanuc' cal cuecaj ca'ailli' icuf'me juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato icuis'econa'ma, timi: ―¿Te ima' aimotalai'ecoyacoxi? Joupa ocuejpa. Ticufhuo' acueca' lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesus aiquitalai'e. Pilato aiquixina' te cocuaya. Icuapa lipicuejma': “Iƚca'a Jesús, ¿te aimitalai'e?” ");
INSERT INTO chdNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ajuic ajuic Pascua, Pilato ticu lane lan xanuc' tixahue'eƚe anuli ƚitats'iya, tux'mas'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iƚta'a al juic tipa'a anuli ƚitats'iya cuftine Barrabás. Iƚquiya i'noƚinc'innila' jouc'a liyejmalepá. Iƚniya itsolimma ehuoc'huaipá cal gobierno romano. Ima'apá lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Icuaitsa lan xanuc' pe lopa'a Pilato. Ixa'hue'me ti'eƚa' ma to mi'ay. ");
INSERT INTO chdNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato icuis'e'mola', timila': ―¿Nai ts'oƚpic'a? Imanc' unc'ijudío, ¿te cux'mas'ma ƚoƚrey? ");
INSERT INTO chdNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Toƚta'a licua'ma Pilato, imetsaicola' iƚne lixanuc' cal cuecaj ca'ailli'. Ixina' te ts'i'ic' liƚpicuejma'. Ixina' ti'eyi laic' Jesús, toƚiya joupa icupá. ");
INSERT INTO chdNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lixanuc' cal cuecaj ca'ailli' icuxe'me, imi'me lan xanuc' timiƚe Pilato tux'masnaƚa' Barrabás. ");
INSERT INTO chdNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato icuis'econa'mola', timila': ―Iƚque ƚolacui'ipa oƚrey, ¿te caif'e'eya iƚquiya? ");
INSERT INTO chdNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ija'acona'me, italai'e'me, timiyi: ―¡Tapaƚts'ijnla' lancruz! ");
INSERT INTO chdNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato icuis'e'mola', timila': ―¿Te caifnepaƚts'ijncoya lancruz? ¿Te quixcay qui'epa? Ija'a'me ujfxi, timiyi: ―¡Tapaƚts'ijnla' lancruz! ");
INSERT INTO chdNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato ipic'a tetenƚcocotsola' lan xanuc'. I'e'ma to lixa'hue'me. Ux'masna'ma Barrabás, icuxe'ma tipalojle Jesús. Epi'ipola' lan soldado tepaƚts'ijnta lancruz. ");
INSERT INTO chdNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lan soldado ileco'me Jesús ƚuna lejut'ƚ cal gobernador. Jiƚpiya ƚuna cuftine al Pretorio. Jiƚpiya efot'ƚe'moƚtsi jahuay liƚf'as soldado. ");
INSERT INTO chdNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Itats'mi'me Jesús lunxali cumi quijahua', ma to liƚpijahua' lan rey. Ipuf'me anuli al corona quitac, ic'ommof'i'i'me ƚijuac Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ipango'me inom'me, ija'a'me: ―¡Aƚnonghuo', ima' iƚrey lan xanuc' judío! ");
INSERT INTO chdNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tuntaf'e'eyi ƚijuac ajaxa, titsuƚc'oyi. Exc'onƚingai'me. ");
INSERT INTO chdNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lijoupa lixocopa, ipa'e'e'me lunxali cumi quijahua', itats'micona'me ma lipijahua'. Ileco'me ipa'anca lema quiƚya', tepaƚts'ijnta lancruz. ");
INSERT INTO chdNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Miyeyi lane italecuf'me anuli cal xans cuftine Simón, ƚas Cirene. Iƚque iƚ'ailli' Alejandro jouc'a Rufo. Icuaico'ma qui'huayonamma cal 'ec. Icuxe'e'me titaiƚa' lencruz Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Icuai'etsa Jesús petsi cuftine Gólgota, luhuaƚquemma: Ƚamats' Quecoye. ");
INSERT INTO chdNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jiƚpiya icufi'me al vino ihuantsi al mirra. Ja'ni tixnaƚa' aijtine mixingufcoya ƚumla. Jesús aiquixnaic'. ");
INSERT INTO chdNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Epaƚts'ingim'me lancruz. Lan soldado if'ilco'me lipijahua', naitsi nolijya. Anuli anuli tulij'ma locuaiya quimane. ");
INSERT INTO chdNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ixhuaita al pelƚa 'hora lepaƚts'ijm'me Jesús lencruz. ");
INSERT INTO chdNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ipo'nompá lacaxma loya'apa licuxecompa Jesús, ticua: “Iƚca'a iƚrey lan xanuc' judío”. ");
INSERT INTO chdNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesús epaƚts'ingimpola' oquexi' linma'ahuale. Anuli tipa'a al c'a camane, ƚocuena loxa camane. ");
INSERT INTO chdNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ma toƚta'a enanƚcopa al Paxi Liniƚingiya loya'apa: “I'e'empá ma to lo'e'enyacola' lan xanuc' ni'epá lixcay”. ");
INSERT INTO chdNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lan xanuc' noyalaicopá jiƚpiya imiloj'me cataiqui', ife'ne'me ƚiƚjuac, timiyi: ―Ima' lofmeteƚya al cuecaj xoute', tijouƚa' afane' quitine joupa olanc'econapa, ");
INSERT INTO chdNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ne', taimunni lomencruz. ¡Tonƚu'exoxi! ");
INSERT INTO chdNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios ixoco'me, timiyoƚtsi: ―Iƚque unƚu'epola' locuenaye. Itsiya aimi'iya munƚu'eyacoxi. ");
INSERT INTO chdNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Illanc' ixanuc' Israel, ja'ni iƚque aƚrey, ja'ni aCristo, ¡timunni lencruz! Aƚsinƚe illanc', tijouƚa' lapenuf'me. Iƚniya lepaƚts'ingimpola' Jesús imiloj'me cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Li'i'ma menac'o imufc'o'ma jahuay lema'a. Ni petsi li'a ƚamats' tocomma ipuqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Al fanej hora lummuhuijma' Jesús ija'a'ma ujfxi, ticua: ―Eloí, Eloí, ¿lama sabactani? Iƚiya lohuaƚquemma ticua: “Ima' mainenDios, ¿te calacanujcopa?” ");
INSERT INTO chdNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Timana' lan xanuc' nacaxoƚanna jiƚpiya icuej'me lines'ma Jesús, iƚniya lines'me: ―¡Xinƚa'! Tijoc'i cal profeta Elías. ");
INSERT INTO chdNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Anuli cal xans icuaiconni tinu, ijac'eco'ma al esponja acuxac vino. Icants'i'ma al jaxa, i'nof'e'ma lico Jesús, titsif'la'. Iƚque cal xans ticua: ―¡Toƚe! Aƚsim'me ja'ni ticuaihuo Elías, tipuƚna'ma lencruz. ");
INSERT INTO chdNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús ija'a'ma ujfxi. Exnalif'ma, imana'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lijahua' lojujnya al cuecaj xoute' its'aƚquenni quituca', al toncay itejmay ƚamats'. Iƚe lijahua' lipa'ne jiƚpe Lajut'ƚ Xonca al Paxi. ");
INSERT INTO chdNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nocuxepola' lan soldado tecaxu anujnca lencruz Jesús, tehuelonge. Ixim'ma Jesús lima'ma ma mija'e' toƚta'a. Ticua: ―Ma' aƚinca iƚca'a cal xans i'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Timana' lacaƚ'no' tecaxoƚanna aculi', tehuelojnyi. Tipa'a María ƚas Magdala, tipa'a María quiƚ'máma' Jacobo y José. Iƚque Jacobo ƚecui'impa: Ƚijoujma. Jouc'a tipa'a ƚaca'no' cuftine Salomé. ");
INSERT INTO chdNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mipa'a Jesús al distrito Galilea iƚniya lacaƚ'no' ihuejpá Jesús, itoc'ipá, ites'mipá. Maƚpiya tehuelojnyi Jesús mipa'a lencruz timana' locuenaye lacaƚ'no' jouc'a. Iƚne y Jesús anuli icuaiyunca Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Iƚe litine avispera. Lihuequi litine itine conxajya. Joupa if'acoƚaipa. ");
INSERT INTO chdNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Anuli cal xans cuftine José, ƚas Arimatea, i'hua'ma ixintsi cal gobernador Pilato. Iƚque José acuecaj xans, anuli pe iƚniya nafot'ƚepoƚtsi noxpijpá lataiqui'. Iƚque i'huaijma ticuaitsi litine jahuay lan xanuc' tihuejcoƚe ȽanDios ƚiƚCuecaj Rey. José i'e'e'moxi acueca' ƚunxajma'. Itsufai'ma pe lopa'a Pilato, ixahue'etsi tepi'inaƚe licuerpo Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ticua: “Ma' imaf'i' Jesús, aiquimac'”. Ijoc'i'ma nocuxepola' lan soldado. Icuis'e'ma ja'ni joupa imapa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nocuxepola' lan soldado timi: “Ƚinca, joupa imapa Jesús”. Pilato epi'i'ma lane José tilecotsi licuerpo Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José ipuƚna'ma licuerpo Jesús jiƚpe lencruz. Iju'eco'ma afujca quijahua' lilanc'ecompa alino, i'na'apa ats'e. I'nicohuo'ma anuli ƚunts'eja', ipuc'o'iya ƚapic. Imef'ma anuli cal cueca' capic, ipa'neco'ma lico ƚunts'eja'. ");
INSERT INTO chdNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María ƚas Magdala, jouc'a María qui'máma' ƚocuenaj José, ehuelojm'me pe lipo'no'enghuo'me licuerpo Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Luyai'ma litine conxajya María ƚas Magdala, María qui'máma' Jacobo, jouc'a ƚaca'no' Salomé, iye'me i'natsa laceite tujuej c'a ti'huof'ita licuerpo Jesús. ");
INSERT INTO chdNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","I'i'ma quitine al te'a quitine al xamano. (Iƚiya adomingo.) Tipammaiyumma cal 'ora, icuaitsa ƚunts'eja'. ");
INSERT INTO chdNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Timiyoƚtsi: ―¿Naitsi laliƚonc'e'eyaconga' ƚapic ƚeti'icoya lico cunts'eja'? ");
INSERT INTO chdNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lixim'me lico cunts'eja' ixim'me joupa iƚonc'empa ƚapic, ipo'nompa jiƚpe anuli liju'. Iƚque ƚapic juaiconapa acueca'. ");
INSERT INTO chdNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Itsuflai'me ƚunts'eja', ixim'me al c'a camane ticutsu anuli ƚamijcano. Afujca lipijahua', axehuay. Ixpailij'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ƚamijcano timila': ―Aimixpailij'molhuo'. Tolahueyi Jesús ƚas Nazaret, maƚque ƚepaƚts'ingimpa. Ilque ailopa'a fa'a. Joupa imaf'inapa. ¡Tolahuelongunca! Jifa'a lipo'no'empa licuerpo. ");
INSERT INTO chdNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Imanc' tonƚenƚe, tolu'itsola' ts'ilihuequi Jesús, jouc'a Pedro, toƚmitsola': “Jesús ti'hua'ma Galilea. Toƚcuaitsa jiƚpiya toƚtalecufta ma to limipolhuo'.” ");
INSERT INTO chdNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lacaƚ'no' ipalunca ƚunts'eja'. Inul'me. Juaiconapa tixpailiquila', tiyula'. Nij naitsi lu'ipa. ");
INSERT INTO chdNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús imaf'ina'ma liƚic'ejma' al te'a quitine al xamano, iƚiya adomingo. Imuj'moxi ate'a María ƚas Magdala, iƚque ƚaca'no' ƚipa'empa acaitsi lontahue. ");
INSERT INTO chdNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iƚque i'hua'ma u'itsola' liyejmalepá Jesús. Iƚniya tihuotsoyi, tijolijyi. ");
INSERT INTO chdNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","María timila': ―Jesús imaf'i'. Iya' aiximpa. Iƚniya aiquiƚ'aic' ƚinca locuapa. ");
INSERT INTO chdNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesús imujcona'moxi pe lomana' oquexi' ts'ilihuequi. Jiƚniya tiyeyi lane ticuaita cal 'ec. Imuj'moxi tocomma ipaicomma. ");
INSERT INTO chdNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iƚne loquexi' ipailiconanca, licuaitsa pe lomana' liƚpimaye, uya'a'me liximpa Jesús. Liƚpimaye inescona'me: “A'ij ƚinca”. ");
INSERT INTO chdNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lijou'ma Jesús imuj'moxi pe lomana' limbamaj nuli ts'ilihuequi. Iƚniya titetsoyi. Itale'mola' iƚniya nonespá: “A'ij ƚinca iƚe loya'apa laƚpimaye. Aiquimaf'i' Jesús.” Ixim'mola' ata liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús timila': ―Tonƚeƚe ni petsi li'a ƚamats'. Toluya'atsa Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Tolu'itsola' jahuay lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iƚne napenufyacu Lataiqui', tepoliƚe, iƚniya tunƚul'me. Naitsi aimepenufi Lataiqui', iƚque tecani'ma. ");
INSERT INTO chdNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","’Tixinim'me al cueca' lo'eyacu iƚne napenufyacu Lataiqui'. Tipa'a'me lontahue litsuflaipá lan xanuc', tipalai'me ituca' liƚtaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ja'ni ti'noƚƚe lainofat'ƚ o tixnaƚe cafxi cummaiya ailopa'a co'e'eyacola'. Tixpayaf'me liƚmane lafcualƚay, iƚne tixaƚcona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lijoupa limipola' toƚta'a caƚ'Ailli' Jesús if'ajna'ma lema'a. Jiƚpe icutsingaitsi al c'a camane ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ts'ilihuequi Jesús ipalunca. Ni petsi uya'atsa Lataiqui', iƚe loya'apa al c'a lixpic'epa ȽanDios. ȽanDios liyejmalepa, i'e'ma acueca'. Toƚta'a imuc'i'mola' lan xanuc' aƚinca Lataiqui' loya'apa ts'ilihuequi Jesús.");
INSERT INTO chdNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ima' cumTeófilo, iya' ninLucas cumme'ehuo' coje'e. Iƚta'a al je'e tuya'e' li'ipa fa'a ƚamats'. Laƚpimaye nepenufpá liƚpenic' tuya'ayi Lataiqui', iƚe loya'apa al c'a lixpic'epa ȽanDios. Iƚniya joupa lu'iponga' li'ipa, iximpá. Axpela' lapimaye joupa iniƚpá liƚje'e loya'apa toƚta'a li'ipa. Iya' jouc'a aixpic'epa quiniƚ'ma laije'e. Cacua: Iƚque Teófilo joupa imuc'impá litaiqui' Jesucristo. Jouc'a ipic'a quije'e loya'apa te ts'i'ic' li'ipa. Iya' joupa aixhuepa jiƚe li'ipa, aipalaic'opola' lapimaye ts'iƚsina' te ts'i'ic' li'ipa iƚniya ƚitiné. Aixpot'ƚenapa lataiqui'. Cuya'e' te ts'i'ic' lipangopa, jouc'a cuya'e' te ts'i'ic' lijoucopa. Ima' toxhueƚa', toƚta'a ti'i'ma coxina' te ts'i'ic' Lataiqui' limuc'impo', iƚe tuya'e' al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Micuxe Herodes al distrito Judea tipa'a anuli ƚa'ailli' cuftine Zacarías. Iƚque jouc'a lif'as ca'aillí ti'e'me canic' al cuecaj xoute'. Mi'huajco'mola' munaitola' ti'e'me canic'. Iƚniya ixanuc' Abías. Zacarías ƚipeno cuftine Elisabet. Iƚque Elisabet ƚitatahuelo cuftine Aarón. ");
INSERT INTO chdNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Loquexi' ac'a xanuc', tihuejcoyi jahuay locuxepa ȽanDios, jahuay loya'apa litaiqui' ȽanDios. Aiquimenaquila'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tama etenƚcocopa ȽanDios iƚniya liƚ'ejma' ailopa'a quiƚ'hua. Elisabet ijuiqui caca'no'. Loquexi' joupa itsilojnapola'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Icuaitsi litine ti'eta canic' lixanuc' Abías, Zacarías i'hua'ma al cuecaj xoute', ti'eta canic' ma to locuxepa ȽanDios, iƚque a'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zacarías ec'aiƚmaita lipenic' titsufai'ma al paxi cajut'ƚ, tipi'eta ƚipac'ec. Toƚta'a mi'eyi la'aillí jiƚpe al cuecaj xoute'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Locuenaye lan xanuc' aimitsuflaiyi al paxi cajut'ƚ. Ailopa'a lane. Iƚniya tiƚmanemma ƚuna. Jiƚe litine mipi'e ƚipac'ec Zacarías, axpela' lan xanuc' comana' ƚuna jiƚpe al paxi cajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Maƚpiya lajut'ƚ imaxcaitsi anuli ƚapaluc quema'a ƚummepa caƚ'Ailli' ȽanDios. Ƚapaluc quema'a ecax'ma al c'a camane al altar petsi lopi'eyompá ƚipac'ec. ");
INSERT INTO chdNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lixim'ma ƚapaluc quema'a Zacarías ixhueƚconni. Ticua: “¿Te iƚca'a?” Ixim'ma axpaiqui' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ƚapaluc quema'a timi: ―CunZacarías, aimixpaij'mo'. ȽanDios joupa icuejpa loxahue'epa. Elisabet ƚopeno tipo'no'e'mo' co'hua amijcano. Ima' tacui'i'ma Juan. ");
INSERT INTO chdNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iƚque ƚa'hua tetenƚcoco'mo' juaiconapa, tixoc'i'mo' meta. Tipajntsi iƚque tixoj'ma quileta axpela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","’Titojla' iƚque ȽanDios timetsaico'ma acueca' xans. Aimixnaya al vino, jouc'a aimixnaya mimeyojya. Iƚque Juan, ma litine tipajntsi, joupa ticuxe lipicuejma' cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tilanc'e'e'mola' liƚpicuejma' axpela' lan xanuc', iƚniya ixanuc' Israel. Toƚta'a tihuejcona'me ƚilenDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ti'huaj'me'ma caƚ'Ailli' ȽanDios. Lipicuejma' ti'onƚcota to lipicuejma' cal profeta Elías. ȽanDios tepi'i'ma quimane ma to lepi'ipa limane Elías. Tilanc'e'e'mola' liƚpicuejma' lan xanuc' jouc'a liƚnaxque', ti'itsola' anuli. Tilanc'e'e'mola' liƚpicuejma' lincuejlocale, ti'i'ma aƚijca liƚpicuejma', tihuejcoƚe ȽanDios. Toƚta'a caƚ'Ailli' ȽanDios tixim'mola' ixanuc' joupa ixanghuaitola' liƚpicuejma', timetsaico'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías icuis'e'ma, timi ƚapaluc quema'a: ―¿Te ts'i'ic' mi'iya caixina' ja'ni lo'iya to laƚmipa? Iya' joupa aƚtojpa, jouc'a ƚaipeno joupa itojpa caca'no'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ƚapaluc quema'a italai'e'ma timi: ―Iya' ninGabriel. Itine itine cacaxu pe lopa'a ȽanDios. Iƚque nalummepa capalaic'otso', cu'itso' iƚta'a lataiqui', iƚe loya'apa al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Itsiya cami'mo' lo'iyaco'. Aimopalaiconaya. Tijouƚa' tipajntsi co'hua topalaina'ma. Tama ima' aimaƚcuec'e laitaiqui', toxim'ma al ƚinca iƚe laimipo'. Tixhuaitsi litine tenanƚ'ma laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lan xanuc' nacaxhuoƚanna ƚuna iƚ'huaijma tipanni Zacarías ticuayi: “¿Te qui'ipa? ¿Te cocoƚcopa?” ");
INSERT INTO chdNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lipanni Zacarías aimipalay, aimi'i. Ipanenni ch'ix. Toƚta'a i'ipa quiƚsina' te ts'i'ic' li'ipa jiƚpe al paxi cajut'ƚ. Jiƚpe iximpa limucaipa ȽanDios. Itsiya Zacarías le'a timuc'icola' limane. Aimipalay. ");
INSERT INTO chdNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mi'ay lanic' Zacarías ipanenni jiƚpe al cuecaj xoute'. Lijou'netsi lipenic' i'huana'ma lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lijou'ma ixim'me innay ƚipeno Elisabet. Amaquej mut'ƚa emi'moxi, ipajm'ma lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ticua: “Iƚe laƚ'ipa aƚ'e'epa caƚ'Ailli' ȽanDios. Iƚque aƚsimpa nincuanuc', liƚonc'e'epa laipelaic'ata. Lan xanuc' aimalatets'iconaya.” ");
INSERT INTO chdNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lixhuaitsi acamts'us mut'ƚa ȽanDios icuxe'epa ti'huaƚa' ƚapaluc quema'a cuftine Gabriel. Umme'ma liƚya' Nazaret lopa'a al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jiƚpe Nazaret tipalaic'otsi anuli ƚahuats'. Joupa inanc'opoƚtsi temalƚi'me anuli cal xans cuftine José. Cal rey David itatahuelo iƚque José. Ƚahuats' cuftine María. ");
INSERT INTO chdNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Icuaitsi ƚapaluc quema'a, itsufai'ma pe lopa'a María, timi: ―CumMaría, canonhuo'. Cu'ihuo' linespa ȽanDios. Iƚque titoc'i'mo' acueca', etenƚcocopa lopicuejma', aimecanujyaco'. Ima' xonca acueca' lipaxnepo'. Toƚiya aiquipaxnela' lof'as cacaƚ'no'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Licuej'ma iƚe lataiqui' Maria ixhueƚco'ma juaiconapa. Timiyoxi: “¿Te caƚnonacopa toƚta'a?” ");
INSERT INTO chdNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ƚapaluc quema'a timi: ―María aimixpaij'mo'. Ƚinca titoc'i'mo' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ima' toxim'moxi minnay. Tipajntsi co'hua tacui'i'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iƚque ti'i'ma acueca' xans. Tecui'im'me: Ƚi'Hua ȽanDios, iƚque cal Cuecaj Xonca. ȽanDios tepi'i'ma quimane ticuxe'ma to licuxepa cal rey David, iƚque itatahuelo. ");
INSERT INTO chdNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ƚo'hua ticuxe'mola' lixanuc', iƚne ixanuc' Jacob. Nij naitsi naipa'eya limane. Locuxeya aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María icuis'e'ma ƚapaluc quema'a, timi: ―¿Teƚe co'iya? Iya' nahuats'. Ailopa'a caipe'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ƚapaluc quema'a italai'e'ma timi: ―Cal Espíritu Santo timuhuo pe lofpa'a. Toxinguf'moxi lipepaxi ȽanDios, iƚque cal Cuecaj Xonca. Ƚo'hua ƚopajnya ma' i'huexi ȽanDios. Tecui'im'me: Ƚi'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ƚopima Elisabet, tama itojpa caca'no', itsiya innay. Luyaipa quitine tinescoyi, timiyi: “Ima' mijuiqui”. Itsiya ixhuaita acamts'us mut'ƚa' innay. ");
INSERT INTO chdNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ȽanDios aimixina quipime. Jahuay nipajnya ti'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María timi: ―Ne'. ȽanDios aiPoujna. Ma to laƚmipa, toƚta'a ti'iƚa'. Toƚta'a cuyaicoƚa'. Ƚapaluc quema'a ipanni pe lopa'a María, i'huanapa. ");
INSERT INTO chdNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Iƚniya ƚitiné ipanni María lipiƚya'. Aiquicoƚ'ma, i'hua'ma ƚijualay, ticuaita anuli liƚya' lopa'a al distrito Judea. ");
INSERT INTO chdNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Icuaitsi liƚya' itsufai'ma lejut'ƚ Zacarías, inom'ma Elisabet. ");
INSERT INTO chdNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jiƚpe al 'hora licuej'ma Elisabet tinoninni, ƚi'hua ƚo'nico licu'u iyuf'conni. Cal Espíritu Santo ticuxe lipicuejma' Elisabet. ");
INSERT INTO chdNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ipalai'ma ujfxi, timi María: ―Ima', xonca acueca' lipaxnepo' ȽanDios. Toƚta'a aiquipaxnela' lof'as cacaƚ'no'. Joupa apaxi ƚo'hua ƚo'nico locu'u. ");
INSERT INTO chdNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Itsiya aixina' acueca' laƚ'ipa. Iya' ni naitsi caca'no'. Ima' ƚotaic' ƚaiPoujna, ti'i'mo' i'máma' iƚque. Itsiya ocuai'ma pe laifpa'a, lahuenge. ");
INSERT INTO chdNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","¡Xinƚa'! Laicuejpa laƚnompa, jiƚpe 'hora, ƚai'hua ƚo'nico laicu'u iyuf'comma. Juaiconapa ixocomma queta. ");
INSERT INTO chdNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Al ƚinca, ima' toyaijma al c'a. Mepenufpa linespa ȽanDios, iƚe limipo'. Onespa: “Iƚe lataiqui' tenanƚ'ma”. ");
INSERT INTO chdNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María ines'ma: Iya' cax'najtsi'i caƚ'Ailli' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tixoqui neta ca'nujuaitsi ȽanDios, iƚque Ƚalunƚu'eya. ");
INSERT INTO chdNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iya' tama ni naitsi cahuats' iƚque aicalatets'i', aƚpaxnepa. Lan xanuc' ticua'me: “Iƚque María al c'a tuyaijma”. Toƚta'a tines'me lan xanuc' nomana' itsiya, jouc'a nomajnyacu locuaicoya quitine. ");
INSERT INTO chdNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Cal Cuecaj CanDios aƚtoc'ipa juaiconapa aƚpaxnepa. Ma' iƚque cal Paxi CanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iƚque tixinnila' acuanuc'la jahuay lixanuc', iƚne noxpaic'epá. Iƚne nomana' itsiya litine, jouc'a nomajnyacu locuaicoya quitine. ");
INSERT INTO chdNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iƚne lan xanuc' nonescopoƚtsi: “Illanc' ninc'tsilaj xanuc'”, ȽanDios joupa eca'nepola' ni petsi li'a ƚamats'. Toƚta'a imuc'ipola' acueca' lipujfxi, acueca' lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iƚonc'e'epola' liƚmane lan tsilaj quincuxepá. Lijoupa epi'ipola' liƚmane lan xanuc' xonca a'ojca. ");
INSERT INTO chdNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pe nonle'epá ites'minapola' xonca ixhuaitola'. Iƚne pe ts'iƚ'hueca acueca' quiƚ'huexi, ummenapola' ixcuajma liƚmane, ailopa'a quepi'ipola'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","ȽanDios ƚaƚPoujna aƚtoc'iponga', illanc' ixanuc' ƚaƚtatahuelo Israel, iƚque inieto Abraham. ȽanDios joupa inespa: “Caxim'mola' acuanuc'la, catoc'i'mola' iƚniya Abraham, ƚi'hua jouc'a linaxque' ƚi'hua. Catoc'i'mola' jahuay lixanuc' Abraham, iƚque itatahuelo iƚniya.” ȽanDios aiquimenc'ejma iƚiya litaiqui' limipola' laƚtatahueló. Ma to limipola', toƚta'a li'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María ipajnhuo'ma to afanej mut'ƚa lejut'ƚ Elisabet. Lijou'ma i'huana'ma ipainanni lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lixhuaitsi al pelƚa mut'ƚa Elisabet ipo'no'ma ƚi'hua. Ipajntsi amijcano. ");
INSERT INTO chdNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lan huejnca lan xanuc' jouc'a lipimaye Elisabet icuej'me li'epa ƚaƚPoujna ȽanDios, iƚque iximpa cuanuc' Elisabet, acueca' litoc'ipa. ");
INSERT INTO chdNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lixhuaita al paico quitine efot'ƚunni ti'e'me ma to liƚ'ejma'. Coƚa' tecui'i'me Zacarías ma to lipuftine qui'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Qui'máma' italai'e'e'mola' timila': ―A'i. Lacui'i'me Juan. ");
INSERT INTO chdNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Italai'e'me, timiyi: ―¿Te colacui'icoyacu Juan? Laƚpimaye, ailopa'a quecui'impa toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ipalaic'oco'me le'a liƚmane qui'ailli' ƚahuac'hua. Icuis'e'me: ―¿Te cofcuapa? ¿Te caftine calacui'iyacu ƚamijcano? ");
INSERT INTO chdNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías ixahue'e'ma tini'inƚe anuli la'hua caxma tiniƚ'ma. Ini'im'me. Iƚque iniƚ'ma: “Lipuftine aJuan”. Lan xanuc' aiquiƚcuec'e li'ipa. Ticuayi: ―¡Toƚsinƚe! ¡Iniƚpa: “Juan”! ");
INSERT INTO chdNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aiquicoƚ'ma, ixaƚna'ma lejoc' Zacarías, uhuaƚquenamma ƚipaƚ, tipalay. Ix'najtsi'i'ma ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lan huejnca lan xanuc' ixpailij'mola'. Ixim'me acueca' li'ipa. Lan xanuc' ni petsi ƚijualay al distrito Judea tuya'ayi li'ipola' Elisabet y Zacarías. ");
INSERT INTO chdNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Licuej'me ticuis'eyoƚtsi, timiyoƚtsi: ―Iƚque ƚamijcano: ¿Te co'eya? y ¿te co'iya? ȽanDios itoc'i'ma ƚamijcano, ipaxne'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cal Espíritu Santo icuxe'ma lipicuejma' Zacarías. Ma to Ƚandios mimi, ma toƚta'a Zacarías tuya'e'. Tuya'e': ");
INSERT INTO chdNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Aƚs'najtsi'i'me ȽanDios, iƚque ƚalanDios illanc' ixanuc' Israel! Aƚtoc'iponga', tocomma aluhuaƚponga' petsi iƚne laƚ'e'eponga' laic'. Iƚniya aimalulijyaconga' illanc' ixanuc' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ȽalanDios, iƚque iPoujna cal rey David, lapi'iponga' Ƚalunƚu'eyaconga'. Maƚque cal rey David itatahuelo iƚque. ");
INSERT INTO chdNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Luyaipa quitine ȽanDios u'ipola' lipaxij profeta toƚta'a lo'eya. Iƚniya u'iyale'me, u'im'mola' laƚtatahueló. ");
INSERT INTO chdNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iƚe litaiqui' ȽanDios tuya'e' te ts'i'ic' laƚtoc'iyaconga'. Ticua: “Cunƚu'e'molhuo'; iƚne naixtuc'opolhuo' aimulijyacolhuo'. Jouc'a no'epolhuo' laic' ailopa'a co'eyacolhuo'.” ");
INSERT INTO chdNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ticua: “Iya' aiquimenc'ecoyacola' laixanuc'”. Iƚne lixanuc' ȽanDios maƚniya aƚtatahueló illanc'. ȽanDios i'nujuaitsi lipaxi cataiqui', iƚe lipo'no'ipola' lixanuc'. q ");
INSERT INTO chdNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Joupa inespa lunƚu'e'monga', aimalulijyaconga' iƚniya nalixtuc'oponga'. ȽanDios toƚta'a limipa ƚaƚtatahuelo Abraham. Joupa icuapa aƚpo'no'monga' pe ailopa'a caxpaiqui', jiƚpiya laxc'onƚingoƚai'me ƚalanDios. Jahuay ƚalunxajma' lihuej'me ȽanDios, aimaƚ'econayacu lixcay. Maƚmana' fa'a li'a ƚamats', jahuay laƚpitine, luyalaico'me to luyalaicopa lixanuc' ȽanDios, iƚque cal Paxi. ");
INSERT INTO chdNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ima' mai'hua Juan, tecui'im'mo' umprofeta. Toya'a'ma litaiqui' ȽanDios, iƚque cal Cuecaj Xonca. Ima' to'huaj'me'ma ƚaƚPoujna, tolanc'e'ma lipene. ");
INSERT INTO chdNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tomuc'i'mola' lixanuc' ȽanDios. Toƚta'a ti'i'ma quiƚsina' ȽanDios tunƚu'e'mola', timenc'e'eco'mola' li'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ȽanDios aƚsimponga' ninc'icuanuc'la. Tiyuf'tsi cal 'ora lapalc'o'i'monga'; ma toƚta'a lapalc'o'iponga' ȽanDios, iƚque Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Toƚta'a tulif'ena'mola' lan xanuc', maƚniya itsiya aiquepalc'o'ila'. Iƚniya tocomma amuf liƚpicuejma', ti'huaicoyi ma le'a lamaya. Aƚƚecona'monga' al c'a cane, jiƚpe aimaƚsueƚmot'ƚeconayacu. ");
INSERT INTO chdNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ƚamijcano ti'hua titoqui. I'i'ma acueca' lipicuejma'. Ai'a ti'e'ma lipenic' ȽanDios, iƚque Juan aiquimujyoxi. Tipa'a pe ailopa'a quiƚya'. ȽanDios tu'i'ma te litine timuj'moxi. Tuya'a'ma litaiqui' ȽanDios, tiquimf'eƚe lipimaye, iƚne lixanuc' Israel. ");
INSERT INTO chdNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Iƚniya ƚitiné cal cuecaj quincuxepa cuftine César Augusto. Ni petsi lomana' lan xanuc' ticuxe'ela' tiyenƚe ƚiƚpiƚeloƚya' pe limajnliyota liƚtatahueló. Jiƚpiya tiniƚinginnola' liƚpuftine. ");
INSERT INTO chdNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Toƚta'a lipangopa lan censo fa'a li'a ƚamats'. Li'ipa aimi'eyi toƚta'a. Iƚniya ƚitiné ƚincuxepa cuftine Cirenio ticuxe ƚamats' Siria. ");
INSERT INTO chdNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jahuay lan xanuc' itsehuo'me ƚiƚpiƚeloƚya' liƚtatahueló, iniƚinginhuo'mola' liƚpuftine. ");
INSERT INTO chdNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","José y María ipalunca liƚpiƚya' Nazaret lopa'a al distrito Galilea. Iye'me al distrito Judea, liƚya' Belén, tiniƚinginnola' jiƚpiya liƚpuftine. Iƚe liƚya' Belén ipiƚya' ƚitatahuelo José, iƚque cal rey David. Iƚniya José y María inonc'opoƚtsi temalƚi'me. Aiquejonƚiyoƚtsi. María innay. ");
INSERT INTO chdNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mimana' liƚya' Belén, ixhuaitsi litine tipajnta ƚi'hua María. ");
INSERT INTO chdNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jiƚpiya ipo'no'ma cal te'a ƚi'hua, iƚque amijcano. Iju'e'ma quijahua', unaj'mi'ma pe lotetsoyopa linneja. José y María epi'impola' lajut'ƚ pe loxmaipa linneja. Locuena lajut'ƚ imanna xanuc', ailopa'a comanc'eyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Maƚpiya liƚya' Belén, ma' ahuejnca, timana' nohuic'ipá mot'ƚ. Iƚe lipuqui' comana' ƚimuc'o', ti'eyi cuenna liƚmot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pe lomana' iƚniya nohuic'ipá mot'ƚ icuai'ma anuli ƚepaluc caƚ'Ailli' ȽanDios. Epalc'o'i'mola' al cueca' al paxi lipepalc'o' ȽanDios. Lixim'me, ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ƚapaluc quema'a ipalaic'o'mola', timila': ―Aimixpailij'molhuo'. Cu'i'molhuo' al c'a li'ipa. Ni petsi lomana' lan xanuc' tixoj'ma quileta. ");
INSERT INTO chdNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Itsiya jiƚpe liƚya' pe lipajnyota cal rey David, maƚpiya ipajnta Ƚonƚu'eyacolhuo'. Iƚque aCristo ƚaƚPoujna. ");
INSERT INTO chdNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jiƚpe liƚya' toƚsinna ƚaca'hua camijcano, iju'eya quijahua', tunouya pe lotetsoyopa linneja. Toƚsintsa toƚta'a ti'i'ma coƚsina' lainu'ipolhuo' al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aiquicoƚ'ma ixim'me axpela' lapaluc' quema'a icuai'me jiƚpiya pe lopa'a ƚapaluc ƚummepa ȽanDios. Iƚniya tix'najtsi'iyi ȽanDios ticuayi: ");
INSERT INTO chdNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Jahuay nomana' xonca al toncay lema'a tix'najtsi'iƚe ȽanDios, timiƚe: Ima' manDios, ƚinca umCueca'. Lan xanuc' nomana' li'a ƚamats', iƚniya pe latenƚcocopa ȽanDios, aimixhueƚmot'ƚecona'me. ");
INSERT INTO chdNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lapaluc' quema'a ipailinamma lema'a. Nohuic'ipá mot'ƚ ipalaic'o'moƚtsi, timiyoƚtsi: ―¡Cuej! ¡Ƚepá liƚya' Belén! ȽaƚPoujna ȽanDios joupa aƚmiponga' te ts'i'ic' li'ipa. ¡Ƚepá, aƚsinna! ");
INSERT INTO chdNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aiquicoƚ'mola' iye'me. Licuaitsa Belén ixintsa María jouc'a José jouc'a ƚacapími', iƚque tunouya petsi lotetsoyopa linneja. ");
INSERT INTO chdNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Liximpá ƚapími' nohuic'ipá mot'ƚ uya'a'me limipola' ƚapaluc quema'a, iƚque ipalaicopa ƚacapími'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lan xanuc' licuej'me loya'apa nohuic'ipá mot'ƚ ticuayi: “¡Xinƚa'! Acueca' li'ipa.” ");
INSERT INTO chdNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María ailopa'a quicuapa. Jahuay ti'nujuaitsi. Itine itine ti'nujuaitsi, timiyoxi: “Toƚta'a toƚta'a li'ipa”. Aiquimenc'ejma. ");
INSERT INTO chdNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nohuic'ipá mot'ƚ ipailinamma, ticuaita pe lomana' liƚmot'ƚ. Miyeyi lane tix'najtsi'iyi ȽanDios. Tix'najtsi'iyi liximpa, tix'najtsi'iyi lataiqui' licuejpa. Ticuayi: “ManDios, acueca' ima', acueca' lof'epa”. ");
INSERT INTO chdNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lixhuaitsi al paico quitine i'e'me circuncidar ƚamijcano, ipo'no'i'me quiseña licuerpo. Ecui'im'me Jesús. Toƚta'a laftine ƚapaluc quema'a lu'ipa ma quinnay María. ");
INSERT INTO chdNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","María ihuejco'ma litaiqui' Moisés, i'huej'moxi. Lixhuaita iƚniya ƚitiné María y José ileco'me ƚa'hua Jesús, i'hua'a'me al cuecaj xoute' lopa'a Jerusalén. Timuc'ita ȽanDios ƚaƚPoujna, tipaxneƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ti'e'eta ma to licuxepa ƚaƚPoujna ȽanDios. Iƚe lataiqui' liniƚijmpa Moisés, tuya'e': “Cal te'a ƚo'hua ƚopajnya, iƚque i'huexi ȽanDios”. ");
INSERT INTO chdNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jouc'a titsufcota ma to loya'apa lataiqui' petsi liniƚijmpa locuxepa ȽanDios. Jiƚpe ticua: “Totsufco'ma oquexi' laijcucú, o oquexi' lan jaƚmu'”. ");
INSERT INTO chdNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jiƚpe al cuecaj quiƚya' Jerusalén tipa'a anuli cal xans cuftine Simeón. Iƚque aƚijca xans, ihuequi jahuay locuxepa ȽanDios. I'huaijma ticuaitsi litine ȽanDios acueca' titoc'iconatsola' lixanuc', iƚniya ixanuc' Israel. Cal Espíritu Santo ticuxe lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iƚque cal Espíritu Santo joupa lu'ipa: “Toxim'ma cal Cristo. Toxim'ma ai'a tima'mo'.” ");
INSERT INTO chdNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Cal Espíritu Santo umme'ma Simeón ti'huaƚa' al cuecaj xoute'. Maƚpiya al 'hora icuaitsa José y María, iƚejma ƚa'hua Jesús. Ti'e'me ma to micua locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón lixim'ma ƚa'hua Jesús ipulai'ma, ix'najtsi'i'ma ȽanDios, timi: ");
INSERT INTO chdNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ManDios maiPoujna: Itsiya lapi'iƚa' lane, iya' aicaxhueƚcoconaya, aƚmanƚa'. Joupa enanƚpa lotaiqui' ima' lalu'ipa. ");
INSERT INTO chdNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Cahuelonge iƚca'a ƚomummepa, iƚca'a Ƚalunƚu'eyaconga'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mummepa, icuai'ma fa'a li'a ƚamats'. Ni petsi lomana' lan xanuc' ti'iƚa' quiƚsina' toƚta'a li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iƚque Epalc'o', tepalc'o'i'mola' liƚpicuejma' lan xanuc', iƚne aimimetsaicohuo' ima' manDios. Illanc' oxanuc', ima' malanDios, iƚque lixoc'i'monga' acueca' calata. Aƚnes'me: “Illanc' ixanuc' Israel, iƚque aƚpiƚya' xans”. ");
INSERT INTO chdNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José jouc'a qui'máma' Jesús ticuayi: “¿Te copalaicocopa toƚta'a ƚa'hua? Aicaƚcueca.” ");
INSERT INTO chdNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simeón ipaxne'mola', timi María qui'máma': ―ȽanDios joupa ixpic'epa lo'iya iƚca'a ƚo'hua. Ummepa fa'a li'a ƚamats' ȽanDios tipa'a lomuc'iyacola' lan xanuc'. Iƚne aimepenufyacu, tinesc'e'me. Ima' jouc'a toteƚco'ma acueca' cumla, toxim'ma to lix'ay al cutsilo titsufai'ma ƚomunxajma', tixcai'e'mo'. ’Hualca aimetenƚcocoyacola' ƚo'hua, iƚne tejac'mola'. Hualca tetenƚcoco'mola', iƚne tuyalaico'me al c'a. Jiƚpe tixinim'me te ts'i'ic' liƚpicuejma' axpela' lan xanuc', iƚne ixanuc' Israel. Timuj'moƚtsi ja'ni ac'a o ja'ni ixcay liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Iƚniya ƚitiné tipa'a jiƚpiya al cuecaj xoute' anuli ƚaca'no' lipuftine Ana. Qui'ailli' cuftine Fanuel, joupa imanapa. Ƚitatahuelo cuftine Aser. Ƚaca'no' Ana aprofeta, tuya'e' lixpic'epa ȽanDios. Joupa itojnapa caca'no'. Iƚque Ana apotsate, ilecopoƚtsi ƚipe'ailli' acaitsi camats', joupa imanapa. ");
INSERT INTO chdNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Itsiya ixhuaita amalpuj nuxans malpuj camats' apotsate. Aimipamma al cuecaj xoute'. Itine ipuqui' jiƚpiya texc'onƚu. Aimitesma, tipalaic'o ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mipalay toƚta'a Simeón icuaitsi jiƚpiya Ana. Ixintsi ƚahuac'hua Jesús, ix'najtsi'i'ma ȽanDios. Jiƚpe al cuecaj xoute' timana' lan xanuc' ts'iƚ'huaijma ȽanDios tunƚu'eƚa' lipiƚya' Jerusalén. Ticuayi: “Aimaƚcuxecona'monga' laƚ'eponga' laic'”. Ana ipalaic'o'mola' jahuay iƚniya, ipalaico'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jiƚpe al cuecaj xoute' José y María i'e'me locuxepa ȽanDios, enant'ƚipá jahuay. Lijou'ma ipailinamma, icuaitsa Nazaret liƚpiƚya' lopa'a al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ƚamijcano ti'hua titoqui, jouc'a lipicuejma'. ȽanDios ti'hua tipaxne. ");
INSERT INTO chdNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Amats' amats' micuaita al juic Pascua José jouc'a qui'máma' Jesús tiyeyi liƚya' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ixhuaitsi Jesús imbamaj coque' ƚemats' itse'me al juic ma to liƚ'ejma'. Ileco'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lijou'ma al juic Jesús ipanenni Jerusalén. José y qui'máma' Jesús aiquiƚsina'. Tiyeyi lane ticuainata liƚpiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ticuayi: “Laƚpimaye iƚejmale Jesús”. Anuli litine tiyeyi lane. Lijou'ma ehue'me Jesús. Ehue'me pe loyepa liƚpimaye, jouc'a limetsaicoyoƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aiquixim'me. Ipailiconamma. Icuaicontsa Jerusalén ehuetsa jiƚpe. ");
INSERT INTO chdNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ehuehuo'me afane' quitine. Ixinghuona'me jiƚpe al cuecaj xoute' pe lomana' lan tsilaj comxiye. Tiquimf'ela', ticuis'ela'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jahuay noquimf'epá timiyoƚtsi: “¡Xinƚa'! Acueca' lipicuejma'. Ac'a juaiconapa titalai'e.” ");
INSERT INTO chdNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lixim'me qui'máma' y José ticuayi: “¿Te qui'ipa? ¿Te co'ecopa toƚta'a?” Quimáma' timi: ―Mai'hua, ¿te caƚ'ecoponga' toƚta'a? Co'ailli' jouc'a iya' juaiconapa lahuehuo'. Aƚsueƚcoyi juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús timila': ―Imanc', ¿te calahuecopa? Ticuicomma iya' capajm'ma lejut'ƚ cai'Ailli'. ¿Te aga aicoƚsina' iƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iƚniya aiquiƚcuec'e lomipola'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lijou'ma, iyena'me jouc'a Jesús. Icuainatsa liƚpiƚya' Nazaret. Jesús ihuejco'mola'. Qui'máma' aiquimenc'ecojma li'ipa. Jahuay i'huejpa lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús ti'hua titoqui. Ti'hua ti'i xonca acueca' lipicuejma'. Etenƚcoco'ma ȽanDios, lan xanuc' jouc'a etenƚcoco'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Juan, i'hua Zacarías, mipa'a pe ailopa'a quiƚya' ȽanDios ipalaic'o'ma, u'i'ma te ts'i'ic' lo'eya. Iƚniya ƚitiné ixhuaitsi imbamaj maque' camats' micuxe cal cuecaj quincuxepa cuftine Tiberias César. Poncio Pilato ticuxe al distrito Judea; Herodes ticuxe al distrito Galilea; Felipe ipima Herodes, ticuxela' lan distrito Iturea jouc'a Traconite. Lisanias ticuxe al distrito Abilinia. Mimana' lan tsila' la'aillí Anás y Caifás ȽanDios ipalaic'opa Juan. ");
INSERT INTO chdNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan ihuejcopa limipa ȽanDios, ipanamma pe lopa'a, ti'hua jahuay ƚamats' ƚemaj panaj Jordán. Tuya'e', tu'ila' lan xanuc': ―Toƚsuej'menanca loƚ'epa lixcay. Tijouƚa' capo'i'molhuo'. ȽanDios tiƚonc'e'ena'molhuo' loƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Luyaipa quitine cal profeta Isaías inescopa Juan, uya'a'ma te ts'i'ic' lo'eya iƚque. Toƚta'a tuya'e' litaiqui' liniƚingiya lije'e, ticua: Petsi ailopa'a quiƚya' tuya'e' anuli cal xans, tu'ila' lan xanuc': “Toƚƚanc'eƚe lipene ƚaƚPoujna, toƚ'e'eƚe aƚijca lane pe loyaicoya. ");
INSERT INTO chdNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jahuay ƚiculhuay tima'nim'me, jahuay ƚijualay ti'oquehuo, lan juentsolay ƚaneya ti'ina'mola' ƚijca, ƚaneya petsi juaiconapa capic, tilajn‑na'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jahuay lan xanuc' tixim'me ȽanDios munƚu'ela' lixanuc'.” ");
INSERT INTO chdNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Icuaiyunca axpela' lan xanuc' iƚpic'a tepo'itsola' Juan. Juan timila': ―Imanc' ti'onƚcospolhuo' to lacaƚpo'. A'ijc'a lonƚ'ejma'. ¿Naitsi limipolhuo' toƚcuaiyunca tolapoƚe? Imanc' toƚcuayi: “Lapo'itsonga'. Toƚta'a aimaƚteƚco'me al cueca' cateƚcoya locuaicoya.” ");
INSERT INTO chdNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","’Iya' camilhuo': Ja'ni oƚpic'a tolunƚul―le, tonƚ'eƚe al c'a ma to mi'eyi petsi al ƚinca lixhuej'menamma. Aimoƚnescona'me: “Abraham aƚtatahuelo. Iƚque aimalacani'eyaconga'.” Camilhuo': ȽanDios aimehue'e' lixanuc'. Iƚna'a lapic' nipajnya ti'e'e'mola' inaxquej Abraham. ");
INSERT INTO chdNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ȽanDios ti'onƚicolhuo' to al 'ec. Joupa ipo'nompa ƚatef'conyacu huejnca ƚime al 'ec. Ja'ni ixcay ƚi'as, tixanc'onata ƚunga. ");
INSERT INTO chdNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lan xanuc' icuis'e'me, timiyi: ―¿Te caƚ'eyacu illanc'? ");
INSERT INTO chdNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan italai'e'e'mola', timila': ―Ja'ni tipa'a oque' lotsamalo, anuli tommi'iƚa' petsi aiqui'hueca. Ja'ni tipa'a ƚofteja, tapi'i'ma pe ailopa'a coteja. ");
INSERT INTO chdNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jouc'a icuaiyunca lin'najts'i'iyale, iƚpic'a tepo'itsola' Juan. Icuis'e'me, timiyi: ―Momxi, illanc', ¿te caƚ'eyacu? ");
INSERT INTO chdNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan timila': ―Toƚ'najtsi'iyaleƚe al ƚijca. Aimoƚfel'miyale'me. ");
INSERT INTO chdNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jouc'a lan soldado icuaiyunca, icuis'e'me, timiyi: ―Illanc', ¿te caƚ'eyacu? Timila': ―Aimoƚnantsej'mola' lan xanuc'. Aimoƚcuf'mola' lan xanuc' petsi ailopa'a co'epa. Tetenƚcocotsolhuo' lo'najtsempolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lan xanuc' timiyoƚtsi: ―¿Te co'iya itsiya? ¿Naitsi xans iƚca'a Juan? ¿Te iƚca'a aCristo, iƚque Ƚommeya ȽanDios? ");
INSERT INTO chdNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan timila': ―Iya capo'icolhuo' aja'. Ticuaihuo ocuena iƚque xonca acueca'. Iya' aimaƚ'onƚspa to iƚque. Aimi'iya cuhuaƚc'e'eya lic'eji'. Iƚque tepo'ico'molhuo' cal Espíritu Santo jouc'a ƚipaƚ cunga. ");
INSERT INTO chdNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iƚque ticuaiyunni ti'onƚcospa to cal xans nofusya ƚitrigo. Ti'noƚ'ma lofuscoya, tequeyaf'ma ƚitrigo, tiƚojm'ma ƚipifuc cal trigo. Cal c'a trigo ti'huejnata lihua. Ƚipifuc tipi'enghua petsi ƚunga aimipica. ");
INSERT INTO chdNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Toƚta'a Juan ixc'ai'i'mola' lan xanuc'. Ti'hua tixc'ai'ila'. Jouc'a tu'ila' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan jouc'a ixc'ai'i'ma Herodes. Iƚque Herodes exic'e'epa ƚipeno ƚipima. Ƚaca'no' cuftine Herodías. Juan itale'ma Herodes toƚta'a li'epa. Jouc'a titale jahuay nixpiya lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes i'e'ma xonca acueca', itats'etsi Juan, i'nicotsi lacarza. ");
INSERT INTO chdNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ai'a titats'em'me Juan iƚque tepo'ila' lan xanuc'. Mepo'iyale icuaitsi Jesús. Jouc'a epo'i'ma. Jesús mijoc'i ȽanDios eximma lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Cal Espíritu Santo imunni ihuoxaf'caitsi Jesús. Iƚque cal Espíritu lixans to anuli cal ja'mu'. Lema'a tipalay, timinni Jesús: ―Ima' ai'Hua ca'ehuo' capic'a juaiconapa. Latenƚma lopicuejma' jouc'a lo'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Lipango'ma Jesús lipenic' ixhuaita to anuxans quimbama' ƚemats'. Lan xanuc' ticuayi i'hua José. Ƚi'ahuelo José cuftine Elí. ");
INSERT INTO chdNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí i'hua Matat, Matat i'hua Leví, Leví i'hua Melqui, Melqui i'hua Jana, Jana i'hua José, ");
INSERT INTO chdNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José i'hua Matatías, Matatías i'hua Amós, Amós i'hua Nahum, Nahum i'hua Esli, Esli i'hua Nagai, ");
INSERT INTO chdNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai i'hua Maat, Maat i'hua Matatías, Matatías i'hua Semei, Semei i'hua Josec, Josec i'hua Judá, ");
INSERT INTO chdNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá i'hua Joanán, Joanán i'hua Resa, Resa i'hua Zorobabel, Zorobabel i'hua Salatiel, Salatiel i'hua Neri, ");
INSERT INTO chdNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri i'hua Melqui, Melqui i'hua Adi, Adi i'hua Cosam, Cosam i'hua Elmodam, Elmodam i'hua Er, ");
INSERT INTO chdNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er i'hua Josué, Josué i'hua Eliezer, Eliezer i'hua Jorim, Jorim i'hua Matat, ");
INSERT INTO chdNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat i'hua Leví, Leví i'hua Simeón, Simeón i'hua Judá, Judá i'hua José, José i'hua Jonam, Jonam i'hua Eliaquim, ");
INSERT INTO chdNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim i'hua Melea, Melea i'hua Mena, Mena i'hua Matata, Matata i'hua Natán, ");
INSERT INTO chdNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán i'hua Davíd, Davíd i'hua Isaí, Isaí i'hua Obed, Obed i'hua Booz, Booz i'hua Sala, Sala i'hua Naasón, ");
INSERT INTO chdNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón i'hua Aminadab, Aminadab i'hua Admin, Admin i'hua Arni, Arni i'hua Esrom, Esrom i'hua Fares, Fares i'hua Judá, ");
INSERT INTO chdNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá i'hua Jacob, Jacob i'hua Isaac, Isaac i'hua Abraham, Abraham i'hua Taré, Taré i'hua Nacor, ");
INSERT INTO chdNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor i'hua Serug, Serug i'hua Ragau, Ragau i'hua Peleg, Peleg i'hua Heber, Heber i'hua Sala, ");
INSERT INTO chdNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala i'hua Cainán, Cainán i'hua Arfaxad, Arfaxad i'hua Sem, Sem i'hua Noé, Noé i'hua Lamec, ");
INSERT INTO chdNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec i'hua Matusalén, Matusalén i'hua Enoc, Enoc i'hua Jared, Jared i'hua Mahalaleel, Mahalaleel i'hua Cainán, ");
INSERT INTO chdNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán i'hua Enós, Enós i'hua Set, Set i'hua Adán, Adán i'hua ȽanDios. Joupa icula'apa. ");
INSERT INTO chdNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús ipainamma pe lopa'a al panaj Jordán, cal Espíritu Santo ticuxe lipicuejma'. Maƚque cal Espíritu i'hua'a'ma pe ailopa'a quiƚya', ailopa'a xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mipa'a jiƚpe ƚonta'a Satanás ehuai'ma. Oquej nuxans quitine oquej nuxans quipuqui' icoƚ'ma lehuaipa. Jahuay iƚniya ƚitiné aiquitesma. Lixhuaitsi iƚne ƚitiné unle'enni juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ƚonta'a timi: ―Ima' ja'ni i'Hua ȽanDios tocuxe'etsi iƚca'a ƚapic. Tomiƚa': “To'exoxi ca'i”. ");
INSERT INTO chdNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús italai'e'e'ma, timi: ―Al Paxi Liniƚingiya ticua: “Ƚoteja cal xans aimites'miya lipitine. Ticuicomma jouc'a jahuay litaiqui' lonespa ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lijou'ma ƚonta'a ileco'ma anuli ƚi'nof'quiya quijuala. Jiƚpe imuc'i'ma nulemma jahuay lan tsilaj nación lomana' li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Timi: ―Capi'i'mo' comane, tocuxena'ma jahuay iƚna'a. Timetsaicom'mo' umcuecaj xonca. Itsiya iya' cacuxela', joupa lapi'impa laimane. Ja'ni caxpic'eƚa' ticuxeƚa' ocuena iya' capi'i'ma quimane, iƚque ticuxena'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ima' ma le'a laxc'onƚingaiƚa', tijouƚa' tocuxena'ma jahuay. ");
INSERT INTO chdNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús italai'e'e'ma, timi: ―Ima' monta'a to'huanƚa'. Al Paxi Liniƚingiya ticua: “Taxc'onƚingaiƚa' ȽanDios, iƚque omenDios. Ma le'a iƚque tomi'ma: Ima' umCueca'.” ");
INSERT INTO chdNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lijou'ma ƚonta'a i'hua'a'ma liƚya' Jerusalén. Icuai'etsi pe lopa'a al cuecaj xoute', xonca al toncay. Jiƚpe ecaxu'ma, timi: ―Ima', ja'ni i'Hua ȽanDios taiyuƚa' al 'ocay. ");
INSERT INTO chdNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Al Paxi Liniƚingiya ticua: ȽanDios tumme'mola' lepaluc' quema'a, titoc'i'mo', ti'e'mo' cuenna. ");
INSERT INTO chdNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tipulnuf'mo' liƚmane, toƚta'a lapic' cane ailopa'a co'eyaco'. Aimixcai'eyaco'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús italai'e'e'ma, timi: ―Jouc'a ticua: “Aimahuai'ma ȽanDios; iƚque omenDios.” ");
INSERT INTO chdNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ƚonta'a lijou'nepa lehuaipa Jesús ipo'nona'ma quituca'. Aimehuaiconaya. ");
INSERT INTO chdNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús ipainamma, icuaita al distrito Galilea. Jiƚpe ixinguf'moxi acueca' lipaxnepa cal Espíritu Santo. Jiƚpe ƚamats' ni petsi lomana' lan xanuc' iƚniya icuej'me lo'epa, lonespa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ƚajut'ƚi pe lafoƚyomma lan xanuc' judío, jiƚpiya timuc'iyale. Jahuay ticuayi ac'a lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Icuaitsi liƚya' Nazaret pe litojyopa. Jiƚpe i'e'ma ma to mi'ay. Litine conxajya itsufai'ma lajut'ƚ pe lafoƚyomma lan xanuc'. Ecax'ma tixhue'ma al Paxi Liniƚingiya. ");
INSERT INTO chdNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ini'im'me lijuisquiya je'e liniƚingiya litaiqui' cal profeta Isaías. Ux'malaif'ma al je'e, tixhuef'i'mola' liniƚingiya, ticua: ");
INSERT INTO chdNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ȽanDios alapi'ipa ƚi'Espíritu Santo. Aƚ'huijf'epa, aƚfajpa cu'itsola' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Tiquimf'eƚe lan xanuc' pe aiquiƚ'hueca. Lummepa camitsola' litats'ila': “Cuhuaƚna'molhuo'”. Jouc'a cu'itsola' lan fohue: “Caxaƚ'mena'molhuo', tolahuetsalena'me”. Pe noximpá ipime lapajnya quiƚonc'e'e'mola' cal cunta. ");
INSERT INTO chdNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Alummepa camitsola' lan xanuc': “Itsiya ƚinca ȽanDios titoc'i'molhuo', tepenuf'molhuo'”. ");
INSERT INTO chdNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lijoupa lu'ipola' iƚiya, ijuitsaf'ina'ma al je'e, ini'ina'ma notoc'iyalepa jiƚpe lajut'ƚ. Icutshuaina'ma. Jahuay nomana' jiƚpe lajut'ƚ tehuelojnyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iƚque timila': ―Imanc' joupa oƚcuejpá iƚe laixhuepa. Itsiya enanƚcopa jiƚe lataiqui' liniƚiya. ");
INSERT INTO chdNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jahuay etenƚcoco'mola' lonespa Jesús. Icuaitsi quiƚpic'a. Ticuis'eyoƚtsi, timiyoƚtsi: ―Iƚque, ¿te ma aƚinca i'hua José? o ¿a'i? ");
INSERT INTO chdNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús timila': ―Imanc' aƚmi'ma: “Ima' oxina' ƚafxi, ¡toxaƚ'mexoxi cotuca'!” Aƚmi'ma: “Aƚcuejpá lo'epa liƚya' Capernaum. Jouc'a to'eƚa' toƚta'a jifa'a lopiƚya'.” ");
INSERT INTO chdNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jouc'a timila': ―Iya' camilhuo' al ƚinca: Ja'ni anuli cal profeta ticuaitsi ma lipiƚya', aimepenufyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","’Ƚitiné lipajmpa cal profeta Elías fa'a li'a ƚamats' uyaipa afane' camats' y onƚca aiquicuic'. Jahuay ƚamats' i'ipa cumemma. Jiƚpe ƚamats' Israel pe lopa'a Elías timana' axpela' lacaƚ'no' lam potsateya. ");
INSERT INTO chdNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ȽanDios aicummaic' Elías pe lomana' iƚniya lacaƚ'no'. Umme'ma ti'huaƚa' locuenaj nación, liƚya' Sarepta, pu'hua titoc'ita anuli ƚaca'no' apotsate. Iƚe liƚya' Sarepta ahuejnca al cuecaj quiƚya' cuftine Sidón. ");
INSERT INTO chdNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","’Ƚitiné lipajmpa cal profeta Eliseo fa'a ƚamats' Israel, timana fa'a axpela' lan xanuc' titeƚcoyi al cuana lepra. Iƚne lafcualƚay ailopa'a quixaƚcopa. Anuli ƚafcuana cuftine Naamán qui'huayomma ocuena camats' cuftine Siria, ƚinca ixaƚcona'ma iƚque. ");
INSERT INTO chdNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Liquimf'epa toƚta'a locuapa Jesús lan xanuc' nomana' jiƚpiya lajut'ƚ, jahuay ixtulenca juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Itsolinanca, i'noƚ'me Jesús, ipa'a'me lema quiƚya'. Liƚya' copa'a letefcaic' quijuala. I'hua'a'me li'huesca ƚijuala, teca'nita liculhuo. ");
INSERT INTO chdNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús uyaico'ma nolojmay xanuc', i'huana'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Icuaitsi liƚya' Capernaum, lopa'a al distrito Galilea. Litine conxajya imuc'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Imetsaico'me acueca' comxi. Ixim'me tipa'a limane, al c'a timuc'iyale. ");
INSERT INTO chdNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lajut'ƚ pe lafoƚyomma lan xanuc' jiƚpe tipa'a anuli cal xans itsufaipa conta'a. Cal xans ija'a'ma ujfxi, timi Jesús: ");
INSERT INTO chdNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ima' cunJesús, mas Nazaret, ¿te cotsufaicomma pe laƚmana' illanc'? ¿Ja'ni ocuaiyoco'ma aƚjou'netsonga'? Aƚpo'notsonga' caƚtuca'. Iya' nimetsaicohuo' naitsi ima'. Ima' umPaxi, co'huayomma ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús itale'ma ƚonta'a, timi: ―¡Ti‑ch'ixcotso'! ¡Taipanni iƚca'a cal xans! Mehuelojnyi jahuay lan xanuc' ƚonta'a eca'ni'ma cal xans ƚamats', ipananni. Aiquixcai'e cal xans. ");
INSERT INTO chdNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lan xanuc' ixpailij'mola', timiyoƚtsi: ―¿Te cataiqui' jiƚta'a? Iƚque cal xans ti'hua limane ticuxe'ela' lontahue, iƚniya tilipalnamma. ");
INSERT INTO chdNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jahuay iƚe ƚamats' ni petsi lomana' lan xanuc' icuej'me lo'epa jouc'a lonespa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús ipanni jiƚpe lajut'ƚ pe lafoƚyomma lan xanuc'. I'hua'ma itsufai'ma lejut'ƚ Simón. Jiƚpe ƚi'maco Simón tunouya textafque, tepi'i ƚinu' juaiconapa. Ixa'hue'me Jesús titoc'iƚa' jiƚque ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús icuaitsi pe lopa'a ƚaca'no' ƚaxtafpa, ic'ommai'ma itale'ma ƚipinu'. Ƚipinu' iƚojn‑na'ma. Aiquicoƚ'ma, ƚaca'no' itsahuenanni, ites'mi'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Joupa if'acoƚaipa cal 'ora, lan xanuc' iƚejma jahuay lilefcualƚay pe lopa'a Jesús, ituca' ituca' liƚcuana. Jesús ixpayaf'mola' anuli anuli, ixaƚ'mena'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Axpela' lontahue ipalumma lafcualƚay. Iƚne lontahue tija'ayi timiyi: ―Ima' i'Hua ȽanDios. Jesús itale'mola'. Timila': ―Aimoluya'acona'me toƚta'a. Iƚniya iƚsina' naitsi Jesús, iƚque cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lihuequi litine liƚic'ejma Jesús ipanni i'hua'ma petsi ailopa'a quiƚya'. Lan xanuc' tehueyi. Ixim'me, timiyi: ―Aimo'huana'ma, topajnla' fa'a laƚpiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús timila': ―Iya' ai'huanapa cuyaicota ocuenaye quiƚeloƚya'. Jouc'a cu'itola' iƚniya lan xanuc': “ȽanDios cal Rey tijoc'ila' lixanuc' tihuejcoƚe”. ȽanDios alummepa toƚta'a ca'eƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Lijou'ma i'huana'ma. Jiƚpiya ƚilemats' lan xanuc' judío ni petsi lomana' ƚajut'ƚi pe lafoƚyomma lan xanuc' ti'hua tuya'e' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Anuli litine Jesús tecaxu ƚema al cuecaj quin'nuhua' Genesaret, jouc'a lacui'impa lin'nuhua' Galilea. Axpela' lan xanuc' efoƚya jiƚpiya tiquimf'eyi mu'ila' litaiqui' ȽanDios. Titants'iyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús ixim'ma tipa'a oque' lam barco jiƚpe ƚema caja. Liƚpoujnalá ailomana', imulumma tipajyi ƚiƚxami. ");
INSERT INTO chdNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús if'aj'ma anuli al barco, iƚe libarco Simón. Ixahue'epa Simón tiƚoc'ai'eƚa' nihuata libarco. Toƚta'a i'e'ma. Jesús micutsu jiƚpe al barco timuc'ila' lan xanuc' nomana' ƚema caja. ");
INSERT INTO chdNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lijoupa limuc'iyalepa, timi Simón: ―Ima' jouc'a lof'as lin'noƚpá catuye toƚ'hua'aƚe al barco. Toƚcuaitsa nolojmay caja tolacajm'mita ƚoƚxami, ti'nijmoƚaita latuye. ");
INSERT INTO chdNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón italai'e'e'ma, timi: ―Momxi, aƚ'epá canic' jahuay lipuqui'. Aicaƚ'noƚi. Itsiya ima' aƚminga': “Tolacajm'mita ƚoƚxami”. Ne', ima' aƚcuxe'enga', lihuejco'mo'. Cacuxe'etola' laipin'noƚpá catuye tecajm'mita ƚiƚxami. ");
INSERT INTO chdNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ecajm'mihuo'me ƚiƚxami, imantsi catuye, coƚa' tits'aƚquehuo. ");
INSERT INTO chdNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Liƚf'as quin'noƚpá catuye timana' locuenaj barco. Simón jouc'a liƚejmale ijoc'i'me iƚniya ticuaiyunca titoc'im'mola'. Icuaitsa imantsola' catuye loquej lam barco. Juaiconapa icuntaj'mola' lam barco, coƚa' ti'nijmoƚecu laja'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lixim'ma toƚta'a Simón Pedro exc'onƚingai'ma li'mitsi' Jesús, timi: ―Maipoujna, aƚpo'noƚa' caituca'. Iya' ninxans juaiconapa acueca' laijunac', catay calaic'ata maƚejmaleyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón jouc'a liƚejmale nomana' jiƚpe libarco ixpailij'mola' juaiconapa liximpá i'noƚ'me axpela' latuye. ");
INSERT INTO chdNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Liƚejmale Simón nomana' locuenaj barco, iƚne Jacobo y Juan inaxque' Zebedeo, jouc'a ixpailij'mola'. Jesús timi Simón: ―Aimixpaij'mo'. Capi'i'mo' locuena copenic'. Aimahueconayacola' latuye. Tahuetola' lan xanuc' lihuejla' iya'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","I'hua'a'me liƚbarco ƚema caja. Ipo'no'me jahuay, ihuej'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mipa'a Jesús anuli liƚya' icuaiyunni anuli cal xans tipa'a licuana cuftine lepra. Jahuay licuerpo imanna cahuí. Ixim'ma Jesús ic'ommof'cai'ma ƚamats', tixahue'e titoc'iƚa', timi: ―Maipoujna, ima' nipajnya latufc'enƚa', caxinxoxi aƚ'inƚa' limpio. ¿Ja'ni to'e'ma? ");
INSERT INTO chdNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús i'nij'ma limane, iƚaf'ma ƚafcuana, timi: ―Ca'e'ma, ti'intso' limpio. Aiquicoƚ'ma iƚojn‑na'ma lehui. ");
INSERT INTO chdNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús ixc'ai'i'ma, timi: ―Aimo'itola' lan xanuc' te ts'i'ic' li'ipo'. Nij naitsi mi'iya quixina'. To'huaƚa', tomujxoxi ƚa'ailli'. Moisés joupa icuxepa te ts'i'ic' mitsufcoyacu iƚniya pe lixaƚconapola' liƚcuana iƚe alepra, ima' totsufcotsi jouc'a. Toƚta'a aƚsim'monga' lihuejcoyi iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tama Jesús timi: “Nij naitsi mi'iya quixina'”, lan xanuc' xonca icuej'me lo'epa. Icuaiyunca axpela' lan xanuc'. Iƚpic'a tiquimf'eƚe Jesús lomuc'iyalepa, iƚpic'a tixaƚ'menatsola' liƚcuana. ");
INSERT INTO chdNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Camna, camna Jesús tijuc'iyoxi. Itsehuo'ma pe ailopa'a quiƚya', pe ailopa'a xanuc', jiƚpe tipalaic'o qui'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Anuli litine timuc'ila' lan xanuc'. Jiƚpe timana' lan xanuc' fariseo, jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. Iƚniya quiyouyomma jahuay ƚiƚeloƚya' al distrito Galilea, jouc'a al distrito Judea, jouc'a al cuecaj quiƚya' Jerusalén. Jiƚpiya ȽanDios timuqui lipepaxi, Jesús tixaƚ'menala' lafcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Icuaiyunca hualca lan xanuc' iƚtaic' anuli ƚuhuaqueya xans, tunaf'ya ƚihuijm‑ma'. Ehue'me te co'iya muyai'eyacu ƚiƚpefcuana ticuai'etsa pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jiƚpe efot'ƚeyoƚtsi axpela' lan xanuc' aimi'iya mitsufai'eyacu. If'ajli'me al toncay lajut'ƚ, enai'e'me luhua'e cajut'ƚ, jiƚpiya ecajnco'me ƚuhuaqueya xans. Ecajmpá to qui'ic' ƚihuijm‑ma' nolojmay xanuc', maƚpe pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús ixim'mola' ti'huaiyijnyi tixaƚ'mena'ma cal xans, timi: ―Maipima, lojunac' joupa iƚojn‑napa. ");
INSERT INTO chdNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lan xanuc' fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios ticuayi liƚpicuejma': “¿Naitsi iƚca'a cal xans? Ti'e'eyoxi to ȽanDios. Ma le'a ȽanDios tiƚonc'e lajunac', iƚca'a a'i.” ");
INSERT INTO chdNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús ixina' toƚta'a ticuayi liƚpicuejma'. Icuis'e'mola': ―Imanc', ¿te coƚnescopa toƚta'a loƚpicuejma'? ");
INSERT INTO chdNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ja'ni toƚsinyi ipime iƚiya laimipa cal xans: “Lojunac' joupa iƚojn‑napa”? Ja'ni camiƚa': “Totsahuenni, to'huaƚa'”, ¿te toƚsim'me a'i quipime iƚe lataiqui'? ");
INSERT INTO chdNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Itsiya camuc'i'molhuo' icueya laimane. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ma capa'a fa'a li'a ƚamats' ti'i'ma quiƚonc'e'e'mola' liƚjunac' lan xanuc'. Timi ƚuhuaqueya xans: ―Totsahuenni. Tonif'la' ƚohuijm‑ma'. To'huanƚa' lomejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mehuelojnyi jahuay lan xanuc' aiquicoƚ'ma, cal xans itsahuenanni, ecaxna'ma. Inif'ma ƚihuijm‑ma', i'huana'ma lejut'ƚ, tix'najtsi'i ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jahuay nomana' jiƚpe lajut'ƚ tocomma tipailo liƚpicuejma'. Ixim'me juaiconapa acueca' li'e'ma Jesús. Ix'najtsi'i'me ȽanDios. Ixpailij'mola', timiyoƚtsi: ―Itsiya aƚsimpá acueca' li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesús ipanni jiƚpe i'hua'ma, ixim'ma anuli ƚin'najtsi'iyale cuftine Leví, ticutsu pe lo'najtsi'iyaleyompa. Jesús timi: ―Lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví itsahuenni, ipo'no'ma jahuay, ihuej'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jiƚpe lejut'ƚ Leví i'eyo'ma lijuic Jesús. Jiƚpe Jesús titetsoyi ts'ilihuequi jouc'a axpela' lin'najtsi'iyale jouc'a ocuenaye xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jiƚpiya timana' lan xanuc' fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, iƚniya tihuejcoyi liƚ'ejma' lam fariseo. Tixtuc'oyi Jesús. Timinnila' ts'ilihuequi: ―Imanc', ¿te coƚtetsocopa, te coƚsnacopa anuli lin'najtsi'iyale y locuenaye lan xanuc', iƚne aimihuejcoyi locuxepa ȽanDios? ");
INSERT INTO chdNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús italai'e'e'mola', timila': ―Lan xanuc' pe ailopa'a quiƚcuana aimicuicomma no'eyacola' cafxi. Laxtafpola' ƚinca ticuicomma no'eyacola' cafxi. ");
INSERT INTO chdNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iya' aicuaicoco'ma cajoc'itsola' ts'iƚtaic' quiƚjunac', tixhuej'menanca. Aicajoc'ila' pe ailopa'a quiƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lijou'ma, timiyi Jesús: ―Ts'ilihuequi Juan itine itine tixnet'ƚyi, aimitetsoyi, tijoc'iyi ȽanDios. Ma' anuli lo'epa ts'ilihuequi lam fariseo. Ima' ts'ihuejhuo' aimixnet'ƚyi, titetsoyi, tixnayi, ma to lo'epa jahuay lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús italai'e'e'mola', timila': ―Mipa'a namaneya, ¿te ticuxe'e'mola' liƚejmale aimitetso'me? ");
INSERT INTO chdNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","A'i. Ticuaitsi litine tiƚonc'e'enatsola' namaneya, iƚne liƚejmale timanecu quiƚtuca', iƚniya ƚitiné ƚinca tixnet'ƚ'me, aimitetsoyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús ti'hua timuc'ila'. Ipango'ma i'onƚico'ma lomuc'iyalepa. Timila': ―¿Te tolipa'a'me tutani anuli al ts'e loƚpijahua', tolanajmot'ƚico'me lafane loƚpijahua'? A'i. Ailopa'a no'eya toƚta'a. Ja'ni toƚta'a tonƚ'eƚe aimetenƚcocoya lafane lijahua'. Aimi'eya quipenic' ni lafane ni al ts'e. ");
INSERT INTO chdNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","’Jouc'a aimoƚc'ej'miyacu al ts'ej vino lafane' pontalay quixmi. Ja'ni toƚta'a tonƚ'eƚe al ts'e vino tits'aƚ'mola' lafane' pontalay quixmi, tic'ejaiquehuo al ts'ej vino, timinsco'mola' ƚixmi. ");
INSERT INTO chdNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Al ts'ej vino toƚc'ej'mi'me al ts'ej ponta quixmi. ");
INSERT INTO chdNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jouc'a camilhuo': Pe noxnapa litojpa vino aiquipic'a al ts'ej vino. Ticua: “Xonca ac'a litojpa vino”. ");
INSERT INTO chdNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Anuli litine conxajya Jesús jouc'a ts'ilihuequi tuyalaicoyi nolojmay cal trigo. Ts'ilihuequi ipa'apá ƚixpaj cal trigo, untaijco'me liƚmane, ite'me. ");
INSERT INTO chdNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hualca lan xanuc' fariseo icuis'em'mola' ts'ilihuequi Jesús, timinnila': ―Imanc', ¿te coƚ'ecopa toƚta'a? Ailopa'a lane mi'enyacu toƚta'a. Itsiya itine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús italai'e'e'mola', timila': ―¿Te aga aicoƚsuec' li'epa David anuli litine tunle'eyi jouc'a liƚejmale? ");
INSERT INTO chdNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Itsufai'ma lejut'ƚ ȽanDios. Epenuf'ma lam paxi ca'i lopa'a jiƚpe, iƚque ƚa'i i'huexi ȽanDios. Lan xanuc' aimi'iya mitejacu, ma le'a la'aillí tite'me. Ƚinca David ite'ma, epi'i'mola' liƚejmale, jouc'a ite'me. ");
INSERT INTO chdNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iya' naPoujna. Iya' caxpic'e te ts'i'ic' lo'eyacu laixanuc' litine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ocuena quitine conxajya Jesús timuc'iyale lajut'ƚ pe lafoƚyomma lan xanuc'. Jiƚpe tipa'a anuli cal xans ijuƚpa al c'a quimane. ");
INSERT INTO chdNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jiƚpe timana' lan xanuc' fariseo, jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. Tehuelaifyi Jesús. Ticuayi: “Itsiya itine conxajya. Aga tixaƚ'meyale'ma. Ja'ni toƚta'a ti'eƚa', aƚcufta.” ");
INSERT INTO chdNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús ixina' locuapa iƚne liƚpicuejma'. Timi cal xans ƚijuƚpa quimane: ―Totsahuenni. To'huanni. Tacaxla' jifa'a. Cal xans itsahuenni, i'hua'ma, ecax'ma jiƚpe limipa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús timila': ―Aƚtalai'e'eƚa' imanc'. Litine conxajya, ¿te ts'i'ic' caƚ'eyacu? ¿Te ts'ipic'a ȽanDios? ¿Aƚ'e'me al c'a o aƚ'e'me lixcay? ¿Lunƚu'e'me anuli cal xans? O ¿alacani'e'me? ");
INSERT INTO chdNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús ehuelojm'mola' lan xanuc' micutshuoƚanna jiƚpiya. Timi cal xans: ―To'nijla' lomane. Cal xans i'nij'ma limane, ixaƚcona'ma nulemma. ");
INSERT INTO chdNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lan xanuc' fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios ixtulenca juaiconapa. Ipalaic'o'moƚtsi, timiyoƚtsi: “¿Te caƚ'e'eyacu iƚque cal xans Jesús?” ");
INSERT INTO chdNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Iƚniya ƚitiné Jesús if'aj'ma ƚijualay tipalaic'ota ȽanDios. Iƚpe ipanenni jahuay lipuqui', tipalaic'o ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Joupa epalc'opa ijoc'i'mola' ts'ilihuequi ticuaiyunca pe lopa'a. I'huijf'e'mola' imbamaj coquexi'. Iƚniya ecui'i'mola' lan apóstole. Liƚpuftine iƚniya: ");
INSERT INTO chdNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón, Jesús ecui'i'ma locuena quipuftine, iƚe aPedro. Andrés, iƚque ipima Simón. Jacobo jouc'a Juan, Felípe jouc'a Bartolomé, ");
INSERT INTO chdNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo jouc'a Tomás, Jacobo iƚque i'hua Alfeo, jouc'a ƚocuena Simón. Ate'a iƚquiya Simón anuli liƚpicuejma' lan xanuc' nocuapá: “Lunƚu'e'me ƚalamats'”. ");
INSERT INTO chdNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, iƚque i'hua anuli cal xans cuftine Jacobo, jouc'a Judas Iscariote, iƚque nocuya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús jouc'a ts'ilihuequi imulnanca ƚijuala. Icuaiyunca ƚihuojma, ecaxma jiƚpiya Jesús. Jiƚpe timana' axpela' ts'ilihuequi Jesús jouc'a axpela' lan xanuc', iƚniya quiyouyomma ni petsi al distrito Judea, jouc'a quiyouyomma al cuecaj quiƚya' Jerusalén, jouc'a ƚamats' ƚema caja pe lopa'a ƚiƚeloƚya' Tiro y Sidón. Icuaicoco'me tiquimf'eƚe litaiqui' Jesús, tixaƚ'menatsola' liƚcuana. ");
INSERT INTO chdNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Loteƚ'mipola' ƚonta'a, ixaƚcona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lafcualƚay noxpayaf'pá Jesús tixingufyi lipepaxi. Jahuay lafcualƚay ixaƚcona'mola'. Toƚiya jahuay lan xanuc' tehueyi tixpayaf'le Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mehuelongila' ts'ilihuequi Jesús timila': ―Imanc', ja'ni ailopa'a coƚ'hueca, ƚinca tuluyalaicoyi al c'a. Pe loƚmana' tipa'a ȽanDios cal Rey, toƚmana' anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ja'ni itsiya tulunle'eyi, ƚinca tuluyalaicoyi al c'a. Ticuaihuo litine tinajntolhuo'. ’Ja'ni itsiya toƚjolijyi, ƚinca tuluyalaicoyi al c'a. Ticuaihuo litine tixojna'ma cunlata. ");
INSERT INTO chdNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ticuaitsi litine ti'entsolhuo' laic' imanc' ts'alihuequi, ja'ni tenajtsolhuo', aimepenufilhuo', ja'ni timintsolhuo' quixcay cataiqui', ja'ni tilaiquintsolhuo' jouc'a loƚpuftine, ti'iƚa' coƚsina' tuluyalaicoyi al c'a. ");
INSERT INTO chdNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","¡Toliyuc'tseƚe tixojla' cunlata! Jipu'hua lema'a tipa'a al cueca' lapi'inyacolhuo'. Imanc' ti'onƚcospolhuo' to lam profeta. Loƚsanuc' ti'elhuo' laic'. Loƚtatahueló ma' anuli li'epá, iteƚ'mim'mola' lam profeta. ");
INSERT INTO chdNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Imanc' ja'ni ts'acueca' coƚ'huexi, a'ijc'a muluyalaicoyi. Joupa olapenufpá. ");
INSERT INTO chdNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Imanc' ja'ni itsiya ixhuaiyilhuo', ƚinca a'ijc'a muluyalaicoyi. Ticuaihuo litine tulunle'e'me. ’Imanc', ja'ni itsiya tixoqui cunlata, tunlixoyi, ƚinca a'ijc'a muluyalaicoyi. Ticuaihuo litine toƚhuotso'me, toƚjolij'me. ");
INSERT INTO chdNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ja'ni jahuay lan xanuc' tinescolhuo' ma le'a al c'a, ƚinca a'ijc'a muluyalaicoyi. Ja'ni toƚta'a lo'ipolhuo' imanc' ti'onƚcospolhuo' to lam profeta nofelƚaiquepá. Lan xanuc' nonescopolhuo' al c'a itsiya, liƚtatahueló iƚniya toƚta'a linescopa. Aiquilimetsaijma ja'ni nofelƚaiquepá profeta. ");
INSERT INTO chdNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Imanc' naƚcuec'epa camilhuo': Toƚ'etsola' capic'a laixtuc'opolhuo'. Toƚ'etsola' al c'a iƚne no'epolhuo' laic'. ");
INSERT INTO chdNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Toƚpaxnetsola' pe nomipolhuo' quixcay cataiqui'. Toƚsahue'eƚe ȽanDios titoc'itsola' iƚne no'epolhuo' lixcay. ");
INSERT INTO chdNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ja'ni tuntaftso' lopeque, tomuc'iƚa' locuena lopeque. Ja'ni texic'e'etso' lopuquiya, aimocuanaj'ma lotsamalo, tommi'iƚa' jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ja'ni tixahue'etso', tapi'itsola' jahuay iƚniya. Ja'ni texic'e'etso' ƚo'huexi, aimomi'ma: “Aƚpai'inƚa'”. ");
INSERT INTO chdNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ma to imanc' oƚpic'a ti'entsolhuo' al c'a, toƚta'a toƚ'etsola' loƚf'as xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ja'ni toƚ'etsola' capic'a ma le'a iƚniya no'epolhuo' capic'a, ¿te ȽanDios tetenƚcoco'ma loƚ'ejma'? A'i. Ma toƚta'a mi'eyi locuenaye lan xanuc', iƚne pe aimihuejyi locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ja'ni toƚtoc'itsola' ma le'a iƚniya notoc'ipolhuo', ¿te ȽanDios tetenƚcoco'ma loƚ'ejma'? A'i. Ma toƚta'a mi'eyi locuenaye lan xanuc', iƚne pe aimihuejyi locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ja'ni tolapi'itsola' ma le'a iƚniya nopai'iconayacolhuo', ¿te ȽanDios tetenƚcoco'ma loƚ'ejma'? A'i. Toƚta'a mi'eyi locuenaye lan xanuc', iƚne pe aimihuejyi locuxepa ȽanDios. Iƚniya tepi'innila' quiƚtomí petsi lopai'iconayacola'. ");
INSERT INTO chdNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","’Imanc' tonƚ'e'mola' capic'a pe no'epolhuo' laic'. Toƚtoc'itsola' jahuay loƚf'as xanuc'. Ja'ni tixahue'etsolhuo' tonlapi'i'mola'. Aimoƚnes'me: “Ne', lapi'iconaƚa'”. Imanc' ja'ni lihuejcoƚa' iƚta'a laitaiqui' tunlulij'me acueca'. Ti'onƚcotolhuo' loƚ'ejma' to li'ejma' coƚ'Ailli', iƚque Nopa'a lema'a xonca al toncay. Iƚque tama aimix'najtsi'iyi, tama ixcay xanuc', ma ti'hua titoc'ila'. ");
INSERT INTO chdNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","’Coƚ'Ailli' Nopa'a lema'a tixinnila' acuanuc'la jahuay lan xanuc'. Imanc' jouc'a toƚsintsola' acuanuc'la loƚf'as xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Imanc' aimoƚnesco'mola' loƚf'as xanuc', toƚta'a aiminescoyacolhuo'. Aimolacani'e'mola' locuenaye, toƚta'a aimecani'enyacolhuo' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tolimenc'e'ecotsola' liƚjunac' loƚf'as xanuc', toƚta'a timenc'e'ecom'molhuo' loƚjunac' imanc'. Tolapi'itsola' locuenaye, toƚta'a tepi'icona'molhuo'. Tepi'icom'molhuo' al c'a alxpijma', lixhueya tentenca ipijuala, ti'e'em'mo' titsujoƚaiquemma. ");
INSERT INTO chdNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ti'hua tipalaic'ola', i'onƚico'mola' lo'iyacola' lan xanuc' petsi amuf liƚpicuejma', ticua: ―Anuli cal fo', ¿te ti'i'ma texaƚ'ma ƚif'as fo', timuc'i'ma lane? A'i. Loquexi' tecajm'moƚaita lina. ");
INSERT INTO chdNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","’Cal xans naihuejpa ƚipomxi ma le'a tihuequi, a'i xonca acueca' xans. Aimicuxeya ƚipomxi. Tijouƚa' joupa ihuic'ipa ti'onƚcota to ƚipomxi. ");
INSERT INTO chdNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Ima', ¿te cofmehuelojncopa ƚopima ƚipifuc li'u? ¿Te aimahuelojnyoxi lo'nico laxma lo'u? ");
INSERT INTO chdNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mipa'a laxma jiƚpe lo'u, ¿te cofmicoya ƚopima: “Maipima, lapi'iƚa' lane quiƚonc'e'e'mo' ƚipifuc lo'u”? Ma le'a to'e'eyoxi xonca. Ate'a taipa'aƚa' al cuecaj laxma lo'nico lo'u. Tijouƚa', tahuelojm'ma al c'a, nipajnya taipa'a'ma ƚipifuc ƚopa'a li'u ƚopima. ");
INSERT INTO chdNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ja'ni ac'a al 'ec aimi'iya mi'asya ƚixcay qui'as. Ja'ni ixcay al 'ec aimi'iya mi'asya cal c'a qui'as. ");
INSERT INTO chdNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Toxinƚa' ƚi'as, toƚta'a taimetsaico'ma jale c'ec iƚca'a. Petsi litac cantsinni aimoxinya lan higo. Petsi al xummi aimoxinya lan 'uva. ");
INSERT INTO chdNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Cal c'a xans tipa'e al c'a li'hueca jiƚpe lipicuejma'. Ƚixcay xans tipa'e lixcay li'hueca jiƚpe lipicuejma'. Ma to quimanna lipicuejma', ja'ni al c'a ja'ni ixcay, toƚta'a litaiqui' tipamma lico. ");
INSERT INTO chdNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Imanc', ¿te caƚmicopa: “MaƚPoujna, maƚPoujna”, tijouƚa' aimonƚ'eyi ma to laifmipolhuo'? ");
INSERT INTO chdNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Camuc'i'molhuo' ƚo'onƚcoya cal xans nocuaiya pe laifpa'a, aƚquimf'e laitaiqui', lihuejma. ");
INSERT INTO chdNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ca'onƚico'ma to cal xans nilanc'epa lejut'ƚ. Ipu'ma a'ojca, i'huajco'ma ƚixmi capic. Maƚpiya titsahue'ehuo quejut'ƚ. Litine lipanni axpe' al pana', lixpe'ma laja', unts'af'i'ma lajut'ƚ, iƚe lajut'ƚ aiquifenna. Ailopa'a qui'ipa, joupa ilange juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","’Cal xans ja'ni ma le'a aƚquimf'epa laitaiqui', iƚque ca'onƚico'ma to cal xans ituca' li'ejma'. Iƚque lilanc'epa lejut'ƚ aiquipucufi. Litsahue'eyomma pe ƚixaƚi camats'. Lipanni al pana', acueca' unts'af'i'ma laja', lajut'ƚ aiquicoƚ'ma, eteƚquemma. Ecanipa nulemma. ");
INSERT INTO chdNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lijoupa lipalaic'opola' toƚta'a lan xanuc' nomana' jiƚpiya, Jesús i'hua'ma, itsufai'ma liƚya' Capernaum. ");
INSERT INTO chdNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jiƚpe tipa'a anuli cal mozo juaiconapa textafque, tima'ma. Ƚipoujna ticuxela' amaxnu lisoldado. Iƚque nocuxepola' lan soldado ti'ay capic'a juaiconapa ƚimozo. ");
INSERT INTO chdNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Licuej'ma tixaƚ'menala' Jesús lafcualƚay umme'mola' hualca lan tsilaj xanuc' judío, iƚne noxpijpá lataiqui', tiyeƚe pe lopa'a Jesús. Tilecotsa, ticuaiyunni lejut'ƚ, tixaƚ'me'ma ƚimozo. ");
INSERT INTO chdNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Iƚne lan tsilaj xanuc' judío icuaitsa pe lopa'a Jesús. Inonc'o'me, timiyi: ―To'huanni, totoc'ita jiƚque nocuxepola' lan soldado. Iƚque ac'a xans. ");
INSERT INTO chdNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Aƚ'enga' capic'a illanc' ixanuc' Israel. Aƚƚanc'e'eponga' anuli lajut'ƚ pe lalafot'ƚeyopoƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús iyejmale'me. Ai'a ticuaita lejut'ƚ nocuxepola' soldado italecuf'me locuenaye lummeconapola'. Timiyi Jesús: ―Nocuxepola' soldado timihuo': “Maipoujna, aimocuaicohuo. Aimoxoc'i'moxi. Iya' caxinyoxi juaiconapa na'hua xans. Aimi'iya motsufaiya lainejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iya' aimi'iya catalecufyaco'. Caxina calaic'ata. Ma le'a tonesla': Tixaƚconƚa' ƚomozo, tijouƚa' tixaƚcona'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iya' quihuejma naƚcuxepa, jouc'a cacuxela' laisoldado. Cami'ma anuli: To'huaƚa', iƚque ti'hua'ma. Cami'ma ƚocuena: To'huanni, iƚque ti'huamma. Cami'ma ƚaimozo: To'eƚa', ma ti'e'ma.” ");
INSERT INTO chdNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Licuej'ma Jesús toƚta'a linespa ƚincuxepa, etenƚcoco'ma juaiconapa. Ipai'e'moxi ipalaic'o'mola' lan xanuc' liƚenc'e, timila': ―Iƚque cal xans lixanuc' aimimetsaicoyi ȽanDios. Imanc' ixanuc' Israel tolimetsaicoyi ȽanDios. Camilhuo': Ailopa'a caiximpa nij naitsi imanc' to iƚque cal xans. Iƚque ƚinca xonca ti'huaiyinge ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ipailinamma lummeconapola', licuainata lejut'ƚ ƚincuxepa iximpá ƚafcuana joupa ixaƚconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lijou'ma Jesús i'hua'ma anuli liƚya' cuftine Naín. Iƚejmale ts'ilihuequi jouc'a axpela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesús micuaispa huejnca pe lotsufaicompa liƚya' jiƚpiya tilipalumma lan xanuc' iƚtaic' anuli ƚimanapa. Iƚque ƚimanapa, ƚaca'no' anuli qui'hua. Qui'máma' apotsate. Axpela' lan xanuc' iƚpe liƚya' liƚejmale ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús ehuelojm'ma ƚaca'no', ixim'ma cuanuc', timi: ―Aimojoj'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Iƚoc'huai'ma pe lopa'a ƚimanapa. Ixpayaf'ma lonaf'ya ƚimanapa. Iƚne ts'iƚtaic' ecaxoƚ'me. Jesús timi: ―Mamijcano, camihuo': Totsahuenni. ");
INSERT INTO chdNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ƚimanapa icutsaina'ma, ipango'ma ipalai'ma. Jesús exat'ƚina'ma qui'máma'. ");
INSERT INTO chdNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jahuay lan xanuc' ixpailij'mola'. Ixim'me acueca' li'ipa. Ix'najtsi'i'me ȽanDios, ticuayi: ―Anuli cal cuecaj profeta icuai'ma pe laƚmana'. ȽanDios icuai'ma, aƚtoc'inga' illanc' ixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ni petsi al distrito Judea, jouc'a ƚamats' ahuejnca jiƚpiya, lan xanuc' icuej'me li'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jouc'a Juan Bautista icuej'ma jahuay iƚna'a. Ts'ilihuequi u'ipá. Juan ijoc'i'mola' oquexi' ts'ilihuequi, ");
INSERT INTO chdNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","umme'mola' pe lopa'a Jesús, ticuis'etsa, timitsa: “Itsiya aƚ'huaicoyi ƚocuaicoya ƚommeya ȽanDios. ¿Te ima'? o ¿te ti'hua aƚ'huaico'me ƚocuaicoya?” ");
INSERT INTO chdNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Iƚne icuaitsa pe lopa'a Jesús, timiyi: ―Juan Bautista alummeponga' licuis'e'mo', timi'mo': “Aƚ'huaicoyi ƚocuaicoya Ƚommeya ȽanDios, ¿te ima'? o ¿te ti'hua aƚ'huaico'me ƚocuaicoya?” ");
INSERT INTO chdNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Maƚe litine Jesús tixaƚ'mela' axpela' lafcualƚay, ituca' ituca' liƚcuana. Jouc'a ipa'apola' lontahue litsuflaipá lan xanuc'. Jouc'a axpela' lam fohue tehuetsalenayi, joupa ixaƚ'menapola' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iƚque timila' lummepolaj Juan: ―Ne', tonƚenƚe. Toƚcuaitsa pe lopa'a Juan tolu'itsa te ts'i'ic' loƚsimpa, loƚcuejpa. Toƚmita: Tehuetsalenayi lam fohue, tiyenayi lam coxo, tixaƚconnala' ts'ilehui lepra, ti'inala' limpio, ticuejnayi lan taƚpe, timaf'inayi limanapola'. Lan xanuc' pe aiquiƚ'hueca tu'innila' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","’Jouc'a toƚmitsa Juan: “Cal xans natenƚcocopa lai'ejma' iƚque ƚinca al c'a loyaicoya”. ");
INSERT INTO chdNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iyena'me lummepolaj Juan. Jesús ipango'ma ipalaic'o'mola' lan xanuc' lefoƚya jiƚpiya. Tipalaijma Juan, timila': ―Imanc', ¿te coƚtsecohuo'me jipu'hua pe ailopa'a quiƚya'? ¿Te coƚsinhuo'me jiƚpiya? ¿Te oƚsinhuo'me anuli al jaxa tife'ne ƚahua'? ");
INSERT INTO chdNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ja'ni a'i, ¿te coƚtsecohuo'me? ¿Naitsi coƚsinhuo'me jiƚpiya? ¿Te oƚsinhuo'me anuli cal xans nopo'nopa al c'a lipijahua', acueca' lipitali? A'i. Lan xanuc' nopo'nopá liƚpijahua' acueca' al c'a, notetsopá al c'a, iƚniya timajnyi ƚilejut'ƚi lan rey. ");
INSERT INTO chdNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","’¿Te coƚtsecohuo'me? ¿Naitsi coƚsinhuo'me jiƚpiya? ¿Te oƚsinhuo'me anuli cal profeta? Aƚinca oƚsinhuo'me anuli cal profeta, iƚque Juan. Iƚque aimi'onƚspola' to lam profeta, xonca acuecaj xans. ");
INSERT INTO chdNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Al Paxi Liniƚingiya joupa ipalaicopa Juan ticuaihuo, ticua: ¡Aƚquimf'eƚa'! Cumme'ma ƚainepaluc. Iƚque ti'huajme'mo', tuya'a'ma ima' tocuaihuo. Tilanc'e'e'mo' lopene pe lof'huaya. ");
INSERT INTO chdNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iya' camilhuo': Iƚque Juan acuecaj xans. Ailopa'a caca'no' quipo'nohuo ƚi'hua to iƚquiya. Tama aimi'iya mi'onƚyacola' to Juan, ja'ni joupa itsufaipa petsi locuxeyopa ȽanDios Nopa'a lema'a, tama xonca aca'hua xans, iƚque joupa ulijnapa Juan. ");
INSERT INTO chdNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lan xanuc' jouc'a no'najtsi'iyalepá iquimf'epá linespa Juan, iƚne imetsaico'me ȽanDios aƚijca lo'epa, epo'i'mola' Juan. ");
INSERT INTO chdNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lan xanuc' fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios etets'i'me loxpic'epa ȽanDios, aiquilepoc', aimicuayi. ");
INSERT INTO chdNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús ti'hua tipalaic'ola' lan xanuc', timila': ―¿Te caif'onƚicoyacolhuo' imanc' noƚmana' fa'a itsiya? ¿Te ts'i'ic' loƚ'ejma'? ");
INSERT INTO chdNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ca'onƚico'molhuo' to la'uhuay nocutshuoƚanna pe locucaleyompa, tijaic'oyoƚtsi. Anuli iƚne timila' lif'as ca'uhuay: “Illanc' aƚfus'mipá laƚjaxa, toƚsouƚe. Aicoƚtsahuo. Lunac'lipá ihuotsoqueya, aicoƚjoqui.” ");
INSERT INTO chdNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","’Toƚta'a loƚ'ejma' imanc'. Ailopa'a catenƚcocoyacolhuo'. Juan Bautista aimitesma to moƚtetsoyi imanc', aimixnay vino. Imanc' toƚcuayi: “Iƚque itsufaipa conta'a”. ");
INSERT INTO chdNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iya' aicuai'ma fa'a li'a ƚamats' catesma to moƚtetsoyi imanc', caxnay al vino. Imanc' aƚnesc'e, toƚcuayi: “Toƚsinƚe, iƚca'a cal xans intetsopa, in‑xnatsaipa. Iƚejmale iƚne lin'najtsi'iyalepá jouc'a locuenaye lan xanuc' pe aimihuejcoyi locuxepa ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","’Iya' cacua: Ƚinca ȽanDios acueca' ac'a lipicuejma', toƚta'a timujyi iƚne naihuejcopá, jouc'a acueca' ac'a liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anuli cal xans fariseo ijoc'i'ma Jesús titetsota. Jesús i'hua'ma, icuaitsi lejut'ƚ cal xans fariseo, icutshuai'ma titetso'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jiƚpe liƚya' tipa'a anuli ƚaca'no' ixcay lo'epa. Iƚque icuej'ma ijoc'impá Jesús lejut'ƚ cal xans fariseo. Ƚaca'no' i'hua'ma lejut'ƚ cal xans. Itai'ma anuli al cuecaj pulu ilajncopa apic cuftine alabastro. Al pulu imanna caceite tujuej c'a. ");
INSERT INTO chdNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ƚaca'no' iƚoc'huai'ma li'mitsi' Jesús. Ipango'ma tijoqui. Ƚujuay ijac'eco'ma li'mitsi' Jesús, etufc'eco'ma ƚijuac. Ituc'o'ma li'mitsi' Jesús, ic'ef'i'i'ma laceite lojuepa c'a. ");
INSERT INTO chdNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cal xans fariseo, iƚque nijoc'ipa Jesús, ixim'ma lo'epa ƚaca'no'. Iƚque timiyoxi: “Ja'ni aƚinca aprofeta iƚque cal xans Jesús, ti'i'ma quixina' te ts'i'ic' lipicuejma' iƚca'a ƚaca'no', ti'i'ma quixina' tipa'a acueca' lijunac'. Ticuanaj'moxi, ticua'ma: Aimaƚ―laf'ma.” ");
INSERT INTO chdNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús ipalaic'o'ma cal xans fariseo, timi: ―CumSimón, tipa'a laifmiyaco'. Timi: ―Ne', Momxi, aƚmiƚa'. Jesús timi: ");
INSERT INTO chdNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","―Timana' oquexi' lan xanuc' iƚtaiyinc'e anuli cal xans. Anuli itaiyinc'e to lolijya anuli camats' y onƚca. Ƚocuena itaiyinc'e to lolijya anulij mut'ƚa y onƚca. ");
INSERT INTO chdNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iƚne loquexi' lan xanuc' ailopa'a co'najtsecoyacu. Iƚque lepi'ipola' quiƚtomí imenc'e'eco'mola' loquexi' liƚtaiyinc'e. Itsiya aƚmiƚa': ¿Iƚne loquexi' naitsi xonca co'eya capic'a iƚque nimenc'e'ecopola' ts'iƚtaiyinc'e? ");
INSERT INTO chdNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón timi: ―Iya' cacua: Iƚque nitaiyinc'e xonca, xonca ti'e'ma capic'a. Jesús timi: ―Otalai'epa ma' al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ipai'e'moxi, ehuelojm'ma ƚaca'no', timi Simón: ―Toxina lo'epa iƚca'a ƚaca'no'. Iya' aicuai'ma lomejut'ƚ. Aicaluhui'i caija' capajcoya lai'mitsi'. Iƚca'a ƚaca'no' lapac'e'ecopa ƚujuay lai'mitsi', etufcopa ƚijuac. ");
INSERT INTO chdNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ima' aicaƚtuc'o'. Iƚca'a ƚaca'no' laicuai'ma fa'a ipangopa aƚtuc'opa lai'mitsi', ti'hua aƚtuc'o'. ");
INSERT INTO chdNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ima' aicaƚc'ef'i'i caceite ƚaijuac. Iƚca'a ƚaca'no' aƚc'ef'i'ipa caceite lojuepa c'a lai'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","’Iya' camihuo': Iƚca'a ƚaca'no' joupa imenc'e'ecompa al cueca' li'epa, toƚiya aƚ'epa capic'a juaiconapa. Cal xans aijtine li'epa, ja'ni timenc'e'ecom'me, aijtine ti'e'ma capic'a. ");
INSERT INTO chdNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesús ipalaic'opa ƚaca'no', timi: ―Joupa imenc'e'ecompo' lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Locuenaye lijoc'impola' ipango'me imi'moƚtsi: ―¿Naitsi iƚca'a cal xans? Timi: “Joupa imenc'e'ecompo' lo'epa”. Toƚta'a aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús timi ƚaca'no': ―Ima' aƚ'huaiyijmpa, toƚiya joupa unƚupo'. To'huanƚa' tixojla' meta. Aimoxhueƚmot'ƚecona'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lijou'ma Jesús iƚya' iƚya' ti'huaf'cay, lan tsilaj quiƚeloƚya' jouc'a lan tsocay quiƚeloƚya'. Tuya'e' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Tijoc'ila' lan xanuc' tihuejcoƚe ȽanDios cal Rey. Limbamaj coquexi' ts'ilihuequi iƚejmale. ");
INSERT INTO chdNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Jouc'a tiyeyi lacaƚ'no'. Iƚne lacaƚ'no' Jesús joupa ixaƚ'menapola'. Hualca iƚniya ipa'epola' lontahue litsuflaipá, locuenaye ituca' quiƚcuana. Anuli iƚniya aMaría ƚas Magdala ƚipa'empa acaitsi lontahue. ");
INSERT INTO chdNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jouc'a tiyeyi axpela' lacaƚ'no' ts'iƚ'hueca. Iƚniya ixhuico'me ƚiƚ'huexi, itoc'im'mola' Jesús jouc'a ts'ilihuequi. Anuli iƚniya cuftine aJuana, ipeno anuli cal xans cuftine aChuza, iƚque ticuxe ƚi'huexi cal rey Herodes. Ocuena cuftine aSusana. ");
INSERT INTO chdNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Axpela' lan xanuc' quipalyomma ƚiƚeloƚya' iyouyunca pe lopa'a Jesús. Lijoupa lefot'ƚepoƚtsi iƚniya lan xanuc' Jesús i'onƚico'ma lo'epa ȽanDios fa'a li'a ƚamats'. Timila': ");
INSERT INTO chdNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Cal xans ipanni ica'nehuo'ma lam fanuj trigo. Mica'ne lam fanu' hualca ecangoƚaitsa lane. Lan xanuc' i'huailetsuf'me. Lacaƚ'hui naiyulpá lema'a icuaitsa, itejn‑na'me. ");
INSERT INTO chdNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","’Hualca lam fanu' i'nifcoƚaitsa ƚixmi capic. Lila'mola' lam fanu' aiquicoƚ'ma ijuƚna'mola'. Aiquix'minuhua ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","’Hualca lam fanu' itsuc'aita pe lopa'a ƚitac'. Ila'mola' ƚaifa' trigo jouc'a ƚitac'. Ƚitac' ejec'o'ena'ma ƚaifa' trigo. ");
INSERT INTO chdNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","’Ocuenaye lam fanu' etojmoƚaitsa cal c'a camats'. Itoj'ma, ipaj'ma, ipammaita. Anuli cal fanu' ipammaita amaxnu. Lijou'ma luya'a'ma iƚta'a lataiqui' Jesús ipalai'ma ujfxi, timila' lan xanuc': ―Naitsi nocuejpa, aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ts'ilihuequi Jesús icuis'e'me te cohuaƚquemma jiƚe lataiqui' li'onƚicopa lo'epa ȽanDios fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús timila': ―Imanc' epalc'o'ipolhuo' loƚpicuejma'. Toƚcuec'eyi lipime lataiqui' loya'apa lo'ipa petsi lan xanuc' tihuejcoyi ȽanDios ƚiƚRey. Ocuenaye a'i, aimicuec'eyi. Iƚne ma le'a aƚquimf'e ca'onƚicojma lo'epa ȽanDios, aimi'iya muhuaƚyacu. Ti'iƚa' to loya'apa al Paxi Liniƚingiya ticua: “Mehuelojnyi aimixim'me, miquimf'eyi aimicuej'me”. ");
INSERT INTO chdNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Itsiya cu'ilhuo' lohuaƚquemma iƚe lataiqui'. ’Lam fanu', iƚne itaiquí ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Iƚe li'ipola' lam fanu' lecangoƚaita jiƚpe lane, ti'onƚcospa to lo'ipola' lan xanuc' petsi ma le'a tiquimf'eyi litaiqui' ȽanDios. Ticuaiyunni ƚixcay xans tiƚonc'e'e'mola' lataiqui' liƚpicuejma'. Iƚque ƚixcay xans ticua: “Aimihuej'me iƚe litaiqui' ȽanDios. Aimunƚul'me.” ");
INSERT INTO chdNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","’Iƚe li'ipola' lam fanu' li'nif'coƚaita ƚixmi capic petsi ahuata ƚamats', ti'onƚcospa to lo'ipola' lan xanuc' noquimf'epá lataiqui', tepenufyi tixoqui quileta. Lataiqui' aimif'acay liƚpicuejma'. Oquej fanej quitine iƚniya tihuejyi lataiqui'. Ticuaitsi lateƚcoya tenajnayoƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","’Iƚe li'ipola' lam fanu' litsuc'aita nolojmay quitac', ti'onƚcospa to lo'ipola' locuenaye xanuc' noquimf'epá lataiqui'. Iƚne muyalaicoyi liƚpitine tixhueƚmot'ƚeyi juaiconapa, o tehueyi te co'iya mulijyacu acuecaj quiƚtomí, o tehueyi te co'iya mixojya quileta. Toƚta'a lataiqui' licuaita liƚpicuejma' ejec'opa, aimipammaiya. ");
INSERT INTO chdNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","’Iƚe li'ipola' lam fanu' ƚetojmoƚaita cal c'a camats' ti'onƚcospa to lo'ipola' lan xanuc' ac'a liƚpicuejma', aimifelƚaiqueyi. Iƚniya ticuejyi litaiqui' ȽanDios, aimimenc'ecoyi. Itine itine tihuejyi. Tipammoƚaispa al c'a. ");
INSERT INTO chdNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Munai'i'me anuli lepalc'o' aimic'ommumijcoyi al cutse ni aimi'nicoyi licu'u hualfa. Tipo'nof'iyi al toncay. Titsuflaiyinƚe lajut'ƚ tixim'me jiƚe lepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jahuay lic'ommuf'inya ti'huájnata, jahuay lemiya timetsaicom'me. Jahuay tepalc'o'im'me. ");
INSERT INTO chdNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Moƚquimf'eyi jouc'a toƚpo'noƚe cuenna. Cal xans ja'ni i'hueca, xonca tepi'im'me. Ja'ni aiqui'hueca, texic'ena'me jahuay. Toƚta'a timuc'im'me li'ipa ailopa'a qui'hueca. Ma le'a ines'ma: “Joupa ai'hueca”. A'ij ƚinca iƚe lonespa. ");
INSERT INTO chdNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Icuaitsa qui'máma' jouc'a lipimaye Jesús. Iƚpic'a tipalaic'o'me. Jiƚpiya timana' axpela' lan xanuc'. Aimi'iya miƚoc'oƚaiyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lan xanuc' timiyi Jesús: ―Tecaxoƚanna ƚuna co'máma' jouc'a lopimaye. Iƚpic'a tipalaic'otso'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús italai'e'e'mola', timila': ―Cai'máma', laipimaye, comana' noquimf'epá naihuejcopá litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Anuli litine Jesús jouc'a ts'ilihuequi if'ajli'me al barco. Jesús timila': ―Aƚquie'me locuenaj liju lin'nuhua'. I'hua'a'me al barco, tuyalaico'me ƚaja. ");
INSERT INTO chdNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Miquieyi Jesús ixmai'ma. Iƚpiya lin'nuhua' aiquicoƚ'ma i'hua'ma ujfxi ƚahua', ixtunni ƚaja. El barco imantsi caja'. Ts'ilihuequi Jesús ixim'me acuecaj caxpaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iƚne iƚoc'oƚai'me pe loxmai'epa Jesús. Ummef'me, timiyi: ―¡Momxi! ¡Momxi! ¡Aƚma'monga'! Jesús itsahuenni. Itale'ma ƚahua' jouc'a ƚaja. Aiquicoƚ'ma i‑ch'ixco'mola'. Jahuay ipanenanni ach'ixca. ");
INSERT INTO chdNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Timila' ts'ilihuequi: ―Imanc', ¿te aimaƚ'huaiyinge? Iƚne ixpailij'mola' juaiconapa, timiyoƚtsi: ―¿Te qui'ipa li‑ch'ixc'epa? ¿Naitsi iƚca'a cal xans? Ticuxela' ƚahua' ƚaja, tihuejcoyi. ");
INSERT INTO chdNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Lijoupa luyalaipá al cuecaj quin'nuhua' icuaitsa ƚilemats' lan xanuc' cuftine lan gadareno. Jiƚpiya ƚamats' lopa'a al huoc'ojmaica ƚemats' al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lipanni Jesús jiƚpe al barco ixim'ma icuaico'ma anuli cal xans maƚpe iƚya' xans, itsuflaipá contahue. Ixpepa quitine aimipo'nohua lipijahua', aimipanga lejut'ƚ. Tipanga pe lemumpola' limanapola'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cal xans lixim'ma Jesús ija'a'ma eca'ni'moxi, ixpats'huai'ma huejnca li'mitsi' Jesús. Ipalai'ma ujfxi, timi Jesús: ―Ima' cumJesús, i'Hua cal Cuecaj CanDios Nopa'a lema'a xonca al toncay, ¿te cocuaiyoco'ma pe laifpa'a? ¿Te ts'opic'a fa'a? Iya' caxa'huehuo' aimaƚteƚ'mi'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Toƚta'a locuapa cal xans. Jesús joupa icuxepa ƚonta'a, imipa: “Taipanni iƚque cal xans”. Iƚque ƚonta'a juaiconapa ti'noƚi cal xans. Lan xanuc' tifi'ecoyi cadena limane' li'mitsi', ticuayi: “Itsiya ailopa'a co'eya”. Ƚonta'a tepi'i quipujfxi, cal xans tits'aƚqui al cadena. Lijou'ma ƚonta'a tihuetsoqui cal xans, ti'hua'e pe ailopa'a quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús icuis'e'ma, timi: ―¿Tej muftine? Italai'e'e'ma, timi: ―Iya' laipuftine Legión. Iƚe laftine ticua: Axpela'. Axpela' lontahue itsuflaipá iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iƚne lontahue tixahue'eyi Jesús aimipa'a'mola'. Aimiye'me al muf, jiƚpe al pu'hua liculhuo. ");
INSERT INTO chdNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jiƚpe ƚemala timana' axpela' lijná titeji quiƚpitamqui. Lontahue ixahue'e'me Jesús tepi'itsola' lane titsuflaiƚe iƚne lijná. Jesús epi'i'mola' lane. ");
INSERT INTO chdNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lontahue ipalunca iƚque cal xans, itsuflai'me lijná. Jahuay iƚne lijná inul'me, if'alcoƚai'me al 'ocay, i'nijmoƚaitsa al cuecaj quin'nuhua', unxaƚac'mola', ima'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lixim'me li'ipa lan xanuc' nohuic'ipá lijna aiquicoƚ'mola', inul'me, iyena'me liƚya'. Jiƚpe uya'atsa li'ipa. Jouc'a calx'huiyaƚma' uya'atsa. ");
INSERT INTO chdNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lan xanuc' ipalunca iye'me ixintsa li'ipa. Icuaitsa pe lopa'a Jesús. Ixim'me cal xans ticutsijnya li'mitsi' Jesús. Joupa lontahue ipalnamma. I'inapa lipicuejma'. I'po'nopa lipijahua'. Lixim'me li'ipa lan xanuc' ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jiƚpiya timana' lan xanuc' joupa iximpá jahuay li'ipa. Iƚniya uya'a'me li'ipa lixaƚconapa iƚque cal xans pe ƚitsufaic' contahue. ");
INSERT INTO chdNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jiƚpe al distrito Gerasa lan xanuc' ixpailij'mola' juaiconapa. Jahuay iƚniya ixahue'e'me Jesús ti'huanƚa', tipo'notsola' quiƚtuca'. Jesús if'aj'ma al barco, tipainahuo, ticuainata ƚocuena quema lin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Cal xans pe ƚipa'empa lontahue tixahue'e Jesús tilecoƚa' jouc'a. Jesús aiquicuac'. Ixc'ai'ina'ma, timi: ");
INSERT INTO chdNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Topainanni lomejut'ƚ. To'itsola' loxanuc' al cueca' li'e'epo' ȽanDios. Cal xans i'huana'ma, icuaitsi lipiƚya'. Ni petsi jiƚpiya u'itsola' lan xanuc' al cueca' li'e'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Icuaitsi Jesús ƚocuenaj quema lin'nuhua', iƚpe iƚ'huaijma axpela' lan xanuc'. Lixim'me ixoconni quileta. ");
INSERT INTO chdNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Icuai'ma anuli cal xans lipuftine aJairo. Iƚque ipenic' iƚpe lajut'ƚ pe lafoƚyomma lan xanuc'. Iƚoc'huai'ma exc'onƚingai'ma li'mitsi' Jesús. Tixahue'e, timi: ―Ƚepá lainejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ipic'a tixinne'etsi ƚi'hua caca'no'. Iƚque textafque, tima'ma. Ƚahuats' ixhuaita imbamaj coque' ƚemats', anuli qui'hua. Jesús iyejmale'me Jairo. Miyeyi lane lanxpela' xanuc' titantsiyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nolojmay xanuc' ti'hua anuli ƚaca'no' textafque. Ixhuaita imbamaj coquej camats' mextafque. Ti'hua cajuats' licu'u. Jahuay li'hueca i'najtse'ecopola' lin'ehuale cafxi. Aiquixaƚma. ");
INSERT INTO chdNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ƚaca'no' iƚoc'huaipa pe lopa'a Jesús. Icuaitsi lixpula', iƚafc'e'e'ma ƚema lipijahua'. Aiquicoƚ'ma, ipanenni licuana, aimi'huaconghua cajuats'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús icuis'e'mola', timila' lan xanuc': ―¿Naitsi naƚ―lafpa? Jahuay italai'e'e'me, timiyi: ―Illanc' aicaƚ―lafhuo'. Pedro timi: ―Momxi, to'hua nolojmay xanuc', titantsihuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús ihui'i'ma, timi: ―Iya' aixingufcopa joupa aƚ―lafquimpa. Iƚquiya epenufpa laipaxi, ixaƚconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ƚaca'no' ixim'ma aimi'iya memiyacoxi. Iƚoc'huai'ma pe lopa'a Jesús, tixpaiqui tiyu licuerpo. Exc'onƚingai'ma li'mitsi' Jesús. Jiƚpe miquimf'eyi lan xanuc', uya'a'ma te quiƚafcopa, timi: “Aiquicoƚ'ma, aƚsaƚconapa laicuana”. ");
INSERT INTO chdNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús timi ƚaca'no': ―Mai'hua, ima' aƚ'huaiyijmpa caxaƚ'mentso'. Joupa ixaƚconapo'. To'huanƚa'. Aimoxhueƚmot'ƚecona'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mipalaic'o Jesús ƚaca'no' icuaiconni anuli cal xans titalecuf'ma Jairo. Iƚque Jairo ipenic' lajut'ƚ pe lafoƚyumma lan xanuc'. Timi: ―Ƚo'hua joupa imanapa. ¿Te cofxoc'icoya Ƚomxi? ");
INSERT INTO chdNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús icuej'ma locuapa cal xans, italai'e'e'ma, timi Jairo: ―Aimoxhueƚmot'ƚe'ma. Ma le'a aƚ'huaiyijnla'. Ƚo'hua tixaƚcona'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Licuaitsa lejut'ƚ Jairo, Jesús i'huijf'epola' Pedro, Jacobo y Juan, jouc'a qui'ailli' qui'máma' ƚahuats'. Itsuflai'me pe lopa'a ƚahuats'. Aiquepi'ila' lane ocuenaye xanuc' mitsuflaiyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jahuay lan xanuc' nomana' jiƚpe lajut'ƚ tihuotsoyi, tijolijyi, tija'ayi, joupa imanapa ƚahuats'. Jesús timila': ―Aimoƚjolijcona'me. Ƚahuats' aiquimac'. Ma le'a tixmay. ");
INSERT INTO chdNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iƚne ixoco'me, iƚsina' joupa imanapa ƚahuats'. ");
INSERT INTO chdNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús i'noƚ'e'e'ma limane ƚahuats', ijoc'i'ma, timi: ―Mahuats', totsahuenni. ");
INSERT INTO chdNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Imaf'ina'ma, aiquicoƚ'ma itsahuenni, ecax'ma. Jesús timila': ―Toƚtes'miƚe. ");
INSERT INTO chdNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Qui'ailli' qui'máma' tipailo liƚpicuejma', ticuayi: “¿Te aƚinca imaf'inapa ƚaƚ'hua?” Jesús ixc'ai'i'mola': ―Aimoluyout'ƚe'me. Nij naitsi mi'iya quixina'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús ijoc'i'mola' limbamaj coquexi' ts'ilihuequi. Epi'i'mola' liƚmane tipa'atsa lontahue, jouc'a tixaƚ'metsa lafcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Umme'mola' ƚiƚeloƚya' tuya'atsa te ts'i'ic' micuxe ȽanDios iƚque cal Rey. Jouc'a tixaƚ'mentsola' lafcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Timila': ―Tonƚeƚe. Nij tintsi moƚtai'me lane. Jouc'a loƚpaluc, loƚponta, ƚonla'i, loƚtomí, ocuena' coƚtsamalo aimoƚtai'me. ");
INSERT INTO chdNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Toƚcuaitsa anuli liƚya' ja'ni tepi'intsolhuo' lajut'ƚ pe loƚmanc'eyacu, moƚmana' liƚya' jiƚpiya lajut'ƚ toƚmajnle. ");
INSERT INTO chdNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Anuli liƚya' ja'ni lan xanuc' aimepenufilhuo' tolipalunca, tolunafle loƚ'mitsi', aimoƚtai'me loƚ'mitsi' ni ƚepi camats' jiƚpe liƚya'. Ti'iƚa' quiƚsina' ma' iƚne quiƚtuca' ti'najtse'me liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Limbamaj coquexi' ts'ilihuequi ipalunca. I'huaf'coƚai'me iƚya' iƚya', tuya'ayi Lataiqui', iƚe loya'apa al c'a lixpic'epa ȽanDios. Jahuay ƚiƚeloƚya' ixaƚ'mentsola' lafcualƚay. ");
INSERT INTO chdNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Cal rey Herodes icuej'ma jahuay lo'epa Jesús iƚpe ƚamats'. Ixhueƚco'ma. Ticua: “¿Naitsi lo'epa toƚta'a?” Timana lan xanuc' nocuapá: “Juan Bautista imaf'inapa, ipanamma pe lomana' limanapola'”. ");
INSERT INTO chdNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ocuenaye ticuayi: “Imaxcainata cal profeta Elías”. Locuenaye ticuayi: “Anuli iƚne lam profeta li'ipa lomana' fa'a li'a ƚamats', itsiya imaf'inapa, icuaina'ma”. ");
INSERT INTO chdNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes timiyoxi: “Iya' joupa aicuxepa etec'empá ƚejoc' Juan. Itsiya cacueca tinesconni anuli cal xans acueca' lo'epa. ¿Naitsi iƚque xans? ¿Te co'iya caxinya?” Ehue'ma te co'iya mixinya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Limbamaj coquexi' lummepola' Jesús ipailinamma, icuainatsa pe lopa'a Jesús. U'i'me jahuay li'epa. Jesús ileco'mola' iye'me quiƚtuca', ticuaita anuli liƚya' cuftine Betsaida. ");
INSERT INTO chdNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lan xanuc' icuej'me pe lotseyacu, iyenc'ot'ƚe'me, ihuej'me Jesús. Icuaitsa pe lopa'a Jesús. Iƚque epenuf'mola'. U'i'mola' te ts'i'ic' micuxe ȽanDios. Laxtafpola' nahuepá tixaƚcontsola', ixaƚ'mena'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","If'acoƚaipa iƚoc'oƚai'me limbamaj coquexi', timiyi: ―Tommetsola' lan xanuc'. Tiyenƚe ƚiƚeloƚya', jouc'a calx'huiyaƚma' lomana' huejnca, tehueta ƚotejacu. Ma fa'a ailopa'a cotejacu. ");
INSERT INTO chdNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Italai'e'e'mola', timila': ―Imanc' toƚtes'mitsola'. Iƚniya italai'e'e'me, timiyi: ―Aicaƚ'hueca. Tipa'a le'a amaque' la'í y oquexi' latuye. ¿Te aga ƚepá illanc' aƚ'nata ƚotejacu jahuay iƚne lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jiƚpe timana' to amaquej mil lan xanuc'. (Jouc'a timana' lacaƚ'no' la'uhuay.) Jesús timila' ts'ilihuequi: ―Toƚmitsola' ticutsoƚaiƚe oque' oque' nuxans quimbama'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Toƚta'a li'epa to licuxe'empola'. Jahuay icutsoƚai'me. ");
INSERT INTO chdNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús epef'mola' lam maque' la'í, loquexi' latuye, ehuenaf'ma lema'a, ix'najtsi'i'ma ȽanDios, ixquenuf'mola'. Epi'i'mola' ts'ilihuequi tica'nentsola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jahuay itetso'me, ixhuaitsola'. Ts'ilihuequi efot'ƚepá lan hualcay ca'i lipanecomma. Imantsola' imbamaj coque' lan tsiquihuit'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Anuli litine Jesús tipalaic'o ȽanDios. Jiƚpiya timana' ts'ilihuequi quiƚtuca'. Timila': ―¿Te cocuapa lan xanuc'? ¿Naitsi iya'? ");
INSERT INTO chdNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Italai'e'e'me, timiyi: ―Timana' nocuapá ima' umJuan Bautista. Ocuenaye ticuayi ima' un'Elías. Locuenaye ticuayi ima' umprofeta. Ticuayi li'ipa opajmpa, imanapo', itsiya omaf'inapa, ocuaina'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Timila': ―Imanc', ¿te coƚcuapa? ¿Naitsi iya'? Pedro italai'e'e'ma, timi: ―Ima' unCristo, ma Ƚi'huijf'epo' ȽanDios, ummepo'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús ixc'ai'i'mola', timila': ―Aimoluyout'ƚe'me. Nij naitsi mi'iya quixina'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cateƚco'ma juaiconapa. Lan tsilaj xanuc' noxpijpá lataiqui', jouc'a lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, alatets'i'ma nulemma. Aƚma'a'ma. Afane' quitine camaf'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ipalaic'o'mola' jahuay lan xanuc', timila': ―Ja'ni anuli cal xans lihuej'ma, iƚque aimi'iya micuxeyacoxi quituca'. Iya' lapaƚts'inginna lancruz. Iƚque ƚalihuejya itine itine titaiƚa' lencruz jouc'a. Tixpic'eƚa' titeƚco'ma. Toƚta'a ƚinca lihuej'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Naitsi aimicua mitelcoya, iƚque no'epoxi cuenna juaiconapa, tecani'e'moxi. Naitsi nocuyacoxi lateƚcoya, iƚque ƚalihuequi tama tima'anƚe, tunƚu'e'moxi. ");
INSERT INTO chdNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cal xans nolijya jahuay lopa'a fa'a li'a ƚamats', ja'ni tecani'e'moxi, ¿te quipenic' iƚe lulijpa? ");
INSERT INTO chdNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","’Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a, cacuaicoconno. Iƚe litine aƚsim'ma ninCueca', aƚsim'ma aƚ'onƚcota to ȽanDios cai'Ailli', lapalc'o'i'ma lam paxi lapaluc' quema'a. Anuli cal xans ja'ni titaiƚa' calaic'ata, toƚta'a aicalihuequi, iƚe litine cacuaicohuananni fa'a li'a ƚamats' iya' jouc'a aicapenufya iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iya' camilhuo' al ƚinca: Fa'a timana' lan xanuc' tixim'me, timetsaico'me lo'eya ȽanDios micuxe li'a ƚamats'. Toƚta'a tixim'me ai'a tima'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Lijoupa luyaipa to apaico quitiné Jesús tipalaic'ota ȽanDios jiƚpe ƚijuala. Ileco'mola' Pedro, Juan, Jacobo, if'ajli'me. ");
INSERT INTO chdNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mipalaic'o ȽanDios ipaico'ma li'a. Lipijahua' i'i'ma afujca afujca, tunts'iflay. ");
INSERT INTO chdNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Icuaitsa oquexi' lan xanuc' ipalaic'o'me Jesús. Anuli iƚne Moisés, ƚocuena Elías. ");
INSERT INTO chdNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iƚniya tulif'ela' al cuecaj quipepalc'o' ȽanDios. Iƚne jouc'a Jesús tipalaicoyi lo'iya ticuaitsi Jesús Jerusalén. Jiƚpe tipo'no'ma li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro jouc'a liƚejmale tama itafquengcola' cahuí, aiquiƚsmaic'. Ehuelojm'me Jesús, ixim'me ipaicopa li'a, lipijahua' tunts'iflay. Ixim'me oquexi' lan xanuc' tecaxoƚanna pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Miƚolijnayi loquexi' lan xanuc' Pedro ipalaic'o'ma Jesús, timi: ―Momxi, ma jifa'a aƚmanecu. Toƚta'a luyalaico'me al c'a. Illanc' aƚƚanc'e'me afane' lihuoxqui, anuli ima', ocuena Moisés, locuena Elías. Pedro ma le'a tipalay, aiquixina' lonespa. ");
INSERT INTO chdNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mipalay Pedro imunni ƚummahuay. Ipoxc'i'mola'. Ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jiƚpe ƚummahuay icuej'me tipalay, timila': ―Iƚca'a ƚai'Hua, ƚai'Huijf'epa. ¡Toƚquimf'eƚe! ");
INSERT INTO chdNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lijoupa limipola' toƚta'a, ts'ilihuequi Jesús ixim'me iƚque quituca'. Moisés y Elías ailomana'. Iƚniya ƚitiné lam fantsi ts'ilihuequi Jesús i'ipola' ch'ix. Aiquiluya'e' iƚe liximpa jiƚpe ƚijuala. ");
INSERT INTO chdNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lihuequi litine imulnanca ƚijuala. Axpela' lan xanuc' icuai'me tehueyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Anuli iƚniya ija'a'ma, ipalaic'o'ma Jesús, timi: ―Momxi, caxahue'ehuo' toxinƚa' ƚai'hua. Iƚque cal nuli cai'hua. ");
INSERT INTO chdNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anuli ƚonta'a ti'noƚi. Ƚai'hua tija'e'. Ƚonta'a tife'ne ujfxi. Tipamma ƚitsulu lico. Ƚonta'a tixcai'e ƚai'hua, afule mux'masya. ");
INSERT INTO chdNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aixahue'epola' lihuejhuo' tipa'aƚe ƚonta'a, aiqui'ic' quilipa'e. ");
INSERT INTO chdNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús italai'e'e'ma, ticua: ―¡Ay imanc'! Aimoƚ'huaiyijnyi ȽanDios, a'ij ƚijca loƚpicuejma'. Coƚa' aicapajncona'ma pe loƚmana'. ¿Te iya' ti'hua caxnet'ƚ'ma? Timi cal xans: ―Aƚƚec'metsi ƚo'hua. ");
INSERT INTO chdNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ai'a ticuaita ƚamijcano ƚonta'a eca'ni'ma ƚamats', ife'ne'ma ujfxi. Jesús itale'ma ƚonta'a, ixaƚ'mena'ma ƚamijcano, exat'ƚina'ma qui'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nahuelojmpá toƚta'a li'ipa jahuay tipailo liƚpicuejma'. Iximpá acueca' lo'epa ȽanDios. Ixpailij'mola'. Mi'nujuaisyi lan xanuc' jahuay lo'epa Jesús ti'hua tipailo liƚpicuejma'. Jesús ipalaic'o'mola' ts'ilihuequi, timila': ");
INSERT INTO chdNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Imanc' toƚpo'noƚe cuenna laifmipolhuo'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aƚcum'ma ticuaita quiƚmane lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ts'ilihuequi aiquiƚcueca limipola' Jesús. Aiquepalc'o'ila' liƚpicuejma'. Aimi'iya mepenufyacu iƚe lataiqui'. Aiquilicuis'e Jesús. Ixpailij'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ipalaic'o'moƚtsi, icuis'e'moƚtsi: “¿Illanc', naitsi no'iya xonca cal cueca'?” ");
INSERT INTO chdNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús imetsaicola' liƚpicuejma', exat'ƚu'ma anuli ƚacamijcano, ecaxijm'moxi. ");
INSERT INTO chdNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Timila' ts'ilihuequi: ―Cal xans nocuapa: “Jesús ti'ela' capic'a la'uhuay”, tijouƚa' tepenufi ƚacamijcano, jouc'a iya' lapenufi. Cal xans pe ƚalapenufpa ma anuli lapenufinga' Ƚalummepa. Iya' camilhuo': Ja'ni anuli imanc' ti'exoxi xonca aca'hua, iƚque xonca acueca'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan ipalaic'o'ma Jesús, timi: ―Momxi, aƚsimpá anuli cal xans ticuaj'mi lopuftine, tipa'ala' lontahue. Illanc' aƚmipá: “Ailopa'a lane. Aimo'e'ma toƚta'a. Ima' a'i caƚejmale.” ");
INSERT INTO chdNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús timila': ―Aimoƚcuanac'e'me. Ja'ni aimixtuc'olhuo' tocomma to onƚejmale. ");
INSERT INTO chdNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Licuaico'ma litine tepenufinnata Jesús pu'hua lema'a, ixpic'epa nulemma ti'huanƚa' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Umme'mola' ts'ilihuequi tuya'atsa ƚiƚeloƚya', tu'iyaletsa Jesús ticuaihuo. Iƚne lummepola' icuaitsa liƚpiƚya' lun samaritano. Tehueyi lajut'ƚ pe lopanc'eya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lan xanuc' jiƚpe liƚya' ticuayi: “Iƚque Jesús ti'hua'ma Jerusalén. Aimalapenufyacu.” (Iƚniya iƚpilaic' al cuecaj xoute' lopa'a Jerusalén.) ");
INSERT INTO chdNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lixim'me liƚ'ejma' iƚne lan xanuc' Jacobo y Juan icuis'e'me Jesús, timiyi: ―Maƚpoujna, ¿te ts'opic'a? ¿Te aga aƚjoc'iƚe ȽanDios, tummeƚa' ƚunga, tipitsola' nulemma iƚne lan xanuc'? Toƚta'a li'epa cal profeta Elías. ");
INSERT INTO chdNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús ipai'e'moxi, itale'mola', timila': ―Imanc' aicoƚsina' te ts'i'ic' loƚcuapa. Tocomma tunlihuejyi ocuena, a'i iya'. Imanc' ituca' loƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aicuaicoco'ma fa'a li'a ƚamats' cunƚu'etsola' lan xanuc', a'i cajac'eyacola'. Lijou'ma iye'me ocuena quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Miyeyi lane icuaitsi anuli cal xans ipalaic'o'ma Jesús, timi: ―Ima' ni petsi loftseya iya' jouc'a quihuej'mo'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús italai'e'e'ma, timi: ―Lant'ƚeyá tipa'a ƚiƚpunts'ejay, lacaƚ'hui naiyulpá lema'a tipa'a liƚpuxiƚ'na'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iya' ailopa'a caifxmai'eya. ");
INSERT INTO chdNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús ipalaic'o'ma ocuena xans, timi: ―Ima' lihuejla'. Cal xans timi: ―Maipoujna, lapi'iƚa' lane, ca'huaƚa' lainejut'ƚ. Mipa'a cai'ailli' capajnta jiƚpe. Tijouƚa timanƚa', caminna, quihuejna'mo'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús timi: ―A'i. Lomapola' ti'i'ma temiƚe liƚf'as lomapola'. Ima' to'huaƚa', toya'atsi te ts'i'ic' micuxe ȽanDios cal Rey. ");
INSERT INTO chdNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ocuena xans ipalaic'o'ma Jesús, timi: ―Maipoujna, quihuej'mo'. Ate'a lapi'iƚa' lane ai'huanapa caxc'ai'itola' iƚne nomana' lainejut'ƚ, tijouƚa' capaiconahuo, quihuej'mo'. ");
INSERT INTO chdNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús timi: ―Cal xans ƚipangopa tepa'ma ƚemats' ja'ni tipaicof'iƚa' tehuelojnla' lixpula', aimi'iya mi'eya lipenic' ȽanDios, iƚque cal Cuecaj Rey. ");
INSERT INTO chdNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lijou'ma ƚaƚPoujna Jesús i'huijf'e'mola' ocuenaye ts'ilihuequi. Iƚniya lam fanej nuxans quimbama'. Umme'mola' tiyeƚe oquexi' oquexi' ƚiƚeloƚya'. Tiyef'coƚaitsa ate'a, tijouƚa' tuyaicota Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Timila': ―Itsiya lixhuaita litine cafot'ƚeya. Tipa'a acueca' lanic', ahuata lan xanuc' nafot'ƚeyacu. Toƚsahue'eƚe ƚaPoujna camats' tummetsola' no'eyacu canic' petsi ƚipammaita ƚemats'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Imanc' laixanuc' ti'onƚcospolhuo' to lam mot'ƚ, iƚne aimi'iya mipa'neyacoƚtsi. Iya' cummelhuo' tonƚeƚe pe lomana' lan xanuc' lo'onƚcospola' to lam lobo, iƚne oyac'la quinneja. ");
INSERT INTO chdNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aimoƚtai'me loƚponta. Jouc'a aimoƚtai'me loƚmorral, ni ƚoƚc'ejí. Aimoƚpalaic'otola' lan xanuc' loƚtalecufyacola' lane. ");
INSERT INTO chdNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Lajut'ƚ pe loƚtsuflaiyacu toƚmitsola': “ȽanDios tipaxnetsolhuo' imanc' noƚmana' fa'a lajut'ƚ”. ");
INSERT INTO chdNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ja'ni tipa'a anuli cal c'a xans jiƚpe lajut'ƚ, ȽanDios tipaxne'ma. Ja'ni ailopa'a, ȽanDios tipaxne'molhuo' ma le'a imanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Petsi lapenufinyacolhuo' maƚpiya tolunxac'eta. Ƚapi'inyacolhuo' toƚteta, toƚsnata. Aimoƚcua'me: “Aimi'iya maƚtejacu. Ailopa'a caƚtomí.” Cal xans no'epa lanic' tipa'a lapi'inyacu. Imanc' toƚ'eyi lipenic' ȽanDios, jouc'a tipa'a lapi'inyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Ƚiƚeloƚya' pe loƚtsuflaiyacu, ja'ni lan xanuc' tepenuftsolhuo' toƚtetsa lapi'inyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Toƚxaƚ'metsola' lafcualƚay. Toƚmitola' lan xanuc': “Ma fa'a pe loƚmana' icuai'ma ȽanDios cal Rey”. ");
INSERT INTO chdNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","’Ƚiƚeloƚya' pe loƚtsuflaiyacu ja'ni aimepenufinnilhuo', toluyalaicotsa ƚaneya iƚpe liƚya', monƚeyi toluya'ata: ");
INSERT INTO chdNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Illanc' ni ƚepi camats' lotaƚijmpa laƚ'mitsi' fa'a loƚpiƚya' aimaƚtaiyacu. Toƚsinƚe, lunafnayi, tipanenni fa'a. Tama aluyalai'me illanc', ti'iƚa' coƚsina' imanc': ȽanDios cal Rey icuai'ma fa'a pe loƚmana'.” ");
INSERT INTO chdNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iya' camilhuo': Al Cuecaj Quitine locuaicoya tama ȽanDios titeƚ'mi'mola' lun Sodoma, xonca acueca' titeƚ'mi'mola' lan xanuc' iƚpe liƚya' petsi aimepenufinnilhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Ima' miƚya' Corazín, acueca' lofteƚcoya. Ima' miƚya' Betsaida acueca' lofteƚcoya jouc'a. Jiƚne loƚxanuc' joupa iximpá al cueca' lo'epa ȽanDios. Aiquiƚsuej'meya. Luyaipa quitine Tiro y Sidón coƚa' ixim'me toƚta'a, lan xanuc' limajmpá coƚa' tixhuej'menacu, coƚa' ticutshuoƚai'me tixhueƚco'me, tipo'no'me liƚpijahua' ayolca, timets'ƚi'me capi' liƚ'a, timujco'moƚtsi ixhuej'menamma liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Al Cuecaj Quitine locuaicoya tama ȽanDios titeƚ'mi'mola' lun Tiro y lun Sidón, xonca acueca' titeƚ'mi'molhuo' imanc' unc'iƚeloƚya' Corazín y Betsaida jouc'a loƚxanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ima' miƚya' Capernaum, ¿te to'nof'e'moxi xonca al toncay? ¿Te ti'onƚto' to ȽanDios? A'i. Ti'oc'em'mo'. Toxinnoxi jiƚpe al muf. ");
INSERT INTO chdNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Imanc' ts'alihuequi, iya' camilhuo': Ja'ni anuli cal xans tiquimf'elhuo', iƚque cal xans aƚquimf'enga' iya', imanc'. Ja'ni anuli cal xans tetets'ilhuo', iƚque cal xans latets'inga' iya', imanc'. Ja'ni anuli cal xans latets'i iya', iƚque cal xans latets'inga' iya' y ȽanDios Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ipalunca lam fanej nuxans quimbamaj ts'ilihuequi Jesús, uya'ahuo'me. Lijou'ma ipailinamma. Licuainatsa pe lopa'a Jesús tixoqui quileta, timiyi: ―Maƚ'ailli', aƚcuaj'mihuo'me lopuftine toƚta'a lontahue lihuejcoponga', ipalumma. ");
INSERT INTO chdNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús timila': ―Ƚonta'a Satanás itsiya ailopa'a pu'hua lema'a. Joupa ecangimpa. Iya' aiximpa lecangemma to lixcuaflay. ");
INSERT INTO chdNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aƚcuec'eƚa' imanc'. Iya' nepi'ipolhuo' loƚmane, ti'i'ma toƚ'huailets'uf'mola' lainofat'ƚ jouc'a linnaispó. Tama icueya quimane Satanás aimi'iya mulijyacolhuo' imanc'. Ailopa'a co'eyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Imanc' tixoqui cunlata lipalunca lontahue loƚcuxe'e'mola'. Itsiya camilhuo': Xonca tixojla' cunlata, ȽanDios timetsaicolhuo'. Ƚoƚpuftine iniƚingiya jiƚpe liniƚingiya ƚiƚpuftine lixanuc' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Maƚpe al 'hora cal Espíritu Santo juaiconapa ixoc'i'ma queta Jesús. Iƚque ipalaic'o'ma ȽanDios, timi: ―Mai'Ailli', ima' maPoujna lema'a y li'a ƚamats'. Cax'najtsi'ihuo' lof'epa. Tomuc'ila' laixanuc', iƚne lo'onƚcospola' to la'uhuay. Mepi'ipola' liƚpicuejma' ticuec'eƚe laitaiqui'. Lan xanuc' ts'iƚsina', xonca nixhuepá, aicomepi'ila' toƚta'a liƚpicuejma'. Iƚne iximpá ipime laitaiqui', to emiya. Aimi'i muhuaƚcufyi. Aƚinca mai'Ailli', toƚta'a loxpic'epa, toƚiya latenƚcocopo' ima'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesús ti'hua tipalay, ticua: ―Cai'Ailli' jahuay lapi'ipa cacuxe'etsola'. Iya' i'Hua ȽanDios, lan xanuc' aimi'iya maƚsingufya iya' laipicuejma'. Ma le'a cai'Ailli' aƚsingufi. Lan xanuc' jouc'a aimi'iya mixingufyacu cai'Ailli' lipicuejma'. Ma le'a iya' ƚi'Hua, ƚinca aixingufi. ’Iya' caxpic'e naiƚne laifmuc'iyacola', iƚne camuc'ila' te ts'i'ic' lipicuejma' cai'Ailli'. Iƚne ƚinca timetsaicoyi cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lijou'ma, Jesús ipalaic'o'mola' ts'ilihuequi quiƚtuca', timila': ―Imanc' aƚinca tuluyalaicoyi al c'a, tolahuelojnyi lo'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iya' camilhuo': Luyaipa quitine axpela' lan xanuc' tijanajyi coƚa' tixinƚe loƚsimpa itsiya imanc'. Iƚniya lam profeta jouc'a lan rey aiquixim'me. Ijanaj'me coƚa' tiquimf'eƚe loƚquimf'epa itsiya imanc'. Aicu'innila' jiƚiya lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lijou'ma itsahuenni anuli ƚomxi nomuc'iyalepa locuxepa ȽanDios, tehuai'ma Jesús. Icuis'e'ma, timi: ―Momxi, aipic'a culijla' al ts'e laipitine aimijouya. ¿Te caif'eya? ");
INSERT INTO chdNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús timi: ―Lataiqui' Liniƚingiya loya'apa locuxepa ȽanDios, ¿te cocuapa? ");
INSERT INTO chdNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ƚomxi italai'e'e'ma, timi: ―“To'nujuaisla' ȽanDios ƚoPoujna, iƚque omenDios. Taihuejla' jahuay ƚomunxajma', jahuay ƚo'alma, jahuay lopujfxi, jahuay lopicuejma'. Ima' to'eyoxi capic'a, ma toƚta'a to'eƚa' capic'a ƚof'as xans, naitsi ƚoftalecufya.” ");
INSERT INTO chdNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús timi: ―Al c'a aƚtalai'e'epa. Toƚta'a to'e'ma, tapenuf'ma lopitine. ");
INSERT INTO chdNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ƚomxi timiyoxi: “Tixinƚa' Jesús iya' aipicuejma'”. Icuis'econa'ma Jesús, timi: ―¿Naitsi xans caif'eya capic'a? ");
INSERT INTO chdNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús italai'e'e'ma, timi: ―Anuli cal xans ipanni liƚya' Jerusalén, imunni lane Jericó. Mi'hua lane lan namats' linma'ahuale i'noƚ'me, umets'ai'me, untaf'me, exic'e'e'me lipijahua', ipo'no'me tocomma joupa tima'ma. Inulna'me. ");
INSERT INTO chdNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jiƚpe al 'hora anuli ƚa'ailli' ti'hua maƚpe lane. Lixim'ma ƚixcaiyoƚpa cal xans aiquicoƚ'ma, uyai'ma locuena liju' lane. ");
INSERT INTO chdNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ma' anuli i'e'ma ƚocuena cal xans notoc'ipa ca'ailli'. Icuaitsi huejnca ƚixcaiyoƚpa cal xans. Lixim'ma aiquicoƚ'ma, uyai'ma locuena liju' lane. ");
INSERT INTO chdNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’Anuli cal xans ƚas Samaria jouc'a ti'hua maƚpe lane. Icuaitsi huejnca ƚixcaiyoƚpa cal xans. Lixim'ma, ixim'ma cuanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iƚoc'huai'ma pe lopa'a cal xans, ic'ef'i'ma laceite jouc'a al vino iƚe lehui. Ifi'e'ma lehui. Lijou'ma ipulaf'ma enaf'i'ma ƚiburro, ileco'ma anuli lajut'ƚ pe lonxac'eyoyacu. Jiƚpe i'e'ma cuenna. ");
INSERT INTO chdNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lihuequi litine ai'a tuyai'ma, cal xans ipa'a'ma liponta oque' al tomí plata, (lolijpa cal xans oquej quitine), epi'i'ma ƚipoujna cajut'ƚ, timi: “Iƚca'a cal xans to'e'ma cuenna. Ja'ni aimixhuaicospa iƚta'a al tomí laifnepi'ipo', ima' taipa'a'ma lotomí, to'naco'ma lahue'eya. Aimoxhueƚmot'ƚe'ma. Cacuaiyoconno, ca'najtse'ena'mo'.” ");
INSERT INTO chdNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","’Afantsi lan xanuc' niximpá iƚque ƚixcaiyoƚpa cal xans. ¿Naitsi nihuejcopa iƚe lataiqui' loya'apa: “To'eƚa' capic'a ƚof'as xans, naitsi ƚoftalecufya”? ");
INSERT INTO chdNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ƚomxi italai'e'e'ma, timi: ―Iƚque ƚiximpa cuanuc'. Jesús timi: ―Ne'. Ima' to'huaƚa', to'etsi ma to li'epa iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Miyeyi lane Jerusalén Jesús jouc'a ts'ilihuequi icuaitsa anuli laca'hua quiƚya'. Jiƚpe tipa'a anuli ƚaca'no' cuftine aMarta. Marta epenuf'ma lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tipa'a ƚipima caca'no' cuftine aMaría. María icutsingai'ma li'mitsi' Jesús. Tiquimf'e litaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta tipa'a acueca' lipenic'. Tihuejnyoxi. Tixhueƚmot'ƚe juaiconapa. Iƚoc'huai'ma pe lopa'a Jesús. Ipalaic'o'ma, timi: ―Maipoujna, ¿te aicoxina' lo'ipa fa'a? Ƚaipepo aƚpo'nohua. Iya' ca'ay jahuay lanic'. Tomiƚa': “Totoc'itsi ƚopima”. ");
INSERT INTO chdNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ȽaƚPoujna Jesús italai'e'e'ma, timi: ―Ima' cumMarta, acueca' lof'epa. Toxhueƚma juaiconapa, taihuejnyoxi. ");
INSERT INTO chdNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ticuicomma ma le'a anuli lof'eya. María i'huijf'epa xonca al c'a. Aimi'iya mixic'enyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anuli litine Jesús mipalaic'o ȽanDios jiƚpe timana' ts'ilihuequi. Jesús lijou'ma lipalaic'o'ma ȽanDios anuli iƚne ts'ilihuequi ipalaic'o'ma, timi: ―Mai'ailli', Juan imuc'i'mola' ts'ilihuequi te ts'i'ic' mipalaic'oyacu ȽanDios. Ima' aƚmuc'itsonga' jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús timila': ―Moƚpalaic'oyi ȽanDios toƚmi'me: Ima' maƚ'Ailli' cofpa'a lema'a. Timetsaicontso' apaxi loPuftine. Ticuaitsi litine petsi jahuay lan xanuc' timetsaicotso' ima' iƚRey. Pu'hua lema'a jahuay tihuejcohuo', toƚta'a tihuejcotso' fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ƚaƚtepa itine itine, lapi'itsonga' itsiya. ");
INSERT INTO chdNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Illanc' joupa limenc'e'ecopola' iƚne laƚ'e'eponga' lixcay. Ima' jouc'a alimenc'e'ecotsonga' petsi lalimenajponga'. Aimaƚƚeco'monga' lalahuaiyoyaconga'. Ja'ni tiƚoc'huai'ma laƚmana' ƚixcay xans, ima' lunƚu'etsonga'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jouc'a timila': ―Anuli imanc' ja'ni nolojmay quipuqui' ƚiƚejmale ticuaitsi lejut'ƚ, timitsi: “Maipima, lapi'iƚa' afane' caine'í. ");
INSERT INTO chdNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Anuli ƚalimetsaicoyoƚtsi icuai'ma lainejut'ƚ. Iƚque in'huaya xans. Iya' ailopa'a caifnepi'iya.” ");
INSERT INTO chdNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iƚque ƚonanc'ompa nopa'a lejut'ƚ, ¿te timi'ma: “Amalapi'i'ma coyac'. Aimaƚtsa'huot'ƚe'ma. Joupa aix'nifconapoxi. Lainaxque' joupa lunahuoƚainapá. Aimi'iya catsahueya. Aimi'iya capi'iyaco'”? ");
INSERT INTO chdNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iya' camilhuo': Tama inespa: “¿Te caif'eya? Ƚinca aƚejmale. Aicatsahueya, aicapi'iya”, ja'ni ti'hua tixahue'e, ƚinca titsahuehuo, tepi'i'ma jahuay loxahue'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Iya' camilhuo': Ti'hua toƚsa'hueƚe, tijouƚa' tepi'im'molhuo'. Ti'hua tolahueƚe, tijouƚa' toƚsim'me. Ti'hua tolumf'asle al puerta, tijouƚa' texi'em'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lan xanuc' noxa'huepá tepi'inni, jouc'a nahuepá tixim'me, jouc'a nomf'axpá texi'em'me. ");
INSERT INTO chdNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Imanc' unc'a'aillí, ja'ni loƚnaxque' tixahue'etsolhuo' quile'i, ¿te tolapi'i'mola' ƚapic? A'i. O ja'ni tixahue'etsolhuo' ƚatu, ¿te tolapi'i'mola' ƚainofaƚ? A'i. ");
INSERT INTO chdNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ja'ni tixahue'etsolhuo' ƚapi'e, ¿te tolapi'i'mola' ƚinnaispo? A'i. Aimi'iya monƚ'eyacu toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","’Imanc' tama oƚtaic' loƚjunac', tipa'a loƚpicuejma' tolapi'ila' al c'a loƚnaxque'. Conƚ'Ailli' Nopa'a lema'a, xonca acueca' lipicuejma'. Iƚquiya ƚinca tepi'i'molhuo' cal Espíritu Santo ja'ni toƚsahue'eƚe. ");
INSERT INTO chdNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús tipa'e ƚonta'a ƚitsufaipa cal xans. Ƚonta'a mi'nico, cal xans aimipalay. Lipanni ƚonta'a cal xans ipalaina'ma. Lan xanuc' lefot'ƚepoƚtsi jiƚpiya ticuayi: ―¡Xinƚa'! Acueca' lo'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Timana' nocuapá: ―A'i. Beelzebú, ƚincuxepa contahue, iƚque ƚepi'ipa limane, toƚta'a tipa'ala' lontahue. ");
INSERT INTO chdNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ocuenaye ehuai'me Jesús, ixa'hue'me timuc'itsola' al cueca', to lo'epa ȽanDios Nopa'a lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús ixina' te ts'i'ic' minesyi jiƚpe liƚpicuejma', timila': ―Ja'ni tenajtsoƚtsi lan xanuc' anuli al cuecaj nación, jiƚiya al nación tejac'ma. Jouc'a ja'ni tenajtsoƚtsi lan xanuc' nomana' anuli lajut'ƚ, iƚniya lan xanuc' aimipajnya liƚpujfxi, tijou'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Imanc' toƚcuayi Beelzebú, iƚque Satanás, lapi'ipa laimane, toƚta'a quipa'ala' lontahue. Iya' cacua: Ja'ni ƚonta'a Satanás tipa'ala' lipontahue joupa enajpoxi Satanás. Iƚque y ts'ilihuequi a'ij nuli liƚpicuejma'. Ja'ni toƚta'a li'ipa, ¿te ti'hua ticuxe Satanás? A'i. Aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iya', ja'ni Beelzebú lalapi'ipa laimane, ja'ni toƚta'a quipa'ala' lontahue, loƚxanuc' naipa'apá contahue, ¿naitsi nepi'ipola' liƚmane iƚniya? Maƚniya timuj'me imanc' timenaquilhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","O ¿te coƚcuayacu ja'ni ȽanDios lalapi'ipa laimane quipa'atsola' lontahue? Ja'ni toƚta'a lo'ipa, ƚinca jifa'a tipa'a ȽanDios cal Rey. Iƚque ticuxe. ");
INSERT INTO chdNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Anuli cal xans ts'ipujfxi, mipa'a lofulecopa ticuanajco'ma lejut'ƚ jouc'a ƚi'hueca. Ailopa'a tintsi. ");
INSERT INTO chdNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ticua: “Tipa'a laifulecopa. Aimi'iya malulijya.” Ticuaitsi ƚocuena xonca ts'ipujfxi, tiƚonc'eta lofulecopa, tulijnata. Tica'neta ƚi'huexi cal xans. ");
INSERT INTO chdNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Naitsi aicalihuequi aƚ'ay laic'. Naitsi aimefot'ƚela' lan xanuc' to laif'epa, iƚque tica'nennala'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ƚonta'a lipanni licuerpo cal xans ti'hualeco'ma ƚijuƚ camats' pe ailopa'a caja'. Tehue petsi conxac'eya. Aimixina. Ticua: “Aipainamma. Ai'huanapa lainejut'ƚ pe lainipayomma.” ");
INSERT INTO chdNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Licuaitsi jiƚpiya tixim'ma itaf'uyiya, i'huáqui al c'a. ");
INSERT INTO chdNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lixim'ma toƚta'a ti'huacona'ma, tilecotola' acaitsi lontahue xonca ixcay. Titsuflai'me jiƚpiya licuerpo cal xans, timajm'me. Toƚta'a iƚque cal xans xonca acueca' a'ijc'a loyaicoya. Al te'a le'a anuli ƚonta'a i'hueca, tijouƚa' ti'i'mola' apaico lontahue. ");
INSERT INTO chdNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mu'ila' toƚta'a Jesús lan xanuc' lafoƚyomma jiƚpiya, anuli ƚaca'no' ipalai'ma ujfxi, timi: ―Joupa ipaxnempa co'máma', iƚque ipo'nopo', itoc'epo'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús italai'e'e'ma: ―Ja'ni tiquimf'eyi litaiqui' ȽanDios jouc'a tihuejcoyi, xonca ipaxnempá iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lan xanuc' efot'ƚepoƚtsi pe lopa'a Jesús. Ipango'ma u'i'mola', timila': ―Lan xanuc' nomana' itsiya litine ixcay liƚpicuejma'. Iƚpic'a ȽanDios timuc'itsola' al cueca'. Iya' cacua: Aimimuc'iyacola'. To li'ipa cal profeta Jonás luyaipa quitine ma toƚta'a aƚ'i'ma iya'. Iƚe ƚinca toƚsim'me, timuc'i'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iƚe li'ipa Jonás imuj'ma al cueca' lo'epa ȽanDios. Toƚta'a ixim'me lan xanuc' nimajmpá liƚya' Nínive. Iƚe laƚ'iya iya' ma' anuli timuc'i'mola' lan xanuc' nomana' itsiya al cueca' lo'epa ȽanDios. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","’Ticuaitsi al Cuecaj Quitine imanc' tolacaxingoƚaita ȽanDios cal Cuecaj Juez. Ƚaca'no' nicuxepola' lan xanuc' nomana' anuli ƚamats' juaiconapa aculi' al 'ocay jouc'a tecaxhuaita. Iƚque ƚaca'no' xonca al c'a li'ejma', toƚiya ticuftolhuo'. I'hua'ma juaiconapa itoqui lane. Icuaitsi pe lotseya. Jiƚpe icuej'ma locuapa cal rey Salomón, iƚque acueca' lipicuejma'. Itsiya imanc' tama toƚquimf'eyi anuli xonca acueca', tolatets'iyi. ");
INSERT INTO chdNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","’Al Cuecaj Quitine tolacaxingoƚaita ȽanDios cal Cuecaj Juez. Jouc'a tecaxingoƚaita lun Nínive, jiƚpiya Jonás uya'ahuo'ma litaiqui' ȽanDios. Iƚniya lun Nínive ticuftolhuo'. Iƚne iquimf'e'me lu'i'mola' Jonás, ixhuej'menanca. Itsiya tama imanc' toƚquimf'eyi anuli xonca acueca', aimoƚsuej'memma. ");
INSERT INTO chdNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Munai'im'me lepalc'o' aimeminyacu, aimic'ommumiquinyacu. Tipo'nonni pe lopiyopa. Toƚta'a titsuflaiƚe lan xanuc' jiƚpe lajut'ƚ tixim'me lepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lo'u' tepalc'o'ihuo'. Ja'ni ac'a lo'u' toxinna pe lof'huapa, te lof'epa. Ja'ni a'ijc'a lo'u' topanehuo al muf. ");
INSERT INTO chdNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ma' anuli lo'e'eyaco' ja'ni to'ehuale laic', topanehuo al muf. Ti'i'mo' a'ijc'a lopicuejma', aimepalc'o'ihuo'. Topo'noƚaj cuenna. Ja'ni timufc'otsi lopicuejma', acueca' juaiconapa ti'i'ma iƚe al muf. ");
INSERT INTO chdNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ja'ni ac'a lopicuejma' aimopajnya al muf. Ti'i'mo' to lo'e'eyaco' lepalc'o'. Ja'ni toƚoc'aiƚa' lepalc'o' tepalc'o'i'mo' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús lijoupa lipalaipa iƚe lataiqui' anuli cal xans fariseo ijoc'ihuo'ma tiyeƚe lejut'ƚ titetsota. Jesús itsufai'ma iƚe lajut'ƚ icutsai'ma, titetso'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Cal xans fariseo ehuelojm'ma Jesús, ixim'ma aimi'ay to lif'as xanuc' fariseo. Aiculou'ma al c'a limane ai'a titetso'ma. Cal fariseo timiyoxi: “Iƚca'a cal xans Jesús, ¿te qui'ecopa toƚta'a? Aiculouhuo al c'a limane to maƚ'eyi illanc'.” ");
INSERT INTO chdNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ȽaƚPoujna Jesús timi: ―Imanc' unc'ifariseo tolapajyi pe li'huáqui. Tolapajyi liƚspula' loƚvaso, loƚpime. Pe aiqui'huáqui, jiƚpe aimoƚ'eyi cuenna. Imanc' loƚpicuejma' tipanemma a'ijc'a, imanna pangay quixcay. Jiƚpe loƚpicuejma' toƚjanajyi tepi'intsolhuo' xonca, toƚspic'eyi toƚ'eƚe quixcay. ");
INSERT INTO chdNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Imanc', unc'itonno. Iƚque Ƚolanc'epa li'huáqui, ¿ja'ni aiquilanc'e jouc'a iƚe pe aiqui'huáqui? ");
INSERT INTO chdNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Imanc' ts'oƚ'hueca tolapi'itsola' pe ailopa'a quiƚ'hueca. Tijouƚa' ȽanDios tetenƚcoco'ma loƚ'ejma', tixim'molhuo' unc'ilimpio, jouc'a loƚpime, loƚvaso. ");
INSERT INTO chdNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’A'ijc'a lo'iyacolhuo' imanc' unc'ifariseo. Loƚxaimu, loƚruda jahuay loƚpitamqui, ja'ni oƚ'hueca imbama' toƚtsufco'me anuli, tijouƚa' aimoƚ'nujuais'mola' loƚf'as xanuc'. Aimoƚ'ela' capic'a. Aimoƚ'ela' al c'a, aimoƚ'ela' al ƚijca to locuxepa ȽanDios. ¡Ne'! Aimonlimenc'eco'me toƚsufco'me ȽanDios loƚpitamqui, jouc'a tonƚ'eƚe jahuay locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’A'ijc'a lo'iyacolhuo' imanc' unc'ifariseo. Jiƚpiya ƚajut'ƚi pe lafoƚyomma lan xanuc', imanc' oƚpic'a toƚcutsoƚaiƚe pe locutsoƚaipa lan tsilaj xanuc'. Monƚe'me la plazá locucaleyompa oƚpic'a lan xanuc' tinontsolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","A'ijc'a lo'iyacolhuo'. Ti'onƚcospolhuo' to jiƚpe lamu'empola' lamizhua. Lan xanuc' muyalaico'me jiƚpiya aimixinyi te ts'i'ic' jiƚpe. Toƚe qui'ic' loƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Anuli iƚne lomxiye nomuc'iyalepa locuxepa ȽanDios italai'e'e'ma, timi: ―Momxi, lofcuapa toƚta'a jouc'a illanc' aƚmiloquinga' cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús italai'e'e'ma, timi: ―Imanc' unc'omxiye noƚmuc'iyalepá locuxepa ȽanDios, a'ijc'a lo'iyacolhuo'. Imanc' tolatonc'iyi lataiqui' locuxepa ȽanDios. Toƚcuxe'ela' lan xanuc' tenant'ƚiƚe jahuay iƚe loƚtaiqui'. Iƚniya tixinyi ipime loƚcuxe'epola', afule mixnet'ƚyi. Jouc'a imanc' aimolanant'ƚiyi. Toƚsinyoƚtsi uhuaƚquelhuo'. Toƚcuxeyoƚtsi coƚtuca'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Imanc' a'ijc'a lo'iyacolhuo'. Loƚtatahueló inma'ahuale, ima'a'me lam profeta. Imanc' toƚƚanc'e'ela' ƚilejut'ƚi iƚne lam profeta. ");
INSERT INTO chdNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Toƚta'a toƚmujyoƚtsi tetenƚcocolhuo' li'epa loƚtatahueló. Iƚne linma'ahuale ima'a'me lam profeta, imanc' toƚƚanc'e'ela' quilejut'ƚi pe lemu'empola' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’ȽanDios acueca' lipicuejma'. Joupa iximpa te ts'i'i'c' loƚ'ejma'. Joupa ipalaicopolhuo', icuapa: “Cumme'e'mola' lam profeta, jouc'a lan apóstole, ticuaitsa pe lomana' iƚniya lan xanuc'. Iƚne tima'ata hualca, locuenaye ti'e'ennola' acueca'.” ");
INSERT INTO chdNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","’Imanc' ma toƚta'a loƚ'ejma'. Toƚta'a jouc'a toƚtai'me liƚjunac' loƚxanuc', iƚne inma'ahuale, ima'a'me lam profeta. Ma lipangopa li'a lamats' maƚpe ipangopa jouc'a li'epa lixcay. ȽanDios jahuay ti'najtsi'i'molhuo' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ti'najtsi'im'molhuo' limacopa Abel, ti'hua ti'najtsi'im'molhuo' lima'ampola' lam profeta, cocuaiya lima'ampa Zacarías. Iƚque ima'ayom'me jiƚpe al cuecaj xoute' lixpula' al altar, jiƚpe lotsuflaiyacu al paxi lugar. ");
INSERT INTO chdNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Imanc' unc'omxiye noƚmuc'iyalepa locuxepa ȽanDios a'ijc'a lo'iyacolhuo'. Joupa oƚcuapá: “Ma le'a illanc' aƚsina'. Ma le'a illanc' aƚmuc'iyale'me.” Joupa oƚs'nifcopá al puerta, olamipá cal llave. Imanc' aicoƚtsuflaic' pe locuxeyopa ȽanDios, jouc'a aicolapi'ila' lane lan xanuc'. Pe nocuapá: “Aƚtsulfoƚaiƚe”, imanc' oƚpa'nela'. ");
INSERT INTO chdNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lomxiye nomuc'iyalepá locuxepa ȽanDios jouc'a lam fariseo juaiconapa ixtulenca. Lipanni Jesús jiƚpe lajut'ƚ ipango'me icuis'mot'ƚe'me juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tehueyi te co'iya mic'aiƚqueya Jesús. Tinesla' cataiqui', tijouƚa' ticuxecota, ticuaita quiƚmane ts'iƚpenic'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mipa'a Jesús lajut'ƚ jiƚpiya efoƚunni axpela' lan xanuc', ti'huaƚtsijnyoƚtsi. Ate'a ipalaic'o'mola' ts'ilihuequi. Lipangopa lipalaic'opola' timila': ―Imanc', toƚpo'noƚe cuenna. Aimolapenuf'me jiƚe ƚiƚƚevadura lan xanuc' fariseo. Capalaicola' liƚ'ejma' iƚniya. Iƚne ma le'a ti'e'eyoƚtsi ac'a xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Camilhuo': Letamuyiya tiƚonc'e'em'me, ti'huájta. Tixim'me iƚe lemiya. ");
INSERT INTO chdNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iƚe loƚpalaipa joupa imufc'opa, ticuaihuo litine tepalc'o'ina'me, ticuec'ena'me. Jiƚe loƚsoulai'ipoƚtsi moƚmana' letemiquiya lajut'ƚ, maƚiya lataiqui' tuya'am'me al toncay lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Imanc' laƚejmalepa, iya' camilhuo': Aimoƚspaic'e'mola' noma'ahualepá. Iƚniya ma le'a tejac'eyi al cuerpo. Tijouƚa' aimi'iya mi'eyacu xonca. ");
INSERT INTO chdNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iya' cu'ilhuo' naitsi ƚoƚspaic'eyacu. Iƚque icueya limane. Ti'i'ma tima'a'mola' lan xanuc', tijouƚa' ti'nij'mi'mola' al muf, pe lopa'a ƚunga. Iƚque ƚinca axpaiqui'. Tolihuejcoƚe iƚque. ");
INSERT INTO chdNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Joupa oƚsina' tojua liƚpitali lan gorrión. Ticujconnila' amajxi ma le'a oque' centavo. Tama ahuata liƚpitali iƚne lacaƚ'hui, ȽanDios aimimenc'ejma ni anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xonca ti'nujuaitsilhuo' imanc'. Joupa ixhuej'miya tojua mipa'a ƚajuac quitefque ƚoƚjuac. Ixina' ja'ni tecangemma anuli. Aimoƚsueƚmot'ƚe'me. Aimixpailij'molhuo' lo'iyacolhuo'. ȽanDios tixinnilhuo' acueca' loƚpitali. Tama axpela' lan gorrión aimi'iya mulijyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Iya' camilhuo': Anuli cal xans mipa'a fa'a li'a ƚamats', ja'ni alimetsaicoƚa', ja'ni timitsola' lif'as xanuc': “Iya' nihuequi Jesús”, iya' jouc'a quimetsaico'ma. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Pe lomana' lepaluc' ȽanDios cuya'ata: “Iƚque cal xans lihuequi”. ");
INSERT INTO chdNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Anuli cal xans ja'ni tinesla': “Iya' aicainihuequi Jesús”, iya' jouc'a aicainimetsaicoya iƚque cal xans. Pe lomana' lepaluc' ȽanDios cuya'ata: “Iƚque aicalihuequi”. ");
INSERT INTO chdNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Cua naitsi aƚnesc'e'eƚa' cataiqui', iƚque cal xans ti'i'ma tiƚojm'ma lijunac'. Cal xans nonesc'e'eya cataiqui' cal Espíritu Santo, iƚque aimiƚonc'e'enyacu lijunac', aimi'iya. Iƚta'a lapajnya jouc'a locuenaj quitine titai'ma lijunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ticuaihuo litine ticufquinnolhuo', ti'hua'am'molhuo' ƚajut'ƚi pe lafoƚyomma lan xanuc', tileconnolhuo' pe lomana' lan tsilaj quincuxepá, maƚe anuli tileconnolhuo' pe lomana' ts'iƚpenic'. Ti'itsolhuo' toƚta'a aimoƚsueƚmot'ƚe'me, aimoƚcua'me: “¿Te co'iya catalai'ecoyacoxi? ¿Te caifmiyacola'?” ");
INSERT INTO chdNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maƚe al 'hora cal Espíritu Santo tu'i'molhuo' loƚtalai'ecoyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jiƚpe lefoƚya anuli cal xans ipalaic'o'ma Jesús, timi: ―Momxi, ƚaipima joupa efot'ƚumijnapa ƚi'huexi caƚ'ailli'. Tomita lapi'iƚa' onƚca ƚocuaiya caimane. ");
INSERT INTO chdNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús italai'e'e'ma, timi: ―Cunxans, ¿te aga aƚfaquimpa cacuxetsolhuo' toƚta'a? A'i. Aimi'iya capit'ƚiyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesús ipalaic'o'mola' lan xanuc', timila': ―Imanc' toƚ'etsoƚtsi cuenna. Aimonlahue'me acueca' coƚ'huexi. Cal xans tama acueca' ƚi'huexi, iƚque ƚi'huexi aimi'iya mepi'iya lipitine. ");
INSERT INTO chdNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesús ti'hua tipalaic'ola'. I'onƚico'ma to li'ipa anuli cal xans nulijpa acueca' qui'huexi. Timila': ―Anuli cal xans i'hueca acueca' ƚemats', ipammaita juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iƚque ipalaic'o'moxi, timiyoxi: “¿Te caif'eya? Ailopa'a caif'huec'e'eya ƚipammaita acueca' ƚainemats'.” ");
INSERT INTO chdNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lijou'ma timiyoxi: “Ne', joupa aixina' laif'eya. Cateƚ'ma ƚainejut'ƚi pe laif'huec'eyopa ƚai'huexi. Tijouƚa' calanc'econa'ma xonca atsila' ƚainejut'ƚi. Jiƚpe ca'huej'ma ƚaitrigo jouc'a jahuay ƚocuena ƚai'huexi ƚipammaita ƚainemats'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tijouƚa' cami'moxi: Cunxans, joupa' o'hueca acueca'. Tijuco'ma axpe' camats'. Itsiya ƚinca tonxaj'ma, totetso'ma, toxna'ma, topajm'ma tixoj'ma meta.” ");
INSERT INTO chdNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ȽanDios ipalaic'o'ma timi: “Ima' cunxans umtonno. Iƚta'a lipuqui' tiƚonc'e'enam'mo' lopitine. Tijouƚa' jahuay ƚomefot'ƚepa, ¿naitsi ƚapenufya iƚna'a?” ");
INSERT INTO chdNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","’Iya' camilhuo': Toƚta'a cal xans ja'ni tixhuej'mecoyoxi iƚque quituca', lo'epa aimetenƚcocojma ȽanDios. Iƚque tama acueca' efot'ƚepa, ȽanDios tixina to aiqui'hueca, aimepenufi iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús lipangoconapa lipalaic'oconapola' ts'ilihuequi, timila': ―Aimoƚsueƚmot'ƚe'me te co'iya muluyalaicoyacu lapajnya fa'a li'a ƚamats'. Aimoƚcua'me: ¿Te caƚtejacu? ¿Te caƚju'ecoyacoƚtsi? ");
INSERT INTO chdNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Loƚpitine acueca' lipitali, ƚoƚtepa aijtine. Loƚcuerpo ƚinca xonca acueca' lipitali, loƚju'ecoyacoƚtsi aijtine. ");
INSERT INTO chdNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","’Toƚsinƚe lan coƚpe'. Iƚniya aimifayi, ni mefot'ƚeyi. Ailopa'a quilejut'ƚ ni quiƚ'huecoƚma pe lo'huejyoyacu ƚotejacu. Ma ȽanDios tites'mila'. Imanc' aimi'onƚyacolhuo' to iƚniya lacaƚ'hui. Xonca acueca' loƚpitali. ");
INSERT INTO chdNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Imanc', ¿te aga ti'i'ma toƚ'e'e'moƚtsi xonca unc'itoƚqui? A'i. Aimi'iya, ni huata. Tama toƚsueƚcocoyi aimi'iya monƚ'eyacu iƚe a'ij cueca'. Tijouƚa' ¿te coƚsueƚcocopa te co'iya muluyalaicoyacu lapajnya? ");
INSERT INTO chdNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Toƚsinƚe te ts'i'ic' mitoqui iƚna'a ƚaic'uá c'ec. Tama aimucui ni mipufi ƚipipa' tetejcoyoxi to quipijahua'. Cal cuecaj rey Salomón lipo'nopa ac'a lipijahua', tama i'huáqui juaiconapa acueca' quincuxepa, aiqui'onƚcotsi to jiƚpe ƚipipa' c'ec. ");
INSERT INTO chdNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ȽanDios tiju'e'ela' juaiconapa ac'a ƚaic'uá c'ec. Iƚque ƚaic'uá c'ec aimijujma. Anuli quitine titoqui ac'a, lihuequi litine tiyaxquinni, tipi'enni pe lopa'a lapa. Imanc', ¿te ȽanDios aimiju'eyacolhuo'? Ah imanc', huata toƚ'huaiyijnyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","’Muluyalaicoyi lapajnya aimolahue'me ma le'a coƚtejacu o coƚsnayacu. Aimoƚcua'me: “ȽanDios, ¿te lapi'i'monga', o aimalapi'iyaconga'?” ");
INSERT INTO chdNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Toƚta'a liƚ'ejma' lan xanuc' pe aimimetsaicoyi ȽanDios. Coƚ'Ailli' ixina' te laicuicom'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Imanc' toƚpo'noƚe loƚpicuejma', tolihuejcoƚe ȽanDios cal Cuecaj Rey, tonƚ'eƚe al c'a ma to locuxepolhuo'. Toƚta'a tepi'i'molhuo' jahuay, aimehue'eyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Imanc' aixanuc' aimixpailij'molhuo', aimoƚsueƚmot'ƚe'me. Tama imanc' unc'ihuata toƚcuxeta pe lopa'a ȽanDios cal Cuecaj Rey. Toƚta'a lixpic'epa ȽanDios, iƚque oƚ'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Toƚcujle ƚoƚ'hueca. Al tomí lolulijyacu tolapi'itsola' lan xanuc' petsi aiquiƚ'hueca. Ja'ni toƚta'a tonƚ'eƚe ti'i'ma acueca' ƚoƚ'huejyacu jipu'hua lema'a. Jifa'a li'a ƚamats' ti'hua tijaf'quila' ƚoƚpontalay tomí, tijou'ma loƚtomí. Pu'huanni a'i. Aimijouya. Jipu'hua nonantsepá aimiƚoc'huaiyacu. Lan huoxmi aimitejacu, ailopa'a. ");
INSERT INTO chdNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Imanc' pe lopa'a ƚoƚ'huexi maƚpiya copa'a loƚpixojma cata. ");
INSERT INTO chdNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Imanc' ti'onƚcospolhuo' to lam mozó ts'iƚ'huaijma ticuaitsi ƚiƚpoujna, iƚque joupa ipainamma lijuic lipemaná, ticuainata lejut'ƚ. Iƚne lam mozó joupa iƚ'huaijma ƚiƚpoujna ti'e'me lipenic'. Joupa unai'ipa liƚpepalc'o'. Ticuainatsi ƚiƚpoujna maƚpe lejut'ƚ tijoc'i'mola' limozó, iƚne aimicoƚyacola' texi'e'me. ");
INSERT INTO chdNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ac'a juaiconapa loyalaicoyacu iƚne lam mozó ts'iƚ'huaijma ƚiƚpoujna ticuaihuananni. Camilhuo' al ƚinca: Ticuaitsi ƚiƚpoujna iƚque tifi'e'moxi to cal mozo, timi'mola' iƚniya limozó: “Imanc' toƚcutsoƚaiƚe, toƚtetso'me. Iya' cates'mi'molhuo'.” ");
INSERT INTO chdNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ticuaitsi ƚiƚpoujna nolojmay quipuqui' o ticuaitsi ai'a tiƚic'e'ma, ja'ni tixintsola' limozó ts'iƚ'huaijma, ƚinca ac'a loyalaicoyacu iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","’Toƚcuec'eƚe iƚta'a laifmipolhuo' jouc'a: Ƚipoujna cajut'ƚ coƚa' ti'iƚa' quixina' te 'hora ticuaihuo ƚinnantsepa, coƚa' aimixmai'ma. Ti'huaico'ma lipuqui', ticuanajco'ma lejut'ƚ. Toƚta'a ƚinnantsepa aimi'iya mitsufaiya. ");
INSERT INTO chdNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Imanc' toƚpo'noƚe cuenna. ¡Toƚmaf'iƚe! Litine toƚnesle: “Ƚaƚpoujna aimicuaiya, ticoƚi”, maƚpiya al 'hora cacuaiyoconno iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro icuis'e'ma timi Jesús: ―Maipoujna, iƚe lotaiqui' lof'onƚicopa tocuaiconanni, ¿te lu'inga' ma le'a illanc' o jouc'a to'ila' jahuay lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ȽaƚPoujna Jesús italai'e'e'ma, timi: ―Ima', ¿te cofcuapa? Ja'ni ƚapoujna tipahuo lejut'ƚ, ¿naitsi co'huijf'eya ti'eƚa' cuenna? Ti'huijf'e'ma cal xans ts'ipicuejma'. Iƚque tenant'ƚi'ma, ticuxe'e'mola' lif'as mozó, tites'mi'mola' lacuej'micoya al 'hora. ");
INSERT INTO chdNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cal xans ƚipo'no'impa lajut'ƚ, ja'ni toƚta'a lo'eya, ac'a juaiconapa loyaicoya. Ticuaitsi ƚipoujna tixim'ma ac'a lo'epa, tetenƚcoco'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iya' camilhuo' al ƚinca: Tepi'i'ma xonca al cueca' lipenic'. Jahuay ƚi'hueca ƚipoujna ticuxe'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","’Iƚque cal xans ƚipo'no'impa lajut'ƚ ja'ni timixoxi: “Ƚaipoujna ticoƚi”, tijouƚa' tipango'ma tuntafej'mola' lif'as mozó, lan xanuc' jouc'a lacaƚ'no', tuyaico'ma litine ma le'a titesma, tixnay, timeyoqui. ");
INSERT INTO chdNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Litine aimi'huaijma, al 'hora aimixhuejcocojma, maƚiya litine ticuaita ƚipoujna. Tetetsuf'ma, tihuescufinna tipajntsi pe aiquilihuejma. ");
INSERT INTO chdNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Cal mozo ts'ixina' lipic'a ƚipoujna, iƚque ja'ni aimihuejnyoxi, ja'ni aimi'ay loxpic'epa ƚipoujna, titeƚ'minna juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Cal mozo pe aiquixina' lipic'a ƚipoujna, tama ti'eƚa' ixcay, iƚque titeƚ'minna huata. Cal xans ja'ni joupa epi'impa axpe', jouc'a tipai'intsi axpe'. Cal xans ja'ni joupa ixc'ai'impa acueca', ticuxe axpe', ticuicomma xonca tenanƚiƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Iya' aicuaicoco'ma cunai'iƚa' ƚunga jifa'a li'a ƚamats'. Cacua: Coƚa' joupa unnaita. ");
INSERT INTO chdNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tehue'e'. Cateƚco'ma xonca. Ma cai'huaijma ti'iƚa' iƚe laifteƚcoya caxhueƚma juaiconapa. Cacua: Aimicoƚ'ma. Ma ti'iƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","’¿Te aga imanc' toƚcuayi: “Iƚque Jesús icuaicoco'ma lan xanuc' aimenaj'moƚtsi”? A'i. Iya' aicuaicoco'ma tixtuleƚe lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Joupa i'ipa toƚta'a, ti'hua ti'i'ma. Anuli lajut'ƚ ja'ni timana' amajxi, jiƚniya tenaj'moƚtsi. Afantsi tixtuc'o'mola' oquexi', loquexi' tixtuc'o'mola' lam fantsi. ");
INSERT INTO chdNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ƚa'ailli' tixtuc'o'ma ƚi'hua camijcano. Ƚi'hua tixtuc'o'ma qui'ailli'. Ƚa'máma' tixtuc'o'ma ƚi'hua cahuats'. Ƚahuats' tixtuc'o'ma qui'máma'. Cal fi'no tixtuc'o'ma ƚihuahua. Ƚahuahua tixtuc'o'ma cal fi'no cahuahua. ");
INSERT INTO chdNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Timila' lan xanuc': ―Ja'ni toƚsinƚe ƚummahuay qui'huayomma pe lof'acaiyopa cal 'ora toƚnes'me: “Ticui'ma”. Ƚinca toƚta'a ti'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jouc'a ja'ni ti'hua ƚinu' cahua' toƚnes'me: “Ti'i'ma inu'”. Ƚinca toƚta'a ti'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imanc' a'i cunc'ic'a xanuc'. Ma le'a tonƚ'e'eyoƚtsi. Toƚsuef'yi lema'a. Iƚe oƚsina'. ¿Te aimolimetsaicoyi lo'epa ȽanDios itsiya litine? ");
INSERT INTO chdNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Jouc'a camilhuo': ¿Te aimolahuelojnyoƚtsi coƚtuca' lonƚ'epa, ja'ni tonƚ'eyi al ƚijca o a'i? ");
INSERT INTO chdNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Monƚeyi lane ima' jouc'a ƚaixtuc'o'po', iƚque no'hua'apo' cal juez, ima' tahue'ma te co'iya mopac'eya lipoyac', tux'masnatso'. Ja'ni a'i, tileco'mo' pe lopa'a cal juez. Iƚque ticuto', tepi'inna quimane ƚapaluc, ti'nicoto' lacarza. ");
INSERT INTO chdNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iya' camilhuo': Ma cotaiyinge, tama ma le'a anuli al centavo, ti'nicoconno' jiƚpiya lacarza, aimaipaya. ");
INSERT INTO chdNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Iƚniya ƚitiné lan xanuc' u'ipá Jesús te ts'i'ic' li'ipola' lan xanuc' quiyouyomma al distrito Galilea. Iƚniya icuaita Jerusalén titsufcota liƚpinneja. Ma mitsufcoyi Pilato icuxe'ma tima'antsola' iƚne lan xanuc'. Letequim'mola' lipanni liƚjuats' iƚne lun Galilea jouc'a ipanni liƚjuats' liƚpinneja, inu'ma anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús timila': ―Jiƚniya lun Galilea li'empola' toƚta'a, ¿te imanc' toƚcuayi xonca acueca' liƚjunac', liƚf'as xanuc' Galilea a'ij cueca' liƚjunac'? ");
INSERT INTO chdNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iya' camilhuo': A'i xonca acueca' liƚjunac'. Imanc' ja'ni aimoƚsuej'memma jouc'a tejac'molhuo', jahuay imanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","’Lecangenni iƚe li'nof'quiya lajut'ƚ lopa'a Siloé, ima'a'mola' imbamaj paico lan xanuc', uxpats'i'mola'. ¿Te coƚcuapa? ¿Te xonca acueca' liƚjunac' iƚniya lima'mola'? Locuenaye xanuc' nimajmpá Jerusalén, ¿te ailopa'a acueca' quiƚjunac'? ");
INSERT INTO chdNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iya' camilhuo' a'i xonca acueca' liƚjunac' iƚne lima'a'mola' li'nof'quiya lajut'ƚ. Imanc' ja'ni aimoƚsuej'memma jouc'a tejac'molhuo', jahuay imanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Imuc'icona'mola', i'onƚicopola' anuli al 'ec icux, timila': ―Anuli cal xans petsi lifapa li'uva jouc'a ifapa li'icux. Litine lehuehuo'ma ƚi'as li'icux ailopa'a qui'as. ");
INSERT INTO chdNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Cal xans ipalaic'o'ma ƚimozo no'epa cuenna ƚi'uva, timi: “Joupa ixhuaita afane' camats' ca'huanetsomma, cahuay ƚi'as icux. Ailopa'a qui'as. ¡Tatejla' nulemma! Ma le'a tixhuijma ƚamats', aimi'atsi.” ");
INSERT INTO chdNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Iƚque no'epa cuenna cal 'uva italai'e'e'ma, timi: “Maipoujna, ¡tipajnla'! Tipanenni ocuena camats'. Capu'ma ƚamats' luxi al icux, cajuaj'mi'ma ƚumi'na. ");
INSERT INTO chdNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ƚocuena camats' tocuaiconamma toxim'ma ja'ni tipa'a ƚi'as. Ja'ni aimi'atsi, ne' tetequim'me.” ");
INSERT INTO chdNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Anuli litine conxajya tipa'a Jesús anuli lajut'ƚ pe lafoƚyomma lan xanuc'. Timuc'iyale. ");
INSERT INTO chdNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jiƚpe tipa'a anuli ƚaca'no' ƚitsufaipa conta'a. Iƚque ƚonta'a ixmec'e'epa lixpula'. Aimi'iya mecaxhuaya. Joupa ixhuaita imbamaj paico camats' toƚta'a ƚonta'a titeƚ'mi ƚaca'no'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lixim'ma ƚaca'no' Jesús ijoc'i'ma, timi: ―Maca'no', joupa uhuaƚquenam'mo', ixaƚconapo'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús ixpayaf'ma limane. Aiquicoƚ'ma, ƚaca'no' ecaxna'ma ƚic'. Ix'najtsi'i'ma ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesús lixaƚ'mena'ma ƚaca'no' itine conxajya, ƚincuxepa jiƚpe lajut'ƚ ixtunni. Timila' lan xanuc': ―Cal xans ti'e'ma canic' acamts'us quitine, ixahuiya. Itsiya itine conxajya. Ja'ni oƚpic'a tixaƚ'mentsolhuo' toƚcuaiyunca ocuena quitine. ");
INSERT INTO chdNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ȽaƚPoujna Jesús italai'e'e'ma, timi: ―Imanc' a'i cunc'ic'a xanuc'. Ma le'a tonƚ'e'eyoƚtsi. Ti'iƚa' litine conxajya, ¿te aimoluhuaƚquila' ƚoƚhuacax, ƚoƚburro? Ƚinca toluhuaƚyi, toƚ'hua'ala' tixnatsa quiƚja'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iƚca'a ƚaca'no' a'i quinneja, inieto ƚoƚtatahuelo Abraham. Ixhuaita imbamaj paico camats' ƚonta'a Satanás ifi'e'. Itsiya itine conxajya, ¿te aimi'iya cuhuaƚya? ");
INSERT INTO chdNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Linespa toƚta'a Jesús i‑ch'ixco'mola' iƚne no'epá laic'. Iƚniya aiquiƚtalai'e. Ailopa'a cotalai'ecoyacu. Locuenaye lan xanuc' tixoqui quileta, ixim'me acueca' ac'a juaiconapa lo'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Timila': ―Itsiya ȽanDios cal Cuecaj Rey tijoc'ila' lan xanuc' tihuejcoƚe. ¿Te co'onƚcospa iƚe lo'ipa? ¿Te caif'onƚicoya? ");
INSERT INTO chdNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ti'i to li'ipa anuli ƚaca'hua fanu'. Iƚque cal fanu' cuftine sinapí. Anuli cal xans itai'ma ƚaca'hua fanu', ifatsi ƚequeya. Ila'ma, i'i'ma acueca' al 'ec. Lacaƚ'hui naiyulpá lema'a tiƚcuaispa tunxajyi jiƚpe, ti'huoxof'coƚaiyi ƚimané jiƚe al 'ec. ");
INSERT INTO chdNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Timiconala': ―¿Te caif'onƚicoya lo'ipa pe ȽanDios cal Cuecaj Rey tijoc'ila' lan xanuc' tihuejcoƚe? ");
INSERT INTO chdNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jiƚpe ti'i'ma to li'ipa lilai'ipa ƚilevadura ƚaca'no' acueca' ƚi'harina. Iƚe cal levadura ti'hua tihuantsi cal 'harina. Lijou'ma umfunni jahuay ƚax'e. ");
INSERT INTO chdNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Lijou'ma Jesús ti'hua lane, ticuaita liƚya' Jerusalén. Tehuengila' ƚiƚeloƚya', lan tsila' jouc'a lan tsocay. Timuc'iyale jiƚpiya ƚiƚeloƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Anuli cal xans ipalaic'o'ma, icuis'e'ma, timi: ―Maipoujna, ¿te aga ahuata lan xanuc' tunƚul'me? Jesús ipalaic'o'mola' lan xanuc' noquimf'epá timila': ");
INSERT INTO chdNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Tolahueƚe te co'iya moƚtsuflaiyacu al tansca al puerta. Iya' camilhuo': Axpela' lan xanuc' tehue'me te co'iya mitsuflaiyacu, tijouƚa' aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Titsahuenni ƚiPoujna cajut'ƚ tix'nifco'ma lejut'ƚ. Ja'ni imanc' toƚmanemma ƚuna toƚjoc'i'me, toƚsa'hue'me, toƚmi'me: “MaƚPoujna, taxi'eƚa' lopuerta. Aƚpic'a aƚtsuflaiƚe.” Iƚque timi'molhuo': “Aicaixina' pe conƚouyomma. Aicainimetsaicolhuo'.” ");
INSERT INTO chdNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Imanc' toƚtalai'e'me, toƚmi'me: “Illanc' aƚejmalepá, aƚtetsopá, aƚsnapá anuli ima'. Ima' o'hua'ma ƚaƚpeneya, tomuc'iyale jiƚpiya laƚpiƚya'.” ");
INSERT INTO chdNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ȽaPoujna timi'molhuo': “Iya' aicaixina' pe conƚouyomma. Aicainimetsaicolhuo'. Imanc' aimonƚ'eyi al ƚijca. Tonlipalunca pe laifpa'a. Tonƚenƚe.” ");
INSERT INTO chdNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","’Iƚniya ƚitiné imanc' toƚsinnola' loƚtatahueló, iƚniya Abraham, Isaac y Jacob, jouc'a jahuay lam profeta. Iƚne itsulfaipá petsi locuxeyopa ȽanDios cal Cuecaj Rey. Imanc' a'i. Toƚmanecu ƚuna. Imanc' toƚjolij'me, toƚtetola' lonƚ'ay. Acueca' cunla loƚteƚcoyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Lan xanuc' naihuejcopá ȽanDios tipalcu ni petsi li'a ƚamats', tipalcu pe laipammaiyomma cal 'ora, jouc'a pe lof'acaicopa cal 'ora, jouc'a pe ƚinu' camats', jouc'a pe lo'huayomma ƚujfxi cahua'. Iƚniya ticuaita al juic. Titsuflaita, ticutsoƚaita, titetsota pe locuxeyopa ȽanDios, iƚque ƚiƚCuecaj Rey. ");
INSERT INTO chdNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","’Toƚcuec'eƚe, locuaicoya quitine tixin‑nim'mola' lijoucola' joupa i'ipola' lan tet'ƚa. Tixin‑nim'mola' lan tet'ƚa joupa i'ipola' lijoucola'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Maƚe 'hora icuaiyunca hualca lam fariseo. Iƚniya timiyi Jesús: ―To'huanƚa'. Taipanni fa'a. Cal rey Herodes tehuehuo' tima'atso'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús italai'e'e'ma, timila': ―Iƚque cal Herodes ti'onƚcospa to cal t'ƚe, ma le'a infel'miyale. Tonƚenƚe. Tulu'itsa: “Jesús timihuo': Itsiya y mouqui quipa'ala' lontahue, caxaƚ'menala' lan xanuc'. Pitsu cajou'ne'ma laipenic'.” ");
INSERT INTO chdNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Itsiya, mouqui y pitsu ca'huana'ma laipene. Cacuaita Jerusalén. Jiƚpe liƚya' quima'ayompola' lam profeta. Iya' ninprofeta, maƚpiya Jerusalén aƚma'ayonna, a'i ocuena quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Miƚya' Jerusalén! ¡Miƚya' Jerusalén! Loxanuc' inma'ahuale tima'annila' lam profeta, tipangila' capic' tima'antsola' lixanuc' ȽanDios, iƚne lummepola' jiƚpiya. ’Iya' axpe' canesqui: Cafot'ƚe'mola' jahuay loxanuc' ma to mi'ay cal tsana mefot'ƚe'mola' laiquipuyu, mipuxc'i'mola' ƚixala'. Ima' aicocuac'. ");
INSERT INTO chdNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Miƚya'! ¡Tahuelojnla' locuecaj xoute'! ȽanDios ipo'nopa quituca'. Tocomma to joupa eteƚquemma. Iya' camilhuo' al ƚinca. Ticuaitsi litine aƚmiƚa': “Ima' unC'a. ȽanDios ƚaƚPoujna ƚinca ummepo'”, iƚe litine aƚsingona'ma. Ai'a ticuaita iƚe litine aimaƚsingonaya. ");
INSERT INTO chdNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Anuli litine conxajya Jesús i'hua'ma titetsota lejut'ƚ anuli cal xans fariseo, iƚque nocuxepola' lif'as fariseo. Jiƚpe lajut'ƚ tehuelaifyi Jesús, ¿te co'eya? ");
INSERT INTO chdNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Jouc'a ticutsuya anuli ƚafcuana, ifunapa jahuay licuerpo. Jesús tehuelonge, ipalaic'o'mola' lam fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, iƚniya nomana' jiƚpiya, icuis'e'mola', timila': ―Litine conxajya, ¿nipajnya tixaƚ'meyale'ma anuli? o ¿aimi'iya? ¿Te tipa'a lane? o ¿ailopa'a? ");
INSERT INTO chdNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Iƚne i‑ch'ixco'mola'. Jesús i'noƚ'ma ƚafcuana, ixaƚ'mena'ma, ummena'ma ti'huanƚa' lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ipalaic'o'mola' iƚne lam fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, timila': ―Imanc', ja'ni tecajm‑maitsi al pu'hua ƚoƚburro o ƚoƚhuacax, tama itine conxajya, ¿te aimonlipa'ayacu? Aƚinca tonlipa'a'me. ");
INSERT INTO chdNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iƚne aiquiƚtalai'e iƚe limipola' Jesús, ailopa'a quiƚtaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jiƚpiya timana' lijoc'impola' tehueyi te co'iya micutsoƚaiyacu pe locutsoƚaiyacu lan tsilaj xanuc'. Lixim'mola' Jesús i'onƚico'mola' liƚ'ejma', timila': ");
INSERT INTO chdNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ja'ni tijoc'intso' anuli al juic lamaná, tocuaitsi lajut'ƚ aimocutshuai'ma pe li'huáqui xonca al c'a. Aga ticuaita anuli xonca cal cuecaj xans. ");
INSERT INTO chdNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Timi'mo' nijoc'ipolhuo': “Totsahuenni. Iƚca'a ticutshuai'ma jiƚpe lofcutsuya ima'. Totsahuenni.” Tijouƚa' toxim'ma calaic'ata. To'hua'ma, tocutshuai'ma pe li'huáqui a'ijc'a. ");
INSERT INTO chdNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","’Ja'ni tijoc'intso' anuli al juic tocutshuai'ma pe li'huáqui xonca a'ijc'a. Ticuaiyunni nijoc'ipo', iƚque timi'mo': “Maipima, to'huanni fa'a. Jifa'a tocutshuai'ma xonca al c'a.” Tijouƚa' locuenaye lijoc'impola' tixim'mo' ima' uncuecaj xans. ");
INSERT INTO chdNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","’Iya' camilhuo': Naitsi cal xans no'e'epoxi acueca', iƚque ti'oc'em'me. Naitsi cal xans no'e'epoxi a'ojca, iƚque tif'ac'em'me. ");
INSERT INTO chdNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús ipalaic'o'ma nijoc'ipa, timi: ―Litine lof'eya al juic aimojoc'i'mola' lonƚejmalepá ni lopimaye. Ni aimojoc'i'mola' nomana' huejnca lomejut'ƚ iƚne pe ts'iƚ'hueca xonca ƚiƚ'huexi. Iƚne ƚinca ti'e'econa'mo', tijoc'icona'mo'. ");
INSERT INTO chdNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","’Ja'ni to'e'ma juic tojoc'itsola' lan xanuc' pe aiquiƚ'hueca. Tojoc'itsola' latumane, lan coxo, lan fohue. ");
INSERT INTO chdNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Toƚta'a, tama iƚniya aimi'iya mi'najtse'eyaco', toyaicona'ma al c'a. Ticuaihuo litine timaf'ina'me lan ƚijca xanuc', ȽanDios ti'najtse'mo' jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Licuej'ma lonespa Jesús anuli jiƚpe titesma timi: ―ȽanDios cal Cuecaj Rey ti'eta juic jiƚpe pe locuxeyopa. Ƚinca al c'a loyaicoya cal xans notsufaiya jiƚpe, titetsota. ");
INSERT INTO chdNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús italai'e'e'ma, timi: ―Anuli cal xans ti'e'ma al cuecaj juic. Ijoc'ipola' axpela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Icuai'ma jiƚe litine al cuecaj juic, umme'ma ƚimozo, timitsola' lijoc'impola': “Tonƚouyunca. Joupa imacoƚpá. Toƚtetsota.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","’Jahuay iƚniya lijoc'impola' ipango'me ines'me: “Aimi'iya ca'huaya”. Cal te'a timi: “Joupa ai'napa ƚainemats'. Ai'huapa caxinna. Tomitsi ƚopoujna: Aimi'iya micuaicoya.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ƚocuena timi: “Iya' ai'napola' imbamaj laihuacax. Ai'huapa caxinnola', ja'ni ti'e'me canic' o a'i. Tomitsi ƚopoujna: Aimi'iya micuaicoya.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ƚocuena timi: “Joupa nemanepa. Aimi'iya ca'huaya.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Ipainanni cal mozo. U'i'ma ƚipoujna linespa lijoc'impola'. Ƚipoujna cajut'ƚ ixtunni. Ummecona'ma ƚimozo, timi: “Aimicoƚ'mo'. To'huaƚa' ƚaneya liƚya', lan tsila', lan tsocay caneya. Tolecotsola', tocuai'ecola' fa'a lan xanuc' pe aiquiƚ'hueca jouc'a latumane, lan coxo, lan fohue.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","I'huacona'ma cal mozo. Ipaiconamma, ipalaic'ocona'ma ƚipoujna, timi: “Joupa ai'epa laƚcuxe'epa. Tehue'ela' lan xanuc', ticuaiyunca xonca axpela'.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ƚapoujna timi ƚimozo: “To'huaƚa' liƚya'. To'huaƚa' lan tsila' caneya, jouc'a ƚema cati'i. Tojoc'itsola' lejmaica, tiyouyunca fa'a. Aipic'a timantsi nulemma lainejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iya' camilhuo': Iƚne lan xanuc' laijoc'ipola' al te'a, nij naitsi iƚniya notec'oya ƚaitejua'.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Axpela' lan xanuc' ilihuequi Jesús lane. Lipai'e'moxi ipalaic'o'mola', timila': ");
INSERT INTO chdNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Cal xans nocuaiyumma pe laifpa'a, nocuapa: “Quihuej'ma Jesús”, iƚque xonca aƚ'e'ma capic'a iya'; qui'ailli', qui'máma', ƚipeno, linaxque', lipimaye, lipitine, aijtine. Ja'ni a'i toƚta'a li'ejma' aimi'iya malihuejya. ");
INSERT INTO chdNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iya' ƚinca cateƚco'ma. Cal xans noxpic'epa aimeteƚcoya, nocuapa: “Iya' aicataiya lainencruz”, iƚque aimi'iya malihuejya. ");
INSERT INTO chdNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Ja'ni anuli imanc' tixpic'eƚa' tilanc'eƚa' li'nof'quiya lajut'ƚ, ate'a ticutshuai'ma, tixim'ma tojua lipitali lolajncoya. Tixim'ma ja'ni ti'ommaicota litomí o a'i. ");
INSERT INTO chdNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ja'ni aimi'ay toƚta'a aga aimi'ommaicoya litomí. Tipu'ma tifa'mola' lapic', tijouƚa' aimi'iya mijou'neya lejut'ƚ, ailopa'a quitomí. Lan xanuc' tixim'me li'ipa, jahuay iƚniya tixoco'me, ");
INSERT INTO chdNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ticua'me: “Iƚque cal xans ipangopa tilanc'e'ma lejut'ƚ. Aiquijou'ne. Aiqui'ic'.” ");
INSERT INTO chdNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’O lan rey, cal nuli ja'ni timana' anuxans mil lisoldado, ƚocuenaj timana' le'a imbamaj mil, tifule'me. Iƚque ts'ahuata quisoldado ticutshuai'ma, tixpic'e'ma lo'eya, ja'ni nipajnya ti'i'ma tulij'ma ƚif'as rey o aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ti'iƚa' quixina' aimi'iya mulijya, mipa'a aculi' ƚif'as rey, tumme'mola' lixanuc', ticuis'eta, timita: “Ƚaƚpoujna ticua: Lu'iƚa', ¿te ts'opic'a? ¿Te capi'iyaco'? ¿Te caif'eya?” Toƚta'a aimifuleyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iya' camilhuo': Imanc' ticuicomma tolatets'iƚe jahuay ƚoƚ'hueca, toƚta'a lihuej'ma. Ja'ni anuli aimicua, iƚque aimi'iya malihuejya. ");
INSERT INTO chdNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ƚo'hue ipenic'. Ja'ni ƚo'hue joupa iminscopa, ¿te co'iya? Aimi'iya milajn‑naya to al te'a. ");
INSERT INTO chdNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Iƚque ƚo'hue ƚiminscopa aimi'iya mi'eya canic', ni jiƚpe ƚamats' ni pe lafot'ƚeyompa ƚumi'na. Aimi'iya mixhuiconyacu. Le'a teca'nim'me. ’Naitsi nocuejpa, aƚquimf'eƚa' iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jahuay lin'najtsi'iyale jouc'a locuenaye lan xanuc' pe aimihuejcoyi locuxepa ȽanDios tiƚoc'oƚaiyi pe lopa'a Jesús, tiquimf'e'me. ");
INSERT INTO chdNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lan xanuc' fariseo jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios ixtulenca. Ticuayi: ―Iƚque cal xans tepenufila' lan xanuc' pe aimihuejcoyi locuxepa ȽanDios. Titetsoyi anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús italai'e'e'mola', i'onƚico'moxi li'ejma' to lo'epa cal xans ƚejac'pa ƚimoƚ. Icuis'e'mola', timila': ");
INSERT INTO chdNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Anuli imanc' amaxnu limot'ƚ, ja'ni tejac'la' anuli, ¿te co'eya? Tipo'no'mola' locuenaye lam malpuj nuxans quimbamaj pelƚa, timanecu ƚimuc'o', tehueta ƚejac'pa, aga tixinnata. ");
INSERT INTO chdNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","’Tixinnatsi ƚimoƚ tipulaf'nata, tipo'nof'inna lixaya, tixoj'ma queta tipaino. ");
INSERT INTO chdNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ticuaitsi lejut'ƚ tijoc'i'mola' lipimaye jouc'a nomana' huejnca, timi'mola': “Tixoquinghua neta juaiconapa. Aixinhuona'ma ƚaimoƚ ƚejac'pa. Tonƚouyunca. Ma' anuli tixoj'ma calata.” ");
INSERT INTO chdNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","’Iya' camilhuo': Ƚinca, ja'ni axpela' lan xanuc' aimicuicomma mixhuej'meyacu, nomana' lema'a tixoj'ma quileta. Ti'iƚa' ma le'a anuli cal xans pe aimihuejma, ja'ni tixhuej'menanni iƚque, xonca acueca' tixoj'ma quileta iƚniya nomana' lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Jouc'a anuli ƚaca'no' i'hueca imbamaj litomí aplata, ja'ni anuli ejac'pa, ¿te aimehueya? Ƚinca tehue'ma. Tunai'i'ma lipepalc'o', titaf'u'ma lejut'ƚ, aga tixinna'ma litomí lejac'pa. ");
INSERT INTO chdNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tixinnaƚa' litomí tijoc'i'mola' liyejmalepa lacaƚ'no' jouc'a nomana' huejnca lejut'ƚ, timi'mola': “Juaiconapa tixoquinghua neta, aixinnapa laitomí lejac'pa. Tunƚouyunca. Ma' anuli tixoj'ma calata.” ");
INSERT INTO chdNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","’Iya' camilhuo': Anuli cal xans pe aimihuejma ja'ni tixhuej'menanni, nomana' pu'hua pe lomana' lapaluc' quema'a tixoj'ma quileta. ");
INSERT INTO chdNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ti'hua timuc'iyale, timila': ―Anuli cal xans timana' oquexi' linaxque'. ");
INSERT INTO chdNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ƚi'hua ƚapepo timi qui'ailli': “Mai'ailli', litine timantso' capenuf'ma ƚai'huexi. Cacua: Lapi'iƚa' itsiya.” Quiƚ'ailli' epi'it'ƚi'mola' loquexi' linaxque' ƚiƚ'huexi. ");
INSERT INTO chdNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","’Uyai'ma oque' fane' quitine ƚi'hua ƚapepo icuj'ma ƚi'huexi ƚepi'impá, ulij'ma litomí. I'hua'ma aculi', ocuenaj camats'. Iƚpe ipajntsi. Ipajnhuo'ma tixoj'ma queta ma mi'ay nixpiya. Ejac'ehuona'ma litomí. ");
INSERT INTO chdNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ijoutsaf'huana'ma, ipanenni ma le'a limane. Jiƚpe ƚamats' i'i'ma cumemma. Ƚamijcano juaiconapa unle'enni. ");
INSERT INTO chdNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ehue'ma quipoujna. Ixim'ma anuli cal xans jiƚpe ƚamats', i'e'ma quipoujna. Ƚapoujna tipa'a ƚemats', umme'ma ƚamijcano ti'etsola' cuenna lijná. ");
INSERT INTO chdNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ƚamijcano tunle'e juaiconapa, tijanaca titeƚa' ƚotecopa lijná. Aiquepi'inni, ni toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Lijou'ma ixhuej'menanni juaiconapa, timiyoxi: “Cai'ailli' timana' axpela' limozó. Jahuay titetsoyi, tijouƚa' tipanemma ƚotecopa. Iya' capa'a fa'a aƚma cumemma. ");
INSERT INTO chdNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Itsiya capainahuo, ca'huana'ma pe lopa'a cai'ailli'. Camita: Mai'ailli', aixina' acueca' lai'epa. Netets'ipa ȽanDios, netets'ipo' ima'. ");
INSERT INTO chdNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Itsiya aimaƚ'onƚico'ma to co'hua. Lapenufla' to comozo.” ");
INSERT INTO chdNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Ipainanni, ti'hua lane ticuainata lejut'ƚ qui'ailli'. Qui'ailli' tehuelonge, ixim'ma ƚi'hua icuaicona'ma aculi'. Ixinna'ma cuanuc'. Inu'ma tepenufnatsi. Litalecuftsi ipulc'o'ma, ituc'o'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ƚi'hua timi: “Mai'ailli', aixina' acueca' lai'epa. Netets'ipa ȽanDios. Netets'ipo' ima'. Itsiya aimaƚ'onƚico'ma to co'hua.” ");
INSERT INTO chdNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Qui'ailli' ijoc'i'mola' limozó, timila': “Toƚtaitsa xonca al c'a lijahua', toƚpo'no'iƚe. Toƚpo'no'iƚe anuli cal anillo limane. Toƚc'uaic'iƚe ƚic'ejí. ");
INSERT INTO chdNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Toƚƚecotsa ƚa'hua huacax ƚifujmpa, toƚma'aƚe. Aƚ'e'me juic. Aƚtetso'me tixoj'ma calata. ");
INSERT INTO chdNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iƚca'a ƚai'hua, iya' cacua: Joupa imanapa. Itsiya imaf'inapa. Iya' cacua: Joupa ejac'pa. Itsiya imaxcainata.” Ipango'ma al juic, tixoqui quileta. ");
INSERT INTO chdNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Cal te'a qui'hua ti'ay canic' pu'hua ƚemats' qui'ailli'. Icuaicona'ma lejut'ƚ. Licuaitsi icuej'ma tunanni, tixahuinni. ");
INSERT INTO chdNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ijoc'i'ma anuli cal mozo, icuis'e'ma, timi: “¿Te conƚ'epa?” ");
INSERT INTO chdNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Cal mozo italai'e'ma timi: “Icuaina'ma ƚopima. Co'ailli' iximpa ailopa'a qui'ipa, aimextafque, toƚiya epenufpa tixoqui queta. Icuxepa ticua: Toƚma'aƚe ƚa'hua huacax ƚifujmpa.” ");
INSERT INTO chdNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Cal te'a qui'hua ixtunni. Aiquitsufaic' lajut'ƚ. Aimicua. Qui'ailli' ipanni. Tixa'hue titsufainaƚa' lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ƚi'hua italai'e'e'ma, timi: “¡Toxinƚa'! Axpe' camats' iya' ca'ay lopenic'. Quihuejcohuo' jahuay laƚcuxe'epa. Ima' aicalapi'i ni toƚta'a. Coƚa' aƚmi'ma: Tolecoƚa' iƚca'a ƚaca'hua chivo, tonƚ'eƚe juic anuli lonƚejmalepa. Aicaƚmic' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Itsiya icuaina'ma ƚo'hua. Iƚquiya inonc'ohuo'mola' lacaƚ'no' notepá liƚcuerpo. Ƚo'huexi ƚomepi'ipa joupa ijou'nehuo'ma. Ima', ¿te co'epa? ¡Oma'apa ƚa'hua huacax ƚifujmpa, titeƚa' iƚquiya!” ");
INSERT INTO chdNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Qui'ailli' timi: “Mai'hua, itine itine aƚmana' anuli. Jahuay ƚai'huexi ima' o'huexi. ");
INSERT INTO chdNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Itsiya tetenƚcocoƚa' tixoj'ma calata. Iƚque ƚopima iya' cacua: Joupa imanapa. Imaf'inapa. Iya' cacua: Joupa ejac'pa. Itsiya imaxcainata.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ipalaic'ocona'mola' ts'ilihuequi, timila': ―Anuli cal xans ts'i'hueca acueca', tipa'a ƚimozo icueya limane, ti'ej cuenna ƚi'huexi ƚipoujna. Lan xanuc' tinesc'eyi cataiqui' cal mozo, ticuayi: “Iƚque, a'ijc'a mi'ay cuenna ƚi'huexi ƚipoujna”. ");
INSERT INTO chdNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Cal xans ijoc'i'ma ƚimozo. Licuaiyunni timi: “¿Te copalaicocopo' toƚta'a iƚnu'hua lan xanuc'? ¿Te co'epa? Totaitsi loje'e. Aipic'a caxinƚa' te co'epa ƚai'huexi. Aimi'hua mo'eya cuenna ƚai'huexi.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Cal mozo timiyoxi: “¿Te caif'eya? Ƚaipoujna liƚonc'e'e'ma laipenic'. Aimi'iya capuya ƚamats'. Ailopa'a caipujfxi. Aimi'iya caxahue'eya al tomí. Catay calaic'ata.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Timiconayoxi: “Joupa aixpic'epa laif'eya. Tijouƚa', ticuaitsi litine ailopa'a caipenic' lan xanuc' lapenuf'ma ƚilejut'ƚi.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Ijoc'i'mola' jahuay iƚne lan xanuc' ts'iƚtaiyinc'e ƚipoujna. Anuli anuli ipalaic'o'mola'. Cal te'a icuis'e'ma, timi: “¿Tojua otaiyinc'e ƚaipoujna?” ");
INSERT INTO chdNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iƚque italai'e'e'ma: “Amaxnu lam tamboj laceite”. Cal mozo timi: “Ja'a iƚta'a loje'e. Tocutshuaiƚa', topai'iƚa' lotaiyinge, ti'iƚa' oquej nuxans quimbama'. Nuya nuya tainiƚƚa'.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ƚocuena icuis'e'ma, timi: “Ima', ¿tojua otaiyinge?” Iƚque italai'e'e'ma: “Anuli maxnu cal cuxtaƚ trigo”. Cal mozo timi: “Ja'a iƚta'a loje'e. Topai'iƚa' lotaiyinge, ti'iƚa' amalpuj nuxans.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’Iƚque cal mozo tama infel'miyale, ƚipoujna imetsaico'ma acueca' lipicuejma'. Lan xanuc' naihuejpá quiƚtuca' liƚpicuejma' xonca iƚsina' te co'iya muyalaicoyacu al c'a. Lan xanuc' joupa lepalc'o'impola' liƚpicuejma' aijtine. ");
INSERT INTO chdNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Iya' camilhuo': Ja'ni tipa'a loƚtomí lolulijpa fa'a li'a ƚamats', toƚtoc'itsola' loƚf'as xanuc'. Toƚta'a tonƚejmale'me. Tijouƚa' tijounaƚa' loƚtomí tepenufinnatolhuo' pe loƚmanc'eyacu nulemma. ");
INSERT INTO chdNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Cal xans ts'ixina' tixhuico'ma ƚi'hueca tama ahuata, ja'ni tixpeƚa' ƚoxhuicoya, jouc'a tixim'ma tixhuico'ma. Cal xans pe aiquixina' mixhuicoya ƚi'hueca, tama ahuata, ja'ni tixpeƚa' ƚoxhuicoya jouc'a aimi'iya quixina' mixhuicoya. ");
INSERT INTO chdNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Imanc' ja'ni aicoƚsina' moƚxhuicoyi al tomí lolulijpa fa'a li'a ƚamats', ¿te aga tepi'im'molhuo' al c'a xonca? ");
INSERT INTO chdNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ja'ni aicoƚsina' coƚxhuijma ƚocuenaj 'huexi, ¿te aga tepi'im'molhuo' coƚtuca' coƚ'huexi? ");
INSERT INTO chdNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Cal mozo ticuicomma ma le'a anuli ƚipoujna. Ja'ni oquexi' tixtuc'o'ma anuli, ƚocuena ti'e'ma capic'a. O tixinc'ne'ma anuli, tetets'i'ma ƚocuena. Imanc' jouc'a ticuicomma ma le'a anuli ƚoƚpoujna, iƚque ȽanDios. Aimi'iya molihuejcoyacu al tomí jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lan xanuc' fariseo, iƚne ts'iƚpic'a juaiconapa al tomí, tiquimf'eyi lonespa Jesús, ixoco'me. ");
INSERT INTO chdNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús timila': ―Loƚf'as xanuc' mixinnilhuo' lonƚ'epa ticuayi: “Ac'a xanuc' lam fariseo”. ȽanDios imetsaicolhuo' te ts'i'ic' loƚpicuejma'. Tipa'a latenƚcocopola' lan xanuc', iƚe ƚinca aimetenƚcocojma ȽanDios. Iƚque tixina ixcay. ");
INSERT INTO chdNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Luyaipa quitine uya'ampá locuxepa ȽanDios jouc'a uya'ampá lonespa lam profeta. Icuaitsi Juan Bautista ipango'ma uya'a'ma te co'iya mitsuflaiyacu pe lopa'a ȽanDios cal Cuecaj Rey. Itsiya ti'hua tuya'anni iƚe lataiqui'. Lan xanuc' tipa'ayi liƚpujfxi titsuflaiƚe jiƚpiya pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ƚinca, tama tipaiconni lema'a jouc'a li'a ƚamats' aimi'iya mipai'inyacu locuxepa ȽanDios, ni ƚainila' aca'hua xonca. ");
INSERT INTO chdNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Cal xans tecanaiƚa' ƚipeno, ja'ni tilecoƚa' ocuena caca'no', iƚque cal xans joupa i'epa quixcay, tipa'a lijunac'. Ma' anuli cal xans ja'ni tilecoƚa' ƚaca'no' ƚecanaiyimpa, iƚque cal xans jouc'a i'epa quixcay, tipa'a lijunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Anuli cal xans ts'i'hueca acueca' tipo'nohuo ac'a juaiconapa lipijahua', umanc'ecompa amorada, xonca acueca' lipitali. Itine itine titeja quitejua' xonca cal c'a. ");
INSERT INTO chdNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jouc'a tipa'a anuli cal xans pe ailopa'a qui'hueca, cuftine aLázaro. Tunouya liju' lipuerta lejut'ƚ cal xans ts'i'hueca. Licuerpo titeja lahui. ");
INSERT INTO chdNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tunle'e. Ticua: “Iƚque ts'i'hueca coƚa' cateƚa' ƚacangemma limesa ƚotecopa”. Lan tsiƚqui tiƚcuaispa tipeƚc'e'eyi lehui. ");
INSERT INTO chdNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lijou'ma imana'ma Lázaro, iƚque aiqui'hueca. Lapaluc' quema'a ileconanca, icuai'etsa pe lopa'a Abraham, mane liju' iƚque. ’Cal xans ts'i'hueca acueca', jouc'a imana'ma. Eminghuo'me. ");
INSERT INTO chdNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Icuaitsi pe loteƚcoyopa locuenaye limanapola', jouc'a iteƚco'ma juaiconapa. Ehuelojm'ma al toncay. Aculi' ixim'mola' Abraham jouc'a Lázaro. Iƚque Lázaro ac'a mipa'a, mane liju' Abraham. ");
INSERT INTO chdNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ijoc'i'ma Abraham, timi: “Mai'ailli' Abraham, aƚsinƚa' nincuanuc'. Tommeƚa' Lázaro, ti'huanni fa'a. Ti'nij'mita laja' lidedo, aƚjac'e'e'ma ƚaipaƚ. Toƚta'a titinu'ma ƚumla cateƚma jifa'a ƚunga aƚpi'e.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham italai'e'e'ma, timi: “Mai'hua, to'nujuaitsi lomuyaicopa mopa'a jiƚpe li'a ƚamats'. Ima' o'hueca jahuay al c'a, iƚca'a Lázaro aiqui'hueca, ma' iteƚcopa. Itsiya iƚca'a tixoquinghua queta, ima' toteƚma. ");
INSERT INTO chdNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jouc'a cami'mo': Tipa'a al cueca' lina lateƚnufinna. Nomana' fa'a, tama iƚpic'a tuyalaiƚe, ticuaitsa pe loƚmana', aimi'iya muyalaiyacu. Jouc'a imanc' aimi'iya moƚcuaiyacu fa'a pe laƚmana'.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Italai'e'e'ma, timi: “Mai'ailli', caxahue'ehuo' tommeƚa' Lázaro ti'huaƚa' lejut'ƚ cai'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Jiƚpiya timana' amajxi laipimaye. Timitsola' te ts'i'ic' laifnuyaicopa. Aimicuaicu jouc'a fa'a pe laifteƚcoyopa.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham italai'e'e'ma, timi: “Tipa'a lije'e liniƚijmpa Moisés jouc'a liƚje'e liniƚijmpa lam profeta. Tiquimf'etsa lataiqui' jiƚpe liniƚingiya.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Timi: “A'i, mai'ailli' Abraham. Ti'huaƚa' anuli ƚicuai'ma fa'a pe laƚmana' illanc' laƚmanaponga', toƚta'a laipimaye tixhuej'mecu.” ");
INSERT INTO chdNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham timi: “Ja'ni aimihuejyi liƚtaiqui' Moisés jouc'a lam profeta, tama anuli ƚimanapa timaf'iconƚa', ti'huaƚa' tipalaic'otsola', iƚniya aimihuejyacu.” ");
INSERT INTO chdNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús timila' ts'ilihuequi: ―Micoƚi li'a ƚamats' timajm'me lan xanuc' naimenac'iyalepa. A'ijc'a loyalaicoyacu iƚniya no'epá toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Cal xans naimenac'iyacola', tama ma le'a anuli iƚna'a laica'uhuay, coƚa' ifinc'im'me ƚejoc' anuli cal cuecaj capic molino, coƚa' ecajm'mintsa ƚaja, tunxaƚac'la' nulemma, timatsi. ");
INSERT INTO chdNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Imanc' toƚ'etsoƚtsi cuenna. Toƚspic'eƚe tonƚ'eƚe ma le'a al c'a. ’Ja'ni a'ijca li'epo' ƚopima, ima' tomiƚa': “Toƚta'a laƚ'epa aimaƚ'econa'ma”. Tijouƚa', ja'ni tixhuej'menanni taimenc'e'ecoƚa' iƚe li'epo'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ja'ni ti'hua ti'ehuo', tama anuli litine tixhuaitsi acaitsi, ja'ni jouc'a ti'hua tixa'huehuo' acaitsi, timihuo': “Ƚinca aixhuej'menamma iƚe lai'epo', limenc'e'ecoƚa'”, ima' taimenc'e'ecoƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ts'ilihuequi Jesús timiyi ƚiƚPoujna: ―Aƚtoc'itsonga', xonca aƚ'huaiyijnle. ");
INSERT INTO chdNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Timila': ―Imanc' ja'ni aimi'iya moƚ'huaiyijnyacu acueca', tama iƚe loƚ'huaiyijmpa tocomma ahuata, ti'onƚcospa to cal fanu' xonca aca'hua cuftine sinapí, ti'i'ma toƚ'e'me acueca'. Toƚcuxe'e'me iƚta'a al 'ec sicómoro, toƚmi'me: “Toyax‑xoxi, tofaxoxi pu'hua ƚaja”. Tijouƚa' iƚe al 'ec tihuejco'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Imanc', ticuainanni lajut'ƚ ƚoƚmozo, joupa i'ehuo'ma canic', epahuo'ma ƚamats', i'ehuo'ma cuenna lan huacax jiƚpe ƚolamats', ¿te coƚmiyacu cal mozo? ¿Te toƚmi'me: “Ne', tocutshuaiƚa', totetsoƚa'”? ");
INSERT INTO chdNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A'i toƚta'a moƚmiyacu. Xonca toƚmi'me: “Tomac'eƚa' ƚaifteja. Toc'ejmot'ƚiƚa' cal pime. Catetso'ma, caxna'ma. Tijouco'ma ima' totetso'ma, toxna'ma.” ");
INSERT INTO chdNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Te toƚs'najtsi'i'me ƚoƚmozo li'epa loƚcuxe'epa? Iya' cacua: Amoƚs'najtsi'iyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Imanc' ti'onƚcospolhuo' to lam mozó. Tolihuejco'me jahuay locuxe'epolhuo' ȽanDios. Tijouƚa' toƚmi'me: “Iya' le'a ninmozo. Ai'epa ma le'a laƚcuxe'epa.” ");
INSERT INTO chdNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús ti'hua lane ticuaita Jerusalén. Tuyaijma pe loniquecomma al distrito Galilea jouc'a ƚilemats' lun Samaria. ");
INSERT INTO chdNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma micuaispa anuli liƚya' italecuf'mola' imbamaj lan xanuc' textafquila', ƚiƚcuana ahui cuftine lepra. ");
INSERT INTO chdNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ecaxoƚ'me aculi', tija'ayi, timiyi: ―CumJesús, momxi, aƚsintsonga' ninc'icuanuc'la. ");
INSERT INTO chdNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús timila': ―Tonƚenƚe. Toƚmujtsoltsi jipu'hua pe lomana' la'aillí. Miyenayi lane ixaƚcona'mola'. I'ina'mola' limpio. ");
INSERT INTO chdNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Anuli iƚniya lixim'moxi ixaƚconapa ipaiconanni, tija'e', tipalay ujfxi, tix'najtsi'i ȽanDios, timi: ―ManDios, aƚ'epa acueca'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Icuaitsi pe lopa'a Jesús, ixpats'huai'ma li'mitsi', timi: ―X'najtseco'. Iƚque cal xans ƚas Samaria. ");
INSERT INTO chdNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús ticua: ―¿Te aiquixaƚcola' imbamaj lan xanuc'? Ma le'a anuli fa'a icuaicona'ma. ¿Pe comana' locuenaye lam pelƚa? ");
INSERT INTO chdNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ma le'a iƚca'a cal xans ipaiconamma tix'najtsi'i ȽanDios? Iƚque ocuena quipiƚya', ƚas Samaria. ");
INSERT INTO chdNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Timi cal xans: ―Totsahuenni, to'huanƚa'. Aƚ'huaiyijmpa, toƚta'a joupa ixaƚconapo'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Lijou'ma lan xanuc' fariseo icuis'e'me, timiyi Jesús: ―¿Te 'hora aƚsim'me ȽanDios cal cuecaj Rey ticuxe'mola' lixanuc'? Jesús italai'e'e'mola', timila': ―Tama imanc' aimoƚsinyi, itsiya ƚinca ȽanDios ticuxela' lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aimi'iya molu'iyacola' lan xanuc': “¡Tolahuelojnle! Jifa'a ȽanDios ticuxela' lixanuc'.” Jouc'a aimi'iya molu'iyacola': “¡Tolahuelojnle! Ƚu'hua ticuxela' ȽanDios lixanuc'.” Jifa'a pe loƚmana' ȽanDios ti'hua ticuxela' lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Timila' ts'ilihuequi: ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ticuaihuo litine imanc' toƚjanaj'me juaiconapa aƚsinƚa'. Toƚnes'me: “Tama anuli litine aƚmajnle anuli”. Aimaƚsinya. ");
INSERT INTO chdNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lan xanuc' timi'molhuo': “Fa'a copa'a”, o “Pu'hua copa'a”. Toƚmanenca. Aimalahue'ma. A'ij ƚinca iƚta'a lominyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mixcuaf'ma tepalc'o'i a'i ma le'a jiƚpe lo'huayomma. Iƚe lepalc'o' tixinyi ni petsi li'a ƚamats'. Toƚta'a ti'i'ma cacuaicohuananni iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iƚe litine aƚsim'ma jahuay lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","’Ate'a cateƚco'ma juaiconapa. Lan xanuc' nomana' itsiya litine latets'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Ma to li'ipa iƚniya ƚitiné lipajmpa Noé jifa'a li'a ƚamats', ma toƚta'a ti'i'ma litine cacuaiconanni iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Milanc'e Noé al cuecaj barco lan xanuc' tuyalaicoyi lapajnya, titetsoyi, tixnayi, temalƚiyi, ticuyi liƚnaxque' temalƚiƚe. Litine litsufai'ma Noé al cuecaj barco ma' anuli mi'eyi. Aiquicoƚ'ma. Icui'ma ƚaxpaiqui' cacui, ijou'ne'mola' jahuay lan xanuc', ima'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","’Mipa'a Lot jifa'a li'a ƚamats' ȽanDios iteƚ'mi'mola' lan xanuc'. Iƚniya tuyalaicoyi lapajnya, titetsoyi, tixnayi, ti'naji, ticujyi, tifayi, tilanc'eyi quilejut'ƚi. ");
INSERT INTO chdNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Litine Lot lipanni jiƚpe liƚya' Sodoma, maƚe litine, icui'ma cunga, icui'ma azufre. Ima'a'mola' jahuay, acueca' caxpaiqui' i'i'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","’Toƚta'a ti'onƚcospa to lo'iya litine cacuaiconanni jifa'a li'a ƚamats'. Aƚsim'ma naitsi iya', iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Iƚe litine ja'ni anuli if'ajnapa al toncay lejut'ƚ, aimines'ma: “Quimuhuananni, quipa'ahuatsi ƚai'huexi”. Aimicoƚ'ma. Tinuƚa'. Jouc'a ja'ni anuli i'huapa ti'eta canic' ƚimuc'o', aimipaihuo, aimines'ma: “Capulaf'nata laipo'nopa ƚu'hua”. ");
INSERT INTO chdNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Toƚ'nujuaisle li'ipa ƚipeno Lot. ");
INSERT INTO chdNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","’Cal xans no'epoxi cuenna, nocuapa: “Cuyaicoƚa' al c'a lapajnya”, iƚque tejac'e'moxi. Cal xans nocupoxi lateƚcoya, tama a'ijc'a loyaicopa lapajnya, iƚque tunƚu'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Iya' camilhuo': Iƚe lipuqui' ja'ni tunahuoƚanna oquexi', tixmaiyi anuli al hualfa, tileconam'me anuli, ƚocuena tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jouc'a lacaƚ'no', ja'ni oquexi' anuli mutsiyi, anuli tileconam'me, ƚocuena tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ja'ni oquexi' lan xanuc' tiƚmana' ƚimuc'o' anuli tileconam'me, ƚocuena tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ts'ilihuequi icuis'e'me Jesús, timiyi: ―Maƚpoujna, ¿pe co'iya toƚta'a? Italai'e'e'mola', timila': ―Pe ƚopa'a ƚimac', jiƚpiya lapote tefoƚyomma. ");
INSERT INTO chdNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús ti'hua timuc'ila' ts'ilihuequi, tu'ila': ―Ti'hua toƚjoc'iƚe ȽanDios, toƚta'a aimitafqueyacolhuo'. I'onƚicopa li'ejma' anuli ƚaca'no' apotsate. ");
INSERT INTO chdNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Timila': ―Anuli liƚya' tipa'a anuli cal juez aimixpaic'e ȽanDios ni aimixpaic'ela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Maƚpe liƚya' tipa'a anuli ƚaca'no' apotsate. Itine itine ticuaiyumma pe lopa'a cal juez. Tixa'hue, timi: “Aƚtoc'iƚa'. Toteƚ'miƚa' ƚalixtuc'opa.” ");
INSERT INTO chdNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","’Muyaipa axpe' quitine cal juez aimicua mitoc'iya. Lijou'ma timiyoxi: “Tama aicaxpaic'e ȽanDios ni aicaxpaic'ela' lonespa lan xanuc', ");
INSERT INTO chdNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","catoc'i'ma iƚca'a cal potsate caca'no' nocuaiyumma itine itine. Cateƚ'mi'ma iƚque ƚaixtuc'opa. Ja'ni a'i, ti'hua ticuaihuo, aicaxnet'ƚya.” ");
INSERT INTO chdNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ȽaƚPoujna Jesús timila' ts'ilihuequi: ―Joupa oƚcuejpá iƚe litaiqui' locuapa cal juez. Iƚque tama a'ij ƚijca li'ejma' itsiya ticua: “Catoc'i'ma iƚca'a ƚaca'no'”. ");
INSERT INTO chdNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Jouc'a ȽanDios, ¿te aimitoc'iyacola' lixanuc', li'huijf'epola'? Iƚniya tijoc'iyi itine ipuqui' tixa'hueyi titoc'itsola'. Ƚinca ȽanDios aimixtuc'oyacola', ti'hua tixnet'ƚqui. Iya' camilhuo': Aimicoƚya, titoc'i'mola'. Titeƚ'mi'mola' laixtuc'opá lixanuc'. ’Tama aƚinca iƚta'a laimipolhuo', cacuaicohuananni li'a ƚamats', ¿te ti'i'mola' axpela' lan xanuc' nepenufpá iƚe laitaiqui' laifnu'ipolhuo' itsiya? Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús ti'hua timuc'iyale. I'onƚico'mola' lan xanuc' nocuapá: “Illanc' ma ninc'ic'a xanuc'”. Iƚne tetets'iyi liƚf'as xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Timila': ―Oquexi' lan xanuc' iye'me al cuecaj xoute', tipalaic'ota ȽanDios. Anuli afariseo, ƚocuena in'najtsi'iyale. ");
INSERT INTO chdNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Cal fariseo tecaxuya tu'i ȽanDios jahuay lo'epa, timi: “ManDios, iya' cax'najtsi'ihuo' iya' aica'ay to lo'epa locuenaye lan xanuc'. Iƚniya tinantseyi, ti'eyi a'ij ƚijca, texic'e'eyi liƚf'as xanuc' liƚpenoye. Iya' a'i to iƚniya ni to iƚca'a ƚin'najtsi'iyale. ");
INSERT INTO chdNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iya' oque' quitine al xamano caxnet'ƚqui, aicatesma. Laifnulijpa amaxnu capequi, capi'ihuo' imbama'.” ");
INSERT INTO chdNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Ƚin'najtsi'iyale tixina calaic'ata, tecaxu lico al xoute'. Ni aiquehuelonge lema'a, tixhueƚma juaiconapa, tuntafque ƚunxajma'. Timi ȽanDios: “MainenDios, tama tipa'a acueca' laijunac', amalixtuc'o'ma. Aƚsinƚaj cuanuc'.” ");
INSERT INTO chdNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Iya' camilhuo': Lipalnamma al cuecaj xoute' iƚniya loquexi' lan xanuc', liyenapá ƚilejut'ƚi, ȽanDios joupa iximpa ƚin'najtsi'iyale to ailopa'a quijunac', epenufpa. Ƚocuena a'i. ’Cal xans no'e'epoxi acueca', ti'oc'enam'me. Ja'ni ti'oc'exoxi, tiƚof'em'me. ");
INSERT INTO chdNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lan xanuc' tiƚcuai'emma liƚnaxque' pe lopa'a Jesús. Iƚpic'a tixpayaf'tsola'. Liximpa toƚta'a ts'ilihuequi Jesús aiquetenƚcoco'mola' lo'epa iƚne lan xanuc'. Italem'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús ijoc'i'mola' ticuaiyunca la'uhuay. Timila' ts'ilihuequi: ―Tolapi'itsola' lane la'uhuay, tiyouyunca pe laifpa'a. Aimoƚcuanac'e'mola'. Lan xanuc' lo'onƚcospola' to iƚna'a la'uhuay maƚniya titsuflai'me pe locuxeyopa ȽanDios cal Cuecaj Rey. ");
INSERT INTO chdNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iya' camilhuo' al ƚinca: Lan xanuc' notsulfoƚaiyacu pe locuxeyopa ȽanDios cal Cuecaj Rey, ticuicomma ti'onƚcotsola' to la'uhuay. Ja'ni a'i aimi'iya mitsuflaiyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Anuli ƚincuxepa ipalaic'o'ma Jesus, icuis'e'ma, timi: ―Momxi, ima' unc'a xans, lu'iƚa', ¿te caif'eya culijla' laipitine aimijouya? ");
INSERT INTO chdNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús italai'e'e'ma timi: ―Ima', ¿te caƚmicuapa: “Unc'a xans”? Le'a anuli copa'a cal C'a, iƚque ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ima' oxina' loya'apa locuxepa ȽanDios, ticua: “Aimoxhuico'ma ƚipeno ƚof'as xans. Aimoma'ahuale'ma. Aimonantse'ma. Aimonescoyale'ma. Taihuejco'mola' co'ailli', co'máma'. Totoc'i'mola'.” ");
INSERT INTO chdNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Cal xans timi: ―Laƚtojyomma iƚe lataiqui' canant'ƚi. Itsiya ixpic' ca'ay toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Licuej'ma limi'ma cal xans, Jesús timi: ―Tehue'ehuo' huata. Jahuay ƚo'hueca tocujtsi. Al tomí lofmulijya tapi'itsola' lan xanuc' pe aiquiƚ'hueca. Toƚta'a ti'i'ma acueca' co'huexi pu'hua lema'a. To'etsi to laifmipo', tijouƚa' tocuaiconamma lihuejna'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Licuej'ma jiƚiya lataiqui' cal xans ihuotsonni juaiconapa. I'hueca acueca' qui'huexi. ");
INSERT INTO chdNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Liximpa cal xans ihuotsonni, Jesús ticua: ―Lan xanuc' ts'iƚ'hueca acueca' quiƚ'huexi tixim'me ipime, afule mitsuflaiyacu pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ticuanni: “Anuli cal camello, iƚque ƚinneja juaiconapa acueca', aimi'iya muyaicoya laquipihuo ƚacuxa”. Cal xans ts'i'hueca acueca', ti'i'ma xonca ipime, afule mitsufaiya pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Licuej'me iƚiya lataiqui' iƚniya timiyoƚtsi: ―Ja'ni toƚta'a, ailopa'a conƚuya. ");
INSERT INTO chdNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús italai'e'e'mola', timila': ―Tama lan xanuc' aimi'iya mi'eyacu, ȽanDios ƚinca nipajnya ti'i'ma ti'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro timi: ―¡Toxinƚa'! Illanc' joupa aƚpo'nonapá jahuay ƚaƚ'huexi. Lihuejnahuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesús timila': ―Iya' camilhuo' al ƚinca: Cal xans naihuejcopa ȽanDios ja'ni tipo'noƚa' lejut'ƚ o ƚipeno, o tipo'no'mola' lipimaye, qui'ailli', qui'máma' o linaxque', mipa'a fa'a li'a ƚamats' tepi'im'me acuecaj xonca. Tijouƚa', ticuaitsi locuena quitine tulij'ma lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Lijou'ma Jesús ileco'mola' quiƚtuca' limbamaj coquexi' ts'ilihuequi, timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Luyaipa quitine lam profeta iniƚpá laƚ'iya. Itsiya aƚf'ajliyi, aƚcuaitsa liƚya' Jerusalén, pu'hua jahuay iƚe lataiqui' tenanƚta. ");
INSERT INTO chdNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aƚcunna, ticuaita quiƚmane lan xanuc' ocuena nación. Lilotsocota, aƚmilojta cataiqui', aƚtsuƚcota lai'a, ");
INSERT INTO chdNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","luntafta f'ix'ec, aƚma'ata. Al fane' quitine camaf'inna. ");
INSERT INTO chdNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ts'ilihuequi aiquiƚcueca iƚe lataiqui' limi'mola'. Aimuhuaƚyi, aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús joupa ticuaispa huejnca liƚya' Jericó. Jiƚpe tipa'a anuli cal fo' ticutsu lema cane, tixa'hue tepi'inƚe caquitomí. ");
INSERT INTO chdNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Icuej'ma tuyalaiyi axpela' lan xanuc', icuis'e'mola', timila': ―¿Te co'ipa? ");
INSERT INTO chdNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Italai'e'e'me, timiyi: ―Icuai'ma Jesús ƚas Nazaret, joupa tuyaipa. ");
INSERT INTO chdNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Cal fo' ija'a'ma, timi: ―Jesús, ima' ƚacui'impo' i'Hua David, ¡Aƚsinƚa' nincuanuc'! ");
INSERT INTO chdNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lan xanuc' liƚej'me timiyi: ―¡Ti‑ch'ixcotso'! Xonca tija'e', timi: ―Mi'Hua David, ¡aƚsinƚa' nincuanuc'! ");
INSERT INTO chdNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús ecaxhuenni, icuxe'ma, timila': ―Aƚƚec'metsi. Icuai'etsa pe lopa'a Jesús. Iƚque icuis'e'ma, timi: ");
INSERT INTO chdNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Te caif'e'eyaco'? ¿Te ts'opic'a? Timi: ―Maipoujna, cahuetsaleƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús timi: ―¡Tahuetsaleƚa'! Aƚ'huaiyijmpa, joupa ixaƚconapo'. ");
INSERT INTO chdNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aiquicoƚ'ma, ehuetsalena'ma. Ipango'ma ihuej'ma Jesús. Tix'najtsi'i ȽanDios. Jahuay nomana' jiƚpiya, liximpa toƚta'a jouc'a ix'najtsi'i'me ȽanDios. Ticuayi: “Acueca' lo'epa ȽanDios”. ");
INSERT INTO chdNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús itsufai'ma liƚya' Jericó, uyaicohuo'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jiƚpe liƚya' tipa'a anuli cal xans cuftine aZaqueo. Iƚque cal xans nocuxepola' lif'as xanuc' quin'najtsi'iyalepá. Acueca' qui'huexi i'hueca. ");
INSERT INTO chdNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tehuay te co'iya mixinya Jesús. Ipic'a timetsaicoƚa'. Jesús ti'hua nolojmay axpela' lan xanuc', Zaqueo aca'hua xans. Tixina aimi'iya mixinya. ");
INSERT INTO chdNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Inu'ma, i'huaj'me'ma. If'aj'ma anuli al 'ec sicómoro. Jiƚpiya tuyaico'ma Jesús. Tixim'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús icuaitsi jiƚpiya, ehuelojm'ma al toncay al 'ec. Ipalaic'o'ma, timi: ―CumZaqueo, nuya taimunni. Itsiya ai'huapa lomejut'ƚ, cunxac'eta. ");
INSERT INTO chdNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo aiquicoƚ'ma, imunni. Ixoj'ma queta juaiconapa. Jiƚpe lejut'ƚ epenuf'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lan xanuc' lixim'me toƚta'a li'i'ma ixtulenca jahuay, tipalaicoyi lo'epa Jesús, tinesyi: ―Iƚque cal xans Zaqueo aimihuejma locuxepa ȽanDios, Jesús itsufaipa lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo ecax'ma, ipalaic'o'ma ƚaƚPoujna Jesús, timi: ―Toxinƚa', maipoujna, itsiya onƚca ƚai'hueca capi'ina'mola' lan xanuc' pe aiquiƚ'hueca. Naitsi cal xans ƚaifel'mipa, nexic'epa litomí, capi'icona'ma amalpemma. ");
INSERT INTO chdNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús mehuelonge Zaqueo ticua: ―Itsiya jifa'a lajut'ƚ unƚupa anuli cal xans, iƚque jouc'a i'hua ƚoƚtatahuelo Abraham. ");
INSERT INTO chdNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aicuaicoco'ma fa'a li'a ƚamats' cahue'mola', cunƚu'e'mola' lan xanuc' lejac'pola'. ");
INSERT INTO chdNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Miquimf'eyi lan xanuc', Jesús ti'hua timuc'iyale. Iƚniya lan xanuc' ticuayi: “Liƚya' Jerusalén a'ij culi'. Ticuaitsi jiƚpiya Jesús tulijtola' laƚ'eponga' laic'. Tijouƚa' illanc' y ȽanDios aƚcux'e'me anuli.” Jesús ipic'a ti'iƚa' quiƚsina' a'ij ƚinca iƚe lonespa. I'onƚico'moxi lo'iya, ");
INSERT INTO chdNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","timila': ―Anuli cal xans iƚque i'hua ƚincuxepa i'huapa aculi', ocuenaj nación. Jiƚpiya tepi'inna lipenic'. Tijouƚa' tipaino, ticuxena'mola' lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ai'a tipahuo ijoc'i'mola' limbamaj limozó. Anuli anuli epi'i'mola' quiƚtomí, lipitali to cal xans lolijpa no'eya canic' afanej mut'ƚa. Timila': “Iya' aicapajnya, ma cai'huayaic' aculi' imanc' toƚsuicoƚe iƚta'a al tomí”. ");
INSERT INTO chdNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Liƚpiƚya' xanuc' ixtuc'o'me cal xans. Ummem'mola' lan xanuc' tiyeƚe pe litsepa, tuya'ata: “Iƚque cal xans aimalapenufyacu. Aimaƚcuxeyaconga' illanc'.” ");
INSERT INTO chdNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Cal xans, epi'impa lipenic' ticuxetsola' lixanuc', ipaiconanni. Licuaitsi ƚemats' icuxe'ma tijoc'intsola' limozó, iƚne nepenufpá al tomí. Tixim'ma lulijpa. ");
INSERT INTO chdNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","’Icuaiyunni cal te'a. Timi ƚipoujna: “Maipoujna, lotomí lalapi'ipa joupa ulijpa imbama'”. ");
INSERT INTO chdNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Timi: “Ima' unc'a mozo. Ac'a lo'epa. Ahuata lainepi'ipo'. Oxhuicopa ac'a. Itsiya capi'i'mo' imbamaj ƚiƚeloƚya', tocuxetola' lan xanuc' nomana' jiƚpe ƚiƚeloƚya'.” ");
INSERT INTO chdNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","’Icuaiyunni ƚocuena, timi ƚipoujna: “Maipoujna, lotomí lalapi'ipa joupa ulijpa amaque'”. ");
INSERT INTO chdNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jouc'a epi'i'ma lipenic'. Timi: “Ima' jouc'a capi'i'mo' copiƚeloƚya'. Tocuxetola' lan xanuc' nomana' jiƚpe lam maquej ƚiƚeloƚya'.” ");
INSERT INTO chdNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Lijou'ma icuaiyunni ƚocuena. Timi ƚipoujna: “Toxinƚa', maipoujna, jiƚta'a lotomí. Ai'huejpa. Aifi'ecopa ijahua'. ");
INSERT INTO chdNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Cai'ecopa caxpaic'ehuo'. Aixina' ima' unxans maftsile. Ni toƚta'a aimocu, ma le'a tapenuf'ma. Aimofa, ma le'a tafot'ƚe'ma.” ");
INSERT INTO chdNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Timi: “Ima' mixcay mozo. Maƚta'a lonespa joupa mecani'epoxi. ¿Te ima' oxina' iya' ninxans naftsile? ¿Te al ƚinca iya capenufi tama aicacu? Jouc'a, ¿te cafot'ƚe tama aicafa? ");
INSERT INTO chdNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Joupa oxina' toƚta'a. Itsiya iƚta'a laitomí, ¿te aicomecana al banco? Toƚta'a coƚa' capenufna'ma laitomí jouc'a lulijpa.” ");
INSERT INTO chdNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Timila' lixanuc' nacaxhuoƚanna jiƚpiya: “Tolaxic'eƚe al tomí, tonlapi'iƚe iƚque ts'i'hueca limbama'”. ");
INSERT INTO chdNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Iƚne italai'e'e'me, timiyi: “Maƚpoujna, joupa i'hueca imbama'”. ");
INSERT INTO chdNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Italai'e'e'mola', timila': “Iya' camilhuo': Jahuay iƚne nulijpá, tepi'im'mola' xonca. Lan xanuc' pe aiquiluliqui, texic'ena'mola' liƚ'hueca. ");
INSERT INTO chdNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Itsiya, toƚ'hua'ancola' fa'a pe laifpa'a lan xanuc' nalixtuc'opa iƚniya nocuapá: Iƚque cal xans aimalapenufyacu, aimaƚcuxeyaconga'. Toƚma'atsola'.” ");
INSERT INTO chdNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lijoupa limipola' jiƚe lataiqui', ti'hua tuyaipa. Tif'aqui lane Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Icuaitsi ƚijuala cuftine Ƚijuala Olivo, ahuejnca ƚiƚeloƚya' Betfagé jouc'a Betania. Jiƚpiya umme'mola' oquexi' ts'ilihuequi, ");
INSERT INTO chdNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","timila': ―Tonƚeƚe jiƚpe liƚya' lehuoc'ocojma. Jiƚpiya loƚtsuflaiyacu toƚsinna tifijnya anuli ƚaca'huaj burro. Nij naitsi xans ƚenafcaipa. Toluhuaiƚtsa, toƚcuai'ecu fa'a. ");
INSERT INTO chdNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ja'ni ticuis'etsolhuo', timitsolhuo': “¿Te cunluhuaiƚcopá ƚa'huaj burro?”, toƚmitsa: “Ƚipoujna tixhuicota”. ");
INSERT INTO chdNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iye'me iƚne loquexi' lummem'mola', ixintsa ƚaca'huaj burro ma to limipola' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Muhuaiƚyi ƚaca'huaj burro lipoujnalá ipalaic'om'mola', timinnila': ―¿Te cunluhuaiƚcopá ƚala'huaj burro? ");
INSERT INTO chdNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Italai'e'e'me, timiyi: ―Ƚipoujna ipicuicoya tixhuicota. ");
INSERT INTO chdNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Icuai'etsa ƚaca'huaj burro pe lopa'a Jesús. Ixpefi'me liƚpuquiya lixpula' ƚa'huaj burro. Jesús enafcai'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pe loyaicoya, lan xanuc' ixpou'me liƚpuquiya. ");
INSERT INTO chdNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Icuaitsa huejnca jiƚpe laimuc' ƚijuala Olivo, lanxpela' ts'ilihuequi Jesús iƚejmale ixoj'ma quileta. Jahuay ipango'me ija'a'me, tix'najtsi'iyi ȽanDios. Joupa iximpá al cueca' li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ticuayi: ―¡Itsiya ocuai'ma ima' aƚRey! Joupa lu'imponga' tocuaihuo, aƚminga' ȽanDios ƚaƚPoujna tumme'mo'. ¡Itsiya ocuai'ma! ¡Aƚs'najtsi'ihuo' juaiconapa! ¡ȽanDios Nopa'a lema'a aimalixtuc'oconayaconga', aƚpaxnenga'! ¡Nomana' lema'a xonca al toncay timiƚe: “Ima' xonca umCueca'”! ");
INSERT INTO chdNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jiƚpe pe lomana' lan xanuc' jouc'a timana' lam fariseo. Iƚniya timiyi Jesús: ―Momxi, to‑ch'ixc'etsola' iƚne ts'ihuejhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús italai'e'e'mola', timila': ―Iya' camilhuo': Ja'ni ti‑ch'ixcotsola' lalihuequi', lapic' tija'a'me, tix'najtsi'i'me ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iƚoc'oƚai'me xonca Jerusalén. Lixim'ma liƚya' Jesús ijoj'ma, ");
INSERT INTO chdNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","timi: ―Iya' caxhueƚcocojma iƚe lo'iyaco', miƚya' Jerusalén. Itsiya ȽanDios ipic'a tipaxnetsola' loxanuc'. Ipic'a titoc'itsola', tuyalaiƚe al c'a. ¡Coƚa' ticuec'eƚe! Aimi'iya micuec'eyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ticuaita litine ticuaicu laixtuc'opo'. Tejuajmi'me camats' lixpula' ƚomitaƚ. Tilanc'e'me lof'ajcoyacu. Tipa'nem'me canumicay, loxanuc' ailopa'a caipalcoyacu. ");
INSERT INTO chdNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Laixtuc'opo' tif'ajli'me ƚomitaƚ, teca'not'ƚi'me ƚomitalot'ƚ, jouc'a loxanuc'. Laixtuc'opo' tijou'ne'mo' nulemma. Ni anuli ƚapic mipo'nof'queya ƚocuena capic. ȽanDios joupa icuai'ma coƚa' tipaxnetso'. Ima' aicoxingufi toƚta'a lo'eya, aicocuac'. Toƚiya titeƚ'mi'mo' to laifmipo'. ");
INSERT INTO chdNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lijou'ma Jesús itsufai'ma al cuecaj xoute' lopa'a Jerusalén. Jiƚpe ipa'a'mola' nocucalepá. ");
INSERT INTO chdNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Timila': ―El Paxi Liniƚingiya tuya'e': “Lainejut'ƚ lecui'impa: Lajut'ƚ petsi lan xanuc' tipalaic'oyo'me ȽanDios.” Itsiya imanc' tonƚ'onƚicoyi iƚta'a lajut'ƚ to ƚunts'eja' lafoƚyomma lan namats'. ");
INSERT INTO chdNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Itine itine Jesús ti'hua al cuecaj xoute'. Timuc'ila' lan xanuc'. Lixanuc' cal cuecaj ca'ailli', lomxiye nomuc'iyalepá locuxepa ȽanDios jouc'a lan tsilaj xanuc' noxpijpá lataiqui', tehueyi te co'iya mima'ayacu Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aiquiƚsina' te co'eyacu. Jahuay lan xanuc' icuaitsi quiƚpic'a litaiqui' Jesús, tipo'noyi cuenna lomuc'iyalepa. ");
INSERT INTO chdNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Anuli litine mipa'a Jesús al cuecaj xoute' timuc'ila' lan xanuc', tu'ila' Lataiqui' loya'apa iƚe al c'a loxpic'epa ȽanDios. Jiƚpiya icuaiyunca lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios, jouc'a lan tsilaj xanuc' noxpijpá lataiqui'. Icuaitsa pe lopa'a Jesús, ");
INSERT INTO chdNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","icuis'e'me, timiyi: ―¿Naitsi nepi'ipo' lomane toƚta'a to'e'ma? ¿Naitsi nummepo'? ");
INSERT INTO chdNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús italai'e'e'mola', timila': ―Iya' jouc'a tipa'a laifnicuis'eyacolhuo'. Aƚtalai'eƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Naitsi nummepa Juan? ¿Naitsi nicuxe'epa tepo'itsola' lan xanuc'? ¿Ja'ni ȽanDios? o ¿anuli cal xans? ");
INSERT INTO chdNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iƚne ipalaic'o'moƚtsi quiƚtuca', timiyoƚtsi: ―¿Te caƚmiyacu? Ja'ni aƚmiƚe: “ȽanDios ummepa”, alicuis'e'monga', aƚmi'monga': “Imanc', ¿te aicolapenufi Juan?” ");
INSERT INTO chdNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ja'ni aƚmiƚe: “Anuli cal xans nummepa”, lan xanuc' aƚma'aco'monga' apic'. Iƚne ticuayi Juan aprofeta. Ticuayi ȽanDios ummepa. ");
INSERT INTO chdNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Italai'e'e'me, timiyi: ―Illanc' aicaƚsina' naitsi nummepa. ");
INSERT INTO chdNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Italai'e'e'mola' Jesús, timila': ―Iya' jouc'a aicu'iyacolhuo' naitsi nalapi'ipa laimane ca'eƚa' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ipango'ma ipalaic'ocona'mola' lan xanuc'. I'onƚicopola' iƚniya ts'iƚpenic' lan judío, timila': ―Anuli cal xans ifapaj 'uva ƚemats'. Hualca lan xanuc' epi'i'mola' lane ti'eƚe canic'. Tijouƚa' lanic', tijouƚa' tefot'ƚeƚe, tepi'ina'me onƚca ƚipammaita. ’Ƚapoujna camats' i'hua'ma aculi'. Jiƚpe icoƚhuo'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Icuaitsi litine tefot'ƚeƚe umme'ma anuli ƚimozo, ti'huaƚa' titaita ƚi'as 'uva, iƚque ƚocuaiya quimane. Lin'epá canic' ailopa'a quilepi'i', ni toƚta'a. Untaf'me cal mozo, icuxe'e'me ti'huanƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","’Ummecona'ma ocuenaj mozo. Iƚque jouc'a untaf'me, i'e'me lixcay, etets'i'me. Ailopa'a quilepi'i', ni toƚta'a. Icuxe'e'me ti'huanƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ummecona'ma ocuenaj mozo, iƚque ƚo'icoya afantsi. Iƚque ixcai'e'me, exaƚcuf'me, ipa'apá ƚamats' pe lifayiya cal 'uva. ");
INSERT INTO chdNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Lijou'ma ƚapoujna camats' pe lifayiya cal 'uva ticua: “¿Te caif'eya?” Ixpic'e'ma, ticua: “Cumme'ma ƚai'hua, ƚaif'epa capic'a juaiconapa. Aga aimetets'iyacu iƚque. Tepenufta.” ");
INSERT INTO chdNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lin'epá canic' lixim'me icuaico'ma ƚi'hua ƚiƚpoujna timiyoƚtsi: “Iƚque tepenuf'ma ƚi'huexi qui'ailli'. Aƚma'a'me. Toƚta'a alulijna'me caƚ'huexi.” ");
INSERT INTO chdNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Exaƚcuf'me, ipa'apá ƚamats' pe lifayiya cal 'uva, ima'a'me. Jesús icuis'e'mola', timila': ―Imanc', ¿te coƚcuapa? Ƚipoujna camats' pe lifayiya cal 'uva, ¿te co'eyacola'? ");
INSERT INTO chdNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iya' cami'molhuo' lo'eya: Ti'hua'ma, ticuaitsi pe lomana' iƚniya lin'epá canic', tima'acola'. Ƚemats' pe lifayiya 'uva, maƚe ƚamats' tepi'i'mola' ocuenaye xanuc'. Licuej'me toƚta'a litaiqui' Jesús lan xanuc' noquimf'epá ticuayi: ―¡ȽanDios aimicu'ma lane mi'i'ma toƚta'a! ");
INSERT INTO chdNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús ehuelonc'e'e'mola' liƚ'a, timila': ―Al Paxi Liniƚingiya tuya'e': Ƚapic ƚetets'ipa nolanc'epá lajutƚ, i'ipa xonca ƚaicuicoya. Iƚque ƚapic xonca tilanc'e ƚaitaƚ aimecangeya lajut'ƚ. Ja'ni a'i mi'iya to itsiya laifnu'ipolhuo', ¿te conescopa toƚta'a al Paxi Liniƚingiya? ");
INSERT INTO chdNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Cal xans tixc'uaƚaf'caitsi, tecanafcaitsi cal Cuecaj Capic, iƚque tunƚa'moxi. Ja'ni iƚque Ƚapic tecangenni tetof'caitsi cal xans, iƚque cal xans tuxpats'i'i'ma nulemma. ");
INSERT INTO chdNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lomxiye nomuc'iyalepá locuxepa ȽanDios jouc'a lixanuc' cal cuecaj ca'ailli' ixtulenca. Iƚsina' Jesús tipalaicola' iƚniya liƚ'ejma'. Ehuepá te co'iya mi'noƚyacu Jesús. Maƚpe 'hora iƚpic'a ti'noƚƚe. Aiqui'ic'. Tixpaic'eyi lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ti'hua tehueyi te co'iya mi'noƚyacu Jesús. Umme'me liƚxanuc' tiyeƚe pe lopa'a Jesús, tehuelaifta. Ma le'a ti'e'eyoƚtsi; iƚne a'ijc'a xanuc'. Ticuis'eta Jesús. Ticuayi: “Tinesc'eƚa' cataiqui' cal gobernador. Tijouƚa' aƚcu'me, ticuaita quimane iƚque ts'ipenic'.” ");
INSERT INTO chdNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Icuis'e'me Jesús, timiyi: ―Momxi, aƚsina' ac'a lotaiqui', ac'a lofmuc'iyalepa. Ima' toxinnila' lan xanuc' ipacoya. Al ƚinca tomuc'ila' lipene ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Itsiya licuis'e'mo', lu'itsonga': ¿Te aƚ'najtse'e'me cal cuecaj quincuxepa César? o ¿aimalapi'iyacu? ¿Te ti'i'ma o aimi'iya? ");
INSERT INTO chdNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús ixina' ma le'a tehueyi tic'aiƚquenni. Timila': ―¿Te calahuaicopa? ");
INSERT INTO chdNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Aƚmuc'iƚa' anuli al tomí. ¿Naitsi jiƚta'a ts'i'a? ¿Naitsi iƚta'a ts'ipuftine? Timiyi: ―Li'a César, lipuftine César. ");
INSERT INTO chdNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Timila': ―Ja'ni i'huexi César, ne', tonlapi'iƚe César. Ja'ni i'huexi ȽanDios, ne', tonlapi'iƚe ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Toƚta'a iƚniya ailopa'a co'eyacu. Aiquiƚc'aiƚqui Jesús. Ixim'me acueca' lipicuejma', i‑ch'ixco'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lijou'ma hualca lan xanuc' saduceo icuaitsa pe lopa'a Jesús. Iƚne tinesyi: Limanapola' aimimaf'iconayacu. Icuis'e'me Jesús, ");
INSERT INTO chdNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","timiyi: ―Momxi, pe liniƚpa Moisés alu'iponga': “Anuli cal xans timanƚa', joupa ilejma ƚaca'no', ja'ni ailopa'a quiƚ'hua ƚamizhua tipa'a ƚipima tileco'ma ƚi'maxi. Tipajntsi quiƚ'hua tecui'i'me lipuftine ƚipima ƚimanapa, tepenuf'ma ƚi'huexi.” ");
INSERT INTO chdNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","’Li'ipa timana' acaitsi lan xanuc' apimaye. Cal te'a ilecopa anuli ƚaca'no', lijou'ma imana'ma. Ailopa'a quiƚ'hua. ");
INSERT INTO chdNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ƚocuena ƚipima ilecopa ƚi'maxi, imana'ma jouc'a. Ailopa'a quiƚ'hua. ");
INSERT INTO chdNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Lijou'ma ƚocuena ƚipima jouc'a ileco'ma ƚi'maxi, imana'ma jouc'a. Ailopa'a quiƚ'hua. Ma' anuli li'i'mola' locuenaye lan malujxi' capimaye. Anuli anuli ileco'me ƚaca'no', imana'mola'. Ailopa'a quiƚ'hua. ");
INSERT INTO chdNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lijou'ma imana'ma ƚaca'no' jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","’Itsiya, lu'itsonga': Ticuaitsi jiƚe litine timaf'inaƚe limanapola', ¿te co'iya iƚque ƚaca'no'? Lan caitsi capimaye ilecopá. ¿Naitsi co'iya quipe'ailli'? ");
INSERT INTO chdNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús timila': ―Mimana' fa'a li'a ƚamats' lan xanuc' temalƚiyi, liƚ'aillí ticuyi liƚnaxque'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Locuena Quitine a'i toƚta'a mi'eyacu. Timana' lan xanuc' lacaƚ'no' ȽanDios tixinnila' ti'i'ma titsuflaita jiƚpe Locuena Capajnya, tixinnila' ti'i'ma timaf'icona'me nulemma. Iƚniya tipo'no'mola' locuenaye limanapola'. Iƚniya aimemalƚiconayacu. ");
INSERT INTO chdNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ti'onƚcotola' to lapaluc' quema'a. Aimimayacola'. Iƚniya ƚinca inaxque' ȽanDios, timaf'i'ina'mola' nulemma. ");
INSERT INTO chdNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","’Maƚque Moisés tuya'e': ȽanDios timaf'i'ina'mola' limanapola'. Toƚta'a tuya'e' lije'e. Jiƚpe tuya'e' li'ipa litine lonajpa lac'ec. Iƚe litine ȽanDios imipa: “Iya' NanDios; ilenDios Abraham, Isaac, Jacob.” ");
INSERT INTO chdNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ja'ni nulemma imanapola' iƚniya, ȽanDios aimimiya: “Iya' ilenDios iƚniya”. ȽanDios ilenDios ts'iƚmaf'i', a'i limanapola'. ȽanDios jahuay tixinnila' to ts'iƚmaf'i'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hualca lomxiye nomuc'iyalepá locuxepa ȽanDios italai'e'me, timiyi Jesús: ―Momxi, ac'a lonespa. ");
INSERT INTO chdNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lijou'ma, ailopa'a quilicuis'ot'ƚeconghua. Tixpailiquila'. ");
INSERT INTO chdNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús timila': ―¿Te conescompa: “Cal rey David itatahuelo cal Cristo, ȽanDios Ƚommeya”? ");
INSERT INTO chdNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Petsi liniƚiya al je'e lan Salmo, David tuya'e': ȽanDios ipalaic'o'ma ƚaiPoujna, timi: “Tocutshuaiƚa' fa'a al c'a camane. ");
INSERT INTO chdNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ima' topajnla' fa'a al c'a camane, ma' iya' ti'hua culiquila' lo'epoj laic'. Tijouƚa' ima' tocuxena'mola'.” ");
INSERT INTO chdNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’David linesco'ma cal Cristo ticua: “… ƚaiPoujna”. ¿Te conescopa “ƚaiPoujna”, ja'ni iƚque cal Cristo i'hua David? ");
INSERT INTO chdNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Miquimf'eyi lan xanuc', Jesús timila' ts'ilihuequi: ");
INSERT INTO chdNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Toƚ'etsoƚtsi cuenna lomxiye nomuc'iyalepá locuxepa ȽanDios. Iƚpic'a tiyelococo'me tipo'no'me liƚpijahua' itoqui. Tetenƚcocola' tixinintsola' to lan c'a xanuc', tinonintsola' miyelocoyi la plazá. Ni petsi locuaicoyacu, ja'ni ƚajut'ƚi pe lafoƚyomma lan xanuc', ja'ni anuli al juic, tehueyi te co'iya micutshuoƚaiyacu pe li'huáqui xonca al c'a. ");
INSERT INTO chdNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iƚniya ma mi'e'eyoƚtsi to lan c'a xanuc' texic'e'eyi ƚiƚ'huexi lam potsateya. Ticoƚi tipalaic'oyi ȽanDios. Ƚinca xonca titeƚ'mi'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Lijou'ma Jesús ehuelojm'mola' lan xanuc' ts'iƚ'hueca acueca' mecajm'miyi liƚpimoxna al caxax lopa'a jiƚpiya al cuecaj xoute'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ixim'ma jouc'a anuli ƚaca'no' apotsate, ailopa'a qui'hueca. Iƚque ti'nij'mi oque' al tomí. Ailopa'a quipitali, toco'ma to oque' centavo. ");
INSERT INTO chdNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús timila' ts'ilihuequi: ―Iya' camilhuo' al ƚinca: Xonca acueca' lipimoxna licupa ƚaca'no' cal potsate, ailopa'a qui'hueca. ");
INSERT INTO chdNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iƚne lan xanuc' ts'iƚ'hueca acueca', ma le'a i'nij'mipá loyaf'pa. Iƚque ƚaca'no' tehue'e', i'nij'mipa jahuay li'hueca. Ailopa'a co'nacoya ƚoteja. ");
INSERT INTO chdNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hualca ts'ilihuequi Jesús tehuelojnyi al cuecaj xoute'. Ticuayi juaiconapa i'huáqui al c'a. Ilajncopa lan c'a capic'. Lan xanuc' joupa icupá liƚtomí, ilanc'empa xonca al c'a. Jesús timila': ");
INSERT INTO chdNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Itsiya i'huáqui juaiconapa al c'a. Aimipaneya toƚta'a. Ticuaita litine jahuay teteƚquehuo. Ni anuli ƚapic mipo'nof'queya ƚipima capic. Jahuay tica'nico'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iƚne icuis'e'me, timiyi: ―Momxi, ¿te quitine toƚta'a ti'i'ma? ¿Te caƚsinyacu ai'a ti'i'ma toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Timila': ―Toƚpo'noƚe cuenna. Aimifel'mim'molhuo'. Axpela' ticuaicu, ticua'me: “Iya' ninCristo. ȽanDios alummepa.” Jouc'a ticua'me: “Joupa icuaico'ma al Cueca' Quitine”. Imanc' aimonlihuej'mola' nocuapá toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Toƚcuej'me lan xanuc' tifuleyi o tifuliquemma. Aimixpailij'molhuo'. Ticuicomma ti'i'ma toƚta'a. Li'a ƚamats' ti'hua ticoƚ'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús ti'hua tipalaic'ola' ts'ilihuequi, timila': ―Lan xanuc' nomana' anuli al nación tifule'me nomana' locuenaj nación. Lan xanuc' nomana anuli ƚilemats' tehuoc'ai'moƚtsi nomana' ƚocuena camats', tifule'me. ");
INSERT INTO chdNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ni petsi li'a ƚamats' tinu'ma acuecaj cunanto, titeƚco'me lumemma, jouc'a al cuana lolecopola'. Jiƚpiya lema'a acueca' lo'iya. Lan xanuc' tixim'me, tixpailij'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ai'a ti'i'ma toƚta'a imanc' toƚteƚco'me. Lan xanuc' ti'noƚ'molhuo', tihuetsoquim'molhuo', ticum'molhuo' ticuaita quiƚmane lan xanuc' nocuxepá ƚajut'ƚi pe lafoƚyomma lan xanuc', ti'nicom'molhuo' lacarza, tilecom'molhuo' pe lomana' lan rey jouc'a pe lomana' locuenaye quincuxepá. Imanc' aƚ'huaiyijmpa iya', toƚiya toƚteƚco'me toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ni petsi loleconyacolhuo' tulu'i'mola' lan xanuc': “Illanc' lihuejyi Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","’Itsiya aimoƚsueƚmot'ƚe'me, aimoƚnes'me: “¿Te caƚcuayacu? ¿Te caƚtalai'e'ecoyacola' lan xanuc'?” Toƚpo'noƚe loƚpicuejma', toƚnesle nulemma: “Aimaƚsueƚmot'ƚe'me”. ");
INSERT INTO chdNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iya' cu'i'molhuo' loƚnesyacu. Capi'i'molhuo' coƚpicuejma' acueca'. Naixtuc'opolhuo' aimi'iya mitalai'eyacolhuo'. Ni aimimiyacolhuo': “A'ij ƚinca loƚnespa imanc'”. Aimi'iya minesyacu toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Loƚ'aillí, loƚpimaye jouc'a lonƚejmalepá ticuftolhuo', ticuaita quiƚmane lincuxepá. Tima'am'molhuo' hualca imanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Imanc' ts'alihuequi, toƚiya ni petsi lomana' lan xanuc' tixtuc'o'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Imanc' aimejac'yacolhuo', ni anuli lijuac ƚoƚjuac aimejac'ya. ");
INSERT INTO chdNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Toƚsnet'ƚƚe jahuay lo'iyacolhuo', toƚta'a tulunƚul'me. ");
INSERT INTO chdNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Litine moƚsinyacu lan soldado canumicay al cuecaj quiƚya' Jerusalén ti'iƚa' coƚsina' aimicoƚya liƚya', tijouna'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iƚe litine ja'ni toƚmana' jiƚpe al distrito Judea tolinul'me, tonƚe'me ƚijualay. Ja'ni toƚmana' al cuecaj quiƚya' tolipalcu. Ja'ni toƚmana' pu'hua ƚimuc'o', aimoƚtsuflai'me liƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jiƚniya ƚitiné fa'a al cueca' quiƚya' tixim'me lateƚcoya. Ma to muya'e' al Paxi Liniƚingiya ma toƚta'a tenanƚco'ma jahuay. ");
INSERT INTO chdNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Acuanuc'la lacaƚ'no' linnaila', jouc'a lacaƚ'no' notu'ipá liƚnaxque'. Titeƚco'me acueca' juaiconapa jifa'a li'a ƚamats'. Lan xanuc' nomana' tixim'me al cueca' lipoyac' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lin'ehuale laic' tima'acom'mola' a'espada. Jouc'a tifi'em'mola' ts'iƚmaf'i', tilecom'mola' ni petsi li'a ƚamats'. Lan xanuc' ocuena quiƚnación, iƚne aimimetsaicoyi ȽanDios, ticuxe'me fa'a liƚya' Jerusalén. ȽanDios tepi'i'mola' lane ti'hua ticuxe'me. Tijouƚa' texic'e'ena'mola' licueya quiƚmane, aimicuxeconayacu liƚya'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Cal 'ora timuj'ma lo'iya. Jouc'a cal mut'ƚa jouc'a lan xamna timuj'me. Lan xanuc' nomana' li'a ƚamats', jahuay lan nación, tixhueƚco'me. Aiquiƚsina' te co'eyacu. Ƚaja tife'ne'moxi juaiconapa, titsahuehuo. Tixtu'ma ƚaja, ticuequehuo acueca'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Titafquecola' lan xanuc', ailopa'a co'eyacu. Tixim'me lan xamna tipai'i'me liƚpene. Tixpailij'mola' juaiconapa, tixhueƚco'me, tines'me: “¿Te xonca caƚteƚcoyacu fa'a li'a ƚamats'?” ");
INSERT INTO chdNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","’Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Iƚne ƚitiné aƚsim'ma cacuaiconahuo jiƚpe ƚummahuay. Aƚsim'ma acueca' laipepaxi, aƚsim'ma ma' anuli ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","’Tipangoƚa' iƚe lo'iya aimixpailij'molhuo'. Tixojla' conlata. Aimicoƚya loƚteƚcoyacu, tulunƚul'me. ");
INSERT INTO chdNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Lijou'ma Jesús ipangopa i'onƚicopa lo'ipa al 'icux, jouc'a jahuay cal 'ec'. Timila' ts'ilihuequi: ―Toƚpo'noƚe cuenna lo'ipola' al 'icux jouc'a jahuay locuenaye cal 'ec'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tuxcuaf'caitsi ƚipela imanc' oƚsina' joupa icuaico'ma ƚinu'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ma' anuli, litine ti'iƚa' to laimipolhuo', ti'i'ma coƚsina' joupa icuaico'ma ȽanDios cal Cuecaj Rey. Jahuay tihuejco'me. ");
INSERT INTO chdNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iya' camilhuo' al ƚinca: Ma to liƚ'ejma' lan xanuc' nomana' itsiya litine, ma toƚta'a ti'i'ma liƚ'ejma' lan xanuc' nomajnyacu iƚe litine lo'iya to laimipolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lema'a y li'a ƚamats' tejac'mola', aimoƚsingonayacu. Laitaiqui' aimejac'ya, tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Imanc' toƚ'etsoƚtsi cuenna. Aimoƚ'e'me nixpiya, aimimeyoj'molhuo', aimoƚsueƚmot'ƚe'me te co'iya moluyalaicoyacu jifa'a lapajnya. Tolihuejcoƚe ȽanDios. Ja'ni a'i, timufc'o'molhuo' loƚpicuejma', ticuaitsi al Cuecaj Quitine tixpaic'e'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ticuaiyunni al Cuecaj Quitine lan xanuc' ni petsi lomana' li'a ƚamats' tixingufco'me. ");
INSERT INTO chdNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","¡Toƚmaf'iƚe! ¡Ti'hua toƚjoc'iƚe ȽanDios! Joupa nu'ipolhuo' iƚe al cueca' lo'iya. Toƚsa'hueƚe ȽanDios, toƚmi'me: “Aƚtoc'itsonga', lunƚu'etsonga'”. Tijouƚa' tixoj'ma cunlata tolacaxingoƚaita pe laifpa'a. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iƚne ƚitiné Jesús timuc'ila' lan xanuc' jiƚpe el cuecaj xoute'. Lipuqui' tipamma liƚya', ti'hua ƚijuala Olivo. Iƚpe tipajnspa ƚic'ayca lipuqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mi'i'ma quitine jahuay lan xanuc' tiyeyi al cuecaj xoute', tiquimf'eta litaiqui' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tehue'e' huata ti'i'ma al juic cuftine al Pascua. Mi'eyi juic titeji ƚa'i aiquilai'inni levadura. ");
INSERT INTO chdNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios tehueyi te co'iya mima'anyacu Jesús. Tixpailiquila', ja'ni tixtulecu lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ƚonta'a Satanás itsufaipa lipicuejma' anuli iƚne limbamaj coquexi' ts'ilihuequi Jesús, iƚque cuftine Judas. Locuena lipuftine Iscariote. ");
INSERT INTO chdNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","I'hua'ma pe lomana' lixanuc' cal cuecaj ca'ailli' jouc'a lapaluc' no'epá cuenna al cuecaj xoute'. Ipalaic'o'mola'. Ixpic'e'ma te co'iya micuya Jesús, ticuaitsi quiƚmane. ");
INSERT INTO chdNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ixoj'ma quileta iƚniya. U'i'me tojua mulijya al tomí. ");
INSERT INTO chdNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas icupa cataiqui' ticu'ma Jesús. I'huana'ma, ehuepa te co'iya micuya iƚque. Ticua: “Aimicuej'me lan xanuc'”. ");
INSERT INTO chdNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Icuaitsi al juic titem'me ƚa'i aiquilai'inni levadura. I'huajcopa litine tima'am'mola' laicanaxque' mot'ƚ, iƚne lotejnyacola' jiƚpe al juic Pascua. ");
INSERT INTO chdNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús umme'mola' Pedro y Juan, timila': ―Tonƚeƚe. Tolafot'ƚetsa ƚaƚtejacu aƚsmocota al juic Pascua. ");
INSERT INTO chdNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Icuis'e'me, timiyi: ―¿Petsi caƚsmocoyoyacu? ¿Te cofcuapa? ");
INSERT INTO chdNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Timila': ―Tonƚeƚe liƚya', ma moƚtsuflaiyi liƚya' toƚsinna anuli cal xans itaic' lijuti caja'. Tolihuejtsa. Iƚque titsufaita anuli lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Toƚpalaic'ota ƚapoujna, toƚmita: “Ƚaƚpomxi alummeponga' pe lofpa'a, ticuis'ehuo', timihuo': ¿Pe copa'a lajut'ƚ pe laƚsmocoyoyacu al juic Pascua, iya' jouc'a lalihuequi?” ");
INSERT INTO chdNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iƚque tilecotolhuo' al toncay lajut'ƚ. Timuc'itolhuo' anuli al cuecaj cajut'ƚ. Jiƚpe tipa'a jahuay, joupa ixhueya. Maƚpiya toƚpo'nota ƚaƚtejacu. ");
INSERT INTO chdNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iƚne loquexi' ts'ilihuequi iye'me. Ixim'me ma to limipola' Jesús. Jiƚpe lajut'ƚ ilanc'e'me calxmocojma'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ticuaitsi al 'hora tixmocoƚe Jesús jouc'a li'apóstole icutshuoƚai'me, titetso'me. ");
INSERT INTO chdNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús timila': ―Aijanajpa juaiconapa aƚsmocoƚe anuli iƚca'a ƚitejua' al Pascua. Aixina' icuaico'ma laifteƚcoya. Ate'a aƚsmoco'me anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iya' camilhuo': Jifa'a li'a ƚamats' aicatetsoconaya iƚta'a al juic. Ticuaitsi litine lan xanuc' tihuejcoƚe ȽanDios ƚiƚCuecaj Rey, iƚe litine ti'icona'ma iƚe al juic, ti'i'ma ituca'. Jiƚpe ƚinca catetsoconna. ");
INSERT INTO chdNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lijou'ma uhuof'ma al taza, ix'najtsi'i'ma ȽanDios, timila' ts'ilihuequi: ―Tuluhuanuf'le iƚta'a al taza. Toƚsnaƚe jahuay imanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Jifa'a li'a ƚamats' aicaxnaconaya lija' uva. Ticuaitsi litine tixinƚe ȽanDios micuxe, iƚe litine, ƚinca caxnaconna. ");
INSERT INTO chdNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Epef'ma anuli ƚa'i. Ix'najtsi'icona'ma ȽanDios. Ixquenuf'ma, epi'i'mola' ts'ilihuequi, timila': ―Jiƚca'a aicuerpo laifcuya cunƚu'e'molhuo'. Tolihuej'me toƚta'a, aƚ'nujuaisco'ma iya' laif'eya. ");
INSERT INTO chdNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lijoupa lixmocopa ix'najtsi'icona'ma ȽanDios, icufi'mola' al taza. Uhuof'ma timila': ―Iƚta'a aijuats' laifxcuajaiya cunƚu'e'molhuo'. Ma mixcuajaiquemma laijuats' caƚinc'i'ma al ts'e cataiqui', ȽanDios lopo'no'ipolhuo' imanc' ixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Jahuay imanc' a'i ixanuc' ȽanDios. Jifa'a tipa'a iƚque ƚaƚcuya. Aƚpo'nof'iyi laƚmane al mesa anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Itsiya ca'huana'ma laipene. Ma toƚta'a laƚ'iya. Tijouƚa' acueca' a'ijc'a juaiconapa tuyaico'ma cal xans ƚaƚcuya. ");
INSERT INTO chdNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ts'ilihuequi ipango'me icuis'e'moƚtsi, timiyoƚtsi: ―¿Naitsi illanc' ti'e'ma toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lijou'ma ipango'me ifuli'i'moƚtsi cataiqui', naitsi xonca cal cueca'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús timila': ―Lan xanuc' pe aimimetsaicoyi ȽanDios lan tsilaj quincuxepá ti'e'eyoƚtsi quiƚpoujnalá. Ts'iƚpenic' ticuayi: “Illanc' ƚinca aƚtoc'ila' laƚxanuc', aƚcuxela' al c'a”. ");
INSERT INTO chdNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Imanc' aimonƚ'e'me toƚta'a. Toƚ'eƚe ituca' loƚ'ejma'. Imanc', iƚque xonca ts'i'huaj'me ti'e'exoxi ti'onƚcotsi to ƚa'hua. Iƚque nocuxepa xonca, ti'e'exoxi ti'onƚcotsi to cal mozo. ");
INSERT INTO chdNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Naitsi iƚque xonca cal cuecaj xans? ¿Ja'ni iƚque ƚocutsuya notetsopa? o ¿ja'ni cal mozo ƚo'hua'apa al pime? Iƚque ƚocutsuya ƚinca xonca acuecaj xans. Laƚmajmpa anuli iya' aƚ'onƚcospa to cal mozo. ");
INSERT INTO chdNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Imanc' aixanuc' aicaƚpo'nohuo caituca'. Capa'a fa'a li'a lamats' aƚteƚcopá anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jouc'a aƚcuxena'me anuli. Cai'Ailli' joupa lapi'ipa laimane cacuxe'ma. Jouc'a iya' capi'ilhuo' loƚmane toƚcuxe'me. ");
INSERT INTO chdNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ticuaitsi litine lihuejco'ma jahuay lan xanuc' iya' imanc' aƚcutsoƚai'me anuli, aƚtetso'me, aƚsna'me. Imanc' toƚcutsoƚai'me loƚcuecaj asiento, toƚspijta lataiqui', toƚcuxe'mola' loƚxanuc', iƚne liƚxanuc' limbamaj coquexi' linaxque' ƚoƚtatahuelo Israel. ");
INSERT INTO chdNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús ipalaic'opa Simón Pedro, timi: ―CumSimón, Satanás ixa'huepa lane tehuai'molhuo' imanc'. Cal xans nofusya ƚitrigo tipa'a'ma ƚipifuc, tipanehuo pangay c'a. Toƚta'a ti'i'molhuo' imanc' lahuaiyinyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aixahue'epa ȽanDios titoc'itso' ima' cumSimón. Toƚta'a ima' ti'hua aƚ'huaiyinge, aimaƚpo'nohuo nulemma. Tijouƚa' tehuaiyintso' ima' toxhuej'meconahuo, lihuejcona'ma. Iƚniya ƚitiné totoc'itsola' lopimaye, tapi'itsola' liƚpujfxi jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro timi: ―Maipoujna, joupa aipo'nopa laipicuejma'. Ni petsi loftseya ca'hua'ma jouc'a. Ja'ni ti'noƚintso' ti'hua'antso' lacarza, ja'ni tima'antso', jahuay ti'e'entso' iya' cacua: Ma aƚ'e'entsonga' anuli. Aicapo'noyaco' cotuca'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Timi: ―CumPedro, camihuo': Iƚta'a lipuqui', ai'a tija'a'ma ƚangiti, ima' tones'ma afanemma: “Aicainimetsaijma Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Icuis'e'mola' ts'ilihuequi, timila': ―Iƚe litine lainumme'molhuo' aicoƚtai'me coƚponta, ni coƚmorral, ni coƚc'ejí, ¿te ehue'e'molhuo'? Timiyi: ―Ailopa'a calahue'ehuo'monga'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Timila': ―Itsiya ituca' lo'iya. Camilhuo': Naitsi ts'i'hueca liponta tomí, titaiƚa'. Naitsi ts'i'hueca ƚimorral, titaiƚa' jouc'a. Ja'ni ailopa'a qui'espada, ticujla' lipuquiya, ti'nacoƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Al Paxi Liniƚingiya tuya'e': “Iƚque iteƚ'mim'me to loteƚ'mimpola' iƚne no'epá quixcay”. Iƚe liniƚiya aƚnescopa iya' laƚ'iya. Camilhuo': Tenanƚ'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Timiyi: ―Maƚ'ailli', jifa'a tipa'a oquej lan 'espada. Timila': ―Ne', tipajnla'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús ipanni lajut'ƚ, ma to mi'ay i'hua'ma ƚijualaj Olivo. Ts'ilihuequi ihuej'me. ");
INSERT INTO chdNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Icuaicontsa petsi lotsepa. Jiƚpiya timila' ts'ilihuequi: ―Toƚjoc'iƚe ȽanDios. Toƚsa'hueƚe aimehuaiyim'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ipo'no'mola' quiƚtuca', i'hua'ma ni huata, iƚojf'e'moxi le'a lipiculi' to taca'niƚa' anuli ƚapic. Exc'onƚhuai'ma, tijoc'i ȽanDios, timi: ");
INSERT INTO chdNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Mai'Ailli' liƚonc'e'eƚa' iƚca'a al cueca' laifteƚcopa, ja'ni toƚta'a oxpic'epa. Tama toƚta'a laifmipo' jouc'a camihuo': To'eƚa' ma to lofxpic'epa a'i to iya' laifxpic'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iximpa icuaico'ma anuli ƚapaluc quema'a. Tepi'i' quipujfxi, ti'ommaitsi. ");
INSERT INTO chdNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lijou'ma ipango'ma ihuotsonni xonca, unlejma ƚunxajma'. Xonca ihui'i'ma ixa'hue'ma ȽanDios. Ijaftsi, titats'quemma ƚamats', tocomma ajuats'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Lijoupa lijoc'ipa ȽanDios itsahuenanni, i'hua'ma pe lomana' ts'ilihuequi. Ixim'mola' tixmaiyi. Ƚihuotsoqueya ulij'mola', i'noƚ'mola' ƚahuí. ");
INSERT INTO chdNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Timila': ―¿Te coƚsmaicopa? Toƚtsolinca, toƚjoc'iƚe ȽanDios. Toƚsa'hueƚe titoc'itsolhuo', aimehuaiyim'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ma mipalay Jesús icuaitsa axpela' lan xanuc'. Judas, iƚque anuli iƚniya limbamaj coquexi' ts'ilihuequi Jesús, i'huaj'me'ela' lan xanuc'. Icuaitsi pe lopa'a Jesús, tituc'o'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús timi: ―Judas, ¿te aƚtuc'o'ma? Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ¿Te aƚtuc'o'ma, tijouƚa' aƚcu'ma? ");
INSERT INTO chdNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Niyejmalepá Jesús lixim'me lo'ipa timiyi: ―Maƚ'ailli', ¿aƚfuleco'me a'espada? ");
INSERT INTO chdNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Anuli ts'ilihuequi ixcai'e'ma ƚimozo cal cuecaj ca'ailli'. Etec'e'e'ma lix'mas, al c'a camane. ");
INSERT INTO chdNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús timila' lan xanuc': ―Lapi'iƚa' lane. Iƚafc'e'e'ma lix'mas iƚque cal xans. Ixaƚ'mena'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ipalaic'o'mola' iƚne nicuaitsa ti'noƚ'me. Iƚniya ixanuc' cal cuecaj ca'ailli', jouc'a incuxepá lapaluc' no'epá cuenna al cuecaj xoute', jouc'a lan tsilaj xanuc' noxpijpá lataiqui'. Timila': ―Imanc', ¿te coƚcuaiyoco'me fa'a oƚtaic' loƚ'espada, lonƚ'ec, aƚ'noƚƚa'? ¿Te aƚ'onƚcospa to ƚinma'ahuale? ");
INSERT INTO chdNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Itine itine aƚmana' anuli jiƚpe al cuecaj xoute'. Aimaƚ'noƚi. Itsiya ƚinca tonƚ'e'me ts'oƚpic'a. Itsiya ti'hua limane nocuxepa al muf. ");
INSERT INTO chdNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","I'noƚ'me Jesús, ileco'me lejut'ƚ cal cuecaj ca'ailli'. Pedro ihuequi aculi'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jiƚpiya ƚipuna quejut'ƚ cal cuecaj ca'ailli' icue'empá ƚunga, icutsingoƚai'me. Pedro icutsingai'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ƚipaƚ cunga tulif'e' li'a Pedro. Anuli cal mozo aca'no' ehuelojm'ma, timila' lan xanuc' nomana' jiƚpiya: ―Iƚque cal xans jouc'a iƚejmale Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro icuanajpa, timi: ―Maca'no', aicainimetsaijma. ");
INSERT INTO chdNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lijou'ma nihuata ocuena cal xans ixim'ma Pedro, timi: ―Ima' jouc'a unƚejmale Jesús. Pedro timi: ―Cunxans, a'i iya'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Uyai'ma to anulij hora. Ocuenaj cal xans ihui'i'ma, timila' locuenaye nomana' jiƚpe: ―Ma' al ƚinca iƚca'a cal xans iƚejmale Jesús. Iƚca'a jouc'a ƚas Galilea. ");
INSERT INTO chdNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro timi: ―Cunxans, aicaixina' te cofnespa, ni aicaicueca. Mipalay Pedro toƚta'a ija'a'ma ƚangiti. ");
INSERT INTO chdNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ȽaƚPoujna Jesús ipai'e'moxi, ehuelojm'ma Pedro. Pedro i'nujuaitsi lataiqui' limipa: “Iƚta'a lipuqui' ai'a tija'a'ma ƚangiti ima' tones'ma afanemma: Aicainimetsaijma Jesús.” ");
INSERT INTO chdNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ipanni, ijojtsi talay. ");
INSERT INTO chdNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lan xanuc' no'epá cuenna Jesús ipango'me ilotsoco'me. Untaf'me c'ec. ");
INSERT INTO chdNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ifi'e'e'me li'u', ticuis'eyi, timiyi: ―¡Tocua'aƚa'! ¿Naitsi nuntafpo'? ");
INSERT INTO chdNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jouc'a imiloj'me axpe' quixcay cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Liƚic'ejma' ileco'me Jesús pe lefoƚya lan tsilaj xanuc' noxpijpá lataiqui' jouc'a lixanuc' cal cuecaj ca'ailli', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Timiyi: ―Ja'ni ima' unCristo, ummepo' ȽanDios, lu'itsonga'. Timila': ―Ja'ni cu'itsolhuo' imanc' aimoƚ'eyacu ƚinca laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ja'ni quicuis'etsolhuo' aimaƚtalai'eya. ");
INSERT INTO chdNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Tuyaiƚa' itsiya cacutsainata al c'a camane ȽanDios. Iƚque jahuay nipajnya ti'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Licuejpá iƚe linespa Jesús jahuay iƚniya lan xanuc' timiyi: ―¿Te ima' i'Hua ȽanDios? Timila': ―Ma to imanc' moƚnesyi, ma' iya'. ");
INSERT INTO chdNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ticuayi: ―Itsiya' ƚinca aimalahueyacola' nocufyacu xonca. Iƚca'a quituca' ecani'epoxi. Joupa aƚcuejpá. ");
INSERT INTO chdNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jiƚpe lefoƚya jahuay iƚniya itsolinamma, i'hua'a'me Jesús pe lopa'a Pilato, iƚque cal gobernador. ");
INSERT INTO chdNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ipango'me icuf'me, timiyi Pilato: ―Aƚquimf'epá ituca' lomuc'iyalepa iƚque cal xans. Tipai'ila' liƚpicuejma' laƚxanuc'. Tu'ila' aimi'najtse'eyacu loxahue'epola' cal cuecaj quincuxepa César. Ticua: “Iya' ninCristo, ninRey”. ");
INSERT INTO chdNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato icuis'e'ma, timi: ―¿Te ima' iƚrey lan xanuc' judío? Italai'e'ma timi: ―Al ƚinca lofcuapa. ");
INSERT INTO chdNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato ipalaic'o'mola' lixanuc' cal cuecaj ca'ailli' jouc'a locuenaye liyejmalepá, timila': ―Iƚque cal xans iya' aiximpa ailopa'a qui'epa. Ailopa'a quijunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ihui'i'me, timiyi: ―Tipai'ila' liƚpicuejma' laƚf'as xanuc' judío. Ni petsi timuc'iyale. Ipangocopa imuc'iyalepa jiƚpe al distrito Galilea, itsiya icuai'ma fa'a liƚya' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato licuej'ma tinesyi al distrito Galilea, icuis'e'ma ja'ni Jesús qui'huayomma Galilea. ");
INSERT INTO chdNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ticuayi: “Ƚinca, qui'huayomma Galilea”. Jiƚpe Galilea ticuxe cal rey Herodes, itsiya copa'a Jerusalén. Pilato aiquicoƚ'ma, umme'ma Jesús jiƚpe pe lopa'a Herodes. ");
INSERT INTO chdNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Lixim'ma Jesús, Herodes ixoconni queta. Axpe' mut'ƚa tijanaca tixinƚa' Jesús. Joupa icuejpa acueca' lo'epa. Ticua: “Iya' jouc'a aƚmuc'i'ma al cueca'”. ");
INSERT INTO chdNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Licuaitsi Jesús juaiconapa icuis'mot'ƚe'ma. Iƚque aiquitalai'e. ");
INSERT INTO chdNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jiƚpe jouc'a tecaxoƚanna lixanuc' cal cuecaj ca'ailli' jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. Ticufyi juaiconapa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes jouc'a lisoldado etets'i'me Jesús, ilotsoco'me. Itats'mi'me al c'a lijahua', to lopo'noyacu lan rey. Ipai'econanca pe lopa'a Pilato. ");
INSERT INTO chdNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Li'ipa Herodes y Pilato ti'eyoƚtsi laic'. Iƚiya litine ipalaic'ona'moƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato efot'ƚe'mola' lixanuc' cal cuecaj ca'ailli' jouc'a ts'iƚpenic' lan xanuc' judío, jouc'a ocuenaye xanuc', ");
INSERT INTO chdNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","timila': ―Imanc' aƚcuai'e'ma iƚca'a cal xans. Aƚmi: “Tipai'ila' liƚpicuejma' lan xanuc'”. Imanc' joupa oƚcuejpá lainicuis'epa iƚque. Iya' cacua: Ailopa'a toƚta'a quijunac'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma' anuli ticua Herodes. Iƚque ipai'enamma, ummeconapa jifa'a pe laƚmana'. Ailopa'a qui'epa Jesús. Aimi'iya canesya: Tima'anƚe. ");
INSERT INTO chdNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Cacuxe'ma tipalojle, tijouƚa' cux'masna'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iƚe al juic Pascua ticuicomma Pilato tux'mas'ma anuli ƚitats'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jahuay ija'a'me, timiyi: ―Iƚque cal xans, ¡Tocuƚa'! ¡Tileconƚe! ¡Tima'antsa! Illanc' aƚpic'a Barrabás. Tox'masla' iƚque. ");
INSERT INTO chdNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Iƚque Barrabás ehuoc'aipola' lan xanuc' nomana' liƚya' Jerusalén. Inma'ahuale. Toƚiya itats'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ipic'a tux'masnaƚa' Jesús. Ipalaic'ocona'mola', timila': ―Cux'masna'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Italai'e'e'me, ija'a'me timiyi: ―¡Tapaƚts'ijnla' lancruz! ¡Tapaƚts'ijnla' lancruz! ");
INSERT INTO chdNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ipalaic'ocona'mola'. I'ipa afanemma mipalaic'ola'. Timiconala': ―¿Te caifnepaƚts'ijncoya lancruz? ¿Te quixcay qui'epa? Ailopa'a qui'epa. Aimi'iya mima'anyacu. Cacuxe'ma tipalojle, tijouƚa' cux'masna'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ija'a'me juaiconapa. Ihui'i'me, timiyi: ―¡Tapaƚts'ijnla' lancruz! Lijou'ma ulij'me iƚniya lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato icuxe'ma ti'iƚa' ma to ts'iƚpic'a. ");
INSERT INTO chdNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ux'masna'ma ƚitats'iya ƚoxahue'epa, iƚque Barrabás, ƚehuoc'aipola' lan xanuc', inma'ahuale xans. Icu'ma Jesús, ti'e'eƚe ma to lan xanuc' lonespa ti'iƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ileco'me Jesús. Miyeyi lane italecuf'me anuli cal xans i'ehuo'ma canic' ƚimuc'o', ipainamma cotsenapa liƚya'. Iƚque cal xans cuftine Simón, ƚas Cirene. I'noƚ'me, ipo'nof'i'me lixpula' lencruz Jesús, titaiƚa', ti'huanc'oƚeƚa'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Iƚenc'e axpela' lan xanuc' jouc'a lacaƚ'no', tijolijyi tihuotsoyi lo'e'enyacu Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús ipai'e'moxi, ipalaic'o'mola', timila': ―Imanc' cunc'acaƚ'no' Jerusalén, aimaƚjojcumle'ma iya' laƚ'iya. Toƚjojcumletsoƚtsi lo'iyacolhuo' imanc', lo'iyacola' loƚnaxque'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ticuaihuo ƚitiné tu'i'moƚtsi: “Lacaƚ'no' lijuiƚqui xonca tixoqui quileta iƚniya, aimixhueƚmot'ƚeyi. Iƚne pe aiquiƚsina' quiƚ'hua, aiquiƚtu'i, jouc'a tixoqui quileta, aimixhueƚmot'ƚeyi.” ");
INSERT INTO chdNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","’Iƚniya ƚitiné lan xanuc' tixim'me acuecaj caxpaiqui'. Tipalaic'o'me cal tsilaj quijualay, timi'me: “Tacangenni lacanaf'caitsonga'”. Lan tsocay quijualay timi'me: “Lamitsonga'”. ");
INSERT INTO chdNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iya' aƚ'onƚcospa to lic'axhui c'ec. Ja'ni toƚta'a laƚ'ipa iya', ¿te ts'i'ic' lo'iyacola' iƚniya lo'onƚcospola' to al 'ec joupa ijuƚpa? Acueca' xonca loteƚcoyacu iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jouc'a ilecom'mola' oquexi' lan xanuc', iƚne i'epá quixcay. Tepaƚts'ingintsa Jesús jouc'a tepaƚts'inginnola' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Icuaitsa jiƚpe cuftine Ƚecoye. Jiƚpiya epaƚts'ingintsa Jesús lencruz. Jouc'a epaƚts'ingim'mola' jiƚne loquexi' ni'epá quixcay. Anuli epaƚts'ingim'me al c'a camane Jesús, ƚocuena loxa camane. ");
INSERT INTO chdNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús tixa'hue qui'Ailli', timi: ―Mai'Ailli', taimenc'e'ecotsola' lo'epa. Aiquiƚsina' lo'epa. Lan soldado tif'ilcoyi lipijahua' Jesús, naitsi nolijya. ");
INSERT INTO chdNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lan xanuc' tecaxoƚanna jiƚpiya tehuelojnyi. Lincuxepá tipalaicoyi Jesús, tetets'iyi, ticuayi: ―Ocuenaye xanuc' unƚu'e'mola'. Ja'ni maƚque aCristo, ƚummepa ȽanDios, ƚi'Huijf'epa ȽanDios, itsiya tunƚu'exoxi. ");
INSERT INTO chdNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma' anuli lan soldado imiloj'me quixcay cataiqui'. Icuaitsa icufi'me al cuxac vino, ");
INSERT INTO chdNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","timiyi: ―Ima', ja'ni ima' iƚrey lan xanuc' judío, tonƚu'exoxi. ");
INSERT INTO chdNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Al toncay ƚijuac Jesús epaƚts'ijnya lancruz anuli laca'hua caxma, jiƚpe iniƚiya ticua: “Iƚca'a iƚrey lan xanuc' judío”. ");
INSERT INTO chdNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Anuli ni'epa lixcay, jouc'a iƚpe tepaƚts'ijnya lencruz, timiloqui quixcay cataiqui', timi: ―Ima', ja'ni umCristo, tonƚu'exoxi jouc'a lunƚu'etsonga' illanc'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ƚocuena itale'ma ƚif'as quixcay xans, timi: ―¿Te aimoxpaic'e ȽanDios? Ima' jouc'a ecani'empo', aƚma'a'monga'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Illanc' lapi'imponga' al ƚijca. Aƚ'epa quixcay, aƚteƚ'minninga'. Iƚca'a cal xans ailopa'a qui'epa. ");
INSERT INTO chdNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Timi Jesús: ―Maipoujna, ticuaitsi litine tocuxetsola' lan xanuc', ¡aƚ'nujuaisla' iya'! ");
INSERT INTO chdNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús timi: ―Iya' camihuo': Itsiya ƚinca aƚcuaita anuli jiƚpe al Paraíso. ");
INSERT INTO chdNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","I'ipa to menac'o. Ni petsi jiƚpe ƚamats' imufc'o'ma. Al muf icoƚ'ma afane' hora. ");
INSERT INTO chdNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Emi'moxi cal 'ora. Jiƚpe al cuecaj xoute' tipa'a lijahua' lojujnya ts'ipa'ne lajut'ƚ xonca al Paxi. Lixhuaita al fanej hora iƚe lijahua' its'aƚquenni tejmay ƚamats', i'i'ma oque'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús ija'a'ma ujfxi, timi qui'Ailli': ―Mai'Ailli', capi'inahuo' ƚai'espíritu, tapenufnaƚa'. Toƚta'a licua'ma exnalif'ma, imana'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nocuxepola' lan soldado lixim'ma li'i'ma imetsaico'ma acueca' ȽanDios. Ipalaicopa Jesús, ticua: ―Iƚque cal xans ƚinca ailopa'a qui'epa, aƚijca xans. ");
INSERT INTO chdNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jiƚpiya timana' lan xanuc' icuaicoco'me tixinƚe lo'iya. Lehuelojmpá toƚta'a li'ipa, iƚniya ixpailij'mola'. Tuntafyi ƚilunxajma', iyena'me tixhueƚcoyi. ");
INSERT INTO chdNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Liƚejmale Jesús jouc'a lacaƚ'no' iƚne quiyouyomma Galilea ilihuequi, jahuay iƚniya tecaxoƚanna aculi'. Tehuelojnyi lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jiƚpe liƚya' Jerusalén tipa'a anuli cal xans cuftine José. Iƚque anuli lan tsilaj xanuc' noxpijpá lataiqui'. Ac'a xans, ti'ay ma le'a al ƚijca. ");
INSERT INTO chdNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Iƚque aiquetenƚcocojma quiƚspic'e lif'as xanuc' noxpijpá. Iƚne ixpic'epá tima'anƚe Jesús, ima'apá. Lipiƚya' José cuftine Arimatea, lopa'a al distrito Judea. I'huaijma ticuaitsi litine tihuejcoƚe ȽanDios ƚiƚRey jahuay lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","José i'hua'ma pe lopa'a Pilato. Ixahue'e'ma tepi'inƚe lane tipuƚnata licuerpo Jesús, titaina'ma teminna. ");
INSERT INTO chdNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José ipuƚhuona'ma licuerpo Jesús, iju'eco'ma anuli al cuecaj quijahua' lilanc'ecompa alino, i'nicotsi anuli al pu'hua cunts'eja' lipupa ƚapic. Ailopa'a quemimpa jiƚpe lipu'hua capic. ");
INSERT INTO chdNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iƚe litine aviernes, ai'a litine conxajya. Ni huata tehue'e' ticuaitsi litine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lacaƚ'no', iƚne quiyouyomma Galilea liyejmalepá Jesús, iƚenc'ot'ƚe ilihuequi José. Ixim'me al pu'hua. Ixim'me jouc'a pe li'nicompa licuerpo Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lijou'ma iyena'me liƚya' Jerusalén. Tefot'ƚeta ƚitamqui, tipo'no'i'me licuerpo Jesús. Jouc'a tilanc'eta laceite lojuepa c'a, ti'ot'ƚi'me licuerpo. Licuaitsi litine conxajya tunxajyi ma to loya'apa locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lihuequi litine, al te'a litine al xamano, iƚe al domingo, ai'a ti'i'ma quitine, ipalunca lacaƚ'no', iye'me al pu'hua. Itai'me ƚitamqui ƚefot'ƚepa. ");
INSERT INTO chdNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Licuaitsa jiƚpiya ixim'me cal cuecaj capic leti'icompa lico cunts'eja' joupa iƚonc'empa, imelfai'empa, tipo'noya liju'. ");
INSERT INTO chdNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Itsuflai'me. Aiquixim'me licuerpo ƚaƚPoujna Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aiquiƚcueca li'ipa. Aiquiƚsina' te co'eyacu. Aiquicoƚ'ma ixim'me oquexi' lan xanuc', maƚpiya lileju' tecaxoƚanna. Liƚpijahua' tunts'ifi to lepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lacaƚ'no' ixpailij'mola' juaiconapa. Ic'ommoƚaipá uhuenacopá ƚamats'. Iƚniya lan xanuc' timinnila' lacaƚ'no': ―Fa'a tipo'nom'mola' lomanapola', ¿te colahuecopa iƚque ƚimaf'i cal xans? ");
INSERT INTO chdNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iƚque ƚolahuepa fa'a ailopa'a. Imaf'inapa, itsahuenamma. Toƚ'nujuaitsa limipolhuo' ma moƚmana' anuli al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Imi'molhuo': “Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Aƚcu'ma lan xanuc', iƚne pe aimihuejcoyi locuxepa ȽanDios. Alapaƚts'inginna lancruz. Afane' litine camaf'ina'ma, catsahueno.” ");
INSERT INTO chdNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Licuej'me toƚta'a, lacaƚ'no' i'nujuaitsa limipola' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ipailinamma. Icuaitsa liƚya' uya'a'me li'ipa. U'intsola' limbamaj nuli lan apóstole jouc'a locuenaye liyejmalepá Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iƚne lacaƚ'no' anuli aMaría ƚas Magdala, ƚocuena aJuana, ƚocuena María iƚque qui'máma' Jacobo. Jouc'a tiƚmana' locuenaye lacaƚ'no' liyejmalepá. Iƚniya nuya'apá timinnila' lan apóstole. ");
INSERT INTO chdNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lan apóstole aimi'eyi ƚinca iƚe liƚtaiqui' lacaƚ'no' luya'apa. Imi'moƚtsi: “Ma le'a ticuayi”. ");
INSERT INTO chdNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro itsahuemma, inu'ma ticuaita pe lopa'a al pu'hua. Licuaitsi jiƚpiya ehuelojmhuo'ma al c'a. Ixim'ma ma le'a lijahua' liju'ecompa licuerpo Jesús. Ipainanni, i'huana'ma liƚya'. Timiyoxi: “¿Te qui'ipa?” ");
INSERT INTO chdNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Maƚe litine oquexi' liƚejmale Jesús tiyeyi lane ticuaita liƚya' cuftine Emaús. Lipiculi' Jerusalén to imbamaj nuli kilómetro. ");
INSERT INTO chdNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iƚne tipalaic'oyoƚtsi, ti'nujuaisyi jahuay li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mipalaic'oyoƚtsi, micuis'eyoƚtsi, mu'iyoƚtsi icuaitsi Jesús. Iyejmale'me anuli. ");
INSERT INTO chdNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iƚne aimimetsaicoyi Jesús. ȽanDios aiquepi'ila' lane. ");
INSERT INTO chdNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús timila': ―Imanc' monƚeyi lane, ¿te coƚmipoƚtsi? Ecaxoƚenca. Ixhueƚconca. I'i'ma cafcuana liƚxans. ");
INSERT INTO chdNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Anuli iƚniya, iƚque lipuftine Cleofas, italai'e'e'ma, timi: ―Lan xanuc' nomana' Jerusalén, jahuay iƚniya iƚsina' li'ipa jiƚpiya iƚna'a ƚitiné. Ja'ni ma lun Jerusalén, ja'ni locuenaye xanuc', jahuay iƚsina'. ¿Te ma le'a ima' aicoxina'? ");
INSERT INTO chdNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Timila': ―¿Te qui'ipa? Iƚne timiyi: ―Aƚ'nujuaisyi li'ipa Jesús ƚas Nazaret. Iƚque aprofeta, acueca' litaiqui', li'epa acueca' jouc'a. ȽanDios jouc'a lan xanuc' imetsaicopá. ");
INSERT INTO chdNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lixanuc' cal cuecaj ca'ailli' jouc'a laƚxanuc', iƚne lan tsilaj xanuc' noxpijpá lataiqui', icupá tima'anƚe, epaƚts'ingimpá lancruz. ");
INSERT INTO chdNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Illanc' aƚcuapá iƚque alunƚu'e'monga' illanc' ixanuc' Israel, tulij'mola' laƚ'eponga' laic'. ’Itsiya ixhuaita afane' quitine quima'anni, joupa imanapa. ");
INSERT INTO chdNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hualca lacaƚ'no' iƚne laƚejmalepá aƚspaic'ehuo'monga'. Ai'a ti'i'ma quitine iƚniya itsehuo'me pe lopa'a al pu'hua. ");
INSERT INTO chdNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Licuaitsa jiƚpiya aiquiƚsina' licuerpo Jesús. Ipailinamma. Alu'iponga': “Aƚsimpola' oquexi' lapaluc' quema'a. Iƚniya aƚmiponga' Jesús imaf'i'.” ");
INSERT INTO chdNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","’Lijou'ma hualca laƚejmale itsehuo'me al pu'hua. Ixinghuo'me ailopa'a licuerpo ma to luya'apa lacaƚ'no'. Maƚque Jesús aiquiƚsina'. ");
INSERT INTO chdNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iƚque timila': ―Imanc' tocomma ailopa'a coƚpicuejma'. ¿Te aimi'iya molapenufyacu linespa lam profeta? ");
INSERT INTO chdNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ja'ni aicoƚsina' joupa ixpic'empá titeƚcoƚa' cal Cristo y tijouƚa' tepenuf'ma limane ticuxe'ma jahuay? ");
INSERT INTO chdNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesús ipango'ma uhuaƚ'ma lataiqui' liniƚpa Moisés, lijou'ma uhuaƚ'ma linespa lam profeta, ti'hua tuhuaƚque jahuay loya'apa al Paxi Liniƚingiya petsi lopalaicopa maƚque Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Icuaitsa liƚya' pe loyepá, Jesús tocomma to tuyai'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Loquexi' timiyi: ―Aimoyai'ma. Topanenni. Joupa if'acoƚaipa cal 'ora. Aƚmanenca. Jesús itsuflaipá lajut'ƚ anuli iƚne. Imanenca. ");
INSERT INTO chdNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Icutsoƚai'me titetso'me. Jesús epef'ma ƚa'i, ix'najtsi'i'ma ȽanDios, ixquenuf'ma, epi'i'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tocomma to exi'enni liƚ'u'. Imetsaico'me Jesús. Aiquicoƚ'ma, aits'ixim'me, tocomma to joupa i'huanapa. ");
INSERT INTO chdNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","I'nujuaitsa li'ipola' miyeyi lane, imi'moƚtsi: ―Maƚeyi lane anuli, maƚpalaic'onga' iƚque, muhuaƚque al Paxi Liniƚingiya, ƚinca aƚsingufcopá acuecaj mafca ƚalunxajma'. ");
INSERT INTO chdNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Maƚpe 'hora itsolinca, iye'me Jerusalén. Licuaitsa ixinim'mola' limbamaj nuli lan apóstole, jouc'a locuenaye liyejmalepá Jesús efoƚya, ");
INSERT INTO chdNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ticuayi: ―Al ƚinca imaf'inapa Caƚ'ailli', joupa itsahuenamma, Simón iximpa. ");
INSERT INTO chdNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Loquexi' uya'a'me li'ipola' miyeyi lane. Timiyi: ―Lixquenuf'ma ƚa'i, jiƚpe limetsaicopá Jesús. ");
INSERT INTO chdNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mipalaic'oyoƚtsi toƚta'a icuaitsi Jesús. Ecax'ma nolojmay. Timila': ―Aimoƚsueƚmot'ƚe'me. ");
INSERT INTO chdNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Iƚniya ixpailij'mola' juaiconapa. Aiquiƚsingufi ja'ni Jesús. Ticuayi: ―Acue quinxpaic'ale. ");
INSERT INTO chdNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús timila': ―¿Te coƚsueƚmot'ƚecopa? Jiƚpe loƚpicuejma' toƚcuayi: “¿Ja'ni Jesús o a'i?” ¿Te coƚnescocopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Toƚsinƚe laimane', lai'mitsi'. Ma' iya'. Aƚ―lafla', toƚta'a ti'i'ma coƚsina' ma' al ƚinca capa'a iya'. Lahuelojnla', tipa'a laipixic', laipecaƚ. Ƚinxpaic'ale ailopa'a quipixic' quipecaƚ. ");
INSERT INTO chdNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Lijoupa limipola' toƚta'a imuc'i'mola' limane', li'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iƚne ixoj'ma quileta juaiconapa. Afule micuec'eyi tipa'a Jesús. Ixim'me juaiconapa acueca' li'ipa. Jesús timila': ―¿Te tipa'a ƚaifteja? ");
INSERT INTO chdNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Epi'i'me ƚaj hualca ƚamixqui' catu. ");
INSERT INTO chdNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Epenuf'ma, mehuelojnyi iƚniya, ite'ma. ");
INSERT INTO chdNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Timila': ―Ma maƚmana' anuli iya' nu'ipolhuo' laƚ'iya. Nu'ipolhuo': “Jiƚpe litaiqui' Moisés, jouc'a liƚtaiqui' lam profeta, jouc'a jiƚpe lan Salmo uya'a'me laƚ'iya iya'. Ticuicomma tenanƚƚa' jahuay.” Itsiya enanƚpa. ");
INSERT INTO chdNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lijou'ma, epalc'o'i'mola' liƚpicuejma', ticuec'eƚe al Paxi Liniƚingiya. ");
INSERT INTO chdNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Timila': ―Al Paxi Liniƚingiya tuya'e': “Cal Cristo titeƚco'ma, tima'am'me. Afane' litine titsahueno, timaf'ina'ma, tipano pe lomana' limanapola'.” ");
INSERT INTO chdNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jouc'a ticua: “Ni petsi li'a ƚamats' tuya'am'me: Toƚsuej'menca, tolapenufle cal Cristo, toƚta'a ȽanDios timenc'e'eco'molhuo' loƚ'epa lixcay.” ’Jifa'a liƚya' Jerusalén tipangoƚa' iƚe loluya'ayacu. ");
INSERT INTO chdNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imanc' joupa oƚsimpá jahuay laƚ'ipa, toluya'a'me. ");
INSERT INTO chdNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cai'Ailli' joupa icupa cataiqui', icuapa te ts'i'ic' lapi'iyacolhuo'. Toƚta'a iya' cumme'etolhuo'. Cai'Ailli' Nopa'a lema'a tepi'i'molhuo' coƚmane. Toƚmanenca fa'a Jerusalén, toƚ'huaicoƚe ti'iƚa' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lijou'ma, Jesús ileco'mola', ipalyonca liƚya' Jerusalén. Icuaitsa liƚya' Betania. Jiƚpiya i'nof'e'ma limane, ipaxne'mola'. ");
INSERT INTO chdNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mipaxnela' enaj'moxi, ilecom'me al toncay. ");
INSERT INTO chdNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ts'ilihuequi exc'onƚcoƚinca. Lijou'ma ipailinamma juaiconapa ixoj'ma quileta, iyena'me Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Itine itine tiyeyi al cuecaj xoute'. Jiƚpe tix'najtsi'iyi ȽanDios. Amén. Toƚta'a li'ipa.");
INSERT INTO chdNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Al te'a ai'a tipango'ma jahuay, tipa'a anuli ƚecui'impá Lataiqui'. Iƚque ƚecui'impá Lataiqui' copa'a pe lopa'a ȽanDios. Iƚque ma' anDios. ");
INSERT INTO chdNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ai'a tipango'ma jahuay, iƚne ȽanDios y Lataiqui', anuli tiƚmana'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jiƚquiya Lataiqui' ilanc'epa jahuay. Jahuay lopa'a lilanc'epa iƚquiya. Ailopa'a cocuena nilanc'epa. Maƚquiya ilanc'epa jahuay. ");
INSERT INTO chdNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jiƚquiya tipa'a lipitine. Nij naitsi lepi'ipa, ma iƚquiya quituca' i'hueca lipitine. Iƚque tepi'ila' liƚpitine lan xanuc', tepalc'o'ila' liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jifa'a li'a ƚamats' lan xanuc' juaiconapa amuf liƚpicuejma'. Jiƚquiya ti'hua tepalc'o'ila'. Jiƚiya al cuecaj muf aimi'iya mipijya jiƚque lipepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tipa'a anuli cal xans cuftine Juan. ȽanDios epi'i'ma lipenic', ti'eƚa' ma to limipa. ");
INSERT INTO chdNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Icuxe'epa tu'itsola' lan xanuc' naitsi iƚque Ƚapalc'o'iyacola'. Jahuay ti'huaiyijnle jiƚquiya Lepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jiƚque Juan a'i jiƚquiya Lepalc'o'. Aimi'iya mepalc'o'iyacola' lan xanuc'. Le'a tipalaico'ma Ƚapalc'o'iyalepa. ");
INSERT INTO chdNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jiƚquiya ƚopalaicopa Juan, iƚque ƚinca Epalc'o'. Icuai'ma fa'a li'a ƚamats', tepalc'o'ila' lan xanuc' ni petsi lomana'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ƚilanc'epa li'a ƚamats' icuai'ma fa'a, lan xanuc' aiquilimetsaijma. ");
INSERT INTO chdNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Petsi lomana' lipiƚya' xanuc' maƚpiya icuaiyunni. Iƚniya aiquilepenufi. ");
INSERT INTO chdNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lan xanuc' nepenufpá, iƚne no'huaiyijmpá, jiƚquiya epi'i'mola' liƚmane timetsaicontsola' inaxque' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iƚne, ¿te ts'i'ic' li'ipola' inaxque' ȽanDios? ¿Te quiƚ'ailli' acueca' xans? A'i. O, ¿te iƚniya quiƚtuca' liƚpicuejma' ixpic'e'me ti'itsoƚtsi inaxque' ȽanDios? A'i. O, ¿te anuli cal cuecaj quincuxepa ixpic'epa, imipola': “Iya' cacua: Ti'itsola' inaxque' ȽanDios”? A'i. Ma ȽanDios ixpic'epa, toƚta'a li'ipola' iƚniya inaxque' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iƚque ƚecui'impá Lataiqui' maƚque anDios, i'epoxi xans, icuaiyunni ma fa'a li'a ƚamats'. Ipajmpa pe laƚmana', aƚsimpá te ts'i'ic' lipicuejma' jiƚquiya, maƚque cal Nuli qui'Hua ȽanDios. Aƚsimpá ituca', ailopa'a xonca toƚquiya. Iƚque ma le'a ac'a lixpic'ejma'. Aimifelƚaique. Aƚtoc'inga'. Lu'inga' al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Bautista tu'ila' lan xanuc': ―Ticuaihuo ƚi'Hua ȽanDios. Ujfxi ipalaic'o'mola', timila': ―Fa'a tipa'a iƚque ƚaipalaicopa, aimipolhuo': “Iya' aicuai'ma ate'a. Tijouƚa' ticuaihuo ocuena xonca cal cueca'. Jiƚque ƚinca cal te'a. Iya' ma ailaifpa'a, jiƚquiya tipa'a.” Itsiya toƚsinƚe, joupa icuai'ma. Ma fa'a tipa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iƚquiya ixhuaiya lipicuejma'. Illanc' a'i quixhuaiya laƚpicuejma', lahue'enga' axpe'. Iƚquiya ƚinca ixhuaiya lipicuejma'. Aƚƚanc'e'enga' laƚpicuejma', ti'iƚa' al c'a. ȽanDios joupa aƚtoc'iponga'. Itsiya' xonca aƚtoc'inga'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lummepa Moisés, aƚtoc'iponga'. Iƚque uya'a'ma locuxepa ȽanDios. Itsiya xonca aƚtoc'inga', ummepa Jesucristo. Maƚque aƚtoc'inga', aƚmuc'inga' jahuay al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nij naitsi niximpa ȽanDios. Cal Nuli qui'Hua ȽanDios tiƚmana' anuli, ma' iƚque aƚmuc'iponga' li'ejma' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lan xanuc' judío, maƚniya nomana' liƚya' Jerusalén, ummem'mola' la'aillí, jouc'a notoc'iyalepá la'aillí. Icuaiyunca pe lopa'a Juan Bautista, icuis'e'me, timiyi: ―¿Naitsi ima'? ");
INSERT INTO chdNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan u'i'mola' al ƚinca, aiquemi'e'mola', timila': ―Iya' a'i ninCristo. ");
INSERT INTO chdNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Icuis'econa'me, timiyi: ―Lu'itsonga', ¿naitsi ima'? ¿Te ima' unElías? Timila': ―Iya' a'i. Icuis'econa'me, timiyi: ―ȽanDios icuapa: “Cumme'e'molhuo' anuli ƚaiprofeta”. Itsiya illanc' licuis'ehuo', ¿te ima' iƚque cal profeta? Italai'e'e'mola', timila': ―Iya' a'i. ");
INSERT INTO chdNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Icuis'econa'me, timiyi: ―Lu'itsonga', ¿naitsi ima'? Ticuicomma lu'itola' lalummeponga'. ¿Te cofnescoyacoxi? ¿Te ts'i'ic' lopenic'? ");
INSERT INTO chdNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan italai'e'e'mola', ipalaico'moxi. U'i'mola' litaiqui' cal profeta Isaías, tuya'e': Petsi ailopa'a quiƚya' tuya'e' anuli cal xans, tu'ila' lan xanuc': “Toƚƚanc'e'eƚe lipene ƚaƚPoujna”. Toƚta'a ipalaico'moxi Juan Bautista. ");
INSERT INTO chdNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Iƚniya lummempola' nopalaic'opá Juan afariseo. ");
INSERT INTO chdNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ti'hua tipalaic'oyi Juan, timiyi: ―Ima' tocua: “Iƚniya cal Cristo, cal Elías, cal profeta ƚommeya ȽanDios, iƚne ocuenaye, a'i iya'”. Ne'. Itsiya ¿te cofmepo'icopola' lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Juan italai'e'e'mola', timila': ―Iya' capo'icola' aja'. Itsiya fa'a pe loƚmana' tipa'a ocuena. Imanc' aicolimetsaijma. Jiƚquiya xonca acueca' xans. Iya' ni aimi'iya cuhuaƚc'e'eya lic'eJi'. Tijouƚa' cajou'neƚa' iya' laipenic' iƚque tipango'ma lipenic'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Toƚta'a li'ipa jiƚpe cuftine Betábara, ƚu'huaj quiyay al pana' Jordán, maƚpiya Juan tepo'iyale. ");
INSERT INTO chdNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lihuequi litine Juan ixim'ma Jesús icuaico'ma. Timila' lan xanuc': ―¡Toƚsinƚe! Iƚque ƚiMoƚ ȽanDios. Tiƚonc'e'e'mola' liƚjunac' lan xanuc' nomana' fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iya' joupa aipalaicopa iƚquiya. Joupa nu'ipolhuo': “Cajou'neƚa' laipenic' iƚque tipango'ma lipenic'. Iƚque xonca acueca'. Iya' ma' ailaifpa'a jiƚque tipa'a.” ");
INSERT INTO chdNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iya' aicainimetsaijma. Iya' aicuaicoco'ma capo'itsolhuo' imanc' ixanuc' Israel, tolimetsaicoƚe jiƚquiya. ");
INSERT INTO chdNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Juan ma ti'hua tipalaijma Jesús. Tuya'e' li'ipa, ticua: ―Iya' aicainimetsaijma Jesús. Aicaixina' naitsi jiƚquiya. Aiximpa cal Espíritu Santo ti'onƚcospa to anuli cal paloma, imumma ehuoxaf'caipa ƚijuac Jesús. Maƚque ȽanDios ƚalummepa capo'iyaleƚa' aja', aƚmipa: “Toxim'ma timuyohuo lema'a cal Espíritu Santo. Tehuoxaf'cai'ma ƚijuac anuli cal xans. Jiƚquiya aimepo'icoyacolhuo' aja'. Tepo'ico'molhuo' cal Espíritu Santo.” Toƚta'a laƚmipa ȽanDios. Itsiya camilhuo' jiƚquiya Jesús i'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lihuequi litine tecaxhuoƚanna Juan jouc'a oquexi' ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan ixim'ma Jesús ti'hua lane. Timila' ts'ilihuequi: ―¡Tolahuelojnle! Jiƚquiya iMoƚ ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iƚniya loquexi' ts'ilihuequi Juan icuej'me lonespa. Ihuejna'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús ipai'e'moxi, ixim'mola' loquexi' iƚenc'e, timila': ―¿Te colahuepá? Iƚniya italai'e'e'me Jesús, timiyi: ―Rabí, ¿pe copanc'epa? (Lataiqui' “Rabí”, iƚe ahebreo, ticuajmaispa: Omxi.) ");
INSERT INTO chdNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús timila': ―Tonƚouyunca. Ƚepá. Toƚsinna. Iye'me, ixintsa jiƚpe pe lipanc'epa Jesús. Joupa uyaipa nolojmay cummuhuijma'. Imanequenca jiƚe litine. ");
INSERT INTO chdNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Lijoupa licuejpá linesma Juan iƚne loquexi' ihuejna'me Jesús, anuli cuftine Andrés, iƚque ipima Simón Pedro. ");
INSERT INTO chdNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés ehuetsi ƚipima, iƚque Simón, timi: ―Illanc' aƚsimpá cal Mesías. Iƚe lataiqui' “Mesías” ticuajmaispa: Cal Cristo, iƚque ƚommeya ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés ilecohuona'ma Simón, icuaitsa pe lopa'a Jesús. Jesús ehuelojm'ma Simón, timi: ―Ima' unSimón, mi'hua Jonás. Ima' tecui'im'mo' unCefas. “Cefas” ataiqui' hebreo. Maƚe lataiqui' griego “aPedro”, ticuajmaispa: Acueca' capic. ");
INSERT INTO chdNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lihuequi litine Jesús ixpic'e'ma ti'hua'ma al distrito Galilea. Mi'hua lane italecuf'ma anuli cal xans cuftine Felipe. Timi: ―Lihuejnaƚa'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jiƚquiya Felipe qui'huayomma Betsaida, liƚpiƚya' Andrés y Pedro. ");
INSERT INTO chdNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe ehuena'ma anuli cal xans cuftine Natanael, timi: ―Moisés jouc'a lam profeta ipalaicopá anuli cal xans. Joupa aƚsimpá iƚque. Maƚque Jesús ƚas Nazaret, i'hua José. ");
INSERT INTO chdNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael timi: ―Liƚya' Nazaret, ¿jiƚpiya tipa'a al c'a? Felipe timi: ―Ƚepá. Toxinna. ");
INSERT INTO chdNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús lixim'ma icuaico'ma Natanael. Inesco'ma, ticua: ―Jifa'a tipa'a anuli cal c'a xans. Ma' al ƚinca i'hua Israel. Aimifelƚaique. ");
INSERT INTO chdNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael icuis'e'ma, timi: ―¿Te li'ipa lalimetsaicopa? ¿Pe caƚsinyopoƚtsi? Jesús timi: ―Ai'a tijoc'i'mo' Felipe, aiximpo'. Cofpa'a lipunxahua la'icux. ");
INSERT INTO chdNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael timi: ―Rabí, ima' i'Hua ȽanDios. Ima' maƚRey illanc' ixanuc' Israel. ");
INSERT INTO chdNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús timi: ―Ma le'a aimipo': “Aiximpo' cofpa'a lipunxahua la'icux”, toƚta'a aƚ'huaiyijm'ma. Toxim'ma xonca' al cueca'. ");
INSERT INTO chdNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Imicona'ma: ―Iya' camilhuo': Toƚsim'me lema'a exiya. Aƚsim'ma aƚ'onƚcospa to al hualijm'ma petsi tif'ajliyi, tilimulumma lepaluc' ȽanDios. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Uyaipa oquej quitine, lihuequi quitine i'i'ma juic camana jiƚpiya liƚya' Caná, al distrito Galilea. Jiƚpiya i'hua'ma qui'máma' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ijoc'impola' Jesús jouc'a ts'ilihuequi. Jiƚpiya icuaitsa al juic. ");
INSERT INTO chdNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ijouna'ma al vino. Qui'máma' Jesús u'i'ma, timi: ―Joupa ijounapa al vino. Ailopa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús italai'e'e'ma qui'máma', timi: ―Momá, ¿te caƚmicopa toƚta'a? A'i quixhuaiya lai'hora. ");
INSERT INTO chdNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Qui'máma' timila' notoc'iyalepá: ―Tonƚ'eƚe lomiyacolhuo' jiƚquiya. ");
INSERT INTO chdNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jiƚpiya timana' acamts'us lan tsila' capixú lilanc'ecompola' apic. Anuli anuli timangospa amalpu' nuxans o amaxnu litro laja'. Lan xanuc' ixhuico'me laja' epajco'me liƚpime o liƚmane' o liƚ'mitsi', ma to liƚ'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús timila' notoc'iyalepá: ―Toƚma'niƚe caja' iƚne ƚapixú. ");
INSERT INTO chdNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Timiconala': ―Itsiya tonlipa'aƚe tutani, toƚmuc'itsa tixnac'otsi cal mayordomo. Itai'me. ");
INSERT INTO chdNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Notoc'iyalepá, iƚniya nipa'apá al vino, iƚsina' petsi quipa'apa. Cal mayordomo aiquixina'. Ixnac'o'ma laja' joupa ipai'ipa, i'ipa avino. Ijoc'i'ma ƚamanepa, ");
INSERT INTO chdNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","timi: ―Ima', itsiya quite' luhua'inga' al c'a vino. A'i toƚta'a mi'enni. Ate'a ticunni al c'a vino. Tijouƚa' tixnaƚe axpe' vino lijoc'impola', tuhua'i'mola' a'ijc'a vino. ");
INSERT INTO chdNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mipa'a Jesús liƚya' Caná al distrito Galilea toƚta'a ipango'ma imujpa lo'epa acueca'. Ts'ilihuequi imetsaico'me jiƚquiya ituca', xonca acueca', a'i to locuenaye lan xanuc'. I'huaiyijm'me. ");
INSERT INTO chdNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Imu'ma al 'ocay, icuaitsi liƚya' Capernaum. Qui'máma' jouc'a lipimaye jouc'a ts'ilihuequi iyejmalena'me. Jiƚpe imanenca oque' afane' quitine. ");
INSERT INTO chdNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Joupa icuaico'ma liƚjuic lan xanuc' judío. Jiƚiya al juic cuftine al Pascua. Jesús if'aj'ma al cueca' quiƚya' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jiƚpe ƚinujnca al cuecaj xoute' ixim'mola' lincucale ticujyi huacax, mot'ƚ jouc'a paloma. Lan xanuc' ti'naji titsufco'me ȽanDios jiƚpe al cuecaj xoute'. Jouc'a ixim'mola' nopai'ipá tomí ticutsoƚanna jiƚpe liƚmesá. ");
INSERT INTO chdNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Uxcui'ma lixmi, ihuetsai'mola' lan mot'ƚ jouc'a lan huacax. Iƚniya nopai'ipá tomí eca'ni'i'mola' liƚtomí, ecanait'ƚi'mola' liƚmesá. ");
INSERT INTO chdNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Timila' nocujpá paloma: ―Tunlipa'antsola'. Jifa'a ejut'ƚ cai'Ailli'. Aimonƚ'e'e'me to laplaza. ");
INSERT INTO chdNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ts'ilihuequi licuej'me lines'ma Jesús i'nujuaitsa loya'apa al Paxi Liniƚingiya, tuya'e': Juaiconapa aipic'a lomejut'ƚ, aicaxnet'ƚya latets'icopa lan xanuc'. Juaiconapa acueca' laipixhuejma', tocomma aƚma'a'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Lan xanuc' judío icuis'e'me Jesús, timiyi: ―¿Te cof'ecopa toƚiya? Aƚmuc'itsonga' al cueca' lof'eya. Toƚta'a aƚcua'me al ƚinca epi'impo' lomane. ");
INSERT INTO chdNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús italai'e'e'mola', timila': ―Ne'. Tolateƚaf'le iƚca'a lejut'ƚ ȽanDios. Ti'iƚa' afane' quitine, iya' joupa aitsahue'enamma. ");
INSERT INTO chdNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lan xanuc' judío italai'e'e'me, timiyi: ―Lilanc'empa jiƚta'a lejut'ƚ ȽanDios icoƚpa oquej nuxans camts'us camats'. Itsiya ima' tocua: “Ti'iƚa' afane' quitine joupa aitsahue'enamma”. Aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús aimipalaijma al cuecaj xoute'. Lines'ma: “… iƚca'a lejut'ƚ ȽanDios”, tinescoyoxi licuerpo. ");
INSERT INTO chdNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ts'ilihuequi Jesús lixim'me limaf'inapa, lipanamma pe lomana' limanapola', iƚniya i'nujuaisnatsa iƚiya litaiqui' Jesús. Icuapá: “Al ƚinca liniƚingiya al Paxi Cataiqui'. Al ƚinca linespa Jesús.” ");
INSERT INTO chdNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jiƚpe al cuecaj quiƚya' Jerusalén ti'eyi al juic Pascua. Maƚpiya tipa'a Jesús. Ti'ay al cueca'. Imuc'i'mola' lan xanuc' acueca' lipaxi. Lixim'me acueca' lo'epa, axpela' lan xanuc' ticuayi: “Lihuejna'me Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesús aimi'huaiyingila' iƚniya. Ixinguf'mola' jahuay lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aiquicuis'ela', ¿te ts'i'ic' cu'hua cal xans lipicuejma'? Imetsaicola' lan xanuc' te ts'i'ic' liƚpicuejma', ja'ni ac'a o ja'ni a'ijc'a. ");
INSERT INTO chdNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Anuli cal xans cuftine Nicodemo icuai'ma pe lopa'a Jesús. Iƚque Nicodemo afariseo, ipenic' pe lomana' lif'as xanuc' fariseo. Icuaitsi joupa imufc'opa. Timi: ―Momxi, aƚsina' ima' xonca tomuc'iyale, ȽanDios ummepo'. Ima' to'ay al cueca'. ȽanDios epi'ipo' lomane, ja'ni a'i aimi'iya mo'eya toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús italai'e'e'ma, timi Nicodemo: ―Iya' camihuo' al ƚinca: Lan xanuc' ticuicomma timajnlicontsa, ja'ni a'i aimi'iya mitsuflaiyacu pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo timi: ―Cal xans ƚitojpa, ¿te co'iya mipajnconaya? ¿Te nipajnya titsufai'ma licu'u qui'máma', tijouƚa' tipajnconna? ");
INSERT INTO chdNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús italai'e'e'ma, timi: ―Iya' camihuo' al ƚinca: Ticuicomma tuyaicoƚa' laja' jouc'a tepenufla' cal Espíritu Santo. Iƚque cal xans ƚinca ipajnconna. Ja'ni a'i, aimi'iya mitsufaiya pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lan xanuc' liƚnaxque' laiƚepá ti'onƚcospola' to iƚniya, mane axanuc'. ȽanDios linaxque' ti'onƚcospa to iƚque. Iƚne linaxque' ȽanDios tipa'a al ts'e liƚpitine, joupa lepi'ipola' cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aimoxhueƚmot'ƚe'ma laimipo': “Imanc' unc'ixanuc' ticuicomma toƚmajnlicontsa”. ");
INSERT INTO chdNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ƚahua' ni petsi ti'hua. Tocueca lona'apa, aicoxina' pe lo'huayomma, ni petsi lotsepa. Ma toƚiya aimi'iya mocuejya li'ipa cal xans pe cal Espíritu Santo i'e'epa i'hua ȽanDios. Iƚque cal xans joupa ipajnconna. Ituca' li'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo italai'e'e'ma Jesús, timi: ―¿Te co'iya iƚta'a laƚmipa? ");
INSERT INTO chdNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús italai'e'e'ma, timi: ―Ima', lof'as xanuc' Israel imetsaicohuo' uncueca' momxi. ¡Aimocueca' laifmipo'! ");
INSERT INTO chdNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iya' camihuo' al linca: Illanc' aƚpalaicoyi iƚe laƚsina', luya'ayi laƚsimpa. Imanc' aimolapenufyi laluya'apa. ");
INSERT INTO chdNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nu'ipolhuo' lo'ipola' lan xanuc' mimana' fa'a li'a ƚamats', aimaƚcuec'e. Ja'ni cu'itsolhuo' loxpic'epa ȽanDios iƚque Nopa'a lema'a, ¿te co'iya maƚcuec'eya? ");
INSERT INTO chdNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nij naitsi nif'ajpa lema'a. Ma le'a cal Xans li'ipa Ƚiximpa cal profeta pu'hua lema'a, iƚque ƚinca imuyommma lema'a. ");
INSERT INTO chdNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","’Limajmpá petsi ailopa'a quiƚya' Moisés y lixanuc', lainofat'ƚ ticala' lan xanuc', tima'annila'. Moisés ilanc'e'ma anuli ƚainofaƚ catejma', ipo'nopa al 'ec, i'nof'e'ma. Lan xanuc' lehuelojm'me iƚque ƚainofaƚ unƚul'me. Ma toƚta'a ticuicomma ti'nof'em'me cal Xans, iƚque li'ipa Ƚiximpa cal profeta. ");
INSERT INTO chdNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Lan xanuc' no'huaiyijmpá iƚque, jahuay iƚniya, tepi'im'mola' al ts'e liƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’ȽanDios i'nujuais'mola' lan xanuc' nomana' li'a ƚamats', ixim'mola' acuanuc'la. Tipa'a ma le'a anuli ƚi'Hua. Icupa iƚque, aimejac'mola' iƚniya no'huaiyijmpá ƚi'Hua ȽanDios, tepi'im'mola' al ts'e liƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ȽanDios lummepa iƚque ƚi'Hua li'a ƚamats' a'i mecani'eyacola' lan xanuc'. Ummecopa tunƚu'e'mola'. ");
INSERT INTO chdNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Cal xans no'huaiyijmpa ƚi'Hua ȽanDios a'i mecani'eya. Ja'ni aimi'huaiyinge, joupa ecanipa. Aiqui'huaiyinge cal Nuli qui'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","’Lepalc'o' icuai'ma fa'a li'a ƚamats'. Lan xanuc' ti'eyi lixcay, toƚiya xonca iƚpic'a al muf. ");
INSERT INTO chdNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mi'eyi lixcay jahuay iƚniya, ti'eyi laic' lepalc'o'. Aimiƚoc'oƚaiyummma. Ticuayi: “Aimaƚsim'monga' illanc' laƚ'epa”. ");
INSERT INTO chdNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iƚniya no'epá al c'a tehueyi lepalc'o'. Ticuayi: “Lan xanuc' ti'iƚa' quiƚsina' lihuejcoyi ȽanDios. Maƚque aƚcuxenga'.” ");
INSERT INTO chdNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jesús ipamma, i'hua'ma al distrito Judea. Ts'ilihuequi jouc'a iye'me. Icuaitsa imanequenca jiƚpiya. Iƚne ts'ilihuequi Jesús epo'iyale'me. ");
INSERT INTO chdNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Iƚniya ƚitiné Juan Bautista jouc'a tepo'iyale. Aiquitats'enni, ma ti'hua ti'ay lipenic'. Juan tipa'a petsi cuftine Enón, huejnca Salim. Jiƚpiya tipa'a axpe' caja'. Tiƚcuaiyumma lan xanuc' tepo'ila'. ");
INSERT INTO chdNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ts'ilihuequi Juan ipalaic'o'moƚtsi lan judío, ifuli'i'moƚtsi cataiqui', tipalaicoyi lo'eyacu ja'ni ȽanDios tixintsola' alimpio, tepenuftsola'. ");
INSERT INTO chdNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ts'ilihuequi Juan icuaitsa pe lopa'a iƚque, timiyi: ―Momxi, tipa'a ocuena comxi tepo'iyale. Moƚmana' ƚu'hua al panaj Jordán, imanc' onƚejmale. Ima' lopalaic'opola' lan xanuc' onesco'ma iƚque. Itsiya jahuay lan xanuc' tiyeyi pe lopa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan italai'e'e'mola', timila': ―Ma ȽanDios tixpic'e te ts'i'ic' laƚpenic' laƚ'epa. Ja'ni a'i, ailopa'a caƚpenic'. ");
INSERT INTO chdNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imanc' joupa oƚcuejpá laimipolhuo': Iya' a'i ninCristo. ȽanDios alummepa cacuaiyunni ate'a, cu'itsola' lan xanuc' ticuaihuo cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Temaneƚa' ƚamijcano tipa'a ƚiƚejmale. Ma le'a ƚamijcano ƚamaneya tileco'ma ƚipeno. Ƚiƚejmale titoc'i'ma tiquimf'e, tixoqui queta ticueca lonespa. Itsiya iya' aƚ'onƚiconno iƚque ƚiƚejmale. Iya' tixoqui neta nulemma. ");
INSERT INTO chdNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Itsiya ca'oc'ena'moxi. Toƚta'a lan xanuc' tixim'me iƚque cal Cristo acuecaj xans. ");
INSERT INTO chdNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Illanc' ninc'ixanuc' maƚmana' fa'a li'a ƚamats' ma le'a aƚsina' te ts'i'ic' mipa'a fa'a ƚamats'. Maƚe caƚnescopa. Iƚque ƚimuyomma lema'a, iƚque ƚinca xonca ixina'. ");
INSERT INTO chdNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iƚque tuya'e' liximpa licuejpa mipa'a pu'hua. Itsiya aimetenƚcocola', aimepenufyi. ");
INSERT INTO chdNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Naitsi napenufpa litaiqui' loya'apa nimuyomma lema'a, iƚque cal xans timuqui te ts'i'ic' ȽanDios lipicuejma'. ȽanDios aimifelƚaique. ");
INSERT INTO chdNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iƚque ƚimuyomma lema'a ȽanDios ummepa, tuya'e' ma lonespa ȽanDios. ȽanDios epi'ipa cal Espíritu Santo ticuxeƚa' jahuay lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","’ȽanDios qui'Ailli' Jesucristo ti'ay capic'a ƚi'Hua. Epi'ipa limane ticuxeƚa' jahuay. ");
INSERT INTO chdNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cal xans nepenufpa ƚi'Hua ȽanDios ma tipa'a al ts'e lipitine aimijouya. Naitsi natets'ipa ƚi'Hua ȽanDios ailopa'a al ts'e lipitine. Ma mi'hua metets'i ƚi'Hua ȽanDios, maƚque ȽanDios tixtu'hua, titeƚ'mi'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Lam fariseo icuej'me lonespa lan xanuc', iƚne tinesconni: “Jesús tepo'ila' axpela' lan xanuc'. Tixpela' ts'ilihuequi. Itsiya Juan Bautista tepo'ila' ahuata.” ");
INSERT INTO chdNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesús aiquepo'ila' lan xanuc'. Ma ts'ilihuequi tepo'iyaleyi. ");
INSERT INTO chdNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús li'ipa quixina' toƚta'a tinescoyi ipayonni al distrito Judea. Jouc'a ts'ilihuequi iye'me al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tuyaicota ƚamats' Samaria. ");
INSERT INTO chdNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Icuaitsa anuli liƚpiƚya' lun samaritano. Liƚya' cuftine Sicar. Iƚe liƚya' tipa'a huejnca anuli ƚamats' li'ipa i'huexi cal xans Jacob. Iƚque epi'ipa ƚi'hua José. ");
INSERT INTO chdNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Maƚpiya tipa'a al pu'hua caja' lipupa Jacob. Jesús i'huacopa cane joupa ixocaita, icutsafcai'ma lico al pu'hua caja', tunxaj'ma. I'ipa to menac'o. ");
INSERT INTO chdNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Anuli ƚaca'no' asamaritana icuai'ma al pu'hua caja', tipa'a'ma quija'. Jesús timi: ―Luhui'iƚa' caija', caxna'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ts'ilihuequi Jesús ailomana'. Iyepá liƚya' ti'nata ƚotejacu. ");
INSERT INTO chdNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ƚaca'no' italai'e'e'ma Jesús, timi: ―Ima' umjudío, iya' naca'no' ninsamaritana. Ima', ¿te caƚpalaic'ocopa? ¿Te caƚsahue'ecopa caja'? (Lun judío aimiyejmaleyi lun samaritano.) ");
INSERT INTO chdNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús timi: ―Ima' aicoxina' naitsi iya'. Jouc'a aicoxina' te ts'i'ic' iƚe lapi'iyacola' ȽanDios lan xanuc'. Ja'ni coƚa' oxina', aƚsahue'e'ma iya' cuhui'itso' coja'. Iya' cuhui'i'mo' al c'a caja' lainupa. ");
INSERT INTO chdNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ƚaca'no' timi: ―Mai'ailli', iƚta'a laja' a'ojca, ailopa'a cofmipa'acoya. ¿Petsi cofxi'ne'eya jiƚiya al c'a caja' lainupa? ");
INSERT INTO chdNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iƚta'a al pu'hua aƚpo'no'eponga' ƚaƚtahuelo Jacob. Maƚque Jacob jifa'a ixnapa iƚta'a laja'. Jouc'a linaxque', lipinneja ixnapá. ");
INSERT INTO chdNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús italai'e'e'ma, timi: ―Cal xans noxnaya jiƚta'a laja' ticuiconahuo quija'. ");
INSERT INTO chdNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Cal xans noxnaya laja' laifcupa aimicuiconaya quija'. Iƚe laja' laifcupa tipanehuo ƚunxajma', ti'onƚcospa to luxi caja', ti'hua tinu, ticu al ts'e lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ƚaca'no' timi: ―Mai'ailli', jiƚiya laja' lofnescopa, luhui'iƚa'. Tijouƚa' aimicuiconaya caija', ni aicuyaiconaya liƚya' quipa'aconaya caija'. ");
INSERT INTO chdNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús timi: ―To'huaƚa', tojoc'itsi ƚope'ailli'. Toƚcuaiyunca fa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ƚaca'no' timi: ―Ailopa'a caipe'ailli'. Jesús timi: ―Al ƚinca lofnespa: “Ailopa'a caipe'ailli'”. ");
INSERT INTO chdNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Joupa oƚƚaitsufcopoƚtsi amajxi loxanuc'. Itsiya oƚƚaitsufcoyoƚtsi anuli cal xans ma a'i cope'ailli'. Al ƚinca lofnespa. ");
INSERT INTO chdNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ƚaca'no' timi: ―Mai'aill', iya' cacua ima' umprofeta. ");
INSERT INTO chdNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Illanc' laƚtatahueló jiƚca'a ƚijuala exc'onƚingoƚai'me ipalaic'o'me ȽanDios. Ma' anuli illanc' laxc'onƚingoƚaiyi fa'a. Imanc' unc'ijudío aƚminga': “Imanc' jouc'a jahuay lan xanuc' tonƚe'me Jerusalén”. Toƚcuayi, ma le'a jiƚpiya al cuecaj xoute' laxc'onƚingoƚaita, aƚpalaic'ota ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús timi: ―Maca'no', camihuo' al ƚinca. Icuaico'ma litine imanc' aimoƚnesyacu: “Jifa'a ƚijuala laxc'onƚingoƚai'me ȽanDios”. Ni lan xanuc' judío minesyacu: “Ƚepá Jerusalén. Jiƚpe laxc'onƚingoƚaita ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Imanc' moƚnesyi: “Laxc'onƚingoƚaiyi ȽanDios”, aicolimetsaijma ȽanDios. Illanc' ninc'ijudío limetsaicoyi ȽanDios. Aƚinca laxc'onƚingoƚaiyi, aƚpalaic'oyi. Petsi lan xanuc' judío ti'huayohuo jiƚquiya Nonƚu'eyacola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","’Ticuaitsi litine locuaicoya, iya' cacua joupa icuai'ma, lan xanuc' aimehueyacu anuli al lugar texc'onƚingoƚaiƚe ȽanDios. Ma jiƚpe liƚpicuejma' ti'nujuaisnata ȽanDios, tihuejco'me locuxe'epola', timetsaico'me. Latenƚcocopa ȽanDios texc'onƚingoƚaiƚe toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ȽanDios a'Espíritu, ailopa'a quicuerpo, ma le'a ipicuejma'. Lan xanuc' tama ticuayi: “Laxc'onƚingoƚaiyi ȽanDios”, ja'ni jiƚpe liƚpicuejma' aimi'nujuaisyi iƚque, ja'ni aimihuejcoyi locuxe'epola', ȽanDios aimetenƚcocoya laxc'onƚingoƚaipa iƚne lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ƚaca'no' timi: ―Aixina' ticuaihuo cal Mesías, jiƚquiya ƚecui'impá “cal Cristo”, ƚommeya ȽanDios. Itsiya tehue'e' laƚpicuejma' aicaƚcueca. Ma ticuaiyunni jiƚquiya lu'ina'monga' jahuay. ");
INSERT INTO chdNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús timi: ―Maƚque tipalaic'ohuo' itsiya. Iya' ninCristo. ");
INSERT INTO chdNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Maƚpe mipalaic'oyoƚtsi icuainanca ts'ilihuequi Jesús. Iƚne aiquilicuis'e: “¿Te cofpalaic'ocopa jiƚquiya ƚaca'no'? ¿Te cahue'epo'?” Mane liƚpicuejma' ticuayi: “Xinƚa', Jesús tipalaic'o anuli ƚaca'no'”. ");
INSERT INTO chdNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ƚaca'no' ipo'no'ma lijuti, ipainanni, i'hua'ma lipiƚya'. Timila' lan xanuc' jiƚpiya: ");
INSERT INTO chdNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Tonƚouyunca. Camuc'itolhuo' anuli cal xans nalu'ipa jahuay lai'epa. ¿Te ma jiƚquiya cal Cristo? ");
INSERT INTO chdNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Lan xanuc' ipalunca jiƚpe liƚpiƚya', iye'me pe lopa'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ai'a ticuaicu lan xanuc', ts'ilihuequi Jesús ihui'i'me, timiyi: ―Momxi, totetsoƚa'. ");
INSERT INTO chdNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús timila': ―Imanc' aicoƚsina'. Tipa'a ƚaifteja. ");
INSERT INTO chdNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Maƚne ts'ilihuequi Jesús ticuis'eyoƚtsi, timiyoƚtsi: ―¿Naitsi nepi'ipa ƚoteja? ");
INSERT INTO chdNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús timila': ―A'i. Aicalapi'inno. Iya' ca'ay lipenic' ȽanDios, iƚe lixpic'epa Ƚalummepa, cajou'ne'ma. Ma ca'ay lipenic' ȽanDios tocomma catesma, ti'hua ti'i caipujfxi. ");
INSERT INTO chdNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","’Imanc' toƚcuayi: “Tehue'e' amalpuj mut'ƚa, tijouƚa' tetequim'me lan trigo”. Iya' camilhuo': Toƚsinƚe jipu'hua pe lifayiya. Tocomma joupa unta'anamma, itojpa. I'huájta afujca. Iya' cacua joupa i'huajcopa litine tetequim'me. ");
INSERT INTO chdNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ti'najtsem'me ƚatejpa trigo. ȽanDios jouc'a ti'najtse'ma iƚque ƚafot'ƚepola' lan xanuc', iƚne nolijyacu al ts'e liƚpitine aimijouya. Anuli ƚifapa, ƚocuena tetequi, tefot'ƚe, tijouƚa' loquexi' tixojna'ma quileta. ");
INSERT INTO chdNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Toƚta'a ti'i'ma al ƚinca lataiqui' loya'apa: “Tipa'a anuli nofapa, ƚocuena nafot'ƚeya”. ");
INSERT INTO chdNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iya' nummepolhuo' imanc' tonlafot'ƚeta petsi aicoƚfac'. Locuenaye ifapá, imanc' tonlafot'ƚeta maƚpiya li'eyopa canic' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jiƚpe liƚya' Sicar ƚaca'no' joupa uya'ahuo'ma: “Iƚque aƚminapa jahuay lai'epa”. Licuej'me iƚe licuapa ƚaca'no' axpela' iƚniya lun samaritano i'huaiyijmpá Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Icuaiyunca pe lopa'a iƚque, timiyi: ―Ƚepá laƚpiƚya'. Jiƚpiya topajnta. Jesús i'hua'ma liƚpiƚya'. Ipajnhuo'ma oquej quitine. ");
INSERT INTO chdNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jiƚpe liƚya' lan xanuc' tiquimf'eyi Jesús lines'ma. Xonca axpela' i'huaiyijm'me. ");
INSERT INTO chdNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iƚne timiyi ƚaca'no': ―Ate'a ima' opalaico'ma Jesús. Illanc' aƚcuayi ma' al ƚinca ima' lofnespa. Itsiya illanc' caƚtuca' aƚcuejnapá linespa jiƚquiya, toƚta'a aƚsina' aƚinca iƚque lunƚu'e'monga' jouc'a tunƚu'e'mola' lan xanuc' ni petsi lomana' li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Luyaipa oquej quitine Jesús ipanni jiƚpe liƚya', i'hua'ma al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Aiqui'huacona'ma al distrito Judea. Maƚquiya ines'ma: “Cal xans, tama aprofeta ƚummepa ȽanDios, mipa'a maƚpe lipiƚya' aimipalaicoyacu c'a lan xanuc', tetets'iyacu”. ");
INSERT INTO chdNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma licuaitsi Galilea lan xanuc' jiƚpiya ƚinca epenuf'me. Iƚniya iyehuo'me al juic Jerusalén, joupa ixinghuo'me lo'epa jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mipa'a Jesús al distrito Galilea i'huacona'ma Caná, jiƚpiya petsi lipai'ihuo'ma laja', i'ipa vino. Jiƚpe Caná tipa'a anuli cal xans, ts'ipenic' cal rey, ƚi'hua textafque. Iƚque ƚafcuana tipa'a liƚya' Capernaum, maƚpe al distrito Galilea. ");
INSERT INTO chdNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ts'ipenic' icuejpa Jesús ailopa'a Judea, joupa icuaiconata Galilea, i'hua'ma, i'huajcotsi Jesús, ixahue'etsi ti'huaƚa' liƚya' Capernaum, tixaƚ'meta ƚi'hua, iƚque tima'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús timi: ―Imanc' toƚcuayi: “Iƚque Jesús aƚmuc'itsonga' al cueca'”. Ja'ni aicamuc'ilhuo' toƚta'a aimaƚ'huaiyijnya. ");
INSERT INTO chdNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ts'ipenic' cal rey timi: ―Mai'ailli', aimicoƚ'mo'. Ƚepá lajut'ƚ. Ja'ni a'i, timana'ma ƚai'hua. ");
INSERT INTO chdNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús timi: ―To'huanƚa'. Ƚo'hua imaf'i'. Aimimaya. Cal xans i'huaiyijmpa Jesús limipa, i'huana'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma mi'huanghua lane Capernaum, iƚniya notoc'ipá italecufunca, timiyi: ―Joupa ixaƚconapa ƚo'hua. ");
INSERT INTO chdNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Icuis'e'mola', timila': ―¿Tej hora lixaƚconapa? Timiyi: ―Tsumjma lixhuaita anulij hora luyaipa menac'o iƚojn‑na'ma ƚipinu'. ");
INSERT INTO chdNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Cal xans i'nujuaitsi li'ipa. Tsumjma maƚpe 'hora Jesús limipa: “Ƚo'hua imaf'i'. Aimimaya.” Cal xans jouc'a lixanuc' nomana' lejut'ƚ, i'huaiyijmpá Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Itsiya i'ipa oquemma li'epa al cueca' Jesús jiƚpe al distrito Galilea. Iƚque joupa itsehuo'ma Judea, icuaiconata Galilea. ");
INSERT INTO chdNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lijou'ma jiƚiya i'huajcopa liƚjuic lan xanuc' judío. Efoƚunni pu'hua Jerusalén. Jesús i'hua'ma, icuaitsi jiƚpe liƚya'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ahuejnca pe lotsuflaicoyacu lam mot'ƚ jiƚpe liƚya' Jerusalén ipa'nempá laja' acueca' quin'nuhua' i'empa. Lipuftine ataiqui' hebreo aBetesda. Jiƚpe lin'nuhua' canumicay tipa'a amaque' ƚinujnca. ");
INSERT INTO chdNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Maƚpe ƚinujnca timana' axpela' lafcualƚay tunahuoƚanna. Timana' lan fohue, lan coxo, jouc'a luhuaƚqueya. Jahuay iƚniya iƚ'huaijma tifentsi laja'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Camna camna anuli ƚapaluc quema'a timuyomma, tife'ne jiƚiya laja'. Tijouƚa' tife'neƚa' laja' cal te'a ƚo'nijmaispa tixaƚma. Ni naitsi cuana tuyainapa. ");
INSERT INTO chdNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma jiƚpiya tipa'a anuli cal xans ixhuaita anuxans quimbamaj paico camats' mextaf'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús ixim'ma iƚque cal xans tunouya. Joupa ixina' axpe' camats' i'ipa licuana. Timi: ―¿Opic'a tixaƚcontso'? ");
INSERT INTO chdNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ƚafcuana italai'enni, timi: ―Mai'ailli', mifenna laja' ailopa'a naƚ'nij'miya. Ma ca'hua'ma ocuena ti'nij'miyoxi ate'a. Iƚque tixaƚconghua, iya' capanemma. ");
INSERT INTO chdNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús timi: ―¡Tacaxla'! ¡Tonif'la' ƚohuijm‑ma'! ¡To'huanƚa'! ");
INSERT INTO chdNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ixaƚcona'ma nulemma iƚque cal xans, inif'na'ma ƚihuijm‑ma'. I'huana'ma. Iƚe litine lixaƚcona'ma maƚe itine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lan judío timiyi cal xans ƚixaƚcona'ma: ―Itsiya litine conxajya. Aimi'iya motaiya ƚohuijm‑ma'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Cal xans timila': ―Iƚque ƚaƚsaƚ'menapa aƚmipa: “Tonif'la' ƚohuijm‑ma', to'huanƚa'”. ");
INSERT INTO chdNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Iƚniya icuis'e'me, timiyi: ―¿Naitsi iƚque ƚimipo': “Tonif'la' ƚohuijm‑ma', to'huanƚa'”? ");
INSERT INTO chdNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cal xans ƚixaƚcona'ma aiquixina' naitsi iƚque ƚimipa toƚiya. Axpela' lan xanuc' jiƚpiya timana'. Jesús joupa itsufainapa pe lomana'. Cal xans aiquixina' petsi lo'huapa. ");
INSERT INTO chdNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lijou'ma italecufcona'moƚtsi pu'hua al cueca' xoute'. Jesús timi: ―¡Toxinxoxi! Joupa ixaƚconapo'. Aimo'econa'ma quixcay. Ja'ni to'econghua quixcay, ti'i'ma xonca acueca' lofteƚcoya. ");
INSERT INTO chdNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Cal xans i'hua'ma, u'ihuo'mola' lan judío, timila': ―Ƚaƚsaƚ'menapa maƚque Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lan judío iƚsina' Jesús tixaƚ'mela' lafcualƚay litine conxajya, ixtulenca, tihuetsojyi. ");
INSERT INTO chdNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús timila': ―Cai'Ailli' ti'hua ti'ay canic', iya' jouc'a ca'ay canic'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lan judío xonca ixtulenca toƚta'a linesma Jesús. Icua'me: “Iƚque Jesús ti'ay quixcay, ti'ay canic' litine conxajya. Ti'ay xonca lixcay, tinesqui: ȽanDios ai'Ailli'. Ma' ti'onƚiyoxi ȽanDios.” Xonca tehueyi te co'iya mima'ayacu. ");
INSERT INTO chdNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús timila': ―Iya' i'Hua ȽanDios, camilhuo' al ƚinca: Iya' caituca' ailopa'a caif'eya. Aimi'iya. Iya' i'Hua ȽanDios, ate'a cahuelojm'ma lo'epa cai'Ailli', tijouƚa' ca'e'ma to lo'epa iƚque. ");
INSERT INTO chdNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iya' i'Hua ȽanDios, iƚque cai'Ailli' aƚ'ay capic'a, aƚmuc'i jahuay lo'epa. Tijouƚa' aƚmuc'i'ma xonca acueca', iya' ca'e'ma. Imanc' toƚsim'me, tixpailij'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","’Cai'Ailli' ixina' timaf'i'ina'mola' limanapola'. Tepi'ina'mola' liƚpitine. Iya' i'Hua ȽanDios jouc'a aixina' camaf'i'ina'mola' limanapola'. Caxpic'e ja'ni capi'ina'mola' liƚpitine, jouc'a caxpic'e ja'ni aicapi'iyacola'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","’Ticuaiyunni Lijoujma Quitine cai'Ailli' aimimu'iyacola' lan xanuc' te ts'i'ic' loyalaicoyacu ni'epá lixcay. Joupa lapi'inapa laimane, iya' cu'itsola' te ts'i'ic loyalaicoyacu iƚniya. Iya' ninJuez. ");
INSERT INTO chdNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Cai'Ailli' ixpic'epa lihuejcoƚa' lan xanuc' ma to mihuejcoyi jiƚque cai'Ailli'. Cal xans pe aimalihuejma iya' i'Hua ȽanDios jouc'a aimalihuejconga' cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Iya' camilhuo' al ƚinca: Cal xans ja'ni ticueca laitaiqui', ja'ni ti'huaiyinge cai'Ailli', iƚque Ƚalummepa fa'a li'a ƚamats', iƚque cal xans joupa ulijpa al ts'e lipitine aimijouya, aimecaniya. Iƚque, ai'a ticuej'ma laitaiqui', ȽanDios tecani'e'ma, itsiya a'i. Aimijouya lipitine iƚque cal xans. ");
INSERT INTO chdNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iya' camilhuo' al ƚinca: Iya' i'Hua ȽanDios cajoc'i'mola' limanapola'. Iƚniya nocuejyacu laitaiqui' timaf'ina'me. Litine ca'e'ma toƚta'a ti'hua ticuaihuo. Iya' cacua: Joupa icuai'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cai'Ailli' i'hueca lipitine, nij naitsi nepi'ipa. Jouc'a iya' ai'hueca laipitine, iya' i'Hua, toƚta'a lixpic'epa cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","’Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Toƚta'a cai'Ailli' aƚfajpa ninJuez, lapi'ipa laimane cu'i'mola' lan xanuc' ja'ni ac'a o ja'ni a'ijc'a li'epa. Cu'i'mola' te ts'i'ic' loyalaicoyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Aimixpailij'molhuo' iƚe laimipolhuo'. Aimoƚnes'me: “¿Te co'iya toƚta'a? Aimi'iya.” Iya' camilhuo': Limanapola' nomana' liƚpu'hua, jahuay iƚniya ticuej'me cajoc'itsola' iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Ticuaihuo litine ti'i'ma toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jahuay limanapola' tipalcu liƚpu'hua. Ja'ni li'epa al c'a timaf'ina'me nulemma, tuyalaina'me al c'a. Ja'ni ixcay li'epa jouc'a timaf'ina'me, iƚne titeƚco'me, nulemma titai'me liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Iya' caituca' ailopa'a caif'eya. Aimi'iya. Cai'Ailli' aƚcuxe'e laifmiyacola' lan xanuc'. Iya' caituca' aicu'iya cal xans ja'ni ti'ay al c'a o ja'ni ti'ay lixcay. To maƚcuxe'e cai'Ailli' toƚe laifmiya. Ma le'a aƚijca laitaiqui'. Iya' aicahuay te co'iya ca'eya laifpixc'epa. Ma to loxpic'epa cai'Ailli', iƚque Ƚalummepa, toƚta'a caxpic'e. ");
INSERT INTO chdNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","’Ja'ni iya' caituca' canescoyoxi, aimi'ommaicoya iƚe laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ƚinca tipa'a anuli noya'apa naitsi iya'. Iya' aixina' iƚque tuya'e al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","’Imanc' olummepola' loƚxanuc' tiyeƚe pe lopa'a Juan Bautista. Jiƚnu'hua icuis'e'me naitsi iya'. Juan imi'mola' al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iya' aicahuay caƚnescoya toƚta'a anuli cal xans. Le'a aipic'a tunƚu'entsolhuo' imanc', toƚta'a ca'nujuaitsi'ilhuo' linespa Juan. ");
INSERT INTO chdNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan Bautista ti'onƚcospa to anuli lepalc'o'. Tepalc'o'ila' lan xanuc'. Micoƚi iƚque lipenic' imanc' tolihuejyi tixoqui conlata. Iƚque epalc'o'ipolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Iƚque u'i'mola' lan xanuc' naitsi iya'. Itsiya imanc' toƚsinyi laif'epa. Iƚe xonca tuya'e naitsi iya', ma' anuli tuya'e naitsi Ƚalummepa, iƚque cai'Ailli'. Iƚe laif'epa, cai'Ailli' joupa aƚcuxe'epa ca'eƚa'. Lapi'ipa laipenic' cajou'neƚa'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","’Cai'Ailli' Ƚalummepa jouc'a u'ipolhuo' naitsi iya'. Iƚque lopalaipa aicoƚcueca ni aicoƚsina' te ts'i'ic' iƚque. ");
INSERT INTO chdNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ȽanDios cai'Ailli' lummepa, imanc' aimalapenufi. Litaiqui' aimipanemma jiƚpe loƚpicuejma', toƚta'a imanc' aimalapenufi. ");
INSERT INTO chdNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","’Toƚsueƚe al c'a al Paxi Liniƚingiya. Toƚcuayi: “Iƚe al Paxi Liniƚingiya lapi'inga' laƚpitine aimijouya”. Maƚiya lataiqui' aƚpalaijma iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Imanc' tama toƚsueyi iƚe lataiqui' aimalihuejma. Aicoƚcuac'. ¿Te co'iya molulijyacu loƚpitine? A'i, aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Aicahuela' lan xanuc' caƚmiya: “Ima' uncuecaj xans”. A'i. Iƚta'a aicapenufi. ");
INSERT INTO chdNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Iya' aixinnilhuo' imanc' te ts'i'ic' loƚpicuejma'. Aixina' aimoƚ'nujuaisyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iya' ma cai'Ailli' lapi'ipa laipenic'. Toƚta'a aicuai'ma fa'a li'a ƚamats'. Imanc' aimalapenufi. Anuli cal xans nocuxepoxi quituca', ja'ni ticuaiyunni, imanc' ƚinca tolapenuf'me. ");
INSERT INTO chdNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Imanc', ¿te co'iya malapenufya? Tolahuela' loƚf'as xanuc' timetsaicontsolhuo'. Aimolahueyi te co'iya mimetsaicoyacolhuo' cal Nuli ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aimoƚnes'me: “Iƚque Jesús aƚcuftonga'. Timita ȽanDios a'ijc'a laƚ'epa.” Ocuena tipa'a ƚocufyacolhuo'. Iƚquiya aMoisés. Imanc' toƚcuayi: “Moisés aƚtoc'i'monga', aƚtalai'ecotonga'”. Iya' cacua: Aimitoc'iyacolhuo'. Maƚque Moisés ƚocufyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Imanc' toƚcuayi: “Lihuejcoyi licuapa Moisés”. A'i molihuejcoyi Moisés. Ja'ni tolihuejcoyi Moisés jouc'a iya' lihuejco'ma. Ma' iya' aƚpalaicopa Moisés jiƚpe liniƚpa. ");
INSERT INTO chdNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Imanc' aimolihuejcoyi liniƚpa Moisés. Toƚta'a, ¿te co'iya molihuejyacu laifmipolhuo'? Imanc' aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jesús iquie'ma al cuecaj quin'nuhua'. Iƚe lin'nuhua' tipa'a oque' lipuftine, aGalilea jouc'a aTiberias. ");
INSERT INTO chdNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Axpela' lan xanuc' ehuelojm'me axpe' al cueca' lo'epa Jesús, ehuelojm'me mixaƚ'menala' lafcualƚay. Iƚne nehuelojmpá toƚta'a tihuejnayi. ");
INSERT INTO chdNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesús jouc'a ts'ilihuequi if'ajli'me ƚijuala, icutsoƚai'me jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tehue'e' oque' afane' quitine ti'i'ma liƚjuic lan xanuc' judío. Iƚiya al juic cuftine al Pascua. ");
INSERT INTO chdNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús ehuelojm'ma, ixim'mola' ticuaico'me axpela' lan xanuc'. Timi Felipe: ―¿Pe caƚ'na'eyacu axpe' ƚa'i titeƚe iƚniya? ");
INSERT INTO chdNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús joupa ixina' lo'eya. Icuis'e'ma Felipe titalai'eƚa' iƚque, timujxoxi te ts'i'ic' lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe italai'e'ma, timi: ―Ja'ni aƚ'natsa axpe' ƚa'i lipitali lolijya no'eya canic' oquej maxnu quitine, ni toƚta'a aimi'ommaicoyacola', ni aimitec'oyacu anuli anuli iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ƚocuena ts'ihuequi ipalaic'o'ma Jesús. Iƚque Andrés, ƚipima Simón Pedro, timi: ");
INSERT INTO chdNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Toxinƚa', jifa'a tipa'a anuli ƚamijcano, itaic' amaque' la'í lilajncopa acebada, jouc'a oquexi' laicatuye. ¿Ja'ni iƚe litaic' ti'ommaico'mola'? A'i. Aimi'iya. Timana' axpela'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús timila' ts'ilihuequi: ―Toƚcuxe'etsola' lan xanuc' ticutsoƚaiƚe ƚamats'. Jiƚpiya tipa'a axpe' cal pajac. Lan xanuc' icutsoƚai'me. Tiƚmana' to amaquej mil lan xanuc', jouc'a timana' lacaƚ'no', la'uhuay. ");
INSERT INTO chdNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús epef'ma ƚa'i, ix'najtsi'i'ma ȽanDios, epi'i'mola' nocutshuoƚanna jiƚpiya. Ma toƚta'a i'e'ma jouc'a latuye. Aiquixpij'ma iƚe ƚotejacu. ");
INSERT INTO chdNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lan xanuc' itetso'me ixhuaitsola'. Jesús timila' ts'ilihuequi: ―Tolafot'ƚeƚe lan hualcay lipanecomma, aimica'nico'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ts'ilihuequi Jesús efot'ƚena'me lan hualcay ca'i ƚilajncopa acebada lipanecomma, imane'me imbamaj coque' lan tsiquihuit'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lan xanuc' ixim'me acueca' lipepaxi Jesús, acueca' li'epa, ticuayi: ―Iƚca'a cal xans aprofeta. Iƚca'a ma' iƚque Ƚommeya ȽanDios, joupa icuai'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iƚpic'a ti'noƚƚe Jesús, ti'e'e'me quiƚrey. Jesús ixina' toƚta'a lo'eyacu lan xanuc', enaj'moxi, i'hua'ma quituca' ƚijualay. ");
INSERT INTO chdNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lummuhuijma' ts'ilihuequi Jesús imulna'me, icuai'me al cuecaj quin'nuhua'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Itsuflai'me al barco, ipango'me uyalaico'me laja'. Ticuaitsa locuena quiju' lin'nuhua' jiƚpe liƚya' Capernaum. Imufaj'mola'. Ts'ilihuequi imanenca quiƚtuca'. Jesús ailopa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Juaiconapa ti'hua ƚahua'. Iƚiya laja' tiyuf'comma acueca'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","I'hua'a'me al barco. Tixhuaispa to amaque' o acamts'us kilómetro li'hua'apa, ts'ilihuequi Jesús ixim'me iƚque icuaico'ma, ti'hua ti'huaf'que laja', tixpailiquila'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús timila': ―Aimixpailij'molhuo'. Ma' iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Licuej'me toƚta'a linespa Jesús tixoqui quileta tepenuf'me tif'ajla' al barco. Aiquicoƚi, icuainatsa ƚamats' pe lotsepa. ");
INSERT INTO chdNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lihuequi litine timana' lan xanuc' lefot'ƚepoƚtsi tecaxoƚanna liju' al cuecaj quin'nuhua'. Iƚne ticuayi: “¿Te qui'ipa? Tsumjma tipa'a le'a anuli al barco. Iƚiya al barco i'hua'a'me ts'ilihuequi Jesús, iƚniya quiƚtuca'. Itsiya, ¿pe copa'a Jesús?” ");
INSERT INTO chdNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ixim'me icuai'me lam barco quiyouyumma liƚya' Tiberias, timanemma huejnca jiƚpe ƚamats' petsi lan xanuc' itepá ƚa'i lepi'ipola' Jesús lijoupa lix'najtsi'ipa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lijoupa li'ipa quiƚsina' ailopa'a Jesús, ailomana' ts'ilihuequi, iƚne lan xanuc' if'ajli'me lam barco, iye'me Capernaum, tehueta Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Icuaitsa locuenaj liju' lin'nuhua' ixinna'me Jesús, timiyi: ―Momxi, ¿tej hora locuai'ma fa'a? ");
INSERT INTO chdNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús timila': ―Iya' camilhuo' al ƚinca: Tama laƚsimpa ma ca'ay al cueca', aimuc'ipolhuo' laipepaxi, imanc' aicoƚcueca. Joupa oƚtepá ƚa'i, inajncotolhuo', toƚta'a lahuay. ");
INSERT INTO chdNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tonlipa'acoyi loƚpujfxi tonlulijcoƚe ƚoƚtejacu, iƚe ƚominscoya. Iya' camilhuo': Tonlipa'acoƚe loƚpujfxi, tonlulijcoƚe ƚocuena catetsoya, iƚe aimiminscoya, ti'hua ticoƚi, tepi'i'mola' lan xanuc' liƚpitine aimijouya, tites'mi'ma iƚe liƚpitine. Iƚque cal tejua' iya' nipajnya capi'i'mola' lan xanuc'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ȽanDios cai'Ailli' joupa lacuej'micopa, lapi'ipa laimane ca'eƚa' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lan xanuc' timiyi: ―Ja'ni aƚ'e'me latenƚcocoya ȽanDios, ¿te caƚ'eyacu? ");
INSERT INTO chdNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Italai'e'e'mola' timila': ―Imanc' toƚ'huaiyijnle iƚque ƚummepa ȽanDios. Ja'ni tonƚ'e'me toƚta'a ma tonƚ'eyi latenƚcocopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Timiyi: ―To'eƚa' al cueca', tijouƚa' aƚ'huaiyijm'mo'. Ne'. Itsiya aƚmuc'itsonga' toƚta'a lof'eya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Laƚtatahueló mimana' petsi ailopa'a quiƚya' iximpá al cueca' li'ipa. Iƚniya ite'me iƚe cuftine “al maná”. Toƚta'a loya'apa al Paxi Liniƚingiya, ticua: “Iƚque epi'i'mola' ƚa'i qui'huayomma lema'a titeƚe”. ");
INSERT INTO chdNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús timila': ―Iya' camilhuo' al ƚinca: Ƚa'i qui'huayomma lema'a aiquepi'ilhuo' Moisés. Ma cai'Ailli' nicupa ƚa'i qui'huayomma lema'a. Iƚque ƚinca ƚa'i. ");
INSERT INTO chdNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ƚa'i qui'huayomma lema'a iƚque ƚe'i ȽanDios. Fa'a li'a ƚamats', ni petsi lomana' lan xanuc' iƚque ƚa'i tepi'i'mola' liƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lan xanuc' timiyi: ―Maƚ'ailli', itsiya lapi'itsonga' iƚque ƚa'i, ti'hua lapi'i'monga'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Timila': ―Iya' ma Na'i. Naitsi ƚalapenufpa tulijta lipitine aimijouya. Naitsi ƚaƚ'huaiyijmpa aimi'hua micui quija'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","’Iya' joupa nu'ipolhuo' te ts'i'ic' loƚ'ejma'. Tama joupa aƚsimpa, aimaƚ'huaiyinge. ");
INSERT INTO chdNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Timana' laixanuc', iƚniya lalapi'ipa cai'Ailli'. Iƚne ƚinca aƚejmale'me. Iƚniya laƚejmalepá aƚmajm'me anuli, aicatets'iyacola'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","’Iya' nimuyomma lema'a aicuaicoco'ma fa'a li'a ƚamats' ca'eƚa' lixpic'epa ȽanDios, iƚque Ƚalummepa. A'i caxpic'e caituca' laif'eya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iƚque Ƚalummepa lapi'inapa laixanuc'. Maƚque ȽanDios joupa ixpic'epa iya' ca'etsola' cuenna, jahuay iƚniya. Ni anuli mejac'ya. Ticuaiyunni Lijoujma Quitine iya' camaf'i'ina'mola'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Toƚta'a lixpic'epa cai'Ailli'. Ixpic'epa te ts'i'ic' loyaicoya cal xans ƚalimetsaicopa iya' i'Hua ȽanDios. Iƚque cal xans ƚaƚ'huaiyijmpa tulij'ma al ts'e lipitine aimijouya. Ticuaiyunni Lijoujma Quitine iya' camaf'i'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Lan xanuc' judío aiquicuaicocotsi quiƚpic'a iƚe linespa Jesús licuapa: “Iya' Na'i nimuyomma lema'a”. ");
INSERT INTO chdNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tinesyi: ―Iƚque cal xans Jesús i'hua José, o ¿ja'ni ocuena? Limetsaicola' illanc' qui'ailli', qui'máma'. ¿Te caƚmicoponga', ticua: “Iya' nimuyomma lema'a”? ");
INSERT INTO chdNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús italai'e'mola', timila': ―Imanc' ¿te colixtulecomma? ¿Te coƚpalaicopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cai'Ailli' jiƚque Ƚalummepa, ja'ni tijoc'iƚa' anuli cal xans, iƚque tiƚoc'huainahuo pe laifpa'a, aƚejmalena'me. Ticuaitsi Lijoujma Quitine camaf'i'ina'ma. Ja'ni cai'Ailli' aimijoc'i aimi'iya miƚoc'huaiya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lam profeta niniƚpá tuya'ayi: “ȽanDios timuc'ina'mola' jahuay iƚniya”. Al ƚinca iƚta'a lataiqui'. Lan xanuc' noquimf'epá locuapa cai'Ailli', iƚne tihuic'iyi lomuc'ipola', iƚniya ƚinca tiƚoc'oƚainacu pe laifpa'a, aƚejmalena'me. ");
INSERT INTO chdNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nij naitsi niximpa cai'Ailli'. Ma' iya' cai'huayomma ȽanDios. Iya' ƚinca aiximpa cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iya' camilhuo' ma' al ƚinca: Cal xans ƚaƚ'huaiyijmpa joupa ulijpa al ts'e lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","’Ma' iya' Na'i. Naitsi ƚalapenufpa tulijta lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Imanc' loƚtatahueló mimana' pe ailopa'a quiƚya', tama itepá ƚa'i cuftine “al maná”, iƚniya imanapola'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jifa'a tipa'a ituca' ca'i. Iƚque imuyomma lema'a. Ja'ni lan xanuc' titeƚe aimimayacola' nulemma. ");
INSERT INTO chdNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ƚa'i ƚitepa loƚtatahueló, iƚque ƚa'i a'i quimaf'i'. Iya' aimaf'i', iya' Na'i nimuyomma lema'a. Iya' cacu'moxi laicuerpo. Toƚta'a lan xanuc' ni petsi nomajnyacu li'a ƚamats', ja'ni lapenufla' aimimayacola' nulemma, aimijouya liƚpitine. Iƚca'a laicuerpo ƚinca ƚa'i. ");
INSERT INTO chdNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lan xanuc' judío ipango'me ifuli'i'moƚtsi cataiqui'. Timiyoƚtsi: ―Iƚque cal xans, ¿te co'iya micuya licuerpo? ¿Maƚiya licuerpo aƚte'me? ");
INSERT INTO chdNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús timila': ―Iya' camilhuo' al ƚinca: Ja'ni imanc' aimoƚteji laicuerpo, ja'ni aimoƚsnayi laijuats', ailopa'a coƚpitine. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Naitsi notepa laicuerpo, noxnapa laijuats', iƚque ƚinca tipa'a lipitine aimijouya. Ticuaiyunni Lijoujma Quitine iya' camaf'i'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Laicuerpo ƚinca atejua', laijuats' ƚinca loxnayacu lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Naitsi notepa laicuerpo, noxnapa laijuats', ma lapenufi iya', iya' capenufi iƚquiya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","’Iya' ca'huaiyinge iƚque Ƚalummepa, maƚque cai'Ailli' ȽanDios Ƚimaf'i'. Toƚta'a aimijouya laipitine. Ma' anuli aimijouya lipitine cal xans ƚaƚtepa iya', iƚque ƚaƚ'huaiyijmpa. ");
INSERT INTO chdNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Capalaijma ƚa'i ƚimuyomma lema'a, ca'onƚicojma laicuerpo. Ƚa'i ƚite'me loƚtatahueló aimi'onƚspa laicuerpo, ituca' ca'i. Tama iƚniya itepá iƚe ƚile'i, imanapola'. Naitsi ƚaƚtepa iya' laicuerpo, iƚca'a ƚa'i, iƚque tepenufi al ts'e lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Toƚta'a licuapa Jesús mipa'a liƚya' Capernaum, mimuc'iyale jiƚpe lajut'ƚ pe lafoƚyomma lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iƚe lines'ma Jesús aiquetenƚcocola' axpela' ts'ilihuequi. Liquimf'e'me iƚniya ticuayi: ―Ipime iƚiya lataiqui'. ¿Naitsi nocuejya? Illanc' aimi'iya malapenufyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús ixina' iƚniya ts'ilihuequi aiquetenƚcocola' linespa. Timila': ―Ja'ni imanc' aiquetenƚcocolhuo' iƚe lainespa, ");
INSERT INTO chdNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿te coƚcuayacu ja'ni aƚsinƚa' caf'aquinghua, cacuaita pu'hua, petsi lai'huayomma? Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ");
INSERT INTO chdNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Laipalaic'opolhuo' a'i canescojma laipixic'. Lixic' ailopa'a co'eya. Al cuerpo ticuicomma ƚi'espíritu. Ƚaitaiquí ti'onƚcospa to cal espíritu. Ja'ni tolapenuf'me iƚniya ƚaitaiquí, tolulij'me loƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ƚinca hualca imanc' aimaƚ'huaiyinge. Jesús tixinnila' naitsi iƚniya aimi'huaiyijnyi. Jouc'a imetsaijma naitsi iƚque cal xans ƚocuya. Toƚta'a ixina' al te'a. ");
INSERT INTO chdNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Timila' ts'ilihuequi: ―A'i jahuay imanc' maƚ'huaiyinge. Iya' joupa aimipolhuo': Ja'ni cai'Ailli' a'i mijoc'i anuli cal xans, iƚque aimi'iya miƚoc'huaiya pe laifpa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ts'ilihuequi licuej'me iƚe licuapa Jesús, axpela' iƚniya ipailinanca. Aiquilihuejconghua. ");
INSERT INTO chdNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús timila' limbamaj coquexi' ts'ilihuequi: ―Imanc', ¿te conƚ'eyacu? ¿Jouc'a imanc' aƚpo'no'ma caituca'? ");
INSERT INTO chdNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro italai'e'ma, timi: ―Mai'ailli', ¿pe caƚtseyacu? Ocuena comxi to ima' ailopa'a. Ailopa'a co'onƚiyaco'. Ima' maƚpalaic'onga' lapenufyi laƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Illanc' joupa aƚ'huaiyijmpo'. Joupa i'ipa caƚsina', ima' unCristo, ima' i'Hua ȽanDios Ƚimaf'i. ");
INSERT INTO chdNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús timila': ―Unc'imbamaj coquexi' ƚinca ai'huijf'epolhuo'. Tipa'a anuli imanc' onta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús ipalaicopa Judas, ƚi'hua Simón Iscariote. Iƚque anuli iƚniya limbamaj coquexi' ts'ilihuequi Jesús, ticuna'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jesús ipanenni jiƚpiya al distrito Galilea. Aimicua mi'huaya al distrito Judea. Joupa icuejpa lixpic'epa lan judío nomana' jiƚpiya. Iƚniya tehueyi te co'iya mima'ayacu. ");
INSERT INTO chdNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tehue'e' oque' afane' quitine ti'i'ma liƚjuic lan xanuc' judío. Mi'i'ma iƚe liƚjuic lan xanuc' tilanc'eyi liƚpunxahuaƚqui, timajm'me jiƚpe. ");
INSERT INTO chdNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Lipimaye Jesús timiyi: ―Taipanni, to'huaƚa' al distrito Judea petsi lo'iyoya al juic. Pu'hua to'etsi al cueca'. Toƚta'a tixinno' lof'eya iƚniya ts'ihuejhuo' nomana' jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Anuli cal xans, ja'ni ipic'a timetsaicoƚe lan xanuc', iƚque ti'e'ma al cueca' petsi lahuetsaleyompa, aimemiyacoxi. Ima', ¿te cofpanecoya fa'a petsi lan xanuc' aimixinyaco', aimehuelojnyaco' lof'epa al cueca'? Tomujtoxi jipu'hua pe lomana' axpela' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Toƚta'a lonespa lipimaye Jesús, aimi'huaiyijnyi. ");
INSERT INTO chdNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús timila': ―Itsiya aica'eya to laƚmipa. Aimi'iya. Iya' aiquicuaiya lai'hora. Imanc' ƚinca jahuay ƚitiné ti'i'ma tonƚ'e'me ma coƚtuca' loƚspic'eyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Loƚf'as xanuc' nomana' fa'a li'a ƚamats' aimi'iya mi'eyacolhuo' laic'. Iya' ƚinca aƚ'e'e laic'. Aiquiƚpic'a laifnu'ipola', camila': “Tonƚ'eyi lixcay”. ");
INSERT INTO chdNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Imanc', ne', toƚf'ajliƚe al juic. Itsiya aica'huaya. Capanehuo. Aiquicuaiya lai'hora. ");
INSERT INTO chdNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Lijoupa linespa toƚta'a Jesús ipanenni Galilea. ");
INSERT INTO chdNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lipimaye iye'me al juic lo'iya Jerusalén. Lijou'ma Jesús i'hua'ma quituca' Jerusalén. Aicuya'e'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jiƚpiya al juic lan xanuc' judío ehue'me Jesús. Icuis'e'moƚtsi: ―Iƚque cal xans, ¿pe copa'a? ");
INSERT INTO chdNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lan xanuc' nomana' jiƚpe al juic ixouloƚai'me. Timana' nonespá ticuayi: “Iƚque ac'a xans”. Locuenaye ticuayi: “A'ijc'a xans. Ma tifel'miyale.” ");
INSERT INTO chdNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Le'a tixouloƚaiyi. Aiminesyi ujfxi. Tixpaic'ennila' ts'iƚpenic' judío. ");
INSERT INTO chdNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Li'ipa nolojmay juic Jesús if'aj'ma al cuecaj xoute'. Jiƚpe ipango'ma imuc'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Licuej'me lan xanuc' judío ticuayi: ―¡Xinƚa'! Iƚque cal xans aiquimuxejma. ¿Petsi quihuic'iyohuo'ma iƚe litaiqui' lomuc'iyalepa? ");
INSERT INTO chdNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús italai'e'mola', timila': ―Laifmuc'ipolhuo' a'i caituca' laipicuejma'. Iƚe lalu'ipa ȽanDios, iƚque Ƚalummepa, maƚe laifmuc'ipolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cal xans nixpic'epa ti'eƚa' latenƚcocopa ȽanDios, iƚque cal xans timetsaico'ma laifmuc'ipolhuo'. Iƚque ti'i'ma quixina' ja'ni ȽanDios aƚmuc'i o ja'ni quipa'e iya' caituca' laipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cal xans nahuepa te co'iya mimetsaiconyacu ja'ni ac'a xans, iƚque timuc'iyale'ma ma le'a lonespa quituca' lipicuejma'. A'i toƚta'a li'ejma' cal xans loya'apa al ƚinca, aƚijca lipicuejma'. Iƚque aimehuay latenƚcocoyacola' lan xanuc'. Tehuay te co'iya mimetsaicoyacu ac'a iƚque ƚummepa. Toƚta'a lai'ejma' iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Litaiqui' Moisés tu'ilhuo' locuxe'epolhuo' ȽanDios. Toƚcuayi: “Ƚinca Moisés lapi'iponga' illanc' litaiqui' ȽanDios. Ma iƚe lataiqui' laƚcuxeponga'.” Ma moƚnesyi toƚta'a imanc' aimolanant'ƚiyi locuxe'epolhuo' ȽanDios. Imanc' ailopa'a colanant'ƚipa. Itsiya, ¿te colahuecopa te co'iya maƚma'aya? ");
INSERT INTO chdNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lan xanuc' judío lefot'ƚepoƚtsi jiƚpiya timiyi: ―¿Naitsi noma'ayaco'? Ima' itsufaipo' conta'a. Ailopa'a noma'ayaco'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús italai'e'mola', timila': ―Le'a anuli cal xans aixaƚ'menapa litine conxajya, imanc' oƚsueƚcopá, toƚcuayi: “¡Xinƚa'! ¡Jesús ti'ay canic' litine conxajya!” ");
INSERT INTO chdNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Imanc' toƚcuayi: “Moisés aƚcuxe'eponga' aƚ'eƚe circuncidar laƚnaxque' camijcanó. Tama ti'iƚa' litine conxajya toƚta'a aƚ'e'me.” Ƚinca Moisés a'i iƚque copa'a cal te'a nicuxepa toƚta'a. Ai'a tipajnta Moisés toƚta'a lo'epa lan tatahueló. ");
INSERT INTO chdNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Imanc' tixoqui cunlata tonƚ'eyi circuncidar loƚnaxque', tama ti'iƚa' litine conxajya. Toƚcuayi: “Ma' aƚ'eyi laƚcuxe'eponga' Moisés”. Imanc' tetenƚcocolhuo' tetec'enƚe lipixic' ƚamijcano. Toƚsinyi ilajmpa al c'a ƚaqueca. Itsiya camilhuo': ¿Te calixtuc'ocopa imanc' iya' lai'epa litine conxajya? Aixaƚ'menapa anuli cal xans. Ac'a ilajn‑napa jahuay licuerpo. ");
INSERT INTO chdNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Imanc' aicoƚcueca, ma le'a toƚcuayi. Ate'a toƚspic'eƚe loƚnesyacu, tijouƚa' toƚpalaiƚe al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","26","Lan xanuc' lun Jerusalén ixim'me Jesús timuc'iyale. Ticuayi: ―¡Xinƚa'! Ticuanni: “Aƚma'a'me iƚque Jesús”. Itsiya maƚque timuc'iyale. Jahuay tehuelojnyi, ailopa'a co'empa. ¿Te cocuapa lan tsila' quiƚpenic'? ¿Te ticuayi maƚque Jesús copa'a cal Cristo? ");
INSERT INTO chdNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Illanc' aƚcuayi: A'i iƚque cal Cristo. Aƚsina' lipiƚya' li'huayomma. Ticuaiyunni cal Cristo aimi'iya caƚsina' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús mimuc'iyale jiƚpe al cuecaj xoute', tipalay ujfxi, tiquimf'eƚe jahuay, timila': ―Imanc' toƚcuayi: “Limetsaicoyi Jesús”. Toƚcuayi: “Aƚsina' lipiƚya' li'huayomma”. A'i. Aicoƚsina' pe cai'huayomma. Iya' a'i caituca' caixpic'e cacuaihuo fa'a li'a ƚamats'. Tipa'a Ƚalummepa. Iƚque aimifelƚaique. Imanc' aicolimetsaijma. ");
INSERT INTO chdNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iya' ƚinca nimetsaijma. Iya' maƚque cai'huayomma. Iƚque alummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Lan judío ixtulenca licuapa Jesús. Ehue'me te co'iya mi'noƚyacu. Aiquiƚ'noƚi. Aiquicuaiya li'hora, aimi'iya mima'ayacu. ");
INSERT INTO chdNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Axpela' lan xanuc' i'huaiyijm'me Jesús. Tinesyi: ―Ticuaiyunni cal Cristo, ¿ja'ni xonca lo'eya? Acueca' lo'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Lam fariseo iquimf'e'me iƚniya lan xanuc' mixouloƚaiyi, tipalaicoyi Jesús. Lixanuc' cal cuecaj ca'ailli' jouc'a iƚniya lam fariseo umme'me lapaluc' xoute' tiyeƚe, ti'noƚtsa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús ti'hua timuc'iyale, timila' lan xanuc': ―Ahuata capajncona'ma jifa'a pe loƚmana'. Tijouƚa' ca'huana'ma pe lopa'a Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Imanc' lahue'ma, aimaƚsingonaya. Pe laifpa'a imanc' aimi'iya moƚcuaiyacu jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Lan judío tipalaic'oyoƚtsi, tinesyi: ―Ja'ni aimaƚsingonayacu iƚque cal xans, ¿pe cotseya? ¿Te ti'hua'ma ƚilemats' lan xanuc' griego pe lomana' laƚpimaye? ¿Te timuc'itola' jiƚne lan xanuc' griego? ");
INSERT INTO chdNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Jiƚque Jesús aƚminga': “Imanc' lahue'ma, aimaƚsingonaya. Pe laifpa'a jiƚpiya imanc' aimi'iya moƚcuaiyacu.” ¿Te cohuaƚquemma iƚiya? ¿Te conescopa iƚquiya? Aicaƚcueca. ");
INSERT INTO chdNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Icuai'ma lijoujma quitine al juic. Iƚiya litine xonca al cueca'. Ecax'ma Jesús. Tipalay ujfxi, tiquimf'eƚe jahuay, timila': ―Cal xans ƚaicuipa quija' tiƚoc'huaiyunni pe laifpa'a. Tixnaƚa' iƚta'a laja' laifcupa. Iƚque ƚaƚ'huaiyijmpa. ’To muya'e' al Paxi Liniƚingiya toƚta'a ti'i'ma. Tuya'e': “Jiƚpe ƚunxajma' tipahuo axpe' caja'. Iƚiya laja' ti'hua tipahuo. Aimixnajya.” ");
INSERT INTO chdNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lines'ma toƚta'a Jesús ipalaico'ma cal Espíritu Santo, iƚque ƚapenufyacu iƚniya no'huaiyijmpá Jesús. Mipa'a Jesús li'a ƚamats' aicummaic' iƚque cal Espíritu Santo. Ticuainatsi lema'a tumme'etola'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Liquimf'epá iƚiya licuapa Jesús timana' nonespá: ―Ƚinca ȽanDios alumme'eponga' ƚiprofeta, maƚque Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Timana' nonespá: ―Jiƚque ƚinca cal Cristo. Locuenaye tinesyi: ―Cal Cristo aimi'huayoya Galilea. ");
INSERT INTO chdNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tuya'e' al Paxi Liniƚingiya: “Cal rey David itatahuelo cal Cristo”. Jouc'a tuya'e': “Cal Cristo co'huayoya liƚya' Belén. Maƚpe lipiƚya' cal rey David.” ");
INSERT INTO chdNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Toƚta'a iƚniya lan xanuc' aiqui'ic' anuli liƚpicuejma'. Timana' nocuapá: “Maƚque cal Cristo”. ");
INSERT INTO chdNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Timana nocuapá: “Aƚ'noƚta”. Ailopa'a no'noƚya. ");
INSERT INTO chdNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Lepaluc' al cuecaj xoute' ipailinamma. Icuaitsa pe lomana' lixanuc' cal cuecaj ca'ailli' jouc'a lam fariseo. Iƚniya icuis'e'me, timinnila' lilepaluc': ―¿Te qui'ipolhuo'? Aicolihuaic' cal xans. ");
INSERT INTO chdNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Italai'e'me: ―Illanc' aƚcuayi ac'a tipalay iƚque. Ocuena aimipalay to iƚque lopalaipa. ");
INSERT INTO chdNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Lan fariseo italai'e'me: ―¿Te ifel'mipolhuo' imanc' jouc'a? ");
INSERT INTO chdNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Te ti'huaiyinge anuli naƚcuxeponga'? O anuli ƚaƚf'as fariseo, ¿te ti'huaiyinge? A'i. Le'a lan xanuc' aiquiƚmuxejma, ma' iƚniya ti'huaiyijnyi. ");
INSERT INTO chdNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Iƚne ni aiquiƚsina' lataiqui' locuxepa ȽanDios. Joupa ecanipola'. ");
INSERT INTO chdNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jiƚpiya tipa'a anuli ƚiƚf'as fariseo cuftine Nicodemo. Maƚque Nicodemo i'huahuo'ma anuli lipuqui', ipalaic'otsi Jesús. Itsiya timila': ");
INSERT INTO chdNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Litaiqui' ȽanDios laƚcuxe'eponga', lu'inga': “Anuli cal xans titalai'e'ecotsi. Toƚquimf'eƚe locuaya. Ja'ni aicoƚquimf'e aimi'iya molacani'eyacu.” ");
INSERT INTO chdNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Timiyi Nicodemo: ―¿Te ima' unGalilea jouc'a? Toxhueƚa' xonca al Paxi Liniƚingiya. Jiƚpe toxim'ma ailopa'a profeta co'huayoya Galilea. ");
INSERT INTO chdNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jahuay iyena'me ƚilejut'ƚi. ");
INSERT INTO chdNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús i'hua'ma ƚijuala cuftine Ƚijuala Olivo. ");
INSERT INTO chdNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Li'ipa quitine ipaiconanni, i'huacona'ma al cuecaj xoute'. Jiƚpiya jahuay lan xanuc' tefot'ƚeyoƚtsi. Jesús icutshuai'ma timuc'iyale'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mimuc'iyale Jesús icuaita jiƚpiya lomxiye nomuc'iyalepá locuxepa ȽanDios jouc'a lam fariseo. Iƚƚejma anuli ƚaca'no'. Iximpá ƚaca'no' tunahuoƚanna cal xans, iƚque a'i quipe'ailli'. Ecaxu'me ƚaca'no' nolojmay lan xanuc' noquimf'epá mimuc'iyale Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Timiyi Jesús: ―Momxi, joupa aƚsimpola' tunahuoƚanna. Cal xans a'i quipe'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Litaiqui' Moisés, iƚe loya'apa locuxepa ȽanDios, maƚe lataiqui' aƚcuxe'enga' aƚma'acotsola' apic lacaƚ'no' no'epá toƚta'a. Ima', ¿te cofcuaya? ¿Te caƚ'e'eyacu iƚca'a ƚaca'no'? ");
INSERT INTO chdNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iƚne tehuaiyi Jesús. Iƚpic'a tinesla': “Aimonƚ'e'me iƚe locuxepa Moisés”. Tijouƚa' ticuxeco'me. Jesús ic'omai'ma. Iniƚco'ma lidedo ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Iƚniya ihui'i'me, icuis'mot'ƚe'me. Jesús ecaxna'ma ƚijca, timila': ―Anuli imanc' ja'ni ailopa'a quijunac', ne', ate'a teca'niƚa' ƚapic. ");
INSERT INTO chdNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Lijou'ma ic'omaicona'ma, iniƚcona'ma ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Lan xanuc', iƚne ts'iƚƚejma ƚaca'no', imetsaico'moƚtsi jouc'a iƚtaic' liƚjunac'. Anuli anuli iyena'me. Ate'a i'huana'ma xonca ƚitojpa xans, lijou'ma ipalnanca anuli anuli, ijouco'ma ts'atesca quemats'. Jesús ƚaca'no' imanenca quiƚtuca'. Ƚaca'no' ti'hua tecaxu jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús ecaxcona'ma ƚijca, ehuelojm'ma ƚaca'no' tecaxu quituca'. Timi: ―Maca'no', ¿te qui'ipola' iƚne lan xanuc'? Joupa iyenapá. ¿Nij naitsi nitac'uipo' cajunac'? ¿Nij naitsi nicufpo' tima'antso'? ");
INSERT INTO chdNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Iƚque timi: ―Mai'ailli', nij naitsi. Jesús timi: ―Iya' jouc'a aicatac'uiyaco' cajunac'. Iya' aicacua: Tima'antso'. To'huanƚa'. Aimo'econna quixcay. ");
INSERT INTO chdNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús imuc'icona'mola' lan xanuc', timila': ―Fa'a li'a ƚamats' iya' Nepalc'o'. Capalc'o'ila' iƚniya nalihuejpa, iƚne tipa'a liƚpitine aimijouya. Iƚniya liƚpicuejma' aimi'iconaya muf, ticuec'e'me, ti'e'me al c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lam fariseo timiyi: ―Ima' tonescoyoxi cotuca'. A'ij ƚinca lofnespa. ");
INSERT INTO chdNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Timila': ―Tama canescoyoxi ma canesqui al ƚinca. Iya' aixina' pe lai'huayomma, aixina' pe laiftseya. Imanc' aicoƚsina' pe lai'huayomma, aicoƚsina' pe laiftseya. ");
INSERT INTO chdNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Imanc' ma coƚtuca' toƚtac'uila' lajunac' loƚf'as xanuc', toƚspic'eyi ja'ni ac'a ja'ni a'ijc'a lo'epa. Iya' aicatac'uila' cajunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ja'ni catac'uiƚa' lajunac' ma aƚijca iƚe laif'eya. Iya' a'i caituca' caxpic'e. Illanc' ma' anuli aƚspic'eyi iya' cai'Ailli', iƚque Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","’Litaiqui' ȽanDios locuxepa ticua: “Oquexi' lan xanuc', ja'ni ma' anuli lonespa, ne', tapenufla' iƚe locuapa”. ");
INSERT INTO chdNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iya' canescoyoxi. Jouc'a cai'Ailli' iƚque Ƚalummepa, ma' anuli aƚnesma. ");
INSERT INTO chdNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Timiyi: ―¿Pe copa'a co'ailli'? Timila': ―Imanc' aicalimetsaijma naitsi iya'. Jouc'a aicolimetsaijma cai'Ailli'. Ja'ni limetsaijma iya', jouc'a cai'Ailli' tolimetsaico'me. ");
INSERT INTO chdNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Toƚiya licuapa Jesús mipa'a al cuecaj xoute', mimuc'iyale. Ticutsuya liju' al caxax pe latoj'mimpá al tomí. Nij naitsi ni'noƚpa Jesús. Aiquicuaiya li'hora. ");
INSERT INTO chdNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","U'icona'mola', timila': ―Ca'huana'ma. Imanc' lahue'ma. Timaco'molhuo' coƚtaic' loƚjunac'. Iya' caituca' ca'hua'ma, aimi'iya maƚeyacu anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Lan xanuc' judío ticuayi: ―¿Te conescopa: “Iya' caituca' ca'hua'ma, aimi'iya maƚeyacu anuli”? ¿Ja'ni tima'a'moxi? ");
INSERT INTO chdNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús ti'hua tipalaic'ola', timila': ―Iya' cai'huayomma al toncay. Imanc' conƚouyomma al 'ocay. Loƚpitine, fa'a li'a ƚamats' ipangoyopa. Iya' a'i. ");
INSERT INTO chdNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Joupa aimipolhuo': Timaco'molhuo' coƚtaic' loƚjunac'. Joupa aimipolhuo' naitsi iya'. Aimolapenufi iƚe laifnescopoxi. Ma' aimolapenufi iƚe laifpalaicopoxi, oƚtaic' loƚjunac', toƚta'a timaco'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Icuis'e'me, timiyi: ―¿Naitsi ima'? Jesús timila': ―Joupa aimipolhuo'. Joupa oƚsina'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tipa'a axpe' laifpalaicoyacolhuo' imanc'. Aiximpolhuo' a'ijc'a lonƚ'epa. Cai'Ailli', iƚque Ƚalummepa, aimifelƚaique, tinesqui mane al ƚinca. Iƚe lalu'ipa iya' cu'iyale fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iƚniya aiquiƚcueca Jesús lipalaicopa ȽanDios qui'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesús timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Tijouƚa' aƚ'nof'enaƚa' imanc' limetsaico'ma naitsi iya'. Limetsaico'ma ma to joupa ainescopoxi iya'. Ti'i'ma coƚsina' te ts'i'ic' laipicuejma'. Iya' caituca' aicaxpic'e laif'eya. Jiƚe laƚmuc'ipa cai'Ailli', maƚe cu'ilhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aƚejmale anuli iya' y Ƚaƚummepa. Iya' ti'hua ca'ay latenƚcocopa iƚque. Toƚta'a aicaƚpo'nohuo caituca'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Miquimf'eyi lan judío, axpela' iƚniya ticuayi: ―Al ƚinca locuapa iƚque. ¡Lihuej'me! ");
INSERT INTO chdNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús ipalaic'o'mola' iƚne lan xanuc' judío no'huaiyijmpá, timila': ―Ja'ni laitaiqui' tipanenni loƚpicuejma' imanc' lihuejna'ma al c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Toƚsim'me al ƚinca laitaiqui', tolihuejco'me. Toƚta'a imanc' coƚtuca' toƚcuxe'moƚtsi al c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Iƚniya timiyi: ―Illanc' inaxque' ƚaƚtatahuelo Abraham. Aimi'iya maƚcuxeyaconga'. Ailopa'a caƚpoujna. Ima', ¿te caƚmicoponga': “Imanc' coƚtuca' toƚcuxe'moƚtsi al c'a”? ");
INSERT INTO chdNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús italai'e'mola': ―Iya' camilhuo' al ƚinca: Cal xans ja'ni ixcay lo'epa iƚe lixcay ticuxe. Iƚque cal xans ti'onƚcospa to cal mozo. ");
INSERT INTO chdNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cal mozo aimipaneya lejut'ƚ ƚipoujna. Ƚi'hua ƚapoujna, iƚque ƚinca tipanehuo. ");
INSERT INTO chdNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","’Iya' i'Hua ȽanDios, ja'ni iya' cuhuaƚnatsolhuo' imanc' ƚinca toƚcuxena'moƚtsi al c'a nulemma. ");
INSERT INTO chdNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Imanc' toƚcuayi: “Illanc' inaxque' ƚaƚtatahuelo Abraham”. Ma' aixina' toƚta'a. Itsiya tama imanc' inaxque' Abraham tolahueyi te co'iya maƚma'aya. Aimalapenufi iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iya' ma to laƚmuc'ipa cai'Ailli', toƚta'a cu'ilhuo'. Cu'ilhuo' ma laiximpa pu'hua pe lopa'a cai'Ailli'. Imanc' ocuena coƚ'ailli'. Tonƚ'eyi lomuc'ipolhuo' iƚque. ");
INSERT INTO chdNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iƚniya timiyi: ―Abraham aƚ'ailli'. Jesús timila': ―Imanc' ja'ni inaxque' Abraham, tonƚ'e'me anuli to li'epa Abraham. ");
INSERT INTO chdNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ituca' loƚ'ejma' imanc'. Toƚspic'eyi aƚma'aƚa', iya' ninxans cu'ilhuo' ma le'a al ƚinca, iƚe laƚmuc'ipa cai'Ailli'. Toƚe a'i qui'aic' Abraham. ");
INSERT INTO chdNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lonƚ'epa imanc' ti'onƚcospa to lo'epa coƚ'ailli'. Iƚniya timiyi: ―Illanc' a'i ninc'ahuaic'la. ȽanDios aƚ'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Timila': ―Ja'ni ȽanDios oƚ'Ailli' imanc' aƚ'e'ma capic'a. Iya' cai'huayomma ȽanDios, aicuai'ma fa'a li'a ƚamats'. A'i iya' caxpic'e caituca' cacuaiyunni. Cai'Ailli' lummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Imanc' aimi'iya maƚquimf'eya iya' laitaiqui', toƚta'a aicoƚcueca iƚe laifpalaic'opolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ƚonta'a oƚ'ailli'. Imanc' inaxque'. Iƚque imanc' ma' anuli loƚjanajpa. Lipangopa li'a ƚamats' iƚque inma'ahuale, aiquepenufi al ƚinca. Ma to micua lipicuejma' tipalay pangay mifel'miyale. Ate'a iƚque ifel'miyalepa. Lijou'ma lan xanuc' tihuejyi li'ejma', jouc'a ti'hua tifel'miyaleyi. ");
INSERT INTO chdNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","’Iya' cu'ilhuo' al ƚinca. Xonca ticuaispa coƚpic'a lafelƚaiqueya cataiqui'. Aimalapenufi iya' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Imanc', ¿te anuli ti'i'ma aƚtac'ui'ma cajunac'? A'i. Aimi'iya maƚmiya: “Ima' aƚfel'minga'”. Ja'ni oƚsina' camilhuo' al ƚinca, ¿te aimalapenufi iya' laitaiqui'? ");
INSERT INTO chdNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","’Cal xans ja'ni i'hua CanDios, iƚque tepenufi lonespa ȽanDios. Imanc' a'i quinaxque' ȽanDios, toƚta'a aimi'iya molapenufyacu lonespa. ");
INSERT INTO chdNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Lan judío timiyi: ―Illanc' joupa aƚnespá ima' unsamaritano. Itsufaipo' conta'a. Al ƚinca iƚe laƚnescopo'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Timila': ―Iya' a'i caƚtsufaic' conta'a. Iya' quihuejma cai'Ailli'. Imanc' latets'i'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iya', ¿te aga cahuay te co'iya maƚnescoya al c'a? A'i toƚta'a lai'ejma'. Ƚinca tipa'a anuli tehuay te co'iya malimetsaicoya lan xanuc'. Iƚque ma cal Cuecaj Juez. ");
INSERT INTO chdNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","’Iya' camilhuo' al ƚinca: Cal xans nalihuejcopa iya' laitaiqui' iƚque aimimaya nulemma. ");
INSERT INTO chdNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lan judío timiyi: ―Itsiya ƚinca aƚsina' itsufaipo' conta'a. Joupa imanapa ƚaƚtatahuelo Abraham jouc'a imanapola' lam profeta. Ima' tonesqui: “Cal xans nalihuejcopa iya' laitaiqui', iƚque aimimaya nulemma”. ");
INSERT INTO chdNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ƚinca joupa imanapa Abraham. Ima', ¿ja'ni xonca uncueca'? Lam profeta imanapola' jouc'a. ¿Naitsi cof'onƚicopoxi? ");
INSERT INTO chdNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Timila': ―Iya' ja'ni caituca' canescoyoxi nincueca', iƚe laifnescopoxi ailopa'a co'eya. Cai'Ailli' aƚnescojma al c'a. Maƚque cai'Ailli' imanc' toƚpalaicoyi toƚcuayi: “Iƚque ƚalanDios”. ");
INSERT INTO chdNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Imanc' aicolimetsaijma. Iya' ƚinca nimetsaijma. Aicacua aicainimetsaijma. Ja'ni canesla' toƚta'a iya' ca'e'moxi acueca' ninfeloye, ca'onƚico'moxi to imanc' unc'ifeloye. Iya' ƚinca nimetsaijma, quihuejma litaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ƚoƚtatahuelo Abraham ijanajpa juaiconapa aƚsintsoƚtsi fa'a li'a ƚamats'. Joupa aƚsimpoƚtsi, ixojma queta Abraham. ");
INSERT INTO chdNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lan xanuc' judío timiyi: ―Ima' aiquixhuaiya oquej nuxans quimbama' ƚomemats'. ¿Te qui'ipa loximpa Abraham? ");
INSERT INTO chdNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús timila': ―Iya' camilhuo' al ƚinca: Ai'a tipajnta Abraham, iya' capa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Lan judío ipef'me lapic'. Tipa'me capic, tima'a'me Jesús. Jesús temiyoxi. Ipanni al cuecaj xoute'. Iƚniya aiquixim'me pe quitsecopa. ");
INSERT INTO chdNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús ti'hua lane, ixim'ma anuli cal fo'. Cal xans ma lipajnta afo'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ts'ilihuequi Jesús icuis'e'me, timiyi: ―Momxi, ¿te qui'ipa lipajnta afo'? ¿Naitsi iƚque ts'ijunac'? ¿Te maƚque cal fo' o qui'ailli', qui'máma'? ");
INSERT INTO chdNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús italai'e'mola', timila': ―Nij naitsi ts'ijunac', ni cal fo' ni qui'ailli' qui'máma'. Ipajnta afo' cal xans, toƚta'a ȽanDios timuc'i'mola' lan xanuc' al cueca' lipepaxi. Jiƚpe licuerpo cal fo' ti'i'ma al cueca'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Micoƚi litine aƚ'e'me loxpic'epa ȽanDios, iƚque Ƚalummepa. Tijouƚa' timufc'oƚa' aimi'iya maƚ'eyacu lanic'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ma capa'a fa'a li'a ƚamats' iya' Nepalc'o'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Lijoupa licuapa toƚta'a Jesús, itsuƚof'ipa ƚamats', ilanc'eco'ma ƚitsulu' ƚaquixitsqui. Iƚque ƚixitsqui imet'ƚi'ipa li'u' cal fo'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Timi cal fo': ―To'huaƚa' jipu'hua lin'nuhua' cuftine Siloé. Iƚpiya tapajtsi lo'u'. Iƚe lipuftine Siloé tuhuaƚquemma: Ummempa. Cal fo' i'hua'ma, epajtsi li'u'. Lipainamma, tehuetsalenghua. ");
INSERT INTO chdNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nomana' lan huejnca jouc'a locuenaye xanuc', iƚne li'ipa iximpá mixa'hue quitomí, iƚne tipalaic'oyoƚtsi, ticuayi: ―¿Te maƚca'a cal xans nocutshuaipa, noxa'huepa? ¿Te qui'ipa? ");
INSERT INTO chdNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hualca ticuayi: ―Maƚca'a cal xans. Locuenaye ticuayi: ―A'i. A'i iƚque, ma le'a ti'onƚcospa. Cal xans timila': ―Ma' iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Timiyi: ―¿Te qui'e'empo'? ¡Ma' ixaƚconapo' lo'u'! ");
INSERT INTO chdNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Timila': ―Cal xans cuftine Jesús, i'epa ƚixitsqui. Iƚque ƚixitsqui aƚmet'ƚi'ipa lai'u'. Alummepa lin'nuhua' Siloé. Aƚmipa: “Jiƚpiya tapajtsi lo'u'”. Ai'hua'ma, nepajtsi lai'u', itsiya exilinamma lai'u', cahuetsalenghua. ");
INSERT INTO chdNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Icuis'e'me, timiyi: ―¿Pe copa'a iƚque cal xans? Timila': ―Aicaixina'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Iƚque cal fo' joupa ixaƚconapa ileco'me petsi lomana' lan xanuc' fariseo. ");
INSERT INTO chdNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Litine Jesús li'e'ma ƚixitsqui, lixaƚ'mena'ma li'u' cal fo', iƚe litine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lam fariseo aiquetenƚcocola' iƚe li'epa Jesús litine conxajya. Icuis'e'me cal xans, timiyi: ―¿Te qui'ipo'? Itsiya tahuetsalenghua. ¿Te qui'e'empo' lo'u'? Cal xans timila': ―Iƚque aƚmet'ƚi'ipa ƚixitsqui lai'u', ai'hua'ma nepajtsi lai'u', itsiya cahuetsalenghua, exilinamma lai'u'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hualca lam fariseo nomana' jiƚnu'hua ines'me: ―ȽanDios a'i cummaic' iƚque cal xans Jesús. Iƚiya litine conxajya tetets'i, ti'ay canic'. Locuenaye tinesyi: ―Ja'ni a'ijc'a xans, ¿te co'iya mi'eya toƚta'a al cueca'? Enaj'moƚtsi onƚca, aiqui'i'ma anuli liƚpicuejma'. Timana' pe aiquetenƚcocola' lo'epa Jesús, timana' locuenaye icuaitsi quiƚpic'a lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Icuis'econa'me cal xans ƚixaƚconapa li'u'. Timiyi: ―Iƚque ƚixaƚ'menapo' lo'u', ima', ¿te cofnesya iƚque? Cal xans timila': ―Iya' cacua aprofeta. ");
INSERT INTO chdNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lan xanuc' judío ticuayi: ―A'ij ƚinca locuapa iƚque cal xans lonespa: “Laipajnta ninfo'”. Lipajnta ailopa'a quicuana, ac'a li'u', toƚta'a tehuetsalenghua itsiya. Ijoc'i'me ticuaiyunca qui'ailli' qui'máma' cal xans ƚixaƚconapa li'u'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Icuis'em'mola', timila': ―¿Te ma' al ƚinca iƚque oƚ'hua? ¿Ma ipajnta afo'? Itsiya tehuetsale. ¿Te qui'ipa? ");
INSERT INTO chdNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Qui'ailli' qui'máma' italai'enca, timinnila': ―Aƚsina' iƚque aƚ'hua. Aƚsina' ipajnta afo'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Itsiya tehuetsalenghua. A'i caƚsina' te qui'ipa. Ni aicaƚsina' naitsi nixaƚ'menapa li'u'. Iƚque joupa itojpa. Titalai'eƚa' iƚque quituca'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Toƚta'a linespa qui'ailli' qui'máma' cal xans. Timiyoƚtsi: “¿Te caƚ'eyaconga' lan xanuc' judío?” Iƚniya joupa inefopá, ixpic'epá, icuapá: “Cal xans, ja'ni tinesla': Jesús iƚque aCristo, iƚque cal xans lihuescuf'me petsi lalafot'ƚeyopoƚtsi. Tijouƚa' aimalapi'iconayacu lane mitsufaiconaya. Aimaƚmajnconayacu anuli.” ");
INSERT INTO chdNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Toƚiya ticuayi: “Iƚque joupa itojpa. Titalai'eƚa' quituca'.” ");
INSERT INTO chdNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lan xanuc' judío ijoc'icona'me cal xans ƚixaƚconapa li'u'. Timiyi: ―ȽanDios tiquimf'ehuo'. Lu'itsonga' al ƚinca. Illanc' limetsaijma cal xans Jesús. Aƚsina' titay cajunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Timila': ―Iya' aicaixina' ja'ni titay cajunac'. Aixina' iya' li'ipa ninfo', itsiya cahuetsalenghua. Iƚiya ƚinca aixina'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Iƚne icuis'e'me, timiyi: ―¿Te qui'e'epo'? ¿Te qui'ipa lixaƚ'menapo' lo'u'? ");
INSERT INTO chdNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Cal xans italai'e'mola', timila': ―Joupa nu'ipolhuo', aicoƚcueca. ¿Te ts'oƚpic'a cu'itsolhuo'? ¿Te aga imanc' oƚpic'a tunlihuej'me? ");
INSERT INTO chdNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ixtulenca. Imilojpá cataiqui'. Timiyi: ―Ima' ƚinca mihuequi iƚque cal xans Jesús. Illanc' a'i. Illanc' lihuejyi Moisés. ");
INSERT INTO chdNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aƚsina' ȽanDios ipalaic'opa Moisés. Iƚque cal xans Jesús aicaƚsina' pe qui'huayomma. ");
INSERT INTO chdNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Italai'e'mola' cal xans timila': ―¡Xinƚa'! Iƚque cal xans aƚsaƚ'menapa lai'u'. Itsiya imanc' toƚcuayi: “Aicaƚsina' pe qui'huayomma”. ");
INSERT INTO chdNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aƚsina' ȽanDios aimiquimf'ela' petsi ixcay lo'epa. Aimitoc'iyacola'. Cal xans noxpaic'epa ȽanDios, ja'ni ti'eƚa' loxpic'epa, iƚque cal xans ƚinca ȽanDios tiquimf'e, titoc'i. ");
INSERT INTO chdNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jifa'a li'a ƚamats' anuli cal xans ja'ni lipajnta afo', ni anulemma aicaƚsina' quixaƚ'menni li'u'. ");
INSERT INTO chdNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iya' cacua: ȽanDios ummepa iƚque Jesús. Ja'ni a'i, ailopa'a co'eya. ");
INSERT INTO chdNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iƚniya italai'e'me, timiyi cal xans: ―Litine lopajncota ima' otaic' lojunac'. ¡Itsiya opic'a aƚmuc'itsonga' illanc'! Ihuescufna'me pe lefot'ƚeyoƚtsi. Timiyi: ―To'huanƚa'. Aimotsufaiconno jifa'a lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús icuej'ma ihuescufimpa pe lefot'ƚeyoƚtsi. Ehuepa, ixinnapa, timi: ―Ima', ¿te ma to'huaiyinge iƚque cal Xans Ƚiximpa cal profeta? ");
INSERT INTO chdNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Cal xans timi: ―Mai'ailli', lu'iƚa' naitsi iƚque. Tijouƚa' ca'huaiyijm'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús timi: ―Joupa oximpa. Tipalaic'ohuo'. Ma' iya'. Iya' iƚque cal Xans Ƚiximpa cal profeta. ");
INSERT INTO chdNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Cal xans timi: ―Mai'ailli', ca'huaiyijnhuo'. Exc'onƚingai'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús timi: ―Aicuaicoco'ma fa'a li'a ƚamats' ti'i'ma tenaj'moƚtsi lan xanuc'. Lan fohue tehuetsalena'me. Iƚne nahuetsalepá ti'e'e'mola' afohue. ");
INSERT INTO chdNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lam fariseo nomana' jiƚpe pe lopa'a Jesús icuej'me lines'ma. Iƚniya icuis'e'me, timiyi: ―¿Te ma illanc' jouc'a ninc'ifohue? ");
INSERT INTO chdNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Timila': ―Ja'ni unc'ifohue aimitac'uim'molhuo' cajunac'. Ma moƚcuayi: “Aƚsinyi”, aimiƚonc'enyacolhuo' loƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Iya' camilhuo' al ƚinca: Cal xans notsufaiya petsi leti'ila' lam mot'ƚ, ja'ni ocuena lotsufaicoya, a'i pe lotsuflaicopa lam mot'ƚ, iƚque cal xans innantsepa, inma'ahuale. ");
INSERT INTO chdNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Notsufaicopa ma al puerta, ƚinca ti'e'mola' cuenna lam mot'ƚ. Iƚque iƚpoujna, nohuic'iyacola'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ma ticuaiyunni nohuic'iyacola' lam mot'ƚ, no'epa cuenna al puerta texi'e'ma. Nohuic'iyacola' lam mot'ƚ titsufai'ma, tijoc'i'mola' lam mot'ƚ. Tijoc'i'mola' anuli anuli liƚpuftine. Tipa'a'mola'. Iƚne lam mot'ƚ tiquimf'eyi litaiqui' nohuic'iyacola', ticuec'eyi. ");
INSERT INTO chdNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nohuic'iyacola' tipa'atsola' limot'ƚ ti'huaj'me'e'mola' iƚniya. Limot'ƚ tihuejnayi, ilimetsaijma litaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ja'ni tijoc'itsola' ocuena, lam mot'ƚ aimihuejyacu. Tinul'me, tipo'no'me quituca'. Aimimetsaicoyacu liƚtaiqui' locuenaye xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Toƚta'a litaiqui' Jesús u'iyalepa. Iƚne lan xanuc' aiquiƚcueca, aimi'iya muhuaƚyacu lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús ipalaic'oconamola', timila': ―Iya' camilhuo' al ƚinca: Iya' ipuerta ƚileti'i' lam mot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ocuenaye icuai'me ai'a cacuaihuo, ijoc'im'mola' lam mot'ƚ. Iƚniya ma innantsepá, inma'ahuale. Lam mot'ƚ aiquiƚquimf'e liƚtaiqui', aiquiƚcueca locuapa. ");
INSERT INTO chdNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iya' ƚinca ipuerta ƚileti'i' lam mot'ƚ. Naitsi ts'alimetsaijma iya' ipuerta ƚileti'i' lam mot'ƚ, ja'ni titsufaiƚa' toƚta'a, iƚque tunƚu'ma. Titsufai'ma, tipahuo, tehueta quiƚtejua' lam mot'ƚ, tixinna. ");
INSERT INTO chdNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Cal namas joupa ipo'nopa lipicuejma' tinantsetola', tilecotola' lam mot'ƚ, tima'atola', tejac'enatola'. Toƚiya itsehuo'ma jiƚpe ƚileti'i' lam mot'ƚ. Iya' a'i. Aicuaicoco'ma cunƚu'e'mola' laimot'ƚ, capi'i'mola' liƚpitine, iƚe xonca al c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ƚiƚpoujna lam mot'ƚ, iƚque nohuic'iyacola', ja'ni ac'a xans ticu'ma lipitine, tunƚu'etsola' limot'ƚ. Toƚta'a lai'ejma'. Iya' ninC'a caPoujna, cunƚu'e'mola' laimot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Cal mozo, ituca' lipicuejma'. Iƚque a'i quiƚpoujna lam mot'ƚ. Lam mot'ƚ a'i qui'huexi. Mixim'ma icuaico'ma cal lobo tinunghua cal mozo. Tipo'no'mola' quiƚtuca' lam mot'ƚ. Cal lobo tipango'ma ti'noƚ'mola', tica'niyoƚtsi lam mot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cal mozo a'i quiƚpoujna lam mot'ƚ, iƚne a'i qui'huexi. Toƚta'a tinuna'ma, aimixinnila' acuanuc'la. ");
INSERT INTO chdNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Iya' ƚinca iƚpoujna lam mot'ƚ. Iya' ninC'a caPoujna. Quimetsaicola' laimot'ƚ. Jouc'a laimot'ƚ limetsaijma iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Cai'Ailli' limetsaijma iya', jouc'a iya' quimetsaijma cai'Ailli'. Ma' anuli to iƚta'a iya' quimetsaicola' laimot'ƚ. Iya' cacu'ma laipitine, cunƚu'e'mola' laimot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","’Timana' ocuenaye laimot'ƚ. Iƚniya tiyelocoyi, aiquiƚtsuflaic' ƚileti'i' liƚf'as mot'ƚ. Iƚniya jouc'a caleconatola', cajoc'itola', aƚquimf'e'ma iya' laitaiqui', aƚcuec'e'ma. Tijouƚa' ti'i'ma le'a anuli ƚati'i', anuli ƚiƚPoujna, ma' iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Iya' cacu'ma laipitine cunƚu'e'mola' laimot'ƚ, toƚiya cai'Ailli' aƚ'ay capic'a. Tijouƚa' aƚma'aƚa' capenufna'ma laipitine, camaf'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ailopa'a naliƚonc'e'eya laipitine. Ma caituca' cacu'moxi. Tipa'a laimane cacu'ma laipitine. Tipa'a laimane capenufna'ma laipitine. Cai'Ailli' aƚcuxepa ca'eƚa' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lan xanuc' judío noquimf'epá iƚe linespa Jesús tifuli'iconayi cataiqui'. Hualca etenƚcoco'mola' iƚe linespa. Locuenaye a'i quetenƚcocola'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Axpela' tinesyi: ―Itsufaipa conta'a. Imintse'epa lipicuejma'. ¿Te coƚquimf'ecopa? ");
INSERT INTO chdNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Locuenaye tinesyi: ―Cal xans ƚitsufaiya conta'a a'i toƚe mipalaiya. Ƚixcay conta'a aimixaƚ'meya cal fo'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iƚne ƚitiné liƚya' Jerusalén ti'eyi al juic cuftine “Lipaxneconapa al cueca' xoute'”. Joupa uyaipa ƚinu'. I'ipa axita quitine. ");
INSERT INTO chdNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ti'hualejma pe lopa'a al cuecaj xoute'. Ti'hua ƚinujnca cuftine “Ƚipinujnca cal rey Salomón”. ");
INSERT INTO chdNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Lan xanuc' ituf'micoƚai'me Jesús, timiyi: ―Ima' aƚmitsonga' naitsi ima'. ¿Te ticoƚ'ma xonca axpe' quitine aimaƚminga' naitsi ima'? Ja'ni unCristo, lu'itsonga' nulemma. ");
INSERT INTO chdNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús italai'e'mola', timila': ―Joupa nu'ipolhuo'. Imanc' aicalapenufi iya' laifmipolhuo'. Cai'Ailli' lapi'ipa laimane, toƚe ca'ay al cueca'. Iƚe al cueca' laif'epa tuya'e' naitsi iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Imanc' a'i caimot'ƚ, toƚta'a aimalapenufi iƚe laifnuya'apa. ");
INSERT INTO chdNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Laimot'ƚ aƚquimf'e, timetsaicoyi laitaiqui'. Iya' quimetsaicola' laimot'ƚ. Iƚniya lihuequi. ");
INSERT INTO chdNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iya' capi'ila' liƚpitine aimijouya. Aimecaniyacola'. Iya' ca'e'mola' cuenna laimot'ƚ. Ailopa'a nalaxic'e'eyoya iya' laimane. ");
INSERT INTO chdNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","’Cai'Ailli' joupa lapi'ipa iƚne laimot'ƚ. Iƚque xonca cal Cueca', ailopa'a co'onƚcoya iƚque. Ailopa'a naipa'ayacola' cai'Ailli' limane, aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Iya' cai'Ailli' aƚ'onƚcosponga'. Iƚque iya' ma' anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lan xanuc' judío epef'cona'me lapic'. Tipaco'me Jesús. Tima'a'me. ");
INSERT INTO chdNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iƚque timila': ―Imanc' joupa oƚsimpá axpe' ai'epa al c'a, iƚiya laƚmuc'ipa cai'Ailli'. Itsiya toƚspic'eyi aƚma'a'ma. Lu'iƚa': ¿Jale lai'epa aicoƚpic'a? ");
INSERT INTO chdNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Lan xanuc' judío italai'e'me, timiyi: ―Aimaƚma'acoyaco' capic lof'epa al c'a. Ima' metets'ipa ȽanDios, iƚe caƚ'e'ecoyaco'. Ima' unxans, to'onƚicoyoxi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús timila': ―Loƚje'e pe liniƚiya locuxepa ȽanDios ticua: “Iya' NanDios cacua: Imanc' unc'andiosla'.” ");
INSERT INTO chdNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Iƚniya lan xanuc' nepenufpá litaiqui' ȽanDios, iƚque ecui'ipola' “… unc'andiosla'”. Iƚe lataiqui' ma' al ƚinca. Aimi'iya moƚpai'iyacu. Joupa iniƚijmpa. ");
INSERT INTO chdNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iya' ma' aƚ'huijf'epa ȽanDios, alummepa fa'a li'a ƚamats'. Iya' laifnescopoxi ja'ni cacua: “Iya' i'Hua ȽanDios”, ¿te caƚmicopa: “Tatets'i ȽanDios”? ");
INSERT INTO chdNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ƚinca, ja'ni aica'ay to lo'epa ȽanDios cai'Ailli', aimalapenuf'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ja'ni oƚsina' ca'ay ma to lo'epa ȽanDios, tama aimalapenufi, tonlimetsaicoƚe laif'epa, iƚe ti'onƚspa to lo'epa cai'Ailli'. Toƚta'a ti'i'ma coƚsina' te ts'i'ic' maƚmana' iya' cai'Ailli'. Aƚmana' anuli. Pe laifpa'a iya' maƚpe tipa'a cai'Ailli'; pe lopa'a cai'Ailli', maƚpe caifpa'a iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iƚniya noquimf'epá toƚta'a linespa Jesús ticuayi: “Aƚ'noƚƚe”. Ailopa'a qui'e'e'me. Iƚque unƚupa. ");
INSERT INTO chdNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","I'huacona'ma locuenaj liju' al panaj Jordán. Ipanenni ma jiƚpiya petsi Juan lepo'iyaleyopa. ");
INSERT INTO chdNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Axpela' lan xanuc' icuaitsa pe lopa'a Jesús. Tinesyi: ―Li'epa Juan a'ij cueca'. Ma le'a inescopa cal xans Jesús. Itsiya joupa i'ipa caƚsina' ma al ƚinca jahuay iƚe linespa Juan. ");
INSERT INTO chdNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Miƚmana' jiƚpiya axpela' i'huaiyijm'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Liƚya' Betania tipa'a anuli ƚafcuana cuftine Lázaro. Iƚque timana' lipimaye cacaƚ'no', liƚpuftine María y Marta. Iƚniya iƚpiƚya' Betania. ");
INSERT INTO chdNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ƚipima ƚafcuana, iƚque María, tixcuaf'i'ma laceite lojuepaj c'a li'mitsi' Jesús, tetufco'ma ƚijuac. ");
INSERT INTO chdNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Iƚniya loquexi' lipimaye Lázaro umme'me cataiqui', tu'inna Jesús: ―Maƚ'ailli', ƚonƚejmalepa, iƚque Lázaro, textafque. ");
INSERT INTO chdNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Licuej'ma Jesús lataiqui' ticua: ―Iƚe licuana aimima'aya nulemma Lázaro. Lo'iya iƚque timuc'i'mola' lan xanuc' te ts'i'ic' laimane, iya' i'Hua ȽanDios. Tixinƚe acueca' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús ti'ela' capic'a juaiconapa lapimaye Marta, María jouc'a Lázaro. ");
INSERT INTO chdNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Licuej'ma textafque Lázaro icoƚ'ma, aiqui'huac'. Jiƚpe pe lopa'a ipanemma oquej quitine. ");
INSERT INTO chdNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lijou'ma timila' ts'ilihuequi: ―Ƚepá, aƚecona'me al distrito Judea. ");
INSERT INTO chdNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ts'ilihuequi timiyi: ―Momxi, lan judío nomana' jiƚpiya ma quite' coƚa' tipato' capic', tima'ato'. Itsiya, tocua: “Ca'huacona'ma pu'hua”. ");
INSERT INTO chdNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús timila': ―Anuli litine tipa'a imbamaj coque' hora. Ja'ni to'huaƚa' litine aimuc'uiyaco'. Cal 'ora tepalc'o'i'mo'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ja'ni to'huaƚa' lipuqui', tuc'ui'mo'. Ailopa'a napalc'o'iyaco'. To'hua al muf. ");
INSERT INTO chdNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lijou'ma timila': ―Ƚaƚejmalepa Lázaro tixmay. Ai'huapa jiƚpe, cummef'nata. ");
INSERT INTO chdNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ts'ilihuequi timiyi: ―Maƚ'ailli', ja'ni tixmay, tixaƚconna. ");
INSERT INTO chdNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús linespa: “Lázaro tixmay”, tuya'e': “Joupa imapa”. Ts'ilihuequi aiquiƚcueca. Ticuayi: “Lázaro ma le'a tixmay”. ");
INSERT INTO chdNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesús ipalaic'o'mola' al cuajmaica cataiqui', timila': ―Lázaro joupa imapa. ");
INSERT INTO chdNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Itsiya aicacua: “Coƚa' pu'hua caifpa'a”. Aicaxhueƚcocojma. Aixina' iƚe li'ipa titoc'i'molhuo' imanc'. Xonca aƚ'huaiyijm'ma iya'. Itsiya ƚepá. Aƚcuaita pe lopa'a iƚque. ");
INSERT INTO chdNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás ƚacui'ipa cal Cuatsi, timila' liƚejmale: ―¡Ƚepá! Ja'ni tima'antsa Jesús, illanc' jouc'a aƚma'atsonga'. Aƚma'monga' anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Licuaitsi Jesús jiƚpe liƚya' joupa ixhuaita amalpuj quitine queminni Lázaro. ");
INSERT INTO chdNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Liƚya' Betania ahuejnca Jerusalén. Laquipiculi' to afane' kilómetro. ");
INSERT INTO chdNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Axpela' lan xanuc' judío quiyouyumma Jerusalén, icuaitsa lilejut'ƚ Marta y María, tiƚonc'e'entsola' liƚpixhuejma', joupa imapa ƚiƚpima Lázaro. ");
INSERT INTO chdNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta icuej'ma icuaico'ma Jesús. Ipanni titalecuftsi. María ipanenni lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta timi Jesús: ―Mai'ailli', coƚa' topa'a fa'a, aimimaya ƚaipima. Joupa imanapa. ");
INSERT INTO chdNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tama imanapa ƚaipima, iya' ti'hua ca'huaiyijnhuo'. Aixina' ja'ni toxa'hue'ma ȽanDios iƚque tepi'i'mo' lofxahue'eya. ");
INSERT INTO chdNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús timi: ―Timaf'ina'ma ƚopima. ");
INSERT INTO chdNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta timi: ―Ne'. Ticuaitsi Lijoujma Quitine timaf'ina'ma. Toƚta'a aixina'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús timi: ―Ma' iya' camaf'i'ina'mola' limanapola'. Capi'ina'mola' liƚpitine. Naitsi ƚaƚ'huaiyijmpa tama timanƚa' timaf'ina'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Iƚne naƚ'huaiyijmpa ja'ni ts'iƚmaf'i' aimimayacola' nulemma. Ima', ¿te cofcuapa? ¿Ja'ni canesqui al ƚinca? ");
INSERT INTO chdNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta timi: ―Mai'ailli', iya' cacua tonesqui al ƚinca. Aixina' ȽanDios tumme'ma ƚi'Hua, iƚque jifa'a ticuaihuo li'a ƚamats'. Iya' cacua: Ima' i'Hua ȽanDios, joupa ocuai'ma. Ima' unCristo. ");
INSERT INTO chdNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lijoupa toƚta'a linespa Marta, i'hua'ma ijoc'itsi ƚipima María. Ipalaic'o'moƚtsi caquiƚtuca'. Marta lipalaic'opa ƚipima, timi: ―Icuai'ma Ƚomxi. Tijoc'ihuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Licuej'ma iƚe lataiqui', María aiquicoƚi, itsahuenni i'hua'ma titalecuftsi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ai'a titsufai'ma liƚya' ipanemma maƚpiya pe litalecufhuo'ma Marta. ");
INSERT INTO chdNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jiƚpe lejut'ƚ María timana' lan judío, icuaita tiƚonc'e'e'me lipixhuejma'. Iƚne ixim'me María itsahuenni. Ixim'me aiquicoƚi, ipanni. Ticuayi: ―I'huapa al pu'hua. Jiƚpiya tijojta. Ihuej'me. ");
INSERT INTO chdNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María icuaitsi pe lopa'a Jesús. Exc'onƚingai'ma li'mitsi', timi: ―Mai'ailli', coƚa' topa'a fa'a, aimi'iya toƚta'a. Ƚaipima aimimaya. ");
INSERT INTO chdNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús ixim'mola' tijolijyi María jouc'a lan xanuc' judío lilihuequi María, ihuotsonni juaiconapa. Ixnalif'ma acueca'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Icuis'e'mola', timila': ―¿Petsi colamu'ehuo'me? Italai'e'me, timiyi: ―Mai'ailli', ƚepá. Aƚsinna. ");
INSERT INTO chdNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Licuaitsa pe lamuya, Jesús ijoj'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Lan xanuc' judío tinesyi: ―¡Toƚsinƚe! Juaiconapa i'epa capic'a Lázaro. ");
INSERT INTO chdNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Locuenaye ticuayi: ―Iƚque ixaƚ'me'e'ma li'u' cal fo'. ¿Te aiquixaƚ'me Lázaro? ¿Te quipo'nocopa quimacopa? ");
INSERT INTO chdNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús icuaitsi petsi lamuya Lázaro. Ihuotsoconamma juaiconapa. Ixnalifcona'ma. Lamuya Lázaro unts'eja'. Lico cunts'eja' eti'icoya acueca' capic. ");
INSERT INTO chdNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús icuxe'e'mola' lan xanuc', timila': ―Tonliƚonc'eƚe iƚque ƚapic. Marta ipima ƚimapa timi Jesús: ―Mai'ailli', itsiya tujuelojma. Ixhuaita amalpuj quitine quimac'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús timi: ―Joupa aimipo': “Ja'ni ima' aƚ'huaiyinge, toxim'ma acueca' ȽanDios, acueca' lo'eya”. ");
INSERT INTO chdNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iƚonc'em'me ƚapic. Jesús ehuelojm'ma al toncay lema'a, timi qui'Ailli': ―Mai'Ailli', cax'najtsi'ihuo' joupa aƚquimf'epa. ");
INSERT INTO chdNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tama aixina' itine itine aƚquimf'e, aimipo': “Cax'najtsi'ihuo' joupa aƚquimf'epa”. Aipic'a aƚcuejla' iƚe laimipo' lan xanuc' nacaxhuoƚanna fa'a. Joupa ainu'ipola': “Cai'Ailli' lummepa fa'a li'a ƚamats'”. Itsiya aipic'a ti'eƚe ƚinca iƚe lainuya'apa. ");
INSERT INTO chdNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Lijoupa toƚta'a licuapa Jesús ija'a'ma, timi: ―¡Lázaro! ¡Taipanni! ");
INSERT INTO chdNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ƚimapa ipanni ƚunts'eja'. Limane' li'mitsi' ifiyicoya ijahua', li'a iju'ecopa apa'yu. Jesús timila' lan xanuc': ―Toluhuaiƚƚe lijahua'. Ti'huanƚa'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lan xanuc' judío iƚne nahuejmpá María, axpela' iƚniya lixim'me li'epa Jesús, tixpic'eyi tihuejle. ");
INSERT INTO chdNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Locuenaye iye'me pe lomana' lam fariseo, u'intsola' li'epa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lixanuc' cal cuecaj ca'ailli' jouc'a lam fariseo ijoc'im'mola' lan tsilaj xanuc' iƚne noxpijpá lataiqui'. Efot'ƚe'moƚtsi, timiyoƚtsi: ―¿Te caƚ'eyacu? Iƚque Jesús ti'ay al cueca'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ticuicomma aƚpa'neƚe, ja'ni a'i jahuay lan xanuc' tihuej'me. Tijouƚa' tixtulecu lan romano, teteƚ'me laƚcuecaj xoute', aƚjou'ne'monga' illanc' ninc'ijudío. ");
INSERT INTO chdNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Maƚpe lefot'ƚeyopoltsi tipa'a anuli cal xans cuftine Caifás. Jiƚniya ƚitiné iƚque Caifás copa'a cal cuecaj ca'ailli'. Iƚque timila' lif'as xanuc': ―Imanc' ailopa'a coƚsina'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aimoƚspic'eyi. Xonca al c'a luyalaico'me ja'ni timaƚa' le'a anuli cal xans, toƚta'a tunƚu'e'mola' jahuay laƚxanuc'. Aimaƚjouyaconga' illanc' ninc'ixanuc' judío. ");
INSERT INTO chdNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás a'i quituca' lipicuejma' toƚta'a tipalay. Iƚniya ƚitiné iƚque copa'a cal cuecaj ca'ailli', ma tuya'e' lixpic'epa ȽanDios. Maƚque ȽanDios joupa ixpic'epa tima'anƚe Jesús, toƚta'a tunƚu'e'mola' lixanuc' ȽanDios, jiƚniya nomana' jiƚpiya ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A'i ma le'a lixanuc' ȽanDios nomana' jiƚpiya ƚamats', tunƚu'e'mola' jouc'a jahuay lixanuc', ni petsi lomana', tefot'ƚena'mola' anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma jiƚiya litine iƚniya lan judío ixpic'e'me tima'anƚe Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lijou'ma Jesús aimuyaicoconghua pe lomana' lan xanuc' judío. Ipanni jiƚpiya al distrito Judea. Icuaitsi anuli liƚya' cuftine Efraín. Iƚpe liƚya' tipa'a huejnca anuli ƚamats' petsi ailopa'a quiƚya'. Jiƚpe imanenca anuli, Jesús y ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Joupa icuaico'ma al juic cuftine al Pascua. Axpela' lan xanuc' ipalunca ƚiƚpiƚeloƚya', if'ajli'me al toncay, ticuaita al cuecaj quiƚya' Jerusalén. Ticuaita ai'a ti'i'ma al juic. Tenant'ƚi'me lataiqui' loya'apa locuxepa ȽanDios. Toƚta'a ƚa'ailli' timi'mola': “Ima' unlimpio. Ti'i'ma tote'ma ƚotejacu jiƚpe al juic.” ");
INSERT INTO chdNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iƚne lan xanuc' ehue'me Jesús, ecaxhuoƚai'me pe lopa'a al cuecaj xoute', timiyoƚtsi: ―¿Te coƚcuapa? ¿Te ticuaihuo Jesús fa'a al juic, o aimicuaiya? ");
INSERT INTO chdNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lixanuc' cal cuecaj ca'ailli' jouc'a lam fariseo joupa icuxepá, timinnila' lan xanuc': ―Anuli imanc' ja'ni ti'iƚa' quixina' pe lopa'a Jesús, lu'itsonga'. Iƚne tehueyi te co'iya mi'noƚyacu Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tehue'e' acamts'us quitine ti'iƚa' al juic cuftine al Pascua. Jesús ipainanni liƚya' Efraín, icuainatsi liƚya' Betania, pe lopa'a Lázaro, iƚque ƚimapa joupa imaf'i'inapa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jiƚpiya ilanc'e'e'me ƚitejua' tixmoco'ma Jesús. Lázaro, Jesús jouc'a lan xanuc' lijoc'impola' icutshuoƚai'me anuli. Marta ites'mi'mola'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María itaic' onƚca litro laceite cuftine nardo. Iƚe laceite tujuej c'a. Ic'ef'i'ma laceite li'mitsi' Jesús, etufco'ma ƚijuac. Imantsi lajut'ƚ ƚojuepaj c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Anuli ƚihuequi Jesús cuftine Judas Iscariote, iƚque ƚocuya Jesús, ixtunni, ticua: ");
INSERT INTO chdNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Iƚe laceite acueca' lipitali, to mulij'ma anuli cal xans no'eya canic' afanej maxnu quitine. ¿Te aiquicuquinni tepi'inatsola' al tomí lan xanuc' pe ailopa'a quiƚtomí? ");
INSERT INTO chdNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas aimixinnila' acuanuc'la iƚne lan xanuc' pe aiquiƚ'hueca quiƚtomí. Iƚque innaminnaipa. I'hueca al ponta pe lo'nij'mimpa al tomí. Tinantse. ");
INSERT INTO chdNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús timila': ―Toƚe. Aimohuos'mi'ma. Ƚaca'no' joupa ixpic'epa lo'e'eya laceite. Ticua: “Ca'huej'ma. Ai'a temim'me Jesús caxcuaf'iƚa' laceite.” (Lan judío ti'huaf'iyi toƚta'a liƚcuerpo lomapola'.) ");
INSERT INTO chdNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Jesús ti'hua timila': ―Petsi loƚmana' aimicuaiya litine pe aimehue'eyacola' quiƚtomí lan xanuc'. Itine itine nipajnya toƚtoc'i'mola'. Ticuaihuo litine iya' aicapajnconaya. ");
INSERT INTO chdNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Axpela' lan xanuc' judío icuej'me tipa'a Jesús lejut'ƚ María. Icuaiyunca jiƚpiya. Iƚpic'a tixinƚe Jesús. Xonca iƚpic'a tixinƚe Lázaro, iƚque cal xans ƚimaf'i'inapa Jesús, itsahue'enamma, ipa'apa pe lomana' limanapola'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Lixanuc' cal cuecaj ca'ailli' aimixoqui quileta, ixtulenca. Ticuayi: “Aƚma'aƚe Lázaro jouc'a”. ");
INSERT INTO chdNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Iƚsina' lo'epa liƚf'as xanuc' judío. Iƚniya liximpá Lázaro imaf'inapa ihuej'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Liƚya' Jerusalén timana' axpela' lan xanuc' icuaita al juic. Lihuequi litine iƚniya icuej'me: “Icuaico'ma Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Etej'me limane' xanghue, ipalunca italecuftsa Jesús. Miyeyi lane iƚniya ija'a'me: ―¡Hosana! ¡Tunƚu'enatso' ȽanDios! ¡Tipaxnetso' ȽanDios iƚque Ƚummepo'! ¡Ima' joupa ocuai'ma! ¡Ima' maƚRey, illanc' ixanuc' Israél! ");
INSERT INTO chdNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús joupa iximpa ƚaca'huaj burro, enafcai'ma. Toƚta'a li'ipa ma to loya'apa al Paxi Liniƚingiya, ticua: ");
INSERT INTO chdNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Cunc'ixanuc' loƚpiƚya' Sión: Aimixpailij'molhuo', aimoƚsueƚmot'ƚe'me. ¡Toƚsinƚe! Icuaico'ma ƚoƚRey ƚenafcaic' ƚi'hua cal burro. ");
INSERT INTO chdNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iƚe litine ts'ilihuequi Jesús aiquiƚcueca li'ipa. Lijoupa lepenufinapa Jesús pu'hua lema'a, i'nujuaisnatsa linesma iƚe liniƚiya. I'ipa quiƚsina' iƚe lataiqui' tinesqui lo'iya Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lan xanuc' nixinghuo'me Lázaro litine lipananni lipu'hua, iƚniya uya'ahuo'me Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lan xanuc' nicuejpá iƚe al cueca' li'epa Jesús ipalunca liƚpiƚya' Jerusalén, italecufhuo'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lam fariseo ipalaic'o'moƚtsi, timiyoƚtsi: ―¡Toƚsinƚe! ¿Te caƚ'eyacu? Jahuay lan xanuc' tihuejnayi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Timana' hualca lan xanuc' griego jiƚpiya liƚya' Jerusalén. Iƚniya jouc'a icula'apá tixinna quiƚjuic, texc'onƚingoƚaita ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Iƚniya icuaita pe lopa'a Felipe. Felipe lipiƚya' Betsaida lopa'a al distrito Galilea. Timiyi: ―Maƚpima, aƚpic'a aƚsinƚe Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe i'hua'ma u'itsi Andrés. Iƚne loquexi' iye'me u'itsa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús timila': ―Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. Joupa icuai'ma lai'hora. Aƚsim'ma naitsi iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","’Iya' camilhuo' al ƚinca: Anulij ƚaj fanu' trigo ja'ni aimifanni, ja'ni aimemunni ƚamats', iƚque tipanehuo quituca'. Aimi'asya. Ja'ni tifanƚe, ja'ni temunƚe ƚamats' iƚque ti'as'ma, ticuef'ma axpe'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Cal xans noximpoxi cuanuc' lipitine, iƚque tejac'ma lipitine. Petsi aimixinyoxi cuanuc' lipitine, petsi aimixhueƚ'mecoyoxi te coyaicoya fa'a li'a ƚamats', iƚque ƚinca tulijna'ma lipitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nai ts'ipic'a ti'eƚa' laipenic', lihuejla'. Pe laifpa'a iya' jiƚpiya jouc'a tipajnta iƚque ƚaƚtoc'ipa, aƚmajnta anuli. Naitsi no'epa laipenic', cai'Ailli' timetsaicona'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Itsiya caxhueƚma juaiconapa. ¿Te caifmiya cai'Ailli'? ¿Te cami'ma: “Mai'Ailli', joupa icuai'ma lai'hora, lunƚu'eƚa'. Toƚta'a aicateƚcoya”? A'i. Aimi'iya camiya toƚta'a. Iya' aicuaicoco'ma fa'a li'a ƚamats' cateƚco'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jesús ti'hua tipalay, tipalaic'o' qui'Ailli', timi: ―Mai'Ailli', caxahue'ehuo' tomuc'itsola' lan xanuc' ima' ƚinca unCuecaj CanDios. Lan xanuc' icuej'me tipalaiyinni jipu'hua lema'a, timi Jesús: ―Iya' joupa aimuc'ipola' lan xanuc' iya' ninCuecaj CanDios. Ma toƚta'a camuc'icona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lan xanuc' nacaxhuoƚanna jiƚpiya iquimf'e'me. Iƚne ticuayi: ―Una'apa. Locuenaye ticuayi: ―A'i cuna'e'. Anuli ƚapaluc quema'a ipalaic'opa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús timila': ―Joupa aixina' iƚe lataiqui' laƚmipa. Iƚque nipalaipa ipic'a imanc' jouc'a toƚquimf'eƚe, tolapenufle. ");
INSERT INTO chdNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Itsiya ȽanDios tipango'ma timuc'i'molhuo' te ts'i'ic' loƚpicuejma' imanc' noƚmana' fa'a li'a ƚamats'. Timuc'i'molhuo' petsi al c'a, petsi a'ijc'a. Itsiya tuliquinam'me nocuxepola' lan xanuc', iƚniya pe aimihuejyi ȽanDios. ȽanDios teca'nita. ");
INSERT INTO chdNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aƚ'nof'e'ma jifa'a li'a ƚamats'. Tijouƚa' lapi'i'ma laimane, cajoc'i'mola' lan xanuc' ni petsi lomana', aƚcuec'e'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Locuapa Jesús: “Aƚ'nof'e'ma”, iƚe linespa timuc'ila' lan xanuc' te ts'i'ic' mimaya. ");
INSERT INTO chdNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lan xanuc' timiyi: ―Laƚje'e liniƚiya locuxepa ȽanDios tuya'e': “Cal Cristo tipajm'ma, aimimaya”. Ja'ni cal Cristo aimimaya, ¿naitsi iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a? Ima' tocua: Ti'nof'em'me. ");
INSERT INTO chdNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús timila': ―Fa'a tipa'a ƚapalc'o'ipolhuo'. Iƚque aimicoƚya fa'a li'a ƚamats'. Ma mipa'a lepalc'o' tonlihuejle iƚque. Ticuaitsi lipuqui' timufaj'molhuo'. Naitsi no'huapa al muf aimixina pe cotseya. ");
INSERT INTO chdNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mipa'a iƚque Lepalc'o' tolapenufle Lepalc'o'. Toƚta'a ti'onƚcotolhuo' to Lepalc'o'. Jouc'a tonlapalc'o'i'mola' loƚf'as xanuc'. Lijoupa limipola' toƚta'a Jesús aiquipalaic'oconala' iƚniya. I'hua'ma petsi lan xanuc' aimixingonayacu. ");
INSERT INTO chdNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tama axpe' ixim'me Jesús lo'epa al cueca', iƚniya lan xanuc' aimepenufyi. Ticuayi: “A'ij ƚinca lonespa”. ");
INSERT INTO chdNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Toƚta'a enanƚcopa iƚe lataiqui' linespa cal profeta Isaías, tuya'e': Mai'Ailli', ailopa'a nalapenufponga' illanc' laƚtaiqui'. Ailopa'a nonesya: Iya' ƚinca aiximpa al cueca' lo'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Isaías inescopola' iƚne lan xanuc' pe aimepenufyi Jesús. Ticua iƚniya aimi'iya mi'huaiyijnyacu, tuya'e': I'e'empola' afohue, i'e'empola' ata liƚpicuejma'. Toƚta'a tama tipa'a liƚ'u' aimixinyacu, tama tipa'a liƚpicuejma' aimicuec'eyacu, aimipailiyacu, aimixhuej'meyacu. Toƚta'a aimi'iya caxaƚ'meyacola'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Toƚta'a linespa Isaías mixina Jesús jiƚpe lema'a, ai'a ticuaihuo li'a ƚamats'. Iximpa te ts'i'ic' iƚque lixans. Lijou'ma ipalaico'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tama al ƚinca iƚe licuapa Isaías timana' lan xanuc' i'huaiyijm'me Jesús, hualca iƚniya iƚpenic'. Iƚne i'e'moƚtsi ch'ix. Tixpaic'eyi lo'eyacu lam fariseo. Iƚniya ticuayi: “Ja'ni lan xanuc' tepenufle Jesús litaiqui' aimalapi'iconayacola' lane mitsuflaiconayacu lajut'ƚ pe lalafot'ƚeyopoƚtsi”. ");
INSERT INTO chdNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Lan xanuc' no'epoƚtsi ch'ix xonca iƚpic'a tepenufintsola', iƚpic'a tixinintsola' lan c'a xanuc'. Aimehueyi ȽanDios latenƚcocopa. Toƚta'a aimuya'ayi ja'ni ti'huaiyijnyi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús uya'a'ma, timila': ―Cal xans ƚalapenufpa iya', lapenufinga' illanc', iya' jouc'a iƚque Ƚalummepa, a'i iya' caituca'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iƚque ƚalahuelojmpa iya', iƚque lahuelonginga' illanc', iya' jouc'a Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","’Iya' aicuaicoco'ma li'a ƚamats' capalc'o'i'mola' lan xanuc'. Cua naitsi ƚalapenufpa iƚque aimipaneya muf lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Cal xans ja'ni aimalihuejma, ja'ni ma le'a aƚquimf'e iya' laitaiqui', iya' aicacani'e iƚque cal xans. Iya' a'i cacani'eyacola' lan xanuc' nomana' fa'a li'a ƚamats'. A'i ƚiya caicuaicoco'ma. Aicuaicoco'ma cunƚu'e'mola'. ");
INSERT INTO chdNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","’Cal xans ja'ni aimalapenufi iya' laitaiqui', latets'ipa, tipa'a lacani'eya. Ticuaitsi Lijoujma Quitine iƚe laitaiqui' lainespa, ma iƚe lataiqui' tecani'e'ma iƚque. ");
INSERT INTO chdNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iƚe laitaiqui' aiquipayoya laipicuejma' iya' caituca'. Cai'Ailli', iƚque Ƚalummepa, maƚquiya aƚsc'ai'ipa laifpalaicoya. ");
INSERT INTO chdNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iya' joupa nimetsaicopa ac'a iƚe lataiqui' laƚsc'ai'ipa cai'Ailli'. Iƚe laitaiqui' lapi'ipa cu'itsola' lan xanuc'. Aixina' ja'ni lapenufla' iya' laitaiqui', iƚne lan xanuc' tulij'me liƚpitine aimijouya. Ma laƚmipa cai'Ailli', toƚta'a capalaic'ocola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Icuaico'ma al juic cuftine al Pascua. Jesús joupa ixina' icuai'ma li'hora. Tipanno fa'a li'a ƚamats', ti'huana'ma, ticuainata pe lopa'a qui'Ailli'. Jesús ti'ela' capic'a ts'ilihuequi iƚniya nomana' li'a ƚamats'. Itsiya timuc'i'mola' juaiconapa lo'epola' capic'a. ");
INSERT INTO chdNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Judas ƚi'hua Simón Iscariote, Satanás joupa icuxe'epa te ts'i'ic' lo'eya. Ticu'ma Jesús. Jesús y ts'ilihuequi tixmocoyi anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ixina' qui'Ailli' epi'ipa limane ticuxe'ma jahuay. Ixina' qui'huayomma pe lopa'a ȽanDios. Ixina' ti'huana'ma, ticuainata maƚpe pe lopa'a ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mixmocoyi ts'ilihuequi, Jesús itsahuenni, ipa'a'ma litsamalo, ipo'no'ma jiƚpe liju', ixpejm'moxi al toalla. ");
INSERT INTO chdNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Uhuaf'ma al cutse caja'. Ipango'ma epac'e'e'mola' liƚ'mitsi' ts'ilihuequi, tetufc'e'ecola' al toalla. ");
INSERT INTO chdNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ti'hua tepac'e'ela' liƚ'mitsi' ts'ilihuequi, icuaitsi pe locutsuya Simón Pedro. Pedro timi Jesús: ―Mai'ailli', ima' a'i malapac'e'e'ma lai'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús timi: ―Itsiya ima' aicocueca laif'epa. Ticuaihuo litine tocuec'ena'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro timi: ―¡Ima' aimi'iya malapac'e'eya lai'mitsi'! Aicapi'iyaco' lane. Jesús italai'e'ma, timi: ―Ja'ni aicapac'e'ehuo' lo'mitsi', aimi'iya maƚmajnyacu anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro timi: ―Ne'. Mai'ailli', lapac'e'eƚa' lai'mitsi', lulahuiƚa' laimane', aƚjuitsai'iƚa' ƚaijuac. ");
INSERT INTO chdNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús timi: ―Ma le'a capac'e'e'mo' lo'mitsi'. Cal xans joupa ƚepopa, iƚque alimpio. Ma le'a li'mitsi' tixisma. Imanc' lalihuequi unc'ilimpio. Tama toƚta'a laifmipolhuo', a'ij limpio jahuay imanc'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús joupa ixina' naitsi ƚocuya. Toƚta'a ticua: “A'ij limpio jahuay imanc'”. ");
INSERT INTO chdNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Lijoupa lepac'e'epola' liƚ'mitsi' ts'ilihuequi, ipo'nocona'ma litsamalo, icutsaicona'ma. Timila' ts'ilihuequi: ―¿Te oƚcuec'epá iƚe lai'e'epolhuo'? ");
INSERT INTO chdNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Imanc' aƚmi “Momxi”, “Mapoujna”; ma' al ƚinca iƚta'a loƚnespa. Iya' Nomxi, iya' naPoujna. ");
INSERT INTO chdNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iya' Nomxi, naPoujna, joupa nepac'e'epolhuo' loƚ'mitsi', imanc' ts'alihuequi. Itsiya camilhuo': Imanc' tolapac'e'e'moƚtsi loƚ'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","’Iya' aimuc'ipolhuo' lonƚ'eyacu. To iya' lai'epa, imanc' jouc'a tonƚ'e'me. ");
INSERT INTO chdNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iya' camilhuo' al ƚinca: Ƚotoc'iyalepa aimi'iya mulijya ƚipoujna. Iƚque ƚinca xonca acueca'. Ma' anuli ƚommempa aimi'iya mulijya ƚommeyalepa, iƚque xonca acueca', ƚocuena ma le'a apaluc. ");
INSERT INTO chdNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ja'ni imanc' joupa oƚcueca iƚiya, ma tolihuejle. Toƚta'a tuluyalaico'me al c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’A'i capalaicolhuo' toƚta'a jahuay imanc'. Nimetsaicolhuo', aixina' naiƚne lai'huijf'epola'. Jouc'a aixina' tenanƚco'ma al Paxi Liniƚingiya. Iƚe lataiqui' tuya'e': “Petsi ƚaƚtetsumlepa, maƚque ƚaƚtepa ƚala'i anuli, iƚque aƚ'epa laic'”. ");
INSERT INTO chdNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","’Itsiya cu'ilhuo' laifnuyaicoya. Ticuaitsi litine ti'iƚa' toƚta'a toƚ'nujuais'me laifmipolhuo'. Toƚcua'me: “Al ƚinca linespa Jesús. Ma to linescopoxi ma toƚta'a iƚque.” ");
INSERT INTO chdNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iya' camilhuo' al ƚinca: Cal xans napenufpa ƚaifnummepa, lapenufinga' iya' jouc'a iƚque. Cal xans ƚalapenufpa, lapenufinga' iya' jouc'a Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Lijoupa licuapa iƚne ƚataiquí Jesús ixhueƚconanni juaiconapa. Timila' ts'ilihuequi: ―Iya' camilhuo' al ƚinca: Anuli imanc' aƚcu'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ts'ilihuequi ixhueƚconca. Ehuelojm'moƚtsi, ticuayi liƚpicuejma': “¿Naitsi copalaicopa Jesús? ¿Naitsi lo'eya toƚta'a?” ");
INSERT INTO chdNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Maƚpe liju' Jesús ticutsu anuli ts'ihuequi. Jesús ti'ay capic'a juaiconapa iƚque ts'ihuequi. ");
INSERT INTO chdNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro tife'ne ƚijuac, i'e'ma señna iƚque ts'ihuequi Jesús. Icuxe'e'ma ticuis'eƚa' Jesús: “¿Naitsi iƚque ƚocuyaco'?” ");
INSERT INTO chdNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iƚque ts'ihuequi iƚoc'huai'ma xonca ahuejnca Jesús, icuis'e'ma, timi: ―Mai'ailli', ¿naitsi iƚque lo'e'eyaco' toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús italai'e'ma, timi: ―Cajac'e'ma iƚca'a ƚahualca ca'i, capi'i'ma anuli ƚaƚejmale titeƚa'. Iƚque ƚinca ƚaƚcuya. Jesús ijac'e'ma ƚe'i, epi'i'ma Judas Iscariote ƚi'hua cal xans cuftine Simón. ");
INSERT INTO chdNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ma miteja ƚa'i ƚonta'a titsufay iƚque cal xans. Jesús timi: ―Ima' oxina' lof'eya. Aimicoƚ'mo'. Toƚe to'eƚa'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Locuenaye ts'ilihuequi Jesús nocutshuoƚanna jiƚpiya aiquiƚsina' te quimicopa Jesús toƚta'a Judas. ");
INSERT INTO chdNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ƚitaic' al ponta pe lo'nij'mimpa al tomí. Oquexi' afantsi ticuayi: “¿Ja'ni tipa'a lalahue'eponga' al juic? ¿Te Jesús ummepa ti'nata? O ¿ja'ni ummepa tepi'itola' quiƚtomí lan xanuc' pe aiquiƚ'hueca?” ");
INSERT INTO chdNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lijoupa litepa ƚa'i Judas aiquicoƚi, ipanni. Joupa i'ipa quipuqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lijoupa lipanni Judas, Jesús ipalaic'o'mola' ts'ilihuequi, timila': ―Itsiya joupa i'ipa, aimehue'e'. Iya' iƚque cal Xans Ƚiximpa cal profeta pu'hua lema'a. ȽanDios timuqui naitsi iya'. Toƚta'a iya' jouc'a camuqui te ts'i'ic' lipicuejma' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma camuqui te ts'i'ic' lipicuejma' ȽanDios, iƚque xonca timuj'ma naitsi iya'. Aimicoƚya. Timuj'ma nulemma naitsi iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","’Cunc'ainaxque', aimaƚcoƚya jifa'a pe loƚmana'. Ca'huana'ma. Lahue'ma imanc'. Joupa aimipola' lan xanuc' judío: “Iya' ca'hua'ma caituca'. Aimi'iya maƚeyacu anuli.” Ma toƚta'a camilhuo' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Itsiya cacuxe'elhuo' lonƚ'eyacu. Iƚe al ts'e cataiqui'. Cacuxe'elhuo': Tonƚ'e'etsoƚtsi capic'a. Ma to iya' ca'elhuo' capic'a, toƚe imanc' tonƚ'e'etsoƚtsi capic'a. ");
INSERT INTO chdNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ja'ni tonƚ'e'etsoƚtsi capic'a, jahuay lan xanuc' timetsaico'molhuo' imanc' alihuequi. ");
INSERT INTO chdNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro timi: ―Mai'ailli', ¿pe coftseya? Jesús italai'e'ma, timi: ―Iya' ca'hua'ma laipene. Itsiya aimi'iya maƚeyacu anuli. Tijouƚa' ima' to'hua'ma lopene ti'onƚcota to laipene. Toƚta'a ƚinca lihuej'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro timi: ―Mai'ailli', ja'ni aimi'iya maƚeyacu anuli itsiya, ¿te co'iyaco'? Tama aƚma'aƚa' iya' cacu'ma laipitine cunƚu'eco'mo'. ");
INSERT INTO chdNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús timi: ―¿Te aƚinca tocu'ma lopitine lunƚu'eco'ma? Iya camihuo' al ƚinca: Iƚta'a lipuqui' ai'a tija'a'ma ƚangiti, ima' tones'ma afanemma: “Iya' aicainimetsaijma Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús ti'hua tipalaic'ola' ts'ilihuequi, timila': ―Itsiya toƚsueƚcoyi. Iya' camilhuo': Aimoƚsueƚmot'ƚe'me. Imanc' toƚ'huaiyijnyi ȽanDios. Jouc'a iya' aƚ'huaiyijnla'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cai'Ailli' acueca' lejut'ƚ. Tipa'a axpela' ƚejut'ƚi petsi lomanc'eyacu laixanuc'. Ma' al ƚinca iƚe laifnespa. Ja'ni a'i coƚa' aicu'iyacolhuo' toƚta'a. Iya' ca'huana'ma calanc'e'etolhuo' coƚmanc'eyacu. Aƚmajnta anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tijouƚa' calanc'etsi loƚmanc'eyacu capaiconno. Calaitsufconatolhuo'. Aƚmajnta anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Imanc' joupa oƚsina' pe laiftseya, joupa oƚsina' lane. ");
INSERT INTO chdNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás timi: ―Mai'ailli', aicaƚsina' pe coftseya. ¿Te co'iya maƚsinyacu iƚe lane? ");
INSERT INTO chdNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús timi: ―Cal xans ts'ipic'a ticuaitsi pe lopa'a cai'Ailli' ȽanDios ticuicomma tixinƚa' lipene lo'huaya. Jouc'a ticuicomma tixinƚa' al ƚinca cataiqui'. Jouc'a ticuicomma tepi'inƚe lipitine aimijouya. Imanc' ja'ni joupa lapenufpa, joupa oƚsimpá lane, tolihuejyi al ƚinca, tipa'a loƚpitine aimijouya. Cal xans pe aimalapenufi iƚque aimicuaiya pe lopa'a cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","’Imanc', ja'ni joupa alimetsaicopa, limetsaiconga' illanc', iya' y cai'Ailli'. Itsiya iƚque cai'Ailli' tolimetsaicoyi, joupa oƚsimpá. ");
INSERT INTO chdNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe timi: ―Mai'ailli', aƚmuc'itsonga' ȽanDios, iƚque co'Ailli'. Tijouƚa' aimaƚsahue'eyaco' xonca. ");
INSERT INTO chdNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús timi: ―Axpe' mut'ƚa i'ipa maƚmana' anuli. ¿Te aicalimetsaijma? Naitsi ƚalahuelojmpa iya', iƚque joupa lahuelojmponga' illanc', iya' y cai'Ailli'. ¿Te caƚmicopa: “Aƚmuc'itsonga' co'Ailli'”? ");
INSERT INTO chdNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Te ima' aicomepenufi iƚe lainespa? Joupa nuya'apa: Pe lopa'a cai'Ailli' maƚpe capa'a iya'. Pe laifpa'a iya' maƚpe tipa'a cai'Ailli'. Ma' aƚmana' anuli. ’Laifnu'ipolhuo' iya' aiqui'huayoya laipicuejma' iya' caituca'. Imanc' aƚsimpa lai'epa acueca'. Maƚpe toƚsinyi lo'epa cai'Ailli', illanc' aƚmana' anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tonƚ'eƚe ƚinca laifnespa: Pe lopa'a cai'Ailli' maƚpe capa'a iya'. Pe laifpa'a iya' maƚpe tipa'a cai'Ailli'. Ma' aƚmana' anuli. O ja'ni aimi'iya monƚ'eyacu ƚinca iƚe laifnespa, toƚ'nujuaitsa lai'epa acueca'. Iƚe timuc'ilhuo' aƚinca laifnespa. ");
INSERT INTO chdNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","’Iya' camilhuo' al ƚinca. Cal xans ƚalapenufpa ti'e'ma to laif'epa. Iya' ca'hua'ma pe lopa'a cai'Ailli'. Tijouƚa' ca'huanƚa' xonca acueca' ti'e'ma iƚque ƚalapenufpa. ");
INSERT INTO chdNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Imanc' ja'ni toƚsinyi naitsi iya', ja'ni limetsaijma, nipajnya toƚsa'hue'me ȽanDios cai'Ailli' titoc'itsolhuo'. Tijouƚa' ca'e'ma to loƚsahue'epa, catoc'i'molhuo'. Toƚta'a iya' i'Hua ȽanDios camuc'i'mola' lan xanuc' te ts'i'ic' lipicuejma' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Camilhuo': Ja'ni i'ipa coƚsina' naitsi iya', ja'ni limetsaijma, toƚsa'hueƚe. Tijouƚa' iya' ca'e'ma maƚe to loƚsahue'epa. ");
INSERT INTO chdNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Imanc', ja'ni aƚ'ay capic'a tolanant'ƚi'me laitaiqui', tonƚ'e'me laifcuxe'epolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Caxahue'e'ma cai'Ailli' tepi'itsolhuo' ocuena Ƚotoc'iyacolhuo'. Iƚque ticuaihuo pe loƚmana', toƚmajm'me anuli. Aimipo'noyacolhuo' coƚtuca'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iƚque cal Espíritu tuya'a'ma al ƚinca. Lan xanuc' nomana' fa'a li'a ƚamats' aimehuelojnyi iƚque, aiquilimetsaijma. Toƚta'a aimi'iya mepenufyacu. Imanc' ƚinca olimetsaijma. Itsiya tipa'a pe loƚmana'. Ticuaihuo litine titsufai'molhuo' iƚque. ");
INSERT INTO chdNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Iya' aicapo'noyacolhuo' quecaniya. Capaiconno, cacuaiconno pe loƚmana'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aimaƚcoƚya fa'a. Lan xanuc' nomana' fa'a, iƚne naihuejpá quiƚtuca' liƚpicuejma', iƚniya aimaƚsingonaya. Imanc' ƚinca ti'hua aƚsinna. Iya' tipa'a laipitine aimijouya. Imanc' jouc'a toƚsim'me loƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","’Ticuaitsi iƚe litine ti'i'ma coƚsina' iya' y cai'Ailli' aƚmana' anuli. Ti'i'ma coƚsina' imanc' y iya' aƚmana' anuli, iya' y imanc' aƚmana' anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Cal xans napenufpa laitaiqui' iƚe laifcuxepa, iƚque ƚalihuequi, ƚinca aƚ'ay capic'a. Iƚque cal xans ƚaƚ'epa capic'a cai'Ailli' ti'e'ma capic'a. Iya' jouc'a ca'e'ma capic'a, camuc'i'ma naitsi iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, iƚque ƚocuena Judas, a'i Judas Iscariote, timi Jesús: ―Mai'ailli', ¿te caƚmuc'icoyaconga' ma le'a illanc'? Aimomuc'iyacola' naitsi ima' locuenaye lan xanuc' nomana' li'a ƚamats'. ¿Te co'iya? ");
INSERT INTO chdNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús italai'e'ma, timi: ―Naitsi ƚaƚ'epa capic'a, iƚque naihuejcopa laitaiqui', cai'Ailli' ti'ena'ma capic'a jouc'a. Aƚcuainacu pe lopa'a. Aƚmajn‑na'me anuli. ");
INSERT INTO chdNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Naitsi aimaƚ'ay capic'a, iƚque aimihuequi laitaiqui'. Iƚe aƚtaiqui' illanc', iya' y cai'Ailli', iƚque Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ma maƚmana' anuli fa'a li'a ƚamats' iya' cu'ilhuo' laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tijouƚa' ticuaiyunni Notoc'iyacolhuo', iƚque cal Espíritu Santo, iƚque timuc'i'molhuo' jahuay. Ti'nujuaitsi'ina'molhuo' laifmipolhuo'. Iya' joupa aixahue'epa cai'Ailli' tummeƚa'. Iƚque tumme'e'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Tolunxac'e'etsoƚtsi ƚolunxajma', ailopa'a tintsi. Toƚta'a laitaiqui' laifpaxnepolhuo', laifnepi'ipolhuo'. Ƚinca jifa'a li'a ƚamats' lan xanuc' naihuejpá quiƚtuca' liƚpicuejma' iƚne jouc'a timi'molhuo': “Ailopa'a tintsi”. Iƚne liƚtaiqui' aimi'onƚspa iya' laitaiqui' laifnu'ipolhuo' itsiya. ");
INSERT INTO chdNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Joupa oƚcuejpá laimipolhuo'. Joupa nu'ipolhuo': “Ca'huana'ma. Tijouƚa' ca'huanƚa' capaiconno, cacuaicoconno.” Ja'ni aƚ'ay capic'a ti'i'ma loƚpixojma cata. Ca'huana'ma pe lopa'a cai'Ailli'. Iƚque cai'Ailli' xonca acueca'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Itsiya nu'ipolhuo' lo'iya. Tijouƚa' ti'iƚa' toƚta'a toƚ'nujuaista iƚiya laimipolhuo', toƚnes'me: “Linespa Jesús ma' al ƚinca”. ");
INSERT INTO chdNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Itsiya huata capalaic'o'molhuo'. Ticuaihuo iƚque nocuxepola' lan xanuc' nomana' fa'a li'a ƚamats', iƚne naihuejpá quiƚtuca' liƚpicuejma'. Iƚque aimaƚcuxe iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma to laƚcuxe'epa cai'Ailli' ma toƚta'a ca'ay, ca'e'ma. Ti'iƚa' quiƚsina' lan xanuc' iya' ca'ay capic'a cai'Ailli'. ’Toƚtsolinca. ¡Ƚepá! ");
INSERT INTO chdNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Iya' aƚ'onƚcospa to lujxi al 'ec 'uva. Iƚe al 'ec tipa'a ƚimané. Iya' aƚinca capa'a iƚe lujxi al 'ec. Cai'Ailli' ƚaƚ'eponga' cuenna, iya' jouc'a ƚaimané. ");
INSERT INTO chdNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iƚne ƚaimané, ja'ni anuli ailopa'a qui'as, cai'Ailli' tetejna'ma. Pe lo'aspa ti'huij'ma. Toƚta'a ti'iƚa' limpio. Ti'asla' xonca. ");
INSERT INTO chdNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Itsiya joupa olapenufpá laitaiqui', iƚe lainu'ipolhuo'. Toƚta'a ȽanDios iximpolhuo' unc'ilimpio. ");
INSERT INTO chdNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Aimolanaj'moƚtsi iya'. Iya' jouc'a aicanajyacoxi imanc'. Anuli limane al 'ec ja'ni tenajxoxi petsi ƚipujxi c'ec, iƚe limane tipanehuo quituca', aimi'asya. Toƚta'a imanc' ja'ni tolanajtsoƚtsi, ti'onƚcotolhuo' to limane al 'ec pe lipanemma quituca', aimi'asyacolhuo'. Ticuicomma maƚmajm'me anuli. Ja'ni a'i ailopa'a conƚ'eyacu al c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Iya' Nujxi C'ec. Imanc' aimané. Ja'ni aimolanajyoƚtsi iya' jouc'a aicanajyacoxi, maƚmajm'me anuli. Toƚta'a ti'onƚcotolhuo' to ƚimané al 'ec no'aspa juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ja'ni tolanajtsoƚtsi imanc' ti'onƚcotolhuo' to ƚimané al 'ec leca'nimpa aculi'. Tijuƚ'mola'. Tijouƚa' tijuƚtsola' tefot'ƚena'me jouc'a lif'as quijuƚpa, tihuoxc'ona'me lonajpa ƚunga, tipi'em'me. ");
INSERT INTO chdNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ja'ni aimolanajyacoƚtsi, ja'ni aimolimenc'ecoyi laitaiqui', nipajnya toƚsa'hue'me, tepi'im'molhuo' iƚe loƚsahue'epa. ");
INSERT INTO chdNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ja'ni ti'onƚcospolhuo' to ƚimané al 'ec no'aspa juaiconapa, anuli anuli ti'atsi, imanc' ƚinca alihuequi. Toƚta'a lan xanuc' tixim'me acueca' cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","’Ma to cai'Ailli' aƚ'ay capic'a, toƚta'a iya' ca'elhuo' capic'a. Aimolanaj'moƚtsi. Maƚmajm'me anuli, toƚta'a ti'hua ca'elhuo' capic'a. ");
INSERT INTO chdNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Imanc' ja'ni tolihuejcoyi laifcuxe'epolhuo', itine itine toƚsim'me ca'elhuo' capic'a. Toƚta'a iya' lai'ejma'. Iya' quihuejma laƚcuxe'epa cai'Ailli', itine itine aixina' aƚ'ay capic'a iƚque. ");
INSERT INTO chdNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Tolapenufle laitaiqui' laifnu'ipolhuo'. Toƚta'a ti'i'ma acueca' loƚpixojma cata. Ma to iya' tixoqui neta, toƚta'a imanc' tixoj'ma cunlata. Aimi'iya moƚsueƚmot'ƚeyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Itsiya cacuxe'elhuo' lonƚ'eyacu. Camilhuo': Tonƚ'etsoƚtsi capic'a. Ma to iya' ca'elhuo' capic'a, toƚe imanc' tonƚ'etsoƚtsi capic'a. ");
INSERT INTO chdNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cal xans, ja'ni acueca' ti'ela' capic'a nonanc'opoƚtsi ticu'ma lipitine tunƚu'e'mola' iƚniya. Ailopa'a xonca acueca' co'eya. ");
INSERT INTO chdNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Imanc' aƚnanc'oyoƚtsi ja'ni tonƚ'eyi laifcuxe'epolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","’Itsiya capalaic'olhuo' a'i lopalaic'onyacola' lam mozó. Cal mozo aiquixina' lo'eya ƚipoujna. Iƚque ƚipoujna aimu'iya. Illanc' aƚejmaleyi. Camilhuo': Iya' aƚnanc'oyoƚtsi. Ailopa'a cainemi'epolhuo'. Jahuay lalu'ipa cai'Ailli' joupa nu'ipolhuo' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Iya' ai'huijf'epolhuo'. Imanc' a'i caƚ'huijf'e iya'. Camilhuo': Nimetsaicopolhuo' aixanuc'. Caxpic'e tonƚeƚe. To al c'a c'ec tipammaispa toƚta'a tipammaitolhuo' imanc'. Iƚe al c'a lonƚ'eyacu tipanehuo. Imanc' aixanuc'. Limetsaijma naitsi iya'. Toƚta'a cai'Ailli' tepi'i'molhuo' loƚsahue'eyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tonƚ'etsoƚtsi capic'a. Toƚta'a laifcuxe'epolhuo' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Lan xanuc' naihuejpá quiƚtuca' liƚpicuejma', ja'ni ti'elhuo' laic', aƚ'nujuaisla' iya' laƚ'epa. Ate'a aƚ'epa laic' iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Imanc' ja'ni coƚa' tolihuejyi coƚtuca' loƚpicuejma' iƚniya lan xanuc' ti'e'molhuo' capic'a. Timi'molhuo': “Ninc'apimaye”. Imanc' aimolihuejyi coƚtuca' loƚpicuejma'. Iya' ai'huijf'epolhuo'. Toƚta'a ocuena loƚ'ejma'. Toƚiya iƚniya ti'e'molhuo' laic'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","’Aƚ'nujuaisla' iya' laitaiqui'. Joupa aimipolhuo': “Notoc'iyalepa aimi'iya mulijya ƚipoujna. Iƚque ƚipoujna ƚinca xonca acueca'.” Ma to li'e'empa ƚipoujna, toƚta'a lo'e'enyacu cal mozo. Iya' joupa lihuetsoquimpa jouc'a tihuetsoquim'molhuo'. Iƚniya ja'ni coƚa' ihuej'me laitaiqui', jouc'a tihuej'me loƚtaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Imanc' aixanuc', toƚta'a iƚne lan xanuc' ti'e'molhuo' laic', tihuetsoquim'molhuo'. Iƚniya aiquilimetsaijma iƚque Ƚalummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Iya' ja'ni coƚa' aicaicuaiyunni fa'a li'a ƚamats', ja'ni coƚa' aicaipalaic'o'mola', iƚniya ti'i'ma tines'me: “Ailopa'a caƚjunac'”. Iya' aicuai'ma, aipalaic'o'mola'. Itsiya aimi'iya minesyacu: “Ailopa'a caƚjunac'”. Iƚne ailopa'a cotalai'ecoyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iƚque ƚalixtuc'opa jouc'a tixtuc'o cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iya' pe lomana' lan xanuc' joupa ai'epa acueca'. Ailopa'a no'eya to iƚta'a lai'epa iya'. Ja'ni coƚa' aicai'aic' toƚta'a iƚniya ti'i'ma tines'me: “Ailopa'a caƚjunac'”. Itsiya aimi'iya minesyacu toƚta'a. Joupa aƚsimpa acueca' lai'epa. Joupa aƚ'eponga' laic', iya' y cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","’Iƚe laƚ'e'epa ma tenant'ƚi al Paxi Liniƚingiya loya'apa: “Tama ailopa'a caif'e'epola' iƚniya aƚ'epa laic'”. ");
INSERT INTO chdNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Pe lopa'a cai'Ailli' jiƚpe tipa'a Notoc'iyacolhuo', iƚque cal Espíritu Santo nonespa al ƚinca. Iƚque co'huayoya ma le'a ȽanDios. Iya' cumme'e'molhuo' pe loƚmana'. Ticuaiyunni fa'a li'a ƚamats' iƚque aƚnesco'ma iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Imanc' jouc'a aƚnesco'ma. Lipangopa laipenic' fa'a li'a ƚamats' aƚejmalepá, iya' y imanc'. Imanc' aƚsimpa acueca' lai'epa, limetsaicopa laipicuejma'. Toƚta'a aƚnesco'ma, tolu'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Joupa nu'ipolhuo' te ts'i'ic' moluyalaicoyacu. Tolapenufle iƚe laimipolhuo'. Toƚta'a aimolanajyacoƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Itsiya camicona'molhuo' te ts'i'ic' moluyalaicoyacu: Tipa'am'molhuo' ƚajut'ƚi pe lafot'ƚeyopoƚtsi. Ticuaihuo litine iƚniya noma'ayacolhuo' tines'me: “Joupa aima'apa iƚque ƚihuejpa Jesús. Iƚe lai'epa etenƚcocopa ȽanDios.” ");
INSERT INTO chdNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iƚniya pe noma'ayacolhuo' aicalimetsaiconga' iya' ni cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Toƚta'a laifnu'ipolhuo'. Ticuaitsi litine toƚteƚcoƚe toƚ'nujuaisnata laimipolhuo'. Ma maƚmana' anuli aicainu'ilhuo' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Itsiya ai'huanapa, cacuainata pe lopa'a iƚque Ƚalummepa. Imanc' aimalicuis'e: “¿Pe coftseya?” Nij anuli nalicuis'epa toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","’Iƚe laimipolhuo' epi'ipolhuo' acueca' quixhuejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Iya' camilhuo' al ƚinca: Ticuicomma ca'huana'ma. Ja'ni a'i, Notoc'iyacolhuo' aimicuaiya pe loƚmana'. Ja'ni ca'huanƚa' ƚinca ticuaihuo. Iya' cumme'etolhuo' pe loƚmana'. Toƚta'a xonca al c'a loluyalaicoyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","’Iƚque cal Espíritu Santo ticuaiyunni li'a ƚamats' timuj'ma ailopa'a cotalai'e'ecoyacu ȽanDios iƚne lan xanuc' naihuejpá quiƚtuca' liƚpicuejma'. Timuj'ma te ts'i'ic' lajunac', timuj'ma te ts'i'ic' al c'a, timuj'ma aƚinca ȽanDios titeƚ'mi'mola' iƚne ts'iƚtaic' quiƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","’Iƚne aicaƚ'huaiyinge, toƚta'a cal Espíritu Santo timuj'ma iƚtaic' liƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Iya' ca'huana'ma pe lopa'a cai'Ailli', imanc' aimalahuelojnconaya aicapajnconaya fa'a li'a ƚamats', cai'Ailli' lapenufnata pu'huanni. Toƚta'a cal Espíritu Santo timuj'ma ac'a lai'epa iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","’Ticuaiyunni cal Espíritu Santo ȽanDios joupa ulijpa Satanás, iteƚ'mipa iƚque nocuxepola' lan xanuc', iƚne naihuejpá quiƚtuca' liƚpicuejma'. Toƚta'a cal Espíritu Santo timuj'ma aƚinca ȽanDios titeƚ'mi'mola' lan xanuc', iƚne ts'iƚtaic' quiƚjunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Tipa'a xonca laifnu'iyacolhuo'. Itsiya aimi'iya cu'iyacolhuo'. Imanc' toƚsim'me ipime iƚe laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ticuaiyunni cal Espíritu Santo iƚque noya'apa al ƚinca, panca panca timuc'i'molhuo'. Toƚta'a ti'i'ma coƚsina' jahuay al ƚinca cataiqui'. Cal Espíritu aimuya'aya quituca' lipicuejma'. Tu'i'molhuo' ma loquimf'epa, iƚiya lataiqui' lu'ipa ȽanDios. Tu'i'molhuo' lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iƚque limetsaijma, aƚnesco'ma. Aiminescoyacoxi. Ma le'a aƚnesco'ma iya' lai'ejma', laipicuejma', laimane. ");
INSERT INTO chdNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ma to li'ejma', lipicuejma', limane cai'Ailli', ma' anuli iya' lai'ejma', laipicuejma', laimane. Toƚiya joupa aimipolhuo': “Iƚque cal Espíritu aiminescoyacoxi. Ma le'a aƚnesco'ma iya' lai'ejma', laipicuejma', laimane.” ");
INSERT INTO chdNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Tuyaiƚa' nihuata aimaƚsingonaya. Tuyaiconƚa' nihuata aƚsingona'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Hualca ts'ilihuequi ipalaic'opoƚtsi, timiyoƚtsi: ―¿Te caƚmicoponga' toƚta'a? Ticua: “Tuyaiƚa' nihuata aimaƚsingonaya. Tuyaiconƚa' nihuata aƚsingona'ma.” Jouc'a ticua: “Ai'huanapa pe lopa'a cai'Ailli'”. ");
INSERT INTO chdNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ti'hua tipalaic'oyoƚtsi, ticuayi: ―¿Te cocuajmaispa licuapa: “Tuyaiƚa' nihuata”? Aicaƚcueca iƚe litaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús ixina' iƚpic'a ticuis'eƚe te cocuapa iƚiya lataiqui'. Timila': ―¿Te colicuis'ecopoƚtsi te cocuapa iƚiya laitaiqui': “Tuyaiƚa' nihuata aimaƚsingonaya, tijouƚa' tuyaiconƚa' nihuata aƚsingona'ma”? ");
INSERT INTO chdNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iya' camilhuo' al ƚinca. Imanc' toƚhuotso'me, toƚjolij'me. Lan xanuc' nomana' fa'a li'a ƚamats', iƚne naihuejpá quiƚtuca' liƚpicuejma', iƚniya tixoj'ma quileta. Imanc' toƚhuotso'me juaiconapa. Tijouƚa' aimoƚhuotsoconayacu. Tiƚonc'e'em'molhuo' loƚpixhuejma', tixoj'ma cunlata. ");
INSERT INTO chdNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ƚaca'no' titeƚco'ma tipajntsi ƚi'hua. Tixhueƚma, ticua: “Joupa ixhuaita litine. Joupa aƚ'huajcopa ƚaipunla.” Tijouƚa' tipajntsi ƚi'hua, timence'co'ma ƚipunla. Tixoqui queta. Ticua: “Ƚacapími' joupa ipajnta, icuai'ma fa'a li'a ƚamats'”. ");
INSERT INTO chdNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","’Toƚta'a loluyalaicoyacu imanc'. Itsiya toƚhuotsoyi, toƚsueƚcoyi. Caxingona'molhuo'. Jiƚpe litine tixoj'ma cunlata. Ailopa'a naiƚonc'e'eyacolhuo' iƚe ƚoƚpixojma cata. ");
INSERT INTO chdNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Jiƚpiya litine aimalicuis'econaya. Iya' camilhuo' al ƚinca: Imanc' oƚsina' naitsi iya', limetsaijma, jahuay loƚsahue'eyacu cai'Ailli' tepi'itsolhuo', iƚque tepi'i'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Aicoƚsahue'e toƚta'a cai'Ailli'. Itsiya camilhuo': Imanc' oƚsina' naitsi iya', limetsaijma, toƚmiƚe toƚta'a cai'Ailli', toƚsahue'e'me. Toƚta'a ƚinca tepi'i'molhuo'. Tijouƚa' ti'i'ma xonca juaiconapa acueca' loƚpixojma cata. ");
INSERT INTO chdNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Iya' laipalaic'opolhuo' a'ij cuajmaica cataiqui', ma le'a ai'onƚicopa. Ticuaihuo litine aica'onƚicoya. Cu'ina'molhuo' al cuajmaica. Cami'molhuo' te ts'i'ic' cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Imanc' oƚsina' naitsi iya', limetsaijma. Ticuaiyunni jiƚpe litine imanc' toƚmiƚe toƚta'a cai'Ailli', toƚsa'hue'me. ’Iya' a'i camilhuo': “Caxahue'e'ma cai'Ailli' tepi'itsolhuo'”. A'i. Aicamiya toƚta'a. Maƚque cai'Ailli' ti'elhuo' capic'a. Maƚque tepi'i'molhuo' loƚsahue'epa. ");
INSERT INTO chdNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Imanc' aƚ'epa capic'a, lapenufpa iya' lainespa, joupa nu'ipolhuo': “Iƚque ȽanDios Ƚalummepa”. Toƚiya maƚque ȽanDios ti'elhuo' capic'a. ");
INSERT INTO chdNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iya' cai'huayomma cai'Ailli', aicuai'ma fa'a li'a ƚamats'. Itsiya ca'huana'ma, quipanahuo li'a ƚamats', cacuainata pe lopa'a cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ts'ilihuequi timiyi: ―Itsiya aƚpalaic'onga' al cuajmaica, aimaƚ'onƚiconga' cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Itsiya aƚsina' ima' jahuay oxina', aimalicuis'econayaco'. Itsiya joupa i'ipa caƚsina' aƚinca o'huayomma ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús timila': ―Itsiya, ¿te aƚinca limetsaijma naitsi iya'? ");
INSERT INTO chdNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ticuaihuo al 'hora, itsiya icuai'ma, imanc' tolinul'me. Tonƚeyoƚna'me ƚolajut'ƚi, tolaca'ne'moƚtsi. Aƚpo'no'ma caituca'. Tama toƚta'a laƚ'e'eya aicapajnya caituca'. Cai'Ailli' tipa'a. ");
INSERT INTO chdNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iya' cacua: Aimoƚsueƚmot'ƚe'me. Toƚiya joupa nu'ipolhuo' lo'iya. Ma moƚmana' fa'a li'a ƚamats' ƚinca toƚteƚco'me. Aimixpailij'molhuo'. Tixojla' cunlata. Iya' joupa nulijpa. ");
INSERT INTO chdNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Toƚe limipola' Jesús ts'ilihuequi. Lijou'ma ehuelojm'ma lema'a. Ipango'ma ipalaic'o'ma qui'Ailli', timi: ―Mai'Ailli', joupa icuai'ma lai'hora. Caxahue'ehuo' tomuc'itsola' laixanuc' naitsi iya'. Iya' o'Hua. Toƚta'a camuc'i'mola' naitsi ima', ima' ai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ima' joupa lapi'ipa laimane cacuxena'mola' jahuay lan xanuc'. Toƚta'a capi'i'mola' laixanuc' liƚpitine aimijouya. Iƚniya laixanuc' ima' lapi'ipa. ");
INSERT INTO chdNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iƚne pe lepi'impola' liƚpitine aimijouya, ma' iƚniya timetsaicohuo' ima' manDios. Jouc'a limetsaijma iya' ninJesucristo, ima' alummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Fa'a li'a ƚamats' aimuc'ipola' naitsi ima'. Iƚe laipenic' lalapi'ipa ima', joupa aijou'nepa. ");
INSERT INTO chdNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ai'a tilajm'ma li'a ƚamats' aƚmana' anuli. Ailopa'a caƚ'onƚcosponga'. Itsiya' mai'Ailli', lapenufnaƚa' jiƚpiya pe lofpa'a. Jiƚpiya aƚmajnta anuli. Ti'iƚa' ma to li'ipa ai'a tilajm'ma li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ima' joupa lapi'ipa iƚne laixanuc'. Iya' aimuc'ipola' naitsi ima'. Iƚniya laixanuc' aimi'onƚspola' locuenaye lan xanuc' nomana' li'a ƚamats' pe naihuejpá quiƚtuca' liƚpicuejma'. Ima' joupa o'huijf'epola'. Iƚniya ihuejcopá lotaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jahuay lapi'ipa ima'. Laixanuc' joupa iƚsina' pe qui'huayomma iƚe lalapi'ipa. Jahuay iƚe lalapi'ipa o'huexi ima'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Lataiqui' ima' lalu'ipa iya' nu'ipola' loxanuc'. Iƚniya epenufpá iƚiya lotaiqui'. Iƚsina' cai'huayomma ma' ima'. Joupa i'huaiyijmpá li'ipa, ima' alummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Iya' caxahue'ehuo' totoc'itsola' iƚne loxanuc'. A'i camihuo' motoc'iyacola' locuenaye xanuc' nomana' li'a ƚamats'. Caxahue'ehuo' totoc'itsola' laƚxanuc', iƚniya lalapi'ipa. Jiƚne o'huexi. ");
INSERT INTO chdNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Jahuay ƚai'huexi jouc'a o'huexi. Jahuay ƚo'huexi jouc'a ai'huexi. Iƚniya laixanuc', iƚne aƚ'huexi, joupa alimetsaicopa, imuj'me naitsi iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Itsiya aicapajnconaya fa'a li'a ƚamats'. Laƚxanuc' ƚinca timajm'me fa'a. Iya' joupa ca'huana'ma, cacuainata pe lofpa'a. Mai'Ailli', ima' umPaxi. Caxahue'ehuo' totoc'itsola' iƚne laixanuc', to'etsola' cuenna. Ti'hua lihuejla' iƚniya. Ima' lopuftine ma laipuftine jouc'a, toƚta'a lacui'ipa ima'. Laixanuc' ja'ni lihuejla' al c'a, iƚne ti'i'ma anuli ma to anuli iya' y ima'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ai'epola' cuenna laixanuc' maƚmana' fa'a li'a ƚamats'. Iƚne aiquicuanaj'me lopuftine, ima' ƚilenDios. Le'a anuli ƚejac'pa, iƚque tejac'eyoxi, toƚe lipicuejma'. Toƚta'a enanƚcopa al Paxi Liniƚingiya. ");
INSERT INTO chdNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Itsiya aicuaiconna pe lofpa'a. Ma capa'a fa'a li'a ƚamats' caxahue'ehuo' totoc'itsola' laixanuc'. To iya' tixoqui neta, aipic'a tixojla' quileta jouc'a laixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nu'ipola' lotaiqui'. Iƚniya epenufpá. Locuenaye lan xanuc' nomana' fa'a li'a ƚamats' pe naihuejpá quiƚtuca' liƚpicuejma', iƚniya ti'eyi laic' laixanuc'. Tixinyi ituca' liƚ'ejma' ma to tixinyi ituca' lai'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A'i caxa'huehuo' maipa'ayacola' laixanuc' fa'a li'a ƚamats'. Ma caxahue'ehuo' to'etsola' cuenna. Toƚta'a ailopa'a co'eyacola' ƚixcay xans. ");
INSERT INTO chdNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Iƚniya ituca' liƚ'ejma' ma to iya' ituca' lai'ejma'. Aimaƚ'onƚsponga' to lan xanuc' naihuejpá quiƚtuca' liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","’Mai'Ailli', totoc'itsola' iƚniya laixanuc', ti'iƚa' o'huexi ima', ti'hua tihuejle al ƚinca. Iƚe lotaiqui' al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ima' alummepa fa'a li'a ƚamats'. Toƚiya iya' nummepola' laixanuc' tiyeƚe ni petsi li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iya' ma' o'huexi. Cacu'moxi cunƚu'etsola' laixanuc', ti'e'etsola' o'huexi jouc'a. Tihuejle al ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Iya' caxahue'ehuo' totoc'itsola' jahuay laixanuc'. A'i camihuo': Totoc'itsola' ma le'a laixanuc' petsi joupa lapenufpa iya'. Iƚne tuya'a'me laitaiqui', tijouƚa' liƚf'as xanuc' jouc'a lapenuf'ma, lihuej'ma. Caxahue'ehuo' totoc'itsola' iƚniya jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aipic'a ti'e'etsola' anuli iƚne laixanuc'. Mai'Ailli' illanc' aƚmana' anuli. Ima' iya' anuli, iya' ima' anuli. Toƚta'a aƚ'e'etsonga' anuli, iƚniya y illanc'. Ja'ni ti'iƚa' toƚta'a locuenaye lan xanuc' nomana' li'a ƚamats' tines'me: “Aƚinca ma ȽanDios ummepa Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","’Ima' joupa aƚpaxnepa, limetsaicopa iya' o'Hua. Toƚta'a iya' aipaxnepola' iƚniya laixanuc', nimetsaicopola' onaxque'. Ma to illanc' aƚmana' anuli, iya' y ima', toƚta'a ti'e'etsola' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iya' y iƚniya aƚmajm'me anuli. Ima' y iya' aƚmana' anuli. Toƚta'a ti'e'etsola' ma' anuli iƚniya. Locuenaye lan xanuc' nomana' li'a ƚamats' ti'i'ma quiƚsina' naitsi iƚque Ƚalummepa, ma' ima' mai'Ailli'. Jouc'a ti'i'ma quiƚsina' lof'epola' capic'a iƚne laixanuc'. Ma to ima' aƚ'ay capic'a toƚta'a to'ela' capic'a iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Mai'Ailli', ai'a tilajm'ma li'a ƚamats', ima' aƚ'ay capic'a, aƚpaxnepa, alimetsaicopa. Itsiya caxahue'ehuo' totoc'itsola' laixanuc', iƚne lalapi'ipa. Camihuo': Aipic'a ticuaitsa jiƚpiya, timajnta pe laifpa'a. Aƚsinƚa' ma to li'ipa. Aƚsintsonga' anuli iya' cai'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","’Mai'Ailli', ima' cotuca' aƚijca lopicuejma'. Locuenaye lan xanuc' nomana' li'a ƚamats', iƚne aiquimetsaicohuo'. Iya' ƚinca nimetsaicohuo'. Laixanuc' jouc'a timetsaicohuo'. Iƚsina' ima' alummepa. ");
INSERT INTO chdNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aimuc'ipola' laixanuc' naitsi ima'. Ti'hua camuc'i'mola', timetsaicotso' xonca, ti'etsoƚtsi capic'a ma to ima' aƚ'ay capic'a. Toƚta'a aƚ'e'etsonga' anuli iya' y laixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús lijoupa lipalaic'opa qui'Ailli' ipanni, ileco'mola' ts'ilihuequi. Iye'me laca'hua pana' cuftine Cedrón. Uyalaico'me locuena liju'. Jiƚpiya tipa'a anuli ƚaqueya. Itsuflai'me. ");
INSERT INTO chdNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, iƚque pe joupa icupa cataiqui' ticu'ma Jesús, imetsaijma jiƚpiya ƚaqueya. Itsenaihuo'me jiƚpe Jesús jouc'a ts'ilihuequi. ");
INSERT INTO chdNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Maƚpiya icuaiconca Judas ilecola' lan soldado romano jouc'a lapaluc' lummempola' lixanuc' cal cuecaj ca'ailli', jouc'a lummempola' lam fariseo. Iƚniya iƚtaic' lolif'ecopoƚtsi, jouc'a liƚpepalc'o', jouc'a locuanajcoyacoƚtsi lofulecoyacu. ");
INSERT INTO chdNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús joupa ixina' jahuay lo'iya. Ipanni, timila': ―Imanc', ¿naitsi conlahuepa? ");
INSERT INTO chdNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Timiyi: ―Lahueyi Jesús, ƚas Nazaret. Jesús timila': ―Ma' iya'. Maƚpe tipa'a Judas, iƚque pe joupa icupa cataiqui' ticu'ma Jesús. Jiƚpe jouc'a tecaxhuoƚanna lan soldado jouc'a lapaluc'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Licuej'me lines'ma Jesús: “Ma' iya'”, iƚniya ipailiconca quiƚspula', enghuoƚaitsa ƚamats'. Ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús icuis'econa'mola', timila': ―Imanc', ¿naitsi conlahuepa? Iƚniya italai'e'econa'me, timiyi: ―Lahueyi Jesús, ƚas Nazaret. ");
INSERT INTO chdNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús timila': ―Joupa aimipolhuo': Ma' iya'. Ja'ni ma le'a iya' lahuay, tolapi'itsola' lane tiyenƚe iƚna'a ts'alihuequi. ");
INSERT INTO chdNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Toƚta'a enanƚcopa limipa Jesús qui'Ailli', locuapa: “Iya' ai'epola' cuenna laixanuc', iƚne lalapi'ipa ima'. Ailopa'a quejac'pa.” ");
INSERT INTO chdNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro itaic' li'espada. Ipa'a'ma, ixcai'e'ma ƚimozo cal cuecaj ca'ailli'. Nulemma etec'e'e'ma lix'mas al c'a camane. Iƚque cal mozo cuftine Malco. ");
INSERT INTO chdNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús icuxe'e'ma Pedro, timi: ―To'huejnaƚa' lo'espada. Cai'Ailli' joupa ixpic'epa toƚta'a laifnuyaicoya. ¿Te ma iya' catets'i'ma iƚque lixpic'ejma'? Ma cateƚco'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lan soldado romano jouc'a nocuxepola', jouc'a lapaluc' lummempola' lan tsilaj judío, iƚniya i'noƚ'me Jesús, ifi'e'me. ");
INSERT INTO chdNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ileco'me pe lopa'a Anás. Iƚque a'hua cunas cuftine aCaifás. Jiƚniya ƚitiné maƚque Caifás cal cuecaj ca'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Joupa inespa: “Tima'anƚe le'a anuli cal xans, tunƚu'etsola' jahuay laƚxanuc'”. ");
INSERT INTO chdNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Milecoyi Jesús iyenc'e'me oquexi' ts'ilihuequi. Iƚniya Simón Pedro jouc'a ƚiƚejmale. Pedro ƚiƚejmale imetsaijma cal cuecaj ca'ailli'. Icuaitsa lejut'ƚ cal cuecaj ca'ailli'. Litsufai'e'me Jesús, Pedro ƚiƚejmale jouc'a itsufai'ma ƚipuna quejut'ƚ ƚa'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro aiquitsufaic'. Ipanenni tecaxu lixpula' al puerta. Ts'ihuequi Jesús, iƚque pe ƚimetsaijma cal cuecaj ca'ailli', ipaiconanni icuaitsi pe lopa'a ƚahuats' no'epa cuenna al puerta. Ipalaic'opa. Lijou'ma itsufai'e'ma Pedro. ");
INSERT INTO chdNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ƚahuats' no'epa cuenna al puerta icuis'e'ma Pedro, timi: ―¿Te ma ima' jouc'a omihuequi cal xans Jesús? Pedro timi: ―A'i iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","I'i'ma juaiconapa caxita. Jiƚpe lam mozó jouc'a lapaluc' icue'epá quiƚpunga. Jiƚniya ecaxoƚingoƚai'me, epat'ƚe'moƚtsi. Pedro jouc'a ecaxingai'ma jiƚpiya, epat'ƚe'moxi. ");
INSERT INTO chdNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Cal cuecaj ca'ailli' Anás ticuis'e Jesús, timi: ―¿Naitsi iƚniya ts'ihuejhuo'? ¿Te cofmuc'ipola'? ");
INSERT INTO chdNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús italai'e'e'ma, timi: ―Iya' aipalaipa petsi jahuay aƚsimpa, aƚquimf'epa. Camuc'ila' lan xanuc' mimana' jiƚpiya ƚilejut'ƚi pe lafoƚyomma, jouc'a pe lopa'a al cuecaj xoute'. Camuc'ila' maƚpiya pe lafoƚyomma lan xanuc' judío. Ailopa'a caimuc'ipola' quemiya. ");
INSERT INTO chdNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Itsiya, ¿te calicuis'ecopa te caifmuc'ipola'? Taicuis'etsola' naƚquimf'epa. Iƚne iƚsina' te ts'i'ic' laimipola'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Licuejpa toƚta'a linespa Jesús, una'ma camane li'a anuli ƚapaluc nacaxuya huejnca. Timi: ―Ima', ¿te coftalai'ot'ƚecopa toƚta'a cal cuecaj ca'ailli'? ");
INSERT INTO chdNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús timi: ―Ja'ni a'i canesqui al ƚijca, lu'iƚa'. Ja'ni ainespa al ƚijca, ¿te caluntafcopa camane? ");
INSERT INTO chdNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ma to quifi'iya Jesús, Anás ummepa pe lopa'a cal cuecaj ca'ailli' Caifás. ");
INSERT INTO chdNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro ipanenni ƚipuna ƚa'ailli', ma mecaxu tepat'ƚeyoxi. Icuis'e'me, timiyi: ―¿Te ma ima' jouc'a omihuequi iƚque? Pedro icuanajpa, timi: ―A'i iya'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Anuli ƚimozo cal cuecaj ca'ailli' ipalaic'o'ma Pedro. Iƚque ma ƚipima ƚetec'epa quix'mas Pedro. Timi: ―Iya' cacua joupa aiximpolhuo' jiƚpiya ƚaqueya, ima' jouc'a Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Icuanajcona'ma Pedro, timi: ―Iya' a'i. Aiquicoƚi. Ija'a'ma ƚangiti. ");
INSERT INTO chdNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ipa'a'me Jesús lejut'ƚ Caifás. Ileco'me pe lopa'a cal gobernador romano, iƚque cuftine Pilato. Joupa i'ipa quitine. Lan judío aiquiƚtsuflaic' lejut'ƚ Pilato. Imanenca ƚuna. Timiyoƚtsi: “Aimi'iya maƚtsuflaiyacu. Aƚpic'a ȽanDios aƚsintsonga' ninc'ilimpio. Toƚta'a nipajnya aƚteta lixic' lotejnyacu al juic Pascua.” ");
INSERT INTO chdNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato ipanni pe lomana' iƚniya, timila': ―¿Te ts'i'ic' loƚcuxecocopa cal xans? ");
INSERT INTO chdNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Italai'e'e'me, timiyi: ―I'epa quixcay. Ja'ni ailopa'a qui'aic', ¿te caƚcuai'ecoyacu fa'a ima'? ");
INSERT INTO chdNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato timila': ―Imanc' toƚƚeconƚe. Tiƚinc'ita ƚoƚjuez. Tixanuta iƚta'a lataiqui'. Tonƚ'e'eƚe to minesqui lataiqui', iƚe locuxe'epolhuo'. Lan judío italai'e'e'me, timiyi: ―Illanc' aimi'hua laƚmane, aimi'iya malacani'eyacu. Aimi'iya maƚspic'eyacu tima'anƚe. ");
INSERT INTO chdNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús joupa uya'apa te co'iya mima'ayacu. Itsiya tenanƚ'ma linespa. ");
INSERT INTO chdNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ipainanni, itsufaicona'ma lejut'ƚ. Ijoc'i'ma Jesús ti'huanni. Icuis'e'ma, timi: ―¿Te ima' iƚrey lan xanuc' judío? ");
INSERT INTO chdNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús timi: ―¿Te ima' toƚta'a topalay cotuca', o lan xanuc' aƚnescopa toƚta'a? ");
INSERT INTO chdNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato italai'e'e'ma, timi: ―Iya', ¿te ninjudío? Loxanuc', iƚniya ixanuc' cal cuecaj ca'ailli', icupo'. ¿Jale co'epa? ");
INSERT INTO chdNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús italai'e'e'ma, timi: ―Iya' aicacuxela' lan xanuc' to micuxeyi lan rey nomana' fa'a li'a ƚamats'. Ituca' laifcuxepola' iya'. Ja'ni coƚa' cacuxe to micuxeyi lan rey nomana' li'a ƚamats', iƚniya ts'alihuequi joupa ifulepá, aƚcuanajco'ma aimaƚcuya ticuaita quiƚmane lan xanuc' judío. Itsiya aicacuxe fa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato timi: ―¿Te ima' unrey? Jesús timi: ―Ma to lofnescopa iya' ninrey. Iya' aipajncota aicuaicoco'ma li'a ƚamats' cu'itsola' lan xanuc' al ƚinca. Pe naihuejpá al ƚinca cataiqui', iƚniya aƚcuec'e. ");
INSERT INTO chdNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato timi: ―¿Te jale al ƚinca? Lijoupa linespa toƚta'a Pilato ipaconanni pe lomana' lan xanuc' judío, timila': ―Iya' cacua, iƚque cal xans ailopa'a quijunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ajuic ajuic Pascua toƚcuaiyumma, aƚsahue'e cux'mas'ma anuli ƚitats'iya, toƚe moƚ'eyi. Itsiya, ¿jale ts'oƚpic'a cux'masla'? ¿Ja'ni cux'masla' iƚca'a ƚoƚrey imanc' unc'ijudío? ");
INSERT INTO chdNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Lan judío ija'acona'me, timiyi: ―Aimox'mas'ma iƚque. Tox'masla' Barrabás. Iƚque Barrabás innantsepa, inma'ahuale. ");
INSERT INTO chdNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato icuxe'ma tileconƚe Jesús tipatsa. ");
INSERT INTO chdNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lijou'ma lan soldado ipuf'me anuli al corona quitac. Ipo'nof'i'me ƚijuac Jesús. Itats'mi'me lijahua' unxali cumi. ");
INSERT INTO chdNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","If'iltsaico'me. Tiƚcuaiyumma pe lacaxu to mi'e'enni cal cuecaj xans. Inom'me, timiyi: ―Aƚnom'mo' ima' iƚrey lan xanuc' judío. Ti'hua ti'econayi. Lijou'ma tuntafc'e'eyi li'a. ");
INSERT INTO chdNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ipaconanni ƚuna. Timila' lan judío: ―Toƚsinƚe. Quipa'a'ma ƚuna iƚca'a Jesús. Ti'iƚa' coƚsina' joupa aiximpa ailopa'a quijunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ipa'a'ma ƚuna. Ƚijuac itaic' licorona quitac. Titatsma lijahua' unxali cumi. Pilato timila' lan judío: ―Toƚsinƚe. Jifa'a copa'a cal xans. ");
INSERT INTO chdNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lixim'me Jesús lixanuc' cal cuecaj ca'ailli' jouc'a lilepaluc', iƚniya ija'a'me ujfxi, timiyi Pilato: ―¡Tapaƚts'ijnla' lancruz! ¡Tapaƚts'ijnla' lancruz! Pilato timila': ―Toƚƚecoƚe imanc' coƚtuca'. Tolapaƚts'ijntsa lancruz. Iya' aiximpa ailopa'a quijunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Lan judío timiyi: ―Iƚque ticua: “Iya' i'Hua ȽanDios”. Tipa'a lataiqui' laƚcuxeponga' illanc'. Iƚe lataiqui' ticua: “Tima'antsola' iƚne nocuapá toƚta'a”. ");
INSERT INTO chdNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Licuej'ma iƚe lonespa, Pilato xonca ixpaij'ma. ");
INSERT INTO chdNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Itsufaicona'ma lejut'ƚ, icuis'econa'ma Jesús, timi: ―Ima', ¿pe co'huayomma? Jesús aiquitalai'e. ");
INSERT INTO chdNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato timi: ―¿Te aimaƚtalai'e? ¿Te aicoxina' ti'hua laimane? Nipajnya cux'masna'mo', nipajnya capaƚts'ijm'mo'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús italai'e'ma, timi: ―Tipa'a anuli xonca acueca'. Iƚque ƚepi'ipo' comane. Ima' cotuca' ailopa'a caƚ'e'eya. Naitsi cal xans naƚcupa, iƚque xonca tipa'a lijunac'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Licuej'ma iƚiya lataiqui' Pilato xonca ehue'ma te co'iya mux'masya Jesús. Lan xanuc' judío ti'hua tija'ayi, timiyi: ―Cal xans nonespa: “Iya' ninRey”, iƚque ti'ay quipilaic' César cal cuecaj rey. Ja'Ni tox'masqui Jesús, jouc'a to'ay laic' ƚopoujna César. ");
INSERT INTO chdNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Licuej'ma Pilato lonespa lan judío i'hua'a'ma Jesús ƚuna petsi cuftine “Ƚitat'ƚuyiya”. Liƚtaiqui' lan judío cuftine Gabata. Jiƚpe icutshuai'ma to cal juez. ");
INSERT INTO chdNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iƚe litine avispera al juic cuftine al Pascua. Joupa ti'i'ma to menac'o. Pilato timila' lan xanuc' judío: ―Toƚsinƚe. Jifa'a copa'a ƚoƚrey. ");
INSERT INTO chdNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Iƚne ija'a'me ujfxi, timiyi: ―¡Tolecoƚa', tolecoƚa', tapaƚts'ijntsi lancruz! Pilato timila': ―¿Te caifnepaƚts'ijncoya ƚoƚrey? Lixanuc' cal cuecaj ca'ailli' italai'e'e'me, timiyi: ―Ma le'a César aƚrey. Ailopa'a cocuena. ");
INSERT INTO chdNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lijou'ma Pilato icu'ma Jesús tepaƚts'ijntsa lancruz. Lan soldado ileco'me. ");
INSERT INTO chdNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús itai'ma lencruz. I'hua'ma lane ticuaita Ƚamats' Quecoye. Liƚtaiqui' lan xanuc' judío cuftine Gólgota. ");
INSERT INTO chdNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jiƚpiya epaƚts'ingim'me lencruz Jesús. Jouc'a epaƚts'ingim'mola' oquexi' lan xanuc', anuli al c'a camane Jesús, ƚocuena loxa camane. Jesús epaƚts'ingimpa nolojmay iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato joupa iniƚijmpa anuli lacaxma. Epaƚts'ijm'me laquitoncay ƚijuac Jesús. Iƚe liniƚiya tinesqui: “Iƚca'a Jesús ƚas Nazaret, iƚrey lan xanuc' judío”. ");
INSERT INTO chdNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jiƚpe pe lapaƚts'ijnya Jesús ahuejnca liƚya' Jerusalén. Axpela' lan xanuc' judío uyalaico'me jiƚpiya. Ixhue'me lainilá liniƚingiya lacaxma. Iniƚingiya afane' ƚataiquí, liƚtaiqui' lan judío, liƚtaiqui' lan romano, liƚtaiqui' lan xanuc' griego. ");
INSERT INTO chdNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Lixanuc' cal cuecaj ca'ailli' aiquicuaicotsi quiƚpic'a liniƚpa Pilato, timiyi: ―¿Te cominiƚcopa: “Iƚca'a iƚrey lan xanuc' judío”? Topai'inƚa'. Tuya'aƚa': “Iƚca'a Jesús, maƚque timiyoxi: Iya' iƚrey lan xanuc' judío.” ");
INSERT INTO chdNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato italai'e'e'mola', timila': ―Joupa aininiƚpa. Tipanenni toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lam malujxi lan soldado, iƚne lepaƚts'ijm'me lancruz Jesús, tumma'me lipijahua'. Anuli anuli tumma'me lipijahua'. Ipanenni anuli litoqui lipijahua'. Iƚiya lipijahua' aiquenanc'iya. Apufi ipangocopa ƚejoc xejmay li'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lan soldado timiyoƚtsi: ―Aimaƚts'aƚyacu. Aƚf'ilcoƚe aƚsim'me naitsi nolijya. Toƚta'a enanƚcopa al Paxi Liniƚingiya tuya'e': “Anuli anuli ummana'me laipijahua'. If'ilco'me naitsi tulijla' litoqui laipijahua'.” Toƚta'a li'epa lan soldado. ");
INSERT INTO chdNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tecaxu María qui'máma' Jesús huejnca pe lepaƚts'ijnyompa lencruz. Jouc'a tecaxhuoƚanna ƚipima qui'máma' cuftine María, iƚque ipeno Cleofas, jouc'a María ƚas Magdala. ");
INSERT INTO chdNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús ehuelojm'ma qui'máma' tecaxu jiƚpiya. Jouc'a ixim'ma anuli ts'ihuequi tecaxu liju' qui'máma'. Iƚque ts'ihuequi, Jesús xonca ti'ay capic'a juaiconapa. Jesús timi qui'máma': ―Momá, jiƚpe tipa'a ƚo'hua. ");
INSERT INTO chdNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Timi ts'ihuequi: ―Toxinƚa', jiƚquiya o'máma'. Iƚe litine ts'ihuequi Jesús epenuf'ma qui'máma' Jesús. Ilaitsufcotsi. ");
INSERT INTO chdNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lijou'ma Jesús ipalaicona'ma. Joupa ixina' ixhuaita jahuay liteƚcopa. Ticua: ―Ticui caija'. Toƚta'a loya'apa al Paxi Liniƚingiya. Itsiya iƚiya lataiqui' tenanƚi. ");
INSERT INTO chdNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jiƚpe tipa'a anuli al catsitu imanna al cuxac vino. Ijac'ecom'me al vino anuli al esponja. Ifinc'i'me lupa limane c'ec cuftine hisopo, i'nof'e'me ti'huajcoƚa' lico Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús lijoupa lixnapa ticua: ―Joupa ixhuaicota. Ic'ommai'ma ƚijuac, ummena'ma ƚi'espíritu ti'huanƚa'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iƚe litine avíspera. Lihuequi litine itine conxajya. Iƚe acuecaj quitine. Lan judío iƚpic'a tiƚonc'en‑natsola' liƚcuerpo iƚne lepaƚts'ingimpola', aimicoƚ'mola' jiƚpiya lilencruz. Ticuayi: “Icuaico'ma al cuecaj quitine. Jiƚne liƚcuerpo aimi'iya mimajnyacu jiƚpe lam fane' lancruz.” Ixahue'e'me Pilato tummetsola' lan soldado tepatsuf'entsola' liƚ'mitsi' napaƚts'ingoƚanna. Tijouƚa' tepatsuf'entsola' liƚ'mitsi' iƚne, tiƚonc'enatsola' lilencruz. ");
INSERT INTO chdNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lan soldado icuaitsa petsi cal te'a ƚepaƚts'ingiya lencruz. Epatsuf'e'me li'mitsi', jouc'a epatsuf'e'me li'mitsi' ƚocuena. ");
INSERT INTO chdNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ipailiconanca, icuaitsa pe lopa'a Jesús. Ixim'me joupa imapa. Aiquepatsuf'e'me li'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Anuli cal soldado i'nif'ma lilanza, ena'ma lanza liju' Jesús. Aiquicoƚi, ipanni lajuats', ipanni laja'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Iƚque nainiƚpa iƚe lataiqui' iximpa toƚta'a li'ipa. Ma' aƚinca iƚe liniƚijmpa. Tu'ilhuo' imanc' noƚsueyacu. Ipic'a imanc' jouc'a tonlapenufle iƚta'a lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iƚe li'ipa enanƚcopa al Paxi Liniƚingiya lonespa: “Aimepatsufiya ni anuli lipecaƚ”. ");
INSERT INTO chdNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Al Paxi Liniƚingiya jouc'a tinesqui: “Tehuelojncona'me iƚque ƚenampa liju'”. ");
INSERT INTO chdNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lijou'ma anuli cal xans cuftine José ƚas Arimatea i'huapa pe lopa'a Pilato. Iƚque José joupa epenufpa litaiqui' Jesús. A'i cuya'e'. Tixpaic'ela' lan judío. Ixa'huehuona'ma Pilato tepi'iƚa' lane tileconna licuerpo Jesús. Pilato epi'i'ma lane. I'hua'ma itainatsi licuerpo Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jouc'a icuaiyunni Nicodemo, iƚque nehuejnhuo'ma lipuqui' ixinghuo'ma Jesús. Nicodemo itaic' cal pomada ilanc'ecompa itamqui ƚojuepaj c'a. Iƚta'a litamqui cuftine amirra, ihuomptsi a'áloes. Iƚque cal pomada lipicumta to oquej nuxans quimbamaj kilo. ");
INSERT INTO chdNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Loquexi' i'e'epá licuerpo Jesús ma to mi'eyi iƚne lan xanuc' judío ai'a teminnola' limanapola'. Iju'eco'me licuerpo ijahua' jouc'a cal pomada. ");
INSERT INTO chdNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pe lepaƚts'ijnyompa Jesús jiƚpiya tipa'a huejnca anuli ƚaqueya. Jiƚpe ƚaqueya tipa'a anuli ƚunts'eja' capic, ilanc'empa ti'huejyom'me ƚomaya. Jiƚpe ƚunts'eja' ailopa'a quemimpa. ");
INSERT INTO chdNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Joupa avíspera litine conxajya. Jiƚpe litine aimi'iya miyeyacu aculi'. Lan xanuc' judío aimicuyi lane. Jiƚta'a ƚunts'eja' ma' ahuejnca pe lepaƚts'ijnyompa Jesús. Jiƚpiya i'huequintsa licuerpo Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Icuaitsi al te'a quitine al xamano, iƚe al domingo, aquipuqui' María ƚas Magdala i'hua'ma ƚunts'eja' pe li'nico'enghuo'me Jesús. Icuaitsi ixim'ma joupa iƚonc'empá cal cuecaj capic ƚetemf'ecompa. ");
INSERT INTO chdNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","María ipainanni ƚunts'eja', tinu. Icuaitsi pe lomana' Simón Pedro y ƚocuena ƚihuejpa Jesús. Jiƚque Jesús ƚi'epa capic'a. María timila': ―Joupa ipa'anapá Caƚ'ailli'. Jiƚpe ƚunts'eja' ailopa'a. Aicaƚsina' pe quipo'no'empa. ");
INSERT INTO chdNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro jouc'a ƚiƚejmale ipalunca, iye'me pe li'nico'enghuo'me Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Loquexi' inul'me. Ƚiƚejmale Pedro ulij'ma. Icuaitsi ate'a. ");
INSERT INTO chdNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ehuenac'o'ma licu'u ƚunts'eja'. Ixim'ma ƚijahuaƚi tummac'o. Aiquitsufaic'. ");
INSERT INTO chdNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simón Pedro i'huanc'e'ma iƚque ƚiƚejmale. Icuaitsi ƚunts'eja' itsufai'ma. Jouc'a ixim'ma ƚijahuaƚi tummac'o. ");
INSERT INTO chdNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ixim'ma lijahua' lifi'ecompa li'a, ƚijuac Jesús. Iƚe lijahua' iximpa ijuisquiya, a'i mipa'a anuli jiƚpe ƚocuena ƚijahuaƚi. ");
INSERT INTO chdNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Lijoupa litsufaipa Pedro, itsufai'ma ƚocuena ts'ihuequi Jesús, iƚque ƚicuaita ate'a, ixim'ma li'ipa. Ticua: “Jesús ma' imaf'inapa”. ");
INSERT INTO chdNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iƚniya aiquiƚcueca al Paxi Liniƚingiya loya'apa ticua: “Timaf'ina'ma tipayonno pe lomana' lamizhua”. ");
INSERT INTO chdNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Loquexi' ts'ilihuequi Jesús iyena'me ƚilejut'ƚi. ");
INSERT INTO chdNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María ƚas Magdala icuaiyocontsi pe lopa'a ƚunts'eja'. Tecaxu ƚuna, tijoqui. Mijoqui tehuenac'o licu'u ƚunts'eja'. ");
INSERT INTO chdNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ixim'mola' oquexi' lapaluc' quema'a, afujca liƚpijahua'. Ticutsoƚanna pe lunahuai'epa licuerpo Jesús. Anuli ticutsu ƚijuac, ƚocuena ticutsu li'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Iƚniya timiyi María: ―Maca'no', ¿te cofjojcopa? María timila': ―Ileconapá Cai'ailli' Jesús. Aicaixina' petsi quipo'no'empá. ");
INSERT INTO chdNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lijoupa linespa toƚta'a ipai'e'ma li'a. Iximpa Jesús tecaxu jiƚpiya. Aiquimetsaico'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús timi: ―Maca'no', ¿te cofjojcopa? ¿Naitsi cofmehuepa? María ticua lipicuejma': “Iƚca'a no'epa cuenna ƚaqueya”. Timi: ―Mai'ailli', ja'ni ima' olecopa, lu'iƚa' pe copo'no'ehuo'ma. Iya' ai'huapa caleconna. ");
INSERT INTO chdNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús timi: ―¡María! María ipai'e'moxi, ipalaic'o'ma litaiqui' hebreo, timi: ―¡Raboni! Iƚe lataiqui' tuhuaƚquemma “Momxi”. ");
INSERT INTO chdNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús timi: ―Aimaƚ'noƚ'ma. Aicaicuaiya pe lopa'a cai'Ailli', iƚque jouc'a oƚ'Ailli'. Iƚque ainenDios, imanc' jouc'a olanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María ƚas Magdala i'hua'ma pe lomana' ts'ilihuequi Jesús, timila': ―Aiximpa Caƚ'ailli'. U'i'mola' licuapa Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Joupa ummuhuaita iƚe litine, al te'a quitine al xamano. Iƚne ts'ilihuequi Jesús tefot'ƚeyoƚtsi anuli, ix'nif'miya lajut'ƚ. Tixpaic'ennila' lan judío. Jiƚpe icuaitsi Jesús. Ecax'ma maƚpe pe lomana', timila': ―Aimoƚhuotso'me. Toluyalaiƚe al c'a. ");
INSERT INTO chdNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Imuc'i'mola' limane, liju'. Lixim'me caƚ'Ailli' iƚniya ts'ilihuequi ixojna'ma quileta. ");
INSERT INTO chdNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús timiconala': ―Aimoƚhuotso'me. Ma to cai'Ailli' alummepa, toƚta'a iya' cummelhuo'. ");
INSERT INTO chdNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Lijoupa limipola' toƚta'a, ifusco'mola', timila': ―Capi'ilhuo' cal Espíritu Santo. Tolapenufle. ");
INSERT INTO chdNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ja'ni toƚmiƚe anuli cal xans: “Lojunac' iƚojn‑napa”, ƚinca joupa iƚojn‑napa lijunac'. Ja'ni toƚmiƚe: “Aiquiƚonge lojunac'”, ƚinca aiquiƚonge lijunac' cal xans. ");
INSERT INTO chdNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iƚe lipuqui' licuai'ma Jesús, anuli iƚniya limbamaj coquexi' ts'ilihuequi ailopa'a jiƚpiya. Iƚque cuftine Tomás, ƚacui'impá cal Cuatsi. ");
INSERT INTO chdNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Locuenaye ts'ilihuequi Jesús timiyi: ―Aƚsinnapá Caƚ'ailli'. Tomás timila': ―Ja'ni caxinƚa' limane petsi lepaƚts'ijncompa lan clavo, ja'ni cacaj'miƚa' laidedo pe lecajm'micompa cal clavo, ja'ni cacanc'oƚa' laimane pe lixcai'empa liju', canes'ma: “Ma' imaf'inapa Jesús”. Ja'ni aicaxina toƚta'a ti'hua canes'ma: “Aiquimaf'inghua Jesús. A'i iƚque ƚicuai'ma.” ");
INSERT INTO chdNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Lijoupa luyaipa apaico quitine, efot'ƚecona'moƚtsi ts'ilihuequi Jesús. Ix'nif'miya lajut'ƚ. Tomás jouc'a tipa'a. Icuaitsi Jesús. Ecaxingai'mola'. Timila': ―Aimoƚhuotso'me. ");
INSERT INTO chdNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Timi Tomás: ―Tacajm'miƚa' lodedo iƚna'a laimane'. To'nijla' lomane tacanc'oƚa' lainiju'. Aimonescona'ma: “Jesús aiquimaf'inghua”. Aƚ'huaiyijnla'. Joupa aimaf'inapa. ");
INSERT INTO chdNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás italai'e'e'ma, timi: ―Ima' maiPoujna. Ima' mainenDios. ");
INSERT INTO chdNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús timi: ―Ima' lahuelonge, toƚta'a aƚ'huaiyijmpa. Naitsi laƚ'huaiyijnya tama aicalahuelonge, iƚque ƚinca xonca lipaxnepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mipa'a fa'a li'a ƚamats' Jesús imuc'i'mola' ts'ilihuequi al cueca' li'epa. Toƚta'a imuc'i'mola' ma ȽanDios ƚummepa. Jifa'a aiquiniƚi jahuay iƚta'a li'epa Jesús, ma le'a huata. ");
INSERT INTO chdNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ƚataiquí liniƚiya fa'a timuc'ilhuo' naitsi Jesús, iƚque cal Cristo, ma' i'Hua ȽanDios. Tolapenufle iƚta'a lataiqui', toƚ'huaiyijm'me iƚque Jesús. Toƚta'a tepi'im'molhuo' loƚpitine aimijouya. ");
INSERT INTO chdNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lijou'ma imujcona'moxi Jesús. Icuaiyocontsi pe lomana' ts'ilihuequi. Iƚniya joupa iyepá al cuecaj quin'nuhua' cuftine Tiberias. (Jouc'a tecui'inni Galilea.) Fa'a cuya'e' li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jiƚpe efot'ƚe'moƚtsi hualca ts'ilihuequi Jesús. Iƚniya Simón Pedro, Tomás iƚque cal Cuatsi, Natanael iƚque lipiƚya' Caná lopa'a al distrito Galilea. Jouc'a timana' loquexi' linaxque Zebedeo, jouc'a ocuenaye loquexi' ts'ilihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro timila': ―Ai'huapa ca'noƚta catú. Locuenaye timiyi: ―Ne'. Jouc'a ƚepá illanc'. Ipalunca, if'ajli'me al barco. Iƚe lipuqui' aiqui'noƚ'me ni' anuli ƚatu. ");
INSERT INTO chdNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Li'ipa quitine tipa'a Jesús tecaxu ƚema caja. Ts'ilihuequi aiquilimetsaijma ja'ni Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús ijoc'i'mola', timila': ―Imanc' cunc'ainaxque', ¿te oƚ'noƚpá o a'i? Italai'e'e'me, timiyi: ―A'i. Ni toƚca'a anuli aicaƚ'noƚi. ");
INSERT INTO chdNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Timila': ―Tolacajm'micontsa cal xami. Tolacajm'mitsa al c'a camane al barco. Jiƚpiya ƚinca tululijtola' latuye. Ecajm'mihuo'me ƚiƚxami. Lijou'ma ixim'me acumta i'ipa cal xami, aimi'iya mexaƚcufyacu, mif'ac'eyacu, minij'miyacu al barco. Imanna catuye. ");
INSERT INTO chdNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Anuli ts'ihuequi Jesús, iƚque ƚi'epa capic'a juaiconapa, ipalaic'o'ma Pedro, timi: ―Iƚque aƚ'Ailli' Jesús. Simón Pedro joupa ipa'apa litsamalo. Licuej'ma icuai'ma Jesús aiquicoƚi, ijojcocona'ma litsamalo, ecajm'mi'moxi laja', ti'hua'ma ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Locuenaye ts'ilihuequi Jesús if'ajli'me al barco. A'ij culi' ƚema caja, tocomma amaxnu metro. Ihuej'me Pedro, equif'me cal xami imanna catuye. ");
INSERT INTO chdNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Icuaitsa ƚema caja, ixim'me imac'o ƚunsuac'. Jiƚpiya tipa'a anuli ƚatu, joupa tixanuya. Ixim'me tipa'a ƚa'i jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús timila': ―Toƚ'hua'anca hualca latuye loƚ'noƚpa. ");
INSERT INTO chdNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pedro if'aj'ma al barco, exaƚ'ma cal xami ƚijuƚ camats'. Iƚca'a cal xami imanna catuye. Iƚne latuye ixhuej'me'mola' ixhuaitsi anulij maxnu oquej nuxans quimbama' fane'. Axpe' catuye cal xami aiquits'aƚquenni. ");
INSERT INTO chdNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús timila': ―Tonƚouyunca. Aƚtetso'me. Ts'ilihuequi Jesús aiquilicuis'e: “¿Naitsi ima'?” Tixinyi calaic'ata. Iƚsina' maƚque iƚ'Ailli' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús iƚoc'huai'ma, epef'ma ƚa'i, epi'i'mola'. Epi'i'mola' jouc'a ƚatu. ");
INSERT INTO chdNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Joupa i'ipa afanemma mimujyoxi Jesús. Ts'ilihuequi iximpá joupa imaf'inapa, ipanamma pe lomana' lamizhua. ");
INSERT INTO chdNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Lijou'ma litetso'me Jesús timi Simón Pedro: ―Simón, ima' i'hua Jonás, lopimaye aƚ'ay capic'a. ¿Te ima' xonca aƚ'ay capic'a? Pedro timi: ―Mai'ailli', ima' oxina' aƚejmalepá. Jesús timi: ―Tohuic'itsola' lan tsocay laimot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús icuis'econa'ma, timi: ―Simón, ima' i'hua Jonás, ¿te aƚ'ay capic'a? Pedro italai'e'e'ma, timi: ―Mai'ailli', ima' oxina' aƚejmalepá. Timi: ―To'etsola' cuenna laimot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús icuis'econa'ma, timi: ―Simón, ima' i'hua Jonás, ¿te ma aƚejmalepá? Pedro ixhueƚco'ma juaiconapa petsi limipa iƚta'a. Ticua: “¿Te calicuis'ecocopa: Te ma' aƚinca aƚejmalepá. Joupa afanemma aƚmipa toƚta'a.” Timi: ―Mai'ailli', ima' oxina' jahuay. Oxina' aƚinca aƚejmalepá. Jesús timi: ―Tohuic'itsola' laimot'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iya' camihuo' al ƚinca: Ima' li'ipa mamijcano, ima' cotuca' tofi'e' lopijahua', o'hualecopa ni petsi lofjanajpa loftseya. Titojnatso' ti'i'ma ituca' lofmuyaicoya. Ima' to'nij'ma lomane, ocuena tifi'e'mo', tileco'mo' petsi aimetenƚcocoyaco'. ");
INSERT INTO chdNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Lines'ma toƚta'a Jesús u'i'ma te ts'i'ic' mimaya Pedro. Ma mima'ayi Pedro, lan xanuc' tixim'me acueca' ȽanDios, acueca' titoc'ila' lixanuc'. Lijou'ma timi: ―Lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro ehuelojm'ma lixpula', ixim'ma ƚocuena ts'ihuequi Jesús i'huanc'e. Iƚque ts'ihuequi Jesús ƚi'epa capic'a juaiconapa. Iƚe lipuqui' lixmoco'me iƚque iƚoc'huaipa Jesús, icuis'epa: “Mai'ailli', ¿naitsi nocuyaco'?” ");
INSERT INTO chdNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro lixim'ma iƚque ihuequi Jesús icuis'e'ma Jesús, timi: ―Mai'ailli', ¿te coyaicoya iƚque? ");
INSERT INTO chdNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús timi: ―Ja'ni iya' aipic'a tipanenni, ja'ni cacuaiconanni caxim'ma tipa'a, ¿te cofcuaya ima'? Ma' iya' caxpic'e te loyaicoya iƚque. Ima' lihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lijou'ma lapimaye, iƚne naihuejpá Jesús, tinesyi: “Ƚapima pe Jesús ƚo'epa capic'a juaiconapa, iƚque aimimaya”. Jesús a'i toƚta'a limipa Pedro. Imipa: “Ja'ni iya' aipic'a tipanenni iƚque, ja'ni cacuaiconanni caxim'ma tipa'a, ¿te cofcuaya ima'? Ma' iya' caxpic'e te loyaicoya iƚque.” ");
INSERT INTO chdNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ts'ihuequi Jesús, iƚque pe Jesús ƚi'epa capic'a juaiconapa, ma' iƚque tu'ilhuo' te ts'i'ic' li'ipa, iniƚpa fa'a. Iniƚpa al ƚinca, toƚta'a aƚsina' illanc'. ");
INSERT INTO chdNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús axpe' i'epa acueca'. Fa'a aiquiniƚingiya jahuay. Ja'ni tiniƚƚe anuli anuli jahuay li'epa Jesús, axpe' je'e tilajm'ma. Fa'a li'a ƚamats' aimi'ommaicoya.");
INSERT INTO chdNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ima' Teófilo, quiniƚ'ehuo' coje'e. Joupa niniƚ'epo' anuli loje'e. Jiƚe loje'e nu'ipo' acuajmaica te ts'i'ic' lipangopa li'epa Jesús, te ts'i'ic' limuc'iyalepa jouc'a te ts'i'ic' luyaicopa lipepajnya mipa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mipa'a Jesús fa'a li'a ƚamats', ai'a tepenufinnata al toncay lema'a, maƚe litine iƚque ixc'ai'ipola' li'apóstole, iƚne li'huijf'epola'. Iƚe litaiqui' lixc'ai'ipola' ma' itaiqui' cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Lixc'ai'ipola' toƚta'a Jesús joupa iteƚcopa, imapa, imaf'ina'ma, imuj'moxi pe lomana' jiƚne li'apóstole. Imuc'i'mola' ma' imaf'i'. Micoƚi oquej nuxans quitine, li'apóstole tixinyi Jesús ti'hua timujyoxi. Tipalaic'ola', tu'ila' te ts'i'ic' locuxeyalepa ȽanDios cal Cuecaj Rey. ");
INSERT INTO chdNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mimana' anuli icuxe'e'mola' timanenca al cuecaj quiƚya' Jerusalén. Aimiye'me. Ti'huaicoƚe ti'iƚa' to linespa ȽanDios. Timila': ―Joupa aimipolhuo' lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan epo'iyalecopa aja'. Aimicoƚya, tepo'icom'molhuo' cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mefoƚumma icuis'e'me Jesus, timiyi: ―MaƚPoujna, illanc' ixanuc' Israel, iƚna'a ƚitiné, ¿te ima' aƚtoc'i'monga', aimaƚcuxeconayaconga' locuenaye lan xanuc'? ");
INSERT INTO chdNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Timila': ―Imanc' aimi'iya coƚsina' lo'iya. ȽanDios tixpic'e'ma te quitine lo'iya toƚta'a. Iƚque ts'ixina' ja'ni ticoƚ'ma o aimicoƚya. ");
INSERT INTO chdNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iya' camilhuo': Cal Espíritu Santo timuyohuo lema'a. Tipaxne'molhuo' imanc'. Tepi'i'molhuo' loƚmane aƚpalaico'ma iya'. Aƚpalaico'ma jifa'a liƚya' Jerusalén, jouc'a aƚpalaicota jahuay al distrito Judea, jouc'a ƚamats' Samaria, jouc'a ni petsi li'a ƚamats', xonca al culi'. ");
INSERT INTO chdNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lijoupa limipola' toƚta'a, mehuelojnyi li'apóstole, Jesús if'ajna'ma. Ilecona'ma anuli ƚummahuay. Aiquixingona'me. ");
INSERT INTO chdNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mif'aquinghua Jesús, tehuenaf'yi lema'a li'apóstole, icuaitsa oquexi' lan xanuc', afujca liƚpijahua'. Ecaxoƚai'me huejnca. ");
INSERT INTO chdNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Timiyi: ―Imanc' ixanuc' Galilea, ¿te colahuenaf'copa lema'a? Joupa iƚonc'e'enapolhuo' Jesús, ileconapa lema'a. To jiƚta'a moƚsinyi lif'ajnapa lema'a, ma toƚta'a ticuaiyoconno maƚque Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Toƚta'a li'ipa mimana' jiƚpiya ƚijuala Olivo. Iƚque ƚijuala ahuejnca Jerusalén, to anuli kilómetro. Tama litine conxajya ticunni lane to'hua'ma iƚe lipiculi'. Lan apóstole ipailinanca, iye'me Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Icuaitsa Jerusalén itsuflai'me lajut'ƚ. If'ajli'me al toncay. Jiƚe lajut'ƚ ixa'huepá, imajmpá iƚne lan apóstole, Pedro, Juan, Jacobo, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo i'hua Alfeo, Simón jouc'a Judas, i'hua Jacobo. Iƚque Simón ai'a tihuej'ma Jesús anuli liƚpicuejma' lan xanuc' nocuapá: “Lunƚu'e'me ƚalamats'”. ");
INSERT INTO chdNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","I'i'ma anuli liƚpicuejma' lan apóstole, itine itine ti'hua tijoc'iyi ȽanDios. Jouc'a efot'ƚeyoƚtsi lacaƚ'no', iƚne liyejmalepá Jesús, jouc'a María qui'máma' Jesús, jouc'a lipimaye Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Iƚne ƚitiné Pedro ecax'ma, ipalaic'o'mola' lipimaye. Timana' to amaxnuj nuxans lefot'ƚeyoƚtsi. Timila': ");
INSERT INTO chdNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Imanc' cunc'aipimaye, al Paxi Liniƚingiya tuya'e' linespa David, iƚe itaiqui' cal Espíritu Santo. David uya'a'ma lo'eya Judas, iƚque ƚi'huaj'me'mola' lan xanuc' li'noƚ'me Jesús. Joupa enanƚpa iƚe loya'apa al Paxi Liniƚingiya, toƚta'a ticuicomma. ");
INSERT INTO chdNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iƚque Judas anuli illanc' ninc'apóstole, anuli laƚpenic'. ");
INSERT INTO chdNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas li'epa iƚe lixcay i'najtsempa, epenuf'ma al tomí, i'naco'ma anuli ƚamats'. Jiƚpe iƚquiya ecanghuaitsi, untaf'ma licu'u, ipanni ƚipucuiyale. ");
INSERT INTO chdNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jahuay nomana' Jerusalén icuej'me li'ipa. Iƚque ƚamats' ƚi'napa Judas ecui'im'me Aceldama. Iƚe lataiqui' iƚtaiqui' iƚne lan xanuc', tuhuaƚquemma cuftine: Ƚamats' cajuats'. ");
INSERT INTO chdNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pedro ti'hua tipalaic'ola' liƚejmale, timila': ―Tuya'e' iƚe al je'e lan Salmo liniƚingiya: Tipanenni quituca' lejut'ƚ iƚque cal xans. Nij naitsi nopajnconaya. Jouc'a tuya'e': Iƚque, iƚe lipenic', ti'eƚa' ocuena. ");
INSERT INTO chdNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Fa'a timana' laƚpimaye, iƚne laƚejmale malihuejyi ƚaƚPoujna Jesús jifa'a li'a ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mepo'iyale Juan, aƚejmalepá iƚne anuli. Litine lileconnapa lema'a ƚaƚPoujna Jesús, laƚpo'noponga' caƚtuca', ti'hua aƚejmale. Itsiya aƚ'huijf'e'me anuli iƚne. Ma' anuli luya'a'me: Imaf'inapa Jesús, aƚsimpá. ");
INSERT INTO chdNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ifaquim'mola' oquexi' lan xanuc' naitsi lolijya iƚe lanic'. Iƚne loquexi' anuli cuftine José Barsabás, ƚocuena cuftine Matías. Iƚque José ƚacui'impa Justo. ");
INSERT INTO chdNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ijoc'i'me ƚaƚPoujna Jesús, timiyi: ―MaƚPoujna, ima' mimetsaicola' te ts'i'ic' liƚpicuejma' jahuay lan xanuc'. Oxina' te ts'i'ic' laƚpicuejma'. Jifa'a timana' oquexi' laƚejmalepá. Ima' joupa o'huijf'epa anuli. Aƚmuc'itsonga' naitsi iƚque. ");
INSERT INTO chdNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Aƚ'eƚe anuli laƚpenic' ninc'apóstole. Toƚta'a lipenic' Judas. Ipo'nopa i'huapa pe lotsepá lif'as quixcay xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","I'e'me naitsi coc'aiƚmaiya. Ec'aiƚmaita Matías. Limbamaj nuli lan apóstole epenuf'me. ");
INSERT INTO chdNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Icuaitsi litine al juic Pentecostés. Maƚe litine lan apóstole jouc'a liƚejmale efot'ƚe'moƚtsi anuli. ");
INSERT INTO chdNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Icuej'me tuna'e' lema'a, to mi'hua'ma ujfxi cahua'. Jiƚpe lajut'ƚ tocomma imanna ƚona'apa. ");
INSERT INTO chdNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ixim'me to ƚipaƚ cunga ixc'if'moxi, ipanenni anuli anuli ƚiƚjuac iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Cal Espíritu Santo icuxe'e'mola' liƚpicuejma'. Tu'ila' te ts'i'ic' minesyacu. Ipango'me ipalai'me ituca' cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Iƚne ƚitiné liƚya' Jerusalén timana' axpela' lan xanuc' judío tixantseyi quiƚjuic. Iƚne quiyouyomma ni petsi li'a ƚamats', tihuejcoyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Icuej'me tuna'e'. Icuaiyunca pe lomana' lan apóstole jouc'a liƚejmale. Aiquiƚsina' te qui'ipa. Tama ocuena ocuena liƚtaiqui' jahuay iƚniya icuec'e'me lonespa lan apóstole. ");
INSERT INTO chdNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tocomma tipailo liƚpicuejma', ixpailij'mola'. Ticuayi: ―Iƚne nopalaipá quiyouyomma Galilea. ");
INSERT INTO chdNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Illanc' aƚmajnliyota ituca' ituca' ƚalamats', ocuena ocuena laƚtaiqui'. Itsiya, ¿te qui'ipa? Jahuay illanc' aƚcuec'ela' iƚniya lonespa. ");
INSERT INTO chdNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Fa'a ja'ni ninc'iPartia, ninc'iMedia, ninc'Elam, ja'ni caƚouyomma ƚamats' Mesopotamia, o Judea, o Capadocia, o Ponto, o Asia, ");
INSERT INTO chdNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","o Frigia, Panfilia, Egipto, jouc'a ƚamats' Libia, iƚe ahuejnca liƚya' Cirene, ja'ni Roma aƚpiƚya' aƚcuai'me al juic, ja'ni aƚmana' ma ninc'ijudío, o ja'ni ocuena laƚraza, lihuejcoyi ƚilenDios lan judío, ");
INSERT INTO chdNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ja'ni aƚmana' ninc'iCreta, o aƚmana' ninc'Arabia, tama ituca' ituca' caƚouyomma, ocuena ocuena laƚtaiqui', itsiya jahuay aƚcuec'eyi iƚne lopalaipa. Aƚcuejyi tipalaiyi ƚaƚtaiquí. Tuya'ayi al cueca' lo'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iƚne lan xanuc' miquimf'eyi tocomma tipailo liƚpicuejma'. Tixhueƚcoyi juaiconapa. Ticuayi: ―¿Te qui'icopa toƚta'a liƚtaiqui' iƚniya? ");
INSERT INTO chdNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ocuenaye ixoco'me, ticuayi: ―Iƚne nopalaipá joupa imeyojpola'. Ixnapá juaiconapa al ts'ej vino. ");
INSERT INTO chdNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Limbamaj nuli lan apóstole jouc'a Pedro enaj'moƚtsi locuenaye lapimaye nomana' jiƚpe, ecaxoƚai'me. Pedro ipalai'ma ujfxi, ipalaic'o'mola' lefoƚya, timila': ―Capalaic'olhuo' jahuay imanc' olafot'ƚeyoƚtsi fa'a Jerusalén. Hualca imanc' noƚmana' fa'a olamats' Judea, locuenaye imanc' ocuena colamats'. Itsiya cami'molhuo', cuhuaƚc'e'e'molhuo' iƚe li'ipa. ¡Aƚquimf'eƚa'! ");
INSERT INTO chdNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","’Imanc' toƚcuayi: Iƚnu'hua lan xanuc' joupa imeyojpola'. A'ij ƚinca loƚnespa. Itsiya apuqui'iya. Le'a apelƚa 'hora. ");
INSERT INTO chdNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Itsiya i'ipa to luya'apa Joel cal profeta. Iƚque uya'apa toƚta'a ti'i'ma, inespa: ");
INSERT INTO chdNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ȽanDios tuya'e': Iƚna'a ƚitiné, ai'a tijou'ma li'a ƚamats', iya' cumme'ma ƚai'Espíritu. Lan xanuc' ni petsi lomana' li'a ƚamats' tepenuf'me. Loƚnaxque' camijcanó jouc'a loƚnaxque' cahuats'la, tuya'a'me laifnu'iyacola'. Litine lolamijcanó tixim'me laifmuc'iyacola', lipuqui' litojpola' xanuc' tipaiyo'me, iya' capi'i'mola' quiƚpaiyo. ");
INSERT INTO chdNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lan xanuc' jouc'a lacaƚ'no', pe nalimetsaicopa iya' iƚPoujna, iƚniya tepenuf'me ƚai'Espíritu, tuya'a'me laifmiyacola'. Ma' iya' cumme'ma ƚai'Espíritu, ticuaita pe lomana' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lan xanuc' tixim'me acueca' laifmuc'iyacola' fa'a li'a ƚamats'. Tehuenaf'le al toncay lema'a tixim'me al cueca'. Tixim'me to lajuats', jouc'a ƚunga, jouc'a juaiconapa quicuxis. ");
INSERT INTO chdNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ƚalapalai'enga' timufc'o'ma. Cal mut'ƚa ti'i'ma to lajuats'. Tijouƚa' ti'iƚa' toƚta'a ticuaihuo jiƚe Litine ȽanDios. Jahuay tixim'me acueca' Litine iƚe; acueca' juaiconapa lo'eya ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Naitsi nojoc'iya ȽanDios, naitsi noxa'hueya titoc'iƚa', iƚque ƚinca tunƚu'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Imanc' ixanuc' Israel, aƚquimf'eƚa' laifnu'iyacolhuo': Cal xans Jesús ƚas Nazaret ma ȽanDios epi'ipa limane, toƚta'a imuj'moxi ma' anDios. Iƚque Jesús li'huamma icuaitsi pe loƚmana', i'e'ma al cueca', i'e'ma ma to lo'eya ȽanDios. Toƚta'a imuc'ipolhuo' naitsi ƚummepa. Joupa oƚsina' iƚe li'ipa. ");
INSERT INTO chdNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lijou'ma i'i'ma ma to quixina' ȽanDios lo'iya, ma to lixpic'e'ma. Iƚque cal xans Jesús ȽanDios icupa, epi'ipolhuo' imanc'. Imanc' oƚcu'me icuaitsi quiƚmane ts'iƚpenic'. Toƚmila' lan xanuc', iƚne pe aimihuejcoyi ȽanDios: “Tonlapaƚts'ijntsa lancruz”. Toƚta'a qui'ic' imanc' oƚma'apá. ");
INSERT INTO chdNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lijou'ma ȽanDios imaf'i'ina'ma. Aiquipo'nohuo quimac'. Unƚu'e'ma. Lamaya aiqui'ic' culiqui nulemma. ");
INSERT INTO chdNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Li'ipa to linespa David mipalaicojma Jesús, tuya'e': Iya' aiximpa lo'iya, ƚaƚPoujna aimaƚpo'noya caituca'. Itine itine aƚmajm'me anuli, iƚque tipa'a al c'a camane, aƚtoc'i. Ailopa'a caƚspaic'eya. ");
INSERT INTO chdNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Toƚta'a caxina amaf'ca ƚainunxajma'. Cuya'a'ma: Iya' tixoqui neta juaiconapa. Aixina' cuyaico'ma al c'a jouc'a laicuerpo. Tijouƚa' laipitine fa'a li'a ƚamats' cunxaj'ma tixoj'ma neta. ");
INSERT INTO chdNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Iya' ƚai'alma aimaƚpo'noya pe lomana' lamizhua. Iya' o'huexi, ima' aiPoujna, aƚtoc'i'ma, laicuerpo aimihuet'ƚya. ");
INSERT INTO chdNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Iya' aixina' laif'eya, joupa aƚmuc'ipa, culij'ma laipitine. Capajn‑na'ma pe lofpa'a, ima' toxhuai'ni'ma laixojcoya neta. ");
INSERT INTO chdNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Cunc'aipimaye, lapi'iƚa' lane capalaic'o'molhuo' al cuajmaica cataiqui'. Imanc' joupa oƚsina' li'ipa ƚaƚtatahuelo David. Iƚque imanapa, temuya. Lipu'hua tipanenni fa'a liƚya' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Iƚque David aprofeta. ȽanDios u'i'ma lo'iya. Joupa epi'ipa cataiqui' imipa: Ima' lofcuxeya aimijouya. Ima' ti'i'ma itatahuelo cal Cristo iƚque ƚaifnummeya ticuxeƚa'. David aiquimenc'ejma iƚe litaiqui' ȽanDios limipa. Ixina' lo'eya ȽanDios, ipalaico'ma lo'iya cal Cristo, ticua timaf'ina'ma. Toƚta'a li'ipa. Iƚque cal Cristo ƚi'alma ȽanDios aiquipo'nohuo nulemma pe lomana' lamizhua, licuerpo aiquihuet'ƚqui. ");
INSERT INTO chdNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iƚque cal Cristo maƚque Jesús, ȽanDios imaf'i'ina'ma, itsahue'enanni. Jahuay illanc' aƚsimpá imaf'inapa. ");
INSERT INTO chdNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ȽanDios qui'Ailli' cal Cristo imi'ma: “Capi'i'mo' cal Espíritu Santo. Tommeta pe lomana' laixanuc'.” Toƚta'a li'ipa. ȽanDios if'ac'enapa lema'a, epi'ipa toƚta'a limane. Iƚque Cristo joupa ummepa cal Espíritu Santo. Imanc' aƚquimf'enga' laƚpalaipa, lahuelonginga' laƚ'ejma'. Toƚta'a maƚcuxenga' cal Espíritu. ");
INSERT INTO chdNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David a'i quif'aqui lema'a. Maƚque tuya'e': ȽanDios tipalaic'o ƚaiPoujna, timi: “Tocutshuai'ma jifa'a al c'a camane. ");
INSERT INTO chdNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Topanehuo fa'a, iya' mi'hua culiquila' lo'epo' laic'. Tijouƚa' ima' tocuxena'mola'.” ");
INSERT INTO chdNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Imanc' ixanuc' Israel; itsiya jahuay imanc' toƚcuec'eƚe iƚe li'ipa. Iƚque Jesús imanc' olapaƚts'ijmpá lancruz, ȽanDios imetsaicopa aƚPoujna, imetsaicopa cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Licuej'me iƚe lataiqui' ecajm‑maitsi lataiqui' liƚpicuejma', icuaitsi ƚilunxajma'. Ixhueƚconca juaiconapa. Icuis'e'me, timinnila' Pedro jouc'a locuenaye apóstole: ―¿Te caƚ'eyacu? Imanc' cunc'aƚpimaye lu'itsonga'. ");
INSERT INTO chdNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro timila': ―Toƚsuej'menca. Toƚnesle: “Al ƚinca iƚque Jesús aCristo”. Tepo'intsolhuo' anuli anuli imanc'. ȽanDios tiƚonc'e'e'molhuo' loƚjunac'. Tepi'im'molhuo' cal Espíritu Santo. Joupa inespa toƚta'a ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Itsiya toƚta'a timila' jahuay nojoc'ipola'. Timilhuo' imanc', timila' loƚnaxque', jouc'a timila' iƚniya nomana' aculi'. ");
INSERT INTO chdNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Lijoupa limipola' toƚta'a, Pedro ti'hua tipalaic'ola' xonca. Ti'hua tixc'ai'ila', tixa'huela', timila': ―Aimolihuej'mola' lan xanuc' nomana' itsiya. Iƚne aimihuejyi al ƚijca lipene ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iƚe litine lan apóstole jouc'a liƚejmale epenufim'mola' to afanej mil lan ts'e capimaye, iƚne epenufpá litaiqui' Pedro epo'im'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jahuay lapimaye tihuejyi lomuc'iyalepa lan apóstole. Tiyejmaleyi, titoc'iyoƚtsi. Ti'eyi to Jesús lixc'ai'ipola' li'apóstole. Tefot'ƚeyoƚtsi, tixquec'iyoƚtsi ƚa'i, titeji. Tijoc'iyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iƚniya ƚitiné jahuay lan xanuc' tixpaic'eyi ȽanDios. Ailopa'a natets'ipa ȽanDios. Lan apóstole ti'eyi al cueca'. Timuc'innila' lan xanuc' lipepaxi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jahuay iƚne naihuejcopá Jesús i'e'e'moƚtsi anuli. Timiyoƚtsi: ―Maipima, ƚai'huexi iya' ima' o'huexi jouc'a. ");
INSERT INTO chdNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ja'ni ƚamats', ja'ni ocuena quiƚ'huexi, pe ts'iƚ'hueca ticujyi. El tomí lolijpa teca'nennila' lapimaye pe ailopa'a quiƚ'hueca. ");
INSERT INTO chdNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Itine itine tiyeyi al cuecaj xoute', tefot'ƚeyoƚtsi. I'ipa anuli liƚpicuejma'. Jouc'a tefot'ƚeyoƚtsi ƚilejut'ƚi. Jiƚpe titeji ƚa'i lixquetsufiya. Ƚinca tixoqui quileta titetsoyi anuli. ");
INSERT INTO chdNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tix'najtsi'iyi ȽanDios. Locuenaye xanuc' tetenƚcocola' liƚ'ejma'. Itine itine ƚaƚPoujna Jesucristo tunƚu'ela' lan xanuc'. Toƚta'a ixpepola' lapimaye, tefot'ƚeyoƚtsi anuli. ");
INSERT INTO chdNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Anuli litine iye'me al cuecaj xoute' Pedro jouc'a Juan. I'ipa al fanej hora. Maƚpe lan xanuc' tijoc'iyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jiƚpe ticutsu anuli cal coxo. Toƚta'a lipajnta. Itine itine tiƚcuai'emma ƚunaj xoute', pe lopa'a al puerta lacui'impa: Xonca Lilange. Jiƚpe cal coxo tixahue'ela' tepi'inni quitomí iƚne lan xanuc' mitsuflaiyi al xoute'. ");
INSERT INTO chdNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ixim'mola' Pedro jouc'a Juan mitsuflaiyi al xoute', ixahue'e'mola' tepi'iƚe quitomí. ");
INSERT INTO chdNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro jouc'a Juan ehuelonc'e'e'me li'a. Pedro timi: ―Ima' alahuelojntsonga'. ");
INSERT INTO chdNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Cal xans i'e'ma to limi'ma. Ticua: “Lapi'i'ma caitomí”. ");
INSERT INTO chdNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro timí: ―Iya' ailopa'a caitomí, ni huata ni axpe'. Ƚinca catoc'i'mo'. Cajoc'i'ma Jesús ƚas Nazaret, iƚque tixaƚ'metso'. Ima', ¡totsahuenni! ¡To'huaƚa'! ");
INSERT INTO chdNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro i'noƚ'e'e'ma al c'a quimane. Ecaxu'ma. Aiquicoƚ'ma i'ina'ma quiƚpujfxi li'mitsi', jouc'a licoxac' qui'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Iyuf'conni, ecax'ma, ipango'ma i'hua'ma. Itsuflai'me al xoute' iƚque jouc'a Pedro y Juan. Ti'hua iyuf'conni, tix'najtsi'i ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jahuay lan xanuc' nomana' jiƚpiya ixim'me ti'hua, icuej'me tix'najtsi'i ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Imetsaico'me, ticuayi: “Iƚca'a cal xans micutsu ƚunaj xoute' jiƚpe al puerta lacui'impa: Xonca Lilange, tixa'hue quitomí. Itsiya, ¿te qui'ipa? Itsiya ti'huanghua.” ");
INSERT INTO chdNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jiƚpe al cuecaj xoute' ƚipinujnca Salomón efot'ƚe'moƚtsi lan xanuc'. Iximpá cal coxo joupa ixaƚconapa, tecaxc'o nolojmay Pedro y Juan, i'noƚila' iƚniya. Ticuayi: “¿Te qui'ipa lixaƚcopa?” ");
INSERT INTO chdNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro lixim'mola' lan xanuc' lefoƚya timila': ―Imanc' cunc'ixanuc', oƚtatahuelo Israel, ¿te aicoƚcueca li'ipa? ¿Te calahuelojncoponga' illanc'? ¿Te aga illanc' caƚtuca' aƚ'e'epa ti'huaƚa' iƚque cal xans? ¿Te aga illanc' xonca lihuejcoyi ȽanDios, toƚta'a lapi'iponga' laƚmane aƚsaƚ'meƚe jiƚca'a cal xans? A'i. ");
INSERT INTO chdNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ma ȽanDios i'epa iƚta'a al cueca' itsiya. Iƚque ilenDios laƚtatahueló Abraham, Isaac y Jacob jouc'a ilenDios laƚ'aillí, itsiya imuc'ipolhuo' joupa imetsaicopa Jesús i'Hua. Imuc'ipolhuo' joupa imetsaicopa ixhuai'nipa lipenic', iƚe lanic' lepi'ipa ti'eƚa'. Maƚque Jesús imanc' oƚcupá icuaitsi limane ƚincuxepa Pilato. Pilato ipic'a tux'masnaƚa', imanc' aicoƚcuac', oƚcuanac'epá. ");
INSERT INTO chdNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Imanc' oƚsa'hue'me Pilato tux'masnaƚa' ƚocuena cal xans, iƚque cal cuej quinma'ahuale. Jesús, cal Paxi Xans, cal Ƚijca Xans, imanc' aicoƚcuac', aicolapenufi. ");
INSERT INTO chdNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Imanc' oƚma'a'me Jesús, maƚque ƚalapi'iponga' laƚpitine. ȽanDios imaf'i'inapa, ipa'apa pe lomana' lamizhua. Jahuay illanc' laƚejmalepá aƚsimpá imaf'inapa. ");
INSERT INTO chdNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aƚ'huaiyijnyi Jesús. Aƚsina' ja'ni aƚnesco'me lipuftine Jesús, ȽanDios tixaƚ'me'ma cal coxo. Toƚta'a li'ipa. Maƚque Jesús aƚtoc'iponga' aƚ'huaiyijnle toƚta'a, toƚiya imanc' toƚsinyi iƚca'a cal xans joupa ixaƚconapa, ailopa'a quicuana. ");
INSERT INTO chdNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Cunc'aipimaye, aixina' li'ipa. Litine loƚma'apa Jesús imanc' aicoƚsina' naitsi iƚque. Jouc'a aiquiƚsina' iƚne nicuxepolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma ȽanDios enant'ƚipa litaiqui', iƚe loya'apa lam profeta. Jahuay iƚniya uya'a'me titeƚco'ma cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","’Itsiya toƚsuej'menca iƚe loƚ'epa. Toƚpai'iƚe loƚpicuejma'. Toƚta'a ȽanDios tiƚonc'e'ena'molhuo' loƚjunac', tunxac'i'molhuo', tipaxne'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ȽanDios joupa u'ipolhuo' tumme'e'molhuo' cal Cristo. Ja'ni toƚsuej'menanca, ƚinca tumme'econa'molhuo' Jesús, maƚque cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iƚque copa'a pu'hua lema'a, i'huaijma ticuaitsi litine jahuay tilajnla' al c'a, ti'iƚa' al ts'e lema'a, al ts'e li'a ƚamats'. Toƚta'a linespa ȽanDios. Li'ipa lipaxi profeta uya'a'me iƚe litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés inesco'ma cal Cristo locuaicoya fa'a li'a ƚamats'. U'ipola' laƚtatahueló lo'iya, timila': ȽanDios ƚoƚPoujna tepi'i'molhuo' anuli cal profeta. Iƚque aƚ'onƚcota to iya', ti'i'ma anuli ƚoƚpiƚya' xans. Iƚque toƚquimf'e'me, tolihuejco'me jahuay lomiyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Naitsi aimihuejma, iƚque tenaj'ma nulemma, aimi'econayacola' anuli lixanuc' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ipangocopa Samuel jahuay lam profeta uya'a'me ma' anuli lo'iya. Itsiya enanƚpa luya'apa. ");
INSERT INTO chdNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Imanc' inaxque' lam profeta, ti'i'ma tolapenuf'me iƚe al c'a lonescopa iƚniya. ȽanDios litine lipalaic'opa Abraham timi: “Tipajnta anuli nopaxneyacola' lan xanuc' ni petsi lomana' li'a ƚamats'. Ima' ti'i'ma itatahuelo iƚquiya.” Maƚe lataiqui' ȽanDios epi'ipola' loƚtatahueló jouc'a epi'ipolhuo' imanc' tolapenufle. ");
INSERT INTO chdNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ȽanDios lijoupa lepi'ipa ƚi'Hua lipenic', umme'ma ate'a pe loƚmana'. Umme'ma tipai'itsolhuo' loƚpicuejma' anuli anuli imanc', toƚta'a aimoƚ'econa'me lixcay, ȽanDios tipaxne'molhuo'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mipalaic'ola' lan xanuc' Pedro y Juan jiƚpe icuaitsa lixanuc' cal cuecaj ca'ailli', jouc'a ƚincuxepa capaluc' xoute', jouc'a lan xanuc' saduceo. ");
INSERT INTO chdNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ixinim'mola' Pedro y Juan timuc'iyaleyi, icuej'me iƚne micuayi: “Al ƚinca timaf'ina'me lamizhua; joupa imaf'inapa Jesús.” Aiquetenƚcocola' iƚe lonespa Pedro y Juan. ");
INSERT INTO chdNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","I'noƚim'mola', i'nicontsola' lacarza, timajntsa jiƚpe iƚe lipuqui'. Joupa if'acoƚaipa. Ticuayi: “Mouqui lipa'a'mola'. Aƚcuxecotola'.” ");
INSERT INTO chdNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Axpela' lan xanuc' noquimf'epá linespa Pedro y Juan i'huaiyijmpá Jesús. Ixpe'mola' lapimaye. Joupa i'i'ma to amaquej mil, ma le'a axanuc'. Timana' jouc'a lacaƚ'no'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Li'ipa quitine efot'ƚe'moƚtsi jiƚpe Jerusalén iƚne lincuxepá lan xanuc' jouc'a lan tsilaj xanuc' noxpijpá lataiqui', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jiƚpe icuaitsa cal cuecaj ca'ailli' Anás, jouc'a Caifás, Juan, Alejandro y locuenaye lixanuc' cal cuecaj ca'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Icuxem'mola' lilepaluc' tilecontsola' Pedro y Juan. Icuai'entsola', ecaxum'mola' petsi lefot'ƚeyoƚtsi. Timinnila': ―Imanc' oƚsaƚ'mepá cal coxo. ¿Naitsi lepi'ipolhuo' coƚmane? ¿Te cuftine iƚque? ");
INSERT INTO chdNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro ixim'ma cal Espíritu Santo ticuxe lipicuejma'. Timila': ―Imanc' cunc'incuxepá jouc'a imanc' noƚspijpá lataiqui', ");
INSERT INTO chdNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","itsiya licuis'enga', aƚminga': ¿Te coƚtoc'icopa cal coxo? ¿Te qui'ipa joupa ixaƚconapa? ");
INSERT INTO chdNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Cu'i'molhuo' li'ipa. Ti'iƚa' coƚsina' jahuay imanc' jouc'a jahuay laƚf'as xanuc' Israel. Illanc' aƚjoc'i'me Jesucristo, ƚas Nazaret, ma' iƚque Jesús imanc' olapaƚts'ijmpá lancruz, ȽanDios imaf'i'inapa ipa'anapa pe lomana' lamizhua. Cacua: Aƚjoc'ipá iƚque. Toƚta'a ixaƚconapa iƚca'a cal xans fa'a tecaxu. Tolahuelojnyi, ailopa'a quicuana. ");
INSERT INTO chdNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Maƚque Jesús copa'a “… ƚapic ƚetets'impa nolanc'epá lajut'ƚ”. Imanc' moƚƚanc'eyi lajut'ƚ aicoƚshuico'me. Itsiya “… joupa i'ipa xonca ƚaicuicoya, iƚque ƚapic xonca tilanc'e ƚaitaƚ, aimecangeya lajut'ƚ”. ");
INSERT INTO chdNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ailopa'a cocuena ƚalunƚu'eyaconga'. Jifa'a li'a ƚamats' ni petsi lomana' lan xanuc', ja'ni tijoc'iƚe Jesús, tinescoƚe lipuftine, tunƚul'me. Ocuena aimi'iya munƚu'eyacola'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iƚne noquimf'epá lonespa Pedro y Juan ixinim'mola' aimixpailiquila', ticuayi: “Iƚne ni naitsi xanuc'. Aiquiƚsuec'. Iƚsina' aƚtalai'e'enga'. ¿Te qui'ipola'?” Ticuayi: “Iƚne iyejmalepá Jesús”. ");
INSERT INTO chdNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ailopa'a quimicona'mola'. Ixim'me cal coxo jouc'a Pedro y Juan tecaxoƚanna. Iƚque joupa ixalconapa. ");
INSERT INTO chdNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ummem'mola' ƚuna. Ipalaic'o'moƚtsi ts'iƚpenic'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ticuayi: ―¿Te caƚ'eyacu? ¿Te caƚmiyacola' iƚne lan xanuc'? Jahuay nomana' fa'a liƚya' Jerusalén joupa iƚsina' juaiconapa acueca' li'epa. Aimi'iya maƚnesyacu: A'ij ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma le'a aƚcuxe'e'mola', aƚmi'mola': “Aimoƚpalaicocona'me Jesús. Aimoƚnesco'me lipuftine.” Toƚta'a lan xanuc' nomana' ocuenaye quiƚeloƚya' aimicuejyacu li'epa iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ijoc'im'mola' Pedro y Juan titsuflaiconanca. Timinnila': ―Aimoƚpalaicocona'me Jesús. Aimoƚmuc'iconayale'me litaiqui'. Aimoƚnescona'me lipuftine. ");
INSERT INTO chdNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro y Juan italai'e'me, timinnila': ―¿Te coƚcuayacu imanc'? ¿Te ts'ipic'a ȽanDios? ¿Ja'ni lihuejco'molhuo' imanc' o lihuejco'me ȽanDios? ");
INSERT INTO chdNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Illanc' aimi'iya maƚtaƚi'eyacoƚtsi laƚco. Iƚe laƚsimpa, laƚcuejpa, aluya'a'me, alu'i'mola' lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Icuxe'econam'mola' Pedro y Juan. Timinnila': ―Ja'ni ti'hua toƚpalaicoyi Jesús aƚteƚ'mi'molhuo'. Tonƚenƚe. Aimi'iya miteƚ'minyacola'. Jahuay lan xanuc' iximpá acueca' iƚe li'ipa, tix'najtsi'iyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Cal xans ƚixaƚconapa a'ij camijcano, joupa ixhuaita oquej nuxans y xonca ƚemats'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Joupa ux'masquinampola' Pedro y Juan ipailinanca, icuaitsa pe lomana' liƚpimaye. Uya'a'me linespa lixanuc' cal cuecaj ca'ailli' jouc'a lan tsilaj xanuc' noxpijpá lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Licuej'me toƚta'a jahuay iƚniya lapimaye ipango'me ijoc'i'me ȽanDios, timiyi: ―MaƚPoujna, illanc' oxanuc'. Ima' olanc'epa lema'a, olanc'epa li'a ƚamats', olanc'epa ƚaja, olanc'epola' jahuay lomana'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ƚaƚtatahuelo David joupa lu'iponga' lofnespa ima' manDios. Micuxe cal Espíritu Santo lipicuejma' David, iƚque ticua: Lan xanuc', iƚne pe aimimetsaicoyi ȽanDios, ixtuc'o'moƚtsi, ixpic'epa ti'e'me nixpiya. ");
INSERT INTO chdNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Lan rey, iƚne nocuxepá jifa'a li'a ƚamats', joupa itsolinamma, tixtuleyi. Nocuxepola' lan xanuc' efot'ƚepoƚtsi anuli, tifuli'i'me ȽanDios, tifuli'i'me cal Cristo, iƚque ƚummepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ma' aƚinca toƚta'a li'ipa jifa'a liƚya'. Efot'ƚepoƚtsi cal rey Herodes, jouc'a Poncio Pilato jouc'a lipiƚya' xanuc', jouc'a laƚxanuc' iƚne ixanuc' Israel. Iƚniya jahuay ixtuc'o'me cal Paxi ƚo'Hua Jesús, iƚque no'epa lopenic' lomepi'ipa, iƚque ƚo'Huijf'epa ima'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iƚniya naixtulepá tocomma to quiƚtuca' tixpic'eyi lo'eyacu. A'i quiƚtuca' mixpic'eyi, ma' ima' ocuxe'e'mola' lo'epa, ima' joupa oxpic'epa lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","’Ima' maƚPoujna, itsiya aƚsa'huehuo' aƚtoc'itsonga'. Toquimf'etsola' nalixtuc'oponga', iƚne aƚminga' cataiqui', illanc' oxanuc', ima' malanDios. MaƚPoujna, lapi'itsonga' caƚpujfxi aimaƚspailij'monga', ti'hua luya'a'me lotaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Illanc' aƚnescocona'me Jesús lipuftine, iƚque cal Paxi ƚo'Hua ni'epa lopenic' lomepi'ipa. Ma' aƚnescoƚe iƚque lipuftine, ima' ti'huaƚa' lomane, toxaƚ'metsola' lafcualƚay, tomuc'itsola' lan xanuc' al cueca' lof'epa, to'eƚa' to aimi'iya mi'eyacu lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lijoupa lijoc'ipa ȽanDios ixim'me tifenna lajut'ƚ pe lafoƚyomma. Lapimaye nomana' jiƚpe cal Espíritu Santo icuxe'mola' liƚpicuejma' jahuay iƚniya. Lijou'ma aiquiƚsina' caxpaiqui'. Ti'hua tu'iyaleyi litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jahuay iƚniya no'huaiyijmpá Jesús ti'e'eyoƚtsi capic'a. Ailopa'a nonesya: “Iƚe ai'huexi ma' iya' caituca'”. Jahuay ticuayi: “Maipima iƚta'a ƚai'huexi jouc'a o'huexi”. ");
INSERT INTO chdNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Lan apóstole ti'hua tuya'ayi: “Aƚsimpá ƚaƚPoujna Jesús joupa imaf'inapa, ipanamma pe lomana' lamizhua”. A'i ma le'a micuayi, jouc'a ti'eyi al cueca'. ȽanDios juaiconapa itoc'i'mola' jahuay iƚniya lapimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Iƚne no'huaiyijmpá Jesús aimehue'ela', ni' anuli. Lapimaye ts'iƚ'hueca, ja'ni amats' o ajut'ƚ, ticujyi. Al tomí lolijpa ti'hua'ayi pe lomana' lan apóstole. ");
INSERT INTO chdNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Teto'ennila' jiƚpe liƚ'mitsi' iƚniya. Iƚe al tomí teca'nennila' lapimaye pe aiquiƚ'hueca. ");
INSERT INTO chdNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tipa'a jiƚpe anuli ƚapima cuftine José. Lan apóstole ecui'i'me Bernabé. Iƚe laftine tuhuaƚquemma: Ƚaixoc'ipola' quileta lipimaye. Iƚque qui'huayomma ƚamats' Chipre. Cal te'a qui'ahuelo aLeví. ");
INSERT INTO chdNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabé icuj'ma anuli ƚemats', itaic' al tomí lulijpa. Eto'e'mola' liƚ'mitsi' lan apóstole. ");
INSERT INTO chdNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jiƚpe pe lomana' lapimaye tipa'a anuli cal xans cuftine Ananías. Jouc'a ƚipeno Safira icuj'me ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Al tomí lulijpa Ananías ipa'a'ma, lipanenni i'hua'a'ma, eto'etsola' liƚ'mitsi' lan apóstole. Ticuanƚe jahuay itaipa al tomí, a'ij ƚinca. Ƚipeno ixina' li'epa ƚipe'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro timí: ―CumAnanías, ¿te comepi'icopa lane ƚonta'a Satanás? Iƚque icuxepo' jiƚpe lopicuejma'. Oxpic'epa tofel'mi'ma cal Espíritu Santo. Omiƚonc'epa lomulijpa al tomí. ");
INSERT INTO chdNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Iƚque ƚomemats' ai'a tocuj'ma, ¿ja'ni ima' cotuca' aimoxpic'e te lof'e'eya? Lijoupa locujpa, al tomí lomulijpa, ¿te aico'huexi? Ima' cotuca' oxpic'epa aƚfel'mitsonga'. Metets'ipa ȽanDios, a'i malatets'inga' illanc' ninc'ixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Licuej'ma iƚe lataiqui' Ananías ecangenni ƚamats', ima'ma. Licuej'me lan xanuc' toƚta'a li'ipa jahuay ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lamijcanó itsolinca, iju'eco'me asábana licuerpo Ananías, itai'me emitsa. ");
INSERT INTO chdNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Uyai'ma afanej hora. Icuaiyunni ƚipeno ƚamizhua Ananías. Iƚque aiquixina' iƚe li'ipa ƚipe'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro icuis'e'ma, timi: ―Alu'iƚa'. ¿Te aƚinca toƚta'a i'najtse'empolhuo' loƚcujpa ƚolamats'? Timi: ―Toƚta'a aƚ'najtse'emponga'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro timi: ―Imanc' loquexi' oƚnefopá olahuaipá cal Espíritu Santo. Toquimf'eƚa'. Icuaicona'me lamijcanó nemihuo'me ƚope'ailli'. Titsolof'que liƚ'mitsi'. Joupa icuai'me ƚunaj puerta. Tileco'mo' ima'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aiquicoƚ'ma. Ƚaca'no' ecanghuaitsi imac' jiƚpe li'mitsi' Pedro. Itsuflai'me lamijcanó ixim'me joupa imanapa. Itai'me emitsa jiƚpiya lemi'e'huo'me ƚipe'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lapimaye, iƚne lefot'ƚepola' ȽanDios, jouc'a jahuay lan xanuc', licuej'me iƚe li'ipa ixpailij'mola' juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Lan xanuc' nomana' jiƚpiya ixim'me axpe' acueca' lo'epa lan apóstole, ixinim'mola' mi'eyi to lo'eya ȽanDios. Jahuay iƚne lan apóstole tefot'ƚeyoƚtsi pe lopa'a al cuecaj xoute', jiƚpe ƚinujnca cuftine Ƚipinujnca Salomón. ");
INSERT INTO chdNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Locuenaye aiqui'onƚila' to iƚniya lan apóstole, tixpailiquila'. Lan xanuc' ticuayi: “Acueca' lo'epa, acueca' ac'a liƚpicuejma' iƚniya”. ");
INSERT INTO chdNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Toƚta'a xonca axpela' i'huaiyijm'me ƚaƚPoujna. Ixpe'mola' axanuc' acaƚ'no'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ipa'a'me lilefcualƚay lonaf'coƚanna liƚhualfa o ƚiƚhuijm‑ma'. Ipo'nom'mola' lema cane, iƚ'huaijma tuyaiƚa' Pedro. Ja'ni tixingufcoƚe ma le'a lipunxahua tixaƚcona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Juaiconapa axpela' lan xanuc' quiyouyomma ƚiƚeloƚya' lomana' huejnca Jerusalén tiƚcuai'em'mola' lilefcualƚay. Jouc'a tiƚcuai'em'mola' locuenaye laxtafpola', tipa'antsola' lontahue litsuflaipá. Jahuay ixaƚcona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ixtulenca cal cuecaj ca'ailli' jouc'a liƚejmale, iƚne lan saduceo. Juaiconapa ti'eyi laic'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Umme'me lilepaluc'. Iƚne i'noƚ'me lan apóstole, I'nico'me lacarza. ");
INSERT INTO chdNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Iƚe lipuqui' icuaiyunni lacarza anuli ƚapaluc quema'a ƚummepa ƚaƚPoujna. Exi'e'ma ƚipuertá lacarza, ipa'ana'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Timila': ―Tonƚeƚe al cuecaj xoute'. Tolacaxoƚtsa jiƚpiya. Toƚpalaic'otola' lan xanuc'. Tolu'itola' te ts'i'ic' al ts'e capajnya, te ts'i'ic' mepenufyacu. ");
INSERT INTO chdNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lijoupa licuej'me toƚta'a, iye'me. Icuaitsa al cuecaj xoute'. Joupa tiƚic'e itsuflai'me jiƚpe. Ipango'me imuc'iyalecona'me lan xanuc'. Cal cuecaj ca'ailli' jouc'a liƚejmale icuaitsa pe loxpijyopa cataiqui'. Ijoc'im'mola' jahuay lan tsilaj xanuc' Israel, iƚne noxpijpá lataiqui', tefot'ƚetsoƚtsi. Lijou'ma ummem'mola' lapaluc' tiyeƚe lacarza. Timinnila': ―Toƚƚecotsola' ticuaiyunca fa'a pe laƚmana' iƚne lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lapaluc' icuaitsa lacarza. Ailomana' jiƚpiya lan apóstole. Ipailinanca, uya'atsa. ");
INSERT INTO chdNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Timiyi: ―Laƚcuaita illanc' lacarza eti'iya al c'a. No'epá cuenna tecaxoƚanna ƚunaj puerta. Alaxi'epá cal puertá nij naitsi nopa'a. ");
INSERT INTO chdNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ƚincuxepa capaluc' al cuecaj xoute', jouc'a cal cuecaj ca'ailli', jouc'a lixanuc' cal cuecaj ca'ailli' iquimf'e'me lonespa lapaluc', icua'me: ―Itsiya iƚe li'ipa, ¿te cocula'aya? ¿Te xonca co'iya? ");
INSERT INTO chdNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Minesyi toƚta'a icuaitsi anuli cal xans, timila': ―¡Toƚsinƚe! Iƚne lan xanuc' imanc' loƚ'nicopola' lacarza, jipu'hua al xoute' tecaxoƚanna, timuc'iyaleyi. ");
INSERT INTO chdNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ƚincuxepa lapaluc' al cuecaj xoute' jouc'a lepaluc' iye'me tilecontsola' lan apóstole. Mane ilecontsola', ailopa'a qui'e'empola'. Iƚne lin‑naihuehuale tixpailiquila'. Ticuayi: “¿Te caƚ'e'eyaconga' lan xanuc'? Ja'ni lixtuc'o'monga', aƚma'aco'monga' apic.” ");
INSERT INTO chdNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Icuaiyocontsa pe lefoƚya petsi loxpijyopa cataiqui'. Ecaxum'mola' jiƚpiya. Cal cuecaj ca'ailli' ipango'ma icuis'e'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Timila': ―Illanc' joupa aƚsc'ai'ipolhuo', aƚcuxe'epolhuo', aƚmipolhuo': “Aimoƚpalaicocona'me Jesús. Aimoƚnescocona'me lipuftine.” Itsiya, ¿te conƚ'epa? Joupa oƚ'nicopá loƚtaiqui' liƚpicuejma' jahuay lan xanuc' nomana' fa'a Jerusalén. Imanc' aƚtac'huinga' cajunac'. Toƚcuayi illanc' aƚma'apá iƚque cal xans Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro jouc'a locuenaye lan apóstole italai'e'e'me, timinnila': ―Ja'ni ȽanDios jouc'a lan xanuc' aƚcuxenga', ticuicomma lihuejcoƚe ȽanDios, a'i lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ȽanDios, ƚilenDios laƚtatahueló, imaf'i'inapa Jesús, ipa'anapa pe lomana' lamizhua. Maƚque Jesús imanc' olapaƚts'ijmpá al 'ec, oƚma'apá. ");
INSERT INTO chdNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Imanc' ixanuc' Israel, maƚque ȽanDios ipic'a tepi'itsolhuo' loƚpicuejma' toƚsuej'menanca, ipic'a timenc'e'eco'molhuo' loƚjunac'. Toƚiya i'epa al cueca'. Imaf'i'inapa Jesús, if'ac'enapa, i'e'epa ƚaƚPincuxepa, Ƚalunƚu'eponga'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Illanc' aƚsina' al ƚinca iƚe laƚmipolhuo'. Toƚiya luya'ayi, lu'ilhuo'. Ma' anuli loya'apa cal Espíritu Santo. Iƚque cal Espíritu ȽanDios tepi'ila' jahuay naihuejcopá. ");
INSERT INTO chdNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iƚne lan xanuc' noquimf'epá ixtulenca juaiconapa. Coƚa' tima'antsola' lan apóstole. ");
INSERT INTO chdNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jiƚpiya lefoƚya tipa'a anuli cal xans fariseo cuftine Gamaliel. Iƚque cal xans omxi, timuc'iyale locuxepa ȽanDios. Jahuay lan xanuc' ixim'me ac'a xans, ticuec'eyi. Iƚque ecax'ma, timila': ―Tolipa'atsola' iƚne lan xanuc'. Illanc' aƚpalaic'o'moƚtsi caƚtuca'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","(Ipa'am'mola' lan apóstole.) Gamaliel ipalaic'o'mola' iƚne lan xanuc' lefoƚya, timila': ―Cunc'aipimaye, cunc'aif'as xanuc' Israel, tonƚ'eƚe cuenna. Toƚspic'eƚe al c'a lonƚ'e'eyacola' iƚne lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Li'ipa cal xans Teudas ehuoc'huai'mola' lincuxepá. Ticua: “Iya' nincuecaj xans. Lihuejla'.” To amalpuj maxnu lan xanuc' ihuej'me. Lijou'ma ima'am'me. Ts'ilihuequi inulai'me nulemma. ");
INSERT INTO chdNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","’Lijou'ma, iƚniya ƚitiné miniƚingaispola' liƚpuftine lan xanuc', ocuenaj cal xans ehuoc'huaicona'mola' lincuxepá. Iƚque cuftine Judas ƚas Galilea. Iƚque jouc'a efot'ƚe'mola' axpela' lan xanuc'. Ifule'me. Judas jouc'a ima'am'me. Ts'ilihuequi inulai'me. ");
INSERT INTO chdNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","’Itsiya camilhuo': Tolanajtsoƚtsi iƚne lan xanuc'. Tolux'masnatsola' tiyenƚe. Iƚniya locuapa, lo'epa, ja'ni tipa'acoyi quiƚtuca' liƚpicuejma', aimi'iya, tejac'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ja'ni ȽanDios ticuxela', imanc' aimi'iya munlulijyacola', mane tolixtuc'o'me ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ihuejco'me limipola' Gamaliel. Ijoc'iconam'mola' lan apóstole titsuflaiconanca. Itsimaf'quim'mola' liƚspula'. Timinnila': ―Aimoƚnescona'me: “Jesús alapi'iponga' laƚmane lu'i'molhuo' iƚe li'ipa”. Ux'masquinam'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lan apóstole ipalunca jiƚpe lefoƚya. Tixoqui quileta. Ticuayi: “ȽanDios tetenƚcocojma maƚnesco'me Jesús. Toƚiya aƚteƚcoyi.” ");
INSERT INTO chdNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Itine itine ti'hua timuc'iyaleyi jiƚpe al cuecaj xoute' jouc'a ƚajut'ƚi. Ti'hua tuya'ayi: “Iƚque Jesús aCristo, ƚi'Huijf'epa ȽanDios”. Aiquixoquila'. ");
INSERT INTO chdNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Iƚne ƚitiné mixpela' ts'ilihuequi Jesús timana' lapimaye ixtuc'o'moƚtsi. Iƚne nopalaipá liƚtaiqui' griego ixtuc'om'mola' locuenaye lapimaye ahebreo, iƚne ocuena liƚtaiqui' lopalaipa. Ticuayi: ―Imanc' loƚpotsateya itine itine tepi'innila' ƚotejacu. Illanc' naƚpalaicopá griego aimepi'innila' laƚpotsateya. ");
INSERT INTO chdNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Limbamaj coquexi' lan apóstole ijoc'im'mola' tefot'ƚetsoƚtsi jahuay ts'ilihuequi Jesús. Timinnila': ―Illanc' aƚmuc'iyaleyi, lu'iyaleyi litaiqui' ȽanDios. ¿Te aƚpo'no'me iƚta'a laƚpenic'? ¿Aƚtes'mi'mola' lan xanuc'? A'i. Aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Imanc' illanc' ninc'apimaye. Ticuicomma acaitsi lapimaye, timetsaicontsola' lan c'a xanuc', ticuxetsola' cal Espíritu Santo liƚpicuejma', ts'iƚsina' tixpic'e'me al c'a. Maƚniya toƚ'huijf'etsola' imanc'. ");
INSERT INTO chdNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Illanc' ti'hua aƚ'econa'me ma to maƚ'eyi. Aƚjoc'i'me ȽanDios, aƚmuc'iyale'me litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jahuay lefoƚya jiƚpe etenƚcoco'mola' iƚe lataiqui'. I'huijf'em'mola' Esteban, Felipe, Prócoro, Nicanor, Timón, Parmenas jouc'a Nicolás. Iƚque Esteban jahuay ƚunxajma' ti'huaiyinge Jesús. Ma le'a cal Espíritu Santo ticuxe lipicuejma'. Nicolás agriego, ƚas Antioquía, ihuejpa lilihuequi lan xanuc' judío. Itsiya ti'huaiyinge Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Iƚne lan caitsi ilecom'mola' pe lomana' lan apóstole. Lan apóstole ijoc'i'me ȽanDios, ipo'nof'i'me liƚmane ƚiƚjuac lan caitsi capimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lijou'ma xonca aculi' i'hua'ma litaiqui' ȽanDios. Liƚya' Jerusalén xonca tixpela' juaiconapa iƚne ts'ilihuequi Jesús. Jiƚpe axpela' la'aillí tihuejcoyi litaiqui' Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ȽanDios juaiconapa titoc'i Esteban, ipaxnepa, epi'ipa limane ti'eƚa' al cueca' to aimi'iya mi'eyacu lan xanuc'. I'e'ma to lo'eya ȽanDios. Toƚta'a timuc'iyale. ");
INSERT INTO chdNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lan xanuc' judío, iƚne pe lafoƚyomma lajut'ƚ cuftine Lilejut'ƚ Lo'nampola' joupa Ux'masquinnapola', ixtuc'o'me Esteban. Iƚne naixtulepá quiyouyomma liƚya' Cirene jouc'a liƚya' Alejandría, jouc'a ƚamats' Cilicia jouc'a ƚamats' Asia. Iƚne ipango'me ifuli'i'moƚtsi cataiqui' Esteban. ");
INSERT INTO chdNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Esteban imuj'moxi acueca' lipicuejma'. Tipalay ma le'a lomipa cal Espíritu Santo. Ulij'mola'. Iƚne ailopa'a cotalai'ecoyacu. ");
INSERT INTO chdNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ixtulenca xonca. I'najtsem'mola' lan xanuc' ticufle Esteban. Tuya'atsa: “Iƚca'a cal xans tetets'i' Moisés, jouc'a tetets'i' ȽanDios. Aƚcuejpá lonespa.” ");
INSERT INTO chdNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Toƚta'a tu'innila' lan xanuc' jouc'a lan tsilaj xanuc' noxpijpá lataiqui', jouc'a lomxiye nomuc'iyalepá locuxepa ȽanDios. Jahuay iƚniya ixtuc'o'me Esteban. Icuaitsa pe lopa'a, i'noƚ'me, i'hua'a'me pe lafoƚyomma lan tsilaj xanuc' noxpijpá lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jiƚpiya lefoƚya icuai'entsola' nofelƚaiquepá, iƚniya icuf'me Esteban. Ticuayi: ―Iƚca'a cal xans ti'hua tetets'i' iƚe al Paxi Cajut'ƚ, jouc'a tetets'i' locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Illanc' aƚcuejpá lonespa. Ticua: “Jesús ƚas Nazaret teteƚ'ma iƚe al xoute'”. Jouc'a ticua: “Jesús tipai'i'ma laƚ'ejma', aimaƚ'econa'me to maƚ'eyi”. Aƚcuayi: Illanc' aimi'iya malapenufyacu toƚta'a. Itsiya lihuejyi litaiqui' Moisés, iƚque aƚcuxenga'. ");
INSERT INTO chdNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lan xanuc' nocutsoƚanna jiƚpiya lefoƚya juaiconapa tehuelojnyi Esteban. Tixinyi li'a ti'onƚcospa to li'a anuli ƚapaluc quema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Cal cuecaj ca'ailli' icuis'e'ma, timi Esteban: ―¿Te al ƚinca locuapa iƚniya? ");
INSERT INTO chdNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban timila': ―Cunc'aipimaye, imanc' aƚtatá laƚcuxenga', aƚquimf'eƚa' laifmiyacolhuo'. ’Mipa'a ƚaƚtatahuelo Abraham ƚamats' Mesopotamia, ai'a ti'huana'ma ƚamats' Harán, cal Cuecaj CanDios, iƚque Nopa'a lema'a, imuj'moxi. ");
INSERT INTO chdNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Timi: “Topo'noƚa' ƚomemats', topo'notsola' loxanuc'. To'huanni. Camuc'ito' ocuena camats', jiƚpe topajnta.” ");
INSERT INTO chdNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham ipanni ƚamats' Mesopotamia pe lomana' lan xanuc' cuftine lan caldeo. I'huana'ma ipajntsi ƚamats' cuftine Harán. Quimaf'i' qui'ailli' jiƚpe imanenca. Lijou'ma limana'ma qui'ailli' ȽanDios ummepa i'huanni jifa'a ƚamats' pe laƚmana' itsiya. ");
INSERT INTO chdNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","’Fa'a ȽanDios aiquepi'i' quemats', qui'huexi ni mixpiqueya anuli li'mis. Icupa cataiqui', timi: “Capi'i'mo' iƚca'a ƚamats'. Ti'i'mo' co'huexi. Tijouƚa' ti'i'ma qui'huexi ƚo'hua.” Iƚe litine Abraham ailopa'a qui'hua. ");
INSERT INTO chdNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jouc'a ȽanDios timi: “Timajnlita lonietó. Iƚne loxanuc' tiye'me ocuena camats' a'i quilemats'. Jiƚpiya timajnta. Lan xanuc' ti'e'moƚtsi quiƚpoujnalá. Ticuxem'mola' juaiconapa. Ti'e'em'mola' quixcay. Amalpuj maxnu camats' ti'e'em'mola' toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tijouƚa' lan malpuj maxnu camats' iya' cateƚ'mi'mola' lan xanuc', iƚne li'epoƚtsi iƚpoujnalá loxanuc'. Iƚniya loxanuc' tipalnacu jiƚpiya. Tipailinacu fa'a. Ma fa'a alaxc'onƚingaina'ma.” ");
INSERT INTO chdNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Lijou'ma ȽanDios ipo'no'ipa cataiqui' Abraham. Icuxe'e'ma ti'exoxi circuncidar. Lijoupa li'epoxi circuncidar Abraham iƚepa qui'hua Isaac. Ipajntsi Isaac, lixhuaitsi apaico quitine, Abraham i'e'ma circuncidar. Isaac i'i'ma qui'ailli' Jacob. Jacob i'i'ma quiƚ'ailli' iƚne limbamaj coquexi' laƚtatahueló. ");
INSERT INTO chdNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Iƚne laƚtatahueló i'e'me laic' laquiƚpepo cuftine José. Icuc'im'mola' José lan xanuc' cotsepa ƚamats' Egipto. Iƚne ileco'me José. ȽanDios aiqueca'nicojma. ");
INSERT INTO chdNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Unƚu'e'ma jahuay lateƚcoya. Titoc'i, epi'ipa acuecaj quipicuejma'. Toƚta'a Faraón, iƚque incuxepa jiƚpe ƚamats' Egipto, tetenƚcocojma li'ejma' José. Ifac'e'ma, epi'ipa lipenic' ticuxetsola' lan xanuc' nomana' ƚamats' Egipto. Jouc'a ticuxela' jahuay nomana' lejut'ƚ Faraón. ");
INSERT INTO chdNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Lijou'ma i'i'ma cumemma. Lan xanuc' ni petsi ƚamats' Egipto ixingufco'me lumemma. Jouc'a lan xanuc' nomana' ƚamats' Canaán iteƚco'me juaiconapa. Laƚtatahueló nomana' ƚamats' Canaán aiquixim'me cotejacu. ");
INSERT INTO chdNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob, iƚque quiƚ'ailli' laƚtatahueló, icuej'ma tipa'a cal trigo ƚamats' Egipto. Iƚne laƚtatahueló ni anulemma aiquiƚtsec' Egipto. Quiƚ'ailli' ummepola' tiyeƚe. ");
INSERT INTO chdNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iyehuo'me, ipailinanca. Lijou'ma iyecona'me. Licuaiyocontsa ƚamats' Egipto José imuj'moxi lipimaye. Timila': “Iya' ƚacoƚpepo. Iya' ninJosé.” Timi cal rey Faraón: “Iƚniya aipimaye”. ");
INSERT INTO chdNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Timila' lipimaye: “Tonƚeƚe Canaán. Toƚƚecotsola' cai'ailli' Jacob jouc'a laƚxanuc'.” Tixhuaispola' afanej nuxans quimbamaj maque' iƚne lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","’Jacob jouc'a linaxque', iƚne laƚtatahueló, imul'me ƚamats' Egipto. Jiƚpe imanenca. Jiƚpe imayo'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lijou'ma ƚiƚpécaƚ icuai'e'me ƚamats' Siquem. Emunatsa al pu'hua li'napa Abraham. Iƚe al pu'hua lopa'a ƚilemats' lixanuc' cal xans Hamor. Abraham i'najtse'e'mola' atomí, i'napa. ");
INSERT INTO chdNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ti'hua tixhuaispola' ƚitiné ȽanDios ti'e'ma ma to limipa Abraham, tepi'i'mola' laƚtatahueló quilemats'. Mimana' iƚniya ƚamats' Egipto ti'hua ticuef'quila'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jiƚpiya anuli cal ts'e quincuxepa ipango'ma icuxe'ma. Iƚque aiquimetsaijma José. ");
INSERT INTO chdNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ehuepa te co'iya mijou'neyacola' laƚxanuc'. Icuxenai'mola' juaiconapa. Icuxe'e'mola' teca'nicoƚe liƚnaxque' camijcanó, timatsola'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","’Iƚne ƚitiné ipajntsi Moisés. ȽanDios icuaicotsi quipic'a ƚacapími', etenƚcoco'ma. Afanej mut'la itoc'empá lejut'ƚ qui'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Lijou'ma eca'nicom'me. Ƚi'hua cahuats' cal rey Faraón ixim'ma, ipulaf'ma, i'hua'a'ma lejut'ƚ. Itoc'e'ma to qui'hua. ");
INSERT INTO chdNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jiƚpe ƚamats' Egipto timana' lan xanuc' acueca' quiƚsina'. Jahuay liƚsina' iƚniya imuc'i'me Moisés. Toƚta'a Moisés jouc'a imuj'moxi acueca' lipicuejma', ac'a lopalaipa, lo'epa. ");
INSERT INTO chdNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Lixhuaitsi oquej nuxans ƚemats' ipic'a tixintsola' lipimaye, iƚne ixanuc' Israel. ");
INSERT INTO chdNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","I'hua'ma pe lomana' lipimaye. Jiƚpe ixim'ma anuli titeƚma. Anuli cal xans egipcio titeƚ'mi. Moisés i'hua'ma titoc'itsi. Icuanajco'ma ƚipima. Ima'a'ma cal xans egipcio. ");
INSERT INTO chdNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ticua lipicuejma': “Cunƚu'e'mola' laipimaye. Iƚne alimetsaico'ma toƚta'a laipenic' lalapi'ipa ȽanDios.” Lipimaye aiquiƚcueca. ");
INSERT INTO chdNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","’Lihuequi litine tifuleyi oquexi' lipimaye. Icuaitsi Moisés, ticua: “Cananc'otola' iƚne laipimaye. Ti'inƚa' liƚpicuejma'. Canajna'mola'.” Timila': “Cunc'ixanuc', imanc' unc'apimaye. Aimoƚfulecona'me.” ");
INSERT INTO chdNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Iƚque noxcai'epa ƚipima ixtuc'opa Moisés. Ummetsai'ma. Timi: “¿Naitsi ima'? ¿Naitsi nifajpo'? ¿Naitsi nepi'ipo' lopenic'? ¿Te ima' aƚcuxe'monga'? ¿Te ima' aƚjuez? ");
INSERT INTO chdNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tsumjma oma'a'ma cal xans egipcio. ¿Te itsiya aƚma'a'ma iya' jouc'a?” ");
INSERT INTO chdNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Licuej'ma iƚe lataiqui' Moisés inuna'ma, i'hua'ma ƚamats' Madián. Ipajntsi. Jiƚpe limajnlitsa oquexi' linaxque'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Uyai'ma oquej nuxans camats'. Anuli litine tipa'a Moisés ƚimuc'o' ahuejnca ƚijuala cuftine Sinaí, petsi ailopa'a quiƚya' ni xanuc'. Jiƚpe tunaqui anuli luxi quitac. Maƚpiya ƚipaƚ cunga imaxcaitsi anuli ƚapaluc quema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés ixim'ma acueca' iƚe li'ipa. I'hua'ma ehuelojntsi xonca ahuejnca. Icuej'ma ƚaƚPoujna ȽanDios tipalay. ");
INSERT INTO chdNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Timi: “Iya' NanDios, ilenDios lotatahueló. Iya' ilenDios Abraham, Isaac, Jacob.” Licuej'ma toƚta'a Moisés ixpaiconni. Ipango'ma iyu'ma licuerpo. Aimi'iya mehuelojnconaya. ");
INSERT INTO chdNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ȽaƚPoujna ȽanDios timi: “Pe lofmecaxu, jiƚpe apaxi camats'. Taipa'aƚa' ƚoc'ejí. ");
INSERT INTO chdNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Cahuelongila' laixanuc', iƚne nomana' Egipto. Aiximpola' titeƚcoyi. Aiquimf'epola' tija'ayi. Iya' nimumma lema'a. Cunƚu'e'mola' laixanuc'. ¡Totsahuenni! ¡Ƚepá! Cumme'mo', topaiconno, to'huacona'ma ƚamats' Egipto.” ");
INSERT INTO chdNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Maƚque Moisés joupa etets'impá, imimpá: “¿Naitsi ima'? ¿Naitsi nifajpo'? ¿Naitsi nepi'ipo' lopenic'? ¿Te ima' aƚcuxe'monga'? ¿Te ima' aƚjuez?” Iƚe litine limaxcaitsi ƚapaluc quema'a jiƚpe munaqui luxi quitac, ȽanDios ifajpa Moisés, epi'ipa lipenic' ticuxetsola', tunƚu'etsola' lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Maƚque Moisés i'e'ma to aimi'iya mi'eyacu lan xanuc'. Tixinƚe lan xanuc' al cueca' lo'epa ȽanDios. Lijou'ma ipa'ana'mola' lixanuc' ƚamats' Egipto. Licuaitsa Ƚunxali Caja jouc'a i'e'ma acueca', jouc'a pe ailopa'a quiƚya'. Laƚtatahueló icoƚ'mola' oquej nuxans camats' muyalaicoyi jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisés u'i'mola' lixanuc', iƚne lixanuc' Israel, timila': “ȽanDios ƚaƚPoujna tepi'i'molhuo' anuli cal profeta aƚ'onƚcota to iya'. Iƚque oƚpiƚya' xans. Iƚque toƚquimf'e'me.” ");
INSERT INTO chdNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Maƚque Moisés efot'ƚe'mola' laƚtatahueƚó mimana' pe ailopa'a quiƚya'. Jiƚpe ƚijuala Sinaí ƚapaluc quema'a ipalaic'opa Moisés. Moisés ipalaic'opola' laƚtatahueló. Moisés epenufpa limaf'i cataiqui', iƚe litaiqui' ȽanDios. Iniƚpa lapenufle illanc'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Laƚtatahueló etets'ipá Moisés. Aiquilihuejma limipola'. Tiƚ'nujuaispá lilendiosla' lun egipicio. ");
INSERT INTO chdNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Timiyi Aarón: “Aƚƚanc'e'etsonga' calandiosla'. Iƚne aƚ'huaj'me'e'monga'. Iƚque Moisés ƚalipa'ahuo'monga' ƚamats' Egipto itsiya ailopa'a. Aicaƚsina' pe quitsepa. Aicaƚsina' te qui'ipa.” ");
INSERT INTO chdNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iƚne ƚitiné ilanc'e'me anuli ƚa'hua huacax ilanc'eco'me a'oro. Ima'a'me linneja, itsufco'me cal ídolo. Tixoqui quileta. Etenƚcoco'mola' iƚe ƚilendios, iƚque ƚilanc'epa, i'e'ecopa quiƚtuca' liƚmane'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ȽanDios eca'nico'mola'. Ticua: “Najmay texc'onƚingoƚaile lopa'a lema'a, iƚniya lan xamna, cal mut'ƚa, cal 'ora”. Toƚta'a tuya'e' al je'e liniƚpa lam profeta. Jiƚpiya ȽanDios ticua: Imanc' ixanuc' Israel, loquej nuxans camats' moƚmana' jiƚpe ƚamats' petsi ailopa'a quiƚya', moƚtsufcola' linneja loƚma'am'mola' y locuenaye loƚtsufco'me, ¿te ma al ƚinca aƚtsufcopa iya'? ");
INSERT INTO chdNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","A'i. Oƚtaic' anuli ƚolandios cuftine Moloc, jouc'a oƚtaic' ƚixamna ƚocuena ƚolandios cuftine Renfán. Iƚniya lolandiosla' coƚƚanc'ecopola' tolaxc'onƚingaitsola'. Iya' cateƚ'mi'molhuo' toƚta'a loƚ'epa, quipa'a'molhuo' ƚolamats', ca'hua'a'molhuo' ƚamats' Babilonia. ");
INSERT INTO chdNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Mimana' ƚamats' pe ailopa'a quiƚya' laƚtatahueló iƚ'hueca lejut'ƚ ȽanDios lilanc'ecompa ijahua'. Jiƚpe lajut'ƚ tipa'a oquej lapic' liƚtaic' liniƚiya loya'apa locuxepa ȽanDios. Ma toƚta'a ȽanDios icuxe'epa Moisés, timi: “Joupa aimuc'ipo' te ts'i'ic' lajut'ƚ, toƚta'a tolanc'e'ma”. ");
INSERT INTO chdNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Liƚnaxque' laƚtatahueló epenuf'me lajut'ƚ, iƚtaic' icuaiyunca jifa'a ƚalamats', itsuflai'enca. Iƚniya ƚitiné micuxela' Josué ulicale'me lan xanuc' limajmpá fa'a, iƚne pe aiquilimetsaijma ȽanDios. ’Icuaitsi litine cal rey David epenuf'ma lipenic' ma tipa'a iƚe lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ȽanDios etenƚcoco'ma li'ejma' David. Iƚque ixa'hue'ma ȽanDios, enDios Jacob. Timi: “Calanc'e'etso' ocuena comejut'ƚ”. ");
INSERT INTO chdNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","David aiquilanc'e lajut'ƚ. Salomón, iƚque i'hua David, ilanc'epa lejut'ƚ ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","’Tama tipa'a lejut'ƚ, ȽanDios Nopa'a lema'a aimipanga anuli lajut'ƚ lilanc'epa cal xans. Toƚta'a licuapa cal profeta muya'e' lu'ipa ȽanDios, ticua: ");
INSERT INTO chdNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Lema'a ti'onƚcospa to laicuecaj asiento, jiƚpe cacutsuya. Li'a ƚamats' ti'onƚcospa to ƚainitas, jiƚpe lunxajyopa lai'mitsi'. Ticua ȽanDios ƚaƚPoujna: ¿Te caƚƚanc'e'ecoya anuli lajut'ƚ? ¿Te ailopa'a caifnunxac'eya? ");
INSERT INTO chdNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Te ma' iya' a'i cailanc'e jahuay? Toƚta'a timila' Esteban iƚne naixtuc'opá. Lijou'ma timiconala': ");
INSERT INTO chdNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","―Ƚinca imanc' aimaƚcuec'e. Loƚpicuejma' ti'onƚcospa to liƚpicuejma' lan xanuc' pe aiquilimetsaijma ȽanDios. Imanc' aimolihuejcoyi cal Espíritu Santo, tecaxaispolhuo'. Ma to mi'eyi loƚtatahueló toƚta'a lonƚ'epa imanc'. ");
INSERT INTO chdNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Iƚniya loƚtatahueló, ¿ja'ni tipa'a anuli cal profeta pe aiquilihuetsoqui? A'i. Ailopa'a. Loƚtatahueló ima'a'me iƚne nuya'apá ƚocuaicoya cal Ƚijca Xans. Imanc' xonca ixcay onƚ'epá. Li'huamma cal Ƚijca Xans imanc' oƚcupá, oƚma'apá. ");
INSERT INTO chdNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Lataiqui' loya'apa locuxepa ȽanDios, maƚe lataiqui' luya'apa lapaluc' quema'a, imanc' olapenufpá, tijouƚa' aicolihuequi. ");
INSERT INTO chdNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lan xanuc' noquimf'epá litaiqui' Esteban ixtulenca juaiconapa. Ticuayi: “Iƚque aƚcufquinga'”. I'ilc'ma liƚ'ay. ");
INSERT INTO chdNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Cal Espíritu Santo icuxe'ma lipicuejma' Esteban. Iƚque ehuelojm'ma lema'a. Ixim'ma te ts'i'ic' jiƚpe pe lopa'a ȽanDios. Jiƚpe tipa'a Jesús tecaxu al c'a camane ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Esteban ticua: ―¡Toƚsinƚe! Caxina exiya lema'a. Jiƚpe tipa'a cal Xans Ƚiximpa cal profeta pu'hua lema'a. Itsiya aiximpa tecaxu al c'a camane ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lan xanuc' ija'a'me ujfxi, um'mit'ƚe'me liƚmane' liƚs'mats'i'. Ihuo'me, umentsu'me Esteban. ");
INSERT INTO chdNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","I'noƚ'me, i'hua'a'me lema quiƚya'. Ipango'me ecanijm'me capic' tima'aƚe. Linfel'miyale nicufpá Esteban ipa'apá liƚtsamalo, ipo'no'e'epá li'mitsi' anuli ƚamijcano cuftine Saulo. ");
INSERT INTO chdNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mipayi capic' Esteban tijoc'i ȽanDios, timi: ―MaiPoujna Jesús, tapenufla' ƚai'espíritu. ");
INSERT INTO chdNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Exc'onƚquenni, ipalai'ma ujfxi timi: ―MaiPoujna, tama aƚ'e'e quixcay, aimotac'ui'i'mola' lajunac'. Lijou'ma lines'ma toƚta'a imana'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Saulo tipa'a tecaxu jiƚpiya, ticua: “Ne', tima'anƚe Esteban”. Hualca lan xanuc' pe naihuejcopá locuxepa ȽanDios itaina'me licuerpo Esteban, emunatsa. Acueca' juaiconapa liƚpihuotsoqueya. Iƚne ƚitiné ihuetsoquim'mola' juaiconapa lapimaye nomana' Jerusalén, iƚne lefot'ƚepola' ȽanDios. Jahuay ica'ne'moƚtsi, iye'me ni petsi al distrito Judea jouc'a ƚamats' Samaria. Ma le'a lan apóstole imanenca Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo tixtuc'ola' juaiconapa lapimaye. Ti'noƚila', tequifila' lan xanuc' jouc'a lacaƚ'no', ti'nicola' lacarza. ");
INSERT INTO chdNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ni petsi litsepa iƚne lapimaye nica'nepoƚtsi uya'a'me Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe ipanni jiƚpe Jerusalén, i'hua'ma anuli liƚya' ƚamats' Samaria. Jiƚpe uya'a'ma: “Jesús copa'a cal Cristo, ȽanDios ƚi'Huijf'epa”. ");
INSERT INTO chdNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lan xanuc' efot'ƚepoƚtsi iquimf'e'me locuapa Felipe. Ixim'me Felipe mi'ay al cueca' to lo'epa ȽanDios. Jahuay iƚniya ipo'no'me cuenna juaiconapa litaiqui' Felipe. ");
INSERT INTO chdNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Jiƚpe liƚya' ixaƚcona'mola' axpela' lafcualƚay, iƚne litsufai'ila' contahue. Mipalcu lontahue tija'ayi ujfxi. Axpela' luhuaƚqueya lan xanuc' jouc'a lan coxo ixaƚcona'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Toƚta'a juaiconapa ixoj'ma quileta lan xanuc' nomana' jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Maƚpe liƚya' tipa'a anuli cal brujo cuftine Simón. I'epa al cueca'. Tifel'mila' jahuay lan xanuc' nomana' ƚamats' Samaria. Timila': ―Iya' a'i ni naitsi xans. Iya' ninCueca'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jahuay iquimf'e'me, lan xanuc' ts'iƚ'hueca jouc'a lan xanuc' pe aiquiƚ'hueca. Ticuayi: ―Ma ȽanDios, iƚque cal Cuecaj Candios, ƚinca ummepa iƚca'a cal xans. Toƚta'a ti'ay al cueca'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Joupa ixhuaita axpe' mut'ƚa cal brujo ti'hua ti'ay lipixcay xans. Lan xanuc' ixinc'nepá, joupa ifel'mipola', tihuejyi. ");
INSERT INTO chdNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Iƚne nepenufpá litaiqui' Felipe epo'im'mola', lan xanuc' jouc'a lacaƚ'no'. Felipe uya'a'ma Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Tu'ila' te co'iya mitsuflaiyacu pe locuxeyopa ȽanDios. Tu'ila' naitsi Jesús, iƚque cal Cristo. ");
INSERT INTO chdNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón jouc'a epenufpa litaiqui' Felipe, epo'im'me. Lijoupa lepo'impa iyejmale'me Felipe. Iximpa al cueca' lo'epa Felipe, to lo'epa ȽanDios. Liximpa toƚta'a, tocomma tipailo lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Lan apóstole nomana' Jerusalén icuej'me: “Lan xanuc' nomana' ƚamats' Samaria epenufpá litaiqui' ȽanDios”. Ummem'mola' liƚf'as apóstole Pedro y Juan tiyeƚe jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Iye'me, icuaitsa pe lomana' lapimaye nepenufpá litaiqui' ȽanDios. Jiƚpe ijoc'i'me ȽanDios, ixahue'e'me tepi'itsola' cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Iƚne lun Samaria joupa inespá: “Jesús aƚPoujna”. Joupa epo'impola'. Aiquilepenufi cal Espíritu Santo. Iƚque aiquimuya pe lomana'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lan apóstole lijoupa lijoc'ipa ȽanDios ipo'nof'i'me liƚmane ƚiƚjuac iƚniya lun Samaria. Iƚne epenuf'me cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón iximpola' li'epa lan apóstole, iximpola' lipo'nof'ipa liƚmane ƚiƚjuac iƚniya lapimaye, iximpola' epenufpá cal Espíritu Santo. Liximpa toƚta'a li'ipa, icufi'mola' quiƚtomí lan apóstole, ");
INSERT INTO chdNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","timila': ―Capi'i'molhuo' coƚtomí. Aipic'a ca'eƚa' ma to lonƚ'epa imanc'. Lapi'iƚa' caimane. Tijouƚa' ja'ni capo'nof'iƚa' laimane anuli cal xans, iƚque tepi'im'me cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro timi: ―Ima' tecanitso' jouc'a lotomí. Tocua to'naco'ma iƚe locupa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ima' aimi'iya motsufaiya laƚpenic'. Ailopa'a capi'iyaco' ȽanDios. Iƚque timetsaicohuo' a'ij ƚijca lopicuejma'. Aimetenƚma. ");
INSERT INTO chdNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ima' mixcay xans. Toxhuej'menanni. Tojoc'iƚa' ȽanDios. Toxa'hueƚa' ja'ni ti'i'ma tiƚonc'e'e'mo' lojunac', timenc'e'ecotso' lofcuapa jiƚpe lopicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Iya' quimetsaicohuo' lo'ejma'. Ima' pangay to'ehuale laic'. Lixcay lopicuejma' joupa ifi'epo'. Aimi'iya mo'eya al c'a. ");
INSERT INTO chdNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón italai'e'ma, timi: ―Imanc' toƚjoc'iƚe ƚaƚPoujna, toƚsahue'eƚe aimaƚ'i'ma to laƚmipa. ");
INSERT INTO chdNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jiƚpe liƚya' lan apóstole uya'a'me te ts'i'ic' liximpa, te ts'i'ic' licuejpa mipa'a Jesús fa'a li'a ƚamats'. Uya'a'me litaiqui' ƚaƚPoujna. Lijou'ma ipailinamma, tiyeyi lane Jerusalén. Miyeyi lane titsulfoƚaiyi axpela' ƚiƚpiƚeloƚya' lun samaritano, tuya'ayi Lataiqui', iƚe loya'apa al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pe lopa'a Felipe imaxcaitsi anuli ƚepaluc ƚaƚPoujna, timi: ―Totsahuenni. To'huaƚa' al sur, iƚe lane co'huayomma Jerusalén lotsepa Gaza. Lane pangay quimuc'o'. Ailopa'a quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe itsahuenni, ipanni. I'hua'ma ma to limipa ƚapaluc quema'a. Maƚe lane ti'hua anuli cal xans ƚas Etiopía. Iƚque ts'ipenic', ticuxe jahuay ƚi'huexi ƚipoujna. Iƚque ƚipoujna ƚincuxepa aca'no' cuftine Candace, ticuxe ƚamats' Etiopía. Cal xans joupa itsehuo'ma al cueca' xoute' lopa'a Jerusalén, jiƚpe exc'onƚingaihuo'ma ȽanDios. Itsiya ipainamma cotsenapa, i'huanapa Etiopía. ");
INSERT INTO chdNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ticusc'o licarro, tixhue liniƚpa lije'e cal profeta Isaías. ");
INSERT INTO chdNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Cal Espíritu Santo ipalaic'o'ma Felipe, timi: ―To'huaƚa' pe lo'huapa al carro. Aimanaj'moxi. ");
INSERT INTO chdNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe inu'ma, i'huajcotsi al carro. Icuej'ma cal xans tixhue liniƚpa cal profeta Isaías. Timi: ―Iƚe al je'e lofxhuepa, ¿te tocuec'e? ");
INSERT INTO chdNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Timi: ―¿Te co'iya cacuec'eya? Ailopa'a naƚmuc'iya. Ixa'hue'ma Felipe tif'ajla' al carro, ticutsoƚaiƚe huejnca. ");
INSERT INTO chdNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Al Paxi Liniƚingiya loxhuepa ticua: Ma to milecom'me anuli ƚa'hua moƚ tima'anna, ma toƚta'a ilecom'me iƚque cal xans. Metec'em'me ƚipimi cal moƚ, iƚque aimija'e', iƚque cal xans jouc'a aiquija'e'. Ailopa'a quimipola' iƚne liteƚ'mi'me. ");
INSERT INTO chdNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Etets'i'me, ailopa'a notoc'iya. ¿Ja'ni jifa'a li'a ƚamats' tipa'a anuli qui'hua? A'i, ailopa'a. Nulemma etec'oyenni lipitine. ");
INSERT INTO chdNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ts'ipenic' icuis'e'ma Felipe, timi: ―Alu'iƚa'. ¿Naitsi conescopa cal profeta? ¿Te tipalaicoyoxi quituca' o tipalaijma ocuena? ");
INSERT INTO chdNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe italai'e'ma, uhuaƚ'ma iƚe lataiqui'. Lijou'ma xonca u'i'ma Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Inesco'ma Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mipalaiyi ti'hua tinu al carro. Icuaitsa pe lopa'a laja'. Ts'ipenic' timi Felipe: ―Toxinƚa'. Jifa'a tipa'a laja'. Aipic'a ima' lapo'iƚa'. ¿Te ti'i'ma? ");
INSERT INTO chdNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe timi: ―Ja'ni jahuay ƚomunxajma' to'huaiyinge Jesús, ti'i'ma. Ts'ipenic' italai'e'ma, timi: ―Iya' ƚinca ca'huaiyinge Jesucristo. Iƚque i'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Icuxe'ma ecaxu'ma al carro. Imulunca loquexi'. Itsuflai'me laja'. Felipe epo'i'ma ts'ipenic'. ");
INSERT INTO chdNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ipalnanca laja', if'ajlina'me ƚamats', cal Espíritu Santo ileco'ma Felipe. Ts'ipenic' aiquixingona'ma. Uyaina'ma tixoqui queta. ");
INSERT INTO chdNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe iximpoxi icuaita jiƚpe liƚya' cuftine Azoto. I'hua'ma lane lotsepa liƚya' Cesarea. Jahuay ƚiƚeloƚya' pe loyaicopa tuya'e' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Icuaitsi Cesarea. ");
INSERT INTO chdNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo ti'hua tixtu'hua. Itine ipuqui' tehue te co'iya mima'ayacola' ts'ilihuequi Jesús. I'hua'ma ipalaic'otsi cal cuecaj ca'ailli'. ");
INSERT INTO chdNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ixahue'e'ma quije'e. Ti'hua'ma liƚya' Damasco, jiƚpiya ƚajut'ƚi pe lafoƚyomma lan xanuc' judío timuc'itola' ts'iƚpenic' iƚe lije'e. Timi cal cuecaj ca'ailli': ―Lapi'iƚa' caimane. Liƚya' Damasco timana' iƚniya naihuejpá al ts'e cane. Ja'ni caxintsola', axanuc' o acaƚ'no', ca'noƚtola', cafijntola', ca'hua'acola' fa'a liƚya' Jerusalén. (Cal cuecaj ca'ailli' epi'i'ma Saulo al je'e lixahue'epa.) ");
INSERT INTO chdNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mi'hua lane joupa ticuaita liƚya' Damasco epalc'o'i'ma anuli lepalc'o'. Iƚe lepalc'o' qui'huayomma lema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ecangenni ixc'uat'ƚhuaitsi ƚamats'. Icuej'ma tipalaic'o, timi: ―Ima' cunSaulo, ¿te calihuetsocopa? ¿Te caƚteƚ'micopa? ");
INSERT INTO chdNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Timi: ―Maipoujna, ¿naitsi ima'? ȽaƚPoujna timi: ―Iya' ninJesús. Ima' aƚteƚ'mi. Cal huacax ja'ni aimicuec'e lanacompa al puya ti'hua titeƚma, ma toƚta'a toteƚma ima', aimocuec'e. ");
INSERT INTO chdNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo tiyu tixpaiqui. Timi: ―Maipoujna, ¿te ts'opic'a ca'eƚa'? ȽaƚPoujna timi: ―Totsahuenni, to'huaƚa' totsufaitsi liƚya'. Jiƚpe tu'inno' lof'eya. ");
INSERT INTO chdNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Lan xanuc' lilecola' Saulo ecaxoƚ'me jiƚpe. Ailopa'a conesyacu. Tixpailiquila'. Icuej'me tipalay. Aiquixim'me. ");
INSERT INTO chdNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo itsahuenni. Lexi'e'ma li'u' joupa i'ipa afo'. Lilecola' exaƚ'me limane. Icuai'etsa liƚya' Damasco. ");
INSERT INTO chdNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Icoƚ'ma afane' quitine aimehuetsale. Aimitesma, aimixnay. ");
INSERT INTO chdNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jiƚpe liƚya' Damasco tipa'a anuli cal xans lipuftine Ananías, ihuequi Jesús. Ma' imaf'i' tocomma tipaima. Iximpa ƚaƚPoujna Jesús, tijoc'i, timi: ―¡CunAnanías! Ananías timi: ―MaiPoujna, ma capa'a fa'a. ");
INSERT INTO chdNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ȽaƚPoujna timi: ―Totsahuenni, to'huaƚa' lane cuftine al Ƚijca Cane, tocuaita lejut'ƚ Judas. Jiƚpe taicuitsufta ja'ni tipa'a Saulo ƚas Tarso. Jiƚpe toxinna, tijoc'i ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ȽanDios joupa imuc'ipa lo'iya. Joupa iximpo' ocuaita ima', cunAnanías. Iximpo' otsufaipa lajut'ƚ, iximpo' topo'nof'i lomane ƚijuac, iximpa joupa ixaƚconapa li'u'. ");
INSERT INTO chdNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías italai'e'ma, timi: ―MaiPoujna, axpela' lan xanuc' tipalaicoyi iƚque cal xans. Ticuayi mipa'a Jerusalén juaiconapa ti'e'ela' quixcay loxanuc', iƚne lo'huijf'epola'. ");
INSERT INTO chdNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Lipamma pu'hua itaic' lije'e lini'ipa cal cuecaj ca'ailli'. Joupa epi'impa limane aƚ'noƚtsonga' jahuay illanc'. Aƚ'noƚ'monga' illanc' naƚjoc'ipo' ima' maƚPoujna Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ȽaƚPoujna timi: ―To'huaƚa'. Iya' ai'huijf'epa iƚque cal xans. Joupa aixpic'epa lo'eya. Tu'itola' lan xanuc' naitsi iya', iya' ninJesús. Tu'itola' lan xanuc' pe aimimetsaicoyi ȽanDios, tu'itola' iƚniya liƚrey. Jouc'a tu'itola' lopimaye, iƚne ixanuc' Israel. ");
INSERT INTO chdNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iƚque ƚinca titeƚco'ma acueca' ma mu'ila' lan xanuc' naitsi iya'. Toƚta'a camuc'i'ma, iya' ninJesús. ");
INSERT INTO chdNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías i'hua'ma. Icuaitsi lajut'ƚ pe lopa'a Saulo. Itsufai'ma, ipo'nof'ipa limane ƚijuac, timi: ―CunSaulo maipima, ima' mo'hua lane fa'a oximpa ƚaƚPoujna Jesús. Iƚque imujpoxi. Maƚque Jesús alummepa fa'a. Ipic'a toxinalenƚa', ticuxetso' lopicuejma' cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aiquicoƚ'ma. Saulo ixim'ma tecangemma tocomma to lipic'ala catú jiƚpe li'u'. Ixaƚcona'ma li'u', ehuetsalena'ma. Itsahuenni, epo'im'me. ");
INSERT INTO chdNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Itetso'ma, icuainanni lipujfxi. Imajm'me anuli ts'ilihuequi Jesús jiƚpe liƚya' Damasco, icoƚ'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Iƚniya ƚitiné itsehuo'ma ƚajut'ƚi pe lafoƚyomma lan xanuc' judío, tu'iyale naitsi Jesús. Timila': ―Iƚque i'Hua ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iƚne noquimf'epá ticuayi: ―¿Te qui'ipa? Iƚque cal xans mipa'a Jerusalén tijou'nela' lan xanuc' nojoc'ipá Jesús. Icuai'ma fa'a ti'noƚtsola' iƚniya, tifi'etsola', ti'hua'a'mola' Jerusalén, ticuai'etola' pe lomana' lixanuc' cal cuecaj ca'ailli'. Itsiya, ¡toƚsinƚe lo'epa! ");
INSERT INTO chdNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo i'ipa xonca acueca' lipicuejma'. Timuqui aƚinca Jesús copa'a cal Cristo, ƚummepa ȽanDios. Ti‑ch'ixc'ela' lan xanuc' judío nomana' jiƚpe liƚya' Damasco. Iƚne ma tiquimf'eyi, ailopa'a cotalai'ecoyacu. ");
INSERT INTO chdNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Joupa uyaipa axpe' quitine lan xanuc' judío ixpic'e'me, ticuayi: ―Aƚma'a'me Saulo. ");
INSERT INTO chdNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ipuqui' itine ti'huejyi cal puertá canumicay eti'icoya aitaƚ jiƚpe liƚya'. Saulo i'ipa quixina' lo'eyacu iƚne lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lijou'ma ts'ilihuequi Saulo unƚu'e'me. Lipuqui' icus'mi'me anuli al cueca' tsiquihuiƚ, panca panca ecajm'me ƚixpula caitaƚ, ixehuaitsi al tsiquihuiƚ jiƚpe ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo i'hua'ma, icuaitsi Jerusalén. Ipic'a tiƚejmaletsa ts'ilihuequi Jesús. Iƚne aiquiƚcuac'. Tixpaic'eyi. Ticuayi: ―Iƚque Saulo a'i mihuequi Jesús, ma le'a ticua. ");
INSERT INTO chdNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabé i'e'ma ƚinca limi'ma Saulo. Ileco'ma pe lomana' lan apóstole. U'i'mola' te ts'i'ic' li'ipa Saulo. Timila': ―Mi'hua lane Saulo ixim'ma ƚaƚPoujna Jesús. Iƚque ipalaic'o'ma. Mipa'a Damasco aimitay calaic'ata. Imuj'moxi ummepa Jesús, tuya'e' litaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulo imajmpá anuli lan apóstole. Ti'hualejma ni petsi Jerusalén. Ailopa'a tintsi. ");
INSERT INTO chdNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tipalaic'ola' lan xanuc' judío, iƚne nopalaipá liƚtaiqui' griego. Timila': ―Imanc' timenaquilhuo'. Iƚne ixtulenca. Ehue'me te co'iya mima'ayacu. ");
INSERT INTO chdNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lapimaye i'ipa quiƚsina' lo'eyacu iƚne lan xanuc' judío. Ileco'me Saulo liƚya' Cesarea. Jiƚpiya ummepa ti'huaƚa' lipiƚya' Tarso. ");
INSERT INTO chdNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Iƚne ƚitiné ailopa'a tintsi. Ti'hua efot'ƚe'moƚtsi lapimaye, iƚne nomana' al distrito Judea jouc'a nomana' al distrito Galilea, jouc'a nomana' ƚamats' Samaria. Ifa'epola' liƚpicuejma'. Xonca tixpaic'eyi ƚaƚPoujna, ti'eyi latenƚcocopa. Cal Espíritu Santo ixoc'i'mola' quileta. Toƚta'a ixpe'mola' lapimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro ti'hua iƚya' iƚya', icuaitsi liƚya' Lida. I'hua'ma ehuejntsola' lapimaye nomana' jiƚpe, iƚne i'huexi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jiƚpe liƚya' ixim'ma anuli cal xans cuftine Eneas. Ixhuaita apaico camats' tunouya. Uhuaquemma. ");
INSERT INTO chdNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro timi: ―CumEneas, Jesucristo ixaƚ'menapo'. Totsahuenni. Tonif'naƚa' lohualfa. Aiquicoƚ'ma, itsahuenanni. ");
INSERT INTO chdNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jahuay lan xanuc' nomana' jiƚpe liƚya' Lida, jouc'a nomana' ƚamats' Sarón, icuej'me ixaƚconapa Eneas. Ixhuej'menca, ipai'i'me liƚpicuejma'. Ipango'me ihuej'me ƚaƚPoujna Jesucristo. ");
INSERT INTO chdNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Liƚya' Jope timana' ts'ilihuequi Jesús. Anuli iƚniya aca'no' cuftine Tabita. Iƚe laftine ja'ni tonesla' ataiqui' griego ticua: Dorcas. Iƚque ƚaca'no' ƚinca ti'ay al c'a. Aimixospa. Itine itine titoc'ila' pe ailopa'a quiƚ'hueca. ");
INSERT INTO chdNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Iƚne ƚitiné Dorcas extaf'ma, imana'ma. Epo'im'me licuerpo. Ipo'nom'me anuli lajut'ƚ lopa'a al toncay. ");
INSERT INTO chdNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ts'ilihuequi Jesús nomana' liƚya' Jope icuej'me a'ij culi' Pedro, tipa'a liƚya' Lida. Ummem'mola' oquexi' lan xanuc' tixahue'etsa, timitsa: ―To'huanni pe laƚmana' liƚya' Jope. Aimicoƚ'mo'. ");
INSERT INTO chdNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro jouc'a iye'me. Licuaitsa lajut'ƚ jiƚpe Jope, ileco'me Pedro al toncay pe lipo'no'empa ƚaca'no' ƚimanapa. Icuaiyunca lapimaye cacaƚ'no' apotsateya. Ecaxingoƚai'me Pedro. Tijolijyi. Timuc'iyi lan tsamalo jouc'a ƚijahuaƚi ƚilanc'epa Dorcas miƚmana' anuli iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro ipa'a'mola'. Exc'onƚhuai'ma, ijoc'i'ma ȽanDios. Lijou'ma ecaxna'ma, ipai'e'moxi, ehuelojm'ma ƚimanapa, timi: ―ConTabita, totsahuenanni. Tabita exi'e'ma li'u'. Ixim'ma Pedro, icutsai'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro i'noƚ'e'e'ma limane, ecaxu'ma. Ijoc'i'mola' titsulfoƚaiconanca lapimaye, iƚne i'huexi ȽanDios, jouc'a lacaƚ'no' lam potsateya. Timila': ―Jifa'a ƚoƚpima Dorcas, joupa imaf'inapa. ");
INSERT INTO chdNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ni petsi jiƚpe liƚya' Jope icuej'me li'ipa. Axpela' i'huaiyijm'me ƚaƚPoujna Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro ipanenni axpe' quitine liƚya' Jope. Ipajm'ma lejut'ƚ anuli cal xans nacof'ejpa quixmi, cuftine Simón. ");
INSERT INTO chdNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Jiƚpe liƚya' Cesarea tipa'a anuli cal xans aromano cuftine Cornelio. Iƚque incuxepa. Locuxepola' amaxnu lisoldado. Iƚne lan soldado, jouc'a liƚf'as soldado, tecui'innila' Lan Italiano. ");
INSERT INTO chdNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iƚque Cornelio tenanƚi locuxepa ȽanDios. Acueca' titoc'ila' lan xanuc' judío pe aiquiƚ'hueca. Itine itine tijoc'i ȽanDios. Jahuay nomana' lejut'ƚ jouc'a tixpaic'eyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Anuli litine, joupa uyaipa menac'o, icuaita to al fanej hora, ȽanDios imuc'i'ma lo'iya. Ixim'ma anuli ƚapaluc quema'a itsufai'ma lejut'ƚ. Ƚapaluc timi: ―¡CunCornelio! ");
INSERT INTO chdNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Lehuelojm'ma ƚapaluc quema'a Cornelio ixpaij'ma juaiconapa. Timi: ―Maipoujna, ¿te ts'opic'a? Timi: ―Lofxa'huepa if'ajpa lema'a pe lopa'a ȽanDios. Iƚque iximpo' totoc'ila' lan xanuc'. Ti'nujuaishuo' ima'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Timihuo': Tommetsola' loxanuc' tiyeƚe Jope. Tiyeƚe pe lopa'a anuli cal xans cuftine Simón, tecui'inni Pedro. Timitsa ti'huanni lomejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iƚque Pedro ipanc'ale lejut'ƚ anuli cal xans ƚacof'ejpa quixmi, cuftine Simón. Simón lejut'ƚ copa'a lema quiƚya', ƚema caja. Pedro tu'i'mo' lof'eya. ");
INSERT INTO chdNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ƚapaluc quema'a nopalaic'opa Cornelio i'huana'ma. Cornelio ijoc'i'mola' oquexi' limozó. Jouc'a ijoc'i'ma anuli cal soldado notoc'ipa. Iƚque cal soldado tenanƚi locuxepa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","U'i'mola' iximpa anuli ƚapaluc quema'a. Jouc'a u'i'mola' linespa. Imi'mola' tiyeƚe liƚya' Jope. Iyepá. ");
INSERT INTO chdNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lihuequi litine lummepola' Cornelio joupa ticuaita liƚya' Jope. I'ipa to menac'o. Maƚe al 'hora Pedro if'ajma al toncay lajut'ƚ. Tipalaic'ota ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mijoc'i ȽanDios unle'enni, ticui coteja. Tilanc'enni ƚoteja. Mi'huaijma titetso'ma i'huapa lipicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ixim'ma exiya lema'a, iximpa to anuli al cuecaj cutse timumma. Iƚe al cuecaj cutse ilanc'ecompa ijahua', ifi'iya lam malpu' ƚupahuay. ");
INSERT INTO chdNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jiƚpe ti'nicoƚanna tocomma to tiƚmana' jahuay linneja nomana' li'a ƚamats'. Timana' iƚne noyecopá amalpu' liƚ'mitsi', jouc'a tiyeyi laquifpoƚtsi ƚamats', jouc'a naiyulpá lema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pedro icuej'ma tipalaic'onni, timinni: ―CumPedro, toma'aƚa' anuli iƚne linneja, toteƚa'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro timi: ―A'i maiPoujna, aimi'iya cateja iƚna'a linneja. Caxinnila' axujc'a. Iya' aicaitec'o cal xujc'a. ");
INSERT INTO chdNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ti'hua tipalaic'onni, timinni: ―Pe ȽanDios liximpa alimpio, ima' aimocua'ma: “Axujc'a”. ");
INSERT INTO chdNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Afanemma i'i'ma toƚta'a. Lijou'ma iƚe al cuecaj cutse if'ajna'ma lema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro timiyoxi: “¿Te caƚmuc'icompa iƚe laiximpa?” Toƚta'a minesqui icuaitsa lam fantsi xanuc' lummepola' Cornelio. Iƚne joupa icuitsufpá, imuc'impola' lejut'ƚ Simón. Itsiya tecaxoƚanna al puerta. ");
INSERT INTO chdNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ticuitsufyi, tijoc'iyi: ―¿Ja'ni fa'a copa'a Simón ipanc'ale, iƚque ƚacui'impa Pedro? ");
INSERT INTO chdNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Micoƚi Pedro al toncay lajut'ƚ ti'hua timiyoxi: “Iƚe laiximpa, ¿te cocuajmaispa?” Cal Espíritu Santo timi: ―Timana' afantsi lan xanuc' tehuehuo'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Totsahuenni, taimuƚa'. Taihuej'mola'. Tonƚeƚe. Aimoxhueƚmot'ƚe'ma. Iya' nummepola'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro imunni. Ipalaic'o'mola' lam fantsi lan xanuc' lummepola' Cornelio. Timila': ―Iya' ninSimón. Imanc' lahuay. ¿Te coƚcuaiyoco'me? ¿Te ts'oƚpic'a? ");
INSERT INTO chdNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Timiyi: ―Cornelio, iƚque incuxepa, locuxepola' amaxnu lan soldado, maƚque alummeponga'. Iƚque aƚijca xans, tixpaic'e ȽanDios. Jahuay lan xanuc' judío ticuayi: “Iƚque ac'a xans”. Anuli cal paxi capaluc quema'a ixc'ai'ipa timi: “Tojoc'itsi Pedro ticuaiyunni lomejut'ƚ. Toquimf'e'ma litaiqui' lu'iyaco'.” ");
INSERT INTO chdNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedro itsufai'e'mola'. Epi'i'mola' pe loxmai'eyacu iƚe lipuqui'. Lihuequi litine itsahuenni, iyejmale'me. Hualca lapimaye lun Jope jouc'a iye'me. ");
INSERT INTO chdNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lihuequi litine icuaitsa liƚya' Cesarea. Tipa'a Cornelio jiƚpe lejut'ƚ, i'huaicola'. Jouc'a tiƚmana' lijoc'impola', iƚne lipimaye jouc'a liyejmalepá xonca limetsaicola'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Licuaita Pedro, Cornelio italecufhuo'ma, exc'onƚingai'ma li'mitsi'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro i'noƚ'e'e'ma limane, timi: ―Totsahuenni. Iya' jouc'a ninxans. ");
INSERT INTO chdNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mipalaic'oyoƚtsi itsulfoƚai'me lajut'ƚ. Pedro ixim'mola' axpela' lan xanuc' efoƚya jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Timila': ―Illanc' ninc'ixanuc' judío, imanc' oƚsina' laƚ'ejma'. Aimaƚejmaleyi imanc' unc'ocuenaye xanuc'. Aimaƚtsulfoƚaiyi ƚolajut'ƚi. Aƚcuayi: “ȽanDios aimepenufilhuo'”. Lacui'ilhuo': “Unc'ixujc'a xanuc'”. ȽanDios joupa aƚmuc'ipa alimenajpa. Aicanesconaya toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Toƚta'a iya' aicaƚcoƚi. Nihuejcopa laƚmipa iƚna'a lummepola' Cornelio. Aicainesqui: “Aimi'iya ca'huaya”. Aicuai'ma fa'a. Itsiya lu'iƚa': ¿Te caƚjoc'icopa? ");
INSERT INTO chdNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio timi: ―Ixhuaita amalpu' quitine, maƚta'a al fanej hora, capa'a fa'a lainejut'ƚ caxnet'ƚqui, cajoc'i ȽanDios, aixim'ma imaxcaita anuli cal xans, tunts'ifi lipijahua'. LacaxinGai'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aƚmi: “CunCornelio, lofxa'huepa if'ajpa lema'a pe lopa'a ȽanDios. Iƚque iximpo' totoc'ila' lan xanuc'. Ti'nuhuaishuo' ima'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Timihuo': Tommetsola' loxanuc' liƚya' Jope. Tiyeƚe pe lopa'a anuli cal xans cuftine Simón, tecui'inni Pedro. Timitsa ti'huanni lomejut'ƚ. Iƚque ipanc'ale lejut'ƚ anuli cal xans ƚacof'ejpa quixmi, cuftine jouc'a Simón. Iƚque Simón lejut'ƚ copa'a lema quiƚya', ƚema caja. Iƚque tu'i'mo' lof'eya.” ");
INSERT INTO chdNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","’Aicaƚcoƚi. Nummepola' laixanuc' tiyeƚe pe lofpa'a. Ima' o'epa al c'a, ocuai'ma lainejut'ƚ. Itsiya, lu'itsonga' te quimipo' ȽanDios. Jahuay iƚe lixc'ai'ipo' lu'itsonga'. Toƚiya lafot'ƚeyoƚtsi, fa'a lahuelonginga' ȽanDios. Aƚquimf'e'mo'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro ipango'ma ipalaic'o'mola', timila': ―Itsiya xonca aixina' te ts'i'ic' lipicuejma' ȽanDios. Ailopa'a catets'ipa. ");
INSERT INTO chdNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Anuli cal xans, ni petsi li'huayomma, ni petsi linación, ja'ni tixpaic'e ȽanDios, ja'ni aƚijca lo'epa, iƚque cal xans ȽanDios tepenufi. ");
INSERT INTO chdNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","’Illanc' ixanuc' Israel, toƚta'a alu'iponga' ȽanDios, lumme'eponga' Jesucristo. Iƚque iƚPoujna jahuay lan xanuc', uya'a'ma: “ȽanDios ipic'a tiyejmaleƚe lan xanuc'”. ");
INSERT INTO chdNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Ate'a Juan Bautista u'i'mola' lan xanuc' tepoliƚe. Lijou'ma Jesús i'hualeco'ma ƚalamats' illanc' ninc'ijudío. Jiƚpe al distrito Galilea ipango'ma uya'a'ma. ȽanDios joupa ipaxnepa, joupa epi'ipa cal Espíritu Santo, epi'ipa limane ti'eƚa' al cueca'. Ni petsi lo'huapa i'e'ma al c'a. Jahuay lan xanuc' loteƚ'mipola' Satanás, Jesús ixaƚ'me'mola'. Iƚque iƚejmale ȽanDios, toƚiya i'e'ma toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Illanc' aƚsimpá li'e'ma mi'hualejma ƚamats' Judea, jouc'a mipa'a liƚya' Jerusalén. Maƚque Jesús epaƚts'ijmpá anuli al 'ec. Ima'a'me. ");
INSERT INTO chdNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Licuaitsi al fane' quitine ȽanDios imaf'i'ina'ma, epi'ipa lane timujxoxi. Imuj'moxi. ");
INSERT INTO chdNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Aimimujyoxi pe lomana' jahuay lan xanuc'. ȽanDios joupa ixpic'epa naitsi noxinyacu. Iƚniya tuya'a'me: “Imaf'inapa Jesús, joupa aƚsimpá”. Toƚiya illanc' aƚ'huijf'eponga' aƚsinnapá joupa imaf'inapa. Lijoupa limaf'inapa aƚtetsoconapá anuli, aƚsnaconapá anuli. ");
INSERT INTO chdNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aƚcuxe'eponga' luya'aƚe, lu'itsola' lan xanuc': “ȽanDios epi'ipa limane Jesús. Iƚque cal Cuecaj Juez. Quiƚmaf'i' lan xanuc' jouc'a petsi limanapola', maƚque Jesús iƚJuez.” ");
INSERT INTO chdNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jahuay lam profeta inescopá Jesús, uya'a'me: “Cal xans ƚo'huaiyijmpa Jesús, ȽanDios timenc'e'eco'ma li'epa lixcay. Ma' iƚque Nalunƚu'eponga'.” ");
INSERT INTO chdNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mipalay Pedro icuaiyunni cal Espíritu Santo. Jahuay lan xanuc' noquimf'epá iximpá cal Espirítu limunni lema'a, epenuf'me. ");
INSERT INTO chdNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jiƚpe timana' lapimaye judío no'huaiyijmpá Jesús, iƚne iƚejmale Pedro. Ticuayi: ―¿Te qui'ipa? Iƚne ocuenaye lan xanuc', a'i judío. Xinƚa', ȽanDios tepi'ila' cal Espíritu Santo. Aimicuanac'ela'. ");
INSERT INTO chdNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Iƚne locuenaye lan xanuc' mix'natsi'iyi ȽanDios tipalaiyi ituca', a'i quiƚtaiqui'. Toƚta'a liƚejmale Pedro ixim'me joupa epi'ipola' ȽanDios cal Espíritu Santo. ");
INSERT INTO chdNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pedro timila' liƚejmale: ―¿Ja'ni tipa'a nonesya: “Iƚniya aimi'iya mepoliyacu aja'”? ¿Ja'ni aimalapi'iyacola' lane? Ma to lalapenufpa illanc' cal Espíritu Santo, iƚniya jouc'a epenufpá. Aimaƚcuanac'eyacola'. ¡Tepoliƚe! ");
INSERT INTO chdNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pedro icuxe'e'mola' tepo'intsola', timetsaicom'mola' ilihuequi Jesucristo. Lijou'ma iƚniya timiyi Pedro: ―Topanenni oquej fanej quitine, aƚmajnle fa'a anuli. ");
INSERT INTO chdNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lan apóstole jouc'a lapimaye nomana' al distrito Judea icuej'me: “Locuenaye lan xanuc', iƚne a'ij judío, jouc'a epenufpá litaiqui' ȽanDios”. ");
INSERT INTO chdNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Icuaitsi Pedro Jerusalén. Jiƚpe lapimaye, iƚne axanuc' judío, tixtuc'oyi Pedro. ");
INSERT INTO chdNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ipalaic'o'me, timiyi: ―Ima' otsufaipa pe lomana' lan xanuc' a'ij judío. Oƚtetsopá anuli. ");
INSERT INTO chdNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro ipango'ma u'i'mola' te ts'i'ic' li'ipa. Ate'a u'i'mola' li'ipa mipa'a liƚya' Jope, lijou'ma u'i'mola' li'ipa liƚya' Cesarea. Timila': ");
INSERT INTO chdNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Iya' capa'a liƚya' Jope, cajoc'i ȽanDios, i'huapa laipicuejma'. Aiximpa to jipu'hua al paiyo. Aixim'ma timumma lema'a to anuli al cutse ilanc'ecompa ijahua', ifiyiya lam malpu' ƚupahuay. Icuaiyunni pe laifpa'a. ");
INSERT INTO chdNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nehuelojm'ma lo'nicoƚanna. Jiƚpe aixim'mola' linneja pe noyecopá amalpu' liƚ'mitsi', lam manxu jouc'a lan ximalo. Aixim'mola' noyecopá laquifpoƚtsi ƚamats', jouc'a aixim'mola' iƚne naiyulpá lema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aicuej'ma tipalay, aƚpalaic'o, aƚmi: “CumPedro, totsahuenni, toma'aƚa' anuli iƚne linneja, toteƚa'”. ");
INSERT INTO chdNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Iya' cami: “A'i maiPoujna, aimi'iya cateja iƚna'a linneja. Aiximpa axujc'a. Iƚque cal xujc'a aicai'nico laico ni anulemma.” ");
INSERT INTO chdNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Aicuejcona'ma tipalay lema'a, aƚtalai'e, aƚmi: “Pe ȽanDios liximpa alimpio, ima' aimocua'ma: Axujc'a.” ");
INSERT INTO chdNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Afanemma toƚta'a i'ipa. Lijou'ma al cuecaj cutse jouc'a lipinneja if'ajna'ma lema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","’Maƚej hora icuaitsa afantsi lan xanuc'. Ecaxoƚ'me ƚuna lajut'ƚ. Iƚne lan xanuc' quiyouyomma Cesarea. Ummempola' pe laifpa'a. ");
INSERT INTO chdNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Cal Espíritu Santo aƚmipa: “To'hua'ma tunƚejmale'me. Aimoxhueƚmot'ƚe'ma.” Aƚtsehuo'me jouc'a iƚna'a lan camts'us laƚpimaye. Aƚcuaitsa liƚya' Cesarea. Aƚtsulfoƚaipá lejut'ƚ cal xans naƚjoc'ipa. ");
INSERT INTO chdNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Iƚque alu'iponga' liximpa. Aƚmiponga': “Iya' aiximpa anuli ƚapaluc quema'a tecaxu lainejut'ƚ. Aƚmipa: Tommetsola' loxanuc' tiyeƚe Jope. Tiyeƚe pe lopa'a anuli cal xans cuftine Simón, tecui'inni Pedro. Timitsa ti'huanni lomejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iƚque Pedro tipalaic'o'molhuo', tuya'a'ma. Toƚta'a tonƚu'ma ima', jouc'a tunƚul'me jahuay nomana' lomejut'ƚ.” ");
INSERT INTO chdNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","’Jiƚpe lejut'ƚ cal xans naƚjoc'ipa aipango'ma aipalaic'o'mola'. Ma capalay, aiquicoƚ'ma, icuaiyunni cal Espíritu Santo imunni lema'a. Ma to licuaiyunni al te'a pe laƚmana', ma toƚta'a icuaiyunni pe lomana' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iya' ai'nujuaitsi litaiqui' ƚaƚPoujna Jesús. Iƚque aƚmiponga': “Juan lepo'ipola' lan xanuc' epo'icopola' aja'. ȽanDios tepo'ico'molhuo' cal Espíritu Santo.” ");
INSERT INTO chdNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ma to lalapi'iponga' ȽanDios cal Espíritu Santo, illanc' pe naƚ'huaiyijmpá ƚaƚPoujna Jesucristo, ma toƚta'a epi'ipola' jouc'a iƚniya. Iya' ma le'a ninxans. ¿Ja'ni ti'i'ma capa'ne'ma ȽanDios? A'i. Aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Licuej'me toƚta'a lan apóstole, ailopa'a quiƚtaleconghua Pedro. Iximpá acueca' lo'epa ȽanDios. Timiyi ȽanDios: ―Aƚs'najtsi'ihuo' joupa mepi'ipola' lane locuenaye xanuc', iƚne a'ij judío, tepenufyi al ts'e liƚpitine aimijouya. Iƚne jouc'a ixhuej'menamma. ");
INSERT INTO chdNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lijoupa lima'ampá Esteban tiƚmana' lapimaye niyepá aculi'. Iƚniya ipalyomma Jerusalén iƚne ƚitiné liteƚ'mimpola'. Ni petsi liyepá uya'a'me litaiqui' Jesús. Icuaita ƚamats' Fenicia, ƚamats' Chipre, jouc'a liƚya' Antioquía. Litaiqui' Jesús aicu'innila' locuenaye xanuc', uya'apá ma le'a pe lomana' liƚf'as xanuc' judío. ");
INSERT INTO chdNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Hualca iƚniya lapimaye quiyouyomma ƚamats' Chipre y liƚya' Cirene. Iƚne lipalunca Jerusalén icuaitsa liƚya' Antioquía, jiƚpe ipalaic'o'me jahuay lan xanuc', a'i ma le'a lan judío. Ipalaic'o'me jouc'a lan griego, tu'innila' litaiqui' Jesucristo. ");
INSERT INTO chdNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mipalaiyi iƚniya, ƚaƚPoujna i'e'ma acueca'. Juaiconapa axpela' lan xanuc' epenuf'me lataiqui' loya'apa iƚniya. Ipaiconni liƚpicuejma'. Ipango'me ihuej'me ƚaƚPoujna Jesucristo. ");
INSERT INTO chdNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lapimaye lafot'ƚeyopoƚtsi Jerusalén icuej'me li'ipa Antioquía. Iƚne umme'me Bernabé ti'huaƚa' jiƚpiya. ");
INSERT INTO chdNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabé icuaitsi jiƚpe liƚya'. Ixim'ma ȽanDios titoc'ila' lan xanuc' nomana' jiƚpiya. Tixoqui queta. Ixc'ai'i'mola' jahuay iƚne lapimaye tipo'noƚe liƚpicuejma' tihuejle ƚiƚPoujna Jesús. Aimenaj'moƚtsi. ");
INSERT INTO chdNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Iƚque Bernabé ma' ac'a xans. Cal Espíritu Santo ticuxe lipicuejma'. Jahuay ƚunxajma' ti'huaiyinge Jesús. Jiƚpe Antioquía juaiconapa ixpepola' iƚne ts'ilihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lijou'ma Bernabé itsehuo'ma liƚya' Tarso, ehuetsi Saulo. ");
INSERT INTO chdNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Licuaitsi ixim'ma, ilecotsi i'hua'a'ma liƚya' Antioquía. Jiƚpe imajntsa anuli camats'. Efot'ƚe'moƚtsi anuli lapimaye. Imuc'i'mola' axpela' lan xanuc'. Liƚya' Antioquía ipangocopa ecui'impola' ts'ilihuequi Jesús: “Imanc' unc'icristiano”. ");
INSERT INTO chdNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Iƚne ƚitiné liƚya' Antioquía icuaiyunca lam profeta quiyouyomma Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Anuli iƚniya cuftine Agabo. Ecax'ma pe lafoƚyomma lapimaye. Timila' lonespa cal Espíritu Santo. Timila': ―Ticuaihuo litine cumemma. Ni petsi lomanc'eyacu lan xanuc' tixim'me lumemma. Ƚitiné micuxe cal cueca' quincuxepa cuftine Claudio toƚta'a lo'iya. ");
INSERT INTO chdNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ts'ilihuequi Jesús jiƚpe Antioquía ixpic'e'me titoc'intsola' liƚpimaye nomana' ƚamats' Judea. Anuli anuli, ma to ts'i'hueca, tixpij'ma tojua tumme'e'mola' lipimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Toƚta'a i'e'me. Bernabé jouc'a Saulo itai'me al tomí. Epi'intsola' lan tsilaj capimaye noxpijpá lataiqui'. Iƚne teca'nem'mola' lapimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Iƚna'a ƚitiné cal rey Herodes i'noƚ'mola' hualca lapimaye pe lafoƚyomma Jerusalén. Ipic'a titeƚ'mitsola'. ");
INSERT INTO chdNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Icuxe'ma tetec'entsa ƚejoc' Jacobo, iƚque ipimaj Juan. Etec'em'me. ");
INSERT INTO chdNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herodes ixim'ma iƚe li'epa icuaitsi quiƚpic'a lan xanuc' judío. Lijou'ma umme'mola' lixanuc' ti'noƚtsa Pedro. Toƚta'a i'i'ma iƚniya ƚitiné mi'eyi liƚjuic lan xanuc' judío. Maƚe al juic titeji ƚa'i petsi aiquilai'inni levadura. ");
INSERT INTO chdNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","I'noƚim'me Pedro. Herodes icuxe'ma i'nicontsa lacarza. Icuxe'e'mola' imbamaj camts'us lisoldado, timila': ―Toƚ'etsa cuenna iƚque Pedro. Mi'eyi cuenna tipai'iyoƚtsi amalujxi, amalujxi. Ticua Herodes: “Tijouƚa' al juic Pascua quipa'anata lacarza. Cacufta jiƚpiya pe lafoƚyomma lan xanuc'.” ");
INSERT INTO chdNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ma mipa'a lacarza Pedro, mi'eyi cuenna, lapimaye lafoƚyomma jiƚpe Jerusalén itine itine tijoc'iyi ȽanDios, tixa'hueyi titoc'iƚa' Pedro. ");
INSERT INTO chdNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Cal Herodes joupa ixpic'epa, ticua: “Mouqui quipa'anata Pedro. Cacuf'ma.” Iƚe lipuqui' Pedro tipa'a jiƚpe lacarza, tixmay nolojmay oquexi' lan soldado. Ifi'empa limane' uhuahuinc'impola' loquexi' lan soldado. Lixpula' al puerta timana' ocuenaye lan soldado ti'eyi cuenna lacarza. ");
INSERT INTO chdNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jiƚpe lacarza icuai'ma anuli ƚepaluc ƚaƚPoujna. Epalc'o'i'ma juaiconapa. Untaf'ma huata liju' Pedro, umef'ma, timi: ―¡Aimicoƚ'mo', totsahuenni! Lan cadena lifiyicoyi limane' Pedro uhuaiƚquenanni. ");
INSERT INTO chdNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ƚapaluc quema'a ipalaic'ocona'ma, timi: ―Tofi'exoxi, toc'uaicoƚa' ƚoc'ejí. Lijoupa li'epa toƚta'a ipalaic'ocona'ma, timi: ―Topoxla' lopuquiya. Alihuejla'. ");
INSERT INTO chdNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ipango'me ipalunca. Pedro ihuej'ma ƚapaluc quema'a. Ticua: “A'ij ƚinca iƚe laƚ'ipa, ma' apaiyo”. ");
INSERT INTO chdNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Uyalaico'me petsi lacaxuya cal te'a soldado no'epa cuenna lacarza. Lijou'ma uyalaico'me ƚocuena. Icuaitsa al cuecaj puerta catejma', iƚe lopa'a ma lane quiƚya'. Al puerta exinni quituca'. Ipalunca. Iyejmale'me lane. Lijou'ma ejac'na'ma ƚapaluc quema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Licuainanni lipicuejma' Pedro ticua: “Itsiya ƚinca aixina' ƚaiPoujna ummepa ƚepaluc. Lunƚu'epa limane Herodes. Tama lan xanuc' judío iƚ'huaijma te co'iya maƚma'aya, itsiya ailopa'a caƚ'e'eya. Aimi'iya.” ");
INSERT INTO chdNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Micua toƚta'a icuaitsi lejut'ƚ María, iƚque i'máma' Juan ƚecui'impa Marcos. Jiƚpe axpela' lapimaye efoƚya. Tijoc'iyi ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro umf'ax'ma ƚuna puerta. Anuli cal criada cuftine Rode i'huapa tixinna naitsi iƚque. Ipanni jiƚpe lajut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Imetsaico'ma litaiqui' Pedro. Juaiconapa ixoj'ma queta aiquexi'e al puerta. Aiquicoƚ'ma, ipaiconanni. Itsufaicona'ma lajut'ƚ, u'itsola' lapimaye, timila': ―Icuaina'ma Pedro. Tecaxu lixpula' al puerta. ");
INSERT INTO chdNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Iƚne timiyi: ―¡Ima' mamac'ta! Tihui'i, timiconala': ―Aƚinca icuaina'ma Pedro. Lapimaye ticuayi: ―A'ij ƚinca laƚmiponga'. A'i maƚque Pedro. Icuai'ma ƚepaluc quema'a. ");
INSERT INTO chdNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro ti'hua tumf'axqui. Exi'e'me al puerta, ixim'me. Ticuayi: ―¡Xinƚa'! Maƚca'a Pedro. ¿Te qui'ipa? ");
INSERT INTO chdNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro i‑ch'ixc'eco'mola' limane. U'i'mola' li'ipa, timila': ―ȽaƚPoujna lipa'ahuona'ma lacarza. Tonlu'itsola' Jacobo jouc'a locuenaye lapimaye toƚta'a laƚ'ipa. I'huana'ma, ijuc'e'moxi. ");
INSERT INTO chdNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Liƚic'e'ma lan soldado nomana' lacarza ixhueƚco'me juaiconapa. Ticuayi: ―¿Pe copa'a Pedro? Ailopa'a fa'a. ¿Te qui'ipa lipamma? ¿Pe quitsepa? ");
INSERT INTO chdNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Cal rey Herodes umme'mola' lixanuc' tehuetsa Pedro. Ehuehuo'me, aiquiƚsina'. Herodes icuis'e'mola' lan soldado. Ihui'i'ma, timila': ―Lu'iƚa', ¿te qui'ipa? Lijou'ma icuxe'ma tima'antsola'. Ipanni al distrito Judea, i'hua'ma liƚya' Cesarea. Jiƚpe ipajntsi. ");
INSERT INTO chdNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes juaiconapa tixtuc'ola' lan xanuc' nomana' ƚiƚeloƚya' Tiro y Sidón. Iƚne lan xanuc' inefo'me quiƚtuca'. Icuaitsa pe lopa'a Herodes. Ate'a ipalaic'opa nocuxepa ƚi'huexi Herodes, iƚque cal xans lipuftine Blasto. Timiyi tixahue'eƚa' Herodes aimixtuc'ocona'mola', tixanghuaitsi, tipaneconni toƚta'a. Iƚne lan xanuc' tetenƚcocola' aimixtuc'ocona'mola' cal rey. Jiƚpe ƚilemats' tehue'e' ƚotejacu. Iƚpic'a Herodes tumme'econatsola'. ");
INSERT INTO chdNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes ixpic'e'ma litine. U'i'mola': ―Jiƚpe litine capalaic'o'molhuo'. Licuaitsi iƚe litine Herodes etej'moxi, ipo'no'ma lipijahua' ajrey, icutsai'ma al cuecaj li'asiento li'nof'quiya. Ipalaic'o'mola', imuxi'ale'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Lan xanuc' jiƚpe lefot'ƚeyoƚtsi ija'a'me, ticuayi: ―Iƚque ƚaƚquimf'epa, a'i xans. Iƚque andios. ");
INSERT INTO chdNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aiquicoƚ'ma. Iteƚ'mi'ma anuli ƚepaluc ƚaƚPoujna ȽanDios. Lapimí ipango'ma ite'me. Lijou'ma ima'ma. Herodes i'e'e'moxi xonca cal cueca', etets'ipa ȽanDios, toƚiya li'ipa toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Litaiqui' ȽanDios ti'hua ti'huajcola' xonca lan xanuc'. Ixpepola' juaiconapa ts'ilihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé y Saulo joupa ecanghuo'me al tomí, epi'inghuo'mola'. Lapimaye nomana' Jerusalén. Lijou'ma ipailinanca icuaitsa liƚya' Antioquía. Ileco'me Juan ƚecui'impa Marcos. ");
INSERT INTO chdNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jiƚpe liƚya' Antioquía petsi lafot'ƚepoƚtsi lapimaye timana' lam profeta jouc'a lomxiye nomuc'iyalepá litaiqui' Jesucristo. Iƚniya liƚpuftine Bernabé, Simón ƚacui'impa Ƚumi, Lucio ƚas Cirene, Manaén ƚitojyohuo'ma lejut'ƚ Herodes. Iƚque Herodes ƚacui'impa cal tetrarca. Jouc'a tipa'a Saulo. ");
INSERT INTO chdNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Iƚniya mixnet'ƚyi, aimitetsoyi, mix'najtsi'iyi ȽanDios, cal Espíritu Santo timila': ―Tolimetsaicotsola' Bernabé jouc'a Saulo. Iya' aijoc'icopola' ti'eƚe lanic' laifnepi'iyacola'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lijou'ma ixnet'ƚcona'me, ijoc'icona'me ȽanDios, ipo'nof'i'me liƚmane ƚiƚjuac iƚne Bernabé jouc'a Saulo. Ixc'ai'inam'mola', timinnila': ―Tonƚenƚe, toƚ'etsa lanic' lepi'ipolhuo' ƚaƚPoujna. ");
INSERT INTO chdNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Lijou'ma cal Espíritu Santo icuxe'mola' tiyeƚe iƚne loquexi'. Iye'me liƚya' Seleucia. Jiƚpiya itsulfoƚai'me anuli al barco lotseya ƚamats' Chipre. ");
INSERT INTO chdNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jiƚpe ƚamats' Chipre ipalunca al barco, icuaitsa liƚya' Salamina. Ƚajut'ƚi pe lafoƚyomma lan xanuc' judío uya'a'me litaiqui' ȽanDios. Tilecoyi Juan Marcos, iyejmale'me. Iƚque titoc'ila'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Uyalaicotsa jahuay ƚamats' Chipre, icuaitsa liƚya' Pafos. Jiƚpiya ixim'me anuli cal xans judío cuftine Barjesús. Iƚque abrujo. Tifel'mila' lan xanuc', timila': ―Iya' ninprofeta. Cuya'e' lonespa ȽanDios. Iƚe lonespa a'ij ƚinca. ");
INSERT INTO chdNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesús ƚipoujna cuftine Sergio Paulo. Iƚque incuxepa jiƚpe Chipre, ac'a lipicuejma'. Ijoc'i'mola' Bernabé jouc'a Saulo ticuaiyunca lejut'ƚ. Ipic'a tiquimf'eƚa' litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Barjesús jouc'a cuftine Elimas. (Iƚe laftine tuhuaƚquemma “abrujo”.) I'e'mola' quipilaic' Bernabé y Saulo. Ticua: “Ƚincuxepa aimihuejco'ma litaiqui' ȽanDios”. Ehue'ma te co'eya. ");
INSERT INTO chdNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Cal Espíritu Santo icuxe'ma lipicuejma' Saulo. (Iƚque jouc'a cuftine aPablo.) Ehuelojm'ma juaiconapa Elimas. ");
INSERT INTO chdNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Timi: ―Ima' ma le'a tofel'miyale. Aimi'iya monesya al ƚinca. To'ay ma le'a lixcay. Ima' i'hua ƚonta'a Satanás. Iƚne no'epá al c'a ima' taixtuc'ola'. To'ay capilaic' lipene ƚaƚPoujna ȽanDios, iƚe al ƚijca cane. Tomuc'iyale ituca' cataiqui'. ¿Te quitine tatec'o'ma iƚe lof'epa? ");
INSERT INTO chdNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Aƚquimf'eƚa': ȽaƚPoujna titeƚ'mihuo'. Aimi'iya mahuetsaleconaya. Micoƚi iƚe loteƚ'miyaco' ni aimoxinya lipepalc'o' cal 'ora. Aiquicoƚ'ma. Elimas ixim'ma tocomma to ummahuay, imufc'o'ma li'u'. Ipango'ma ixpailo'ma limane. Tehuay naitsi naxaƚya. ");
INSERT INTO chdNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lixim'ma toƚta'a li'i'ma ƚincuxepa epenufpa lataiqui' limipa Pablo. Ticua: ―¡Acueca' litaiqui' ƚaƚPoujna Jesús! ¡Acueca' lo'epa! ");
INSERT INTO chdNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Jiƚpe liƚya' Pafos Pablo y liƚejmale itsulfoƚai'me ocuena barco. Licuaitsa liƚya' Perge lopa'a ƚamats' Panfilia, Juan, iƚque notoc'ipola', ipo'no'mola' quiƚtuca'. Ipainanni, i'huana'ma lipiƚya' Jerusalén. ");
INSERT INTO chdNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablo y Bernabé ipalunca Perge, iye'me liƚya' Antioquía lopa'a ƚamats' Pisidia. Litine conxajya itsulfoƚai'me lajut'ƚ pe lafoƚyomma lan xanuc' judío, icutsoƚai'me. ");
INSERT INTO chdNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Iquimf'e'me loxhuecofimpa al je'e liniƚiya locuxepa ȽanDios, jouc'a al je'e iniƚiya loya'apa lam profeta. Lijou'ma nocuxepá jiƚpiya lajut'ƚ umme'me anuli ƚapaluc pe locutsoƚanna Pablo y liƚejmale. Timila': ―Cunc'aƚpimaye, anuli imanc' ja'ni ipic'a tixc'ai'i'mola' lan xanuc' nomana' fa'a, ne', tipalaic'otsola'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablo ecax'ma. I'nof'e'ma limane, ipango'ma ipalaic'o'mola', timila': ―Imanc' cunc'ixanuc' oƚtatahuelo Israel, jouc'a imanc' noƚspaic'epá ȽanDios, aƚquimf'eƚa'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ȽanDios, ƚalanDios illanc' ixanuc' Israel, joupa i'huijf'epola' laƚtatahueló. Miƚmana' iƚne laƚxanuc' ƚamats' Egipto ȽanDios i'e'e'mola' axpela'. Lijou'ma itoc'i'mola' juaiconapa, ipa'a'mola' jiƚpe ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Muyalaicoyi ƚamats' pe ailopa'a quiƚya' to oquej nuxans camats' ȽanDios ixnet'ƚ'ma liƚ'ejma', itoc'i'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Maƚque ȽanDios ecani'e'mola' lan xanuc' acaitsi lan nacíon ƚamats' Canaán. Maƚpe ƚamats' Canaán epi'i'mola' laƚxanuc' quilemats'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Lijou'ma ȽanDios ifaj'mola' iƚne lecui'impola' lan Juez. To amalpu maxnu oquej nuxans quimbama' camats' lan Juez icuxe'me. Lijou'ma cal profeta cuftine Samuel icuxe'mola' laƚxanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","’Iƚne ƚitiné laƚxanuc' ixahue'e'me ȽanDios tepi'itsola' anuli cal rey, ticuxetsola'. Epi'i'mola' ƚiƚrey cuftine Saul, i'hua Cis. Iƚque Saul ƚitatahuelo cuftine Benjamín. ");
INSERT INTO chdNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lijou'ma ȽanDios iƚonc'e'ena'ma Saul lipenic', epi'i'ma David. Ti'iƚa' iƚque ƚiƚrey laƚxanuc'. Maƚque cal rey David ȽanDios inescopa ticua: David i'hua Isaí, ainimetsaijma te ts'i'ic' li'ejma'. Iƚque lipicuejma' ti'onƚcospa to iya' laipicuejma'. Aƚinca ti'e'ma jahuay laifxpic'epa. ");
INSERT INTO chdNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","’Maƚque David ȽanDios i'e'epa itatahuelo Jesús, iƚque Ƚalunƚu'eponga'. Toƚta'a li'epa ȽanDios enanƚ'ma litaiqui' li'ipa linespa. Ummepa Jesús pe laƚmana' illanc' ixanuc' Israel. ");
INSERT INTO chdNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ate'a icuai'ma Juan Bautista. Uya'a'ma, timila' lan xanuc': “Imanc' cunc'ixanuc', oƚtatahuelo Israel, toƚsuej'menca, tolapoliƚe”. ");
INSERT INTO chdNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan joupa tijou'ne'ma lipenic' ticuis'ela' lan xanuc', timila': “Imanc', ¿te coƚcuapa? ¿Naitsi iya'? Iya' a'i to laƚnescopa. Aicuai'ma ate'a, tijouƚa' ticuaihuo iƚque pe ts'oƚ'huaijma ƚocuaicoya. Iƚque xonca acueca' xans. Iya' aimi'iya cuhuaƚc'e'eya lic'eji'.” ");
INSERT INTO chdNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Cunc'aipimaye, imanc' noƚspaic'epá ȽanDios, ja'ni Abraham oƚtatahuelo o ja'ni ituca' loƚnación, itsiya ȽanDios tipalaic'olhuo', tu'ilhuo' naitsi iƚque Ƚonƚu'eyacolhuo'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Lan xanuc' nomana' Jerusalén jouc'a liƚpincuxepá aiquilimetsaijma iƚque Ƚalunƚu'eponga'. Iƚniya icuxecopa Jesús. Toƚta'a enant'ƚipá loya'apa lam profeta jiƚpe liƚje'e, iƚe al je'e tixhuenni itine itine conxajya. ");
INSERT INTO chdNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tama aiquiƚsi'ne quijunac' ixa'hue'me Pilato ticuxeƚa' tima'anƚe. ");
INSERT INTO chdNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lenant'ƚipá jahuay lo'iya Jesús, iƚe luya'apa lam profeta, ipuƚquinna'me petsi lepaƚts'ingiya jiƚe al 'ec, ipo'nontsa ƚunts'eja'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lijou'ma ȽanDios imaf'i'inapa iƚque Jesús, ipa'apa pe lomana' lamizhua. ");
INSERT INTO chdNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ts'ilihuequi Jesús, pe nipalyomma Galilea, iyejmale'me icuaitsa anuli Jerusalén, iƚniya ixingona'me Jesús, tu'iyaleyi iƚe liximpa. ");
INSERT INTO chdNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Ƚinca, mimana' laƚtatahueló ȽanDios imipola' iƚe al c'a lo'iya. Imi'mola': “Toƚe, toƚe ca'e'ma”. Itsiya lu'ilhuo': Joupa i'ipa. ");
INSERT INTO chdNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ȽanDios joupa imaf'i'inapa Jesús. Enant'ƚipa iƚe litaiqui' limipola' laƚtatahueló. Toƚta'a aƚmuc'iponga' illanc' iƚnietó iƚne laƚtatahueló. Ma toƚta'a loya'apa al salmo lacui'impa loque', tuya'e' lonespa ȽanDios, ticua: Ima' ai'Hua, Itsiya aimuc'ipola' lan xanuc' aƚinca iya' o'Ailli'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","’Jouc'a tuya'e' timaf'i'ina'ma Jesús, tipa'anata pe lomana' lamizhua. Tuya'e' aimimaconaya, aimihuet'ƚya licuerpo. ȽanDios timila' lixanuc': Joupa aipo'nopa lataiqui', nepi'ipa David. Iƚe laitaiqui' apaxi, canant'ƚi'ma. Toƚta'a toƚsim'me imanc'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ocuena al salmo jouc'a tuya'e': To'e'ma cuenna ƚo'Hua, iƚque o'Huexi. Titoc'i'ma, aimihuet'ƚya licuerpo. ");
INSERT INTO chdNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","’Iƚe lataiqui' aiminescoyoxi David. Iƚque mipa'a fa'a li'a ƚamats' i'e'ma lixpic'epa ȽanDios, ticuxeyale. Imanapa, eminc'ina'me pe lomana' liƚcuerpo litatahueló. Lijou'ma ihuet'ƚna'ma licuerpo. ");
INSERT INTO chdNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Iƚe lataiqui' tinescojma Jesús. Ma' iƚque ȽanDios imaf'i'ina'ma. Licuerpo a'i quihuet'ƚ'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","’Cunc'aipimaye, aƚquimf'eƚa'. Iya' cu'ilhuo': Ja'ni toƚ'huaiyijnle Jesús ȽanDios timenc'e'eco'molhuo' loƚ'epa lixcay. ");
INSERT INTO chdNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tama tolihuejcoyi locuxepa Moisés aimimenc'e'ecoyacolhuo' nulemma jahuay loƚ'epa lixcay. Ti'hua toƚtai'me lajunac'. Ja'ni toƚ'huaiyijnle Jesús, aimitac'uinyacolhuo' cajunac', ni toƚta'a. ");
INSERT INTO chdNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iya' camilhuo' imanc' naƚquimf'epa: Toƚpo'noƚe cuenna. Ja'ni a'i ti'i'molhuo' to loya'apa ȽanDios jiƚpe litaiqui' liniƚingiya liƚje'e lam profeta, ticua: ");
INSERT INTO chdNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Imanc' tolixocoyi, tolahuelojnle laif'epa, toƚ'huijle loƚpicuejma'. Itsiya, ma moƚmana' imanc', ca'e'ma al cueca'. Ja'ni tu'intsolhuo': Toƚe, toƚe lo'epa ȽanDios, imanc' toƚtalai'e'me: “A'ij ƚinca iƚe lalu'iponga'.” ");
INSERT INTO chdNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mipalumma lan xanuc' lafoƚyomma jiƚpe lajut'ƚ ixa'hue'me Pablo y Bernabé, timinnila': ―Locuena xamano, ticuaitsi litine conxajya, aƚpalaic'ocona'monga', lu'i'monga' xonca iƚne ƚataiquí. ");
INSERT INTO chdNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Lijoupa lipalunca jahuay lefoƚya, axpela' lan xanuc' judío jouc'a locuenaye xanuc' petsi ilihuequi liƚ'ejma' lan judío, iyejmale'me Pablo y Bernabé. Iƚniya ixc'ai'im'mola' lan xanuc', timinnila': ―ȽanDios titoc'i'molhuo'. Aimolanaj'moƚtsi iƚque. ");
INSERT INTO chdNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Icuaiyocontsi litine conxajya tehue'ela' ma le'a anuli oquexi' lan xanuc'. Jahuay locuenaye nomana' jiƚpe liƚya' efoƚunni tiquimf'e'me litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lan xanuc' judío, lixim'me joupa efoƚumma axpela' lan xanuc' i'em'mola' laic' Pablo y Bernabé. Timinnila' lan xanuc': ―Iƚniya ma le'a tifel'milhuo' imanc'. A'ij ƚinca lonespa. ");
INSERT INTO chdNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pablo y Bernabé aimixpailiquila'. Timinnila' iƚne lan xanuc' naixtulepá: ―Ate'a alu'ipolhuo' imanc' litaiqui' ȽanDios. Toƚta'a lixpic'epa. Imanc' aimetenƚcocolhuo', aimolapenufyacu al ts'e loƚpitine, tolacani'eyoƚtsi coƚtuca'. Itsiya aƚpo'no'molhuo'. Aƚe'me pe lomana' locuenaye xanuc' pe aimimetsaicoyi ȽanDios. Aƚpalaic'otola' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ma ȽanDios aƚcuxe'eponga' iƚe laƚ'eyacu. Al Paxi Liniƚingiya tuya'e' toƚta'a lonespa ȽanDios, ticua: Iya' nepi'ipo' lopenic', tapalc'o'itola' liƚpicuejma' pe aimimetsaicoyi ȽanDios. Ti'i'ma quiƚsina' cunƚu'e'mola' iya'. Iƚne nomana' xonca aculi' to'itola' iƚta'a laitaiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Licuej'me lonespa Pablo y Bernabé locuenaye lan xanuc' pe a'ij judío, iƚniya ixojma quileta. Ticuayi: ―Ac'a litaiqui' lonespa ƚaƚPoujna. ȽanDios joupa ixpic'epa naitsi iƚne lapenufyacu al ts'e liƚpitine aimijouya. Ma' iƚniya i'huaiyijmpá Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ni petsi jiƚpe ƚamats' lan xanuc' icuej'me litaiqui' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lijou'ma lan xanuc' judío pe aimi'huaiyijnyi ƚaƚPoujna Jesús ipalaic'om'mola' lacaƚ'no' pe ts'iƚ'hueca, iƚniya naihuejcopá locuxepa ȽanDios. Ipalaic'om'mola' jouc'a lan tsilaj xanuc'. Toƚta'a ixtuc'om'mola' Pablo y Bernabé, ipa'am'mola' jiƚpe ƚilemats'. ");
INSERT INTO chdNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pablo y Bernabé unaf'me liƚ'mitsi'. Ipa'a'me ƚepi camats' litaƚijmpa ƚiƚc'ejí. Toƚta'a iƚne lan apóstole imuc'im'mola' lan xanuc' ja'ni tejac'e'moƚtsi iƚne quiƚtuca' iƚjunac'. Ipalunca liƚpiƚya' iƚniya lan xanuc', iyepá lane lotsepa liƚya' Iconio. ");
INSERT INTO chdNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Le'a cal Espíritu Santo ticuxela' liƚpicuejma', toƚta'a tixoqui quileta tiyeyi iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mimana' liƚya' Iconio Pablo y Bernabé itsehuo'me lajut'ƚ pe lafoƚyomma lan xanuc' judío. Jiƚpe uya'a'me Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Axpela' noquimf'epá epenuf'me luya'a'me Pablo y Bernabé. Iƚne nepenufpá ajudío jouc'a agriego. ");
INSERT INTO chdNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lijou'ma lan xanuc' judío pe aiquilepenufi iƚe litaiqui' Jesús ipalaic'o'me locuenaye xanuc' agriego. Eteƚc'e'e'me liƚpicuejma'. Toƚta'a iƚne lan xanuc' ti'eyi laic' lapimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pablo y Bernabé icoƚ'mola', imanenca jiƚpe liƚya'. Aimixpailiquila'. Mi'huaiyijnyi ȽanDios ti'hua tuya'ayi litaiqui'. Tu'innila': ―Toƚ'huaiyijnle ȽanDios. Toƚta'a tipaxne'molhuo', titoc'i'molhuo'. Maƚque ȽanDios imujpa al ƚinca lonespa Pablo y Bernabé. Epi'i'mola' liƚmane ti'eƚe al cueca'. Toƚta'a lan xanuc' iximpá te ts'i'ic' lo'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Lan xanuc' jiƚpe liƚya' i'e'moƚtsi onƚca. Hualca ihuej'me lan xanuc' judío pe aiquilepenufi Jesús. Locuenaye ihuej'me Pablo y Bernabé. ");
INSERT INTO chdNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Lan xanuc' griego jouc'a lan xanuc' judio pe aiquilihuequi Pablo ipalaic'om'mola' ts'iƚpenic' jiƚpe liƚya'. Inefo'me, ticuayi: “Aƚteƚ'mi'mola' Pablo y Bernabé. Aƚma'aco'mola' apic'.” ");
INSERT INTO chdNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Pablo y Bernabé i'ipa quiƚsina' lo'e'enyacola'. Inul'me, iye'me ƚamats' cuftine Licaonia. Jiƚpiya uya'atsa Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. U'im'mola' lan xanuc' nomana' ƚiƚeloƚya' Listra y Derbe, jouc'a nomana' ƚilemats' ahuejnca. ");
INSERT INTO chdNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Jiƚpe liƚya' Listra tipa'a anuli cal coxo. Itine itine ticutsu. Li'mitsi' ailopa'a quiƚpujxi. Ma toƚe ipajncota. Ni anulemma qui'huac'. Aimi'i. ");
INSERT INTO chdNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Anuli litine cal coxo tiquimf'e mipalay Pablo. Pablo ehuelojm'ma. Ixim'ma cal xans ticua lipicuejma': “Ƚinca aƚsaƚcona'ma”. ");
INSERT INTO chdNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pablo ipalaic'o'ma ujfxi, timi: ―¡Topo'notsola' ƚamats' lo'mitsi', tacaxla' ƚic! Cal coxo iyuf'conni, ecax'ma ƚijca, ipango'ma i'hua'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lan xanuc' nomana' jiƚpiya ehuelojm'me cal coxo joupa ixaƚconapa, ipango'me ija'a'me. Tipalaiyi liƚtaiqui', iƚe lopalaipa lan xanuc' jiƚpe ƚamats' Licaonia. Ticuayi: ―¡Landiosla' i'epoƚtsi xanuc', imulumma pe laƚmana'! ");
INSERT INTO chdNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ipalaicom'mola' Pablo y Bernabé, ticuayi: ―Bernabé iƚque andios Zeus. Ƚocuena andios Hermes. Pablo xonca tipalay, toƚiya ecui'im'me Hermes. (Iƚne lan xanuc' ticuayi xonca tipalay Hermes. Iƚque ilepaluc lif'as candiosla'.) ");
INSERT INTO chdNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iƚne lan xanuc' nomana' ƚamats' Licaonia ƚilendios cuftine “Zeus nopa'a pe lotsufaicompa liƚya'”. Ƚe'ailli' Zeus icuaitsi al puerta ƚipuna cajut'ƚ pe lomana' Pablo y Bernabé. Ilecola' lan huacax, itaic' lan arco lilanc'ecompa ipa'. Tima'a'mola' lihuacax, titsufco'mola' Pablo y Bernabé. Ma' anuli iƚpic'a lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Loquexi' lan apóstole, iƚne Pablo y Bernabé, ixim'me lo'eyacu iƚne ƚa'ailli' y lan xanuc'. Aiquicoƚ'mola'. Ipalunca lajut'ƚ, itsulfoƚai'me nolojmay xanuc'. Tits'aƚyi liƚpijahua', timujyi a'ij c'a iƚe lo'eyacu lan xanuc'. Tija'ayi, ");
INSERT INTO chdNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","timinnila': ―Cunc'ixanuc', ¿te conƚ'eyacu? Illanc' jouc'a ninc'ixanuc'. Jifa'a aluya'ayi Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. Maƚe Lataiqui' tu'ilhuo': “Toƚpo'notsola' iƚna'a lolandiosla', aimolihuejcona'me”. Lolandiosla' ailopa'a co'epa, aimi'iya mitoc'iyacolhuo'. Tolihuejle ȽanDios Ƚimaf'i. Iƚque Nilanc'epa lema'a, li'a ƚamats', ƚaja jouc'a jahuay lopa'a. ");
INSERT INTO chdNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","’Luyaipa quitine, imanc' jouc'a locuenaye lan xanuc' pe a'ij judío toluyalaicoyi lapajnya tolihuejyi ma to moƚ'eyi. ȽanDios ixnet'ƚpa iƚe loƚ'ejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tama a'ij cuajmaica cu'ilhuo' te ts'i'ic' lipicuejma', ȽanDios imuc'ipolhuo' li'ejma'. Imuc'ipolhuo' ac'a lo'epa. Ma' iƚque ticuxe ticuiƚa', aƚcuic'inga' ƚacui ƚo'huayomma lema'a. Jouc'a ticuxe ti'iƚa' ƚitiné cafot'ƚeya. Toƚta'a aƚsinyi ƚaƚtepa. Juaiconapa alixoc'inga' calata. ");
INSERT INTO chdNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tama toƚta'a limipola' Pablo lan xanuc' afule mihuejcoyi. Juaiconapa iƚpic'a titsufcoƚe. ");
INSERT INTO chdNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Maƚej hora icuaitsa lan judío naixtulepá, iƚne quiyouyomma ƚiƚeloƚya' Iconio y Antioquía. Ipalaic'om'mola' lan xanuc' jiƚpe lefoƚya. Inesc'em'mola' Pablo y Bernabé. Lan xanuc' ihuejco'me iƚne lan xanuc' judío, ipaf'me capic' Pablo. Lijou'ma ticuayi: “Joupa imapa”. Ipa'a'me jiƚpe liƚya'. Ipo'no'me lema quiƚya'. ");
INSERT INTO chdNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ts'ilihuequi Pablo y Bernabé iƚoc'oƚai'me canumicay Pablo. Iƚque itsahuenanni, itsufaicona'ma liƚya'. Lihuequi litine ipalunca Pablo y Bernabé, icuaitsa liƚya' cuftine Derbe. ");
INSERT INTO chdNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jiƚpe uya'acona'me Lataiqui', iƚe loya'apa lixpic'epa ȽanDios. Axpela' lan xanuc' epenuf'me lataiqui', ihuej'me. Lijou'ma Pablo y Bernabé ipailiconanca, iyecona'me ƚiƚeloƚya' Listra, Iconio y Antioquía. ");
INSERT INTO chdNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Imuc'iyalecontsa ts'ilihuequi Lataiqui', ifa'empola' liƚpicuejma', ixc'ai'im'mola', timinnila': ―Ticuicomma aƚteƚcoƚe, tijouƚa' aƚtsuflainata pe locuxeyopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Iƚya' iƚya' ni petsi lafoƚyomma lapimaye Pablo y Bernabé ifaj'me lan tsilaj xanuc' noxpic'eyacu lataiqui'. Tixnet'ƚyi, aimitetsoyi, tijoc'iyi ƚaƚPoujna, timiyi: ―MaƚPoujna, iƚna'a lan xanuc' ti'huaiyijnhuo'. Totoc'itsola'. ");
INSERT INTO chdNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ipalunca liƚya' Antioquía. Uyalaico'me jahuay ƚamats' Pisidia. Icuaiyocontsa ƚamats' Panfilia. ");
INSERT INTO chdNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Iyecona'me liƚya' Perge. Jiƚpe uya'a'me Lataiqui'. Lijou'ma ipalunca, imul'me al 'ocay, icuaitsa liƚya' Atalia. ");
INSERT INTO chdNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Jiƚpiya itsulfoƚaicona'me anuli al barco lotseya locuena quiƚya' cuftine Antioquía. Pablo y Bernabé limajmpá jiƚpe Antioquía lapimaye ummempola' tiyenƚe, ti'etsa lanic' lapi'ipola' ȽanDios. Ixa'huepá titoc'itsola'. Itsiya joupa ixhuai'nipá lanic'. Ticuaiconata. ");
INSERT INTO chdNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Icuaitsa Antioquía. Ijoc'im'mola' lapimaye iƚne nefot'ƚepoƚtsi jiƚpe liƚya'. U'im'mola' jahuay li'ipola' lan xanuc' pe a'ij judío. ȽanDios joupa iƚonc'epa lipa'nepola'. Iƚniya jouc'a titsuflaiyi lane, ti'huaiyijnyi Jesucristo. ");
INSERT INTO chdNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jiƚpiya liƚya' Antioquía icoƚ'mola'. Imanenca anuli ts'ilihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Icuaitsa liƚya' Antioquía hualca lapimaye ts'ilihuequi Jesús quiyouyomma al distrito Judea, ipango'me imuc'iyale'me. Tu'innila' lapimaye nomana' jiƚpe liƚya': ―Tolanant'ƚiƚe locuxepa Moisés, tonƚ'etsoƚtsi circuncidar. Ja'ni a'i, aimi'iya molunƚulyacu. ");
INSERT INTO chdNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo y Bernabé ifuli'imoƚtsi cataiqui' iƚne lapimaye, aiquentenƚcocola' lomuc'iyalepa. Lijou'ma lapimaye ixpic'e'me tiyeƚe Jerusalén Pablo y Bernabé jouc'a hualca lapimaye nomana' jiƚpe Antioquía. Pu'hua Jerusalén tipalaic'onnola' lan apóstole y lapimaye noxpijpá lataiqui'. Ticuis'ennola': “Imanc', ¿te coƚcuapa? Laƚpimaye pe a'ij judío, ¿ja'ni ti'e'moƚtsi circuncidar o a'i?” ");
INSERT INTO chdNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ipalunca Pablo, Bernabé y liƚejmale lun Antioquía. Locuenaye lapimaye lafoƚyomma jiƚpe Antioquía ecanumf'entsacane. Uyalaico'me ƚamats' Fenicia jouc'a ƚamats' Samaria. Jiƚpe ƚiƚeloƚya' ipalaicom'mola' lapimaye, uya'a'me iƚe li'ipola' lan xanuc' a'ij judío, ticuayi: “Ipai'ipá liƚpicuejma', tihuejyi Jesús”. Licuej'me toƚta'a li'ipa jahuay lapimaye ixoconni quileta juaiconapa. ");
INSERT INTO chdNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablo, Bernabé y liƚejmale icuaitsa liƚya' Jerusalén. Lapimaye lafoƚyomma jiƚpe, lan apóstole jouc'a lapimaye noxpijpá lataiqui', epenufim'mola'. Pablo y Bernabé uya'a'me jahuay li'ipa, uya'a'me acueca' litoc'ipola' ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Jiƚpe Jerusalén timana' hualca lan xanuc' fariseo no'huaiyijmpá ƚaƚPoujna Jesucristo. Iƚne ecaxoƚ'me, ticuayi: ―Lapimaye pe a'ij judío tenant'ƚiƚe locuxepa Moisés. Ti'etsoƚtsi circuncidar. ");
INSERT INTO chdNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Efot'ƚe'moƚtsi lan apóstole jouc'a lapimaye noxpijpá lataiqui'. Icuis'e'moƚtsi: “¿Te caƚspic'eyacu?” ");
INSERT INTO chdNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ipalaic'o'moƚtsi juaiconapa. Lijouco'ma ecax'ma Pedro. Timila': ―Cunc'aipimaye, joupa oƚsina' li'ipa. ȽanDios aƚmuc'iponga' naitsi no'huaya pe lomana' locuenaye lan xanuc', iƚne a'ij judío. Aƚ'huijf'epa ca'huaƚa' iya', cuya'atsi Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios, ti'huaiyijnle Jesucristo. ");
INSERT INTO chdNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Li'huaiyijm'me Jesucristo ȽanDios ipaxne'mola' to laƚpaxneponga' illanc'. Epi'ipola' cal Espíritu Santo. Toƚta'a imujpa aƚinca ti'huaiyijnyi Jesucristo. ȽanDios aimimenajya, timetsaicola' jahuay lan xanuc', te ts'i'ic' liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Iƚniya, illanc', ma' anuli lapenufponga'. Laƚ'huaiyijmpá Jesucristo latufc'e'eponga' laƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","’Itsiya, ¿te colahuaicopá ȽanDios? Imanc' toƚcuayi: “Aƚcuxe'e'mola' laƚpimaye tihuejcoƚe jahuay locuxepa Moisés”. Iya' cacua: Laƚtatahueló aiquilenant'ƚi iƚe lataiqui', ni illanc' aicalanant'ƚi, aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Joupa i'ipa caƚsina' ma le'a Jesucristo aƚtoc'i'monga'. Iƚque aƚsimponga' ninc'icuanuc'la, lunƚu'e'monga'. Ma' anuli tunƚu'e'mola' iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Lapimaye lafoƚyomma jiƚpiya ailopa'a cotalai'ecoyacu. Iquimf'e'me loya'apa Pablo y Bernabé muya'ayi al cueca' li'epa ȽanDios pe lomana' locuenaye lan xanuc', iƚne a'ij judío. Uya'a'me li'ipa ma mi'eyi lipenic' ȽanDios. Iƚque joupa epi'ipola' liƚmane, toƚta'a i'e'me to aimi'iya mi'eyacu lan xanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lijoupa luya'apa toƚta'a Jacobo ipalaic'o'mola' lapimaye lefot'ƚepoltsi, timila': ―Cunc'aipimaye, aƚquimf'eƚa'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro alu'iponga' li'ipa litine ȽanDios imuj'moxi pe lomana' locuenaye lan xanuc', iƚne a'ij judío. Iƚe litine ipango'ma ijoc'i'mola' tihuejcoƚe, ti'iƚa' quixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lam profeta joupa uya'apá toƚta'a lo'eya ȽanDios. Jiƚpe liƚje'e iniƚijmpá lonespa ȽanDios, ticua: ");
INSERT INTO chdNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Tijouƚa' catoc'icona'mola' laixanuc'. Iya' capi'i'mola' laixanuc' ƚiƚrey, cal rey David itatahuelo. ");
INSERT INTO chdNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Toƚta'a locuenaye lan xanuc' tehuena'me ƚiƚPoujna, iƚne a'ij judío pe joupa nimetsaicopola' aixanuc', maƚniya lahuena'ma. ");
INSERT INTO chdNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Toƚta'a linespa ȽanDios No'epa jahuay iƚna'a. Joupa imuc'ipola' lan xanuc' nomana' luyaipa quitine. ");
INSERT INTO chdNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jacobo ti'hua tipalaic'ola' lipimaye, timiconala': ―Iya' cacua: Iƚne laƚpimaye a'ij judío pe joupa ixhuej'menamma, tihuecoyi ȽanDios, aimaƚpa'ne'mola'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Alumme'e'mola' quiƚje'e, lu'i'mola': “Imanc' aimoƚte'me lixic' litsufcompola' landiosla'. Iƚque cal tejua' joupa i'ipa quixcay. Toƚ'etsoƚtsi cuenna. Aimoƚsuico'mola' ocuenaye cacaƚ'no', ma' le'a loƚpenoye. Aimoƚte'me liƚpixic' linneja lixnajmpola' cajuats', jouc'a aimoƚte'me lajuats'.” ");
INSERT INTO chdNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","’¿Te caƚcuxe'ecoyacola' xonca? Jiƚpiya ƚajut'ƚi pe lafoƚyomma laƚf'as xanuc' judío, itine itine conxajya tixhuef'yi locuxepa Moisés. Ixhuaita axpe' camats' toƚta'a mi'eyi jahuay ƚiƚeloƚya'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Lan apóstole jouc'a lapimaye noxpijpá lataiqui', jouc'a jahuay lapimaye lafoƚyomma jiƚpe Jerusalén i'e'e'moƚtsi anuli liƚpicuejma'. Ticuayi: ―Aƚ'huijf'e'mola' laƚpimaye. Alumme'mola' tiyeƚe Antioquía. Tiyejmaleƚe Pablo y Bernabé. I'huijf'em'mola' Judas ƚacui'impa Barsabás jouc'a Silas. Iƚne liƚpimaye tixininnila' ac'a liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ini'impola' al je'e, tini'innola' lapimaye a'ij judío. Iƚe al je'e tuya'e': “Illanc' ninc'apóstole, ninc'atsila' capimaye naƚspic'epá lataiqui', aƚnonilhuo' imanc' a'ij judío, noƚmana' liƚya' Antioquía, jouc'a noƚmana' ni petsi ƚamats' Siria, jouc'a noƚmana' ƚamats' Cilicia. Imanc' illanc' ninc'apimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","’Joupa aƚmimponga' iƚe luya'apa hualca lapimaye lipalyomma fa'a. Iƚne imipolhuo': ‘Imanc' tolanant'ƚiƚe locuxepa Moisés. Tonƚ'etsoƚtsi circuncidar.’ Toƚta'a ixhueƚ'mipolhuo'. Toƚcuayi: ¿Te caƚ'eyacu? ’Itsiya lu'ilhuo': Illanc' aicalummela' iƚniya. Aicaƚmila': Toƚta'a toƚmitsola'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Illanc' naƚmana' fa'a joupa aƚ'e'epoƚtsi anuli laƚpicuejma'. Aƚspic'epá alumme'elhuo' iƚna'a laƚ'huijf'epola', tiyejmaleƚe laicaƚpimaye Pablo y Bernabé. ");
INSERT INTO chdNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iƚne coƚa' tima'mola' mi'eyi lipenic' ƚaƚPoujna Jesucristo, tocomma to aimunƚulyacu. ");
INSERT INTO chdNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Loquexi' laƚpimaye lalummepola', iƚne Judas y Silas tu'itolhuo' laƚspic'ejma', iƚe laliniƚpa iƚta'a al je'e. ");
INSERT INTO chdNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Illanc' y cal Espíritu Santo aƚspic'eyi a'ij cueca' laƚcuxe'eyacolhuo'. Fa'a lu'ilhuo' ma le'a oquej fane' loƚ'eyacu petsi xonca latenƚcocopa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Lu'ilhuo': ’Aimoƚte'me lixic' litsufcompola' landiosla'. Aimoƚte'me lajuats'. Aimoƚte'me liƚpixic' linneja lixnajmpola' cajuats'. Tonƚ'e'etsoƚtsi cuenna. Aimoƚsuico'mola' ocuenaye cacaƚ'no', ma le'a loƚpenoye. ’Ja'ni toluyalaico'me toƚta'a tonƚ'e'me al c'a. Itsiya icula'apa iƚe laƚsc'ai'ipolhuo'.” ");
INSERT INTO chdNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Lapimaye nomana' Jerusalén ixc'ai'im'mola' Pablo, Bernabé y liƚejmale. Iƚne iye'me. Icuaicontsa Antioquía. Jiƚpiya ijoc'im'mola' lapimaye tefoƚunca. Ini'im'mola' al je'e. ");
INSERT INTO chdNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Lapimaye ininuf'me ixhue'me. Iƚe loxc'ai'impola' ixoc'i'mola' quileta. ");
INSERT INTO chdNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iƚne Judas y Silas aprofeta. Juaiconapa ixc'ai'im'mola' lapimaye, ifa'em'mola' liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jiƚpiya imanenca, icoƚ'mola'. Icuaitsi litine tiyenƚe lapimaye ixc'aitsona'me, timinnila': ―Tonƚenƚe al c'a. Toƚpailinanca, tonƚenƚe pe lomana' iƚne nummepolhuo'. Toƚmitsola': “Ailopa'a tintsi”. ");
INSERT INTO chdNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas ixpic'epa tipanehuo Antioquía. ");
INSERT INTO chdNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo y Bernabé imanenca jiƚpe liƚya' tuya'ayi, timuc'iyaleyi Lataiqui'. Iƚe litaiqui' ƚaƚPoujna. Ma' anuli lo'epa axpela' lapimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ti'hua tuyaipa ƚitiné. Lijou'ma Pablo ipalaic'o'ma Bernabé, timi: ―Ƚepá, ƚeconapá jahuay ƚiƚeloƚya' petsi joupa laluya'apa litaiqui' ƚaƚPoujna. Aƚsinna te ts'i'ic' mimana'. ");
INSERT INTO chdNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé ticua: ―Aƚƚecocona'me Juan Marcos, aƚejmalecona'me. ");
INSERT INTO chdNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablo timi: ―A'i. Laƚcuaitsa ƚamats' Panfilia iƚque aƚpo'noponga' caƚtuca'. Aiqui'e'ma canic' anuli illanc'. Aimaƚƚecocona'me. ");
INSERT INTO chdNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ipalaic'o'moƚtsi juaiconapa. Ifuli'i'moƚtsi cataiqui'. Lijouco'ma anuli anuli i'hua'ma lipene. Bernabé ileco'ma Marcos, itsulfoƚai'me anuli al barco, iye'me Chipre. ");
INSERT INTO chdNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo i'huijf'e'ma Silas. Pablo y Silas y lapimaye efot'le'moƚtsi. Ijoc'i'me ȽanDios. Ixa'hue'me titoc'itsola' Pablo y Silas. Lijou'ma ipalunca iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Iye'me ƚamats' Siria jouc'a ƚamats' Cilicia. Pablo ipalaic'o'mola' lapimaye ni petsi lafoƚyomma. Ifa'e'mola' liƚpicuejma'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo y Silas icuaitsa liƚya' Derbe, uyalaico'me, icuaitsa Listra. Jiƚpe liƚya' tipa'a anuli ƚamijcano cuftine Timoteo. Qui'máma' ajudía, ti'huaiyinge Jesucristo. Qui'ailli' agriego. Timoteo tihuequi Jesús. ");
INSERT INTO chdNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lapimaye, iƚne nomana' Listra, jouc'a nomana' Iconio ticuayi: “Ac'a xans Timoteo”. ");
INSERT INTO chdNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo ixpic'epa tiyejmale'me. Ai'a tileco'ma i'e'ma circuncidar. Ticua: “Toƚta'a aimixtulecu lan xanuc' judío nomana' fa'a ƚamats'”. Jahuay iƚniya iƚsina' qui'ailli' Timoteo agriego. Toƚiya Timoteo aiqui'aic' circuncidar. ");
INSERT INTO chdNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lijou'ma Pablo, Silas y Timoteo iyehuo'me iƚya' iƚya', ehuengintsola' lapimaye nomana'. Imuc'im'mola' al je'e loya'apa locuxepa lan apóstole y lapimaye noxpijpá lataiqui', iƚne nomana' Jerusalén. Tixc'ai'innila', tu'innila' tenant'ƚiƚe iƚe lataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Toƚta'a lapimaye lafoƚyomma iƚniya ƚiƚeloƚya' xonca ti'huaiyijnyi. Itine itine tixpela' lapimaye. ");
INSERT INTO chdNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Lijou'ma, ehuengintsola' lapimaye nomana' ni petsi ƚamats' Frigia y ƚamats' Galacia. Aiquiƚtsuflaic' ƚamats' Asia. Cal Espíritu Santo aiquepi'ila' lane muya'ayacu Lataiqui' jiƚpe ƚamats'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Icuaitsa ƚema ƚamats' Misia ixpic'epa titsulfoƚaitsa ƚamats' Bitinia. Cal Espíritu, iƚque ƚi'Espíritu Jesús, aiquepi'ila' lane. ");
INSERT INTO chdNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ti'hua tiyeyi ƚema ƚamats' Misia. Imul'me liƚya' Troas. ");
INSERT INTO chdNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lipuqui' Pablo ixim'ma al paiyo. ȽanDios timuc'i lo'eya. Ixim'ma tecaxu anuli cal xans ƚas Macedonia. Tixa'hue, timi: “To'huanni fa'a ƚainemats' Macedonia. Fa'a aƚtoc'i'monga'.” ");
INSERT INTO chdNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Iƚe liximpa Pablo alu'iponga' illanc' laƚejmale. Aƚspic'epá ƚe'me ƚamats' Macedonia. Aƚcuayi: Ma ȽanDios aƚjoc'iponga', alu'itsonga' lan xanuc' nomana' jiƚpe ƚamats' Lataiqui' loya'apa iƚe al c'a lixpic'epa ȽanDios. ");
INSERT INTO chdNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jiƚpe Troas aƚtsulfoƚaipá anuli al barco. Aƚepá ƚijca ƚamats' cuftine Samotracia. Lihuequi litine aƚcuaitsa liƚya' Neápolis. ");
INSERT INTO chdNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Lipalyonca al barco aƚepá Filipos. Iƚe liƚya' xonca imetsaicoquiya jiƚpe ƚamats' Macedonia, i'huexi cal cuecaj quincuxepa romano. Jiƚpe aƚcoƚponga'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Litine conxajya lipalunca liƚya', aƚepá petsi tefot'ƚeyoƚtsi lan xanuc' mijoc'i'me ȽanDios, jiƚpe al pana'. Aƚcutsoƚanna, aƚpalaic'opola' lacaƚ'no' licuai'me. ");
INSERT INTO chdNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Anuli jiƚne lacaƚ'no' lipuftine aLidia. Tihuequi locuxepa ȽanDios. Lipiƚya' cuftine Tiatira. Ticuqui quijahua' lumanc'ecompa amorada. ȽaƚPoujna epi'ipa lipicuejma' icuej'ma lonespa Pablo. ");
INSERT INTO chdNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ƚaca'no' Lidia jouc'a jahuay nomana' lejut'ƚ epo'im'mola'. Lijou'ma Lidia aƚsa'hueponga', aƚminga': ―Ja'ni imanc' aƚsimpa iya' nepenufpa ƚaƚPoujna ƚepá lainejut'ƚ. Jiƚpe aƚmanc'aleta. Ihui'i'ma. Aƚehuo'me lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Anuli litine maƚeyi petsi aƚjoc'ita ȽanDios aƚtalecuf'me anuli ƚahuats'. Lipoujnalá joupa i'napá, ticuxeyi. Ƚahuats' ticua'e, ticuxe lipicuejma' anuli ƚiponta'a Satanás. Timila' lan xanuc' lo'iyacola'. Toƚta'a tuliqui juaiconapa acueca' tomí. Tepi'ila' lipoujnalá. ");
INSERT INTO chdNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Illanc' aƚejmaleyi Pablo. Ƚahuats' alihuequinga'. Tija'e', ticua: ―Toƚsintsola' iƚna'a lan xanuc'. Cal Cueca' CanDios iƚPoujna iƚna'a. Tu'ilhuo' te co'iya molunƚulyacu. ");
INSERT INTO chdNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tuyaipa axpe' quitine mi'ay toƚta'a ƚahuats'. Pablo aiquetenƚcocojma lo'epa. Tixhueƚmot'ƚe juaiconapa. Lijouco'ma ipai'e'moxi, ehuelojm'ma ƚahuats', ipalaic'o'ma ƚonta'a, timi: ―Cajoc'i ƚaiPoujna, canesma lipuftine Jesucristo. Toƚta'a cacuxe'ehuo': Taipananni lipicuejma' iƚca'a ƚahuats'. Aiquicoƚ'ma. Ipananni ƚonta'a. ");
INSERT INTO chdNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Lipoujnalá ƚahuats' iximpá ixaƚconapa, ixtulenca. Iƚsina' aimi'iya mulijconayacu quiƚtomí. I'noƚim'mola' Pablo y Silas, exaƚim'mola' jiƚpiya pe lomana' ts'iƚpenic'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","I'hua'am'mola' pe lomana' lan juez romano. Timinnila': ―Iƚne lan xanuc' ajudío, fa'a laƚpiƚya' tehueyi cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Aƚmuc'inga' aƚpai'inga' laƚ'ejma'. Illanc' ma lihuejcoyi cal cuecaj quincuxepa romano. Ma' iƚque aƚcuxenga'. Aimi'iya malapenufyacu ocuena cataiqui'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jahuay lefoƚya jiƚpiya ixtuc'om'mola' Pablo y Silas. Lan juez icuxe'me texitsoquintsola' Pablo y Silas, titsimafquintsola' liƚspula'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Itsimafquim'mola' juaiconapa. Ecanc'ontsola' lacarza. Icuxe'e'me cal xans no'epa cuenna lacarza, timiyi: ―To'etsola' cuenna iƚna'a lan xanuc'. Aimipalcu. ");
INSERT INTO chdNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Licuejpa toƚta'a no'epa cuenna lacarza i'nicotsola' xonca licu'u cacarza. Icansc'om'mola' liƚ'mitsi' laxma. Aimipalyacu, aimi'iya. ");
INSERT INTO chdNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Li'i'ma to nolojmay quipuqui' Pablo y Silas tijoc'iyi ȽanDios, tunac'liyi timiyi: “ManDios, ima' unCueca'”. Locuenaye litats'ila' tiquimf'eyi. ");
INSERT INTO chdNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Inu'ma ƚunanto. Tifenna ƚamats' petsi lifayiya ƚaitaƚ lacarza. Aiquicoƚ'ma, exinni jahuay lam puerta. Jahuay litats'ila' ixim'moƚtsi uhuaiƚquem'mola' latejmaj cadena. ");
INSERT INTO chdNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Cal xans no'epa cuenna lacarza tixmay. Imaf'i'ma ixim'ma lam puerta exiya. Ticua: “Itsiya, ¿te caif'eya? Joupa ipalnamma litats'ila'”. Ipa'a'ma li'espada. Ticua: “Cama'a'moxi”. ");
INSERT INTO chdNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablo ixim'ma lo'eya. Ija'a'ma ujfxi, timi: ―Aimo'e'e'moxi. Ma fa'a aƚmana' jahuay illanc'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","No'epa cuenna lacarza icuxe'e'ma tulif'enƚe. Aiquicoƚ'ma, itsufai'ma pe lomana' litats'empola'. Eca'ni'moxi jiƚpe liƚ'mitsi' Pablo y Silas. Tiyu tixpaiqui. ");
INSERT INTO chdNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tipa'ala' ƚuna. Ticuis'ela', timila': ―Cunc'ixanuc', ¿te co'iya cunƚu'eyacoxi? ¿Te caif'eya? ");
INSERT INTO chdNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Iƚne timiyi: ―Ima' to'huaiyijnla' ƚaƚPoujna Jesucristo, iƚque tunƚu'e'mo'. Toƚta'a ti'eƚe iƚne nomana' lomejut'ƚ. Jouc'a tunƚu'e'mola' jahuay iƚniya. ");
INSERT INTO chdNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","U'i'me litaiqui' ƚaƚPoujna. U'im'mola' jouc'a nomana' lejut'ƚ. ");
INSERT INTO chdNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Maƚpe 'hora lipuqui' no'epa cuenna lacarza ileco'mola' Pablo y Silas, epac'e'etsola' ƚilehui. Aiquicoƚ'mola', epo'im'mola' iƚque y jahuay lixanuc'. ");
INSERT INTO chdNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Lijou'ma ileco'mola' lejut'ƚ Pablo y Silas. Ites'mitsola'. Juaiconapa tixoqui queta ti'huaiyinge ȽanDios. A'i ma le'a iƚque jouc'a jahuay lixanuc' ti'huaiyijnyi. ");
INSERT INTO chdNT_vpl VALUES (