﻿USE sofia;
DROP TABLE IF EXISTS sofia.cha_vpl;
CREATE TABLE cha_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cha_vpl WRITE;
INSERT INTO cha_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","DICHOSO y taotao, ni ti mamomocat gui pinagat y manaelaye, ni y ti sumasaga gui chalan manisao, ni y ti matatachong gui siyan ayo sija y manmanmofefea. ");
INSERT INTO cha_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Lao guiya lay Jeova, ayo y minagofña, ya y layña jajaso, jaane yan puenge. ");
INSERT INTO cha_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Ya taegüijeja y trongcon jayo ni y matanme gui oriyan sadog, ya guaja tinegchaña gui tiempoña, ya y jagonña ti umalayo; ya todo y finatinasña mumemegae. ");
INSERT INTO cha_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Lao ti taegüine y manaelaye; lao parejo yan y paja ni y güinaefe ni y manglo. ");
INSERT INTO cha_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Sa enao na ti mangajujulo y manaelaye gui sentensia; ni y manisao gui y inetnon manunas. ");
INSERT INTO cha_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Sa si Jeova jatungo y chalan manunas: lao y chalan manaelaye ufanmalingo. ");
INSERT INTO cha_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","SA jafa na manlalalo y nasion sija, ya y taotao sija manmanjaso y banida? ");
INSERT INTO cha_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Manotojgue y ray sija gui tano, ya y prinsipe sija manafaesen entalo sija contra si Jeova, yan contra y pinalaeña, ilegñija: ");
INSERT INTO cha_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Nita yulang y guinideña, ya nasuja guiya jita y godeña. ");
INSERT INTO cha_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Ya y sumasaga gui langet uchumachaleg: ya y Señot jamofefea sija. ");
INSERT INTO cha_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Ayo nae cumuentos yan sija yan y linalaloña: ya y binibuña ninafañatsaga sija. ");
INSERT INTO cha_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Lao guajo japolo y rayjo gui jilo Sion, gui santos na egsojo. ");
INSERT INTO cha_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Guajo bae jusangan y tinagojo: si Jeova ilegña nu guajo: Lajijo jao; ya guajo julilis jao pago na jaane. ");
INSERT INTO cha_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Gagaoyo ya guajo junaejao ni y nasion sija pot y erensiamo ya y uttimon patte y tano, uiyomo. ");
INSERT INTO cha_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ya unyulang sija ni y baran lulog; taegüije y bason y yero unyogyog sija. ");
INSERT INTO cha_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Ya pago, tingo, O ray sija: resibe finanagüe, jamyo man jues gui tano. ");
INSERT INTO cha_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Setbe si Jeova ni y minaañao, yan fanmagof ni minayengyong. ");
INSERT INTO cha_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Chico y laje, no sea ulalálalo, ya unfanmalingo jamyo gui chalan, sa gusisija y linalaloña sinenggue. Mandichoso todos y umangoco sija guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","JEOVA, jafa muna manlajyan y enimigujo! Megae mangajulo contra guajo. ");
INSERT INTO cha_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Megae umaalog ni y antijo: Taya inayuda para güiya, gui as Yuus. Sila. ");
INSERT INTO cha_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Lao jago, O Jeova, jago y patang gui oriyajo; y minalagjo yan ayo ni y janacajulo y ilujo. ");
INSERT INTO cha_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Ya y inagangjo juagang si Jeova, ya güiyaja umopeyo gui santos na ogsoña. Sila. ");
INSERT INTO cha_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Bae juason ya maegoyo; ya magmatayo; sa si Jeova gumuguutyo. ");
INSERT INTO cha_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Ti maañaoyo nu y dies mit na taotao, ni y mapolo sija gui oriyajo contra guajo. ");
INSERT INTO cha_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Cajulo, O Jeova; nalibre yo, O Yuusso: sa jago manalamen todo y enimigujo ni y guijadas; y nifen y manaelaye unyamag. ");
INSERT INTO cha_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Gui as Jeova nae gaegue y satbasion: ya y taotaomo nae gaegue y bendisonmo. Sila. ");
INSERT INTO cha_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","ANAE juagangjao, opeyo, O Yuus y tininasso: anae chatsagayo jago munadangculoyo: maase nu guajo ya jungog y tinaetaejo. ");
INSERT INTO cha_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Jamyo, famaguon taotao, asta ñgaean nae innanalo y onraco gui minamajlao? Asta ñgaean yanmiyo y banida ya inaliligao y dinague? Sila. ");
INSERT INTO cha_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Tingoja, na si Jeova japolo apatte y deboto para güiya namaesa: si Jeova jajungog yo, anae juagang güe. ");
INSERT INTO cha_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Fangalamten ya chatmiyo faniisao: fanmanjaso nu y corasonmiyo gui jilo camanmiyo, ya famacaca. Sila. ");
INSERT INTO cha_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Nae y tunas na inefresen ya angoco si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Megae umaalog: Jaye ufanuejit jafa minauleg? Jatsa gui jilonmame, O Jeova, y minalag y matamo. ");
INSERT INTO cha_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Jago numae minagof y corasonjo, megaeña qui uguaja sija anae umemegae y maeisñija yan y binoñija. ");
INSERT INTO cha_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ya y pas nae umason yo ya taegüijeja maegoyo: sa jagoja Jeova, unnasagayo seguro. ");
INSERT INTO cha_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","JUNGOG, O Jeova, y sinanganjo, ecungog y jinasoco. ");
INSERT INTO cha_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ecungog y vos y inagangjo, Ray jo, yan Yuusso: sa jago jutaetaetaye. ");
INSERT INTO cha_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","O Jeova, y egaan unjungog y vosso; y egaan juguaguato y tinaetaejo guiya jago, ya jubébela. ");
INSERT INTO cha_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Sa ti jago na Yuus ni y gumaeya y tinaelaye: y taelaye ti usaga guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ti manasaga y mangaduco gui menan matamo: ya ti yamo todo y fumatitinas y taelaye. ");
INSERT INTO cha_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Jago yumulang y manguecuentos mandague: ya y taotao cajâgâ yan y dinague, si Jeova jaguefchatlie. ");
INSERT INTO cha_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ya guajoja, yan y megagae y minaasemo, bae jalom gui guimamo: ya juadora anae juatan y santo templomo ni y ninamaañaomo. ");
INSERT INTO cha_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Jeova, esgaejonyo gui tininasmo, pot causa ya enimigujo; natunas gui menajo y chalanmo. ");
INSERT INTO cha_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Sa taya finitme gui pachotñija; ya sanjalomñija senmanaelaye: naftan mababa y agagañija; yan y jilañija finande: ");
INSERT INTO cha_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Condena sija, O Yuus, polo y ufamodong pot y pinagatñija: gui minegae y isaoñija nasuja sija sa managuaguat contra jago. ");
INSERT INTO cha_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Nafanmagof todos y umangngocojao, polo para taejinecog ya ufanagang pot y minagofñija sa undefiende sija, polo ya ufanmagof ni jago, y gumaeya y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Sa jago bumendise y manunas; O Jeova, parejoja yan un patang unpolo gui oriyaña y finaborese. ");
INSERT INTO cha_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","JEOVA chamoyo lumalalatde ni y binibumo: chamoyo cumastitiga nu y dangculo na linalalomo. ");
INSERT INTO cha_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Gaease nu guajo, O Jeova, sa estagüe yo namasogsog: amte yo, O Jeova, sa y tolangjo esta mananatchatsaga. ");
INSERT INTO cha_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Ya y antijo esta senchatsaga: Ya jago, O Jeova, asta ngaean? ");
INSERT INTO cha_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Nanalo, O Jeova, nalibre y antijo: satbayo pot causa y minaasemo. ");
INSERT INTO cha_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Sa y finatae nae taya jinaso guiya jago: ya y naftan nae jaye numannae jao grasias? ");
INSERT INTO cha_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Yayasyo nu y todo y siningonjo: todo y puenge junamamaya y camajo ni lagojo: junafotgon y catreco nu y lagojo. ");
INSERT INTO cha_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Y atadogjo esta magasta nu y pinite: ninafanbijo pot todo ayo y munachachatsaga yo. ");
INSERT INTO cha_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Nafanjanao guiya guajo todo ayo y fumatitinas y taelaye: sa si Jeova jajungog y vos y casaojo. ");
INSERT INTO cha_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Si Jeova jajungog y guinagaojo: si Jeova uresibe y tinaetaejo. ");
INSERT INTO cha_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Manmamajlao ya ninafañatsaga megae, todo y enimigujo: sija manalo, sija manmamajlao gusise. ");
INSERT INTO cha_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","O Jeova, Yuusso, yya jago nae gaegue y inangococo: Satbayo todo gui pumetsisigue yo, ya nalibre yo. ");
INSERT INTO cha_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Para chaña pumedasitos y antijo taegüije y leon, ni jayulang, anae taya jaye uninalibre. ");
INSERT INTO cha_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Jeova, Yuusso, yaguin jufatinas este: yaguin guaja gui canaejo taelaye; ");
INSERT INTO cha_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Yan juapase taelaye y sumaga guiya guajo yan pas, (magajet na junalibre y pumetsisigue yo pot taya causa:) ");
INSERT INTO cha_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Japetsisigue y enimigujo y antijo, ya jachule; magajet, na jagacha gui tano y jaanijo: ya y onraco japolo gui eda. Sila. ");
INSERT INTO cha_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Cajulo, O Jeova, yan y linalalomo; jatsa namaesa contra y binibon y munachachatsagayo: ya magmata pot guajo untago y sentensia. ");
INSERT INTO cha_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Polo ya y inetnon taotao unineriyaye jao: ya gui san jiloñija natalo jao guato gui san jilo. ");
INSERT INTO cha_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Si Jeova jajusga y taotao: jusgayo, O Jeova, taemanoja y tininasso: taemanoja y minaulegmo ni y gaegue guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Polo ya ujocog y taelayen manaelaye, lao nafitme y manunas: sa si Yuus, ni tinas, jachachague y corason yan y jinaso gui sanjalom. ");
INSERT INTO cha_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Y patangjo gaegue gui as Yuus, güiya munalibre y manunas gui corason. ");
INSERT INTO cha_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Si Yuus y tinas na jues: magajet na si Yuus lalalalo todo na jaane. ");
INSERT INTO cha_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Yaguin y taotao ti jabira güe, güiya janamalagtos y espadaña: janaregla y atcosña ya janalisto. ");
INSERT INTO cha_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ya jafatinas para güiya y atmas y finatae: janafañila y flechaña. ");
INSERT INTO cha_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Estagüe na uguaja piniten mañago tinaelaye: magajet na mapotgue y inacacha ya mañago dinague. ");
INSERT INTO cha_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Jaguadog y tipo, ya janatadong: ya esta podong gui joyo na y finatinasñaja. ");
INSERT INTO cha_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Polo ya y inacachaña ubira güi jilo y iluña: ya y binibuña upodong gui jilo cácagongña. ");
INSERT INTO cha_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Bae junae si Jeova gracias taemanoja y tininasña: ya jucantaye ni y tinina y naan Jeova Gueftaquilo. ");
INSERT INTO cha_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","O Jeova, Señotmame, jafa muna mauleg y naanmo gui todo y tano: ni y unpolo y minalagmo gui jilo y langet. ");
INSERT INTO cha_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Guinin pachot y mandiquique yan y mañususo nae unpolo y minetgot? Pot y enimigumo sija: sa para unnasuja y enimigo yan y umeemog. ");
INSERT INTO cha_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Anae julie y langetmo, ni y checho y calolotmo, y pilan yan y pution, ni jago pumolo; ");
INSERT INTO cha_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Jaye y taotao, para uguaja guiya güiya jinaso? yan lajin taotao para ubinesita güe. ");
INSERT INTO cha_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Sa unfatinas didide diquiqueña qui y angjeles, ya uncorona güe ni y minalag yan inenra. ");
INSERT INTO cha_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Unnafanmagas todo ni checho y canaemo: todo unpolo gui papa y adengña. ");
INSERT INTO cha_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Y quinilo yan y nobiyo todo ayo: taegüenaoja y gâgâ ni gaegue gui fangualuan. ");
INSERT INTO cha_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Y pajaro gui langet, yan y güijan gui tase: ya jafaja ni manmalolofan gui chalan y tase. ");
INSERT INTO cha_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Jeova, Señotmame: jafa muna mauleg y naanmo gui todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","BAE junae grasias si Jeova contodo y corasonjo: bae jufanue todo ni ninamanman na chechomo. ");
INSERT INTO cha_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Bae jumagof, ya unnasenmagofyo guiya jago: jucantaye ni y tinina y naanmo O jago Gueftaquilo. ");
INSERT INTO cha_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Anae y enimiguja unnabira sija tate: manbasnag, ya manmalingo gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Sa jago fumatinas y jinasoco yan y causaco: unfatachong gui trono, ya unjusga y tinas. ");
INSERT INTO cha_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Guinin unlalatde y nasion sija, guinin unyulang y manaelaye, guinin unfunas y naanñija para siempre taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Esta malachae y enimigo; esta mayulang para siempre: yan y siuda ni y inyilang, y jinasoñija manachamalingo yan sija. ");
INSERT INTO cha_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Ya si Jeova sumaga calang ray para siempre, ya janalisto y tronuña para usentensia. ");
INSERT INTO cha_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ya güiya jumusga y tano ni tininas, ujajusga y taotao sija yan y minagajet. ");
INSERT INTO cha_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Ya si Jeova locue y taquilo na tore para y manmachiguit, y taquilo na tore gui tiempon chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Ya jaangoco sija guiya jago y tumungo y naanmo; sa jago, Jeova, ti unyute ayo y umaliligao jao. ");
INSERT INTO cha_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Cantaye si Jeova ni y tinina ni sumasaga gui Sion: namatungo gui entalo taotao sija y checoña. ");
INSERT INTO cha_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Sa anae jacocobla y jâgâ jajaso sija: ya ti malefa ni inagang y mamoble. ");
INSERT INTO cha_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Gaease nu guajo, O Jeova; atan y pinitejo ni jususungonja y chumatlie yo, jago y munacajulo yo gui pettan finatae: ");
INSERT INTO cha_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Para jufamanue todo ni y tininamo gui trangcan y jagan Sion: ya umagof yo gui satbasionmo. ");
INSERT INTO cha_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Unnafanmafondo y nasion gui joyo ni y finatinasñija: ya y casiyas nae ni janaaatog, y patasñija esta mangodon. ");
INSERT INTO cha_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Si Jeova janamatungo güe ni y sentensia ni jafatinas; ya jalaso y taelaye ni y checho y canaena: Jinaso. Sila. ");
INSERT INTO cha_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Ufanmanalo guato y manaelaye gui sasalaguan: yan todo y taotao ni manmalefa as Yuus. ");
INSERT INTO cha_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Sa ti para siempre umamalefanñaejon y nesesitao: ni y ninanggan y mamoble ufanmalingo para siempre. ");
INSERT INTO cha_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Cajulo, O Jeova: chamo munamametgot y taotao: ya ufanmajusga y nasion gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Polo, O Jeova, y minaañao guiya sija: polo ya utungo y nasion na sija taotaoja. ");
INSERT INTO cha_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","JAFA na tumojgue jao na chago, O Jeova? jafa na umatogjao gui tiempon chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Sa pot sobetbia y taelaye na japetsisigue y pebble; ufanmachule gui finababa y manmajajaso. ");
INSERT INTO cha_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Sa enao mina jatunanmaesagüe y taelaye, ni y minalago y antiña: ya y manlagga jarechasa; junggan, jadespresia si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Y taelaye pot y sobetbia y mataña, ilegña: ti jaaliligao si Yuus: Gui todo y jinasoña, jasangan: Taya Yuus. ");
INSERT INTO cha_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Y chalanña chatsaga todo y tiempo; y juisiomo goschago gui linieña: ya todo y enimiguña, güiya jaguaefe sija. ");
INSERT INTO cha_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ilegña gui corasonña: Ti jucalamten: gui todo y generasion sija, ti jufalag y chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Y matdision bula y pachotña yan dinague yan chiniguit: y papa y jilaña inacacha yan tinaelaye. ");
INSERT INTO cha_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Gaegue matatachong y lugat ti matungo gui sengsong: ya y umatog na lugat japupuno y taeisao: y atadogña manaatanja contra y pebble. ");
INSERT INTO cha_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Jananangga gui lugat ti matungo, taegüije y leon gui liyangña: jananangga para ucone y pebble: jacone y pebble anae jayotte ni y lasoña. ");
INSERT INTO cha_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Jacojajatgüe, janatunog, megae na manaeninasiña mamodong gui gaesisiña na iyoña. ");
INSERT INTO cha_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ylegña gui corasonña: Si Yuus esta malefa: janaatog y mataña; taya nae jalie. ");
INSERT INTO cha_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Cajulo, O Jeova; O Yuus, jatsa y canaemo: chamo malelefa ni y mamoble. ");
INSERT INTO cha_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Pot jafa jadespresia y taelaye si Yuus; ya ilegña gui corasonño: Jago ti ugagao. ");
INSERT INTO cha_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Jago lumie: sa jago umatan y inacacha yan y minattrata, para uchule gui canaemo: yya jago nae mandaña y mamoble: y manaesaena, jago umayuyuda. ");
INSERT INTO cha_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Yulang y canae y manaelaye: ya ayo y taelaye, aliligao jao y tinailayeña asta qui ti unsoda. ");
INSERT INTO cha_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Si Jeova Ray na para taejinecog yan taejinecog: ya y nasion esta manmalachae gui tanoña. ");
INSERT INTO cha_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Y minalago y manumitde jago jumungog, O Jeova: jago dumespopone y corasonñija, ungueguesecungog ni y talangamo: ");
INSERT INTO cha_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Para unjusga y manaesaena yan y mamoble: para chamo tumatalo munamaañao y taotao gui tano. ");
INSERT INTO cha_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","AS Jeova nae juangocoyo: jafa na ilegmo ni antijo: Gupo gui egsomo calang pajaro? ");
INSERT INTO cha_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Sa, estagüe, y manaelaye na jaaregla y atcos: jafamauleg y flecha gui taliña para uflecha gui jinemjom y manunas na corason. ");
INSERT INTO cha_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Yaguin y plinanta sija esta mayulang: jafa siña y manunas ujafatinas. ");
INSERT INTO cha_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Si Jeova gaegue gui santos na temploña; si Jeova, y tronuña gaegue gui langet; y atadogña manlilie yan y babaliña jachachague y famaguon y taotao. ");
INSERT INTO cha_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Si Jeova jachachague y manunas: lao y manaelaye, ya y gumaeya mandague, y antiña chumatlie. ");
INSERT INTO cha_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Uuchan y casiyas gui jilo y manaelaye: guafe yan asufre ya y manglo na mañila y patteña gui basuña. ");
INSERT INTO cha_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Sa y tinas Jeova; yaña y tinas: ya jaatan y manunas y mataña. ");
INSERT INTO cha_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","AYUDA, O Jeova, sa jocog mandeboto: sa jocog y manmauleg gui entalo y famaguon taotao. ");
INSERT INTO cha_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Masasangang taebale cada uno gui tiguangña: yan labios na jaande, yan doble na corason jasasangan. ");
INSERT INTO cha_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Si Jeova uutut todo y labios na jaande, yan y jila ni cumuecuentos mandangculo: ");
INSERT INTO cha_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Ayo na ujaalog: Pot y jilata na utagana; y labiosta iyota: jaye siña señot gui jilota? ");
INSERT INTO cha_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Sa y chiniguit y mamoble y an y inigong y mannesesitao: pago bae cajulo, ilegña si Jeova: guajo jupolo güi na seguro, ni y jaguaefeye. ");
INSERT INTO cha_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Sa y finijo Jeova, gasgas na finijo: calang salape na managasgas gui jotno gui jilo y tano: managasgas siete biaje. ");
INSERT INTO cha_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Jago, O Jeova, ni umadadaje sija, jago umantiene para taejinecog, guine este na generasion. ");
INSERT INTO cha_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Jijot gui oriya manjajanao y manaelaye: anae esta nacajulo y tinaelaye gui entalo y famaguon taotao. ");
INSERT INTO cha_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","ASTA ngaean, O Jeova, nae, umalefa jao guajo para taejinecog? asta ngaean nae unnaatog y matamo guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Asta ngaean nae jujaso y pinagat gui antijo, anae guaja pinite gui corasonjo todo y jaane? Asta ngaean nae ufangajulo y enimigujo guiya guajo? ");
INSERT INTO cha_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Jaso ya jungogyo, O Jeova, Yuusso: ina y atadogjo sija para mungayo maego gui maego finatae. ");
INSERT INTO cha_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Sa chaña umaalog y enimigujo: Jugana güe: sa chaña y enimigujo fanmamagof yaguin calamtenyo. ");
INSERT INTO cha_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Lao guajo, y minaasemo nae juangocoyo: ya umagof y corasonjo gui satbasionmo. ");
INSERT INTO cha_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Bae cantaye si Jeova: sa jafatinas y mauleg guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","YLEGÑA y taetiningo gui corasonña: Taya Yuus: sija manpotlilo, jafatinas y chatliion na chocho: taya ni uno ni y fumatitinas y mauleg. ");
INSERT INTO cha_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Si Jeova jaaatan desde y langet y jilo y famaguon taotao, para ulie cao guaja uno malate, yan jaaliligao si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Todos manlache; manjuyong potlilo todo; taya jaye fumatitinas y mauleg, taya ni uno. ");
INSERT INTO cha_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Ada ti jatungo todo y fumatitinas y taelaye? ni y jacacano y taotaojo, taegüije y chumochocho pan? ya si Jeova ti jaaagang. ");
INSERT INTO cha_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Ayo nae manlaolao ni minaañao: sa si Yuus gaegue gui rasan y manunas. ");
INSERT INTO cha_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ya y pinagat y pebble innamamajlao, sa si Jeova guinegüeña. ");
INSERT INTO cha_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Malago, y satbasion Israel mato guinin Sion! Anae jatalo si Jeova quinautiba y taotaoña, ayo nae magof si Jacob yan magof Israel. ");
INSERT INTO cha_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","JEOVA, jaye usaga gue tabernaculumo? jaye usaga gui santos na ogsomo. ");
INSERT INTO cha_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Y jumanao gui minauleg, ya y fumatitinas y tininas, yan y cumuecuentos magajet gui jalom corasonña. ");
INSERT INTO cha_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Y ti fafajiyunge ni jilaña, ni ti jafatitinas taelaye gui amiguña, ni usigue sumangan y minamajlao contra y tiguangña. ");
INSERT INTO cha_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Gui atadogña ninadespresiao ni y taotao áplacha, lao y maañao as Jeova jaonra: y manjula para dañoña namaesa ya ti jatolaeca. ");
INSERT INTO cha_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Y salapeña ti mannanae para ufangana, ni uchule y apas contra y taeisao: ya y fumatinas estesija ti siña cumalamten. ");
INSERT INTO cha_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","ADAJE yo, O Yuus: sa iya jago nae gaegue y inangococo. ");
INSERT INTO cha_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ylegmo, O antijo, as Jeova: jago Señotto: taya minaulegco yaguin taegüe guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Ya y mañantos ni mangaegue gui tano, sija manmagas ya todo y minalagojo gaegue guiya sija. ");
INSERT INTO cha_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Mumegae y piniteñija ni tumolaeca si Jeova pot otro Yuus: ti juofrese ni y inefreseñija na jâgâ, ni juchule y naanñija gui labiosso. ");
INSERT INTO cha_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Si Jeova y patten ni y ineredajo, yan y basujo: jago mumantietiene y fottunajo. ");
INSERT INTO cha_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Ya, y fottunajo upodong gui lugat na magof: magajet na bonito na ineredajo. ");
INSERT INTO cha_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Jubendise si Jeova, ni y japagat yo: ya an puenge nae jafananagüe yo y jinasoco gui san jalomjo. ");
INSERT INTO cha_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Si Jeova jupolo gui menajo para siempre: sa yaguin gaegue güe gui agapajo, ti siña yo manacalamten. ");
INSERT INTO cha_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Enao mina magof y corasonjo ya magof y inenrajo: locue y catneco sumaga seguro. ");
INSERT INTO cha_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Sa ti undingo y antijo gui naftan: ni unnae y santosmo para ulie y minitong. ");
INSERT INTO cha_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Unnatungoyo ni y chalan y linâlâ: binilan minagof y gaegue gui menamo: ya y agapa na canaemo guaja minagof para siempre. ");
INSERT INTO cha_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","JUNGOG, O Jeova, y taotao tunas: atituye y casaojo; guefecungog y tinaetaejo, na ti jumajanao gui labios dinagüe. ");
INSERT INTO cha_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Polo y menamo nae ya ujuyong y sentensiajo: lie ni y atadogmo y tininas. ");
INSERT INTO cha_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Jago guinin chumague y corasonjo; guinin unbisitayo gui puenge; guinin unchagueyo ya taya sinedamo: y jinasoco na ti manisagüe y pachotto. ");
INSERT INTO cha_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Para y finatinas y taotao, pot y finijo ni guinin y labiosmo, jumantiene yo gui san juyong y chalan ni y manyuyulang. ");
INSERT INTO cha_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Y pinecatto guiniut gui chalanmo, ya y adengjo ti susulong. ");
INSERT INTO cha_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Jagasja juagang jao, sa jago unope yo, O Yuus: naegueng guiya guajo y talangamo, ya jungog y sinanganjo. ");
INSERT INTO cha_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Fanue ni y minaasemo ni namanman, jago na unnalibre y umangoco sija guiya jago, guinin y ayosija ni mangajulo contra y agapa na canaemo. ");
INSERT INTO cha_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Adaje yo, taegüije y atilong y niñon mata, naatog yo gui papa y anineng papamo, ");
INSERT INTO cha_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Y menan y manaelaye ni y jumojoño yo: y gostaelaye y enimigujo ni majijujute yo. ");
INSERT INTO cha_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Manmaafuyot ni y linedoñija: ya y pachotñija cumuecuentos sobetbio. ");
INSERT INTO cha_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Y pinecatmame nae maoriyayejam pago: japolo y atadogñija para ujayutejam gui tano. ");
INSERT INTO cha_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Taegüije y león ni y gosmalago ni y naña: ya y león diquique ni y gaegue gui saga na umaalog. ");
INSERT INTO cha_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Cajulo, O Jeova, polo jao gui menaña, yute papa: libre y antijo gui manaelaye nu y espadamo. ");
INSERT INTO cha_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Gui taotao sija nu y canaemo, O Jeova, gui taotao ni y iyon tano, ayo na güinajaña gaegue gui estisija na jaane: ayo y tiyanña unabula nu y tesorumo: sija manjaspog y famaguon, ya polo y sebla y güinaja gui mandiquique na patgonñija. ");
INSERT INTO cha_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Guajo, yan y tininas julie y matamo: najong yo anae magmata yo gui pinarejumo. ");
INSERT INTO cha_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","JUGUAEYAJAO, O Jeova, y minetgotto. ");
INSERT INTO cha_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Si Jeova y achojo, y castiyujo, yan y nanalibrijo: Yuusso, metgot y achojo, juangoco yo guiya güiya; patangjo yan y cánggilon y satbasionjo, y leca na torijo. ");
INSERT INTO cha_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Bae juagang si Jeova, ni combiene na mannae todo ni y alabansa: taegüije bae julibre gui enimigujo. ");
INSERT INTO cha_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Mato guiya guajo y piniten finatae, ya y minilalag y tinaelaye janamaañaoyo. ");
INSERT INTO cha_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Y piniten naftan gaegue gui oriyajo, y lason finatae mato guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Y chinatsagaco nae juagang si Jeova, ya juagang y Yuusso: güiya jajungog gui temploña y vosso, ya y inagangjo gui menaña, jumalom y talangaña. ");
INSERT INTO cha_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Ayo nae y tano calamten ya mayengyong, ya y simiento sija y egso manmanyengyong yan mangalamten, sa güiya lalalo. ");
INSERT INTO cha_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Cajulo aso gui güiingña, ya guinin pachotña guafe manonggue y pinigan mañila pot este. ");
INSERT INTO cha_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Y janamangag y langet ya tumunog: ya teog na jinemjom gaegue gui sampapa y adengña. ");
INSERT INTO cha_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Ya maudae güe gui jilo un querubin, ya gumupo güe; magajet na gumupo güe gui jilo y papan y manglo. ");
INSERT INTO cha_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Japolo jinemjom para fanatuganña; para y tabernaculuña gui oriyaña; jinemjom y janom, teog na mapagajes guinin y langet. ");
INSERT INTO cha_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Pot y minalag gui menaña y teog na mapagajesña malofan: graniso yan pinigan guafe. ");
INSERT INTO cha_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Jajulo locue si Jeova gui langet, ya y Gueftaquilo jasangan ni y inagangña: graniso yan pinigan guafe. ");
INSERT INTO cha_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ya jatago y flechaña ya manchinalapon: ya magajet, megae na lamlam ya manyinilang. ");
INSERT INTO cha_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Ayonae esta malie y tinadong y janom, ya janamababa y simiento y tano sija pot y linalatdemo, O Jeova, pot y güinaefen y jinagong gui güiingmo. ");
INSERT INTO cha_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Jatago desde sanjilo, jachuleyo; ya jaatoyo guinin y megae na janom. ");
INSERT INTO cha_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Janalibrego gui manmetgot na enimigujo, yan y chumatliéyo, sa sija mas manmetgot qui guajo. ");
INSERT INTO cha_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Sija manmato guiya guajo gui un jaanen y chinatsagaco: lao si Jeova, güiya y fanapojo. ");
INSERT INTO cha_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Ya jachuleyo locue gui anae ancho na lugat: janalibreyo sa ninamagof ni guajo. ");
INSERT INTO cha_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Si Jeova jaapaseyo taemanoja y y tininasso: taemanoja y guinasgas y canaejo unaeyo. ");
INSERT INTO cha_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Sa juadaje y chalan Jeova: ya ti taelaye yo na juapattayo gui as Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Sa todo y jinasoña mangaegue gui menajo: ya ti junajanao guiya guajo y tinagoña. ");
INSERT INTO cha_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Ya guajo cabales guiya güiya: ya juadaje yo guinin y tinaelayeco. ");
INSERT INTO cha_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Pot este jaapaseyo si Jeova taemanoja y tininasso: taemanoja y guinasgas y canaejo gui menan atadogña. ");
INSERT INTO cha_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Ya y gaemaase unfanue na gaemaasejao: ya y taotao ni y cabales, unfanue na cabales jao. ");
INSERT INTO cha_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ya y gasgas unfanue na gasgasjao: ya y camten unfanue na camtenjao. ");
INSERT INTO cha_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Sa jago munalibre y mangaepinite na taotao; ya y sobetbio na atadog jago munatunog. ");
INSERT INTO cha_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Sa jago munamalag y candetto: si Jeova, Yuusso, namanana y jemjom guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Sa pot jago na jufalagüe y inetnon sendalo: ya pot y Yuusso jugope y quelat. ");
INSERT INTO cha_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Ya si Yuus, cabales y chalanña: y fino Jeova esta machague: patang güe para todo y numanangga güe. ");
INSERT INTO cha_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Jaye si Yuus yaguin ti si Jeova güe? ya jaye y acho, jaguin ti si Yuusta? ");
INSERT INTO cha_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Si Yuus jagogode yo ni y minetgot: ya jafatitinas cabales y chalanjo? ");
INSERT INTO cha_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Jafatitinas y adengjo taegüije y adeng y benado: ya janasagayo gui taquilo na sagajo sija. ");
INSERT INTO cha_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Jafanagüe y canaejo para y guera: ya enaomina y canaejo judobla y atcas bronse. ");
INSERT INTO cha_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ya unnaeyo locue ni y patang gui satbasionmo: ya y agapa na canaemo mumantietieneyo; ya y minansomo munamegaeyo. ");
INSERT INTO cha_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Unnadangculo y pinecatto gui papajo; ya y adengjo ti usulong. ");
INSERT INTO cha_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Judulalag y enimigujo sija, ya jugâchâ: ya ti jubirago talo asta que jocog. ");
INSERT INTO cha_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Junafanmañetnot, ya ti siña mangajulo: mamodong sija gui papa adengjo. ");
INSERT INTO cha_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Sa guinin ungode yo ni y minetgot para y guera: unnafanecon y enimigujo gui papajo. ");
INSERT INTO cha_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Guinin unfatinas ni y enimigujo na unaeyo ni y tataloñija, para juyulang y chumatliiyo. ");
INSERT INTO cha_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Manaagang, ya taya jaye ufansinatba: manaagange si Jeova ya ti manjiningog. ");
INSERT INTO cha_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Ayonae juguleg sija taegüije y petbos gui menan y manglo; taegüije y fache gui chalan ni y manmachalapon. ");
INSERT INTO cha_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Guinin unnalibre yo gui y inaguaguat y taotao: guinin unadaje yo para jumagas gui nasion sija: y taotao sija ni ti jutungo ujasesetbeyo. ");
INSERT INTO cha_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Ya anae jajungog guiya guajo ujaosgueyo: ya y taotao juyong ujaosgueyo ni y dinague. ");
INSERT INTO cha_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Ya taotao juyong manlinachae ya manmamamaela ya manlalaolao guinin manmapongle. ");
INSERT INTO cha_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Lâlâ si Jeova; ya ubendito y achojo: ya umanataquilo na Yuus y satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Si Yuus ni y numae yo y inemog, ya jasujeta y taotao gui papajo. ");
INSERT INTO cha_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Janalibre yo gui enimigujo: magajet na unnasanjiloyo gui ayo sija y mangajulo contra guajo: ya janalibre yo gui taotao ni y matatnga. ");
INSERT INTO cha_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Pot este junae jao grasias gui entalo y nasion sija, O Jeova; ya jucanta y alabansa para y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Dangculo na linibre janae y rayña; ya jafanue minaase ni y pinalaeña; as David ya y semiyaña para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Y langet munaclaro y minalag Yuus; ya y fineda mamanue y checho canaeña. ");
INSERT INTO cha_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Y un jaane yan y otro jaane masangang y finijo, ya y un puenge ya y otro puenge mamanue tiningo. ");
INSERT INTO cha_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Taya sinangan, ni finijo; ti siña umajungog y vosñija. ");
INSERT INTO cha_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Ya gui todo y tano jumanao y rayaña, ya asta uttimon y tano y finoña: ya japolo tabernaculo para atdao guiya sija. ");
INSERT INTO cha_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Ya güiya taegüije y nobio ni jumujuyong guinin y cuattoña, ya jamagof taegüije y matatnga na taotao, para ufalago gui finalago. ");
INSERT INTO cha_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Y jinanaoña guinin un punta gui langet, ya y linilicoña asta y uttimoña: ya taya jaye uatog ni y minaepeña. ");
INSERT INTO cha_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Y lay Jeova cabales, jafamauleg y ante; y testimonion Jeova seguro, janafanmalalate y manaeisao. ");
INSERT INTO cha_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Y finañagüe Jeova tunas, janafanmamagof y corason: y tinago Jeova claro, janafanmalag y atadogsija. ");
INSERT INTO cha_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Y minaañao as Jeova gasgas, sumaga para taejinecog; y sentensian Jeova magajet, ya todo tunas. ");
INSERT INTO cha_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Na malago mas que y oro, magajet mas que y megae na oro ni y manfino: mames mas que y miet, que y titijo gui sagan miet. ");
INSERT INTO cha_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Y tentagomo locue mapagat yan sija: ya yaguin jaadaje sija y uguaja dangculo na apas. ");
INSERT INTO cha_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Ya y linachiña jaye utiningo? ya y linache na ti jutungo, nalibreyo. ");
INSERT INTO cha_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Unmantiene locue y tentagomo guinin y sobetbio na isao: ya munga mangae ninasiñañija guiya guajo: ayo nae cabalesyo ya gasgas yo guinin y dangculo na quinebrantan y tinago. ");
INSERT INTO cha_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Polo ya y sinangang y pachotto ya y jinason y corasonjo umauleg gui menamo, O Jeova, minetgotto yan y munalilibreyo. ");
INSERT INTO cha_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","SI Jeova uninepejao y jaanen chinatsaga: y naan y Yuus Jacob ninacajulojao. ");
INSERT INTO cha_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Utago y para uinayudajao guinin y santuario, ya guinin y Sion unninametgotjao. ");
INSERT INTO cha_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ujaso todo y ninaemo, ya uchajlao y inefresimo sinenggue. ");
INSERT INTO cha_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Nae jao taemanoja y minalago y corasonmo, ya cumple todo y pinagatmo. ");
INSERT INTO cha_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Utafangana gui satbasionmo, ya y naan y Yuusmame injatsa julo y banderanmame: ucumple si Jeova todo y guinagaomo. ");
INSERT INTO cha_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Pago jutungo na si Jeova jaadadaje y pinalaeña: güiya uinepe gue guinin santos y langetña yan y minetgot y satbasion gui agapaña. ");
INSERT INTO cha_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Estesija gui caretasija, ya ayosija gui cabayosija nae jaangocosija: lao jita y naan Jeova, ni y Yuusta, utajajasoja. ");
INSERT INTO cha_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Estesija mandimo ya mamodong: lao jita tafangajulo ya tafanogue tunas. ");
INSERT INTO cha_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Jeova, nalibre: polo y Ray ya uopejam anae inagang. ");
INSERT INTO cha_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","O Jeova, gui minetgotmo ninamagof y ray; ya gui satbasionmo ninamagof megae! ");
INSERT INTO cha_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Y minalago y corasonña, jago numae: ya ti unpune ni y guinagao y labiosña. ");
INSERT INTO cha_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Sa untagam güe nu y bendision y minauleg: y coronan oro nu y fino, unpolo gui jilo y iluña. ");
INSERT INTO cha_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Linâlâ na guinagaoña unnae: y anaco na jaane, para siempre taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Dangculo y minalagña gui satbasionmo: onra yan minagas unpolo gui jiloña. ");
INSERT INTO cha_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Sa jago bumendise para taejinecog: unnamagof güe yan minagof gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Sa y ray jaangongoco si Jeova: ya pot y minaase y Gueftaquilo ti calamten. ");
INSERT INTO cha_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Y canaemo usoda todo y enimigumo: y agapa na canaemo usoda todo y chumatlie jao. ");
INSERT INTO cha_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Jago pumolo sija taegüije y jetnon guafe gui tiempon binibumo: si Jeova yumulang sija anae lalalo, ya y guafe ufanlinachae. ");
INSERT INTO cha_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ya y tinegchaña unyulang gui jilo y tano, ya y semiyaña gui entalo y famaguon y taotao. ");
INSERT INTO cha_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Sa jagasja majasuye y taelaye contra jago: jagasja majaso y dinague ni y ti siña mafatinas. ");
INSERT INTO cha_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Sa jago fumatinas na jabira y tataloñija ya unnalisto y jalon y atcosmo contra y matañija. ");
INSERT INTO cha_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Taquilo jao, O Jeova, yan y minetgotmo: incantaye yan inalabaye y ninasiñamo. ");
INSERT INTO cha_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","YUUSSO, Yuusso, sa jafa na undingo yo? sa jafa chago jao gui inayudajo yan y finijo gui inigongjo. ");
INSERT INTO cha_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","O Yuusso, juagang gui jaane ya ti unope: ya gui puenge lao jusoda y descanso. ");
INSERT INTO cha_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Ya y santos jao, O jago ni y sumasaga gui alabansan Israel. ");
INSERT INTO cha_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Yya jago nae manangoco y tatanmame: manangoco ya unnafanlibre sija. ");
INSERT INTO cha_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Maaagang jao ya ninafanlibre: manmanangoco nu jago ya ti manmamajlao. ");
INSERT INTO cha_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Ya guajo y gâgâ ilo ya ti taotao: namamajlao gui lalaje ya madespresia gui taotao. ");
INSERT INTO cha_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Todo y lumiiyo manatchatgue pot guajo mamuyuyueyo ya jayeyengyong y ilonñija. ");
INSERT INTO cha_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Angoco jao as Jeova; polo ya ulibre gue: polo ya ulibre güe sa güinaeya güe. ");
INSERT INTO cha_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Sa jago y chumule yo gui tiyan: ya unnafanangoco anae gaegue yo gui jaof nanajo. ");
INSERT INTO cha_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Gui jilomo mayute yo guinin y tiyan: desde y tiyan nanajo jago Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Chamo chachago guiya guajo; sa y chinatsagaco esta jijot, sa taya jaye yo uayuda. ");
INSERT INTO cha_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Megae na toro jaoriyayeyo: manmetgot na toron Básan jumijujuteyo. ");
INSERT INTO cha_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Ya jabababa y pachotñija guiya guajo taegüije y león ni tegcho yan cumate. ");
INSERT INTO cha_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Janamachuda yo taegüije y janom, todo y telangjo manápula: y corasonjo taegüije y danges; esta madirite gui talo gui sanjalomjo. ");
INSERT INTO cha_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Anglo y minetgotto taegüije y pedason an mafag: ya y jilajo cheton gui paladatto: ya gui petbos finatae nae unpoloyo. ");
INSERT INTO cha_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Sa maoriyayayeyo y galago sija: majijujuteyo y inetnon y manaelaye; ya manadochon gui canaejo yan y adengjo. ");
INSERT INTO cha_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Mojon jusangan todo ni y telangjo: sija jaatanyo ya jaconsidedera. ");
INSERT INTO cha_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Maipe gui entaloñija todo y bestidujo: ya y magagujo marifa. ");
INSERT INTO cha_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Lao jago, O Jeova, chamo chachago: O jago, minetgotto, chadig yan unayudayo. ");
INSERT INTO cha_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Nalibre gui espada y antijo: y beyan corasonjo, guinin y ninasiñan y galago. ");
INSERT INTO cha_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Nalibreyo gui pachot y león; magajet, guinin y canggilon y nubiyo ni titogcha, unope yo. ");
INSERT INTO cha_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Bae jusaasgane y mañelujo y naanmo: ya gui entalo gui inetnon taotao bae jualalabajao. ");
INSERT INTO cha_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Ya y manmaañao as Jeova, fanmanalaba nu güiya: todo y semiyan Jacob fanmanonra nu güiya: ya fanmaañao nu güiya todo y semiyan Israel. ");
INSERT INTO cha_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Sa ti guinin jadespresia ni jachatlie y pinadesen y pebble; ni unaatog y mataña guiya güiya: ya anae jaagang guiya güiya, jajungog. ");
INSERT INTO cha_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Ya iya jago nae mamaela y alabansajo gui dangculon inetnon: ya y promesajo juapase gui menan y manmaañao güe. ");
INSERT INTO cha_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Ufañocho y manmanso ya ufanjaspog: ufanmanalaba as Jeova y umaliligao güe: polo ya ufanmanlâlâ y corasonmiyo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Ujajaso ya ufanalo guato as Jeova todo y uttimon y tano: ya ufamnanadora gui menamo todo y familian y nasion sija. ");
INSERT INTO cha_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Sa as Jeova y raeno: ya güiya umagas gui todo nasion. ");
INSERT INTO cha_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Ufañocho ya ufanmanadora todo y yinemog y tano: gui menanña ufandimo, todo y manunog gui eda: güiyaja ni y tisiña unalala y antiña. ");
INSERT INTO cha_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Un semiya usinetbe güe: ya umasangan si Jeova asta y uttimo generasion. ");
INSERT INTO cha_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Ufanmato ya ufanmasangan y tininasña ni y taotao na umafañago, na güiya fumatinas este. ");
INSERT INTO cha_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","SI Jeova güiya y pastotjo: tayayo unafatta. ");
INSERT INTO cha_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Y manbetde na chaguan nae janaason yo: ya y quieto na janom nae jaosgaejon yo. ");
INSERT INTO cha_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Jananalo y antijo: jaosgaejon yo gui chalan tininas pot y naanña. ");
INSERT INTO cha_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Yaguin jufamocat gui chalan y anineng y finatae, ti maañao yo ni jafa na taelaye, sa jago gaegue guiya guajo: y baramo yan y bastonmo unnae yo minagof. ");
INSERT INTO cha_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Unfamauleg y lamasa gui menajo yan y menan y enimigujo sija: naye laña y ilujo, ya y copajo esta machúchuda. ");
INSERT INTO cha_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Sen magajet y minauleg yan y minaase madalalagyo todo nu sija gui jaanen linâlâjo: ya y guima Jeova jusaga para taejinecog na jaane. ");
INSERT INTO cha_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Y tano iyon Jeova yan y binilaña: y tano yan y manasaga gui sanjalomña. ");
INSERT INTO cha_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Sa güiya fumatinas gui jilo y tase: ya gui jilo y janom nae japolo fitme. ");
INSERT INTO cha_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Jaye ucajulo gui egso Jeova? ya jaye ugaegue gui sagan y sinantosña. ");
INSERT INTO cha_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Ayo y gasgas canaeña yan y gasgas corasonña: ni ti pumopolo gui taebale y antiña ni ufanjula ni y dinague. ");
INSERT INTO cha_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Güiya uresibe y bendision Jeova: yan y tininas guine as Yuus satbasionña. ");
INSERT INTO cha_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Este na generasion y umaliligao güe: y umaliligao y matamo, O Yuus Jacob. Sila. ");
INSERT INTO cha_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Jatsa julo y ilonmiyo, O jamyo trangco sija ya umajatsa julo y taejinecog na potta sija, ya y Ray langet ujalom. ");
INSERT INTO cha_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Jaye este na Ray langet? Si Jeova, metgot yan matatnga: si Jeova matatnga gui guera. ");
INSERT INTO cha_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Jatsa julo y ilonmiyo, O jamyo trangca sija ya umajatsa julo y taejinecog na potta sija ya y Ray langet ujalom. ");
INSERT INTO cha_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Jaye este na Bay langet? Si Jeova gui inetnon sendalo, güiya ayo y Ray langet. Sila. ");
INSERT INTO cha_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","YYAJAGO, O Jeova, nae jujatsa y antijo. ");
INSERT INTO cha_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","O Yuusso, iyajago nae juangocoyo: chamo yo munamamamajlao; chamo pumopolo y enimigujo na ugana gui jilojo. ");
INSERT INTO cha_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Magajet, na todo y mumananggajao ti ufanmamajlao: sija ufanmamajlao ni y chumogüe dinague sin jafa. ");
INSERT INTO cha_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Y chalanmo, O Jeova, fanueyo; fanagüe yo, ni y chalanmo. ");
INSERT INTO cha_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Osgaejonyo gui minagajetmo ya unfanagüeyo; sa jago y Yuus ni y satbasionjo: iyajago nae jufannangga todotdia. ");
INSERT INTO cha_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Jaso, O Jeova, y mauleg na minaasemo; yan y mauleg na güinaeyamo, sa sija guinin apmam na tiempo. ");
INSERT INTO cha_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Chamo jumajaso y isao y pinatgonjo, ni y quinebrantaco ni y tinago: segun y güinaeyamo jasoyo, pot y minauleg y naanmo, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Mauleg yan tunas si Jeova: pot enao na jafanagüe y maniisao ni y chalan. ");
INSERT INTO cha_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Y manmanso ufanfinanagüe gui juisio: yan y manmanso ufanguinia gui chalan. ");
INSERT INTO cha_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Todo y chalan Jeova güinaeya yan minagajet ni y ayo y umadadaje y tratuña yan y testimoniuña. ");
INSERT INTO cha_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Pot y naanmo, O Jeova, asie y isaojo sa gosdangculo. ");
INSERT INTO cha_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Jaye ayo na taotao y maañao as Jeova? güiya ufinanagüe ni y chalan mano y inayegña. ");
INSERT INTO cha_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Y antiña usaga gui mauleg: ya y semiyaña uereda y tano. ");
INSERT INTO cha_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Y secreton Jeova gaegue guiya sija y mumaañaogüe güe; ya güiya ufanagüe sija ni y tratuña. ");
INSERT INTO cha_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Y atadogjo siempre juatan si Jeova; sa güiya ujala y adengjo juyong gui laso. ");
INSERT INTO cha_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Atanyo, ya gaease ni guajo: sa guajo taeconsueloyo yan piniteyo. ");
INSERT INTO cha_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Y chinatsagan y corasonjo lumalamegae: najuyongyo gui pinitijo. ");
INSERT INTO cha_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Atan y trinesteco yan y pinitijo; ya unasie todo y isaojo. ");
INSERT INTO cha_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Atan y enimigujo, sa sija manmegae, ya sija chumatliiyo ni y fejman na chinatlie. ");
INSERT INTO cha_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Adaje y antijo ya nalibreyo: ya chajo mamamajlao, sa iyajago nae juangocoyo. ");
INSERT INTO cha_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Y minauleg yan y tininas juadádajeyo: sa jago junanangga. ");
INSERT INTO cha_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Nalibre, O Yuus, y iya Israel gui todo y chinatsagaña. ");
INSERT INTO cha_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","JUSGAYO, O Jeova, sa guajo jumajanao yo gui tininasso: juangocoyo locue gui as Jeova: pot enao na ti jusulong. ");
INSERT INTO cha_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Ecsamina yo, O Jeova, ya chagueyo: chague y jinasojo gui jinalomjo yan y corasonjo. ");
INSERT INTO cha_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Sa y güinaeyamo gaegue gui menan atadogjo; ya gui minagajetmo nae jumajanaoyo. ");
INSERT INTO cha_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ti jagasja matachongyo yan y ti manmagajet na taotao; ni jujalom yan y lumilipa. ");
INSERT INTO cha_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Juchatlie y inetnon y chumogüe taelaye: ya ti jufatachong yan y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Jufagase y canaejo ni y tinaeisao: taegüije juoriya gui attatmo, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Para junajungog y inagang y grasias yan para jusangan todo y ninamanmanmo. ");
INSERT INTO cha_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Jeova, yajo y sagan y guimamo: yan y lugat nae sumasaga minalagmo. ");
INSERT INTO cha_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Chamo na fandadaña yan y maniisao y antijo, ni y jaanijo yan y taotao cájaga. ");
INSERT INTO cha_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Sa ayosija na canaeñija mangaegue y nacacha: ya y agapa y canaeñija bula ni y catnada. ");
INSERT INTO cha_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Lao guajo jumajanao yo yan y tininasso: nalibreyo, ya gaease ni guajo. ");
INSERT INTO cha_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Y adengjo gaegue gui lugat ni yano: ya gui inetnon taotao nae jubendise si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","SI Jeova y candetto yan y satbasionjo? ya jaye jumaañagüeyo? si Jeova y minetgot y linâlâjo, ya jaye yo nae jumaañao? ");
INSERT INTO cha_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Anae manmato guiya guajo y chumogüe taelaye para u jacano y catneco, y contrariojo yan y enimigujo, sija manmatompo ya manmatomba. ");
INSERT INTO cha_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Achogja ujapolo un inetnon sendalo contra guajo ti maañao y corasonjo: achogja ucajulo y guera contra guajo, este nae juangocoyo. ");
INSERT INTO cha_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Unoja na güinaja jugagao gui as Jeova, este jualiligao; na jugaegue gui guima Jeova todo y jaanen linâlâjo, para julie y guinatbon Jeova ya para jualigao gui temploña. ");
INSERT INTO cha_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Sa güiya munaatogyo gui tabernacoluña gui jaanen pinite: ya janaatogyo gui fanatog y tabernacoluña: ya japoloyo julo gui jilo y acho. ");
INSERT INTO cha_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Ya pago janataquiloyo y ilujo gui jilo y enimigujo gui oriyajo: ya junae gui tabernacoluña inefresen minagof; bae jucantae, magajet, jucantaye alabansa sija si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Jungog, O Jeova, anae juagang ni inagangjo, gaease locue ni guajo ya unopeyo. ");
INSERT INTO cha_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Anae ilegmo: Aligao jamyo y matajo; y corasonjo ilegña nu jago: O Jeova, y matamo jualiligao. ");
INSERT INTO cha_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Chamo munaaatog y matamo guiya guajo; chamo munasusuja yan y binibumo y tentagomo: jago guinin ayudajo; chamoyo yumuyute ya chamoyo dumidingo, O Yuus gui satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Anae si tatajo yan nanajo yumuteyo: si Jeova jumocayo. ");
INSERT INTO cha_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Fanagüeyo, O Jeova, ni y chalanmo: ya osgaejonyo, gui chalan yano, pot rason y enimigujo. ");
INSERT INTO cha_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Chamoyo pumopolo gui minalago y contrariojo: sa mangajujulo contra guajo mandacon na testigo, ya jaye usinangang y taease. ");
INSERT INTO cha_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Guinin lalangoyo yaguin ti jujonggue na guaja nae julie y minauleg Jeova gui tano ni y manlâlâlâ. ");
INSERT INTO cha_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Nangga si Jeova: nametgotjao ya polo ya unamatatnga y corasonmo: magajet, na nangga jao si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","YYAJAGO, O Jeova, juaagang; achojo, chamo fatilúluye yo: yaguin infatiluye yo, guajo uparejo yan y manútunog gui tadong y joyo. ");
INSERT INTO cha_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Jungog y inagang y guinagaojo anae juagang jao: anae jujatsa y canaejo gui sinantos templomo. ");
INSERT INTO cha_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Chamoyo cumocone guato gui manaelaye yan y chumogüe y taelaye: ya jasasangan y pas gui tiguangña ya y inacacha gaegue gui corasonñija. ");
INSERT INTO cha_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Nae sija taemanoja y chechoñija: ya taemanoja y taelayen chechoña. Nae sija taemanoja y finatinas y canaeñija: apase ni y para ujamarese. ");
INSERT INTO cha_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Sa timanmalago jalie y checho Jeova, ni y finatinas y canaeña, ufanyinilang sija ya ti uninafangajulo. ");
INSERT INTO cha_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Bendito si Jeova, sa jajungong y inagang y guinagaojo. ");
INSERT INTO cha_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Si Jeova y minetgotto yan y patangjo; y iyagüiya nae manangoco y corasonjo, ya guajo uayuda: Enao mina senmagof y corasonjo; ya y quinantaco nae jualabagüe. ");
INSERT INTO cha_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Si Jeova y minetgotñija: ya güiya y minetgot y satbasion para y pinalaeña. ");
INSERT INTO cha_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Nalibre y taotaomo ya bendise y erensiamo: ya nafañocho sija ya unmantiene sija para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","NAE si Jeova, O famaguon manmetgot, nae si Jeova ni inenra yan y minetgot. ");
INSERT INTO cha_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Nae si Jeova y inenra ni mauleg para y naanña: adora si Jeova ni guinatbon y sinantosña. ");
INSERT INTO cha_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Y inagang Jeova gaegue gui jilo y janomsija: ya y Yuus langet janajujulo: junggan, si Jeova, gui jilo y megae na janom. ");
INSERT INTO cha_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Y inagang Jeova y ninasiña: y inagang Jeova bula y minagas. ");
INSERT INTO cha_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Y inagang Jeova yumuyulang y trongcon y sedrosija: magajet na jayulang si Jeova y trongcon sedrosija y Líbano. ");
INSERT INTO cha_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Ya janafanayog sija locue taegüije y tatnero: y Líbano yan y Sirion taegüije y patgon y dadao na nubiyo. ");
INSERT INTO cha_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Y inagang Jeova umuutut y mañila y guafe. ");
INSERT INTO cha_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Y inagang Jeova munamayengyong y jalomtano: janameyeyengyong si Jeova y jalomtano guiya Cades. ");
INSERT INTO cha_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Y inagang Jeova munafanmañañago y binado sija ya janafanquesnuda y jalomtano: ya y temploña nae todo y güinaja ilegña: Minalag. ");
INSERT INTO cha_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Si Jeova anae guaja delubio matachong calang un ray; magajet na matatachong si Jeova calang ray na taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Si Jeova unae minetgot y taotaoña: si Jeova jabendise y taotaoña ni y pas. ");
INSERT INTO cha_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","JUNATAQUILO jao, O Jeova; sa jago unnajatsa yo julo: ya ti unnafanmagof y enimigujo guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Jeova, Yuusso, juagangjao ya unnajomloyo. ");
INSERT INTO cha_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","O Jeova, jago munacajulo y antijo gui naftan: unadajeyo na lâlâyo para mungayo tumunog gui naftan. ");
INSERT INTO cha_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Cantaye si Jeova, O jamyo mañantosña: ya innae grasias y santos na naaña. ");
INSERT INTO cha_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Sa pot didideja guaja linalaloña; gui finaboreseña nae guaja linâlâ: yaguin y pupuenge majon sumaga y tinanges; y egaan mato y minagof. ");
INSERT INTO cha_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Ya guajo jagas ileco anae lumálaguaja yo: ti jucalamten talo taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Sa jago, Jeova, pot y finaboresemo jagasja unnafitme y egsojo: lao unnana y matamo, ya guajo chumatsaga. ");
INSERT INTO cha_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Yya jago, O Jeova, juaagangjao: ya si Jeova jutayuyut. ");
INSERT INTO cha_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Jafayo probechoco gui jâgâjo, anae tumunog yo gui naftan? Ada uinalabajao ni y petbos? Ada usangan y minagajetmo? ");
INSERT INTO cha_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Jungog, O Jeova, ya gaease ni guajo: Jeova, jago para inayudajo. ");
INSERT INTO cha_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Jago bumira y inigongjo gui baela: ya unpula y lutojo ya unnaquinereasyo ni y minagof; ");
INSERT INTO cha_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Para jucantaye jao inenra ya ti jufamatquilo: O Jeova, Yuusso, junaejao grasias para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","YYAJAGO, O Jeova, nae juangoco: chamoyo munamamamajlao para taejinecog: nalibreyo gui tininasmo. ");
INSERT INTO cha_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Egueng papa guiya guajo y talangamo, nalibreyo guse: jago y para guajo acho ni y fitme, pot y guima lumijing nae para unnalibreyo. ");
INSERT INTO cha_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Sa jago y achojo yan y castiyujo; enao mina pot y naanmo esgaejonyo ya chachalalaneyo. ");
INSERT INTO cha_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Chuleyo gui lagua ni y munanaaatogyo gui ti umatungo: sa jago y seguro na sagajo. ");
INSERT INTO cha_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Y canaemo nae, junae ni y espiritujo: unnalibreyo, O Jeova, jago Yuus minagajet. ");
INSERT INTO cha_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Juchatlie ayo sija y numanangga y taebale na dinague: lao guajo si Jeova juangongoco. ");
INSERT INTO cha_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Jumagof ya jusenmagof gui minaasemo: sa jagas unlie y pinitijo: ya jagas untungo y antijo gui chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ya jago ti jumujuchomyo gui canae y enimigujo: jagas unpolo y adengjo gui dangculo na sagayan. ");
INSERT INTO cha_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Gaease ni guajo, O Jeova, sa estagüe yo gui chinatsaga: sa y atadogjo linachae ni y pinite, junggan, y antijo yan y tataotaojo. ");
INSERT INTO cha_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Sa y jaanijo linachae ni y trinestico, ya y sacanjo ni y suspiros: linalachae y minetgotto pot y tinaelayeco: ya y telangjo mananglo. ");
INSERT INTO cha_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Pot todo y enimigujo, jumuyongyo mamajlao, magajet na sentaegüijeja a para y tiguangjo yan y minaañao ni y manatungoyo: ya y lumiliiyo gui sanjiyong mañuja guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Sa esta malefayo taegüije y matae ni ti manjaso: taegüijeyo y an mafag baso. ");
INSERT INTO cha_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Sa jujungog y dinisonran y lajyayan: minaañao sija gui todo oriya: anae manafaesen entresija contra guajo, ya majasusuye para umacone y antijo. ");
INSERT INTO cha_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Lao guajo, iya jago nae juangocoyo, O Jeova: ileco: Jago y Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Y canaemo nae gaegue y tiempoco: nalibre yo gui canae y enimigujo yan y pumetsisigueyo. ");
INSERT INTO cha_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Nafanina y matamo gui jilo y tentagomo: nalibreyo ni y güinaeyamo. ");
INSERT INTO cha_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","O Jeova, chamo yo munamámamajlao; sa jagasja juaagangjao: polo y manaelaye ya ufanmamajlao: polo sija ya ufanmamatquilo gui naftan. ");
INSERT INTO cha_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Nafanmamatquilo y labios ni y manmandadague; sa manguecuentos saguat contra y manunas, yan sobetbia yan despresio. ");
INSERT INTO cha_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Jafa muna dangculo y minaulegmo ni unadadaje para y mumaañaogüe jao, na unfatinas para y umangocojao gui menan y famaguon y taotao. ");
INSERT INTO cha_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Jago nae ufanatog sija na ti umatungo gui menamo guinin y taelaye na contraton taotao; jago unadaje sija gui guima lumijing guinin y inaguaguat y jila sija. ");
INSERT INTO cha_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Bendito si Jeova: sa jafanueyo ninamanman gui minaaseña gui siudan manmetgot. ");
INSERT INTO cha_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Ya guajo ileco y nalulajo: Juutut yo gui menan atadogmo; lao magajet na jago jumungog y vos y guinagaojo anae juagangjao. ");
INSERT INTO cha_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Guaeya si Jeova todo jamyo mañantos; ya y manmauleg adaje si Jeova, ya apase megagae y fumatitinas ni y sobetbia. ");
INSERT INTO cha_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Nafanmetgot jamyo, ya inafanmatatnga y corasonmiyo, todo y numanangga si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","DICHOSO y maasie ni y taelayen finatinasña, ya y isaoña matampe. ");
INSERT INTO cha_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Dichoso y taotao ni y ti jacatgaye si Jeova ni tinaelaye, ni uguaja gui espirituña dinague. ");
INSERT INTO cha_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Anae mamatquiloyo, y telangjo ninafanbijo, ni y inigongjo todotdia. ");
INSERT INTO cha_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Sa y jaane yan y puenge y canaemo macat guiya guajo; ya y finetgonjo mabira para y inanglo gui tiempon maepe. Sila. ");
INSERT INTO cha_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Y isaojo junatungo jao ya y tinaelayeco ti junaatog; ya ileco: Guajo bae juconfesatñaejon y tinaelayen finatinasso as Jeova; ya jago unasie y taelayen y isaojo. Sila. ");
INSERT INTO cha_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Sa este nae umatayuyut jao y mandeboto todos gui tiempo anae mojon siña ujasoda: senmagajet anae machuchuda inetnon y janom, ti ufato guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Jago y fanatugco; ya gui chinatsaga jago unadajeyo: ya nu y cantan linibre, jago unoriyayeyo. ");
INSERT INTO cha_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Junatungo jao ya jufanagüe jao ni y chalan anae jumajanao: jupagat jao nu y atadogco. ");
INSERT INTO cha_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Chamo pumarérejo yan y cabayo, pat y mula ni taya tiningoñija: na nesesita y modasa yan y freno para umantiene; yaguin taya estesija ti malago guaguato guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Megae na triniste para y manaelaye: lao y numaangongoco si Jeova, minaase umoriyayayegüe. ");
INSERT INTO cha_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Fanmagof as Jeova, ya infansenmagof, O jamyo manunas; ya fanagang ni y minagof, todo y manunas na corason. ");
INSERT INTO cha_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","FANMAGOF gui as Jeova jamyo manunas: sa y manunas bonito na alabansa. ");
INSERT INTO cha_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Fanmannae grasias indandane si Jeova ni atpa: cantaye güe ni alabansa nu y guitala ni y gaecuetdas dies. ");
INSERT INTO cha_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Cantaye güe ni y nuebo na canta: dandan mauleg ni y agang. ");
INSERT INTO cha_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Sa y fino Jeova tunas: ya todo y chechoña esta mafatinas ni y minagajet. ");
INSERT INTO cha_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Güiya yaña y tininas yan y juisio; ya cariño na güinaeya gui as Jeova, bula y tano. ");
INSERT INTO cha_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Pot y fino Jeova esta mafatinas y langetsija: ya pot y jajaja ni y pachotña, todo y inetnonñija. ");
INSERT INTO cha_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Güiya munadaña gui un monton y janom gui tase: güiya pumolo gui atmasén y tinadongsija. ");
INSERT INTO cha_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Manmaañao as Jeova todo y tano: manmaañao nu güiya todo mañasaga gui tano. ");
INSERT INTO cha_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Sa güiya umalog ya jumuyong: güiya manago ya sumaga fitme. ");
INSERT INTO cha_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Si Jeova munataesetbe y pinagat y nasion; ya güiya munataebale y jinaso y taotao. ");
INSERT INTO cha_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Y pinagat Jeova sumaga para taejinecog: y jinason y corasonña para todo y generasion. ");
INSERT INTO cha_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Dichoso y nasion ni si Jeova Yuusña: yan y taotao ni y jaayeg pot erensia para güiya. ");
INSERT INTO cha_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Desde y langet jaatan si Jeova: jalilie todos y famaguon Adam. ");
INSERT INTO cha_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Desde y sagaña na lugat jaatan; jaatitutuye todo y mañasaga gui jilo y tano. ");
INSERT INTO cha_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Güiya fumatinas y corasonñija todos: yan jaatitutuye todo y chechoñija. ");
INSERT INTO cha_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Y ray ti umalibre pot y dangculon inetnon sendaloña: y matatnga na taotao ti umasatba pot y dangculon minetgotña. ");
INSERT INTO cha_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Y cabayo taebale para useguro: sa güiya ti unalibre ni uno nu y dangculon jinilatña. ");
INSERT INTO cha_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Estagüeja, y atadog Jeova gui jilo y manmaañagüe güe: gui jiloñija y numanangga y minaaseña. ");
INSERT INTO cha_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Para unalibre gui finatae y antiñija: ya para unae linâlâ gui ñinalang. ");
INSERT INTO cha_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Y antita jagas jananangga si Jeova: y ayudata yan y patangta güiya. ");
INSERT INTO cha_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Pot güiya manmagof y corasonta, sa y sinantos naanña nae jagas taangocojit. ");
INSERT INTO cha_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Polo y minaasemo, O Jeova, ugaegue guiya jame, según ninangganmamame guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","JUBENDISE si Jeova gui todo y tiempo: y alabansaña siésiempreja sumaga gui pachotto. ");
INSERT INTO cha_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Si Jeova umalaba y antijo: man manjungog y manmanso ya ninafanmagof. ");
INSERT INTO cha_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Junadangculo si Jeova guiya guajo: ya nita tanataquilo y naanña gui un vos. ");
INSERT INTO cha_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Jualigao si Jeova ya güiya jajungogyo: ya todo y minaañaojo janalibreyo. ");
INSERT INTO cha_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Sija inatangüe ya infaninina: ya y matañija ti ufanmamajlao. ");
INSERT INTO cha_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Este y namase na taotao umagang, ya si Jeova jumungog, ya ninalibre todo gui chinatsagaña. ");
INSERT INTO cha_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Y angjet Jeova jaoriyaye sija y manmaañao nu güiya ya janalibre sija. ");
INSERT INTO cha_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Chague ya unlie na mauleg si Jeova: dichoso y taotao ni umangocogüe guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Fanmaañao as Jeova, jamyo mañantosña: sa taya ufatta para y manmaañao nu güiya. ");
INSERT INTO cha_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Y mandiquique na león mannamase ya manñalang; ya y umaliligao si Jeova ti ufatta ni jafa na minauleg. ");
INSERT INTO cha_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Maela jamyo famaguon, ecungog yo: ya jufanagüe jamyo ni y minaañao as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Jaye enao na taotao y tumátana y linâlâ, ya yaña megae na jaane para ulie y minauleg? ");
INSERT INTO cha_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Adaje y jilamo gui taelaye, yan y labiosmo na ucuentos mandague. ");
INSERT INTO cha_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Suja gui taelaye ya fatinas y mauleg; aligao y pas ya dalalag. ");
INSERT INTO cha_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Y atadog Jeova gaegue gui jilo y manunas: ya y talangaña esta mababa pot y inagangñija. ");
INSERT INTO cha_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Y matan Jeova contra y fumatitinas y taelaye para uutut gui tano y jinasoñija. ");
INSERT INTO cha_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Managang y manunas ya si Jeova jumungog: ya todo y chinatsagañija ninafanlibre. ");
INSERT INTO cha_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Jijot esta si Jeova gui manmaque branta na corason: yan y manmañetnot na espiritu janalibre. ");
INSERT INTO cha_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Megae y pinitiñiñija y manunas: lao todo ayo si Jeova munafanlibre. ");
INSERT INTO cha_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Jaadaje todo y telangñija: ya ni uno guiya sija umayamag. ");
INSERT INTO cha_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Y tinaelaye upinino y taotao ni taelaye: ya y chumatlie y manunas ufansinentensia. ");
INSERT INTO cha_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Janalilibre si Jeova y linâlâ y tentagoña: ya taya ni uno ni umangoco güe usinentensia. ");
INSERT INTO cha_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","AGUAGUATE, O Jeova, ayo y umaguaguaguateyo; mumo yan ayo y amumumujo. ");
INSERT INTO cha_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Mantiene y patang yan guinegüe, ya tojgue para unayudayo. ");
INSERT INTO cha_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Ya chule y lansa ya patang y chalan contra ayo y pumetsisigueyo: alog ni antijo: Guajo y satbasionmo. ");
INSERT INTO cha_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Polo ya ufanmamajlao, ya ufanquinenfunde y umaliligao y antijo: polo ya ufanalo tate ya ufanmamajlao y jumajaso y taelayejo. ");
INSERT INTO cha_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Polo sija ya calang y paja gui menan y manglo: ya y angjet Jeova ufanchineneg sija. ");
INSERT INTO cha_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Polo y chalanñija ya jomjom yan palagse: ya y angjet Jeova ufanpinetsigue sija. ");
INSERT INTO cha_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Sa sin causa manatog para guajo y lagua gui joyo: ya sin causa manmanguadog joyo para y antijo. ");
INSERT INTO cha_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Polo ya ufato guiya güiya ya yinilang ni ti jatungo: polo ya y lagua ni janaaatog, ucone maesagüe: yan y jalom yinilang nae upodong güe. ");
INSERT INTO cha_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Ya umagof y antijo gui as Jeova: ya umagof gui satbasionña. ");
INSERT INTO cha_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Todo y telangjo y ilegñija: Jeova, jaye parejumo? ni unalibre y mamoble gui mas manmetgot qui güiya: magajet na y mamoble yan y mannesesitao, guinin y jachulelejguan? ");
INSERT INTO cha_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Mangajulo testigon mandague: ya jafaesenyo ni y ti jutungo. ");
INSERT INTO cha_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Manaeyo ni taelaye pot y mauleg, ya manataelaye y antijo. ");
INSERT INTO cha_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Lao guajo anae manmalango sija, magagojo y luto: junatriste y antijo yan umayunat: y tinaetaejo tumalo jalom gui pechoco. ");
INSERT INTO cha_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Mamomocat yo ya ileleco: Güiya buente y gachongjo, pat y chelujo: ya tumecon yo triste calang uno ni y umuugung pot si nanaña. ");
INSERT INTO cha_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Lao anae desgrasiaoyo, sija manmagof ya mandaña: ya y gosnamaase mandaña contra guajo ya guajo ti jutungo: sija matitegyo ya ti manbasta. ");
INSERT INTO cha_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Parejo yan y áplacha na minefea gui fandango, janachéchegcheg y nifenñija guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Jeova, asta ngaean nae unatan? nalibre y antijo gui yinilangña, yan y beya y corasonjo gui león. ");
INSERT INTO cha_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Junae jao grasias gui dangculon y inetnon taotao: ya jualaba jao gui entalo linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Chamo pumopolo na ufanmamagof guiya guajo y enimigujo sin jafa? ni ayo y chumatlieyo sin causa jaachetgue yo nu y atadog. ");
INSERT INTO cha_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Sa ti manguecuentos pas: ya contra y manmanso gui tano jajajaso y finijo dinague. ");
INSERT INTO cha_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Magajet na jabababa y pachotñija contra guajo; ilegñija: Ja, ja y atadogmameja lumie. ");
INSERT INTO cha_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Unlie este, O Jeova; chamo famatquiquilo: O Jeova, chamo chachago guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Jaso ya fagmata para y juisioco; junggan, para y causaco Yuusso yan y Señotto. ");
INSERT INTO cha_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Jusgayo taemanoja y tininasmo, O Jeova, Yuusso, ya chamo pumopolo na ufanmamagof guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Chamo pumopolo na ujaalog gui corasonñija: Ja, taegüije manmalagojit; chamo pumopolo na ujaalog: Jita jagas tacalamot güe. ");
INSERT INTO cha_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Polo ya ufanmamajlao ya ufañatsaga ayo sija y manmagof pot y manadañujo: polo ya ufanminagago ni y minamajlao yan y disonra y munadangculo sija contra guajo. ");
INSERT INTO cha_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Polo ya ufanagang ni minagof ya ufanmagof y gumaeya y tinas na causaco: junggan, polo ya ujaalog siempre: innadangculo si Jeova, ni y yaña na memegae y tentagoña. ");
INSERT INTO cha_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Ya y jilajo usangan ni y tininasmo, yan todotdia ni y alabansamo. ");
INSERT INTO cha_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","YINEMBESTE y taelaye, ilegña gui corasonjo, taya minaañao as Yuus gui menan atadogña. ");
INSERT INTO cha_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Sa pot enao jafaande maesa güe gui atadogña, ya ti usoda y taelayeña ya umachatlie gue. ");
INSERT INTO cha_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Y finijo gui pachotña manaelaye yan finababa: basta güe ni utungo yan ufatinas y mauleg. ");
INSERT INTO cha_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Y tinaelaye jajajaso gui jilo camaña: japolo maesa güe gui un chalan ni y ti mauleg: ti jachatlie y inacacha. ");
INSERT INTO cha_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","O Jeova, asta y langet y güinaeyamo; y minagajetmo inataca asta y mapagajes. ");
INSERT INTO cha_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Y tininasmo taegüije y egso Yuus; y juisiomo sija dangculoña tinadong: y taotao yan y gâgâ, jago umadadaje, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Gosdangculo y balotña y güinaeyamo, O Yuus! ya y famaguon taotao ufanmagogue gui papa y anineng y papamo. ");
INSERT INTO cha_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Ufansennajong ni y minegae y guimamo: ya jago unnafanguimen ni y sadog y minagofmo. ");
INSERT INTO cha_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Sa iyajago nae gaegue y bebô y linâlâ: ya y ininamo nae infanmalie inina. ");
INSERT INTO cha_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Sisigueja y güinaeyamo para y tumungo jao; ya y tininasmo para manunas na corason. ");
INSERT INTO cha_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Chamo pumopolo ya ufato contra guajo y patas y sobetbio: ni y canae y manaelaye unasuja yo. ");
INSERT INTO cha_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Ayo nae mamodong y manmamatitinas ni y taelaye: sija manmachoneg ya ti siña ufangajulo. ");
INSERT INTO cha_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","CHAMO umestotban mamaesa jao ni y chumogüe daño, ni unguaja embidia, ni y fumatitinas y taelaye. ");
INSERT INTO cha_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Sa ufanmautut guse taegüijeja y chaguan, ya ufanmalayo taegüije y chaguan betde. ");
INSERT INTO cha_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Angocojao as Jeova, ya fatinas y mauleg: saga gui tano ya unchogüe minauleg. ");
INSERT INTO cha_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Magofjao as Jeova: ya güiya unninae ni guinagao y corasonmo. ");
INSERT INTO cha_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Bira y chalanmo para as Jeova: ya angocogüe locue, ya güiya unajuyong este. ");
INSERT INTO cha_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Ya janajanao y tininasmo taegüije y manana: ya y juisiomo taegüije y taloane. ");
INSERT INTO cha_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Quieto jao as Jeova, ya nanggagüe nu y siningon: chamo umestotban mamaesa jao ni y mumegae, gui chalanña ni y taotao ni fumatitinas y dinague. ");
INSERT INTO cha_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Basta y binibo, ya polo y linalalo; chamo umestotban mamaesa jao para unfatinas y dano. ");
INSERT INTO cha_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Sa y chumogüe dano ufanmautut: lao y numanangga si Jeova, sija ujaereda y tano. ");
INSERT INTO cha_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Ya desde este didide ti utaegüe y taelaye: magajet na jaguefjajaso y sagaña ya utaegüe güe. ");
INSERT INTO cha_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Lao y manmanso ujaereda y tano: ya ufanmagof maesa sija ni megae na pas. ");
INSERT INTO cha_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Y taelaye man jajaso dinague contra y manunas ya janachechegcheg y nifenñija guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Si Jeova chumachaleg pot güiya: sa jalilie na ufato gui jaaniña. ");
INSERT INTO cha_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Y manaelaye jalagnos y espada, yan janadilog y atcosñija para uyute papa y mamoble yan y mannesesitao: para ujapuno sija y manunas gui chalan. ");
INSERT INTO cha_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Y espadañija jumalom gui corasonñijaja ya y atcosñija umayamag. ");
INSERT INTO cha_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Maulegñaja y didide gui manunas, qui y minegae gui megae na manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Sa y canae y manaelaye ufanmayamag: lao si Jeova jamantietene y manunas. ");
INSERT INTO cha_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Jatungo si Jeova y jaanen y manunas: ya y erensiañija usaga para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Sija, ti ufanmamajlao gui taelaye na tiempo: ya y jaanen ñinalang ufanjaspog. ");
INSERT INTO cha_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Lao y manaelaye ufanmalingo: yan y enimigon Jeova ufanparejo y sebon cotdero sija: sija ufanlinachae, calang aso ufanguelinachae. ");
INSERT INTO cha_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Y manaelaye mañuñule inayao ya ti jaapapasetalo: ya y manunas guaja minaaseñija ya mannae. ");
INSERT INTO cha_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Sa ayosija y manbendise pot güiya ujaereda y tano: ya ayosija y manmatdise pot güiya ufanmautut. ");
INSERT INTO cha_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Sa y jinanao y mauleg na taotao si Jeova mumantietene; ya güiya yaña y chalanña. ");
INSERT INTO cha_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Yaguin matomba, ti uguefpodong: sa si Jeova mumantietene nu y canaeña. ");
INSERT INTO cha_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Guine patgon yo ya estayo bijo; lao tatnae julie y mauleg madingo, ni y semiyaña manegagao nengcanoñija. ");
INSERT INTO cha_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Todotdia guaja minaase yan ninaayao: ya y simiyaña para bendision. ");
INSERT INTO cha_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Suja gui taelaye, ya fatinas y mauleg; ya sumasasaga jao para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Sa si Jeova yaña y juisio, ya ti jadingo y mañantosña: sija ufanmaadaje para siempre: ya y semiyan y manaelaye ufanmautut. ");
INSERT INTO cha_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Y manunas ujaereda y tano ya usaga para taejinecog gui jiloña. ");
INSERT INTO cha_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Y pachot y manunas manguecuentos minalate, ya y jilaña cumuecuentos juisio. ");
INSERT INTO cha_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Y lay y Yuusña gaegue gui corasonña, pot enao na y adengña ti usulong. ");
INSERT INTO cha_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Y taelaye jaespipia y tinas ya jaegaga para upuno. ");
INSERT INTO cha_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Si Jeova ti upinelo gue gui canaeña: ni usinentensia güe yan manjusga. ");
INSERT INTO cha_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Nangga si Jeova ya adaje y chalanña, ya güiya unninataquilo para unereda y tano: anae y manaelaye ufanmautut, jago siempre unlie. ");
INSERT INTO cha_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Guajo jagas julie y taelaye na dangculo ninasiñaña, ya janamayao güe, calang y atbot ni betde gui edaña. ");
INSERT INTO cha_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Ya jumalofan ya estagüe, na taegüe: magajet na jualigao ya tisiña masoda. ");
INSERT INTO cha_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Jaso y cabales, ya atan y tinas na taotao: sa y uttimoña ayo na taotao y pas. ");
INSERT INTO cha_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Lao y manaelaye todo manmayulang: ya y uttimon y manaelaye ufanmautut. ");
INSERT INTO cha_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Lao y satbasion y manunas gui as Jeova: güiya y minetgotñija gui tiempon y chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Ya si Jeova ufaninayuda ya uninafanlibre gui manaelay: ya uninafansatba sa sija numananggagüe. ");
INSERT INTO cha_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","O Jeova, chamoyo lumalálatde nu y lalalomo, ni uncastigayo nu y binibumo. ");
INSERT INTO cha_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Sa y flechamo cheton guiya guajo: ya y canaemo macat gui jilojo. ");
INSERT INTO cha_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Taya jinemlo gui catneco pot y binibumo: ya taya pas gui telangjo pot causa y isaojo. ");
INSERT INTO cha_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Sa y tinaelayeco malofan gui jilo ilujo: sija sen macat guiya guajo taegüije y catga macat. ");
INSERT INTO cha_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Y chetnotto manmutung yan manpotlilo, pot causa y binabajo. ");
INSERT INTO cha_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Pinite yo yan gostumecon yo: todotdia jumajanaoyo yan umuugong yo. ");
INSERT INTO cha_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Sa y atayojo bula sinenggue: ya taya jinemlo gui catneco. ");
INSERT INTO cha_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Manyafaeyo yan gosmamuteyo: cumate yo pot y atboroto gui corasonjo. ");
INSERT INTO cha_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Jeova, y menamo nae gaegue todo y tinangajo: ya y inigongjo tiunaatog guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Y corasonjo bobongbong, y minetgotto malingo: ya y minalag y atadogjo fatta esta. ");
INSERT INTO cha_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Y gumaeya yo yan y mangachongjo manotojgue chago gui chetnotto; ya parientesso manotojgue gui chago. ");
INSERT INTO cha_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Ayosija ni y umaliligao y antijo manmaplanta laso para guajo; ya y umaliligao y dañujo manguecuentos tinaelaye: ya todotdia manmanajaso ni y finababa. ");
INSERT INTO cha_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Lao guajo, calang tanga, ti jujungog: ya guajo calang udo ni ti ubaba y pachotña. ");
INSERT INTO cha_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Magajet na guajo calang un taotao ni ti manjujungog: ya taya linalatde gui pachotña. ");
INSERT INTO cha_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Sa iya jago, O Jeova, junanangga: jago unfanope, O Jeova, Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Sa ileco: Chañija fanmamagof guiya guajo: anae sulong y adengjo manladangculon sija guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Sa guajo cana na ugadon: ya y pinitijo gaegue siesiempre gui menajo. ");
INSERT INTO cha_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Sa bae jusangan y tinaelayeco; bae jutriste pot y isaojo. ");
INSERT INTO cha_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Sa y enimigujo manlâlâ ya manmetgot: ya mumemegaeja y chumatlieyo sin jafa. ");
INSERT INTO cha_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Ayosija locue ni y jaapapase y mauleg pot y taelaye, sija contrarionjo, sa judadalalag y mauleg. ");
INSERT INTO cha_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Chamo dumidingoyo, O Jeova: O Yuusso, chamo chachago guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Laguse ya unayudayo, O Jeova y satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","GUAJO ileco bae juadaje y chalanjo, para chajo umiisao pot y jilajo: bae juadaje y pachotto ni freno, anae y manaelaye mangaegue gui menajo. ");
INSERT INTO cha_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Jugueffamatquilo ya juquieto gui minauleg: ya y pinitijo manatbororota. ");
INSERT INTO cha_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Y corasonjo maepe gui sanjalomjo: anae jujajaso, y guafe mañoñonggue: ayo nae cumuentos yo yan y jilajo. ");
INSERT INTO cha_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Natungo yo, Jeova, ni uttimoco, yan y medidan y jaanijo cuanto guaja; natungoyo jafa na checayo. ");
INSERT INTO cha_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Estagüe na un atafja unnae y jaanijo; ya y sacanjo calangja taya gui menamo: sen magajet na todo y taotao taebale anae guaja mas balotña. ");
INSERT INTO cha_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Senmagajet na calang anineng jumajanao todo y taotao: senmagajet na taesetbe y atborotoñija: Sa manrecocoje y güinaja ya ti jatungo jaye y chinile. ");
INSERT INTO cha_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Ya pago, Jeova, jafa junangga? y ninanggaco gaegue guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Nalibre yo gui todo y tinaelayeco, chamoyo pumopolo na jumanamamajlao gui taetiningo. ");
INSERT INTO cha_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Guajo mamatquilo, ti jubaba y pachotto: sa jago fumatinas. ");
INSERT INTO cha_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Najanao guiya guajo y sinaulagmo: sa pot y tinetpen y canaemo lumachaeyo. ");
INSERT INTO cha_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Anae unnatunas y taotao nu y linalatde, pot y tinaelaye, ninalachae y bonituña taegüije y puliya: senmagajet na todo y taotao taebale. ");
INSERT INTO cha_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Jungog y tinaetaejo, O Jeova, ecungog y inagangjo: chamo famatquilo gui menan y lagojo: sa taotao tumano yo guiya jago: pago finatoyo taegüeje y mañaenajo todos. ");
INSERT INTO cha_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Poloyo ya jufañule minetgot, antes de jujanao ya ti jutalo. ");
INSERT INTO cha_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","JUNANGGA nu y siningon as Jeova; ya janaegueng maesa güe guiya guajo, ya jajungog y inagangjo. ");
INSERT INTO cha_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Ya güiya chumule yo guinin un joyo chatliion, guinin fache na tadong: ya japolo y adengjo gui jilo acho, ya janafitme y jinanaojo. ");
INSERT INTO cha_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ya japolo gui pachotto canta na mannuebo, junggan, y alabansa gui Yuusta. Megae lumie ya manmaañao, ya ufanangoco as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Dichoso y taotao ni jaangoco gui as Jeova: ya ti jaaatan y mansobetbio ni y manabag manmalag y mandague. ");
INSERT INTO cha_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Megae O Jeova, y ninamanmanmo ni unfatinas: yan y jinasomo para jame; ti siña maaregla sija gui menamo: yaguin guajo judeclara ya jusangang sija, tisiña matufong sa gosmegae. ");
INSERT INTO cha_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Y inefresen ninae ti yamo: y talangajo jagasja unbaba: inefresen sinenggue ya y ninae pot y isao, ti jagasja ungagao. ");
INSERT INTO cha_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Ayo nae ileco: Estagüe na matoyo: gui finalulon y leblo nae esta matugue pot guajo. ");
INSERT INTO cha_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Yajo para jufatinas y minalagomo, O Yuusso: magajet na y laymo gaegue gui jalom corasonjo. ");
INSERT INTO cha_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Guajo jagas jusangan y tininas gui jalom y dangculo na inetnon taotao: estagüe, na ti junaquiequeto y labiosso, O Jeova, jago tumungo. ");
INSERT INTO cha_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Ti junaatog y tininasmo gui jalom corasonjo; y minagajetmo yan satbasionmo jagas jusangan: ti jupune y minaasemo yan y minaulegmo gui dangculon inetnon taotao. ");
INSERT INTO cha_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Jago, O Jeova, chamo dumitietietene y minaasemo para guajo: sa y minaasemo yan y minagajetmo juadadaje yo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Sa gaegue gui oriyajo y tinaelaye asta ti tufungon: jajiguef yo y tinaelayeco sija, ya ti siña juatan julo; megaeña mas que y gapotulo gui ilujo, ya y corasonjo yafae esta. ");
INSERT INTO cha_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Malagojao, O Jeova, unnalibreyo: O Jeova, laguse para unayudayo. ");
INSERT INTO cha_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Polo ya ufanmamajlao ya ufaninestotba ayo y umaliligao y antijo para uyulang: polo ya ufanalo tate ya ufanmamajlao, ni y yañija y munataelaye yo. ");
INSERT INTO cha_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Polo ya ufanlapoble sija, pot y minamajlaoñija, ni y umaalog ni guajo: Ja, ja. ");
INSERT INTO cha_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Polo ya ufanmagof ya ufansemagof ni jago, todo y umaliligao jao: ya polo ya siesiempreja ujaalog, y gumaeya y satbasionmo: Ladangculo Jeova. ");
INSERT INTO cha_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Ya guajo pobleyo ya nesesitaoyo; lao si Jeova jajajasoyo. Jago y umayuyudayo yan y munalibre yo: O Yuusso, chamo atrasasao. ");
INSERT INTO cha_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","DICHOSO ayo y maase ni y mamoble; sa y jaanen y tinaelaye nae, si Jeova ulinibre. ");
INSERT INTO cha_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Si Jeova uinadajegüe, yan umantiene güe lâlâ; ya güiya udichoso gui tano; ya tiuenentrega güe gui minalago y enemiguña. ");
INSERT INTO cha_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Si Jeova uinayuda güe jilo camaña ni y pinitiña; unfatinas todo y camaña anae malango. ");
INSERT INTO cha_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Guajo ilegco: Jeova gaease nu guajo: najomlo y antijo; sa umisaoyo contra jago. ");
INSERT INTO cha_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","y enemigujo jasangan y taelaye contra guajo ilegñija: Ngaean umatae, ya ufalingo y naanña? ");
INSERT INTO cha_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Anae mato para uliiyo, jasangan y taebale; y corasonña nae mandaña y tinaelaye pot güiyaja; anae jumanao juyong jasangan ayo. ");
INSERT INTO cha_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Todo y chumatliiyo manañangon entre sija contra guajo; contra guajo nae majaso y tinaelayeco. ");
INSERT INTO cha_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Ti mauleg na chetnot, ilegñija, sumaga guiya güiya; sa anae umason gui cama ti siña ninacajulo talo. ");
INSERT INTO cha_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Ya ayo y güinaeyaco nae juangocoyo, güiya y cumano y najo pan, jajatsa y dedegoña contra guajo. ");
INSERT INTO cha_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Lao jago Jeova, gaease nu guajo, ya unacajuloyo, para juapase sija. ");
INSERT INTO cha_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Pot este jutungo, na unmagof guiya guajo, sa y enemigujo ti ujagana yo. ");
INSERT INTO cha_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ya guajo, gui quinabalesso unmantieneyo; ya unpoloyo gui menamo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Bendesido si Jeova ni y Yuus Israel, ni y taejinecog, yan taejinecog. Amen, Amen. ");
INSERT INTO cha_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","TAEGÜIJE y benabo ni y guija, ni y malago ni y minilalag y janom: taegüijeja locue y antijo sumospípiros pot jago, O Yuus. ");
INSERT INTO cha_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Y antijo majo pot si Yuus, pot y lalâlâ na Yuus; ngaean nae jufato, ya juanog gui menan Yuus? ");
INSERT INTO cha_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Y lagojo guinin nengcanojo, jaane yan puenge, ya todo y jaane ilegñiñijaja nu guajo: Manggue y Yuusmo? ");
INSERT INTO cha_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Anae jujaso estesija, machuda juyong y antijo guiya guajo, anae manmalofan y linajyan taotao, maposyo, ya jucone sija asta y guimayuus; yan y minagof, yan y tinina; un linajyan na umadadaje y guipot na jaane. ");
INSERT INTO cha_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Jafa na dumilogjao, O antijo? yan jafa na estotbajao gui jinalomjo? Nangga jao si Yuus, sa guajo bae jutuna güe pot y ayudo gui menaña. ");
INSERT INTO cha_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Yuusso, y antijo esta dumilog gui jinalomjo; pot enao na jujajasojao desde y tano guiya Jordan, yan Hermonitas, desde y egso Misar. ");
INSERT INTO cha_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Un tinadong, jaagang y otro tinadong, pot palangpang y janommo sija: todo y napomo, yan y langatmo, manmalofan gui jilojo. ");
INSERT INTO cha_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Jatago si Jeova y minaaseña gui jaane, ya y puenge y cantaña guiya guajo, ya y tinaetae para y Yuus a linâlâjo. ");
INSERT INTO cha_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Jualog as Yuus, y achojo: Jafa na malefajao nu guajo? Jafa mina na tristeyo pot y chiniguit y enemigo? ");
INSERT INTO cha_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Parejoja yan y espada gui telangjo, y enemigujo mamofeayo, anae ilegñija cada jaane nu guajo: Mano nae gaegue y Yuusmo? ");
INSERT INTO cha_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Jafa na dumilog jao, O antijo? yan jafa na, estotbajao gui jinalomjo? Nangga si Yuus, sa bae jutuna güe, ni y ayuda nu y matajo, yan y Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","JUSGAYO, O Yuus, ya unsangan y mumujo contra y nasion ni y ti manjonggue: O coneyo gui manmandadague, yan y manaelaye na taotao. ");
INSERT INTO cha_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Sa jago Yuus y ninasiñajo; jafa na unrechasa? ya fafa mina tristeyo pot y chiniguit y enemigo? ");
INSERT INTO cha_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","O tago y mananamo, yan y minagajetmo; ya uesgaejonyo: ya uchuleyo asta y santos na egsomo, yan y tabetnaculumo. ");
INSERT INTO cha_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Sa bae jujalom gui attat Yuus, y as Yuus nae gaegue y dangculon minagofjo; Ja jutuna jao yan y atpa, O Yuus, Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Jafa na dumilog jao, O antijo? yan jafa na estotba jao gui jinalomjo? Nangga si Yuus; sa bae jutuna güe, ni y inayuda nu y matajo, yan y Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","JAME injingog ni y talanganmame, O Yuus, na jasanganejam y tantanmane, ni y finatinasmo gui tiemponñija, gui antiguo na tiempo. ");
INSERT INTO cha_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Nu y canaemoja unyute y nasion, ya unpolo sija; unnafantriste y taotao sija, ya unnafanjanao. ");
INSERT INTO cha_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Sa ti inchile y tano pot espadanñija para iyonñija, ni ti unnafanlibre pot y canaeñija; lao y agapa na canaemo yan y canaemo, yan y minalag y matamo, sa unguaeya sija. ");
INSERT INTO cha_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Jago y Rayjo, O Yuus: fanago linibre para si Jacob. ");
INSERT INTO cha_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Pot jago na inyite papa y enemigonmame: pot y naanmo, na ingacha y mangajulo contra jame. ");
INSERT INTO cha_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Sa ti juangocoyo ni y flechaco, ni y espadajo ti ulibreyo. ");
INSERT INTO cha_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Sa jago umadadajejam gui enemigonmame; ya y chumatliijam unnafanmamajlao. ");
INSERT INTO cha_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Ya gui as Yuus tatunanmaesa jit todot dia; ya para taejinecog, intina y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Lao pago unyute jam, ya unnafanmamajlaojam; ya ti jumanaojao yan y inetnon sendalonmame. ");
INSERT INTO cha_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Unbirajam tate guinin y enemigonmame; ya ayo sija y chumatliijam, manmañaque para sija namaesa. ");
INSERT INTO cha_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Unpolojam taegüije y quinilo ni y para umacano; ya janafanmachalaponjam gui entalo y nasion. ");
INSERT INTO cha_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Unbende y taotaomo pot taya; ya ti mumegae y güinajamo pot y balenñija. ");
INSERT INTO cha_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Unnafanmamajlaojam ni y tiguangmame; pot y manmanmofefea, yan manmanbotlelea ni y mangaegue gui oriyanmame. ");
INSERT INTO cha_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Unnafanmafa y sinanganjam gui entalo y nasion, pot y yinengyong y ilonñija gui entalo y taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Y desenrajo gaegueja gui menajo todot dia; ya y minamajlao y matajo jatampe yo. ");
INSERT INTO cha_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Sa y inagang ayo y numanamamajlao, yan y chumatfino contra si Yuus; pot y enemigo yan y taotao ni y maneemog. ");
INSERT INTO cha_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Todo este manmato guiya jame; lao ti manmalelefajam nu jago, ni ti manmatinasjam mandague ni y tratumo. ");
INSERT INTO cha_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Y corasonmame ti inbira tate; ni y pinecatmame ti sumuja gui chalanmo. ");
INSERT INTO cha_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Masqueseaja unyamagjam gui sagan y jacal sija, ya untampejam ni y aninen y finatae. ");
INSERT INTO cha_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Yanguin manmalefajam ni y naan Yuusmame, ya inestira y canaemame pot y otro Yuus; ");
INSERT INTO cha_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Ada ti ualigaojam si Yuus? Sa jatungoja y secreton y corason. ");
INSERT INTO cha_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Junggan, pot y jago manmapunojam todo y inanaco y jaane; manmatufongjam taegüije y quinilo ni y para umapuno. ");
INSERT INTO cha_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Fagmata, jafajao na mamaego, Señot? Cajulo, chamojam yumuyute para siempre. ");
INSERT INTO cha_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Pot jafa nae unnaatog y matamo, ya malefajao ni y pinitenmame yan y chiniguitmame. ");
INSERT INTO cha_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Y antenmame esta dumilog gui petbos; ya y tiyanmame cheton papa gui tano. ");
INSERT INTO cha_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Cajulo ya unayudajam, ya unnafanlibrejam gui minaasemo. ");
INSERT INTO cha_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Y corasonjo machúchuda nu y mauleg na güinaja; jusangan ayo sija y para y ray; y jilajo, calang y pluman y chadeg mangue. ");
INSERT INTO cha_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Guefpaguñajao qui y famaguon y taotao sija: y grasia machúchuda jalom gui labiosmo; enaomina binendisejao as Yuus, para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Gode y espadamo gui cháchagamo, O gosbalente jao, yan y langetmo yan y minagasmo. ");
INSERT INTO cha_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ya y minagasmo sigue di mumegae, sa pot y minagajet, yan y minanso, yan tininas: ya y agapa na canaemo unfinanagüe ni y mannamaañao na güinaja. ");
INSERT INTO cha_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Y flechamo manacadedog; mamodong y taotao gui papamo; sija gaegue gui corason y enemigon y ray. ");
INSERT INTO cha_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Y tronumo taejinecog, yan taejinecog, O Yuus: y bariyan y raenomo, tunas na bariya. ");
INSERT INTO cha_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Unguaeya y tininas, ya unchatlie y tinaelaye; enaomina si Yuus ni y Yuusmo, pinalaejao ni y lañan minagof, mas qui y mangachongmo. ");
INSERT INTO cha_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Todo y magagumo mamaopao ni y mira, yan y chaguan na jajatot, yan y casia; manjuyong gui palasyon matfit, anae guinatbon musica manamagofjao. ");
INSERT INTO cha_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Y jaga sija y ray, mangaegue gui entalo y manonrada na famalaoanmo; ya y rayna matátachong gui agapamo yan y magaguña y oron Ofir. ");
INSERT INTO cha_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Jungog O jaga, jaso ya tecon y talangamo; ya unmalefa ni y mañataotaomo, yan y guima tatamo. ");
INSERT INTO cha_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Ya ugosmalago y ray ni y bonitamo; sa güiya y Señotmo yanguin unadora güe. ");
INSERT INTO cha_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Ya y jagan Tiro yan y ninae ugaegue güije; asta y manrico gui entalo y taotao unmagaogao ni y fabotmo. ");
INSERT INTO cha_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Y jagan y ray, gui palasyo gosbonita güe: y magaguña maadotna ni y oro. ");
INSERT INTO cha_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Macone guato gui as ray, yan y magaguña ni y mabotda: y bitgen sija mangachongña ni y tumattitiye, sija unquinenie guato. ");
INSERT INTO cha_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Sija machulilie guato yan minagof yan alegria: ufanjalom gui palasyon y ray. ");
INSERT INTO cha_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Gui lugat si tatamo, y ugaegae y famaguonmo; unnafanprinsipe gui todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Guajo junamajaso y naanmo gui todo y generasion sija: enaomina y taotao sija mannaejao grasias para taejinecog yan taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","SI Yuus, güiya y guinegüeta yan y minetgotta, enseguidas manayuda gui chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Enaomina mungajit manmaañao, achogaja ucalamten y tano, yan y egso umachule asta y talo gui tase sija; ");
INSERT INTO cha_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Achogaja manapangpang y janom ya chatsaga; achogaja umayeyengyong y egso sija, pot causa y minatatgaña. Sila. ");
INSERT INTO cha_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Ayogüeja y sadog yan y minilalagña sija janamamagof y siuda Yuus; y santos na sagan y tabetnaculo guiya Gueftaquilo. ");
INSERT INTO cha_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Si Yuus gaegue gui entaloña; ti ucalamten; si Yuus uinayuda y ininan y egaan. ");
INSERT INTO cha_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Manlalalo y nasion sija, ya mangalamten y raeno sija; umagang, ya maderite y tano. ");
INSERT INTO cha_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Manjijita yan y Señot y inetnon sendalo. Y Yuus Jacob, güiya y guinegüeta. Sila. ");
INSERT INTO cha_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Maela ya inlie y checho Jeova; Jafa na yinilang jafatinas gui jilo tano? ");
INSERT INTO cha_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Güiya munabasta y guera, asta y uttimon y tano; jayulang y atcos, ya jautut y lansa; güiya sumonggue y caretan guera gui guafe. ");
INSERT INTO cha_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Quieto, ya untungo na guajo si Yuus: jutaquilo gui entalo y nasion sija, jutaquilo gui tano. ");
INSERT INTO cha_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Manjijita yan y Señot y inetnon sendalo. Y Yuus Jacob, güiya y guinegüeta. Sila. ");
INSERT INTO cha_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","NAFAMAGPAG y canaemiyo todo jamya na taotao; agang si Yuus ni y inagang guinana. ");
INSERT INTO cha_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Sa si Jeova sentaquilo yan namaañao; Güiya mas dangculo na ray gui jilo todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Güiya ugana todo y taotao ya upolo gui papata; yan y nasion sija gui papa adengta. ");
INSERT INTO cha_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Güiya umayig y erensiata ni y para jita: y minagas gui as Jacob ni y güinaeyaña. Sila. ");
INSERT INTO cha_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Si Yuus mapos julo yan y inagang, si Jeova yan y sonidon y trompeta. ");
INSERT INTO cha_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Fanganta tinina sija para si Yuus; fanganta tinina sija; fanganta tinina sija para y rayta, fanganta tinina sija. ");
INSERT INTO cha_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Sa si Yuus güiya ray todo y tano: fanganta y tinina sija, yan y tiningo. ");
INSERT INTO cha_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Si Yuus mangobiebietna gui jilo y nasion sija; si Yuus matatachong gui tronon y sinantosña. ");
INSERT INTO cha_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Sa y prinsipen y taotao sija mandaña ufantaotao y Yuus Abraham; sa y patang y tano, iyon Yuus: Güiya y sentaquilo. ");
INSERT INTO cha_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","DANGCULO si Yuus, ya para umagueftuna, gui siuda y Yuusta, gui egso y sinantosña. ");
INSERT INTO cha_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Bonito na sagayan, y minagof todo gui tano, y egso Sion gui sumanlago na banda, siuda y dangculo na ray. ");
INSERT INTO cha_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Si Yuus esta matungo gui jalom y palasyoña, na para y guinegüe. ");
INSERT INTO cha_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Sa estagüe y ray sija na mandaña, manmalofan ya mandadañaja. ");
INSERT INTO cha_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Manmalie, ya luego ninafanmanman; ninafañatsaga, ya maninalulula manjanao. ");
INSERT INTO cha_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Y mayengyong gumote sija güije; yan y pinite taegüije y palaoan yan para ufañago. ");
INSERT INTO cha_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Jago yumamag y batcon Tarsis, ni y manglo sancatan. ");
INSERT INTO cha_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Jaftaemanoja y jiningogmame, taegüijeja liniimame gui siuda y Señot y inetnon sendalo; gui siuda y Yuusmame: si Yuus plumanta para taejinecog. Sila. ");
INSERT INTO cha_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Injaso y güinaeyamo, O Yuus, gui talo gui templomo. ");
INSERT INTO cha_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Jaftaemanoja y naanmo, O Yuus, taegüijeja y tininamo asta y uttimon y tano: y agapa na canaemo, bula ni y tininas. ");
INSERT INTO cha_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Namagof y egso Sion, yan sija jagan Juda ufanmagof; pot y jinisgamo sija. ");
INSERT INTO cha_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Famocat gui Sion, ya unjanagüe y oriyaña; ya untufong y tore güije. ");
INSERT INTO cha_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Matca y colatña ni y munaseguguro, ya injaso y palasyoña; para usiña jamyo insangane y generasion ni y mamamaela. ");
INSERT INTO cha_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Sa este na Yuus, y Yuusta para taejinecog, yan taejinecog: güiya uesgaejonjit, asta y finataeta. ");
INSERT INTO cha_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","JINGOG este todo jamyo ni y taotao; ecungog jamyo todos ni y mañasaga. gui tano: ");
INSERT INTO cha_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Jamyo todo mandaña, y managpapa, y managquilo, y manrico, yan y mamoble. ");
INSERT INTO cha_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Y pachotto usangan y minalate; ya y jinason y corasonjo y tiningo. ");
INSERT INTO cha_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Bae juecungog y parabola; ya jubaba y jemjom sinanganjo gui atpa. ");
INSERT INTO cha_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Sajafa na maañaoyo gui jaanen y tinaelaye, anae y tinaelayen y dedegoco jaoriyayayeyo? ");
INSERT INTO cha_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Ayo y umangongoco sija ni y güinajañija, yan jatunanmaesaja ni y minegae y riniconñija; ");
INSERT INTO cha_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Taya guiya sija siña umapasiye y cheluña, ni unae si Yuus ni y rumescata güe; ");
INSERT INTO cha_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","(Sa y ninálibre y antinñija, dangculo presiuña, ya para upolu para siempre.) ");
INSERT INTO cha_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Para ulâlâ asta y taejinecog, ya ti ulie minitong. ");
INSERT INTO cha_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Sa jalie na y manmalate na taotao sija manmamataeja, y manaejinaso yan y manbababa, manmalingo, ya japolo y güinajañija para y palo. ");
INSERT INTO cha_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Y jinason y sumanjalomñija, na y guimañija usaga para taejinecog, ya y anae mañasaga na lugat para y todo generasion sija; ya jafanaan y tanoñija, ni y naanñijaja. ");
INSERT INTO cha_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Lao y taotao ti sumaga gui onraña, parejoja yan y gâgâ na matae. ");
INSERT INTO cha_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Este y jinanaoñiñija, y binabanñiñijaja; ya anae esta manmapos, manmagof y taotao nu y sinanganñija. Sila. ");
INSERT INTO cha_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Sija ufanquinano gui naftan parejoja yan y manadan quinilo y finatae upinasto sija; ya y manunas mangaeninasiña gui jiloñija gui egaan; ya y boninituñija, para ulachae gui jalom naftan, sa taya sagaña. ");
INSERT INTO cha_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Lao si Yuus unalibre y antijo gui ninasiñan y naftan; sa uresibeyo. Sila. ");
INSERT INTO cha_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Chamo maaañao, yanguin guaja taotao urico; yanguin y güinaja, y guimaña mumémegae; ");
INSERT INTO cha_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Sa yanguin matae, taya uchule; y güinajaña, ti udinalalaggüe. ");
INSERT INTO cha_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Achogaja anae lalâlâ, dichoso y antiña; sa matutunajao ni y taotao sija, yanguin unfamauleg mamaesajao. ");
INSERT INTO cha_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Ujanao para y generasion tataña; ti ufanmanlie manana. ");
INSERT INTO cha_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Y taotao ni y maoonra, ya ti matungo; parejoja yan y gâgâ ni y umatae. ");
INSERT INTO cha_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","SI Yuus, junggan, si Yuus, si Jeova sumangan, ya jaagang y tano desde y quinajulo y atdao asta y tumunogña papa güije. ");
INSERT INTO cha_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Y sumanjiyong Sion, gosbonito, sí Yuus umiina. ");
INSERT INTO cha_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Y Yuusta ufato, ya ti ufamatquilo: y guafe ufanlinachae gui menaña, ya uguaja dangculon pinagyo gui oriyaña. ");
INSERT INTO cha_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","uagang gui taquilo na langet yan y tano, para ujusga y taotaoña. ");
INSERT INTO cha_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Nafandaña y mañantos guiya guajo; ayo sija y fumatinas y tratujo pot y inefrese. ");
INSERT INTO cha_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Y langet udineclara y tininasña: sa si Yuus güiyaja y jues. Sila. ");
INSERT INTO cha_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Jingog, O taotaojo, ya jusangan; O Israel, ya bae jusangan testimonio contra jago: guajo si Yuus, ni si Yuusmo. ");
INSERT INTO cha_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ti julalatde jao pot y inefresimo, ya y inefresimo sinenggue, para todo y jaane gui menajo. ");
INSERT INTO cha_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Sa ti jufangone nubiyo gui guimamo, ni laje na chiba gui quelatmo. ");
INSERT INTO cha_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Sa todo y gâgâ gui jalom tano, gâjo, yan y gâgâ sija gui jilo y mit na sabana. ");
INSERT INTO cha_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Sa jutungo todo y pajaro gui jalom tano; y manmachaleg na gâgâ sija gui jalomtano; todo gâjo. ");
INSERT INTO cha_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Yanguin ñalangyo, ti jusanganejao; sa iyoco y tano, yan y sinajguanña. ");
INSERT INTO cha_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Juchoco catnen nubiyo, pat jugui. men jâgâ chiba? ");
INSERT INTO cha_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Nae si Yuus inefresen grasia; ya unapase y promesamo gui Gueftaquilo. ");
INSERT INTO cha_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ya unagangyo gui jaanen y chinatsaga: junalibrejao, ya siempre unonrayo. ");
INSERT INTO cha_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Lao ilegña si Yuus ni y manaelaye; Jafa unfatinas para undeclara y tina. gojo, pat jagas unchule y tratujo gui pachotmo? ");
INSERT INTO cha_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Sa jago unchatlie y finanagüe, ya unyute y sinanganjo gui tatemo. ");
INSERT INTO cha_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Anae unlie y saque, undalalag güe; yan jagas gaepattejao yan y manábale. ");
INSERT INTO cha_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Sa unnasetbe y pachotmo gui tae laye, ya y jilamo fumatitinas ocodon dinague. ");
INSERT INTO cha_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Matátachongjao, ya cumuecuentosjao contra y chelumo; undesonra y lajin nanamo. ");
INSERT INTO cha_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Estesija finatinasmo, lao mamatquiquilojayo: jinasomo na parejojitja: lao bae julalatdejao, ya jupolo tinaelayemo sija gui menan matamo. ");
INSERT INTO cha_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Pago jaso este, jamyo ni y manmalefa as Yuus; na noseaja jusisi jamyo ya jufapidasos, ya taya unalibre. ");
INSERT INTO cha_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Y numaeyo inefresen tinina, jaonrayo; ya ayo y munatutunas y sinanganña, jufanue ni y satbasion Yuus. ");
INSERT INTO cha_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","GAEASE nu guajo, O Yuus, jaftaemanoja y minauleg güinaeyamo, jaftaemanoja y minegae y minaasemo; fuñas y tinaelayeco. ");
INSERT INTO cha_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Gosfagaseyo todo ni y tinaelayeco, ya unnagasgasyo ni y isaojo. ");
INSERT INTO cha_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Sa jutungoja y tinaelayeco: ya y isaojo gaegueja siempre gui menajo. ");
INSERT INTO cha_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Sa contra jago, jagoja, juisagüe, ya jufatinas y daño gui menan matamo: para utunas yanguin cumuentosjao, ya utaefatta yanguin manjusgajao. ");
INSERT INTO cha_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Estagüeja, na mafatinasyo gui tinaelaye, yan y isao nae si nanajo mumapotguenaejonyo. ");
INSERT INTO cha_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Estagüeja, na unguaeya y magajet guiya jalolom; ya y umatog na lugat nae unnatungoyo ni y tiningo. ");
INSERT INTO cha_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Nagasgasyo ni hisopo, ya jumuyong gasgas: fagaseyo ya jumuyong apacaña, qui y niebe. ");
INSERT INTO cha_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Nafanjungogyo minagof yan y alegria para ufanmagof y telangjo ni y unyamag. ");
INSERT INTO cha_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Naatog y matamo gui isaojo; ya unfunas todo y inechongjo. ");
INSERT INTO cha_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Fatinas gui sumanjalomjo y gasgas na corason, O Yuus; ya unnanuebo y tinas na espiritu gui sumanjalomjo. ");
INSERT INTO cha_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Chamo yumuyuteyo gui menamo; yan chamo chumuchule y santos na Espiritumo guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Natalo mague guiya guajo y minagof y satbasionmo: ya unmantieneyo ni y libre na Espiritumo. ");
INSERT INTO cha_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ayo nae jufanagüe y manaelaye ni y chalanmo: ya y maniisao ufanmañotsot guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Nalibreyo gui isao gui jâgâ, O Yuus, jago Yuus y satbasinojo; ya y jilajo ucanta agang ni y tininasmo. ");
INSERT INTO cha_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Jeova, baba y labiosso: ya y pachotto ufamanue ni y matunamo. ");
INSERT INTO cha_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Sa ti yamo inefrese para junaejao; ti magofjao ni y inefresen sinenggue. ");
INSERT INTO cha_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Y inefrese para si Yuus, manmayamag na espiritu: y mayamag yan y pinite na corason, O Yuus, jago siempre ti undespresia. ");
INSERT INTO cha_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Fatinas mauleg, ni y minauleg minagofmo, guiya Sion; fatinas y quelat Jerusalem. ");
INSERT INTO cha_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ayo nae unmagof ni y inefresen tininas, y inefresen sinenggue yan y cabales na inefresen sinenggue: Ayo nae unmaofrese nubiyo gui attatmo. ");
INSERT INTO cha_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","JAFA na tunanmaesajao gui inacacha, O matatnga na taotao? y minaasen Yuus sumasagaja cada jaane siempre. ");
INSERT INTO cha_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Y jilamo fumatitinas ocodon y taelaye: parejo yan y malagtos na inabajan batbas, machochoeho dinague. ");
INSERT INTO cha_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Unguaeyaña y daño mas qui y mauleg; yan y mandague, mas qui cumuentos ni y tininas. Sila. ");
INSERT INTO cha_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Unguaeya todo y mannanataelaye na sinangan: O, dacon na jula. ");
INSERT INTO cha_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Si Yuus unyinilang locue para taejinecog; unquinene, ya unjinala juyong gui guimamo magago; ya unjinale juyong gui tano y lalâlâ. Sila. ");
INSERT INTO cha_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Ya umalie ni y manunas; ya umaañao, ya umachatchatgue, ilegñija: ");
INSERT INTO cha_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Estagüe, yuje na taotao y ti japolo si Yuus para minetgotña: lao jaangoco güe ni y manadan güinajaña, ya janametgot güe ni y tinaelayeña. ");
INSERT INTO cha_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Lao guajo, parejoyo yan y betde na troncon oliba gui jalom guimayuus; juangongocoyo ni y minaase Yuus para taejinecog, yan taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Junaejao grasias, para taejinecog, sa unfatinas este; ya junangga y naanmo, sa este mauleg; gui menan y mañantosmo. ");
INSERT INTO cha_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","ILEGÑA y taetiningo gui corasonña: Taya Yuus. Manpotlilo sija, mafatinas y chatliion na tinaelaye; taya ni uno ni fumatitinas mauleg. ");
INSERT INTO cha_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Si Yuus gui langet tumalag pápapa y famaguon taotao sija; para ulie cao guaja gaetiningo, ni y umaliligao si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Todos sija manalo tate; ya manjuyong potlilo sija; taya ni uno ni fumatitinas y mauleg, aje, taya ni uno. ");
INSERT INTO cha_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Taya tiningoñija ni chumogüe inechong? ni y macano y taotaojo sija, taegüije yan mañochocho pan: ya ti maagang si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Mangosmanmaañao sija gui anae taya minaañao: sa si Yuus janafanmachapon adisapatta y telang ayo y tumotojgue contra jago; jago jagas unnafanmamajlao, sa si Yuus manrenechasa sija. ");
INSERT INTO cha_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","O, na y satbasion Israel mojon ujuyong guiya Sion! anae si Yuus janatalo y quinautiba y taotaoña; ayo nae umagof si Jacob, yan ufanmagof y Israel. ");
INSERT INTO cha_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","SATBAYO, O Yuus, pot y naanmo, ya unjusgayo pot y minetgotmo. ");
INSERT INTO cha_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Jungog y tinaetaejo, O Yuus; ecungog y sinangan y pachotto. ");
INSERT INTO cha_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Sa y taotao juyong sija mangajulo contra guajo, yan y taotao ni y fijon y minatatgañija maaliligao y antijo; sija jagasja ti japopolo si Yuus gui menanñija. Sila. ");
INSERT INTO cha_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Estagüe na si Yuus umayuyudayo; si Jeova mañisija yan ayo y mumantietene y antijo. ");
INSERT INTO cha_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Güiya uapase taelaye y enemigujo sija; yulang sija gui minagajetmo. ");
INSERT INTO cha_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Sa inefresijo ni y minalagojo bae junaejao; bae jualaba y naanmo, O Jeova, sa mauleg. ");
INSERT INTO cha_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Sa güiya munalibreyo todo gui chinatsaga: sa y atadogjo jagasja jalie y minalagojo contra y enemigujo. ");
INSERT INTO cha_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","JUNGOG y tinaetaejo, O Yuus: ya chamo umaatog maesa jao gui guinagaojo. ");
INSERT INTO cha_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Atituyeyo, ya opeyo: sa inestotbayo gui trinistieco, ya umugongyo; ");
INSERT INTO cha_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Sa pot y inagang y enemigo: sa pot y chiniguit y manaelaye; sa mayute y tinaelaye gui jilojo, ya pot y biniboñija, na machatliiyo, japetsigueyo. ");
INSERT INTO cha_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Y corasonjo gospute gui sumanjalomjo: yan y minaañao y finatae podong gui jilojo. ");
INSERT INTO cha_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Minaañao yan linaolao, manmato guiya guajo; y linijan ñumoñoyo. ");
INSERT INTO cha_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Ya ilegco: O mojon yanguin gaepapayo, taegüije y paluma! ayo nae jugupo chago, ya judescansa. ");
INSERT INTO cha_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Estagüe, ayo nae jujanao chago, ya jusaga gui jalomtano. Sila. ");
INSERT INTO cha_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Mojon bae jualula malag y guinegüe, guinin y duron manglo yan y pinagyo. ");
INSERT INTO cha_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Yulang, O Jeova, ya ipe y jilañija; sa jagasja julie y fijom na manaelaye, ya y manmanpotfifia gui siuda. ");
INSERT INTO cha_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Jaane yan puenge manjajanao gui sumanjilo y quelatña: inechong yan inacacha mangaegue gui entaloña. ");
INSERT INTO cha_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Manaelaye mangaegue gui entaloña; chiniguit yan dinague ti usuja gui chalanña. ");
INSERT INTO cha_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Sa ti y enemigo lumalatdeyo; ayo nae siña jusungon; ni ti ayo y chumatliiyo ni y munadangculo güe contra guajo: ayo nae junaatog maesayo guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Lao jagoja, un taotao, ni y parejujo, yan y gachongjo, yan y senjuguflie na amigujo. ");
INSERT INTO cha_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Sa y mamis na inangoco manasangane jam y jinasonmame; ya tafanmamocat yan linajyan taotao gui guimayuus. ");
INSERT INTO cha_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Polo sija ya derepente ufanchinile ni y finatae: polosija ya ufansinetta papa manlalâlâ guiya sasalaguan; sa guaja y manaelaye gui sagañija yan y sanjalomñija. ");
INSERT INTO cha_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Lao guajo, bae juagang si Yuus; ya si Jeova usatbayo. ");
INSERT INTO cha_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Pupuenge, ogaan, yan taloane, jufanjaso ya juagang duro, ya güiya ujungog y inaganjo. ");
INSERT INTO cha_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Güiya jagasja munalibre y antijo qui pas, guinin y guera ni y comontrayo: sa megae pumotfifia yo. ");
INSERT INTO cha_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Si Yuus ufaninjingog, ya ufaninepe sija; asta ayo y mañasaga desde y apmam na tiempo. Sila. Ti taotao sija ni siempre jatulaeca, ya ti manmaañao as Yuus. ");
INSERT INTO cha_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Jaestira mona y canaeña contra ayo sija ni y manpas guiya güiya: jayulang y tratuña. ");
INSERT INTO cha_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Y sinangan y pachotña palagseña qui y mantica, lao guera gui jalom corasonña; y sinanganña mananana qui y laña; lao puro ayo sija espada in malagnos. ");
INSERT INTO cha_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Polo y catgamo gui as Jeova, ya güiya uminantiene; sa taya nae jasotta y manunas ya umanacalamten. ");
INSERT INTO cha_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Lao jago, O Yuus, ufansinetta sija papa gui joyon finatae; sa y manmejgá, yan manfáfababa na taotao sija, ti ufanlâlâ ni lamita gui jaaniñija; lao guajo juangocoyo nu jago. ");
INSERT INTO cha_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","GAEASE nu guajo, O Yuus; sa y taotao malago na ujapañotyo; mumumo todot dia, ya jachichiguityo. ");
INSERT INTO cha_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Todot dia y enemigujo manmalago na ujapañotyo; sa megae mamumujo ya mansobetbio. ");
INSERT INTO cha_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Jafaja na tiempo nae maañaoyo, juangocojayo guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Gui as Yuus jualaba y finoña; gui as Yuus nae jagasja jupolo y inangococo, ti maañaoyo; jafa ufatinas y catne guiya guajo? ");
INSERT INTO cha_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Todot dia mabira y sinanganjo; sa todo y jinasoñija contra guajo para tinaelaye. ");
INSERT INTO cha_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Mandaña ya manatog maesasija; ya magueguesatituye y pinecatjo, anae jagas mananangga sija y antijo. ");
INSERT INTO cha_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Ufanescapa nu y tinaelaye? gui binibo nae unyute papa y taotao sija, O Yuus. ");
INSERT INTO cha_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Jago sumangan y jinanaojo; polo gui jalom boteyamo y lagojo: manaegüe sija gui leblomo? ");
INSERT INTO cha_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Ayo nae, ujabira sija tate y enemigujo y jaane nae juagangjao; este jutungo, na si Yuus para guajo. ");
INSERT INTO cha_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Gui as Yuus jualaba y finoña: gui as Jeova jualaba y finona. ");
INSERT INTO cha_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Gui as Yuus nae jagasja jupolo y inangococo; ya siempre ti jumaañao; jafa y taotao ufatinas guiya guajo? ");
INSERT INTO cha_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Y promesamo gaegue guiya guajo, O Yuus: ya juapasejao siempre ni y inefresen grasias. ");
INSERT INTO cha_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Sa jagasja unnalibre y antijo gui finatae; ti siempre unnalibre y adengjo an podong? para jufamocat gui menan Yuus gui candet y manlálâlâ. ");
INSERT INTO cha_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","GAEASE nu guajo, O Yuus, gaease nu guajo; sa y antijo guinegüe güe guiya jago: magajet, y anineng y papamo ugogüeyo asta qui manmalofan y chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Bae juagang si Yuus Gueftaquilo; si Yuus ni y jafatinas todo y güinaja para guajo. ");
INSERT INTO cha_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Ufanago guinin y langet ya unalibreyo; anae jalalatde ayo y malago pumañotyo. Sila. Si Yuus utago y minaaseña yan y minagajetña. ");
INSERT INTO cha_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Y antijo gaegue gui entalo y león sija: ya umaasonyo gui entalo ayo sija y minañila guafe, junggan, yan y lalajin taotao sija ni y nifenñija y lansa sija, yan flecha sija, ya y jilañija malagtos na espada. ");
INSERT INTO cha_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Nadangculojao gui jilo y langet, O Yuus; polo y inenramo todo gui sanjilo tano. ");
INSERT INTO cha_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Jagas mamatinas laso, para y pinecatto; y antijo tumecon papa; jagas manmaguadog joyo gui menajo; ya sija mamodong maesaja gui taloloja. Sila. ");
INSERT INTO cha_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Y corasonjo, esta meton, O Yuus, y corasonjo esta meton; bae jucanta, magajetja, jucanta alabansa sija. ");
INSERT INTO cha_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Fagmata, inenrajo; fagmata, guitala yan atpa; guajoja na maesa magmatayo taftaf. ");
INSERT INTO cha_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Bae junaetjao grasias, O Jeova, gui entalo y taotao sija; jucantayejao alabansa sija gui entalo y nasion sija. ");
INSERT INTO cha_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Sa asta y langet, dangculo y minaasemo, yan asta y mapagajes y minagajetmo. ");
INSERT INTO cha_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Nadangculojao gui jilo y langet, O Yuus; polo y minalagmo todo gui sanjilo y tano. ");
INSERT INTO cha_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","MAGAJET na jamyo manudo, anae debe de unfanguentos jamyo tininas? manmanjujusga jamyo tunas, O jamyo, ni y lalajin taotao sija? ");
INSERT INTO cha_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Magajet, na y jalom corason nae manmachochocho jamyo tinaelaye; intajlang gui canaenmiyo y tinaelaye gui tano. ");
INSERT INTO cha_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Y manaelaye, manaotao juyong desde y jalom tuyan: enseguidas qui manmafañago, manabag manguecuentos ni y mandague. ");
INSERT INTO cha_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Y binenoñija, parejo yan y binenon y culebbla: sija parejo yan y tangan y serpiente, ni y jajuchum talangaña; ");
INSERT INTO cha_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Ya ti jaecungog y inagang y encantador, ni y gosfaye manencanta. ");
INSERT INTO cha_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Yamag y nifenñija gui jalom pachotñija, O Yuus: yamag juyong y dangculo na nifen y patgon leon, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Polo ya ufanmadirite taegüije y janom ni y malalagoja gui iyoña: anae jaachechetgüe y flechaña, polo ya calang manutut. ");
INSERT INTO cha_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Polo ya utaegüije y acaleja ni y madirite ya umalofan: taegüije y taetiempo na mañagon palaoan, ni y ti guinin lumilie y atdao. ");
INSERT INTO cha_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Antes di usiente y lauyanmiyo y guafen y tituca, uchule sija ya unajanao, nu y remulinon manglo, ayo manbetde taegüije mansinenggue, ");
INSERT INTO cha_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Y manunas ufanmagof yanguin jalilie y inemog; ufagase y adengña gui jâgâ y taelaye. ");
INSERT INTO cha_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Para ualog y taotao: Magajet na guaja apasñija y manunas: magajet guaja si Yuus ni y manjujusga gui tano. ");
INSERT INTO cha_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","NALIBREYO gui enemigujo sija, O Yuusso; polo yo gui jilo guinin ayosija ni y mangajujulo contra guajo. ");
INSERT INTO cha_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Nalibreyo gui chumogüe y tinaelaye, ya satbayo gui manmejga na taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Sa, estagüe, na mananangga y antijo: y manmetgot mandaña contra guajo; ti pot y tinaelayeco, ni ti pot y isaojo, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Manmalago ya japrepara sija, sin y linachijo; fagmata, ya unayudayo, ya unlie. ");
INSERT INTO cha_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Jago Jeova, Yuus y inetnon sendalo, si Yuus Israel; fagmata ya unbisita todo y nasion sija; chamo gagaease ni y manaelaye. Sila. ");
INSERT INTO cha_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Manalo guato yan pupuenge: ya manboruruca taegüije y galago, ya malilicucue y siuda. ");
INSERT INTO cha_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Liija, sa mannutugap juyong guinin y pachotñija: espada sija guaja gui jalom labiosñija; jaye, ilegñiñija, cao jajungog? ");
INSERT INTO cha_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Lao jago, O Jeova, siempre unchatgue sija; siempre unmofea todo y nasion. ");
INSERT INTO cha_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","O minetgotto, junanangga jao; sa si Yuus y guimajo lumijing. ");
INSERT INTO cha_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Si Yuusso nu y minaaseña, ugaegue gui menajo: si Yuus unaliiyo y minalagojo, gui jilo y enemigujo sija. ");
INSERT INTO cha_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Chamo pumupuno sija, sa trabia ti manmalelefa y taotaojo; chalapon sija pot y ninasiñamo; ya unchule sija papa, O Jeova, patangmame. ");
INSERT INTO cha_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Pot y isao y pachotñija, yan pot y sinangan y labiosñija, polo ya ufanmacone, pot y sobetbioñija: yan pot y matdision, yan manmandadague ni y sinanganñija. ");
INSERT INTO cha_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Lachae sija ni y binibumo, lachae sija, para sija ti ufangaegue talo: ya ujatungo na si Yuus mangobiebietna gui as Jacob, asta y uttimon y tano. Sila. ");
INSERT INTO cha_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Ya an pupuenge, polo ya ufanalo guato, ya unfanboruca taegüije y galago ya umalilicue y siuda. ");
INSERT INTO cha_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Nafanjajanao julo yan papa, ya ufanmanaliligao nañija; ya usaga todo puenge yanguin ti manjaspog. ");
INSERT INTO cha_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Lao guajo, jucanta ni y ninasiñamo; magajet, na jucanta agang ni y minaasemo yan ogaan; sa guinin jago y guimajo lumijing, yan y guinegüeco gui jaanen chinatsagaco. ");
INSERT INTO cha_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Jago, O minetgotjo, jucantaye y alabansa sija; sa si Yuus y guimajo lumijing, yan y Yuus y minaasejo. ");
INSERT INTO cha_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","O Yuus, jago yumutejam, jago gumapotjam papa; guinin lalalojao; O, natalojam guato. ");
INSERT INTO cha_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Jago jagasja munamayengyong y tano; jago yumulang; nafanjomlo y yinilangña sija, sa manmayeyengyong. ");
INSERT INTO cha_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Unfanue y taotaomo sija ni y manmajetog na güinaja; unnafanguimenjam ni y binon na matulalaejon. ");
INSERT INTO cha_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Unnae ayo sija ni y manmaañao nu jago, un bandera para ujatsa pot y minagajet. Sila. ");
INSERT INTO cha_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Sa para ufanlibre y güinaeyamo; satba ni y agapa na canaemo, yan opejam. ");
INSERT INTO cha_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Si Yuus sumangan y sinantosña; siempre jumagof; ya siempre judibide iya Siquem, ya jumide y bayen Sucot. ");
INSERT INTO cha_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Iyoco Galaad, ya iyoco Manases: Efraim y guinegüe y ilujo; Juda y baston minagasso. ");
INSERT INTO cha_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moab, y palanggana para jufagagaseyo; y jilo Edom nae juyute y sapatosso: Filistia, agangjao pot guajo. ");
INSERT INTO cha_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Jaye uchinileyo guato gui fitme na siuda? jaye uesgaejonyo guato Edom? ");
INSERT INTO cha_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Mungajao, O Yuus, ni y guinin yumutejam? yan jago, O Yuus, ti jumanao yan y inetnon sendalonmame. ");
INSERT INTO cha_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Naejam inayuda contra y contrario gui chinatsaga; sa taebale y inayudan taotao. ");
INSERT INTO cha_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Guinin as Yuus nae infatinas y minatatnga; sa güiyaja ni ugacha papa y contrarionmame. ");
INSERT INTO cha_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","JUNGOG y inaganjo, O Yuus; atituye y tinaetaejo. ");
INSERT INTO cha_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Desde y uttimon y tano juagang jao, anae taeninasiña y corasonjo: chalaneyo asta y acho ni y mas taquilo qui guajo. ");
INSERT INTO cha_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Sa jago guinin y guinegüeco, yan y guiman lumijing guinin y enemigo. ");
INSERT INTO cha_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Jusaga gui jalom y tabetnaculumo para taejinecog: ya jugogüeyo gui tinampen y papamo. Sila. ");
INSERT INTO cha_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Sa jago O Yuus guinin jumungog y promesajo; jago guinin numaeyo ni y erensian ayo sija y manmaañao ni y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Jago munaanaco y jaanin y ray; y sacanña taegüije y megae na generasion sija. ");
INSERT INTO cha_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Usaga gui menan Yuus para taejinecog: O, nalisto y güinaeya yan y minagajet, para ufanadaje güe. ");
INSERT INTO cha_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Pot este jucantaye y naanmo para taejinecog, para jufatinas y prinimetijo cada jaane. ");
INSERT INTO cha_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Y antijo janananggaja si Yuus; sa guinin güiya nae mamaela y satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Güiyaja y achojo yan y satbasionjo, güiya y torejo taquilo: ya ti megae jumanacalamten. ");
INSERT INTO cha_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Asta ngaen nae intigong contra unoja taotao? todos jamyo infanmapuno; taegüije y padet ni y cumba, yan taegüije y matomba na colat. ");
INSERT INTO cha_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Manafaesenja gui entaloñija na umayute papa gui ninasiñaña: manmagof ni y dinague sija: manmanbendidise ni y pachotñija, lao manmanmatdidise qui sumanjalomñija. ");
INSERT INTO cha_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Si Yuus nanggajao, O antijo; sa guinin güiya y ninanggaco. ");
INSERT INTO cha_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Güiyaja y achojo yan y satbasionjo; güiya y torejo taquilo, ya ti jumanacalamten. ");
INSERT INTO cha_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Gui as Yuus nae gaegue y satbasionjo yan y minalagjo; y acho y minetgotjo yan y guinegüeco mangaegue gui as Yuus. ");
INSERT INTO cha_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Angoco gue todo y tiempo, jamyo ni y taotao sija; chuda y corasonmiyo gui menaña: si Yuus y guinegüe para jita. Sila. ");
INSERT INTO cha_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Seguro todo y taotao sija ni y umitde condisioñija manjinaja; ya y managquilo condisioñija, un dinague; yanguin manmapolo gui balansa, todos manñajlalangña qui y jinaja. ");
INSERT INTO cha_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Chamo umangongoco jao gui inamot, yan chamo na gagaebale y sinaque: yanguin y güinaja manlalamegae; chamo pumópolo y corasonmo guiya sija. ");
INSERT INTO cha_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Guinin jasangan si Yuus un biaje; ya dos biaje jagasja jujungog este; na y ninasiña iyon Yuus. ");
INSERT INTO cha_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Sa iyomoja locue Jeova y minaase: sa unapapaseja cada taotao jaftaemano y chechonâ. ");
INSERT INTO cha_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","O Yuus, jago y Yuusso; taftaf jualigao jao; y antijo majo pot jago, y catneco majalang nu jago, gui anglo an majo na tano, anae taya janom; ");
INSERT INTO cha_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Taegüije juatan jao gui templo para julie y ninasiñamo yan y minlagmo. ");
INSERT INTO cha_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Sa y mauleg güinaeyamo maulegña qui y linâlâ; y labiosso ualabajao. ");
INSERT INTO cha_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Taegüine jubendise jao gui linâlâjo; ya jujatsa julo y canaejo ni y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Y antijo ujaspog taegüije y ujaspog ni y titanos an montica; ya y pachotjo ualabajao yan y minagof y labiosso. ");
INSERT INTO cha_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Yanguin jujaso jao gui jilo camajo; ya y jinasoco nu jago gui ora nae bumebelayo an puenge. ");
INSERT INTO cha_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Sa jago guinin umayudayo; enaomina y anineng y papamo nae jumagof. ");
INSERT INTO cha_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Y antijo dangculo na tinatitiye jao: y agapa na canaemo mumantieteneyo. ");
INSERT INTO cha_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Lao ayo sija y umaliligao y antijo, para umayulang, sija ufanjanao para y mas tadong na joyo gui tano. ");
INSERT INTO cha_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Ufanmaentrega gui jinilat y espada; sija ugüinaja para y sora sija. ");
INSERT INTO cha_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Lao y ray umagof gui as Yuus; ya todo y manmanjula pot güiya unfanmagof: sa y pachot ayo sija y manmandadague ufanmajuchom. ");
INSERT INTO cha_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","JUNGOG y inagangjo, O Yuus, gui quejaco: adaje y linâlâjo ni y minaañaoña ni y enemigo. ");
INSERT INTO cha_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Naatogyo gui secreto na pinagat y manaelaye; yan y inatborota ni y chumogüe y taelaye. ");
INSERT INTO cha_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Ni y janafanmalagtos y jilañija taegüije y espada, yan janafanapunta y flechañija, ni manmalaet na sinangan. ");
INSERT INTO cha_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Para ujaflecha gui secreto y cabales; ya derepente manflecha güe, ya ti maañao. ");
INSERT INTO cha_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Janafanfitmeja sija gui na jinasuye taelaye: manmanafaesen para ujananaplinanta y laso; ya ilegñija: Jaye ufanlinie? ");
INSERT INTO cha_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Manmanaliligao ni y tinaelaye; ilegñija na tacumple guse y inaligaota: cada uno guiya sija manacjalom jinasonñija yan corasonñija manadong. ");
INSERT INTO cha_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Lao si Yuus flumecha sija, ya enseguidas ninafanlamen nu y flecha. ");
INSERT INTO cha_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Ya taegüije ninafanmatompo; y jilañija contra sija; ya todo y lumie sija ujayengyong y ilonñija. ");
INSERT INTO cha_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ya todo y taotao sija ufanmaañao; ya ujasangan y checho Yuus: sa ujaguesjaso y finatinasña. ");
INSERT INTO cha_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Y manunas ufanmagof sija gui as Jeova, ya ujaangoco nu güiya; yan todo y manunas na corason, ufanmalag. ");
INSERT INTO cha_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Y tinina unanangga jao guiya Sion, O Yuus; iya jago nae umapase y promesa. ");
INSERT INTO cha_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","O jago ni y jumungog y utinaetae, todo y catne ufanmato guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Jaganayo y tinaelaye sija; lao y isaomame, jago umasie. ");
INSERT INTO cha_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Dichoso y taotao ni y unayeg, ya unnaguaguato guiya jago, para usaga gui sagamo: manjaspogjam ni y minauleg y guimamo, asta y santos na lugat gui templomo. ");
INSERT INTO cha_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Pot y namaañao na güinaja nae unopejam gui tininas; O Yuus y satbasionmame; jago y ninangga gui uttimon puntan tano todo, yan asta todo ayo sija y manlachago, ni y mangaegue gui jilo y tase. ");
INSERT INTO cha_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ayo y pot ninasiñaña japlanta seguro y egso, madudog ni y ninasiñaña; ");
INSERT INTO cha_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ni y janaquieto y palañgpang y tase sija, y palangpang y napoñija yan janafanbasta managuaguat y taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Ya ayo sija ni y mañasaga gui uttimon tano, manmaañao ni señatmo: unnamagof y jumuyong y egaan yan y pupuenge. ");
INSERT INTO cha_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Jago bumisita y tano yan unriega; unnagosrico; y sadog Yuus bula janom: unnafanmauleg y maies para sija yanguin esta unnalisto y tano taegüije. ");
INSERT INTO cha_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Unnafangosbula janom y sutcoñija: unnafitme a pujañija güije; ya unnamañaña ni y ichan; ya unbendise y sinisoñija. ");
INSERT INTO cha_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Uncorona y sacan sija ni y minaulegmo; ya y finaposmo manutujo y mantica. ");
INSERT INTO cha_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Manutujo gui jilo y pastaje sija gui desierto: ya y mandiquique na sabana madudog ni y minagof. ");
INSERT INTO cha_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Y pastaje sija manminagago ni y manadan gâgâ; y baye sija locue mantinampe ni y maies; manesalao ni y minagofñija, ya mangacanta locue. ");
INSERT INTO cha_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","FATINAS y minagof na inagang gui as Yuus todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Canta y minagof gui naanña: namalag y tininaña. ");
INSERT INTO cha_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Alog as Yuus: jafa na manámaañao y chechomo: pot y dinangculon y ninasiñamo uninaseja y contrarionmo papa. ");
INSERT INTO cha_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Todo y tano umadodorajao yan macantatayejao: yan macantataye y naanmo. Sila. ");
INSERT INTO cha_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Maela ya inlie y checho Yuus: na ninámaañao y chechoña gui jilo y famaguon y taotao. ");
INSERT INTO cha_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Jatolaeca y tase y anglo na tano: ya japocacate y sadog: ya ayo nae manmagofjam nu güiya. ");
INSERT INTO cha_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Güiya jagobiebietna ni y minetgotña para taejinecog: y atadogña pumupulan y nasion sija: ya munga y managuaguat na ujajatsa sija. Sila. ");
INSERT INTO cha_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Fanmanbendise ni y Yuusta jamyo ni y taotao ya namajungog y inagang y tininaña: ");
INSERT INTO cha_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Ayo y mumantiene y antita gui linâlâ: ya ti japolo y adengta na usulong. ");
INSERT INTO cha_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Sa jago chumaguejam, O Yuus; jagasja unchague jam taegüije y salape an machague. ");
INSERT INTO cha_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Jago chumulejam gui jalom y laso: unpolo chinatsaga na catga gui sinturanmame. ");
INSERT INTO cha_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Jago namaudae y taotao guijilomame: jame infaposgüe y guafe an y janom: lao unchulejam asta y jalom y rico na sagayan. ");
INSERT INTO cha_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Jujalom gui jalom guimamo yan y sinenggue na inefrese sija: ya bae juapase jao ni y promesajo, ");
INSERT INTO cha_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Ni y labiosso sumangan, yan y pachotto jagas cumuentos anae estabayo gui chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Bae junaejao sinenggue na inefrese ni y yemog yan paopao na tatneron quinilo: bae junaejao nobiyo yan chiba sija. Sila. ");
INSERT INTO cha_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Maela ya injingong, todo ayo y manmañao as Yuus, ya bae jusangane jamyo jafa finatinasña ni y antijo. ");
INSERT INTO cha_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Guajo juagang güe ni y pachotto: ya güiya umaalaba ni y jilajo. ");
INSERT INTO cha_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Yaguin jumantiene y tinaelaye gui corasonjo, si Jeova ti ujungogyo. ");
INSERT INTO cha_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Lao magajet na si Yuus jajungog: güiya umadaje y inagang y tinaetaejo. ");
INSERT INTO cha_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Bendito si Yuus, sa ti jabira y tinaetaejo ni y minaaseña guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","O Yuus, gaease ni jame ya unbendisejam: yan janafanmalag y mataña gui jilomame. Sila. ");
INSERT INTO cha_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Para usiña matungo y chalanmo gui jilo y tano yan y satbasionmo gui nasion todos: ");
INSERT INTO cha_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Polo y taotao ya umatuna jao, O Yuus: polo y taotao todo ya umatuna. ");
INSERT INTO cha_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","O, polo y nasion sija ya ufanmagof yan ufanganta ni y minagof: sa jago siempre jumusga y taotao gui tininas yan ungobietna y nasion sija gui jilo y tano. Sila. ");
INSERT INTO cha_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Polo y taotao ya umatuna jao, O Yuus: polo y taotao todo ya umatuna. ");
INSERT INTO cha_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Ya y tano jagasja unajuyong megae tinegchaña: ya si Yuus ni y Yuusta ubendisejit. ");
INSERT INTO cha_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Si Yuus ubendisejit: yan todo y uttimon y tano umaañao nu güiya. ");
INSERT INTO cha_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","POLO si Yuus ya ucajulo, polo y enimiguña ya ufanmachalapon: polo ayo sija y chumatlie güe ya ufanmalago gui menaña. ");
INSERT INTO cha_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Taegüije y manajanao y aso, taegüijeja yute sija: taegüije y maderite y danges gui menan guafe, taegüijeja manmalingoñija y manaelaye gui menan Yuus. ");
INSERT INTO cha_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Lao y manunas ufansénmagof: ufansenalegre gui menan Yuus: magajet ya usendangculo y minagofñija. ");
INSERT INTO cha_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Cantaye si Yuus, cantaye alabansa sija y naanña: nacajulo y chalan para ayo na maudae y inanaco y desierto sija; y naanña, si Yah ya fansenmagof gui menaña. ");
INSERT INTO cha_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Tatan y manaetata ya y jues para y manbiuda, si Yuus gui sinantos na sagaña. ");
INSERT INTO cha_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Si Yuus munafañaga y taeparientes gui familia sija: güiya chumule juyong preso para umegae: lao y managuaguat mañagaja gui anglo na tano. ");
INSERT INTO cha_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O Yuus, mientras unjanao gui menan y taotao; mientras na unfamocat gui inanaco desierto. Sila. ");
INSERT INTO cha_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Y tano mayeyengyong, y langet locue manutujo gui menan Yuus: ayo iya Sinae mayengyong gui menan Yuus, ni si Yuus guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Jago, O Yuus, tumago megae na uchan, yan jago munafitme y erensiamo na taotao anae yayas. ");
INSERT INTO cha_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Y inetnon taotaomo mañaga güije: jago, O Yuus, fumamauleg y minaulegmo para y mamoble. ");
INSERT INTO cha_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Si Jeova jananae ni finijo: yan mandangculo ayo na inetnon famalaoan ni y munamatungo: ");
INSERT INTO cha_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Ray sija y inetnon sendalo falago chadig: ya güiya palaoan ni y sumasaga iya sija mafacae y inamot na güinaja. ");
INSERT INTO cha_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Yaguin manmalago jamyo dumescansa gui quelat quinilo; calang y papan y paluma nii platiao, yan y piluña nii amariyo calang oro. ");
INSERT INTO cha_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Anae ayo todo janasiña manafanmachalapon y ray sija guiya güiya: taegüije anae mamodong nieve guiya Salmón. ");
INSERT INTO cha_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Y egso Yuus y egso Basán: y gostaquilo na ogso y egso Basán. ");
INSERT INTO cha_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Sa jafa na manaatansegüet, jamyo nii manaquilo na osgo guato gui egso güinaeyan Yuus para sagaña: magajet na si Jeova sumaga güije para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Y caretan Yuus y viente mil, junggan, miyares yan miyares ya si Jeova gui entaloñija taegüije iya Sinae, iya santos na sagaña. ");
INSERT INTO cha_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Jagasja jao cajulo iya jululo, jagas uncone y mamacautiba na megae: jagas unresibe ninae sija entre taotao sija: magajet entre y managuaguat locue, para si Jeova Yuus usiña sumaga gui entaloñija. ");
INSERT INTO cha_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Bendito si, Jeova nii todo y jaane jaencatga y catgata, junggan, ayo y Yuus y satbasionta. Sila. ");
INSERT INTO cha_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Si Yuus güiya si Yuus satbasion para jita: ya y jinanao guinin y finatae iyon Jeova, Señot. ");
INSERT INTO cha_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Lao si Yuus janafanlamen y ilon y enimiguña yan y cácagong y manmipe ayo y sisigueja gui isaoña. ");
INSERT INTO cha_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Ya si Jeova ilegña: Bae chule talo guinin Basán, bae chule sija talo, guinin y tádodong na tase. ");
INSERT INTO cha_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Ya y adengmo siña umanaatunog gui jâgâ ya y jila y gamo galago siña patten y enimigumo. ");
INSERT INTO cha_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Sija jalie y jinanaomo, O Yuus; magajet y jinanao y Yuusso, Rayjo gui sinantos na sagaña. ");
INSERT INTO cha_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Y mangacanta manjajanao gui menan, y mandadangdang yan y dandanñija jatatituye; y entaloñija y donseya sija ni y mandadangdang nii pandireta. ");
INSERT INTO cha_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Fanbendise si Yuus gui jalom y inetnon taotao; junggan, jamyo y tutujonña guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Ayonae estaba y diquique as Benjamin y magasñija, y prinsipen Juda yan y compañia apapagat, y prinsipen Sabulon yan y prinsipen Neftali. ");
INSERT INTO cha_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Y Yuusmo tumago y minetgotmo; O Yuus, nametgot y chechomo para jame. ");
INSERT INTO cha_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Pot causa y templomo guiya Jerusalem, y ray sija manmañuñule ninae sija para jago. ");
INSERT INTO cha_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Lalatde y dadao na gâgâ gui piao, y manadan nobiyo yan y tatneron gataotao, nii guinocha papa adengñija y pedason salape sija: jochalapon ayosija taotao nii manmalago manguera. ");
INSERT INTO cha_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Ufanmato y prinsipe sija guinin Egipto: Etiopia guse ujaestira y canaeña gui as Yuus. ");
INSERT INTO cha_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Cantaye si Yuus jamyo nii raenon tano; O canta tinina para y Señot. Sila. ");
INSERT INTO cha_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Para ayo y maudae gui jilo y langet y langet sija, nii guinin ampman na tiempo; estagüe na güiya masangan nii inagang; nii gaeninasiña na inagang. ");
INSERT INTO cha_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Sangan y minetgot Yuus: y minagasña gaegue gui jilo Israel, yan y minetgotña gaegue gui jalom y mapagages. ");
INSERT INTO cha_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","O Yuus, ninamaañaojao gui santos na sagamo sija: y Yuus Israel, güiya numae minetgot yan ninasiña y taotaoña: Bendito si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","NALIBREYO, O Yuus; sa y janom manjalom asta y antijo. ");
INSERT INTO cha_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Magñoyo gui tadong na luño; anae ti siñayo tumojgue: guajo mato y jalom tadong na janom anae y milag malofan gui jilojo. ");
INSERT INTO cha_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Yayasyo ni y inagangjo: y agagajo ninaanglo: y atadogco linálachae mientras junanangga si Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Ayosija y chumatliiyo pot taya, megaeña qui y gapotulo gui ilujo: ayosija y manmalago umututyo nii enemigujo sin jafa na linache, mangaeninasiña: ayo nae guajo junatalo guato ayo y taya nae juchuleguan. ");
INSERT INTO cha_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","O Yuus, jago tumungo y taetiningojo: yan y isaojo sija ti junaatog guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Chamo ayo sija y numananggajao munafanmamamajlao pot guajo, O Jeova, Yuus y inetnon sendalo: chamo ayo sija y umaliligaojao umadesonra pot guajo, O Yuus Israel. ");
INSERT INTO cha_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Sa pot jago jupadese y linalatde: minamajlao tumampe y matajo. ");
INSERT INTO cha_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Guinin manataotao juyong yo nii mañelujo; yan taotao juyongyo gui famaguon nanajo. ");
INSERT INTO cha_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Sa y inigo y guimamo cumanoyo: ya y linalatdeñija y ayo sija nii lumalatde jao manbasnag guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Anae tumangesyo ya junamajalang y antijo pot ti chumocho, este y para malalatdeco. ");
INSERT INTO cha_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Anae jufatinas y luto para magagujo, jumuyongyo un cuentos nu sija. ");
INSERT INTO cha_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Ya ayo y manmatatachong gui petta, manadingan contra guajo: ya guajo y cantasionñija anae mangacanta y manbulacho. ");
INSERT INTO cha_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Lao guajoja, y tinaetaejo guiya jago, O Jeova, gui tiempon y finaboresemo: O Yuus, pot y minegae y minaasemo opeyo gui minagajet y satbasionmo. ");
INSERT INTO cha_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Nalibreyo gui liño ya chajo mamagño: polo ya ulibreyo güije sija nii chumatliiyo, yan gui y tinadong y janom sija. ");
INSERT INTO cha_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Chamo pumopolo y minilalag na janom na ufalofan gui jilojo, ni unpolo y tinadong na upañotyo; chamo pumopolo y joyo na ujuchom y pachotña gui jilojo. ");
INSERT INTO cha_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Opeyo, O Jeova; sa y minaasemo gosmauleg: taemanoja y minegae y minaasemo, birajao guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Chamo na aatog y matamo gui tentagomo; sa gaegue yo gui chinatsaga: opeyo guse. ");
INSERT INTO cha_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Najijot jao gui antijo ya unnalibre: rescatayo sa juguaja y enimigujo sija. ");
INSERT INTO cha_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Jago tumungo y malalatdeco, yan y minamajlaojo yan y madesonraco: y contrariojo mangaegue todo gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Y linalatde yumulang y corasonjo: yan bulayo y pinite: ya manaliligaoyo jaye upinite, lao taya ni uno: yan y numamagofyo lao ti jusoda ni uno. ");
INSERT INTO cha_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Sija numaeyo locue lalaet para nengcanojo: yan anae majoyo, sija numaeyo binagle para juguimen. ");
INSERT INTO cha_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Polo ya lamasañija mamalaso gui menanñija: polo ya yaguin gaegue sija gui pas, este para ocodo. ");
INSERT INTO cha_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Polo ya ujomjom y atadogñija para chañija fanmalilie; yan janayeyengyong nii sinturanñija para todo y tiempo. ");
INSERT INTO cha_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Basija gui jiloñija y binibumo, ya polo y dangculon linalalomo ya ufanjeniguif sija. ");
INSERT INTO cha_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Polo y sagañija ya umayulang: yan taya ni uno siña sumaga gui tiendañija. ");
INSERT INTO cha_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Sa sija pumetsigue ayo sija y sinaolagmo: ya sija sumangan y pinitinja ni y ninafanlamenmo. ");
INSERT INTO cha_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Naye mas taelaye y tinaelayeñija, ya chamo munafanjajalom gui tininasmo. ");
INSERT INTO cha_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Palo ya umafunas sija gui leblon linâlâ: ya munga manmatugue sija yan y manunas. ");
INSERT INTO cha_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Lao guajo pobleyo yan tristeyo: polo y satbasionmo, O Yuus, ya upoloyo guiya jululo. ");
INSERT INTO cha_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Guajo bae jualaba y naan Yuus nu y cantasion, ya junadangculo güe nu y inefresen grasias. ");
INSERT INTO cha_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Ya este munaguefmagof si Jeova mas qui y nobiyo, pat y toro nii mangaecángjilon yan papaquis. ");
INSERT INTO cha_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Y manmanso, jalie este ya ninafanmagof: ya y corasonmiyo ufanlâlâ y unaaliligao si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Sa si Jeova jajungog y mannesesitao ya ti jachatlie y prenesuña sija. ");
INSERT INTO cha_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Polo y langet yan tano ya umaalaba güe, yan y tase sija yan todo y güinaja nii mangalalamten gui sanjalomña. ");
INSERT INTO cha_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Sa si Yuus ujasatba y Sion yan ujafatinas y siuda sija guiya Juda: para usiña sija mañaga güije yan uguaja para y iyonñija. ");
INSERT INTO cha_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Ya y semiya locue gui tentagoña uereda ni ayo: ya ayo sija y gumaeya y naanña unafañaga güije. ");
INSERT INTO cha_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","NACHADIG, O Yuus, para unalibreyo: nachadig umayudayo, O Yuus. ");
INSERT INTO cha_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Polo sija ya ufanmamajlao yan ufaninistotba ni y umaliligao y antijo: polo sija ya ufanalo tate yan ufanmamajlao ni y manmagof nii desonraco. ");
INSERT INTO cha_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Polo sija ya ufanalo tate para apas y minamajlaoñija ja ni y ilegñija: Aha, Aha. ");
INSERT INTO cha_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Polo ayo todo y umaliligaojao ya unfanmagof yan ufansenmagof ni jago: ya polo ya ayo y gumaeya y satbasionmo ya ilelegñija siésiempreja: Umanasendangculo si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Lao guajo pobleyo yan nesesitaoyo: nachadig jao guiya guajo, O Yuus: sa jago umayuyudayo, yan y munalibreyo; O Jeova, chamo umatrasasao. ");
INSERT INTO cha_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","YYAJAGO, O Jeova, nae jupolo y inangococo: ya chajo mamámajlao para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Nalibreyo, nii tininasmo ya rescatayo: naapo y talangamo guiya guajo ya unsatbayo. ");
INSERT INTO cha_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Jago y acho y saga para guajo, anae mafatoyo todo y tiempo: jago mannae tinago na jumasatbayo: sa jago y finitmeco yan y castiyujo. ");
INSERT INTO cha_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Rescatayo, O Yuusso, juyong gui canae y manaelaye yan y canae y ti manunas yan y manrecto na taotao. ");
INSERT INTO cha_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Sa jago y ninanggaco, O Jeova Yuus: jago y inangococo desde y pinatgonjo. ");
INSERT INTO cha_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Sa jago mumantieneyo desde y jalom tuyan, jago chumuleyo juyong guinin y tiyan nana: ya y tininajo todo y tiempo guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Guajo taegüije y ninamanman gui linajyan; lao jago y megot na guinegüeco. ");
INSERT INTO cha_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Y pachotto ubula nii tininamo, an y inenramo todot dia. ");
INSERT INTO cha_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Chamoyo yumuyute gui tiempo y inamcojo: yaguin minetgotto esta jocog chamoyo dumidingo. ");
INSERT INTO cha_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Sa y enimigujo manadingan contra guajo; yan ayo sija y numanangga y antijo, manafaesen entre sija. ");
INSERT INTO cha_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Ylegñija: Diningogüe as Yuus: petsigue ya enchilegüe; sa taya para ulinibregüe. ");
INSERT INTO cha_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O Yuus, chamo chachago guiya guajo; Yuusso, nachadig yan para unayudayo. ");
INSERT INTO cha_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Polo sija ya ufanmamajlao yan ufanlinachae, ayo y contrarion y antijo; polo sija ya ufantinampe nii minamajlao yan y sinala, y umaliligao y dañujo. ");
INSERT INTO cha_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Lao guajo juananangga todo y tiempo, yan junalala megae y tininajo guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Y pachotto usinangan y tininasmo, yan y satbasionmo todot dia: sa ti jutungo y minegaeña. ");
INSERT INTO cha_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Bae jufalag y minetgot gui as Yuus, Jeova; ya jusangan y tininasmo, magajet, iyomoja namaesa. ");
INSERT INTO cha_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","O Yuus, jago jagasja fumanagüe yo desde y pinatgonjo; yan asta pago jusangan claro nii ninamanman y chechomo. ");
INSERT INTO cha_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Pago locue anae estayo bijo ya chungeyo, O Yuus chamoyo dumidingo: asta que jusangan claro nii minetgotmo y manmámamaela na generasion, yan y ninasiñamo cada uno ni ayo y ufanmato. ");
INSERT INTO cha_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Yan y tinasmo locue, O Yuus, sumentaquilo; jagasja unfatinas y mandangculo na güinaja sija: O Yuus, jaye uparejumo? ");
INSERT INTO cha_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Sa jago y fumanuejam mandangculo na pinite yan chinatsaga, siempre unnalâlâjam talo, yan unchulejam talo julo guinin y tinadong y tano. ");
INSERT INTO cha_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Aumenta y dinangculoco; yan birajao ya unamamagofyo. ");
INSERT INTO cha_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Ya guajo locue bae jualaba jao yan y guitala: magajet, y minagajetmo, O Yuusso: yyajago nae jucantaye yan y atpa, O jagoja na Santos guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Y labiosso sendangculo minagofña anae jucantayejao tinina; yan y antijo ni jago munalilibre. ");
INSERT INTO cha_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Y jilajo locue jasasangan y tininasmo todot dia: sa innafanmamajlao yan innafaninestotba ayo y umaliligao y dañujo. ");
INSERT INTO cha_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","NAE y ray ni juisiomo, O Yuus, yan y tininasmo gui lajin y ray. ");
INSERT INTO cha_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Ya güiya ufanjusga y taotaomo gui tininas, yan y mamoblemo gui juisio. ");
INSERT INTO cha_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Ya y beca sija chumule y pas gui taotao yan y mandiquique na ogso sija pot y tininas. ");
INSERT INTO cha_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Güiya ufanjusga y mamoble na taotao, güiya ufañatba y famaguon y mannesesitao, yan ufanyinamag y manmachaleg. ");
INSERT INTO cha_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Sija ufanmaañao ni jago mientras gagaegue y atdao, yan y pilan gui todo y generasion yan y generasion. ");
INSERT INTO cha_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Güiya tumunog papa taegüije y ichan gui jilo y manmautot na chaguan: taegüije minatmon janom ni y nafotgon y tano. ");
INSERT INTO cha_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Ya y jaaniña sija, mumamta y tininas; ya y pas sumenmegae asta qui jocog y pilan. ");
INSERT INTO cha_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Güiya uguaja minagasña locue guinin y tase asta y tase, yan guinin y sadog asta y uttimon y tano. ");
INSERT INTO cha_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Ya ayo y mañasaga gui desierto, manecon gui menaña; ya y enimiguña sija mamanjojoflag gui eda. ");
INSERT INTO cha_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Y ray sija guiya Tarsis yan isla sija ufanmañuñule ninae: yan y ray sija guiya Sabá yan iya Seba ufanmannae ninae. ");
INSERT INTO cha_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Magajet, y ray todos ujatomba sija gui menaña: yan y nasion todos usinetbe güe. ");
INSERT INTO cha_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Sa güiya unalibre y nesesitao an jumagang; yan ayo locue y peble an ni y taya uinayuda. ");
INSERT INTO cha_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Güiya unafanmañotbla y mamoble yan y mannesesitao yan ujasatba y anten y mannesesitao. ");
INSERT INTO cha_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Güiya unafanlibre y antiñija guinin y chiniguit yan y finijom: yan ugagaebale y jâgâñija gui menan atadogña. ");
INSERT INTO cha_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Ya güiya lumala, ya para güiya umanae ni y oron Sabá; ya y tinayuyut locue mafatitinas pot güiya todo y tiempo; sa sija ufanbendise güe todot dia. ");
INSERT INTO cha_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Sa uguaja megae na maies gui jalom y eda gui sanjilo y puntan y beca sija; ya y tinegchaña ufanmayengyong taegüije y Libano.; ya sija gui siuda ninafangatbo taegüije y chaguan gui eda. ");
INSERT INTO cha_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Y naanña gagaegue para taejinecog: y naanña sisigueja taegüije y siniguen y atdao: yan todo y taotao ufandichoso guiya güiya; yan todo y nasion umafanaan güe dichoso. ");
INSERT INTO cha_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Bendito si Jeova Yuus, ni si Yuus Israel, sa güiyaja na maesa fumatinas y mannamanman na güinaja. ");
INSERT INTO cha_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Yan bendito y minalag y naanmo para taejinecog: ya polo todo y tano ya ufanbula ni y minalagmo. Amen yan Amen. ");
INSERT INTO cha_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Magpo y tinayuyut David ni y lajin Isai. ");
INSERT INTO cha_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","SENMAGAJET si Yuus na mauleg para Israel, ni ayo sija y mangasgas na corason. ");
INSERT INTO cha_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Ya guajo cánaja sumuja y adengjo; didideja tentenjan sulon y pinecatta. ");
INSERT INTO cha_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Sa jumalatgue y mangaduco, anae julie y minauleg y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Sa taya pinite gui finataeñija: lao y minetgotñija fitme. ");
INSERT INTO cha_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Taya chinatsagañija taegüije y otro taotao sija; ni ufanmasapet taegüije y palo na taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Enaomina na sobetbia y cadena nii lisayon y cueyoñija; y finijom tumampe sija taegüije y magago. ");
INSERT INTO cha_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Y atadogñija mamachom ni y yinemog; guajañija mas qui y corason siña umalatgue. ");
INSERT INTO cha_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Sija manmanbotlelea, yan jasasangan chiniguit gui tinaelaye: jasasangan y mansentaquilo. ");
INSERT INTO cha_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Japolo y pachotñija gui langet, yan y jilañija janafanmamocat gui inanaco y tano. ");
INSERT INTO cha_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Enao mina y taotaoña manalo mague: yan y binilan y janom gui posuelo umafugo nu sija. ");
INSERT INTO cha_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Ya ilegñija: Jaftaemano tungoña si Yuus? Ada guaja tiningo gui Gueftaquilo? ");
INSERT INTO cha_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Sa estagüe ya sija y manaelaye; ya sija manmegae gui tano, sa taya chinatsagañija todo y jaane. ");
INSERT INTO cha_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Senmagajet na taebale y junagasgas y corasonjo: yan jufagase y canaejo gui guinasgas. ");
INSERT INTO cha_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Sa todo y inanaco y jaane chatsagayo, yan y castigojo cada ogaan. ");
INSERT INTO cha_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Yaguin jagasja jualog, bae jusangan este; este na jagasja judague y generasion: y famaguonmo. ");
INSERT INTO cha_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Yaguin jujaso jaftaemano na jutungo este, sumenmacat para guajo; ");
INSERT INTO cha_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Asta que jujalom gui sinantos na sagayan gui as Yuus; ya jujaso y uttimoñija. ");
INSERT INTO cha_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Magajet na jago pumolo sija gui palagse na sagayan; jago yumute sija papa gui jalom y yinilang. ");
INSERT INTO cha_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Sa jaftaemano na ufanyinilang, gui un rato! sija chadig malimachae ni y minaañao sija. ");
INSERT INTO cha_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Taegüije güinife an magmata; taegüenaoja, O Señot, yaguin magmatajao, unchatlie y jechurañija. ");
INSERT INTO cha_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Sa y corasonjo estaba triste, ya matogchayo gui sumanjalom. ");
INSERT INTO cha_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Na taegüije taejinasoyo, yan taetiningoyo: taegüijeyo y gâgâ gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Masqueseaja gagaegueyo siempre guiya jago; jago mumantiene y agapa na canaejo. ");
INSERT INTO cha_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Jago umesgaejonyo ni y consejumo, ya despues unresibeyo gui langet. ");
INSERT INTO cha_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Ya jayeyo guajayo gui langet sino jagoja? ya taya gui jilo y tano güinaeyaco, na jagoja. ");
INSERT INTO cha_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Y catneco yan y corasonjo malachae: lao si Yuus y minetgot y corasonjo, yan y güinajajo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Sa, estagüe ya ayo sija y mañago guiya jago, na ufanmalingo: jago yumulang todo ayo sija y manjanao guiya jago para inábale. ");
INSERT INTO cha_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Lao mauleg para guajo y juguaguato jijot gui as Yuus: sa jupolo y inangococo gui Señot Jeova, para usiña jusangan todo y chechomo. ");
INSERT INTO cha_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","O Yuus, sajafa na unyutejam para taejinecog? sajafa na y linalomo umasgon contra y quinilo sija gui pastajimo? ");
INSERT INTO cha_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Jaso y inetnonmo ni y unfajan gui ampmam na tiempo; y tribon y erensiamo, ni y jago sumatba; yan y egso Sion, anae sumasagajao. ");
INSERT INTO cha_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Jatsa y adengmo para taejinecog na yinilang: sa y enimigo jafatinas y tinaelaye todo gui jalom y sinantos na sagamo. ");
INSERT INTO cha_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Y contrariumo sija manaagang gui entalo y inetnonmo; ya japolo julo y banderañija para señat sija. ");
INSERT INTO cha_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Parejo yan y taotao y jajatsa julo y gachae sija gui jilo y chemchom na trongco jayo sija. ");
INSERT INTO cha_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Lao pago sija yumute papa y binetda na chocho un biajeja, ni y gachae yan y mattiyo sija. ");
INSERT INTO cha_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Sa sija sumanggüe y sinantos na sagamo, yan munainale y sagan y naanmo, sanpapa gui tano. ");
INSERT INTO cha_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Ylegñija gui corasonñija: Nije tayulang sija ni mandaño: ya sija sumonggue todo y sinagogan Yuus gui tano. ");
INSERT INTO cha_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ti talie y señatta sija: ya taya ni uno profeta mas: ni uguaja sija ni utiningo asta ngaean. ");
INSERT INTO cha_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Asta ngaean, O Yuus, nae y contrario ulalatde? ya y enimigo ufañatfino contra y naanmo para taejinecog? ");
INSERT INTO cha_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Sajafa na unjedo y canaemo, junggan y agapa na canaemo? jala juyong gui pechomo ya unyulang. ");
INSERT INTO cha_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Sa si Yuus y Rayjo gui ampmam na tiempo, jafatitinas y satbasion gui entalo y tano. ");
INSERT INTO cha_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Jago dumibide y tase ni y ninasiñamo: jago yumamag y ilon y alo sija gui tase. ");
INSERT INTO cha_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Jago yumamag y ilon lebiatan, ni y dadao na güijan, an pidasito; yan unnae güe para nengcano y taotao ni y mañasaga gui desierto. ");
INSERT INTO cha_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Jago bumaba y matan janom yan y minilalag: jago munafananglo y manmetgot na sadog sija. ");
INSERT INTO cha_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Y jaane iyomo, y puenge locue iyomo: jago fumamauleg y inina yan y atdao. ");
INSERT INTO cha_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Jago pumolo todo y oriyan y tano: jago fumatinas y tiempon maepe yan y tiempom manengjeng. ");
INSERT INTO cha_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Jaso este, na y enimigo manmalalatde, O Jeova, ya ayo y mangaduco na taotao jachatfino y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","O, chamo umintrerega y anten y gamo paluma gui dadao na gâgâ: chamo malelefa ni y dinaña y mamoblemo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Respeta y trato: sa y jemjom na sagayan sija gui tano manbula y sagan y manmalamaña. ");
INSERT INTO cha_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","O, Chamo munafanatalo manmamajlao y manmachichiguit: polo y mamoble yan y mannesesitao ya umalalaba y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Cajulo, O Yuus, gogüe y causamo: jaso jaftaemano y manaejinaso na taotao ni y lumalatdejao cada jaane. ");
INSERT INTO cha_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Chamo malelefa ni y inangang y contrariumo sija; y borucan ayo sija y mangajulo contra jago, lumala cajuloja siesiempre. ");
INSERT INTO cha_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","YYAJAGO, O Yuus, innae grasia; iyajago innae grasia sa y naanmo esta jijot: sa y ninamanman na chechomo masasangan. ");
INSERT INTO cha_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ngaean nae jusoda y tiempo na mamatca, bae jujusga ni y tinas. ");
INSERT INTO cha_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Y tano yan todo y mañasaga mamalachae: guajo chumuchule julo y jaliguiña. Sila. ");
INSERT INTO cha_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Ya ileco ni y mansobetbio: Chamiyo fumatitinas y sinebetbio: yan ni y manaelaye, chamiyo jumajatsa julo y canggelon. ");
INSERT INTO cha_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Chamiyo jumajatsa y canggelonmiyo gui taquilo; chamiyo fanguecuentos ni y tiso na tongjo. ");
INSERT INTO cha_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Sa y jinatsa ni y ufato ni y guinin y sancatan, ni y guinin y sanlichan, ni y guinin y sajaya. ");
INSERT INTO cha_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Lao si Yuus y jues: güiya pumolo papa uno, yan jajatsa julo otro. ");
INSERT INTO cha_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Sa gaegue gui canae Jeova y copa, yan y bino ni lalálalo; bula dinaña, ya jachuda juyong taeguijeja; lao y asiento gui fondoña, todo y manaelaye gui tano jafufugo ya jaguiguimen sija. ");
INSERT INTO cha_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Lao guajo bae jusangan claro para taejinecog; ya bae jucantaye si Yuus Jacob, y alabansa sija. ");
INSERT INTO cha_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Todo y canggelon y manaelaye locue bae juutot: lao y canggelon y manunas umanafangajulo. ");
INSERT INTO cha_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","MATUNGO si Yuus esta guiya Juda: y naanña manadangculo guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Yya Salem nae gaegue y tabetnacoluña, ya y sagaña gaegue guiya Sion. ");
INSERT INTO cha_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Ayo nae jayamag sija y flechan y atcos; yan y patang yan y espada, yan y guera. Sila. ");
INSERT INTO cha_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Malagjao yan magas jao mas qui y tadong na jalomtano. ");
INSERT INTO cha_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Ya y manmajetog na corason manmayulang manafanaelaye; esta jamaego y minaegoñija; ya taya ni un taotao ni y gaeninasiña jasoda y canaeñija. ");
INSERT INTO cha_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Pot y chinemamo, O Yuus Jacob, todo careta yan y cabayo manmayute gui minaego y finatae. ");
INSERT INTO cha_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Jago, junggan jago, para unamaañao: ya jaye siña tumogue gui menamo yan lalalojao? ");
INSERT INTO cha_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Jago munamajungog y sentensia guinin y langet; ya y tano manmaañao, ya manmamatquilo. ");
INSERT INTO cha_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Anae si Yuus jacajulo gui juisio, para usatba todo y manmanso gui tano. Sila. ");
INSERT INTO cha_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Magajet na y binibon y taotao uinalabajao: yan y seblan y binibo, jago sumoma. ");
INSERT INTO cha_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Promete ya inapase si Jeova ni y Yuusmiyo: todo ayo y mangaegue gui oriyaña manmañuñule ninae para güiya ni y namaañao. ");
INSERT INTO cha_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Güiya munamautut y espiriton y prinsipe sija: sa güiya y namaañao para y ray sija gui tano. ");
INSERT INTO cha_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","BAE juagang si Yuus ni y inagangjo; magajet na si Yuus ni y inagangjo; ya güiya jumungogyo. ");
INSERT INTO cha_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Y jaane y chinatsagaco jualigao y Señot: y canaejo maestira gui puenge ya pumapara: y antijo ti malago manamagof. ");
INSERT INTO cha_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Jujajaso, si Yuus ya janaestotbayo: umuugongyo, sa y espiritujo lalalango. Sila. ");
INSERT INTO cha_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Jago unadaje y atadogjo ni taemaego: sa taegüije chatsagayo na ti siñayo cumuentos. ");
INSERT INTO cha_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Sa guajo jujajaso y jaane ni y ampmam manmalofan, yan y sacan ni y ampmam na tiempo. ");
INSERT INTO cha_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Jujajaso y cantaco gui puenge: jujajaso ni y corasonjo; ya y espiritujo guine guefaligao? ");
INSERT INTO cha_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Ada uyute y Señot para taejinecog? ya ti utalo y finaboresiña? ");
INSERT INTO cha_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Cao y minaaseña usenjanaoja para taejinecog? ya y promesaña ufanlingo para taejinecog? ");
INSERT INTO cha_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Ya malefa si Yuus na uyóase? ya pot y linalaloña na jajuchom y güinaeyaña? Sila. ");
INSERT INTO cha_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Ya guajo ileco: Este y dinafejo: lao bae jujaso y sacan sija gui agapa na canae y Gueftaquilo. ");
INSERT INTO cha_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Bae jusangan y checho Jeova: sa bae jujaso y ninamanmanmo gui ampmam na tiempo. ");
INSERT INTO cha_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Bae jujaso locue todo y chechomo, yan jusangan sumanjalomjo y finatinasmo. ");
INSERT INTO cha_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Y chalanmo, O Yuus, gague gui sinantos na sagayan: jaye dangculo na yuus calang y Yuusta? ");
INSERT INTO cha_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Jago y Yuus ni y fumatinas y mannamanman: jago munamatungo y minetgotmo gui taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Jago yan y canaemo munafanlibre y taotaomo; ni y famaguon Jacob yan José. Sila. ");
INSERT INTO cha_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Y janom malie jao, O Yuus, y janom malie jao, ya sija ninafanmaañao: ya y tinadong locue ninafanmayengyong. ");
INSERT INTO cha_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Y mapagajes sija manmañuñuda janom: ya y langet mannae y inagang: ya y flechamo locue manjanao juyong. ");
INSERT INTO cha_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Ya y palampan y jilumo estaba gui remolino; ya y lamlam maniiina gui tano: ya y tano manmayengyong yan manlalaolao. ");
INSERT INTO cha_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Y chalanmo gui tase, ya y finaposmo gui mandangculo na janom, ya y guinachamo ti matungo. ");
INSERT INTO cha_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Jago umesgaejon y taotaomo taegüije y manadang quinilo pot y canae Moises yan Aaron. ");
INSERT INTO cha_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","ECUNGOG, O taotaojo, y tinagojo: na inecungog ni y talanganmo y sinangan y pachotto. ");
INSERT INTO cha_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Bae jubaba y pachotto gui acomparasion: bae jusangan sinangan na gui jemjom gui ampmam na tiempo. ");
INSERT INTO cha_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Ayosija ni y injingog yan y intingo, yan y tatanmame ni jasanganejam. ");
INSERT INTO cha_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ti innafanatog sija guinin y famaguonñija, masangangane y generasion ni y manmamamaela ni y tinina sija gui Señot, yan y minetgotña yan y mannamanman na chechoña ni y jachogüe. ");
INSERT INTO cha_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Sa güiya munacajulo y testimonio gui as Jacob, yan japolo tinago guiya Israel, ni y janatungo sija y famaguonñija. ");
INSERT INTO cha_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Para ujatungo y generasion ni y manmamamaela, y famaguonja ni y finañagonñija; ni y ufangajulo ya ujasangane y famaguonñija. ");
INSERT INTO cha_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Para usiña japolo y ninanggañija gui as Yuus, ya ti ufanmalefa ni y checho Yuus, lao jaadaje y tinagoña sija. ");
INSERT INTO cha_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Ya chañija fanaegüigüije y tatañija; un generasion ni managuaguat yan ti manmalago manmanosgue: y generasion ni y ti japolo y corasonñija gui tinas, yan ayo na espirituñija y ti manfitme gui as Yuus. ");
INSERT INTO cha_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Y famaguon Efraim, guaja atmas yan manmañule y atcos sija, manalo tate gui jaanen y guera. ");
INSERT INTO cha_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Ti jaadaje y traton Yuus, ya ti manmalago na ufanmamocat gui tinagoña. ");
INSERT INTO cha_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Ya manmalefa ni y chechoña, yan y ninamanmanña ni y manfinanue sija. ");
INSERT INTO cha_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Namanman na güinaja finatinasña gui menan y tatañija, gui tano Egipto, gui fangualuan Soan. ");
INSERT INTO cha_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Jadebide y tase ya janafanmalofan gui inanaco sija todo; yan janafañaga y janom taegüije y monton. ");
INSERT INTO cha_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Ya y jaane janafanenesgaegaejonja ni y mapagajes; yan todo puenge y finañila y guafe. ");
INSERT INTO cha_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Japanag y acho gue desierto, ya janae sija na ufanguinem taegüije na jumuyong guinin y dangculon tinadong. ");
INSERT INTO cha_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Ya mañule minilalag locue guinin y acho, yan janafalalago y janom taegüije y sadog. ");
INSERT INTO cha_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Lao trabia sisigueja mas isagüegüe, ya manmanembeste contra Gueftaquilo gui desierto. ");
INSERT INTO cha_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Ya sija jatienta si Yuus gui corasonñija, yan mangagagao catne pot y güinaeyañija. ");
INSERT INTO cha_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Magajet na sija manguentos contra si Yuus; ilegñija: Ada siña si Yuus jafamaulequejit lamasa gui desierto? ");
INSERT INTO cha_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Sa, estagüe, na anae japanag y acho, manjuyong y janom, ya y minilalag manmachuchuda. Ada siña güe manae pan locue? umafamauleg catne para y taotaoña? ");
INSERT INTO cha_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Enao mina anae jajungog este, y Señot ninabubo: ya umasonggue y guafe contra as Jacob, yan y linalalo locue cajulo contra Israel; ");
INSERT INTO cha_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Sa ti jajonggue si Yuus, yan ti jaangoco sija gui satbasionña. ");
INSERT INTO cha_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Lao güiya tumago y mapagajes guinin y sanjilo; yan jababa y pettan langet. ");
INSERT INTO cha_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Yan janauchan papa y mana gui jiloñija para ujacano, yan janae sija ni y maies y langet. ");
INSERT INTO cha_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Y taotao cumano y na y manmetgot: güiya numae sija catne para ufanjaspog. ");
INSERT INTO cha_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Jatago y manglo sancatan na ufanguaefe gui jalom y langet: yan pot y ninasiñaña jachachalane y manglo sanjaya. ");
INSERT INTO cha_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Janauchan catne locue gui jiloñija taegüije y petbos; yan y pajaro ni gaepapa taegüije inae gui tase; ");
INSERT INTO cha_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Ya japolo ayo sija na ufanbasnag gui entalo y campoñija, ya gui oriyan y sagañija. ");
INSERT INTO cha_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Ya sija jacano, ya mangosjaspog sija; sa güiya numae sija ni y tinangañiñija. ");
INSERT INTO cha_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Lao ti janajanao guiya sija y tinangañija; lao estabaja trabia y catneñija gui jalom y pachotñija, ");
INSERT INTO cha_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Ya y binibon Yuus mato gui jiloñija, ya japuno y mas manyomog guiya sija, yan jayute papa y patgon na taotao sija guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Lao contodo este, sigueja di maaiisao trabia: yan ti majonggue y mamnamanman na chochoña. ");
INSERT INTO cha_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Ya pot este na y jaaneñija janafanlinachae ni y banidá; yan y sacanñija gui minaañao. ");
INSERT INTO cha_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Ya anae japuno sija, ayo nae manafaesen pot güiya yan jabira sija ya maaligao guse si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Yan jajaso na si Yuus y achoñija, yan y Gueftaquilo na Yuus y Satbadotñija. ");
INSERT INTO cha_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Achogja ujafaande güe ni y pachotñija yan ujadague ni y jilañija. ");
INSERT INTO cha_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Sa y corasonñija ti tunas guiya güiya: ni ufanfitme gui tratuña. ");
INSERT INTO cha_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Lao güiya, bula minaase jaasie ni y tinaelayeñija, yan ti jayuyulang sija: magajet, megae na tiempo nae jabira y linalaloña, yan ti jajatsa julo y binibuña. ");
INSERT INTO cha_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Sa jajaso na sija catneja; y manglo na malofan ya mapos ya ti mamaela talo. ");
INSERT INTO cha_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Cuanto biaje manmanembeste contra güiya gui jalomtano yan manatriste güe gui desierto! ");
INSERT INTO cha_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Ya manalo tate ya matienta si Yuus; ya macase y Santosgüe guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Ya ti jajaso y canaeña; ni jaane anae ninafanlibre gui contrario. ");
INSERT INTO cha_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Ni y pineloña na señatña guiya Egipto: yan y ninamanmanña gui fangualuan Soan: ");
INSERT INTO cha_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Yan jatulaeca y Sadog janajâgâ; yan y minilalag para chañija fanguiguimen. ");
INSERT INTO cha_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Janae megae na lalo para ufanquinano; yan rana sija para ufanyinilang. ");
INSERT INTO cha_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Janae y ilo oruga ni y aumentan tano; ya y finachochoñija y apacha. ");
INSERT INTO cha_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Jayulang y fangualuanñija ubas ni y ichan grano; yan y trongco igos sija ni y hielo. ");
INSERT INTO cha_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Japolo y gañija gâgâ locue gui papa y ichan grano, ya y manadan gañija gui minaepen lamlam. ");
INSERT INTO cha_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Jayute gui jiloñija y fijom na binibuña; binibo, linalalo, yan chinatsaga; y manadan manaelaye na angjet sija. ");
INSERT INTO cha_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Mamatinas chalan para y linalaloña; ya ti jachoma y antiñija guinin y finatae, lao japolo y linâlâñija gui peste. ");
INSERT INTO cha_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Ya japuno todo y finenena na finañagon guiya Egipto, y mas magas naminetgotñija gui jalom y tiendan Cam! ");
INSERT INTO cha_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Lao chalane juyong y taotaoña taegüije y quinilo sija, yan jaesgagaejon sija gui desierto taegüije y manadan, gâgâ. ");
INSERT INTO cha_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ya jachule sija gui seguro, ya sija ti manmaañao: lao y tase tumampe y enimigoñija. ");
INSERT INTO cha_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Ya jacone sija asta y oriyan y sinantos na sagaña, güineja na ogso ni y guinanan y agapa na canaeña. ");
INSERT INTO cha_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Jayute juyong y nasion locue gui menañija, yan jafacae guiya sija y erensiañija ya jaraya, ya janafañaga y tribon Israel gui jalom y tiendañija. ");
INSERT INTO cha_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Lao sija trabia jatietentaja, yan manmanembebesteja contra y Gueftaquilo na Yuus, yan ti jaadaje y tinagoña. ");
INSERT INTO cha_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Lao manalo tate, yan manmafatinas dinague taegüije y tatañija: ya manmabira sija gui un banda taegüije y dacon na atco. ");
INSERT INTO cha_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Sa macase güe ya mannalalalo pot y sagañija ni taquilo ya masuog güe ya manafanugo ni y imageñija ni tinaga. ");
INSERT INTO cha_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Anae jajungog este si Yuus, ninabubo, yan jagoschatlie iya Israel. ");
INSERT INTO cha_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Ya pot ayo na jadingo y tabetnaculo guiya Silo, yan y tienda ni y japolo gui entalo taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Ya janae ni y minetgotña y cautibo, ya y minalagña gui canae y contrario. ");
INSERT INTO cha_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Janae y espada ni y taotaoña: yan ninabubo ni y erensiaña. ");
INSERT INTO cha_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Linachae ni y guafe y manpatgon na lalaje; ya y manpatgon na famalaoan taya cantan umasagua. ");
INSERT INTO cha_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Ya y mamaleñija manmodong gui espada; ya y manbiuda sija ti ninafantriste. ");
INSERT INTO cha_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Ya y Señot magmata taegüije y uno ni y guinin mamaego, yan taegüije y matatñga na taotao ni y ninaaagang pot rason di y bino. ");
INSERT INTO cha_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Ya japuno y enimiguña sija ni y mañasaga gui santate: yan japolo sija güi taejinecog na minamajlao. ");
INSERT INTO cha_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Ademas jarechasa y tabetnaculo gui as José, ya ti jaayeg y tribon Efraim. ");
INSERT INTO cha_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Lao jaayeg tribon Juda, ayo ogso Sion ni y güinaeyaña. ");
INSERT INTO cha_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Ya jafatinas y sinantos na sagaña taegüije y manaquilo na sagayan sija, taegüije y tano na japlanta para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Jaayeg si David locue na tentagoña, yan jacone güe guinin y quelat y quinilo, ");
INSERT INTO cha_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Chinile güe ni guinin jatatitiye y manmanago na quinilo ya jacone para unafañocho y taotaoña gui as Jacob yan y erensiaña guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Ya taegüije janafañocho sija segun y tininas y corasonña; yan jaesgaejon sija pot y tiningon y canaeña. ");
INSERT INTO cha_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","O Yuus, y nasion ni ti manjonggue manmato ya manjalom gui erensiamo: ya manataelaye y santos na templomo; ya mayulang ya mapolo y Jerusalem pot montón sija. ");
INSERT INTO cha_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Ya y tataotao y manmatae na tentagomo manmanae nañija y pajaro gui langet: ya y catnen y mañantosmo y gâgâ gui tano. ");
INSERT INTO cha_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Y jâgâñija manmachuda taegüije y janom, gui oriyan Jerusalem; sa taya jaye ufanjinafog. ");
INSERT INTO cha_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Manafanmamamajlaojam ni y tiguangmame: manmamofeajam yan manmabotleajam ni y mañasaga gui oriyanmame. ");
INSERT INTO cha_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Asta ngaean, O Señot, unlalalo para taejinecog? ya y inigomo sinenggue taegüije y guafe? ");
INSERT INTO cha_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Chuda juyong y binibumo gui jilo y nasion ni y ti tumungojao, yan y jilo y raeno sija ni y ti umaagan y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Sa sija lumachae si Jacob, yan jayulang y sagañija. ");
INSERT INTO cha_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Chamo jumajaso contra jame y tinaelayen y tatamname: Polo y minauleg minaasemo ya uchadig insedajam; sa manafangostagpapjamam. ");
INSERT INTO cha_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Ayudajam, O Yuus, gui satbasionmame pot y minalag y naanmo; yan nafanlibrejam, yan fagase y isaomame pot y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Sa jafa ilegñija y nasion ni ti manmanjonggue: Mangue y Yuusñija? Polo y inemog y jâgâ y tentagomo sija ni y manmachuda ya umatungo ni y nasion ni ti manmanjonggue, gui menan y matanmame. ");
INSERT INTO cha_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Polo ya y inigon y manmapreso mato gui menamo; segun y dinangculo y ninasiñamo adaje ayo sija y esta manmatancho para ufanmatae. ");
INSERT INTO cha_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Ya apase gui tiguangmame siete mas gui jalom y pechoñija, y linalatdeñija, sa sija lumalatdejao, O Señot. ");
INSERT INTO cha_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Ayo nae jame y taotaomo yan y quinilo gui pastajimo, bae inalaba jao para taejinecog; ya infanmamanue ni y alabansamo para todo y generasion. ");
INSERT INTO cha_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","ECUNGOG, O Pastot guiya Israel, jago ni y umesgagaejon si José taegüije y manadan quinilo; jago ni y sumasaga gui entalo y querubin sija manina mona. ");
INSERT INTO cha_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Y menan Efraim, yan Benjamin, yan Manases, nacajulo y minatatngamo, ya maelajao para usatbajam. ");
INSERT INTO cha_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Birajam talo, O Yuus; ya nafanina y matamo ya infansatbo. ");
INSERT INTO cha_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O Jeova, Yuus y inetnon sendalo, asta ngaean unlálalaloja contra y tinayuyut y taotaomo? ");
INSERT INTO cha_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Unafañochocho sija ni y pan lago; yan unnae sija ni y lago para ujaguinem gui dangculo na medida. ");
INSERT INTO cha_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Unnafanmumojam yan y tiguangmame: yan y enimigonmame manmachachatgue jam gui entaloñija. ");
INSERT INTO cha_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Birajam talo, O Yuus y inetnon sendalo, ya nafanina y matamo; ya infansatbo. ");
INSERT INTO cha_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Jago chumule juyong y trongcon ubas guiya Egipto: ya jagasja unyute juyong y nasion, ya untanme güe. ");
INSERT INTO cha_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Jago fumamauleg y saga gui menaña, ya güiya y natadodong y jaleña, yan nabula y tano. ");
INSERT INTO cha_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Ya sabana sija mantinampe ni y aninengña, yan y ramasña taegüije y sedro Yuus na trongcon jayo. ");
INSERT INTO cha_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Jatago juyong y ramasña gui tase; yan y manlodo na siniso gui sadog. ");
INSERT INTO cha_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Sa jafa unjulog papa y quelatña: ya todo y manmalolofan gui chalan matitife güe? ");
INSERT INTO cha_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Y balaco guinin y jalomtano machuchule ya mayúyulang, yan y manmachaleg na gâgâ gui fangualuan cumacano. ");
INSERT INTO cha_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Birajao talo, O Yuus inentnon sendalo, ingagagao jao: ya talag papa guinin y langet ya unlie yan unbisita este na trongcon ubas, ");
INSERT INTO cha_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Ya y fangualuan ni y tinanom y agapa na canaemo, yan y ramas ni jago munafitme para jagoja namaesa, ");
INSERT INTO cha_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Masinenggue ni y guafe, ya mautut papa esta; ya manmalingo pot y chinema gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Polo y canaemo gui jilo y taotao gui agapa na canaemo, gui jilo y lajin y taotao ni unnametgot para jago. ");
INSERT INTO cha_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ayo nae ti infanalo tate guinin jago: nafanlâlâjam ya bae inagang y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Birajam talo, O Jeova, Yuus y inetnon sendalo, ya nafanina y matamo; ya infansatbo. ");
INSERT INTO cha_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","FANGANTA agang gui as Yuus ni y minetgotta: fatinas y magof na boruca gui as Yuus Jacob. ");
INSERT INTO cha_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Entona y salmo, yan chule mague y pandireta; yan y magof na atpa yan y guitala. ");
INSERT INTO cha_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Guaefe y trompeta gui tiempo y nuebo na pulan, gui tiempon gualafon na pulan, gui jaanen y guipot magas. ");
INSERT INTO cha_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Sa este lay guiya Israel: yan y tinago Yuus Jacob. ");
INSERT INTO cha_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Jafatinas este as José para untestimonio anae jumanao juyong gui inanaco y tano Egipto: anae jujungog y finijo na ti siña jutungo. ");
INSERT INTO cha_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Janajanao y apagaña guinin y catga: yan y canaeña manalibre guinin y lauya. ");
INSERT INTO cha_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Jago umaagan gui chinatsaga, ya guajo munalibrejao: guajo umopejao gui umatog na sagayan julo: ya juchaguejao gui oriyan janom guiya Meriba. Sila. ");
INSERT INTO cha_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Jungog, O taotaojo, ya guajo junae jao testimonio, O Israel, yaguin malagojao unecungogyo! ");
INSERT INTO cha_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Munga otro yuus, guiya jago; ni unadora otro yuus. ");
INSERT INTO cha_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Sa guajo y Jeova Yuusmo, ni y chumule jao juyong gui tano Egipto: baba y pachotmo, ya bae nabula. ");
INSERT INTO cha_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Lao y taotaojo ti jajungog y inagangjo; ya iya Israel ti malago ni guajo. ");
INSERT INTO cha_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Ayo nae jupolo sija ya jumanao ni y minajetog y corasonñija: para ufanmamomocat ni y pinagatñija. ");
INSERT INTO cha_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","O yaguin y taotaojo majungog yo, ya iya Israel manmamocat gui chalanjo! ");
INSERT INTO cha_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Siña guse juchoma y enimigoñija, ya jubira y canaejo contra y contrarioñija. ");
INSERT INTO cha_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Ya y umanmachatlie ni y Jeova, mojon mansujeto sija guiya güiya: y tiempoñija usaga para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Güiya unafañocho sija locue ni y mas mauleg na trigo: yan y miet ni jumujuyong gui acho anae junajaspog jao. ");
INSERT INTO cha_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","SI Yuus tumotojgue gui inetnon Yuus; ya jajusga gui entalo yuus sija. ");
INSERT INTO cha_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Asta ngaean nae unjusga ti tunas, yan unresibe y taotao sija ni y manaelaye? Sila. ");
INSERT INTO cha_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Jusga y mamoble yan y manaesaena: ya nafanunas y manpinite yan y mannesesitao. ");
INSERT INTO cha_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Rescata mamoble yan y mannesesitao: nafanlibre sija gui canae y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Sa ti jatungo ni ujaquetungo: manmamomocatja gui jalom jomjom: ya todo y plinantan tano manalamten. ");
INSERT INTO cha_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Guajo ileco: Jamyo yuus; yan todo jamyo y famaguon y Gueftaquilo. ");
INSERT INTO cha_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Lao infanmataeja taegüije y taotao sija, yan infanbasnag taegüije y uno gui prinsipe sija. ");
INSERT INTO cha_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Cajulo, O Yuus, jusga y tano: sa jago umerensia todo y nasion. ");
INSERT INTO cha_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","CHAMO famatquiquilo, O Yuus: ya chamo tiumaagan yan chamo quequeto, O Yuus. ");
INSERT INTO cha_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Sa, estagüe, enimigumo na manpalalangpang: yan ayo sija y chumatlie jao jajatsa y iloñija. ");
INSERT INTO cha_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Sa manpinagat ni y dinague consejo contra y taotaomo, yan manafaesen entre sija contra y ninafanatogmo. ");
INSERT INTO cha_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Sa guinin ilegñija: Maela, ya nije tautut sija ni y guinin y nasion; para y naan Israel munga majaso mas. ");
INSERT INTO cha_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Sa sija manafaesen entre sija ni y unoja corason; ya managogüe contra jago. ");
INSERT INTO cha_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Y tiendan Edom yan Ismaelita sija: Moab yan Agareno sija. ");
INSERT INTO cha_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gebal yan Ammon yan Amaleg; Filistia yan y mañasaga guiya Tiro. ");
INSERT INTO cha_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Asur locue mandaña yan sija: sa maninayuda ni y famaguon Lot. Sila. ");
INSERT INTO cha_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Fatinas guiya sija taegüije unfatinas iya Madian yan taegüije iya Sisara taegüije iya Jabin jijot gui sadog Sison: ");
INSERT INTO cha_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Ni y manmalingo guiya Endor: manjuyong manaegüije y estiecot para y tano. ");
INSERT INTO cha_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Fatinas y magasñija ya parejo yan Oreb yan Seeb; magajet na todo y prinsipeñija parejo yan Sebah yan Salmuna: ");
INSERT INTO cha_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Ni y ilegñija: Nije jitaja tachule y sagayan para iyotaja. ");
INSERT INTO cha_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","O Yuusso, fatinas sija ya ufanparejo yan y petbos ni y remolílino; parejo yan y ngasan trigo gui menan y manglo; ");
INSERT INTO cha_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Taegüije y guafe anae jasonggue y jalomtano, yan taegüije y mañila anae finaliñagüe y sabana. ");
INSERT INTO cha_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Taegüijija petsigue sija ni y pagyomo, yan nafanmaañao sija ni y dangculon pinagyomo. ");
INSERT INTO cha_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Nabula y matañija ni y dinesonra: para sija ujaaligao y naanmo, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Polo sija ya ufanmamajlao yan ufanmaañao para taejinecog: magajet na sija ufandesonrao, ya ufanmalingo. ");
INSERT INTO cha_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Para ujatungo na jagoja y naanmo si Jeova, na jagoja y Gueftaquilo gui jilo todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","NAGÜINAEYAYON y sagamo, O Señot y inetnon sendalo! ");
INSERT INTO cha_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Y antijo tumatanga, magajet na asta ninamalango pot y sagan y Jeova: y corasonjo yan y catneco agagange y lâlâlâ na Yuus. ");
INSERT INTO cha_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Magajet y gorrión mañoda gumaña, yan y golondrina chenchonña para güiya, anae siña mapolo y famaguonña, esta y jalom y attatmo, O Señot y inetnon sendalo, Rayjo yan Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Mandichoso ayo sija y mañasaga gui jalom y guimamo; sa sigueja di malabajao: ");
INSERT INTO cha_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Dichoso y taotao ni y minetgotña gaegue guiya jago: yan y chalan para jago gaegue gui corasonña. ");
INSERT INTO cha_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Ni y anae janafanmalofan gui inanaco bayen tinangis jafatinase tupo sija; ya y taftaf na ichan locue tinampe ni y bendision. ");
INSERT INTO cha_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Manjanao guinin y manasiña minetgot asta y otro minetgot cada uno guiya sija manmalie gui menan Yuus guiya Sion. ");
INSERT INTO cha_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Jeova, Yuus y inetnon sendalo, jungog y tinayuyutto: ecungog, O Yuus Jacob. Sila. ");
INSERT INTO cha_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Lie, O Yuus, patangmame: ya atan y matan y pinalaemo. ");
INSERT INTO cha_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Sa y un jaane gui sagamo mas mauleg qui un mit. Gañacoja na jupottero gui guima y Yuusso, qui jusaga gui jalom y sagan y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Sa y Jeova Yuus, güiya y atdao yan y patang: si Jeova unfannae grasia yan minalag: ti jachoma y manmauleg na güinaja ni y mammamomocat gui tininas. ");
INSERT INTO cha_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O Señot y inetnon sendalo, dichoso y taotao ni y umangoco güe guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","JEOVA, jago guinin ninamagof jao ni y tanomo: sa unnafanalo mague y manmacautiba sija gui as Jacob. ");
INSERT INTO cha_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Jago guinin umasie y tinaelayen y taotaomo: yan untampe todo y isaoñija. Sila. ");
INSERT INTO cha_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Guinin unnajanao todo y binibumo: ya unbirajao talo guinin y finijom y binibumo. ");
INSERT INTO cha_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Birajam, O Yuus, gui satbasionmame, yan nabasta y binibumo guiya jame. ");
INSERT INTO cha_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Ada unlalalaloja nu jame para taejinecog? Ada unnajujuyong y linâlâlomo para todo y generasion? ");
INSERT INTO cha_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Ada ti unnalâlâjam talo: para y taotaomo ufanmagof ni jago? ");
INSERT INTO cha_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Fanuejam ni y minaasemo, O Jeova, ya unnaejam ni y satbasionmo. ");
INSERT INTO cha_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Guajo jujungog jafa usangan si Yuus Jeova: sa güiya usangan y pas gui taotaoña, yan y mañantos sija: lao chañija natalo guato gui binaba. ");
INSERT INTO cha_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Magajet na y satbasionña esta jijot güije sija ni manmaañao nu güiya: para y minalag usaga gui tanomame. ");
INSERT INTO cha_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Minaase yan minagajet manásoda ya mandaña: y tininas yan y pas manachico. ");
INSERT INTO cha_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Y minagajet lacho julo gui tano; yan y tininas jaatan papa guinin y langet. ");
INSERT INTO cha_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Magajet na si Jeova numae ni y minauleg: ya y tanota manae minegaeña. ");
INSERT INTO cha_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Tininas jumajanao gui menaña; yan japolo y pinecatña y chalan para ufamocat. ");
INSERT INTO cha_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","NAEGUENG papa y talangamo, O Jeova, ya unopeyo: sa pobleyo yan nesesitaoyo. ");
INSERT INTO cha_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Adaje y antijo; sa debotoyo: O jago ni y Yuusso, nalibre y tentagomo sa jaangoco gue guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Gaease nu guajo, O Jeova: sa juaagang jao todot dia. ");
INSERT INTO cha_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Namagof y anten y tentagomo; sa iya jago, O Jeova, nae jujatsa julo y antijo. ");
INSERT INTO cha_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Sa jago, Jeova, y mauleg yan y chadig manasie; yan dangculo y minaasemo güije todo gui umaagangjao. ");
INSERT INTO cha_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Jungog, O Señot y tinayuyutto: yan ecungog y inagang y guinagagaojo. ");
INSERT INTO cha_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Sa y jaanen y chinatsagaco juagangjao: ya jago y unopeyo. ");
INSERT INTO cha_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Sa y entalo y yuus sija, taya taegüenao iya jago, O Jeova; ni jafa na chocho parejo yan y chechomo. ");
INSERT INTO cha_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Todo y nasion sija ni y finatinasmo, manmato y manmanadora gui menamo, O Jeova; yan ufanalaba y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Sa jago dangculojao yan unfatitinas y manmaman na güinaja: jagoja na maesa Yuus. ");
INSERT INTO cha_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Fanagüeyo ni y chalanmo, O Señot: ya bae jufamocat gui minagajetmo: ya naetnon y jinason corasonjo para umaañao ni y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Sa bae jualaba jao, O Jeova, Yuusso, contodo y corasonjo: yan junamalag y naanmo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Sa sendangculo y minaasemo para guajo; sa guinin unnalibre y antijo guinin iya papapa guiya sasalaguan. ");
INSERT INTO cha_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O Yuus, y mansobetbio mangajulo contra guajo, yan y inetnon y managuaguat na taotao jagasja maaliligao y antijo: yan ti mapolo jao gui menañija. ");
INSERT INTO cha_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Lao jago, O Jeova, si Yuus jao ni y bila minaase yan cariñoso, ñateng para binibo yan dangculo na minaase yan minagajet. ");
INSERT INTO cha_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","O birajao, guiya guajo ya gaease nu guajo: nae ni y minetgotmo y tentagomo, yan nalibre y lajin y tentagomo palaoan. ");
INSERT INTO cha_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Fanueyo ni y señat para y mauleg: para ujalie ayo sija y chumatliiyo ya ufanmamajlao: sa jago, Jeova, y umayudayo yan cumonsuelayo. ");
INSERT INTO cha_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","YPLINANTAÑA gaegue gui santos na ogso. ");
INSERT INTO cha_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Jaguaeyaña si Jeova y trangca Sion mas que todo y saga sija gui as Jacob. ");
INSERT INTO cha_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Manmalag na güinaja y manmasasangan guiya jago, O siuda Yuus. Sila. ");
INSERT INTO cha_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Guajo bae jusangan ni y Rahab yan Babilonia gui entalo ayo sija ni y tumunogyo: Sa, estagüe, Palestina yan Tiro yan Etiopia: este na taotao mafañagon güije. ");
INSERT INTO cha_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Yan iya Sion ualog: Este yan ayo na taotao mafañagon iya güiya: yan y Gueftaquilo namaesa unafitmegüe. ");
INSERT INTO cha_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Si Jeovaja tumufong anae jatugue sija y taotao, na esta na taotao mafañagon güije. Sila. ");
INSERT INTO cha_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Parejo y mangacanta yan y madadandan ufangaegue güije: ya todo y bebôco gaegue guiya jago. Sila. ");
INSERT INTO cha_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","O Jeova, Yuus satbasionjo, güajo guinin umaagan jaane yan puenge gui menamo: ");
INSERT INTO cha_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Polo y tinayuyutto ya ufato gui menamo: naegueng y talangamo gui inagangjo. ");
INSERT INTO cha_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Sa y antijo bula chinatsaga sija: ya y linâlâjo esta jijot gui para y naftan. ");
INSERT INTO cha_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Estayo matufong yan ayo sija y manjajanao papa gui joyo: sa taegüije yo y taotao ni y taya ayudaña. ");
INSERT INTO cha_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Mayute esta gui entalo y manmatae, taegüije y manmapuno ni y manaason jalom y naftan; ni y ti unjajaso mas: ni y manmautut guinin y canaemo. ");
INSERT INTO cha_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Jago pumoloyo guiya papapa na joyo, gui jalom jomjom na lugat gui jalom y tinadong. ");
INSERT INTO cha_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Y binibumo sumasaga macat guiya güajo, ya unachatsagayo nu y todo napomo. Sila. ");
INSERT INTO cha_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Jago munafanjanao lachago y manatungojo guiya guajo; unpoloyo na jumachatlie nu sija: mapongleyo ya ti siñayo manajanao. ");
INSERT INTO cha_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Y atadogjo ninalachae pot y pinitijo: ya juagangjajao, O Jeova, cada jaane, jujuto juyong y canaejo guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Ada unnamalie y ninamanman gui manmatae? Siña y manmatae mangajulo ya unmaalaba? Sila. ");
INSERT INTO cha_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Siña y minauleg güinaeyamo masangan gui jalom y naftan? pat y minagajetmo gui yinilang? ");
INSERT INTO cha_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Siña y ninamanmanmo matungo gui jalom jomjom? yan y tininasmo gui jalom tano ni y manmalefa? ");
INSERT INTO cha_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Lao guajo iya jago, O Jeova, umaagangyo: yan ogaan tinayuyutto ufato gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Sajafa, O Jeova, na unyute y antijo? Sajafa na unnaatog y matamo guinin iya guajo? ");
INSERT INTO cha_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Gofchatsaga tristeyo yan cana yo matae, desde y pinatgonjo: mientras jususungon y minamaañaomo, ya janagosestotbayo. ");
INSERT INTO cha_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Ya y fijom na binibumo malofan guiya guajo: ya y minamaañaomo umututyo. ");
INSERT INTO cha_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Sa manmato gui oriyajo todot dia taegüije y janom: mandaña gui oriyajo. ");
INSERT INTO cha_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Y güinaeyaco yan y amigujo unnafañago guiya guajo, yan y manatungojo gui jalom jomjom. ");
INSERT INTO cha_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","BAE jucanta y minaase Jeova para taejinecog: ya y pachotto nae junamatungo y minagajetmo gui todo y generasion. ");
INSERT INTO cha_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Sa ileco: Y minaase umanacajulo para taejinecog: ya y minagajetmo unnafitme todo gui langet. ");
INSERT INTO cha_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ya jufatinas y trato gui inayegco, yan manjulayo gui as David ni y tentagojo. ");
INSERT INTO cha_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Ya y semiyamo junafitme para taejinecog: ya jufatinas julo y tronumo gui todo y generasion. Sila. ");
INSERT INTO cha_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Ya y langet sija ufanmanalaba ni y ninamanmanmo, O Jeova: y minagajetmo locue gui inetnon y mañantos. ");
INSERT INTO cha_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Sa jaye gui langet sija siña parejuña si Jeova? Jaye gui lajin y gaeninasiña uparejuña si Jeova? ");
INSERT INTO cha_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Si Yuus, gosnamaañao gui pinagat y mañantos, yan umamaanaogüe güe mas qui todo ni ayo sija y mangaegue gui oriyaña. ");
INSERT INTO cha_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","O Jeova, Yuus y inetnon sendalo, jaye matatnga parejo yan jago, O YAH? ya y minagajetmo ni y gaegue gui oriyamo? ");
INSERT INTO cha_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Jago umaregla y sobetbian tase: anae y napo mangajulo, jago pumoca sija. ");
INSERT INTO cha_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Jago yumamag iya Rahab ya unfapidaso taegüije y uno ni y mapuno; jago chumalapon y enimigumo ni y canae y minetgotmo. ");
INSERT INTO cha_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Y langet sija iyomo, yan yo tano locue iyomo: y tano yan y binilan sinajguanña ni y plinantamo sija. ");
INSERT INTO cha_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Y sanlago yan y sanjaya, jago fumatinas sija: Tabor yan Hermon manmagof ni y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Gaegue guiya jago y canae ni y matatnga: sa y canaemo metgot, ya taquilo y agapa na canaemo. ");
INSERT INTO cha_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Y tininas yan y juisio y plinantan tronumo: minaase yan minagajet manjajanao gui menan metamo. ");
INSERT INTO cha_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Mandichoso ayo na taotao y tumungo y magof na inagang: sa manmamocat gui mananan y matamo, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Sa y naanmo nae manmamagof todot dia: yan y tininasmo nae munafangajulo. ");
INSERT INTO cha_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Sa jago y minalag y minetgotñija: yan pot y finaboresimo na injatsajulo y canggelonmame. ");
INSERT INTO cha_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Sa iyon Jeova y patangta: yan y rayta iyon Ayo na Santos guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Ayonae unsangan gui guinigüife gui mañantosmo, ya ilegmo: guajo jupolo y inayuda gui jilo y uno ni y matatnga: yan junacajulo y uno na y maayeg gui taotao. ");
INSERT INTO cha_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Jusoda si David na tentagojo; ya jupalae güe nu y santos na lañajo. ");
INSERT INTO cha_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Guiya y canaejo munafitme: yan y canaejoja locue munametgot güe: ");
INSERT INTO cha_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Ya y enimigo taeinamot guiya güiya: ni y lajin y manaelaye ti umanalamen güe. ");
INSERT INTO cha_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Sa bae juyute papa y contrarioña gui menaña yan jucastiga ayo sija y chumatlie güe. ");
INSERT INTO cha_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Lao y minagajetto yan y minaasejo usaga guiya güiya: yan pot y naanjo na umanacajulo y canggelonña. ");
INSERT INTO cha_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ya bae jupolo y canaeña locue gui jalom tase, yan y agapa na canaeña gui jalom sadog. ");
INSERT INTO cha_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Sa güiya umalog ni guajo: Jago y tatajo, Yuusso, yan y acho gui satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Bae jupolo güe locue pot finenana na finañagujo, mas taquiloña qui y ray sija gui tano. ");
INSERT INTO cha_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Y minaasejo bae juadaje pot güiya para taejinecog, yan y tratujo ufitme guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Y semiyaña locue junasaga para ugaegue taejinecog, yan y tronuña taegüije y jaanen y langet. ");
INSERT INTO cha_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Yaguin famaguonña dumingo y tinagojo, yan ti manmamomocat gui juisioco, ");
INSERT INTO cha_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","Yaguin maquebranta y layjo yan ti maadaje y tinagojo; ");
INSERT INTO cha_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","Ayo nae jufatoegüe gui inaguaguatñija yan y bara, ya jusaulag gui tinaelayeñija. ");
INSERT INTO cha_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Lao y minaasejo ti junajanao todo guiya güiya: ya ti jupolo na ufatta y minagajetto. ");
INSERT INTO cha_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Y tratujo ti juquebranta ni jutolaeca y sinanganjo ni jumuyong gui labiosso. ");
INSERT INTO cha_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Un biajeja jufanjula pot y sinantosso ya ti judague si David. ");
INSERT INTO cha_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Y semiyaña gagaegue para taejinecog, yan y tronuña taegüijeja y atdao gui menajo. ");
INSERT INTO cha_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Ya maplanta para taejinecog taegüije y pilan, ya taegüije y gosmagajet na testigo gui langet. Sila. ");
INSERT INTO cha_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Lao jago jagasja unyute yan unrechasa, jago jagasja lalalojao ni y pinalaemo. ");
INSERT INTO cha_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Sa unchatlie y traton y tentagomo; ya unnaale y coronaña asta papa gui jilo oda. ");
INSERT INTO cha_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Unyamag papa todo y quelatña; yan unyulang y minetgot na castiyaña. ");
INSERT INTO cha_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Ya todo y manmalolofan gui ayo na chalan mayuteñaeñaejon: güiya manamamamajlao ni y tiguangña. ");
INSERT INTO cha_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Jago jumatsa julo y agapa na canae y contrariuña sija; yan jago munafanmagof todo y enimiguña. ");
INSERT INTO cha_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Magajet na jago locue bumira y filon y espadaña, ya ti unnafitme güe gui guera. ");
INSERT INTO cha_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Jago jagasja munabasta y minalagña, yan unyute y tronuña papa gui jilo oda. ");
INSERT INTO cha_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ya y jaanen y pinatgonña jago jagasja munacadada: jago jagasja tumampe güe ni y minamajlao. Sila. ");
INSERT INTO cha_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Asta ngaean, O Jeova, ada unatogjao para taejinecog? Asta ngaean ufañila y binibumo taagüije y guafe? ");
INSERT INTO cha_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","O, jaso na quinadada y tiempoco esta: pot jafa na taesetbe jagas unfatinas todo y famaguan taotao? ");
INSERT INTO cha_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Jaye na taotao enao y lalâlâ ya ti ulie finatae, ni y ujanalibre y antiña gui ninasiñan y naftan? Sila. ");
INSERT INTO cha_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Jeova, mangue y minaasemo sija ni y ampmam, ni y jinilamo as David gui minagajetmo? ");
INSERT INTO cha_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Jaso, Jeova, y minamajlao y tentagomo sija: ni y jucatgaja gui jalom pechoco, y minamamajlao y taotao todo ni y matatnga: ");
INSERT INTO cha_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Ni y enimigumo mannanamamajlao, O Jeova: ni y enimigumo munamamajlao y pinecat y pinalaemo. ");
INSERT INTO cha_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Bendito si Jeova para taejinecog: Amen yan Amen. ");
INSERT INTO cha_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","JEOVA jago guinin saganmamame yan todo y generasion. ");
INSERT INTO cha_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Antes de najuyong y egso sija ya unfatinas y tano todo yan y mañasaga: sa desde y tutujonña yan asta y taejinecog, jagoja si Yuus. ");
INSERT INTO cha_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Jago bumira y taotao para y yinilang; ya ilelegmo: Fanalo guato, jamyo famaguon taotao. ");
INSERT INTO cha_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Sa y mit años gui menamo taegüijeja y nigapja anae malofan esta, yan taegüijeja y ora gui bumebela gui puenge. ");
INSERT INTO cha_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Jago chumule sija taegüije y minilag y janom; manaegüije y minaego: ya y egaan manaeguije y chaguan ni y manlacho julo. ");
INSERT INTO cha_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Ya y egaan, mumegae ya manlacho julo; lao y pupuenge manmautut yan ufanmalayo. ");
INSERT INTO cha_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Sa y linalalomo nae lumachaejam, yan y binibumo nae munafañatsagajam. ");
INSERT INTO cha_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Sa unpolo y tinaelayenmame gui menamo, yan y ti matungo na isaomame gui minananan y matamo. ");
INSERT INTO cha_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Sat odo y jaaninmame manmalofan gui binibumo: inlachae y sacanmame ni y taegüijeja cuentos ni y masangan esta. ");
INSERT INTO cha_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Y jaanen y sacanmame setenta años, ya y pot y minetgot siña gagaegue asta ochenta años; lao y sobetbiañija y checho yan y trineste; sa munaguse manmapos: yan jame mangupo. ");
INSERT INTO cha_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Jaye tumungo y ninasiñan y linalalomo, ya y binibumo segun y ninamaañao guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Ya fanagüejam tumufong y jaaninmame, para mojon usiña guajajam un corason ni y malate. ");
INSERT INTO cha_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Talo mague, O Jeova: asta ngaean? ya polo ya unfañotsot pot y tentagomo. ");
INSERT INTO cha_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","O nafannajong jam taftaf ni y minaasemo: ya insiña manmagof yan infansenmagof todo gui jaaninmame. ");
INSERT INTO cha_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Nafanmagof jam, segun na jaane anae unnafanpinite jam, yan y sacan anae inlie y taelaye: ");
INSERT INTO cha_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Polo y chechomo umalie gui tentagomo sija, yan y minalagmo gui famaguonña. ");
INSERT INTO cha_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Ya y guinatbon Jeova ni y Yuusta ugaegue guiya jame; ya unnafitme guiya jame y checho y canaeta: magajet, y checho y canaemame unnafitme. ");
INSERT INTO cha_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","YA y sumasaga gui umatog na sagayan y Gueftaquilo, güiya usaga gui papa y anineng y Todojajanasiña. ");
INSERT INTO cha_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Bae jusangan as Jeova, güiya y umamparayo yan y castiyujo: Yuusso, iya güiya nae juangocoyo. ");
INSERT INTO cha_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Sa güiya unninalibre guinin y lason y tiradot, yan guinin y yinilang peste. ");
INSERT INTO cha_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Güiya untinampe ni y piluña, yan y papa y papaña nae unangoco jao: y minagajetña uguinogüemo yan upatangmo. ");
INSERT INTO cha_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Jago ti unmaañao ni y minamaañao y puenge; ni y flecha ni mangugupo gui jaane; ");
INSERT INTO cha_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Ni pot y peste ni manmamomocat gui jalom jomjom; ni pot y yinilang ni y lumachae y taloane. ");
INSERT INTO cha_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Y mit ufanbasnag gui oriyamo, yan y dies mit gui agapa na canaemo: lao ti siña mato jijot guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Sa y atadogmoja umatan, yan lumie y apas y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Jagoja, O Jeova, y umamparayo! Sa jagasja unfatinas y Gueftaquilo na sagamo. ");
INSERT INTO cha_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Taya taelaye ufato guiya jago, ni jafa na chetnot ujijot gui sagamo. ");
INSERT INTO cha_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Sa jaencatga y angjetña sija nu jago, para uninadaje todo gui jinanaomo. ");
INSERT INTO cha_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Ya unmajatsa julo ni y canaeñija, ya ti umanafannotpe acho y adengmo. ");
INSERT INTO cha_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ya unfamgacha gui jilo y leon yan y culebla: y patgon leon yan y serpiente ungagacha gui papa adeng sija. ");
INSERT INTO cha_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Sa japolo y güinaeyaña guiya guajo, enao mina junalibre güe: guajo pumolo güe gui taquilo, sa güiya guinin tumungo y naanjo. ");
INSERT INTO cha_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Güiya umagangyo ya guajo umopegüe: sa jumajame gui chinatsaga; junalibre güe yan juonra güe. ");
INSERT INTO cha_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ya y inanaco y linâlâña junanajong güe, yan jufanue güe ni y satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","MAULEG para umannae grasias si Jeova ya umacanta y alabansa sija gui naanmo, O Jago, Gueftaquilo: ");
INSERT INTO cha_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Para infamamanue ni y minauleg güinaeyamo gui egaan yan y minagajetmo cada puenge. ");
INSERT INTO cha_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Gui dandan ni y dies cuetdasña; yan gui guitala; yan gui atpa yan y mames na inagang. ");
INSERT INTO cha_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Sa jago, Jeova, unnamagofyo nu y chechomo: ya bae junagana pot y checho y canaemo. ");
INSERT INTO cha_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","O Jeova, namandinangculo sija y chechomo! yan jinasomo mansentadong: ");
INSERT INTO cha_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Sa y taotao ni y aguaguat ti jatungo: ni y caduco ti jatutungo este. ");
INSERT INTO cha_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Anae y manaelaye lachog taegüije y chaguan, yan anae todo y chumogüe y tinaelaye manlajyan: ayo mina ufanmayulang para taejinecog: ");
INSERT INTO cha_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Lao jago, O Jeova, para taejinecog gagaegue y tinaquilo. ");
INSERT INTO cha_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Sa, estagüe, y enimigumo, O Jeova, sa, estagüe, y enimigumo na ufanmalingo; yan todo y chumochogüe y tinaelaye ufanmachalapon. ");
INSERT INTO cha_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Lao y canggelonjo, jago munacajulo taegüije y canggelon y titogcha na nubiyo: ya mapalaeyo ni y lañan nuebo. ");
INSERT INTO cha_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Sa y atadogcoja lumie y güinaeyaco gui enimigujo sija yan y talangajoja jumungog y güinaeyaco ni chumogüe y taelaye ni y mangajulo contra guajo. ");
INSERT INTO cha_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Sa y tinas lâlâ taegüije y trongcon palma: lumadangculo güe taegüije y trongcon sedro gui Libano. ");
INSERT INTO cha_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Ayo sija y manmatanme gui guima Jeova, manlâlâ gui jalom y sagan y Yuusta. ");
INSERT INTO cha_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Sigueja di manmanogcha asta que manbijo: manmesgo yan manbetde. ");
INSERT INTO cha_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Para ufanmamanue na si Jeova goftunas: güiya y achojo ya taya tinaelaye guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","SI Jeova jagobiebietna mabeste güe ni y ninasifia; si Jeova numabeste güe, ni y minetgot dinidog güe: y tano locue ninafitme ya ti siña manacalamten. ");
INSERT INTO cha_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Y tronumo mafatinas desde di ampmam na tiempo: jago guinin y taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Mangajulo y minalag sija, O Jeova, ya y minalag sija mangajulo y inangangñija; y minalag sija mangajulo y napoñija. ");
INSERT INTO cha_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Mastaquilo y inagang sija y minegae y janom sija, yan y fijom na napo gui tase, si Jeova gui sanjilo gaesisiña. ");
INSERT INTO cha_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Y testimoniomo sija mansenmagajet: sinantosja conbiene gui jalom guimamo, O Jeova, para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","O Jeova, Yuus Jao, ni y inemog iyomo; O Yuus Jao, ni y inemog iyomo, famanuen maesajao ni y minalag. ");
INSERT INTO cha_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Jatsa jao julo, jago y jues y tano: nae ni y apasñija y mansobetbio. ");
INSERT INTO cha_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Jeova, asta ngaean y manaelaye, asta ngaean y manaelaye nae ufanmagana? ");
INSERT INTO cha_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Sija manmefno, sija sumangan sinaguat yan todo y chumochogüe y tinaelaye manbanidoso. ");
INSERT INTO cha_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Sa sija yumamag ya japedasitos y taotaomo, O Jeova, yan janafanpinite y erensiamo. ");
INSERT INTO cha_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Sija pumuno y biuda yan taotao juyong, yan japuno y manaetata. ");
INSERT INTO cha_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Sa ilegñija: Si Jeova ti ujalie, ni si Yuus Jacob ti ufanatituye. ");
INSERT INTO cha_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Fanatituye, jamyo managuaguat gui taotao: yan jamyo mangaduco, ngaean nae infanmalate? ");
INSERT INTO cha_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Ya ayo y plumanta y talanga, ada ti ujungog? ya ayo y fumatinas y atadog, ada ti ulie? ");
INSERT INTO cha_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Ya ayo y cumastiga y taotao sija ada ti ujanafanunas? ayoja y fumanagüe y taotao ni y tiningo? ");
INSERT INTO cha_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Si Jeova jatungo y jinason y taotao, na sija puro jinaja. ");
INSERT INTO cha_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Dichoso y taotao ni y unnaregla güe, O Jeova, yan ufanagüe güe ni y tinagomo; ");
INSERT INTO cha_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Sa jago siña numae gui descanso guinin y jaanin y chinatsaga, asta qui y joyo maguadog para y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Sa si Jeova ti janasuja y taotaoña, ni ti udingo y erensiaña. ");
INSERT INTO cha_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Lao y jinisga utalo guato gui tininas: yan todo y manunas na corason ujadalalag. ");
INSERT INTO cha_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Jaye malago cajulo para guajo contra y chumochogüe y daño? Jaye malago tumojgue julo para guajo contra y chumochogüe y taelaye? ");
INSERT INTO cha_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Yanguin si Jeova guinin ti umayudayo, y antijo gusija guinin sumaga gui finatquilo. ");
INSERT INTO cha_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Anae ileco: Sulong y adengjo: y minaasemo, O Jeova, mumantieneyo. ");
INSERT INTO cha_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Anae juguaja y manadan jinasoco gui sanjalomjo, y quinensuelamo sija ninasenmagof y antijo. ");
INSERT INTO cha_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Y tronon tinaelaye uguaja comunion yan jago, ni y fumatinas daño pot y tinago? ");
INSERT INTO cha_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Sija mandaña contra y anten y manunas, yan ja sentensia y jâgâ y taeisao. ");
INSERT INTO cha_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Lao si Jeova guinin y leca na torijo: yan Yuusso y achon y guinegüeco. ");
INSERT INTO cha_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Ya güiya chumule gui jiloñija y isaoñija, yan ujautut sija gui dañoñijaja; ya si Jeova, ni y Yuusta, umutut sija. ");
INSERT INTO cha_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","O maela, ya tacantaye si Jeova: nije tafatinas y minagof na inagang para y acho y satbasionta. ");
INSERT INTO cha_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Nije taufanmato gui menaña yan y grasias, ya tafatinas y minagof na inagang nu y salmos. ");
INSERT INTO cha_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Sa si Jeova y dangculo na Yuus, yan y dangculo na Ray gui jilo todo yuus. ");
INSERT INTO cha_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Y jalom y canaeña nae mangaegue y manadong na sagayan gui tano: y minetgot y beca sija iyoña locue. ");
INSERT INTO cha_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Y tase iyoña yan güiya fumatinas: yan y canaeñaja fumatinas y anglo na tano. ");
INSERT INTO cha_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","O maela nije taadora ya tafanecon papa, nije tafandimo gui menan Jeova ni y fumatinasjit. ");
INSERT INTO cha_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Sa güiya y Yuusta; yan jita y taotao gui pastajiña, yan y quinilo gui canaeña. Pago na jaane yaguin injingog y inagangña, ");
INSERT INTO cha_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Chamiyo munafanmajejetog y corasonmiyo, taegüije guiya Meriba, taegüije y jaanin y tentasion gui desierto. ");
INSERT INTO cha_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Anae y tatanmiyo tumientayo, machagueyo, yan malie y chechojo. ");
INSERT INTO cha_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Cuarenta años inapmamña nae tristeyo pot este na generasion, ya ileco: Sija na taotao ni y manlache gui corasonñija, yan jagasja ti jatungo y chalanjo. ");
INSERT INTO cha_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Pot ayo na manjulayo gui binibujo, ya sija ti siña majalom gui descansoco. ");
INSERT INTO cha_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","O cantaye si Jeova ni y nuebo na canta: cantaye si Jeova todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Cantaye si Jeova, bendise y naanña; fanmamanue ni y satbasionña guinin y jaane yan y jaane. ");
INSERT INTO cha_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Sangan claro y minalagña gui nasion sija ya y ninámanmanña gui entalo todo y taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Sa si Jeova dangculo, yan sendangculo para umaalaba: güiya umamaañaogüe mas qui todo yuus. ");
INSERT INTO cha_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Sa todo y yuus y nasion sija manidolo: lao si Jeova fumatinas y langet sija. ");
INSERT INTO cha_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Onra yan minagas mangaegue gui menaña: minetgot yan guinatbo mangaegue gui jalom y santos na sagaña. ");
INSERT INTO cha_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Nae si Jeova, O familian gui taotao sija, nae si Jeova minalag yan minetgot. ");
INSERT INTO cha_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Nae si Jeova ni y minalag sa uiyon y naanña: chule y ninae ya maela sanjalom gui sagaña. ");
INSERT INTO cha_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","O adora si Jeova gui guinatbon y sinantosña: fanlaolao gui menaña todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Sangan gui nasion sija na si Jeova jagobiebietna: y tano maplanta locue ni y ti siña manacalamten: guiya jumusga y taotao gui tininas. ");
INSERT INTO cha_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Manmagof y langet sija, yan senmagof y tano; ya y tase palalangpang, yan y binilaña. ");
INSERT INTO cha_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Ya y fangualuan senmagof yan todo y mangaegue gui sanjalomña: ayonae todo y trongco sija gui jalomtano mangantapot y minagof. ");
INSERT INTO cha_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Gui menan Jeova, sa güiya umamamaela; sa guiya umamamaela para ujusga y tano: ujusga y tano gui tininas, yan y taotao sija gui minagajetña. ");
INSERT INTO cha_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","SI Jeova jagobiebietna, polo ya y tano umagof; polo ya y minegae y isla ufansenmagof. ");
INSERT INTO cha_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Y mapagajes yan y jemjom sija mangaegue gui oriyaña: tininas yan juisio y plinantan y tronuña. ");
INSERT INTO cha_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Y guafe manjanao gui menaña, yan mausinesenggue y enimiguña gui oriya. ");
INSERT INTO cha_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Y lamlamña maninina y tano: ya y tano malie ya ninalaolao. ");
INSERT INTO cha_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Y egso sija manmadirite taegüije y danges gui menan Jeova, gui menan y Señot y tano todo. ");
INSERT INTO cha_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Y langet sumangan claro y tininasña, yan todo y taotao guinin malie y minalagña. ");
INSERT INTO cha_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Nafanmamajlao todo ayo sija y sumesetbe y imagen sija ni tinaga, ni y tunanmaesaja sija y ídolo sija: Adora güe todo jamyo ni y yuus. ");
INSERT INTO cha_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Yya Sion jajungog ya ninamagof, yan y jagan Juda sija ninafansenmagof; sa pot y juisiomo sija, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Sa jago Jeova, mas taquilo gui jilo todo y tano: ya jago umanacajulo chago gui jilo todo y yuus. ");
INSERT INTO cha_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","O jamyo y gumaeya si Jeova, jachatlie y daño: güiya umadaje y anten y mañantosña: güiya munafanlibre sija juyong gui canae y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Manana matanme para y manunas, yan minagof para y manunas na corason. ");
INSERT INTO cha_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Fanmagof as Jeova jamyo ni y manunas; nae grasias y santos na naaña. ");
INSERT INTO cha_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","CANTAYE si Jeova ni y nuebo na canta; sa güiya fumatinas y mannamanman na güinaja: sa y agapa na canaeña, yan y santos na canaeña fumatinas y satbasion para güiya. ");
INSERT INTO cha_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Si Jeova janamatungo y satbasionña: y tininasña jafanue gui menan y nasion sija. ");
INSERT INTO cha_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Jagasja jajaso y minaaseña yan y minagajetña para y guima Israel: ya todo sija y uttimon y tano, guinin malie y satbasion y Yuusta. ");
INSERT INTO cha_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Fatinas y minagof na inagang as Jeova, todo y tano: agang yan fanganta, nu y minagof, junggan, fanganta alabansa sija. ");
INSERT INTO cha_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Cantayo si Jeova y alabansa sija, nu y atpa; y atpa yan y inagang y guinatbon musica. ");
INSERT INTO cha_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Yan y trompeta sija yan y sonidon y cotneta; fatinas y minagof na inagang gui menan y Ray Jeova. ");
INSERT INTO cha_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Polo ya y tase upalalangpang yan y binilaña; y tano yan y mañasaga gui sanjalomña; ");
INSERT INTO cha_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Polo ya y manadan janom ujanafamapagpag canaeñija: polo ya y egso sija manganta pot y minagof. ");
INSERT INTO cha_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Gui menan Jeova: sa güiya umamamaela para ujusga y tano: ujusga y tano, gui tininas yan y taotao sija gui minagajet. ");
INSERT INTO cha_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","SI Jeova jagobiebietna; polo ya y taotao sija ufanlaolao; matatachong güe guijilo y querubin: polo ya y tano ufangalamten. ");
INSERT INTO cha_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Si Jeova dangculo guiya Sion: yan güiya mas taquilo gui jilo todo y taotao. ");
INSERT INTO cha_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Polo ya sija ufanalaba y dinagculon yan y namaañao na naanmo; sa santos güe. ");
INSERT INTO cha_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Y ninasiñan y ray locue jaguaeya y juisio: jago pumolo y tininas; jago fumatinas y juisio yan y tininas gui as Jacob. ");
INSERT INTO cha_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Nacajulo si Jeova ni y Yuusta, yan adora gui fañajangan y adengña; sa santos güe. ");
INSERT INTO cha_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Si Moises yan Aaron gui entalo mamale, yan si Samuel manisija yan ayo y umaagang y naanña; sija umaagang si Jeova, ya güiya umope sija. ");
INSERT INTO cha_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Güiya cumuentutuse sija gui jalom y jaliguen y mapagajes: sija umadaje y tinagoña, yan y otden ni y mannae sija. ");
INSERT INTO cha_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Jago umope sija, O Jeova Yuusmame: jago si Yuus ni y umasie sija, achogja jago chumule y inemog gui chechoñija. ");
INSERT INTO cha_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Nacajulo si Jeova ni y Yuusta, yan adora güe gui santos na ogsoña: sa si Jeova, ni y Yuusta, santos güe. ");
INSERT INTO cha_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","FATINAS y minagof na inagang as Jeova: jamyo tano todos. ");
INSERT INTO cha_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Setbe si Jeova ni y minagof: maela gui menaña ya fanganta. ");
INSERT INTO cha_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Tingo na si Jeova, güiya si Yuus: güiyaja y fumatinas jit, yan jita iyoña; jita y taotaoña yan y quinilo sija gui pastajiña. ");
INSERT INTO cha_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Fanjalom gui trangcaña yan y inefresen grasias, ya y jalom y sagaña yan y alabansa: nae güe grasias, yan bendise y naanña. ");
INSERT INTO cha_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Sa si Jeova mauleg; y minaaseña ugagaegue para taejinecog; yan y minagajet para todo y generasion sija. ");
INSERT INTO cha_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","BAE jucanta y minaase yan y juisio: iyajago nae O Jeova, bae jucanta. ");
INSERT INTO cha_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Bae juadajeyo ni y malate gui cabales na jinanao. O ngaean nae unfato jao guiya guajo? bae jufamocat gui jalom guimajo yan y cabales na corason. ");
INSERT INTO cha_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Mungayo pumolo y taelaye na güinaja gui menan atadogjo: juchatlie y chechoñija ayo y manabag sija: tiucheton guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Y chatpayon na corason junafanjanao guiya guajo; ti yajo tumungo y manaelaye na güinaja. ");
INSERT INTO cha_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Ayo y secreto na finajiyunge y tiguangña, güiya bae juyulang: ya ayo y taquilo y inatanña yan y sobetbio na corason ti siña jusungon. ");
INSERT INTO cha_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Y atadogjo bae janameton y manmanjonggue gui tano, para ufañaga sija guiya guajo: ya ayo y mamomocat gui cabales na jinanao, güiya siempre sumesetbeyo. ");
INSERT INTO cha_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Ya ayo y chumochogüe y dinague ti siña sumaga gui jalom guimajo: ya ayo y sumasagan y mandague ti siña numafitme gui menan y atadogjo. ");
INSERT INTO cha_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Y egaan yan y egaan bae juyulang todo y manaelaye gui tano; para uutot todo y chumochogüe ni y taelaye gui siuda Jeova. ");
INSERT INTO cha_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","JUNGOG y tinayuyutto, O Jeova, polo y inagangjo ya ufato guiya Jago. ");
INSERT INTO cha_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Chamo munaatog y matamo guiya guajo gui jaanen anae chatsagayo: naegueng y talangamo guiya guajo; y jaane anae juagangjao, opeyo guse. ");
INSERT INTO cha_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Sa y jaanijo linachae taegüije y aso, ya y telangjo janon taegüije y falot. ");
INSERT INTO cha_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Y corasonjo manetnot, yan anglo taegüije chaguan; sa malefayo jucano y najo pan. ");
INSERT INTO cha_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Ya pot y inagang y inigongjo y telangjo mafachet yan y catneco. ");
INSERT INTO cha_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Parejoyo yan y pelicano na pájaro gui desierto: yan taegüijeyo y memo gui lugat na mayulang. ");
INSERT INTO cha_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Jupulan, yan jumuyong yo taegüije y gorrion na pajaro güigüiyaja gui jilo y atof y guima. ");
INSERT INTO cha_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Y enimigujo lumalatdeyo todot dia; yan ayo sija y manlalalo contra guajo manmanjula pot guajo. ");
INSERT INTO cha_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Sa jagasja jucano y apo taegüije y pan, yan manadaña y guimenjo yan y tanges. ");
INSERT INTO cha_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Sa pot y linalalomo yan y binibumo: sa jago jumatsayo yan yumuteyo. ");
INSERT INTO cha_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Y jaanijo taegüije y anineng ni y umaso; yan angloyo taegüije y chaguan. ");
INSERT INTO cha_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Lao jago, O Jeova, gagaegue jao para taejinecog: yan y memoriasmo asta todo y generasion. ");
INSERT INTO cha_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Jago ucajulo, yan umaase ni iya Sion: sa y tiempo para unmaase nu güiya, magajet na mato y tiempo ni y matancho. ");
INSERT INTO cha_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Sa y tentagomo ninafanmagof ni y achoña: yan ninafanmaase ni y petbosña. ");
INSERT INTO cha_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Enao mina y nasion sija ufanmaañao ni y naan Jeova, yan todo y ray sija gui tano ni y minalagmo. ");
INSERT INTO cha_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Sa si Jeova jafatinas y Sion, umanog güe gui jalom y minalagña. ");
INSERT INTO cha_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Jagoflamen y tinayuyut y mannesesitao; yan ti jachatlie y tinayuyutñija. ");
INSERT INTO cha_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Utugue este para y generasion ni y manmámamaela: yan y taotao ni y ufanmafatinas ujaalaba si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Sa güiya jagasja jaatan papa gui y tinaquilo y santos na sagaña; guinin y langet nae si Jeova jaatan y tano. ");
INSERT INTO cha_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Para ujungog y inigong y manmaprereso: yan para upula ayo sija y manmatancho para ufanmapuno. ");
INSERT INTO cha_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Para umasangan claro y naan Jeova guiya Sion, yan y alabansaña guiya Jerusalem; ");
INSERT INTO cha_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Anae y taotao sija manetnon ya mandaña, yan y raeno sija para ujasetbe si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Janadafe y minetgotto gui chalan; güiya munacadada y jaanijo. ");
INSERT INTO cha_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Guajo ileco: O Yuusso chamo yo chumuchule gui lamita na jaanijo: y sacanmo sija para todoja y generasion. ");
INSERT INTO cha_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Sa desde y ampmam na tiempo jago pumolo y plinantan tano: yan y langet sija y checho y canaemo. ");
INSERT INTO cha_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Sija ufanmalingo, lao jago ungagaegueja: magajet na todo sija ufanguesbijo taegüije y magago: taegüije y bestido untolaeca sija, ya sija manmatalaeca. ");
INSERT INTO cha_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Lao jago y mismojajao, yan y sacanmo sija ti ufanjocog. ");
INSERT INTO cha_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Y famaguon y tentagomo ufangagaegue, yan y semiyanñija ufanmaplanta gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","BENDISE si Jeova, O antijo: yan todo y sanjalomjo, bendise y santos na naanña. ");
INSERT INTO cha_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Bendise si Jeova, O antijo, yan chamo malelefa todo ni y minaulegña: ");
INSERT INTO cha_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ni y umasie todo tinaelayemo; ni y munamagong todo y chetnotmo; ");
INSERT INTO cha_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Ni y munalibre y linâlâmo guinin y yinilang: ni y comorona jao ni güinaeyan mauleg yan y manadan minaase: ");
INSERT INTO cha_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Ni y munanajong y pachotmo ni y manmauleg na güinaja: ya y pinatgonmo jananuebo taegüije y aguila. ");
INSERT INTO cha_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Si Jeova fumatinas y tinas na chocho sija, yan y juisio sija para todo ayo sija y manmachiguet. ");
INSERT INTO cha_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Güiya munatungo si Moises ni y chalanña, ya y chechoña gui famaguon Israel. ");
INSERT INTO cha_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Si Jeova bula y minaase yan cariñoso, ñateng y binibuña yan gofmegae y minaaseña. ");
INSERT INTO cha_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Güiya ti ufanlalatde para siempre: ni umantiene y binibuña para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Ti guinin jafatinas guiya jita segun y isaota; ni uapasejit segun y tinaelayeta. ");
INSERT INTO cha_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Sa taegüije y langet goftaquilo gui jilo y tano, taegüijeja sendangculo y minaaseña para ayo sija y manmaañao nu güiya. ");
INSERT INTO cha_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Taemanoja chinagoña desde y sancatan, yan asta y sanlichan, taegüijeja chinagoña nae janajanao guiya jita y isaota. ");
INSERT INTO cha_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Parejoja yan y tata ni jaguaeya y famaguonña, taegüenaoja si Jeova jaguaeya ayo sija y manmaañao nu güiya. ");
INSERT INTO cha_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Sa güiya tumungo y jechurata; jajaso na jita y petbos. ");
INSERT INTO cha_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Sa y taotao, y jaaniña taegüijeja y chaguan; taegüijeja y flores gui fangualuan lalachog. ");
INSERT INTO cha_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Sa y manglo manmalofan gui jiloña, yan güiya mapos: yan y sagayan ti siña jatungo mas. ");
INSERT INTO cha_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Lao y minaase Jeova, guinin taejinecog asta taejinecog guijilo ayo sija y manmaañao nu güiya, yan y tininasña gui famaguon y famaguon; ");
INSERT INTO cha_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Yya sija y umadadaje y tratuña, yan ayo sija y jumajaso y finanagüeña para ufatinas. ");
INSERT INTO cha_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Si Jeova japlanta y tronuña gui langet sija; yan y raenoña y naregla y jilo todoja. ");
INSERT INTO cha_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Bendise si Jeova, jamyo ni angjetña sija, ni y manmatatnga gui minetgot, ni y cumumple y sinanganña, ni y umecungog y inagang y finoña. ");
INSERT INTO cha_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Bendise si Jeova todo jamyo ni y inetnon sendaloña: jamyo ni y ministroña ni y fumatitinas y minalagoña. ");
INSERT INTO cha_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Bendise si Jeova, todo y finatinasña, gui todo y sagayan anae jagobiebietna: bendise si Jeova, O antijo. ");
INSERT INTO cha_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","BENDISE si Jeova, O antijo: O Jeova Yuusso, jago y sendangculo; jago minagagago ni y onra, yan y minagas. ");
INSERT INTO cha_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ni y untampen maesajao ni y manana taegüije y bestido: ni y jumuto juyong y langet sija taegüije y cottina. ");
INSERT INTO cha_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Ni y plumanta y jayo y aposentuña gui jalom janom: ni y fumatinas y mapagajes para caruajeña: ni y mamomocat gui jilo y papan y manglo. ");
INSERT INTO cha_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Ni y fumatinas y manglo sija para tentagoña: y ministroña y mañila y guafe. ");
INSERT INTO cha_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Ni y pumolo y plinantan tano, ya ti siña manacalamten para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Ya tumampe güe ni y tinadong taegüije y bestido: y janom sija manotojgue gui sanjilo y beca sija. ");
INSERT INTO cha_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Ya pot y linalatdemo, sija manjanao; ya pot y inagang y julumo mañadig manjanao. ");
INSERT INTO cha_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Sija manjanao julo gui beca sija, sija apan papa gui oriyan y bayesija, gui sagayan ni y jago fumamauleg para sija. ");
INSERT INTO cha_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Jago pumolo y uttimonñija ya ti siña manmalofan guato; para ti siña jabira sija talo para utampe y tano. ");
INSERT INTO cha_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Jatago y tutujon y janom gui jalom y bayesija; ni y manmalalago gui entalo y egso sija. ");
INSERT INTO cha_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Sija numae guimenñija y todo gâgâ sija gui fangualuan: y manmachaleg na asno sija manmagong y majoñija. ");
INSERT INTO cha_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Ya iya sija nae y pajaron y langet guaja sagañija ya mangacanta gui entalo y ramas sija. ");
INSERT INTO cha_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Güiya numaye janom y egso sija guinin y aposentuña sija: y tano jaspog ni y tinegcha y chechomo. ");
INSERT INTO cha_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Güiya y chaguan munafanlâlâ para y guaca sija, yan y tinanom para usinetbe y taotao: para ufañule nengcano gui tano; ");
INSERT INTO cha_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Yan y bino ni y munamamagof y corason y taotao, yan y laña para ulamlam y mataña, yan y pan ni y munamemetgot y corason y taotao. ");
INSERT INTO cha_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Y trongcon jayo Jeova manbula chugo; y sedro sija gui Libano ni y tinanomña; ");
INSERT INTO cha_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Anae y pajaro jafatitinas y chechoñija; ya y chuchuco, y trongcon pino guimaña. ");
INSERT INTO cha_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Y taquilo na ogso sija para y manmachaleg na chiba: yan y acho sija guinegüe para y conejo. ");
INSERT INTO cha_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Jatancho y pilan para y tiempo: y atdao tumungo y jinanaoña papa. ");
INSERT INTO cha_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Jago fumatinas y jemjom yan puenge; anae todo y gâgâ gui jalomtano mangucunanaf mona. ");
INSERT INTO cha_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Y manfamaguon na leon sija manaagang ni y manmaconeñija yan jaaliligao y nañija guinin as Yuus. ");
INSERT INTO cha_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Y atdao cajulo, sija manmapos, yan manason sija papa gui jalom y liyangñija. ");
INSERT INTO cha_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Y taotao jumajanao mona gui finatinasña yan gui chechoña, asta qui puenge. ");
INSERT INTO cha_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Jeova, manminegae sija y chechomo! y minenajlom, jago fumatinas sija todo: y tano senbula ni y rinicumo. ");
INSERT INTO cha_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Ayo guato gaegue y tase, dangculo yan ancho, anae y sanjalomña sija y güinaja na mangucunanaf ni ti siña matufong, todoja mandangculo yan mandiquique sija na gâgâ. ");
INSERT INTO cha_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Ayo nae manjajanao y batco sija: ayo nae gaegue y lebiatan ni y finatinasmo para y jumugando gui sanjalomña. ");
INSERT INTO cha_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Este sija todo mumananggajao; sa jago siña unnae sija nañija gui tiempo ni matancho. ");
INSERT INTO cha_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Sa ayo y jago numae, sija naufandaña: unbaba y canaemo ya sija mannajong ni y minauleg. ");
INSERT INTO cha_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Unnaatog y matamo, sija mañatsaga: unchule y jinagonñija, sija manmatae, yan manalo guato gui petbosñija. ");
INSERT INTO cha_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Untago mona y espiritumo, sija manfinatinas: yan jago munanuebo y inatan gui sanjilo y tano. ");
INSERT INTO cha_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Polo ya y minalag Jeova ugagaegue para taejinecog: Polo ya si Jeova umagof gui chechona: ");
INSERT INTO cha_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Ni y jaatan y jilo y tano yan jayengyong: ni y japacha y egso sija yan janaasgon. ");
INSERT INTO cha_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Bae jucantaye si Jeova taemenoja y inanaco y linâlâjo: bae jucantaye tinina y Yuusso mientras lalâlâyo. ");
INSERT INTO cha_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Polo ya y jinasoco iya güiya usenmames: bae jugofmagof as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Polo y manisao ya ufanlinachae gui tano, polo y manaelaye ya utaya. Bendise si Jeova, O antijo. Alaba si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","O nae grasias si Jeova; agang y naanña; namatungo y chechoña gui entalo taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Cantaye güe, cantaye güe ni y alabansa sija; fanadingan ni y todo y chechoña ni y mannamanman. ");
INSERT INTO cha_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Manmalag jamyo ni y santos na naanña: umanmagof ayo sija na corason y umaliligao si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Aligao si Jeova yan y minetgotña: Aligao y mataña para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Jaso y ninamanman checho ni y monjayan jachogüe; ninamanmanña yan y juision y pachotña; ");
INSERT INTO cha_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","O Jamyo, ni y semiyan Abraham tentagoña, jamyo ni y famaguon Jacob inayegña sija. ");
INSERT INTO cha_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Güiya si Jeova Yuusta: y juisioñasija mangaegue todo gui tano. ");
INSERT INTO cha_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Jagasja jaso y tratuña para taejinecog, y finijo ni y tinagoña para mit na generasion. ");
INSERT INTO cha_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Ayo na trato ni y jafatinas gui as Abraham, yan y jinilaña gui as Ysaac. ");
INSERT INTO cha_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Yan ayoja janafitme gui as Jacob para otden, yan as Israel para taejinecog na trato. ");
INSERT INTO cha_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Ylelegña: Yya jago guajo junaejao y tano Cananea, y facae y erensiamo. ");
INSERT INTO cha_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Anae sija mandidideja na numeron taotao: junggan, senmandidide yan taotao juyong güije; ");
INSERT INTO cha_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Ya sija manjanao guinin y un nasion asta y otro nasion, guinin y un raeno asta otro taotao; ");
INSERT INTO cha_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Ti japolo ni un taotao na ujafatinas daño guiya sija: magajet na jalalatde y ray sija pot causañija: ");
INSERT INTO cha_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Ylegña: Chamo pumapacha y pinalaejo, yan chamo munafanlalamen y profetajo sija. ");
INSERT INTO cha_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Ya jatago y ñinalang gui jilo y tano: ya jayulang todo y minetgot y agon. ");
INSERT INTO cha_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Ya jatago un taotao gui menañija, si José ni y mabende para tentago. ");
INSERT INTO cha_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Ayo sija na adengña y ninafanlamen ni y cadena: güiya mapolo guientalo y lilog. ");
INSERT INTO cha_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Asta y tiempo anae macumple y finoña: ya y fino Jeova chumague güe, ");
INSERT INTO cha_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Y ray matago ya pinila güe, ayo y magas taotao sija yan pinelo güe na ujanao libre. ");
INSERT INTO cha_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Pinelo güe magas gui guimaña yan gobietnon todo y güinajaña: ");
INSERT INTO cha_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Para upreso y prinsipeña ni y minagofña; yan ufanagüe y manamco ni y manpápagat. ");
INSERT INTO cha_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Si Israel locue jumalom guiya Egipto; yan si Jacob taotao juyong sumasaga gui tano Cam. ");
INSERT INTO cha_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Yan janafansenmegae y taotaoña; yan janafanmetgot mas que y enimigoñija. ");
INSERT INTO cha_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Jabira y corasonñija para ujachatlie y taotaoña sija, para ufanmatinas ni y finaye gui tentagoña sija. ");
INSERT INTO cha_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Jatago si Moises ni y tentagoña; yan si Aaron ni y guinin inayegña. ");
INSERT INTO cha_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Sija japolo ni y señatña guiya sija, yan ninamanman gui tano Cam. ");
INSERT INTO cha_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Jatago y jemjom, ya ninajomjom; yan sija ti ninafanaguaguat contra y finoña. ");
INSERT INTO cha_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Jatolaeca y janomñija jafajâgâ, yan japuno y güijanñija. ");
INSERT INTO cha_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Y tanoñija janae manadan ranas, ya megae gui jalom y aposenton y rayñija sija. ");
INSERT INTO cha_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Güiya sumasangan, yan manmato manadan dinaña lalo, yan juto sija gui todo y oriyan y tanoñija. ");
INSERT INTO cha_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Güiya numae sija uchan graniso, yan mañila guafe gui tanoñija. ");
INSERT INTO cha_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Jasaolag y trongcon ubasñija locue, yan y trongcon ygosñija; yan jajulog y trongcon jayo sija gui oriyan tanoñija. ");
INSERT INTO cha_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Güiya y sumangan, yan y apacha sija manmato, yan uruga na ulo sija yan ayo taya numeroñija, ");
INSERT INTO cha_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Ya sija jacano todo y tinanom gui jalom y tanoñija, yan jalachae sija y tinegcha gui tanoñija. ");
INSERT INTO cha_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Ya japuno locue todo y finenana na finañagon laje gui tanoñija, y magas todo y ninasiñañija. ");
INSERT INTO cha_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Ya jacone sija juyong locue yan y salape yan y oro; yan taya ni un taotao malango gui triboñija. ");
INSERT INTO cha_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Yya Egipto manmagof anae sija manjanao: pot minaañaoñija guinin podong guiya sija. ");
INSERT INTO cha_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Jajuto y mapagajes para ufantinampe; yan y guafe janae para ufaninina gui puenge. ");
INSERT INTO cha_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Manmangagao y taotao, yan jaconie pajaro ni calang palumo sija; yan ninafanjaspog ni y pan langet. ");
INSERT INTO cha_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Jababa y acho yan y janom milalag juyong; manmalalago gui anglo na sagayan taegüije y sadog. ");
INSERT INTO cha_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Sa jajaso y santos na sinanganña, yan Abraham ni y tentagoña. ");
INSERT INTO cha_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Ya jacone juyong y taotaoña yan y minagof, yan y inayegña gui cantasion sija. ");
INSERT INTO cha_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Yan janae sija ni y tano y nasion sija: yan sija jachule para iyoñija ni y checho y taotao sija: ");
INSERT INTO cha_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Para usiña adaje y otdenña, yan ufatinas y layña. Alaba jamyo si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","ALABA jamyo si Jeova. O nae grasias si Jeova; sa güiya mauleg: sa y minaaseña gagaegueja para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Jaye siña sumangan y gaesisiñan y checho Jeova? pot mamanue todo ni y alabansaña? ");
INSERT INTO cha_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Dichoso ayo sija y umadadaje y juisio, yan ayo y fumatitinas y tininas todo y tiempo. ");
INSERT INTO cha_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Jasoyo, O Jeova, nu y finaborese ni y unnae y taotaomo; O bisitayo nu y satbasionmo; ");
INSERT INTO cha_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Para jusiña lumie y minauleg gui inayegmo, para jusiña mumagof gui minagof y nasionmo, para jusiña mumalag gui erensiamo. ");
INSERT INTO cha_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Guinin manisaojam yan y tatanmame, infatinas y tinaelaye yan inchegüe y inechong. ");
INSERT INTO cha_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Y tatanmame ti jatungo y ninamanmanmo guiya Egipto; ti jajaso y manadan y minaasemo; lao manmanembeste gui tase, junggan gui Tasen Agaga. ");
INSERT INTO cha_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Lao jasatbaja sija pot y naanña, para usiña janamatungo y dangculon y ninasiñaña. ");
INSERT INTO cha_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Jalalatde y Tasen Agaga locue yan janaanglo: lao jaesgaejon sija inanaco y todo gui tinadong, taegüije todo inanaco y desierto. ");
INSERT INTO cha_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Yan janafanlibre sija guinin y canae ayo y chumatlie sija, yan jarescata sija guinin y canae y enimigo. ");
INSERT INTO cha_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Yan y janom sija tumampe y contrarioñija: ya taya ni uno guiya sija sebla. ");
INSERT INTO cha_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Ayo nae jajonggue y sinanganña sija; jacanta y tininaña. ");
INSERT INTO cha_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Ya guse manmalefa ni y chechoña: ti janangga y pinagatña: ");
INSERT INTO cha_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Lao manmalago megae gui jalomtano, yan matienta si Yuus gui desierto. ");
INSERT INTO cha_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Ya güiya numae sija ni y guinagaoñija; lao janamanae ni y minasogsog gui jalom y anteñija. ");
INSERT INTO cha_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Ya manmanugo as Moises gui fangualuan; yan si Aaron ni y santos Jeova. ");
INSERT INTO cha_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Y tano mababa ya pinañot si Datan, yan mantinampe y mangachong Abirom. ");
INSERT INTO cha_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Yan y guafe manafañila gui mangachongñija; ya y mañila sumonggue y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Ya manmamatinas tatnero guiya Horeb, yan maadora y diniriten y imagen. ");
INSERT INTO cha_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Taegüije, jatulaeca y minalagñija para nu jechuran guaca ni y chumochocho chaguan. ");
INSERT INTO cha_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Manmalefa as Yuus ni y satbadotñija, ni y fumatinas y mandangculo na güinaja guiya Egipto; ");
INSERT INTO cha_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Mannamanman na checho gui tano Cam, yan mannamaañao na güinaja gui Tasen Agaga. ");
INSERT INTO cha_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Enao mina ilegña güiya, na uyunilang sija, yaguin ti si Moises ni y inayegña ti tumogue gui menaña gui finapetta, para ubira y binibuña para chaña yumuyulang sija. ");
INSERT INTO cha_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Magajet na jachatlie y güaeyayon na tano, ya ti jajonggue y finoña. ");
INSERT INTO cha_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Lao mangonggong gui sa tiendañíja; ya ti jaecungog y inagang Jeova. ");
INSERT INTO cha_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Enao mina jajatsa y canaeña contra sija; para uyute sija gui jalom y desierto: ");
INSERT INTO cha_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Para uyute y semiyañija locue gui nasion sija, yan para uchalapon sija gui jalom y tano sija. ");
INSERT INTO cha_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Ya mandaña sija gui Baal-peor; ya jacano y inefresen y manmatae. ");
INSERT INTO cha_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Taegüine sija mannalalalo güe nu y chechoñija: ya derepente mato gui jiloñija sija chetnot. ");
INSERT INTO cha_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Ya janatojgue julo si Finees, ya jafatinas y juisio: ya y chetnot pumara. ");
INSERT INTO cha_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Yan ayo nae jatufong iya güiya y tininas, gui todo y generasion sija para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Ya sija mannalalalo güe locue gui janom guiya Meriba: ya jumuyong daño para si Moises pot causañija. ");
INSERT INTO cha_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Sa sija chumoma y espirituña; sa jasangan sin jinaso pot labiosña. ");
INSERT INTO cha_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Ya ti jayulang y nasion sija, taegüije si Jeova ni y mantinago sija. ");
INSERT INTO cha_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Lao mandaña sija yan y nasion sija, yan jaeyag y chechoñija: ");
INSERT INTO cha_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Yan jasetbe y idolosñija: jumuyong un laso para sija. ");
INSERT INTO cha_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Magajet na jaofrese y lajeñija yan y jagañija gui anite, ");
INSERT INTO cha_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Yan jachuda y jâgâ y manaeisao, magajet na y jâgâ y lajeñija yan y jagañija ni jaofrese gui idolos guiya Cananea: yan y tano ni y ninaáplacha ni y jâgâ. ");
INSERT INTO cha_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Ya taegüije munafanáplacha pot y chechoñijaja, yan ninafanábale ni y finatinasñija. ");
INSERT INTO cha_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Enao mina y binibon Jeova sinenggue contra y taotaoña, ya jaguefchatlie y erensiañija. ");
INSERT INTO cha_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Ya janae nu sija gui canae y nasion sija; yan ayo y chumatlie sija janafanmagas gui jiloñija. ");
INSERT INTO cha_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Ya y enimigoñija locue chumiguet sija, yan sija chumule asta y jalom inesgue gui papa y canaeñija. ");
INSERT INTO cha_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Megae na biaje nae janafanlibre sija; lao sija maembeste güe ni y pinagatñija, yan manmachile papa gui tatpapa ni y tinaelayeñija. ");
INSERT INTO cha_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Lao jaatan y pinitiñija, anae jajungog y inagangñija. ");
INSERT INTO cha_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Ya jajaso para sija y tratuña, yan ninafanmañotsot según y minegae y minaaseña. ");
INSERT INTO cha_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Janafangaease locue ni ayo y cumone sija preso. ");
INSERT INTO cha_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Nafanlibrejam, O Jeova, Yuusmame, yan nafandañajam gui entalo y nasion sija, para unae grasias y santos na naanmo, yan ufangana gui alabansamo. ");
INSERT INTO cha_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Bendito si Jeova ni Yuus Israel guinin y taejinecog para y taejinecog. Polo ya todo taotao ilegñija. Amen. Alaba jamyo si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","O nae grasias si Jeova, sa güiya mauleg: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Polo y ninafanlibre as Jeova ya ujasangan, anae janafanlibre guinin y canae y contrario; ");
INSERT INTO cha_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Yan janafandaña sija juyong gui tano sija, guinin y sancatan, yan guinin y sanlichan, guinin y san lago, yan guinin y san jaya. ");
INSERT INTO cha_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Manaabag gui jalomtano gui chalan desierto; ya ti manmañoda siuda para ufañaga. ");
INSERT INTO cha_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Manñalang yan minajo sija, y anteñija manlalango gui sanjalomñija. ");
INSERT INTO cha_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Ayo nae maagang si Jeova gui chinatsagañija, ya güiya munalibre sija gui pinadeseñija. ");
INSERT INTO cha_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Ya maninesgaejon sija mona, gui tinas na chalan, para usiña manjanao para y siuda anae mañasaga. ");
INSERT INTO cha_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","O, para y taotao sija mojon ufanmanalaba si Jeova pot y minaulegña, yan pot y ninamanman na chechoña gui famaguon taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Sa jananajong y malago na ante, yan janabula y ñalang na ante ni y minauleg. ");
INSERT INTO cha_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Ayo sija y manmatatachong gui jemjom yan y jalom y anineng y finatae, ni y guinin jagode nu y pinite yan lulog; ");
INSERT INTO cha_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Sa manembeste contra y fino Yuus, yan jachatlie y pinagat y Gueftaquilo: ");
INSERT INTO cha_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Enao mina jachule papa y corasonñija gui checho; manbasnag papa ya taya para ufaninayuda. ");
INSERT INTO cha_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Ayo nae maagang si Jeova gui chinatsagañija, ya güiya munalibre sija gui pinadeseñija. ");
INSERT INTO cha_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Jachule sija juyong gui jemjom yan y anineng y finatae, yan jagutos y manmagodeñija. ");
INSERT INTO cha_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","O para y taotao sija mojon ufanmanalaba si Jeova pot y minaulegña, yan pot y ninamanman na chechoña gui famaguon y taotao sija! ");
INSERT INTO cha_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Sa güiya yumamag y trangcan bronse, yan janapedaso y rejas lulog. ");
INSERT INTO cha_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Mangaduco, sa pot y tinaelayeñija yan pot y inechongñija fanmanmamadese. ");
INSERT INTO cha_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Y anteñija jachatlie todo y clasen nengcano; yan manjijot gui trangcan y finatae. ");
INSERT INTO cha_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Ya maagang si Jeova gui chinatsagañija ya güiya munalibre sija gui pinadeseñija. ");
INSERT INTO cha_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Manninae y finoña ya manninajomlo sija, yan manninalibre sija guinin y yinilangñija. ");
INSERT INTO cha_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","O para y taotao sija mojon ufanmanalaba si Jeova pot y minaulegña, yan pot y ninamanman na chechoña gui fumaguon y taotao sija! ");
INSERT INTO cha_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Ya polo sija ya ujaofrese y inefresen grasias sija, yan jasangan claro y chechoña gui cantan minagof. ");
INSERT INTO cha_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Sija ni manjanao papa gui tase gui jalom y batco, ni y fumatinas chechoñija gui jilo manadan janom sija; ");
INSERT INTO cha_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Estesija lumie y checho Jeova, yan y ninamanmanña gui jalom y tinadong. ");
INSERT INTO cha_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Sa jatagoña, ya janacajulo y pagyon manglo, ni y jumatsa julo y napo sija. ");
INSERT INTO cha_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Mangajulo para y langet, manjanao talo papa para y tinadong: y anteñija manmaderite pot y chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Manmatulaejon mona an tate, yan manmamangag taegüije y bulacho na taotao, yan manmalingo y jinasoñija. ");
INSERT INTO cha_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Ya maagang si Jeova gui chinatsagañija, ya güiya munalibre sija gui pinadeseñija. ");
INSERT INTO cha_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Janabasta y pagyo, yan y napo sija manmamatquilo. ");
INSERT INTO cha_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Ayo nae manmagof sa mangieto, ya taegüije jacone sija asta y minalagoñija na puetto. ");
INSERT INTO cha_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","O para y taotao sija mojon ufanmanalaba si Jeova pot y minaulegña, yan pot y ninamanman na checoña gui famaguon y taotao sija! ");
INSERT INTO cha_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Polo ya sija umanacajulo güe locue gui y inetnon y taotao yan ufanmanalaba nu güiya gui tachong y manamco. ");
INSERT INTO cha_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Jafasadog y desierto, yan jafaanglo na oda y tutujon janom; ");
INSERT INTO cha_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Jafadesierton asiga y mauleg na tano, pot y tinaelayen ayo sija y mañasaga gui sanjalom. ");
INSERT INTO cha_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Jafajagoen janom y desierto, yan janafamimichao y janom y anglo na oda. ");
INSERT INTO cha_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Yan ayo na janafañaga y manñalang, ya sija siña jafamauleg y siuda para ufañaga; ");
INSERT INTO cha_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Yan matanme y fangualuan, yan manmananom gui fangualuan ubas, ya ufanmarecoge y tinegchan y aumento. ");
INSERT INTO cha_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Jabendise sija locue, para ufangosmegae; yan ti upolo y gañija gâgâ na udidide. ");
INSERT INTO cha_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Tumalo sija mandidide yan mannecon papa, pot y chiniguet, chinatsaga, yan triniste. ");
INSERT INTO cha_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Jachuda sinala gui jilo y prinsepe sija, yan janafanabag sija gui jalomtano anae taya chalan. ");
INSERT INTO cha_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Lao japolo y mannesesitao julo guinin y pinadese, yan mandaña gui familia sija taegüije y inetnon quinilo. ");
INSERT INTO cha_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Y manunas ujalie ayo yan ufanmagof; yan todo y tinaelaye ujinichom y pachotña. ");
INSERT INTO cha_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Masquesea jaye na manmalate, ujaadaje este sija na güinaja; ya sija ujajaso y minaase gui as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","O Yuus, y corasonjo esta meton; bae jucanta, magajetja na jucanta alabansa sija yan todo y minalagjo. ");
INSERT INTO cha_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Fatmata guitala, yan atpa: guajoja na maesa magmatayo taftaf. ");
INSERT INTO cha_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Bae junae jao grasias, Jeova gui entalo y taotao sija: yan jucantaye alabansa, sija gui entalo y nasion sija. ");
INSERT INTO cha_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Sa y dangculon y minaasemo gui san jilo y langet: yan y minagajetmo tinacaja y mapagajes sija. ");
INSERT INTO cha_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Nadangculojao, O Yuus, gui jilo y langet: yan y minalagomo gui san jilo todo y tano. ");
INSERT INTO cha_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Para usiña ayo y güinaeyamo manlibre ni y agapa na canaemo, yan opejam. ");
INSERT INTO cha_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Si Yuus ilegña gui sinantosña: Guajo jumagof, guajo jupatte Siquem, yan jumide juyong y bayen Sucot. ");
INSERT INTO cha_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Yyoco Gilaad; iyoco Manases: Efrain locue y minetgot y ilujo; Juda y bastonjo; ");
INSERT INTO cha_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moab y palanganajo anae jufagase adeng sija: y jilo Edom nae juyute y sapatoso: y jilo Filistia nae juagang. ");
INSERT INTO cha_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Jaye uconeyo asta y jalom y fitme na siuda? Jaye uinesgaejonyo asta y jalom Idumea? ");
INSERT INTO cha_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Ti jago, O Yuus, ni y yumute jam? yan jago, O Yuus, ti jumanao yan y inetnon sendalonmame. ");
INSERT INTO cha_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Naejam linibre gui chinatsaga: sa taesetbe y inayudan y taotao. ");
INSERT INTO cha_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","As Yuus nae utafanmatatnga: sa güiyaja uguinacha papa y enimiguta. ");
INSERT INTO cha_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","CHAMO famatquiquilo, O Yuus, gui alabansajo; ");
INSERT INTO cha_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Sa y pachot y manaelaye yan y pachot y dinague manmababa contra guajo: sa manguecuentos contra guajo yan y mandacon na jula. ");
INSERT INTO cha_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Sija umoriyayayeyo locue ni y finijo chinatlie; yan manmumo contra guajo sin jafa. ");
INSERT INTO cha_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Sa y apas y güinaeyaco, sija contrariujo: lao guajo siempre manayuyutyo. ");
INSERT INTO cha_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Yan sija jaapaseyo taelaye pot mauleg, yan chinatlie pot y guinaeyaco. ");
INSERT INTO cha_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Polo jao y taelaye na taotao guiya güiya: ya polo un contrario ya utojgue gui agapa na canaeña. ");
INSERT INTO cha_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Yaguin majusga güe, polo ya umasentensia: yan y tinaetaeña ufamaisao. ");
INSERT INTO cha_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Ya y jaaniña udidide: yan otro uchinile ofisioña. ");
INSERT INTO cha_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Y famaguonña ufanaetata yan y asaguaña ubiuda. ");
INSERT INTO cha_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Polo ya y famaguonña ufanlaong yan ufanmangagao: ya polo sija ya umaliligao y nañija güije gui chago gui sagañija na mayulang. ");
INSERT INTO cha_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Polo ya umaamot ya unnachule todo y güinajaña, yan y taotao juyong chumoleguan ni y finachochoña. ");
INSERT INTO cha_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Polo ya taya ni jaye umaase ni güiya; yan ni uno ufinaborese y manaetata na famaguonña. ");
INSERT INTO cha_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Polo ya y famaguonña ufanmautut; yan gui generasion ni y jadalalalag, umafagasñaejon y naanñija. ");
INSERT INTO cha_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Poly ya y tinaelayen y tataña sija umajaso gui as Jeova: ya y isao nanaña ti umafagasñaejon. ");
INSERT INTO cha_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Polo ya sija siempre ufangaegue gui menan Jeova, sa güiya siña umutut y jinasoñija guinin y tano. ");
INSERT INTO cha_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Sa ti jajaso mamanue minaase, lao japetsigue y peble yan y nesesitao na taotao, yan y mayulang na corason ujapuno sija. ");
INSERT INTO cha_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Magajet na jaguaeya y matdision, ya ayo na mato guiya güiya; ya ti ninamagof ni y bendision, ya ayo na chago guiya güiya. ");
INSERT INTO cha_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Ya güiya mumagago güe ni y matdision taegüije y bestiduña, ya ayo na jumalom gui jalom y tiyanña taegüije y janom, yan taegüije y laña gui jalom tolangña. ");
INSERT INTO cha_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Polo ya ayo guiya güiya, taegüije y magago ni y jatatampegüe, yan para sinturon ni y jadudog güe siempre. ");
INSERT INTO cha_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Ya este apas y contrariujo sija guinin as Jeova, yan ayo sija ni y manguecuentos taelaye contra y antijo. ");
INSERT INTO cha_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Lao fatinas para guajo, O Yuus Jeova, pot y naanmo: sa mauleg na minaasemo, enao mina nalibreyo. ");
INSERT INTO cha_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Sa pobleyo, yan nesesitaoyo, yan y corasonjo mañetnot gui sanjalomjo. ");
INSERT INTO cha_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Mapos yo taegüije y anineng yaguin malofan: matafye yo julo yan papa taegüije y apacha. ");
INSERT INTO cha_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Y timoco mandafe pot y inayunat; yan y catneco manmasogsog, sa ti jataca y iinemog. ");
INSERT INTO cha_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Jumuyong yo locue taegüije linalatde guiya sija: anae maaatanyo jayeyengyong y iloñija. ");
INSERT INTO cha_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Ayudayo, O Jeova Yuusso; O satbayo segun y minaasemo: ");
INSERT INTO cha_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Para sija ujatungo na este y canaemo: na jago, Jeova, fumatinas este. ");
INSERT INTO cha_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Polo ya sija manmamatdise, lao jago manbendise: yaguin sija mangajulo, ufanmamajlao; lao y tentagomo umagof. ");
INSERT INTO cha_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Ya y contrariojo ufanminagago ni y desonra; yan ufantinampe sija ni y minamajlaoñija taegüije y capa. ");
INSERT INTO cha_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Jeova bae junae sendangculo na grasias nu y pachotto; junggan, jualabagüe gui linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Sa güiya utojgüe gui agapa na canae y nesesitao, para usinatba güe guinin ayo sija y jumusga y antiña. ");
INSERT INTO cha_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","SI Jeova ilegña ni y señotto, fatachong gui agapa na canaejo, asta qui jupolo y enimigo para fañajangan adengmo. ");
INSERT INTO cha_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Si Jeova uninamannae y baran minetgotmo guinin Sion: gobietna gui entalo y enimigumo sija. ");
INSERT INTO cha_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Y taotaomo ufanmalago na ufanmanofrese nu sija gui jaanen y ninasiñamo: gui guinatbon sija y sinantos, guinin y tiyan y agaan, ungae serenon y pinatgonmo. ");
INSERT INTO cha_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Si Jeova manjula ya timañotsot, jago y pale para taejinecog segun y otden Melquisedec. ");
INSERT INTO cha_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Si Jeova, gui agapa na canaemo, upanag todo y ray sija gui jaanin y binibuña. ");
INSERT INTO cha_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Güiya ufanjusga gui entalo y nasion sija, janabula y sagayan sija ni y tataotao y manmatae; unamagomgom y ilo gui jilo y megae na tano sija. ");
INSERT INTO cha_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Unaguimen y sadog gui chalan: enaomina güiya jumatsa julo y ilo. ");
INSERT INTO cha_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","FANMANALABA jamyo as Jeova. Guajo junae si Jeova grasias contodo y corasonjo, gui jalom y pinagat manunas, yan y jalom y inetnon taotao. ");
INSERT INTO cha_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Y checho Jeova mansendangculo, ya maaliligao ni ayo sija todo y ninafanmamagof nu estesija. ");
INSERT INTO cha_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Y chechoña y onra yan minagas: yan y tininasña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Jafatinas y mannamanman na chechoña para umajajaso: si Jeova cariñoso yan bula ni y minaase. ");
INSERT INTO cha_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Güiya guinin munae nengcano ayo sija y manmaañao nu güiya: ya güiya siempre jajasoja tratuña. ");
INSERT INTO cha_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Jagasja jafanue y taotaoña ni y ninasiñan y chechoña, anae janae sija ni y erensian y nasion sija. ");
INSERT INTO cha_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Y checho sija y canaeña y minagajet yan juisio; ya todo y sinanganña sija manseguro. ");
INSERT INTO cha_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Manfitme sija para taejinecog yan taejinecog, yan mamafatinas gui minagajet yan y tininas. ");
INSERT INTO cha_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Janamannae y linibre para y taotaoña; ya jatago y tratuña para taejinecog: sinantos yan inenra y naanña. ");
INSERT INTO cha_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Y minaañao as Jeova y tutujon y minalate y mauleg na tiningo mangaegue güije todo gui fumatitinas y tinagoña: y alabansaña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","FANMANALABA jamyo as Jeova. Dichoso y taotao ni maañao as Jeova, yan ninasendangculo y minagofña ni y tinagoña sija. ");
INSERT INTO cha_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Ya y semiyaña manmatatnga gui jilo y tano: ya y generasion manunas ufandichoso. ");
INSERT INTO cha_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Güinaja yan rinico mangaegue gui guimaña: ya y tininasña gagaegueja para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Ya y manunas nae cajulo y manana gui jalom jomjom: güiya cariñoso güe yan bula minaase, yan tunasgüe. ");
INSERT INTO cha_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Y mauleg para ayo na taotao ni y fumatitinas y cariño, yan numanaayao: güiya umantiene y causaña gui juisio. ");
INSERT INTO cha_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Sa güiya ti umanacalamten para taejinecog: y manunas para taejinecog: ufanmajajasoja. ");
INSERT INTO cha_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Güiya ti umaañao ni y manaelaye na notisia sija: y corasonña meton ya jaangoco si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Y corasonña fitme ya güiya ti umaañao, asta qui jalie y diniseaña gui jilo y contrariuña sija. ");
INSERT INTO cha_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Guiya tumalapon, güiya numae ni y mamoble; ya y tininasña gagaegue para taejinecog, y canggelonña umajatsa ni y inenra. ");
INSERT INTO cha_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Y taelaye na taotao jalie ayo yan ninapinite: yan janachechegcheg y nifenña, yan maderite ya mapos: ya y diniseaña y taelaye umalingo. ");
INSERT INTO cha_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","FANMANALABA jamyo as Jeova. Fanmanalaba, O tentago Jeova sija. Fanmanalaba y naan Jeova. ");
INSERT INTO cha_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Bendito y naan Jeova, desde este na tiempo yan para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Desde y quinajulo y atdao asta y minachomña papa, y naan Jeova para umaalaba. ");
INSERT INTO cha_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Si Jeova gueftaquilo gui jilo todo y nasion yan y minalagña gui jilo y langet sija. ");
INSERT INTO cha_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Jaye parejuña si Jeova ni y Yuusta, ni y japolo y tachongña gui sanjilo. ");
INSERT INTO cha_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Ni y muna umitde güe para uatan y güinaja sija ni y mangaegue gui langet yan y tano. ");
INSERT INTO cha_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Güiya jumatsa julo y mamoble gui petbos, yan jajatsa y mananesitao gui monton estietcot. ");
INSERT INTO cha_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Para unafanmatachong yan y prinsepe sija magajet, yan y prinsepen y taotaoña sija. ");
INSERT INTO cha_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Ya janafamulan guma y ti fafañago na palaoan, ya jumuyong gofmagof na nanan famaguon. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","ANAE si Israel jumanao juyong Egipto, y guima Jacob guinin y taotao y finijo na ti matungo. ");
INSERT INTO cha_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Juda jumuyong y santos na sagaña, yan Israel y gobietnoña. ");
INSERT INTO cha_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Y tase jalie ayo, yan malago; Jordan masugon tate. ");
INSERT INTO cha_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Y beca sija manayog taegüije y quinilo laje yan y mandiquique ogso sija taegüije y manpatgon na quinilo sija. ");
INSERT INTO cha_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Jafa guaja guiya jago, O tase, na malagojao? Jago Jordan ni y masugon tate? ");
INSERT INTO cha_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Jamyo ni y beca sija ni y manayog taegüije y quinilo laje; yan jamyo di quique na ogso sija taegüije y manpatgon na quinilo sija? ");
INSERT INTO cha_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Mayeyengyong, jago tano, gui menan Jeova, gui menan y Yuus Jacob; ");
INSERT INTO cha_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Ni y jafaacho y jagoe janom, ya jafagagot y tutujon janom sija. ");
INSERT INTO cha_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","AJE ti iyajame, O Jeova, aje ti iyajame, lao iya naanmo, nae uminalag pot y minaasemo, yan pot y minagajetmo. ");
INSERT INTO cha_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Pot jafa mojon y nasion ilegñija: Mangue pago y Yuusñija? ");
INSERT INTO cha_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Lao si Yuusmame gaegue gui langet: guinin jafatinas jafaja y minalagoña. ");
INSERT INTO cha_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Y idolosñija sija salape yan oro, finatinas y canae y taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Guaja pachotñija lao ti manguecuentos: guaja atadogñija lao ti manmanlilie; ");
INSERT INTO cha_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Guaja talangañija lao ti manmanjujungog: guaja güiengñija lao ti manmannginginge: ");
INSERT INTO cha_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Guaja canaeñija lao ti manmangogote: guaja adengñija lao ti manmamomocat: ni ufanguentos ni y güetgüeroñija. ");
INSERT INTO cha_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Ya ayo y fumatinas sija manparejoja yan sija: magajet na jayeja y umangoco güe guiya sija, ");
INSERT INTO cha_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","O Israel, angoco si Jeova: sa güiya y ayudañija yan y patangñija. ");
INSERT INTO cha_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","O guma Aaron, angoco si Jeova: sa güiya y ayudañija yan y patangñija. ");
INSERT INTO cha_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Jamyo ni y manmaañao as Jeova, angoco si Jeova: sa güiya y ayudañija yan y patangñija. ");
INSERT INTO cha_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Si Jeova guinin jajaso jita: guiya bumendisijit; güiya bumendise y guima Israel; güiya bumendise y guima Aaron. ");
INSERT INTO cha_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Güiya bumendise ayo sija y manmaañao as Jeova, todo y mandiquique yan y mandangculo. ");
INSERT INTO cha_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Si Jeova unninamegae mas yan mas, jago yan y famaguonñija. ");
INSERT INTO cha_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Jamyo manbinendise as Jeova ni y fumatinas y langet yan y tano. ");
INSERT INTO cha_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Y langet sija ni y langet Jeova sija: lao y tano mannae para y famaguon y taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Y manmatae ti manmanalaba as Jeova, ni jaye güije gui manjajanao papa gui jalom y manmamatquiquiloja. ");
INSERT INTO cha_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Lao jita, tabendise si Jeova, desde pago na tiempo mona yan para taejinecog. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","JUGUAEYA si Jeova sa jajungog y inagangjo yan y tinayuyutto sija. ");
INSERT INTO cha_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Sa janaegueng y talangaña guiya guajo, enao mina na juaagangja güe mientras lâlâlâyo. ");
INSERT INTO cha_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Y cuetdas y finatae umoriyayeyo, yan y piniten y naftan sumoda yo: ya jusoda chinatsaga yan triniste. ");
INSERT INTO cha_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Ayo nae juagang y naan Jeova; O Jeova, jugagagaojao, nalibre y antijo. ");
INSERT INTO cha_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Guaeyayon si Jeova yan tunas; junggan, y Yuusta senyoase. ");
INSERT INTO cha_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Si Jeova jaadadaje y taeisao: guajo estaba macone tagpapa, yan güiya sumatbayo. ");
INSERT INTO cha_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Talo guato gui descansomo, O antijo; sa si Jeova uchalapon megae guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Sa unalibre y antijo guinin y finatae, y atadogco guinen y lagosija, yan y adengjo guinin y pinedong. ");
INSERT INTO cha_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Bae jufamocat gui menan Jeova gui tano y manlalala. ");
INSERT INTO cha_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Jujojonggue, enao mina jusangan sa estaba gosdangculo y pinitijo. ");
INSERT INTO cha_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Yleco gui chinadigco, todo y taotao sija mandacon. ");
INSERT INTO cha_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Jafa juapase si Jeova pot todo y minaulegña guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Bae juchule y copan satbasion, yan juagang y naan Jeova. ");
INSERT INTO cha_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Bae juapase y promesajo as Jeova, pago gui menan todo y taotaoña sija. ");
INSERT INTO cha_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Guaelaye gui linie Jeova, y finatae y mañantosña. ");
INSERT INTO cha_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","O Jeova, magajet na guajo tentagomo; guajo y tentagomo, yan y lajin y tentagomo palaoan: jago pumula y magodeco. ");
INSERT INTO cha_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Bae juofrese jao ni y inefresen grasias, yan juaagang y naan Jeova. ");
INSERT INTO cha_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Bae juapase y promesajo as Jeova, pago gui menan todo y taotaoña sija. ");
INSERT INTO cha_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Gui jalom y páteo y guima Jeova, gui talo guiya jago, O Jerusalem. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","O fanmanalaba as Jeova, jamyo todo y nasion sija: fanmanalaba nu güiya jamyo todo y taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Sa y minaaseña dangculo guiya jita; yan y minagajet Jeova gagaegue para taejinecog. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","O nae gracias si Jeova; sa güiya mauleg: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Polo ya si Israel ilegña pago, na y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Polo ya y guima Aaron ilegña pago, na y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Polo ya ayo sija y manmaañao pago as Jeova ilegñija, na minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Juagang si Jeova gui chinatsagaco: ya si Jeova umopeyo, yan japoloyo güi dangculo na sagayan. ");
INSERT INTO cha_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Si Jeova para guajo; ya ti jumaañao: jafa siña y taotao ufatinas guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Si Jeova para guajo gui entalo güije sija y umayuyudayo: enao mina julie y dineseajo güije sija ni y chumatliiyo. ");
INSERT INTO cha_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Mas mauleg umaangoco si Jeova qui umapolo y inangoco gui taotao. ");
INSERT INTO cha_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Mas mauleg umaangoco si Jeova qui umapolo y inangoco y prinsipe sija. ");
INSERT INTO cha_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Todo y nasion umoriyayeyo: lao pot y naan Jeova juutut sija. ");
INSERT INTO cha_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Sija umoriyayeyo; junggan, sija umoriyayeyo: lao pot y naan Jeova juutut sija. ");
INSERT INTO cha_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Sija umoriyayeyo taegüije y obeja sija; sija manmapuno taegüije y guafen tituca: pot y naan Jeova na juutut sija. ");
INSERT INTO cha_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Jago chumonegyo para jupodongyo, lao si Jeova umayudayo. ");
INSERT INTO cha_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Si Jeova y minetgotto yan y cantaco, yan güiya jumuyong y satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Y inagang y minagof yan y satbasion gaegue gui jalom y tiendan y manunas: y agapa na canae Jeova fumatitinas y minatatnga. ");
INSERT INTO cha_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Y agapa na canae Jeova majatsa julo; y agapa na canae Jeova fumatitinas y minatatnga. ");
INSERT INTO cha_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ti jumatae, lao bae julâlâ, yan jusangan claro y checho Jeova sija. ");
INSERT INTO cha_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Si Jeova jacastigayo megae: lao ti janaeyo guato gui finatae. ");
INSERT INTO cha_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Babayeyo ni y trangcan tininas sija: ya bae jujalom guiya sija, bae junae grasias si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Este na trangcan Jeova; anae, manjajalom y manunas. ");
INSERT INTO cha_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Guajo junae jao grasias: sa jago jagasja umopeyo, yan jago jumuyong y satbasionjo. ");
INSERT INTO cha_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Y acho ni y marechasa ni y manmanjajatsa y guima, jumuyong mumagas na acho gui esquina. ");
INSERT INTO cha_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Este si Jeova chechoña; ya namanman gui atadogta. ");
INSERT INTO cha_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Este na jaane si Jeova fumatinas; tafanmagof yan tafansenmagof ni ayo. ");
INSERT INTO cha_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Satba pago, jugagagaojao, O Jeova: O Jeova, jugagagaojao, pago namannae minegae. ");
INSERT INTO cha_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Dichoso ayo y mamamaela gui naan Jeova; inbendisijao guinin y guima Jeova. ");
INSERT INTO cha_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yuus si Jeova, guinin fumanuejit ny y inina: funot y inefresen ni y cuetdas asta gui canggelon y attat. ");
INSERT INTO cha_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Jago y Yuusso, yan bae junaejao grasias: jago y Yuusso, bae jujatsajao julo. ");
INSERT INTO cha_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","O nae grasias si Jeova; sa güiya mauleg: sa y minaaseña gagaegueja para taejinecog. Amen. ");
INSERT INTO cha_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","ALEPH MANDICHOSO ayo sija y mangabales gui chalan ni y manmamomocat segun y lay Jeova. ");
INSERT INTO cha_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Mandichoso ayo sija y umadadaje y testimonioña, yan y umaliligao güe contodo y corasonñija. ");
INSERT INTO cha_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Magajet na sija ti manmatitinas jafa ni ti tunas; sija manjajanao gui jinanaoña sija. ");
INSERT INTO cha_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Guinin untagojamja ni y finanagüemo para inguesadaje sija. ");
INSERT INTO cha_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","O mojon ya ufitme y jinanaojo sija, para juadaje y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Ya ayonae ti jumamajlao, yanguin esta jurespeta todo y tinagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Bae junaejao grasias, yan y tininas y corason, yanguin jueyag y tinas na juisiomo. ");
INSERT INTO cha_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Bae juadaje y laymo; chamoyo sumesendingo. ");
INSERT INTO cha_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","BETH Pot jafa y patgon na laje nae unagasgas y jinanaoña? Yanguin jaguesadaje jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Jagasja jualiligaojao contodo y corasonjo; chamoyo munaabag gui tinagomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Y sinanganmo junaatog gui jalom y corasonjo, para chajo umiisao contra jago. ");
INSERT INTO cha_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Dichosojao O Jeova; fanagüeyo ni y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Contodo y labiosso jagasja jusangan claro todo y juisio sija y pachotmo. ");
INSERT INTO cha_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Jagasja magofyo gui chalan y testimoniomo; taegüije magofyo gui todo y güinaja sija. ");
INSERT INTO cha_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Bae jujaso y finanagüemo, ya jurespeta y jinanaomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Bae jumagofyo ni y laymo sija: ti jumalefa ni y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","GIMEL Guefayuda y tentagomo, para julâlâ; ayonae juadaje y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Baba y atadogco, ya julie y mannamanman sija gui tinagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Guajo taotao juyongyo gui tano: chamo naaatog y tinagomo sija guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Y antijo mayamag pot y minalagoña ni y guaja gui juisiomo sija todo y tiempo. ");
INSERT INTO cha_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Unlalatde y sobetbio sija ni y manmatdito, ni y manabag gui tinagomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Nafañuja guiya guajo y minamajlao, yan y dinespresia; sa jagasja juadaje y testimoniomo. ");
INSERT INTO cha_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Y prinsipe sija locue manmatachong yan manguecuentos contra guajo: lao y tentagomo jajajasoja y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Y testimoniomo y minagofjo sija yan y taotaojo na pápagat sija. ");
INSERT INTO cha_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","DALETH Y antijo mafachet yan y petbos: nalâlâyo jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Jusangan claro y jinanaojo sija, ya unopeyo: fanagüeyo ni y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Natungoyo ni y chalan y finanagüemo sija; ayo nae jusangan y namanman y chechomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Y antijo maderite sa macat; nametgotyo jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Nasuja guiya guajo y chalan mandacon; ya naeyo, pot y grasiasmo, y tinagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Jagasja juayeg y chalan y minagajet: y juisiomo jagasja jupolo gui menajo. ");
INSERT INTO cha_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Jusisigue y testimoniomo sija: O Jeova, chamo namamamajlaoyo. ");
INSERT INTO cha_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Bae jufalalagüe y chalan tinagomo sija, yanguin unnadangculo y corasonjo. ");
INSERT INTO cha_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","HE Fanagüeyo, O Jeova, ni y chalan y laymo sija; ya juadaje asta y uttimo. ");
INSERT INTO cha_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Naeyo tiningo, ya bae juadaje y laymo: junggan bae juadaje contodo y corasonjo. ");
INSERT INTO cha_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Nafalofanyo gui chalan y tinagomo, sa ayoyo nae mamagof. ");
INSERT INTO cha_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Namangag guato y corasonjo gui testimoniomo, ya munga gui linatga. ");
INSERT INTO cha_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Bira y atadogco ni guinin manlilie banida; ya nalâtâyo gui jinanaomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Nafitme y sinanganmo gui tentagomo, ni y deboto nu jago. ");
INSERT INTO cha_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Bira y minamajlaojo ni y janamaaañaoyo; sa y juisiomo sija manmauleg. ");
INSERT INTO cha_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Liija na minajalangyo ni y finanagüemo sija: nalâlâyo gui tininasmo. ");
INSERT INTO cha_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","VAU Namamaela locue y minaasemo guiya guajo, O Jeova, asta y satbasionmo jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Ayo nae uguaja para juope y munamamamajlaoyo; sa juangocoyo ni y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Ya chamo todo chumuchule gui pachotto y sinangan y minagajetmo; sa jagasja junangga y juisiomo. ");
INSERT INTO cha_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Ayo nae juadaje y laymo todo y tiempo, para taejinecog yan taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Ya julibre jumanao; sa jagasja jualigao y finanagüemo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Ya bae jusangan locue y testimoniomo sija gui menan y ray sija, ya ti jumamajlao. ");
INSERT INTO cha_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Ya bae jumagofyo gui tinagomo sija, ni y juguaeya. ");
INSERT INTO cha_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Bae jujatsa julo locue y canaejo sija gui tinagomo sija, ni y juguaeya; ya bae jujaso y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","ZAIN Jaso y sinangan gui tentagomo, ni y unfatinasyo na junangga. ");
INSERT INTO cha_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Este munamamagofyo gui trinisteco; sa y sinanganmo jagasja munalâlâyo. ");
INSERT INTO cha_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Gogosmachatgüeyo ni y mansobetbio: lao trabia ti juabag guinin y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Jagasja jujajaso y juisiomo sija ni y guinin ampmam na tiempo, O Jeova, ya jagasja juconseulan maesayo. ");
INSERT INTO cha_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Jaguotyo y maepe na binibo, sa pot y manaelaye ni y madingo y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Y lay sija cantaco sija gui guima anae taotao tumanoyo. ");
INSERT INTO cha_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Jagasja jujajaso y naanmo, O Jeova qui puenge, ya juadadajeja y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Este guajayo, sa juadaje y finanagüemo. ");
INSERT INTO cha_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","CHETH Si Jeova y patteco guinin jusangan na juadaje y sinanganmo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Jugagao y finaboresemo contodo y corasonjo: magaease nu guajo jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Jujaso gui jinanaojo sija, ya jubira y adengjo guato gui testimoniomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Inalululayo, ya ti sumagayo, para juadaje y tinagomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Y cuetdas manaelaye jafunutyo; lao ti malefayo ni y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Bae jucajulo gui tatalopuenge, ya junaejao grasias, sa pot y tinas na juisiomo. ");
INSERT INTO cha_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Guajo gachong ayo sija y manmaañao nu jago, yan ayo sija y umadadaje y finanagüemo. ");
INSERT INTO cha_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Y tano, O Jeova, bula ni y minaasemo: fanagüeyo ni y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","TETH Mauleg finatinasmo ni y tentagomo, O Jeova, jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Fanagüeyo mauleg na juisio yan tiningo: sa jagasja jujonggue y tinagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Antes di jutriste, umabagyo; lao pago juadaje y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Jago maulegjao, ya unfatinas mauleg; fanagüeyo ni y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Y sobetbio jafatinas un dinague contra guajo: bae juadadajeja y finanagüemo sija contodo y corasonjo. ");
INSERT INTO cha_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Y corasonñija, manmantica calang sebo: lao jumagofyo ni y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Mauleg para guajo, na guinin ninatristeyo; para jueyag y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Y lay y pachotmo, maulegña para guajo, qui ni mit na oro yan salape. ");
INSERT INTO cha_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","JOD Y canaemo sija fumatinasyo yan fumajechurayo; naeyo tiningo, para jueyag y tinagomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Ayo sija y manmaañao nu jago ujalieyo ya ufanmagof; sa jagasja junangga y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","O Jeova, jutungoja na y juisiomo tunas, yan pot y minagajetmo na unnatristeyo. ");
INSERT INTO cha_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Polo jutayuyutjao ya y minauleg y minaasemo unamagofyo, jaftaemano y sinanganmo gui tentagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Polo ya ufato guiya guajo y cariñoso na minaasemo sija, para ulâlâyo; sa y tinagomo y minagofjo. ");
INSERT INTO cha_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Polo ya manmamajlao y mansobetbio; sa manapodong yo nu y dinague: lao jujajasoja y finanagüe sija. ");
INSERT INTO cha_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Polo ya umabira iyaguajo ayo sija y manmaañao nu jago, yan sija ujatungo y testimonio sija. ");
INSERT INTO cha_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Polo ya fitme y corasonjo gui laymo, ya chajo mamamajlao. ");
INSERT INTO cha_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","CAPH Y antijo lalango pot y satbasionmo, lao junananggaja y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Y atadogco ninalachae pot y sinanganmo mientras ileleco: Ngaean nae unconsuelayo. ");
INSERT INTO cha_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Sa jumuyongyo calang y boteya gui jalom aso; lao trabia ti malelefayo ni y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Cuanto sija y jaanen y tentagomo? Asta ngaean nae unjusga ayo sija y pumetsisigueyo? ");
INSERT INTO cha_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Y mansobetbio manmanguadog joyo para guajo, ni y ti taegüije laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Todo y tinagomo sija manunas: ayudayo sa sija mapetsisigueyo ni y dinague. ");
INSERT INTO cha_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Canaja malalachaeyo gui jilo y tano; lao ti judingo y finanagüemo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Nalâlâyo pot y cariñoso na güinaeyamo, ayo nae juadaje y testimonion pachotmo. ");
INSERT INTO cha_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","LAMED O Jeova, para taejinecog y sinanganmo fitme gui langet. ");
INSERT INTO cha_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Y minagajetmo gagaegue asta todo y generasion sija; jago plumanta y tano ya sumaga. ");
INSERT INTO cha_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Sija jasisigueja asta pago na jaane jaftaemano y otdenmo; sa todos sija tentagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Yaguin ti jagas janamagofyo y laymo, jagas malingo ni y trinisteco. ");
INSERT INTO cha_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Ti jumalefa ni y finanagüemo sija para taejinecog: sa pot sija na unnalâlâyo. ");
INSERT INTO cha_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Guajo iyomoyo, satbayo; sa jualiligao y finanagüemo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Y manaelaye manananggayo para umayulang; lao jugueguesjasoja y testimoniomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Guinin julie y uttimon y todo quinabales; ya y tinagomo gosfeda. ");
INSERT INTO cha_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","MEM O jafa muna juguaeyo y tinagomo! esteja jinasosoco todot dia. ");
INSERT INTO cha_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Y tinagomo janafanungoñayo qui enemigujo sija; sa sija siempre infanjajameja. ");
INSERT INTO cha_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Megaeña tiningojo qui todo y maestronomo sija: sa y testimoniomo sija, y jinasojo. ");
INSERT INTO cha_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Manungoñayo qui y manbijo; sa juadadaje y finanagüemo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Junapara y adengjo guato gui todo chalan tinaelaye, para juadaje y sinangan. ");
INSERT INTO cha_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Ti jubirayo gui juisiomo: sa jagasja unfanagüeyo. ");
INSERT INTO cha_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Na minames y sinanganmo ni y chinaguijo, junggan mamesña qui y miet para y pachotto. ");
INSERT INTO cha_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Guinin y finanagüemo sija nae mañuleyo tiningo: enaomina juchatlie todo y chalan mandacon. ");
INSERT INTO cha_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","NUN Y sinanganmo y candet para y adengjo, yan manana gui chalanjo. ");
INSERT INTO cha_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Manjulayo ya junafitme na juadaje y tinas na juisiomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Gospiniteyo; nalâlâyo, O Jeova, jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","O Jeova, jutatayuyut jao: chajlao y libren y inefresen pachotto sija, ya fanagüeyo ni y juisiomo. ");
INSERT INTO cha_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Antijo siempre gaegue güi canaejo; lao ti malelefayo ni y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Y manaelaye maplantayeyo laso; lao ti sumujayo gui finanagüemo. ");
INSERT INTO cha_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Juchule erensiaco para siempre y testimoniomo sija; sa sija y minagof y corasonjo. ");
INSERT INTO cha_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Jumangag y corasonjo para jucumple y laymo sija; para taejinecog asta y uttimo. ");
INSERT INTO cha_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","SAMECH Juchatlie y mangaejinaso dobble: lao y tinagomo juguaeya. ");
INSERT INTO cha_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Jago y fanatogco na lugat yan y patangjo: junanangga, y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Fañuja guiya guajo jamyo ni y chumogüe manaelaye: para juadadaje y tinago Yuusso. ");
INSERT INTO cha_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Mantieneyo jaftaemano y sinanganmo, para julâlâ: ya chamoyo na mamamajlao ni y ninanggaco. ");
INSERT INTO cha_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Mantieneyo ya juseguro: ya jurespeta y tinagomo sija siempre. ");
INSERT INTO cha_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Unpolo pot taya todo ayo sija y manaba gui laymo: sa y finababañija taebale. ");
INSERT INTO cha_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Unnafañuja todo ayo sija y manaelaye gui tano calang basula: enao mina juguaeya y testimoniomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Y catneco lalaolao pot y maañaoña nu jago: ya maañaoyo ni y juisiomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","AIN Jufatinas juisio yan tininas: chamoyo dumidingo gui minafañatsagayo. ");
INSERT INTO cha_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Jago unaseguro y tentagomo para mauleg; chamo pumópolo y sobetbio na unachatsagayo. ");
INSERT INTO cha_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","y atadogco yafae pot y satbasionmo, yan pot y tinas na sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Fatinas gui tentagomo jaftaemano y minaasemo, yan fanagüeyo ni y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Guajo tentagomoyo; naeyo tiningo, ya jutungo y tinagomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Esta tiempo para si Jeova ufachocho: na sija manataebale y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Enao mina juguaeya y tinagomo sija, mas qui y oro, junggan, mas qui y fino na oro. ");
INSERT INTO cha_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Enao mina junaguaelaye todo y finanagüemo sa tunas pot todo güinaja: ya juchatlie y cada chalan dacon. ");
INSERT INTO cha_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","PE Y tinagomo sija mannámanman: enao mina maninadadaje ni y antijo. ");
INSERT INTO cha_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Y binaban y sinanganmo numae manana: jananae tinagoña y manaetiningo. ");
INSERT INTO cha_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Juguefbaba y pachotto, ya sumuspirosyo: sa majalangyo ni y tinagomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Birajao guiya guajo, y unmaase nu guajo, taegüije y costumbremo ni unfatinas ni ayo sija ni gumaeya y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Naregla y pinecatto ni y sinanganmo: ya chamo na fangagae ninasiña y jafa na isao guiya guajo. ");
INSERT INTO cha_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Nalibreyo gui chiniguet y taotao, ayo nae juadaje y finanagüemo. ");
INSERT INTO cha_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Nafanina y matamo gui jilo y tentagomo; ya unfanagüeyo ni y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Janom sadog manmalalago papa gui atadogco sija sa sija ti maadaje y tinagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","TZADE Tunasjao, O Jeova, yan tunas y juisiomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Jagasja untago y testimoniomo sija gui tininas, yan minagajetja. ");
INSERT INTO cha_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Y inigojo jalachaeyo, sa y contrariujo sija manmalefa ni y sinanganmo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Y sinanganmo sengasgas: enao mina jaguaeya y tentagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Diquiqueyo, ya madespresiayo, lao ti malelefayo ni y finanagüemo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Y tininasmo taejinecog na tininas ya y tinagomo minagajet. ");
INSERT INTO cha_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Chinatsaga yan pinite sumodayo: lao y tinagomo sija minagofjo. ");
INSERT INTO cha_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Y testimoniomo sija manunas para taejinecog: naeyo tiningo ya julâlâ. ");
INSERT INTO cha_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","KOPH Umaagangyo contodo y corasonjo; opeyo, O Jeova; bae juadaje y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Jagasja juagangjao; satbayo, ya juadaje y testimoniomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Taftafñayo qui y egaan ya umagangyo: junangga guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Y atadogco taftaña qui y bumela gui puenge para jujajasoja y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Jungog y inagangjo jaftaemano y minauleg güinaeyamo: O Jeova, nalâlâyo, jaftaemano y juisiomo. ");
INSERT INTO cha_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Manjijot ayo sija y tumatitiye y tinaelaye: sija mañago gui tinagomo. ");
INSERT INTO cha_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Jago jijot jao, O Jeova; yan todo y tinagomo sija minagajet. ");
INSERT INTO cha_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Pot guinin ampmam na tiempo jutungo y testimoniomo sija, ni y unplanta sija para siempre. ");
INSERT INTO cha_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","RESH Jaso y trinisteco, ya nalibreyo; sa ti malefayo ni y laymo. ");
INSERT INTO cha_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Plaitea y causaco, ya nalibreyo ni apasmo: nalâlâyo jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Chago y satbasion gui manaelaye, sa ti maaliligao y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Dangculo y cariñoso na minaasemo, O Jeova, nalâlâyo jaftaemano y juisiomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Megae pumetsisigueyo yan contrariujo; lao ti sumususujayo gui testimoniomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Julie y fumatinas dinague, ya tristeyo, sa ti maadaje y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Jaso jafa muna juguaeya y finanagüemo sija: nalâlâyo, O Jeova, jaftaemano y munamauleg güinaeyamo. ");
INSERT INTO cha_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Y resumen sinanganmo minagajet; ya cada uno tunas na juisiomo sija gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","SHIN Y prinsipe sija mapetsisigueyo sin causa: lao y corasonjo maaañaoja ni y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Jumagofyo ni y sinanganmo, taegüije y manmañoda dangculo na inamot. ");
INSERT INTO cha_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Jugoschatlie ya juingin y dinague; lao y laymo juguaeya. ");
INSERT INTO cha_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Siete maje gui un jaane jualabajao, sa pot y tinas na juisiomo. ");
INSERT INTO cha_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Dangculo na pas guaja para ayo sija y gumaeya y laymo, ya taya lugatñija para ufanmatompo. ");
INSERT INTO cha_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","O Jeova, jagasja junangga y satbasionmo, ya esta juchogüe y tinagomo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Y antijo esta jaadaje y tinagomo sija: ya sija mangosyajo. ");
INSERT INTO cha_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Esta juadaje y finanagüemo sija yan y testimoniomo sija; sa todo y jinanaojo mangaegue gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","TAU Polo ya y inagangjo ufato jijot gui menamo, O Jeova: naeyo tiningojo jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Polo y tinayuyutto ya ufato gui menamo: nalibreyo jaftaemano y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Polo y labiosso ya umasangan alabansa sija; sa unfanagüeyo ni y laymo sija. ");
INSERT INTO cha_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Polo ya y jilajo ucanta y sinanganmo: sa todo y tinagomo manunas. ");
INSERT INTO cha_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Polo ya ulisto y canaemo para uinayudayo; sa y tinagomo jagasja juayeg. ");
INSERT INTO cha_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Jagasja majalangyo ni y satbasionmo, O Jeova: ya y laymo minagofjo. ");
INSERT INTO cha_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Palo ya ulâlâ y antijo, ya ualabajao: polo ya juisiomo sija uinayudayo. ");
INSERT INTO cha_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Juabagyo, parejo yan y malingo na quinilo: aligao y tentagomo; sa ti malelefayo ni y tiningomo sija. ");
INSERT INTO cha_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Y Cantan Quinajulo. JUAGANG si Jeova gui anae chatsagayo, ya jaopeyo. ");
INSERT INTO cha_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Nalibre y antijo, O Jeova, gui mandacon na labios, yan y mafáfababa na jula. ");
INSERT INTO cha_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Jafa unmannae jao, pat jafa mas unmafatinas guiya jago y dacon: na jula? ");
INSERT INTO cha_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Y cadidug y flechan y matatnga, yan y pinigan gago. ");
INSERT INTO cha_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Ae ae guajo, ni taotao tumanoyo guiya Meseg, ya sumagayo gui tiendan Kedar. ");
INSERT INTO cha_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Y antijo sumaga apmam, yan ayo y chumatlie y pas. ");
INSERT INTO cha_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Guajo para pas, lao, anae cumuentosyo, sija para guera. ");
INSERT INTO cha_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Y Cantan Quinajulo. JUJATSA julo y atadogco gui sabana: guinin mamano mague y umayuyudayo? ");
INSERT INTO cha_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Y umayuyudayo guinin as Jeova, ni y fumatinas y langet yan y tano. ");
INSERT INTO cha_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Ti upolo y adengmo na umanacalamten: ayo y umadadajejao ti umatujog. ");
INSERT INTO cha_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Estagüe, y umadadaje Israel ti umatujog ni ti umaego. ");
INSERT INTO cha_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Si Jeova y umadadajejao: si Jeova nujongmo gui agapa na canaemo. ");
INSERT INTO cha_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Y atdao ti unninasague gui jaane, ni y pilan gui puenge. ");
INSERT INTO cha_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Si Jeova uninadaje gui todo tinaelaye: güiya uadaje y antimo. ");
INSERT INTO cha_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Si Jeova uninadaje yan jumujuyongjao yan jumajalomjao, desde pago na tiempo yan para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Y Cantan Quinajulo. MAGOFYO anae ilegñija nu guajo, nije tafanmalag y guima Jeova. ");
INSERT INTO cha_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Y adengta ufanojgue gui jalom y trangcamo, O Jerusalem. ");
INSERT INTO cha_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalem, mafatinas jago calang y siuda ni y mafatinas mafnot: ");
INSERT INTO cha_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Sa ayo nae mangajulo y tribosija, magajet na y tribon y Jeova, pot y testimonio guiya Israel, para ujanae grasias y naan Jeova. ");
INSERT INTO cha_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Sa ayonae mapolo y trono sija para ufanmanjusga, y trono sija gui guima David. ");
INSERT INTO cha_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Fanmanayuyut para upas iyon Jerusalem: sa mumegae ayo sija y gumaeyajao. ");
INSERT INTO cha_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Pas ugaegue gui jalom y quelatmo, yan guinefsaga gui jalom palasyomo. ");
INSERT INTO cha_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Pot causan y mañelujo yan y mangachongjo, jualog pago: Pas ugaegue gui sanjalommo. ");
INSERT INTO cha_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Pot causan guma Jeova Yuusso nae jualigao y minaulegmo. ");
INSERT INTO cha_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Y Cantan Quinajulo. YYAJAGO nae jujatsa y atadogco, O jago ni y matatachong gui langet sija. ");
INSERT INTO cha_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Estagüe, parejo yan y atadog tentago sija ni y jaaatan y canae y amuñija, yan y atadog sija y palaoan jaaatan y canae y amafia; parejoja y atadogmame jaaatan locue si Jeova Yuusmame, asta qui ugaemaase nu jame. ");
INSERT INTO cha_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Gaease nu jame, O Jeova, gaease nu jame: sa guesmanbulajam ni y iningen. ");
INSERT INTO cha_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Y antita senbula ni y binitlean ayo sija y taepinite, yan y denespresian y mansobetbio. ");
INSERT INTO cha_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Y Cantan Quinajulo; iyon David. YANGUIN si Jeova ti guinin estaba gui bandata, pago Israel ualog; ");
INSERT INTO cha_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Yanguin si Jeova ti guinin estaba gui bandata, anae y taotao sija mangajulo contra jita: ");
INSERT INTO cha_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","Ayo nae japañotjit lalâlâ, yanguin mangosbubu contra jita. ");
INSERT INTO cha_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Ayo nae janafanmachuchudajit y janom, yan y diquique na sadog malofan gui jilo y antita: ");
INSERT INTO cha_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Ayo nae y mansobetbio na janom manmalofan gui jilo y antita. ");
INSERT INTO cha_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Dichoso si Jeova, sa ti mannae nu jita para güinaja y nifenñija. ");
INSERT INTO cha_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Y antijo umescapa taegüije y pajaro yan umescapa güe gui lason y tiradot: magtos y laso, ya manescapajam. ");
INSERT INTO cha_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Y naan Jeova umayuyudajam, ni y fumatinas y langet yan y tano. ");
INSERT INTO cha_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Y Cantan Quinajulo. TODO ayo y umangogoco sija gui as Jeova ufanaegüije y egso Sion, ni y ti siña manacalamten, ya usaga para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Taemanoja y egso sija gui oriyan Jerusalem, taegüijeja si Jeova gui oriyan y taotaoña sija, desde pago para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Sa y baran y manaelaye ti usaga gui jilo y fottuna y manunas; sa noseaja ujajuto mona canaeñija y manunas gui tinaelaye. ");
INSERT INTO cha_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Fatinas mauleg güije sija gui manmauleg, O Jeova, yan ayo sija y manunas corasonñija. ");
INSERT INTO cha_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Lao ayo sija y bumira sija ya malag y echong na chalanñija, si Yuus ufaninesgaejon yan ayo sija y manmamatitinas tinaelaye. Pas ugaegue guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Y Cantan Quinajulo. ANAE jabira talo si Jeova y quinautiba iyon Sion, manparejojit yan ayo sija y manmangüife. ");
INSERT INTO cha_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Ayonae y pachotto bula chinaleg, ya y jilata canta: ya ayonae ujaalog gui entalo y nasion sija: si Jeova jafatinas dangculo na güinaja para sija. ");
INSERT INTO cha_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Si Jeova jafatinas dangculo na güinaja para jita; enaomina tafanmagof. ");
INSERT INTO cha_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Bira talo y quinautibanmame, O Jeova, taegüije y sadog gui sumanjaya. ");
INSERT INTO cha_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Ayo sija y manmananom yan lago: ufanmangoco yan minagof. ");
INSERT INTO cha_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Achogja jumajanao mona ya tuma tanges, mañuñule bonito na semiya; ufato talo yan y minagofña, jachuchuleja y manojon quinecoña. ");
INSERT INTO cha_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Y Cantan Quinajulo; iyon Salomon. YANGUIN ti si Jeova y jumatsa y guima, taebale y finatinasñija y manmachocho: yanguin ti si Jeova y umadaje y siuda, y guatdia magmamataja lao taebale. ");
INSERT INTO cha_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Taebale y uncajulo taftaf, ya undescansa atrasao, ya uncano y pan pinite: sa jananaeja ni y güinaeyaña y mamaego. ");
INSERT INTO cha_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Estagüe, y famaguon erensian Jeova: ya yi tinegcha y tiyan, apasiña. ");
INSERT INTO cha_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Jaftaemanoja y flecha gui canae y matatnga na taotao; taegüijeja locue y famaguon y manpatgon. ");
INSERT INTO cha_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Magof y taotao yanguin bula y questat y flechaña nu sija: ti ufanmamajlao, lao ufanguentos yan y enemigo sija gui trangca. ");
INSERT INTO cha_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Y Cantan Quinajulo. DICHOSO ayo y maañao as Jeova; ni y mamomocat, gui chalanña sija. ");
INSERT INTO cha_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Sa uncano y finachocho y canaemo: siempre unmagof yan umauleg para jago. ");
INSERT INTO cha_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Y asaguamo utaegüije y trongcon ubas ni y bula tinegcha gui jalom guimamo: y famaguonmo manparejo yan y tinanom olibo gui oriyan y lamasamo. ");
INSERT INTO cha_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Estagüe, taegüijeja y bendisionña ni y maañao as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Si Jeova ubinendisejao gui Sion; ya unlie y minauleg guiya Jerusalem todo y jaanin y linâlâmo. ");
INSERT INTO cha_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Magajet na unlie y famaguon y famaguonmo. Pas ugaegue guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Y Cantan Quinajulo. MEGAE na tiempo nae manapiniteyo desde y pinatgonjo: polo ya ualog Israel pago: ");
INSERT INTO cha_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Megae na tiempo nae manapiniteyo desde y pinatgonjo: lao trabia ti mangana ni y ninasiñañija contra guajo. ");
INSERT INTO cha_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Y manmanalado jaalado gui jilo y tatalojo: janafananaco y sutcoñija. ");
INSERT INTO cha_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Si Jeova tunaegüe: güiya umutut y cuetdas y manaelaye. ");
INSERT INTO cha_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Polo ya ufanmamajlao todo ayo y bumira sija tate, todo sija y chumatlie Sion. ");
INSERT INTO cha_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Polo ya ufantaegüije y chaguan gui jilo guma, ni y anglo antes di udoco: ");
INSERT INTO cha_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Ya chaña y manuutut chaguan munabubula y canaeña, ni y pechonña y manmanonojo. ");
INSERT INTO cha_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Ni ujaalog ayo sija y manmalolofan, Y bendision Jeova usaga gui jilomo; jame bumendise jao pot y naan Jeova. ");
INSERT INTO cha_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Y Cantan Quinajulo. Y sumanjiyong y tinadong nae juagang jao, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Jeova, ecungog y inagangjo: polo ya talangamo sija uegueng gui inagang y guinagaojo. ");
INSERT INTO cha_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Yanguin mojon unmatca y tinaelaye sija; Jeova, jaye utojgüe? ");
INSERT INTO cha_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Lao guaja inasie guiya jago, para unmamaañagüe. ");
INSERT INTO cha_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Junanangga si Jeova, y antijo mannanangga, ya y sinanganña junanangga. ");
INSERT INTO cha_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Y antijo jananangga si Jeova, mas qui y guatdia sija ni manmannanangga y egaan: magajet na mas qui y guatdia sija manmannananangga y egaan. ");
INSERT INTO cha_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","O Israel nangga si Jeova; sa gui as Jeova guaja minaase, ya iya guiya nae megae na inalibre. ");
INSERT INTO cha_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Ya güiya unalibre Israel todo gui tinaelayeña. ");
INSERT INTO cha_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Y Cantan Quinajulo; iyon David. JEOVA, ti sobetbio y corasojo, ni ti taglajiyon y atadogco: ni comequegaechecho yo ni y dangculo na güinaja; ni mas ninámanman para guajo. ");
INSERT INTO cha_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Magajet na jufamatquilo yo yan junaquietoyo; taegüije y patgon yan ninasusu as nanaña: y antijo guiya guajo parejo yan y patgon ni y sumususu. ");
INSERT INTO cha_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","O Israel nangga si Jeova, desde pago ya para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Y Cantan Quinajulo. JEOVA jaso para si David, todo y trinisteña; ");
INSERT INTO cha_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Jaftaemano na manjula gui as Jeova yan japromete y Gaesisiña gui as Jacob; ");
INSERT INTO cha_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Magajet na ti jujalom gui tabetnaculon y guimajo, ni jufalag gui camajo: ");
INSERT INTO cha_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Ti junamatujog y atadogco; ni junamaego y lasas y atadogco, ");
INSERT INTO cha_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Asta qui jusodayo y lugat para si Jeova, y tabetnaculo para y Gaesisiña gui as Jacob. ");
INSERT INTO cha_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Estagüe na injingog masangangüe guiya Efrata ya inseda gui fangualuan qui jalomtano. ");
INSERT INTO cha_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Infanjalom gui tabetnaculuña: inadora gui menan y fañajangan adengña. ");
INSERT INTO cha_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Cajulo, O Jeova, gui lugat y descansomo: jago yan y atcan y minetgotmo. ");
INSERT INTO cha_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Polo y mamalemo sija ya ufanminagago ni y tininas: ya y mañantosmo sija ufanagang ni y minagof. ");
INSERT INTO cha_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Pot y naan y tentagomo as David, chamo bumibira y matan y pinalaemo. ");
INSERT INTO cha_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Si Jeova manjula minagajet gui as, David; ti ubira güe; y tinegcha y tataotaomo, juplanta gui jilo tronumo. ");
INSERT INTO cha_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Yaguin jaadaje y famaguonmo y tratujo, yan y testimoniojo ni y jufanagüe sija, asta y famaguonñija locue ufanmatachong gui tronumo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Sa si Jeova guinin jaayeg Sion; este jadesea para sagaña. ");
INSERT INTO cha_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Este y lugat y descansoco para taejinecog: este nae jusaga; sa este judesea. ");
INSERT INTO cha_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Bae jubendise dangculo y prebensionña: ya bae junafannajong y mamobleña ni y pan. ");
INSERT INTO cha_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Junafanminagago locue y mamaleña sija ni y satbasion: yan y mañantosña sija ufanagang managang ni y minagof. ");
INSERT INTO cha_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Ayonae junadoco y canggelon David: guinin jufamauleg y candit para y pinalaejo. ");
INSERT INTO cha_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Bae junafanminagago y enemiguña sija ni y minamajlao; lao y jiloña nae unamagas y coronaña. ");
INSERT INTO cha_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Y Cantan Quinajulo; iyon David. ESTAGÜE, jafa munamauleg, yan jafa munamagof y mañelo ufañaga mañisija gui unoja. ");
INSERT INTO cha_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Este parejo yan y mauleg na laña gui ilo, ni y mimilalag gui batbas, asta y batbas Aaron; ya jumajnanao papa asta y cueyon magaguña; ");
INSERT INTO cha_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Taegüije serenon Hermon, ni y mamopodong gui jilo ogso guiya Sion; sa ayo nae mañago si Jeova y bendision, güiya taejinecog na linâlâ. ");
INSERT INTO cha_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Y Cantan Quinajulo. ESTAGÜE, fanmanbendise as Jeova, todo jamyo ni y tentago Jeova, ni y manotojgue gui jalom y guima Jeova gui puenge. ");
INSERT INTO cha_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Jatsa julo y canaemiyo gui sinantos na sagayan, ya fanmanbendise jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Si Jeova ni y fumatinas y langet yan y tano, bumendise jao guiya Sion. ");
INSERT INTO cha_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","FANMANALABA jamyo as Jeova. Fanmanalaba jamyo y naan Jeova: fanmanalaba güe, O jamyo, ni y tentago Jeova sija. ");
INSERT INTO cha_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Jamyo ni y manotojgue gui jalom guma Jeova, y jalom pateo y guimayuus. ");
INSERT INTO cha_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Fanmanalaba as Jeova; sa si Jeova mauleg güe: fanganta y alabansa sija ni y naanña; sa magof este. ");
INSERT INTO cha_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Sa si Jeova jaayeg si Jacob para güiya, ya Israel para y güinajañaja namaesa. ");
INSERT INTO cha_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Sa jutungo na si Jeova dangculo güe: ya y Señotta taquiloña qui todo y Yuus. ");
INSERT INTO cha_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Jafaja y malagoña si Jeova, esteja jafatinas, gui langet yan y tano, yan y tase, yan todo y manadong na lugat. ");
INSERT INTO cha_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Janafangajujulo y asgon sija guinin y uttimon y tano; janalalamlam para uuchan; janachinile y manglo gui güinajaña. ");
INSERT INTO cha_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Ni y janalamen y finenana na finañago guiya Egipto, todo y taotao yan y gâgâ. ");
INSERT INTO cha_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Ya manago señat sija yan mannamanman gui talo guiya jago, O Egipto: gui as Faraon yan todo y tentagoña. ");
INSERT INTO cha_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Ya janalamen y mandangculo na nasion, yan japuno y manmatatñga na ray sija. ");
INSERT INTO cha_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Si Sehón ray y Amorreo yan si Og ray Basán, yan todo y raeno sija guiya Cananea: ");
INSERT INTO cha_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Ya mannae para erensia ni y tanoñija: para erensian y taotao na guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Y naanmo O Jeova, gagaegue para taejinecog; y majasomo, O Jeova, para todo y generasion sija. ");
INSERT INTO cha_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Sa si Jeova ujusga y taotaoña, ya ugaease ni y tentagoña sija. ");
INSERT INTO cha_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Y idolos y nasion sija, salape yan oro, y checho y canae y taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Guaja pachotñija, lao ti manguecuentos: guaja atadogñija, lao ti manmanlilie; ");
INSERT INTO cha_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Guaja talangañija; lao ti manmanjujungog; ni uguaja jinagong gui pachotñija. ");
INSERT INTO cha_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Ayo sija y fumatinas estesija ujafanparejoja yan sija: magajet na cada uno ni y umangoco sija ni ayosija. ");
INSERT INTO cha_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","O guma Israel, bendise si Jeova: O guma Aaron, bendise si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","O guma Levi, bendise si Jeova: jamyo ni y manmaañao as Jeova, bendise si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Bendito si Jeova guinin Sion ni y sumaga guiya Jerusalem. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","O nae si Jeova grasias; sa güiya mauleg: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","O nae grasias y Yuus y yuus sija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","O nae grasias y Señot y señot sija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Para ayo y güiyaja namaesa fumatinas y dangculo namanman: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Para güiya ni y pot y tiningo jafatinas y langet: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Para güiya ni y jajuto y tano gui jilo janom sija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Para guiya ni y jafatinas y mandangculo na candet sija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Y atdao para ufangobietna gui jaane: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Y pilan yan y pution sija para ufanmangobietna gui puenge: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Para güiya ni y munalamen Egipto gui finenana na finañagoñija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Ya jacone juyong Israel gui entaloñija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Yan y metgot na jataf canae yan y canae na majala: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Para güiya ni y japatten dos y Tasen Agaga: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Ya janafalofan Israel gui entaloña: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Ya jayute si Faraon yan todo y sendaluña sija gui Tasen Agaga: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Para güiya ni y jaosgaejon y taotaoña y inanaco y desierto: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Para güiya ni y janalamen y mandangculo na ray sija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Yan japuno y mangaeninasiña sija na ray: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Si Sehón ray y Amorreo: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Yan si Og ray Basán: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Ya mannae erensia ni y tanoñija: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Magajet na para erensian y tentagoña guiya Israel: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Ni y jajasojit gui managpapata: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Ya janalibrejit gui coutrariuta: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Ni y mannae nengcano para todo y catne: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","O nae grasias y Yuus y langet: sa y minaaseña gagaegue para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Y oriyan y sadog Babilonia nae infanmatachong, magajet na manangesjit yanguin injaso Sion. ");
INSERT INTO cha_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Incana y atpanmame gui trongcon sauses gui entaloña güije. ");
INSERT INTO cha_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Sa güije ayo sija y cumonejit, jatagojit na tafanganta: ya ayo sija y lumachaejit, jatagojit na tafanmagof, ilegñija: Cantayejit uno ni y cantan Sion. ");
INSERT INTO cha_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Jaftaemano incanta y cantan Jeova gui ti tanomame? ");
INSERT INTO cha_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Yanguin malefayo nu jago, O Jerusalem! polo ya umalefa y agapa na canaejo ni y tiningoña. ");
INSERT INTO cha_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Yanguin ti jujaso jao, polo ya unacheton y jilajo gui paladatto; yanguin ti juguaeyajao, Jerusalem, mas qui y prinsipat na minagofjo. ");
INSERT INTO cha_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Jaso O Jeova contra y famaguon Edom gui jaanin Jerusalem; ni ilegñija: Funas, funas asta y simientoña. ");
INSERT INTO cha_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","O jagan Babilonia ni y para unmayulang; umagof ayo y para uninapase taegüije ni y unsetbejam. ");
INSERT INTO cha_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Umagof ayo, y uquenene na uyinite y famaguonmo contra y acho. ");
INSERT INTO cha_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Y Salmon David. BAE junae jao grasias contodo y corasonjo: gui menan yuus sija, jucantaye jao ni y alabansa sija. ");
INSERT INTO cha_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Jufanadora para y santos na templomo, ya junae y naanmo grasias pot y cariñoso na güinaeyamo, yan pot y minagajetmo: sa unnadangculo y sinanganmo mas qui y naanmo. ");
INSERT INTO cha_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Y jaane anae juagang, jago umopeyo, ya unanimayo, ni y minetgot y antijo. ");
INSERT INTO cha_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Todo y ray gui tano unmannae jao grasias, O Jeova, sa jagasja majungog y sinangan y pachotmo. ");
INSERT INTO cha_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Magajet na ufanganta ni y chalan Jeova; sa dangculo y minalag Jeova. ");
INSERT INTO cha_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Masquesea taquilo si Jeova, lao jarespetaja y managpapa: lao y sobetbio jatungoja desde y chago. ");
INSERT INTO cha_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Masquesea mamocatyo gui entalo y chinatsaga, unnalâlâyo: unestira mona y canaemo contra y binibun y enimigujo sija, ya y agapa na canaemo usatbayo. ");
INSERT INTO cha_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Si Jeova unacabales y gaegue guiya guajo: y minaasemo, O Jeova, gagaegue para taejinecog: chamo dumidingo y checo y canaemo. ");
INSERT INTO cha_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Y Salmon David. O Jeova, guinin unrejistrayo, ya guinin untungoyo. ");
INSERT INTO cha_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Untutungoja y finatachongjo yan y quinajulojo; untutungoja y jinasoco desde y chagogo. ");
INSERT INTO cha_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Unlilicue y finaposo yan y fanasonjo, ya untutungo todo y chalanjo. ");
INSERT INTO cha_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Sa taya ni un sinangan gui jilajo: jao, estagüe, na untungoja todo, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Unoriyayeyo gui menajo, yan y tateco: yan unpolo y canaemo gui jilojo. ");
INSERT INTO cha_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Gosnámanman este na tiningo para guajo; gostaquilo, ti siña jucomprende. ");
INSERT INTO cha_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Manoyo guato taegüe y espiritumo? pat manoyo jufalagüe taegüe yo gui menamo? ");
INSERT INTO cha_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Yaguin cumajuloyo gui langet gaegueja jao güije; yanguin jujuto y camajo guiya sasalaguan, gaegueja jao locue güije. ");
INSERT INTO cha_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Yanguin juchule y papan y egaan, ya jusaga gui uttimon y tase; ");
INSERT INTO cha_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","Asta ayo gaegueja y canaemo na jaosgagaejonyo, ya y agapa na canaemo umantieneyo. ");
INSERT INTO cha_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Yanguin jualog: Magajet na utampeyo y jemjom: asta y puenge uinayo. ");
INSERT INTO cha_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Asta y jemjom ti uninatogüe: lao y puenge ufanina taegüije y jaane: y jemjom yan y mananana manparejoja para jago. ");
INSERT INTO cha_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Jago tumungo yo, sa jago magas y sumanjalomjo; guinin untampeyo gui jalom tiyan nanajo. ");
INSERT INTO cha_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Junae jao grasias: sa gosnamaañao yan gosnamanman y mafatinasso: mannamanman y chechomo; ya y antijo jagostungo este. ");
INSERT INTO cha_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Y tataotaojo ti umatog guiya jago, anae mafatinasyo gui secreto; ya matufog yo ni namanman, gui mas tagpapa na lugat gui tano. ");
INSERT INTO cha_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Y atadogmo lumie y tataotaojo ya ti cabales: ya y lebblomo nae manmatugue todo y pedason tataotaojo, ya taya ufatta. ");
INSERT INTO cha_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Jafa muna guaguan y jinasomo guiya guajo, O Yuus! Jafa muna megae sumaña! ");
INSERT INTO cha_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Yanguin jutufong sija, manmegaeña y numeroña qui y inae: yanguin magmatayo, gaeguejayo trabia guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Seguro na unpuno y taelaye, O Yuus: enaomina mañuja guiya guajo y manmejga na taotao sija. ");
INSERT INTO cha_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Sa manguentos taelaye contra jago, ya y enimigumo sija machule y naanmo pot taya. ");
INSERT INTO cha_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Ada ti juchatlie ayo sija, O Jeova, y chumatlie jao? yan ada ti unatristeyo pot ayo sija y mangajulo contra jago? ");
INSERT INTO cha_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Juchatlie sija ni y cabales na chinatlie: jutufong sija pot y enemigujo. ");
INSERT INTO cha_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Rejistrayo O Yuus, ya untungo y corasonjo: chagueyo ya untungo y jinasoco sija. ");
INSERT INTO cha_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Ya unlie cao guaja taelaye gui sumanjalomjo, ya unchachalaneyo gui chalan taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Y Salmon David. NALIBREYO O Jeova gui taelaye na taotao: adajeyo gui fette na taotao: ");
INSERT INTO cha_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Ni y manmanjaso taelaye gui corasonñija: cada jaane mandaña para y guera. ");
INSERT INTO cha_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Janafanmalagtos y jilañija taegüije y serpiente; binenon y culebbla guaja gui jalom y labiosñija. Sila. ");
INSERT INTO cha_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Adajeyo O Jeova, gui canae y taelaye; adajeyo gui fette na taotao: ni y manmadetetmina para unasuja y pinecatto. ");
INSERT INTO cha_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Y sobetbio sija janaatog y laso yan y cuetdas para guajo: matiende y lagua gui oriyan chalan; manmanplanta ocodo para guajo. Sila. ");
INSERT INTO cha_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Ilegco as Jeova: Jago y Yuusso: ecungog y inagang y tinayuyutto, O Jeova. ");
INSERT INTO cha_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","O Yuus, Jeova, ni y minetgot y satbasionjo, jago tumampe y ilujo gui jaanin y guera. ");
INSERT INTO cha_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Chamo numanae y taelaye ni y dineseaña, O Jeova; chamo umayuyuda y taelaye jinasoña; na noseaja unafannaquilo maesa sija. Sila. ");
INSERT INTO cha_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Ya y ilun ayo sija y umoriyayeyo, polo ya utinampe sija ni y taelayen labiosñija. ");
INSERT INTO cha_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Polo ya ufamodog y pinigan guafe gui jiloñija: polo ya ufanmayute sija guato gui jalom guafe; y jalom y tadong na joyo ya chañija fangajujulo talo. ");
INSERT INTO cha_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Ti ufitme gui tano y cumuecuentos ni y taelaye: y tinaelaye jaaliligao y taelaye na taotao para uninaatlibes güe. ");
INSERT INTO cha_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Jutungo na si Jeova umantiene y causan y manpinite, yan y tininas y pebble. ");
INSERT INTO cha_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Magajet na umanae grasia y naanmo, ni y manunas: y manunas ufañaga gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Y Salmon David. JEOVA jagasja juaagangjao; chadig para iya guajo: ecungog y inagangjo, yanguin juagang jao. ");
INSERT INTO cha_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Polo y tinayuyutto ya umaplanta gui menamo taegüije y insensio; ya y jinatsaco julo ni y canaejo utaegüije y inefresen pupuenge. ");
INSERT INTO cha_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Polo y guatdia O Jeova gui menan pachotjo; adaje y pettan y labiosso. ");
INSERT INTO cha_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Chamo nafalag y tataelaye na güinaja y corasonjo, ya ufatinas y taelaye na chocho yan ayo sija na taotao y chumogüe tinaelaye: ya chamo na jucanoyo ni y mannge na nañija. ");
INSERT INTO cha_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Polo y tininas ya unalamenyo, este y minauleg; ya ureprendeyo, ya utaegüije y laña gui jilo y ilujo: chamo na ilujo urechasa: sa asta anae manaelaye sija, y tinayuyutto ugagaegueja. ");
INSERT INTO cha_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Manmayute papa y juesñija gui anae acho na lugat; ya ujajungog y sinanganjo sija, sa manmames. ");
INSERT INTO cha_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Y telangmame manmachalapon gui pachot y naftan; taegüije anae un taotao jaalado ya japuta y tano. ");
INSERT INTO cha_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Lao y atadogco, mangaegue guiya jago, O Yuus Jeova: iya jago nae gagaegueja y inangococo: chamo dumidingo y antijo namaesa. ");
INSERT INTO cha_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Adajeyo gui laso ni y maplanta para guajo, yan y ecodon y chumagüe y taelaye. ");
INSERT INTO cha_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Polo ya ufamodong y manaelaye gui jalom y laguañija, mientras umescacapayo. ");
INSERT INTO cha_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Cantan David anae Gagaegue gue gui Liyang; un Tinayuyut. JUAGANG si Jeova gui inagangjo; gui inagangjo si Jeova nae jutayuyut. ");
INSERT INTO cha_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Jubasia y quejaco gui menaña, jufanue gui menaña ni y chinatsagaco. ");
INSERT INTO cha_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Yanguin y espiritujo lalango gui sumanjalomjo, untungoja y finaposso. Y chalan gui anae mamocatyo, manaatog y laso para guajo. ");
INSERT INTO cha_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Atan y agapa na canaejo ya lie; lao taya ni un taotao tumungoyo: y guine güeco esta malingo; taya ni un taotao umadaje y antijo. ");
INSERT INTO cha_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Juagang jao O Jeova; ilegco: Jago guinegüeco yan y patteco gui tano y manlalâlâ. ");
INSERT INTO cha_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Atituye y inagangjo; sa sen lumalagpapayo; nalibreyo gui pumetsisigueyo, sa manmetgotña qui guajo. ");
INSERT INTO cha_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Najuyong y antijo gui calaboso, ya junae grasias y naanmo: ujaoriyayeyo y manunas; sa unfatinas pot guajo gosmegae. ");
INSERT INTO cha_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Y Salmon David. JUNGOG y tinayuyutto, O Jeova; ecungog y guinagaojo sija: opeyo pot y minagajetmo yan y tininasmo. ");
INSERT INTO cha_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Ya chamo jumajalom gui juisio yan y tentagomo: sa taya taotao lalâlâ umajustifica gui menamo. ");
INSERT INTO cha_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Sa y enimigo guinin japetsigue y antijo; guinin jasaulag papa gui jilo oda y jaanijo: janasagayo gui anae jomjom na lugat sija, taegüije sija y guinin apmam na manmatae. ");
INSERT INTO cha_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Enaomina y espiritujo, lalango gui sumanjalomjo: y corasonjo gui sumanjalomjo triste. ");
INSERT INTO cha_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Jujaso sija y apmam na jaane; jujaso todo y chechomo; jujajaso y checho y canaemo. ");
INSERT INTO cha_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Jujuto mona y canaejo guiya jago: y antijo majo nu jago, taegüije y anglo na tano. Sila. ");
INSERT INTO cha_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Jungogyo enseguidas, O Jeova: sa malayo y antijo: chamo na naaatog y matamo guiya guajo; sa noseaja juparejo yan ayo sija y mannunog gui jalom joyo. ");
INSERT INTO cha_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Na jungogyo ni y cariñoso na güinaeyamo gui egaan; sa jagoja nae juangocoyo: natungoyo ni y chalan anae para jufamocat; sa jujatsa julo y antijo guiya jago. ");
INSERT INTO cha_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Nalibreyo, O Jeova, gui enemigujo sija: jufalagüe jao, ya unnaatogyo. ");
INSERT INTO cha_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Fanagüeyo ya jufatinas y minalagomo: sa jago y Yuusso: y espiritumo mauleg; osgaejonyo gui tano y manunas. ");
INSERT INTO cha_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Nalâlâyo, O Jeova, pot y naanmo: pot y tininasmo, chule y antijo gui chinatsaga. ");
INSERT INTO cha_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Yan pot y cariñoso na güinaeyamo utut y enemigujo sija, ya unyulang todo sija y munapinite y antijo: sa guajo tentagomo. ");
INSERT INTO cha_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Y Salmon David. BENDITO si Yuus y achojo, ni y jafanagüe y canaejo para uguera, yan y calalotjo para umumo. ");
INSERT INTO cha_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Y minaaseco yan y guimegüeco y iyoco tore na taquilo, yan y munalibreyo; y patangjo, yan y anae juangocoyo; ni y pumolo y taotaojo gui papajo. ");
INSERT INTO cha_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Jeova, jafa y taotao na unatituye y tiningoña? pat y lajin taotao na uncuecuenta güe? ");
INSERT INTO cha_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Y taotao parejoja yan y jinaja; y jaaniña parejoja yan y anineng ni y malofan. ");
INSERT INTO cha_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Natalagpapa, y langetmo, O Yuus, ya tunogjao papa: pacha y egso sija ya ufanaso. ");
INSERT INTO cha_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Fanyute ni y lamlam ya ufanchinalapon sija: nafanogcha y flechamo, ya ufaninestotba sija. ");
INSERT INTO cha_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Estira y canaemo guinin jilo; rescatayo yan nalibreyo gui manadan janom, gui canae y manaotao juyong. ");
INSERT INTO cha_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Ni y pachotñija manguecuentos banida, ya y agapa na canaeñija, y dacon na canae agapa. ");
INSERT INTO cha_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Jucantaye jao ni y nuebo na canta, O Yuus: y guitala, ni y dies cuetdasña nae jucantaye jao ni y alabansa sija. ");
INSERT INTO cha_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Güiya ayo y mannae satbasion gui ray sija: ni janalibre si David ni y tentagoña gui gosnalamen na espada. ");
INSERT INTO cha_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Rescatayo ya nalibreyo gui canae y manaotao juyong, ni y pachotñija manguecuentos banida, ya y agapa na canaeñija y dacon na canae agapa. ");
INSERT INTO cha_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Ya y famaguonmame lalaje ufantaegüije y tinanom yanguin mandoco ya mangajulo gui pinatgonñija; ya y jaganmame ufantaegüije y mapopolo gui punta na acho, ni y malabla taegüije y palasyo. ");
INSERT INTO cha_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Ya y lanchonmame bula, mannae todo clasen güinaja: ya gamame quinilo ufanmañago mit yan dies mit gui fangualuanmame. ");
INSERT INTO cha_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Ya y gamame nobiyo sija ufanmangotga mauleg; ya chañija rumorompe jalom ni juyong, ya taya inagang pot pinite gui cayenmame. ");
INSERT INTO cha_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Mandichoso ayo sija na taotao y manguaja ni este: Junggan, mandichoso ayo sija na taotao ni y Yuusñija si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Y Salmon Alabansa; iyon David. JUNADANGCULO jao Yuusso, O Ray; jubendise y naanmo para taejinecog yan taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Cada jaane jubendise jao; ya bae jualaba y naanmo para taejinecog yan taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Dangculo si Jeova, ya sumendangculo para umaalaba; ya y dinangculoña ti comprediyon. ");
INSERT INTO cha_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Un generasion ualaba y chechomo gui otro generasion, yan ujadeclara y matatnga na finatinasmo sija. ");
INSERT INTO cha_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Jujajaso ni y minalag na minagas y inenramo, yan y mannamanman y chechomo. ");
INSERT INTO cha_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Ya y taotao sija ujasangan y ninasiñan y namaañao na finatinasmo sija; ya guajo bae judeclara y dinangculomo. ");
INSERT INTO cha_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Ujasangan y majason dinangculon y minaulegmo, ya ufanganta ni y tininasmo. ");
INSERT INTO cha_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Si Jeova, cariñosogüe, yan bula minaase; ñateng para ulalalo, ya dangculo minaaseña. ");
INSERT INTO cha_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Si Jeova mauleg para todo: ya y cariñoso na minaaseña gui jilo todo y chechoña. ");
INSERT INTO cha_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Todo y chechomo uninalaba jao, O Jeova; ya y mañantosmo unmabendise jao. ");
INSERT INTO cha_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Ujasangan y minalag y raenomo, yan ufanguentos ni y ninasiñamo. ");
INSERT INTO cha_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Para ujanamatungo y matatnga na finatinasña sija gui lalajen taotao, yan y minalag y minagasña gui raenoña. ");
INSERT INTO cha_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Y raenomo, taejinecog na raeno, ya y gobietnomo gagaegueja para todo y generasion. ");
INSERT INTO cha_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Si Jeova mumantiene todo ayo sija y mamodong, yan jajatsa todo ayo y manetecon. ");
INSERT INTO cha_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Todo y atadog sija numanangga jao; ya jago numae sija nañija gui mauleg na tiempo. ");
INSERT INTO cha_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Unbaba y canaemo, ya unnafannajong todo y minalago y manlâlâlâ na güinaja. ");
INSERT INTO cha_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Si Jeova tunas güe gui todo y chalanña; ya cariñoso gui todo y chechoña. ");
INSERT INTO cha_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Si Jeova jijot gui todo ayo sija y umaagang gue; gui todo ayo y umaagang güe ni y minagajet. ");
INSERT INTO cha_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Güiya unafanbula y minalago ayo sija y manmaañao nu güiya: ujungog locue y inagangñija, ya usatba sija. ");
INSERT INTO cha_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Si Jeova jaadadaje todo ayo sija y gumaeya güe: lao todo y manaelaye uyulang. ");
INSERT INTO cha_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Y pachotto usangan y tinina as Jeova: ya polo todo y catne, ya utinina y santos na naanña, para taejinecog yan taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","FANMANALABA jamyo as Jeova. O antijo, alaba si Jeova. ");
INSERT INTO cha_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Mientras lalâlâyo, bae jualaba si Jeova: jucantaye alabansa sija gui Yuusso mientras guajayo sustansiaco. ");
INSERT INTO cha_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Chamo pumopolo y inangocomo gui prinsipe sija, ni y lajin taotao, gui anae taya inayuda. ");
INSERT INTO cha_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Y jinagongña jumanao, ya güiya tumalo guato gui edaña: ayoja na jaane malingo y jinasoña. ");
INSERT INTO cha_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Magof ayo y uguaja ni y Yuus Jacob para innayuda güe, ni y inangocoña gaegue gui as Jeova Yuusña: ");
INSERT INTO cha_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Ni y jafatinas y langet yan y tano, yan y tase, yan todo y mangaegue gui sumanjalomñija, ni y jaadaje y minagajet para taejinecog. ");
INSERT INTO cha_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Ni y jafatitinas juisio gui manmachiguet; ni y jananae nengcano y manñalang: si Jeova japupula y manmaprereso: ");
INSERT INTO cha_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Si Jeova bumababa y atadogñija y bachet: si Jeova jumajatsa ayo sija y manetecon; si Jeova jaguaeguaeya y manunas. ");
INSERT INTO cha_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Si Jeova jaadadaje y taotao juyong sija; jamantietiene y taya tatañija yan y manbiuda; lao y chalan y tinaelaye, janaopop. ");
INSERT INTO cha_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Si Jeova ufangobietna para taejinecog; y Yuusmo, O Sion, para todo y generasion. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","FANMANALABA jamyo as Jeova: sa mauleg na utacantaye alabansa sija gui Yuusta; sa magof este; ya y alabansa respetao. ");
INSERT INTO cha_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Si Jeova jumajatsa Jerusalem: ja fandadaña y manmayute juyong guiya Israel. ");
INSERT INTO cha_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Janafanjomlo y manmayulang na corason, ya jabee y chetnotñija. ");
INSERT INTO cha_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Jasangan y numeron y pution sija; jafanaan todo sija ni y naanñija. ");
INSERT INTO cha_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Dangculo y Yuusta, yan matatnga gui ninasiña; tiningoña taeuttimo. ");
INSERT INTO cha_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Si Jeova jumajatsa y manmanso: ya jachule papa y manaelaye gui jilo oda. ");
INSERT INTO cha_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Cantaye si Jeova ni y finatinas grasias; cantaye alabansa sija gui atpa, para y Yuusta. ");
INSERT INTO cha_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Ni y jatatampe y langet ni y mapagages, ya jalilisto y ichan para y tano, ya janafandodoco y chaguan gui jilo ogso sija. ");
INSERT INTO cha_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Güiya numannae y gâgâ sija nañija, yan y fumaguon y aga sija ni y manaagang. ");
INSERT INTO cha_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Güiya ti ninamamagof ni y ninasiñan y cabayo: ni ti ninamamagof güe ni y adeng y taotao. ");
INSERT INTO cha_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Si Jeova ninamamagof güe ni y manmaañao nu güiya, ni y umangoco sija gui minaaseña. ");
INSERT INTO cha_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Alaba si Jeova, O Jerusalem; alaba si Yuusmo, O Sion. ");
INSERT INTO cha_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Sa janafanfitme y rejas y trangcamo: jabendise y famaguonmo gui sumanjalommo. ");
INSERT INTO cha_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Jafatinas pas gui jalom uttimomo, ya ninabula jao ni y guesmauleg na trigo. ");
INSERT INTO cha_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Janajanao y tinagoña gui jilo tano: y sinanganña malalago goschadig. ");
INSERT INTO cha_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Mannae niebe calang pulo: jachalapon y manengjeng na sereno calang apo. ");
INSERT INTO cha_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Jayute y aesña calang andesmorona sija: jaye siña tumojgue gui menan y manengjengña? ");
INSERT INTO cha_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Janajanao y sinanganña, ya jadirite: janafanguaefe y mangloña, ya y janom sija manmilalag. ");
INSERT INTO cha_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Jafanue si Jacob ni y sinanganña, ya y layña sija yan y juisioña sija y Israel. ");
INSERT INTO cha_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Ti jafatinas taegüine gui un nasion: ya y juisioña, sija ti manmatungo sija. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","FANMANALABA jamyo as Jeova. Fanmanalaba jamyo as Jeova desde y langet: Fanmalaba nu güiya guiya jululo. ");
INSERT INTO cha_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Fanmanalaba jamyo nu güiya, todo y angjetña: fanmanalaba jamyo nu güiya todo y inetnon sendaluña. ");
INSERT INTO cha_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Fanmanalaba jamyo nu güiya, atdao an pulan: fanmanalaba jamyo nu güiya todo y pution ni y maniina. ");
INSERT INTO cha_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Fanmanalaba jamyo nu güiya, langet sija y langet sija, yan y janom sija ni y mangaegue gui jilo y langet. ");
INSERT INTO cha_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Polo sija ya ujaalaba y naan Jeova: sa manago, ya sija manfatinas. ");
INSERT INTO cha_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Güiya guinin plumanta sija locue para taejinecog yan taejinecog: jafatinas y tinago na tu ufalofan. ");
INSERT INTO cha_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Fanmanalaba jamyo as Jeova desde y tano, jamyo ni y mandadao gui tinadong tase, yan todo y manadong. ");
INSERT INTO cha_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Y guafe yan graniso; niebe yan asgon: manglo pagyo ni y cumumple y sinanganña: ");
INSERT INTO cha_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Ogso sija yan todo y sabana; manmanogcha na trongcon jayo yan todo y sedrosija; ");
INSERT INTO cha_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","Gâgâ yan todo y guaca; mangucunanas na gâgâ, yan y mangugupo na pajaro. ");
INSERT INTO cha_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Ray sija y tano yan todo y taotao sija. Prinsipe sija, yan todo y jues y tano: ");
INSERT INTO cha_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Y manfamaguon na lalaje, yan famalaoan: y manamco na taotao, yan famaguon: ");
INSERT INTO cha_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Polo sija ya ujaalaba y naan Jeova: sa y naanñaja guefmanataquilo: y minalagña gui jilo tano yan y langet. ");
INSERT INTO cha_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Jagasja jajatsa julo locue y canggelon taotaoña; y tininan todo y mañantosña sija; magajet na sija y famaguon Israel, y taotao sija ni y manjijot guiya güiya. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","FANMANALABA jamyo as Jeova. Cantaye si Jeova ni y nuebo na canta, ya y tininaña gui inetnon y mañantos. ");
INSERT INTO cha_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Polo Israel ya umagof ni y fumatinas güe: polo y famaguon Sion ya ufanmagof ni y Rayñija. ");
INSERT INTO cha_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Polo sija ya ujaalaba y naaña ni y dansa: ya umacantaye güe gui atpa yan pandireta. ");
INSERT INTO cha_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Sa si Jeova janamagof güe gui taotaoña: güiya janagatbo y manmanso ni y satbasion. ");
INSERT INTO cha_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Polo y mañantos y ufanmagof gui minalag; polo ya ufanganta pot y minagof gui jilo y camañija. ");
INSERT INTO cha_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Polo y taquilo na alabansa gui as Yuus ya ugaegue gui pachotñija, yan y espada ni y malagtos dos banda gui canaeñija; ");
INSERT INTO cha_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Para ujafatinas y inemog gui nasion sija, yan y castigo gui taotao sija; ");
INSERT INTO cha_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Para ujagode y rayñija, ni y cadena sija; yan y manmagasñija ni y goden lulug. ");
INSERT INTO cha_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Para ujafatinas gui jiloñija y matugue na juisio: este na inenra para todo y mañantosña. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","FANMANALABA jamyo as Jeova. Alaba si Yuus gui sinantos na sagaña: alaba gue gui feneda y ninasiñaña. ");
INSERT INTO cha_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Alaba güe ni y matatnga na finatinasña sija: alaba güe jaftaemanoja y minagas dinangculoña. ");
INSERT INTO cha_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Alaba güe ni y sonidon y trompeta: alaba güe ni y guitala yan y atpa. ");
INSERT INTO cha_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Alaba güe ni y pandireta, yan y dansa: alaba güe ni y gaecuetdas na dandan yan y flauta. ");
INSERT INTO cha_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Alaba güe ni y agang na batingting: alaba güe ni gosagang na sonidon batingting. ");
INSERT INTO cha_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Polo todo y güinaja ni y mangaejinagong ya ujaalaba si Jeova. Fanmanalaba jamyo as Jeova. ");
INSERT INTO cha_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","LEBLON y rasan Jesucristo lajin David, lajin Abraham. ");
INSERT INTO cha_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham jalilis si Ysaac; ya si Ysaac jalilis si Jacob; ya si Jacob jalilis si Judas yan y mañeluña. ");
INSERT INTO cha_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ya si Judas jalilis, gui as Tamar, si Fares yan si Sara; ya si Fares jalilis si Esrom; ya si Esrom jalilis si Aram; ");
INSERT INTO cha_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ya si Aram jalilis si Aminadab; ya si Aminadab jalilis si Naason; ya si Naason jalilis si Salmon; ");
INSERT INTO cha_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ya si Salmon jalilis, gui as Rahab, si Boos; ya si Boos jalilis, gui as Rut, si Obed; ya si Obed jalilis si Isai; ");
INSERT INTO cha_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ya si Isai jalilis si ray David; ya si ray David jalilis si Salomon ni guinin güiya nii ampmam palaoan Urias; ");
INSERT INTO cha_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ya si Salomon jalilis si Roboam; ya si Roboam jalilis si Abias; ya si Abias jalilis si Asa; ");
INSERT INTO cha_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ya si Asa jalilis si Josafat; ya si Josafat jalilis si Joram; ya si Joram jalilis si Osias; ");
INSERT INTO cha_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ya si Osias jalilis si Joatam; ya si Joatam jalilis si Acas; ya si Acas jalilis si Esequias; ");
INSERT INTO cha_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ya si Esequias jalilis si Manases; si Manases jalilis si Amon; ya si Amon jalilis si Josias; ");
INSERT INTO cha_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ya si Josias jalilis si Joaquim; si Joaquim jalilis si Jeconias, yan y mañeluña anae manmacone guiya Babilonia. ");
INSERT INTO cha_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ya mapos y manmacone guiya Babilonia, si Jeconias jalilis si Salatiel; si Salatiel jalilis si Sorobabel; ");
INSERT INTO cha_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ya si Sorobabel jalilis si Abiud; si Abiud jalilis si Eliaquim; si Eliaquim jalilis si Asor; ");
INSERT INTO cha_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor jalilis si Sadog; si Sadog jalilis si Achim; si Achim si Eliud; ");
INSERT INTO cha_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud jalilis si Eleasar; si Eleasar jalilis si Matan; si Matan jalilis si Jacob; ");
INSERT INTO cha_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob jalilis si José, asaguan Maria, na finañago si Jesus na mafanaan si Cristo. ");
INSERT INTO cha_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Enao mina todo y generasion desde as Abraham asta as David, catotse sija na generasion; ya desde as David asta manmacone guiya Babilonia, catotse na generasion; ya desde qui manmacone guiya Babilonia asta as Cristo, catotse na generasion. ");
INSERT INTO cha_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Y mafañagon Jesucristo taegüine: Y nanaña as Maria, nobian José, antes de ujadaña, güiya esta masoda mapotgue pot y Espiritu Santo. ");
INSERT INTO cha_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ya si José asaguaña, sa mauleg na taotao, ti malago pinelo güe gui ninamamajlao, lao malagoña upinelo güe gui secreto. ");
INSERT INTO cha_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ya anae jajajaso este, mato para güiya y angjet Señot, anae jagüife gui minaegoña, na ilegña: José, lajin David, chamo maañao na unresibe si Maria asaguamo, sa y gaegue guiya güiya y linilis Espiritu Santo. ");
INSERT INTO cha_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ya ufañago un laje ya ufanaan si Jesus; sa güiya unafanlibre y taotaoña nu y isaoñija. ");
INSERT INTO cha_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Todo sija masusede para umacumple y esta jasangan y Señot pot y profeta, ni ilegña: ");
INSERT INTO cha_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Estagüe, un vitgen na umapotgue, ya ufañago un laje ya ufanaan si Emanuel, na comoqueilegña na si Yuus gaegue guiya jita. ");
INSERT INTO cha_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Anae magmata si José gui minaegoña, jafatinas taegüije y tinago y angjet, ya jaresibe y asaguaña. ");
INSERT INTO cha_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ya ti matungo asta qui mañago ni lajiña finenana; ya nae y naanña si Jesus. ");
INSERT INTO cha_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","YA mafañago si Jesus guiya Betlehem Judea gui jaanin ray Herodes, estagüe y manfaye na manmato guinin y sancatan para Jerusalem, ");
INSERT INTO cha_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ylegñija: mangue y ray Judios, ni mafañago? Sa y estreyasña inlie gui sancatan ya manmatojam para inadoragüe. ");
INSERT INTO cha_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ya anae jajungog este, si ray Herodes, inistotba yan todo y taotao Jerusalem locue. ");
INSERT INTO cha_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ya anae maagange todo y prinsipen mamale yan y escriba sija güije na tano, manfinaesen mano nae mafañago si Cristo. ");
INSERT INTO cha_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sija ilegñija: Iya Betlehem Judea; sa taegüine y munjayan matugue pot y profeta: ");
INSERT INTO cha_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ya jago Betlehem, tano Juda, ada ti sendiquique jao gui entalo y prinsipen Juda, sa iya jago nae ujuyong y magalaje, para upasto y taotaojo, Israel. ");
INSERT INTO cha_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Entonses si Herodes, anae jaagang y manfaye gui secreto, jaquequetungo guiya sija, ngaean y estreyas nae malie. ");
INSERT INTO cha_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ya Jatago sija para Betlehem, ilegña: Janao fanmalag ayo guato ya inalula manmamaesen pot y patgon; yaguin esta inseda, insangane yo; ya jufato locue ya juadora güe. ");
INSERT INTO cha_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ya anae munjayan jajungog y sinangan ray, manmapos; ya estagüe y estreyas ni y jalie gui sancatan, na mofona gui menañija asta qui mato ya sumaga gui anae estaba y patgon. ");
INSERT INTO cha_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Anae malie y estreyas, gosdangculo minagofñija. ");
INSERT INTO cha_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Anae manjalom gui guima, jasoda y patgon yan y nanaña, as Maria, ya mandimo ya maadora; ya mababa y güinajañija ya manae güe: oro, insenso, yan mira. ");
INSERT INTO cha_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ya manmasangane pot si Yuus gui güinife, na ti ufanmalag as Herodes, manjanao para y tanoñija gui otro chalan. ");
INSERT INTO cha_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ya anae manmapos sija, y angjet y Señot mato gui as José gui güinife, ya ilegña: Cajulo ya uncone y patgon yan si nanaña, ya infanjanao para Egipto, ya infañaga güije, asta qui guajojao sumangane; sa si Herodes jaaligao y patgon para umapuno. ");
INSERT INTO cha_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ya cajulo güe, ya jacone y patgon yan si nanaña gui puenge ya manjanao para Egipto; ");
INSERT INTO cha_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ya sumaga güije asta que matae si Herodes, sa para umacumple y sinangan y Señot pot y profeta, na ilegña: Iya Egipto nae, juagang y Lajijo. ");
INSERT INTO cha_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Si Herodes, anae jalie na mamofea güe ni manfaye, gueflalalo ya manago na ufanmapuno todo y famaguon ni guaja guiya Betlehem yan gui todo oriyaña ni dos años sacanñija para papa, jaftaemanoja y tiempo anae ninatungo ni y manfaye. ");
INSERT INTO cha_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ayo nae macumple esta, ni y guinin masangan pot y profeta Jeremias, na ilegña: ");
INSERT INTO cha_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Inagang na majungog guiya Rama umagang, tumangis yan cumasao na dangculo; si Raquel cumasao pot y famaguonña, ya ti malago maconsuela sa manaegüe. ");
INSERT INTO cha_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Anae esta matae si Herodes, mato y angjet y Señot gui as José gui güinife, guiya Egipto, ");
INSERT INTO cha_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ya ilegña: Cajulo, cone y patgon yan si nanaña, ya infanjanao para y tano Israel; sa matae y cumequepuno y patgon. ");
INSERT INTO cha_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ayo nae cajulo ya jacone y patgon yan si nanaña ya manmalag y tano Israel. ");
INSERT INTO cha_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ya jajungog na si Arquelao, güiya y ray guiya Judea gui sagan tataña as Herodes, maañao malag guato; lao pot si Yuus ninatungo güe claro gui güinifeña, mapos malag y tanon Galilea. ");
INSERT INTO cha_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ya anae mato, sumaga gui siuda na mafanaan Nasaret; para ucumple y masanganña pot y profeta sija, na umafanaan taotao Nasaret. ");
INSERT INTO cha_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","AYO sija na jaane, mato si Juan Bautista ya sumetmon gui desierton Judea, ");
INSERT INTO cha_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ylegña: Fanmañotsot sa y raenon langet jumijijot. ");
INSERT INTO cha_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sa esta güiya uje y guinin jasangan y profeta Isaias, na ilegña: Inagang ni umagang gui desierto: Famauleg y chalan y Señot, natunas y chalanña. ");
INSERT INTO cha_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Y magaguña si Juan y pilon cameyo yan y godeña cuero na jachaflileg gui senturaña, ya y naña y apacha sija yan y miet jalom tano. ");
INSERT INTO cha_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ayo nae mapos malag para güiya, Jerusalem yan Judea yan todo y tano gui oriyan Jordan, ");
INSERT INTO cha_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ya esta manmatagpange pot güiya, guiya Jordan, jasangan claro y isaoñija. ");
INSERT INTO cha_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ya jalie megae na Fariseo yan Saduseo sija na manmamaela para y tinagpangeña ya ilegña: Rasan culebla, jaye jamyo fumanagüe na insujaye y binibo ni mamaela? ");
INSERT INTO cha_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Fanmamatinas tinegcha digno ni y sinetsot. ");
INSERT INTO cha_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ya chamiyo jumajaso sumangan gui sanjalommiyo, na si Abraham tatata; ya guajo sumangane jamyo, na siña si Yuus janacajulo este sija na acho famaguon gui as Abraham. ");
INSERT INTO cha_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pago, esta locue y gachae gaegue na mapolo gui jale y trongcon jayo sija; ya todo y trongcon jayo ni ti manogcha mauleg, umautut ya umapolo gui guafe. ");
INSERT INTO cha_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Guajo magajet jutagpange jamyo nu y janom para minañotsot, lao y mamamaela gui tateco, mas guaja ninasiñaña qui guajo: y sapatosña ti mauleg yo na jupula; güiya infantinagpange ni Espiritu Santo yan y guafe. ");
INSERT INTO cha_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Y abanicoña gaegue gui canaeña, ya unagasgas y tablaña, ya unaetnon y triguña jalom gui jalom camalin, ya usonggue y pajan trigo gui taejinecog na guafe. ");
INSERT INTO cha_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Anae mato si Jesus guinin Galilea, malag Jordan gui as Juan para utinagpange. ");
INSERT INTO cha_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lao si Juan ti malago, ilegña: Nesesita yo matagpange pot jago, enaojao na mamaela guiya guajo? ");
INSERT INTO cha_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Inepe as Jesus ilegña: Diejaloja, sa taegüenao mauleg para utacumple y todo na tininas. Ayo nae pinelo. ");
INSERT INTO cha_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ya si Jesus, anae munjayan matagpange, cajulo gusisija guine y janom, y langet mababa pot güiya ya malie y Espiritun Yuus tumunog calang paluma y sumaga gui jiloña. ");
INSERT INTO cha_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ya estagüe, un vos guinin y langet na ilegña: Estagüiya y lajijo ni y guefyajo. ");
INSERT INTO cha_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","AYO nae quinene si Jesus ni Espiritu para y jalomtano para umatienta ni anite; ");
INSERT INTO cha_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ya estaba umayunat cuarenta na jaane yan cuarenta na puenge ya despues ñalang. ");
INSERT INTO cha_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ya mato guiya güiya y manienienta, ya ilegña: Yaguin jago lajin Yuus, tago este y acho ya ufamapan. ");
INSERT INTO cha_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Güiya manope ilegña: Matugue esta: Ti y panja uninalâlâ y taotao, lao y todo y sinangan ni y jumuyong gui pachot Yuus. ");
INSERT INTO cha_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ayo nae ninamalofan ni anite gui santa na siuda; pinelo gui jilo torren diquique, iyon y templo. ");
INSERT INTO cha_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Y ilegña: Yaguin jago lajin Yuus, yutejao güine papa, sa matugue esta: Y angjet sija uninadje ya unquinajat ni canaeñija, para chaña y adengmo umatotpe contra y acho. ");
INSERT INTO cha_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Si Jesus ilegña: Locue esta matugue, chamo tietienta y Señot, Yuusmo. ");
INSERT INTO cha_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tumalo ninamalofan ni anite gui un sabana na sentáquilo ya jafanue todo y raeno sija gui jilo y tano yan y minagofñija, ");
INSERT INTO cha_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ya ilegña: Todo este sija junaejao yaguin dumimojao ya unadora yo. ");
INSERT INTO cha_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ayonae si Jesus ilegña nu güiya: Janao Satanas, sa matugue esta, y Señot Yuusmo na güiyaja unadora yan güiyaja unsetbe. ");
INSERT INTO cha_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ayo nae diningo ni anite, ya y angjet sija manmato ya masetbe güe. ");
INSERT INTO cha_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Anae jajungog si Jesus na si Juan esta mapongle, tumalo guato Galilea. ");
INSERT INTO cha_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ya jadingo Nasaret, mato Capernaum ya sumaga gui oriyan tase gui oriyan tanon Sabulon yan Neftalim. ");
INSERT INTO cha_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Para umacumple y guinin jasangan y profeta Isaias, na ilegña: ");
INSERT INTO cha_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Y tano Sabulon yan y tano Neftalim, chalan tase yan para otro banda guiya Jordan, Galilea y Gentiles. ");
INSERT INTO cha_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ya y taotao sija nu y mañasaga gui jemjom, dangculo na manana liniiñija; y ayo sija nu y mañasaga tanon anineng y finatae, candet ufaninina. ");
INSERT INTO cha_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Desde ayo jatutujon si Jesus sumetmon ya ilegña: Fanmañotsot, sa y raenon langet jijijot. ");
INSERT INTO cha_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ya anae jumajanao si Jesus gui tasen Galilea, jalie dos chumelo; si Simon mafanaan Pedro yan si Andres cheluña, na janatutunog y lagua gui tase sa manpescadot. ");
INSERT INTO cha_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ya ilegña nu sija: Dalalag yo ya junafanpescadot taotao jamyo. ");
INSERT INTO cha_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sija japolo y lagua sija ya madalalag güe. ");
INSERT INTO cha_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anae jumanao güije, jalie otro dos chumelo, si Santiago lajin Sebedeo, yan si Juan cheluña, gui sajyan yan si tatañija as Sebedeo na jalememenda y laguañija; ya jaagang. ");
INSERT INTO cha_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sija enseguidas japolo y sajyan yan si tatañija ya madalalag güe. ");
INSERT INTO cha_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ya jalilicue si Jesus iya Galilea mamanagüe gui sinagoga sija ya sumetmetmon ni raenon y evangelio, ya janafanjomlo todo y chetnot yan todo y pinite gui taotao; ");
INSERT INTO cha_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ya y matunaña matungo todo guiya Siria; ya maquenenee güe guato todo manmalango, ni guaja todo clasen chetnot yan pinite; y maninanite yan y manbababa yan y manparalitico; ya janafanjomlo. ");
INSERT INTO cha_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ya madalalag güe linajyan taotao, guinin Galilea, yan guinin Decapolis, yan guinin Jerusalem, yan guinin Judea, yan y otro banda guiya Jordan. ");
INSERT INTO cha_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ANAE jalie si Jesus y linajyan taotao, cajulo gui un sabana, ya matachong; ya y disipuluña manmato guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ya jababa y pachotña ya jafanagüe, ilegña: ");
INSERT INTO cha_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mandichoso y mamoble gui Espiritu, sa uiyonñija y raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mandichoso y mantriste, sa sija umanafanmagof. ");
INSERT INTO cha_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mandichoso y manmanso, sa sija ufanmaereda ni y tano. ");
INSERT INTO cha_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mandichoso y manñalang yan manmajo ni tininas, sa sija umanafanjaspog. ");
INSERT INTO cha_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mandichoso y manyóase, sa sija ufantinaca ni minaase. ");
INSERT INTO cha_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mandichoso y mangasgas corasonñija, sa sija ujalie si Yuus. ");
INSERT INTO cha_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mandichoso y fumatitinas y pas, sa sija ufanmafanaan famaguon Yuus. ");
INSERT INTO cha_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mandichoso y manmapetsigue pot causa y tininas; sa uiyonñija y raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mandichoso jamyo, yaguin manmamatdise jamyo, yan manmapetsigue jamyo, yan manmasangane jamyo todo taelaye pot y naanjo, ya manmandague. ");
INSERT INTO cha_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Fanmagof, ya infansenmagof, sa y premionmiyo gui langet sendangculo: sa taegüenaoja locue manmapetsigueñija y profeta sija ni y antes di jamyo. ");
INSERT INTO cha_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jamyo y asigan y tano; ya yaguin y asiga malingo y maaseña, jafa taemano manasne? taya baliña, na umayute juyong ya umagacha ni y taotao. ");
INSERT INTO cha_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jamyo y candet y tano. Y siuda ni maplanta gui jilo y tano táquilo ti siña umatog. ");
INSERT INTO cha_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Taya candet umasonggue ya umapolo gui papa un medida; lao umapolo gui candelero, ya umanainina todo y mangaegue gui jalom guma. ");
INSERT INTO cha_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Polo ya umanina y candetmiyo gui menan y taotao sija, para ujalie y mauleg chechonmiyo, ya innamagof y tatanmiyo ni y gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Chamiyo jumajaso na mato yo para juyulang y tinago pat y profeta sija; ti mato yo para juyulang, lao para jucumple. ");
INSERT INTO cha_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa magajet jusangane jamyo, nu y langet yan y tano ufalingo; lao ni un punto ni un pongpong gui tinago ufalingo, asta qui güiya todo macumple. ");
INSERT INTO cha_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ya jayeja y yumulang uno güine gui sendiquique na tinago, ya mamanagüe ni taotao, diquique umafanaan gui raenon langet; lao jayeja y fumatinas ya mamanagüe umafanaan dangculo gui raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sa guajo sumangane jamyo: na y tininasmiyo yaguin ti mudongña qui y tininas y escriba yan y Fariseo sija, ti siña jamyo manjalom gui raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Injingogja y munjayan masangane sija gui manmalofan na tiempo: Chamo famumuno, ya jayeja y mamuno, peligroña gui juisio. ");
INSERT INTO cha_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lao guajo sumangane jamyo na jayeja y lalalo ni cheluña, peligroña gui juisio, na jayeja y umalog ni cheluña, taetiningo jao, peligroña gui tribunal, lao jayeja y umalog bababa jao, peligroña gui guafen sasalaguan. ");
INSERT INTO cha_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yaguin unchule y ninaimo guato gui attat, ya ayo nae unjaso na guaja linachimo gui chelumo; ");
INSERT INTO cha_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Polo güije y ninaimo gui menan y attat, ya unjanao finena ya inatungo yan y chelumo, ya ayo nae untalo guato ya unnaenñaejon y ninaimo. ");
INSERT INTO cha_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Atungo yan y contrariumo enseguidas, mientros gaegue jamyo gui chalanmiyo, noseaja, y cotrariumo unenentrega gui jues, ya y jues unenentrega gui ofisiat ya unmapolo gui preso. ");
INSERT INTO cha_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Magajet jusangane jamyo: Seguro na ti unjuyong güije, asta qui anapase y uttimo na coble. ");
INSERT INTO cha_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Injingogja y munjayan masangan: Munga umábale, ");
INSERT INTO cha_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ya guajo sumangane jamyo, na jayeja y umatan y palaoan nu ábale na minalagoña, jafatinas yan güiya y ábale gui jalom corasonña. ");
INSERT INTO cha_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yaguin y agapa na atadogmo uninapodong jao, chule ya yute guiya jago; sa maulegña na ufalingo un pidaso guiya jago, qui todo y tataotaomo umayute guiya sasalaguan. ");
INSERT INTO cha_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ya yaguin y agapa na canaemo uninapodong jao, utut ya yute guiya jago; sa maulegña, na ufalingo un pidaso guiya jago, qui todo y tataotaomo umayute guiya sasalagüan. ");
INSERT INTO cha_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Munjayan locue masangan: Jayeja y dumingo y asaguaña, umatugue y papet y inapattan umasagua. ");
INSERT INTO cha_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lao guajo sumangane jamyo, na y dumingo y asaguaña ya ti pot inábale, jafatinas y ábale; ya jayeja y umasagua ayo y umadingo, jafatinas y ábale. ");
INSERT INTO cha_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Injingogja locue y munjayan masangane sija gui manmalofan na tiempo: Munga manjula pot namaesa jao; lao unfatinas ni y Señot gui jinilamo. ");
INSERT INTO cha_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lao guajo sumangane jamyo: Chamiyo fanmanjujula pot jafa; ti pot y langet, sa raenon Yuus; ");
INSERT INTO cha_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni pot y tano, sa sagan y adengña; ni pot Jerusalem, sa siuda y dangculo na Ray; ");
INSERT INTO cha_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni pot y ilumo unfanjula; sa ti siña y gaponulo uno naapaca, ni uno naatulong. ");
INSERT INTO cha_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lao yaguin manguentos jamyo, alog: Junggan, junggan; Aje, aje; sa yaguin mas qui este, taelaye jumuyong. ");
INSERT INTO cha_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Injingogja y munjayan masangan: Atadog yan atadog, nifen yan nifen, ");
INSERT INTO cha_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lao guajo sumangane jamyo: Chamiyo fumatinas jafa contra y tinaelaye; yaguin jayejao pumatmada gui agapa na fasumo, birayeja ni y otro. ");
INSERT INTO cha_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ya jayeja y munaquequemumojao ya jachule y magagomo, nae locue y capamo. ");
INSERT INTO cha_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ya jayeja y umafuetsas jao na unjanao yan güiya un miya; unjanao yan güiya dos. ");
INSERT INTO cha_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Y gumagao jao, nae; ya y mumalago umayao jao, chamo jao rumiuusa. ");
INSERT INTO cha_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Injingogja y munjayan masangan: Guaeya y tiguangmo ya chatlie y enemigomo. ");
INSERT INTO cha_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lao guajo sumangane jamyo: Guaeya y enemigonmiyo; bendise y mumatdidise jamyo; fantinas mauleg ni y chumatlie jamyo, tayuyute sija as Yuus ni y munamamajlao jamyo yan y pumetsigue jamyo, ");
INSERT INTO cha_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Para infanfamaguon y tatanmiyo ni y gaegue gui langet, nu y janafanina y atdao gui jilo y manaelaye yan y manmauleg; ya janauchan gui jilo y manunas yan y timanunas. ");
INSERT INTO cha_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sa yaguin inguaeya ayo y gumaeya jamyo, jafa premionmiyo? Ada ti jafatinas locue taegüenao y publicano sija? ");
INSERT INTO cha_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yaguin unsaluda y mañelunmiyo, jafa unfatinas mauleg? Ada ti jafatinas locue taegüenao y ti mangilisyano? ");
INSERT INTO cha_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nafangabales jamyo taegüije y tatanmiyo ni y gaegue gui langet, cabales. ");
INSERT INTO cha_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ADAJE ya chamiyo fumatitinas y limosnanmiyo gui menan y taotao sija, para infanlinie; sa yaguin ti taegüenao, taya premionmiyo gui tatanmiyo ni gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yaguin unfatitinas y limosnamo, chamo na catitiye trompeta gui menamo taegüije y jafatitinas y hipocrita sija gui sinagoga, yan y plasa para uguaja minalagñija nu y taotao sija. Magajet jusangane jamyo na esta guaja premioñija. ");
INSERT INTO cha_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lao jago, yaguin unfatitinas y limosnamo, chamo natutungo y canaemo acagüe jafa checho y canaemo agapa. ");
INSERT INTO cha_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Para ugaegue y limosnamo gui secreto, sa y tatamo ni jalilie gui secreto, güiya umapase jao gui publico. ");
INSERT INTO cha_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ya yaguin manaetaejao, munga taegüije y hipocrita, sa sija yanñija manmanaetae gui sinagoga yan y esquinan chalan manotojgue para ufanmalie nu y taotao sija. Magajet na esta guaja premioñija. ");
INSERT INTO cha_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lao jago, yaguin manaetaejao, jalom gui aposentomo, ya juchum y pettamo, ya taetaye y tatamo ni y gaegue gui secreto; sa y tatamo ni y jalilie gui secreto, güiya umapase jao gui publico. ");
INSERT INTO cha_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yan manaetaejao chamo sumasangan un sinangan megae na biaje na taebale, taegüije y Gentiles; jinasoñija na ufanmajungog pot y megae sinanganñija. ");
INSERT INTO cha_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Chamiyo fumatitinas taegüije iya sija; sa y tatanmiyo jatungoja jafa innesesita antes qui ingagao güe. ");
INSERT INTO cha_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lao an manmanaetae jamyo taegüine: Tatanmame na gaegue jao gui langet: umatuna y naanmo. ");
INSERT INTO cha_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Umamaela y raenomo, umafatinas y minalagomo jaftaemano gui langet taegüijija gui tano; ");
INSERT INTO cha_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Naejam pago nu y cada jaane na agonmame; ");
INSERT INTO cha_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ya asiijam nu y dibenmame, taegüije yan inasisie y dumidibejam sija; ");
INSERT INTO cha_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ya chamojam pumópolo na infanbasnag gui tentasion, lao nafanlibrejam nu y taelaye; sa iyomo y raeno, yan y ninasiña, yan y minalag para taejinecog na jaane; Amen. ");
INSERT INTO cha_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sa yaguin inasie y umisagüe jamyo: maninasiija locue jamyo as tatanmiyo ni gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lao yaguin ti unasie ayo sija y umisagüe jamyo, ti infaninasie locue ni tatanmiyo nu y isaomiyo. ");
INSERT INTO cha_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yaguin umayuyunatjao, munga taegüije y hipocrita nu y triste na mata, jaago y matañija, para ufanmatungo ni taotao sija na manayunat. Magajet jusangane jamyo, na esta guaja premioñija. ");
INSERT INTO cha_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lao jago, yaguin umayunat jao, palalae y ilumo, ya unfagase y matamo; ");
INSERT INTO cha_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Para munga malilie nu y taotao sija na umayuyunat jao, lao si tatamoja ni y gaegue gui secreto; ya si tatamo, ni jalilie gui secreto, güiya uninapase gui publico. ");
INSERT INTO cha_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Chamiyo fannanaetnon güinaja para jamyo gui tano, mano nae y poliya yan y lamas uyinamag, yan y saque sija uyulang yan uchule; ");
INSERT INTO cha_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lao fannaetnon güinaja para jamyo gui langet, mano nae ni y poliya ni y lamas ti uyinamag, ya ni y saque sija ti uyulang yan ti uchule. ");
INSERT INTO cha_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sa manoja nae gaegue y güinajanmiyo, ayoja nae gaegue locue y corasonmiyo. ");
INSERT INTO cha_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Y candet y tataotao y atadog; yaguin y gasgas atadogmo, todo y tataotaomo ubula y manana. ");
INSERT INTO cha_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lao yaguin y taelaye na atadogmo, todo y tataotaomo jomjom, Sa yaguin y manana ni y gaegue guiya jago jomjom, jafa na gosdangculo na jinemjom! ");
INSERT INTO cha_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Taya ni uno siña sumetbe dos amo; sa jachatlie y uno, ya jaguflie y otro; pat jadalalag y uno ya jadespresia y otro. Ti siña jamyo insetbe si Yuus yan y güinaja. ");
INSERT INTO cha_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Enao mina jusangane jamyo: Chamiyo fanmanjajaso pot y jaaninmiyo; jafa para incano, pat jafa para inguimen; ni pot para innaminagago y tataotaomiyo. Ada ti bale mas y linâlâmo qui y nengcano, yan y tataotaomo qui y magago? ");
INSERT INTO cha_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Atanja y pajaro gui langet; ti manmanananon, ni ti manmangongoco, ni ti manmanrecocoje jalom gui camalin; sa si tatamoja gui langet munafañochocho. Ada ti mangaebalotña jamyo qui sija? ");
INSERT INTO cha_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ya jaye guiya jamyo, yaguin manjaso, siña jataluye y linecaña un codo? ");
INSERT INTO cha_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ya jafa jamyo na manmanjajaso pot magago? Jasoja y lirio sija gui fangualuan, jaftaemano manlâlâñiñija; ti manmachochocho ya ti manmajijila. ");
INSERT INTO cha_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lao jusangane jamyo, na si Salomon yan todo y minalagña, ti minagago parejo yan uno güine sija. ");
INSERT INTO cha_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yanguin si Yuus janaminagago y chaguan gui fangualuan; sa pago gaegue, ya agupa machule ya mapolo gui jetno, ada ti mas jamyo inninaminagago, taotao jamyo na didide jinengguenmiyo? ");
INSERT INTO cha_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Enao mina, chamiyo jumajaso umalog: Jafajit tacano, pat jafajit taguimen, pat jafajit magaguta? ");
INSERT INTO cha_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sa todo este sija na güinaja, jaaliligao y Gentiles; ya y tatanmiyo gui langet jatungoja na innesesita todo este sija na güinaja. ");
INSERT INTO cha_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lao aligao fenena y raenon Yuus, yan y tininasña; ya despues todo este sija na güinaja infanmataluye. ");
INSERT INTO cha_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chamiyo jumajaso y para agupa, sa y para agupa güiyaja güe ujaso. Basta para y cada y jaane y inalulaye. ");
INSERT INTO cha_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","CHAMIYO fanmanjusga para ti infanmajusga. ");
INSERT INTO cha_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sa taemanoja yan manmajusga yan manmañogne jamyo, taegüijija locue infanmajusga; ya taemanoja y minedidamiyo, taegüijija locue infanmamediye. ");
INSERT INTO cha_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sa jafa muna unlilie y migo gui atadog y chelumo, ya ti unjajaso y jayo gui atadogmo? ");
INSERT INTO cha_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jafa taemano unalog nu y chelumo: Maela ya junajanao enao y migo gui atadogmo; ya enagüija y jayo gui atadogmo? ");
INSERT INTO cha_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hipocrita! Najanao finenana y jayo gui atadogmo? ya ayo nae siña ungueflie yan para unnajanao y migo gui atadog y chelumo. ");
INSERT INTO cha_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Chamiyo numanae y galago nu y santos, ni inpelo y perlasmiyo gui menan y babue; sa no seaja ujagacha nu y patasñija ya ujabira sija ya infanyenabalag jamyo. ");
INSERT INTO cha_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Gagao ya infanmanae; aligao ya inseda; yajo ya infanmababaye. ");
INSERT INTO cha_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sa jayeja y mangagao, uresibe; ya y manaligao, usoda; ya y manyajo, umababaye. ");
INSERT INTO cha_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ya jayeja guiya jamyo, yaguin uguinagao nu y lajiña pan, ada unnae acho? ");
INSERT INTO cha_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pat yaguin uguinagao un güijan, ada unnae un serpiente? ");
INSERT INTO cha_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ombre manaelaye jamyo, intingo numae mauleg na ninae y famaguonmiyo; ada ti mas y tatanmiyo, ni y gaegue gui langet, unnae mauleg na güinaja todo ayo y gumagaogüe? ");
INSERT INTO cha_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Enao mina, jaftaemano y malagomiyo na y taotao ufatitinas nu jamyo, taegüijija infatitinas locue nu sija; sa este y lay yan y profeta sija. ");
INSERT INTO cha_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jalom gui maiot na potta, sa y feda na potta ya micanpo y chalan nu y jumananaogüe y finalingo, ya megae sija y fumapoposgüe. ");
INSERT INTO cha_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sa y maiot na potta ya dalalae na chalan y jumananaogüe y linâlâ, ya didide sija y sumosoda. ");
INSERT INTO cha_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Adaje jamyo nu y ti manmagajet na profeta, ni ufanmato guiya jamyo maninagagon quininilo, lao y sanjalomñija mangaegue lobo na mañaque. ");
INSERT INTO cha_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Injatingo pot y tinegchañija. Ada y taotao ufañule ubas guine y títucan jayo, pat igos guine y títucan chaguan? ");
INSERT INTO cha_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Taegüijija todo y mauleg na trongcon jayo, siempre mauleg tinegchaña; lao y taelaye na trongcon jayo, siempre taelaye tinegchaña. ");
INSERT INTO cha_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ti siña y mauleg na trongcon jayo manogcha taelaye; ni y taelaye na trongcon jayo manogcha mauleg. ");
INSERT INTO cha_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Todo y trongcon jayo ni ti manogcha mauleg, umautut ya umayute gui guafe, ");
INSERT INTO cha_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Enao mina pot y tinegchañija, injatingo. ");
INSERT INTO cha_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ti todo y umalog nu guajo: Señot! Señot! ujalom gui raenon langet; lao ayo y fumatinas y minalago y tatajo, ni y gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Megae, güije na jaane, ualog nu guajo: Señot! Señot! ada ti inprofetisa pot y naanmo, yan innajanao y anite pot y naanmo, yan infatinas megae námanman na chocho pot y naanmo? ");
INSERT INTO cha_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ya ayo nae jusangane sija, ni y magajet ti jutungo jamyo, fanjanao guiya guajo, jamyo manmamatitinas inechong. ");
INSERT INTO cha_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Enao mina jayeja y jumungog este sija y sinanganjo ya fumatinas, güiya parejo yan y méjnalom na taotao, na jafatinas y guimaña gui jilo acho; ");
INSERT INTO cha_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ya utunog y ichan, yan ufanmato y sadog, yan ufanmanguaefe y manglo, ya ubinate ayo na guma ya ti upodong, sa mafatinas gui jilo acho. ");
INSERT INTO cha_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lao jayeja y jumungog este sija y sinanganjo, ya ti fumatinas, güiya parejo yan y bábaba na taotao na jafatinas y guimaña gui jilo unae; ");
INSERT INTO cha_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ya utunog y ichan yan ufanmato y sadog, yan ufanmanguaefe y manglo ya ubinate ayo na guma, ya upodong; ya gosdangculo y pinedongña. ");
INSERT INTO cha_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ya susede, anae munjayan este sija jasangan si Jesus, ninafanmanman y linajyan taotao sija nu y doctrinaña. ");
INSERT INTO cha_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sa jafanagüe sija, calang uno ni gaeninasiña, lao ti calang y escriba sija. ");
INSERT INTO cha_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","YA anae tumunog güe guinin y sabana, madalalag güe dangculo na linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ya estagüe na mato un ategtog ya tinayuyut güe ilegña: Señot, yaguin malagojao, siña unnagasgas yo. ");
INSERT INTO cha_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ya jaestira y canaeña ya japacha ya ilegña: malagoyo, gasgasjao! Ya enseguidas y ategtog gasgas. ");
INSERT INTO cha_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ayo nae ilegña si Jesus: Adaje ya chamo fañangangane ni jaye; lao falag y pale ya unfanue nu jago, ya unchule y ninae ni manago si Moises para testimonioñija. ");
INSERT INTO cha_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ya anae jumalom si Jesus guiya Capernaum, mato guiya güiya un senturion guinagao güe, ");
INSERT INTO cha_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ya ilegña: Señot, y tentagojo gaegue guiyajame na umaason sa malango paralitico, ya gogosninachatsaga sa adit. ");
INSERT INTO cha_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ya ilegña nui guiya: Bae jufato ya junajomlo. ");
INSERT INTO cha_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lao senturion manope ya ilegña: Señot, ti siña na guajojao junafato gui papa atufjo, lao sanganja un palabra ya ujomlo y tentagojo. ");
INSERT INTO cha_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sa guajo locue un taotao gui papa ninasiña, ya guaja sendalojo gui papa ninasiñajo; ya yaguin ilegco nu este na taotao: Janao, ya jumanao; yan ilegco ni otro: Maela, ya mamaela, yan ilegco ni tentagojo: Chogüe este, ya jachogüe. ");
INSERT INTO cha_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ya anae jajungog si Jesus, ninamanman, ya ilegña nu y dumadalalag güe: Magajet jusangane jamyo, na tayayo nae mañoda ni este na dangculon jinenggue guiya Israel! ");
INSERT INTO cha_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya guajo sumangane jamyo, na ufanmato megae guine y sancatan, yan guine y sanlichan; ya ufanmatachong yan si Abraham yan si Ysaac yan si Jacob gui raenon langet; ");
INSERT INTO cha_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lao y famaguon y raeno ufanmayute gui sumanjiyong gui jemjom; ya ayo nae uguaja cumasao yan checheg nifen. ");
INSERT INTO cha_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Entonses si Jesus ilegña nu y senturion: Janao, parejoja y unjonggue, umafatinas guiya jago; ya y tentagoña jumonlo güije na ora. ");
INSERT INTO cha_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ya anae mato si Jesus gui guiman Pedro, jalie y suegran Pedro na umaason gui cama, sa guaja calenturaña. ");
INSERT INTO cha_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ya japacha canaeña; ya pinelo ni calentura: ya cajulo ya jasetbe sija. ");
INSERT INTO cha_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ya anae esta pupuenge, maconie güe megae na maninanite, ya janajanao guiya sija todo y anite pot y sinanganña, yan janafanjomlo todo y manmalango. ");
INSERT INTO cha_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Para umacumple y esta masangan pot y profeta Isaias, na ilegña: Güiya chumule y chetnotta yan cumacatga y pinitita. ");
INSERT INTO cha_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ya anae jalie si Jesus y linajyan taotao gui oriyaña, manago na ufanmalag y otro banda y sadog. ");
INSERT INTO cha_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ya mato un escriba ya ilegña nu güiya: Maestro, judalalag jao mano y malagomo guato. ");
INSERT INTO cha_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ya si Jesus ilegña nu güiya: Y sora sija guaja liyangñija, ya y pajaro gui langet guaja chenchonñija: lao y Lajin taotao taya mano nae unaason y iluña. ");
INSERT INTO cha_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ya otro uno gui disipuluña ilegña nu güiya: Señot, nae yo lisensia ya jujanao finena ya jujafot y tatajo. ");
INSERT INTO cha_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ya si Jesus ilegña nu güiya: Dalalag yo; ya polo ya y manmatae ufanjinafot ni y mangaematae. ");
INSERT INTO cha_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ya anae jumalom gui un sajyan, y disipuluña sija madalalag güe. ");
INSERT INTO cha_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ya dangculo na pagyo mato gui tase ya y sajyan tinatampe nu y napo sija; ya güiya mamaegoja. ");
INSERT INTO cha_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ya manmato guiya güiya y disipuluña ya mayajogüe ilegñija: Señot, nafanlibrejam sa manmalingojam! ");
INSERT INTO cha_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Güiya ilegña nu sija: Jafa na manmaañao jamyo, taotao na didide jinengguenmiyo? Ayo nae cajulo ya jachoma y manglo yan y tase, ya dangculo na minalinao guaja. ");
INSERT INTO cha_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ya y taotao sija manmanman, ya ilegñija; jafa este na taotao na y manglo yan y tase maoosgueja güe? ");
INSERT INTO cha_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ya anae mato gui otro banda gui tano y taotao Gadara sija, umasoda yan dos na gaemanganite na manguine y naftan, yan mangosnamaañao y jechurañija; ya taya siña malofan güije na chalan. ");
INSERT INTO cha_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ya estagüe, na manaagang ilegñija: Para jafajam nu jago Lajin Yuus? Matojao güine para usapetjam antes di y tiempo? ");
INSERT INTO cha_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ya chago guiya sija estaba un manada na gosmegae na babue mañochocho. ");
INSERT INTO cha_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Y anite sija matayuyutgüe ilegñija: Yaguin unyutejam juyong, najanaojam na fanmalag ayo y babue sija. ");
INSERT INTO cha_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ya ilegña nu sija: Janao. Ya sija manjuyong ya, manmalag gui jalom y manadan babue; ya, estagüe, todo y babue manmalago papa gui un didog na lugat, asta y jalom tase, ya manmatae gui janom tase. ");
INSERT INTO cha_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Y munafañochocho y babue manmalago ya manmalag y siuda, ya jasangan todo y guaja, ya jafa susede yan y mangaemanganite. ");
INSERT INTO cha_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ya, estagüe, todo y siuda manjanao para ufanasoda yan si Jesus, ya anae maliigüe, matayuyutgüe na ujanao gui tanoñija. ");
INSERT INTO cha_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","YA jumalom gui un batco, mapos güe, ya malag y otro banda ya mato gui suidaña. ");
INSERT INTO cha_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ya, estagüe, sija na manmangongone güe un malango, umaason gui cama sa paralitico; ya anae jalie si Jesus y jinenggueñija, ilegña nu y paralitico: Angoco lajijo; y isaomo unmaasie. ");
INSERT INTO cha_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ya estagüe sija palo escriba na ilegñija gui sanjalomñija: Este chumatfino contra si Yuus. ");
INSERT INTO cha_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ya anae jatungo si Jesus y jinasoñija, ilegña: Jafa na manmanjajaso jamyo taelaye gui corasonmiyo? ");
INSERT INTO cha_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sa jafa mas guse masangan: Y isaomo unmaasie: pat masangan: Cajulo ya unfamocat? ");
INSERT INTO cha_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lao para intingoja na y Lajin taotao guaja ninasiñaña, gui jilo tano, para umaasie isao; (ayo nae ilegña nu y paralitico), Cajulo, chule y camamo ya unjanao para iyajamyo. ");
INSERT INTO cha_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ayo nae cajulo ya mapos para iyasija. ");
INSERT INTO cha_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ya anae malie nu y linajyan taotao, ninafanmanman, ya manamalag si Yuus, sa mannae nu ayo na ninasiña gui taotao sija. ");
INSERT INTO cha_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ya anae malofan si Jesus güije, jalie un taotao na matatachong gui bancon y tributo, na y naanña si Mateo, ya ilegña nu güiya, Dalalagyo. Ya cajulo ya dinalalag güe. ");
INSERT INTO cha_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ya susede anae estaba güe, matachong chumochocho gui jalom guma, estagüe, sija megae na publicano yan manisao, manmato ya mañija manmatachong gui lamasa yan si Jesus yan y disipuluña sija. ");
INSERT INTO cha_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ya anae malie este nu y Fariseo sija, ilegñija nu y disipuluña: Sa jafa y maestronmiyo na mañisija mañocho yan y publicano yan y manisao? ");
INSERT INTO cha_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lao anae jajungog ayo, ilegña: Y manaechetnot ti janesesita medico: lao y manmalango. ");
INSERT INTO cha_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Janao ya inquetungo jafa este: Minaase malagojo, ya ti inefrese; sa ti mato yo para juaagang y manunas, lao y manisao para ufanmañotsot. ");
INSERT INTO cha_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ayo nae y disipulon Juan manmato guiya güiya ya ilegñija: Jafa jame yan y Fariseo sija na manayuyunat megae; ya y disipulumo ti manayuyunat? ");
INSERT INTO cha_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ya ilegña si Jesus nu sija: Siña y mangachong y nobio, mantriste yaguin mañisijaja yan y nobio? Lao ufato y jaane, na y nobio umacone guiya sija, ya ayo nae ufanayunat. ");
INSERT INTO cha_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Taya ni un taotao lumimendanñaejon y nuebo na magago gui mamagagonñañajeon ni y bijo; sa ayo na lemenda usuja gui magago, ya y minatitegña sentaelaye. ");
INSERT INTO cha_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni umasajguane locue y nuebo na bino gui bijo na boteyan cuero sa y boteyan cuero umafag ya umachuda y bino, ya manmalingo y boteyan cuero; lao umasajguane y nuebo na bino gui nuebo na boteyan cuero, ya uchamaog y dos. ");
INSERT INTO cha_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mientras jasangangane sija ni este, estagüe, un magas na mato ya inadoragüe ilegña: Y jagajo matae tiampmanja; lao nije ya maela ya unpolo y canaemo gui jiloña ya ulâlâ. ");
INSERT INTO cha_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ya cajulo si Jesus ya dinalalag güe, yan y disipuluña locue. ");
INSERT INTO cha_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ya, estagüe, un palaoan na malango nu y minilalag y jâgâ, esta dose años, mato gui tateña ya japacha y madoblan y magaguña; ");
INSERT INTO cha_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sa ilegña gui sumanjalomña: Yaguin jupachaja y magaguña, jujomlo. ");
INSERT INTO cha_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lao si Jesus jabiragüe ya anae malie güe ilegña: Jagajo, angoco, y jinengguemo unninajomlo. Ya y palaoan ninajomlo desde ayo na ora. ");
INSERT INTO cha_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ya anae mato si Jesus gui guima ayo na magas, ya jalie y mandadandan nu y flauta yan y taotao sija manboruruca, ");
INSERT INTO cha_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ylegña: Fañuja; sa y patgon palaoan ti mamatae, lao mamaego. Ya mabutleagüe. ");
INSERT INTO cha_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lao y taotao sija anae mañuja, güiya mapos jalom, ya jamantiene canaeña; ya y patgon palaoan cajulo. ");
INSERT INTO cha_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ya malofan este na fama todo güije na tano. ");
INSERT INTO cha_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Anae mafapos si Jesus güije, madalalag güe dos taotao na bachet na umaagang ilegñija: Gaease nu jame, jago, Lajin David. ");
INSERT INTO cha_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ya anae mato guato gui jalom guma, manmato guiya güiya y dos bachet, ya si Jesus ilegña nu sija: Injenggue na guajo siña jufatinas este? Ya sija ilegñija: Junggan Señot. ");
INSERT INTO cha_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ayo nae japacha y atadogñija ya ilegña: Parejoja y jinengguenmiyo umafatinas. ");
INSERT INTO cha_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ya y atadogñija manmababa. Ya si Jesus jagosencatga ilegña. Adaje ya chamiyo munatutungo ni uno. ");
INSERT INTO cha_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lao anae manmapos sija, manafamta y famaña todo güije na tano. ");
INSERT INTO cha_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ya anae manmapos sija; estagüe, machule guiya güiya un taotao na udo, na gaeanite. ");
INSERT INTO cha_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Anae ninajanao y anite y udo cumuentos. Ya y linajyan taotao ninafanmanman ya ilegñija: Taya este nae malie guiya Israel. ");
INSERT INTO cha_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lao y Fariseo sija ilegñija: Pot y ninasiña y prinsipen anite, janajanao y anite sija. ");
INSERT INTO cha_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ya jalilicue si Jesus todo y siuda sija yan y sengsong, mamananagüe gui guima Yuusñija, ya jasesetmon y ebangelion y raeno, yan janafanmamagong todo y chetnot yan todo y pinite gui taotao sija. ");
INSERT INTO cha_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Anae jalie y linajyan taotao, ninamaase nu sija, sa manadingo ya manmachalapon calang y quinilo nu y taya pastotñija. ");
INSERT INTO cha_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ayo nae ilegña nu y disipuluña: Magajet na y cosecha megae: lao y manfáfachocho didide. ");
INSERT INTO cha_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tayuyut y Señot y cosecha ya utago y manfáfachocho gui cosechaña. ");
INSERT INTO cha_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","AYO nae jaagang y dose na disipuluña, ya janae ninasiñañija contra y manaplacha na espiritu, para ujayute juyong; yan unafanmagong todo y chetnot, yan todo y manpinite. ");
INSERT INTO cha_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ya y naan y dose apostoles sija este sija: Y finenana, si Simon na mafanaan si Pedro, yan si Andres cheluña: si Santiago, lajin Sebedeo, yan si Juan cheluña; ");
INSERT INTO cha_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Si Felipe, yan si Bartolome; si Tomas, yan si Mateo y publicano; si Santiago, lajin Alfeo, yan si Lebeo, na y apiyiduña si Tadeo; ");
INSERT INTO cha_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Si Simon Selote, yan si Judas Iscariote, ni y umintrega güe locue. ");
INSERT INTO cha_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Este y dose sija mantinago as Jesus na ufanjanao ya maninencatga ilegña: Chamiyo fanmalag y chalan y Gentiles; yan y siuda y Samaritano sija chamiyo fanjajalom: ");
INSERT INTO cha_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lao gosmauleg para ufanmalag y malingo na quinilo gui guima Israel. ");
INSERT INTO cha_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Anae manjanao jamyo, setmon ya alog: Y raenon langet mato jijot. ");
INSERT INTO cha_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nafanjomlo y manmalango, nafan gasgas y manategtog, nafangajulo y manmatae, nafanjanao y anite sija: pot grasia na inresibe, fanmannae pot grasia. ");
INSERT INTO cha_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Chamiyo fannanaetnon oro ni salape ni coble gui betsanmiyo; ");
INSERT INTO cha_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni tengguang para y chalan, ni dos na magago ni sapatos, ni baston; sa y fafáchocho jamerese y nengcanoña. ");
INSERT INTO cha_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yan todo na siuda, pat songsong na manjalom jamyo, guesaligao jaye mumerese, ya fañaga güije asta qui para infanjanao. ");
INSERT INTO cha_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yaguin manjalom jamyo gui guima, saluda. ");
INSERT INTO cha_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yaguin y guima jamerese, y pasmiyo usaga guiya güiya; lao yaguin ti jamerese, y pasmiyo utaloja guato guiya jamyo. ");
INSERT INTO cha_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ya jayeja y ti rumesibe jamyo, yan ti jaecungog y sinanganmiyo, fanjanao güije na guma pat suida, ya insacude contra sija todo y petbos gui adengmiyo. ");
INSERT INTO cha_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Magajet jusangane jamyo: Y mas mauleg para y tano Sodoma yan Gomora gui jaanin sentensia, qui para ayo na siuda. ");
INSERT INTO cha_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Estagüe, na guajo jamyo tumago, calang quinilo gui entalo lobo sija; fanmalate calang y serpiente sija, yan y fanmanso calang y paluma sija. ");
INSERT INTO cha_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Adaje jamyo nu y taotao sija; sa infaninentrega gui inetnon ofisiat, ya infanmasaolag gui sinagogañija; ");
INSERT INTO cha_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ya infanmacone guato gui menan magalaje yan ray pot y naanjo, para testimonio contra sija yan y Gentiles. ");
INSERT INTO cha_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lao yaguin manmaentrega jamyo, chamiyo jumajaso jafa para insangan; so ayoja na ora infanmanae jafa para insangan. ");
INSERT INTO cha_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sa ti jamyo infanguentos, lao y Espiritun y Tatanmiyo ni y cumuecuentos gui jalommiyo. ");
INSERT INTO cha_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Y cheloja uinentrega y cheluña para umapuno, ya y tata y lajiña: ya y famaguon ufangajulo contra tatañija, ujanamapuno. ");
INSERT INTO cha_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ya todo infanchinatlie pot y naanjo; lao y sumigue asta y uttimo, güiya ucajulo gui langet. ");
INSERT INTO cha_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lao yaguin manmapetsigue jamyo gui un suida, fanmalag y otro: sa magajet jusangane jamyo, na ti infanmunjayan manjanao todo gui siudan Israel, asta qui mato y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Y disipulo, ti dangculoña qui y maestro, yan y tentago qui y amuña. ");
INSERT INTO cha_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bastaja y disipulo yaguin parejoja y maestruña, ya y tentago yaguin parejoja y amuña. Sa yaguin y tata gui guima mafanaan Beetsebub, cuanto mas y familiana? ");
INSERT INTO cha_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Chamiyo fanmaañao; sa taya matatampe, para ti umalie: yan manaatog para ti umatungo. ");
INSERT INTO cha_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Todo sija y jusangane jamyo gui jemjom, sanganñaejon gui manana: ya todo sija y injingog gui talanga, sanganñaejon desde y jilo guma. ");
INSERT INTO cha_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ya chamiyo fanmaañao ni upinino y tataotao; sa ti siña japuno y ante: lao fanmaañaoñao ni ayo y siña yumute y tataotao yan y ante guato guiya sasalaguan. ");
INSERT INTO cha_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ada ti mabende dos gorrión na pájaro pot un coble? yan ni uno guiya sija upodong gui tano sin utungo si tatanmiyo. ");
INSERT INTO cha_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Y gaponulonmiyo locue esta todo manmatufong. ");
INSERT INTO cha_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chamiyo fanmaañao; sa mas manbaliñaja jamyo qui y megae na pájaro. ");
INSERT INTO cha_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jayeja y sumanganyo gui menan taotao, güajo locue jusangangüe gui menam y tatajo ni gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ya jayeja y pumuneyo gui menan taotao sija, guajo locue jupune güe gui menan y tatajo ni y gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Chamiyo jumajaso na mato yo para jupolo pas gui tano: ti matoyo para jupolo pas, lao espada. ");
INSERT INTO cha_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sa mato yo para jupolo inaguaguat y laje contra y tataña, ya y jaga contra y nanaña, ya y yetna contra y suegraña. ");
INSERT INTO cha_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ya y enemigoñija mangaegueja guiya sija. ");
INSERT INTO cha_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Y gumaeya y tataña pat y nanaña mas qui guajo, ti ufanmerese nu guajo; ya y gumaeya y lajiña pat y jagaña mas qui guajo, ti ufanmerese nu guajo. ");
INSERT INTO cha_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ya, y ti chumule y quiluusña ya udalalagyo, ti ufanmerese nu guajo. ");
INSERT INTO cha_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Y sumoda y linâlâña, ufinalingaeguan; ya y finalingaeguan ni y linâlâña pot y naanjo, güiya usoda. ");
INSERT INTO cha_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Y rumisibe jamyo, jaresibeja yo; ya y rumisibeyo, jaresibeja y tumagoyo. ");
INSERT INTO cha_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Y rumesibe un profeta pot y naan profeta, uresibe y premion profeta; ya y rumesibe y taotao tunas pot y naan y taotao tunas, uresibe y premion y taotao tunas. ");
INSERT INTO cha_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ya masquesea jayeja y numae uno güine nu este sija y mandiquique, unoja bason janom ni y fresco, pot y naan y disipulo, magajet jusangane jamyo na ti ufalingo y premiuña. ");
INSERT INTO cha_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","YA anae munjayan jatago si Jesus y dose disipuluña, jumanao para ufamanagüe, yan usetmom gui siudañija. ");
INSERT INTO cha_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Anae jajungog si Juan, gui guima presuña, y finatinas Jesucristo; jatago. dos gui disipuluña, ");
INSERT INTO cha_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ya ilegña: Jago ayo y para ufato pat infanmannanggajam otro? ");
INSERT INTO cha_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ya manope si Jesus ilegña: Janao ya innatungo si Juan todo ni y liniimiyo yan y jiningogmiyo. ");
INSERT INTO cha_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Y bachet manmanlie, y mancojo manmamocat, y manategtog mangasgas, y mananga manmanjungog: y manmatae manafangajulo ya y mamoble manmasangane ni y evangelio. ");
INSERT INTO cha_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ya dichoso y ti sumasoda lugat para umatompo guiya guajo. ");
INSERT INTO cha_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Anae manmapos sija, jatutujon si Jesus sumangan si Juan gui linajyan taotao. Jafa injanagüe jamyo para inlie gui desierto? un trongcon piao na ninamayeyengyong ni y manglo? ");
INSERT INTO cha_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pat, jafa injanagüe jamyo para inlie? un taotao na minagagon fino na magago? Estagüe, sija y manminagagon fino na magago, mangaegue gui guima y ray sija. ");
INSERT INTO cha_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lao pot jafa injanagüe jamyo? Para inlie un profeta? Junggan, jusangane jamyo, mas qui y profeta. ");
INSERT INTO cha_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sa este yuje y munjayan matugue: Estagüe na junajanao y taotao y tinagojo gui menan matamo, para ufamauleg y chalanmo gui menamo. ");
INSERT INTO cha_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Magajet jusangane jamyo, na ti ucajulo gui entalo y manmafañañago gui famalaoan, uno mas dangculo qui si Juan Bautista; lao y mas diquique gui raenon langet mas dangculo qui güiya. ");
INSERT INTO cha_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ya desde y jaanin Juan Bautista asta pago, y raenon langet gaeninasiña; ya y manmatatnga sija uamot. ");
INSERT INTO cha_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sa todo y profeta sija, yan y lay, japrofetisa asta si Juan. ");
INSERT INTO cha_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","An manmalago jamyo inresibe; güiya si Ilias ni y umamaela. ");
INSERT INTO cha_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Y gaetalanga para unfanjungog, güiya ujungog. ");
INSERT INTO cha_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Lao jaye nae juacompara este na rasa? Manparejo yan y famaguon ni manmatatachong gui plasa ya jaagang y mangachongñija, ");
INSERT INTO cha_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ya ilegñija: Indandane jamyo flauta, ya ti manbaela jamyo, manuugong jamyo lao ti manatanges jamyo. ");
INSERT INTO cha_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sa mato si Juan ya ti chumocho ni gunimen, ya ilegñija: Gaeanite güe. ");
INSERT INTO cha_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ya mato y Lajin taotao ya chumocho yan gumimen, ya ilegñija: Estagüe un taotao na gachumocho, yan gagumimem, amigon y publicano sija yan y manisao; lao y tiningo manacabales ni y finatinasña. ");
INSERT INTO cha_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ayo nae jatutujon lumalalatde y siuda sija nae guinin jafatinas sumenmegae na namanman Sa ti manmanjonggue, ilegña: ");
INSERT INTO cha_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ayjao, Corasin! Ayjao, Betsaida! sa yaguin iya Tiro yan Sidon nae mafatinas ayo y mannamanman ni y mafatinas guiya jamyo, esta jagas manmañotsot gui silisio yan apo. ");
INSERT INTO cha_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lao guajo sumangane jamyo, na mas songunon Tiro yan Sidon qui para jamyo gui jaanin y sentensia. ");
INSERT INTO cha_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya jago, Capernaum, ni y jagas manataquito jao asta y langet; unmayute jao papa sasalaguan; sa yaguin iya Sodoma nae mojon mafatinas todo ayo y mannamanman ni jagas mafatinas guiya jago, mangagaegueja mojon asta pago na jaane. ");
INSERT INTO cha_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lao guajo sumangane jamyo; na y mas songunon tano Sodoma, qui para jago gui jaanin y sentensia. ");
INSERT INTO cha_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ayo na tiempo nae, manope si Jesus ilegña: Grasias junaejao, Tata, Señot y langet yan y tano, sa unnafanatog estesija gui manmalate yan manmejnalom, ya unfanue y famaguon. ");
INSERT INTO cha_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Taegüenaoja Tata: sa taegüenao y mauleg gui liniimo. ");
INSERT INTO cha_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Todo y güinaja jaentrega yo si Tata; ya taya tumungo y Lajiña na si Tataja: ni taya tumungo, si Tata na y lajiñaja, ya ayoja y lajiña malagoña unafanungo. ");
INSERT INTO cha_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maela guiya guajo todo y manyayas, yan y menoson, ya guajo junafandescansa. ");
INSERT INTO cha_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Polo y yugojo gui jilomiyo, ya infaneyag guiya guajo, sa guajo manso yan umitde gui corasonjo; ya infanmañoda descanso para y antinmiyo. ");
INSERT INTO cha_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sa y yugojo mañana, ya y catgaco ñajlalang. ");
INSERT INTO cha_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","AYO na tiempo nae jumajanao si Jesus un sabalo na jaane gui entalo mais ya y disipuluña manñalang, ya jatutujon manmañule ni espiga ya jacano. ");
INSERT INTO cha_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ya anae jalie y Fariseo sija, ilegñija: Estagüe y disipulumo na jafatitinas y ti mauleg para umafatinas gui sabalo na jaane. ");
INSERT INTO cha_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ya güiya ilegña nu sija: Ada ti untaetae, jafa finatinasña si David, anae ñalang yan y mangachogña? ");
INSERT INTO cha_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jaftaemano jumalom gui guimayuus, ya jacano y pan proposision sija, na ti cabales güiya ucano, ni y mangachongña; lao para y mamaleja? ");
INSERT INTO cha_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pat, ada ti untaetae gui lay, na y jaanin y sabado, gui templo y mamale sija japrofana y sabado, ya taya isaoñija? ");
INSERT INTO cha_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Guajo sumangane jamyo, uno mas dangculo qui y templo gaegue güine. ");
INSERT INTO cha_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lao yaguin intingo jafa este ilelegña, Minaase malagojo, ti inefrese, ti insangan mojon contra y manaeisao. ");
INSERT INTO cha_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sa y Señot y sabado y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ya anae jumanao güije malag y gumayusñija; ");
INSERT INTO cha_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ya estagüe un taotao na majlog y canaeña; ya mafaesen ilegñija: Ada mauleg para jita na infanamte gui sabado? para umafaaela güe. ");
INSERT INTO cha_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ya güiya ilegna: Jafa taotao guaja gui entalo miyo yaguin guaja un quinilo na podong gui joyo, gui jaanin sabalo, ada ti uestira y canaeña ya jochule? ");
INSERT INTO cha_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ada ti mas baliña un taotao qui un quinilo? Pot este, cabales na umafatinas mauleg gui jaanin sabado. ");
INSERT INTO cha_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ayo nae ilegña ni y ayo na taotao: Juto y canaemo; ya jajuto ya finamauleg talo parejo yan y otro. ");
INSERT INTO cha_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ayo nae y Fariseo sija manjanao, ya manafaesen entre sija contra güiya para umapuno güe. ");
INSERT INTO cha_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lao anae jatungo ai Jesus, mapos güije; ya madalalag güe linajyan taotao, ya janafanjomlo todosija. ");
INSERT INTO cha_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ya güiya guefmanencatga, na chañija munamatutungo güe. ");
INSERT INTO cha_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Para umacumple y esta munjayan masangan pot y profeta Isaias, ilegña: ");
INSERT INTO cha_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Estagüiya y tentagojo ni y juayig, y güinaeyaco ni y janamagof y antijo: na jupoluye ni y Espiritujo gui jiloña, ya jasangane Gentiles y juisio. ");
INSERT INTO cha_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ti upotfia, ni uagang; ya taya ni uno ujiningog y inagangña gui chalan. ");
INSERT INTO cha_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ti umayulang y piao ni mayamag ni umapuno y mechan dangis ni y aasa asta qui machule y juisio para y guinana. ");
INSERT INTO cha_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ya pot y naanña, manmannanangga y Gentiles. ");
INSERT INTO cha_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ya machuliegüe guato un inanite, na bachet yan udo, ya janajomlo; ayo nae cumuentos y udo yan manlie. ");
INSERT INTO cha_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ya todo y taotao sija ninafanmanman, ya ilegñija: Ada ti este yuje y lajin David? ");
INSERT INTO cha_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lao y Fariseo sija jajungog ya ilegñija: Este ti uyute juyong y anite, yaguin ti pot Beetsebub, magas y anite sija. ");
INSERT INTO cha_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ya si Jesus, anae jatungo y jinasoñija, ilegña: Todo y raeno umadibide contra güiyaja uyulang; ya cada guma, pat siuda, umadibide contra güiyaja, ti usaga. ");
INSERT INTO cha_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Yaguin si Satanas jayute juyong si Satanas, güiya umadibide contra güiyaja, ya jaftaemano y raenoña sumaga? ");
INSERT INTO cha_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yanguin guajo pot si Beetsebub juyuyute juyong y anite sija; pot jaye y famaguonmiyo, fanyinite sija juyong? Pot ayo, sija ufanjuesmiyo. ");
INSERT INTO cha_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yanguin pot y Espiritun Yuus, juyute juyong y anite sija, magajet na esta mato guiya jamyo y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Sajafa? Jaftaemano siña un taotao jumalom gui guima y matatnga na taotao ya uyulang todo y güinajaña, yanguin ti jagode finenana y matatnga? Ayo nae siña jayulang y guimaña. ");
INSERT INTO cha_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Y ti jumajame, contrariujo güe; ya y ti rumecoje güe guiya guajo, güiya umachalapon. ");
INSERT INTO cha_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pot enao na jusangane jamyo: Todo isao yan y chatfino contra si Yuus, umasie y taotao sija; lao y chatfino contra y Espiritu, ti umaasie y taotao. ");
INSERT INTO cha_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ya jayeja y cumuentos contra y Lajin taotao, umaasie; lao jayeja y cumuentos contra y Espiritu Santo, ti umaasie, ni este na tiempo, ni y ayo na mamamaela. ");
INSERT INTO cha_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Fatinas mauleg na trongcon jayo, yan y tinegchaña mauleg; pat fatinas taelaye na trongcon jayo, yan taelaye y tinegchaña; sa pot y tinegchaña, y jayo esta matungo. ");
INSERT INTO cha_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","O rasan culebla! jafa taemano jamyo na manaelaye siña manguentos mauleg, lo sa gui minegae y guaja gui corason, sinasangan y pachot. ");
INSERT INTO cha_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Y mauleg na taotao, nu y mauleg na güinaja gui corasonña, mauleg chinileleña; lao y taelaye na taotao, nu y taelaye na güinaja gui corasonña, taelaye chinileleña. ");
INSERT INTO cha_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lao guajo sumangane jamyo, na todo y finijo na taesetbe ya jasasangan y taotao sija, janesesita ufanmannae cuenta gui jaanin y sentensia. ");
INSERT INTO cha_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sa pot y finomo na unmanatunas jao, yan pot y finomo na unmasentensia jao. ");
INSERT INTO cha_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ayo nae manmanope y escriba yan y Fariseo sija ilegñija: Maestro manmalagojam na inlie un señatmo. ");
INSERT INTO cha_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ya güiya manope ilegña nu sija: y generasion manaelaye yan manábale manmanaliligao y señat, lao taya señat ufanmanae, na y señat Jonas profeta. ");
INSERT INTO cha_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa taegüenaoja si Jonas sumaga tres na jaane yan tres na puenge gui jalom y tiyan y bayena, ayo locue mina y Lajin taotao, usaga tres na jaane yan tres na puenge gui jalom corason y tano. ");
INSERT INTO cha_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y taotao Ninibe ufangajulo gui juisio yan este na generasion, ya ufanmasentensia, sa sija manmañotsot ni y setmon Jonas; ya estagüeja, uno güine na lugat na mas dangculo qui si Jonas. ");
INSERT INTO cha_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y raena gui sancatan ucajulo gui juisio yan este na generasion ya ufanmasentensia, sa mato guine y uttimon tano, para uecungog y tiningo Salomon, ya estagüeja uno güine na lugat na mas dangculo qui si Salomon. ");
INSERT INTO cha_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yanguin y áplacha na espiritu jumanao gui taotao, mamomocat gui anglo na lugat, ya jaaliligao nae udescansa, lao ti mañoda. ");
INSERT INTO cha_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ayo nae ilegña: Jutalo guato para y iyajame ni anae guine ayoyo. Ya anae mato guato, jasoda taesinajguan, binale yan maadotna. ");
INSERT INTO cha_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ayo nae mapos, ya mangone talo gachongña siete na espiritu na mas taelaye qui güiya, ya manjalom ya mañaga güije; ya mas taelaye uttimoña yuje na taotao qui y finenaña. Taegüineja locue ujumuyong este na generasion y manaelaye. ");
INSERT INTO cha_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ya anae estaba güe cumuecuentos yan y taotao sija; estagüe, si nanaña, yan y mañeluña mangaegue gui sumanjiyong, na manmalago na umacuentuse güe. ");
INSERT INTO cha_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ya ilegña uno: Estagüe, si nanamo, yan y mañelumo gui sumanjiyong, na manmalago na umacuentuse jao. ");
INSERT INTO cha_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ya güiya jaope ayo y sumangan este, ya ilegña: Jaye nanajo yan jaye mañelujo? ");
INSERT INTO cha_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ya jajuto y canaeña gui disipuluña, ya ilegña: Estagüe, y nanajo yan y mañelujo. ");
INSERT INTO cha_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sa todo ayo y fumatinas y minalago y Tatajo ni y gaegue gui langet, este güiya chelujo laje, yan chelujo palaoan, yan nanajo. ");
INSERT INTO cha_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","AYO na jaane, jinanaoña si Jesus gui guima, matachong gui oriyan tase. ");
INSERT INTO cha_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ya mato guiya güiya dangculo na linajyan taotao; ya jumalom güe gui un batco, ya matachong; ya todo y linajyan taotao manmatachong gui oriyan unae. ");
INSERT INTO cha_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ya jacuentuse sija megae na acomparasion, ilegña: Estagüe y tátanom na jumuyong para ufananom. ");
INSERT INTO cha_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ya anae manananom, palo gui semiya manpodong gui oriyan chalan, ya manmato y pájaro sija ya macano. ");
INSERT INTO cha_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Palo gui semiya manpodong gui jilo acho na lugat, na ti megae odaña; ya doco ti apmam, sa ti tadong papa gui eda. ");
INSERT INTO cha_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lao anae manina y atdao, mansinenggue sa taejale, ya ninamalayo. ");
INSERT INTO cha_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ya palo mamodong gui entalo títuca sija ya mandoco y títuca ya chiniguet. ");
INSERT INTO cha_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ya palo manpodong gui mauleg na oda, ya manmanogcha; y uno siento, y otro sesenta, y otro treinta. ");
INSERT INTO cha_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Y gaetalanga para ufanjungog, güiya ujungog. ");
INSERT INTO cha_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ayo nae manmato y disipuluña sija ya ilegñija: Jafajao na cumuecuentuse sija pot acomparasion sija? ");
INSERT INTO cha_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ya güiya manope ilegña. Sa esta manmanae jamyo, para intingo y misterion y raenon langet, lao sija ti ufanmanae. ");
INSERT INTO cha_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sa jayeja y guaja, umanae para uguaja mas; lao ayo y taya iyoña, achog uguaja y iyoña, umachule. ");
INSERT INTO cha_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Enaomina jucuentuse sija pot acomparasion; sa y manmanaatan, ya ti manmanlie, ya manecungog, ya ti manmanjujungog, ni ujatungo. ");
INSERT INTO cha_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Y ya sija nae umacumple y sinangan Isaias ni ilegña: Anae manmanjujungog, ujungog ya ti utungo; ya anae manmanaatan, ufanmanlie, ya ti ujasiente. ");
INSERT INTO cha_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sa y corasonñija este na taotao sija manmacat, ya y talangañija mapot manmanjungog, ya y atadogñija jajujuchom; para chañija fanmanlilie ni atadogñija, yan ufanmanjungog ni talangañija, ya ujatungo ni corasonñija, ya ujatolaeca sija, ya guajo junajomlo sija. ");
INSERT INTO cha_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Lao mandichoso y atadogmiyo, sa manmanlie, yan y talanganmiyo sa manmanjungog. ");
INSERT INTO cha_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sa magajet jusangane jamyo, na megae na profeta, yan manunas na taotao jagasja manmalago na ujalie y liniinmiyo, ya ti jalie; yan ujajungog y jiningogmiyo, ya ti jajungog. ");
INSERT INTO cha_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ecungog jamyo y acomparision y tátanom. ");
INSERT INTO cha_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jayeja y umecungog y sinangan y raeno, ya ti jatungo, mato y Taelaye ya janajanao y esta matanme gui corasonña. Este yuje semiya ni y pedong gui oriyan chalan. ");
INSERT INTO cha_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ya ayo y matanme gui jilo acho na lugat, este yuje y jumungog y sinangan, ya jaresibe ni y minagofña. ");
INSERT INTO cha_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lao taya jale guiya güiya, ya gaegue un ratoja; sa anae mato y triniste yan minamajlao pot causan di y sinangan, ti apmam matompo gui isao. ");
INSERT INTO cha_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ya ayo y matanme gui entalo títuca sija; este yuje y jumungog y sinangan; lao y inadajiña ni y tano, yan dinague ni güinaja, jañucot y sinangan ya sumaga sin tinegchaña. ");
INSERT INTO cha_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lao ayo y matanme gui mauleg na oda; este yuje y jumungog y sinangan ya jatungo, ya manogcha locue; ya y tinegchaña y uno siento, ya y otro sesenta, ya y otro treinta. ");
INSERT INTO cha_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Otro acomparasion jasangane sija ilegña: Y raenon langet parejoja yan un taotao ni manananom gui fangualuanña, mauleg na semiya. ");
INSERT INTO cha_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ya y tiempo nae manmamaego y taotao sija, mato y enemigo ya jatanme y taelaye na chaguan gui entalo y trigo, ya mapos. ");
INSERT INTO cha_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ya anae mandoco y trigo ya manmanogcha, y taelaye na chaguan mandoco locue. ");
INSERT INTO cha_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ya manmato y tentago y tatan familia ya ilegñija nu güiya: Señot, ada ti mauleg na semiya tinanommo gui fangualuanmo? Jafa mina guaja taelaye na chaguan? ");
INSERT INTO cha_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ylegña nu sija: Un enemigo fumatinas este. Ya y tentagoña ilegñija nu güiya: Malagojao ya infanjanao ya inchile? ");
INSERT INTO cha_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ylegña: Munga, sa no sea yaguin inchile y taelaye na chaguan, innabineog locue y trigo. ");
INSERT INTO cha_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Polo ya ufandaña mandoco sija na dos asta y quineco; an mato y tiempon quineco, bae jualog ni para ufanmangoco: Chile finena y taelaye na chaguan, ya inguede famanojo para umasonggue; ya y trigo polo gui jalom y camalinjo. ");
INSERT INTO cha_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Otro acomparasion sinangane sija ilegña: Y raenon langet parejoja yan y pepitas y mostasa, ni jachule un taotao ya jatanme gui fangualuanña. ");
INSERT INTO cha_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Magajet na güiya mas diquique gui todo y semiya sija; lao anae esta mandoco, güiya mas dangculo gui manmagogulae, ya mamatrongconjayo, ya manmato sija y pájaron y aire, ya manmamatinas y chenchon gui ramasña. ");
INSERT INTO cha_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Otro acomparasion sinangane sija ilegña: Y raenon langet, parejoja yan y libadura, ni y un palaoan jachule ya janana gui tres medidan arina, asta qui todo manbolacho. ");
INSERT INTO cha_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Todo estesija jasangan si Jesus pot acomparasion gui linajyan taotao; ya taya jasangane sija sin acomparasion. ");
INSERT INTO cha_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Para umacumple y munjayan masangan pot y profeta na ilegña: Jubaba y pachotto pot acomparasion: ya jusangan güinaja sija ni manafanatog desde y plinantan y tano. ");
INSERT INTO cha_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ayo nae jadingo y linajyan taotao ya mapos, ya jumalon gui guima; ya manmato guiya güiya y disipuluña sija, ya ilegñija: Naclaruyejam ni y acomparasion y taelaye na chaguan gui fangualuan. ");
INSERT INTO cha_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ya manope sija ilegña: Ayo y mananom mauleg na semiya y Lajin taotao yuje. ");
INSERT INTO cha_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Y fangualuan, y tano; y manmauleg na semiya, y famaguon y raeno, ya y taelaye na chaguan y famaguon y Maligno. ");
INSERT INTO cha_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y enemigo, ni y tumanme, y anitegüe; ya y quineco, y jinecog y siglo; ya y para ufanmangone, y angjet sija. ");
INSERT INTO cha_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sa taegüenao machule y taelaye na chaguan ya masonggue gui guafe, taegüijija locue y jinecog y siglo. ");
INSERT INTO cha_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ya utago y Lajin taotao y angjetña sija; ya urecoje todo ayo sija y fumatitinas y tinempo, yan y fumatitinas y tinaelaye; ");
INSERT INTO cha_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ya uyute gui jetnon guafe; ya ayo nae uguaja tumanges, yan chegcheg nifen. ");
INSERT INTO cha_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ayo nae y manunas, ufanmanina calang y atdao, gui raenon y Tatanñija. Y gaetalanga para ufanjungog, güiya ujungog. ");
INSERT INTO cha_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Y raenon langet locue, parejoja yan un senguaguan na güinaja ni y mananana gui un fangualuan, ya un taotao, anae jasoda, janana, ya mapos yan pot y minagofña jabende todo y iyoña ya jafajan ayo na fangualuan. ");
INSERT INTO cha_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Y raenon langet parejoja locue yan un taotao ni manbebende, na manaliligao bonito na petlas: ");
INSERT INTO cha_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ya anae mañoda un petlas na senguaguan, mapos ya jabende todo y güinajaña ya jafajan ayo. ");
INSERT INTO cha_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Y raenon langet parejoja locue, yan un lagua ni y mayute guato gui tase, ya mangone todo clase: ");
INSERT INTO cha_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ya anae esta bula, majala guato gui oriyan unae; ya manmatachong, ya majoca y manmauleg ya masajguane gui sajguanñija, ya y manaelaye mayute juyong. ");
INSERT INTO cha_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Taegüinija locue y jinecog y siglo: ufato y angiet sija ya ujanafanjanao y manaelaye gui entalo y manunas; ");
INSERT INTO cha_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ya ujayute gui jetnon guafe; ya ayo nae uguaja güije tumanges, yan chegcheg nifen. ");
INSERT INTO cha_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ayo nae si Jesus ilegña nu sija: Intingo todo estesija? Sija ilegñija nu guiya: Junggan. ");
INSERT INTO cha_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ya güiya ilegña nu sija: Pot este todo escriba ni mafatinas disipulo gui raenon langet, parejoja yan y tatan un familia, ni y jachuchule gui güinajaña bijo sija, yan nuebo sija. ");
INSERT INTO cha_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ya anae janafonjayan si Jesus todo este sija na acomparasion, mapos güije. ");
INSERT INTO cha_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ya anae mato gui tanoña, mamanagüe gui guimayuusñija, ya sija ninafanmanman, ya ilegñija: Guine mano nae jumuyong este na tiningoña, ya este sija mandangculo na ninasiña? ");
INSERT INTO cha_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ada ti güiya este y lajin y catpintero? Ada si nanaña ti mafanaan si Maria? yan y mañeluña, ti sija si Santiago, si José, si Simon, yan si Judas? ");
INSERT INTO cha_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ya ada ti manjijita yan y mañeluña palaoan? Guine mano nae uguaja este na taotao todo estesija? Ya guaja guiya güiya disgusto. ");
INSERT INTO cha_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Lao si Jesus ilegña nu sija: Y profeta taya onraña, gui tanoña yan y guimaña; lao gaeonraña gui otro lugat. ");
INSERT INTO cha_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ya ti jafatinas güije megae na mannamanman, sa taya jinengguenñija. ");
INSERT INTO cha_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","AYO na tiempo si Herodes y tetrarca jajungog y faman Jesus; ");
INSERT INTO cha_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ya ilegña nu y tentagoña sija: Este si Juan Bautista: güiya cajulo gui entalo y manmatae, enao mina mandangculo na mannamanman jafatitinas guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sa si Herodes esta jacone si Juan, ya jagode, ya japolo gui calaboso, pot si Herodias, asaguan Felipe y cheluña. ");
INSERT INTO cha_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sa si Juan ilegña nu güiya: Ti tunas na un guaja jao nu este na palaoan. ");
INSERT INTO cha_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ya anae malago na upinino güe, maañao ni y linajyan taotao; sa pineloñija na si Juan profeta güe. ");
INSERT INTO cha_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ya anae mato y jaanin y mafañagon Herodes, y jagan Herodias bumaela gui talo, ya ninamagof si Herodes, ");
INSERT INTO cha_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ya pot este japromete ya manjula na uninae todo y guinagaoña. ");
INSERT INTO cha_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ya güiya guinin umatungo finena an nanaña, ya ilegña: Naeyo güine gui un plato ni y ilon Juan Bautista. ");
INSERT INTO cha_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ayo nae y ray ninatriste; lao pot causa y juramentoña yan y mangachongña na mangaegue gui lamasa, manago na umanae. ");
INSERT INTO cha_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ya, manago na umautot y ilon Juan gui calaboso. ");
INSERT INTO cha_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ya machule guato y ilo gui un plato, ya manae y patgon palaoan, ya güiya chumule para si nanaña. ");
INSERT INTO cha_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ya y disipuluña sija, manmato ya machule y tataotaoña, ya majafot, ya manmapos, ya masangane si Jesus. ");
INSERT INTO cha_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ya anae jajungog este si Jesus, mapos güije gui un batco para y desierto na lugat na sumajnge: ya anae majungog ni y linajyan taotao sija, madalalague güe, manmamocatja desde siuda sija. ");
INSERT INTO cha_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ya jumanao si Jesus, ya jalie y dangculo na linajyan taotao: ya ninamaase ni ayo sija, ya janafanjomlo y manmalango sija. ");
INSERT INTO cha_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ya anae estaba pupnenge güije na jaane, manmato guiya güiya y disipuluña sija ya ilegñija; Este na lugat desierto ya y tiempo esta ufalofan; tago y linajyan taotao ya ufanjanao, ya ufanmalag y sengsong sija, ya ufanmamajan nañija. ");
INSERT INTO cha_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lao si Jesus ilegña nu sija: Taya nesesida na sija ufanjanao: jamyo innae nañija. ");
INSERT INTO cha_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sija ilegñija nu güiya: Taya güine guaja na sincoja na pan, ya dos na güijan. ");
INSERT INTO cha_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Güiya ilegña: Chulieyofan güine mague. ");
INSERT INTO cha_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ya jatago y linajyan taotao na ufanmatachong gui jilo chaguan, jachule y sinco na pan yan dos na güijan ya jaatan julo y langet, ya jabendise: ya jaipe y pan ya janae y disipulo sija, ya y disipulo janae y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ya mañocho todos, ya manjaspog; ya anae majoca y sebblan pedaso sija na maipe, bula dose na canastra. ");
INSERT INTO cha_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ya y mañocho sija, sinco mit na lalaje, ti matufong y famalaoan yan y famaguon. ");
INSERT INTO cha_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Enseguidas si Jesus janafanjalom y disipuluña sija gui un batco, ya manjanao manmofona, manmalag y otro bandan sadog, y tiempo nae güiya janafanjanao y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ya anae munjayan jadespide y linajyan taotao, cajulo gui un ogso na sumajnge, ya manaetae. Ya estaba gui puenge, ya sumasaga güigüiyaja namaesa. ");
INSERT INTO cha_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lao y batco pago estaba gui talo gui tase, pinapada ni napo, sa y manglo contra. ");
INSERT INTO cha_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ya y mina cuatro na guatdia gui puenge, si Jesus jumanao para iyasija mamomocat gui jilo tase. ");
INSERT INTO cha_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ya anae malie ni disipuluña sija na mamomocat gui jilo tase, ninafañatsaga, ya ilegñija: Fafañagüe este; ya managang ni y minaañaoñija. ");
INSERT INTO cha_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Enseguidas si Jesus cumuentos, ilegña nu sija: Angoco jamyo; guajoyo; chamiyo fanmaaañao. ");
INSERT INTO cha_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ayo nae manope si Pedro ilegña: Señot, yaguin jago, tago yo ya jufalag iyajago gui jilo janom. ");
INSERT INTO cha_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Güiya ilegña: Maela. Ya tumunog si Pedro gui batco, ya mamocat gui jilo janom para uguaguato gui as Jesus. ");
INSERT INTO cha_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lao anae jalie na dangculo na manglo, ninamaañao; ya anae jatutujon dimafondo, jaagang, ilegña: Señot, nalibreyo. ");
INSERT INTO cha_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ya enseguidas si Jesus jajuto mona y canaeña, ya guiniut güe, ya ilegña nu güiya: Taotao na didide jinengguemo! Sa jafa ti unjonggue? ");
INSERT INTO cha_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ya anae manjalom julo gui batco, y manglo quieto. ");
INSERT INTO cha_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ayo nae y mangaegue gui batco, maadora güe ilegñija: Magajet na jago Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ya anae manmalofan gui tase, manmato gui tano Genesaret. ");
INSERT INTO cha_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ya y taotao ayo na lugat anae matungo güe, manmanago y oriyan todo ayo na tano, na umacone guato todo y manmalango. ");
INSERT INTO cha_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ya magagao güe na upolo na umapacha y madobbla y magaguña; ya todo y pumacha güe, guefjomlo sija. ");
INSERT INTO cha_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","AYO nae manmato gui as Jesus escriba yan Fariseo sija, guiya Jerusalem, ya ilegñija: ");
INSERT INTO cha_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Jafa disipulomo na ti jaosgue y tradision y manbijo? sa ti jafagagase y canaeñija anae mañocho pan? ");
INSERT INTO cha_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ya güiya jaope sija ilegña: Jafa locue jamyo na ti inesgue y tinago Yuus pot tradisionmiyo? ");
INSERT INTO cha_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sa si Yuus manago, ilegña: Onra si tatamo, yan si nanamo; ya y mumatdise si tataña, pat si nanaña, magajet na umatae. ");
INSERT INTO cha_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lao jamyo ilegmiyo: Jayeja y umalog ni tataña, pat si nanaña: Y ninae para si Yuus, ayo na probechonmiyo guiya guajo; ");
INSERT INTO cha_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ya ti guaelaye na ujaonra si tataña. Enaomina innataelaye y Sinangan Yuus pot y tradisionmiyo. ");
INSERT INTO cha_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hipocritas! Cabales y sinangan nu jamyo as Isaias anae ilegña: ");
INSERT INTO cha_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Este na taotao sija, nu y labiosñija jaonrayo; lao y corasonñija chago guiya guajo. ");
INSERT INTO cha_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lao taesetbe y inadodorayo, manmamananagüe y finanagüenñija ni y sinangan taotao. ");
INSERT INTO cha_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ya jaagang y linajyan taotao, ya ilegña nu sija: Ecungog ya intingo. ");
INSERT INTO cha_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ti y jumajalom gui pachot, muna natataelaye y taotao; na ayo y jumujuyong gui pachot, ayo muna natataelaye y taotao. ");
INSERT INTO cha_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ayo nae manmato y disipuluña sija, ya ilegnija nu güiya: Untungo na y Fariseo sija ninafandisgustao anae jajungog este na sinangan? ");
INSERT INTO cha_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lao güiya jaope sija ilegña: Todo tinanom ni y ti jatanom y Tatajo na gaegue gui langet, umajajleg. ");
INSERT INTO cha_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Polo sija: y bachet ya uguia y bachet; yaguin y bachet uguia y bachet, sija na dos uchapodongja gui joyo. ");
INSERT INTO cha_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ya manope si Pedro, ilegña: Sanganejam nu este na acomparasion. ");
INSERT INTO cha_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ya si Jesus ilegña: Ada locue trabia jamyo ti intitingoja? ");
INSERT INTO cha_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ti intingo na todo y jumalom gui pachot, jumajanao para y tiyan, ya mayuyute gui lugat umatog. ");
INSERT INTO cha_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lao todo y jumuyong gui pachot, estesija guine y corason, ya estesija muna natataelaye y taotao. ");
INSERT INTO cha_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sa gui corason nae manjujuyong y taelaye na jinaso, manpegno taotao, adulterio, inabale, saque, ti manmagajet na testimonio, chatfino contra si Yuus. ");
INSERT INTO cha_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Estesija muna fanataelaye y taotao; lao y chumocho yan y ti mafagase canaeña, ti ninatataelaye y taotao. ");
INSERT INTO cha_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ya jumanao si Jesus güije, malag y oriyan Tiro yan Sidon. ");
INSERT INTO cha_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ya estagüe un palaoan, taotao Cananea, na jumanao gui ayo sija na oriya, ya umaagang, ilegña: Señot, Lajin David, gaemaase nu guajo; y jagajo ninachatsaga fefman ni anite. ");
INSERT INTO cha_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lao güiya ti jaope sinangan: Ayo nae manmato y disipuluña sija, ya magagao güe ilegñija: Tago güe ya ujanao, sa esta jame jaagang. ");
INSERT INTO cha_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ya güiya jaope ilegña: Ti guajo matago na y manmalingo na quinilo gui guima Israel. ");
INSERT INTO cha_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ayo nae y palaoan mato, ya jaadoro güe, ilegña: Señot, ayudayo. ");
INSERT INTO cha_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ya manope güi ilegña: Ti mauleg na tachule y pan y famaguon ya tayute y galago sija. ");
INSERT INTO cha_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ya y palaoan manope: Magajet Señot; lao y galago sija, mañochochoja ni andesmorona ni mamopodong gui lamasan y amuñijo. ");
INSERT INTO cha_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ayo nae manope si Jesus, ilegña: Palaoan! dangculo jinengguemo: umafatinas guiya jago jafa y malagomo. Ya jomlo y jagaña desde ayo na ora. ");
INSERT INTO cha_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ya si Jesus mapos güije, ya mato jijot gui tasen Galilea: ya cajulo gui jilo un finabeca, ya matachong güije. ");
INSERT INTO cha_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ya manmato guiya güiya linajyan taotao, na guaja guiya sija cojo, bachet, udo, mangco, yan palo sija megae na manmalango, ya manmapolo gui adeng Jesus; ya janafanjomlo. ");
INSERT INTO cha_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pot este mina y linajyan taotao ninafanmanman, anae jalie na y udo manguentos, ya y mangco manjomlo, ya y cojo manmamocat, ya y bachet manmanlie; ya ninamaonra si Yuus Israel. ");
INSERT INTO cha_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ya si Jesus jaagang y disipuluña sija, ilegña: Janamaaseyo y linajyan taotao, sa esta tres na jaane na manjame, ya taya nañija: ya mungayo munafanjanao sin ufañocho, sa no seaja ufanlalango gui chalan. ");
INSERT INTO cha_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ayo nae y disipuluña sija ilegñija nu güiya: Amano nae uguaja megae na pan güine gui desierto para utanafanjaspog este y dangculo na linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Si Jesus ilegña nu sija: Cuanto na pan guajata? Ya sija ilegñija: Siete, yan didide güijan diquique. ");
INSERT INTO cha_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ya jatago y linajyan taotao na ufanmatachong gui jilo oda. ");
INSERT INTO cha_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ya jachule y siete na pan yan y güijan sija, ya janae grasias, ya jaipe, ya janae y disipuluña sija, ya y disipuluña janae y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ya mañocho todos, ya manjaspog; ya anae majoca y pedaso sija na maipe ni y sebbla; bula siete na canastra. ");
INSERT INTO cha_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ya y mañocho sija, cuatro mit, ti matufong y famalaoan yan y famaguon. ");
INSERT INTO cha_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ya anae jadespide y linajyan taotao, cajulo gui un batco, ya mato gui origan Magdala. ");
INSERT INTO cha_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","YA manmato y Fariseo yan y Saduseo sija, ya matienta güe, magagagao na ufanfinanue un señat gui langet. ");
INSERT INTO cha_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lao güiya jaope ilegña nu sija: Yanguin esta pupnenge y jaane, ilegmiyo: Mauleg na tiempo pago, sa y langet agaga. ");
INSERT INTO cha_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ya y egaan: Pago uguaja pinagyo, sa managaga y langet ya didide na mapagajes. Jamyo tumungo jumusga y matan y langet; lao y señat y tiempo sija ti innasiña. ");
INSERT INTO cha_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Y taelaye yan adulterio na rasa jagueguefaliligao un señat, lao taya ufanmanae atgun señat, na y señat Jonas profeta. Ya jadingo sija, ya mapos. ");
INSERT INTO cha_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ya anae manmato gui otro bandan jagoi y disipuluña sija jajaso na manmalefa ya ti manmañule pan. ");
INSERT INTO cha_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ya si Jesus ilegña nu sija: Atan, ya inadaje jamyo ni y lebaduran y Fariseo yan y Saduseo sija. ");
INSERT INTO cha_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ya sija manmanjaso gui sanjalomñija, ilegñija: Buente pot y ti manmañulejam pan. ");
INSERT INTO cha_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ya jatungo si Jesus, ilegña nu sija: Jafa jinasonmimiyo gui sanjalommiyo, taotao na didide jinengguenmiyo, pot y ti manmañule jamyo pan? ");
INSERT INTO cha_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ada ti intitingo, ni ti injajaso y sinco na pan, gui sinco mit, ya cuanto na canastra injeca. ");
INSERT INTO cha_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ni y siete na pan gui cuatro mit, ya cuanto na canastra injeca? ");
INSERT INTO cha_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jafa este na ti intingo, na ti pot y pan na jusangane jamyo? Lao inadaje jamyo ni y lebaduran y Fariseo yan y Saduseo sija. ");
INSERT INTO cha_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ayo nae jatungo na ti mansinangane sija na ujaadaje sija ni y lebaduran pan; lao y finanagüen y Fariseo yan y Saduseo sija. ");
INSERT INTO cha_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ya anae mato si Jesus gui Sesarean Filipe, jafaesen y disipuluña sija ilegña: Jaye ilegñiñija y taotao sija nu y Lajin taotao? ");
INSERT INTO cha_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ya sija ilegñija: Guaja umalog na jago si Juan Bautista; ya guaja umalog, si Elias; ya guaja umalog, si Jeremias, pat uno gui profeta sija. ");
INSERT INTO cha_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Güiya ilegña nu sija: Ya jamyo, jaye ilegmimiyo nu guajo? ");
INSERT INTO cha_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Manope si Simon Pedro ilegña: Jago si Cristojao, y Lajin Yuus ni y lalâlâ. ");
INSERT INTO cha_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ayo nae inepe as Jesus ilegña: Dichosojao, Simon, lajin Jonas; sa ti jufanuejao sensen ni jâgâ, na y Tatajo ni y gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya guajo locue sumanganejao, na jago si Pedro; ya y jilo este na acho, jufatinas y iglesiamo; ya y pettan sasalaguan taeninasiña contra guiya. ");
INSERT INTO cha_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ya junaejao ni y yaben y raenon langet; ya todoja y ungode gui tano, umagodeja locue gui langet; ya todoja y unpula gui tano, umapula locue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ayo nae jatago y disipuluña sija, na chañija fanmañangangane ni jaye na güiya si Jesus y Cristo. ");
INSERT INTO cha_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde ayo na tiempo jatutujon si Jesus dumeclaraye y disipuluña sija, na guaja nesesidaña na ujanao para Jerusalem, ya upadese megae sija gui manbijo, yan y prinsipen y mamale sija, yan y escriba sija, ya umapuno, ya umanacajulo gui mina tres na jaane. ");
INSERT INTO cha_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ya si Pedro, quinene güe ya tinitujon güe rineprende, ilegña: Señot, maase nu jago: este ti usiña jago. ");
INSERT INTO cha_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ayo nae jabiragüe, ya ilegña as Pedro: Suja gui menajo, Satanas: jago un tropero para guajo; sa ti untungo y güinaja Yuus, na y güinajan taotaoja sija. ");
INSERT INTO cha_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ayo nae si Jesus, ilegña ni y disipuloña sija: Yanguin jaye malago dumalalag yo, polo ya upune namaesagüe, ya uchule y quiluusña ya udalalag yo. ");
INSERT INTO cha_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sa jayeja y malago munalibre y linâlâña, ufinalingaeguan; ya jayeja y finalingaeguan ni y linâlâña pot guajo, güiya usoda. ");
INSERT INTO cha_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sa jafa probechoña y taotao, yanguin jagana todo y tano, ya y linâlâña malingo? Pat jafa na apas ufannae y taotao pot y linâlâña. ");
INSERT INTO cha_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sa y Lajin taotao, ufato gui minalog y Tataña yan y angjetna sija; ya ayo nae uapase cada uno taemano y chechoña. ");
INSERT INTO cha_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Magajet jusangane jamyo: na guaja palo gui mangaegue güine, na ti ujachague finatae, asta qui jalie y Lajin taotao na mato gui raenoña. ");
INSERT INTO cha_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","DESPUES di y saes na jaane, si Jesus jacone si Pedro, yan si Santiago, yan si Juan cheluña, ya jacone julo gui un taquilo na finabeca, na sumajnge. ");
INSERT INTO cha_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ya jaaggo y jechuraña gui menanñija; ya y mataña manina calang y atdao; ya y magaguña apaca calang y manana. ");
INSERT INTO cha_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ya estagüe, na manmato güiya sija si Moises yan si Elias, na manguecuentos yan güiya. ");
INSERT INTO cha_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ya manope si Pedro, ilegña as Jesus: Señot, mauleg na mangaeguejit güine: yaguin malagojao, bae jufatinas güine tres na tabetnaculo; para jago y uno, para si Moises y uno, yan para si Elias y uno. ");
INSERT INTO cha_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Anae cumuecuentos güe, estagüe, un malag na mapagajes jananujong gui jiloñija, ya, estagüe, un inagang gui mapagajes na ilegña; Estagüiya y Lajijo na maguflie, na guefyajo: ecungog güe. ");
INSERT INTO cha_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ya anae jajungog este y disipulo sija, manpodong gui jilo matañija ya mangosmaañao. ");
INSERT INTO cha_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ayo nae si Jesus mato ya manpinacha, ilegña: Fangajulo ya chamiyo fanmaaañao. ");
INSERT INTO cha_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ya anae jajatsa y atadogñija, taya jalie na si Jesusja. ");
INSERT INTO cha_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ya anae manunog papa guine y finabeca, si Jesus mantinago ya ilegña: Chamiyo fanmañangangane ni jaye ni liniimiyo, asta qui y Lajin taotao esta cajulo gui entalo manmatae. ");
INSERT INTO cha_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ayo nae y disipuluña sija mafaesen güe ya ilegñija: Jafa nae na ilegñija y escriba sija na si Elias ufato finena? ");
INSERT INTO cha_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ya inepe as Jesus, ilegña: Magajet na si Elias ufato finena, ya ujananalo todo y güinaja. ");
INSERT INTO cha_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lao guajo sumangane jamyo, na si Elias esta mato, ya ti matungogüe: lao mafatinas guiya güiya todo y malagoñija. Taegüenaoja locue y Lajin taotao upadese nu sija. ");
INSERT INTO cha_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ayo nae y disipulo sija jatungo na mansinangane sija as Juan Bautista. ");
INSERT INTO cha_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ya anae manmato sija gui linajyan taotao, mato guiya güiya un taotao na dinimumuye güe ya ilegña: ");
INSERT INTO cha_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Señot, gaease ni lajijo; sa malango baba, ya gogosjapadese; sa megae nae podong gui guafe, yan megae nae podong gui janom. ");
INSERT INTO cha_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ya guinin juchulie guato y disipulumo, lao tisiña manajomio. ");
INSERT INTO cha_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ya manope si Jesus, ilegña: O generasion na ti manjonggue yan manchatpayon! asta ngaean nae utafanjijitaja? asta ngaean nae jususungonja jamyo? Chulie yo fan mague. ");
INSERT INTO cha_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ya jalalatde si Jesus y anite, ya mapos gui malango, ya y patgon jomlo desde ayo na ora. ");
INSERT INTO cha_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ayo nae manmato y disipulo sija gui as Jesus, ya ilegñija: Jafajam mina ti siña inyite juyong? ");
INSERT INTO cha_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Si Jesus ilegña nu sija: Pot diquique na jinengguenmiyo: sa magajet jusangane jamyo, na yanguin mangaejinenggue jamyo, calang y pepitas mostasa, injaalog ni este na jalom tano: Janao güine; ya ujanao, ya taya ti siña para jamyo. ");
INSERT INTO cha_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Lao este na classe ti jumanao juyong, yaguin ti y minauleg y tinayuyut.) ");
INSERT INTO cha_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ya anae manmamocat guiya Galilea, ilegña si Jesus nu sija: Y Lajin taotao umaentrega gui canae y taotao sija; ");
INSERT INTO cha_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ya umapuno; lao y mina tres na jaane, ucajulo. Ya sija ninafangostriste. ");
INSERT INTO cha_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ya anae manmato guiya Capernaum, manmato gui as Pedro ayosija y manmangongobbla y medio siclo, y tributo, ya ilegñija: Ada ti manapapase y maestronmiyo y medio siclo y tributo? ");
INSERT INTO cha_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Güiya ilegña: Junggan. Ya anae jumalom güe gui jalom guma, si Jesus, cuenentuse güe antes, ilegña: Jafa jinasosomo Simon? Y ray y tano sija, jaye jacocobbla tributo pat senso? y famaguonñija, pat y taotaojuyong? ");
INSERT INTO cha_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ya anae ilegña, Y taotaojuyong; si Jesus ilegña nu güiya: Ayo nae y famaguon manlibre. ");
INSERT INTO cha_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lao para mungajit fumatinas y tinempo para sija, Janao falag y tase, ya unyute y jagüet, ya y finenana na güijan na mato, cone; ya an unbaba y pachotña, unsoda y un siclo; chule este ya nae para guajo yan para jago. ");
INSERT INTO cha_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","AYO na tiempo, manmato y disipulo sija gui as Jesus, ya ilegñija: Jaye mas dangculo gui raenon langet? ");
INSERT INTO cha_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ya jaagang si Jesus un patgon, ya japolo gui entaloñija, ");
INSERT INTO cha_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ya ilegña: Magajet jusangane jamyo, yaguin ti inbira jamyo, ya ti infanjuyong calang, y diquique na famaguon, sen ti infanjalom gui raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ya jayeja y umumitde calang este na patgon, este uguefdangculo gui raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ya jayeja y rumesibe un patgon, parejo yan este, pot y naanjo, jaresibeja yo locue. ");
INSERT INTO cha_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lao jayeja y munamatompo uno güine gui estesija mandiquique ni y jumonggue yo, mas mauleg umagode gui agagaña y dangculo na molinon acho, ya umayute gui anae tadodong y tase. ");
INSERT INTO cha_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ayay y tano pot y tinempo sija! sa nesesita na ufato y tinempo sija, lao, ayay ayo na taotao, y uminafato y tinempo. ");
INSERT INTO cha_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Enao mina yaguin y canaemo, pat y adengmo, unninaquepodongjao, utut ya unnajanao guiya jago: sa maulegña na unqueyaojao, pat mangcojao, ya unjalom gui linâlâmo, qui uguaja dos canaemo, yan dos adengmo, ya unmapolo gui taejinecog na guafe. ");
INSERT INTO cha_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yaguin y atadogmo unninaquepodongjao, chule ya unnajanao guiya jago; sa maulegña na unjalom gui linâlâmo yan un atadog, qui uguaja dos atadogmo, ya unmapolo gui guafen sasalaguan. ");
INSERT INTO cha_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Atan ya chamiyo dumesprenesia uno güine gui estesija y mandiquique; sa guajo sumangane jamyo, na y angjetñija gui langet, siesiempreja jaliliija y matan y Tatajo ni y gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Sa y Lajin taotao mato para usatba y manmalingo.) ");
INSERT INTO cha_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jafa jinasonmimiyo? Yaguin guaja un taotao na gaega siento na quinilo, ya finalingaeguan uno: Ada ti upolo y noventa y nueve gui jalomtano, ya ujanao ya ujaligao ayo y malingo? ");
INSERT INTO cha_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yanguin jasoda, magajet jusangane jamyo, na magofña ni ayo, qui y noventa y nueve ni y ti manmalingo. ");
INSERT INTO cha_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Taegüineja, ti minalago Tatanmiyo ni y gaegue gui langet, na uguaja malingo uno güine gui estesija y mandiquique. ");
INSERT INTO cha_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yaguin y chelumo inisagüejao, janao, ya unsangane ni y linachiña, jamyoja na dos; yanguin inecungogjao, ungana y chelumo. ");
INSERT INTO cha_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lao, yaguin ti jaecungogjao, fangone gachongmo uno, pat dos, sa para y pachot dos pat tres na testigo, ucabales todo y sinangan. ");
INSERT INTO cha_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yanguin ti jaecungog sija, sangane y inetnon mangilisyano; lao yaguin ti malago jaecungog y inetnon mangilisyano, güiya para jago parejo yan un taotaojuyong pat publicano. ");
INSERT INTO cha_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Magajet jusangane jamyo, na todo y inguede gui tano, ufanmagode locue gui langet: ya todo y inpila gui tano, ufanmapula locue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jusangane jamyo talo, na yaguin dos guiya jamyo inguaja un corason gui jilo tano, pot jafa na güinaja ni ingagao; umafatinas para sija, pot y Tatajo na gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sa manoja nae guaja dos pat tres, na mandadaña pot y naanjo, gaegue yo güije gui entaloñija. ");
INSERT INTO cha_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ayo nae si Pedro mato guiya güiya ya ilegña: Señot, cuanto biaje juasie y chelujo yaguin jaisagüeyo? asta siete biaje? ");
INSERT INTO cha_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Si Jesus ilegña nu güiya: Ti jualog sieteja na biaje, lao, asta setenta na siete. ");
INSERT INTO cha_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Enao mina y raenon langet, parejoja yan un ray, na malago na ufatinas cuentas yan y tentagoña sija. ");
INSERT INTO cha_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ya anae jatutujon fumatinas y cuentas sija, maconiegüe guato, uno na mandidibe dies mit talento. ");
INSERT INTO cha_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Lao anae güiya ti siña jaapase, y amuña manago na umabende güe, yan y asaguaña, yan y famaguonña, yan todo y güinajaña, ya umaapasegüe. ");
INSERT INTO cha_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ayo na tentago, dumimo papa ya tinayuyutgüe, ilegña: Señot, gaesiningon nu guajo, ya juapasejao todo. ");
INSERT INTO cha_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y amon ayo na tentago, ninagosmaase, ya pinelogüe, ya inasie ni y dibiña. ");
INSERT INTO cha_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ya jumanao ayo na tentago, ya umasoda yan uno gui mangachongña na dinidibegüe cien pesetas; ya jamantiene güe ya jañucut, ya ilegña: Apaseyo todo ni dibimo. ");
INSERT INTO cha_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ayo nae y gachongña dumimo papa, ya tinayuyutgüe ilegña: Gaesiningon nu guajo, ya juapasejao. ");
INSERT INTO cha_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lao güiya ti malago, ya mapos ya pinelo gui catset asta qui uinapase ni y dibiña. ");
INSERT INTO cha_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ya anae malie ni y mangachongña, jafa y susede, ninafangostriste, ya manmato, ya masangane y amuñija y susede. ");
INSERT INTO cha_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ayo nae y amuña inagang güe, ya ilegña: Taelayejao na tentago. Juasiijao todo ni y dibimo, sa untayuyutyo: ");
INSERT INTO cha_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ada locue ti ninamaase jao ni y gachongmo, calang y maasejo nu jago? ");
INSERT INTO cha_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ayo nae y amuña ninalalalo, ya inentrega güe gui mansasapet, asta qui uapase todo y dinidibegüe. ");
INSERT INTO cha_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Taegüenaoja locue ufatinas nu jamyo y Tatajo ni gaegue gui langet, yaguin ti inasie gui corasonmiyo cada uno gui chelonmiyo nu y dibiña. ");
INSERT INTO cha_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","YA malofan anae si Jesus munjayan este sija na finanagüeña, jumanao guiya Galilea, ya mato gui oriyan Judea, gui otro bandan Jordan. ");
INSERT INTO cha_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ya madalalag güe ni y dangculo na linajyan taotao, ya janafanjomlo güije. ");
INSERT INTO cha_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ayo nae manmato guiya güiya y Fariseo sija, ya matienta güe ya ilegñija nu güiya: Siña y laje jayute y asaguaña pot jafa na rason? ");
INSERT INTO cha_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Güiya jaope ya ilegña: Ada ti intaetae na y fumatinas desde y tutujon, laje yan palaoan jafatinas sija; ");
INSERT INTO cha_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ya ilegña: Pot este y laje upolo si tataña yan si nanaña, ya udaña yan y asaguaña, ya sija na dos unoja catneñija? ");
INSERT INTO cha_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Taegüenao sija ti udos, na unoja na catne. Pot enao mina y ninadaña Yuus, ti mauleg y taotao ujanaadesapatta. ");
INSERT INTO cha_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ylegñija nu güiya: Pot jaf mina si Moises jatago na umatugue y papet umadesapatta, ya umayute? ");
INSERT INTO cha_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Güiya ilegña: Pot y manmajetog corasonmiyo, si Moises na japetmite na inyite y asaguanmiyo, lao y tutujonña ti taegüenao. ");
INSERT INTO cha_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Guajo jamyo sumangane, na jayeja y yumute y asaguaña ya ti pot y inabale, ya umasagua yan otro, umabale; ya y umasagua yan y umayute, umabaleja. ");
INSERT INTO cha_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ylegñija y disipuluña sija nu güiya: Yaguin taegüenao nu y laje yan y asaguana, ti mauleg na umasagua. ");
INSERT INTO cha_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ayo nae ilegña: Ti todo siña rumesibe este na sinangan: na ayoja sija y manmanae. ");
INSERT INTO cha_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sa guaja capon sija na y mafañago capon guine y jalom tuyan nanañija; ya guaja capon na ninafancapon ni y taotao sija; ya guaja capon na jacapon maesaja sija pot rason di y raenon langet. Y siña rumesibe este, güiya uresibe. ");
INSERT INTO cha_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ayo nae machule guato guiya güiya famaguon sija, para upolo y canaeña gui jiloñija, ya ufanaetae; lao y disipulo sija manlinalatde y manmangongone guato. ");
INSERT INTO cha_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lao si Jesus ilegña: Polo y famaguon, ya chamiyo chumochoma, na ufanmamaela guiya guajo; sa iyon este sija y raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ya anea munjayan japolo y canaeña gui jiloñija, mapos güije. ");
INSERT INTO cha_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ya estagüe uno na mato, ya ilegña: Maestro, jafa mauleg jufatinas, para juguaja taejinecog na linala? ");
INSERT INTO cha_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Güiya ilegña: Jafa na funaesenyo nu y minauleg? Guaja unoja mauleg: lao yaguin malagojao jumalom gui linâlâ, adaje y tinago sija. ");
INSERT INTO cha_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ylegña nu güiya: Jafa? Si Jesus ilegña: Munga mamuno; munga umabale; munga mañaque; munga masangan y ti magajet na testimonio; ");
INSERT INTO cha_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Onra si tatamo, yan si nanamo; Ya güaeya y tiguangmo calang jago maesaja. ");
INSERT INTO cha_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Y patgon na taotao ilegña nu güiya: Todo este sija juadaje: Jafa trabia fattaco? ");
INSERT INTO cha_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ylegña si Jesus nu güiya: Yaguin malagojao na uncabales, janao, ya unbende todo y güinajamo, ya unnae y mamobble, ya uguaja güinajamo gui langet; ya maela dalalagyo. ");
INSERT INTO cha_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lao anae jajungog y patgon na taotao, este na sinangan, ninatriste ya mapos; sa guaja megae iyoña na güinaja. ");
INSERT INTO cha_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ayo nae si Jesus ilegña ni disipuluña: Magajet jusangane jamyo, na y manrico mapot jumalom gui raenon langet. ");
INSERT INTO cha_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ya jusangane jamyo talo, na mas guse un cameyo malofan gui matan jaguja, qui un rico ujalom gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Anae jajungog este sija y disipuluña, ninafangosmanman, ya ilegñija: Jaye nae siña satbo? ");
INSERT INTO cha_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Maninatan as Jesus, ya ilegña nu sija: Yan y taotao sija, ti siña este; lao yan si Yuus, todo siña. ");
INSERT INTO cha_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ayo nae manope si Pedro, ilegña nu güiya: Estagüejamja, na inpelo todo, ya indadalalagjao; jafa nae uguajanmame? ");
INSERT INTO cha_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Si Jesus ilegña nu sija: Magajet jusangane jamyo, na jamyo ni dumadalalagyo, y tiempon finamauleg, anae matachong y Lajin taotao gui tronon y langetña, jamyo locue infanmatachong gui jilo y dose na trono para injisga y dose na tribu guiya Israel. ");
INSERT INTO cha_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ya jayeja y yumute gumaña, pat cheluña laje, pat cheluña palaoan, pat tataña, pat nanaña, pat lajiña, pat tanoña pot y naanjo, ufanresibe cien biaje, ya umaereda ni y taejinecog na linâlâ. ");
INSERT INTO cha_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lao megae na manfinenana ufanuttimo; ya y manuttimo ufanfinenana. ");
INSERT INTO cha_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","SA y raenon langet parejoja yan un taotao, tatan un familia na jumanao taftaf gui egaan para ufantratos manfáfachocho, para y fangualuanña ubas. ");
INSERT INTO cha_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ya anae esta manatungopara ufanmachocho pot un peseta gui un jaane, jatago na ufanmalag y fangualuanña. ");
INSERT INTO cha_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ya y mina tres na ora, jumajanao ya jalile palo na manotojgue gui plasa manaechoco, ");
INSERT INTO cha_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ya ilegña nu sija: Janao locu fanmalag y fangualuanjo, ya junae jamyo ni y cabales. Ya manmapos. ");
INSERT INTO cha_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ya jumanao talo gui mina saes, yan y mina nuebe na ora, ya jafatinasja taegüije. ");
INSERT INTO cha_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jumanao gui mina onse na ora, ya jasoda palo na manaechocho, ya ilegña: Jafa na mañasagaja jamyo güine todo pago na jaane, ya manaechocho jamyo? ");
INSERT INTO cha_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sija ilegñija nu güiya: Sa tayajam tumatratos. Güiya ilegña nu sija: Janao locue fanmalag y fangualuanjo. ");
INSERT INTO cha_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ya anae estaba pupuenge güije na jaane, y magas ni y gaiyo ayo y fangualuan ubas, ilegña nu y magas na tentagoña: Agang todo y manfafachocho, ya unapase ni y chechoñija, tutujon desde y uttimo asta y finenana. ");
INSERT INTO cha_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ya anae manmato ayo y jumanao gui mina onse na ora, cada uno jaresibe un peseta. ");
INSERT INTO cha_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Anae manmato y jumanao finenana, jinasonñija na ujaresibe mas; lao manparejoja todo siji cada uno jaresibe un peseta. ");
INSERT INTO cha_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ya anae jaresibe, ninafanadingan contra y tatan y familia, ");
INSERT INTO cha_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ilegñija: Este sija y manuttimo, taya chechoñija na un oraja, ya unnafanparejoja yan jame, na jame cumatga y catga yan todo y minaepen y jaane. ");
INSERT INTO cha_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Güiya jaope uno guiya sija, ilegña: Amigo, taya ti tunas jufatinas nu jago. Ada ti matungo jit pot un peseta? ");
INSERT INTO cha_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chule y iyomo ya unjanao: guajo malagoyo na junae este y uttimo, parejo yan jago. ");
INSERT INTO cha_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ada ti cabales na jufatinas jafa y malagojo ni y iyoco? Pat ada taelaye y atadogmo, sa guajo mauleg? ");
INSERT INTO cha_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Taegüenao y manfinenana ufanuttimo, ya y manuttimo, ufanfinenana. ");
INSERT INTO cha_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ya anae si Jesus cajulo guiya Jerusalem, jacone y dose na disipoluña gui sumajnge ya ilegña nu sija gui chalan: ");
INSERT INTO cha_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Estagüijit na mangajulo guiya Jerusalem, ya y Lajin taotao umaentrega gui magas na mamale sija, yan escriba sija; ya umasentensia para umapuno; ");
INSERT INTO cha_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ya umaentrega gui Gentiles sija, para umabutlea, yan umasaulag, yan umaatane gui quiluus; lao y mina tres na jaane umacajulo. ");
INSERT INTO cha_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ayo nae manmato guiya güiya y nanan y famaguon Sebedeo, yan y famaguonña, ya maadora güe, ya manmangagagao ni un güinaja. ");
INSERT INTO cha_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ya ilegña nu güiya: Jafa malagomo? Y palaoan ilegña nu güiya: Tago este y dos lajijo ya ufatachong, y uno gui agapa na canaemo, ya y otro gui acagüemo, gui raenomo. ");
INSERT INTO cha_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ayo nae inepe as Jesus ilegña: Ti untungo jafa mangagao. Siñajamyo gumimen gui copa anae gumiguimenyo? Sija ilegñija, siñajam. ");
INSERT INTO cha_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Güiya ilegña nu sija: Magajet na infanguimen gui copajo; lao infanmatachong gui agapa na canaejo pat y acagüe, ti guajo jufannae, na para ayo sija y esta manmaprepara pot y Tatajo. ");
INSERT INTO cha_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ya anae majungog este ni y dies, ninafanbubo nu y dos chumelo. ");
INSERT INTO cha_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ayo nae si Jesus, inagang sija guiya güiya ya ilegña: Intingo na y magas y taotaojuyong sija, manmamanda gui jiloñija; ya mandangculo jafatinas ninasiñanñija gui jiloñija. ");
INSERT INTO cha_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lao ti utaegüine guiya jamyo; ya jayeja y malago dumangculo gui entalonmiyo, güiya ministronmiyo. ");
INSERT INTO cha_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ya y malago ufinenana gui entaloñmiyo, güiya tentagonmiyo. ");
INSERT INTO cha_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sa y Lajin taotao, ti mato para umasetbe, na para ufañetbe, ya para ufannae y jaaniña un rescata para unafanlibre megae. ");
INSERT INTO cha_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ya anae manjanao sija guiya Jerico, madalalague güe dangculo na linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ya estagüe dos bachet na matatachong gui oriyan chalan, ya anae jajungog na para ufalofan si Jesus, managang, ilegñija: Señot, Lajin David, gaease nu jame. ");
INSERT INTO cha_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ya y linajyan taotao, manlinalatde, para ufanmamatquilo: lao sija mas managang, ilegñija: Señot, Lajin David, gaease nu jame. ");
INSERT INTO cha_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ya sumaga si Jesus, ya maninagang, ilegña: Jafa malagomiyo na jufatinas para jamyo? ");
INSERT INTO cha_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ylegñija: Señot, y atadogmame umababa. ");
INSERT INTO cha_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ayo nae si Jesus ninamaase, ya japacha y atadogñija, ya manmanlie y atadogñija, ya madalalague güe. ");
INSERT INTO cha_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","YA anae esta manjijijot guiya Jerusalem, manmato guiya Betfaye, gui egso Olibo, si Jesus jatago dos gui disipuluña, ");
INSERT INTO cha_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ylegña nu sija: Janao fanmalag y sengsong sa gaegüenao gui menanmiyo, sa enseguidas inseda un bulico na magogode, sumisija yan un poyino: pula ya unchulieyo mague. ");
INSERT INTO cha_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yaguin guaja jamyo sumangane jafa, alog: Y Señot janesesita; ya infanmanae enseguidas. ");
INSERT INTO cha_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ya todo este jumuyong, para umacumple y sinangan y profeta ni y ilegña: ");
INSERT INTO cha_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sangane y jagan Sion: Estagüe y Raymo na mato guiya jago, mamso, ya matatachong gui jilo un bulico yan un poyino, patgon bulico. ");
INSERT INTO cha_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ya y disipulo sija manmapos, ya jafatinas jaftaemano y mantinago as Jesus. ");
INSERT INTO cha_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ya machule y bulico, yan y poyino, ya japolo y magagunija gui jiloñija, ya matachong gui jiloñija. ");
INSERT INTO cha_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ya un gosdangculo na linajyan taotao jajuto y magaguñija gui chalan; yan palo manmanutot ramas jayo, ya jajuto gui chalan; ");
INSERT INTO cha_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ya y linajyan taotao ni y manmofona, yan y manatate, manaagang, ilegñiñija: Hosana y Lajin David: Dichoso y mato pot y naan y Señot; Hosana guiya jilulo. ");
INSERT INTO cha_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Anae jumalomgüe guiya Jerusalem, todo y siuda manatborotao, ya ilegñija: Jaye este? ");
INSERT INTO cha_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ya y linajyan taotao ilegñija: Este si Jesus, y profetan Nasaret yan Galilea. ");
INSERT INTO cha_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ya jumalom si Jesus gui guimayuus, ya jayute juyong todo y manmanbebende, yan y manmamamajan gui guimayuus, ya janaalinquin y lamasan y manmanulalaeca salape, yan y tachong y manmanbebende paluma; ");
INSERT INTO cha_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ya ilegña nu sija: Esta matugue, y guimajo, guma manaetae umafanaan; lao jamyo fumatinas y liyang y mañaque. ");
INSERT INTO cha_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ya manmato guiya güiya manbachet yan mancojo, gui guimayuus, ya janafanjomlo. ");
INSERT INTO cha_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lao y magas na mamale sija, yan y escriba sija, ninafalalalo anae jalie y mannamanman sija ni y jafatitinas, yan y famaguon sija ni y manaagang gui guimayuus, ya ilegñija: Hosana y Lajin David; ");
INSERT INTO cha_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ya ilegñija nu güiya: Ti unjungog jafa este ilegñiñija? Si Jesus ilegña nu sija: Junggan. Taya nae untaetae: Guinin pachot y famaguon yan y mañususo, unnacabales y tinina? ");
INSERT INTO cha_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ya jadingo sija, jumuyong gui siuda asta Betania; ya sumaga güije. ");
INSERT INTO cha_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y egaan, anae tumalo guato gui siuda, ñalang. ");
INSERT INTO cha_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ya jalie un trongcon igos jijot gui chalan, ya malag ayo, lao taya sinedaña na jagonja; ya ilegña: Ti unfanogcha asta ni ngaean. Ya ti apmam y igos anglo. ");
INSERT INTO cha_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Anae malie este ni y disipulo sija, ninafanmanman, ya ilegñija: Nachinadeg y igos anglo! ");
INSERT INTO cha_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ya maninepe as Jesus, ilegña: Magajet jusangane jamyo, na yaguin guaja jinengguenmiyo, ya ti buebuente jamyo, infatinas ti esteja ni y mafatinas gui y igos; lao yaguin insangane este na ogso ya ilegmiyo: Janao ya unyutejao gui tase, umafatinas. ");
INSERT INTO cha_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sa todosija y ingagao an manmanaetae jamyo ya injenggue, infanmanresibe. ");
INSERT INTO cha_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ya anae jumalom gui guimayuus, y magas na mamale sija, yan manamco na taotao sija, manmato guiya güiya, anae estaba mamananagüe, ya ilegñija: Jafa na ninasiña na unfatinas estesija? ya jayejao numae nu este na ninasiñamo? ");
INSERT INTO cha_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ya maninepe as Jesus, ilegña nu sija: Guajo locue jufaesen jamyo un sinangan; yaguin insangane yo, guajo locue jusangane jamyo jafa na ninasiña muna jufatitinas este. ");
INSERT INTO cha_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Y tinagpangen Juan, guine mano? Guine y langet, pat y taotao sija? Ayo nae sija jajajaso gui sumanjalomñija ilegñija: Yaguin ilegmame, guine y langet; ualog nu jame: jafa nae na ti injenggue? ");
INSERT INTO cha_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yaguin ilegmame: Y taotao sija; manmaañaojam ni y taotao sija; sa pineloñija todo na profeta si Juan. ");
INSERT INTO cha_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ya manope ilegñija as Jesus: Ti intingo. Si Jesus locue ilegña nu sija: Ni guajo ti jusangane jamyo, pot jafa na ninasiña na jufatinas este. ");
INSERT INTO cha_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Lao jafa pinelonmimiyo? Un taotao guaja dos lajiña, ya mato guiya y finena ya ilegña: Lajijo, janao fachocho gui fangualuan ubas. ");
INSERT INTO cha_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ya manope, ilegña: Munga yo; lao despues mañotsot ya mapos. ");
INSERT INTO cha_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mato guiya y otro, ya jasanganeja talo taegüije: Ya inepe ilegña: Guajo, señot, bae jujanao, lao ti jumanao. ");
INSERT INTO cha_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jaye guiya sija na dos fumatinas y minalago y tata? Sija ilegñija: y finenena. Ylegña si Jesus nu sija: magajet jusangane jamyo, na y publicano sija, yan y manputa sija, ufanjalom gui raenon Yuus gui menanmiyo. ");
INSERT INTO cha_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sa mato si Juan guiya jamyo gui chalan tininas, ya ti injenggue güe; ya y publicano sija, yan y manputa sija majonggue güe: lao jamyo, anae inlie, ti manmañotsot jamyo para injenggue güe. ");
INSERT INTO cha_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ecungog otro acomparasion: Un taotao, tatan un familia, japlanta un fangualuan ubas, y jacolat nu y trongco ni y tituca, ya jaguadog gui entalo un lagat, ya jafatinas un tore, ya janamaatquila gui manfafachocho, ya maposgüe malag otro tano. ");
INSERT INTO cha_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ya anae esta jijot y tiempon y tinegcha, jatago y tentagoña sija para ayo y manfafachocho, para ujaresibe y tinegcha sija. ");
INSERT INTO cha_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lao y manfafachocho jacone y tentago sija, y japanag y uno, japuno y otro, ya jatagas nu y acho y otro. ");
INSERT INTO cha_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jatago talo y palo tentagoña sija, mas qui y finenana: ya manmafatinasja talo taegüije. ");
INSERT INTO cha_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Y uttimo jatago y lajiña, ilegña: Ufangaerespeto ni y lajijo. ");
INSERT INTO cha_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lao anae malie ni y manfafachocho, na y lajiña, ilegñija gui sumanjalomñija: Estagüiya y eredero, maela ya tapuno, ya tachule y fangualuanña. ");
INSERT INTO cha_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ya macone ya mayute juyong gui fangualuan, ubas, y mapuno. ");
INSERT INTO cha_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Anae mato y señot y fangualuan ubas, jafa umafatinas contra ayo y manfafachocho? ");
INSERT INTO cha_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sija ilegñija uguefyulang y manaelaye: ya y fangualuan ubas unamaatquila gui otro manfafachocho na umapasegüe ni tinegcha gui tiempo. ");
INSERT INTO cha_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Se Jesus ilegña nu sija: Taya nae intaetae y Tinigue sija: Y acho ni y jarechasa y manmamatitinas y guima, esteja mapolo cuentan ulo gui esquina: este finatinas y Señot ya janafanmanman y atadogta? ");
INSERT INTO cha_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Enao mina jusangane jamyo, na y raenon Yuus umanajanao guiya jamyo, ya ufanmanae ayo sija na taotao y fumatinas para umegae y tinegchaña. ");
INSERT INTO cha_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ya y pedong gui jilo este na acho, umayulang; ya, yaguin y jiloña nae podong, umapedasitos. ");
INSERT INTO cha_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ya anae majungog ni y magas na mamale sija yan y Fariseo sija, y acomparasionña sija, jinasonñija na pot sija na jasasangan. ");
INSERT INTO cha_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ya anae maaligao para umaconegüe, manmaañao ni taotao sija, sa maatangüe pot profeta. ");
INSERT INTO cha_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","SI Jesus manope ya jacuentuse sija talo y acomparasion sija ilegña, ");
INSERT INTO cha_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Y raenon langet, parejo yan un ray, na jafatinas gupot umasagua para y lajiña. ");
INSERT INTO cha_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ya jatago y tentagoña sija, na ujaagange y manmaconbida gui guipot; lao ti manmalago manmato. ");
INSERT INTO cha_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jatago talo palo tentagoña, ilegña: Sangane y manmaconbida: Esta jufamauleg y na taloane, y gajo toro yan y manyomog na gajo, esta manmapuno, ya todo esta listo: fanmamaela gui guipot umasagua. ");
INSERT INTO cha_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lao sija ti jaatituye, ya manmapos, y uno para y fangualuaña, y otro para y cometsioña. ");
INSERT INTO cha_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Y palo macone y tentagoña ya manamamajlao, ya manmapuno. ");
INSERT INTO cha_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lao y ray ninalalalo; ya jatago y sendaluña sija na ujapuno todo ayo y mamuno sija, ya ujasonggue y siudaña. ");
INSERT INTO cha_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ayo nae ilegña ni y tentagoña sija: Y guipot umasagua esta listo; lao ayo sija y manmaconbida ti mandigno. ");
INSERT INTO cha_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Janao fanmalag y mafapoposgüe na chalan, ya inagange para y guipot umasagua todo y inseda. ");
INSERT INTO cha_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ya manmapos y tentago sija para y chalan, ya janafandaña todo y jasoda, parejo y taelaye yan y mauleg; ya y guipot umasagua bula ni manmaconbida. ");
INSERT INTO cha_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ya anae jumalom y ray para ulie y manmaconbida, jalie güije un taotao na ti minagago ni y magagon gupot. ");
INSERT INTO cha_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ya ilelegña nu guiya: Amigo, jafa na jumalomjao güine ya taya magagumo magagon gupot? Lao güiya ti cumuentos. ");
INSERT INTO cha_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ayo nae y ray ilegña ni y manmañeñetbe: Gode y adengña, yan y canaeña, ya inchile, ya inyite juyong gui jalom jomjom: ayo nae uguaja tumanges, yan chegcheg nifen. ");
INSERT INTO cha_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sa megae manmaagang; lao didide manmaayig. ");
INSERT INTO cha_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ayo nae manmapos y Fariseo sija, ya manacuentuse jafa taemano ninagadon güe ni y cuentosña. ");
INSERT INTO cha_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ya jatago guato guiya güiya y disipuloñija yan iyon Herodes, ilegñija: Maestro, intingo na jago magajetjao, ya mamananagüejao na magajet y chalan Yuus; ya taya unadadaje ni jaye; sa ti uno na guaelaye guiya jago y finaboresen taotao. ");
INSERT INTO cha_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sangane jam nae, jafa jinasosomo? Tunas na infanmanaejam tributo as Sesat, pat aje? ");
INSERT INTO cha_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lao si Jesus jatungo y tinaelayeñija, ya ilegña: Jafa muna intientayo, hipocritas? ");
INSERT INTO cha_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Fanueyofan ni y salape y tributo. Ya sija machuliegüe un dinario. ");
INSERT INTO cha_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ayo nae ilegña nu sija: Jaye iyo este na imagen yan y tinigue ni y gaigue gui jiloña? ");
INSERT INTO cha_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sija ilegñija nu güiya: Iyon Sesat. Ayo nae ilegña nu sija: Nae si Sesat ni iyon Sesat, ya si Yuus ni iyon Yuus. ");
INSERT INTO cha_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ya anae sija jajungog este na sinangan, ninafanmanman, ya madingo güe ya manmapos. ");
INSERT INTO cha_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ayo na jaane, manmato guiya güiya y Saduseo sija, ni y ilegñija na taya quinajulo y manmatae, ya mafaesen güe, ");
INSERT INTO cha_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ylegñija: Maestro, si Moises ilegña, Yaguin jaye na taotao matae ya taya patgonña, y cheluña uasagua yan y asaguaña, ya unacajulo semiya gui cheluña. ");
INSERT INTO cha_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Guaja guiya jame siete na lalaje mañelo; ya y finena umasagua ya matae, ya taya patgonña, japolo y asaguaña gui cheluña. ");
INSERT INTO cha_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Parejoja talo y mina dos, yan y mina tres, asta y mina siete. ");
INSERT INTO cha_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Anae munjayan manmatae todosija, matae y palaoan locue. ");
INSERT INTO cha_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y quinajulo y manmatae, jaye gui siete ugaeasagua y palaoan? sa todosija maninasagua. ");
INSERT INTO cha_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ayo nae maninepe as Jesus, ilegña: Manabag jamyo sa ti intingo y Tinigue sija, ni y ninasiñan Yuus. ");
INSERT INTO cha_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sa y quinajulo y manmatae, ni manasagua ni umanafanasagua, sa manparejoja yan y angjet sija gui langet. ");
INSERT INTO cha_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ya y quinajulo y manmatae, ada ti intaetae y esta masangan pot si Yuus nu jamyo na ilegña: ");
INSERT INTO cha_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Guajo si Yuus Abraham, yan si Yuus Ysaac, yan si Yuus Jacob? Ti güiya si Yuus y manmatae, na Yuus y manlâlâlâ. ");
INSERT INTO cha_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Anae majungog este nu y linajyan taotao, ninafanmanman ni y finanagüeña. ");
INSERT INTO cha_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lao anae y Fariseo sija majungog na janafanmamatquilo y Saduseo sija, mandaña gui un lugat. ");
INSERT INTO cha_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ya mafaesen güe, uno guiya sija, ni y magas y lay, tinienta güe, ilegña: ");
INSERT INTO cha_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, jafa y mas dangculo na tinago gui lay? ");
INSERT INTO cha_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Si Jesus ilegña nu güiya: Guaeya y Señot Yuusmo con todo y corasonmo, yan todo y antimo, yan todo y jinasomo. ");
INSERT INTO cha_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Este y finenana yan y dangculo na tinago. ");
INSERT INTO cha_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya y mina dos parejoja yan este: Guaeya y tiguangmo parejo yan jago. ");
INSERT INTO cha_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Este y dos na tinago chinileja todo y lay yan y profeta. ");
INSERT INTO cha_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ya enae estaba y Fariseo sija mandadaña, si Jesus manfinaesen sija; ");
INSERT INTO cha_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ylegña: Jafa jinasonmiyo as Cristo? jaye gaelaje güe? Sija ilegñija: Lajin David. ");
INSERT INTO cha_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Güiya ilegña nu sija: Jafa na si David gui Espiritu finanaan güe Señot, ilegña: ");
INSERT INTO cha_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Y Señot jasangane y Señotjo, fatachong gui agapa na canaejo, asta qui jupolo y enemigumo gui papâ adengmo. ");
INSERT INTO cha_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yaguin si David finanaan güe Señot, jafa taemano lajiña? ");
INSERT INTO cha_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ya taya siña ni uno umope güe. Ya desde ayo na jaane taya umatrebe güe para umafaesesen güe ni jafa. ");
INSERT INTO cha_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","AYO nae si Jesus, jacuentuse y linajyan taotao, yan y disipuluña sija, ");
INSERT INTO cha_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ylegña: Y escriba yan y Fariseo sija manmatatachong gui tachong Moises; ");
INSERT INTO cha_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Todo y mansinangane jamyo na inadaje, fatinas yan adaje; lao chamiyo fumatitinas taegüije y finatinasñiñija, sa sija jasasangan, lao ti jafatitinas. ");
INSERT INTO cha_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sa manmangogode catga sija na manmacat ya mapot machule, ya japolo gui jilo y apagan y taotao sija; lao sija ni y calalotñija ti manmalago janacalamten. ");
INSERT INTO cha_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Lao todo y chechoñija, jafatinas para umalie ni y taotao sija sa janaancho y filacteriañija, ya jajujuto y madoblan y magagonñija. ");
INSERT INTO cha_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ya yañija y finenana na saga gui guipot, yan y finenana na tachong gui sinagoga; ");
INSERT INTO cha_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yan y manmasaluda gui plasa, yan ufanmafanaan ni y taotao sija, Rabi. ");
INSERT INTO cha_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lao jamyo chamiyo fanmalalago manmafanaan. Rabi; sa unoja Maestronmiyo, ya todo jamyo mañelo. ");
INSERT INTO cha_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chamiyo fanmamananaan ni uno tatanmiyo gui tano; sa unoja Tatanmiyo, na gaegue gui langet. ");
INSERT INTO cha_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni infanmamanaan uno amunmiyo; sa unoja amunmiyo, si Cristo. ");
INSERT INTO cha_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lao y mas dangculo guiya jamyo, güiya utentagonmiyo. ");
INSERT INTO cha_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sa jayeja y munadangculon namae sagüe, umumitde; ya jayeja y munaumitden namaesagüe, güiya udangculo. ");
INSERT INTO cha_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Lao ay ay para jamyo escriba yan Fariseo sija, hipocrita! sa injichom y raenon langet gui menan y taotao sija; ya ni jamyo ti manjalom, ni y para ufanjalom ti inpelo na ufanjalom. ");
INSERT INTO cha_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ay ay para jamyo, escriba yan Fariseo sija, hipocrita! sa inticho y guima y biuda sija yan inagó y tinaetae; pot este inresibe dangculo na sentensia.) ");
INSERT INTO cha_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ay ay para jamyo, escriba yan Fariseo sija, hipocrita! sa inlilicue y tase yan y tano para infatinas un prosélito, ya anae esta infatinas, infatitinas güe lalajin sasalaguan dosbiaje mas qui jamyo. ");
INSERT INTO cha_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ay ay para jamyo, bachet na guia sija ni y ilegmiyo: Jayeja y manjula pot templo, taya este; lao jayeja y manjula pot y oron y templo, gaeisao güe. ");
INSERT INTO cha_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Manbababa yan manbachet! Jafa mas dangculo, y oro pat y templo, ni y munasantos y oro? ");
INSERT INTO cha_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ya jayeja y manjula pot y attat, taya este; lao jayeja y manjula pot y ninae ni gaegue gui jiloña, gaeisao güe. ");
INSERT INTO cha_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Manbachet jamyo! Jafa mas dangculo, y ninae pat y attat ni munasantos y ninae? ");
INSERT INTO cha_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Enao mina y manjula pot y attat, manjula pot ayo yan todo y guaja gui jiloña. ");
INSERT INTO cha_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ya y manjula pot y templo, manjula pot ayo yan pot güiya y sumaga gui jinalomña. ");
INSERT INTO cha_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ya y manjula pot y langet, manjula pot y trono Yuus, yan pot güiya ni gaegue na matatachong gui jiloña. ");
INSERT INTO cha_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ay ay para jamyo, escriba yan Fariseo sija, hipocrita! sa manmanapase jamyo diesmo y yetba buena, yan anis yan comino, ya inpelo y mas dangculo gui lay; y juisio, y minaase, yan y jinenggue. Este nesesita umafatinas, ya munga mapolo na ti infatinas y otro sija. ");
INSERT INTO cha_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bachet jamyo na guia sija! sa inguicula y ñamo, ya inpapañot y cameyo. ");
INSERT INTO cha_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ay ay para jamyo, escriba yan Fariseo sija, hipocrita! sa infagagase y sumanjiyeng y posuelo yan y plato; lao y sumanjalom bula inamot yan minampos. ");
INSERT INTO cha_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo bachet jao! fagase finena y sumanjalom gui posuelo yan y plato, ya despues y sumanjiyong ugasgas locue. ");
INSERT INTO cha_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ay ay para jamyo, escriba yan Fariseo sija, hipocrita! sa manparejo jamyo yan y manmablanquea na naftan na y sanjiyongña magajet na mauleg malie: lao y sumanjalomña bula tolang manmatae, yan todo y ináplacha. ");
INSERT INTO cha_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taegüenao locue jamyo y sumanjiyong magajet na manunas malie jamyo ni taotao sija; lao y sumanjalom bula hipocresia yan inechong. ");
INSERT INTO cha_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ay ay para jamyo escriba yan Fariseo sija, hipocrita! sa infatinas naftan y profeta sija, ya inadotna y naftan y manunas, ");
INSERT INTO cha_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ya ilegmiyo: Yaguin mangaeguejam gui jaanin y tatanmame sija, ti infangachong yan sija gui jâgâ y profeta sija. ");
INSERT INTO cha_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ayo mina jamyo mismo innae testimonio contra jamyo, na jamyo famaguon ayo sija y pumuno y profeta sija. ");
INSERT INTO cha_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jamyo locue innabula y medidan y tatanmiyo. ");
INSERT INTO cha_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Colebla sija, rasan colebla sija! Jaf taemano jamyo insujaye gui sentensian sasalaguan? ");
INSERT INTO cha_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Enaomina estagüeyo na junae jamyo profeta sija, yan manmalate yan escribasija; ya palo guiya sija inpino ya inatane gui quiluus; ya y palo guiya sija, inpanag gui sinagoganmiyo, ya inpetsigue sija guinin siuda asta siuda; ");
INSERT INTO cha_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Para ufato gui jilomiyo todo y tunas na jâgâ ni y machuda gui jilo y tano, desde y jâgân Abel y tinas, asta y jâgâ Sacharias, lajin Barachias, ni inpino gui entalo templo yan y attat. ");
INSERT INTO cha_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Magajet jusagane jamyo, na todo estesija ufanmato gui jilo este na generasion. ");
INSERT INTO cha_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem! Jerusalem! ni y pumuno y profeta sija, ni infagas ni acho todo y manmatago para jago, cuanto biaje malagoyo na jurecoje y famaguonmo, calang y ponedera yan jarecoje y poyitasña sija gui papa papaña, lao ti manmalago jamyo! ");
INSERT INTO cha_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Estagüe na madingo guiya jamyo y guimanmiyo na ti mataotagüe. ");
INSERT INTO cha_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sa guajo jamyo sumangane, na desde pago, ti inliiyo, asta qui ilegmiyo: Dichoso güe y mato. pot y naan y Señot. ");
INSERT INTO cha_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","YA si Jesus jumuyong gui templo ya mapos; manmato y disipuluña sija, para umafanue ni y mafatinas y templo. ");
INSERT INTO cha_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Si Jesus jaope sija, ilegña: Ti inlie todo estesija? Magajet jusangane jamyo, na ti umapolo güine un acho gui jilo otro acho, na ti umayulang. ");
INSERT INTO cha_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ya anae matatachong güe gui sabana Olibo, manmato guiya güiya y disipulo sija, ya ilegñija: Sangane jam ngaean ufanjuyong estesija na güinaja, yan jafa taemano na señat y finatomo, yan y jinecog y tiempo? ");
INSERT INTO cha_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ya maninepe as Jesus, ilegña: Adaje ya chamiyo fanmadadague ni jaye. ");
INSERT INTO cha_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sa megae ufanmato pot y naanjo, ya ujaalog: Guajo si Cristo; ya megae ujadague. ");
INSERT INTO cha_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ya infanmanjungog guera yan sinangan nu y guera; atan ya chamiyo ninafañachatsaga; sa nesesita na todo este ufanjuyong, lao trabia ti y jinecog. ");
INSERT INTO cha_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sa ufangajulo nasion contra nasion, yan raeno contra raeno; ya uguaja ñinalang yan linao gui lugat sija. ");
INSERT INTO cha_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ya todo este sija na güinaja y tutujon y pininite. ");
INSERT INTO cha_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ayo nae infanmaentrega para infanmanapute, ya infanmapuno; ya infanmachatlie gui todo nasion pot y naanjo. ");
INSERT INTO cha_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ya megae innafanmatompo; ya ufanaentrega unos y otros, ya ufanachatlie unos y otros. ");
INSERT INTO cha_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ya megae ti manmagajet na profeta ufangajulo, ya ujadague megae. ");
INSERT INTO cha_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ya pot y janamegae y tinaelaye, y güinaeyan y megae janamanenggeng. ");
INSERT INTO cha_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lao y sumungon asta y jinecog, este usatba. ");
INSERT INTO cha_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ya umapredica este y ebangelion y raeno gui todo y tano, para testimonio gui todo y nasion, ya ayo nae ufato y jinecog. ");
INSERT INTO cha_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Enaomina an inlie y chinatlie y inginon na yinilang, ni y jasangan si Daniel profeta ni tumotojgue gui santos na lugat; (y tumataetae güiya utungo). ");
INSERT INTO cha_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ayo nae y mangaegue guiya Judea, manmalago para y taquilo na jalomtano; ");
INSERT INTO cha_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ya y gaegue gui jilo atof, ti ufanunog ya ujachule jafa gui guimaña; ");
INSERT INTO cha_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ya y gaegue gui fangualuan, ti ufanalo tate ya ujachule y magagoña. ");
INSERT INTO cha_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lao ay ay para y manmapotgue, yan y mannanasuso, güije na jaane! ");
INSERT INTO cha_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Fanmanaetae, sa y jinanaonmiyo, munga gui tiempon manenggeng ni y sabado. ");
INSERT INTO cha_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sa ayo na tiempo uguaja dangculo na pininite, ya desde y tutujon y tano asta pago, taya nae guaja; ya taya mas na uguaja asta jinecog. ");
INSERT INTO cha_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yaguin ayo na jaane sija ti manafangadada, ni un catne usiña ninalibre; lao pot y manmaayig, ayo sija na jaane umanafangadada. ");
INSERT INTO cha_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yaguin jaye na taotao umalog nu jago: Estagüe si Cristo, pat ayo; chamo jumojonggue. ");
INSERT INTO cha_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sa ufangajulo y ti manmagajet na Cristo yan ti manmagajet na profeta sija; ya ufanmamanue dangculo na señat sija, yan mannamanman, ya, yaguin siña, ujadagueja asta y manmaayig. ");
INSERT INTO cha_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Estagüe na jusangane jamyo antes. ");
INSERT INTO cha_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yaguin ilegñija nu jamyo: Estagüe na gaegue güi desierto, chamo jumajanao; pat, Estagüe, na gaegue gui sanjalom gui cuatto, chamo jumojonggue. ");
INSERT INTO cha_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sa calang y lamlam ni y jumuyong gui sancatan, ya manina gui sanlichan, taegüijija locue y minamaela y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sa manoja nae mañaga y tataotao y matae, ayo locue nae ufandaña y aguila sija. ");
INSERT INTO cha_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ti apmam despues di y pininiten ayo sija na jaane, y atdao ujomjom, ya y pilan ti ufanina; ya y pution sija ufamodong guine y langet; ya y nina siñan y langet ufanmayengyong. ");
INSERT INTO cha_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ayo nae uanog señat y Lajin taotao gui langet; yan ayo nae ufanugung todo y tribu sija gui tano; ya ujalie y Lajin taotao na mamamaela gui jilo y mapagajes sija gui langet, yan y ninasiñaña yan y dangculon minalagña. ");
INSERT INTO cha_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ya utago y angetña sija yan y dangculo na catin y trompeta ya ujanadaña y inayigñija guine y cuatro manglo, desde y un punta gui langet asta y otro. ");
INSERT INTO cha_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tingo y acomparasion y trongcon igos. Yanguin y ramasña mañaña ya manjagon, intingo na jijot y fañomnagan. ");
INSERT INTO cha_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Taegüenaoja locue jamyo, yaguin inlie todo este sija na güinaja, intingoja na esta jijot gui petta sija. ");
INSERT INTO cha_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Magajet jusangane jamyo, na ti ufanmalofan este na generasion, asta qui todo este sija na güinaja manmacumple. ");
INSERT INTO cha_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Y langet yan y tano ufanmalofan; lao y sinanganjo sija ti ufanmalofan. ");
INSERT INTO cha_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Lao ayo na jaane yan ayo na ora, taya tumungo, ni y angjet sija gui langet ni y Lajiña, na y Tatajoja. ");
INSERT INTO cha_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Lao calang y jaanin Noe, taegüijija locue y minamaela y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sa ayo na jaane sija y antes di y dilubio, estaba mañochocho yan manguiguimen, ya manasagua, yan manafanaasagua, asta ayo na jaane anae jumalom si Noe gui atca, ");
INSERT INTO cha_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ya ti jatungo asta qui mato y dilubio, ya manchinile todos sija; taegüijija locue y minamaelan y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ya ayo na jaane uguaja dos gui fangualuan; y uno umacone, ya y otro umapolo: ");
INSERT INTO cha_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dos palaoan manguguleg gui mitate; y uno umacone, y ya otro umapolo. ");
INSERT INTO cha_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Fanbela sa ti intingo jafa na jaane nae ufato y Señotmiyo. ");
INSERT INTO cha_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tingo este na yaguin y gaeguima jatungo ngaean nae ufato y saque, ubelagüe, sa ti upolo na umayulangguan ni iyasija. ");
INSERT INTO cha_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Enao mina jamyo locue fanlisto, sa y Lajin taotao ufato güije na ora gui anae ti injajaso. ");
INSERT INTO cha_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jaye y tifáfababa yan y malate na tentago, ni y señotña ninamagasgüe gui guimaña, para uninanae sija nañija gui tiempo? ");
INSERT INTO cha_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dichoso ayo na tentago, yaguin mato y amuña ya sineda jafatitinas taegüije. ");
INSERT INTO cha_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Magajet jusangane jamyo, na uninamagasgüe todo gui iyoña. ");
INSERT INTO cha_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lao yaguin ayo y taelaye na tentago ilegña gui corasonña: Y amujo ufato atrasao; ");
INSERT INTO cha_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ya sigue di janafanlamen y mangachongña, y chumochocho yan gumiguimen yan y manbeglacho: ");
INSERT INTO cha_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Y señot ayo na tentago ufato güije na jaane gui anae ti jananangga yan y ora ni ti jatungo, ");
INSERT INTO cha_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ya uyenajo güe ni latigo yan ufinanue ni y patteña yan hipocrita sija ayo nae uguaja tumanges, yan chegcheg nifen. ");
INSERT INTO cha_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","AYO nae y raenon langet parejo yan dies na bitgen, ni jachule y lamparañija ya manmapos para ujatagam y nobio. ");
INSERT INTO cha_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ya y sinco guiya sija manmejnalom, ya y sinco manaetiningo. ");
INSERT INTO cha_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Y manaetiningo, jachule y lamparañija, ya ti manmañule laña. ");
INSERT INTO cha_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lao y manmejnalom manmañule laña gui baso, yan y lamparañija. ");
INSERT INTO cha_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ya anae atrasasao y nobio, manmatujog todo sija, ya manmaego. ");
INSERT INTO cha_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ya y tatalopuenge majungog un inagang, na ilegña: Estagüe y nobio na mamamaela! fanjuyong ya inresibe! ");
INSERT INTO cha_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ayo nae todo y bitgen sija mangajulo ya jafamauleg y lamparañija. ");
INSERT INTO cha_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ya y manaetiningo ilegñija ni manmejnalom: Naejam gui lañanmiyo sa y lamparanmame manmatae. ");
INSERT INTO cha_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ya y manmejnalom manmanope ilegñija: Munga sa ti mannajongjit; lao janao fanmalag y manmanbebende ya infanmamajan para jamyo namaesa. ");
INSERT INTO cha_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ya anae manmapos sija para ufanmamajan, mato y nobio; ya y estaba manlisto manjalom yan güiya gui guipot umasagua; ya majuchom y petta. ");
INSERT INTO cha_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Despues manmato y palo na bitgen ya ilegñija: Señot, Señot, babayejam. ");
INSERT INTO cha_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lao güiya manope, ilegna; Magajet jusangane jamyo na ti jutungo jamyo. ");
INSERT INTO cha_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Fanmagmata sa ti intingo y jaane ni y ora. ");
INSERT INTO cha_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sa uguaja parejo yan un taotao ni jumanao chago na tano, ya jaagang antes y tentagoña sija, ya jaentrega sija ni güinajaña. ");
INSERT INTO cha_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ya y uno janae sinco talento, ya y otro dos, ya y otro uno; ya cada uno taemano y guinefuloña; ya enseguidas mapos. ");
INSERT INTO cha_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ya y rumesibe y sinco na talento, janacometsio, ya jagana talo sinco na talento. ");
INSERT INTO cha_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Parejo locue yan y rumesibe dos, mangana talo dos. ");
INSERT INTO cha_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lao y rumesibe y uno, jumuyong ya jaguadog y eda, ya janaatog y salape y senotña. ");
INSERT INTO cha_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Despues di apmam na tiempo, mato y señot ayo sija na tentago, ya manacuentas yan sija. ");
INSERT INTO cha_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ya mato ayo y rumesibe sinco na talento, yan mañuñule talo sinco talento, ya ilegña: Señot, sinco na talento unnaeyo; estagüe talo sinco na junafangana. ");
INSERT INTO cha_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y senotña ilegña nu güiya: Mauleg chechomo, jago mauleg na tentago yan guesmanosguejao: guine unfatinas mauleg gui didide, bae jupoluyejao megae: jalom gui minagof y señotmo. ");
INSERT INTO cha_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mato locue ayo y rumesibe dos na talento, ya ilegña: Señot, dos na talento unnaeyo; estagüe talo dos talento na junafangana. ");
INSERT INTO cha_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Y señotña ilegña nu güiya: Mauleg chechomo, jago mauleg na tentago yan guesmanosguejao: guine unfatinas mauleg gui didide, bae jupoluyejao megae; jalom gui minagof y señotmo. ");
INSERT INTO cha_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mato locue ayo y rumesibe un talento, ya ilegña: Señot, guajo jutungo na jago majetogjao na taotao; sa mangongoco jao gui anae ti mananom jao, ya manrecocoje jao gui anae ti mañalapon jao; ");
INSERT INTO cha_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ya maañaoyo, ya maposyo ya junaatog y talentomo gui jalom y tano: estagüe ni iyomo. ");
INSERT INTO cha_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lao y señotña inepe güe ilegña: Taelayejao na tentago yan gago. Untungoja na mangongoco yo gui anae ti mananom yo, ya manrecocoje yo gui anae ti mañalapon yo; ");
INSERT INTO cha_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Enao mina jago nesesita unnae y banquero sija ni salapejo, ya yaguin matoyo, juresibe y iyoco yan ganansia. ");
INSERT INTO cha_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Enao mina umanajanao ayo na talento guiya güiya, ya umannae ayo y guaja dies na talento. ");
INSERT INTO cha_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sa jayeja y guaja, umannae güe, ya uguaja megae; lao y taya iyoña, achogja guaja güinajaña umanajanao. ");
INSERT INTO cha_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ya y taebalenña na tentago, yute juyong gui jalom jomjom, ayo nae uguaja tumanges yan chegcheg nifen. ");
INSERT INTO cha_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yaguin y Lajin taotao mato gui minalagña, yan todo y angjetña sija, ayo nae ufatachong gui jilo y tachong y minalagña; ");
INSERT INTO cha_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ya umanafandaña gui menaña todo y nasion sija; ya umanafañajnge y uno gui otro, calang y pastot yan janasajnge y quinilo sija gui chiba; ");
INSERT INTO cha_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ya japolo y quinilo sija gui agapaña, ya y chiba gui acagüeña. ");
INSERT INTO cha_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ayo nae y ray ualog ni mangaegue gui agapaña: Maela jamyo mandichoso gui Tatajo, ya inereda y raeno ni esta listo para jamyo desde y mafatinas y tano; ");
INSERT INTO cha_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sa anae ñalangyo, innachocho yo; anae majoyo, innaguimen yo; anae taotaojuyong yo, innajalom yo; ");
INSERT INTO cha_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Anae taya magagojo, innaminagago yo. Anae malangoyo, inbesita yo; anae gaegue yo gui calaboso, manmato jamyo guiya guajo. ");
INSERT INTO cha_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ayo nae y manunas manmanope güe ilegñija: Señot, ngaean nae inliijao ñalang, ya innachocho jao? pat majo, ya innaguimen jao? ");
INSERT INTO cha_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ngaean nae inliijao taotaojuyong, ya innajalom jao? pat anae taya magagomo, ya innaminagago jao? ");
INSERT INTO cha_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pat ñgaean nae inliijao malango, pat y calaboso, ya manmatojam guiya jago? ");
INSERT INTO cha_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y ray ujaope ilegña nu sija: Magajet jusangane jamyo, taemanoja na y infatinas ni uno güine gui mandiquique na mañelujo, infatinasja locue nu guajo. ");
INSERT INTO cha_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ayo nae ilegña locue ni y mangaegue gui acagüeña: Fanjanao guiya guajo, jamyo matdito, fanmalag y taejinecog na guafe, ni esta manalisto ni anite yan y anjetña sija; ");
INSERT INTO cha_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sa anae ñalangyo, ti innachocho yo; anae majoyo, ti innaguimen yo; ");
INSERT INTO cha_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Anae taotaojuyong yo, ti innajalom yo; anae taya magagojo, ti innaminagago yo; malangoyo, yan gaegue yo gui calaboso, lao ti inbesita yo. ");
INSERT INTO cha_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ayo nae ufanmanope locue sija, ilegñija: Señot, ngaean nae inliijao ñalang, pat majo, pat taotaojuyong, pat taya magagomo, pat malango, pat gui calaboso, ya ti insetbejao? ");
INSERT INTO cha_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ayo nae ujaope sija, ilegña: Magajet jusangane jamyo, na taemanoja ti infatinas nu uno güine gui mas mandiquique, ti infatinas nu guajo. ");
INSERT INTO cha_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ya esta sija manmapos para y taejinecog na minasapet; lao y manunas para y taejinecog na linala. ");
INSERT INTO cha_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","YA susede anae munjayan si Jesus jasangan este sija na sinangan, ilegña ni disipuluña sija; ");
INSERT INTO cha_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Intingo na dos na jaane talo umafatinas y guipot; ya y Lajin taotao umaentrega para umatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ayo nae y prinsipen y mamale sija, yan y manbijo na taotao sija, mandaña gui palasyon y magas na pale, y naanña si Caefas: ");
INSERT INTO cha_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ya manaconseja entresija para ujacone si Jesus pot dinague, ya ujapuno. ");
INSERT INTO cha_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lao ilegñija: Munga gui jaanin y guipot, sa munga na umafatinas yinaoyao gui taotao sija. ");
INSERT INTO cha_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ya anae estaba si Jesus guiya Betania, gui guima Simon y ategtog, ");
INSERT INTO cha_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mato guiya güiya un palaoan, na guaja un boteya alabastron ungüento na dangculo baliña, ya jachuda gui jilo iluña, anae estaba gui lamasa na matatachong: ");
INSERT INTO cha_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lao anae malie ni disipuluña sija, ninafanlalalo, ya ilegñija: Jafa na jagagasta este? ");
INSERT INTO cha_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sa este na ungüento siña mabende pot dangculo na presio, ya ufanmanae y mamoble. ");
INSERT INTO cha_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Anae jatungo si Jesus, ilegña nu sija: Jafa na innachatsaga y palaoan? sa jafatinas mauleg na chocho para guajo. ");
INSERT INTO cha_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sa jamyo guaja siempre mamoble manjajamyo, lao guajo, siempre taya. ");
INSERT INTO cha_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sa jachuda este na ungüento gui tataotaojo, jafatinas para majafotjo. ");
INSERT INTO cha_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Magajet jusangane jamyo: Mano nae este na ebangelio na umapredica gui todo y tano, uguajaja locue este y finatinasña este na palaoan, masangan para memoriasña. ");
INSERT INTO cha_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ayo nae y uno gui dose, y naanña si Judas Iscariote, mapos malag y prinsipen y mamale sija, ");
INSERT INTO cha_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ya ilegña: Jafa malagomiyo innaeyo, ya juentrega jamyo nu güiya? Ya manmapesa para güiya treinta pidason salape. ");
INSERT INTO cha_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ya desde ayo, manmanaliligao lugat para umaentrega güe. ");
INSERT INTO cha_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ya y finenana na jaanin gupot pan sin lebadura, manmato y disipulo gui as Jesus, ya ilegñija: Mano nae malagojao ya infamaulequejao namo gui guipot? ");
INSERT INTO cha_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ya ilegña: Janao fanmalag y siuda, gui guima ayo na taotao, y insangane: Y Maestro ilegña, y tiempoco esta jijot, iyajamyo nae jufatinas y guipot Pascua yan y disipulojo sija. ");
INSERT INTO cha_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ya y disipulo sija jafatinas y mantinago as Jesus, ya manalisto y guipot pascua. ");
INSERT INTO cha_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ya anae pupuenge güije na jaane, matachong gui lamasa yan y dose na disipulo; ");
INSERT INTO cha_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ya anae mañochocho güiya ilegña: Magajet jusangane jamyo, na uno guiya jamyo uentregayo. ");
INSERT INTO cha_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sija ninafangostriste, ya sigue di ilegñija cada uno nu güiya: Buente guajo, Señot? ");
INSERT INTO cha_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ayo nae manope ilegña: Y munajalom y canaeña yan guajo gui plato, güiya uentregayo. ");
INSERT INTO cha_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Magajet na y Lajin taotao ujanao, calang y esta matugue nu güiya; lao ay ay para ayo na taotao ni y jaentrega y Lajin taotao! maulegña mojon ayo na taotao na ti umafañago. ");
INSERT INTO cha_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ayo nae manope si Judas, ni umentrega güe, ilegña: Guajo buente Rabi? Ylegña nu güiya: Jago guinin sumangan. ");
INSERT INTO cha_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ya mientras mañochocho, jachule si Jesus y pan, ya jabendise, ya jaipe, ya janae y disipoluña sija, ya ilegña: Chule, ya cano; este y tataotaojo. ");
INSERT INTO cha_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jachule y copa, ya janae si Yuus grasias, ya janae sija ni y copa, ilegña: Fanguimen jamyo todo. ");
INSERT INTO cha_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sa este y jâgâjo gui Nuevo Testamento, ni y machuda para megae, para inasiin y isao. ");
INSERT INTO cha_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya jusangane jamyo, na desde pago ti juguimen mas y tinegcha ubas, asta ayo na jaane anae para juguimen nuebo yan jamyo gui raenon Tata. ");
INSERT INTO cha_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ya anae munjayan jacanta un himno, manmapos para sabana Olibo, ");
INSERT INTO cha_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ayo nae si Jesus ilegña nu sija: Todos jamyo ufanmañoda guiya guajo ocasion inale pago na puenge; sa matugue esta: Junafañetnot y pastot, ya y quinilo sija manmachalapon gui manada. ");
INSERT INTO cha_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lao despues di unacajuloyo talo gui entalo manmatae, jujanao gui menanmiyo guiyo Galilea. ");
INSERT INTO cha_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Si Pedro manope, ilegña nu güiya: Yaguin todos ufanmañoda guiya jago ocasion inale lao guajo ti jusoda para siempre ocasion inale. ");
INSERT INTO cha_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Si Jesus, ilegña: Magajet jusanganejao: na pago na puenge, antes di ucanta y gayo, undagueyo tres biaje. ");
INSERT INTO cha_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ylegña nu guiya si Pedro: Achogaja junesesita matae yan jago, lao ti judaguejao. Yan todo y palo disipulo sija, taegüenaoja ilegñija locue. ");
INSERT INTO cha_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ayo nae mato si Jesus yan sija gui güetta na mafanaan Gethsemane, ya ilegña ni disipuluña sija: Fanmatachong güine, ya jumanaoyo ya j ufanaetae güije guato. ");
INSERT INTO cha_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ya jacone gachongña si Pedro yan y dos lajin Sebedeo, ya jatutujon mantriste yan manmajalang. ");
INSERT INTO cha_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ayo nae si Jesus ilegña nu sija: Y antijo gostriste asta qui matae: fañaga güine, ya infanbela yan guajo. ");
INSERT INTO cha_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ya mamocat mona didide, tumecon ya manaetae, ilegña: Tatajo, yaguin siña, nafalofan este na copa guiya guajo: lao ti según y minalagojo, na según y minalagomo. ");
INSERT INTO cha_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ya mato gui disipuluña sija, ya jasoda sija na manmamaego: ya ilegña as Pedro: Jafa, ada ti siña jamyo infanbela yan guajo una ora? ");
INSERT INTO cha_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Fanbela ya infanmanaetae, para chamiyo fanjajalom gui tentasion: y espiritu magajet na malago lao y catne echecho. ");
INSERT INTO cha_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mapos talo gui segundo biaje ya manaetae, ilegña: Tatajo, yaguin ti siña este na copa malofan guiya guajo, yaguin ti juguimen, ufatinas y minalagomo. ");
INSERT INTO cha_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ya mato, ya jasoda talo sija na manmamaego; sa y atadogñija manmacat. ");
INSERT INTO cha_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ya jadingo sija, mapos talo ya manaetae gui mina tres biaje, jasangan ayoja na sinangan. ");
INSERT INTO cha_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ayo nae mato gui disipuluña sija, ya ilegña: Infanmamaegoja, pago, yan infandescacansaja; estagüe na mato y ora, ya y Lajin taotao esta maentrega gui canae y manisao sija. ");
INSERT INTO cha_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fangajulo na nije tafanjanao; estagüe esta mato y umentregayo. ");
INSERT INTO cha_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ya y tiempoja anae cumuecuentos güe, estagüe si Judas, uno gui dose, mato mañisija yan un dangculon linajyan taotao, manmañuñule espada yan galute, tinago y prinsipen y mamale sija yan y manamco na taotao sija. ");
INSERT INTO cha_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yan umentrega güe, mannae esta señat, ilegña: Y juchico, güiya; guesguot. ");
INSERT INTO cha_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ya enseguidas matogüe gui as Jesus, ya ilegña nu güiya: Minagof, Maestro! ya jachico. ");
INSERT INTO cha_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ya si Jesus, ilegña nu güiya: Amigo, jafajao na mato? Ayo nae manmato sija ya maguot si Jesus, ya macone. ");
INSERT INTO cha_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ya, estagüe, uno gui mangachong si Jesus, jajuto y canaeña, ya jalagnos y espadaña, y janalamen uno gui tentago y prinsipen y mamale sija, janajanao un talanga. ");
INSERT INTO cha_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ayo nae si Jesus ilegña nu güiya: Natalo guato y espadamo gui sagaña; sa todo y manmañuñule espada, nu y espadaja ufanpinino. ");
INSERT INTO cha_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ada jinasomo na ti siñayo jutayuyut si Tata pago, ya güiya unaeyo enseguidas mas di dose legion na angjet sija? ");
INSERT INTO cha_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lao jaftaemano macumple y Tinigue sija; sa matugue na taegüenao nesesita umafatinas este? ");
INSERT INTO cha_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ayo na ora ilegña si Jesus ni linajyan taotao: Manmato jamyo parejo yan contra y saque, na manmañuñule jamyo espada yan galute para inqueneyo? Cada jaane manjijitaja guajo matachong gui templo, mamnanagüe nu jamyo, ya ti inqueneyo. ");
INSERT INTO cha_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lao todo este umafatinas, para umacumple y Tinigue sija ni y profeta sija. Ayo nae todo y disipuluña sija madingo güe, ya manmalago. ");
INSERT INTO cha_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ya ayo sija y cumone si Jesus, macone güe guato gui as Caefas, magas na pale, anae manestaba y escriba sija yan y manamco na mandadaña. ");
INSERT INTO cha_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lao si Pedro, dinalalag güe chago asta qui mato gui colat y magas na pale; ya jumalom ya manmatachong yan y tentago sija, para ulie y uttimo. ");
INSERT INTO cha_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ya y prinsipen y mamale sija yan todo y inetnon ofisiat, manmanaliligao ni ti magajet na testimonio contra si Jesus, para umapuno. ");
INSERT INTO cha_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lao ni uno mañoda; achogja mato megae na ti manmagajet na testigo. Lao y uttimo manmato dos, ");
INSERT INTO cha_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Na ilegñija, Este na taotao ilegña: Guajo siña juyulang papa este na gumayuus, ya junacajulo gui tres na jaane. ");
INSERT INTO cha_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ya cajulo y magas y mamale, ya ilegña nu güiya: Ti unfanope ni jafa? Jafa este na testimonio contra jago? ");
INSERT INTO cha_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lao si Jesus mamatquiloja. Ya y magas y mamale ilegña nu güiya: Jutayuyutjao pot y lalâlâ na Yuus, na unsanganejam cao jago si Cristo, Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Si Jesus ilegña nu güiya: Jago guinin sumangan. Ya jusangane jamyo na desde pago inlie y Lajin taotao na matatachong gui agapa y ugaeninasiña na canae, ya umamaela gui jalom y mapagajes sija gui langet. ");
INSERT INTO cha_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ayo nae y magas y mamale, jatiteg y magaguña, ya ilegña: Cumuentos chatfino contra si Yuus: jafa mas na utanesesita testigo sija? Estagüe esta pago na injingog y chinatfino contra si Yuus. ");
INSERT INTO cha_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jafa pinelonmimiyo? Sija manmanope ilegñija: Jamerese y finatae. ");
INSERT INTO cha_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ayo nae matolae y mataña yan patmada güe; ya y palo manafañetnot nu y dinemo; ");
INSERT INTO cha_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ya ilegñija: Profetisayejam, O Cristo! jayejao munafañetnot? ");
INSERT INTO cha_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ya ayo na tiempo si Pedro estaba matatachong gui sumanjiyong gui guelat; ya mato guija güiya un palaoan tentago, ya ilegña: Manjajamjo locue yan si Jesus y Galileo. ");
INSERT INTO cha_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lao güiya jadague gui menan todos, ilegña: Ti jutungo jafa ilelegmo. ");
INSERT INTO cha_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ya anae jumuyong gui petta; linie ni otro palaoan, ya ilegña ni ayo y manestaba güije: Este locue mañisija yan si Jesus Nasareno. ");
INSERT INTO cha_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ya jadague talo ya manjula ilegña: Ti jutungo ayo na taotao. ");
INSERT INTO cha_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ti apmam despues manmato sija y mangaegue güije, ya ilegñija as Pedro: Magajet na jago locue uno guiya sija; sa y sinanganmo dumiclalara jao. ");
INSERT INTO cha_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ayo nae jatutujon mumatdise, yan manjula, ilegña: Ti jutungo ayo na taotao. Ya enseguidas cumanta y gayo. ");
INSERT INTO cha_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ya jajaso si Pedro y sinangan Jesus ni ilegña: Antes di ucanta y gayo, undagueyo tres biaje. Ya mapos juyong ya gueftumanges. ");
INSERT INTO cha_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","YA mato y egaan, todo y prinsipen y mamale, yan y manamco na taotao sija, mandaña y manaconseja entre sija contra si Jesus, para umapuno güe. ");
INSERT INTO cha_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ya anae munjayan magode güe, macone ya maentrega gui as Ponsio Pilato y magalaje. ");
INSERT INTO cha_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ayo nae si Judas, y umentrega güe, jalie na esta umayogua, ya mañotsot ya jachule talo guato y treinta pidason salape gui prinsipen y mamale yan y manamco na taotao sija, ");
INSERT INTO cha_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ya ilegña: Guajo isaoyo, juentrega y taeisao na jâgâ. Lao sija ilegñija: Jafa ayo guiyajame? Jagoja adaje. ");
INSERT INTO cha_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ya jayute y pidason salape jalom gui jalom y templo, ya mapos ya jañaca güe. ");
INSERT INTO cha_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ya y prinsipen y mamale sija, jachule y salape ya ilegñija: Ti tunas na tapolo gui tesoro sa baliña y jâgâ. ");
INSERT INTO cha_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ya manaconseja entre sija, ya mafajan y fangualuan oyero, para y naftan y taotaojuyong. ");
INSERT INTO cha_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ayo mina mafanaan ayo na fangualuan: Fangualuan jâgâ, asta pago na jaane. ");
INSERT INTO cha_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ayo nae macumple y sinangan na pot y profeta Jeremias, ni ilegña: Ya sija jachule y treinta pidason salape, presio ayo y gaebale, y presio na mapolo gui jiloña y famaguon Israel; ");
INSERT INTO cha_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ya manmanae sija, para ujafajan y fangualuan y oyero taegüenao, na jatagoyo y Señot. ");
INSERT INTO cha_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ya si Jesus estaba tomotojgue gui menan y magalaje, ya y magalaje finaesen güe, ilegña: Jago y Ray Judio sija? Si Jesus ilegña: Jago umalog. ");
INSERT INTO cha_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ya anae mafaaela ni y prinsipen y mamale, yan y manamco sija, ti manope ni jafa. ");
INSERT INTO cha_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ayo nae si Pilato ilegña nu güiya: Ti unjujungog cuanto na güinaja nae manmadeclara contra jago? ");
INSERT INTO cha_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ya ti manope ni un sinangan; ya ninagosmanman y magalaje. ");
INSERT INTO cha_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ya y jaanin y guipot, costumbreña y magalaje na usotta pot y taotao sija un preso, jaye y malagoñija. ");
INSERT INTO cha_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ya guaja presoñija uno na afamao, na y naanña si Barabas. ");
INSERT INTO cha_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ya anae mandaña ilegña si Pilato nu sija: Jaye malagonmiyo jusottaye jamyo? Si Barabas pat si Jesus, ni mafanaan Cristo? ");
INSERT INTO cha_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sa jatungoja na pot embidiañija muna maentrega güe. ");
INSERT INTO cha_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ya anae estaba güe na matatachong gui tribuna, y asaguaña manago nu güiya, ilegña: Chamo umeentalo nu enao tunas na taotao; sa pago jupadedese megae sija gui güinife pot güiya. ");
INSERT INTO cha_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lao y prisipen y mamale sija, yan y manamco sija jasoyo y taotao sija, na ujagagao si Barabas, ya si Jesus, umapuno. ");
INSERT INTO cha_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ya y magalaje manope, ilegña nu sija: Jaye gui dos malagonmiyo jusottaye jamyo? Sija ilegñija: Si Barabas. ");
INSERT INTO cha_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Si Pilato ilegña nu sija: Ya jafa jufatinas as Jesus ni mafanaan Cristo? Todos sija ilegñija: Umatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ya ilegña: Jafa na taelaye finatinasña? Lao sija managang mas duro, ilegñija: Umatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Anae jalie si Pilato na taya jafa na probecho, lao mas y ninafanyaoyao, mañule janom ya jafagase y canaeña gui menan y taotao sija, ya ilegña: Taeisaoyo gui jâgâ este y tunas na taotao: lie jamyo. ");
INSERT INTO cha_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ya manmanope todo y taotao sija ilegñija: Y jâgâña usaga guiya jame, yan y famaguonmame. ");
INSERT INTO cha_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ayo nae masotta si Barabas, ya an munjayan mapanag si Jesus, maentrega para umaatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ayo nae y sendalon y magalaje macone si Jesus gui pretorio, ya mandaña guiya güiya todo y manadan sendalo sija. ");
INSERT INTO cha_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ya mapula y magaguña, ya manaminagago agaga na magagon anaco. ");
INSERT INTO cha_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ya mapolo gui iluña un corona na mafatinas ni títuca sija, yan un piao gui agapa na canaeña; ya mandimo gui menaña, ya mamofefea, ilegñija: Jafa talatmanu jao Ray Judio sija! ");
INSERT INTO cha_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ya matolae güe, ya machule y piao ya mapanag y iluña. ");
INSERT INTO cha_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ya anae munjayan mamofefea, mapula y magagon anaco, ya manaminagago ni magaguña, ya macone para umaatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ya anae jumajanao manasoda yan un taotao Sirene na y naanña si Simon: este maobliga para uchinilie ni quiluusña. ");
INSERT INTO cha_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ya anae manmato gui un lugat na mafanaan Golgota, cumequeilegña, y sagan calabera, ");
INSERT INTO cha_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mannae para uguimen binagle, manadaña yan lalaet; ya anae jachague, ti malago jaguimen. ");
INSERT INTO cha_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Anae munjayan maatane gui quiluus, mandesapatta y magaguña, mayute suette sija gui jiloña; (para umacumple y mumayan masangan pot y profeta: Ujanaadesapatta y magagujo, ya y jilo y magagujo ufanmayute suette sija.) ");
INSERT INTO cha_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ya manmatachong, ya maadadaje güe güije. ");
INSERT INTO cha_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ya mapolo gui iluña y mafaelaña, matugue: ESTE SI JESUS RAY Y JUDIO SIJA. ");
INSERT INTO cha_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ayo nae maatane yan güiya gui quiluus yan y dos na saque; y uno gui agapaña ya y otro gui acagüeña. ");
INSERT INTO cha_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ya y taotao na manmalolofan, masangane güe innataelaye, ya jayeyengyong y iluñija, ");
INSERT INTO cha_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ya ilegñija: Jago y yumute papa y templo, ya y mina tres na jaane unnacajulo; libre maesajao; yaguin jago Lajin Yuus, tunog papa güenao gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Taegüinija locue mamofefea güe y prisipen mamale sija, yan y escriba sija, yan y Fariseo sija, yan y manamco na taotao sija, ilegñija: ");
INSERT INTO cha_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Janalibre y palo, ya ti siñagüe janalibre na maesa. Güiya y Ray y Israel; polo ya utunog papa pago gui quiluus, ya ayo nae utajonggue güe. ");
INSERT INTO cha_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jaangoco si Yuus; polo ya ulinibre pago, yaguin malago nu güiya, sa ilegña: Güajo Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y mañaque locue, ni y manmaatane yan güiya gui quiluus, manajuyonge güe locue. ");
INSERT INTO cha_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ya desde y mina saes na ora guaja jinemjom todo y jilo y tano, asta y mina nuebe na ora. ");
INSERT INTO cha_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ya y mina nuebe na ora, si Jesus umagang nu y dangculon inagang ilegña: Eli, Eli, lama sabactani! cumequeilegña: Yuusso, Yuusso, jafa na undingo yo? ");
INSERT INTO cha_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ya y palo ni manestaba güije, majungog güe, ya ilegñija: Si Elias este jaaagang. ");
INSERT INTO cha_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ya enseguidas malago uno guiya sija, ya jachule y espongja y janafañopchop binagle, ya japolo gui un piao, ya janae güe para uguimen. ");
INSERT INTO cha_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Y palo ilegñija: Polo ya talie cao ufato si Elias ya uninalibre. ");
INSERT INTO cha_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ayo nae si Jesus, anae munjayan umagang talo otro biaje nu y dangculon inagang jaentrega y espiritu. ");
INSERT INTO cha_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ya estagüe y cottinan y templo na masise y dos pedaso, guinin sumanjilo asta y sumanpapa; ya y tano mayengyong, ya y acho sija mangoca. ");
INSERT INTO cha_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ya y naftan sija manmababa ya megae na tataotao mañantos sija ni manmamaego, mangajulo; ");
INSERT INTO cha_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ya jumanao gui naftan, despues di quinajiloña, ya mato gui santos na siuda, ya manalie ya megae. ");
INSERT INTO cha_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ya y senturion, yan y mangaegue yan güiya na maadadaje si Jesus, anae malie y linao yan todo ayo sija y manmafatinas, mangosmaañao ya ilegñija: Sumen magajet na Lajin Yuus este. ");
INSERT INTO cha_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ya mangaegue güije megae na famalaoan na manmanaatan gui chago, ni jadalalag si Jesus guine Galilea ya jasesetbe. ");
INSERT INTO cha_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gui entalo ayo sija si Maria Magdalena, yan si Maria nanan Santiago yan José, yan y nanan y famaguon Sebedeo. ");
INSERT INTO cha_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ya anae este pupuenge güije na jaane, mato un taotao Arimatea, na rico, na y naanña si José, na güiya locue disipulon Jesus. ");
INSERT INTO cha_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Güiya mato gui as Pilato, ya jagagao y tataotao Jesus. Ayo nae si Pilato manago na umanae. ");
INSERT INTO cha_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ya jachule si José y tataotao, ya jabalutan ni un sabanas na gasgas, ");
INSERT INTO cha_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ya japolo gui nuebo na naftanña, ni y finatinasñaja gui acho ni sacapico; ya janagalileque guato un dangculon acho y pettan y naftan, ya mapos. ");
INSERT INTO cha_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ya manestaba güije si Maria Magdalena, yan y otro Maria, na manmatatachong gui menan y naftan. ");
INSERT INTO cha_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ya y inagpaña na jaane, despues di y jaanen finamauleg, mandaña y prinsipen y mamale sija, yan y Fariseo sija gui as Pilato, ");
INSERT INTO cha_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ya ilegñija: Señot, injaso na ayo y dacon ilegña, anae estaba lalâlâ: Despues di tres na jaane, jucajulo talo. ");
INSERT INTO cha_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Enao mina fanago, ya umaasegura y naftan, asta y mina tres na jaane; sa noseaja ufanmato y disipulo sija an puenge ya ujasaque; ya ujaalog ni taotao sija: Cajulo esta gui entalo manmatae: ya y uttimo na linache udangculoña qui y finenana. ");
INSERT INTO cha_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ilegña si Pilato nu sija: Inguaja un guatdianmiyo; janao, ya inasegura todo manu y ninasiñanmiyo. ");
INSERT INTO cha_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ayo nae manmapos sija, ya maadaje y naftan para umaasegura, ya maseyo y acho. ");
INSERT INTO cha_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","YUTTIMO na ora y sabalo, gui egaan anae mumanánaná y finénana na jaane gui semana, mato si Maria Magdalena yan y otro Maria, para ujalie y naftan. ");
INSERT INTO cha_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ya, estagüe un dangculon linao; sa y angjet y Señot tumunog guine y langet, ya janagalileg y acho gui petta, ya matachong gui sumanjilo. ");
INSERT INTO cha_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ya y jechuraña parejo yan y lamlam, ya y magaguña apaca calang niebe. ");
INSERT INTO cha_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ya pot y minaañao nu güiya, y guatdia sija mayengyong ya sumaga calang manmatae. ");
INSERT INTO cha_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ya manope y angjet, ilegña ni famalaoan sija: Chamiyo fanmaaañao jamyo; sa jutungoja na inaliligao si Jesus, ni guinin maatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Taegüe güine; sa esta cajulo, taegüine guinin jasangan. Maela ya inlie y lugat anae guinin umaason y Señot; ");
INSERT INTO cha_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ya janao fanlagoguse, ya sangane y disipuluña sija, na esta cajulo gui entalo y manmatae, ya infanninanangga Galilea: ya ayo nae inlie güe; estagüe, na esta jusangane jamyo. ");
INSERT INTO cha_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ayo nae sija manapos gui naftan, manmaañao yan mangosmagof, yan manmalalago para umannae notisia y disipuluña sija. ");
INSERT INTO cha_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ya estagüe si Jesus na manasoda ya ilegña nu sija: Fanmagof todos! Ya sija manmato, ya manmagote y adengña ya maadora güe. ");
INSERT INTO cha_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ayo nae si Jesus ilegña nu sija: Chamiyo fanmaañao; janao ya sangane mañelujo na ufanjanao para Galilea; ya ayo nae ujaliiyo güije. ");
INSERT INTO cha_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Anae manmapos sija, estagüe palo gui guatdia sija na manmato gui siuda, ya janatungo y prinsipen y mamale sija, todo y munjayan manmafatinas. ");
INSERT INTO cha_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ya anae mandaña yan y manamco na taotao ya manaconseja entre sija, mannae y sendalo sija megae na salape, ");
INSERT INTO cha_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ya ilegñija: Alog, y disipuluña sija manmato gui anae puenge, ya masaque güe, anae manmamaegojam. ");
INSERT INTO cha_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yaguin jaecungog este y magalaje, jame innamalago güe ya infanseguro. ");
INSERT INTO cha_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ayo nae sija jachule y salape ya jafatinas jafa y manmafanagüe sija: ya esta na sinangan mapublilica ni Judio sija asta pago na jaane. ");
INSERT INTO cha_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ya y onse na disipulo sija manmapos para Galilea, gui un ogso anae guinin mantinago as Jesus. ");
INSERT INTO cha_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ya anae malie, maadoragüe; lao y palo buebuente. ");
INSERT INTO cha_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ya mato guiya sija si Jesus ya jasangane sija, ilegña: Todo y ninasiña manaeyo, gui langet yan y tano. ");
INSERT INTO cha_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Fanjanao, ya fannaquilisyano todo y nasion sija, tagpange sija pot y naan y Tata, yan y Lajiña, yan y Espiritu Santo: ");
INSERT INTO cha_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Fanagüe sija, na ujaadaje todosija ni jutago jamyo; sa estagüe jugagaegueja guiya jamyo todo y jaane, asta y jinecog y tano. Amen. ");
INSERT INTO cha_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","TUTUJON y ibangelion Jesucristo, Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jaftaemano esta matugue gui profeta Isaias: Estagüe, guajo tumago y tentagojo gui menan matamo, para ufamauleg y chalanmo gui menamo. ");
INSERT INTO cha_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ynagang ni umaagang gui desierto: Fanmauleg y chalan y Señot: natunas y cayejonña. ");
INSERT INTO cha_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Si Juan managpange gui desierto, ya jasetmon y tinagpangen minañotsot para inasiin isao sija. ");
INSERT INTO cha_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ya manjanao guiya güiya guato todo y tano Judea, yan todo sija guiya Jerusalem; ya todo sija mantinagpange gui sadog Jordan, ya jaconfesatñaejon y isaoñija. ");
INSERT INTO cha_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ya si Juan minagagon pulon cameyo, yan sinturon cuero gui senturaña; ya y naña, apacha yan miet monte. ");
INSERT INTO cha_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ya mansesetmon, ilegña: Ufato gui tateco uno na masgaeninasiña qui guajo, y coreas y sapatosña, ti digno yo nu jutecon ya jupula. ");
INSERT INTO cha_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Guajo magajet na jutagpange jamyo yan janom; lao güiya infantinagpange ni Espiritu Santo. ");
INSERT INTO cha_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ya susede ayo sija na jaane, na si Jesus mato guine Nasaret Galilea, ya tinagpange as Juan gui Jordan. ");
INSERT INTO cha_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ya enseguidas nae cajulo gui janom, jalie na mababa y langet, ya y Espiritu, calang paluma tumunog gui jiloña, ");
INSERT INTO cha_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ya mato un inagang guine y langet na ilegña: Jago y lajijo ni yajo, iya jago nae gosmagof yo. ");
INSERT INTO cha_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ya enseguidas ninafalag y desierto ni Espiritu. ");
INSERT INTO cha_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ya sumaga güije cuarenta na jaane, ya tinienta as Satanas; yan mañisija y manmachaleg na gâgâ sija; ya y angjet sija masetbe güe. ");
INSERT INTO cha_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Anae munjayan si Juan mapreso, mato si Jesus guiya Galilea, jasesetmon y ibangelion Yuus. ");
INSERT INTO cha_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ya ilegña: Y tiempo esta macumple; ya y raenon Yuus esta jijot: fanmañotsot, ya injenggue y ibangelio. ");
INSERT INTO cha_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ya mamomocat gui oriyan tasen Galilea, jalie si Simon, yan si Andres chelun Simon, na jayuyute y lagua gui tase, sa sija manpescadot. ");
INSERT INTO cha_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ya si Jesus ilegña nu sija: Maela dalalagyo, ya junafanpescadot taotao jamyo. ");
INSERT INTO cha_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Enseguidas japolo y laguañija ya madalalag güe. ");
INSERT INTO cha_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Anae malofan talo didide mona, jalie si Santiago, lajin Sebedeo, yan si Juan cheluña, na manestaba locue gui batco na jalememenda y laguañija. ");
INSERT INTO cha_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ya enseguidas jaagang; ya jadingo si tatanñija as Sebedeo gui batco yan y manmachocho sija, ya madalalag güe. ");
INSERT INTO cha_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ya manjalom Capernaum; ya enseguidas, gui sábado na jaane, jumalom gui sinagoga ya mamanagüe. ");
INSERT INTO cha_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ya sija ninafanmanman ni finanagüeña; sa jafananagüe sija calang uno ni gaeninasiña, ya ti calang y escriba sija. ");
INSERT INTO cha_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ya enseguidas guaja güije gui sinagogañija un taotao na guaja áplacha na espiritu, ya güiya umagang, ");
INSERT INTO cha_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ylegña: Parajafa jam nu jago, Jesus taotao Nasaret? Matojao para unnafanaelayejam? Jutungoja jayejao, jago y Santos guine as Yuus. ");
INSERT INTO cha_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ya si Jesus jalalatde ilegña: Pacaca, ya maela juyong guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ya anae y áplacha na espiritu tiniteg güe, ya ninaagang gosdangculo na inagang, jumuyong guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ya todo sija ninafanmanman, pot este manafaesen entre sija, ilegñija: Jafa este? Jafa na nuebo finanagüe este! yan ninasiña jatago y manáplacha na espiritu, ya maosgueja güe? ");
INSERT INTO cha_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Enseguidas y famaña manamamta todo gui tano oriyan Galilea. ");
INSERT INTO cha_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ya enseguidas anae jumuyong gui sinagoga, mato gui guima Simon yan si Andres, yan si Santiago yan si Juan. ");
INSERT INTO cha_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ya y suegran Simon estaba na umaason sa malango yan calentura: ya masangane güe enseguidas nu y palaoan. ");
INSERT INTO cha_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ayo nae mato güe, ya jamantiene canaeña, ya jajatsa julo; ya pinelo ni calentura, ya güiya sumetbe sija. ");
INSERT INTO cha_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ya anae estaba esta pupuenge, anae machom y atdao, maconiigüe todo ni manmañetnot yan y maninanite. ");
INSERT INTO cha_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ya todo y siuda mandaña gui petta. ");
INSERT INTO cha_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ya janafanjomlo megae ni manestaba manmalango todo clasen chetnot sija; ya jayute juyong megae na anite sija; ya ti japolo nu y anite sija cumuentos sa matungo güe. ");
INSERT INTO cha_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ya y egaan güije, cajulo gostaftaf, jojomjomja trabia, ya jumuyong, ya malag y un lugat desierto, ya manaetae güije. ");
INSERT INTO cha_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ya tinatiye güe as Simon, yan y mangachochongña. ");
INSERT INTO cha_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ya anae masoda güe, ilegñija nu güiya: Todo umaliligaojao. ");
INSERT INTO cha_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Güiya ilegña nu sija: Nije tafanmalag y otro lugat gui sengsong ni jijot, ya jufansetmon locue güije; sa pot este na matoyo. ");
INSERT INTO cha_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ya jumalom gui sinagogañija todo Galilea, sesetmon ya jayuyute juyong y anite sija. ");
INSERT INTO cha_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ya un ategtog mato guiya güiya, tinayuyut güi ya dumimo, ya ilegña: Yaguin malagojao, siña unnagasgasyo. ");
INSERT INTO cha_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ya si Jesus ninamaase ya jaestira y canaeña, ya japacha, ya ilegña: Malagoyo, ungasgas. ");
INSERT INTO cha_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ya enseguidas y chetnot y ategtog mapos guiya güiya ya gasgas güe. ");
INSERT INTO cha_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ya jagosencatga, ya jatago na ujanao, ");
INSERT INTO cha_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ya ilegña nu güiya: Atan ya chamo sumangangane ni jaye jafa; lao sigueja gui jinanaomo ya unfanue y pale nu jago, ya unofrese ni guinasgasmo ni si Moises manago, para testimonioñija. ");
INSERT INTO cha_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lao güiya mapos, ya jatutujon munamatungo, yan janagosmamta y checho; pot este, si Jesus ti siña jumalom matungo nu güiya gui siuda; lao sumasagaja gui sumanjiyong gui lugat desierto sija, ya manmato guiya güiya guinin todo y patte sija. ");
INSERT INTO cha_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","YA otro biaje güiya jumalom guiya Capernaum, despues di malofan ti megae na jaane sija; ya majungog na gaegue güe gui jalom guma. ");
INSERT INTO cha_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ya mandaña megae, ya ti manulag, ni gui oriyan y petta; ya jasetmon y sinangan guiya sija. ");
INSERT INTO cha_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ayo nae manmato guiya güiya manmangongone un paralitico, na macocone ni cuatro. ");
INSERT INTO cha_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ya anae ti siña manmato guiya güiya pot y linajyan taotao, manajanao y atof anae estaba güe, ya anae munjayan mababa, manatunog y cama anae mapopolo y paralitico. ");
INSERT INTO cha_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ya anae jalie si Jesus y jinenggueñija, ilegña ni paralitico: Lajijo, y isaomo unmaasie. ");
INSERT INTO cha_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ya estaba güije manmatatachong palo escriba sija, ya manmanjajaso gui corasonñija, ilegñija: ");
INSERT INTO cha_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Jafa na cumuecuentos este na taotao chatfino contra si Yuus? Jaye siña manasie isao, solo si Yuusja? ");
INSERT INTO cha_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ya jatungo si Jesus enseguidas gui espirituña na manmanjajaso gui sumanjalomñija, ya ilegña nu sija: Jafa muna injajaso este sija gui corasonmiyo? ");
INSERT INTO cha_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Jafa mas guse taalog y paralitico: Y isaomo unmaasie; pat taalog: Cajulo, chule y camamo, ya unjanao? ");
INSERT INTO cha_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lao para intingo na y Lajin taotao guaja ninasiñaña gui jilo tano manasie isao (ilegña ni paralitico), ");
INSERT INTO cha_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Jualog nu jago: Cajulo, ya unchule y camamo ya janao falag iyajamyo. ");
INSERT INTO cha_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ayo nae cajulo güe enseguidas, ya jachule y camaña, ya mapos gui menan todo; enao muna todo ninafanmanman, ya manamalag si Yuus, ilegñija: Taya nae inlie ayo. ");
INSERT INTO cha_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ya jumanao talo gui oriyan tase, ya todo y linajyan taotao manmato guiya güiya, ya jafanagüe sija. ");
INSERT INTO cha_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ya anae malofan jalie si Levi, lajin Alfeo, na matatachong gui bancon y tributo sija, ya ilegña nu güiya: Dalalagyo. Ya cajulo ya dinalalag güe. ");
INSERT INTO cha_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ya susede na estaba güe matachong para uchocho gui lamasa gui guima ayo, ya megae sija na publicano yan manisao sija manmatatachong mañisija locue yan si Jesus, yan y disipoluña sija; sa guaja megae dumadalalag güe. ");
INSERT INTO cha_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ya y escriba sija gui entalo y Fariseo sija, anae jalie na mañochocho yan y manisao yan y publicano sija, ilegñija ni disipoluña sija: Jafa este na güiya chomocho yan gumiguimen, yan y publicano sija yan y manisao? ");
INSERT INTO cha_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ya anae jajungog si Jesus, ilegña nu sija: Y manjomlo ti janesesita medico, na y manmalango. Ti matoyo para juagang y manunas, na y manisao sija. ");
INSERT INTO cha_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ya y disipulon Juan, yan y disipulon Fariseo sija manayunat: ya manmato, ya ilegñija nu güiya: Jafa muna y disipulon Juan yan y disipulon Fariseo sija manayuyunat; ya y disipulumo ti manayuyunat? ");
INSERT INTO cha_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Si Jesus ilegña nu sija: Siña manayunat y mangaegue gui guipot umasagua, yaguin mañisija yan y nobio? Y tiempo nae mañisijaja yan y nobio, ti siña manayunat. ");
INSERT INTO cha_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lao ufato y jaane sija, na y nobio umanajanao guiya sija; ya ayo sija na jaane nae ufanayunat. ");
INSERT INTO cha_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Taya ni uno lumimendanñañaejon y nuebo na magago gui bijo na bestido; sa ayo y nuebo na limenda ujanao gui bijo, ya mas taelaye y matiteg. ");
INSERT INTO cha_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ya taya ni uno umasajguane y nuebo na bino gui bijo na boteyan cuero: sa y nuebo na bino uyamag y boteyan cuero sija, ya umachuda y bino, ya y boteyan cuero manmalingo; lao y nuebo na bino, y nuebo na boteyan cuero nae umasajguane. ");
INSERT INTO cha_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ya manmapos este, malolofan güe gui jalom fangualuan trigo gui sabado na jaane; ya y disipoluña sijas igue di manmanjala ni espiga sija. ");
INSERT INTO cha_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ya y Fariseo sija, ilegñija: Atanja, jafa na jafatitinas gui sabado na jaane y ti mauleg para umafatinas? ");
INSERT INTO cha_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ya güiya ilegña nu sija: Taya nae intaetae jafa checho David anae janesesita, ya ñalang yan y mangachongña? ");
INSERT INTO cha_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jafa taemano jalomña gui guimayuus anae si Abiatar magas na pale, ya jacano y pan ni inefrese, ni ti para macano, na para y pale sija; ya janae locue y mangachongña sija? ");
INSERT INTO cha_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ylegña talo nu sija: Y sabado pot y taotao na mafatinas: ti y taotao pot y sabado. ");
INSERT INTO cha_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Enaomina y Lajin taotao Señot locue gui sabado. ");
INSERT INTO cha_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","YA jumalom talo gui sinagoga; ya guaja güije un taotao na anglo un canaeña. ");
INSERT INTO cha_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ya sija maaatanja güe cao unajomlo gui sabado na jaane; para umafaaela. ");
INSERT INTO cha_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ayo nae ilegña ni ayo na taotao y anglo un canaeña: Tojgue julo gui entalo. ");
INSERT INTO cha_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ya ilegña nu sija: Siña tafatinas mauleg gui sabado na jaane pat taelaye? nalibre y linâlâ pat puno? Lao sija manmamatquiquiloja. ");
INSERT INTO cha_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ya anae jaatan gui oriya sija yan y linalalo, ninapinite pot y majetog corasoññija, ya ilegña nu y taotao: Estira mona y canaemo. Ya jaestira, ya y canaeña tumalo mauleg parejo yan y otro. ");
INSERT INTO cha_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ayo nae manmapos y Fariseo sija, ya manaconseja yan y taotao Herodes sija, contra güiya, para umapuno. ");
INSERT INTO cha_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lao si Jesus sumuja para y tase yan y disipuluña sija; ya madalalag un dangculon linajyan taotao guine Galilea, yan guine Judea, ");
INSERT INTO cha_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yan guine Jerusalem, yan guine Idumea, yan y otro bandan Jordan, yan guine oriyan Tiro yan Sidon, dangculo na linajyan taotao anae majungog y dangculon finatinasña sija, manmato guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ya jasangane y disipoluña sija, na un diquique na batco uninananggaja güe, pot y linajyan taotao para munga güe manachatsaga, ");
INSERT INTO cha_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sa guaja megae janafanjomlo; ya pot ayo na manpodong gui jiloña, todo y mangaechetnot para umapacha, ");
INSERT INTO cha_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ya y manáplacha sija na espiritu locue, anae malie güe, manpodong papa gui menaña, ya managang, ilegñija: Jago y Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lao guiya jagosencatga sija, na chañija munamatutungo güe. ");
INSERT INTO cha_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ya cajulo gui egso, ya jaagang guiya güiya ayo sija y malagoña, ya sija manmato guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ya jaayig y dose, na ufañisijaja, yan para unafanjanao ya ujafanmansetmon; ");
INSERT INTO cha_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yan ufangaeninasiña para ujayute juyong y anite sija. ");
INSERT INTO cha_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sija si Simon, ni japolo sobrenaaña si Pedro; ");
INSERT INTO cha_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yan si Santiago, lajin Sebedeo, yan si Juan chelun Santiago; ni japolo sobrenaañija si Boanerges ni comoqueilegña lalajin julo. ");
INSERT INTO cha_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yan si Andres, yan si Felipe, yan si Bartolome, yan si Mateo, yan si Tomas yan si Santiago, lajin Alfeo, yan si Tadeo, yan si Simon y Cananeo; ");
INSERT INTO cha_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yan si Judas Iscariote ni y locue umentrega güe: ya manjalom talo gui guima. ");
INSERT INTO cha_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ya y linajyan taotao mandaña talo, ya pot este sija ti siña ni ufañochocho pan. ");
INSERT INTO cha_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ya anae majungog na familiaña sija, manmato para umaguot; sa ilegñija: Esta ti guiya güe. ");
INSERT INTO cha_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ya y escriba sija ni manmato guine Jerusalem, ilegñija, na guaja güe as Beetsebub, ya pot y prinsipen anite na manyuyute juyong anite sija. ");
INSERT INTO cha_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lao güiya umagang sija, ya ilegña nu sija pot acomparasion: Jafataemano siña si Satanas jayute juyong si Satanas? ");
INSERT INTO cha_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yaguin un raeno madibide contra güiyaja, ayo na raeno ti siña sumaga. ");
INSERT INTO cha_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yaguin un guma madibide contra güiyaja, ayo na guma ti siña sumaga. ");
INSERT INTO cha_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yaguin si Satanas cajulo contra güiyaja, ya madibide ti siña sumaga: lao gae jinecog. ");
INSERT INTO cha_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Taya ni un taotao siña jumalom gui guima y matatnga na taotao, ya unataelaye y güinajaña sija, yaguin ti jagode finena y matatnga na taotao; ya ayo nae unataelaye y güinajaña. ");
INSERT INTO cha_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Magajet jusangane jamyo, na todo y isao sija ufanmaasie gui lalajin taotao sija, yan y chinatfino contra cuatquieraja sija na chinatfinue. ");
INSERT INTO cha_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lao jayeja y chumatfino contra y Espiritu Santo, taemaasie ni ngaean; ya peligroña y taejinecog na isao: ");
INSERT INTO cha_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sa ilegñija, güiya guaja áplacha na espiritu. ");
INSERT INTO cha_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ya manmato si nanaña, yan y mañeluña, ya manestaba gui sumanjiyong, manmanago na umaagang güe. ");
INSERT INTO cha_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ya y linajyan taotao estaba manmatatachong gui oriyaña; ya ilegñija nu güiya: Estagüe si nanamo yan y mañelumo gui sumanjiyong na maaliligaojao. ");
INSERT INTO cha_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ya güiya jaope sija, ilegña: Jaye nanajo yan jaye mañelujo? ");
INSERT INTO cha_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ya manaatan gui oriya anae manestaba manmatatachong gui oriyaña, ya ilegña: Estagüe y nanajo, yan y mañelujo! ");
INSERT INTO cha_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sa jayeja y fumatinas y minalago Yuus, güiya chelujo laje, yan chelujo palaoan, yan nanajo. ");
INSERT INTO cha_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","YA jatutujon otro biaje mananagüe gui oriyan tase; ya mandaña guiya güiya dangculo na linajyan taotao, enao mina jumalom gui un batco, ya matachong gui tase; ya todo y linajyan taotao manestaba gui jilo tano gui oriyan tase. ");
INSERT INTO cha_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ya jafanagüe sija megae pot acomparasion, ya ilegña nu sija gui finanagüeña. ");
INSERT INTO cha_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ecungog: Estagüe y tatanom na jumuyong para ufananom. ");
INSERT INTO cha_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ya anae manananom, palo mamodong gui oriyan chalan; ya mato y pajaron y aire ya macano. ");
INSERT INTO cha_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ya y palo mamodong gui jilo acho, anae ti megae na oda; ya enseguidas mandoco, sa ti tadong gui eda. ");
INSERT INTO cha_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lao anae cajulo y atdao, sinenggue, sa taejaleñija manmalayo. ");
INSERT INTO cha_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ya y palo mamodong gui entalo tituca sija; ya mandoco y tituca sija, ya chiniguet, ya ti manogcha. ");
INSERT INTO cha_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ya y palo mamodong gui mauleg na tano, ya manmanogcha, ya mangajulo ya manmegae; ya uno manogcha treinta, y otro sesenta, y otro ciento. ");
INSERT INTO cha_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ayo nae ilegña nu sija: Y gae talanga para ufanjungog, güiya uecungog. ");
INSERT INTO cha_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ya anae estaba güe güiyaja, y manestaba gue oriyaña yan y dose, mafaesen güi ni y acomparasion sija. ");
INSERT INTO cha_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ya ilegña nu sija: Jamyo manmanae y misterion raenon Yuus; lao y mangaegue gui sumanjiyong, pot acomparasion nae umafatinas todo estesija; ");
INSERT INTO cha_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Para y manlilie, jalie ya ti jasiente; ya y manecungog, manmanjungog, lao ti jatungo; sa no sea ufanmabra talo, ya ufanmmaasie ni isaoñija. ");
INSERT INTO cha_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ya ilegña nu sija: Ti intingo este na acomparasion? Jafa taemano nae, tungonmiyo todo ni acomparasion sija? ");
INSERT INTO cha_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Y tatanom jatanme y finijo. ");
INSERT INTO cha_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ya este yuje sija y oriyan chalan, anae manmatanme y finijo; lao despues di jajungog, mato si Satanas, enseguidas, ya janajanao y finijo ni matanme gui corasonñija. ");
INSERT INTO cha_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Parejoja locue yan este sija y manmatanme gui jilo acho; anae majungog y finijo, enseguidas maresibe todo ni y minagofñija; ");
INSERT INTO cha_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lao taya jaleñija, ya ti jadura apmam; sa anae cajulo y triniste, pat y pinetsigue pot y finijo, enseguidas maninefende. ");
INSERT INTO cha_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ya este yuje sija y manmatanme gui entalo tituca sija; y jumungog y finijo; ");
INSERT INTO cha_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Lao y inadajen este y tano, yan y dinaguen y güinaja sija, yan y minalago ni guaja gui palo güinaja sija, manjalom ya machiguet y finijo ya jumuyong ti manogcha. ");
INSERT INTO cha_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ya este yuje sija y manmatanme gui mauleg na tano; y jumungog y finijo ya maresibe, ya manmanogcha, ya uno treinta y otro sesenta, y otro siento. ");
INSERT INTO cha_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ylegña nu sija locue: Esta machule y candet para umapolo gui papa medida, pat gui papa cama? Ya ti para umapolo gui jilo lamasa? ");
INSERT INTO cha_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sa taya na manaatog, ti umafatanñaejon; ni gae gui secreto ya ti umababa. ");
INSERT INTO cha_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yaguin guaja gaetalanga para ufanjungog, güiya uecungog. ");
INSERT INTO cha_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ylegña nu sija locue: Adaje jafa y jiningogmiyo. Y medida anae inmediye sija, ayoja nae infanmamidiye jamyo; ya infanmanae jamyo mas. ");
INSERT INTO cha_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sa y guaja, umanae: ya y taya, esta y güinajaña, unajanao. ");
INSERT INTO cha_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ya ilegña: Taegüine y raenon Yuus, yaguin un taotao manyute semiya gui jalom oda; ");
INSERT INTO cha_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ya maego, ya cajulo gui puenge yan jaane, ya semiya mapta ya doco, ti jatungo jafataemano. ");
INSERT INTO cha_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sa y tano güiyaja manogcha, finena jagon, enseguidas y espiga, despues y grano bula gui espiga. ");
INSERT INTO cha_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ya yaguin y tinegcha dumangculo, enseguidas mapolo y sese para mangoco, sa mato y cosecha. ");
INSERT INTO cha_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ya ilegña: Jafajit nae tanaparejo y raenon Yuus? pat jafa na acomparasion nae taacompara? ");
INSERT INTO cha_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Parejo yan un granon mostasa, ni y anae matanme gui tano, achogja güiya mas diquique gui entalo todo y semiya sija ni y guaja gui jilo y tano. ");
INSERT INTO cha_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lao anae matanme, doco, ya güiya mas dangculo qui todo na golae, ya manramas ni mandangculo na ramasña; ya pot este y pajaron y aire siña mañaga gui papa y nijongña. ");
INSERT INTO cha_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yan megae sija na acomparasion parejo yan este sija, jasangane sija finijo, jaftaemano y siña jajungog. ");
INSERT INTO cha_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ya sin acomparasion ti jasangane sija; lao y disipoluña sija anae mañisijaja janaclaruye todo. ");
INSERT INTO cha_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ya ilegña nu sija güijija na jaane, anae esta pupuenge: Nije tafanmalofan gui otro banda. ");
INSERT INTO cha_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ya jadingo y linajyan taotao, ya macone güe mañija, anae gaegue güe sui jalom batco. Ya guaja locue palo diquique na batco mañisija. ");
INSERT INTO cha_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ya cajulo un dangculon pagyon manglo, ya jinatme ni napo sija y jalom batco, ya ninabula. ");
INSERT INTO cha_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ya güiya gaegue gui popa na mamaego gui jilo alunan; ya mayajo, ya ilegñija nu güiya: Maestro, taya unadadaje na infanmatae? ");
INSERT INTO cha_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ya cajulo güe, ya jalalatde y manglo, ya ilegña ni tase: Pacaca famatquilo. Ya bumasta y manglo, ya guaja dangculo na catma. ");
INSERT INTO cha_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ya ilegña nu sija: Jafa jamyo na gosmanmaañao? Taye jinengguenmiyo trabia? ");
INSERT INTO cha_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ya mangosmanmaañao, ya ilegñija entre sija: Jaye este, na asta y manglo yan y tase maosgue güe? ");
INSERT INTO cha_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","YA manmato gui otro bandan tase gui tano y taotao Gadara sija. ");
INSERT INTO cha_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ya anae jumuyong güe gui batco, enseguidas umasoda yan un taotao gui naftan sija ni guaja un áplacha na espiritu. ");
INSERT INTO cha_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ya guaja sagaña gui jalom naftan sija, ya taya siña gumode güe nu y cadenaja: ");
INSERT INTO cha_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sa megae na biaje nae magode nu y tale sija yan cadena sija, lao y cadena sija esta manmayamag pot guiya; ya y tale sija manmagtos, ya taya siña munamanso güe. ");
INSERT INTO cha_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ya siempre yan puenge yan jaane, jumajanao ya umaagang gui entalo naftan sija, yan gui jalomtano sija, ya janalalamen güe ni acho sija. ");
INSERT INTO cha_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ya anae jalie si Jesus gui chago, malago, ya jaadora güe. ");
INSERT INTO cha_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ya umagang gosdangculo na inagang, ilegña: Para jafayo ni jago, Jesus, Lajin y Gueftaquilo na Yuus? Jufanjula nu jago pot si Yuus na chamoyo munachachatsaga. ");
INSERT INTO cha_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sa ilegña nu güiya: Juyong güine na taotao, áplacha na espiritu. ");
INSERT INTO cha_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ya jafaesen: Jaye naanmo? Ya inepe, ilegña: Linajyan naanjo: sa manmegaejam. ");
INSERT INTO cha_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ya jatayuyut megae, para chaña yiniyite juyong güije na tano. ");
INSERT INTO cha_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ya gaegue güije, jijot gui jalomtano sija, un dangculo na manadan babue na mañochocho. ");
INSERT INTO cha_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ya matayuyut güe ni ayo todo sija na anite, ilegñija: Tagojam para y babue sija para infanjalom guiya sija. ");
INSERT INTO cha_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ya manpinetmite as Jesus. Ya manjuyong ayo sija y manáplacha na espiritu, ya manjalom gui babue sija; ya y manada manmalago papa gui un didog na lugat asta y jalom tase, ya guaja sija dos mit; ya manmatmos gui tase. ");
INSERT INTO cha_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ya y munafañochocho y babue sija manmalago ya manmañangane gui siuda yan y fangualuan sija. Ya manjanao sija para ujalie jafa ayo y guinin mafatinas. ");
INSERT INTO cha_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ya manmato gui as Jesus, ya malie y guinin ninachatsaga ni anite, matatachong, ya minagagago, ya jatungo ayo y guaja ni linajyan; ya manmaañao. ");
INSERT INTO cha_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ya mansinagane ni ayo sija y lumie; jafa taemano matoña ayo y guinin guaja anite, yan y babue sija. ");
INSERT INTO cha_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ya matutujon matayuyut güe na ujanao gui tanoñija. ");
INSERT INTO cha_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ya anae jumalom güe gui batco, tinayuyut güe ni ayo y guinin guaja anite, para ujasija. ");
INSERT INTO cha_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ya si Jesus ti pinetmite, lao ilegña un güiya: Janao falag iyajamyo gui amigumo sija; ya unsangane sija na dangculon güinaja y Señot finatinasña nu jago, yan guaja minaaseña nu jago. ");
INSERT INTO cha_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ya maposgüe ya jatutujon sumanganñaejon guiya Decapolis na dangculon güinaja y finatinas Jesus nu güiya: ya todo ninafanmanman. ");
INSERT INTO cha_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ya anae malofan otro biaje si Jesus gui un batco para y otro banda, mandaña guiya güiya un dangculo na linajyan taotao; ya gaegue güe gui oriyan tase. ");
INSERT INTO cha_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ya mato uno gui prinsipe sija gui sinagoga, y naanña si Jairo; ya anae linie güe, podong gui adengña; ");
INSERT INTO cha_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ya tinayuyut güe megae, ilegña: Y jagajo cumequematae. Nije ya unpolo y canaemo gui jiloña, para ujomlo, yan ulâlâ. ");
INSERT INTO cha_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ya jumanao yan Jesus, ya megae na taotao sija madalalag güe, ya machiguet güe. ");
INSERT INTO cha_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ya un palaoan na numanajuyong jâgâ esta dose años. ");
INSERT INTO cha_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ya japadese megae medico, ya jagasta todo y güinajaña, ya taya jaaprobecha; lao lumala adid, ");
INSERT INTO cha_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ya anae jajungog ayosija na cumuentos si Jesus, jumalom gui entalo y taotao sija gui sumantate, ya japacha y magaguña. ");
INSERT INTO cha_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sa ilegña: Yaguin jupacha y magaguñaja, uguajayo jinemlo. ");
INSERT INTO cha_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ya enseguidas y menegae y jâgâña umanglo, ya jasiente y tataotaoña na esta jomlo ni ayo na chetnot. ");
INSERT INTO cha_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ya si Jesus enseguidas jatungo guiya güiyaja, na ninasiña jumuyong guiya güiya, jabira güe guato gui linajyan taotao, ya ilegña: Jaye pumacha y magagujo? ");
INSERT INTO cha_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ya y disipuluña sija ilegñija nu güiya: Unlie y linayan taotao na machichiguetjao, ya ilegmo: Jaye pumachayo? ");
INSERT INTO cha_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ya güiya manatan gui oriya para ulie y fumatinas este. ");
INSERT INTO cha_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Lao ayo nae y palaoan maañao ya manlaloalao, jatungo na iyagüiya nae mafatinas, mato ya podong gui menaña, ya jasangane todo ni magajet. ");
INSERT INTO cha_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ya güiya ilegña: Jagajo, y jinengguemo unninajomlo; janao yan minagof, ya unjomio ni chetnotmo. ");
INSERT INTO cha_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y tiempo nae cumuecuentos güe, manmato guine y guima y prinsipen sinagoga ya ilegñija: Y jagamo matae: para jafa di unnachachatsaga mas y Maestro? ");
INSERT INTO cha_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lao si Jesus, anae jajungog este na sinangan, ilegña ni prinsipen sinagoga: Chamo maaañao; jonggueja. ");
INSERT INTO cha_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ya ti japetmite ni uno na událalag güe, solo si Pedro, yan si Santiago, yan si Juan, chelun Santiago. ");
INSERT INTO cha_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ya mato gui guima y prinsipen y sinagoga, ya jalie y atboroto yan y manatanges yan y manugung. ");
INSERT INTO cha_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ya anae jumalom, ilegña nu sija: Jafa na manatborotao jamyo, yan manatanges jamyo? Y patgon na palaoan ti matae, na mamaego. ");
INSERT INTO cha_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ya mamofea güe. Lao güiya janafanjuyong todo, ya jacone y tata yan y nanan y patgon na palaoan, yan y mangachochongña, ya manjalom anae gaegue y patgon na palaoan. ");
INSERT INTO cha_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ya jamantiene y canae y patgon palaoan, ya ilegña: Talitha cumi; cumequeilegña: Patgon palaoan, jago jucuentutuse, cajulo. ");
INSERT INTO cha_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ya enseguidas ayo na patgon palaoan cajulo, ya mamocat; sa sacaña y dose años. Ya enseguidas ninafanmanman ni gosdangculo na namanman. ");
INSERT INTO cha_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lao güiya jagosencatga sija na taya ujanatungo: ya manago na umanachocho y patgon palaoan. ");
INSERT INTO cha_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","YA anae jumanao güije mato gui tanoña; ya y disipuluña sija madalalag güe. ");
INSERT INTO cha_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ya anae mato y sábado na jaane, jatutujon mamanagüe gui sinagoga; ya megae ni jumungog güe ninafanmanman, ya ilegñija: Mano nae guaja este taotao este sija na güinaja? Yan jafa este na tiningo y esta manae güe? ya jaftaemano este sija na ninámanman ni mafatinas ni canaeña? ");
INSERT INTO cha_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ada ti este y catpintero, lajin Maria, chelun Santiago, yan si Joses, yan si Juda, yan si Simon? Ada ti manjijita yan y mañeluña famalaoan güine? Ya maninefefende nu güiya. ");
INSERT INTO cha_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Lao si Jesus ilegña nu sija: Taya profeta sin onraña lao y tanoñaja, yan entre y parientesña sija, ya y guimaña. ");
INSERT INTO cha_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ya ti siña jafatinas güije jafa na námanman, na japolo y canaeña gui jilo palo manmalango sija, ya janajomlo. ");
INSERT INTO cha_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ya güiya ninámanman ni ti manmanjongguenñija; ya malilicue gui y sengsong sija mananagüe. ");
INSERT INTO cha_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ya jaagang y dose sija, y jatutujon tumago dos en dos, ya janae ninasiñañija gui jilo manáplacha na espiritu sija; ");
INSERT INTO cha_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ya jatago sija na chañija fanmañuñule ni jafa para y chalan, na un bastoñija; ni costat, ni pan, ni salape gui betsanñija; ");
INSERT INTO cha_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lao ufanchenancleta; ya munga manminagago dos na magago. ");
INSERT INTO cha_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ya ilegña nu sija: Manoja na guma nae manjalom jamyo; fañaga güije, asta gui manjanao jamyo güije na lugat. ");
INSERT INTO cha_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ya todo ayo sija y ti rumesibe jamyo, ni ti maninecungog jamyo, fanjanao güije, sacude y petbos ni gaegue gui papa adengmiyo para testimonio contra sija. Magajet jusangane jamyo, na mas sungunon na castigon Sodoma, yan Gomora gui jaanin y sentensia, qui ayo na sidua. ");
INSERT INTO cha_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ya manmapos jasetmon na y taotao sija ufanmañotsot. ");
INSERT INTO cha_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ya jayute juyong megae na anite sija, ya japapalae laña megae na manmalango sija, ya janafanjomlo. ");
INSERT INTO cha_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ya jajungog y ray Herodes y faman Jesus (sa afamao y naanña), ya ilegña: Si Juan Bautista cajulo guine y manmatae sija; ya pot este mangaeninasiña na chocho, esta fumatinas nu güiya. ");
INSERT INTO cha_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Palo ilegñija: Si Elias. Y palo ilegñija: Profeta güe, pat uno gui profeta sija. ");
INSERT INTO cha_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ya anae jajungog si Herodes, ilegña: Este si Juan ni guine judegüeya: güiya cajulo guine y manmatae sija. ");
INSERT INTO cha_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sa güiyaja si Herodes manago na umamantiene si Juan, ya umapreso gui catset pot si Herodias, asaguan y cheluña as Felipe, sa jacone para asaguaña. ");
INSERT INTO cha_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Sa si Juan ilegña as Herodes: Ti cabales na uncone y asaguan y chelumo. ");
INSERT INTO cha_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ya pot este si Herodias uninaguaguat contra güiya, ya jadesesao na upuno, lao ti janasiña. ");
INSERT INTO cha_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sa si Herodes maañao as Juan, jatungo na tunas yan Santos na taotao ya jaguefadaje. Ya anae jajungog, gosbumuebuente gui corasonña; ya jaecungogjao ni minagofña. ");
INSERT INTO cha_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ya anae mato un jaane na si Herodes gumupot ni mafañaguña, ya mamatinas sena para y prinsipeña sija yan y capitan sija, yan y manmagas sija guiya Galilea; ");
INSERT INTO cha_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ya jumalom y jagan Herodias, ya bumaela, ya janamagof si Herodes, yan ayo sija y mangachochongña gui lamasa; ya y ray ilegña ni patgon na palaoan: Gagaoyo ni malagomo, ya junaejao. ");
INSERT INTO cha_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ya manjula: Todo y ungagaoyo, junae asta lamita gui raenoco. ");
INSERT INTO cha_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ya mapos güe, ya ilegña as nanaña: Jafa jugagao? Si nanaña ilegña: Y ilun Juan Bautista. ");
INSERT INTO cha_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ayo nae jumalom enseguidas gui ray ya jagagao, ilegña: Malagoyo pago na unnaeyo gui un plato ni ilun Juan Bautista. ");
INSERT INTO cha_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ya y ray ninagostriste; lao pot y juramentoña, yan ayo sija y mangachongña gui lamasa, ti malago japune. ");
INSERT INTO cha_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ya enseguidas y ray manago uno gui guatdia, jatago na ujanao ya uchinilie ni iluña. Ya mapos, ya jadegüeya gui jalom catset. ");
INSERT INTO cha_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ya machule guato y iluña gui un plato, ya manae y patgon palaoan, ya y patgon palaoan janae y nanaña. ");
INSERT INTO cha_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ya anae majungog ni disipuluña sija, manmato, ya machule y tataotaoña, ya mapolo gui un naftan. ");
INSERT INTO cha_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ya y apostoles mandaña gui as Jesus, ya masangane güe todo ni chechoñija, yan y finanagüenñija. ");
INSERT INTO cha_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ya güiya ilegña su sija: Maela jamyo apatte gui un lugat desierto, ya infandescansa didide; sa megae sija manjajanao, yan manmafato, ya manaelugat mañocho. ");
INSERT INTO cha_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ya manmapos gui un batco gui un lugat desierto apatte. ");
INSERT INTO cha_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ya y lumie sija na manjanao megae, ya matungo güe; ya manmalalago para ayo megae manmamomocat gui siuda sija, ya manmato antes qui sija, ya mandaña guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ya anae jumuyong si Jesus jalie y linajyan taotao ya ninamaase nu sija, sa manparejoja yan y quinilo sija ni taya pastotñija; ya jatutujon fumanagüe megae na güinaja. ");
INSERT INTO cha_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ya anae estaba pupuenge, y disipuluña sija manmato guiya güiya, ilegñija: Y lugat desierto este, ya esta pupuenge. ");
INSERT INTO cha_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Najanao sija para ufanmalag y campo yan y sengsong sija gui oriya, ya ujafanmamajan pan para sija. ");
INSERT INTO cha_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lao manope, ilegña nu sija: Nae sija mañija. Ya sija ilegñija nu güiya: Infanjanao ya infanmamajan pan pot dosientos na denario, para innae sija nañija? ");
INSERT INTO cha_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ya güiya ilegña nu sija: Cuanto na pan guaja jamyo? Janao, ya inlie. Ya anae jatungo sija, ilegñija: Sinco, yan dos na güijan. ");
INSERT INTO cha_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ya jatago, sija na ujanafanmatachong todos pot mangachong gui jilo y manbetde na chaguan. ");
INSERT INTO cha_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ya manmatachong pot mangachong, siento yan siento, yan sincuenta yan sincuenta. ");
INSERT INTO cha_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ya jachule y sinco na pan yan y dos na güijan, ya manatan julo gui langet, ya jabendise, ya jaipe y pan sija; ya janae y disipuluña sija para ujaplanta gui sanmenañija; ya y dos na güiyan manmapatte todos. ");
INSERT INTO cha_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ya mañocho todos, ya manjaspog. ");
INSERT INTO cha_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ya jajatsa y pedaso sija dose na canastra manbula; yan pedaso y güijan sija locue. ");
INSERT INTO cha_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ya ayo sija y mañocho ni pan, sinco mit na lalaje sija. ");
INSERT INTO cha_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ya enseguidas jaapura y disipuluña sija na ufangajulo gui batco, ya ufanjanao gui menaña gui otro banda guiya Betsaida, mientras janajanao y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ya despues, anae munjayan janajanao sija, mapos malag y egso para ufanaetae. ");
INSERT INTO cha_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ya anae esta pupuenge, y batco estaba gui talo gui tase, ya güiyaja namaesa gui tano. ");
INSERT INTO cha_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ya jalie sija na manmachochocho mapot manmamómogsae, sa y manglo contrario para sija; ya jijot gui mina cuatro na guatdia gui puenge, mato güe guiya sija, mamómocat gui jilo tase; ya malago na ufalofan gui oriyañija. ");
INSERT INTO cha_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ya anae malie nu sija, na mamómocat gui jilo tase, jinasoñija na pantasma, ya managang; ");
INSERT INTO cha_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sa todos lumie güe, ya ninafañatsaga. Lao enseguidas jacuentuse sija, ya ilegña nu sija: Angoco jamyo, guajoyo; chamiyo fanmaaañao. ");
INSERT INTO cha_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ya cajulo guiya sija gui batco, ya y manglo mapos: ya sija ninafangosmanman; ");
INSERT INTO cha_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sa sija ti jatungo y milagron y pan sija; sa y corasonñija estaba mangosmajetog. ");
INSERT INTO cha_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ya anae manmalofan para y otro banda, manmato gui tano Genesaret, ya manmalag y puetto. ");
INSERT INTO cha_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ya anae manjuyong sija gui batco, enseguidas matungo güe. ");
INSERT INTO cha_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ya manmalago gui oriyan todo ayo na tano, ya matutujon mañule gui todo y patte, manmalango sija gui cama, mano nae majungog na estaba güije. ");
INSERT INTO cha_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ya manuja nae jumalom, songsong, pat suida, pat fangualuan, mapolo papa y malango sija gui chalan, y matayuyut güe na upacha y canton y magaguña, ya todo ayo sija y japacha, manjomlo. ");
INSERT INTO cha_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","YA mandaña guiya güiya y Fariseo sija, yan palo gui escriba sija ni manmato guine Jerusalem, ");
INSERT INTO cha_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ya malie palo gui disipuluña na mañochocho pan yan áplacha na canae, ni comequeilegña na pot ti jafagase. ");
INSERT INTO cha_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sa y Fariseo sija, yan toda y Judio sija, jaadadaje y tradision manamco sija, yaguin megae nae ti jafagase y canaeñija, ti ufañocho. ");
INSERT INTO cha_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya anae manmato guine y metcado, yaguin ti jafagase sija, ti ufañocho; yan megae sija na güinaja rinesibeñija para ujaadaje, parejoja yan mafagase y copa sija, yan y jara sija, yan y bason coble sija. ");
INSERT INTO cha_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ya mafaesen ni Fariseo sija yan y escriba sija: Jafa y disipulumo sija na ti manmamómocat taemano y tradision manamco sija; mañochochoja pan yan aplacha y canaeñija? ");
INSERT INTO cha_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ya ilegña nu sija: Hipocrita jamyo; mauleg sinanganña si Isaias, ni y esta matugue: Este sija na taotao y labiosñija nae maonrayo, lao y corasonñija chago guiya guajo. ");
INSERT INTO cha_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lao taebale jaadorayo, manmamananagüe ni finanagüe ni tinago taotao sija. ");
INSERT INTO cha_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sa inpelo jamyo y tinago Yuus, ya mantietiene fitme y tradision taotao sija: (ni y mafagase y jara sija, yan y copa sija, yan infatinas megae sija na güinaja parejo yan este.) ");
INSERT INTO cha_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ya ilegña nu sija: Magajet jamyo yumute y tinago Yuus para inadaje y tradisionmiyo. ");
INSERT INTO cha_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sa si Moises ilegña: Onra si tatamo yan si nanamo; ya y mumatdise y tata pat y nana, seguro na umatae. ");
INSERT INTO cha_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lao jamyo ilegmiyo: Yaguin y taotao ilegña ni tataña pat nanaña: Y Cotban (cumequeilegña y ninae) na jago umaprobecha pot guajo, güiya sumaga libre. ");
INSERT INTO cha_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ya inpelo güe na ufatinas taya para si tataña pat si nanaña; ");
INSERT INTO cha_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Inrechasa y sinangan Yuus ni ninaenmiyo na tradision; yan megae sija na güinaja finatinasmiyo parejo yan este. ");
INSERT INTO cha_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ya jaagang talo guiya güiya todo y linajyan taotao ya ilegña: Ecungog jamyo todos, ya intingo. ");
INSERT INTO cha_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Taya gui sumanjiyong gui taotao ni y janajalom, siña numataelaye, lao y janajujuyong gui jinalomña, ayo sija munatataelaye y taotao ");
INSERT INTO cha_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Yaguin guaja gaetalanga para ufanjungog, uecungog) ");
INSERT INTO cha_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ya anae jumalom gui guima, jadingo y linajyan taotao, y disipuluña sija mafaesen güe ni acomparasion. ");
INSERT INTO cha_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ya ilegña nu sija: Taegüenaja jamyo locue manaetiningo? Ti intingo na todo y guine jiyong ni jumajalom y taotao ti siña ninataelaye? ");
INSERT INTO cha_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sa ti jumajalom gui corasonña na y tiyanña ya malolofan gui secreto; taegüenao janagasgas todo y nengcano. ");
INSERT INTO cha_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yan ilegña: Y jumujuyong gui taotao, ayo munatataelaye y taotao. ");
INSERT INTO cha_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa y gui jinalomña gui corason y taotao sija nae, manjujuyong y manaelaye na jinaso sija, y manadulterio, y manábale yan y manpegno, ");
INSERT INTO cha_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Y mañaque sija, y manlatga, y manaelaye, y dinague, y inábale, y taelaye na atadog, y chinatfino contra si Yuus, y sobetbio, y bababa: ");
INSERT INTO cha_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Todo este sija na tinaelaye, manguine jalom ya janatataelaye y taotao. ");
INSERT INTO cha_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ya cajulo güije, mapos para y oriyan Tiro yan Sidon; ya jumalom gui guima, malagoña na taya utiningo; lao ti siña unatog. ");
INSERT INTO cha_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sa jajungog masasangan güe un palaoan na y diquique na jagaña, guaja un áplacha na espiritu, mato ya jatomba güe gui adengña: ");
INSERT INTO cha_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ya y palaoan Griega, gui tano Sirofenisa, y tinayuyut güe na uyute juyong gui jagaña y anite. ");
INSERT INTO cha_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lao ilegña nu guiya: Polo finena ya ufanjaspog y famaguon sija; sa ti mauleg machule y pan y famaguon, ya ufanmayotte y galago sija. ");
INSERT INTO cha_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ya manope y palaoan, ilegña: Junggan, Señot; lao y galago sija, gui papa lamasa, jacacanoja y andesmoronan y famaguon sija. ");
INSERT INTO cha_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ayo nae ilegña ni palaoan: Pot este na sinangan, janao y anite jumanao gui jagamo. ");
INSERT INTO cha_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ya anae jumanao para iyasija, jasoda na y jagaña umaason gui jilo cama, ya y anite esta jumanao. ");
INSERT INTO cha_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ya tumalo jumanao gui oriyan Tiro yan malofan guiya Sidon, ya mato gui tasen Galilea; ya malofan gui entalo y oriyan Decapolis. ");
INSERT INTO cha_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ya maconie güe un tanga ya udo, ya matayuyut güe na upolo y canaeña gui jiloña. ");
INSERT INTO cha_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ya janasajnge güe gui linajyan taotao, ya japolo y calolotña gui talangan y tanga, ya tumola ya japacha y jilaña; ");
INSERT INTO cha_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ya jaatan julo y langet sumospiros, ya ilegña: Efatha, cumequeilegña, mababa! ");
INSERT INTO cha_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ya mababa y talangaña; ya mapula y gumogode y jilaña, ya cumuentos mauleg. ");
INSERT INTO cha_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ya jaencatga sija, na chañija sumangangane ni jaye; lao mientras mas jaencatga, mas manamamto; ");
INSERT INTO cha_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ya ninafangosmanman, ilegñija: Mauleg finatinasña todo: janafanmanjungog y mananga, ya y manudo janafanguentos. ");
INSERT INTO cha_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","AYO sija na jaane, anae guaja talo un dangculon linajyan taotao ya taya jafa nañija, si Jesus jaagang y disipuluña sija, ya ilegña nu sija: ");
INSERT INTO cha_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Maase yo ni linajyan taotao sa esta tres jaane na manjame; ya taya jafa nañija. ");
INSERT INTO cha_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yaguin junafanjanao sin mañocho para iyasija, ufanlalango gui chalan; sa palo guiya sija manmato guine y chago. ");
INSERT INTO cha_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ya y disipuluña sija, maope güe: Guine mano nae siña manafanjaspog este taotao sija pan, güine gui desierto? ");
INSERT INTO cha_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Guiya jafaesen sija: Cuanto na pan guaja jamyo? Ylegñija, siete. ");
INSERT INTO cha_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ayo nae jatago y linajyan taotao na ufanason gui jilo oda; ya jachule y siete na pan, ya janae Yuus maase ya jaipe, ya janae y disipuluña sija para ujaplanta gui menanñija; ya sija japlanta gui menan y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yan guaja locue palo mandiquique na güijan sija; ya anae jabendise, jatago na ujaplanta locue gui menanñija. ");
INSERT INTO cha_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pues mañocho, ya manjaspog; ya majatsa y pidaso sija ni sebbla, siete canastra. ");
INSERT INTO cha_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ya y mañocho sija, buente cuatro mit; ya jadespide. ");
INSERT INTO cha_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ya enseguidas jumalom gui batco yan y disipuluña sija, ya manmato gui oriyan Dalmanuta. ");
INSERT INTO cha_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ya manmato y Fariseo sija, ya matutujon manafaesen yan güiya, manmanaliligao guiya güiya un señat guine y langet, matietienta güe. ");
INSERT INTO cha_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ya sumospiros gostadong gui espirituña, ya ilegña: Jafa na mangagagao señat este na generasion? Magajet jusangane jamyo, na ti umanae señat este na generasion. ");
INSERT INTO cha_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ya jadingo sija, ya jumalom talo gui batco, ya mapos para y otro banda. ");
INSERT INTO cha_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ya manmalefa ti manmañule pan, ya taya na unoja na pan gui batco. ");
INSERT INTO cha_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ya jaencatga sija, ilegña: Atan, adaje jamyo ni lebaduran y Fariseo sija, yan y lebaduran Herodes. ");
INSERT INTO cha_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ya manafaesen gui entalo sija, ilegña: Pot y taya panta. ");
INSERT INTO cha_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ya anae jatungo si Jesus ilegña nu sija: Jafa manafaesen gui entalomiyo pot y taya panmiyo? Ti injaso ni ti intingo? Majejetogja trabia y corasonmiyo? ");
INSERT INTO cha_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Guaja atadogmiyo, lao ti manmanlilie jamyo? Guaja talanganmiyo, ya ti manmanjujungogja jamyo? Ya ti injajasoja? ");
INSERT INTO cha_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Anae juipe y sinco na pan sija entalo y sinco mit, cuanto na canastra injatsa bula ni pidaso sija ni sebbla? Ylegñija: Dose. ");
INSERT INTO cha_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ya anae y siete na pan sija entalo y cuatro mit, cuanto na canastra injatsa bula ni pidaso sija ni sebbla? Ylegñija: Siete. ");
INSERT INTO cha_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Güiya ilegña nu sija: Ti intingo asta pago? ");
INSERT INTO cha_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ya mato guiya Betsaida; ya maconie güe guato un bachet, ya matayuyut güe na upacha güe. ");
INSERT INTO cha_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ayo nae jamantiene y canae y bachet, ya jacone asta y jiyong y siuda; ya anae jatolae y atadogña, japolo y canaeña gui jiloña, ya jafaesen: Unlie jafa? ");
INSERT INTO cha_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ya güiya manatan ya, ilegña: Julie taotao sija; lao julie sija calang trongconjayo na manmamómocat. ");
INSERT INTO cha_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Entonses japolo ya canaeña talo gui atadogña ya jaguefatan; ya jomlo, ya manlie claro todo. ");
INSERT INTO cha_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ya jatago para iyasija, ilegña: Chamo jumajalom gui sengsong (ni usangane jaye gui siuda). ");
INSERT INTO cha_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ya mapos si Jesus yan y disipuluña sija gui sensong sija y Cesarean Felipe: ya y chalan jafaesen y disipuluña sija, ilegña nu sija: Jaye ilegñija y taotao sija nu guajo? ");
INSERT INTO cha_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ya sija masangane güe, ilegñija: Si Juan Bautista; y palo ilegñija: Si Elias; y palo ilegñija: Uno gui profeta sija. ");
INSERT INTO cha_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ayo nae jafaesen sija: Ya jamyo, jaye ilegmiyo nu guajo? Inepe as Pedro ilegña: Jago si Cristo jao. ");
INSERT INTO cha_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ya jaencatga sija na chañija sumangangane ni jaye pot güiya. ");
INSERT INTO cha_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ya jatutujon fumanagüe sija na y Lajin taotao janesesita upadese megae, ya umarechasa ni manamco sija, yan y prinsipen y mamale sija, yan y escriba sija, ya umapuno; ya ucajulo talo gui mina tres na jaane. ");
INSERT INTO cha_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ya claroja nae jasangan este na sinangan. Ayo nae si Pedro quinene güe, ya tinitujon güe rineprende. ");
INSERT INTO cha_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lao anae jabira güe, ya jaatan y disipuluña sija, jalalatde si Pedro ilegña: Suja guiya guajo, Satanas; sa ti unadadaje y güinaja sija ni para si Yuus, na y güinajan taotao sija. ");
INSERT INTO cha_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ya jaagang y linajyan taotao yan y disipuluña sija, ya ilegña nu sija; Jaye y malago tumatiye yo, upune maesa güe, ya uchule y quiluusña ya udalalagyo. ");
INSERT INTO cha_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa y malago sumatba y linâlâña, ufinalingaeguan; lao y finalingaeguan ni linâlâña pot guajo, yan y ibangelio, este usatba y linâlâña. ");
INSERT INTO cha_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sa, jafa uaprobecha y taotao, yaguin jagana todo y tano, ya finalingaeguan ni linâlâña? ");
INSERT INTO cha_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pat jafa na apas ufannae y taotao pot y linâlâña? ");
INSERT INTO cha_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sa y mamajlao nu guajo yan y sinaganjo, gui sanmenan este y generasion ábale yan gaeisao, unimamajlaogüe locue ni Lajin taotao y tiempo nae mato gui minalag y Tataña, yan y mañantos na angjetña sija. ");
INSERT INTO cha_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","YA ilegña nu sija: Magajet jusangane jamyo, na guaja palo sija ni mangaegue güine na ti ujaguaeya finatae, asta que jalie y raenon Yuus na mato yan ninasiña. ");
INSERT INTO cha_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Anae esta malofan y sais na jaane, si Jesus jacone si Pedro, yan si Santiago, yan si Juan, janafañajnge sijaja gui un taquilo na ogso; ya jaago güe gui menanñija. ");
INSERT INTO cha_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ya y magaguña manmañila, gosapaca calang niebe, taya ni un fafagas gui tano siña munaapaca taegüine. ");
INSERT INTO cha_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ya manalie na mato guiya güiya si Elias yan Moises, na manguecuentos yan si Jesus. ");
INSERT INTO cha_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ayo nae manope si Pedro, ilegña as Jesus: Maestro mauleg utafañagajit güine, ya tafanmamatinas tres tabetnáculo; para jago y uno, para si Moises y otro, yan para si Elias y otro. ");
INSERT INTO cha_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Si ti jatungo jafa usangan, sa estaba mangosmaañao. ");
INSERT INTO cha_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ya mato un mapagajes y manjineme sija, ya un inagang gui mapagajes, ilegña: Este y güinaeyaco na Lajijo, jingog güe. ");
INSERT INTO cha_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ya derepente jaatan gui oriyañija, ti manmanlie ni jaye, na si Jesusja yan sija. ");
INSERT INTO cha_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ya anae manunog sija guine y egso, jaencatga sija na chañija sumangangane ni jaye ni liniiñija, asta que y Lajin taotao esta cajulo guine entalo y manmatae. ");
INSERT INTO cha_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ya sija jaadaje ayo na sinangan guiya sijaja, manafaesen gui entaloñija: Jafa ayo y cajulo guine entalo y manmatae cumequeilegña. ");
INSERT INTO cha_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ya mafaesen güe, ilegñija: Y escriba sija ilegñija, si Elias nesesita ufato finenana. ");
INSERT INTO cha_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Güiya manope ilegña nu sija: Si Elias magajet nesesita ufato finenana, ya jafatinas talo todo y güinaja: Jafa esta matugue gui Lajin taotao na upadese megae ya manataya guaelayeña? ");
INSERT INTO cha_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lao jusangane jamyo na si Elias esta mato ya esta mafatinas guiya güiya todo y malagoñija, taegüine esta matugue nu güiya. ");
INSERT INTO cha_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ya anae mato gui disipuluña sija, jalie un dangculon linajyan taotao gui oriyañija, yan y escriba sija ni manafaesen yan sija. ");
INSERT INTO cha_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ya enseguidas todo y linajyan taotao, anae malie güe, ninafangosmanman, ya manmalago guato guiya güiya ya masaluda güe. ");
INSERT INTO cha_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ya jafaesen sija, ilegña! Jafana manafaesen jamyo yan sija? ");
INSERT INTO cha_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ya manope uno gui linajyan taotao, ilegña: Maestro juconie jao mague na lajijo, na guaja un espiritun udo; ");
INSERT INTO cha_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ya manoja nae quinene güe, japedadasos; ya bóboan, ya janachechegcheg y nifenña, ya ninayafae; ya jusangane y disipulumo sija, na ujayute juyong, lao ti manasiña. ");
INSERT INTO cha_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Manope güe, ilegña nu sija: O generasion ni ti manjonggue! asta ngaean nae utafanjijitaja? asta ngaean nae jususungonja jamyo? maelayofan mague. ");
INSERT INTO cha_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ya maconie guato guiya güiya; ya anae jalie, enseguidas y espiritu manlálaolao güe; ya güiya podong gui jilo oda gumagalileg ya bóboan. ");
INSERT INTO cha_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ya jafaesen y tataña; cuanto tiempo esta desde qui mato este guiya güiya? Güiya ilegña: Desde qui diquique: ");
INSERT INTO cha_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya megae na biaje nae yinite gui jalom guafe, yan y jalom janom para upinino; lao yaguin siña jao ayudajam, gaemaase nu jame. ");
INSERT INTO cha_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Si Jesus, ilegña nu güiya: Yaguin siña jao, todo siña para y manjonggue. ");
INSERT INTO cha_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Enseguidas y tatan y patgon, jaagang yan y lagoña, ya elegña: Jujonggue; ayuda y taejinenggueco. ");
INSERT INTO cha_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ya anae si Jesus jalie na manmalalago y linajyan taotao, jalalatde y áplacha na espiritu, ilegña: Espiritun udo yan tanga, guajo jao tumago, juyong guiya güiya, ya chamo jumajalom talo guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ayo nae y espiritu umagang, ya manlalaolao güe megae, ya jumuyong; ya güiya sumaga calang matae, enaomina megae ilegñija, na esta matae. ");
INSERT INTO cha_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lao si Jesus jamantiene canaeña, ya jinatsa güe; ya cajulo. ");
INSERT INTO cha_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ya anae jumalom güe gui jalom guma, y disipuluña sija mafaesen güe en secreto, ilegñija: Jafajam na ti innasiña yumute juyong? ");
INSERT INTO cha_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ya ilegña nu sija: Este na rasan anite sija, taya siña munajanao, na y tinayuyut. ");
INSERT INTO cha_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ya manmapos güije, manmalofan inanaco Galilea; ya ti malago na guaja utiningo güe. ");
INSERT INTO cha_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sa jafanagüe y disipuluña sija ya ilegña nu sija: Y Lajin taotao umaentrega gui canae taotao sija, ya umapuno; lao yaguin este matae, ucajulo talo despues di tres na jaane. ");
INSERT INTO cha_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lao sija ti jatungo este na sinangan, ya manmaañao na ujafaesen güe. ");
INSERT INTO cha_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ya mato guiya Capernaum; ya anae mato gui guima, jafaesen sija: Jafa jamyo na manafaesen entalomiyoja gui chalan? ");
INSERT INTO cha_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lao sija manmamatquiquiloja; sa guine manafaesen gui chalan uno y otro, jaye guiya sija udangculo. ");
INSERT INTO cha_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ayo nae manmatachong, ya jaagang y dose ya ilegña nu sija: Y malago fuminenana, uuttimon gui tododos, yan utentagon tododos. ");
INSERT INTO cha_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ya jacone un patgon, ya japolo gui entaloñija; ya jajogüe gui canaeña, ya ilegña nu sija: ");
INSERT INTO cha_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Y rumesibe pot y naanjo uno ni manaegüine na famaguon, jaresibe yo, ya y rumesibe yo, ti guajo jaresibe, na y tumago yo. ");
INSERT INTO cha_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Si Juan, ilegña nu güiya: Maestro, inlie uno na manyute juyong anite sija pot y naanmo, ya inchema, sa ti jadadalalagjit. ");
INSERT INTO cha_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ya si Jesus ilegña: Chamiyo chumochoma; sa ni uno ni fumatinas milagro pot y naanjo, siña gusisija jasangan taelaye guiya guajo. ");
INSERT INTO cha_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sa ayo y ti contra jita, manjijitaja. ");
INSERT INTO cha_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sa jayeja y numae jamyo un copan janom, sa iyon Cristo jamyo, magajet jusangane jamyo, na sen ti ufalingo y apasña. ");
INSERT INTO cha_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ya jayeja y ninaquepodong uno guine sija gui mandiquique ni jumonggue yo; mauleg para güiya, umagode gui agagaña un acho atutong, ya umayute gui jalom tase. ");
INSERT INTO cha_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Lao yaguin y canaemo ninaquepodong jao, utut; maulegña na unjalom gui linâlâ mangco, qui uguaja dos canaemo, ya unjanao para sasalaguan, y guafe ni ti siña mapuno. ");
INSERT INTO cha_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Anae y iloñija ti ufanmatae; ya y guafe taejinecog nae umapuno.) ");
INSERT INTO cha_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ya yaguin y adengmo ninaquepodong jao, utut: maulegña na unjalom gui linâlâ cojo, qui uguaja dos adengmo ya unyenite para sasalaguan; ");
INSERT INTO cha_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Anae y iloñija ti ufanmatae, ya y guafe taejinecog nae umapuno.) ");
INSERT INTO cha_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ya yaguin y atadogmo ninaquepodong jao, lagnos; maulegña na unjalom gui raenon Yuus, yan un atadogja, qui uguaja dos atadogmo ya unyenite para sasalaguan. ");
INSERT INTO cha_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","(Anae y iloñija ti ufanmatae, ya y guafe taejinecog na umapuno.) ");
INSERT INTO cha_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sa todos ufanmaasne yan guafe; (ya todo y inefrese ufanmaasne yan asiga). ");
INSERT INTO cha_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mauleg y asiga; lao yaguin y asiga malingo y maasenña, jaftaemano numamaasen? Guaja asiganmiyo guiya jamyoja; yan guaja pas gui entalomiyo. ");
INSERT INTO cha_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","YA cajulo güije, mato qui oriyan Judea, gui otro bandan Jordan; ya manalo y linajyan taotao mandaña guiya güiya; ya jatalo fumanagüe, taegüije, y costumbreña. ");
INSERT INTO cha_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ya manmato y Fariseo sija guiya güiya, ya mafaesen güe cao tunas y laje uyute y asaguaña? matietienta güe. ");
INSERT INTO cha_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Lao güiya manope, ilegña nu sija: Jafa mantinago jamyo as Moises? ");
INSERT INTO cha_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ya sija ilegñija: Si Moises japetmite na umatugue papet inapattan umasagua ya uyute. ");
INSERT INTO cha_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ya si Jesus manope, ilegña nu sija: Pot y majetog corasonmiyo na mantiniguie jamyo ni este na tinago. ");
INSERT INTO cha_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lao desde tutujon y jiniyong, Laje yan palaoan fumatinas sija Yuus. ");
INSERT INTO cha_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pot este na rason y laje udingo si tataña yan si nanaña, ya udaña yan y asaguaña. ");
INSERT INTO cha_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ya y este y dos, umana unoja na catne; ya esta ti udos mas, na unoja na catne. ");
INSERT INTO cha_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jafaja si Yuus munadaña, y taotao ti unadesapatta. ");
INSERT INTO cha_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ya y jalom guma, y disipulo sija mafaesen güe talo ni ayoja. ");
INSERT INTO cha_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ya ilegña nu sija: Jayeja y yumute y asaguaña, ya umasagua yan otro, jafatinas y adulterio contra y palaoan. ");
INSERT INTO cha_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ya yaguin y palaoan yumute y asaguaña, ya umasagua yan otro, jafatinas adulterio. ");
INSERT INTO cha_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ya machulie guato guiya güiya diquique na famaguon para upacha: ya y disipulo sija jalalatde ayo sija. ");
INSERT INTO cha_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ya anae jalie si Jesus, sen ti ninamagof ya ilegña nu sija: Polo y diquique na famaguon ya ufanmamaela guiya guajo; chamiyo chumochoma; sa iyon este sija y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Magajet jusangane jamyo, na y ti rumesibe y raenon Yuus calang un patgon, ti ujalom gui jalom ayo. ");
INSERT INTO cha_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ya jajogüe sija ya japolo y canaeña gui jiloñija, ya jabendise sija. ");
INSERT INTO cha_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ya anae jumanao gui chalan, mato uno malalago ya dinimuye güe gui menaña ya finaesen güe: Mauleg na Maestro, jafa jufatinas para juereda y taejinecog na linâlâ? ");
INSERT INTO cha_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Si Jesus ilegña nu güiya: Jafa na ilegmo nu guajo mauleg? Taya mauleg, na unoja, si Yuus. ");
INSERT INTO cha_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Untungo y tinago sija: Chamofamumuno; chamo fumatinas adulterio; chamo fañañaque; chamo sumanganñaejon y ti magajet na testimonio; chamo chumu y ti iyomo; onra si tatamo yan si nanamo. ");
INSERT INTO cha_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Güiya manope ilegña: Maestro, todo este juadadaje desde nae patgonyo. ");
INSERT INTO cha_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ayo nae matan güe as Jesus, güinaeya güe, ya ilegña nu güiya: Fatta jao uno: Janao ya ufajan todo y güinajamo, ya unnae y mamobble sija, ya uguaja güinajamo gui langet: ya maela, ya undalalag yo. ");
INSERT INTO cha_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lao güiya ninamatolaeca y mataña ni este na sinangan ya mapos ninatriste; sa guaja megae güinajaña. ");
INSERT INTO cha_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ayo nae si Jesus manatan gui oriya, ya ilegña ni disipuluña sija: Na minapot manjalom gui raenon Yuus ayo sija y mangaegüinaja! ");
INSERT INTO cha_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ya y disipulo sija ninafanmanman ni sinanganña: Lao si Jesus manope ilegña talo: Famaguon, na minapot manjalom, gui raenon Yuus y umangongoco sija gui güinaja! ");
INSERT INTO cha_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas guse malofan un cameyo gui matan un jaguja, qui y gaegüinaja ujalom gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ya sija ninagos fanmanmanman, ya ilegñija nu güiya: Ayo nae, jaye siña satbo? ");
INSERT INTO cha_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ayo nae si Jesus jaatan sija, ya ilegña: Para y taotao sija, este ti siña, lao para si Yuus ti taegüine; sa para si Yuus todo ninasiña. ");
INSERT INTO cha_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ayonae si Pedro jatutujon ilegña nu güiya: Estagüejamja na indingo todo, ya indadalalagjao. ");
INSERT INTO cha_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Inepe as Jesus ilegña. Magajet jusanganejao: Taya ni un taotao ni y dumingo gumaña, pat mañeluña lalaje, pat mañeluña famalaoan, pat nanaña, pat tataña, pat famaguonña, pat fangualuaña, pot guajo, yan y ibangelio; ");
INSERT INTO cha_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Na ti uresibe pagoja sienbiaje: guma sija, yan mañeluña lalaje, yan mañeluña famalaoan, yan nanaña, yan famaguonña, yan fangualuan sija, yan umapetsigue; ya y mámamaela na siglo, taejinecog na linâlâ. ");
INSERT INTO cha_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lao megae na manfinenana, ufanuttimo, ya y manuttimo, ufanfinenana. ");
INSERT INTO cha_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ya anae mangaegue gui chalan, mangajulo guiya Jerusalem; ya si Jesus malag y menañija; ya ninafanmanman: ya y dumadalalag mangosmaañao. Ya jacone talo y dose, ya jatutujon sumangane sija jafa ususede güe. ");
INSERT INTO cha_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ylegña: Estagüejit na mangajulo guiya Jerusalem, ya y Lajin taotao umaentrega gui magas mamale, yan y escriba sija, ya umasentensia para umapuno, ya umaentrega gui Gentiles. ");
INSERT INTO cha_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ya umamofea, yan umatolae, yan umasaulag, yan umapuno; ya y despues di tres na jaane ucajulo talo. ");
INSERT INTO cha_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ya si Santiago yan si Juan, lalajin Sebedeo, manmato jijot guiya güiya ya ilegñija nu güiya: Maestro, manmalagojam na unfatinas guiyajame jafa y malagomame. ");
INSERT INTO cha_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ya ilegña nu sija: Jafa malagonmiyo na jufatinas guiya jamyo? ");
INSERT INTO cha_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ilegñija nu güiya: Nafanmatachongjam, y uno gui agapamo, ya y otro gui acagüemo, gui minalagmo. ");
INSERT INTO cha_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Si Jesus ilegña nu sija: Ti intingo jafa ingagagao. Siña jamyo manguimen gui copa anae gumiguimenyo? yan infanmatagpange ni y matagpangeco? ");
INSERT INTO cha_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ya ilegñija nu güiya: Mansiñajam. Ayonae ilegña si Jesus nu sija: infanguimen gui copa anae gumiguimenyo, yan infanmatagpange ni y ma tagpangeco; ");
INSERT INTO cha_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lao y infanmatachong gui agapajo, yan y acagüeco; ti guajo jufannae; lao para ayo sija ufanmanae y manmapreparaye. ");
INSERT INTO cha_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ya anae majungog este ni y dies, ninafanlalalo as Santiago yan Juan. ");
INSERT INTO cha_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Lao maninagang as Jesus ya ilegña nu sija: Intingo na ayo y manmanafanmagas gui Gentiles, jafatinas minagas gui jiloñija; ya y manmagas, jafatinas ninasiña gui jiloñija. ");
INSERT INTO cha_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lao ti utaegüenao guiya jamyo; sa jaye y malago dumangculo guiya jamyo; güiya ufañeñetbe. ");
INSERT INTO cha_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ya jaye guiya jamyo y malago mumagas; utentago para todo. ");
INSERT INTO cha_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sa magajet ni y Lajin taotao ti mato para umasetbe, lao para ufañetbe, ya para ufannae y jaaniña ni un rescate para unafanlibre megae. ");
INSERT INTO cha_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ya manmato Jerico. Ya anae manjanao gui Jerico, yan y disipuluña yan un dangculon linajyan taotao, si Bartimeo lajin Timeo, na bachet, matatachong gui oriyan chalan, ya umegagao. ");
INSERT INTO cha_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ya anae jajungog na si Jesus Nasareno, jatutujon umagang ilegña: Jesus, Lajin David, gaease nu guajo. ");
INSERT INTO cha_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ya megae mumomye para ufamatquilo: lao mas umagang gosagang: Jago ni y Lajin David, gaease nu guajo. ");
INSERT INTO cha_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ya si Jesus tumojgüe ya ilegña: Agang güe. Ya maagang y bachet ilegñija nu güiya: Magofjao; cajulo sa inaagangjao. ");
INSERT INTO cha_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ya janasuja y capaña, y cajulo, ya malag as Jesus. ");
INSERT INTO cha_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ya si Jesus manopegüe ya ilegña: Jafa malagomo jufatinas guiya jago? Y bachet ilegña nu güiya: Raboni, nafanliiyo. ");
INSERT INTO cha_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Si Jesus ilegña: Janao, y jinengguemo munajomlojao. Ya enseguidas manlie, ya jadalalag si Jesus gui jinanaoña. ");
INSERT INTO cha_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","YA anae esta manjijijot Jerusalem, yan Betfage, yan Betania, gui egso Olibo, jatago dos gui disipuluña, ");
INSERT INTO cha_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ya ilegña nu sija: Janao fanmalag y sengsong gui menanmiyo: ya enseguidas qui manjalom jamyo, inseda un patgon bulico, na magogode, na taya nae matachonge; pila ya inquene mague. ");
INSERT INTO cha_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ya yanguin jaye na taotao umalog nu jamyo; Jafa na infatinas este? Sangane: Señot janesesita: ya enseguidas umanajanao mague. ");
INSERT INTO cha_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ya manmapos, ya masoda nu patgon bulico gui caye na magogode gui jiyong potta ya mapula güe. ");
INSERT INTO cha_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ya palo ni y mangaegue güije ilegñija nu sija: Jafa na inpila enao y patgon bulico? ");
INSERT INTO cha_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ya masangane jaftaemano y mansinangane as Jesus: ya japolo na ufanjanao. ");
INSERT INTO cha_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ya macone guato y patgon bulico gui as Jesus, ya japolo magagoñija güi jiloña ya maudae si Jesus. ");
INSERT INTO cha_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ya megae jajuto magagoñija gui chalan: yan palo y ramas jayo na manmanuutot gui fangualuan. ");
INSERT INTO cha_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ya ayo sija y manmofona gui menaña, yan y madalalag gui tatteña, manaagang ilegñija: Hosana; Bendito ayo y mato pot y naan y Señot: ");
INSERT INTO cha_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bendito y raeno na mamamaela, y raenon y tatata as David, Hosana guiyajululu. ");
INSERT INTO cha_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ya si Jesus jumalom Jerusalem, ya jumalom gui templo; ya anae munjayan jalie todo y güinaja, ya y pupuenge, mapos yan y dose, manmalag Betania. ");
INSERT INTO cha_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ya y inagpaña anae manmato guinen Betania, ñalang. ");
INSERT INTO cha_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ya anae jalie mona un trongcon igos na gagaejagonja, malag ayo jinasoña na ufañoda jafa; lao anae mato guato, taya sinedaña na jagonja; sa ti tiempopoña y igos trabia. ");
INSERT INTO cha_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ayonae manope ya ilegña nu güiya: Taya ni un taotao uquinano y tinegchamo para siempre. Ya majungog ni y disipuluña. ");
INSERT INTO cha_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ya manmato Jerusalem; ya jumalom y templo, ya sigue di jayute juyong todo ayo sija y manmanbebende, yan y manmamamajan gui templo, yan janafanalinquin y lamasan salape y manmanulalaeca, yan y tachong y man manbebende paluma: ");
INSERT INTO cha_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ya taya ni uno jaconsiente na ufañule baso gui templo. ");
INSERT INTO cha_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ya mamanagüe, ilegña nu sija: Ada ti matugue na y guimajo umafanaan guma manaetae ni y todo nasion sija? lao jamyo fumatinas y liyang mañañaque. ");
INSERT INTO cha_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ya majungog ni y magas mamale yan y escriba sija, ya maaliligao jaftaemano para umapuno; sa mamaañao nu güiya, sa janafanmamanman y linajyan taotao ni y finanagüeña. ");
INSERT INTO cha_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ya cada pupuenge, jumanao juyong gui siuda. ");
INSERT INTO cha_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ya y egaan anae manmalolofan, malie y trongcon igos na anglo desde y jale. ");
INSERT INTO cha_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ayonae jajaso si Pedro ya ilegña nu güiya: Rabi, estagüe y trongcon igos ni y unmatdise na anglo todo. ");
INSERT INTO cha_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ya manope si Jesus ilegña nu sija: Jenggue si Yuus. ");
INSERT INTO cha_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sa magajet jusangane jamyo: Jayeja y umalog ni este y egso, janao ya unyutejao gui tase; ya ti bumuebuente gui corasonña, lao jajonggue na umafatinas ayo y sinanganña; uguaja. ");
INSERT INTO cha_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Enaomina jusangane jamyo: Na todo sija ingagao, anae manmanaetae jamyo, jenggue na esta inresibe, ya infanmannae. ");
INSERT INTO cha_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ya an manojgue ya mananaetaejamyo, asie yanguin guajajao jafa contra jaye; sa y Tatanmiyo locue ni y gaegue gui langet, uninasie ni y isaomiyo. ");
INSERT INTO cha_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lao yanguin ti manasiijamyo, y Tatanmiyo ni y gaegue gui langet ti uninasie ni y isaomiyo. ");
INSERT INTO cha_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ya manmato talo Jerusalem, ya anae mamomocat gui templo, manmato y magas mamale, yan y escriba, yan y manamco sija; ");
INSERT INTO cha_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ya ilegñija nu güiya: Pot jafa na ninasiña na unfatitinas estesija? yan jayejao numae ni este na ninasiña, para unfatinas estesija? ");
INSERT INTO cha_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ya si Jesus ilegña nu sija: Bae jufaesen locue jamyo un finaesen ya inepeyo, ayonae jusangane jamyo pot jafa na ninasiña na jufatitinas este sija. ");
INSERT INTO cha_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Y tinagpangen Juan, guinen y langet, pat guinen y taotao sija? epeyo. ");
INSERT INTO cha_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ya jajajaso gui sumanjalomñija, ilegñija: Yanguin ilegmame, Guinen y langet; ualog: Jafanae na ti injenggue güe? ");
INSERT INTO cha_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yanguin ilegmame guinen y taotao sija—manmaañao ni y taotao, sa pineloñija todo na magajet na profeta si Juan. ");
INSERT INTO cha_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ya manmanope, ilegñija as Jesus: Ti intingo. Ayonae si Jesus ilegña nu sija; ni guajo locue ti jusangane jamyo pot jafa naninasiña, na jufatitinas estesija. ");
INSERT INTO cha_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","YA sigue di jacuentuse sija acomparasion sija. Un taotao mananom gui fangualuan ubas, ya jacolat nu trongcon tituca, ya manguadog un joyo para un lagat ya jafatinas un tore, ya jaatquila y manfafachocho, ya mapos güe malag otro tano. ");
INSERT INTO cha_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ya anae esta tiempo, jatago uno gui tentagoña para ayo y manmachochocho, para ujaresibe guinen manmachochocho y tinegcha y fangualuan ubas. ");
INSERT INTO cha_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ya macone y tentago, ya masaulag, ya manajanao taesinajguan. ");
INSERT INTO cha_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ya jatago talo y otro tentagoña; ya mapoca y iluña, ya manataelaye güe gosdangculo. ");
INSERT INTO cha_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ya jatalo tumago y otro, ya mapuno; yan otro megae ya palo manmasaulag yan palo manmapuno. ");
INSERT INTO cha_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ya guaja unoja lajiña na sumenyaña; ya güiya uttimo jatago, ilegña: Ufangaerespeto ni y lajijo. ");
INSERT INTO cha_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ya ayo sija y manmachochocho, ilegñija gui sumanjalomñija. Estagüe y eredero; nije tapuno, ya y fangualuan uiyota. ");
INSERT INTO cha_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ya macone güe, ya mapuno, ya mayute juyong gui fangualuan. ");
INSERT INTO cha_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jafa pago ufatinas y magas y fangualuan? Ufato, ya uyulang todo y manmachochocho, ya ufannae otro ni y fangualuan. ");
INSERT INTO cha_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Taya nae intaetae este na tinigue: Y acho, ni y jarechasa y manmanmatitinas ni y guima, esteja mapolo cuentan ulo gui esquina. ");
INSERT INTO cha_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Este finatinas y Señot, ya janafanmanman gui menan atadogta. ");
INSERT INTO cha_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ya maaliligao para umagote lao manmaañao ni y linajyan taotao; sa matungo na jasasangan y acomparasion contra sija: ya madingo, ya manmapos gui jinanaoñija. ");
INSERT INTO cha_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ya manmatago guato guiya güiya palo gui Fariseo sija yan taotao Herodes; para umaquegacha gui sinanganña. ");
INSERT INTO cha_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ya anae manmato, ilegñija nu güiya: Maestro, intingo na jago magajetjao; ya taya unadadaje ni un taotao; sa ti guaelaye nu jago y finaboresen taotao, lao mamananagüejao ni y magajet na chalan Yuus. Tunas na infanmanaejam tributo as Sesat, pat aje? ");
INSERT INTO cha_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Innae, pat mungajam numae? Lao si Jesus jatungoja y quinadoñija, ya ilegña nu sija: Jafa muna na intietientayo? maela un denarion salape ya julie. ");
INSERT INTO cha_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ya anae machulie guato, ilegña nu sija: Iyon jaye este na imagen yan tinigue? Ylegñija nu güiya: Iyon Sesat. ");
INSERT INTO cha_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ayonae si Jesus ilegña nu sija: Nae si Sesat ni y iyon Sesat, ya si Yuus ni y iyon Yuus. Ya ninafangosmanman nu güiya. ");
INSERT INTO cha_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ya manmato guiya güiya y Saduseo sija ni y ilegñija, na taya quinajulo y mannatae; ya mafaesen güe, ilegñija: ");
INSERT INTO cha_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro, jatuguiejam si Moises: Yanguin y chelun un taotao matae, ya y palaoan ni y asaguaña sumaga ya taya patgonña, ayo y laje ni y chelun y matae, uasagua talo y palaoan, ya ufamasemiya gui cheluña. ");
INSERT INTO cha_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ya guaja seite lalaje na mañelu: y finenana umasagua, ya matae ti mapolo semiya: ");
INSERT INTO cha_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Inasagua talo y palaoan ni y mina dos, ya matae talo taya pineloña semiya: ya y mina tres taegüijeja talo. ");
INSERT INTO cha_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ya y siete, ti mapolo semiyañijo; despues di todos, matae y palaoan locue. ");
INSERT INTO cha_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y quinajulo y manmatae, jaye guiya sija ugae asagua y palaoan? sa todo y siete manmasagua. ");
INSERT INTO cha_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Si Jesus ilegña nu sija: Ada ti manlache jamyo, sa ti intingo y tinigue, ni y ninasiñan Yuus? ");
INSERT INTO cha_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sa y mangajulo guinen manmatae, ni ufanasagua, ni umanafanasagua; lao manparejoja yan y angjet sija gui langet. ");
INSERT INTO cha_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ya y manmatae ni y ufannacajulo; ti untaetae gui leblon Moises, jaftaemano si Yuus gui jalomtano guiya trongcon jayo ni y ilegña as Moises: Guajo si Yuus Abraham, yan si Yuus Ysaac, yan si Yuus Jacob? ");
INSERT INTO cha_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ti güiya si Yuus y manmatae, na si Yuus y manlâlâlâ; enaomina ninafangoslache jamyo. ");
INSERT INTO cha_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ya uno gui escriba mato, ya jajungog na manafaesen entresija, ya jatungo na mauleg inepeña nu sija, finaesen güe: Jafa y finenana qui todo na tinago? ");
INSERT INTO cha_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Si Jesus manope: Este y finenana na tinago: Jingog O Israel: Y Señot Yuusta, unoja na Señot: ");
INSERT INTO cha_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ya guaeya jamyo y Señot, Yuusmiyo, contodo y corasonmiyo, yan contodo y antenmiyo, yan contodo y jinasonmiyo, yan contodo y minetgotmiyo. ");
INSERT INTO cha_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ya este y segundo: Guaeya y tiguangmo parejo yan jago. Taya otro tinago mas, mandangculo qui estesija. ");
INSERT INTO cha_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ya y escriba ilegña nu güiya. Magajet Maestro, mauleg na unsangan na güiya unoja; ya taya otro na güiyaja. ");
INSERT INTO cha_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ya ugumaeya güe contodo y corason, yan contodo y tiningo, yan contodo y minetgot, yan ugumaeya y tiguangña parejo yan güiya, mas qui todo y inefrese, yan y ninae sija. ");
INSERT INTO cha_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ya anae jalie si Jesus ni y minejnalom inepeña, ilegña nu güiya: Ti chagojao gui raenon Yuus. Ya taya ni un taotao fumaesen güe talo desde ayo. ");
INSERT INTO cha_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ya maninepe as Jesus gui anae mamananagüe gui templo, ilegña: Jafa na ilegñija y escriba sija, na si Cristo Lajin David? ");
INSERT INTO cha_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sa si David mismo ilegña gui Espiritu Santo: Y Señot ilegña ni y Señotto: Fatachong gui agapa na canaejo, asta qui jupolo y enemigumo sija gui papa y fañajangan adengmo. ");
INSERT INTO cha_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David jafanaan güe Señot; ya jaftaemano na y lajiña? Ya manmagof y dangculon linajyan taotao sija anae majungog. ");
INSERT INTO cha_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ya ilegña gui finanagüeña: Adaje jamyo ni y escriba sija, sa yanñija manjanao yan y anaco magagoñija, yan yanñija manmasaluda gui metcado, ");
INSERT INTO cha_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yan y manmagas na tachong gui sinagoga, yan y ya jululo na tachong gui guipot; ");
INSERT INTO cha_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ni y jatucho y guima y biuda sija, ya janafananaco tinaetaeñija ni y dinague: este sija ujaresibe dangculo na sentensia. ");
INSERT INTO cha_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ya anae matachong si Jesus gui menan y cajon ni y para y ninae; megae na taotao manmato, ya manmanyute jalom salape gui cajon; ya y megae na manrico sija, megae yiniteñija jalom. ");
INSERT INTO cha_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ya mato un pobble na buida; ya manyute jalom dos cobble na bale buente un centavos. ");
INSERT INTO cha_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ya si Jesus jaagang y disipuluña, ya ilegña nu sija: Magajet jusangane jamyo: Este y pebble na biuda, mas megae yiniteña jalom qui ni todo ayo sija y guinen manmanyute jalom gui cajon. ");
INSERT INTO cha_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sa todo y manmanyute jalom, pot y minegaeñijaja; lao güiya pot y minalagoñaja na jayute jalom todo y güinajaña; asta y sustentoña todo. ");
INSERT INTO cha_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","YA anae jumuyong gui templo; ilegña nu güiya uno gui disipuluña: Maestro, liija na jechuran acho, yan guma sija. ");
INSERT INTO cha_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ya si Jesus manope ilegña nu sija: Unlie este sija na mandangculon guma? taya usobbla ni un acho gui jilo y otro, na ti umayute papa. ");
INSERT INTO cha_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ya anae matachong gui jilo y finabeca na y naanña Olibo, gui menan y templo, finaesen gui secreto as Pedro, yan Santiago, yan si Juan, yan si Andres, ");
INSERT INTO cha_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ilegñija: Sanganejam, ngaean estesija ufanmato? yan jafa na señat yanguin para todo estesija nae ufanmacumple? ");
INSERT INTO cha_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Si Jesus jatutujon ilegña nu sija: Adaje jamyo, ya chamiyo fanmafabababa. ");
INSERT INTO cha_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sa megae ufanmato pot y naanjo, ya ualog: Guajo güiya Jesucristo, ya ufababa megae. ");
INSERT INTO cha_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yanguin injingog y guera, yan y masangan y guera: chamiyo ninafañachatsaga: sa nesesita estesija jumuyong: lao trabia ti y jinecog. ");
INSERT INTO cha_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sa y nasion sija ufangajulo contra y nasion, yan y raeno contra raeno: ya uguaja linao gui megae na lugat ya uguaja ñinalang: estesija tutujon y pinite. ");
INSERT INTO cha_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Lao adaje jamyo: sa infanmaentrega gui tribunal sija; ya infanmasaulag gui sinagoga: yan infanojgue gui menan y manmagas sija yan y ray sija, pot causa de guajo para un testimonio contra sija. ");
INSERT INTO cha_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ya y ibangelio nesesita umapredica finenana gui entre todo y nasion. ");
INSERT INTO cha_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lao anae maconejamyo, ya maentregajamyo, chamiyo jumajaso jafa para insangan, ni injasuye jafa: sa jafaja y manaejamyo güije na ora, ayoja insangan: sa ti jamyo infangcuentos, na y Espiritu Santo. ");
INSERT INTO cha_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pago y laje uentrega y cheluña laje, para umapuno; ya y tata y lajiña: ya y famaguon ufangajulo contra y mañaenanñija: ya uuafanmapuno. ");
INSERT INTO cha_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ya jamyo infanmachatlie ni todo y taotao sija, pot y naanjo: lao jaye y sumungon asta y uttimo, umasatba. ");
INSERT INTO cha_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Lao anae inlie y chinatlie y inginon na yinilang tumotojgue gui anae ti para utojgue, (y mananaetae utungo) ayo sija y mangaegue guiya Judea ufanmalago para y jalomtano: ");
INSERT INTO cha_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ya y gaegue gui jilo guma, chaña tumutunog ni ujalom ya ufañule jafa na güinaja gui jalom gumaña. ");
INSERT INTO cha_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya y gaegue gui fangualuan, chaña tumatalo tate para uchule y magaguña. ");
INSERT INTO cha_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lao mannamaase ayo sija y manmapotgue yan y mannanasusu, güije sija na jaane! ");
INSERT INTO cha_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Fanmanaetae, ya munga y jinanaomiyo gui tiempon y manenggeng. ");
INSERT INTO cha_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sa ayo sija na jaane, uguaja pininite, ni y taya nae guaja desde y matutujon y tano, anae jafatinas si Yuus, asta pago; ni uguaja asta jinecog. ");
INSERT INTO cha_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lao yaguin ti janacadada y Señot ayo sija na jaane, taya catne usatba: lao pot y rason y manmaayigja, ni y inayigña, janacadada ayo sija na jaane. ");
INSERT INTO cha_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ya yanguin guaja umalog nu jago: Estagüe si Cristo: pat ayogüe guato; chamiyo jumojonggue. ");
INSERT INTO cha_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sa ufangajulo sija ti manmagajet na Cristo sija, yan ti manmagajet na profeta sija, ya ufanmamanue sija señat yan mannamanman, para ufanmamababa, yanguin janasiña, asta y manmaayig. ");
INSERT INTO cha_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lao adaje jamyo: Sa estagüeja, na jusangane jamyo todos antes. ");
INSERT INTO cha_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lao ayo sija na jaane an munjayan y pininite sija; ujomjom y atdao, ya y pilan ti ufanina, ");
INSERT INTO cha_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ya y pution sija gui langet ufamodong, ya y ninasifia sija gui langet ufanmayengyong. ");
INSERT INTO cha_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ya ayo nae ujalie y Lajin taotao na mamamaela gui sanjalom mapagajes, yan y dangculon ninasiñaña yan y minalagña. ");
INSERT INTO cha_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ya ayonae utago y angjetña sija na ujarecoje y inayigña sija, guinen y cuatro na manglo, guinen y uttimon y tano asta y uttimon y langet. ");
INSERT INTO cha_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tingo y acomparasion y trongcon igos; Anae mamaulegja trabia y ramasña, ya manjajagonja, intingoja na esta jijijot y tiempon maepe. ");
INSERT INTO cha_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jamyo locue anae inlie estesija, na manmato, tingoja na güiya esta jijijot, parejoja yan esta gaegue gui petta. ");
INSERT INTO cha_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Magajet jusangane jamyo: Este na generasion ti ufanmalofan, asta que todo estesija munjayan manmachogüe. ");
INSERT INTO cha_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Y langet yan y tano, ufanmalofan, lao y sinanganjo ti ufalofan. ");
INSERT INTO cha_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Lao ayo na jaane pat ayo na ora, taya ni un taotao tumungo; ni y angjet sija ni mangaegue gui langet, ni y Laje; na y Tata güiyaja. ");
INSERT INTO cha_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Adaje jamyo: fanbela, ya infanmanaetae: sa ti intingo ngaean y tiempo. ");
INSERT INTO cha_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Say y Lajin taotao, parejoja yan un taotao ni y jumajanao chago ya jadingo y gumaña; ya janae y tentagoña ninasiñañija yan cada uno y chechoña, ya jatago y pottero na ufanbela. ");
INSERT INTO cha_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Fanbela, sa ti intingo ngaean nae ufato y magas y guima; cao y pupuenge, pat y tatalopuenge, pat y oogayo, pat y egaan; ");
INSERT INTO cha_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na, noseaja derepente ufato, ya infansineda manmamaego. ");
INSERT INTO cha_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ya jafa y jusangane jamyo, jusanganeja todos: Fanbela. ");
INSERT INTO cha_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","GUAJA dos na jaane antes di guipot y pascua yan y taelibadura na pan: ya y magas mamale sija, yan y escriba sija, maaliligao jaftaemano para umafababa, ya umacone, ya umapuno. ");
INSERT INTO cha_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lao ilegñija: Munga gui guipot na jaane, sa noseaja uguaja atboroto ni y taotao sija. ");
INSERT INTO cha_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ya anae estaba guiya Betania, gui guima Simon y ategtog, ya matachong gui lamasa para uchocho; mato un palaoan mañuñule un alabastro na boteyan inggüenten puro nardo, na gosguaguan; ya mafag y boteya, ya jachuda gui jilo y ilon Jesus. ");
INSERT INTO cha_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ya guaja sija ninafanbubo sanjalomñija, ya ilegñija: Jafa este na inggüente na manalalastimaja? ");
INSERT INTO cha_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Maulegña umabende pot tresientos peseta, ya ufanmanae y mamobble: ya malalatde y palaoan. ");
INSERT INTO cha_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lao si Jesus ilegña: Pologüe namaesa. Jafaja na inatbororota güe? Mauleg finatinasña nu guajo. ");
INSERT INTO cha_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sa manjajamyoja yan y mamobble siempre; ya ngaeanja nae manmalago jamyo, infatinasja mauleg guiya sija: lao guajo ti tafanjijitaja siempre. ");
INSERT INTO cha_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Güiya jafatinas taemanoja y ninasiñaña: güiya mato antes, para uinggüentiye y tataotaojo, para y naftan. ");
INSERT INTO cha_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Magajet jusangane jamyo: Manoja este na ebangelio nae mapredica, gui todo y tano, este locue y finatinasña umasangan, para memoriasña. ");
INSERT INTO cha_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ya si Judas Iscariote, uno gui dose, mapos malag y magas mamale, para umentrega güe guiya sija. ");
INSERT INTO cha_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ya anae majungog, ninafansenmagof, ya mapromete manae güe salape. Ya jaaliligao jaftaemano para uinentrega. ");
INSERT INTO cha_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ya y finenana na jaane y taelibadura na pan, anae maofrese y pascua, y disipuluña ilegñija nu güiya; Manojam malagomo guato ya infamauleg nae para unchocho gui pascua? ");
INSERT INTO cha_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ya jatago y dos gui disipuluña, ya ilegña nu sija: Janao fanmalag y siuda, sa infanasoda güije yan un taotao na mangangatga un jarran janom: dalalag güe. ");
INSERT INTO cha_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ya amanoja nae jumalom, alog ni y taotao guma: Y Maestro, ilegña: Mangue y aposento ni y anae para infañocho gui pascua yan y disipulujo? ");
INSERT INTO cha_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ya güiya infanfinanue un dangculo na cuatto; esta mafamauleg yan listo; ayo nae famauleg para jita. ");
INSERT INTO cha_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ya y disipuluña sija manmapos, ya manmato gui siuda, ya jasoda jaftaemano y mansinangane sija: ya mafamauleg para y pascua. ");
INSERT INTO cha_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ya y pupuenge mato yan y dose. ");
INSERT INTO cha_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ya anae manmatatachong ya mañochocho, si Jesus ilegña: Magajet jusangane jamyo: Uno guiya jamyo umentregayo; güiyaja uchumocho yan guajo. ");
INSERT INTO cha_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ayo nae ninafangostriste, ya ilegñija nu güiya uno yan otro: Guajo? y otro ilegña: Guajo? ");
INSERT INTO cha_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ayo nae manope ilegña nu sija: Uno gui dose ni y jumajame manotche gui tason. ");
INSERT INTO cha_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Y Lajin taotao magajet na mapos, ni y esta matugue pot güiya: lao namaase ayo na taotao ni y jaentrega y Lajin taotao. Maulegña ayo na taotao na ti umafañago. ");
INSERT INTO cha_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ya anae mañochocho, jachule si Jesus y pan, ya jabendise, ya jaipe, ya janae sija, ilegña: Chile ya incano, sa este y tataotaojo. ");
INSERT INTO cha_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ya jachule y posuelo, ya anae munjayan janae grasia, janae sija: ya todos manguimen. ");
INSERT INTO cha_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ya ilegña nu sija: Este y jâgâjo, gui nuebo na testamento, ni machuda pot y megae. ");
INSERT INTO cha_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Magajet jusangane jamyo, na ti juguimen talo ni y tinegcha ubas, asta ayo na jaane, na juguimen nuebo gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ya anae munjayan macanta un himno, manmapos manmalag y finabeca Olibo. ");
INSERT INTO cha_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ya si Jesus ilegña nu sija: Todos jamyo infaninefende pot guajo; sa esta matugue: Bae jupanag y pastot, ya y quinilo sija ufanmachalapon. ");
INSERT INTO cha_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lao despues di lâlâyo talo, ya cumajuloyo, jujanao esta y menanmiyo guiya Galilea. ");
INSERT INTO cha_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ayo nae si Pedro ilegña: Achogja todos maninefende; lao guajo aje. ");
INSERT INTO cha_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ya sinangane as Jesus ilegña: Magajet jusanganejao na jago pagoja na puenge, antes qui uoo dos biaje y gayo, unpuneyo tres biaje. ");
INSERT INTO cha_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lao guiya janaguefchadeg y cuentosña, ilegña: Yanguin jumitamatae, ti jupunejao ni jaftaemano. Taegüineja locue sinanganñija todos. ");
INSERT INTO cha_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ya manmato un lugat na y naaña Gethsemane: ya ilegña ni y disipuluña sija: Fanmatatachong güine, mientras mananaetaeyo. ");
INSERT INTO cha_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ya jacone gachongña si Pedro, yan si Santiago, yan si Juan, ya jatutujon manmajalang, yan mangostriste, ");
INSERT INTO cha_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ya ilegña nu sija: Y antijo sentriste asta qui jumatae; fañaga güine, ya iafanmamulan. ");
INSERT INTO cha_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ya jumanao mona didide, dumimo papa gui jilo oda, ya manaetae, na yanguin siña, ufalofan y ora guiya güiya. ");
INSERT INTO cha_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ya ilegña: Abba, Tata: todo y güinaja mansiña para jago; nasuja este y posuelo guiya guajo: lao ti taemanoja minalagojo, na y minalagomo. ");
INSERT INTO cha_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ya mato talo guato ya jasoda sija manmaego, ya ilegña as Pedro: Simon mamaegojao? ti siñajao bumela un oraja? ");
INSERT INTO cha_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Fanbela, yan infanmanaetae; para chamiyo fanjajalom gui tentasion: Y Espiritu magajet na malago; lao y catne echecho. ");
INSERT INTO cha_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ya jumanao talo ya manaetae ya ayoja mismo na sinangan. ");
INSERT INTO cha_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ya anae tumalo guato jasoda talo sija na manmamaego: sa y atadogñija mangosmacat, ya ti ujatungo jafa umaope güe. ");
INSERT INTO cha_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ya mato talo gui mina tres biaje, ya ilegña nu sija: Fanmaego pago, ya infandescansa: esta najong; y ora esta mato; lie y Lajin taotao na maentrega gui canae y manisao sija. ");
INSERT INTO cha_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fangajulo ya nije tafanjanao; sa esta y umentregayo jijot. ");
INSERT INTO cha_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ya enseguidas, mientras cumuecuentos, mato si Judas, uno gui dose, ya mañisija yan un linajyan taotao, manmañuñule espada, yan galute guinen y magas mamale, yan y escriba, yan y manamco sija. ");
INSERT INTO cha_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ya ayo y umentrega güe, mannae señat, ilegña: Jaye y juchico, güiya ayo: guiot ya inquene na seguro. ");
INSERT INTO cha_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ya enseguidas nae matogüe, jumajanaoja guato guiya güiya, ya ilegña: Maestro; ya jachico. ");
INSERT INTO cha_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ya ayonae mapolo canae sija gui jiloña ya macone. ");
INSERT INTO cha_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ya uno guiya sija ni y tumotojgue gui oriya, jalagnos y espadaña, ya jataga y tentago y magas mamale, ya jautut talangaña. ");
INSERT INTO cha_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ya manope si Jesus ilegña nu sija: Ada manmato jamyo calang contra y saque, na manmañuñule jamyo espada, yan galute para inguiotyo? ");
INSERT INTO cha_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Guinen manjijitaja todo y jaane gui templo manmamananagüe, ya ti inquequeneyo? lao mafatinas este para umacumple y tinigue. ");
INSERT INTO cha_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ya madingo, ya manmalago todos. ");
INSERT INTO cha_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ya dinalalaggüe un patgon na taotao, na jatatampe güe un sábanas, sa taya magagago: ya y mamatgon sija na taotao, maguot güe. ");
INSERT INTO cha_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lao güiya japolo y sábanas, ya malago sin magago. ");
INSERT INTO cha_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ya macone si Jesus para y magas na pale: ya mandaña y manmagas mamale yan y manamco, yan y escriba sija. ");
INSERT INTO cha_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ya si Pedro dinalalag güe, lao chago, asta gui sanjalom, sanjalom y palasyon y magas na pale: ya matachong yan y tentago sija, ya janama maope güe gui guafe. ");
INSERT INTO cha_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ya y magas mamale, yan todo y inetnon ofisiat, manmanaliligao testimonio contra si Jesus para umapuno; lao taya masoda. ");
INSERT INTO cha_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sa megae manmannae ti manmagajet na testimonio contra güiya: lao y testimonioñija ti manparejo. ");
INSERT INTO cha_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ya mangajulo palo ni manmannae contra güiya y testimonio na ti manmagajet, ilegñija: ");
INSERT INTO cha_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Injingog y ilegña: Juyulang este na templo, ni y mafatinas nu canae, ya y tres na jaane, janacajulo talo otro na ti finatinas canae. ");
INSERT INTO cha_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lao este na testimonioñija, locue ti manparejo. ");
INSERT INTO cha_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ya y magas na pale tumojgue julo gui talolo, ya jafaesen si Jesus ilegña: Ti unfanope ni jafa? Jafa este sija na testimonioñija contra jago? ");
INSERT INTO cha_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lao mamatquiquiloja, taya inepeña. Tumalo y magas na pale finaesen ilegña: Jago si Jesucristo Lajin y Bendito? ");
INSERT INTO cha_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ya si Jesus ilegña: Guajo; ya umamaela y tiempo anae inlie y Lajin taotao matatachong gui agapa y gaeninasiña na canae, ya umamaela gui jalom y mapagajes y langet. ");
INSERT INTO cha_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ayonae y magas na pale, jatiteg y magaguña, ya ilegña: Para jafajit palo testigo sija? ");
INSERT INTO cha_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Injingogja y chinatfinoña contra si Yuus: Jafa jinasonmimiyo? Ya todos manmañentensia para umapuno. ");
INSERT INTO cha_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ya y palo matutujon matolae, yan matatampe mataña, yan mapatmada, ya ilegñija nu güiya: Profetisa: ya y ofisiat sija rumesibe güe ya japatmada ni y canaeñija. ");
INSERT INTO cha_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ya anae si Pedro gaegue gue sanpapa gui palasyo, mato un palaoan tentago y magas na pale: ");
INSERT INTO cha_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ya anae jalie si Pedro na janamamaepe güe, jaatan ya ilegña: Jago locue manjajamyo yan si Jesus Nasareno? ");
INSERT INTO cha_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lao jadague ilegña: Ti jutungo, ni jutungo jafa ilelegmo. Ya mapos juyong gui cajida; ya umoo y gayo. ");
INSERT INTO cha_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ya linie talo ni y palaoan, ya jatutujon sumangane ayo sija y manotojgue gui oriyaña: Este uno guiya sija. ");
INSERT INTO cha_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ya jadague talo. Ti apmam ayo y manotojgue gui oriya ilegñija as Pedro: Magajet na jago uno guiya sija? sa jago taotao Galileajao. ");
INSERT INTO cha_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lao jatutujon mamatdise yan manjula ya ilegña: Ti jutungo este na taotao y insasangan. ");
INSERT INTO cha_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ya enseguidas y mina dos biaje umoo y gayo. Jajaso si Pedro y sinangan, jaftaemano si Jesus nu güiya ilegña: Antes que uoo y gayo dos biaje, undagueyo tres biaje. Ya anae jajaso, tumanges. ");
INSERT INTO cha_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","YA enseguidas y egaan güije, y magas mamale yan y manamco, yan y escriba sija, yan todo y inetnon ofisiat manaconseja entaloñija, ya magode si Jesus, ya macone, ya maentrega si Pilato. ");
INSERT INTO cha_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ya finaesen as Pilato, ilegña nu güiya: Jago y Ray Judios? Ya manope ilegña: Jago sumangan. ");
INSERT INTO cha_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ya mafaaela ni y magas mamale, megae sija na güinaja. ");
INSERT INTO cha_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ya finaesen güe talo as Pilato, ilegña: Ti unfanope ni jafa? liija na minegae finaela contra jago. ");
INSERT INTO cha_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lao si Jesus ti manope ni jafa; ayo mina ninamanman si Pilato. ");
INSERT INTO cha_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ya ayo na gupot, y costumbre masosotta un preso, yanguin jagagao jaye y malagoñija. ");
INSERT INTO cha_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ya guaja güije uno, y naanña si Barabas, na mapreso yan y mangachongña gui un jatsamiento; sija manmamuno anae mangajulo gui jatsamiento. ");
INSERT INTO cha_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ya y linajyan taotao manmato jijot, ya jatutujon manmangaogao na ufatinas taegüije y guinen jafatinas guiya sija, ");
INSERT INTO cha_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Lao si Pilato manope sija, ilegña: Manmalago jamyo na jusottaye jamyo y Ray Judios? ");
INSERT INTO cha_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sa jatungo, na ayo na maentrega ni y magas mamale, pot y embidia. ");
INSERT INTO cha_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lao y magas mamale jatago y taotao sija, na ujagagao na si Barabas umasotta. ");
INSERT INTO cha_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ya si Pilato manope ilegña talo nu sija: Jafanae malagomiyo jufatinas ayo y infananaan Ray Judios? ");
INSERT INTO cha_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ya managang talo ilegñija: Atane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ayonae si Pilato, ilegña nu sija: Jafa na taelaye finatinasña? Ya mas managang, ilegñija: Atane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ya si Pilato, malago na ufanmagof y taotao sija, jasottaye sija si Barabas, ya maentrega si Jesus, anae munjayan masaulag, para umaatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ya maosgaejon ni y sendalo sija, guato gui patio mafanaan Pretorio; ya madaña todo y mangachong. ");
INSERT INTO cha_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ya manaminagago púrpura, ya matufog un coronan tituca. ");
INSERT INTO cha_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ya matutujon masaluda, ilegñija: Jafa tatatmanojao Ray Judios! ");
INSERT INTO cha_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ya mapanag y iluña ni y piao, ya matolae güe, yan mandidimo, ya maadodora güe. ");
INSERT INTO cha_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ya anae munjayan mamofeagüe, manajanao y púrpura, ya manaminagago ni y magaguñaja. Ya macone güe para umaatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ya manacatga uno ni y malolofan para ufañija, si Simon Sirineo, tatan Alejandro yan Rufo, na mato guinen y fangualuan, para uquinatgaye ni y quiluus Jesus. ");
INSERT INTO cha_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ya macone guato gui un lugat na y naanña Golgota: cumequeilegña, Sagan calabera. ");
INSERT INTO cha_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ya manae guimenña, bino manadaña yan mira, lao ti jaresibe. ");
INSERT INTO cha_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ya maatane güe gui quiluus, manafacae ni magaguña; ya manrifa jaye uchinile cada uno. ");
INSERT INTO cha_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ya y mina tres na ora, anae maatane güe gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ya y tinigue y fumaaelagüe, matugue gui sanjilo. Y RAY JUDIOS. ");
INSERT INTO cha_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ya maatane dos na saque yan güiya: y uno gui agapaña, ya y otro gui acagüeña. ");
INSERT INTO cha_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Ya macumple y tinigue ni y ilegña: Güiya, usaouao matufong yan y manisao.) ");
INSERT INTO cha_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ya macacase todo ni y manmalolofan, ya jayeyengyong y ilonñija, ya ilegñija: Ay! jago ni y unyulang y templo, ya unjatsa talo gui mina tres na jaane; ");
INSERT INTO cha_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Satba maesajao, ya maela tunog papa güenao gui quiluus. ");
INSERT INTO cha_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Taegüenaoja locue y magas mamale, manmanbotlelea gui entaloñija, ya ilegñija yan y escriba sija: Jasatba y palo, ya güiya na maesa ti siña güe jasatba. ");
INSERT INTO cha_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si Cristo y Ray Israel, polo ya utunog pago gui quiluus, para utafanlie, ya utafanjonggue güe. Yan ayo y mangachochongña manmaatane gui quiluus madespresia güe. ");
INSERT INTO cha_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ya anae mato y mina saes na ora, jomjom todo y tano asta y mina nuebe na ora. ");
INSERT INTO cha_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ya y mina nuebe na ora, janagosagang si Jesus ilegña: Eli, Eli, lama sabactani? cumequeilegña: Yuusso, Yuusso, jafa muna undingoyo? ");
INSERT INTO cha_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ya palo ni y manotojgue gui oriyaña, anae majungog güe, ilegñija: Estagüe na jaaagang si Elias. ");
INSERT INTO cha_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ya malago uno, ya jasupog y espongja gui binagle, ya japolo gui puntan y piao, ya janae para uguimen, ya ilegña: Poloja güe namaesa; ya utafanlie cao ufato si Elias, ya uninatunog. ");
INSERT INTO cha_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ya si Jesus umagang goságang, ya jaentrega y espiritu. ");
INSERT INTO cha_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ya y cottinan y templo, masisen dos pedaso, y sanjilo asta y sanpapa. ");
INSERT INTO cha_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ya anae y senturion ni y tumotojgue gui menaña, linie, na taegüenao jaentrega y espiritu, ilegña: Magajet na este na taotao Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ya mangaegue locue sija famalaoan, na maaatan gui chago, ya entre sija estaba si Maria Magdalena, yan si Maria nanan Santiago y patgon, yan si José, yan si Salome; ");
INSERT INTO cha_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ni y anae estaba güe guiya Galilea, madalalag güe, ya masetbe güe; yan megae sija na famalaoan mangachochongña julo guiya Jerusalem. ");
INSERT INTO cha_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ya anae estaba pupuenge, sa ayo na jaane y Preparasion, cumequeilegña y jaane antes di y sábado, ");
INSERT INTO cha_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mato si José, taotao Arimatea, mauleg na taotao na pápagat, ni y jananangga locue y raenon Yuus; ya mapos yan atrebe malag as Pilato, ya jagagao y tataotao Jesus. ");
INSERT INTO cha_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ya ninamanman si Pilato, cao esta matae; ya jaagang y senturion, ya jafaesen cao esta matae algun tiempo. ");
INSERT INTO cha_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ya anae jatungo gui senturion; janae si José ni y tataotao. ");
INSERT INTO cha_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ya güiya mamajan fino na magagao; ya janatunog y tataotaoña ya jabalutan ni y fino na magago, ya japolo gui un naftan ni maguadog gui acho, ya janagaliligue guato un acho, gui pettan y naftan. ");
INSERT INTO cha_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ya si Maria Magdalena, yan si Maria nanan José, jalie amano nae mapolo. ");
INSERT INTO cha_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","YA anae esta malofan y sabado, si Maria Magdalena, yan si Maria nanan Santiago, yan si Salome, manmamajan paopao, para ufato ya umapalalae güe. ");
INSERT INTO cha_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ya taftataf gui egaan, gui finenana na jaane gui semana, manmato gui naftan gui quinajulo y atdao. ");
INSERT INTO cha_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ya ilegñija entre sija: Jaye uninagalileg y acho gui pettan y naftan? ");
INSERT INTO cha_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ya anae maaatan, malie na esta managalileg y acho, sa gosdangculo. ");
INSERT INTO cha_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ya manjalom gui naftan, malie un patgon na taotao, na matatachong gui agapa na banda, minagagon apaca na anaco; ya ninafangosmaañao. ");
INSERT INTO cha_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ya ilegña nu sija: Chamiyo fanmaaañao: inaliligao si Jesus Nasareno, ni y maatane gui quiluus: esta cajulo; taegüe güine; liija y lugat anae mapopolo güe. ");
INSERT INTO cha_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Janao infanjanao, ya insangane y disipuluña, yan si Pedro: Güiya jumanao gui menanmiyo guiya Galilea; ayo nae inlie güe, ni y guinin mansinangane jamyo. ");
INSERT INTO cha_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ya manmapos juyong, ya manmalago gui naftan, sa jumuyong manlalaolao yan manmanman; ya ti ufanmanangane jafa ni y taotao; sa mangosmanmaañao. ");
INSERT INTO cha_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Lao anae cajulo si Jesus, taftataf gui egaan gui finenana na jaane gui semana, umalie finena, yan Maria Magdalena, ni y guinin janajuyong siete na anite. ");
INSERT INTO cha_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ya mapos güe, ya jasangane ayo y guinin mangachochongña, ni y mantriste, yan manatanges. ");
INSERT INTO cha_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ya sija, anae jajungog na esta lâlâ ya umalie yan Mana, ti majonggue. ");
INSERT INTO cha_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ya anae manmalofan estesija, manmalie talo yan dos, lao otro jechuraña; gui anae manjajanao gui fangualuan. ");
INSERT INTO cha_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ya manmapos, ya manmasangane y palo disipulo: lao ti majonggue. ");
INSERT INTO cha_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Despues di ayo, manmalie yan y onse gui anae mañochocho, ya jalalatde ni y ti manjengguenñija, yan y majetog corasonñija, sa ti majonggue ayo sija y lumie güe despues di cumajulo. ");
INSERT INTO cha_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ya ilegña nu sija; Janao fanmalag todo y tano, ya predica y ibangelio todo y ninajuyong sija. ");
INSERT INTO cha_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jaye y manjonggue ya matagpange, usatba; lao ayo y ti manjonggue; umasentensia. ");
INSERT INTO cha_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ya este sija na señat ufantinattitiye ayo sija y manmanjonggue: Pot y naanjo ujayute juyong y anite sija; ufanguentos ni y nuebo na finijo; ");
INSERT INTO cha_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ufanmangajat culebla sija, ya, yanguin manguimen jafa na beneno; ti uninafanlamen: ya ujapolo y canaeñija gui manmalango sija, ya ujanafanjomlo. ");
INSERT INTO cha_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Enao y Señot, despues di mansinangane sija, rinisibe ni y langet, ya matachong gui agapa Yuus. ");
INSERT INTO cha_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ya manmapos, ya mapredica y sinangan gui todo y lugat, mañisija manmachocho yan y Señot, ya manafitme y sinangan ni y umatitiye na señat. Amen. ");
INSERT INTO cha_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","POT y guaja megae y umapolo y canaeñija para ufannaregla y cuentos nu y ayo na güinaja na esta guefmaasegura gui entalo jame, ");
INSERT INTO cha_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jaftaemanoja ninaejam ni guine y tutujoña y testigojam ni y malie, nu y yan y ministrojam y sinangan; ");
INSERT INTO cha_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y jinasoco mauleg locue nu guajo, sa juguefegaga sinengcabales todo y güinaja guine y tutujonña, na jutuguie jao pot y inaregla, jago guesmagas na Teofilo; ");
INSERT INTO cha_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Para untungo sija y magajet ayosija mano nae unresibe y finanagüe. ");
INSERT INTO cha_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Guaja gui jaanin Herodes, ray guiya Judea, un pale, naanña si Sacharias, y clasen Abias; y asaguaña guinin sija jagan Aaron ya y naaña si Elisabet. ");
INSERT INTO cha_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Este na dos mauleg gui sanmenan Yuus, jajananao gui todo y lay yan y tinago Señot, ti lalatdiyon. ");
INSERT INTO cha_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ya taya patgonñija; sa si Elisabet tifáfañago; yan y dos megae jaaniñija. ");
INSERT INTO cha_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ya jumuyong, anae mañeñetbe si Sacharias, gui ofisio y pale gui menan Yuus, gui chechon y clasiña, ");
INSERT INTO cha_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jaftaemanoja y costumbren y ofisio y pale, y chechoña na jumalom gui guimayuus ya jasonggue y paopao. ");
INSERT INTO cha_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ya todo y linajyan taotao mangaegue gui sanjiyong manmananaetae gui oran paopao. ");
INSERT INTO cha_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ya mato guiya güiya y angjet y Señot, na gaegue gui agapa y attat y paopao. ");
INSERT INTO cha_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ya inestotba si Sacharias anae jalie, ya mato minaañao gui jiloña. ");
INSERT INTO cha_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lao y angjet ilegña nu güiya: Sacharias, chamo maaañao; sa y tinaetaemo este majungog; ya y asaguamo as Elisabet ufañago y patgon laje, ya umafanaan naanña si Juan. ");
INSERT INTO cha_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ya uguaja jao minagof yan alegria; ya y megae umagof nu y mafañaguña. ");
INSERT INTO cha_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sa udangculo güe gui menan Señot; ya ti uguimen bino ni metgot na guinem ya ubulagüe Espiritu Santo, guinin y tiyan nanaña. ");
INSERT INTO cha_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ya megae gui famaguon Israel, ujabira nu y Señot, Yuusñija. ");
INSERT INTO cha_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ya ujanaogüe gui menan y mataña nu y espiritu yan y ninasiñan Elias, para unanalo y corasonñija y mañaena guiya y famaguon, yan y manchátmatago ni y tiningo y manunas; para ufamauleg nu y Señot y taotao, ni y esta fanmauleg para güiya. ");
INSERT INTO cha_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ya ilegña si Sacharias nu y angjet: Jaftaemano jutungo este? sa guajo bijoyo ya y asaguajo megae jaaniña. ");
INSERT INTO cha_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ya manope y angjet ya ilegña nu güiya: Guajo si Gabriel, na gaegue yo tumotojgue gui menan Yuus; ya guajo esta matago na jucuentusejao, ya junaejao ni este mauleg na sinangan. ");
INSERT INTO cha_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ya estagüe, na jago udojao ya ti siña uncuentos, asta y jaane nae este macumple estesija; sa y ti unjongue y sinanganjo, ni umacumple y tiempoña. ");
INSERT INTO cha_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ya y taotao sija manmannanangga as Sacharias, ya ninafanmanman ni y inapmamña gui guimayuus. ");
INSERT INTO cha_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ya anae jumuyong, ti siña umadingane sija; ya matungo na manlie un linie gui guimayuus; lao güiya sigue di fumatinas y señatja; ya sumaga udo. ");
INSERT INTO cha_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ya anae esta munjayan y jaanin y ministroña, jumanao para y guimaña. ");
INSERT INTO cha_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ya despues di ayo sija na jaane mapotgue y asaguaña as Elisabet, ya janana sinco na meses, ya ilegña: ");
INSERT INTO cha_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Taemanoja y Señot jafatinas para guajo, este sija na jaane nae jaatanyo para unajanao y mamajlaojo gui entalo taotao sija. ");
INSERT INTO cha_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Y mina saes na mes, y angjet Gabriel esta tumago guine as Yuus, para un siuda guiya Galilea, ni y naanña y Nasaret, ");
INSERT INTO cha_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Guiya un bitgen, nobia y un laje naanña si José, familian David; ya y naan y bitgen si Maria. ");
INSERT INTO cha_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ya jumalom manu nae estaba güe, ya ilegña: Jafa tatatmana jao na guefmaborese jao; y Señot gaegue guiya ");
INSERT INTO cha_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Lao pot este na sinangan, ninaestotba güe, ya jajajaso na jaftaemano este na sinaluda. ");
INSERT INTO cha_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Entonses y angjet ilegña nu güiya: Maria, chamo maaañao; sa unsoda y finaborese gui menan Yuus. ");
INSERT INTO cha_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ya estagüe, na unmapotgue gui tiyanmo ya unfañago un patgon laje, ya umafanaan y naaaña si Jesus. ");
INSERT INTO cha_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ya udangculo güe, ya umafanaan Lajin Gueftaquilo: ya y Señot Yuus ufannae güe y tronon David tataña. ");
INSERT INTO cha_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ya ugobietna gui guima Jacob siesiempreja; ya y raenoña ugagaegue taejinecog. ");
INSERT INTO cha_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Entonses si Maria ilegña ni y angjet: Jafa jumuyong este? sa ti jutungo laje. ");
INSERT INTO cha_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ya manope y angjet, ya ilegña nu güiya: Y Espiritu Santo umamaela guiya jago, ya y ninasiña y Gueftaquilo jafatinas y anineng gui jilomo; enaomina ayo na Santos na umafañago, umafanaan Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ya, estagüe, si Elisabet, parentesmo, locue güiya mapotgue un laje gui inamcoña; ya este y mina saes na mes nu güiya na mafanaan tifáfañago. ");
INSERT INTO cha_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sa y sinangan Yuus, taya uno na taeninasiña. ");
INSERT INTO cha_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Entonses si Maria ilegña: Estagüe y tentagon Señot; ufatinas guiya guajo taemanoja y sinanganmo. Ya y angjet mapos guiya güiya. ");
INSERT INTO cha_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ya ayo na jaane sija, cajulo si Maria ya jumanao gusise para un tano taquilo, guiya un siudan Juda; ");
INSERT INTO cha_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ya jumalom gui guima Sacharias ya jasaluda si Elisabet. ");
INSERT INTO cha_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ya jumuyong taegüije na anae jajungog si Elisabet y sinaludan Maria, y patgon tumayog gui jalom tiyanña; si Elisabet bula Espiritu Santo, ");
INSERT INTO cha_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ya umagang ni dangculo na inagang ya ilegña: Dichosojao gui entalo y famalaoan, ya dichoso y tinegchan tiyanmo. ");
INSERT INTO cha_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ya guine manu este guiya guajo, na mato guiya guajo y nanan y Señotto. ");
INSERT INTO cha_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sa estagüe, na anae mato y inagang y sinaludamo gui talangajo, y patgon, gui jalom tiyanjo, tumayog ni minagofña. ");
INSERT INTO cha_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ya dichosogüe y jumonggue; sa uguaja y quinimple gui güinaja, ni esta masangane güe ni guinin y Señot. ");
INSERT INTO cha_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Entonses ilegña si Maria: Janadangculo y antijo y Señot, ");
INSERT INTO cha_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ya y espiritujo ninamagof gui as Yuus y Satbadotto. ");
INSERT INTO cha_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sa jaatan y dinespresiaoña y tentgoña; sa estagüe na desde pago jumafanaan dichosa ni todo y generasion. ");
INSERT INTO cha_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sa ayo na guaja ninasiña, jafatinas guiya guajo dangculo na güinaja; ya santos y naanña. ");
INSERT INTO cha_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ya y minaaseña gaegue gui generasion taotao sija, gui jiloñija ni manmaañao nu güiya. ");
INSERT INTO cha_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ya pot y canaeña jafanue minetgot; janafañuja y sobetbio sija gui jinason y corasonñija. ");
INSERT INTO cha_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ya jayute papa y magas gui tronoñija, ya jajatsa y manumitde. ");
INSERT INTO cha_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ya y manñalang janafanbula ni y minauleg; ya y manmigüinaja janafanjanao yan y tae sinajguan. ");
INSERT INTO cha_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ya jaayuda si Israel tentagoña, para ufanjaso y miñaase, ");
INSERT INTO cha_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Taemano y jasangane y mañaenata), as Abraham yan y semiyaña para todo y tiempo. ");
INSERT INTO cha_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Si Maria sumaga yan güiya calang tres meses ya despues jumanao asto iyasija. ");
INSERT INTO cha_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ya si Elisabet jacumple y tiempo nae para ufañago; ya mañago un patgon laje. ");
INSERT INTO cha_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ya anae majungog ni tiguangña yan y parientesña, na si Yuus janadangculo y minaaseña guiya güiya; ya manmagof yan güiya. ");
INSERT INTO cha_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ya susede na y mina ocho na jaane manmato para umasircunsida y patgon: ya malagoñija umafanaan ni y naan tataña as Sacharias. ");
INSERT INTO cha_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ya manope y nanaña ya ilegña: Aje, sa umafanaan si Juan. ");
INSERT INTO cha_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ya ilegñija nu güiya: Taya gui manparientesmo mafanaan nu este na naan. ");
INSERT INTO cha_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ya maseñat y tataña, ya mafaesen jafa malagoña umafanaan. ");
INSERT INTO cha_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ya mangagao un diquique na tabla ya jatugue ilegña: Si Juan naanña. Ya todo sija ninafanmanman. ");
INSERT INTO cha_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ya enseguidas mababa y pachotña, ya mapula y jilaña, ya cumuentos, jabendise si Yuus. ");
INSERT INTO cha_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ya guaja minaañao gui jiloñija todo y mañasaga gui oriyañija: ya gui todo y tano taquilo guiya Judea, masasangan este sija na sinangan. ");
INSERT INTO cha_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ya todosija y jumujungog jaadaje gui corasonñija ya ilegñija: Jafa jumuyong este na patgon? Sa y canae Yuus gaegue guiya güiya. ");
INSERT INTO cha_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ya si Sacharias, tataña, bula Espiritu Santo ya japrofetisa, ilegña: ");
INSERT INTO cha_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Bendito y Señot, y Yuus y Israel; sa jabisita ya jafatinas y redension, para taotaoña, ");
INSERT INTO cha_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ya janacajulo para jita un canggelon y satbasion, gui guima y tentagoña as David, ");
INSERT INTO cha_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Taegüijija na jasasangan gui pachot y mañantos na profetaña, ni esta gaegue guinin tutujonña y tano), ");
INSERT INTO cha_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Satbasion gui y enemiguta yan gui canae todo y chumatliijit; ");
INSERT INTO cha_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Para umafanue y minaaseña gui mañaenata, ya umajaso y santos na tratoña; ");
INSERT INTO cha_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Y juramento ni manjula as Abraham ni tatata, ");
INSERT INTO cha_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Na güiya unaejit linibreta gui canae y enemiguta ya utasetbe güe sin minaañao, ");
INSERT INTO cha_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Y sinantos yan y tinunas gui menaña todo y jaanita. ");
INSERT INTO cha_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ya, jago, patgon, unmafanaan profetan y Gueftaquilo; sa unjanao gui menan y Señot para unfamauleg y chalanña; ");
INSERT INTO cha_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Para ufanamatungo y satbasion gui taotaoña ni y maasiin y isaoñija, ");
INSERT INTO cha_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Pot causa y corason y minaaseña y Yuusta, anae y candit ogaan guinin taquilo, jabisitajit, ");
INSERT INTO cha_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Para junae inina y manmatatachong gui jemjom yan y anineng y finatae; para ufanue y patasta gui chalan y pas. ");
INSERT INTO cha_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ya y patgon lumala ya mumetgot gui espiritu ya sumaga gui desierto asta y jaane anae esta matungo guiya Israel. ");
INSERT INTO cha_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","YA susede na ayo sija na jaane, jumuyong un bando guinen as Augusto Sesat, para todo y tano na mataotagüe, na y naanñija ufanmatugue gui padron. ");
INSERT INTO cha_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Este finenana na padron esta fumatinas, anae si Sirenio y magalaje guiya Siria. ");
INSERT INTO cha_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ya manjanao todo y taotao para ninatugue y naanñija gui padron, cada uno gui siudaña. ");
INSERT INTO cha_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ya jumanao si José guinin Galilea, guinin un siuda na naanña Nasaret, para ufalag Judea, gui siudan David, na mafanaan Betlehem, sa güiya y guima y familian David; ");
INSERT INTO cha_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Para ufanmatugue gui padron yan si Maria, asaguaña umacamo yan güiya, anae estaba dangculo sa mapotgue, ");
INSERT INTO cha_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ya susede, anae gaegue sija güije, y jaaniña ni para ufañago esta macumple; ");
INSERT INTO cha_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ya mañago un laje finenana na patgon; ya mabalutan ni y pañales, ya manaason qui cajon sacate; sa taya sagañija gui guima. ");
INSERT INTO cha_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ya guaja pastot sija güije na tano, na mañaga gui fangualuan, ya jaadadaje y manadan quinilo gui puenge. ");
INSERT INTO cha_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ya estagüe y angjet y señot tumotojgue guiya sija; y minalag Yuus jaina gui oriyañija; ya guaja dangculo na minaañao. ");
INSERT INTO cha_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lao y angjet ilegña nu sija: Chamiyo fanmaañao; sa, estagüe, na juchule para jamyo mauleg na sinangan dangculo na minagof, para todo y taotao: ");
INSERT INTO cha_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sa esta mafañago para jamyo gui siudan David, pago na jaane, un Satbadot, na güiya si Cristo, y Señot. ");
INSERT INTO cha_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ya este y señatmiyo: Inseda y patgon mabalutan ni y pañales, ya umaason gui cajon sacate. ");
INSERT INTO cha_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ya enseguidas anog yan y angjet y linajyan y sendalo gui langet, na manmantutuna as Yuus, ya ilegñija: ");
INSERT INTO cha_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Minalag gui y Gueftaquilo as Yuus, ya y tano pas gui entalo taotao ni y minagofña dangculo. ");
INSERT INTO cha_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ya jumuyong anae y angjet sija manmamapos guiya sija para y langet, y pastot sija manasangane. uno yan otro: Nije tafanmalag pues, asta Betlehem, ya talie este na güinaja ni esta jumuyong, na si Yuus jafanuejit. ");
INSERT INTO cha_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ya manmato chadeg, ya jasoda si Maria yan José, yan y diquique na patgon umaason gui cajon sacate. ");
INSERT INTO cha_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ya anae esta malie, janatungo y sinangan na mansinangane sija nu y diquique na patgon. ");
INSERT INTO cha_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ya todo y manmanjungog, ninafanmanman pot y pastot sija, ni y sinanganñija. ");
INSERT INTO cha_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lao si Maria jananana todo este sija na sinangan, jajasosoye gui corasonña. ");
INSERT INTO cha_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ya manato guato y pastot sija yan manmagof ya matuna si Yuus pot todo y güinaja ni munjayan jajungog yan jalie, jaftaemano y esta jasangane sija. ");
INSERT INTO cha_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ya anae esta macumple y ocho na jaane, para umasirconsida güe mafanaan naanña si Jesus, taegüije y finanaan nu y angjet antes qui umamapotgueñaejon gui tiyan nanaña. ");
INSERT INTO cha_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ya anae esta macumple y jaanin y guinasgas, jaftaemanoja y lay Moises, sija macone güe guiya Jerusalem para umanae gui Señot. ");
INSERT INTO cha_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Jaftaemanoja y matuque gui lay y Señot: todo laje na jababa y tiyan, umafanaan santos para y Señot); ");
INSERT INTO cha_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ya para umanae inefrese jaftaemanoja y masangan y lay y Señot, un pares na tortola pat dos patgon na paluma. ");
INSERT INTO cha_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ya, estagüe, guaja un taotao guiya Jerusalem, na naanña si Simeon, ya este na taotao, cabales ya guefmanjonggue na jananangga y quinensuela y Israel: ya y Espiritu Santo gaegue gui jiloña. ");
INSERT INTO cha_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ya esta mafanue güe nu y Espiritu Santo, na ti ulie finatae, antes na ulie Cristo, y Señot. ");
INSERT INTO cha_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ya mato güe pot y Espiritu gui templo, ya anae machule, nu si tataña, y patgon Jesus gui templo para umafatinas pot guiya, taemanoja y costumbren y lay, ");
INSERT INTO cha_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ayo nae güiya jajogue gui canaeña ya jabendise si Yuus ya ilegña: ");
INSERT INTO cha_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Pago polo, Señot, y tentagomo ya jumanao yan pas, taemanoja y sinanganmo. ");
INSERT INTO cha_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sa jalie y matajo y satbasionmo, ");
INSERT INTO cha_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ni esta unfamauleg gui menan todo y taotao; ");
INSERT INTO cha_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Y candit para ufanmatungo y nasion sija, yan y minalag para y taotaomo, Israel. ");
INSERT INTO cha_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ya si José yan y nanaña ninafanmanman nu ayo sija y jasasangan nu güiya; ");
INSERT INTO cha_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ya jabendise si Simeon ya ilegña ni nanaña as Maria: Estagüe na patgon esta mapolo para pinedong yan para ufanjinatsa y megae guiya Israel; yan para y señat ni y ninachatsaga, ");
INSERT INTO cha_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yan y jago locue, sa y antimo na umadotgan nu y espada, ya para jinasoñija y megae na corason nae umatungo. ");
INSERT INTO cha_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gaegue locue güije, si Ana y profeta palaoan, jagan Fanuel gui tribun Aser (na güiya guaja megae na jaaniña, yan sumaga yan y asaguaña siete años desde y binitgenña; ");
INSERT INTO cha_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ya bumiuda asta ochenta y cuatro años) ya ti jafapos gui templo, ya jaadodora si Yuus, puenge yan jaane nu y umayuyunat yan manaenaetae. ");
INSERT INTO cha_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ya este mato güijija na ora ya janae si Yuus maase, ya jacumuentuse pot güiya todo sija y manmannangga ni linibre guiya Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lao anae esta jacumple todo sija, taemanoja y gaegue gui lay y Señot, manalo guato Galilea gui siudañija guiya Nasaret. ");
INSERT INTO cha_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ya y patgon dumangculo yan ninamatatnga ya bulagüe tiningo: ya y grasian Yuus gaegue gui jiloña. ");
INSERT INTO cha_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ya manjajanao sija tataña todo y sacan asta Jerusalem gui guipot y pascua. ");
INSERT INTO cha_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ya anae guaja esta dose na años, sija mangajulo guiya Jerusalem taemanoja y costumbren y guipot. ");
INSERT INTO cha_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ya anae jocog y jaane sija, manalo sija, ya sumaga y patgon, Jesus, guiya Jerusalem taetiningo nu y tataña sija. ");
INSERT INTO cha_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ya jinasoñija na gaegue gui mangachongñija, ya un jaane na manjajanaoja; ya maaliligao güe gui entalo y parientesñija yan y manatungoñija. ");
INSERT INTO cha_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lao anae ti masoda güe, manalo guato Jerusalem maaliligao güe. ");
INSERT INTO cha_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ya susede anae esta malofan tres na jaane, inseda güe gui templo matatachong gui entalo y manfaye maecungog yan mafafaesen. ");
INSERT INTO cha_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ya todo sija y jumujungog ninafanmanman ni tiningoña yan y inepeña. ");
INSERT INTO cha_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ya anae malie manmajngan ya ilegña nu güiya si nanaña: Patgon, jafa na unfatinasjam taeguenao? Estagüe si tatamo yan guajo na inaliligao jao yan y pinitinmame! ");
INSERT INTO cha_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ayo nae ilegña nu sija: Pot jafa yo na inaliligao? Ti intingo na y checho y tatajo nesesita yo na fatinas? ");
INSERT INTO cha_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lao sija ti jatungo ayo na sinangan y mansinangane. ");
INSERT INTO cha_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ya tumunog yan sija ya manjanao. guato Nasaret ya mansinejeta sija. Ya si nanaña jaadaje este todo sija gui corasoña. ");
INSERT INTO cha_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ya si Jesus lumálamodong gui tiningoña yan y linecaña yan y grasia gui as Yuus yan y taotao sija. ");
INSERT INTO cha_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Y mina quinse na año gui tiempo anae si Tiberio Sesat jagobietna, ya si Ponsio Pilato, güiya magalaje guiya Judea; ya si Herodes, güiya magalaje tetrarca guiya Galilea; ya y cheluña as Felipe, güiya magalaje tetrarca guiya Iturea yan y ya tanon Traconite; ya si Lisanias, güiya magalaje tetrarca guiya Abilinia; ");
INSERT INTO cha_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ya y dangculo na mamale si Annas yan si Caefas, este na tiempo, mato y sinangan Yuus gui as Juan, lajin Sacharias, gui jalomtano. ");
INSERT INTO cha_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ya güiya mato gui todo y tano gui oriyan Jordan, jasesetmon y managpang en sinetsot para y maasiin isao. ");
INSERT INTO cha_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Taegüije esta matugue gui leblo ni y sinangan y profeta Isaias, na ilegña: Inagangña ni y umaagang gui jalomtano: Famauleg y chalan y Señot, y cayejonña natutunas. ");
INSERT INTO cha_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Todo y finacañada umanafanbula, yan todo y tano boca yan y manloca na ogso umanafanagpapa; yan y manechong umanafanunas, yan y chalan farangca unamafanyano. ");
INSERT INTO cha_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya todo y catne ulie y satbasion Yuus. ");
INSERT INTO cha_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Enaomina ilegña ni y linajyan taotao na manmato para ufanmatagpange pot güiya: Rasan culebla, jaye jamyo fumanagüe na insuaye y binibo ni y mamamaela? ");
INSERT INTO cha_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Chile tinegchanmiyo ni y magajet na sinetsot, ya chamiyo insigue di sumasangan nu jamyoja: Guaja tatanmame si Abraham; sa jusanganejamyo na siña, si Yuus güine gui acho janafangajulo y famaguon Abraham. ");
INSERT INTO cha_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ya pagoja y gachae gaegueja gui jale y trongcon jayo sija: todo y trongcon jayo na ti mauleg tinegchañija, umautut ya umayute gui guafe. ");
INSERT INTO cha_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ya y linajyan taotao mafaesen güe ya ilegñija: Pues jafajam infatinas? ");
INSERT INTO cha_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ya manope, ilegña nu sija: Y guaja dos magaguña, unae y taya iyoña: ya y guaja naña ufatinas taegüijija. ");
INSERT INTO cha_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ya manmato locue y publicano sija para ufanmatatagpange, ya ilegñija: Maestro jafa infatinasjam? ");
INSERT INTO cha_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ya ilegña nu sija: Chamiyo gumagagao mas ni y esta jamyo manmatago. ");
INSERT INTO cha_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ya mafaesen güe locue nu y sendalo sija, ilegñija: Ya jame, jafajam infatinas? Ya mansinangane: Chamiyo mumatratrata ni jaye ni infanmanchiguit, ya magof jamyo nu y apasmiyo. ");
INSERT INTO cha_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ya y taotao sija jananangga ya manmanjajajaso todo sija as Juan gui corasonñija, cao güiya si Jesucristo. ");
INSERT INTO cha_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Manope si Juan ya ilegña nu todosija: Guajo magajet managpapange jamyo an janom; lao mamamaela uno na mas gaeninasiña qui guajo, ya ti siña yo manmerese na jupula y coreas y sapatosña: güiya managpapange an Espiritu Santo yan guafe. ");
INSERT INTO cha_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ya abanicuña gaegueja gui canaeña para unagasgas y guinecoña, ya janafandaña y trigo gui camalenña; lao usonggue y ngasan gui guafe ni ti siña upuno. ");
INSERT INTO cha_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ya mamagat megae na sinangan ya japredica y taotao sija ni ibangelio. ");
INSERT INTO cha_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lao si Herodes, ayo magalaje tetrarca, linalatde as Juan, pot si Herodias, asaguan y cheluña as Felipe, yan pot todo y tinaelaye sija ni jafatinas si Herodes, ");
INSERT INTO cha_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ya jafatinas este mas taelaye qui todo, ya maponggle si Juan gui catset. ");
INSERT INTO cha_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ya susede, anae todo y taotao manmatagpange, si Jesus locue matagpange; ya anae manaetaegüe, mababa y langet; ");
INSERT INTO cha_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ya tumunog gui jiloña y Espiritu Santo na gaejechuraña calang paluma, ya mato un inagang guine y langet na ilegña: Jago y lajijo ni juguaeya; iyajago nae gaegue minagofjo. ");
INSERT INTO cha_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ya si Jesus namaesa anae jatutujon sumetnon, güiya treinta años, ya güiya lajin José (calang jinason taotao), nu y lajin Eli, ");
INSERT INTO cha_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nu y lajin Matat nu y lajin Levi, nu y lajin Metqui, nu y lajin Jané, nu y lajin José, ");
INSERT INTO cha_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Nu y lajin Matatias nu y lajin Amos, nu y lajin Nalum, nu y lajin Eslí, nu y lajin Nagé, ");
INSERT INTO cha_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nu y lajin Maat, nu y lajin Matatias, nu y lajin Simei, nu y lajin José, nu y lajin Juda, ");
INSERT INTO cha_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nu y lajin Joana, nu y lajin Resa, nu y lajin Sorobabel, nu y lajin Salatiel, nu y lajin Neri, ");
INSERT INTO cha_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nu y lajin Metqui, nu y lajin Adí, nu y lajin Cosam, nu y lajin Elmodan, nu y lajin Er, ");
INSERT INTO cha_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nu y lajin Jesus, nu y lajin Elieser, nu y lajin Jorim, nu y lajin Mata, nu y lajin Levi, ");
INSERT INTO cha_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nu y lajin Simeon, nu y lajin Juda, nu y lajin José, nu y lajin Jonan, nu y lajin Eliaquim, ");
INSERT INTO cha_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Nu y lajin Melea, nu y lajin Mena, nu y lajin Matata, nu y lajin Natan, nu y lajin David, ");
INSERT INTO cha_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nu y lajin Jesse, nu y lajin Obed, nu y lajin Boos, nu y lajin Salmon, nu y lajin Naason, ");
INSERT INTO cha_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nu y lajin Aminadab, nu y lajin Aram, nu y lajin Esrom, nu y lajin Fares, nu y lajin Juda, ");
INSERT INTO cha_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Nu y lajin Jacob, nu y lajin Ysaac, nu y lajin Abraham, nu y lajin Taré, nu y lajin Nacor, ");
INSERT INTO cha_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nu y lajin Serug, nu y lajin Ragau, nu y lajin Peleg, nu y lajin Heber, nu y lajin Sela, ");
INSERT INTO cha_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Nu y lajin Cainan, nu y lajin Arfaxat, nu y lajin Sem, nu y lajin Noe, nu y lajin Lameg, ");
INSERT INTO cha_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nu y lajin Matusalem, nu y lajin Enog, nu y lajin Jared, nu y lajin Mahalaleel, nu y lajin Cainan, ");
INSERT INTO cha_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Nu y lajin Enos, nu y lajin Set, nu y lajin Adam, nu y lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","YA si Jesus, bula Espirita Santo, tumato guato gui Jordan, ya quinene ni Espiritu asta y desierto. ");
INSERT INTO cha_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ya sumaga güije cuarenta na jaane ya tinienta nu y anite. Ya ti chumocho ni jafa, güije sija na jaane; ya anae esta macumple, ñalang güe. ");
INSERT INTO cha_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ya ilegña nu güiya y anite: Yaguin jago Lajin Yuus, tago este y acho ya ufamapan. ");
INSERT INTO cha_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ya si Jesus manope qüe: Esta mamatugue, na ti y panja munalâlâ y taotao. ");
INSERT INTO cha_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ya jacone güe quinene julo, ya finanue güe todo y raeno gui jilo y tano gui un momento y tiempo, ");
INSERT INTO cha_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ya y anite ilegña nu güiya: Bae junae jao ni este na ninasiña todo, yan y minalagñija; sa guajo maentrega, ya jaye y malagojo, junae. ");
INSERT INTO cha_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Enaomina jago, yaguin unadora gui menajo, todosija iyomo. ");
INSERT INTO cha_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ya manope si Jesus, ya ilegña: Esta matugue na y Señot Yuusmo unadora, ya güiyaja unsetbe. ");
INSERT INTO cha_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ya quinene talo guiya Jerusalem ya pinelo gui sumanjilo y templo, ya ilegña nu güiya: Yaguin jago Lajin Yuus, yutejao güine papa: ");
INSERT INTO cha_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sa esta matugue, na y angjetña sija jaencatga nu jago para unmaadaje, ");
INSERT INTO cha_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ya y canaeñija unquilile sa chamo matompo y adengmo gui acho. ");
INSERT INTO cha_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Manope si Jesus ya ilegña: Esta masangan: Chamo tietienta y Señot Yuusmo. ");
INSERT INTO cha_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Anae esta munjayan todo y tentasionña y anite mapos guiya güiya un rato. ");
INSERT INTO cha_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Si Jesus tumato gui ninasiñan y Espiritu asta Galilea: ya jumanao y famaña guiya todo y tano gui oriyaña. ");
INSERT INTO cha_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ya güiya mamananagüe gui guimayuusñija, ya ninafanonra nu y todo. ");
INSERT INTO cha_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ya mato guiya Nasaret anae jagas mapogsae: ya jumalom taemanoja y costumbreña gui jaanin sabado, gui guimayuus ya cajulo para utaetae. ");
INSERT INTO cha_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ya manaegüe y leblon y profeta Isaias. Ya anae jababa y leblo, jasoda anae esta matugue: ");
INSERT INTO cha_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Y Espiritun y Señot gaegue gui jilojo, sa japalae yo para jupredica y mauleg na sinangan gui mamobble: ya matago yo para jusangane mancautibo, linibre, ya para y manbachet ufanmanlie, ya para junafanlibre y manchiguit, ");
INSERT INTO cha_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Para jusaganñaejon y guaeyayon na año y Señot. ");
INSERT INTO cha_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ya jajuchom y leblo ya anae janatalo y ministro, matachong; ya todo y mangaegue gui guimayuus, güiyaja manatan. ");
INSERT INTO cha_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ya jatutujon sumangane sija: Pago esta macumple este na tinigue gui talanganmiyo. ");
INSERT INTO cha_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ya todoja manmannae testimonio ya esta ninafanmanman nu minauleg sinangan ni manjujuyong, gui pachotña; ya ilegñija: Ti güiya ini y lajin José. ");
INSERT INTO cha_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ya ilegña nu sija: Magajet insanganeyo nu este na sinangan: Medico, amte namaesajaoja: todo sija injingog na unfatinas guiya Capernaum, fatinas locue güine gui tanomo. ");
INSERT INTO cha_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ya ilegña: Magajet na jusangane jamyo, na ni un profeta guaegayon gui tanoña. ");
INSERT INTO cha_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lao magajet jusangane jamyo: Megae na biuda sija guaja gui Israel gui jaanin Elias, anae y langet majuchom tres años yan saes mesas, anae guaja dangculo na ñinalang gui todo y tano; ");
INSERT INTO cha_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lao ni uno guiya sija nae, esta matago si Elias, na as Sarepta, guiya tanon Sidon, guiya un palaoan biuda. ");
INSERT INTO cha_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ya megae na ategtog locue guaja guiya Israel gui tiempon y profeta Eliseo; lao taya guiya sija esta magasgas, na si Naaman taotao Siro. ");
INSERT INTO cha_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayo nae todo y taotao gui guimayuus manbula y linalalo, anae jajungog estesija; ");
INSERT INTO cha_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ya mangajulo, ya chumulegüe gui sanjiyong y siuda, ya macone asta gui sanjilo y egso, anae esta maplanta y siudañija, para ufanyute gui papa. ");
INSERT INTO cha_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lao güiya, malofan gui entaloñija, ya mapos. ");
INSERT INTO cha_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ya mato papa guiya Capernaum, siudan Galilea, ya ayo nae mamananagüe gui sabado na jaane: ");
INSERT INTO cha_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ya sija ninafanmanman nu y finanagüeña; sa y sinanganña gaeninasiña. ");
INSERT INTO cha_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ya gaegue gui guimayuus un taotao na guaja anite ináplacha; ya umagang dangculo na inagang. ");
INSERT INTO cha_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Jei! pelojam! para jafajam nu jago, Jesus Nasareno? Matojao para unyulangjam? jutungojao jayejao; jago ayo na Santos gui as Yuus! ");
INSERT INTO cha_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ya si Jesus jalalatde ya ilegña: Pacaca ya maela juyong guiya güiya. Ya anae y anite mayute güe gui entaloñija, jumuyong guiya güiya; ya taya ninalamen. ");
INSERT INTO cha_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ya minamanman mato gui jilo todo sija, ya manadingan uno yan otro, ilegñija: Jafa na cuentos este? Sa nu y gobietnaña yan y ninasiñaña jatago y áplacha na anite sija ya unfanjuyong? ");
INSERT INTO cha_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ya y famaña masanganñaejon todo y lugat sija gui oriyaña ayona. ");
INSERT INTO cha_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ya jacajulo jumanao juyong gui guimayuus ya jumalom gui guiman Simon; ya y suegran Simon esta umaason, malingo nu y dangculo na calenturaña; ya matayuyutgüe pot güiya. ");
INSERT INTO cha_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ya jatojgue gui jijutña, ya jalalatde y calentura ya y calentura pinelo; ya güiya cajulo ensiguidas ya jasetbe. ");
INSERT INTO cha_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ya y tiempo y minachom y atdao nae, todo y mangaemalango ni y megae na chetnot, manmaconie guiya güiya; ya japolo y canaeña gui jilo cada uno guiya sija, ya janafanjomlo sija. ");
INSERT INTO cha_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ya anite sija manjuyong locue guiya megae, na manaagang ya ilegñija: Jago, y Lajin Yuus! Lao güiya jalalatde ya ti japolo ya ufanguentos, sa matungo güe na güiya si Cristo. ");
INSERT INTO cha_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ya anae esta taftaf y jaane, jumanao para un jalomtano: ya y linajyan taotao sija maaliligao güe ya manmafato guiya güiya ya manmalago sija ufanmantiene güe para munga mapos guiya sija. ");
INSERT INTO cha_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ya güiya ilegña nu sija: Nesesitayo locue gui palo siuda umapredica y raenon Yuus: sa para este na matagoyo. ");
INSERT INTO cha_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ya japredidica gui guimayuus sija guiya Galilea. ");
INSERT INTO cha_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","YA susede anae y linajyan taotao manoriya yan machichiguet güe ya jaecungog y sinangan Yuus, na güiya gaegue tumotojgue gui oriyan jagoe Genesaret. ");
INSERT INTO cha_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ya jalie dos batco na estaba jijot gui oriyan y jagoe; ya y manpescadot manunog güije, ya jafagase y laguañija. ");
INSERT INTO cha_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ya jumalom güine gui un batco ya y iyon Simon; ya jagagao na unafalag y tano didide. Ya matachong ya mamanagüe desde y batco ni linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ya anae munjayan cumuentos, ilegña as Simon: Juyong gui tadong na tase ya innatunog y laguanmiyo para un quinene. ");
INSERT INTO cha_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ya manope si Simon ya ilegña: Maestro estajam manmachocho todo puenge ya taya quinenemame; lao pot y sinanganmo bae innatunog y lagua. ");
INSERT INTO cha_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ya anae manmatinas este, japongle un dangculo na quinenen güijan; ya esta tiniteg y laguanñija. ");
INSERT INTO cha_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ayo nae jaseñat y mangachongñija ni mangaegue gui otro batco, para ufanmato ya ufaninayuda. Ya manmato, ya janabulaja y dos batco, ya jatutujon manmañoñogñog. ");
INSERT INTO cha_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ya anae jalie este si Simon Pedro, dumimo papa gui as Jesus ya ilegña: Suja guiya guajo, Señot; sa taotao isaoyo. ");
INSERT INTO cha_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sa ninamaañao yan todos y mangaegue guiya güiya, pot causa de y quinenen güijan ni y inquene; ");
INSERT INTO cha_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ya taegüije ja locue as Santiago yan si Juan, famaguon Sebedeo, ya sija mangachong Simon. Ya ilegña si Jesus as Simon: Chamo maaaño: sa desde pago ufangone jao y taotao. ");
INSERT INTO cha_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ya anae esta mañule gui tano y batcoñija; todo jayute ya madalaggüe. ");
INSERT INTO cha_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ya susede anae gaegue güe gui uno gui siuda sija, estagüe un taotao na bula ategtog: güiya anae jalie si Jesus, podong gui mataña gui menaña ya jagagao, ilegña: Señot, yaguin malagojao, siñajao unnagasgasyo? ");
INSERT INTO cha_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ya jaestira y canaeña ya japacha, ilegña: Malagoyo, gasgasjao; ya enseguidas y ategtog jumanao guiya güiya. ");
INSERT INTO cha_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ya tinago güe, na chaña sangangane ni jaye: lao janao, unfanue y pale nu jago ya unofrese ni y guinasgasmo, taemanoja y tinagon Moises para testimonio nu sija. ");
INSERT INTO cha_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lao y masanganña jumanao megae; ya mandaña y dangculon linajyan taotao para umajungog yan para ufanmagong y chetnotñija. ");
INSERT INTO cha_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lao güiya jaapatta güe asta y jalomtano ya manaetae. ");
INSERT INTO cha_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ya susede gui un jaane na estabagüe mamanagüe; ya mangaegue y Fariseo sija yan y magas y lay, manmatatachong, sa sija manmato guinen y sengsong Galilea, yan Judea, yan y ya Jerusalem; ya y ninasiñan y Señot gaegue güije para unamagong. ");
INSERT INTO cha_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ya estagüe sija taotao na macocone un taotao gui jilo un cama na paralitico; ya maaliligao mano nae mañule jalom para umapolo gui menaña. ");
INSERT INTO cha_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ya anae ti masoda mano nae umapolo pot causa y linajyan taotao, mangajulo gui jilo guma ya guinin y atof nae manatunog yan camaña gui entalo, asta y gui menan Jesus. ");
INSERT INTO cha_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ya anae jalie y jinengguenñija yuje sija, ilegña: Taotao, y isaomo umaasie. ");
INSERT INTO cha_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ya y escriba yan y Fariseo sija jatutujon manmanjaso, ya ilegñija: Jaye güe este na usangan chatfino contra si Yuus? Jaye siña manasie isao, na si Yuusja? ");
INSERT INTO cha_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Lao si Jesus jatungo y jinasonñija; manope ya ilegña nu sija: Jafa injajaso gui corasonmiyo? ");
INSERT INTO cha_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Jafa sen taeminapot masangan: Y isaomo unmaasie; pat masangan: Cajulo ya unfanmocat? ");
INSERT INTO cha_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lao para intingoja na y Lajin taotao guaja ninasiñaña gui tano para umasie isao (ilegña nu y paralitico), jusanganejao: Cajulo, chule y camamo ya unjanao para iyajamyo. ");
INSERT INTO cha_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ya enseguidas güiya cajulo gui menanñija, ya jachule ayo anae umaasongüe ya jumanao para y guimaña, ya jatuna si Yuus, ");
INSERT INTO cha_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ya ninafanmanman todosija, ya matuna si Yuus; ya manbula y minaañao, ilegñija: Inlie námanman sija pago. ");
INSERT INTO cha_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ya despues di estesija, jumanao, ya jalie un publicano na y naanña si Levi, matatachong gui bancon y tributo ya ilegña: Dalalagyo. ");
INSERT INTO cha_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ya japolo todo y güinajaña ya cajulo ya jadalalaggüe. ");
INSERT INTO cha_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ya jafatinas si Levi un dangculon gupot gui guimaña: ya guaja un dangculon linajyan publicano sija, yan otro sija manmatachong gui lamasa yan sija. ");
INSERT INTO cha_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ya y Fariseo sija yan y escribañija, mangogonggong contra y disipuluña sija, ilegñija: Sajafa na manjajamyo mañocho yan manguimen yan y publicanosija yan y manisao? ");
INSERT INTO cha_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ya manope si Jesus ya ilegña nu sija: Y manaechetnot ti janesesita medico; lao y manmalango. ");
INSERT INTO cha_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ti matoyo para juagang y manunas, lao y manisao para ufanmañotsot. ");
INSERT INTO cha_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ya ilegñija nu güiya: Y disipulon Juan manayuyunat megae na biaje, ya jafatitinas tinayuyut; parejoja yan y disipulon Fariseo sija; ya iyoco mañochocho yan manguiguimen? ");
INSERT INTO cha_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ya si Jesus ilegña nu sija: Siña innaayunat y mangaegue gui guipot uma sagua anae mañisijaja yan y nobio? ");
INSERT INTO cha_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lao ufato jaane na y nobio umana suja; ayo nae ufanayunat güije na jaane sija. ");
INSERT INTO cha_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ya mansinangane sija locue un acomparasion: Taya taotao janajanao pidason magago gui nuebo na bestido ya japolo gui bijo na bestido; no sea ujatiteg y nuebo ya locue y magago guinin nuebo ti parejo yan y bijo. ");
INSERT INTO cha_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ya taya mananaye nuebo na bino gui bijo na boteyan cuero: ya no sea, y bino ni nuebo uyinamag y boteyan cuero, ya y bino umachuda, ya y boteyan cuero ufalingo. ");
INSERT INTO cha_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lao y nuebo bino na nasesita y nuebo na boteyan cuero nae umapolo. ");
INSERT INTO cha_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ya ni un taotao ni gumimen y bijo na bino umalago ni nuebo; sa ualog: Y bijo maulegña. ");
INSERT INTO cha_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","YA susede y un sabado, jumajanao si Jesus gui fangualuan maies; ya y disipuluña sija, manmanjajala ni y masotcan maies, ya jacano, jagugugan ni y canaeñija. ");
INSERT INTO cha_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ya y Fariseo sija ilegñija: Jafa na infatitinas y ti tunas na umafatinas gui sabado na jaane: ");
INSERT INTO cha_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ya maninepe as Jesus iligña: Taya nae intaetae este y finatinas David anae ñalang yan y mangachongña? ");
INSERT INTO cha_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Anae jumalom gui guimayuus, ya jachule ya jacano y pan ni y mafamamauleg, yan janae locue y mangachongña: ni y ti tunas na ucano na para y mamaleja? ");
INSERT INTO cha_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ya ilegña nu sija: Y Lajin Taotao locue Señot y sabado. ");
INSERT INTO cha_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ya susede y otro sabado, na jumalom gui guimayuus ya mamanagüe: ya estaba güije un taotao na anglo y agapa na canaeña. ");
INSERT INTO cha_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ya y escriba yan y Fariseo sija maaatan güe, cao unajomlo gui sabado na jaane; para uquefanmañoda jafa ya umafaaela. ");
INSERT INTO cha_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lao jatungoja y jinasonñija; ya ilegña ni ayo na taotao y anglo canaeña: Cajulo ya untojgue gui tálolo! ya tumojgue julo. ");
INSERT INTO cha_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ya ilegña si Jesus nu sija: Jufafaesen jamyo uno. Tunas gui sabado na umafatinas y mauleg pat y taelaye? numalibre linâlâ pat mamuno? ");
INSERT INTO cha_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ya jaatan todos y oriyañija ya ilegña nu güiya: Estira mona y canaemo. Ya guiya jafatinas taegüije, ya y canaeña numalo ya magong taegüije y otro. ");
INSERT INTO cha_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ya sija mansénbubo, ya manguecuentos uno yan otro, jafa mojon ujafatinas gui as Jesus. ");
INSERT INTO cha_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ya susede gui ayo sija na jaane, jumanao para ufanaetae gui un ogso ya todo y puenge jasigue di manaetaeja para as Yuus. ");
INSERT INTO cha_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ya anae manana, jaagang y disipuluña sija; ya jaayig dose guiya sija, ni manmafanaan locue apostoles. ");
INSERT INTO cha_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Si Simon ni jafanaan locue Pedro, yan si Andres cheluña, yan si Santiago, yan si Juan, si Felipe, yan si Bartolome, ");
INSERT INTO cha_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Yan si Mateo, yan si Tomas, yan si Santiago, lajin Alfeo, yan si Simon ni mafanaan Selote, ");
INSERT INTO cha_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yan si Judas chelun Santiago, yan si Judas Iscariote ni y traidot; ");
INSERT INTO cha_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ya manunog yan sija ya tumojgue gui un lugat ni yano; yan y dangculon linajyan disipuluña sija, yan y dangculon linajyan taotao, guinin todo yya Judea, yan yya Jerusalem, yan y tano Tiro yan yya Sidon, ni manmato para umaecungog, yan para uninafanmagong y chetnotñija; ");
INSERT INTO cha_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yan manafanmagong ayo sija y munafanachatsaga ni y espiritun áplacha. ");
INSERT INTO cha_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ya manmalago pumapacha güe y linajyan taotao: sa manjujuyong guiya güiya ninasiña ya janafanmamagong todo sija. ");
INSERT INTO cha_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ya güiya manatan julo gui disipuluña, ya ilegña: Mandichoso jamyo ni mamobble; sa iyonmiyo y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mandichoso jamyo ni y manñalang pago: sa ufanjaspog. Mandichoso y manatanges: sa ufañaleg. ");
INSERT INTO cha_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mandichoso jamyo yaguin y taotao sija infanchinatlie, yan ujaapatta sija guiya jamyo ya ujalalatde jamyo ya ujayute juyong y naanmiyo pot taelaye pot causa y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Fansenmagof güije na jaane; yan infanayog ni minagofmiyo: sa, estagüe, y premionmiyo dangculo gui langet; sa taegüenaoja jafatitinas y tatañija ni y profeta sija. ");
INSERT INTO cha_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lao ay jamyo ni manrico! sa esta guaja consuelonmiyo. ");
INSERT INTO cha_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ay jamyo ni esta manjaspog pago! sa infanñalang. Ay jamyo ni mañachaleg pago! sa jamyo infanugong yan infananges. ");
INSERT INTO cha_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ay jamyo yaguin todo y taotao sija manguecuentos mauleg nu jamyo! sa taegüenaoja ujafatinas y tatañija ni y manfatso na profeta. ");
INSERT INTO cha_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lao jusangangane jamyo ni jumujungog: Güaeya y enemigonmiyo; fatinas mauleg ni y chumatlie jamyo, ");
INSERT INTO cha_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bendise y mumatdise jamyo, ya infanmanaetae pot y namamajlao jamyo. ");
INSERT INTO cha_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ya pumatmada y un banda fasumo, naeja locue ni y otro, ya y chumule y capamo, chamo chumochoma na uchule y chininamo locue. ");
INSERT INTO cha_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ya cada uno ni y gumagaojao, nae; ya y chumule y güinajamo, chamo tumalulugua gumagao. ");
INSERT INTO cha_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ya jafa y malagomiyo ni y taotao jafatinas nu jamyo; taegüijija fatinas locue nu sija: ");
INSERT INTO cha_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sa yaguin inguaeya y gumaeya jamyo, jafa na grasia guajanmiyo? sa y manisao locue jaguaeya y gumaeya sija. ");
INSERT INTO cha_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yaguin infatinas mauleg ni y fumamamauleg jamyo, jafa na grasia guajanmiyo? sa y manisao locue jafatitinasja taegüenao. ");
INSERT INTO cha_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yanguin innaayao na ayo sija ni y guaja ninanggamo para infanresibe, jafa na grasia guajanmiyo: sa y manisao janaayao y manisao para ufanmanresibe taegüije talo. ");
INSERT INTO cha_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lao guaeya jamyo y enimigunmiyo ya infatinas mauleg nu sija: ya innaaayao, ya chamiyo fantataeninangga, ya udangculo y premionmiyo yan infanfamaguon y Gueftaguilo: sa güiya cariñoso nu y ingrato sija, yan y taelaye. ");
INSERT INTO cha_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jamyo locue fanyóase, taegüije y tatanmiyo ni y gaegue gui langet yóase. ");
INSERT INTO cha_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Chamiyo jumusga, sa ti infanjinisga: chamiyo sumetetensia, sa ti infansinentensia: nafanlibre, ya y ninafanlibre: ");
INSERT INTO cha_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fanmanae, ya infanmanae; mauleg na medida y majoño papa, ya umachaochao ya umachúchuda, ufanmannae y taotao sija gui jalom pechonmiyo; sa ayoja na medida y anae manmide jamyo: infanmamediye talo jamyo. ");
INSERT INTO cha_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ya jasangane sija un acomparasion ilegña: Siña y bachet jaosgaejon y otro bachet? ti ujaachapodong y dos gui joyo? ");
INSERT INTO cha_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Y disipulo ti taquiloña qui y maestro: lao cada uno ni y cabales, güiya utaegüijija y maestroña. ");
INSERT INTO cha_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ya jafa muna unlilie y migo gui atadog y chelumo; ya ti unlilie y jayo gui atadogmo? ");
INSERT INTO cha_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ya jafa muna siña unalog ni y chelumo: Chelujo, maela ya junajanao y migo gui atadogmo, yanguin jago ti unlilie y jayo gui atadogmo? Hipocrita jao, yute juyong finena y jayo gui atadogmo, ya ayo nae unlie claro para unnajanao y migo gui atadog y chelumo. ");
INSERT INTO cha_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sa taya mauleg na trongco, ni y fanogcha taelaye, ni y taelaye na trongco ni y fanogcha mauleg. ");
INSERT INTO cha_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sa cada trongco matungoja pot y tinegchaña. Sa ti ufanmanrecoje y taotao sija igos gui manituca ni ufanmanrecoje ubas gui jalom gadon. ");
INSERT INTO cha_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Y mauleg na taotao, ni y mauleg na guinaja gui corasonña, mañuñule mauleg; ya y taelaye na taotao, ni y taelaye na güinaja gui corasonña, mañuñule taelaye: sa y minegae y corason jasasangan y pachotña. ");
INSERT INTO cha_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ya jafa na infananaanyo Señot, Señot, ya ti infatitinas y jusangangane jamyo? ");
INSERT INTO cha_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Jaye y mato guiya guajo ya jaecungog y sinanganjo ya jafatinas; jufanue jaye parejuña: ");
INSERT INTO cha_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Parejo yan un taotao ni y manjatsa guma, ya jaguadog tadong ya japolo y simiento gui jilo y fitme na acho; ya yanguin cajulo y manadan janom, ya milag y sadog chineneg ayo na guma; lao ti umayengyong, sa maplanta gui jilo y acho. ");
INSERT INTO cha_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lao ayo y umeecungog ya ti jafatinas; parejo yan y taotao ni y manjatsa guma gui jilo oda ya ti janaye simiento; ya anae milag y sadog ya chineneg, enseguidas upodong; ya dangculo y yinilang ayo na guma. ");
INSERT INTO cha_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","YA despues di munjayan todo y finanagüeña si Jesucristo gui talangan taotao sija, güiya jumalom guiya Capernaum. ");
INSERT INTO cha_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ya y tentago un senturion ni y guefyaña, estaba malango, ya esta para umatae. ");
INSERT INTO cha_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lao anae y senturion jajungog na masasangan si Jesus, jatago y manamco na Judios, para umagagao na ufato ya unajomlo y tentagoña. ");
INSERT INTO cha_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ya anae manmato as Jesus, guefmagagao ilegñija: Dignogüe na unfatinas este pot güiya: ");
INSERT INTO cha_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Sa jagüaeya y nasionmame ya japlantaye jam sinagoganmame. ");
INSERT INTO cha_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ya manjanao yan si Jesus. Ya anae esta manjijot gui guima y senturion jatago y amiguña sija para ualog as Jesus: Señot chamo ninachachatsaga; sa ti dignoyo na junajalom jao gui papa atofjo; ");
INSERT INTO cha_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pot este ti jujaso na dignoyo na jufato guiya jago; lao sanganja ya ujomlo y tentagojo. ");
INSERT INTO cha_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sa guajo locue na taotao gaegeuyo gui papa y ninasiña, ya guaja gui papajo sendalo sija; yan ileco nu este: Janao, ya mapos; ya y otro: Maela, ya mato; ya y tentagojo: Fatinas este, ya jafatinas. ");
INSERT INTO cha_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ya anae jajungog si Jesus este, ninamanman nu güiya, ya jabiragüe ilegña ni y linajyan taotao ni y dumalalag güe: Jusangane jamyo na ti jusoda taegüije na dinangculon jinenggue ni iya Israel. ");
INSERT INTO cha_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ya anae manalo sija guato gui guima y manmanago, jasoda na jomlo y tentago ni estaba malango. ");
INSERT INTO cha_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ya susede un rato despues di este na, si Jesus jumanao asta un siuda ni mafanaan Nain; ya mañisija yan y disipuluña yan y dangculon manadan taotao. ");
INSERT INTO cha_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ya anae esta jijot gui pettan y siuda, estagüe na macocone un matae, güiyaja lajin nanaña, ya biuda locue, ya linajyan taotao siuda mangachongchongña. ");
INSERT INTO cha_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ya anae linie ni y Señot ninamaase nu güiya, ya ilegña nu güiya: Chamo cumacasao. ");
INSERT INTO cha_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ya lumatguato ya japacha y andas; ya y chumuchule mañaga. Ya ilegña: Patgon, guajo jao sumangane, cajulo. ");
INSERT INTO cha_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ya y estaba matae matachong ya jatutujon cumuentos, ya inentrega as Jesus gui as nanaña. ");
INSERT INTO cha_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ya ninafanmaaañao todosija, ya maalaba si Yuus ilegñija: Dangculo na profeta esta cajulo entre yya jita: ya, si Yuus jagas jabisita taotaoña. ");
INSERT INTO cha_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ya jumanao este na famaña gui todo yya Judea yan todo oriya y tano. ");
INSERT INTO cha_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ya y disipulon Juan masangane güe todo estesija. ");
INSERT INTO cha_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ya jaagang si Juan dos gui disipuluña ya jatago para as Jesus, ilegña: Cao jago yuje y para ufato pat infanmannangga jam otro? ");
INSERT INTO cha_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ya anae manmato y taotao sija guiya güiya, ilegñija: Si Juan Bautista tumagojam para yya jago, ilegña: Cao jago yuje y para ufato pat infanmannangga jam otro? ");
INSERT INTO cha_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ya ayo mismo na ora, janafanjomlo megae ni y manmalango yan y mangaechetnotsija yan espiritun manaelaye; yan megae na manbachet ninafanmanlie. ");
INSERT INTO cha_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ya maninepe as Jesus ya ilegña nu sija: Janao yan sangane si Juan ni y liniimiyo yan y jiningogmiyo; sa y manbachet manmanlie, ya y mangojo manmamocat, ya y manategtog mangasgas, ya y mananga manmanjungog, y manmatae manafangajulo, ya umapredica y ibangelio gui mamobble. ");
INSERT INTO cha_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ya dichoso ayo y ti sumosoda y lugat para umatompo guiya guajo. ");
INSERT INTO cha_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ya anae manmapos y mantinago as Juan, jatutujon cumuentuse y taotao sija pot si Juan: Jafa injanagüe jamyo para inlie gui desierto? un piao ni y yinengyong ni y manglo? ");
INSERT INTO cha_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Lao jafa injanagüe jamyo para inlie? un taotao na puru suabe magaguña? Estagüe, ayo sija y manminagagago ni y malagno magago yan manlalâlâ gui guinatbo, gui palasyon y ray nae mañasaga. ");
INSERT INTO cha_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lao jafa injanagüe para inlie? un profeta? magajet, jusangane jamyo na mas que un profeta. ");
INSERT INTO cha_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Este yuje y esta matugue: Estagüe na jatago y tentagojo gui menan matamo, ni para ufamauleg y chalanmo gui menamo. ");
INSERT INTO cha_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jusangane jamyo, na entre ayo sija y manmafañago gui famalaoan, taya dangculoña qui si Juan; lao y diquiqueja gui raenon Yuus dangculoña qui güiya. ");
INSERT INTO cha_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ya todo y taotao anae majungog güe, yan y publicano sija, jajustifica si Yuus ya manmatagpange ni y tinagpangen Juan. ");
INSERT INTO cha_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lao y Fariseo yan y manmagas y lay, jarechasa y consejon Yuus contra sijaja; sa ti manmatagpange pot güiya. ");
INSERT INTO cha_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ya ilegña: Jafa nae juacompara y taotao este na generasion? ya jafa parejonñija? ");
INSERT INTO cha_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Manparejo yan y famaguon ni manmatatachong gui plasa ya manaagang uno yan otro ya ilegñija: Indadane jamyo flauta, y ti manbaela jamyo, manuugonge jamyo, ya ti manatanges jamyo. ");
INSERT INTO cha_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sa mato si Juan Bautista ni uchocho pan ni uguimen bino, ya ilelegmiyo: Guaja anitiña. ");
INSERT INTO cha_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mato y Lajin taotao, ya chumocho yan gumimen, ya ilelegmiyo: Estagüe, un taotao na gachumocho yan gagumimen bino, yan amigon y publicano sija, yan y manisao. ");
INSERT INTO cha_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lao y tiningo manacabales ni y todo famaguonña. ");
INSERT INTO cha_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ya malago uno gui Fariseo sija na ufañija mañocho. Ya jumalom gui guima y Fariseo ya matachong gui lamasa. ");
INSERT INTO cha_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ya estagüe, un palaoan gui siuda, na miisao, ya anae jatungo na gaegue si Jesus matatachong gui lamasa gui guima y Fariseo, mañule un boteyan alabastro na ingüente. ");
INSERT INTO cha_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ya tumojgue gui taten Jesus, ya cumasao; ya jatutujon munafotgon ni lagoña y adeng Jesus, ya jasaosao ni y gapuniluña; ya jachichico y adengña ya japapalae ni y inggüente. ");
INSERT INTO cha_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ya anae jalie este y Fariseo ni y umagange güe, cumuentos gui sumanjalomña, ilelegña: Este na taotao yaguin profeta güe, jatungo jafa este na palaoan y pumapacha güe sa güiya miisao. ");
INSERT INTO cha_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ya manope si Jesus ya ilegña nu güiya: Simon, guaja para jasangane jao. Ya güiya ilegña: Sangan Maestro. ");
INSERT INTO cha_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Un taotao guaja dos dumídibe: ya y uno mandidibe quinientos monedan denario, ya y otro sincuenta. ");
INSERT INTO cha_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ya anae taya apasñija, inasie todo y dos. Enao mina, jaye guiya sija mas güinaeya? ");
INSERT INTO cha_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Manope si Simon, ya ilegña: Y pineloco na ayo y mas maasie; ya güiya ilegña: Tunas jinisgamo. ");
INSERT INTO cha_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ya jabira güe guato gui palaoan, ya ilegña as Simon: Unlilie este na palaoan? Jumalomyo gui guimamo, ti unnaeyo janom para y adengjo; lao este janafotgon y adengjo ni lagoña, ya jasaosao ni y gapuniluña. ");
INSERT INTO cha_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jago ti unnaeyo un chico: lao este na palaoan desde que jumalomyo ti pumapara jachico y adengjo. ");
INSERT INTO cha_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ti unpalae y ilujo ni laña, lao este japalae y adengjom inggüente. ");
INSERT INTO cha_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Enao mina jusangane jao, na y isaoña, ni y megae, umaasie; sa güiya megae maguaeyaña; lao y didide maasiiña, didide maguaeyaña. ");
INSERT INTO cha_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ya ilegña nu güiya: Y isaomo maasie. ");
INSERT INTO cha_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ya y mangachochongña manmatachong gui lamasa, jatutujon sumangan gui sumanjalomñija: Jaye este na ufanasie locue isao? ");
INSERT INTO cha_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ya ilegña ni palaoan: Y jinengguemo unsinatba; janao yan pas. ");
INSERT INTO cha_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","YA susede un rato despues na jajanaogüe y siuda sija yan y sengsong sija manpredidica, yan numanafanungo nu y ibangelion y raenon Yuus; ya mañisija yan y dose, ");
INSERT INTO cha_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ya palo sija famalaoan ni guinin nanafanmagong ni manaelayen espiritu yan y chetnot sija; si Maria ni mafanaan magdalena ni jumuyong guiya güiya siete na manganite, ");
INSERT INTO cha_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ya si Juana, asaguan Chusa, mayetdomon Herodes; yan si Susana yan megae ni pumalo ni jasesetbe ni güinajañija: ");
INSERT INTO cha_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ya anae mandaña y dangculon linajyan taotao, yan y manestaba cada siuda manmato guiya güiya, jacuentuse pot un acomparasion. ");
INSERT INTO cha_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Un tátanom jumanao para ufananom y semiyaña; ya anae manmananom, palo podong gui oriyan chalan; ya todo magacha, ya manmato sija y pajaro gui langet ya macano. ");
INSERT INTO cha_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yan palo mamodong gui jilo acho; ya anae lachog, ninamalayo sa ti fofotgon. ");
INSERT INTO cha_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yan palo mamodong gui jalom tituca; ya mandoco mañija y tituca, ya chiniguit. ");
INSERT INTO cha_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yan palo mamodong gui mauleg y tano; ya mandoco, ya manogcha siento pot uno. Ya anae esta jasangan estesija umagang: Y gaetalanga para ufanjungog, uecungog. ");
INSERT INTO cha_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ya y disipuluña sija mafaesen güe: Jafa este na acomparasion? ");
INSERT INTO cha_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ya guiya ilegña: Esta manmannae jamyo para intingo y misterion y raenon Yuus lao y pumalo pot acomparasion; para ujaaatanja ya ti ujalie, yan ujaecungogja ya ti ujatungo. ");
INSERT INTO cha_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pues este ayo na acomparasion: Y semiya y sinangan Yuus. ");
INSERT INTO cha_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Y gui oriyan chalan ayo sija y jagas jumungog; ya despues mato y manganite ya janasuja y sinangan gui corasonñija sa ti mojon ufanmanjonggue ya ufanmasatba. ");
INSERT INTO cha_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ya y jilo acho, ayo sija y anae jajungog, jaresibe y sinangan nu y minagof; lao estesija manaejale; sa jajonggue un ratoja, lao anae mato tentasion mamodong. ");
INSERT INTO cha_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ya y pedong gui jalom tituca, este sija y jumungog; ya mientras jumanao gui chalanñija, manchiniguit ni inadajeñiñija, yan y güinaja, yan y minagof tano gui este linâlâ, ya ti jumuyong tinegchañija cabales. ");
INSERT INTO cha_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lao ayo y mangaegue gui mauleg na tano, este sija na guinin jumungog y sinangan gui corason ni mauleg yan tunas, jamantietiene, ya manogcha yan manpasensia. ");
INSERT INTO cha_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ni uno ni mañoñonggue candet, utampe nu y batde pat upolo gui papa catre, lao upolo gui jilo lamasa para y jumajalom ulie y manana. ");
INSERT INTO cha_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sa taya manaatog ya ti umafatanñaejon; ni gae gui secreto ya ti umatungo, ujuyong gui manana. ");
INSERT INTO cha_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Guesadaje jaftaemano y jiningogmiyo: sa masquesea jaye y guaja, umanae; lao masquesea jaye y taya, unajanao ayo y pineloña na uguaja. ");
INSERT INTO cha_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ayonae manmato guiya güiya si nanaña yan y mañeluña, lao tisiña manlatguato guiya güiya pot y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ya masangane, ilegñija nu güiya: Si nanamo yan y mañelumo manmatotojgue gui sanjiyong na manmalago na unmalie. ");
INSERT INTO cha_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ya manope ya ilegña nu sija: Y nanajo yan y mañelujo, ayosija y jumungog y sinangan Yuus ya jafatinas. ");
INSERT INTO cha_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ya susede y uno gui ayosija jaane nae, na jumalom gui un batco, güiya yan y disipoluña sija; ya ilegña nu sija: Nije tafanjanao y otro banda jagoe; ya manjanao. ");
INSERT INTO cha_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ya anae mumamayama sija, güiya maego; ya manguaefe un dangculon, pagyo y manglo gui jagoe; ya bula y batco janom ya mangaegue sija gui peligro. ");
INSERT INTO cha_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ya manmato guiya güiya, ya mapangon, ilegñija: Maestro, maestro, tafanmalingo. Ya magmata, ya jalalatde y manglo yan y chaochao y janom; ya pumara, ya jumuyong malinao. ");
INSERT INTO cha_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ya ilegña nu sija: Mano nae gaegue jinengguenmiyo? Ya sija manmaañao ya ninafanmanman, ilegñija uno yan otro: Jaye este, na asta y manglo yan y janom jatago ya maoosgueja? ");
INSERT INTO cha_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ya manmato asta, y tano y taotao Gadara sija, ni gaegue gui sanmenan y Galilea. ");
INSERT INTO cha_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ya anae jumanao para y tano, umasoda yan un taotao gui jiyong y siuda na gaemanganite; ya apmam na tiempo ti minagagago ni usaga gui guima, na y naftanja. ");
INSERT INTO cha_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ya anae jalie si Jesus, umagang, ya jatombagüe gui menaña ya ilegña ni dangculo na inagang: Para jafayo nu jago Jesus, Lajin Yuus Gueftaquilo? Jusuplica jao na chamoyo sumasapet. ");
INSERT INTO cha_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sa jatago y espiritun áplacha na ufanjanao gui taotao; sa apmam na tiempo na maguot güe: mamantiene güe preso ya magode nu y cadena yan tale sija; ya jayamag y guinede ya quinene ni y manganite asta y desierto sija. ");
INSERT INTO cha_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ya finaesen as Jesus: Jaye naanmo? Ya güiya ilegña: Linajyan; sa megae na manganite manjalom guiya güiya. ");
INSERT INTO cha_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ya masuplica güe na chaña tumatago na ufanjanao para y tadong na joyo. ");
INSERT INTO cha_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ya estaba güije un inetnon babue na lajyan na mañochocho gui jalom tano: ya masuplica güe na ufanpinelo ya ufanjalom güije sija. Ya manpinelo. ");
INSERT INTO cha_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ya anae manjuyong y manganite gui taotao, manjalom gui babue ya y inetnon manmanunugo sajyao guato gui un didog gui jagoe ya manmatmos. ");
INSERT INTO cha_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ya ayo sija munafañochocho y babue anae jalie y mafatinas, manmapos ya jasangane y taotao siuda yan gui fangualuan. ");
INSERT INTO cha_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ya manjanao para ujalie y mafatinas; ya manmato gui as Jesus; ya masoda y taotao ni anae guinin jumuyong y manganite, na minagagago ya guaja jinasoña cabales, ya matatachong gui adeng Jesus; ya ninafanmaañao. ");
INSERT INTO cha_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ya mansinangane ni lumie, jafa taemano manamagongña ayo y guinin jinatme manganite. ");
INSERT INTO cha_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ayonae todo y taotao gui tano y Gadarenos yan todo y oriyan, magagao na ujanao guiya sija; sa mansenmaañao; ya güiya cajulo gui batco ya tumalo tate. ");
INSERT INTO cha_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lao ayo na taotao anae guinun manjuyong y manganite, siniplica güe para usaga guiya güiya; lao janajanao ya ilegña: ");
INSERT INTO cha_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Talo guato guiya jamyo ya unfañangane jaftaemano na dangculon güinaja finatinasña si Yuus nu jago. Ya guiña jumanao, ya jasanganñaejon todo gui siuda jaftaemano finatinasña si Jesus nu güiya. ");
INSERT INTO cha_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ya anae tumalo guato si Jesus maresibe ni y linajyan taotao sija ya mangosmagof; sa todoja numananggaja. ");
INSERT INTO cha_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ya estagüe, un taotao na y naanña si Jairo, ya güiya locue magas y sinagoga; mato ya jatombagüe papa gui adeng Jesus, ya jagagao na ujalom gui guimaña. ");
INSERT INTO cha_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sa guaja unoja jagaña na esta guaja dose años, ya estaba jijot na umatae. Ya anae jumanao maapupura güe ni linajyan taotao sija. ");
INSERT INTO cha_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ya un palaoan na numanajuyong jâgâ esta dose años, esta jalachae gumasta todo y güinajaña ni jaapaseñaejon medico, lao taya siña munamagong, ");
INSERT INTO cha_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mato gui tateña ya japacha y madoblan magaguña, ya enseguidas esta bumasta y jâgâña. ");
INSERT INTO cha_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ayonae si Jesus ilegña: Jayeyo pumacha? Lao anae todos japune ilegña si Pedro yan y mangachongña: Maestro, y linajyan taotao umanoriya jao yan machichiguit jao, ");
INSERT INTO cha_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lao si Jesus ilegña: Guajayo pumacha; sa guajo jutungo na guaja ninasiña jumuyong guiya guajo. ");
INSERT INTO cha_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ayonae y palaoan anae jalie na ti siña janaatog, mato ya manlalaolao, ya jatombagüe gui menaña, ya jasangan gui menan y taotao sija todos, pot jafa na japacha, yan jaftaemano na ninajomlo enseguidas. ");
INSERT INTO cha_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ya ilegña nu güiya: Hija, y jinengguemo unninajomlo; janao ya upas. ");
INSERT INTO cha_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ya mientras cumuecuentos, mato uno ni taotao y magas y sinagoga ya ilegña: Y jagamo matae, chamo umestototba y Maestro. ");
INSERT INTO cha_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ya anae jajungog si Jesus manopegüe: Chamo maaañao; jonggueja sa güiya ujomlo. ");
INSERT INTO cha_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ya anae mato gui guima, taya japolo na ujalom yan güiya na si Pedro, si Juan, yan si Santiago, yan y tatan y patgon, yan y nanaña. ");
INSERT INTO cha_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ya todos mangacasao, yan malamementagüe; lao ilegña: Chamiyo fangacasao; sa ti matae, lao mamaego. ");
INSERT INTO cha_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ya macháchatgue güe, sa matungoja na esta matae. ");
INSERT INTO cha_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lao güiya jamantiene y canaeña ya jaagang ilegña: Patgon palaoan, cajulo. ");
INSERT INTO cha_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ya mato y espirituña talo, ya enseguidas cajulo; ya manago na umanachocho. ");
INSERT INTO cha_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ya ninafanmanman y mañaenaña: lao jaencatga na chañija sumangangane ni un taotao jafa y mafatinas. ");
INSERT INTO cha_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","YA jaagang ya mandaña y dose disipuluña ya janae ninasiña gui jilo y manganite todo, yan para ufanmanamte nu y chetnot sija. ");
INSERT INTO cha_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ya jatago na ujapredica y raenon Yuus, yan unafanjomlo y manmalango. ");
INSERT INTO cha_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ya ilegña nu sija: Chamiyo fanmañuñule ni jafa para y chalan, ni baston, ni botsa, ni pan, ni salape; ni infangaemagago dos. ");
INSERT INTO cha_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ya cuatquiera na guma nae manjalom jamyo, fañaga güije asta que manjanao jamyo. ");
INSERT INTO cha_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ya todo ayo sija y ti rumesibe jamyo, anae manjanao jamyo güije na siuda, sacude y petbos gui adengmiyo para testimonio contra sija. ");
INSERT INTO cha_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ya manjanao sija, ya manmalofan sija gui sengsong, mapredidica y ibangelio, yan mannanajomlo gui todo y lugat. ");
INSERT INTO cha_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lao si Herodes tetrarca jajungog masangan este sija na finatinas, ya estaba guefinestotba ni y sinañgan palo na si Juan esta cumajulo guinin manmatae. ");
INSERT INTO cha_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ya y pumalo ilegñija: Si Elias jumuyong talo; ya otros umalog; na uno gui manamco na profeta lâlâ talo. ");
INSERT INTO cha_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ya ilegña si Herodes: Si Juan guajo dumegüeya; ya jaye este nae jujungog sija na güinaja? Ya japrocura lumie güe. ");
INSERT INTO cha_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ya anae manalo guato y apostoles sija, masangane güe todo ni y finatinasñija. Ya jacone sija ya mañuja asta un banda, gui un siuda ni mafanaan Betsaida. ");
INSERT INTO cha_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ya anae esta matungo ni y linajyan taotao sija, madálalag güe; ya güiya jaresibe, ya jasangane ni y raenon Yuus; ya janafanjomlo y numesesita manmaamte. ");
INSERT INTO cha_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ya y jaane jatutujon pumuenge; ya mafatoigüe nu y dose ya ilegñija nu güiya: Nafanjanao, y linajyan taotao, para ufanjanao asta y sengsong yan y fangualuan gui oriya, ya ufañaga ya ufanmanaligao nañija; sa mangaeguejit güine gui desierto na lugat. ");
INSERT INTO cha_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ya ilegña nu sija: Jamyo innafañocho. Ya ilegñija: Taya guajata na sincoja na pan yan dos güijan, patsino nije tafanjanao tafanmamajan nengcano para todo este sija na taotao. ");
INSERT INTO cha_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ya guaja buente sinco mit na taotao. Ya ilegña ni disipuluña: Nafanmatachong pot compania, cada compania sincuenta. ");
INSERT INTO cha_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ya taegüije mafatinas, ya mannafamatachong todos. ");
INSERT INTO cha_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ya jachule y sinco na pan yan y dos güijan, ya jaatan julo y langet ya jabendise ya jaipe; ya janae y disipoluña para upolo gui menan y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ya mañocho ya manjaspog todos; ya esta majatsa y sebla y pedaso sija, dose canastra. ");
INSERT INTO cha_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ya susede, anae mananaetae güiyaja namaesa, estabaja mangaegue guiya güiya y disipuluña, ya jafaesensija, ilegña: Jaye ilegñiñija y taotao nu guajo? ");
INSERT INTO cha_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ya sija manmanope ya ilegñija: Si Juan Bautista; lao guaja umalog: Si Elias; yan palo umalog na uno gui manamco na profeta lâlâ talo. ");
INSERT INTO cha_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ya ilegña nu sija: Lao jamyo, jaye ilegmimiyo nu guajo? Ya manope si Simon Pedro ya ilegña: Si Cristo, gui as Yuus. ");
INSERT INTO cha_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ya manguenesencatga sija ya jatago na chañija sumangangane ni jaye nu este; ");
INSERT INTO cha_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ilegña: Y Lajin taotao nesesita ufamadese megae, ya umarechasa ni y manamco sija, yan y manmagas y mamale yan y escriba sija, ya umapuno ya umanacajulo gui mina tres na jaane. ");
INSERT INTO cha_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ya ilegña nu sija todos: Yaguin guaja y malago tumatiyego, upunenaesa güe, ya uchule y quiluusña cada jaane ya udalalagyo. ");
INSERT INTO cha_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sa masqueseaja jaye y malago na usatba y linâlâña, ufinalingaeguan; ya masquesea jaye y malingo y linâlâña pot y naanjo, güiya usatba. ");
INSERT INTO cha_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sa jafa probechoña y taotao yaguin jagana todo y tano, ya güiya unafalingo maesa güe pat uyulang maesa gue? ");
INSERT INTO cha_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sa masqueseaja jaye pot y mamajlao guajo yan pot y sinanganjo, mamajlao locue nu este y Lajin taotao, yaguin mato gui minalagña yan y minalag tata yan y mañantos na angjet sija. ");
INSERT INTO cha_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lao magajet jusangane jamyo: Na guaja palo gui mangaegue güine, na ti uchague y finatae asta que ujalie y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ya susede mina ocho na jaane, despues di estesija na sinangan, jacone mañija yan Pedro, yan si Juan, yan si Santiago, ya cajulo gui egso ni taquilo para ufanaetae. ");
INSERT INTO cha_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ya mientras mananaetae güe, y jechuran mataña tolaeca; ya y magaguña jumuyong apaca ya malag. ");
INSERT INTO cha_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ya, estagüe, dos taotao na cumuecuentos yan güiya; ya si Moises, yan Elias, ");
INSERT INTO cha_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ya manjuyong yan y minalagñija, ya manguecuentos pot y jinanaoña, na para ucumple guiya Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lao si Pedro yan y mangachogña, mansenmatujog; ya anae manmagmata, malie y minalagña yan ayo na dos taotao ni mangachongña. ");
INSERT INTO cha_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ya susede, mientras sumusuja sija guiya güiya, si Pedro ilegña as Jesus: Maestro, maulegñaja tafañaga güine; ya nije tafanmamatinas tres na tabetnaculo; uno para jago, uno para si Moises, yan uno para si Elias; ti jatungo jafa jasasangan. ");
INSERT INTO cha_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ya mientras jasasangan este, mato un mapagajes ya mantinampe; ya ninafanguefmaañao anae manjalom gui mapagajes. ");
INSERT INTO cha_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ya mato un inagang gui mapagajes na ilegña: Este y lajijo, inayigco; ecungog güe. ");
INSERT INTO cha_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ya anae malofan ayo na inagang, esta masoda si Jesucristo güigüiyaja namaesa; ya sija manmamatquiloja, ya güije sija na jaane, taya jasangane ni jaye pot y liniiñija. ");
INSERT INTO cha_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ya susede inagpaña güije na jaane, anae manunog guinin y egso, ya y dangculon linajyan taotao masoda güe. ");
INSERT INTO cha_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ya, estagüe, un taotao gui entalo y linajyan, na umagang ilegña: Maestro jutayuyut jao na unlie y lajijo; sa y unoja patgonjo: ");
INSERT INTO cha_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sa, estagüe, un espiritu na quinene, ya enseguidas umagang; ya ninalaolao güe ya numanajuyong buo, ya aapmam na pinadese na sumuja guiya güiya, na ninalalamenja, ");
INSERT INTO cha_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya guinin jutayuyut y disipulumo na ujayute juyong; ya ti manasiña. ");
INSERT INTO cha_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ya manope si Jesus ya ilegña: O generasion na ti manjonggue, yan manchatpayon! asta ngaean nae utafanjijita, ya jujasusungon jamyo? conieyo fan mague ni y lajimo. ");
INSERT INTO cha_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lao anae mámamamaela, y anite yinite papa ya guefninalaolao. Lao si Jesus jalalatde y espiritun áplacha ya janajomlo y patgon ya janatalo guato as tataña. ");
INSERT INTO cha_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ya todos ninafanman nu y minagas Yuus, lao mientras manmamanman todos pot todo estesija ni y jafatinas, ilegña ni disipuluña; ");
INSERT INTO cha_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Polo ya utatcalon gui talanganmiyo este sija na sinangan: sa umaentrega y Lajin taotao gui canae taotao sija. ");
INSERT INTO cha_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lao sija ti jatungo este na sinangan, ya manafaninatogüe para chañija tumutungo: ya manmaañao mafaesen güe ni ayo na sinangan. ");
INSERT INTO cha_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ya jumuyong manafaesen entre sija, jaye guiya sija udangculoña. ");
INSERT INTO cha_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lao si Jesus anae jaliija y jinason y corasonñija, jacone un patgon ya japolo gui bandaña, ");
INSERT INTO cha_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ya ilegña nu sija: Jaye y rumesibe este na patgon pot naanjo jaresibeyo; ya y rumesibeyo, jaresibe y tumagoyo; sa jaye y mas diquique guiya jamyo, ayo dangculo. ");
INSERT INTO cha_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ya manope si Juan ya ilegña: Maestro inlie uno na manyuyute juyong y manganite pot y naanmo; ya inchema sa ti jadadalalagjit. ");
INSERT INTO cha_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ya ilegña si Jesus ni sija; chamiyo chumochoma, sa ayo ni ti contra jamyo, guiya para jamyo. ");
INSERT INTO cha_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ya susede, anae mato y jaane nae jijot para umaresibe gui sanjilo; janameton y mataña para ujanao para Jerusalem, ");
INSERT INTO cha_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ya manago tentago sija na ufanmofona gui menaña; ya majanao manjalom gui un songsong Samaritano, para umanalistuye güe güije. ");
INSERT INTO cha_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ya ti maresibe güe, sa y mataña meton para ujananao para Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ya anae malie este ni disipuluña, si Santiago, yan si Juan, ilegñija: Señot, malago jao ya utafanmanago ya utunog guafe guinin y langet, ya ufanlinachae? ");
INSERT INTO cha_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ayonae jabira güe ya manlinalatde. ");
INSERT INTO cha_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ya manjanao para y otro songsong. ");
INSERT INTO cha_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ya anae manjajanao sija, un taotao ilegña nu güiya gui chalan: Señot, bae judalalagjao manoja y unjanao guato. ");
INSERT INTO cha_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ya ilegña si Jesus nu güiya: Y sora sija mangaeliyang, ya y pajaro sija gui langet mangaechenchon; lao y Lajin taotao taya sangaña ni anae para upolo y iluña. ");
INSERT INTO cha_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ya ilegña ni otro: Dalalagyo. Ya güiya ilegña; Señot, sottayo naya ya finenana jujanao ya jujafot si tatamo. ");
INSERT INTO cha_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lao ilegña nu güiya: Polo y manmatae ya ufanajafot y manmataeñija; lao jago janao ya unpredica y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ya ilegña locue otro; judalalagja jao Señot; lao sottayo naya ya judespideyo ni y mangaegue guiya jame. ");
INSERT INTO cha_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ya ilegña si Jesus: Ni uno ni pumopolo y canae gui alado ya uatan tateña ni y digno para y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ANAE munjayan este sija na güinaja, jaayig y Señot otro setenta, ya jatago dos en dos gui menaña para todo y siuda yan ayo na lugat anae para ufato güe. ");
INSERT INTO cha_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ya ilegña nu sija: Y cosecha megae, lao y manmachochocho didide; enaomina gagao y Señot y cosecha, ya ufanago ni manmachochocho para y cosechaña. ");
INSERT INTO cha_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Fanjanao gui chalanmiyo; estagüe na jutago jamyo taegüije quinilo gui entalo y lobo sija. ");
INSERT INTO cha_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Chamiyo fanmañuñule botsa ni maleta, ni sapatos: ni jaye insaluda gui jinanaonmiyo. ");
INSERT INTO cha_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Masqueseaja mano na guma nae manjalom jamyo, finenana in alog: Pas para este na guma. ");
INSERT INTO cha_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yaguin guaja güije patgon y pas, y pasmiyo usaga guiya güiya; yaguin taya, utalo guato guiya jamyo. ");
INSERT INTO cha_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fañaga güije na guma, fañocho yan infanguimen todo y manmanaenmiyo; sa y machochoeho ufanmerese nu y apasña. Chamiyo fanjajanao guma pot guma. ");
INSERT INTO cha_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ya masquesea mano na siuda nae manjalom jamyo, ya manmaresibe jamyo, cano jafa y manmasajyane jamyo. ");
INSERT INTO cha_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ya nafanjomlo y manmalango ni guaja güije, ya inalog nu sija: y raenon Yuus esta mato guiya jamyo. ");
INSERT INTO cha_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lao masqueseaja mano na suida nae manjalom jamyo, ya ti manmaresibe jamyo, fanjanao gui cayeñija, ya inalog: ");
INSERT INTO cha_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Asta y petbos ni jachetune y adengmame güine gui siudanmiyo, insacude contra jamyo; lao tingo este na y raenon Yuus mato jijot guiya jamyo. ");
INSERT INTO cha_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya jusangane jamyo: mas sungunon Sodoma güije na jaane qui ayo na siuda. ");
INSERT INTO cha_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ay! ay! jao Corasin: ay! ay! jao Betsaida! sa yaguin guiya Tiro yan Sidon nae manmafatinas este sija na mannamanman y manmafatinas guiya jamyo, jagas sen amco manmañotsot, infanmatachong gui silisio yan y apo. ");
INSERT INTO cha_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Enaomina mas sungunon Tiro yan Sidon qui para jamyo gui jaanin y sentensia. ");
INSERT INTO cha_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya jago Capernaum, unacajulo jao asta y langet? umachule papa asta sasalaguan. ");
INSERT INTO cha_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Y jumungog jamyo, jajungogyo; ya y dumesecha jamyo, jadesechayo; ya y dumesechayo, jadesecha y tumagoyo. ");
INSERT INTO cha_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ya manalo guato y setenta yan y minagofñija, ya ilegñija: Señot, asta y manganite insujejeta pot y naanmo. ");
INSERT INTO cha_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ya ilegña nu sija: Julie si Satanas taegüije y lamlam ni y pedong guinin y langet. ");
INSERT INTO cha_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Estagüe, na junae jamyo ninasiña para ingacha y culebla, yan y alacran, yan y jilo todo y ninasiñan y enemigo, ya taya siña munafanlamen jamyo. ");
INSERT INTO cha_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lao chamiyo ninafanmamagof pot este, pot y espiritu sija ni insujejeta; lao fanmagof jamyo pot y naanmiyo ni esta matugue gui langet. ");
INSERT INTO cha_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ya ayoja na ora magof si Jesus gui Espiritu Santo ya ilegña: Junae jao grasia, O Tata, Señot y langet yan y tano, sa unana este sija na güinaja gui manmejnalom yan manmanungo, ya unfanue gui mandiquique; junggan Tata, sa taegüine nae senmagof gui menamo. ");
INSERT INTO cha_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Todo y güinaja sija jagasja jaentregayo y Tatajo; ya taya tumungo jaye y Lajiña, na y Tataja; ya jaye y Tata, na y Lajiñaja, yan ayo y minalago y lajiña ufinanue. ");
INSERT INTO cha_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ya jabiragüe guato gui disipulo sija, ya ilegña: Mandichoso y atadog ni manmanlie nu estesija ni y liniinmiyo: ");
INSERT INTO cha_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sa jusangane jamyo, na megae na profeta yan ray sija, dumesesea na ulie nu estesija ni y liniinmiyo, ya ti malie; yan ujajungog nu estesija ni y jiningogmiyo ya ti jajungog. ");
INSERT INTO cha_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ya, estagüe, un magas y lay na tumojgue julo ya tinietientagüe, ya ilegña: Maestro, jafa jufatinas para juereda y taejinecog na linâlâ? ");
INSERT INTO cha_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ya ilegña nu güiya: Jafa matugue gui tinago? jafa untataetae? ");
INSERT INTO cha_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ya güiya manope, ilegña: Guaeya y Señot Yuosmo contodo gui corasonmo, yan contodo y antimo, yan contodo y minetgotmo, yan contodo y tiningomo; yan y tiguangmo taegüije iya jago namaesa. ");
INSERT INTO cha_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ya ilegña nu güiya: Mauleg inepemo: fatinas este, ya unlâlâ. ");
INSERT INTO cha_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lao güiya, malago na unatunas maesa güe, ilegña as Jesus: Ya jaye tiguangjo? ");
INSERT INTO cha_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ya inepe as Jesus ya ilegña: Un taotao tumunog guinin Jerusalem asta Jerico, ya podong gui entalo y manaque; y machule y magaguña ya manachetnudan güe, ya manjanao ya mapolo cana matae. ");
INSERT INTO cha_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ya susede na un pale tumunog güijeja na chalan; ya anae jalie malofanja gui otro banda. ");
INSERT INTO cha_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Taegüijeja locue un Lebita, anae mato jijot güije na lugat, ya jaatanja, ya malofanja gui otro banda. ");
INSERT INTO cha_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ya un Samaritano, anae jumajanao güije na chalan, mato lugat nae gaegue güe, ya anae jalie, ninamaase, ");
INSERT INTO cha_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ya mato guato guiya güiya jabee y chetnot sija ya janaye laña yan bino; ya janamaudae gui gaña gâgâ, ya jacone asta y guima publico ya jaadaje. ");
INSERT INTO cha_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ya y inagpaña güije anae para ujanao jachule dos denarion salape ya janae y magas y guima, ya ilegña nu güiya: Guesadaje güe; ya todo y palo na gastomo despues, yaguin tumaloyo mague, juapase jao. ");
INSERT INTO cha_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ya jaye y tiguang entre y tres, pot ayo y pedong gui entalo y manaque? ");
INSERT INTO cha_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ya güiya ilegña: Ayo y maase nu güiya. Ayonae ilegña Janao ya unfatinas locue taegüije. ");
INSERT INTO cha_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ya anae jumajanao, jumalom gui un songsong; ya un palaoan na y naanña si Marta rinesibegüe gui guimaña. ");
INSERT INTO cha_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ya guaja uno cheluña palaoan na y naanña si Maria, na locue matatachongja gui adeng Jesus, ya jaecungogja y sinanganña. ");
INSERT INTO cha_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lao si Marta esta inestotba pot megae sinetbeña, ya mato guiya güiya, ya ilegña: Señot, ada ti unlie y chelujo na upaloyo ya jufañeñetbeja na maesa? Tago ya uayudayo. ");
INSERT INTO cha_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ya inepe as Jesus ilegña nu güiya: Marta, Marta, esta jago inestotba ya guesmanadaje jao, pot megae na güinaja: ");
INSERT INTO cha_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lao unoja manesesita; ya si Maria jaayig ayo mauleg na patte ni ti umachule guiya güiya. ");
INSERT INTO cha_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","YA susede anae mananaetae güe gui un lugat, ya magpo, uno gui disipuluña ilegña nu güiya: Señot, fanagüejam manmanaetae, taegüije locue as Juan ni jafanagüe y disipuluña! ");
INSERT INTO cha_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ya ilegña na sija: Yaguin manmanaetae jamyo alog: Tata, Umatuna y naanmo. Umamaela y raenomo, ");
INSERT INTO cha_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Naejam pago cada jaane ni y nengcanomame. ");
INSERT INTO cha_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ya unasiijam ni isaomame; sa jame locue inasisie todo ayo y dumidibe jam. Ya chamojam pumopolo gui tentasion. ");
INSERT INTO cha_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ya ilegña nu sija: Jaye guiya jamyo y gaeamigo uno, ya ufinatoigüe gui tatalopuenge, ya ualog nu güiya: Amigo naayaoyo tres pan; ");
INSERT INTO cha_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Sa un amigojo mato guiya guajo guinin bumiaje, ya taya ni jafa para juplantaye gui menaña; ");
INSERT INTO cha_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ya ayo y gaegue gui sumanjalom ufanope, ya ualog: Chamo umatbororotayo; sa esta majuchom y petta, ya estagüejam gui cama yan y famaguonjo; ti siñayo cajulo ya junae jao. ");
INSERT INTO cha_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ya jusangane jamyo: Achogja ti ucajulo ya uninae pot y amiguña: lao pot y magagaoña, ucajulo ya unae jaftaemano y janesesita. ");
INSERT INTO cha_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ya jusangane jamyo: Gagao, ya infanmanae; aligao ya inseda; yajo, ya infanmababaye. ");
INSERT INTO cha_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sa jayeja y mangagao uresibe; ya y manaligao usoda; ya y manayajo, umababaye. ");
INSERT INTO cha_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Pat jaye guiya jamyo na tata, yan uguinagao ni y lajiña un pan, ya unnae un acho? pat un güijan ya enbes di güijan unnae culebla? ");
INSERT INTO cha_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pat yan guinagao un chada, ada unnae un alacran? ");
INSERT INTO cha_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pues ombre jamyo, ni y manaelaye, intingo numae mauleg na ninae y famaguonmiyo, cuanto mas y Tatanmiyo gui langet unae ni y Espiritu Santo todo ayo y gumagao güe? ");
INSERT INTO cha_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ya jayute juyong un anite na udo. Ya susede anae jumuyong este y anite, y ido cumuentos, ya y linajyan taotao sija ninafanmanman. ");
INSERT INTO cha_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ya palo guiya sija ilegñija: Pot si Beetsebub, ni magas y manganite, na jayuyuteja juyong y manganite sija. ");
INSERT INTO cha_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lao y pumalo matietientagüe, magagagao un señat gui langet. ");
INSERT INTO cha_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lao güiya jatungo y jinason ayo sija ya ilegña nu sija: Todo y raeno umadibide contra güiyaja, uyulang; ya y guima umadibide contra guma, upodong. ");
INSERT INTO cha_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yaguin si Satanas locue madibide contra güiya namaesa, jaftaemano y raenoña sumaga? Sa ilegmiyo na juyuyute juyong y manganite pot si Beetsebub. ");
INSERT INTO cha_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lao yaguin junajujuyong y manganite pot si Beetsebub, pot jaye y famaguonmiyo ufanyinite sija juyong? Enaomina sija ufanjues para jamyo. ");
INSERT INTO cha_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lao yaguin pot y calulot Yuus nae, juyuyute juyong y manganite, magajet na y raenon Yuus mato guiya jamyo. ");
INSERT INTO cha_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yaguin un taotao ni matatnga, ya jafamauleg y atmasña, ya japulan y guimaña: todo güinajaña, manseguro. ");
INSERT INTO cha_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lao anae mato otro na matatngaña qui güiya ya inañao, inamot ni atmasña anae jaangoco güe ya jafacae y güinajaña. ");
INSERT INTO cha_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ayo y ti jumujame, contra guajo yuje; ya ayo y ti rumecocoge guiya guajo machalapon. ");
INSERT INTO cha_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ya y espiritun áplacha, anae jumuyong gui taotao, jumajanao gui anglo na lugat, manaliligao dinescansa; ya anae ti mañoda, ilegña: Bae talo guato gui guimajo anae jumanaoyo. ");
INSERT INTO cha_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ya anae mato, jasoda mabale yan maadotna. ");
INSERT INTO cha_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ya jumanao ya mangone yan güiya otro siete espiritu mas manaelayeña qui güiya, ya jumalom ya sumaga güije: ya taelayeña y uttimoña ayo na taotao qui y finena. ");
INSERT INTO cha_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ya susede anae jasangan estesija, un palaoan gui linajyan taotao, umagang ilegña nu güiya: Dichoso ayo na tuyan y chumuchulejao, yan ayo na pecho y anae sumususo jao. ");
INSERT INTO cha_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lao güiya ilegña: junggan, lao dichosuña ayo y jumungog y sinangan Yuus, ya jaadaje. ");
INSERT INTO cha_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ya anae manetnon y linajyan taotao guiya güiya, jatutujon sumangan: Este na generasion manaelaye: manmanaliligao señat; lao ti ufanmannae nu señat mas na ayoja y señat Jonas. ");
INSERT INTO cha_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sa taegüije si Jonas y señat para y taotao Ninibe taegüijeja locue y Lajin taotao para güine na generasion. ");
INSERT INTO cha_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y raenan sanjaya cumajulo gui jaanin juisio yan y taotao este na generasion ya manquinendena; sa mato guinin y uttimon y tano para uecungog y minalate Salomon; ya estagüeja uno dangculoña qui si Salomon gaegue guine na lugat. ");
INSERT INTO cha_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y taotao sija guiya Ninibe, ufangajulo gui jaanin juisio yan este na generasion ya manquinendena; sa manmañotsot pot y prenedican Jonas; ya estagüe uno mas dangculoña qui si Jonas gaegue güine na lugat. ");
INSERT INTO cha_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Taya ni un taotao munaaatog gui bedega y candet ni esta masonggue, ni upolo gui papa ganta, sino y candelero para todo y manjajalom ujalie y manana. ");
INSERT INTO cha_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Y candet y taotao, y atadog; yaguin y atadogmo sensiyo todo y tataotaomo maninina; lao yaguin taelaye, y tataotaomo locue bula jomjom. ");
INSERT INTO cha_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Atan pues sa y manana ni y gaegue guiya jago, munga jomjom. ");
INSERT INTO cha_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Enao mina yaguin todo y tataotaomo bula manana, ni mano na lugat nae guaja jomjom, cabales na ubula manana, taegüije y yanguin malag ininaña y candet ya inina jao. ");
INSERT INTO cha_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ya mientras cumuecuentos, un Fariseo siniplicagüe na usija chumocho, ya jumalom ya matachong gui lamasa. ");
INSERT INTO cha_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lao y Fariseo ninamanman anae jalie este, pot y ti jafagase güe finena antes di uchocho. ");
INSERT INTO cha_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ya y Señot ilegña nu güiya: Pago jamyo ni Fariseo, y sumanjiyongja gui copa yan plato innagagasgas, lao y sumanjalommiyo bula inamot an tinaelaye. ");
INSERT INTO cha_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Manaejinaso jamyo, ada ayo y fumatinas gui sumanjiyong, ti güiya locue y fumatinas gui sumanjalom? ");
INSERT INTO cha_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lao todo y guajanmiyo naenñaejon limosña; ya estagüe na todo ufangasgas para jamyo. ");
INSERT INTO cha_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lao ay, ay jamyo Fariseo! ni infanmannae diesmos nu y yetba buena yan laruda yan todo golae; ya innafapos y tininas yan y güinaeyan Yuus. Estesija nesesita infatinas, sin pelo y pumalo. ");
INSERT INTO cha_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ay, ay jamyo Fariseo! sa ingüaeya etmas manaquilo na tachong gui sinagoga, yan y sinaluda sija gui metcado. ");
INSERT INTO cha_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ay ay jamyo! sa calang jamyo naftan ni ti malilie; ya y taotao sija manmalolofanja gui sumanjilo ya ti matungo. ");
INSERT INTO cha_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ya manope un magas y lay, ilegña nu güiya: Maestro, yaguin unsangan estesija unlatdejam locue. ");
INSERT INTO cha_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Lao güiya ilegña: Ay ay jamyo locue y manmagas y lay! sa innafanmangangatga y taotao sija ni ayo na catga y macat para uchule, ya ni un calolotmiyo innainete para inayuda. ");
INSERT INTO cha_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ay, ay jamyo! sa infatinas y naftan, y profeta sija, ya y tatanmiyo pumuno. ");
INSERT INTO cha_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Taegüine mantestigo jamyo, ya inconsienteja y checho y tatanmiyo; sa sija magajet pumuno, ya jamyo fumatinas y naftanñija. ");
INSERT INTO cha_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Enaomina ilegña y minalate Yuus: Bae managoyo profeta yan apostoles para sija; ya megae guiya sija inpino yan inpetsigue: ");
INSERT INTO cha_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sa guinin este na generasion manesesita machule y jâgâ todo y profeta, ni manmachuda desde y tutujon y tano; ");
INSERT INTO cha_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Desde jâgâ Abel, asta y jâgâ Sacharias, ni y matae gui entalo y attat yan y templo; magajet, jusangane jamyo na umanesesita machule guinin este na generasion. ");
INSERT INTO cha_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ay ay jamyo y manmagas y lay! sa innajanao y yaben tiningo; ya ti infanjalom jamyo yan y mangequejalom inchechema. ");
INSERT INTO cha_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ya anae jumuyong güije, y escribas yan y Fariseos sija, matutujon ma afuefuetsas ya macacase para usigue cumuentos megae; ");
INSERT INTO cha_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Maespipia, para umaquechule jafa guinin y pachotña. ");
INSERT INTO cha_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","YA ayo na tiempo, anae mandaña megae na mit na linajyan taotao, asta managacha uno yan otro; ya jatutujon sumangane y disipuluña sija finenana: Adaje jamyo ni y libaduran y Fariseo sija ni y hipocresia. ");
INSERT INTO cha_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sa taya na matatampe na ti umababa; pat mananana, na ti umatungo. ");
INSERT INTO cha_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Enaomina jafa guinin sinanganmiyo gui jemjom, umajungog gui manana; ya jafa y incuentuse gui talanga gui jalom aposento, umaagangnaejon gui jilo guma. ");
INSERT INTO cha_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ya jusangane jamyo ni y amigujo sija: Chamiyo fanmaaañao ni ayo sija y pumuno y tataotao, sa an munjayan ayo, taya jafa siña ujafatinas. ");
INSERT INTO cha_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lao jusangane jamyo jaye inmaañagüe: Fanmaañao jamyo ni ayo y yanguin munjayan japuno, guaja ninasiñaña na uyute asta sasalaguan: Junggan, jusangañe jamyo: Fanmaañao jamyo nu güiya. ");
INSERT INTO cha_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ada ti mabende sinco na pajaro, pot dos na octabo? ya ni uno guiya sija mamalefañaejon gui menan Yuus? ");
INSERT INTO cha_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lao asta y gaponulonmiyo esta manmatufong. Chamiyo fanmaaañao: sa manbaliña jamyo qui y megae pajaro. ");
INSERT INTO cha_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ya jusangane jamyo: Jayeja y comonfesatñaejonyo gui menan y taotao sija; uquinenfesatñaejon locue ni y Lajin taotao gui menan y angjet Yuus. ");
INSERT INTO cha_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lao ayo y pumuneyo gui menan taotao sija, siempre pune güe gui menan y angjet Yuus. ");
INSERT INTO cha_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ya jayeja y cumuentos contra y Lajin taotao, umaasie; lao y chumatfino contra Espiritu Santo, ti umaasie. ");
INSERT INTO cha_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ya anae manmacone jamyo gui menan y sinagoga sija, yan y manmagas, yan y gaesisiña, chamiyo madadaje jaftaemano yan jafa para inepe, ni jafa para insangan; ");
INSERT INTO cha_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sa y Espiritu Santo infanfinanagüe güije na ora jafa para insangan. ");
INSERT INTO cha_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ya uno gui linajyan taotao ilegña nu güiya: Maestro, tayo y chelujo ya ufacaeyo ni y erensia. ");
INSERT INTO cha_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Lao ilegña nu güiya: Taotao, jaye pumoloyo gui jilomo para jues, pat para mamacae? ");
INSERT INTO cha_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ya ilegña nu sija: Atan, ya inguesadaje jamyo ni y linagga: sa y linâlâ y taotao, ti guinin y manadan güinaja sija ni y jasagagaye. ");
INSERT INTO cha_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ya mansinangane un parabola, ilegña: y fangualuan un taotao na rico, jumujuyong megae na quineco. ");
INSERT INTO cha_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ya manjaso gui sumanjalomña, ilegña: Jafa jufatinas, sa taya mano nae jupolo y quinecojo. ");
INSERT INTO cha_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ya ilegña: Este bae jufatinas: bae jujala papa y lanchoco, ya jujatsa y mas dangculo; ya ayo nae jupolo todo y maiisso yan y güinajajo. ");
INSERT INTO cha_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ya jualog ni y antijo: Ante, megae güinajamo, para megae na sacan; descansa, ya unchocho, yan unguimen, yan unmagof. ");
INSERT INTO cha_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lao si Yuus ilegña nu güiya: Taejinaso jao! pago na puenge nesesita umachule y antimo: ya para jaye ayo sija na güinaja ni unnaetnon? ");
INSERT INTO cha_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Taegüenaoja y manaetnon y güinaja para güiyaja, ya ti urico para si Yuus. ");
INSERT INTO cha_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ya ilegña ni y disipoluña sija: Enaomina jusangane jamyo, Chamiyo madadaje pot y linâlânmiyo, jafa para incano; ni y tataotaonmiyo, jafa para innaminagago. ");
INSERT INTO cha_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sa y linâlâ mas qui y nengcano, ya y tataotao mas qui y magago. ");
INSERT INTO cha_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jaso y aga sija, na ti manmanananom, ni ufanmangoco; ni uguaja sagannengcanoñija ni lancho; ya si Yuus janachocho sija; ya cuanto mas manmauleg jamyo qui y pajaro! ");
INSERT INTO cha_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yan jaye guiya jamyo pot inadaje siña uaumenta un codo y linecaña? ");
INSERT INTO cha_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yanguin ti siña inchegüe y mas diquique, para jafa inadadaje y pumalo? ");
INSERT INTO cha_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Jaso y lirio sija, jaftaemano mandocoñiñija! ti manmachochocho, ni ufanmanjila; ya jusangane jamyo na si Salomon contodo y minalagña, ti minagago parejo yan uno guiya sija. ");
INSERT INTO cha_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yanguin si Yuus janafanminagago y chaguan qui fangualuan ni y gaegue pago, ya agupa esta mayute guato gui jetno; ti mas magajet na inninafanminagago jamyo, O jamyo didide na jinenggue? ");
INSERT INTO cha_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ya chamiyo umaliligao jafa para incano, ni jafa para inguimen, ni infanbuébuente gui jinasonmiyo. ");
INSERT INTO cha_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sa todo este sija na güinaja manmaaliligao ni y nasion sija gui tano: lao y tatanmiyo jatungoja na innesesita estesija na güinaja. ");
INSERT INTO cha_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lao aligao finena y raenoña; ya todo este sija na güinaja umanafandaña para jamyo. ");
INSERT INTO cha_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Chamiyo fanmaaañao, jamyo diquique na manada; sa este minagof y tatanmiyo, na infanninae ni y raeno. ");
INSERT INTO cha_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bende y güinajamo, ya unfannae. limosna; fanmamamauleg botsa ni ti ubijo, un güinaja gui langet na ti ufatta, anae ti usineda ni y saque, ni ti upotliya. ");
INSERT INTO cha_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sa manoja nae gaegue y güinajamo, ayoja nae gaegue locue y corasonmo. ");
INSERT INTO cha_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Polo ya esta madudog y senturanmiyo, ya esta masonggue y candet miyo; ");
INSERT INTO cha_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ya infanparejo yan ayo na taotao sija y jananangga y señotñija, yanguin tumalo guato guinin y guipot umasagua; sa para yanguin mato ya manyajo, umababaye enseguidas. ");
INSERT INTO cha_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mandichoso ayo sija na tentago, yanguin mato y señot, mansineda manbebela; magajet jusangane jamyo, na ududog güe, ya unafanmatachong para ufañocho, ya ufalag y sumanmena ya usetbe sija. ");
INSERT INTO cha_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ya yanguin ufato gui segundo na bela ya gui tetsero, ya mansineda sija taegüijeja, mandichoso ayo sija na tentago. ");
INSERT INTO cha_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Este tingo na yanguin y tata gui guima mojon jatungo jafa na ora nae ufato y saque, upulan ya ti upolo na umayulang y guimaña. ");
INSERT INTO cha_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Enaomina nafanlisto jamyo locue, sa ufato y Lajin taotao, güije na ora gui anae ti injajaso. ");
INSERT INTO cha_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ayonae ilegña si Pedro: Señot, unsangan este na acomparasion para jame, pat para todos? ");
INSERT INTO cha_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ya y Señot ilegña: Jaye nae ayo y mauleg yan mejnalom na mayetdomo, ni y ninamagas ni y señotña gui güinajana, para uninanae naña gui tiempoña? ");
INSERT INTO cha_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dichoso ayo na tentago y yanguin mato y señotña, sineda na jachochogüe taegüije. ");
INSERT INTO cha_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Magajet jusangane jamyo; na uninamagas gui jilo y güinajaña, todo. ");
INSERT INTO cha_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lao yanguin ayo na tentago y ilegña gui jalom corasonña: Y señotjo caeja mato; ya jatutujon pumanag y famalaoan na tentago, yan y lalaje; ya chumocho, yan gumimen, ya bumolacho; ");
INSERT INTO cha_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Y señot ayo na tentago, ufato güije na jaane gui anae ti jananangga, yan gui ora anae ti jatungo, ya uninasuja, ya uninafandaña y patteña yan y ti manmanjonggue. ");
INSERT INTO cha_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ya ayo na tentago y jatungo y minalago y señotña; ya ti jalisto güe, ni jafatinas jaftaemano y minalagoña, umasaulag megae. ");
INSERT INTO cha_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lao ayo y ti jatungo, ya jafatinas digno na umasauleg, lao didide masaulagña. Sa jayeja y megae manaiña, siempre megae uchule, ya jaye y megae catgoña, mas megae magagaoña. ");
INSERT INTO cha_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Matoyo para juyute y guafe gui jilo tano: ya jafa malagojo yanguin esta todo mañiñila? ");
INSERT INTO cha_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lao guaja tagpangeco para jumatagpange; ya jafa chachatsagajayo asta qui umacumple! ");
INSERT INTO cha_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Injajaso jamyo na matoyo para junae pas y tano? Jusangane jamyo, na aje; lao mas para inaguaguat. ");
INSERT INTO cha_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sa desde pago sigue mona, uguaja gui un guma sinco na ti manparejo, y tres contra y dos, ya y dos contra y tres. ");
INSERT INTO cha_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Y tata uaguaguat contra y lajiña, ya y laje contra y tata; ya y nana contra y jagaña, ya y jaga contra y nana; y suegra contra y yetna, ya y yetna contra y suegraña. ");
INSERT INTO cha_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ya ilegña locue ni y taotao sija: Yanguin inlilie y mapagajes na cajulo gui sumanlichan, siempre ilelegmiyo: Mamamaela y ichan; ya magajet. ");
INSERT INTO cha_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ya yanguin manguaefe y manglo sanjaya, ilelegmiyo: Uguaja maepe; ya ufato. ");
INSERT INTO cha_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Manhipocrita jamyo; intingo umegsamina y langet, yan y tano; ya jafa na ti intingo umegsamina y tiempo pago? ");
INSERT INTO cha_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ya jafa na ni jamyo ti injisga jafa y tinas? ");
INSERT INTO cha_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ya mientras jumanao jao yan y enemigumo para y magas, procura munaquelibre jao gui jinanaomo; na noseaja uninarastra guato gui jues, ya y jues uninentrega gui ofisiat, ya y ofisiat unpinelo gui calaboso. ");
INSERT INTO cha_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jusangane jao: Ti unjanao juyong güije, asta qui unapase y uttimo na marabidi. ");
INSERT INTO cha_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","YA mangaegue güije na tiempo taotao sija, ni masangane güe pot y Galileo sija, ni si Pilatos janadaña y jâgâñija yan y inefresenñija. ");
INSERT INTO cha_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ya si Jesus manope ya ilegña nu sija: Jinasonmiyo na este sija na Galileo, mas manisao qui todo Galileo sija na japadese ayo sija? ");
INSERT INTO cha_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jusangane jamyo na aje; sa yanguin ti manmañotsot jamyo, manparejoja jamyo manáchamalingo. ");
INSERT INTO cha_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pat ayo sija y diesiocho ni y podong y tore gui jiloñija guiya Siloe ya manpinino, jinasonmiyo na mas manisao ayo sija qui todo y taotao ni y mañasaga Jerusalem? ");
INSERT INTO cha_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jusangane jamyo na aje; sa yanguin ti manmañotsot jamyo, manparejoja jamyo manáchamalingo. ");
INSERT INTO cha_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ya jasangan este na acomparasion: Un taotao guaja y trongcon igos na matanme gui fangualuanña; ya anae mato para uegaga cao guaja tinegchaña, ti mañoda. ");
INSERT INTO cha_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ya ilegña ni y lancheruña: Esta guaja tres años ni matoyo güine na trongcon igos, manegagayo tinegcha, ya taya nae mañodayo; utut papa; para jafa na jaocucupa y tano? ");
INSERT INTO cha_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ya manope ilelegña nu güiya: Señot, polo pago na año ya juguadog y oriyaña, ya junaye estietcot: ");
INSERT INTO cha_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ya yanguin ufanogcha, mauleg; yanguin aje, siempre, unutut. ");
INSERT INTO cha_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ya estaba na mamananagüe gui un sinagoga, gui sabado na jaane. ");
INSERT INTO cha_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ya estagüe un palaoan, na guaja un espiritun malango guiya güiya esta diesiocho años, ya esta ninaojlo, ya tisiña tumacho. ");
INSERT INTO cha_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ya anae linie as Jesus, inagang ya ilegña nu güiya: Palaoan, libre jao gui malangumo. ");
INSERT INTO cha_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ya japolo y canaeña gui jiloña; ya enseguidas ninatunas, ya jaalaba si Yuus. ");
INSERT INTO cha_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lao y magas sinagoga lalalo sa si Jesus, numanajomlo gui sabado na jaane, ya manope ilegña nu y linajyan taotao sija: Guaja saes na jaane para ufanmachocho y taotao sija: ya este nae mauleg mato para numajomlo; lao ti y sabado na jaane. ");
INSERT INTO cha_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ayonae inepe ni y Señot, ya ilegña: Hipocrita jamyo, ada ti siña cada uno guiya jamyo upula y gaña guaca, pat asno gui pesebre, ya ucone ya unaguimen gui sabado na jaane? ");
INSERT INTO cha_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ya ti siña este na palaoan, ni y jagan Abraham, ni guinede as Satanas diesiocho años, manalibre gui magodeña, gui sabado na jaane? ");
INSERT INTO cha_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ya anae jasangan estesija, todo y enemiguña ninafan mamajlao; ya todo y taotao sija ninafanmagof, pot todo y sennamagof na güinaja ni y machogüe pot güiya. ");
INSERT INTO cha_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pot enao ilegña: Jafa parejuña y raenon Yuus? yan jafa nae juacompara? ");
INSERT INTO cha_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Parejo yan y granon y semiyan mustasa, ni y jachule y taotao, ya jatanme gui jalom jardinña; ya docó, ya jumuyong trongcon jayo; ya esta y pajaro sija gui langet mañaga gui ramasña. ");
INSERT INTO cha_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ya ilegña talo: Jafa nae juacompara y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Parejo yan y libadura, ni jachule un palaoan, ya janaatog gui tres medidan arina, asta qui todo manespongja. ");
INSERT INTO cha_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ya jumajanao gin chalaña, malag y siuda sija, yan y sengsong mamananagüe, ya jumajananao para Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ya ilegña uno nu güiya: Señot, didide manmasatba? si Jesus ilegña nu sija, ");
INSERT INTO cha_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Guefprocura mangejalom gui maiot na potta; sa jusangane jamyo na megae prumocucura mangejalom, lao ti mansiña. ");
INSERT INTO cha_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yanguin y magas y guima jayasja cajulo ya jajuchom y petta, ya intitujon jamyo manmanojgue gui sumanjiyong ya inyajo y petta, ya ilegmi miyo: Señot, babayejam: ya ufanope ya ualog nu jamyo: Ti jutungo manguinemano jamyo: ");
INSERT INTO cha_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ya intitujon umalog: Guinin mañochojam yan manguimenjam gui menamo, yan mamanagüe jam gui cayenmame. ");
INSERT INTO cha_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lao güiya ualog: Jusangane jamyo, na ti jutungo manguinemano jamyo: fañuja guiya guajo, todos jamyo ni y chumogüe y tinaelaye. ");
INSERT INTO cha_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ya ayonae uguaja cumasao, yan chegcheg nifen, yanguin inlie si Abraham, yan si Ysaac, yan si Jacob, yan todo y profeta sija, gui raenon Yuus; ya jamyo infanmachoneg juyong. ");
INSERT INTO cha_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ya ufanmato manguinen y sancatan yan y sanlichan, yan y sanlago yan y sanjaya; ya ufanmatachong gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ya estagüe na guaja manuttimo ya ufanfinenana, y guaja manfinenana ya ufanuttimo. ");
INSERT INTO cha_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ya ayo na ora, manmato Fariseo sija ya ilegñija nu güiya: Janao ya unsuja güine; sa malago si Herodes na unpinino. ");
INSERT INTO cha_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ya ilegña nu sija: Janao, sangane ayo na sora, na estagüe, na juyute juyong y anite sija, yan manaamteyo pago na jaane yan agupa, ya y mina tres na jaane ufonjayanyo. ");
INSERT INTO cha_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lao nesesita jufamocat pago yan agupa yan y inagpaña, sa ti siña na ufalingo y profeta gui Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jerusalem! Jerusalem! ni y unpuno y profeta sija, yan unfagas ni acho ayo sija y manmatago para güiya! cuanto biaje malagoyo na junafandaña y famaguonmo, taegüije y ponidera janafandaña y poyitasña gui papa papaña, ya timalago jamyo! ");
INSERT INTO cha_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Estagüe na manmapoluye jamyo ni y guimanmiyo taetaotao; ya jusangane jamyo: Ti inliiyo, asta qui mato ayo na tiempo anae inalog: Dichoso ayo y mamamaela ni y naan y Señot. ");
INSERT INTO cha_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","YA susede na anae jumalom gui guima un magas Fariseo, para uchocho pan, gui sabado na jaane, ya sija maespipiaja. ");
INSERT INTO cha_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ya, estagüe, un taotao gaegue gui menaña na malango binaya. ");
INSERT INTO cha_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ya manope si Jesus, ya jacuentuse manmagas y lay, yan y Fariseo sija, ilegña: Tunas numajomlo gui sabado na jaane pat aje? ");
INSERT INTO cha_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ya sija manmamatquiquiloja. Ayonae jacone güe, ya janajomlo, ya jasotta na ujanao. ");
INSERT INTO cha_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ya jaope sija ilegña: Jaye guiya jamyo, yanguin guaja gaña asno pat guaca, podong gui jalom tupo, ada ti enseguidas ujatsa gui sabado na jaane? ");
INSERT INTO cha_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ya ti siña talo manmanope ni estesija. ");
INSERT INTO cha_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ya jasangan un acomparasion ni y manmaconbida, anae jaatituye ni y jaayig y mas managquilo na tachong gui lamasa; ya ilegña nu sija: ");
INSERT INTO cha_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Yanguin quinenbida jao ni un taotao para y guipot, chamo fatatachong gui mas tagquilo na tachong; sa ufato otro na mas onrao qui jago, ni y quinenbidaña locue; ");
INSERT INTO cha_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ya ufato y cumonbida jao ya ualog nu jago: Nae este lugat y este taotao; ya ayonae untutujon mumamajlao yanguin sumaga jao gui mas uttimo na lugat. ");
INSERT INTO cha_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lao yanguin quinenbida jao, janao ya fatachong gui mas tagpapa na lugat; sa yanguin mato y cumonbida jao, ualog nu jago: Amigo, janao falag iya jululo; ya ayonae unguaja inenra gui menan ayo sija y mangachongmo ni y manmatachong gui lamasa. ");
INSERT INTO cha_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sa jayeja y manataquilo maesa güe, unaumitde güe ya y umunaumitde güe, umanataquilo. ");
INSERT INTO cha_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ya ilegña nu ayo y guinin cumonbida güe: Yanguin mamatinas jao nataloane pat sena, chamo umagagange y manamigumo sija, ni y mañelumo, ni y manparientesmo, ni y manrico na tiguangmo; sa noseaja unmaconbida locue talo, ya unmaapase. ");
INSERT INTO cha_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lao yanguin gumupot jao, agange y mamoble, yan y manmanco yan y mancojo, yan y manbachet; ");
INSERT INTO cha_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ya undichoso; sa ti siña maapase jao; lao unmaapase gui quinajulo y manunas. ");
INSERT INTO cha_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ya anae jajungog este, uno gui mangachongña ni y manmatachong gui lamasa, ilegña nu güiya: Dichoso ayo y uchocho pan gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lao ilegña nu güiya: un taotao jafatinas un dangculon sena, ya mangonbida megae: ");
INSERT INTO cha_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ya jatago y tentagoña gui oran sena, na ualog ni ayo sija y manmaconbida: Nije; sa esta todo listo. ");
INSERT INTO cha_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ya jatutujon cada uno umescusa güe. Y fenenana ilegña: Mamajanyo un pidason tano, ya nesesitayo jujanao ya julie; jugagao jao na unescusayo. ");
INSERT INTO cha_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ya y otro ilegña: Mamajanyo sinco pares na nobiyo para mancareta, ya bae jujanao ya juchague: jugagao jao na unescusayo. ");
INSERT INTO cha_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ya y otro ilegña: Umasaguayo, ya enaomina ti siñayo mato. ");
INSERT INTO cha_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ya tumalo guato y tentago, ya janatungo y senotña nu este sija. Ayo nae y magas y guima ninagoslalalo, ya ilegña ni y tentagoña: Janao, lasajyao falag y caye sija yan y chalan gui siudad, ya uncone mague y mamoble, yan y mancojo, yan y manbachet, yan y manmanco. ");
INSERT INTO cha_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ya ilegña y tentago: Señot, esta mafatinas y tinagomo, ya trabia guaguajaja lugat. ");
INSERT INTO cha_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ya y señot ilegña ni y tentagoña: Janao falag y dangculo na chalan yan y lugat ni y guaja ngangao, ya unafuetsas sija, ya ufanjalom para ubula y guimajo. ");
INSERT INTO cha_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sa jusangane jamyo, na ni uno güije sija gui guinin manmaconbida, uchague y senajo. ");
INSERT INTO cha_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ya mañisija mangaegue yan un dangculon manadan taotao; ya jabira güe, ya ilegña nu sija: ");
INSERT INTO cha_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Achogja un taotao mato guiya guajo, ya ti jachatlie si tataña, yan si nanaña, yan y asaguaña, yan y famaguonña, yan mañeluña lalaje, yan y mañeluña famalaoan, yan y linâlâña locue, ti siñagüe disipulujo. ");
INSERT INTO cha_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ya jayeja y ti cumatga y quiluusña, ya dumalalag yo; ti siñagüe disipulojo. ");
INSERT INTO cha_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sa jaye guiya jamyo, ujaso manjatsa un tore, ya ti ufatachong finena ya utufong y para gastoña cao siña uninafunjayan? ");
INSERT INTO cha_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sa noseaja yanguin esta japolo y simiento, ya ti siña janafunjayan; todo y lumie jatutujon manmanbotlea nu güiya, ");
INSERT INTO cha_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ylegñija: Este na taotao jatutujon manjatsa, ya ti siña janafunjayan. ");
INSERT INTO cha_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pat jaye y ray, anae jajanao para uguera contra y otro ray, ti ufatachong finena, ya ufañangane cao siña güe yan y dies mit, utagam y mamamaela yan veinte mit contra güiya? ");
INSERT INTO cha_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Patseno, mientras chachagoja y otro trabia, janajanao un compañia, ya ufangagao pas. ");
INSERT INTO cha_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Taegüenaoja locue; masquesea jaye guiya jamyo y ti rumechasa todo y güinajaña; ti siñagüe disipulujo. ");
INSERT INTO cha_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Y asiga mauleg; lao yanguin malingo y asiga maasenña, jaftaemano manasne? ");
INSERT INTO cha_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ti mauleg para y tano, ni para fanyútian basula; masenyuteja ni y taotao. Jaye y gaetalanga para ufanjungog, güiya uecungog. ");
INSERT INTO cha_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","YA manjijijot guato guiya güiya, todo y publicano, yan y manisao, para umaecungog güe. ");
INSERT INTO cha_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ya mangogonggong y Fariseo sija, yan y escriba ilelegñija: Este na taotao, jaresisibeja y manisao, ya mañisijaja mañocho. ");
INSERT INTO cha_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ya jasangane sija ni este na acomparasion, ilegña: ");
INSERT INTO cha_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Jaye na taotao guiya jamyo, y yanguin guaja gaña siento na quinilo, ya ufinalingaeguan ni y uno, ada ti ujanao ya udingo y nobentainuebe gui desierto asta qui jasoda ayo y malingo? ");
INSERT INTO cha_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ya anae jasoda, jaapagaye ya jamagogofgüe. ");
INSERT INTO cha_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ya anae mato gui guimaña, jaagange todo y manamiguña, yan y tignangña, ya ilelegña nu sija: Nije tafanmagof, sa jagasja jusoda y gajo quinilo ni y guinin malingo. ");
INSERT INTO cha_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jusangane jamyo, na taegüenaoja locue uguaja gui langet, minagof yanguin un taotao na isao mañotsot, mas qui y nobentainuebe manunas na taotao ni y ti janesesita manmañotsot. ");
INSERT INTO cha_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pat, jaye na palaoan, y yanguin uguaja iyoña dies na pidason salape, ya ufinalingaeguan ni y uno; ada ti usonggue y candet ya ubale y jalom guma, ya uguesaligao asta qui usoda? ");
INSERT INTO cha_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ya yanguin esta jasoda, jaagange y manamigaña, yan y tiguangña ya mandaña, ya ilelegña: Nije tafanmagof, sa jagasja jusoda y pidason salape ni y guinin malingo. ");
INSERT INTO cha_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Taegüenaoja locue jusangane jamyo, na uguaja minagof gui menan y angjet Yuus, pot y un taotao na isao ni y mañotsot. ");
INSERT INTO cha_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ya ilegña: Un taotao guaja dos lajiña: ");
INSERT INTO cha_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ya y mas patgon, ilegña as tataña: Tata, naeyo ni y patteco gui güinaja ni y para guajo. Ya jafacae para sija ni y güinajaña. ");
INSERT INTO cha_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ya ti megae na jaane malofan, anae y mas patgon janafandaña todo, ya mapos asta y chago na tano; ya jagasta todo y güinajaña güije gui guipot yan bisio di gula. ");
INSERT INTO cha_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ya anae jagasta todo esta: mato un dangculon ñinalang güije na tano, ya jatutujon taena. ");
INSERT INTO cha_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ya jumanao, ya jatituye gui un taotao güije na tano: ya tinago para y fangualuanña, para unachocho babue sija. ");
INSERT INTO cha_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ya jatatanga na unabula tiyanña ni y lasas frijoles ni y jacacano y babue sija; ya taya ni un taotao numanaegüe. ");
INSERT INTO cha_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ya anae numalo y jinasoña, ilegña: Cuanto na jotnaleron tata, mangaena pan, ya manmañoñobblaja, ya guajo güine jumatae ñalang! ");
INSERT INTO cha_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bae jucajulo ya jujanao para as tata, ya jualog nu güiya: Tata, umisaoyo contra y langet, yan contra jago, ");
INSERT INTO cha_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ti dignoyo mas na jumafanaan lajimo: naparejoyo yan y jotnalerumo sija. ");
INSERT INTO cha_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ya cajulo, ya mapos para as tataña. Lao chagoja trabia, si tataña linie güe, ya ninamaase, ya finalagüe, ya tinegtog, ya chinicogüe. ");
INSERT INTO cha_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ya y patgon ilegña as tataña: Tata, umisaoyo contra y langet, yan contra jago; ti dignoyo mas na jumafanaan lajimo. ");
INSERT INTO cha_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lao y tata ilegña ni y tentagoña sija: Chule y mas mauleg na magago ya umanaminagago; ya umapolo y aniyu gui calolotña, yan y sapatos gui adengña: ");
INSERT INTO cha_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ya umacone mague un tatnero ni y mas yomog, ya umapuno ya tafañocho ya tafanmagof; ");
INSERT INTO cha_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sa este y lajijo guinin matae, ya lâlâ talo; guinin malingo, ya masoda. Ya jatutujon sija manmagof. ");
INSERT INTO cha_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ya y lajiña ni y mas amco estaba gui fangualuan; ya anae guaguato ya esta jijot gui guima, jajungog y dandan yan y manbabaila: ");
INSERT INTO cha_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ya jaagang uno gui tentago sija, ya jafaesen jafa ayo sija. ");
INSERT INTO cha_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ya ilegña nu güiya: Y chelumo mato; ya si tatamo japuno y tatnero ni y mas yomog, sa jaresibe gae seguro yan sano. ");
INSERT INTO cha_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ya ninagoslalalo, ya ti malago jumalom: ayonae jumuyong si tataña, ya siniplica na ujalom. ");
INSERT INTO cha_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ya manope ilegña as tataña: Estagüe, megae na año nae jusesetbe jao, ya taya nae ti jaosgue jafa na tinagomo: lao taya nae unnaeyo un patgon chiba para infanmagof yan y manamigujo sija: ");
INSERT INTO cha_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lao anae mato este na lajimo ni y jalachae todo y güinajamo gui manputa sija; unpunueja ni y mas yomog na tatnero. ");
INSERT INTO cha_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ya ilegña nu güiya: Lajijo, siempre jumijitaja; ya todo y güinajajo iyomo. ");
INSERT INTO cha_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lao mauleg para utafanmagof ya utafanalegria: sa este y chelumo guinin matae, ya lâlâ talo; yan guinin malingo, ya esta masoda. ");
INSERT INTO cha_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","YA ilegña locue ni y disipuluña sija: Guaja un taotao na rico, ya guaja mayetdomuña; ya este mafaaela guiya güiya na jagasta y güinajaña. ");
INSERT INTO cha_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ya janamaagange, ya ilegña nu güiya: Jafa este y jujujungog guiya jago? Fannae cuenta pot y mayetdomumo, sa ti siña jao mumayetdomo mas. ");
INSERT INTO cha_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ayonae y mayetdomo, ilegña gui sumanjalomña: Jafa jufatinas? sa y señotjo unajanaoyo gui mayetdomujo: Taya minetgotto para ufanguadog; mamajlaojo umogagao. ");
INSERT INTO cha_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jutungo esta jafa jufatinas, para yanguin manajanaoyo gui mayetdomujo, jumaresibeyo gui guimañija. ");
INSERT INTO cha_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ya jaagang cada uno gui manmadidibe ni y señotña, ya ilegña ni y finenana: Cuanto undidibe y señotjo? ");
INSERT INTO cha_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ya ilegña: Siento na medidan laña. Ayonae ilegña nu güiya: Chule y cuentamo ya unfatachong guse ya untugue sincuenta. ");
INSERT INTO cha_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ya ilegña talo ni y otro: Ya jago, cuanto dibimo? Ilegña: Siento na medidan trigo. Ylegña talo: Chule y cuentamo ya untugue ochenta. ");
INSERT INTO cha_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ya jaalaba y señot y taelaye na mayetdomo; sa pot y jagostungo chumogüe: sa y famaguon este na tano, manmejnalomña y generasionñija, qui y famaguon y manana. ");
INSERT INTO cha_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ya jusangane jamyo: Fanmamamauleg amigonmiyo pot y güinajan y timanunas; sa yanguin manfatta jamyo, infanrinesibe gui taejinecog na saganñija. ");
INSERT INTO cha_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ya y tunas gui didide, tunasja locue gui megae; ya y ti tunas gui didide, ti tunasja locue gui megae. ");
INSERT INTO cha_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yanguin ti guinin manunas jamyo gui ti magajet na güinaja, jaye infaninangoco gui magajet na güinaja? ");
INSERT INTO cha_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ya yanguin ti guinin manunas fiet jamyo gui iyon y otro taotao, jaye infanninae ni y iyonmiyo? ");
INSERT INTO cha_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni un tentago siña jasetbe dos na señot: sa uchatlie y uno, ya uguaeya y otro; pat atituye gui uno, ya udespresia y otro. Ti siña jamyo insetbe si Yuus, yan y güinaja. ");
INSERT INTO cha_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ya y Fariseo sija locue, ni y mangasalape, majungog este sija; ya mabotlea güe. ");
INSERT INTO cha_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ya ilegña si Jesus nu sija: Jamyo yuje sija y innafanunas maesa jamyo gui menan y taotao sija; lao si Yuus jatungoja y corasonmiyo: sa ayo y guesmaguaeya gui entalo y taotao sija y chinatlie para y menan Yuus. ");
INSERT INTO cha_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Y lay, yan y profeta sija, mangaegue asta as Juan: ya desde ayo na tiempo y raenon Yuus mapredicañaejon, ya todoja jumalom nu y finijon. ");
INSERT INTO cha_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lao guseña malofan y langet yan y tano, qui na un pidasito gui lay ufatta. ");
INSERT INTO cha_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Todo ayo y dumingo y asaguaña, ya umasagua yan otro, jafatinas y abale; ya y umasagua ayo na palaoan ni y diningo ni y asaguañalaje, jafatinas y abale. ");
INSERT INTO cha_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Guaja un taotao na rico, na minagagagoja putpura, yan y guesmauleg na magago apaca, ya cada jaane gumupupot. ");
INSERT INTO cha_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ya guaja locue un pobble na umógagao limosna, y naanña si Lasaro, na bula chetnot, ni y estaba mapolo gui pettan y rico. ");
INSERT INTO cha_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ya malagogüe na umanachocho ni ayo y andesmoronan ni y mamopodong gui lamasan y rico; ya asta y galago manmato ya manmanjójoflag y chetnotña. ");
INSERT INTO cha_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ya despues, matae y pebble ni y umógagao limosna, ya macone ni y angjet sija asta y pechon Abraham; matae locue y rico na taotao, ya majafot; ");
INSERT INTO cha_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ya y ya sasalaguan, jajatsa y atadogña, anae estaba gui sinapet, ya jalie si Abraham na chago, yan si Lasaro gui pechoña. ");
INSERT INTO cha_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ya umagang ilegña: Tata Abraham, gaease nu guajo, ya tago si Lasaro, para usupog y puntan calolotña gui janom ya unafresco y jilajo; sa estagüe na masasapetyo güine na mañila. ");
INSERT INTO cha_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lao si Abraham ilegña: Laje, jaso na anae lalâlâ jao unresibe todo y manmauleg na güinajamo; taegüenaoja locue si Lasaro jaresibe y manaelaye na güinaja: lao pago, güiya mamagof güine, ya jago masasapet. ");
INSERT INTO cha_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ya gui todo estesija; esta mapolo fitme gui entalota un dangculon joyo na chojfe, para todo y manmalago manmalofan güine asta iya jamyo ti ufansiña; ni ufanmalofan y manmalago güenao manmalag iya jamyo. ");
INSERT INTO cha_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ayonae ilegña: Pues jutayuyut jao tata, tago güe para y guima tata; ");
INSERT INTO cha_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sa guajayo sinco mañelujo lalaje; para usangane sija testimonio; ni noseaja ufanmamaela locue güine gui sinapet na lugat. ");
INSERT INTO cha_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Lao si Abraham ilegña: Gaegueja si Moises yan y profeta sija, polo ya ujaecungogja. ");
INSERT INTO cha_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ya ilegña: Aje, tata Abraham; sa yanguin uno ni y guinin manmatae jumanao para iya sija, ufanmañotsot. ");
INSERT INTO cha_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ya ilegña nu güiya: Yanguin ti maecungog si Moises, yan y profeta sija; ti ufanmaosgon achogja uguaja cajulo guinin y manmatae. ");
INSERT INTO cha_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","YA ilegña ni y disipuluña sija: Ti siña ti ufato y escandalo; lao ay, ay ayo y munafato! ");
INSERT INTO cha_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maulegña na umagode gui agagaña un alutong, ya umayute gui tase, antes qui uninaquepodong uno güine gui mandiquique sija. ");
INSERT INTO cha_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Adaje jamyo: Yanguin umisao y chelumo contra jago, reprende: y yanguin mañotsot, asie. ");
INSERT INTO cha_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yanguin siete biaje gui un jaane umisao contra jago, ya siete biaje mafato guiya jago, ya ilelegña: Mañotsotyo, un asie. ");
INSERT INTO cha_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ya y apostoles, ilegñija nu y Señot: Aumenta, y jinengguenmame. ");
INSERT INTO cha_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ya y Señot ilegña: Yanguin mangaejinenggue jamyo taegüije y granon mostasa, ya mojon ilegmiyo nu este na sicómoro trongcon jayo: Chapag jao güenao, ya unplanta jao gui tase; ya mojon infaninesgueja. ");
INSERT INTO cha_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lao jaye guiya jamyo y guaja tentagoña, na manalalado, pat mamamasto quinilo, y yanguin mato guinin y fangualuan, ualog nu güiya; maela enseguidas y fatachong, ya unchocho? ");
INSERT INTO cha_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ya ti ualog nu güiya finena: Nalisto y senajo para juchocho, ya undudog jao, ya unsetbeyo asta qui munjayanyo chumocho, yan gumimen: ya despues nae unchocho, ya unguimen? ");
INSERT INTO cha_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Numae grasias ayo na tentago, sa jafatinas y matagoña? Jinasoco na aje. ");
INSERT INTO cha_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Taegüineja locue jamyo, yanguin esta inchegüe todo ayo sija y jutago jamyo, ualog: Maninutil jam na tentago; sa ayoja y para y chechomame inchegüe. ");
INSERT INTO cha_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ya susede anae jumanao para Jerusalem, ya malofan gui inanaco Samaria, yan Galilea. ");
INSERT INTO cha_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ya anae jumalom gui un songsong, manasoda güije yan dies na taotao na manategtog; ya manojgue desde y chago. ");
INSERT INTO cha_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ya jajatsa y inagangñija, ya ilegñija: Jesus, Maestro, gaease nu jame. ");
INSERT INTO cha_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ya anae jalie, ilegña nu sija: Janao ya infanue y mamale nu jamyo. Ya susede anae manjajanao, manjuyong mangasgas. ");
INSERT INTO cha_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ya y uno guiya sija, anae jalie na jomlo güe, jabira güe tate, ya janaagagang mannae si Yuus minalag. ");
INSERT INTO cha_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ya jatomba güe papa gui fion adeng si Jesus, ya janae grasias: este na taotao, Samaritano. ");
INSERT INTO cha_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ya manope si Jesus, ilegña: Ada ti dies y mangasgas? ya manmangue y nuebe? ");
INSERT INTO cha_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Taya masoda tumalo mague para unae si Yuus grasias, na esteja y taotao juyong. ");
INSERT INTO cha_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ya ilegña bu güiya: Cajulo ya unjanao; y jinengguemo munajomlo jao. ");
INSERT INTO cha_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ya anae mafaesen ni y Fariseo sija, ngaean nae ufato y raenon Yuus, jaope ilegña: Y raenon Yuus, ti matungo finatoña. ");
INSERT INTO cha_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni ujaalog: Estagüe! pat ayogüe! sa y raenon Yuus, gaegueja gui sumanjalommiyo. ");
INSERT INTO cha_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ya ilegña ni y disipuluña sija: Ufato y jaane sija, na infanmalago na inlie uno gui jaanin y Lajin taotao, ya ti inlie. ");
INSERT INTO cha_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ya ujaalog nu jamyo: Estagüe, pat ayogüe; chamiyo tumatitiye, ni indalalaque sija. ");
INSERT INTO cha_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sa taegüijeja y lamlam, yan mañila gui un lugat gui papa y langet, ya inina y otro banda gui papa y langet; taegüineja locue y Lajin taotao, gui jaaniña. ");
INSERT INTO cha_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lao nesesita na ufamadese finena megae, ya umarechasa ni este na generasion. ");
INSERT INTO cha_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sa jaftaemanoja y jaanin Noe, taegüijeja locue y jaanin y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mañocho, yan manguimen, yan manasagua, yan manafanasagua, asta ayo na jaane anae jumalom si Noe gui atca, ya mato y dilubio ya manyinilang sija todo. ");
INSERT INTO cha_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Taegüineja locue jasusede gui jaanin Lot: mañocho, manguimen, manmamajan, manmanbende, manmananom, yan manmanjatsa guma; ");
INSERT INTO cha_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lao ayoja na jaane anae jumanao si Lot guiya Sodoma, janauchan guafe, yan asufre guinin y langet, ya manyinilang todo sija. ");
INSERT INTO cha_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Taegüijeja uguaja güije na jaane yanguin ufamanue y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ayo na jaane, ayo y gaegue gui jilo guma ya y güinajaña gaegue gui jalom guma, chaña tumutunog ya uchule; parejoja locue yan y gaegue gui fangualuan, chaña tumatalo tate. ");
INSERT INTO cha_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jaso y asaguan Lot. ");
INSERT INTO cha_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Masquesea jaye y umaliligao na usatba y linâlâña, ufinalingaeguan; ya masquesea jaye y finalingaeguan y liânâlña umasatba. ");
INSERT INTO cha_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jusangane jamyo, na ayo na puenge uguaja dos na taotao gui un catre; y uno umacone ya y otro umapolo. ");
INSERT INTO cha_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dos na palaoan dumadaña manguleg; y uno umacone, ya y otro umapolo. ");
INSERT INTO cha_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dos na taotao ugaegue gui fangualuan; y uno umacone, ya y otro umapolo. ");
INSERT INTO cha_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ya manmanope ilegñija nu güiya: Manggue Señot? Ya jaope ilegña: Manoja nae gaegue y tataotao, ayoja nae mandaña y pojaro aguila sija. ");
INSERT INTO cha_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","YA jasangane un acomparasion, na y taotao sija janesesita ufanmanayuyut, ya chañija fanataeanima. ");
INSERT INTO cha_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ilelegña: Guaja gui un siuda un jues, na ti maañao as Yuus, ni urespeta ni jaye na taotao: ");
INSERT INTO cha_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ya guaja locue güije na siuda un biuda ni y mato guiya güiya ya ilelegña: Areglajam yan y enemigujo. ");
INSERT INTO cha_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ya ti malago finena; lao despues ilegña gui sumanjalomña: Achogja ti maañaoyo as Yuus, ni jufanrespeta taotao; ");
INSERT INTO cha_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Lao pot y jarorobayo este na palaoan, bae juaregla sija, sa noseaja pot y sisigueja mague, uestotbayo. ");
INSERT INTO cha_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ya y Señot ilegña: Ecungog jafa y ti tunas na jues ilelegña. ");
INSERT INTO cha_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ada ti unalibre si Yuus y inayigña, ni y maaagang güe jaane, yan puenge, ya apmam na jasungon pot sija? ");
INSERT INTO cha_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jusangane jamyo, na enseguidas unafanlibre. Lao anae ufato y Lajin taotao, ufañoda jinenggue gui jilo tano? ");
INSERT INTO cha_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ya jasangan este na acomparasion ni ayo sija y umangocon maesa sija na manunas, ya jadespresia y pumalo: ");
INSERT INTO cha_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Dos na taotao jumanao julo gui templo para ujafanaetae: Y un Fariseo, ya y otro publicano. ");
INSERT INTO cha_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Y Fariseo tumojgue, ya taegüine tinaetaeña gui sumanjalomña: Junae jao grasias Yuus, sa ti parejoyo yan y pumalo na taotao, ni y manáplacha, yan manábale, ni y este publicano. ");
INSERT INTO cha_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Umayuyunatyo dos biaje gui semana; mannanaeyo diesmos ni y todo güinajajo. ");
INSERT INTO cha_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lao y publicano gaegue na tumotojgue gui chago; ya ti jaguesjatsa y atadogña julo gui langet; lao jaseseco y pechoña, ya ilelegña: Yuus, gaease nu guajo, sa taotao isaoyo. ");
INSERT INTO cha_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jusangane jamyo, na, este na taotao jumanao papa y guimaña, ya maasie y isaoña, mas mauleg qui y otro; sa cada uno y minadangculo güe, uninaumitde; ya y munamitde güe, umanadangculo. ");
INSERT INTO cha_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ya maconie guato guiya güiya ni y diquique na famaguonñija, para upacha; ya anae manlinie ni y disipulo sija, manmalalatde. ");
INSERT INTO cha_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lao si Jesus jaagang sija, ya ilegña: Polo y diquique na famaguon ya ufanmamaela guiya guajo, ya chamiyo chumochoma; sa iyon este sija y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Magajet jusangane jamyo, na y ti rumesibe y raenon Yuus taegüije y diquique na patgon, ti ujalom güije. ");
INSERT INTO cha_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ya un taotao na magas, finaesen güe ilelegña: Mauleg na Maestro, jafa jufatinas para juereda y taejinecog na linâlâ? ");
INSERT INTO cha_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ya si Jesus ilegña nu güiya: Jafa na ilegmo nu guajo mauleg? taya mauleg na unoja, si Yuus. ");
INSERT INTO cha_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Utungo y tinago sija: Chamo umábale, Chamo famumuno, Chamo fañañaque, Chamo sumasangan y ti magajet na sinangan, Onra si tatamo, yan nanamo. ");
INSERT INTO cha_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ya ilegña: Todo este sija juadaje desde y pinatgonjo. ");
INSERT INTO cha_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Anae jajungog este sija si Jesus, ilegña nu güiya: Guaja uno fattamo trabia: bende todo y güinajamo, ya unfacae y mamobble, ya uguaja güinajamo gui langet, ya maela dalalagyo. ");
INSERT INTO cha_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lao anae jajungog estesija, ninágostriste; sa gosrico güe. ");
INSERT INTO cha_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ya anae linie as Jesus, ilegña: Namanminapot ayo sija y mangaegüinaja manjalom gui raenon Yuus! ");
INSERT INTO cha_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sa guseña malofan un cameyo gui matan y jaguja, qui ujalom un rico gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ya ayo y jumungog, ilegñija: Jaye nae siña satbo? ");
INSERT INTO cha_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ya ilegña: Y güinaja ni y ti mansiña para y taotao sija; mansiña para as Yuus. ");
INSERT INTO cha_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ayonae ilegña si Pedro: Estagüeja na indingo y iyonmame, ya indalalag jao. ");
INSERT INTO cha_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ya ilegña nu sija: Magajet jusangane jamyo, na taya ni un taotao ni y dumingo guma, pat asagua, pat mañelu, pat mañaena, pat famaguon, pot y raenon Yuus, ");
INSERT INTO cha_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ya ti uresibe mas megae pago na tiempo, lao y mamamaela na tiempo, taejinecog na linâlâ. ");
INSERT INTO cha_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ya jacone y dose, ya ilegña nu sija: Estagüe, na manjajanaojit julo Jerusalem, ya todosija y tinigue y profeta sija pot y Lajin taotao, ufanmacumple. ");
INSERT INTO cha_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sa nesesita na umaentrega gui taotao juyong, ya umabotlea, yan umafaesegnane, yan umatolae: ");
INSERT INTO cha_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ya umasaulag, ya umapuno; ya y mina tres na jaane, ucajulo talo. ");
INSERT INTO cha_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lao sija ti jatungo ni uno gui este sija: ya este na sinangan manaatog guiya sija, ya ni ti jatungo jafa sija y masangan. ");
INSERT INTO cha_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ya susede anae esta jijijot Jerico, estaba un taotao bachet gui oriyan chalan na matatachong, ya umógagao: ");
INSERT INTO cha_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ya anae jajungog y linajyan taotao na manmalolofan, mamaesen jafa ayo. ");
INSERT INTO cha_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ya masangane güe, na si Jesus Nasareno malolofan. ");
INSERT INTO cha_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ya umagang ilelegña: Jesus, jago ni y Lajin David, gaease nu guajo. ");
INSERT INTO cha_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ya machoma ni y manmofona para ufamatquilo: lao mas umagang megae: Jago ni y Lajin David, gaease nu guajo. ");
INSERT INTO cha_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ya tumojgue si Jesus, ya manago na umaconie guato guiya güiya: ya anae esta jijijot, finaesen: ");
INSERT INTO cha_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Jafa malagomo jufatinas guiya jago? Ya güiya ilegña: Señot, para jufanlie. ");
INSERT INTO cha_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ya ilegña si Jesus nu güiya: Fanlie: y jinengguemo unsinatba. ");
INSERT INTO cha_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ya enseguidas jaresibe y liniiña, ya jadalalag güe, yan janamalag si Yuus; yan todo y taotao sija, anae malie, maalaba si Yuus. ");
INSERT INTO cha_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","YA jumalom si Jesus, ya malofan inanaco Jerico. ");
INSERT INTO cha_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ya, estagüe, güije un taotao na y naanña si Saqueo, magas y publicano, na rico güe. ");
INSERT INTO cha_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ya jaquequeliija jaye si Jesus; lao ti siña, pot y linajyan taotao, yan pot y etigo güe. ");
INSERT INTO cha_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ya malago mona, ya umeculo gui trongcon sicomoro para ulie: sa nesesita na ufapos güije. ");
INSERT INTO cha_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ya anae mato si Jesus güije na lugat, manatan julo, ya ilegña nu güiya: Saqueo, tunog lasajyao, sa pago na, jaane nesesita na jusaga gui guimamo. ");
INSERT INTO cha_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ya sumajyao papa, ya jaresibe güe yan y minagofña. ");
INSERT INTO cha_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ya anae malie este, todos mangonggong, ilegñija: Mapos, para usaga gui isao na taotao. ");
INSERT INTO cha_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ya si Saqueo tumojgue ya ilegña ni y Señot: Estagüe, Señot, y lamita gui güinajajo junae y mamobble sija; ya yanguin guaja chinelejo pot finababa bae junae cuatro talo. ");
INSERT INTO cha_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ya ilegña si Jesus nu güiya: Pago na jaane mato y satbasion güine na guma; sa güiya locue Lajin Abraham. ");
INSERT INTO cha_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sa y Lajin taotao mato para ualigao, yan usatba y manmalingo. ");
INSERT INTO cha_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ya mientras majujungog este sija, jaaumenta ya jasangan un acomparasion, sa pot y esta jijijot Jerusalem, yan pot y jinasonñija na enseguidas ufato y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Pot este na ilegña: Un taotao na magas, jumanao para y chago na tano para uresibe y raeno, yan para utaloja guato. ");
INSERT INTO cha_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ya jaagang y dies na tentagoña, ya jaentrega dies na minan moneda, ya ilegña nu sija: Nafangagana asta qui ufato. ");
INSERT INTO cha_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lao y taotaoña gui güije na tano machatlie güe, ya manmanago un compañia guato guiya güiya, ilegñija: Mungajam na ufangobietna este na taotao gui jilo mame. ");
INSERT INTO cha_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ya susede anae esta jaresibe y raeno, tumalo guato, ya manago na ufanmaagange y tentago sija ni y janae ni y salape, para utungo cuanto cada uno güinanaña. ");
INSERT INTO cha_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ya anae mato y finenana, ilegña: Señot, y minamo mangana dies na mina mas. ");
INSERT INTO cha_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ya ilegña nu güiya: Mauleg na finatinasmo, mauleg jao na tentago. Pot y tunas jao gui didide, guaja ninasiñamo gui jilo y dies na siuda. ");
INSERT INTO cha_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ya anae mato y mina dos, ilegña: Señot, y minamo mangana sinco na mina. ");
INSERT INTO cha_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ya locue ilegña nu güiya: Jago gui jilo sinco na siuda. ");
INSERT INTO cha_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ya mato y otro ilegña: Señot, estagüe y minamo na juadaje ya jupolo gui jalom y setbiyetas: ");
INSERT INTO cha_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sa maañaoyo nu jago, sa recto jao na taotao: unchuchule y ti unpolo, ya uncococo y ti untanom. ");
INSERT INTO cha_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ya ilegña nu güiya: Taelaye jao na tentago, y guinin y pachotmo nae jujusga jao. Untungoja na recto yo na taotao, juchuchuleja y ti jupolo, ya jucococoja y ti jutanme: ");
INSERT INTO cha_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jafa na ti unpolo y salapejo gui banco; sa para yanguin matoyo jugagao yan y ganansia? ");
INSERT INTO cha_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ya ilegña nu ayo sija y manotojgue gui oriya: Nasuja guiya güiya y minan moneda ya umanae ayo y guaja dies na mina. ");
INSERT INTO cha_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ya ilegñija nu güiya: Señot, guajaja güe dies na mina. ");
INSERT INTO cha_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Sa jusangane jamyo, na masqueseaja jaye y guaja iyoña, umanae; lao y taya iyoña, achogja y guajaña umanasuja guiya guiya. ");
INSERT INTO cha_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Lao aya sija y enemigujo, ni y ti manmalago na jufangobietna gui jiloñija, cone mague, ya ufanmadegüeya gui menajo. ");
INSERT INTO cha_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ya anae munjayan jasangan este, malag y sumanmena, ya cajulo Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ya susede anae esta jijot Betfage, yan Betania, gui egso ni y mafanaan ogso Olibo, jatago dos gui disipuluña, ");
INSERT INTO cha_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ilegña: Janao fanmalag esta mona y sengsong; ya an manjalom jamyo güije, inseda un patgon bulico na magogode, na taya ni un taotao tumachojnge: pula ya inquene mague. ");
INSERT INTO cha_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ya yanguin jaye na taotao fumaesen jamyo: Jafa miña inpila? Sangane taegüine: Sa janesesita y Señot. ");
INSERT INTO cha_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ya manjanao ayo sija y manmatago, ya jasoda jaftaemano y mansinangane sija. ");
INSERT INTO cha_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ya anae mapupula y patgon bulico, ilegña y gaega nu sija: Jafa muna inpípila y patgon bulico. ");
INSERT INTO cha_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ya ilegñija: Janesesita y Señot. ");
INSERT INTO cha_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ya macone guato gui as Jesus: ya japolo y magagoñija gui jilo y patgon bulico, ya manmaudae si Jesus, ");
INSERT INTO cha_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ya anae jumajanao, jababa y magagoñija gui chalan. ");
INSERT INTO cha_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ya anae esta jijijot, esta tumutunog gui egso Olibo, todo y manadan disipulo matutujon manmagof ya maalaba si Yuus, yan dangculo inagang, pot y liniiñija todo ni y finatinas namanman. ");
INSERT INTO cha_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ylegñija: Dichoso y Ray ni y mato pot y naan y Señot: pas gui langet, yan minalag guiya jululo. ");
INSERT INTO cha_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ya palo gui Fariseo sija, manestaba gui entalo y linajyan taotao ilegñija nu güiya: Maestro, reprende y disipulumo sija. ");
INSERT INTO cha_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ya manope ilegña: Jusangane jamyo, na yanguin manmamatquilo este sija, y acho enseguidas ufanagang. ");
INSERT INTO cha_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ya anae esta jijot, ya jalile y siuda, ninacasao pot güiya. ");
INSERT INTO cha_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ylegña: Yanguin untungo, pago gui jaanimo, jagoja, y güinaja ni y iyon y pas! lao pago esta maatogüe y atadogmo. ");
INSERT INTO cha_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sa ufanmato jaane guiya jago, na y enemigumo sija utanmancolat oda gui oriyamo, ya unmaoriyaye, ya unmaadaje cada banda, ");
INSERT INTO cha_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ya umayute papa gui jilo oda yan y famaguonmo ni y mangaegue gui sumanjalommo; ya ti unmapoluye un acho gui jilo y otro; sa ti untungo y tiempon y mabisitamo. ");
INSERT INTO cha_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ya jumalom gui templo, ya jatutujon yumute juyong todo ayo sija y manmanbebende güije; ");
INSERT INTO cha_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ya ilegña nu sija: Esta matugue: Y gumajo, uguma manaetae; lao jamyo infaliyang saque. ");
INSERT INTO cha_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ya mamanagüe gui templo cada jaane. Lao y magas mamale sija, yan y escriba, yan y manmagas y taotao sija, maaliligao para umaqueyulang. ");
INSERT INTO cha_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ya ti jajulat sumoda jafa ujachogüe: sa todo y taotao gumeguesecungog güe. ");
INSERT INTO cha_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","YA susede uno gui güije sija na jaane, anae jafananagüe y taotao sija gui templo, ya japredidica y ibangelio; manmato guiya güiya y magas mamale, yan y escriba, yan y manamco sija; ");
INSERT INTO cha_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ya macuentuse, ilegñija nu güiya: Sangane jam, jafa na ninasiña na unfatitinas este sija na güinaja? Pat jaye numae jao ni este na ninasiña? ");
INSERT INTO cha_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ya manope si Jesus, ilegña nu sija: Jufaesen locue jamyo un finaesen, ya sanganeyo; ");
INSERT INTO cha_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Y tagpangen Juan, guinin y langet, pat guinin y taotao sija? ");
INSERT INTO cha_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ya sija, jajaso gui sumanjalomñija, ilegñija: Yanguin ilegmame: Guinin y langet; ualog, jafa nae na ti injenggue güe? ");
INSERT INTO cha_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Lao yanguin ilegmame: Guinin y taotao sija; infanmamagas nu y acho ni y taotao, sa pineloñija na profeta si Juan. ");
INSERT INTO cha_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ya manmanope na ti jatungo guine mano. ");
INSERT INTO cha_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ayonae ilegña si Jesus nu sija: Ni guajo locue ti jusangane jamyo, jafa na ninasiña na jufatitinas este sija na güinaja. ");
INSERT INTO cha_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ya jatutujon sumangane sija ni este na acomparasion; Un taotao, manplanta un fangualuan ubas, ya japoluye ni manfáfachocho, ya jumanao para y chago na tano, apmam na tiempo. ");
INSERT INTO cha_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ya y tiempon mangoco, jatago un tentago para y manmachóchocho, para umanae ni y tinegcha y gualo; lao masaulag ni y manmachóchocho, ya manajanao taesinajguan. ");
INSERT INTO cha_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ya jatago talo y otro tentago: ya masaulag locue talo, ya manamamajlao, ya manajanao taesinajguan. ");
INSERT INTO cha_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ya jatalo tumago y mina tres na tentago: ya manaerida, ya mayute juyong. ");
INSERT INTO cha_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ayonae ilegña y señot y fangualuan: Jafa jufatinas? Bae jutago y guefyajo na lajijo, sa buente ufangaerespeto nu güiya. ");
INSERT INTO cha_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lao anae malie ni y manmachóchocho, manasangane ilegñija: Estagüe y heredero; nije tapuno, ya usaga y inereda guiya jita. ");
INSERT INTO cha_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ya mayute juyong gui jiyong y fangualuan, ya mapuno. Jafa pago ufatinas y señot y fangualuan nu sija? ");
INSERT INTO cha_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ufato, ya uyulang este sija y manmachóchocho, ya ufannae otro ni y fangualuan. Ya anae majungog ayo, ilegñija: Munga este. ");
INSERT INTO cha_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lao jaatan sija ya ilegña: Jafa nae este y esta matugue: Y acho ni y jarechasa y manmamatitinas y guima, esteja mapolo cuentan ulo gui esquina? ");
INSERT INTO cha_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jayeja y pedong gui jilo ayo na acho, umayamag pedasitos; lao jayeja y jinegse, ufinapetbos. ");
INSERT INTO cha_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ya y magas mamale, yan y escriba sija, maaliligao para umaqueguot güije na ora; lao manmaañao nu y taotao sija, sa matungoja na jasangan este na acomparasion, contra sija. ");
INSERT INTO cha_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ya mapupulanja yan manmanago na umaespipia, para ujafaquemanunas sija na taotao, ya uquefanmañule ni y sinanganña, ya umaqueentrega güe gui inaregla yan ninasiñan y gobietno. ");
INSERT INTO cha_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ya mafaesen güe, ilegñija: Maestro, intingo na unsasangan yan mamananagüe jao tunas, ya ti numanasajnge jao taotao, lao mamananagüe jao ni y magajet na chalan Yuus. ");
INSERT INTO cha_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tunas na infanmanaejam si Sesat tributo, pat aje? ");
INSERT INTO cha_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lao jatungoja y mañañija, ya ilegña nu sija: ");
INSERT INTO cha_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Fanueyo nu y salape. Jaye gaeimagen este yan este na tinigue? Ya manmanope ilegñija: Iyon Sesat. ");
INSERT INTO cha_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ya ilegña nu sija: Nae si Sesat ni y iyon Sesat, ya innae si Yuus nu y iyon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ya ti siña maguot pot y sinanganña gui menan y taotao sija; ya ninafanmanman ni y inepeña ya manmamatquilo. ");
INSERT INTO cha_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ya manmato guiya güiya Saduseo sija, ni y sumangan na taya quinajulon manmatae; ya mafaesen güe, ");
INSERT INTO cha_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ylegñija: Maestro, si Moises jatuguiejam, na yanguin dos chumelo na laje, ya y uno guaja asaguaña, ya matae taya patgonña; ayo y cheluña uniasagua y palaoan, ya unacajulo semiya gui cheluña. ");
INSERT INTO cha_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ya guaja siete na lalaje na mañelu: ya y finenana umasagua, ya matae taya patgonña. ");
INSERT INTO cha_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ya inasagua y palaoan ni y miná dos; ");
INSERT INTO cha_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ya inasagua talo ni y miná tres; yan taegüenaoja locue todo y siete manmatae ya taya famaguonñija. ");
INSERT INTO cha_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ya y palaoan uttimo matae locue. ");
INSERT INTO cha_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ya y quinajulon manmatae, jaye gaeasagua y palaoan? sa inasagua todo ni y siete. ");
INSERT INTO cha_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ya si Jesus ilegña nu sija: Y famaguon este na tiempo manásagua yan manafanásagua: ");
INSERT INTO cha_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lao ayo sija y ufanmanmerese güije na tiempo, yan y quinajulon manmatae, ni ufanasagua, ni umanafanasagua: ");
INSERT INTO cha_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ni ti siña manmatae talo: sa manparejoja yan y angjet sija; yan manfamaguon Yuus, sa manfamaguon y quinajulon. manmatae. ");
INSERT INTO cha_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ya pot y manmatae ni umanafangajulo, asta si Moises mamanue gui finajalomtano, anae jafanaan y Señot, Yuus Abraham yan Yuus Ysaac yan Yuus Jacob. ");
INSERT INTO cha_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sa ti güiya Yuus manmatae, na manlâlâ: sa todosija manlala guiya güiya. ");
INSERT INTO cha_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ya manmanope palo gui escriba sija ilegñija: Maestro, mauleg sinanganmo. ");
INSERT INTO cha_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ya desde ayo, ti matatnga mafaesen güe talo jafa. ");
INSERT INTO cha_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ya ilegña nu sija: Jafa na ilegñija na si Cristo lajin David? ");
INSERT INTO cha_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ya güiyaja si David umalog gui leblon y Salmos: Y Señot ilegña ni y Señotjo, Fatáchong gui agapa na canaejo, ");
INSERT INTO cha_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Asta qui jupolo y enemigumo sija para fañajangan y adengmo. ");
INSERT INTO cha_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Enao muna si David finanaan güe Señot, ya jaftaemano mina ulajiña? ");
INSERT INTO cha_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ya majujungogja ni y taotao sija, anae ilegña ni y disipuluña: ");
INSERT INTO cha_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Adaje jamyo ni y escriba sija, sa yanñija manmamocat yan y anaco na magago, yan yanñija manmasaluda gui plasa, yan y finénana na tachong gui sinagoga sija; yan y finénana na saga gui guipot; ");
INSERT INTO cha_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yan jalachae y guima y biuda sija, yan manmamanunue ni y anaco tinaetaeñija pot taya; estesija ujaresibe mandangculo na sinentensia. ");
INSERT INTO cha_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","YA anae manatan julo, jalie y manrico na taotao sija, na jayuyute jalom y ninaenñija gui cajon salape. ");
INSERT INTO cha_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ya jalie locue un pobble na biuda, na manyute jalom güije dos coble. ");
INSERT INTO cha_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ya ilegña: Jusangane jamyo ni y magajet. Este y pebble na biuda, manyute jalom mas qui todo sija: ");
INSERT INTO cha_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sa todo estesija, y sebblanñijaja manmayute jalom minaeñija: lao este yan y pinebbleña, jayute todo jalom y güinajaña. ");
INSERT INTO cha_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yan pot y manguecuentos palo pot y templo, ni y maadotna manbonito na acho sija yan ninae sija, ilegña: ");
INSERT INTO cha_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Este sija na güinaja y inlie, estagüe, ufanmato jaane sija, na taya usobbla güine un acho gui jilo y otro, na ti umayute papa. ");
INSERT INTO cha_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ya mafaesen güe, ilegñija: Maestro, ngaean nae ujuyong estesija? yan jafa na señat uguaja, yanguin jijot para ufanmato este sija na güinaja? ");
INSERT INTO cha_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ayonae ilegña: Guesadaje jamyo ya chamiyo fanmafabábaba: sa megae ufanmato pot y naanjo, ya ujaalog: Güiya yo ya y tiempo esta jijijot; chamiyo dumalálalaque sija. ");
INSERT INTO cha_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lao yanguin injingog y guera sija, yan y atboroto, chamiyo faninespápanta: sa nesesita ufanmato este sija finena; lao y uttimo ti enseguidas. ");
INSERT INTO cha_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ayo nae ilegña nu sija: Y nasion sija ufangajulo contra y nasion, ya y raeno contra raeno: ");
INSERT INTO cha_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ya uguaja dangculon linao, ya y cada lugat ñinalang yan peste; yan uguaja minaañao sija, yan mandangculo na señat guinin y langet. ");
INSERT INTO cha_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lao antes di todo este sija, ujapolo y canaeñija gui jilomiyo, ya infanmapetsigue, yan infanmaentrega gui sinagoga sija, yan y catset, yan infanmacone guato gui ray sija, yan y manmagas pot y naanjo. ");
INSERT INTO cha_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ya ujuyong este guiya jamyo para testimonio. ");
INSERT INTO cha_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Polo gui corason miyo, na chamiyo jumajaso finena jafa para inepe: ");
INSERT INTO cha_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sa guajo junae jamyo pachot yan tiningo, ni todo y enimigunmiyo ti siña macontra ni umachaba. ");
INSERT INTO cha_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ya infanenentrega ni y mañaenanmiyo, yan y mañelunmiyo, yan y parientesmiyo, yan y amigonmiyo; yan guaja guiya jamyo umanamapuno. ");
INSERT INTO cha_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ya infanmachatlie ni todo y taotao pot y naanjo. ");
INSERT INTO cha_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lao ni uno gui gaponulonmiyo ufalingo. ");
INSERT INTO cha_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ya y manpasensianmiyo nae, inganaye y antenmiyo. ");
INSERT INTO cha_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ya anae inlie Jerusalem, na esta ineriyaye ni y sendalo sija, intingoja na esta jijijot y mayulangña. ");
INSERT INTO cha_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ya ayonae y mangaegue guiya Judea, ufanmalago para y egso sija; ya ayo sija y mangaegue gui entaloña ufanjuyong; ya y mangaegue gui fangualuan, chañija fanjajalom güije. ");
INSERT INTO cha_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sa este sija y jaanin inemog, sa para umacumple todo y güinaja ni y esta manmatugue. ");
INSERT INTO cha_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lao mannamaase ayo sija y manmapotgue, yan y mannanasusu güije sija na jaane! sa uguaja dangculon chinatsaga gui jilo tano, yan binibo gui jilo este taotao sija. ");
INSERT INTO cha_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ya ufamodong gui jilo y filon y espada, ya ufanmacone preso gui todo y nasion: ya Jerusalem umagacha papa ni y Gentiles, asta qui umacumple y tiempon y Gentiles. ");
INSERT INTO cha_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ya uguaja señat sija gui atdao yan y pilan, yan y pution sija; yan chinatsagan nasion sija gui jilo tano pot y guinadon pangpang y tase yan y napo. ");
INSERT INTO cha_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Manlalalango y taotao sija, pot y manmaañaoñija, yan pot y ninanangga ni ayo sija y manmamamaela para y tano: sa manmayengyong y ninasiñan y langet sija. ");
INSERT INTO cha_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ya ayonae ujalie y Lajin taotao na mamamaela gui y mapagajes yan y ninasiña yan y dangculon minalag. ");
INSERT INTO cha_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ya anae esta jatutujon sumesede este sija, ayonae infanalag jilo, ya injatsa julo y ilunmiyo; sa esta jijijot y para inmanafanlibre. ");
INSERT INTO cha_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ya jasangane sija un acomparasion, ilegña: Atanja y trongcon igos, yan todo y trongcon jayo sija. ");
INSERT INTO cha_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yanguin esta manmañúñuso, inlie ya intingoja maesa jamyo na esta jijijot y verano. ");
INSERT INTO cha_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Taegüenaoja locue jamyo yanguin inlie esta sija na masusede, tingo na esta jijijot y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Magajet jusangane jamyo: Ti ufapos este na generasion, asta qui todo sija manmacumple. ");
INSERT INTO cha_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Y langet yan y tano ufanmalofan, lao y finojo ti ufalofan. ");
INSERT INTO cha_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ya inguesadaje jamyo na ufanbula y corasonmiyo ni y pinadog mañocho yan inelacho, yan y inadajen este na linâlâ, ya ufato guiya jamyo ayo na jaane derepente, ");
INSERT INTO cha_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Taegüijeja y laso: sa taegüijeja ufinatoña gui jilo todo sija y mañasaga gui jilo tano. ");
INSERT INTO cha_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Enaomina fanbela todo tiempo, ya infanmanaetae, ya para infansiña manescapa ni todo estesija y ni ufanmato, yan para infanojgue gui menan y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ya mamananagüe cada jaane gui templo; yan cada puenge jumajanao, ya sumasaga gui un ogso na mafanaan ogso Olibo. ");
INSERT INTO cha_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ya todo y taotao sija manmafato gui templo, taftaf gui egaan, para umaecungog güe. ");
INSERT INTO cha_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","AYO nae estaba jijijot y jaanin y guipot y pan ni taelibadura, ni mafanaan pascua. ");
INSERT INTO cha_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ya y magas mamale yan y escriba sija maaliligao jaftaemano para umapuno güe; lao manmaañao ni y taotaosija. ");
INSERT INTO cha_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ya jumalom si Satanas gui as Judas y apeyiduña Iscariote, uno gui numerou y dose. ");
INSERT INTO cha_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ya maposgüe, ya manguentos yan y magas mamale, yan y manmagas, jafataemano para uinentrega guiya sija. ");
INSERT INTO cha_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ya ninafanmagof, ya matratos na umanae salape. ");
INSERT INTO cha_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ya manpromete ya jaaliligao lugat para uqueentrega guiya sija, yanguin manaegüe y linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ya mato y jaanin y taelibadura na pan, anae nesesita umaofrese y pascua. ");
INSERT INTO cha_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ya jatago si Pedro yan Juan, ilegña: Janao ya innalisto y pascua para jita, para utafañocho. ");
INSERT INTO cha_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ya sija ilegñija nu güiya: Mano malagomo nae innalisto? ");
INSERT INTO cha_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ya ilegña nu sija: Estagüe, anae manjalom jamyo gui siuda, infanasoda güije yan un taotao, na mañuñule un jarran janom; dalalaque güe jalom mano na guma nae jumalom. ");
INSERT INTO cha_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ya inalog ni y gaéguima: Y Maestro ilegña nu jago: Manggue y aposento anae para juchocho gui pascua yan y disipulujo sija? ");
INSERT INTO cha_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ya infanfinanue ni y dangculo na aposento gui sanjilo todo cabales: ayonae innalisto. ");
INSERT INTO cha_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ya manjanao ya masoda jaftaemano y mansinangane sija; ya manalisto para y pascua. ");
INSERT INTO cha_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ya anae mato y ora, matachong papa mañija yan y dose na apostoles. ");
INSERT INTO cha_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ya ilegña nu sija: Jagasja juguefdesea na utafañocho guine na pascua antes di jufamadese: ");
INSERT INTO cha_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sa jusangane jamyo: Ti juchocho mas, asta qui macumple gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ya juresibe y copa ya janae grasia, ya ilegña: Chule este, ya infanafacae entre jamyo: ");
INSERT INTO cha_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sa jusangane jamyo na ti juguimen otro biaje ni y tinegcha ubas, asta qui ufato y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ya jachule y pan, ya anae janae grasia, jaipe, ya janae sija, ilegña: Este y tataotaojo, ni y manmanae jamyo: fatitinas este para injajasoyo. ");
INSERT INTO cha_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Taegüijeja locue y copa, anae munjayan mañena ilegña: Este na copa y nuebo na trato gui jâgâjo, ni y machuda pot jamyo. ");
INSERT INTO cha_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lao estagüeja y canae y umentregayo na jumajame gui lamasa. ");
INSERT INTO cha_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ya magajet na y Lajin taotao ujanao, ni y esta manfagpo, lao ay ay ayo na taotao uinentrega! ");
INSERT INTO cha_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ya jatutujon manafaesen entre sija, jae guiya sija ufinatinas este. ");
INSERT INTO cha_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ya guaja locue inaguaguat guiya sija, jaye umasdangculo. ");
INSERT INTO cha_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ya ilegña nu sija: Y ray y Gentiles, jafatitinas minagas gui jiloñija; ya ayo y fumatitinas ninasiña gui jiloñija, manmafanaan manmauleg na taotao. ");
INSERT INTO cha_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lao ti infanaegüenao: sa jaye y mas dangculo guiya jamyo, ufamataegüije y mas diquique; ya y magas, ufamataegüije y mañeñetbe. ");
INSERT INTO cha_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sa cao dangculoña, ayo y matatachong chumocho, pat ayo y mañeñetbe? ti ayo y matachong chumocho; lao guajo gaegue gui entalonmiyo taegüije ayo y mañeñetbe. ");
INSERT INTO cha_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jamyo ayo sija y sumisigueja mangachongjo gui tentasionjo. ");
INSERT INTO cha_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ya juaregla un raeno para jamyo, taegüije y as Tata ni y jaaregla y raeno para guajo. ");
INSERT INTO cha_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Para infañocho yan infanguimen, gui lamasajo gui raenoco; ya infanmatachong gui trono sija ya injisga y dose na tribo guiya Israel. ");
INSERT INTO cha_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, estagüe, si Satanas, na malago nu jago para unquinila gui coladot taegüije y trigo; ");
INSERT INTO cha_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lao guajo tayuyute jao, para chaña fafatta y jinengguemo: ya yanguin umabira jao, nafanfitme y mañelumo. ");
INSERT INTO cha_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ya ilegña nu güiya: Señot, estayo listo para judalalag jao para y catset yan para y finatae. ");
INSERT INTO cha_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ya ilegña: Jusangane jao Pedro, na ti uoo y gayo pago na jaane, antes di undagueyo tres biaje na guinin untungoyo. ");
INSERT INTO cha_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ya ilegña nu sija: Anae jutago jamyo sin botsa, yan sin maleta, yan sin sapatos, guaja fattanmiyo? Ya ilegñija: Taya. ");
INSERT INTO cha_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ayonae ilegña nu sija: Lao pago, y gaebotsa, uchuleja, yan taegüenaoja locue y maleta: ya jaye y taya espadaña, ubende y magaguña ya ufamajan uno. ");
INSERT INTO cha_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sa jusangane jamyo, na este y esta matugue, nesesita na umacumple guiya guajo: Ya matufong gui entalo y manaelaye sija: sa y güinaja sija pot guajo, umanafanfagpo. ");
INSERT INTO cha_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ya ilegñija: Señot, estagüeja dos na espada. Ya ilegña nu sija: Esta najong. ");
INSERT INTO cha_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ya jumuyong, ya mapos, taegüijeja y costumbreña, para y egso Olibo; ya matatiye locue ni y disipuluña. ");
INSERT INTO cha_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ya anae mato gui lugat, ilegña nu sija: Fanmanaetae, ya chamiyo fanjajalom gui tentasion. ");
INSERT INTO cha_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ya sumuja guiya sija, gui un inagüit acho; ya dumimo, ya manaetae, ");
INSERT INTO cha_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ylegña: Tata, yanguin malago jao, nasuja guiya guajo este y copa: lao munga mafatinas y malagojo, lao y malagomo. ");
INSERT INTO cha_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ya finatoigüe güije un angjet guinin y langet, ya ninametgot. ");
INSERT INTO cha_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ya anae estaba umagoninias, mas fejman manaetae: ya y masajalomña taegüije y mandangculo na gotan jâgâ, mamopodong papa gui eda. ");
INSERT INTO cha_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ya anae cajulo guinin manaetae, ya mato gui disipuluña, jasoda na manmamaego sa mantriste, ");
INSERT INTO cha_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ya ilegña nu sija: Jafa na manmamaego jamyo? fangajulo ya infanmanaetae, sa noseaja infanjalom gui tentasion. ");
INSERT INTO cha_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ya mientras cumuecuentos, estagüe un manadan taotao, yan ayo y mafanaan si Judas, uno gui dose, na mafona gui menanñija, ya jumijijot gui as Jesus para uchico. ");
INSERT INTO cha_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lao si Jesus ilegña nu güiya: Judas, pot un chicoja na unentrega y Lajin taotao? ");
INSERT INTO cha_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ya anae malie, ni ayo sija y mangaegue gui oriyaña, jafa ujuyong, ilegñija: Señot, intaga ni y espada? ");
INSERT INTO cha_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ya uno guiya sija jataga y tentago y magas mamale, ya jautut y agapa na talangaña. ");
INSERT INTO cha_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ya manope si Jesus ilegña: Polo este esta. Ya japacha y talangaña, ya janamagong. ");
INSERT INTO cha_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ayonae ilegña si Jesus ni y magas mamale, yan y capitan sija gui templo, yan y manamco sija ni y manmato guiya güiya: Manmato jamyo yan espada yan galute, taegüije y contra y saque? ");
INSERT INTO cha_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Anae estaba manjijitaja cada jaane gui templo, taya nae inestira y canaenmiyo contra guajo: lao este oranmiyo, yan y ninasiñan jinemjom. ");
INSERT INTO cha_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ya maguot güe ya macone guato gui guima y magas mamale. Ya tinatitiyeja as Pedro lachago. ");
INSERT INTO cha_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ya anae munjayan matotne y guafe gui talo gui patio, ya mandaña manmatachong, matachong si Pedro gui entaloñija. ");
INSERT INTO cha_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ya linie ni un criada anae matachong gui ininan guafe, ya guinesatangüe, ya ilegña: Este locue na taotao manisija. ");
INSERT INTO cha_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ya jadague, ilegña: Palaoan, ti jutungo güe. ");
INSERT INTO cha_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ya anae na apmam linie ni otro ya ilegña: Mangachochongmo yuje sija? ya ilegña si Pedro: Taotao, ti guajo. ");
INSERT INTO cha_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ya anae malofan una ora, otro jagosasegura ilegña: Magajet na sumisija este yan ayo, sa taotao Galilea locue este. ");
INSERT INTO cha_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ya si Pedro ilegña: Taotao, ti jutungo jafa ilelegmo. Ya mientras cumecuentos, enseguidas umoo y gayo. ");
INSERT INTO cha_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ya jabira güe y Señot ya jaaatan si Pedro. Ayonae jajaso si Pedro y sinangan y Señot, ni y ilegña nu güiya: Antes que uoo y gayo pago na jaane, undagueyo tres biaje. ");
INSERT INTO cha_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ya jumuyong si Pedro ya guefcumasao. ");
INSERT INTO cha_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ya y taotao sija ni gumuguot si Jesus, mabotlelea ya manalalamen. ");
INSERT INTO cha_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ya anae mabendas y atadogña, mafaesen ilelegñija: Sangan; jaye jao munalamen? ");
INSERT INTO cha_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ya megae sija na chinatfino masasangan contra guiya, manamamajlao güe. ");
INSERT INTO cha_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ya anae manana mandaña sija y inetnon manamco na taotao sija y magas y mamale yan y escribas: ya macone guato gui tribunatñija, ilegñija: ");
INSERT INTO cha_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yaguin jago si Jesucristo, sangane jam. Lao ilegña nu sija: Yaguin jusangane jamyo, ti injenggue yo; ");
INSERT INTO cha_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ya yaguin guajo jamyo fumaesen, ti inepeyo. ");
INSERT INTO cha_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lao desde pago para mona y Lajin taotao gaegue na matatachong gui agapa gui ninasiñan Yuus. ");
INSERT INTO cha_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ya ilegña todos: Ayonae Lajin Yuus jao? Ya ilegña nu sija: Jamyo umalog na guajo yo. ");
INSERT INTO cha_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ayonae ilegñija: Jafa mas na testimonio tanesesita? sa tajungogja esta gui pachotña. ");
INSERT INTO cha_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","YA todo y linajyanñija mangajulo, ya macone asta as Pilatos. ");
INSERT INTO cha_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ya matutujon mafaaela ilegñija: Inseda este na taotao na janaquequelache y nasionta, yan mañoñoma na umanae tributo si Sesat, ya ilelegña na güiya si Cristo un ray. ");
INSERT INTO cha_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ayonae si Pilatos finaesen ilegña: Jago y Ray y Judio sija? ya inepe ya ilegña: Jago umalog. ");
INSERT INTO cha_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ya si Pilatos ilegña ni y magas y mamale, yan y linajyan taotao sija: Taya isao jusoda güine na taotao. ");
INSERT INTO cha_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lao sija japotfia, ilegñija: Jaatbororota y taotao sija, mamananagüe guiya Judea todo, jatutujon desde Galilea asta esteja na lugat. ");
INSERT INTO cha_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ya anae jajungog este si Pilatos, mamaesen cao taotao Galilea. ");
INSERT INTO cha_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ya anae jatungo na gaegue gui sisiñan Herodes, janamanajanao asta as Herodes, sa estaba güe locue guiya Jerusalem güije sija na jaane. ");
INSERT INTO cha_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ya si Herodes anae jalie si Jesus, ninasenmagof: sa jagasja jadesea na ulie, sa jajujungog guinin güiya, megae na güinaja: ya jananangga na ufanlie guinin güiya y milagro. ");
INSERT INTO cha_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ya jafaesen megae na sinangan: lao taya inepe güe. ");
INSERT INTO cha_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yan mangaegue y magas y mamale yan y escribas na manmatatachong ya mafaaela güe fijom. ");
INSERT INTO cha_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Lao si Herodes yan y sendaluña, madespresia yan mabotlea, yan manaminagago ni lamlam na magago, ya manatalo guato as Pilatos. ");
INSERT INTO cha_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ya umamigo si Pilatos yan Herodes güijeja na jaane: sa guinin umachatlie y dos. ");
INSERT INTO cha_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ya si Pilatos janaetnon y magas y mamale, yan y magalaje yan y taotao sija, ");
INSERT INTO cha_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ya ilegña nu sija: Inquene mague guiya guajo este na taotao na janaquequelache y taotao sija; ya, estagüe, na jufaesen gui menanmiyo, ya taya jusoda ni jafa na isao güine na taotao pot y finaaelamimiyo sija. ");
INSERT INTO cha_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aje, ni si Herodes: sa junafalag iya güiya, ya, estagüe, ni jafa na ufanmerese na finatae pot y guinin finatinasña. ");
INSERT INTO cha_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Enao mina bae jucastiga ya jusotta. ");
INSERT INTO cha_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ya manesesita na umasotta uno gui guipot. ");
INSERT INTO cha_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ya managang cada uno, ilegñija: Nasuja juyong enao na taotao ya umasotta si Barabas: ");
INSERT INTO cha_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Sa mapreso pot un jatsamiento yan mamuno ni y jafatinas gui siuda. ");
INSERT INTO cha_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ya si Pilatos ilegña talo nu sija, Malagomiyo na umasotta si Jesus. ");
INSERT INTO cha_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lao managang ilegñija: Atane gui quiluus, atane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ya ilegña nu sija gui mina tres biaje: Sa jafa? jafa na taelaye finatinasña este na taotao? Taya ni jafa na causa para umapuno jusoda guiya güiya. Pot este na rason bae jucastigaja ya jusotta. ");
INSERT INTO cha_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lao sija enseguidas janadangculo inagangñija, ya magagao na umaatane gui quiluus. Ya y inagangñija mangana. ");
INSERT INTO cha_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ayonae si Pilatos janae sentensia na ufatinas taemano y guinagaoñiñija. ");
INSERT INTO cha_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ya masotta ayo y guinin mapreso pot jatsamiento yan mamuno, ayo y guinin magagagao: ya manmaentrega as Jesus gui minalagoñija. ");
INSERT INTO cha_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ya anae macocone güe maguot si Simon, taotao Sirene, ni guinin y fangualuan, ya manae ni quiluus na uapagaye gui taten Jesus. ");
INSERT INTO cha_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ya matatitiye ni y dangculon linajyan taotao yan famalaoan sija ni mangacasao yan manatangis pot güiya. ");
INSERT INTO cha_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lao si Jesus jabira güe tate guiya sija ilegña; Famalaoan Jerusalem, chamiyo fangacasao pot guajo, lao fangacasao pot jamyoja yan pot y famaguonmiyo. ");
INSERT INTO cha_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sa, estagüe, na ufato sija jaane nae umaalog: Mandichoso sa y manmachora, yan y tiyan sija ni ti manmamañago, yan y pecho sija ni ti manmamómogsae. ");
INSERT INTO cha_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ayonae matutujon maalog ni egso sija: Famodong gui jilonmame; ya y sabana sija: Tampe jam. ");
INSERT INTO cha_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sa yaguin y betde na jayo jafatinas estesija, y anglo, jafa uchogüe? ");
INSERT INTO cha_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ya macone locue dos palo na taelaye finatinasñija para ufanmapuno yan güiya. ");
INSERT INTO cha_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ya anae manmato güije na lugat ni mafanaan Calabera, maatane gui quiluus güije yan ayo y dos ni y taelaye finatinasñija, uno gui agapa ya y otro gui acagüe. ");
INSERT INTO cha_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ya si Jesus ilegña: Tata, asie estesija; sa ti jatungo jafa jachochogüe. Ya manafacae entre sija y magaguña, ya marifa. ");
INSERT INTO cha_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ya y taotao sija manotojgue ya maaatanja. Ya mabotlelea ni y magas sija locue, ya ilelegñija: Ufañatba otrosija: palo ya usatban maesagüe, yaguin este si Cristo, ni guine as Yuus. ");
INSERT INTO cha_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ya mamofefea ni y sendalo sija, manmato guiya güiya, ya mafanunue ni y binagle. ");
INSERT INTO cha_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ya ilegñija: Yaguin jago Ray y Judio sija, satban maesa jao. ");
INSERT INTO cha_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ya guaja locue un tinigue gui jiloña: ESTE GUIYA Y RAY Y JUDIO SIJA. ");
INSERT INTO cha_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ya uno gui ayo y taelaye finatinasñija ilegna: Yaguin jago si Cristojao? Satban maesajao yan jame. ");
INSERT INTO cha_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lao inepe ni otro, ya linalatde ilegña: Ti maañao jao as Yuus, sa gaegue jao gui mismo sinentensia? ");
INSERT INTO cha_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lao jita magajet na tunas; sa utafanresibe pot y finatinasta: lao este na taotao, taya taelaye finatinasña. ");
INSERT INTO cha_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ya ilegña: Jesus, jajaso yo yaguin matojao gui raenomo. ");
INSERT INTO cha_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ayonae ilegña nu güiya: Magajet jusangane jao: Pago mismo na jaane utajita na dos guiya Paraiso. ");
INSERT INTO cha_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ya anae buente y oran a las sais, jumuyong jomjom todo y jilo y tano asta y oran a las nuebe, ");
INSERT INTO cha_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ya y atdao jomjom, ya y cottinan templo maipe gui talo. ");
INSERT INTO cha_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ya anae umagang si Jesus, ni dangculo na inagang, ilegña: Tata, y canaemo nae jupolo y espiritujo; ya anae munjayan jasangan este, jaentrega y espiritu. ");
INSERT INTO cha_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ya anae jalie y senturion estesija y manmalofan, janamalag si Yuus, ilegña: Sen magajet este na taotao na tunas. ");
INSERT INTO cha_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ya todo y linajyan taotao ni mandaña anae manmalofan este sija, anae malie y jagas sinesede, natumalo guato ya jaseco pechonñija. ");
INSERT INTO cha_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lao todo y atungoña yan y famalaoan ni tumatitiye güe desde Galilea, manestaba manlachago maatanja este sija. ");
INSERT INTO cha_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ya estagüe, un taotao na y naanña si José, un taotao na pápagat, mauleg na taotao yan tunas: ");
INSERT INTO cha_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Ti jaconsiente y pinagatñija ni y finatinasñija:) Taotao Arimatea, gui Siuda y Judiosija, ya güiya locue jananangga y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Este mato gui as Pilatos, ya jagagao y tataotao Jesus. ");
INSERT INTO cha_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ya janatunog gui quiluus, ya jabalutan gui un sabanas, ya japolo gui un naftan ni maguadog gui acho, ya taya ni uno mapolo güije antes. ");
INSERT INTO cha_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ya ayo na jaane y inaregla y pascua, ya pago manana gui sabado. ");
INSERT INTO cha_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ya manmato locue y famalaoan ni y tumatitiye desde Galilea, ya malie y naftan yan jaftaemano mapoloña y tataotaoña. ");
INSERT INTO cha_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ya tumalo guato sija, ya manmamamauleg paopao yan inggüente sija: ya mandescansa gui sabado na jaane jaftaemanoja y tinago. ");
INSERT INTO cha_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","LAO y finenana na jaane gui semana, gui taftataf gui egaan, manmato gui naftan, mapmañuñule guato paopao ni y finamaulegñija. ");
INSERT INTO cha_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ya masoda y acho na esta managalileg gui pettan y naftan. ");
INSERT INTO cha_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ya anae manjalom ti masoda y tataotao y Señot Jesus. ");
INSERT INTO cha_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ya anae manmajngang nu este, dos taotao tumotojgue gui oriyanñija, na minagagago ni y lamlam na magago. ");
INSERT INTO cha_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ya anae ninafanmaañao ya manecon papa gui eda, ilegñija nu sija: Jafa muna inaliligao y lâlâ gui entalo y manmatae? ");
INSERT INTO cha_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Taegüe güine, lao esta cajulo: jaso y mansinangane jamyo, anae estataba Galilea, ");
INSERT INTO cha_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ylegña: Na nesesita na y Lajin taotao umaentrega gui canae y taotao sija ni manisao, y umaatane gui quiluus, ya ucajulo talo gui mina tres na jaane. ");
INSERT INTO cha_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ayonae jajaso sija y sinanganña, ");
INSERT INTO cha_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ya manalo guato gui naftan ya jasangane y onse nu este sija, yan todo y pumalo. ");
INSERT INTO cha_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ya sija si Maria Magdalena yan si Juana, yan si Maria nanan Santiago; yan y pumalo palaoan ni mangachongñija, sumangane y apostoles nu estesija. ");
INSERT INTO cha_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lao sija japolo na taetiningo, y sinanganñija ya ti majonggue. ");
INSERT INTO cha_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ayonae cajulo si Pedro, ya malago asta y naftan: ya anae ñumejon ya jaatan jalom, jalilie y sabanasja gui un lugat, ya mapos güe iyasija ya ninamanman nu este y manmalofan. ");
INSERT INTO cha_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ya, estagüe, dos guiya sija na jumajanao, güijeja na jaane, para un songsong ni naanña Emmaus, sesenta estadios desde Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ya cumuecuentos y dos mona pot todo estesija y masusede. ");
INSERT INTO cha_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ya susede anae cumuecuentos y dos, ya manafaesen entre sija, mato si Jesus ya mañisija manjanao. ");
INSERT INTO cha_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lao y atadogñija calang manmatampe, para chañija tumutungo güe. ");
INSERT INTO cha_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ya ilegña nu sija: Jafa na cuentosmimiyo uno yan otro, anae manajanao jamyo, ya mañaga ya ninafantriste? ");
INSERT INTO cha_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Inepe ni ayo y uno ni y naanña si Cleofas ya ilegña nu güiya: Ada sumagaja jao guiya Jerusalem, ya ti untungo jafa manmalofan güine sija na jaane? ");
INSERT INTO cha_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ayonae ilegña nu sija: Jafa sija? Ya ilegñija nu güiya: Ayo sija iyon si Jesus Nasareno, ni profeta güe ni gaeninasiña gui checho yan y sinangan gui menan Yuus yan todo y taotao sija; ");
INSERT INTO cha_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ya maentrega, gui magas mamale yan y magalajenmame para umasentensia ni y finatae, ya maatane gui quiluus. ");
INSERT INTO cha_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lao jame innanangga sa güiya y para unafanlibre y Israel. Junggan, yan mas qui todo este, pago esta mina tres na jaane desde que masusede estesija. ");
INSERT INTO cha_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yan locue palo famalaoan ni mangachongmame janamanman jam sa manmato gui naftan gui taftataf gui egaan; ");
INSERT INTO cha_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ya anae ti masoda y tataotaoña, manmato guiya jame ilegñija na manmanlie sija y liniin angjet sija, ni y jasnangane na lâlâgüe. ");
INSERT INTO cha_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ya mamjanao guato gui naftan palo gui mangachongmame ya masoda taemanoja y sinangan y famalaoan; lao ti malie güe. ");
INSERT INTO cha_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ya ilegña nu sija: O taotao manaetiningo jamyo, yan y ñateng y corasonmiyo para injenggue todo y sinangan y profeta sija! ");
INSERT INTO cha_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ada ti nesesita na si Cristo ufamadese nu este sija ya taegüine nae ujalom gui minalagña? ");
INSERT INTO cha_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ya jatutujon desde as Moises, yan y profeta sija, y jasangangane claro todo ni tinigue ni y pot güiya. ");
INSERT INTO cha_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ya manmato gui sengsong ni jajananagüe güije; ya jasigue para mas chago jinanaoña. ");
INSERT INTO cha_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lao sija janasaga fuetsao, ilegñija: Maela tafañaga sa este puenge ya jocog y jaane; ya jumalom para usaga mañisija. ");
INSERT INTO cha_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ya susede, anae matachong gui lamasa yan sija, jachule y pan ya jabendise, ya jaipe ya manninae. ");
INSERT INTO cha_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ayonae manmababa atadogñija ya matungo güe; lao güiya jamalingoja gui inatanñija. ");
INSERT INTO cha_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ya ilegñija entre y dos: Ada ti sinenggue y corasonta gui sumanjalomta mientras jacuentutusejit gui chalan, yan anae jababayejit ni y tinigue? ");
INSERT INTO cha_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ya cumajulo y dos güije na ora, ya tumalo guato Jerusalem: ya masoda y onse mandadaña, yan y manestaba mangachongñiñija, ");
INSERT INTO cha_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ya ilelegñija: Magajet, esta cajulo y Señot, na umalie yan si Simon. ");
INSERT INTO cha_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ayonae sija jasangane nu este sija y masusede gui chalan; yan jafa taemano, tungoñija anae jaipe y pan. ");
INSERT INTO cha_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ya mientras manguecuentos nu este sija, güiya tumojgueja gui entaloñija, y ilegña nu sija: Pas guiya jamyo. ");
INSERT INTO cha_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ayonae manmaañao ya manmajngang ya jinasonñija na manmanlie sija un espiritu. ");
INSERT INTO cha_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lao güiya ilegña nu sija: Jafa na ninafanestotba jamyo? Ya jafa na cumajulo y jinasonmiyo gui corasonmiyo? ");
INSERT INTO cha_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Atanja y canaejo yan y adengjo, sa guajo mismoyo: pacha yan inlie sa y espiritu taecatne ni tolang, taegüije inliija na guajayo, ");
INSERT INTO cha_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ya anae jasangan este, manfinanue ni y canaeña yan y adengña. ");
INSERT INTO cha_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ya anae ti jajonggue sija pot minagofñija, ya ninafanmanman, güiya ilegña nu sija: Guaja güine jafa para utacano? ");
INSERT INTO cha_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ya sija janae un pedason güijan na mapeja. ");
INSERT INTO cha_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ya jachule ya jacano gui menanñija. ");
INSERT INTO cha_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ya ilegña nu sija: Este sija na sinangan ni y jusangangane jamyo anae manjijita: taemanoja na nesesita na umacumple todo y esta matugue gui lay Moises yan y profeta sija, yan y Salmos pot guajo. ");
INSERT INTO cha_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ayonae manbinaba y jinasoñija para ujatungo y tinigue; ");
INSERT INTO cha_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ya ilegña nu sija: Taegüine esta matugue, na si Cristo ufamadese ya ucajulo talo guinin y manmatae gui mina tres na jaane; ");
INSERT INTO cha_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ya umapredica gui naanña y sinetsot yan inasiin isao, gui todo y nasion sija, umatutujon desde Jerusalem. ");
INSERT INTO cha_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ya jamyo testigo nu estesija na güinaja. ");
INSERT INTO cha_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ya, estagüe, na bae jutago y promesan y Tatajo gui jilo miyo: lao jamyo fañaga gui siuda guiya Jerusalem, asta que manminagago jamyo ni y ninasiña guinin iya jululo. ");
INSERT INTO cha_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ya manquinene juyong asta Betania; ya jajatsa y canaeña ya manbinendise sija. ");
INSERT INTO cha_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ya susede anae manbinendise, jaapatte güe guiya sija ya machule julo gui Langet. ");
INSERT INTO cha_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ya sija jaadora ya manalo guato Jerusalem yan y dangculon minagofñija; ");
INSERT INTO cha_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ya mangaegue siempre gui templo, manmanbendidise as Yuus. Amen. ");
INSERT INTO cha_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Y tutujonña gaegue y Finijo, ya y Finijo güiya yan si Yuus; ya y Finijo güiya si Yuus. ");
INSERT INTO cha_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Güiya gaegue gui tutujonña yan si Yuus. ");
INSERT INTO cha_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Todo y güinaja sija manmafatinas pot güiya; yaguin ti pot güiya, taya ni esta mafatinas, nu y gaegue gui finatinas sija. ");
INSERT INTO cha_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Y linâlâ gaegue guiya güiya, ya y linâlâ, güiya y candet y taotao sija. ");
INSERT INTO cha_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ya y candet gui jalom jomjom maniina, ya y jemjom ti matungo. ");
INSERT INTO cha_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Y un taotao ni manafato guine as Yuus, y naanña si Juan. ");
INSERT INTO cha_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Güiya mamaela para testimonio, para ufannae testimonio nu y candet, para ufanmanjonggue todo y taotao pot güiya. ");
INSERT INTO cha_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Güiya ti y candet, lao mamaela para ufannae testimonio nu y candet. ");
INSERT INTO cha_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ayo y magajet na candet ni maniina y todo taotao, na mamamaela güine gui tano. ");
INSERT INTO cha_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Güiya gaegue gui tano, ya y tano mafatinas pot güiya, ya y tano ti matungo güe. ");
INSERT INTO cha_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Güiya mato gui iyoña ya iyoña ti marisibe güe. ");
INSERT INTO cha_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lao todo y rumesibe güe, güiya janae ninasiñanñija para ufamaguon Yuus; junggan, para todo ni y jumonggue y naanña. ");
INSERT INTO cha_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sija manmalilis ti guinin y jâgâ, ya ti guinin y minagof y catne, ya ti guinin minagof y taotao, lao guinin as Yuus. ");
INSERT INTO cha_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ya ayo na Finijo mamacatne ya sumaga guiya jita (ya talie y minalagña, ayo na minalag taegüije y linilisja gui tata), bula y grasia yan y minagajet. ");
INSERT INTO cha_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Juan manae testimonio nu güiya ya umagang ya ilegña: Güiya ayo y jusasangan: y mamaela gui tateco, güiya dangculoña qui guajo, sa güiya finenena qui guajo. ");
INSERT INTO cha_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gui binilaña manmañulijit todo, yan y grasia pot y grasia. ");
INSERT INTO cha_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sa y tinago sija pot si Moises esta manae, lao y grasia yan y minagajet, pot si Jesucristo namanmato. ");
INSERT INTO cha_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Si Yuus, taya taotao lumie, taya na tiempo, ayo na Lajiña, y linilisja, na gaegue san jalom y pechon tata, güiya jafanue jit nu güiya. ");
INSERT INTO cha_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ya este y testimonien Juan, anae y Judio sija manafanmato nu y mamale yan Lebita sija, guine Jerusalem, ni manmafasen: Jago, jaye jao? ");
INSERT INTO cha_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Güiya jaconfesatñaejon ya ti japune, lao jaconfesatñaejon, ilegña: Guajo ti Jesucristo yo. ");
INSERT INTO cha_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ya mafaesen: Jafa nae? Jago si Elias? Ya ilegña: Ti guajo yo. Jago ayo na profeta? Ya manope: Aje. ");
INSERT INTO cha_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Enaomina ilegñija nu güiya: Jaye jao? para siñajam infanmanope ni y tumago jam. Jafa ilelegmo nu jago namaesa? ");
INSERT INTO cha_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ylegña: Guajo inagang yo nu y umaagang gui desierto; natunas y chalan señot, taegüije ilegña si Esaias profeta. ");
INSERT INTO cha_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ya ayo sija ni namanmato ni y guinin Fariseo sija. ");
INSERT INTO cha_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ya mafafaesen güe ya ilegñija nu güiya: Sajafa na managpangejao, yaguin ti jago si Jesucristo, ni si Elias, ni y ayo na profeta? ");
INSERT INTO cha_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Si Juan manope ilelegña: Guajo managpagpange an janom; mas y entalo miyo, guaja uno na ti intingo. ");
INSERT INTO cha_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Este uje y mamaela gui tateco, y mas dangculo qui guajo, ya guajo ti dignoyo na jupula ni y coreas y sapatosña. ");
INSERT INTO cha_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Este sija finatinas guiya Betania y otra banda gui Jordan, anae managpagpange si Juan. ");
INSERT INTO cha_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Y siguiente na jaane jalie si Juan si Jesus na mamaela para iya güiya ya ilegña: Estagüe y corderon Yuus na janajanao y isao gui tano. ");
INSERT INTO cha_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Este yuje ileo, na y tateco mamamaela un laje y dangculoña qui guajo, sa güiya finenena qui guajo. ");
INSERT INTO cha_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ya guajo ti jutungo; lao para umafanue y Israel nu güiya, enao mina mato yo yan managpagpange yo an janom. ");
INSERT INTO cha_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Si Juan manae testiomonio ilegña: Julie y Espiritu ni tumutunog guinin y langet, taegüije y paluma ya sumaga gui jiloña. ");
INSERT INTO cha_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ya guajo ti jutungo güe, lao y munamamaela yo para ufanagpange an janom, ayo sumangane yo: Sobre ayo na unlie na tumunog y Espiritu ya sumaga guiya güiya, este uje y managpagpange ni Espiritu Santo. ");
INSERT INTO cha_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ya guajo julie ya manae yo testimonio nu y güiya y Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Y siguiente na jaane tumalo manmatojgue si Juan yan dos gui disipuluña. ");
INSERT INTO cha_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ya Jaatan si Jesus ni mamomocat güije, ya ilegña: Estagüe y Corderon Yuus. ");
INSERT INTO cha_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ya majungog ni dos na disipuluña comequentosña yan madalalag si Jesus. ");
INSERT INTO cha_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ya jabira güe si Jesus ya jalie na madadalalag güe nu sija ya ilegña nu sija: Jafa inaliligao? Ya sija ilegñija: Rabi (este finijo comequeilegña, gui chamorro, Maestro) manu sagamo? ");
INSERT INTO cha_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ylegña: mamaela ya unlie. Manmamaela ya jalie manu nae sumaga ya mañagaja yan güiya, güije na jaane, sa jijut y ora y mina dies. ");
INSERT INTO cha_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si Andres y chelun Simon Pedro, güiya uno gui dos y jumungog umadingan an Juan, yan madalalag güe. ");
INSERT INTO cha_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Güiya jasoda finena y cheluña as Simon, ya ilegña nu güiya: Tasoda y Mesias (ni y cumequeilegña: güiya si Cristo). ");
INSERT INTO cha_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ya macone guato as Jesus; anae inatan as Jesus ilegña: Jago Simon, patgon Jonas: jago mafanaan Sefas (cumequeilegña: acho). ");
INSERT INTO cha_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Y siguiente na jaane, malago si Jesus malag Galilea, ya jasoda si Felipe, taotao Betsaida, gui siudan Andres yan Pedro. ");
INSERT INTO cha_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Si Felipe jasoda si Nataniel ya ilegña nu güiya: Esta tasoda ayo y jatugue si Moises gui tinago yan y profeta, Jesus, taotao Nasaret y patgon José. ");
INSERT INTO cha_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ya ilegña si Nataniel: Guinin Nasaret siña jumuyong minauleg? Ylegña si Felipe: maela ya unlie. ");
INSERT INTO cha_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Si Jesus jalie mamaela para iya güiya, si Nataniel, ya ilegña nu güiya: Estagüe senmagajet iyon Israel, na taya finababa guiya güiya. ");
INSERT INTO cha_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ylegña nu güiya si Nataniel: Guine manu na untungo yo? Manope si Jesus ya ilegña nu güiya: Antes di si Felipe uninagang, na gaegue jao gui papa y ygos, guajo julie jao. ");
INSERT INTO cha_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Manope si Nataniel ya ilegña: Rabi, jago uje y lajin Yuus, jago uje y ray guiya Israel. ");
INSERT INTO cha_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Manope si Jesus ya ilegña nu güiya: Sa jusangane jao, na julie jao gui papa y ygos, ya unjonggue? Jago unlie mandangculoña na güinaja qui este. ");
INSERT INTO cha_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ylegña nu güiya: Magajet ya magajet jusangane jao, y mamaela na tiempo nae unlie y langet mababa ya y angjet sija guine as Yuus mangajujulo yan manututunog gui jilo y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Y mina tres na jaane, mafatinas y guipot umasagua, gui Cana, siudan Galilea, ya y nanaña si Jesus gaegue güije. ");
INSERT INTO cha_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ya si Jesus yan y disipuluña maagange locue para y guipot umasagua. ");
INSERT INTO cha_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Anae taya y bino, y nanaña si Jesus ilegña nu güiya: Taya binoñija. ");
INSERT INTO cha_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ya ilegña nu güiya si Jesus: Pot jafayo na juentalo nu jago, palaoan? trabia ti mafato y orajo. ");
INSERT INTO cha_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Si nanaña ilegña ni manmañeñetbe: Fatinas todo y tinagoña. ");
INSERT INTO cha_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y estaba güije saes lauyan acho, parejoja yan y guinasgasñija y Judios, na manulat, cada uno, dos pat tres cantaro. ");
INSERT INTO cha_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ylegña si Jesus nu sija: Nafanbula este sija lauyan janom. Ya manafanbula asta y pachot. ");
INSERT INTO cha_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ya ilegña nu sija: Chile pago ya innae y maestrosala; ya machule. ");
INSERT INTO cha_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ya anae y maestrosala jachague y janom na mafatimas bino, ya ti jatungo guine mano: (lao y manmañeñetbe tumungo, na jachule y janom), y maestrosala jaagange y nobio; ");
INSERT INTO cha_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ya ilegña nu güiya: Todo y taotao janafofona y mauleg na bino; ya yaguin esta manjaspog, ayo nae y mas manaelaye: lao jago unnanana y mauleg na bino asta pago. ");
INSERT INTO cha_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Este na tutujon y señatña sija, jafatinas si Jesus, guiya Cana suidan Galilea, ya janamatungo y minalagña; ya y disipuluña sija majonggue güe. ");
INSERT INTO cha_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Despues di este tumunog guiya Capernaum, güiya yan y mañeluña yan y disipuluña sija, ya mañaga güije ti megae na jaane. ");
INSERT INTO cha_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Y estaba güije jijot y pascuan y Judios, ya si Jesus cajulo guiya Jerusalem. ");
INSERT INTO cha_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ya jasoda gui guimayuus manmanbebende y nubiyo yan y quinilo, yan y paluma, yan y manmanulalaeca manmatatachong: ");
INSERT INTO cha_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ya mañaolag ni tale, ya janafanmalago todo gui guimayuus, yan y quinilo, yan y nubiyo; yan y machapon y salape y manmanulalaeca, yan manaalinquin y lamasa, ");
INSERT INTO cha_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ya ilegña ni manmanbebende ni paluma: Nafanjanao güine este sija na güinaja, ya chamiyo fumatitinas y guima tata, guima namajan. ");
INSERT INTO cha_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Entonses manmanjaso y disipuluña ni estaba matugue: Ynigo y guimamo cumano yo. ");
INSERT INTO cha_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Y Judio sija manmanope ya ilegñija; Jafa na señat unfanuejam taegüije ayo, sa jago unfatinas este sija na güinaja? ");
INSERT INTO cha_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Si Jesus manope ya ilegña: Yulang este na gumayuus, ya y tres na jaane; junacajulo talo. ");
INSERT INTO cha_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ayonae y Judio sija ilegñija: Gui cuarentaisaes años manacajulo este na gumayuus, ya jago, gui tres na jaane, unacajulo? ");
INSERT INTO cha_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lao güiya umadingan ni guima tataotaoña. ");
INSERT INTO cha_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Enao mina anae cajulo guine manmatae, y disipuluña jajaso na munjayan jasangane este, ya manmanjonggue ni tinigue sija yan y sinangan ni jasangan si Jesus. ");
INSERT INTO cha_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ya, güiya gaegue guiya Jerusalem gui pascua, y jaane ni guipot, ya megae manmanjonggue ni naanña, anae malie sija y señatña sija ni jafatinas. ");
INSERT INTO cha_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lao si Jesus namaesa, ti jaangoco güe guiya sija, sa güiya jatungo todo taotao, ");
INSERT INTO cha_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ya taya nesesida na jaye unae testimonio ni taotao, sa güiya tumungo y guaja gui jalom taotao. ");
INSERT INTO cha_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","YA guaja un taotao Fariseo na naanña si Nicodemo, prinsipe y Judiosija. ");
INSERT INTO cha_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Este mato gui as Jesus gui puenge ya ilegna nu güiya: Rabi, jame intingo na jago maestro guine as Yuus, sa taya siña fumatinas este sija na señat, ni unfatitinas, yaguin ti sumisija yan Yuus. ");
INSERT INTO cha_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ynepe as Jesus ya ilegña nu güiya: Magajet ya magajet y jusangane jao, na y ti mafañago talo, ti siña jalie y raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ylegña nu güiya si Nicodemo: Jafa muna siña y taotao mafañago yaguin este biju; siña güe jumalom dos biaje, talo gui jalom y tiyan nanaña ya umafañago? ");
INSERT INTO cha_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ynepe as Jesus: Magajet ya magajet jusangane jao, na y ti mafañago ni janom yan ni iyon Espiritu, ti siña jumalom gui raenon Yuus. ");
INSERT INTO cha_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Todo y mafañago ni guine catne, catneja güe; ya y mafañago guine Espiritu, espirituja güe. ");
INSERT INTO cha_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Chamo ninamamanman ni jusangane jao: Y nesesita jamyo na mafañago talo. ");
INSERT INTO cha_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Y manglo manguaefe mano malagoña, ya unjungog y bengbengña, lao ti untungo guine manu mague, ni tampoco para manu guato. Taegüenao todo ayo y manmafañago guine Espiritu. ");
INSERT INTO cha_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Si Nicodemo manope ya ilegña: Jafa muna siña este? ");
INSERT INTO cha_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ynepe as Jesus ya ilegña nu güiya: Jago un maestro guiya Israel ya ti untungo este? ");
INSERT INTO cha_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Magajet ya magajet jusangane jao, Y tatungo, tasangan; ya y talie tadeclara, ya ti inresibe y testimoniota. ");
INSERT INTO cha_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yaguin jusangane jao güinajan tano, ya ti unjonggue, jafa taemano unjonggue yaguin jusangane jao güinajan langet? ");
INSERT INTO cha_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ya taya cajulo gui langet, güiyaja y tumunog guine y langet, güiya matungo, y Lajin taotao ni y gaegue gui langet, ");
INSERT INTO cha_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ya jaf taemanoja si Moises janacajulo y serpiente gui desierto, taegüijeja na nesesita na y Lajin taotao umanacajulo. ");
INSERT INTO cha_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Para todo ayo y jumonggue güe, ti siña malingo, ya guaja linâlâña na taejinecog. ");
INSERT INTO cha_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sa taegüenao na jaguaeya si Yuus y tano, janae ni linilisja Lajiña y para todo ayo y jumonggue güe, ti siña malingo, ya guaja linâlâña na taejinecog. ");
INSERT INTO cha_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sa ti jatago si Yuus y Lajiña guato gui tano, para usapit y tano, lao para y tano unalibre pot güiya. ");
INSERT INTO cha_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Y jumonggue güe, ti umasapit; ayo y ti jumonggue güe ayo umasapit, sa ti manjonggue ni naan unoja na Lajin Yuus. ");
INSERT INTO cha_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ya este na sinapit, na y inina malag y tano, ya y taotao sija gaonñija y jemjom qui y inina, sa y finatinasñija taelaye. ");
INSERT INTO cha_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sa todo ayo y fumatinas y taelaye, chatlie y inina, ya ti malag y inina, sa y chechoña no sea umareprende. ");
INSERT INTO cha_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ayo y fumatinas y magajet, malag y inina, para y unamatungo finatinasña, sa y finatinasña guine as Yuus. ");
INSERT INTO cha_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Despues di estesija, mato si Jesus yan y disipuluña sija, gui un tano Judea ya gaegue güije yan sija managpange. ");
INSERT INTO cha_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Managpapange locue si Juan, guiya Enon, jijot guiya Salim, sa gaegue güije megae na janom: ya sija manmamaela, ya manmatagpange. ");
INSERT INTO cha_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sa si Juan trabia ti mapopolo gui catset. ");
INSERT INTO cha_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ya guaja un inaguaguat entre sija yan y disipulon Juan yan y Judio sija pot y guinasgas. ");
INSERT INTO cha_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ya manmato gui as Juan, ya ilegñija nu güiya: Rabi, ayo y gaegue güije guinin iya jago, gui otro banda Jordan ni unnae testimonio, estagüe! na jatagpange, yan y todo y taotao manmato guiya güiya. ");
INSERT INTO cha_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Manope si Juan ilegña: Ti siña y taotao manresibe jafa, yaguin ti manae guine y langet. ");
INSERT INTO cha_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jamyoja innae testimonio na guinin jusangan: Ti guajo si Jesucristo, lao guajo matago gui menaña. ");
INSERT INTO cha_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ya guaja asaguaña, güiya y nobio locue; lao amigon nobio, ni y tomotojgue ya jajujungogja, ya magof dangculo pot y sinangan y nobio. Taegüine pues este minagofjo esta macumple. ");
INSERT INTO cha_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Güiya siempre, lumálamodong; ya guajo manaladiquique. ");
INSERT INTO cha_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Y guinin jila mague, güiya mas taquilo qui todo; ya y iyon y tano, tanoja güe, ya iyon y tanoja jasasangan; ya y mamaela guine langet, güiya iyajululo. ");
INSERT INTO cha_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tanae testimonio, nu y lumie ya jajungog, ya taya rumesibe y testimonioña. ");
INSERT INTO cha_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ya y rumesibe y testimonioña, este sumeyo na si Yuus, güiya magajet. ");
INSERT INTO cha_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sa y tinago as Yuus, y fino Yuus jasangan; sa si Yuus ti mannanae güe ni y Espiritu pot medida. ");
INSERT INTO cha_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Sa y tata yaña y Lajiña ya todo y güinaja japolo gui canaeña. ");
INSERT INTO cha_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Y jumonggue y Lajiña guaja taejinecog na linâlâ; ya ayo y ti manjonggue y Lajiña, ti ulie linâlâ, lao y binibon Yuus gaegue gui jiloña. ");
INSERT INTO cha_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ANAE y Señot jatungo, na Fariseo sija manmanjungog, na si Jesus jafatinas disipuluña ya jatagpange megaeña qui si Juan. ");
INSERT INTO cha_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Achogja ti si Jesus namaesa matagpange, lao y disipuluñaja), ");
INSERT INTO cha_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jadingo guiya Judea, ya mapos talo malag Galilea. ");
INSERT INTO cha_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ya janesesita na umalofan inanaco Samaria. ");
INSERT INTO cha_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mato pues gui un siudan Samaria, na mafanaan Sicar, jijot gui fangualuan na si Jacob janae si José, lagiña. ");
INSERT INTO cha_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ya gaegue güine y tipo Jacob. Enaomina si Jesus, sa yayas güe guinin y chalan, matachong gui oriyan y tipo. Güenao na ora cana a las saes. ");
INSERT INTO cha_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mato un palaoan Samaria para ufanlupog janom; ya si Jesus ilegña nu güiya: Naeyo ya juguinem. ");
INSERT INTO cha_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Sa y disipuluña manmapos para y siuda, para ufanmamajan nengcano. ");
INSERT INTO cha_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ylegña nu güiya y palaoan Samaria: Jaftaemano na jago y Judio jao, ya untagojit najunaguinemjao, ya guajo palaoan Samaria? (Sa y Judio sija ti manatungo yan y taotao Samaria). ");
INSERT INTO cha_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Manope si Jesus, ya ilegña nu güiya: Yaguin untungo y ninaeña si Yuus yan jaye güe y sumangane jao, naeyo ya juguinem: jago ungagao güe ya güiya unninae janom lalâlâ. ");
INSERT INTO cha_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ya y palaoan ilegña nu güiya: Señot, taya siña unlupog, sa y tipo tadong: amano pues nae guaja jao ni y janom lalâlâ. ");
INSERT INTO cha_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ada dangculoña jao qui y tatanmame as Jacob, ni y numaejam nu este na tupo, ya güiya gumiguinem yan famaguonña, yan y gaña gâgâ sija? ");
INSERT INTO cha_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Manope si Jesus, ya ilegña nu güiya: Jaye y guminem nu este na janom, güiya umajo talo. ");
INSERT INTO cha_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lao ayo y guminem uje na janom y junae güe, para todo y tiempo ti umajo; ya ayo na janom y guajo junae güe, güiya y janom tupo, ni jumuyong para linâlâ na taejinecog. ");
INSERT INTO cha_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ylegña nu güiya y palaoan: Señot, naeyo nu este na janom para ti siñayo majo, ni jutalo mague para jufanlupog. ");
INSERT INTO cha_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Si Jesus ilegña nu güiya: Janao agange y asaguamo, ya unmamaela güine mague. ");
INSERT INTO cha_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Manope y palaoan ya ilegña nu güiya: Taya asaguajo. Ylegña nu güiya si Jesus: Mauleg sinanganmo na ilegmo. Taya asaguajo. ");
INSERT INTO cha_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sa sinco jagas asaguamo; ya pago y gaegue guiya jago, ti güiya y asaguamo: este unsangan pot minagajet. ");
INSERT INTO cha_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ya ilegña nu güiya y palaoan: Señot, pineloco nu jago, profeta jao. ");
INSERT INTO cha_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Y tatanmame manmanadodora güine gui jalomtano, ya jamyo ilegmiyo, na iya Jerusalem, ayo na lugat, siempre nae umafatinas y adorasion. ");
INSERT INTO cha_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ylegña nu güiya si Jesus: Palaoan, jonggue yo sa ufato y ora, na ti este na jalomtano, ni iya Jerusalem, inadora jamyo si Yuus Tata. ");
INSERT INTO cha_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jamyo inadora ti intingo. Jame inadora y tiningomame, sa y satbasion y Judio sija güiya. ");
INSERT INTO cha_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lao y jaane umamaela, ya güiya güe pago, nae y magajet na manmanadododora, uje adodora si Yuus Tata gui espiritu yan y minagajet; sa si Yuus Tata, locue jaaliligao ayo sija y umadodora güe. ");
INSERT INTO cha_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Yuus, güiya Espiritu, ya y umadora güe, siempre jaadora güe y espiritu yan y minagajet. ");
INSERT INTO cha_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ylegña nu güiya y palaoan: Guajo jutungo na y Mesias umamaela (ayo y naanña si Cristo); yaguin mato güe, güiya ufanagüejit todo. ");
INSERT INTO cha_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ylegña nu güiya si Jesus: Guajoyo, ni umadingangane jao. ");
INSERT INTO cha_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ya pot este manmato y disipuluña ya ninafanmanman pot y umadingan yan y palaoan: ya ni uno siña umalog: Jafa finaesesenmo? pat, pot jafa uncuentutuse güe? ");
INSERT INTO cha_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Taegüenao y palaoan japolo y batdeña, ya mapos malag y siuda, jasangane y taotao sija ya ilegña: ");
INSERT INTO cha_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Fanmamaela ya inlie un taotao ni sumangane yo todo y finatinaso! Güiya buente si Cristo? ");
INSERT INTO cha_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Manmapos gui siuda, ya manmalag as Jesus. ");
INSERT INTO cha_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ayo na tiempo magagagao güe ni disipulo sija, ilegñija: Rabi, chocho! ");
INSERT INTO cha_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ya güiya ilegña na sija: Guaja najo nengcano na jamyo ti intingo. ");
INSERT INTO cha_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Enaomina y disipulo sija ilegñija entre sija: Buente guaja chumulilie naña? ");
INSERT INTO cha_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Si Jesus ilegña nu sija: Y nengcanojo y jufatinas y minalago ayo y tumago yo, ya magpo chechoña. ");
INSERT INTO cha_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ya ti ilegmiyo: Guaja trabia cuatro na meses nae ufato y quineco? Estagüe na jusangane jamyo: Fanalagquilo y matanmiyo ya inatan y fangualuan sija, sa esta manapaca para quineco. ");
INSERT INTO cha_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ya y mangoco uresibe y apasña, ya uchule y tinegcha para taejinecog na linâlâ; para ayo y mangoco, ya ayo y manananom mandaña gui minagof. ");
INSERT INTO cha_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ya pot este macumple y sinangan: uno manananom ya y otro mangongoco. ");
INSERT INTO cha_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Guajo jamyo tumago para infanmangoco ya ti jamyo chumogüe; otro manmachocho ya jamyo manjalom gui chechoñija. ");
INSERT INTO cha_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ya megae na taotao Samaria, taotao güije na siuda, manmanjonggue nu güiya pot y sinangan y palaoan, sa manae testimonio na ilegña: Jasangane yo todo ni y finatinasjo. ");
INSERT INTO cha_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Enao mina anae y taotao Samaria manmato guiya güiya, magagao na usaga ya ufandaña; ya güiya sumaga güije dos na jaane. ");
INSERT INTO cha_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ya y manmanjonggue nu güiya gofmegae pot y sinanganña. ");
INSERT INTO cha_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ya ilegñija nu y palaoan: Pago ti pot y finomo na injenggue; sa jame mismo injingog güe, ya intingo na este, güiya y magajet na Salvadot y tano. ");
INSERT INTO cha_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ya depues di dos na jaane, jumanao güije ya malag Galilea. ");
INSERT INTO cha_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Potjafa na si Jesus mismo manae testimonio, na y profeta gui tanoña taya onraña. ");
INSERT INTO cha_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ya pot este anae malag Galilea, y taotao Galilea maresibe güe sa malie todo y finatinasña guiya Jerusalem, na jafatinas gui tiempo y guipot; sa sija locue manmalag y guipot. ");
INSERT INTO cha_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mato, otro biaje, si Jesus, guiya Cana siuda guiya Galilea, nae y jafatinas bino y janom: ya guaja güije un magalaje na y lajiña malango guiya Capernaum. ");
INSERT INTO cha_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ya anae jajungog na si Jesus, jumanao gui Juda ya tumunog para Galilea, mapos güe malag as Jesus, ya jagagao na utunog guiya Capernaum, ya uamte y lajiña, sa esta cumequematae. ");
INSERT INTO cha_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Enao mina si Jesus ilegña nu güiya: Yaguin ti inlie señat sija, yan y ninamanman sija, ti injenggue. ");
INSERT INTO cha_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ya ilegña y magalage nu güiya: Señot, tunog lasajyao, antes qui umatae y lajijo! ");
INSERT INTO cha_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ylegña si Jesus nu güiya: Janao, sa y lajimo lâlâ! Jajonggue y taotao y sinangan Jesus ni y sinangane güe, ya mapos. ");
INSERT INTO cha_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ya anae güiya tumutunog, y familiaña matagam güe ya masangane na ilegñija, Na y lajimo lâlâ! ");
INSERT INTO cha_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mamaesen jafa na ora y lajiña na mumauleg, ya ilegñija: Nigap gui las siete na ora pinelo ni calenturaña. ");
INSERT INTO cha_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jatungo y tataña enao na ora nae sinangane güe as Jesus, Y lajimo lâlâ; ya güiya namaesa jajonggue yan todo y familiaña! ");
INSERT INTO cha_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Este y mina dos na señat, na jafatinas si Jesus, anae jinanaoña guiya Judea, para Galilea. ");
INSERT INTO cha_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","DESPUES di manmalofan este sija, guaja gupot y Judio sija ya si Jesus cajulo guiya Jerusalem. ");
INSERT INTO cha_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ya iya Jerusalem, jijot gui petta quinilo sija, guaja un tangque janom na mafananaan gui fino Hebreo, Betesda, na guaja sinco potta. ");
INSERT INTO cha_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ya manestaba güije megagae na manmalango: bachet, mangojo, yan mansogsog. ");
INSERT INTO cha_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ya gaegue güije un taotao na esta malofan treinta y ocho años na malango. ");
INSERT INTO cha_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Linie as Jesus na umaason, ya anae jatungo na amam na tiempo, ilegña nu güiya: Malago jao na umagong? ");
INSERT INTO cha_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ynepe güe ni y malango: Señot, taya jaye yo unninajalom gui tangque y tiempo nae y janom sigue ni calalamten, ya anae jumajanaoyo, otro tumunog antes qui guajo. ");
INSERT INTO cha_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sinanangane as Jesus: Cajulojao, jatsa y camamo ya unjanao! ");
INSERT INTO cha_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ya enseguidas magong y chetnot ayo na taotao, ya jajatsa y camaña ya mapos. Lao ayo na jaane sabado. ");
INSERT INTO cha_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ylegñija y Judio sija nu y manamagong: Sabado, este na jaane, ti tunas unchule y camamo! ");
INSERT INTO cha_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Manope güe: Ayo y munamagong yo, güiya namaesa sumangane yo: jatsa y camamo ya unjanao. ");
INSERT INTO cha_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Entonses mafaesen güe: Jaye enao na taotao y sumangane jao, na unjatsa y camamo yan unjanao? ");
INSERT INTO cha_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ayo y guinin minamagong güe, ti jatungo jaye; sa si Jesus esta mapos, sa gaegue güije na lugat, un linajyan taotao. ");
INSERT INTO cha_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Sineda güe despues as Jesus, gui templo, ya ilegña: Estagüe esta magong jao; chamo umiisao talo no sea na taelayeña qui este ufato guiya jago. ");
INSERT INTO cha_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ayo na taotao mapos, ya jasangane Judio sija na si Jesus ninamagong y chetnotña. ");
INSERT INTO cha_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ya pot este na rason, y Judio sija madulalag si Jesus, sa y jafatinas este na güinaja gui sabado na jaane. ");
INSERT INTO cha_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Entonses si Jesus maninepe: Si tatajo jafatitinas asta pago, yan guajo locue jufatitinas. ");
INSERT INTO cha_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ya pot este na rason y Judio sija japrocura mas dangculo para ujapuno, say ti janainaleja y sabado na jaane, lao pot y jasangan locue na si Yuus güiya y tataña; jafatitinas güiyaja parejo yan si Yuus. ");
INSERT INTO cha_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Entonses si Jesus manope ilegña nu sija: Magajet ya magajet jusangane jamyo: Ti siña y Lajiña jafatinas jafa pot güiya namaesa, lao jafa y jalie finatinas y tata; sa todo y finatinasña, taemanoja y Lajiña locue fumatinas. ");
INSERT INTO cha_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sa y Tata yaña y Lajiña ya jafanue nu güiya todo ni jafatitinas; ya jafanue nu güiya y checho ni mandangculo, ya jamyo unfanmanman. ");
INSERT INTO cha_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sa taegüenao si Tata janafangajulo y manmatae ya jananae linâlâñija, taegüije locue y Lajiña janae y linâlâ, jaye malagoña. ");
INSERT INTO cha_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Sa y Tata taya jaye jajujusga, lao todo y juisio, janae y Lajiña. ");
INSERT INTO cha_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Para todo ufanmanonra ni Lajiña jaf taemanoja jaonra y Tata. Ya y ti umonra y Lajiña, ti jaonra si Tata ni tumago güe. ");
INSERT INTO cha_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Magajet ya magajet jusangane jamyo: Y jumungog y sinanganjo, ya jumonggue ayo y tumago yo, guaja linâlâfia taejinecog; ya ti ufato gui sinapet; lao esta malofan guine y finatae para y linâlâ. ");
INSERT INTO cha_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Magajet ya magajet jusangane jamyo: Y ora mamamaela, ya pago esta; na y manmatae sija ujajungog y inagang Lajin Yuus; ya ayo sija y jumungog, ufanlâlâ. ");
INSERT INTO cha_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sa taegüine y Tata guaja linâlâfia guiya güiyaja; taegüineja janae locue y Lajiña, para uguaja linâlâña guiya güiyaja: ");
INSERT INTO cha_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ya janae locue ninasiñaña para ufatinas juisio, sa güiya y Lajin taotao. ");
INSERT INTO cha_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Chamiyo ninafanmamanman ni este: sa y ora mamamaela, na todo ayo sija y mangaegue gui naftan, umajungog y inagangña, ");
INSERT INTO cha_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ya jumanao juyong; y fumatinas mauleg, ufanjuyong gui quinajulo para linâlâ; ya ayo sija y fumatinas taelaye, y quinajulo para sinapit. ");
INSERT INTO cha_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ti siña yo namaesa mamatinas jafa: taemanoja y jiningogco, ayoja jujusga, sa y juisioco tunas, sa ti jualiligao y minalagojo; lao y minalago y tata ni tumago yo. ");
INSERT INTO cha_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yaguin mannae yo testimonio nu guajo namaesa, y testimoniojo ti magajet. ");
INSERT INTO cha_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Guaja otro na mannanae testimonio. nu guajo; ya guajo jutungo na y testimonioña, ni y ninaiña pot guajo, magajet. ");
INSERT INTO cha_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jamyo manmatago para as Juan, ya güiya mannae testimonio ni magajet; ");
INSERT INTO cha_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Lao y testimonio ni juresibe, ti guinin y taotao: lao jusangane estesija, para jamyo infanlibre. ");
INSERT INTO cha_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Güiya y lámpara ni masonggue ya maniina; ya jamyo infanmalago manmagof didide na tiempo gui candetña. ");
INSERT INTO cha_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ya y testimonio ni gaegue guiya guajo mas dangculo qui y gaegue gui as Juan; sa y finatinas ni y Tata numaeyo para umacumple, ayo na finatinas na guajo jufatinas; este jatestifica nu guajo, nu y Tata tumago yo. ");
INSERT INTO cha_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Si Tata locue ni y tumago yo, güiya namaesa mannae y testimonio nu guajo. Jamyo tat nae injingog bosña, ni locue ti inlie jechuraña. ");
INSERT INTO cha_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ya taya sinanganña sumaga guiya jamyo; sa ti injenggue na güiya manago. ");
INSERT INTO cha_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aligao y tinigue sija sa y jinasonmiyo iya güiya nae inguaja y linâlâ na taejinecog; ya sija todo ufanmannae testimonio nu guajo, ");
INSERT INTO cha_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ti manmalago jamyo manmamaela guiya guajo, para uguaja linâlâ. ");
INSERT INTO cha_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ynenra y taotao sija, guajo ti juresibe. ");
INSERT INTO cha_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lao guajo jutungo jamyo na taya y güinaeyan Yuus ni y gaegueja guiya jamyo. ");
INSERT INTO cha_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Guajo mato yo pot y naan Tatajo, ya ti inresibe yo; yaguin otro mato pot y naanña namaesa, ayo inresibe. ");
INSERT INTO cha_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jafa muna siña injenggue jamyo ni y rumesibe inenra uno sija yan otro, ya ti inaligao y inenraja na mato guine as Yuus na unoja? ");
INSERT INTO cha_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ti injaso na jufaaela jamyo gui as Tata: ya y fumaaela jamyo si y Moises, ayo nae gaegue ininangganmiyo. ");
INSERT INTO cha_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pues yaguin injenggue si y Moises, injenggue yo locue: sa iya guajo nae manugue si Moises. ");
INSERT INTO cha_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lao yaguin tinigueña sija ti injenggue, jafa muna injenggue y sinanganjo? ");
INSERT INTO cha_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","DESPUES di manmalofan estesija, mapos si Jesus malag y otro banda y tasen Galilea, na ayo y tasen Tiberias. ");
INSERT INTO cha_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ya madalalag güe ni y dangculo na linajyan taotao sa jalie sija y megaegae na señat ni jafatinas gui manmalango. ");
INSERT INTO cha_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ya cajulo si Jesus gui un ogso, ya matachong güije yan y disipuluña sija. ");
INSERT INTO cha_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ya jijot y guipot pascua, guipot y Judio sija. ");
INSERT INTO cha_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ya anae tumalag jilo si Jesus, jalie na guaja mamamaela para iya güiya, un linajyan na taotao, ilegña as Felipe: Manu nae tafanmamajan pan para ufañocho este sija? ");
INSERT INTO cha_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jasangan este para uchague güe; sa güiya tumungo jafa ufatinas. ");
INSERT INTO cha_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Manope si Felipe: Dosiento na denario na pan, ti ufannajong para cada uno guiya sija ufañule didide. ");
INSERT INTO cha_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ylegña nu güiya, uno gui disipuluña sija, Andres, chelun Simon Pedro: ");
INSERT INTO cha_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Un patgon gaegue güine na guaja sinco pan sebada yan dos güijan na diquique: Lao jafa na estesija, gui entalo y este na minegae? ");
INSERT INTO cha_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ylegña si Jesus: Nafanason y taotao. Ya megae na chaguan gaegue güije na lugat, ya manason y taotao, cana sinco mil na lalaje. ");
INSERT INTO cha_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ya jachule si Jesus ayo sija na pan ya anae janae si Yuus grasias, jaipie todo ayo y manaason; taegüijija locue ni y güijan sija, jaf taemanoja y minalagoñija. ");
INSERT INTO cha_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ya anae manjaspog ilegña ni disipuluña sija: Joca todo y dinidide ni y tetenjan, sa munga guaja malingo. ");
INSERT INTO cha_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ya jajoca todo, ya janabula dose na canastran dangculo ni y dinidide, dinididin y sincoja na pan sebada, y tejnan ayo sija y mañocho. ");
INSERT INTO cha_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ayo sija na taotao, anae jalie y señat ni jafatinas si Jesus, ilegñija: Este senmagajet na güiya y profeta ni para umamaela gui tano. ");
INSERT INTO cha_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ayo na tiempo jatungo si Jesus, na ufanmamaela para umacone pot minetgot, ya jafatinas y ray, tumalo guato gui un jalomtano güigüiyaja namaesa. ");
INSERT INTO cha_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Anae esta pupuenge manunog y disipuluña sija gui tase. ");
INSERT INTO cha_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ya manjalom gui un sajyan, ya manchinichile ni tase para Capernaum. Ya pago jomjom, ya si Jesus ti manfinatotoe sija. ");
INSERT INTO cha_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ya cajulo dangculo na napon pot rason un dangculo na manglo na manguaefe. ");
INSERT INTO cha_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ya anae esta manmamogsae gui tase calang bente sinco pot trenta estadio, malie si Jesus na mamomocat gui jilo y tase ya lumalajijot guato gui sajyan: ya manmaañao sija. ");
INSERT INTO cha_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lao güiya ilegña nu sija: Guajoyo; chamiyo fanmaañao! ");
INSERT INTO cha_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Manmagof anae maresibe gui sajyan; ya ensiguidas mato y sajyan gui tano ni y jajananao güe. ");
INSERT INTO cha_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Y inagpaña na jaane, y linajyan taotao ni gaegue gui otro bandan tase, jalilie na taya güije mas na unoja na sajyan diquique, ya jatungo na si Jesus ti jumalom gui sajyan yan y disipuloña sija, lao y disipuloña sija esta manmapos sijaja; ");
INSERT INTO cha_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Ya manmato sija y sajyan diquique guine Tiberias, jijot güije na lugat anae mañocho ni pan, despues di y Señot janae si Yuus grasias.) ");
INSERT INTO cha_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ya anae jalie y linajyan taotao sija na si Jesus taegüe güije, ni y disipuluña sija; manjalom sija locue gui sajyan diquique, ya manmapos para Capernaum, maaliligao si Jesus. ");
INSERT INTO cha_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ya anae masoda gui otro bandan tase, ilegñija nu güiya: Rabi Ngaean nae mato jao güine? ");
INSERT INTO cha_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Maninepe as Jesus ilegña: Magajet ya magajet jusangane jamyo; na inaliligao yo, ti pot y liniimiyo ni señat sija; lao pot y quinanomiyo ni pan, y ninafanjaspog jamyo. ");
INSERT INTO cha_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Fanmachocho, munga para ayo y fafalingo na nengcano, lao ayo na nengcano y sumaga taejinecog na linâlâ, ni y Lajin taotao numae jamyo; sa güiya sineyo ni Tata, si Yuus. ");
INSERT INTO cha_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Enao mina ilegñija nu güiya: Jafa tafatinas, para utafatinas y checho Yuus? ");
INSERT INTO cha_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Si Jesus manope ilegña nu sija: Este y checho Yuus, na injenggue ayo y jatago. ");
INSERT INTO cha_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Entonses ilegñija nu güiya: Jafa na señat unfatinas para inlie, ya injenggue jao? Jafa chechomo? ");
INSERT INTO cha_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Si tatanmame jacano y mana gui desierto, taemanoja y munjayan matugue; pan guine y langet manmanae para u jacano. ");
INSERT INTO cha_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ya ilegña si Jesus nu sija: Magajet ya magajet jusangane jamyo, na ti si Moises numae jamyo ni pan guine y langet, si Tatajo janae jamyo ni magajet na pan guine y langet. ");
INSERT INTO cha_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sa y pan Yuus ayo y tumunog guine y langet, ya jananae linâlâ y tano. ");
INSERT INTO cha_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ayo nae ilegñija nu güiya: Señot naejam siempre ni este na pan! ");
INSERT INTO cha_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Si Jesus ilegña nu sija: Guajo y pan lalâlâ; y mato guiya guajo, ti uñalang; ya y jumonggue yo, ti umajo para taejinecog. ");
INSERT INTO cha_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lao jusangane jamyo; na este inlie yo ya ti injenggue. ");
INSERT INTO cha_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Todo y janae yo si Tata, ufato guiya guajo; ya ayo y ufanmato guiya guajo, gosmagajet na guajo ti siña juyute güe juyong. ");
INSERT INTO cha_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sa tumunog yo guine y langet ti para jufatinas y minalagojo, lao y minalagoña ayo y tumago yo. ");
INSERT INTO cha_vpl VALUES ("J