﻿USE sofia;
DROP TABLE IF EXISTS sofia.cgc_vpl;
CREATE TABLE cgc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cgc_vpl WRITE;
INSERT INTO cgc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","6","Yi sinulat parti ta mga kaapuan na alinan Jesu-Cristo na isya na linai Ari David, daw Ari David an isya na linai Abraham. Abraham an amay Isaac daw isya ta mga bata din Jacob na amay Juda daw iya na mga utod. Juda an nangasawa ki Tamar daw darwa iran na bata, Fares daw Zara. Fares an amay Esrom daw iya na bata Aram, Aram an amay Aminadab daw iya na bata Naason, Naason an amay Salmon na nangasawa ki Rahab daw iran na bata Booz. Booz an nangasawa ki Ruth. Obed iran na bata. Obed an amay Jesse daw iya na bata Ari David. ");
INSERT INTO cgc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Ari David an nangasawa ta dati na sawa Orias. Solomon iran na bata. Solomon an amay Roboam daw iya na bata Abias, Abias an amay Asa daw iya na bata Josafat, Josafat an amay Joram daw iya na bata Ozias, Ozias an amay Jotam daw iya na bata Acaz, Acaz an amay Esequias daw iya na bata Manases, Manases an amay Amos daw iya na bata Josias, daw Josias an amay Jeconias daw iya na mga utod. Ta timpo Josias, mga Israelinen pabiag daw padala man naan ta Babilonia. ");
INSERT INTO cgc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Alin ta timpo na mga Israelinen pabiag daw padala naan ta Babilonia asta ta pagtao Jesus, yi mga alinan din na kaapuan: Salatiel na bata Jeconias. Salatiel an amay Zorobabel daw iya na bata Abiud, Abiud an amay Eliaquim daw iya na bata Azor. Azor an amay Sadoc daw iya na bata Aquim na amay Eliud. Eliud an amay Eleazar daw iya na bata Matan, Matan an amay Jacob na amay Jose na sawa Maria. Maria an inay Jesus na paumaw na Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gani, naan ta lista i ta mga kaapuan Jesus katursi na sunod-sunuray na mga mag-amay alin ki Abraham asta ki Ari David, daw alin ki Ari David katursi man na sunod-sunuray na mga mag-amay asta ta timpo na mga Israelinen pabiag daw padala naan ta Babilonia, daw katursi man na sunod-sunuray na mag-amay asta ki Jesus na Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iling ti pagtao Jesu-Cristo: Iya na inay na Maria nakagunan Jose. Na ula pa danen nakasal daw ula pa gadumaay, Maria i bagnes en paagi ta gaem ta Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Dili inta miag Jose i na dayunon iran na kasal tak Maria i bagnes. Piro, tenged matareng na ittaw Jose i daw dili man kanen miag na magayyaan Maria an, paisip din na belagan ta sikrito nang. ");
INSERT INTO cgc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na gaminsar nang pa kanen daw ino buaten din, katunuga kanen i. Nali nang, may angil na alin ta Ginuo Dyos na gapakita naan ta iya na dagammo daw gambal, “Jose na linai Ari David, dili ka magdua-dua na Maria an batunon no na imo na sawa tak ganangken kanen an paagi ta gaem ta Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Magbata Maria ta mama daw bata an ngaranan no na Jesus tak kanen an magluwas ta mga ittaw na kalai din alin ta silot ta iran na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iling tan natabo parti ki Maria aged matuman ambal ta Dyos anay pa sa paagi ta isya na prupita na manugsugid ta kabebet-en ta Dyos. Ambal ta prupita, ");
INSERT INTO cgc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Magbagnes dlaga na ula pa natandeg ta mama daw kanen i magbata ta mama. Umawen bata an ta ngaran na Emmanuel.” na beet ambalen “Dyos an naan ki kiten”. ");
INSERT INTO cgc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pagbugtaw Jose, patuman din ambal ya ta angil daw Maria i pabaton din na iya na sawa. ");
INSERT INTO cgc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piro, ula din tandega asta na magbata Maria i ta panganay na bata na mama. Pangaranan Jose bata an na Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus i natao naan ta Betlehem na sakep ta prubinsya Judea ta timpo na Herodes ari dya. Tenged ta iya na pagtao, may gabot na mga mama naan ta Jerusalem alin ta lugar naan dapit ta sennangngan. Danen an mga manugtagna ta matabo paagi ta pagpanilag ta mga bituon. Nanginsa danen an naan ta mga ittaw, ");
INSERT INTO cgc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Indi bata ya na natao na mag-ari ta mga Judio? Nakita nay isya na bituon naan ta sennangngan na tanda ta iya na pagtao daw giling kay di aged mag-atag ta pagdayaw ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na namatian Ari Herodes balita ya na may bata na natao na mag-ari ta mga Judio, gapalibeg kanen i asta man mga ittaw naan ta bilog na Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Paumaw din tanan na mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises daw painsaan din danen an daw ino nabetang naan ta mga sinulat ya parti daw indi matao Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sabat danen, “Naan ta Betlehem na sakep ta prubinsya Judea tak nasulat anay pa sa ta isya na prupita na manugsugid ta kabebet-en ta Dyos: ");
INSERT INTO cgc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kyo na naan ta Betlehem na sakep ta prubinsya Judea, bisan sise nang inyo na banwa, yi bantog gid naan ta Judea tak alin ta inyo na linai mabot isya na manugdumala. Paryo kanen ta manugbantay ta karniro tak kanen manguna daw magbantay ta ake na mga ittaw na mga linai Israel.’” ");
INSERT INTO cgc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagmati Herodes ta sabat danen, pasapol din dayon ta sikrito mga mama na gabot alin ta sennangngan daw painsaan din daw kan-o gid gagwa bituon ya na iran na nakita. ");
INSERT INTO cgc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagsabat danen ta iya na insa, papanaw din danen an naan ta Betlehem daw paambalan, “Sigi, manaw kaw daw ngitaen nyo gid bata ya. Daw makita nyo kanen, sugiran a nyo aged miling a man dya daw mag-atag ta pagdayaw ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pag-ambal ta ari ya, gapanaw danen dayon. Na gapanaw danen, nali nang nakita danen isab bituon ya na dati nakita danen naan ta sennangngan. Sikad gid bakod iran na kalipay na nakita danen bituon ya. Pasunod danen asta na gateneng en usoy ta apaw ta balay na naan dya bata ya. ");
INSERT INTO cgc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gaselled danen ta balay ya daw nakita danen bata an daw iya na inay na Maria. Galuod danen i daw gaatag ta pagdayaw naan ta bata. May dala danen i na maalen na mga rigalo na blawan, kamangyan daw paammot na mira. Pagwa danen iran na mga rigalo daw paatag naan ta bata an. ");
INSERT INTO cgc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na muli en mga mama na alin ta sennangngan, paambalan danen i ta Dyos paagi ta dagammo na dili en danen malik ki Herodes. Tenged ta iran na dagammo, guli danen naan ta iran na lugar na ula en danen gaagi isab naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Paglambay ta pila na mga adlaw na gapanaw en na muli mga mama ya na naan alin ta sennangngan, may angil na alin ta Ginuo Dyos na gapakita isab ki Jose naan ta iya na dagammo na gambal, “Jose, mangon ka daw dleen no bata an daw iya na inay na miling naan ta lugar na Egipto. Naan kaw nang dya anay magtinir mintras ula a pa gambal ki kyo na malik tak ngitaen Herodes bata an aged patayen.” ");
INSERT INTO cgc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pagmati Jose ta ambal ta angil, kilem pa kanen i gabangon daw dleen mag-inay i naan ta Egipto. ");
INSERT INTO cgc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Naan danen dya magtinir asta na Herodes an mapatay. Ta iran na pag-iling naan ta Egipto, natuman ambal ya ta Ginuo Dyos anay pa sa paagi ta isya na prupita: “Papagwa ko ake an na bata alin ta Egipto.” ");
INSERT INTO cgc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na nlaman Herodes na nawaisan kanen an tak mga mama ya na alin ta sennangngan ula gabalik ki kanen, sikad gid gilek din an. Gasugo kanen na patayen tanan na mga bata na mama na gaidad ta darwa taon paebes na naan ta Betlehem daw mga banwa na dani nang. Iling tan sugo din tak ta banta din mga darwa taon idad Jesus tenged ta sugid ta mga mama ya parti daw kan-o danen nakita bituon ya. ");
INSERT INTO cgc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na papatay mga bata na mama tenged ta sugo Herodes, natuman ambal ya ta Dyos paagi ki Jeremias na prupita anay pa sa, ");
INSERT INTO cgc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“May namatian na mga gaug-og daw gaaya naan ta banwa na Rama. Gagal gid Raquel i tenged ta iya na mga bata. Dili kanen an mapalipay tak iya na mga bata ula en.” ");
INSERT INTO cgc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na patay en Herodes ya, may angil alin ta Ginuo Dyos na gapakita eman ki Jose naan ta dagammo din na naan pa danen an ta Egipto. ");
INSERT INTO cgc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Gambal angil i, “Jose, mangon ka. Dleen no mag-inay an daw malik kaw en naan ta lugar na Israel tak patay en mga ittaw ya na gusto na patayen bata an.” ");
INSERT INTO cgc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pagmati Jose ta ambal ta angil, gabangon kanen i daw padala din mag-inay an na malik naan ta Israel. ");
INSERT INTO cgc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piro, na namatian Jose na Arquelao en ari ta prubinsya Judea sal-i ta amay din na Herodes, adlek Jose na malik dya. Gadiritso nang en danen Jose naan ta Galilea tak paandaman kanen ta Dyos naan ta dagammo din na dili malik ta Judea. ");
INSERT INTO cgc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naan danen dya gaistar ta banwa na Nazaret. Ta pag-istar Jesus dya, natuman ambal ya ta Dyos anay pa sa paagi ta mga prupita, “Kanen an umawen na Nazareno.” ");
INSERT INTO cgc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Paglambay ta tama na mga taon alin ta pagtao Jesus, giling Juan i na manugbautismo naan ta lugar na ula kabalayan naan ta Judea. Naan dya Juan i gawali ta mga ittaw na giling ki kanen aged mamati ta iya na wali. ");
INSERT INTO cgc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ambal din, “Magnelsel kaw daw dilian nyo inyo an na mga sala tak anduni abot en upurtunidad na makapasakep kaw ta papaabot nyo na pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan i, kanen ittaw na pasambit naan ta sulat Isaias na prupita anay pa sa: “May ittaw naan ta lugar na ula kabalayan na galaygay na bakod iya na kagi. Ambal din ta mga ittaw, ‘Ipriparar nyo agian an para ta pag-abot ta Ginuo. Tadlengen nyo dalan an na agian din!’” ");
INSERT INTO cgc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan i gabayo ta mga nauman alin ta belbel ta kamilyo daw iya an na bakles buat alin ta langgit ta ayep. Iya an na pagkaan mga apan-apan daw deges ta putyukan. ");
INSERT INTO cgc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sikad tama na mga ittaw giling ki kanen alin ta syudad Jerusalem daw duma pa na mga banwa ta bilog na prubinsya Judea daw mga banwa na dani ta Suba Jordan. ");
INSERT INTO cgc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gaamin danen an ta iran na mga sala daw pabautismuan din danen an naan ta Suba Jordan. ");
INSERT INTO cgc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Piro, na nakita Juan tama na mga Pariseo daw Saduseo na giling man dya aged magpabautismo, pambalan din danen an, “Kyo na malain! Paryo kaw ta mga bata ta bekkessan na dalitan! Salig nyo taan na paagi nang ta inyo na pagpabautismo malikawan nyo mabot an na silot ta Dyos tenged ta iya na kagilek. ");
INSERT INTO cgc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Daw nelselan nyo daw dilian inyo an na mga sala, kinanglan ipakita nyo paagi ta inyo na mga buat. ");
INSERT INTO cgc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dili kaw man magsalig na maluwas kaw alin ta silot ta Dyos na mambal kaw ta inyo na kaugalingen, ‘Kami i mga linai Abraham!’ Sugiran ta kyo na pwidi imuon ta Dyos mga bato na i na linai Abraham! ");
INSERT INTO cgc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tandaan nyo! Priparar en Dyos an na silutan kaw tenged ta inyo na mga sala na paryo kanen ta ittaw na gaalo en ta wasay din naan ta puon ta kaoy na pukanen tak kada kaoy na dili dayad iya na bunga pukanen daw pilak naan ta apoy. ");
INSERT INTO cgc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yaken gabautismo ki kyo paagi nang ta waig na pamatuod na kyo yan ganelsel en daw padilian nyo man en inyo na mga sala. Piro, may mabot sunod ki yaken na mas datas iya na katengdanan kaysa ta ake na katengdanan. Dili a bagay na magsirbi ki kanen maskin ta pagdala nang ta iya na sandal tak datas gid iya na katengdanan. Bautismuan din duma an ki kyo paagi ta Dyos Ispiritu Santo daw duma ya paagi ta apoy. ");
INSERT INTO cgc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kanen an priparar en na magbelag ta mga ittaw na matareng naan ta mga dili matareng. Paryo kanen an ta ittaw na gimes en na panginan iya an na naani na trigo tak gibit en ta gamit na pangpangin aged mabelag linggas an naan ta uot. Trigo an na linggas taguon din naan ta iya na kamalig. Piro, uot an daw uppa sunugon din naan ta apoy na dili mapatay.” ");
INSERT INTO cgc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ta yon man na timpo na tama na mga ittaw gapabautismo ki Juan, Jesus i galin ta Galilea daw miling ki Juan naan ta Suba Jordan aged magpabautismo man. ");
INSERT INTO cgc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piro, dili inta miag Juan i daw ambal din, “Yaken dapat na bautismuan no, piro giling ka di ki yaken para magpabautismo?” ");
INSERT INTO cgc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sabat Jesus, “Buaten no nang anduni tak dapat na tumanen ta liag an ta Dyos.” Pag-ambal Jesus, gakumpurmi Juan na bautismuan din Jesus an. ");
INSERT INTO cgc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na nabautismuan en Jesus daw gatakas kanen ta waig, dayon gabukas langit an daw nakita din Dyos Ispiritu Santo an gapababa naan ki kanen paryo ta salampati. ");
INSERT INTO cgc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","May namatian na gambal na naan ta langit, “Yi ake na bata na palangga ko. Nalipay a gid ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagtapos ta pagbautismo ki Jesus, padala kanen i ta Dyos Ispiritu Santo naan ta lugar na ula kabalayan aged tintaren Satanas. ");
INSERT INTO cgc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Naan dya gapwasa kanen i seled ta kwarinta na adlaw daw kwarinta man na kilem. Paglambay ta kwarinta na adlaw, nletem gid kanen i. ");
INSERT INTO cgc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gabot Satanas na manugtintar daw gambal ki kanen, “Tenged na kaon yan Bata Ta Dyos, imuon no na tinapay mga bato na i.” ");
INSERT INTO cgc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sabat din, “Naan ta sinulat na pulong ta Dyos may ambal, ‘Dili nang ta tinapay mabui mga ittaw. Kinanglan man tanan an na paambal ta Dyos.’” ");
INSERT INTO cgc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagsabat Jesus, padala Satanas kanen i naan ta Jerusalem na syudad ta Dyos daw patindeg naan ta pinakadatas na parti ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ambal Satanas, “Tenged na kaon yan Bata Ta Dyos, mugpa ka tak naan ta sinulat na pulong ta Dyos may ambal, ‘Magsugo Dyos an ta mga angil din na magbantay ki kaon.’ Nasulat man, ‘Saluon ka danen ta iran na mga lima aged dili ka katupa naan ta bato.’” ");
INSERT INTO cgc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sabat eman Jesus, “Naan ta sinulat na pulong ta Dyos may ambal, ‘Dili no piliten Ginuo an na imo na Dyos na pamatuuran din pa iya na pag-amblig ki kaon.’” ");
INSERT INTO cgc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagsabat Jesus, padala Satanas kanen i naan ta sikad datas na bukid daw papakita ki kanen tanan na nasyon ta kalibutan daw iran an na manggad. ");
INSERT INTO cgc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ambal Satanas, “Daw magluod ka ki yaken na sirbian a no, tanan na napakita ko iatag ko ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sabat Jesus, “Layas ka, Satanas! Naan ta sinulat na pulong ta Dyos may ambal, ‘Magsirbi ka ta Ginuo na imo na Dyos. Kanen nang sirbian no.’” ");
INSERT INTO cgc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesus i padilian Satanas daw pila na mga angil gabot daw paasikaso danen Jesus i. ");
INSERT INTO cgc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na nabalitaan Jesus na Juan ya na manugbautismo napriso, galin kanen i ta prubinsya Judea daw malik naan ta lugar na Galilea. ");
INSERT INTO cgc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ula nang en kanen gatinir naan ta banwa na Nazaret tak galakted kanen naan ta banwa na Capernaum daw naan dya gaistar. Capernaum an naan kilid ta Dagat Galilea daw dani ta darwa na lugar na Zabulon daw Neftali. ");
INSERT INTO cgc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tenged naan dya Jesus gistar, natuman ambal ya Isaias na prupita anay pa sa: ");
INSERT INTO cgc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Naan ta mga lugar na Zabulon daw Neftali na gatubang ta dagat daw naan liyo ta Suba Jordan na yon man lugar na Galilea na istaran ta tama na mga ittaw na dili iya ta Dyos, ");
INSERT INTO cgc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mga ittaw dya paryo danen an ta mga ittaw na lugay en gatinir naan ta delem na lugar, piro kakita en ta sikad pawa. Paryo man danen an ta mga ittaw na lugay en gistar naan ta delem na lugar na iran na kabui pirmi naan ta piligro, piro may gapawa en naan ki danen.” ");
INSERT INTO cgc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Alin ta timpo na Jesus i gaistar naan ta Capernaum, kanen i gaumpisa en ta pagwali naan ta mga ittaw na ambal din, “Magnelsel kaw daw dilian nyo inyo an na mga sala tak anduni abot en upurtunidad na makapasakep kaw naan ta papaabot nyo na pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na gapanaw Jesus i naan ta kilid ta Dagat Galilea, nakita din darwa na mag-utod na mananagat na Simon na paumaw man na Pedro daw iya na utod na Andres na danen an galaya. ");
INSERT INTO cgc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Gambal Jesus i ki danen, “Muyog kaw ki yaken aged imuon ta kyo na ake na mga tinudluan. Paryo ta ubra nyo na kyo yan mananagat ta sidda yon man imuon ta kyo na mananagat ta mga ittaw tak tudluan ta kyo na maglaygay ta mga ittaw na magpasakep danen ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pag-ambal Jesus, pabilin dayon danen iran ya na mga laya daw gakuyog ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Gapadayon Jesus i ta pagpanaw daw naan ta unaan nakita din man darwa na mag-utod na Santiago daw Juan na mga kabataan Zebedeo. Naan danen ta sakayan na buti duma ta iran na amay na gapuna danen an ta iran na pukot. Paumaw Jesus mag-utod an ");
INSERT INTO cgc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","daw padilian dayon danen iran na amay naan ta buti daw gakuyog ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galibot Jesus i ta bilog na Galilea na gatudlo naan ta mga balay tipunan ta mga Judio daw gasugid kanen an ta miad na balita parti ta pagdumala ta Dyos. Paayad din mga ittaw an na may mga masakit daw may mga dipirinsya ta lawa. ");
INSERT INTO cgc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Galapta gid naan ta bilog na prubinsya ta Siria balita an parti ta mga nabuat Jesus. Padala ki kanen tama na mga ittaw bisan ino iran na masakit, mga ittaw na gabatyag ta segeng na sakit ta lawa, mga naseddepan ta malain na ispiritu, mga kuyapen daw mga paralitiko. Napaayad Jesus danen an tanan. ");
INSERT INTO cgc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tama ittaw na gakuyog ki Jesus na mga taga-Galilea, mga taga-Decapolis daw mga taga-Jerusalem. Duma an na gakuyog ki kanen alin pa ta duma na mga banwa na sakep ta prubinsya Judea daw alin ta liyo Suba Jordan. ");
INSERT INTO cgc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na nakita Jesus na tama ittaw giling naan ki kanen, gatukad kanen i naan ta isya na bukid daw naan dya kanen gapungko. Iya na mga tinudluan gaprani ki kanen ");
INSERT INTO cgc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","daw gatudlo kanen ki danen ta iling ti: ");
INSERT INTO cgc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“May angken na kalipay alin ta Dyos mga ittaw na nalam na danen an gakinanglan ta Dyos tak beet ambalen na sakep danen an ta iya na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","May angken na kalipay alin ta Dyos mga ittaw na gangasebe anduni tak danen an lipayen ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","May angken na kalipay alin ta Dyos mga ittaw na mapainebesen tak mabaton danen tanan na papangako ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","May angken na kalipay alin ta Dyos mga ittaw na liag magtuman ta kabebet-en ta Dyos na terek ta iran na tagipusuon tak tabangan din danen an aged matuman gid danen iya na kabebet-en. ");
INSERT INTO cgc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","May angken na kalipay alin ta Dyos mga ittaw na maluluy-on tak danen an kaluuyan ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","May angken na kalipay alin ta Dyos mga ittaw na iran na palabi pagsirbi daw pagtuman ta Dyos tak mabot adlaw na makita danen kanen an. ");
INSERT INTO cgc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","May angken na kalipay alin ta Dyos mga ittaw na gabuat ta paagi na maglineng pagdumaay ta mga ittaw tak Dyos an pasunod danen na paryo danen ta mga bata na gasunod ta ugali ta iran na amay. ");
INSERT INTO cgc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","May angken na kalipay alin ta Dyos mga ittaw na papangabot ta mga gakuntra ki danen tenged ta iran na pagsunod ta kabebet-en ta Dyos tak beet ambalen na sakep danen ta iya na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","May angken kaw na kalipay alin ta Dyos daw matabo na painsulto kaw, papangabot kaw ta mga gakuntra ki kyo daw ambalan ta maskin ino nang na malain na mga ambal na dili matuod tak kyo yan sakep ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Daw maagian nyo mga malain na iling tan, magkalipay kaw ta miad tak may bakod na bales naan ta langit na patagana ta Dyos para ki kyo. Demdemen nyo na inagian nyo an na bellay paryas nang ta inagian ta mga prupita ya na una ki kyo na danen an papangabot ta mga gakuntra ki danen. Bisan iling tan iran na inagian, kabaton danen ya ta bakod na bales alin ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Gambal pa Jesus i naan ta iya na mga tinudluan, “Kyo na mga tinudluan ko, paryo kaw ta asin na kinanglan para ta kayaran ta mga ittaw ta kalibutan i. Isipen nyo: Daw ula en lasa asin an, impusibli na magmasin pa isab. Ula en pulos. Papilak nang en daw nautaran ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kyo paryo man ta ilaw ta kalibutan tak gatabang kaw ta mga ittaw aged na makala danen Dyos an. Makita gid mga buat nyo an paryo ta syudad na naan apaw ta bungyod na iya na pawa impusibli na maliperan. ");
INSERT INTO cgc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Daw mga ittaw magtutod ta lampraan, dili danen takleban ta gantangan. Ibetang danen naan ta tungtungan ta ilaw aged selled ta balay mapawaan daw tanan na mga ittaw dya kakita. ");
INSERT INTO cgc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iling man tan, dili nyo ilikem inyo na pagsunod ta Dyos aged makita ta mga ittaw inyo na mga binuatan na miad daw dayawen danen Dyos an na ate na Amay naan ta langit.” ");
INSERT INTO cgc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili kaw mag-isip na ake na tuyo ta pag-iling di para magtudlo ta mga ittaw na dili danen kinanglan na tumanen Mga Sinulat Moises daw Mga Sinulat Ta Mga Prupita. Ake na tuyo ta pag-iling di para maintindian ta mga ittaw beet ambalen ta mga sinulat ya aged tumanen danen ta usto. ");
INSERT INTO cgc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iling gid tan ake na tuyo daw sugiran ta kyo na maski marwad kalangitan an daw kalibutan i, dili gid marwad bisan isya na tise na litra daw isya na kurit ta litra na naan ta Mga Sinulat Moises mintras ula pa natuman tanan na dapat matuman na mga ambal ta Dyos na naan ta mga sinulat ya. ");
INSERT INTO cgc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Daw kino na dili magtuman ta maskin pinakasimpli na sugo naan ta Mga Sinulat Moises daw magtudlo ta duma na dili kinanglan tumanen, kanen bilangen na may pinakababa na katengdanan ta tanan na sakep ta pagdumala ta Dyos. Piro, daw kino na magtuman ta mga sugo daw magtudlo ta duma na danen magtuman man, kanen bilangen na may datas na katengdanan naan ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gambal a ki kyo na daw inyo na pagsunod ta kabebet-en ta Dyos paryo nang ta pagsunod ta mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, impusibli na masakep kaw ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gambal pa gid Jesus i naan ta iya na mga tinudluan, “Namatian nyo en na gasugo Dyos an naan ta mga kaapuan na alinan nyo, ‘Dili ka magpatay,’ daw gasugo man na ‘daw kino makapatay sintinsyaan.’ ");
INSERT INTO cgc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piro, gambal a ki kyo na daw kino may kagilek ta iya na duma, sintinsyaan man. Bisan kino na gainsulto ta iya na duma na pambalan din, ‘Kabos ka gid,’ nakasala kanen daw dapat dleen naan ta ate na kadatasan na kunsiyo na Sanedrin para manabat. Bisan kino na pagayyaan din iya na duma na pambalan din, ‘Bungbuang ka,’ nakasala kanen daw dapat apoy na naan ta impirno iya na tupaan. ");
INSERT INTO cgc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Gani, daw magbetang ka en inta ta imo na dala na alad naan ta alaran daw naan dya nademdeman no na may duma na lain beet ki kaon, ");
INSERT INTO cgc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bilin no anay alad no an naan ta atubangan ta alaran daw ilingan no kanen an daw mangayo ka ta pasinsya. Daw magmiaray kaw en, malik ka daw dayunon no imo na pag-alad naan ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Daw may gakusar ki kaon, arigluon no dayon na ula kaw pa kabot naan ta uwis tak daw kyo naan en ta uwis, intriga ka naan ta gwardya daw prisuon. ");
INSERT INTO cgc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iling gid tan matabo ki kaon daw sugiran ta kaw na dili ka pagwaen asta na mabayaran no gid tanan na dapat bayaran.” ");
INSERT INTO cgc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Gambal pa Jesus i naan ta iya na mga tinudluan, “Namatian nyo en sugo ta Dyos na iling ti, ‘Dili ka mag-intra ta bai na sawa ta duma.’ ");
INSERT INTO cgc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piro, gambal a ki kyo na daw mama magtan-aw ta isya na bai daw gaisip ta malain, paryo na kanen an gaintra en. ");
INSERT INTO cgc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Daw tuo no na mata tenaan na nakasala ka, dapat lukaten no daw pilak. Mas miad pa na kulang isya na parti ta imo na lawa kaysa na kumplito daw pilak ka naan ta impirno. ");
INSERT INTO cgc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Daw tuo no na lima tenaan na nakasala ka, dapat uturon no daw pilak. Mas miad pa na kulang isya na parti ta imo na lawa kaysa na kumplito daw naan ka tupa ta impirno.” ");
INSERT INTO cgc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Gambal pa Jesus i naan ta iya na mga tinudluan, “Sugo man ta Dyos na daw mama gusto magbelag ta iya na sawa, kinanglan buatan din ta kasulatan ta pagbelag. ");
INSERT INTO cgc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piro, gambal a ki kyo na daw bisan kino na mama na belagan din iya an na sawa na ula man gaintra ta mama, kasala kanen an tak daw mangasawa isab pabelagan din an na sawa, paryas man gyapon na gaintra ta mama. Bisan kino na mama na mangasawa ta bai na nabelagan, kasala kanen an tak paryas man gyapon na gaintra kanen ta bai.” ");
INSERT INTO cgc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Gambal pa Jesus i naan ta iya na mga tinudluan, “Namatian nyo man en na ta una gasugo Dyos an naan ta mga kaapuan na alinan nyo, ‘Dili no bawien imo na sumpa naan ta Dyos. Tumanen no daw ino imo na sumpa ki kanen.’ ");
INSERT INTO cgc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Piro, gambal a ki kyo, daw magpangako kaw, dili kaw nang en magsumpa. Dili kaw magsumpa paagi ta pagsambit ta langit tak naan dya truno ta Dyos ta iya na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Dili kaw man magsumpa paagi ta pagsambit ta kalibutan tak kalibutan i sakep ta iya na pagdumala na paryo naan di gatungtong iya na batiis. Dili kaw man magsumpa paagi ta pagsambit ta Jerusalem tak Jerusalem syudad na iya ta Dyos na makagagaem na ari. ");
INSERT INTO cgc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dili kaw man magsumpa paagi ta pagsambit ta inyo na ulo tak dili nyo kaya na pamitemen daw paputien maskin isya naet ta inyo na buok. ");
INSERT INTO cgc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mas dayad daw miag kaw na mag-ee, ambalen nyo nang ‘Ee.’ Daw miag kaw na magdili, ambalen nyo nang ‘Dili.’ Maskin ino pa na duma na ambal na pasambit nyo, naan alin en ki Satanas.” ");
INSERT INTO cgc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Gambal pa Jesus i naan ta iya na mga tinudluan, “Namatian nyo en sugo ta Dyos na iling ti, ‘Daw kino magsamad ta mata ta duma, iya na mata samaren man. Daw kino magtangtang ta ngipen ta duma, iya na ngipen tangtangen man.’ ");
INSERT INTO cgc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piro, gambal a ki kyo na dili kaw magbales ta mga ittaw na gabuat ta malain ki kyo. Daw tampaen ka naan ta tuo no na mimi, itubang no man liyo no an na mimi. ");
INSERT INTO cgc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Daw idimanda ka na kamangen imo an na bayo, iatag no man imo na pang-isleb. ");
INSERT INTO cgc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Daw piliten ka ta isya na sundalo na pas-anen iya an na dala ta isya kilumitro, dleen no bisan pa asta ta darwa na kilumitro. ");
INSERT INTO cgc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tagan no daw kino mangayo ki kaon daw paelesen no man daw kino gaeles.” ");
INSERT INTO cgc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gambal pa Jesus i naan ta iya na mga tinudluan, “Namatian nyo en sugo ta Dyos na iling ti, ‘Gugmaen nyo inyo na mga arey daw demetan nyo mga gakuntra ki kyo.’ ");
INSERT INTO cgc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piro, gambal a ki kyo na gugmaen nyo mga ittaw na gakuntra ki kyo daw pangamuyuan nyo mga ittaw na gapangabot ki kyo ");
INSERT INTO cgc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tak daw iling tan buaten nyo, ate an na Amay naan ta langit pasunod nyo na paryo kaw ta bata na gasunod ta ugali ta iya na amay. Miad man gyapon Dyos an naan ta mga ittaw na malain daw ula gasunod ki kanen daw naan man ta mga ittaw na miad daw gasunod ki kanen tak danen tanan pasilakan din ta adlaw daw paatagan ta uran. ");
INSERT INTO cgc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Daw gugmaen nyo an mga ittaw nang na gagugma ki kyo, dili kaw magpaabot na mabaton nyo dayad na bales alin ta Dyos. Bisan mga manugsukot ta buis gagugma ta mga gagugma ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Daw mga patubay nyo an mga paryo nyo nang na Judio, ino inyo na buat na mas miad pa ta duma? Bisan mga ittaw na ula kakala ta Dyos gabuat man ta iling tan. ");
INSERT INTO cgc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gani, buaten nyo daw ino miad an naan ta mga ittaw aged paryas kaw ta ate na Amay naan ta langit na tanan na pabuat din miad.” ");
INSERT INTO cgc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Gambal pa gid Jesus i naan ta iya na mga tinudluan, “Ambligan nyo na daw magbuat kaw ta miad, dili para nang na makita ta mga ittaw aged dayawen kaw tak daw iling tan buaten nyo, ula kaw mabaton na bales alin ta ate na Amay naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Gani, daw mag-atag kaw ta limos, dili nyo umawen mga ittaw na marani na makita danen inyo an na pag-atag. Iling tan pabuat ta mga ittaw na iran na pag-atag pakita-kita nang. Na danen an naan ta mga balay tipunan daw mga dalan, liag danen na iran na pag-atag makita ta tama na mga ittaw aged dayawen danen an. Iling gid tan pabuat danen, piro sugiran ta kyo na ula duma na bales na mabot pa ki danen ta iran na pag-atag ta limos daw dili, pagdayaw nang ya ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Daw magtabang kaw ta mga gakinanglan, dili nyo isugid bisan pa ta seed nyo gid na arey ");
INSERT INTO cgc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","aged sikrito nang inyo an na pagtabang tak nakita ta Dyos na ate na Amay naan ta langit daw kanen magbales ta dayad ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gambal pa Jesus i naan ta iya na mga tinudluan, “Daw mangamuyo kaw, dili nyo sunuron buat an ta mga ittaw na iran na pagpangamuyo pakita-kita nang. Gusto danen na mangamuyo na gatindeg naan ta mga balay tipunan daw naan ta mga kanto ta karsada aged sigurado gid na mlaman ta mga ittaw na danen an dyusnon. Iling gid tan pabuat ta duma na ittaw, piro sugiran ta kyo na ula en duma na bales na mabot pa ki danen ta iran na pagpangamuyo daw dili, pagtan-aw nang ya ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gani, daw mangamuyo ka, melled ka naan ta imo na kwarto na kaon nang daw saraan ngaan an. Naan dya, mangamuyo ka ta Dyos na ate na Amay na dili makita. Piro, kanen kakita ta mga buat na ula nakita ta mga ittaw daw balesan ka din ta dayad. ");
INSERT INTO cgc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Daw mangamuyo kaw, dili lawig na balik-balik na mga ambal. Iling tan buat ta mga ittaw na ula kakala ta Dyos tak salig danen daw lawig iran na pangamuyo, mamatian danen an ta iran na dyos. ");
INSERT INTO cgc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dili kaw magparyo ki danen tak bag-o kaw mangamuyo, nlaman en ta ate na Amay naan ta langit inyo an na mga kinanglan. ");
INSERT INTO cgc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gani, daw mangamuyo kaw, iling ti: ‘Amay nay na naan ta langit, kabay na kalaen ka ta tanan na mga ittaw na kaon nang Dyos daw tumanen ka danen. ");
INSERT INTO cgc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kabay na mabot en timpo na magdumala ka ta tanan na mga ittaw. Kabay na mga ittaw ta kalibutan i magtuman ta imo na kabebet-en na paryas naan ta langit patuman imo na kabebet-en. ");
INSERT INTO cgc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tagan no kami i ta ame na kinanglan na pagkaan ta anduni na adlaw. ");
INSERT INTO cgc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawaren no kami i ta ame na mga sala paryas na napatawad nay man mga kasala an ki kami. ");
INSERT INTO cgc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tabangan kay no na dili kay madala ta mga tintar. Luwasen kay no ki Satanas. Yi ame na pangamuyo tak kaon Ari Na Makagagaem daw dayawen ka ta ula katapusan. Amen.’” ");
INSERT INTO cgc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ambal pa Jesus, “Daw patawaren nyo mga ittaw na kasala ki kyo, patawaren kaw man ta ate na Amay na naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piro, daw dili nyo patawaren danen an, dili kaw man patawaren ta ate na Amay na naan ta langit.” ");
INSERT INTO cgc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Gambal pa Jesus i naan ta iya na mga tinudluan, “Daw magpwasa kaw, dili nyo buaten paryo ta mga ittaw na iran na pagpwasa pakita-kita nang. Daw danen magpwasa, pabuat danen ta iran na kaugalingen daw lagen no napung-awan daw pabay-an nang iran na kaugalingen aged magbilib mga ittaw na danen an gapwasa. Iling gid tan pabuat ta duma na ittaw, piro sugiran ta kyo na ula duma na bales na mabot pa ki danen ta iran na pagpwasa daw dili, pagbilib nang ya ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Piro, daw kyo magpwasa, manglam-os kaw daw manudlay ");
INSERT INTO cgc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","aged ula may nalam na gapwasa kaw. Ate na Amay na dili makita na naan ta langit, dapat kanen nang nalam daw magpwasa kaw. Kanen kakita ta mga buat na ula nlami ta mga ittaw daw balesan kaw din ta dayad.” ");
INSERT INTO cgc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili kaw magtipon ta manggad unti ta kalibutan i para nang ta inyo na kaugalingen tak maketket nang ta mga sapat, matektekan daw selleren ta duma na ittaw inyo an na balay aged takawan. ");
INSERT INTO cgc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Piro, para malipay Dyos an ki kyo, gamiten nyo inyo an na manggad ta pagbuat ta miad. Daw iling tan buaten nyo, paryo na gatipon kaw ta manggad naan ta langit na naan dya inyo na manggad dili maketket, dili matektekan daw dili man matakaw. ");
INSERT INTO cgc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dapat iling tan buaten nyo tak daw indi kaw gatipon ta manggad nyo, naan man dya nakem nyo an.” ");
INSERT INTO cgc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Gambal pa Jesus i naan ta iya na mga tinudluan, “Mata an paanggid ta lampraan na gaatag ta pawa naan ta imo na kaugalingen. Daw miad mata no an, imo na kaugalingen ubos pawa. ");
INSERT INTO cgc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piro, daw lebbeg mata no an, imo na kaugalingen ubos delem. Daw pawa an na salig nyo na naan ki kyo delem pla, beet ambalen sikad gid delem naan ki kyo!” ");
INSERT INTO cgc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Gambal pa Jesus i naan ta iya na mga tinudluan, “Impusibli na isya na suguon, dengngan din na sirbian darwa na amo tak isya an palanggaen din daw tumanen na terek ta iya na tagipusuon, piro isya ya pakalainen din daw dili man tauron. Iling man tan, daw labien nyo pagpatama an ta inyo na manggad, impusibli na sirbian nyo Dyos an. ");
INSERT INTO cgc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Gani, gambal a ki kyo na dili kaw sali ta palibeg parti ta inyo na kabui daw parti man daw indi kaw kamang ta inyo na pagkaan daw inemen. Dili kaw man sali ta palibeg ta bayo na suuton nyo. Di' ba pagkaan an, dili nang yon impurtanti para ta ate na kabui? Di' ba bayo an, dili nang yon impurtanti para ta ate na lawa? ");
INSERT INTO cgc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lagen nyo mga yupan an! Ula danen an gasabwag, ula man gaani daw ula man gatipon ta bisan ino nang naan ta budiga para ta iran na kan-enen. Piro, bui man gyapon danen an tak ate na Amay na naan ta langit gapakaan ki danen. Di' ba kyo mas impurtanti kaysa ta mga yupan? ");
INSERT INTO cgc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Di' ba bisan magpalibeg kaw pa, dili nyo man gyapon madugangan ta bisan isya nang na uras inyo an na kabui? ");
INSERT INTO cgc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Man-o tak gapalibeg kaw gid daw indi kaw magkamang ta inyo na bayo? Lagen nyo mga bulak an naan ta blasan daw paino magtubo. Ula gapangabellay ta pag-ubra mga bulak an daw ula man gabuat ta bayo. ");
INSERT INTO cgc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sugiran ta kyo na Ari Solomon ya na sikad manggaranen daw iya na mga bayo sikad dayad, ula kanen bayo na mas dayad pa kaysa ta isya na bulak. ");
INSERT INTO cgc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Papabulak ta Dyos mga lamunon an na bui naan ta blasan piro ta dili nang lugay rabasen nang daw imuon na pandabok naan ta pugon! Daw iling tan pabuat ta Dyos naan ta lamunon, simpri mas pa na kyo tagan ta Dyos ta bayo na suuton! Man-o tak kulang inyo an na pagsalig ta Dyos parti ta inyo na mga kinanglanen? ");
INSERT INTO cgc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Dili kaw sali ta palibeg na mambal kaw, ‘Ino kan-enen ta? Ino inemen ta? Ino bayuon ta?’ ");
INSERT INTO cgc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mga ittaw na ula gatuo ta Dyos, danen an pirmi gapalibeg parti ta tanan na mga kinanglanen danen. Piro, Dyos na ate na Amay na naan ta langit, nlaman din daw ino inyo an na mga kinanglanen. ");
INSERT INTO cgc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dili kaw magparyo ta mga ittaw na ula gatuo. Una ta tanan, labien nyo inyo an na pagpasakep ta pagdumala ta Dyos daw inyo na pagtuman ta iya na kabebet-en. Daw iling tan buaten nyo, sigurado tagan kaw din ta inyo na mga kinanglanen. ");
INSERT INTO cgc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gani, dili kaw sali ta palibeg parti ta mabot pa na mga adlaw. Magsalig kaw nang naan ta Dyos. Usto en pagpalibeg nyo an parti ta anduni na adlaw. Dapat mga prublima an na naan ta mabot pa na mga adlaw dili nyo idugang naan ta mga prublima ta anduni na adlaw.” ");
INSERT INTO cgc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili kaw mag-usgar ta duma aged dili kaw man usgaran ta Dyos ");
INSERT INTO cgc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","tak daw mag-usgar kaw ta duma, Dyos an mag-usgar ki kyo. Basian an na pagamit nyo ta pag-usgar naan ta duma, yon man gamiten ta Dyos ki kyo. ");
INSERT INTO cgc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Man-o tak sali ka gid ta bantay ta sala ta duma, piro sala no an na bakod pabay-an no nang? Daw iling tan buat no, paryo na nakita no puling na tise nang naan ta mata ta duma, piro pabay-an no nang man na naan ta imo na mata may paryo bakod na tablon. ");
INSERT INTO cgc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Maskin paryo may tablon na naan ta imo na mata, gambal ka ta duma no, ‘Miad taan na kamangen ko imo an na puling’. ");
INSERT INTO cgc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Salig no daw kino ka na ula sala! Dilian no imo na sala bag-o ka magsaway ta duma parti ta iya na sala. Daw iling tan buaten no, paryo pakamang no tablon an na naan ta imo na mata aged kakita ka ta usto para makamang no tise an na puling na naan ta mata ta duma.” ");
INSERT INTO cgc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Gatudlo man Jesus na dapat dili magpadayon ta pagtudlo ta pulong ta Dyos naan ta mga ittaw na dili miag mamati. Ambal din, “Dili nyo iatag maalen na mga betang naan ta mga ayam tak kyo pa balikan danen daw kagaten. Dili nyo man ibetang mga pirlas naan ta atubangan ta mga baboy tak utad-utaran nang danen.” ");
INSERT INTO cgc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili kaw mag-untat na mangayo naan ta Dyos tak sigurado na tagan kaw din. Dili kaw mag-untat na marani naan ta Dyos tak sigurado tabangan kaw din. Dili kaw mag-untat na mangamuyo naan ta Dyos tak sigurado sabaten kaw din ");
INSERT INTO cgc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","tenged bisan kino na mangayo, matagan. Bisan kino na marani, tabangan. Bisan kino na mangamuyo, sabaten. ");
INSERT INTO cgc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Di' ba kyo na mga ginikanan, ula kaw gaatag ta bato naan ta inyo na bata na gangayo ta tinapay? ");
INSERT INTO cgc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ula kaw man gaatag ta bekkessan naan ta inyo na bata na gangayo ta sidda. ");
INSERT INTO cgc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tenged kyo na mga gabuat ta malain nalam man mag-atag ta dayad na mga betang naan ta inyo na mga bata, sigurado na ate an na Amay na naan ta langit mas pa gid mag-atag ta dayad na betang naan ta mga gangayo ki kanen! ");
INSERT INTO cgc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Trataren nyo duma na mga ittaw paryo man daw ino liag nyo na pagtratar danen ki kyo tak iling tan beet ambalen ta patudlo naan ta Mga Sinulat Moises daw Mga Sinulat Ta Mga Prupita.” ");
INSERT INTO cgc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Gambal Jesus i ta isya na paanggid naan ta iya na mga tinudluan, “Magselled kaw naan ta kitid na selleran tak wayang na selleran daw lapad na dalan, yon agian na diritso ta silot na ula katapusan daw tama na mga ittaw gaselled dya. ");
INSERT INTO cgc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piro, kitid na selleran daw kuli agian na dalan, yon agian aged maangken kabui na ula katapusan daw pila nang na ittaw gaselled dya.” ");
INSERT INTO cgc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gambal pa Jesus i naan ta iya na mga tinudluan, “Mag-amblig kaw aged dili nyo sunuron mga dili-matuod na prupita tak gapakuno-kuno nang danen an na danen mga padala ta Dyos. Dili man igo iran na patudlo parti ta kabebet-en ta Dyos. Danen paryo ta pintas na mga ayep na gapakuno-kuno na mga beet na karniro. ");
INSERT INTO cgc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makala nyo mga dili-matuod na prupita paagi ta iran na mga binuatan paryo na makala nyo mga kaoy paagi ta iran na bunga. Daw liag ta ittaw na mamang ta bunga ta ubas, simpri dili kanen an mag-ipo naan ta telleken na tanem. Daw liag ta ittaw na mamang ta bunga ta igos, simpri dili kanen an mag-ipo naan ta sampinit. ");
INSERT INTO cgc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kaoy na miad gamunga ta dayad daw kaoy na lain gamunga ta lain. ");
INSERT INTO cgc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Impusibli na kaoy na miad mamunga ta lain daw kaoy na lain mamunga ta dayad. ");
INSERT INTO cgc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kada kaoy na dili dayad iya an na bunga, pukanen daw pilak naan ta apoy. ");
INSERT INTO cgc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sigurado gid na makala nyo mga dili-matuod na prupita paagi ta iran na mga binuatan.” ");
INSERT INTO cgc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili tanan na gaumaw ki yaken, ‘Ginuo ko,’ masakep ta pagdumala ta Dyos. Mga ittaw na gasunod ta kabebet-en ta ake na Amay na naan ta langit, danen an sakep ta iya na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Daw mabot adlaw na mag-ukom Dyos ta tanan na mga ittaw daw kino matareng daw dili matareng, tama gid mag-ambal ki yaken, ‘Ginuo, nlaman no na ta imo na ngaran pasugid nay ta mga ittaw imo an na pulong. Ta imo na ngaran gapagwa kay ta mga malain na ispiritu daw gabuat kay man ta tama na katingalaan.’ ");
INSERT INTO cgc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yi ake na sabat ki danen, ‘Dili ta kyo kala. Malin kaw di, kyo na mga gabuat ta malain.’” ");
INSERT INTO cgc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Gambal pa Jesus i naan ta iya na mga tinudluan, “Tanan na gamati daw gasunod ta ambal ko, danen an paryo ta ittaw na maalam na gatukod ta balay na mga ligi an natindeg naan ta unay na bato. ");
INSERT INTO cgc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gabot timpo na gauran ta tudo, gabaa daw gaunos na palamba gid balay ya, piro ula natumba tak napatindeg naan ta unay na bato. ");
INSERT INTO cgc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Piro, tanan na gamati ta ambal ko daw ula gasunod, danen an paryo ta ittaw na ula isip na gapatindeg ta balay naan ta pantad. ");
INSERT INTO cgc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gabot timpo na gauran ta tudo, gabaa daw gaunos na palamba gid balay ya daw natumba balay na nagubba gid.” ");
INSERT INTO cgc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagtapos Jesus ta pag-ambal, gatingala gid tanan an na ittaw ta iya na panudluon ");
INSERT INTO cgc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tak kanen an gatudlo alin ta iya gid na alam. Dili kanen an paryo ta mga manugtudlo ta Mga Sinulat Moises tak patudlo danen naan nang alin ta alam ta duma na ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagtapos ta pagtudlo Jesus ta mga ittaw naan ta bukid, gategbeng kanen i daw sikad tama na mga ittaw gakuyog. ");
INSERT INTO cgc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Isya na mama na may segeng na masakit ta langgit gaprani ki Jesus daw galuod na gambal, “Ginuo, daw gusto no, mapaayad a no ta ake na masakit.” ");
INSERT INTO cgc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Paibitan Jesus mama an daw ambal din, “Gusto ko! Mayad ka!” Pag-ambal Jesus, nayad dayon mama an ta iya na masakit ta langgit. ");
INSERT INTO cgc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Paambalan Jesus kanen an, “Dili ka mugid naan ta bisan kino parti ta ake na pagpaayad ki kaon. Magdiritso ka nang naan ta pari daw magpatan-aw na nayad ka en. Magdala ka man ta alad na igo ta sugo ta Dyos naan ta Mga Sinulat Moises aged may pamatuod ka naan ta mga ittaw na nayad ka en.” ");
INSERT INTO cgc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na giling Jesus i naan ta banwa na Capernaum, isya na dili-Judio na upisyal ta sundalo gaprani ki kanen daw gapakiluoy, ");
INSERT INTO cgc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ginuo, ake na suguon ganegga naan ta ame na balay tak naparalays daw segeng na sakit nabatyagan din an.” ");
INSERT INTO cgc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ambal Jesus ki kanen, “Miling a dya daw paayaren ko kanen an.” ");
INSERT INTO cgc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Piro, sabat ta upisyal, “Ginuo, dili a bagay na magbaton ki kaon naan ta ame na balay tak datas imo na katengdanan. Mambal ka nang, sigurado na mayad en ake na suguon. ");
INSERT INTO cgc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tenged ta ake na inagian bilang upisyal ta sundalo, nlaman ko gid na matuman dayon imo an na ambal. Pamanduan a ta mga upisyal na mas datas iran na katengdanan kaysa ta ake na katengdanan daw may pamanduan a man. Daw mag-ambal a ta isya, ‘Miling ka unso,’ gapanaw dayon. Daw mag-ambal a ta duma, ‘Manaw ka ri,’ gaprani dayon. Daw mag-ambal a ta suguon ko, ‘Ubraen no ni,’ paubra din dayon.” ");
INSERT INTO cgc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagmati Jesus ta ambal ta upisyal, gabilib kanen i daw gambal naan ta mga ittaw na gakuyog ki kanen parti ta upisyal an, “Bakod gid iya na pagsalig ki yaken daw sugiran ta kyo na ula a pa kakita ta ittaw naan ta tanan na linai Israel na may bakod na pagsalig paryo ta iya na pagsalig. ");
INSERT INTO cgc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gambal a ki kyo na tama na dili linai Israel alin ta bisan indi na mga lugar ta kalibutan mandegek duma ta kaapuan na ate na alinan na danen Abraham, Isaac daw Jacob naan ta kumbira na naan ta kaarian ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piro, tama na mga linai Israel na imbis na mandegek danen an naan ta kaarian ta Dyos, dleen danen an naan ta sikad delem na lugar padyo ta kaarian. Naan dya danen an mangagal ta tudo daw magbaggit ta iran na ngipen.” ");
INSERT INTO cgc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pagtapos ta pag-ambal Jesus naan ta mga ittaw na gakuyog ki kanen, gambal man kanen naan ta upisyal an, “Muli ka en. Matuman imo na pangabay tenged ta imo na pagsalig ki yaken.” Ta yon man na uras, nayad suguon ya ta upisyal. ");
INSERT INTO cgc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Giling Jesus i naan ta balay danen Pedro. Nakita din dya ugwangan ya Pedro na bai na ganegga tak nadangga. ");
INSERT INTO cgc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Patandeg Jesus kanen an naan ta lima daw gapuas iya na dangga. Gabangon dayon kanen daw mimes ta pagkaan para ki danen Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na salep en adlaw, padala ki Jesus tama na mga ittaw na naseddepan ta malain na mga ispiritu. Papagwa din mga malain ya na ispiritu paagi nang ta iya na ambal. Paayad din man tanan na mga ittaw na may masakit na padala ki kanen bisan ino iran an na masakit. ");
INSERT INTO cgc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ta pagpaayad din ta mga ittaw daw pagpagwa ta mga malain na ispiritu, natuman ambal ya Isaias na prupita anay pa sa. Ambal Isaias, “Pakamang din lain na mga pamatyag ta ate na lawa daw paayad din ate na mga masakit.” ");
INSERT INTO cgc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na nakita Jesus na gatipon isab ki kanen sikad tama na mga ittaw, pasugo din iya an na mga tinudluan na makted danen an duma ki kanen naan ta liyo na baybay ta Dagat Galilea. ");
INSERT INTO cgc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na gaimes en danen an na makay, may isya na manugtudlo ta Mga Sinulat Moises na gaprani ki Jesus daw mambal, “Mistro, muyog a gid ki kaon bisan indi ka pa punta tak liag ko na isya a man ta imo na mga tinudluan!” ");
INSERT INTO cgc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ambal Jesus, “Miad pa isipen no anay mga ayep an naan ta kakauyan. Danen an may istaran na lungag daw mga yupan man a may salag na ulian, piro Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, bisan indi nang gatinir tak ula ulian na balay na iya gid.” ");
INSERT INTO cgc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","May isya eman ta mga tinudluan Jesus na gambal ki kanen, “Ginuo, bag-o a nang en muyog. Muli a pa aged daw mapatay amay ko ya naan a dya para maasikaso ko paglebbeng ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sabat Jesus, “Duma nang en na mga ittaw na ula paumawa na muyog ki yaken pwidi na danen mag-asikaso ta paglebbeng ta imo ya na amay. Kaon yan a, muyog ka ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Gasakay Jesus i ta isya na buti daw gakuyog man iya an na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na galakted danen an, nali nang gasampi pelles na angin daw gadarko gid baled an. Buti ya tise nang nasanapan ta taklap ta mga baled. Piro, Jesus i gatunuga. ");
INSERT INTO cgc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iya an na mga tinudluan gaprani ki kanen daw papukaw danen kanen i na ambal danen, “Ginuo, tabangan kay no! Maleddang ki en!” ");
INSERT INTO cgc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus i gambal ki danen, “Kulang inyo na pagsalig ki yaken. Man-o tak nadlek kaw?” Pagtapos Jesus ambal, gabangon kanen daw pamanduan din pelles na angin daw baled na muntat. Dayon sikad kalmada. ");
INSERT INTO cgc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Gatingala gid iya an na mga tinudluan daw gambal, “Ino taan klasi na ittaw ni? Bisan angin an daw baled gatuman ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pag-abot Jesus daw iya na mga tinudluan naan ta liyo na kilid ta dagat naan ta lugar ta mga Gadareno, may gasugat ki Jesus na darwa na mama na naan galin ta patyo. Danen i naseddepan ta malain na mga ispiritu. Sikad danen an manakit ta mga ittaw asta ula may gaagi naan ta dani ta patyo. ");
INSERT INTO cgc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagkita danen ki Jesus, nali nang danen an gasinggit, “Kaon na Bata Ta Dyos, man-o tak anen ka di? Giling ka di aged silutan kay no, bisan dili pa igo na uras?” ");
INSERT INTO cgc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Naan ta dili gid madyo ki danen Jesus, may paneng ta baboy na ganuklad. ");
INSERT INTO cgc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gapakiluoy mga malain ya na ispiritu ki Jesus, “Daw kami i pagwaen no, pailingen kay no naan ta mga baboy na ya.” ");
INSERT INTO cgc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus i gambal ki danen, “Mwa kaw!” Pag-ambal Jesus, gagwa danen ya naan ta darwa na mama daw gaseddep naan ta mga baboy. Tanan ya na baboy gadlagan paebes ta bangilid daw nulog naan ta dagat daw nalemmes tanan. ");
INSERT INTO cgc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mga manugbantay ta mga baboy gadlagan ta subla na adlek daw giling naan ta banwa na dani dya. Gapalapta danen an ta balita parti ta tanan na natabo ta mga baboy daw ta darwa na mama na naseddepan ta mga malain na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tama na mga ittaw gagwa ta banwa na munta ki Jesus na paryo na naan dya bilog na banwa. Pagkita danen ki Jesus, gapakiluoy danen an na daw pwidi, malin kanen an ta iran na lugar. ");
INSERT INTO cgc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Gasakay isab Jesus i daw iya na mga tinudluan naan ta buti daw gabalik ta banwa na naan en dya kanen gaistar. ");
INSERT INTO cgc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na naan Jesus dya, may mga ittaw na giling ki kanen. Patuwangan danen mama na naan ta neggaan tak dili kapanaw. Na nakita Jesus na danen an gasalig gid ki kanen na mapaayad din mama an na dili kapanaw, gambal kanen i ta mama an, “Tong, malipay ka. Napatawad en imo an na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naan man dya pila na mga manugtudlo ta Mga Sinulat Moises. Na namatian danen ambal Jesus naan ta mama na dili kapanaw, ambal danen ta iran na kaugalingen, “Iya na ambal insulto ta uturidad ta Dyos ta pagpatawad ta sala!” ");
INSERT INTO cgc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Piro, nlaman Jesus daw ino iran an na isip daw paambalan din danen an, “Man-o tak gaisip kaw ta malain? ");
INSERT INTO cgc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Indi ta darwa na i mas dali nang buaten? Ambalen ko na napatawad en iya na mga sala, o ambalen ko na kanen an mangon daw manaw? Simpri darwa i paryas nang na dali buaten tak iling an tan mabuat paagi nang ta gaem daw uturidad ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pamatuuran ko ki kyo na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan may uturidad naan ta kalibutan i na magpatawad ta mga sala.” Dayon, gambal Jesus i ta mama na dili kapanaw, “Mangon ka! Dleen no neggaan no an daw muli.” ");
INSERT INTO cgc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pag-ambal Jesus, gabangon mama an daw guli. ");
INSERT INTO cgc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na nakita ta mga ittaw na nayad en mama ya, sikad gid tingala danen daw gadayaw danen ta Dyos na gaatag ta iling tan na uturidad naan ta ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pagtapos Jesus ta pagpaayad ta mama ya na dili kapanaw, galin kanen i. Ta iya na pagpanaw, nakita din isya na manugsukot ta buis na ngaran din Mateo na gamungko naan ta bayaran ta buis. Gambal Jesus i ki Mateo, “Muyog ka ki yaken aged kaon isya man ta ake na mga tinudluan.” Pag-ambal Jesus, gatindeg dayon Mateo i daw muyog. ");
INSERT INTO cgc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na Jesus i gakaan naan ta balay danen Mateo, tama na mga manugsukot ta buis daw makasasala na mga ittaw na gabot dya. Gakaan danen an na duma ki kanen daw iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na nakita ta mga Pariseo dya na Jesus i gakaan duma ta makasasala na mga ittaw, painsaan danen iya an na mga tinudluan, “Man-o tak inyo na mistro gakaan duma ta mga manugsukot ta buis daw makasasala na mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na namatian Jesus insa ya danen, sabat din, “Mga ittaw na miad iran na lawa ula gakinanglan ta duktor. Piro, mga ittaw an a na may masakit, danen gakinanglan ta duktor. ");
INSERT INTO cgc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Intindien nyo gid ta miad ambal an ta Dyos naan ta sinulat na pulong din, ‘Mas gusto ko na may kaluoy kaw ta kada isya kaysa may paalad kaw ki yaken.’ Nyan na ula a giling di para manggat ta mga ittaw na salig danen na matareng danen an. Giling a di para manggat ta mga ittaw na makasasala aged magsunod danen an ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gaprani ki Jesus pila na mga tinudluan Juan na manugbautismo. Gambal danen, “Pirmi kay ame gapwasa daw yon man mga Pariseo an, piro man-o tak imo na mga tinudluan ula gapwasa?” ");
INSERT INTO cgc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sabat Jesus, “Daw may kumbira ta kasal, impusibli na mga paimbitar an mangasebe mintras mama na bag-o kasal anen pa don duma ki danen! Piro, mabot adlaw na mama an na bag-o nang kasal kamangen naan ki danen. Yon en uras na danen an magpwasa.” ");
INSERT INTO cgc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Gambal pa Jesus i ki danen, “Ula bisan kino na gatupak ta bag-o na tila na ula pa nabunaki naan ta daan na bayo tak mag-itad tinai ya naan ta bayo daw magbakod pa gid gisi an ta bayo tenged gakeddet tupak ya. ");
INSERT INTO cgc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iling man tan, ula bisan kino na gaugsak ta bag-o na bino na dili pa iseg na gabula pa naan ta daan na ugsakan na langgit na ula en gainat. Daw iling tan buaten din, mabustik ugsakan tenged ta pagbula ta bino. Muyak bino ya daw masamad man ugsakan an. Dapat bag-o buat na bino iugsak naan ta bag-o buat na ugsakan na langgit na gainat pa aged paryo danen an na dili maino.” ");
INSERT INTO cgc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na gambal pa Jesus i naan ta mga tinudluan Juan na manugbautismo, may isya na gadumala ta balay tipunan na gabot daw galuod naan ta tubangan Jesus. Gapakiluoy kanen an ki Jesus, “Bag-o nang napatay ake na bata na bai. Miling ki naan ta ame na balay. Daw maimo nang, itungtong no imo na lima naan ki kanen para mabui.” ");
INSERT INTO cgc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Gatindeg Jesus i daw muyog ki kanen. Gakuyog man mga tinudluan Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na gapanaw pa danen Jesus, may isya na bai na gaprani ki kanen naan dapit ta iya na tudtod. Bai ya, iya na rigla ula gapeet ta usto seled ta dusi anyos. Pagprani din ki Jesus, patandeg din bungay-bungay ta sidsid ta bayo na pangkablay Jesus ");
INSERT INTO cgc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tak naan ta iya na isip, “Daw matandeg ko nang iya na bayo, mayad a gid.” ");
INSERT INTO cgc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pagtandeg ta bai ta bayo Jesus, galiso Jesus i daw nakita din bai ya daw ambal din, “Kay, malipay ka! Tenged ta imo na pagsalig, nayad ka.” Pag-ambal Jesus, nayad dayon bai ya. ");
INSERT INTO cgc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pag-abot danen Jesus naan ta balay ta mama na gadumala ta balay tipunan, nakita Jesus mga manugtukar ta plawta para ta pug-aw daw tama na mga ittaw na gasinaba. ");
INSERT INTO cgc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gambal kanen an ta mga ittaw, “Mwa kaw anay. Bata an dili patay. Gatunuga nang kanen an.” Piro, patatawaan nang ta mga ittaw Jesus i. ");
INSERT INTO cgc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na napagwa en mga ittaw ya, dayon man selled Jesus i naan ta kwarto na naan dya patay an na bata. Pabitan din lima ta bata daw dayon gabangon bata an. ");
INSERT INTO cgc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Balita parti ta pagpaayad din ta bata ya galapta ta tanan na banwa na dani ta Capernaum. ");
INSERT INTO cgc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pag-alin Jesus ta lugar na naan dya paayad din bata ya, may gasunod ki kanen na darwa na mama na bulag. Gasinggit danen an ki kanen, “Apo Ari David! Maluoy ka ki kami!” ");
INSERT INTO cgc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na gaselled Jesus naan ta balay na dayunan din, darwa ya na bulag gaprani ki kanen. Gainsa kanen ki danen, “Gapati kaw na mapaayad ta kyo?” Sabat danen, “Ee, Ginuo.” ");
INSERT INTO cgc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pagsabat danen, patandeg din iran na mata daw mambal, “Pabuat ko ni para ki kyo tenged ta inyo na pagsalig ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dayon, kakita en danen an. Paambalan din danen an na dili mugid ta bisan kino parti ta pagpaayad din ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piro, ta iran na pagpanaw, pasugid danen ta mga ittaw naan ta tanan na banwa na dani ta Capernaum parti ta pagpaayad din ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pag-alin ta darwa na bulag naan ki Jesus, may padala naan ki kanen na isya na mama na apa tak naseddepan ta malain na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Papagwa Jesus malain ya na ispiritu daw apa an kambal en. Gatingala gid mga ittaw an daw gambal, “Ula kay pa kakita na paryo tan naan ta bilog na nasyon Israel.” ");
INSERT INTO cgc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piro, mga Pariseo an gambal, “Napagwa din mga malain na ispiritu paagi ta gaem na alin ta pangulo ta mga malain na ispiritu.” ");
INSERT INTO cgc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Galibot Jesus i ta tanan na mga syudad daw banwa naan ta Galilea daw gatudlo naan ta mga balay tipunan ta mga Judio. Pasugid din miad na balita parti ta pagdumala ta Dyos daw paayad din man mga ittaw maskin ino iran na masakit daw dipirinsya ta lawa. ");
INSERT INTO cgc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na nakita Jesus tama na mga ittaw na giling ki kanen, naluoy kanen an tak tama na bellay iran na naagian daw ula danen an dangepan. Danen an paryo ta mga karniro na ula manugbantay. ");
INSERT INTO cgc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gaisturya kanen ta isya na paanggid naan ta iya na mga tinudluan, “Paryo may sikad lapad na anien, piro pila nang na mga ittaw gaani. ");
INSERT INTO cgc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Gani, naan kaw mangabay ta ittaw na gapaani na magpadala kanen an ta dugang pa na mga mag-ani.” ");
INSERT INTO cgc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Paumaw Jesus dusi din na apustulis na magtipon naan ki kanen daw patagan din danen an ta uturidad aged magpagwa ta mga malain na ispiritu na naan ta mga ittaw daw magpaayad man ta mga may masakit maskin ino iran na masakit daw lain na batyag. ");
INSERT INTO cgc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yi ngaran ta dusi na apustulis: una Simon na paumaw man na Pedro daw iya na utod na Andres, sunod mag-utod na Santiago daw Juan na mga kabataan Zebedeo, ");
INSERT INTO cgc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolome, Tomas, Mateo na manugsukot ta buis, Santiago na bata Alfeo, Tadeo, ");
INSERT INTO cgc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon na Makabanwa, daw Judas Iscariote na ta uryan magtraydor ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pasugo Jesus dusi din na apustulis daw paambalan, “Dili kaw miling naan ta mga lugar ta mga dili-Judio daw naan ta mga banwa ta mga Samaritano. ");
INSERT INTO cgc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Miling kaw ta mga paryo nyo na ittaw na linai Israel tak paryo danen an narwad na mga karniro. ");
INSERT INTO cgc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Maski indi kaw munta, iwali nyo iling ti, ‘Anduni abot en upurtunidad na makapasakep kaw ta papaabot na pagdumala ta Dyos.’ ");
INSERT INTO cgc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Magpaayad kaw ta mga may masakit daw magbui kaw ta mga napatay. Magpaayad kaw man ta mga may segeng na masakit ta langgit daw magpagwa kaw ta mga malain na ispiritu naan ta mga ittaw. Tenged libri nang nabaton nyo na uturidad alin ki yaken aged matuman nyo ubra na paambal ko ki kyo, dapat libri nang man inyo na tabang ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dili kaw magdala ta kwarta na bisan blawan, pilak, daw tambaga naan ta inyo na puyo-puyo. ");
INSERT INTO cgc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ta inyo na pagpanaw, dili kaw magdala ta binagteng, mga mlaan, pangsili na sandal, daw tungkod tak mga manug-ubra an dapat gid na tagan ta iran na kinanglanen para mabui. ");
INSERT INTO cgc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Bisan indi kaw munta na banwa daw baryo, mangita kaw ta dayunan nyo naan ta miad na ittaw daw magtinir kaw dya keteb na malin kaw ta iran na lugar. ");
INSERT INTO cgc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagselled nyo ta balay, mag-atag kaw ta bindisyon ta mga ittaw dya. ");
INSERT INTO cgc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Daw dayad iran na pagbaton ki kyo, matuman gid bindisyon nyo na mabaton danen katawwayan na alin ta Dyos. Piro, daw dili dayad iran na pagbaton, bawien nyo inyo an na bindisyon. ");
INSERT INTO cgc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Daw dili kaw batunon ta mga ittaw naan ta isya na banwa daw dili man danen matian inyo na mga ambal, malin kaw dya. Ta inyo na pag-alin ta iran na panimalay daw banwa, ipakita nyo na papadpad nyo yab-ok an ta inyo na mga batiis na alin ta iran na banwa. ");
INSERT INTO cgc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dapat gid iling tan buaten nyo aged mapaandaman nyo danen an. Sugiran ta kyo na daw mabot adlaw na mag-ukom Dyos ta mga ittaw daw kino matareng daw dili matareng, mas gaan pa silot na maageman ta sikad malain na mga ittaw na gaistar naan ta Sodoma daw Gomora anay pa sa kaysa ta silot ta mga ittaw na dili magbaton ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Gambal pa Jesus i ta dusi din na apustulis, “Tandaan nyo! Daw naan kaw en ta mga ittaw na ilingan nyo, kyo yan paryo ta daram na mga karniro naan ta tengnga ta pintas na mga ayep. Mag-andam kaw paryo ta bekkessan na pirmi alisto. Paryo ta salampati na daram, dili kaw mag-isip na magbuat ta malain. ");
INSERT INTO cgc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mag-andam kaw tak may mga ittaw na magdakep ki kyo na intriga kaw naan ta mga gadumala ta iran na mga banwa aged usisaen. Kastiguon kaw danen naan ta iran na balay tipunan. ");
INSERT INTO cgc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tenged ta inyo na pagsunod ki yaken, patubangen kaw danen naan ta mga gubirnador daw mga ari. Daw naan dya, magpamatuod kaw naan ki danen daw ta mga dili-Judio man parti ta inyo na pagpati ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ta timpo na madakep kaw, dili kaw magpalibeg daw ino isabat nyo daw ambalen. Ta uras na usisaen kaw, tabangan kaw ta Dyos daw ino inyo na ambalen ");
INSERT INTO cgc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","tak inyo na ambalen dili alin ki kyo. Inyo na ambalen naan gid alin ta Dyos Ispiritu Santo na padala ta ate na Amay na naan ta langit.” ");
INSERT INTO cgc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ambal pa Jesus, “Ta yon man na timpo ta kakulian, may mga ittaw na iran na mga utod ipapatay danen paagi ta iran na pagtraydor. Iling man tan buaten ta mga amay naan ta iran na kabataan. Mga bata magbatok ta iran na mga ginikanan daw ipapatay man danen iran na mga ginikanan. ");
INSERT INTO cgc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Demetan kaw ta tanan tenged sakep kaw ki yaken. Piro, mga ittaw na magpadayon ta iran na pagpati ki yaken asta ta katapusan ta yon man na timpo, danen an maluwas alin ta lain na mga buat ta mga gakuntra ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Daw papangabot kaw ta mga gakuntra ki kyo naan ta isya na banwa tenged ta inyo na pagtudlo ta mga ittaw dya, malyo kaw naan ta duma na banwa. Dapat gid na malyo kaw daw sugiran ta kyo na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mabot bag-o nyo matapos inyo na ubra na galibot kaw ta inyo na pagtudlo naan ta mga banwa ta Israel. ");
INSERT INTO cgc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Dili kaw magtingala na kuntraen kaw daw sakiten paryo ki yaken tak ula tinudluan na mas datas iya na katengdanan kaysa ta katengdanan ta iya na mistro daw ula suguon na mas datas iya na katengdanan kaysa ta katengdanan ta iya na amo. ");
INSERT INTO cgc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Usto gid daw inagian ta mga tinudluan an magparyo ta inagian ta iran na mistro daw mga suguon ta iran na amo. Daw yaken na mistro nyo paumaw ta mga ittaw na Satanas, mas pa gid lain umaw danen ki kyo na ake na mga tinudluan tak daw ino buaten naan ta amay ta panimalay, mas malain pa mga buaten naan ta mga mimbro ta panimalay.” ");
INSERT INTO cgc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili kaw madlek ta mga ittaw na magkuntra ki kyo. Tanan na sikrito mlaman daw tanan na tinago mwa ta uryan. ");
INSERT INTO cgc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Daw ino ambal ko ki kyo na pasikrito naan ta delem, isugid nyo daw adlaw. Daw ino namatian nyo ki yaken na inay kagi ko, isugid nyo naan ta atep ta balay na tama na mga ittaw kamati. ");
INSERT INTO cgc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dili kaw madlek ta mga ittaw na makapatay ki kyo tak bisan patayen kaw danen, ula danen may mabuat na malain ta inyo na ispiritu. Dyos nang adlekan nyo tak kanen nang may sarang na magsilot ta mga ittaw ta iran na lawa daw ispiritu naan ta impirno.” ");
INSERT INTO cgc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ambal pa Jesus, “Di' ba darwa buok na yupan na derse barato nang na mapalit ta isya nang na sinsilyo na tambaga? Piro, ula gid bisan isya ki danen na nulog naan ta basak na dili pagbeet ta ate na Amay. ");
INSERT INTO cgc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kyo pa na mga ittaw, dili kaw pabay-an ta Dyos tak asta katamaen ta inyo na buok nlaman din. ");
INSERT INTO cgc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Gani, dili kaw madlek tak mas impurtanti kaw kaysa ta tama na yupan.” ");
INSERT INTO cgc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Gambal pa Jesus i naan ta iya na mga tinudluan, “Daw kino mag-ako naan ta tubangan ta mga ittaw na kanen sakep ki yaken, akuon ko naan ta tubangan ta ake na Amay naan ta langit na kanen an sakep ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piro, daw kino mag-ambal naan ta tubangan ta mga ittaw na kanen dili sakep ki yaken, ambalen ko naan ta tubangan ta ake na Amay naan ta langit na kanen an dili sakep ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili nyo isipen na ake na tuyo na giling a di aged magdala ta kalineng naan ta kalibutan i. Tenged ta pag-iling ko di, imbis maglineng naan ta kalibutan i, mga ittaw magkuntraay. ");
INSERT INTO cgc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tenged ta ake na pag-iling di ‘magkuntra bata na mama ta iya na amay, yon man bata na bai ta iya na inay, daw yon man magad na bai ta iya na ugwangan na bai. ");
INSERT INTO cgc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iran na mga kuntra mga duma man gyapon danen naan ta iran na panimalay!’ ");
INSERT INTO cgc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Daw kino na mas palangga din iya na ginikanan daw iya na mga kabataan kaysa ki yaken, dili ko kanen an mabaton na isya ta ake na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Daw kino dili miag na magparyo kanen an ta ittaw na gapas-an ta iya na krus tenged iling tan buaten ta ittaw na magsunod ki yaken, dili ko kanen an mabaton na isya ta ake na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Daw kino gapalabi ta iya na kabui, mapatay man gyapon. Piro, bisan kino na mag-alad ta iya na kabui tenged ki yaken, maangken din kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Gambal pa Jesus i naan ta iya na mga tinudluan, “Daw kino magbaton ki kyo na mga tinudluan ko, paryas man na pabaton a din. Daw kino magbaton ki yaken, paryas man na pabaton din gapadala an ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Daw kino magbaton ta prupita tak nlaman din na manugsugid ta kabebet-en ta Dyos, sigurado na mabaton din dayad na bales alin ta Dyos na paryas ta nabaton ya ta mga prupita. Daw kino magbaton ta matareng na ittaw tak nlaman din na ittaw an matareng, sigurado na mabaton din dayad na bales alin ta Dyos na paryas ta nabaton ya ta mga matareng. ");
INSERT INTO cgc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sugiran ta kyo na daw kino magbuat ta miad maskin mag-atag ta isya nang na baso na waig na inemen naan ta bisan isya ko na kebes na tinudluan tak nlaman din na ittaw an ake na tinudluan, sigurado gid na mabaton din dayad na bales alin ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagtapos ta pag-ambal Jesus ta dusi din na apustulis, gapanaw kanen i aged magtudlo daw magwali naan ta mga dani na banwa. ");
INSERT INTO cgc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Juan ya na manugbautismo naan pa ta prisuan, nabalitaan din parti ta mga pabuat Jesus na Pinili Ta Dyos Na Mag-ari. Tenged ta nabalitaan din, papailing din pila ta iya na mga tinudluan naan ki Jesus aged mag-insa. ");
INSERT INTO cgc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pag-abot danen, gainsa danen ki Jesus, “Kaon kon papaabot nay ya na papangako ta Dyos? Daw dili kaon, may anen pa na duma?” ");
INSERT INTO cgc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sabat Jesus, “Malik kaw ki Juan daw sugiran nyo kanen parti ta mga nakita nyo na pabuat ko daw mga namatian nyo na ambal ko: ");
INSERT INTO cgc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","mga bulag kakita en, mga piang kapanaw en ta usto, mga ittaw na may segeng na masakit ta langgit naayad en, mga bengngel kamati en, mga patay pabui en, daw nasugid en miad an na balita naan ta mga imol. ");
INSERT INTO cgc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sugiran nyo pa kanen an na may angken na kalipay alin ta Dyos mga ittaw na ula danen patalikuri iran an na pagsalig ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na galin mga tinudluan Juan, gambal Jesus parti ki Juan naan ta mga ittaw dya, “Na giling kaw kan-o ki Juan naan ta lugar na ula kabalayan, ino liag nyo na makita? Ittaw na dili pirmaninti iya na isip daw dili man masaligan na paryo ta kugon na paapay-apay nang ta angin? Simpri, dili! ");
INSERT INTO cgc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ino gid liag nyo na makita na giling kaw dya? Mama na gasuot ta maalen na bayo? Simpri, dili! Mga ittaw an na gasuot ta dayad gid na bayo, naan danen gaistar ta mga palasyo. ");
INSERT INTO cgc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ino gid liag nyo na makita? Prupita na manugsugid ta kabebet-en ta Dyos? Simpri, ee! Piro, gambal a ki kyo na Juan ya mas pa ta isya na prupita ");
INSERT INTO cgc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","tak kanen manugsugid ya na pasambit ta Dyos naan ta iya na sinulat na pulong na kanen gambal, ‘Ipadala ko una ki kaon ake na manugsugid aged ipriparar din agian ta imo na pag-abot.’” ");
INSERT INTO cgc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ambal pa Jesus, “Juan gid manugsugid ya na papadala ta Dyos daw sugiran ta kyo na alin ta una na timpo asta anduni, ta tanan na mga ittaw na natao, ula isya ki danen na may labaw pa na katengdanan kaysa ta katengdanan Juan na manugbautismo. Piro, umpisa ta yi na timpo, ittaw na may pinakababa na katengdanan naan ta tanan na sakep ta pagdumala ta Dyos, iya na katengdanan labaw pa ta katengdanan Juan. ");
INSERT INTO cgc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Umpisa pa ta pagwali Juan na manugbautismo asta anduni, gapadayon gid Dyos ta iya na pag-imbitar na mga ittaw magpasakep naan ta iya na pagdumala daw tama na mga ittaw nakumbinsi gid daw dili en mapegengan na magpasakep. ");
INSERT INTO cgc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Naan ta Mga Sinulat Ta Mga Prupita daw Mga Sinulat Moises may tudlo na may timpo na mabot na mag-umpisa pagdumala ta Dyos naan ta kalibutan. Pag-abot Juan, umpisa natuman mga ambal ta Dyos paagi ta mga prupita. ");
INSERT INTO cgc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Daw patian nyo ambal an ta mga prupita, maintindian nyo na Elias ya na ambal danen na mabot, beet ambalen Juan. ");
INSERT INTO cgc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Daw kino liag magbaton ta ake i na ambal, isipen din gid ta usto namatian din an.” ");
INSERT INTO cgc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Gambal pa Jesus i, “Isipen ta anay daw indi pakumparar mga ittaw an ta yi na timpo. Danen an paryo ta mga bata na gamungko naan ta plasa na dili kuntinto ta maskin ino na ampang. Gambal danen ta mga duma danen na gaampang, ");
INSERT INTO cgc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Patukaran nay kyo yan ta plawta ta masadya na kanta, piro ula kaw gasayaw! Pakantaan nay kyo yan ta kanta ta kumpanyar ta patay, piro ula kaw gagal.’” ");
INSERT INTO cgc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ambal man Jesus ta mga ittaw dya, “Iling man tan kyo yan tak ula kaw man gyapon nalipay ki Juan daw ki yaken. Na Juan ya gapwasa daw ula gainem ta bino, ambal nyo, ‘Naseddepan kanen ta malain na ispiritu!’ ");
INSERT INTO cgc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Piro, na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan gainem ta bino daw ula gapwasa, ambal nyo, ‘Lagen nyo ittaw i, takab ta pagkaan daw sikad minem. Pirmi kanen gaduma ta mga manugsukot ta buis daw makasasala na mga ittaw!’” Gambal pa Jesus i ta isya na ambalanen, “Napamatuuran na igo tudlo ya paagi ta pabuat ta mga ittaw na gasunod.” ");
INSERT INTO cgc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gapadayon Jesus i ta iya na laygay daw gambal kanen kuntra ta mga ittaw naan ta mga banwa na naan din dya nabuat katamaan ta iya na mga katingalaan tak maskin nakita danen mga katingalaan ya, ula man gyapon danen ganelsel daw ula man padilian iran an na mga sala. ");
INSERT INTO cgc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ambal din parti ki danen, “May segeng na silot na maageman ta mga taga-Corazin daw taga-Betsaida! Tama na katingalaan na nabuat ko naan ta iran na mga banwa, piro ula danen an ganelsel daw ula man danen padilii iran an na mga sala. Daw naan ta Tiro daw Sidon pabuat ko mga katingalaan na paryo ta nabuat ko naan ta Corazin daw Betsaida, sigurado na mga taga-Tiro daw taga-Sidon magsuot gid dayon ta bayo na sanot-sanuton daw magbetang ta abo naan ta iran na ulo aged ipakita na ganelsel danen an daw padilian man danen iran an na mga sala. ");
INSERT INTO cgc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sugiran ta kyo na daw mabot adlaw na mag-ukom Dyos an naan ta mga ittaw daw kino matareng daw dili matareng, mas gaan silot ta mga taga-Sidon daw taga-Tiro kaysa ta silot ta mga taga-Corazin daw taga-Betsaida. ");
INSERT INTO cgc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Mga ittaw man na taga-Capernaum! Salig gid danen na dayawen danen an ta Dyos. Piro, dili din danen an dayawen. Iulog din danen an naan ta Hades na lugar ta mga patay daw naan dya danen an silutan! Daw naan ta Sodoma pabuat mga katingalaan na paryo ta nabuat ko naan ta Capernaum, sigurado na magnelsel danen an daw asta inta anduni may banwa pa na Sodoma. ");
INSERT INTO cgc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sugiran ta kyo na daw mabot adlaw na mag-ukom Dyos an naan ta mga ittaw daw kino matareng daw dili matareng, mas gaan silot ta mga taga-Sodoma kaysa ta silot ta mga taga-Capernaum.” ");
INSERT INTO cgc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pagtapos ta ambal Jesus, gapangamuyo kanen i, “Amay ko, kaon na manugdumala ta tanan na naan ta langit daw kalibutan, bakod pagdayaw ko an ki kaon. Kamatuuran parti ki kaon na ula no papaintindi ta mga ittaw na maalam daw may datas na iniskwilaan, papaintindi no en ta mga ittaw na paryo ta mga bata na ula kaiskwila. ");
INSERT INTO cgc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Amay ko, nadayaran ka na iling tan imo na pagbeet.” ");
INSERT INTO cgc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pagtapos Jesus ta pangamuyo, gambal kanen an naan ta mga ittaw dya, “Tanan na alam daw gaem ta ake na Amay patugyan din naan ki yaken. Ula duma na kakala ta iya na Bata daw dili, Amay. Ula duma na kakala ta iya na Amay daw dili, Bata daw duma pa man na mga ittaw na papili ta Bata aged naan ki danen ipakala din iya an na Amay.” ");
INSERT INTO cgc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ambal pa Jesus, “Kyo tanan na nabellayan daw nabeg-atan gid ta mga pas-anen, magdangep kaw ki yaken aged tagan ta kyo ta katawwayan. ");
INSERT INTO cgc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magpasakep kaw daw magpatudlo man ki yaken na paryo magpas-an kaw ta singkaw alin ki yaken. Iling tan dapat an na buaten nyo tak yaken i maluluy-on daw mapainebesen daw tagan ta kyo ta katawwayan. ");
INSERT INTO cgc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Dili bellay magpasakep kaw ki yaken daw magtuman ta ake na tudlo tak paryo magbaton kaw ta singkaw na dili beg-at daw pas-anen na dili bellay na alin ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Paglambay ta pila na mga adlaw, Jesus i daw iya na mga tinudluan gaagi naan ta isya na triguan ta Adlaw Ta Pagpuay. Iya na mga tinudluan nletem daw gaugot danen ta pila na passi ta trigo daw pakaan. ");
INSERT INTO cgc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Piro, na nakita ta pila na mga Pariseo na mga tinudluan Jesus gaugot daw gakaan, gambal danen ki kanen, “Lagen no ubra ta imo na mga tinudluan. Pabuat danen kuntra ta mga sugo parti ta Adlaw Ta Pagpuay.” ");
INSERT INTO cgc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sabat Jesus, “Paryo kaw inyo na ula kabasa parti ta pabuat Ari David anay pa sa na nletem gid kanen daw iya na mga duma! ");
INSERT INTO cgc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kanen giling naan ta balay ta Dyos daw gakaan ta tinapay na paalad para ta Dyos. Patagan din man iya na mga duma. Piro, maskin mga pari nang patugutan na maan ta tinapay na paalad para ta Dyos, buat ya danen Ari David ula pabilang na kuntra ta mga sugo Moises. ");
INSERT INTO cgc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Paryo kaw inyo na ula kabasa naan ta Mga Sinulat Moises parti ta mga pari na kinanglan mag-ubra naan ta Adlaw Ta Pagpuay. Gasirbi danen ta Dyos naan ta Timplo naan ta Adlaw Ta Pagpuay maskin kuntra ta mga sugo Moises na mubra naan ta Adlaw Ta Pagpuay, piro buat ya danen na mga pari ula pabilang na kuntra ta mga sugo. ");
INSERT INTO cgc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sugiran ta kyo na impurtanti gid mga sugo parti ta Timplo, piro may anen di na mas impurtanti kaysa ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Daw naintindian nyo inta daw ino beet ambalen ta ambal ta Dyos, ula kaw inta gausgar ta duma na ula gabuat ta sala. Iling ti ambal ta Dyos, ‘Mas gusto ko na may kaluoy kaw ta kada isya kaysa may paalad kaw ki yaken.’ ");
INSERT INTO cgc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gani, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan may uturidad na magbeet daw ino tugot na buaten naan ta Adlaw Ta Pagpuay.” ");
INSERT INTO cgc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pagtapos Jesus ta isturya naan ta mga Pariseo ya, gapadayon kanen i ta iya na pagpanaw daw gaselled naan ta balay tipunan na naan dya mga Pariseo na ya gasimba. ");
INSERT INTO cgc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naan dya may mama na isya din an na lima kimay. Gainsa mga Pariseo ki Jesus, “Ino ta imo na isip, naan ta Mga Sinulat Moises patugot na naan ta Adlaw Ta Pagpuay magpaayad ki ta mga ittaw na may masakit?” Iling tan insa ta mga Pariseo tak papangitaan danen kanen i ta sala aged maakusaran. ");
INSERT INTO cgc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sabat din, “Daw isya ki kyo may subuok na karniro na mulog ta lungag naan ta Adlaw Ta Pagpuay, simpri gawaten nyo daw mangen pagwa! ");
INSERT INTO cgc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Di' ba ittaw an mas impurtanti kaysa ta karniro? Gani, dili kuntra ta Mga Sinulat Moises na magbuat ki ta miad ta ate na mga duma naan ta Adlaw Ta Pagpuay.” ");
INSERT INTO cgc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pagsabat Jesus ta mga Pariseo, gambal kanen ta mama ya, “Untayen no imo na lima na kimay.” Dayon, pauntay ta mama iya na lima daw nayad na paryo ta liyo din na lima na ula dipirinsya. ");
INSERT INTO cgc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Galin mga Pariseo ya daw gasapol danen an daw ino paagi na Jesus an ipapatay danen. ");
INSERT INTO cgc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na nlaman Jesus na paplanuan kanen i ta mga Pariseo na patayen, galin kanen ta lugar ta mga Pariseo na ya. Tama na mga ittaw gasunod ki kanen daw tanan ki danen na may masakit paayad din. ");
INSERT INTO cgc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Paambalan din danen an na dili manugid-sugid parti ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tenged iling tan mga pabuat din, natuman sulat ya Isaias na prupita anay pa sa na Dyos gambal: ");
INSERT INTO cgc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yi ake na pinili aged magsirbi ki yaken. Papalangga ko daw nalipay a gid ki kanen. Ubayan ko kanen an paagi ta ake na Ispiritu. May ibalita kanen an para ta tanan na mga ittaw daw ino paagi na bilangen ko na danen an matareng. ");
INSERT INTO cgc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dili kanen magdiskas daw dili man minggit naan ta mga ittaw. Dili man kanen an mamatian na gambal na iya na kagi biskeg naan ta mga dalan. ");
INSERT INTO cgc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Miad kanen an daw magtabang man ta mga ittaw na galuya iran an na pagsalig na paryo kanen an ta ittaw na ula gabali ta tanem na gaapay daw ula man gapatay ta lampraan na gapaleng-paleng. Padayunon din iya na buat na iling tan asta matuman ake na liag na mga ittaw bilangen ko na matareng. ");
INSERT INTO cgc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Naan ki kanen paglaem ta tanan.” Yon ambal ta Dyos naan ta sinulat Isaias. ");
INSERT INTO cgc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","May mama na naapa daw nabulag tak naseddepan ta malain na ispiritu. Padala kanen i naan ki Jesus daw paayad Jesus kanen i na kaambal dayon daw kakita. ");
INSERT INTO cgc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tanan gatingala daw gambal, “Yi taan en Apo Ari David na papaabot ta.” ");
INSERT INTO cgc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Piro, na namatian ta mga Pariseo ambal ya ta mga ittaw, gambal danen an, “Nyan na ittaw gapagwa ta mga malain na ispiritu paagi nang ta gaem na alin ki Satanas na pangulo ta mga malain na ispiritu.” ");
INSERT INTO cgc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nlaman Jesus iran an na isip daw gambal kanen ki danen, “Daw mga sinakepan ta isya na kaarian magkuntraay, iran na kaarian dili magpadayon. Daw mga ittaw na naan ta isya na syudad magkuntraay, dili magpadayon iran na syudad. Iling man tan matabo daw mga ittaw na naan ta isya na panimalay magkuntraay. ");
INSERT INTO cgc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Daw palayasen Satanas iya na mga sinakepan, pakuntra din iya an na kaugalingen. Daw iling tan, dili magpadayon iya an na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ambal nyo na naan alin ki Satanas gaem an ta ake na pagpagwa ta mga malain na ispiritu, piro indi alin gaem ya ta inyo na mga tinudluan ta iran na pagpagwa ta mga malain na ispiritu? Simpri alin ta Dyos! Danen an pamatuod na sala gid inyo an na ambal tak iran na gaem daw ake paryas nang na alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tenged papagwa ko mga malain an na ispiritu paagi ta gaem ta Dyos Ispiritu Santo, beet ambalen na gabot en naan ki kyo papaabot nyo na pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ambal pa Jesus, “Daw may ittaw na liag melled daw mamang ta mga pagkabetang naan ta balay ta iseg na ittaw, impusibli na kaselled kanen an daw dili din anay magapos iseg ya na ittaw. Daw nagapos en, sigurado gid na makamang din en mga pagkabetang naan ta balay.” ");
INSERT INTO cgc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ambal pa Jesus, “Daw kino na ula gatabang ki yaken ta ake na ubra, kanen gakuntra ki yaken na paryo kanen ta ittaw na imbis na mabang ta pagtipon ta mga karniro, gatabog ki danen na magpadyo. ");
INSERT INTO cgc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sugiran ta kyo na bisan ino na mga sala ta mga ittaw daw mga ambal danen na malain kuntra ta Dyos, mapatawad pa. Piro, mga ambal danen na malain kuntra ta Dyos Ispiritu Santo, dili mapatawad. ");
INSERT INTO cgc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Daw kino mag-ambal ta malain kuntra ki Yaken Na Alin Ta Langit Na Natao Naan Ta Kalibutan, mapatawad pa ta Dyos. Piro, daw kino mag-ambal ta malain kuntra ta Dyos Ispiritu Santo, dili mapatawad naan ta yi na timpo daw dili man mapatawad naan ta timpo na mabot.” ");
INSERT INTO cgc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gambal pa Jesus i, “Daw dayad kaoy an, simpri dayad man iya na bunga. Daw lain kaoy an, simpri lain man iya na bunga. Mga kaoy makala paagi ta iran na bunga. ");
INSERT INTO cgc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kyo na malain! Paryo kaw ta mga bata ta bekkessan na dalitan! Impusibli na mag-ambal kaw ta maskin ino na miad paryo ta kaoy na lain impusibli na magbunga na dayad tak daw ino naan ta isip ta ittaw, yon man ambalen din. ");
INSERT INTO cgc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ittaw na miad, pirmi man miad mga paambal din tak tanan na naan ta iya na isip miad. Ittaw na malain, pirmi man malain mga paambal din tak tanan na naan ta iya na isip malain. ");
INSERT INTO cgc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sugiran ta kyo na naan ta adlaw na mag-ukom Dyos an ta mga ittaw daw kino matareng daw dili matareng, kyo manabat naan ki kanen tenged ta inyo na mga ambal na malain na dapat ula nyo inta ambala ");
INSERT INTO cgc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","tak dipindi ta inyo na mga naambal daw silutan kaw, daw dili.” ");
INSERT INTO cgc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","May mga Pariseo daw manugtudlo ta Mga Sinulat Moises na gambal ki Jesus, “Mistro, liag nay na magbuat ka ta katingalaan aged makita nay pamatuod na papadala ka ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sabat Jesus, “Mga ittaw ta yi na timpo malain daw gatalikod ta Dyos. Papangitaan a danen ta katingalaan na buat aged may pamatuod para ki danen na papadala a ta Dyos. Piro, ula duma na katingalaan na ipakita ki danen daw dili, katingalaan ya na natabo ki Jonas na prupita anay pa sa. ");
INSERT INTO cgc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Seled ta tallo adlaw daw tallo kilem naan Jonas ya ta gettek ta sikad bakod na sidda daw kagwa man na bui. Paryo man tan, Kanen Na Alin Ta Langit naan ta lebbengan ta tallo adlaw daw tallo kilem daw magwa man na bui. ");
INSERT INTO cgc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Daw mabot adlaw na mag-ukom Dyos an ta tanan na mga ittaw daw kino matareng daw dili matareng, naan dya mga taga-Ninive ya na nabui anay pa sa ta timpo Jonas mindeg daw magpamatuod na igo gid na silutan ta Dyos mga ittaw an ta yi na timpo. Mga taga-Ninive ya may matareng na magpamatuod ta iling sa tak ganelsel daw padilian danen iran an na mga sala na kamati danen ta wali Jonas. Piro anduni, anen di en isya i na mas labaw pa iya na katengdanan kaysa ta katengdanan Jonas, piro ula kaw gapati ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Daw mabot adlaw na mag-ukom Dyos an ta tanan na mga ittaw daw kino matareng daw dili matareng, naan dya Rayna ya na alin ta Sur mindeg daw magpamatuod na igo gid na silutan ta Dyos mga ittaw an ta yi na timpo. Kanen an may matareng na magpamatuod ta iling sa tak anay pa sa kanen gabyai na naan pa alin ta sikad madyo na lugar aged mamati ta tudlo Ari Solomon na maalam gid. Piro anduni, anen di en isya i na mas labaw pa iya na katengdanan kaysa ta katengdanan Ari Solomon, piro ula kaw gapati ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Gaisturya Jesus i ta alimbawa, “May malain na ispiritu na gagwa ta ittaw na paseddepan din. Paggwa din, giling kanen an naan ta mara na lugar aged mangita ta mapuayan. Piro, ula kanen may nakita. ");
INSERT INTO cgc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Gaisip kanen an, ‘Miad pa na malik a naan ta ittaw ya na naalinan ko.’ Pagbalik din naan ta ittaw ya, nakita din na paryo ta balay na bakanti, limpyo daw ayos. ");
INSERT INTO cgc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gagwa isab kanen an naan ta ittaw ya aged mangita ta pitto na mas malain pa na ispiritu kaysa ki kanen. Pagkita din, danen tanan gaseddep naan ta ittaw ya daw gatinir dya ta lugay. Mas lain pa gid uryan an na kaimtangan ta ittaw ya kaysa ta una. Iling man tan matabo ta malain na mga ittaw ta yi na timpo. Gadugang pa gid iran an na malain na buat daw isip tak ula danen ganelsel ta iran na mga sala na namatian danen miad na balita.” ");
INSERT INTO cgc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na gambal pa Jesus i ta mga ittaw, gabot iya na mga utod na mama daw iya na inay. Gatindeg danen an naan ta gwa tak may ambalen danen ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","May gambal ki kanen, “Naan ta gwa imo ya na inay daw mga utod. May ambalen danen an ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Gainsa Jesus i ta ittaw na gambal ki kanen, “Kino ake an na inay daw mga utod?” ");
INSERT INTO cgc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pag-insa din, patudlo din iya na mga tinudluan daw mambal, “Yi danen i pabilang ko na ake na inay daw mga utod ");
INSERT INTO cgc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","tak daw kino mga gasunod ta kabebet-en ta ake na Amay na naan ta langit, danen pabilang ko na ake na utod daw inay.” ");
INSERT INTO cgc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yon man na adlaw na gatudlo Jesus i ta iya na mga tinudluan naan ta isya na balay, galin kanen i dya daw megbeng naan kilid ta Dagat Galilea daw gamungko dya. ");
INSERT INTO cgc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sikad tama na mga ittaw giling dya daw gatipon naan ki kanen. Tenged sikad tama ittaw, gasakay kanen i naan ta buti daw mungko. Mga ittaw an a, gatindeg naan ta dagsayan. ");
INSERT INTO cgc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tama iya na paambal ki danen paagi ta mga paanggid na isturya na paryo ti: “Mamati kaw! May mangunguma na giling naan ta iya na uma aged magsabwag ta binni. ");
INSERT INTO cgc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta iya na pagsabwag, may mga binni na katupa naan ta dalan. Mga yupan gaprani daw mga binni an ubos danen ta tuktok. ");
INSERT INTO cgc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Duma an na binni katupa naan ta batuan na may tappaw nang na basak. Tenged tappaw nang, ula nang lugay nanlisok en mga binni an. ");
INSERT INTO cgc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na ugto-adlaw en, galayeng daw gakeseg tak babaw nang mga gamot an. ");
INSERT INTO cgc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Duma man an na binni katupa naan ta basak na natubuan ta mga telleken na lamunon. Na gatubo en mga lamunon, nalemmes mga binni ya na gatubo. ");
INSERT INTO cgc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Piro, duma pa gid na binni katupa naan ta dayad na basak daw gatubo, gabakod daw namunga. May bunga na gapungpong ta isya gatos na passi, may anen man sisinta daw may anen man trinta.” ");
INSERT INTO cgc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gambal pa Jesus i, “Daw kino liag magbaton ta ake i na ambal, isipen din gid ta usto namatian din an.” ");
INSERT INTO cgc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Gaprani mga tinudluan Jesus ki kanen daw gainsa, “Man-o tak gagamit ka ta mga paanggid na isturya ta imo na pag-ambal naan ta mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sabat Jesus, “Kyo na mga tinudluan ko patagan ta Dyos ta pribiliyo na maintindian nyo mga ula din pasugira anay pa sa parti ta iya na pagdumala. Piro, duma na mga ittaw ula din paatagan ");
INSERT INTO cgc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","tak daw kino kaintindi daw gapati ta ake na mga patudlo parti ta pagdumala ta Dyos, dugangan pa gid ta Dyos asta na magtama iya an na maintindian. Piro, daw kino ula gapati, bawian pa ta Dyos kanen an daw ino na naintindian din parti ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yon na gatudlo a paagi ta mga paanggid na isturya naan ta duma na mga ittaw tak maski patan-aw danen ta miad ake na mga buat, ula man gyapon kaintindi daw ino beet ambalen. Maski namatian danen ta miad ake na mga patudlo, paryas ula man gyapon danen an kamati daw ula man gyapon kaintindi. ");
INSERT INTO cgc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tenged iling tan danen an, natuman en sulat ya Isaias na prupita anay pa sa na Dyos gambal, ‘Maski mamati kaw pa ta miad daw magtan-aw, dili kaw man gyapon kaintindi daw ino beet ambalen. ");
INSERT INTO cgc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yi na mga ittaw, dessen iran na ulo. Gapabengngel nang danen an daw gapabulag-bulag aged paryas na ula danen an kakita, kamati daw kaintindi tak basi daw maintindian danen, magnelsel daw marani ki yaken daw patawaren ko danen an.’” ");
INSERT INTO cgc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ambal man Jesus, “Iling tan duma na mga ittaw, piro may bakod kaw na pribiliyo tak kakita kaw ta ake na mga buat daw kamati man ta ake na ambal. ");
INSERT INTO cgc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","May bakod kaw gid na pribiliyo daw sugiran ta kyo na anay pa sa tama na manugsugid ta kabebet-en ta Dyos daw mga dyusnon na ittaw na gaandem na makita danen mga buat na nakita nyo, piro ula bisan isya ki danen kakita. Liag man danen na mamatian mga ambal na namatian nyo, piro ula bisan isya ki danen kamati.” ");
INSERT INTO cgc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ambal pa Jesus, “Matian nyo daw ino beet ambalen ta paanggid na isturya ta mangunguma na gasabwag. ");
INSERT INTO cgc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Isya na ittaw kamati ta tudlo parti ta pagdumala ta Dyos, piro ula kanen kaintindi ta usto. Gabot Satanas daw pakamang din tudlo ya na naan ta isip ta ittaw. Iling tan beet ambalen ta mga binni na katupa naan ta dalan. ");
INSERT INTO cgc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mga binni na katupa naan ta batuan na may tappaw nang na basak paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw daw pabaton dayon na may kalipay, ");
INSERT INTO cgc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","piro iran na pagpati dili terek ta iran na nakem. Paryo danen ta tanem na mga gamot an babaw nang. Gani, ula nang lugay iran na pagpati. Na gabot mga prublima daw papangabot danen ta mga gakuntra ki danen tenged ta iran na pagpati ta tudlo ya, patalikuran danen dayon iran na pagpati. ");
INSERT INTO cgc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mga binni na katupa naan ta natubuan ta mga telleken na lamunon paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw, piro nalipatan danen tudlo ya tenged gapalibeg danen parti ta pangabui daw gangabot man na magmanggaranen. Ula en pulos iran na pagpati tak ula risulta na paryo danen an ta tanem na ula gabunga. ");
INSERT INTO cgc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mga binni na katupa naan ta dayad na basak paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw daw papatian man danen daw may dayad na risulta iran na pagpati. Danen an paryo ta tanem na gapungpong ta bunga na may isya gatos na passi, may sisinta daw may anen man na trinta.” ");
INSERT INTO cgc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Gaisturya Jesus i ta isya pa na paanggid, “Pagdumala an ta Dyos paryo ta natabo ta isya na mama na gasabwag ta dayad na binni na trigo naan ta iya na uma. ");
INSERT INTO cgc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Piro, isya na kilem na gatunuga pa mga ittaw, giling iya na kuntra naan ta uma ya daw pasabwagan ta binni ta lamunon na kilo na daw lagen paryo man ta trigo. Pagtapos ta pagsabwag, guli iya na kuntra. ");
INSERT INTO cgc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na gatubo en trigo ya daw gamunga, nakala man en daw indi sa mga lamunon. ");
INSERT INTO cgc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mga suguon ta tag-iya ta uma giling ki kanen daw gambal, ‘Amo, di' ba dayad na binni imo na pasabwag naan ta imo na uma? Man-o taan tak may anen man dya kilo na mga lamunon?’ ");
INSERT INTO cgc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sabat din, ‘Pasabwag ta kuntra.’ Insa danen, ‘Gusto no na bud-uton nay mga lamunon an?’ ");
INSERT INTO cgc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Sabat din, ‘Dili nang anay. Daw bud-uton nyo, basi madapil trigo an. ");
INSERT INTO cgc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bay-an nyo nang anay asta na mabot uras ta tag-ani. Daw tag-ani en, suguon ko mga manug-ani an na bud-uton danen kilo an na mga lamunon daw begkesen aged sunugon. Piro trigo an a, tipunon danen daw itago naan ta ake na budiga.’” ");
INSERT INTO cgc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Gaisturya Jesus i ta isya pa man na paanggid, “Pagdumala an ta Dyos paryo ta natabo ta binni na mustasa na patanem ta isya na ittaw naan ta iya na uma. ");
INSERT INTO cgc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yi na binni pinakatise ta tanan na binni. Piro, na gatubo en, mas pa bakod kaysa ta tanan na tanem na gulay daw naimo na bakod na kaoy. Bisan mga yupan an gatugdon daw gasalag naan ta iya na mga sanga.” ");
INSERT INTO cgc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gaisturya Jesus i ta isya pa gid na paanggid, “Pagdumala an ta Dyos paryo ta natabo ta tise na pampaabok ta tinapay na palaket ta isya na bai naan ta tama na arina na bali tallo sekeb ta bakod na sekeban. Maskin tama arina an, napaabok man gyapon tanan.” ");
INSERT INTO cgc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na gatudlo Jesus i naan ta mga ittaw parti ta pagdumala ta Dyos, tanan na panudluon din paagi nang ta mga paanggid. Ula kanen gatudlo ki danen daw dili, paagi nang ta mga paanggid. ");
INSERT INTO cgc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ta iya na pag-isturya ta mga paanggid, natuman sinulat ya ta isya na prupita anay pa sa, “Mag-ambal a ki danen paagi ta mga paanggid. Mag-ambal a parti ta mga ula pa nlami ta mga ittaw alin pa ta pagbuat ta kalibutan.” ");
INSERT INTO cgc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagtapos Jesus ta pag-isturya ta mga paanggid, padilian din mga ittaw na patudluan din daw gaselled naan ta balay na iya na dayunan. Gaprani iya na mga tinudluan daw gainsa, “Pwidi kay no sugiran daw ino beet ambalen ta paanggid ya parti ta kilo na lamunon.” ");
INSERT INTO cgc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sabat din, “Ittaw ya na gasabwag ta dayad na binni beet ambalen Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. ");
INSERT INTO cgc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Uma ya beet ambalen kalibutan i. Dayad ya na binni beet ambalen mga ittaw na sakep ta pagdumala ta Dyos daw kilo ya na lamunon, mga sakep ta pagdumala Satanas. ");
INSERT INTO cgc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kuntra ya na gasabwag ta binni ta kilo na lamunon beet ambalen Satanas. Tag-ani ya beet ambalen pag-ukom ta Dyos naan ta katapusan ta yi na timpo daw mga manug-ani ya, danen mga angil ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pag-ukom an ta Dyos ta katapusan paryo ta pagtipon daw pagsunog ta kilo na lamunon na pabud-ot. ");
INSERT INTO cgc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta timpo ta pag-ukom ta Dyos, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan magpadala ta iya na mga angil aged tanan na gatintar daw tanan man na gabuat ta malain tipunon danen daw belagen naan ta mga ittaw na iya na padumalaan. ");
INSERT INTO cgc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mga ittaw na malain ipilak ta mga angil naan ta apoy na gadaba-daba daw naan dya mangagal ta tudo daw magbaggit ta iran na ngipen. ");
INSERT INTO cgc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mga gapasakep ta pagdumala ta Dyos, naan danen ta kaarian ta ate na Amay na paryo danen an ta adlaw na gasilak gid. Daw kino liag magbaton ta ake i na ambal, isipen din gid ta usto namatian din an.” ");
INSERT INTO cgc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Gambal pa Jesus i naan ta iya na mga tinudluan, “Pagdumala an ta Dyos paryo ta natabo ta manggad na nalebbeng naan ta isya na uma. Manggad an nakita ta isya na ittaw daw patampekan din isab. Ta iya na kalipay guli kanen daw pabligya din tanan din na pagkabetang daw papalit uma ya.” ");
INSERT INTO cgc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ambal pa Jesus, “Isab, pagdumala an ta Dyos paryo ta natabo daw isya na nigusyanti gangita ta dayad na mga pirlas. ");
INSERT INTO cgc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pagkita din ta dayad na pirlas na sikad maal, guli kanen an daw pabligya tanan din na pagkabetang daw papalit din pirlas ya.” ");
INSERT INTO cgc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Gambal pa Jesus i naan ta iya na mga tinudluan, “Isya pa na paanggid. Pagdumala an ta Dyos paryo ta natabo daw may pukot na pataktak naan ta dagat daw klasi-klasi na mga sidda naapas. ");
INSERT INTO cgc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na tama en apas naan ta pukot, pabatak ta mga mananagat daw dleen ta baybay. Gapungko danen daw papili dayad an na mga sidda daw paugsak naan ta bangkat. Piro, dili dayad na mga sidda papilak. ");
INSERT INTO cgc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iling man tan matabo ta mga ittaw ta pag-ukom ta Dyos naan ta katapusan ta yi na timpo. Mga angil an mabot daw belagen danen mga ittaw an na malain daw matareng. ");
INSERT INTO cgc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mga malain an pilak naan ta apoy na gadaba-daba daw naan dya mangagal ta tudo daw magbaggit ta iran na ngipen.” ");
INSERT INTO cgc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus i gainsa ta iya na mga tinudluan, “Naintindian nyo tanan na paanggid na paisturya ko?” Sabat danen, “Ee.” ");
INSERT INTO cgc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ambal pa Jesus, “Kada manugtudlo na gasunod ta patudlo ki kanen parti ta pagdumala ta Dyos sarang magtudlo ta dati na mga tudlo daw bag-o man na mga tudlo. Manugtudlo na iling tan paryo ta tag-iya ta balay na tama daan daw bag-o man na manggad naan ta taguan na pwidi din iprisintar naan ta iya na mga bisita.” ");
INSERT INTO cgc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagtapos Jesus ta pag-isturya ta mga paanggid naan ta iya na mga tinudluan, gapadayon kanen ta iya na pagpanaw. ");
INSERT INTO cgc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Guli kanen naan ta banwa na naan dya kanen an gabakod. Naan dya gatudlo kanen naan ta balay tipunan daw gatingala gid tanan na kamati ki kanen daw gambal danen, “Indi alin iya na kanlaman daw iya na gaem ta pag-imo ta mga katingalaan? ");
INSERT INTO cgc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Di' ba amay din karpintiro ya? Di' ba inay din Maria an daw mga utod din danen Santiago, Jose, Simon daw Judas? ");
INSERT INTO cgc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Di' ba mga utod din na bai anen man di ta ate i na banwa gaistar? Indi gid alin iya na tudlo?” ");
INSERT INTO cgc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tenged iling tan iran na isip parti ki Jesus, ula gid danen an gapati ki kanen. Piro, gambal Jesus ki danen, “Bisan indi na lugar, mga prupita an na manugsugid ta kabebet-en ta Dyos pataod gid ta mga ittaw, piro naan ta iran gid na banwa ula pataura ta iran na kasimanwa daw pamilya.” ");
INSERT INTO cgc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tenged mga kasimanwa Jesus ula gapati ki kanen, dili gid tama nabuat din na mga katingalaan naan ta iran na banwa. ");
INSERT INTO cgc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ta timpo na Jesus gatudlo naan ta Nazaret, Herodes i na manugdumala ta Galilea, namatian din mga isturya parti ki Jesus ");
INSERT INTO cgc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","daw gambal ta iya na mga upisyalis, “Basi Jesus an, yon man Juan na manugbautismo na nabannaw. Yon na may gaem kanen ta pagbuat ta mga katingalaan.” ");
INSERT INTO cgc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nlaman Herodes parti ki Juan tak kanen mismo gasugo na Juan ya dakepen, gapuson, daw prisuon. Papriso din Juan tenged ki Herodias na pasawa din bisan Herodias an sawa ta iya na utod na Felipe ");
INSERT INTO cgc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","daw tenged man na kanen an pirmi paambalan Juan, “Kuntra ta mga sugo naan ta Mga Sinulat Moises na pasawa no sawa ta imo na utod.” ");
INSERT INTO cgc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tenged ta ambal Juan, gusto Herodes na ipapatay Juan ya, piro nadlek kanen ta mga ittaw tak gapati danen an na Juan ya isya na prupita alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naan ta kaadlawan Herodes, manak din na dalagita na bata Herodias gaselled daw gasayaw naan tubangan ta mga gatambong. Naganya gid ta iya na sayaw Herodes i ");
INSERT INTO cgc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","daw ganumpa gid na iatag ki kanen daw ino iya na ayuon. ");
INSERT INTO cgc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ta segyet ta inay din, gambal kanen naan ki Herodes, “Atag no dayon ki yaken ulo ya Juan na manugbautismo na nabetang naan ta bandiyado.” ");
INSERT INTO cgc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pagmati Herodes, ganelsel kanen an, piro tenged ta iya na sumpa na namatian ta mga bisita din, gasugo kanen an na tumanen papangayo ta dalagita. ");
INSERT INTO cgc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Papauturan din Juan ta lieg naan ta prisuan. ");
INSERT INTO cgc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ulo ya Juan na nabetang ta bandiyado paatag naan ta dalagita daw paatag din man naan ta iya na inay. ");
INSERT INTO cgc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mga tinudluan Juan giling dya daw mangen lawa ya daw ilebbeng. Pagtapos ta paglebbeng, giling danen ki Jesus daw pasugid na Juan ya patay en. ");
INSERT INTO cgc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagmati Jesus na Juan ya patay en, gasakay kanen ta buti na kanen nang. Giling kanen ta lugar na ula kabalayan. Piro, na nlaman ta mga ittaw na galin kanen i, galutos danen an na gapanaw nang alin ta lain-lain na mga banwa. ");
INSERT INTO cgc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagkawas Jesus, patan-aw din sikad tama na mga ittaw na gatipon dya daw naluoy gid kanen i ki danen. Tenged ta iya na kaluoy, paayad din mga ittaw ya na may masakit. ");
INSERT INTO cgc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na semsem en, gaprani mga tinudluan Jesus ki kanen daw mambal, “Kilem en, naan ki pa di ta lugar na ula kabalayan. Miad taan daw pailingen no mga ittaw an naan ta mga baryo aged malit ta iran na pagkaan.” ");
INSERT INTO cgc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sabat Jesus ki danen, “Dili en kinanglan na manaw pa danen an. Kyo mag-atag ki danen ta iran na makaan.” ");
INSERT INTO cgc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sabat danen, “Mistro, impusibli tak may anen ki nang di limma buok na tinapay daw darwa na sidda.” ");
INSERT INTO cgc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ambal Jesus, “Dleen nyo di.” ");
INSERT INTO cgc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pagbaton din, gambal kanen naan ta mga ittaw na mungko naan ta lamunon. Pakamang din limma an na tinapay daw darwa na sidda. Gaangad kanen ta langit daw gapasalamat ta Dyos. Dayon, pabiak-biak din tinapay ya daw paatag naan ta iya na mga tinudluan aged itagtag man danen naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kakaan danen tanan daw nabusog. Patipon ta iya na mga tinudluan sama ya daw napanno danen dusi na baskit na darko. ");
INSERT INTO cgc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Katamaen ta mga kakaan mga limma libo na mama na ula labet ta bilang mga bai daw mga kabataan. ");
INSERT INTO cgc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Na natipon en ta mga tinudluan Jesus sama ya na tinapay daw sidda, pasakay din dayon danen an naan ta isya na buti daw paambalan na muna en lakted naan ta liyo ta dagat tak paulien din pa mga ittaw an. ");
INSERT INTO cgc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Na napauli din en danen an, giling kanen naan ta bukid na kanen nang aged mangamuyo. Na semsem en, isya nang kanen an dya. ");
INSERT INTO cgc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta yo man na uras mga tinudluan din na naan ta buti madyo en alin ta dagsayan. Nakulian buti an magsulong tenged ta darko na baled tak sungsong angin an. ");
INSERT INTO cgc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na mapit-madlaw en, gasunod Jesus i ki danen na gapanaw kanen naan ta apaw ta waig. ");
INSERT INTO cgc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na nakita kanen i ta mga tinudluan din, nakulbaan gid danen an daw gasinggit ta subla na adlek, “Bagat!” ");
INSERT INTO cgc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gambal dayon Jesus i ki danen, “Isegen nyo nakem nyo an! Yaken ni. Dili kaw madlek!” ");
INSERT INTO cgc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Gambal Pedro i, “Ginuo, daw kaon gid nyan, mambal ka na miling a dyan ki kaon na manaw a man naan ta apaw ta waig.” ");
INSERT INTO cgc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ambal Jesus, “Manaw ka di!” Pag-ambal Jesus, gapanaog Pedro i ta buti daw gapanaw naan ta apaw ta waig na miling ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Na nabatyagan Pedro biskeg na angin, nadlek kanen an daw gaamat-amat leddang. Gasinggit kanen an, “Ginuo, tabangan a no!” ");
INSERT INTO cgc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pagawat dayon Jesus daw paibitan Pedro i daw mambal, “Pedro, tise imo na pagsalig! Man-o tak gadua-dua ka?” ");
INSERT INTO cgc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pag-ambal din, gasakay danen na darwa naan ta buti daw galinaw. ");
INSERT INTO cgc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mga tinudluan an na naan ta buti gadayaw ki Jesus, “Matuod gid! Kaon Bata Ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Paglakted Jesus daw iya na mga tinudluan naan ta liyo na baybay ta Dagat Galilea, gadungka danen an ta banwa na Genesaret. ");
INSERT INTO cgc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na nakala ta mga ittaw dya Jesus i, palapta danen balita na naan dya kanen i daw tanan na mga ittaw na may masakit padala ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gapangabay mga ittaw ki kanen na daw pwidi mga ittaw na may masakit magtandeg bisan ta bungay-bungay nang ta sidsid ta iya na bayo na pangkablay. Tanan na katandeg nayad. ");
INSERT INTO cgc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","May giling ki Jesus na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises na naan galin ta Jerusalem. Gainsa danen ki kanen, ");
INSERT INTO cgc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Man-o tak imo an na mga tinudluan ula gasunod ta mga kaugalian na alin ta ate na mga manakem? Ula danen gasunod ta sirimunya ta pag-ugas ta lima bag-o danen an maan.” ");
INSERT INTO cgc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sabat Jesus ki danen, “Ta, kyo a, man-o tak ula kaw gatuman ta mga sugo ta Dyos aged masunod nyo nang mga kaugalian an na buat nyo? ");
INSERT INTO cgc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Di' ba sugo ta Dyos, ‘Tauron no imo an na amay daw inay’? Ambal din man, ‘Bisan kino gambal ta malain parti ta iya na amay daw inay dapat silutan ta kamatayen.’ ");
INSERT INTO cgc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Piro, dili iling tan inyo na patudlo tak naan ta mga kaugalian na pabuat nyo, patudlo nyo na mga ittaw dili en kinanglan magtaod ta iran na ginikanan paagi ta pagtabang basta mag-ambal danen an ta iran na ginikanan ta iling ti, ‘Ake na iatag na tabang inta ki kyo natagana en para ialad naan ta Dyos.’ Ula nyo patubaya sugo an ta Dyos para masunod nang mga kaugalian na pabuat nyo. ");
INSERT INTO cgc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Inyo na pagtaod ta Dyos pakita-kita nang! Igo gid laygay Isaias na prupita anay pa sa parti ki kyo naan ta iya na sinulat. Nasulat din na Dyos gambal, ");
INSERT INTO cgc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Yi na mga ittaw gataod ki yaken paagi nang ta iran na baba. Piro, iran na tagipusuon adyo ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ula pulos iran an na pagsimba ki yaken tak danen an gatudlo na naan kon alin ki yaken mga sugo an na naan nang alin ta mga ittaw.’” ");
INSERT INTO cgc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Paumaw Jesus mga ittaw na marani daw ambal din, “Mamati kaw daw intindien nyo ambalen ko i. ");
INSERT INTO cgc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dili tenged ta mga gaselled ta baba ta mga ittaw na danen an pabilang na ‘dili-limpyo’. Danen an pabilang na ‘dili-limpyo’ tenged ta mga gagwa naan ta iran na baba.” ");
INSERT INTO cgc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pag-ambal Jesus, gaprani iya na mga tinudluan daw gambal, “Nainsulto gid mga Pariseo an ta imo na ambal.” ");
INSERT INTO cgc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus i gasabat ki danen paagi ta paanggid parti ta mga Pariseo, “Kada tanem na ula patanema ta ake na Amay na naan ta langit bud-uton gid. ");
INSERT INTO cgc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Largaan nyo nang mga Pariseo an tak paryo danen an ta mga bulag na manugguyod ta bulag. Daw bulag magguyod ta paryo din na bulag, danen an na darwa mulog naan ta lungag.” ");
INSERT INTO cgc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Gambal Pedro i ki Jesus, “Sugiran kay no tuo daw ino beet ambalen ta ambal no an parti daw ino gaselled daw gagwa naan ta baba ta mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sabat Jesus, “Asta kyo na ake na mga tinudluan, ula man kaintindi? ");
INSERT INTO cgc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dapat naintindian nyo na bisan ino na gaselled ta baba ta mga ittaw gadiritso naan ta iran na gettek daw ta uryan magwa man gyapon. ");
INSERT INTO cgc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Naan alin ta tagipusuon ta mga ittaw mga malain na ambal na gagwa alin ta iran na baba. Tenged ta iran na malain na ambal bilangen danen an na ‘dili-limpyo’ ");
INSERT INTO cgc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","tak naan alin ta tagipusuon mga buat na iling ti: mga malain na isip, gapatay, gadulog ta dili din sawa, gabuat ta malaw-ay ta panan-aw ta Dyos, ganakaw, gatistigo ta dili matuod daw gambal ta dili matuod parti ta duma. ");
INSERT INTO cgc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tenged ta iling tan na mga buat, mga ittaw an bilangen na ‘dili-limpyo’. Piro, daw mga ittaw an maan na ula gasunod ta sirimunya ta pag-ugas ta lima, dili danen an bilangen na ‘dili-limpyo’.” ");
INSERT INTO cgc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Galin Jesus i ta Genesaret daw giling ta lugar na dani ta mga banwa na Tiro daw Sidon. ");
INSERT INTO cgc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","May isya na bai na Canaanen na gaistar dya na giling ki Jesus daw gapakiluoy na bakod iya na kagi, “Ginuo! Apo Ari David! Maluoy ka ki yaken! Ake na bata na bai naseddepan ta malain na ispiritu daw nabellayan gid!” ");
INSERT INTO cgc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piro, ula gasabat Jesus i. Gaprani iya na mga tinudluan ki kanen daw sigi gid ambal, “Palinen no bai na yan tak sikad sagbak daw gasunod-sunod ki kiten.” ");
INSERT INTO cgc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sabat Jesus ki danen, “Ula a labet ki kanen tak papadala a para nang ta mga linai Israel na paryo mga karniro na narwad.” ");
INSERT INTO cgc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Gaprani bai ya daw galuod naan ta atubangan Jesus daw mambal, “Ginuo, tabangan a no.” ");
INSERT INTO cgc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tenged bai ya dili-Judio, iling ti sabat Jesus, “Dili dapat na kamangen pagkaan an ta mga bata daw iatag naan ta mga ayam.” ");
INSERT INTO cgc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ambal ta bai, “Matuod nyan, Ginuo, piro bisan pa mga ayam gakaan man ta mummo na nulog alin ta lamisa ta iran na tag-iya.” ");
INSERT INTO cgc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sabat Jesus ta bai, “Manang, bakod gid imo na pagsalig! Imuon ko imo na pangabay.” Pagsabat din, nayad dayon bata ya. ");
INSERT INTO cgc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Galin Jesus i ta lugar na dani Tiro daw Sidon daw gaagi naan kilid ta Dagat Galilea. Gatukad kanen naan ta bungyod na dani ta dagat daw mungko. ");
INSERT INTO cgc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tama na mga ittaw giling ki kanen daw gadala ta mga piang, mga may dipirinsya ta batiis, bulag, apa daw duma pa gid na mga ittaw na may masakit. Paprani danen mga ittaw an na may masakit naan ta tubangan Jesus daw paayad din. ");
INSERT INTO cgc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gatingala gid tanan an na mga ittaw ta iran na nakita: mga apa kaambal en, mga may dipirinsya ta batiis nayad en, mga ittaw na piang kapanaw en ta usto daw mga bulag kakita en. Gadayaw danen an ta Dyos na patuuan ta mga linai Israel. ");
INSERT INTO cgc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Paumaw Jesus na marani ki kanen iya an na mga tinudluan daw ambal din ki danen, “Naluoy a ta mga ittaw na duma ki kiten tak tallo en adlaw na gakuyog danen i ki yaken daw anduni ubos en iran na balon. Dili ko gusto na paulien danen i na ula kakaan tak basi malipeng ta iran na pagpanaw.” ");
INSERT INTO cgc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gainsa iya na mga tinudluan, “Naan ta lugar na i na ula kabalayan indi ki magkamang ta tinapay na igo ta sikad i tama na mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Insa Jesus ki danen, “Pila buok na tinapay naan ki kyo?” Sabat danen, “Pitto daw pila buok man na derse na sidda.” ");
INSERT INTO cgc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Papungko Jesus mga ittaw an naan ta basak ");
INSERT INTO cgc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","daw pakamang din pitto an na tinapay daw sidda daw gapasalamat ta Dyos. Pabiak-biak din tinapay an daw patenga-tenga sidda daw paatag naan ta iya na mga tinudluan aged itagtag danen naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kakaan danen tanan daw nabusog. Patipon ta iya na mga tinudluan sama ya daw napanno danen pitto na baskit na darko. ");
INSERT INTO cgc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Katamaen ta mga kakaan appat libo na mama na ula labet ta bilang mga bai daw mga kabataan. ");
INSERT INTO cgc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Papauli Jesus mga ittaw ya daw gasakay kanen ta buti daw miling naan ta lugar na sakep ta banwa na Magadan. ");
INSERT INTO cgc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","May mga Pariseo daw Saduseo na gaprani ki Jesus tak liag danen na pamatuuran din daw indi gid alin iya na gaem. Papangitaan danen kanen an ta katingalaan na buat na alin ta Dyos aged may pamatuod na kanen an papadala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Piro, gambal Jesus ki danen, “Pagsalep ta adlaw, mambal kaw, ‘Dayad timpo i kisyem tak gaminog langit an.’ ");
INSERT INTO cgc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta sellem na magpawa-pawa, mambal kaw, ‘Maglain timpo i kani tak minog langit an daw tama item.’ Sagad kaw manilag ta mga nakita nyo naan ta kalangitan, piro dili nyo makamang daw ino beet ambalen ta mga natabo na pakita ta Dyos ta yi na timpo! ");
INSERT INTO cgc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mga ittaw ta yi na timpo malain daw gatalikod ta Dyos! Papangitaan a danen ta katingalaan na buat aged may pamatuod para ki danen na papadala a ta Dyos. Piro, ula duma na katingalaan na ipakita ki danen daw dili, katingalaan ya na natabo ki Jonas anay pa sa!” Pag-ambal Jesus, galin kanen ta mga Pariseo daw Saduseo daw miling ta duma na lugar. ");
INSERT INTO cgc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na kalakted en Jesus i daw iya na mga tinudluan naan ta liyo Dagat Galilea, nalipatan ta iya na mga tinudluan na magdala ta tinapay na balon. ");
INSERT INTO cgc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gambal kanen i ki danen, “Mag-andam kaw gid daw maglikaw ta pampaabok ta mga Pariseo daw Saduseo.” ");
INSERT INTO cgc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pag-ambal din, gaisturyaay mga tinudluan an, “Iling tan ambal din tak ula ki kadala ta tinapay na balon.” ");
INSERT INTO cgc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nlaman Jesus paisturya danen daw ambal din, “Tise gid inyo na pagsalig. Man-o tak gapalibeg kaw gid na ula kaw tinapay? ");
INSERT INTO cgc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ula nyo pa naintindii? Ino, ula nyo gid nademdemi nabuat ko ta limma ya na tinapay para ta subla limma libo na ittaw daw pila na mga baskit napanno nyo ya ta sama na patipon nyo? ");
INSERT INTO cgc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ula nyo man nademdemi pabuat ko ta pitto na tinapay para ta subla appat libo na ittaw daw pila na mga baskit napanno nyo ya ta sama na patipon nyo? ");
INSERT INTO cgc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Man-o tak ula nyo pa naintindii na dili parti ta tinapay beet ko ya ambalen? Ambalen ko isab, ‘Mag-andam kaw gid daw maglikaw ta pampaabok ta mga Pariseo daw Saduseo.’” ");
INSERT INTO cgc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dayon, naintindian en danen na ula kanen an gapaandam ki danen parti ta pampaabok na pagamit naan ta tinapay. Gapaandam kanen i parti ta dili matuod na patudlo ta mga Pariseo daw Saduseo na dapat na dili danen patian. ");
INSERT INTO cgc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na gabot Jesus i daw iya na mga tinudluan naan ta lugar na sakep ta banwa na Cesarea Filipos, gainsa kanen ki danen, “Kino kon ambal ta mga ittaw Yaken i Na Alin Ta Langit Na Natao Naan Ta Kalibutan?” ");
INSERT INTO cgc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sabat danen, “May mga ittaw na gambal na kaon kon yan Juan na manugbautismo. Duma ya a gambal na kaon kon Elias. Duma pa ya gambal na kaon kon Jeremias, daw duma pa gid ya gambal na kaon kon isya ta duma man na mga prupita na manugsugid ta kabebet-en ta Dyos anay pa sa.” ");
INSERT INTO cgc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Insa din pa, “Kyo a, ino maambal nyo daw kino yaken i?” ");
INSERT INTO cgc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sabat Simon Pedro, “Kaon yan Pinili Ta Dyos Na Mag-ari daw Bata ta Dyos na bui.” ");
INSERT INTO cgc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ambal Jesus ki kanen, “Simon na bata Jonas, may bakod ka na pribiliyo tak kamatuuran i na paambal no ula napaintindi ta ittaw ki kaon. Napaintindi ki kaon ta ake na Amay na naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ambalen ko man ki kaon na kaon Pedro na beet ambalen bato daw naan ta unay na bato na i itukod ko ake na balay na yon man tanan na mga ittaw na gatuo ki yaken daw bisan gamiten pa Satanas tanan din na gaem, dili din mapirdi danen an na gatuo ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iatag ko ki kaon uturidad an na alin ta Dyos aged magdumala ta mga ittaw na sakep ta iya na pagdumala na paryo paatag ki kaon yawi an na pangbukas ta iya na kaarian. Tenged ta uturidad na alin ta Dyos, daw ino na ibawal no unti ta kalibutan paagi ta imo na katengdanan, pabawal en ta Dyos. Daw ino itugot no unti ta kalibutan, patugot en ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pagtapos ta ambal Jesus ki Pedro, paambalan din gid danen an tanan na dili danen mugid ta bisan kino na kanen i Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Umpisa ta adlaw na nakala en ta mga tinudluan Jesus na kanen Pinili Ta Dyos Na Mag-ari, gasaysay kanen an ki danen na naan ta plano ta Dyos na kanen an miling ta Jerusalem daw naan dya maagian din tama na malain na buaten ta mga gadumala ta mga Judio, mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises. Patayen kanen i, piro bannawen ta Dyos naan ta pangallo na adlaw. ");
INSERT INTO cgc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagmati Pedro ta ambal Jesus, padala din Jesus an daw gapadyo danen ta iran na mga duma aged ambalan din na dili kanen an kumpurmi ta ambal ya Jesus. Ambal din, “Ginuo, dili magtugot Dyos an! Impusibli na iling an tan matabo ki kaon!” ");
INSERT INTO cgc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gatubang Jesus ki Pedro daw mambal, “Layas ka di, Satanas! Paryo na kaon magpegeng ki yaken ta pagsunod ta kabebet-en ta Dyos tak naan ta imo na isip pagbeet nang ta ittaw, dili pagbeet ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gambal pa gid Jesus i ta iya na mga tinudluan, “Daw kino miag na kanen isya man na tinudluan ko, dapat dili iya en na liag masunod daw dapat man na isipen din na paryo kanen an ta isya na ittaw na gapas-an ta iya na krus tenged iling tan buaten ta ittaw na magsunod ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kinanglan na buaten iling an tan tak daw kino gapalabi ta iya na kabui, mapatay man gyapon. Piro, bisan kino na mag-alad ta iya na kabui tenged ki yaken, maangken din kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Daw may ittaw na maangken din tanan na manggad naan ta kalibutan i piro dili din malikawan silot na ula katapusan naan ta impirno, ula man gyapon pulos tanan na naangken din. Ula gid betang na pwidi iatag aged balyo ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yaken Na Alin Ta Langit Na Natao Naan Ta Kalibutan malik duma ta ake na mga angil daw makita sikad silaw na pawa na naan ki yaken na paryo man ta pawa na naan ta ake na Amay. Ta pagbalik ko, kada isya na ittaw tagan ko ta bales dipindi daw ino nabuat danen. ");
INSERT INTO cgc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sigurado gid na iling tan naan ta ake na pagbalik daw sugiran ta kyo na may anen di ki kyo na bag-o danen mapatay makita danen Yaken Na Alin Ta Langit Na Natao Naan Ta Kalibutan na mabot aged mag-umpisa ta ake na pagdumala.” ");
INSERT INTO cgc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Paglambay ta annem na adlaw alin ta pag-ambal Pedro parti daw kino Jesus i, danen nang Pedro daw mag-utod na Santiago daw Juan pakuyog Jesus na miling naan ta datas na bukid. ");
INSERT INTO cgc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na naan dya, nakita danen Pedro na gaisab sura Jesus na gapawa sura din an na paryo ta adlaw daw iya na bayo sikad gid puti na sikad silaw. ");
INSERT INTO cgc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nali nang, Moises daw Elias gapakita ki danen daw gasugranen ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Gambal Pedro i ki Jesus, “Ginuo, miad gid man na naan ki di. Daw liag no, magbuat a ta tallo na pasilungan di. Isya para ki kaon, isya para ki Moises daw isya man para ki Elias.” ");
INSERT INTO cgc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na gambal pa Pedro i, nali nang may panganod na sikad pawa na galekkep ki danen tanan. May namatian na gambal na naan ta panganod, “Yi ake na bata na palangga ko. Nalipay a gid ki kanen. Mamati kaw ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagmati danen Pedro ta ambal ya na alin ta panganod, galuod na galeeb danen an tak sikad gid adlek danen. ");
INSERT INTO cgc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Piro, papranian Jesus danen an daw patandeg. Ambal din, “Mangon kaw! Dili kaw madlek.” ");
INSERT INTO cgc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pag-angad danen, ula danen duma na nakita daw dili, Jesus nang. ");
INSERT INTO cgc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na gategbeng Jesus daw danen Pedro alin ta bukid, paambalan din danen an, “Dili kaw mugid ta bisan kino parti ta nakita nyo naan ta bukid asta na bannawen ta Dyos Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan.” ");
INSERT INTO cgc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gainsa mga tinudluan ki kanen, “Man-o tak mga manugtudlo ta Mga Sinulat Moises gambal na kinanglan Elias ya muna anay mabot bag-o Pinili Ta Dyos Na Mag-ari?” ");
INSERT INTO cgc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sabat Jesus, “Matuod iran an na patudlo na Elias ya muna anay mabot aged kanen magpriparar ta tanan para ta pag-abot ta Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sugiran ta kyo na mama ya na paryo ki Elias abot en, piro ula pabatuna ta mga ittaw daw nabuat danen ki kanen daw ino na malain na liag danen na buaten. Iling man tan, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan buatan man danen ta malain.” ");
INSERT INTO cgc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pag-ambal Jesus, naintindian ta mga tinudluan din na Elias na pasambit din beet ambalen Juan na manugbautismo. ");
INSERT INTO cgc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na naan en Jesus i daw danen Pedro ta ebes ta bukid, kabalik danen naan ta tama na mga ittaw na gatipon dya. May mama na gaprani ki Jesus daw magluod naan ta atubangan din. ");
INSERT INTO cgc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Gambal mama an, “Ginuo, maluoy ka ta ake na bata na mama tak kuyapen kanen an daw segeng gid na sakit iya na pamatyag daw kanen abuton. Pirmi nang kanen natumba naan ta apoy daw naan ta waig. ");
INSERT INTO cgc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Padala ko kanen ta imo na mga tinudluan, piro ula danen napaayad.” ");
INSERT INTO cgc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Gambal Jesus i, “E-hey! Kyo na mga ittaw ta yi na timpo, ula kaw gasalig ta Dyos! Malain kaw daw sutil! Asta kan-o a pa na magduma ki kyo daw magsakripisyo bag-o kaw magsalig ta Dyos? Dleen nyo di bata an ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na naan en ki kanen bata an, paambalan din malain ya na ispiritu na mwa. Gagwa malain ya na ispiritu daw nayad dayon bata an. ");
INSERT INTO cgc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mga tinudluan Jesus gaprani ki kanen daw gainsa na danen nang, “Man-o tak dili kay kapagwa ta malain na ispiritu naan ta bata an?” ");
INSERT INTO cgc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sabat Jesus, “Ula nyo napagwa malain ya na ispiritu tenged kulang gid inyo na pagsalig, piro gambal a ki kyo na bisan inyo na pagsalig ta Dyos tise nang na paryas katise ta binni na mustasa, sarang kaw mambal ta yi na bukid, ‘Malyo ka unso,’ bukid i magsalyo. Tanan sarang nyo na mabuat. ");
INSERT INTO cgc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Piro, ta iling sa na klasi ta malain na ispiritu impusibli na mapagwa nyo daw dili kaw anay mangamuyo daw magpwasa.” ");
INSERT INTO cgc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na gatipon Jesus i daw iya na mga tinudluan naan ta Galilea, gambal kanen ki danen, “Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan dali nang en intriga naan ta mga gakuntra ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Patayen danen kanen i, piro ta pangallo na adlaw bannawen ta Dyos.” Tenged ta iya na ambal, nasebean gid ta miad iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na gabot Jesus i daw iya na mga tinudluan naan ta banwa Capernaum, may mga manugsukot ta buis para ta Timplo na gaprani ki Pedro daw gainsa, “Gabayad man ta buis inyo na mistro para ta supurta ta Timplo?” ");
INSERT INTO cgc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sabat Pedro, “Ee.” Gaselled Pedro naan ta balay daw mambal inta en kanen an tenged ta insa ta mga manugsukot, piro naunaan en kanen an Jesus, “Ino ta imo, Simon? Kino dapat magbayad ta buis naan ta mga ari ta kalibutan i? Mga sakep ta ari? Duma na mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sabat Pedro, “Duma na mga ittaw.” Ambal Jesus, “Ta, di libri en mga sakep ta ari? ");
INSERT INTO cgc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Piro, daw dili ki magbayad, basi magilek ki kiten mga manugsukot an ta buis para ta Timplo. Miling ka ta dagat daw mangawil. Una na sidda na masubbad no, pangangaen no. May makita ka naan ta iya na baba na sinsilyo na igo bayad ta buis ta darwa na ittaw. Mangen no daw ibayad para ta ate na buis.” ");
INSERT INTO cgc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ta yon man na uras na gaisturyaay Jesus i daw Pedro parti ta buis, duma na mga tinudluan Jesus gaprani daw gainsa ki Jesus, “Ginuo, kino may pinakadatas na katengdanan naan ta pagdumala ta Dyos?” ");
INSERT INTO cgc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ta iya na sabat, paumaw din na marani isya na bata na naan dya daw papatindeg din naan ta tengnga ");
INSERT INTO cgc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","daw ambal din, “Gaandem kaw gid ta datas na katengdanan, piro gambal a ki kyo na daw dili nyo bag-uon inyo na kaugalingen na mapainebesen kaw paryo ta mga bata, impusibli na makalabet kaw naan ta mga ittaw na padumalaan ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bisan kino na bag-uon din iya na kaugalingen aged mapainebesen kanen an paryo ta yi na bata, kanen an may pinakadatas na katengdanan naan ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Daw kino ki kyo na tenged ki yaken magbaton ta bisan isya na paryo ta yi na bata, paryas man na yaken pabaton nyo.” ");
INSERT INTO cgc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gambal pa Jesus i naan ta iya na mga tinudluan, “Daw kino na kanen tenaan na makasala bisan isya nang ta kebes ko na mga tinudluan na gapati ki yaken, mas miad pa daw tabiran iya na lieg ta bakod na galingan na bato daw ulog naan ta laod aged malemmes. ");
INSERT INTO cgc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kaluluoy mga ittaw tak tama tenaan na matintar danen na makasala. Impusibli na malikawan mga tintar, piro segeng gid na silot maageman ta bisan kino na kanen tenaan na duma na ittaw nakasala. ");
INSERT INTO cgc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Daw imo na lima tenaan na nakasala ka, dapat uturon no daw pilak. Iling man tan batiis no an. Mas miad pa na ungkol ka piro paselleren ka naan ta langit na mabui ta ula katapusan kaysa darwa imo na lima daw darwa imo na batiis, piro pilak ka naan ta impirno na apoy an na naan dya dili mapatay. ");
INSERT INTO cgc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Daw imo na mata tenaan na nakasala ka, dapat lukaten no daw pilak. Mas miad pa na isya nang imo na mata piro paselleren ka naan ta langit na mabui ta ula katapusan kaysa darwa imo na mata, piro pilak ka naan ta apoy ta impirno.” ");
INSERT INTO cgc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Gambal pa Jesus i, “Dili nyo saligaan bisan isya ta ake na mga tinudluan. Sugiran ta kyo na mga angil naan ta langit na pirmi naan ta atubangan ta ake na Amay na naan ta langit gabantay ki danen daw gapriparar gid en na mangabay ta Dyos para ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Yi tuyo na giling di Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan aged ngitaen daw luwasen mga ittaw na kasala para dili danen maageman ula katapusan na silot ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ino ta inyo na isip? Daw isya na ittaw may isya gatos na karniro, piro isya ya na karniro gapanaw madyo na ta uryan narwad, ino buaten ta tag-iya? Di' ba bilin din anay nubintay-nuibi an na karniro na gaalab naan ta bungyod daw ngitaen narwad ya? ");
INSERT INTO cgc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sigurado gid na ngitaen din daw sugiran ta kyo na daw matabo na makita din en, mas bakod pa gid iya na kalipay tenged ta karniro na nakita din kaysa ta nubintay-nuibi na ula narwad. ");
INSERT INTO cgc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iling man tan ate an na Amay na naan ta langit, dili kanen an miag na maageman ta bisan isya ta ake na mga tinudluan silot na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gambal pa Jesus i, “Daw imo na utod ta pagtuo kasala ki kaon, ilingan no kanen an daw ambalan no parti ta iya na nabuat na sala. Ta imo na pag-ambal ki kanen, kyo nang darwa mag-isturyaay. Daw batunon din imo na ambal, mabalik inyo an na pagmiaray na mag-utod ta pagtuo. ");
INSERT INTO cgc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piro, daw dili din batunon, magdala ka ta isya na utod nyo ta pagtuo, daw pwidi man darwa, daw malik ki kanen aged inyo na pag-isturya may tistigo tak ‘paagi ta darwa o tallo na tistigo mapamatuuran bisan ino na naisturyaan.’ ");
INSERT INTO cgc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Daw dili din pa gid batunon imo na ambal, isugid no ta mga gatuo naan ta iran na pagtipon. Daw dili din man gyapon batunon, kabigen nyo nang en kanen an na isya ta mga ula gapati ta Dyos daw ta mga malain na manugsukot ta buis. ");
INSERT INTO cgc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Dapat gid na iling tan buaten nyo ki kanen. Sugiran ta kyo na daw ino na ibawal nyo unti ta kalibutan paagi ta inyo na katengdanan, pabawal en ta Dyos. Daw ino itugot nyo unti ta kalibutan, patugot en ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Isab, sugiran ta kyo daw darwa kaw gaisya ta isip parti ta bisan ino na inyo na pangayo naan ta ake na Amay naan ta langit, imuon din para ki kyo ");
INSERT INTO cgc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","tak daw darwa o subla pa darwa na mga ittaw gatipon tenged danen an sakep ki yaken, anen a man dya na duma ki danen.” ");
INSERT INTO cgc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Gaprani Pedro i ki Jesus daw gainsa, “Ginuo, daw isya na utod ko ta pagtuo pirmi kasala ki yaken, pila gid bisis patawaren ko kanen an? Asta ta pitto bisis?” ");
INSERT INTO cgc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sabat Jesus, “Dili nang asta ta pitto bisis. Dapat asta ta sitintay-syiti bisis. ");
INSERT INTO cgc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iling tan dapat buaten no tak pagdumala an ta Dyos paryo ta natabo daw liag ta isya na ari na ayuson din utang an ta mga ittawan din naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na gaumpisa en kanen ta pagsuma, padala naan ki kanen ittaw an na may utang na dyis mil na sinsilyo na pilak na may bakod gid na balor. ");
INSERT INTO cgc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tenged ittaw an dili kabayad ta utang, pasugo ta ari na bligya kanen an daw sawa din daw mga bata daw bligya man tanan din na pagkabetang aged mabayaran din iya na utang. ");
INSERT INTO cgc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pagmati din ta sugo ta ari, gadapa kanen an naan ta batiisan ta ari daw gambal, ‘O maal na ari, pasinsyaen a no nang anay tak magbayad a gid ta tanan nyan ki kaon.’ ");
INSERT INTO cgc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Natandeg gid tagipusuon ta ari daw papatawad din ittaw an daw ula en pabayara pa ta iya na utang. ");
INSERT INTO cgc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Paggwa ta ittaw an, nasugat din isya man na ittawan ta ari. Paryas din ya na ittawan may utang ki kanen na isya gatos na sinsilyo na pilak. Papranian din daw paluab daw kegaen. Ambal din, ‘Bayaran a no ta imo na utang ki yaken!’ ");
INSERT INTO cgc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Galuod kautang ki kanen daw gapakiluoy, ‘Pasinsyaen a no nang anay tak magbayad a gid ki kaon!’ ");
INSERT INTO cgc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piro, dili kanen miag. Papapriso din kautang ya ki kanen asta na kabayad ta utang. ");
INSERT INTO cgc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Na nakita ta duma na mga ittawan ta ari pabuat ya ta ittaw na patawad ta ari, galain gid iran na nakem daw giling danen an naan ta ari aged mugid. ");
INSERT INTO cgc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pagmati ta ari ta iran na sugid, paumaw din ittaw an na patawad din ta bakod na utang daw pambalan, ‘Malain ka na ittaw! Ula ta kaw pabayara ta imo na utang tak gapakiluoy ka. ");
INSERT INTO cgc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Inta naluoy ka man ta paryas no na ittawan ko na paryo ta ake na kaluoy ki kaon.’ ");
INSERT INTO cgc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tenged ta kagilek ta ari, paintriga din ittaw ya naan ta manugpriso asta na kabayad ta tanan na utang.” ");
INSERT INTO cgc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pagtapos Jesus ta isturya ta paanggid, ambal din pa, “Iling man tan buaten ki kyo ta ake na Amay na naan ta langit daw dili nyo patawaren na terek ta inyo na tagipusuon inyo an na utod ta pagtuo.” ");
INSERT INTO cgc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagtapos Jesus ta iya na pagtudlo parti ta pagpatawad, galin kanen i ta Galilea daw miling ta prubinsya Judea na gaagi naan dapit ta sennangngan ta Suba Jordan. ");
INSERT INTO cgc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Naan dya sikad tama na mga ittaw gasunod ki kanen daw paayad din danen an ta iran na masakit. ");
INSERT INTO cgc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","May mga Pariseo na giling ki Jesus aged dakep-dakepen kanen an paagi ta insa para maakusaran daw may ambalen kanen an na kuntra ta Mga Sinulat Moises. Gainsa danen ki kanen, “Ino ta imo na isip? Naan ta Mga Sinulat Moises patugot na mga mama magbelag ta iran na sawa ta bisan ino nang na tenaan?” ");
INSERT INTO cgc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sabat Jesus, “Sigurado na nabasa nyo en daw nlaman nyo na ta una gid na timpo ‘pabuat ta Dyos mga ittaw na danen mama daw bai,’ ");
INSERT INTO cgc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","daw ambal ta Dyos, ‘Yon tenaan na mama malin ta pudir ta iya na amay daw inay tak kanen daw iya na sawa magdumaay na danen na darwa mimo na isya.’ ");
INSERT INTO cgc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gani, mama daw bai na magsawa dili en darwa. Danen isya nang en. Tenged paisya ta Dyos mama an daw bai, kuntra ta pagbeet din na belagen danen an ta bisan kino.” ");
INSERT INTO cgc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mga Pariseo an gainsa pa ki Jesus, “Man-o tak gasugo Moises anay pa sa na mga mama magbuat anay ta kasulatan ta pagbelag bag-o danen belagan iran na sawa?” ");
INSERT INTO cgc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sabat din, “Tenged dessen inyo na ulo patugutan kaw Moises na belagan nyo inyo an na sawa, piro alin pa ta una dili plano ta Dyos na mga magsawa an magbelagay. ");
INSERT INTO cgc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Gambal a ki kyo na daw bisan kino na mama na belagan din iya an na sawa na ula man gaintra ta mama daw mangasawa kanen isab ta duma na bai, kasala kanen an tak paryas man gyapon na kanen an gaintra ta bai.” ");
INSERT INTO cgc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mga tinudluan Jesus gambal ki kanen, “Daw iling tan sitwasyon daw may sawa ka, mas miad pa na dili nang en mangasawa.” ");
INSERT INTO cgc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sabat din, “Ambal nyo an dili mabaton ta tanan. Mabaton nang ta mga ittaw na kaya danen na dili mangasawa paagi ta tabang ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","May mga mama na dili mangasawa tenged natao na may dipirinsya ta lawa, duma an tenged ta buat naan ta iran na lawa, daw duma pa gid an tenged palabi danen iran na pagsirbi ta Dyos. Gani, daw mabaton nyo na dili kaw mangasawa, dili kaw nang en mangasawa.” ");
INSERT INTO cgc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","May mga bata na padala naan ki Jesus aged itungtong din iya an na lima ki danen daw pangamuyuan danen an. Piro, pasaway ta iya na mga tinudluan mga gadala ya. ");
INSERT INTO cgc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gambal kanen i, “Bay-an nyo nang mga bata an na magprani ki yaken. Dili nyo danen an pegengan tak mga paryo ki danen sakep ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pag-ambal din, patungtong din iya an na lima naan ki danen daw pangamuyuan danen an. Pagtapos din ta pangamuyo, galin kanen dya. ");
INSERT INTO cgc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","May gaprani ki Jesus na batan-en na mama. Gainsa mama an, “Mistro, ino dapat ko na buaten na miad aged maangken kabui na ula katapusan?” ");
INSERT INTO cgc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sabat Jesus, “Man-o tak yaken painsaan no parti daw ino miad? Isya nang gid miad! Dyos nang! Daw liag no na maangken kabui an na ula katapusan, tumanen no mga sugo an na paatag ta Dyos paagi ki Moises.” ");
INSERT INTO cgc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gainsa eman mama an, “Indi sa na mga sugo?” Sabat Jesus, “Sugo ta Dyos na, ‘Dili ka magpatay, dili ka mag-intra ta bai, dili ka manakaw, dili ka magtistigo ta dili matuod ");
INSERT INTO cgc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","daw tauron no imo na amay daw inay.’ Sugo man ta Dyos, ‘Gugmaen no duma na mga ittaw paryo man ta paggugma no ta imo na kaugalingen.’” ");
INSERT INTO cgc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sabat ta mama, “Tanan na sugo na pasambit no patuman ko. Ino pa kulang na ula ko pa nabuat?” ");
INSERT INTO cgc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ambal Jesus, “Daw liag no na ula ka kulang ta imo na pagtuman ta kabebet-en ta Dyos, muli ka daw bligya no imo na mga pagkabetang daw bayad an iatag no ta mga imol tak sigurado maangken no dayad na bales na patagana ta Dyos naan ta langit. Daw matuman no en ambal ko, malik ka daw muyog ki yaken aged isya ka man na tinudluan ko.” ");
INSERT INTO cgc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagmati ta mama ta ambal ya Jesus, gapanaw kanen an na nasebean tak tama gid iya na mga pagkabetang. ");
INSERT INTO cgc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ambal Jesus naan ta iya na mga tinudluan, “Iling gid tan batyagen ta ittaw na tama iya na pagkabetang daw sugiran ta kyo na mga ittaw na manggaranen bellay gid magpasakep naan ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yon man, mas dali pa ta bakod na ayep na kamilyo meddep naan ta lungag ta dagem kaysa ittaw na manggaranen magpasakep naan ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagmati ta mga tinudluan ta iya na ambal, gatingala gid danen an daw gambal, “Ta, daw iling tan na bellay para ta mga manggaranen, impusibli na may maluwas alin ta silot ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Patan-aw Jesus danen an daw ambal din, “Impusibli ta ittaw, piro tanan mabuat ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tenged ta ambal ya Jesus, gambal Pedro i, “Ta, kami a? Padilian nay tanan aged muyog ki kaon. Ino mabaton nay alin ta Dyos?” ");
INSERT INTO cgc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ambal Jesus ki danen, “Matuod na padilian nyo tanan. Piro, gambal a ki kyo na mabot adlaw na bag-uon ta Dyos yi na kalibutan daw Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mungko naan ta iya na truno aged mag-ari. Kyo man na mga tinudluan ko, mungko kaw naan ta dusi na truno aged magdumala kaw ta mga ittaw na linai ta dusi na bata Israel. ");
INSERT INTO cgc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Piro dili nang nyan, may anen pa man na dayad na bales na alin ta Dyos para ta bisan kino na padilian din iya na balay, mga utod, amay daw inay, mga bata daw mga basak aged munod ki yaken tak mas tama pa gid iya na mabaton kaysa ta iya na padilian daw may kabui man na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tama anduni na may datas na katengdanan na ta uryan magbaba daw tama man anduni na may baba na katengdanan na ta uryan magdatas.” ");
INSERT INTO cgc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gaisturya Jesus i ta paanggid naan ta iya na mga tinudluan, “Pagdumala an ta Dyos paryo ta pabuat ta isya na tag-iya ta basak na sellem pa gid gapanaw na mangita ta mga ittaw na suulan na mag-ubra naan ta iya na taneman ta ubas. ");
INSERT INTO cgc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na may nakita kanen na mga ittaw na mag-ubra, gasugtanay danen an ta usto na suol na isya na sinsilyo na pilak para ta isya na adlaw na ubra daw papailing din danen an naan ta iya na taneman ta ubas. ");
INSERT INTO cgc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Paglambay ta tallo uras alin ta pagsennang ta adlaw, tag-iya i ta ubasan gapanaw isab daw may nakita kanen naan ta palingki na mga gaistambay na ula ubra. ");
INSERT INTO cgc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gambal kanen ki danen, ‘Miling kaw man naan ta ake na ubasan na mubra tak tagan ta kyo ta usto na suol.’ ");
INSERT INTO cgc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yon en gapanaw danen daw mubra dya. Iling man tan gyapon pabuat ta tag-iya pag-abot ta ugto-adlaw daw naan ta mapon man. ");
INSERT INTO cgc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Na mapon gid en, giling eman kanen an naan ta palingki daw may nakita pa gid kanen an dya na mga gaistambay. Gainsa kanen an ki danen, ‘Man-o tak pasayangan nyo nang bilog i na adlaw?’ ");
INSERT INTO cgc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sabat danen, ‘Ta, mino kay abi na ula man may mag-atag ki kami ta ubra?’ Ambal din ki danen, ‘Miling kaw man ta ake na ubasan daw mubra.’ ");
INSERT INTO cgc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Na semsem en, pasugo ta tag-iya kapatas din an na umawen mga gaubra ya daw suulan umpisa ta mga uryan ya na gaubra asta ta una. ");
INSERT INTO cgc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mga uryan ya na gaubra pasuulan ta usto na suol para ta isya na adlaw. ");
INSERT INTO cgc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na nlaman ta mga una na gaubra daw ino suol ya na paatag naan ta mga uryan na gaubra, gasalig danen an na mas bakod iran an na mabaton. Piro, isya-isya ki danen patagan ta suol na paryo man ta mga uryan nang ya na gaubra. ");
INSERT INTO cgc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagbaton danen ta iran na suol, gariklamo danen an naan ta tag-iya, ");
INSERT INTO cgc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Yi na mga ittaw gaubra nang ta isya uras, piro paparyo no iran na suol ta ame bisan kami gaubra ta bilog na adlaw naan ta sikad dangga.’ ");
INSERT INTO cgc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sabat ta tag-iya an naan ta isya ki danen na gariklamo, ‘Dey, ula a gadaya ki kaon. Di' ba gasugtanay ki ta usto na suol para ta isya na adlaw? ");
INSERT INTO cgc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Batunon no imo an na suol daw manaw ka en. Ake na liag na suulan mga uryan an paryo man ta imo na suol. ");
INSERT INTO cgc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ara, pagusto a daw inuon ko ake i na kwarta. Ino, inggit ka tak miad a?’” ");
INSERT INTO cgc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pagtapos Jesus isturya ta paanggid, ambal din naan ta iya na mga tinudluan, “Paryo man tan, mga may baba na katengdanan anduni, ta uryan magdatas daw mga may datas na katengdanan anduni, ta uryan magbaba.” ");
INSERT INTO cgc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ta pag-iling Jesus daw mga gakuyog ki kanen naan ta Jerusalem, abot adlaw na paprani Jesus dusi an na apustulis naan ki kanen daw papadyo alin ta duma na mga ittaw aged isturyaen din na danen nang. Gambal kanen i ki danen, ");
INSERT INTO cgc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Matian nyo gid ambalen ko i ki kyo. Gapanaw ki na munta en naan ta Jerusalem daw naan dya Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan intriga naan ta mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises. Sintinsyaan kanen i ta kamatayen ");
INSERT INTO cgc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","daw intriga naan ta mga dili-Judio aged pagayyaan, latiguon, daw silutan ta kamatayen naan ta krus, piro ta pangallo na adlaw bannawen kanen i ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Inay danen Santiago daw Juan na mga kabataan Zebedeo gaprani ki Jesus na pakuyog din darwa din an na bata. Galuod kanen na gadapa tak may ipangabay ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus i gainsa ki kanen, “Manang, ino liag no?” Sabat din, “Gapangabay a na naan ta adlaw na papungkuon ka na mag-ari, tagan no ta pabor darwa ko an na bata na mungko danen naan ta kilid no na isya an naan dapit ta tuo daw isya an a, naan dapit ta wala.” ");
INSERT INTO cgc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ambal Jesus ki danen, “Ula nyo nlami daw ino inyo an na papangabay. Masarangan nyo taan na maagian ake an na maagian na segeng na kabellay?” Sabat danen, “Ee, masarangan nay.” ");
INSERT INTO cgc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ambal Jesus, “Maagian nyo matuod segeng na kabellay na maagian ko. Piro, dili yaken magpili daw kino mungko naan dapit ta tuo daw wala ta kilid ko tak para nang ta mga ittaw na pataganaan ta ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na namatian ta sampulo na apustulis parti ta pangabay ya ki Jesus, gagilek gid danen an naan ta darwa na mag-utod. ");
INSERT INTO cgc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Paumaw Jesus na marani danen an tanan daw ambal din, “Nlaman nyo na mga gadumala naan ta mga dili-Judio gaabuso ta iran na pagdumala daw iling man tan mga dili-Judio na may datas na katengdanan ta iran na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piro, dapat dili kaw iling tan tak daw kino ki kyo na liag din na datas iya na katengdanan naan ki kyo na ake na mga tinudluan, dapat na kanen an magsirbi ki kyo na iya na mga duma na paryo kanen inyo na manugsirbi. ");
INSERT INTO cgc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Daw kino man ki kyo na gaandem na magpanguna ki kyo na ake na mga tinudluan, dapat na kanen an magsirbi ki kyo na iya na mga duma na paryo kanen inyo na suguon ");
INSERT INTO cgc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","tak dapat paryo kaw ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. Tuyo din ta pag-iling di ta kalibutan i dili para sirbian ta mga ittaw. Giling di kanen para magsirbi ta duma daw mag-atag man ta iya na kabui para matubos tama na mga ittaw alin ta silot ta iran na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ta pag-iling Jesus daw iya na mga tinudluan naan ta Jerusalem, naagian danen syudad na Jerico. Na galin danen ta Jerico, tama na mga ittaw gasunod ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nalambayan danen darwa na bulag na gamungko naan ta kilid dalan. Na nlaman ta darwa na bulag na Jesus i gaagi dya, gasinggit danen an ki kanen, “Ginuo! Apo Ari David! Maluoy ka ki kami!” ");
INSERT INTO cgc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pasaway ta mga ittaw danen an na dili magsagbak. Piro, gasinggit pa gid danen an ta tudo, “Ginuo! Apo Ari David! Maluoy ka ki kami!” ");
INSERT INTO cgc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gateneng Jesus i daw paumaw din danen an daw ambal din, “Sugiran a nyo daw ino liag nyo buaten ko para ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ambal danen, “Ginuo, liag nay na makakita!” ");
INSERT INTO cgc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naluoy gid Jesus i ki danen daw patandeg din iran an na mata. Dayon kakita danen an daw gakuyog ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na dani nang en ta Jerusalem Jesus i daw mga gakuyog ki kanen, kabot danen ta baryo na Betfage naan ta Bukid Olibo. Pasugo din darwa ta iya na mga tinudluan ");
INSERT INTO cgc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na ambal din, “Miling kaw ta baryo na naan ta unaan. Pagselled nyo dya, makita nyo dayon isya na asno na naigot na naan man dya iya na bata. Badbaren nyo igot an daw dleen nyo mga asno an ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Daw may ittaw na mag-insa ki kyo, sabaten nyo, ‘Kinanglan ta Ginuo mga asno i.’ Daw iling tan sabat nyo ki kanen, tugutan kaw din na dleen nyo mga asno an.” ");
INSERT INTO cgc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Natabo iling sa aged matuman ambal ta Dyos anay pa sa paagi ta isya na prupita na manugsugid ta iya na kabebet-en. Ambal din, ");
INSERT INTO cgc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sugiran nyo mga ittaw ta syudad Sion, ‘Anduni inyo na Ari mabot en ki kyo. Ula kanen gabugal. Gasakay nang kanen an naan ta asno. Asno na pasakayan din bata pa.’” ");
INSERT INTO cgc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pagsugo Jesus ta darwa ya na tinudluan, gapanaw danen daw patuman sugo din ya ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Padala danen ki kanen inay daw bata na asno. Paapinan danen ta iran na mga bayo tudtod ta bata na asno daw gasakay Jesus i. ");
INSERT INTO cgc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pagsakay din, gapadayon kanen i daw mga gakuyog ki kanen na munta Jerusalem. Tama na mga ittaw gauna ki kanen na galadlad ta iran na mga bayo naan ta dalan na agian din daw duma man ya gatapas ta sanga ta mga tanem daw patagtag naan ta dalan aged ipakita iran na pagtaod ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mga ittaw na gauna ki Jesus daw duma na gasunod man gasinggit, “Dayawen ta Apo Ari David! Dayawen gabot an na papadala ta Ginuo Dyos! Dayawen ta Dyos an na naan ta langit!” ");
INSERT INTO cgc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na gaselled en Jesus i ta Jerusalem, naguluan mga ittaw ta bilog na syudad daw gainsaay, “Kino na ittaw nyan?” ");
INSERT INTO cgc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mga gakuyog ki Jesus gasabat, “Kanen Jesus na isya na prupita. Kanen taga-Nazaret na sakep ta Galilea!” ");
INSERT INTO cgc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Gaselled Jesus i ta sular ta Timplo daw papagwa din mga ittaw dya na gabligya daw mga gamalit ta mga pang-alad para ta Dyos. Patumba din mga lamisaan ta mga manugbalyo ta kwarta daw mga pungkuan ta mga gabligya ta salampati na pang-alad. ");
INSERT INTO cgc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pambalan din danen an, “Naan ta sinulat na pulong ta Dyos, kanen an gambal, ‘Ake na balay umawen na balay pangamuyuan.’” Ambal pa Jesus, “Piro, pabuat nyo iya na balay na ‘taguan ta mga manakaw’.” ");
INSERT INTO cgc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Naan ta Timplo may giling ki Jesus na mga bulag daw piang daw paayad din danen an. ");
INSERT INTO cgc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piro, mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises gagilek na nakita danen mga katingalaan an na pabuat din daw namatian danen mga kabataan an na gasinggit ta pagdayaw ki kanen naan ta Timplo, “Dayawen ta Apo Ari David!” ");
INSERT INTO cgc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ta kagilek ta mga pari an daw mga manugtudlo, gambal danen ki Jesus, “Ino, ula ka kamati ta pasinggit ta mga kabataan? Man-o tak ula no sawaya danen an!” Sabat din, “Simpri namatian ko. Paryo kaw inyo na ula kabasa naan ta sinulat na pulong ta Dyos ambal ya na, ‘Bisan mga derse na kabataan daw mga bata na gasuso nang pa patudluan na magdayaw ki kaon!’” ");
INSERT INTO cgc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pag-ambal Jesus, galin kanen i ki danen daw gagwa ta syudad na miling ta Betania daw naan dya kanen gadayon ta yon man na kilem. ");
INSERT INTO cgc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na adlaw en, gabalik Jesus i naan ta Jerusalem daw ta iya na pagpanaw kanen i nletem. ");
INSERT INTO cgc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nakita din isya na kaoy na igos na dani ta dalan. Papranian din, piro ula gid kanen may nakita na bunga, mga daon nang. Ambal din ta kaoy an na igos, “Umpisa anduni dili ka en mamunga!” Pag-ambal din, gakeseg dayon igos an. ");
INSERT INTO cgc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkita ta iya na mga tinudluan ta natabo ta igos an, gatingala gid danen an daw gambal, “Paino na gakeseg dayon igos an?” ");
INSERT INTO cgc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sabat Jesus, “Gakeseg igos an tenged gid ta ake na ambal daw sugiran ta kyo na daw gasalig kaw ta Dyos na ula gadua-dua, dili nang paryo ta ake na nabuat ta yi na igos mabuat nyo. Mabuat nyo mas pa ta nabuat ko. Daw mambal kaw ta yi na bukid, ‘Akwaten ka ta Dyos daw ilabyog naan ta dagat,’ matuman gid ambal nyo an. ");
INSERT INTO cgc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Daw gasalig kaw ta Dyos, bisan ino inyo na pangayuon paagi ta pangamuyo, mabaton nyo gid.” ");
INSERT INTO cgc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na naan en Jesus i ta Timplo na gatudlo, may mga manugdumala na mga pari daw mga gadumala ta mga Judio na gaprani ki kanen daw gainsa, “Indi alin imo na uturidad ta mga pabuat no naan ta Timplo i? Kino gaatag ki kaon ta imo na uturidad?” ");
INSERT INTO cgc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sabat din, “Minsa a anay ki kyo. Daw masabat a nyo, isugid ko daw indi alin ake na uturidad ta pagbuat ko ta iling sa naan ta Timplo i. ");
INSERT INTO cgc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yi ake na insa: Juan ya na manugbautismo, indi alin iya na uturidad ta pagbautismo din ta mga ittaw? Ino ta inyo na isip, naan alin ta Dyos, naan alin ta ittaw?” Gaisturyaay danen an daw ino iran na isabat. Ambal danen, “Daw sabaten ta, ‘naan alin ta Dyos,’ insaan ki din, ‘Man-o tak ula kaw gapati ki Juan?’ ");
INSERT INTO cgc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piro, daw sabaten ta, ‘naan alin ta ittaw,’ madlek ki tak basi mga ittaw di magbuat ta malain na kuntra ki kiten tenged pakala danen Juan ya na isya na prupita na alin ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tenged ula danen may isabat ki Jesus, ambal danen ki kanen, “Ula nay nlami.” Ambal din, “Dili ko man isugid ki kyo daw indi alin ake na uturidad ta mga pabuat ko naan ta Timplo i.” ");
INSERT INTO cgc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Gambal pa Jesus i naan ta mga manugdumala na mga pari daw mga gadumala ta mga Judio, “Ino ta inyo na isip daw may matabo na iling ti: May amay na darwa iya na bata na mama. Pasugo din magulang ya, ‘Tong, miling ka anduni naan ta taneman ta ubas daw mag-ubra dya.’ ");
INSERT INTO cgc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Sabat ta magulang, ‘Dili a miling dya!’ Piro, ta uryan gabag-o iya na isip daw giling dya. ");
INSERT INTO cgc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pasugo man ta amay mangngod ya paryas man ta sugo din naan ta magulang ya. Sabat ta mangngod, ‘Ee, Tay’, piro ula kanen an giling dya.” ");
INSERT INTO cgc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pagtapos Jesus ta isturya, gainsa kanen, “Kino ta darwa gatuman ta sugo ta iran na amay?” Sabat danen, “Magulang.” Ambal Jesus, “Igo sabat nyo an. Piro, gambal a ki kyo na mga manugsukot ta buis daw mga malain na bai una en gapasakep ta pagdumala ta Dyos kaysa ki kyo. ");
INSERT INTO cgc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan ya giling di daw gatudlo ki kyo parti ta paagi na magtuman ta liag ta Dyos, piro ula kaw gapati ki kanen. Mga manugsukot ta buis daw mga malain na bai, danen gapati. Bisan nakita nyo na gapati danen ki Juan, ula man gyapon gabag-o inyo an na isip na magpati ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Gambal pa gid Jesus i naan ta mga manugdumala na mga pari daw mga gadumala ta mga Judio, “Sugiran ta kyo ta isya pa na paanggid na isturya. May tag-iya na gatanem ta ubas naan ta iya na uma daw pakuralan din. Gakutkot man kanen ta lungag daw naan dya gabuat ta pegaan ta ubas. Gapatindeg man kanen ta turi na bantawan ta manugbantay. Tapos ta tanan din na ubra, papaagsa din ubasan ya daw miling naan ta madyo na lugar. ");
INSERT INTO cgc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na timpo en ta pagpupo ta mga ubas, papailing din pila na suguon din naan ta mga gaagsa ta ubasan aged kamangen iya na parti ta tubbas. ");
INSERT INTO cgc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Piro, pagabling ta mga gaagsa iya na mga suguon daw isya ya pabugbog, isya man ya papatay, daw isya pa gid ya patimbag danen ta bato asta na napatay. ");
INSERT INTO cgc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Papailing man ta tag-iya duma pa na mga suguon na mas tama kaysa ta una din na papailing. Piro, natabo man ki danen paryo ta natabo ya ta una na mga papailing din dya. ");
INSERT INTO cgc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ta uryan, papailing din iya an na bata na mama naan ta mga gaagsa tak ambal din ta iya na kaugalingen, ‘Sigurado na tratuon danen ta miad ake i na bata.’ ");
INSERT INTO cgc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piro, na nakita ta mga gaagsa bata ya ta tag-iya, gaisturyaay danen an, ‘Yon manubli ta uma na i. Sigi, patayen ta kanen an aged ate nang en panublien din an.’ ");
INSERT INTO cgc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pagtapos danen ta iran na pag-isturyaay, pagabling danen kanen an, payudyod pagwa naan ta ubasan daw papatay.” ");
INSERT INTO cgc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pagtapos Jesus ta isturya, painsaan din mga manugdumala an, “Ta, daw mabot tag-iya ya ta ubasan, ino buaten din ta mga gaagsa?” ");
INSERT INTO cgc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sabat danen, “Danen ya na mga malain na gaagsa patayen din gid na ula kaluoy daw paagsa din iya na ubasan naan ta duma na mga ittaw na mag-atag ki kanen ta iya na parti ta tubbas daw timpo en ta pagpupo.” ");
INSERT INTO cgc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ambal Jesus, “Igo nyan. Piro, paryo kaw inyo na ula kabasa ta ambal naan ta sinulat na pulong ta Dyos na iling ti, ‘Bato an na ta isip ta mga manug-ubra ta balay dili magamit, yon gid pamag-ang na bato. Yi tanan pagbeet ta Ginuo Dyos daw gatingala ki gid.’” ");
INSERT INTO cgc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ambal man Jesus, “Gani, sugiran ta kyo na kamangen ta Dyos alin ki kyo pribiliyo na sakep kaw ta iya na pagdumala daw iatag din naan ta mga ittaw na magtuman ta iya na mga sugo. ");
INSERT INTO cgc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Daw kino karagpa naan ta pamag-ang ya na bato, kanen an mawasak. Daw kino maulugan ta pamag-ang ya na bato, kanen an malegsek.” ");
INSERT INTO cgc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagmati ta mga manugdumala na mga pari daw mga Pariseo ta mga paanggid na isturya Jesus, naintindian danen na danen paisturya din naan ta iya na paanggid. ");
INSERT INTO cgc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Liag danen na dakepen inta kanen i. Piro, nadlek danen an na basi mga ittaw dya magbuat ta malain kuntra ki danen tak pakala ta mga ittaw na Jesus i prupita na alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gapadayon Jesus i ta iya na pagtudlo na gaisturya ta mga paanggid. ");
INSERT INTO cgc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ambal din, “Pagdumala an ta Dyos paryo ta natabo daw may ari na gaanda ta kumbira para ta kasal ta bata din na mama. ");
INSERT INTO cgc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Papailing din pila na mga suguon din na umawen mga paimbitar ya na mandegek en. Piro, mga paimbitar ya dili miag na miling dya. ");
INSERT INTO cgc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Papailing din duma pa na mga suguon daw ambal din ki danen, ‘Sugiran nyo mga paimbitar ya na imes en kumbira i. Naiyaw en papatambek na mga baka na patagana para ta kumbira. Tanan anda en. Miling en danen na mandegek!’ ");
INSERT INTO cgc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piro, ula man gyapon patubaya ta mga paimbitar. Duma ki danen giling naan ta iran na uma daw duma ya a naan ta iran na nigusyo. ");
INSERT INTO cgc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Duma pa ya, paabungan danen mga suguon na papailing ta ari daw pabugbog danen daw papatay. ");
INSERT INTO cgc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sikad gid gilek ta ari daw dayon papadala din iya na mga sundalo aged mga paimbitar ya na gapatay ta iya na mga suguon patayen daw sunugon iran na syudad. ");
INSERT INTO cgc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Gaumaw ari i ta duma pa gid na mga suguon din daw gambal ki danen, ‘Ake na kumbira anda en, piro mga naimbitar ko ya dili gid man danen an dapat na mag-atindir. ");
INSERT INTO cgc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Miling kaw ta mga karsada daw indi tama na mga ittaw daw imbitaren nyo tanan na mga ittaw na makita nyo dya.’ ");
INSERT INTO cgc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pag-ambal ta ari, gapanaw dayon mga suguon ya na miling ta mga karsada daw indi tama na mga ittaw daw padala danen tanan na mga ittaw na nakita danen maskin mga ittaw na malain daw mga ittaw na miad. Napanno ta mga bisita kumbiraan ya. ");
INSERT INTO cgc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Na gaselled ari i naan ta kumbiraan aged tan-awen mga gandegek ya, nakita din isya na mama na ula kasuot ta bayo na para ta mga naimbitar ta kasal. ");
INSERT INTO cgc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Painsaan kanen ta ari, ‘Dey, ino paagi na kaselled ka di na ula ka kasuot ta bayo na para ta mga naimbitar?’ Piro, ula gid kanen kasabat. ");
INSERT INTO cgc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pasugo ta ari iya na mga suguon, ‘Gapuson nyo iya na lima daw batiis daw ipagwa kanen an daw pilak naan ta sikad delem na lugar na naan dya mga ittaw gangagal ta tudo daw magbaggit ta iran na ngipen.’” ");
INSERT INTO cgc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Patapos Jesus iya na isturya paagi ta yi na ambal, “Tama mga paimbitar, piro pila nang papili na mandegek.” ");
INSERT INTO cgc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pagtapos Jesus ta pagtudlo paagi ta mga paanggid, galin mga Pariseo naan ki kanen daw gasapol danen an daw ino buaten danen aged madakep-dakep kanen i paagi ta mga insa. ");
INSERT INTO cgc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pagtapos ta sapol, may mga tinudluan danen daw mga ittaw na gasunod ki Herodes na papailing naan ki Jesus aged mag-insa. Ambal danen, “Mistro, nlaman nay na ula ka pagbula, gatudlo ka ta kamatuuran parti ta kabebet-en ta Dyos, daw ula ka may papaburan tak maskin kino pa na ittaw paryo nang imo na pagtratar ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sugiran kay no tuo. Ta imo na isip, naan ta Mga Sinulat Moises patugutan ki na magbayad ta buis naan ta pangulo ta Roma?” ");
INSERT INTO cgc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Piro, nlaman Jesus na malain iran na tuyo daw ambal din, “Gapakuno-kuno kaw nang na inyo na pag-insa terek ta inyo na nakem! Liag nyo nang na dakep-dakepen a paagi ta ake na sabat! ");
INSERT INTO cgc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dawatan a nyo ta isya na sinsilyo na paryo ta pabayad nyo ta buis.” Padawat danen isya na sinsilyo na paryo ta iya na paayo. ");
INSERT INTO cgc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Gainsa kanen i ki danen, “Iya ti na sura daw ngaran naan ta yi na sinsilyo?” ");
INSERT INTO cgc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sabat danen, “Iya ta pangulo ta Roma.” Ambal din, “Ta, daw ino iya ta pangulo ta Roma, iatag nyo ki kanen. Daw ino iya ta Dyos, iatag nyo ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagmati ta mga pangulo ta mga Judio ta iya na ambal, gatingala gid danen an daw gapanaw dayon. ");
INSERT INTO cgc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta yon man na adlaw na Jesus an painsaan parti ta pagbayad ta buis, may mga Saduseo na giling ki kanen aged dakep-dakepen kanen an paagi ta insa parti ta pagbannaw tak ula danen an gapati na mabannaw mga patay an. ");
INSERT INTO cgc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ambal danen ki kanen, “Mistro, ambal Moises naan ta iya na sinulat na daw mama na may sawa mapatay na ula kanen bata ta iya na sawa, dapat paus-os katengdanan din naan ta iya na mangngod aged makabata para ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Alimbawa, may anen di ki kami pitto na mag-utod na mama. Kamagulangan ya nangasawa daw napatay na ula danen an bata. Nabalo ya pasawa ta pangarwa na utod. ");
INSERT INTO cgc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pangarwa ya na utod napatay man na ula danen an bata. Iling man tan natabo ta pangallo asta ta pangpitto na utod. ");
INSERT INTO cgc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ta uryan, bai ya napatay man. ");
INSERT INTO cgc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ta, daw mabot timpo na mabannaw mga patay, kino ta pitto ya na mag-utod matuod na sawa ta bai ya tak tanan danen kasawa ki kanen?” ");
INSERT INTO cgc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sabat Jesus, “Sala inyo na isip tak ula kaw nalam daw ino naan ta sinulat na pulong ta Dyos daw ula kaw man gapati na Dyos may gaem ta pagbannaw ta mga patay. ");
INSERT INTO cgc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Daw mabannaw mga patay ya, dili danen mangasawa tak paryo danen ta mga angil naan ta langit na ula gasawaay. ");
INSERT INTO cgc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Parti man ta pagbannaw, paryo kaw inyo na ula kabasa ta ambal ta Dyos ki kyo naan ta sinulat na pulong din, ");
INSERT INTO cgc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yaken i Dyos danen Abraham, Isaac daw Jacob.’ Iling tan na ambal ta Dyos pamatuod na mga ittaw na napatay mabannaw tak dili kanen an Dyos ta mga patay. Dyos kanen an ta mga bui.” ");
INSERT INTO cgc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagmati ta mga ittaw dya ta ambal Jesus, gatingala gid danen an ta iya na tudlo. ");
INSERT INTO cgc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na namatian ta mga Pariseo na ula gid gasasaba mga Saduseo an ta ambal ya Jesus parti ta pagbannaw, gatingeb mga Pariseo an na miling ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Isya ki danen na may datas alam parti ta Mga Sinulat Moises, liag din na dakep-dakepen Jesus i paagi ta insa na iling ti, ");
INSERT INTO cgc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mistro, ino pinakaimpurtanti na sugo naan ta Mga Sinulat Moises?” ");
INSERT INTO cgc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sabat Jesus, “‘Gugmaen no Ginuo an na imo na Dyos na terek gid ta imo na tagipusuon. Ipakita no imo an na gugma paagi ta ugali daw isip.’ ");
INSERT INTO cgc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yon una daw pinakaimpurtanti na sugo. ");
INSERT INTO cgc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pangarwa na impurtanti na sugo paryas ta una: ‘Gugmaen no duma na mga ittaw paryo man ta paggugma no ta imo na kaugalingen.’ ");
INSERT INTO cgc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Darwa i na sugo basian ta tanan na naan ta Mga Sinulat Moises daw Mga Sinulat Ta Mga Prupita.” ");
INSERT INTO cgc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na mga Pariseo i gatipon pa naan ki Jesus, gainsa kanen an ki danen, ");
INSERT INTO cgc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ino ta inyo na isip parti ta Pinili Ta Dyos Na Mag-ari? Kino kaapuan na alinan din?” Sabat danen, “Ari David.” ");
INSERT INTO cgc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ambal Jesus “Ta, daw Ari David alinan ta Pinili Ta Dyos, man-o na David ya na pagaeman kanen ta Dyos Ispiritu Santo, paumaw din Pinili Ta Dyos na iya na Ginuo? Yi ambal Ari David: ");
INSERT INTO cgc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ginuo Dyos gambal ta ake na Ginuo, “Mungko ka di naan dapit ta ake i na tuo asta na mapirdi ko imo na mga kuntra.”’ ” ");
INSERT INTO cgc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ambal man Jesus, “Daw iling tan ambal Ari David parti ta Pinili Ta Dyos Na Mag-ari na paumaw din na iya na Ginuo, di' ba Pinili Ta Dyos Na Mag-ari dili nang basta na linai Ari David?” ");
INSERT INTO cgc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ula gid may gasabat ki kanen daw umpisa sa na adlaw, ula may nangiseg na mag-insa pa ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagtapos Jesus ta ambal naan ta mga Pariseo, gaisturya man kanen i naan ta mga ittaw na naan dya gatipon daw naan ta iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ambal din, “Mga Pariseo an daw mga manugtudlo ta Mga Sinulat Moises pasaligan na magsaysay ta mga sunuran na paatag paagi ki Moises. ");
INSERT INTO cgc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gani, tumanen nyo iran an na palaygay, piro dili nyo sunuron iran na pabuat tak danen an mismo ula gasunod ta iran na laygay. ");
INSERT INTO cgc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Papatuman danen naan ta mga ittaw tama na sunuron na bellay gid buaten na paryo gabegkes danen ta beg-at na dala daw papas-an naan ta mga ittaw daw ula man danen paduol maskin ta iran nang na kalingking. ");
INSERT INTO cgc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tanan na pabuat danen pakita-kita nang naan ta mga ittaw. Derse na kaon na paigot naan ta takong daw blukan ta uras ta pagpangamuyo, iran ya a papalapad pa gid danen, daw papalangkaw mga bungay-bungay ta sidsid ta iran na bayo. ");
INSERT INTO cgc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Daw mandegek danen an, liag gid danen na naan ta pungkuan na para ta impurtanti na mga ittaw. Iling man tan daw naan danen an ta mga balay tipunan. ");
INSERT INTO cgc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Daw naan danen ta lugar na naan dya tama na mga ittaw, liag gid danen na mga ittaw mag-atag ta taod daw mag-umaw ki danen na ‘mistro’. ");
INSERT INTO cgc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Piro, kyo yan a, dili kaw magparyo ki danen na magpaumaw na ‘mistro’ tak isya nang inyo na manugtudlo daw kyo tanan mag-utod ta pagtuo. ");
INSERT INTO cgc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dili kaw man mag-atag ta taod paagi ta pag-umaw na ‘amay’ naan ta bisan kino unti ta kalibutan i tak isya nang gid inyo an na Amay daw kanen naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dili kaw man magpaumaw na ‘ginuo’ tak isya nang inyo na Ginuo daw kanen Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Daw kino ki kyo may pinakadatas na katengdanan, kanen manugsirbi nyo. ");
INSERT INTO cgc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Daw kino magpadatas ta iya na kaugalingen, paebesen kanen an ta Dyos. Daw kino magpaebes ta iya na kaugalingen, padatasen kanen an ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ambal man Jesus, “Kyo na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, maageman nyo segeng na silot! Inyo na pagtuman ta Dyos pakita-kita nang! May katengdanan kaw na itudlo nyo paagi an na magpasakep mga ittaw naan ta pagdumala ta Dyos. Piro, ula kaw gapasakep ta iya na pagdumala daw papegengan nyo man mga ittaw ya na liag inta magpasakep. Paryo kaw ta ittaw na gasarado ta ngaan ta balay daw naan ta gwa gabantay aged duma an dili kaselled. ");
INSERT INTO cgc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kyo na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, maageman nyo segeng na silot! Inyo na pagtuman ta Dyos pakita-kita nang! Sikad kaw manluko ta mga balo na bai daw paubos nyo iran an na pangabuian. Gapakuno-kuno kaw na riliyuso paagi ta lawig na pangamuyo naan ta tama na mga ittaw aged dili mlaman na mga pabuat nyo an malain. Tenged iling tan mga buat nyo, maageman nyo segeng na silot ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kyo na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, maageman nyo segeng na silot! Inyo na pagtuman ta Dyos pakita-kita nang! Gabyai kaw naan ta mga madyo na lugar aged mangumbinsi ta bisan isya nang na ittaw na dili-Judio para isya man ta inyo na mga tinudluan. Pagtapos nyo ta pagkumbinsi, patudluan nyo asta na kanen an malain gid en daw dapat silutan naan ta impirno na mas pa ki kyo! ");
INSERT INTO cgc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kyo na paryo gid ta bulag na mga manuggiya, maageman nyo segeng na silot! Patudlo nyo na daw kino magsumpa paagi ta pagsambit ta Timplo, ula bali daw dili din tumanen iya an na sumpa. Piro, daw kanen magsumpa paagi ta pagsambit ta blawan na naan ta Timplo, kinanglan tumanen din gid iya an na sumpa. ");
INSERT INTO cgc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Buang-buang kaw gid na mga bulag! Indi ti mas impurtanti? Ino ta inyo na isip, Timplo o blawan na naan ta Timplo? Simpri Timplo i mas impurtanti tak blawan pabilang na para ta Dyos tenged blawan naan ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Patudlo nyo man na daw kino magsumpa paagi ta pagsambit ta alaran na naan ta Timplo, ula bali daw dili din tumanen iya an na sumpa. Piro, daw kanen magsumpa paagi ta pagsambit ta alad na nabetang naan ta alaran, kinanglan tumanen din gid iya an na sumpa. ");
INSERT INTO cgc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga bulag kaw gid! Indi ti mas impurtanti? Ino ta inyo na isip, alaran o alad na naan ta alaran? Simpri alaran mas impurtanti tak alad pabilang na para ta Dyos tenged alad naan ta alaran! ");
INSERT INTO cgc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Daw kino magsumpa paagi ta pagsambit ta alaran, gasumpa kanen an paagi ta alaran asta tanan na paalad dya. ");
INSERT INTO cgc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Daw kino magsumpa paagi ta pagsambit din ta Timplo, gasumpa kanen an paagi ta Timplo asta man Dyos mismo na gatinir dya. ");
INSERT INTO cgc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Daw kino magsumpa paagi ta pagsambit din ta langit, gasumpa kanen an paagi ta truno ta Dyos asta man Dyos mismo na gamungko dya. ");
INSERT INTO cgc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kyo na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, maageman nyo segeng na silot! Inyo na pagtuman ta Dyos pakita-kita nang! Gaamblig kaw gid na maalad naan ta Dyos isya na parti ta sampulo na parti ta tanan gid na paani nyo bisan ta mga daon na panglasa ta pagkaan. Piro, pabay-an nyo nang impurtanti na mga sugo tak dili igo inyo na pagtratar naan ta duma na mga ittaw, ula kaw naluoy ta mga gakinanglan daw dili kaw man masaligan. Igo na gaalad kaw ta isya ta sampulo na parti naan ta Dyos, piro dapat dili nyo bay-an mga sugo din an na mas impurtanti pa. ");
INSERT INTO cgc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Paryo kaw gid ta bulag na mga manuggiya! Gaamblig kaw gid na magtuman ta dili impurtanti na mga sugo, piro pabay-an nyo nang mga impurtanti an. Iling tan na pabuat nyo paryo na inyo na inemen pasala nyo aged sigurado na dili nyo mainem mga sapat-sapat an, piro ula bali na malam-ed nyo bakod na ayep na kamilyo. ");
INSERT INTO cgc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kyo na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, maageman nyo segeng na silot! Inyo na pagtuman ta Dyos pakita-kita nang! Paryo kaw ta ittaw na gaugas nang ta gwa ta ineman daw mangkok, piro selled ta ineman daw mangkok ula din paugasi. Iling man tan, pakita-kita nyo nang pirmi naan ta mga ittaw na patuman nyo gid mga sunuran nyo, piro pabay-an nyo na sikad kaw mangwarta daw inyo nang na kaugalingen na kalipay paintindi nyo an. ");
INSERT INTO cgc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bulag kaw na mga Pariseo! Bag-uon nyo anay inyo na isip aged makabuat kaw man ta miad. Daw iling tan buaten nyo, paryo na palimpyo nyo anay selled ta ineman daw mangkok daw sunod gwa man aged ubos limpyo. ");
INSERT INTO cgc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kyo na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, maageman nyo segeng na silot! Inyo na pagtuman ta Dyos pakita-kita nang! Paryo kaw ta mga pantyon na papinturaan ta puti na daw lagen naan ta gwa dayad, piro naan ta selled ubos ligna daw bekkeg ta mga patay. ");
INSERT INTO cgc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iling kaw man tan tak ta panan-aw ta mga ittaw ki kyo, matareng kaw, piro inyo na pagtuman ta Dyos dili terek ta inyo na tagipusuon daw ubos nang malain naan ta inyo na isip. ");
INSERT INTO cgc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kyo na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises, maageman nyo segeng na silot! Inyo na pagtuman ta Dyos pakita-kita nang! Gapaubra kaw ta mga lebbengan ta mga prupita daw papadayad nyo mga pantyon an ta mga ittaw na matareng. ");
INSERT INTO cgc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Gambal kaw, ‘Daw kami bui ta timpo ta ame na mga kaapuan, dili kay ame maglabet ta iran na pagpatay ta mga prupita.’ ");
INSERT INTO cgc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta, paagi ta iling tan na paambal nyo, paako nyo na kyo linai ta mga gapatay ta mga prupita. ");
INSERT INTO cgc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tenged iling kaw san, sigi, padayunon nyo daw tapuson mga malain na buat na naumpisaan danen. ");
INSERT INTO cgc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Kyo na malain! Paryo kaw ta mga bekkessan daw mga bata ta bekkessan na dalitan! Dili nyo malikawan na sintinsyaan kaw ta Dyos na silutan naan ta impirno! ");
INSERT INTO cgc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Magpadala a ki kyo ta mga manugsugid ta kabebet-en ta Dyos, mga ittaw na maalam daw mga manugtudlo ta Mga Sinulat Moises. Duma an ki danen ipapatay nyo, duma an ipalansang naan ta krus, duma pa an ipakastigo nyo naan ta inyo na mga balay tipunan daw duma pa gid ipalagas nyo ta inyo na pagpangabot ki danen bisan indi danen an miling. ");
INSERT INTO cgc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gani, sigurado gid na manabat kaw ta kamatayen ta tanan na mga ittaw na matareng umpisa gid ki Abel na matareng na ittaw asta ki Zacarias na bata Baraquias na papatay naan ta Timplo naan ta tengnga ta sunugan ta mga alad daw Balay Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sugiran ta kyo na mga ittaw ta yi na timpo manabat gid ta kamatayen danen tanan na matareng.” ");
INSERT INTO cgc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Gangasebe Jesus i daw gambal, “Kyo na naan ta Jerusalem, kaluluoy kaw. Ula nyo batuna mga padala ya ta Dyos tak papatay nyo mga prupita daw patimbag mga sinugo ta Dyos. Lugay en na liag ko na pasakepen kaw inta ki yaken daw ambligan paryas ta pagtipon ta nayen na manok ta iya na mga piyak naan ta dalem ta iya na mga pakpak. Piro, dili kaw miag! ");
INSERT INTO cgc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tenged iling tan nabuat nyo, anduni syudad nyo an daw Timplo pabay-an nang en ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sugiran ta kyo na dili a nyo makita isab asta mabot adlaw na mambal kaw, ‘Dayawen ta kanen an na papadala ta Ginuo Dyos na miling di en.’” ");
INSERT INTO cgc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na gapanaw Jesus i na mwa ta Timplo, iya na mga tinudluan gaprani ki kanen. Pabugal danen ki kanen mga bilding naan ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ambal din ki danen, “Makita nyo pa anduni tanan na i daw dayad matuod, piro gambal a ki kyo na mabot adlaw na magubba gid Timplo i daw tanan na bato ta Timplo mawasak na ula gid maskin isya nang na bato na gasampaw pa naan ta duma na bato.” ");
INSERT INTO cgc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Giling danen i Jesus naan ta Bukid Olibo. Na gamungko kanen i dya, iya na mga tinudluan gaprani ki kanen na danen nang daw mambal, “Sugiran kay no tuo daw kan-o matabo nyan na paambal no. Ino sinyalis na pamatuod na kaon mabot en daw matapos man en yi na timpo?” ");
INSERT INTO cgc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sabat Jesus ki danen, “Mag-andam kaw gid aged dili kaw maluko ");
INSERT INTO cgc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","tak tama na mga ittaw miling ki kyo na akuon danen ake na ngaran ta iran na kaugalingen daw ambalen danen, ‘Yaken i Pinili Ta Dyos Na Mag-ari!’ Ta iling tan na buat danen, tama na mga ittaw maluko danen. ");
INSERT INTO cgc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ta yon man na timpo kamati kaw ta gira na dani ki kyo daw kabalita na naan ta madyo may gira man, piro dili kaw mataranta tak naan ta plano ta Dyos na matabo anay iling an tan. Piro, dili pa katapusan ta yi na timpo. ");
INSERT INTO cgc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mga nasyon maggiraay daw mga kaarian kuntra ta kaarian. May segeng na letem daw mga linog naan ta lain-lain na mga lugar. ");
INSERT INTO cgc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Piro, tanan na iling tan umpisa nang pa ta segeng na kakulian na maagian ta mga ittaw paryo ta mabatyagan ta bai na manugbata en na umpisa nang pa gapasakit. ");
INSERT INTO cgc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ta yon man na timpo ta kakulian, may mga ittaw na magdakep ki kyo na intriga kaw naan ta mga gakuntra ki kyo aged pabellayan daw duma an ki kyo patayen. Bisan indi demetan kaw gid ta tanan tenged sakep kaw ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta yon man na timpo, tama na mga ittaw magtalikod ta iran na pagsalig ki yaken daw duma an magdemetay daw magtrayduray. ");
INSERT INTO cgc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tama mwa na dili-matuod na prupita daw tama maluko danen. ");
INSERT INTO cgc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tenged na magtama mga ittaw na gabuat ta malain, katamaan ta mga ittaw, marwad iran na paggugmaay. ");
INSERT INTO cgc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piro, maluwas mga ittaw na magpadayon ta iran na pagpati ki yaken asta ta katapusan ta yon na timpo. ");
INSERT INTO cgc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bag-o matapos yi na timpo, miad na balita parti ta pagdumala ta Dyos masugid anay naan ta bilog na kalibutan aged mamatian ta tanan.” ");
INSERT INTO cgc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ambal pa Jesus, “Ta timpo na mabot, makita nyo naan ta Timplo ‘sikad malain na betang na gainsulto ta balay ta Dyos’ na yon man pasambit ya Daniel na prupita anay pa sa.” -- Kyo na gabasa ta nasulat na i, intindien nyo gid daw ino beet ambalen. ");
INSERT INTO cgc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ambal pa gid Jesus, “Daw iling tan makita nyo naan ta Timplo, beet ambalen abot en timpo na mga ittaw na gaistar naan ta prubinsya Judea dapat na magbakwit naan ta mga bukid. ");
INSERT INTO cgc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Daw matabuan na may ittaw na naan ta atep ta iran na balay, dapat na magbakwit dayon na dili en melled pa ta balay daw magkamang ta pagkabetang na dleen din. ");
INSERT INTO cgc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iling man tan, daw matabuan na may ittaw na naan ta iya na uma, dapat na dili en muli pa na magkamang ta pang-isleb din na bayo. ");
INSERT INTO cgc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ta yon man na timpo, kaluluoy gid mga bai na gabagnes daw gapasuso tak mabellayan danen ta pagbakwit. ");
INSERT INTO cgc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mangamuyo kaw nang ta Dyos na inyo na pagbakwit dili matabo naan ta tagtignaw daw dili man naan ta Adlaw Ta Pagpuay ");
INSERT INTO cgc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","tak ta yon man na timpo, maagian ta mga ittaw segeng gid na kakulian na ula pa naagii ta bisan kino alin ta pagbuat ta kalibutan daw kalangitan asta anduni. Ula en may matabo pa na mas segeng na kakulian kaysa ta iling tan. ");
INSERT INTO cgc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Daw dili palipuon ta Dyos mga inadlaw na ya na maagian danen, ula gid may isya na ittaw na mabilin na bui. Piro, palipuon din nang tenged ta iya na pinili na mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ambal pa Jesus, “Ta yon man na timpo, daw may mambal ki kyo, ‘Lagen nyo, anen di en Pinili Ta Dyos Na Mag-ari!’ dili kaw magpati. Iling man tan daw may mambal, ‘Kanen man nyan!’ ");
INSERT INTO cgc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","tak may miling ki kyo na mga dili-matuod na Pinili Ta Dyos Na Mag-ari daw mga dili-matuod na prupita. Magbuat danen an ta bakod na mga katingalaan na pamatuod na danen an may gaem aged na daw maimo, tilawan na maluko danen asta pa ta mga ittaw na pinili ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tandaan nyo gid ambal ko an tak nasugid ko en daan ki kyo parti ta matabo pa mintras na ula pa natabo. ");
INSERT INTO cgc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tenged pasugiran ta kyo en, daw may mambal ki kyo, ‘Yo, anen dya en Pinili Ta Dyos Na Mag-ari naan ta lugar na ula kabalayan’, dili kaw miling dya. Daw ambalen man danen, ‘Yi, anen di en kanen naan ta selled ta kwarto’, dili kaw magpati ");
INSERT INTO cgc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","tak ta adlaw na mabot Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, makita kanen an ta tanan na mga ittaw paryo ta kilat na makita gid na gakurit alin ta sennangngan munta ta salepan. ");
INSERT INTO cgc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Makita gid ta tanan iya an na pag-abot na paryo man ta isya na ambalanen, ‘Daw indi may patay, mlaman gid ta tanan tak naan dya galayog-layog mga uwak.’” ");
INSERT INTO cgc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Gambal pa gid Jesus i parti ta mga adlaw na mabot, “Sunod ta yon man na mga adlaw na may mga segeng na kakulian, dayon matabo na ‘Magdelem adlaw an daw bulan an dili magpawa. Mga bituon an mulog alin ta langit daw tanan na naan ta kalangitan manlatak na paryo ta payegyeg.’ ");
INSERT INTO cgc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pagtapos ta mga matabo na iling tan, may makita naan ta kalangitan na sinyalis na mabot en Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. Tanan na mga ittaw ta kalibutan mangug-og ta tudo tenged ta iran na kaadlek. Makita danen na kanen an mabot naan ta panganod na bakod gid iya na gaem daw sikad silaw na pawa ta Dyos naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta biskeg na tunog ta trumpita, ipadala din iya an na mga angil naan ta appat na pamusod ta kalibutan aged tipunon mga ittaw na iya na pinili alin ta tanan na lugar.” ");
INSERT INTO cgc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Gambal pa Jesus i, “Intindien nyo daw ino beet ambalen ta paanggid na isturya ta kaoy na igos: Daw iya an na mga sanga gasalingsing daw gadaon, mlaman nyo na mabot en tagtanem. ");
INSERT INTO cgc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yon man, daw makita nyo na gaumpisa en matabo tanan na pasugid ko ki kyo, sigurado gid na mlaman nyo na kanen an mabot en na paryo naan en kanen ta gwa ta gangaan. ");
INSERT INTO cgc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sugiran ta kyo na tanan ya na mga pasugid ko ki kyo matabo na ula pa napatay tanan na mga ittaw ta yi na timpo. ");
INSERT INTO cgc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maski marwad pa kalangitan an daw kalibutan, ake i na mga ambal magpadayon asta ta ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Gambal pa Jesus i, “Parti daw ino adlaw daw uras na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mabot, ula may nalam bisan mga angil ta langit daw bisan man Bata Ta Dyos. Dyos Amay nang gid nalam. ");
INSERT INTO cgc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ta timpo na mabot en Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, mga buat ta mga ittaw paryas man ta mga pabuat ya ta mga ittaw anay pa sa ta timpo Noe. ");
INSERT INTO cgc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta mga adlaw ya na ula pa gabot anaw na galapaw ta bilog na kalibutan, ula ta iran na isip daw ino matabo ki danen daw gapadayon man gyapon danen ta iran na pang-adlaw-adlaw na buat. Gakaan danen ya, gainem daw gangasawa asta ta adlaw na gasakay en Noe naan ta arka. ");
INSERT INTO cgc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ula gid danen nlami daw ino matabo ki danen asta gabot anaw ya daw nalemmes danen tanan. Iling man tan, mga ittaw magulpian naan ta adlaw na mabot Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. ");
INSERT INTO cgc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Daw matabuan na darwa na mama gaubra naan ta uma, isya an kamangen daw isya an a, mabilin. ");
INSERT INTO cgc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Daw matabuan na darwa na bai gatabangay ta paggaling, isya an kamangen daw isya an a, mabilin. ");
INSERT INTO cgc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Gani, magbantay kaw tak ula nyo nlami daw ino na adlaw na mabot inyo an na Ginuo. ");
INSERT INTO cgc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Intindien nyo ta miad na daw nlaman inta ta tag-iya ta balay daw ino uras ta kilem mabot ittaw na manakaw, sigurado na magpulaw kanen ta pagbantay ta iya na balay aged matakaw an dili kaselled. ");
INSERT INTO cgc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gani, dapat na pirmi kaw anda tak Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mabot ta uras na ula nyo papaabuta.” ");
INSERT INTO cgc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Gaisturya pa Jesus i ta paanggid naan ta iya na mga tinudluan, “May tag-iya ta balay na gapili naan ta iya na mga suguon ta isya na masaligan daw maalam. Napili din na suguon patugyanan din na magdumala ta duma na mga suguon naan ta iya na panimalay daw tagan danen an ta iran na pagkaan ta igo na uras. ");
INSERT INTO cgc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Daw suguon na gadumala maabutan ta iya na amo na patuman din papaubra ya ki kanen, sigurado gid na bakod iya na kalipay. ");
INSERT INTO cgc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sugiran ta kyo na padumalaen kanen an ta amo din naan ta tanan na pagkabetang ta iya na amo. ");
INSERT INTO cgc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piro, daw matabuan na suguon ya malain, mambal kanen ta iya na kaugalingen, ‘Lugay pa taan malik ake ya na amo.’ ");
INSERT INTO cgc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tenged iling tan iya na paisip, mag-umpisa kanen na manakit ta iya na duma na mga suguon daw pagusto man kanen an ta kaan daw inem duma ta mga palaingaw. ");
INSERT INTO cgc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na iling tan ubra din, gulpi nang abot iya na amo ta adlaw na ula din papaabuta daw ta uras na ula din nlami. ");
INSERT INTO cgc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pag-abot ta iya na amo, silutan kanen an ta beg-at na silot paryo ta maageman ta duma na mga ittaw na pakita-kita nang iran na pagtuman. Iling tan na mga ittaw silutan naan ta lugar na naan dya danen mangagal daw magbaggit ta iran na mga ngipen.” ");
INSERT INTO cgc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Gambal pa Jesus i naan ta iya na mga tinudluan, “Ta adlaw na mabot Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, pagdumala an ta Dyos paryo ta natabo ta sampulo na dlaga na abay na may dala na lampara para ta iran na pagsugat ta kasalen na mama na mabot. ");
INSERT INTO cgc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Limma ki danen maalam daw limma ya kabos-kabos. ");
INSERT INTO cgc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Mga maalam ya gadala ta iran na lampara daw gadala pa gid ta risirba na lana para ta iran na lampara. Mga kabos-kabos ya a gadala ta iran na lampara, piro ula gadala ta lana na risirba. ");
INSERT INTO cgc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na lugay mabot kasalen ya na mama, sampulo na abay tunugaen ta pagtagad ki kanen asta na katunuga. ");
INSERT INTO cgc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na magtenga kilem en, may gasinggit, ‘Anen en mama na kasalen! Giran nyo! Sugaten nyo kanen an!’ ");
INSERT INTO cgc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gabugtaw dayon sampulo ya na mga abay daw gapriparar ta iran na lampara. ");
INSERT INTO cgc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Piro, mga kabos-kabos ya na abay gambal naan ta mga maalam na abay, ‘Tagan kay nyo tuo ta dala nyo na lana bisan tise nang tak gapaleng-paleng en ame i na mga lampara.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sabat ta mga maalam, ‘Dili pwidi tak basi dili mag-igo dala nay i na lana para ki kiten tanan. Miad pa na manaw kaw daw malit ta lana na para ta inyo yan na lampara.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Na gapanaw mga abay ya na kabos-kabos aged malit ta lana, gabot kasalen ya na mama. Limma ya na abay na anda en ta pag-abot din gakuyog ki kanen naan ta kumbiraan. Pagselled danen, pasaraduan gangaan ya. ");
INSERT INTO cgc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ula nang lugay, gabot man limma ya na mga abay na gapalit ta lana, piro sarado en gangaan ya. Gaumaw danen an, ‘Sir! Sir! Paselleren kay no!’ ");
INSERT INTO cgc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piro, gasabat mama ya na kasalen, ‘Paselleren ta kyo inta daw kala ta kyo, galing dili ta kyo kala.’” ");
INSERT INTO cgc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pagtapos Jesus ta pag-isturya ta paanggid, gambal kanen i naan ta iya na mga tinudluan, “Nyan na kinanglan gid na magbantay kaw tak dili nyo mlaman daw kan-o mabot Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan.” ");
INSERT INTO cgc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Gambal pa Jesus i naan ta iya na mga tinudluan, “Pagdumala an ta Dyos paanggid man ta pabuat ta isya na ittaw na marga na miling ta madyo na lugar. Bag-o kanen marga, paumaw din iya an na mga suguon aged intrigaan din danen an na magdumala ta iya na pagkabetang. ");
INSERT INTO cgc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kada isya ki danen paintrigaan din ta kwarta keteb ta iran na masarangan na inigusyo. Una ya paintrigaan din ta limma na sinsilyo na pilak na may bakod gid na balor, daw sunod ya darwa na sinsilyo daw sunod pa gid ya isya. Pagtapos din ta pag-intriga, gapanaw kanen ya. ");
INSERT INTO cgc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Suguon ya na kabaton ta limma na sinsilyo na pilak, panigusyo din kwarta ya daw kaginansya kanen ya ta limma. ");
INSERT INTO cgc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iling man tan, kabaton ya ta darwa, kaginansya kanen ya ta darwa. ");
INSERT INTO cgc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piro, kabaton ya ta isya na sinsilyo na pilak gagwa daw gakutkot naan ta basak daw palebbeng din kwarta ya ta iya na amo. ");
INSERT INTO cgc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Paglambay ta lugay na timpo, gabalik amo ya. Papangitaan din iya na mga suguon ta sumada ta iran na mga panigusyo. ");
INSERT INTO cgc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Suguon ya na kabaton ta limma na sinsilyo gaprani na dala din limma pa gid na sinsilyo daw ambal din ta iya na amo, ‘Sir, paintriga no kan-o ki yaken limma na sinsilyo. May tubo na limma.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sabat ta iya na amo, ‘Nyan dayad! Miad ka gid daw masaligan na suguon. Tenged masaligan ka parti ta sise na kantidad, anduni intrigaan ta kaw ta bakod na kantidad. Magkalipay ka duma ki yaken.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Suguon ya na kabaton ta darwa na sinsilyo gaprani ta iya na amo daw mambal, ‘Sir, paintriga no kan-o ki yaken darwa na sinsilyo. May tubo na darwa.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sabat ta amo, ‘Nyan dayad! Miad ka gid daw masaligan na suguon. Tenged masaligan ka parti ta sise nang na kantidad, anduni intrigaan ta kaw ta bakod na kantidad. Magkalipay ka duma ki yaken.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Suguon ya na kabaton ta isya na sinsilyo gaprani man daw mambal ta iya na amo, ‘Sir, nlaman ko na pwirti ka gid na amo tak gapangani ka ta dili imo na sinabwag daw gapanapas ka ta dili imo na pinanggas. ");
INSERT INTO cgc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nyan na adlek a tak basi ula a ginansya daw marwad pa imo an na kwarta. Yon tenaan na palebbeng ko nang naan ta basak. Yi en kwarta no.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Sabat ta amo, ‘Malain ka na suguon daw tamad gid! Nlaman no na gapangani a ta dili ake na sinabwag daw gapanapas man ta dili ake na pinanggas! ");
INSERT INTO cgc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Man-o tak ula no paeles kwarta ko an naan ta mga nigusyanti na gapautang na gapatubo ta kwarta aged ta ake na pagbalik makamang ko ake na kwarta na may tubo man?’ ");
INSERT INTO cgc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ambal ta amo naan ta duma na mga suguon din, ‘Kamangen nyo naan ki kanen isya an na sinsilyo daw iatag naan ta suguon na may sampulo na sinsilyo ");
INSERT INTO cgc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","tak mga ittaw na masaligan parti ta mga paatag ki danen, tagan pa gid ta tama. Piro, mga ittaw na dili masaligan, maskin sise na naan ki danen kamangen pa. ");
INSERT INTO cgc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Anduni, parti ta suguon i na ula pulos, dleen nyo kanen i daw pilak naan ta sikad delem na lugar na naan dya mga ittaw an mangagal ta tudo daw magbaggit ta iran an na ngipen.’” ");
INSERT INTO cgc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Gambal pa gid Jesus i naan ta iya na mga tinudluan, “Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mabot na makita sikad silaw na pawa na naan ki kanen daw kanen duma ta tanan na mga angil. Pag-abot din, mungko kanen an naan ta iya na truno aged mag-ari. ");
INSERT INTO cgc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tanan na mga ittaw ta kalibutan tipunon naan ki kanen. Belagen din danen an ta darwa na grupo na paryo ta ubra ta manugbantay ta karniro na pabelag din mga karniro an naan ta mga kanding. ");
INSERT INTO cgc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mga ittaw na matareng tipunon din naan dapit ta iya na tuo paryo ta paimo naan ta mga karniro. Mga ittaw na dili matareng tipunon din naan dapit ta iya na wala paryo ta paimo naan ta mga kanding. ");
INSERT INTO cgc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kanen an na Ari mag-ambal ta mga ittaw na naan dapit ta iya na tuo, ‘Kyo na mga pakaluy-an ta ake na Amay, marani kaw di daw batunon nyo patagana din para ki kyo. Tagan kaw din ta mga kaayaran na para ta mga ittaw na sakep ta iya na pagdumala tak iling tan plano din alin pa ta pagbuat din ta kalibutan daw kalangitan. ");
INSERT INTO cgc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yon buaten din para ki kyo tak na nletem a, papakaan a nyo. Na nlao a, papainem a nyo ta waig. Na ula a maistaran, papadayon a nyo naan ta inyo na balay. ");
INSERT INTO cgc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na ula a masuot, paatagan a nyo ta bayo. Na gamasakit a, paasikaso a nyo. Na napriso a, pasud-o a nyo.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Pagtapos ta ambal ta Ari, mga matareng an na ittaw mag-insa ki kanen, ‘Ginuo, kan-o ka nakita nay na nletem daw paatagan nay kaon yan ta pagkaan? Kan-o ka nlao daw paatagan nay kaon yan ta waig na inemen? ");
INSERT INTO cgc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kan-o ka nakita nay na ula ka istaran daw papadayon nay kaon yan naan ta ame na balay? Kan-o ka gakinanglan ta bayo daw paatagan nay kaon yan ta suuton? ");
INSERT INTO cgc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kan-o ka nakita nay na gamasakit o napriso daw gasud-o kay ki kaon?’ ");
INSERT INTO cgc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kanen an na Ari magsabat, ‘Salig nyo gid na ula a nyo patabangi, piro sugiran ta kyo na nabuat nyo ya naan ta kebes na mga ittaw na pabilang ko na ake na mga utod, paryo nabuat nyo man en ki yaken.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ari an mambal naan ta mga ittaw naan dapit ta iya na wala, ‘Kyo na mga sintinsyaan ta Dyos na silutan, malin kaw di ta atubangan ko. Unso kaw naan ta apoy na ula katapusan na patagana ta Dyos para ki Satanas daw ta iya na mga sinakepan. ");
INSERT INTO cgc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yon buaten ta Dyos ki kyo tak na nletem a, ula a nyo paatagi ta pagkaan. Na nlao a, ula a nyo paatagi ta waig na inemen. ");
INSERT INTO cgc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na ula a maistaran, ula a nyo padayuna naan ta inyo na balay. Na ula a suuton, ula a nyo paatagi ta bayo. Na gamasakit a, ula a nyo pasud-ua daw iling man tan na napriso a.’ ");
INSERT INTO cgc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Gainsa danen an ta Ari, ‘Ginuo, kan-o ka nakita nay na nletem, nlao, ula madayunan, ula suuton, gamasakit ka daw napriso na ula kay gatabang ki kaon?’ ");
INSERT INTO cgc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Sabat ta Ari ki danen, ‘Matuod na ula a nyo patabangi tak sugiran ta kyo na ula nyo ya nabuat naan ta kebes na mga ittaw na pabilang ko na ake na mga utod, paryo ula nyo nabuat naan ki yaken.’” ");
INSERT INTO cgc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pagtapos Jesus ta pag-isturya ta paanggid, ambal din pa, “Mga ittaw na dili matareng silutan naan ta impirno ta ula katapusan. Piro, mga ittaw na matareng maangken danen kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagtapos Jesus ta iya na pagtudlo naan ta mga tinudluan din, gasugid kanen i ki danen, ");
INSERT INTO cgc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nlaman nyo na darwa nang en adlaw bag-o mag-umpisa Pista Ta Paglibri Alin Ta Egipto. Ta adlaw ta pista an, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan iintriga naan ta iya na mga kuntra aged sintinsyaan ta kamatayen paagi ta paglansang naan ta krus.” ");
INSERT INTO cgc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ta adlaw na gambal Jesus ta iling tan, mga manugdumala na mga pari daw mga gadumala ta mga Judio gatipon naan ta istaran ta pinakadatas na manugdumala ta mga pari na ngaran din Caifas. ");
INSERT INTO cgc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Gaplano danen an aged na ipadakep danen Jesus i ta sikrito nang daw ipapatay. ");
INSERT INTO cgc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Piro, gambal danen an, “Dili ta anay buaten ate na plano naan ta timpo ta pista tak basi maggamo mga ittaw an.” ");
INSERT INTO cgc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Giling Jesus i naan ta baryo na Betania daw gadayon naan iran Simon. Simon i, kala ta mga ittaw na kanen i dati na may segeng na masakit ta langgit. ");
INSERT INTO cgc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na gakaan Jesus i naan iran Simon, may bai na gaprani ki Jesus. May dala kanen an na tise na tibod na buat alin ta bato na alabastro na may ugsak na maalen na paammot. Pabubo din paammot an naan ta ulo Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkita ta mga tinudluan Jesus, gagilek danen an daw gambal, “Man-o tak pauyakan din nang paammot an? ");
INSERT INTO cgc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pwidi pa inta mabligya nan ta maal na prisyo daw kwarta ya iatag naan ta mga imol.” ");
INSERT INTO cgc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nlaman Jesus iran na paambal daw painsaan din danen an, “Man-o tak pasaway nyo bai i? Dayad iya na pabuat ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mga imol an pirmi nyo duma, piro yaken i a, dili en maglugay na duma ki kyo. ");
INSERT INTO cgc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ta iya na pagbubo naan ki yaken ta paammot, papriparar din lawa ko para ta ake na lebbeng. ");
INSERT INTO cgc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Dayad gid iya na pabuat ki yaken daw sugiran ta kyo na bisan indi mawali miad na balita naan ta bilog na kalibutan, pabuat din i ki yaken masambit man para ta pagdemdem ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Isya ta dusi na apustulis na ngaran din Judas Iscariote giling naan ta mga manugdumala na mga pari ");
INSERT INTO cgc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","daw gainsa, “Pila inyo na bayad ki yaken daw trayduran ko daw intriga Jesus ya naan ki kyo?” Dayon pabayaran danen kanen i ta trinta buok na sinsilyo na pilak. ");
INSERT INTO cgc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Umpisa ta yon man na uras, gangita en kanen ta tsansa na matrayduran din daw maintriga Jesus an naan ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta una na adlaw ta Pista Ta Tinapay Na Ula Pampaabok, mga tinudluan i Jesus gaprani ki kanen daw gainsa, “Indi no liag na magpriparar kay para ki kaon ta yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto?” ");
INSERT INTO cgc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sabat Jesus, “Miling kaw naan ta syudad daw ngitaen nyo kala ta ya na mama daw sugiran nyo kanen an ta iling ti, ‘May ambal Mistro ya ki kaon. Yi ambal din, “Mabot en ake na uras naan ta plano ta Dyos. Naan ta imo na balay yaken daw ake na mga tinudluan magsilibrar ta Pista Ta Paglibri Alin Ta Egipto.”’ ” ");
INSERT INTO cgc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pagtapos ta ambal Jesus, patuman ta mga tinudluan din iya na ambal daw gapriparar danen an ta yapon ta pagsilibrar ta pista. ");
INSERT INTO cgc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na semsem en, gayapon Jesus i duma ta dusi na apustulis. ");
INSERT INTO cgc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na gakaan danen, gambal Jesus i, “Gaduma kaw anduni ki yaken ta pagkaan, piro sugiran ta kyo na isya ki kyo magtraydor ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pagmati ta mga apustulis, nasebean gid danen an daw kada isya ki danen gambal ki kanen, “Ginuo, dili yaken nya, di' ba?” ");
INSERT INTO cgc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ambal Jesus ki danen, “Magtraydor an ki yaken isya ki kyo na gasawsaw man naan ta mangkok duma ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Matuman gid en ambal naan ta sinulat na pulong ta Dyos na mapatay Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. Piro, ittaw an na magtraydor ki kanen may segeng na silot na maageman daw miad pa na ula nang en kanen an natao.” ");
INSERT INTO cgc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pag-ambal Jesus, Judas i na magtraydor ki kanen gambal, “Mistro, dili yaken nya, di' ba?” Ambal Jesus, “Kaon nang gambal san.” ");
INSERT INTO cgc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na gakaan pa Jesus i daw mga apustulis, gakamang kanen i ta tinapay daw gapasalamat ta Dyos. Pabiak-biak din daw paatag ki danen na ambal din, “Mamang kaw ta tinapay i daw kan-enen nyo. Yi ni ake na lawa.” ");
INSERT INTO cgc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pagtapos danen kamang ta tinapay, gakamang Jesus i ta ineman na may ugsak na bino daw gapasalamat ta Dyos. Paatag din ki danen na ambal din, “Tanan kaw minem ta bino i. ");
INSERT INTO cgc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yi ni ake na lengngessa na kalig-enan ta kasugtanan na alin ta Dyos. Matulo ake na lengngessa na yaken i mapatay bilang alad para ta tama na mga ittaw aged patawaren iran na mga sala. ");
INSERT INTO cgc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sugiran ta kyo na dili aren minem isab ta bino asta mabot adlaw na yaken i minem ta bag-o na bino duma ki kyo naan ta pag-umpisa ta pagdumala ta ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gakanta danen ta pagdayaw naan ta Dyos daw pagtapos, gagwa danen na miling naan ta Bukid Olibo. ");
INSERT INTO cgc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na Jesus i daw mga apustulis naan en ta Bukid Olibo, ambal din ki danen, “Anduni na kilem, mabot uras na kyo tanan dilian a nyo tenged ta matabo ki yaken paryo ta ambal na naan ta sinulat na pulong ta Dyos na Dyos gambal, ‘Patayen ko manugbantay an, dason wasaken ko panen na mga karniro.’” ");
INSERT INTO cgc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ambal pa Jesus, “Pagbannaw ki yaken, muna a ki kyo na miling naan ta Galilea.” ");
INSERT INTO cgc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Gambal Pedro i ki kanen, “Dili ta kaw dilian bisan dilian ka ta tanan tenged ta matabo ki kaon!” ");
INSERT INTO cgc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sabat din, “Dayad gid inta ambal no an, piro sugiran ta kaw na ta yi gid na kilem bag-o magtagaok manok, kambal ka en ta tallo bisis na dili a no kala.” ");
INSERT INTO cgc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sabat Pedro, “Bisan patayen a pa duma ki kaon, dili a mag-ambal na dili ta kaw kala.” Pag-ambal Pedro, iling man tan ambal ta duma pa na mga apustulis. ");
INSERT INTO cgc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesus i daw mga apustulis giling naan ta lugar na paumaw na Getsemane. Pag-abot danen dya, gambal kanen i ki danen, “Mungko kaw nang di anay tak miling a naan ta unaan para mangamuyo.” ");
INSERT INTO cgc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pag-ambal din, pakuyog din danen i Pedro daw darwa na bata Zebedeo. Umpisa sa, gangalised kanen i daw nasebean gid ");
INSERT INTO cgc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","na ambal din ki danen, “Daw paryo a gid mapatay ta subla na kalised. Unti kaw nang daw magpulaw na magbantay-bantay duma ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na gapanaw kanen i naan ta unaan, gadapa naan ta basak daw gapangamuyo. Ambal din, “Amay ko, daw maimo, ipamadyo no ki yaken segeng na kabellay na maagian ko. Piro, dili ake na liag matuman, imo na liag.” ");
INSERT INTO cgc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagtapos Jesus ta pagpangamuyo, gabalik kanen i naan ta iya na mga tinudluan daw naabutan din danen an na gatunuga. Gambal kanen ki Pedro, “Ino, dili kaw gid kaagwanta bisan isya nang uras na magpulaw na magbantay-bantay duma ki yaken? ");
INSERT INTO cgc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpulaw kaw daw mangamuyo aged dili kaw mapirdi ta pagtilaw na mabot ki kyo. Liag nyo inta na magpulaw daw mangamuyo, piro dili kaya ta inyo na lawa.” ");
INSERT INTO cgc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gapanaw isab Jesus i naan ta unaan daw gapangamuyo, “Amay ko, daw dili malikawan na tubangen ko segeng na kabellay na maagian ko, imo na pagbeet matuman an.” ");
INSERT INTO cgc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na gabalik isab kanen i ki danen Pedro, naabutan din na gatunuga eman tak puyat gid danen an. ");
INSERT INTO cgc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pabilin din danen an isab daw manaw naan ta unaan. Ta pangallo na bisis gapangamuyo kanen na paryo man gyapon iya na pangamuyo. ");
INSERT INTO cgc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagtapos din ta pagpangamuyo, gabalik kanen i naan ta iya na mga tinudluan daw pambalan din danen an, “Aree! Gatunuga kaw pa man yan gyapon daw gapuay! Lagen nyo! Uras en na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan trayduron daw intriga naan ta malain na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mangon kaw! Gabot en ittaw an na magtraydor ki yaken. Mos, sugaten ta kanen an.” ");
INSERT INTO cgc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na gambal pa Jesus i ki danen Pedro, gabot Judas an na isya ta dusi na apustulis. Gakuyog ki kanen sikad tama na mga ittaw na gadala ta mga ispada daw mga baston. Pasugo danen an ta mga manugdumala na mga pari daw mga gadumala ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas an na traydor, bag-o kanen miling ki Jesus, gambal daan kanen an naan ta mga magdakep ki Jesus daw ino iya na sinyas para makala danen Jesus an. Ambal din, “Daw kino mabugno ko paagi ta arek, yon inyo na papangita. Dakepen nyo kanen an.” ");
INSERT INTO cgc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tenged ta ambal daan Judas, na gabot danen an, gadiritso kanen i ki Jesus daw magbugno, “Mistro, miad na kilem!” daw paarekan din. ");
INSERT INTO cgc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ambal Jesus ki kanen, “Dey, buaten no en tuyo no an ta pag-iling di.” Pag-ambal Jesus, papranian danen Jesus i daw padakep. ");
INSERT INTO cgc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nali nang, isya ta mga duma Jesus gagabot ta iya na ispada daw patigbas din suguon ya ta pinakadatas na manugdumala ta mga pari daw nalantep gid iya na talinga. ");
INSERT INTO cgc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus i gambal, “Balik no ta tageban ispada no an! Mga ittaw na gagamit ta ispada, ta ispada man mapatay. ");
INSERT INTO cgc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Paryo ka imo ula nalam na sarang a mangayo ta tabang naan ta ake na Amay na naan ta langit daw ipadala din dayon linibo na mga angil aged magtabang ki yaken! ");
INSERT INTO cgc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Piro, daw mangayo a ta tabang, dili matuman plano ta Dyos naan ta sinulat na pulong din na iling gid ti matabo ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pambalan man Jesus mga ittaw an na duma ki Judas, “Man-o, tulisan a na kinanglan gid na magdala kaw pa ta mga ispada daw mga baston ta pagdakep ki yaken? Adlaw-adlaw naan a ta Timplo gamungko na gatudlo ta mga ittaw, piro ula a nyo dya dakepa. ");
INSERT INTO cgc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piro, yi tanan natabo ki yaken aged matuman ambal ya ta mga prupita naan ta sinulat na pulong ta Dyos.” Pag-ambal Jesus, padilian kanen i ta iya na mga tinudluan daw danen ya tanan gadlagan padyo. ");
INSERT INTO cgc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mga ittaw na gadakep ki Jesus, padala danen kanen an naan ta istaran Caifas na pinakadatas na manugdumala ta mga pari tak naan dya gatipon mga manugtudlo ta Mga Sinulat Moises daw mga gadumala ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro i gasunod ki Jesus, piro madyo iya na antad. Gasunod kanen an asta ta sular ta istaran ta pinakadatas na pari. Pagselled din naan ta sular, gapungko kanen i duma ta mga gwardya aged makita din daw ino matabo ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mga manugdumala na mga pari daw tanan na mimbro ta Sanedrin na kadatasan na kunsiyo ta mga Judio gangita ta ibidinsya na dili matuod aged Jesus i masintinsyaan ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piro, bisan tama gaprani daw gatistigo ta dili matuod kuntra ki Jesus, ula man gyapon danen an may nakita na ibidinsya. Ta uryan, darwa na ittaw gaprani ");
INSERT INTO cgc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","daw gambal, “Nyan na ittaw gambal, ‘Masarangan ko gubbaen Balay Ta Dyos daw ipatindeg isab seled ta tallo nang na adlaw.’” ");
INSERT INTO cgc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pinakadatas na pari gatindeg daw painsaan din Jesus i, “Ula ka may isabat ta iran na ambal kuntra ki kaon?” ");
INSERT INTO cgc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piro, ula gid gasasaba Jesus i. Painsaan eman kanen i ta pinakadatas na pari, “Ta ngaran ta Dyos Na Bui, sugiran kay no daw kaon gid Pinili Ta Dyos Na Mag-ari na Bata Ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sabat Jesus, “Kaon en gambal san. Piro, sugiran ta kyo tanan, umpisa anduni, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan makita nyo na gamungko naan tengnged ta Dyos Na Makagagaem naan dapit ta tuo daw makita nyo man na kanen mabot na naan ta panganod naan ta kalangitan.” ");
INSERT INTO cgc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagmati ta pinakadatas na pari, pagisi din iya na kaugalingen na bayo ta subla din na kagilek. Gambal kanen an, “Iya na ambal insulto ta uturidad ta Dyos. Dili en kinanglan na may ittaw pa na magtistigo! Kyo mismo kamati na iya na ambal insulto ta uturidad ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta, ino inyo na disisyon?” Sabat danen tanan, “Nakasala kanen an. Dapat sintinsyaan ta kamatayen!” ");
INSERT INTO cgc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Duma an ki danen gaileb naan ta sura Jesus daw gatiro ki kanen. Duma man ya gatampaling ");
INSERT INTO cgc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na gambal danen, “Abi, daw kaon Pinili Ta Dyos Na Mag-ari, lagpaten no tuo! Kino gatampaling ki kaon?” ");
INSERT INTO cgc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na gamungko pa Pedro i naan ta sular ta istaran Caifas, isya na suguon na bai gaprani naan ki kanen daw mambal, “Di' ba kaon yan duma Jesus na taga-Galilea?” ");
INSERT INTO cgc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piro, ula gaako Pedro i. Pasabat din bai an na tanan na naan dya kamati man, “Ula a nalam daw ino paambal no an.” ");
INSERT INTO cgc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pag-ambal Pedro, giling kanen naan dani ta giyt. Naan dya nakita man kanen an ta isya pa na suguon na bai na gambal ta mga ittaw na gatindeg dya, “Yi na ittaw duma man Jesus na taga-Nazaret.” ");
INSERT INTO cgc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piro, ula eman gaako Pedro i. Ambal din, “Gasumpa a, dili ko kala ittaw na yan!” ");
INSERT INTO cgc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta ula nang lugay, mga ittaw na gatindeg dya gaprani ki Pedro daw gambal, “Kaon isya gid ki danen na duma ki Jesus tenged pang-ambal no an paryo gid ta pang-ambal ta mga taga-Galilea.” ");
INSERT INTO cgc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piro, ganapa gid Pedro i daw gambal, “Bisan silutan a pa, ula a gid kakala ta ittaw na yan!” Pag-ambal Pedro, dayon gatagaok manok. ");
INSERT INTO cgc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nademdeman Pedro ambal ya Jesus ki kanen, “Bag-o magtagaok manok, kambal ka en ta tallo bisis na dili a no kala.” Pagdemdem din, gagwa kanen i daw magal ta tudo ta pagnelsel. ");
INSERT INTO cgc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagsennang ta adlaw, tanan na mga manugdumala na mga pari daw mga gadumala ta mga Judio gasapol daw gasugtanay na dapat masintinsyaan Jesus i ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Papagapos danen kanen i daw padala na intriga naan ki Pilato na gubirnador ta prubinsya Judea. ");
INSERT INTO cgc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas i na gatraydor ki Jesus, na nlaman din na Jesus masintinsyaan ta kamatayen, nakunsinsya gid kanen i ta iya na nabuat. Giling kanen i naan ta mga manugdumala na mga pari daw mga gadumala ta mga Judio aged ibalik trinta na sinsilyo na pilak na bayad danen ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ambal din ki danen, “Nakasala a tak natrayduran ko daw naintriga naan ki kyo ittaw na ula gid sala.” Ambal danen, “Ino ki kami a? Imo na sabaten nyan en.” ");
INSERT INTO cgc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pagmati Judas ta iran na ambal, papesdak din kwarta ya naan ta saag ta Balay Ta Dyos daw galin dya. Giling kanen ta isya na lugar daw naan dya gapakamatay paagi ta pagbitay ta iya na kaugalingen. ");
INSERT INTO cgc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mga sinsilyo na papesdak Judas patimod ta mga manugdumala na mga pari. Ambal danen, “Kuntra ta Mga Sinulat Moises na iulog kwarta i naan ta ugsakan ta mga alad unti ta Timplo tak yi na kwarta suol ta pagpatay.” ");
INSERT INTO cgc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ta uryan, gasugtanay danen an na kwarta ya ipalit ta basak na iya ta isya na manugbuat ta kuron aged buaten danen na patyo para ta mga mapatay na istrangiro. ");
INSERT INTO cgc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tenged ta iran na pagpalit ta basak ya ta kwarta na suol ta pagpatay, asta anduni basak ya paumaw na Basak Ta Lengngessa daw ");
INSERT INTO cgc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","natuman man en ambal ya Jeremias na prupita anay pa sa. Ambal din, “Pakamang danen trinta na sinsilyo na pilak na sugtanan ta mga linai Israel na iprisyo para ta iya na kamatayen, ");
INSERT INTO cgc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","daw kwarta na ya papalit ta basak na iya ta manugbuat ta kuron paryo ta sugo ta Dyos ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na naan pa Jesus i gatindeg tubang ki Pilato, gainsa Pilato ki kanen, “Kaon ari ta mga Judio?” Sabat Jesus, “Kaon en gambal san.” ");
INSERT INTO cgc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Paakusar kanen an ta mga manugdumala na mga pari daw mga gadumala ta mga Judio, piro ula kanen gasabat. ");
INSERT INTO cgc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gainsa eman Pilato ki kanen, “Tama gid iran na akusar kuntra ki kaon. Man-o ula ka gasabat?” ");
INSERT INTO cgc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piro, maskin isya nang na ambal, ula gid gasabat Jesus i ta iran na mga akusar daw Pilato gatingala gid ta miad. ");
INSERT INTO cgc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kada Pista Ta Paglibri Alin Ta Egipto, kaugalian Pilato na magpalibri kanen an ta isya na priso na papangabay ta mga ittaw na librien. ");
INSERT INTO cgc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ta timpo na Jesus patubang ki Pilato, may priso na isya na kala gid na kriminal na ngaran din Barabas. ");
INSERT INTO cgc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na gatipon mga ittaw an naan ki Pilato, gainsa kanen ki danen, “Kino liag nyo na librien ko para ki kyo? Barabas o Jesus i na paumaw na Pinili Ta Dyos Na Mag-ari?” ");
INSERT INTO cgc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iling tan ambal din tak nlaman din na Jesus i paintriga ki kanen ta mga manugdumala tenged nang ta iran na inggit ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na Pilato gamungko na mag-ukom, may pasugo iya na sawa na ambalen ki kanen, “Dili ka magpasilabet ta nyan na ittaw na ula kabuat ta sala tak natublag a gid anduni tenged ta ake na dagammo parti ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Piro, mga manugdumala na mga pari daw mga gadumala ta mga Judio gakumbinsi ta mga ittaw na Barabas pilien danen na librien daw Jesus i a sintinsyaan ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gainsa isab Pilato i, “Kino ta darwa na mama liag nyo na librien ko?” Sabat danen, “Barabas!” ");
INSERT INTO cgc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ambal din, “Daw Barabas librien ko, ino buaten ko ki Jesus na paumaw na Pinili Ta Dyos Na Mag-ari?” Sabat danen tanan, “Ilansang kanen an naan ta krus!” ");
INSERT INTO cgc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Insa din, “Man-o, ino gid nabuat din an na sala?” Piro, patuduan pa gid danen iran an na singgit, “Ilansang kanen an naan ta krus!” ");
INSERT INTO cgc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na nakita Pilato na ula en kanen an sarang na mabuat pa tak umpisa en maggamo mga ittaw an, gapakamang kanen an ta waig daw naan ta tubangan ta mga ittaw gaugas kanen ta iya na lima daw gambal, “Ula a labet ta kamatayen ta ittaw na i! Inyo nyan en na sabaten!” ");
INSERT INTO cgc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sabat ta mga ittaw, “Kami daw ame na mga kabataan manabat ta iya na kamatayen.” ");
INSERT INTO cgc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pagsabat ta mga ittaw, palibri din Barabas ya. Gasugo kanen na Jesus i latiguon daw intriga naan ta mga sundalo na maglansang ki Jesus naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Padala ta mga sundalo ta gubirnador Jesus i naan ta iran na kampo na naan ta selled ta sular ta Pretorio na palasyo ta gubirnador. Patipon danen libot ki Jesus tanan na sundalo ta iran na batalyon na naan dya gakampo. ");
INSERT INTO cgc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Palubbas danen bayo din an daw pasuutan ta kapa na kulor minog. ");
INSERT INTO cgc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Galubid danen ta blagen ta telleken na tanem daw pabuat na kuruna. Pabetang danen naan ta ulo Jesus daw papaibit danen iya na tuo na lima ta baston. Galuod danen an naan ta tubangan din daw papagayyaan na ambal danen, “Mabuay ari ta mga Judio!” ");
INSERT INTO cgc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Paileban danen kanen i daw pakamang iya an na paibitan na baston daw pukpok naan ta iya na ulo. ");
INSERT INTO cgc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagtapos danen ta pagpagayya ki kanen, pakamang danen kapa ya daw pasuutan isab kanen an ta iya na bayo daw padala mwa ta syudad aged ilansang naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na Jesus i padala ta mga sundalo pagwa ta syudad, nasugat danen mama na taga-Cirene na ngaran din Simon. Papilit danen kanen i na pas-anen krus an na lansangan ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagpas-an din, gapadayon danen ta iran na pagdala ki Jesus asta ta lugar na paumaw na Golgota na beet ambalen Bungyod Balbagol. ");
INSERT INTO cgc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pag-abot danen dya, papainem danen Jesus i ta bino na may simbog na pait, piro na natilawan din, dili kanen i miag minem. ");
INSERT INTO cgc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Palansang danen kanen i naan ta krus daw pagtapos ta paglansang, paulas-ulas danen iya na mga bayo paagi ta paggabot-gabutay. ");
INSERT INTO cgc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagtapos danen ta ulas ta iya na mga bayo, gapungko danen an daw gabantay ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naan dapit ta apaw ta ulo Jesus nabetang karatula na naan dya nasulat akusar kuntra ki kanen. Iling ti nasulat ya: YI JESUS, ARI TA MGA JUDIO. ");
INSERT INTO cgc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na kanen i palansang naan ta krus, darwa na matakaw palansang man naan ta mga krus. Krus an ta mga matakaw patindeg na isya an naan dapit ta iya na tuo daw isya an a, naan dapit ta wala. ");
INSERT INTO cgc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mga ittaw na galambay dya gatande-tande gid ta pag-insulto ki Jesus ");
INSERT INTO cgc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na danen an gambal, “Ambal no gubbaen no Balay Ta Dyos daw patindegen isab seled ta tallo adlaw! Daw kaya no iling an tan, luwasen no imo an na kaugalingen! Daw kaon Bata Ta Dyos, manaog ka dyan ta krus yan!” ");
INSERT INTO cgc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iling man tan, Jesus i papagayyaan ta mga manugdumala na mga pari, mga manugtudlo ta Mga Sinulat Moises daw mga gadumala ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ambal danen, “Lagen nyo ittaw na yan! Paluwas din kabui ta duma na mga ittaw, piro iya an na kaugalingen na kabui dili din maluwas. Kanen kon ari ta mga linai Israel! Dapat manaog kanen an dayon anduni alin ta krus aged patian ta kanen an. ");
INSERT INTO cgc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Gasalig kanen an ta Dyos, lagen ta abi daw Dyos nalipay ki kanen daw luwasen kanen an tak paako din na kanen kon Bata Ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Papagayyaan man kanen an ta mga matakaw na pasilutan ta kamatayen duma ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na ugto-adlaw en, gadelem bilog na lugar dya asta ta tallo uras. ");
INSERT INTO cgc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pag-abot ta katapusan ta pangallo na uras na gadelem, gasinggit Jesus i na bakod iya na kagi, “Eli, Eli, lema sabactani?” na beet ambalen, “Dyos ko, Dyos ko, man-o tak pabay-an a no?” ");
INSERT INTO cgc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Duma na mga ittaw na gatindeg dani ki Jesus kamati ta iya na singgit daw ambal danen, “Paumaw din Elias ya!” ");
INSERT INTO cgc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Isya ki danen gadlagan na mamang ta ispunga. Pasawsaw din ispunga an naan ta agsem na bino daw pabetang din naan ta ugbos ta baston daw padeel naan ta baba Jesus aged na masepsep. ");
INSERT INTO cgc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Duma na mga ittaw gambal, “Largaan nyo nang kanen an. Lagen ta abi daw mabot gid Elias ya daw luwasen kanen an.” ");
INSERT INTO cgc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Gasinggit isab Jesus i na bakod iya na kagi daw patugyan din iya na ispiritu naan ta Dyos daw nabugto iya na ginawa. ");
INSERT INTO cgc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kurtina ya naan ta Balay Ta Dyos dayon nagisi na tenga gid alin ta apaw paebes. Galinog kalibutan i daw mga darko na bato nabiak. ");
INSERT INTO cgc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gaabri man mga lebbengan an daw tama na mga ittaw na iya ta Dyos nabannaw. ");
INSERT INTO cgc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gagwa danen an naan ta iran na mga lebbengan daw pagtapos ta pagbannaw ki Jesus, giling danen an naan ta Jerusalem na syudad ta Dyos daw tama na mga ittaw kakita ki danen. ");
INSERT INTO cgc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Upisyal ta sundalo daw iya na mga sakep na gabantay ki Jesus, na nabatyagan danen paglinog ya daw nakita danen tanan na natabo, nadlek gid danen an daw gambal, “Matuod gid man! Ittaw na yan Bata Ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tama na mga bai na naan gatindeg ta madyo na gatan-aw ta mga natabo. Danen an mga bai na kakuyog ki Jesus na galin kanen ta Galilea aged magtabang ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Anen man dya danen i Maria Magdalena, Maria na inay Santiago daw Jose, daw sawa Zebedeo. ");
INSERT INTO cgc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","May manggaranen na mama na taga-Arimatea na ngaran din Jose. Kanen isya ta mga ittaw na gapati ki Jesus. Na mapon gid en ta yo man na adlaw na Jesus napatay, ");
INSERT INTO cgc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","giling Jose i ki Pilato daw galisinsya na kanen mamang ta lawa Jesus. Gasugo Pilato an na iatag naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pakamang Jose lawa ya Jesus naan ta krus daw putuson paagi ta pagblebed ta maalen na tila na lino na bag-o. ");
INSERT INTO cgc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pabetang din lawa ya Jesus naan ta bag-o din papabuat na lebbengan na bato na palungagan na paryo ta kwiba. Pasaraan din lebbengan an ta bakod na bato na papaligid naan ta gangaan daw galin kanen dya. ");
INSERT INTO cgc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena daw isya pa na Maria anen man dya na gamungko na gatubang naan ta lebbengan. ");
INSERT INTO cgc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ta Adlaw Ta Pagpuay na yon man adlaw na sunod ta adlaw ta pagpriparar, mga manugdumala na mga pari daw mga Pariseo giling naan ki Pilato. ");
INSERT INTO cgc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gambal danen ki Pilato, “Pataod na Gubirnador, may nademdeman kay. Na bui pa yo na bula na ittaw, ambal din na daw mapatay kanen, mabannaw kon kanen ta pangallo na adlaw. ");
INSERT INTO cgc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Miad taan daw pabantayan no iya an na lebbengan asta ta pangallo na adlaw tak basi daw iya an na lawa takawen ta mga tinudluan din daw panugid-sugid man danen naan ta mga ittaw na nabannaw kanen ya. Daw iling tan matabo, mas lain pa gid uryan an na panluko danen kaysa ta una ya na kanen gambal na kanen kon Pinili Ta Dyos Na Mag-ari.” ");
INSERT INTO cgc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ambal Pilato, “Sigi, magdala kaw ta mga sundalo daw kyo nang en bala na magpabantay ta usto ta lebbengan ya tak kyo nalam daw ino dapat buaten.” ");
INSERT INTO cgc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pag-ambal Pilato, mga Pariseo daw mga manugdumala na mga pari giling naan ta lebbengan duma ta mga sundalo. Pabetangan danen ta tanda bato ya na sara aged mlaman daw may galigid ta bato ya. Papabantayan man danen ta mga sundalo lebbengan ya. ");
INSERT INTO cgc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lambay en Adlaw Ta Pagpuay. Pagsennang nang pa ta adlaw naan ta una na adlaw ta duminggo, Maria Magdalena i daw isya pa na Maria giling naan ta lebbengan Jesus aged bistaan. ");
INSERT INTO cgc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gulpi nang galinog ta biskeg tak may angil na gabot alin ta langit na papadala ta Ginuo Dyos. Giling kanen an naan ta lebbengan daw paligid din bato ya na sara daw naan kanen dya gapungko. ");
INSERT INTO cgc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Iya an na sura sikad silaw na paryo ta kilat daw iya an na bayo sikad gid puti. ");
INSERT INTO cgc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pagkita ta mga gwardya na naan man dya, gakereg danen ta subla na kaadlek daw natumba na paryo danen an mga patay. ");
INSERT INTO cgc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Gambal angil an naan ta mga bai, “Dili kaw madlek. Nlaman ko na papangita nyo Jesus ya na nalansang naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ula di en. Paryo ta iya na naambal, kanen ya pabannaw en ta Dyos. Marani kaw di daw lagen nyo nabetangan ta iya na lawa. ");
INSERT INTO cgc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Miling kaw dayon naan ta iya na mga tinudluan daw sugiran nyo danen ya na kanen pabannaw en ta Dyos daw gauna kanen ya ki danen naan ta Galilea. Naan danen dya makita kanen ya. Ta, pasugid ko en iya na tugon para ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Gadali-dali ta pag-alin mga bai ya naan ta lebbengan na may kaadlek, piro bakod iran na kalipay. Gadlagan danen an munta ta mga tinudluan aged magsugid. ");
INSERT INTO cgc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na gadlagan danen i, nali nang, gasugat Jesus i ki danen daw magbugno. Gaprani danen an ki kanen daw magluod na gadapa daw mibit naan ta iya na batiis ta pagdayaw ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Gambal Jesus i ki danen, “Dili kaw madlek. Manaw kaw daw sugiran nyo ake na mga tinudluan na yon man mga pakabig ko na ake na mga utod na miling danen an naan ta Galilea daw naan kay dya magkitaay.” ");
INSERT INTO cgc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na gapadayon mga bai ya munta naan ta mga tinudluan Jesus, duma an na mga sundalo na gagwardya naan ta lebbengan gabalik naan ta syudad. Pasugid danen naan ta mga manugdumala na mga pari tanan ya na natabo na nakita danen naan ta lebbengan. ");
INSERT INTO cgc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tenged ta sugid ta mga sundalo, gasapol daw gasugtanay mga manugdumala an na mga pari daw mga gadumala ta mga Judio daw ino iran na buaten. Pabayaran danen mga sundalo an ta bakod na kantidad daw ");
INSERT INTO cgc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","pasugo danen, “Ibalita nyo ta mga ittaw na mintras gatunuga kaw kabii kilem, giling dya mga tinudluan ya Jesus daw patakaw danen iya ya na lawa naan ta lebbengan. ");
INSERT INTO cgc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Daw mabalitaan ta gubirnador na lawa ya patakaw, dili kaw magpalibeg tak kami nang en bala ki kanen aged mapati kanen an na ula kaw labet.” ");
INSERT INTO cgc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pabaton dayon ta mga gwardya kwarta ya daw patuman danen pasugo ya ki danen. Gani, alin sa asta anduni, iling tan isturya ya na napalapta naan ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Unsi ya na apustulis giling naan ta isya na bukid ta Galilea na paambal Jesus na ilingan danen. ");
INSERT INTO cgc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na nakita danen Jesus i, galuod danen ta pagdayaw ki kanen bisan na duma an ki danen gadua-dua pa. ");
INSERT INTO cgc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gaprani Jesus i ki danen daw gambal, “Naatag en ta ake na Amay ki yaken tanan na uturidad na magdumala ta tanan na naan ta langit daw naan ta kalibutan. ");
INSERT INTO cgc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gasugo a ki kyo na ilingan nyo daw tudluan mga ittaw naan ta bilog na kalibutan aged danen an magsunod man ta ake na natudlo. Iling tan buaten nyo paagi ta pagbautismo nyo ki danen ta ngaran ta Dyos Amay, Dyos Anak, daw Dyos Ispiritu Santo ");
INSERT INTO cgc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","daw paagi man ta pagtudlo nyo ki danen na magtuman danen ta tanan na pasugo ko ki kyo. Demdemen nyo gid na ta tanan na uras yaken i duma ki kyo asta ta katapusan ta yi na timpo.”");
INSERT INTO cgc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yi sinulat parti ta kaumpisaan ta miad na balita parti ki Jesu-Cristo na Bata Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Umpisa miad i na balita paryo gid ta ambal ta Dyos na nasulat Isaias na prupita anay pa sa. Yi ambal ta Dyos, “Ipadala ko una ki kaon ake na manugsugid aged ipriparar din agian ta imo na pag-abot.” ");
INSERT INTO cgc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kanen “ittaw naan ta lugar na ula kabalayan na galaygay na bakod iya na kagi. Ambal din ta mga ittaw, ‘Ipriparar nyo agian an para ta pag-abot ta Ginuo. Tadlengen nyo dalan an na agian din!’” ");
INSERT INTO cgc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Natuman sinulat Isaias na giling Juan naan ta lugar na ula kabalayan daw naan dya gawali ta mga ittaw na danen an kinanglan magnelsel daw dilian iran an na mga sala para patawaren danen an ta Dyos. Pawali din man na dapat na pamatuuran danen iran na pagnelsel paagi ta pagpabautismo naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sikad tama na mga ittaw giling ki kanen alin ta syudad Jerusalem daw duma pa na mga banwa ta bilog na prubinsya Judea. Gaamin danen an ta iran na mga sala daw pabautismuan din danen an naan ta Suba Jordan. ");
INSERT INTO cgc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan i gabayo ta mga nauman alin ta belbel ta kamilyo daw iya an na bakles buat alin ta langgit ta ayep. Pagkaan din an mga apan-apan daw deges ta putyukan. ");
INSERT INTO cgc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iling ti pawali din man naan ta mga ittaw, “May mabot sunod ki yaken na mas datas iya na katengdanan kaysa ta ake na katengdanan. Dili a bagay na magsirbi ki kanen maskin na magdemel na magbadbad ta igot ta iya na sandal tak datas gid iya na katengdanan. ");
INSERT INTO cgc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yaken gabautismo ki kyo paagi nang ta waig, piro kanen ya a magbautismo ki kyo paagi ta Dyos Ispiritu Santo.” ");
INSERT INTO cgc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ta yon man na timpo na tama na mga ittaw gapabautismo ki Juan, galin Jesus i ta banwa Nazaret na sakep ta Galilea daw miling ki Juan. Pabautismuan kanen i Juan naan ta Suba Jordan. ");
INSERT INTO cgc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na nabautismuan en Jesus i daw gatakas kanen ta waig, dayon gabukas langit an daw Dyos Ispiritu Santo an gapababa naan ki kanen paryo ta salampati. ");
INSERT INTO cgc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","May namatian na gambal na naan ta langit, “Kaon ake na bata na palangga ko. Nalipay a gid ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pagtapos ta pagbautismo ki Jesus, dayon kanen i padala ta Dyos Ispiritu Santo na miling naan ta lugar na ula kabalayan. ");
INSERT INTO cgc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Naan dya gatinir kanen i ta kwarinta na adlaw daw patintar kanen i Satanas. May anen man dya mapintas na mga ayep, piro paasikaso kanen i ta mga angil. ");
INSERT INTO cgc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Napriso Juan ya na manugbautismo daw giling dayon Jesus i naan ta Galilea daw gawali ta miad na balita na alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ambal din, “Abot en uras na naan ta plano ta Dyos. Anduni abot en upurtunidad na makapasakep kaw naan ta papaabot nyo na pagdumala ta Dyos! Magnelsel kaw daw dilian nyo inyo an na mga sala daw magpati ta miad na balita.” ");
INSERT INTO cgc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na gapanaw Jesus i naan ta kilid ta Dagat Galilea, nakita din mag-utod na mananagat na Simon daw Andres na danen an galaya. ");
INSERT INTO cgc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Gambal Jesus i ki danen, “Muyog kaw ki yaken aged imuon ta kyo na ake na mga tinudluan. Paryo ta ubra nyo na kyo yan mananagat ta sidda yon man imuon ta kyo na mananagat ta mga ittaw tak tudluan ta kyo na maglaygay ta mga ittaw na magpasakep danen ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pag-ambal Jesus, pabilin dayon danen iran ya na mga laya daw gakuyog ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gapadayon Jesus ta pagpanaw naan ta kilid ta dagat daw naan ta unaan nakita din mag-utod na Santiago daw Juan na mga kabataan Zebedeo. Naan danen an ta iran na buti na gapuna danen an ta iran na pukot. ");
INSERT INTO cgc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Paumaw Jesus danen an daw padilian dayon danen iran na amay naan ta buti duma ta mga ittaw na pasuulan daw gakuyog danen an ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus i daw iya an na mga tinudluan giling naan ta banwa na Capernaum. Naan ta Adlaw Ta Pagpuay, gaselled kanen i naan ta balay tipunan daw gatudlo ta mga ittaw dya. ");
INSERT INTO cgc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gatingala gid mga ittaw ya ta iya na panudluon tak kanen an gatudlo alin ta iya gid na alam. Dili kanen an paryo ta mga manugtudlo ta Mga Sinulat Moises tak patudlo danen naan nang alin ta alam ta duma na ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Naan man ta balay tipunan may mama na naseddepan ta malain na ispiritu na gasinggit, ");
INSERT INTO cgc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus na taga-Nazaret, man-o tak anen ka di? Giling ka di taan aged silutan kay? Kala ta kaw daw kino ka! Kaon yan alin gid ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Paay Jesus malain ya na ispiritu, “Sagbak! Mwa ka dyan ki kanen!” ");
INSERT INTO cgc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pag-ambal din, ittaw ya gapegpeleg tenged ta malain na ispiritu daw ispiritu ya gasinggit na gagwa naan ta ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pagkita ta mga ittaw dya na napagwa Jesus malain ya na ispiritu, gatingala gid danen an daw gainsaay, “Uy! Ino taan ni? Bag-o gid na panudluon! May uturidad kanen an na bisan mga malain na ispiritu gatuman ki kanen. Na pasugo din danen an na maggwa, dayon man tuman!” ");
INSERT INTO cgc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dasig paglapta naan ta bilog na Galilea balita an parti ta mga nabuat Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus i galin ta balay tipunan duma ki Simon daw Andres na miling naan ta balay danen Simon. Gakuyog man Santiago daw Juan. ");
INSERT INTO cgc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Naan ta balay Simon, pasugiran dayon Jesus i ta mga ittaw dya na ugwangan Simon na bai ganegga tak nadangga. ");
INSERT INTO cgc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Papranian Jesus kanen an daw paibitan naan ta lima daw bangunon. Gapuas dayon iya na dangga daw gaimes kanen an ta pagkaan para ki danen Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na mapon en na pasalep adlaw an, padala naan ki Jesus tanan na mga ittaw na may masakit naan ta banwa na iran Simon daw mga naseddepan ta malain na mga ispiritu. ");
INSERT INTO cgc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tama gid na mga ittaw gatipon naan ta tubangan ta balay ya na paryo naan dya bilog na banwa. ");
INSERT INTO cgc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Paayad Jesus tama na mga ittaw ta iran na mga masakit daw papagwa din man tama na malain na ispiritu na naan ta mga ittaw. Paay din na dili mag-ambal mga malain an na ispiritu tak nlaman danen daw kino kanen an. ");
INSERT INTO cgc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na mapit-madlaw, gabangon Jesus i daw miling naan ta lugar na ula kabalayan daw mangamuyo. ");
INSERT INTO cgc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon i daw iya na mga duma gangita ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkita danen ki kanen, gambal danen, “Tama gangita ki kaon!” ");
INSERT INTO cgc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Piro, ambal din, “Miling ki naan ta mga banwa na dani nang aged magsugid ta miad na balita naan ta mga ittaw tak iling tan ake na tuyo ta pag-iling naan ta mga banwa.” ");
INSERT INTO cgc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tenged iling tan ambal Jesus, galibot kanen an ta bilog na Galilea. Naan ta mga balay tipunan ta mga Judio gasugid kanen ta miad na balita. Gapagwa man kanen an ta mga malain na ispiritu na naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","May gaprani ki Jesus na mama na may segeng na masakit ta langgit. Galuod kanen an daw gapakiluoy, “Daw gusto no, mapaayad a no ta ake na masakit.” ");
INSERT INTO cgc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naluoy gid Jesus i daw pabitan din mama an daw ambal din, “Gusto ko! Mayad ka!” ");
INSERT INTO cgc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pag-ambal Jesus, nakamang dayon masakit ta langgit ta mama an daw naayad en. ");
INSERT INTO cgc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pagpaayad Jesus ta mama, papanaw din dayon ");
INSERT INTO cgc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","na paambalan gid, “Dili ka mugid naan ta bisan kino parti ta ake na pagpaayad ki kaon. Magdiritso ka nang naan ta pari daw magpatan-aw na nayad ka en. Magdala ka man ta alad na igo ta sugo ta Dyos naan ta Mga Sinulat Moises parti ta mga napaayad alin ta segeng na masakit ta langgit aged may pamatuod ka naan ta mga ittaw na nayad ka en.” ");
INSERT INTO cgc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piro, gapanaw mama ya daw bisan indi kanen punta palapta din balita na paayad Jesus kanen ya. Tenged ta pagsugid ta mama ya, Jesus i dili en kaselled ta maskin indi na banwa na kanen i makita ta tama na mga ittaw tak tama magtipon ki kanen. Naan nang en kanen ta gwa ta mga banwa naan ta mga lugar na ula kabalayan. Piro, sigi man gyapon iling mga ittaw an naan ki kanen alin ta lain-lain na mga lugar. ");
INSERT INTO cgc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paglambay ta pila na mga adlaw, Jesus i gabalik daw melled naan ta Capernaum. Galapta balita na naan en kanen i ta ulian din na balay. ");
INSERT INTO cgc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sikad tama na mga ittaw gatipon dya. Ula en pwistuan duma an bisan naan ta gwa ta gangaan. Na gatudlo Jesus i ki danen parti ta ambal ta Dyos, ");
INSERT INTO cgc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","may giling dya na appat na ittaw. Patuwangan danen isya na mama na dili kapanaw. ");
INSERT INTO cgc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tenged ta katamaen ta mga ittaw, dili danen an kaprani naan ki Jesus. Gapanaik danen an naan ta apaw ta atep ta balay daw pabusluan danen na usoy naan ta patindegan Jesus. Pagbuslo danen ta atep, naan dya danen patunton mama ya na ganegga ta iya na neggaan. ");
INSERT INTO cgc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na nakita Jesus na danen an gasalig gid ki kanen na mapaayad din mama an, gambal kanen i ta mama an, “Tong, napatawad en imo an na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","May mga manugtudlo ta Mga Sinulat Moises na gamungko dya daw gambal ta iran na kaugalingen, ");
INSERT INTO cgc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Man-o tak gambal kanen an ta iling tan? Iya na ambal insulto ta uturidad ta Dyos! Ula duma na makapatawad ta mga sala daw dili, Dyos nang!” ");
INSERT INTO cgc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Piro, nlaman Jesus na gaisip danen an ta iling tan daw dayon paambalan din, “Man-o tak gaisip kaw ta iling tan? ");
INSERT INTO cgc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Indi ta darwa na i mas dali nang buaten ko naan ta yi na mama na dili kapanaw? Ambalen ko na napatawad en iya na mga sala, o ambalen ko na kanen an mangon daw mangen din iya na neggaan daw manaw? Simpri darwa i paryas nang na dali buaten tak iling an tan mabuat paagi nang ta gaem daw uturidad ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pamatuuran ko ki kyo na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan may uturidad naan ta kalibutan i na magpatawad ta mga sala.” ");
INSERT INTO cgc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Dayon, gambal Jesus i ta mama na dili kapanaw, “Gasugo a ki kaon, mangon ka! Dleen no neggaan no an daw muli.” ");
INSERT INTO cgc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Naan ta tubangan ta tanan na mga ittaw, gabangon mama an daw pabitbit din dayon iya na neggaan daw mwa. Gatingala gid danen tanan daw gadayaw ta Dyos. Ambal danen, “Ula kay pa kakita na paryo ti!” ");
INSERT INTO cgc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Giling isab Jesus i naan ta kilid ta Dagat Galilea. Sikad tama na mga ittaw giling ki kanen daw patudluan din danen an. ");
INSERT INTO cgc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na natapos en Jesus ta pagtudlo, gapanaw kanen i daw nakita din isya na manugsukot ta buis na ngaran din Levi na bata Alfeo. Gamungko Levi i naan ta bayaran ta buis. Gambal Jesus i ki kanen, “Muyog ka ki yaken aged kaon isya man ta ake na mga tinudluan.” Pag-ambal Jesus, gatindeg dayon Levi i daw muyog. ");
INSERT INTO cgc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na Jesus i gakaan naan ta balay Levi, iya na mga tinudluan gakaan duma ki kanen. Gakaan man duma ki danen Jesus tama na mga manugsukot ta buis daw makasasala na mga ittaw tak tama na mga ittaw na iling tan gakuyog ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","May mga manugtudlo ta Mga Sinulat Moises na mimbro man ta grupo ta mga Pariseo na kakita na Jesus i gakaan duma ta mga manugsukot ta buis daw makasasala na mga ittaw. Gainsa danen an ta mga tinudluan Jesus, “Man-o tak gakaan kanen an duma ta mga manugsukot ta buis daw makasasala na mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na namatian Jesus insa ya danen, sabat din, “Mga ittaw na miad iran na lawa ula gakinanglan ta duktor. Piro, mga ittaw an a na may masakit, danen gakinanglan ta duktor. Nyan na ula a giling di para manggat ta mga ittaw na salig danen na matareng danen an. Giling a di para manggat ta mga ittaw na makasasala aged magsunod danen an ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mga tinudluan Juan na manugbautismo daw mga Pariseo man, pirmi danen gapwasa. May mga ittaw na giling ki Jesus daw minsa ki kanen, “Man-o tak mga tinudluan Juan daw mga tinudluan man ta mga Pariseo gapwasa, piro imo an a, ula danen gapwasa?” ");
INSERT INTO cgc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Gasabat Jesus i, “Daw may kumbira ta kasal, impusibli na mga paimbitar an magpwasa mintras mama na bag-o nang kasal anen pa don duma ki danen! Daw kanen duma pa ki danen, dili danen magpwasa! ");
INSERT INTO cgc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piro, mabot adlaw na kanen an kamangen naan ki danen. Yon en uras na danen an magpwasa.” ");
INSERT INTO cgc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Gambal pa Jesus i, “Ula bisan kino na gatupak ta bag-o na tila na ula pa nabunaki naan ta daan na bayo. Daw iling tan buaten din, mag-itad tinai ya naan ta bayo daw magbakod pa gid gisi an ta bayo tenged gakeddet tupak ya. ");
INSERT INTO cgc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iling man tan, ula bisan kino na gaugsak ta bag-o na bino na dili pa iseg na gabula pa naan ta daan na ugsakan na langgit na ula en gainat. Daw iling tan buaten din, mabustik ugsakan tenged ta pagbula ta bino. Masayang bino daw ugsakan man. Dapat bag-o buat na bino iugsak naan ta bag-o buat na ugsakan na langgit na gainat pa.” ");
INSERT INTO cgc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ta Adlaw Ta Pagpuay, Jesus i daw iya na mga tinudluan gaagi naan ta isya na triguan. Na gaagi dya danen an, mga tinudluan din gaugot ta pila na mga passi ta trigo aged kan-enen. ");
INSERT INTO cgc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","May mga Pariseo na gambal ki Jesus, “Lagen no ubra ta imo na mga tinudluan. Man-o tak gabuat danen an ta iling sa na kuntra ta mga sugo parti ta Adlaw Ta Pagpuay?” ");
INSERT INTO cgc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Sabat Jesus, “Paryo kaw inyo na ula kabasa parti ta pabuat Ari David naan ta timpo Abiatar na pinakadatas na manugdumala ta mga pari na nletem gid David ya daw iya na mga duma tak ula makaan! Giling David ya naan ta balay ta Dyos daw gakaan ta tinapay na paalad para ta Dyos. Patagan din man iya na mga duma. Piro, maskin mga pari nang patugutan na maan ta tinapay na paalad para ta Dyos, buat ya danen Ari David ula pabilang na kuntra ta mga sugo Moises.” ");
INSERT INTO cgc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Gambal pa Jesus i ki danen, “Adlaw Ta Pagpuay pabuat ta Dyos para ta kayaran ta mga ittaw. Mga ittaw an ula pabuat ta Dyos para ta Adlaw Ta Pagpuay. ");
INSERT INTO cgc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Gani, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan may uturidad na magbeet daw ino tugot na buaten maskin naan ta Adlaw Ta Pagpuay.” ");
INSERT INTO cgc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na gaselled isab Jesus i naan ta balay tipunan, naan dya may mama na isya din an na lima kimay. ");
INSERT INTO cgc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Naan man dya pila na mga ittaw na gapanilag gid ki Jesus daw ayaren din mama an naan ta Adlaw Ta Pagpuay tak papangitaan danen kanen i ta sala aged maakusaran. ");
INSERT INTO cgc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Gambal Jesus i ta mama na lima din an kimay, “Mindeg ka daw mubang naan ta mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pag-ambal Jesus ta mama ya, gainsa kanen naan ta mga ittaw, “Naan ta Mga Sinulat Moises, ino patugot na buaten ta naan ta Adlaw Ta Pagpuay? Indi ti: Magbuat ki ta miad, magbuat ki ta malain? Magluwas ki ta mga ittaw, magpatay ki ta mga ittaw?” Pag-ambal din, ula gid may gasabat ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Patan-aw din danen an na naan ta iya na palibot na may kagilek kanen an. Galain beet din an tak dessen iran na tagipusuon. Ambal din ta mama ya, “Untayen no imo na lima na kimay.” Dayon, pauntay ta mama iya na lima daw nayad en. ");
INSERT INTO cgc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Galin dya dayon mga Pariseo daw gasapol danen an duma ta mga ittaw na gasunod ki Herodes daw ino paagi na Jesus an ipapatay danen. ");
INSERT INTO cgc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Gapanaw Jesus i daw iya na mga tinudluan na miling naan ta kilid ta Dagat Galilea. Gasunod man ki danen sikad tama na mga ittaw na naan galin ta Galilea daw Judea. ");
INSERT INTO cgc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tama man na mga ittaw naan galin ta Jerusalem, lugar na Idumea, liyo ta Suba Jordan daw mga lugar na dani ta mga banwa na Tiro daw Sidon tak nabalitaan danen parti ta mga pabuat Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tenged sikad tama na mga ittaw dya, pasugo Jesus iya an na mga tinudluan na mag-anda ta isya na buti aged daw magginetek gid man mga ittaw, may masakayan kanen an. ");
INSERT INTO cgc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tenged na tama en napaayad din, mga ittaw na may masakit na naan dya gasel-et gid naan ta mga ittaw aged magtandeg nang danen ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Naan man dya, na nakita Jesus i ta mga malain na ispiritu, mga ittaw na naseddepan danen gadapa naan ta tubangan din daw gasinggit mga malain na ispiritu, “Kaon Bata Ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Paambalan din gid mga malain na ispiritu na dili mugid naan ta mga ittaw daw kino kanen an. ");
INSERT INTO cgc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gatukad Jesus i naan ta isya na bukid na patipon din mga liag din an na pakuyugon. ");
INSERT INTO cgc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Naan dya, patagan din ta katengdanan na paumaw na apustulis dusi an na pakuyog din aged magduma ki kanen daw ipadala din man na magwali parti ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Patagan din man danen an ta uturidad na magpagwa ta mga malain na ispiritu naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yi dusi na napili din: Simon na pangaranan din na Pedro, ");
INSERT INTO cgc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mag-utod na Santiago daw Juan na mga kabataan Zebedeo na danen an pangaranan din man na Boanerges na beet ambalen mga bata ta dageeb. ");
INSERT INTO cgc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Napili din man danen Andres, Felipe, Bartolome, Mateo, Tomas, Santiago na bata Alfeo, Tadeo, Simon na Makabanwa ");
INSERT INTO cgc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","daw Judas Iscariote na ta uryan magtraydor ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na guli en Jesus i, gaginetek isab sikad tama na mga ittaw, ino pa ula en kanen timpo na maan daw iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na namatian ta iya na pamilya na ula kanen timpo maan, giling danen an dya aged kamangen kanen i tak gambal danen na kanen ula en naan ta igo na isip. ");
INSERT INTO cgc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","May mga manugtudlo ta Mga Sinulat Moises na naan galin ta Jerusalem na gambal, “Naseddepan kanen an Satanas na pangulo ta mga malain na ispiritu. Yon man na napagwa din mga malain na ispiritu paagi ta gaem na alin ki Satanas.” ");
INSERT INTO cgc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Paumaw Jesus mga ittaw an na marani ki kanen. Gaisturya kanen i ki danen paagi ta isya na alimbawa, “Ino pagpagwa Satanas ta paryo din man na Satanas? ");
INSERT INTO cgc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Daw mga sinakepan ta isya na kaarian magkuntraay, iran na kaarian dili magpadayon. ");
INSERT INTO cgc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iling man tan isya na panimalay. Daw mga ittaw na naan ta isya na panimalay magkuntraay, magubba man iran an na pamilya. ");
INSERT INTO cgc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Daw kuntraen Satanas iya an na kaugalingen na yon man kanen daw iya an na mga sinakepan magbelagay, dili magpadayon iya an na pagdumala. Mapirdi gid kanen an. ");
INSERT INTO cgc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Daw may ittaw na liag melled daw mamang ta mga pagkabetang naan ta balay ta iseg na ittaw, impusibli na kaselled kanen an daw dili din anay magapos iseg ya na ittaw. Daw nagapos en, sigurado gid na makamang din en mga pagkabetang naan ta balay. ");
INSERT INTO cgc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iling man tan na sarang ko pagwaen mga malain na ispiritu. Sugiran ta kyo na tanan na sala ta mga ittaw daw mga ambal danen na malain na kuntra ta Dyos mapatawad pa. ");
INSERT INTO cgc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Piro, daw kino mag-ambal ta malain kuntra ta Dyos Ispiritu Santo, dili kanen an mapatawad. Iling tan na sala, dala-dala din ta ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Paambal Jesus iling tan tak ambal ta mga manugtudlo ta Mga Sinulat Moises na kanen i naseddepan ta malain na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na gatudlo Jesus i ta mga ittaw, gabot iya na mga utod na mama daw iya na inay. Gatindeg danen an naan ta gwa daw papaumaw danen Jesus i. ");
INSERT INTO cgc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tama na mga ittaw gamungko palibot ki kanen daw isya ki danen gasugid, “Naan ta gwa imo ya na inay daw mga utod na gangita ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Gainsa Jesus i, “Kino ake an na inay daw mga utod?” ");
INSERT INTO cgc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pag-insa din, gatan-aw kanen an naan ta mga ittaw na gamungko palibot ki kanen daw ambal din pa ki danen, “Kyo yan pabilang ko na ake na inay daw mga utod ");
INSERT INTO cgc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","tak daw kino gasunod ta kabebet-en ta Dyos, danen pabilang ko na ake na mga utod daw inay.” ");
INSERT INTO cgc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gatudlo isab Jesus i naan ta kilid ta Dagat Galilea. Sikad tama na mga ittaw giling dya daw gatipon naan ki kanen. Tenged sikad tama ittaw, gasakay kanen i naan ta buti na gapundo daw mungko. Mga ittaw an a, naan danen ta kilid ta dagat. ");
INSERT INTO cgc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tama iya na patudlo ki danen paagi ta mga paanggid na isturya. Ta iya na pagtudlo ki danen iling ti ambal din, ");
INSERT INTO cgc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mamati kaw! May mangunguma na giling ta iya na uma aged magsabwag ta binni. ");
INSERT INTO cgc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ta iya na pagsabwag, may mga binni na katupa naan ta dalan. Mga yupan gaprani daw mga binni an ubos danen ta tuktok. ");
INSERT INTO cgc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Duma an na binni katupa naan ta batuan na may tappaw nang na basak. Tenged tappaw nang, ula nang lugay nanlisok en mga binni an. ");
INSERT INTO cgc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Na ugto-adlaw en, galayeng daw gakeseg tak babaw nang mga gamot an. ");
INSERT INTO cgc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Duma man an na binni katupa naan ta basak na natubuan ta mga telleken na lamunon. Na gatubo en mga lamunon, nalemmes mga binni ya na gatubo. Gani, ula namunga. ");
INSERT INTO cgc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Piro, duma pa gid na binni katupa naan ta dayad na basak daw gatubo, gabakod daw namunga. May bunga na gapungpong ta trinta na passi, may anen man sisinta daw may anen pa man isya gatos.” ");
INSERT INTO cgc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gambal pa Jesus i, “Daw kino liag magbaton ta ake i na ambal, isipen din gid ta usto namatian din an.” ");
INSERT INTO cgc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na Jesus nang en daw dusi na apustulis daw duma pa na gakuyog ki kanen, gainsa danen ki kanen parti ta mga paanggid din na isturya. ");
INSERT INTO cgc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gambal kanen i, “Kyo na mga tinudluan ko patagan ta Dyos ta pribiliyo na mlaman nyo mga ula din pasugira anay pa sa na parti ta iya na pagdumala. Piro, duma na mga ittaw natudluan parti ta iya na pagdumala paagi nang ta mga paanggid na isturya ");
INSERT INTO cgc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","aged, ‘maski tan-awen pa danen ta miad ake na mga buat, dili man gyapon kaintindi daw ino beet ambalen, maski matian pa danen ta miad ake na mga itudlo, dili man gyapon kaintindi tak daw kaintindi danen an, magnelsel ta iran na mga sala daw marani ta Dyos daw patawaren din danen an. Piro, dili gid miag danen an na magnelsel.’” ");
INSERT INTO cgc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gambal pa Jesus i ki danen, “Daw ula nyo naintindii paanggid an na isturya parti ta mangunguma, dili nyo man maintindian duma pa na mga paanggid. ");
INSERT INTO cgc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yi beet ambalen ta paanggid an: Binni na pasabwag ta mangunguma, yon tudlo na parti ta ambal ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mga binni na katupa naan ta dalan paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw, piro gabot dayon Satanas daw pakamang din naan ta iran na isip patudlo ya ki danen. ");
INSERT INTO cgc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mga binni na katupa naan ta batuan na may tappaw nang na basak paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw daw pabaton dayon na may kalipay, ");
INSERT INTO cgc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","piro iran na pagpati dili terek ta iran na nakem. Paryo danen ta tanem na mga gamot an babaw nang. Gani, ula nang lugay iran na pagpati. Na gabot mga prublima daw papangabot danen ta mga gakuntra ki danen tenged ta iran na pagpati ta tudlo ya, patalikuran danen dayon iran na pagpati. ");
INSERT INTO cgc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mga binni na katupa naan ta natubuan ta mga telleken na lamunon paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw, ");
INSERT INTO cgc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","piro nalipatan danen tudlo ya tenged gapalibeg danen parti ta pangabui, gangabot na magmanggaranen daw subla na andem ta duma na mga betang. Ula en pulos iran na pagpati tak ula risulta na paryo danen an ta tanem na ula gabunga. ");
INSERT INTO cgc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mga binni na katupa naan ta dayad na basak paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw daw papatian man danen daw may dayad na risulta iran na pagpati. Danen an paryo ta tanem na gapungpong ta bunga na may trinta na passi, may sisinta daw may anen man isya gatos.” ");
INSERT INTO cgc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Gambal pa gid Jesus i naan ta iya na mga tinudluan paagi ta paanggid, “Di' ba daw mga ittaw magtutod ta lampraan daw dleen naan ta iran na kwarto, dili danen takleban ta gantangan? Dili man danen ibetang naan ta dalem ta kattri! Simpri ibetang danen naan ta tungtungan ta ilaw. ");
INSERT INTO cgc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iling tan ake an na panudluon tak ula may patago na dili magwa. Ula man may pasikrito na dili mlaman ta tanan. ");
INSERT INTO cgc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Daw kino liag magbaton ta ake i na ambal, isipen din gid ta usto namatian din an.” ");
INSERT INTO cgc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gambal pa gid kanen an, “Matian nyo gid ambal ko i. Daw magprusigir kaw na maintindian ta miad ake na mga patudlo, maintindian nyo gid ta miad daw dugangan pa gid ta Dyos inyo na pag-intindi. ");
INSERT INTO cgc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iling tan dapat buaten nyo tak daw kino kaintindi daw gapati ta ake na mga patudlo parti ta pagdumala ta Dyos, dugangan pa gid ta Dyos iya an na pag-intindi. Piro, daw kino ula gapati, bawian pa ta Dyos kanen an daw ino na naintindian din parti ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Gambal pa Jesus i naan ta iya na mga tinudluan paagi ta paanggid, “Pagdumala ta Dyos paryo ta matabo daw isya na ittaw magsabwag ta binni naan ta iya na uma. ");
INSERT INTO cgc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Adlaw kilem, bugtaw man kanen an daw gatunuga, mga binni an nanlisok daw gatubo maskin ula din naintindii daw ino na pagtubo. ");
INSERT INTO cgc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Naan ta basak tanan na kinanglan ta tanem aged magtubo. Una, puon an gadaon, sunod gauway daw ta uryan may tinggas na mga bunga. ");
INSERT INTO cgc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Daw inog en, miling dayon tag-iya naan ta uma daw magdala ta panggapas tak uras en na anien.” ");
INSERT INTO cgc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Gambal pa gid Jesus i naan ta iya na mga tinudluan, “Indi ta pakumparar pagdumala an ta Dyos? Ino na paanggid ate na gamiten aged masaysay pagdumala din an? ");
INSERT INTO cgc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pagdumala din an paryo ta natabo ta binni na mustasa na patanem ta isya na ittaw naan ta iya na uma. Yi na binni pinakatise ta tanan na binni. ");
INSERT INTO cgc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piro, na natanem en, gatubo daw gabakod na mas pa bakod kaysa ta tanan na tanem na gulay daw gabaal gid mga sanga na bisan mga yupan an gapasilong daw gasalag naan ta iya na mga sanga.” ");
INSERT INTO cgc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tama pa gid na paanggid na iling tan na pagamit Jesus ta iya na pagtudlo ta mga ittaw parti ta pagdumala ta Dyos. Patudlo din nang ki danen sarang an danen maintindian. ");
INSERT INTO cgc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ula kanen gatudlo ki danen daw dili, paagi nang ta mga paanggid. Piro, daw kanen nang en daw iya na mga tinudluan, pasaysay din ki danen daw ino beet ambalen ta mga paanggid. ");
INSERT INTO cgc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na semsem en ta yon man na adlaw na gaisturya Jesus i ta mga paanggid naan ta iya na mga tinudluan, gambal kanen ki danen, “Mos! Makted ki naan ta liyo.” ");
INSERT INTO cgc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Padilian danen tama ya na mga ittaw na gatipon dya daw gasakay danen an naan ta buti na naan dya en Jesus i. Galarga danen duma ki Jesus daw pila man na mga ittaw na kasakay naan ta duma na mga buti. ");
INSERT INTO cgc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na galakted danen an, nali nang gasampi pelles na angin. Sigi gid taklap baled an daw tise nang nasanapan buti an. ");
INSERT INTO cgc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus i gatunuga naan ta ulin na may palunan kanen. Papukaw kanen i ta iya na mga tinudluan daw ambal danen, “Mistro, ula nang ki kaon na maleddang ki?” ");
INSERT INTO cgc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pag-ambal danen, gabangon kanen daw pauntat din angin an daw pamanduan din baled an, “Maglinaw daw maglineng!” Dayon, gauntat biskeg na angin daw sikad kalmada. ");
INSERT INTO cgc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Gambal kanen i ki danen, “Man-o tak nadlek kaw? Ula kaw gid pagsalig ki yaken?” ");
INSERT INTO cgc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nadlek gid danen an na paryo dili mapati ta iran na nakita. Gambal danen an, “Ino taan klasi na ittaw ni? Bisan angin an daw baled gatuman ki kanen!” ");
INSERT INTO cgc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gapadayon Jesus i daw iya na mga tinudluan ta iran na paglakted daw gabot naan ta liyo Dagat Galilea naan ta lugar ta mga Gerasano. ");
INSERT INTO cgc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagkawas Jesus naan ta buti, may gasugat dayon ki kanen na mama na naan galin ta patyo. Mama an naseddepan ta malain na ispiritu ");
INSERT INTO cgc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","daw pirmi kanen an gatinir naan ta patyo. Dili man en kanen magapos bisan kadinaan pa ");
INSERT INTO cgc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","tak tama en na bisis na pagapos iya an na batiis daw lima, piro pabugto din nang mga kadina an naan ta iya na lima daw pagubba din pusas an naan ta iya na batiis. Bisan kino dili kapegeng ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Adlaw kilem bisan indi kanen, naan ta patyo daw naan man ta mga bukid, pirmi kanen an gasinggit daw paninaan din iya an na lawa ta mga bato. ");
INSERT INTO cgc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na nabantaw din Jesus i, gadlagan kanen an daw galuod naan ta atubangan Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gasinggit kanen an, “Jesus! Kaon na Bata ta Dyos Na Labaw Ta Tanan! Man-o tak anen ka di? Gapakiluoy a ki kaon paagi ta ngaran ta Dyos na dili a no sakiten.” ");
INSERT INTO cgc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Iling tan ambal ta mama an tak bag-o nang paambalan Jesus, “Kaon na malain na ispiritu, maggwa ka ta mama na i.” ");
INSERT INTO cgc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Painsaan Jesus mama an, “Ino ngaran no?” Gasabat malain na mga ispiritu na naan ta mama, “Ake na ngaran Linibo tak tama kay.” ");
INSERT INTO cgc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sigi kanen gapakiluoy ki Jesus na dili nang danen an paalinen ta lugar na ya. ");
INSERT INTO cgc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Naan ta bangilid na dani ki danen Jesus, may paneng ta baboy na ganuklad. ");
INSERT INTO cgc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gapakiluoy mga malain ya na ispiritu ki Jesus, “Pailingen kay no naan ta mga baboy. Pabay-an kay no na magseddep ki danen.” ");
INSERT INTO cgc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pag-ambal danen, pabay-an din nang danen an daw gagwa danen alin ta mama daw gaseddep naan ta mga baboy. Mga baboy ya gadlagan paebes ta bangilid daw nulog naan ta dagat daw nalemmes tanan. Katamaen ta mga baboy mga darwa libo. ");
INSERT INTO cgc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mga manugbantay ta mga baboy gadlagan ta subla na adlek daw gasugid ta mga ittaw naan ta banwa daw ta mga baryo parti ta iran na nakita. Mga ittaw an giling ki Jesus para makita danen mama ya. ");
INSERT INTO cgc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pag-abot ta mga ittaw ki Jesus, nakita danen mama an na padilian en ta linibo na malain na ispiritu. Gamungko mama an daw may bayo en na suot daw usto en iya na isip. Nadlek danen an tanan tenged ta iran na nakita. ");
INSERT INTO cgc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mga kakita ya ta katingalaan na pabuat Jesus, danen gasugid ta mga ittaw na bag-o nang gid gabot parti ta natabo ta mama na padilian ta mga malain na ispiritu daw natabo man ta mga baboy. ");
INSERT INTO cgc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pagmati ta mga ittaw, gapakiluoy danen an ki Jesus na malin kanen ta iran na lugar. ");
INSERT INTO cgc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na makay en Jesus i naan ta buti, mama an na padilian ta malain na mga ispiritu gapangabay na muyog ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Piro, ula din patuguti mama an. Ambal din, “Miad pa, muli ka ta imo na mga kauturan daw sugiran no danen an ta katingalaan na nabuat ta Ginuo Dyos ki kaon na naluoy kanen an ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pag-ambal Jesus, gapanaw mama an daw giling naan ta lugar ta sampulo na syudad na pangaranan na Decapolis. Naan dya pasugid din katingalaan na nabuat Jesus ki kanen. Tanan na kamati ki kanen gatingala gid. ");
INSERT INTO cgc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ta pagbalik Jesus daw iya na mga tinudluan naan ta Galilea, galakted danen an naan ta liyo na kilid ta dagat. Tama na mga ittaw gatipon ki kanen na naan nang pa kanen ta kilid ta dagat. ");
INSERT INTO cgc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","May mama na gaprani ki Jesus na isya na gadumala ta balay tipunan. Ngaran din Jairo. Pagkita din ki Jesus, galuod kanen an naan ta tubangan Jesus ");
INSERT INTO cgc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","daw gapakiluoy gid, “Ake na bata na dalagita tagumatayen en. Miling ki naan ta ame na balay. Daw maimo nang, itungtong no imo na lima naan ki kanen para mayad daw mabui.” ");
INSERT INTO cgc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pag-ambal Jairo, gakuyog Jesus ki kanen. Ta pagpanaw danen Jesus munta iran Jairo, tama na mga ittaw gakuyog na gadas-egay daw Jesus i naipit ta iran na pagdas-egay. ");
INSERT INTO cgc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","May isya na bai na anen man dya na iya na rigla ula gapeet ta usto seled ta dusi anyos. ");
INSERT INTO cgc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tama na kabellay naagian din ta pagpabulong naan ta lain-lain na mga duktor asta naubos en iya na kwarta ta pagpabulong. Piro, imbis na mayad kanen an, gadugang pa gid iya an na masakit. ");
INSERT INTO cgc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tenged nabalitaan din parti ki Jesus, gasel-et kanen an naan ta tama na mga ittaw daw magprani naan dapit ta tudtod Jesus daw patandeg din bayo na pangkablay Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iling tan pabuat din tak naan ta iya na isip, “Bisan matandeg ko nang iya na bayo, mayad a gid.” ");
INSERT INTO cgc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pagtandeg ta bai ta bayo Jesus, dayon peet iya na rigla daw nabatyagan din na nayad en kanen an ta iya na masakit. ");
INSERT INTO cgc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nlaman Jesus na may gaem na alin ki kanen na gapaayad ta ittaw. Galiso kanen an dayon daw minsa ta mga ittaw, “Kino gatandeg ta ake na bayo?” ");
INSERT INTO cgc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gasabat iya na mga tinudluan, “Nakita no na tama na mga ittaw gadas-eg ki kaon. Man-o tak minsa ka pa daw kino gatandeg ta bayo no an?” ");
INSERT INTO cgc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piro, sigi kanen tan-aw ta palibot na pangita din daw kino gatandeg ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tenged nlaman ta bai natabo ya ta iya na pag-ayad, gaprani kanen an ki Jesus na gakereg ta subla na adlek. Galuod kanen naan ta tubangan Jesus daw pasugid din tanan na natabo ta iya na pag-ayad. ");
INSERT INTO cgc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Gambal Jesus i ki kanen, “Kay, tenged ta imo na pagsalig, nayad ka. Muli ka en na may katawway ta nakem tak ayad ka en ta imo na masakit.” ");
INSERT INTO cgc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na gambal pa Jesus i ta bai ya, may gabot na pila na mga ittaw na naan galin ta balay ta mama an na gadumala ta balay tipunan. Ambal danen, “Dili ta nang en pailingen pa Mistro an naan ta balay nyo tak ula en bata no ya.” ");
INSERT INTO cgc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piro, ula intindia Jesus iran an na ambal. Gambal kanen an ta mama an na gadumala ta balay tipunan, “Dili ka magkulba. Magsalig ka nang.” ");
INSERT INTO cgc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta pagpadayon danen Jesus ta iran na pagpanaw, paambalan din mga ittaw an na dili nang muyog. Pakuyog din nang ya danen Pedro daw mag-utod na Santiago daw Juan. ");
INSERT INTO cgc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pag-abot danen naan ta balay ta mama an na gadumala ta balay tipunan, nakita Jesus mga ittaw an na gasinaba. Duma an ki danen gagal daw duma an a gaug-og. ");
INSERT INTO cgc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gaselled Jesus i naan ta balay daw ambal din ta mga ittaw, “Man-o tak gasinaba kaw daw gangagal? Bata an dili patay. Gatunuga nang kanen an.” ");
INSERT INTO cgc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Piro, patatawaan nang ta mga ittaw Jesus i. Papagwa Jesus tanan na mga ittaw daw paselled din amay daw inay ta bata daw paselled din man tallo din na duma naan ta selled na anen dya bata ya. ");
INSERT INTO cgc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pabitan Jesus lima an ta bata daw mambal, “Talitha koum,” na beet ambalen, “Kay, gambal a ki kaon, mangon ka.” ");
INSERT INTO cgc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dayon, bangon kanen an daw gapanaw-panaw naan ta kwarto. Kanen an dusi anyos en. Mga ginikanan din sikad gid tingala. ");
INSERT INTO cgc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Piro, paambalan Jesus danen an na dili mugid ta bisan kino parti ta nakita danen na pabuat din, daw paambalan din man danen an na tagan bata an ta pagkaan. ");
INSERT INTO cgc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Galin Jesus i daw iya na mga tinudluan ta banwa na dani ta Dagat Galilea daw miling ta banwa na naan dya kanen i gabakod. ");
INSERT INTO cgc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ta Adlaw Ta Pagpuay, giling kanen i naan ta balay tipunan. Naan dya kanen gatudlo ta mga ittaw daw tama na kamati ki kanen gatingala gid. Ambal danen, “Indi alin iya na patudlo? Indi alin iya na kanlaman? Makatingala gid mga buat din! ");
INSERT INTO cgc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Di' ba kanen isya nang na karpintiro? Di' ba kanen bata Maria daw iya na utod danen Santiago, Jose, Judas daw Simon daw mga utod din na bai anen man di gaistar?” Tenged iling tan iran na isip parti ki kanen, ula gid danen an gapati ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Gambal Jesus i ki danen, “Bisan indi na lugar, mga prupita an na manugsugid ta kabebet-en ta Dyos pataod gid ta mga ittaw, piro naan ta iran gid na banwa, ula pataura ta iran na kasimanwa. Ula man danen an pataura ta iran na mga parinti daw pamilya.” ");
INSERT INTO cgc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tenged mga kasimanwa Jesus ula gapati ki kanen, dili gid tama nabuat din na mga katingalaan naan ta iran na banwa. Dili gid tama na mga ittaw na may masakit paayad din paagi ta pagtungtong ta iya na lima. ");
INSERT INTO cgc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Gatingala kanen an na ula danen an gapati ki kanen. Pagtapos Jesus ta pagtudlo naan ta balay tipunan, galibot kanen i naan ta mga banwa daw gatudlo. ");
INSERT INTO cgc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Paumaw din dusi an na apustulis na magtipon naan ki kanen daw pasugo din danen an na manaw na tag-darwa. Bag-o danen manaw, patagan din anay danen an ta uturidad aged magpagwa ta mga malain na ispiritu na naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Paambalan din mga apustulis na ta iran na pagpanaw tungkod nang dleen an danen. Dili danen magdala ta pagkaan, binagteng daw kwarta man naan ta iran na puyo-puyo. ");
INSERT INTO cgc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gambal man kanen i ki danen na pwidi magsandal, piro dili magdala ta bayo na mlaan. ");
INSERT INTO cgc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gambal pa kanen i ki danen, “Daw padayunon kaw naan ta isya na balay, naan kaw nang dya magtinir keteb na malin kaw ta iran na banwa. ");
INSERT INTO cgc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Piro, daw dili kaw batunon ta mga ittaw naan ta isya na banwa daw dili man miag danen mamati ki kyo, malin kaw dya. Ta inyo na pag-alin, ipakita nyo na papadpad nyo yab-ok an ta inyo na mga batiis na alin ta iran na banwa bilang pamatuod kuntra ki danen tak ula danen pabatuna upurtunidad na mapamatian danen miad na balita.” ");
INSERT INTO cgc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gapanaw mga apustulis an daw gawali ta mga ittaw na danen an dapat magnelsel daw dilian iran na mga sala. ");
INSERT INTO cgc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tama na malain na ispiritu napagwa ta mga apustulis naan ta mga ittaw daw tama man na may masakit na papairan danen ta lana ta olibo na paayad danen. ");
INSERT INTO cgc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Namatian Ari Herodes mga isturya parti ta mga pabuat Jesus tak bantog gid en Jesus an. May mga ittaw na gambal, “Jesus an, kanen Juan na manugbautismo na nabannaw. Yon na may gaem kanen ta pagbuat ta mga katingalaan.” ");
INSERT INTO cgc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Duma an gambal, “Jesus, kanen Elias na prupita anay pa sa.” Duma pa gid an a gambal, “Jesus an isya na prupita na paryo ta mga prupita anay pa sa.” ");
INSERT INTO cgc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Piro, na namatian Herodes ambal ta mga ittaw, gambal kanen, “A, Juan ya na pauturan ko ta lieg nabannaw!” ");
INSERT INTO cgc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nlaman Herodes parti ki Juan tak kanen mismo gasugo na Juan ya dakepen, gapuson, daw prisuon tenged ki Herodias na pasawa din bisan Herodias an sawa ta iya na utod na Felipe ");
INSERT INTO cgc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","daw tenged man na kanen an pirmi paambalan Juan, “Kuntra ta mga sugo naan ta Mga Sinulat Moises na pasawa no sawa ta imo na utod.” ");
INSERT INTO cgc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tenged ta ambal Juan, gademet Herodias ki Juan daw liag din na patayen. Piro, dili din mabuat iya na liag ");
INSERT INTO cgc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tak bakod gid pagtaod Herodes ki Juan. Juan ya paambligan man Herodes tak nlaman din na Juan matareng daw dyusnon. Na gamati kanen ta wali Juan, nadayaran kanen i bisan galibeg iya na ulo parti ta namatian din. ");
INSERT INTO cgc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ta uryan, gabot upurtunidad na patagaran Herodias aged Juan an ipapatay din. Herodes i, naan ta iya na kaadlawan gakumbira daw paimbitar din iya an na mga ittawan na may datas na katengdanan, mga upisyal ta sundalo daw duma na mga ittaw naan ta Galilea na may datas na katengdanan. ");
INSERT INTO cgc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na gakumbira danen, bata Herodias na dalagita gaselled daw gasayaw daw naganya gid Herodes daw iya na mga bisita. Gambal kanen i ta dalagita, “Ayuon no ki yaken bisan ino gusto no, iatag ko ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Gasumpa kanen daw gambal pa, “Bisan ino ayuon no ki yaken, iatag ko ki kaon bisan tenga pa ta ake na kaarian.” ");
INSERT INTO cgc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gagwa dalagita i daw gainsa ta iya na inay, “Ino ayuon ko?” Sabat inay din, “Ayuon no na Juan na manugbautismo uturan ta lieg.” ");
INSERT INTO cgc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dalagita i gadali-dali balik naan ta ari daw mambal, “Gusto ko na atag no dayon ki yaken ulo Juan na manugbautismo na nabetang naan ta bandiyado.” ");
INSERT INTO cgc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pagmati ta ari, ganelsel gid kanen tak kinanglan gid na iatag paayo ta dalagita tenged ta iya na sumpa na namatian ta mga bisita din. ");
INSERT INTO cgc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pasugo din dayon iya an na manugpatay na sundalo na uturan Juan ta lieg daw dleen ulo an naan ki kanen. Gapanaw sundalo ya naan ta prisuan daw pauturan din Juan ta lieg. ");
INSERT INTO cgc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Padala ta sundalo ulo ya na nabetang naan ta bandiyado daw paatag naan ta dalagita daw paatag man ta dalagita naan ta iya na inay. ");
INSERT INTO cgc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na namatian ta mga tinudluan Juan na kanen patay en, giling danen dya na mangen lawa din daw lebbeng. ");
INSERT INTO cgc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mga apustulis ya na papanaw Jesus na tag-darwa gabalik naan ki kanen daw pasugid danen tanan ya na nabuat danen daw natudlo. ");
INSERT INTO cgc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gambal kanen i naan ta iya na mga apustulis, “Miling ki naan ta lugar na ula kabalayan para kapuay ki bisan ula nang lugay.” Iling tan ambal Jesus tenged sikad tama na mga ittaw giling dya daw ula untat iran na pag-iling daw ula en uras danen Jesus na maan. ");
INSERT INTO cgc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gasakay danen an ta sakayan na buti na danen nang daw miling naan ta lugar na ula kabalayan. ");
INSERT INTO cgc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Piro, pag-alin danen Jesus, nakita daw nakala danen an ta tama na mga ittaw. Gadlagan mga ittaw an alin ta lain-lain na mga banwa daw miling ta lugar na puntaan danen Jesus. Mga ittaw an una pa abot ki danen Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagkawas danen Jesus, patan-aw din sikad tama na mga ittaw na gatipon dya daw naluoy gid kanen i tak paryo danen ta mga karniro na ula manugbantay. Tenged ta iya na kaluoy, tama patudlo din ki danen. ");
INSERT INTO cgc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na dali nang en magsalep adlaw, gaprani mga tinudluan Jesus ki kanen daw mambal, “Mapon gid en, naan ki pa di ta lugar na ula kabalayan. ");
INSERT INTO cgc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Miad taan daw pailingen no mga ittaw an naan ta dani nang na mga baryo daw banwa aged malit ta iran na pagkaan.” ");
INSERT INTO cgc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piro, sabat Jesus, “Kyo mag-atag ki danen ta iran na makaan.” Gainsa danen ki Jesus, “Ino! Manaw kay pa daw malit ta tinapay na bali darwa gatos na sinsilyo na pilak aged ipakaan ki danen?” ");
INSERT INTO cgc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ambal Jesus, “Lagen nyo tuo daw pila buok na tinapay naan ki kyo.” Pag-usisa danen, gasabat danen an, “Limma na tinapay daw darwa na sidda.” ");
INSERT INTO cgc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pasugo Jesus iya na mga tinudluan na grupo-grupuon na papungkuon mga ittaw an naan ta dayad na lamunon. ");
INSERT INTO cgc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gapungko mga ittaw an na gagrupo ta tag-isya gatos daw tag-singkwinta. ");
INSERT INTO cgc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pakamang Jesus limma an na tinapay daw darwa na sidda. Gaangad kanen ta langit daw gapasalamat ta Dyos. Dayon, pabiak-biak din tinapay ya daw paatag naan ta iya na mga tinudluan aged itagtag naan ta mga ittaw. Patenga-tenga din man sidda ya ki danen tanan. ");
INSERT INTO cgc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kakaan danen tanan daw nabusog. ");
INSERT INTO cgc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Patipon ta iya na mga tinudluan sama ya na tinapay daw sidda daw napanno danen dusi na baskit na darko. ");
INSERT INTO cgc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Katamaen ta mga mama na kakaan limma libo. ");
INSERT INTO cgc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na natipon en ta mga tinudluan Jesus sama ya na tinapay daw sidda, pasakay din dayon danen an naan ta isya na buti daw paambalan na muna en lakted naan ta liyo munta ta Betsaida tak paulien din pa mga ittaw an. ");
INSERT INTO cgc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na napauli din en, giling kanen i naan ta bukid aged mangamuyo. ");
INSERT INTO cgc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na semsem en, mga tinudluan Jesus naan en ta laod, daw Jesus i nabilin na isya nang naan ta takas. ");
INSERT INTO cgc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nakita din na nabellayan danen ta paggayong tak sungsong angin an. Na mapit-madlaw en, gasunod kanen i ki danen na gapanaw kanen naan ta apaw ta waig. Na malambayan din en danen an, ");
INSERT INTO cgc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nakita danen kanen an na gapanaw naan ta apaw ta waig. Gasinggit danen an tak salig danen bagat kanen an. ");
INSERT INTO cgc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Danen tanan kakita ki kanen daw nadlek gid. Dayon gambal kanen i, “Isegen nyo nakem nyo an! Yaken ni. Dili kaw madlek!” ");
INSERT INTO cgc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pag-ambal din, gasakay kanen naan ta buti daw galinaw. Gatingala gid danen an ");
INSERT INTO cgc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tak ula pa gid kaintindi daw ino beet ambalen ta katingalaan ya na naimo din ta tinapay. Iling tan tak danen an bellay paintindien. ");
INSERT INTO cgc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Paglakted Jesus daw iya na mga tinudluan naan ta liyo na baybay ta Dagat Galilea, gadungka danen an ta banwa na Genesaret daw naan dya gapundo. ");
INSERT INTO cgc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagkawas danen, nakala dayon ta mga ittaw Jesus i. ");
INSERT INTO cgc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Gadali-dali mga ittaw an na miling naan ta palibot na mga lugar ta pagkamang ta mga ittaw na may masakit daw dleen naan ta lugar na nlaman danen na naan dya Jesus ya. ");
INSERT INTO cgc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bisan indi nang kanen an, naan ta mga sitio, naan ta mga baryo daw ta mga syudad man, padala mga ittaw ya na may masakit naan ta lugar na tipunan pirmi ta tama na mga ittaw daw gapangabay danen ki kanen na daw pwidi mga ittaw na may masakit magtandeg bisan ta bungay-bungay nang ta sidsid ta iya na bayo na pangkablay. Tanan na katandeg nayad. ");
INSERT INTO cgc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","May gatipon naan ki Jesus na mga Pariseo daw pila na mga manugtudlo ta Mga Sinulat Moises na naan galin ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nakita danen na mga tinudluan Jesus gakaan na ula gasunod ta kaugalian ta mga Judio aged iran na lima bilangen na “limpyo”. Beet ambalen na ula danen an gasunod ta sirimunya ta pag-ugas ta lima bag-o maan. ");
INSERT INTO cgc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mga Judio an, labi en gid mga Pariseo, bag-o danen an maan gasunod gid anay ta sirimunya ta pag-ugas ta lima na sunod ta iran na kaugalian na alin ta mga manakem. ");
INSERT INTO cgc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Daw naan danen galin ta palingki, mag-ugas gid anay danen an ta iran na lima bag-o maan. Tama pa gid iran na mga kaugalian na alin ta mga manakem. Alimbawa, mga sirimunya ta pag-ugas ta mga ineman, kuron daw mga sin-aran na buat ta tambaga. ");
INSERT INTO cgc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mga Pariseo an daw mga manugtudlo ta Mga Sinulat Moises gainsa ki Jesus, “Man-o tak imo an na mga tinudluan ula gasunod ta mga kaugalian na alin ta ate na mga manakem? Gakaan danen an na iran na lima pabilang na ‘dili-limpyo’ tak ula danen an gasunod ta sirimunya ta pag-ugas ta lima.” ");
INSERT INTO cgc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sabat Jesus ki danen, “Inyo na pagtaod ta Dyos pakita-kita nang. Igo gid laygay Isaias na prupita anay pa sa parti ki kyo naan ta iya na sinulat. Nasulat din na Dyos gambal, ‘Yi na mga ittaw gataod ki yaken paagi nang ta iran na baba. Piro, iran na tagipusuon adyo ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ula pulos iran an na pagsimba ki yaken tak danen an gatudlo na naan kon alin ki yaken mga sugo an na naan nang alin ta mga ittaw.’ ");
INSERT INTO cgc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Iling gid tan inyo an na pabuat tak mga sugo ta Dyos ula nyo pasunod, piro mga kaugalian na buat nang ta mga ittaw pirmi nyo pasunod.” ");
INSERT INTO cgc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Gambal pa Jesus i, “Sikad kaw gid magsikway ta mga sugo ta Dyos aged masunod nyo nang mga kaugalian an na buat nyo. ");
INSERT INTO cgc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Alimbawa, ambal Moises, ‘Tauron no imo an na amay daw inay.’ Ambal din man, ‘Bisan kino gambal ta malain parti ta iya na amay daw inay dapat silutan ta kamatayen.’ ");
INSERT INTO cgc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Piro, dili iling tan inyo na patudlo tak naan ta mga kaugalian na pabuat nyo, patudlo nyo na mga ittaw dili en kinanglan magtaod ta iran na ginikanan paagi ta pagtabang basta mag-ambal danen an ta iran na ginikanan ta iling ti, ‘Kurban en ake na iatag na tabang inta ki kyo.’” -- Kurban i beet ambalen “Yi natagana en para ialad naan ta Dyos”. ");
INSERT INTO cgc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ambal pa Jesus, “Pabay-an nyo sugo an ta Dyos paagi ta mga kaugalian na pabuat nyo daw patudlo naan ta duma. Tama pa gid na mga buat nyo na iling tan.” ");
INSERT INTO cgc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Paumaw isab Jesus mga ittaw an na marani daw ambal din, “Mamati kaw tanan daw intindien nyo ambalen ko i. ");
INSERT INTO cgc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dili tenged ta bisan ino na gaselled naan ta mga ittaw na danen an pabilang na ‘dili-limpyo’. Danen an pabilang na ‘dili-limpyo’ tenged ta mga gagwa alin ki danen. ");
INSERT INTO cgc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Daw kino liag magbaton ta ake i na ambal, isipen din gid ta usto namatian din an.” ");
INSERT INTO cgc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagtapos Jesus ta ambal naan ta mga ittaw, galin kanen ki danen daw gaselled naan ta ulian din na balay. Naan ta balay, gainsa iya na mga tinudluan ki kanen daw ino beet ambalen ta ambal din an parti daw ino gaselled daw gagwa ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Gambal Jesus i ki danen, “Asta kyo na ake na mga tinudluan, ula man kaintindi? Dapat naintindian nyo na bisan ino na kan-enen ta mga ittaw, dili danen an bilangen na ‘dili-limpyo’ ");
INSERT INTO cgc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tak pagkaan an ula gaagi ta iran na isip. Gadiritso pagkaan an naan ta iran na gettek daw ta uryan magwa man gyapon.” Paagi ta iling tan na ambal Jesus, papaintindi din na tanan na makaan “limpyo” na yon man ula en pagkaan na kuntra ta mga sugo ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gambal pa Jesus i, “Tenged ta mga malain na ambal daw buat ta mga ittaw, danen an bilangen na ‘dili-limpyo’ ");
INSERT INTO cgc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","tak naan alin ta tagipusuon mga buat na iling ti: mga malain na isip, gabuat ta malaw-ay ta panan-aw ta Dyos, ganakaw, gapatay, gadulog ta dili din sawa, ");
INSERT INTO cgc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gapangabot pa gid ta tama na mga betang, gabuat ta malain kuntra ta duma, gadaya, gabuat ta makagayya, gainggit, gambal ta dili matuod parti ta duma, gapabugal ta iya na kaugalingen daw gabuat ta kabuangan. ");
INSERT INTO cgc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tanan na iling tan na mga buat na malain naan galin ta tagipusuon daw tenged ta yon man gyapon na mga buat, mga ittaw bilangen na ‘dili-limpyo’.” ");
INSERT INTO cgc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Galin Jesus i ta Genesaret daw giling ta lugar na sakep ta banwa na Tiro. Pag-abot din, gaselled kanen i ta isya na balay. Dili din inta gusto na mlaman ta mga ittaw na kanen naan en ta iran na lugar, piro dili gid matago. ");
INSERT INTO cgc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","May bai dya na bata din na dalagita naseddepan ta malain na ispiritu. Na namatian din na Jesus i gabot, giling dayon kanen ki Jesus daw galuod na gadapa naan ta atubangan Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Gapakiluoy kanen i na pagwaen Jesus malain ya na ispiritu naan ta iya na bata. Kanen i dili-Judio na natao naan ta Fenicia na sakep ta Siria daw iya na linggwai Griego. ");
INSERT INTO cgc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tenged kanen i dili-Judio, iling ti sabat Jesus, “Kinanglan makakaan gid anay mga bata an asta mabusog tak dili dapat na kamangen pagkaan an ta mga bata daw iatag naan ta mga ayam.” ");
INSERT INTO cgc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ambal ta bai, “Matuod nyan, Ginuo, piro bisan pa mga ayam naan ta dalem ta lamisaan gakaan ta mummo alin ta mga bata.” ");
INSERT INTO cgc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ambal Jesus, “Tenged dayad gid imo na sabat pwidi ka en muli. Gagwa en malain ya na ispiritu naan ta imo na bata.” ");
INSERT INTO cgc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Guli bai i daw nakita din na nayad en iya na bata daw ganegga ta kattri tak kagwa en malain ya na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Galin Jesus i naan ta lugar na sakep ta Tiro daw gaagi kanen i ta mga lugar na Sidon daw Decapolis diritso ta Dagat Galilea. ");
INSERT INTO cgc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","May mama na alla na bengngel na padala ta mga ittaw naan ki kanen daw gapakiluoy danen an na itungtong din iya na lima naan ta mama na alla aged mayad. ");
INSERT INTO cgc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pabelag Jesus mama an alin ta tama na mga ittaw na gatipon dya. Pabetang Jesus timbang din na tudlo naan ta darwa na talinga ta mama. Paileban din iya na tudlo daw patandeg din dila ya ta mama. ");
INSERT INTO cgc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gaangad kanen i ta langit daw gaginawa ta dalem daw mambal, “Effata” na beet ambalen, “Mabukas ka.” ");
INSERT INTO cgc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kamati dayon mama ya daw kaambal en ta tadleng. ");
INSERT INTO cgc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Paambalan Jesus mga ittaw an na dili mugid ta bisan kino parti ta pagpaayad din ta mama ya. Piro, bisan sigi ambal din ki danen ta iling tan, gapadayon pa gid danen an ta pagsugid. ");
INSERT INTO cgc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sikad gid tingala ta mga ittaw daw ambal danen, “Dayad gid tanan na buat din! Bisan mga alla kaambal daw mga bengngel kamati!” ");
INSERT INTO cgc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na gapanaw pa Jesus i naan ta lugar na dani ta Dagat Galilea, gatipon eman tama na mga ittaw naan ki kanen. Na ula en danen an makaan, paumaw Jesus na marani ki kanen iya an na mga tinudluan daw ambal din ki danen, ");
INSERT INTO cgc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naluoy a ta mga ittaw na duma ki kiten tak tallo en adlaw na gakuyog danen i ki yaken daw anduni ubos en iran na balon. ");
INSERT INTO cgc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Daw paulien ko pa danen i na ula kakaan, malipeng danen i ta iran na pagpanaw tak duma ki danen naan pa alin ta madyo na lugar.” ");
INSERT INTO cgc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sabat ta iya na mga tinudluan, “Indi ki magkamang ta tinapay naan ta lugar na i na ula kabalayan aged ipakaan ki danen?” ");
INSERT INTO cgc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Insa Jesus ki danen, “Pila buok na tinapay naan ki kyo?” Sabat danen, “Pitto.” ");
INSERT INTO cgc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Papungko Jesus mga ittaw an naan ta basak daw pakamang din pitto an na tinapay daw gapasalamat ta Dyos. Pabiak-biak din tinapay an daw paatag naan ta iya na mga tinudluan aged itagtag danen naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","May anen man pila buok na sidda. Gapasalamat kanen ta Dyos daw paatag din sidda an naan ta iya na mga tinudluan aged itagtag man naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kakaan danen tanan daw nabusog. Patipon ta iya na mga tinudluan sama ya daw napanno danen pitto na baskit na darko. ");
INSERT INTO cgc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Katamaen ta mga kakaan mga appat libo na ittaw. Papauli Jesus mga ittaw ya ");
INSERT INTO cgc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","daw gasakay dayon kanen an ta buti duma ta iya na mga tinudluan daw miling naan ta lugar na Dalmanuta. ");
INSERT INTO cgc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pag-abot Jesus daw iya na mga tinudluan naan ta lugar na Dalmanuta, may mga Pariseo na gabot dya aged diskusyunon Jesus an. Papangitaan danen kanen an ta katingalaan na buat na alin ta Dyos aged may pamatuod na kanen an papadala ta Dyos tak liag danen na pamatuuran din daw indi gid alin iya na gaem. ");
INSERT INTO cgc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Piro, Jesus i gaginawa ta dalem daw mambal, “Kyo na mga ittaw ta yi na timpo, man-o tak papangitaan a nyo ta katingalaan na buat na pamatuod na papadala a ta Dyos? Ee, liag nyo na makita katingalaan, piro gambal a ki kyo na ula katingalaan na ipakita ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pag-ambal Jesus, galin kanen i daw gasakay isab kanen daw iya na mga tinudluan naan ta buti daw makted naan ta liyo Dagat Galilea. ");
INSERT INTO cgc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na galakted Jesus i daw iya na mga tinudluan ta Dagat Galilea, nalipatan ta iya na mga tinudluan na magdala ta tinapay na balon. May anen tinapay, piro subuok nang na naan ta buti na pasakayan danen. ");
INSERT INTO cgc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Paandaman Jesus iya an na mga tinudluan, “Mag-andam kaw daw maglikaw ta pampaabok ta mga Pariseo daw pampaabok Herodes.” ");
INSERT INTO cgc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pag-ambal din, gaisturyaay danen an, “Iling tan ambal din tak ula ki tinapay na balon.” ");
INSERT INTO cgc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nlaman Jesus paisturya danen daw gainsa kanen i, “Man-o tak gapalibeg kaw gid na ula kaw tinapay? Ino? Ula nyo pa naintindii? Ula nyo pa nakamang? Bellay kaw gid paintindien. ");
INSERT INTO cgc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","May mata kaw, piro dili kaw kakita. May talinga kaw, piro dili kaw kamati. Man-o? Ula nyo gid nademdemi na napakaan ko sikad tama na mga ittaw? ");
INSERT INTO cgc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na pabiak-biak ko limma ya na tinapay para ta subla limma libo na ittaw, pila na mga baskit napanno nyo ya ta sama na patipon nyo?” Sabat danen, “Dusi.” ");
INSERT INTO cgc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Gainsa pa gid Jesus i, “Na pabiak-biak ko pitto ya na tinapay para ta subla appat libo na ittaw, pila na mga baskit napanno nyo ya ta sama na patipon nyo?” Sabat danen, “Pitto.” ");
INSERT INTO cgc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dayon gambal Jesus i, “Ino? Ula nyo pa naintindii daw ino beet ambalen ta mga pabuat ko?” ");
INSERT INTO cgc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na gabot Jesus i daw iya na mga tinudluan naan ta Betsaida, may mama na bulag na padala ta mga ittaw naan ki kanen daw gapakiluoy danen na tandegen din bulag an aged makakita. ");
INSERT INTO cgc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Paibitan din mama an na bulag naan ta lima daw paguyod din mwa ta banwa. Pag-abot danen ta gwa, paileban din mata ya ta bulag daw patakleban din ta iya na lima. Pagkamang din ta iya na lima, painsaan din bulag ya, “Ta, may nakita ka en?” ");
INSERT INTO cgc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gatan-aw mama na bulag naan ta palibot daw mambal, “Kita ko en mga ittaw an na gapanaw, piro pagluag ko, paryo nang danen an ta mga kaoy.” ");
INSERT INTO cgc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Patakleban isab Jesus mata ta mama. Pagkamang Jesus ta lima din, pabuklad gid ta mama iya na mata daw nakakita gid en na tin-aw iya na panan-aw. ");
INSERT INTO cgc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Papauli Jesus mama an daw paambalan, “Magdiritso ka nang en uli ta inyo na balay na dili magi naan ta banwa.” ");
INSERT INTO cgc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Giling Jesus i daw iya na mga tinudluan naan ta mga baryo na sakep ta banwa na Cesarea Filipos. Ta iran na pagpanaw na miling dya, gainsa Jesus i ki danen, “Kino a kon ambal ta mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sabat danen, “May mga ittaw na gambal na kaon kon yan Juan na manugbautismo. Duma ya a gambal na kaon kon Elias. Duma pa ya gambal na kaon kon isya ta duma man na mga prupita na manugsugid ta kabebet-en ta Dyos anay pa sa.” ");
INSERT INTO cgc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Insa din pa, “Kyo a, ino maambal nyo daw kino yaken i?” Sabat Pedro, “Kaon yan Pinili Ta Dyos Na Mag-ari.” ");
INSERT INTO cgc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pagsabat Pedro, paambalan Jesus danen an na dili mugid ta bisan kino daw kino kanen i. ");
INSERT INTO cgc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Umpisa ta adlaw na nakala en ta mga tinudluan Jesus na kanen Pinili Ta Dyos Na Mag-ari, gatudlo kanen i ki danen na naan ta plano ta Dyos na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, maagian din tama na malain na buat ta mga gakuntra ki kanen. Mga gadumala ta mga Judio, mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises magsikway ki kanen. Patayen kanen i, piro bannawen ta Dyos naan ta pangallo na adlaw. ");
INSERT INTO cgc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ula gid kanen an may patago ta iya na pagsugid ki danen. Pagmati Pedro ta ambal Jesus, padala din Jesus an daw gapadyo danen ta iran na mga duma. Paambalan din na dili kanen an kumpurmi ta ambal ya Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Gatubang Jesus i daw gatan-aw ta iya na mga tinudluan daw pasaway din Pedro an, “Layas ka di Satanas! Naan ta imo na isip pagbeet nang ta ittaw, dili pagbeet ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Paumaw Jesus na marani tama na mga ittaw na naan dya daw iya man na mga tinudluan daw ambal din, “Daw kino miag na kanen isya man na tinudluan ko, dapat dili iya en na liag masunod daw dapat man na isipen din na paryo kanen an ta isya na ittaw na gapas-an ta iya na krus tenged iling tan buaten ta ittaw na magsunod ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kinanglan na buaten iling an tan tak daw kino gapalabi ta iya na kabui, mapatay man gyapon. Piro, bisan kino na mag-alad ta iya na kabui tenged ki yaken daw ta pagsugid ta miad na balita, maangken din kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Daw may ittaw na maangken din tanan na manggad naan ta kalibutan i piro dili din malikawan silot na ula katapusan naan ta impirno, ula man gyapon pulos tanan na naangken din. ");
INSERT INTO cgc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ula gid betang na pwidi iatag aged balyo ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bisan kino magsikway ki yaken daw ta ake na tudlo naan ta yi na timpo ta tama ittaw na malain na gatalikod ta Dyos, Yaken i Na Alin Ta Langit Na Natao Naan Ta Kalibutan magsikway man ki kanen. Sikwayen ko kanen an naan ta adlaw ta pag-umpisa ta ake na pagdumala na malik a duma ta mga angil ta ake na Amay daw makita sikad silaw na pawa na naan ki yaken na paryo man ta pawa na naan ta ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ambal pa Jesus ki danen, “Sigurado gid na iling tan naan ta ake na pagbalik daw sugiran ta kyo na may anen di ki kyo na bag-o danen mapatay, makita pa danen na pagdumala ta Dyos na papaabot nyo mag-umpisa paagi ta bakod din na gaem.” ");
INSERT INTO cgc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Paglambay ta annem na adlaw alin ta pag-ambal Pedro parti daw kino Jesus i, danen nang Pedro, Santiago daw Juan pakuyog Jesus na miling naan ta datas na bukid. Na naan dya, nakita danen Pedro na gaisab sura Jesus ");
INSERT INTO cgc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","daw iya na bayo sikad gid puti na sikad silaw. Ula gid bayo na palatag ta maskin kino na manugbunak naan ta kalibutan i na mas puti pa ta bayo Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nali nang Elias daw Moises gapakita ki danen daw gasugranen ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Gambal Pedro i ki Jesus, “Mistro, miad gid man na naan ki di. Magbuat kay ta tallo na pasilungan. Isya para ki kaon, isya para ki Moises daw isya man para ki Elias.” ");
INSERT INTO cgc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Iling tan ambal din tak ula kanen nalam daw ino dapat din ambalen tenged nakulbaan gid danen an. ");
INSERT INTO cgc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nali nang may panganod na galekkep ki danen tanan. May namatian na gambal na naan ta panganod, “Yi ake na bata na palangga ko. Mamati kaw ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gatan-aw danen Pedro naan ta palibot daw ula en danen duma na nakita daw dili, Jesus nang. ");
INSERT INTO cgc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na gategbeng Jesus daw danen Pedro alin ta bukid, paambalan din danen an na dili mugid ta nakita danen dya naan ta bisan kino asta na mabannaw alin ta patay Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. ");
INSERT INTO cgc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tenged ta ambal Jesus, ula gid danen gasugid ta mga nakita danen. Piro, na danen nang en, gainsaay danen an daw ino beet ambalen Jesus na paambal din “mabannaw alin ta patay”. ");
INSERT INTO cgc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ta yon man na uras, gainsa danen an ki Jesus, “Man-o tak mga manugtudlo ta Mga Sinulat Moises gambal na kinanglan Elias ya muna anay mabot bag-o Pinili Ta Dyos Na Mag-ari?” ");
INSERT INTO cgc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sabat Jesus, “Matuod iran an na patudlo na Elias ya muna anay mabot aged kanen magpriparar ta tanan para ta pag-abot ta Pinili Ta Dyos Na Mag-ari. Isipen nyo nasulat parti ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan daw man-o tak naambal dya na maagian din tama na malain na buat ta mga gakuntra ki kanen daw sikwayen man kanen an ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sugiran ta kyo na mama ya na paryo ki Elias abot en daw pabuat ta mga ittaw ki kanen mga malain na liag danen buaten paryo ta ambal naan ta sinulat na pulong ta Dyos parti ta matabo ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na gabalik en Jesus i daw danen Pedro naan ta duma na mga tinudluan Jesus, nakita danen na sikad tama na mga ittaw gatipon dya daw pila man na mga manugtudlo ta Mga Sinulat Moises na gadiskusyon naan ta iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na nakita kanen i ta mga ittaw, gatingala danen an daw gadlagan na marani ki kanen aged mag-atag ta taod. ");
INSERT INTO cgc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Gainsa kanen i ta iya na mga tinudluan, “Ino padiskusyunan nyo daw mga manugtudlo?” ");
INSERT INTO cgc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","May mama na naan ta mga ittaw na gatipon dya gasabat, “Mistro, padala ko di ake na bata na mama para ayaren no tak naseddepan ta malain na ispiritu na gapaapa ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Daw abuton na pagaeman kanen an ta malain na ispiritu, palampes kanen an naan ta basak, gabula iya na baba, gabaggit iya na ngipen daw gamiskeg iya na lawa. Gapangabay a ta imo na mga tinudluan na pagwaen danen malain an na ispiritu, piro dili danen masarangan.” ");
INSERT INTO cgc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Gambal Jesus i ta iya na mga tinudluan, “E-hey! Kyo na mga ittaw ta yi na timpo, ula kaw gasalig ta Dyos! Asta kan-o a pa na magduma ki kyo daw magsakripisyo bag-o kaw magsalig ta Dyos? Dleen nyo di ki yaken bata an.” ");
INSERT INTO cgc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pagsugo din, padala danen bata an ki kanen. Pagprani ta bata, Jesus an nakita ta malain na ispiritu daw gapegpeleg dayon bata ya daw gulpi nang tumba daw galigid naan ta basak na gabula iya na baba. ");
INSERT INTO cgc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Gainsa Jesus i ta amay ta bata ya, “Kan-o pa gailing ti imo na bata?” Sabat ta amay ya, “Alin pa na sise kanen i. ");
INSERT INTO cgc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pirmi padala ta malain na ispiritu kanen i naan ta apoy daw waig aged masunog daw malemmes. Piro, daw may maimo ka, maluoy ka ki kami daw tabangan kay no.” ");
INSERT INTO cgc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ambal Jesus, “Man-o tak gambal ka ‘daw may maimo a’? Yi ambal ko, tanan na betang maimo ko para ta mga ittaw na gasalig ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sabat dayon ta amay ya ta bata na tudo iya na kagi, “Gasalig a, piro tabangan a no aged dili a magdua-dua.” ");
INSERT INTO cgc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na nakita Jesus na sikad tama na mga ittaw gadali-dali na gaprani, paambalan din malain ya na ispiritu, “Kaon na malain na ispiritu na gapaapa daw gapabengngel ta yi na bata, pasugo ta kaw na mwa ki kanen daw dili ka en isab magseddep ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pag-ambal din, gasinggit malain ya na ispiritu daw papegpeleg din gid ta miad bata ya daw mwa. Ula en gulag bata an na paryo patay gid. Tama na mga ittaw na naan dya gambal, “Bata an patay en.” ");
INSERT INTO cgc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piro, paibitan Jesus lima an ta bata daw bangunon. Dayon gatindeg bata an. ");
INSERT INTO cgc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagpaayad Jesus ta bata, gaselled Jesus i naan ta ulian din na balay daw iya na mga tinudluan gainsa ki kanen na danen nang, “Man-o tak dili kay kapagwa ta malain na ispiritu naan ta bata ya?” ");
INSERT INTO cgc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sabat din, “Ula duma na paagi na mwa iling sa na klasi ta malain na ispiritu daw dili, paagi gid ta pagpangamuyo.” ");
INSERT INTO cgc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Galin Jesus i daw iya na mga tinudluan ta lugar na dani ta bukid daw gaagi naan ta Galilea. Dili miag Jesus na mlaman ta mga ittaw na kanen anen dya ");
INSERT INTO cgc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tak gatudlo kanen i ta iya na mga tinudluan. Ta iya na pagtudlo, gambal kanen ki danen, “Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan dali nang en intriga naan ta mga gakuntra ki kanen. Patayen danen kanen i, piro ta pangallo na adlaw alin ta iya na kamatayen, mabannaw kanen i.” ");
INSERT INTO cgc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ula danen naintindii daw ino beet din ambalen, piro gangawa danen an na mag-insa ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ta pagpanaw Jesus daw iya na mga tinudluan naan ta Galilea, kabot danen an naan ta banwa na Capernaum. Na gaselled en danen ta balay na iran na dayunan, gainsa Jesus ki danen, “Ino gid padiskusyunan nyo gina na gapanaw ki?” ");
INSERT INTO cgc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piro, ula danen gasasaba tak padiskusyunan danen parti daw kino gid ki danen may pinakadatas na katengdanan. ");
INSERT INTO cgc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gapungko Jesus i daw paumaw din na marani dusi na apustulis. Pambalan din danen an, “Daw kino gaandem ta datas na katengdanan, kinanglan magpaebes kanen an daw manugsirbi ta tanan.” ");
INSERT INTO cgc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pag-ambal Jesus, gakamang kanen ta sise na bata na naan dya daw papatindeg din naan ta tengnga. Pakengkeng din bata ya daw mambal ki danen, ");
INSERT INTO cgc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Daw kino ki kyo na tenged ki yaken magbaton ta bisan isya na paryo ta yi na bata, paryas man na yaken pabaton nyo. Daw kino ki kyo magbaton ki yaken, dili nang yaken pabaton nyo. Pabaton nyo man gapadala an ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Gambal Juan i ki kanen, “Mistro, may nakita kay na ittaw na gasambit man ta ngaran no ta iya na pagpagwa ta mga malain na ispiritu. Paay nay tak dili ta kanen ya duma.” ");
INSERT INTO cgc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ambal Jesus, “Dili nyo ayen kanen ya. Impusibli na bisan kino, pagtapos din sambit ta ake na ngaran ta iya na pagbuat ta katingalaan, mambal man kanen ta malain kuntra ki yaken ");
INSERT INTO cgc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tak bisan kino na ula gakuntra ki kiten, gatabang ki kiten. ");
INSERT INTO cgc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sugiran ta kyo na daw kino magbuat ta miad ki kyo maskin mag-atag ki kyo ta bisan isya nang na baso na waig na inemen tak sakep kaw ta Pinili Ta Dyos Na Mag-ari, sigurado gid na mabaton din dayad na bales alin ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Gambal pa Jesus i naan ta iya na mga tinudluan, “Daw kino na kanen tenaan na makasala bisan isya nang ta kebes ko na mga tinudluan na gapati ki yaken, mas miad pa daw tabiran iya na lieg ta bakod na galingan na bato daw ulog kanen an naan ta dagat. ");
INSERT INTO cgc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Daw imo na lima tenaan na nakasala ka, dapat uturon no! Mas miad pa na ungkol isya no na lima piro paselleren ka naan ta langit na mabui ta ula katapusan kaysa na darwa imo na lima piro tupa ka naan ta impirno na may apoy na dili mapatay ");
INSERT INTO cgc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","tak naan ta impirno maageman no segeng na sakit tenged ‘mga luod daw apoy dya dili mapatay’. ");
INSERT INTO cgc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Daw imo na batiis tenaan na nakasala ka, dapat uturon no! Mas miad pa na ungkol isya no na batiis piro paselleren ka naan ta langit na mabui ta ula katapusan kaysa na darwa imo na batiis piro pilak ka naan ta impirno ");
INSERT INTO cgc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","tak naan ta impirno maageman no segeng na sakit tenged ‘mga luod daw apoy dya dili mapatay’. ");
INSERT INTO cgc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Daw imo na mata tenaan na nakasala ka, dapat lukaten no! Mas miad pa na isya nang imo na mata piro paselleren ka naan ta kaarian ta Dyos kaysa na darwa imo na mata piro pilak ka naan ta impirno ");
INSERT INTO cgc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tak naan ta impirno maageman no segeng na sakit tenged ‘mga luod daw apoy dya dili mapatay’. ");
INSERT INTO cgc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Maagian ta tanan na mga ittaw mga kabellay an aged magbag-o iran na batasan tak paryo ta apoy na pagamit aged blawan an magpuro, mga kabellay an isya na paagi na magkamang daw ino dili dayad naan ta batasan ta mga ittaw para magmiad danen an.” ");
INSERT INTO cgc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Gambal pa Jesus i ta paanggid na iling ti, “Daw asin natimpla naan ta pagkaan, magdayad lasa ta pagkaan. Piro, daw asin ula en gamasin, ula en pulos tak impusibli na magmasin pa isab. Dapat na dayad inyo na batasan paryo ta natimplaan ta asin para dayad pagdumaay nyo ta kada isya.” ");
INSERT INTO cgc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Galin Jesus i naan ta Capernaum daw miling ta prubinsya Judea na gaagi naan dapit ta sennangngan ta Suba Jordan. Tama eman na ittaw gatipon naan ki kanen daw patudluan din danen an paryo ta pirmi din na pabuat. ");
INSERT INTO cgc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","May mga Pariseo na giling ki Jesus aged dakep-dakepen kanen an paagi ta insa para maakusaran daw may ambalen kanen an na kuntra ta Mga Sinulat Moises. Gainsa danen an ki kanen, “Ino ta imo na isip? Naan ta Mga Sinulat Moises patugot na mga mama magbelag ta iran na sawa?” ");
INSERT INTO cgc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ambal din, “Ngaran sa sugo ya ki kyo naan ta Mga Sinulat Moises?” ");
INSERT INTO cgc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sabat danen, “Patugot Moises na mga mama magbelag ta iran na sawa daw magbuat danen anay ta kasulatan ta pagbelag.” ");
INSERT INTO cgc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ambal Jesus, “Yon na sugo parti ta pagbelag pasulat Moises tak kyo na mga linai Israel dessen gid ulo. ");
INSERT INTO cgc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Di' ba alin ta pag-umpisa ta kalibutan ‘pabuat ta Dyos mga ittaw na danen mama daw bai’? ");
INSERT INTO cgc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Yon tenaan na mama malin ta pudir ta iya na amay daw inay tak kanen daw iya na sawa magdumaay ");
INSERT INTO cgc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na danen na darwa mimo na isya.’ Gani, mama daw bai na magsawa dili en darwa. Danen isya nang en. ");
INSERT INTO cgc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tenged paisya ta Dyos mama an daw bai, kuntra ta pagbeet din na belagen danen an ta bisan kino.” ");
INSERT INTO cgc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pagtapos Jesus ta iya na pag-ambal naan ta mga Pariseo, gabalik kanen naan ta balay na iya na dayunan. Naan dya iya na mga tinudluan gainsa ki kanen parti ta paambal din. ");
INSERT INTO cgc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Gasabat kanen, “Bisan kino na mama na magbelag ta iya na sawa daw mangasawa kanen isab ta duma na bai, kasala kanen an kuntra ta una din na sawa tak paryas man gyapon na gaintra ta bai. ");
INSERT INTO cgc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yon man, bisan kino na bai na magbelag ta iya na sawa daw mangasawa kanen isab ta duma na mama, kasala kanen an tak paryas man gyapon na gaintra ta mama.” ");
INSERT INTO cgc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","May mga ittaw na gaprani ki Jesus na gadala ta iran na mga bata para itungtong din iya an na lima naan ta mga bata daw bindisyunan danen an. Piro, pasaway ta iya na mga tinudluan mga gadala ya. ");
INSERT INTO cgc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkita Jesus, gagilek kanen an daw pambalan din, “Bay-an nyo nang mga bata an na magprani ki yaken. Dili nyo danen an pegengan tak mga paryo ki danen sakep ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sakep gid ta pagdumala ta Dyos mga ittaw na paryo ki danen daw sugiran ta kyo na bisan kino na magpasakep ta pagdumala ta Dyos na dili kanen magparyo ta bata na gasalig na ula gadua-dua, impusibli na kanen an makalabet naan ta mga ittaw na padumalaan ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pag-ambal din, pakengkeng din mga bata an daw patungtong din iya an na lima naan ki danen daw bindisyunan danen an. ");
INSERT INTO cgc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na manaw en Jesus i aged magpadayon ta iya na byai miling ta Jerusalem, may mama na gadlagan na marani ki kanen daw galuod naan ta atubangan din. Gambal mama an, “Mistro, nlaman ko na matareng ka. Ino dapat ko na buaten aged maangken kabui na ula katapusan?” ");
INSERT INTO cgc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sabat din, “Man-o tak paumaw a no na matareng? Ula duma na matareng daw dili, Dyos nang. ");
INSERT INTO cgc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nlaman no mga sugo ta Dyos na, ‘Dili ka magpatay, dili ka mag-intra ta bai, dili ka manakaw, dili ka magtistigo ta dili matuod, dili ka magdaya, daw tauron no imo na amay daw inay.’” ");
INSERT INTO cgc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sabat ta mama an, “Mistro, tanan na sugo na pasambit no patuman ko alin na sise a pa.” ");
INSERT INTO cgc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Patan-aw din mama an na may pagpalangga daw paambalan, “May isya pa na ula no nabuat. Muli ka daw bligya no imo na mga pagkabetang daw bayad an iatag no ta mga imol tak sigurado na maangken no dayad na bales na patagana ta Dyos naan ta langit. Daw matuman no en ambal ko, malik ka daw muyog ki yaken aged isya ka man na tinudluan ko.” ");
INSERT INTO cgc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nagulpian mama an ta iya na pagmati ta ambal Jesus. Gapanaw kanen an na nasebean tak tama gid iya na mga pagkabetang. ");
INSERT INTO cgc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Patan-aw-tan-aw Jesus iya na mga tinudluan naan ta iya na palibot daw mambal, “Mga ittaw na manggaranen bellay gid magpasakep naan ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mga tinudluan Jesus gatingala gid ta iya na ambal. Ambal din isab ki danen, “Mga arey, mga ittaw na manggaranen bellay gid magpasakep naan ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas dali pa ta bakod na ayep na kamilyo meddep naan ta lungag ta dagem kaysa ittaw na manggaranen magpasakep naan ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pag-ambal din, gatingala pa gid danen an daw gaisturyaay, “Ta, daw iling tan na bellay para ta mga manggaranen, impusibli na may maluwas alin ta silot ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Patan-aw Jesus danen an daw ambal din, “Impusibli ta ittaw, piro dili impusibli ta Dyos tak tanan mabuat din.” ");
INSERT INTO cgc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ambal Pedro ki Jesus, “Ta, kami a? Padilian nay tanan aged muyog ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sabat Jesus, “Matuod na padilian nyo tanan. Piro, gambal a ki kyo na may dayad na bales na alin ta Dyos para ta bisan kino na padilian din iya na balay, mga utod, amay daw inay, mga bata daw mga basak aged munod ki yaken daw magsugid ta miad na balita ");
INSERT INTO cgc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tak naan ta yi na timpo mas tama pa na mabaton din kaysa ta mga padilian din. Mabaton din mga balay, mga utod, inay, mga bata, mga basak, daw asta maagian din man mga kabellay tenged ta mga pabuat ta mga gakuntra ki kanen daw naan ta timpo na mabot may kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tama anduni na may datas na katengdanan na ta uryan magbaba daw tama man anduni na may baba na katengdanan na ta uryan magdatas.” ");
INSERT INTO cgc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ta pag-iling Jesus daw iya na mga tinudluan naan ta Jerusalem, abot adlaw na galin danen an ta Suba Jordan na gaagi danen naan ta dalan na munta ta Jerusalem. Jesus i naan ta unaan. Gatingala iya na mga tinudluan na miling kanen naan ta Jerusalem daw duma na mga ittaw na gasunod man nadlek daw ino matabo dya ki kanen. Ta iran na pagpanaw, paprani Jesus dusi an na apustulis naan ki kanen daw papadyo alin ta duma na mga ittaw aged isturyaen din na danen nang. Pasugiran din ta matabo ki kanen naan ta Jerusalem, ");
INSERT INTO cgc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Matian nyo gid ambalen ko i ki kyo. Gapanaw ki na munta en naan ta Jerusalem daw naan dya Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan intriga naan ta mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises. Sintinsyaan kanen ta kamatayen daw intriga naan ta mga dili-Judio. ");
INSERT INTO cgc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pagayyaan danen kanen i, ileban, latiguon daw patayen. Piro, ta pangallo na adlaw, mabannaw kanen i.” ");
INSERT INTO cgc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Danen i Juan daw Santiago na mga kabataan Zebedeo gaprani ki Jesus daw gambal, “Mistro, may ayuon kay inta ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Gainsa Jesus i, “Ngaran sa inyo an na ayuon?” ");
INSERT INTO cgc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sabat danen, “Pwidi kay no tagan ta pabor na daw papungkuon ka na magdumala, papungkuon kay no man naan ta kilid no na isya an naan dapit ta tuo daw isya an a, naan dapit ta wala.” ");
INSERT INTO cgc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Piro, ambal Jesus, “Ula nyo nlami daw ino inyo na paayo. Masarangan nyo taan na maagian daw antuson ake an na maagian daw antuson na segeng na kabellay daw kasakit?” ");
INSERT INTO cgc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sabat danen, “Ee, masarangan nay.” Ambal Jesus, “Igo ambal nyo an. Maagian nyo daw antuson segeng na kabellay daw kasakit na maagian ko. ");
INSERT INTO cgc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piro, dili yaken magpili daw kino mungko naan dapit ta tuo daw wala ta kilid ko tak para nang ta mga ittaw na pataganaan ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na namatian ta sampulo na apustulis parti ta paayo ya ki Jesus, gagilek danen an ki Santiago daw Juan. ");
INSERT INTO cgc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gani, paumaw Jesus na marani danen an tanan daw ambal din, “Nlaman nyo na mga ittaw na pakala ta mga dili-Judio na iran na mga manugdumala gaabuso ta iran na pagdumala daw iling man tan mga dili-Judio na may datas na katengdanan ta iran na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piro, dapat dili kaw iling tan tak daw kino ki kyo na liag din na datas iya na katengdanan naan ki kyo na ake na mga tinudluan, dapat na kanen an magsirbi ki kyo na iya na mga duma na paryo kanen inyo na manugsirbi. ");
INSERT INTO cgc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Daw kino man ki kyo gaandem na magpanguna ki kyo na ake na mga tinudluan, dapat na kanen an magsirbi ki kyo tanan na iya na mga duma na paryo kanen inyo na suguon. ");
INSERT INTO cgc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bisan Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, tuyo din ta pag-iling di ta kalibutan i dili para sirbian ta mga ittaw. Giling di kanen para magsirbi ta duma daw mag-atag man ta iya na kabui para matubos tama na mga ittaw alin ta silot ta iran na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ta pagpanaw Jesus daw iya na mga tinudluan munta ta Jerusalem, kabot danen an naan ta syudad na Jerico. Na galin en kanen i ta Jerico duma ta iya na mga tinudluan daw ta sikad tama na mga ittaw, may gapalimos na bulag na gamungko naan ta kilid dalan na iran na agian. Iya na ngaran Bartimeo na beet ambalen “bata Timeo”. ");
INSERT INTO cgc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na namatian din na Jesus na taga-Nazaret gaagi dya, gasinggit kanen i, “Jesus! Apo Ari David! Maluoy ka ki yaken!” ");
INSERT INTO cgc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pasaway kanen i ta tama na mga ittaw na dili kanen magsagbak. Piro, gasinggit pa gid kanen i ta tudo, “Apo Ari David! Maluoy ka ki yaken!” ");
INSERT INTO cgc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Gateneng Jesus i daw mambal, “Umawen nyo kanen an na miling di.” Paumaw danen bulag an daw ambal danen, “Biskegen no nakem no an! Mindeg ka! Gumaw kanen an ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Papilak dayon ta bulag iya na pangkegme na bayo daw gadali-dali tindeg na miling ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ambal Jesus ki kanen, “Sugiran a no daw ino liag no na buaten ko para ki kaon.” Ambal din, “Mistro, liag ko na makakita.” ");
INSERT INTO cgc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ambal Jesus, “Sigi, manaw ka en. Nayad ka en tenged ta imo na pagsalig ki yaken.” Dayon kakita kanen an daw gaduma ta mga gakuyog ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na dani nang en ta Jerusalem Jesus i daw mga gakuyog ki kanen, kabot danen ta lugar ta darwa na baryo na Betfage daw Betania na naan ta Bukid Olibo. Pasugo din darwa ta iya na mga tinudluan ");
INSERT INTO cgc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na ambal din, “Miling kaw ta baryo na naan ta unaan. Pagselled nyo dya, makita nyo dayon isya na asno na bata pa na ula pa gid nasakayi na gaigot dya. Badbaren nyo igot an daw dleen nyo di asno an. ");
INSERT INTO cgc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Daw may ittaw na mag-insa ki kyo, ‘Man-o tak pakamang nyo asno an?’ sabaten nyo, ‘Kinanglan ta Ginuo asno i daw balik din man.’” ");
INSERT INTO cgc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Giling danen ta baryo ya daw nakita danen isya na asno na bata pa na naan ta kilid dalan na gaigot naan ta ngaan ta isya na balay. Na pabadbad nang pa danen igot ta asno, ");
INSERT INTO cgc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mga ittaw na naan dya gatindeg gainsa, “Man-o tak pabadbad nyo igot an ta asno?” ");
INSERT INTO cgc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Gasabat danen paryo ta ambal Jesus ki danen daw pabay-an nang en danen an na pakamang asno an. ");
INSERT INTO cgc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Padala danen asno an ki Jesus daw paapinan danen ta iran na mga bayo tudtod an ta asno daw gasakay Jesus i. ");
INSERT INTO cgc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pagsakay din, gapadayon danen Jesus na munta ta Jerusalem. Tama na mga ittaw gauna ki kanen na galadlad ta iran na mga bayo naan ta dalan na agian din daw duma man ya, patagtag danen naan ta dalan mga pasasa na daon ta palma na alin ta mga uma aged ipakita iran na pagtaod ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mga ittaw na gauna ki Jesus daw duma na gasunod man gasinggit, “Dayawen ta Dyos an! Dayawen gabot an na papadala ta Ginuo Dyos! ");
INSERT INTO cgc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dayawen kanen i na gabot na magpadayon ta pagdumala ta ate na kaapuan na Ari David! Dayawen ta Dyos an na naan ta langit!” ");
INSERT INTO cgc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pag-abot danen Jesus naan ta Jerusalem, gaselled kanen an ta sular ta Timplo daw patan-aw din mga betang naan ta selled. Piro, tenged na dali nang en magsalep adlaw an, gagwa kanen na miling ta Betania duma ta dusi na apustulis daw naan dya gapalambay ta kilem. ");
INSERT INTO cgc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na adlaw en, galin Jesus i daw iya na mga tinudluan naan ta Betania. Ta iran na pagpanaw na malik ta Jerusalem, kanen i nletem. ");
INSERT INTO cgc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nakita din naan ta dili gid madyo isya na kaoy na igos na gagabong ta daon. Papranian din aged tan-awen daw may bunga, piro ula gid kanen may nakita na bunga. Ubos nang daon tenged dili pa timpo na mamunga mga kaoy na igos. ");
INSERT INTO cgc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dayon din pambalan igos an, “Umpisa anduni, ula en may kakaan ta imo na bunga.” Yon na ambal Jesus namatian ta iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na Jesus i daw iya na mga tinudluan naan en ta Jerusalem, gaselled isab kanen an ta sular ta Timplo daw papagwa din mga ittaw dya na gabligya daw mga gamalit ta mga pang-alad para ta Dyos. Patumba din mga lamisaan ta mga manugbalyo ta kwarta daw mga pungkuan ta mga gabligya ta salampati na pang-alad. ");
INSERT INTO cgc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ula kanen gatugot na mga ittaw na gadala ta iran na mga bligya magi naan ta sular ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Galaygay kanen ta mga ittaw, “Naan ta sinulat na pulong ta Dyos, kanen an gambal, ‘Ake na balay umawen na balay pangamuyuan para ta tanan na mga ittaw.’” Ambal pa Jesus, “Piro, pabuat nyo iya na balay na ‘taguan ta mga manakaw’.” ");
INSERT INTO cgc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na namatian ta mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises parti ta pabuat Jesus naan ta Timplo, gangita danen ta paagi na ipapatay Jesus i tak nadlek danen ki kanen tenged mga ittaw nadayaran gid ta iya na mga patudlo. ");
INSERT INTO cgc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pagsalep ta adlaw, gagwa Jesus i daw iya na mga tinudluan naan ta syudad. ");
INSERT INTO cgc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na sellem en, gapanaw Jesus i daw iya na mga tinudluan na malik ta Jerusalem. Ta iran na pagpanaw, nakita danen na kaoy na igos na pasumpa din gakeseg asta gid ta gamot. ");
INSERT INTO cgc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nademdeman Pedro ambal ya Jesus naan ta igos daw ambal din, “Mistro, lagen no! Gakeseg igos an na pasumpa no.” ");
INSERT INTO cgc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sabat Jesus, “Kinanglan magsalig kaw nang ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gakeseg igos an tenged gid ta ake na ambal daw sugiran ta kyo na bisan kino na mambal ta yi na bukid, ‘Akwaten ka ta Dyos daw ilabyog naan ta dagat,’ daw gapati gid kanen na ula gadua-dua na matabo, iya na ambal matuman. ");
INSERT INTO cgc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gani, gambal a ki kyo na bisan ino inyo na pangayuon paagi ta pangamuyo, daw magpati kaw na mabaton nyo, iatag gid ki kyo. ");
INSERT INTO cgc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Daw mangamuyo kaw, patawaren nyo anay daw kino kasala ki kyo aged ate na Amay na naan ta langit magpatawad man ki kyo ta inyo na mga sala. ");
INSERT INTO cgc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Piro, daw dili kaw magpatawad, dili kaw man patawaren ta ate na Amay na naan ta langit.” ");
INSERT INTO cgc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gabalik Jesus i daw iya na mga tinudluan naan ta Jerusalem daw gaselled naan ta Timplo. Na kanen i gapanaw-panaw ta sular ta Timplo, may mga manugdumala na mga pari, mga manugtudlo ta Mga Sinulat Moises daw duma pa na mga gadumala ta mga Judio na gaprani ki kanen ");
INSERT INTO cgc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","daw gainsa, “Indi alin imo na uturidad ta mga pabuat no naan ta Timplo i? Kino gaatag ki kaon ta imo na uturidad aged buaten iling ya sa?” ");
INSERT INTO cgc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sabat Jesus ki danen, “Minsa a anay ki kyo. Daw masabat a nyo, isugid ko daw indi alin ake na uturidad ta pagbuat ko ta iling sa naan ta Timplo i. ");
INSERT INTO cgc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yi ake na insa: Juan ya na manugbautismo, indi alin iya na uturidad ta pagbautismo din ta mga ittaw? Ino ta inyo na isip, naan alin ta Dyos, naan alin ta ittaw? Sabaten a nyo.” ");
INSERT INTO cgc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gaisturyaay danen an daw ino iran na isabat. Ambal danen, “Daw sabaten ta ‘naan alin ta Dyos’, insaan ki din ‘Man-o tak ula kaw gapati ki Juan?’ ");
INSERT INTO cgc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piro, dili ta man masabat ‘naan alin ta ittaw’!” Iling tan iran na isip tak nadlek danen an na basi mga ittaw an dya magbuat ta malain na kuntra ki danen tenged pakala gid ta mga ittaw Juan ya na isya na prupita na alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tenged ula danen may isabat ki Jesus, ambal danen ki kanen, “Ula nay nlami.” Ambal din ki danen, “Dili ko man isugid ki kyo daw indi alin ake na uturidad ta mga pabuat ko naan ta Timplo i.” ");
INSERT INTO cgc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Gaisturya pa Jesus i naan ta mga manugdumala na mga pari, mga manugtudlo ta Mga Sinulat Moises daw duma pa na mga gadumala ta mga Judio paagi ta isya na paanggid. Ambal din, “May mama na gatanem ta ubas naan ta iya na uma daw pakuralan din. Gakutkot man kanen ta lungag daw naan dya gabuat ta pegaan ta ubas. Gapatindeg man kanen ta turi na bantawan ta manugbantay. Tapos ta tanan din na ubra, papaagsa din ubasan ya daw miling ta madyo na lugar. ");
INSERT INTO cgc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na timpo en ta pagpupo ta mga ubas, papailing din isya ta mga suguon din naan ta mga gaagsa ta ubasan aged kamangen naan ki danen parti din ya ta tubbas ta iya na ubasan. ");
INSERT INTO cgc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pag-abot dya ta suguon, pagabling danen kanen ya daw pabugbog daw papauli na ula dala. ");
INSERT INTO cgc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Papailing man ta tag-iya isya pa na suguon, piro papakang danen naan ta ulo suguon ya daw pagayyaan. ");
INSERT INTO cgc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Papailing din isya pa gid na suguon, piro papatay danen. Iling man tan pabuat danen ta tama na mga suguon na papailing din. Duma an pabugbog danen daw duma ya papatay. ");
INSERT INTO cgc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Isya nang gid en na pwidi din masugo, iya na palangga na bata na mama. Papailing din iya na bata tak ambal din ta iya na kaugalingen, ‘Sigurado na tratuon danen ta miad ake i na bata.’ ");
INSERT INTO cgc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Piro, na nakita danen bata ya ta tag-iya, gaisturyaay danen, ‘Yon manubli ta uma na i. Sigi, patayen ta kanen an aged ate nang en panublien din an.’ ");
INSERT INTO cgc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pagtapos danen ta iran na pag-isturyaay, pagabling danen kanen an, papatay daw payudyod pagwa naan ta ubasan.” ");
INSERT INTO cgc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pagtapos Jesus ta isturya, painsaan din mga gadumala an ta mga Judio, “Ta, ino buaten ta tag-iya? Simpri ilingan din mga gaagsa ya daw patayen daw paagsa din iya na ubasan naan ta duma na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Paryo kaw inyo na ula kabasa ta ambal naan ta sinulat na pulong ta Dyos na iling ti: ‘Bato an na ta isip ta mga manug-ubra ta balay dili magamit, yon gid pamag-ang na bato. ");
INSERT INTO cgc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yi tanan pagbeet ta Ginuo Dyos daw gatingala ki gid!’” ");
INSERT INTO cgc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pag-ambal Jesus, liag ta mga manugdumala na mga pari, mga manugtudlo ta Mga Sinulat Moises daw mga gadumala ta mga Judio na dakepen inta Jesus i tak naintindian danen na danen paisturya din naan ta iya na paanggid. Piro, nadlek danen an na basi mga ittaw dya magbuat ta malain kuntra ki danen. Tenged ula danen mabuat, padilian danen Jesus i daw manaw. ");
INSERT INTO cgc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pasugo ta mga gadumala ta mga Judio pila na mga Pariseo daw pila man na mga ittaw na gasunod ki Herodes na miling danen an ki Jesus daw dakep-dakepen kanen an paagi ta mga insa. ");
INSERT INTO cgc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yon na giling danen an ki kanen daw mambal, “Mistro, nlaman nay na ula ka pagbula daw ula ka may papaburan tak maskin kino pa na ittaw paryo nang imo na pagtratar ki danen daw gatudlo ka ta kamatuuran parti ta kabebet-en ta Dyos. Sugiran kay no tuo. Ta imo na isip, naan ta Mga Sinulat Moises patugutan ki na magbayad ta buis naan ta pangulo ta Roma? ");
INSERT INTO cgc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Magbayad ki? Dili ki magbayad?” Piro, nlaman Jesus na danen an gapakuno-kuno nang na iran na pag-insa terek ta iran na nakem. Pambalan din danen an, “Liag nyo nang na dakep-dakepen a paagi ta ake na sabat! Dawatan a nyo ta isya na sinsilyo na paryo ta pabayad nyo ta buis tak lagen ko.” ");
INSERT INTO cgc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Padawat danen sinsilyo na paryo ta iya na paayo. Ambal din, “Iya ti na sura daw ngaran naan ta yi na sinsilyo?” Sabat danen, “Iya ta pangulo ta Roma.” ");
INSERT INTO cgc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ambal din, “Ta, daw ino iya ta pangulo ta Roma, iatag nyo ki kanen. Daw ino iya ta Dyos, iatag nyo ta Dyos.” Pagmati danen ta ambal Jesus, gatingala gid danen an ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","May mga Saduseo na giling ki Jesus aged dakep-dakepen kanen an paagi ta insa parti ta pagbannaw tak ula danen an gapati na mabannaw mga patay an. ");
INSERT INTO cgc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ambal danen ki kanen, “Mistro, naan ta Mga Sinulat Moises may sunuron ki na daw mama na may sawa mapatay na ula kanen bata ta iya na sawa, dapat paus-os katengdanan din naan ta iya na mangngod aged makabata para ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Alimbawa: may pitto na mag-utod na mama. Kamagulangan ya nangasawa daw napatay na ula kanen an bata. ");
INSERT INTO cgc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nabalo ya pasawa ta pangarwa na utod. Piro, napatay man pangarwa ya na utod na ula danen an bata. Iling man tan natabo ta pangallo ya na utod. ");
INSERT INTO cgc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Natabo iling tan ta pitto na mag-utod tak tanan danen kasawa ta bai na balo, piro napatay na ula danen bata. Ta uryan, bai ya napatay man. ");
INSERT INTO cgc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ta, daw mabot timpo na mabannaw mga patay, kino ki danen na mag-utod matuod na sawa ta bai ya tak danen na pitto ubos kasawa ki kanen?” ");
INSERT INTO cgc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sabat Jesus, “Sala inyo na isip tak ula kaw nalam daw ino naan ta sinulat na pulong ta Dyos daw ula kaw man gapati na Dyos may gaem ta pagbannaw ta mga patay. ");
INSERT INTO cgc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Daw mabannaw mga patay ya, dili danen mangasawa tak paryo danen ta mga angil naan ta langit na ula gasawaay. ");
INSERT INTO cgc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Parti man ta pagbannaw, paryo kaw inyo na ula kabasa ta ambal ta Dyos naan ta sinulat Moises. Naan ta isturya parti ta tanem na galegleg, Dyos gambal ki Moises, ‘Yaken i Dyos danen Abraham, Isaac daw Jacob.’ ");
INSERT INTO cgc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Iling tan na ambal ta Dyos pamatuod na mga ittaw na napatay mabannaw tak dili kanen an Dyos ta mga patay. Dyos kanen an ta mga bui. Sala gid inyo na isip!” ");
INSERT INTO cgc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","May manugtudlo ta Mga Sinulat Moises na gaprani ki Jesus daw namatian din pagdiskasay danen Jesus daw mga Saduseo parti ta pagbannaw. Na namatian din na dayad sabat Jesus, gainsa kanen an, “Ta tanan na sugo ta Dyos, ino pinakaimpurtanti?” ");
INSERT INTO cgc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sabat Jesus, “Naan ta sinulat Moises pinakaimpurtanti na sugo. Ambal din, ‘Mga linai Israel, mamati kaw! Ginuo na ate na Dyos, kanen nang gid Ginuo. ");
INSERT INTO cgc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gugmaen no Ginuo an na imo na Dyos na terek gid ta imo na tagipusuon. Ipakita no imo an na gugma paagi ta ugali, isip daw mga buat.’ ");
INSERT INTO cgc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yi pangarwa na impurtanti na sugo: ‘Gugmaen no duma na mga ittaw paryo man ta paggugma no ta imo na kaugalingen.’” Ambal din man, “Ula en sugo na mas impurtanti kaysa ta darwa na i.” ");
INSERT INTO cgc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ambal ta manugtudlo, “Mistro, dayad gid sabat no. Igo imo na ambal na may isya nang na Dyos daw ula en duma. ");
INSERT INTO cgc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Igo man na dapat gugmaen ta kanen an na terek gid ta tagipusuon daw ipakita ate na gugma paagi ta isip daw mga buat, daw igo man na dapat ate na paggugma naan ta duma paryo ta ate na paggugma ta kaugalingen ta tak ate na pagtuman ta yon na mga sugo mas impurtanti kaysa ta tanan na alad naan ta Dyos asta ta mga ayep na paiyaw para ialad.” ");
INSERT INTO cgc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nlaman Jesus na igo gid sabat ta manugtudlo daw ambal din, “Dili madyo na bilangen ka ta Dyos na isya man ta mga ittaw na iya na padumalaan.” Pagtapos Jesus ta ambal, ula may nangiseg na mag-insa pa ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na gatudlo Jesus i naan ta Timplo, gambal kanen, “Man-o tak gambal mga manugtudlo ta Mga Sinulat Moises na Pinili Ta Dyos Na Mag-ari linai Ari David? ");
INSERT INTO cgc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David mismo, na pagaeman kanen ya ta Dyos Ispiritu Santo gambal, ‘Ginuo Dyos gambal ta ake na Ginuo, “Mungko ka di naan dapit ta ake i na tuo asta na mapirdi ko imo na mga kuntra.”’ ” ");
INSERT INTO cgc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ambal man Jesus, “Daw iling tan ambal Ari David parti ta Pinili Ta Dyos Na Mag-ari na paumaw din na iya na Ginuo, di' ba Pinili Ta Dyos Na Mag-ari dili nang basta na linai Ari David?” Tama na mga ittaw na naan dya gamati ki Jesus daw nalipay danen ta iran na namatian. ");
INSERT INTO cgc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na gatudlo Jesus i ta mga ittaw, gambal kanen, “Mag-amblig na dili kaw magparyo ta mga manugtudlo ta Mga Sinulat Moises. Daw mamasyar danen an, gasuot danen ta langkaw na bayo na maalen aged ipakita na datas iran na katengdanan. Daw naan danen an ta lugar na naan dya tama na mga ittaw, liag gid danen na mga ittaw mag-atag ta taod ki danen. ");
INSERT INTO cgc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Daw naan danen an ta mga balay tipunan, liag gid danen na naan danen ta pungkuan na para ta impurtanti na mga ittaw. Iling man tan daw mandegek danen an. ");
INSERT INTO cgc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sikad man danen an manluko ta mga balo na bai daw paubos danen pangabuian ta mga balo. Gapakuno-kuno danen an na riliyuso paagi ta lawig na pangamuyo naan ta tama na mga ittaw aged dili mlaman na mga pabuat an danen malain. Tenged iling tan mga buat danen, maageman danen segeng na silot ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na Jesus i naan ta Timplo, gamungko kanen tengnged ta ugsakan ta alad daw gatan-aw ta mga ittaw na gaulog dya ta iran na kwarta. Tama na mga manggaranen gaulog ta bakod na kantidad. ");
INSERT INTO cgc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","May gaprani na balo na bai na pubri. Paulog din darwa na sinsilyo na derse na may pinakatise na balor. ");
INSERT INTO cgc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Paumaw Jesus na marani iya na mga tinudluan daw ambal din, “Daw lagen, sise gid paulog an ta pubri na balo. Piro, sugiran ta kyo na mas bakod pa naatag din kaysa ta naatag ta tanan na gaulog ta kwarta para ta Timplo ");
INSERT INTO cgc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","tak paalad an danen subla nang ta iran na mga manggad na dili en danen kinanglan. Piro, maskin ula gid ta ula balo an, paalad din tanan din na pangabuian.” ");
INSERT INTO cgc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na gapanaw Jesus i na mwa ta Timplo, isya ta iya na mga tinudluan gambal, “Mistro, lagen no. Dayad Timplo i! Darko mga bato an na pagamit ta pagbuat ta Timplo daw dayad na pagpatindeg ta mga bilding!” ");
INSERT INTO cgc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sabat Jesus ki kanen, “Matuod nyan. Makita nyo pa yi na mga bilding na dayad, piro mabot adlaw na magubba gid Timplo i daw tanan na bato ta Timplo mawasak na ula gid maskin isya nang na bato na gasampaw pa naan ta duma na bato.” ");
INSERT INTO cgc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Giling danen i Jesus naan ta Bukid Olibo. Na gamungko kanen i dya na gatubang ta Timplo, danen i Pedro, Santiago, Juan daw Andres gainsa ki kanen na danen nang, ");
INSERT INTO cgc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sugiran kay no tuo daw kan-o matabo nyan na paambal no. Ino sinyalis na pamatuod na mabot en timpo na matuman ambal no?” ");
INSERT INTO cgc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ambal din ki danen, “Mag-andam kaw gid aged dili kaw maluko ");
INSERT INTO cgc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","tak tama na mga ittaw miling ki kyo na akuon danen ake na ngaran ta iran na kaugalingen daw ambalen danen, ‘Yaken i Pinili Ta Dyos Na Mag-ari.’ Ta iling tan na buat danen, tama na ittaw maluko danen. ");
INSERT INTO cgc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Daw kamati kaw ta mga gira na dani ki kyo daw kabalita na naan ta madyo may gira man, dili kaw mataranta tak naan ta plano ta Dyos na matabo anay iling an tan. Piro, katapusan ta yi na timpo mabot pa. ");
INSERT INTO cgc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mga nasyon maggiraay daw mga kaarian kuntra ta kaarian. May mga linog naan ta lain-lain na mga lugar daw may segeng na letem. Piro, tanan na iling tan umpisa nang pa ta segeng na kakulian na maagian ta mga ittaw paryo ta mabatyagan ta bai na manugbata en na umpisa nang pa gapasakit. ");
INSERT INTO cgc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mag-andam kaw tak may mga ittaw na magdakep ki kyo na intriga kaw naan ta mga gadumala ta inyo na banwa aged usisaen. Tenged ta inyo na pagsunod ki yaken, kastiguon kaw naan ta mga balay tipunan daw patubangen naan ta mga gubirnador daw mga ari. Daw naan dya, magpamatuod kaw naan ki danen parti ta inyo na pagpati ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Miad na balita parti ta pagdumala ta Dyos masugid anay naan ta mga ittaw ta tanan na nasyon bag-o mabot katapusan ta yi na timpo tak iling tan plano ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ta timpo na kyo dakepen daw dleen naan ta kurti, dili kaw dayon magpalibeg daw ino isabat nyo. Daw uras en na kyo kinanglan na mag-ambal, iambal nyo nang paambal an ta Dyos Ispiritu Santo ki kyo tak alin ki kanen inyo na iambal, dili alin ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Gambal pa Jesus i, “Ta yon man na timpo ta kakulian, may mga ittaw na iran na mga utod ipapatay danen paagi ta iran na pagtraydor. Iling man tan buaten ta mga amay naan ta iran na kabataan. Mga bata magbatok ta iran na mga ginikanan daw ipapatay man danen iran na mga ginikanan. ");
INSERT INTO cgc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Demetan kaw ta tanan tenged sakep kaw ki yaken. Piro, maluwas mga ittaw na magpadayon ta iran na pagpati ki yaken asta ta katapusan ta yon na timpo.” ");
INSERT INTO cgc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ambal pa Jesus, “Ta timpo na mabot, makita nyo na naan ta dili dapat betangan ‘sikad malain na betang na gainsulto ta balay ta Dyos’.” -- Kyo na gabasa ta nasulat na i, intindien nyo gid daw ino beet ambalen. Ambal pa gid Jesus, “Daw iling tan makita nyo naan ta dili dapat betangan, beet ambalen abot en timpo na mga ittaw na gaistar naan ta prubinsya Judea dapat magbakwit naan ta mga bukid. ");
INSERT INTO cgc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ta yon man na timpo, daw matabuan na may ittaw na naan ta atep ta iran na balay, dapat na magbakwit dayon na dili en melled pa naan ta balay daw magkamang ta bisan ino. ");
INSERT INTO cgc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Iling man tan, daw matabuan na may ittaw na naan ta iya na uma, dapat na dili en muli pa na magkamang ta pang-isleb din na bayo. ");
INSERT INTO cgc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ta yon man na timpo, kaluluoy gid mga bai na gabagnes daw gapasuso tak mabellayan danen ta pagbakwit. ");
INSERT INTO cgc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mangamuyo kaw nang ta Dyos na dili matabo iling an tan naan ta tagtignaw ");
INSERT INTO cgc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","tak ta yon man na timpo maagian ta mga ittaw segeng na kakulian na ula pa naagii ta bisan kino alin ta pagbuat ta Dyos ta kalibutan i daw kalangitan asta anduni. Ula en may matabo pa na mas segeng na kakulian kaysa ta iling tan. ");
INSERT INTO cgc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Daw dili palipuon ta Ginuo Dyos mga inadlaw na ya na maagian danen, ula gid may isya na ittaw na mabilin na bui. Piro, palipuon din nang tenged ta iya na pinili na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ta yon man na timpo, daw may mambal ki kyo, ‘Lagen nyo, anen di en Pinili Ta Dyos Na Mag-ari!’, dili kaw magpati. Iling man tan daw may mambal, ‘Lagen nyo, kanen man nyan!’ ");
INSERT INTO cgc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","tak may miling ki kyo na mga dili-matuod na Pinili Ta Dyos Na Mag-ari daw mga dili-matuod na prupita. Magbuat danen an ta mga katingalaan na pamatuod na danen an may gaem aged na daw maimo, tilawan na maluko danen asta pa ta mga ittaw na pinili ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Magbantay kaw tak nasugid ko en daan ki kyo parti ta matabo pa mintras na ula pa natabo.” ");
INSERT INTO cgc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Gambal pa gid Jesus i parti ta mga adlaw na mabot, “Sunod ta yon man na mga adlaw na may mga segeng na kakulian, ‘Magdelem adlaw an daw bulan an dili magpawa. ");
INSERT INTO cgc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mga bituon an mulog alin ta langit daw tanan na naan ta kalangitan manlatak na paryo ta payegyeg.’ ");
INSERT INTO cgc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Pagtapos ta mga matabo na iling tan, makita ta mga ittaw Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. Mabot kanen na naan kanen ta panganod na bakod gid iya na gaem daw sikad silaw na pawa ta Dyos naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pag-abot din, ipadala din mga angil naan ta appat na pamusod ta kalibutan aged tipunon mga ittaw na iya na pinili alin ta tanan na lugar.” ");
INSERT INTO cgc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Gambal pa Jesus i, “Intindien nyo daw ino beet ambalen ta paanggid na isturya ta kaoy na igos: Daw iya an na mga sanga gasalingsing daw gadaon, mlaman nyo na mabot en tagtanem. ");
INSERT INTO cgc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yon man, daw makita nyo na gaumpisa en matabo mga pasugid ko ki kyo, sigurado gid na mlaman nyo na kanen an mabot en na paryo naan en kanen ta gwa ta gangaan. ");
INSERT INTO cgc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sugiran ta kyo na tanan ya na mga pasugid ko ki kyo matabo na ula pa napatay tanan na mga ittaw ta yi na timpo. ");
INSERT INTO cgc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maski marwad pa kalangitan an daw kalibutan, ake i na mga ambal magpadayon asta ta ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Gambal pa Jesus i, “Parti daw ino adlaw daw uras na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mabot, ula may nalam bisan mga angil ta langit daw bisan man Bata Ta Dyos. Dyos Amay nang gid nalam. ");
INSERT INTO cgc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gani, mag-andam kaw daw magbantay tenged na ula nyo nlami daw kan-o kanen mabot. ");
INSERT INTO cgc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iling tan buaten nyo tenged Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan paryo ta ittaw na gapanaw na miling ta madyo na lugar, piro bag-o kanen malin, paintriga din naan ta iya na mga suguon mga ubraen an danen. Kada isya ki danen may iya na ubra. Paambalan din man iya na manugbantay ta gangaan na magbantay gid. ");
INSERT INTO cgc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iling man tan, magbantay kaw tak ula nyo nlami daw kan-o mabot kanen na paryo ta tag-iya ta balay. Basi mabot kanen ta semsem, tenga kilem, mapit-madlaw, o pagsennang ta adlaw. ");
INSERT INTO cgc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Magbantay kaw pirmi ta iya na pag-abot aged daw gulpi kanen mabot, dili kaw mabutan na gatunuga daw ula gabantay. ");
INSERT INTO cgc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ambal ko i ki kyo, paambal ko man naan ta tanan: ‘Magbantay kaw!’” ");
INSERT INTO cgc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na darwa nang en adlaw bag-o mag-umpisa Pista Ta Paglibri Alin Ta Egipto daw Pista Ta Tinapay Na Ula Pampaabok, mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises gangita pa ta paagi na ipadakep danen Jesus i ta sikrito nang daw ipapatay. ");
INSERT INTO cgc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Piro, gambal danen an, “Dili ta anay buaten ate na plano naan ta timpo ta pista tak basi maggamo mga ittaw an.” ");
INSERT INTO cgc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Giling Jesus i naan ta baryo na Betania daw gadayon naan iran Simon. Simon i, kala ta mga ittaw na kanen i dati na may segeng na masakit ta langgit. Na gakaan Jesus naan iran Simon, may bai na gaprani ki Jesus. May dala kanen an na tise na tibod na buat alin ta bato na alabastro na may ugsak na puro na paammot na maalen na buat alin ta tanem na nardo. Pabali din lieg ta tibod daw paammot an pabubo naan ta ulo Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Piro, duma na mga ittaw na naan dya gagilek daw gaisturyaay, “Man-o tak pauyakan din nang paammot an? ");
INSERT INTO cgc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pwidi pa inta mabligya nan ta tallo gatos na sinsilyo na pilak daw kwarta ya iatag naan ta mga imol.” Tenged iling tan iran na isip, pasaway gid danen bai an. ");
INSERT INTO cgc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Piro, ambal Jesus ki danen, “Largaan nyo nang kanen i. Man-o tak pasaway nyo? Dayad iya na pabuat ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mga imol an pirmi nyo duma daw pwidi kaw katabang ki danen bisan ino uras na liag nyo. Piro, yaken i a, dili en maglugay na duma ki kyo. ");
INSERT INTO cgc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yi na bai gaatag ta iya na masarangan para ki yaken. Ta iya na pagbubo naan ki yaken ta paammot, papriparar din lawa ko para ta ake na lebbeng. ");
INSERT INTO cgc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dayad gid iya na pabuat ki yaken daw sugiran ta kyo na bisan indi mawali miad na balita naan ta bilog na kalibutan, pabuat din i ki yaken masambit man para ta pagdemdem ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote na isya ta dusi na apustulis giling naan ta mga manugdumala na mga pari daw gambal na Jesus ya matrayduran din daw intriga naan ki danen. ");
INSERT INTO cgc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagmati danen ta ambal din, nadayaran gid danen an ta iya na plano daw gangako na tagan kanen an ta kwarta. Umpisa ta yon man na uras, gangita en kanen ta tsansa na matrayduran din daw maintriga Jesus an naan ki danen. ");
INSERT INTO cgc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Abot una na adlaw ta Pista Ta Tinapay Na Ula Pampaabok. Yon man adlaw ta pag-iyaw ta mga karniro na bata pa na patagana para ta yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto. Gainsa mga tinudluan i Jesus ki kanen, “Indi no liag na kami i miling aged magpriparar para ki kaon ta yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto?” ");
INSERT INTO cgc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pasugo din darwa ta iya na mga tinudluan na ambal din, “Miling kaw naan ta syudad. Pag-abot nyo dya, may masugat kaw na mama na gapas-an ta bandi na may waig. Sunuron nyo kanen ya. ");
INSERT INTO cgc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Daw indi kanen melled na balay, ambalen nyo naan ta tag-iya, ‘May insa Mistro ya ki kaon. Yi insa din, “Indi selled na dayunan para ta bisita na naan a dya maan kani duma ta mga tinudluan ko ta yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto?”’ ");
INSERT INTO cgc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pag-ambal nyo, ipakita ta tag-iya ki kyo wayang na selled naan ta apaw na tanan na mga kinanglan anen dya en. Naan kaw dya magpriparar ta ate na yapon.” ");
INSERT INTO cgc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pagtapos ta ambal Jesus, gapanaw darwa na tinudluan daw giling naan ta syudad. Nakita danen selled ya na pasambit Jesus tak tanan na paambal din ki danen natuman. Na naan en danen ta selled ya, gapriparar danen an ta yapon ta pagsilibrar ta pista. ");
INSERT INTO cgc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na semsem en, Jesus i daw dusi na apustulis gabot dya. ");
INSERT INTO cgc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na gayapon danen, gambal Jesus i, “Gaduma kaw anduni ki yaken ta pagkaan, piro sugiran ta kyo na isya ki kyo na gakaan man duma ki yaken magtraydor ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pagmati ta mga apustulis, nasebean danen an daw kada isya ki danen gambal ki kanen, “Dili yaken nya, di' ba?” ");
INSERT INTO cgc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ambal din, “Magtraydor an ki yaken isya ki kyo na dusi na kanen an gasawsaw man ta tinapay naan ta mangkok duma ki yaken. ");
INSERT INTO cgc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Matuman gid en ambal naan ta sinulat na pulong ta Dyos na mapatay Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. Piro, ittaw an na magtraydor ki kanen may segeng na silot na maageman daw miad pa na ula nang en kanen an natao.” ");
INSERT INTO cgc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na gakaan pa Jesus i daw mga apustulis, gakamang kanen i ta tinapay daw gapasalamat ta Dyos. Pabiak-biak din daw paatag ki danen na ambal din, “Mamang kaw ta tinapay i. Yi ni ake na lawa.” ");
INSERT INTO cgc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagtapos danen kamang ta tinapay, gakamang Jesus i ta ineman na may ugsak na bino daw gapasalamat ta Dyos. Paatag din ki danen daw tanan danen gainem. ");
INSERT INTO cgc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Gambal Jesus i, “Yi ni ake na lengngessa na kalig-enan ta kasugtanan na alin ta Dyos. Matulo ake na lengngessa na yaken i mapatay bilang alad para ta tama na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iling gid tan beet ambalen ta yi na bino daw sugiran ta kyo na dili aren minem isab ta bino asta mabot adlaw na yaken i minem ta bag-o na bino naan ta pag-umpisa ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gakanta danen ta pagdayaw naan ta Dyos daw pagtapos, gagwa danen na miling naan ta Bukid Olibo. ");
INSERT INTO cgc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na Jesus i daw mga apustulis naan en ta Bukid Olibo, ambal din ki danen, “Mabot uras na kyo tanan dilian a nyo paryo ta ambal naan ta sinulat na pulong ta Dyos na Dyos gambal, ‘Patayen ko manugbantay an, dason wasaken ko panen na mga karniro.’” ");
INSERT INTO cgc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ambal pa Jesus, “Pagbannaw ki yaken, muna a ki kyo na miling naan ta Galilea.” ");
INSERT INTO cgc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Gambal Pedro i ki kanen, “Dili ta kaw dilian bisan dilian ka ta tanan!” ");
INSERT INTO cgc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sabat din, “Dayad gid inta ambal no an, piro sugiran ta kaw na anduni ta yi gid na kilem bag-o magtagaok manok ta pangarwa bisis, kambal ka en ta tallo bisis na dili a no kala.” ");
INSERT INTO cgc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piro, galalis gid Pedro i na gambal, “Bisan patayen a pa duma ki kaon, dili a mag-ambal na dili ta kaw kala.” Pag-ambal Pedro, iling man tan ambal ta tanan din na duma. ");
INSERT INTO cgc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesus i daw mga apustulis giling naan ta lugar na paumaw na Getsemane. Pag-abot danen dya, gambal kanen i ki danen, “Mungko kaw nang di anay tak mangamuyo a unso.” ");
INSERT INTO cgc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pag-ambal din, pakuyog din danen i Pedro, Santiago daw Juan. Umpisa sa, gangalised kanen i daw nasebean gid ");
INSERT INTO cgc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","na ambal din ki danen, “Daw paryo a gid mapatay ta subla na kalised. Unti kaw nang. Magpulaw kaw na magbantay-bantay.” ");
INSERT INTO cgc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na gapanaw kanen i naan ta unaan, gadapa naan ta basak daw gapangamuyo na daw maimo dili din maagian segeng na kabellay na naan ta plano ta Dyos para ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Gapangamuyo kanen i, “Amay ko! Tanan maimo no. Ipamadyo no ki yaken segeng na kabellay na maagian ko. Piro, dili ake na liag matuman, imo na liag.” ");
INSERT INTO cgc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pagtapos Jesus ta pagpangamuyo, gabalik kanen i ki danen Pedro daw naabutan din na gatunuga. Gambal kanen ki Pedro, “Simon, man-o tak gatunuga ka? Ino, dili ka gid kaagwanta bisan isya nang uras na magpulaw na magbantay-bantay?” ");
INSERT INTO cgc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ambal din ki danen, “Magpulaw kaw daw mangamuyo aged dili kaw mapirdi ta pagtilaw na mabot ki kyo. Liag nyo inta na magpulaw daw mangamuyo, piro dili kaya ta inyo na lawa.” ");
INSERT INTO cgc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Gapanaw isab Jesus i naan ta unaan daw mangamuyo na paryo man gyapon ta una din ya na pangamuyo. ");
INSERT INTO cgc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na gabalik isab kanen i ki danen Pedro, naabutan din na gatunuga eman tak puyat gid danen an. Pagpukaw din ki danen, dili danen mlaman daw ino iran na iambal ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta pangallo na bisis gapangamuyo Jesus daw pagtapos din ta pagpangamuyo, gabalik isab kanen an ki danen. Paambalan din danen an, “Aree! Gatunuga kaw pa man yan gyapon daw gapuay? Usto en. Lagen nyo! Uras en na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan trayduron daw intriga naan ta malain na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mangon kaw! Gabot en ittaw an na magtraydor ki yaken. Mos, sugaten ta kanen an.” ");
INSERT INTO cgc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na gambal pa Jesus i ki danen Pedro, nali nang gabot Judas an na isya ta dusi na apustulis. Tama na mga ittaw duma din na may dala na mga ispada daw mga baston. Pasugo danen an ta mga manugdumala na mga pari, mga manugtudlo ta Mga Sinulat Moises daw mga gadumala ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas an na traydor, bag-o kanen miling ki Jesus, gambal daan kanen an naan ta mga magdakep ki Jesus daw ino iya na sinyas para makala danen Jesus an. Ambal din, “Daw kino mabugno ko paagi ta arek, yon inyo na papangita. Dakepen nyo kanen an daw dleen nyo na bantayan gid ta usto.” ");
INSERT INTO cgc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tenged ta ambal daan Judas, na gabot danen an, gadiritso kanen i ki Jesus daw magbugno, “Mistro!” daw paarekan din. ");
INSERT INTO cgc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dayon, padakep danen Jesus i. ");
INSERT INTO cgc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piro, isya ki danen na gatindeg dani ki Jesus gagabot ta ispada daw patigbas suguon ya ta pinakadatas na manugdumala ta mga pari daw nalantep gid iya na talinga. ");
INSERT INTO cgc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Gambal Jesus i ki danen, “Man-o, tulisan a na kinanglan gid na magdala kaw pa ta mga ispada daw mga baston ta pagdakep ki yaken? ");
INSERT INTO cgc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Adlaw-adlaw naan a ta Timplo na gatudlo daw naan kaw man dya, piro ula a nyo dakepa. Piro, kinanglan na matuman plano ta Dyos parti ki yaken paryo ta ambal naan ta sinulat na pulong din.” ");
INSERT INTO cgc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pag-ambal Jesus, padilian kanen i ta mga apustulis daw danen ya tanan gadlagan padyo. ");
INSERT INTO cgc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","May isya na miron dya na gasunod ki Jesus. Ula kanen duma na suot daw dili, isya nang panid ta tila na lino na paabel din. Awiran inta kanen an ta mga sundalo aged dakepen, ");
INSERT INTO cgc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","piro gamallos kanen an daw pabilin din iya na bayo. Gadlagan kanen padyo na palaw. ");
INSERT INTO cgc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mga ittaw na gadakep ki Jesus, padala danen kanen an naan ta istaran ta pinakadatas na manugdumala ta mga pari. Naan man dya gatipon mga manugdumala na mga pari, mga gadumala ta mga Judio daw mga manugtudlo ta Mga Sinulat Moises. ");
INSERT INTO cgc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro i gasunod ki Jesus, piro madyo iya na antad. Gaselled kanen i naan ta sular ta istaran ta pinakadatas na manugdumala ta mga pari daw gapungko duma ta mga gwardya aged magpadangga naan ta apoy. ");
INSERT INTO cgc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mga manugdumala na mga pari daw tanan na mimbro ta Sanedrin na kadatasan na kunsiyo ta mga Judio gangita ta ibidinsya aged Jesus i masintinsyaan ta kamatayen. Piro, ula danen may nakita. ");
INSERT INTO cgc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tama gatistigo ta dili matuod kuntra ki kanen. Piro, ula gasaktuay iran na mga sugid. ");
INSERT INTO cgc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","May mga ittaw dya na gatistigo ta dili matuod kuntra ki kanen na iling ti ambal danen, ");
INSERT INTO cgc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Namatian nay na kanen an gambal, ‘Gubbaen ko yi na Balay Ta Dyos na buat ta mga ittaw daw seled ta tallo na adlaw magpatindeg a ta isya na Balay Ta Dyos na dili buat ta ittaw.’” ");
INSERT INTO cgc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piro, iran na mga ambal ula man gyapon gasaktuay. ");
INSERT INTO cgc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pagtapos ta ambal ta mga gatistigo, gatindeg pinakadatas na manugdumala ta mga pari naan ta tubangan daw painsaan din Jesus i, “Ula ka may isabat ta iran na ambal kuntra ki kaon?” ");
INSERT INTO cgc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ula gid gasasaba Jesus i. Painsaan eman kanen i ta pinakadatas na manugdumala ta mga pari, “Ino, kaon gid Pinili Ta Dyos Na Mag-ari na Bata Ta Padayaw Ta Na Dyos?” ");
INSERT INTO cgc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sabat Jesus, “Ee, yaken. Makita nyo Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan na gamungko en naan tengnged ta Dyos Na Makagagaem naan dapit ta tuo daw makita nyo man na kanen mabot na naan ta panganod naan ta kalangitan.” ");
INSERT INTO cgc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagmati ta pinakadatas na manugdumala ta mga pari, pagisi din iya na kaugalingen na bayo ta subla din na kagilek. Gambal kanen an, “Dili en kinanglan na may ittaw pa na magtistigo! ");
INSERT INTO cgc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kyo mismo kamati na iya na ambal insulto ta uturidad ta Dyos. Ta, ino ta inyo?” Gaisya danen tanan ta ambal na nakasala Jesus an daw dapat na sintinsyaan ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Duma an ki danen gaileb ki Jesus. Paperengan danen mata din an daw tiruon kanen an daw ambal danen, “Lagpaten no tuo daw kino gatiro ki kaon?” Pagtapos danen tiro, pakamang kanen an ta mga gwardya daw tabangan ta tampaling. ");
INSERT INTO cgc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na Pedro i naan pa ta sular ta istaran ta pinakadatas na manugdumala ta mga pari, may gaagi dya na bai na isya ta mga suguon ta pinakadatas ya na pari. ");
INSERT INTO cgc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na nakita din Pedro i na gapadangga naan ta apoy, patan-aw din gid ta miad daw mambal, “Di' ba kaon yan duma Jesus na taga-Nazaret?” ");
INSERT INTO cgc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piro, ula gaako Pedro i. Ambal din, “Ula a nalam daw ino paambal no an.” Pag-ambal din, giling kanen naan dani ta ngaan na paselled ta sular. Dayon, gatagaok manok. ");
INSERT INTO cgc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na Pedro i naan dani ta ngaan na paselled ta sular, nakita isab kanen i ta suguon na bai daw gambal isab bai an parti ki kanen naan ta mga ittaw na gatindeg dya, “Yi na ittaw isya ta mga duma Jesus.” ");
INSERT INTO cgc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piro, ula eman gaako kanen i. Ta ula nang lugay, mga ittaw na gatindeg dani ki Pedro gambal ki kanen, “Kaon isya gid ki danen na duma ki Jesus tak taga-Galilea ka.” ");
INSERT INTO cgc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piro, ganapa gid Pedro i daw gambal, “Bisan silutan a pa, ula a gid kakala ta ittaw na pambal nyo!” ");
INSERT INTO cgc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pag-ambal Pedro, dayon gatagaok manok ta pangarwa na bisis. Nademdeman Pedro ambal ya Jesus ki kanen, “Bag-o magtagaok manok ta pangarwa bisis, kambal ka en ta tallo bisis na dili a no kala.” Pagdemdem din, ula kanen i kapegeng ta iya na kaugalingen daw gagal gid kanen i. ");
INSERT INTO cgc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagsennang ta adlaw, dayon mga manugdumala na mga pari, mga gadumala ta mga Judio, mga manugtudlo ta Mga Sinulat Moises daw tanan na mimbro ta Sanedrin na kadatasan na kunsiyo ta mga Judio gasapol daw gasugtanay ta sunod na buaten danen ki Jesus. Papagapos danen kanen i daw padala daw paintriga naan ki Gubirnador Pilato. ");
INSERT INTO cgc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Gainsa Pilato ki kanen, “Kaon ari ta mga Judio?” Sabat Jesus, “Kaon en gambal san.” ");
INSERT INTO cgc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tama akusar ta mga manugdumala na mga pari kuntra ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gainsa eman Pilato ki kanen, “Ino, ula ka may isabat ta iran na mga akusar? Tama gid iran na akusar kuntra ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piro, Jesus i ula gid gasabat daw Pilato gatingala gid. ");
INSERT INTO cgc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kada Pista Ta Paglibri Alin Ta Egipto, kaugalian Pilato na magpalibri kanen an ta isya na priso na papangabay ta mga ittaw na librien. ");
INSERT INTO cgc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ta timpo na Jesus patubang ki Pilato, naan ta prisuan may mama na ngaran din Barabas. Kanen an daw mga duma din na gakuntra man ta gubirno napriso tak kapatay danen ta ittaw ta iran na paggamo kuntra ta gubirno. ");
INSERT INTO cgc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mga ittaw gaprani ki Pilato daw gapangabay na magpalibri kanen ta isya na priso paryo ta iya na kaugalian. ");
INSERT INTO cgc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kanen i gainsa, “Liag nyo na librien ko ari i ta mga Judio?” ");
INSERT INTO cgc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iling tan ambal din tak nlaman din na Jesus i paintriga ki kanen ta mga manugdumala na mga pari tenged nang ta iran na inggit ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piro, mga ittaw an pasegyet ta mga manugdumala na mga pari na Barabas nang en iran na pangabayen na librien, dili Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato gainsa eman, “Ino buaten ko ta ittaw i na paambal nyo na ari ta mga Judio?” ");
INSERT INTO cgc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Gasinggit danen an, “Ilansang kanen an naan ta krus!” ");
INSERT INTO cgc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Insa Pilato, “Man-o, ino gid nabuat din an na sala?” Piro, patuduan pa gid danen iran an na singgit, “Ilansang kanen an naan ta krus!” ");
INSERT INTO cgc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tenged liag Pilato na mga ittaw an malipay ta iya na disisyon, palibri din Barabas ya. Gasugo kanen na Jesus i latiguon daw intriga naan ta mga sundalo na maglansang ki kanen naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Padala ta mga sundalo Jesus i naan ta iran na kampo na naan ta selled ta sular ta palasyo ta gubirnador. Palasyo an paumaw man na Pretorio. Patipon danen libot ki Jesus tanan na sundalo ta iran na batalyon na naan dya gakampo. ");
INSERT INTO cgc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pasuutan danen Jesus i ta kapa na kulor bayulit. Galubid danen ta blagen ta telleken na tanem daw pabuat na kuruna daw pabetang naan ta iya na ulo. ");
INSERT INTO cgc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Gambal danen i ki kanen, “Mabuay ari ta mga Judio!” ");
INSERT INTO cgc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tama bisis na papukpok danen ta baston iya na ulo daw paileban pa gid danen kanen an. Paluod-luuran man danen daw pasimba-simba. ");
INSERT INTO cgc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagtapos danen ta pagpagayya ki kanen, pakamang danen kapa ya na bayulit daw pasuutan isab kanen an ta iya na bayo daw padala mwa ta syudad aged ilansang naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na Jesus i padala ta mga sundalo pagwa ta Jerusalem, nasugat danen mama na ngaran din Simon na naan galin ta uma daw gapaselled en naan ta syudad. Simon ya taga-Cirene daw amay kanen an Alejandro daw Rufo. Papilit kanen an ta mga sundalo na pas-anen krus an na lansangan ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pagpas-an din, gapadayon danen ta iran na pagdala ki Jesus asta ta lugar na paumaw na Golgota na beet ambalen Bungyod Balbagol. ");
INSERT INTO cgc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pag-abot danen dya, papainem danen Jesus i ta bino na may simbog na bulong na mira, piro ula din inema. ");
INSERT INTO cgc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Palansang danen kanen i naan ta krus. Pagtapos ta paglansang, paulas-ulas danen iya na mga bayo paagi ta paggabot-gabutay aged mlaman daw ino na bayo makamang ta kada isya. ");
INSERT INTO cgc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tallo uras galambay en alin ta pagsennang ta adlaw na palansang danen Jesus i naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Naan ta karatula na naan dya nasulat akusar kuntra ki kanen, iling ti nasulat: ARI TA MGA JUDIO. ");
INSERT INTO cgc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na kanen i palansang naan ta krus, darwa na matakaw palansang man naan ta mga krus. Krus an ta mga matakaw patindeg na isya an naan dapit ta iya na tuo daw isya an a, naan dapit ta wala. ");
INSERT INTO cgc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ta iling tan na paagi, natuman ambal an naan ta sinulat na pulong ta Dyos, “Pabilang kanen an na isya man na kriminal.” ");
INSERT INTO cgc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mga ittaw na galambay dya gatande-tande gid ta pag-insulto ki Jesus na danen an gambal, “A! Ambal no gubbaen no Balay Ta Dyos daw patindegen isab seled ta tallo adlaw! ");
INSERT INTO cgc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Daw kaya no iling an tan, luwasen no imo an na kaugalingen! Manaog ka dyan ta krus yan!” ");
INSERT INTO cgc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iling man tan, Jesus i papagayyaan ta mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises. Gaisturyaay danen an, “Lagen nyo ittaw na yan! Paluwas din kabui ta duma na mga ittaw, piro iya an na kaugalingen na kabui dili din maluwas. ");
INSERT INTO cgc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kanen kon Pinili Ta Dyos Na Mag-ari na Ari Ta Mga Linai Israel. Dapat manaog kanen an dayon anduni alin ta krus aged patian ta kanen an.” Bisan mga matakaw na pasilutan ta kamatayen duma ki kanen, papagayyaan man danen kanen an. ");
INSERT INTO cgc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na ugto-adlaw en, gadelem bilog na lugar dya asta ta tallo uras. ");
INSERT INTO cgc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pag-abot ta katapusan ta pangallo na uras na gadelem, gasinggit Jesus i na bakod iya na kagi, “Eloi, Eloi, lema sabactani?” na beet ambalen, “Dyos ko, Dyos ko, man-o tak pabay-an a no?” ");
INSERT INTO cgc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Duma na mga ittaw na gatindeg dani ki Jesus kamati ta iya na singgit daw ambal danen, “Matian nyo! Paumaw din Elias ya!” ");
INSERT INTO cgc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Isya na mama gadlagan na mamang ta ispunga. Pasawsaw din ispunga an naan ta agsem na bino daw pabetang din naan ta ugbos ta baston daw padeel naan ta baba Jesus aged na masepsep. Ambal din, “Largaan nyo nang kanen an. Lagen ta abi daw mabot gid Elias ya daw kamangen kanen an naan ta krus.” ");
INSERT INTO cgc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gasinggit Jesus i na bakod iya na kagi daw nabugto iya na ginawa. ");
INSERT INTO cgc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kurtina ya naan ta Balay Ta Dyos nagisi na tenga gid alin ta apaw paebes. ");
INSERT INTO cgc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Upisyal ta mga sundalo na gatindeg naan ta atubangan Jesus kamati ta iya na singgit daw kakita gid na nabugto iya na ginawa. Gambal upisyal i, “Matuod gid man! Ittaw na yan Bata Ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","May mga bai na naan gatindeg ta madyo na gatan-aw ta mga natabo. Anen man dya danen i Maria Magdalena, Maria na inay Joses daw Santiago na paumaw na Angngod daw anen man dya Salome. ");
INSERT INTO cgc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na ula pa napatay Jesus i, na naan pa kanen ta Galilea, pirmi danen an gakuyog daw gatabang ki kanen. Tama pa man mga duma na bai gatan-aw ta mga natabo ki Jesus. Danen an gakuyog man ki Jesus ta iya na pag-iling naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Napatay Jesus naan ta Adlaw Ta Pagpriparar na yon man adlaw bag-o Adlaw Ta Pagpuay. Na mapon gid en, ");
INSERT INTO cgc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","nangiseg gid Jose i na taga-Arimatea na miling ki Pilato daw maglisinsya na kanen mamang ta lawa Jesus. Jose i kala na mimbro ta Sanedrin na kadatasan na kunsiyo ta mga Judio daw gapaabot kanen ta timpo na mag-umpisa pagdumala an ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na nasugiran Pilato na patay en Jesus, gatingala kanen an. Paumaw din upisyal ta mga sundalo daw painsaan daw matuod na patay en Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na namatian Pilato sugid ta upisyal na patay en Jesus, patugutan din Jose i na kamangen lawa Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Gapalit Jose i ta maalen na tila na lino. Pakamang din lawa Jesus naan ta krus daw putuson paagi ta pagblebed ta tila ya. Pabetang din lawa ya Jesus naan ta lebbengan na bato na palungagan na paryo ta kwiba. Pasaraan din lebbengan an ta bakod na bato na papaligid naan ta gangaan. ");
INSERT INTO cgc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nlaman Maria Magdalena daw Maria na inay Joses daw indi nalebbeng Jesus ya tak naan danen dya na gatan-aw ta paglebbeng Jose ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Paglambay ta Adlaw Ta Pagpuay na gasalep en adlaw daw umpisa una na adlaw ta duminggo, danen Maria Magdalena, Maria na inay Santiago daw Salome na iran na duma gapalit ta ammot na mga pamanyos aged betangan lawa Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta yon man na una na adlaw ta duminggo na bag-o nang pa gasennang adlaw, gapanaw danen an na miling ta lebbengan ya Jesus. ");
INSERT INTO cgc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta iran na pagpanaw, gainsaay danen an, “Ya! Kino taan kani magligid ta bato na sara ta lebbengan ya?” ");
INSERT INTO cgc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iling tan ambal danen tak sikad bakod bato ya. Pag-abot danen ta lebbengan, nakita danen na bato ya naligid en. ");
INSERT INTO cgc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gaselled danen naan ta lebbengan daw may nakita danen na isya na mama na batan-en. Iya na bayo puti na langkaw. Gamungko kanen naan dapit ta tuo ta selled ta lebbengan. Nadlek gid danen an. ");
INSERT INTO cgc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Gambal kanen ki danen, “Dili kaw madlek. Nlaman ko na papangita nyo Jesus ya na taga-Nazaret na nalansang naan ta krus. Kanen ya pabannaw en ta Dyos! Ula di en! Lagen nyo nabetangan ta iya na lawa. ");
INSERT INTO cgc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Miling kaw naan ta iya na mga tinudluan daw sugiran nyo danen ya, labi gid ki Pedro, na gauna Jesus ya ki danen naan ta Galilea. Naan danen dya makita kanen ya paryo ta iya na naambal ki danen.” ");
INSERT INTO cgc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Gagwa mga bai an naan ta lebbengan daw gadlagan. Sikad gid tingala danen daw gakereg ta subla na kulba. Ula danen gasugid ta maskin kino parti ta iran na inagian tak nadlek gid danen an. ");
INSERT INTO cgc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nabannaw Jesus i naan ta una na adlaw ta duminggo. Na sellem pa ta yon man na adlaw, una kanen gapakita naan ki Maria Magdalena. Maria Magdalena an bai na naan alin ki kanen napagwa Jesus pitto na malain na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pagkita Maria ki Jesus, giling kanen naan ta mga tinudluan Jesus daw naabutan din na danen an gangasebe pa daw gangagal. Pasugiran din danen an na bui Jesus ya. ");
INSERT INTO cgc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Piro, ula danen gapati ta iya na sugid na Jesus ya bui daw gapakita ki kanen. ");
INSERT INTO cgc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesus i gapakita man na gabag-o iya na sura naan ta darwa din na tinudluan na danen gapanaw na miling naan ta baryo. ");
INSERT INTO cgc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pagkita danen ki kanen, gabalik danen an naan ta Jerusalem. Pasugiran danen iran na mga duma na Jesus i gapakita ki danen, piro ula man gyapon gapati iran na mga duma. ");
INSERT INTO cgc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ta uryan, gapakita Jesus i naan ta unsi na apustulis na danen an gakaan. Pagilekan din danen an tenged na ula danen gapati daw dessen iran na ulo tak ula gapati ta sugid ta mga kakita ki kanen pagtapos na kanen an pabannaw. ");
INSERT INTO cgc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pasugo Jesus danen an, “Miling kaw ta mga ittaw naan ta bilog na kalibutan daw isugid naan ki danen miad na balita parti ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Maluwas mga ittaw na magpati ta miad na balita daw magpabautismo, piro mga ittaw na dili magpati, maageman danen silot na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","May mga katingalaan na sinyalis na makita nyo na buaten ta mga ittaw na gapati. Iling ti mga sinyalis: Paagi ta pagsambit ta ake na ngaran, mapagwa danen malain na mga ispiritu na naan ta mga ittaw. Mambal danen an ta duma na mga linggwai na ula gani danen naistudyui. ");
INSERT INTO cgc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Dili danen an maino maskin mabitan danen mga bekkessan daw maskin kainem man ta ilo. Mapaayad danen mga ittaw an na may masakit paagi ta pagtungtong ta iran na mga lima.” ");
INSERT INTO cgc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagtapos ambal Ginuo Jesus ta mga apustulis, padala kanen i naan ta langit daw gapungko kanen naan tengnged ta Dyos naan dapit ta tuo. ");
INSERT INTO cgc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iya na mga tinudluan gawali naan ta bisan indi na lugar. Ta iran na pagwali, patabangan ta Ginuo danen an daw iran an na pawali pamatuuran din paagi ta mga katingalaan na nabuat danen.");
INSERT INTO cgc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dungganen na Teofilo, Tama na mga ittaw gatingwa naan ta iran na sulat ta pagsaysay ta tanan na parti ki Jesus na natabo en naan ta ame i na lugar. ");
INSERT INTO cgc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Iran na mga sulat paryas man ta pasugid ki kami ta mga ittaw na kakita mismo alin pa ta umpisa ta mga natabo ya daw gawali man ta miad na balita parti ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naisipan ko na miad pa na magsulat a man para masaysay ko ta miad parti an ki kanen tak nausisa ko ta usto tanan ya na natabo alin ta umpisa. Nyan na, gasulat a ki kaon, Teofilo, ");
INSERT INTO cgc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aged mlaman no na mga natudlo an ki kaon parti ki Jesus matuod gid. ");
INSERT INTO cgc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ta timpo Herodes na ari ta bilog na prubinsya Judea, may isya na pari ta Judio na ngaran din Zacarias. Kanen an sakep ta isya na grupo ta mga pari na paumaw na Abias. Sawa din Elisabet na alin man ta pamilya ta mga pari tak linai man Aaron. ");
INSERT INTO cgc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Danen na magsawa matareng na mga ittaw na gatuman ta liag ta Dyos. Ula masaway ki danen ta iran na pagtuman ta tanan na sugo daw tudlo na alin ta Ginuo Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ula danen an bata tak baog Elisabet an daw manakem en danen an. ");
INSERT INTO cgc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gabot timpo na Zacarias i naan ta Timplo na gasirbi ta Dyos tak rilibo ta mga pari ta grupo na Abias. ");
INSERT INTO cgc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na kanen naan ta Timplo, abot adlaw na kanen papili alin ta iya na grupo paagi ta gabot-gabutay na magsunog ta kamangyan na ialad naan ta Ginuo Dyos. Iling tan kaugalian ta mga pari ta iran na pagpili. Na uras en na magsunog ta kamangyan, gaselled kanen i naan ta Balay Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ta yo na uras na gasunog kanen i ta kamangyan, gapangamuyo mga ittaw an na gatipon naan ta gwa. ");
INSERT INTO cgc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na naan pa Zacarias i ta selled, may angil alin ta Ginuo Dyos na gapakita ki kanen na gatindeg naan dapit ta tuo ta sunugan ta kamangyan. ");
INSERT INTO cgc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkita din ta angil, nataranta gid kanen an daw nadlek. ");
INSERT INTO cgc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gambal angil i ki kanen, “Zacarias, dili ka madlek tak pangamuyo no ya namatian ta Dyos. Elisabet ya na sawa no magbata ta mama daw ngaranan no na Juan. ");
INSERT INTO cgc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bata na matao imo gid na kalipay. Tama man na ittaw malipay tenged natao kanen an ");
INSERT INTO cgc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tak kanen an tagan ta Ginuo Dyos ta bakod na katengdanan. Dili gid kanen an minem ta bino. Dili man minem ta maskin ino na inemen na makaingaw. Umpisa na naan ta gettek ta inay din, paubayan en kanen an ta Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pabaliken din naan ta Ginuo Dyos nakem an ta tama na kalai no na mga linai Israel na gamadyo ta inyo na Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Muna kanen an na miling ta mga ittaw aged laygayan danen an bag-o mabot Ginuo para kapriparar ta iya na pag-abot. Ta iya na paglaygay, gaeman kanen an ta Dyos Ispiritu Santo paryas ki Elias na prupita anay pa sa. Paagi ta iya na laygay, magdayad nakem an ta mga amay naan ta iran na mga bata daw magtareng isip an ta mga ittaw na ula gatuman ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Gainsa Zacarias i naan ta angil, “Ino pamatuod na matabo ambal no an? Manakem kay en!” ");
INSERT INTO cgc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sabat ta angil, “Yaken Gabriel. Naan a alin ta Dyos. Papadala a din na miling ki kaon aged magsugid ta miad i na balita parti ta buaten din para ki kaon. ");
INSERT INTO cgc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naan ta igo na timpo matuman gid pasugid ko i. Piro, tenged na ula ka gapati, kaon yan magparyas en ta apa. Dili ka makaambal keteb ta adlaw na matabo sugid ko i.” ");
INSERT INTO cgc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na gaisturyaay Zacarias i daw angil naan ta selled ta Balay Ta Dyos, mga ittaw ya na gapangamuyo naan ta gwa gatagad ki kanen. Gatingala danen ya man-o tak lugay kanen an mwa. ");
INSERT INTO cgc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Paggwa din, dili en kaambal. Naintindian ta mga ittaw na kanen i may nakita na katingalaan naan ta selled tak sigi nang en sinyas ki danen daw dili en makaambal. ");
INSERT INTO cgc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pagtapos ta rilibo Zacarias, guli kanen i. ");
INSERT INTO cgc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Paglambay ta pila na mga adlaw, Elisabet na sawa din gabagnes daw ula galin ta iran na istaran keteb ta limma bulan. ");
INSERT INTO cgc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet an gambal, “Miad tak Ginuo Dyos an naluoy ki yaken. Ta tabang din, dili aren magayya naan ta mga ittaw tak dili aren baog.” ");
INSERT INTO cgc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na annem en bulan pagbagnes Elisabet, pasugo isab ta Dyos angil Gabriel na miling naan ta banwa na Nazaret na sakep ta Galilea. ");
INSERT INTO cgc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","May ambalen kanen an na alin ta Dyos para ta isya na dlaga na ula pa natandeg ta mama. Ngaran din an Maria daw nakagunan kanen an ta mama na ngaran din Jose na linai Ari David. ");
INSERT INTO cgc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel i gapakita daw gaprani ki Maria daw gabugno, “Maria, sadya na adlaw para ki kaon. Napili ka para ta bakod na pribiliyo. Ginuo Dyos an gaubay ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pagmati Maria, ula din naintindii daw ino beet ambalen ta angil daw gakullaw kanen an man-o tak iling tan ambal ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ambal pa ta angil, “Maria, dili ka madlek tak patagan ka ta Dyos ta bakod gid na pribiliyo. ");
INSERT INTO cgc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mamati ka! Mabagnes ka daw magbata ta mama. Ngaranan no kanen na Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kanen an may bakod na katengdanan. Umawen kanen an na Bata Ta Dyos Na Labaw Ta Tanan. Tagan kanen an ta Ginuo Dyos ta katengdanan na mag-ari paryo ta kaapuan din na Ari David. ");
INSERT INTO cgc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mag-ari kanen an naan ta mga linai Jacob ta ula katapusan. Dili matapos iya an na pagdumala.” ");
INSERT INTO cgc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pagmati Maria, gainsa kanen ta angil, “Man-o na mabagnes a na yaken i ula natandeg ta mama?” ");
INSERT INTO cgc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sabat ta angil ki Maria, “Dyos Ispiritu Santo an mabot ki kaon daw magbagnes ka paagi ta paglekkep ki kaon ta gaem ta Dyos Na Labaw Ta Tanan. Gani, bata an na matao ki kaon alin gid ta Dyos daw umawen kanen an na Bata Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lagen no Elisabet ya na imo na parinti. Dati kanen ya baog, piro anduni gabagnes en ta bata na mama, maskin kanen an manakem en. Anduni annem en bulan pagbagnes din an ");
INSERT INTO cgc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tak ula impusibli ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pagmati Maria, ambal din, “Gapasakep a ta pagbeet ta Ginuo Dyos. Kabay pa na matuman paambal no an ki yaken.” Pagtapos ta ambal Maria, galin angil ya. ");
INSERT INTO cgc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Paglambay ta pila na mga adlaw alin ta pagsugid ta angil ki Maria, giling Maria i ta banwa danen Zacarias na naan ta kabungyuran na lugar ta prubinsya Judea. Gadali kanen an na magsud-o ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pag-abot din dya, gaselled kanen i naan ta balay danen Zacarias daw gaatag ta taod ki Elisabet. ");
INSERT INTO cgc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pagmati Elisabet ta ambal Maria, gulpi giyo bata an naan ta gettek din daw Elisabet i pagaeman ta Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nalipay gid Elisabet daw bakod iya na kagi na gambal kanen ki Maria, “Miad gid Dyos an ki kaon labaw ta tanan na bai. Miad man kanen an ta bata na matao ki kaon. ");
INSERT INTO cgc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kino a gid na pasud-o a no, kaon na inay ta Ginuo ko! ");
INSERT INTO cgc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nlaman ko na kaon inay ta Ginuo tak pagmati ko ta kagi no, bata i naan ta gettek ko gulpi nang giyo ta kalipay din. ");
INSERT INTO cgc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Malipay ka gid tak gapati ka na ambal ya ta Ginuo Dyos ki kaon matuman!” ");
INSERT INTO cgc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pagtapos ta ambal Elisabet, Maria i gambal, “Gadayaw a ta Ginuo Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nalipay a tenged ta Dyos na ake na Manluluwas. ");
INSERT INTO cgc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kademdem kanen an ki yaken na kebes din na suguon. Umpisa anduni, tanan na mga ittaw ta mga timpo na mabot mag-ambal na bakod gid pribiliyo ko ");
INSERT INTO cgc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tenged ta mga katingalaan na nabuat ta Dyos Na Makagagaem para ki yaken. Labaw gid kanen an ta tanan. ");
INSERT INTO cgc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bakod gid kaluoy din an naan ta tanan na mga gataod ki kanen umpisa ta una na timpo asta anduni daw ta ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pakita din na bakod iya na gaem paagi ta iya na mga buat. Papirdi din daw pawasak mga ittaw na ugal aged dili matuman iran na malain na mga plano. ");
INSERT INTO cgc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Papalin din mga gadumala an naan ta iran na mga datas na katengdanan, daw paatagan din ta datas na katengdanan mga kebes an. ");
INSERT INTO cgc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Paatagan din mga nakulian an ta iran na mga kinanglanen. Piro, mga manggaranen an papalin din na ula dala. ");
INSERT INTO cgc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Patabangan din mga linai Israel na iya na mga ittaw tak ula kanen an nalipat ta iya na pangako na maluoy kanen ki Abraham daw ta mga linai Abraham asta ta ula katapusan.” Yon ambal Maria ta iya na pagdayaw ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mga tallo bulan na gadayon Maria naan iran Elisabet bag-o muli. ");
INSERT INTO cgc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Abot uras na gabata Elisabet i daw mama iya na bata. ");
INSERT INTO cgc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Namatian ta mga silingan din daw iya na mga parinti parti ta bakod na kaluoy ta Ginuo Dyos ki kanen daw nalipay man danen an. ");
INSERT INTO cgc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta pangwallo na adlaw alin ta pagtao ta bata, patuman ta ginikanan din sirimunya an ta pagbuat ta tanda naan ta iya na lawa daw ta pag-atag ta ngaran. Duma na mga ittaw na gatambong ta sirimunya, liag danen na Zacarias ngaran an ta bata aged sangay ta amay din. ");
INSERT INTO cgc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Piro, dili miag iya na inay. Ambal inay din, “Dili pwidi tak ngaranan nay kanen an na Juan.” ");
INSERT INTO cgc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ambal danen naan ta iya na inay, “Man-o tak Juan na ngaran gusto nyo? Ula kaw man yan parinti na ngaran din an Juan.” ");
INSERT INTO cgc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pasinyasan danen Zacarias an daw ino liag din na ngaran na para ta iya na bata. ");
INSERT INTO cgc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Gasinyas Zacarias na tagan ta masulatan daw iling ti pasulat din, “Juan ngaran din.” Gatingala gid danen an tanan ta iya na nasulat. ");
INSERT INTO cgc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pagtapos din sulat, dayon kaambal isab kanen an na gadayaw ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mga kasilingan Zacarias gatingala gid na nadlek tenged ta mga natabo ki danen Zacarias. Balita an parti ki danen galapta ta tanan na mga banwa naan ta kabungyuran na lugar ta prubinsya Judea. ");
INSERT INTO cgc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tanan na mga kamati, paisip-isip danen, “Ino taan plano ta Ginuo Dyos ta yon na bata daw magbakod?” Iling tan iran na isip tak nlaman danen na paubayan kanen an ta Ginuo Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na kaambal en isab Zacarias i na amay Juan, pagaeman kanen an ta Dyos Ispiritu Santo daw ambal din: ");
INSERT INTO cgc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kiten na mga linai Israel, magdayaw ki ta Ginuo na ate na Dyos tak kiten na mga ittaw din pademdem din daw palibri man alin ta ate na mga kuntra. ");
INSERT INTO cgc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Padala din ki kiten isya na makagagaem na manluluwas na linai ta pasaligan din na Ari David. ");
INSERT INTO cgc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Paagi ta padala din na manluluwas, patuman din iya na pangako na nasugid paagi ta mga prupita anay pa sa na gasirbi ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Gapangako kanen na luwasen ki din alin ta ate na mga kuntra daw alin ta malain na plano ta mga gademet ki kiten. ");
INSERT INTO cgc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gapangako man kanen an na maluoy ta mga kaapuan na ate na alinan daw magtuman kanen an ta iya na pangako na dili din gid matalikuran. ");
INSERT INTO cgc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Yon mga pangako din ki Abraham na ate na alinan. Gasumpa kanen an na luwasen ki din alin ta ate na mga kuntra aged kiten i magsirbi ki kanen na ula ki adlek, ");
INSERT INTO cgc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ula masaway ki kiten daw pirmi ki magsunod ta iya na liag keteb bui ki pa. ");
INSERT INTO cgc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kaon na bata ko, umawen ka na manugsugid ta kabebet-en ta Dyos Na Labaw Ta Tanan. Kaon muna na miling ta mga ittaw bag-o mabot Ginuo para kapriparar danen ta iya na pag-abot. ");
INSERT INTO cgc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kaon magtudlo ta mga ittaw ta Dyos na danen an maluwas paagi ta pagpatawad din ki danen ta iran na mga sala. ");
INSERT INTO cgc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Tenged ate na Dyos miad daw maluluy-on, ipadala din ki kiten manluluwas na alin ta langit. Ta pag-abot ta manluluwas, kamangen din ate na adlek ta kamatayen na paryo kanen an ta adlaw na gasennang daw gapapawa ta lugar na delem. Tudluan ki din man daw ino buaten ta aged magtawway ate na kabui.” Yon ambal Zacarias ta iya na pagdayaw ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gabakod Juan na dayad iya an na pamatasan. Na bakod kanen an en, naan kanen an gistar ta lugar na ula kabalayan asta ta adlaw na mag-umpisa kanen an ta paglaygay naan ta mga linai Israel. ");
INSERT INTO cgc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta timpo na natao en Juan ya, Augusto na pangulo ta Roma gasugo na tanan na mga ittaw na sakep ta iya na pagdumala magpalista para masinsos. ");
INSERT INTO cgc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Tenged ta sugo Augusto, giling mga ittaw an naan ta mga banwa na alinan ta iran na kaapuan para magpalista. Yon una na sinsos na Cirenio gubirnador ta prubinsya Siria. ");
INSERT INTO cgc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tenged ta sinsos, galin Jose i ta banwa na Nazaret na sakep ta Galilea daw miling ta prubinsya Judea aged magpalista naan ta banwa na naan dya natao David ya tak kanen i linai David. Betlehem ngaran ta banwa David na pailingan din. ");
INSERT INTO cgc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maria na nakagunan din pakuyog din miling ta Betlehem aged magpalista man. Kabulanan en Maria na giling danen an ta Betlehem. ");
INSERT INTO cgc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na naan danen ta Betlehem, abot en uras na magbata Maria i. ");
INSERT INTO cgc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Gabata kanen an ta iya na panganay na isya na mama. Paputos din ta bakken bata i daw pabetang naan ta pakan-anan ta ayep. Danen an naan nang ta pasilungan ta mga ayep tak ula en bakanti naan ta balay dayunan. ");
INSERT INTO cgc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ta timpo na natao bata Maria, may mga manugbantay ta karniro na naan ta paalaban na dani ta Betlehem. Gapulaw danen an ta pagbantay ta iran na mga karniro. ");
INSERT INTO cgc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nali nang, may angil alin ta Ginuo Dyos na gapakita ki danen. Nasilakan danen an ta pawa na alin ta Ginuo Dyos daw nadlek gid danen an! ");
INSERT INTO cgc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Gambal angil ki danen, “Dili kaw madlek! Mamati kaw! May isugid a ki kyo na miad na balita na mag-atag ta bakod na kalipay ta tanan na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Anduni na adlaw naan ta banwa David natao en inyo an na Manluluwas. Kanen Pinili Ta Dyos Na Mag-ari na inyo na Ginuo! ");
INSERT INTO cgc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yi pamatuod ta ake na ambal ki kyo: Makita nyo tise an na bata na naputos ta bakken na naan ta pakan-anan ta ayep.” ");
INSERT INTO cgc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nali nang, may gapakita na sikad tama na mga angil na gaduma naan ta una ya na angil daw gadayaw ta Dyos. Ambal danen, ");
INSERT INTO cgc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Naan ta langit tanan na pagdayaw paatag naan ta Dyos. Naan ta kalibutan katawway ta kabui ta mga ittaw na gaatag ta kalipay ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na gabalik mga angil naan ta langit, gaisturyaay mga manugbantay i, “Mos! Miling ki naan ta Betlehem daw lagen ta natabo ya na pasugid ki kiten ta angil na papadala ta Ginuo Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gadali-dali danen an na miling naan ta Betlehem. Na naan en danen dya, nakita danen Maria an daw Jose daw nakita man danen bata an na naan ta pakan-anan ta ayep. ");
INSERT INTO cgc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pagkita danen, pasugid danen ambal ya ta angil parti ta bata an. ");
INSERT INTO cgc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tanan na ittaw na kamati ta iran na pasugid gatingala gid. ");
INSERT INTO cgc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Piro Maria i a, pirmi din pademdem daw paisip ta miad tanan na natabo parti ta iya na bata. ");
INSERT INTO cgc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mga manugbantay ya ta karniro gabalik naan ta paalaban na nalipay daw gadayaw danen naan ta Dyos tenged ta tanan na namatian daw nakita danen tak natuman gid sugid ya ta angil. ");
INSERT INTO cgc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta kawallo na adlaw alin ta pagtao ta bata Maria, gatuman Jose i daw Maria ta sirimunya ta mga Judio ta pagbuat ta tanda naan ta lawa ta bata na mama. Ta sirimunya ta pagbuat ta tanda, paatagan bata an ta ngaran na Jesus tak na ula pa gabagnes Maria i, sugo ta angil na ngaranan danen bata an na Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Paglambay ta kwarinta na adlaw alin ta pagbata Maria, giling danen i Jose daw Maria naan ta Jerusalem tak abot en igo na adlaw na miling ta Timplo na magtuman ta sugo naan ta Mga Sinulat Moises parti ta sirimunya ta paglimpyo para ta mga bai na gabata. Padala man danen Jesus i daw paalad naan ta Ginuo Dyos ");
INSERT INTO cgc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","tak patuman danen sugo ta Ginuo Dyos na nasulat na iling ti, “Kada panganay na bata na mama iya ta Ginuo Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Gaalad man danen ta mga yupan aged magtuman ta sugo ta Ginuo Dyos, “Mag-alad ka ta darwa na salampati. Daw dili salampati, pwidi man darwa na bata pa na tukmo.” ");
INSERT INTO cgc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","May mama na gistar naan ta Jerusalem na ngaran din Simeon. Matareng kanen an daw dyusnon daw gapaabot na tabangan ta Dyos mga linai Israel. Kanen an ittaw na paubayan ta Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nlaman din paagi ta Dyos Ispiritu Santo na bag-o kanen mapatay, makita din Pinili an Ta Ginuo Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta pag-ubay ta Dyos Ispiritu Santo ki kanen, giling kanen naan ta Timplo ta yon man na adlaw na Jesus i padala dya aged magtuman danen Jose ta mga sugo naan ta Mga Sinulat Moises parti ta panganay na bata na mama. Pagselled danen Jose naan ta Timplo, ");
INSERT INTO cgc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","gaprani Simeon ki danen daw pakengkeng din Jesus i. Gadayaw kanen ta Dyos na ambal din, ");
INSERT INTO cgc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ginuo Dyos, yaken na suguon no, pwidi no en bawien kabui ko. Tawway en ake na nakem na natuman pangako no ki yaken ");
INSERT INTO cgc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","tak nakita ko en Manluluwas i ");
INSERT INTO cgc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","na padala no para ta tanan na ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ipaintindi din ta mga ittaw na mga dili linai Israel parti an ta imo na kabebet-en. Tenged ki kanen, kami na imo na mga ittaw na mga linai Israel dayawen ta duma na mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na namatian ta mga ginikanan Jesus ambal Simeon parti ki Jesus, gatingala gid danen an. ");
INSERT INTO cgc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pabindisyunan Simeon danen an daw ambal din ki Maria, “Tenged ta bata no i, tama ki kiten na mga linai Israel magpadyo ta Dyos daw tama man magprani ta Dyos. Kanen i magtudlo parti ta kabebet-en ta Dyos, piro tama na mga ittaw magkuntra ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tenged ki kanen, ipakita ta Dyos daw ino gid naan ta isip ta mga ittaw. Kaon yan masakitan gid na paryo pabuno ta ispada imo na tagipusuon.” ");
INSERT INTO cgc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Naan man ta Timplo may bai na manakem gid en na manugsugid ta kabebet-en ta Dyos. Ngaran din Ana daw bata kanen i Fanuel na alin ta pamilya Aser. Pitto nang taon pagduma din ta iya na sawa daw nabalo en kanen i. ");
INSERT INTO cgc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Adlaw kilem kanen naan ta Timplo na gasirbi ta Dyos paagi ta pagpwasa daw pagpangamuyo. Idad din utsintay-kwattro na Jesus an padala danen Jose naan ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na gambal pa Simeon ya ki danen Maria, gaprani Ana i daw gapasalamat ta Dyos tenged ki Jesus. Gasugid man kanen i parti ki Jesus naan ta mga ittaw na galaem ta paglibri ta Dyos ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na natuman en Maria daw Jose tanan na sugo ta Ginuo Dyos na nasulat parti ta mga gabata, gabalik danen naan ta iran na banwa na Nazaret na sakep ta Galilea. ");
INSERT INTO cgc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesus i gabakod na miad iya na lawa. Gadugang iya na alam daw gaubay pirmi Dyos an ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kada taon ginikanan Jesus giling naan Jerusalem tenged ta Pista Ta Paglibri Alin Ta Egipto. ");
INSERT INTO cgc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na Jesus gaidad en ta dusi anyos, giling ginikanan din naan ta Jerusalem daw pakuyog kanen i aged mamista danen an tak yon iran na kaugalian. ");
INSERT INTO cgc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagtapos ta pista, gapanaw danen an Jose daw Maria na muli. Piro, ula danen nlami na gapabilin Jesus i naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Salig danen na kanen i naan nang gakuyog ta mga duma danen na guli. Isya en adlaw panaw danen Jose bag-o danen pangita Jesus i naan ta duma danen na mga grupo ta iran na mga parinti daw arey. ");
INSERT INTO cgc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Na ula danen nakita kanen i, gabalik danen an naan ta Jerusalem aged ngitaen. ");
INSERT INTO cgc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ta pangallo na adlaw alin ta pag-umpisa ta pagpangita, nakita danen Jesus naan ta Timplo na gamungko na duma ta mga mistro. Kanen i gamati daw gainsa ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tanan na kamati ki kanen gatingala tenged ta iya na alam daw mga sabat. ");
INSERT INTO cgc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na nakita Jesus i ta iya na ginikanan, gatingala danen an daw gambal Maria ki kanen, “Bata na i, man-o tak iling ti buat no ki kami? Kami amay no galibeg gid ta pangita ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sabat Jesus, “Man-o tak pangita a nyo? Dapat inta nlaman nyo na kinanglan na naan a di ta balay ta ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piro, ula kaintindi iya na ginikanan daw ino beet din ambalen. ");
INSERT INTO cgc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesus i gakuyog ta ginikanan din na malik naan ta Nazaret. Gatuman gid kanen an ki danen. Pirmi naan ta isip Maria tanan ya na natabo na parti ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Gabakod Jesus i daw gadugang iya na alam daw nalipay gid Dyos an daw mga ittaw ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ta pangkinsi na taon ta pagdumala Tiberio na pangulo ta Roma, Poncio Pilato gubirnador naan ta prubinsya Judea. Ta yon man na timpo Herodes gadumala naan ta Galilea. Felipe na utod Herodes gadumala naan ta Iturea daw Traconite. Lisanias gadumala naan ta Abilinia. ");
INSERT INTO cgc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas daw Caifas mga pinakadatas na manugdumala ta mga pari. Ta yon man na timpo, Juan na bata Zacarias naan ta lugar na ula kabalayan. Na naan dya kanen an, may minsai alin ta Dyos na napaabot ki kanen para isugid din ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Giling kanen an naan ta tanan na lugar na dani ta Suba Jordan daw naan dya gawali ta mga ittaw na danen an kinanglan magnelsel daw dilian iran an na mga sala para patawaren danen an ta Dyos. Pawali din man na dapat na pamatuuran danen iran na pagnelsel paagi ta pagpabautismo naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","May nasulat Isaias na prupita anay pa sa na natuman paagi ta pagwali Juan. Iling ti nasulat din, “May ittaw naan ta lugar na ula kabalayan na galaygay na bakod iya na kagi. Ambal din ta mga ittaw, ‘Ipriparar nyo agian an para ta pag-abot ta Ginuo. Tadlengen nyo dalan an na agian din! ");
INSERT INTO cgc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tampekan nyo tanan an na yup-ak naan ta tengngaan ta mga bukid! Patagen nyo tanan an na mga bungyod daw bukid! Tadlengen nyo galike-like an na mga dalan! Tapanen nyo mga dalan an na lub-ang-lub-ang! ");
INSERT INTO cgc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Daw iling tan buaten nyo, makita ta tanan paagi an ta pagluwas ta Dyos ta mga ittaw.’” ");
INSERT INTO cgc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tama na mga ittaw giling ki Juan aged magpabautismo ki kanen. Gambal kanen ki danen, “Kyo na malain! Paryo kaw ta mga bata ta bekkessan na dalitan! Salig nyo taan na paagi nang ta inyo na pagpabautismo malikawan nyo mabot an na silot ta Dyos tenged ta iya na kagilek! ");
INSERT INTO cgc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Daw nelselan nyo daw dilian inyo an na mga sala, kinanglan ipakita nyo paagi ta inyo na mga buat. Dili kaw man mag-isip na maluwas kaw alin ta silot ta Dyos na mambal kaw ta inyo na kaugalingen, ‘Kami i mga linai Abraham!’ Sugiran ta kyo na pwidi imuon ta Dyos mga bato na i na linai Abraham! ");
INSERT INTO cgc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tandaan nyo! Priparar en Dyos an na silutan kaw tenged ta inyo na mga sala na paryo kanen ta ittaw na gaalo en ta wasay din naan ta puon ta kaoy na pukanen tak kada kaoy na dili dayad iya na bunga pukanen daw pilak naan ta apoy.” ");
INSERT INTO cgc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gainsa mga ittaw ki Juan, “Ino dapat nay na buaten aged pamatuod na ganelsel kay en?” ");
INSERT INTO cgc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sabat Juan, “Daw kino ki kyo may darwa na bayo, isya an atag nyo ta ittaw na ula bayo. Iling man tan, daw kino ki kyo may pagkaan, tagan nyo ittaw an na ula makaan.” ");
INSERT INTO cgc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gaprani man ki Juan mga manugsukot an ta buis aged magpabautismo. Gainsa danen, “Mistro, ino dapat nay na buaten?” ");
INSERT INTO cgc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sabat Juan, “Dili kaw magsukot ta subla!” ");
INSERT INTO cgc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mga sundalo na gamati ki Juan gainsa man ki kanen, “Ta, kami a, ino dapat nay na buaten?” Sabat din, “Dili kaw mangwarta paagi ta pagpalleg daw pagbuat-buat ta sala naan ta mga ittaw na ula sala. Makuntinto kaw nang en ta inyo na swildo.” ");
INSERT INTO cgc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ta timpo na mga ittaw gapabautismo ki Juan, tama gapaabot ta pag-abot ta Pinili Ta Dyos Na Mag-ari. Pagmati ta mga ittaw ta wali Juan, gainsa danen an ta iran na kaugalingen daw Juan en taan Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na nlaman Juan na iling sa iran an na isip, gambal kanen an, “Yaken gabautismo ki kyo paagi nang ta waig. Piro, may mabot na mas datas iya na katengdanan kaysa ta ake na katengdanan. Dili a bagay na magsirbi ki kanen maskin ta pagbadbad nang ta igot ta iya na sandal tak datas gid iya na katengdanan. Bautismuan din duma an ki kyo paagi ta Dyos Ispiritu Santo daw duma ya paagi ta apoy. ");
INSERT INTO cgc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kanen an priparar en na magbelag ta mga ittaw na matareng naan ta mga dili matareng. Paryo kanen an ta ittaw na gimes en na panginan iya an na naani na trigo tak gibit en ta gamit na pangpangin aged mabelag linggas an naan ta uot. Trigo an na linggas taguon din naan ta iya na kamalig. Piro, uot an daw uppa sunugon din naan ta apoy na dili mapatay.” ");
INSERT INTO cgc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tama pa man na duma na laygay Juan ta iya na pagwali naan ta mga ittaw na kinanglan iran na batasan magbag-o daw ta iya na pagsugid ta miad na balita parti ta papaabot na Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ta paglaygay Juan, pakuntra din malain na buat Herodes na manugdumala ta Galilea tak Herodes ya, pasawa din Herodias bisan magbayaw danen an daw tenged man ta duma pa na buat Herodes na malain. ");
INSERT INTO cgc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Piro, gadugang pa gid sala Herodes tak papriso din Juan ya. ");
INSERT INTO cgc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na ula pa napriso Juan daw gabautismo pa kanen ta mga ittaw, Jesus i gapabautismo man ki kanen. Pagtapos ta bautismo, gapangamuyo Jesus i daw gabukas langit an. ");
INSERT INTO cgc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dyos Ispiritu Santo an na daw lagen paryo ta salampati gapababa naan ki kanen. May namatian na gambal na naan ta langit, “Kaon ake na bata na palangga ko. Nalipay a gid ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na Jesus i gaidad ta mga trinta anyos, gumpisa kanen ta iya na mga ubra. Isip ta mga ittaw na kanen i bata Jose. Jose an bata Eli ");
INSERT INTO cgc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na iya na amay Matat, Matat an bata Levi na iya na amay Melqui, Melqui an bata Janai na iya na amay Jose, ");
INSERT INTO cgc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jose an bata Matatias na iya na amay Amos, Amos an bata Nahum na iya na amay Esli, Esli an bata Nagai ");
INSERT INTO cgc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na iya na amay Maat, Maat an bata Matatias na iya na amay Semei, Semei an bata Jose na iya na amay Joda, ");
INSERT INTO cgc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda an bata Joanan na iya na amay Resa, Resa an bata Zorobabel na iya na amay Salatiel, Salatiel an bata Neri ");
INSERT INTO cgc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na iya na amay Melqui, Melqui an bata Adi na iya na amay Cosam, Cosam an bata Elmadam na iya na amay Er, ");
INSERT INTO cgc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er an bata Josue na iya na amay Eliezer, Eliezer an bata Jorim na iya na amay Matat, Matat an bata Levi ");
INSERT INTO cgc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na iya na amay Simeon, Simeon an bata Juda na iya na amay Jose, Jose an bata Jonam na iya na amay Eliaquim, Eliaquim an bata Melea ");
INSERT INTO cgc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na iya na amay Mena, Mena an bata Matata na iya na amay Natan, Natan an bata David ");
INSERT INTO cgc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na iya na amay Jesse, Jesse an bata Obed na iya na amay Booz, Booz an bata Salmon na iya na amay Naason, ");
INSERT INTO cgc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason an bata Aminadab na iya na amay Admin, Admin an bata Arni na iya na amay Esrom, Esrom an bata Fares na iya na amay Juda, ");
INSERT INTO cgc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda an bata Jacob na iya na amay Isaac, Isaac an bata Abraham na iya na amay Tera, Tera an bata Nahor ");
INSERT INTO cgc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na iya na amay Serug, Serug an bata Ragau na iya na amay Peleg, Peleg an bata Heber na iya na amay Sala, ");
INSERT INTO cgc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala an bata Cainan na iya na amay Arfaxad, Arfaxad an bata Sem na iya na amay Noe, Noe an bata Lamec ");
INSERT INTO cgc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na iya na amay Metusela, Metusela an bata Enoc na iya na amay Jared, Jared an bata Mahalalel na iya na amay Cainan, ");
INSERT INTO cgc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan an bata Enos na iya na amay Set, Set an bata Adan, daw Adan an pakabig na bata ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pagtapos ta pagbautismo ki Jesus naan ta Suba Jordan, galin Jesus dya na pagaeman ta Dyos Ispiritu Santo daw giling naan ta lugar na ula kabalayan. Ta iya na pagtinir dya, gapadayon Dyos Ispiritu Santo ta pag-ubay ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Gatinir kanen i dya ta kwarinta na adlaw daw patintar kanen Satanas. Ta yon man na mga adlaw ula kanen may pakaan. Paglambay ta kwarinta na adlaw, nletem gid kanen i. ");
INSERT INTO cgc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iling ti na paagi pagtintar Satanas ki Jesus. Ambal Satanas, “Tenged na kaon yan Bata Ta Dyos, imuon no na tinapay bato na i.” ");
INSERT INTO cgc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sabat Jesus, “Naan ta sinulat na pulong ta Dyos may ambal, ‘Dili nang ta tinapay mabui mga ittaw.’” ");
INSERT INTO cgc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagsabat Jesus, padala Satanas kanen i naan ta datas na lugar. Nali nang papakita Satanas ki kanen tanan na nasyon ta kalibutan. ");
INSERT INTO cgc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ambal Satanas ki Jesus, “Iatag ko ki kaon tanan na nasyon daw manggad dya aged kaon magdumala. Pwidi ko iatag naan ta maski kino na liag ko tak naan en ki yaken uturidad ta pagdumala ta mga nasyon na yan. ");
INSERT INTO cgc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Daw magluod ka ki yaken na sirbian a no, imo en tanan na napakita ko ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sabat Jesus, “Naan ta sinulat na pulong ta Dyos may ambal, ‘Magsirbi ka ta Ginuo na imo na Dyos. Kanen nang sirbian no.’” ");
INSERT INTO cgc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagsabat Jesus, padala Satanas kanen i naan ta Jerusalem daw patindeg naan ta pinakadatas na parti ta Timplo. Ambal Satanas, “Tenged na kaon yan Bata Ta Dyos, alin di mugpa ka ");
INSERT INTO cgc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tak naan ta sinulat na pulong ta Dyos may ambal, ‘Magsugo Dyos an ta mga angil din na magbantay ki kaon.’ ");
INSERT INTO cgc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nasulat man, ‘Saluon ka danen ta iran na mga lima aged dili ka katupa naan ta bato.’” ");
INSERT INTO cgc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sabat Jesus, “Naan ta sinulat na pulong ta Dyos may ambal, ‘Dili no piliten Ginuo an na imo na Dyos na pamatuuran din pa iya na pag-amblig ki kaon.’” ");
INSERT INTO cgc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pagtapos Satanas ta iya na pagtintar ki Jesus, padilian din anay Jesus ya asta kanen an may upurtunidad na magtintar isab ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pagtapos Satanas ta pagtintar ki Jesus, gabalik Jesus i naan ta Galilea daw naan ki kanen gaem ta Dyos Ispiritu Santo. Balita an na parti ki kanen galapta naan ta bilog na Galilea. ");
INSERT INTO cgc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Gatudlo kanen i naan ta mga balay tipunan ta mga Judio daw padayaw kanen i ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na naan pa Jesus ta Galilea, giling kanen i naan ta Nazaret na banwa na naan dya kanen i gabakod. Ta Adlaw Ta Pagpuay, giling kanen i naan ta balay tipunan paryo ta pirmi din pabuat. Na naan ta selled, gatindeg kanen naan ta tubangan ta mga ittaw aged magbasa ta sinulat na pulong ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Paatag ki Jesus sinulat Isaias na prupita anay pa sa daw pabuklad din. Pangita din daw pabasa nasulat Isaias na iling ti: ");
INSERT INTO cgc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Paubayan a ta Dyos Ispiritu Santo tak napili a ta Ginuo Dyos na magsugid ta miad na balita naan ta mga imol. Pasugo a din na magsugid ta mga biag na danen an malibri, magsugid ta mga bulag na danen an makakita daw magtabang ta mga palupig. ");
INSERT INTO cgc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pasugo a din na magsugid na abot en timpo naan ta plano ta Ginuo Dyos na maluoy kanen ta mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagtapos Jesus basa ta sinulat ya, palukot din daw pabalik naan ta ittaw na gaatag ki kanen. Gapungko kanen i daw tanan na mga ittaw dya gatan-aw ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gambal kanen i ki danen, “Mintras na namatian nyo ake na pabasa na naan ta sinulat na pulong ta Dyos, natuman en ake na pabasa.” ");
INSERT INTO cgc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tanan danen gatingala ki kanen daw gakullaw ta makatingala na mga ambal din. Ambal danen, “Di' ba kanen i bata nang Jose na kasimanwa ta?” ");
INSERT INTO cgc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tenged ta iran na ambal parti ki Jesus, gambal kanen i ki danen, “Sigurado a na ipademdem nyo ki yaken yi na ambalanen, ‘Duktor, bulungon no anay imo an na kaugalingen!’ tak beet ambalen nyo na buaten ko unti naan ta ake na kaugalingen na banwa mga namatian nyo na nabuat ko naan ta Capernaum.” ");
INSERT INTO cgc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ambal din pa ki danen, “Ee, liag nyo na iling tan buaten ko. Piro, gambal a ki kyo na mga prupita na manugsugid ta kabebet-en ta Dyos, danen an ula papatii ta iran na mga kasimanwa na danen an pasugo ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Isipen nyo natabo ta timpo Elias na prupita anay pa sa. May letem naan ta bilog na Israel tak ula gid guran keteb ta tallo tenga taon. Ta yon man na timpo, bisan tama na balo na bai naan ta lugar na Israel, Elias ya ula pasugua ta Dyos na magtabang naan ta maskin isya ki danen. Pasugo kanen na magtabang naan ta isya na bai na balo na dili-Israelinen naan ta banwa na Sarepta naan ta prubinsya ta Sidon na dili sakep ta Israel. ");
INSERT INTO cgc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Iling man tan ta timpo Eliseo na prupita anay pa sa. Tama ittaw naan ta Israel na may segeng na masakit ta langgit, piro ula isya ki danen na kasimanwa Eliseo na papaayad din. Naaman ya nang na taga-Siria papaayad din.” ");
INSERT INTO cgc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pagmati ta mga ittaw na naan ta balay tipunan ta ambal Jesus, sikad gid gilek danen tanan. ");
INSERT INTO cgc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gatindeg danen an daw payudyod Jesus i pagwa ta iran na banwa asta ta pangpang aged itulod inta kanen i tak iran na banwa naan ta apaw ta bungyod. ");
INSERT INTO cgc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piro, Jesus i gaagi nang naan ta iran na tengnga daw magpadyo. ");
INSERT INTO cgc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Alin ta Nazaret, gategbeng Jesus i naan ta banwa na Capernaum na sakep man ta Galilea. Na naan kanen i dya, kada Adlaw Ta Pagpuay giling kanen i naan ta balay tipunan aged magtudlo. ");
INSERT INTO cgc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tanan na gamati ki kanen gatingala gid tak kanen an gatudlo alin ta iya gid na alam. ");
INSERT INTO cgc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ta Adlaw Ta Pagpuay na naan Jesus i ta balay tipunan, may mama na anen dya na naseddepan ta malain na ispiritu. Gasinggit kanen an ki Jesus, ");
INSERT INTO cgc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ara! Jesus na taga-Nazaret, man-o tak anen ka di? Giling ka di taan aged silutan kay? Kala ta kaw daw kino ka! Kaon yan alin gid ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Paay Jesus malain ya na ispiritu, “Sagbak! Mwa ka dyan ki kanen!” Pag-ambal Jesus, naan ta tubangan ta tanan na ittaw dya palampes ta malain na ispiritu ittaw an naan ta saag daw padilian na ula naino. ");
INSERT INTO cgc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pagkita ta mga ittaw dya na napagwa Jesus malain ya na ispiritu, gatingala gid danen an daw gaisturyaay, “Uy! Ino taan klasi na ambal nya? May bakod na gaem kanen an daw uturidad na bisan mga malain na ispiritu gatuman ki kanen. Na pasugo din danen an na maggwa, dayon man gwa!” ");
INSERT INTO cgc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Galapta gid naan ta mga lugar na dani ta Capernaum balita an parti ta mga nabuat ya Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus i galin naan ta balay tipunan daw giling naan ta balay danen Simon. Anen man dya ugwangan Simon na bai daw sikad paso lawa din an. Mga ittaw na naan ta balay ya gangayo ta tabang ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gaprani Jesus i daw gatindeg tengnged ta neggaan din. Pasugo Jesus na magpuas dangga din an. Gapuas iya na dangga daw dayon bangon kanen daw mimes ta pagkaan para ki danen Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na magsalep nang pa adlaw an, tanan na mga ittaw naan ta Capernaum na duma danen may masakit, padala danen naan ki Jesus. Bisan ino na mga masakit ta mga ittaw na padala ki kanen, patungtong din iya na lima ta kada isya daw danen tanan nayad. ");
INSERT INTO cgc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pagwa din man mga malain na ispiritu alin ta tama na mga ittaw. Na gagwa danen an, gasinggit, “Kaon Bata Ta Dyos!” Paay din danen an na dili en mag-ambal pa tak nlaman danen na kanen Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagsennang ta adlaw, gapanaw Jesus i alin ta Capernaum daw miling naan ta lugar na ula kabalayan. Papangita kanen i ta mga ittaw. Pagkita danen ki kanen, paawiran danen daw pangabayen na dili kanen i malin ta iran na lugar. ");
INSERT INTO cgc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Piro, gambal kanen i ki danen, “Dapat miling a pa ta duma na mga banwa aged magsugid ta miad na balita parti ta pagdumala ta Dyos tak pasugo a din para magbuat ta iling tan.” ");
INSERT INTO cgc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tenged iling tan ambal Jesus, gapadayon kanen i ta pagsugid ta miad na balita naan ta mga balay tipunan ta mga Judio naan ta bilog na Judea. ");
INSERT INTO cgc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na gatudlo Jesus i naan kilid ta Dagat Genesaret, gaginetek mga ittaw an tak liag danen na mamati ta iya na mga patudlo parti ta ambal ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nakita din darwa na buti na pabilin naan ta dagsayan. Mga mananagat an kakawas en daw gawaswas ta iran na mga pukot. ");
INSERT INTO cgc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gasakay Jesus i naan ta isya na buti na iya Simon daw gapangabay ki Simon na magpalaod tise. Naan dya gamungko Jesus i daw magpadayon ta pagtudlo ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagtapos Jesus ta pagtudlo, gambal kanen ki Simon, “Magpalaod ki daw mamukot aged may makamang ki.” ");
INSERT INTO cgc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Gambal Simon i ki Jesus, “Mistro, ula ki taan may makamang tak kadlaw kay nang ta pamukot, piro ula kay man gyapon kamang. Tenged nyan ambal no, magtaktak kay isab.” ");
INSERT INTO cgc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pagtaktak danen ta mga pukot, pakulong danen sikad tama na sidda asta na tise nang magisi iran na mga pukot. ");
INSERT INTO cgc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tenged ta katamaen ta sidda, papaypay danen Simon iran ya na mga duma na naan ta isya na buti na magtabang. Gaprani dayon iran ya na mga duma daw papanno danen ta sidda darwa na buti. Napanno gid mga buti ya asta mateggeb daw tise nang maleddang. ");
INSERT INTO cgc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkita Simon Pedro ta sikad tama na sidda, galuod kanen an naan ta tubangan Jesus daw gambal, “Ginuo, dili ka marani ki yaken. Gayya a gid ki kaon tak tama a sala.” ");
INSERT INTO cgc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iling tan ambal din tak gatingala gid kanen an daw mga duma din tenged ta sikad tama na mga sidda na nakamang danen. ");
INSERT INTO cgc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gatingala man danen Santiago daw Juan na mga kabataan Zebedeo na duma din na mananagat. Gambal Jesus i ki Simon, “Dili ka madlek! Paryo na papanagat no an mga sidda, yon man umpisa anduni panagaten no an mga ittaw tak maglaygay ka naan ta mga ittaw na magpasakep danen ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pagtapos Jesus ta ambal, pasaog danen Simon mga buti ya. Pabilin danen tanan na pagkabetang danen daw gakuyog ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na Jesus i naan ta isya na banwa, may mama dya na may segeng na masakit ta langgit ta bilog din na lawa. Pagkita din ki Jesus, gadapa kanen an naan ta atubangan Jesus daw gapakiluoy, “Ginuo, daw gusto no, mapaayad a no ta ake na masakit.” ");
INSERT INTO cgc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Paibitan Jesus mama an daw ambal din, “Gusto ko! Mayad ka!” Pag-ambal Jesus, nakamang dayon masakit ta langgit ta mama ya. ");
INSERT INTO cgc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Paambalan Jesus kanen an, “Dili ka mugid naan ta bisan kino parti ta ake na pagpaayad ki kaon. Magdiritso ka nang naan ta pari daw magpatan-aw na nayad ka en. Magdala ka man ta alad na igo ta sugo ta Dyos naan ta Mga Sinulat Moises parti ta mga napaayad alin ta segeng na masakit ta langgit aged may pamatuod ka naan ta mga ittaw na nayad ka en.” ");
INSERT INTO cgc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Maski paambalan Jesus mama ya na dili mugid, galapta man gyapon balita parti ki Jesus. Pirmi sikad tama na mga ittaw gaprani na gatumpok naan ki Jesus para mamati ta iya na mga patudlo daw mangabay ki kanen na ayaren iran na masakit. ");
INSERT INTO cgc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Piro, kanen i a, ugali din na pirmi miling naan ta lugar na ula kabalayan aged mangamuyo. ");
INSERT INTO cgc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Isya adlaw, na Jesus i gatudlo ta mga ittaw, anen dya pila na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises na gapamati man. Alin danen ta lain-lain na mga banwa na sakep ta Galilea daw alin man ta syudad Jerusalem daw duma pa na mga banwa na sakep ta Judea. Naan ki Jesus gaem an ta Ginuo Dyos ta pagpaayad ta mga ittaw na may masakit. ");
INSERT INTO cgc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na gatudlo pa kanen i, may mga ittaw na giling dya. Patuwangan danen mama na naan ta neggaan tak dili kapanaw. Gangita danen an ta paagi na melled naan ta balay aged dleen inta mama an na dili kapanaw naan ta atubangan Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piro, ula danen kaselled tak sikad tama ittaw daw ula maagian. Tenged ula danen maagian, padala danen mama an naan ta apaw ta atep ta balay. Paukab danen atep ya na usoy ki Jesus daw patunton danen mama an naan ta tubangan Jesus na naan man ta tengnga ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na nakita Jesus na danen an gasalig gid ki kanen na mapaayad din mama an na dili kapanaw, gambal kanen i ta mama an, “Dey, napatawad en imo an na mga sala!” ");
INSERT INTO cgc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mga manugtudlo ta Mga Sinulat Moises daw mga Pariseo gagumod, “Kino gid ittaw na i na iya na ambal insulto ta uturidad ta Dyos? Ula duma na makapatawad ta mga sala daw dili, Dyos nang!” ");
INSERT INTO cgc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Piro, nlaman Jesus iran na isip. Gainsa kanen i ki danen, “Man-o tak gaisip kaw ta iling tan? ");
INSERT INTO cgc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Indi ta darwa na i mas dali nang buaten? Ambalen ko na napatawad en iya na mga sala, o ambalen ko na kanen an mangon daw manaw? Simpri darwa i paryas nang na dali buaten tak iling an tan mabuat paagi nang ta gaem daw uturidad ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pamatuuran ko ki kyo na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan may uturidad naan ta kalibutan i na magpatawad ta mga sala.” Dayon, gambal Jesus i ta mama na dili kapanaw, “Gasugo a ki kaon, mangon ka! Dleen no neggaan no an daw muli!” ");
INSERT INTO cgc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Naan ta tubangan ta tanan na ittaw, gabangon dayon mama an. Pabitbit din iya an na neggaan daw muli na gadayaw ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Gatingala gid danen tanan daw gadayaw ta Dyos. Sikad gid pagkullaw an danen. Ambal danen, “Makatingala gid nakita ta anduni!” ");
INSERT INTO cgc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagtapos ta pag-ayad Jesus ta mama ya na dili kapanaw, gagwa Jesus i naan ta balay daw manaw. Ta iya na pagpanaw, nakita din isya na manugsukot ta buis na ngaran din Levi na gamungko naan ta bayaran ta buis. Gambal Jesus ki kanen, “Muyog ka ki yaken aged kaon isya man ta ake na mga tinudluan.” ");
INSERT INTO cgc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pag-ambal Jesus, gatindeg dayon Levi daw padilian tanan din na mga betang daw muyog. ");
INSERT INTO cgc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi i gakumbira naan ta iran na balay para ki Jesus. Tama na manugsukot ta buis daw duma pa na mga ittaw gakaan duma ki danen Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","May mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises na mimbro man ta grupo ta mga Pariseo na gariklamo naan ta mga tinudluan Jesus, “Man-o tak gakaan kaw daw gainem duma ta mga manugsukot ta buis daw makasasala na mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sabat Jesus, “Mga ittaw na miad iran na lawa ula gakinanglan ta duktor. Piro, mga ittaw an a na may masakit, danen gakinanglan ta duktor. ");
INSERT INTO cgc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nyan na ula a giling di para maglaygay naan ta mga ittaw na salig danen na matareng danen an. Giling a di para maglaygay naan ta mga ittaw na makasasala aged magnelsel danen an daw dilian iran na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","May mga ittaw na gaprani ki Jesus daw gambal, “Mga tinudluan Juan daw mga tinudluan man ta mga Pariseo pirmi gapwasa daw gapangamuyo. Man-o tak imo an na mga tinudluan sigi nang a na kaan daw inem na ula gid gapwasa?” ");
INSERT INTO cgc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Gasabat Jesus i, “Daw may kumbira ta kasal, impusibli na mga paimbitar an dili nyo pakan-enen mintras na mama na bag-o nang kasal anen pa don duma ki danen! ");
INSERT INTO cgc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Piro, mabot adlaw na mama an na bag-o kasal kamangen naan ki danen. Yon en uras na danen an magpwasa.” ");
INSERT INTO cgc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gaisturya pa Jesus i ki danen ta paanggid, “Ula bisan kino na gagisi daw gakamang ta tila na pangtupak naan ta bag-o na bayo daw itupak naan ta daan na bayo. Daw iling tan buaten din, bag-o na bayo masamad tak nagisi en daw tupak ya dili bagay ta daan na bayo tak alin ta bag-o na bayo. ");
INSERT INTO cgc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Iling man tan, ula bisan kino na gaugsak ta bag-o na bino na dili pa iseg na gabula pa naan ta daan na ugsakan na langgit na ula en gainat. Daw iling tan buaten din, mabustik ugsakan tenged ta pagbula ta bino. Muyak bino ya daw masamad man ugsakan an. ");
INSERT INTO cgc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dapat bag-o na bino iugsak naan ta bag-o buat na ugsakan na langgit na gainat pa. ");
INSERT INTO cgc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mga ittaw na anad en ta pag-inem ta lugay en buat na inemen, dili sabor ki danen bag-o buat na inemen. Ambal danen, ‘Mas sabor gid inemen an na lugay en nabuat.’” ");
INSERT INTO cgc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ta Adlaw Ta Pagpuay, Jesus i daw iya na mga tinudluan gaagi naan ta isya na triguan. Gaugot mga tinudluan din ta pila na mga passi ta trigo daw pakesse-kesse danen daw kan-enen. ");
INSERT INTO cgc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","May mga Pariseo na gambal ki Jesus, “Man-o tak gabuat kaw ta iling sa na kuntra ta mga sugo parti ta Adlaw Ta Pagpuay?” ");
INSERT INTO cgc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sabat Jesus, “Paryo kaw inyo na ula kabasa parti ta pabuat Ari David anay pa sa na nletem gid kanen ya daw iya na mga duma. ");
INSERT INTO cgc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Giling kanen naan ta balay ta Dyos daw patagan ta tinapay na paalad para ta Dyos. Patagan din man iya na mga duma. Piro, maskin mga pari nang patugutan na maan ta tinapay na paalad para ta Dyos, buat ya danen Ari David ula pabilang na kuntra ta mga sugo Moises.” ");
INSERT INTO cgc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ambal pa Jesus ki danen parti ta iya na kaugalingen, “Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan may uturidad na magbeet daw ino tugot na buaten naan ta Adlaw Ta Pagpuay.” ");
INSERT INTO cgc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Isya man na Adlaw Ta Pagpuay, Jesus i gaselled daw gatudlo naan ta balay tipunan. Naan dya may mama na tuo din an na lima kimay. ");
INSERT INTO cgc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Naan man dya duma na mga Pariseo daw mga manugtudlo ta Mga Sinulat Moises. Danen i gapanilag gid ki Jesus daw magpaayad kanen naan ta Adlaw Ta Pagpuay tak papangitaan danen kanen i ta sala aged maakusaran. ");
INSERT INTO cgc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piro, nlaman Jesus iran an na isip. Gambal kanen ta mama na lima din an kimay, “Mindeg ka daw marani di.” Pag-ambal Jesus, mama ya gaprani ki kanen daw gatindeg naan ta tubangan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gainsa Jesus i ta mga Pariseo daw mga manugtudlo ya, “Naan ta Mga Sinulat Moises, ino tugot na buaten ta naan ta Adlaw Ta Pagpuay? Indi ti: Magbuat ki ta miad, magbuat ki ta malain? Magluwas ki ta mga ittaw, magpatay ki ta mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pag-insa din, patan-aw din danen an tanan na naan ta iya na palibot daw gambal kanen i ta mama ya, “Untayen no imo na lima na kimay.” Dayon, pauntay ta mama iya na lima daw nayad en. ");
INSERT INTO cgc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na nakita ta mga manugtudlo ta Mga Sinulat Moises daw mga Pariseo na mama ya paayad Jesus naan ta Adlaw Ta Pagpuay, gagilek gid danen an ki Jesus. Tenged ta iran na kagilek, gasapol danen an daw ino iran an na buaten ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Paglambay ta pila na mga adlaw alin ta pagpaayad Jesus ta mama ya na lima din kimay, gapanaw Jesus i daw miling naan ta isya na bukid aged mangamuyo. Kadlaw gid kanen an ta pangamuyo naan ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagsennang ta adlaw, patipon Jesus mga tinudluan din an daw gapili kanen i ta dusi naan ki danen. Paatagan din danen an ta katengdanan na paumaw na apustulis. ");
INSERT INTO cgc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yi mga napili din: Simon na pangaranan din na Pedro, Andres na utod Simon, Santiago, Juan, Felipe, Bartolome, ");
INSERT INTO cgc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Santiago na bata Alfeo, Simon na paumaw man na Makabanwa, ");
INSERT INTO cgc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas na bata ta isya man na Santiago daw Judas Iscariote na ta uryan magtraydor ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na gategbeng Jesus i daw mga duma din alin ta bukid, gateneng danen i naan ta patag na lugar. Naan dya tama na mga tinudluan din daw sikad man tama na mga ittaw na naan pa alin ta syudad Jerusalem daw duma pa na mga banwa ta bilog na prubinsya Judea daw mga madyo na mga banwa na Tiro daw Sidon na dani ta baybay. ");
INSERT INTO cgc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Giling danen an dya aged mamati ki Jesus daw paayaren din man danen an ta iran na masakit. Papalin Jesus mga malain na ispiritu na gatublag ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tama na mga ittaw na liag magtandeg ki Jesus tak nayad bisan kino na gatandeg ki kanen tenged ta sikad bakod na gaem na alin ki kanen daw tanan na mga ittaw dya na may masakit paayad din. ");
INSERT INTO cgc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gatubang Jesus i ta iya na mga tinudluan daw mambal, “May angken na kalipay alin ta Dyos kyo yan na imol tak beet ambalen na sakep kaw ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","May angken na kalipay alin ta Dyos kyo yan na nletem anduni tak mabusog kaw. May angken na kalipay alin ta Dyos kyo yan na gaug-og anduni tak magtawa kaw. ");
INSERT INTO cgc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","May angken kaw na kalipay alin ta Dyos daw matabo na demetan kaw, sikwayen, painsulto daw inyo man na dengeg samaren tenged kyo yan sakep ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. ");
INSERT INTO cgc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Daw maagian nyo mga malain na iling tan, magkalipay kaw daw musko ta subla na kalipay tak may bakod na bales naan ta langit na patagana ta Dyos para ki kyo. Demdemen nyo na iran na buaten na malain ki kyo paryas nang ta pabuat ya anay pa sa ta iran na mga kaapuan naan ta mga prupita. Piro, bisan iling tan inagian ta mga prupita, kabaton danen ya ta bakod na bales alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Piro, kyo na manggaranen anduni, may maageman kaw na segeng na kalised tak ula en duma na kalipay na mabot pa ki kyo daw dili, dayad an na pangabui na naageman nyo anduni naan ta kalibutan i. ");
INSERT INTO cgc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kyo na pirmi busog anduni, may maageman kaw na segeng na kalised tak maleteman kaw. Kyo na gatatawa daw gasadya nang anduni, may maageman kaw na segeng na kalised tak mangasebe kaw daw mag-ug-og. ");
INSERT INTO cgc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Daw kyo dayawen gid ta usto ta tama na mga ittaw tak pabuat nyo daw ino nang an na makalipay ki danen, may maageman kaw na segeng na kalised tenged iran na pagdayaw ki kyo paryas nang ta pabuat ya anay pa sa ta iran na mga kaapuan naan ta mga dili-matuod na prupita. Padayaw gid mga dili-matuod na prupita, piro pasilutan ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Gambal pa Jesus i naan ta iya na mga tinudluan, “Kyo na gamati ki yaken, may ambal a ki kyo. Gugmaen nyo mga ittaw na gakuntra ki kyo daw magbuat kaw ta miad naan ta mga ittaw na gademet ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mangamuyo kaw ta Dyos na magdayad kaimtangan an ta mga ittaw na gangabay na maglain kaimtangan nyo. Mangamuyo kaw man para ta mga ittaw na gabuat ta malain ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Daw tampaen ka, itubang no pa liyo no an na mimi. Daw kamangen bayo no na pang-isleb, dili no pegengan na makamang man isya pa an na suot no na bayo. ");
INSERT INTO cgc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tagan no daw kino mangayo ki kaon. Daw kamangen imo na mga gamit, dili no bawien. ");
INSERT INTO cgc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Trataren nyo duma na mga ittaw paryo man daw ino liag nyo na pagtratar danen ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Daw gugmaen nyo an mga ittaw nang na gagugma ki kyo, dili kaw dayawen ta Dyos tak bisan pa mga ittaw na gabuat ta malain, danen an gagugma man ta mga gagugma ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Daw miaran nyo an mga ittaw nang na miad ki kyo, dili kaw dayawen ta Dyos tak bisan pa mga ittaw na gabuat ta malain, danen an gamiad man ta mga gamiad ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Daw magpaeles kaw ta mga ittaw nang na makabayad, dili kaw dayawen ta Dyos tak bisan pa mga ittaw na gabuat ta malain, danen an gapaeles man na balik nang ta puon naan ta mga paryo danen na gabuat ta malain. ");
INSERT INTO cgc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Piro kyo, gugmaen nyo daw miaran mga kuntra nyo an. Magpaeles kaw ki danen na dili kaw mag-isip ta bales. Daw buaten nyo iling tan, may bakod na bales para ki kyo. Mapamatuuran nyo man na Dyos Na Labaw Ta Tanan pasunod nyo na paryo kaw ta mga bata na gasunod ta ugali ta iran na amay tak Dyos an pirmi miad bisan ta mga ittaw na ula gademdem ta dayad na buat ki danen daw bisan man ta mga may malain na batasan. ");
INSERT INTO cgc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dapat maluuyon kaw man paryo ta ate na Dyos na Amay na maluuyon.” ");
INSERT INTO cgc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Gambal pa Jesus i naan ta iya na mga tinudluan, “Dili kaw mag-usgar ta duma tak daw dili kaw mag-usgar ki danen, dili kaw usgaran ta Dyos. Dili kaw mag-ambal ta duma na danen an may sala daw dapat na silutan tak daw dili kaw mag-ambal ta iling tan, dili mag-ambal Dyos an na kyo yan dapat silutan. Magpatawad kaw ta duma tak daw patawaren nyo danen an, patawaren kaw ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mangatag kaw ta duma tak daw mangatag kaw ki danen, Dyos an mag-atag ki kyo ta sikad tama na paryo din padesek, payegyeg daw padugangan pa aged magsubla. Daw mangatag kaw, dapat tama tak daw ino katamaen ta atag nyo naan ta duma, iling man tan katamaen iatag an ta Dyos ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Gaisturya Jesus i ki danen ta alimbawa, “Kabuangan nang gid daw ittaw na bulag magguyod ta isya man na bulag. Daw bulag magguyod ta paryo din na bulag, danen an na darwa mulog naan ta lungag. ");
INSERT INTO cgc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mga ittaw na patudluan, iran na alam dili datas pa ta alam ta mistro danen. Piro, pagtapos ta pagtudlo ki danen, iran na alam paryas en ta alam ta iran na mistro. ");
INSERT INTO cgc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Man-o tak sali ka gid ta bantay ta sala ta duma, piro sala no an na bakod pabay-an no nang? Daw iling tan buat no, paryo na nakita no puling na tise nang naan ta mata ta duma, piro pabay-an no nang man na naan ta imo na mata may paryo bakod na tablon. ");
INSERT INTO cgc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Maskin paryo may tablon na naan ta imo na mata na ula no intindia, gambal ka ta duma no, ‘Dey, miad taan na kamangen ko imo an na puling.’ Salig no daw kino ka na ula sala! Dilian no imo na sala bag-o ka magsaway ta duma parti ta iya na sala. Daw iling tan buaten no, paryo pakamang no tablon an na naan ta imo na mata aged kakita ka ta usto para makamang no tise an na puling na naan ta mata ta duma.” ");
INSERT INTO cgc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Gambal pa Jesus i naan ta iya na mga tinudluan, “Mga kaoy na dayad dili mamunga ta lain. Mga kaoy na lain dili mamunga ta dayad. ");
INSERT INTO cgc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mga kaoy makala paagi ta iran na bunga. Daw liag ta ittaw na mamang ta bunga ta igos, simpri dili kanen an mag-ipo naan ta telleken na tanem! Daw liag ta ittaw na mamang ta bunga ta ubas, simpri dili kanen an mag-ipo naan ta blagen na telleken! ");
INSERT INTO cgc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iling man tan, ittaw na miad, pirmi man miad mga paambal din tak tanan na naan ta iya na isip miad. Ittaw na malain, pirmi man malain mga paambal din tak tanan na naan ta iya na isip malain. Daw ino naan ta isip ta ittaw, yon man ambalen din.” ");
INSERT INTO cgc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Gambal pa Jesus i naan ta iya na mga tinudluan, “Man-o tak paumaw a nyo na ‘Ginuo’, piro ula kaw gasunod ta ambal ko? ");
INSERT INTO cgc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Isturya ko ki kyo parti ta mga ittaw na gaprani ki yaken daw gamati ta ambal ko daw gasunod. ");
INSERT INTO cgc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Danen an paryo ta ittaw na gatukod ta balay na gakutkot kanen ta dalem asta naabot unay na bato aged tindegan ta ligi. Gabot timpo na gabaa suba daw galamba waig naan ta balay, piro ula nadala ta waig balay ya tak lig-en pagbuat ya ta balay. ");
INSERT INTO cgc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Piro, mga ittaw na kamati ta ambal ko daw ula gasunod, danen an paryo ta ittaw na gatukod ta balay na ula din patansek mga ligi an naan ta mga bato. Gabot timpo na gabaa suba daw galamba waig naan ta balay. Natumba dayon balay ya na nagubba gid.” ");
INSERT INTO cgc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagtapos Jesus ta tanan na tudlo din ta mga ittaw na naan danen an ta patag na lugar, giling kanen naan ta banwa na Capernaum. ");
INSERT INTO cgc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Naan dya may dili-Judio na upisyal ta sundalo na kanen an may suguon na palangga din ta miad. Gamasakit suguon din an daw tagumatayen. ");
INSERT INTO cgc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tenged namatian ta upisyal ta sundalo parti ki Jesus, papailing din ki Jesus pila na mga gadumala ta mga Judio na magpangabay danen ki Jesus na miling naan ta iya na balay aged ayaren suguon ya. ");
INSERT INTO cgc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na danen an gabot ki Jesus, gapakiluoy gid danen an ki kanen, “Miad gid na matabangan no upisyal na ya ");
INSERT INTO cgc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tak palangga din gid kiten i na mga Judio daw kanen man gapatindeg ta ame ya na balay tipunan.” ");
INSERT INTO cgc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tenged ta ambal ta mga manugdumala, gakuyog Jesus i ki danen. Na dani nang en danen i Jesus naan ta balay ta upisyal, gasugo upisyal ya ta pila na mga arey din na ambalen ki Jesus tugon din an, “Ginuo, dili no nang en pabellayan imo na kaugalingen na miling pa di tak dili a bagay na magbaton ki kaon naan ta ame na balay tak datas imo na katengdanan. ");
INSERT INTO cgc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yon man tenaan na ula a gid giling ki kaon. Mambal ka nang, sigurado na mayad en ake na suguon. ");
INSERT INTO cgc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tenged ta ake na inagian bilang upisyal ta sundalo, nlaman ko gid na matuman dayon imo an na ambal. Pamanduan a ta mga upisyal na mas datas iran na katengdanan kaysa ta ake na katengdanan daw may pamanduan a man. Daw mag-ambal a ta isya, ‘Miling ka unso,’ gapanaw dayon. Daw mag-ambal a ta duma, ‘Manaw ka ri,’ gaprani dayon. Daw mag-ambal a ta suguon ko, ‘Ubraen no ni,’ paubra din dayon.” ");
INSERT INTO cgc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagmati Jesus ta tugon ya, gabilib kanen naan ta upisyal. Gatubang kanen ta mga ittaw na gakuyog ki kanen daw mambal, “Sugiran ta kyo na ula a pa kakita ta ittaw naan ta tanan na linai Israel na may bakod na pagsalig paryo ta iya na pagsalig.” ");
INSERT INTO cgc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Gabalik mga arey ta upisyal naan ta iya na balay. Pag-abot danen, nakita danen na ayad en suguon din an. ");
INSERT INTO cgc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Paglambay ta pila nang na mga adlaw alin ta pagpaayad Jesus ta suguon ta upisyal, giling kanen i naan ta banwa na pumaw na Nain. Gakuyog iya na mga tinudluan daw sikad tama na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na dani nang en danen naan ta ngaan ta banwa, gagwa ta banwa mga ittaw na miling ta lebbengan na may dala na patay na mama na bugtong nang na bata ta bai na balo. Tama na mga taga-Nain na gakumpanyar. ");
INSERT INTO cgc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagkita Ginuo ta balo ya, naluoy gid kanen i daw ambal din, “Manang, dili ka magal!” ");
INSERT INTO cgc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pag-ambal din, gaprani kanen i daw patandeg din neggaan ya ta patay. Gateneng dayon mga galayong an. Gambal kanen i, “Tong, mangon ka!” ");
INSERT INTO cgc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Gabangon bata ya daw gambal en. Paintriga Jesus bata ya naan ta iya na inay. ");
INSERT INTO cgc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Gatingala gid danen tanan daw gadayaw ta Dyos, “May gabot na manugsugid ta kabebet-en ta Dyos na may bakod na gaem.” Ambal pa danen, “Kademdem gid Dyos an ta mga ittaw din.” ");
INSERT INTO cgc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Balita ya parti ta buat Jesus galapta naan ta bilog na Judea daw ta palibot na mga lugar. ");
INSERT INTO cgc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan i na manugbautismo pasugiran ta mga tinudluan din parti ta tanan na nabuat Jesus. Gumaw kanen i ta darwa ta mga tinudluan din daw ");
INSERT INTO cgc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","pailingen naan ta Ginuo aged insaan, “Kaon kon papaabot nay ya na papangako ta Dyos? Daw dili kaon, may anen pa na duma?” ");
INSERT INTO cgc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Pag-abot ta darwa na tinudluan ki Jesus, gapaayad pa kanen i ta tama na mga ittaw: mga may masakit, mga may lain na pamatyag, mga patublag ta malain na mga ispiritu daw mga bulag. Gambal darwa na tinudluan ki Jesus, “Papailing kay di Juan na manugbautismo tak may insa kanen ya ki kaon. Yi insa din, ‘Kaon kon papaabot nay ya na papangako ta Dyos? Daw dili kaon, may anen pa na duma?’” ");
INSERT INTO cgc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sabat Jesus, “Malik kaw ki Juan daw sugiran nyo kanen parti ta mga nakita nyo na pabuat ko daw mga namatian nyo na ambal ko: mga bulag kakita en, mga piang kapanaw en ta usto, mga ittaw na may segeng na masakit ta langgit naayad en, mga bengngel kamati en, mga patay pabui en, daw nasugid en miad an na balita naan ta mga imol. ");
INSERT INTO cgc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sugiran nyo pa kanen an na may angken na kalipay alin ta Dyos mga ittaw na ula danen patalikuri iran an na pagsalig ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pag-alin ta darwa na tinudluan Juan, gambal Jesus i parti ki Juan naan ta mga ittaw dya, “Na giling kaw kan-o ki Juan naan ta lugar na ula kabalayan, ino liag nyo na makita? Ittaw na dili pirmaninti iya na isip daw dili man masaligan na paryo ta kugon na paapay-apay nang ta angin? Simpri, dili! ");
INSERT INTO cgc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ino gid liag nyo na makita na giling kaw dya? Mama na gasuot ta maalen na bayo? Simpri, dili! Mga ittaw an na gasuot ta dayad gid na bayo daw gapagusto nang ta iran na pangabui, naan danen gaistar ta mga palasyo. ");
INSERT INTO cgc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ino gid liag nyo na makita? Prupita na manugsugid ta kabebet-en ta Dyos? Simpri, ee! Piro, gambal a ki kyo na Juan ya mas pa ta isya na prupita ");
INSERT INTO cgc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","tak kanen manugsugid ya na pasambit ta Dyos naan ta iya na sinulat na pulong na kanen gambal, ‘Ipadala ko una ki kaon ake na manugsugid aged ipriparar din agian ta imo na pag-abot.’” ");
INSERT INTO cgc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ambal pa Jesus, “Sugiran ta kyo na alin ta una na timpo asta anduni, ta tanan na mga ittaw na natao ula isya ki danen na may labaw pa na katengdanan kaysa ta katengdanan Juan. Piro, umpisa ta yi na timpo, ittaw na may pinakababa na katengdanan naan ta tanan na sakep ta pagdumala ta Dyos, iya na katengdanan labaw pa ta katengdanan Juan.” ");
INSERT INTO cgc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tanan na gamati ta yon na paambal Jesus parti ki Juan asta man mga manugsukot ta buis, kumpurmi danen an na matuod patudlo Juan parti ta liag ta Dyos para ki danen tak dati gapabautismo danen an ki Juan. ");
INSERT INTO cgc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piro, mga Pariseo an daw mga ittaw an na may datas alam parti ta Mga Sinulat Moises, pasikway gid danen liag an ta Dyos para ki danen tak ula danen an gapabautismo ki Juan. ");
INSERT INTO cgc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Gambal pa Jesus i, “Isipen ta anay daw indi pakumparar mga ittaw an ta yi na timpo. Indi taan paryo danen an? ");
INSERT INTO cgc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Danen an paryo ta mga bata na gamungko naan ta plasa na dili kuntinto ta maskin ino na ampang. Gambal danen ta mga duma danen na gaampang, ‘Patukaran nay kyo yan ta plawta ta masadya na kanta, piro ula kaw gasayaw! Pakantaan nay kyo yan ta kanta ta kumpanyar ta patay, piro ula kaw gagal!’ ");
INSERT INTO cgc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iling man tan kyo yan tak ula kaw man gyapon nalipay ki Juan na manugbautismo daw ki yaken. Na Juan ya gapwasa daw ula gainem ta bino, ambal nyo, ‘Naseddepan kanen ta malain na ispiritu!’ ");
INSERT INTO cgc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Piro, na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan gainem ta bino daw ula gapwasa, ambal nyo, ‘Lagen nyo ittaw i, takab ta pagkaan daw sikad minem. Pirmi kanen gaduma ta mga manugsukot ta buis daw makasasala na mga ittaw!’” ");
INSERT INTO cgc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gambal pa Jesus i ta isya na ambalanen, “Napamatuuran na igo tudlo ya paagi ta pabuat ta mga ittaw na gasunod.” ");
INSERT INTO cgc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jesus i paimbitar ta isya na Pariseo na maan duma ki kanen. Giling Jesus i naan ta balay ta Pariseo daw gakaan dya. ");
INSERT INTO cgc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Naan ta yon man na banwa may bai na kanen an kala na makasasala. Namatian din na Jesus i gakaan naan ta balay ta Pariseo. Pagmati din, giling kanen dya na may dala na tise na tibod na buat alin ta bato na alabastro na may ugsak na maalen na paammot. ");
INSERT INTO cgc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Gaprani kanen an naan dapit ta tudtod Jesus daw gatindeg naan ta batiisan. Gagal kanen an daw natuluan ta lua din batiis Jesus. Papairan din ta iya na buok batiis an daw paarekan daw pabanyusan ta paammot. ");
INSERT INTO cgc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pariseo na gaimbitar ki Jesus, gagumod kanen an na nakita din pabuat ta bai ya. Ambal din ta iya na kaugalingen, “Daw matuod gid na ittaw na i prupita, inta nlaman din daw kino bai na gatandeg ki kanen. Inta nlaman din daw ino klasi na bai nan. Kanen an makasasala na bai!” ");
INSERT INTO cgc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ambal Jesus ta Pariseo an, “Simon, may ambal a ki kaon.” Sabat Simon, “Sigi, Mistro, ambalen no.” ");
INSERT INTO cgc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Paisturyaan Jesus kanen an ta paanggid, “Darwa na ittaw kautang naan ta manugpautang. Isya an kautang ta limma gatos na sinsilyo na pilak daw isya ya, kautang ta singkwinta nang. ");
INSERT INTO cgc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tenged darwa danen ula kwarta na pambayad, papasinsya danen ya ta manugpautang. Ta, kino taan ki danen na darwa mas magpalangga ta manugpautang?” ");
INSERT INTO cgc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sabat Simon, “Ittaw ya bayon na mas bakod iya na utang na papasinsya ta manugpautang.” Ambal Jesus, “Igo nyan!” ");
INSERT INTO cgc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pag-ambal din, galiso kanen an naan ta bai ya daw mambal isab ki Simon, “Lagen no bai i! Pagselled ko ta balay no, ula ka may pasugo na magkamang ta waig na pang-ugas ta batiis ko na paryo ta ate na kaugalian. Piro bai i, pabasa din batiis ko i ta iya na lua daw papairan din ta iya na buok. ");
INSERT INTO cgc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ula a no pabugno paagi ta pag-arek na paryo ta ate na kaugalian. Piro, umpisa ta pag-abot ko, ula gauntat bai i ta pagtaod ki yaken paagi ta pag-arek ta batiis ko. ");
INSERT INTO cgc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ula no pabetangi ta lana ulo ko i paryo ta ate na kaugalian ta pagbaton ta mga bisita. Piro bai na i, pabanyusan din batiis ko i ta maalen na paammot. ");
INSERT INTO cgc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gani, sugiran ta kaw, bakod din na pagpalangga ki yaken pamatuod na napatawad en tama din na sala. Daw kino mapatawad na pila nang iya na mga sala, dili bakod iya na pagpalangga ta gapatawad ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ambal Jesus ta bai an, “Napatawad en imo an na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pag-ambal Jesus ta bai, mga ittaw na gakaan duma ki kanen gambal naan ta iran na kaugalingen, “Ino isip din ta iya na kaugalingen, Dyos kanen an na makapatawad ta mga sala?” ");
INSERT INTO cgc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ambal pa Jesus ta bai an, “Tenged ta pagsalig no ki yaken, naluwas ka ta silot ta imo na mga sala. Muli ka en na may katawway ta nakem.” ");
INSERT INTO cgc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Paglambay ta pila na mga adlaw, Jesus i galibot ta mga syudad daw banwa naan ta Galilea daw gasugid ta miad na balita parti ta pagdumala ta Dyos. Gakuyog ki kanen dusi na apustulis. ");
INSERT INTO cgc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Gakuyog man pila na mga bai. Duma ki danen mga napaayad din ta iran na mga masakit daw duma pa ki danen napagwaan din ta mga malain na ispiritu. Isya man ki danen na gakuyog ki Jesus, Maria na paumaw man na Maria Magdalena. Napagwa alin ki kanen pitto na mga malain na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Isya pa ki danen, Juana na sawa Chuza na mayurdumo ta panimalay Herodes. Isya pa gid ki danen, Susana. Tama pa man na mga bai gakuyog daw alin ta iran na pagkabetang gatabang ki Jesus daw iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Gatipon ki Jesus tama na mga ittaw na alin ta lain-lain na mga banwa. Gaisturya kanen ki danen ta isya na paanggid, ");
INSERT INTO cgc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“May mangunguma na giling naan ta iya na uma aged magsabwag ta binni. Ta iya na pagsabwag, may mga binni na katupa naan ta dalan. Naan dya nautaran mga binni daw ubos tuktok ta mga yupan. ");
INSERT INTO cgc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","May mga binni man na katupa naan ta batuan na may tappaw nang na basak. Pagtubo ta mga binni, gakeseg tak ula nang lugay gamara basak ya. ");
INSERT INTO cgc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","May mga binni pa man na katupa naan ta basak na natubuan ta mga telleken na lamunon. Gatubo mga binni ya na duma ta lamunon daw nalemmes. ");
INSERT INTO cgc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","May mga binni pa gid na katupa naan ta dayad na basak. Gatubo mga binni ya daw gabunga. Kada puon may bunga na gapungpong ta isya gatos na passi.” Pagtapos isturya Jesus ta paanggid, gambal pa kanen an na bakod iya na kagi, “Daw kino liag magbaton ta ake i na ambal, isipen din gid ta usto namatian din an.” ");
INSERT INTO cgc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mga tinudluan Jesus gainsa ki kanen daw ino beet ambalen ta iya na isturya na paanggid. ");
INSERT INTO cgc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sabat Jesus, “Kyo na mga tinudluan ko patagan ta Dyos ta pribiliyo na maintindian nyo mga ula din pasugira anay pa sa na parti ta iya na pagdumala. Piro, duma na mga ittaw patudluan ko parti ta iya na pagdumala paagi ta mga isturya na paanggid aged, ‘maski tan-awen pa danen ta miad ake na mga buat, dili man gyapon kaintindi daw ino beet ambalen, maski matian pa danen ta miad ake na mga itudlo, dili man gyapon kaintindi.’” ");
INSERT INTO cgc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ambal pa Jesus, “Yi beet ambalen ta paanggid na isturya: Binni ya na pasabwag, tudlo parti ta ambal ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mga binni na katupa naan ta dalan paryo ta tudlo na pamatian ta mga ittaw, piro gabot Satanas daw pakamang din patudlo ya na naan ta iran na isip aged dili danen patian daw dili man danen an maluwas alin ta silot ta iran na mga sala. ");
INSERT INTO cgc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mga binni na katupa naan ta batuan na may tappaw nang na basak paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw daw pabaton na may kalipay, piro iran na pagpati dili terek ta iran na nakem. Paryo danen ta mga tanem na mga gamot an babaw nang. Ula nang lugay iran na pagpati. Na naagian danen mga pagtilaw, narwad iran na pagpati. ");
INSERT INTO cgc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mga binni na katupa naan ta natubuan ta mga telleken na lamunon paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw, piro nalipatan danen tenged gapalibeg danen ta iran na mga prublima, nawili danen ta iran na manggad daw kasadyaan nang iran na pangita. Gani, ula pulos iran na pagpati tak ula risulta na paryo danen an ta tanem na bunga din an ubos nang ta pulak. ");
INSERT INTO cgc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mga binni na katupa naan ta dayad na basak paryo ta tudlo parti ta ambal ta Dyos na pamatian ta mga ittaw na may dayad na tagipusuon. Pirmi danen nademdeman tudlo ya daw gaprusigir danen na tumanen. May pulos gid iran na pagpati tak danen an paryo ta tanem na dayad mamunga.” ");
INSERT INTO cgc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Gaisturya Jesus i ta isya pa na paanggid, “Daw mga ittaw magtutod ta lampraan, dili danen takleban daw dili man ibetang naan ta dalem ta kattri. Ibetang danen naan ta tungtungan ta ilaw aged pawa an makita ta mga ittaw na melled dya. ");
INSERT INTO cgc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iling tan ake an na tudlo tak ula may patago na dili magwa. Ula man may pasikrito na dili madiskubri daw mlaman ta tanan. ");
INSERT INTO cgc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Gani, mamati kaw gid ta usto ta ake na mga patudlo tak daw kino kaintindi daw gapati ta ake na tudlo parti ta pagdumala ta Dyos, dugangan pa gid ta Dyos iya an na pag-intindi. Piro, daw kino ula gapati, bawian pa ta Dyos kanen an daw ino na salig din na naintindian din parti ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mga utod Jesus na mama daw iya na inay giling ki kanen, piro dili danen an kaprani tak gaginetek mga ittaw an dya. ");
INSERT INTO cgc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","May gasugid ki kanen, “Naan ta gwa imo ya na inay daw mga utod. May kinanglan kon danen ya ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pagmati Jesus, ambal din ta mga ittaw dya, “Mga ittaw na gamati daw gatuman ta ake na mga patudlo parti ta ambal ta Dyos, danen an pabilang ko na ake na mga utod daw inay.” ");
INSERT INTO cgc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ta timpo na Jesus galibot ta mga syudad daw banwa, gaanggat kanen i ta iya na mga tinudluan, “Mos! Makted ki naan ta liyo.” Pag-ambal din, gasakay danen i ta buti daw marga. ");
INSERT INTO cgc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na galayag en danen, katunuga kanen i. Nali nang gasampi pelles na angin. Buti ya tise nang nasanapan ta taklap ta mga baled daw iran na kabui naan ta piligro. ");
INSERT INTO cgc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iya na mga tinudluan gaprani ki kanen daw papukaw danen kanen i na ambal danen, “Ginuo, Ginuo! Maleddang ki en!” Gabangon kanen daw pamanduan din na muntat pelles na angin daw darko na baled. Dayon untat daw gakalmada. ");
INSERT INTO cgc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesus i gambal ki danen, “Indya inyo na pagsalig ki yaken?” Piro, gakullaw gid daw nadlek danen an tenged ta iran na nakita. Gaisturyaay danen an, “Ino taan klasi na ittaw ni? Bisan angin daw baled gatuman ki kanen!” ");
INSERT INTO cgc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gapadayon Jesus daw iya na mga tinudluan ta iran na paglayag daw gabot naan ta liyo na kilid ta dagat na gatubang ta Galilea. Yon lugar ta mga Gerasano. ");
INSERT INTO cgc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na gatakas nang pa Jesus i, may gasugat ki kanen na mama na naseddepan ta mga malain na ispiritu. Mama an dati naan gistar ta banwa ta yon man na lugar, piro lugay en na ula kanen an gabayo daw ula man gaistar ta balay. Naan nang kanen an ta patyo gaistar. ");
INSERT INTO cgc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na nakita din Jesus i, galuod kanen naan ta atubangan Jesus daw gasinggit, “Jesus! Kaon na Bata ta Dyos Na Labaw Ta Tanan! Man-o tak anen ka di! Gapakiluoy a ki kaon na dili a no sakiten.” ");
INSERT INTO cgc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iling tan ambal ta mama an tak bag-o nang paambalan Jesus malain ya na ispiritu na maggwa. Tama en na bisis na kanen an pagaeman ta malain na ispiritu. Maski kanen an pirmi pagapos ta kadina asta ta batiis din daw pabantayan ta mga ittaw, pabugto din nang kadina an daw papwirsa kanen an ta malain na ispiritu na mlagan naan ta mga lugar na ula kabalayan. ");
INSERT INTO cgc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Painsaan Jesus mama an, “Ino ngaran no?” Sabat din, “Linibo!” Iling tan iya na ambal tak sikad tama na malain na ispiritu na naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mga malain na ispiritu gapakiluoy ki Jesus na dili danen an manduan na munta ta lungag na kadalemen an ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naan ta bangilid na dani ki danen Jesus, may paneng ta baboy na ganuklad. Gapakiluoy ki Jesus mga malain ya na ispiritu na pabay-an danen an na magseddep naan ta mga baboy. Pabay-an din nang danen an. ");
INSERT INTO cgc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gagwa mga malain ya na ispiritu alin ta mama daw gaseddep naan ta mga baboy. Mga baboy ya gadlagan paebes ta bangilid daw nulog naan ta dagat daw nalemmes tanan. ");
INSERT INTO cgc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagkita ta mga manugbantay ta mga baboy na nalemmes mga baboy ya, gadlagan danen ta subla na adlek daw gasugid ta mga ittaw naan ta banwa daw ta mga baryo parti ta iran na nakita. ");
INSERT INTO cgc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mga ittaw ya na kamati giling ki Jesus aged man-aw. Pag-abot danen ki kanen, nakita danen mama an na padilian ta mga malain na ispiritu. Gamungko mama an naan ta tubangan Jesus daw may bayo en na suot daw usto en iya na isip. Mga ittaw na giling dya nadlek tenged ta iran na nakita. ");
INSERT INTO cgc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mga kakita ya ta katingalaan na pabuat Jesus, danen gasugid ta mga ittaw na bag-o nang gid gabot parti ta pagpaayad Jesus ta mama ya na naseddepan ta mga malain na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gapakiluoy mga Gerasano ki Jesus na malin kanen i ta iran na lugar tak sikad gid iran na adlek ki kanen. Tenged ta ambal ta mga ittaw, gasakay Jesus i daw mga tinudluan din naan ta buti na malik ta alinan danen na lugar. ");
INSERT INTO cgc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mama ya na padilian ta malain na mga ispiritu gapangabay na muyog ki Jesus. Piro, papauli kanen i Jesus daw paambalan, ");
INSERT INTO cgc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Miad pa, muli ka daw ibalita no katingalaan an na nabuat ta Dyos ki kaon.” Gani, galibot mama ya naan ta bilog na banwa daw pasugid din katingalaan na nabuat Jesus ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na gabalik danen Jesus naan ta Galilea, tama na mga ittaw nasadyaan gid na gasugat ki kanen tak gatagad danen an ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","May mama na gaprani ki Jesus na ngaran din Jairo. Kanen isya na gadumala ta balay tipunan. Pagprani din naan ta tubangan Jesus, galuod kanen an daw gapakiluoy na miling Jesus i naan ta iya na balay ");
INSERT INTO cgc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tak tagumatayen bata din na bai na bugtong nang na gaidad ta dusi anyos. Na gapanaw Jesus na munta naan iran Jairo, tama na mga ittaw gakuyog ki kanen na gadas-egay daw Jesus i naipit ta iran na pagdas-egay. ");
INSERT INTO cgc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","May isya na bai na anen man dya na iya na rigla ula gapeet ta usto seled ta dusi anyos. Naubos tanan din na pagkabetang ta iya na pagpabulong, piro ula man gyapon may duktor na kapaayad ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gaprani kanen an naan dapit ta tudtod Jesus daw patandeg din bungay-bungay ta sidsid ta bayo na pangkablay Jesus. Dayon peet iya na rigla. ");
INSERT INTO cgc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Gainsa Jesus i, “Kino gatandeg ki yaken?” Piro, ula gid may gaako daw kino gatandeg ki kanen. Gambal Pedro, “Mistro, mga ittaw i galibot daw gadas-eg naan ki kaon! Man-o tak minsa ka pa?” ");
INSERT INTO cgc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sabat Jesus, “May gatandeg gid ki yaken tak nabatyagan ko na may gaem na alin ki yaken na gapaayad ta ittaw.” ");
INSERT INTO cgc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na nlaman ta bai na nabatyagan Jesus iya na pagtandeg, gaprani kanen an na gakereg ta subla na adlek. Galuod kanen an naan ta batiisan Jesus daw pasugiran din Jesus i naan ta tubangan ta mga ittaw na man-o tak gatandeg kanen ki Jesus daw paagi na naayad dayon kanen an. ");
INSERT INTO cgc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Gambal Jesus i ki kanen, “Kay, tenged ta imo na pagsalig, nayad ka. Muli ka en na may katawway ta nakem.” ");
INSERT INTO cgc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na gambal pa Jesus i ta bai ya, may gabot alin ta balay Jairo. Gambal kanen ki Jairo, “Dili ta nang en pailingen pa Mistro an naan ta balay nyo tak ula en bata no ya.” ");
INSERT INTO cgc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pagmati Jesus, gambal kanen ki Jairo, “Dili ka magkulba! Magsalig ka nang. Mag-ayad kanen ya.” ");
INSERT INTO cgc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ta pag-abot danen naan ta balay Jairo, patugutan Jesus danen nang Pedro, Santiago, Juan daw mga ginikanan ta bata na melled naan ta balay. ");
INSERT INTO cgc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tanan na mga ittaw na naan dya gagal daw gaaya. Gambal Jesus i ki danen, “Dili kaw magal. Bata an dili patay. Gatunuga nang kanen an.” ");
INSERT INTO cgc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Patatawaan nang ta mga ittaw Jesus i tak nlaman danen na patay en. ");
INSERT INTO cgc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Piro, paibitan din lima an ta bata daw ambal din, “Kay! Mangon ka!” ");
INSERT INTO cgc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dayon nabui bata an daw gabangon. Gasugo Jesus na pakan-enen danen bata an. ");
INSERT INTO cgc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gatingala gid mga ginikanan din an. Paambalan Jesus danen an na dili mugid ta maski kino na pabui din iran an na bata. ");
INSERT INTO cgc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Paumaw Jesus dusi na apustulis na magtipon naan ki kanen daw patagan din danen an ta gaem daw uturidad aged magpagwa ta tanan na klasi ta mga malain na ispiritu na naan ta mga ittaw daw magpaayad man ta mga ittaw na may masakit. ");
INSERT INTO cgc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pasugo din danen an na magtudlo parti ta pagdumala ta Dyos daw magpaayad man ta mga ittaw na may masakit. ");
INSERT INTO cgc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Paambalan din danen an, “Dili kaw magdala ta maskin ino para ta inyo na pagpanaw, maski tungkod, binagteng, pagkaan, kwarta daw mga mlaan. ");
INSERT INTO cgc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maski kino na magbaton ki kyo naan ta iran na balay, naan kaw nang dya magdayon asta ta inyo na pag-alin ta iran na lugar. ");
INSERT INTO cgc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Piro, daw dili kaw batunon ta mga ittaw naan ta isya na banwa, malin kaw dya. Ta inyo na pag-alin, ipakita nyo na papadpad nyo yab-ok an ta inyo na mga batiis na alin ta iran na banwa bilang pamatuod kuntra ki danen tak ula danen pabatuna upurtunidad na mapamatian danen miad na balita.” ");
INSERT INTO cgc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pagtapos ta ambal Jesus, gapanaw mga apustulis ya na miling naan ta lain-lain na mga baryo. Naan ta tanan na baryo na pailingan danen, gasugid danen an ta miad na balita parti ta pagdumala ta Dyos daw gapaayad man ta mga ittaw na may masakit. ");
INSERT INTO cgc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes na manugdumala ta Galilea, na namatian din parti ta tanan na pabuat Jesus daw mga apustulis, galibeg gid ulo din tak may mga ittaw na gambal na Jesus kon i Juan na manugbautismo na nabannaw. ");
INSERT INTO cgc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Duma na mga ittaw, salig danen na Jesus i Elias tak gambal danen na gapakita kon Elias na prupita anay pa sa. Duma pa gid an a, salig danen na Jesus i isya ta mga prupita anay pa sa na nabannaw na lain man kaysa ki Elias. ");
INSERT INTO cgc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ambal Herodes, “Jesus an dili Juan tak Juan ya pauturan ta lieg tenged ta sugo ko. Kino gid taan kanen an? Tama na sugid na makatingala parti ki kanen na namatian ko.” Tenged iling tan naan ta isip Herodes, gatingwa gid kanen na makita din Jesus an. ");
INSERT INTO cgc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dusi ya na apustulis gabalik ki Jesus daw pasugid ki kanen tanan ya na nabuat danen naan ta mga lugar na iran na nailingan. Pagsugid danen, pakuyog Jesus danen an na miling naan ta banwa na Betsaida. Ula din pakuyuga duma na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na nlaman ta mga ittaw na gapanaw danen Jesus, galutos danen an. Nalipay Jesus i ta pagbaton ki danen daw patudluan din parti ta pagdumala ta Dyos. Paayad din daw kino ki danen may masakit. ");
INSERT INTO cgc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na mapon gid en, gaprani ki Jesus dusi na apustulis daw mambal, “Miad taan daw pailingen no mga ittaw an naan ta dani na mga banwa daw baryo aged mangita danen ta mga balay na dayunan daw pagkaan tak naan ki di ta lugar i na ula kabalayan.” ");
INSERT INTO cgc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Piro, gambal Jesus i, “Kyo mag-atag ki danen ta iran na makaan.” Sabat danen, “May anen ki nang di limma buok na tinapay daw darwa na sidda. Kinanglan na manaw kay pa daw malit ta pagkaan na kaigo ki danen tanan.” ");
INSERT INTO cgc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iling tan ambal danen tak tama ittaw. Katamaen ta mga mama nang pa mga limma libo en. Gambal Jesus i naan ta mga apustulis, “Mga ittaw an grupuon nyo ta singkwinta daw papungkuon.” ");
INSERT INTO cgc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Patuman ta mga apustulis sugo ya Jesus na papungkuon tanan. ");
INSERT INTO cgc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pakamang Jesus limma an na tinapay daw darwa na sidda. Gaangad kanen ta langit daw gapasalamat ta Dyos. Dayon, pabiak-biak din tinapay ya daw patenga-tenga sidda daw paatag naan ta mga apustulis aged itagtag naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kakaan danen tanan daw nabusog. Patipon ta mga apustulis sama ya daw napanno danen dusi na baskit na darko. ");
INSERT INTO cgc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesus i gapangamuyo na kanen nang. Iya an na mga tinudluan naan man dya ta dili gid madyo ki kanen. Pagtapos din pangamuyo, gainsa kanen i ki danen, “Kino a kon ambal ta mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sabat danen, “May mga ittaw na gambal na kaon kon yan Juan na manugbautismo. Duma ya a gambal na kaon kon Elias. Duma pa ya gambal na kaon kon isya ta duma pa na mga prupita na nabannaw en.” ");
INSERT INTO cgc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Insa din pa, “Kyo a, ino maambal nyo daw kino yaken i?” Sabat Pedro, “Kaon yan Cristo, Pinili Ta Dyos Na Mag-ari!” ");
INSERT INTO cgc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pagsabat Pedro, paambalan gid Jesus danen an na dili mugid ta bisan kino na kanen i Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Gambal pa Jesus i naan ta iya na mga tinudluan, “Naan ta plano ta Dyos na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, maagian din tama na malain na buat ta mga gakuntra ki kanen. Mga gadumala ta mga Judio, mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises magsikway ki kanen. Patayen kanen i, piro bannawen ta Dyos naan ta pangallo na adlaw.” ");
INSERT INTO cgc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ambal Jesus ta mga ittaw na naan dya, “Daw kino miag na kanen isya man na tinudluan ko, dapat dili iya en na liag masunod daw dapat man na adlaw-adlaw isipen din na paryo kanen an ta isya na ittaw na gapas-an ta iya na krus tenged iling tan buaten ta ittaw na magsunod ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kinanglan na buaten iling an tan tak daw kino gapalabi ta iya na kabui, mapatay man gyapon. Piro, bisan kino na mag-alad ta iya na kabui tenged ki yaken, maangken din kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Daw may ittaw na maangken din tanan na manggad naan ta kalibutan i piro dili din malikawan silot na ula katapusan naan ta impirno, ula man gyapon pulos tanan na naangken din. ");
INSERT INTO cgc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bisan kino magsikway ki yaken daw ta ake na tudlo, Yaken i Na Alin Ta Langit Na Natao Naan Ta Kalibutan magsikway man ki kanen. Sikwayen ko kanen an naan ta adlaw ta pag-umpisa ta ake na pagdumala na malik a daw makita sikad silaw na pawa na naan ki yaken na paryo man ta pawa na naan ta ake na Amay daw ta mga angil din. ");
INSERT INTO cgc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sigurado gid na iling tan naan ta ake na pagbalik daw sugiran ta kyo na may anen di ki kyo na bag-o danen mapatay, makita pa danen na mag-umpisa Dyos an ta iya na pagdumala na papaabot nyo.” ");
INSERT INTO cgc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Paglambay ta mga wallo na adlaw alin ta pag-ambal Jesus parti ta mga ittaw na liag na danen isya man ta iya na mga tinudluan, pakuyog din danen an Pedro, Juan daw Santiago na magtukad naan ta isya na bukid aged mangamuyo. ");
INSERT INTO cgc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na gapangamuyo kanen i, gaisab lagen sura din an daw iya na bayo sikad gid puti na sikad silaw. ");
INSERT INTO cgc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nali nang may darwa na mama na gapakita daw gasugranen ki kanen. Danen Moises daw Elias. ");
INSERT INTO cgc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iran an na sura sikad silaw. Gaisturya danen an ki Jesus parti ta iya na pagtuman ta pagbeet ta Dyos na kanen an mapatay naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Meek gid tunuga an Pedro daw iya na mga duma. Pagbugtaw danen, nasilawan danen an ta kapawa na alin ki Jesus daw nakita man danen darwa an na mama na gatindeg duma ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na malin nang pa ki Jesus darwa ya na mama, gambal Pedro i ki Jesus, “Ginuo, miad gid man na naan ki di. Magbuat kay ta tallo na pasilungan. Isya para ki kaon, isya para ki Moises daw isya man para ki Elias.” Iling tan ambal Pedro tak ula din naintindii daw ino gid paambal din an. ");
INSERT INTO cgc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na gambal pa Pedro i, nali nang may panganod na galekkep ki danen tanan. Nadlek gid ta miad tallo an na tinudluan Jesus na galekkep panganod ya ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","May namatian na gambal na naan ta panganod, “Yi ake na bata. Ake Na Pinili. Mamati kaw ki kanen!” ");
INSERT INTO cgc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagtapos ta ambal na alin ta panganod, nakita danen Pedro na Jesus nang en bilin. Ula gid anay pasugid danen Pedro ta bisan kino parti ta nakita danen naan ta bukid. Danen nang nalam. ");
INSERT INTO cgc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sunod na adlaw, Jesus i daw tallo din na tinudluan gategbeng alin ta bukid daw sikad tama na mga ittaw gasugat ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Naan ta mga ittaw na gasugat ki danen may mama na gaumaw ki Jesus. Ambal din na bakod iya na kagi, “Mistro! Tabangan a no! Lagen no anay bata ko i na mama. Bugtong ko nang pa man ni na bata. ");
INSERT INTO cgc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pirmi nang kanen i pagaeman ta malain na ispiritu daw nali nang kanen i gasinggit. Gapegpeleg kanen i daw gabula iya na baba tenged ta malain na ispiritu. Pasakit gid kanen i ta usto daw ula gid padilii ta malain na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Gapakiluoy a ta imo na mga tinudluan na pagwaen danen malain an na ispiritu, piro dili danen masarangan.” ");
INSERT INTO cgc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ambal Jesus, “E-hey! Kyo na mga ittaw ta yi na timpo, ula kaw gasalig ta Dyos! Malain kaw daw sutil! Asta kan-o a pa na magduma ki kyo daw magsakripisyo bag-o kaw magsalig ta Dyos?” Gambal kanen ta mama ya, “Dleen no di bata no an.” ");
INSERT INTO cgc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na gaprani bata an, palampes kanen an ta malain na ispiritu daw gapegpeleg. Paay Jesus malain ya na ispiritu daw paayad din bata an. Na nayad en bata an, pabalik Jesus kanen an naan ta iya na amay. ");
INSERT INTO cgc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tanan na ittaw dya gatingala gid tenged ta bakod na gaem ta Dyos na papakita Jesus paagi ta pagpaayad din ta bata ya. Na gakullaw pa mga ittaw tenged ta tanan na katingalaan na nabuat Jesus, ");
INSERT INTO cgc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","gambal kanen i naan ta iya na mga tinudluan, “Tandaan nyo gid ambal ko i. Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan dali nang en intriga naan ta mga gakuntra ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ula danen naintindii daw ino beet din ambalen tak ula pa papaintindi ta Dyos ki danen. Gangawa danen an na mag-insa ki Jesus daw ino beet din ambalen. ");
INSERT INTO cgc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mga tinudluan Jesus galalisay daw kino ki danen may pinakadatas na katengdanan. ");
INSERT INTO cgc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tenged nlaman Jesus isip danen, gakamang kanen ta sise na bata na naan dya daw papatindeg naan dapit ta iya na kilid. ");
INSERT INTO cgc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Gambal Jesus i ki danen, “Daw kino ki kyo na tenged ki yaken magbaton ta bisan isya na paryo ta yi na bata, paryas man na yaken pabaton nyo. Daw kino ki kyo magbaton ki yaken, pabaton nyo man gapadala an ki yaken. Daw kino na pinakakebes ki kyo, kanen an may pinakadatas na katengdanan.” ");
INSERT INTO cgc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ambal Juan ki Jesus, “Ginuo, may nakita kay na ittaw na gasambit man ta ngaran no ta iya na pagpagwa ta mga malain na ispiritu. Paay nay tak dili ta kanen ya duma.” ");
INSERT INTO cgc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ambal Jesus, “Dili nyo ayen kanen ya tak bisan kino na ula gakuntra ki kyo, gatabang ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na dali nang en mabot adlaw na dleen Jesus i naan ta langit, disidido en kanen i na miling naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta iya na pagpanaw, may mga ittaw na pasugo din na muna ki kanen naan ta isya na banwa ta Samaria aged mangita ta balay na dayunan din. ");
INSERT INTO cgc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piro, mga ittaw dya dili miag na magbaton ki kanen tak nlaman danen na kanen i isya na Judio na miling naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mga tinudluan Jesus na danen Santiago daw Juan, nlaman danen na mga ittaw na naan dya dili miag na magbaton ki kanen. Gani, gainsa danen an ki kanen, “Ino, Ginuo, liag no na mangabay kay ta Dyos na pauranan din ta apoy alin ta langit mga ittaw an naan dya aged masunog?” ");
INSERT INTO cgc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Patubang Jesus danen an Santiago daw pasaway din. ");
INSERT INTO cgc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pagtapos din ta saway, kanen daw iya na mga tinudluan giling naan ta duma na banwa. ");
INSERT INTO cgc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na gapanaw Jesus daw iya na mga tinudluan, may ittaw na gambal ki kanen, “Muyog a gid ki kaon bisan indi ka pa punta tak liag ko na isya a man ta imo na mga tinudluan!” ");
INSERT INTO cgc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ambal Jesus, “Miad pa isipen no anay mga ayep an na naan ta kakauyan. Danen an may istaran na lungag daw mga yupan man a may salag na ulian, piro Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, bisan indi nang gatinir tak ula ulian na balay na iya gid.” ");
INSERT INTO cgc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","May ittaw man na paambalan Jesus, “Muyog ka ki yaken aged isya ka man ta ake na mga tinudluan!” Ambal ta ittaw ya, “Ginuo, bag-o a nang en muyog. Muli a pa aged daw mapatay amay ko ya naan a dya para maasikaso ko paglebbeng ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sabat Jesus, “Duma nang en na mga ittaw na ula paumawa na muyog ki yaken pwidi na danen mag-asikaso ta paglebbeng ta imo ya na amay. Piro kaon imo a, isugid no ta tama na mga ittaw balita an parti ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","May isya pa na ittaw na gambal ki Jesus, “Ginuo, muyog a ki kaon tak liag ko na isya a man ta imo na mga tinudluan. Piro, pwidi a magpalam anay ta mga duma ko naan ta ame na balay?” ");
INSERT INTO cgc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ambal Jesus ki kanen, “Isipen no anay parti ta ittaw na garado, piro pirmi kanen an gablikid. Dili igo iya an na ubra. Iling man tan ittaw na gakuyog ki yaken, piro isip din an naan pa pirmi ta dati na kaimtangan na padilian din. Ula pulos na sakep kanen an ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Paglambay ta pila na mga adlaw pagtapos laygay Jesus ta mga ittaw na liag na muyog ki kanen, gapili kanen ta sitintay-dos alin ta iya na mga tinudluan aged pailingen din na tag-darwa na muna ki kanen naan ta kada banwa daw lugar na ilingan din. ");
INSERT INTO cgc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gaisturya kanen ta isya na paanggid naan ta iya na mga tinudluan, “Paryo may sikad lapad na anien, piro pila nang na mga ittaw gaani. Gani, naan kaw mangabay ta ittaw na gapaani na magpadala kanen an ta dugang pa na mga mag-ani. ");
INSERT INTO cgc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Manaw kaw en! Piro, tandaan nyo! Daw naan kaw en ta mga ittaw na ilingan nyo, kyo yan paryo ta daram na mga karniro na bata pa naan ta tengnga ta pintas na mga ayep. ");
INSERT INTO cgc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ta pagpanaw nyo, dili kaw magdala ta puyo, binagteng daw sandal na pangsili. Dili nyo awatan pagpanaw nyo ta pag-isturya ta mga ittaw na masugat nyo naan ta dalan. ");
INSERT INTO cgc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bisan iya tan na balay na maselleran nyo, unaen nyo pag-ambal iling an ti, ‘Kabay pa na mabaton nyo katawwayan na alin ta Dyos.’ ");
INSERT INTO cgc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Daw ittaw na gistar dya magbaton ta inyo an na bindisyon, maangken din katawwayan alin ta Dyos. Piro, daw ittaw na gistar dya dili magbaton ta inyo an na bindisyon, bawien nyo nang en. ");
INSERT INTO cgc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Daw kino magbaton ki kyo, naan kaw magtinir ta iran na balay asta malin kaw ta iran na banwa. Dili kaw magayya na maan daw minem ta bisan ino na mga papatad danen tak mga manug-ubra an dapat masuulan. Dili kaw magsalyo-salyo ta dayunan. ");
INSERT INTO cgc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Daw ino na banwa na ilingan nyo na mga ittaw dya magbaton ki kyo, kan-enen nyo daw ino man mga ipatad danen. ");
INSERT INTO cgc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paayaren nyo man mga gamasakit an naan ta iran na banwa. Sugiran nyo mga ittaw an na naan dya ta iling ti, ‘Anduni gabot en upurtunidad na makapasakep kaw naan ta papaabot nyo na pagdumala ta Dyos.’ ");
INSERT INTO cgc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Piro, daw ino na banwa na ilingan nyo na mga ittaw dya dili magbaton ki kyo, bag-o kaw malin dya magteneng kaw naan ta mayor na mga dalan daw indi tama na mga ittaw daw mag-ambal, ");
INSERT INTO cgc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yab-ok ta banwa nyo na gadekket ta ame na mga batiis padparen nay bilang pamatuod kuntra ki kyo. Tandaan nyo! Anduni gabot en upurtunidad na makapasakep kaw naan ta papaabot nyo na pagdumala ta Dyos, piro ula nyo pabatuna.’” ");
INSERT INTO cgc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ambal pa Jesus, “Sugiran ta kyo na daw mabot adlaw na mag-ukom Dyos ta mga ittaw daw kino matareng daw dili matareng, mas gaan pa silot na maageman ta sikad malain na mga ittaw na gaistar naan ta Sodoma anay pa sa kaysa ta silot ta mga ittaw na dili magbaton ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gambal pa Jesus i naan ta iya na mga tinudluan, “May segeng na silot na maageman ta mga taga-Corazin daw taga-Betsaida! Tama na katingalaan na nabuat ko naan ta iran na mga banwa, piro ula danen an ganelsel daw ula man danen padilii iran an na mga sala. Daw naan ta Tiro daw Sidon pabuat ko mga katingalaan na paryo ta nabuat ko naan ta Corazin daw Betsaida, sigurado na mga taga-Tiro daw taga-Sidon magsuot gid dayon ta bayo na sanot-sanuton daw magbetang ta abo naan ta iran na ulo aged ipakita na ganelsel danen an daw padilian man danen iran an na mga sala. ");
INSERT INTO cgc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Daw mabot adlaw na mag-ukom Dyos an naan ta mga ittaw daw kino matareng daw dili matareng, mas gaan silot ta mga taga-Sidon daw taga-Tiro kaysa ta silot ta mga taga-Corazin daw taga-Betsaida. ");
INSERT INTO cgc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mga ittaw man na taga-Capernaum! Salig gid danen na dayawen danen an ta Dyos. Piro, dili din danen an dayawen. Iulog din danen an naan ta Hades na lugar ta mga patay daw naan dya danen an silutan!” ");
INSERT INTO cgc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Gambal pa Jesus i naan ta iya na mga tinudluan, “Daw kino mamati ki kyo daw magtuman ta ambal nyo, paryas man na yaken patuman din. Daw kino na magsikway ki kyo, paryas man na yaken na gasugo ki kyo pasikway din. Daw kino na magsikway ki yaken, paryas man na pasikway din gapadala an ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gabalik na may kalipay sitintay-dos ya na mga tinudluan Jesus. Gasugid danen ki kanen, “Ginuo, ta ame na pagsambit ta imo na ngaran, maski mga malain na ispiritu gatuman ki kami na maggwa alin ta mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Gambal Jesus i ki danen, “Nlaman ko tak nakita ko pagpirdi ta Dyos ki Satanas na paryo ta latti na gulpi tupa alin ta langit. ");
INSERT INTO cgc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Paatagan ta kyo ta gaem aged maski mautaran nyo bekkessan daw sitsipit, ula may malain na matabo ki kyo. Paatagan ta kyo man ta uturidad aged mapirdi nyo Kuntra na Satanas maskin ino buaten din paagi ta biskeg din na gaem. Ula may magbuat ta malain ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Dili kaw magkalipay tenged nang gatuman ki kyo mga malain an na ispiritu. Magkalipay kaw gid tak naan ta langit inyo an na ngaran nasulat en naan ta listaan ta mga sakep ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ta yon man na uras na gaisturyaay Jesus daw sitintay-dos na mga tinudluan din, bakod gid na kalipay na atag ta Dyos Ispiritu Santo ki kanen. Kaambal kanen i, “Amay ko, kaon na manugdumala ta tanan na naan ta langit daw kalibutan, bakod pagdayaw ko an ki kaon. Kamatuuran parti ki kaon na ula no papaintindi ta mga ittaw na maalam daw may datas na iniskwilaan, papaintindi no en ta mga ittaw na paryo ta mga bata na ula kaiskwila. Ee, Amay ko, nadayaran ka na iling tan imo na pagbeet.” ");
INSERT INTO cgc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pagtapos Jesus ta pangamuyo, gambal kanen an naan ta mga ittaw dya, “Tanan na alam daw gaem ta ake na Amay patugyan din naan ki yaken. Ula duma na kakala ta iya na Bata daw dili, Amay. Ula duma na kakala ta iya na Amay daw dili, Bata daw duma pa man na mga ittaw na papili ta Bata aged naan ki danen ipakala din iya an na Amay.” ");
INSERT INTO cgc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Gatubang Jesus ta iya na mga tinudluan daw gambal naan nang ki danen, “May bakod na pribiliyo mga ittaw na kakita man ta ake na mga buat na nakita nyo. ");
INSERT INTO cgc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sugiran ta kyo na anay pa sa tama na manugsugid ta kabebet-en ta Dyos daw mga ari man na liag danen makita mga buat na nakita nyo, piro ula bisan isya ki danen kakita. Liag man danen na mamatian mga ambal na namatian nyo, piro ula bisan isya ki danen kamati.” ");
INSERT INTO cgc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","May isya na ittaw na may datas alam parti ta Mga Sinulat Moises na gatindeg aged dakep-dakepen Jesus an paagi ta insa. Gainsa kanen an ki Jesus, “Mistro, ino dapat ko na buaten aged maangken kabui na ula katapusan?” ");
INSERT INTO cgc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Insa Jesus ki kanen, “Ino nasulat naan ta Mga Sinulat Moises? Ino beet ambalen ta mga nabasa no dya?” ");
INSERT INTO cgc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sabat din, “Nasulat na ‘Gugmaen no Ginuo an na imo na Dyos na terek gid ta imo na tagipusuon. Ipakita no imo an na gugma paagi ta ugali, mga buat daw isip.’ Nasulat man, ‘Gugmaen no duma na mga ittaw paryo man ta paggugma no ta imo na kaugalingen.’” ");
INSERT INTO cgc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ambal Jesus ki kanen, “Igo sabat no an. Daw iling tan buaten no, maangken no kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Piro, dili miag kanen an na magayyaan. Yon tenaan na gainsa pa gid kanen an ki Jesus, “Piro, kino na duma na dapat ko gugmaen?” ");
INSERT INTO cgc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sabat Jesus paagi ta alimbawa na isturya, “May mama na Judio na gategbeng alin ta Jerusalem na miling naan ta Jerico. Ta iya na pagpanaw, gulpi nang kanen an paabungan ta mga manakaw. Pakamang danen tanan na dala din asta iya na bayo. Pabugbog danen kanen an daw padilian na tise nang napatay. ");
INSERT INTO cgc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Luglugay, may gaagi dya na isya na Judio na pari. Pagkita din ta mama ya, galiis nang kanen an. ");
INSERT INTO cgc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iling man tan, isya na linai Levi na manugtabang naan ta Timplo gaagi man dya. Pagkita din ta mama ya, galiis man kanen. ");
INSERT INTO cgc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Luglugay, may isya na Samaritano na gabyai daw kaprani ta lugar na naan dya mama ya. Na nakita din mama ya, naluoy gid kanen an. ");
INSERT INTO cgc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Papranian din mama ya daw pabulong ta lana daw bino mga nina daw begkesan. Papasakay din mama ya naan ta ayep na iya na pasakayan. Padala din naan ta balay na dayunan daw naan din dya paasikaso. ");
INSERT INTO cgc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sunod na adlaw, Samaritano ya gaatag ta darwa na sinsilyo na pilak naan ta tag-iya ta balay na dayunan daw gambal, ‘Asikasuon no kanen an. Daw magkulang kwarta i ta imo na panggastos para ki kanen, ta ake na pagbalik di bayaran ta kaw nang.’” ");
INSERT INTO cgc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pagtapos ta isturya Jesus, gainsa kanen i, “Ta, ino ta isip no? Kino ta tallo na ya na gaagi dya papakita din na kanen miad na ittaw naan ta mama na paabungan ta mga manakaw?” ");
INSERT INTO cgc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sabat ta ittaw an na may datas alam, “Yo ittaw ya na naluoy ki kanen.” Gambal Jesus ki kanen, “Sigi! Magbuat ka man ta miad na iling tan.” ");
INSERT INTO cgc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na gapadayon ta pagbyai danen Jesus, kabot danen i naan ta isya na banwa na may bai na gaistar dya na ngaran din Marta. Pabaton din danen Jesus naan ta iran na balay. ");
INSERT INTO cgc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta i may utod na bai na ngaran din an Maria. Maria an gamungko naan ta batiisan ta Ginuo daw gamati ta mga patudlo din. ");
INSERT INTO cgc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piro, Marta i, gagulo gid isip din tak sake ta tama na imesen. Gaprani kanen i ki Jesus daw mambal, “Ginuo, ula nang ki kaon na pabay-an a nang ta utod ko na yaken nang gaimes ta tanan? Ambalan no tuo kanen an na tabangan a din.” ");
INSERT INTO cgc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sabat ta Ginuo, “Aree, Marta, gapalibeg ka gid daw sake ta tama na ubra, ");
INSERT INTO cgc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","piro isya nang impurtanti gid na buaten daw yon papili Maria na gamungko kanen an di na mamati ta tudlo ko. Dili ko kanen an pegengan.” ");
INSERT INTO cgc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesus i gapangamuyo naan ta isya na lugar. Tapos din ta pangamuyo, isya na tinudluan din gaprani ki kanen daw gambal, “Ginuo, tudluan kay no mangamuyo paryo na Juan na manugbautismo gatudlo ta iya na mga tinudluan.” ");
INSERT INTO cgc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ambal Jesus, “Iling ti na paagi daw kyo mangamuyo: ‘Amay, Kabay na kalaen ka ta tanan na mga ittaw na kaon nang Dyos daw tumanen ka danen. Kabay na mabot en timpo na magdumala ka ta tanan na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tagan no kami i ta ame na kinanglan na pagkaan adlaw-adlaw. ");
INSERT INTO cgc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Patawaren no kami i ta ame na mga sala paryas na napatawad nay man tanan na kasala ki kami. Tabangan kay no na dili kay madala ta mga tintar.’” ");
INSERT INTO cgc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Gambal pa Jesus i naan ta iya na mga tinudluan, “Alimbawa, isya ki kyo ta tenga kilem miling naan ta iya na arey para mangabay daw pwidi kanen matagan ta tallo buok na tinapay ");
INSERT INTO cgc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tak may bisita kanen na bag-o nang gabot alin ta madyo. Bisita din an iya na arey daw ula en kanen an ipakaan. ");
INSERT INTO cgc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Piro, dili kanen an gwaan ta arey na pailingan din daw mambal pa iya na arey, ‘Dili a no isturbuon. Natrangkaan en gangaan an. Yaken daw ake na mga kabataan ganegga en. Dili a magbangon para mag-atag ta pagkaan.’” ");
INSERT INTO cgc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ambal pa Jesus, “Sugiran ta kyo na maskin arey na pailingan din dili magbangon para mag-atag ta pagkaan tenged danen an darwa mag-arey, sigurado na magbangon gid arey din an daw mag-atag ta maskin ino na kinanglanen din tenged ula gid kanen an gauntat ta pagpangayo. ");
INSERT INTO cgc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Gani, yi ambal ko ki kyo: Dili kaw mag-untat na mangayo naan ta Dyos tak sigurado na tagan kaw din. Dili kaw mag-untat na marani naan ta Dyos tak sigurado tabangan kaw din. Dili kaw mag-untat na mangamuyo naan ta Dyos tak sigurado sabaten kaw din ");
INSERT INTO cgc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","tenged bisan kino na mangayo, matagan. Bisan kino na marani, tabangan. Bisan kino na mangamuyo, sabaten. ");
INSERT INTO cgc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Di' ba kyo na mga ginikanan, ula kaw gaatag ta bekkessan naan ta inyo na bata na gangayo ta sidda? ");
INSERT INTO cgc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ula kaw man gaatag ta sitsipit naan ta inyo na bata na gangayo ta tallog. ");
INSERT INTO cgc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tenged kyo na mga gabuat ta malain nalam man mag-atag ta dayad na mga betang naan ta inyo na mga bata, sigurado na ate an na Amay na naan ta langit mas pa gid mag-atag ta Dyos Ispiritu Santo ta mga gangayo naan ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","May ittaw na paapa ta malain na ispiritu. Pagwa Jesus malain ya na ispiritu daw kaambal dayon ittaw ya. Mga ittaw na kakita ta pabuat Jesus gatingala gid. ");
INSERT INTO cgc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piro, pila ki danen gambal, “Papagwa din mga malain na ispiritu paagi ta gaem na alin ki Satanas na pangulo ta mga malain na ispiritu.” ");
INSERT INTO cgc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Duma man ki danen, liag na pamatuuran Jesus daw indi gid alin iya na gaem. Papangitaan danen kanen an ta katingalaan na buat na alin ta Dyos aged may pamatuod na kanen an papadala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nlaman Jesus iran an na isip daw gambal kanen ki danen, “Daw mga sinakepan ta isya na kaarian magkuntraay, iran na kaarian dili magpadayon. Daw mga ittaw na naan ta isya na panimalay magkuntraay, danen an magbelagay. ");
INSERT INTO cgc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Daw kuntraen Satanas iya an na mga sinakepan, dili magpadayon iya an na pagdumala. Iling tan ambal ko tak gambal kaw pa na papagwa ko mga malain na ispiritu paagi ta gaem na alin ki Satanas. ");
INSERT INTO cgc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ambal nyo na naan alin ki Satanas gaem an ta ake na pagpagwa ta mga malain na ispiritu, piro indi alin gaem ya ta inyo na mga tinudluan ta iran na pagpagwa ta mga malain na ispiritu? Simpri alin ta Dyos! Danen an pamatuod na sala gid inyo an na ambal tak iran na gaem daw ake paryas nang na alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tenged papagwa ko mga malain an na ispiritu paagi ta gaem na alin ta Dyos, beet ambalen na gabot en naan ki kyo papaabot nyo na pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gaisturya Jesus i ta isya pa na paanggid, “Daw may iseg na ittaw na kumplito ta armas gabantay ta balay din, ula may matabo ta iya na mga pagkabetang. ");
INSERT INTO cgc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piro, daw sulungon kanen an na mapirdi ta ittaw na mas biskeg pa ki kanen, kamangen mga armas din an na salig din na usto en na pangbatok. Tanan na pagkabetang din kamangen ta ittaw na mas biskeg pa ki kanen daw itagtag naan ta duma na mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ambal pa Jesus, “Daw kino na ula gatabang ki yaken ta ake na ubra, kanen gakuntra ki yaken na paryo kanen ta ittaw na imbis na magtabang ta pagtipon ta mga karniro, kanen pa gatabog na magpadyo.” ");
INSERT INTO cgc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Gaisturya Jesus i ta alimbawa naan ta mga ittaw, “May malain na ispiritu na gagwa ta ittaw na paseddepan din. Paggwa din, giling kanen an naan ta mara na lugar aged mangita ta mapuayan. Na ula kanen may nakita, gaisip kanen an, ‘Miad pa na malik a naan ta ittaw ya na naalinan ko.’ ");
INSERT INTO cgc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pagbalik din naan ta ittaw ya, nakita din na paryo ta balay na limpyo daw ayos. ");
INSERT INTO cgc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Gagwa isab kanen an naan ta ittaw ya aged mangita ta pitto na mas malain pa na ispiritu kaysa ki kanen. Pagkita din, danen tanan gaseddep naan ta ittaw ya daw gatinir dya ta lugay. Mas lain pa gid uryan an na kaimtangan ta ittaw ya kaysa ta una.” ");
INSERT INTO cgc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na gaisturya pa Jesus i naan ta tama na mga ittaw, may bai na naan dya na gambal ki kanen, “Pribiliyo gid na bakod na atag ta Dyos naan ta bai na gabata daw gapasuso ki kaon!” ");
INSERT INTO cgc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ambal Jesus, “Bakod pa gid pribiliyo an ta mga ittaw na gamati daw gatuman ta tudlo parti ta ambal ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na gatama pa gid mga ittaw na gatipon naan ki Jesus, gambal kanen ki danen, “Malain gid mga ittaw ta yi na timpo! Papangitaan a danen ta katingalaan na buat aged may pamatuod para ki danen na papadala a ta Dyos. Piro, ula duma na katingalaan na ipakita ki danen daw dili, katingalaan ya na natabo ki Jonas anay pa sa. ");
INSERT INTO cgc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Natabo ya ki kanen pamatuod para ta mga taga-Ninive na kanen ya papadala ta Dyos. Iling man tan, Kanen Na Alin Ta Langit may matabo ki kanen na pamatuod para ta mga ittaw ta yi na timpo na kanen i papadala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Daw mabot adlaw na mag-ukom Dyos an ta tanan na mga ittaw daw kino matareng daw dili matareng, naan dya Rayna ya na alin ta Sur mindeg daw magpamatuod na igo gid na silutan ta Dyos mga ittaw an ta yi na timpo. Kanen an may matareng na magpamatuod ta iling sa tak anay pa sa kanen gabyai na naan pa alin ta sikad madyo na lugar aged mamati ta tudlo Ari Solomon na maalam gid. Piro anduni, anen di en isya i na mas labaw pa iya na katengdanan kaysa ta katengdanan Ari Solomon, piro ula kaw gapati ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Daw mabot adlaw na mag-ukom Dyos an ta tanan na mga ittaw daw kino matareng daw dili matareng, naan dya mga taga-Ninive ya na nabui anay pa sa ta timpo Jonas mindeg daw magpamatuod na igo gid na silutan ta Dyos mga ittaw an ta yi na timpo. Mga taga-Ninive ya may matareng na magpamatuod ta iling sa tak ganelsel daw padilian danen iran an na mga sala na kamati danen ta wali Jonas. Anduni, anen di en isya i na mas labaw pa iya na katengdanan kaysa ta katengdanan Jonas, piro maski kamati kaw ta wali din, ula kaw man gyapon ganelsel daw padilian inyo an na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Gaisturya Jesus i ta paanggid, “Daw mga ittaw magtutod ta lampraan, dili danen taguon daw dili man takleban ta gantangan. Ibetang danen naan ta tungtungan ta ilaw aged pawa an makita ta mga ittaw na melled dya.” ");
INSERT INTO cgc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ambal din man, “Mata no an paanggid ta lampraan na gaatag ta pawa naan ta imo na kaugalingen. Daw miad mata no an, imo na kaugalingen ubos pawa. Piro, daw lebbeg mata no an, imo an na kaugalingen ubos delem. ");
INSERT INTO cgc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gani, isipen no ta miad. Basi pawa an na salig no naan ki kaon, delem. ");
INSERT INTO cgc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Daw imo na kaugalingen ubos pawa na ula gid parti na delem, gapawa ka gid na paryas may lampraan na gailaw ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagtapos Jesus ta pagtudlo naan ta mga ittaw, may Pariseo na gaimbitar ki Jesus na maan duma ki kanen naan ta iya na balay. Giling Jesus i naan ta balay ta Pariseo daw gakaan dya. ");
INSERT INTO cgc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gatingala gid Pariseo an tak nakita din na gakaan Jesus na ula gaugas anay ta lima paryo ta kaugalian ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tenged na iling sa isip ta Pariseo, gambal Ginuo i ki kanen, “Kyo na mga Pariseo, paryo kaw ta ittaw na gaugas nang ta gwa ta ineman daw mangkok, piro selled ta ineman daw mangkok ula din paugasi. Iling man tan, pakita-kita nyo nang pirmi naan ta mga ittaw na patuman nyo gid mga sunuran nyo, piro pabay-an nyo na sikad kaw mangabot ta tama na mga betang daw ubos nang malain naan ta inyo na isip. ");
INSERT INTO cgc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga buang-buang! Di' ba Dyos na gabuat ta inyo na lawa, kanen man gabuat ta inyo na isip? Dapat dili nang inyo na mga buat miad. Dapat miad man naan ta inyo na isip. ");
INSERT INTO cgc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gani, bag-uon nyo inyo na isip daw mag-atag man na may kalipay ta nakem naan ta mga gakinanglan. Daw iling tan buaten nyo, paryo na limpyo kaw naan ta selled daw gwa tak ubos miad naan ta inyo na isip daw mga buat. ");
INSERT INTO cgc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kyo na mga Pariseo, maageman nyo segeng na silot! Gaamblig kaw gid na maalad naan ta Dyos isya na parti ta sampulo na parti ta tanan gid na paani nyo bisan ta mga daon na panglasa ta pagkaan daw gulayen. Piro, pabay-an nyo nang impurtanti na mga sugo tak dili igo inyo na pagtratar naan ta duma na mga ittaw daw ula kaw man gagugma ta Dyos. Igo na gaalad kaw ta isya ta sampulo na parti naan ta Dyos, piro dapat dili nyo bay-an mga sugo din an na mas impurtanti pa. ");
INSERT INTO cgc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kyo na mga Pariseo, maageman nyo segeng na silot! Na naan kaw ta mga balay tipunan, liag nyo gid na naan kaw ta pungkuan na para ta impurtanti na mga ittaw. Na naan kaw ta lugar na naan dya tama na mga ittaw, liag nyo gid na mga ittaw mag-atag ta taod ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kyo na mga Pariseo, maageman nyo segeng na silot! Pakita-kita nyo nang na dyusnon kaw, piro inyo an na tagipusuon dili limpyo. Paryo kaw ta mga lebbengan na daw lagen, dili lebbengan tak ula tanda. Paagian ta mga ittaw, piro ula danen nlami na ligna naan ta dalem.” ");
INSERT INTO cgc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","May mama na may datas alam parti ta Mga Sinulat Moises na naan man dya na gambal ki Jesus, “Mistro, nainsulto kay man ta mga paambal no an!” ");
INSERT INTO cgc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ambal Jesus, “Kyo man na mga may datas alam parti ta Mga Sinulat Moises, maageman nyo segeng na silot! Papatuman nyo naan ta mga ittaw tama na sunuron na bellay gid buaten na paryo papas-an nyo ta mga ittaw dala na sikad beg-at daw ula nyo man paduol naan ki danen maskin ta inyo nang na kalingking. ");
INSERT INTO cgc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kyo na mga may datas alam parti ta Mga Sinulat Moises, maageman nyo segeng na silot! Padayad nyo mga lebbengan an ta mga prupita na papatay anay pa sa ta inyo na mga kaapuan! ");
INSERT INTO cgc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tenged na padayad nyo mga lebbengan danen, pakita nyo na naan ta inyo na isip igo pabuat ta mga kaapuan nyo na papatay danen mga prupita. ");
INSERT INTO cgc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Parti ta iling tan na buat, Dyos an ta iya na alam gambal ta iling ti: ‘Pailingen ko ki danen mga manugsugid ta ake na kabebet-en daw mga sinugo ko. Duma an na mga pailingen ko patayen danen. Duma ya pangabuton ta mga gakuntra ki danen.’” ");
INSERT INTO cgc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ambal pa Jesus, “Gani, kyo na mga ittaw ta yi na timpo, manabat kaw tenged ta tanan na mga prupita na papatay alin pa ta pagbuat ta kalibutan. ");
INSERT INTO cgc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Manabat kaw ta kamatayen ta tanan na mga prupita umpisa gid ki Abel asta ki Zacarias na papatay naan ta Timplo naan ta tengnga ta sunugan ta mga alad daw Balay Ta Dyos. Ee, sugiran ta kyo na mga ittaw ta yi na timpo manabat gid ta kamatayen danen tanan. ");
INSERT INTO cgc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kyo na mga may datas alam parti ta Mga Sinulat Moises, maageman nyo segeng na silot! Ula kaw gapati ta kamatuuran na alin ta Dyos daw ula nyo man pasugid naan ta duma. Paryo kaw ta isya na ittaw na dili miag melled ta balay daw pegengan din pa duma na mga ittaw na miag melled tak pakamang din yawi ya.” ");
INSERT INTO cgc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na galin en Jesus i ta balay ta Pariseo, mga manugtudlo ta Mga Sinulat Moises daw duma na mga Pariseo gaumpisa na kuntraen gid danen kanen i daw sigi danen insa ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pabantayan gid danen iya na sabat aged madakep kanen an paagi ta iya na ambal. ");
INSERT INTO cgc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ta timpo na gaumpisa mga Pariseo an ta pagkuntra ki Jesus, gatipon eman naan ki Jesus sikad tama na mga ittaw. Gaginetek danen an asta duma an nautaran. Naan nang anay Jesus i gambal ta iya na mga tinudluan, “Mag-andam kaw gid daw maglikaw ta pampaabok ta mga Pariseo. Beet ambalen ko dili nyo sunuron iran na ugali na pakita-kita nang na danen an dyusnon. ");
INSERT INTO cgc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Piro, tanan na sikrito mlaman daw tanan na tinago mwa ta uryan. ");
INSERT INTO cgc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yon man, bisan ino na ambal nyo na pasikrito naan ta delem, mamatian gid ta tama na mga ittaw daw adlaw. Daw ino na paambal nyo naan ta selled ta kwarto na inay kagi nyo an, yon man isugid naan ta atep ta balay na tama na mga ittaw kamati.” ");
INSERT INTO cgc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ambal pa Jesus, “Kyo na mga arey ko, mamati kaw ki yaken. Dili kaw madlek ta mga ittaw na makapatay ki kyo tak bisan patayen kaw danen, ula en danen an duma pa na mabuat ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gambal a ki kyo daw kino gid dapat na adlekan nyo. Dyos nang gid tak ta pagkamang din ta inyo na kabui, may uturidad pa kanen an na pilak kaw naan ta impirno. Kanen nang gid adlekan nyo!” ");
INSERT INTO cgc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ambal pa Jesus, “Di' ba limma buok na yupan na derse barato nang na mapalit ta darwa nang na sinsilyo na tambaga? Piro, ula napabay-an ta Dyos maski isya ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kyo pa na mga ittaw, dili kaw pabay-an ta Dyos tak asta katamaen ta inyo na buok nlaman din. Gani, dili kaw madlek tak mas impurtanti kaw kaysa ta tama na yupan!” ");
INSERT INTO cgc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ambal pa Jesus, “Sugiran ta kyo na daw kino mag-ako naan ta tubangan ta mga ittaw na kanen sakep ki yaken, Yaken Na Alin Ta Langit Na Natao Naan Ta Kalibutan, akuon ko naan ta tubangan ta mga angil ta Dyos na kanen an sakep ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piro, daw kino mag-ambal naan ta tubangan ta mga ittaw na kanen dili sakep ki yaken, Yaken Na Alin Ta Langit Na Natao Naan Ta Kalibutan, ambalen ko naan ta tubangan ta mga angil ta Dyos na kanen an dili sakep ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tanan na mga ittaw na mag-ambal ta malain kuntra ki Yaken Na Alin Ta Langit Na Natao Naan Ta Kalibutan, mapatawad pa ta Dyos. Piro, daw kino mag-ambal ta malain kuntra ta Dyos Ispiritu Santo, dili en mapatawad. ");
INSERT INTO cgc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Daw dleen kaw naan ta balay tipunan daw naan man ta tubangan ta mga manugdumala daw mga upisyalis aged usisaen tenged ta inyo na pagsunod ki yaken, dili kaw magpalibeg daw ino isabat nyo ta pagdipindir nyo ta inyo na kaugalingen. ");
INSERT INTO cgc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ta uras ta pag-usisa ki kyo, Dyos Ispiritu Santo magtudlo ki kyo daw ino dapat na isabat nyo.” ");
INSERT INTO cgc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Naan ta mga ittaw na gatipon ki Jesus, may isya ki danen na gambal ki kanen, “Mistro, ambalan no ake an na utod na partian a din ta ame na panublien.” ");
INSERT INTO cgc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sabat Jesus ki kanen, “Dili ake na katengdanan na mag-ukom daw magparti ta inyo na panublien.” ");
INSERT INTO cgc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ambal Jesus ta mga ittaw dya, “Mag-andam kaw! Dili kaw magpangabot pa gid ta tama na mga betang tak dayad an na kabui ula ta katamaen ta inyo na pagkabetang.” ");
INSERT INTO cgc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gaisturya Jesus i ki danen ta isya na alimbawa, “May isya na mama na manggaranen gid na may dayad na tubbas ta iya na uma. ");
INSERT INTO cgc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gaisip kanen an, ‘Ino taan dayad na buaten ko? Kulang taguan ta ake i na mga tubbas.’ ");
INSERT INTO cgc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ambal din ta iya na kaugalingen, ‘Iling ti buaten ko. Gubbaen ko ake an na mga budiga daw magpatindeg a ta mas bakod pa gid na mga budiga. Naan ko dya taguon ake an na mga tubbas daw pagkabetang. ");
INSERT INTO cgc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Daw natago ko en tanan, ambalen ko ta ake na kaugalingen, “Tama en mga patagana ko para ta ake na kinanglanen ta tama pa na taon. Anduni, pwidi aren magpuay. Pagusto aren ta kaan daw inem daw magsadya!”’ ");
INSERT INTO cgc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Piro, Dyos an gambal ta manggaranen ya, ‘Buang-buang ka gid! Anduni, ta kilem na i mapatay ka. Kino magpulos ta patagana no an na manggad? Di, duma nang en na ittaw!’” ");
INSERT INTO cgc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ambal pa Jesus, “Iling tan matabo ta mga ittaw na gatipon ta manggad para nang ta iran na kaugalingen, piro ula danen palabia kabebet-en an ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ambal pa Jesus naan ta iya na mga tinudluan, “Gambal a ki kyo na dili kaw sali ta palibeg parti ta inyo na kabui daw parti man daw indi kaw kamang ta inyo na pagkaan. Dili kaw man sali ta palibeg ta bayo na suuton nyo. ");
INSERT INTO cgc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Di' ba pagkaan an, dili nang yon impurtanti para ta ate na kabui? Di' ba bayo an, dili nang yon impurtanti para ta ate na lawa? ");
INSERT INTO cgc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lagen nyo mga uwak an. Ula danen an gasabwag daw gaani! Ula man danen an mga tabungos daw budiga! Piro, bui man gyapon danen an tak Dyos gapakaan ki danen. Simpri kyo mas impurtanti kaysa ta mga yupan. ");
INSERT INTO cgc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Di' ba bisan magpalibeg kaw pa, dili nyo man gyapon madugangan ta bisan isya nang na uras inyo an na kabui? ");
INSERT INTO cgc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Daw dili nyo masarangan iling tan na buat na dili gid impurtanti, man-o tak gapalibeg kaw pa tenged ta inyo na mga kinanglanen? ");
INSERT INTO cgc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lagen nyo man mga bulak an naan ta blasan daw paino magtubo. Ula gapangabellay ta pag-ubra mga bulak an daw ula man gabuat ta bayo. Sugiran ta kyo na Ari Solomon ya na sikad manggaranen daw iya na mga bayo sikad dayad, ula kanen bayo na mas dayad pa kaysa ta isya na bulak. ");
INSERT INTO cgc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Papabulak ta Dyos mga lamunon an na bui naan ta blasan piro ta dili nang lugay rabasen nang daw imuon na pandabok naan ta pugon! Daw iling tan pabuat ta Dyos naan ta lamunon, simpri mas pa na kyo tagan ta Dyos ta bayo na suuton! Man-o tak kulang inyo an na pagsalig ta Dyos parti ta inyo na mga kinanglanen? ");
INSERT INTO cgc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dili kaw sali ta isip daw ino kan-enen nyo daw inemen. Dili kaw man sali ta palibeg. ");
INSERT INTO cgc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mga ittaw na ula gatuo ta Dyos, danen an pirmi gapalibeg parti ta tanan na kinanglanen danen. Piro, Dyos na ate na Amay, nlaman din daw ino inyo an na mga kinanglanen. ");
INSERT INTO cgc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dapat dili kaw magparyo ta mga ittaw na ula gatuo. Labien nyo inyo an na pagpasakep ta pagdumala ta Dyos. Daw iling tan buaten nyo, sigurado tagan kaw din ta inyo na mga kinanglanen.” ");
INSERT INTO cgc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Gambal pa Jesus i naan ta iya na mga tinudluan, “Maski pila kaw nang, dili kaw madlek tak nalipay Dyos na ate na Amay na papalabet kaw din ta iya na pagdumala. ");
INSERT INTO cgc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bligya nyo inyo an na mga pagkabetang daw kwarta an na bayad iatag nyo naan ta mga imol. Daw iling tan paggamit nyo ta inyo an na manggad, paryo kaw may puyo na dili magdaan na taguan ta manggad naan ta langit daw naan dya dili mabuinan tak dili makamang ta matakaw daw dili man maketket ta mga sapat. ");
INSERT INTO cgc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dapat iling tan buaten nyo tak daw indi kaw gatipon ta manggad nyo, naan man dya nakem nyo an.” ");
INSERT INTO cgc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ambal pa Jesus naan ta mga tinudluan din, “Dapat magparyo kaw ta mga suguon na gatagad ta iran na amo na muli alin ta kumbira ta kasal. Pirmi anda danen an maskin ino uras mabot iran na amo tak kasuot en danen an ta iran na bayo ta pag-ubra daw paambligan man danen na dili mapatay mga lampraan an. Tenged danen an anda en, daw mabot amo ya danen na mag-umaw naan ta may gangaan, mabukasan dayon danen iran ya na amo. ");
INSERT INTO cgc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sigurado gid na bakod na kalipay para ta mga suguon na maabutan ta iran na amo na danen an gabantay pa! Sugiran ta kyo na mamala amo an danen aged mimes na magsirbi ki danen. Pailingen din danen an naan ta lamisa daw sirbian. ");
INSERT INTO cgc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bakod na kalipay para ta mga suguon daw makita ta iran na amo na danen an gabantay na gatagad gid ta iya na pag-abot asta ta tenga kilem, daw ta mapit-madlaw. ");
INSERT INTO cgc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Intindien nyo ta miad na daw nlaman inta ta tag-iya ta balay daw ino uras mabot ittaw na manakaw, sigurado na bantayan din iya na balay aged matakaw an dili kaselled. ");
INSERT INTO cgc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gani, dapat na pirmi kaw anda tak Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mabot ta uras na ula nyo papaabuta.” ");
INSERT INTO cgc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pagtapos ta isturya Jesus, gainsa Pedro i, “Ginuo, kino paambalan no ta paanggid na isturya? Para nang nyan ki kami? Para ta tanan na mga ittaw na anen man di?” ");
INSERT INTO cgc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gasabat Ginuo paagi ta isya na paanggid para ta mga tinudluan din, “May tag-iya ta balay na gapili naan ta iya na mga suguon ta isya na masaligan daw maalam. Napili din na suguon patugyanan din na magdumala ta duma na mga suguon naan ta iya na panimalay daw tagan danen an ta iran na pagkaan ta igo na uras. ");
INSERT INTO cgc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Daw suguon na gadumala maabutan ta iya na amo na patuman din papaubra ya ki kanen, sigurado gid na bakod iya na kalipay. ");
INSERT INTO cgc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sugiran ta kyo na padumalaen kanen an ta amo din naan ta tanan na pagkabetang ta iya na amo. ");
INSERT INTO cgc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piro, daw suguon na gadumala gaisip na lugay pa malik iya na amo, mag-umpisa kanen na manakit ta duma na mga suguon, mama daw bai. Pagusto nang kanen an ta kaan daw inem daw sigi man na ingaw. ");
INSERT INTO cgc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na iling tan ubra din, gulpi nang abot iya na amo ta adlaw na ula din papaabuta daw ta uras na ula din nlami. Pag-abot ta iya na amo, silutan kanen an ta beg-at na silot paryo ta maageman ta mga dili masaligan na ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Daw may suguon na nlaman din daw ino liag ta iya na amo na buaten din, piro pabay-an din nang, sigurado na kastiguon kanen an ta tudo. ");
INSERT INTO cgc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Piro, suguon na ula nalam daw ino liag ta iya na amo daw yon na may nabuat kanen na kuntra ta liag ta iya na amo, simpri kastiguon kanen an, piro gaan nang. Daw kino patagan ta tama, pangitaan man kanen an ta tama. Daw kino na pasaligan ta bakod, mas bakod man sabaten din.” ");
INSERT INTO cgc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Gambal pa Jesus i naan ta iya na mga tinudluan, “Giling a di aged sunugon kalibutan i. Liag ko inta na gaapoy en. ");
INSERT INTO cgc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piro, tama pa na mga kabellay na kinanglan maagian ko anay. Paryo dili ko kaya isipen asta na matapos tanan na maagian ko! ");
INSERT INTO cgc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Salig nyo na ake na tuyo na giling a di aged magdala ta kalineng naan ta kalibutan i. Sugiran ta kyo, dili kalineng. Tenged ta pag-iling ko di, mga ittaw magbelagay. ");
INSERT INTO cgc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Umpisa anduni, magbelagay mga panimalay. Daw may anen limma na ittaw, darwa ya kuntraen ta tallo daw tallo ya kuntraen ta darwa. ");
INSERT INTO cgc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magkuntraay amay daw bata din na mama, yon man inay daw bata din na bai, daw yon man ugwangan na bai daw magad din na bai.” ");
INSERT INTO cgc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Gambal pa Jesus i naan ta tama na mga gapamati ki kanen, “Daw makita nyo na gadakmel item an naan ta salepan, mambal kaw dayon, ‘Muran kani!’ Guran man matuod. ");
INSERT INTO cgc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Daw mabatyagan nyo na eyep ta angin alin ta bagat, mambal kaw, ‘Madlaw kani!’ Gadlaw man matuod. ");
INSERT INTO cgc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gapakuno-kuno kaw nang na maalam kaw. Sagad kaw manilag ta mga nakita nyo naan ta kalibutan daw kalangitan. Man-o tak ula nyo nakamang daw ino beet ambalen ta mga natabo na pakita ta Dyos naan ta yi na timpo?” ");
INSERT INTO cgc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Gambal pa Jesus i naan ta mga ittaw, “Man-o tak dili kaw malam mag-isip daw ino dapat nyo na buaten? ");
INSERT INTO cgc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Daw may gakusar ki kaon, dapat tingwaen no na mag-ayusay kaw na ula kaw pa kabot naan ta uwis tak daw dleen ka din naan ta uwis, intriga ka naan ta pulis daw prisuon. ");
INSERT INTO cgc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sugiran ta kaw na dili ka pagwaen asta na mabayaran no gid tanan na dapat bayaran.” ");
INSERT INTO cgc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ta yon gid na timpo na tama na mga ittaw gatipon ki Jesus, may mga gaprani ki kanen daw gaisturya parti ta pabuat Gubirnador Pilato na gapapatay kanen ta mga taga-Galilea na danen an naan ta Timplo na gaiyaw ta mga ayep na alad danen. ");
INSERT INTO cgc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Gambal Jesus i ta mga gaisturya ki kanen, “Salig nyo taan na iling sa na klasi ta iran na kamatayen naan ta Timplo pamatuod na mas bakod iran na mga sala kaysa ta duma pa na mga taga-Galilea. ");
INSERT INTO cgc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sala inyo na paisip! Piro, sugiran ta kyo na daw dili kaw magnelsel daw dilian inyo an na mga sala, maageman nyo paryas ta iran na naageman tak silutan kaw man ta Dyos ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ino ta inyo na isip parti ta disi-utso na ittaw na natumbaan ta datas na turi naan ta banwa na Siloe? Salig nyo taan na iling sa na klasi ta kamatayen pamatuod na mas bakod iran na mga sala kaysa ta tanan na mga ittaw na sakep ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Sala inyo na paisip! Sugiran ta kyo na daw dili kaw magnelsel daw dilian inyo an na mga sala, maageman nyo man paryas ta iran na naageman tak silutan kaw man ta Dyos ta kamatayen.” ");
INSERT INTO cgc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gaisturya Jesus i ta paanggid parti ta pagnelsel, “Isya na mama may kaoy na igos naan ta iya na taneman ta ubas. Isya na adlaw, pabistaan din kaoy na igos daw may bunga. Piro, ula kanen an may nakita na bunga. ");
INSERT INTO cgc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gambal kanen an ta manug-asikaso ta iya na taneman, ‘Tallo en taon na gabalik-balik a di na gangita ta bunga ta kaoy na i, piro ula a may nakita! Pukanen no nang en tak yi na kaoy gakamang nang ta abuno ta basak.’ ");
INSERT INTO cgc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sabat ta manug-asikaso, ‘Amo, miad taan daw dili ta anay pukanen ni ta yi na taon. Kultibaren ko gid anay daw abunuan. ");
INSERT INTO cgc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Daw sunod na taon mamunga, miad gid i. Piro, daw dili mamunga, ula ki en may mabuat. Pukanen ta nang en.’” ");
INSERT INTO cgc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ta Adlaw Ta Pagpuay gatudlo Jesus i naan ta isya na balay tipunan. ");
INSERT INTO cgc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Naan man dya may bai na ta disi-utso anyos nakulian gid ta sakit na naan alin ta isya na malain na ispiritu. Tenged ta pabuat ta malain na ispiritu, sikad gid ekbe lawa din an daw dili din matadleng bisan ta tise nang. ");
INSERT INTO cgc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na nakita Jesus bai an, paumaw din na marani daw paambalan, “Manang, libri ka en ta imo na dipirinsya ta lawa.” ");
INSERT INTO cgc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pag-ambal Jesus, patungtong din iya na lima naan ta bai daw gatadleng dayon lawa ta bai daw gadayaw bai an naan ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gagilek gid manugdumala ta balay tipunan tak gapaayad Jesus i naan ta Adlaw Ta Pagpuay. Gambal manugdumala an naan ta mga ittaw dya, “May annem na adlaw ta isya na duminggo na patugutan ki na mag-ubra. Daw miag kaw na magpaayad ta inyo na masakit, miling kaw di ta mga adlaw ta pag-ubra. Dili nang ta Adlaw Ta Pagpuay!” ");
INSERT INTO cgc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sabat ta Ginuo ki kanen, “Pakita-kita nyo nang naan ta mga ittaw inyo an na pagtuman ta Dyos. Di' ba maskin Adlaw Ta Pagpuay, kada isya ki kyo gakamang ta inyo na baka daw asno na naigot naan ta pasilungan daw padala naan ta paineman? ");
INSERT INTO cgc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tenged inyo na mga ayep pabuatan nyo ta dayad naan ta Adlaw Ta Pagpuay, dapat na magtabang ki man ta yi na bai na linai man Abraham paryo ki kiten aged mayad kanen ta iya na dipirinsya ta lawa bisan anduni Adlaw Ta Pagpuay. Disi-utso en na anyos na paryo pagapos kanen Satanas tenged ta iya na masakit.” ");
INSERT INTO cgc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pag-ambal Jesus ta iling tan, mga ittaw dya na gakuntra ki kanen nagayya ta sabat din. Piro, nalipay gid katamaan ta mga ittaw dya tenged ta katingalaan na mga pabuat Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Gambal Jesus i naan ta mga ittaw na duma ki kanen, “Indi papaanggid pagdumala ta Dyos? Indi pakumparar? ");
INSERT INTO cgc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pagdumala an ta Dyos paryo ta natabo ta binni na mustasa na patanem ta isya na ittaw naan ta gulayan. Gatubo binni ya na naimo na bakod na kaoy daw mga yupan an gasalag naan ta iya na mga sanga.” ");
INSERT INTO cgc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gaisturya Jesus i ta isya pa na paanggid, “Indi pakumparar pagdumala ta Dyos? ");
INSERT INTO cgc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pagdumala an ta Dyos paryo ta natabo ta tise na pampaabok ta tinapay na palaket ta isya na bai naan ta tama gid na arina na bali tallo sekeb ta bakod na sekeban. Maskin tama arina an, napaabok man gyapon tanan.” ");
INSERT INTO cgc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Gapadayon Jesus i na miling naan ta Jerusalem. Naan ta mga banwa daw mga baryo na nailingan din gatudlo kanen an. ");
INSERT INTO cgc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ta iya na pagtudlo, may ittaw na gainsa ki kanen, “Ginuo, pila nang na mga ittaw na maluwas alin ta silot ta Dyos?” Gasabat Jesus i paagi ta isya na paanggid na isturya, ");
INSERT INTO cgc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Buaten nyo tanan nyo an na masarangan aged makaselled naan ta kitid na gangaan tak sugiran ta kyo na tama na mga ittaw na magtingwa na melled, piro dili danen makaselled. ");
INSERT INTO cgc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Daw tag-iya an ta balay manirado en daw magtrangka ta gangaan, naan kaw nang en ta gwa magtindeg daw manuktok naan ta sara na mangabay, ‘Sir! Paselleren kay no!’ Magsabat tag-iya an, ‘Ara, daw kino kaw yan a! Ula ko nlami daw taga indi kaw!’ ");
INSERT INTO cgc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sabat nyo, ‘Kala kay no inta tak agi ki en dumaay na gakaan. Katudlo ka pa naan ta ame ya na banwa!’ ");
INSERT INTO cgc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Piro, mag-ambal isab tag-iya an, ‘Dili ta kyo kala. Ula ko nlami daw taga indi kaw! Malin kaw di ta atubangan ko, kyo tanan na gabuat ta malain.’ ");
INSERT INTO cgc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Daw makita nyo na naan ta kaarian ta Dyos danen Abraham, Isaac, Jacob daw tanan na prupita, mangagal kaw ta tudo daw magbaggit ta inyo na ngipen ta kaeget tak tabugon kaw daw dili paselleren. ");
INSERT INTO cgc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kyo yan dili paselleren, piro mga ittaw na dili linai Israel na alin ta appat na pamusod ta kalibutan mandegek ta kumbira na naan ta kaarian ta Dyos. Alin danen ta sennangngan, salepan, mian daw bagat. ");
INSERT INTO cgc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sigurado gid na may mga ittaw na salig nyo na uryan anduni, piro naan ta kaarian ta Dyos una en danen an. May mga ittaw man na salig nyo na una anduni, piro naan ta kaarian ta Dyos uryan danen an.” ");
INSERT INTO cgc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pagtapos Jesus tudlo, may mga Pariseo na gaprani ki kanen daw gambal, “Malin ka di daw magpadyo tak Herodes may plano na patayen ka.” ");
INSERT INTO cgc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ambal Jesus ki danen, “Ambalen nyo ta tuso na ya na ittaw, ‘Dili a malin di. Maski lipo nang en ake na timpo, magpadayon a man gyapon na magpagwa ta mga malain na ispiritu alin ta mga ittaw daw magpaayad man ta mga ittaw na may masakit asta ta timpo na naan ta plano ta Dyos na matapos ko tanan na tuyo ta pag-iling ko di. ");
INSERT INTO cgc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Di' ba mga prupita ya naan papatay ta Jerusalem? Magpadayon aren ta pagpanaw ko na munta ta Jerusalem tak impusibli na patayen prupita an naan ta duma pa na lugar tenged naan nang gid ta Jerusalem patayen.’” ");
INSERT INTO cgc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Gangasebe Jesus i daw gambal, “Kyo na naan ta Jerusalem, kaluluoy kaw. Ula nyo batuna mga padala ya ta Dyos tak papatay nyo mga prupita daw patimbag mga sinugo ya ta Dyos. Lugay en na liag ko na pasakepen kaw inta ki yaken daw ambligan paryas ta pagtipon ta nayen na manok ta iya na mga piyak naan ta dalem ta iya na mga pakpak. Piro, dili kaw miag! ");
INSERT INTO cgc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tenged iling tan nabuat nyo, anduni syudad nyo an daw Timplo pabay-an nang en ta Dyos. Sugiran ta kyo na dili a nyo makita isab asta mabot adlaw na mambal kaw, ‘Dayawen ta kanen an na papadala ta Ginuo Dyos na miling di en.’” ");
INSERT INTO cgc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ta Adlaw Ta Pagpuay giling Jesus i naan ta balay ta isya na Pariseo na may datas na katengdanan tak paimbitar na maan dya. Pag-abot Jesus, papanilagan gid ta miad kanen i ta mga ittaw dya daw may buaten kanen na kuntra ta sunuran ta iran na riliyon. ");
INSERT INTO cgc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","May mama dya na gubbag lawa din an tenged ta iya na masakit. Gaprani kanen an na gatubang ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pagprani din, mga Pariseo an na naan dya daw mga ittaw man na may datas alam parti ta Mga Sinulat Moises painsaan Jesus, “Ino ta inyo na isip, naan ta Mga Sinulat Moises patugot na naan ta Adlaw Ta Pagpuay magpaayad ki ta mga ittaw na may masakit?” ");
INSERT INTO cgc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Piro, ula danen an gasabat ki Jesus. Tenged ula danen gasabat, paibitan din mama ya na gamasakit daw paayad daw paambalan na muli. ");
INSERT INTO cgc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gambal Jesus i ki danen, “Daw isya ki kyo may bata na ta Adlaw ta Pagpuay nulog naan ta kinutkot na waig, di' ba kamangen nyo dayon maskin Adlaw Ta Pagpuay? Iling man tan daw nulog inyo na baka.” ");
INSERT INTO cgc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pagtapos ta ambal Jesus, ula danen an gasasaba tak igo ambal din an. ");
INSERT INTO cgc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Naan ta balay ta Pariseo na gaimbitar ki danen, nakita Jesus na mga bisita an gapili ta iran na mapungkuan naan ta mga patagana para ta mga ittaw na impurtanti. Tenged ta nakita din, galaygay kanen i ki danen paagi ta alimbawa, ");
INSERT INTO cgc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Daw imbitaren ka naan ta kumbira ta kasal, dili ka mili ta pungkuan na patagana para ta mga ittaw na impurtanti tak basi may bisita man na paimbitar na mas impurtanti pa ki kaon. ");
INSERT INTO cgc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Daw bisita na mas impurtanti mabot, ittaw an na gaimbitar ki kyo magprani ki kaon daw mambal, ‘Pwidi no iatag ki kanen pungkuan no an?’ Tenged ta ambal din, magayyaan ka daw papungkuon ka din duma ta mga kebes. ");
INSERT INTO cgc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dapat daw imbitaren ka naan ta kumbira, mili ka ta pungkuan na para ta mga kebes. Daw naan ka dya mungko, ittaw na gaimbitar ki kaon magprani daw mambal, ‘Dey, dapat naan ka ta pungkuan na para ta mga ittaw na impurtanti.’ Tenged ta ambal din, tauron ka naan ta tubangan ta tanan na bisita. ");
INSERT INTO cgc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dapat iling tan buaten nyo tak daw kino magpadatas ta iya na kaugalingen, paebesen kanen an ta Dyos. Daw kino magpaebes an ta iya na kaugalingen, padatasen kanen an ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gambal Jesus i ta ittaw ya na gaimbitar ki kanen, “Daw gusto no mag-imbitar ta duma na mga ittaw na migma o magyapon, dili ka mag-imbitar ta mga arey no, ta mga utod, ta mga parinti daw ta mga manggaranen na silingan no tak basi ta pila na mga adlaw danen mag-imbitar man ki kaon. Daw imbitaren ka danen, mabaton no en bales ta imo na pag-imbitar ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dapat daw magpakumbira ka, imbitaren no mga imol an, mga pingkaw, mga piang daw mga bulag. ");
INSERT INTO cgc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Daw iling tan na mga ittaw imbitaren no, ta uryan may angken ka na kalipay alin ta Dyos tak maskin dili danen kabales ta pag-imbitar no, Dyos an magbales gid ki kaon ta dayad naan ta adlaw na mga matareng ya bannawen ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na naan pa Jesus i ta balay ta Pariseo, isya na bisita na gakaan duma ki kanen daw kamati ta iya na laygay gambal, “May bakod na pribiliyo mga ittaw na kalabet ta kumbira naan ta kaarian ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Paisturyaan Jesus kanen an ta isya na paanggid, “May ittaw na gaanda ta bakod na kumbira daw tama na mga ittaw paimbitar din. ");
INSERT INTO cgc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ta uras ta kumbira, papailing din iya na suguon naan ta mga paimbitar aged ambalan, ‘Miling kaw en tak tanan anda en!’ ");
INSERT INTO cgc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Piro, kada isya ki danen na paimbitaran gabalibad na dili kailing ta kumbira. Ambal ta isya ya, ‘Bag-o a nang kapalit ta basak. Kinanglan miling a dya aged lagen ko. Kaon nang magpasinsya ki yaken.’ ");
INSERT INTO cgc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ambal man ta duma ya, ‘Bag-o a nang kapalit ta sampulo na baka daw anduni lagen ko daw dayad magrado. Kaon nang magpasinsya ki yaken.’ ");
INSERT INTO cgc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ambal pa gid ta duma ya, ‘Dili a kailing tak bag-o a nang kasal.’ ");
INSERT INTO cgc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pag-uli ta suguon, pasugiran din iya na amo na tanan na mga paimbitar gabalibad. Gagilek gid amo ya daw gambal ta suguon din, ‘Giran no. Miling ka naan ta mga dalan daw mga agian ta ate na banwa daw dleen no di mga imol an, mga pingkaw, mga bulag daw mga piang.’ Pagtapos ta ambal ta amo, dayon panaw suguon ya. ");
INSERT INTO cgc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pagbalik din, ambal din ta iya na amo, ‘Sir, natuman ko en sugo no ki yaken, piro may bakanti pa na pungkuan naan ta kumbiraan.’ ");
INSERT INTO cgc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ambal ta amo ya naan ta suguon, ‘Miling ka naan ta mga karsada daw derse na mga dalan na naan ta gwa ta banwa. Anggaten no na miling di mga ittaw an na makita no dya aged ula bakanti na pungkuan naan ta ake na kumbira. ");
INSERT INTO cgc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sugiran ta kaw na tanan ya na paimbitaran ko na gabalibad, ula maskin isya ki danen na makatilaw ta paanda ko naan ta kumbira!’” ");
INSERT INTO cgc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ta pagpanaw Jesus na miling ta Jerusalem, tama na mga ittaw gakuyog ki kanen. Gatubang kanen ki danen daw gambal, ");
INSERT INTO cgc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Daw kino liag na muyog ki yaken, piro mas palangga din mga ginikanan din an, sawa, kabataan, mga utod asta iya na kaugalingen kaysa ki yaken, dili pwidi na kanen isya man ta ake na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Daw kino dili miag na magparyo kanen an ta ittaw na gapas-an ta iya na krus tenged iling tan buaten ta ittaw na magsunod ki yaken, dili pwidi na kanen isya man ta ake na mga tinudluan.” ");
INSERT INTO cgc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Gaisturya Jesus ta isya na alimbawa, “Daw isya ki kyo gaplano na magpatindeg ta turi, isipen din gid anay daw sumaen daw pila magastos din bag-o mag-umpisa tukod aged mlaman din daw igo kwarta din an para kapatapos ta turi. ");
INSERT INTO cgc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Daw ula kanen an gaisip anay, basi dili kanen kapatapos ta turi tak kwarta din an igo nang gid para ta pagpaubra ta pundasyon. Tatawaan nang kanen an ta tanan na kakita. ");
INSERT INTO cgc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mambal danen, ‘Nyan, lagen nyo ittaw na yan. Gaumpisa kanen an ta pagpatindeg ta turi, piro dili kapatapos!’” ");
INSERT INTO cgc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Gaisturya pa Jesus ta isya pa na alimbawa, “Daw may ari na gusto na maggira ta duma na ari, bag-o kanen magsulong isipen din anay daw sampulo libo na mga sundalo din kasarang na magbatok ta binti mil na mga sundalo ta kuntra din na ari. ");
INSERT INTO cgc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Daw ta isip din dili danen an makasarang na magbatok ta kuntra, bag-o mabot iran na kuntra, ipadala din mga ittawan din na munta ta iran na kuntra aged magsugtanay danen para ta kalineng. ");
INSERT INTO cgc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iling man tan, kada isya ki kyo kinanglan na mag-isip anay parti ta pagsunod ki yaken. Daw kino na dili miag na dilian tanan na pagkabetang din, dili pwidi na kanen isya man ta ake na mga tinudluan.” ");
INSERT INTO cgc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Gambal pa Jesus i naan ta mga ittaw na gakuyog ki kanen, “Daw asin natimpla naan ta pagkaan, magdayad lasa ta pagkaan. Piro, daw ula en lasa asin an, impusibli na magmasin pa isab. ");
INSERT INTO cgc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ula pulos asin an na ula en lasa tak dili magamit bisan pa ta pang-abuno. Gani, papilak nang en. Daw kino liag na magbaton ta ake i na ambal, isipen din gid ta usto namatian din an!” ");
INSERT INTO cgc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tama na manugsukot ta buis daw makasasala na mga ittaw na giling ki Jesus aged mamati ta tudlo din. ");
INSERT INTO cgc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tenged pabay-an nang Jesus na mamati ki kanen mga makasasala an, mga Pariseo ya daw mga manugtudlo ta Mga Sinulat Moises gagumod na gaisturyaay, “Yan na ittaw gabaton ta makasasala na mga ittaw daw gakaan pa na duma ki danen!” ");
INSERT INTO cgc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tenged ta paggumod ta mga Pariseo daw mga manugtudlo, gaisturya Jesus i ki danen ta paanggid na iling ti: ");
INSERT INTO cgc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“May ittaw na mga karniro din an isya gatos. Daw marwad isya, simpri bilin din anay nubintay-nuibi an naan ta paalaban daw ngitaen din isya ya na narwad asta na makita. ");
INSERT INTO cgc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Daw makita din, pas-anen din daw dleen muli na may kalipay. ");
INSERT INTO cgc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pag-uli din, umawen din iya an na mga arey daw mga silingan daw mambal, ‘Magsadya ki tak nakita ko en karniro ko na narwad!’” ");
INSERT INTO cgc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pagtapos Jesus ta isturya ta paanggid, gambal kanen ta mga gagumod, “Sugiran ta kyo na iling man tan na mas bakod gid kalipay ta Dyos daw iya na mga angil naan ta langit tenged ta isya na ittaw na kasala na ganelsel daw padilian din iya an na mga sala kaysa ta kalipay tenged ta nubintay-nuibi na matareng na mga ittaw na dili kinanglan magnelsel.” ");
INSERT INTO cgc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Gaisturya Jesus ta isya pa na paanggid, “May bai na sinsilyo din an sampulo buok na pilak. Daw marwad isya an, simpri magtutod kanen an ta lampraan daw magsillig na ngitaen din gid ta miad naan ta iya na balay asta na makita. ");
INSERT INTO cgc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Daw makita din, umawen din iya an na mga arey daw mga silingan daw mambal, ‘Magsadya ki tak nakita ko en sinsilyo ko na narwad!’” ");
INSERT INTO cgc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pagtapos Jesus ta pag-isturya ta paanggid, gambal kanen ki danen na mga gagumod parti ta iya na pagbaton ta mga ittaw na makasasala, “Sugiran ta kyo na iling man tan, may bakod na kalipay Dyos an daw iya na mga angil tenged ta isya na ittaw na kasala na ganelsel daw padilian din iya an na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Gaisturya Jesus i ta isya pa gid na paanggid naan ki danen na mga gagumod parti ta iya na pagbaton ta mga ittaw na makasasala. Ambal din, “Isya na amay may bata na darwa na mama. ");
INSERT INTO cgc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bata ya na mangngod gambal ki kanen, ‘Tay, atag no en ki yaken ake na panublien.’ Tenged ta ambal ta bata din, paparti din iya an na mga pagkabetang naan ta darwa din na bata. ");
INSERT INTO cgc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Paglambay ta pila na mga adlaw, pabligya ta mangngod iya na parti ta panublien daw giling naan ta madyo na lugar na dala din tanan na kwarta. Na naan en kanen an ta madyo na lugar, pagusto nang kanen ta gastos ta mga ula pulos. ");
INSERT INTO cgc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na ubos din en gasta tanan din na kwarta, natabuan na may segeng na letem naan ta lugar na patiniran din daw ula gid en kanen an makaan. ");
INSERT INTO cgc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tenged kanen an ula en kwarta, gaprisintar kanen an na mubra naan ta isya na gistar dya. Pabaton kanen an daw papadala naan ta uma aged magsagod ta mga baboy. ");
INSERT INTO cgc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tenged ta iya na kaletem, gusto din gid inta na maan ta baog ta mga baboy. Piro, ula gid may naluoy ki kanen na mag-atag ta pagkaan. ");
INSERT INTO cgc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Paglambay ta pila na mga adlaw, paisip din ta miad iya na kaimtangan. Ambal din ta iya na kaugalingen, ‘Mga gaubra ya naan ta amay ko, tama gid iran na pagkaan, piro yaken i a, mapatay a gid di ta letem! ");
INSERT INTO cgc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Miad pa na muli a nang en naan ta amay ko daw mambal a, “Tay, kasala a gid kuntra ta Dyos daw ki kaon. ");
INSERT INTO cgc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dili aren dapat na umawen pa na imo na bata. Tratuon a no nang en na isya ta mga gaubra naan ki kaon.”’ ");
INSERT INTO cgc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tenged iling tan isip ta mangngod an, gapanaw kanen an na muli naan ta amay din. “Na madyo nang pa kanen an naan ta iran na balay, nabantaw en kanen an ta iya na amay. Naluoy gid amay din an ki kanen. Dayon gadlagan amay din na sugaten kanen an daw paakes daw paarekan. ");
INSERT INTO cgc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gambal kanen ta iya na amay, ‘Tay, kasala a gid kuntra ta Dyos daw ki kaon. Dili aren dapat na umawen pa na imo na bata.’ ");
INSERT INTO cgc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Piro, amay din ya gambal naan ta mga suguon, ‘Giran nyo! Dleen nyo di pinakadayad an na bayo daw ipasuot ki kanen. Suksukan nyo ta singsing tudlo din an daw suutan ta sandal batiis din an. ");
INSERT INTO cgc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kamangen nyo papatambek ya na baka na bata pa na patagana para ta kumbira daw iyawen. Magkumbira ki daw magsadya ");
INSERT INTO cgc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tak bui ake i na bata na salig ta na patay en. Paryo narwad kanen i, piro anduni nakita en!’ Pagtapos din ambal, gaumpisa danen an na magsadya. ");
INSERT INTO cgc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ta pag-uli ta mangngod, ula dya magulang din tak gaubra naan ta uma. Na guli magulang ya daw dani en kanen an ta iran na balay, namatian din tukar daw sagbak ta mga ittaw naan ta sinayaw. ");
INSERT INTO cgc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gumaw kanen an ta isya na suguon daw painsaan daw gaino mga ittaw an. ");
INSERT INTO cgc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sabat ta suguon ya, ‘Mangngod no guli en. Gapaiyaw inyo na amay ta papatambek na baka na bata pa na patagana para ta kumbira tak kauli mangngod no na bui daw ula may malain na natabo ki kanen.’ ");
INSERT INTO cgc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pagmati ta magulang, gagilek gid kanen an daw ula kanen gaselled naan ta iran na balay. Na nlaman ta amay din na ula kanen gaselled, gagwa amay din an daw paalam-alaman kanen an na melled. ");
INSERT INTO cgc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gambal kanen an naan ta iya na amay, ‘Tay, demdemen no na lugay aren na gapangabellay paryo ta suguon no daw tanan na sugo no patuman ko gid. Piro, ula ka gid gaatag ki yaken maskin ta isya nang na tinday na kanding aged magsadya a na duma ta mga arey ko. ");
INSERT INTO cgc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Piro, nyan na bata no, maskin pasayangan din mga pagkabetang no naan ta bayaran na mga bai, pag-uli din, paiyawan no pa kanen an ta papatambek na baka na bata pa na patagana para ta kumbira!’ ");
INSERT INTO cgc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ambal ta amay din ki kanen, ‘Tong, kaon yan naan pirmi di na duma ki yaken daw tanan na pagkabetang ko imo man. ");
INSERT INTO cgc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dapat na magsadya ki daw magpasalamat tak bui mangngod no na salig ta patay en. Paryo kanen an narwad, piro nakita en!’” ");
INSERT INTO cgc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isya adlaw, na gapanaw Jesus miling ta Jerusalem, gaisturya kanen i ta paanggid naan ta iya na mga tinudluan, “Isya na mama na manggaranen may manugdumala ta iya na pagkabetang. Isya na adlaw may gasugid ki kanen na kwarta din ya pagastos nang ta ula pulos ta iya na manugdumala. ");
INSERT INTO cgc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pagmati din ta balita ya, papaumaw din iya na manugdumala daw ambalan, ‘Namatian ko na pagastos no ta ula pulos ake na kwarta. Iatag no ki yaken mga sumada ta panigusyo no alin ta pagkabetang na pasalig ko ki kaon tak dili ka en pwidi na magdumala ta ake na mga pagkabetang!’ ");
INSERT INTO cgc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Manugdumala an gambal ta iya na kaugalingen, ‘Ino buaten ko tak palinen aren ta amo ko? Dili ko masarangan ubra an ta trabador daw nagayya a man na magpalimos. ");
INSERT INTO cgc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, nlaman ko en daw ino buaten ko aged daw palinen aren, may mga arey a na magbaton ki yaken naan ta iran na mga balay.’ ");
INSERT INTO cgc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pagtapos din ta isip, paumaw din kada isya na may utang ta iya na amo. Una na ittaw na paumaw din painsaan din, ‘Pila utang no ya ta amo ko?’ ");
INSERT INTO cgc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sabat ta ittaw, ‘Isya gatos na tadyaw na lana ta olibo.’ Ambal din, ‘Yi listaan ta utang no. Giran no! Mungko ka di daw silian ta singkwinta nang en.’ ");
INSERT INTO cgc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Isya pa na ittaw painsaan din, ‘Ta, kaon a. Pila utang no ya?’ Sabat ta ittaw, ‘Isya libo na sako na trigo.’ Ambal din, ‘Yi listaan ta utang no. Silian no ta wallo gatos nang.’ ");
INSERT INTO cgc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na namatian ta amo parti ta ubra ta sikad magdaya na manugdumala din, padayaw din tak manugdumala malam mangita ta paagi para ta kaugalingen din na kayaran.” Ambal pa Jesus, “Iling man tan mga ittaw na ula gatuo ta Dyos. Mas malam danen an kaysa ta mga gatuo an ta Dyos ta pagtratar danen ta iran na mga duma para ta iran na kaugalingen na kayaran. ");
INSERT INTO cgc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Piro, mabot timpo na ula en pulos manggad nyo an. Gani, sugiran ta kyo na dapat gamiten nyo manggad nyo an unti ta kalibutan i ta pagbuat ta miad naan ta mga ittaw aged may magbaton man ki kyo naan ta istaran na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Daw kino masaligan parti ta pila nang na mga betang, simpri masaligan man parti ta tama. Daw kino dili masaligan parti ta pila nang na mga betang, simpri dili man masaligan parti ta tama. ");
INSERT INTO cgc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yon man, daw dili kaw masaligan parti ta manggad naan ta kalibutan i, dili kaw man saligan ta Dyos ta matuod na manggad naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Daw dili kaw masaligan ta pag-ibit ta manggad na dili inyo, dili kaw man tagan ta Dyos ta manggad na patagana para ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Impusibli na isya na suguon, dengngan din na sirbian darwa na amo tak isya an palanggaen din daw tumanen na terek ta iya na tagipusuon, piro isya ya pakalainen din daw dili man tauron. Iling man tan, daw labien nyo pagpatama an ta inyo na manggad, impusibli na sirbian nyo Dyos an.” ");
INSERT INTO cgc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mga Pariseo na gamati ta tudlo Jesus parti ta manggad, gayami danen an ki kanen tak ubos nang kwarta naan ta iran na isip. ");
INSERT INTO cgc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Gambal Jesus ki danen, “Pakita-kita nyo nang ta mga ittaw na kyo yan matareng. Piro Dyos an, nlaman din daw ino gid naan ta inyo na mga tagipusuon. Tama na pabilang na impurtanti ta mga ittaw, piro naan ta Dyos ula pulos. ");
INSERT INTO cgc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Bag-o gaumpisa ta pagwali Juan ya na manugbautismo, palabi gid ta mga ittaw Mga Sinulat Moises daw Mga Sinulat Ta Mga Prupita. Piro, umpisa ta timpo ta pagwali ya Juan, miad na balita an parti ta pagdumala ta Dyos pasugid en daw tama na mga ittaw nakumbinsi gid na magpasakep ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piro, dili beet ambalen na pwidi pabay-an Mga Sinulat Moises tak mas pusibli na marwad kalangitan an daw kalibutan i kaysa na marwad maski isya na punto ta mga tudlo naan ta Mga Sinulat Moises. ");
INSERT INTO cgc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Alimbawa, sugo an na parti ta pagsawaay dili pwidi pabay-an. Bisan kino na mama na magbelag ta iya na sawa daw mangasawa kanen isab ta duma na bai, kasala kanen an tak paryas man gyapon na kanen an gaintra ta bai. Bisan kino na mama na mangasawa ta bai na pabelagan ta una na sawa, kanen an kasala tak paryas man gyapon na gaintra kanen ta bai.” ");
INSERT INTO cgc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Gaisturya pa Jesus i ta mga Pariseo na ubos nang kwarta naan ta iran na isip, “May mama na sikad manggaranen na iya na mga bayo maalen na buat alin ta dayad gid na tila na lino daw tila na kulor bayulit. Adlaw-adlaw pagusto kanen an ta sabor na mga pagkaan. ");
INSERT INTO cgc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","May isya man na mama na imol na ngaran din Lazaro. Panno gid ta katel lawa din an. Pirmi kanen an naan ta ngaan ta balay ta mama na manggaranen ");
INSERT INTO cgc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","tak liag din na maan inta maskin ta pagkaan na nulog nang alin ta lamisa ta manggaranen ya. Papranian pa kanen an ta mga ayam daw padilaan mga katel din an. ");
INSERT INTO cgc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ta uryan, Lazaro napatay daw padala ta mga angil naan ta langit daw papungko kanen naan dapit ta kilid Abraham. Manggaranen ya napatay man daw palebbeng. ");
INSERT INTO cgc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Naan ta Hades na lugar ta mga patay, manggaranen ya pasilutan ta segeng na kasakit. Nabantaw din Abraham daw nabantaw din man Lazaro na naan dapit ta kilid Abraham. ");
INSERT INTO cgc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tenged ta segeng na kasakit na nabatyagan din, gaumaw kanen ki Abraham, ‘Tay Abraham, maluoy ka ki yaken! Suguon no tuo Lazaro an na tugmaw din ta waig tudlo din an daw tuluan din dila ko i aged mabugnawan tak dili aren kaagwanta ta segeng na dangga ta apoy di!’ ");
INSERT INTO cgc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ambal Abraham ki kanen, ‘Tong, demdemen no na bui ka pa sa, gapagusto ka nang, piro Lazaro i a, nakulian gid. Anduni, unti Lazaro i nalipay, piro imo a unsan, nabatyagan no segeng na kasakit. ");
INSERT INTO cgc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Isya pa, may anen na sikad dalem na laang na nabetang naan ta ate na tengnga aged bisan kino naan ki kami na miag na miling dyan ki kyo dili makailing daw bisan kino na naan dyan ki kyo dili makalakted di.’ ");
INSERT INTO cgc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ambal ta manggaranen ya, ‘Tay Abraham, daw iling san, gapakiluoy a gid ki kaon na pailingen no Lazaro yan naan ta balay ta amay ko ");
INSERT INTO cgc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tak may limma a pa na utod na mga mama. Kanen magpaandam ki danen aged dili danen mailingan yi na lugar na may segeng na kasakit.’ ");
INSERT INTO cgc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ambal Abraham, ‘Pwidi danen basaen mga paandam naan ta Mga Sinulat Moises daw Mga Sinulat Ta Mga Prupita. Dapat na patian danen.’ ");
INSERT INTO cgc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sabat ta manggaranen ya, ‘Tay Abraham, dili danen nya patian. Piro, daw may miling ki danen alin ta lugar ta mga patay daw maglaygay ki danen, sigurado na magnelsel danen an daw dilian iran na mga sala.’ ");
INSERT INTO cgc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ambal Abraham ki kanen, ‘Daw dili danen magpati ta mga paandam naan ta Mga Sinulat Moises daw ta Mga Sinulat Ta Mga Prupita, dili man gyapon danen ya magpati maskin may ittaw na mabannaw na miling ki danen.’” ");
INSERT INTO cgc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isya na adlaw na gapanaw Jesus i miling ta Jerusalem, galaygay kanen i naan ta iya na mga tinudluan, “Impusibli na malikawan mga tintar an na makasala mga ittaw. Piro, segeng na silot maageman ta ittaw na kanen tenaan na duma na ittaw makasala! ");
INSERT INTO cgc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas miad pa daw tabiran iya na lieg ta galingan na bato daw ulog kanen an naan ta dagat kaysa kanen tenaan na makasala bisan isya nang ta kebes ko na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gani, mag-amblig kaw daw ino pabuat nyo!” Ambal din pa, “Daw isya ta mga duma no makasala kuntra ki kaon, ambalan no kanen an parti ta iya na sala. Daw magnelsel kanen an daw mangayo ta patawad, patawaren no. ");
INSERT INTO cgc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Daw makasala kanen an kuntra ki kaon ta pitto bisis seled ta isya na adlaw daw pitto man bisis kanen an miling ki kaon na mangayo ta patawad, patawaren no!” ");
INSERT INTO cgc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Gambal mga apustulis an naan ta Ginuo, “Tabangan kay no aged magbiskeg pa gid pagsalig nay an naan ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ambal ta Ginuo, “Bisan inyo na pagsalig ta Dyos tise nang na paryas katise ta binni na mustasa, sarang kaw mambal ta yi na kaoy na sikumuro, ‘Gabuton ka ta Dyos daw ilakted naan ta dagat,’ daw matuman man ambal nyo an.” ");
INSERT INTO cgc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ambal pa ta Ginuo naan ta mga apustulis, “Alimbawa, may mama na suguon na garado daw gabantay ta mga karniro. Daw muli kanen alin ta uma, dili mambal iya na amo ki kanen, ‘Giran no, manaw ka di. Maan ki.’ ");
INSERT INTO cgc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Simpri dili mambal iya na amo ta iling tan. Ambalan kanen an, ‘Mag-imes ka ta yapon ko. Sunod, magsili ka ta bayo daw magsirbi ka ki yaken mintras gakaan a. Pagtapos ko kaan, pwidi ka en maan.’ ");
INSERT INTO cgc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dili man pasalamatan kanen an ta iya na amo tak patuman din nang sugo an ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iling kaw man tan. Daw matuman nyo tanan na sugo ta Dyos ki kyo, dapat ambalen nyo, ‘Mga suguon ki nang. Gatuman ki nang ta ate na katengdanan.’” ");
INSERT INTO cgc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na giling Jesus i ta Jerusalem, naan kanen i gaagi ta dulunan ta mga prubinsya ta Samaria daw Galilea. ");
INSERT INTO cgc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pagselled din ta isya na banwa, may nasugat kanen na sampulo na mama na may segeng na masakit ta langgit. Na madyo pa danen an ki kanen, gateneng danen ");
INSERT INTO cgc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","daw gangayo ta tabang na tudo iran na kagi, “Jesus! Mistro! Maluoy ka ki kami!” ");
INSERT INTO cgc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkita din ki danen, paambalan din, “Miling kaw naan ta mga pari daw magpatan-aw ki danen daw ayad kaw en.” Na giling nang pa danen an naan ta mga pari, ayad en danen an. ");
INSERT INTO cgc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Isya ki danen na nakita din na kanen an ayad en, gabalik ki Jesus daw gadayaw man ta Dyos na tudo iya na kagi. ");
INSERT INTO cgc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Galuod kanen naan ta atubangan Jesus daw gapasalamat. Kanen an isya na Samaritano. ");
INSERT INTO cgc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Gambal Jesus i naan ta mga ittaw dya, “Di' ba sampulo mga napaayad ya? Indya taan syam ya? ");
INSERT INTO cgc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Man-o tak duma ya ula kabalik na magpasalamat ta Dyos? Yi nang na mama na istrangiro pa gabalik di.” ");
INSERT INTO cgc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ambal Jesus ta mama ya na gabalik, “Mindeg ka daw manaw. Tenged ta pagsalig no ta Dyos nayad ka en.” ");
INSERT INTO cgc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","May mga Pariseo na gainsa ki Jesus daw kan-o mag-umpisa papaabot na pagdumala ta Dyos. Sabat Jesus, “Dili paagi ta pagpanilag na mlaman ta mga ittaw daw kan-o mag-umpisa pagdumala an ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nyan na, ula may mambal, ‘Lagen nyo! Yi, anen di en pagdumala ta Dyos!’ daw ula man may mambal, ‘Yo, anen dya en pagdumala ta Dyos!’ tak papaabot nyo na pagdumala ta Dyos naan en ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Gambal Jesus i naan ta iya na mga tinudluan, “Mabot timpo na gusto nyo gid inta na kabalik en Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan aged magduma kaw ki kanen bisan isya nang na adlaw. Piro, dili pa matabo ta timpo na bui kaw pa. ");
INSERT INTO cgc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta yon man na timpo na mabot en kanen, may mambal ki kyo, ‘Yo, unso Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan!’ Duma an mambal, ‘Yi, anen di kanen i!’ Piro, dili kaw magpati daw dili man manaw na ngitaen kanen an ");
INSERT INTO cgc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","tak ta adlaw na mabot kanen an, makita kanen an ta tanan na mga ittaw paryo ta kilat na makita gid na gapapawa ta bilog na kalangitan. ");
INSERT INTO cgc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piro, bag-o kanen mabot, kinanglan anay na maagian din tama na malain na buaten ki kanen daw sikwayen kanen i ta mga ittaw ta yi na timpo. ");
INSERT INTO cgc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ta timpo na mabot en kanen i, mga buat ta mga ittaw paryas man ta mga pabuat ya ta mga ittaw anay pa sa ta timpo Noe. ");
INSERT INTO cgc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta timpo Noe, ula ta iran na isip daw ino matabo ki danen daw gapadayon man gyapon danen ta iran na pang-adlaw-adlaw na buat. Gakaan danen ya, gainem daw gangasawa asta ta adlaw na gasakay en Noe naan ta arka. Pagsakay Noe, gabot anaw ya na galapaw ta bilog na kalibutan daw nalemmes tanan ya na ula kasakay naan ta arka. ");
INSERT INTO cgc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ta timpo na malik en Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, mga buat ta mga ittaw paryas man ta pabuat ta mga ittaw ta timpo Lot. Ganginaan danen ya, gainem, ganigusyo, gatanem daw gapatindeg ta balay. ");
INSERT INTO cgc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ta adlaw na gabakwit Lot ya alin ta banwa na Sodoma, tanan na mga ittaw na gaistar dya papauranan ta Dyos ta apoy daw ta galegleg na mga bato na asupri na alin ta kalangitan daw ubos danen patay. ");
INSERT INTO cgc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iling man tan ta adlaw na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan magpakita daw makala ta tanan daw kino gid kanen an. Magulpian mga ittaw an tak ula danen an gapaabot ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ta yon man na adlaw na mabot kanen i, daw matabuan na may ittaw na naan ta atep ta iran na balay, dapat na magbakwit dayon na dili en melled pa naan ta balay daw magkamang ta iya na mga pagkabetang. Iling man tan, daw matabuan na may ittaw na naan ta iya na uma, dapat na dili en muli. ");
INSERT INTO cgc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Demdemen nyo natabo ya ta sawa Lot. ");
INSERT INTO cgc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Daw kino gapalabi ta iya na kabui, mapatay man gyapon. Piro, bisan kino mag-alad ta iya na kabui tenged ki yaken, maangken din kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sugiran ta kyo na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, ta kilem ta iya na pag-abot daw matabuan na darwa gadulog na gatunuga, isya an kamangen daw isya an a, mabilin. ");
INSERT INTO cgc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Daw matabuan na darwa na bai gatabangay ta paggaling, isya an kamangen daw isya an a, mabilin. ");
INSERT INTO cgc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Iling man tan, darwa na ittaw na galuy-on naan ta uma, isya an kamangen daw isya an a, mabilin.” ");
INSERT INTO cgc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mga tinudluan Jesus gainsa ki kanen, “Ginuo, indi matabo paambal no an?” Gasabat kanen paagi ta ambalanen na beet ambalen mlaman gid daw indi. Ambal din, “Daw indi may patay, mlaman gid ta tanan tak naan dya galayog-layog mga uwak.” ");
INSERT INTO cgc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gaisturya Jesus i ta paanggid parti ta pagpangamuyo naan ta iya na mga tinudluan aged itudlo ki danen na kinanglan na pirmi danen an mangamuyo daw dili man mataka. ");
INSERT INTO cgc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ambal din, “Naan ta isya na banwa may uwis na ula adlek ta Dyos daw ula kanen gaisip ta kayaran ta duma na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Naan ta yo man na banwa may bai na balo na sigi balik-balik ki kanen na gambal, ‘Tagan a no ta ustisya ta ake na riklamo batok ta kuntra ko.’ ");
INSERT INTO cgc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ta una, ula paintindia ta uwis bai an, piro ta uryan gambal uwis i ta iya na kaugalingen, ‘Maskin ula a adlek ta Dyos daw ula a gaisip ta kayaran ta duma na mga ittaw ");
INSERT INTO cgc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","dapat iatag ko ki kanen pangayo din na ustisya aged dili a matakaan ta iya na pagbalik-balik tak pirmi a din paisturbo.’” ");
INSERT INTO cgc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ambal pa ta Ginuo naan ta iya na mga tinudluan, “Isipen nyo daw ino beet ambalen ta pabuat ta dili matareng na uwis. ");
INSERT INTO cgc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Daw uwis an na dili matareng gaatag ta ustisya, sigurado na mas pa Dyos an mag-atag ta ustisya naan ta iya na mga ittaw na ta adlaw daw kilem gangayo ta iya na tabang! Basi mag-isip kaw na lugay bag-o kanen an magtabang ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sugiran ta kyo na kanen an magtabang dayon ki danen! Piro, daw malik Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan, basi makita din an pila nang na mga ittaw na gaprusigir gid ta pagpangamuyo na may pagsalig naan ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gaisturya Jesus i ta paanggid naan ta mga ittaw na gapati na danen an matareng piro duma na mga ittaw dili matareng. ");
INSERT INTO cgc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yi paanggid na paisturya din: “Darwa na mama giling naan ta Timplo aged mangamuyo. Isya an Pariseo daw isya an a, manugsukot ta buis. ");
INSERT INTO cgc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pariseo an, gatindeg kanen an daw gapangamuyo parti ta iya na kaugalingen, ‘O Dyos, gapasalamat a ki kaon na dili a paryo ta duma na mga ittaw na manluko, madaya, gaintra ta bai daw dili a man paryo ta yon na manugsukot ta buis. ");
INSERT INTO cgc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gapwasa a darwa bisis ta isya na duminggo daw gaalad a ta isya ta sampulo na parti ta tanan na kwarta na nabaton ko.’ ");
INSERT INTO cgc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Piro, manugsukot an a, gatindeg kanen naan ta madyo daw gapangamuyo na ula gaangad naan ta langit tak gayya kanen an tenged ta iya na mga sala. Papukpok din iya na dag-anan tak ganelsel gid kanen an ta iya na mga sala. Ambal din, ‘O Dyos, maluoy ka ki yaken tak tama a gid sala!’ ");
INSERT INTO cgc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Sugiran ta kyo na Pariseo an ula napatawad ta Dyos, piro manugsukot ya ta buis guli na pabilang na ula sala tak napatawad ta Dyos tenged daw kino magpadatas ta iya na kaugalingen, paebesen kanen an ta Dyos. Daw kino magpaebes ta iya na kaugalingen, padatasen kanen an ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","May mga ittaw na gaprani ki Jesus na gadala ta iran na mga bata na derse para itungtong din iya an na lima naan ta mga bata daw bindisyunan danen an. Pagkita ta iya na mga tinudluan, pasaway danen mga gadala ya. ");
INSERT INTO cgc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piro, paumaw Jesus mga bata ya na marani ki kanen. Ambal din naan ta iya na mga tinudluan, “Bay-an nyo nang mga bata an na magprani ki yaken. Dili nyo danen an pegengan tak mga paryo ki danen sakep ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sakep gid ta pagdumala ta Dyos mga ittaw na paryo ki danen daw sugiran ta kyo na bisan kino na magpasakep ta pagdumala ta Dyos na dili kanen magparyo ta bata na gasalig na ula gadua-dua, impusibli na kanen an makalabet naan ta mga ittaw na padumalaan ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Isya na ittaw na may datas na katengdanan gambal ki Jesus, “Mistro, nlaman ko na matareng ka. Ino dapat ko na buaten aged maangken kabui na ula katapusan?” ");
INSERT INTO cgc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sabat din, “Man-o tak paumaw a no na matareng? Ula duma na matareng daw dili, Dyos nang. ");
INSERT INTO cgc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nlaman no mga sugo ta Dyos na, ‘Dili ka mag-intra ta bai, dili ka magpatay, dili ka manakaw, dili ka magtistigo ta dili matuod daw tauron no imo na amay daw inay.’” ");
INSERT INTO cgc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sabat ta ittaw, “Tanan na sugo na pasambit no patuman ko alin na sise a pa.” ");
INSERT INTO cgc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagmati Jesus ta sabat ta ittaw, ambal din, “May isya pa na ula no nabuat. Bligya no tanan no na pagkabetang daw bayad an iatag no ta mga imol tak sigurado na maangken no dayad na bales na patagana ta Dyos naan ta langit. Daw matuman no en ambal ko, malik ka daw muyog ki yaken aged isya ka man na tinudluan ko.” ");
INSERT INTO cgc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pagmati ta ittaw ta ambal ya Jesus, nasebean kanen an tak kanen an sikad gid manggaranen. ");
INSERT INTO cgc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pagkita Jesus na nasebean ittaw ya, ambal din, “Mga ittaw na manggaranen bellay gid magpasakep naan ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas dali pa ta bakod na ayep na kamilyo meddep naan ta lungag ta dagem kaysa ittaw na manggaranen magpasakep naan ta pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ambal ta mga ittaw na kamati ta ambal ya Jesus, “Ta, daw iling tan na bellay para ta mga manggaranen, impusibli na may maluwas alin ta silot ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sabat Jesus, “Impusibli ta ittaw, piro dili impusibli ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ambal Pedro “Ta, kami a? Padilian nay tanan nay na pagkabetang aged muyog ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ambal Jesus ki danen, “Matuod na padilian nyo tanan. Piro, gambal a ki kyo na may dayad na bales na alin ta Dyos para ta bisan kino na padilian din iya na balay, sawa, mga utod, mga ginikanan daw mga bata tenged sakep kanen an ta pagdumala ta Dyos ");
INSERT INTO cgc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tak naan ta yi na timpo tagan kanen an ta Dyos ta subla pa kaysa ta mga padilian din ya daw naan ta timpo na mabot may kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Papadyo Jesus dusi an na apustulis alin ta duma na mga ittaw na gakuyog man aged isturyaen din na danen nang. Ambal din ki danen, “Matian nyo gid ambalen ko i ki kyo. Gapanaw ki na munta en naan ta Jerusalem daw naan dya matuman tanan na nasulat ta mga prupita anay pa sa parti ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. ");
INSERT INTO cgc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kanen i intriga naan ta mga dili-Judio daw pagayyaan, insultuan, ileban, ");
INSERT INTO cgc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","latiguon daw patayen. Piro, ta pangallo na adlaw, kanen mabannaw.” ");
INSERT INTO cgc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ula naintindii ta mga apustulis ambal din ya. Ula gid danen nlami daw ino beet din ambalen tak nalikem ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na dani nang en danen i Jesus naan ta syudad na Jerico, may mama na bulag na gamungko naan ta kilid dalan na iran na maagian daw gapalimos. ");
INSERT INTO cgc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na namatian ta bulag sinaba ya ta tama na mga ittaw na galambay, gainsa kanen an ki danen daw ino pasinabaan an danen. ");
INSERT INTO cgc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pasugiran danen kanen an na galambay Jesus na taga-Nazaret. ");
INSERT INTO cgc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Gasinggit kanen an, “Jesus! Apo Ari David! Maluoy ka ki yaken!” ");
INSERT INTO cgc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pasaway kanen ta mga ittaw na gauna ki danen Jesus na dili kanen an magsagbak. Piro, gasinggit pa gid kanen an ta tudo, “Apo Ari David! Maluoy ka ki yaken!” ");
INSERT INTO cgc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pagmati Jesus, gateneng kanen i daw gasugo na dleen bulag an ki kanen. Pagprani ta bulag, ambal din, ");
INSERT INTO cgc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Sugiran a no daw ino liag no na buaten ko para ki kaon.” Ambal ta bulag, “Ginuo, liag ko na makakita!” ");
INSERT INTO cgc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ambal Jesus, “Makakita ka en! Nayad ka en tenged ta imo na pagsalig ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dayon kakita kanen an daw gakuyog ki Jesus daw gadayaw kanen ta Dyos. Tanan na mga ittaw na kakita ta pagpaayad Jesus ki kanen gadayaw man ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pagtapos Jesus ta pagpaayad ta bulag ya, gapadayon kanen ta iya na pagpanaw daw naagian din syudad na Jerico. ");
INSERT INTO cgc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Naan dya may mama na ngaran din Zaqueo. Kanen i pangulo ta mga manugsukot ta buis naan ta syudad ya daw manggaranen kanen i. ");
INSERT INTO cgc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Liag din gid na makita daw makala daw kino Jesus an, piro dili din makita tenged tama na mga ittaw gatumpok naan ki Jesus daw putot Zaqueo i. ");
INSERT INTO cgc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tenged liag din gid na makita Jesus an, gadlagan kanen i na muna ta mga ittaw daw gakatay naan ta kaoy na sikumuro aged makita din Jesus tak naan dya mag-agi. ");
INSERT INTO cgc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na gabot Jesus ta kaoy na naan dya Zaqueo, gaangad kanen daw gambal, “Zaqueo, manaog ka dyan! Giran no tak anduni plano ko na naan a magdayon ta imo na balay.” ");
INSERT INTO cgc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pag-ambal Jesus, gadali-dali gid Zaqueo na manaog daw nalipay gid na batunon din Jesus i naan ta iya na balay. ");
INSERT INTO cgc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pagmati ta mga ittaw na Jesus i magdayon naan ta balay Zaqueo, gagumod danen ya tanan, “Aree! Man-o tak naan pa kanen an magdayon ta balay ta makasasala na ittaw?” ");
INSERT INTO cgc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na naan danen Jesus ta balay Zaqueo, gatindeg Zaqueo i daw mambal ki kanen, “Ginuo, iatag ko ta mga imol tenga ta ake na mga pagkabetang. Daw kino nasukot ko kan-o ta subla, bayaran ko kanen an ta appat pilo.” ");
INSERT INTO cgc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ambal Jesus ki Zaqueo, “Anduni kaon daw imo na pamilya naluwas en alin ta silot ta inyo na mga sala tak gatuo ka man paryas Amay Abraham. ");
INSERT INTO cgc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yi tuyo na giling di Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan aged ngitaen daw luwasen mga nakasala para dili danen maageman ula katapusan na silot ta Dyos tenged ta iran na mga sala.” ");
INSERT INTO cgc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","May duma na mga ittaw naan ta balay Zaqueo na gamati ta ambal Jesus ki Zaqueo. Pagtapos Jesus ta pag-ambal ki Zaqueo, danen an paisturyaan din ta isya na paanggid tak nlaman danen na dani nang en Jesus ta Jerusalem na iya na puntaan. Naan ta isip danen na daw mabot kanen dya, mag-umpisa dayon papaabot danen na pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yi isturya din na paanggid, “May mama na alin ta kala na pamilya na miling naan ta madyo na banwa aged naan dya tagan ta katengdanan na mag-ari para ta pag-uli din, ari en kanen an. ");
INSERT INTO cgc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Piro bag-o kanen malin, paumaw din sampulo ta mga suguon din daw kada isya ki danen patagan din ta isya na sinsilyo na blawan. Ambal din, ‘Gamiten nyo nyan ta nigusyo asta malik a di.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Piro, pagmati ta mga kasimanwa din na kanen mag-ari ki danen, dili miag danen na kanen mag-ari ki danen tak gademet danen an ki kanen. Pag-alin din ta iran na banwa na miling ta madyo na lugar, gapadala danen an ta pila na mga ittaw na miling man naan ta pailingan din aged ittaw ya na mag-atag ki kanen ta katengdanan ambalan danen na iling ti, ‘Dili kay miag na kanen an mag-ari ki kami.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Piro, maskin dili miag mga kasimanwa din, paimo man gyapon kanen an na ari. “Pag-uli din na kanen an ari en, paumaw din mga suguon din an na paatagan ta kwarta aged mlaman din daw pila tubo ta iran na panigusyo. ");
INSERT INTO cgc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Gabot una ya na suguon daw gambal, ‘Sir, sinsilyo na blawan na paatag no ki yaken may tubo na sampulo.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Gambal ari i ki kanen, ‘Nyan dayad! Miad ka gid man na suguon. Tenged masaligan ka parti ta sise na kantidad, tagan ta kaw ta katengdanan ta pagdumala ta sampulo na banwa.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gabot pangarwa ya na suguon daw gambal, ‘Sir, sinsilyo na blawan na paatag no ki yaken may tubo na limma.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Gambal ari i ki kanen, ‘Tagan ta kaw ta katengdanan ta pagdumala ta limma na banwa.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Isya pa na suguon gabot daw gambal ta ari, ‘Yi sinsilyo na blawan na paatag no ki yaken. Paputos ko daw patago. ");
INSERT INTO cgc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nadlek a ki kaon tak pwirti ka gid na amo. Gakamang ka ta dili imo na tinago daw gapangani ta dili imo na sinabwag.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Gambal ari i ki kanen, ‘Malain ka gid na suguon! Gamiten ko ambal no an kuntra man ki kaon. Tenged nlaman no na pwirti a gid na amo daw gakamang a ta dili ake na tinago daw gapangani ta dili ake na sinabwag, ");
INSERT INTO cgc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","man-o tak ula no papaeles kwarta ko an naan ta nigusyanti na gapautang na gapatubo ta kwarta? Di, ta pagbalik ko, dili nang puon makamang ko, may tubo pa inta!’ ");
INSERT INTO cgc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Gambal ari i naan ta duma na mga suguon na naan dya gatindeg, ‘Kamangen nyo naan ki kanen sinsilyo an daw iatag nyo ta ake na suguon na may sampulo na tubo.’ ");
INSERT INTO cgc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sabat danen ta ari ya, ‘Sir, may sinsilyo en kanen na sampulo!’ ");
INSERT INTO cgc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ambal ta ari, ‘Sugiran ta kyo, mga ittaw na masaligan parti ta mga paatag ki danen, tagan pa. Piro, mga ittaw na dili masaligan, maskin sise na naan ki danen kamangen pa. ");
INSERT INTO cgc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Anduni, mga ittaw an na dili miag na yaken mag-ari ki danen, dleen nyo di daw patayen naan ta tubangan ko!’” ");
INSERT INTO cgc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagtapos ta isturya Jesus ta paanggid, gapadayon kanen i ta pag-iling naan ta Jerusalem daw naan kanen i ta una ta mga gakuyog ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na Jesus i daw mga gakuyog ki kanen dani nang en naan ta mga baryo na Betfage daw Betania na naan ta bukid na paumaw Bukid Olibo, pasugo din darwa ta iya na mga tinudluan ");
INSERT INTO cgc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na ambal din, “Miling kaw ta baryo na naan ta unaan. Pagselled nyo dya, makita nyo isya na asno na bata pa na ula pa gid nasakayi na gaigot dya. Badbaren nyo igot an daw dleen nyo di asno an. ");
INSERT INTO cgc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Daw may ittaw na mag-insa ki kyo, ‘Man-o tak pabadbad nyo nyan?’ sabaten nyo, ‘Kinanglan ta Ginuo asno i.’” ");
INSERT INTO cgc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pagtapos ta ambal Jesus, gapanaw darwa na tinudluan na pasugo din daw natabo ki danen paryo ta paambal din. ");
INSERT INTO cgc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na pabadbad nang pa danen igot ta asno, mga tag-iya ta asno gainsa ki danen, “Man-o tak pabadbad nyo igot an ta asno?” ");
INSERT INTO cgc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sabat danen, “Kinanglan ta Ginuo asno i.” ");
INSERT INTO cgc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Padala danen asno an ki Jesus daw paapinan danen ta iran na mga bayo tudtod an ta asno daw papasakay Jesus i. ");
INSERT INTO cgc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na kanen i gapadayon munta ta Jerusalem na gasakay, galadlad mga ittaw an ta iran na mga bayo naan ta dalan na agian din aged ipakita iran na pagtaod ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na kalambot kanen ta parti ta dalan na umpisa en paebes naan ta Bukid Olibo, tanan na tinudluan din na gakuyog gaumpisa en na magkalipay. Gadayaw danen ta Dyos na biskeg iran na kagi parti ta tanan na katingalaan na nakita danen. ");
INSERT INTO cgc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ambal danen, “Dayawen ta gabot an na ari na papadala ta Ginuo Dyos! May katawwayan ki naan ta Dyos! Dayawen ta Dyos an!” ");
INSERT INTO cgc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tenged ta pagdayaw ta mga tinudluan Jesus, may mga Pariseo dya na gariklamo ki kanen, “Mistro! Sawayen no mga tinudluan no an.” ");
INSERT INTO cgc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sabat Jesus ki danen, “Sugiran ta kyo na daw dili danen magdayaw ki yaken, mga bato an unti magdayaw ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tenged Jesus dani en ta Jerusalem daw nabantaw din syudad an, tudo agal din tenged ta mga ittaw dya. ");
INSERT INTO cgc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ambal din, “Inta nlaman nyo en daw ino paagi na maageman nyo matuod na katawwayan naan ta Dyos. Piro, uryan en. Anduni palikem en ta Dyos ki kyo tak ula nyo pabaton ittaw na padala din ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kaluluoy kaw gid tak mabot timpo na sulungon kaw ta mga kuntra nyo. Libutan kaw danen daw bantayan ta miad na ula gid paagi na kabwi kaw. ");
INSERT INTO cgc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kyo tanan na gistar dyan patayen. Inyo na syudad gubbaen danen na ula gid bisan isya nang na bato ta padir daw balay nyo mabilin na gasampaw pa naan ta duma na bato. Masamad gid inyo na syudad daw mapatay kaw tak ula nyo paintindia upurtunidad na paatag ta Dyos na luwasen kaw din.” ");
INSERT INTO cgc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na gabot Jesus i naan ta Jerusalem, gaselled kanen ta sular ta Timplo daw papagwa din mga ittaw dya na gabligya ta mga pang-alad para ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Pambalan din danen an, “Naan ta sinulat na pulong ta Dyos, kanen an gambal, ‘Ake na balay, balay pangamuyuan.’” Ambal pa Jesus, “Piro pabuat nyo iya na balay na ‘taguan ta mga manakaw’!” ");
INSERT INTO cgc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Umpisa ta yon man na timpo, adlaw-adlaw gatudlo Jesus i naan ta Timplo. Mga manugdumala na mga pari, mga manugtudlo ta Mga Sinulat Moises daw mga Judio na may datas na katengdanan gangita ta paagi na ipapatay kanen i. ");
INSERT INTO cgc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Piro, ula danen an kakita ta paagi na ipapatay kanen i tak pirmi naan ki kanen tama na mga ittaw na nawili gid ta mati ta iya na tudlo. ");
INSERT INTO cgc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na Jesus i naan ta Jerusalem, gatudlo kanen ta mga ittaw naan ta Timplo daw gasugid ki danen ta miad na balita parti ta pagdumala ta Dyos. Na gatudlo kanen, may mga manugdumala na mga pari, mga manugtudlo ta Mga Sinulat Moises daw duma pa na mga gadumala ta mga Judio na gaprani ki kanen ");
INSERT INTO cgc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","daw gambal, “Sugiran kay no daw indi alin imo na uturidad ta mga pabuat no naan ta Timplo i. Kino gaatag ki kaon ta imo na uturidad?” ");
INSERT INTO cgc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Sabat Jesus ki danen, “Minsa a anay ki kyo. Juan ya na manugbautismo, indi alin iya na uturidad ta pagbautismo din ta mga ittaw? Ino ta inyo na isip, naan alin ta Dyos, naan alin ta ittaw? Sabaten a nyo.” ");
INSERT INTO cgc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gaisturyaay danen an daw ino iran na isabat. Ambal danen, “Daw sabaten ta ‘naan alin ta Dyos,’ insaan ki din, ‘Man-o tak ula kaw gapati ki Juan?’ ");
INSERT INTO cgc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piro, daw sabaten ta ‘naan alin ta ittaw,’ timbagen ki ta mga ittaw na naan di asta na mapatay ki tak gapati gid danen an na Juan ya isya na prupita na alin ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tenged ula danen may isabat ki Jesus, ambal danen ki kanen, “Ula nay nlami daw indi alin iya na uturidad.” ");
INSERT INTO cgc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ambal din ki danen, “Dili ko man isugid ki kyo daw indi alin ake na uturidad ta mga pabuat ko naan ta Timplo i.” ");
INSERT INTO cgc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pagtapos ta ambal Jesus ta mga manugdumala ya, gaisturya kanen i ta paanggid naan ta mga ittaw dya. Ambal din, “May mama na gatanem ta ubas naan ta iya na uma daw papaagsa din. Giling kanen an naan ta madyo na lugar daw naan dya kanen an galugay. ");
INSERT INTO cgc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na timpo en ta pagpupo ta mga ubas, papailing din isya ta mga suguon din naan ta mga gaagsa ta ubasan aged kamangen parti din ya ta tubbas ta iya na ubasan. Pag-abot dya ta suguon, pabugbog danen kanen ya daw papauli na ula dala. ");
INSERT INTO cgc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Papailing man ta tag-iya isya pa na suguon, piro pabugbog danen suguon ya daw pagayyaan daw papauli man na ula dala. ");
INSERT INTO cgc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Papailing ta tag-iya isya pa gid na suguon na pangallo en daw yon man gyapon natabo. Pabugbog gid ta miad suguon ya daw payudyod na pagwa naan ta ubasan. ");
INSERT INTO cgc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ta uryan, tag-iya ta ubasan gambal ta iya na kaugalingen, ‘Ino buaten ko i? A, miad pa taan daw palangga ko i na bata na mama pailingen ko dya. Basi kanen i tratuon danen ta miad!’ ");
INSERT INTO cgc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Piro, na nakita ta mga gaagsa bata ya ta tag-iya, gaisturyaay danen an, ‘Yon manubli ta uma na i. Sigi, patayen ta kanen an aged ate nang en panublien din an.’ ");
INSERT INTO cgc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pagtapos danen ta iran na pag-isturyaay, pagabling danen kanen an, payudyod pagwa naan ta ubasan daw papatay.” Pagtapos Jesus ta isturya, ambal din ta mga ittaw dya, “Ta, ino buaten ta tag-iya ya naan ta mga gaagsa ta iya na ubasan? ");
INSERT INTO cgc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Simpri ilingan din danen an daw patayen daw paagsa din iya na ubasan naan ta duma na mga ittaw.” Pagmati ta mga ittaw dya ta paanggid na isturya Jesus, gambal danen an, “Padyo nang inta na matabo iling an tan!” ");
INSERT INTO cgc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Patan-aw din gid danen an daw gainsa ki danen, “Daw ta isip nyo na dapat na dili matabo iling an tan, ino beet ambalen ta ambal naan ta sinulat na pulong ta Dyos na iling ti: ‘Bato an na ta isip ta mga manug-ubra ta balay dili magamit, yon gid pamag-ang na bato.’” ");
INSERT INTO cgc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ambal man Jesus, “Kada ittaw na karagpa naan ta pamag-ang ya na bato, danen an mawasak. Daw kino na maulugan ta pamag-ang ya na bato, kanen an malegsek.” ");
INSERT INTO cgc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises, dakepen danen dayon inta Jesus i tak naintindian danen na danen paisturya din naan ta iya na paanggid. Piro, ula danen dakepa tak adlek danen an na daw dakepen danen kanen i, basi mga ittaw dya magbuat ta malain kuntra ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises gabantay ta upurtunidad na ipadakep danen Jesus i. Pasugo danen pila na mga ittaw na manilag daw dakep-dakepen kanen i paagi ta mga insa aged maakusaran daw intriga naan ta Romanen na gubirnador na gadumala ta iran na prubinsya. Mga gapanilag ya gapakuno-kuno nang na iran na pag-insa terek ta iran na nakem. ");
INSERT INTO cgc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Gambal danen ki Jesus, “Mistro, nlaman nay na ambal no an daw mga patudlo ubos igo. Ula ka may papaburan. Gatudlo ka ta kamatuuran parti ta kabebet-en ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sugiran kay no tuo. Ta imo na isip, naan ta Mga Sinulat Moises patugutan ki na magbayad ta buis naan ta pangulo ta Roma?” ");
INSERT INTO cgc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nlaman Jesus na malain iran na tuyo daw ambal din, ");
INSERT INTO cgc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Dawatan a nyo ta isya na sinsilyo na paryo ta pabayad nyo ta buis.” Pagbaton din, ambal din, “Iya ti na sura daw ngaran naan ta yi na sinsilyo?” Sabat danen, “Iya ta pangulo ta Roma.” ");
INSERT INTO cgc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ambal din, “Ta, daw ino iya ta pangulo ta Roma, iatag nyo ki kanen. Daw ino iya ta Dyos, iatag nyo ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tenged dayad sabat Jesus, ula natuman iran na liag na madakep kanen ta iya na ambal naan ta atubangan ta mga ittaw. Ula danen gasasaba tak gatingala gid danen an ta iya na sabat. ");
INSERT INTO cgc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","May mga Saduseo na giling ki Jesus aged dakep-dakepen kanen an paagi ta insa parti ta pagbannaw tak ula danen an gapati na mabannaw mga patay an. ");
INSERT INTO cgc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ambal danen ki kanen, “Mistro, naan ta Mga Sinulat Moises may sunuron ki na daw mama na may sawa mapatay na ula kanen bata ta iya na sawa, dapat paus-os katengdanan din naan ta iya na mangngod aged makabata para ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Alimbawa: may pitto na mag-utod na mama. Kamagulangan ya nangasawa daw napatay na ula kanen an bata. ");
INSERT INTO cgc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pagsawa ta balo na bai paus-os naan ta pangarwa na utod. ");
INSERT INTO cgc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Napatay man pangarwa na utod daw paus-os isab naan ta pangallo na utod. Yon man gyapon natabo ta duma na mga utod na tanan danen napatay na ula bata. ");
INSERT INTO cgc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ta uryan, bai ya napatay man. ");
INSERT INTO cgc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ta, daw mabot timpo na mabannaw mga patay, kino ki danen na mag-utod matuod na sawa ta bai ya tak danen na pitto ubos kasawa ki kanen?” ");
INSERT INTO cgc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sabat Jesus, “Ta yi na kabui gangasawa mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piro, naan ta liyo na kabui ula gangasawa mga ittaw na bilangen ta Dyos na labet ta mga bannawen din na magduma ki kanen naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Naan dya ula en danen an kamatayen tak danen an paryo ta mga angil. Danen an mga bata ta Dyos na pabannaw din. ");
INSERT INTO cgc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","May pamatuod naan ta sinulat Moises na mabannaw mga patay. Naan ta isturya parti ta tanem na galegleg, ambal ta Ginuo Dyos parti ta iya na kaugalingen na kanen an Dyos danen Abraham, Isaac daw Jacob. ");
INSERT INTO cgc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iling tan na ambal ta Dyos pamatuod na mga ittaw na napatay mabannaw tak dili kanen an Dyos ta mga patay. Dyos kanen an ta mga bui tak ta panan-aw din bui tanan an na mga ittaw na pabilang din na dapat na danen mag-angken ta kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mga manugtudlo ta Mga Sinulat Moises na naan dya gambal ki Jesus, “Mistro, dayad gid sabat no an.” ");
INSERT INTO cgc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Iling sa ambal danen tak ula may nangiseg na mag-insa pa ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Gambal Jesus i naan ta mga gapamati ki kanen, “Man-o tak gambal mga manugtudlo na Pinili Ta Dyos Na Mag-ari linai Ari David ");
INSERT INTO cgc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","na Ari David mismo gasulat naan ta Mga Salmo ta iling ti, ‘Ginuo Dyos gambal ta ake na Ginuo, “Mungko ka di naan dapit ta ake i na tuo ");
INSERT INTO cgc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta na mapirdi ko imo na mga kuntra na danen an paryo ta tungtungan ta imo na mga batiis.”’ ” ");
INSERT INTO cgc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ambal man Jesus, “Daw iling tan ambal Ari David parti ta Pinili Ta Dyos Na Mag-ari na paumaw din na iya na Ginuo, di' ba Pinili Ta Dyos Na Mag-ari dili nang basta na linai Ari David?” ");
INSERT INTO cgc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Gambal Jesus i naan ta iya na mga tinudluan daw duma na mga ittaw na naan dya na gapamati man, ");
INSERT INTO cgc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mag-amblig na dili kaw magparyo ta mga manugtudlo ta Mga Sinulat Moises. Daw mamasyar danen an, gasuot danen ta langkaw na bayo na maalen aged ipakita na datas iran na katengdanan. Daw naan danen an ta lugar na naan dya tama na mga ittaw, liag gid danen na mga ittaw mag-atag ta taod ki danen. Daw naan danen an ta mga balay tipunan, liag gid danen na naan danen ta pungkuan na para ta impurtanti na mga ittaw. Iling man tan daw mandegek danen an. ");
INSERT INTO cgc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sikad man danen an manluko ta mga balo na bai daw paubos danen pangabuian an ta mga balo. Gapakuno-kuno na riliyuso danen an paagi ta lawig na pangamuyo naan ta tama na mga ittaw aged dili mlaman na mga pabuat an danen malain. Tenged iling tan mga buat danen, maageman danen segeng na silot ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na gatudlo Jesus i naan ta Timplo, gatan-aw kanen ta palibot daw nakita din na paulog ta mga manggaranen iran na alad na kwarta naan ta mga ugsakan ta alad. ");
INSERT INTO cgc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nakita din man na paulog ta balo na bai na pubri darwa na sinsilyo na derse na may pinakatise na balor. ");
INSERT INTO cgc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pagkita din ta paatag ta bai, ambal din, “Daw lagen, sise gid paulog an ta pubri na balo. Piro, sugiran ta kyo na mas bakod pa naatag din kaysa ta naatag ta duma na mga ittaw ");
INSERT INTO cgc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","tak paalad an danen subla nang ta iran na mga manggad na dili en danen kinanglan. Piro, maskin ula gid ta ula balo an, paalad din tanan din na pangabuian.” ");
INSERT INTO cgc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na gatudlo pa Jesus i naan ta Timplo, may mga ittaw na gaisturya ki kanen na sikad dayad Timplo an tak buat ta dayad gid na mga bato daw dayad na mga dikurasyon na paalad ta mga ittaw para ta Dyos. Pagmati Jesus ta iran na pagdayaw, ambal din, ");
INSERT INTO cgc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“May adlaw na mabot na tanan na nakita nyo di anduni magubba gid daw tanan na bato ta Timplo i mawasak na ula gid maskin isya nang na bato na gasampaw pa naan ta duma na bato.” ");
INSERT INTO cgc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gainsa danen an ki Jesus, “Mistro, kan-o matabo nyan na paambal no? Ino sinyalis na pamatuod na mabot en timpo na matuman ambal no?” ");
INSERT INTO cgc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sabat Jesus, “Mag-andam kaw gid aged dili kaw maluko tak tama na mga ittaw miling ki kyo na akuon danen ake na ngaran ta iran na kaugalingen daw ambalen danen, ‘Yaken i Pinili Ta Dyos Na Mag-ari!’ Ambalen man danen, ‘Abot en timpo i na Pinili Ta Dyos Na Mag-ari mag-umpisa ta iya na pagdumala!’ Piro, dili kaw magpati ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Daw kabalita kaw ta mga gira daw gamo, dili kaw mataranta tak naan ta plano ta Dyos na matabo anay iling an tan. Piro, dili beet ambalen na mabot dayon katapusan ta yi na timpo.” ");
INSERT INTO cgc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ambal din pa, “Mga nasyon maggiraay daw mga kaarian kuntra ta kaarian. ");
INSERT INTO cgc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Naan ta lain-lain na mga lugar may biskeg na mga linog, letem, mga pisti, makaadlek na mga matabo daw bakod na katingalaan naan ta kalangitan. ");
INSERT INTO cgc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Piro, bag-o matabo iling an tan, may mga ittaw na magdakep ki kyo daw pangabuton kaw gid. Intriga kaw danen naan ta mga pangulo ta mga balay tipunan aged usisaen. Prisuon kaw man danen. Dleen man naan ta atubangan ta mga ari daw ta mga gubirnador aged usisaen. Iling tan buaten danen na malain ki kyo tenged sakep kaw ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Daw usisaen kaw, yon uras na may upurtunidad kaw na magpamatuod parti ta inyo na pagpati ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gani, dapat ibetang nyo anduni naan ta inyo na isip na dili magpalibeg daw ino isabat nyo ");
INSERT INTO cgc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tak ta uras na usisaen kaw, yaken magtabang ki kyo daw ino igo na ambalen nyo aged inyo na mga kuntra dili en kasabat pa ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Duma ki kyo trayduran ta inyo na mga ginikanan, mga utod, mga parinti daw mga arey. Duma man ki kyo ipapatay danen. ");
INSERT INTO cgc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Demetan kaw ta tanan tenged sakep kaw ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piro, dili kaw madlek tak Dyos mismo mag-amblig ki kyo na maskin isya na naet ta inyo na buok dili marwad. ");
INSERT INTO cgc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Daw magpadayon kaw ta pagpati ki yaken maskin maagian nyo na papangabot kaw ta mga gakuntra ki kyo, inyo na kabui maluwas. ");
INSERT INTO cgc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Daw makita nyo na palibutan Jerusalem i ta tama na sundalo na gasulong, mlaman nyo na dili gid en maglugay masamad bilog na i na syudad. ");
INSERT INTO cgc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ta timpo na palibutan Jerusalem ta mga kuntra, mga ittaw an na gaistar naan ta prubinsya Judea, dapat na magbakwit naan ta mga bukid daw mga ittaw an na gaistar naan ta selled ta Jerusalem dapat na malin. Mga ittaw an na gaistar naan ta gwa ta Jerusalem dapat na dili en melled. ");
INSERT INTO cgc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Daw masamad Jerusalem i, mlaman nyo na abot en timpo na matuman tanan na paandam na naan ta sinulat na pulong ta Dyos parti ta pagsilot ta Dyos ta mga linai Israel. ");
INSERT INTO cgc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ta yon man na timpo, kaluluoy gid mga bai na gabagnes daw gapasuso tak mabellayan danen ta pagbakwit. Mga ittaw ta yi na nasyon, maageman danen sikad kuli na pangabui daw segeng na silot ta Dyos tenged ta iya na kagilek ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mga ittaw mapatay paagi ta gira, daw duma ya mabiag daw dleen naan ta duma na mga nasyon. Mga ittaw na sakep ta Jerusalem pirdien daw lupigen ta mga dili-Judio asta ta katapusan ta timpo na tugutan ta Dyos na mga dili-Judio magdumala ta Jerusalem i.” ");
INSERT INTO cgc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ambal pa gid Jesus parti ta mga adlaw na mabot, “May makita na mga sinyalis naan ta adlaw, bulan daw mga bituon. Mga ittaw naan ta kalibutan i mataranta daw maguluan daw ino beet ambalen ta sikad na pag-ugpaas ta mga baled ta dagat. ");
INSERT INTO cgc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kamangan danen an ta ginawa tenged ta iran na kaadlek. Makulbaan gid danen parti ta mga matabo pa na malain naan ta bilog na kalibutan tak tanan na naan ta kalangitan manlatak na paryo ta payegyeg. ");
INSERT INTO cgc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dayon, makita danen Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. Mabot kanen na naan kanen ta panganod na bakod gid iya na gaem daw sikad silaw na pawa ta Dyos naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Daw mag-umpisa en malain na mga matabo naan ta kalangitan, biskegen nyo inyo an na nakem daw magkalipay kaw tak beet ambalen na malibri kaw en alin ta kalainan ta yi na timpo.” ");
INSERT INTO cgc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Gaisturya pa Jesus i ta paanggid na iling ti: “Lagen nyo kaoy na igos daw tanan man na kaoy. ");
INSERT INTO cgc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Daw makita nyo na gasalingsing en, mlaman nyo na mabot en tagtanem. ");
INSERT INTO cgc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yon man, daw makita nyo na gaumpisa en matabo mga pasugid ko ki kyo, sigurado gid na mlaman nyo na abot en timpo ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sugiran ta kyo na tanan ya na mga pasugid ko ki kyo matabo na ula pa napatay tanan na mga ittaw ta yi na timpo. ");
INSERT INTO cgc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maski marwad pa kalangitan an daw kalibutan, ake i na mga ambal magpadayon asta ta ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Gambal pa Jesus i, “Mag-amblig kaw na dili kaw mawili ta mga kasadyaan, pag-inem-inem daw paglabi nang ta inyo na pagpangabui tak Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan gulpi mabot ta timpo na ula nyo paabuta. ");
INSERT INTO cgc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Daw iling tan buaten nyo, paryo kaw ta ayep na gulpi nang nasied tenged maagian ta tanan na mga ittaw naan ta kalibutan mga matabo ta iya na pag-abot. ");
INSERT INTO cgc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gani, kinanglan na pirmi kaw magbantay ta iya na pag-abot. Mangamuyo kaw na tabangan ta Dyos na daw maagian nyo mga kabellay na mabot, ula may maino ki kyo. Mangamuyo kaw man na daw Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mabot, mubang kaw ki kanen na may kalipay daw ula man adlek.” ");
INSERT INTO cgc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Adlaw-adlaw gatudlo Jesus i naan ta Timplo. Daw kilem, gagwa kanen i ta Jerusalem na miling naan ta Bukid Olibo daw naan dya gapalambay ta kilem. ");
INSERT INTO cgc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Daw sellem pa gid, gatipon naan ta Timplo tama na mga ittaw aged mamati ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na dali nang en adlaw ta Pista Ta Tinapay Na Ula Pampaabok na paumaw man na Pista Ta Paglibri Alin Ta Egipto, ");
INSERT INTO cgc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises gangita ta paagi na Jesus i ipapatay danen na ula may nalam tak nadlek danen an na basi maggamo mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ta yon man na timpo na Jesus paplanuan na ipapatay, Satanas an gaumpisa na pagaeman din Judas na paumaw man na Iscariote. Judas i isya ta dusi na apustulis. ");
INSERT INTO cgc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Na Judas i pagaeman en Satanas, giling kanen i naan ta mga manugdumala na mga pari daw ta mga gadumala ta mga gwardya ta Timplo. Gasugranen kanen ki danen daw ino paagi na matrayduran din daw intriga Jesus an naan ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nadayaran gid danen an ta iran na pagsugranen daw gatanyag ki kanen ta kwarta. ");
INSERT INTO cgc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Pabaton din iran an na tanyag daw umpisa ta yon man na uras, gangita en kanen ta tsansa na matrayduran din daw intriga Jesus an naan ki danen na dili mlaman ta tama na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gabot adlaw na mag-umpisa en Pista Ta Tinapay Na Ula Pampaabok. Yon man adlaw ta pag-iyaw ta mga karniro na bata pa na patagana para ta yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto. ");
INSERT INTO cgc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na uras en ta pagpriparar ta yapon, Pedro ya daw Juan pasugo Jesus, “Muna kaw en naan ta syudad daw ipriparar nyo ate na yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto.” ");
INSERT INTO cgc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gainsa danen ki Jesus, “Indi liag no na magpriparar kay?” ");
INSERT INTO cgc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sabat din ki danen, “Pag-abot nyo naan ta syudad, may masugat kaw na mama na gapas-an ta bandi na may waig. Sunuron nyo kanen ya daw indi kanen melled na balay. ");
INSERT INTO cgc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ambalen nyo naan ta tag-iya, ‘May insa Mistro ya ki kaon. Yi insa din, “Indi selled na dayunan para ta bisita na naan a dya maan kani duma ta mga tinudluan ko ta yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto?”’ ");
INSERT INTO cgc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tapos ta ambal nyo, ipakita ta tag-iya ki kyo wayang na selled naan ta apaw na tanan na mga kinanglan anen dya en. Naan kaw dya magpriparar ta ate na yapon.” ");
INSERT INTO cgc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pagtapos ta ambal Jesus, giling darwa na tinudluan naan ta syudad. Nakita danen selled ya na pasambit Jesus tak tanan na paambal din ki danen natuman. Na naan en danen ta selled ya, gapriparar danen ta yapon ta pagsilibrar ta pista. ");
INSERT INTO cgc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na uras en ta yapon, gakaan Jesus i duma ta mga apustulis. ");
INSERT INTO cgc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ambal din ki danen, “Bakod gid andem ko na maduma ko kyo yan ta pagkaan ta yi na yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto bag-o ko maagian kasakit an ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sugiran ta kyo na pagtapos ta ate na pagyapon anduni, dili aren maan ta yapon ta Pista Ta Paglibri asta ta timpo na magdumala en Dyos an ta tanan na mga ittaw daw matuman daw ino beet ambalen ta yapon na i.” ");
INSERT INTO cgc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gakamang Jesus i ta ineman na may ugsak na bino daw gapasalamat ta Dyos. Ambal din ta mga apustulis, “Batunon nyo ni daw minem kaw ti daw atag nyo man naan ta inyo na duma. ");
INSERT INTO cgc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sugiran ta kyo na pagtapos ta ate na pagyapon anduni, dili aren minem ta bino asta mabot adlaw na mag-umpisa pagdumala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Gakamang kanen i ta tinapay daw gapasalamat ta Dyos. Pabiak-biak din daw paatag ki danen na ambal din, “Yi ni ake na lawa na alad ko para ki kyo. Padayunon nyo pagbuat ta iling ti ta pagdemdem ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Iling man tan, pagtapos ta yapon, gaatag kanen i isab ki danen ta ineman na may ugsak na bino. Ambal din, “Yi na inemen bag-o na kasugtanan alin ta Dyos na palig-enen paagi ta kamatayen ko bilang alad para ki kyo na lengngessa ko matulo. ");
INSERT INTO cgc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ittaw na magtraydor ki yaken gakaan man duma ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Matuman gid en plano an ta Dyos na mapatay Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. Piro, ittaw an na magtraydor ki kanen may maageman na segeng na silot.” ");
INSERT INTO cgc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pagtapos ta ambal Jesus, gaumpisa mga apustulis an na mag-insaay daw kino taan ki danen magtraydor an. ");
INSERT INTO cgc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mga apustulis Jesus gaumpisa na magdiskasay daw kino ki danen kalaen na may pinakadatas na katengdanan. ");
INSERT INTO cgc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pagmati Jesus, ambal din, “Mga ari daw mga manugdumala ta mga dili-Judio gaabuso ta iran na pagdumala daw gusto man na kalaen na manugtabang ta iran na mga kasimanwa. ");
INSERT INTO cgc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piro kyo yan, dapat dili kaw iling tan. Daw kino ki kyo may pinakadatas na katengdanan dapat na magpaebes na bilangen din iya na kaugalingen na paryo kamangnguran nang ta tanan. Daw kino ki kyo na gapanguna dapat na bilangen din iya na kaugalingen na paryo suguon nang. ");
INSERT INTO cgc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Indi ta darwa na i may mas datas na katengdanan? Ittaw na gakaan, ittaw na gasirbi ki kanen? Di' ba ittaw na gakaan? Piro, ta ate na pagdumaay, yaken na Ginuo nyo isya na gasirbi ki kyo. ");
INSERT INTO cgc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kyo gaunong ki yaken na naageman ko mga kabellay. ");
INSERT INTO cgc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Paryas ta pabuat ta Amay ko na paatagan a din ta katengdanan na magdumala, anduni yaken gaatag ki kyo ta katengdanan na magdumala ");
INSERT INTO cgc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","aged maan kaw daw minem duma ki yaken naan ta ake na lamisa ta pag-umpisa ta ake na pagdumala. Mungko kaw man naan ta truno ta mga ari tak magdumala kaw ta mga ittaw na linai ta dusi na bata Israel.” ");
INSERT INTO cgc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ambal Jesus ki Simon Pedro, “A, Simon! Satanas an galisinsya na tugutan kanen na kyo tanan tagan ta pagtilaw tak liag din na marwad pagsalig nyo ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gapangamuyo a para ki kaon aged dili marwad pagsalig no. Daw magbalik nakem no an ki yaken, tabangan no imo an na mga duma aged magbiskeg iran na pagsalig.” ");
INSERT INTO cgc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ambal Simon ki Jesus, “Ginuo, mag-unong a gid ki kaon maskin prisuon a duma ki kaon daw patayen a pa.” ");
INSERT INTO cgc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ambal Jesus ki kanen, “Pedro, sugiran ta kaw na bag-o magtagaok manok kani, kambal ka en ta tallo bisis na dili a no kala.” ");
INSERT INTO cgc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pagtapos ta ambal Jesus ki Simon Pedro, gainsa kanen i ta tanan na apustulis, “Na pasugo ta kyo kan-o na miling naan ta mga ittaw na ula ta kyo papadalaa ta puyo, binagteng daw sandal na pangsili, di' ba ula kaw nakulangi ta maskin ino?” Sabat danen, “Ee, ula kay gid nakulangi!” ");
INSERT INTO cgc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ambal pa Jesus, “Iling tan pugya, piro anduni daw may puyo kaw daw binagteng man, dleen nyo. Daw ula kaw ispada, kinanglan magbligya kaw ta bayo nyo aged malit ta ispada ");
INSERT INTO cgc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","tak sugiran ta kyo na may ambal naan ta sinulat na pulong ta Dyos na kinanglan matuman paagi ta mga matabo ki yaken. Yi nasulat: ‘Kanen pabilang man na kriminal.’” Ambal man Jesus, “Tanan na nasulat parti ki yaken matuman en.” ");
INSERT INTO cgc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ambal danen, “Ginuo, may anen di darwa na ispada.” Sabat din, “Igo nyan en.” ");
INSERT INTO cgc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na tapos en yapon Jesus daw mga apustulis, gagwa kanen i ta Jerusalem daw miling naan ta Bukid Olibo tak iling tan pirmi pabuat din umpisa ta iya na pag-abot naan ta Jerusalem. Gakuyog ki kanen mga tinudluan din. ");
INSERT INTO cgc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pag-abot danen naan ta iran na pailingan, ambal Jesus ta iya na mga tinudluan, “Mangamuyo kaw aged dili kaw mapirdi ta pagtilaw na mabot ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Gapaadyo Jesus i ki danen ta distansya na paryo ta tumanan ta bato na patimbag. Na naan kanen dya, galuod kanen daw gapangamuyo. ");
INSERT INTO cgc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ambal din, “Amay, daw pagbeet no, ipamadyo no ki yaken segeng na kabellay na maagian ko. Piro, dili ake na liag matuman, imo na liag.” ");
INSERT INTO cgc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Isya na angil alin ta langit gapakita ki Jesus daw pabiskeg din nakem an Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gapangamuyo pa gid Jesus i ta miad tak gangasebe gid daw gatulo naan ta basak darko din na ulas na may lengngessa. ");
INSERT INTO cgc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagtapos din ta pagpangamuyo, gabalik kanen i naan ta iya na mga tinudluan daw naabutan din danen an na gatunuga tak naluyaan danen ta subla na kasebe. ");
INSERT INTO cgc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ambal din ki danen, “Man-o tak gatunuga kaw? Mangon kaw daw mangamuyo aged dili kaw mapirdi ta pagtilaw na mabot ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na gambal pa Jesus i naan ta mga apustulis na duma ki kanen, nali nang gabot tama na mga ittaw. Gapanguna ki danen Judas na isya ta dusi na apustulis. Gaprani kanen an ki Jesus aged mag-atag ta taod paagi ta arek. ");
INSERT INTO cgc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ambal Jesus ki kanen, “Judas, man-o tak arek an na tanda ta pagpalangga pagamit no para trayduran Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan?” ");
INSERT INTO cgc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na naintindian ta mga duma Jesus daw ino matabo ki kanen, gainsa danen ki kanen, “Ginuo, gusto no na tigbasen nay danen an?” ");
INSERT INTO cgc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na ula pa kasabat Jesus i, patigbas ta isya ta mga tinudluan din suguon ya ta pinakadatas na manugdumala ta mga pari daw nalantep gid tuo na talinga. ");
INSERT INTO cgc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Gasaway Jesus i, “Untatan nyo nyan en! Usto en!” Pag-ambal din, patandeg din puon ta talinga daw nayad. ");
INSERT INTO cgc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Duma man ta mga giling dya aged magdakep ki Jesus mga manugdumala na mga pari, mga gadumala ta mga gwardya ta Timplo daw mga gadumala ta mga Judio. Ambal Jesus ki danen, “Man-o, tulisan a na kinanglan gid na magdala kaw pa ta mga ispada daw mga baston? ");
INSERT INTO cgc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Adlaw-adlaw duma a ki kyo naan ta Timplo, piro ula a nyo dya dakepa. Inyo en na timpo anduni aged maimo plano nyo tak uras en na patugutan manugdumala an ta kalainan na kanen magbeet.” ");
INSERT INTO cgc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesus i padakep ta mga manugdumala daw padala naan ta istaran ta pinakadatas na manugdumala ta mga pari. Gasunod Pedro i ki danen, piro madyo iya na antad. ");
INSERT INTO cgc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pag-abot danen, gamaket danen an ta apoy naan ta tengnga ta sular daw gapungko danen naan ta palibot na gapadangga. Gapungko man dya Pedro na duma ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na gamungko kanen dya daw napawaan ta apoy, nadiparaan kanen i ta isya na suguon na bai. Patan-aw kanen i ta miad ta bai daw gambal bai an naan ta mga ittaw dya, “Nyan isya man na duma ta ittaw na padala di.” ");
INSERT INTO cgc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piro, ula gaako Pedro i. Ambal din, “Kay, dili ko kanen an kala.” ");
INSERT INTO cgc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ula nang lugay may isya man na kakala ki Pedro daw ambal din, “Kaon yan isya man ta mga tinudluan din.” Piro, ambal Pedro, “Dey, dili a!” ");
INSERT INTO cgc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Paglambay ta mga isya uras, may isya pa gid na ittaw na gambal, “Kanen gid an duma ta ittaw na padala di tak kanen taga-Galilea man.” ");
INSERT INTO cgc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piro, sabat Pedro, “Dey, ula a gid nalam daw ino paambal no an!” Ta yon gid na uras na gambal pa Pedro, gatagaok manok. ");
INSERT INTO cgc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ginuo i gatubang daw gatan-aw gid ta miad ki Pedro. Nademdeman dayon Pedro ambal ya ta Ginuo ki kanen, “Bag-o magtagaok manok kani, kambal ka en ta tallo bisis na dili a no kala.” ");
INSERT INTO cgc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pagdemdem Pedro, gagwa kanen i daw magal ta tudo ta pagnelsel. ");
INSERT INTO cgc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Naan ta istaran ta pinakadatas na manugdumala ta mga pari, papagayyaan Jesus i daw pabugbog ta mga gagwardya ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Paperengan danen mata din an daw insaan, “Lagpaten no tuo! Kino gatampaling ki kaon?” ");
INSERT INTO cgc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tama pa na ambal danen na insulto ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagsennang ta adlaw, gasapol mga mimbro an ta kadatasan na kunsiyo na Sanedrin. Danen an mga gadumala ta mga Judio, mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises. Jesus i padala dya aged mubang ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Gambal danen ki kanen, “Sugiran kay no daw kaon gid Pinili Ta Dyos Na Mag-ari.” Sabat din, “Daw ambalen ko na yaken Pinili Ta Dyos Na Mag-ari, dili kaw man gyapon magpati. ");
INSERT INTO cgc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Maskin ino insa ko ki kyo, dili kaw man magsabat. ");
INSERT INTO cgc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piro, umpisa anduni, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan mungko en naan tengnged ta Dyos Na Makagagaem naan dapit ta tuo.” ");
INSERT INTO cgc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Insa danen, “Beet no ambalen na kaon Bata Ta Dyos?” Sabat Jesus, “Kyo en gambal san na yaken.” ");
INSERT INTO cgc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ambal danen, “Dili ta en kinanglan duma pa na mga ittaw na magtistigo kuntra ki kanen. Namatian ta en iya an na mga sabat. Paukuman din iya na kaugalingen paagi ta iya na ambal.” ");
INSERT INTO cgc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pagtapos ta sapol ta Sanedrin na kadatasan na kunsiyo ta mga Judio, tanan na mimbro ta Sanedrin gapanaw daw padala Jesus i naan ki Gubirnador Pilato. ");
INSERT INTO cgc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na naan en danen ta tubangan Pilato, paakusar danen Jesus i na ambal danen, “Nasapuan nay ittaw na i na gasegyet ta mga kasimanwa nay na dili danen an magpasakep ta gubirno ta Roma daw dili man danen an magbayad ta iran na buis naan ta pangulo ta Roma. Papati din man mga ittaw an na kanen Pinili Ta Dyos Na Mag-ari.” ");
INSERT INTO cgc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato i gainsa ki Jesus, “Kaon ari ta mga Judio?” Sabat Jesus, “Kaon en gambal san.” ");
INSERT INTO cgc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato i gambal naan ta mga manugdumala na mga pari daw ta duma na mga ittaw na naan dya, “Ula a may nakita na sala ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piro, gapadayon pa gid danen an ta iran na pag-akusar, “Nyan gid gadala ta gamo naan ta bilog na Judea paagi ta iya na pagtudlo! Gaumpisa kanen an naan ta Galilea daw anduni padala din di ta Jerusalem i.” ");
INSERT INTO cgc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagmati Pilato ta iran na akusar, gainsa kanen i ki danen, “Taga-Galilea ittaw na i?” ");
INSERT INTO cgc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na nlaman din na Jesus i naan alin ta Galilea na padumalaan Herodes, pasugo din iya na mga ittawan na dleen Jesus i ki Herodes tak ta yon man na timpo Herodes naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nalipay gid Herodes i na nakita din Jesus an tak kabalita kanen an parti ki Jesus daw lugay en na liag din makita aged kakita kanen ta katingalaan na buaten Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tama insa din ki Jesus. Piro, ula gid Jesus i gasabat. ");
INSERT INTO cgc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Naan man dya mga manugdumala na mga pari daw mga manugtudlo ta Mga Sinulat Moises na gatindeg daw gasinggit gid danen an ta iran na pag-akusar ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes daw iya na mga sundalo, painsultuan danen Jesus an daw patatawaan. Pabayuan danen kanen an ta maalen na bayo na paryo ta bayo ta ari daw pabalik danen ki Pilato. ");
INSERT INTO cgc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodes daw Pilato dati gakuntraay. Ta yon man na adlaw na Jesus an pabalik Herodes naan ki Pilato, gaumpisa en danen an ta pagmiaray. ");
INSERT INTO cgc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na pabalik Jesus i naan ki Pilato, patipon Pilato mga manugdumala na mga pari, duma na mga gadumala ta mga Judio daw tama man na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ambal din ki danen, “Padala nyo ittaw na i ki yaken daw gambal kaw na kanen an gasegyet ta mga ittaw na dili danen an magpasakep ta gubirno ta Roma. Nausisa ko en kanen an naan ta atubangan nyo, piro ula a may nakita na maski isya na sala na paakusar nyo ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes ya ula man may nakita na sala naan ki Jesus tak pabalik din Jesus ki yaken. Ula gid may nabuat na sala Jesus an na dapat sintinsyaan ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gani, magsugo a na latiguon kanen an daw pagtapos ta latigo, palibrien ko.” ");
INSERT INTO cgc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iling tan ambal Pilato tak daw timpo ta Pista Ta Paglibri Alin Ta Egipto, kinanglan magpalibri kanen an ta isya na priso tenged iling tan iya na kaugalian. ");
INSERT INTO cgc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tanan na mga ittaw na gatipon dya gasinggit ki Pilato, “Sintinsyaan ta kamatayen ittaw na yan! Barabas liag nay na librien no!” ");
INSERT INTO cgc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas ya napriso tak labet kanen ya ta paggamo naan ta Jerusalem kuntra ta gubirno ta Roma daw kapatay kanen ta ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tenged liag gid Pilato na librien Jesus i, gambal kanen isab ta mga ittaw na dapat librien Jesus i. ");
INSERT INTO cgc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Piro, gasinggit pa gid mga ittaw an, “Ilansang, ilansang kanen an naan ta krus!” ");
INSERT INTO cgc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ta pangallo bisis gambal Pilato i ki danen, “Man-o, ino gid nabuat din an na sala? Ula a may nakita na sala na dapat na sintinsyaan kanen i ta kamatayen. Magsugo a na latiguon kanen an daw pagtapos ta latigo, palibrien ko kanen an!” ");
INSERT INTO cgc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piro, gasinggit pa gid danen an na bakod iran na kagi na papilit Pilato an na magsugo kanen na ilansang Jesus i naan ta krus. Ta uryan, paayunan nang en Pilato liag ya ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gadisisyon kanen an na tumanen nang en iran ya na liag. ");
INSERT INTO cgc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Palibri din mama ya na gagamo kuntra ta gubirno ta Roma daw kapatay ta ittaw. Piro, Jesus ya paintriga din naan ta mga sundalo na maglansang ki kanen naan ta krus aged matuman liag ya ta mga ittaw na mapatay kanen an. ");
INSERT INTO cgc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na Jesus i padala ta mga sundalo pagwa ta Jerusalem, nasugat danen mama na taga-Cirene na ngaran din Simon na naan galin ta uma daw gapaselled en naan ta syudad. Pagabling danen Simon an daw papas-an ki kanen krus an na lansangan ki Jesus daw papasunod danen kanen an ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sikad gid tama na mga ittaw na gasunod ki Jesus. Duma ki danen mga bai na gapukpok ta iran na dag-anan daw gaaya ta iran na kasebe parti ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Galiso Jesus i naan ta mga bai daw gambal, “Kyo na mga bai na taga-Jerusalem, dili kaw magal tenged ki yaken. Magal kaw tenged ta inyo na kaugalingen daw inyo na mga kabataan ");
INSERT INTO cgc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","tak mabot timpo na may segeng na kalised. Ta yon man na timpo mambal mga ittaw, ‘Mas dayad pa kaimtangan ya ta mga bai na baog, ula kaagi minata daw ula may pasuso.’ ");
INSERT INTO cgc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ta yon man na timpo, ‘mga ittaw mambal man naan ta mga bukid, “Tumpagan kay nyo!” Ambal man danen naan ta mga bungyod, “Tampekan kay nyo.”’ ” ");
INSERT INTO cgc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ambal man Jesus, “Sigurado gid na iling tan matabo tak daw yaken i na ula sala naagian ko segeng na kabellay, simpri mas segeng pa gid na kabellay maagian ta mga ittaw na nakasala daw ula man ganelsel.” ");
INSERT INTO cgc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","May darwa na kriminal na padala man ta mga sundalo duma ki Jesus naan ta gwa ta Jerusalem aged silutan danen an ta kamatayen. ");
INSERT INTO cgc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na gabot danen tanan naan ta lugar na paumaw na Bungyod Balbagol, palansang ta mga sundalo Jesus i daw darwa ya na kriminal naan ta mga krus. Patindeg danen krus Jesus daw mga krus ta darwa na kriminal na isya an naan dapit ta tuo Jesus daw isya an a, naan dapit ta iya na wala. ");
INSERT INTO cgc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus i gambal, “Amay, patawaren no danen an tak ula danen naintindii daw ino pabuat an danen ki yaken.” Pagtapos ta paglansang, paulas-ulas ta mga sundalo iya na mga bayo paagi ta paggabot-gabutay. ");
INSERT INTO cgc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mga ittaw na giling dya na galuag daw mga manugdumala an na naan dya, patatawaan danen Jesus i daw ambal danen, “Paluwas din kabui ta duma na mga ittaw. Daw kanen an Pinili Ta Dyos Na Mag-ari, dapat maluwas din man iya an na kaugalingen na kabui!” ");
INSERT INTO cgc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pagayyaan man ta mga sundalo Jesus i. Papranian danen kanen i daw painem ta agsem na bino. ");
INSERT INTO cgc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ambal danen, “Daw kaon yan ari ta mga Judio, luwasen no imo an na kaugalingen.” ");
INSERT INTO cgc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pabetang naan dapit ta apaw ta ulo din sinulat na iling ti, YI ARI TA MGA JUDIO. ");
INSERT INTO cgc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Isya ya ta darwa na kriminal na nalansang man naan ta krus paryas ki Jesus gainsulto ki kanen, “Di' ba kaon kon Pinili Ta Dyos Na Mag-ari? Luwasen no imo an na kaugalingen daw kami man!” ");
INSERT INTO cgc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Piro, pagmati ta isya an na kriminal, pasaway din kriminal na gainsulto ki Jesus. Ambal din, “Man-o tak gambal ka ta iling san? Ula ka adlek ta Dyos? Pasintinsyaan ka man ta kamatayen na paryas ki kanen. ");
INSERT INTO cgc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Igo nang na pasilutan ki tak bayad ta ate na malain na mga nabuat. Piro, kanen an a, ula may malain na nabuat.” ");
INSERT INTO cgc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ambal din ki Jesus, “Jesus, ta timpo na mag-umpisa ka en na magdumala, demdemen a no.” ");
INSERT INTO cgc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sabat Jesus ki kanen, “Ee. Gambal a ki kaon na anduni gid na adlaw magduma ka ki yaken naan ta Paraiso.” ");
INSERT INTO cgc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na mag-ugto-adlaw en, gadelem bilog na lugar dya asta ta tallo uras ");
INSERT INTO cgc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","tak ula gaadlaw ta tallo na uras. Kurtina ya naan ta Balay Ta Dyos nagisi na tenga gid. ");
INSERT INTO cgc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gambal Jesus i na bakod iya na kagi, “Amay, pasalig ko ki kaon ake na ispiritu!” Pagtapos ta ambal din, nabugto iya na ginawa. ");
INSERT INTO cgc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pagkita ta upisyal ta sundalo ta natabo ya, gadayaw kanen an ta Dyos, “Matuod gid man! Matareng ittaw na yan!” ");
INSERT INTO cgc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tama na mga ittaw gatipon dya aged muag ta pagsintinsya. Pagkita danen ta natabo ya, guli danen an na gapukpok ta iran na mga dag-anan tenged ta sikad gid na kasebe. ");
INSERT INTO cgc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tama na mga arey Jesus daw mga bai na kakuyog ki kanen alin ta Galilea, danen an naan gatindeg ta madyo na gatan-aw ta mga natabo. ");
INSERT INTO cgc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","May mama na ngaran din Jose na miad daw matareng na ittaw. Mimbro kanen an ta Sanedrin na kadatasan na kunsiyo ta mga Judio, ");
INSERT INTO cgc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","piro dili kanen kumpurmi ta disisyon daw pabuat ta Sanedrin kuntra ki Jesus. Naan kanen gistar ta banwa Arimatea na sakep ta Judea daw gapaabot kanen ta timpo na mag-umpisa pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Giling Jose i ki Gubirnador Pilato daw galisinsya na kanen mamang ta lawa Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Patugutan kanen i daw pakamang din naan ta krus lawa ya Jesus daw paputos paagi ta pagblebed ta maalen na tila na lino. Pabetang din lawa ya Jesus naan ta lebbengan na bato na palungagan na paryo ta kwiba. Lebbengan na ya ula pa may nalebbeng dya. ");
INSERT INTO cgc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nalebbeng Jesus dya naan ta adlaw ta pagpriparar daw ta uras na dali nang en mag-umpisa Adlaw Ta Pagpuay. ");
INSERT INTO cgc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mga bai na kakuyog ki Jesus na galin kanen ta Galilea gasunod ki Jose miling naan ta lebbengan. Nakita danen lebbengan an daw nakita man danen daw ino na pag-uyos ta lawa Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Guli danen an daw mag-imes ta ammot na mga pamanyos para ta lawa Jesus. Na gaumpisa en Adlaw Ta Pagpuay, ula en danen an gaubra aged magtuman ta mga sugo naan ta Mga Sinulat Moises parti ta Adlaw Ta Pagpuay. ");
INSERT INTO cgc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta una na adlaw ta duminggo na sellem pa gid, mga bai an na gaimes ta ammot na mga pamanyos para ta lawa Jesus giling isab naan ta lebbengan din na padala danen iran na naimes. ");
INSERT INTO cgc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pag-abot danen naan ta lebbengan, nakita danen na lebbengan ya bukas en tak bato na sara naligid en. ");
INSERT INTO cgc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gaselled danen naan ta lebbengan, piro ula danen nakita lawa Ginuo Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Gakullaw danen an daw ino natabo. Na gakullaw pa danen, nali nang may darwa na mama na iran na bayo sikad silaw na gatindeg naan tengnged ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mga bai an sikad gid nadlek daw galuod padapa. Darwa na mama gambal ta mga bai, “Man-o tak bui an papangita nyo ta lugar i ta mga patay? ");
INSERT INTO cgc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ula di en kanen ya! Pabannaw en ta Dyos! Demdemen nyo ambal din ki kyo na naan pa kanen ta Galilea. ");
INSERT INTO cgc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ambal din na naan ta plano ta Dyos na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan intriga naan ta malain na mga ittaw daw ilansang naan ta krus daw naan ta pangallo na adlaw alin ta iya na kamatayen, kanen an mabannaw.” ");
INSERT INTO cgc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pagmati ta mga bai ta ambal ta darwa na mama, nademdeman danen naambal ya Jesus ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Guli danen an alin ta lebbengan Jesus daw pasugid danen mga natabo ya ki danen naan ta unsi na apustulis daw naan ta duma man na mga tinudluan Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Magdalena, Juana, Maria na inay Santiago daw iran na mga duma, danen mga bai ya na gasugid naan ta mga apustulis. ");
INSERT INTO cgc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pasugid ya ta mga bai ula papatii ta mga apustulis tak salig danen na kabuangan nang sugid ya. ");
INSERT INTO cgc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piro, Pedro i galin dayon daw gadlagan na miling naan ta lebbengan Jesus. Pag-abot din dya, galeeb kanen i daw sil-ingen selled an. Nakita din mga tila nang en na lino na pamputos. Pagkita din, guli kanen i na gakullaw daw ino natabo ya. ");
INSERT INTO cgc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yon man na adlaw na mga bai ya giling naan ta lebbengan Jesus, may darwa na tinudluan din na giling naan ta banwa na paumaw Emmaus. Kaadyuon an ta Emmaus alin ta Jerusalem daw panawen mga tallo uras. ");
INSERT INTO cgc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ta iran na pagpanaw, gaisturyaay danen an parti ta mga bag-o nang na natabo ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na gaisturyaay danen an, Jesus i gaprani daw gapanaw na dengngan ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Piro, ula danen nakala kanen i tak paryo paliperan iran an na mata. ");
INSERT INTO cgc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Gainsa kanen ki danen, “Ino paisturya nyo an mintras gapanaw kaw?” Pagmati danen ta insa din, gateneng anay danen an ta iran na pagpanaw. Makita naan ta iran na sura na danen gangasebe gid. ");
INSERT INTO cgc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Isya ki danen na ngaran din Cleofas gambal ki Jesus, “Ta tanan na bisita na naan ta Jerusalem, kaon nang ula nalam parti ta bag-o nang na mga natabo!” ");
INSERT INTO cgc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Insa Jesus, “Ngaran sa mga natabo ya?” Sabat danen, “Mga natabo ki Jesus na taga-Nazaret. Kanen ya prupita na may sarang ta pagtudlo daw pagbuat ta mga katingalaan. Nadayaran gid Dyos ki kanen daw pataod gid kanen ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Piro, ame na mga manugdumala na mga pari daw mga gapanguna ta banwa, paintriga danen kanen ya naan ta gubirnador aged masintinsyaan ta kamatayen. Papalansang danen kanen naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kami na mga tinudluan din gasalig gid na kanen maglibri ki kiten na mga linai Israel alin ta ate na mga kuntra. Anduni pangallo na adlaw en alin ta iya na kamatayen. ");
INSERT INTO cgc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Duma nay na mga bai may nasugid ki kami daw gatingala kay gid. Ambal danen na gina sellem giling danen naan ta lebbengan Jesus, ");
INSERT INTO cgc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","piro ula danen nakita lawa din ya. Gabalik danen an daw gasugid ki kami na may nakita danen na panan-awan na mga angil gambal ki danen na Jesus ya bui. ");
INSERT INTO cgc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pagmati nay ta iran na sugid, pila na mga duma nay giling naan ta lebbengan daw mga nakita danen dya paryo gid ta sugid ya ta mga bai. Ula man danen nakita Jesus ya!” ");
INSERT INTO cgc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ambal Jesus ki danen, “Aree! Ula kaw pa kaintindi? Man-o tak bellay para ki kyo na magpati ta tanan na ambal ta mga prupita? ");
INSERT INTO cgc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Simpri maagian anay ta Pinili Ta Dyos Na Mag-ari tanan ya na mga malain na buat ki kanen paryo ta pasambit nyo bag-o din mabaton pinakadatas na uturidad daw pagdayaw na iya ta Dyos tak iling tan naan ta plano ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pasaysay man Jesus ki danen tanan an na naan ta sinulat na pulong ta Dyos na parti ki kanen, umpisa ta Mga Sinulat Moises asta ta Mga Sinulat Ta Mga Prupita. ");
INSERT INTO cgc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na dani en danen an ta banwa na ilingan danen, paryo na magdiritso pa Jesus i ta iya na pagpanaw. ");
INSERT INTO cgc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Piro, paawiran kanen an ta darwa an na ambal danen, “Unti ka nang anay magdayon duma ki kami tak mapon en daw dali nang en magdelem.” Tenged ta iran na ambal, gakuyog Jesus i ki danen aged naan dya magdayon. ");
INSERT INTO cgc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na naan en ta balay, gakaan Jesus i duma ki danen Cleofas. Gakamang kanen i ta tinapay daw gapasalamat. Pabiak-biak din tinapay ya daw paatag ki danen. ");
INSERT INTO cgc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nali nang, paryo ula en liped iran na mata. Nakala en danen kanen i! Dayon kanen i narwad ta iran na panan-aw. ");
INSERT INTO cgc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gaisturyaay danen an, “Na gapanaw ki pa gina, nyan pla na nadayaran ki gid ta iya na pag-isturya ki kiten na pasaysay din mga ambal ya naan ta sinulat na pulong ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Gadali-dali panaw danen Cleofas alin Emmaus na malik naan ta Jerusalem. Pag-abot dya, nakita danen unsi na apustulis daw mga duma man danen na gatipon en. ");
INSERT INTO cgc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mga gatipon dya gaisturyaay, “Matuod gid! Ginuo ya nabannaw! Gapakita kanen ya ki Simon!” ");
INSERT INTO cgc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pag-ambal ta mga gatipon dya, danen Cleofas gasugid daw ino natabo ya ki danen mintras gapanaw danen na miling Emmaus daw nakala danen Jesus ya paagi ta pagbiak-biak din ta tinapay. ");
INSERT INTO cgc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na danen Cleofas gaisturya pa ta duma na mga tinudluan Jesus, gulpi nang gapakita Jesus i na gatindeg duma ki danen. Ambal din ki danen, “Kabay pa na mabaton nyo katawwayan na alin ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nakulbaan danen daw adlek gid tak salig danen na kalag nakita danen. ");
INSERT INTO cgc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ambal din pa ki danen, “Man-o tak kulbaan kaw? Man-o tak ula kaw gapati na yaken ni? ");
INSERT INTO cgc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lagen nyo ake i na mga lima daw mga batiis! Yaken gid ni! Ibitan a nyo daw tan-awen tak kalag an a ula sapo daw bekkeg, piro yaken i a may sapo daw bekkeg paryo ta nakita nyo.” ");
INSERT INTO cgc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pag-ambal din, papakita din mga agi ta lansang naan ta iya na mga lima daw batiis. ");
INSERT INTO cgc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Piro, ula pa gid danen gapati na Jesus gid nakita an danen tenged bakod iran na kalipay daw gatingala gid danen an. Tenged ula pa danen gapati, gainsa kanen i ki danen, “May pagkaan kaw di?” ");
INSERT INTO cgc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Paatagan danen kanen i ta sinugba na sidda. ");
INSERT INTO cgc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pakamang din sidda ya daw gakaan kanen an na danen an gatan-aw. ");
INSERT INTO cgc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Gambal kanen i ki danen, “Na gadumaay ki pa kan-o, gambal a daan ki kyo na naan ta plano ta Dyos na matuman tanan na nasulat parti ki yaken na naan ta Mga Sinulat Moises, Mga Sinulat Ta Mga Prupita daw Mga Salmo.” ");
INSERT INTO cgc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pasaysay din sinulat na pulong ta Dyos ki danen aged maintindian danen ta usto. ");
INSERT INTO cgc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Gambal kanen i, “Iling ti nasulat: Pinili Ta Dyos Na Mag-ari maagian din segeng na mga kabellay. Mapatay kanen, piro ta pangallo na adlaw mabannaw. ");
INSERT INTO cgc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nasulat man na paagi ta iya na uturidad mga ittaw naan ta Jerusalem asta ta bilog na kalibutan sugiran na daw magnelsel danen an daw dilian iran an na mga sala, patawaren danen an ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kyo na mga tinudluan ko, magpamatuod kaw parti ki yaken tak nakita nyo tanan na mga buat ko daw natabo ki yaken. ");
INSERT INTO cgc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ipadala ko ki kyo papangako ya ta ake na Amay. Gani, magtagad kaw anay unti Jerusalem i asta na mabaton nyo gaem na alin ta Dyos na papangako din.” ");
INSERT INTO cgc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na timpo na Jesus i malik en naan ta langit, padala din iya an na mga tinudluan na mwa danen an alin ta Jerusalem. Na dani nang en danen an naan ta baryo na Betania, padatas din iya an na mga lima na mangamuyo daw pabindisyunan danen an. ");
INSERT INTO cgc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na gapangamuyo pa kanen i, galin kanen ki danen daw padala naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Padayaw kanen i ta mga tinudluan din. Gabalik danen an naan ta Jerusalem na bakod gid iran na kalipay! ");
INSERT INTO cgc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Adlaw-adlaw naan danen an ta Timplo na gadayaw ta Dyos.");
INSERT INTO cgc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Anay pa sa bag-o nabuat kalibutan i, anen en kanen na paumaw na Pulong. Pulong an duma ta Dyos daw kanen an Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Alin pa gid ta una, duma en kanen ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paagi ki kanen pabuat ta Dyos tanan na betang daw ula may betang na nabuat na dili paagi ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kanen an alinan ta kabui daw kanen paumaw na ilaw na gapapawa ta isip ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ilaw an gapawa naan ta delem daw impusibli man na ilaw an dili magpawa naan ta delem. ");
INSERT INTO cgc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","May ittaw na papadala ta Dyos na ngaran din Juan. ");
INSERT INTO cgc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan papadala ta Dyos para magsugid ta mga ittaw parti ki kanen na paumaw na Ilaw aged magpati danen ki kanen tenged ta sugid Juan. ");
INSERT INTO cgc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan i dili paumaw an na Ilaw. Piro, pasugo ta Dyos Juan i na magsugid parti ki kanen na paumaw na Ilaw. ");
INSERT INTO cgc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Paumaw an na Ilaw, kanen an matuod na ilaw na giling ta kalibutan i daw gapapawa ta isip ta tanan na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bisan anen kanen di duma ta mga ittaw ta kalibutan i daw paagi ki kanen nabuat ta Dyos kalibutan i, ula man gyapon danen kakala daw kino gid kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Giling kanen ta mga ittaw na papili din na iya gid, piro katamaan ki danen ula danen pabaton kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piro, bisan kino na gabaton na gatuo ki kanen, danen an may matareng na alin ki kanen na maimo danen an na mga bata ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Danen naimo na mga bata ta Dyos dili tenged pabata danen ta Dyos paryo ta pagbata ta mga ittaw. Dili man pabata danen an paryo ta disisyon ta magsawa na gusto magbata. Iya gid ta Dyos na buat na danen an naimo na iya na mga bata. ");
INSERT INTO cgc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kanen na paumaw na Pulong natao daw gaistar naan ta kalibutan i na duma ki kiten. Nlaman nay na ula duma paryo ki kanen na miad gid daw paagi ki kanen mlaman ta gid kamatuuran an parti ta Dyos. Nakita nay na daw ino naan ta Dyos Amay naan man ki kanen tenged kanen bugtong na Bata Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pasugid Juan naan ta mga ittaw daw kino gid paumaw an na Pulong. Ambal Juan na bakod iya na kagi, “Jesus an, kanen paambal ko na ittaw na mabot sunod ki yaken, piro mas datas pa iya na katengdanan kaysa ta ake na katengdanan tak anen en kanen an na ula a pa natao.” ");
INSERT INTO cgc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tenged Jesus miad gid, pirmi ki din paatagan ta mga kaayaran. ");
INSERT INTO cgc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dyos gaatag ki kiten ta iya na mga sugo paagi ta sinulat Moises, piro paagi ki Jesu-Cristo pakita din na kanen an miad gid daw papaintindi din man ki kiten kamatuuran parti ta iya na kaugalingen. ");
INSERT INTO cgc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ula may ittaw na kakita ta Dyos. Piro, nakala ta gid Dyos an paagi ki kanen na bugtong na Bata. Kanen an Dyos daw duma ta Dyos Amay. ");
INSERT INTO cgc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Naan ta Jerusalem mga manugdumala ta Judio gasugo ta mga pari daw mga duma danen na Levita na ilingan danen Juan an na insaan daw kino gid kanen an. Iling ti natabo ta iya na pagsabat ki danen. ");
INSERT INTO cgc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pasugiran din danen an ta matuod. Ula gid kanen gabula. Ambal din, “Dili yaken Pinili Ta Dyos Na Mag-ari.” ");
INSERT INTO cgc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gainsa pa danen, “Ta, daw dili kaon Pinili Ta Dyos Na Mag-ari, kino ka gid? Kaon Elias na prupita na manugsugid ta kabebet-en ta Dyos?” Sabat din, “Dili.” Painsaan danen isab kanen i, “Kaon papaabot ta ya na prupita?” Sabat din, “Dili.” ");
INSERT INTO cgc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ambal danen ki kanen, “Sugiran no kami i daw kino ka gid aged may isugid kay ta mga gasugo ya ki kami. Ino maambal no parti ta imo na kaugalingen?” ");
INSERT INTO cgc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sabat din alin ta sinulat Isaias. Ambal din, “Yaken ittaw naan ta lugar na ula kabalayan na galaygay na bakod iya na kagi, ‘Tadlengen nyo agian an para ta pag-abot ta Ginuo.’” ");
INSERT INTO cgc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mga ittaw an na gainsa ki Juan, danen pasugo ta mga manugdumala na paumaw na Pariseo. ");
INSERT INTO cgc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Insa pa gid danen ki kanen, “Daw dili kaon Pinili Ta Dyos Na Mag-ari daw dili man kaon Elias daw dili ka man prupita na mabot, man-o tak gabautismo ka ta mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sabat din, “Matuod gabautismo a ta mga ittaw paagi nang ta waig. Piro, dili yaken papaabot nyo ya tak may isya na anen di anduni na dili nyo kala daw kino gid kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kanen pambal ko ya na mabot sunod ki yaken. Dili a bagay na magsirbi ki kanen maskin ta pagbadbad nang ta igot ta iya na sandal tak datas gid iya na katengdanan.” ");
INSERT INTO cgc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Pag-insa ya ta mga Pariseo ki Juan natabo naan ta Betania naan pa ta liyo ta Suba Jordan na anen dya Juan an na gabautismo ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sunod na adlaw, nakita Juan na gaprani Jesus ki kanen. Gambal Juan ta mga ittaw dya, “Lagen nyo, anen en kanen i na paumaw na Karniro na papadala ta Dyos para ialad tak paagi ki kanen patawaren ta Dyos mga ittaw ta iran na mga sala. ");
INSERT INTO cgc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kanen i pambal ko na mabot sunod ki yaken daw mas datas pa iya na katengdanan kaysa ta ake na katengdanan tak na ula a pa natao, kanen anen en. ");
INSERT INTO cgc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ta una, ula ko pa nakala daw kino kanen i na mabot sunod ki yaken. Piro, padala a ta Dyos na magbautismo ta mga ittaw aged makala kanen i ta mga linai Israel paagi ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Gapamatuod Juan naan ta mga ittaw parti ta iya na inagian, “Ta una, ula ko nakala daw kino kanen an na mabot sunod ki yaken. Piro, na padala a ta Dyos na magbautismo ta mga ittaw, ambal din ki yaken na daw makita ko Dyos Ispiritu Santo gapababa alin ta langit daw gapabilin naan ta isya na ittaw, yon man na ittaw na papaabot ko. Kanen magbautismo an ta mga ittaw paagi ta Dyos Ispiritu Santo. Ambal ya ta Dyos ki yaken natuman gid tak nakita ko en Dyos Ispiritu Santo gapababa alin ta langit paryo ta salampati daw gapabilin naan ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nakita ko gid en daw yon tenaan na gasugid a ta mga ittaw na Jesus an Bata Ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sunod na adlaw, Juan daw darwa din na tinudluan anen isab ta Betania na naan ta liyo ta Suba Jordan. ");
INSERT INTO cgc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nakita din Jesus na galambay daw ambal din, “Lagen nyo, anen en Jesus na Karniro na papadala ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagmati ta darwa na tinudluan Juan, gasunod dayon danen an ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na gablikid Jesus i, nakita din darwa an na tinudluan Juan na gasunod ki kanen. Painsaan din, “Ino kinanglan nyo?” Sabat ta darwa an, “Rabbi, indi ka gadayon?” Rabbi beet ambalen mistro. ");
INSERT INTO cgc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ambal Jesus ta darwa na tinudluan Juan, “Mos, muyog kaw ki yaken aged mlaman nyo daw indi a gadayon.” Pag-ambal din, gakuyog dayon darwa ya daw nakita danen daw indi kanen gadayon. Naan dya danen an alin ta paglambay ta appat uras alin ta ugto-adlaw asta magkilem. ");
INSERT INTO cgc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Isya na tinudluan Juan na kamati ta ambal Juan daw gasunod ki Jesus, ngaran din Andres na utod Simon Pedro. ");
INSERT INTO cgc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pangita dayon Andres utod din ya daw pasugiran din, “Nakita nay Mesias ya.” Pambal na Mesias beet ambalen Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pag-ambal Andres, padala din dayon Simon an naan ki Jesus. Pag-abot danen Andres ki Jesus, gatan-aw Jesus i ki Simon daw ambal din, “Kaon Simon na bata Juan. Piro, umawen ta kaw na Cefas.” Ngaran na Cefas, daw isalyo naan ta Griego na linggwai, Pedro. ");
INSERT INTO cgc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sunod na adlaw, Jesus i gadisisyon na miling kanen naan ta Galilea. Ta iya na pagpanaw, nakita din Felipe daw ambal din, “Muyog ka ki yaken aged kaon man isya ta ake na mga tinudluan.” ");
INSERT INTO cgc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe i taga-Betsaida na isya na banwa na sakep ta Galilea. Taga-Betsaida man danen ya Andres daw Pedro. ");
INSERT INTO cgc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe i, papangita din dayon Natanael ya. Pagkita din, ambal din, “Nakita nay kanen ya na pasambit Moises naan ta iya na sinulat daw pasambit man ta mga prupita naan ta iran na mga sinulat. Kanen Jesus na taga-Nazaret na bata Jose.” ");
INSERT INTO cgc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ambal Natanael, “Aree! Ula gid an may miad na alin ta Nazaret!” Ambal man Felipe, “Muyog ka ki yaken aged makita no kanen ya.” ");
INSERT INTO cgc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na gaprani Natanael ki Jesus, nakita Jesus kanen i daw gambal parti ki kanen, “Anen mama i na matuod na linai Israel tak masaligan.” ");
INSERT INTO cgc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Gatingala Natanael an tak nakala kanen an Jesus. Gainsa kanen an ki Jesus, “Man-o tak nakala a no?” Sabat Jesus, “Bag-o ka pa paanggat Felipe, nakita ta kaw en na naan ka pa ta dalem ta kaoy na igos.” ");
INSERT INTO cgc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dayon ambal Natanael ki Jesus, “Mistro, matuod gid na kaon Bata Ta Dyos daw kaon man Ari ta mga linai Israel.” ");
INSERT INTO cgc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ambal Jesus ki Natanael, “Kaon yan gapati en ki yaken tenged ta ambal ko na nakita ta kaw naan ta dalem ta kaoy na igos. Makita no mas makatingala pa na mga buat kaysa ta nakita no anduni.” ");
INSERT INTO cgc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gambal pa Jesus ki kanen, “Sigurado gid na makita nyo mas makatingala pa na mga buat daw sugiran ta kyo na makita nyo langit na magbukas daw mga angil ta Dyos gapanaik naan ta langit daw gapanaog naan ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan.” ");
INSERT INTO cgc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Paglambay ta darwa na adlaw alin ta pag-isturya Jesus ki Natanael, may kasal naan ta banwa na Cana na sakep ta Galilea. Gatambong inay Jesus ta kasal. ");
INSERT INTO cgc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus daw iya na mga tinudluan gatambong man ta kasal ya tak danen paimbitar man. ");
INSERT INTO cgc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na naubusan en ta bino mga ittaw na gakumbira, iya na inay gambal ki kanen, “Ula en danen an bino.” ");
INSERT INTO cgc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sabat Jesus, “Nay, dili ka magpalibeg tak nlaman ko daw ino dapat ko na buaten. Dili pa uras na matuman plano ta Dyos para ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Inay Jesus gambal naan ta mga ittaw na gasirbi, “Tumanen nyo daw ino sugo din ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","May anen dya annem na tadyaw na buat alin ta bato. Kada tadyaw pwidi maugsakan ta binti asta ta trinta galon na waig na pagamit para pang-ugas ta lima tak ta riliyon ta mga Judio may sunuran parti ta paglimpyo ta lima. ");
INSERT INTO cgc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ambal Jesus ta mga ittaw na gasirbi, “Pannuon nyo ta waig mga tadyaw an.” Pagtapos Jesus ta ambal, papanno danen asta gid tepeng ta bibig ta mga tadyaw. ");
INSERT INTO cgc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ambal Jesus ki danen, “Magsalok kaw ta waig naan ta mga tadyaw an daw dleen nyo naan ta ittaw na pasaligan ta pag-asikaso ta kumbira.” Pag-ambal Jesus, mga ittaw na gasirbi, gasalok naan ta mga tadyaw daw padala danen naan ta ittaw na gaasikaso ta kumbira. ");
INSERT INTO cgc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na patilawan din iran ya na dala, bino nainem din tak waig nimo en na bino. Ula din nlami daw indi galin bino an, piro mga ittaw ya na gasirbi, nlaman danen. Paumaw din mama na nakasal. ");
INSERT INTO cgc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ambal din, “Kustumbri ta mga ittaw na gakumbira una danen na papatad dayad an na klasi ta bino. Daw tama en nainem ta iran na mga bisita, dili en dayad na bino papatad danen. Piro, kaon yan, iba man a tak pauryan no imo dayad an na klasi ta bino!” ");
INSERT INTO cgc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Pag-imo an Jesus ta bino alin ta waig na kanen naan ta Cana na sakep ta Galilea, yon una na katingalaan na pabuat din na pamatuod daw kino kanen an. Paagi ta una na katingalaan na pabuat din, papakala din na daw ino naan ta Dyos naan man ki kanen. Iya na mga tinudluan gatuo ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagtapos ta kasal, gategbeng Jesus duma ta iya na inay, iya na mga utod daw iya na mga tinudluan naan ta banwa na Capernaum. Gatinir danen dya ta pila na mga adlaw. ");
INSERT INTO cgc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na dali nang en mabot timpo na mag-umpisa pista ta mga Judio na paumaw na Pista Ta Paglibri Alin Ta Egipto, Jesus i daw iya na mga tinudluan giling naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Naan ta sular ta Timplo may nakita kanen i na mga ittaw na gabligya ta pang-alad na mga baka, karniro daw tukmo. May mga ittaw man dya na manugbalyo ta kwarta. ");
INSERT INTO cgc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pagkita din, gakamang kanen an ta mga kalat daw pabuat din na panglapres. Papagwa din alin ta Timplo tanan na ganigusyo dya asta mga karniro daw baka. Pawas-ag din mga kwarta ya ta mga manugbalyo daw patumba din man iran na mga lamisaan. ");
INSERT INTO cgc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pambalan din mga ittaw na gabligya ta mga tukmo, “Mangen nyo mga tukmo an daw dleen nyo mwa. Dili nyo en buaten na bligyaan balay i ta ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na nakita ta mga tinudluan Jesus na papagwa din alin ta Timplo mga ittaw na gabligya dya, nademdeman danen na naan ta sinulat na pulong ta Dyos may gapangamuyo ta Dyos ta iling ti, “Bisan patayen a ta mga ittaw, bakod man gyapon pagpalangga ko ta imo na balay.” ");
INSERT INTO cgc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mga manugdumala ta Judio gagilek ki Jesus daw gambal danen an ki kanen, “Daw alin ta Dyos imo na uturidad ta pagpalin no ta mga ittaw ya naan ta Timplo, magbuat ka ta katingalaan na pamatuod no ki kami.” ");
INSERT INTO cgc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sabat Jesus ki danen, “Daw gubbaen nyo Balay i Ta Dyos, patindegen ko isab seled ta tallo na adlaw.” ");
INSERT INTO cgc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ambal danen, “Di, ino isip ti a? Ula ka nalam na Balay i Ta Dyos patukod ta kwarintay-sais na taon? Impusibli na mapatindeg no ta tallo nang na adlaw.” ");
INSERT INTO cgc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piro, ula danen naintindii na Balay Ta Dyos na pambal Jesus beet ambalen iya na lawa. ");
INSERT INTO cgc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ta pagbannaw ki kanen ta uryan, mademdeman ta iya na mga tinudluan iya an na paambal na seled ta tallo na adlaw patindegen din isab Balay Ta Dyos. Gani, mapati gid danen an na matuod ambal Jesus daw mga ambal parti ki kanen naan ta sinulat na pulong ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na naan Jesus i ta Jerusalem ta timpo ta Pista Ta Paglibri Alin Ta Egipto, tama na mga ittaw gatuo ki kanen tak nakita danen mga katingalaan na pabuat din. ");
INSERT INTO cgc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piro, Jesus ula gasalig na matuod iran na pagtuo ki kanen tak nlaman din ugali ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dili en kinanglan na sugiran pa kanen an daw ino iran na isip tak nlaman din en daw ino isip ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","May mama na ngaran din Nicodemo na mimbro ta grupo na paumaw na Pariseo daw isya man kanen an ta mga manugdumala ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isya na kilem, giling kanen an ki Jesus daw gambal, “Mistro, nlaman nay na kaon papadala ta Dyos aged magtudlo ki kami. Nlaman nay tak imo na mga katingalaan na buat pamatuod na Dyos an gaubay ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ambal Jesus ki Nicodemo, “Matuod gid nyan daw sugiran ta kaw na ula duma na masakep ta pagdumala ta Dyos daw dili, mga ittaw na matao isab.” ");
INSERT INTO cgc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Insa Nicodemo ki Jesus, “Daw isya na ittaw manakem en, ino paagi na kanen an matao isab? Impusibli na malik pa kanen isab naan selled ta gettek ta iya na inay daw matao isab.” ");
INSERT INTO cgc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sabat Jesus, “Matuod gid nyan, piro gambal a ki kaon na ula duma na makalabet naan ta mga ittaw na padumalaan ta Dyos daw dili, mga ittaw na matao paagi ta waig daw Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bisan kino na pabata ta ittaw, kanen an ittaw nang man. Piro, bisan kino na natao paagi ta Dyos Ispiritu Santo, may bag-o na kabui na alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dili ka magtingala ta ake na ambal na kada ittaw kinanglan matao isab. ");
INSERT INTO cgc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Angin gaeyep bisan indi nang dapit. Piro, bisan ula nyo nlami daw indi galin daw indi punta, mabatyagan nyo man gyapon. Iling man tan mga ittaw na natao paagi ta Dyos Ispiritu Santo tak bisan ula danen naintindii paagi an na natao danen isab, matuod man gyapon na natao danen daw nakita danen risulta ta mga nabuat ta Dyos Ispiritu Santo ki danen.” ");
INSERT INTO cgc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Insa Nicodemo ki Jesus, “Man-o, pwidi na matao mga ittaw paagi ta Dyos Ispiritu Santo?” ");
INSERT INTO cgc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sabat Jesus, “Di' ba kaon yan pataod na manugtudlo ta mga linai Israel, piro ula no pa gid naintindii na matao isab mga ittaw paagi ta Dyos Ispiritu Santo? ");
INSERT INTO cgc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tingala a gid na ula no pa naintindii, piro gambal a ki kaon na pasugid nay en ki kyo mga nlaman nay daw mga nakita nay, piro ula kaw man gyapon gapati ta ame na sugid. ");
INSERT INTO cgc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tenged na ula kaw gapati ta tudlo ko parti ta kabui naan ta kalibutan i, dili kaw man gyapon magpati ta isugid ko ki kyo parti daw ino naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ula duma na kailing naan ta langit daw makasugid gid parti ta langit daw dili, Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan.” ");
INSERT INTO cgc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ambal din pa, “Buaten naan ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan paryo ta pabuat ya anay pa sa naan ta bekkessan na buat alin ta brunsi. Na danen Moises naan ta lugar na ula kabalayan, bekkessan ya na brunsi pabetang din naan ta kaoy daw padatas aged mga magtan-aw ta bekkessan ya dili mapatay. Iling man tan buaten ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan tak naan ta plano ta Dyos na kanen i ibetang naan ta kaoy daw ipadatas ");
INSERT INTO cgc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aged bisan kino magtuo ki kanen, maangken danen kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tenged ta bakod na paggugma ta Dyos ta mga ittaw ta kalibutan, paatag din bugtong din na Bata aged bisan kino magtuo ta iya na Bata, dili din maageman silot na ula katapusan. Tagan din danen an ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tuyo ta Dyos na papadala din iya na Bata naan ta mga ittaw ta kalibutan dili para magsintinsya iya na Bata ki danen ta ula katapusan na silot. Tuyo din na paagi ta iya na Bata danen maluwas alin ta silot. ");
INSERT INTO cgc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Gani, bisan kino na gatuo ta Bata Ta Dyos, dili en sintinsyaan. Piro, bisan kino na ula gatuo, nasintinsyaan en ta silot na ula katapusan tak ula gatuo ta bugtong na Bata Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yi tenaan na sintinsyaan danen an ta Dyos: Kanen an na paumaw na Ilaw giling ta kalibutan i daw gapapawa kanen an ta isip ta mga ittaw aged magpati danen ta Dyos, piro mas gusto danen kadelem kaysa ta kapawa aged magpadayon danen ta iran na mga buat na malain. ");
INSERT INTO cgc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tanan na mga ittaw na gabuat ta malain gasikway ki kanen na paumaw na Ilaw daw ula man gaprani ki kanen tak basi makita na mga buat an danen malain. ");
INSERT INTO cgc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piro, tanan na gasunod ta kamatuuran parti ta Dyos, gaprani danen an ki kanen na paumaw na Ilaw aged makita ta mga ittaw na gabuat danen an ta dayad tak gatuman ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Paglambay ta pila na mga adlaw alin ta pag-isturyaay Jesus daw Nicodemo, Jesus daw iya na mga tinudluan giling naan ta lain-lain na mga lugar naan ta prubinsya na Judea. Naan dya danen an gatinir daw gabautismo ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ta yon man na timpo, Juan gabautismo ta mga ittaw naan ta Enon na dani nang ta Salim tak naan dya tama waig. Giling pa mga ittaw naan ki kanen daw magpabautismo ");
INSERT INTO cgc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tak ta yon man na timpo ula pa kanen napriso. ");
INSERT INTO cgc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ta yon man na timpo, gadiskasay mga tinudluan Juan daw isya na mama na Judio tenged ta sunuran ta mga Judio parti ta sirimunya ta paglimpyo. ");
INSERT INTO cgc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pagtapos ta iran na pagdiskasay, mga tinudluan Juan giling ki kanen daw gambal, “Mistro, nademdeman no na gasugid ka kan-o parti ta mama ya na duma no naan ta liyo Suba Jordan? Anduni, gabautismo kanen ya daw sikad tama na mga ittaw giling ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ambal Juan, “Bay-an nyo nang. Daw ula kanen paatagan ta Dyos ta katengdanan, impusibli na iling an tan mabuat din. ");
INSERT INTO cgc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Namatian nyo en ake na ambal na dili yaken Pinili Ta Dyos Na Mag-ari. Papadala a ta Dyos una ki kanen aged magsugid ta mga ittaw na kanen an mabot.” ");
INSERT INTO cgc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gaisturya pa Juan ta paanggid, “Bai na kasalen, simpri para ta iya na nubyo. Bisan bai an dili para ta mama na abay, bakod man gyapon kalipay ta mama na abay tak gaasikaso kanen ta kasal daw kanen an duma man ta kasalen na mama daw gamati ta ambal ta kasalen na mama. Anduni iling man tan ake na kalipay tak napriparar ko en mga ittaw para ta pag-abot ta Pinili Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Matuman gid plano ta Dyos na kanen na Pinili Ta Dyos mas makala pa kaysa ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Igo gid na mas nakala Pinili Ta Dyos kaysa ki Juan tak Pinili an alin ta langit ya na istaran ta Dyos daw iya an na katengdanan pinakadatas ta tanan. Piro, mga ittaw na naan ta kalibutan i, taga-unti nang danen an daw iran man na ambal parti nang ta mga betang naan ta kalibutan i. ");
INSERT INTO cgc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kanen i na alin ta langit gasugid parti ta mga nakita daw mga namatian din naan ta langit, piro pila nang gapati ta iya na sugid. ");
INSERT INTO cgc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mga ittaw na gapati ta iya na sugid, danen gapamatuod na mga ambal ta Dyos matuod gid. ");
INSERT INTO cgc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kanen i na papadala ta Dyos alin ta langit gasugid ta mga ambal ta Dyos tak paatag ki kanen Dyos Ispiritu Santo an na magtabang na ula limitasyon. ");
INSERT INTO cgc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kanen i na papadala, kanen Bata ta Dyos Amay daw papalangga kanen i ta Dyos daw patugyanan ta tanan. ");
INSERT INTO cgc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bisan kino na gatuo ta Bata Ta Dyos, naangken din en kabui na ula katapusan na alin ta Dyos. Piro, bisan kino na ula gatuo ta Bata Ta Dyos, dili din maangken kabui na ula katapusan tak maageman din segeng na silot ta Dyos ta ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Paglambay ta pila na mga adlaw, nlaman Jesus na nabalitaan ta mga Pariseo na mas tama iya na mga tinudluan kaysa ta mga tinudluan Juan daw mas tama na mga ittaw na nabautismuan din. ");
INSERT INTO cgc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Piro, kanen i, ula gabautismo ta bisan kino. Iya an na mga tinudluan, danen gabautismo. ");
INSERT INTO cgc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na nlaman Jesus, galin danen Jesus naan ta Judea daw gabalik ta Galilea. ");
INSERT INTO cgc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta iran na pagpanaw munta ta Galilea, paengnged Jesus na magi danen naan ta lugar na Samaria. ");
INSERT INTO cgc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ta iran na pag-agi naan ta Samaria, giling danen ta banwa na paumaw na Sicar na dani nang ta basak na paatag Jacob ta bata din na Jose. ");
INSERT INTO cgc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Naan ta basak na ya bubon na nakutkot Jacob anay pa sa. Na ugto-adlaw, gamungko Jesus i naan ta tengnged ta bubon tak nakapuyan kanen an ta panaw. ");
INSERT INTO cgc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mga tinudluan ya Jesus gapanaw munta ta banwa aged malit ta pagkaan. Na gamungko Jesus, may gabot na bai na Samaritana aged mandok. Ambal Jesus ta bai an, “Daw pwidi, painemen a no.” ");
INSERT INTO cgc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sabat ta bai, “Di' ba kaon yan Judio? Yaken i Samaritana. Man-o tak gangayo ka ki yaken ta waig?” Iling tan ambal ta bai an tak mga Judio ula gatubay ta mga Samaritano. ");
INSERT INTO cgc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sabat Jesus, “Daw nlaman no inta daw ino atag na alin ta Dyos daw nakala a no man daw kino yaken i na gangayo ta waig ki kaon, mangayo ka inta ki yaken aged tagan ta kaw ta waig na mag-atag ta kabui.” ");
INSERT INTO cgc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ambal ta bai, “Sir, ula ka timba daw dili ka man kasalok tak yi na bubon sikad dalem. Indi ka magkamang ta waig na mag-atag ta kabui?” ");
INSERT INTO cgc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Insa pa ta bai ki Jesus, “Ino beet ambalen no? Imo na katengdanan mas datas pa kaysa ta katengdanan Jacob na kaapuan na ate na alinan? Kanen gaatag ta yi na bubon bilang ame na panublien daw gainem man ta waig na alin ta yi na bubon asta iya na mga bata daw mga ayep.” ");
INSERT INTO cgc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sabat Jesus, “Tanan na mga ittaw na minem ta waig na alin ta yi na bubon, mlao isab. ");
INSERT INTO cgc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Piro, bisan kino minem ta waig na atag ko, dili en mlao isab. Waig na pambal ko mag-atag ta kabui na ula katapusan na paryo ta tuburan na gailig na dili maubbasan.” ");
INSERT INTO cgc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ambal ta bai an, “Sir, tagan a no ta waig na pambal no aged dili aren mlao daw dili a man sigi balik-balik di na mandok.” ");
INSERT INTO cgc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ambal Jesus ta bai, “Muli ka daw umawen no sawa no ya daw malik kaw di ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Sabat ta bai, “Ula a sawa.” ");
INSERT INTO cgc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ambal Jesus, “Matuod ambal no an na ula ka sawa tak limma ka en bisis na gangasawa daw mama na gistar ki kaon anduni dili matuod no na sawa tak sawa-sawa no nang.” ");
INSERT INTO cgc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ambal ta bai, “Sir, ta panilag ko kaon yan prupita ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pwidi a no sugiran daw indi nay dapat simbaen Dyos an. Anay pa sa ame na mga kaapuan na mga Samaritano, pasimba danen Dyos an naan ta yi na bukid. Piro, kyo na mga Judio gambal na dapat na naan nang gid ta Jerusalem ya Dyos an simbaen ta mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ambal Jesus ta bai, “Kay, magpati ka ta ambal ko. Mabot timpo na dili en naan ta yi na bukid daw dili man naan ta Jerusalem simbaen ta mga ittaw Dyos Amay an. ");
INSERT INTO cgc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kyo na mga Samaritano ula kaw kakala daw kino pasimba nyo. Piro, kami na mga Judio, kala nay Dyos na pasimba nay tak paagi ki kami na mga Judio ipaintindi ta Dyos naan ta mga ittaw paagi an na maluwas danen alin ta iya na silot na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mabot en timpo daw anduni en na Dyos Amay an simbaen ta mga ittaw ta matuod tak iran na pagsimba terek ta iran na tagipusuon daw pasunod man danen kamatuuran na alin ki kanen. Iling tan liag ta Dyos Amay. ");
INSERT INTO cgc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dyos an, dili makita tak kanen ispiritu. Gani, kinanglan daw simbaen ta Dyos an, terek gid ta ate na tagipusuon daw pasunod ta man kamatuuran na alin ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ambal ta bai, “Nlaman ko daw mabot en Mesias na paumaw man na Pinili Ta Dyos Na Mag-ari, isaysay din ki kiten tanan an na parti ta mga sugo ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ambal Jesus, “Kanen ya na pambal no na mabot, yaken mismo na gaisturya ki kaon anduni.” ");
INSERT INTO cgc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na Jesus daw bai an gaisturyaay pa, mga tinudluan Jesus gabot daw gatingala gid danen an tak gaisturya Jesus naan ta isya na bai. Piro, ula isya ki danen gainsa daw ino kinanglan ta bai an daw man-o tak gaisturya Jesus ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pabilin dayon ta bai iya na sandukan daw gabalik kanen an naan ta banwa. Pag-abot din dya, gambal kanen an ta mga ittaw, ");
INSERT INTO cgc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mos, muyog kaw daw tan-awen nyo mama ya na gambal ki yaken parti ta tanan ko na pabuat. Kanen taan Pinili Ta Dyos Na Mag-ari.” ");
INSERT INTO cgc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pag-ambal ta bai, gapanaw kanen daw mga ittaw na paisturya din gakuyog na miling ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bag-o kabot naan ki Jesus bai ya daw mga ittaw na gakuyog, mga tinudluan Jesus sigi ambal ki kanen, “Mistro, maan ka en.” ");
INSERT INTO cgc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sabat Jesus ki danen, “May pagkaan a, piro ula nyo nlami.” ");
INSERT INTO cgc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pag-ambal Jesus, gatingala mga tinudluan din an daw gainsaay danen an, “May gadala di taan ta pagkaan ki kanen?” ");
INSERT INTO cgc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ambal Jesus ki danen, “Ta pagtuman ko ta liag ta gapadala ki yaken daw pagtuman ko man ta mga papabuat din ki yaken, paryo may pakaan a na gapabiskeg ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","May ambalanen na ‘Appat pa na bulan bag-o mabot tag-ani’. Piro, yi nang ake na maambal ki kyo: Tag-ani en anduni. Tan-awen nyo mga ittaw na gaprani en ki kiten na dapat tudluan aged magtuo ki yaken. Paryo danen ta tanem na naan ta uma na igo en anien daw dapat na umpisaan en pag-ani an. ");
INSERT INTO cgc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sigurado na kyo na magtudlo ki danen magbaton ta dayad na bales alin ta Dyos na paryo kaw ta mga manug-ani na magbaton ta iran na suol daw sigurado man na mga ittaw na paryo an inyo na anien tagan ta Dyos ta kabui na ula katapusan. Mga ittaw na gatanem daw mga ittaw na gaani mag-isya ta kalipay tenged ta dayad na risulta ta iran na pagpangabellay. ");
INSERT INTO cgc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","May isya pa na ambalanen: ‘Iba gamanggas, iba gaani.’ Ambalanen na i matuod gid ");
INSERT INTO cgc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","tak na papadala ta kyo, paryo kaw ta mga ittaw na gaani naan ta anian na ula danen gangabellay ta pagtanem. Duma gangabellay una ki kyo daw kyo gasubli nang en ta iran na ubra.” ");
INSERT INTO cgc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tama na mga Samaritano na taga-Sicar na gatuo ki Jesus tenged ta ambal ta bai ya ki danen na Jesus gambal parti ta tanan na buat ta bai ya. ");
INSERT INTO cgc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na gabot mga Samaritano naan ki Jesus, pawiran danen Jesus an na magtinir ki danen daw naan dya gatinir kanen an ta darwa na adlaw. ");
INSERT INTO cgc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tenged ta tudlo Jesus, gatama pa gid mga ittaw na gatuo ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mga ittaw na gatuo gambal ta bai ya, “Anduni, gatuo kay ki Jesus dili tenged nang ta imo na sugid. Gatuo kay ki kanen tenged kami i kamati ta iya na tudlo daw nlaman nay en na kanen gid Manluluwas para ta tanan na mga ittaw ta bilog na kalibutan.” ");
INSERT INTO cgc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Paglambay ta darwa adlaw na gatinir Jesus daw iya na mga tinudluan naan ta Sicar, gapanaw danen an daw giling ta Galilea na lugar na iya na alinan. ");
INSERT INTO cgc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Giling kanen dya maskin kaambal kanen an na mga prupita na manugsugid ta kabebet-en ta Dyos danen an ula pataura ta iran na mga kasimanwa. ");
INSERT INTO cgc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Piro, pag-abot danen Jesus naan ta Galilea, dayad na pagbaton ta mga ittaw ki kanen tak nakita ta mga ittaw tanan na mga buat din na naan kanen ta Jerusalem ta timpo ta Pista Ta Paglibri Alin Ta Egipto tenged mga ittaw an naan man dya ta pista ya. ");
INSERT INTO cgc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na naan pa danen Jesus ta Galilea, gabalik danen naan ta Cana na banwa na naan dya paimo Jesus waig ya na bino. Ta mga inadlaw na gabalik Jesus naan ta Cana, may upisyal ta gubirno na naan ta Capernaum na bata din gamasakit. ");
INSERT INTO cgc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na namatian ta upisyal na Jesus gabalik naan ta Galilea alin ta Judea, giling kanen an naan ta Cana daw gapangabay ki Jesus na megbeng anay naan ta Capernaum aged ayaren iya na bata na gatagumatayen en. ");
INSERT INTO cgc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ambal Jesus, “Man-o tak kyo na mga taga-Galilea gusto nyo gid na makita mga katingalaan na buat ko? Bisan dili nyo makita mga katingalaan na pamatuod daw kino a, magtuo kaw inta ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ambal ta upisyal ki Jesus, “Sir, daw pwidi nang, muyog ka anay megbeng mintras bui pa bata ko ya.” ");
INSERT INTO cgc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ambal Jesus, “Muli ka nang en. Bata no ya ayad en.” Gapati upisyal ya ta ambal Jesus daw gapanaw dayon na muli. ");
INSERT INTO cgc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na gapanaw kanen na muli, pasugat kanen an ta mga suguon din daw pasugiran na iya na bata ayad en. ");
INSERT INTO cgc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gainsa kanen ki danen daw ino uras umpisa na gaayad bata din ya. Dayon gasabat mga suguon din, “Kabii paglambay ta ugto-adlaw, ula en nadangga bata no ya.” ");
INSERT INTO cgc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nademdeman dayon ta upisyal na ta yon gid man na uras gambal Jesus na iya na bata ayad en. Tenged bata din ya paayad Jesus, kanen daw tanan din na mga sinakepan gatuo ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pagpaayad an Jesus ta bata ya, yon pangarwa na katingalaan na pabuat din na pamatuod daw kino kanen an. Nabuat din pangarwa an na katingalaan na gabalik kanen naan ta Galilea alin ta Judea. ");
INSERT INTO cgc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na gabot adlaw ta isya na pista ta mga Judio, giling isab Jesus naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Naan ta Jerusalem, dani ta agian ta mga karniro na paumaw na Gangaan Ta Mga Karniro, may languyan na paumaw naan ta linggwai na Hebreo na Betesda. Naan kilid ta waig may limma na silungan. ");
INSERT INTO cgc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Naan dya ganegga tama na mga ittaw na may dipirinsya ta lawa paryo ta mga bulag, piang daw paralitiko. Gatagad danen an daw mag-ulag waig an. ");
INSERT INTO cgc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kaysan may anen kon angil alin ta langit na giling naan ta waig aged ulagen. Bisan kino makauna tugmaw naan ta waig na paulag, mayad kanen an bisan ino pa iya na dipirinsya ta lawa. ");
INSERT INTO cgc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","May mama man dya na seled ta trintay-utso en taon na gamasakit. ");
INSERT INTO cgc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nakita Jesus na mama an ganegga dya daw nlaman din man na sikad lugay en mama an gamasakit. Painsaan din mama an, “Gusto no mayad?” ");
INSERT INTO cgc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sabat ta mama na gamasakit, “Sir, gusto ko inta, piro daw magbaled-baled waig an, ula may magdala ki yaken naan ta waig. Mintras na munta a nang pa dya, pirmi a naunaan ta duma.” ");
INSERT INTO cgc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ambal Jesus ta mama an, “Mangon ka. Dleen no ikam no an daw manaw.” ");
INSERT INTO cgc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dayon naayad mama an. Padala din iya na ikam daw manaw. Adlaw an na paayad Jesus mama ya, Adlaw Ta Pagpuay. ");
INSERT INTO cgc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mga manugdumala ta Judio gambal ta mama na nayad, “Anduni Adlaw Ta Pagpuay. Kuntra ta mga sugo naan ta Mga Sinulat Moises na mag-ubra ka bisan magdala ka nang ta imo na ikam.” ");
INSERT INTO cgc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sabat ta mama na nayad, “Ittaw ya na gapaayad ki yaken, kanen gasugo na dleen ko ake na ikam daw manaw.” ");
INSERT INTO cgc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Painsaan mama ya ta mga manugdumala ta Judio, “Kino ittaw ya na gasugo ki kaon na dleen no imo an na ikam daw manaw?” ");
INSERT INTO cgc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piro, ula nakala ta mama daw kino gapaayad ki kanen tak Jesus an gapanaw en daw naliperan ta tama na mga ittaw dya. ");
INSERT INTO cgc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Paglambay ta pila na mga uras na Jesus naan ta Timplo, nakita din isab mama na paayad din daw ambal din, “Ayad ka en. Dili ka en magbuat ta sala aged ula may matabo ki kaon na mas pa malain kaysa ta una.” ");
INSERT INTO cgc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pag-ambal Jesus, gapanaw mama an na malik naan ta mga manugdumala ta Judio daw gasugid na Jesus gapaayad ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yon tenaan na gaumpisa mga manugdumala ta Judio na magkuntra danen ki Jesus tak gapaayad kanen ta ittaw naan ta Adlaw Ta Pagpuay. ");
INSERT INTO cgc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Gambal Jesus naan ta mga manugdumala, “Ake na Amay gapadayon pa ta pag-ubra daw yaken i magpadayon man.” ");
INSERT INTO cgc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mga manugdumala ta Judio gaprusigir pa gid na ipapatay Jesus an tenged ula kanen gasunod ta iran na kaugalian parti ta Adlaw Ta Pagpuay daw tenged man paambal din pa na Dyos an iya na Amay na beet din ambalen na kanen daw Dyos isya nang ta uturidad. ");
INSERT INTO cgc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Gambal pa Jesus i naan ta mga manugdumala ta Judio, “Paumaw ko gid Dyos an na ake na Amay daw sugiran ta kyo na yaken na iya na Bata ula gabuat ta ake nang na liag. Pabuat ko daw ino nakita ko na pabuat ta ake na Amay tak daw ino pabuat din, yon man buaten ko. ");
INSERT INTO cgc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ake na Amay gapalangga ki yaken na Bata din. Gani, papakita din ki yaken tanan din na buat. Ipabuat din pa ki yaken katingalaan na mas pa kaysa ta mga pabuat ko en aged kyo magtingala gid. ");
INSERT INTO cgc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ake na Amay gabannaw ta mga patay daw gaatag ta kabui ki danen. Iling man tan yaken i na Bata din. Mag-atag a man ta kabui naan ta bisan kino na liag ko na atagan. ");
INSERT INTO cgc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ake na Amay ula gaukom ta mga ittaw daw kino matareng daw dili matareng. Piro, yaken na Bata din gaukom tak paatagan a din ta uturidad ta pag-ukom ");
INSERT INTO cgc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aged tanan na mga ittaw magtaod ki yaken paryo man ta iran na pagtaod ta ake na Amay. Bisan kino na ula gataod ki yaken, ula man gataod ta ake na Amay na gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mag-atag a gid ta kabui naan ta bisan kino na liag ko na tagan daw sugiran ta kyo na mga ittaw na gapati ta ake na mga ambal daw gatuo ta gapadala ki yaken, naangken en danen kabui na ula katapusan. Dili en danen an masintinsyaan ta silot na ula katapusan. Beet ambalen na danen an dili en naan ta dati danen na kabui na ulipen danen ta sala daw dapat masintinsyaan ta silot na ula katapusan. Naan danen en ta bag-o na kabui na naangken danen en kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sigurado gid na dili en danen an sintinsyaan ta kamatayen daw sugiran ta kyo na mabot en timpo, daw anduni en, na yaken na Bata Ta Dyos, ake an na mga ambal matian ta mga ittaw na ula pa gapati. Daw kino ki danen mapati ta ake na ambal, tagan ko danen an ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iling tan mabuat ko tak yaken i paryo ta ake na Amay na mag-atag ta kabui na ula katapusan tenged yaken na Bata din paatagan din ta uturidad ta pag-atag ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Natagan a man ta ake na Amay ta uturidad ta pag-ukom ta mga ittaw daw kino matareng daw dili matareng tak yaken i Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan. ");
INSERT INTO cgc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dili kaw magtingala ta ambal ko i tak mabot timpo na tanan na napatay mamatian danen ake na pag-umaw ki danen. ");
INSERT INTO cgc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pagmati danen, mabannaw danen an. Mga gabuat ta miad mabannaw na tagan ta kabui na ula katapusan. Piro, mga gabuat ta malain mabannaw na sintinsyaan ta ula katapusan na silot.” ");
INSERT INTO cgc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Gapadayon Jesus i ta ambal naan ta mga manugdumala ta Judio, “Ula a may pabuat ta ake nang na uturidad. Daw mag-ukom a ta mga ittaw daw kino matareng daw dili matareng, pasunod ko ambal ta ake na Amay. Yon en na ake na pag-ukom usto tenged ula ko sunura ake na liag. Pasunod ko nang pagbeet ta gapadala ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ambal pa Jesus, “Daw yaken nang magsugid parti ta ake na kaugalingen, dili a mapatian ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piro, may isya pa na gasugid parti ki yaken. Ake na Amay gasugid parti ki yaken daw nlaman ko na iya na sugid mapatian gid. ");
INSERT INTO cgc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“May mga ittaw na papadala nyo naan ki Juan daw kanen gasugid ki danen ta matuod parti ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Maski matuod sugid ta mga ittaw parti ki yaken, dili ko kinanglan iran na sugid para ipamatuod daw kino yaken i. Piro, papademdem ko nang ki kyo ambal ya Juan parti ki yaken aged daw mapati kaw ta iya na sugid, maluwas kaw alin ta silot ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan ya, kanen paryo ta pawa na lampraan tak iya na tudlo gapapawa ta isip ta mga ittaw. Ta lipo nang na timpo nalipay kaw ta iya na tudlo. ");
INSERT INTO cgc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Piro, may isya pa gid na pamatuod na mas pa gid mapatian kaysa ta pasugid Juan parti ki yaken. Mga katingalaan na papabuat ta ake na Amay ki yaken pamatuod na kanen gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ake na Amay na gapadala ki yaken, kanen mismo gapamatuod parti ki yaken daw kino yaken i. Piro, alin pa ta una asta anduni, ula nyo namatii iya na kagi daw ula nyo man nakita iya na sura. ");
INSERT INTO cgc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ula nyo man pabetang naan ta inyo na isip iya an na mga ambal tak ula kaw gatuo ki yaken na papadala din. ");
INSERT INTO cgc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gaistudyo kaw gid ta usto ta sinulat na pulong ta Dyos tak isip nyo na naan dya makita paagi an na maangken nyo kabui na ula katapusan. Naan man ta sinulat na pulong ta Dyos may ambal man parti ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Piro, dili kaw man gyapon miag na magtuo ki yaken. Daw magtuo kaw inta ki yaken, maangken nyo kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ula a gapaabot na dayawen a nyo ");
INSERT INTO cgc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","tak kala ta kyo daw nlaman ko man na ula kaw gagugma ta Dyos na terek gid ta inyo na tagipusuon. ");
INSERT INTO cgc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bisan ake na Amay gapadala ki yaken naan ta kalibutan i daw ake na uturidad alin ki kanen, ula a nyo man gyapon pabaton. Piro, daw may mabot na duma na iya na uturidad alin ta iya nang na kaugalingen, pabaton nyo dayon. ");
INSERT INTO cgc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Impusibli na magtuo kaw ki yaken tak gapaabot kaw na dayawen kaw ta mga paryo nyo na ittaw piro ula kaw gatingwa na dayawen kaw ta matuod na Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Dili kaw mag-isip na yaken magkusar ki kyo naan ta ake na Amay. Moises ya, na iya na mga sinulat alinan ta inyo na palaeman, kanen mismo magkusar ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Daw gapati kaw ki Moises, magpati kaw man inta ki yaken tak Moises gasulat parti ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tenged ula kaw gapati ta mga sinulat Moises, simpri dili kaw man magpati ta ake na mga ambal.” ");
INSERT INTO cgc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Paglambay ta pila na mga adlaw, Jesus daw iya na mga tinudluan galakted naan ta liyo ta Dagat Galilea na paumaw man na Dagat Tiberias. ");
INSERT INTO cgc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Naan dya, sikad tama na mga ittaw gasunod ki Jesus tak nakita danen mga katingalaan na pabuat din na paayad din mga ittaw na may masakit. ");
INSERT INTO cgc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Gatukad kanen daw iya na mga tinudluan naan ta bungyod daw gapungko danen dya. ");
INSERT INTO cgc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ta yon man na timpo, dali nang en mag-umpisa pista ta mga Judio na paumaw na Pista Ta Paglibri Alin Ta Egipto. ");
INSERT INTO cgc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na naan danen Jesus ta bukid, nabantaw din na sikad tama na mga ittaw na munta ki kanen. Gainsa kanen ki Felipe, “Indi ki malit ta pagkaan para ta yon na mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nlaman en Jesus daw ino iya na buaten, piro iling tan iya na insa tak liag din na ipakita Felipe daw ino kabakod pagsalig Felipe ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Sabat Felipe ki kanen, “Maskin darwa gatos na sinsilyo na pilak gamiten ta para ipalit ta tinapay, kulang man gyapon ta yon na mga ittaw bisan tise nang iran na kan-enen.” ");
INSERT INTO cgc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Isya ta mga tinudluan Jesus na ngaran din Andres na utod Simon Pedro ");
INSERT INTO cgc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","gambal ki Jesus, “May bata di na kadala ta limma buok na tinapay daw darwa buok na sidda. Piro, nuon ta ni ta iling san katamaen ta mga ittaw!” ");
INSERT INTO cgc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pasugo Jesus iya na mga tinudluan, “Papungkuon nyo tanan na mga ittaw.” Wayang lugar an dya daw may lamunon. Naan dya mga ittaw gapungko. Katamaen ta mga mama nang pa mga limma libo en. ");
INSERT INTO cgc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dayon pakamang Jesus tinapay an daw gapasalamat ta Dyos. Papatagtag din naan ta mga ittaw daw ino katamaen na gusto danen. Yon man pabuat din ta sidda an. ");
INSERT INTO cgc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kakaan danen tanan daw nabusog. Pagtapos danen kaan, gambal Jesus i naan ta iya na mga tinudluan, “Tipunon nyo mga sama an aged dili masayang.” ");
INSERT INTO cgc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dayon patipon ta mga tinudluan tinapay na ula nakaan ta mga ittaw. Napanno danen dusi na baskit na darko ta mga sama na alin ta limma na tinapay. ");
INSERT INTO cgc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pagkita ta mga ittaw ta katingalaan na pabuat Jesus, ambal danen, “Jesus gid prupita ya na pambal ta Dyos anay pa sa na mabot unti ta kalibutan i.” ");
INSERT INTO cgc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nlaman en Jesus tuyo ta mga ittaw na kamangen kanen aged piliten danen kanen an na buaten na ari. Tenged nlaman din iran na tuyo, galin kanen dya daw gatukad naan ta isya na bukid na kanen nang isya. ");
INSERT INTO cgc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na semsem en ta adlaw na papakaan Jesus subla limma libo na ittaw, mga tinudluan din gategbeng naan ta baybay. ");
INSERT INTO cgc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Gasakay danen ta buti aged makted naan ta Dagat Galilea na malik ta Capernaum. Ta iran na pagsakay, kilem en daw ula pa kabalik Jesus ya ki danen. ");
INSERT INTO cgc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na galakted danen an, gadarko baled an tak sikad pelles. ");
INSERT INTO cgc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na kalambot danen ta mga tallo tenga milyas na kamadyuon ta iran na paggayong, nakita danen na gapanaw Jesus an naan apaw ta waig na gaprani ta iran na sakayan. Nadlek gid danen an. ");
INSERT INTO cgc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ambal Jesus ki danen, “Yaken ni. Dili kaw madlek.” ");
INSERT INTO cgc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pag-ambal Jesus, nalipay gid danen daw pasakay danen kanen an. Pagsakay Jesus, kadungka dayon danen an naan ta iran na ilingan. ");
INSERT INTO cgc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ta sunod na adlaw, mga ittaw an ula pa galin ta yon man na lugar na naan ta liyo ta dagat na naan danen dya kakaan ta tinapay pagtapos Ginuo Jesus ta pagpasalamat. Nademdeman danen na naan ta galambay ya na kilem may anen dya isya nang na buti daw mga tinudluan nang Jesus kasakay ya. Jesus an ula gakuyog ki danen. Na gakullaw pa mga ittaw an daw indi Jesus, may mga buti na gadungka dya na naan galin ta Tiberias. ");
INSERT INTO cgc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pagkita ta mga ittaw na ula dya Jesus an daw mga tinudluan din, gasakay danen ta mga buti daw giling ta Capernaum aged ngitaen danen kanen ya. ");
INSERT INTO cgc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pag-abot ta mga ittaw naan ta liyo na baybay, nakita danen Jesus an daw painsaan danen, “Mistro, kan-o ka pa di?” ");
INSERT INTO cgc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Sabat Jesus, “Miad gid insa nyo an a, piro gambal a ki kyo na papangita a nyo dili tenged naintindian nyo daw ino beet ambalen ta mga katingalaan na pabuat ko. Pangita a nyo gid tenged na kakaan kaw ta tinapay daw nabusog. ");
INSERT INTO cgc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dili kaw magpangabellay para nang ta pagkaan na ula galugay. Magpangabellay kaw para ta pagkaan na gapadayon na mag-atag ta kabui na ula katapusan. Mag-atag an ki kyo ta yi na kabui Yaken Na Alin Ta Langit Na Natao Naan Ta Kalibutan tak yaken paatagan ta Dyos Amay ta uturidad ta pag-atag ta kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mga ittaw gainsa ki Jesus, “Ino dapat nay na buaten aged matuman nay liag ta Dyos?” ");
INSERT INTO cgc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Sabat Jesus, “Yi liag ta Dyos na dapat nyo buaten: Magtuo kaw ki yaken na papadala din.” ");
INSERT INTO cgc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Insa ta mga ittaw, “Ino katingalaan na mabuat no aged may makita kay na pamatuod para mapati kay ki kaon? Ino gid buaten no? ");
INSERT INTO cgc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Anay pa sa, ate na mga kaapuan gatinir naan ta lugar na ula kabalayan. Naan dya gakaan danen an ta pagkaan na alin ta langit. Naan ta sinulat na pulong ta Dyos may ambal, ‘Danen paatagan ta pagkaan na alin ta langit para kan-enen danen.’” ");
INSERT INTO cgc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sabat Jesus, “Matuod gid na paatagan danen an ta pagkaan alin ta langit, piro gambal a ki kyo na dili Moises gaatag ki danen ta pagkaan na alin ta langit. Ake na Amay gaatag ki danen ta pagkaan na alin ta langit anay pa sa, daw anduni, iatag din en ki kyo matuod na pagkaan na alin ta langit. ");
INSERT INTO cgc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pagkaan na atag ta Dyos ula duma daw dili, kanen i na giling ta kalibutan alin ta langit aged mag-atag ta kabui na ula katapusan naan ta mga ittaw ta kalibutan.” ");
INSERT INTO cgc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ambal ta mga ittaw, “Sir, iatag no pirmi ki kami iling sa na pagkaan na pambal no.” ");
INSERT INTO cgc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ambal Jesus, “Yaken pagkaan na mag-atag ta kabui na ula katapusan. Bisan kino magtuo na magpasakep ki yaken, dili en maletem daw dili man en mlao. ");
INSERT INTO cgc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piro, bisan nakita a nyo, ula kaw pa man gyapon gatuo ki yaken paryo ta naambal ko en ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tanan na mga ittaw na patugyan ta Amay ko ki yaken, magtuo na magpasakep ki yaken. Bisan kino na magtuo na magpasakep ki yaken, sigurado gid na batunon ko. ");
INSERT INTO cgc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Giling a naan ta kalibutan i alin ta langit dili para magtuman ta ake nang na liag. Giling a di para magtuman ta liag ta gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yi liag ta gapadala ki yaken: Ambligan ko tanan na mga ittaw na patugyan din ki yaken aged ula bisan isya ki danen marwad ki yaken. Bannawen ko danen an naan ta katapusan na adlaw ");
INSERT INTO cgc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","tak liag ta ake na Amay na tanan na mga ittaw na kakala daw gatuo ki yaken na Bata din, maangken danen kabui na ula katapusan daw bannawen ko man danen an naan ta katapusan na adlaw.” ");
INSERT INTO cgc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mga Judio na anen dya, pagmati danen ta ambal Jesus, gagumod danen kuntra ki kanen tak ambal din na kanen pagkaan na alin ta langit. ");
INSERT INTO cgc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ambal danen, “Di' ba Jesus nang man nyan na bata Jose? Kala ta iya an na amay daw inay. Man-o tak ambal din na kanen an alin ta langit?” ");
INSERT INTO cgc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ambal Jesus ki danen, “Dili kaw sali ta gumod. ");
INSERT INTO cgc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ake na Amay na gapadala ki yaken, daw ula din betanga naan ta isip ta mga ittaw liag an na danen an magtuo na magpasakep ki yaken, impusibli na danen an magtuo na magpasakep ki yaken. Mga ittaw na magtuo na magpasakep ki yaken bannawen ko naan ta katapusan na adlaw. ");
INSERT INTO cgc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Naan ta Mga Sinulat Ta Mga Prupita may ambal, ‘Tanan danen tudluan ta Dyos.’ Gani, bisan kino na gamati daw gatuman ta mga tudlo ta Dyos Amay, kanen magtuo na magpasakep ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dili beet ko ambalen na may ittaw na kakita en ta Dyos Amay. Ula duma na kakita ta Dyos daw dili, yaken nang na alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yaken nang gid kakita ta Dyos daw sugiran ta kyo na bisan kino na gatuo ki yaken, may kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yaken pagkaan na mag-atag ta kabui. ");
INSERT INTO cgc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Anay pa sa na inyo ya na mga kaapuan gatinir naan ta lugar na ula kabalayan, gakaan danen ta pagkaan na alin ta langit, piro napatay man gyapon danen ya. ");
INSERT INTO cgc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Piro, yaken i pagkaan na alin ta langit. Bisan kino maan ti na pagkaan, dili en mapatay. ");
INSERT INTO cgc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yaken i pagkaan na alin ta langit na mag-atag ta kabui. Bisan kino na maan ta yi na pagkaan, mabui ta ula katapusan. Pagkaan na pambal ko ake na lawa na iatag ko para ta mga ittaw ta bilog na kalibutan aged maangken danen kabui na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mga Judio na anen dya, na namatian danen ambal Jesus, gadiskasay gid danen an, “Ino paagi na iatag din ki kiten iya an na lawa para kan-enen ta?” ");
INSERT INTO cgc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ambal Jesus ki danen, “Yaken gid pagkaan na mag-atag ta kabui daw sugiran ta kyo na Yaken i Na Alin Ta Langit Na Natao Naan Ta Kalibutan, daw dili kaw maan ta lawa ko daw minem ta ake na lengngessa, impusibli na maangken nyo kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bisan kino maan ta ake na lawa daw minem ta ake na lengngessa, maangken din kabui na ula katapusan daw bannawen ko man kanen an naan ta katapusan na adlaw. ");
INSERT INTO cgc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ake na lawa pagkaan na matuod daw ake na lengngessa inemen na matuod. ");
INSERT INTO cgc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bisan kino maan ta ake na lawa daw minem ta ake na lengngessa, pirmi kanen naan ki yaken daw pirmi a man naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ake na Amay na gapadala ki yaken alinan ta kabui daw bui a tenged ki kanen. Iling man tan, mga ittaw na maan ta ake na lawa, mabui danen an tenged ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yaken matuod na pagkaan na alin ta langit. Yaken dili paryo ta pagkaan ya na alin ta langit na pakaan ta inyo na mga kaapuan anay pa sa tak napatay man gyapon danen ya. Piro, bisan kino maan ta matuod na pagkaan, mabui kanen an ta ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yi patudlo Jesus na naan kanen ta balay tipunan ta mga Judio naan ta Capernaum. ");
INSERT INTO cgc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na kamati mga tinudluan Jesus ta ambal din parti ta iya na lawa daw lengngessa, tama ki danen gambal, “Sikad gid bellay iya na tudlo. Kino taan magpati tan?” ");
INSERT INTO cgc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bisan ula may gasugid ki Jesus, nlaman din na gagumod iya na mga tinudluan tenged ta iya na tudlo. Ambal din ki danen, “Nalainan kaw gid ta ake ya na tudlo? ");
INSERT INTO cgc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ino pa gid taan daw makita nyo na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan gabalik naan ta iya na alinan? ");
INSERT INTO cgc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dyos Ispiritu Santo an gaatag ta kabui. Mga ittaw an a, dili maimo na danen mag-atag ta kabui. Bisan kino na magpati ta ake na ambal, Dyos Ispiritu Santo an magpabilin naan ki kanen daw mag-atag man ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piro, may anen ki kyo na ula gapati ta ake na ambal.” Iling tan ambal Jesus tak alin pa ta umpisa na napili din iya na mga tinudluan, nlaman din en daw kino ki danen dili magpati daw kino man magtraydor ki kanen ta uryan. ");
INSERT INTO cgc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ambal pa Jesus naan ta iya na mga tinudluan, “Tenged may anen ki kyo na dili magpati, yon tenaan na paambal ko ki kyo kan-o na daw ula betanga ta ake na Amay na gapadala ki yaken liag an naan ta isip ta mga ittaw na danen an magtuo na magpasakep ki yaken, impusibli na danen an magtuo na magpasakep ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Umpisa ta yon man na uras na gatudlo Jesus parti ta iya na lawa daw lengngessa, padilian en kanen an ta tama na mga ittaw na dati gasunod ki kanen. Ula en danen an gakuyog ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Gainsa Jesus ta dusi na apustulis, “Ta? Dilian a nyo man?” ");
INSERT INTO cgc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sabat Simon Pedro ki Jesus, “Ginuo, ula kay duma na dangepan daw dili, kaon nang tak gatudlo ka parti ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Gapati kay ki kaon daw nlaman nay man na kaon yan alin gid ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ambal Jesus, “Di' ba papili ko kyo yan na dusi, piro may isya ki kyo na gasunod ki Satanas?” ");
INSERT INTO cgc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas na bata Simon Iscariote, kanen pambal ya Jesus na gasunod ki Satanas. Bisan Judas isya ta dusi na apustulis, ta uryan kanen an magtraydor ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagtapos Jesus ta iya na pag-isturya naan ta mga apustulis, galibot kanen an naan ta bilog na Galilea. Engnged din gid na dili kanen an miling naan ta Judea tak duma na mga manugdumala ta Judio gaprusigir gid na ipapatay kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na dali nang en mabot timpo na mag-umpisa pista ta mga Judio na paumaw na Pista Ta Mga Pasilungan, ");
INSERT INTO cgc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","mga utod Jesus gambal ki kanen, “Dayad daw malin ka di na miling ta Judea aged makita man ta mga tinudluan no dya mga katingalaan na paryo ta mga nabuat no ");
INSERT INTO cgc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","tak bisan kino na gusto mabantog, dili kanen magbuat na tago nang. Tenged gabuat ka ta mga katingalaan, dapat ipakita no naan ta tanan na mga ittaw bisan indi nang.” ");
INSERT INTO cgc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Paagi ta iran na ambal na iling tan pakita danen na bisan danen an mga utod Jesus, ula danen gapati ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sabat Jesus ta mga utod din, “Kyo a pwidi mag-iling naan ta pista bisan ino na uras. Piro, yaken i a, dili pa igo na uras aged matuman plano ta Dyos para ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Pwidi kaw tak ula tenaan na kyo yan demetan ta mga ittaw na ula gapati ta Dyos. Piro, yaken i a demetan danen tak paambal ko na iran na mga buat malain. ");
INSERT INTO cgc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gani, kyo nang manaw na mamista. Dili a nang ake manaw tak dili pa ake na uras.” ");
INSERT INTO cgc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pag-ambal Jesus, gapabilin kanen naan ta Galilea. ");
INSERT INTO cgc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pagpanaw ta mga utod Jesus na mamista naan ta Pista Ta Mga Pasilungan, gapanaw man kanen an, piro ula kanen an gapakita ta mga ittaw aged ula may nalam. ");
INSERT INTO cgc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Naan ta pista papangita Jesus an ta mga manugdumala ta Judio na gakuntra ki kanen. Sigi danen insa daw indya kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tama na mga ittaw dya daw sigi gaisturyaay danen an ta inay-inay nang parti ki Jesus. Duma gambal, “Miad kanen na ittaw.” Piro, duma an a gagumod, “Dili kanen an miad tak paluko din nang mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Piro, gambal danen ta sikrito nang parti ki Jesus tak adlek danen an ta mga manugdumala ta Judio na gakuntra ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na naan en ta katengaan ta pista ya, giling Jesus naan ta Timplo daw naan dya gatudlo. ");
INSERT INTO cgc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Gatingala gid mga manugdumala ta Judio tenged ta tudlo din daw gambal danen an, “Indi alin alam ta yi na ittaw tak ula kanen patudlui ta manugtudlo na may datas alam parti ta Mga Sinulat Moises?” ");
INSERT INTO cgc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sabat Jesus ki danen, “Ake na patudlo dili alin ta kaugalingen ko na isip. Patudlo ko an naan alin ta gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bisan kino na magtingwa na magtuman ta kabebet-en ta Dyos, mlaman din na ake na patudlo dili ake nang. Mlaman din na patudlo ko an naan alin ta Dyos ");
INSERT INTO cgc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","tak bisan kino na gatudlo alin ta iya na kaugalingen na isip, liag din na kanen an dayawen ta mga ittaw. Piro, bisan kino na iya na liag na gapadala ya ki kanen dayawen ta mga ittaw, masaligan kanen an na ittaw daw ula man gabula. ");
INSERT INTO cgc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Anay pa sa, paatag ta Dyos ki kyo iya na mga sugo paagi ki Moises, piro ula bisan isya ki kyo gatuman ta tanan na mga sugo din. Daw pagtuman nyo ta mga sugo ya terek ta inyo na nakem, ula kaw inta gaplano na ipapatay a nyo.” ");
INSERT INTO cgc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ambal ta mga ittaw, “Naseddepan ka taan ta malain na ispiritu. Kino abi gaplano na ipapatay ka?” ");
INSERT INTO cgc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ambal Jesus naan ta mga ittaw, “Gatingala kaw gid na man-o tak gapaayad a ta isya na mama naan ta Adlaw Ta Pagpuay. ");
INSERT INTO cgc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Di' ba kyo man kaysan gaubra naan ta Adlaw Ta Pagpuay na gabuat kaw ta sirimunya ta pagbuat ta tanda naan ta lawa ta bata? Naan ta Mga Sinulat Moises, pasulat din sugo ya ta Dyos na naan ta pangwallo na adlaw alin ta pagtao buatan nyo ta tanda lawa an ta mga bata nyo na mama na beet ambalen na danen iya ta Dyos. -- Ta matuod, ate na mga kaapuan anay pa sa, gabuat en ta yi na sirimunya bag-o pa ta timpo Moises. -- Piro, bisan natuon naan ta Adlaw Ta Pagpuay sirimunya ta pagbuat ta tanda naan ta lawa, gapadayon kaw man gyapon ta pagbuat ta tanda aged masunod nyo nang sugo ya. ");
INSERT INTO cgc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tenged gapadayon kaw ta pagbuat ta tanda naan ta isya nang na parti ta lawa maskin naan pa ta Adlaw Ta Pagpuay aged dili kaw maakusaran na ula gasunod ta mga sugo naan ta Mga Sinulat Moises, man-o tak gagilek kaw pa ki yaken na papaayad ko bilog na kalawaan ta isya na mama naan ta Adlaw Ta Pagpuay? ");
INSERT INTO cgc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dili nyo usgaran ittaw an tenged nang ta inyo na nakita ki kanen. Bag-o kaw mag-usgar ta duma usisaen nyo anay iya na buat aged mlaman nyo daw miad daw malain.” ");
INSERT INTO cgc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na naan Jesus ta Jerusalem na gatudlo naan ta Timplo, naan man dya pila na mga taga-Jerusalem na gaisturyaay, “Di' ba kanen i ittaw na papangabot na ipapatay ta ate na mga manugdumala? ");
INSERT INTO cgc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Piro, bisan na galaygay kanen i naan ta tubangan ta tama na mga ittaw, ula man danen an gambal kuntra ki kanen. Nakala danen taan na kanen i Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Basi dili kanen Pinili Ta Dyos tak nlaman ta gid daw taga indi kanen an. Daw mabot Pinili ya Ta Dyos, ula may nalam daw taga indi kanen ya.” ");
INSERT INTO cgc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tenged iling tan iran na ambal parti ki Jesus, patuduan din gid iya na kagi na gatudlo pa kanen an naan ta Timplo na ambal din, “Salig nyo na kala a nyo en daw taga indi a. Ula a giling ta kalibutan i ta ake nang na liag. May gapadala ki yaken na iya na ambal ubos kamatuuran. Dili nyo kanen an kala, ");
INSERT INTO cgc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","piro kala ko gid kanen an tak kanen mismo alinan ko daw kanen man gapadala ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tenged ta ambal Jesus, dakepen inta kanen an ta mga manugdumala ta Judio. Piro, ula may gadakep ki kanen tak dili pa uras din na matuman plano ta Dyos para ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Maskin mga manugdumala ta Judio gakuntra ki Jesus, gatama man gyapon mga ittaw na gatuo ki kanen. Ambal danen, “Basi yi en Pinili Ta Dyos Na Mag-ari tak sigurado gid na ula ittaw na makabuat ta katingalaan na mas pa makatingala ta mga nabuat din.” ");
INSERT INTO cgc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na namatian ta mga Pariseo ambal ya ta mga ittaw parti ki Jesus, danen daw mga manugdumala na mga pari gasugo ta mga gwardya ta Timplo na dakepen Jesus an. ");
INSERT INTO cgc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tenged may plano na ipadakep Jesus an, ambal din naan ta mga ittaw, “Dili aren maglugay na magduma ki kyo tak malik a naan ta gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mangita kaw gid ki yaken, piro dili a nyo makita tak dili kaw makailing ta ake na ilingan.” ");
INSERT INTO cgc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mga manugdumala ta Judio na gakuntra ki Jesus, gainsaay danen an, “Indi kanen an punta na dili ta makita? Ino, miling kanen ta mga paryo ta na mga Judio na naan gistar ta mga lugar ta mga dili-Judio daw magtudlo kanen an dya? ");
INSERT INTO cgc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ino beet ambalen din na ngitaen ta kanen an, piro dili ta en makita daw dili ki man makailing ta ilingan din?” ");
INSERT INTO cgc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gabot katapusan na adlaw ta Pista Ta Mga Pasilungan na ta isip ta mga Judio pinakaimpurtanti na adlaw ta pista. Ta yon man na adlaw anen Jesus an naan ta Timplo. Gatindeg kanen an daw patuduan din iya na kagi na ambal din, “Bisan kino na nlao, marani ki yaken aged minem. ");
INSERT INTO cgc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bisan kino na magtuo ki yaken, may anen ki kanen paryo ta ambal naan ta sinulat na pulong ta Dyos na iling ti: Naan ta iran na tagipusuon may mag-atag ta kabui na ula katapusan na paryo ta tuburan na bui.” ");
INSERT INTO cgc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ta pag-ambal Jesus ta iling tan, paambal din an parti ta Dyos Ispiritu Santo na mabaton pa ta mga gatuo ki kanen. Piro, ula pa danen nabaton tak Jesus an ula pa napatay, nabannaw daw gabalik naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mga ittaw na kamati ta ambal Jesus, gambal, “Kanen gid papaabot ta na prupita na manugsugid ta kabebet-en ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Duma na mga ittaw gambal, “Kanen an Pinili Ta Dyos Na Mag-ari.” Piro, duma pa gid an gambal, “Dili taan kanen Pinili Ta Dyos tak alin kanen ta Galilea daw nlaman ta na Pinili Ta Dyos dili alin ta Galilea. ");
INSERT INTO cgc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Naan ta sinulat na pulong ta Dyos may ambal na Pinili Ta Dyos alin ta linai David daw matao naan ta Betlehem na banwa David.” ");
INSERT INTO cgc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Isip ta mga ittaw parti ki Jesus ula gaparyo. ");
INSERT INTO cgc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Gusto ta duma na dakepen Jesus an, piro ula man gyapon danen padakepa kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mga gwardya ta Timplo na pasugo na dakepen Jesus an, gabalik danen naan ta mga manugdumala na mga pari daw mga Pariseo na gasugo ki danen. Gainsa mga manugdumala an, “Man-o tak ula nyo dakepa Jesus ya daw dleen di?” ");
INSERT INTO cgc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sabat ta mga gwardya, “Ula gid ittaw na mas dayad iya na patudlo kaysa ta patudlo Jesus.” ");
INSERT INTO cgc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mga Pariseo an gambal ta mga gwardya, “Asta kyo yan, naluko kaw man Jesus! ");
INSERT INTO cgc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ula bisan isya ki kami na mga manugdumala na mga pari daw mga Pariseo gapati ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mga ittaw na ula kaintindi ta sinulat Moises, danen nang gapati ki Jesus. Lagen ta daw dili danen an silutan ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Anen man dya Nicodemo na isya man na Pariseo na kabisita ki Jesus na bag-o nang umpisa Jesus an ta iya na pagtudlo. Nicodemo gambal ta mga duma din na gadumala, ");
INSERT INTO cgc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kuntra ta mga sugo naan ta Mga Sinulat Moises na magsintinsya ki ta ittaw na ula ta pa kanen nausisa daw ino nabuat din na sala.” ");
INSERT INTO cgc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mga manugdumala gagilek ki Nicodemo tak paryas kanen gakampi ki Jesus. Pambalan danen Nicodemo an, “Paryo ka imo taga-Galilea paryo ki Jesus! Usisaen no anay sinulat na pulong ta Dyos aged makita no gid na ula prupita na alin ta Galilea.” ");
INSERT INTO cgc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagtapos ta iran na pagdiskasay, guli danen an tanan. ");
INSERT INTO cgc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ta katapusan ta Pista Ta Mga Pasilungan, Jesus i giling naan ta Bukid Olibo. Kadlaw kanen i dya. ");
INSERT INTO cgc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sunod na adlaw na sellem pa gid, gabalik kanen i naan ta Timplo daw tama na mga ittaw galibot ki kanen. Gapungko kanen daw gatudlo ki danen. ");
INSERT INTO cgc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na gatudlo pa Jesus, may mga manugtudlo ta Mga Sinulat Moises daw mga Pariseo na gadala ta isya na bai na nadakep na gaintra ta mama. Patindeg danen bai an naan ta tubangan ta mga ittaw na gamati ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ambal danen ki Jesus, “Mistro, yi na bai nadakep na gaintra ta mama. ");
INSERT INTO cgc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Naan ta Mga Sinulat Moises may sugo na mga bai na gaintra ta mama dapat sintinsyaan ta kamatayen paagi ta pagtimbag ta mga bato. Ino maambal no parti ta yi na bai?” ");
INSERT INTO cgc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iling tan insa danen aged dakep-dakepen Jesus an paagi ta insa para maakusaran daw may ambalen kanen an na kuntra ta Mga Sinulat Moises. Piro, Jesus an gademel nang daw gasulat kanen naan ta basak paagi ta iya na tudlo. ");
INSERT INTO cgc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tenged na sigi pa insa danen ki Jesus parti ta bai, gatan-aw kanen ki danen daw ambal din, “Daw kino ki kyo ula sala, yon una na magtimbag ta yi na bai.” ");
INSERT INTO cgc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pagtapos ta pag-ambal Jesus, gademel kanen isab daw gasulat naan ta basak. ");
INSERT INTO cgc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagmati ta mga ittaw dya, isya-isya danen galin, umpisa ta mga manakem asta na Jesus nang en nabilin daw bai na gatindeg pa dya. ");
INSERT INTO cgc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na Jesus daw bai nang en nabilin dya, patan-aw Jesus bai an daw painsaan din, “Indya en danen ya? Ula bisan isya na magsilot ki kaon?” ");
INSERT INTO cgc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sabat ta bai, “Ee, Sir. Ula bisan isya.” Ambal Jesus, “Dili a man ake magsilot ki kaon. Pwidi ka en manaw, piro dili ka en magbuat isab ta sala.” ");
INSERT INTO cgc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na gatudlo Jesus i naan ta mga ittaw, gambal kanen i, “Yaken ilaw para ta tanan na mga ittaw. Bisan kino na magpati ki yaken, pawaan ko iya na isip daw tagan ko man kanen an ta kabui na ula katapusan. Daw iling tan buaten ko ki kanen, paryo kanen dili en magpanaw pa naan ta delem tak napawaan kanen an ta ilaw.” ");
INSERT INTO cgc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pagmati ta mga Pariseo, ambal danen, “Tenged sugid no an parti ta imo na kaugalingen imo nang na ambal, dili kay magpati ta imo na sugid.” ");
INSERT INTO cgc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sabat Jesus, “Bisan yaken gasugid parti ta ake na kaugalingen, matuod man gyapon ake na sugid tak nlaman ko ake na alinan daw ake na ilingan, piro kyo, ula nyo nlami. ");
INSERT INTO cgc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gausgar kaw ta mga ittaw paagi nang ta inyo na nakita. Piro, dili iling tan ake na pag-ukom ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Daw mag-ukom a, usto gid tak dili nang yaken gaukom. Darwa kay gaukom, yaken daw ake na Amay na gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Naan ta Mga Sinulat Moises may ambal na daw sugid an ta darwa na ittaw gaparyo, matuod gid iran an na sugid. ");
INSERT INTO cgc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yaken daw ake na Amay gasugid parti ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Gainsa mga Pariseo ki Jesus, “Indi imo na Amay?” Sabat Jesus, “Dili a nyo kala daw dili nyo man kala ake na Amay. Daw kala a nyo inta, kala nyo man ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iling tan ambal Jesus na gatudlo kanen naan ta Timplo na dani kanen an ta betangan ta alad na kwarta. Piro, ula may gadakep ki kanen tak dili pa iya na uras na matuman plano ta Dyos para ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na gatudlo Jesus i naan ta Timplo, gambal kanen ta mga ittaw, “Malin a di. Pag-alin ko, mangita kaw ki yaken. Piro, dili kaw makailing ta ake na ilingan tak mapatay kaw na dili kaw mapatawad ta Dyos tenged ta inyo na sala na ula kaw gapati ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pagmati ta mga manugdumala ta Judio dya ta ambal Jesus, gaisturyaay danen an, “Ino beet ambalen din na dili ki makailing ta iya na ilingan? Basi magpakamatay kanen an.” ");
INSERT INTO cgc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ambal Jesus ki danen, “Kyo yan taga-kalibutan daw inyo na isip paryo nang ta isip ta mga ittaw na ula gapati ta Dyos, piro yaken i a taga-langit daw ake na isip dili paryo ta isip ta mga ittaw na ula gapati ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pambal ko na mapatay kaw na dili kaw mapatawad ta Dyos tenged ta inyo na sala. Daw dili kaw mapati na yaken i pambal ko ya na yaken, sigurado gid na dili kaw mapatawad ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Gainsa danen ki Jesus, “Kino ka gid?” Sabat Jesus, “Alin pa kan-o na gaumpisa a ta pagtudlo ta mga ittaw, nasugid ko en daw kino yaken i. ");
INSERT INTO cgc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tama a inta iakusar ki kyo. Piro, ula a duma na ambalen naan ta tanan na mga ittaw ta kalibutan daw dili, ake nang na namatian alin ta gapadala ki yaken. Yon nang ambalen ko tak iya na ambal kamatuuran.” ");
INSERT INTO cgc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ula danen naintindian na pambal din ya na gapadala ki kanen beet din ambalen iya na Amay. ");
INSERT INTO cgc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ambal pa Jesus ki danen, “Pagtapos na ipadatas Kanen i Na Alin Ta Langit Na Natao Naan Ta Kalibutan, maintindian nyo en na yaken i pambal ko ya na yaken. Maintindian nyo man na ula a gabuat daw gambal ta ake nang na uturidad tak pasunod ko nang tudlo ta ake na Amay ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ake na Amay na gapadala ki yaken pirmi kanen duma ki yaken. Ula a din pabay-i tak pirmi a gabuat ta makapalipay ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na gambal Jesus ta iling tan, tama gatuo ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na gatudlo pa Jesus i ta mga ittaw naan ta Timplo, gambal kanen naan ta mga Judio na gapati ki kanen, “Daw magpadayon kaw ta pagtuman ta ake na tudlo, kyo matuod ko na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mlaman nyo man kamatuuran an daw paagi ta kamatuuran an, malibri kaw.” ");
INSERT INTO cgc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ambal danen, “Kami i mga linai Abraham. Ula kay gapasakep naan ta pagbeet ta bisan kino. Man-o tak gambal ka na kami malibri?” ");
INSERT INTO cgc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sabat Jesus, “Matuod gid, ula kaw gapasakep naan ta pagbeet ta bisan kino, piro gambal a ki kyo na bisan kino na gabuat ta sala, kanen an ulipen ta sala. ");
INSERT INTO cgc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mga suguon an dili pirmaninti na mimbro ta panimalay ta amo danen, piro mga bata ta amo pirmaninti gid. ");
INSERT INTO cgc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gani, daw yaken na Bata Ta Dyos maglibri ki kyo aged dili kaw en ulipen ta sala, malibri kaw gid. ");
INSERT INTO cgc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Nlaman ko na kyo yan mga linai Abraham. Piro, duma ki kyo gaprusigir gid na ipapatay a nyo tak dili nyo mabaton ake na tudlo. ");
INSERT INTO cgc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pasugid ko ki kyo mga pakita ta ake na Amay ki yaken. Piro, kyo yan gasunod kaw nang ta ambal ta inyo na amay.” ");
INSERT INTO cgc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ambal danen ki Jesus, “Abraham ya ame na amay.” Sabat Jesus, “Daw kyo yan matuod na mga linai Abraham, gabuat kaw inta ta dayad paryo ta buat din. ");
INSERT INTO cgc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piro, duma ki kyo gaprusigir na ipapatay a nyo tak gasugid a ki kyo ta kamatuuran na alin ta Dyos. Abraham ya ula gabuat paryo ta inyo na buat. ");
INSERT INTO cgc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pirmi kaw nang gasunod ta buat ta inyo na amay.” Ambal danen, “Kami matuod na mga bata ta Dyos tak Dyos nang gid matuod nay na Amay.” ");
INSERT INTO cgc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ambal Jesus ki danen, “Daw Dyos inyo na Amay, palanggaen a nyo inta tak yaken alin ta Dyos. Giling a ta kalibutan i alin ki kanen. Dili ake nang na liag na miling a ta kalibutan i. Giling a di tak Dyos gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Man-o tak ula kaw kaintindi ta ake na ambal? Ula kaw kaintindi tenged dili kaw miag na magpati ta ake na tudlo. ");
INSERT INTO cgc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Paryo kaw gid ta inyo na amay na Satanas. Daw ino liag din, yon man liag nyo na buaten. Alin ta una, kanen sikad magpatay ta mga ittaw daw ula kanen gambal ta matuod tak dili kanen miag na magtuman ta kamatuuran na pulong ta Dyos. Ugali din sikad magbula tak kanen alinan ta tanan na bula. ");
INSERT INTO cgc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Piro, yaken gasugid ki kyo ta kamatuuran daw yon tenaan na ula kaw gapati ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ula bisan isya ki kyo makaambal na may sala a. Gasugid a nang ta kamatuuran. Man-o tak dili kaw pa mapati ki yaken? ");
INSERT INTO cgc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Daw kino bata an ta Dyos, gapati kanen ta ambal ta Dyos. Ula kaw gapati ki yaken tenged Dyos an dili inyo na amay.” ");
INSERT INTO cgc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na pambalan Jesus mga Judio an na Dyos an dili iran na amay tenged ula danen gapati ki Jesus, gambal danen an ki kanen, “Igo ame na ambal na kaon yan Samaritano daw naseddepan ka man ta malain na ispiritu.” ");
INSERT INTO cgc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ambal Jesus, “Ula a naseddepi ta malain na ispiritu. Padayaw ko nang ake na Amay, piro pagayyaan a nyo. ");
INSERT INTO cgc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ula a gangita na dayawen a ta mga ittaw. Piro, ake na Amay liag din na yaken i dayawen daw kanen nang mag-ukom ta mga ittaw na gapagayya ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sigurado gid na mga gapagayya ki yaken silutan, piro gambal a ki kyo na bisan kino na magtuman ta ake na mga tudlo, dili en mapatay.” ");
INSERT INTO cgc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ambal danen ki Jesus, “Sigurado kay gid na kaon naseddepan ta malain na ispiritu tak gambal ka pa na mga ittaw na gatuman ta tudlo no dili en mapatay. Nlaman nay na tanan na mga ittaw mapatay. Bisan na gatuman Abraham ta Dyos anay pa sa, napatay man gyapon kanen an daw napatay man mga prupita na manugsugid ta kabebet-en ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ino beet no ambalen? Salig no na mas datas pa katengdanan no kaysa ta katengdanan ta ate na kaapuan na Abraham daw mga prupita? Napatay man en danen tanan. Ino isip no parti ta imo na kaugalingen?” ");
INSERT INTO cgc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sabat Jesus ki danen, “Daw yaken nang magdayaw ta ake na kaugalingen, ula pulos. Piro, ake na Amay na pambal nyo na inyo man na Amay, kanen mismo gadayaw ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Dili nyo kala ake na Amay, piro kanen kala ko. Alimbawa, daw mag-ambal a na ula a kakala ki kanen, magparyo a man ki kyo na mga bula. Piro, kala ko gid kanen an daw patuman ko iya na mga ambal. ");
INSERT INTO cgc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Anay pa sa, nalipay gid ate na kaapuan na Abraham tak gapaabot kanen an na makita a din na mabot a ta kalibutan i. Ta matuod, nakita a din en daw nalipay gid kanen ya.” ");
INSERT INTO cgc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ambal danen ki Jesus, “Tenged ula ka pa gaidad ta singkwinta, dili kay mapati na nakita no Abraham ya.” ");
INSERT INTO cgc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sabat Jesus, “Matuod gid na ula a pa gaidad ta singkwinta, piro gambal a ki kyo na bag-o pa natao Abraham ya, yaken i anen en.” ");
INSERT INTO cgc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tenged ta ambal Jesus, gatimod danen an ta mga bato aged timbagen kanen an asta na mapatay. Piro, Jesus i galin dayon naan ta mga ittaw daw gagwa kanen an ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na gapanaw Jesus i daw iya na mga tinudluan, may nakita danen na mama na bulag alin ta pagtao. ");
INSERT INTO cgc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mga tinudluan an gainsa ki Jesus, “Mistro, man-o tak mama an natao na bulag? Iya na sala? Sala ta iya na ginikanan?” ");
INSERT INTO cgc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sabat Jesus, “Dili tenged ta iya na sala daw dili man tenged ta sala ta iya na ginikanan. Bulag kanen an aged may makita na katingalaan na buaten ta Dyos naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Daw adlaw, mga ittaw gaubra, piro daw kilem, dili en danen kaubra. Beet ambalen ko daw may uras ki pa na mubra, dapat na buaten ta daw ino liag ta Dyos na gapadala ki yaken tak mabot uras na dili ta en mabuat. ");
INSERT INTO cgc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mintras naan a pa ta kalibutan i, yaken ilaw para ta tanan na mga ittaw tak gapapawa a ta isip ta mga ittaw.” ");
INSERT INTO cgc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pag-ambal Jesus, gaileb kanen naan ta basak daw gabuat kanen ta lunang. Papaid din lunang an naan ta mata ta bulag. ");
INSERT INTO cgc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ambal din naan ta bulag, “Miling ka naan ta may waig ya na alin ta tuburan Siloam daw maglam-os.” Siloam beet ambalen padala. Pag-ambal Jesus, giling dayon dya bulag an daw galam-os. Kakita en kanen an daw gapanaw muli. ");
INSERT INTO cgc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pag-uli din, nakita kanen an ta mga silingan din daw mga ittaw na kakita ki kanen na gapalimos pa dati kanen an. Ambal danen, “Di' ba yan mama na pirmi gamungko na gapalimos?” ");
INSERT INTO cgc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ambal ta duma, “Kanen yan.” Piro, duma an gambal, “Dili kanen nya. Basi paryo nang danen an ta sura.” Ambal ta mama an, “Yaken mama na dati gapalimos.” ");
INSERT INTO cgc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Painsaan danen mama an, “Ino paagi na nayad imo an na mata?” ");
INSERT INTO cgc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sabat ta mama, “Ittaw ya na paumaw na Jesus gabuat ta lunang daw papaid din naan ta mata ko i. Pasugo a din na miling naan ta may waig ya na alin ta tuburan Siloam daw maglam-os. Giling a man dya daw galam-os. Yon en na kakita aren.” ");
INSERT INTO cgc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Painsaan danen mama an, “Indya en kanen ya na gapaayad ki kaon?” Sabat ta mama, “Inday, ula a nalam.” ");
INSERT INTO cgc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Adlaw na pabuat Jesus lunang ya daw paayad din mata ya ta mama na bulag, yon man Adlaw Ta Pagpuay. Mama ya na nayad padala ta mga ittaw naan ta mga Pariseo. ");
INSERT INTO cgc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pagkita ta mga Pariseo ta mama an, painsaan danen daw ino paagi na naayad iya na mata. Sabat ta mama, “Papairan din ta lunang mata ko i daw galam-os a. Anduni kakita aren.” ");
INSERT INTO cgc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ambal ta pila na mga Pariseo, “Ittaw ya na gapaayad ta imo an na mata dili alin ta Dyos tak ula kanen gatuman ta mga sugo parti ta Adlaw Ta Pagpuay.” Piro, duma an na mga Pariseo gambal, “Ittaw na gapaayad ta bulag i ula kanen kasala tak mga ittaw na gabuat ta sala dili makabuat ta katingalaan paryo ta nabuat din.” Mga Pariseo an galalisay tak ula gaparyo iran na isip parti ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Gainsa danen ta mama na nayad en, “Ino maambal no parti ta ittaw ya na gapaayad ta imo na mata?” Sabat ta mama, “Kanen an isya na prupita.” ");
INSERT INTO cgc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Danen na mga manugdumala ta Judio na gainsa ta mama an, ula danen gapati na dati bulag kanen an daw anduni kakita en. Tenged ula danen gapati, paumaw danen ginikanan din ya ");
INSERT INTO cgc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","daw painsaan danen, “Bata nyo ni? Matuod na kanen natao na bulag? Man-o tak kakita en kanen an anduni?” ");
INSERT INTO cgc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sabat ta ginikanan din, “Matuod na kanen bata nay daw natao kanen na bulag. ");
INSERT INTO cgc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Piro, ula nay nlami daw ino paagi na kakita kanen an daw kino gapaayad ta iya na mata. Insaan nyo kanen an tenged may idad man en daw nalam man en kanen magsabat parti ta iya na kaugalingen.” ");
INSERT INTO cgc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iling tan sabat ta iya na ginikanan tak adlek danen an ta mga manugdumala ta Judio na gakuntra ki Jesus tenged nasapulan en ta mga manugdumala na daw kino mag-ambal na Jesus an Pinili Ta Dyos Na Mag-ari, bawalan danen na melled naan ta mga balay tipunan ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yon tenaan na gambal ginikanan ta bulag an na insaan kanen an ta mga manugdumala tenged may idad man en kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pagtapos danen ta pag-isturya ta ginikanan ya ta mama na nayad, paumaw danen isab mama ya na nayad daw pambalan danen, “Mag-ambal ka ta matuod parti ta ittaw ya na gapaayad ki kaon tak Dyos gamati ki kaon. Nlaman nay na kanen makasasala na ittaw.” ");
INSERT INTO cgc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sabat ta mama, “Ula ko nlami daw ittaw ya na gapaayad ki yaken makasasala. Basta nlaman ko na dati yaken i bulag, piro anduni kakita aren.” ");
INSERT INTO cgc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Painsaan danen mama an, “Ino pabuat din ki kaon? Ino paagi na paayad din mata no an?” ");
INSERT INTO cgc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Sabat ta mama, “Gasugid aren ki kyo, piro dili kaw mapati. Man-o tak gusto nyo mamati isab ta ambal ko? Gusto nyo man taan na kyo maimo man na mga tinudluan ta ittaw ya na gapaayad ki yaken?” ");
INSERT INTO cgc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pag-ambal ta mama, painsultuan danen kanen an, “Kaon yan iya na tinudluan, piro kami i a mga tinudluan Moises. ");
INSERT INTO cgc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nlaman nay na Dyos an gambal ki Moises ya anay pa sa. Piro, daw parti ta ittaw ya na gapaayad ki kaon, ula nay nlami daw taga indi kanen an.” ");
INSERT INTO cgc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sabat ta mama, “Impusibli na ula nyo nlami daw taga indi ittaw na ya. Tenged kanen gapaayad ta ake na mata, nlaman ta na kanen an alin ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nlaman ta na kanen dili makasasala tak ula gatabang Dyos an ta mga makasasala na ittaw. Gatabang nang Dyos an ta mga gasimba ki kanen daw gatuman ta iya na kabebet-en. ");
INSERT INTO cgc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Umpisa pa sa bag-o nabuat kalibutan i, anduni nang may ittaw na gapaayad ta ittaw na bulag alin ta iya na pagtao. ");
INSERT INTO cgc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ula duma makapaayad ta bulag daw dili, ittaw na alin ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ambal danen, “Alin ta pagtao no makasasala ka en. Man-o tak gatudlo ka pa ki kami?” Pagtapos danen ta pag-ambal ta mama an, papalin danen kanen ya naan ta balay tipunan. ");
INSERT INTO cgc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na nlaman Jesus na papalin ta mga manugdumala mama ya na paayad din, papangita din. Pagkita din ta mama ya, painsaan din, “Gatuo ka ki Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan?” ");
INSERT INTO cgc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sabat ta mama, “Sir, sugiran a no daw kino kanen an aged magtuo a ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ambal Jesus, “Anduni nakita no en kanen an tak yon man yaken mismo na gaisturya ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ambal ta mama, “Ginuo, gatuo a.” Pag-ambal din, dayon kanen galuod daw gadayaw ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ambal Jesus, “Giling a di ta kalibutan i para mlaman paagi ki yaken daw kino kakala gid ta Dyos daw kino man ula an kakala ta Dyos. Mga ittaw an na ula kakala ta Dyos, danen an paryo ta mga bulag na paayaren ko pa aged makakita. Mga ittaw an a na gambal na danen an kakala gid ta Dyos, danen an paryo ta mga ittaw na salig danen na kakita danen an piro ipakita ko na danen mga bulag pa.” ");
INSERT INTO cgc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mga Pariseo na kamati ta ambal Jesus, insa danen, “Beet ambalen no na kami i mga bulag man?” ");
INSERT INTO cgc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sabat Jesus, “Daw ula nyo inta nlami kamatuuran na pulong ta Dyos, dili kaw usgaran na may sala kaw. Piro, tenged na gambal kaw na nlaman nyo en kamatuuran na pulong ta Dyos, kyo yan pausgaran en na may sala tak ula kaw gapati ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Gambal pa Jesus i naan ta mga Pariseo, “Igo gid na kyo yan pausgaran en na may sala tak ula kaw gapati ki yaken daw sugiran ta kyo na daw may ittaw na magselled naan ta turil ta mga karniro na ula gaagi naan ta gangaan tak gakatay nang, yon na ittaw manakaw daw tulisan. ");
INSERT INTO cgc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Piro, manugbantay ta mga karniro naan gid gaagi ta gangaan. ");
INSERT INTO cgc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kanen an paselleren ta manugbantay ta gangaan daw iya na kagi kala gid ta mga karniro. Umawen din iya na mga karniro ta iran na mga ngaran daw dleen din mwa na kanen gauna ki danen. ");
INSERT INTO cgc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na napagwa din en tanan din na karniro, kanen an gauna na miling naan ta paalaban daw mga karniro gasunod ki kanen tak kala danen iya an na kagi. ");
INSERT INTO cgc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mga karniro an dili munod ta ittaw na dili danen kala. Magpadyo danen an ki kanen tak dili danen kala kagi an ta dili manugbantay ki danen.” ");
INSERT INTO cgc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Pagmati ta mga Pariseo ta paanggid na isturya, ula danen kaintindi daw ino beet din ambalen. ");
INSERT INTO cgc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ambal pa Jesus paagi ta paanggid, “Mga karniro an iling gid tan daw sugiran ta kyo na yaken gangaan na agian ta mga karniro. ");
INSERT INTO cgc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","May mga ittaw na gatudlo una ki yaken, piro ula gatudlo ta kamatuuran daw dili man dapat patian. Danen paryo ta mga manakaw daw tulisan na ula pamatii ta mga karniro. ");
INSERT INTO cgc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yaken gangaan. Daw kino magpasakep ta Dyos paagi ki yaken, kanen an maluwas na paryo kanen ta karniro na magselled naan ta turil daw mwa man na mangita ta kan-enen na ula may malain na matabo ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Manakaw an na ittaw, tuyo din ta pag-iling naan ta mga karniro aged magnakaw, magpatay daw magsamad. Piro yaken i a, giling a di ta kalibutan i aged kabui an na ula katapusan maangken ta mga ittaw. Subla pa ta maisip daw ino kadayad ta kabui an na ula katapusan.” ");
INSERT INTO cgc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ambal pa gid Jesus, “Yaken masaligan na manugbantay ta mga karniro. Masaligan na manugbantay, ialad din iya na kabui asta ta kamatayen aged maluwas iya na mga karniro. ");
INSERT INTO cgc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Piro, manugbantay an na pasuulan nang dili gid paryo ta manugbantay na tag-iya. Daw makita ta pasuulan na manugbantay na may gapanekeb na ayep na gaprani ta mga karniro, dilian din mga karniro an daw mlagan. Mga karniro an tekeben daw mawas-ag man danen an. ");
INSERT INTO cgc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pasuulan na manugbantay gadlagan tak ula nang bali ki kanen mga karniro an tenged kanen pasuulan nang na magbantay. ");
INSERT INTO cgc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Piro yaken i a, masaligan a na manugbantay ta mga karniro daw mga ittaw na sakep ki yaken paryo ta mga karniro ko. Kala ko danen an daw kala a man danen ");
INSERT INTO cgc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","paryo na kala a ta Dyos Amay daw kanen an kala ko man. Ialad ko ake na kabui asta ta kamatayen para ta mga ittaw na pakabig ko na ake na mga karniro. ");
INSERT INTO cgc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","May duma a pa na mga karniro na ula natingeb naan ta yi na turil. Kinanglan na dleen ko man danen an naan ki yaken. Danen an mamati man ta ake na kagi daw magsunod man ki yaken aged tanan ko na mga karniro mag-isya nang en naan ta isya na paneng daw manugbantay. ");
INSERT INTO cgc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Yi tenaan na yaken i, palangga a ta ake na Amay: Ialad ko ake na kabui na mapatay a para mabui a man isab. ");
INSERT INTO cgc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ula may makapatay ki yaken daw dili ko itugot. May matareng a na ialad ko ake na kabui daw may matareng a man na mabui isab tak yi sugo ta ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tenged ta ambal Jesus, ula gaparyo isip ta mga Judio parti ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tama na mga Judio gambal, “Naseddepan kanen an ta malain na ispiritu daw buang man en. Man-o tak mamati ki pa ki kanen?” ");
INSERT INTO cgc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Piro, duma an a gambal, “Ittaw na naseddepan ta malain na ispiritu dili makatudlo paryo ta tudlo din daw dili man makapaayad ta ittaw na bulag.” ");
INSERT INTO cgc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Timpo ta tagtignaw, gasilibrar mga Judio ta pista naan ta Jerusalem na paumaw na Pista Ta Pag-alad Ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ta timpo ta yon man na pista, Jesus i gapanaw naan ta isya na balkon naan ta Timplo na paumaw na Balkon Solomon. ");
INSERT INTO cgc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na gapanaw kanen dya, may mga manugdumala ta Judio na gatipon libot ki kanen daw gainsa, “Ino pa gid kalugayen paglikem no ki kami daw kino ka? Ambalen no ki kami na maintindian nay gid daw kaon yan Pinili Ta Dyos Na Mag-ari.” ");
INSERT INTO cgc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sabat Jesus ki danen, “Nasugiran ta kyo en daw kino a, piro dili kaw mapati. Mga katingalaan na papabuat ta ake na Amay ki yaken pamatuod daw kino a gid. ");
INSERT INTO cgc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Piro, dili kaw mapati ki yaken tak kyo dili isya ta ake na mga ittaw na pakabig ko na ake na mga karniro. ");
INSERT INTO cgc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mga ittaw na pakabig ko na ake na mga karniro gamati ki yaken. Danen an kala ko daw gasunod man danen an ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Paatagan ko danen an ta kabui na ula katapusan daw dili man en danen maageman silot an na ula katapusan. Ula bisan kino na mag-agaw ki danen naan ki yaken ");
INSERT INTO cgc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","tak Dyos na makagagaem na labaw ta tanan patugyan din danen an naan ki yaken daw ula bisan kino man na mag-agaw ki danen naan ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yaken daw ake na Amay isya nang.” ");
INSERT INTO cgc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagmati ta mga manugdumala ta Judio dya ta ambal Jesus, gatimod danen isab ta mga bato aged timbagen Jesus asta na mapatay. ");
INSERT INTO cgc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ambal Jesus ki danen, “Napakita ko en ki kyo tama na mga katingalaan na dayad na papabuat ta ake na Amay ki yaken. Ino nabuat ko na sala na timbagen a nyo?” ");
INSERT INTO cgc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sabat danen, “Timbagen nay kaon yan dili tenged ta dayad no na mga buat. Timbagen nay kaon yan tenged imo an na ambal insulto ta uturidad ta Dyos tak kaon ittaw nang, piro gambal ka na kaon yan Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sabat Jesus ki danen, “Di' ba may ambal naan ta inyo na sinulat na pulong ta Dyos na gambal Dyos an naan ta mga ittaw na danen mga dyos? ");
INSERT INTO cgc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nlaman ta na mga ambal naan ta sinulat na pulong ta Dyos dili maimo silian. Mga ittaw na kabaton ta sinulat na pulong ta Dyos, paambal ta Dyos na danen an mga dyos. ");
INSERT INTO cgc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Piro yaken i a, pinili ta Dyos na ake na Amay aged magsirbi ki kanen daw papadala a din man naan ta kalibutan i. Man-o tak pwidi ki kyo na mga ittaw ya paambal na mga dyos piro yaken i a, paakusaran nyo na ake an na ambal insulto ta uturidad ta Dyos tak gambal a na yaken Bata Ta Dyos? ");
INSERT INTO cgc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Daw paryo inta ta inyo na isip na ake na mga pabuat dili mga papabuat ta ake na Amay ki yaken, dapat nang na dili kaw mapati ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Piro, tenged na gabuat a ta papabuat ta ake na Amay ki yaken, dapat mapati kaw ki yaken. Bisan ula kaw gapati ki yaken tenged ta mga ambal ko, magpati kaw inta ki yaken tenged ta mga katingalaan na nabuat ko. Daw magpati kaw ki yaken, mlaman nyo na ake an na Amay naan ki yaken daw yaken naan man ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pagtapos Jesus ta pag-ambal, padakep inta danen kanen an, piro galikaw kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Galakted kanen an isab naan ta Suba Jordan daw giling ta lugar na naan dya Juan dati gabautismo. Naan dya Jesus gatinir ");
INSERT INTO cgc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","daw tama na mga ittaw gaprani ki kanen. Gaisturyaay mga ittaw an, “Ula gabuat Juan ta mga katingalaan, piro matuod gid tanan na mga ambal din parti ki Jesus.” ");
INSERT INTO cgc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tama na mga ittaw dya gatuo ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","May mama na gamasakit na ngaran din Lazaro na taga-Betania. Yon na Betania banwa na naan dya gistar Maria daw iya na utod na Marta. ");
INSERT INTO cgc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria i, kanen Maria na ta uryan magbubo ta paammot naan ta batiis Ginuo Jesus daw pairan din man ta iya na buok. Kanen man Maria na utod Lazaro ya na gamasakit. ");
INSERT INTO cgc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mag-utod ya na danen Maria daw Marta may pasugo na miling ki Jesus daw ambalen ki kanen iran na tugon, “Ginuo, pinalangga no ya na arey gamasakit.” ");
INSERT INTO cgc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na pasugiran Jesus i na Lazaro ya gamasakit, ambal din, “Risulta ta masakit Lazaro dili katapusan ta iya na kabui. Risulta ta iya na masakit na makita ta mga ittaw katingalaan na buat ta Dyos daw mapakala man danen na daw ino naan ta Dyos naan man ta Bata Ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mag-utod i na Marta, Maria daw Lazaro palangga gid Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tapos na nasugiran Jesus i na Lazaro ya gamasakit, palambay din anay darwa adlaw na naan kanen an ta lugar na patiniran din. ");
INSERT INTO cgc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Paglambay ta darwa na adlaw, gambal Jesus i ta mga tinudluan din, “Manaw ki en. Malik ki naan ta Judea.” ");
INSERT INTO cgc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ambal ta mga tinudluan din, “Mistro, di' ba ta pila nang ya na adlaw patimbag ka inta na patayen ta mga manugdumala ta Judio? Man-o abi na malik ka pa dya?” ");
INSERT INTO cgc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ambal Jesus, “Dili kaw madlek. Di' ba ta isya adlaw may dusi uras na pawa? Gani, bisan kino na manaw na adlaw pa, dili kanen an makaragpa tenged pawa pa adlaw an. ");
INSERT INTO cgc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Piro, bisan kino na manaw na kilem en, makaragpa kanen an tak delem.” ");
INSERT INTO cgc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ambal pa Jesus ta mga tinudluan din, “Lazaro ya na ate na arey gatunuga nang. Ilingan ko dya kanen ya daw pukawen.” ");
INSERT INTO cgc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ambal ta iya na mga tinudluan, “Ginuo, daw gatunuga nang Lazaro ya, mayad pa kanen ya.” ");
INSERT INTO cgc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iling tan iran na ambal tak salig danen na gatunuga nang Lazaro ya. Piro, beet ambalen Jesus na Lazaro ya patay en. ");
INSERT INTO cgc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gani, gambal kanen i ki danen na maintindian gid danen, “Lazaro ya patay en. ");
INSERT INTO cgc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Piro, gapasalamat a na ula a dya na napatay kanen ya aged daw makita nyo buaten ko, magdugang pa inyo na pagsalig ki yaken. Mos, ilingan ta en kanen ya.” ");
INSERT INTO cgc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas na isya na tinudluan Jesus daw paumaw man na Kapid, gambal kanen an ta duma din na mga tinudluan, “Mos, bisan mapatay ki man na duma ki Jesus, muyog ki nang en ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na gabot Jesus i daw iya na mga tinudluan dani ta baryo na Betania, namatian din na appat adlaw en nalebbeng Lazaro ya. ");
INSERT INTO cgc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kaadyuon ta Betania an alin ta Jerusalem daw panawen ula isya uras. ");
INSERT INTO cgc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tama na mga Judio gasud-o ki Marta daw Maria aged lingawen tenged napatay utod ya danen. ");
INSERT INTO cgc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na namatian Marta na Jesus mabot, gapanaw kanen an na mugat. Piro, Maria i a gapabilin naan ta iran na balay. ");
INSERT INTO cgc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ambal Marta ki Jesus, “Ginuo, daw anen ka di inta, ula napatay ame na utod. ");
INSERT INTO cgc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piro, nlaman ko na bisan napatay en Lazaro ya, anduni iatag man gyapon ta Dyos ki kaon daw ino pangayuon no.” ");
INSERT INTO cgc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dayon ambal Jesus, “Inyo na utod mabannaw.” ");
INSERT INTO cgc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ambal Marta, “Nlaman ko na kanen ya mabannaw naan ta katapusan na adlaw na bannawen ta Dyos mga patay.” ");
INSERT INTO cgc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ambal Jesus, “Yaken i magbannaw ta mga patay daw yaken man mag-atag ta kabui. Daw kino na gatuo ki yaken, bisan mapatay kanen an, mabui man gyapon. ");
INSERT INTO cgc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Daw kino kaangken ta kabui na ula katapusan tak gatuo ki yaken, dili en kanen an mapatay. Gapati ka ta ambal ko?” ");
INSERT INTO cgc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Sabat Marta, “Ee, Ginuo. Gapati a gid na kaon Pinili Ta Dyos Na Mag-ari daw kaon man Bata Ta Dyos na papaabot nay na miling ta kalibutan i.” ");
INSERT INTO cgc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagtapos Marta ta ambal ki Jesus, guli kanen naan ta iran na balay daw paumaw din na marani Maria an na utod din daw pasugiran din na inay nang kagi din, “Anen en Mistro daw pumaw ka din.” ");
INSERT INTO cgc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagmati Maria, dayon kanen tindeg daw manaw na mugat ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na gapanaw Maria, ula pa kabot Jesus i naan ta Betania. Naan pa kanen ta lugar na naan dya gakitaay kanen daw Marta. ");
INSERT INTO cgc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mga Judio na galingaw ki Marta daw Maria, gasunod man ki Maria tak nakita danen na gadali-dali kanen na mindeg daw manaw. Salig danen na Maria miling ta lebbengan Lazaro aged naan dya magal. ");
INSERT INTO cgc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Gabot Maria i ta lugar na naan dya Jesus. Pagkita din ki Jesus, galuod kanen an naan ta batiisan Jesus daw gambal, “Ginuo, daw anen ka di inta, ula napatay ake na utod.” ");
INSERT INTO cgc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na nakita Jesus na Maria an gagal asta mga Judio na gakuyog ki Maria, nasebean kanen i daw natandeg gid iya na tagipusuon. ");
INSERT INTO cgc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Gainsa kanen i ki danen, “Indi nyo palebbenga Lazaro ya?” Sabat danen, “Mos, Ginuo. Tudlo nay ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus i gagal. ");
INSERT INTO cgc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gambal mga Judio an na naan dya, “Lagen nyo. Palangga din gid Lazaro.” ");
INSERT INTO cgc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piro, duma an gambal, “Papaayad gani Jesus mata ta bulag ya. Man-o tak Lazaro ya a ula din paayara para dili mapatay?” ");
INSERT INTO cgc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nasakitan gid Jesus i na gabot kanen naan ta lebbengan Lazaro. Lebbengan Lazaro isya na kwiba na pasaraan ta bato. ");
INSERT INTO cgc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ambal Jesus, “Ligiren nyo bato an.” Sabat Marta na utod Lazaro, “Ginuo, sikad bao en kanen an tak appat en adlaw na nalebbeng.” ");
INSERT INTO cgc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ambal Jesus ki Marta, “Di' ba gambal aren ki kaon na daw magsalig ka ki yaken, makita no katingalaan na buaten ta Dyos?” ");
INSERT INTO cgc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pag-ambal Jesus, paligid danen bato ya. Gangad Jesus ta langit daw gambal, “Amay, gapasalamat a ki kaon tenged gamati ka ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nlaman ko man na pirmi ka gamati ki yaken, piro iling tan ambal ko aged mapati mga ittaw di na kaon gapadala ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagtapos Jesus ta pagpangamuyo, patuduan din iya na kagi na gambal kanen an, “Lazaro, mwa ka.” ");
INSERT INTO cgc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dayon gagwa Lazaro an na iya na lima daw batiis nableberan ta tila na panglebbeng daw naputos man iya an na waleng ta panyo na lapad. Ambal Jesus ta mga ittaw dya, “Badbaran nyo kanen an aged kapanaw.” ");
INSERT INTO cgc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na napatay Lazaro, tama na mga Judio gasud-o ki Maria daw kakita man ta pagbannaw Jesus ki Lazaro. Tenged ta iran na nakita, gatuo danen an ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piro, duma an a ki danen giling naan ta mga Pariseo daw gasugid na Lazaro ya pabannaw Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mga Pariseo na pasugiran ta mga ittaw parti ta nabuat Jesus daw mga manugdumala na mga pari man gapaumaw ta mga mimbro ta Sanedrin na kadatasan na kunsiyo ta mga Judio aged magsapol danen an. Gaisturyaay danen an, “Ino buaten ta tak ittaw na ya gabuat ta sikad tama na mga katingalaan? ");
INSERT INTO cgc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Daw largaan ta nang kanen an ta iya na mga buat, tanan na mga ittaw magpati na kanen Pinili Ta Dyos Na Mag-ari. Sulungon ki gid ta mga Romanen daw gubbaen danen Timplo ta ate na Dyos daw samaren man ate na nasyon.” ");
INSERT INTO cgc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Naan man dya ta iran na pagsapol pinakadatas na manugdumala ta mga pari ta yo na taon. Ngaran din Caifas. Ambal din ta mga manugdumala, “Paryo kaw inyo ula kaintindi. ");
INSERT INTO cgc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ula nyo naintindii na mas dayad daw isya nang na ittaw mapatay para ki kiten na mga paryo din na Judio kaysa mapatay tanan na mga ittaw ta ate na nasyon.” ");
INSERT INTO cgc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ula kanen gambal ta iya nang na isip tak pabetang ta Dyos naan ta iya na isip daw ino ambalen din bilang kanen pinakadatas na pari ta yo na taon. Iya na paambal beet ambalen na mapatay Jesus para ta mga paryo din na mga Judio. ");
INSERT INTO cgc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Piro, dili beet ambalen na mapatay Jesus para ta mga Judio nang. Beet ambalen man na mapatay Jesus para ta tanan na mga ittaw na maimo na mga bata ta Dyos na naan alin ta lain-lain na mga lugar aged mga Judio daw dili-Judio man mag-isya danen tanan. ");
INSERT INTO cgc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Umpisa sa na adlaw, mga manugdumala ta Judio gaplano daw ino paagi na ipapatay danen Jesus i. ");
INSERT INTO cgc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tenged ta plano ya danen, ula en gapakita Jesus i naan ta tama na mga ittaw ta mga banwa ta mga Judio. Giling kanen naan ta banwa na Efraim na dani ta lugar na ula kabalayan daw naan dya kanen gatinir na duma ta iya na mga tinudluan. ");
INSERT INTO cgc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na dali nang en mabot timpo na mag-umpisa pista ta mga Judio na paumaw na Pista Ta Paglibri Alin Ta Egipto, tama na mga ittaw giling naan ta Jerusalem na alin ta duma man na mga banwa aged magtuman ta iran na sunuran paagi ta mga sirimunya ta paglimpyo. ");
INSERT INTO cgc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Papangita ta mga ittaw Jesus an, piro ula danen nakita. Na gatipon danen naan ta Timplo, gainsaay danen an, “Ino ta inyo na isip? Miling taan ta pista i Jesus ya?” ");
INSERT INTO cgc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","May sugo alin ta mga manugdumala na mga pari daw mga Pariseo na daw kino nalam daw indi Jesus an, dapat isugid din naan ta mga manugdumala aged ipadakep danen Jesus an. ");
INSERT INTO cgc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na annem nang en adlaw bag-o ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto, Jesus i giling naan ta Betania na lugar Lazaro. Lazaro i, kanen mama na pabannaw Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na naan Jesus ta Betania, gaanda Lazaro daw iya na mga utod ta ispisyal na yapon tak nalipay danen na gabot Jesus an. Marta an gasirbi daw Lazaro i isya ta mga gaduma ki Jesus na gakaan. ");
INSERT INTO cgc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria i gakamang ta tenga litro ta puro na paammot na maalen na buat alin ta tanem na nardo. Pabubo din naan ta batiis Jesus daw batiis ya papairan din man ta iya na buok. Bilog na balay gaenneb gid ta ammot. ");
INSERT INTO cgc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Naan man dya Judas Iscariote na isya na tinudluan Jesus. Kanen tinudluan na ta pila nang en na adlaw magtraydor ki Jesus. Gariklamo kanen an na ambal din, ");
INSERT INTO cgc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Man-o tak ula pabligya paammot an aged iatag kwarta an naan ta mga imol? Bayad ta yan na paammot tallo gatos na sinsilyo na pilak.” ");
INSERT INTO cgc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iling tan ambal Judas dili tenged na naluoy kanen an ta mga imol. Ambal din iling tan tak kanen an manakaw. Kanen gaibit ta kwarta danen Jesus daw pirmi din pakamangan. ");
INSERT INTO cgc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ambal Jesus, “Largaan nyo nang Maria an tak patagana din paammot na i para ta iya na pagpriparar ta lawa ko para ta ake na lebbeng. ");
INSERT INTO cgc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mga imol an pirmi nyo duma, piro yaken i a, dili en maglugay na duma ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tama na mga Judio kamati na Jesus naan ta Betania daw giling man danen dya. Piro, dili nang tenged ki Jesus giling danen dya tak gusto man danen na makita Lazaro ya na pabannaw Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mga manugdumala na mga pari gaplano na Lazaro an ipapatay man danen. ");
INSERT INTO cgc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tenged ta pagbannaw ki Lazaro, tama na mga Judio ula en gasunod ta tudlo ta mga manugdumala. Gatuo danen an ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sunod na adlaw pagtapos danen Lazaro ta pag-iwat ta ispisyal na yapon para ki Jesus, sikad tama na mga ittaw namista naan ta Jerusalem daw nabalitaan man danen na Jesus an miling dya. ");
INSERT INTO cgc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Gakamang mga ittaw an ta mga daon ta kaoy na palma daw gapanaw danen na magsugat ki Jesus naan ta gwa ta syudad. Ta iran na pagsugat, gasinggit danen, “Dayawen ta Dyos an! Dayawen gabot an na papadala ta Ginuo Dyos! Dayawen Ari ta mga linai Israel!” ");
INSERT INTO cgc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Gasugo Jesus na dlaan kanen an ta isya na bata pa na asno daw gasakay kanen an. Pabuat din an paryo gid ta ambal naan ta sinulat na pulong ta Dyos: ");
INSERT INTO cgc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kyo na naan ta syudad Sion, dili kaw madlek tak anduni inyo na ari mabot en na gasakay ta bata pa na asno.” ");
INSERT INTO cgc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ta primiro, mga tinudluan Jesus ula pa danen naintindii daw ino beet ambalen ta mga natabo ta pag-iling Jesus naan ta Jerusalem. Piro, pagbannaw ki Jesus daw pagbalik din naan ta langit, nademdeman danen ambal ya naan ta sinulat na pulong ta Dyos parti ki kanen daw naintindian man danen na ambal ya parti ki kanen natuman gid paagi ta mga natabo ta pag-iling din naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ta adlaw na gaselled Jesus i naan ta Jerusalem, tama na mga ittaw gasugid ta duma na mga ittaw parti ta iran na nakita na Jesus gaumaw ki Lazaro na mwa ta lebbengan daw pabannaw din. ");
INSERT INTO cgc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tama na mga ittaw gapanaw na magsugat ki Jesus naan ta gwa ta syudad tak namatian danen na gabuat kanen ta katingalaan. ");
INSERT INTO cgc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mga Pariseo an gaisturyaay, “Ula ki en mabuat. Lagen nyo, tanan na mga ittaw gasunod en ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","May mga dili-Judio man na giling ta Jerusalem para mamista daw magsimba ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Duma an ki danen giling ki Felipe na taga-Betsaida na banwa na sakep ta Galilea daw gambal, “Sir, gusto nay mag-isturya ki Jesus.” ");
INSERT INTO cgc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pagmati Felipe, gapanaw kanen an daw pasugiran din Andres ya. Darwa en danen gapanaw na miling ki Jesus na magsugid parti ta ambal ya ta mga dili-Judio. ");
INSERT INTO cgc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pagmati Jesus ta sugid danen Felipe daw Andres, ambal din ki danen, “Mabot en uras na Kanen i Na Alin Ta Langit Na Natao Naan Ta Kalibutan, makala daw kino gid kanen i paagi ta iya na kamatayen. ");
INSERT INTO cgc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sigurado gid na mabot en uras na ya daw sugiran ta kyo na daw isya na binni na trigo dili matanem naan ta basak, mabilin na isya nang. Piro, daw matanem, magtubo daw mamunga ta tama. ");
INSERT INTO cgc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Daw kino gapalabi ta iya na kabui, dili din maangken kabui na ula katapusan. Piro, bisan kino ula gapalabi ta iya na kabui unti ta kalibutan, maangken din kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bisan kino na magsirbi ki yaken, kinanglan na magsunod ki yaken aged daw indi a, anen man dya kanen an na suguon ko. Daw kino gasirbi ki yaken, kanen tagan ta Dyos Amay ta dayad na bales.” ");
INSERT INTO cgc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ambal pa Jesus, “Anduni, paryo ta dili ko masarangan isipen maagian ko an daw dili ko man mlaman daw ino dapat ko na ambalen! Amay ko, luwasen a no ta segeng na kabellay na maagian ko! Piro, tuyo ta pag-iling ko ta kalibutan i aged maagian ko gid segeng na kabellay na naan ta imo na plano. ");
INSERT INTO cgc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Amay ko, ipakala no naan ta mga ittaw paagi ki yaken daw kino gid kaon yan. Gapasakep a ta imo na kabebet-en.” Dayon may namatian na gambal na naan ta langit, “Paagi ki kaon, napakala ko en daw kino a gid daw ipakala ko eman paagi ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mga ittaw na gatipon dya namatian man danen gambal ya na naan ta langit. Duma ki danen gambal, “Gadageeb,” daw duma an a gambal, “May angil na gaisturya ki kanen!” ");
INSERT INTO cgc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ambal Jesus ta mga ittaw dya, “Ambal ya na namatian nyo dili para ki yaken tak para nya ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Anduni, gabot en timpo na mga ittaw mausgaran en tenged ta iran na pagkuntra ta Dyos daw timpo man en na mapirdi Satanas an na gapangulo ta mga ittaw na gakuntra ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Daw ibetang aren naan ta kaoy daw ipadatas alin ta basak, ipakita ko ake na kaluoy ta tanan na mga ittaw aged magtuo danen ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iling tan ambal Jesus aged mlaman ta mga ittaw daw ino na paagi iya an na kamatayen. ");
INSERT INTO cgc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sabat ta mga ittaw dya ki Jesus, “Natudluan kay en na naan ta sinulat na pulong ta Dyos may ambal na Pinili Ta Dyos Na Mag-ari mabui ta ula katapusan. Man-o tak gambal ka na naan ta plano ta Dyos na Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan ipadatas? Kino Kanen an Na Alin Ta Langit Na Natao Naan Ta Kalibutan?” ");
INSERT INTO cgc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Gasabat Jesus i paagi ta isya na paanggid na isturya parti ta iya na kaugalingen, “Ula nang en lugay na ilaw i marwad en naan ki kyo. Mintras na ilaw i anen pa ki kyo, magpadayon kaw ta inyo na pagpanaw aged dili kaw mabutan ta delem tak bisan kino na gapanaw naan ta delem, dili din mlaman daw indi kanen an punta. ");
INSERT INTO cgc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gani, magtuo kaw ki kanen na paumaw na Ilaw mintras anen pa kanen ki kyo aged maimo kaw na sakep ki kanen na gasunod ta iya na tudlo.” Pagtapos Jesus ta ambal, galin kanen dya daw ula en kanen gapakita naan ki danen. ");
INSERT INTO cgc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan nakita ta mga ittaw na tama en na katingalaan na pabuat Jesus na pamatuod daw kino kanen an, ula man gyapon danen an gatuo ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tenged ula danen gatuo, natuman nasulat Isaias na prupita anay pa sa, “Ginuo, paryas ula ittaw na gapati ta palaygay nay daw paryas man ula ittaw na kaintindi daw ino beet ambalen ta imo na mga buat paagi ta bakod no na gaem.” ");
INSERT INTO cgc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nasulat man Isaias daw ino tenaan na dili magtuo mga ittaw: ");
INSERT INTO cgc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pabulag danen an ta Dyos daw padessen din man iran na mga ulo aged paryas ula danen kakita daw ula man kaintindi tak basi daw maintindian danen, magnelsel daw marani ki yaken daw patawaren ko danen an.” ");
INSERT INTO cgc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iling tan pasulat Isaias anay pa sa parti ki Jesus tak napakala daan ta Dyos ki Isaias na daw ino naan ta Dyos naan man ta Pinili Ta Dyos Na Mag-ari. Tenged napakala ki kanen, gambal kanen parti ta Pinili Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Maskin may mga ittaw na ula gatuo ki Jesus, tama man gyapon gatuo ki kanen asta man mga manugdumala ta Judio. Piro, mga manugdumala an ula gaako na gatuo danen an tak adlek ta mga Pariseo tenged mga gatuo an ki Jesus pabawalan ta mga Pariseo na melled naan ta mga balay tipunan ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ula danen gaako tak palabi danen na dayawen danen an ta mga ittaw kaysa na dayawen ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na gatudlo Jesus i naan ta mga ittaw, gambal kanen na patuduan din iya na kagi, “Bisan kino magtuo ki yaken, kanen gatuo man ta gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bisan kino kakita ki yaken, kakita man en ta gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Giling a di ta kalibutan i aged yaken paryo ta ilaw na magpapawa naan ta mga ittaw para bisan kino na magtuo ki yaken, paryo na dili en kanen an naan ta delem. ");
INSERT INTO cgc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Bisan kino kamati ta ake na ambal, piro ula kanen gatuman, dili yaken magsintinsya ki kanen ta ula katapusan na silot tak ula a giling di ta kalibutan i aged magsintinsya ta mga ittaw. Giling a di aged luwasen ko danen an alin ta ula katapusan na silot ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Piro, mga ittaw na gasikway ki yaken daw ula gapati ta ake na ambal, silutan danen an naan ta katapusan na adlaw na mag-ukom Dyos an ta mga ittaw. Silutan danen an tenged ula danen gatuman ta ake na ambal. ");
INSERT INTO cgc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ula a gambal ta ake nang na liag tak Amay ko na gapadala ki yaken, kanen gasugo daw ino ambalen ko. ");
INSERT INTO cgc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nlaman ko na daw mambal a naan ta mga ittaw daw ino pasugo ta ake na Amay ki yaken na ambalen, maintindian danen daw ino paagi na maangken danen kabui na ula katapusan. Gani, pambal ko nang daw ino papaambal ta ake na Amay ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bag-o ta Pista Ta Paglibri Alin Ta Egipto, nlaman Jesus na mabot en uras na matuman plano ta Dyos para ki kanen na malin kanen ta kalibutan i daw malik ta Dyos na iya na Amay. Alin ta una pagugma gid Jesus iya na mga ittaw na gasunod ki kanen daw pagugma din man danen an asta ta katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na Jesus i daw iya na mga tinudluan gayapon, Judas an na bata Simon Iscariote naan en ta iya na isip na magtraydor kanen ki Jesus tak iling tan na plano nabetang en daan Satanas naan ta iya na isip. ");
INSERT INTO cgc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus i, nlaman din en na tanan na uturidad paatag ta Dyos na iya na Amay naan ki kanen daw kanen alin ta Dyos daw malik man ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tenged na nlaman en Jesus, iling ti pabuat din: Na ula pa galin mga tinudluan din naan ta lamisa, gatindeg kanen i daw palubbas din iya na mga pang-apaw na bayo daw pableberan din ta twalya iya na awak. ");
INSERT INTO cgc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Gabetang kanen an ta waig naan ta labador daw dayon din paugasan mga batiis ta iya na mga tinudluan daw papairan din man ta twalya na nablebed naan ta iya na awak. ");
INSERT INTO cgc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na naan en kanen i ki Simon Pedro, ambal Simon Pedro, “Ginuo, man-o tak kaon gid mag-ugas ta ake na batiis?” ");
INSERT INTO cgc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sabat Jesus, “Anduni dili no pa maintindian daw ino beet ambalen ta pabuat ko, piro mabot adlaw na maintindian no en.” ");
INSERT INTO cgc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ambal Pedro, “Dili pwidi na kaon mag-ugas ta ake na batiis.” Sabat Jesus, “Daw dili ka magpaugas ki yaken ta imo na batiis, dili ka en ake na duma.” ");
INSERT INTO cgc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ambal Simon Pedro, “Ginuo, daw iling tan, dili nang batiis ko ugasan no. Ugasan no man asta ake i na lima daw ulo.” ");
INSERT INTO cgc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ambal Jesus, “Ittaw na kalangoy en dili kinanglan mangoy isab tak bilog din na lawa limpyo en. Batiis din nang kinanglan na ugasan isab. Kyo yan mga limpyo en, piro dili kyo tanan.” ");
INSERT INTO cgc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iling tan ambal Jesus na dili tanan na tinudluan din limpyo tak nlaman din daw kino magtraydor ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagtapos ta pag-ugas Jesus ta iran na mga batiis, pasuksok din isab iya na pang-apaw na bayo daw malik naan ta lamisa. Gainsa kanen ta mga tinudluan din, “Naintindian nyo pabuat ko an ki kyo anduni? ");
INSERT INTO cgc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Paumaw a nyo na ‘Mistro’ daw ‘Ginuo’. Igo man tak yaken matuod nyo na mistro daw Ginuo. ");
INSERT INTO cgc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tenged yaken i na inyo na Ginuo daw Mistro gaugas ta inyo na mga batiis, dapat na kyo man mag-ugas ta batiis ta mga duma nyo. ");
INSERT INTO cgc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yon alimbawa ko para sunuron nyo. ");
INSERT INTO cgc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Dapat gid na sunuron a nyo daw sugiran ta kyo na katengdanan ta isya na suguon dili mas datas kaysa ta katengdanan ta amo din daw katengdanan ta isya na ittaw na pasugo dili mas datas kaysa ta katengdanan ta gapadala ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Anduni, nlaman nyo en kamatuuran na patudlo ko. Daw tumanen nyo, maangken nyo kalipay na alin ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jesus i gambal pa naan ta iya na mga tinudluan, “Ake na paisturya dili parti ki kyo tanan tak nlaman ko daw ino naan ta isip ta kada ittaw na papili ko. Piro, kinanglan na matuman yi na ambal na naan ta sinulat na pulong ta Dyos, ‘Duma ko na gakaan na dengngan ki yaken, kanen an magkuntra ki yaken.’ ");
INSERT INTO cgc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Anduni bag-o matabo, gasugid a daan ki kyo na may magkuntra ki yaken aged patian nyo daw kino yaken i. ");
INSERT INTO cgc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sigurado gid na yaken i pambal ko ya na yaken daw sugiran ta kyo na daw kino magbaton ta mga ittaw na papadala ko, paryas man na yaken pabaton din. Daw kino magbaton ki yaken, paryas man na pabaton din ake na Amay na gapadala ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pag-ambal Jesus ta iling tan, sakit gid iya na nakem. Paprangka din iya na mga tinudluan na ambal din, “Gaduma kaw anduni ki yaken ta pagkaan, piro sugiran ta kyo na isya ki kyo magtraydor ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pagmati ta mga tinudluan Jesus, gatan-away danen an tak ula danen nlami daw kino paambal din. ");
INSERT INTO cgc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Isya na tinudluan Jesus na pinalangga din naan ta iya na kilid. ");
INSERT INTO cgc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tinudluan na ya pasinyasan Simon Pedro na insaan din Jesus an daw kino gid ki danen paambal Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Gasandig ki Jesus tinudluan an daw gainsa, “Ginuo, kino gid paambal no ya?” ");
INSERT INTO cgc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sabat Jesus, “Itublok ko biak i na tinapay. Daw kino tagan ko, kanen magtraydor ki yaken.” Pag-ambal Jesus, patublok din tinapay an daw paatag din ki Judas na bata Simon Iscariote. ");
INSERT INTO cgc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagbaton Judas ta tinapay an, gaseddep dayon Satanas ki kanen. Ambal Jesus ki Judas, “Giran no. Buaten no en plano no an.” ");
INSERT INTO cgc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pag-ambal Jesus, ula bisan isya ki danen dya kaintindi daw man-o tak gambal kanen ki Judas ta iling tan. ");
INSERT INTO cgc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Salig ta duma na mga tinudluan na basi Judas an pasugo nang Jesus na malit ta iran na mga kinanglanen para ta pista daw basi man pasugo din Judas an na mag-atag ta limos naan ta mga imol tak Judas gaibit ta iran na kwarta. ");
INSERT INTO cgc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pagbaton Judas ta tinapay ya na paatag Jesus, gagwa kanen an dayon daw manaw. Kilem nya en. ");
INSERT INTO cgc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na galin en Judas ki danen Jesus, gambal Jesus i naan ta duma na mga tinudluan, “Mabot en uras na Kanen i Na Alin Ta Langit Na Natao Naan Ta Kalibutan, mapakala kanen paagi ta iya na kamatayen daw kino gid kanen i daw paagi ki kanen mapakala man en daw kino gid Dyos an. ");
INSERT INTO cgc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Daw mapakala paagi ki kanen daw kino gid Dyos an, dayon man kanen i ipakala ta Dyos daw kino gid kanen an.” ");
INSERT INTO cgc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ambal pa Jesus, “Kyo na pabilang ko na ake na mga bata, dili aren maglugay na duma ki kyo. Mangita kaw gid ki yaken, piro dili kaw makailing ta ilingan ko paryo ta paambal ko naan ta mga manugdumala ta Judio. ");
INSERT INTO cgc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Gani, may bag-o a na sugo para ki kyo: Dapat maggugmaay kaw. Daw ino ake na paggugma ki kyo, dapat na iling man tan inyo an na paggugma ta kada isya. ");
INSERT INTO cgc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Daw makita ta mga ittaw na kyo yan gagugmaay, mlaman danen na kyo yan ake na mga tinudluan.” ");
INSERT INTO cgc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pedro i gainsa ki Jesus, “Ginuo, indi ka gid punta?” Sabat Jesus, “Anduni, dili ka pa kakuyog ki yaken ta ilingan ko, piro ta uryan munod ka.” ");
INSERT INTO cgc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Insa Pedro, “Ginuo, man-o tak dili a kakuyog ki kaon anduni? Anda aren na mapatay para ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Sabat Jesus ki Pedro, “Nyan salig no na anda ka gid na mapatay para ki yaken! Dayad gid ambal no an, piro gambal a ki kaon na bag-o magtagaok manok kani kambal ka en ta tallo bisis na dili a no kala.” ");
INSERT INTO cgc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Gapadayon Jesus i ta pag-ambal naan ta iya na mga tinudluan, “Dili kaw magpalibeg. Magsalig kaw ta Dyos Amay daw magsalig kaw man ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Istaran ta ake na Amay sikad wayang na tama na mga maistaran dya. Muna a ki kyo daw buaten ko mga dapat buaten aged makaistar kaw dya. Matuod gid ambal ko ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tenged muna a ki kyo daw buaten ko mga dapat buaten aged makaistar kaw dya, malik a di daw dleen ta kyo dya aged duma kaw ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nlaman nyo en agian an munta ta ake na ilingan.” ");
INSERT INTO cgc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas gambal ki Jesus, “Ginuo, ula kay nalam daw indi ka punta. Gani, ino paagi na mlaman nay agian na munta ta ilingan no ya?” ");
INSERT INTO cgc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Sabat Jesus ki Tomas, “Yaken agian, kamatuuran, daw kabui tak paagi nang ki yaken mga ittaw marani ta Dyos Amay daw mlaman man danen kamatuuran an parti ki kanen daw mabaton man kabui na ula katapusan. Ula duma na paagi na mga ittaw makakala ta Dyos Amay daw makaprani man ki kanen daw dili, paagi nang ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tenged nakala a nyo en, makala nyo man ake na Amay. Umpisa anduni, sigurado na kala nyo daw nakita nyo man kanen an en.” ");
INSERT INTO cgc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ambal Felipe ki Jesus, “Ginuo, ipakita no ki kami Dyos Amay an. Daw makita nay kanen an, kuntinto kay en.” ");
INSERT INTO cgc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sabat Jesus, “Felipe, lugay aren na duma ki kyo. Man-o tak ula a no pa gid nakala? Bisan kino na kakita ki yaken, kakita man ta Amay ko. Man-o tak gambal ka pa na ipakita ko ki kyo ake na Amay? ");
INSERT INTO cgc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ino, ula ka gapati na yaken i naan a ta ake na Amay daw ake an na Amay naan man kanen ki yaken? Ake na mga ambal ki kyo dili alin ki yaken. Ake na mga ambal alin ta ake na Amay na pirmi naan ki yaken. Kanen man alinan ta mga pabuat ko. ");
INSERT INTO cgc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kyo yan dapat mapati na yaken i naan a ta ake na Amay daw ake an na Amay naan man kanen ki yaken. Piro, daw dili kaw mapati ki yaken tenged ta ake na ambal, mapati kaw ki yaken tenged ta mga katingalaan na pabuat ko. ");
INSERT INTO cgc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Dapat gid na mapati kaw ki yaken tenged ta mga pabuat ko daw sugiran ta kyo na mga gatuo an ki yaken magbuat man paryo ta pabuat ko daw magbuat man danen ta mas pa ta ake na mga nabuat tak malik a ta ake na Amay. ");
INSERT INTO cgc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bisan ino pangabayen nyo ta ake na Amay tenged sakep kaw ki yaken, buaten ko aged makala daw kino gid Dyos Amay an paagi ki yaken na Bata din. ");
INSERT INTO cgc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Daw mangabay kaw ta bisan ino tenged na sakep kaw ki yaken, sigurado na buaten ko.” ");
INSERT INTO cgc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Gapadayon Jesus i ta pag-ambal naan ta iya na mga tinudluan, “Daw pagugma a nyo, magtuman kaw ta ake na mga sugo ");
INSERT INTO cgc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","daw yaken, mangabay a naan ta Dyos Amay na magpadala kanen ta isya na sal-i ki yaken na magduma ki kyo daw mag-ubay man ta ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kanen na magduma ki kyo Dyos Ispiritu Santo na magtudlo ki kyo ta kamatuuran. Mga ittaw na ula gapati ta Dyos, ula danen pabaton Dyos Ispiritu Santo an tak dili danen kaintindi ki kanen daw dili man danen kala. Piro kyo yan, kala nyo kanen an tak duma kanen ki kyo daw mabot adlaw na naan en kanen an ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Dili ko pabay-an kyo yan na ula kaw duma tak malik a gid ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mga ittaw na ula gapati ta Dyos, dali nang en mabot uras na dili a danen makita, piro kyo a, makita a nyo pa man gyapon. Tenged mabui a isab, mabui kaw man ta ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta adlaw na mabui a isab, mlaman nyo na yaken i naan a ta ake na Amay, kyo yan naan kaw ki yaken, daw yaken i naan a ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bisan kino na paintindi din gid ake na mga sugo daw patuman, kanen gagugma man ki yaken. Bisan kino na gagugma ki yaken, pagugma man kanen an ta ake na Amay. Pagugma ko man kanen an daw ipakala ko pa gid ake na kaugalingen ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Isya na tinudluan Jesus na ngaran din Judas may insa ki Jesus. -- Yi na Judas dili Judas Iscariote. -- Gainsa Judas i ki Jesus, “Ginuo, man-o tak naan no nang ki kami ipakala gid imo an na kaugalingen? Man-o tak dili no ipakala imo an na kaugalingen naan ta tanan na mga ittaw?” ");
INSERT INTO cgc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sabat Jesus, “Daw kino gagugma ki yaken, tumanen din ake na mga ambal. Daw iling tan buaten din, Amay ko an maggugma ki kanen daw yaken i daw ake an na Amay naan kay ki kanen na kanen paryo balay na ame na istaran. ");
INSERT INTO cgc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Piro, bisan kino na ula gagugma ki yaken, ula din tumana ake na mga ambal. Ake na ambal na namatian nyo dili alin ki yaken tak naan alin ta ake na Amay na gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Yon pasugid ko en daan ki kyo mintras anen a pa di duma ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Isya an na magduma ki kyo na yon man Dyos Ispiritu Santo na ipadala ta Dyos Amay naan ki kyo na sal-i ki yaken, kanen an magtudlo ki kyo ta tanan na mga kinanglan na mlaman nyo parti ta ake na mga ambal daw kanen man magpademdem ki kyo ta tanan na mga paambal ko. ");
INSERT INTO cgc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tawwayen ko inyo na nakem. Katawwayan na iatag ko ki kyo paryo ta katawwayan ta ake na nakem. Mga ittaw na ula gapati ta Dyos, dili danen makaatag ki kyo ta iling sa na katawwayan. Dili kaw magpalibeg daw dili kaw man madlek. ");
INSERT INTO cgc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Namatian nyo ambal ko ki kyo na mabilin ta kyo, piro malik a man. Daw matuod na pagugma a nyo, inta magkalipay kaw tak miling a ta ake na Amay na iya na katengdanan mas datas pa kaysa ta ake na katengdanan. ");
INSERT INTO cgc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pasugid ko daan ki kyo na malik a ta ake na Amay bag-o matabo na malik a aged daw matabo en na paryo gid ta ake na ambal, magtuo kaw ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Dili aren maglugay na mag-ambal ki kyo tak mabot di en Satanas na gapangulo ta mga ittaw na ula gapati ta Dyos. Ula kanen an uturidad na magdumala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Piro, mabaton ko tanan na mga matabo ki yaken na plano ta Dyos daw patuman ko man tanan din na mga sugo ki yaken aged tanan na mga ittaw mlaman danen na pagugma ko ake na Amay. Mos, manaw ki en.” ");
INSERT INTO cgc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Gambal pa Jesus i naan ta iya na mga tinudluan paagi ta paanggid, “Yaken matuod na puon na ubas daw ake na Amay manug-asikaso. ");
INSERT INTO cgc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kada sanga ko na ula gabunga pautod din daw kada sanga na gabunga pauturan din ta ugbos aged malimpyo daw mamunga pa gid ta tama. ");
INSERT INTO cgc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kyo paryo ta mga nalimpyuan na mga sanga na gabunga gid ta tama tak gabag-o kaw paagi ta ake na tudlo. ");
INSERT INTO cgc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Magpadayon kaw na naan kaw ki yaken na yon man yaken i magpadayon na naan a ki kyo. Daw sanga ta ubas mabelag naan ta iya na puon, sanga an dili mamunga. Iling man tan, daw dili kaw magpadayon na naan kaw ki yaken, paryo kaw ta mga sanga na dili mamunga. ");
INSERT INTO cgc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yaken i puon na ubas daw kyo yan mga sanga. Daw magpadayon kaw na naan kaw ki yaken daw yaken magpadayon na naan a man ki kyo, paryo kaw ta sanga na miad mamunga tak daw mabelag kaw ki yaken, dili kaw makabuat ta bisan ino. ");
INSERT INTO cgc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bisan kino na dili magpadayon na naan kanen ki yaken, kanen paryo ta sanga na papilak nang daw gaega. Dayon patipon daw sunugon. ");
INSERT INTO cgc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Piro, daw kyo magpadayon na naan kaw ki yaken daw ake na mga ambal naan ta inyo na tagipusuon, bisan ino inyo na pangabayen, buaten ko. ");
INSERT INTO cgc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Iling ti na paagi na ipakala nyo naan ta mga ittaw daw kino gid Dyos Amay: magpadayon kaw ta pagbuat ta miad na makapalipay ta Dyos na yon man mlaman ta mga ittaw na kyo yan mga tinudluan ko. ");
INSERT INTO cgc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Kyo yan pagugma ko paryo ta paggugma ta Amay ko ki yaken. Gani, magpadayon kaw ta pagtuman ki yaken tak daw iling tan buaten nyo, mlaman nyo na pirmi ta kyo pagugma. ");
INSERT INTO cgc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Daw tumanen nyo ake na mga sugo, mlaman nyo pirmi na pagugma ta kyo, paryo ta pagtuman ko ta mga sugo ta ake na Amay na nlaman ko na pirmi a din pagugma. ");
INSERT INTO cgc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iling tan paambal ko ki kyo aged bakod gid inyo na kalipay paryo man ta ake na kalipay. ");
INSERT INTO cgc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Yi sugo ko ki kyo na maggugmaay kaw paryo ta paggugma ko ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ula gugma na mas dayad pa ti na paalad ta isya na ittaw iya an na kabui na mapatay kanen an para ta iya na mga arey. ");
INSERT INTO cgc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Daw magtuman kaw ta ake na mga sugo, kyo yan mga arey ko. ");
INSERT INTO cgc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dili ta kyo en umawen na mga suguon tak mga suguon an ula nalam daw ino buat ta iran na amo. Piro, umawen ta kyo en mga arey ko tak nasugid ko en ki kyo tanan na namatian ko na alin ta ake na Amay. ");
INSERT INTO cgc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dili kyo gapili ki yaken. Yaken gapili ki kyo daw papadala ta kyo na miling kaw daw maglaygay naan ta mga ittaw aged danen an magtuo man. Ta iling tan na paagi, inyo na pagpati ki yaken may risulta na magpadayon naan ta ula katapusan. Tenged man na kyo mga papili daw papadala ko, pwidi kaw mangabay ta bisan ino naan ta ake na Amay tak sakep kaw ki yaken daw sigurado na iatag din ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ambalen ko isab na yi sugo ko ki kyo na dapat maggugmaay kaw ta kada isya.” ");
INSERT INTO cgc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Gambal pa Jesus i naan ta iya na mga tinudluan, “Bisan kyo demetan ta mga ittaw na gakuntra ta Dyos, dili kaw magtingala. Demdemen nyo na yaken una na pademetan danen. ");
INSERT INTO cgc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Daw kyo paryas ta mga ittaw na gakuntra ta Dyos, palanggaen kaw danen bilang iran na mga duma. Piro, kyo yan dili iran na mga duma tak papili ta kyo aged dili kaw en magparyo ki danen. Yon tenaan na kyo yan demetan danen. ");
INSERT INTO cgc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Demdemen nyo ake na ambal na katengdanan ta isya na suguon dili mas datas kaysa ta katengdanan ta amo din. Daw ino pabuat naan ta amo, yon man buaten naan ta iya na suguon. Iling man tan, tenged papangabot a ta mga gakuntra ki yaken, simpri pangabuton kaw man danen. Tenged ake na ambal patuman ta mga gapati ki yaken, simpri inyo an na ambal tumanen man danen. ");
INSERT INTO cgc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pangabuton kaw ta mga gakuntra ki yaken tak sakep kaw ki yaken daw dili man danen kala gapadala an ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Daw ula a inta giling ta kalibutan i daw gatudlo man ki danen, ula danen sabaten na ula danen gapati ta kamatuuran na papaintindi ta Dyos paagi ki yaken. Piro, tenged giling a di daw gatudlo man ki danen, ula en rason na danen an dili magpati. ");
INSERT INTO cgc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bisan kino na gademet ki yaken, gademet man kanen ta ake na Amay. ");
INSERT INTO cgc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Daw ula ko inta papakita naan ta mga ittaw mga katingalaan na buat ko na dili mabuat ta duma na mga ittaw, ula danen sabaten na ula danen gapati ta kamatuuran na papaintindi ta Dyos paagi ki yaken. Piro, maskin nakita en danen mga katingalaan na nabuat ko, yaken i daw ake na Amay pademetan man gyapon danen. ");
INSERT INTO cgc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tenged ta iran na pagdemet, natuman ambal naan ta sinulat na pulong ta Dyos, ‘Pademetan a danen bisan na ula a sala.’” ");
INSERT INTO cgc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ambal pa Jesus, “Ta paabuton na adlaw, mabot isya an na magduma ki kyo sal-i ki yaken na pailingen ko ki kyo alin ta ake na Amay. Kanen magsugid ki kyo parti ki yaken. Kanen an Dyos Ispiritu Santo na manugtudlo ta kamatuuran daw ipadala man ta ake na Amay. ");
INSERT INTO cgc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kyo man, dapat na magsugid ta mga ittaw parti ki yaken tak alin pa kan-o na gaumpisa a ta pagtudlo gaduma kaw en ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Pasugid ko en mga matabo an ki kyo aged daw mabot uras na matabo, dili kaw marwaran ta pagsalig ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kyo yan bawalan na magselled naan ta mga balay tipunan ta mga Judio. Dili nang nyan, mabot man uras na daw kino magpatay ki kyo, ta iran na isip gasirbi danen ta Dyos paagi ta pagpatay ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iling tan buaten danen ki kyo tak ula danen an kakala ta ake na Amay daw ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Paambal ko ki kyo anduni aged daw may matabo na iling tan, mademdeman nyo mga ambal ko.” Gambal pa Jesus i naan ta iya na mga tinudluan, “Ta primiro, ula ko nasugid ki kyo mga matabo ki kyo tak duma a nyo pa. ");
INSERT INTO cgc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Piro anduni, dili aren maglugay na duma ki kyo tak malik aren naan ta gapadala ya ki yaken. Maskin iling tan sugid ko, ula bisan isya ki kyo gainsa daw indi a punta. ");
INSERT INTO cgc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Gangasebe kaw gid tenged ta ake na sugid. ");
INSERT INTO cgc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Piro, sugiran ta kyo ta matuod na mas dayad para ki kyo daw bilin ta kyo tak daw magpadayon a na duma ki kyo, dili miling isya an na magduma ki kyo na sal-i ki yaken na mag-ubay ki kyo. Piro daw bilin ta kyo, ipadala ko kanen an naan ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Daw mabot kanen an, ipaintindi din ta mga ittaw na ula gapati ta Dyos parti ta iran na sala, ake na pagkamatareng daw pagsintinsya ta Dyos ki danen. ");
INSERT INTO cgc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Parti ta sala, ipaintindi din ta mga ittaw na danen an nakasala na kuntra ta Dyos tak ula danen gatuo ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Parti ta pagkamatareng, ipaintindi din na matuod na yaken matareng. Yi pamatuod na yaken i matareng: Malik a ta ake na Amay daw dili a nyo makita paryo ta pambal ko ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Parti ta pagsintinsya, ipaintindi din ta mga ittaw na ula gapati ta Dyos na sintinsyaan danen an ta Dyos tak Satanas an na pasunod danen nasintinsyaan din en. ");
INSERT INTO cgc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Tama pa inta mga ambalen ko ki kyo, piro dili nyo pa maintindian anduni tenged ta inyo na kasebe. ");
INSERT INTO cgc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ta paabuton na adlaw na mabot Dyos Ispiritu Santo na manugtudlo ta kamatuuran, tabangan kaw din para maintindian nyo tanan na kamatuuran na alin ta Dyos. Mga isugid din ki kyo dili alin ta iya nang na isip tak isugid din an mga namatian din alin ta Dyos Amay daw isaysay din man mga matabo pa ya. ");
INSERT INTO cgc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ipakala din na daw ino naan ta Dyos naan man ki yaken tak ipaintindi din ki kyo ake an na mga ambal daw mga buat. ");
INSERT INTO cgc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tanan na naan ta ake na Amay, yon man naan ki yaken. Yon tenaan na gambal a na ake an na mga ambal daw mga buat ipaintindi ta Dyos Ispiritu Santo ki kyo.” ");
INSERT INTO cgc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Gapadayon Jesus i ta pag-ambal naan ta iya na mga tinudluan, “Dali nang en mabot uras na dili a nyo makita. Piro, ula nang man lugay makita nyo yaken i isab.” ");
INSERT INTO cgc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Gainsaay pila na mga tinudluan din, “Ino beet din ambalen na dali nang en mabot uras na dili ta kanen an makita, piro ula nang man lugay makita ta kanen an isab? Ino beet din ambalen na miling kanen an ta iya na Amay?” ");
INSERT INTO cgc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sigi pa danen insaay, “Ino beet din ambalen na ula nang en lugay? Dili ta maintindian daw ino beet din ambalen.” ");
INSERT INTO cgc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nlaman Jesus na liag inta ta mga tinudluan din na mag-insa ki kanen. Gambal kanen i ki danen, “Di' ba gainsaay kaw daw ino beet ko ambalen na dali nang en mabot uras na dili a nyo makita, piro ula nang man lugay makita nyo man yaken i isab? ");
INSERT INTO cgc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sigurado gid na matabo iling an tan daw sugiran ta kyo na mabot adlaw na mag-ug-og kaw daw mag-aya, piro mga ittaw an na ula gapati ta Dyos magkalipay. Mangasebe kaw, piro ta uryan marwad en inyo an na kasebe daw masilian ta kalipay. ");
INSERT INTO cgc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iling tan na maagian nyo paryo ta inagian ta bai na gapasakit daw segeng iya na pamatyag tak gabot uras na magbata en. Piro, na kabata en kanen an, malipatan din en iya na kasakit tenged ta bakod din na kalipay na natao iya na bata. ");
INSERT INTO cgc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Iling man tan kyo yan tak gangasebe kaw anduni, piro mabot adlaw na magkitaay ki isab daw malipay kaw. Bisan ino buaten ta duma na mga ittaw naan ki kyo, dili marwad inyo an na kalipay. ");
INSERT INTO cgc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Umpisa ta adlaw na malik a naan ta ake na Amay, dili kinanglan en na naan kaw ki yaken mangabay ta bisan ino. Igo gid na dili kaw en naan ki yaken mangabay daw sugiran ta kyo na daw naan kaw ta ake na Amay mangabay ta bisan ino bilang mga sakep ki yaken, iatag din. ");
INSERT INTO cgc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta anduni ula kaw pa gapangabay naan ta ake na Amay bilang mga sakep ki yaken. Anduni, naan kaw ki kanen mangabay. Sigurado na iatag din inyo na papangabay daw malipay kaw gid. ");
INSERT INTO cgc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ake na ambal ki kyo anduni paagi ta mga paanggid na isturya. Piro, mabot adlaw na dili aren mag-ambal paagi ta mga paanggid. Ipaintindi ko ta usto ki kyo parti an ta ake na Amay. ");
INSERT INTO cgc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta yon man na adlaw, kyo mismo magpangabay naan ta ake na Amay bilang mga sakep ki yaken. Dili ko beet ambalen na yaken nang gid mangabay an naan ta ake na Amay para ki kyo. ");
INSERT INTO cgc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pwidi na kyo mismo mangabay naan ta ake na Amay tenged kyo yan pagugma din gid. Pagugma kaw din tak gagugma kaw man ki yaken daw gapati kaw na yaken alin ta ake na Amay. ");
INSERT INTO cgc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Alin a ta ake na Amay na giling a di ta kalibutan i. Piro anduni, malin aren daw malik ta ake na Amay.” ");
INSERT INTO cgc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ambal ta mga tinudluan Jesus, “Anduni, naintindian nay en imo an na ambal tak ula ka en gambal paagi ta mga paanggid. ");
INSERT INTO cgc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Anduni, sigurado kay gid na nlaman no tanan. Dili en kinanglan na insaan ka pa ta bisan kino tak maskin ula pa gainsa ki kaon, nlaman no en iya na isip. Gani, gapati kay na alin ka gid ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dayon ambal Jesus naan ta iya na mga tinudluan, “Ta kalugayen, gapati kaw gid man ki yaken! ");
INSERT INTO cgc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Piro, mabot man en uras daw anduni en na magbelag-belagay kaw. Kada isya ki kyo muli ta iya na balay daw dilian a nyo. Piro, bisan dilian a nyo na yaken nang, dili a isya nang tak ake na Amay pirmi gaduma ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iling tan paambal ko ki kyo aged magtawway inyo na nakem paagi ta inyo na pagsalig ki yaken. Maagian nyo mga kabellay naan ta kalibutan i, piro biskegen nyo inyo na nakem tak napirdi ko en mga gakuntra ta Dyos naan ta kalibutan i.” ");
INSERT INTO cgc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagtapos Jesus ta ambal naan ta iya na mga tinudluan, gaangad kanen an naan ta langit daw gapangamuyo, “Amay ko, gabot en uras na matuman imo an na plano para ki yaken. Ipakala no ta mga ittaw na daw ino naan ki kaon, naan man ki yaken na imo na Bata aged ipakala ko ta mga ittaw daw kino gid kaon yan. ");
INSERT INTO cgc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Iling tan na pabuat no ki yaken tak paatagan a no ta uturidad ta pagdumala ta tanan na mga ittaw aged tanan danen na patugyan no ki yaken, tagan ko ta kabui na ula katapusan. ");
INSERT INTO cgc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yi paagi na maangken ta mga ittaw kabui na ula katapusan: Makala gid danen ta usto kaon yan na matuod na Dyos daw yaken na Jesu-Cristo na imo na papadala. ");
INSERT INTO cgc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Unti ta kalibutan i napakala ko en ta mga ittaw daw kino gid kaon yan paagi ta pagtuman ko ta mga papabuat no ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Gani, Amay ko, ta pagbalik ko na duma isab ki kaon, ibalik no dapat an na pagkala ki yaken na kiten isya nang ta uturidad paryo kan-o na anen a pa dyan duma ki kaon bag-o nabuat kalibutan i.” ");
INSERT INTO cgc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Gapadayon Jesus i ta pagpangamuyo, “Napakala ta kaw gid en naan ta yi na mga mama. Danen an mga papili no aged dili danen en magparyo ta mga gakuntra ki kaon daw patugyan no danen an naan ki yaken. Dati danen an imo na mga ittaw, piro patugyan no naan ki yaken. Patuman danen imo an na ambal. ");
INSERT INTO cgc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Anduni, nlaman en danen na tanan na patudlo ko naan alin ki kaon. ");
INSERT INTO cgc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tanan na ambal no ki yaken natudlo ko en ki danen daw pabaton man danen. Nlaman danen na alin a gid ki kaon daw gapati man danen an na kaon gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Anduni, ula a gapangamuyo para ta mga ittaw na ula gatuo. Gapangamuyo a para nang ta mga ittaw na patugyan no ki yaken tak danen an imo na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tanan an na imo na mga ittaw, ake man na mga ittaw daw tanan na ake na mga ittaw imo man. Paagi ki danen papakala a na daw ino naan ki kaon naan man ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dili aren magtinir ta kalibutan i. Malik aren ki kaon, piro danen an mabilin pa ta kalibutan i. Amay ko, kaon nang gid matuod na Dyos. Ambligan no danen an paagi ta imo na gaem na yon man gaem na paatag no ki yaken aged danen tanan mag-isya paryo ki kiten. ");
INSERT INTO cgc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mintras na duma a pa ta mga ittaw na patugyan no ki yaken, paubayan ko danen an daw paambligan ko man paagi ta gaem na paatag no ki yaken. Ula ko papabay-i danen an, piro may isya ki danen na maageman din silot na ula katapusan aged matuman ambal na naan ta imo na sinulat na pulong. ");
INSERT INTO cgc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Malik aren naan ki kaon. Piro, mintras na anen a pa di ta kalibutan i, anduni iling ti ambal ko ta ake na pangamuyo aged mamatian man danen daw malipay gid danen an paryo ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Patudlo ko ki danen imo an na ambal, piro pademetan danen an ta mga ittaw na gakuntra ki kaon tak paryo danen ki yaken na ula gasunod ta batasan ta mga ittaw na gakuntra ki kaon. ");
INSERT INTO cgc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ula a gapangamuyo na kamangen no en danen an ta kalibutan i. Gapangamuyo a na ambligan no danen an aged dili danen an buatan Satanas ta malain. ");
INSERT INTO cgc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Danen an paryo ki yaken tak ula danen gasunod ta batasan ta mga ittaw na gakuntra ki kaon. ");
INSERT INTO cgc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Paagi ta kamatuuran na patudlo ki danen imuon no danen an na imo gid na mga ittaw na magsirbi ki kaon. Kamatuuran imo na pulong. ");
INSERT INTO cgc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Paryo man na papadala a no naan ta kalibutan i, papadala ko danen an naan ta mga ittaw aged magsugid parti ta kamatuuran. ");
INSERT INTO cgc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Paalad ko ake na kaugalingen ta pagsirbi ki kaon para ta iran na kayaran aged imuon no danen an imo gid na mga ittaw na magsirbi man ki kaon sunod ta kamatuuran na patudlo ki danen.” ");
INSERT INTO cgc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Gapadayon pa gid Jesus i ta iya na pagpangamuyo, “Amay ko, gapangamuyo a dili nang para ta mga tinudluan ko. Gapangamuyo a man para ta mga ittaw na magtuo ki yaken paagi ta tudlo ta mga tinudluan ko ");
INSERT INTO cgc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","aged tanan na mga magtuo ki yaken mag-isya na paryo ki kiten na kaon na Amay ko naan ka ki yaken daw yaken naan a ki kaon. Yon man, kiten i daw mga ittaw na magtuo ki yaken mag-isyaay aged duma na mga ittaw magpati man na kaon gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Katengdanan na paatag no ki yaken na kaon ipakala ko naan ta mga ittaw daw kino gid kaon yan, yon man na katengdanan paatag ko ki danen aged mag-isyaay danen an na paryo ki kiten na isya nang. ");
INSERT INTO cgc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yaken naan a ki danen daw kaon naan ka ki yaken aged danen an mag-isya nang gid. Daw mag-isya danen an, mlaman ta mga ittaw na kaon gapadala ki yaken daw gagugma ka man ta tanan na mga gatuo paryo man ta paggugma no ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amay ko, gusto ko na mga ittaw na patugyan no ki yaken magduma man ki yaken naan ta ake na ilingan aged makita danen na naan man ki yaken katengdanan na paryo gid ta imo na katengdanan na paatag no ki yaken. Yon na katengdanan paatag no ki yaken tenged ta imo na pagpalangga ki yaken bag-o nabuat kalibutan i. ");
INSERT INTO cgc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Amay ko na matareng ta tanan, mga ittaw na gakuntra ki kaon ula kakala ki kaon. Piro yaken a, kakala a gid ki kaon daw nlaman man ta mga tinudluan ko na kaon gapadala ki yaken. ");
INSERT INTO cgc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Napakala ko en kaon yan ki danen daw magpadayon a pa gid ta pagpakala ki kaon naan ki danen aged maggugmaay danen an paryo ta imo na paggugma ki yaken daw yaken naan a man ki danen.” ");
INSERT INTO cgc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagtapos ta pagpangamuyo Jesus, gapanaw kanen an na duma ta iya na mga tinudluan pagwa ta Jerusalem daw galakted naan ta Sapa Cedron. Naan ta liyo may taneman ta olibo daw naan dya danen an gateneng. ");
INSERT INTO cgc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas na magtraydor ki Jesus, natultulan din man taneman ya ta olibo tak naan dya pirmi gatipon danen Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Giling dya Judas an daw gadala ta grupo ta mga sundalo asta mga gwardya ta Timplo na papadala ta mga manugdumala na mga pari daw mga Pariseo. Danen Judas gadala ta mga ilaw na bat-aw, mga parol daw mga armas man. ");
INSERT INTO cgc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tenged nlaman Jesus tanan na matabo ki kanen, pasugat din danen an Judas daw painsaan, “Kino pangita nyo?” ");
INSERT INTO cgc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Sabat danen, “Jesus na taga-Nazaret.” Ambal Jesus ki danen, “Yaken ni.” Judas na traydor anen man dya na gatindeg duma ta mga ittaw na gangita ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pag-ambal Jesus “Yaken ni”, dayon danen tanan atras daw natumba. ");
INSERT INTO cgc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Gainsa isab Jesus i ki danen, “Kino gid inyo na pangita?” Sabat danen isab, “Jesus na taga-Nazaret.” ");
INSERT INTO cgc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ambal Jesus, “Paambal ko en ki kyo na yaken ni. Tenged yaken pangita nyo, tugutan nyo nang na mga duma ko malin di.” ");
INSERT INTO cgc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ta pag-ambal Jesus ta iling tan, natuman ambal din ya naan ta iya na Amay, “Mga patugyan no ki yaken ula bisan isya ki danen na narwad ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dayon pagabot Simon Pedro ispada na dala din daw patigbas din suguon ya ta pinakadatas na manugdumala ta mga pari daw nalantep gid tuo na talinga. Malco ngaran ta suguon ya. ");
INSERT INTO cgc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Piro, Pedro i paambalan Jesus, “Balik no ta tageban ispada no an! Kinanglan na batunon ko segeng na kabellay na maagian ko na naan en ta plano ta ake na Amay para ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na tapos en Jesus ta ambal ki Pedro, mga sundalo daw iran na kumander daw mga gwardya ta Timplo padakep danen Jesus an. Pagapos danen kanen an ");
INSERT INTO cgc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","daw padala naan ki Anas na ugwangan Caifas. Caifas i pinakadatas na manugdumala ta mga pari ta yo na taon ");
INSERT INTO cgc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","daw kanen man ittaw na gambal naan ta mga manugdumala ta Judio na dayad pa daw may isya na ittaw na mapatay para ta iran na nasyon. ");
INSERT INTO cgc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na Jesus an padala ta mga sundalo daw mga gwardya naan ta istaran Anas na pinakadatas na manugdumala ta mga pari, Simon Pedro daw isya pa na tinudluan gasunod ki Jesus. Tinudluan i na duma Pedro kala ta pinakadatas na pari. Tenged kanen kala, kaselled kanen na duma ki Jesus naan ta sular ta istaran ta pinakadatas na pari. ");
INSERT INTO cgc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piro, Pedro nabilin naan gwa ta sular. Tinudluan i na gaselled, kanen i gabalik naan ta gwa daw galisinsya ta bai na gabantay ta gangaan daw pwidi paselleren Pedro an. Paglisinsya din naan ta bai, papaselled ta bai Pedro an. ");
INSERT INTO cgc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Gainsa bai i ki Pedro, “Kaon isya man ta mga tinudluan ta yon na ittaw na padakep danen?” Sabat Pedro, “Dili a!” ");
INSERT INTO cgc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tenged yon na kilem tignaw, mga suguon daw mga gwardya gamaket ta apoy daw gatindeg danen na galibot naan ta apoy aged magpadangga. Pedro gatindeg man na duma ki danen daw gapadangga man. ");
INSERT INTO cgc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Naan ta selled ta istaran Anas na pinakadatas na manugdumala ta mga pari, gaimbistigar Anas an ki Jesus parti ta mga tinudluan Jesus daw iya man na pagtudlo. ");
INSERT INTO cgc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Sabat Jesus, “Ula a gambal ta sikrito nang naan ta mga ittaw. Yaken i gatudlo naan ta tama na mga ittaw. Pirmi a gatudlo naan ta mga balay tipunan daw Timplo na naan dya mga Judio an gatipon. ");
INSERT INTO cgc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Man-o tak gainsa kaw ki yaken? Insaan nyo mga ittaw an na kamati ki yaken tak nlaman danen daw ino mga naambal ko.” ");
INSERT INTO cgc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pag-ambal Jesus, gulpi nang kanen an patampaling daw pasaway ta isya na gwardya, “Man-o tak iling tan sabat no an ta pinakadatas na manugdumala ta mga pari?” ");
INSERT INTO cgc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sabat Jesus, “Daw sala sabat ko an, mambal ka nang daw ino lain naan ta sabat ko ya. Piro, daw usto sabat ko, man-o tak patampaling a no?” ");
INSERT INTO cgc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na nagapos pa Jesus i, papadala kanen Anas naan ki Caifas na pinakadatas na manugdumala ta mga pari ta yo na taon. ");
INSERT INTO cgc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na gatindeg Simon Pedro i naan dani ta apoy daw gapadangga, may gainsa ki kanen, “Kaon isya ta mga tinudluan ta ittaw ya na paimbistigar danen anduni?” Ula gaako Pedro an. Sabat din, “Dili a!” ");
INSERT INTO cgc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Anen man dya isya na suguon ta pinakadatas na manugdumala ta mga pari na parinti ta mama na patigbas Pedro naan ta talinga. Gainsa suguon i ki Pedro, “Di' ba nakita ko kaon yan na duma Jesus gina naan ta taneman ta olibo?” ");
INSERT INTO cgc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ula eman gaako Pedro i na kanen duma Jesus. Dayon, gatagaok manok. ");
INSERT INTO cgc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kasanagen en na natapos Caifas iya na pag-imbistigar ki Jesus. Mga Judio na gadakep ki Jesus padala danen kanen an naan ta Pretorio na palasyo Gubirnador Pilato. Ula gaselled mga Judio naan ta palasyo ya tenged dili danen gusto na bilangen na “dili-limpyo”. Ta iran na kaugalian, daw magselled danen ta istaran ta dili-Judio, dili en danen mga “limpyo” na yon man bawal ki danen maan ta yapon ta pagsilibrar ta Pista Ta Paglibri Alin Ta Egipto. ");
INSERT INTO cgc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato i gagwa na gatubang ta mga Judio daw gainsa, “Ino akusar nyo kuntra ki Jesus?” ");
INSERT INTO cgc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Sabat ta mga Judio, “Ula duma na tenaan na padala nay kanen an ki kaon daw dili, gabuat kanen ta malain.” ");
INSERT INTO cgc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ambal Pilato, “Dleen nyo kanen an malik daw kyo magsintinsya paagi ta inyo na kasuguan.” Sabat danen, “Ula kay uturidad ta pagsintinsya ta kamatayen.” ");
INSERT INTO cgc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ta iran na ambal na iling tan, natuman ambal Jesus daw ino paagi na mapatay kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pag-ambal danen, gaselled isab Pilato ta iya na palasyo daw paumaw din Jesus daw painsaan din, “Kaon ari ta mga Judio?” ");
INSERT INTO cgc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sabat Jesus na gainsa man, “Imo gid na insa nyan? May gasugid ki kaon parti ki yaken?” ");
INSERT INTO cgc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Sabat Pilato, “Ino ta isip no, Judio a? Mga paryo no na Judio daw mga manugdumala na mga pari, danen gadala ki kaon di. Ino gid nabuat no na sala?” ");
INSERT INTO cgc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Sabat Jesus, “Ake na padumalaan bilang ari dili naan ta kalibutan i. Daw unti a inta gaari naan ta kalibutan i, ake na mga sinakepan magbatok ta mga manugdumala ta Judio aged dili a danen dakepen. Piro, ake na padumalaan bilang ari dili naan ta kalibutan i.” ");
INSERT INTO cgc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ambal Pilato, “Daw iling tan, kaon pla ari?” Ambal Jesus, “Kaon en gambal san na yaken i ari. Tuyo ko na giling a ta kalibutan i na natao aged magsugid ta kamatuuran. Bisan kino na gusto mlaman kamatuuran an, kanen gapati ta ake na mga ambal.” ");
INSERT INTO cgc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Gainsa Pilato i, “Ino kamatuuran an?” Na tapos en Pilato an ta pag-ambal ki Jesus, gagwa kanen isab daw gambal parti ki Jesus naan ta mga Judio na gatipon dya, “Ula a may nakita na sala para akusaran nyo kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Di' ba may kaugalian kaw na daw timpo ta Pista Ta Paglibri Alin Ta Egipto gapangabay kaw ki yaken na magpalibri a ta isya na priso? Liag nyo na librien ko ari an ta mga Judio?” ");
INSERT INTO cgc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Gasinggit danen an, “Dili ittaw na yan librien no. Barabas ya librien no!” -- Barabas ya, kanen isya na tulisan. ");
INSERT INTO cgc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pag-ambal danen na librien Barabas ya, gasugo Pilato an na dleen Jesus i daw latiguon. ");
INSERT INTO cgc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pagtapos ta paglatigo ki Jesus, mga sundalo an gakamang ta telleken na tanem daw palubid na pabuat na kuruna daw pabetang danen naan ta ulo Jesus. Pabayuan danen Jesus i ta bayulit na pang-apaw. ");
INSERT INTO cgc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Gaeles-elesay na gaprani danen an ki Jesus daw gambal, “Mabuay ari ta mga Judio!” Sigi danen tampaling Jesus an. ");
INSERT INTO cgc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato an gagwa isab daw gatubang ta mga ittaw na gatipon dya daw gambal, “Mamati kaw. Jesus an pagwaen ko isab daw ipatubang ki kyo aged mlaman nyo na ula a gid may nakita na sala para akusaran nyo kanen an.” ");
INSERT INTO cgc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pag-ambal Pilato, gagwa Jesus i daw naan pa ta iya na ulo kuruna an na telleken daw suot din pa bayulit na bayo. Ambal Pilato, “Tan-awen nyo ittaw na i.” ");
INSERT INTO cgc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na Jesus i nakita ta mga manugdumala na mga pari daw mga gwardya, gasinggit danen an, “Ilansang kanen an naan ta krus! Ilansang kanen an naan ta krus!” Ambal Pilato ki danen, “Kyo nang en magdala ki kanen daw ilansang tak ula a may nakita na sala para akusaran nyo kanen an.” ");
INSERT INTO cgc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sabat ta mga manugdumala ta Judio, “Naan ta Mga Sinulat Moises may sugo na dapat sintinsyaan ta kamatayen ittaw na gaako na kanen Bata Ta Dyos. Tenged gaako Jesus na kanen Bata Ta Dyos, dapat kanen an sintinsyaan ta kamatayen.” ");
INSERT INTO cgc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagmati Pilato ta ambal ta mga manugdumala na Jesus gaako na kanen Bata Ta Dyos, gadugang pa gid kaadlek Pilato. ");
INSERT INTO cgc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Padala din isab Jesus an naan ta selled ta palasyo daw painsaan, “Taga-indi ka gid?” Piro, Jesus an ula gasabat. ");
INSERT INTO cgc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Insa Pilato, “Man-o tak ula ka gasabat? Ino, ula no nlami na may uturidad a ta paglibri ki kaon daw may uturidad a man ta pagpalansang ki kaon naan ta krus?” ");
INSERT INTO cgc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sabat Jesus, “Imo na uturidad ta paglibri ki yaken daw pagpalansang naan ta krus naan alin ta Dyos. Gani, mga ittaw an na gadala ki yaken naan ki kaon mas bakod iran na sala kaysa ta imo na sala.” ");
INSERT INTO cgc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagmati Pilato ta ambal Jesus, gangita pa gid kanen an ta paagi na librien din Jesus an. Piro, mga manugdumala an ta Judio gapadayon ta pagsinggit, “Daw librien no ittaw na yan, dili ka en arey ta pangulo ta Roma tak bisan kino na gaako na kanen ari, gakuntra kanen an ta pangulo ta Roma.” ");
INSERT INTO cgc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagmati Pilato ta singgit danen, gagwa kanen an daw padala din Jesus an mwa. Gapungko Pilato naan ta pungkuan ta uwis na naan ta sular na paumaw na Saag Na Paipid-ipid Na Mga Bato, na naan ta linggwai na Hebreo paumaw na Gabbata. ");
INSERT INTO cgc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na gapungko Pilato naan ta pungkuan ta uwis, ugto-adlaw ta adlaw ta pagpriparar para ta Pista Ta Paglibri Alin Ta Egipto. Gambal Pilato naan ta mga Judio na gatipon dya, “Yi inyo na ari.” ");
INSERT INTO cgc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Piro, gasinggit pa gid danen an, “Patayen kanen an! Patayen kanen an! Ilansang kanen an naan ta krus!” Ambal Pilato ki danen, “Inyo i na ari liag nyo na ipalansang ko naan ta krus?” Sabat ta mga manugdumala na mga pari, “Ula kay duma na ari daw dili, pangulo ta Roma.” ");
INSERT INTO cgc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pagmati Pilato ta iran na ambal, pasunod din nang en iran na gusto. Jesus i paintriga Pilato naan ta mga sundalo aged ilansang naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Papas-an danen ki kanen krus an na naan don kanen an ilansang. Padala danen kanen i pagwa alin ta Jerusalem na miling naan ta Bungyod Balbagol na naan ta linggwai na Hebreo paumaw man na Golgota. ");
INSERT INTO cgc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Naan ta bungyod ya palansang danen Jesus i naan ta krus. Palansang man danen darwa na kriminal naan ta mga krus. Patindeg danen krus Jesus daw mga krus ta darwa na kriminal. Krus an Jesus naan ta tengnga daw iya ta mga kriminal naan dapit ta timbang kilid krus Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato an may papasulat na karatula daw papabetang din naan ta krus Jesus. Iling ti nasulat ya, “JESUS NA TAGA-NAZARET, ARI TA MGA JUDIO.” ");
INSERT INTO cgc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tama na mga ittaw kabasa ta karatula ya ta iran na paglambay tak dani ta syudad Jerusalem lugar an na naan dya Jesus pasilutan ta kamatayen daw nasulat ya naan ta karatula naan ta mga linggwai na Hebreo, Latin daw Griego. ");
INSERT INTO cgc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mga manugdumala na mga pari gariklamo ki Pilato, “Ula no inta papasulat na Jesus an ari ta mga Judio. Ipasulat no na Jesus gaako na kanen ari ta mga Judio.” ");
INSERT INTO cgc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ambal Pilato, “Napasulat ko an dili ko en silian.” ");
INSERT INTO cgc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Paglansang ta mga sundalo ki Jesus naan ta krus, pakamang danen mga bayo din ya daw paulas-ulas danen appat ya na kada sundalo may iya na parti. May isya na bayo na ula pa naulas daw yon na bayo buat ta inabel na tila na ula tagduan alin apaw asta ebes. ");
INSERT INTO cgc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Gaisturyaay mga sundalo, “Dili ta gisien ni. Maggabot-gabutay ki nang aged mlaman ta daw kino kakamang ti.” Ta pagbuat danen ta iling tan, natuman ambal naan ta sinulat na pulong ta Dyos, “Paulas-ulas danen ake na mga bayo daw pagabot-gabutan.” ");
INSERT INTO cgc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Naan dani ta krus na palansangan ki Jesus, gatindeg iya na inay, bai na utod ta inay din, Maria na sawa Cleofas daw Maria Magdalena. ");
INSERT INTO cgc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nakita Jesus iya an na inay daw pinalangga din na tinudluan na gatindeg dani ta iya na inay. Pagkita din ki danen, ambal din ta iya na inay, “Nay, kabigen no na imo na bata nyan na tinudluan ko.” ");
INSERT INTO cgc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ambal din man ta tinudluan din an, “Kabigen no kanen an na imo na inay.” Umpisa ta yo na adlaw, inay Jesus naan gistar ta balay ta pinalangga na tinudluan Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pag-ambal Jesus naan ta iya na inay daw tinudluan na pinalangga, gambal kanen an, “Nlao a.” Iling tan ambal Jesus tak nlaman din na matuman en tanan na nasugo ki kanen daw paagi ta iya an na ambal, natuman ambal ya naan ta sinulat na pulong ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Naan ta dani ta palansangan ki Jesus may ugsakan na panno ta agsem na bino. Pasawsaw ta mga sundalo ispunga naan ta bino daw patuslok danen naan ta isya na sanga ta tanem na isopo daw padeel naan ta baba Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na natilawan Jesus bino an, gambal kanen an, “Natuman en.” Dayon kanen demel daw patugyan din iya na ispiritu naan ta Dyos daw nabugto iya na ginawa. ");
INSERT INTO cgc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Adlaw na palansang Jesus an naan ta krus, adlaw ta pagpriparar para ta Adlaw Ta Pagpuay. Dili gusto ta mga manugdumala ta Judio na lawa ta mga ittaw na nalansang naan ta krus mabilin naan ta mga krus asta ta Adlaw Ta Pagpuay. Yi na Adlaw Ta Pagpuay ispisyal gid ki danen tenged timpo en ta Pista. Gapangabay mga manugdumala ta Judio ki Pilato daw pwidi na balien tiked ta mga ittaw na nalansang naan ta krus aged dali iran na kamatayen daw kamangen dayon danen an naan ta iran na mga krus. ");
INSERT INTO cgc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pasugo Pilato mga sundalo na pangabay ya buaten. Pabali danen mga tiked ta darwa na ittaw na nalansang naan ta mga krus na duma ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Piro, pag-abot danen ki Jesus, ula danen pabalia iya na tiked tak nakita danen na patay en kanen an. ");
INSERT INTO cgc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kilid an ta lawa din pasandak ta isya na sundalo ta bangkaw daw dayon gapuswak lengngessa daw waig. ");
INSERT INTO cgc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yon na mga natabo ki Jesus nakita ko gid daw pasulat ko man naan ta yi na libro aged magpati kaw. Nlaman ko na ake na ambal matuod. ");
INSERT INTO cgc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tenged na mga tiked Jesus ula danen pabalia, natuman ambal naan ta sinulat na pulong ta Dyos, “Ula bisan isya na bekkeg din na mabali.” ");
INSERT INTO cgc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Natuman man isya pa na ambal naan ta sinulat na pulong ta Dyos, “Tan-awen danen ittaw an na pasandak danen.” ");
INSERT INTO cgc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","May mama na ngaran din Jose na taga-Arimatea. Kanen isya ta mga ittaw na gapati ki Jesus, piro ula kanen gasugid ta duma na ittaw na kanen isya ta mga tinudluan Jesus tak adlek kanen ta mga manugdumala ta mga Judio. Jose an giling ki Pilato daw galisinsya na kanen mamang ta lawa Jesus. Na patugutan kanen an, gapanaw kanen na mamang ta lawa Jesus naan ta krus aged lebbeng. ");
INSERT INTO cgc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo gakuyog ki kanen daw gadala ta mga trinta kilos na paammot na buat alin ta tagek ta mira daw aloe. Nicodemo an, kanen mama ya na gabisita ki Jesus ta isya ya na kilem. ");
INSERT INTO cgc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pagkamang danen ta lawa Jesus, pabetangan danen ta paammot na dala danen daw paputos paagi ta pagblebed ta tila na lino tak iling tan kaugalian ta mga Judio ta paglebbeng. ");
INSERT INTO cgc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Naan ta lugar ya na nalansang Jesus naan ta krus, may taneman ta mga kaoy daw naan ta taneman may bag-o pa nang buat na lebbengan na bato na palungagan paryo ta kwiba daw ula pa may nalebbeng dya. ");
INSERT INTO cgc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Naan dya pabetang danen Jose lawa ya Jesus tak lebbengan an dani nang daw gapura danen tenged mapon gid en ta adlaw ta pagpriparar ta mga Judio na dili nang en lugay mag-umpisa Adlaw Ta Pagpuay. ");
INSERT INTO cgc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ta una na adlaw ta duminggo, bag-o magsilak adlaw an, Maria Magdalena giling naan ta lebbengan Jesus. Pag-abot dya, nakita din na nakamang en bato ya na sara naan ta gangaan ta lebbengan. ");
INSERT INTO cgc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dayon kanen dlagan miling ki Simon Pedro daw pinalangga na tinudluan Jesus. Ambal din ki danen, “May gakamang ta lawa ya ta Ginuo naan ta iya na lebbengan daw ula nay nlami daw indi padlaa.” ");
INSERT INTO cgc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pagmati Pedro daw pinalangga na tinudluan Jesus ta ambal Maria Magdalena, giling danen naan ta lebbengan. ");
INSERT INTO cgc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Gadlagan danen an na darwa, piro mas dasig pinalangga an na tinudluan kaysa ki Pedro daw kanen una abot naan ta lebbengan. ");
INSERT INTO cgc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Galeeb kanen na gasil-ing naan ta selled ta lebbengan daw nakita din dya mga tila na lino na pablebed naan ta lawa ta Ginuo. Piro, ula kanen gaselled. ");
INSERT INTO cgc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sunod ta tinudluan na una abot, Simon Pedro man gabot naan ta lebbengan. Gaselled kanen dayon daw nakita din na naan dya tila ya na lino ");
INSERT INTO cgc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","daw lapad na panyo na paputos naan ta ulo Jesus. Piro, panyo ya naipid daw nabetang belag ta tila na lino. ");
INSERT INTO cgc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Gaselled man naan ta lebbengan pinalangga an na tinudluan na una abot. Na nakita din tila na naan dya, gapati en kanen an na Jesus nabannaw en. ");
INSERT INTO cgc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ta yo na uras ula pa danen naintindii ambal naan ta sinulat na pulong ta Dyos na naan ta plano ta Dyos na mabannaw Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na nakita en danen Pedro selled ya ta lebbengan Jesus, guli en danen an. ");
INSERT INTO cgc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Magdalena gabalik naan ta lebbengan Jesus daw gatindeg kanen naan ta gwa na gagal. Mintras gagal kanen an, galeeb kanen na gasil-ing naan ta lebbengan. ");
INSERT INTO cgc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nakita din darwa na angil na iran na suot puti. Gamungko danen an naan ta pabetangan ta lawa Jesus. Isya na angil naan dapit ta batiisan daw isya an a, naan ta uluan. ");
INSERT INTO cgc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Gainsa darwa an na angil ki Maria, “Kay, man-o tak gagal ka?” Sabat Maria, “May gakamang ta lawa ta Ginuo ko daw ula ko nlami daw indi padlaa.” ");
INSERT INTO cgc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pag-ambal Maria, gablikid kanen daw nakita din Jesus na gatindeg dya piro ula din nakala. ");
INSERT INTO cgc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ambal Jesus, “Kay, man-o tak gagal ka? Kino pangita no?” Salig Maria daw Jesus manug-asikaso ta mga tanem. Ambal din ki Jesus, “Sir, daw kaon gakamang ta iya na lawa, sugiran a no daw indi no pabetanga aged kamangen ko dya.” ");
INSERT INTO cgc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ambal Jesus ki kanen, “Maria!” Dayon Maria gatubang ki Jesus daw gambal, “Rabboni!” Naan ta linggwai na Hebreo, Rabboni beet ambalen manugtudlo. ");
INSERT INTO cgc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ambal Jesus ki Maria, “Dili ka mibit ki yaken tak ula a pa kabalik naan ta ake na Amay. Miling ka ta ake na mga tinudluan na yon man mga pakabig ko na ake na mga utod daw sugiran no na malik aren ta ake na Amay na inyo man na Amay. Kanen man ake na Dyos daw inyo man na Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tenged ta ambal Jesus, giling Maria i naan ta mga tinudluan Jesus daw gambal, “Nakita ko Ginuo.” Pasugid man Maria ki danen mga paambal Jesus ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na kilem en ta adlaw na Jesus i nabannaw, mga tinudluan din gatipon naan ta selled ta isya na balay daw patrangkaan danen mga gangaan tak adlek danen an ta mga manugdumala ta Judio. Gulpi nang gabot Jesus i daw gatindeg duma ki danen. Ambal din, “Kabay pa na tawway inyo na tagipusuon.” ");
INSERT INTO cgc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pag-ambal Jesus, papakita din mga agi ta lansang naan ta iya na mga lima daw agi man ta bangkaw naan ta kilid ta iya na lawa. Nalipay gid iya na mga tinudluan tak nakita danen Ginuo an. ");
INSERT INTO cgc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Gambal isab Jesus naan ta mga tinudluan, “Kabay pa na tawway inyo na tagipusuon. Ipadala ko kyo yan naan ta mga ittaw paryo ta pagpadala ta ake na Amay ki yaken naan ta mga ittaw aged tumanen ko iya na liag.” ");
INSERT INTO cgc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pag-ambal Jesus, gaginawa kanen an daw gambal ki danen, “Anduni Dyos Ispiritu Santo an mabaton nyo en. ");
INSERT INTO cgc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Daw kino ambalan nyo na iran na sala patawaren, Dyos man magpatawad ki danen daw danen an napatawad en. Piro, daw kino ambalan nyo na iran na sala dili patawaren, Dyos man dili magpatawad ki danen.” ");
INSERT INTO cgc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na gapakita Jesus i ta iya na mga tinudluan, ula dya duma ki danen Tomas ya na paumaw man na Kapid na isya ta dusi na apustulis. ");
INSERT INTO cgc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pasugiran nang Tomas an ta duma na mga tinudluan na ambal danen, “Nakita nay Ginuo ya!” Ambal Tomas ki danen, “Bag-o a mapati ta sugid nyo, kinanglan na makita ko mga agi ta lansang naan ta iya na mga lima daw matuslok ko ake na tudlo naan ta mga agi ta lansang naan ta iya na mga lima daw matuslok ko man ake na lima naan ta agi ta bangkaw naan ta iya na kilid.” ");
INSERT INTO cgc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Paglambay ta isya na duminggo alin ta pagbannaw ki Jesus, mga tinudluan din gatipon isab naan ta selled ta balay daw Tomas anen man dya duma ki danen. Natrangkaan mga gangaan ta balay. Gulpi nang gabot isab Jesus i daw gatindeg duma ki danen. Gambal isab Jesus, “Kabay pa na tawway inyo na tagipusuon.” ");
INSERT INTO cgc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ambal Jesus ki Tomas, “Tomas, tan-awen no ake na mga lima daw tandegen no mga agi ta lansang naan ta ake na mga lima. Tuslok no imo na lima naan ta agi ta bangkaw naan ta kilid ta ake na lawa. Dili ka en magdua-dua pa. Magpati ka na yaken ni.” ");
INSERT INTO cgc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ambal Tomas, “Kaon ake na Ginuo daw Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ambal Jesus ki Tomas, “Gapati ka en ki yaken tak nakita a no en. Piro, mga ittaw na gapati bisan ula a danen nakita, maangken danen kalipay alin ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tama pa gid na mga katingalaan na papakita Jesus naan ta iya na mga tinudluan na ula nasulat naan ta yi na libro. ");
INSERT INTO cgc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yi na libro pasulat ko para magpati kaw na Jesus an Pinili Ta Dyos Na Mag-ari daw Bata Ta Dyos daw paagi ta inyo na pagpati maangken nyo kabui na ula katapusan tenged ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Paglambay ta pila na mga adlaw, Jesus i gapakita isab naan ta iya na mga tinudluan na danen an naan dani ta Dagat Tiberias. Iling ti natabo ta iya na pagpakita ki danen: ");
INSERT INTO cgc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Naan dya Simon Pedro, Tomas na paumaw man na Kapid, Natanael na taga-Cana na banwa na sakep ta Galilea, mga kabataan Zebedeo daw darwa pa na tinudluan Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ambal Simon Pedro naan ta iya na mga duma, “Mamukot a.” Ambal man ta mga duma din, “Muyog kay.” Pag-ambal din, gapanaw danen i daw gasakay ta buti, piro bilog na kilem ula danen kamang. ");
INSERT INTO cgc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na gapawa-pawa en, gatindeg Jesus i naan ta baybay. Piro, iya na mga tinudluan ula kakala ki kanen. ");
INSERT INTO cgc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Gainsa kanen ki danen, “Mga arey, may kamang kaw?” Sabat danen, “Ula.” ");
INSERT INTO cgc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ambal din ki danen, “Taktak nyo isab pukot nyo an naan dapit ta tuo ta inyo na buti. Naan don makakamang kaw.” Pag-ambal din, pataktak isab danen pukot an. Na pabatak danen, dili en danen an karaag tak sikad tama na sidda na gaapas naan ta pukot. ");
INSERT INTO cgc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tinudluan na pinalangga Jesus gambal ki Simon Pedro, “Ginuo nya.” Pagmati Simon Pedro na Ginuo nya, dayon kanen an suksok ta iya na bayo na nalubbas din daw gatugpa naan ta dagat aged miling naan ta Ginuo. ");
INSERT INTO cgc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Piro, duma na mga tinudluan na naan pa ta buti ya gapailis daw paguyod pukot an na panno ta sidda asta na kalambot danen an naan ta baybay. Paguyod nang danen pukot an tak dili gid danen an madyo ta baybay an. Mga kwarintay-nuibi duppa nang kamadyuon an. ");
INSERT INTO cgc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagtakas danen, nakita danen na may pasugba na sidda. May anen man dya tinapay. ");
INSERT INTO cgc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Gambal Jesus i ki danen, “Dlaan a nyo ta sidda na kamang nyo.” ");
INSERT INTO cgc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Gapanaik Simon Pedro an ta iran na buti daw pabeteng naan ta baybay pukot an na panno ta darko na mga sidda, mga sinto singkwintay-tris bilog. Piro, bisan sikad tama na mga sidda, pukot an ula nagisi. ");
INSERT INTO cgc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ambal Jesus ki danen, “Manaw kaw di daw mamaaw.” Tanan danen ula gangaas na minsa daw kino kanen an tak nlaman danen en na kanen Ginuo. ");
INSERT INTO cgc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pakamang Jesus mga tinapay an daw paatag din ki danen. Yon man sidda an. ");
INSERT INTO cgc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yi en pangallo bisis na gapakita Jesus naan ta iya na mga tinudluan alin ta iya na pagbannaw. ");
INSERT INTO cgc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na mga tinudluan an kakaan en, gainsa Jesus i ki Simon Pedro, “Simon na bata Juan, pagugma a no mas pa ta iran na paggugma?” Sabat Simon, “Ee, Ginuo, nlaman no na pagugma ta kaw.” Ambal Jesus ki Pedro, “Ambligan no ake na mga ittaw paryo ta pag-amblig ta isya na manugbantay ta iya na mga karniro.” ");
INSERT INTO cgc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Gainsa isab Jesus i ki Simon ta pangarwa na bisis, “Simon na bata Juan, pagugma a no?” Sabat isab Simon, “Ee, Ginuo, nlaman no na pagugma ta kaw.” Ambal isab Jesus, “Ambligan no ake na mga ittaw paryo ta pag-amblig ta isya na manugbantay ta iya na mga karniro.” ");
INSERT INTO cgc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ta pangallo na bisis gainsa Jesus i ki Pedro, “Simon na bata Juan, pagugma a no?” Nasebean Pedro tak tallo gid bisis kanen an painsaan Jesus na daw pagugma din gid Jesus an. Sabat Pedro, “Ginuo, nlaman no tanan daw nlaman no gid na pagugma ta kaw.” Ambal isab Jesus ki Pedro, “Ambligan no ake na mga ittaw paryo ta pag-amblig ta manugbantay ta iya na mga karniro. ");
INSERT INTO cgc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Buaten no gid iling an tan daw gambal a ki kaon na pugya na bata ka pa daw may panawan ka, kaon gaimes ta imo na kaugalingen na gaigot ta imo na bakles daw gapanaw ka man naan ta bisan indi nang na gusto no ilingan. Piro, dili iling tan daw manakem ka en. Daw manakem ka en, mag-untay ka ta imo na blukan daw igutan ka man ta duma na ittaw daw dleen ka danen ta dili no gusto ilingan.” ");
INSERT INTO cgc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iling tan ambal Jesus ki Pedro para mlaman daw ino klasi kamatayen Pedro daw mlaman man na paagi ta iya na kamatayen Dyos an dayawen. Ambal Jesus ki Pedro, “Magsunod ka ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na gapanaw Jesus i daw Pedro, gablikid Pedro an daw nakita din na gasunod ki danen tinudluan ya na pinalangga gid Jesus. Tinudluan na pinalangga, kanen tinudluan na ta pagyapon danen bag-o napatay Jesus gasandig ki Jesus daw gainsa daw kino magtraydor ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagkita Pedro ta pinalangga na tinudluan Jesus na gasunod ki danen, gainsa kanen ki Jesus, “Ginuo, ino matabo ta yon na tinudluan?” ");
INSERT INTO cgc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sabat Jesus ki Pedro, “Daw gusto ko na mabui pa yon na tinudluan asta ta adlaw na malik a, ino ki kaon? Kaon imo a, magsunod ka nang ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tenged ta ambal ya Jesus, galapta naan ta tama na mga utod ta pagtuo isturya ya na pinalangga na tinudluan din dili mapatay. Piro, ula gambal Jesus na dili mapatay pinalangga na tinudluan. Iling ti ambal din: “Daw gusto ko na mabui pa yon na tinudluan asta ta adlaw na malik a, ino ki kaon?” ");
INSERT INTO cgc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yaken mismo pinalangga an na tinudluan Jesus na gasunod ki kanen daw ki Pedro na danen an gapanaw naan ta baybay. Yaken man tinudluan an na gasugid ta mga natabo daw pasulat ko man naan ta yi na libro. Nlaman nyo na ake na ambal matuod. ");
INSERT INTO cgc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tama pa gid buat Jesus na ula nasulat naan ta yi na libro. Daw isya-isyaen isulat, kulang pa kalibutan i na betangan ta mga libro na sulatan parti ta mga binuatan din tak sikad tama.");
INSERT INTO cgc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dungganen na Teofilo, Ta una na libro na ake na pasulat, pasaysay ko parti ta tanan na mga pabuat daw patudlo Jesus ");
INSERT INTO cgc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta ta adlaw na kanen an padala na malik naan ta langit. Na ula pa kanen an gabalik naan ta langit, may tugon bilin kanen an paagi ta Dyos Ispiritu Santo para ta napili din na mga apustulis. ");
INSERT INTO cgc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Seled ta kwarinta na adlaw tapos ta iya na kamatayen daw pagbannaw, gapakita kanen an ki danen daw pamatuuran din gid ta tama na mga bisis na kanen an bui. Ta pagkitaay danen daw Jesus, gatudlo man kanen an parti ta pagdumala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ta isya na adlaw na gatipon danen Jesus na gakaan, gambal kanen an, “Dili kaw anay mag-alin ta Jerusalem. Magtagad kaw nang asta matuman pangako ya ta Dyos na ake na Amay. Papangako din na Dyos Ispiritu Santo ipadala ki kyo paryo ta nasugid ko en kan-o. ");
INSERT INTO cgc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan ya gabautismo ta mga ittaw paagi ta waig piro kyo yan, ta paglambay ta pila na mga adlaw mabautismuan kaw paagi ta Dyos Ispiritu Santo.” ");
INSERT INTO cgc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na gatipon mga apustulis an daw Jesus naan ta isya na bukid, gainsa danen an ki kanen, “Ginuo, yi en taan timpo para palinen gubirno ta Roma aged ibalik no isab naan ki kiten na mga linai Israel pagdumala an ta ate na lugar?” ");
INSERT INTO cgc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sabat Jesus, “Dili para ki kyo na mlaman daw kan-o matabo tak Dyos an na ake na Amay, kanen nang gid may katengdanan ta pagtirmino ta mga timpo daw ta mga matabo. ");
INSERT INTO cgc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Piro, ta pagbaton nyo ta Dyos Ispiritu Santo, mabaton nyo gid gaem na alin ta Dyos daw magsugid kaw parti ki yaken naan ta syudad Jerusalem, ta bilog na Judea, naan ta Samaria daw asta ta madyo pa gid na mga lugar.” ");
INSERT INTO cgc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagtapos ta ambal Jesus, pasunod gid danen ta tan-aw kanen an mintras na kanen an padala en na malik naan ta langit. Nalekkepan kanen an ta panganod daw narwad dayon ta iran na panan-aw. ");
INSERT INTO cgc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na danen an gaangad pa na gatan-aw ta miad, nali nang may darwa na mama na gabayo ta puti gatindeg tengnged ki danen ");
INSERT INTO cgc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","daw gambal ki danen, “Kyo na mga taga-Galilea, man-o tak gatindeg kaw dyan daw gaangad naan ta langit? Jesus ya na nakita nyo na padala naan ta langit, kanen malik naan ta kalibutan i ta paryo man na paagi na nakita nyo kanen an na gabalik naan ta langit.” ");
INSERT INTO cgc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pagtapos na Jesus gabalik naan ta langit, gabalik man mga apustulis an naan ta Jerusalem alin ta bukid ya na pangaranan na Bukid Olibo na may kaadyuon daw panawen ula tenga uras. ");
INSERT INTO cgc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pag-abot naan ta Jerusalem, gapanaik danen an naan ta apaw na kwarto ta balay na padayunan danen. Yi mga apustulis na naan dya: danen Pedro daw Juan, Santiago daw Andres, Felipe daw Tomas, Bartolome daw Mateo, Santiago na bata Alfeo, Simon na paumaw man na Makabanwa daw Judas na bata Santiago. ");
INSERT INTO cgc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Danen an pirmi gadumaay ta pagpangamuyo na duma danen pila na mga bai, daw Maria na inay Jesus daw mga utod Jesus na mga mama. ");
INSERT INTO cgc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Isya adlaw na mga apustulis naan pa ta Jerusalem, Pedro i gatindeg daw gambal naan ta mga paryo din na gatuo ki Jesus. Katamaen an ta mga gatuo na naan dya mga sinto binti. Ambal Pedro ki danen, ");
INSERT INTO cgc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga utod ko, naan ta plano ta Dyos na matuman pasulat ya Ari David anay pa sa paagi ta Dyos Ispiritu Santo parti ki Judas na gapanguna ta mga gadakep ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kanen ya isya man na mimbro ta ate na grupo na papili Jesus na magsirbi ki kanen duma ki kiten.” ");
INSERT INTO cgc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yi natabo ki Judas: Kwarta ya na nabaton din tenged ta malain din na buat parti ki Jesus, pagamit din ta pagpalit ta basak daw naan dya napatay kanen an. Na napatay kanen ya, gaalok iya an na lawa, gapuswak iya na gettek daw gagwa iya na mga bituka. ");
INSERT INTO cgc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tanan na mga ittaw naan ta Jerusalem nalam ta natabo ya ki Judas daw basak ya na palit din paumaw danen naan ta iran na linggwai “Aceldama” na yon man paumaw na Basak Ta Lengngessa. ");
INSERT INTO cgc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pedro i gambal pa gid, “May nasulat naan ta libro na Mga Salmo, ‘Kabay na ula may mag-istar na mga ittaw naan ta lugar na istaran din.’ Daw nasulat man, ‘Kabay na may magsal-i ta iya na katengdanan.’ ");
INSERT INTO cgc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Gani, kinanglan na may isya na magdugang ki kiten na magpamatuod man na Ginuo Jesus nabannaw. Piro, kinanglan na isya kanen an na gaduma ki kiten ta tanan na mga timpo na naduma ta pa Ginuo ya, umpisa ta pagbautismo na pabuat Juan asta ta adlaw na padala Jesus ya na malik naan ta langit.” ");
INSERT INTO cgc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pagtapos ta ambal Pedro, gapili danen an ta darwa na mama aged alin ta darwa an isya nang pilien danen. Papili danen Matias an daw Jose na paumaw na Barsabas na pabansagan man na Justo. ");
INSERT INTO cgc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pagtapos ta pagpili ta darwa an, gapangamuyo danen an, “O Ginuo, kaon nang nalam daw ino naan ta isip ta tanan na mga ittaw. Gani, isugid no ki kami daw kino ta darwa i pilien no na apustol ");
INSERT INTO cgc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na magsal-i ki Judas na gatalikod ta iya na katengdanan daw anen en ta lugar ya na bagay ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagtapos ta pangamuyo, gagabot-gabutay danen an daw napili Matias ya daw kanen padugang ta unsi ya na mga apustulis. ");
INSERT INTO cgc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gabot adlaw na pista ta mga Judio na paumaw na Pista Ta Pentecostes. Gatipon tanan na mga gatuo ki Jesus naan ta isya na balay. ");
INSERT INTO cgc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nali nang, may namatian danen an na alin ta langit paryo ta biskeg na angin na gabagrong gid naan ta bilog na balay na patipunan danen. ");
INSERT INTO cgc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dayon, may gapakita ki danen na daw lagen paryas mga derse na legleg ta apoy na gatugdon naan ta kada isya ki danen. ");
INSERT INTO cgc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pagaeman danen an ta Dyos Ispiritu Santo daw gambal danen an ta lain-lain na mga linggwai na ula danen naistudyui sunod ta ipaambal ta Dyos Ispiritu Santo ki danen. ");
INSERT INTO cgc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ta yon man na timpo, may dyusnon na mga Judio na gatinir naan ta Jerusalem na naan alin ta lain-lain na mga nasyon. ");
INSERT INTO cgc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ta pagmati danen ta sinaba, tama gailing dya na gatipon. Gatingala gid danen an tak namatian ta kada isya ki danen naan ta iran na kaugalingen na linggwai paambal an ta mga gatuo. ");
INSERT INTO cgc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gatingala gid danen an daw gambal, “Di' ba yi na mga gambal i taga-Galilea? ");
INSERT INTO cgc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Man-o tak namatian ta anduni danen an na gambal naan ta mga linggwai ta ate na mga lugar? ");
INSERT INTO cgc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kiten i mga taga-Parto, taga-Medo, daw taga-Elam, daw duma man ki kiten naan alin ta Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO cgc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Egipto daw parti ta lugar na Libya na dani ta Cirene. Duma an ki kiten naan alin ta lugar na Roma, ");
INSERT INTO cgc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","mga Judio man daw mga dili-Judio na iran na pasimba Dyos an na pasimba ta mga Judio. Duma an a ki kiten naan alin ta pulo na Creta daw duma an naan alin ta lugar na Arabia. Piro, bisan lain-lain ate na mga linggwai, namatian ta danen an na gambal naan ta ate na inalinan na mga linggwai parti ta mga katingalaan na pabuat ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iling tan ambal danen tenged ta iran na katingala daw gainsa-insaay danen an, “Ino taan liag ambalen ti?” ");
INSERT INTO cgc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Piro, duma an gasunlog na gambal, “Mga ingaw nyan!” ");
INSERT INTO cgc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dayon, Pedro i duma ta unsi na mga apustulis gatindeg naan ta tubangan ta mga ittaw daw bakod iya na kagi na gambal kanen i, “Mga kasimanwa ko na mga Judio daw tanan kaw na gatinir naan ta Jerusalem, pamatian a nyo daw tugutan a ta pagsugid ki kyo daw ino beet ambalen ta yi na natabo. ");
INSERT INTO cgc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dili kami i mga ingaw paryo ta paisip nyo. Sellem pa i! Tallo nang pa uras galambay alin ta pagsennang ta adlaw. ");
INSERT INTO cgc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ta matuod, yi na natabo naambal en Joel na prupita na manugsugid ta kabebet-en ta Dyos anay pa sa. Ambal Joel, ");
INSERT INTO cgc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Dyos an gambal daw ino iya na imuon ta katapusan na mga inadlaw. Ambal din, “Ipadala ko Dyos Ispiritu Santo naan ta tanan na mga ittaw para gaeman din danen an. Inyo an na mga kabataan magsugid ta ake na mga ambal. Inyo an na mga miron makakita ta mga panan-awan. Inyo na mga manakem na mama makakita ta ake na mga plano naan ta iran na mga dagammo. ");
INSERT INTO cgc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bisan naan ta ake na mga suguon, mga mama man daw mga bai, papadala ko ake na Ispiritu ta yon man na mga inadlaw daw magsugid man danen an ta ake na mga ambal. ");
INSERT INTO cgc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ipakita ko naan ta mga ittaw mga katingalaan naan ta langit daw mga sinyalis naan ta kalibutan. Tama na mga lengngessa tenged ta pagpatay. May mga apoy man daw mga tumbuok na aso. ");
INSERT INTO cgc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Adlaw an dili magpawa daw bulan an magminog na paryo ta lengngessa bag-o mabot andemen na adlaw na makatingala na Ginuo an mag-ukom ta tanan na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Piro, ta yon man na timpo, daw kino marani ta Ginuo Dyos malibri alin ta silot ta iya na mga sala.”’ ” ");
INSERT INTO cgc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ambal pa Pedro, “Mga paryo ko na linai Israel, matian nyo gid ambalen ko i ki kyo parti ki Jesus an na taga-Nazaret. Kanen an gabuat ta mga katingalaan na pamatuod na kanen an papadala ta Dyos. Tenged ta mga pabuat ta Dyos paagi ki Jesus pamatuuran din na Jesus an may bakod na gaem na alin ki kanen. Yi tanan nlaman nyo gid tak anen di natabo. ");
INSERT INTO cgc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jesus an patugyan naan ki kyo sunod ta plano ta Dyos na patirmino din en daan. Piro kyo yan, papapatay nyo kanen an paagi ta tabang ta mga ittaw na ula kakala ta Dyos daw palansang danen Jesus an naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Piro, pabannaw kanen an ta Dyos na beet ambalen dili din en magian mga kasakit an na gadala ta kamatayen daw dili en isab kanen an mapatay. Dili kanen mabilin naan ta lugar ta mga patay tak anduni ula en kamatayen kanen an. ");
INSERT INTO cgc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Naan ta sinulat Ari David, ambal David parti ki kanen iling ti, ‘Nakita ko na Ginuo Dyos an pirmi gaduma ki yaken aged ula en may makatublag ki yaken. ");
INSERT INTO cgc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nyan gid nalipay ake na tagipusuon daw sikad sadya ake an na mga paambal tenged ki kaon, O Ginuo. Bisan mapatay a, may palaeman a pa ");
INSERT INTO cgc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tak nlaman ko na dili a no dilian naan ta Hades na lugar ta mga patay daw dili no man tugutan na malunot lawa an ta imo gid na Manugsirbi. ");
INSERT INTO cgc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Patudlo no ki yaken daw ino paagi na mangabui aged may kabui na ula katapusan daw malipay a tenged kaon ake na maduma.’” ");
INSERT INTO cgc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro i gapadayon pa gid ta iya na pag-ambal, “Mga utod ko, daw parti ki Ari David na ate na alinan na kaapuan, nlaman ta gid na napatay kanen ya daw asta anduni iya na lebbengan anen pa di. ");
INSERT INTO cgc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kanen ya isya na prupita na manugsugid ta kabebet-en ta Dyos anay pa sa. Nlaman din na gapangako Dyos an ki kanen na isya ta iya na mga linai manubli ta iya na pagkaari. Ta pagpangako ta Dyos ki kanen, gasumpa Dyos an na tumanen din gid iya na pangako. ");
INSERT INTO cgc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nlaman en daan David parti ta pagbannaw ya ta Pinili Ta Dyos Na Mag-ari. Gani, gambal David ya na Pinili Ta Dyos Na Mag-ari, dili kanen an pabay-an ta Dyos naan ta Hades na lugar ta mga patay daw dili man malunot iya na lawa. ");
INSERT INTO cgc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesus an pabannaw ta Dyos daw kami tanan mga gapamatuod ki kyo tak nakita nay en kanen an na bui. ");
INSERT INTO cgc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesus man paatagan ta Dyos Amay ta pinakadatas na katengdanan na naan kanen tengnged ta Dyos Amay naan dapit ta tuo daw pabaton din alin ta iya na Amay papangako ya na ipadala naan ki kami Dyos Ispiritu Santo an. Yon na papangako natuman anduni paryo ta inyo na nakita daw namatian. ");
INSERT INTO cgc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nlaman ta na dili David paatagan ya ta Dyos ta datas na katengdanan na mungko tengnged ki kanen tak parti ta iya na Pinili Na Mag-ari, David mismo gambal, ‘Ginuo Dyos gambal ta ake na Ginuo, “Mungko ka di naan dapit ta ake i na tuo, ");
INSERT INTO cgc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta na mapirdi ko imo na mga kuntra na danen an paryo ta tungtungan ta imo na mga batiis.”’ ” ");
INSERT INTO cgc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ambal pa Pedro, “Gani, tanan kaw na mga paryo ko na linai Israel dapat intindien nyo gid na Jesus ya na papalansang nyo naan ta krus, kanen paimo ta Dyos na Ginuo daw Pinili Ta Dyos Na Mag-ari!” ");
INSERT INTO cgc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagmati ta mga ittaw ta ambal Pedro, nakunsinsya gid danen an daw gainsa danen an ki Pedro daw ta duma na mga apustulis, “Mga utod, ino dapat nay na buaten?” ");
INSERT INTO cgc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Sabat Pedro, “Magnelsel kaw daw dilian nyo inyo an na mga sala. Magpabautismo kaw na pamatuod na kyo yan anduni gatuo ki Jesu-Cristo para mapatawad kaw ta inyo na mga sala daw para mabaton nyo man Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pangako ya ta Dyos na ipadala din Dyos Ispiritu Santo an para ki kyo, para ta inyo na mga linai, para man ta tanan na mga ittaw na dili-Judio daw asta ta tanan na mga ittaw na kabaton ta upurtunidad na paatag ta Ginuo na ate na Dyos na marani ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tama pa mga ambal Pedro ta pagpamatuod ki danen daw galaygay man ki danen, “Likawan nyo silot na alin ta Dyos na maageman ta mga malain na ittaw ta yi na timpo!” ");
INSERT INTO cgc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tama mga gapati ta ambal Pedro daw gapabautismo danen an. Ta yon man na adlaw, may mga tallo libo na ittaw na nadugang naan ta grupo ta mga gatuo ki Jesu-Cristo. ");
INSERT INTO cgc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Gaatag danen ta tama na mga uras ta pag-istudyo naan ta mga patudlo ta mga apustulis daw ta pagtipon naan ta duma na mga gatuo daw ta pagyapon daw pagpangamuyo duma man ki danen. ");
INSERT INTO cgc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tama na mga katingalaan na paimo ta Dyos paagi ta mga apustulis na pamatuod na iran na patudlo alin gid ta Dyos. Tenged ta mga buat danen, gatingala gid tama na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Papadayon ta mga gatuo ki Jesus iran an na pagtipon daw gaatagay danen an daw ino iran na mga kinanglanen para ta kayaran ta tanan. ");
INSERT INTO cgc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pabligya danen iran na mga basak daw mga pagkabetang daw bayad ya panagtag danen dipindi ta kinanglanen ta kada isya. ");
INSERT INTO cgc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Adlaw-adlaw, gapadayon danen an ta iran na pagtipon-tipon naan ta Timplo daw naan ta iran na mga balay gadumaay danen an na gakaan na may kalipay na terek ta iran na tagipusuon. ");
INSERT INTO cgc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gadayaw danen an ta Dyos daw duma na mga ittaw nadayaran ki danen. Adlaw-adlaw may nadugang ki danen na mga ittaw na paluwas ta Ginuo alin ta silot ta iran na mga sala. ");
INSERT INTO cgc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ta isya na adlaw, mga tallo uras alin ta ugto-adlaw, danen i Pedro daw Juan giling naan ta Timplo tak yon gid uras ta pagpangamuyo. ");
INSERT INTO cgc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Naan ta gangaan ta Timplo na paumaw na Dayad Na Gangaan, may mama na dili kapanaw alin ta pagtao din. Kada adlaw padala kanen an na palayungan daw pabilin naan ta gangaan aged magpalimos naan ta mga ittaw na gaselled ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pagkita din na magselled danen Pedro daw Juan, gangayo kanen an ta limos. ");
INSERT INTO cgc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Patan-aw gid danen kanen an daw Pedro i gambal ki kanen, “Man-aw ka anay ki kami.” ");
INSERT INTO cgc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Patan-aw din ta miad danen an tak gasalig na may atag ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piro, Pedro i gambal ki kanen, “Ula a kwarta na pilak o blawan, piro may anen a na iatag ki kaon. Paagi ta ngaran Jesu-Cristo na taga-Nazaret daw tenged ta iya na gaem, mindeg ka daw manaw!” ");
INSERT INTO cgc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pag-ambal Pedro, paibitan din tuo an na lima ta mama na dili kapanaw aged patindegen. Gabiskeg dayon batiis an ta mama daw buko-buko ta iya na kitin ");
INSERT INTO cgc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","daw galusko kanen an na gatindeg daw gapanaw-panaw. Na gaselled danen Pedro daw Juan naan ta Timplo, gakuyog ki danen mama an daw sigi iya na panaw daw lusko na gadayaw kanen ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nakita ta tanan na mga ittaw naan ta Timplo na kanen an gapanaw daw gadayaw ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Na nakala danen na kanen an mama ya na dili kapanaw na gapalimos dati naan ta Dayad Na Gangaan ta Timplo, gatingala gid danen an ta natabo ya ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na mama an na nayad sigi ibit ki danen Pedro daw Juan, tanan na mga ittaw naan ta Timplo gadlagan na marani ki danen naan ta lugar ta Timplo na paumaw na Balkon Solomon daw mga ittaw an gatingala gid. ");
INSERT INTO cgc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na nakita Pedro mga ittaw an, gambal kanen i ki danen, “Mga paryo ko na linai Israel, man-o tak gatingala kaw gid daw gatan-aw ta miad ki kami? Ino! Salig nyo paagi ta ame na kaugalingen na sarang o tenged dyusnon kay na anduni mama i kapanaw en? ");
INSERT INTO cgc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mama i nayad en paagi ta gaem Jesus daw tenged man na liag ta Dyos na pamatuuran din na Jesus an na iya na Pasugo anduni bui naan ta langit tenged ta pagbannaw ta Dyos ki kanen. Yi man na Dyos pasimba danen Abraham, Isaac, Jacob daw tanan na mga alinan ta na kaapuan. Piro, kyo yan, na naan pa Jesus an ta kalibutan i, paintriga nyo kanen an naan ta mga uturidad ta ate na lugar daw pasikway nyo kanen an naan ta atubangan Pilato bisan buy-an inta kanen an Pilato. ");
INSERT INTO cgc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kanen an alin gid ta Dyos daw matareng, piro pasikway nyo daw imbis na papangabay nyo ki Pilato na buy-an kanen an, papangabay nyo gid na buy-an ki kyo isya ya na manugpatay. ");
INSERT INTO cgc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Gaatag an ta kabui ta tanan na mga may kabui, kanen ya papapatay nyo, piro pabannaw kanen ya ta Dyos daw kami i mga gapamatuod na nabannaw kanen ya. ");
INSERT INTO cgc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Gani, paagi ta gaem Jesus daw tenged man ta pagtuo ta yi na mama ki Jesus, paatagan ta kabiskeg yi na mama na inyo na nakita daw nakala. Kyo mga kakita na anduni naayad mama i paagi ta iya na pagtuo ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mga utod ko, nlaman ko en na Jesus ya nabuatan nyo ta malain tenged kyo yan daw inyo na mga manugdumala ula kaw nalam daw kino gid kanen ya. ");
INSERT INTO cgc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Piro, patuman ta Dyos iya ya na paambal paagi ta pabuat nyo ki Jesus na iya na Pinili Na Mag-ari tak anay pa sa na timpo, paambal din paagi ta tanan din na mga prupita na maagian ta iya na Pinili Na Mag-ari segeng an na kabellay daw kamatayen. ");
INSERT INTO cgc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gani, magnelsel kaw daw marani ta Dyos para patawaren kaw din ta inyo na mga sala daw mabaton nyo man tawway na nakem na alin ki kanen na Ginuo Dyos ");
INSERT INTO cgc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","daw para man ipadala din ki kyo Jesus an na iya na Pinili Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Piro, naan ta plano din na Jesus an magpabilin anay naan ta langit asta mabot timpo na bag-uon tanan na mga betang paryo ta pasugid din anay pa sa paagi ta iya na mga prupita na gasirbi ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Paryo ta ambal Moises anay pa sa, ‘Ginuo Dyos magpadala ki kyo ta prupita na paryo man ta pagpadala din ki yaken naan ta iya na mga ittaw daw prupita ya isya ta na kasimanwa. Kinanglan matian nyo gid tanan na mga ambal ta prupita ya ki kyo. ");
INSERT INTO cgc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Daw kino dili magtuman ta paambal din, belagen danen an naan ta mga ittaw ta Dyos daw maageman danen silot na ula katapusan.’ ");
INSERT INTO cgc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ambal ya Moises, paambal man ta tanan na mga prupita umpisa ki Samuel anay pa sa asta ta mga prupita na nabui sunod ki kanen. Danen tanan gambal man parti ta mga natabo anduni. ");
INSERT INTO cgc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kiten mga linai ta mga prupita. Mga papangako ta Dyos paagi ki danen para man ki kiten. Paryo ta ambal ta Dyos ki Abraham, ‘Paagi ta imo na mga linai mga ittaw ta tanan na mga lai naan ta kalibutan tagan ko ta mga kaayaran.’ ");
INSERT INTO cgc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gani, papili ta Dyos Pasugo din ya na Jesus daw padala una naan ki kiten na mga Judio aged tagan ki ta kaayaran na may sarang ki na dilian ta ate na mga sala daw marani ki ta Dyos tenged ta pagbag-o din ki kiten.” ");
INSERT INTO cgc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na gambal pa danen Pedro daw Juan naan ta mga ittaw, papranian danen an ta mga pari ta mga Judio, mga Saduseo daw ta kumander ta mga gwardya ta Timplo. ");
INSERT INTO cgc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gagilek mga gaprani ya tenged danen an Pedro daw Juan gatudlo na Jesus ya nabannaw daw pagbannaw ki kanen pamatuod na mabannaw mga patay an. ");
INSERT INTO cgc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tenged dili mapati mga upisyalis an ta patudlo ya danen Pedro, papadakep ta mga upisyalis danen an Pedro daw Juan daw papriso asta ta sunod na adlaw tak pagdakep ya ki danen semsem en. ");
INSERT INTO cgc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Piro, tama na mga ittaw na kamati ta iran na mga tudlo gapati. Katamaen ta mga mama na gatuo ki Jesus mga limma libo. ");
INSERT INTO cgc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sunod na adlaw, mga gapanguna ta banwa, mga gadumala ta mga Judio, daw mga manugtudlo ta Mga Sinulat Moises gatipon naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anen man dya Anas na pinakadatas na manugdumala ta mga pari daw danen Caifas, Juan, Alejandro daw duma pa na mga mimbro ta pamilya Anas. ");
INSERT INTO cgc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gasugo danen na ipatubang Pedro ya daw Juan naan ta mga upisyalis. Na gatubang en danen Pedro, painsaan danen an ta mga upisyalis, “Iya san na gaem daw ngaran pagamit nyo ta pagpaayad ta mama na dati dili kapanaw?” ");
INSERT INTO cgc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro an, pagaeman kanen an ta Dyos Ispiritu Santo daw gasabat ki danen, “Mga gapanguna ta banwa daw mga gadumala ta mga Judio, ");
INSERT INTO cgc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","daw insaan nyo kami i parti ta miad na buat naan ta yi na mama na dati dili kapanaw daw parti man daw ino paagi na naayad kanen an, ");
INSERT INTO cgc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kyo daw tanan na mga paryo ta na linai Israel na anen di, dapat mlaman nyo gid na yi na mama na gatindeg naan ta inyo na atubangan nayad en paagi ta iya na pagtuo ki Jesu-Cristo na taga-Nazaret na papalansang nyo naan ta krus piro pabannaw ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesus an kanen pasambit naan ta sinulat na pulong ta Dyos na Dyos gambal, ‘Kyo na mga manug-ubra ta balay, bato an na ta isip nyo dili magamit, yon gid pamag-ang na bato.’ ");
INSERT INTO cgc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Gambal a ki kyo na ula gid duma na ittaw naan ta bilog na kalibutan na makaluwas ki kiten alin ta silot ta ate na mga sala daw dili, Jesus nang.” ");
INSERT INTO cgc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Gatingala gid mga manugdumala ki danen Pedro na gasabat danen an na ula adlek tak nlaman ta mga manugdumala na Pedro an daw Juan ula iniskwilaan daw kebes nang. Nlaman man danen na Pedro an daw Juan mga gaduma ki Jesus kan-o. ");
INSERT INTO cgc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Piro, tenged nakita danen mama an na nayad na gatindeg duma ki danen Pedro, ula nang en danen an gasasaba parti ta natabo. ");
INSERT INTO cgc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Papagwa anay ta mga upisyalis danen an Pedro aged danen na mga upisyalis magsapol. ");
INSERT INTO cgc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Na gasapol danen, gainsaay danen an ta kada isya, “Ino ate na imuon naan ta yon na mga mama? Tanan na mga gaistar naan ta Jerusalem nalam na danen an gabuat ta katingalaan. Gani, dili ki makabalibad. ");
INSERT INTO cgc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Piro, yi buaten ta aged dili maglapta naan ta mga ittaw balita ya na mama an na dili kapanaw paayad paagi ta gaem Jesus. Andaman ta danen an na dili en mag-ambal naan ta bisan kino parti ki Jesus.” ");
INSERT INTO cgc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tapos sapol ta mga upisyalis, paumaw isab danen an Pedro daw paandaman na dili gid en mag-ambal daw magtudlo parti ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piro, Pedro i daw Juan gainsa naan ta mga upisyalis, “Pinsaren nyo, daw ino mas dayad an naan ta atubangan ta Dyos, magtuman ki kyo o magtuman ta Dyos? ");
INSERT INTO cgc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Daw parti ki kami, dili nay mapegengan ame na kaugalingen ta pagsugid ta ame na nakita daw namatian.” ");
INSERT INTO cgc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Pagtapos na paandaman pa gid ta mga upisyalis danen an Pedro, pabuy-an danen an. Adlek mga upisyalis an na daw silutan danen an Pedro daw Juan, basi maggamo mga ittaw tak gadayaw mga ittaw an ta Dyos tenged ta katingalaan na natabo na nayad isya na mama na dili kapanaw alin ta pagtao na idad din subla kwarinta na taon. ");
INSERT INTO cgc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na pabuy-an Pedro an daw Juan, gabalik danen an ta iran na mga arey na mga gatuo daw pasugid danen ambal an ta mga manugdumala ta mga pari daw mga gadumala ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pagmati ta mga gatuo, gapangamuyo danen an ta Dyos, “O Makagagaem Na Dyos, kaon gabuat ta langit, ta basak, ta dagat daw tanan na mga anen don. ");
INSERT INTO cgc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pagaeman ta Dyos Ispiritu Santo ame na kaapuan na Ari David na imo man na manugsirbi na gambal ka paagi ki kanen. Ambal David, ‘Man-o tak segeng gid na gilek ta mga dili-Judio na gakuntra ta Dyos? Man-o tak mga ittaw gaisip ta ula pulos na mga plano? ");
INSERT INTO cgc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mga ari ta kalibutan daw mga manugdumala gatipon na gakuntra ta Ginuo Dyos daw ta iya na Pinili.’ ");
INSERT INTO cgc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","O Ginuo Dyos, iling gid tan natabo naan ta yi na syudad na danen ya Herodes, Poncio Pilato, mga dili linai Israel daw mga linai Israel man gakuntra ki Jesus na imo gid na Manugsirbi daw Pinili Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pabuat danen tanan ya paryo gid ta imo na naplano daan na matabo. ");
INSERT INTO cgc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Anduni, O Ginuo Dyos, matian no iran an na pagpalleg ki kami na imo na mga suguon daw tabangan kay ta ame na pag-ambal na ula kay adlek ta pagsugid ta miad na balita na alin ki kaon parti ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipakita no imo an na gaem paagi ta pagpaayad nay ta mga ittaw na may masakit daw itugot no man na paagi ta gaem Jesus na imo gid na Manugsirbi mabuat nay mga katingalaan na pamatuod na ame na sugid alin gid ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagtapos ta iran na pagpangamuyo, gaeyeg-eyeg lugar an na patipunan danen. Pagaeman danen an ta Dyos Ispiritu Santo daw gasugid danen an ta miad na balita na alin ta Dyos na ula danen adlek. ");
INSERT INTO cgc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mga gatuo an ki Jesus, danen an gaisyaay nang ta isip. Patingeb danen tanan na mga pagkabetang danen daw ula bisan isya ki danen gaangken ta iya na pagkabetang para nang ta iya gid na kaugalingen tak iran na mga pagkabetang pakabig danen na para ta tanan. ");
INSERT INTO cgc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Paagi ta gaem ta Dyos, gapadayon mga apustulis an ta pagpamatuod parti ta pagbannaw ki Ginuo Jesus daw tenged ta tabang ta Dyos ki danen, nlaman ta tanan na Dyos an sikad miad ki danen tanan. ");
INSERT INTO cgc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ula gid bisan isya ki danen nakulangi ta iran na mga kinanglanen tak duma ki danen may mga basak daw mga balay na pabligya, daw kantidad an ta iran na pabligya padala danen ");
INSERT INTO cgc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","daw paatag naan ta mga apustulis. Patagtag ta mga apustulis kwarta an naan ta mga gatuo dipindi ta iran na kinanglan. ");
INSERT INTO cgc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","May isya na mama na taga-Cipre na ngaran din an Jose. Kanen an Judio na alin ta linai Levi. Umaw ta mga apustulis ki kanen Bernabe na beet ambalen Manugtabang. Kanen an may miad man na pabuat na iling ti: ");
INSERT INTO cgc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","May basak kanen na pabligya daw bayad ya paintriga din man naan ta mga apustulis. ");
INSERT INTO cgc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","May magsawa na Ananias daw Safira na gabligya man ta iran na basak para itabang danen naan ta mga gakinanglan na mga gatuo. Piro, patago Ananias duma ya na kwarta na alin ta bayad ta iran na basak daw gakumpurmi man iya an na sawa. Nabilin ya na kwarta, paatag Ananias naan ta mga apustulis. ");
INSERT INTO cgc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Gambal Pedro i ki kanen, “Ananias, man-o tak gapadaag ka naan ki Satanas na magbula ka ta Dyos Ispiritu Santo? Man-o tak patago no duma ya na kwarta na bayad ta inyo na basak? ");
INSERT INTO cgc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na ula nyo pa nabligya inyo an na basak, di' ba kyo tag-iya? Na nabligya nyo en, di' ba inyo man gyapon na pagbeet daw inuon nyo kwarta nyo an? Man-o tak pabetang nyo naan ta inyo na isip na magbuat kaw ta malain? Ula kaw gabula naan ta mga ittaw, gabula kaw naan ta Dyos!” ");
INSERT INTO cgc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na namatian Ananias, natumba kanen an daw napatay dayon. Tanan na mga kamati parti ta natabo ya nadlek. ");
INSERT INTO cgc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mga miron na naan dya, gaprani daw paputos danen lawa an Ananias daw palayungan danen pagwa daw ilebbeng. ");
INSERT INTO cgc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Paglambay ta mga tallo uras, gabot Safira na sawa Ananias, piro ula kanen an nalam ta natabo ya ta iya na sawa. ");
INSERT INTO cgc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Gambal Pedro i ki kanen, “Sugiran a no daw yi gid tanan kantidad na nabaton nyo na bayad ta pagbligya nyo ta inyo na basak.” Sabat Safira, “Ee, nyan tanan na nabaton nay.” ");
INSERT INTO cgc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ambal Pedro ki kanen, “Man-o tak gakumpurmiay kaw na magsawa na magbula naan ta Dyos Ispiritu Santo na papaubay ta Ginuo naan ta mga gatuo? Salig nyo taan na dili kaw din silutan. Lagen no! Mga galebbeng an ta imo na sawa, gabalik en daw naan en ta gangaan daw kaon man sunod na layungan danen pagwa!” ");
INSERT INTO cgc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Natumba dayon daw napatay man Safira an naan ta atubangan Pedro. Gaselled mga miron an daw nakita danen na patay en Safira an daw palayungan man danen pagwa daw lebbeng abay ta iya na sawa. ");
INSERT INTO cgc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tanan na mga gatuo daw tanan na mga kamati parti ta natabo ki Ananias daw Safira nadlek gid. ");
INSERT INTO cgc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","13","Papakita ta mga apustulis naan ta mga ittaw tama na mga katingalaan na pamatuod na danen an paatagan ta abilidad na alin ta Dyos. Kaysan, gatipon mga gatuo an naan ta paumaw na Balkon Solomon na sakep ta Timplo. Ula gid duma na mga ittaw nangiseg na magtipon duma ki danen, bisan pa na mga gatuo an pataa gid ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Piro, gadugang pa gid man gyapon sikad tama na mga mama daw mga bai na gatuo ta Ginuo. ");
INSERT INTO cgc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tenged ta mga katingalaan na pabuat ta mga apustulis, padala ta mga ittaw naan ta dalan mga may masakit an daw pabetang naan ta mga neggaan daw ikam aged daw mag-agi dya Pedro an, maayad danen an bisan paagi nang ta iya na alo. ");
INSERT INTO cgc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tama man na mga ittaw gabot naan alin ta mga banwa na dani ta Jerusalem. Padala man danen mga ittaw an na may masakit daw mga ittaw na naseddepan man ta malain na ispiritu daw tanan nayad. ");
INSERT INTO cgc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pinakadatas an na manugdumala ta mga pari daw iya na mga duma na mga Saduseo nainggit gid ta mga apustulis ya. ");
INSERT INTO cgc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Papadakep danen daw papriso mga apustulis ya. ");
INSERT INTO cgc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piro, naan ta yon man na kilem na danen an padakep, pabukasan ta isya na angil ta Ginuo Dyos mga gangaan an ta prisuan daw papagwa danen an. Gambal angil i ki danen, ");
INSERT INTO cgc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Miling kaw naan ta Timplo daw ambalen nyo naan ta mga ittaw dya minsai an parti ta bag-o na kabui na maangken paagi ta pagtuo ki Jesus.” ");
INSERT INTO cgc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Patuman danen pambal an ta angil daw ta pagsennang ta adlaw, gaselled danen an naan ta Timplo daw gatudlo. Na gabot pinakadatas na manugdumala ta mga pari daw iya na mga duma naan ta iran na tipunan, paumaw din na magsapol mga mimbro an ta Sanedrin daw tanan man na mga gadumala ta mga linai Israel. Gapasugo danen an na kamangen mga apustulis an naan ta prisuan daw ipatubang ki danen. ");
INSERT INTO cgc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piro, pag-abot ta mga gwardya naan ta prisuan, ula dya en mga apustulis ya. Gabalik mga gwardya an naan ta mga manugdumala daw gambal danen an, ");
INSERT INTO cgc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Na gabot kay naan ta prisuan, nakita nay na nakandado pa daw tanan na mga gwardya gabantay naan ta mga gangaan, piro ta pag-abri nay ta gangaan, ula nay danen an nakita!” ");
INSERT INTO cgc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na namatian ta pangulo ta mga gwardya ta Timplo daw ta mga manugdumala na mga pari, gatingala danen an daw gakullaw daw ino pa gid sunod na matabo. ");
INSERT INTO cgc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na gakullaw pa danen an, gabot isya na mama daw gambal ki danen, “Mamati kaw anay! Mga mama ya na papriso nyo, naan en ta Timplo daw gatudlo ta mga ittaw dya!” ");
INSERT INTO cgc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pangulo an ta mga gwardya giling dayon naan ta Timplo duma ta iya na mga ittawan daw padala danen malik mga apustulis ya. Piro, ula danen papwirsaa mga apustulis ya tak nadlek danen an na basi daw timbagen danen an ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Paselled mga apustulis an daw patubang naan ta mga mimbro ta Sanedrin aged insaan ta pinakadatas na manugdumala ta mga pari. ");
INSERT INTO cgc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ambal din ki danen, “Gapaandam kay en ki kyo na dili kaw gid en magtudlo parti ki Jesus! Piro papalapta nyo pa man gyapon inyo an na patudlo naan ta bilog na Jerusalem daw gambal kaw pa man na kami i may sabaten ta iya an na kamatayen!” ");
INSERT INTO cgc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piro, gasabat Pedro an daw mga apustulis, “Daw pilien nay daw kino dapat na tumanen, Dyos o ittaw, Dyos nang gid tumanen nay, dili ittaw! ");
INSERT INTO cgc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dyos an na pasimba ta ate na mga alinan na kaapuan gabannaw ki Jesus na papapatay nyo na kanen an palansang naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pabannaw Jesus an ta Dyos daw paatagan kanen an ta pinakadatas na katengdanan na papungko tengnged ta Dyos naan dapit ta tuo aged magdumala ta tanan. Anduni kanen an Manugdumala daw Manluluwas na mag-atag ta mga linai Israel ta upurtunidad na magnelsel daw dilian iran na mga sala aged mapatawad danen an ta iran na mga sala. ");
INSERT INTO cgc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami gapamatuod ta mga natabo parti ki Jesus. Dyos Ispiritu Santo an na paatag ta Dyos naan ta mga gatuman ta Dyos, kanen man gapamatuod parti ta mga natabo ya.” ");
INSERT INTO cgc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagmati ta mga mimbro ta Sanedrin ta ambal danen Pedro, segeng gid iran na kagilek daw gusto gid danen na patayen mga apustulis an. ");
INSERT INTO cgc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piro, gatindeg isya na mimbro ta Sanedrin na ngaran din Gamaliel. Kanen an isya ta grupo ta mga Pariseo. Kanen isya man na manugtudlo ta Mga Sinulat Moises daw pataa man ta tanan na mga ittaw. Gasugo kanen an na pagwaen anay mga apustulis an. ");
INSERT INTO cgc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pagpagwa ki danen Pedro, gambal Gamaliel an naan ta mga duma din na mga mimbro ta Sanedrin, “Mga paryo ko na linai Israel, mag-andam kaw daw ino buaten nyo ta yon na mga mama. ");
INSERT INTO cgc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nademdeman nyo na pugya may mama na ngaran din Teudas na giling di na gapabugal-bugal na salig din daw kino gid kanen an. May mga gasunod man ki kanen na mga appat gatos na mama. Piro, papatay kanen ya daw gabelag-belagay mga gasunod ya ki kanen daw ula en batia parti ki danen. ");
INSERT INTO cgc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagtapos ki Teudas, ta uras ta sinsos, may isya pa na mama na ngaran din Judas na taga-Galilea. Kanen isya na gakuntra ta gubirno daw gadumala ta mga gasunod ki kanen. Piro, papatay man kanen ya daw gabelag-belagay man mga gasunod ya ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gani, sugiran ta kyo yan, largaan nyo nang en mga mama na yan. Buy-an nyo danen an tak daw iran an na plano iya nang man ta mga ittaw, dili madayon. ");
INSERT INTO cgc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Piro, daw iran na plano iya ta Dyos, ula kaw gid en sarang mabuat tak Dyos an pakuntra nyo.” ");
INSERT INTO cgc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pagtapos ta laygay Gamaliel, kumpurmi mga mimbro an ta Sanedrin ta iya na ambal. Papaselled isab danen mga apustulis an daw pakastigo. Pagtapos ta kastigo, paandaman danen isab mga apustulis an na dili en mag-ambal parti ki Jesus. Dayon, pabuy-an. ");
INSERT INTO cgc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Galin mga apustulis an naan ta tubangan ta Sanedrin na may kalipay tak paatagan danen an ta Dyos ta pribiliyo na naagian danen mga malain na buat daw pagayyaan man danen an tenged ta iran na pagtuo ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Adlaw-adlaw, naan ta Timplo daw naan ta mga balay, gapadayon danen an ta pagtudlo daw pagsugid ta miad na balita parti ki Jesus na kanen an Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ta yon man na timpo na gatudlo pa daw gawali mga apustulis an naan ta Timplo, gatama pa gid mga gatuo an ki Jesus. Piro, mga gatuo an na iran an na linggwai Griego gariklamo kuntra ta mga gatuo man na iran an na linggwai Hebreo. Gariklamo danen an tak daw may patagtag na pagkaan adlaw-adlaw naan ta mga balo na bai, mga balo an na iran na linggwai Griego, ula naatagi. Piro, mga balo an na iran na linggwai Hebreo, naatagan ta pagkaan. ");
INSERT INTO cgc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tenged ta yon na riklamo, paumaw ta dusi na apustulis tanan an na mga gatuo na gatipon-tipon ta pagsimba naan ta Jerusalem daw ambal danen, “Dili naan ta plano ta Dyos na pabay-an nay nang pagsugid an ta miad na balita na alin ta Dyos aged magtagtag nang ta pagkaan. ");
INSERT INTO cgc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Gani, mga utod nay ki Cristo, magpili kaw ta pitto na mama naan ki kyo na pataa gid ta mga ittaw daw nlaman nyo na pirmi danen an gapasakep naan ta Dyos Ispiritu Santo daw maalam man danen an. Tagan nay danen an ta katengdanan ta pagtagtag ta pagkaan naan ta mga gakinanglan ");
INSERT INTO cgc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","daw kami i a, iatag nay ame na uras ta pagsugid ta miad na balita na alin ta Dyos daw ta pagpangamuyo.” ");
INSERT INTO cgc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pag-ambal ta mga apustulis, nadayaran mga gatuo an ta ambal danen. Papili danen Esteban an na mama na terek gid iya na pagtuo daw pirmi man kanen an gapasakep naan ta Dyos Ispiritu Santo. Napili man: Felipe, Procoro, Nicanor, Timon, Parmenas daw Nicolas na taga-Antioquia na gasalyo naan ta tuuan ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Papatubang ta mga gatuo naan ta mga apustulis iran an na mga napili. Papangamuyuan ta mga apustulis daw patungtong danen iran na mga lima naan ta mga napili aged bindisyunan. ");
INSERT INTO cgc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gapadayon mga apustulis an ta pagsugid ta miad na balita na alin ta Dyos parti ki Jesus naan ta mga ittaw. Tenged ta miad na balita na pasugid danen, gadugang pa gid mga gatuo an ki Jesus naan ta Jerusalem daw tama na mga pari ta mga Judio gatuo man. ");
INSERT INTO cgc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban i, patabangan gid kanen an ta Dyos daw may gaem alin ta Dyos aged magbuat kanen an ta mga katingalaan naan ta mga ittaw na pamatuod na iya an na pawali alin gid ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Piro, may mga Judio na gadiskas kuntra ki Esteban. Danen an mga mimbro ta paumaw na Balay Tipunan Ta Mga Nalibri Na Mga Ulipen. Naan danen alin ta mga banwa na Cirene daw Alejandria daw alin man ta mga prubinsya na Cilicia daw Asia. ");
INSERT INTO cgc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Piro, napirdi danen an ta rason ta mga paambal ya Esteban tak Dyos Ispiritu Santo gaatag ki kanen ta alam. ");
INSERT INTO cgc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tenged danen an napirdi Esteban, gasuol danen an ta pila na mga ittaw na mag-ambal ta dili matuod kuntra ki Esteban. Iling ti ambal ta mga pasuulan danen: “Namatian nay kanen an na papakalain din Moises an daw Dyos!” ");
INSERT INTO cgc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Paagi ta iran na ambal na dili matuod, pasegyet danen mga ittaw an, daw mga gadumala ta mga Judio daw mga manugtudlo ta Mga Sinulat Moises aged kuntraen man danen Esteban an. Pailingan danen tanan kanen an daw padakep daw padala naan ta mitingan ta mga manugdumala na mga pari na Sanedrin. ");
INSERT INTO cgc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","May duma na mga ittaw na papadala man danen aged mag-ambal ta dili matuod kuntra ki Esteban naan ta tubangan ta Sanedrin. Ambal danen, “Yi na mama ni pirmi din nang papakalain ate na Timplo daw Mga Sinulat Moises. ");
INSERT INTO cgc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Namatian nay na kanen an gambal na Jesus ya na taga-Nazaret gubbaen din kon ate na Timplo daw silian din man tanan na mga sunuran na paatag Moises ki kiten.” ");
INSERT INTO cgc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tanan na mga mimbro ta Sanedrin gatan-aw gid ki Esteban daw nakita danen na iya an na sura paryas ta sura ta angil. ");
INSERT INTO cgc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pagtapos ta ambal ta mga ittaw ta dili matuod kuntra ki Esteban, gainsa pinakadatas an na manugdumala ta mga pari ki kanen, “Matuod ni mga paambal i danen?” ");
INSERT INTO cgc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Gasabat kanen i, “Mga kasimanwa ko na mga Judio, daw pwidi nang matian a nyo! Anay pa sa, makagagaem an na Dyos gapakita naan ta ate na alinan na kaapuan na Abraham na naan pa kanen ya ta lugar na Mesopotamia na ula pa kanen ya gasalyo naan ta syudad na Haran. ");
INSERT INTO cgc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ta yon man na timpo anay pa sa, gambal Dyos an ki kanen, ‘Malin ka ta lugar na i na paistaran nyo. Ibilin no imo an na mga parinti daw miling ka ta lugar na itudlo ko ki kaon.’ ");
INSERT INTO cgc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yon na galin Abraham ya ta lugar na Caldea daw gasalyo naan ta syudad na Haran. Na napatay iya na amay, pailing kanen ya ta Dyos naan ta yi na lugar na paistaran ta anduni. ");
INSERT INTO cgc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Piro, pag-iling din di anay pa sa, ula pa naatag ta Dyos ki kanen panublien din an na basak maskin isya nang na paryo ta palad kalapad. Piro, gangako Dyos an ki kanen na yi na lugar iatag ki kanen daw ta iya na mga linai maskin kanen ya ula pa bata. ");
INSERT INTO cgc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gambal Dyos an ki kanen, ‘Imo na mga linai mag-istar naan ta isya pa na lugar na dili iran daw danen an mga istrangiro dya. Naan dya buaten danen an na mga ulipen daw pabellayan ta usto ta mga ittaw na naan dya keteb ta appat gatos na taon.’ ");
INSERT INTO cgc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ambal pa ta Dyos ki Abraham, ‘Piro, silutan ko mga ittaw an naan ta nasyon na mag-ulipen ta imo na mga linai daw ta uryan, imo na mga linai malin dya daw malik isab naan ta yi na lugar. Pagbalik danen, magsimba danen eman ki yaken na iran na Dyos.’” ");
INSERT INTO cgc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ambal pa Esteban, “Pasugo ta Dyos danen ya Abraham na buatan ta tanda naan ta lawa iran ya na mga bata na mama na beet ambalen Dyos an may kasugtanan ki danen. Abot timpo na Abraham ya may bata na mama na pangaranan din na Isaac daw kanen ya pabuatan man Abraham ta tanda naan ta lawa naan ta pangwallo na adlaw alin ta pagtao din. Ta uryan, Isaac ya may bata na mama na pangaranan din na Jacob, daw Jacob ya may dusi man na mga bata na mama na ate na mga bantog na alinan na kaapuan. ");
INSERT INTO cgc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Duma ya ta bantog ta na mga kaapuan nainggit ki Jose na iran na mangngod daw pabligya danen naan ta mga Egiptuanen bilang isya na ulipen. Piro, Dyos an gaubay ki Jose ");
INSERT INTO cgc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","daw gatabang na masarangan din mga kabellay na naagian din. Patagan kanen an ta Dyos ta kaalam daw Paraon ya na ari ta lugar na Egipto nadayaran ki kanen. Paimo Paraon kanen an na gubirnador naan ta bilog na Egipto daw ta palasyo Paraon. ");
INSERT INTO cgc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ta yon man na timpo anay pa sa, naan ta Egipto daw lugar na Canaan may segeng gid na letem na yon tenaan ta segeng na kabellay na naagian ta mga ittaw. Ate ya na mga kaapuan naan ta Canaan ula may kamangan ta pagkaan. ");
INSERT INTO cgc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Piro, pagmati Jacob na may tama na trigo naan ta lugar na Egipto, papadala din dya iya an na mga bata na mama. Yi una na pag-iling dya ta ate na mga kaapuan. ");
INSERT INTO cgc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ta pangarwa danen na pag-iling naan ta Egipto, gapakala Jose ya ta iya na kaugalingen naan ta iya na mga utod daw yon na nlaman en ta Paraon parti an ta pamilya Jose. ");
INSERT INTO cgc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Gatugon Jose ya na pailingen naan ta Egipto Jacob ya na iya na amay daw tanan din na mga parinti na sitintay-singko tanan. ");
INSERT INTO cgc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Giling danen ya Jacob ta Egipto daw naan dya danen an gaistar asta danen an napatay. ");
INSERT INTO cgc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iran an na mga lawa padala malik naan ta Siquem daw naan dya palebbeng naan ta lebbengan ya na anay pa sa papalit Abraham naan ta mga bata Hamor na mama.” ");
INSERT INTO cgc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na dali nang en mabot timpo na matuman pangako ya ta Dyos ki Abraham na librien din ate na mga kaapuan naan ta Egipto daw atagan ki danen ta panublien ta ya na basak naan ta Canaan, gatama pa gid danen an dya ");
INSERT INTO cgc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","asta na may bag-o eman na ari na gadumala naan ta Egipto. Ari ya ula nalam parti ki Jose daw iya na pamilya. ");
INSERT INTO cgc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Paluko ta ari ate ya na mga kaapuan daw padaeg-daeg. Papilit din danen ya na ipagwa naan ta lawas ta iran na mga balay iran na mga bata na bag-o nang natao daw largaan nang aged mapatay. ");
INSERT INTO cgc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ta yon man na timpo anay pa sa, natao Moises ya. Kanen ya gwapo na bata daw nadayaran Dyos an ki kanen. Pasagod kanen ya ta iya na mga ginikanan naan ta iran na balay ta tallo na bulan. ");
INSERT INTO cgc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Na dili en danen matago kanen ya, pabetang danen kanen ya naan ta kilid ta suba na may tama lamunon na datas. Naan dya, Moises ya nakita daw pakamang ta bai na bata Paraon na ari ta Egipto. Pasagod ta bai Moises ya na paryo gid ta iya na kaugalingen na bata. ");
INSERT INTO cgc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Patudluan Moises ya ta tanan na mga alam ta mga Egiptuanen daw bantog kanen ya tenged ta iya na abilidad ta paglaygay daw ta mga pabuat din. ");
INSERT INTO cgc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na kwarinta en taon idad Moises, naisipan din na magbisita naan ta mga paryo din na linai Israel. ");
INSERT INTO cgc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nakita din isya ya ki danen na padaeg-daeg ta isya na Egiptuanen. Pakampian din iya ya na kalai daw bilang bales, papatay din Egiptuanen ya. ");
INSERT INTO cgc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Salig din na maintindian ta mga kalai din na gamiten kanen an ta Dyos para librien din danen ya ta pag-ulipen naan ta lugar na Egipto, piro ula danen kaintindi. ");
INSERT INTO cgc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ta sunod na adlaw, nakita din darwa na mga mama na kalai din na gatiruay daw gatingwa kanen an na bawien din danen ya. Ambal din, ‘Mga utod ko, kyo yan gauturay, man-o tak gatiruay kaw?’ ");
INSERT INTO cgc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Piro, patulod kanen an ta mama ya na nakasala daw gambal mama ya, ‘Kino gaimo ki kaon na manugdumala daw manug-ukom ki kami? ");
INSERT INTO cgc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ino! Patayen a no man paryo ta Egiptuanen ya na papatay no kabii?’ ");
INSERT INTO cgc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagmati Moises, galayas kanen an alin ta Egipto daw gistar naan ta lugar na Midian na kanen an istrangiro dya. Na kanen an naan ta Midian, nangasawa kanen daw kabata ta darwa na mama. ");
INSERT INTO cgc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Paglambay ta kwarinta na taon na naan Moises ya ta lugar na ula kabalayan na dani ta Bukid Sinai, may angil na gapakita ki kanen naan ta galegleg na tanem. ");
INSERT INTO cgc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Gatingala gid Moises ya ta iya na nakita daw gaprani kanen an dya aged usisaen din gid. Na gaprani kanen an dya, namatian din na Ginuo Dyos gambal, ");
INSERT INTO cgc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yaken i Dyos ta inyo na mga kaapuan, Abraham, Isaac daw Jacob.’ Gakereg Moises ta subla na adlek daw ula kanen an kaiseg ta pagtan-aw. ");
INSERT INTO cgc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ginuo Dyos gambal pa ki Moises, ‘Tangtangen no mga sandal no an tak patindegan no an sagrado na basak tenged naan a di. ");
INSERT INTO cgc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nakita ko gid na padaeg-daeg ake an na mga ittaw naan ta Egipto. Namatian ko iran na pag-agal. Yon na giling a di alin ta langit aged librien ko danen an alin ta pag-ulipen ki danen. Gani, mag-anda ka, Moises! Pabaliken ko kaon yan naan ta Egipto.’” ");
INSERT INTO cgc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ambal pa Esteban, “Yon man na Moises pasikway ta mga paryo din na linai Israel na painsaan danen kanen ya, ‘Kino gaimo ki kaon na manugdumala daw manug-ukom ki kami?’ Piro, bisan pasikway danen Moises ya, kanen papadala ta Dyos na iran na manugdumala daw manugluwas paagi ta tabang ta angil na gapakita ki kanen naan ta galegleg na tanem. ");
INSERT INTO cgc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Papangunaan Moises mga kalai din ya pagwa alin ta Egipto. Na naan pa danen ta Egipto, gabuat kanen an ta mga katingalaan na pamatuod na kanen an padala ta Dyos na iran na manugdumala daw manugluwas. Iling tan pabuat din naan ta lugar na Egipto, naan ta Dagat Minog daw naan man ta lugar na ula kabalayan na naan dya danen an seled ta kwarinta na taon. ");
INSERT INTO cgc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yon man na Moises an gambal naan ta mga paryo din na linai Israel, ‘Anay pa sa, papadala a ta Dyos naan ki kyo, piro ta mabot pa na adlaw, magpadala kanen an ta isya na prupita naan ki kyo na ate man na utod.’” ");
INSERT INTO cgc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ambal pa Esteban, “Moises ya, kanen man duma ta ate na mga kaapuan na naan danen ta lugar na ula kabalayan. Duma man kanen ta angil na gambal ki kanen naan ta Bukid Sinai daw pabaton din mga ambal ta Dyos ki kanen na dili masilian aged iatag din man naan ki kiten. ");
INSERT INTO cgc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Piro, ate ya na mga kaapuan ula gapati ki Moises. Pasikway danen kanen ya daw gusto danen na magbalik naan ta lugar na Egipto. ");
INSERT INTO cgc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Tenged lugay Moises ya naan ta bukid, gambal mga ittaw ya ki Aaron, ‘Ubraan kay no ta mga dyos na magpanguna ki kiten tak ula kay nalam daw ino en natabo ki Moises na ya na gapanguna ki kiten ta ate na pag-alin ta Egipto.’ ");
INSERT INTO cgc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iling tan iran na isip na gaubra danen ya ta dyos-dyusan na paryo ta tinday na baka lagen. May mga ayep na paiyaw danen ya daw pasunog bilang iran na alad naan ta dyos-dyusan daw gasadyaay danen ya tenged ta iran na pabuat. ");
INSERT INTO cgc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Piro, patalikuran danen ya ta Dyos daw pabay-an din nang bisan pa na magsimba danen an ta adlaw, bulan daw mga bituon na naan ta kalangitan. Pabuat ya danen paryo ta nasulat naan ta libro Amos na prupita anay pa sa na Dyos gambal, ‘Mga linai Israel! Dili para ki yaken mga paiyaw nyo an daw paalad na mga ayep naan ta lugar na ula kabalayan seled ta kwarinta na taon. ");
INSERT INTO cgc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Inyo na mga paalad para ta mga dyos-dyusan nyo paryo ki danen Moloc na iya na balbalay papadala nyo daw Refan na bituon nyo na dyos na papadala nyo man. Danen mga dyos-dyusan na pabuat nyo na simbaen. Tenged ta pabuat nyo, palinen ko kyo yan daw ipadala naan ta unaan ta lugar na Babilonia.’” ");
INSERT INTO cgc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Gambal pa Esteban naan ta mga mimbro ta Sanedrin, “Ate ya na mga kaapuan na naan danen ta lugar na ula kabalayan, may turda na para ta pagsimba ta Dyos na naan dya kasugtanan na alin ki kanen. Turda ya paubra ta iran na mga kaapuan paryo ta paambal ta Dyos ki Moises sunod ta plano na pakita ta Dyos ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Paglambay ta tama na mga taon, iran na mga linai na ate man na alinan na mga kaapuan, danen man ya gadala ta turda ta timpo na Josue ya gapanguna ki danen. Josue ya gapanguna ki danen ta timpo na papaalin ta Dyos mga ittaw ya na ula gapati ki kanen daw iran ya na basak paatag din ta ate ya na mga kaapuan. Turda ya naan ki danen asta ta timpo na Ari David gadumala ki danen. ");
INSERT INTO cgc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dyos an nalipay gid ki David. Gangayo David ya naan ta Dyos na tugutan kanen an na magpatindeg ta pirmaninti na balay ta Dyos aged mga ittaw an naan dya magsimba ta Dyos na yon man Dyos na pasimba Jacob na kaapuan na alinan David. ");
INSERT INTO cgc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Piro, ula natukod David balay ya. Iya na bata na Solomon, kanen gapatukod. ");
INSERT INTO cgc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Piro, Dyos Na Labaw Ta Tanan dili din kinanglan na mag-istar naan ta balay na papatindeg ta mga ittaw paryo ta paambal din paagi ki Isaias na prupita anay pa sa, ");
INSERT INTO cgc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Langit an ake na truno na pungkuan ko daw kalibutan an tungtungan ta ake na batiis. Impusibli na maubra nyo balay na paryo tan para ki yaken. Ula istaran para puayan ko. ");
INSERT INTO cgc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yaken gabuat ta tanan na naan ta langit daw kalibutan.’” ");
INSERT INTO cgc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Gambal pa gid Esteban naan ta mga mimbro ta Sanedrin, “Mga sutil kaw gid na mga ittaw! Paryo kaw inyo ta mga ittaw na ula gapati ta Dyos. Paryo kaw gid man ta inyo na mga alinan na kaapuan tak pirmi kaw ula gatuman ta Dyos Ispiritu Santo. ");
INSERT INTO cgc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tanan na mga prupita na manugsugid ta kabebet-en ta Dyos anay pa sa papangabot ta inyo na mga alinan na kaapuan. Papatay man ta inyo na mga alinan na kaapuan bisan pa mga gatagna ya parti ta pag-abot ta Matareng Na Manugsirbi Ta Dyos na bag-o nyo nang patrayduran daw papatay. ");
INSERT INTO cgc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Inyo na mga kaapuan kabaton ta Mga Sinulat Moises na paatag ta Dyos ki kyo paagi ta iya na mga angil. Piro, ula nyo gid patumana.” ");
INSERT INTO cgc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pagmati ta mga mimbro ta Sanedrin ta ambal Esteban, gagilek gid danen an daw gabaggit ta tudo ta subla na kaeget. ");
INSERT INTO cgc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Piro, Esteban i pagaeman gid ta Dyos Ispiritu Santo daw gatan-aw gid naan ta langit. Nakita din kapawa naan alin ta Dyos daw nakita din man Jesus an na gatindeg tengnged ta Dyos naan dapit ta tuo. ");
INSERT INTO cgc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Gambal pa Esteban i naan ta mga mimbro ta Sanedrin, “Lagen nyo! Nakita ko langit an na gabukas daw Kanen Na Alin Ta Langit Na Natao Naan Ta Kalibutan gatindeg tengnged ta Dyos naan dapit ta tuo!” ");
INSERT INTO cgc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pagmati danen ta ambal Esteban, gasinggit danen an ta tudo daw patakleban danen iran an na mga talinga daw gadlagan munta ki kanen daw dakepen. ");
INSERT INTO cgc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Payudyod danen kanen an na pagwa ta syudad daw paumpisaan danen ta timbag kanen an ta mga bato. Mga gatistigo kuntra ki Esteban, pabilin danen iran na mga pang-isleb na bayo naan tengnged ta isya na mama na ngaran din Saulo. ");
INSERT INTO cgc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na patimbag danen Esteban an, gapangamuyo gid kanen an na batunon Ginuo Jesus iya an na ispiritu. ");
INSERT INTO cgc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Galuod kanen an daw gasinggit na bakod iya na kagi, “Ginuo, dili no bilangen na sala iran i na buat ki yaken!” Pagtapos ta ambal Esteban, nabugtuan kanen an ta ginawa. ");
INSERT INTO cgc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ta pagpatay ki Esteban, Saulo ya gakumpurmi man na miad iran ya na buat. Ta yon man na adlaw na Esteban ya papatay, gaumpisa en segeng gid na pagpangabot kuntra ta mga gatuo ki Jesus na naan ta Jerusalem. Duma na mga gatuo galapta en naan ta mga prubinsya na Judea daw Samaria. Piro mga apustulis Jesus a, gapabilin nang naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Parti ki Esteban, lawa din ya palebbeng ta dyusnon na mga ittaw daw sikad gid iran na pag-ug-og. ");
INSERT INTO cgc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo i a, gatingwa gid ta iya na pagpangabot kuntra ta mga gatuo ki Jesus. Gabalay-balay gid kanen an daw papayudyod din daw papriso mga mama man daw mga bai. ");
INSERT INTO cgc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mga gatuo ya na galapta, gasugid danen an ta miad na balita parti ki Jesus bisan indi nang danen an punta. ");
INSERT INTO cgc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe i giling naan ta syudad na sakep ta Samaria. Gawali kanen dya na Jesus an kanen Pinili Ta Dyos Na Mag-ari na papadala ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na namatian ta sikad tama na mga ittaw dya wali an Felipe daw nakita danen tanan na mga katingalaan na pabuat din, gapati gid danen an ta iya na ambal. ");
INSERT INTO cgc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tenged ta mga katingalaan na pabuat din na pamatuod na kanen an papadala ta Dyos, tama gid na mga malain na ispiritu gagwa ta mga ittaw daw gasinggit na bakod iran an na kagi. Tama man na mga ittaw na dili kapanaw daw mga ittaw na piang papaayad din. ");
INSERT INTO cgc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tenged ta tanan na mga buat Felipe, nalipay gid mga ittaw an na naan ta syudad ya. ");
INSERT INTO cgc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","May mama na dati na manugmadyik na ngaran din Simon. Kanen an naan gaistar ta yon man na syudad ta Samaria na naan dya gabuat Felipe an ta mga katingalaan. Ta kalugayen en na timpo, napatingala gid Simon mga Samaritano an ta iya na abilidad ta pagmadyik daw gapabugal kanen an na bantog na ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tanan na mga Samaritano alin ta mga manggaranen asta ta mga imol gamati daw galuag ki kanen daw gambal, “Kanen dyos an na paumaw na Bakod Na Gaem.” ");
INSERT INTO cgc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gambal danen ta iling tan daw gapati danen ki kanen tak ta lawig na timpo gatingala gid danen an ta iya na abilidad ta pagmadyik. ");
INSERT INTO cgc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Piro, na namatian ta mga ittaw pasugid an Felipe daw gapati danen an parti ta miad na balita parti ta pagdumala ta Dyos daw parti man ki Jesu-Cristo na kanen Pinili Ta Dyos Na Mag-ari, tama ki danen gapabautismo, mga mama man daw mga bai. ");
INSERT INTO cgc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Asta Simon an na manugmadyik gapati man ta wali an Felipe daw nabautismuan. Pirmi kanen an gakuyog-kuyog ki Felipe daw indi punta tak gabilib kanen an ta mga katingalaan na buat Felipe. ");
INSERT INTO cgc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mga apustulis an na naan ta Jerusalem, na namatian danen na mga Samaritano an gapati man ta miad na balita na alin ta Dyos parti ki Jesus, papadala danen Pedro an daw Juan na miling naan ta Samaria. ");
INSERT INTO cgc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pag-abot danen dya, papangamuyuan danen mga bag-o nang an gatuo aged mabaton ta mga gatuo Dyos Ispiritu Santo an. ");
INSERT INTO cgc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ta yon man na timpo, Dyos Ispiritu Santo an ula pa nabaton ta bisan kino ki danen. Nabautismuan nang danen an na pamatuod na danen an gatuo ki Ginuo Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tenged ula pa danen kabaton ta Dyos Ispiritu Santo, patungtong Pedro daw Juan iran an na mga lima naan ki danen aged mabaton danen Dyos Ispiritu Santo an. ");
INSERT INTO cgc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na nakita Simon na Dyos Ispiritu Santo an paatag paagi ta pagtungtong ta mga lima Pedro daw Juan, patanyagan din danen an ta kwarta ");
INSERT INTO cgc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","daw gambal, “Tagan a nyo man ta inyo na gaem aged daw kino matungtungan ko ta ake na lima, mabaton din man Dyos Ispiritu Santo an.” ");
INSERT INTO cgc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piro, sabat Pedro ki kanen, “Kabay pa inta na marwad ka asta kwarta no an tak salig no mapalit no gaem an na paatag nang an ta Dyos! ");
INSERT INTO cgc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kaon yan, ula ka gid imo labet ta ame na ubra tak ta pagtan-aw ta Dyos, malain imo an na isip. ");
INSERT INTO cgc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Magnelsel ka daw dilian no malain no an na isip daw mangamuyo ka ta Ginuo Dyos na kabay pa na patawaren ka din ");
INSERT INTO cgc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","tak ta panilag ko, nainggit ka nang gid daw naulipen man ta sala.” ");
INSERT INTO cgc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sabat Simon, “Pangamuyuan a nyo naan ta Ginuo aged dili matabo ki yaken mga naambal nyo an.” ");
INSERT INTO cgc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pagtapos ta pagpamatuod daw pagsugid ta miad na balita parti ki Ginuo Jesus naan ta mga ittaw, danen Pedro daw Juan gabalik naan ta Jerusalem. Ta iran na pagpanaw na malik, gaapit-apit danen an naan ta tama na mga banwa ta Samaria daw gasugid ta miad na balita parti ki Ginuo Jesus naan ta tama na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","May angil ta Ginuo na gambal ki Felipe, “Magpriparar ka daw miling naan dapit ta bagat daw magi ka ta dalan na alin ta Jerusalem na megbeng naan ta Gaza. Yon na dalan gaagi man naan ta lugar na ula kabalayan.” ");
INSERT INTO cgc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pagmati Felipe, patuman din ambal ya ta angil daw gapanaw. Ta iya na pagpanaw, nakita din isya na upisyal na taga-Etiopia na may datas na katengdanan. Upisyal an isya na manug-ibit ta tanan na manggad ta Candace na rayna ta Etiopia. Naan galin upisyal an ta Jerusalem tak naan dya kanen gasimba ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Guli kanen an na gasakay ta iya na kalisa daw gabasa ta sinulat Isaias na prupita na manugsugid ta kabebet-en ta Dyos anay pa sa. ");
INSERT INTO cgc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Gambal Dyos Ispiritu Santo an ki Felipe, “Pranian no kalisa an daw abayan.” ");
INSERT INTO cgc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pagmati Felipe ta ambal ta Dyos Ispiritu Santo, gadlagan kanen i na marani naan ta kalisa. Namatian din pabasa an ta upisyal na alin ta sinulat Isaias. Gainsa kanen i, “Naintindian no beet ambalen ta pabasa no an?” ");
INSERT INTO cgc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Sabat ta upisyal, “Ino pag-intindi ko ti daw ula may magsaysay ki yaken?” Pag-ambal ta upisyal, paambalan din Felipe i na makay daw mungko tengnged ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yi parti ta sinulat Isaias na pabasa ta upisyal: “Kanen an paryo ta karniro na padala aged iyawen. Kanen an paryo man ta bata pa na karniro na daw guntingan ta belbel, gapabaya nang gid. Iling man tan kanen an, ula gasasaba. ");
INSERT INTO cgc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Papagayyaan kanen an daw dili man matareng pagsintinsya ki kanen. Ula linai na kaapuan alin ki kanen tak iya na kabui unti ta kalibutan i palipo nang ta mga gasintinsya ki kanen.” ");
INSERT INTO cgc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Upisyal an gambal ki Felipe, “Sugiran a no tuo daw kino paisturya ta manugsulat i. Iya na kaugalingen o duma na ittaw?” ");
INSERT INTO cgc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Alin ta yon man gyapon na sinulat, pasugid Felipe ki kanen miad i na balita parti ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ta pagpadayon danen, kasampet danen an naan ta lugar na may waig daw gambal upisyal an, “Lagen no! May waig di! Pwidi a mabautismuan?” ");
INSERT INTO cgc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Sabat Felipe, “Pwidi, daw magtuo ka ki Jesus na terek gid ta imo na tagipusuon.” Ambal din, “Gatuo a gid na Jesu-Cristo an Bata Ta Dyos.” ");
INSERT INTO cgc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pateneng ta upisyal kalisa an. Danen an na darwa gapanaog naan ta waig daw pabautismuan Felipe kanen an. ");
INSERT INTO cgc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pagtakas danen, gulpi nang pakamang Felipe i ta Dyos Ispiritu Santo na papaubay ta Ginuo naan ta mga gatuo daw ula en nakita ta upisyal Felipe i. Gapadayon upisyal ya ta iya na pagpanaw na may kalipay. ");
INSERT INTO cgc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe i a, namasmasan din nang en na naan en kanen i ta Asoto na sakep ta Judea. Naan dya, galibot kanen an na gasugid ta miad na balita parti ki Jesus naan ta tanan na mga banwa asta kabot kanen i naan ta Cesarea. ");
INSERT INTO cgc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo i, gapadayon pa gid ta pagpangabot na ipapatay din bisan kino nang na mga gasunod ta mga patudlo Ginuo Jesus. Giling kanen i ta pinakadatas na manugdumala ta mga pari ");
INSERT INTO cgc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","para mangayo ta mga sulat na magpakala ki kanen naan ta mga manugdumala ta mga balay tipunan ta mga Judio naan ta syudad na Damasco. Paagi ta mga sulat na ya, mlaman ta mga manugdumala na kanen i may uturidad na daw makita din maskin kino nang, mga mama man daw mga bai, na isya ta grupo na paumaw na Mga Gasunod Ta Mga Patudlo Jesus dakepen na pusasan daw dleen naan ta Jerusalem aged prisuon. ");
INSERT INTO cgc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ta iya na pag-iling naan ta syudad Damasco na dali nang en kanen an kabot, nali nang may gasilak naan ki kanen na sikad pawa na naan alin ta langit. ");
INSERT INTO cgc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natumba kanen i naan ta basak daw may namatian kanen i na gambal ki kanen, “Saulo, Saulo, man-o tak papangabot a no?” ");
INSERT INTO cgc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo i gainsa, “Sir, kino ka?” Sabat ta gambal ya ki kanen, “Yaken i Jesus na papangabot no. ");
INSERT INTO cgc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mangon ka daw melled naan ta Damasco daw naan dya may magsugid ki kaon daw ino naan ta plano ta Dyos na buaten no.” ");
INSERT INTO cgc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mga duma ya Saulo ula gasasaba. Namatian danen kagi ta gambal ya, piro ula danen may nakita na bisan kino. ");
INSERT INTO cgc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Gabangon Saulo i, piro pagmuklat din, dili en kanen i kakita. Pasagabay nang danen kanen i asta kabot naan ta Damasco. ");
INSERT INTO cgc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Seled ta tallo na adlaw, dili kanen i makakita daw ula kanen gakaan daw gainem ta bisan ino. ");
INSERT INTO cgc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Naan ta Damasco may isya na gatuo ki Jesus na ngaran din Ananias. Gambal Dyos an ki kanen paagi ta panan-awan, “Ananias!” Sabat Ananias, “Ginuo, anen a di.” ");
INSERT INTO cgc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ambal ta Ginuo ki kanen, “Miling ka naan ta balay danen Judas na naan ta dalan na paumaw na Kalsada Na Tadleng daw insaan no daw pwidi no isturyaen mama ya na taga-Tarso na ngaran din Saulo tak naan kanen dya gapangamuyo. ");
INSERT INTO cgc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Paagi man ta panan-awan, nakita Saulo isya na mama na gaprani ki kanen daw mama an patungtong din iya an na mga lima naan ki Saulo aged Saulo an makakita isab.” ");
INSERT INTO cgc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sabat Ananias, “Ginuo, tama gasugid ki yaken parti ta yon na mama daw parti ta makaadlek din na mga pabuat naan ta imo na mga ittaw naan ta Jerusalem. ");
INSERT INTO cgc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Giling kanen an di na may uturidad naan alin ta mga manugdumala na mga pari aged magdakep ta tanan na mga ittaw na gasimba ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Piro, ambal ta Ginuo ki Ananias, “Manaw ka! Mama na ya na Saulo, papili ko na gamiten para magsirbi ki yaken daw magsugid parti ki yaken naan ta mga dili linai Israel, mga ari daw mga linai Israel. ");
INSERT INTO cgc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ipakita ko ki kanen mga kabellay an na naan ta plano ta Dyos na maagian din tenged ki yaken.” ");
INSERT INTO cgc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pagtapos ta ambal ta Dyos, gapanaw Ananias an daw gaselled naan ta balay danen Judas. Patungtong din iya an na mga lima ki Saulo daw gambal kanen an, “Saulo, utod ko, papadala a di Ginuo Jesus na gapakita ki kaon naan ta dalan na giling ka di ta Damasco i. Papadala a din aged makakita ka isab daw mabaton no man Dyos Ispiritu Santo.” ");
INSERT INTO cgc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nali nang, may nulog na naan alin ta mga mata Saulo na paryo imbis ta sidda daw kakita en kanen an isab. Gabangon kanen an daw gapabautismo. ");
INSERT INTO cgc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Gakaan en kanen an daw gabalik en iya ya na keseg. Gatinir Saulo i ta pila na mga adlaw naan ta Damasco duma ta mga gatuo na naan dya. ");
INSERT INTO cgc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Gaumpisa dayon kanen i ta pagwali naan ta mga balay tipunan na Jesus an Bata Ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Gatingala gid tanan an na mga ittaw na kamati ki kanen daw gainsa danen an, “Di' ba yi mama na gapangabot daw gapatay ta mga ittaw naan ta Jerusalem na mga gatuo ki Jesus? Di' ba kanen i giling di aged dakepen mga gatuo an daw dleen danen an naan ta mga manugdumala na mga pari?” ");
INSERT INTO cgc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Iling tan iran na isip parti ki Saulo, piro paagi ta tabang ta Dyos ki kanen, gadugang pa gid iya na abilidad ta pagsugid ta miad na balita parti ki Jesus asta na mga Judio an na naan ta Damasco gatingala gid daw ula man danen an may isabat kuntra ta iya na pawali tak pamatuuran din gid na Jesus an Pinili Ta Dyos Na Mag-ari. ");
INSERT INTO cgc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Paglambay ta tama na mga adlaw, pila na mga manugdumala ta mga Judio gaplano na Saulo an patayen danen. ");
INSERT INTO cgc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Piro, may gasugid ki Saulo parti ta iran na plano. Adlaw daw kilem, pabantayan ta mga Judio mga gangaan an ta syudad aged patayen kanen an. ");
INSERT INTO cgc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Piro, isya na kilem, kanen an patabangan ta mga ittaw na gasunod ta iya na tudlo parti ki Jesus. Kanen an paugsak danen naan ta bangkat daw patunton naan agi tumbuan ta padir ta syudad. ");
INSERT INTO cgc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Giling Saulo an naan ta Jerusalem daw gatingwa kanen an na mabet ta mga gatuo na naan dya, piro nadlek danen ya ki kanen tak dili danen ya magpati na kanen an gatuo man en ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Piro, isya ki danen na ngaran din Bernabe, patabangan din Saulo an daw papakala naan ta mga apustulis. Pasaysay Bernabe ki danen na Saulo an na naan kanen ta dalan munta ta Damasco nakita din Ginuo ya daw Ginuo ya gambal ki kanen. Pasugid man Bernabe ki danen na Saulo an na naan kanen an ta Damasco, ula gid kanen adlek na gawali parti ki Jesus. ");
INSERT INTO cgc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pagtapos Bernabe ta ambal, pabaton ta mga apustulis ambal din an parti ki Saulo daw gakuyog Saulo an ki danen na galibot ta bilog na Jerusalem daw ula adlek kanen an na gawali parti ta Ginuo. ");
INSERT INTO cgc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Naan man ta mga Judio na iran na linggwai Griego gaisturya kanen an daw gadiskas, piro paplanuan danen na patayen kanen an. ");
INSERT INTO cgc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na nlaman ta mga gatuo parti ya ta plano na patayen danen Saulo an, padul-ong danen kanen an naan ta Cesarea daw papailing naan ta Tarso. ");
INSERT INTO cgc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ta yon man na timpo, mga gatuo an naan ta bilog na Judea, Galilea daw Samaria ula en papangabot ta mga gakuntra ki danen daw galig-en pa gid iran an na pagtuo. Mga gatuo an dya gatama pa gid daw tenged ta tabang ta Dyos Ispiritu Santo, papakita danen paagi ta iran na ugali na danen an may bakod gid en na pagtaod ta Ginuo. ");
INSERT INTO cgc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro i, tama en na mga banwa na nailingan din daw giling man kanen i naan ta mga ittaw na iya ta Dyos na naan gaistar ta Lida. ");
INSERT INTO cgc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Naan dya, may nakita kanen i na mama na ngaran din Eneas na naparalays daw ula kabangon naan ta iya na neggaan ta wallo en na taon. ");
INSERT INTO cgc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Gambal Pedro i ki kanen, “Eneas, paayad ka en Jesu-Cristo. Mangon ka daw imesen no imo an na neggaan.” Dayon gabangon Eneas an. ");
INSERT INTO cgc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tanan na mga ittaw na gistar naan ta Lida daw Patag Saron na kakita na Eneas an nayad en, danen an gatuo ta Ginuo. ");
INSERT INTO cgc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Naan ta syudad Jope may bai na gatuo ki Jesus na ngaran din Tabita. Naan ta linggwai na Griego iya na ngaran Dorcas na beet ambalen usa. Pirmi kanen an gabuat ta miad daw matabyangen man kanen an ta mga imol. ");
INSERT INTO cgc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ta yon na mga inadlaw na Pedro an naan ta Lida, gamasakit Tabita i daw kanen i napatay. Iya na lawa patrapuan danen daw naan kanen i ta apaw na kwarto pauyusa. ");
INSERT INTO cgc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tenged dili gid madyo Jope an ta Lida daw tenged man na mga gatuo na naan ta Jope kabalita na Pedro an naan ta Lida, papailing danen ki kanen darwa na mga mama. Gapangabay danen ki kanen na muyog ki danen dayon na miling naan ta Jope. ");
INSERT INTO cgc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Gaimes Pedro i daw muyog ki danen. Pag-abot danen naan ta Jope, papanaik danen kanen an naan ta apaw ya na kwarto. Galibot ki kanen mga bai an na balo na nangagal daw papakita danen ki kanen mga bayo na patai Dorcas na kanen ya bui pa. ");
INSERT INTO cgc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Papagwa Pedro alin ta kwarto danen an tanan daw galuod kanen i na mangamuyo. Pagtapos din ta pagpangamuyo, gatubang kanen i naan ta patay ya daw gambal, “Tabita, mangon ka!” Pag-ambal Pedro, gamuklat Tabita an. Pagkita din ki Pedro, gabangon kanen an daw mungko. ");
INSERT INTO cgc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Paibitan Pedro iya na lima daw patindegen kanen an. Paumaw Pedro dayon mga gatuo an daw mga bai na balo daw patugyan din ki danen Tabita an na bui en. ");
INSERT INTO cgc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nabalitaan ta mga ittaw naan ta bilog na Jope natabo ya ki Tabita daw tama en gatuo an ta Ginuo. ");
INSERT INTO cgc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro ya gatinir naan ta Jope ta pila na mga adlaw duma ta isya na mama na ngaran din Simon na manugbelad ta langgit ta mga ayep. ");
INSERT INTO cgc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","May mama naan ta syudad Cesarea na ngaran din Cornelio. Kanen an upisyal ta mga sundalo ta gubirno ta Roma na naan ta batalyon na paumaw Batalyon Italyano. ");
INSERT INTO cgc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kanen an dyusnon na ittaw daw bilog din na panimalay iran na pasimba Dyos an na pasimba ta mga Judio. Bakod gid iya an na tabang naan ta mga imol na mga Judio daw pirmi man kanen an gapangamuyo ta Dyos. ");
INSERT INTO cgc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Isya na mapon na mga tallo uras galambay alin ta ugto-adlaw, may nakita kanen an na panan-awan. Naan ta iya na panan-awan may nakita kanen an na angil ta Dyos na gaprani daw gaumaw ki kanen, “Cornelio!” ");
INSERT INTO cgc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Patan-aw din gid ta miad angil an ta subla din na kaadlek daw gasabat kanen an, “Sir, man-o a?” Sabat ta angil, “Pabaton ta Dyos imo na mga pangamuyo daw nlaman din man na gatabang ka ta mga imol. Yon na gademdem kanen ki kaon. ");
INSERT INTO cgc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Anduni, magpadala ka ta mga mama naan ta syudad Jope aged sugaten danen mama an na ngaran din Simon na paumaw man na Pedro. ");
INSERT INTO cgc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Gadayon kanen an naan ta balay Simon na manugbelad ta langgit ta mga ayep daw iya na istaran dani nang ta baybay.” ");
INSERT INTO cgc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na galin angil ya, paumaw Cornelio darwa ta iya na mga suguon daw isya ta iya na mga sundalo. Sundalo an dyusnon daw saligan din man. ");
INSERT INTO cgc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pasugiran din danen an ta tanan parti ta panan-awan din daw papailing din danen an naan ta Jope. ");
INSERT INTO cgc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ta sunod na adlaw, mga suguon Cornelio giling naan ta Jope. Ta mga ugto-adlaw dani nang en danen an mabot naan ta Jope. Ta yon man na uras, Pedro i gapanaik naan ta atep ta balay aged mangamuyo. ");
INSERT INTO cgc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nletem gid en kanen i daw gusto din en na maan. Na paimes nang pa pagkaan an para ki kanen, may papakita Dyos an ki kanen na panan-awan. ");
INSERT INTO cgc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Naan ta iya na panan-awan nakita din na langit an gabukas daw may gababa na paryo ta syal na lapad na may igot naan ta appat na pusod daw patunton naan ta basak. ");
INSERT INTO cgc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Naan ta syal ya tanan na mga klasi ta mga ayep na appat batiis, mga ayep na gagyanap daw mga yupan. May anen na mga ayep na naan ta syal na bawal kan-enen para ta mga Judio. ");
INSERT INTO cgc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","May namatian kanen i na gambal na naan ta langit, “Pedro, mindeg ka! Mag-iyaw ka, magluto daw maan!” ");
INSERT INTO cgc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piro gasabat Pedro i, “Ginuo, dili ko mabuat nyan! Ula a gid gakaan ta bisan ino na pagkaan na pakabig na ‘dili-limpyo’.” ");
INSERT INTO cgc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pagsabat Pedro, namatian din isab gambal ya ki kanen, “Dili no ambalen na ‘dili-limpyo’ bisan ino na pakabig en ta Dyos na ‘limpyo’.” ");
INSERT INTO cgc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tallo bisis iling tan natabo daw paryo ya ta syal pabatak na balik naan ta langit. ");
INSERT INTO cgc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na gaisip pa Pedro i daw ino beet ambalen ta iya na panan-awan, mga mama ya na papailing Cornelio ki kanen, nakita danen balay an Simon. Paagi ta pag-insa-insa ta mga mama ya, naisipan danen na yon taan balay na dayunan Pedro daw anen en danen an ta gangaan ta sular. ");
INSERT INTO cgc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Gaumaw anay danen an daw gainsa, “May gadayon di na ngaran din Simon na paumaw man na Pedro?” ");
INSERT INTO cgc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na gapalibeg pa Pedro i parti ta iya na panan-awan, Dyos Ispiritu Santo an gambal ki kanen, “Mamati ka! May tallo na mama di na gangita ki kaon. ");
INSERT INTO cgc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Manaog ka daw dili ka magdua-dua ta pagkuyog ki danen tak yaken gapadala ki danen.” ");
INSERT INTO cgc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pag-ambal ta Dyos Ispiritu Santo, gapanaog Pedro i daw gambal naan ta mga mama, “Yaken papangita nyo. Ino tuyo nyo ta pag-iling nyo di?” ");
INSERT INTO cgc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Gasabat danen an, “Papailing kay di ki kaon ta isya na upisyal ta mga sundalo na ngaran din Cornelio. Miad kanen an na mama na iya na pasimba Dyos an ta mga Judio daw kanen an pataa gid ta tanan na mga Judio. May panan-awan kanen an na isya na angil ta Dyos gambal ki kanen na imbitaren ka na miling naan ta iya na balay aged mamati kanen an ta imo na ambal.” ");
INSERT INTO cgc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pagmati Pedro, paambalan din mga mama an na melled daw naan din dya danen an patunugaa. Sunod pa gid na adlaw, gaimes Pedro i daw gakuyog ta mga mama na papailing Cornelio ki kanen. May pila na mga utod ki Cristo na mga taga-Jope na gakuyog man ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sunod na adlaw, gabot danen an naan ta syudad Cesarea. Cornelio an gatagad ki danen duma ta iya na mga parinti daw mga seed din na arey na paimbitar din. ");
INSERT INTO cgc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na melled en Pedro i naan ta balay danen Cornelio, pasugat Cornelio kanen i daw galuod Cornelio an naan ta atubangan din na simbaen inta kanen i. ");
INSERT INTO cgc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piro, gambal Pedro i ki Cornelio, “Mindeg ka tak ittaw a nang man na paryo ki kaon.” ");
INSERT INTO cgc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Gaisturya pa Pedro ki Cornelio na gaselled danen ta balay daw nakita Pedro tama na mga ittaw na gatipon dya. ");
INSERT INTO cgc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Gambal Pedro i ki danen Cornelio, “Nlaman nyo gid na kami i na mga Judio ula kay patuguti ta ame na patuuan na magbisita ki kyo na mga dili-Judio. Dili kay man pwidi magduma ki kyo. Piro, papaintindi ta Dyos ki yaken na dili ko kabigen na ‘dili-limpyo’ bisan ino na lai ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gani, na paimbitar a nyo na miling di, ula a gabalibad. Anduni, liag ko na mlaman man-o na papaumaw a nyo.” ");
INSERT INTO cgc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Sabat Cornelio, “Mga tallo en adlaw galambay, gapangamuyo a naan ta ake i na balay. Ta iling man ti na uras na mga tallo uras paglambay ta ugto-adlaw, nali nang may gapakita ki yaken na mama na sikad silaw iya na bayo ");
INSERT INTO cgc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","daw gambal kanen ki yaken, ‘Cornelio! Imo an na pangamuyo namatian ta Dyos daw gademdem kanen ta imo na pagtabang naan ta mga imol. ");
INSERT INTO cgc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Magpadala ka ta mga mama naan ta Jope aged sugaten danen mama an na ngaran din Simon na paumaw man na Pedro. Gadayon kanen an naan ta balay Simon na manugbelad ta langgit ta mga ayep daw iya na istaran dani nang ta baybay.’ ");
INSERT INTO cgc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pag-ambal ta mama ki yaken ta iling tan, papailingan ko kaon yan dayon daw gapasalamat a gid ki kaon na giling ka di. Anduni, naan kay di tanan ta tubangan ta Dyos gatagad aged mamati ta bisan ino na pasugo din na iambal no.” ");
INSERT INTO cgc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Gaumpisa Pedro i ta pagwali naan ki danen Cornelio parti ki Jesus, “Anduni, naintindian ko en na paryo nang pagkabig an ta Dyos ta tanan na mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Bisan kino na gataod ta Dyos daw gabuat ta matareng, nadayaran Dyos an ki kanen bisan ino iya na lai. ");
INSERT INTO cgc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nlaman nyo miad na balita na papasugid ta Dyos ki kami na mga linai Israel para mlaman ta daw ino na paagi na patawaren ki din ta ate na mga sala. Miad an na balita pasugid ki kiten paagi ki Jesu-Cristo na Ginuo Ta Tanan. ");
INSERT INTO cgc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nlaman nyo na minsai ya nawali umpisa alin ta Galilea asta ta bilog na Judea pagtapos Juan ta wali na mga ittaw an dapat na magnelsel daw dilian iran an na mga sala daw magpabautismo. ");
INSERT INTO cgc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nlaman nyo parti ki Jesus na taga-Nazaret, daw paino kanen ya papili ta Dyos daw paubayan ta Dyos Ispiritu Santo. Jesus an paatagan man ta Dyos ta uturidad na paryo gid ta iya na uturidad. Nlaman nyo man na Jesus ya giling naan ta lain-lain na mga banwa daw gabuat ta mga miad naan ta mga ittaw daw gapaayad man ta tanan na mga ittaw na pagaeman Satanas. Iling tan pabuat Jesus tenged pirmi gaduma Dyos an ki kanen. ");
INSERT INTO cgc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kami na mga apustulis mga kakita gid ta tanan na mga pabuat din naan ta Jerusalem daw naan man ta duma pa na mga banwa ta mga Judio. Papapatay kanen ya ta mga manugdumala ta Judio paagi ta paglansang naan ta krus. ");
INSERT INTO cgc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Piro, ta pangallo na adlaw, pabannaw kanen ta Dyos daw gapakita kanen an naan ta mga ittaw. ");
INSERT INTO cgc_vpl VALUES ("AC10_41","074_10_41","ACT","10"