﻿USE sofia;
DROP TABLE IF EXISTS sofia.cfm_vpl;
CREATE TABLE cfm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cfm_vpl WRITE;
INSERT INTO cfm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pathian Fapa, Jesuh Khrih ih Thuthang Ṭha ih hramthawhnak cu hitih in a si. ");
INSERT INTO cfm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profet Isaiah ih nganmi mangin: “ ‘Zohhnik, na hmai ah ka palai ka thlah thok, Ani nih na zalam a timtuah thok.’ ");
INSERT INTO cfm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ramṭhing ih mi pakhat hehnak aw nih, ‘Bawipa ih zalam timtuah uh; A zalam cu dingter uh,’ a ti.” ");
INSERT INTO cfm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Baptisma petu Johan cu ramṭhing la in a ban ih, sual ngaihthiamnak hrangah sirfaknak baptisma thu a sim. Ani nih mipi pawl sinah, “Nan sual sir uh la baptisma la uh. Cun Pathian nih nan sual pawl nan ta ngaihthiam thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Cun Judea peng pumpi le Jerusalem mi zate pawl cu a sinah an feh. An sualnak pawl an phuang ih Johan hmangin Jordan tikua ah baptisma an co. ");
INSERT INTO cfm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johan cu kalauk hmul ih tuahmi hnipuan a hru ih a tai ah saphaw taikap a kap. Cun khabawk le hramlak khuailawti cu caw ah a ei. ");
INSERT INTO cfm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Cun, a thusipmi cu, “Ka dungih a tiang dingmi pa hi kei nakin a picang sawn, a hmai ah kun pit in a kedap hri phoihsaktu ding hmanah kei cu ka tlak lo. ");
INSERT INTO cfm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kei cu ti in baptisma nan ta pe; asinain ani cu Thlarau Thianghlim thawn baptisma nan ta pe thok,” tiah a i. ");
INSERT INTO cfm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cuvai ni ah Jesuh cu Galilee peng Nazareth khua in a ban ih Johan hmangin Jordan tikua ah baptisma a la. ");
INSERT INTO cfm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cun Jesuh cu ti sungih a hang suah cangka in van a hong fa ih Thlarau cu thute mangin a tlunih a rong ṭum cu a hmu. ");
INSERT INTO cfm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Cun van in aw pakhat nih, “Nang cu ka duhdawt ngaimi ka Fapa na si, na cungah ka lung a kim setak,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hmakhatte ah Thlarau nih Jesuh cu ramṭhing ah a ṭhita. ");
INSERT INTO cfm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cun cuvai hmun ah ni sawmli a um ih Seihtan nih a tukforh. Ramsa pawl thawn an um ih vancungmi pawl nih an tuamhlawm. ");
INSERT INTO cfm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Johan thawng an thlak hnukah Jesuh cu Galilee peng ah a feh ih Pathian ih Thuthang Ṭha a sim. ");
INSERT INTO cfm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesuh nih, “Tikcu a kim i ih Pathian uknak a nai i! Nan sual sir u la Thuthang Ṭha cu zum uh!” tiah a sim. ");
INSERT INTO cfm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesuh cu Galilee Tili kap ih a feh laiah, Simon le a unaupa Andru cu nga tlaitu an ih ruangah, tili sungah sur an vorh berbo lai a hmu hnei. ");
INSERT INTO cfm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Cun Jesuh nih an sinah, “Ka thlun uh, cule minung tlaitu ah nan ta tuah thok,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hmakhatte ah an ni nih an sur pawl an ramta ih a dung an thlun. ");
INSERT INTO cfm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Cun Jesuh cu a hlat deuhnak ah a feh ih, Zebedi ih fapa James le a unaupa Johan lawng sungih an sur pawl an rep berbo lai a hmu hnei. ");
INSERT INTO cfm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hmakhatte ah Jesuh nih a ko hnei ih, an pa Zebedi cu an tlakfa pawl thawn lawng sungah an ramta ih a dung an thlun. ");
INSERT INTO cfm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesuh le a dungthluntu pawl cu Kapernaum khua ah an feh, a zingla Sabbath ni ah Jesuh cu Sinakok ah a lut ih thuzirh a thok. ");
INSERT INTO cfm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A thuzirhmi ah an mang a bang, zangahtihle Daanthiam pawl mang i lo in, ani cu thuneitu pakhat mangin a zirh. ");
INSERT INTO cfm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cuvai can ah thlarau sia ih molhmi pa pakhat cu Sinakok sung ah a tiang ih, ");
INSERT INTO cfm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nazareth mi Jesuh, zangtu ah kan na ṭul? Kan na siatsuah dingah maw na tiang? Hu na si tih ta fiah — nang cu Pathian ih mi Thianghlim Pakhat na si,” tiah a hek. ");
INSERT INTO cfm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Cun Jesuh nih cupa cu, “Daite in um, cupa ih sung in suak!” tiah a tai. ");
INSERT INTO cfm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Thlarau sia nih cupa cu thangai in a caihter ih thangngai a heh hnuk ah, cupa ih sung in a suak. ");
INSERT INTO cfm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Cun an zatein an mangbang colh ih, “Aimang thil cu zangtih in a i? Zirhnak thar maw a i? Thlarau sia pawl hman thuneihnak thawn thu a pe hnei ih a thu an thlun!” tiah pakhat le pakhat an sutfa. ");
INSERT INTO cfm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Cutin Jesuh ih thuhla cu hmakhatte ah Galilee peng zate ah a thang colh. ");
INSERT INTO cfm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesuh cu Sinakok ih a suah cang in Simon le Andru teiʼ inn ah James le Johan thawn an lut. ");
INSERT INTO cfm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon nupi ih nu cu khurhfah in a fak ih a it; Jesuh a tian cang in cuvai thu cu an sim lohli. ");
INSERT INTO cfm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesuh cu a sin a va feh ih a kut in a han tho. A khurhfahnak cu a dam ih a tuamhlawm hnei. ");
INSERT INTO cfm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ni a pil ih simla a tian tikah, mi fak pawl le thlarau sia ih molhmi pawl hmahhmah cu Jesuh sinah an tianpit. ");
INSERT INTO cfm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Cun an khawpawh in cuvai inn suahka hmai ah an hmuakkhawmfa. ");
INSERT INTO cfm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesuh nih fahnak phunphun ih a fakmi pawl a damter, cule khawsia tamngai khaw a dawisuak hnei. Khawsia pawl cu ṭon a sian hnei lo; zangahtihle hutu a si tih an fiah. ");
INSERT INTO cfm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Zingmaw khawvang hlan ah Jesuh cu a tho ih inn leng ah a suak. Thawngṭhingnak hmun ah a feh ih thla a cam. ");
INSERT INTO cfm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon le a rualpi pawl nih Jesuh cu an hrawl, ");
INSERT INTO cfm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","an hmuh tikah, “Mi hmahhmah nih ta hrawl eng,” tiah an sim. ");
INSERT INTO cfm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesuh nih, “Khua kiangkap dang ah feh uh sing. Thu ka sim hnei thok. Zangahtihle cucu ka tiannaksan a i,” tiah a sawn hnei. ");
INSERT INTO cfm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cun Galilee peng hmahhmah ah a feh ih an sinakok pawl ah thu a sim ih khawsia pawl khaw a dawisuak. ");
INSERT INTO cfm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Miphar pa pakhat cu Jesuh sin a feh ih, khuk bil in bopnak a hler ih, “na duh ah cu, ka na thiangter thei,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesuh nih a thinfak ih a kut dawh pit in a tham. Cule a sinah, “Ta ka thianter ka duh, thiang i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hmakhatte ah a pharfah a dam ih a thiang. ");
INSERT INTO cfm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesuh nih fak ngai in ralrinnak a pe ih a hlatnak ah a fehter lohli, ");
INSERT INTO cfm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Cun a sinah, “Ngai hnik! Hutu sinah zangkhaw sim hlah. Cunakin puithiam sinah va feh cih la tak zohfel seh; mi hmahhmah nih na dam tihmi an fiahnak dingah Moses ih thupekmi mangin mithiang na sihnak dingah thawinak pe,” tiah thu a pe. ");
INSERT INTO cfm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sikhawsehla cupa cu a feh ih a damnak thu cu duhsah ngaiin a sim ih khawhra a thang. Curuangah Jesuh cu mi ih hmuhhngan in khaw sungah a lut thei i lo. Khaw lengah a um ih a sinah hmunzakip in mi nih an pha. ");
INSERT INTO cfm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ni tawkfang a rei hnukah Jesuh cu Kapernaum khua ah a ban sal ih, inn ah a um tih thu cu mi nih an fiah. ");
INSERT INTO cfm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mi tamngai cu hmunkhat ah an hmuakkhawm fak ruangah khan lawng a um lo ih suahka hram tiangin mi an khat colh. Cun Jesuh nih an sinah thu a sim. ");
INSERT INTO cfm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Minung pali nih taksaze pa cu an zawn fa ih Jesuh sinah an tian pit. ");
INSERT INTO cfm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mi an tam tuk ih Jesuh ih hram an tian pit thei lo ruangah Jesuh umnak zawn inn tlun khuh cu an bal; an bauh colh ih taksaze pa cu a tangthah thawn an ron ṭhum. ");
INSERT INTO cfm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuh nih an zupnak a hmuh tikah, taksaze pa sinah, “Ka fapa, na sual pawl cu ngaihthiam na i cem,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Cun cuvai hmun ih a to ve mi daanthiam hrekkhat pawl nih an thinlung te in, ");
INSERT INTO cfm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Zangruangah hivai pa cu aitin a ṭon? Pathian thangsiat a i. Pathian hrel lo hutu nih sual pawl a ngaihthiam thei?” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuh nih an thinlung te in himang thu an ruah cu hmakhatte ah a thlarau nih a fiah ih an sinah, “Zangruangah nan thinlung te in himang thu cu nan ruat? ");
INSERT INTO cfm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","‘Na sual pawl cu ngaihthiam na i cem,’ tih maw, ‘Hang tho la na tangthah la pit in feh,’ tih, khoitu sawn hi hivai taksaze pa sinah sip bai sawn? ");
INSERT INTO cfm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Asinain Minung Fapa nih leitlun ah sual pawl ngaihthiam theinak thuneihnak a nei tih nan fiahnak dingah hihi tuah a i,” tiah a sim. Taksaze pa sinah, ");
INSERT INTO cfm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Na sinah ta sim, hang tho, na tangthah la piʼn na inn ah ṭin,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cun taksaze pa cu a hang tho ih hmakhatte ah a tangthah la pit in an zate hmuhhngan ah a feh. Curuangah an zatein an mangbang tuk ih, “Aimang thil cu kan hmu kel lo,” tiah an ti ih Pathian an thangṭhat. ");
INSERT INTO cfm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesuh cu Galilee tili kam ah a va feh sal; mi tamngai a sinah an tiang ih thu a zirh hnei. ");
INSERT INTO cfm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A feh pah ah Alfias ih fapa Levi cu a siahkhong zung sungih a to cu a hei hmu. Cun Jesuh nih, “Ka thlun,” tiah a ti. Levi cu a hang ding ih Jesuh cu a thlun. ");
INSERT INTO cfm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cun Jesuh cu Levi ih inn ah caw a ei. Siahkhongtu pawl le misual pawl khaw Jesuh le a dungthluntu pawl thawn caw an ei khat. Minung an tamngai ih Jesuh cu an thlun. ");
INSERT INTO cfm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farasi mi daanthiam pawl nih Jesuh cu siahkhongtu pawl le misual pawl thawn caw an ei khat lai an hmuh tikah, a dungthluntu pawl sinah, “Zangruangah Jesuh cu siahkhongtu pawl le misual pawl thawn caw an ei khat?” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cun Jesuh nih a thei hnei ih an sinah, “Mi fimdam pawl nih sibawi an ṭul lo, mifak pawl kau nih an ṭul. Mi dingfel pawl ko dingah ka tiang lo, misual pawl ko dingah ka tiang,” tiah a let hnei. ");
INSERT INTO cfm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Johan ih dungthluntu pawl le Farasi pawl cu caw an ul. Minung pawl cu Jesuh sin an feh ih, “Johan ih dungthluntu pawl le Farasi dungthluntu pawl cu caw an ul, zangruangah na dungthluntu pawl cu caw an ul ve lo?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Cun Jesuh nih an sinah, “Mo neitu an sinih a um laiah, mo lawmtu pawl caw an ul thok maw? Mopuai ah mo neitu an sinih a um sung cu caw an ul thei thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Asinain an sin in mo neitu laksak ni a tiang leh thok, cuvai ni ah caw an ul leh thok. ");
INSERT INTO cfm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Hutu khaw nih hnipuan hlun cu puanthan thar thawn a dap kel lo. A dap asihle a thar nih a hlun cu a duk thok ih hnem hlehhlo in a pat thok. ");
INSERT INTO cfm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Cun hutukhaw nih sabit ti thar cu thawl hlun sungah an se kel lo. An siah asihle sabit ti thar nih thawl hlun cu a pak ter thok ih sabit ti le a thawl cu an siat colh thok. Sabit ti thar cu thawl thar ah siah sawn thok a i,” tiah a let hnei. ");
INSERT INTO cfm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabbath ni ah Jesuh cu sangvut lo lakin a feh; cule a dungthluntu pawl cu an feh pah ah sangvut vui pawl cu an zut. ");
INSERT INTO cfm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Cun Farasi pawl nih Jesuh sinah, “Zohhnik, Sabbath ni ah tuah lo dingah daan ih a khammi cu zangruangah na dungthluntu pawl nih an tuah?” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Cun Jesuh nih an sinah, “David nih a rualpi pawl thawn ei ding nei lo in le cawṭam ih an um lai ah zang a tuah tihmi nan siar kel lo maw? ");
INSERT INTO cfm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Puithiam lubik Abiathar sanah Pathian ih inn songah lut in, puithiam pawl kau ih ei ding tiah daan ih a sianmi sang cu David nih a ei ih a rualpi pawl khaw a pe hnei,” tiah a let hnei. ");
INSERT INTO cfm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cun Jesuh nih an sinah, “Sabbath cu minung hrangah tuahmi a i; minung hi Sabbath hrangah tuahmi a i lo. ");
INSERT INTO cfm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Curuangah Minung Fapa cu Sabbath tlun khawah bawi a i,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Cun Jesuh cu Sinakok ah a lut sal ih, cuva ah kutze pa pakhat a um. ");
INSERT INTO cfm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mi hrekkhat nih Jesuh cu sual an puh theinak dingah, Sabbath ni ah cupa cu a damter thok maw damter thok lo tiah ṭhangai in an zoh. ");
INSERT INTO cfm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesuh nih cuvai kutze pa cu, “Hang ding la, hmai ah va suak hnik,” tiah thu a pe. ");
INSERT INTO cfm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Cun Jesuh nih an sinah, “Daan nih Sabbath ni ah thil ṭha tuah maw, thil ṭha lo tuah hi a kham? Mi nunnak run maw, thah hi a kham?” tiah a sut hnei. Asinain an dai ṭhipṭhep. ");
INSERT INTO cfm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Cun Jesuh nih thinsia in a zoh hnei vivo ih an thinlung a ruh tuk ruangah a riah a se ngai. Cun cuvai kutze pa cu, “Na ban cu pharh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farasi pawl cu lengah an suak ih Herod ih milai pawl thawn Jesuh thah thei dan ding an relkhawm lohli. ");
INSERT INTO cfm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesuh cu a dungthluntu pawl thawn Galilee Tili ah an va feh; miburpi nih Jesuh cu an thlun. Anni cu Galilee peng, Judea peng, ");
INSERT INTO cfm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem khua, Idumea peng, Jordan tikua kiangkap, Tai-ar le Sidon khua kiangkap in a tiangmi pawl an i. Jesuh ih thil tuahmi pawl an theih ruangih a tiangmi pawl an i. ");
INSERT INTO cfm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Minung an tamtuk ih mipi pawl nih an pah lonak dingah lawng fate timlam sak cia dingin Jesuh nih a dungthluntu pawl cu a forh hnei. ");
INSERT INTO cfm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mifak tamngai a damter ruangah mifak pawl cu Jesuh tham ngah dingin an cuh fa deido. ");
INSERT INTO cfm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cun thlarau sia pawl nih Jesuh an hmuh cangcangin a hmai ah an bok ih, “Nang cu Pathian ih Fapa na si,” tiah an hek. ");
INSERT INTO cfm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Cun Jesuh nih ama cu hutu a si tih khi mi an sip lonak dingah cuvai thlarau sia pawl cu ralrinnak a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Cun Jesuh cu tlang cungah a kai ih a duh mi pawl a sinah a ko hnei; cule a sinah an tiang. ");
INSERT INTO cfm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Cun a sinih umtu dingah le thusimtu dingih a thlah hnei theinak dingah minung hleinih a hril. ");
INSERT INTO cfm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Cule khawsia pawl dawisuah theinak thuneihnak khaw a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cun minung hleinih a hril mi ih hmin pawl cu: Simon (Peter tiah hmin a sakmi), ");
INSERT INTO cfm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi ih fapa James le a naupa Johan (Jesuh nih Boanerges tiah hmin a sak hnei, Khawhri ih fale tinak a i), ");
INSERT INTO cfm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Philip, Bartholomeo, Matthai, Thomas, Alfias ih fapa James, Thaddaeus, Phunṭan Simon le, ");
INSERT INTO cfm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jesuh zuarthlaitu Judas Iskariot pawl an si. ");
INSERT INTO cfm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cun Jesuh cu inn ah a ṭin. Mipi cu a sinah an tiang sal sei ruangah Jesuh le a dungthluntu pawl cu caw hman an ei man lo. ");
INSERT INTO cfm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cuvai thu cu a sungkua pawl nih an fiah ih, mi nih “Jesuh cu a aa i,” tiah an tih ruangah, Jesuh kilkhawi dingah an feh. ");
INSERT INTO cfm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalem ih a tiangmi daanthiam pawl nih, “Hi pa hi Beelzebul ih luhhnawhmi a i. Khawsia uktu bawi ih thuneihnak thawn khawsia pawl a dawisuak,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Cun Jesuh nih a sinah a ko hnei ih tahṭhipnak hmangin thu a sim hnei, “Zangtin Seihtan nih Seihtan lala a dawisuak thei thok maw? ");
INSERT INTO cfm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ram pakhat cu ṭhenṭhek fa in ama le ma a dohfak ahcun, cuvai ram cu rei a ding thei thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Innsang pakhat cu ṭhenṭhek fa in ama le ma a dohfak ahcun, cuvai sungkua cu rei a ding thei thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cun Seihtan cu ama le ma do fa in a ṭhenṭhek fak a sih ahcun, rei a ding thei thok lo ih a siatral thok. ");
INSERT INTO cfm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Asinain thaṭha pa cu hri thawn an khih hmasak lo ahcun, hutukhaw nih a inn songah lut pit in a thil an laksak thei thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Thutak in nan ta sim, minung pawl ih sualnak hmahhmah le zangmang midang thangsiatnak an ṭonmi pawl cu ngaihthiam an i thok. ");
INSERT INTO cfm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Asinain hutukhaw Thlarau Thianghlim a thangsiattu cu ngaihthiam a i kel thok lo, zangahtihle kumkhua daih sualnak a tuah,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zangruangah tih le “Hi pa hi thlarau thianglo a sungah a um,” tiah an tih ruangah a si. ");
INSERT INTO cfm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Cun Jesuh ih nu le a unau pawl cu an tiang, inn lengah an ding ih, Jesuh kawhsak dingah mi an forh. ");
INSERT INTO cfm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesuh ih hramah minung tamngai an to ih an ni nih, “Zohhnik, na nu le, na naunu le, na naupa le pawl nih ta hrawl eng, inn leng ah an um,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesuh nih, “Ka nu le ka unau pawl cu hutu le an si?” tiah a sut hnei. ");
INSERT INTO cfm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A hramih totu pawl cu a zoh hnei ih, “Ka nu le ka unau pawl cu hiva ah an um. ");
INSERT INTO cfm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hutu khaw sisehla Pathian ih duhnak a tuahtu hmahhmah cu ka nu le ka unau pawl an si,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesuh cu Galilee Tili kap ah thuzirh a thok sal. A sinih a tiangtu minung an tam tuk ruangah, lawng sungah a lut ih a to. Mipi pawl cu tili kap leilung ah an um. ");
INSERT INTO cfm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cun tahṭhipnak pawl hmangin thu a zirh hnei ih, mipi pawl sinah: ");
INSERT INTO cfm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ṭhangai in ngai uh! Thlaici vorhtu cu thlaici vorh dingah a feh. ");
INSERT INTO cfm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Thlaici cu a vorh ih, a hrekkhat cu zalam tluan ah an ṭil ih vate pawl nih an ei. ");
INSERT INTO cfm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Thlaici hrekkhat cu lung tamnak hmun ah an ṭil ih leilung a sah lo ruangah thlaici cu an kho lohli. ");
INSERT INTO cfm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Asinain ni a hang suah tikah, ni nih a sat hnei ih an hram a thuk lo ruangah an rocar colh. ");
INSERT INTO cfm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Thlaici hrekkhat cu hling lakah an ṭil. Hling cu a hang ṭhang ih thlaikho cu a khuh colh ruangah an vui thei lo. ");
INSERT INTO cfm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Thlaici dang pawl cu leiram ṭhatnak ah an ṭil. An hang ṭhang ih a let sawmthum, a let sawmruk, a let zakhat tiangin an vui thei,” tiah a sim hnei. ");
INSERT INTO cfm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Cun an sinah, “Theihnak naa a neitu nih thei seh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesuh cu ama lawng a um laiah, a kiangkap um pawl le a dungthluntu hleinih pawl nih tahṭhipnak thu pawl an sut ");
INSERT INTO cfm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Cun Jesuh nih an sinah, “Pathian Uknak thuthup cu nan sinah pek a i cem, asinain a leng mi pawl hrangah cu tahṭhipnak thawn sip a i, ");
INSERT INTO cfm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","curuangah, “ ‘An zoh ngelngo thok naʼn an hmu thei thok lo, An naa nih a thei thok naʼn an fiahthiam thok lo; Zangahtihle Pathian sin an kir sal thok ih a ngaihthiam hnei pang thok,’ ” tiah a sim. ");
INSERT INTO cfm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cun Jesuh nih an sinah, “Hivai tahṭhipnak hi nan cingthiam lo maw? Aitih cun zangtin tahṭhipnak hmahhmah cu nan cingthiam thok? ");
INSERT INTO cfm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Thlaici vorhtu nih Pathian thu a vorh. ");
INSERT INTO cfm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mi hrekkhat cu zalam tluan ih a ṭilmi thlaici mang an i. Thu cu an thei, asinain Seihtan a tiang lohli ih an sungih tuhmi thu cu a laksak hnei. ");
INSERT INTO cfm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Cumangin a hrekkhat cu lung tamnak hmun ih a ṭilmi thlaici mang an i. Pathian thu an theih cangin lungawi ngai in an cohlang lohli. ");
INSERT INTO cfm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Asinain anma ah hrilhhram an neih lo ruangah reilote kau a daih. Cun Pathian thu ruangih harsatnak le hremnak a tian tikah Pathian an phatsan. ");
INSERT INTO cfm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mi hrekkhat cu hling lakih a ṭilmi thlaici mang an i. Pathian thu cu an thei, ");
INSERT INTO cfm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","asinain leitlun nunnak thu ih donharnak, let duhnak le thil dang duhnak pawl nih, Pathian thu cu a khuh ruangah an vui thei lo. ");
INSERT INTO cfm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Asinain mi hrekkhat cu leiram ṭhatnak ih a ṭilmi thlaici mang an i. Pathian thu cu an thei, an cohlang ih a let sawmthum, a let sawmruk, a let zakhat tiangin an vui thei,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Cun Jesuh nih an sinah, “Mei-inn cu kho tang le ihkhun tangah siah a i kel maw? Mei-inn vannak ah siah a i ko lo maw? ");
INSERT INTO cfm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Zangahtihle phorh lo dingih thuhmi le lang nolhsal lo dingmi thuthup zangkhaw a um lo. ");
INSERT INTO cfm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Theihnak naa a neitu nih thei seh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Cun Jesuh nih an sinah, “Nan theihmi thu hi ṭhaten ruat uh. Midang tahnak ih nan hmanmi mangin nan khaw tah nan i ve thok — cunakih tamsawn hman bet nan i thok. ");
INSERT INTO cfm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Zangahtihle a neitu cu pek bet a i thok ih, a nei lo tu cu a neihsun hman laksak a i thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Cun Jesuh nih, “Pathian Uknak cu, mi pakhat nih lo sungah thlaici a vorh ih, ");
INSERT INTO cfm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ama cu zan ah a it ih sun ah a tho, cuvai lai ah thlaici cu ama ten a kho ih a ṭhang; zangah aitin a ṭhang thiam tih khaw a fiah lo. ");
INSERT INTO cfm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A ma ten leilung nih a ṭhang ter ih a thei ter, hmasabik ah hnah no a cerh ter, cule a vui ter ih netabik ah a fang a um ter. ");
INSERT INTO cfm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Asinain a vui a cut tikah, cawlak can a cut i ruangah, a tacin thawn a la lohli tu mang a i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cun Jesuh nih, “Pathian Uknak cu zangtu thawn kan tahṭhim thok? Asihlole zangtu tahṭhipnak hmangin kan sim thok? ");
INSERT INTO cfm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lo sungih vorhmi ṭangṭap ci mang a i. Ṭangṭap ci cu leitlun ih thlaici hmahhmah lakih a fate bik a i. ");
INSERT INTO cfm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ṭangṭap ci cu vorh a ih tikah, a hang ṭhang ih thlaihnah dang hmahhmah nakin a hnem sawn. Tlangṭek hnem ngaingai a nei ih van ih vate pawl nih bu khaw an sa,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","An fiahthiam theinak dingah, Jesuh nih himang tahṭhipnak tamngai hmangin an sinah thu a sim. ");
INSERT INTO cfm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tahṭhipnak tello in an sinah thu a sim lo. Asinain anma lawng kau an um can ah, a dungthluntu pawl sinah zangtinkim a simfiang. ");
INSERT INTO cfm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cuvai ni simla a kim tikah, Jesuh nih a dungthluntu pawl sinah, “Tili khatla ralah feh u sing,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Cun mipi pawl cu an ramta; Jesuh cu lawng sungah a to cia ih an feh pit. Lawng dang pawl khaw cuva ah an um ve. ");
INSERT INTO cfm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Cun zil fak ngai in a zuang ciamco ih tisuar nih lawng cu a siatsuah ruangah lawng cu ti in a khat. ");
INSERT INTO cfm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesuh cu lawng mei laah a um ih tokheng tlun ah a ihhmul. Cun an ṭhang ih, “Sayapa, kan riaral colh thok hi poi na ti lo maw?” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesuh cu a hang tho ih zil cu a tai, cule tisuar sinah, “Dai i! Um zirziar!” tiah thu a pe. Cun zil cu a zuang i lo ih a dai ṭhipṭhep. ");
INSERT INTO cfm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesuh nih a dungthluntu pawl sinah, “Zangruangah aitluk lawmlam in nan ṭih? Zupnak nan nei rih lo maw?” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Cun an ṭih tuk lawmlam ih pakhat le pakhat, “Hi pa hi zangtumang minung zetzo a i si na, zil le tisuar hman nih a thu an ngai?” tiah an ti fa. ");
INSERT INTO cfm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cun Jesuh le a dungthluntu pawl cu Galilee tili khatla ral ih Gerasenes ram an va ban. ");
INSERT INTO cfm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cun Jesuh cu lawng sung in a ṭum ih, thlarau sia ih molhmi pa pakhat cu thlan sung in suak pit in Jesuh sinah a tiang lohli. ");
INSERT INTO cfm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Cuvai pa cu thlan lakih ummi a i. Hutu khaw nih thirhri hman in an khih thei lomi pa a si. ");
INSERT INTO cfm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ke khihnak hri le thirhri pawl thawn hma tamngai an khit na in cuvai hri pawl cu a catter hnei colh ih hutu khaw cuvai pa neh thei dingin an tha a ṭha lo. ");
INSERT INTO cfm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sun zan in thlan lak le tlang lakah a hek ih ama le ma khaw lung thawn a at fa. ");
INSERT INTO cfm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cun lam hla in Jesuh a hei hmuh tikah, a va zuang ih Jesuh ih hmai ah cun a khuk a bil. ");
INSERT INTO cfm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Cun a aw neih patawp in a hek ih, “Cungnungbik Pathian ih Fapa, Jesuh! Nang le kei cu zangtu kan pehtlai fa? Pathian hmin in ta ka dil, ka hrem hram hlah!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Zangahtihle Jesuh nih a sinah, “Nang thlarau sia, hi pa ih sung in suak!” tiah a tih takdah ruangah a si.) ");
INSERT INTO cfm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Cun Jesuh nih, “Na hmin hu a si?” tiah a sut. Cuvai pa nih, “Ka hmin cu ‘Burpi’ a si — zangahtihle kan tam setak!” tiah a sawn. ");
INSERT INTO cfm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Cun cuvai pa nih thlarau thianglo pawl cuvai ram in dawi hnei colh lo dingah Jesuh cu thungai thlak in a dil. ");
INSERT INTO cfm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Culaifangah cuvai kiangkap tlanghmual hrial ah vok rual tampi an tlang deido. ");
INSERT INTO cfm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Cun thlarau thianglo pawl nih Jesuh sinah, “Vok rual sinah kan hei thlah, an sungah kan lut ter,” tiah an hler. ");
INSERT INTO cfm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","An hlerh mangin Jesuh nih a sian hnei. Thlarau thianglo pawl cu cuvai pa ih sungin an suak ih vok rual sungah an lut. Cun vok rual pawl — an zatein 2,000 hrawng — cu kak lakah an dawp ih tili sungah ṭil pit in an thi. ");
INSERT INTO cfm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vok kiltu pawl cu an va zuang ih, cuvai thuhla cu khawpi sung le ram sungah an than ciamco. Cun mipi pawl cu thil cangmi zoh dingah an va feh. ");
INSERT INTO cfm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mipi pawl cu Jesuh sin an va tiang. Thlarau sia “Burpi” ih molhmi pa cu hnipuan a hru ih a lungfim te in an va hmu, cule an ṭih. ");
INSERT INTO cfm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Thlarau sia ih molhmi pa tlun ih thil cangmi le vok rual tlun ih thil cangmi a hmutu pawl nih cuvai thu cu mi an sim. ");
INSERT INTO cfm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Cun mipi pawl nih Jesuh cu an ram in suak dingah an hler. ");
INSERT INTO cfm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cule Jesuh cu lawng sungih a luh tikah, thlarau sia ih luhhnawh dah mi pa nih a sinah um dingin a hler. ");
INSERT INTO cfm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Asinain Jesuh nih a sian lo ih a sinah, “Inn ah va ṭin pit in na sungkua pawl sinah, Bawipa nih na hrangah zangtluk thil maksak a tuah tihle zangtluk in na tlun ah thinfahnak a nei tih khi va sim hnei sawn,” tiah a forh. ");
INSERT INTO cfm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Cun cuvai pa cu a va feh ih Jesuh nih a hrangih a tuahsak mi thuhla cu Dekhapolis ram sungah a sim. Cun mi hmahhmah an mang a bang. ");
INSERT INTO cfm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cun Jesuh cu tili khatla ral ah lawng thawn a feh sal. Jesuh ih hram ah minung tamngai an hmuakkhawm fa, cule Jesuh cu tili kam ah a si. ");
INSERT INTO cfm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cun sinakok uktu pawl lakih pakhat, a hmin ah Jairas tihmi pa a tiangih Jesuh a hmuh tikah a ke hram ah a bok ih, ");
INSERT INTO cfm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","thungai thlakin thinfak a dil, “Ka fanu te a thi i ngaingai thok. A dam ih a nun theinak dingah kan sinah tiangin ka fanu ih tlun ah na kut suang hram,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Cun Jesuh cu cuvai pa thawn an feh. Mipi tamngai nih an thlun ih Jesuh cu an pah pah deido. ");
INSERT INTO cfm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cuvai hmun ah kum hleinih sung thi-dok fahnak ih a faktu numi pakhat a um. ");
INSERT INTO cfm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A neihmi hmahhmah ne kau in sibawi tamngai sinah a tuamhlawm fa cem naʼn dam hoi loʼn a bese deuhdeuh. ");
INSERT INTO cfm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cuvai nu cu Jesuh ih thuhla a thei ih mipi pawl lakin Jesuh cu a dung laʼn a thlun, cule Jesuh ih puan cu a tham. ");
INSERT INTO cfm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Zangahtihle, “A puan tal ka tham ngah ahcun ka dam kau thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hmakhatte ah a thi dokmi cu a dam ih a fahnak in damter a i cem tih khaw a taksa nih a fiah. ");
INSERT INTO cfm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesuh cu a sung in a huham a suak tih a fiahfa lohli, cule mipi la ah a herfa ih, “Hutu nih ka puan nan tham?” tiah a sut hnei. ");
INSERT INTO cfm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Cun a dungthluntu pawl nih a sinah, “Mipi pawl nih ta pah eng deido cu na hmu kau, zangtin ‘Hutu nih ka puan nan tham?’ na ti thiam,” tiah an let. ");
INSERT INTO cfm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A puan thamtu fiah duh ah kiangkap pawl cu a zoh. ");
INSERT INTO cfm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Asinain numi nu cu, a cung ih thil cangmi cu a fiah ih, ṭih le ṭhia pah in Jesuh ih ke hram ah a bok. Cule Jesuh sinah thudik zaten a sim colh. ");
INSERT INTO cfm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Cun Jesuh nih a sinah, “Ka fanu, na zupnak nih ta damter cem, hnangamten va feh la na fahnak in dam dah hram law,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesuh cu a ṭon ngelngo lai ah, sinakok uktu pa ih inn in mi an tiang ih, “Na fanu cu a thi cem. Zangruangah Sayapa cu na hnaihnok rih ngelngo?” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Asinain Jesuh nih an ṭonmi cu zanghrel lo in sinakok uktu pa sinah, “Ṭih vai hlah, zum kau lai ci,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesuh nih Peter, James, le James ih naupa Johan hrello hutukhaw a dung thlun a sian hnei lo. ");
INSERT INTO cfm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sinakok uktu pa ih inn an va bat tikah, mipi pawl ṭap le aihram in an buai deido cu a va hmu hnei. ");
INSERT INTO cfm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Cun inn songah a lut ih an sinah, “Zangruangah ṭap le aihram in nan buai deido? Hi nappang nute hi a thi lo pi — a ihhmul mi a i!” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Cun mipi pawl nih Jesuh cu an hnihsan. Cun Jesuh nih an zaten lengah a suak ter hnei colh. Nappang nu ih nu le pa le a ṭhit tak hneimi pawl thawn nappang nu ih umnak ah cun an lut. ");
INSERT INTO cfm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Cun a kut in nappang nu cu a tlai ih, “Talitha, koum!” tiah a ti. A sullam cu “Nute, hang tho ta ti!” tinak a i. ");
INSERT INTO cfm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hmakhatte ah nappang nu a hang tho lohli ih a feh. (Zangahtihle cuvai nu cu kum hleinih mi a i.) Cucu an mang a bang taktak. ");
INSERT INTO cfm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Cun Jesuh nih hi thu hi hukhaw fiah ter lo dingin khoh ngaiin thu a pe hnei ih cuvai nu ih ei dingah thil pakhat khat pek a forh hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesuh cu cuvai hmun in a suahnak khua ah a feh ih a dungthluntu pawl nih an thlun. ");
INSERT INTO cfm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabbath ni ah sinakok ah thu zirh a thok. A thuzirhmi a theitu mi tampi cu an mang a bang ngai ih, “Hivai pa nih hi thil pawl hi khoituʼn a ngah? A sinih pekmi hivai fitnak hi zangtu fitnak a i? Zangtin himang mangbangza hi teh a kut in a tuah thiam? ");
INSERT INTO cfm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ani cu Mary ih fapa, James, Joses, Judas le Simon le pawl ih upa, lettama pa khi a si lo maw? A naunu le khaw hiva kan sinah an um ve i lo maw?” tiah an ti. Cun an ni le nih Jesuh cu an hnong. ");
INSERT INTO cfm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Cun Jesuh nih an sinah, “Profet cu ama ih khua le ram, a sungkhat pawl le a sungkua hrello hmun dang ah cu an upat,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Cun cuvai hmun ah cun mifak temte tlunah a kut a suang ih a damter; cuvai hrello mangbangza zangkhaw a tuah lo. ");
INSERT INTO cfm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Cun an zuplonak ruangah Jesuh cu a mangbang. Cun a kaingkap khua pawl ah a feh ih thu a zirh. ");
INSERT INTO cfm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Cule minung hleinih cu a ko hnei ih pa nih panih in a thlah hnei. Cun thlarau sia pawl tlunih thuneih theinak a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Cule an sinah, “Nan khualtlotnak ah fiangṭhulh hrello zangkhaw keng hlah uh — caw i seh, khualtlotnak zal i seh, paisa bawm sungah paisa i seh, keng hlah uh. ");
INSERT INTO cfm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kedap cu hru uh, asinain angki hlei keng hlah uh,” tiah thu a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Cun an sinah, “Inn sung nan luh cangcang in, nan feh sal hlan lo cuvai inn ah nan cam thok. ");
INSERT INTO cfm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Cun riah-inn nan ta cohlang lo ih nan thu nan ta ngai lo tu khua cu, an khua nan suah tak tikah, anma dokalhnak fiahpittu ah, nan ke ih leivut cu thingta uh,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Curuangah an feh ih sirfaknak ding thu an phuang. ");
INSERT INTO cfm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Khawsia tamngai an dawi suak ih mifak tamngai khaw hriak an culh ih an damter. ");
INSERT INTO cfm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesuh ih hmin a than tuk ruangah Siangpahrang Herod nih Jesuh ih thuhla cu a thei ve. Mi hrekkhat nih, “Baptisma petu Johan cu thihnak in a thosal. Curuangah hi mangbangza thil pawl tuahtheinak huham cu Jesuh sinah ṭuan a ṭuan i thok,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mi dang pawl nih, “Elijah a si,” tiah an ti. Asinain mi dang pawl sei nih, “Profet a i, a sih lole profet pawl lakih pakhat khat mang a i,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Asinain Herod nih cuvai thu a theih ve tikah, “A hngawng ka ṭhawh termi Johan a si kau, thihnak in a thosal si lai tu!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Zangahtihle Herod ama rori nih a naupa Filip ih nupi Herodias ruangah mi a thlah ih Johan cu a tlai ter hnei, cule hri thawn khit pit in thawng thla dingin thu a pek dahmi a i. Zangruangah tih le Herod nih a nau pa Filip ih nupi Herodias cu nupi ah a ṭhit ruangah a i. ");
INSERT INTO cfm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Zangahtihle Johan nih Herod sinah, “Na naupa ih nupi na ṭhit cu daan nih a duh lo,” tiah a tih tak dah ruangah a i. ");
INSERT INTO cfm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Curuangah Herodias nih Johan cu a mit a kem ih thah a duh; Asinain a that thei lo. ");
INSERT INTO cfm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Zangruangah tih le Johan cu mi dingfel le mi thianghlim a i tih Herod nih a fiah ruangah a ṭih ih a hum. Herod nih Johan ih thu a theih tikah, thin buai ngai in a um, cule a thusipmi cu lungawi ngai in ngai a duh thotho. ");
INSERT INTO cfm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Cun Herod nih a suahni lopnak ah bawi upa pawl, ralbawi pawl le Galilee peng ih upa pawl hrangah zanriah ei khatnak puai a tuah ih, Herodias cu tikcu remcang a ngah. ");
INSERT INTO cfm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias ih fanu cu a rong lut ih a lam, Herod le a mikhual pawl cu an lung a awi ngai. Cun Siangpahrang pa nih numi nute sinah cun, “Na duhmi hmahhmah cu ka hler la ta pe thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cun cuvai nute sinah, “Ka na hlerhmi poh cu ta ka pe thok, ka ram a hrek tiang khaw ta pe thok!” tiah siatti dingin thu a kam. ");
INSERT INTO cfm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Cun cuvai nute cu a feh ih a nu sinah, “Zangtu ka hler thok?” tiah a sut. Cun a nu nih, “Baptisma petu Johan ih lu,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cun cuvai nu cu zamrang ngai in siangpahrang pa sinah a feh lohli ih, “Baptisma petu Johan ih lu cu kheng thawn in ka pe lohli la ka duh,” tiah a hler. ");
INSERT INTO cfm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cun siangpahrang pa cu a riah a se ngai, asinain siatti dingin thu a kam cem ruangah le a mikhual pawl ruangah cuvai nu ih hlerhmi cu a el thei lo. ");
INSERT INTO cfm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Siangpahrang pa nih mithattu a thlah lohli ih Johan ih lu la dingin thu a pe. Cuvai pa cu thawnginn songah a va feh ih Johan ih lu cu a va tan. ");
INSERT INTO cfm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Cun Johan ih lu cu kheng thawn a keng ta ih numi nute cu a pe. Cule numi nute nih a nu sinah a pe. ");
INSERT INTO cfm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cuvai thu cu Johan ih dungthluntu pawl nih an fiah tikah, an feh ih a ruak cu an la, cule thlan ah an phum. ");
INSERT INTO cfm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Cun a forhthlah pawl cu Jesuh sinah an hmuakkhawm fa ih an tuahmi hmahhmah le an zirhmi hmahhmah cu a zaten an sim. ");
INSERT INTO cfm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cun ani nih an sinah, “Ram ṭhing ah nanma thawn hlang kan feh thok ih kan va cawlhnga thok,” tiah a ti hnei. Zangahtihle mi lut suak an tamtuk ruangah caw ei can rori hman an nei lo. ");
INSERT INTO cfm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Cun ram ṭhing la ah anma hlang lawng thawn an feh. ");
INSERT INTO cfm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mipi pawl nih an pawh lai cu an hmu ih hutu le an si tih an fiah tikah khua cangcang in ke thawn an zuang. Cule Jesuh le a dungthluntu pawl ih bat hlan ah an ban. ");
INSERT INTO cfm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesuh cu lawng sungin a suah tikah, miburpi cu a hmu hnei, cule khaltu nei lo tuu mang an ih ruangah a thinfak hnei. Cule thu tamngai a zirh hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cun ni a sim i tikah, a dungthluntu pawl cu Jesuh sinah an feh ih, “Hi hmun hi ram ṭhing a i, ni le a sim ngai i cem. ");
INSERT INTO cfm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mipi pawl hi, kiangkap ih lo le khua pawl ah thlah hnei la, ei ding thil zangtumaw tal leih fa seu,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Asinain Jesuh nih, “Ei ding cu nan nih pe uh,” tiah a sawn hnei. Cun an ni nih, “Ngun tangka 200 man in caw lei pit in mipi pawl hi kan pe thok maw?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Cule ani nih an sinah, “Sang hlawm khawzat nan nei? Feh uhla zoh uh,” tiah a ti hnei. Cun an va zoh ih, “Sang hlawm nga le nga panih,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Cule a dungthluntu pawl sinah, mipi pawl cu ta hring tlun ah a bur a bur in to ter dingah, thu a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Curuangah mipi pawl cu zakhat bur, sawmnga bur tin an to. ");
INSERT INTO cfm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Cun sang hlawm nga le nga panih cu a la ih, van la zoh in lungawithu a sim. Cule sang cu a seu ih mipi pawl zem dingah a dungthluntu pawl sinah a pe. Cun nga panih khaw cu an zate sinah a zem. ");
INSERT INTO cfm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Cule an zaten an ei ih an khop ngai. ");
INSERT INTO cfm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","An hlahmi nga le sang nepnawi pawl cu a dungthluntu pawl nih an sar ih khoto hleinih a khat in an sar. ");
INSERT INTO cfm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cuvai sang eitu pawl cu pami hlang ah 5,000 an i. ");
INSERT INTO cfm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesuh nih mipi pawl a tlun ter hnei laiah, tili ral ih Bethsaida khua ah feh khan dingin a dungthluntu pawl cu hmakhatte ah lawng sungah a lut ter hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cun Jesuh cu mipi pawl tlun hnukah, thla cam dingin tlang tlunah a kai. ");
INSERT INTO cfm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cun ni a sim i tikah, lawng cu tili laifang ah a um ih Jesuh cu tili kam ah ama kau a um. ");
INSERT INTO cfm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Zil cu anma la ah a zuan ruangah, a dungthluntu pawl cu harsa ngaiin lawng an to cu a hmu hnei. Curuangah zingmaw khawvang hlan hrawngah tili tlunin an sinah a feh. An sin a tian tikah lattak hnei a tum. ");
INSERT INTO cfm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cun ti tlunih a feh cu an hmuh tikah, muthla ah an tih ih an hek ciamco. ");
INSERT INTO cfm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Zangahtihle an zaten an hmu ih an ṭih tuk. Asinain hmakhatte ah Jesuh nih an sinah, “Thinphang hlah uh, kei ka si, ṭih hlah uh,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Cun a dungthluntu pawl sin lawng sungah a lut ih zil cu a dai. Cun dungthluntu pawl cu an mang a bang ngai. ");
INSERT INTO cfm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Zangahtihle an lung a ruh tuk ruangah mi 5,000 caw a darmi ih a tih duhsatnak khaw an fiahthiam lo. ");
INSERT INTO cfm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cun tili an tan ngah tikah Gennesaret ah an ban, cule an lawng cu tikap ah an khit. ");
INSERT INTO cfm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lawng sung in an ṭum tikah, mipi pawl nih Jesuh cu an fiah thiam lohli. ");
INSERT INTO cfm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Cun cuvai ram kiangkap pawl hmahhmah ah an zuang ih, Jesuh a um tih an fiahnak hmun cangcang ah mifak pawl cu an ihnak tangthah thawn an tian pit. ");
INSERT INTO cfm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Cun Jesuh ih fehnak hmun khawte cang ah iseh, khawpi cang le lo tiangah khaw iseh, mifak pawl cu dawr hmun ah an tian pit. Jesuh ih hnipuan zimte tal tham ter dingah an hler. Cule a tham ngahtu hmahhmah cu an dam. ");
INSERT INTO cfm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Cun Jerusalem in a tiangmi Farasi pawl le daanthiam hrekkhat pawl cu Jesuh ih hram ah an hmuakkhawmfa. ");
INSERT INTO cfm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cule Jesuh ih dungthluntu hrekkhat pawl cu an kut hnawm pi in caw an ei khi an hmu — cucu an kut an ṭawlfa lo, tinak a i. ( ");
INSERT INTO cfm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Zangahtihle Farasi pawl le Judah mi hmahhmah nih, an pupa pawl ih dun le daan khoh ngai in an thlun ruangah, kut ṭawlfa loʼn caw an ei lo. ");
INSERT INTO cfm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cun dawr in an tlun tik khawah kholhfa hmasak loʼn zangkhaw an ei lo. Cule an pupa pawl ih dun le daan pawl: khuat ṭawl dan, khukheng ṭawl dan le ihkhun pawl thianfaih dan tivek pawl khaw an thlun.) ");
INSERT INTO cfm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Cun Farasi pawl le daanthiam pawl nih Jesuh cu, “Zangruangah na dungthluntu pawl hi kan pupa pawl ih dun le daan thlun loʼn, kut hnawm pi thawn caw an ei?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Cun Jesuh nih an sinah, “Profet Isaiah nih, nan mitifater pawl ih thuhla a sip mi cu a dik taktak. Hitin a ngan: “ ‘Hi minung pawl nih an hmurka kau in ka na upat, Asinain an thinlung cun ka na hlat. ");
INSERT INTO cfm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kei ka na biaknak cu a lakmen a i, minung ih daan pawl cu Pathian ih thurin mangin an zirh.’ ");
INSERT INTO cfm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Pathian ih thupek cu nan ram ih minung ih dun le daan sawn nan thlun.” ");
INSERT INTO cfm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cun Jesuh nih an sinah, “Nan zirhsinmi dun le daan hngetkhoh dingah Pathian ih thupek sawn cu nan hnong. ");
INSERT INTO cfm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Zangahtihle Moses nih, ‘Nan nu le nan pa cu upat uh,’ cule, ‘A nu le pa ṭonsia ih a be tu cu thah tengteng thok a i,’ tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Asinain nan nih cu, ‘Mi pakhat khat nih a nu le a pa hrangah thil ṭha pakhat khat nei na kau in “Korban a tih” a sih ahcun (Korban tihmi cu Pathian sinih pekhlanmi tinak a i), ");
INSERT INTO cfm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","cuvai pa cu a nu le pa zohkhentu sihnak in a luat,’ tiah nan ti. ");
INSERT INTO cfm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nan zirhsinmi nan dun le daan hmangin, Pathian ih thu cu zanghmanlo ah nan tuah. Cule cuvai mang thil tamngai khaw nan tuah,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cun Jesuh nih mipi pawl cu a ko hnei sal ih an sinah, “Nan zaten ka ngai uhla cing uh. ");
INSERT INTO cfm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lengla in sungla ih a lutmi thil pawl nih minung hi a hnawmter lo; Asinain sungla in a suakmi thil pawl nih a hnawmter sawn,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesuh cu mipi pawl ramta hnei pit in inn song a luh tikah, a dungthluntu pawl nih cuvai tahṭhipnak thu cu an sut. ");
INSERT INTO cfm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesuh nih an sinah, “Zangtin nan khaw nan cing ve cuang lo maw? Lengla in a lut mi zangtu thil khaw nih minung a hnawmter lo, ");
INSERT INTO cfm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","zangahtihle cuvai thil cu a thinlung sungah a lut lo ih, a pumpi sungah a lut sawn. Cule ekinn ah a suak colh sal, tih nan fiah lo maw?” tiah a ti hnei. (Aitin a tihnak cu caw hmahhmah hi ei thiang a i, tiah a tih duhnak a i.) ");
INSERT INTO cfm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cun Jesuh nih, “Minung sungih a suakmi thil nih minung a hnawmter. ");
INSERT INTO cfm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Zangahtihle minung sungla ih a suakmi ruahnak ṭha lo, nupa sual tuahnak, lolak hlah, lainawng, ");
INSERT INTO cfm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ṭangṭawm sualnak, duhhamnak, sualralnak, mideu, taksa hiarnak, nahsuah iksiknak, midang thangsiatnak, puarthaunak, atthlakza thil tuahnak — ");
INSERT INTO cfm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","aivai thil ṭha lo hmahhmah cu minung sungin a suak ih, minung a hnawmter,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Cun Jesuh cu cuvai hmun in a pok ih, Tai-ar khuapi hram la ah a feh. Cule inn pakhat sungah a lut ih hutukhaw ih an fiah ding a duh lo, asinain a thupfa thei cuang lo. ");
INSERT INTO cfm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Zangahtihle a fanu khawsia ih luhhnawh mi ih nu, nucang pakhat nih Jesuh a um tih a fiah ih a sinah a feh, cule hmakhatte ah a ke hram ah a bok. ");
INSERT INTO cfm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nucang nu cu Zentail mi Fonisia rammi a i. Cuvai nu nih a fanu sungih khawsia dawisuak dingah Jesuh cu a hler. ");
INSERT INTO cfm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesuh nih a sinah, “Fale nih khop ngai in ei hmasak seu. Zangahtihle fale ih caw laksak pit in uico pek cu a ṭha thok lo,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Asinain cuvai nucang nu nih, “A i hrim, Bawipa, fale ih caw tlawktlau cu cabuai tangih uico pawl nih ei ve kau hmah uh ee,” tiah a sawn. ");
INSERT INTO cfm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Cun Jesuh nih cuvai nu sinah, “Hivai na ṭonkam ruangah, na feh thei i, na fanu sung in khawsia cu a suak cem,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cun cuvai nu cu inn a bat tikah, a fanu cu ihkhun tlunah it in a hmu. Khawsia cu a suak cem taktak. ");
INSERT INTO cfm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Cun Jesuh cu Tai-ar peng a ramta ih Sidon peng pal pah pit in Dekhapolis ram Galilee Tili ah a feh. ");
INSERT INTO cfm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Cun naset le fiangngai ih ṭonthiamlo pa pakhat cu Jesuh sinah an tianpit. Cule cuvai pa ih tlunah a kut suang dingin Jesuh cu an hler. ");
INSERT INTO cfm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Cun Jesuh nih cuvai pa cu mipi pawl lak in hmun dang deuh ah a ṭhita ih, cuvai pa ih naa sungah a zung in a von tok, a cihrit a kha, cule a lei a tham sak. ");
INSERT INTO cfm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Cun van la zoh in a thawpi a suah ih, “Ephphatha!” tiah a ti. A sullam cu, “Hong fa seh!” tihnak a i. ");
INSERT INTO cfm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cun cuvai pa ih naa cu a theng ih a lei talh dawntu cu a poih, cule fiangngai in a ṭon suak thei. ");
INSERT INTO cfm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Cun Jesuh nih mipi pawl cu hukhaw sim lo dingin thu a pe. Asinain a kham hnei tam deuhdeuh le tam sinsin in an sim. ");
INSERT INTO cfm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Cun mipi pawl cu an khuaruah a har ngai ih, “Thil zangkim hi ṭha tuk in a tuah. Naset pawl cu an naa a theng ter ih ṭonthiamlo pawl khaw a ṭon ter,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Cuvai can ah, minung tamngai cu an hmuakkhawm fa seisei ih ei ding zangkhaw an neih lo tikah, Jesuh nih a dungthluntu pawl cu a ko hnei ih an sinah, ");
INSERT INTO cfm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mipi pawl hi ka thinfak hnei tuk, zangahtihle ka sinah an umnak ni thum lai a rei i cem ih ei ding zangkhaw an nei lo. ");
INSERT INTO cfm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Zangkhaw ei lo in ka tlun ter hnei asihle, lam lakah an caw ṭam in an ba colh thok. Zangahtihle mi hrekkhat cu lam hlapi in a tiangmi an i,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Cun a dungthluntu pawl nih, “Aimang ramṭhing lakah hutu nih minung hi zat hrangah caw a hrawl thei thok?” tiah an sawn. ");
INSERT INTO cfm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesuh nih an sinah, “Sang hlawm khawzat nan nei?” tiah a sut hnei. Cule an ni nih, “Hlawm sarih,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cun Jesuh nih mipi pawl cu leilung ah to dingin thu a pe hnei. Cule sang hlawm sarih cu a la ih lungawithu a sip hnukah, a seu ih mipi pawl zem dingah a dungthluntu pawl sinah a pe. Cule an ni nih mipi pawl cu an zem. ");
INSERT INTO cfm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nga fate te khaw temte an nei. Lungawithu a sip hnukah mipi pawl zem thotho dingin thu a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Cun mipi pawl cu an ei ih an khop ngai. Cule an hlahmi nepnawi pawl cu an sar sal ih kho sarih khat an sar. ");
INSERT INTO cfm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cun a eitu mipi pawl cu 4,000 hrawng an i. Jesuh cu mipi pawl a tlunter hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cule hmakhatte ah a dungthluntu pawl thawn lawng sung ah an lut ih Dalmanutha peng ah an feh. ");
INSERT INTO cfm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Cun Farasi pawl cu an tiang ih Jesuh thawn thu-el fak an thok. Jesuh hneksaknak dingah, vancung ihsin hmuhsaknak tuah an hler. ");
INSERT INTO cfm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Asinain Jesuh cu a thawpi a suah ih, “Zangruangah tun san minung pawl hi hmuhsaknak nan hrawl? Thutak in nan ta sim, tun san minung pawl sinah zangtu hmuhsaknak khaw pek an i thok lo,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cule Jesuh cu a feh ta hnei ih lawng sungah a lut. Cun tili khatla ralah a feh. ");
INSERT INTO cfm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Cun dungthluntu pawl nih sang kentak an hmulh ih lawng sungah cun sang hlawm khat kau an nei. ");
INSERT INTO cfm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Cule Jesuh nih an sinah, “Farasi pawl ih colh le Herod ih colh hi ralring lau cih,” tiah a cah hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Cule “sang kan neih lo ruangah aitin kan na ti si na pan,” tiah pakhat le pakhat an ti fa. ");
INSERT INTO cfm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesuh nih an ṭonmi a thei hnei ih, an sinah, “Sang nan neih lo thu cu zangah nan rel ngelngo? Nan cing thiam lo maw, nan fiahfiang lo? Nan lung a ruh rih maw? ");
INSERT INTO cfm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mit nei hmah pit in — nan hmu lo maw? Naa nei hmah pit in — nan thei lo maw? ");
INSERT INTO cfm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Minung 5,000 hrang ah sang hlawm nga ka seu lai ah khin an hlahmi a nepnawi kho khawzat nan sar? tih khi nan cing i lo maw?” tiah a sut hnei. Anni nih a sinah, “Kho hleinih,” tiah an let. ");
INSERT INTO cfm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Cun Jesuh nih an sinah, “minung 4,000 hrang ah sang hlawm sarih ka seu lai ah khi an hlahmi a nepnawi kho khawzat nan sar?” tiah a sut hnei. Cule an ni nih a sinah, “Kho sarih,” tiah an let. ");
INSERT INTO cfm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Cule Jesuh nih an sinah, “Cucu nan fiahthiam rih cuang lo maw?” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Cun Bethsaida khua an ban. Mitkhang pa pakhat cu a sinah an tianpit ih tham dingah Jesuh cu an hler. ");
INSERT INTO cfm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Cun Jesuh nih mitkhang pa cu a kut in a tlai ih khaw lengah a ṭhi ta. Cule a mit ah cihrit a khak ih a tlunah a kut a suang. Cun Jesuh nih a sinah, “Zangtu tal hmu thiam cim?” tiah a sut. ");
INSERT INTO cfm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mitkhang pa cu tlun la a zoh ih, “Minung pawl ka hmu thei, asinain thingkuang feh deido mang an i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Cun Jesuh nih a mit cu a tham sak sal ih a mit cu a hrak. A mit cu a damsal ih zang hmahhmah fiangten a hmu thei. ");
INSERT INTO cfm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Cule Jesuh nih, “Khaw sungah lut vai hlah,” tiah thu a pe ih inn ah a tlung ter. ");
INSERT INTO cfm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cun Jesuh le a dungthluntu pawl cu Sisaria Filipi ih khawte pawl ah an feh. Jesuh nih lampi lakah a dungthluntu pawl cu, “Mi nih kei hi hutu tiah ka na ti?” tiah a sut hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A dungthluntu pawl nih a sinah, “Baptisma petu Johan a si, ta ti. Asinain mi hrekkhat nih Elijah a si, ta ti. Mi hrekkhat nih profet pakhat khat a si, tiah ta ti eng,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Cule Jesuh nih an sinah, “Asihle nan teh kei hi hutu tiah ka na ti?” tiah a sut hnei. Peter nih a sinah, “Nang cu Khrih na si,” tiah a sawn. ");
INSERT INTO cfm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Cule Jesuh nih a thuhla cu hutukhaw sim lo dingah khoh ngaiin ralrinnak a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cun Jesuh nih a dungthluntu pawl thuzirh a thok. Minung fapa cu harnak tamngai a tuar thok ih upa pawl, puithiam upa pawl le daanthiam pawl nih an hnong thok. Cule an that thok ih ni thum hnukah a thosal thok, tiah a zirh hnei. ");
INSERT INTO cfm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cun cuvai thu cu an sinah langhngan ngaiin a sim hnei. Cule Peter nih Jesuh cu hmun dang deuhah a ṭhita ih a mawhthluk. ");
INSERT INTO cfm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Asinain Jesuh cu a her fa ih a dungthluntu pawl zoh hnei pah in Peter cu a tai, “Seihtan, ka dung la ah feh! Zangahtihle Pathian thil ruat loʼn minung thil sawn na ruat,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cun Jesuh nih mipi pawl le a dungthluntu pawl cu a ko hnei ih, an sinah, “Hutu khaw ka dung ka na thlun duhtu cu ama le ma hnong fa seh, cule a thinglamtah phur in ka dung ka thlun seh. ");
INSERT INTO cfm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Zangahtihle hutu poh khaw ama ih nunnak a rung duhtu cu a nunnak a hlo thok, asinain hutu poh khaw keimai hrang le thuthang ṭha ruangih a nunnak a hlotu cu a nunnak a run ngah thok. ");
INSERT INTO cfm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Zangahtihle mi pakhat nih leilung pumpi hi co in ama ih nunnak hlo hnik sehla, a hrangah zangtu hlawknak a um? ");
INSERT INTO cfm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A nunnak cu zangtu thawn in a lei thei sal thok? ");
INSERT INTO cfm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hutu khaw sualnak le rinumlonak ih a khatmi hivai san ah, kei le ka thu a zahpittu cu minung fapa nih a Pa ih sunlawinak le a thianghlim vancungmi pawl thawn an tian leh tikah a zahpit hnei ve thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Cun Jesuh nih an sinah, “Thutak in nan ta sim, hivai hmun ih a dingmi mi hrekkhat hi, Pathian ih Uknak cu huham thawn a tian an hmuh hlan lo, thihnak tep lo dingmi an um,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cun ni ruk hnukah, Jesuh nih Peter, James le Johan pawl cu tlang tlunah anma lawng a kai pit hnei. Cule Jesuh cu an hmai ah a muihmel a thleng fa. ");
INSERT INTO cfm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A hnipuan cu a tleu ih a var setak — leitlun ih thil sawptu hutu mang khaw nih cutluk var in an tuah thei thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Cun an sinah Elijah cu Moses thawn an rong lang ih Jesuh thawn an be fa berbo. ");
INSERT INTO cfm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Cule Peter nih Jesuh sinah, “Rabbi, aiva ih kan um hi a ṭha tuk. Thlam pathum in sa u sing, na hrangah pakhat, Moses hrangah pakhat, cule Elijah hrangah pakhat,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Zangruangah tihle an ṭih tuk ih ṭon ding dang a fiah lo ruangah a si. ");
INSERT INTO cfm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Cun khawdur nih a ron khuh hnei ih khawdur sung in aw pakhat nih, “Hihi ka duhdawt ngaimi ka Fapa a si — a thu ngai uh!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Cucangin dungthlutu pathum pawl cu an kiangkap an zoh lohli ih hutukhaw an hmu lo; Jesuh kau an hram ih a um cu an hmu. ");
INSERT INTO cfm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tlang tlun in an rong ṭum laiah, “Minung Fapa thihnak ihsin a thawhsal hlan lo cu, an hmuh mi thilpawl hutukhaw sim lo dingah,” Jesuh nih thu a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cuvai a thupekmi cu an thlun ih, “ ‘thihnak in thawhsal,’ tihmi cu zangtu khi i la na?” tiah pakhat le pakhat an sut fa. ");
INSERT INTO cfm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Cule Jesuh sinah, “Zangruangah daanthiam pawl nih Elijah a tiang hmasak thok an ti?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Cun Jesuh nih an sinah, “Elijah cu a tiang hmasa taktak thok ih zang hmahhmah a remṭhasal colh thok. Zangruangah Ca Thianghlim sungah, Minung Fapa cu harnak tamngai a tuar thok ih hnon a i thok, tiah ngan a i? ");
INSERT INTO cfm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Thutak in nan ta sim, Elijah cu a tiang taktak cem, cule a thuhla an ngancia mangin, an duhduh in a tlunah an tuah,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cun dungthluntu dang pawl sin an tian tikah, mipi tamngai nih an kulh ih daanthiam pawl le dungthluntu pawl thu an el fak ngelngo cu an hmu. ");
INSERT INTO cfm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cule mipi zate cu Jesuh an hmuh cangka in an mang a bang setak, cule ama hmuak dingin a sinah an zuang. ");
INSERT INTO cfm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Cun Jesuh nih a dungthluntu pawl sinah, “An ni thawn zangtu nan el fa?” tiah a sut hnei. ");
INSERT INTO cfm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cule mipi lakin mi pakhat nih a sawn ih, “Sayapa, nan sinah ka fapa ka tian pit, zangahtihle thlarau sia nih ṭon thiam lo in a tuah. ");
INSERT INTO cfm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Thlarau sia nih a molh cangcang in leilung ah a hlon fa, a ka in rabuan a suak, a ha a rial ih a ṭhong colh. Cule na dungthluntu pawl sinah, thlarau sia dawisuak dingin ka sim hnei naʼn, an dawisuak thei lo,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Cule Jesuh nih a sawn ih an sinah, “Aw zupnak nei lo a tun san minung pawl, nan sinah khawtik tiang ka um rih thok? Nan tlunah khawtik tiang ka thinsau thok? Cuvai pa cu ka sinah tianpit uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Cule cuvai pa cu Jesuh sinah an feh pit. Thlarau sia nih Jesuh a hmuh cangka in nappang pa cu a caih ter ih leilung ah a ngal, a tawng fa ih a ka in rabuan a suak. ");
INSERT INTO cfm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Cule Jesuh nih, “Hitin a sihnak hi rei cem im?” tiah a pa cu a sut. Cule a pa nih, “A nappan lai in a si cem. ");
INSERT INTO cfm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vei tampi cu thlarau sia nih that dingin meisa sung le ti sungah a hlon. Na tuah theimi a sih ahcun kan thinfah la kan bawm hram,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesuh nih a sinah, “Na tuah theimi a sih ahcun, tiah na ti. A zumtu hrang ahcun zang hmahhmah hi a cang thei colh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hmakhatte ah nappang pa ih pa cu a hek ih, “Ka zum, ka zuplonak ka bawm hram,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesuh nih mipi pawl hmuakkhawm fa cu a hmuh hnei tikah, thlarau sia cu a tai ih, a sinah, “Naset le ṭon thiam lo nang thlarau sia, hivai nappang pa sungin suak la lut sal i hlah, tiah thu ta pe,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Cule thlarau sia cu a hek ih nappang pa cu a caih ter hnukah a sungin a suak. Nappang pa cu mithi mangin a um ih, mi tampi nih, “Nappang pa a thi,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Asinain Jesuh nih a kut in nappang pa cu a la ih a han tho, cule a hang ding. ");
INSERT INTO cfm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cule Jesuh cu inn songah a lut ih a dungthluntu pawl nih a thupteʼn, “Zangah kan hmah kan dawisuak thei lo?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Cule Jesuh nih an sinah, “Thlacamnak lo cun, himang thlarau sia cu zangkhaw nih a dawisuak thei lo,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Cun Jesuh le a dungthluntu pawl cu cuvai hmun ihsin an pok ih Galilee peng palpah in an feh. Cule Jesuh nih hutukhaw ih an fiah ding a duh lo. ");
INSERT INTO cfm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Zangahtihle a dungthluntu pawl thu a zirh hnei ih, an sinah, “Minung Fapa cu mi kut ah pek a i thok ih an that thok. Cule an thah hnuk ni thum hnukah a thosal thok,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Asinain zangtu a sim tih an cing thiam lo, a suh le an ṭih ih an sut ngam lo. ");
INSERT INTO cfm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Cun Jesuh le a dungthluntu pawl cu Kapernaum khua an ban. Cule inn songih a um laiah, Jesuh nih an sinah, “Lampi lakah zangtu thu nan el fa ngelngo?” tiah a sut hnei. ");
INSERT INTO cfm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Asinain daiten an um colh, zangahtihle lampi lakih an el fakmi cu an lakah hutu a hnem bik tihmi a i. ");
INSERT INTO cfm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Cun Jesuh cu a to, cule a dungthluntu hleinih cu a ko hnei ih, an sinah, “Hutukhaw hmasabik sih a duhtu cu mi hmahhmah lakah netabik a i thok ih, mi hmahhmah ih siahhlawh a i thok,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesuh nih nappang pa a ko ih an laifang ah a ding ter, cule a kut in a cawi ih, an sinah, ");
INSERT INTO cfm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hutukhaw ka hmin in himang nappang pakhat a cohlangtu cu kei ka na cohlang a i. Cule hutukhaw ka na cohlangtu cu kei kau ka na cohlang i lo in, ka na thlahtu sawn a cohlang mi a i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johan nih Jesuh sinah, “Sayapa, na hmin in thlarau sia a dawisuaktu mi pakhat kan hmu ih kan na thluntu a ih lo ruangah cuvai pa cu kan dawn,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Asinain Jesuh nih, “Dawn hlah uh, zangahtihle ka hmin ih mangbangza a tuahtu cu nih ka na relsiat thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Zangahtihle kan na dokalh lotu cu kan la ṭang a i. ");
INSERT INTO cfm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Zangahtihle thutak in nan ta sim, Khrih ih ta na ih ruangah ka hmin in din ding ti khuat khat ta petu cu, a tuah ṭhatman a sung hrimhrim thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Cun hutukhaw ka na zumtu hivai nappang pakhat khat a sual tertu cu a hngawng ah fang rialnak lungtum thlaih pit in tipi thuanthum sungah hlon fa sehla a hrangah a ṭha sawn. ");
INSERT INTO cfm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na kut nih ta sual ter asihle na kut cu ṭhot. Taksa kim lo in nunnak sungih luh cu kut panih thawn a mit kel lo mi meisa, hell sungih feh nakin na hrangah a ṭha sawn. ");
INSERT INTO cfm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Cun na ke nih ta sual ter asihle na ke cu ṭhot. Ke kim lo in nunnak sung luh cu ke panih thawn hell sungih luh nakin na hrangah a ṭha sawn. ");
INSERT INTO cfm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Cun na mit nih ta sual ter asihle na mit cu khorh. Mit pakhat thawn Pathian Uknak sungih luh cu mit panih thawn hell ih luh nakin na hrangah a ṭha sawn. ");
INSERT INTO cfm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cuvai hmun ahcun ‘zang pawl cu an thi kel lo ih meisa khaw a mit kel lo.’ ");
INSERT INTO cfm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Thawinak cu ci in thianfaiter a sih mangin mi hmahhmah cu meisa in thianfaiter colh an i ve thok. ");
INSERT INTO cfm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ci cu a ṭha, asinain a al nak a net asihle, zangtin na al ter sal thok? “Nanma ah ci cu nei uh, cule pakhat le pakhat rem fa uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Cun Jesuh cu cuvai hmun in a suak ih Jordan tikua ralkhat le Judea peng laah a feh. Mipi pawl cu a sinah an hmuakkhawm fa sei ih a tuah kel mangin thu a zirh hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Cun Farasi pawl cu a sinah an feh ih, hneksak an duh ruangah, “Pami nih a nupi ma sehla daan nih a siang maw?” tiah thu an sut. ");
INSERT INTO cfm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesuh nih a let hnei ih, “Moses nih zangtu thu nan ta pe?” tiah a sut hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cule an ni nih, “Moses nih maknak ca ngan pit in mak cu a siang,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Asinain Jesuh nih an sinah, “Nan lungruh tuk ruangah nan hrangah hi daan hi Moses nih a ngan. ");
INSERT INTO cfm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Asinain sersiam thoktir ihsin ‘Pathian nih numi le pami a tuah.’ ");
INSERT INTO cfm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Curuangah pami nih a nu le pa ramta pit in a nupi a kop thok. ");
INSERT INTO cfm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Cule taksa panih cu taksa pakhat ah an cang thok.’ Curuangah an ni cu panih an i, i lo, taksa pakhat an i sawn. ");
INSERT INTO cfm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Curuangah Pathian ih a kop cem mi cu hutukhaw nih ṭhen hlah seu,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cun inn song an luh sal tikah, a dungthluntu pawl nih cuvai thu cu an sut sal. ");
INSERT INTO cfm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Cule Jesuh nih an sinah, “Hutukhaw a nupi ama ih nupi dang a ṭhit asihle ṭangṭawm sualnak a tuah. ");
INSERT INTO cfm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Cun numi khaw nih a pasal ama ih pasal dang a neih asihle ṭangṭawm sualnak a tuah,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Cun mipi pawl nih, Jesuh ih tham dingah, nappang pawl cu a sinah an ṭhi. Cule a dungthluntu pawl nih cu pawl cu an tai. ");
INSERT INTO cfm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Asinain Jesuh nih a hmuh tikah, a thin a se ih an sinah, “Nappang pawl cu ka sinah tiang seu, dawn hlah uh. Zangahtihle Pathian Uknak cu himang nappang pawl ih ta a i. ");
INSERT INTO cfm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Thutak in nan ta sim, ‘Hutu khaw sisehla nappang pawl mangin Pathian Uknak a cohlang lo tu cu Pathian Uknak sungah an lut thei kel thok lo,’ ” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Cule nappang pawl cu a ban tlunah a cawi hnei, an tlunah a kut a suang ih thlawsuah a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cun Jesuh cu khual tlawn ding ih a suah zawngah, a sinah mi pakhat a zuang ih a khuk bil in, “Zirhtu ṭha, kumkhua nunnak ka co theinak dingah zangtu ka tuah thok?” tiah a sut. ");
INSERT INTO cfm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Cule Jesuh nih a sinah, “Zangruangah zirhtu ṭha tiah ka na ko? Pathian hrello mi ṭha hukhaw an um lo. ");
INSERT INTO cfm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Thupek pawl khi fiah kau hmah ci ee: ‘Mi that hlah, ṭangṭawm sualnak tuah hlah, lolak hlah, fiahpitnak dik lo rel hlah, mi deu hlah, na nu le pa cu upat hnei,’ ” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Cun ani nih Jesuh sinah, “Sayapa, cuvai pawl hmahhmah cu ka no lai ihsin ka thlun hnei colh cia mi an i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Cun Jesuh nih cuvai pa cu a zoh ih, a duhdawt, cule a sinah, “Thil pakhat na sam rih: feh la, na neihmi hmahhmah zuar pit in mi fahrah pawl pe hnei, cule vancung ah hlawnthil na nei thok. Cun ka dung ka thlun,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cun cuvai pa cu Jesuh sipmi thu ah a riah a se ih thin nuam lo ngai in a feh, zangahtihle ani cu thilri tamngai a neih ruangah a i. ");
INSERT INTO cfm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Cun Jesuh cu a kiangkap a zoh ih a dungthluntu pawl sinah, “Paisa nei milian pawl hrangah Pathian Uknak sungih luh cu zangtlukin a har!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Cule a dungthluntu pawl cu a sipmi thu ah an mang a bang. Asinain Jesuh nih an sinah, “Fale pawl, Pathian Uknak sungih luh cu zangtlukin a har! ");
INSERT INTO cfm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pathian Uknak sungih milian pa a luh ding nakin ṭhim awng sungih kalauk luh ding hman a bai sawn,” tiah a sim hnei sal. ");
INSERT INTO cfm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cun dungthluntu pawl cu an mang a bang hlehhlo ih, a sinah, “Asihle hutu rundam a i thei thok?” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Cule Jesuh nih a zoh hnei ih, an sinah, “Minung hrang ahcun thil cangthei lo a i, asinain Pathian hrang ahcun thil cangthei lo a i lo. Zangahtihle Pathian thawn cu zang hmahhmah hi a cangthei colh,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Cutikah Peter nih a sinah, “Ngai hnik, zang hmahhmah ramta pit in na dung kan thlun,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Cule Jesuh nih, “Thutak in nan ta sim, hutukhaw siseh la keimai ruang ah le thuthang ṭha ruang ah, a inn, a u le nau, a nu le pa, a fale, a leiram pawl a ramta tu cu, ");
INSERT INTO cfm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tun san sung ah tam sinsin a ngah thok. A inn, a u le nau, a nu, a fale leh a leiram pawl khaw a let zakhat in a ngah thok — hremnak pawl khaw a ngah thok. Cule a tiang lai dingmi san ah kumkhua nunnak a ngah thok. ");
INSERT INTO cfm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Asinain hmasabik a i mi, mi tampi cu netabik an i leh thok ih, netabik pawl cu hmasabik an i leh thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cun Jerusalem la ih an feh lai ah Jesuh cu an hmai ah a feh khan, a dungthluntu pawl cu an mang a bang ih a thluntu midang pawl khaw an ṭih. Cule dungthluntu hleinih pawl cu hmun dang deuh ah a ṭhi ta hnei sal ih a tlunih thilcang dingmi pawl a sim hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesuh nih, “Ngai hnik uh! Jerusalem khua kan ban thok ih, Minung Fapa cu puithiam upa pawl le daanthiam pawl kut ah pek a i thok. Cule an ni nih thi dingin mawh an puh thok, cule Zentail pawl sinah an ap thok. ");
INSERT INTO cfm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cun hnihsuahsainak ah an hmang thok ih cihrit an khak thok, an thawi thok ih an that thok. Cule ni thum hnukah a thosal thok,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Cun Zebedi ih fapa James le Johan cu Jesuh sinah an feh ih, “Sayapa, thil ta hlermi hmahhmah kan tuahsak la kan duh,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Cule Jesuh nih an sinah, “Zangtu tuahsak nan duh?” tiah a sut hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Cule an ni nih a sinah, “Na sunlawinak ah na vorh la ah pakhat, na keh la ah pakhat, kan toter veve hram,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Asinain Jesuh nih an sinah, “Zangtu nan hler tihmi nan fiah lo. Ka din dingmi khuat hi nan ding thei thok maw? Asihlole ka co dingmi baptisma teh nan co thei thok maw?” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Cun an ni nih a sinah, “Kan tuah thei thok,” tiah an ti. Cule Jesuh nih an sinah, “Ka din dingmi khuat cu nan ding thei kau thok, cule ka co dingmi baptisma khaw nan co thei kau thok. ");
INSERT INTO cfm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Asinain ka vorh la le ka keh la ih to ding thu cu kei ih pek dingmi a i lo; timtuah sak ciami pawl hrang sawn ah a i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cun cuvai thu cu a dang pahra pawl nih an theih tikah James le Johan cungah an lung a awi lo. ");
INSERT INTO cfm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Cule Jesuh nih a sinah a ko hnei ih, an sinah, “Zentail pawl uktu dingih ruahmi pawl cu an mipi tlunah an bawisak fa ngai ih, an hotu pawl khaw an tlunah thu an nei ngai, tih cu nan fiah. ");
INSERT INTO cfm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Asinain nan lakah cu hi mangin i ding a i lo. Hutu khaw nan lak ih hnem bik sih a duh ahcun nan siahhlawh i sawn seh. ");
INSERT INTO cfm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cule hutukhaw nan lak ih hmasabik sih a duh ahcun nan zate ih sal i sawn seh. ");
INSERT INTO cfm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Zangahtihle Minung Fapa hman riatmi i dingah a tiang lo, riantu i dingah le mi tamngai tlatnak hrangah a nunnak pe ding sawn ah a tiang,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cun Jesuh le a dungthluntu pawl cu Jerikho khua an ban; cule a dungthluntu pawl le mipi tamngai thawn Jerikho in an pawh zawngah, Timias ih fapa Bartimias, mitkhang kutdawh, cu lampi kap ah a to. ");
INSERT INTO cfm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cule Nazareth mi Jesuh a si tih a theih tikah, a hek ih, “Jesuh, David Fapa, ka cungah thinfahnak nei hram!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cule mi tampi nih an tai ih, daiten um an forh. Asinain a hek hlehhlo ih, “David Fapa, ka cungah thinfahnak nei hram,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Cun Jesuh cu a cawlhnga ih, “Ko uh,” tiah a ti. Cule mitkhang pa cu an ko ih, a sinah, “Thin thlangamten um, hang tho, Jesuh nih ta ko,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Cule a hnipuan cu a hlon ta ih, Jesuh sinah cun a pet vervo. ");
INSERT INTO cfm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Cule Jesuh nih a let ih, a sinah, “Na hrangah zangtu ta tuahsak na duh?” tiah a sut. Cule mitkhang pa nih a sinah, “Rabbi, khua hmu thei sal ningla ka duh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Cule Jesuh nih a sinah, “Feh, na zupnak nih ta damter cem,” tiah a ti. Cule hmakhatte ah khua a hmu thei sal ih Jesuh cu zalam ah a thlun. ");
INSERT INTO cfm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cun Jerusalem la an naih i mepmo ih, Olif Tlang ih Bethfath le Bethani khua hram an bat tikah, Jesuh nih a dungthluntu panih cu a thlah hnei ih, ");
INSERT INTO cfm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","an sinah, “Nan hmala ih khaw sungah feh uh, khaw sungih nan luh cangka in hutukhaw ih an to kel lomi lak note hri thawn an khihmi nan hmu thok. A hri cu phoih uhla duk ta uh. ");
INSERT INTO cfm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Cule mi pakhat khat nih, ‘Zangah aitin nan tuah?’ tiah nan ta tih eng le, ‘Bawipa nih a ṭul, hi hmunah nan ta kuat sal lohli thok,’ ti uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Cun an feh ih lampi lengih kotka ah lak note an khih cu an hmu, cule a hri cu an phoih. ");
INSERT INTO cfm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Cun cuvai hmun ih a dingmi mi hrekkhat nih, “Zangah lak note cu a hri nan phoih?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Cule an ni nih Jesuh ih a sip hnei cia mangin an sim, cun an feh ter. ");
INSERT INTO cfm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cule Jesuh sinah lak note cu an ṭhi ta ih a cungah puan an thah sak ih Jesuh cu a cungah a to. ");
INSERT INTO cfm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cun minung tamngai nih zalam tluanah an puan an thap ih mi hrekkhat nih lo sungih sawlhnah an sat ih zalam tluanah an thap. ");
INSERT INTO cfm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cun a hmaiih a fehtu pawl le a dungih a thluntu pawl cu an hek ih, “Hosanna! Bawipa ih hmin in a tiangtu cu thlawsuah in um seh! ");
INSERT INTO cfm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","A tiang dingmi kan pa David ih uknak cu thlawsuah in um seh! A sangbik ah Hosanna!” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Cule Jesuh cu Jerusalem ah a feh ih biakinn songah a lut. Thil hmahhmah a zoh colh hnukah, ni a sim i ih, dungthluntu hleinih pawl thawn Bethani khua ah an feh. ");
INSERT INTO cfm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cun a zingthlala ah, Bethani khua in an kirhsal tikah, Jesuh cu a caw a ṭam. ");
INSERT INTO cfm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Cule lamhla nawnah a hnah a nim ngaimi thei kuang pakhat a hmu ih a thei ka hmuh pangah tiah thei kuang la cu a feh. Thei kuang umnak a bat tikah, a hnah hrello zangkhaw a hmu lo; zangahtihle thei a thei can a i lo. ");
INSERT INTO cfm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cutikah Jesuh nih thei kuang cu, “A kumkhua in hutukhaw nih na thei ei i nawn hlah seu,” tiah a ti. Cule a dungthluntu pawl nih a ṭonmi cu an thei. ");
INSERT INTO cfm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cun Jerusalem an ban. Cule Jesuh cu Biakinn songah a lut ih Biakinn songih thil zuartu pawl le thil leitu pawl dawisuah a thok. Cule Paisa thlengtu pawl ih cabuai le thute zuartu pawl ih tokheng pawl khaw a linglet colh. ");
INSERT INTO cfm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Cule hutukhaw Biakinn songah zangtumang thilri khaw phur in vah a sian hnei lo. ");
INSERT INTO cfm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Cun thu a zirh hnei ih an sinah, “Ca Thianghlim sungah ‘Ka inn cu miphun zate hrangah thlacamnak inn tiah kawh a i thok,’ tiah ngan a i lo mawh? Asinain damiah pawl ih rolhnak lungkuak ah nan tuah,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Puithiam upa pawl le daanthiam pawl nih cuvai cu an theih tikah, Jesuh cu an ṭih ruangah a thah thei dan ding an hrawl. Zangahtihle mipi zate cu Jesuh ih thuzirhmi ah an mang a bang. ");
INSERT INTO cfm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cun ni a sim i tikah Jesuh le a dungthluntu pawl cu khaw sung in an suak. ");
INSERT INTO cfm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cun a zingthlala zalam ih an feh laiah, a tawhram in a rocar mi thei kuang cu an hmu. ");
INSERT INTO cfm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Cun Peter cu a cing sal ih Jesuh sinah, “Rabbi, Zohhnik aw! Na camsiatmi thei kuang cu a rocar colh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Cule Jesuh nih a let ih an sinah, “Pathian zum uh. ");
INSERT INTO cfm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Thutak in nan ta sim, hutukhaw a thinlung sungah rinhelhnak nei lo in a sipmi mangin a cang tengteng thok tiah a zup ahcun, hivai tlang hi, thawnfa pit in tipi thuanthum sungah ṭil, tiah a titu cu a ṭon mangin tuahsak a i thok. ");
INSERT INTO cfm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Curuangah nan ta sim, thlacamnak thawn nan hlerhmi hmahhmah hi kan ngah cem tiah zum uh la, cule nan ta a si thok. ");
INSERT INTO cfm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cun thla cam dingih nan din tikah, Van ih a um mi nan Pa nih nan sualnak pawl nan ta ngaihthiam theinak dingah, mi pakhat khat cungah lungkim lonak nan neih asihle ngaihthiam uh,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Cun Jesuh le a dungthluntu pawl cu Jerusalem ah an ban sal. Cule Jesuh cu biakinn songih a feh laiah, puithiam upa pawl, daanthiam pawl le upa pawl nih an pha ih, ");
INSERT INTO cfm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesuh sinah, “Himang thil pawl hi hutu ih thuneihnak in na tuah hnei? Asihlole himang thil pawl tuah dingah hutu nih thuneihnak ta pe?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Cule Jesuh nih an sinah, “Kei khaw thu pakhat nan ta sut ve thok ih, ka let uh. Cun zangtu thuneihnak thawn himang thil pawl ka tuah, tihmi nan ta sim thok. ");
INSERT INTO cfm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johan ih Baptisma hi vancung la in maw minung sin in a i? Ka let hnik uh,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Cun cuvai thu cu anma ten an relkhawm ih, “Van la in a i, tiah kan tih le, ‘Zangruangah Johan cu nan zum lo,’ tiah kan na ti thok. ");
INSERT INTO cfm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Cun ‘Minung sin in…,’ tiah kan ti thok maw?” (Zangahtihle mi hmahhmah nih Johan cu profet taktak a i tiah an pom ruangah mipi pawl an ṭih.) ");
INSERT INTO cfm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Curuangah Jesuh sinah “Kan fiah ve lo,” tiah an let. Cule Jesuh nih an sinah, “Kei khaw zangtu thuneihnak thawn hi thil pawl ka tuah, tihmi nan ta sim ve thok lo,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Cun Jesuh nih an sinah tahṭhipnak thawn thusip a thok. “Mi pakhat nih sabit dum a tuah ih hruang in a kulh, cule sabit ti surnak ah khur a lai ih hrawlte a don. Cun a dum cu man pek ih a sawngtu pawl sinah a ramta ih lam hlapi ah khual a tlawn. ");
INSERT INTO cfm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","A tikcu can a kim tikah, dum sawngtu pawl sin in a covo sabit thei la dingah, a siahhlawh pakhat a thlah. ");
INSERT INTO cfm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Cun cuvaipa cu an tlai ih an thawi hnukah zahawr in an tlungter. ");
INSERT INTO cfm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Cule an sinah siahhlawh dang pakhat cu a thlah seisei. Cun cuvaipa cu a lu ah an thawi ih hmualpho le ningzak in an tuah. ");
INSERT INTO cfm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A dang a thlah sal seisei ih a thlahmi pa cu an that. Cule a dang tamngai khaw cu a thlah bet, a hrekkhat cu an thawi ih a hrekkhat cu an that. ");
INSERT INTO cfm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Thlah dingmi pakhat la cu a nei rih, a duhdawt ngaimi a fapa a si. Netabikah dum sawngtu pawl sinah cun a fapa cu a thlah ih, ‘Ka fapa cu an upat kau thok,’ tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Asinain dum sawngtu pawl nih, ‘Hivaipa hi ro cotu thok cu a i. Cei uh, that lausing, cule a co dingmi ro hmahhmah cu kan maiʼ ta an i thok,’ tiah pakhat le pakhat an ti fa. ");
INSERT INTO cfm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cun cuvaipa cu an tlai ih an that, cule sabit dum lengah an hlon. ");
INSERT INTO cfm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Sabit dum neitu nih zangtin tuah lai? a feh thok ih dum sawngtu pawl cu a siatsuah hnei thok, cule sabit dum cu midang sinah a pe thok. ");
INSERT INTO cfm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ca thianghlim sungah: “ ‘Inn satu pawl ih an hnon mi lung cu A thupi bikmi innkil lung ah a cang. ");
INSERT INTO cfm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hihi Bawipa ih tuahmi a i, Cule kan mithmuh ah mangbangza a i, tiih nganmi khi nan siar kel lo maw?’ tiah a ti.” ");
INSERT INTO cfm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Cun Judah upa pawl cu Jesuh tlaih dan ding an hrawl, asinain mipi pawl an ṭih. Zangahtihle cuvai tahṭhipnak cu anma tihsat ih a sipmi a si tih an fiah. Curuangah Jesuh cu an ramta ih lam hlapi ah an feh. ");
INSERT INTO cfm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cun a ṭonkam in ama an tlaih theinak dingah, Farasi hrekkhat le Herod ih milai hrekkhat cu Jesuh sinah an thlah. ");
INSERT INTO cfm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Cun Jesuh sin an ban ih a sinah, “Sayapa, nang cu, mi nih zangtin ka na ruat eng thok, tih khaw zanghrel loʼn thudik na sim, tih kan fiah. Zangahtihle minung mithmai na zoh lo ih Pathian ih zalam cu dik ngaiin na zirh. Caesar sinih siah pek hi daan nih a siang maw siang lo? Kan pe thok maw pe thok lo?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Asinain Jesuh nih an depdetnak a fiah ih an sinah, “Zangruangah ka na hneksak eng? ngun tangka ka pe hnik uh, cule ka zoh hnik thok,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Cun ngun tangka cu an pe ih an sinah, “Hihi hutu ih muihmel a si ih, zangtu thu a ngan fa?” tiah a sut hnei. Anni nih, “Caesar ih,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Cule Jesuh nih an sinah, “Caesar ih thil pawl cu Caesar sinah pe uh, cule Pathian ih thil pawl cu Pathian pe uh,” tiah a ti. Cun Jesuh cungah an mang a bang ngai. ");
INSERT INTO cfm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Cun Jesuh sinah thawhsalnak a um lo titu Sadusi pawl an tiang ih thu an sut. ");
INSERT INTO cfm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Sayapa, Moses nih, ‘mi pakhat cu fa nei loʼn a nupi a thihtak asihle a unau pa nih cuvai nuhmei cu a ṭhi thok ih, a unau pa ih hrangah ci a thlahsak thok,’ tiah kan na ngansak. ");
INSERT INTO cfm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Cun unau pasarih an um, uta bik nih nupi a ṭhi ih fa nei loʼn a thi. ");
INSERT INTO cfm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Cule a panihnak pa nih cuvai nu cu a ṭhi ih fa nei loʼn a thi ve. Cun a pathumnak pa khaw cumang thotho in a cang. ");
INSERT INTO cfm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cule an pasarih in fa nei loʼn an thi colh. Neta bik ah numi nu khaw a thi ve. ");
INSERT INTO cfm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Curuangah thawhsalnak ih an thawhsal tikah, hutu bik ih nupi a si thok? An pasarih in nupi ah an ṭhi vek sikhaw?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesuh nih an sinah, “Pathian ih cahnak huham le Ca Thianghlim nan fiah lo ruangah nan sual a i lo maw? ");
INSERT INTO cfm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Zangahtihle thihnak in an thawhsal tikah, an ṭhi fa i thok lo, ṭhitfaknak khaw a um i thok lo ih, vancung ih a ummi vancungmi pawl mang an i thok. ");
INSERT INTO cfm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Cun mithi thawhsalnak thu ah, hrambur sung in Pathian nih Moses sinah, ‘Kei cu Abraham ih Pathian, Isak ih Pathian, le Jakob ih Pathian ka si,’ a tihmi Moses cabu khi nan siar kel lo maw? ");
INSERT INTO cfm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ani cu a thimi pawl ih Pathian a i lo, a nungmi pawl ih Pathian a i sawn. Curuangah nan ruatsual ngai,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cun daanthiam pawl lakih mi pakhat cu a tiang ih, thu an relmi cu a ngai. Cule Jesuh nih ṭha tukin a sawn hnei thiam tih a hmuh tikah, “Thupek hmahhmah lakah khoitu hi a thupi bik?” tiah a sut. ");
INSERT INTO cfm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesuh nih, “A thupi bikmi Thupek cu: ‘Maw Israel, ngai hnik, Bawipa kan Pathian, Bawipa cu pakhat a i. ");
INSERT INTO cfm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cun Bawipa na Pathian cu na thinlung zateʼn, na nunnak zateʼn, na ruahnak zaten le na cahnak zaten na duhdawt thok,’ tihhi a i. ");
INSERT INTO cfm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Cun a panihnak cu: ‘Nangma le nangma na duhdawt fak mangin na inn kiangveng pawl na duhdawt thok,’ tihhi a i. Hi thupek pawl nakih thupi sawn thupek a um lo,” tiah a sawn. ");
INSERT INTO cfm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Cule daanthiam pa nih a sinah, “Sayapa, na sipmi cu a ṭha. Thudik na sim, zangahtihle Pathian pakhat kau a um, ani siarlo pathian dang an um lo. ");
INSERT INTO cfm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cun thinlung zate, fiahthiamnak zate, cahnak zate thawn ama Pathian duhdawt, le ma le ma duhdawt fak mangin inn kiangveng pawl duhdawt cu meihul thawinak le thawinak dangdang pawl nakin a thupi sawn,” tiah a sawn. ");
INSERT INTO cfm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Cun Jesuh nih, cupa nih fing ngaiin a let, tih a hmuh tikah, a sinah, “Pathian uknak thawn nan hlat fa lo,” tiah a ti. Cuvai hnuk cu hukhaw nih thu an sut ngam i lo. ");
INSERT INTO cfm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Cun Jesuh cu biakinn songah thu a zirh. Jesuh nih, “Zangtin daanthiam pawl nih Khrih cu David ih fapa a si, tiah an ti thiam? ");
INSERT INTO cfm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David ama rori nih Thlarau Thianghlim hmangin: “ ‘Bawipa nih ka Bawipa sinah: Na ral pawl na ke tangih ka siah hlan lo, Ka vorh la ah to,’ tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","A ma David rori hman nih ani cu ‘Bawipa’ tiah a ko. Curuangah zangtin a fapa cu a si thiam thok?” tiah a ti. Cule mipi tam ngai nih Jesuh ih thuzirhmi cu lungawi ngaiin an ngai. ");
INSERT INTO cfm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Cun a thuzirhnak ah Jesuh nih, “Daanthiam pawl khi ralring uh, an ni cu angki fual thawn tawivah an duh ih dawr tluan ah cibai buk an duh. ");
INSERT INTO cfm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Cule Sinakok ah tonak ṭhabik ah to an duh ih puai tuahnak ah upatnak hmun ih to an duh. ");
INSERT INTO cfm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nuhmei pawl ih inn an long ih, mi deuhnak ah rei ngaingai in thla an cam fa ter. Hipawl hi thuṭhennak nasa sawn an tuar thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Cun Jesuh cu thawhhlawm bawm zawn ah a to ih, mipi nih thawhhlawm bawm sungah zangti in tangka an ṭhil, tih a zoh. Milian pawl nih tangka tamngai an ṭhil. ");
INSERT INTO cfm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Cun nuhmei fahrah pakhat a tiang ih dar tangka pia nih a ṭhil ve. ");
INSERT INTO cfm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Cule a dungthluntu pawl cu a ko hnei ih an sinah, “Thutak in nan ta sim, hivai nuhmei fahrah nu hi thawhhlawm bawm sungih a ṭhiltu dang pawl hmahhmah nakin tamsawn a ṭhil. ");
INSERT INTO cfm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Zangahtihle midang pawl hmahhmah cu an neih hleifuanmi an pe; asinain ani cu a fahrah ngai na in — a nunkhaw saknak ding ih a neihmi zatein a ṭhil colh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cun Jesuh cu Biakinn songin a suah fangah, a dungthluntu pawl lakih mi pakhat nih a sinah, “Zoh hnih, Sayapa, hivai lung pawl le inn pawl hi maktak uh e!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Cule Jesuh nih a sinah, “Hi inn mak tara pawl hi na hmu kau lo maw? Hi lung pakhat cungah lung dang pakhat hman tang lo in hlon colh a i leh thok,” tiah a sim. ");
INSERT INTO cfm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesuh cu Biakinn la hoi in Olif Tlang cungih a to laiah, Peter, James, Johan le Andru nih a thupte in an pha ih, ");
INSERT INTO cfm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Cuvai thil pawl cu khawtikah a tiang thok ih, a tian ni a nai tikah zangtu hmuhsaknak pawl a um thok?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Cule Jesuh nih an sinah, “Mi ih nan ta deuh eng lonak dingah ralring uh. ");
INSERT INTO cfm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mi tampi ka hmin in an tiang thok ih, ‘Kei hi ani ka si!’ tiah an ti thok ih mi tampi an deu thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Cun dohfaknak thu le ral dawhnak thuthang pawl nan theih tikah nan thinphang hlah uh. Cumang thil pawl cu a cang hrimhrim thokmi an i, asinain a netnak cu a tiang rih lo. ");
INSERT INTO cfm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Zangahtihle miphun pakhat le pakhat, ram khat le ram khat an do fa thok. Cule hmun dangdang ah ling a hnin thok ih mangṭam a tlung thok. Cuvai pawl cu nauneih thokih pumfah mang a i thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Asinain nanma hrimhrim ralring uh. Zangahtihle nan ta tlai eng thok ih khonsil ah nan ta fehpit thok; Sinakok sungah nan ta thawivel eng thok; cule ka thuhla fiahpittu dingah keimaiʼ ruangah uktu pawl le siangpahrang hmai ah nan ding thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cule thuthang ṭha cu miphun zate sinah sipphuan hmasak a i thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cun nan ta tlai eng ih mi kut nan tian tikah, zangtu ka ṭon thok tiah khawruahhar cia hlah uh. Asinain cuvai tikcu can ih nan sinih sipmi hmahhmah kau ṭon uh. Zangahtihle a ṭontu cu nan, nan i lo, Thlarau Thianghlim sawn a i. ");
INSERT INTO cfm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cule unau le unau khaw thihnak tiang khop in an phatsan fa thok ih, pa nih fa, cun fale nih nu le pa pawl an dodal thok ih thihnak tiang an suah fa thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Cun ka hmin ruangah mi hmahhmah nih nan ta hua eng thok. Asinain a net tiang a tuarsuaktu cu rundam a i thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Cun ‘Tuksumza Thil Borhhlawh’ cu a din lonak ding hmun ih a din nan hmu thok.” (A siartu nih cingthiam seh!) “Cule Judea peng ih a um mi pawl cu tlang cung ah zuang seu. ");
INSERT INTO cfm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inn tlun diphun ih a um mi cu rong ṭum pit in thil la dingah inn song ah lut hlah seh. ");
INSERT INTO cfm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Cule lo ih a um mi khaw a hnipuan la dingah a inn ah tlung hlah seh. ");
INSERT INTO cfm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Cuvai can cu farai pawl le nau hnawi fawp nei pawl hrangah cu a har setak thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cuvai can cu isik can ah cang lo dingin thla cam uh. ");
INSERT INTO cfm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Zangahtihle cuvai ni ah cun Pathian nih leilung a semsuah tir in a tun tiangah a um dah kel lomi, leh a um sal i nawn thok lo mi harsatnak a um thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Cun cuvai ni cu Bawipa nih a tawiter lo ahcun zangmang minung khaw an luat thok lo. Asinain a hril hleice mi pawl hrangah cuvai ni cu a tawiter thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Cun mi pakhat khat nih, ‘Zohhnik uh, Khrih cu hiva a um!’ lole ‘Zohhnik uh, Khrih cu khiva ah a um,’ tiah nan ta ti eng khawah — zum hlah uh! ");
INSERT INTO cfm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Zangahtihle khrih deu pawl le profet deu pawl an suak thok ih mi an deuh theinak dingah hmuhsaknak pawl le mangbangza thil pawl an tuah thok, a canthei ahcun hril mi pawl hman an deu thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Asinain ralring uh; ai hlan in thil hmahhmah nan ta sim cia cem. ");
INSERT INTO cfm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Asinain cuvai ni ahcun, cuvai harsatnak a tian hnukah, ni cu a mawk thok ih thlapa khaw a vang thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cun vancung in arsi pawl an ṭil thok ih vancung huham cahnak pawl khaw an hnin colh thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Cun mi nih huham cahnak le sunlawinak thawn Minung Fapa khawdur lakin a rong ṭum cu an hmu thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cule a vancungmi pawl a thlah hnei thok ih Leilung kil li ih a hril mi pawl cu lei taw deng ihsin van deng tiang a khawlkhawm hnei thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Thei kuang tahṭhipnak in zir uh. A tlang note an hang suak ih a hnah a cerh tikah ṭhal can a nai tih nan fiah. ");
INSERT INTO cfm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cumang thotho in, himang thil pawl a tian nan hmuh tikah tikcu can a nai i, kotka hram a ban i, tih fiah uh. ");
INSERT INTO cfm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Thutak in nan ta sim, hivai thil pawl a kim lai hlan lo, tun san minung pawl hi an loral thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Van le leilung cu an loral thok, asinain ka ṭonkam pawl cu an loral kel thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Asinain cuvai ni le can cu hutukhaw nih an fiah lo — van ih vancungmi pawl khaw nih an fiah lo, Fapa khaw nih a fiah lo; Pa kau nih a fiah. ");
INSERT INTO cfm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nanma hrimhrim ah ralring uh, thengvar zikzik uh. Zangahtihle khawtikah a cang thok tih nan fiah lo. ");
INSERT INTO cfm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Zangtu thawn a ṭiahfa tihle, mi pakhat a inn ramta in khual tlawn dingih a pawh tikah, a sinum pawl sinah thuneihnak le an ṭuanvo vek ṭhaten a peta hnei ih kotka kiltu khaw ihhmul lo in thengvar ringring dingin thu a cah ta tu pa mang khi a i. ");
INSERT INTO cfm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Curuangah thengvar ringring uh, zangahtihle inn neitu cu zan ah maw, zanruang ah maw, zing arkhuan can ah maw, zingmaw ah maw — khawtikah a tiang thok tih nan fiah lo. ");
INSERT INTO cfm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Culole rinlopiʼn a tiang ih nan ihhmulh lai nan ta hmu pang thok. ");
INSERT INTO cfm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cun nan sinih ka sipmi thu hi mi hmahhmah sin khaw ah ka sim: thengvar in ralring uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lantak Puai le Colh tello Sang Puai kim ding cu ni nih kau a duh. Puithiam upa pawl le daanthiam pawl nih Jesuh cu a thupten tlaih thei dan ding le thah thei dan ding an hrawl. ");
INSERT INTO cfm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Asinain, “Puai can ah cu i hlah seh, mipi pawl an buai pang thok,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Cun Jesuh cu Bethani khua, pharfah a tuar ta dah tu Simon inn ah a um ih caw a ei lai ah, a man khung ngaimi le a thianghlim mi hriak rimhmui cu alabaster lung ih tuahmi thawl thawn kengta pit in numi nu pakhat cu a tiang. Cuvai thawl cu a phak ih hriak rimhmui cu Jesuh ih lu ah a burh. ");
INSERT INTO cfm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mi hrekkhat cu an thin a se ih, “Zangruangah hi hriak rimhmui cu a riaral ter men? ");
INSERT INTO cfm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Zangahtihle hivai hriak cu Ngun tangka zathum nakih tam ah zuar pit in mi fahrah pek sawn thok a i naʼn,” tiah an ti. Cule numi nu cu an mawhthluk. ");
INSERT INTO cfm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Asinain Jesuh nih, “A ma ten umter uh. Zangruangah numi nu cu nan hnaihnok ngelngo? Ani nih ka cungah thil ṭha a tuah. ");
INSERT INTO cfm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Zangahtihle mi fahrah pawl cu nan sin an um reuhro thok ih, nan duh tik poh ah an cungah thil ṭha nan tuah thei. Asinain kei cu nan sinah ka um reuhro thok lo. ");
INSERT INTO cfm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ani nih a tuah thei tawk a tuah cem. Ka na phumnak ding hrangah ka taksa ruangpum hriak a culh cia mi a i. ");
INSERT INTO cfm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cun thutak in nan ta sim, thuthang ṭha an sipnak leilung pumpuluk ah hivai a tuahmi thu hi ama hmulhlonak ah an sim reuhro thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Cun dungthluntu lakih pakhat Judas Iskariot cu Jesuh zuar dingin puithiam upa pawl sinah a feh. ");
INSERT INTO cfm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cule puithiam upa pawl nih cuvai thu an theih tikah, an lung a awi ngai ih tangka pe dingin thu an kam. Cule Judas cu Jesuh zuar ding can remcang a hrawl. ");
INSERT INTO cfm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cun Colh Telhlo Sang Puai, ni khatnak, Lantak Puai thawinak hrang tuu fa no thah ni ah, a dungthluntu pawl nih Jesuh sinah, “Lantak Puai caw cu khoitu ah ta timtuah sak nung la na duh?” tiah an sut. ");
INSERT INTO cfm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cule a dungthluntu pawl lakih mi panih cu a hei thlah ih an sinah, “Khawpi sungah feh uhla tithawl cawitu pa thawn nan hmu fa thok, cule ani cu thlun uh. ");
INSERT INTO cfm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cun khoitu inn ih a luh khaw ah, a luhnak inn ih inntek sinah, ‘Sayapa nih, ka dungthluntu pawl thawn Lantak Puai caw kan einak ding mikhual khan cu khoitu hi a si? a ti,’ tiah sut uh. ");
INSERT INTO cfm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Cule ani nih timtuah ciami tlunta khan hnempi nan ta hmuh thok, cuva cu kan hrangah timtuah uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Cun dungthluntu pawl cu an pok ih khawpi sung ah an feh. Jesuh ih a sipcia mangin an va hmu. Cule Lantak Puai zanriah an timtuah. ");
INSERT INTO cfm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cun simla a phak tikah Jesuh cu dungthluntu hleinih pawl thawn an va feh. ");
INSERT INTO cfm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cule cabuai ih caw an ei lai ah Jesuh nih, “Thutak in nan ta sim, nan lakih mi pakhat — kei thawn caw a ei khat tu — nih ka na zuar thok,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dungthluntu pawl cu an riah a se ngai ih pakhat hnuk pakhat in, “Kei ka si maw?” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesuh nih an sinah, “Dungthluntu hleinih lakih mi pakhat, kei thawn kheng pakhat sungih sang a hnimtu hi a si. ");
INSERT INTO cfm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Minung Fapa cu, a thuhla ngancia mangin, a feh taktak thok. Asinain Minung Fapa a zuartu pa cu a lamka a pit. Suak lo lawlaw in um sehla a hrangah cun a ṭha sawn thok naʼn!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Cun caw an ei laiah, Jesuh nih sang cu a la, thlawsuah a pek hnukah a ṭhek ih a dungthluntu pawl sin a pe hnei, “La uh la ei uh, hihi ka taksa a si,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cule khuat cu a la ih lungawithu a sip hnukah a pe hnei ih an zaten an ding. ");
INSERT INTO cfm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Cun Jesuh nih an sinah, “Hihi mi tamngai hrangah ka thletmi, ka thisen ih thukam a i. ");
INSERT INTO cfm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Thutak in nan ta sim, Pathian Uknak sungih sabit ti thar ka din sal lai hlan lo hivai sabit ti cu ka ding i thok lo,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cule hla an sa ih Olif Tlang ah an feh. ");
INSERT INTO cfm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Cun Jesuh nih an sinah, “Nan zaten ka na zuangta colh thok ih ka na ramta eng thok. Zangahtihle ‘Tuukhal cu ka thawi thok ih, tuu pawl cu an ṭhekdarh colh thok,’ tiah ca thianghlim ah ngan a i. ");
INSERT INTO cfm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Asinain ka thawhsal hnukah Galilee ah nan hmai ah ka feh thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter nih a sinah, “Midang pawl nih ta zuangta colh khaw seula, kei cu ka zuang thok lo,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Cule Jesuh nih a sinah, “Thutak in nan ta sim, nihin zan ah, ar vei nih a khuan hlanah vei thum ka na phatsan thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Asinain Peter nih nasa hlehhlo in, “Nang thawn thi ding i hman ningla, ta phatsan hrimhrim thok lo,” tiah a ti. A dang pawl khaw nih cutin an ti ve. ");
INSERT INTO cfm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Cun Gethsemane tihmi hmun an va ban ih Jesuh nih a dungthluntu pawl sinah, “Thla ka cam sung aiva hi to khan uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cule Peter, James le Johan cu a sinah a ṭhi ta hnei. Jesuh cu khuaruahhar le vansang ngai in a um ih, ");
INSERT INTO cfm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","an sinah, “Ka thinlung hi thihnak tlak khop in rauh ngai a riah a se. Hiva ah si khan uh la ka hngak uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Cun hmunhla deuh ah a feh ih leilung ah a bok, cule a canthiam a sih ahcun cuvai can cu ka sin in lan ter, tiah thla a cam. ");
INSERT INTO cfm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Cule, “Abba, ka Pa, na hrangah cun zang hmahhmah a cangthei colh. Hivai khuat hi ka sin in la hram. Asinain ka duh mangin i hlah seh, na duh mangin i sawn seh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Cun Jesuh cu a dungthluntu pawl sinah a kir sal ih an ihhmulh khi a hmu. Cule Peter sinah, “Simon, na ihhmul maw? Nazi pakhat te hman ka na hngak thei lo maw? ");
INSERT INTO cfm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tukforhnak ih nan luh lonak dingah ihhmul loʼn hngak uh la thla cam uh. Thlarau nih a duh naʼn taksa cu a ṭawnṭai!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cule Jesuh cu a feh sal ih a hmasa mang thotho in thla a cam sal. ");
INSERT INTO cfm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cun a kir sal sei ih an ihhmulh cu a hmu hnei sei, zangahtihle an mit a rit tuk. Zangtin kan sawn sal thok tih khaw an fiah lo. ");
INSERT INTO cfm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A vei thumnak a kir sal ih an sinah, “Nan ihhmul rih thotho a si maw? Nan cawlhnga rih zikzik maw? A tawk i. A tikcu a kim i. Minung Fapa cu misual pawl kut sungah zuar a i cem. ");
INSERT INTO cfm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tho uh, feh u sing. Zohhnik uh, ka na zuartu pa a ban i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cun a ṭon berbo laiah, hmakhatte ah, dungthluntu hleinih lakih pakhat, Judas cu puithiam upa pawl, daanthiam pawl le mi upa pawl ih thlahmi talhvawng le ralnam keng miburpi thawn an tiang ");
INSERT INTO cfm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mi zuartu pa nih, “Ka hnap thokmi pa cu nan tlaih duhmi pa a i. Tlai uhla ṭhaten kil pit in ṭhi ta uh,” tiah hminhlitnak a pe hnei cia. ");
INSERT INTO cfm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas cu a tian cang in Jesuh sin a feh lohli ih, “Rabbi,” tiah a ti ih a hnam. ");
INSERT INTO cfm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Cun Jesuh cu an tlai ih an khit. ");
INSERT INTO cfm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Asinain cuvai hmun ih a dingtu mi pakhat nih ralnam a zuk ih puithiam lubik ih sinum paiʼ nakawr cu ṭot in a sat. ");
INSERT INTO cfm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Cule Jesuh nih an sinah, “Damiah tlai ding mangin ralnam le talhvawng thawn ka na tlai dingah maw nan tiang? ");
INSERT INTO cfm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Biakinn ah thu zirh in ni cangcang nan sinah ka um ih ka na tlai eng lo. Asinain Ca Thianghlim cu a kim a ṭul,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cule a dungthluntu pawl nih an ramta ih an zuangta colh. ");
INSERT INTO cfm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Cun puan pate kau a sinmi tlangval pakhat nih Jesuh cu a thlun. Ani khaw cu an tlai ve. ");
INSERT INTO cfm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Asinain a puan pate cu a ramta ih taklawng in a zuang. ");
INSERT INTO cfm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Cun Jesuh cu Puithiam lubik sinah an ṭhi ta ih puithiam upa pawl, mi upa pawl le daanthiam pawl cu an hmuakkhawm fa. ");
INSERT INTO cfm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Cule Peter nih lam hlat nawn in puithiam upa ih tualhma tiang a thlun. Cule siahhlawh pawl sinah a to ih meisa a ai ve. ");
INSERT INTO cfm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Puithiam upa pawl le khonsil upa pawl cu Jesuh thah theinak ding thu fiahpittu an hrawl, asinain an hmu lo. ");
INSERT INTO cfm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Zangahtihle mi tamngai nih fiahpitnak diklo thawn sual an puh, asinain an thu a rual fa thiam lo. ");
INSERT INTO cfm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Cun mi hrekkhat cu an ding ih, fiahpitnak diklo thawn sual an puh, ");
INSERT INTO cfm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hi pa ih ṭonmi kan thei, ‘Minung ih sakmi hivai Biakinn hi ka siatbal thok ih ni thum sungah kut ih sak lo mi a dang pakhat ka sa thok,’ a ti,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Asinain cuvai an fiahpitnak thu khaw cu an rual fa thiam cuang lo. ");
INSERT INTO cfm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Cun Puithiam Lubik cu an lai fangah a hang ding ih, Jesuh sinah, “Zangkhaw na let hnei thok lo maw? Hi pawl nih ta dokalh in fiahpitnak thu an sipmi hi zangtin a si?” tiah a sut. ");
INSERT INTO cfm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Asinain Jesuh cu daiten a um ih zangkhaw a sawn lo. Puithiam Lubik nih, “Nang hi sunloihmi Pathian ih Fapa Khrih cu na si maw?” tiah a sut sal. ");
INSERT INTO cfm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Cule Jesuh nih, “Ka si, Minung Fapa cu Huham Cahnak neitu ih vorh la ah to in vancung ih khawdur pawl thawn a tian khaw na hmu leh thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Cule Puithiam Lubik cu a hnipuan a phat ih, “Fiahpittu dang kan ṭul bet i maw? ");
INSERT INTO cfm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pathian a thangsiat zia cu nan thei vek cem. Zangtin nan ruat?” tiah a ti. Cule an zaten Jesuh cu thi tlak hrimhrim a i tiah mawh an puh. ");
INSERT INTO cfm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cun mi hrekkhat nih cihrit an khak, a hmai an hup ih an thawng. Cule, “Hutu nih ta thawng? Kan sim hnik,” tiah an ti. Cun siahhlawh pawl nih an beng. ");
INSERT INTO cfm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Cun Peter cu tualhma ih a um lai ah Puithiam Lubik ih siahhlawh pawl lak in numi pakhat cu a sinah a tiang. ");
INSERT INTO cfm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Cule cuvai nu nih Peter meisa a aih lai cu a hmuh tikah a zoh ih, “Nang khaw Nazareth mi Jesuh thawn umkhatmi na si ve,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Asinain Peter nih a el ih, “Ka fiah lo, zangtu na ṭon tih khaw ka fiah lo,” tiah a ti ih kotka la ah a feh. Cule ar a khuang. ");
INSERT INTO cfm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Cun siahhlawh nu nih a va hmu seisei ih, a hram ih a dingtu pawl sinah, “Hi pa hi an lakih telmi a i,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Asinain Peter nih a el seisei. Cun tawite rei hnukah, Peter cu a hram ih dingtu pawl nih, “Nang khaw hi an lakih mi pakhat na si rori, zangahtihle Galilee mi na i,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Cule Peter nih siatcam in thu a kam ih, “Nan sipmi pa hi hutu a si tih ka fiah hrimhrim lo,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cun hmakhatte ah a vei nihnak ar a khuang. Cule Peter cu Jesuh nih, “Ar vei nih khuang hlanah vei thum tiang ka na phatsan thok,” tih a sipmi cu a cing sal. Cun Peter cu a riahse in a ṭap. ");
INSERT INTO cfm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cun zingmaw ngaiah puithiam upa pawl cu mi upa pawl, daanthiam pawl, le khonsil upa pawl thawn thurel khawmnak an tuah lohli. Jesuh cu hri in an khit ih Pilat sinah an ṭhita. ");
INSERT INTO cfm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Cun Pilat nih, “Judah siangpahrang na si maw?” tiah a sut. Cule Jesuh nih, “Nang nih na ti,” tiah a sawn. ");
INSERT INTO cfm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Cule puithiam upa pawl nih Jesuh cu sual a phunphun an puh. ");
INSERT INTO cfm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Curuangah Pilat nih, “Zangkhaw na sawn hnei thok lo maw? Ta zuarthlainak liangluang hi ngai hnik,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Asinain Jesuh nih zangkhaw a sawn hnei lo ruangah Pilat cu a mang a bang. ");
INSERT INTO cfm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lantak Puai cangcang ah Pilat nih mipi ih an dilmi thawngtla pakhat a suahsak hnei ringring. ");
INSERT INTO cfm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Culai ah Barabbas an tihmi pa, ralthawh lai ah mi a thattu pa cu, ral thotu dang pawl thawn thawng an tla. ");
INSERT INTO cfm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Cun mipi pawl cu a tuahkel mangin tuah dingah Pilat sin an tiang ih an hler. ");
INSERT INTO cfm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Asinain Pilat nih a sawn hnei ih, “Judah Siangpahrang hi thlah ningla nan duh maw?” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Zangahtihle puithiam upa pawl nih an nahsuah ruangah, a kut ah an tianpit, tih a fiah. ");
INSERT INTO cfm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Asinain Barabbas sawn suah dingah puithiam upa pawl nih mipi pawl cu an forh cia. ");
INSERT INTO cfm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Cun Pilat nih a sut hnei sal ih, “Asihle Judah siangpahrang nan tihmi pa hi zangtin ka tuah ding nan duh?” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Cule an ni nih, “Thinglamtah ah that,” tiah an hek sal. ");
INSERT INTO cfm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Cun Pilat nih, “Zangruangah, zangtu thil ṭhalo a tuah?” tiah a ti. Asinain an ni nih, “Thinglamtah ah that kau,” tiah an hek hlehhlo. ");
INSERT INTO cfm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat cu mipi lungkimter a duh, Barabbas cu an hrangah a thlah. Cule Pilat nih Jesuh cu a thawiter hnei ih thinglamtah ah that dingin an kut ah a pe hnei. ");
INSERT INTO cfm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Cun ralkap pawl nih Jesuh cu uktu bawi ih tualhma ah an luhpit ih ralkap bur khat khaw an kokhawm. ");
INSERT INTO cfm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cule Jesuh cu puan sendup an hruksak ih hling ih phiar mi lukhum a lu ah an khumter. ");
INSERT INTO cfm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Cule salam pek an thok ih, “Judah Siangpahrang, upatnak ta pe!” tiah an zohsuam. ");
INSERT INTO cfm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Cun a lu ah fung thawn an thawi, cihrit an khak, an khuk an bil ih a hmai ah an kun. ");
INSERT INTO cfm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cutin an zohsuam hnukah puan sendup cu an phoihsak ih, ama a hnipuan an hruter, cule thinglamtah ah that dingah an ṭhi ta. ");
INSERT INTO cfm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cun khawte ihsin khawpi ih feh, Alexander le Rufus ih pa, Sairin khua mi Simon cu lampi ah an hmu ih, Jesuh ih thinglamtah cu a hramhram in an pu ter. ");
INSERT INTO cfm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Cule Jesuh cu Golgotha tihmi hmun ah an fehpit. Golgotha tih cu “Luruh hmun,” tihnak a i. ");
INSERT INTO cfm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Cun mura thawn nawhmi sabit ti cu an pe, asinain Jesuh nih a ding duh lo. ");
INSERT INTO cfm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cule thinglamtah ah an khen, a hnipuan cu an phat ih hutu nih zangtu bik a co thok tih fiah dingah camcawhfung zuk pit in an zem fa. ");
INSERT INTO cfm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesuh an khet can cu zingmaw nazi pakua a i. ");
INSERT INTO cfm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Cule sual an puhnak catar cu, “Judah Siangpahrang,” tiah a i. ");
INSERT INTO cfm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesuh thawn damiah panih, a vorh la ah pakhat, a keh la ah pakhat an khen ve. ");
INSERT INTO cfm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cun a hram ih vongva tu pawl nih an thangsiat ih, diriam ngaiin an lu an sut, cule, “Hei! Nang hi Biakinn bal piʼn ni thum sungah a sasaltu khi na si lo maw! ");
INSERT INTO cfm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nangma le nangma rung fa la thinglamtah cungin rong ṭum,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Cumangin puithiam upa pawl le Daanthiam pawl nih Jesuh cu an zohsuam ih, “Midang cu a rung thei, asinain ama le ma cu a rungfa thei lo. ");
INSERT INTO cfm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel siangpahrang, Khrih cu a tun rori ah thinglamtah cungin rong ṭum sehla, kan hmu thok ih kan zum thok,” tiah an ti. A ma thawn thinglamtah ih an khet mi pawl khaw nih an zohsuam ve. ");
INSERT INTO cfm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cun sun nazi hleinih a kim ih simla nazi pathum tiang ram pumpuluk ah sunkhawmaw a tlung. ");
INSERT INTO cfm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Cule simla nazi pathum ah Jesuh cu a ṭap ih, “Eloi, Eloi, lema sabachthani?” tiah thangai in a hek, a sullam cu, “Ka Pathian, ka Pathian, zangah ka na zuangta?” tihnak a i. ");
INSERT INTO cfm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Cun a hram ih a ding mi, mi hrekkhat nih an thei ih, “Ngaihnik uh, Elijah a ko,” tiah an ti. ");
INSERT INTO cfm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cule mi pakhat a va zuang ih puansia cu a hangmi sabit ti sungah a hnim ih, fung ah hri thawn a khit. Cun din dingah Jesuh sin a pe ih, “Hngak rih hnik uh, thinglamtah cung in ṭhum dingah Elijah a rong maw rong lo kan zoh hnik thok,” tiah a ti hnei. ");
INSERT INTO cfm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Cule Jesuh cu thangai in a hek ih a thaw a zom. ");
INSERT INTO cfm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cun biakinn puanzar cu a tlun zim in a tang zim tiang ṭhen nih ah a ṭhen fa. ");
INSERT INTO cfm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesuh hmaizawn ih a dingtu ralbawipa nih Jesuh ih thihdan a hmuh tikah, “Hi pa hi Pathian Fapa rori a i kau e!” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cuva ah cun lamhlat nawn in a cuan ve tu numi hrekkhat khaw an um. Cupawl cu Magdala khawnu Mary, James nauta sawn le Joses ih nu Mary, le Salome pawl an i. ");
INSERT INTO cfm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Cuvai numi pawl cu Jesuh Galilee peng ih a um laiih a thluntu le a tuamhlawmtu an i. Jesuh thawn Jerusalem ih a feh ve tu numi dang tampi khaw an tel ve. ");
INSERT INTO cfm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cun cuvai ni cu Sabbath ni phak hlan timtuahfak ni a i. ");
INSERT INTO cfm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zanla a kim tikah, Khonsil upa lak ih upat mi sungtel le Pathian Uknak a hngakhlaptu Arimathea khawmi Josef cu ralṭha ngaiin, Pilat sinah a feh ih, Jesuh ih ruak cu a hler. ");
INSERT INTO cfm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat nih Jesuh a thi cem, tih a theih tikah, a mang a bang ngai. Ralbawipa a ko ih, a thihnak rei cem im? tiah a sut. ");
INSERT INTO cfm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ralbawipa sin in Jesuh a thi cem tih a theih tikah a ruak cu Josef a la ter. ");
INSERT INTO cfm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Cun Josef cu puan nem pate a lei ih Jesuh ruak cu thinglamtah cung in a ṭhum, cule puan nem pate in a tuam ih lung an vih mi thlan ah a phum. Cun thlanka cu lung thawn in a khar ta. ");
INSERT INTO cfm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdala khawnu Mary le Joses ih nu Mary nih Jesuh an phumnak cu an hmu. ");
INSERT INTO cfm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cun Sabbath ni a net tikah, Magdala khawnu Mary, James ih nu Mary le Salome nih Jesuh ruak culh dingah zihmui an lei. ");
INSERT INTO cfm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Zarh khat ih ani khatnak, zingmaw nisuah fangah thlan ah an feh. ");
INSERT INTO cfm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cule, “Thlanka kharnak lung teh hutu nih kan na thawn sak thok?” tiah pakhat le pakhat an ti fa. ");
INSERT INTO cfm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Cule an zoh ih, lung cu thawn fa cem in an hmu. Cuvai lung cu lung hnempi a i. ");
INSERT INTO cfm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Thlan sungah cu an lut ih angki fual rang a hru mi tlangval pakhat, vorhla kap ih to cu an hmu ih — an thin a phang ngai. ");
INSERT INTO cfm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ani nih an sinah, “Nan thin phang hlah uh. Thinglamtah ih khenbet mi Nazareth mi Jesuh nan hrawl. Aiva ah a um i lo — thawhtersal a i cem! An siahnak hmun hi zoh hnik hman uh. ");
INSERT INTO cfm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Feh uhla, ‘nan hmai ah Galilee ah a feh thok, nan ta sip cia mangin cuva ah nan hmu thok,’ tiah a dungthluntu pawl le Peter cu sim uh,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Cule an suak ih thinphang le mangbang in thlan in an zuang. An ṭih tuk ruangah hu sin khaw ah zangkhaw an sim lo. Marka Thuthangṭha Netnak Sau 16.9–20  ");
INSERT INTO cfm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zarh khat ih a ni khatnak zingmaw ah, Jesuh a thosal, khawsia pasarih a dawisuakmi Magdala khawnu Mary sinah a lang hmasabik. ");
INSERT INTO cfm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Magdala khawnu Mary cu Jesuh thawn tlanglengkhat dahmi le riahsia in a ṭap mi pawl sinah a feh ih a sim hnei. ");
INSERT INTO cfm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Asinain Jesuh cu a nung tihmi le Magdala khawnu Mary nih a hmu, tihmi cu an theih tikah an zum lo. ");
INSERT INTO cfm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cuvai hnukah, Jesuh cu dungthluntu panih khawte la ih an feh lai ah phundang in an sinah a lang. ");
INSERT INTO cfm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cuvai le panih cu an kirsal ih midang pawl sinah an sim, asinain an zum lo. ");
INSERT INTO cfm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cuvai hnuk ah dungthluntu hleikhat pawl caw an ei lai ah Jesuh cu an sinah a lang. A thawhsal hnuk mi hrekkhat nih an hmuh thu a dungthluntu pawl nih an zum lo ih, an zuplonak le an lungruhnak ruangah a tai hnei. ");
INSERT INTO cfm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cun an sinah, “Leilung tlun hmahhmah ah feh uhla, cule serhsiammi zate sinah thuthang ṭha sim uh. ");
INSERT INTO cfm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hutukhaw isehla a zum ih baptisma a cotu cu rundam an i thok. Asinain a zum lotu cu hutukhaw isehla thiam lo coter a i thok. ");
INSERT INTO cfm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Cule a zumtu pawl cu hi hminsitnak pawl tuah theinak huham pek an i thok: ka hmin in khawsia an dawi thei thok; ṭon thar in an ṭon thok; ");
INSERT INTO cfm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","an kut thawn rul an la thok; thihsi an din hmanah an zangkhaw a poi thok lo; mifak cungah an kut an suang thok ih mifak cu an dam thok,” tiah a ti. ");
INSERT INTO cfm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cun an sinih thu a sip colh hnukah, Bawipa Jesuh cu van ah lakin a um ih Pathian vorh la kap ah a to. ");
INSERT INTO cfm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Cule dungthluntu pawl cu an feh ih khuazakip ah thu an sim; Bawipa cu an sinah ṭuan a ṭuan ih, mangbangza an tuahmi nih an thusim mi hi a dik, tih a langter. Marka Thuthangṭha Netnak Tawi 16.9–10  ");
INSERT INTO cfm_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","Numi pawl cu Peter le a rualpi pawl sinah an feh ih an theihmi thuhla cu a tawinak in an sim. ");
INSERT INTO cfm_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","Cuhnukah Jesuh ama rori nih kumkhua rundamnak thu le thu thianghlim cu nisuahnak in nitlaknak tiang a dungthluntu pawl hmangin a sim.");
ALTER TABLE cfm_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
