﻿USE sofia;
DROP TABLE IF EXISTS sofia.cesnkb_vpl;
CREATE TABLE cesnkb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cesnkb_vpl WRITE;
INSERT INTO cesnkb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kniha rodu Ježíše Krista, syna Davidova, syna Abrahamova: ");
INSERT INTO cesnkb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham zplodil Izáka, Izák zplodil Jákoba, Jákob zplodil Judu a jeho bratry. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judas pak zplodil Fáresa a Záru z Támary a Fáres zplodil Ezroma. Ezrom zplodil Arama. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram pak zplodil Amínadaba a Amínadab zplodil Názona. Názon zplodil Salmona. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon zplodil Boáze z Rachab a Boáz zplodil Obéda z Rút. Obéd pak zplodil Isaje. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaj zplodil krále Davida a král David zplodil Šalomouna z manželky Uriášovy. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Šalomoun zplodil Roboáma, Roboám zplodil Abiáše, Abiáš zplodil Azu, ");
INSERT INTO cesnkb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza zplodil Jozafata, Jozafat zplodil Jorama, Joram zplodil Oziáše. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziáš pak zplodil Joatama a Joatam zplodil Achaza. Achaz zplodil Ezechiáše. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezechiáš pak zplodil Manasese a Manases zplodil Amona. Amon pak zplodil Joziáše. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joziáš pak zplodil Jekoniáše a jeho bratry za babylónského zajetí. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Po zavlečení do Babylónu pak Jekoniáš zplodil Salatiela a Salatiel zplodil Zorobábela. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobábel zplodil Abiuda a Abiud zplodil Eliakima, Eliakim pak zplodil Azora. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor potom zplodil Sádocha, Sádoch zplodil Achima a Achim zplodil Eliuda. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud zplodil Eleazara, Eleazar zplodil Mátana, Mátan zplodil Jákoba. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jákob pak zplodil Josefa, muže Marie, z níž se narodil Ježíš zvaný Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A tak bylo celkem čtrnáct pokolení od Abrahama až do Davida, čtrnáct pokolení od Davida až do babylónského zajetí a čtrnáct pokolení od babylónského zajetí až do Krista. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Narození Ježíše Krista se událo takto: Když byla jeho matka Marie zasnoubena Josefovi, ještě než se sešli, ukázalo se, že je těhotná z Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ale její muž Josef byl spravedlivý a protože ji nechtěl vystavit potupě, rozhodl se propustit ji potají. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Když pak o těch věcech přemýšlel, hle, Pánův anděl se mu ukázal ve snu a řekl: “Josefe, synu Davidův, neboj se vzít si Marii za svou manželku, neboť to, co je v ní počato, je z Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Porodí pak syna a dáš mu jméno Ježíš, neboť on zachrání svůj lid od jejich hříchů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Toto všechno se stalo, aby se naplnilo to, co Pán promluvil skrze proroka, který řekl: ");
INSERT INTO cesnkb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hle, panna bude těhotná a porodí syna a dají mu jméno Emmanuel,” které se překládá: Bůh s námi. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Když se pak Josef probudil ze spánku, udělal, co mu přikázal Pánův anděl a přijal Marii za svou manželku. ");
INSERT INTO cesnkb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ale nepoznal ji až do té doby, než porodila svého prvorozeného syna; a dal mu jméno Ježíš. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Když se pak Ježíš narodil v judském Betlémě za dnů krále Heroda, hle, do Jeruzaléma přišli mágové od východu ");
INSERT INTO cesnkb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","a říkali: “Kde je ten narozený židovský král? Viděli jsme totiž na východě jeho hvězdu a přišli jsme, abychom se mu poklonili.” ");
INSERT INTO cesnkb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","To když uslyšel král Herodes, velmi se rozrušil a celý Jeruzalém s ním. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Svolal tedy všechny velekněze a učitele lidu a tázal se jich, kde se má Kristus narodit. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Oni mu řekli: “V judském Betlémě. Neboť tak je napsáno skrze proroka: ");
INSERT INTO cesnkb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ale ty, Betléme v zemi judské, nikoli nejsi nejmenší mezi knížaty judskými, neboť z tebe vyjde Panovník, který bude pást můj lid, Izrael.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tehdy Herodes tajně povolal mágy a vyptával se jich na čas, kdy se jim ta hvězda ukazovala. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A když je posílal do Betléma, řekl: “Jděte a pečlivě vyhledejte to dítě, a jakmile ho naleznete, oznamte mi to, abych i já mohl přijít a poklonit se mu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Když tedy vyslechli krále, odjeli. A hle, hvězda, kterou viděli na východě, je předcházela, až se zastavila nad místem, kde bylo to dítě. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Když tu hvězdu uviděli, zaradovali se nesmírnou radostí. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Vešli tedy do domu, nalezli dítě s Marií, jeho matkou, a padli a klaněli se mu. Potom otevřeli své poklady a obětovali mu dary: zlato, kadidlo a myrhu. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","A když dostali ve snu od Boha pokyn, aby se nevraceli k Herodovi, vrátili se do své země jinou cestou. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Když pak odjeli, hle, Josefovi se ve snu ukázal Pánův anděl a řekl: “Vstaň, vezmi dítě i jeho matku, uteč do Egypta a zůstaň tam, dokud ti nepovím; neboť Herodes se chystá to dítě hledat, aby ho zabil.” ");
INSERT INTO cesnkb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A tak v noci vstal, vzal dítě i jeho matku a odešel do Egypta ");
INSERT INTO cesnkb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","a zůstal tam až do Herodovy smrti, aby se naplnilo to, co Pán promluvil skrze proroka: “Z Egypta jsem povolal svého Syna.” ");
INSERT INTO cesnkb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Když pak Herodes poznal, že byl od mágů oklamán, nesmírně se rozhněval a dal povraždit všechny děti mužského pohlaví v Betlémě a v celém okolí od dvouletých níže, podle času, na který se vyptal mágů. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tehdy se naplnilo to, co bylo řečeno skrze proroka Jeremiáše: ");
INSERT INTO cesnkb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Hlas byl slyšet v Ráma, naříkání, pláč a mnohé úpění, Ráchel plačící nad svými dětmi; a nenechala se utěšit, protože jich už není.” ");
INSERT INTO cesnkb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Když pak Herodes zemřel, hle, Pánův anděl se ve snu ukázal Josefovi v Egyptě ");
INSERT INTO cesnkb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a řekl: “Vstaň, vezmi dítě i jeho matku a jdi do izraelské země, neboť ti, kdo usilovali o život dítěte, jsou již mrtví.” ");
INSERT INTO cesnkb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josef tedy vstal, vzal dítě i jeho matku a přišel do izraelské země. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Když však uslyšel, že v Judsku kraluje místo svého otce Heroda Archelaus, bál se tam jít. A když byl od Boha ve snu varován, obrátil se do galilejského kraje. ");
INSERT INTO cesnkb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Když tam přišel, bydlel ve městě zvaném Nazaret, aby se naplnilo to, co bylo řečeno skrze proroky - že bude nazván Nazaretský. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","V těch dnech přišel Jan Křtitel a kázal v judské poušti. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Říkal: “Čiňte pokání, protože nebeské království se přiblížilo!” ");
INSERT INTO cesnkb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","To je ten, o kterém mluvil prorok Izaiáš, když říkal: “Hlas volajícího na poušti: Připravte Pánovu cestu! Napřimujte jeho stezky!” ");
INSERT INTO cesnkb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ten Jan měl oděv z velbloudí srsti, kolem boků měl kožený pás a jeho pokrmem byly kobylky a lesní med. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vycházel k němu tehdy celý Jeruzalém, celé Judsko i celý jordánský kraj. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A když vyznávali své hříchy, křtil je v Jordánu. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Když však uviděl mnohé z farizeů a saduceů, jak jdou k jeho křtu, řekl jim: “Plemeno zmijí, kdo vám ukázal, jak utéci před přicházejícím hněvem? ");
INSERT INTO cesnkb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Proto začněte nést ovoce odpovídající vašemu pokání. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A nemyslete, že si můžete říkat: Abrahama máme za otce. Říkám vám totiž, že Bůh je schopen Abrahamovi vzbudit syny z tohoto kamení. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sekera je již přiložena ke kořeni stromů. Každý strom, který nenese dobré ovoce, tedy bude vyťat a vhozen do ohně. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jistě, já vás křtím vodou k pokání, ale ten, který přichází po mně, je silnější než já. Já nejsem hoden ani nosit jeho obuv. On vás bude křtít Duchem Svatým a ohněm. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jeho věječka je již v jeho ruce a on vyčistí svůj mlat. Svou pšenici shromáždí do obilnice, ale plevy bude pálit neuhasitelným ohněm.” ");
INSERT INTO cesnkb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tehdy přišel Ježíš z Galileje za Janem k Jordánu, aby se od něj nechal pokřtít. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ale Jan mu v tom velmi bránil. Říkal: “Já potřebuji být pokřtěn od tebe a ty přicházíš za mnou?” ");
INSERT INTO cesnkb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ježíš mu však odpověděl: “Dopusť to teď, protože takto máme naplnit veškerou spravedlnost.” A tak ho nechal. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","A když byl Ježíš pokřtěn, vystoupil ihned z vody, a hle, otevřela se mu nebesa a spatřil Božího Ducha, jak sestupuje z nebe jako holubice a přichází na něj. ");
INSERT INTO cesnkb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A hle, hlas z nebe řekl: “Toto je můj milovaný Syn, v němž jsem nalezl zalíbení.” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tehdy byl Ježíš veden Duchem na poušť, aby byl pokoušen od ďábla. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A poté, co se postil čtyřicet dní a čtyřicet nocí, vyhladověl. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tehdy k němu přistoupil Pokušitel a řekl: “Jsi-li Boží Syn, řekni, ať se z tohoto kamení stanou chleby.” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ale on odpověděl: “Je napsáno: ‘Nejen chlebem bude člověk živ, ale každým slovem, které vychází z Božích úst.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pak ho ďábel vzal do svatého města, postavil ho na vrcholek chrámu ");
INSERT INTO cesnkb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a řekl mu: “Jsi-li Boží Syn, vrhni se dolů! Vždyť je napsáno: ‘Svým andělům přikáže o tobě a ponesou tě na rukou, abys snad nenarazil nohou na kámen.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ježíš mu řekl: “Opět je napsáno: ‘Nebudeš pokoušet Pána, svého Boha.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ďábel ho zase vzal na velmi vysokou horu a ukázal mu všechna království světa a jejich slávu ");
INSERT INTO cesnkb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","a řekl mu: “Toto všechno ti dám, když padneš na zem a pokloníš se mi.” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tehdy mu Ježíš řekl: “Odejdi, Satane! Vždyť je napsáno: ‘Pánu, svému Bohu, se budeš klanět a jemu jedinému budeš sloužit.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tehdy ho ďábel opustil a hle, přistoupili andělé a sloužili mu. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Když Ježíš uslyšel, že Jan byl uvězněn, vrátil se do Galileje. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Opustil Nazaret a přišel bydlet do Kafarnaum u moře, v krajinách Zabulón a Neftalí, ");
INSERT INTO cesnkb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","aby se naplnilo to, co bylo řečeno skrze proroka Izaiáše: ");
INSERT INTO cesnkb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Země Zabulón a země Neftalí, při cestě k moři, za Jordánem, Galilea pohanských národů: ");
INSERT INTO cesnkb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","lid, který bydlel v temnosti, uviděl veliké světlo a těm, kteří seděli v krajině a stínu smrti, světlo se zaskvělo.” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Od té doby začal Ježíš kázat. Říkal: “Čiňte pokání, protože nebeské království se přiblížilo.” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Když se pak Ježíš procházel podél Galilejského moře, uviděl dva bratry, Šimona zvaného Petr a Ondřeje, jeho bratra, jak házejí síť do moře (protože to byli rybáři), ");
INSERT INTO cesnkb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","a řekl jim: “Pojďte za mnou a udělám z vás rybáře lidí!” ");
INSERT INTO cesnkb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","A oni hned opustili sítě a šli za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Když pak odtud poodešel, uviděl jiné dva bratry, Jakuba Zebedeova a jeho bratra Jana, jak na lodi se svým otcem Zebedeem spravují sítě, a povolal i je. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A oni hned opustili loď i svého otce a šli za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ježíš pak procházel celou Galileu, vyučoval v jejich synagogách, kázal evangelium království a uzdravoval každou nemoc a každý neduh v lidu. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Zpráva o něm se roznesla i po celé Sýrii, a tak k němu přiváděli všechny nemocné, sužované různými neduhy a bolestmi, posedlé, náměsíčníky a ochrnuté a on je uzdravil. ");
INSERT INTO cesnkb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A šly za ním veliké zástupy z Galileje a z Dekapole, i z Jeruzaléma, z Judska a ze Zajordánska. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Když pak Ježíš uviděl zástupy, vystoupil na horu, a když se posadil, přistoupili k němu jeho učedníci. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tehdy otevřel ústa a začal je vyučovat. Říkal: ");
INSERT INTO cesnkb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blaze chudým v duchu, neboť jim patří nebeské království. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Blaze plačícím, neboť oni budou potěšeni. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Blaze mírným, neboť oni přijmou zemi za své dědictví. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Blaze těm, kdo hladovějí a žízní po spravedlnosti, neboť oni budou nasyceni. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Blaze milosrdným, neboť jim se dostane milosrdenství. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Blaze čistým v srdci, neboť oni uvidí Boha. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Blaze těm, kdo působí pokoj, neboť oni budou nazváni Božími syny. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Blaze těm, kdo jsou pronásledováni pro spravedlnost, neboť jejich je nebeské království. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Blaze vám, když vám budou zlořečit a pronásledovat vás a lživě proti vám mluvit všechno zlé kvůli mně. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Radujte se a jásejte, protože vaše odplata v nebesích je veliká. Takto totiž pronásledovali proroky, kteří byli před vámi.” ");
INSERT INTO cesnkb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Vy jste sůl země. Jestliže však sůl ztratí svou chuť, čím bude osolena? Není už dobrá k ničemu, jen se vyhodí ven a lidé ji pošlapou. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Vy jste světlo světa. Město ležící na hoře nemůže být skryto. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Také nerozsvěcují lampu, aby ji postavili pod nádobu, ale na stojan a tehdy osvětluje všechny, kdo jsou v domě. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tak nechte své světlo zářit před lidmi, ať vidí vaše dobré skutky a vzdají slávu vašemu Otci, který je v nebesích.” ");
INSERT INTO cesnkb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nemyslete si, že jsem přišel zrušit Zákon nebo Proroky. Nepřišel jsem je zrušit, ale naplnit. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Amen, říkám vám: Dokud nepomine nebe a země, nepomine ani nejmenší písmenko, ani jediná čárka ze Zákona, než se všechny ty věci stanou. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Proto, kdokoli by zrušil jedno z těchto nejmenších přikázání a tak by učil lidi, bude v nebeském království nazýván nejmenším. Ale kdokoli by je plnil a učil, ten bude v nebeském království nazýván velikým. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Říkám vám totiž, že pokud vaše spravedlnost nebude omnoho převyšovat spravedlnost zákoníků a farizeů, nikdy nevstoupíte do nebeského království.” ");
INSERT INTO cesnkb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Slyšeli jste, že předkům bylo řečeno: ‘Nezabiješ,’ a kdokoli by zabil, bude vydán soudu. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Já vám však říkám, že každý, kdo se bezdůvodně zlobí na svého bratra, bude vydán soudu. Kdokoli by řekl svému bratru: ‘Ráka!’ bude vydán veleradě, a kdokoli by řekl: ‘Blázne!’ bude vydán pekelnému ohni. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","A proto, když bys obětoval na oltáři svůj dar a tam si vzpomněl, že tvůj bratr má něco proti tobě, ");
INSERT INTO cesnkb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nech svůj dar tam před oltářem a jdi a nejprve se smiř se svým bratrem a potom přijď a obětuj svůj dar. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dohodni se se svým odpůrcem rychle, dokud jsi s ním na cestě, aby tě tvůj odpůrce nevydal soudci a soudce zřízenci a byl bys vsazen do vězení. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Amen, říkám ti: Rozhodně odtamtud nevyjdeš, dokud nevrátíš poslední haléř.” ");
INSERT INTO cesnkb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Slyšeli jste, že předkům bylo řečeno: ‘Nezcizoložíš.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Já vám však říkám, že každý, kdo by se chtivě podíval na ženu, už s ní zcizoložil ve svém srdci. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pokud tě tedy svádí tvé pravé oko, vyloupni je a zahoď od sebe. Je přece pro tebe prospěšnější, aby zahynul jeden tvůj úd, než aby bylo celé tvé tělo uvrženo do pekla. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A pokud tě svádí tvá pravá ruka, usekni ji a zahoď od sebe. Je přece pro tebe prospěšnější, aby zahynul jeden tvůj úd, než aby celé tvé tělo bylo uvrženo do pekla. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Také bylo řečeno: ‘Kdokoli by propustil svou manželku, ať jí dá potvrzení o rozvodu.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Já vám ale říkám, že každý, kdo propouští svou manželku (kromě případu smilstva), přivádí ji k cizoložství a každý, kdo by si tu propuštěnou vzal, cizoloží.” ");
INSERT INTO cesnkb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Slyšeli jste také, že předkům bylo řečeno: ‘Nebudeš křivě přísahat’ a ‘Splníš své přísahy Pánu.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Já vám však říkám, abyste vůbec nepřísahali, ani při nebi, protože to je Boží trůn, ");
INSERT INTO cesnkb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ani při zemi, protože to je podnož jeho nohou, ani při Jeruzalému, protože to je město toho velikého Krále. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nepřísahej ani na svou hlavu, protože nemůžeš jediný vlas udělat bílým nebo černým. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ať je tedy vaše slovo ‘Ano’ ano a ‘Ne’ ne. Co je nad to, je od zlého.” ");
INSERT INTO cesnkb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Slyšeli jste, že bylo řečeno: ‘Oko za oko a zub za zub.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Já vám však říkám, abyste neodporovali zlému člověku, ale kdokoli tě udeří do pravé tváře, nastav mu i druhou. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A jestli se s tebou někdo chce soudit a vzít ti košili, nech mu i plášť. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A když tě někdo bude nutit jít jednu míli, jdi s ním dvě. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tomu, kdo tě prosí, dávej a od toho, kdo si od tebe chce vypůjčit, se neodvracej.” ");
INSERT INTO cesnkb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Slyšeli jste, že bylo řečeno: ‘Budeš milovat svého bližního a nenávidět svého nepřítele.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Já vám však říkám: Milujte své nepřátele! Žehnejte těm, kdo vás proklínají, konejte dobro těm, kdo vás nenávidí, a modlete se za ty, kdo vás pomlouvají a pronásledují, ");
INSERT INTO cesnkb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","abyste byli synové svého Otce, který je v nebesích. Vždyť on dává svému slunci vycházet na dobré lidi i na zlé a posílá déšť na spravedlivé i nespravedlivé. ");
INSERT INTO cesnkb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Když totiž milujete jen ty, kdo milují vás, jakou máte odplatu? Nedělají snad i celníci totéž? ");
INSERT INTO cesnkb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A když zdravíte jen své bratry, co mimořádného děláte? Nedělají to snad i celníci? ");
INSERT INTO cesnkb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Buďte tedy dokonalí, jako je dokonalý váš Otec, který je v nebesích.” ");
INSERT INTO cesnkb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Dávejte si pozor, abyste nedělali své milosrdné skutky před lidmi proto, aby vás viděli. Jinak totiž nemáte odplatu u svého Otce, který je v nebesích. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Proto když prokazuješ milosrdenství chudým, nevytrubuj před sebou, jako to dělají pokrytci v synagogách a na ulicích, aby se nechali chválit od lidí. Amen, říkám vám, že už mají svou odplatu. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ale když ty prokazuješ milosrdenství, ať tvá levice neví, co dělá pravice, ");
INSERT INTO cesnkb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","aby tvé milosrdenství bylo vskrytu. A tvůj Otec, který vidí vskrytu, ti odplatí zjevně.” ");
INSERT INTO cesnkb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“A když se modlíš, nebuď jako pokrytci. Ti totiž při modlitbě rádi postávají v synagogách a na nárožích ulic, aby se ukazovali lidem. Amen, říkám vám, že už mají svou odplatu. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ale ty, když se modlíš, vejdi do svého pokojíku, a když zavřeš dveře, modli se ke svému Otci, který je vskrytu. A tvůj Otec, který vidí vskrytu, ti odplatí zjevně. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Když se tedy modlíte, neříkejte prázdná slova jako pohané. Ti si totiž myslí, že budou vyslyšeni pro množství svých slov. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nebuďte jim tedy podobní, protože váš Otec ví, co potřebujete, ještě předtím, než ho poprosíte. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Proto se modlete takto: Otče náš, který jsi v nebesích, ať se posvětí tvé jméno! ");
INSERT INTO cesnkb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ať přijde tvé království! Ať se stane tvoje vůle jako v nebi, tak i na zemi. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dej nám dnes náš každodenní chléb, ");
INSERT INTO cesnkb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","a odpusť nám naše viny, jako i my odpouštíme našim viníkům. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A neuveď nás do pokušení, ale vysvoboď nás od zlého. Neboť tvé je království i moc i sláva navěky. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Odpustíte-li totiž lidem jejich prohřešky, odpustí váš nebeský Otec i vám. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ale jestliže lidem neodpustíte jejich prohřešky, pak ani váš Otec neodpustí vaše prohřešky vám.” ");
INSERT INTO cesnkb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“A když se postíte, nebuďte zasmušilí jako pokrytci, kteří hyzdí své tváře, aby ukázali lidem, že se postí. Amen, říkám vám, že už mají svou odplatu. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ale ty, když se postíš, pomaž si hlavu olejem a umyj si tvář, ");
INSERT INTO cesnkb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","aby tvůj půst nebyl zjevný lidem, ale tvému Otci, který je vskrytu. A tvůj Otec, který vidí vskrytu, ti odplatí zjevně.” ");
INSERT INTO cesnkb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nehromaďte si poklady na zemi, kde je ničí mol a rez a kde zloději vykopávají a kradou, ");
INSERT INTO cesnkb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ale hromaďte si poklady v nebi, kde je mol a rez neničí a zloději nevykopávají ani nekradou. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Vždyť kde je váš poklad, tam bude i vaše srdce. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lampou těla je oko. Pokud je tedy tvé oko prosté, celé tvé tělo bude jasné. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ale pokud je tvé oko zlé, celé tvé tělo bude temné. Je-li tedy světlo v tobě tmou, jak veliká bude tma?! ");
INSERT INTO cesnkb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nikdo nemůže sloužit dvěma pánům. Buď totiž bude jednoho nenávidět a druhého milovat, nebo se bude toho jednoho držet a tím druhým pohrdne. Nemůžete sloužit Bohu i mamonu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Proto vám říkám: Nemějte starost o svůj život, co byste jedli a co pili, ani o své tělo, co byste si oblékali. Není snad život víc než pokrm a tělo víc než oděv? ");
INSERT INTO cesnkb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pohleďte na ptáky na nebi. Nesejí, nesklízejí ani neshromažďují do stodol, a váš nebeský Otec je živí. Nejste snad vy mnohem dražší? ");
INSERT INTO cesnkb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kdo z vás může pečlivým staráním přidat ke své výšce jediný loket? ");
INSERT INTO cesnkb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Proč si tedy děláte starosti s oblečením? Pomyslete na polní lilie, jak rostou. Nepracují ani nepředou, ");
INSERT INTO cesnkb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ale říkám vám, že ani Šalomoun ve vší své slávě nebyl oblečen jako jedna z nich. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jestliže tedy Bůh takto obléká polní trávu, která dnes je a zítra bude hozena do pece, neoblékne snad mnohem spíš vás, vy malověrní? ");
INSERT INTO cesnkb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nemějte tedy starosti. Neříkejte: ‘Co budeme jíst?’ nebo ‘Co budeme pít?’ anebo ‘Co si oblečeme?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Všechny tyto věci totiž vyhledávají pohané, ale váš nebeský Otec ví, že to všechno potřebujete. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hledejte nejprve Boží království a jeho spravedlnost a toto vše vám bude přidáno. ");
INSERT INTO cesnkb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nemějte tedy starost o zítřek, neboť zítřek se bude starat o své věci. Den má dost svého trápení.” ");
INSERT INTO cesnkb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nesuďte, abyste nebyli souzeni. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jakým soudem totiž soudíte, takovým budete souzeni, a jakou mírou měříte, takovou vám bude zase odměřeno. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Proč tedy vidíš třísku v oku svého bratra, ale trámu ve svém oku si nevšímáš? ");
INSERT INTO cesnkb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A jak můžeš říci svému bratru: ‘Nech mě, ať ti vytáhnu z oka třísku,’ a hle, ve tvém oku je trám! ");
INSERT INTO cesnkb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pokrytče, vytáhni nejdříve trám ze svého oka a tehdy prohlédneš, abys vytáhl třísku z oka svého bratra. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nedávejte svaté věci psům a neházejte své perly před svině, aby je snad svýma nohama nepošlapaly, neotočily se a neroztrhaly vás.” ");
INSERT INTO cesnkb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Proste a bude vám dáno, hledejte a naleznete, tlučte a bude vám otevřeno. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Neboť každý, kdo prosí, dostává, a kdo hledá, nalézá a tomu, kdo tluče, bude otevřeno. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kdo z vás je takový člověk, že podá svému synu kámen, když ho poprosí o chléb? ");
INSERT INTO cesnkb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A když poprosí o rybu, dá mu snad hada? ");
INSERT INTO cesnkb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jestliže tedy vy, kteří jste zlí, umíte dávat svým dětem dobré dary, čím více váš Otec, který je v nebesích, dá dobré věci těm, kdo ho prosí?” ");
INSERT INTO cesnkb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“A proto všechno, co chcete, aby lidé dělali vám, stejně i vy dělejte jim, neboť v tom spočívá Zákon i Proroci. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Vcházejte těsnou branou. Prostorná je brána a široká cesta, která vede do záhuby, a mnoho je těch, kdo vcházejí skrze ni, ");
INSERT INTO cesnkb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","neboť těsná je brána a úzká cesta, která vede k životu, a málo je těch, kdo ji nalézají.” ");
INSERT INTO cesnkb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Dávejte si pozor na falešné proroky, kteří k vám přicházejí v ovčím rouše, ale uvnitř jsou to draví vlci. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Poznáte je podle jejich ovoce. Sklízejí se snad hrozny z trní a fíky z bodláčí? ");
INSERT INTO cesnkb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tak tedy každý dobrý strom nese dobré ovoce a špatný strom nese zlé ovoce. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Dobrý strom nemůže nést zlé ovoce a špatný strom nemůže nést dobré ovoce. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Každý strom, který nenese dobré ovoce, bývá vyťat a vhozen do ohně. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","A proto je poznáte podle jejich ovoce. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ne každý, kdo mi říká ‘Pane, Pane’, vejde do nebeského království, ale ten, kdo koná vůli mého Otce, který je v nebesích. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mnozí mi v ten den řeknou: ‘Pane, Pane, copak jsme ve tvém jménu neprorokovali? Nevymítali jsme ve tvém jménu démony a nedělali jsme ve tvém jménu mnoho zázraků?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A tehdy jim vyznám: ‘Nikdy jsem vás neznal. Odejděte ode mě, vy, kdo konáte nepravost!’” ");
INSERT INTO cesnkb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kdokoli tedy slyší tato má slova a plní je, bude podobný moudrému muži, který postavil svůj dům na skále. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pak padl déšť a přišly záplavy a vály větry a udeřily na ten dům, ale nespadl, protože byl založen na skále. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ale každý, kdo slyší tato má slova a neplní je, bude podobný bláznivému muži, který postavil svůj dům na písku. ");
INSERT INTO cesnkb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pak padl déšť a přišly záplavy a vály větry a udeřily na ten dům a spadl a jeho pád byl veliký.” ");
INSERT INTO cesnkb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Když Ježíš dokončil tuto řeč, stalo se, že zástupy žasly nad jeho učením, ");
INSERT INTO cesnkb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","protože je vyučoval jako ten, kdo má moc, a ne jako zákoníci. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Když pak sestupoval z hory, šly za ním veliké zástupy. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A hle, přišel malomocný a klaněl se mu se slovy: “Pane, kdybys jen chtěl, můžeš mě očistit.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ježíš vztáhl ruku, dotkl se ho a řekl: “Chci, buď očištěn!” A jeho malomocenství bylo ihned očištěno. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tehdy mu Ježíš řekl: “Dej pozor, abys to nikomu neříkal. Jdi ale, ukaž se knězi a obětuj Bohu ten dar, který přikázal Mojžíš, na svědectví pro ně.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","A když Ježíš vcházel do Kafarnaum, přistoupil k němu římský setník a prosil ho: ");
INSERT INTO cesnkb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Pane, můj služebník leží doma raněn mrtvicí a strašně trpí.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ježíš mu řekl: “Já přijdu a uzdravím ho.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Setník však odpověděl: “Pane, nejsem hoden, abys vešel pod mou střechu, ale jen řekni slovo a můj služebník bude uzdraven. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vždyť i já jsem člověk pod mocí a mám pod sebou vojáky. Tomuto řeknu ‘Jdi’ a on jde a jinému ‘Přijď’ a on přijde; svému otroku řeknu ‘Udělej tohle’ a udělá to.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Když to Ježíš uslyšel, podivil se a řekl těm, kdo šli za ním: “Amen, říkám vám, že ani v Izraeli jsem tak velikou víru nenašel. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Říkám vám, že mnozí přijdou od východu i od západu a budou stolovat s Abrahamem, Izákem a Jákobem v nebeském království. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ale synové království budou vyvrženi do té venkovní tmy. Tam bude pláč a skřípění zubů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tomu setníkovi pak Ježíš řekl: “Jdi, ať se ti stane, jak jsi uvěřil.” A jeho služebník byl v tu chvíli uzdraven. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Když pak Ježíš přišel do Petrova domu, uviděl jeho tchyni, jak leží a má horečku. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dotkl se tedy její ruky, horečka ji opustila a ona vstala a začala je obsluhovat. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Když potom nastal večer, přivedli k němu mnoho lidí posedlých démony a on ty duchy vymítal slovem a uzdravil všechny nemocné, ");
INSERT INTO cesnkb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","aby se naplnilo to, co bylo řečeno skrze proroka Izaiáše: “On sňal naše slabosti a odnesl naše nemoci.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Když pak Ježíš kolem sebe uviděl veliké zástupy, přikázal učedníkům, aby se přeplavili na druhou stranu. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tehdy k němu přistoupil jeden zákoník a řekl mu: “Mistře, budu tě následovat, kamkoli půjdeš.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ježíš mu tedy řekl: “Lišky mají doupata a nebeští ptáci hnízda, ale Syn člověka nemá, kde by složil hlavu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tehdy mu řekl jiný z jeho učedníků: “Pane, dovol mi nejdřív odejít a pochovat svého otce.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ježíš mu však řekl: “Pojď za mnou a nech mrtvé, ať pochovávají své mrtvé.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Potom vstoupil na loď a jeho učedníci ho následovali. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na moři pak náhle nastala veliká bouře, takže vlny přikrývaly loď. On však spal. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Přistoupili tedy a vzbudili ho se slovy: “Pane, zachraň nás, vždyť hyneme!” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ježíš jim ale řekl: “Proč se bojíte, malověrní?” Tehdy vstal a napomenul vítr i moře a nastal naprostý klid. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A ti muži žasli a říkali: “Co je tohle za člověka, že ho poslouchá i vítr a moře?” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Když se pak přeplavil na druhou stranu do kraje Gergezenců, setkali se s ním dva lidé posedlí démony, kteří vyšli z hrobů a byli velmi nebezpeční, takže nikdo nemohl chodit tou cestou. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A hle, křičeli: “Co je ti do nás, Ježíši, Boží Synu? Přišel jsi sem, abys nás předčasně trýznil?” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Daleko od nich se páslo veliké stádo vepřů ");
INSERT INTO cesnkb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","a ti démoni ho prosili: “Jestliže nás vymítáš, dovol nám odejít do toho stáda vepřů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","On jim tedy řekl: “Jděte!” A oni vyšli, vstoupili do toho stáda vepřů, a hle, celé stádo se rozběhlo ze srázu dolů do moře a zahynulo ve vodách. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ti, kdo je pásli, pak utekli, a když přišli do města, všechno vyprávěli - totiž to o těch posedlých. ");
INSERT INTO cesnkb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A hle, celé město vyšlo Ježíši naproti, a jakmile ho uviděli, žádali ho, aby odešel z jejich kraje. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Vstoupil tedy na loď, přeplavil se a přišel do svého města. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","A hle, přinesli mu ochrnutého člověka ležícího na lůžku. Když Ježíš uviděl jejich víru, řekl ochrnutému: “Buď dobré mysli, synu, tvé hříchy jsou ti odpuštěny.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A hle, někteří ze zákoníků si řekli: “Ten člověk se rouhá!” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A když Ježíš viděl jejich myšlení, řekl: “Proč si v srdcích myslíte zlé věci? ");
INSERT INTO cesnkb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Vždyť co je snadnější? Říci: Jsou ti odpuštěny hříchy, anebo říci: Vstaň a choď? ");
INSERT INTO cesnkb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ale abyste věděli, že Syn člověka má na zemi moc odpouštět hříchy” - tehdy pověděl ochrnutému - “Vstaň, vezmi své lůžko a jdi domů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A on vstal a odešel domů. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Když to tedy uviděly zástupy, užasly a vzdaly slávu Bohu, který dal takovou moc lidem. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Když potom šel Ježíš odtud, uviděl člověka jménem Matouš, jak sedí na celnici, a řekl mu: “Pojď za mnou.” A on vstal a šel za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Když pak Ježíš seděl za stolem v jeho domě, hle, stalo se, že přišlo mnoho celníků a hříšníků a stolovali s Ježíšem a jeho učedníky. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Když to uviděli farizeové, řekli jeho učedníkům: “Proč váš mistr jí s celníky a hříšníky?” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ježíš to však uslyšel a řekl jim: “Lékaře nepotřebují zdraví, ale nemocní. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jděte a naučte se, co znamená: ‘Milosrdenství chci, a ne oběť.’ Nepřišel jsem totiž volat spravedlivé, ale hříšné k pokání.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Potom k němu přišli učedníci Jana Křtitele a ptali se: “Jak to, že my a farizeové se postíme často, ale tvoji učedníci se nepostí?” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ježíš jim řekl: “Mohou ženichovi přátelé truchlit, dokud je ženich s nimi? Přijdou dny, kdy od nich bude ženich vzat, a tehdy se budou postit. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nikdo přece nepřišívá záplatu z nové látky na starý plášť, neboť ta záplata odtrhne i kus roucha a díra je ještě horší. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Také se nelije nové víno do starých nádob. Jinak se nádoby roztrhnou, víno se vylije a nádoby se zničí. Nové víno se přece lije do nových nádob a tak se obojí zachová.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zatímco k nim mluvil tyto věci, náhle k němu přistoupil představený synagogy a klaněl se mu se slovy: “Moje dcera právě zemřela. Ale pojď, vlož na ni ruku a bude žít!” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ježíš tedy vstal a šel za ním a jeho učedníci také. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A náhle se zezadu přiblížila žena, která dvanáct let trpěla krvácením, a dotkla se cípu jeho roucha. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","(Řekla si totiž: “Jestli se jenom dotknu jeho roucha, budu uzdravena.”) ");
INSERT INTO cesnkb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ježíš se otočil, a když ji uviděl, řekl: “Buď dobré mysli, dcero. Tvá víra tě uzdravila.” A od té chvíle byla uzdravena. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Když pak Ježíš přišel do domu představeného synagogy, uviděl hudebníky a hlučný zástup kvílících ");
INSERT INTO cesnkb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a řekl jim: “Odejděte, protože ta dívka neumřela, ale spí.” A oni se mu vysmívali. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Když byl ale zástup vyveden, Ježíš vstoupil dovnitř a vzal ji za ruku a ta dívka vstala. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A zpráva o tom se roznesla po celé té zemi. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Když odtud Ježíš odcházel, šli za ním dva slepci, kteří volali a říkali: “Smiluj se nad námi, synu Davidův!” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Když pak přišel domů, ti slepci k němu přistoupili a Ježíš jim řekl: “Věříte, že jsem schopen to udělat?” Oni řekli: “Ano, Pane.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tehdy se dotkl jejich očí a řekl: “Staň se vám podle vaší víry.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A jejich oči se otevřely. Ježíš je pak přísně napomenul a řekl jim: “Dejte pozor, ať se to nikdo nedozví.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ale oni vyšli a roznesli zprávu o něm po celé té zemi. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A když odcházeli, náhle k němu přivedli němého člověka posedlého démonem. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Když pak byl ten démon vyhnán, němý začal mluvit. Lidé v zástupu tedy užasli a říkali: “Nic takového nebylo nikdy vídáno v Izraeli!” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farizeové však říkali: “Vymítá démony skrze knížete démonů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ježíš tedy obcházel všechna města a vesnice, vyučoval v jejich synagogách, kázal evangelium království a uzdravoval každou nemoc a každý neduh mezi lidmi. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A když viděl zástupy, byl pohnut soucitem k nim, protože byli zesláblí a rozptýlení jako ovce nemající pastýře. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tehdy řekl svým učedníkům: “Žeň je jistě veliká, ale dělníků málo. ");
INSERT INTO cesnkb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Proto proste Pána žně, ať vypudí dělníky na svou žeň.” ");
INSERT INTO cesnkb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Potom svolal svých dvanáct učedníků a dal jim moc nad nečistými duchy, aby je vymítali a aby uzdravovali každou nemoc a každý neduh. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jména dvanácti apoštolů jsou pak tato: Nejprve Šimon zvaný Petr a jeho bratr Ondřej, potom Jakub Zebedeův a jeho bratr Jan, ");
INSERT INTO cesnkb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip a Bartoloměj, Tomáš a celník Matouš, Jakub Alfeův a Lebeus příjmením Tadeáš ");
INSERT INTO cesnkb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Šimon Kananita a Jidáš Iškariotský, ten, který ho také zradil. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Těchto dvanáct Ježíš vyslal a přikázal jim: “Nechoďte na cestu pohanů a nevstupujte do města Samaritánů, ");
INSERT INTO cesnkb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ale raději jděte ke ztraceným ovcím z Izraelova domu. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jděte a kažte: Nebeské království se přiblížilo! ");
INSERT INTO cesnkb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nemocné uzdravujte, malomocné očišťujte, mrtvé křiste, démony vymítejte. Zadarmo jste dostali, zadarmo dejte. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Neberte si zlato, stříbro, ani peníze do opasků, ");
INSERT INTO cesnkb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ani mošnu na cestu, ani dvě košile, ani obuv, ani hůl, protože dělník je hoden svého pokrmu. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","A když vejdete do kteréhokoli města nebo vesnice, zeptejte se tam, kdo je toho hoden, a u něj zůstaňte, dokud neodejdete. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Když pak přicházíte do domácnosti, pozdravte ji. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A bude-li toho ten dům hoden, ať váš pokoj přijde na něj. Pokud však nebude hoden, ať se váš pokoj navrátí k vám. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A kdokoli vás nepřijme a nebude poslouchat vaše slova, vyjděte z toho domu nebo města a vyklepte jeho prach ze svých nohou. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Amen, říkám vám, že v soudný den bude sodomské a gomorské zemi lehčeji než tomu městu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Hle, posílám vás jako ovce mezi vlky, proto buďte chytří jako hadi a bezelstní jako holubice. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dejte si však pozor na lidi, protože vás budou vydávat soudům a bičovat vás ve svých shromážděních. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Budete kvůli mně vedeni i před vládce a krále, na svědectví pro ně a pro národy. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ale když vás jim vydají, nestarejte se, jak a co byste řekli, neboť to, co máte říci, vám bude dáno v tu chvíli. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nejste to totiž vy, kdo mluví, ale Duch vašeho Otce, který mluví ve vás. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bratr pak vydá bratra na smrt, i otec syna a děti povstanou proti rodičům a zabijí je. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A všichni vás budou kvůli mému jménu nenávidět, ale kdo vytrvá až do konce, ten bude spasen. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kdyby vás tedy v tom městě pronásledovali, utečte do jiného. Amen, říkám vám totiž, že neprojdete izraelská města, než přijde Syn člověka. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Není učedník nad mistra ani služebník nad svého pána. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pro učedníka je dost na tom, když bude jako jeho mistr a služebník jako jeho pán. Jestliže hospodáře nazvali Belzebulem, čím spíše jeho domácí?” ");
INSERT INTO cesnkb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Proto se jich nebojte, neboť není nic skrytého, co nebude zjeveno, ani nic tajného, co nebude poznáno. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Co vám říkám ve tmě, mluvte na světle, a co slyšíte šeptat do ucha, kažte na střechách. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A nebojte se těch, kdo zabíjejí tělo, ale duši zabít nemohou, ale raději se bojte Toho, který může duši i tělo zahubit v pekle. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Copak se neprodávají dva vrabci za haléř? A ani jeden z nich nepadne na zem bez vědomí vašeho Otce. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Vám jsou ale spočítány i všechny vlasy na hlavě! ");
INSERT INTO cesnkb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Proto se nebojte. Jste dražší než mnoho vrabců.” ");
INSERT INTO cesnkb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kdokoli mne tedy vyzná před lidmi, toho i já vyznám před svým Otcem, který je v nebesích. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kdo by mne ale před lidmi zapřel, toho i já zapřu před svým Otcem, který je v nebesích. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nemyslete si, že jsem přišel na zem přinést pokoj. Nepřišel jsem přinést pokoj, ale meč. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Přišel jsem, abych rozdělil člověka proti jeho otci, dceru proti její matce a nevěstu proti její tchýni. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A nepřátelé člověka budou ti z jeho vlastní rodiny. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kdo má rád otce nebo matku více nežli mne, není mě hoden, a kdo má rád syna nebo dceru více nežli mne, není mě hoden. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","A kdo nebere svůj kříž a nenásleduje mne, není mě hoden. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kdo nalezne svou duši, ten ji ztratí, a kdo ztratí svou duši kvůli mně, ten ji nalezne.” ");
INSERT INTO cesnkb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kdo vás přijímá, ten přijímá mne, a kdo přijímá mne, přijímá Toho, který mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kdo přijímá proroka jako proroka, dostane odplatu proroka, a kdo přijímá spravedlivého jako spravedlivého, dostane odplatu spravedlivého. ");
INSERT INTO cesnkb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A kdokoli by dal jednomu z těchto maličkých k pití jen pohár studené vody, protože je to můj učedník, říkám vám jistě, že rozhodně neztratí svou odplatu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Když Ježíš přestal dávat svým učedníkům tato přikázání, stalo se, že odtud vyšel, aby učil a kázal v jejich městech. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Když pak Jan ve vězení uslyšel o Kristových skutcích, poslal dva ze svých učedníků, ");
INSERT INTO cesnkb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","aby se ho zeptal: “Jsi ty Ten, který má přijít, nebo máme čekat jiného?” ");
INSERT INTO cesnkb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ježíš jim odpověděl: “Jděte a oznamte Janovi, co slyšíte a vidíte: ");
INSERT INTO cesnkb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Slepí vidí, chromí chodí, malomocní jsou očišťováni, hluší slyší, mrtví jsou kříšeni a chudým se káže evangelium. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A blaze tomu, kdo se nade mnou nepohoršuje.” ");
INSERT INTO cesnkb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","A když ti muži odešli, Ježíš začal zástupům říkat o Janovi: “Co jste si přišli do pouště prohlédnout? Třtinu klátící se větrem? ");
INSERT INTO cesnkb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na co jste se tedy vyšli podívat? Na člověka oblečeného hebkým rouchem? Pohleďte, ti, kdo se oblékají hebkým rouchem, jsou v královských domech. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Co jste tedy vyšli vidět? Proroka? Ano, říkám vám, a více než proroka. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Toto je ten, o kterém je napsáno: ‘Hle, já před tvou tváří posílám svého posla, který připraví tvou cestu před tebou.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Amen, říkám vám, že mezi těmi, kdo se narodili z žen, nepovstal větší než Jan Křtitel, ale kdo je nejmenší v nebeském království, je větší než on. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ode dnů Jana Křtitele až dosud nebeské království snáší násilí a násilníci ho uchvacují. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Neboť všichni Proroci i Zákon až po Jana o tom prorokovali. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A jste-li to ochotni přijmout, on je ten Eliáš, který měl přijít. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kdo má uši k slyšení, ať slyší. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ke komu ale přirovnám toto pokolení? Je podobné dětem, které sedí na tržišti a volají na druhé: ");
INSERT INTO cesnkb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Pískali jsme vám a netančili jste; žalostně jsme naříkali a neplakali jste!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jan totiž přišel, nejedl a nepil a oni říkají: ‘Má démona!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Přišel Syn člověka, jí a pije a říkají: ‘Hle, žrout a pijan vína, přítel celníků a hříšníků!’ Ale moudrost je ospravedlněna svými dětmi.” ");
INSERT INTO cesnkb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tehdy začal vyčítat městům, ve kterých se stalo nejvíce jeho zázraků, že nečinila pokání: ");
INSERT INTO cesnkb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Běda tobě, Korozaim, běda tobě, Betsaido! Vždyť kdyby se zázraky, které se dějí u vás, staly v Týru a Sidonu, dávno by v pytlovině a v popelu činili pokání. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A tak vám říkám: Týru a Sidonu bude v soudný den lehčeji než vám. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ty, Kafarnaum, které jsi až k nebi vyvýšeno, až do pekla budeš svrženo. Vždyť kdyby se zázraky, které se dějí v tobě, staly v Sodomě, zůstala by stát až dodnes. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A tak vám říkám, že sodomské zemi bude v soudný den lehčeji než tobě.” ");
INSERT INTO cesnkb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tehdy Ježíš odpověděl: “Chválím tě, Otče, Pane nebe i země, že jsi tyto věci skryl před moudrými a rozumnými a zjevil jsi je nemluvňatům. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jistě, Otče, neboť tak se ti zalíbilo. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Všechno je mi dáno od mého Otce a nikdo nezná Syna, jedině Otec a ani Otce nikdo nezná, jedině Syn a ten, komu by ho Syn chtěl zjevit. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pojďte ke mně všichni, kteří pracujete a jste obtěžkáni, a já vám dám odpočinout. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Vezměte na sebe mé jho a učte se ode mne, neboť jsem mírný a pokorný v srdci; a najdete odpočinek pro své duše. ");
INSERT INTO cesnkb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Vždyť mé jho je příjemné a mé břemeno lehké.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tou dobou procházel Ježíš v sobotu obilím a jeho učedníci začali vytrhávat klasy a jíst, protože měli hlad. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Když to však viděli farizeové, řekli mu: “Podívej se, tvoji učedníci dělají, co se v sobotu dělat nesmí!” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","On jim řekl: “Copak jste nečetli, co udělal David, když on i ti, kdo byli s ním, měli hlad? ");
INSERT INTO cesnkb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jak vešel do Božího domu a jedl posvátné chleby předložení, které nesměl jíst on, ani ti, kdo byli s ním, ale pouze samotní kněží? ");
INSERT INTO cesnkb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","A nečetli jste v Zákoně ani to, že kněží v sobotu svou prací v chrámu znesvěcují sobotu a jsou nevinní? ");
INSERT INTO cesnkb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A říkám vám, že zde je někdo větší nežli chrám. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kdybyste ale věděli, co znamená: ‘Milosrdenství chci, a ne oběť,’ neodsuzovali byste nevinné. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Syn člověka je totiž Pánem i nad sobotou.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Když pak odtud odešel, přišel do jejich synagogy. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A hle, byl tu člověk, který měl uschlou ruku. Ptali se ho tedy, zda se smí v sobotu uzdravovat, aby ho mohli obžalovat. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","On jim však řekl: “Je snad mezi vámi takový člověk, že kdyby měl jednu ovci a ta by mu v sobotu spadla do jámy, nevzal by ji a nevytáhl? ");
INSERT INTO cesnkb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","O co je pak dražší člověk než ovce? Proto se v sobotu smí konat dobro.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tehdy řekl tomu člověku: “Natáhni tu ruku.” A on ji natáhl a byla znovu zdravá jako ta druhá. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farizeové však odešli a radili se proti němu, jak by ho zničili. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ježíš to ale věděl a odešel odtud. Šly za ním veliké zástupy lidí a on je všechny uzdravil. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Přísně je napomínal, aby ho neuváděli ve známost, ");
INSERT INTO cesnkb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","a tak se naplnilo to, co bylo řečeno skrze proroka Izaiáše: ");
INSERT INTO cesnkb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hle, můj služebník, kterého jsem vyvolil, můj milovaný, v němž má duše našla zalíbení. Na něj položím svého Ducha, on oznámí spravedlnost národům. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nebude se hádat ani křičet, na ulicích nikdo neuslyší jeho hlas. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nalomenou třtinu nedolomí a doutnající knot neuhasí, dokud nedovede spravedlnost k vítězství. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A na jeho jméno budou spoléhat národy.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Potom byl k němu přiveden slepý a němý člověk posedlý démonem a on ho uzdravil, takže ten slepý a němý mluvil a viděl. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A všechny ty zástupy žasly a říkaly: “Není snad tohle ten Syn Davidův?” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ale když to uslyšeli farizeové, řekli: “Ten člověk nevymítá démony jinak než skrze Belzebula, knížete démonů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ježíš ale znal jejich myšlenky a řekl jim: “Každé království rozdělené samo proti sobě zpustne a žádné město nebo dům rozdělený proti sobě neobstojí. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Vymítá-li Satan Satana, je rozdělen sám proti sobě. Jak tedy jeho království obstojí? ");
INSERT INTO cesnkb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A pokud já vymítám démony Belzebulem, kým je vymítají vaši synové? Oni proto budou vašimi soudci. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Vymítám-li však démony Božím Duchem, jistě k vám přišlo Boží království. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Jak také může někdo vejít do silákova domu a uloupit jeho majetek, pokud toho siláka nejdříve nespoutá? Teprve tehdy vyloupí jeho dům. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kdo není se mnou, je proti mně, a kdo neshromažďuje se mnou, rozptyluje. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Proto vám říkám: Každý hřích i rouhání bude lidem odpuštěno, ale rouhání proti Duchu lidem odpuštěno nebude. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kdokoli by řekl slovo proti Synu člověka, bude mu to odpuštěno, ale kdokoli by mluvil proti Duchu Svatému, nebude mu odpuštěno ani v tomto věku, ani v budoucím. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Buďto udělejte strom dobrým a jeho ovoce bude dobré, anebo udělejte strom špatným a jeho ovoce bude špatné. Strom se přece pozná po ovoci. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Plemeno zmijí! Jak byste mohli mluvit dobré věci, když jste zlí? Vždyť ústa mluví z hojnosti srdce. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dobrý člověk vynáší z dobrého pokladu svého srdce to dobré a zlý člověk vynáší ze zlého pokladu zlé. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ale říkám vám, že z každého prázdného slova, které lidé řeknou, budou skládat účty v soudný den. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Svými vlastními slovy totiž budeš ospravedlněn a svými vlastními slovy budeš odsouzen.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tehdy mu někteří ze zákoníků a farizeů odpověděli: “Mistře, chceme od tebe vidět nějaké znamení.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","On jim ale odpověděl: “Zlé a cizoložné pokolení vyhledává znamení, ale žádné znamení mu nebude dáno, kromě znamení proroka Jonáše. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Neboť tak, jako byl Jonáš tři dny a tři noci v břiše velryby, tak bude Syn člověka tři dny a tři noci v srdci země. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Muži z Ninive povstanou na soudu s tímto pokolením a odsoudí je, neboť po Jonášově kázání činili pokání, a hle, zde je více než Jonáš. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Královna jihu povstane na soudu s tímto pokolením a odsoudí je, neboť přijela z kraje světa, aby slyšela Šalomounovu moudrost, a hle, zde je více než Šalomoun.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Když pak nečistý duch vyjde z člověka, chodí po suchých místech a hledá odpočinek, ale nenachází. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tehdy řekne: ‘Vrátím se do svého domu, odkud jsem vyšel.’ A když přijde, nalezne ho prázdný, vymetený a ozdobený. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tehdy jde a přibere k sobě sedm jiných duchů, horších než je sám. Pak vejdou dovnitř a bydlí tam a poslední věci toho člověka jsou horší než první. Tak tomu bude i s tímto zlým pokolením.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","A zatímco ještě mluvil k zástupům, hle, jeho matka a bratři stáli venku, neboť s ním chtěli promluvit. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Někdo mu řekl: “Pohleď, tvá matka a tvoji bratři stojí venku a chtějí s tebou mluvit.” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","On však tomu, kdo mu to řekl, odpověděl: “Kdo je má matka? A kdo jsou moji bratři?” ");
INSERT INTO cesnkb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ukázal rukou na své učedníky a řekl: “Pohleď, toto je má matka a moji bratři. ");
INSERT INTO cesnkb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kdokoli totiž koná vůli mého nebeského Otce, ten je můj bratr a sestra a matka.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ten den Ježíš vyšel z domu a posadil se u moře. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tehdy se k němu sešly tak veliké zástupy, že nastoupil na loď a posadil se; a celý ten zástup stál na břehu. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mluvil k nim v podobenstvích o mnoha věcech. Řekl: “Hle, vyšel rozsévač, aby rozsíval. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A jak rozsíval, některá semena padla podél cesty a přiletěli ptáci a sezobali je. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jiná padla na skalnatá místa, kde neměla mnoho země, a ihned vzešla, protože neměla hloubku země. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Když pak vyšlo slunce, byla spálena, a protože neměla kořen, uschla. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jiná zase padla do trní, a když trní vyrostlo, udusilo je. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jiná však padla do dobré země a vydala úrodu, některé stonásobnou, jiné šedesátinásobnou a jiné třicetinásobnou. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kdo má uši k slyšení, ať slyší.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tehdy k němu přistoupili učedníci a řekli mu: “Proč k nim mluvíš v podobenstvích?” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","On jim odpověděl: “Protože vám je dáno poznat tajemství nebeského království, ale jim to dáno není. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tomu, kdo má, totiž bude dáno a bude mít hojnost, ale tomu, kdo nemá, bude vzato i to, co má. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Proto k nim mluvím v podobenstvích, že vidí, ale nevidí a slyší, ale neslyší ani nerozumějí. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ale naplňuje se na nich proroctví Izaiáše, který řekl: ‘Sluchem uslyšíte, ale nijak nepochopíte, a zrakem uvidíte, ale nijak neprohlédnete. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Neboť srdce tohoto lidu ztučnělo a svýma ušima ztěžka slyšeli. Své oči pevně zavřeli, aby snad očima neuviděli, ušima neuslyšeli a srdcem nepochopili a neobrátili se, abych je neuzdravil.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ale blaze vašim očím, že vidí, a vašim uším, že slyší. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Amen, říkám vám, že mnozí proroci a spravedliví toužili spatřit, co vy vidíte, ale neviděli a slyšet, co slyšíte, ale neslyšeli.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Vy tedy slyšte význam podobenství o rozsévači: ");
INSERT INTO cesnkb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ke každému, kdo slyší slovo o království a nerozumí, přichází ten zlý a uchvacuje to, co je zaseto do jeho srdce. To je ten osetý podél cesty. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A kdo je oset na skalnaté zemi, je ten, který slyší slovo a hned je s radostí přijímá, ");
INSERT INTO cesnkb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ale nemá v sobě kořen a je nestálý, a když přichází soužení nebo pronásledování kvůli slovu, hned se pohoršuje. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kdo je oset do trní, je ten, který slyší slovo, ale starosti tohoto světa a oklamání bohatstvím to slovo dusí, a tak se stává neplodným. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A kdo je oset na dobré půdě, je ten, který slyší slovo a rozumí a který opravdu přináší úrodu: někdo stonásobnou, jiný šedesátinásobnou a jiný třicetinásobnou.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pak jim předložil jiné podobenství. Řekl: “Nebeské království je podobné člověku rozsívajícímu na svém poli dobré semeno. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ale zatímco lidé spali, přišel jeho nepřítel, nasel mezi pšenici koukol a odešel. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Když pak vzešla stébla a přinesla úrodu, tehdy se ukázal i koukol. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Služebníci toho hospodáře tedy přišli a řekli mu: ‘Pane, nenasel jsi na svém poli dobré semeno? Odkud se tedy vzal ten koukol?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","On jim řekl: ‘To udělal nepřítel.’ Služebníci mu řekli: ‘Chceš tedy, abychom šli a vytrhali ho?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ale on řekl: ‘Nikoli, protože byste při trhání koukolu mohli vytrhnout i pšenici. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nechte obojí růst spolu až do žně. V čas žně řeknu žencům: Vytrhejte nejdříve koukol a svažte do snopků ke spálení, ale pšenici shromážděte do mé obilnice.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pak jim předložil jiné podobenství. Řekl: “Nebeské království je podobné zrnku hořčice, které člověk vzal a zasel na svém poli. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","To zrnko je opravdu nejmenší ze všech semen, ale když vyroste, je větší než jiné rostliny a stane se stromem, takže nebeští ptáci přiletí a uhnízdí se v jeho větvích.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Řekl jim ještě jiné podobenství: “Nebeské království je podobné kvasu, který žena vzala a zadělala ve třech měřicích mouky, až všechno zkvasilo.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Toto všechno Ježíš říkal zástupům v podobenstvích a bez podobenství k nim vůbec nemluvil. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A tak se naplnilo to, co bylo řečeno skrze proroka: “Otevřu svá ústa v podobenstvích, budu vyprávět věci skryté od založení světa.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tehdy Ježíš propustil zástupy a šel domů. Jeho učedníci k němu přistoupili a řekli: “Vysvětli nám to podobenství o koukolu na poli.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Odpověděl jim: “Rozsévač dobrého semene je Syn člověka ");
INSERT INTO cesnkb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","a pole je tento svět, dobré semeno jsou synové království, ale koukol jsou synové toho zlého. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nepřítel, který je rozsívá, je ďábel, sklizeň je konec tohoto světa a ženci jsou andělé. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jako se tedy sbírá koukol a spaluje se ohněm, tak to bude při konci tohoto světa. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Syn člověka pošle své anděly a ti vyberou z jeho království všechno pohoršující i ty, kdo konají nepravost, ");
INSERT INTO cesnkb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","a vrhnou je do ohnivé pece. Tam bude pláč a skřípění zubů. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tehdy se spravedliví v království svého Otce rozzáří jako slunce. Kdo má uši k slyšení, ať slyší.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Nebeské království je také podobné pokladu ukrytému v poli, který když člověk nalezl, skryl ho a kvůli radosti z něj jde, prodává všechno, co má, a kupuje to pole.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nebeské království je také podobné kupci hledajícímu krásné perly, ");
INSERT INTO cesnkb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","který když našel jednu velmi vzácnou perlu, šel a prodal všechno, co měl, a koupil ji.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nebeské království je také podobné vlečné síti hozené do moře, nabírající ze všech druhů ryb, ");
INSERT INTO cesnkb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","kterou, když byla naplněna, vytáhli rybáři na břeh, sedli si a shromáždili to, co bylo dobré, do nádob, ale špatné vyhodili pryč. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Totéž se bude dít při konci tohoto světa. Vyjdou andělé a oddělí zlé zprostřed spravedlivých ");
INSERT INTO cesnkb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","a vrhnou je do ohnivé pece. Tam bude pláč a skřípění zubů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tehdy se jich Ježíš zeptal: “Pochopili jste všechny tyto věci?” A oni mu řekli: “Ano, Pane.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Řekl jim tedy: “Proto je každý učitel vyučený o nebeském království podobný hospodáři, který vynáší ze svého pokladu nové i staré věci.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","A stalo se, že když Ježíš dokončil tato podobenství, šel odtud. ");
INSERT INTO cesnkb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Přišel do svého domovského města a učil je v jejich synagoze tak, že žasli a říkali: “Odkud má tenhle takovou moudrost a zázračné schopnosti? ");
INSERT INTO cesnkb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Není to snad syn toho tesaře? Nejmenuje se jeho matka Marie a jeho bratři Jakub, Jozes, Šimon a Juda? ");
INSERT INTO cesnkb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A nejsou snad všechny jeho sestry u nás? Odkud tedy má tenhle všechny tyto věci?” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","A tak se nad ním pohoršovali. Ježíš jim tedy řekl: “Prorok není beze cti, jedině ve své vlasti a ve svém domě.” ");
INSERT INTO cesnkb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A kvůli jejich nevěře tam neudělal mnoho zázraků. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","V tu dobu uslyšel zprávu o Ježíši i tetrarcha Herodes ");
INSERT INTO cesnkb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a řekl svým služebníkům: “To je Jan Křtitel. Byl vzkříšen z mrtvých, a proto se skrze něj dějí zázraky.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes totiž Jana zatkl, spoutal a dal do vězení kvůli Herodiadě, manželce svého bratra Filipa, ");
INSERT INTO cesnkb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","protože mu Jan říkal: “Není ti dovoleno, abys ji měl!” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A ačkoli ho chtěl zabít, bál se zástupu, protože ho měli za proroka. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Když pak nastal den oslavy Herodových narozenin, zatančila dcera Herodiady uprostřed hodovníků a zalíbila se Herodovi. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Proto jí s přísahou slíbil, že jí dá, o cokoli požádá. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A ona, předem navedena svou matkou, řekla: “Dej mi sem na tu mísu hlavu Jana Křtitele.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Král se tedy zarmoutil, ale kvůli přísaze a kvůli těm, kdo s ním stolovali, poručil, aby jí byla dána. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Poslal tedy kata, aby Jana sťal ve vězení. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jeho hlava pak byla přinesena na míse a dána té dívce a ta ji odnesla matce. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pak přišli jeho učedníci, vzali tělo a pochovali ho. Potom šli a pověděli to Ježíši. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Když to Ježíš uslyšel, o samotě se odtud lodí odplavil na pusté místo. Zástupy to však uslyšely a vypravily se za ním pěšky z měst. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Když Ježíš vystoupil, uviděl veliký zástup lidí; byl naplněn soucitem k nim a uzdravil jejich nemocné. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Když pak nastal večer, přišli k němu jeho učedníci se slovy: “Tohle místo je pusté a je už pokročilá hodina. Propusť ty zástupy, ať odejdou do vesnic a nakoupí si jídlo.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ježíš jim ale řekl: “Nemusejí odcházet. Vy jim dejte najíst.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Řekli mu: “Nic tu nemáme - jen pět chlebů a dvě ryby.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","On však řekl: “Přineste mi je sem.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tehdy přikázal, aby se zástup posadil na trávě. Vzal těch pět chlebů a ty dvě ryby, vzhlédl k nebi, požehnal a nalámal ty chleby a dal učedníkům a učedníci zástupům. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A tak se všichni najedli a byli nasyceni. Potom sebrali nalámané kousky, které zbyly: dvanáct plných košů. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A těch, kteří jedli, bylo kolem pěti tisíc mužů, kromě žen a dětí. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Potom Ježíš hned své učedníky přinutil, aby nastoupili na loď a jeli napřed na druhou stranu, než rozpustí zástupy. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Když pak propustil zástupy, vystoupil o samotě na horu, aby se modlil. A když přišel večer, byl tam sám. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ale loď už byla uprostřed moře, zmítána vlnami, protože byl protivítr. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Při čtvrté noční hlídce pak k nim Ježíš šel pěšky po moři. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Když ho učedníci uviděli, jak kráčí po moři, vyděsili se a říkali: “To je přízrak!” A křičeli strachy. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ale Ježíš na ně ihned promluvil a řekl jim: “Vzmužte se, to jsem já! Nebojte se.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petr mu odpověděl: “Pane, jestli jsi to ty, přikaž mi, ať k tobě přijdu po vodě.” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","On řekl: “Pojď!” A Petr vystoupil z lodi a kráčel po vodě, aby přišel k Ježíši. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Když ale viděl, jak silný je vítr, dostal strach a začal se topit. Tehdy vykřikl: “Pane, zachraň mě!” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ježíš ihned vztáhl ruku, chytil ho a řekl: “Proč jsi pochyboval, malověrný?” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A jakmile vstoupili na loď, vítr se utišil. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ti, kdo byli na lodi, pak přistoupili a klaněli se mu se slovy: “Ty jsi opravdu Boží Syn!” ");
INSERT INTO cesnkb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A když se přeplavili, přijeli do genezaretské země. ");
INSERT INTO cesnkb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tamější muži ho poznali a rozeslali posly po celém okolí. Přinesli k němu všechny nemocné ");
INSERT INTO cesnkb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","a ti ho prosili, aby se směli aspoň dotknout cípu jeho roucha. A kdokoli se ho dotkl, byl úplně uzdraven. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tehdy k Ježíši přicházeli zákoníci a farizeové z Jeruzaléma a říkali: ");
INSERT INTO cesnkb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Proč tvoji učedníci přestupují tradici starších? Vždyť si neumývají ruce, když mají jíst chleba!” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","On jim však odpověděl: “A proč vy přestupujete Boží přikázání kvůli své tradici? ");
INSERT INTO cesnkb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Vždyť Bůh přikázal: ‘Cti otce i matku’ a ‘Kdokoli by zlořečil otci nebo matce, ať propadne smrti.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Vy ale říkáte, že kdokoli by řekl otci nebo matce: ‘To, čím bych ti měl vypomoci, je dar Bohu,’ ");
INSERT INTO cesnkb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","už nemusí nijak uctít svého otce nebo matku. A tak jste zrušili Boží přikázání kvůli své tradici. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pokrytci, Izaiáš o vás dobře prorokoval, když říkal: ");
INSERT INTO cesnkb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tento lid se ke mně přibližuje svými ústy a ctí mne svými rty, ");
INSERT INTO cesnkb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","avšak jejich srdce je ode mne daleko. Nadarmo mne ale uctívají, když učí učení a přikázání lidí.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pak svolal zástup a řekl jim: “Slyšte a rozumějte. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Člověka nešpiní to, co vchází do úst, ale co vychází z úst, to člověka špiní.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tehdy k němu přistoupili učedníci a řekli mu: “Víš to, že se farizeové urazili, když slyšeli tu řeč?” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","On odpověděl: “Každá sazenice, kterou nesázel můj nebeský Otec, bude vykořeněna. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Opusťte je. Jsou to slepí vůdcové slepců. Povede-li slepý slepého, oba padnou do jámy.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petr mu odpověděl: “Vysvětli nám to podobenství.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ježíš ale řekl: “Vy jste ještě tak nechápaví? ");
INSERT INTO cesnkb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nerozumíte, že všechno, co vchází do úst, jde do břicha a pak se vypouští do stoky? ");
INSERT INTO cesnkb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Co ale z úst vychází, jde ze srdce, a to špiní člověka. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ze srdce totiž vycházejí zlé myšlenky, vraždy, cizoložství, smilnění, krádeže, falešná svědectví, urážky. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tyto věci špiní člověka. Ale jíst neumytýma rukama, to člověka nešpiní.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ježíš pak odtud odešel a odebral se do krajů Týru a Sidonu. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A hle, z těch míst vyšla kananejská žena a křičela: “Pane, Synu Davidův, smiluj se nade mnou! Má dcera je hrozně posedlá ďáblem.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","On jí však neodpověděl ani slovo. Jeho učedníci tedy přistoupili a prosili ho: “Pošli ji pryč, vždyť za námi pořád křičí.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ale on odpověděl: “Nebyl jsem poslán jinam než ke ztraceným ovcím z Izraelova domu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ona však přišla a klaněla se mu. Řekla: “Pane, pomoz mi.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ale on odpověděl: “Není správné vzít chléb dětem a hodit ho štěňatům.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A ona řekla: “Ano, Pane, ale právě štěňata jedí drobty, které padají ze stolu jejich pánů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tehdy jí Ježíš odpověděl: “ženo, tvoje víra je veliká. Ať se ti stane, jak toužíš.” A od té chvíle byla její dcera uzdravená. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Když pak odtud Ježíš odešel, přišel ke Galilejskému moři, vystoupil na horu a posadil se tam. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tehdy k němu přišly veliké zástupy lidí, kteří měli s sebou chromé, slepé, hluché, zmrzačené a mnohé jiné. Skládali je k Ježíšovým nohám a on je uzdravoval, ");
INSERT INTO cesnkb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","takže zástupy užasly, když viděly, jak němí mluví, zmrzačení jsou zdraví, chromí chodí a slepí vidí; a vzdaly slávu Bohu Izraele. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Potom Ježíš svolal své učedníky a řekl: “Je mi líto toho zástupu. Vždyť zůstávají se mnou už tři dny a nemají co jíst. Nechci je poslat pryč hladové, aby se snad cestou nevyčerpali.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jeho učedníci mu řekli: “Kde na této poušti najdeme tolik chleba, abychom nasytili takový zástup?” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ježíš jim tedy řekl: “Kolik máte chlebů?” A oni řekli: “Sedm a pár malých rybek.” ");
INSERT INTO cesnkb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ježíš tedy přikázal zástupům, aby se posadily na zem. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Potom vzal těch sedm chlebů a ty ryby, vzdal díky, nalámal a dával svým učedníkům a učedníci zástupům. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A tak se všichni najedli a byli nasyceni. Potom posbírali nalámané kousky, které zbyly: sedm plných košů. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Těch, kteří jedli, pak bylo čtyři tisíce mužů, kromě žen a dětí. ");
INSERT INTO cesnkb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A když propustil zástupy, vstoupil na loď a přijel do kraje Magdala. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tehdy ho přišli pokoušet farizeové a saduceové. Prosili ho, aby jim ukázal znamení z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","On jim odpověděl: “Když je večer, říkáte: ‘Bude hezky, protože nebe je červené.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ale za svítání říkáte: ‘Dnes bude ošklivo, protože je červené zatažené nebe.’ Pokrytci! Umíte rozeznat vzhled nebe, ale znamení těchto časů rozeznat neumíte? ");
INSERT INTO cesnkb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Zlé a cizoložné pokolení vyhledává znamení, ale žádné znamení mu nebude dáno, kromě znamení proroka Jonáše.” Tehdy je nechal a odešel. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","A když se jeho učedníci přeplavili na druhou stranu, zjistili, že zapomněli vzít chléb. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ježíš jim tehdy řekl: “Dávejte pozor a varujte se kvasu farizeů a saduceů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Oni se pak mezi sebou dohadovali a říkali: “Nevzali jsme žádný chléb.” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ježíš to ale věděl a řekl jim: “Proč se spolu dohadujete, vy malověrní, že jste nevzali chléb? ");
INSERT INTO cesnkb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Copak ještě nechápete ani si nevzpomínáte na těch pět chlebů pro pět tisíc mužů, a kolik jste nasbírali košů? ");
INSERT INTO cesnkb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ani na těch sedm chlebů pro ty čtyři tisíce, a kolik jste nasbírali košů? ");
INSERT INTO cesnkb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jak to, že nerozumíte, že jsem nemluvil o chlebech, když jsem říkal: Varujte se farizejského a saducejského kvasu?” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tehdy pochopili, že jim neřekl, aby se vyvarovali chlebového kvasu, ale farizejského a saducejského učení. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Když pak Ježíš přišel do končin Cesareje Filipovy, zeptal se svých učedníků: “Za koho mne, Syna člověka, mají lidé?” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A oni řekli: “Někteří za Jana Křtitele, jiní za Eliáše a jiní za Jeremiáše nebo za jednoho z proroků.” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","On jim řekl: “A za koho mne máte vy?” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Šimon Petr mu odpověděl: “Ty jsi Kristus, ten Syn živého Boha!” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ježíš mu tedy řekl: “Blaze tobě, Šimone, synu Jonášův, protože toto ti nezjevilo tělo a krev, ale můj Otec, který je v nebesích. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A já ti říkám, že ty jsi Petr a na té skále postavím svou církev a brány pekla ji nepřemohou. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dám ti klíče nebeského království, a cokoli svážeš na zemi, bude už svázáno v nebi, a cokoli rozvážeš na zemi, bude už rozvázáno v nebi.” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tehdy své učedníky přísně napomenul, aby nikomu neříkali, že On, Ježíš, je Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Od té doby začal Ježíš oznamovat svým učedníkům, že musí jít do Jeruzaléma a mnoho vytrpět od starších, od velekněží a od zákoníků, být zabit a třetího dne vstát z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tehdy ho Petr vzal stranou a začal ho kárat slovy: “Bůh tě chraň, Pane, to se ti nikdy nestane!” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","On se ale odvrátil a řekl Petrovi: “Jdi za mnou, Satane, svádíš mě, protože nemyslíš na Boží věci, ale na lidské!” ");
INSERT INTO cesnkb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Potom Ježíš řekl svým učedníkům: “Chce-li někdo přijít za mnou, ať se zřekne sám sebe, vezme svůj kříž a následuje mě. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kdokoli by si totiž chtěl zachránit duši, ztratí ji, ale kdokoli by ztratil svou duši pro mě, ten ji nalezne. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Vždyť co prospěje člověku, kdyby získal celý svět, ale uškodil své duši? A co dá člověk na oplátku za svou duši? ");
INSERT INTO cesnkb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Neboť Syn člověka přijde ve slávě svého Otce se svými anděly a tehdy každému odplatí podle jeho skutků. ");
INSERT INTO cesnkb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Amen, říkám vám, že někteří z těch, kdo tu stojí, rozhodně nezakusí smrt, dokud nespatří Syna člověka přicházet v jeho království.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Po šesti dnech pak Ježíš vzal k sobě Petra, Jakuba a jeho bratra Jana, vyvedl je o samotě na vysokou horu ");
INSERT INTO cesnkb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","a proměnil se před nimi. Jeho tvář zazářila jako slunce a jeho šaty zbělely jako světlo. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A hle, uviděli Mojžíše a Eliáše, jak s ním mluví. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petr pak Ježíši odpověděl: “Pane, to je dobře, že jsme zde. Jestli chceš, udělejme tu tři stánky - jeden tobě, jeden Mojžíšovi a jeden Eliášovi.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ale když ještě mluvil, náhle je zastínil zářící oblak. A hle, hlas z toho oblaku řekl: “Toto je můj milovaný Syn, ve kterém jsem našel zalíbení. Toho poslouchejte.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","To když učedníci uslyšeli, padli na tváře a velice se báli. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A Ježíš přistoupil, dotkl se jich a řekl: “Vstaňte a nebojte se.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A když pozvedli oči, neviděli nikoho jiného než samotného Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Když pak sestupovali z hory, Ježíš jim přikázal: “Nikomu o tom vidění neříkejte, dokud Syn člověka nevstane z mrtvých.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Učedníci se ho zeptali: “Proč tedy zákoníci říkají, že nejdříve musí přijít Eliáš?” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ježíš jim ale odpověděl: “Jistě, nejdříve přijde Eliáš a všechno napraví. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Já vám však říkám, že Eliáš už přišel, ale oni ho nepoznali a udělali s ním, co chtěli. Tak také bude od nich trpět Syn člověka.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tehdy učedníci pochopili, že jim to řekl o Janu Křtiteli. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","A když přišli k zástupu, přistoupil k němu jeden člověk, padl před ním na kolena a řekl: ");
INSERT INTO cesnkb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Pane, smiluj se nad mým synem. Je to náměsíčník a těžce tím trpí, protože často padá do ohně a častokrát do vody. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Přivedl jsem ho ke tvým učedníkům, ale nemohli ho uzdravit.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ale Ježíš na to odpověděl: “nevěřící a zvrácené pokolení, jak dlouho budu s vámi? Jak dlouho vás budu snášet? Přiveďte mi ho sem.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ježíš pak tomu démonovi pohrozil a on vyšel a chlapec byl v tu chvíli uzdraven. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Potom k Ježíši přistoupili učedníci a v soukromí se ho zeptali: “Proč jsme ho my nemohli vyhnat?” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ježíš jim řekl: “Kvůli své nevěře. Amen, říkám vám, když budete mít víru jako hořčičné zrnko, řeknete této hoře: ‘Přejdi odsud tam,’ a ona přejde a nic pro vás nebude nemožné. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ale tento druh démonů nevychází jinak než skrze modlitbu a půst.” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","A když chodili po Galileji, Ježíš jim řekl: “Syn člověka bude vydán do lidských rukou. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Zabijí ho, ale on bude třetího dne vzkříšen.” A oni se nesmírně zarmoutili. ");
INSERT INTO cesnkb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Když pak přišli do Kafarnaum, přistoupili k Petrovi výběrčí chrámového poplatku a řekli: “Váš mistr neplatí poplatek?” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A on řekl: “Platí.” A když šel domů, Ježíš ho předešel a řekl: “Co myslíš, Šimone, od koho vybírají pozemští králové daně a poplatky? Od svých synů nebo od cizích?” ");
INSERT INTO cesnkb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A když Petr odpověděl: “Od cizích,” Ježíš mu řekl: “Synové jsou tedy svobodní! ");
INSERT INTO cesnkb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ale abychom je neurazili, jdi k moři, hoď udici a první vylovenou rybu vezmi, a když jí otevřeš ústa, najdeš tam peníz. Ten vezmi a dej jim ho za mě i za sebe.” ");
INSERT INTO cesnkb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","V tu dobu přišli k Ježíši učedníci a říkali: “Kdo je tedy v nebeském království největší?” ");
INSERT INTO cesnkb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ježíš k sobě zavolal malé dítě, postavil je uprostřed nich ");
INSERT INTO cesnkb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a řekl: “Amen, říkám vám, že jestli se neobrátíte a nebudete jako malé děti, vůbec do nebeského království nevejdete. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A proto kdokoli se poníží a bude jako toto malé dítě, ten je v nebeském království největší. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A kdokoli by takové dítě přijal v mém jménu, přijímá mne.” ");
INSERT INTO cesnkb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kdokoli by ale svedl jednoho z těchto maličkých, kteří věří ve mne, bylo by pro něj lepší, kdyby mu na krk pověsili. Veliký mlýnský kámen a utopili ho v mořské hlubině. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Běda světu kvůli pohoršením! Pohoršení sice musejí přicházet, ale běda člověku, skrze kterého pohoršení přichází. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Svádí-li tě tedy tvá ruka nebo noha, usekni ji a zahoď od sebe. Je pro tebe lepší, abys chromý nebo zmrzačený vstoupil do života, než mít obě ruce nebo obě nohy a být uvržen do věčného ohně. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A jestliže tě svádí tvé oko, vyloupni je a zahoď od sebe. Je pro tebe lepší vejít do věčného života jednooký, než mít obě oči a být uvržen do pekelného ohně. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Dejte si pozor, abyste nepohrdali žádným z těchto maličkých. Říkám vám totiž, že jejich andělé v nebesích neustále hledí na tvář mého nebeského Otce.” ");
INSERT INTO cesnkb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Neboť Syn člověka přišel, aby spasil to, co zahynulo. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Co myslíte, kdyby nějaký člověk měl sto ovcí a jedna z nich by zabloudila, nenechá těch devadesát devět na horách a nepůjde hledat tu bloudící? ");
INSERT INTO cesnkb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A když se stane, že ji najde, říkám vám jistě, že se z ní raduje více než z těch devadesáti devíti, které nezabloudily. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Právě tak není vůle vašeho Otce v nebesích, aby zahynul jediný z těchto maličkých.” ");
INSERT INTO cesnkb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kdyby tvůj bratr proti tobě zhřešil, jdi a napomeň ho mezi čtyřma očima. Jestliže tě poslechne, získal jsi svého bratra. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pokud tě neposlechne, vezmi s sebou ještě jednoho nebo dva bratry, aby každé slovo obstálo v ústech dvou nebo tří svědků. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nechce-li však poslechnout ani je, řekni to církvi. A pokud odmítne poslechnout i církev, ať je tedy pro tebe cizí jako pohan a celník. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Amen, říkám vám, že cokoli svážete na zemi, bude už svázáno v nebi, a cokoli rozvážete na zemi, bude už rozvázáno v nebi. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Říkám vám také, že pokud se dva z vás na zemi shodnou ohledně čehokoli, za co by prosili, stane se jim to od mého nebeského Otce. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Neboť kdekoli se shromáždí dva nebo tři v mém jménu, tam jsem já uprostřed nich.” ");
INSERT INTO cesnkb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tehdy k němu přistoupil Petr a řekl: “Pane, kolikrát proti mně může můj bratr zhřešit a já mu mám odpustit? Až sedmkrát?” ");
INSERT INTO cesnkb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ježíš mu odpověděl: “Neříkám ti, že až sedmkrát, ale až sedmdesátkrát sedmkrát. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nebeské království je totiž podobné králi, který chtěl se svými služebníky vyrovnat účty. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A když začal počítat, byl přiveden jeden, který mu dlužil deset tisíc hřiven. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Když pak neměl čím zaplatit, poručil jeho pán, aby ho prodali i se ženou, s dětmi a se vším, co měl, a tím aby se zaplatil dluh. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ten služebník tedy padl a začal se mu klanět se slovy: ‘Pane, měj se mnou trpělivost a všechno ti zaplatím!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ten pán se tedy nad ním slitoval, propustil ho a dluh mu odpustil. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Když ale ten služebník odešel, našel jednoho ze svých spoluslužebníků, který mu dlužil sto denárů, chytil ho a začal ho škrtit se slovy: ‘Zaplať mi, co dlužíš!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ten spoluslužebník tedy padl k jeho nohám a prosil ho: ‘Měj se mnou trpělivost a všechno ti zaplatím!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ale on nechtěl. Odešel a dal ho do vězení, dokud by nezaplatil, co dluží. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Když pak jeho spoluslužebníci viděli, co se stalo, velice se zarmoutili; šli ke svému pánu a pověděli mu všechno, co se stalo. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tehdy ho jeho pán zavolal a řekl mu: ‘Ty zlý služebníku! Odpustil jsem ti celý ten dluh, protože jsi mě prosil. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Neměl ses i ty slitovat nad svým spoluslužebníkem, jako jsem se slitoval já nad tebou?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A tehdy se jeho pán rozhněval a dal ho katům, dokud nezaplatí všechno, co mu dlužil. ");
INSERT INTO cesnkb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Totéž udělá i můj nebeský Otec vám, pokud každý ze srdce neodpustíte svému bratru jejich prohřešky.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Když Ježíš domluvil tato slova, stalo se, že odešel z Galileje a přišel do judského kraje za Jordánem. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Šly za ním veliké zástupy a on je tam uzdravil. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tehdy k němu přišli farizeové a pokoušeli ho slovy: “Smí člověk propustit svou manželku z jakéhokoli důvodu?” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","On jim odpověděl: “Cožpak jste nečetli, že Stvořitel je od počátku ‘učinil muže a ženu’ ");
INSERT INTO cesnkb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","a řekl: ‘Proto člověk opustí otce i matku a přilne ke své manželce a ti dva budou jedno tělo’? ");
INSERT INTO cesnkb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","A tak už nejsou dva, ale jedno tělo. Co tedy Bůh spojil, ať člověk nerozděluje.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Oni mu ale řekli: “Proč tedy Mojžíš přikázal dát potvrzení o rozvodu a tak propustit ženu?” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Odpověděl jim: “Mojžíš vám dovolil propouštět vaše manželky kvůli tvrdosti vašeho srdce, ale od počátku to tak nebylo. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Proto vám říkám, že kdokoli by propustil svou manželku z jiného důvodu než kvůli smilstvu a vzal si jinou, cizoloží, a kdo si bere propuštěnou, cizoloží.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jeho učedníci mu řekli: “Jestliže má člověk s manželkou takovou při, není dobré se ženit.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Řekl jim tedy: “Ne všichni přijímají toto slovo, ale jen ti, kterým je to dáno. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Neboť jsou panicové, kteří se tak narodili z lůna matky, a jsou panicové, které udělali panici lidé, a jsou panicové, kteří se sami stali panici pro nebeské království. Kdo to může přijmout, ať to přijme.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tehdy k němu přinesli malé děti, aby na ně pokládal ruce a modlil se, ale učedníci je přísně napomínali. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ježíš ale řekl: “Nechte děti a nebraňte jim přicházet ke mně, protože takovým patří nebeské království.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A tak na ně pokládal ruce a potom odtud odešel. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A hle, přišel k němu jeden muž a řekl mu: “Dobrý mistře, co dobrého mám udělat, abych měl věčný život?” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","On mu však řekl: “Proč mě nazýváš dobrým? Nikdo není dobrý, jen jediný - Bůh. Chceš-li ale vstoupit do života, dodržuj přikázání.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Zeptal se ho: “Která?” Ježíš řekl: “‘Nezabiješ, nezcizoložíš, nebudeš krást, nevydáš falešné svědectví’, ");
INSERT INTO cesnkb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘cti svého otce i matku’ a ‘budeš milovat svého bližního jako sám sebe.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ten mladík mu řekl: “To všechno jsem dodržoval odmalička. Co mi ještě schází?” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ježíš mu řekl: “Pokud chceš být dokonalý, jdi, prodej svůj majetek, dej ho chudým a budeš mít poklad v nebi. A pojď, následuj mě.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Když ale mladík uslyšel tu řeč, smutně odešel. Měl totiž mnoho majetku. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ježíš tedy řekl svým učedníkům: “Amen, říkám vám, že pro boháče je nesnadné vstoupit do nebeského království. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A říkám vám znovu: Je snadnější, aby velbloud prošel uchem jehly, než aby boháč vešel do Božího království.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","A když to jeho učedníci uslyšeli, nesmírně nad tím žasli a říkali: “Kdo tedy může být spasen?” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ježíš však na ně pohlédl a řekl: “U lidí je to nemožné, ale u Boha je možné všechno.” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tehdy mu Petr odpověděl: “Pohleď, my jsme všechno opustili a šli jsme za tebou. Co tedy bude s námi?” ");
INSERT INTO cesnkb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ježíš jim řekl: “Amen, říkám vám, kdo jste mě následovali, že při znovuzrození světa, až se Syn člověka posadí na trůnu své slávy, budete i vy sedět na dvanácti trůnech a budete soudit dvanáct pokolení Izraele. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A každý, kdo opustil domy nebo bratry nebo sestry nebo otce nebo matku nebo ženu nebo děti nebo pole kvůli mému jménu, vezme stokrát více a přijme věčný život za své dědictví. ");
INSERT INTO cesnkb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mnozí první však budou poslední a poslední první.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Nebeské království je totiž podobné hospodáři, který vyšel za svítání, aby najal dělníky na svou vinici. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Domluvil se s dělníky na denáru za den a poslal je na svou vinici. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A když okolo třetí denní hodiny vyšel ven, uviděl jiné, jak stojí na tržišti a zahálejí. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Řekl jim tedy: ‘Jděte i vy na tu vinici a dám vám, co bude spravedlivé.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A oni šli. Potom znovu vyšel ven kolem šesté a deváté hodiny a udělal totéž. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Když potom vyšel kolem jedenácté hodiny, našel jiné, jak stojí a zahálejí. Řekl jim: ‘Proč tu stojíte a celý den zahálíte?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Oni mu řekli: ‘Protože nás nikdo nenajal.’ Řekl jim tedy: ‘Jděte i vy na tu vinici a dostanete, co bude spravedlivé.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Když pak nastal večer, řekl pán vinice svému správci: ‘Zavolej dělníky a zaplať jim mzdu, počínaje od posledních až po první.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A když přišli ti, kdo byli najati kolem jedenácté hodiny, dostali každý po jednom denáru. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Když pak přišli ti první, mysleli si, že dostanou víc, ale i oni dostali každý jeden denár. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","A když ho dostali, začali reptat proti hospodáři. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Říkali: ‘Tihle poslední pracovali jednu hodinu a tys je postavil naroveň nám, kteří jsme nesli břemeno celého dne a horko.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","On však jednomu z nich odpověděl: ‘Příteli, já ti nekřivdím. Copak ses se mnou nedomluvil na denáru? ");
INSERT INTO cesnkb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vezmi si, co je tvoje, a běž, já ale chci dát tomuto poslednímu stejně jako tobě. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Copak si nesmím na svém dělat, co chci? Anebo máš závistivé oko, protože jsem dobrý?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Takto budou poslední první a první poslední. Je totiž mnoho povolaných, ale málo vyvolených.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","A když Ježíš putoval vzhůru do Jeruzaléma, vzal si na cestě svých dvanáct učedníků stranou a řekl jim: ");
INSERT INTO cesnkb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hle, jdeme do Jeruzaléma a tam bude Syn člověka vydán velekněžím a zákoníkům a ti ho odsoudí k smrti. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Vydají ho pohanům, aby se mu vysmívali, zbičovali ho a ukřižovali, ale třetího dne bude vzkříšen.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tehdy k němu přišla matka Zebedeových synů se svými syny, klaněla se mu a o něco ho prosila. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Řekl jí tedy: “Co chceš?” Ona řekla: “Řekni, ať tito dva moji synové mohou sedět ve tvém království jeden po tvé pravici a druhý po tvé levici.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ježíš jí ale odpověděl: “Vy nevíte o co prosíte. Můžete pít kalich, který já mám pít, a být pokřtěni křtem, kterým se já křtím?” Řekli mu: “Můžeme.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","On jim řekl: “Můj kalich budete opravdu pít a křtem, kterým se já křtím, budete pokřtěni, avšak dát vám sedět po mé pravici a po mé levici, to není má věc, ale patří těm, pro které to připravil můj Otec.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","A když to uslyšelo ostatních deset, rozhořčili se na ty dva bratry. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ježíš je ale zavolal k sobě a řekl: “Víte, že vládcové národů nad nimi panují a velikáni nad nimi užívají moc. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tak to ale mezi vámi nebude. Kdokoli by mezi vámi chtěl být veliký, ať je vaším služebníkem. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A kdokoli by mezi vámi chtěl být první, ať je vaším otrokem. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Právě tak Syn člověka nepřišel, aby se mu sloužilo, ale aby sloužil a aby dal svůj život jako výkupné za mnohé.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Když pak vycházeli z Jericha, šel za ním veliký zástup. ");
INSERT INTO cesnkb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A hle, dva slepci sedící u cesty uslyšeli, že tudy jde Ježíš a vykřikli: “Pane, Synu Davidův, smiluj se nad námi!” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Zástup je přísně napomínal, aby mlčeli, ale oni křičeli tím více: “Pane, Synu Davidův, smiluj se nad námi!” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ježíš se tedy zastavil, zavolal je a řekl: “Co chcete, abych pro vás udělal?” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Oni mu řekli: “Pane, ať se otevřou naše oči.” ");
INSERT INTO cesnkb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ježíš se tedy, naplněn soucitem, dotkl jejich očí a oni ihned prohlédli a šli za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Když se pak přiblížili k Jeruzalému a přišli do Betfagé k Olivetské hoře, tehdy Ježíš poslal dva učedníky ");
INSERT INTO cesnkb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a řekl jim: “Jděte do té vesnice naproti vám a hned tam najdete přivázanou oslici a s ní oslátko. Odvažte je a přiveďte ke mně. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A kdyby vám někdo něco řekl, odpovězte: ‘Pán je potřebuje’ a on je propustí.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","To všechno se stalo, aby se naplnilo to, co bylo řečeno skrze proroka: ");
INSERT INTO cesnkb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Povězte dceři Sionu: Pohleď, tvůj král přichází k tobě mírný, sedící na oslici, totiž na oslátku, mláděti té podrobené jhu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Učedníci tedy šli a udělali, jak jim Ježíš přikázal. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Přivedli oslici i oslátko, položili na ně své pláště a posadili ho na ně. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Veliký zástup pak rozprostíral své pláště na cestě a jiní sekali větve ze stromů a stlali je na cestu. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A zástupy, které šly zpředu i zezadu, volaly: “Hosana, Synu Davidův! Požehnaný, který přichází v Pánově jménu! Hosana na výsostech!” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Když pak vjel do Jeruzaléma, celé město se otřáslo a řeklo: “Kdo to je?” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A zástupy říkaly: “To je Ježíš, ten prorok z galilejského Nazaretu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ježíš pak vešel do Božího chrámu a vyhnal všechny, kdo v chrámu prodávali a kupovali, a zpřevracel stoly směnárníků i sedačky prodavačů holubic. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Řekl jim: “Je napsáno: ‘Můj dům bude nazván domem modlitby,’ ale vy jste z něj udělali ‘doupě lupičů’!” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tehdy k němu v chrámu přišli slepí a chromí a on je uzdravil. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Když ale velekněží a zákoníci uviděli divy, které dělal, a děti, jak křičí v chrámu a říkají: “Hosana, Synu Davidův!” rozhořčili se ");
INSERT INTO cesnkb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","a řekli mu: “Slyšíš, co říkají?” Ježíš jim řekl: “Ovšem. Copak jste nikdy nečetli: ‘Z úst nemluvňátek a kojenců sis připravil chválu’?” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Potom je opustil a odešel ven z města do Betanie a tam přenocoval. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Když se potom za svítání vracel do města, dostal hlad. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A když uviděl u cesty jeden fíkovník, šel k němu, ale nenašel na něm nic než listí. Řekl mu tedy: “Ať se z tebe navěky už neurodí ovoce!” A ten fíkovník hned uschl. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Když to viděli učedníci, podivili se a řekli: “Jak to, že ten fíkovník tak rychle uschl?” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ježíš jim tedy odpověděl: “Amen, říkám vám, pokud budete mít víru a nebudete pochybovat, nejenže budete moci tohle udělat fíkovníku, ale i kdybyste řekli této hoře: ‘Zvedni se a vrhni se do moře!’ stane se to. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","A všechno, o cokoli byste prosili v modlitbě, dostanete, když budete věřit.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Když pak přišel do chrámu, přistoupili k němu velekněží a starší lidu, když vyučoval, a řekli mu: “Jakou mocí děláš tyto věci? A kdo ti tu moc dal?” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ježíš jim odpověděl: “Já se vás také zeptám na jednu věc, a když mi ji řeknete, já vám také řeknu, jakou mocí dělám tyto věci. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Odkud byl Janův křest? Z nebe, nebo z lidí?” Začali se tedy mezi sebou dohadovat. Říkali si: “Kdybychom řekli, že z nebe, řekne nám: ‘Proč jste mu tedy neuvěřili?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Když řekneme, že z lidí..., bojíme se zástupu, protože všichni mají Jana za proroka.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A tak Ježíši odpověděli: “Nevíme.” A on jim řekl: “Ani já vám tedy neřeknu, jakou mocí dělám tyto věci.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ale co myslíte? Jeden člověk měl dva syny. Přistoupil k prvnímu a řekl: ‘Synu, jdi dnes pracovat na mou vinici.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","On odpověděl: ‘Nechci,’ ale pak si to rozmyslel a šel. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Potom přistoupil k druhému a řekl mu totéž. Ten odpověděl: ‘Já půjdu, pane,’ ale nešel. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Který z těch dvou naplnil otcovu vůli?” Řekli: “Ten první.” Ježíš jim tedy řekl: “Amen, říkám vám, že celníci a nevěstky jdou do Božího království před vámi. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jan k vám totiž přišel cestou spravedlnosti a vy jste mu neuvěřili, ale celníci a nevěstky mu uvěřili. Vy jste to viděli, ale ani potom jste si nerozmysleli, že mu uvěříte.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Poslouchejte jiné podobenství: Byl jeden hospodář, který vysadil vinici, obehnal ji plotem, vykopal v ní lis a postavil věž. Pak ji pronajal vinařům a odešel na cestu. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Když se pak přiblížil čas vinobraní, poslal k vinařům své služebníky, aby převzali její úrodu. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Vinaři však vzali jeho služebníky a jednoho zbili, jiného zabili a dalšího ukamenovali. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Poslal tedy znovu jiné služebníky, více než předtím, a těm udělali totéž. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nakonec k nim poslal svého syna. Řekl si: ‘Mého syna budou mít ve vážnosti.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Když ale vinaři toho syna uviděli, řekli si: ‘Tohle je dědic, pojďme, zabijme ho a zmocněme se jeho dědictví.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Potom ho chytili, vyhodili z vinice ven a zabili. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Co tedy udělá pán vinice těm vinařům, až přijde?” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Oni mu řekli: “Ty zlosyny zle zahubí a vinici pronajme jiným vinařům, kteří mu budou odevzdávat ovoce v čas jeho sklizně. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ježíš jim řekl: “Nikdy jste nečetli v Písmech? ‘Kámen, který stavitelé zavrhli, se stal hlavním kamenem klenby. Stalo se to od Pána a je to v našich očích div.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Proto vám říkám, že vám bude Boží království vzato a bude dáno lidu přinášejícímu jeho ovoce. ");
INSERT INTO cesnkb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","A kdo by padl na ten kámen, bude roztříštěn, a na koho by padl, toho rozdrtí na prach.” ");
INSERT INTO cesnkb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Když velekněží a farizeové slyšeli ta jeho podobenství, pochopili, že mluvil o nich, ");
INSERT INTO cesnkb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","a chtěli ho zatknout, ale zalekli se zástupů, protože lidé ho měli za proroka. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ježíš k nim pak znovu mluvil v podobenstvích a řekl: ");
INSERT INTO cesnkb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nebeské království je podobné králi, který svému synu vystrojil svatbu. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Poslal své služebníky, aby svolali na svatbu ty, kdo byli pozváni, ale oni nechtěli přijít. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Poslal tedy znovu jiné služebníky a řekl jim: ‘Povězte pozvaným: Hle, připravil jsem pro vás svou hostinu. Moji býci a můj vykrmený dobytek jsou zabiti a všechno je připraveno; pojďte na svatbu!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Oni však na to nedbali a odešli jeden na svůj statek a jiný za svým obchodem. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ostatní se pak chopili jeho služebníků, potupili je a zabili. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Když to král uslyšel, rozhněval se, poslal svá vojska a ty vrahy zahubil a jejich město spálil. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tehdy řekl svým služebníkům: ‘Svatba je sice připravena, ale ti, kdo byli pozváni, nebyli hodni. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Proto jděte na nároží, a kohokoli najdete, zvěte na svatbu. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A ti služebníci vyšli na ulice a shromáždili všechny, které našli - zlé i dobré, a tak se svatební místnost naplnila hodovníky. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tehdy vešel král, aby se podíval na hosty, a uviděl tam člověka, který nebyl oblečen do svatebního roucha. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Řekl mu: ‘Příteli, jak jsi sem vešel bez svatebního roucha?’ A on oněměl. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Král tedy řekl služebníkům: ‘Svažte mu nohy a ruce, vezměte ho a uvrhněte do té zevnější tmy! Tam bude pláč a skřípění zubů.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Je totiž mnoho povolaných, ale málo vyvolených.” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tehdy farizeové odešli a radili se, jak by ho mohli chytit za slovo. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pak k němu poslali své učedníky s herodiány a ti řekli: “Mistře, víme, že jsi pravdomluvný a pravdivě učíš Boží cestě a na nikoho nedbáš, neboť se neohlížíš na to, kdo je kdo. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Proto nám řekni, co si myslíš: Je správné dávat císaři daň nebo ne?” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ježíš ale znal jejich zlomyslnost a řekl jim: “Proč mě pokoušíte, pokrytci? ");
INSERT INTO cesnkb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ukažte mi peníz daně.” Přinesli mu tedy denár. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Řekl jim: “Čí je tento obraz a nápis?” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Odpověděli: “Císařův.” Tehdy jim řekl: “Dejte tedy to, co je císařovo, císaři, a co je Božího, Bohu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","A když to uslyšeli, podivili se. Potom ho opustili a odešli. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","V ten den k němu přišli saduceové, kteří říkají, že není vzkříšení, a zeptali se ho: ");
INSERT INTO cesnkb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mistře, Mojžíš řekl, že když někdo zemře bez dětí, aby si jeho bratr právem švagrovství vzal jeho ženu a zplodil svému bratru potomka. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","U nás bylo sedm bratrů. První se oženil a zemřel, a protože neměl potomky, zanechal svou ženu svému bratru. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Totéž se stalo i s druhým a třetím bratrem, až po sedmého. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Poslední ze všech pak zemřela i ta žena. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kterému z těch sedmi tedy bude manželkou při vzkříšení? Měli ji přece všichni!” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ježíš jim však odpověděl: “Bloudíte, protože neznáte Písma ani Boží moc. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Vždyť při vzkříšení se lidé nežení ani nevdávají, ale jsou jako Boží andělé v nebi. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ale ohledně zmrtvýchvstání - copak jste nečetli, co vám Bůh řekl slovy: ");
INSERT INTO cesnkb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Já jsem Bůh Abrahama, Bůh Izáka a Bůh Jákoba’? Bůh není Bohem mrtvých, ale živých!” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","A když to uslyšely zástupy, žasly nad jeho učením. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Když pak farizeové uslyšeli, že Ježíš umlčel saduceje, sešli se spolu. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Potom se jeden z nich, učený v Zákoně, zeptal, aby ho vyzkoušel: ");
INSERT INTO cesnkb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mistře, které je největší přikázání v Zákoně?” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ježíš mu řekl: “‘Budeš milovat Pána, svého Boha, celým svým srdcem, celou svou duší a celou svou myslí.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","To je první a největší přikázání. ");
INSERT INTO cesnkb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Druhé je mu podobné: ‘Budeš milovat svého bližního jako sám sebe.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na těchto dvou přikázáních spočívá celý Zákon i Proroci.” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","A když už se farizeové sešli, Ježíš se jich zeptal: ");
INSERT INTO cesnkb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Co si myslíte o Kristu? Čí je to syn?” Řekli mu: “Davidův.” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","On jim řekl: “Jak ho tedy může David v Duchu nazývat Pánem? Vždyť říká: ");
INSERT INTO cesnkb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Pán řekl mému Pánu: Seď po mé pravici, dokud nepoložím tvé nepřátele za podnož tvých nohou.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Když ho tedy David nazývá Pánem, jak to může být jeho syn?” ");
INSERT INTO cesnkb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","A nikdo mu nemohl odpovědět ani slovo. Od toho dne se ho už nikdo neodvážil na nic zeptat. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tehdy Ježíš mluvil k zástupům a svým učedníkům. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Řekl: “Na Mojžíšově místě se posadili zákoníci a farizeové. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Proto plňte a zachovávejte všechno, cokoli vám řeknou, abyste zachovávali, ale nejednejte podle jejich skutků, protože oni mluví, ale nejednají. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Svazují těžká a neúnosná břemena a nakládají je lidem na ramena, sami však s nimi nechtějí ani pohnout prstem. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","A všechny své skutky dělají, aby je viděli lidé. Rozšiřují své modlitební řemínky a prodlužují si třásně na pláštích. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mají rádi čestná místa na večeřích a přední sedadla ve shromážděních, ");
INSERT INTO cesnkb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","zdravení na tržištích, a když je lidé nazývají: ‘Rabbi, Rabbi.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Vy si ale nenechte říkat ‘Rabbi’, protože máte jednoho Učitele, Krista, a vy všichni jste bratři. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A nikoho si na zemi nenazývejte ‘Otcem’, protože máte jednoho Otce, který je v nebi. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Také si nenechte říkat ‘Vůdcové’, protože máte jednoho Vůdce, Krista. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ale kdo je z vás největší, ten bude vaším služebníkem. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kdo bude sám sebe povyšovat, ten bude ponížen, a kdo se sám poníží, ten bude povýšen.” ");
INSERT INTO cesnkb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ale běda vám, zákoníci a farizeové, vy pokrytci, že zavíráte nebeské království před lidmi. Sami tam totiž nevcházíte a těm, kteří vcházejí, vejít nedovolujete. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Běda vám, zákoníci a farizeové, vy pokrytci, že vyjídáte domy vdov a předstíráte dlouhé modlitby. Proto dostanete těžší rozsudek. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Běda vám, zákoníci a farizeové, vy pokrytci, že obcházíte moře i souš, abyste obrátili jednoho člověka na víru, a když se tak stane, uděláte z něho syna pekla dvakrát více, než jste sami. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Běda vám, slepí vůdcové, kteří říkáte: ‘Kdyby někdo přísahal při chrámu, to nic neznamená, ale kdo by přísahal při chrámovém zlatu, ten je zavázán.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Blázni a slepci! Co je větší - zlato nebo chrám, který to zlato posvěcuje? ");
INSERT INTO cesnkb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Říkáte také: ‘Kdyby někdo přísahal při oltáři, to nic neznamená, ale kdo by přísahal při daru ležícím na něm, ten je zavázán.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Blázni a slepci! Co je větší - dar nebo oltář, který ten dar posvěcuje? ");
INSERT INTO cesnkb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","A proto ten, kdo přísahá při oltáři, přísahá při něm i při všem, co na něm leží. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ten, kdo přísahá při chrámu, přísahá při něm i při Tom, kdo v něm přebývá, ");
INSERT INTO cesnkb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","a ten, kdo přísahá při nebi, přísahá při Božím trůnu i při Tom, který na něm sedí. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Běda vám, zákoníci a farizeové, vy pokrytci, že dáváte desátky z máty, z kopru a z kmínu, ale opustili jste závažnější věci ze Zákona - právo, milosrdenství a víru. Tyto věci jste měli dělat a tamty neopouštět. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Slepí vůdcové, cedíte komára, ale velblouda polykáte. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Běda vám, zákoníci a farizeové, vy pokrytci, že zvenčí čistíte kalich a mísu, ale ty jsou zevnitř plné zlodějství a neřesti. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizeji, ty slepče, vyčisti nejdříve vnitřek kalicha a mísy, aby mohly být čisté i zvenčí. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Běda vám, zákoníci a farizeové, vy pokrytci, protože se podobáte obíleným hrobům, které zvenčí vypadají opravdu krásně, ale uvnitř jsou plné mrtvých kostí a veškeré nečistoty. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tak se i vy zvenčí zdáte lidem opravdu spravedliví, ale uvnitř jste plní pokrytectví a nepravosti. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Běda vám, zákoníci a farizeové, vy pokrytci, že stavíte hroby prorokům, ozdobujete náhrobky spravedlivých ");
INSERT INTO cesnkb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","a říkáte: ‘Kdybychom žili za dnů našich otců, neúčastnili bychom se s nimi prolévání krve proroků.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tím svědčíte sami proti sobě, že jste synové těch, kdo vraždili proroky. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Naplňte tedy míru svých otců! ");
INSERT INTO cesnkb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Vy hadi, plemeno zmijí, jak byste unikli odsouzení do pekla? ");
INSERT INTO cesnkb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pohleďte, já k vám proto posílám proroky, mudrce a učitele Písma, a vy některé z nich zabijete a ukřižujete, a některé z nich budete bičovat ve svých shromážděních a budete je pronásledovat od města k městu, ");
INSERT INTO cesnkb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","aby na vás přišla všechna spravedlivá krev prolévaná na zemi, od krve spravedlivého Ábela až po krev Zachariáše, syna Barachiáše, kterého jste zabili mezi svatyní a oltářem. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Amen, říkám vám, že všechny tyto věci přijdou na toto pokolení.” ");
INSERT INTO cesnkb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jeruzaléme, Jeruzaléme, který zabíjíš proroky a kamenuješ ty, kteří jsou k tobě posíláni! Kolikrát jsem chtěl shromáždit tvé děti, jako slepice shromažďuje svá kuřata pod křídla, ale nechtěli jste. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hle, váš dům se vám zanechává pustý. ");
INSERT INTO cesnkb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Říkám vám totiž, že od této chvíle mě neuvidíte, dokud neřeknete: ‘Požehnaný, který přichází v Pánově jménu!’” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","A když Ježíš vyšel z chrámu a odcházel pryč, tu k němu přistoupili jeho učedníci, aby mu ukázali chrámové stavby. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ježíš jim však řekl: “Vidíte všechny tyto věci? Říkám vám jistě, že tu nebude ponechán kámen na kameni: všechno bude zbořeno.” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Když se pak posadil na Olivetské hoře, přistoupili k němu učedníci soukromě se slovy: “Řekni nám, kdy to bude a jaké bude znamení tvého příchodu a konce tohoto světa?” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ježíš jim odpověděl: “Dejte pozor, aby vás nikdo nesvedl. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mnozí totiž přijdou pod mým jménem a budou říkat: ‘Já jsem Kristus’ a svedou mnohé. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Budete pak slýchat války a zprávy o válkách. Hleďte, abyste se nestrachovali, protože se to všechno musí stát. Ale to ještě nebude konec. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Povstane totiž národ proti národu a království proti království a budou hlady, mory a zemětřesení na různých místech. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ale to všechno jsou počátky porodních bolestí. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tehdy vás vydají soužení a budou vás zabíjet a budete nenáviděni všemi národy kvůli mému jménu. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tehdy se mnozí pohorší a budou se vzájemně zrazovat a nenávidět jedni druhé ");
INSERT INTO cesnkb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","a povstane mnoho falešných proroků a svedou mnohé. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A protože se rozmnoží nepravost, láska mnohých vychladne. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kdo však vytrvá až do konce, ten bude spasen. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A toto evangelium království bude kázáno po celém světě na svědectví všem národům a tehdy přijde konec.” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Proto, když uvidíte ‘ohavnost zpustošení’, o níž mluvil prorok Daniel, jak stojí na svatém místě (kdo čte, rozuměj), ");
INSERT INTO cesnkb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tehdy ať ti, kdo jsou v Judsku, utíkají na hory. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kdo bude na střeše, ať nesestupuje, aby si ze svého domu něco vzal. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A kdo na poli, ať se nevrací zpátky, aby si vzal svůj plášť. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ale běda bude v těch dnech těhotným a těm, které kojí. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Proto se modlete, aby váš útěk nenastal v zimě nebo v sobotní den. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Protože tehdy bude veliké soužení, jaké do této doby nebylo od počátku světa, a už ani nikdy nebude. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A kdyby ty dny nebyly zkráceny, nezachránil by se žádný člověk. Kvůli vyvoleným však ty dny budou zkráceny.” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kdyby vám v té době někdo řekl: ‘Hle, Kristus je zde!’ anebo: ‘Tady je!’, nevěřte. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Povstanou totiž falešní kristové a falešní proroci a budou dělat veliké divy a zázraky, takže by svedli (kdyby to bylo možné) i vyvolené. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hle, řekl jsem vám to předem. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Řeknou-li vám tedy: ‘Pohleďte, je na poušti!’ nevycházejte; anebo: ‘Hle, je na tajných místech,’ nevěřte. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Neboť jako blesk vychází od východu a září až na západ, takový bude i příchod Syna člověka. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kdekoliv totiž bude tělo, tam se shromáždí orli. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","A hned po soužení těch dnů se zatmí slunce a měsíc nevydá své světlo. Hvězdy budou padat z nebe a nebeské mocnosti budou otřeseny. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Potom se na nebi objeví znamení Syna člověka a tehdy budou všechny národy země kvílet a spatří Syna člověka, jak přichází na nebeských oblacích s mocí a velikou slávou. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A on pošle své anděly s hlasitou polnicí a ti shromáždí jeho vyvolené od čtyř větrů, od jednoho konce nebe až po druhý.” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Naučte se tedy od fíkovníku tomuto podobenství: Když již jeho větev změkne a vyráží listí, poznáváte, že léto je blízko. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tak i vy, až uvidíte toto všechno, vězte, že je blízko, že už je ve dveřích. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Amen, říkám vám, že toto pokolení rozhodně nepomine, než se toto všechno stane. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nebe a země pominou, ale má slova nikdy nepominou.” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“O tom dni a hodině však nikdo neví - ani nebeští andělé - pouze sám můj Otec. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ale jak bylo za dnů Noéma, tak bude i při příchodu Syna člověka. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Neboť stejně jako v těch dnech před potopou jedli a pili, ženili se a vdávaly se až do toho dne, kdy Noé vešel do archy, ");
INSERT INTO cesnkb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","a nic nepoznali až do chvíle, kdy přišla potopa a všechny smetla, tak to bude i při příchodu Syna člověka. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tehdy budou dva na poli; jeden bude vzat a druhý zanechán. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dvě budou mlít mlýnským kamenem, jedna bude vzata a druhá zanechána. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Proto bděte, neboť nevíte, ve kterou hodinu přijde váš Pán. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Vězte však, že kdyby hospodář věděl, ve kterou noční dobu přijde zloděj, bděl by a nenechal by ho prokopat se do jeho domu. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Proto i vy buďte připraveni, neboť Syn člověka přijde v hodinu, o které netušíte.” ");
INSERT INTO cesnkb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kdo je tedy ten věrný a moudrý služebník, kterého jeho pán ustanovil nad svým služebnictvem, aby jim dával pokrm v patřičný čas? ");
INSERT INTO cesnkb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blaze tomu služebníku, kterého jeho pán při příchodu zastihne, že tak jedná. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Amen, říkám vám, že ho ustanoví nad vším svým majetkem. ");
INSERT INTO cesnkb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kdyby si však ten zlý služebník v srdci řekl: ‘Můj pán mešká se svým příchodem,’ ");
INSERT INTO cesnkb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a začal by bít své spoluslužebníky a jíst a pít s opilci, ");
INSERT INTO cesnkb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tehdy přijde pán toho služebníka v den, kdy to nečeká, a v hodinu, kterou nezná, ");
INSERT INTO cesnkb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","a oddělí ho a určí mu díl s pokrytci. Tam bude pláč a skřípění zubů.” ");
INSERT INTO cesnkb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tehdy bude nebeské království podobné deseti pannám, které vzaly své lampy a vyšly naproti ženichovi. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pět z nich bylo rozumných a pět pošetilých. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Když ty pošetilé braly své lampy, nevzaly si s sebou olej. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ty rozumné si však se svými lampami vzaly také olej v nádobkách. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Když pak ženich dlouho nepřicházel, začaly všechny podřimovat a usínat. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A o půlnoci nastal křik: ‘Hle, ženich přichází! Vyjděte mu vstříc!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Všechny panny tedy vstaly a připravily si své lampy. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pošetilé pak řekly těm rozumným: ‘Dejte nám ze svého oleje, protože naše lampy hasnou.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ty rozumné jim ale odpověděly: ‘Nebude ho dost pro nás i pro vás. Raději jděte k prodavačům a kupte si.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A když odešly kupovat olej, přišel ženich a ty, které byly připravené, s ním vešly na svatbu. A dveře byly zavřeny. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Potom ale přišly také ty zbývající panny a říkaly: ‘Pane, pane, otevři nám!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ale on jim odpověděl: ‘Amen, říkám vám, že vás neznám.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bděte tedy, protože neznáte den ani hodinu, ve kterou přijde Syn člověka.” ");
INSERT INTO cesnkb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Je to totiž jako když člověk při odchodu na cestu zavolal své služebníky a svěřil jim svůj majetek. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jednomu dal pět hřiven, jinému dvě a jinému jednu, každému podle jeho schopností, a odešel na cestu. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ten, který dostal pět hřiven, ihned šel, nechal je vydělávat a získal jiných pět hřiven. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Stejně tak i ten, který dostal dvě, získal jiné dvě. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ale ten, který dostal jednu, odešel, zakopal ji v zemi a tak skryl peníze svého pána. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Potom po dlouhé době pán těch služebníků přišel a počítal s nimi účty. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Když přistoupil ten, který dostal pět hřiven, přinesl pět dalších hřiven a řekl: ‘Pane, dal jsi mi pět hřiven a podívej se, získal jsem pět dalších.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jeho pán mu tedy řekl: ‘Výborně, můj dobrý a věrný služebníku. Byl jsi věrný nad málem, proto tě ustanovím nad mnohým. Vejdi do radosti svého pána.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Potom přistoupil ten, který dostal dvě hřivny a řekl: ‘Pane, dal jsi mi dvě hřivny a podívej se, získal jsem další dvě.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jeho pán mu řekl: ‘Výborně, můj dobrý a věrný služebníku. Byl jsi věrný nad málem, ustanovím tě nad mnohým. Vejdi do radosti svého pána.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Potom přistoupil i ten, který dostal jednu hřivnu a řekl: ‘Pane, věděl jsem, že jsi přísný člověk, že sklízíš, kde jsi nezasel, a sbíráš, kde jsi nerozsypal. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","A tak jsem odešel a skryl tvou hřivnu v zemi, protože jsem se bál. Pohleď, zde máš, co je tvoje.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jeho pán mu však odpověděl: ‘Ty zlý a líný služebníku! Věděl jsi, že sklízím, kde jsem nezasel, a sbírám, kde jsem nerozsypal! ");
INSERT INTO cesnkb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Měl jsi tedy dát mé peníze směnárníkům a já bych, až přijdu, vzal, co mi patří i s úrokem. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vezměte mu tedy tu hřivnu a dejte ji tomu, kdo má deset hřiven. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Každému, kdo má, totiž bude dáno a bude mít hojnost, ale tomu, kdo nemá, bude vzato i to, co má. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A toho neužitečného služebníka vyhoďte do té zevnější tmy. Tam bude pláč a skřípění zubů.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Když pak přijde Syn člověka ve své slávě a s ním všichni svatí andělé, tehdy se posadí na trůnu své slávy. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Všechny národy budou shromážděny před ním a on je oddělí jedny od druhých, tak jako pastýř odděluje ovce od kozlů. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ovce postaví po své pravici, ale kozly po levici. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Potom král řekne těm po své pravici: ‘Pojďte vy, kdo jste požehnaní od mého Otce, přijměte za své dědictví to království, které je pro vás připraveno od založení světa. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Neboť jsem hladověl a vy jste mi dali najíst, měl jsem žízeň a dali jste mi napít, byl jsem cizincem a přijali jste mě. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Byl jsem nahý a oblékli jste mě, byl jsem nemocný a navštívili jste mě, byl jsem ve vězení a přišli jste za mnou.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tehdy mu ti spravedliví odpoví: ‘Pane, kdy jsme tě viděli hladového a nakrmili tě, anebo žíznivého a dali jsme ti napít? ");
INSERT INTO cesnkb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kdy jsme tě viděli jako cizince a přijali tě, anebo nahého a oblékli tě? ");
INSERT INTO cesnkb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kdy jsme tě viděli nemocného anebo v žaláři a přišli jsme k tobě?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A král jim odpoví: ‘Amen, říkám vám, že cokoli jste udělali nejmenšímu z těchto mých bratrů, to jste udělali mně.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Potom řekne také těm po levici: ‘Jděte ode mě, vy proklatí, do věčného ohně, který je připraven pro ďábla a jeho anděly, ");
INSERT INTO cesnkb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","protože jsem hladověl a nedali jste mi najíst, měl jsem žízeň a nedali jste mi napít. ");
INSERT INTO cesnkb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Byl jsem cizincem a nepřijali jste mě, nahý a neoblékli jste mě, byl jsem nemocný a ve vězení a vy jste mě nenavštívili.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tehdy mu odpovědí i oni a řeknou: ‘Pane, kdy jsme tě viděli hladového nebo žíznivého nebo jako cizince nebo nahého nebo nemocného nebo ve vězení a neposloužili jsme ti?’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tehdy jim odpoví: ‘Amen, říkám vám, že cokoli jste neudělali nejmenšímu z těchto, to jste neudělali mně!’ ");
INSERT INTO cesnkb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","A tak tito půjdou do věčných muk, ale spravedliví do věčného života.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","A stalo se, že když Ježíš dokončil všechna tato slova, řekl svým učedníkům: ");
INSERT INTO cesnkb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Víte, že za dva dny bude Veliká noc a Syn člověka bude zrazen, aby byl ukřižován.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tehdy se na dvoře nejvyššího kněze jménem Kaifáš sešli velekněží, zákoníci a starší lidu ");
INSERT INTO cesnkb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","a radili se spolu, jak by se Ježíše lstí zmocnili a zabili ho. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Říkali ale: “Ne ve svátek, aby mezi lidem nenastalo pozdvižení.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Když pak byl Ježíš v Betanii, v domě Šimona Malomocného, ");
INSERT INTO cesnkb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","přistoupila k němu žena s alabastrovou nádobkou velmi drahé masti a vylila ji na jeho hlavu, když byl za stolem. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Když to však uviděli jeho učedníci, rozhořčili se a říkali: “K čemu je tato ztráta? ");
INSERT INTO cesnkb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Vždyť se to mohlo draze prodat a rozdat chudým!” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ježíš to však poznal a řekl jim: “Proč tu ženu trápíte? Vždyť pro mě udělala dobrý skutek. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chudé přece máte u sebe vždycky, ale mne vždycky mít nebudete. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Když totiž tato žena vylila tu mast na mé tělo, udělala to pro můj pohřeb. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Amen, říkám vám, že kdekoli se na celém světě bude kázat toto evangelium, bude se mluvit také o tom, co udělala ona, na její památku.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tehdy jeden ze dvanácti, jménem Jidáš Iškariotský, šel k velekněžím ");
INSERT INTO cesnkb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a řekl jim: “Co jste mi ochotni dát, když vám ho zradím?” A oni mu odpočítali třicet stříbrných. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Od té chvíle tedy hledal příležitost, aby ho zradil. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Prvního dne svátku nekvašených chlebů pak k Ježíši přistoupili učedníci a řekli mu: “Kde chceš, abychom ti připravili k jídlu beránka?” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A on jim řekl: “Jděte k jednomu člověku ve městě a řekněte mu: ‘Mistr vzkazuje: Můj čas je blízko. U tebe budu se svými učedníky slavit Hod beránka.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Učedníci tedy udělali, jak jim Ježíš uložil, a připravili beránka. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Když pak nastal večer, byl za stolem s dvanácti. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","A když jedli, řekl: “Amen, říkám vám, že jeden z vás mě zradí.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oni tedy v nesmírném zármutku začali jeden po druhém říkat: “Snad to nejsem já, Pane?” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ale on jim odpověděl: “Zradí mě ten, kdo se mnou namáčí ruku do mísy. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Syn člověka jde vskutku tak, jak je o něm napsáno, ale běda člověku, jímž je Syn člověka zrazován. Pro toho člověka by bylo lepší, kdyby se vůbec nenarodil.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nato řekl Jidáš, který ho zrazoval: “Snad to nejsem já, Rabbi?” A on mu odpověděl: “Tys to řekl.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","A když jedli, vzal Ježíš chléb, požehnal, rozlomil a dal ho učedníkům se slovy: “Vezměte, jezte, to je mé tělo.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Potom vzal kalich, vzdal díky a podal jim ho se slovy: “Pijte z něho všichni, ");
INSERT INTO cesnkb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","neboť to je má krev nové smlouvy, která se prolévá za mnohé na odpuštění hříchů. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A říkám vám, že od této chvíle už nebudu pít z tohoto plodu vinného kmene až do toho dne, kdy ho s vámi budu pít nový v království svého Otce.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","A když zazpívali žalm, vyšli na Olivetskou horu. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tehdy jim Ježíš řekl: “Vy všichni ode mne této noci odpadnete. Je přece napsáno: ‘Budu bít pastýře a ovce stáda se rozprchnou.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ale až vstanu z mrtvých, předejdu vás do Galileje.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petr mu však odpověděl: “I kdyby od tebe všichni odpadli, já neodpadnu nikdy!” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ježíš mu řekl: “Amen, říkám ti, že ještě dnes v noci, dříve než se ozve kohout, mě třikrát zapřeš.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ale Petr mu řekl: “I kdybych měl s tebou zemřít, nikdy tě nezapřu!” Podobně mluvili i všichni ostatní učedníci. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tehdy Ježíš přišel s učedníky na místo zvané Getsemane a řekl jim: “Posaďte se tu, zatímco se odejdu tamhle modlit.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Vzal s sebou Petra a oba Zebedeovy syny a tu se začal rmoutit a mít velikou úzkost. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tehdy jim řekl: “Má duše je smutná až k smrti. Zůstaňte tu a bděte se mnou.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pak poodešel kousek dál, padl na tvář a modlil se: “Otče můj, jestli je to možné, ať mě ten kalich mine! Avšak ne jak chci já, ale jak ty.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Potom přišel k učedníkům a nalezl je, jak spí. Řekl tedy Petrovi: “To jste se mnou nemohli bdít jedinou hodinu? ");
INSERT INTO cesnkb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bděte a modlete se, abyste nevešli do pokušení. Duch je sice připraven, ale tělo je slabé.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Potom odešel podruhé a modlil se: “Otče můj, jestliže mě tento kalich nemůže minout, ale musím ho vypít, ať se stane tvá vůle.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A když přišel, znovu je nalezl, jak spí, protože jim ztěžkly oči. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tehdy je nechal, znovu odešel a potřetí se modlil stejná slova. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Potom přišel ke svým učedníkům a řekl jim: “Vy ještě spíte a odpočíváte? Pohleďte, přiblížila se ta hodina a Syn člověka je vydáván do rukou hříšníků. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Vstávejte, pojďme! Hle, můj zrádce už je blízko.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","A když ještě mluvil, náhle přišel Jidáš, jeden ze dvanácti, a s ním veliký zástup s meči a holemi, poslaný od velekněží a starších z lidu. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ten, který ho zrazoval, si s nimi domluvil znamení: “Je to ten, kterého políbím. Toho se chopte.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ihned tedy přistoupil k Ježíši a řekl: “Buď zdráv, Rabbi,” a políbil ho. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ježíš mu však řekl: “Příteli, proč jsi přišel?” Tehdy přistoupili, vztáhli na Ježíše ruce a chopili se ho. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jeden z těch, kdo byli s Ježíšem, však náhle mávl rukou, vytasil svůj meč, zasáhl služebníka nejvyššího kněze a usekl mu ucho. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tehdy mu Ježíš řekl: “Vrať svůj meč na jeho místo, protože všichni, kteří berou meč, mečem zahynou. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Myslíš si snad, že nemohu požádat svého Otce? On by mi hned dal více než dvanáct legií andělů. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jak by se pak ale naplnila Písma svědčící, že to musí takhle být?” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","V tu chvíli řekl Ježíš zástupům: “Vypravili jste se jako na zločince, s meči a holemi, abyste mě zatkli? Každý den jsem s vámi sedával v chrámu a vyučoval a nezatkli jste mě. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ale toto všechno se stalo, aby se naplnila prorocká Písma.” Tehdy ho všichni učedníci opustili a utekli. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ti, kdo Ježíše zatkli, ho tedy odvedli k nejvyššímu knězi Kaifášovi, kde se shromáždili zákoníci a starší. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petr ho ale zpovzdálí následoval až na dvůr nejvyššího kněze. Potom vešel dovnitř a sedl si mezi sluhy, aby viděl konec. ");
INSERT INTO cesnkb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Velekněží a starší s celou veleradou pak proti Ježíši hledali falešné svědectví, aby ho mohli vydat na smrt, ");
INSERT INTO cesnkb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ale žádné nenašli. I když předstupovali mnozí falešní svědkové, nenašli nic. Nakonec ale předstoupili dva falešní svědkové ");
INSERT INTO cesnkb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a řekli: “Tento muž řekl: ‘Mohu zbořit Boží chrám a za tři dny ho postavit.’” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tehdy povstal nejvyšší kněz a řekl mu: “Nic neodpovídáš? Co proti tobě svědčí tito muži?” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ale Ježíš mlčel. Nejvyšší kněz mu tedy řekl: “Zapřísahám tě při živém Bohu, abys nám řekl, zda jsi Kristus, ten Boží Syn!” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ježíš mu odpověděl: “Tys to řekl. Ale říkám vám, od této chvíle uvidíte Syna člověka sedět po pravici Moci a přicházet na nebeských oblacích.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tehdy nejvyšší kněz roztrhl svá roucha se slovy: “Rouhal se! K čemu ještě potřebujeme svědky? Hle, právě jste slyšeli jeho rouhání! ");
INSERT INTO cesnkb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Co si o tom myslíte?” A oni odpověděli: “Je hoden smrti.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Potom mu plivali do obličeje a bili ho pěstmi a jiní ho tloukli holemi ");
INSERT INTO cesnkb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","a říkali: “Prorokuj nám, Kriste, kdo tě udeřil?” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petr ale seděl venku na dvoře. Jedna služebná k němu přistoupila a řekla: “Ty jsi byl také s tím Ježíšem z Galileje.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ale on to přede všemi zapřel. Řekl: “Nevím, o čem mluvíš!” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A vyšel k bráně. Uviděla ho však jiná a řekla těm, kdo tam byli: “Tenhle byl také s tím Ježíšem z Nazaretu.” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A on ho znovu zapřel s přísahou: “Toho člověka neznám!” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Po malé chvíli přistoupili kolemstojící a řekli Petrovi: “Jistěže jsi také jeden z nich. I tvé nářečí tě prozrazuje!” ");
INSERT INTO cesnkb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tehdy se začal proklínat a přísahat: “Toho člověka neznám!” A vtom zakokrhal kohout ");
INSERT INTO cesnkb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","a Petr si vzpomněl na slova, která mu Ježíš řekl: “Dříve než se ozve kohout, třikrát mě zapřeš.” A vyšel ven a hořce se rozplakal. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A když přišlo ráno, usnesli se všichni velekněží a starší lidu proti Ježíši, že ho vydají na smrt. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Svázali ho tedy, odvedli ho k vladaři, Pontskému Pilátovi, a vydali mu ho. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Když tehdy Jidáš, jeho zrádce, uviděl, že Ježíš byl odsouzen, litoval toho a vrátil těch třicet stříbrných velekněžím a starším. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Řekl jim: “Zhřešil jsem! Zradil jsem nevinnou krev!” Oni však odpověděli: “Co je nám do toho? Hleď si toho sám!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zahodil tedy ty stříbrné v chrámu a šel pryč. A když odešel, oběsil se. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Velekněží pak vzali ty stříbrné a řekli: “Nelze je dát do pokladny, protože je to mzda za krev.” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A když se poradili, koupili za ně hrnčířovo pole k pohřbívání cizinců. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Proto se to pole až dodnes nazývá Pole krve. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tehdy se naplnilo to, co bylo řečeno skrze proroka: “Vzali třicet stříbrných, cenu za toho ceněného, kterého takto ocenili synové Izraele, ");
INSERT INTO cesnkb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","a dali je za hrnčířovo pole, jak mi uložil Pán.” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ježíš pak stanul před vladařem. Vladař se ho zeptal: “Ty jsi ten židovský král?” Ale Ježíš mu odpověděl: “Ty to říkáš.” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A když ho velekněží a starší obviňovali, nic neodpovídal. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilát mu tedy řekl: “Neslyšíš, jaké věci to proti tobě svědčí?” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","On mu ale neodpověděl ani na jediné slovo, takže se vladař velmi divil. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vladař pak měl ve zvyku propouštět lidu ve svátek jednoho vězně, kterého chtěli. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A tehdy měli významného vězně jménem Barabáš. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Když se tedy lidé sešli, Pilát jim řekl: “Koho chcete, abych vám propustil? Barabáše nebo Ježíše zvaného Kristus?” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Věděl totiž, že ho vydali ze závisti. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","A když seděl na soudné stolici, poslala k němu jeho žena vzkaz: “Neměj nic s tímto spravedlivým, neboť jsem dnes kvůli němu ve snu mnoho vytrpěla.” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Velekněží a starší ale navedli zástupy, aby si vyžádali Barabáše a Ježíše aby dali zahubit. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Vladař jim tedy odpověděl: “Kterého z těch dvou chcete, abych vám propustil?” A oni řekli: “Barabáše!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilát jim řekl: “Co tedy mám udělat s Ježíšem zvaným Kristus?” A všichni řekli: “Ať je ukřižován!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Vladař však řekl: “A co zlého udělal?” Ale oni křičeli ještě víc: “Ať je ukřižován!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A když Pilát viděl, že nic nezmůže, ale že je čím dál větší pozdvižení, vzal vodu a před zástupem si umyl ruce se slovy: “Nejsem vinen krví tohoto spravedlivého. Hleďte si toho sami.” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A všechen lid odpověděl: “Jeho krev na nás a na naše děti!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tehdy jim propustil Barabáše, ale Ježíše nechal zbičovat a vydal ho k ukřižování. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tehdy vzali vladařovi vojáci Ježíše do paláce a shromáždili k němu celou posádku. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Svlékli ho a oblékli mu rudý plášť, ");
INSERT INTO cesnkb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","a když upletli korunu z trní, nasadili mu ji na hlavu a do pravé ruky mu dali hůl. Pak před ním klekali a posmívali se mu. Říkali: “Buď zdráv, židovský králi!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Plivali na něj a vzali tu hůl a bili ho do hlavy. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Když se mu dost naposmívali, svlékli z něho ten plášť a oblékli mu jeho šaty. Potom ho odvedli, aby byl ukřižován. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A když vyšli, našli člověka z Kyrény, jménem Šimona. Toho přinutili, aby vzal jeho kříž. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A tak přišli na místo zvané Golgota, což znamená Místo lebky. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dali mu napít octa smíšeného se žlučí. A když jej okusil, nechtěl pít. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A když ho ukřižovali, rozdělili si jeho šaty házením losu, aby se naplnilo, co bylo řečeno skrze proroka: “Rozdělili si mé šaty mezi sebou a o mé roucho házeli los.” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pak seděli a hlídali ho tam. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A nad jeho hlavu dali nápis jeho viny: “TOTO JE JEŽÍŠ, ŽIDOVSKÝ KRÁL”. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tehdy byli spolu s ním ukřižováni dva zločinci, jeden po pravici a druhý po levici. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kolemjdoucí mu spílali, pokyvovali hlavami ");
INSERT INTO cesnkb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a říkali: “Ty, který boříš chrám a za tři dny ho stavíš, zachraň sám sebe! Jestli jsi Boží Syn, sestup z kříže!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tak podobně se posmívali i velekněží se zákoníky a staršími a říkali: ");
INSERT INTO cesnkb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Jiné spasil, ale sám sebe spasit nemůže! Jestli je král Izraele, ať teď sestoupí z kříže a uvěříme v něj! ");
INSERT INTO cesnkb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Spoléhal na Boha, tak ať ho teď vysvobodí, jestli o něj stojí! Říkal přece: ‘Jsem Boží Syn’!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A tak podobně ho hanobili i zločinci, kteří byli ukřižováni s ním. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Od šesté hodiny pak nastala po celé zemi tma až do deváté hodiny. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kolem deváté hodiny pak Ježíš hlasitě vykřikl: “Eli, Eli, lama sabachtani?” to je: “Bože můj, Bože můj, proč jsi mě opustil?” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A když to uslyšeli někteří z kolemstojících, říkali: “Ten člověk volá Eliáše!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jeden z nich hned odběhl, vzal houbu, a když ji naplnil octem, dal ji na větev a dával mu napít. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ale ostatní říkali: “Nech ho, uvidíme, jestli přijde Eliáš, aby ho zachránil!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ježíš pak opět hlasitě vykřikl a vypustil ducha. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A hle, chrámová opona se roztrhla na dva kusy odshora až dolů a země se otřásla a skály popraskaly. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Otevřely se hroby a vstala mnohá těla zesnulých svatých, ");
INSERT INTO cesnkb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","kteří po jeho vzkříšení vyšli z hrobů, přišli do svatého města a ukázali se mnoha lidem. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Když pak setník a ti, kdo s ním hlídali Ježíše, uviděli zemětřesení a to, co se dělo, velmi se vyděsili a říkali: “To byl opravdu Boží Syn!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bylo tam také mnoho žen přihlížejících zpovzdálí, které doprovázely Ježíše z Galileje a sloužily mu. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Byla mezi nimi Marie Magdaléna a Marie, matka Jakuba a Jozese, a matka Zebedeových synů. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A když nastal večer, přišel bohatý člověk z Arimatie, jménem Josef, který byl také Ježíšův učedník. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ten přišel k Pilátovi a požádal o Ježíšovo tělo. Tehdy Pilát nařídil, aby tělo bylo vydáno. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef vzal tělo, zavinul ho do čistého plátna ");
INSERT INTO cesnkb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a pochoval ho do svého nového hrobu, který si vytesal ve skále. Potom přivalil ke dveřím hrobu velký kámen a odešel. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A byla tam Marie Magdaléna a druhá Marie, sedící naproti hrobu. ");
INSERT INTO cesnkb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nazítří, po dni připravování, se pak velekněží a farizeové sešli k Pilátovi ");
INSERT INTO cesnkb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","a řekli mu: “Pane, vzpomněli jsme si, že když ten bludař ještě žil, řekl: ‘Po třech dnech vstanu.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Proto nařiď, ať je hrob hlídán až do třetího dne, aby snad nepřišli jeho učedníci, neukradli ho a neřekli lidu: ‘Byl vzkříšen z mrtvých!’ Tak bude poslední blud horší než ten první!” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilát jim řekl: “Máte stráž, jděte a hlídejte, jak umíte.” ");
INSERT INTO cesnkb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A tak šli, a když zapečetili kámen, obsadili hrob strážnými. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Když pak končila sobota a svítalo na první den týdne, přišla Marie Magdaléna a ta druhá Marie, aby se podívaly na hrob. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A hle, nastalo veliké zemětřesení, neboť Pánův anděl sestoupil z nebe, a když přišel, odvalil kámen ode dveří a posadil se na něm. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jeho obličej byl jako blesk a jeho roucho bílé jako sníh. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A strážní se strachem z něj roztřásli a zůstali jako mrtví. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anděl pak odpověděl ženám: “Vy se nebojte. Vždyť vím, že hledáte ukřižovaného Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Není tu, neboť vstal, jak předpověděl. Pojďte, pohleďte na místo, kde ležel Pán. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jděte rychle a řekněte jeho učedníkům, že byl vzkříšen z mrtvých. A hle, předchází vás do Galileje. Tam ho spatříte. Hleďte, řekl jsem vám to.” ");
INSERT INTO cesnkb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A tak rychle odešly od hrobu s bázní a s velikou radostí a běžely, aby to oznámily jeho učedníkům. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A když to šly oznámit jeho učedníkům, vtom se s nimi setkal Ježíš a pozdravil je. Přistoupily tedy, objaly jeho nohy a poklonily se mu. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tehdy jim Ježíš řekl: “Nebojte se, jděte a oznamte mým bratrům, ať jdou do Galileje a tam mě spatří.” ");
INSERT INTO cesnkb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","A když ty ženy odcházely, hle, někteří ze stráže šli do města a oznámili velekněžím všechno, co se stalo. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A když se shromáždili se staršími, poradili se a dali vojákům mnoho peněz ");
INSERT INTO cesnkb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","a řekli: “Mluvte takhle: ‘V noci přišli jeho učedníci a ukradli ho, když jsme spali.’ ");
INSERT INTO cesnkb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A kdyby o tom uslyšel vladař, my ho přesvědčíme a zbavíme vás starostí.” ");
INSERT INTO cesnkb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Oni tedy vzali peníze a dělali, jak byli naučeni. A tato řeč je mezi Židy rozhlášena až do dnešního dne. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jedenáct učedníků pak šlo do Galileje, na tu horu, kterou jim Ježíš určil. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","A když ho spatřili, poklonili se mu; ale někteří pochybovali. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ježíš přistoupil, promluvil k nim a řekl: “Je mi dána veškerá moc na nebi i na zemi. ");
INSERT INTO cesnkb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Proto jděte, dělejte učedníky ze všech národů; křtěte je ve jméno Otce i Syna i Ducha Svatého ");
INSERT INTO cesnkb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","a učte je zachovávat všechno, co jsem vám přikázal. A hle, já jsem s vámi po všechny dny až do skonání světa. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Počátek evangelia Ježíše Krista, Božího Syna. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jak je napsáno v Prorocích: “Hle, já před tvou tváří posílám svého posla, který připraví tvou cestu před tebou.” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Hlas volajícího na poušti: Připravte Pánovu cestu! Napřimujte jeho stezky!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tak přišel Jan, křtil na poušti a kázal křest pokání na odpuštění hříchů. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vycházela k němu celá judská země i všichni Jeruzalémští, a když vyznávali své hříchy, křtil je v řece Jordán. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan byl oblečen velbloudí srstí a koženým pasem kolem boků a jedl kobylky a lesní med. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kázal a říkal: “Po mně přichází ten, který je silnější než já! Já nejsem hoden ani sehnout se a rozvázat řemínek jeho obuvi. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jistě, já jsem vás křtil vodou, ale on vás bude křtít Duchem Svatým.” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","V těch dnech se pak stalo, že přišel Ježíš z galilejského Nazaretu a byl od Jana pokřtěn v Jordánu. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A hned když vystupoval z vody, uviděl protržená nebesa a Ducha sestupujícího na něj jako holubice. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A z nebe zazněl hlas: “Ty jsi ten můj milovaný Syn, v němž jsem nalezl zalíbení.” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A hned ho Duch vypudil na poušť. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Byl na poušti čtyřicet dní a pokoušel ho Satan. Byl tam s divokou zvěří a sloužili mu andělé. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A když byl Jan uvězněn, Ježíš přišel do Galileje a kázal evangelium Božího království. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Říkal: “Čas se naplnil a Boží království se přiblížilo. Čiňte pokání a věřte evangeliu!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A když procházel podél Galilejského moře, uviděl Šimona a Ondřeje, jeho bratra, jak házejí síť do moře (protože to byli rybáři). ");
INSERT INTO cesnkb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ježíš jim řekl: “Pojďte za mnou a udělám z vás rybáře lidí!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","A hned opustili své sítě a šli za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Když pak kousek poodešel, uviděl Jakuba Zebedeova a jeho bratra Jana, jak na lodi spravují sítě. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A hned je povolal. Oni pak nechali svého otce Zebedea na lodi s nádeníky a odešli za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Potom přišli do Kafarnaum a on hned v sobotu vešel do synagogy a učil. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A tam žasli nad jeho učením, protože je učil jako ten, kdo má moc, a ne jako zákoníci. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","V jejich synagoze byl právě člověk v moci nečistého ducha. Vykřikl: ");
INSERT INTO cesnkb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ach, co je ti do nás, Ježíši Nazaretský? Přišel jsi nás zničit? Znám tě, kdo jsi - ten Svatý Boží!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ježíš mu pohrozil a řekl: “Zmlkni a vyjdi z něj!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A ten nečistý duch jím zalomcoval, hlasitě vykřikl a vyšel z něho. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A všichni byli tak ohromeni, že se začali ptát jeden druhého: “Co tohle je? Co je to za nové učení? Vždyť rozkazuje s mocí i těm nečistým duchům a poslouchají ho!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A zpráva o něm se hned roznesla po celém galilejském kraji. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","A hned když vyšli ze synagogy, přišli domů k Šimonovi a Ondřejovi spolu s Jakubem a Janem. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Šimonova tchyně tam ležela v horečce, a tak mu o ní hned pověděli. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Přistoupil tedy, vzal ji za ruku a zvedl ji. Horečka ji hned opustila a ona je začala obsluhovat. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Když potom nastal večer a zapadlo slunce, přinesli k němu všechny nemocné i ty, kteří byli posedlí démony. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Celé město se seběhlo ke dveřím ");
INSERT INTO cesnkb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","a on uzdravil množství lidí trápených různými neduhy a vyhnal množství démonů. A nedovoloval démonům mluvit, protože ho znali. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ráno pak vstal dlouho před rozedněním a vyšel ven. Odešel na opuštěné místo a tam se modlil. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ale Šimon a ti, kdo byli s ním, se za ním pustili. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","A když ho našli, řekli mu: “Všichni tě hledají.” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A on jim řekl: “Pojďme dál, do okolních městeček, abych kázal i tam. Vždyť proto jsem přišel.” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kázal tedy v jejich synagogách po celé Galileji a vymítal démony. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tehdy k němu přišel malomocný. Padl před ním na kolena a prosil ho: “Kdybys jen chtěl, můžeš mě očistit!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ježíš pak naplněn soucitem vztáhl ruku, dotkl se ho a řekl mu: “Chci, buď očištěn!” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A jakmile to Ježíš řekl, hned od něj malomocenství odstoupilo a byl očištěn. ");
INSERT INTO cesnkb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","A hned ho poslal pryč s přísným varováním: ");
INSERT INTO cesnkb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Dej pozor, abys nikomu nic neříkal. Jdi ale, ukaž se knězi a obětuj za své očištění to, co přikázal Mojžíš, na svědectví pro ně.” ");
INSERT INTO cesnkb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ale on vyšel a začal hodně mluvit a rozhlašovat tu věc tak, že Ježíš už nemohl veřejně vejít do města, ale zůstával venku na opuštěných místech. A lidé k němu přicházeli odevšad. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A po několika dnech opět přišel do Kafarnaum a proslechlo se, že je doma. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A hned se shromáždilo takové množství, že se už nemohli vejít ani ke dveřím. A mluvil jim slovo. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tehdy k němu přišli s ochrnutým, kterého nesli čtyři muži. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","A když ho k němu nemohli kvůli zástupu přinést, odkryli střechu nad místem, kde byl, a když ji probořili, spustili dolů lůžko, na kterém ležel ten ochrnutý. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Když Ježíš uviděl jejich víru, řekl tomu ochrnutému: “Synu, tvé hříchy jsou ti odpuštěny.” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Byli tu ale někteří ze zákoníků. Seděli tam a v srdcích uvažovali: ");
INSERT INTO cesnkb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Proč mluví tak rouhavě? Kdo kromě samotného Boha může odpustit hříchy?” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ježíš však ve svém duchu hned poznal, že takto sami pro sebe uvažují, a řekl jim: “Proč ve svých srdcích takto uvažujete? ");
INSERT INTO cesnkb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Co je snadnější? Říci ochrnutému: Tvé hříchy jsou odpuštěny, anebo říci: Vstaň, vezmi své lůžko a choď? ");
INSERT INTO cesnkb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ale abyste věděli, že Syn člověka má na zemi moc odpouštět hříchy” - tehdy pověděl ochrnutému - ");
INSERT INTO cesnkb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“říkám ti, vstaň, vezmi své lůžko a jdi domů.” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A on hned vstal, přede všemi vzal své lůžko a odešel, takže všichni žasli a oslavovali Boha se slovy: “Nic takového jsme nikdy neviděli.” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ježíš pak znovu vyšel k moři. Všechen zástup přicházel k němu a on je vyučoval. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cestou uviděl Léviho, Alfeova syna, jak sedí na celnici, a řekl mu: “Pojď za mnou.” A on vstal a šel za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Když pak byl Ježíš za stolem v jeho domě, stalo se, že i mnozí celníci a hříšníci stolovali s Ježíšem a s jeho učedníky. Bylo jich totiž mnoho, kteří šli za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Když však zákoníci a farizeové uviděli, že jí s celníky a hříšníky, říkali jeho učedníkům: “Jak to, že jí a pije s celníky a hříšníky?” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Když to Ježíš uslyšel, řekl jim: “Lékaře nepotřebují zdraví, ale nemocní. Nepřišel jsem volat spravedlivé, ale hříšné k pokání.” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Janovi učedníci a farizeové se postili. Někteří přišli a řekli mu: “Proč se učedníci Jana a farizeů postí, ale tvoji učedníci se nepostí?” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ježíš jim odpověděl: “Mohou se ženichovi přátelé postit, dokud je ženich s nimi? Dokud mají ženicha u sebe, nemohou se postit. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Přijdou však dny, kdy od nich bude ženich vzat, a tehdy, v těch dnech, se budou postit. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nikdo nepřišívá záplatu z nové látky ke starému plášti; jinak utrhne ta nová záplata i od starého a díra je ještě horší. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nikdo také nelije nové víno do starých nádob; jinak to nové víno roztrhne nádoby, víno se vylije a nádoby se zničí. Nové víno se přece lije do nových nádob.” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Stalo se pak, že v sobotu procházel obilím a jeho učedníci začali cestou vytrhávat klasy. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farizeové mu tedy řekli: “Pohleď, proč dělají, co se v sobotu nesmí?” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Řekl jim: “Copak jste nikdy nečetli, co udělal David, když měl nouzi a hlad, on i ti, kdo byli s ním? ");
INSERT INTO cesnkb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jak vešel do Božího domu za nejvyššího kněze Abiatara a jedl posvátné chleby předložení, které nikdo kromě kněží nesmí jíst, a dal i těm, kdo byli s ním?” ");
INSERT INTO cesnkb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A řekl jim: “Sobota byla učiněna pro člověka, a ne člověk pro sobotu. ");
INSERT INTO cesnkb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Proto je Syn člověka Pánem i nad sobotou.” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pak opět vešel do synagogy a byl tu člověk, který měl uschlou ruku. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A sledovali ho, zda ho uzdraví v sobotu, aby ho mohli obžalovat. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","On řekl tomu člověku, který měl uschlou ruku: “Postav se doprostřed.” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A řekl jim: “Smí se v sobotu konat dobro, nebo zlo? Zachránitživot nebo ho zničit?” Ale oni mlčeli. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A když se po nich s hněvem rozhlédl, zarmoucen nad tvrdostí jejich srdce, řekl tomu člověku: “Natáhni tu ruku.” A on ji natáhl a byla znovu zdravá jako ta druhá. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farizeové pak hned odešli a radili se proti němu s herodiány, jak by ho zahubili. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ježíš však odešel se svými učedníky k moři a šla za ním veliká spousta lidí z Galileje a z Judska ");
INSERT INTO cesnkb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","i z Jeruzaléma a z Idumeje, ze Zajordánska a z okolí Týru a Sidonu. Když slyšeli, jaké věci dělal, přišla jich k němu veliká spousta. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Proto řekl svým učedníkům, aby pro něj měli stále připravenou loďku kvůli zástupu, aby ho neumačkali. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Uzdravil jich totiž tolik, že všichni, kdo měli nějaká trápení, se na něj vrhali, aby se ho dotkli. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A nečistí duchové, jakmile ho uviděli, padali před ním a křičeli: “Ty jsi ten Boží Syn!” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ale on jim velmi hrozil, aby ho neuváděli ve známost. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Potom vystoupil na horu, povolal k sobě ty, které sám chtěl, a ti přišli k němu. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ustanovil jich dvanáct, aby byli s ním a aby je poslal kázat ");
INSERT INTO cesnkb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","a aby měli moc uzdravovat nemoci a vymítat démony: ");
INSERT INTO cesnkb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Šimona (kterému dal jméno Petr), ");
INSERT INTO cesnkb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakuba Zebedeova a Jakubova bratra Jana (kterým dal jméno Boanerges, to jest “Synové hromu”) ");
INSERT INTO cesnkb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","a Ondřeje, Filipa, Bartoloměje, Matouše, Tomáše, Jakuba Alfeova, Tadeáše, Šimona Kananitu ");
INSERT INTO cesnkb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","a Jidáše Iškariotského, který ho také zradil. A šli s ním do domu. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A znovu se sešel takový zástup, že se nemohli ani najíst chleba. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A když se to dozvěděli jeho příbuzní, vyšli, aby si ho vzali, protože lidé říkali, že se pominul. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Zákoníci, kteří přišli z Jeruzaléma, pak říkali, že má Belzebula a že vymítá démony skrze knížete démonů. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","A tak je zavolal a mluvil k nim v podobenstvích: “Jak může Satan vymítat Satana? ");
INSERT INTO cesnkb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pokud se království rozdělí samo proti sobě, nemůže to království obstát. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Také když se dům rozdělí sám proti sobě, nemůže ten dům obstát. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jestliže tedy Satan povstal sám proti sobě a je rozdělen, nemůže obstát, ale je s ním konec. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nikdo však nemůže přijít do domu siláka a uloupit jeho majetek, pokud toho siláka nejdříve nespoutá. Teprve tehdy vyloupí jeho dům.” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Amen, říkám vám, že všechny hříchy budou lidským synům odpuštěny, i rouhání, jakkoli by se rouhali. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ale kdokoli by se rouhal proti Duchu Svatému, tomu nebude odpuštěno na věky, ale propadl věčnému odsouzení.” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Říkali totiž o něm: “Má nečistého ducha.” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tehdy přišli jeho bratři a matka. Zůstali venku a vzkázali mu, že ho volají. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A kolem něj seděl zástup lidí. Řekli mu: “Podívej se, tvá matka a tvoji bratři jsou venku a hledají tě.” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","On jim však odpověděl: “Kdo je má matka a moji bratři?” ");
INSERT INTO cesnkb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Rozhlédl se po těch, kdo seděli okolo něj, a řekl: “Pohleďte, to je má matka a moji bratři. ");
INSERT INTO cesnkb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kdokoli totiž koná Boží vůli, ten je můj bratr a sestra a matka.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tehdy začal znovu vyučovat u moře. Shromáždil se k němu tak obrovský zástup, že nastoupil do lodi na moři a posadil se; a celý ten zástup byl na zemi u moře. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Učil je v podobenstvích mnoha věcem a ve svém vyučování jim řekl: ");
INSERT INTO cesnkb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Slyšte: Hle, vyšel rozsévač, aby rozsíval. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A při tom rozsívání se stalo, že některé semeno padlo podél cesty a přiletěli nebeští ptáci a sezobali je. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jiné padlo na skalnaté místo, kde nemělo mnoho země, a ihned vzešlo, protože nemělo hloubku země. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Když pak vyšlo slunce, spálilo je; a protože nemělo kořen, uschlo. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jiné zase padlo do trní, a když trní vyrostlo, udusilo je a nevydalo úrodu. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jiné však padlo do dobré země a vydalo vzhůru vystupující a rostoucí úrodu. Některé přineslo třicetinásobek, jiné šedesátinásobek a jiné stonásobek.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tehdy jim řekl: “Kdo má uši k slyšení, ať slyší.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A jakmile byl o samotě, ptali se ho ti, kdo byli s ním spolu s dvanácti, na to podobenství. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Řekl jim tedy: “Vám je dáno poznat tajemství Božího království, ale těm, kdo jsou mimo něj, se to všechno děje v podobenstvích, ");
INSERT INTO cesnkb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","aby ‘Hledíce hleděli, ale neviděli a slyšíce slyšeli, ale nerozuměli, aby se snad neobrátili a nebyly jim odpuštěny hříchy.’” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tehdy jim řekl: “Vy to podobenství nechápete? Jak tedy porozumíte všem podobenstvím? ");
INSERT INTO cesnkb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ten rozsévač rozsívá slovo. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A ti podél cesty, kde se rozsívá slovo, jsou tito: Jakmile uslyší, ihned přichází Satan a bere to slovo, které bylo zaseto do jejich srdcí. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","A podobně ti, kteří jsou osíváni na skalnaté půdě, jsou tito: Jakmile to slovo uslyší, hned ho s radostí přijímají, ");
INSERT INTO cesnkb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ale nemají v sobě kořen a jsou nestálí. Když potom kvůli tomu slovu nastane soužení nebo pronásledování, hned se pohoršují. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A další jsou ti, kteří jsou osíváni do trní: To jsou ti, kteří slyší slovo, ");
INSERT INTO cesnkb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ale pak přicházejí starosti tohoto světa, oklamání bohatstvím a chtivost po dalších věcech a dusí to slovo, takže se stává neplodným. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A toto jsou ti, kteří jsou oseti na dobré půdě: Slyší slovo, přijímají je a přinášejí úrodu - jedno třicetinásobnou, jiné šedesátinásobnou a jiné stonásobnou.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dále jim řekl: “Přichází snad světlo proto, aby bylo postaveno pod nádobu nebo pod postel? Nemá být postaveno na stojan? ");
INSERT INTO cesnkb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Není totiž nic skrytého, co by nemělo být zjeveno, ani nic tak utajeného, aby to nevyšlo najevo. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Má-li někdo uši k slyšení, ať slyší!” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Řekl jim také: “Dávejte pozor na to, co posloucháte. Jakou mírou měříte, takovou vám bude odměřeno a vám poslouchajícím bude přidáno. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tomu, kdo má, totiž bude dáno, a tomu, kdo nemá, bude vzato i to, co má.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Potom řekl: “Boží království působí tak, jako když člověk hodí zrno na zem ");
INSERT INTO cesnkb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","a spí a vstává ve dne i v noci a to zrno klíčí a roste, a on neví jak. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Země totiž plodí úrodu sama - nejdříve stéblo, potom klas a potom zralé obilí v klasu. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A když úroda dozraje, ihned přiloží srp, protože nastala sklizeň.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Řekl také: “K čemu přirovnáme Boží království? Jakým podobenstvím ho představíme? ");
INSERT INTO cesnkb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Je jako zrnko hořčice, které když je zaseto do země, je nejmenší ze všech semen na zemi. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Když je však zaseto, roste, až je větší než všechny byliny a vypouští veliké větve, takže i nebeští ptáci mohou hnízdit v jeho stínu.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A mluvil jim slovo v mnoha takových podobenstvích, tak jak byli schopni rozumět. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nemluvil k nim jinak než v podobenstvích, ale svým učedníkům všechno v soukromí vysvětloval. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Toho dne, když už nastal večer, jim řekl: “Přeplavme se na druhou stranu.” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nechali tedy zástup na břehu a vzali ho, jak byl, na loďce. A byly s ním i jiné loďky. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tehdy nastala veliká větrná bouře a vlny se valily na loď, takže se loď již naplňovala. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","On ale spal na polštáři na lodní zádi, a tak ho vzbudili a řekli mu: “Mistře, ty nedbáš na to, že hyneme?” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Když se tedy probudil, napomenul vítr a řekl moři: “Zmlkni, utiš se!” A vítr se utišil a nastal naprostý klid. ");
INSERT INTO cesnkb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tehdy jim řekl: “Proč se tak bojíte? Jakto, že nemáte víru?” ");
INSERT INTO cesnkb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A oni dostali veliký strach a říkali jeden druhému: “Kdo to tedy je, že ho poslouchá i vítr a moře?” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tehdy se přeplavili přes moře do kraje Gadarenců. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A jakmile vystoupil z lodi, ihned se s ním setkal člověk z hrobů v moci nečistého ducha. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ten bydlel v hrobech a nikdo ho už nemohl ani svázat řetězem. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Býval totiž často spoután okovy a řetězy, ale on ty řetězy vždy roztrhal a okovy rozlámal a nikdo ho nemohl zkrotit. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vždycky, ve dne i v noci, byl na horách a v hrobkách, křičel a tloukl se kamením. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Když pak z dálky uviděl Ježíše, přiběhl a poklonil se mu ");
INSERT INTO cesnkb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","a hlasitě vykřikl: “Co je ti do mě, Ježíši, Synu Nejvyššího Boha? Pro Boha tě zapřísahám, abys mě netrýznil!” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ježíš mu totiž řekl: “Vyjdi z toho člověka, ty nečistý duchu!” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A tázal se ho: “Jak se jmenuješ?” On mu řekl: “Mé jméno je Legie, protože je nás mnoho,” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","a velice ho prosil, aby je nevyháněl z toho kraje. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","U hory se tam právě páslo veliké stádo vepřů ");
INSERT INTO cesnkb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","a všichni ti démoni ho prosili: “Pusť nás do těch vepřů, ať vejdeme do nich!” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ježíš jim to hned povolil a ti nečistí duchové vyšli a vstoupili do těch vepřů. Stádo se pak rozběhlo ze srázu dolů do moře (bylo jich asi dva tisíce) a v moři se utopilo. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ti, kdo ty vepře pásli, pak utekli a rozhlásili to ve městě i na venkově. Lidé tedy vyšli, aby viděli, co se to stalo. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Přišli k Ježíši a viděli toho, který býval posedlý a měl Legii, jak tam sedí oblečen a při zdravém rozumu, a dostali strach. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ti, kteří to viděli, jim pak vylíčili, jak to bylo s tím posedlým a s těmi vepři, ");
INSERT INTO cesnkb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","a oni ho začali prosit, aby odešel z jejich kraje. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Když pak nastupoval na loď, žádal ho ten, který býval posedlý démony, aby s ním mohl zůstat. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ježíš mu to ale nedovolil a řekl mu: “Jdi domů ke svým a oznam jim, jak veliké věci pro tebe udělal Pán a jak se nad tebou slitoval.” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","On tedy odešel a začal v Dekapoli kázat, co všechno pro něj Ježíš udělal. A všichni se divili. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Když se pak Ježíš zase přeplavil lodí na druhou stranu, sešel se k němu veliký zástup lidí. A byl u moře. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Vtom k němu přišel jeden z představených synagogy, jménem Jairus, a když ho uviděl, padl k jeho nohám ");
INSERT INTO cesnkb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a velmi ho prosil: “Moje dcerka umírá. Pojď, vlož na ni ruce, aby byla uzdravena, a bude žít.” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A tak s ním odešel a veliký zástup šel za ním a tlačili se na něj. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A byla tam jedna žena, která měla krvácení už dvanáct let. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mnoho vytrpěla od mnoha lékařů, utratila všechno, co měla, ale nic jí neprospělo a bylo jí ještě hůř. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Když však uslyšela o Ježíši, přišla k němu davem zezadu a dotkla se jeho roucha. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Řekla totiž: “Jestli se dotknu aspoň jeho roucha, budu uzdravena.” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A její krvácení ihned přestalo a poznala na těle, že byla z toho trápení uzdravena. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A Ježíš v sobě ihned poznal, že z něho vyšla moc. Otočil se v davu a řekl: “Kdo se dotkl mého roucha?” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jeho učedníci mu řekli: “Vidíš, že se na tebe tlačí dav, a říkáš: ‘Kdo se mě dotkl?’” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ale on se rozhlížel, aby uviděl tu, která to udělala. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A když ta žena poznala, co se s ní stalo, přišla s bázní a rozechvěním, padla před ním na zem a řekla mu celou pravdu. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","On jí však řekl: “Dcero, tvá víra tě uzdravila. Jdi v pokoji a buď uzdravena ze svého trápení.” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A když ještě mluvil, přišli lidé z domu představeného synagogy se slovy: “Tvá dcera umřela. Proč ještě obtěžuješ mistra?” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jakmile však Ježíš uslyšel, co říkali, řekl představenému synagogy: “Neboj se, jenom věř.” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A nikomu nedovolil, aby ho doprovázel, kromě Petra a Jakuba a Jana, Jakubova bratra. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Když pak přišel k domu představeného synagogy a uviděl veliké pozdvižení a plačící a hlasitě naříkající, ");
INSERT INTO cesnkb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","vstoupil dovnitř a řekl jim: “Proč děláte pozdvižení a pláčete? To dítě neumřelo, ale spí.” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A tak se mu vysmívali, ale on všechny vyhnal, vzal otce a matku dítěte i ty, kteří byli s ním, a vešel do místnosti, kde leželo dítě. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Vzal dívku za ruku a řekl jí: “Talita kumi,” což se překládá: “Děvčátko, říkám ti, vstaň.” ");
INSERT INTO cesnkb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A ta dívka hned vstala a začala se procházet; bylo jí totiž dvanáct let. A zmocnil se jich veliký úžas. ");
INSERT INTO cesnkb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","On jim však jasně přikázal, aby se o tom nikdo nedozvěděl. A řekl jim, ať jí dají najíst. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Potom odtud odešel a přišel do svého domovského města a jeho učedníci šli s ním. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Když nastala sobota, začal učit v synagoze; a mnozí, kteří ho slyšeli, žasli a říkali: “Odkud to má? A co to dostal za moudrost? A jak to, že se skrze jeho ruce dějí takové zázraky? ");
INSERT INTO cesnkb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Není to snad ten tesař, syn Marie a bratr Jakuba, Jozese, Judy a Šimona? A nejsou snad jeho sestry tady s námi?” A tak se nad ním pohoršovali. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ježíš jim tedy řekl: “Prorok není beze cti; jedině ve své vlasti, mezi svými příbuznými a ve svém domě.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A nemohl tam udělat žádný zázrak, jen na několik nemocných vložil ruce a uzdravil je. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Podivil se tedy nad jejich nevěrou a začal obcházet okolní městečka a učit. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Potom k sobě svolal dvanáct učedníků a začal je vysílat po dvou. Dal jim moc nad nečistými duchy ");
INSERT INTO cesnkb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","a přikázal jim, aby si na cestu nebrali nic kromě hole: ani mošnu, ani chléb, ani peníze do opasku, ");
INSERT INTO cesnkb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ale aby měli obuté sandále a neoblékali si dvě košile. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Řekl jim také: “Kamkoli vejdete do domu, tam zůstaňte, dokud odtamtud nevyjdete. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A kdekoli by vás nepřijali a neposlouchali by vás, vyjděte odtamtud a vyklepte prach ze svých nohou na svědectví proti nim. Amen, říkám vám, že Sodomě a Gomoře bude v soudný den lehčeji než tomu městu.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A tak vyšli a kázali, aby lidé činili pokání. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Vymítali mnoho démonů a mnoho nemocných mazali olejem a uzdravovali. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tehdy o něm uslyšel i král Herodes (protože jeho jméno se stalo známým) a řekl: “Jan Křtitel vstal z mrtvých, a proto se skrze něj dějí zázraky!” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jiní však říkali: “Je to Eliáš” a jiní říkali: “Je to prorok jako jeden z těch dávných proroků.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Když to však uslyšel Herodes, řekl: “To je ten Jan, kterého jsem sťal. Byl vzkříšen z mrtvých!” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes totiž sám poslal, zatkl Jana a spoutal ho ve vězení kvůli Herodiadě, manželce svého bratra Filipa, protože se s ní oženil. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jan totiž Herodovi říkal: “Není ti dovoleno mít manželku svého bratra!” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias to tedy měla proti němu a chtěla ho zabít, ale nemohla. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes se totiž Jana bál, neboť věděl, že je to spravedlivý a svatý člověk, a tak ho chránil. Když ho slyšel, mnoho věcí i dělal a poslouchal ho rád. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Příhodný den však přišel, když Herodes na oslavu svých narozenin uspořádal hostinu pro své velmože a velitele a pro přední muže Galileje. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Když přišla dcera té Herodiady a zatančila, zalíbila se Herodovi i jeho spoluhodovníkům a král té dívce řekl: “Pros mne, o cokoli chceš, a dám ti to.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A přísahal jí: “O cokoli bys mne poprosila, to ti dám, až do polovice svého království.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Odešla tedy a řekla své matce: “O co mám poprosit?” A ona řekla: “O hlavu Jana Křtitele.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hned tedy se spěchem přišla ke králi a prosila ho: “Chci, abys mi ihned dal na míse hlavu Jana Křtitele.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A král se velmi zarmoutil, ale kvůli svým přísahám a spoluhodovníkům ji nechtěl odmítnout. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A tak ten král hned poslal kata a přikázal, aby přinesl Janovu hlavu. A ten odešel, sťal ho ve vězení ");
INSERT INTO cesnkb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a přinesl jeho hlavu na míse. Dal ji té dívce a ta dívka ji dala své matce. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Když to potom uslyšeli jeho učedníci, přišli, vzali jeho tělo a pochovali je do hrobu. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Potom se apoštolové sešli k Ježíši a oznámili mu všechno, co dělali i co učili. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tehdy jim řekl: “Pojďte jen vy sami stranou na opuštěné místo a trochu si odpočiňte.” Těch, kdo k nim přicházeli a zase odcházeli, bylo totiž tolik, že neměli ani chvilku na jídlo. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Odpluli tedy o samotě lodí na pusté místo. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ale když odcházeli, mnozí je uviděli a poznali. Seběhli se tam ze všech měst pěšky, předešli je a sešli se k němu. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Když pak Ježíš vystoupil, uviděl veliký zástup lidí a byl naplněn soucitem k nim, protože byli jako ovce, které nemají pastýře. Tehdy je začal učit mnoha věcem. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A když už se připozdilo, přišli k němu jeho učedníci a řekli: “Tohle místo je pusté a už je moc hodin. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Propusť je, ať odejdou do okolních statků a vesnic a nakoupí si chléb, protože nemají co jíst.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","On jim ale odpověděl: “Vy jim dejte najíst.” Řekli mu: “Máme jít a nakoupit chléb za dvě stě denárů a dát jim najíst?” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","On jim řekl: “Kolik máte chlebů? Jděte a podívejte se.” Když to zjistili, řekli: “Pět, a dvě ryby.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tehdy jim přikázal, aby všechny posadili po skupinách na zelené trávě. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rozložili se tedy v řadách po stu a po padesáti lidech. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Potom vzal těch pět chlebů a ty dvě ryby, vzhlédl k nebi, požehnal a nalámal ty chleby a dával svým učedníkům, aby jim je předkládali. A ty dvě ryby rozdělil všem. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","A tak se všichni najedli a byli nasyceni. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Potom sebrali dvanáct košů plných kousků chleba a ryb. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A těch, kteří ty chleby jedli, bylo kolem pěti tisíc mužů. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Potom hned své učedníky přinutil, aby nastoupili na loď a jeli napřed na druhou stranu k Betsaidě, než on rozpustí zástup. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A když se s nimi rozloučil, odešel na horu, aby se modlil. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Když pak nastal večer, byla loď uprostřed moře a on sám na zemi. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A uviděl je, jak se úmorně plaví, protože jeli proti větru. Při čtvrté noční hlídce pak k nim přicházel pěšky po moři a chtěl je minout, ");
INSERT INTO cesnkb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ale oni, když ho uviděli, jak kráčí po moři, mysleli, že je to přízrak, a vykřikli strachy. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Všichni ho totiž uviděli a vyděsili se. Ale on s nimi hned promluvil a řekl jim: “Vzmužte se, to jsem já! Nebojte se.” ");
INSERT INTO cesnkb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A nastoupil k nim do lodi a vítr se utišil. A oni ještě daleko víc sami v sobě žasli a divili se. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nepochopili totiž nic ohledně těch chlebů, protože jejich srdce bylo ztvrdlé. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A když se přeplavili, přijeli do genezaretské země a přistáli. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","A jakmile vystoupili z lodi, lidé ho hned poznali ");
INSERT INTO cesnkb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","a oběhli celý ten kraj a začali na nosítkách přinášet nemocné tam, kde slyšeli, že je. ");
INSERT INTO cesnkb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","A kamkoli přišel, do vesnic, do měst nebo na venkov, lidé pokládali nemocné na tržištích a prosili ho, aby se mohli dotknout aspoň cípu jeho roucha. A kdokoli se ho dotkl, byl uzdraven. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Potom se k němu sešli farizeové a někteří ze zákoníků, kteří přišli z Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","A když uviděli některé jeho učedníky jíst chleby nečistýma (to jest neumytýma) rukama, rozzlobili se. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farizeové a všichni Židé totiž nejedí, aniž by si obřadně umyli ruce, a tak dodržují tradici starších. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Když přijdou z trhu, nejedí, dokud se neočistí. A je ještě mnoho jiných věcí, které přijali a dodržují, jako očišťování pohárů, džbánů, měděných nádob a lehátek. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farizeové a zákoníci se ho potom zeptali: “Proč tvoji učedníci nežijí podle tradice starších a jedí chléb nečistýma rukama?” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ale on jim odpověděl: “Izaiáš o vás pokrytcích prorokoval dobře, jak je napsáno: ‘Tento lid mne ctí svými rty, avšak jejich srdce je ode mne daleko. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nadarmo mne ale uctívají, když učí učení a přikázání lidí.’ ");
INSERT INTO cesnkb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Opustili jste totiž Boží přikázání a dodržujete lidskou tradici, očišťování džbánů a pohárů. A takových podobných věcí děláte mnoho.” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A řekl jim: “Zavrhujete Boží přikázání čistě, abyste zachovali svou tradici. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Vždyť Mojžíš řekl: ‘Cti svého otce a svou matku’ a ‘Kdokoli by zlořečil otci nebo matce, ať propadne smrti.’ ");
INSERT INTO cesnkb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Vy ale říkáte, že kdyby člověk řekl svému otci nebo matce: ‘To, čím bych ti měl vypomoci, je korban’ (to jest dar Bohu), ");
INSERT INTO cesnkb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tak už ho nenecháte nic udělat pro jeho otce nebo matku. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Rušíte Boží slovo svou tradicí, kterou jste ustanovili. A takových podobných věcí děláte mnoho.” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Potom svolal všechen zástup a řekl jim: “Slyšte mne všichni a rozumějte. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nic, co zvenčí vchází do člověka, ho nemůže pošpinit. Člověka ale špiní to, co vychází z něj! ");
INSERT INTO cesnkb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Má-li kdo uši k slyšení, ať slyší.” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Když pak odešel od zástupu do domu, jeho učedníci se ho vyptávali na to podobenství. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A on jim řekl: “Vy jste také tak nechápaví? Copak nerozumíte, že cokoli vchází do člověka zvenčí, ho nemůže pošpinit, ");
INSERT INTO cesnkb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","protože to nevchází do jeho srdce, ale do břicha a vychází to do stoky?” Tak očistil všechny pokrmy. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Potom řekl: “Co z člověka vychází, to člověka špiní. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Z nitra lidského srdce totiž vycházejí zlé myšlenky, cizoložství, smilnění, vraždy, ");
INSERT INTO cesnkb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","krádeže, lakomství, ničemnost, lest, nestydatost, závistivé oko, urážky, pýcha, bláznivost. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Všechny tyto zlé věci vycházejí z nitra a pošpiňují člověka.” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Potom vstal a odešel odtud do končin Týru a Sidonu. Vešel do domu a nechtěl, aby se to někdo dozvěděl, ale nemohl se utajit. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Doslechla se o něm totiž žena, jejíž dcerka měla nečistého ducha. Přišla a padla mu k nohám ");
INSERT INTO cesnkb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","(ta žena byla Řekyně, rodem Syrofeničanka) a prosila ho, aby z její dcery vyhnal démona. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ale Ježíš jí řekl: “Nech nejprve nasytit děti, protože není správné vzít chléb dětem a hodit ho štěňatům.” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ona mu však odpověděla: “Ano, Pane, ale ta štěňata jedí pod stolem z drobtů od dětí.” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Řekl jí tedy: “Protože jsi řekla tato slova, jdi domů. Ten démon z tvé dcery vyšel.” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A když přišla domů, zjistila, že dívka leží na lůžku a že démon odešel. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tehdy Ježíš znovu vyšel z kraje Tyrských a Sidonských a prostředkem území Dekapole přišel ke Galilejskému moři. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tehdy k němu přivedli hluchoněmého a prosili ho, aby na něj vložil ruku. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","On si ho vzal stranou od zástupu, vložil mu prsty do uší, plivl a dotkl se jeho jazyka. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Potom vzhlédl k nebi, vzdychl a řekl mu: “Efata!” což znamená: “Otevři se!” ");
INSERT INTO cesnkb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A jeho uši se ihned otevřely a pouto jeho jazyka se rozvázalo a začal mluvit správně. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ježíš jim přikázal, aby to nikomu neříkali, ale čím více jim přikazoval, tím více to rozhlašovali. ");
INSERT INTO cesnkb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A lidé byli nesmírně ohromeni. Říkali: “Všechno udělal dobře! Dokonce i hluchým dává sluch a němým řeč!” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","V těch dnech tam bylo velmi veliké množství lidí, a když už neměli nic k jídlu, Ježíš svolal své učedníky a řekl jim: ");
INSERT INTO cesnkb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Je mi líto toho zástupu. Vždyť zůstávají se mnou už tři dny a nemají co jíst. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pokud je propustím hladové, cestou se vyčerpají; a někteří z nich přišli zdaleka.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jeho učedníci mu odpověděli: “Jak bude někdo moci zde na poušti nasytit tyto lidi chlebem?” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zeptal se jich tedy: “Kolik máte chlebů?” A oni řekli: “Sedm.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Přikázal tedy zástupu, aby se posadili na zem. Potom vzal těch sedm chlebů, vzdal díky, nalámal a dával svým učedníkům, aby je předkládali, a oni je předložili zástupu. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Měli také trochu rybiček. Ježíš je požehnal a řekl, ať předkládají i je. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A tak se najedli a byli nasyceni a nasbírali sedm košů nalámaných kousků, které zbyly. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Těch, kteří jedli, pak bylo okolo čtyř tisíc. Ježíš je potom propustil, ");
INSERT INTO cesnkb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ihned nastoupil se svými učedníky na loď a přijel do dalmanutského kraje. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tehdy přišli farizeové a začali se s ním hádat a pokoušet ho tím, že od něho chtěli znamení z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ježíš si v duchu hluboce povzdychl a řekl: “Proč toto pokolení vyhledává znamení? Amen, říkám vám, že tomuto pokolení žádné znamení dáno nebude!” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A když je opustil, nastoupil zase do lodi a odplul na druhou stranu. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Zapomněli však vzít chléb a neměli s sebou na lodi víc než jeden bochník. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tehdy jim přikazoval: “Dávejte pozor a varujte se kvasu farizeů a kvasu Heroda.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dohadovali se tedy mezi sebou a říkali: “Nemáme žádný chléb.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ježíš to ale věděl a řekl jim: “Proč se dohadujete, že nemáte chléb? Ještě nechápete a nerozumíte? Ještě máte ztvrdlé srdce? ");
INSERT INTO cesnkb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Máte oči, a nevidíte? Máte uši, a neslyšíte? Už si nevzpomínáte? ");
INSERT INTO cesnkb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Když jsem nalámal pět chlebů mezi pět tisíc mužů, kolik plných košů nalámaných kousků jste nasbírali?” Řekli mu: “Dvanáct.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“A co těch sedm chlebů mezi čtyři tisíce? Kolik plných košů nalámaných kousků jste sebrali?” A oni řekli: “Sedm.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Řekl jim: “Jak to, že ještě nerozumíte?” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Potom přišli do Betsaidy a tam k němu přivedli slepce a prosili ho, aby se ho dotkl. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chytil tedy toho slepce za ruku a vyvedl ho ven za vesnici. Plivl mu na oči, vložil na něj ruce a ptal se ho: “Vidíš něco?” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A on vzhlédl a řekl: “Rozeznávám lidi, neboť vidím něco jako chodící stromy.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Potom mu znovu vložil ruce na oči a nechal ho vzhlédnout. Tehdy byl uzdraven, takže viděl všechno jasně i na dálku. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Poslal ho tedy domů se slovy: “Nechoď do té vesnice ani to nikomu z té vesnice neříkej.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tehdy Ježíš a jeho učedníci vyšli do vesnic kolem Cesareje Filipovy. Po cestě se svých učedníků ptal: “Za koho mne mají lidé?” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Oni odpověděli: “Někteří za Jana Křtitele, jiní za Eliáše a jiní za jednoho z proroků.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tehdy se jich zeptal: “A za koho mne máte vy?” Petr odpověděl a řekl mu: “Ty jsi Kristus!” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A on je přísně napomenul, aby to o něm nikomu neříkali. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tehdy je začal učit, že Syn člověka musí mnoho vytrpět a být zavržen staršími, velekněžím i zákoníky, být zabit a po třech dnech vstát z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ta slova mluvil otevřeně, a proto ho Petr vzal stranou a začal ho kárat. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ježíš se ale obrátil, podíval se na své učedníky a pokáral Petra slovy: “Jdi za mnou, Satane! Nemyslíš na Boží věci, ale na lidské.” ");
INSERT INTO cesnkb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Potom svolal zástup se svými učedníky a řekl jim: “Chce-li někdo jít za mnou, ať se zřekne sám sebe, vezme svůj kříž a následuje mne. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kdokoli by si totiž chtěl zachránit duši, ztratí ji, ale kdokoli ztratí svou duši pro mne a pro evangelium, ten ji zachrání. ");
INSERT INTO cesnkb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vždyť co prospěje člověku, kdyby získal celý svět, ale uškodil své duši? ");
INSERT INTO cesnkb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A co dá člověk na oplátku za svou duši? ");
INSERT INTO cesnkb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kdo by se totiž v tomto cizoložném a hříšném pokolení styděl za mne a za má slova, za toho se bude stydět i Syn člověka, až přijde ve slávě svého Otce se svatými anděly.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A řekl jim: “Amen, říkám vám, že někteří z těch, kdo tu stojí, rozhodně nezakusí smrt, dokud nespatří, jak Boží království přišlo v moci.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Po šesti dnech pak Ježíš vzal k sobě Petra, Jakuba a Jana, vyvedl je samotné stranou na vysokou horu a proměnil se před nimi. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jeho šaty se rozzářily a úplně zbělely jako sníh, tak jak by je žádný bělič na zemi nemohl vybílit. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A uviděli Eliáše a Mojžíše, jak mluví s Ježíšem. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petr pak Ježíši odpověděl: “Rabbi, to je dobře, že jsme zde. Udělejme tedy tři stánky - jeden tobě, jeden Mojžíšovi a jeden Eliášovi.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nevěděl totiž, co by řekl, protože byli velmi vyděšení. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tehdy se objevil oblak a zastínil je a z toho oblaku zazněl hlas, který řekl: “Toto je můj milovaný Syn. Toho poslouchejte.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A náhle, když se rozhlédli, neviděli už nikoho jiného než samotného Ježíše s nimi. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Když pak sestupovali z hory, přikázal jim, aby nikomu nevyprávěli, co viděli, dokud Syn člověka nevstane z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nechali si tedy tu věc pro sebe a dohadovali se, co to je ‘vstát z mrtvých’. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Potom se ho ptali: “Proč zákoníci říkají, že nejdříve musí přijít Eliáš?” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ale on jim odpověděl: “Jistě, nejdříve přijde Eliáš a všechno napraví. A co je napsáno o Synu člověka? Že musí mnoho vytrpět a být pohrdán. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ale říkám vám, že Eliáš také přišel a oni mu udělali, co chtěli, tak jak je to o něm napsáno.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Když potom přišel k učedníkům, uviděl, že je kolem nich veliký zástup a že se s nimi hádají zákoníci. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A jakmile ho všichni v zástupu spatřili, byli velmi překvapeni a běželi k němu a zdravili ho. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zeptal se tedy zákoníků: “Proč se s nimi hádáte?” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A jeden ze zástupu mu odpověděl: “Mistře, přivedl jsem k tobě svého syna, který má němého ducha. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kdekoli se ho zmocní, trhá jím a on pění a skřípe zuby a vyčerpá se. Řekl jsem tedy tvým učedníkům, aby ho vyhnali, ale nemohli!” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","On mu ale odpověděl: “nevěřící pokolení, jak dlouho budu s vámi? Jak dlouho vás budu snášet? Přiveďte ho ke mně.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Přivedli ho tedy k němu, a jakmile ho uviděl, hned jím ten duch začal tak zmítat, že upadl, válel se po zemi a pěnil. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ježíš se pak zeptal jeho otce: “Jak je to dlouho, co se mu tohle stává?” A on řekl: “Od dětství. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A často s ním házel i do ohně a do vody, aby ho zahubil. Ale můžeš-li něco udělat, slituj se nad námi a pomoz nám!” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ježíš mu však řekl: “Můžeš-li tomu věřit. Pro věřícího je možné všechno.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A otec toho chlapce ihned se slzami vykřikl: “Pane, já věřím! Pomoz mé nevěře!” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Když ale Ježíš uviděl, že se sbíhá zástup, pohrozil tomu nečistému duchu a řekl mu: “Ty němý a hluchý duchu, já ti přikazuji: vyjdi z něho a víckrát do něj nevcházej!” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A tak s křikem a velikým zmítáním vyšel. A chlapec byl jako mrtvý, takže mnozí říkali, že zemřel. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ježíš ho ale vzal za ruku, zvedl ho a on vstal. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A když vešel do domu, učedníci se ho v soukromí ptali: “Proč jsme ho my nemohli vyhnat?” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Řekl jim tedy: “Tento druh démonů nemůže nijak vyjít, jedině skrze modlitbu a půst.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Když pak odtamtud odešli, procházeli Galilejí, ale on nechtěl, aby o tom někdo věděl. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Učil totiž své učedníky a říkal jim: “Syn člověka bude vydán do lidských rukou a zabijí ho. A až bude zabit, třetího dne vstane z mrtvých.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Oni však to slovo nechápali a báli se ho zeptat. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Potom přišel do Kafarnaum, a když byl v domě, ptal se jich: “O čem jste to po cestě mezi sebou rozmlouvali?” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ale oni mlčeli, protože se po cestě mezi sebou dohadovali, kdo z nich je větší. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Posadil se tedy, zavolal těch dvanáct a řekl jim: “Jestli někdo chce být první, bude posledníze všech a služebník všech.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tehdy vzal dítě a postavil je uprostřed nich. Potom je vzal do náručí a řekl jim: ");
INSERT INTO cesnkb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kdokoli by přijal jedno z takových dětí v mém jménu, přijímá mne, a kdokoli by přijal mne, nepřijímá mne, ale Toho, který mě poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jan mu tedy odpověděl: “Mistře, viděli jsme někoho, kdo nechodí s námi, jak ve tvém jménu vymítá démony a bránili jsme mu, protože nechodí s námi.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ale Ježíš řekl: “Nebraňte mu. Vždyť není nikdo, kdo by udělal zázrak v mém jménu a mohl o mně snadno mluvit zle. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vždyť kdo není proti nám, je s námi. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kdokoli by vám totiž dal k pití pohár vody v mém jménu, protože jste Kristovi, říkám vám jistě, že rozhodně neztratí svou odplatu.” ");
INSERT INTO cesnkb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kdokoli by ale svedl jednoho z těchto maličkých, kteří věří ve mne, bylo by pro něj mnohem lepší, kdyby mu na krk pověsili mlýnský kámen a hodili ho do moře. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kdyby tě sváděla tvá ruka, usekni ji. Je pro tebe lepší vejít zmrzačený do života, než mít obě ruce a jít do pekla, do toho neuhasitelného ohně, ");
INSERT INTO cesnkb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kde ‘jejich červ neumírá a oheň nehasne’. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A kdyby tě sváděla tvá noha, usekni ji. Je pro tebe lepší vejít chromý do života, než mít obě nohy a být uvržen do pekla, do toho neuhasitelného ohně, ");
INSERT INTO cesnkb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kde ‘jejich červ neumírá a oheň nehasne’. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A kdyby tě svádělo tvé oko, zahoď je. Je pro tebe lepší vejít jednooký do Božího království, než mít obě oči a být uvržen do pekelného ohně, ");
INSERT INTO cesnkb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kde ‘jejich červ neumírá a oheň nehasne’. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Neboť každý bude solen ohněm a každá oběť bude solena solí. ");
INSERT INTO cesnkb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sůl je dobrá. Když ale sůl přestane být slaná, čím ji osolíte? Mějte v sobě sůl a žijte spolu v pokoji.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Potom vstal, odešel odtud a krajinou za Jordánem přišel do judského kraje. Tam se k němu znovu sešly zástupy a on je podle svého zvyku opět učil. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tehdy k němu přišli farizeové a pokoušeli ho otázkou: “Smí muž propustit manželku?” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","On jim však odpověděl: “Co vám přikázal Mojžíš?” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Oni řekli: “Mojžíš nám dovolil napsat potvrzení o rozvodu a tak ji propustit.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ježíš jim tedy odpověděl: “To přikázání vám napsal kvůli tvrdosti vašeho srdce. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ale od počátku stvoření je Bůh ‘učinil muže a ženu’. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Proto člověk opustí svého otce i matku a přilne ke své manželce. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","A ti dva budou jedno tělo,’ takže už nejsou dva, ale jedno tělo. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Co tedy Bůh spojil, ať člověk nerozděluje.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Když potom byli v domě, učedníci se ho na tu věc vyptávali znovu. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Řekl jim tedy: “Kdokoli by propustil svou manželku a vzal si jinou, cizoloží proti ní. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A jestliže by žena propustila svého muže a vdala se za jiného, cizoloží.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tehdy k němu přinášeli malé děti, aby se jich dotkl, ale učedníci přísně napomínali ty, kteří je přinášeli. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Když to ale uviděl Ježíš, rozhořčil se a řekl jim: “Nechte děti přicházet ke mně a nebraňte jim, protože takovým patří Boží království. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Amen, říkám vám, že kdokoli nepřijme Boží království jako dítě, nikdy do něho nevejde.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tehdy je bral do náručí, pokládal na ně ruce a žehnal jim. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Když potom vycházel na cestu, přiběhl jeden muž, poklekl před ním a ptal se ho: “Dobrý mistře, co mám udělat, abych se stal dědicem věčného života?” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ježíš mu však řekl: “Proč mě nazýváš dobrým? Nikdo není dobrý, jen jediný - Bůh. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Přikázání znáš: ‘Abys nezcizoložil, nezabil, neukradl, nevydal falešné svědectví, nepodvedl; cti svého otce i matku.’” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","On mu odpověděl: “Mistře, to všechno jsem dodržoval odmalička.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A když se na něho Ježíš podíval, zamiloval si ho a řekl mu: “Jedno ti schází - jdi, prodej všechno, co máš, a dej chudým a budeš mít poklad v nebi. A pojď, vezmi kříž a následuj mne.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ale on se z těch slov zarmoutil a smutně odešel. Měl totiž mnoho majetku. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A když se Ježíš rozhlédl, řekl svým učedníkům: “Jak nesnadno vejdou do Božího království ti, kdo mají bohatství!” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Učedníci však nad těmi jeho slovy užasli. Ježíš jim tedy znovu odpověděl: “Synové, jak těžké je pro ty, kdo spoléhají na bohatství, vejít do Božího království. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Je snadnější, aby velbloud prošel uchem jehly, než aby boháč vešel do Božího království.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Oni si tedy mezi sebou v nesmírném úžasu řekli: “Kdo tedy může být spasen?” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ježíš se na ně podíval a řekl: “U lidí je to nemožné, ale ne u Boha, protože u Boha je možné všechno.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petr mu tedy začal říkat: “Pohleď, my jsme všechno opustili a šli jsme za tebou.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ježíš odpověděl: “Amen, říkám vám, že není nikdo, kdo by opustil dům nebo bratry nebo sestry nebo otce nebo matku nebo ženu nebo děti nebo pole kvůli mně a kvůli evangeliu ");
INSERT INTO cesnkb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a nepřijal by nyní v tomto čase stokrát tolik domů a bratrů a sester a matek a dětí a polí s pronásledováním a v nadcházejícím věku věčný život. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mnozí první však budou poslední a poslední první.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tehdy byli na cestě vzhůru do Jeruzaléma a Ježíš šel napřed. Byli ohromeni, a jak šli za ním, báli se. Vzal tedy těch dvanáct znovu k sobě a začal jim říkat, co se mu má stát: ");
INSERT INTO cesnkb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Hle, jdeme do Jeruzaléma a tam bude Syn člověka vydán velekněžím a zákoníkům. Odsoudí ho k smrti, vydají ho pohanům, ");
INSERT INTO cesnkb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","budou se mu vysmívat, zbičují ho, poplivou ho a zabijí, ale třetího dne vstane z mrtvých.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tehdy k němu přistoupili Zebedeovi synové Jakub a Jan se slovy: “Mistře, chceme, abys pro nás udělal, o cokoli tě poprosíme.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Řekl jim tedy: “Co chcete, abych pro vás udělal?” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Oni mu řekli: “Dej nám, abychom mohli sedět ve tvé slávě jeden po tvé pravici a druhý po tvé levici.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ale Ježíš jim řekl: “Vy nevíte, o co prosíte. Můžete pít kalich, který já piji, a být pokřtěni křtem, kterým se já křtím?” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Oni mu řekli: “Můžeme.” Ježíš jim však řekl: “Budete pít kalich, který já piji, a budete pokřtěni křtem, kterým se já křtím; ");
INSERT INTO cesnkb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","avšak dát vám sedět po mé pravici nebo levici, to není má věc, ale patří těm, pro které je to připraveno.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A když to uslyšelo ostatních deset, začali se na Jakuba a Jana hněvat. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ježíš je však zavolal k sobě a řekl jim: “Víte, že ti, kterým se líbí vládnout nad národy, nad nimi panují a jejich velikáni nad nimi užívají moc. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tak to ale mezi vámi nebude. Kdokoli by mezi vámi chtěl být veliký, bude vaším služebníkem, ");
INSERT INTO cesnkb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","a kdokoli by mezi vámi chtěl být první, bude otrokem všech. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vždyť ani Syn člověka nepřišel, aby se mu sloužilo, ale aby sloužil a aby dal svůj život jako výkupné za mnohé.” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Potom přišli do Jericha. A když se svými učedníky a s velikým zástupem lidí vycházel z Jericha, seděl u cesty slepý Bartimeus, Timeův syn, a žebral. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Když uslyšel, že je to Ježíš Nazaretský, začal křičet a říkat: “Ježíši, Synu Davidův, smiluj se nade mnou!” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mnozí ho přísně napomínali, aby mlčel, ale on křičel ještě více: “Synu Davidův, smiluj se nade mnou!” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ježíš se tedy zastavil a řekl, ať ho zavolají. A když toho slepce volali, říkali mu: “Buď dobré mysli! Vstávej, volá tě!” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Odhodil tedy svůj plášť, vstal a přišel k Ježíši. ");
INSERT INTO cesnkb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ježíš mu odpověděl: “Co chceš, abych pro tebe udělal?” Ten slepec mu řekl: “Rabboni, ať vidím!” ");
INSERT INTO cesnkb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tehdy mu Ježíš řekl: “Jdi, tvá víra tě uzdravila.” A on ihned prohlédl a následoval Ježíše na cestě. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Když se pak přiblížili k Jeruzalému - k Betfagé a Betanii u Olivetské hory, poslal dva ze svých učedníků ");
INSERT INTO cesnkb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a řekl jim: “Jděte do té vesnice naproti vám, a hned jak do ní vejdete, najdete přivázané oslátko, na kterém ještě nikdo z lidí neseděl. Odvažte ho a přiveďte. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A kdyby vám někdo řekl: ‘Co to děláte?’ řekněte: ‘Pán ho potřebuje,’ a hned ho zase pošle sem.” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","A tak odešli a našli oslátko přivázané venku u dveří domu na nároží a odvázali ho. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tehdy jim někteří z kolem stojících řekli: “Co děláte, že odvazujete to oslátko?” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Oni jim však řekli, jak jim přikázal Ježíš, a tak je nechali. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Potom to oslátko přivedli k Ježíši, hodili na ně své pláště a on si na ně sedl. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mnozí rozprostřeli své pláště na cestě a jiní sekali ratolesti ze stromů a stlali je na cestu. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A ti, kteří šli napřed, i ti, kdo šli za ním, volali: “Hosana! Požehnaný, který přichází v Pánově jménu! ");
INSERT INTO cesnkb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Požehnané je království našeho otce Davida, přicházející v Pánově jménu! Hosana na výsostech!” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tak tedy Ježíš vstoupil do Jeruzaléma i do chrámu. Když si všechno prohlédl, byl už večer, a tak vyšel se dvanácti do Betanie. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Když potom druhého dne vycházeli z Betanie, dostal Ježíš hlad. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A když zdálky uviděl fíkovník, jak má listí, šel k němu, zda by snad na něm něco nenalezl. A když přišel, nenašel na něm nic než listí, protože nebyl čas fíků. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ježíš mu tedy řekl: “Ať z tebe navěky už nikdo nejí ovoce!” A jeho učedníci to slyšeli. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","A tak přišli do Jeruzaléma. Když pak Ježíš vešel do chrámu, začal vyhánět ty, kdo v chrámu prodávali i kupovali, a zpřevracel stoly směnárníků i sedačky prodavačů holubic. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A nikomu nedovoloval ani přenášet zboží skrze chrám. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Vyučoval je a říkal jim: “Není snad napsáno, že ‘Můj dům bude nazván domem modlitby pro všechny národy’? Vy jste z něj ale udělali ‘doupě lupičů’!” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Když to však uslyšeli zákoníci a velekněží, hledali způsob, jak by ho zahubili, protože se ho báli. Všechen zástup totiž žasl nad jeho učením. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","A když nastal večer, vyšel ven z města. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Když potom šli za svítání kolem toho fíkovníku, uviděli, že uschl od kořenů. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petr se tedy rozpomněl a řekl mu: “Mistře, podívej se, ten fíkovník, který jsi proklel, uschl!” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ježíš jim odpověděl: “Mějte Boží víru. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Amen, říkám vám, že kdokoli by řekl této hoře: ‘Zvedni se a vrhni se do moře,’ a nepochyboval by ve svém srdci, ale věřil by, že se děje to, co říká, bude mít, cokoli řekl. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Proto vám říkám: Věřte, že všechno, o co při modlitbě prosíte, jste dostali a budete to mít. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A když se postavíte k modlitbě, odpouštějte, pokud máte něco proti někomu, aby i váš Otec v nebesích odpustil vaše prohřešky vám. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jestliže však vy neodpouštíte, ani váš Otec, který je v nebesích, neodpustí vaše prohřešky vám.” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Potom znovu přišli do Jeruzaléma, a když se procházel v chrámu, přistoupili k němu velekněží, zákoníci a starší lidu. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Řekli mu: “Jakou mocí děláš tyto věci? A kdo ti tu moc dal, že je děláš?” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ježíš jim však odpověděl: “Já se vás také zeptám na jednu věc. Odpovězte mi a potom vám řeknu, jakou mocí dělám tyto věci. ");
INSERT INTO cesnkb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Byl Janův křest z nebe, nebo z lidí? Odpovězte mi.” ");
INSERT INTO cesnkb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Uvažovali tedy mezi sebou a říkali: “Kdybychom řekli, že z nebe, řekne nám: ‘Proč jste mu tedy neuvěřili?’ ");
INSERT INTO cesnkb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Když ale řekneme, že z lidí...” (báli se totiž lidu, protože všichni měli zato, že Jan byl opravdový prorok). ");
INSERT INTO cesnkb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Odpověděli tedy Ježíši a řekli: “Nevíme.” Ježíš jim odpověděl: “Ani já vám tedy neřeknu, jakou mocí dělám tyto věci.” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tehdy k nim začal mluvit v podobenstvích: “Jeden člověk vysadil vinici, obehnal ji plotem, vykopal v ní lis a postavil věž. Potom ji pronajal vinařům a odešel na cestu. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","A když byl čas vinobraní, poslal k těm vinařům služebníka, aby od vinařů převzal díl z úrody vinice. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Oni ho však vzali, zbili a poslali pryč s prázdnou. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A tak k nim znovu poslal jiného služebníka. Toho kamenovali, poranili na hlavě a poslali pryč zohaveného. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Poslal tedy opět jiného. A toho zabili a mnoho jiných také. Některé bili a jiné zabíjeli. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Měl ale ještě jediného syna, svého milovaného, a tak k nim nakonec poslal jeho se slovy: ‘Mého syna budou mít ve vážnosti.’ ");
INSERT INTO cesnkb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ale ti vinaři řekli jedni druhým: ‘Tohle je dědic, pojďte, zabijme ho a dědictví bude naše.’ ");
INSERT INTO cesnkb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A tak ho vzali, zabili a vyhodili z vinice ven. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Co tedy udělá pán té vinice? Přijde a zahubí ty vinaře a vinici dá jiným. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nečetli jste snad Písmo? ‘Kámen, který stavitelé zavrhli, se stal hlavním kamenem klenby. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Stalo se to od Pána a je to v našich očích div.’” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chtěli ho tedy zatknout, ale zalekli se zástupu. Poznali totiž, že to podobenství řekl o nich. A tak ho nechali a odešli. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Potom k němu poslali některé z farizeů a herodiánů, aby ho chytili za slovo. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Přišli tedy a řekli mu: “Mistře, víme, že jsi pravdomluvný a na nikoho nedbáš, neboť se neohlížíš na to, kdo je kdo, ale pravdivě učíš Boží cestě. Je správné dávat císaři daň nebo ne? Máme dávat nebo nedávat?” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","On ale znal jejich pokrytectví a řekl jim: “Proč mě pokoušíte? Přineste mi peníz, ať se podívám.” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A když ho přinesli, řekl jim: “Čí je tento obraz a nápis?” Řekli mu: “Císařův.” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ježíš jim tedy odpověděl: “Dejte to, co je císařovo, císaři, a co je Božího, Bohu.” A nad tím se podivili. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Potom k němu přišli saduceové, kteří říkají, že není vzkříšení, a ptali se ho: ");
INSERT INTO cesnkb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mistře, Mojžíš nám napsal, že kdyby něčí bratr zemřel a zanechal po sobě manželku, ale neměl by děti, ať si jeho ženu vezme jeho bratr a vzbudí svému bratru potomka. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bylo tedy sedm bratrů. První se oženil a zemřel a nezanechal potomka. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A když si ji vzal druhý, také zemřel a nezanechal potomka. A stejně tak třetí. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A tak ji mělo všech sedm, ale nezanechali potomka. Poslední ze všech pak zemřela i ta žena. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Až tedy při vzkříšení vstanou z mrtvých, kterého z nich bude manželkou? Vždyť ji mělo za manželku všech sedm!” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ježíš jim však odpověděl: “Nebloudíte snad proto, že neznáte Písma ani Boží moc? ");
INSERT INTO cesnkb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vždyť až lidé vstanou z mrtvých, nebudou se ženit ani vdávat, ale budou jako andělé v nebi. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ale o mrtvých, že vstávají - copak jste nečetli v Mojžíšově knize, jak k němu Bůh promluvil z keře? Řekl mu: ‘Já jsem Bůh Abrahamův, Bůh Izákův a Bůh Jákobův.’ ");
INSERT INTO cesnkb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","On není Bohem mrtvých, ale Bohem živých! Proto jste ve velikém bludu.” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A když jeden ze zákoníků uslyšel, jak se spolu hádají, a poznal, že jim dobře odpověděl, přistoupil a zeptal se ho: “Které přikázání je ze všech nejpřednější?” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ježíš mu odpověděl: “Nejpřednější ze všech je přikázání: ‘Slyš, Izraeli: Pán, náš Bůh, je jeden Pán. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Proto budeš milovat Pána, svého Boha, celým svým srdcem, celou svou duší, celou svou myslí a ze vší své síly.’ To je první přikázání. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A druhé, podobné, je toto: ‘Budeš milovat svého bližního jako sám sebe.’ Žádné přikázání není větší než tato dvě.” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A ten zákoník mu řekl: “Mistře, to jsi opravdu řekl dobře, neboť Bůh je jeden a kromě něj není žádný jiný. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A milovat ho celým srdcem, celým rozumem, celou duší a ze vší síly a milovat svého bližního jako sám sebe, to je nade všechny zápaly a oběti.” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A když Ježíš uviděl, že mu odpověděl rozumně, řekl mu: “Nejsi daleko od Božího království.” A nikdo se ho už neodvažoval na nic zeptat. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Když potom Ježíš vyučoval v chrámu, odpověděl: “Jak mohou zákoníci říkat, že Kristus je Davidův syn? ");
INSERT INTO cesnkb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Vždyť sám David řekl v Duchu Svatém: ‘Pán řekl mému Pánu: Seď po mé pravici, dokud nepoložím tvé nepřátele za podnož tvých nohou.’ ");
INSERT INTO cesnkb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Když ho tedy sám David nazývá Pánem, jak může být Kristus jeho syn?” A veliký zástup ho rád poslouchal. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ve svém vyučování jim tedy říkal: “Varujte se zákoníků, kteří se chtějí procházet ve slavnostních pláštích a být zdraveni na tržištích, ");
INSERT INTO cesnkb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","sedět na předních sedadlech ve shromážděních a na čestných místech při večeřích, ");
INSERT INTO cesnkb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","kteří vyjídají domy vdov a předstírají dlouhé modlitby. Ti dostanou těžší rozsudek.” ");
INSERT INTO cesnkb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Potom se posadil naproti pokladnici a díval se, jak do ní lidé házejí peníze. A mnoho bohatých tam házelo hodně. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Když pak přišla jedna chudá vdova, hodila tam dva haléřky (což je jeden čtvrťák). ");
INSERT INTO cesnkb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tehdy svolal své učedníky a řekl jim: “Amen, říkám vám, že tato chudá vdova dala více než všichni, kdo házeli peníze do pokladnice. ");
INSERT INTO cesnkb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Všichni totiž dávali ze svého nadbytku, ale tato žena dala ze svého nedostatku všechno, co měla, celé své živobytí.” ");
INSERT INTO cesnkb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Když potom vycházel z chrámu, řekl mu jeden z jeho učedníků: “Mistře, pohleď, jaké kameny a jaké stavby!” ");
INSERT INTO cesnkb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ježíš mu odpověděl: “Vidíš tyto veliké stavby? Nebude tu ponechán kámen na kameni: všechno bude zbořeno.” ");
INSERT INTO cesnkb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Když se pak posadil na Olivetské hoře naproti chrámu, ptali se ho soukromě Petr, Jakub, Jan a Ondřej: ");
INSERT INTO cesnkb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Řekni nám, kdy to bude a jaké bude znamení času, kdy se toto všechno naplní?” ");
INSERT INTO cesnkb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tehdy jim Ježíš začal odpovídat: “Dejte pozor, aby vás nikdo nesvedl. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mnozí totiž přijdou pod mým jménem a budou říkat: ‘Já jsem Kristus,’ a svedou mnohé. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Když pak uslyšíte války a zprávy o válkách, nestrachujte se, protože se to musí dít. Ale to ještě nebude konec. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Povstane totiž národ proti národu a království proti království. Na různých místech budou zemětřesení a budou hladomory a nepokoje. Toto jsou počátky porodních bolestí. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ale vy na sebe dávejte pozor. Budou vás totiž vydávat soudům a shromážděním; budete biti a stanete kvůli mně před vládci a králi, na svědectví pro ně. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ale nejdříve musí být všem národům kázáno evangelium. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A když vás budou odvádět a dávat do vězení, nedělejte si předem starosti a nerozmýšlejte si, co byste řekli, ale mluvte to, co vám bude dáno v tu chvíli. Nejste to totiž vy, kdo mluví, ale Duch Svatý. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tehdy vydá bratr bratra na smrt, i otec svého syna, a děti povstanou proti rodičům a zabijí je. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","A všichni vás budou nenávidět kvůli mému jménu. Ale kdo vytrvá až do konce, ten bude spasen.” ");
INSERT INTO cesnkb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ale když uvidíte ‘ohavnost zpustošení’, o níž mluvil prorok Daniel, jak stojí, kde stát nemá (kdo čte, rozuměj), tehdy ať ti, kdo jsou v Judsku, utíkají do hor. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kdo bude na střeše, ať nesestupuje do svého domu, ani nevchází, aby si ze svého domu něco vzal. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","A kdo na poli, ať se nevrací zpátky, aby si vzal svůj plášť. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ale běda bude v těch dnech těhotným a těm, které kojí. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Proto se modlete, aby váš útěk nenastal v zimě. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Protože ty dny budou dny soužení, jaké do této doby nebylo od počátku stvoření, které Bůh stvořil, a jaké už nikdy nebude. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A kdyby Pán ty dny nezkrátil, nezachránil by se žádný člověk. Kvůli vyvoleným, které vyvolil, však Pán ty dny zkrátil.” ");
INSERT INTO cesnkb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kdyby vám v té době někdo řekl: ‘Hle, Kristus je zde!’ anebo ‘Pohleďte, tam je!’, nevěřte. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Povstanou totiž falešní kristové a falešní proroci a budou dělat divy a zázraky, aby sváděli (kdyby to bylo možné) dokonce i vyvolené. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ale vy dávejte pozor. Hle, všechno jsem vám řekl předem. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","V těch dnech po tom soužení se pak zatmí slunce a měsíc nevydá své světlo. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hvězdy budou padat z nebe a mocnosti, které jsou v nebesích, budou otřeseny. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A tehdy spatří Syna člověka, jak přichází v oblacích s velikou mocí a slávou. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A tehdy pošle své anděly a shromáždí své vyvolené od čtyř větrů, od nejzazšího konce země po nejzazší konec nebe.” ");
INSERT INTO cesnkb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Naučte se tedy od fíkovníku tomuto podobenství: Když již jeho větev změkne a vyráží listí, poznáváte, že léto je blízko. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tak i vy, až uvidíte, jak se dějí tyto věci, vězte, že je blízko, že už je ve dveřích. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Amen, říkám vám, že toto pokolení rozhodně nepomine, než se toto všechno stane. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nebe a země pominou, ale má slova nikdy nepominou. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","O tom dni a hodině však nikdo neví - ani andělé v nebi ani Syn, jenom Otec. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dávejte pozor, buďte bdělí a modlete se, vždyť nevíte, kdy nastane ten čas. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Je to jako když člověk odešel na cestu: opustil svůj dům a svěřil správu svým služebníkům. Každému určil jeho práci a vrátnému přikázal, aby bděl. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Proto bděte, neboť nevíte, kdy přijde pán domu - zda večer nebo o půlnoci nebo za kuropění nebo za svítání. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aby vás snad, když znenadání přijde, nenalezl spící. ");
INSERT INTO cesnkb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A co říkám vám, říkám všem: Bděte.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Za dva dny byla Veliká noc a svátek nekvašených chlebů a velekněží se zákoníky hledali způsob, jak by se ho lstí zmocnili a zabili ho. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Říkali ale: “Ne ve svátek, aby snad nebylo pozdvižení lidu.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Když pak byl v Betanii a stoloval v domě Šimona Malomocného, přišla žena s alabastrovou nádobkou velmi drahé masti z pravého nardu. A když tu nádobku rozbila a vylila na jeho hlavu, ");
INSERT INTO cesnkb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","hněvali se někteří mezi sebou a říkali: “K čemu je ta ztráta této masti? ");
INSERT INTO cesnkb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Vždyť se to mohlo prodat za více než tři sta denárů a dát chudým!” A hubovali ji. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ale Ježíš řekl: “Nechte ji. Proč ji trápíte? Udělala pro mě dobrý skutek. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chudé přece máte u sebe vždycky, a kdykoli chcete, můžete pro ně konat dobro, ale mne vždycky mít nebudete. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tato žena udělala, co mohla. Předem pomazala mé tělo k pohřbu. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Amen, říkám vám, že kdekoli se na celém světě bude kázat toto evangelium, bude se mluvit také o tom, co udělala ona, na její památku.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tehdy jeden ze dvanácti, Jidáš Iškariotský, odešel k velekněžím, aby jim ho zradil. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Když to uslyšeli, zaradovali se a slíbili, že mu dají peníze. Začal tedy hledat příležitost, jak by ho zradil. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Prvního dne svátku nekvašených chlebů, když býval obětován velikonoční beránek, mu jeho učedníci řekli: “Kam chceš, abychom šli a připravili ti k jídlu beránka?” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tehdy poslal dva ze svých učedníků a řekl jim: “Jděte do města a potká vás člověk, který ponese džbán vody. Jděte za ním. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A tam, kam vejde, řekněte hospodáři: ‘Mistr říká: Kde je místnost, v níž bych se svými učedníky pojedl beránka?’ ");
INSERT INTO cesnkb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","On vám ukáže velikou horní místnost, prostřenou a připravenou. Tam nám připravte večeři.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Učedníci tedy odešli, a když přišli do města, našli všechno tak, jak jim řekl, a připravili beránka. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Když pak nastal večer, přišel Ježíš se dvanácti. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","A když byli za stolem a jedli, Ježíš řekl: “Amen, říkám vám, že jeden z vás, kdo jí se mnou, mě zradí.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Začali se tedy rmoutit a jeden po druhém mu říkali: “Snad ne já?” A jiný: “Snad ne já?” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ale on jim odpověděl: “Je to jeden ze dvanácti, ten, který se mnou namáčí ruku do mísy. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Syn člověka jde vskutku tak, jak je o něm napsáno, ale běda člověku, jímž je Syn člověka zrazován. Pro toho člověka by bylo lepší, kdyby se vůbec nenarodil.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","A když jedli, vzal Ježíš chléb, požehnal, rozlomil a dal jim ho se slovy: “Vezměte, jezte, to je mé tělo.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Potom vzal kalich, vzdal díky a podal jim ho. A pili z něho všichni. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tehdy jim řekl: “Toto je má krev nové smlouvy, která se prolévá za mnohé. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Amen, říkám vám, že už nebudu pít z plodu vinného kmene až do toho dne, kdy ho budu pít nový v Božím království.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","A když zazpívali žalm, vyšli na Olivetskou horu. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tehdy jim Ježíš řekl: “Všichni ode mne této noci odpadnete. Je přece napsáno: ‘Budu bít pastýře a ovce se rozprchnou.’ ");
INSERT INTO cesnkb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ale až vstanu z mrtvých, předejdu vás do Galileje.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tehdy mu Petr řekl: “I kdyby všichni odpadli, já nikdy!” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ježíš mu řekl: “Amen, říkám ti, že ještě dnes v noci, dříve než se dvakrát ozve kohout, mě třikrát zapřeš.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ale on tvrdil mnohem více: “I kdybych měl s tebou zemřít, nikdy tě nezapřu!” A podobně mluvili i všichni ostatní. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tehdy přišli na místo zvané Getsemane. Tehdy řekl svým učedníkům: “Posaďte se tu, než se pomodlím.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Vzal s sebou Petra, Jakuba a Jana a tu se začal děsit a mít velikou úzkost. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tehdy jim řekl: “Má duše je smutná až k smrti. Zůstaňte tu a bděte.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pak poodešel kousek dál, padl na zem a modlil se, aby, jestli je to možné, od něj ta hodina odešla. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tehdy řekl: “Abba, Otče, pro tebe je možné všechno. Odejmi ode mě tento kalich! Avšak ne, co já chci, ale co chceš ty.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Potom přišel a nalezl je, jak spí. Řekl tedy Petrovi: “Šimone, ty spíš? Nemohl jsi bdít jedinou hodinu? ");
INSERT INTO cesnkb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bděte a modlete se, abyste nevešli do pokušení. Duch je sice připraven, ale tělo je slabé.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Potom opět odešel a modlil se týmiž slovy. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A když se vrátil, znovu je nalezl, jak spí, protože jim ztěžkly oči. Nevěděli tedy, co by mu odpověděli. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A když přišel potřetí, řekl jim: “Vy ještě spíte a odpočíváte? Dost už! Pohleďte, přišla ta hodina a Syn člověka je vydáván do rukou hříšníků. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Vstávejte, pojďme! Hle, můj zrádce už je blízko.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","A když ještě mluvil, náhle přišel Jidáš, jeden ze dvanácti, a s ním veliký zástup s meči a holemi, poslaný od velekněží, zákoníků a starších. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A jeho zrádce s nimi měl smluvené znamení. Řekl: “Je to ten, kterého políbím. Chopte se ho a veďte ho opatrně.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A když přišel, ihned přistoupil k němu a řekl: “Rabbi, Rabbi,” a políbil ho. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tehdy na něj vztáhli ruce a chopili se ho. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jeden z těch, kdo stáli kolem něj, však vytasil meč, zasáhl otroka nejvyššího kněze a usekl mu ucho. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tehdy jim Ježíš odpověděl a řekl: “Vypravili jste se jako na zločince, s meči a holemi, abyste mě zatkli? ");
INSERT INTO cesnkb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Každý den jsem byl s vámi, vyučoval jsem v chrámu a nezatkli jste mě. Ale ať se naplní Písma!” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tehdy ho všichni opustili a utekli. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ale jeden mladík šel za ním oblečen do lněného plátna na nahém těle. A když ho mládenci chytili, ");
INSERT INTO cesnkb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nechal tam to plátno a utekl nahý. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ježíše pak odvedli k nejvyššímu knězi, u něhož se sešli všichni velekněží i starší a zákoníci. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petr ho ale zpovzdálí následoval až dovnitř, na dvůr nejvyššího kněze a tam si sedl mezi sluhy a ohříval se u ohně. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Velekněží s celou veleradou pak proti Ježíši hledali svědectví, aby ho vydali na smrt, ale žádné nenalézali. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mnozí totiž proti němu křivě svědčili, ale jejich svědectví se neshodovala. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Potom někteří povstali a křivě proti němu svědčili: ");
INSERT INTO cesnkb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“My jsme ho slyšeli, jak řekl: ‘Já zbořím tento chrám udělaný rukama a za tři dny postavím jiný, neudělaný rukama.’” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ale ani tak se jejich svědectví neshodovala. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tehdy povstal uprostřed nejvyšší kněz a zeptal se Ježíše: “Nic neodpovídáš? Co proti tobě svědčí tito muži?” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ale on mlčel a nic neodpověděl. Nejvyšší kněz se ho tedy ptal znovu a řekl mu: “Jsi ty Kristus, ten Syn Požehnaného?” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ježíš řekl: “Já jsem. A vy uvidíte Syna člověka sedět po pravici Moci a přicházet s nebeskými oblaky.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tehdy nejvyšší kněz roztrhl své roucho a řekl: “K čemu ještě potřebujeme svědky? ");
INSERT INTO cesnkb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Slyšeli jste rouhání! Co si o tom myslíte?” A všichni ho odsoudili, že je hoden smrti. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A někteří po něm začali plivat a zahalovat mu tvář a bít ho pěstmi a říkat mu: “Prorokuj!” A sluhové ho tloukli holemi. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A zatímco byl Petr dole na dvoře, přišla tam jedna ze služek nejvyššího kněze, ");
INSERT INTO cesnkb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a když si všimla Petra, jak se ohřívá, podívala se na něj a řekla: “Ty jsi byl také s tím Ježíšem z Nazaretu.” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ale on to zapřel. Řekl: “Nevím, ani nerozumím, o čem mluvíš!” A vyšel ven před dvůr. A tehdy zakokrhal kohout. ");
INSERT INTO cesnkb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Potom ho ta služebná uviděla znovu a začala říkat těm, kdo stáli kolem: “Tohle je jeden z nich!” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","On to však znovu zapíral. Po malé chvíli říkali zase ti kolemstojící Petrovi: “Jistěže jsi jeden z nich, vždyť jsi Galilejec. I tvé nářečí to dokazuje!” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","On se ale začal proklínat a přísahat: “Toho člověka, o kterém mluvíte, neznám!” ");
INSERT INTO cesnkb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A vtom zakokrhal kohout podruhé a Petr si vzpomněl na slova, která mu Ježíš řekl: “Dříve než se dvakrát ozve kohout, třikrát mě zapřeš.” A když na to pomyslel, rozplakal se. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A hned za svítání, když se velekněží poradili se staršími a se zákoníky i s celou veleradou, svázali Ježíše, odvedli ho a vydali Pilátovi. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilát se ho zeptal: “Ty jsi ten židovský král?” Ale on mu odpověděl: “Ty to říkáš.” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Potom ho velekněží začali obviňovat z mnoha věcí, ale on nic neodpovídal. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilát se ho tedy znovu zeptal: “Nic neodpovídáš? Pohleď, z kolika věcí tě obviňují.” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ježíš ale stejně nic neodpověděl, takže se Pilát divil. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Byl však zvyklý propouštět jim ve svátek jednoho vězně, za kterého prosili. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tehdy byl společně s jinými vzbouřenci, kteří při vzpouře spáchali vraždu, uvězněn jeden jménem Barabáš. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Zástup se tedy dal do křiku a začal prosit Piláta o to, co jim dělal vždycky. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilát jim ale odpověděl: “Chcete, abych vám propustil židovského krále?” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","(Poznával totiž, že mu ho velekněží vydali ze závisti.) ");
INSERT INTO cesnkb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Velekněží však vyburcovali zástup, ať žádá, aby jim raději propustil Barabáše. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilát jim tedy znovu odpověděl a řekl: “Co tedy chcete, abych udělal s tím, kterého nazýváte králem Židů?” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A oni znovu zakřičeli: “Ukřižuj ho!” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilát jim řekl: “A co udělal zlého?” Ale oni křičeli ještě víc: “Ukřižuj ho!” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A Pilát, který chtěl vyhovět davu, jim propustil Barabáše, ale Ježíše nechal zbičovat a vydal ho k ukřižování. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tehdy ho vojáci odvedli dovnitř na nádvoří paláce zvaného Pretorium a svolali celou posádku. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Oblékli mu purpurový plášť a nasadili mu korunu upletenou z trní. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pak ho začali zdravit: “Buď zdráv, židovský králi!” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bili ho holí do hlavy, plivali na něj, klekali před ním a klaněli se mu. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Když se mu dost naposmívali, svlékli z něho ten plášť a oblékli mu jeho šaty. Potom ho vyvedli, aby ho ukřižovali. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A přinutili nějakého kolemjdoucího, Šimona Kyrénského (otce Alexandra a Rufa), který šel z pole, aby vzal jeho kříž. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Vedli ho na místo zvané Golgota, což v překladu znamená Místo lebky. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dávali mu pít víno s myrhou, ale on to nepřijal. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A jak ho křižovali, dělili si jeho šaty a házeli o ně los, kdo si co vezme. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Když ho ukřižovali, byla třetí hodina dne. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","A nad ním byl napsán nápis jeho viny: “ŽIDOVSKÝ KRÁL.” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Spolu s ním ukřižovali dva zločince, jednoho po jeho pravici a druhého po levici. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tak se naplnilo Písmo, které říká: “Byl započten mezi zločince.” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kolemjdoucí mu spílali, pokyvovali hlavami a říkali: “Aha! Ty, který boříš chrám a za tři dny ho stavíš, ");
INSERT INTO cesnkb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","zachraň sám sebe a sestup z kříže!” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Podobně se posmívali i velekněží se zákoníky a říkali jeden druhému: “Jiné spasil, ale sám se spasit nemůže! ");
INSERT INTO cesnkb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ať ten Kristus, ten král Izraele, teď sestoupí z kříže, abychom to uviděli a uvěřili.” A hanobili ho i ti, kdo byli ukřižováni s ním. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A když přišla šestá hodina, nastala po celé zemi tma až do deváté hodiny. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A o deváté hodině Ježíš hlasitě vykřikl: “Eloi, Eloi, lama sabachtani?” což v překladu znamená: “Bože můj, Bože můj, proč jsi mě opustil?” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","A když to uslyšeli někteří z kolemstojících, říkali: “Podívejte, volá Eliáše!” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jeden z nich tedy odběhl, naplnil houbu octem, dal ji na větev a dával mu napít se slovy: “Nechte ho; uvidíme, jestli přijde Eliáš, aby ho dal dolů!” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ale Ježíš hlasitě vykřikl a vydechl naposled. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A chrámová opona se roztrhla na dva kusy odshora až dolů. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A když setník, který stál naproti němu, uviděl, jak vykřikl a naposled vydechl, řekl: “Ten člověk byl opravdu Boží Syn!” ");
INSERT INTO cesnkb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Byly tam také ženy, které přihlížely zpovzdálí; mezi nimi i Marie Magdaléna a Marie, matka Jozese a Jakuba Menšího, a Salome. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ty ho následovaly a sloužily mu, když byl ještě v Galileji, a s nimi mnoho jiných, které s ním přišly do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A protože už nastal večer a byl den připravování (to jest den před sobotou), ");
INSERT INTO cesnkb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","přišel Josef z Arimatie, ctihodný člen rady, jenž sám také očekával Boží království, osmělil se a vešel k Pilátovi a požádal o Ježíšovo tělo. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilát se ale podivil, že Ježíš už zemřel. Zavolal tedy setníka a zeptal se ho, je-li to dlouho, co zemřel. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","A když se to od setníka dozvěděl, daroval tělo Josefovi. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ten nakoupil plátno, a když ho sňal z kříže, ovinul ho tím plátnem a pochoval ho do hrobu, který byl vytesán ve skále. Ke dveřím hrobu pak přivalil kámen. ");
INSERT INTO cesnkb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ale Marie Magdaléna a Marie Jozesova se dívaly, kam byl pochován. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Když pak skončila sobota, nakoupily Marie Magdaléna, Marie Jakubova a Salome vonné masti, aby mohly jít pomazat Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Za svítání prvního dne týdne tedy přišly k hrobu, jakmile vyšlo slunce. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ale říkaly si: “Kdo nám odvalí kámen ode dveří hrobu?” ");
INSERT INTO cesnkb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(A když vzhlédly, spatřily, že kámen je odvalen.) Byl totiž velmi veliký. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","A když vešly do hrobu, uviděly napravo sedět mladíka oblečeného bílým rouchem a vylekaly se. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","On jim však řekl: “Nelekejte se. Hledáte ukřižovaného Ježíše z Nazaretu. Vstal, není tu. Pohleďte na místo, kam ho položili. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jděte ale a řekněte jeho učedníkům, i Petrovi, že jde před vámi do Galileje. Tam ho spatříte, jak vám řekl. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A tak rychle vyšly ven a utekly od hrobu, neboť na ně přišel strach a úžas. A nikomu nic neřekly, protože se bály. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","A když Ježíš vstal z mrtvých ráno v neděli, ukázal se nejdříve Marii Magdaléně, té, ze které vyhnal sedm démonů. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta šla a oznámila to těm, kdo bývali s ním a nyní truchlili a plakali. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A ti, když slyšeli, že žije a že ho viděla, neuvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Potom se jiným způsobem ukázal dvěma z nich na cestě, když šli na venkov. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A ti šli a oznámili to ostatním. Ani těm neuvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nakonec se ukázal jedenácti, když spolu seděli, a vyčítal jim jejich nevěru a tvrdost srdce, protože nevěřili těm, kdo ho viděli vzkříšeného. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Potom jim řekl: “Jděte do celého světa a kažte evangelium všemu stvoření. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kdo uvěří a pokřtí se, bude spasen, ale kdo neuvěří, bude odsouzen. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ty, kdo uvěří, pak budou provázet tato znamení: v mém jménu budou vymítat démony, budou mluvit v nových jazycích, ");
INSERT INTO cesnkb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","budou brát hady, a kdyby vypili něco jedovatého, nijak jim to neublíží; budou vkládat ruce na nemocné a bude jim dobře.” ");
INSERT INTO cesnkb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Když k nim tedy Pán domluvil, byl vzat vzhůru do nebe a posadil se po Boží pravici. ");
INSERT INTO cesnkb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A oni vyšli a kázali všude a Pán jim pomáhal a potvrzoval slovo znameními, která je doprovázela. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Poněvadž se mnozí pokusili po pořádku sepsat vyprávění o těch věcech, ve kterých my máme plnou jistotu ");
INSERT INTO cesnkb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","(neboť nám je předali ti, kdo byli od počátku očitými svědky a služebníky toho Slova), ");
INSERT INTO cesnkb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","zdálo se i mně dobré, abych ti o tom po pořádku napsal, vznešený Teofile, neboť jsem to všechno od začátku pečlivě vyhledal, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","abys poznal hodnověrnost těch věcí, jimž jsi byl naučen. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Za dnů judského krále Heroda byl jeden kněz, jménem Zachariáš, z Abiášovy kněžské třídy, a jeho manželka byla z dcer Áronových a jmenovala se Alžběta. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oba byli v Božích očích spravedliví a chodili bezúhonně ve všech Pánových přikázáních a ustanoveních. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Neměli však dítě, protože Alžběta byla neplodná a oba už byli v pokročilém věku. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A když konal kněžskou službu před Bohem podle pořadí své třídy, stalo se, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","že na něj podle zvyku kněžského úřadu padl los, aby vešel do Pánova chrámu a obětoval kadidlo. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Venku pak stálo veliké množství lidí modlících se v hodině zapálení kadidla. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tehdy se mu ukázal Pánův anděl stojící vpravo od kadidlového oltáře. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Když ho Zachariáš spatřil, zděsil se a padl na něj strach. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anděl mu však řekl: “Neboj se, Zachariáši, neboť tvá prosba byla vyslyšena a Alžběta, tvá manželka, ti porodí syna a dáš mu jméno Jan. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Z toho se budeš radovat a veselit a z jeho narození budou mít radost mnozí. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Neboť bude veliký v Pánových očích a nebude pít víno ani opojný nápoj a bude naplněn Duchem Svatým už z lůna své matky. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A mnohé ze synů Izraele obrátí k Pánu, jejich Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","On půjde před jeho tváří v duchu a moci Eliášově, aby obrátil srdce otců k synům a nepovolné k moudrosti spravedlivých, aby přichystal Pánu připravený lid.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zachariáš tedy řekl andělu: “Podle čeho to poznám? Vždyť jsem stařec a také má manželka je v pokročilém věku.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anděl mu odpověděl: “Já jsem Gabriel, ten, který stojí před Boží tváří, a byl jsem poslán, abych k tobě promluvil a oznámil ti tyto radostné zprávy. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A hle, budeš němý a nebudeš moci promluvit až do dne, kdy se tyto věci stanou, protože jsi neuvěřil mým slovům, která se ve svém čase naplní.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A lidé venku čekali na Zachariáše a divili se, že se tak zdržuje v chrámu. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Když pak vyšel, nemohl k nim promluvit. A tak poznali, že v chrámu spatřil vidění, neboť se s nimi dorozumíval posunky a zůstával němý. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Stalo se pak, že po naplnění dnů své služby odešel do svého domu. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jeho manželka Alžběta po těch dnech počala a tajila se s tím pět měsíců se slovy: ");
INSERT INTO cesnkb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Takto se ke mně zachoval Pán ve dnech, kdy na mě pohlédl a zbavil mě pohany mezi lidmi.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","V šestém měsíci pak byl anděl Gabriel poslán od Boha do galilejského města jménem Nazaret ");
INSERT INTO cesnkb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","k panně zasnoubené muži jménem Josef, z domu Davidova. A jméno té panny bylo Marie. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A když k ní přišel, řekl: “Zdravím tě, milostí obdařená, Pán s tebou! Jsi požehnaná mezi ženami!” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ale když ho spatřila, byla z jeho slov rozrušena a přemýšlela, co to bylo za pozdrav. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anděl jí tedy řekl: “Neboj se, Marie, vždyť jsi u Boha nalezla milost. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hle, počneš v lůnu a porodíš syna a dáš mu jméno Ježíš. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ten bude veliký a bude nazván Synem Nejvyššího a Pán, náš Bůh, mu dá trůn jeho otce Davida. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bude navěky kralovat nad domem Jákobovým a jeho království nebude mít konce. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marie však řekla andělu: “Jak se to stane, když dosud nepoznávám muže?” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anděl jí odpověděl: “Sestoupí na tebe Duch Svatý a zastíní tě moc Nejvyššího; proto také to svaté, co se z tebe narodí, bude nazýváno Syn Boží. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A pohleď, tvá příbuzná Alžběta, o které říkali, že je neplodná, ta také počala syna, i ve svém stáří - a je v šestém měsíci, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","neboť u Boha nebude nemožné žádné slovo.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tehdy Marie řekla: “Pohleď, jsem služebnice Pána. Ať se mi stane podle tvého slova!” A anděl od ní odešel. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","V těch dnech pak Marie vstala a spěšně odešla do hor, do města Judova. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Vešla do Zachariášova domu a pozdravila Alžbětu. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","A jakmile Alžběta uslyšela Mariin pozdrav, stalo se, že děťátko v jejím lůnu poskočilo a Alžběta byla naplněna Duchem Svatým. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tehdy hlasitě zvolala: “Požehnaná jsi mezi ženami a požehnaný plod tvého lůna! ");
INSERT INTO cesnkb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ale proč je mi dáno, že matka mého Pána přišla ke mně? ");
INSERT INTO cesnkb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Vždyť jakmile vešel zvuk tvého pozdravu do mých uší, poskočilo děťátko v mém lůnu radostí. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A blaze té, která uvěřila, neboť se naplní to, co jí bylo řečeno od Pána.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tehdy Marie řekla: “Má duše velebí Pána ");
INSERT INTO cesnkb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","a můj duch jásá v Bohu, mém Spasiteli, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","neboť pohlédl na ponížení své služebnice. Hle, od nynějška mne budou blahoslavit všechna pokolení, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","neboť mi učinil veliké věci Ten, který je mocný, jehož jméno je svaté ");
INSERT INTO cesnkb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","a jehož milosrdenství k těm, kteří se ho bojí, trvá od pokolení do pokolení. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Svou paží dokázal moc, rozptýlil pyšné v myšlení jejich srdce. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mocné svrhl z trůnů a ponížené povýšil. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hladové nasytil dobrými věcmi a bohaté propustil s prázdnou. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ujal se Izraele, svého služebníka; pamatoval na milosrdenství ");
INSERT INTO cesnkb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","- jak mluvil k našim otcům - vůči Abrahamovi a jeho semeni až navěky.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marie s ní pak zůstala asi tři měsíce a vrátila se do svého domu. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Alžbětě se tehdy naplnil čas k porodu a porodila syna. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A když její sousedé a příbuzní uslyšeli, že jí Pán prokázal své veliké milosrdenství, radovali se spolu s ní. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Osmého dne se pak stalo, že přišli to dítě obřezat a dávali mu jméno podle jeho otce, Zachariáš. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jeho matka jim však odpověděla: “Ne, bude se jmenovat Jan.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Řekli jí: “Vždyť ve tvém rodu se tak nikdo nejmenuje!” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ptali se tedy posunky jeho otce, jak by ho chtěl pojmenovat. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","On požádal o tabulku a napsal slova: “Jmenuje se Jan.” Všichni se podivili. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A jeho ústa se ihned otevřela a jeho jazyk se rozvázal a dobrořečil Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tehdy na všechny jejich sousedy přišla bázeň a po celých judských horách se rozmlouvalo o všech těchto věcech. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Všichni, kteří o tom slyšeli, to ukládali ve svém srdci se slovy: “Co to bude za dítě?” A Pánova ruka byla s ním. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jeho otec Zachariáš pak byl naplněn Duchem Svatým a prorokoval těmito slovy: ");
INSERT INTO cesnkb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Požehnaný Pán, Bůh Izraele, neboť nás navštívil a svému lidu způsobil vykoupení. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vyzdvihl nám roh spasení v domě Davida, svého služebníka, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","jak mluvil skrze ústa svých svatých proroků, kteří byli od věků, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","o vysvobození od našich nepřátel a z ruky všech, kteří nás nenávidí, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","aby prokázal milosrdenství našim otcům a vzpomenul na svou svatou smlouvu - ");
INSERT INTO cesnkb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na přísahu, kterou přísahal Abrahamovi, našemu otci - že nám dá, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","abychom vysvobozeni z ruky svých nepřátel beze strachu sloužili jemu ");
INSERT INTO cesnkb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ve svatosti a spravedlnosti před jeho tváří po všechny dny svého života. ");
INSERT INTO cesnkb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A ty, dítě, budeš nazváno prorokem Nejvyššího, neboť půjdeš před Pánovou tváří připravit jeho cesty, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","dát jeho lidu poznat spasení v odpuštění jejich hříchů ");
INSERT INTO cesnkb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","skrze niterné milosrdenství našeho Boha, v němž nás navštívil jako svítání z výšin, ");
INSERT INTO cesnkb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","aby se ukázal sedícím v temnotách a stínu smrti, aby přivedl naše nohy na cestu pokoje.” ");
INSERT INTO cesnkb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dítě pak rostlo a sílilo v duchu a bylo na pustinách až do dne, kdy se ukázalo Izraeli. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","V těch dnech se pak stalo, že vyšlo nařízení od císaře Augusta, aby byl sepsán celý obydlený svět. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Toto byl první soupis za syrského vladaře Quirinia.) ");
INSERT INTO cesnkb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A tak všichni šli, aby byli zapsáni, každý do svého města. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","I Josef z Galileje se tedy vydal z města Nazaret do Judska, do města Davidova zvaného Betlém (protože byl z domu a rodu Davidova), ");
INSERT INTO cesnkb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","aby byl zapsán s Marií, svou zasnoubenou manželkou, která byla těhotná. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A když tam byli, stalo se, že se naplnily dny, aby porodila. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A porodila svého prvorozeného syna, zavinula ho do plenek a položila ho do jeslí, protože pro ně nebylo místo v hospodě. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A v tom kraji byli pastýři, kteří přebývali na poli a drželi noční hlídky nad svým stádem. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Náhle se mezi ně postavil Pánův anděl; ozářila je Pánova sláva a přišla na ně veliká bázeň. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A ten anděl jim řekl: “Nebojte se, neboť hle, zvěstuji vám velikou radost, která bude pro všechen lid. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Neboť se vám dnes narodil Spasitel ve městě Davidově, totiž Kristus, Pán. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","A toto vám bude za znamení: naleznete děťátko zavinuté do plenek, ležící v jeslích.” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A hned se s andělem objevilo množství nebeského vojska, jež chválilo Boha a říkalo: ");
INSERT INTO cesnkb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Sláva na výsostech Bohu a na zemi pokoj, Boží zalíbení v lidech.” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","A stalo se, že když od nich ti andělé odešli do nebe, řekli pastýři jedni druhým: “Pojďme tedy do Betléma a pohleďme na tu věc, která se stala, jak nám ji Pán oznámil.” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Přišli tedy se spěchem a nalezli Marii a Josefa i to děťátko ležící v jeslích. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A když ho uviděli, začali rozhlašovat, co jim bylo o tom dítěti řečeno. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A všichni, kteří to slyšeli, užasli nad tím, co jim pastýři říkali. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marie pak všechna ta slova uchovávala a zvažovala ve svém srdci. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A ti pastýři při návratu oslavovali a chválili Boha za všechno, co slyšeli a viděli tak, jak jim bylo řečeno. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Když se pak naplnilo osm dní pro obřezání dítěte, dali mu jméno Ježíš, jak ho pojmenoval anděl předtím, než bylo počato v lůnu. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A když se naplnily dny jejího očišťování podle Mojžíšova zákona, přinesli ho do Jeruzaléma, aby ho postavili před Pánem ");
INSERT INTO cesnkb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(jak je napsáno v Pánově zákoně: “Každý chlapec otvírající lůno bude zasvěcen Pánu”) ");
INSERT INTO cesnkb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","a aby dali oběť, jak je to řečeno v Pánově zákoně: “Dvě hrdličky nebo dvě holoubata.” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A hle, v Jeruzalémě byl člověk jménem Simeon. Ten člověk byl spravedlivý a zbožný, očekával potěšení Izraele a Duch Svatý byl na něm. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jemu bylo od Ducha Svatého sděleno, že nespatří smrt dříve, než uvidí Pánova Krista. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ten přišel veden Duchem do chrámu. A když rodiče přinesli to dítě, Ježíše, aby s ním naložili podle zvyklosti Zákona, ");
INSERT INTO cesnkb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","tehdy ho vzal do náručí, dobrořečil Bohu a řekl: ");
INSERT INTO cesnkb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nyní, Hospodine, propouštíš svého služebníka v pokoji podle svého slova. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Neboť mé oči spatřily tvé spasení, ");
INSERT INTO cesnkb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","které jsi připravil před tváří všech lidí ");
INSERT INTO cesnkb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","- světlo ke zjevení národům a slávu tvého lidu Izraele.” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A jeho otec a matka se divili těm věcem, které o něm byly řečeny. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon jim požehnal a řekl Marii, jeho matce: “Hle, tento je určen k pádu a pozdvižení mnohých v Izraeli a za znamení, kterému bude odpíráno ");
INSERT INTO cesnkb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(a i tvou vlastní duší pronikne meč), aby bylo zjeveno myšlení mnoha srdcí.” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Byla tam také prorokyně Anna, dcera Fanuelova z pokolení Ašer. Ta byla ve velmi pokročilém věku a s mužem žila od svého panenství jen sedm let. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Byla vdova a bylo jí okolo osmdesáti čtyř let. Ta nevycházela z chrámu a dnem i nocí sloužila Bohu posty a modlitbami. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ta přišla ve stejnou chvíli a vzdávala Pánu chválu a říkala o něm všem, kdo v Jeruzalémě očekávali vykoupení. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A když vykonali všechno podle Pánova zákona, vrátili se do Galileje, do svého města Nazaretu. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dítě pak rostlo a sílilo v duchu, naplňováno moudrostí a Boží milost byla na něm. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jeho rodiče chodívali každý rok do Jeruzaléma na svátek Veliké noci. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Také když mu bylo dvanáct let, šli podle toho svátečního zvyku vzhůru do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","A když se naplnily dny toho svátku, a už se vraceli, zůstal chlapec Ježíš v Jeruzalémě a Josef ani jeho matka o tom nevěděli. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","V domnění, že je v karavaně, ušli den cesty a hledali ho mezi příbuznými a známými. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Když ho však nenalezli, vrátili se do Jeruzaléma a hledali ho. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Po třech dnech se pak stalo, že ho nalezli v chrámu, jak sedí uprostřed učitelů, naslouchá jim a dotazuje se jich. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A všichni, kdo ho slyšeli, žasli nad jeho rozumností a odpověďmi. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Když ho rodiče spatřili, ulekli se a jeho matka mu řekla: “Synu, proč jsi nám to udělal? Pohleď, tvůj otec a já jsme tě s bolestí hledali.” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A on jim řekl: “Proč jste mě hledali? Copak jste nevěděli, že musím být v tom, co je mého Otce?” ");
INSERT INTO cesnkb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Oni však slova, která jim říkal, nepochopili. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A tak šel s nimi, přišel do Nazaretu a byl jim poddán. Jeho matka pak uchovávala všechna ta slova ve svém srdci. ");
INSERT INTO cesnkb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A Ježíš prospíval moudrostí, věkem a milostí u Boha i u lidí. ");
INSERT INTO cesnkb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Patnáctého roku vlády císaře Tiberia, když byl Pontský Pilát vladařem v Judsku a Herodes byl tetrarchou Galileje, jeho bratr Filip tetrarchou Itureje a Trachonitské země a Lyzaniáš tetrarchou Abilény, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","za nejvyššího kněze Annáše a Kaifáše, se na poušti stalo Boží slovo k Janovi, synu Zachariášovu. ");
INSERT INTO cesnkb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ten šel do celého kraje kolem Jordánu a kázal křest pokání na odpuštění hříchů, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","jak je napsáno v knize slov proroka Izaiáše, který řekl: “Hlas volajícího na poušti: Připravte Pánovu cestu! Napřimujte jeho stezky! ");
INSERT INTO cesnkb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Každé údolí bude vyplněno a každá hora a pahorek budou sníženy; křivé věci budou přímé a hrbolaté cesty hladké. ");
INSERT INTO cesnkb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A veškeré tělo spatří spasení Boží.” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Proto říkal zástupům, které k němu vycházely, aby je křtil: “Plemeno zmijí! Kdo vám ukázal, jak utéci před přicházejícím hněvem? ");
INSERT INTO cesnkb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Neste tedy ovoce odpovídající vašemu pokání a nezačínejte si říkat: ‘Abrahama máme za otce.’ Říkám vám totiž, že Bůh je schopen Abrahamovi vzbudit syny z tohoto kamení. ");
INSERT INTO cesnkb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sekera je již přiložena ke kořeni stromů, a tak každý strom, který nenese dobré ovoce, bude vyťat a vhozen do ohně.” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zástupy se ho ptaly: “Co tedy máme dělat?” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Odpověděl jim: “Kdo má dvě košile, ať dá tomu, kdo nemá nic, a ten, kdo má jídlo, ať udělá totéž.” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Přišli pak také celníci, aby byli pokřtěni a řekli mu: “Mistře, co máme dělat?” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A on jim řekl: “Nevybírejte nic víc než to, co je vám nařízeno.” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ptali se ho také vojáci. Říkali: “A co máme dělat my?” Řekl jim tedy: “Nikoho nevydírejte ani nepodvádějte a buďte spokojeni se svým žoldem.” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A zatímco lid očekával a všichni si v srdci o Janovi mysleli, že by snad on mohl být Kristus, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jan všem odpověděl: “Jistě, já vás křtím vodou, ale přichází ten, který je silnější než já. Jemu nejsem hoden ani rozvázat řemínek jeho obuvi. On vás bude křtít Duchem Svatým a ohněm. ");
INSERT INTO cesnkb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jeho věječka je již v jeho ruce a on vyčistí svůj mlat. Pšenici shromáždí do své obilnice, ale plevy spálí neuhasitelným ohněm.” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A tak i mnoha jinými slovy napomínal lid a kázal evangelium. ");
INSERT INTO cesnkb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ale tetrarcha Herodes, když byl od něho kárán ohledně Herodiady, manželky svého bratra Filipa, a ohledně všech zlých věcí, které Herodes udělal, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","přidal ke všemu také to, že vsadil Jana do vězení. ");
INSERT INTO cesnkb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A když se křtil všechen lid, stalo se, že byl pokřtěn i Ježíš; a když se modlil, otevřelo se nebe ");
INSERT INTO cesnkb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","a Duch Svatý na něj sestoupil v tělesné podobě jako holubice a z nebe zazněl hlas, který řekl: “Ty jsi můj milovaný Syn, v tobě jsem nalezl zalíbení.” ");
INSERT INTO cesnkb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ježíš sám začínal asi ve třiceti letech a byl, jak se domnívali, syn Josefův, který byl syn Heliho, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","který byl Matata, který byl Léviho, který byl Melchiho, který byl Jannaje, který byl Josefa, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","který byl Matatiáše, který byl Amose, který byl Nahuma, který byl Esliho, který byl Naggaje, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","který byl Mahata, který byl Matatiáše, který byl Semeje, který byl Josefa, který byl Judy, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","který byl Johanana, který byl Resy, který byl Zorobábela, který byl Salatiela, který byl Neriho, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","který byl Melchiho, který byl Addiho, který byl Kosama, který byl Elmódama, který byl Era, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","který byl Joseho, který byl Eliezera, který byl Jórima, který byl Matata, který byl Léviho, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","který byl Šimeóna, který byl Judy, který byl Josefa, který byl Jónama, který byl Eliakima, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","který byl Meleje, který byl Ménama, který byl Mataty, který byl Nátana, který byl Davida, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","který byl Isaje, který byl Obéda, který byl Boáze, který byl Salmona, který byl Názona, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","který byl Amínadaba, který byl Arama, který byl Ezroma, který byl Fáresa, který byl Judy, který byl Jákoba, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","který byl Izáka, který byl Abrahama, který byl Táreho, který byl Náchora, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","který byl Sárucha, který byl Ragaua, který byl Fáleka, který byl Hebera, který byl Sály, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","který byl Kainana, který byl Arfaxada, který byl Sema, který byl Noéma, který byl Lámecha, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","který byl Matuzaléma, který byl Enocha, který byl Járeda, který byl Mahalalela, který byl Kainana, ");
INSERT INTO cesnkb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","který byl Enose, který byl Seta, který byl Adama, který byl Boží. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ježíš se pak vrátil od Jordánu plný Ducha Svatého a byl Duchem puzen na poušť. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Čtyřicet dní byl pokoušen ďáblem a v těch dnech nic nejedl, ale poté, co ty dny skončily, vyhladověl. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tehdy mu ďábel řekl: “Jsi-li Boží Syn, řekni tomuto kameni, ať se stane chlebem.” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A Ježíš mu odpověděl: “Je napsáno: ‘Nejen chlebem bude člověk živ, ale každým Božím slovem.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Potom ho ďábel vyvedl na vysokou horu a ukázal mu v jednom okamžiku všechna království světa. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ďábel mu řekl: “Dám ti všechnu tuto moc a slávu těchto království, neboť byla předána mně a já ji dávám, komu chci. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pokloníš-li se tedy přede mnou, bude všechno tvoje.” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ježíš mu však odpověděl: “Odejdi ode mě, Satane! Vždyť je napsáno: ‘Pánu, svému Bohu, se budeš klanět a jemu jedinému budeš sloužit.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tehdy ho přivedl do Jeruzaléma, postavil ho na vrcholek chrámu a řekl mu: “Jsi-li Boží Syn, vrhni se odsud dolů. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Vždyť je napsáno: ‘Svým andělům přikáže o tobě, aby tě ochránili, ");
INSERT INTO cesnkb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","a ponesou tě na rukou, abys snad nenarazil nohou na kámen.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ježíš mu odpověděl: “Je řečeno: ‘Nebudeš pokoušet Pána, svého Boha.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","A když ďábel vykonal všechno pokušení, odešel od něho až do určeného času. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ježíš se pak vrátil v moci Ducha do Galileje a zpráva o něm se roznesla po celém okolí. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A on učil v jejich synagogách a byl všemi chválen. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A tak přišel do Nazaretu, kde byl vychován, a podle svého zvyku vstoupil v sobotní den do synagogy a povstal, aby četl. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Byla mu tedy podána kniha proroka Izaiáše, a když knihu otevřel, nalezl místo, kde bylo napsáno: ");
INSERT INTO cesnkb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Duch Pánův je nade mnou, protože mne pomazal kázat evangelium chudým. Poslal mne uzdravit lidi zdrcené v srdci, kázat propuštění zajatým a prohlédnutí slepým, propustit zdeptané na svobodu ");
INSERT INTO cesnkb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","a kázat Pánovo milostivé léto.” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Potom knihu zavřel, vrátil ji služebníku a posadil se. Oči všech v synagoze byly upřeny na něj. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tehdy k nim začal mluvit: “Dnes se toto Písmo naplnilo ve vašich uších.” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Všichni mu tedy přisvědčovali a divili se slovům milosti vycházejícím z jeho úst a říkali: “Není to snad Josefův syn?” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tehdy jim řekl: “Jistě mi řeknete toto podobenství: ‘Lékaři, uzdrav se sám! To, co jsme slyšeli, že se stalo v Kafarnaum, udělej i zde, ve své vlasti.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Potom řekl: “Amen, říkám vám, že žádný prorok není ve své vlasti vítaný. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A řeknu vám po pravdě, že za Eliášových dnů, když bylo nebe zavřené po tři roky a šest měsíců a když byl veliký hlad po celé zemi, bylo mnoho vdov v Izraeli, ");
INSERT INTO cesnkb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","avšak Eliáš nebyl poslán k žádné z nich - jenom k jedné vdově do sidonské Sarepty. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","A za proroka Elizea bylo mnoho malomocných v Izraeli, avšak žádný z nich nebyl očištěn - jen syrský Náman.” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A když to slyšeli, byli všichni v synagoze naplněni hněvem. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Povstali, vyhnali ho ven z města a dovedli ho až na okraj hory, na níž bylo jejich město postaveno, aby ho shodili dolů. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","On ale prošel jejich středem a šel dál. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tehdy sestoupil do galilejského města Kafarnaum a v sobotu je učil. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A tam žasli nad jeho učením, protože jeho slovo mělo moc. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","V té synagoze byl člověk, který měl ducha nečistého démona, a ten hlasitě vykřikl: ");
INSERT INTO cesnkb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ach, co je ti do nás, Ježíši Nazaretský? Přišel jsi nás zničit? Znám tě, kdo jsi - ten Svatý Boží!” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ježíš mu pohrozil a řekl: “Zmlkni a vyjdi z něj!” A ten démon ho vrhl doprostřed, vyšel z něho a vůbec mu neublížil. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na všechny tedy přišel úžas a začali spolu rozmlouvat. Říkali: “Co je to za slovo, že v moci a síle přikazuje nečistým duchům a oni vycházejí?” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A zpráva o něm se šířila po každém místě v okolí. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Potom vstal, odešel ze synagogy a vešel do Šimonova domu. Šimonova tchyně byla sužována vysokou horečkou, a tak ho za ni poprosili. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Postavil se tedy nad ni, pohrozil té horečce a ta ji opustila. A ona ihned vstala a začala je obsluhovat. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Při západu slunce pak všichni, kteří měli nemocné různými neduhy, je k němu přiváděli a on na každého z nich vkládal ruce a uzdravoval je. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Z mnohých také vycházeli démoni, kteří křičeli a říkali: “Ty jsi Kristus, ten Boží Syn!” On jim však hrozil a nedovoloval jim mluvit, neboť věděli, že on je Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Když pak nastal den, Ježíš se odtud vydal na pusté místo. Zástupy ho hledaly, a když přišly k němu, zadržovaly ho, aby od nich neodcházel. ");
INSERT INTO cesnkb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ale on jim řekl: “Musím ohlašovat Boží království také jiným městům; neboť k tomu jsem poslán.” ");
INSERT INTO cesnkb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kázal tedy v galilejských synagogách. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Když se pak na něj tlačil zástup lidí, aby slyšeli Boží slovo, a on stál u Genezaretského jezera, stalo se, ");
INSERT INTO cesnkb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","že uviděl u břehu jezera stát dvě lodi, z nichž vystoupili rybáři a prali sítě. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nastoupil tedy do jedné z těch lodí, která byla Šimonova, a poprosil ho, aby maličko poodjel od břehu. Potom se posadil a učil zástupy z lodi. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A když přestal mluvit, řekl Šimonovi: “Jeď na hlubinu a spusťte své sítě k lovu.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Šimon mu však odpověděl: “Mistře, pracovali jsme celou noc a nic jsme nechytili. Ale na tvé slovo síť spustím.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","A když to udělali, nabrali tak veliké množství ryb, že se jejich síť začala trhat. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dali tedy znamení svým druhům, kteří byli na jiné lodi, aby přišli a pomohli jim. A když přišli, naplnili obě lodi tak, že se ponořovaly. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","A když to Šimon Petr uviděl, padl k Ježíšovým kolenům a řekl: “Odejdi ode mě, Pane, vždyť jsem hříšný člověk!” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jeho i všech, kdo byli s ním, se totiž zmocnil úžas nad tím úlovkem ryb, které chytili; ");
INSERT INTO cesnkb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","stejně tak i Jakuba a Jana, Zebedeových synů, kteří byli Šimonovými společníky. Ježíš však Šimonovi řekl: “Neboj se. Od nynějška budeš lovit lidi.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A když přivezli lodi ke břehu, všechno opustili a šli za ním. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Když pak byl v jednom městě, hle, stalo se, že tam byl muž plný malomocenství. Když uviděl Ježíše, padl na tvář a poprosil ho: “Pane, kdybys jen chtěl, můžeš mě očistit.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ježíš vztáhl ruku, dotkl se ho a řekl: “Chci, buď očištěn!” a malomocenství od něj ihned odešlo. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Přikázal mu pak, aby to nikomu neříkal: “Jdi ale, ukaž se knězi a obětuj za své očištění, jak přikázal Mojžíš, na svědectví pro ně.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Řeč o něm se však šířila stále více a lidé se scházeli ve velikých zástupech, aby ho slyšeli a byli od něj uzdravováni ze svých nemocí. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","On pak odcházel do pustin a modlil se. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A jednoho dne se stalo, že učil a seděli tam farizeové a učitelé Zákona, kteří se sešli ze všech galilejských i judských vesnic i z Jeruzaléma, a Pánova moc byla přítomna k jejich uzdravení. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A hle, muži nesli na lůžku ochrnutého člověka a snažili se ho přinést dovnitř a položit před něj. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","A když kvůli zástupu nenašli, kudy by ho tam vnesli, vylezli na střechu a otvorem mezi taškami ho spustili i s lůžkem doprostřed před Ježíše, ");
INSERT INTO cesnkb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","který když uviděl jejich víru, mu řekl: “Člověče, tvé hříchy ti jsou odpuštěny.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Zákoníci a farizeové však začali uvažovat a říkali si: “Kdo to je, že mluví tak rouhavě? Kdo kromě samotného Boha může odpustit hříchy?” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ježíš však poznal jejich myšlenky a odpověděl jim: “Proč ve svých srdcích takto uvažujete? ");
INSERT INTO cesnkb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Co je snadnější? Říci: Tvé hříchy ti jsou odpuštěny, anebo říci: Vstaň a choď? ");
INSERT INTO cesnkb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ale abyste věděli, že Syn člověka má na zemi moc odpouštět hříchy” - tehdy pověděl ochrnutému - “říkám ti, vstaň, vezmi své lůžko a jdi domů.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A on hned před nimi vstal, vzal to, na čem ležel, odešel domů a cestou oslavoval Boha. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Všech se tedy zmocnil úžas a oslavovali Boha. Byli naplněni bázní a říkali: “Dnes jsme viděli nepochopitelné věci!” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Potom vyšel a spatřil celníka jménem Lévi, jak sedí na celnici. Řekl mu: “Pojď za mnou.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A on všechno opustil, vstal a šel za ním. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lévi mu pak ve svém domě udělal velikou hostinu a byl tam veliký zástup celníků i jiných, kdo s nimi stolovali. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ale jejich zákoníci a farizeové reptali a říkali jeho učedníkům: “Proč jíte a pijete s celníky a hříšníky?” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ježíš jim však odpověděl: “Lékaře nepotřebují zdraví, ale nemocní. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nepřišel jsem volat spravedlivé, ale hříšné k pokání.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A oni mu řekli: “Proč se Janovi učedníci často postí a modlí, podobně i učedníci farizeů, ale tvoji jedí a pijí?” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","On jim tedy řekl: “Můžete snad nutit ženichovy přátele, aby se postili, dokud je ženich s nimi? ");
INSERT INTO cesnkb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Přijdou však dny, kdy od nich bude ženich vzat, a tehdy, v těch dnech, se budou postit.” ");
INSERT INTO cesnkb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Řekl jim pak také toto podobenství: “Nikdo nepřišívá záplatu z nového pláště na starý; jinak by totiž trhal ten nový a ke starému se záplata z nového nehodí. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nikdo také nelije nové víno do starých nádob; jinak totiž nové víno roztrhne ty nádoby a samo vyteče a nádoby se zničí. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nové víno se přece má lít do nových nádob a tak se obojí zachová. ");
INSERT INTO cesnkb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A nikdo, kdo pil staré, nechce hned nové, neboť říká: ‘Staré je lepší.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Druhou sobotu se pak stalo, že procházel obilím a jeho učedníci trhali klasy, rukama je mnuli a jedli. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tehdy jim někteří z farizeů řekli: “Proč děláte, co se v sobotu dělat nesmí?” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ježíš jim odpověděl: “Copak jste nečetli, co udělal David, když on i ti, kdo byli s ním, měli hlad? ");
INSERT INTO cesnkb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jak vešel do Božího domu a vzal posvátné chleby předložení, které nesmí jíst nikdo kromě samotných kněží, a jedl a dal i těm, kdo byli s ním?” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Řekl jim tedy: “Syn člověka je Pánem i nad sobotou.” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","V jinou sobotu se pak stalo, že vešel do synagogy a učil. A byl tu člověk, jehož pravá ruka byla uschlá. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Zákoníci a farizeové ho tedy sledovali, zda bude v sobotu uzdravovat, aby na něj našli nějakou žalobu. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","On ale znal jejich myšlenky, a tak řekl tomu člověku s uschlou rukou: “Vstaň a postav se doprostřed.” A on vstal a postavil se tam. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tehdy jim Ježíš řekl: “Zeptám se vás na jednu věc: Smí se v sobotu konat dobro, nebo zlo? Zachránit život, nebo ho zničit?” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A když se po nich po všech rozhlédl, řekl tomu člověku: “Natáhni tu ruku.” A on to udělal a byla znovu zdravá jako ta druhá. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Oni však byli naplněni zuřivostí a začali se spolu domlouvat, co by Ježíši udělali. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","V těch dnech se stalo, že vystoupil na horu, aby se modlil, a strávil celou noc v modlitbě k Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Když pak nastal den, zavolal své učedníky, vyvolil z nich dvanáct a nazval je apoštoly: ");
INSERT INTO cesnkb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Šimona (kterému dal také jméno Petr) a jeho bratra Ondřeje, Jakuba a Jana, Filipa a Bartoloměje, ");
INSERT INTO cesnkb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matouše a Tomáše, Jakuba Alfeova a Šimona, zvaného Zélótes, ");
INSERT INTO cesnkb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judu Jakubova a Jidáše Iškariotského, který se potom stal zrádcem. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A když s nimi sestoupil, stanul na rovině, kde byl zástup jeho učedníků a veliké množství lidí z celého Judska i z Jeruzaléma a z přímořského Týru a Sidonu. Ti přišli, aby ho slyšeli a aby byli uzdraveni ze svých neduhů, ");
INSERT INTO cesnkb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","i ti, kteří byli trápeni nečistými duchy. A byli uzdravováni. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A všechen zástup se ho snažil dotknout, neboť z něj vycházela moc a uzdravovala všechny. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tehdy pozvedl oči na své učedníky a řekl: “Blaze vám chudým, neboť vám patří Boží království. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blaze vám, kteří teď hladovíte, neboť budete nasyceni. Blaze vám, kteří teď pláčete, neboť se budete smát. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blaze vám, když vás budou lidé nenávidět a když vás vyobcují a potupí a vaše jméno zavrhnou jako zlé kvůli Synu člověka. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Radujte a veselte se v ten den, neboť hle, vaše odplata v nebi je veliká. Totéž přece dělali jejich otcové prorokům. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ale běda vám bohatým, neboť vy už máte své potěšení. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Běda vám, kteří jste nasyceni, neboť budete hladovět. Běda vám, kteří se teď smějete, neboť budete truchlit a plakat. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Běda vám, kdyby o vás dobře mluvili všichni lidé. Totéž přece dělali jejich otcové falešným prorokům.” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ale vám, kteří slyšíte, říkám: Milujte své nepřátele! Konejte dobro těm, kdo vás nenávidí, ");
INSERT INTO cesnkb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","žehnejte těm, kdo vás proklínají, a modlete se za ty, kdo vás pomlouvají. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tomu, kdo tě bije do tváře, nastav také druhou a tomu, kdo ti bere plášť, nebraň vzít i košili. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Každému, kdo tě prosí, dávej a od toho, kdo si bere tvé věci, je nevyžaduj zpět. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A jak chcete, aby se lidé chovali k vám, stejně tak se chovejte i vy k nim. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Když totiž milujete ty, kdo milují vás, jaká je to zásluha? Vždyť i hříšníci milují ty, kteří milují je. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A kdybyste se chovali dobře k těm, kteří se chovají dobře k vám, jaká je to zásluha? Vždyť i hříšníci dělají totéž. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A kdybyste půjčovali těm, od kterých máte naději to zase dostat, jaká je to zásluha? Vždyť i hříšníci půjčují hříšníkům, aby totéž zase dostali. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Vy však milujte své nepřátele a konejte dobro; půjčujte a neočekávejte nic nazpět. Tehdy bude vaše odplata veliká a budete synové Nejvyššího, neboť on je laskavý i k nevděčným a zlým. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Buďte tedy milosrdní, jako je milosrdný i váš Otec.” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nesuďte a nebudete souzeni. Neodsuzujte a nebudete odsouzeni. Odpouštějte a bude vám odpuštěno. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dávejte a bude vám dáno. Míru dobrou, natlačenou, natřesenou a přetékající dají do vašeho klína. Jakou mírou totiž měříte, takovou vám bude zase odměřeno.” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Potom jim řekl toto podobenství: “Může snad slepý vést slepého? Nespadnou pak oba do jámy? ");
INSERT INTO cesnkb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Není učedník nad svého mistra, ale každý, kdo je dokonale vyučen, bude jako jeho mistr. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Proč tedy vidíš třísku v oku svého bratra, ale trámu ve vlastním oku si nevšímáš? ");
INSERT INTO cesnkb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A jak můžeš říci svému bratru: ‘Bratře, nech mě, ať ti vytáhnu z oka třísku,’ když sám nevidíš trám ve svém oku? Pokrytče, vytáhni nejdříve trám ze svého oka a tehdy prohlédneš, abys vytáhl třísku, která je v oku tvého bratra.” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Není totiž dobrý strom, který nese špatné ovoce, ani špatný strom, který nese dobré ovoce. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Každý strom se přece pozná po svém vlastním ovoci: z trní se nesbírají fíky a z bodláčí se nesklízejí hrozny. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dobrý člověk vynáší z dobrého pokladu svého srdce to dobré a zlý člověk vynáší ze zlého pokladu svého srdce to zlé. Jeho ústa totiž mluví z hojnosti srdce.” ");
INSERT INTO cesnkb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Proč mi však říkáte: ‘Pane, Pane,’ a neděláte, co říkám? ");
INSERT INTO cesnkb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ukážu vám, komu je podobný každý, kdo přichází ke mně, slyší mé slovo a plní je: ");
INSERT INTO cesnkb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Je podobný člověku, který stavěl svůj dům tak, že kopal hluboko a položil základy na skále. Když pak přišla povodeň, přivalila se na ten dům řeka, ale nemohla jím otřást, neboť byl založen na skále. ");
INSERT INTO cesnkb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ale ten, kdo je slyšel a nenaplnil, je podobný člověku, který postavil dům na zemi bez základů. Přivalila se na něj řeka a hned spadl a pád toho domu byl veliký.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Když pak dokončil všechna tato slova k naslouchajícímu lidu, vešel do Kafarnaum. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A jeden setník měl na smrt nemocného služebníka, kterého si velmi cenil. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Když tedy uslyšel o Ježíši, poslal k němu židovské starší a prosil ho, aby přišel a uzdravil jeho služebníka. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Přišli tedy k Ježíši a snažně ho prosili slovy: “Je hoden, abys to pro něj udělal. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Vždyť miluje náš národ, i synagogu nám postavil.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ježíš tedy šel s nimi. A když už byl nedaleko od domu, poslal k němu ten setník přátele, aby mu řekli: “Pane, neobtěžuj se, neboť nejsem hoden, abys vešel pod mou střechu. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Proto jsem se ani nepokládal za hodného, abych k tobě přišel. Ale řekni slovo a můj služebník bude uzdraven. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Vždyť i já jsem člověk postavený pod moc a mám pod sebou vojáky. Tomuto řeknu ‘Jdi’ a on jde a jinému ‘Přijď’ a on přijde; svému otroku řeknu ‘Udělej tohle’ a udělá to.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Když to Ježíš uslyšel, podivil se nad ním, obrátil se a řekl zástupu, který šel za ním: “Říkám vám, že ani v Izraeli jsem tak velikou víru nenašel.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A když se ti, kdo byli posláni, vrátili domů, našli toho služebníka, který byl nemocný, zdravého. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Potom se stalo, že šel do města jménem Naim; a šlo s ním mnoho jeho učedníků a veliký zástup lidí. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A když se přiblížil k městské bráně, hle, vynášeli mrtvého; byl to jediný syn své matky, a ta byla vdova. A byl s ní veliký zástup lidí z města. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Když ji Pán spatřil, byl pohnut soucitem k ní a řekl jí: “Neplač.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Přistoupil a dotkl se már a ti, kdo je nesli, se zastavili. Tehdy řekl: “Mladíku, říkám ti, vstaň!” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A ten mrtvý se posadil a začal mluvit. Ježíš ho tedy předal jeho matce ");
INSERT INTO cesnkb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","a všech se zmocnila bázeň a oslavovali Boha se slovy: “Povstal mezi námi veliký prorok” a “Bůh navštívil svůj lid.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A tato zpráva o něm vyšla do celého Judska a do celého okolí. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tehdy Janovi oznámili jeho učedníci o všech těchto věcech. Jan tedy zavolal kterési dva ze svých učedníků ");
INSERT INTO cesnkb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a poslal je k Ježíši se slovy: “Jsi ty Ten, který má přijít, nebo máme čekat jiného?” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Když tedy k němu ti muži přišli, řekli: “Jan Křtitel nás k tobě poslal se slovy: Jsi ty Ten, který má přijít, nebo máme čekat jiného?” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","(A právě v tu chvíli uzdravil mnoho lidí od neduhů a trápení a zlých duchů a mnoha slepým daroval zrak.) ");
INSERT INTO cesnkb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ježíš jim tedy odpověděl: “Jděte a oznamte Janovi, co jste viděli a slyšeli: slepí vidí, chromí chodí, malomocní jsou očišťováni, hluší slyší, mrtví jsou kříšeni a chudým se káže evangelium. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A blaze tomu, kdo se nade mnou nepohoršuje.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Když pak Janovi poslové odešli, začal zástupům říkat o Janovi: “Co jste si přišli do pouště prohlédnout? Třtinu klátící se větrem? ");
INSERT INTO cesnkb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na co jste se tedy vyšli podívat? Na člověka oblečeného hebkým rouchem? Pohleďte, ti, kteří jsou v slavném rouchu a žijí v rozkoši, jsou v královských domech. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Co jste tedy vyšli vidět? Proroka? Ano, říkám vám, a více než proroka. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Toto je ten, o kterém je napsáno: ‘Hle, já před tvou tváří posílám svého posla, který připraví tvou cestu před tebou.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Říkám vám totiž, že mezi těmi, kdo se narodili z žen, není větší prorok než Jan Křtitel, ale kdo je nejmenší v Božím království, je větší než on.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A všechen lid, který to slyšel, i celníci, uznali Boží spravedlnost, když se nechali pokřtít Janovým křtem. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ale farizeové a zákoníci odmítli Boží vůli pro sebe, když se od něj pokřtít nenechali. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A Pán řekl: “Ke komu tedy přirovnám lidi tohoto pokolení a čemu se podobají? ");
INSERT INTO cesnkb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jsou podobní dětem, které sedí na tržišti a volají jedny na druhé: ‘Pískali jsme vám a netančili jste; žalostně jsme naříkali a neplakali jste!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jan Křtitel totiž přišel, nejedl chléb a nepil víno a vy říkáte: ‘Má démona!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Přišel Syn člověka, jí a pije a vy říkáte: ‘Hle, žrout a pijan vína, přítel celníků a hříšníků!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ale moudrost je ospravedlněna všemi svými dětmi.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jeden z farizeů ho pak prosil, aby s ním pojedl. Vešel tedy do domu toho farizea a stoloval s ním. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A hle, když se jedna žena, hříšnice z toho města, dozvěděla, že Ježíš stoluje v domě toho farizea, přinesla alabastrovou nádobku s mastí. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A stojíc s pláčem zezadu u jeho nohou, začala mu skrápět nohy slzami a vlasy své hlavy je utírala a líbala mu nohy a mazala je mastí. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Když to ale spatřil ten farizeus, který ho pozval, řekl si: “Kdyby tohle byl prorok, věděl by, co je to za ženu, která se ho dotýká, a jaká je, protože je hříšnice.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ježíš mu odpověděl: “Šimone, musím ti něco povědět.” A on řekl: “Pověz, mistře.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Jistý věřitel měl dva dlužníky. Jeden dlužil pět set denárů a druhý padesát. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A když neměli čím zaplatit, oběma odpustil. Pověz tedy, který z nich ho bude více milovat?” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Šimon odpověděl: “Mám za to, že ten, kterému více odpustil.” On mu řekl: “Správně jsi usoudil.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Obrátil se k té ženě a řekl Šimonovi: “Vidíš tuto ženu? Vešel jsem do tvého domu; ty jsi mi nepodal vodu na nohy, ale ona skrápěla mé nohy slzami a vlasy své hlavy je utřela. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nepolíbil jsi mne, ale ona od chvíle, kdy jsem vešel, nepřestala líbat mé nohy. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nepomazal jsi mi hlavu olejem, ale ona pomazala mastí mé nohy. ");
INSERT INTO cesnkb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Proto ti říkám: Je jí odpuštěno hodně hříchů, neboť hodně milovala. Komu se ale odpouští málo, ten miluje málo.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A řekl jí: “Tvé hříchy jsou odpuštěny.” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tehdy si ti, kdo s ním stolovali, začali mezi sebou říkat: “Kdo to je, že i hříchy odpouští?” ");
INSERT INTO cesnkb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","On však té ženě řekl: “Tvá víra tě zachránila. Jdi v pokoji.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Potom se stalo, že procházel jednotlivá města a vesnice. Kázal a ohlašoval Boží království a dvanáct apoštolů s ním; ");
INSERT INTO cesnkb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","také některé ženy, které byly uzdraveny od zlých duchů a nemocí: Marie zvaná Magdaléna, z níž vyšlo sedm démonů, ");
INSERT INTO cesnkb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Johana, manželka Herodova úředníka Chuzy, a Zuzana a mnoho jiných, které mu sloužily ze svého majetku. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Když se pak začal scházet veliký zástup a lidé se k němu hrnuli z města za městem, promluvil k nim v podobenství: ");
INSERT INTO cesnkb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Vyšel rozsévač, aby rozsíval své zrno. A jak rozsíval, jedno padlo podél cesty a bylo pošlapáno a nebeští ptáci je sezobali. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jiné padlo na skálu, a když vzešlo, uschlo, protože nemělo vláhu. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jiné zase padlo mezi trní a to trní vyrostlo s ním a udusilo je. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jiné však padlo do dobré země, a když vzešlo, přineslo stonásobnou úrodu.” Když to řekl, volal: “Kdo má uši k slyšení, ať slyší!” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jeho učedníci se ho tedy ptali: “Co je to za podobenství?” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","On řekl: “Vám je dáno poznat tajemství Božího království, ale ostatním jen v podobenstvích, aby ‘hledíce neviděli a slyšíce nerozuměli’.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“To podobenství tedy znamená: Zrno je Boží slovo ");
INSERT INTO cesnkb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","a ti podél cesty jsou ti, kteří slyší, ale potom přichází ďábel a bere to slovo z jejich srdce, aby neuvěřili a nebyli spaseni. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ti na skále jsou ti, kteří když slyší slovo, s radostí je přijímají, ale nemají kořeny. Ti věří na čas, ale v době pokušení odpadají. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","To, které padlo mezi trní, jsou pak ti, kteří slyšeli, ale jak jdou za starostmi a bohatstvím a rozkošemi tohoto života, bývají udušeni a nepřinášejí užitek. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ale to v dobré zemi jsou ti, kteří když slyší slovo, udržují je v ušlechtilém a dobrém srdci a vytrvale přinášejí užitek.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nikdo, když rozsvítí lampu, nepřikrývá ji nádobou a nestaví ji pod postel, ale staví ji na stojan, aby ti, kteří vcházejí, viděli světlo. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Není totiž nic tajného, co nebude zjeveno, ani nic skrytého, co nebude poznáno a nevyjde najevo. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Proto dávejte pozor na to, jak posloucháte. Tomu, kdo má, totiž bude dáno, ale tomu, kdo nemá, bude vzato i to, co si myslí, že má.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tehdy za ním přišla jeho matka a bratři, ale kvůli zástupu se k němu nemohli dostat. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oznámili mu tedy: “Tvá matka a tvoji bratři stojí venku a chtějí tě vidět.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","On jim však odpověděl: “Má matka a moji bratři jsou ti, kdo slyší Boží slovo a plní je.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jednoho z těch dnů se pak stalo, že nastoupil se svými učedníky na loď a řekl jim: “Přeplavme se přes jezero.” A tak vypluli. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","A když se plavili, usnul. Tehdy se na jezero snesla větrná bouře a loď se naplňovala, takže byli v nebezpečí. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Přistoupili tedy a vzbudili ho se slovy: “Mistře, mistře, hyneme!” On však vstal, napomenul vítr a vzedmutí vod, a tak přestaly a nastal klid. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tehdy jim řekl: “Kde je vaše víra?” A oni se strachem a úžasem říkali jeden druhému: “Kdo to tedy je, že přikazuje i větru a vodám a poslouchají ho?” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tehdy se přeplavili do kraje Gadarenců, který je naproti Galileji. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","A když vystoupil na zem, setkal se s ním jeden muž z toho města, který měl už dlouhou dobu démony. Nenosil žádné šaty ani nebydlel v domě, ale v hrobkách. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Když pak spatřil Ježíše, vykřikl, padl před ním a hlasitě zvolal: “Co je ti do mě, Ježíši, Synu Nejvyššího Boha? Prosím tě, abys mě netrýznil!” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Ježíš totiž přikazoval tomu nečistému duchu, aby z toho člověka vyšel. Mnohokrát se ho totiž zmocňoval, takže musel být spoutáván řetězy a hlídán v okovech, ale on ta pouta trhal a býval démonem hnán na poušť.) ");
INSERT INTO cesnkb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ježíš se ho tedy zeptal: “Jak se jmenuješ?” a on řekl: “Legie,” neboť do něj vstoupilo mnoho démonů. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A ti ho prosili, aby jim nepřikazoval odejít do propasti. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tehdy tam bylo veliké stádo vepřů pasoucích se na hoře, a tak ho prosili, aby jim dovolil vejít do nich. A on jim to dovolil. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Démoni tedy vyšli z toho člověka a vstoupili do vepřů a to stádo se rozběhlo ze srázu do jezera a utopilo se. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Když pak ti, kdo je pásli, uviděli, co se stalo, utekli a cestou to vyprávěli ve městě i na venkově. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lidé tedy vyšli, aby viděli, co se stalo. Když přišli k Ježíši a nalezli toho člověka, ze kterého vyšli démoni, jak sedí u Ježíšových nohou oblečen a při zdravém rozumu, dostali strach. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ti, kteří to viděli, jim pak vyprávěli, jak byl ten, který měl démony, zachráněn. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Všichni ti lidé z gadarenského kraje ho tedy prosili, aby od nich odešel, neboť byli sevřeni velikým strachem. Nastoupil tedy do lodi a vrátil se zpět. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ten muž, ze kterého vyšli démoni, ho ale prosil, aby mohl být s ním. Ježíš ho však propustil se slovy: ");
INSERT INTO cesnkb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Vrať se domů a vypravuj, jak veliké věci pro tebe udělal Bůh.” On tedy odešel a rozhlašoval po celém městě, jak veliké věci pro něj Ježíš udělal. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Když se pak Ježíš vrátil, stalo se, že ho přivítal zástup lidí, neboť ho všichni očekávali. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A vtom přišel muž jménem Jairus a ten byl představený synagogy. Padl Ježíši k nohám a prosil ho, aby vešel do jeho domu, ");
INSERT INTO cesnkb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","neboť měl jedinou dceru, asi dvanáctiletou, a ta umírala. A tak šel a tiskly ho davy. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A jedna žena, která už dvanáct let trpěla krvácením a vynaložila všechno své živobytí na lékaře a žádný ji nemohl uzdravit, ");
INSERT INTO cesnkb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","přistoupila zezadu, dotkla se cípu jeho roucha a její krvácení ihned přestalo. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ježíš tedy řekl: “Kdo se mě dotkl?” A když to všichni popírali, řekl Petr a ti, kdo byli s ním: “Mistře, davy se na tebe tisknou a tlačí a ty říkáš: ‘Kdo se mě dotkl?’” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ježíš ale řekl: “Někdo se mě dotkl, neboť jsem poznal, že ze mě vyšla moc.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A když ta žena poznala, že se neutajila, s rozechvěním přistoupila, padla před ním na zem a přede všemi lidmi mu pověděla, proč se ho dotkla a jak byla hned uzdravena. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A on jí řekl: “Buď dobré mysli, dcero, tvá víra tě uzdravila. Jdi v pokoji.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A když ještě mluvil, přišel někdo z domu představeného synagogy se slovy: “Tvá dcera umřela. Neobtěžuj mistra.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Když to však Ježíš uslyšel, odpověděl mu: “Neboj se, jenom věř a bude zachráněna.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Když pak vešel do toho domu, nenechal se sebou vejít nikoho kromě Petra, Jakuba a Jana a otce a matky té dívky. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Všichni nad ní plakali a kvíleli, ale on řekl: “Neplačte. Neumřela, ale spí.” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A tak se mu vysmívali, neboť věděli, že umřela. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ale on všechny vyhnal, vzal ji za ruku a zvolal: “Dívenko, vstaň!” ");
INSERT INTO cesnkb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tehdy se její duch navrátil a ona hned vstala. Nařídil tedy, ať jí dají najíst. ");
INSERT INTO cesnkb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A její rodiče užasli. On jim však přikázal, aby nikomu neříkali, co se stalo. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tehdy svolal svých dvanáct učedníků, dal jim sílu a moc nad všemi démony, a aby uzdravovali nemoci, ");
INSERT INTO cesnkb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","a poslal je, aby kázali Boží království a uzdravovali nemocné. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Řekl jim také: “Nic si na tu cestu neberte: ani hůl, ani mošnu, ani chléb, ani stříbro, ani nemívejte po dvou košilích. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Do kteréhokoli domu vejdete, tam zůstaňte a odtud vycházejte. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A kdekoli by vás nepřijali, vyjděte z toho města a setřeste i prach ze svých nohou na svědectví proti nim.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A tak vyšli a chodili po okolních vesnicích. Kázali evangelium a všude uzdravovali. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tehdy o všech věcech, které se skrze něj dály, uslyšel tetrarcha Herodes a byl bezradný, protože někteří říkali, že Jan vstal z mrtvých, ");
INSERT INTO cesnkb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","někteří zase, že se zjevil Eliáš, a jiní, že vstal jeden z dávných proroků. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes tedy řekl: “Jana jsem sťal. Ale kdo je tento, o kterém slyším takové věci?” A toužil ho vidět. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Potom se apoštolové vrátili a vyprávěli mu, co všechno udělali. Tehdy je vzal s sebou a odešel do ústraní na pusté místo u města zvaného Betsaida. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ale když se to zástupy dozvěděly, šly za ním. A on je přijal a mluvil k nim o Božím království a ty, kdo potřebovali uzdravení, uzdravoval. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Den se však začal chýlit k večeru. Dvanáct učedníků tedy přistoupilo a řekli mu: “Propusť ten zástup, ať se rozejdou do okolních vesnic a statků, přenocují tam a najdou si stravu, protože zde jsme na pustém místě.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","On jim však řekl: “Vy jim dejte najíst.” Ale oni řekli: “Nemáme víc než pět chlebů a dvě ryby. Ledaže bychom snad šli a nakoupili jídlo pro všechen tento lid.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Bylo tam totiž kolem pěti tisíc mužů.) Řekl tedy svým učedníkům: “Posaďte je ve skupinách po padesáti.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A tak to udělali a všechny posadili. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tehdy vzal těch pět chlebů a dvě ryby, vzhlédl k nebi, požehnal je, nalámal a dával svým učedníkům, aby je předkládali zástupu. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","A tak se všichni najedli a byli nasyceni. Potom se sebralo dvanáct košů nalámaných kousků, které jim zbyly. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Když se pak o samotě modlil a učedníci byli s ním, stalo se, že se jich zeptal: “Za koho mne mají zástupy?” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Oni odpověděli: “Někteří za Jana Křtitele, jiní za Eliáše a jiní říkají, že vstal jeden z dávných proroků.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ale on jim řekl: “A za koho mne máte vy?” A Petr mu odpověděl: “Za Božího Krista!” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","On je tedy přísně napomenul, aby to nikomu neříkali, ");
INSERT INTO cesnkb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","a řekl: “Syn člověka musí mnoho vytrpět a být zavržen staršími, velekněžími i zákoníky, být zabit a třetího dne vstát z mrtvých.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Potom jim všem říkal: “Chce-li někdo přijít za mnou, ať se zřekne sám sebe a bere svůj kříž každý den a následuje mne. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kdokoli by si totiž chtěl zachránit duši, ztratí ji, ale kdokoli by ztratil svou duši pro mne, ten ji zachrání. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Vždyť co je platno člověku, kdyby získal celý svět, ale sám sebe ztratil nebo sám sobě uškodil? ");
INSERT INTO cesnkb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kdokoli by se totiž styděl za mne a za má slova, za toho se bude stydět Syn člověka, až přijde ve své slávě a ve slávě Otce a svatých andělů. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ale říkám vám po pravdě: Jsou někteří z těch, kdo tu stojí, kteří rozhodně nezakusí smrt, dokud nespatří Boží království.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Asi osm dní po těchto slovech se stalo, že k sobě vzal Petra, Jakuba a Jana a vystoupil na horu, aby se modlil. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","A když se modlil, změnil se vzhled jeho tváře a jeho oděv zbělel a rozzářil se. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A hle, mluvili s ním dva muži. Byli to Mojžíš a Eliáš, ");
INSERT INTO cesnkb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kteří se ukázali ve slávě a mluvili o jeho odchodu, který se měl naplnit v Jeruzalémě. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ale Petr a ti, kteří byli s ním, byli obtěžkáni spánkem. Když se však probudili, uviděli jeho slávu a ty dva muže, jak stojí s ním. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A když se od něho vzdalovali, stalo se, že Petr řekl Ježíši: “Mistře, to je dobře, že jsme zde. Udělejme tedy tři stánky - jeden tobě, jeden Mojžíšovi a jeden Eliášovi!” Ale nevěděl, co říká. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A zatímco to říkal, objevil se oblak a zastínil je. A když vcházeli do toho oblaku, dostali strach. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Z toho oblaku pak vyšel hlas, který řekl: “Toto je můj milovaný Syn. Toho poslouchejte.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A když ten hlas zazněl, zůstal tam jenom Ježíš. A oni mlčeli a v těch dnech nikomu neoznámili nic z toho, co viděli. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Když pak druhý den sestoupili z hory, stalo se, že se s ním setkal veliký zástup. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A hle, jeden muž ze zástupu zvolal: “Mistře, prosím tě, pohlédni na mého syna. Vždyť je to můj jediný! ");
INSERT INTO cesnkb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A hle, napadá ho duch a náhle křičí. Zmítá jím, takže sliní, a když ho trápí, těžko od něj odchází. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Poprosil jsem tedy tvé učedníky, aby toho ducha vyhnali, ale nemohli!” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ježíš však odpověděl: “nevěřící a zvrácené pokolení, jak dlouho budu s vámi a budu vás snášet? Přiveď svého syna sem.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A jak přicházel, ten démon ho porazil a začal jím zmítat. Ježíš tomu nečistému duchu pohrozil, uzdravil chlapce a vrátil ho jeho otci. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Všichni tedy žasli nad Boží velkolepostí. Když se ale všichni divili všemu, co Ježíš udělal, řekl svým učedníkům: ");
INSERT INTO cesnkb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Vy uložte tato slova do svých uší, neboť Syn člověka bude vydán do lidských rukou.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Oni však to slovo nechápali a bylo před nimi skryto, aby mu neporozuměli. A báli se ho na to slovo zeptat. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tehdy mezi nimi vyvstala otázka, kdo z nich je největší. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Když ale Ježíš viděl myšlení jejich srdce, vzal dítě, postavil je vedle sebe ");
INSERT INTO cesnkb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a řekl jim: “Kdokoli by přijal toto dítě v mém jménu, přijímá mne, a kdokoli by přijal mne, přijímá Toho, který mě poslal. Neboť kdo je mezi vámi všemi nejmenší, ten bude veliký.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jan tedy odpověděl: “Mistře, viděli jsme někoho, jak ve tvém jménu vymítá démony, a bránili jsme mu, protože nechodí s námi.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ale Ježíš mu řekl: “Nebraňte mu. Vždyť kdo není proti nám, je s námi.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Když se pak naplňovaly dny, aby byl vzat vzhůru, stalo se, že upřel svou tvář k cestě do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Poslal tedy před sebou posly a ti šli a vstoupili do samařské vesnice, aby pro něj vše připravili. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ale tam ho nepřijali, protože jeho tvář byla obrácena k cestě do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Když to tedy viděli jeho učedníci Jakub a Jan, řekli: “Pane, chceš, ať řekneme ohni, aby sestoupil z nebe a pohltil je, jako to udělal i Eliáš?” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ale on se obrátil a pokáral je slovy: “Vy nevíte, jakého jste ducha. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Neboť Syn člověka nepřišel lidské duše zahubit, ale spasit.” Šli tedy do jiné vesnice. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A když šli, stalo se, že mu někdo na cestě řekl: “Pane, budu tě následovat, kamkoli půjdeš.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ježíš mu tedy řekl: “Lišky mají doupata a nebeští ptáci hnízda, ale Syn člověka nemá, kde by složil hlavu.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tehdy řekl jinému: “Pojď za mnou.” Ale on řekl: “Pane, dovol mi nejdřív odejít a pochovat svého otce.” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ježíš mu však řekl: “Nech mrtvé, ať pochovávají své mrtvé, ale ty jdi a kaž Boží království!” ");
INSERT INTO cesnkb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A ještě jiný mu řekl: “Půjdu za tebou, Pane, ale nejdříve mi dovol, ať se rozloučím s těmi, kdo jsou v mém domě. ");
INSERT INTO cesnkb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ale Ježíš mu řekl: “Nikdo, kdo položí ruku na pluh a ohlíží se zpátky, není způsobilý pro Boží království.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Potom Pán určil i jiných sedmdesát a poslal je před svou tváří po dvou do každého města i místa, kam měl sám přijít. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Řekl jim tedy: “Žeň je jistě veliká, ale dělníků málo. Proto proste Pána žně, ať vypudí dělníky na svou žeň. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jděte. Hle, já vás posílám jako berany mezi vlky. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nenoste měšec, ani mošnu, ani obuv a s nikým se po cestě nezdravte. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Do kterékoli domácnosti vejdete, nejdříve řekněte: ‘Pokoj tomuto domu.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","A bude-li tam syn pokoje, váš pokoj spočine na něm; a pokud ne, navrátí se k vám. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","V tom domě zůstávejte a jezte a pijte, co mají, neboť dělník je hoden své mzdy. Nepřecházejte z domu do domu. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Když pak vejdete do kteréhokoli města a přijmou vás, jezte, co vám nabídnou. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A uzdravujte v tom městě nemocné a říkejte jim: ‘Boží království se přiblížilo k vám.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jestliže ale přijdete do nějakého města a nepřijmou vás, vyjděte na jeho ulice a řekněte: ");
INSERT INTO cesnkb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘I ten prach z vašeho města, který na nás ulpěl, vytřásáme na vás. Avšak to vězte, že se k vám přiblížilo Boží království.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A říkám vám, že v onen den bude lehčeji Sodomě než tomu městu.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Běda tobě, Korozaim, běda tobě, Betsaido! Vždyť kdyby se zázraky, které se dějí u vás, staly v Týru a Sidonu, dávno by seděli v pytlovině a popelu a činili pokání. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Týru a Sidonu však bude na soudu lehčeji než vám. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ty, Kafarnaum, které jsi až k nebi vyvýšeno, až do pekla budeš svrženo. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kdo slyší vás, slyší mne, a kdo vás odmítá, odmítá mne. Kdo pak odmítá mne, odmítá Toho, který mě poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Potom se s radostí vrátilo těch sedmdesát a říkali: “Pane, i démoni se nám poddávají ve tvém jménu!” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tehdy jim řekl: “Viděl jsem Satana spadnout z nebe jako blesk. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hle, dávám vám moc šlapat na hady a štíry i na veškerou sílu nepřítele a vůbec nic vám neublíží. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Neradujte se však z toho, že se vám poddávají duchové, ale spíše se radujte, že vaše jména jsou zapsána v nebesích.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","V tu chvíli se Ježíš rozveselil v Duchu a řekl: “Chválím tě, Otče, Pane nebe i země, že jsi tyto věci skryl před moudrými a rozumnými a zjevil jsi je nemluvňatům. Jistě, Otče, neboť tak se ti zalíbilo. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Všechno je mi dáno od mého Otce a nikdo neví, kdo je Syn, jedině Otec, a kdo je Otec, jedině Syn a ten, komu by ho Syn chtěl zjevit.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A když se obrátil k učedníkům, řekl jim samotným: “Blaze očím, které vidí, co vy vidíte. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Říkám vám totiž, že mnozí proroci a králové chtěli spatřit, co vy vidíte, ale neviděli, a slyšet, co slyšíte, ale neslyšeli.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A hle, jeden učený v Zákoně vstal a zkoušel ho slovy: “Mistře, co mám udělat, abych se stal dědicem věčného života?” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","On mu řekl: “Co je napsáno v Zákoně? Jak tam čteš?” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A on odpověděl: “Budeš milovat Pána, svého Boha, celým svým srdcem, celou svou duší, ze vší své síly a celou svou myslí a svého bližního jako sám sebe.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ježíš mu tedy řekl: “Správně jsi odpověděl. Dělej to a budeš žít.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ale on se chtěl sám ospravedlnit, a tak řekl Ježíši: “A kdo je můj bližní?” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ježíš mu odpověděl: “Jeden člověk šel z Jeruzaléma do Jericha a padl mezi lupiče. Ti ho oloupili a zranili, potom odešli a nechali ho polomrtvého. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A náhodou šel tou cestou jeden kněz, a když ho spatřil, přešel kolem po protější straně. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Podobně i levíta, když přišel na to místo a spatřil ho, přešel po protější straně. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Přišel k němu ale také jeden Samaritán, který tudy cestoval, a když ho spatřil, byl pohnut soucitem. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Přistoupil, obvázal jeho rány a nalil na ně olej a víno. Pak ho položil na své zvíře, dovezl ho do hostince a postaral se o něj. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Když pak druhý den odcházel, vytáhl dva denáry, dal je hostinskému a řekl mu: ‘Postarej se o něj, a cokoli bys vynaložil navíc, to ti zaplatím, až se vrátím.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kdo z těch tří se ti tedy zdá být bližním toho, který upadl mezi lupiče?” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A on řekl: “Ten, který mu prokázal milosrdenství.” Ježíš mu tedy řekl: “Jdi a jednej tak i ty.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","A když šli, stalo se, že vešel do jedné vesnice a jistá žena jménem Marta ho přijala do svého domu. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ta měla sestru jménem Marie, která si sedla u Ježíšových nohou a poslouchala jeho slova. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ale Marta byla zaneprázdněna množstvím služby. Ta přistoupila a řekla: “Pane, tebe nezajímá, že mě má sestra nechala sloužit samotnou? Proto jí řekni, ať mi pomůže.” ");
INSERT INTO cesnkb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ježíš jí tedy odpověděl: “Marto, Marto, staráš se a trápíš se mnoha věcmi. ");
INSERT INTO cesnkb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jen jedno je však potřeba. A Marie si vybrala dobrou část, která jí nebude odňata.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A stalo se, že se na jednom místě modlil, a když přestal, řekl mu jeden z jeho učedníků: “Pane, nauč nás modlit se, tak jako Jan vyučoval své učedníky.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Řekl jim tedy: “Když se modlíte, říkejte: Otče náš, který jsi v nebesích, ať se posvětí tvé jméno! Ať přijde tvé království! Ať se stane tvoje vůle jako v nebi, tak i na zemi. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Náš denní chléb nám dávej každý den. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A odpusť nám naše hříchy; neboť i my odpouštíme každému, kdo se proviňuje proti nám. A neuveď nás do pokušení, ale vysvoboď nás od zlého.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tehdy jim řekl: “Někdo z vás bude mít přítele, půjde k němu o půlnoci a řekne mu: ‘Příteli, půjče mi tři chleby, ");
INSERT INTO cesnkb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","protože ke mně přišel z cesty můj přítel a nemám, co bych mu nabídl.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A on mu zevnitř odpoví: ‘Neobtěžuj mě! Dveře jsou už zavřené a mé děti jsou se mnou v posteli. Nemohu vstát a dát ti to.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Říkám vám: i kdyby nevstal a nedal mu to, protože je jeho přítel, kvůli jeho neodbytnosti se přece zvedne a dá mu, cokoli potřebuje.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“A tak vám říkám: Proste a bude vám dáno, hledejte a naleznete, tlučte a bude vám otevřeno. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Neboť každý, kdo prosí, dostává a kdo hledá, nalézá a tomu, kdo tluče, bude otevřeno. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Který z vás, otců, podá svému synu kámen, když ho prosí o chléb? Anebo o rybu - podá mu snad místo ryby hada? ");
INSERT INTO cesnkb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Anebo když poprosí o vejce, podá mu snad štíra? ");
INSERT INTO cesnkb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jestliže tedy vy, kteří jste zlí, umíte dávat svým dětem dobré dary, čím více váš nebeský Otec dá Ducha Svatého těm, kdo ho prosí?” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A Ježíš vymítal démona a ten byl němý. Když pak démon vyšel, stalo se, že ten němý promluvil. A zástupy se divily. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Někteří z nich ale řekli: “Vymítá démony skrze Belzebula, knížete démonů.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jiní ho zase pokoušeli tím, že od něj chtěli znamení z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","On ale znal jejich myšlenky a řekl jim: “Každé království rozdělené samo proti sobě pustne a dům rozdělený proti domu padá. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Je-li tedy i Satan rozdělen sám proti sobě, jak jeho království obstojí? Říkáte přece, že vymítám démony skrze Belzebula. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A pokud já vymítám démony Belzebulem, kým je vymítají vaši synové? Oni proto budou vašimi soudci. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Vymítám-li však démony Božím prstem, jistě k vám přišlo Boží království. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Když silný ozbrojenec hlídá svůj palác, jeho majetek je v klidu. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ale když na něj přijde někdo silnější než on a přemůže ho, vezme mu všechnu výzbroj, na kterou spoléhal, a jeho kořisti rozdělí. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kdo není se mnou, je proti mně, a kdo neshromažďuje se mnou, rozptyluje.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Když nečistý duch vyjde z člověka, chodí po suchých místech a hledá odpočinek. A když ho nenajde, říká: ‘Vrátím se do svého domu, odkud jsem vyšel.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A když přijde, nalezne ho vymetený a ozdobený. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tehdy jde a přibere sedm jiných duchů, horších, než je sám. Pak vejdou dovnitř a bydlí tam a poslední věci toho člověka jsou horší než první.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A když to říkal, stalo se, že jedna žena ze zástupu pozdvihla hlas a řekla mu: “Blaze lůnu, které tě nosilo, a prsům, které jsi sál!” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ale on řekl: “Spíše blaze těm, kdo slyší Boží slovo a dodržují je.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A když se k němu scházely zástupy, začal říkat: “Toto pokolení je zlé. Vyhledává znamení, ale žádné znamení mu nebude dáno, kromě znamení proroka Jonáše. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Neboť jako se Jonáš stal znamením pro Ninivské, tak bude i Syn člověka znamením pro toto pokolení. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Královna jihu povstane na soudu s muži tohoto pokolení a odsoudí je, neboť přijela z kraje světa, aby slyšela Šalomounovu moudrost, a hle, zde je více než Šalomoun. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Muži z Ninive povstanou na soudu s tímto pokolením a odsoudí je, neboť po Jonášově kázání činili pokání, a hle, zde je více než Jonáš.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nikdo, když rozsvítí lampu, nestaví ji do skrýše ani pod nádobu, ale na stojan, aby ti, kdo vcházejí, viděli světlo. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lampou těla je oko. Pokud je tedy tvé oko prosté, je jasné i celé tvé tělo. Jakmile je však zlé, je i tvé tělo temné. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dej tedy pozor, aby světlo, které je v tobě, nebylo tmou. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Když pak bude celé tvé tělo jasné a nebude mít žádnou temnou část, bude celé tak jasné, jako když tě lampa ozařuje svým jasem.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","A když mluvil, prosil ho jeden farizeus, aby u něho poobědval. Vešel tedy a posadil se za stůl. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A když to ten farizeus uviděl, podivil se, že se před obědem nejdříve neumyl. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pán mu tedy řekl: “Vy farizeové teď čistíte pohár a mísu zvenčí, ale vaše nitro je plné zlodějství a ničemnosti. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Blázni! Zdali Ten, který stvořil vnějšek, nestvořil také vnitřek? ");
INSERT INTO cesnkb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Raději tedy dávejte jako milosrdný dar to, co máte uvnitř, a hle, všechno vám bude čisté. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ale běda vám farizeům, že odevzdáváte desátky z máty a z routy a z každé byliny, ale pomíjíte právo a Boží lásku. Tyto věci jste měli dělat a tamty neopomíjet. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Běda vám farizeům, neboť milujete čestná sedadla na shromážděních a zdravení na tržištích. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Běda vám, zákoníci a farizeové, vy pokrytci, neboť jste jako nezřetelné hroby - lidé po nich chodí, ani to nevědí.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jeden z učených v Zákoně mu tedy odpověděl: “Mistře, když takhle mluvíš, haníš i nás.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ale on řekl: “I vám učeným v Zákoně běda, neboť zatěžujete lidi neúnosnými břemeny a sami se těch břemen nedotýkáte ani jedním prstem. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Běda vám, protože stavíte hroby proroků, které vaši otcové zabili, ");
INSERT INTO cesnkb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","a tak dosvědčujete a schvalujete skutky svých otců. Oni je totiž zabili a vy jim stavíte hroby. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Proto také Boží moudrost řekla: ‘Pošlu k nim proroky a apoštoly a z těch některé zabijí a jiné budou pronásledovat,’ ");
INSERT INTO cesnkb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","aby od tohoto pokolení byla vyžádána krev všech proroků prolitá od založení světa, ");
INSERT INTO cesnkb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","od Ábelovy krve až po krev Zachariáše, který zahynul mezi oltářem a chrámem. Ano, říkám vám, že bude vyžádána od tohoto pokolení. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Běda vám učeným v Zákoně, neboť jste vzali klíč poznání! Sami jste nevešli a těm, kdo vcházeli, jste zabránili.” ");
INSERT INTO cesnkb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","A když jim to řekl, začali na něj zákoníci a farizeové prudce dotírat a nutili ho mluvit o mnoha věcech. ");
INSERT INTO cesnkb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Dělali mu nástrahy a snažili se ho chytit za slovo, aby ho mohli obžalovat. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A když se mezitím sešly desetitisíce lidí, takže šlapali jedni po druhých, začal Ježíš říkat svým učedníkům: “Především se varujte kvasu farizeů, což je pokrytectví. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Není totiž nic skrytého, co nebude zjeveno, ani nic tajného, co nebude poznáno. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","To, co jste říkali ve tmě, tedy bude slyšet na světle, a co jste ve svých pokojích šeptali do ucha, se bude kázat ze střech.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ale vám, svým přátelům, říkám: Nebojte se těch, kdo zabíjejí tělo a potom nemají, co by udělali víc. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ukážu vám však, koho se máte bát: Bojte se Toho, který když zabije, má moc uvrhnout do pekla. Ano, říkám vám, Toho se bojte. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Neprodává se snad pět vrabců za dva haléře? A jediný z nich není před Bohem zapomenut. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Vám jsou však spočítány i všechny vlasy na hlavě! Proto se nebojte. Jste dražší než mnoho vrabců.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Říkám vám tedy: Kdokoli mne vyzná před lidmi, toho i Syn člověka vyzná před Božími anděly. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kdo mne ale před lidmi zapře, bude zapřen před Božími anděly. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","A každému, kdo řekne slovo proti Synu člověka, bude odpuštěno, ale tomu, kdo by se rouhal Duchu Svatému, odpuštěno nebude. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Když vás pak povedou do shromáždění a před vrchnosti a vlády, nestarejte se, co a jak máte odpovídat a co říkat, ");
INSERT INTO cesnkb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","protože Duch Svatý vás v tu chvíli naučí, co máte říci.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Někdo ze zástupu mu řekl: “Mistře, řekni mému bratru, ať se se mnou rozdělí o dědictví!” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","On mu však řekl: “Člověče, kdo mě nad vámi ustanovil soudcem nebo děličem?” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Řekl jim tedy: “Dejte pozor a varujte se lakomství; neboť život člověka nespočívá v hojnosti jeho majetku.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tehdy jim řekl podobenství: “Pole jednoho bohatého člověka přineslo hojnou úrodu. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Přemýšlel tedy a říkal si: ‘Co budu dělat? Vždyť nemám, kam bych shromáždil svou úrodu!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Potom řekl: ‘Udělám toto: Zbořím své stodoly a postavím větší a tam shromáždím všechnu svou úrodu i své zboží. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A své duši řeknu: Duše, máš mnoho zboží uloženého na mnoho let. Odpočívej, jez, pij, vesel se!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ale Bůh mu řekl: ‘Blázne, tuto noc od tebe vyžádají tvou duši a čí bude to, co jsi připravil?’ ");
INSERT INTO cesnkb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tak je to s každým, kdo si hromadí poklady a není bohatý v Bohu.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tehdy řekl svým učedníkům: “Proto vám říkám, nemějte starost o svůj život, co byste jedli, ani o tělo, co byste si oblékali. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Život je víc než pokrm a tělo víc než oděv. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pohleďte na havrany, že nesejí ani nesklízejí a nemají spíže ani stodoly, ale Bůh je živí. Čím větší cenu máte vy než ptáci! ");
INSERT INTO cesnkb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kdo z vás může pečlivým staráním přidat ke své výšce jediný loket? ");
INSERT INTO cesnkb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Když tedy nezmůžete ani to nejmenší, proč se staráte o to ostatní? ");
INSERT INTO cesnkb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pohleďte na lilie, jak rostou. Nepracují ani nepředou, ale říkám vám, že ani Šalomoun ve vší své slávě nebyl oblečen jako jedna z nich. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jestliže tedy Bůh takto obléká trávu, která je dnes na louce a zítra bude hozena do pece, čím spíše vás, vy malověrní?! ");
INSERT INTO cesnkb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nehledejte tedy, co byste jedli nebo co byste pili, ani se tím nezneklidňujte. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Všechny tyto věci totiž vyhledávají národy tohoto světa, ale váš Otec ví, že je potřebujete. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hledejte raději Boží království a všechny tyto věci vám budou přidány. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Neboj se, maličké stádo, neboť vašemu Otci se zalíbilo dát vám království. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Prodávejte svůj majetek a dávejte milosrdné dary. Udělejte si měšce, které nestárnou, nehynoucí poklad v nebi, kam zloděj nepřichází a kde mol neničí. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vždyť kde je váš poklad, tam bude i vaše srdce.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Vaše bedra ať jsou přepásaná a vaše lampy ať hoří. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","A vy buďte jako lidé očekávající svého pána, až se vrátí ze svatby, aby mu otevřeli hned, jakmile přijde a zatluče. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blaze těm služebníkům, které pán při svém příchodu zastihne bdící. Amen, říkám vám, že se přepáše, posadí je za stůl, přistoupí a bude jim sloužit. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A přijde-li během druhé nebo třetí hlídky a zastihne je tak, blaze těm služebníkům. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Vězte však, že kdyby hospodář věděl, ve kterou hodinu má přijít zloděj, bděl by a nedovolil by mu prokopat se do jeho domu. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Proto i vy buďte připraveni, neboť Syn člověka přijde v hodinu, o které netušíte.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tehdy mu Petr řekl: “Pane, říkáš to podobenství jenom nám, nebo také všem?” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Pán řekl: “Kdo je tedy ten věrný a moudrý správce, kterého pán ustanoví nad svým služebnictvem, aby jim v patřičný čas dával vyměřený pokrm? ");
INSERT INTO cesnkb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blaze tomu služebníku, kterého jeho pán při příchodu zastihne, že tak jedná. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","V pravdě vám říkám, že ho ustanoví nad vším svým majetkem. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kdyby si však ten služebník v srdci řekl: ‘Můj pán mešká se svým příchodem’ a začal by bít služebníky a služebné a jíst, pít a opíjet se, ");
INSERT INTO cesnkb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tehdy přijde pán toho služebníka v den, kdy to nečeká, a v hodinu, kterou nezná, a oddělí ho a určí mu díl s nevěrnými. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A ten služebník, který znal vůli svého pána, ale nepřipravil se a nejednal podle jeho vůle, bude hodně bit. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ale ten, který ji neznal a udělal trestuhodné věci, bude bit méně. Vždyť komukoli je hodně dáno, od toho bude hodně vyžádáno; a komu svěřili hodně, od toho vyžádají více.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Přišel jsem na zem pustit oheň a co si přeji, než aby už hořel?! ");
INSERT INTO cesnkb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mám se ale křtít křtem a jak je mi úzko, dokud se nevykoná! ");
INSERT INTO cesnkb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Myslíte si, že jsem přišel přinést na zem pokoj? Říkám vám, ne pokoj, ale rozdělení. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Neboť od nynějška jich bude pět rozděleno v jednom domě: tři proti dvěma a dva proti třem. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Otec bude rozdělen proti synu a syn proti otci, matka proti dceři a dcera proti matce, tchýně proti své snaše a snacha proti své tchýni.” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zástupům také řekl: “Když spatříte oblak, jak vychází od západu, hned říkáte: ‘Přichází liják,’ a je to tak. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Když pak vane jižní vítr, říkáte: ‘Bude horko,’ a bývá. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pokrytci! Umíte rozpoznat vzhled země i nebe; jak to, že tedy nepoznáváte tento čas?” ");
INSERT INTO cesnkb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“A proč ani sami od sebe nerozsuzujete, co je spravedlivé? ");
INSERT INTO cesnkb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Když tedy jdeš se svým odpůrcem k vrchnosti, snaž se s ním cestou vypořádat. Jinak tě potáhne k soudci a soudce tě vydá biřici a biřic tě vsadí do vězení. ");
INSERT INTO cesnkb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Říkám ti: Rozhodně odtamtud nevyjdeš, dokud nevrátíš i ten poslední haléř.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","V tu dobu byli přítomni někteří, kteří mu vyprávěli o Galilejcích, jejichž krev Pilát smísil s jejich oběťmi. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ježíš jim tedy odpověděl: “Myslíte si, že tito Galilejci byli větší hříšníci než všichni ostatní Galilejci, že se jim to stalo? ");
INSERT INTO cesnkb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Říkám vám, že ne. A nebudete-li činit pokání, zahynete podobně všichni. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Anebo těch osmnáct, na které spadla věž v Siloe a zabila je - myslíte si, že byli větší viníci než všichni lidé bydlící v Jeruzalémě? ");
INSERT INTO cesnkb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Říkám vám, že ne. A nebudete-li činit pokání, zahynete podobně všichni.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Vyprávěl tedy toto podobenství: “Jeden člověk měl na své vinici zasazený fíkový strom. Přišel pak na něm hledat ovoce, ale nenašel. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Řekl tedy vinaři: ‘Hle, tři roky přicházím a hledám na tomto fíkovníku ovoce, ale nenalézám. Poraz ho. Proč má kazit i tu zem?’ ");
INSERT INTO cesnkb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ale on mu odpověděl: ‘Pane, nech ho ještě tento rok, až ho okopám a pohnojím, ");
INSERT INTO cesnkb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ponese-li snad ovoce. A pokud ne, porazíš ho potom.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","V sobotu pak učil v jedné synagoze. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A hle, byla tam žena, která měla osmnáct let ducha nemoci a byla sehnutá a nijak se nemohla narovnat. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Když ji Ježíš spatřil, zavolal ji k sobě a řekl jí: “Ženo, jsi zproštěna své nemoci.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Vložil na ni ruce a ona se hned narovnala a oslavovala Boha. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Představený synagogy však na to odpověděl s hněvem, protože Ježíš uzdravoval v sobotní den, a řekl zástupu: “Je šest dní, ve kterých se má pracovat. V nich tedy přicházejte a nechte se uzdravovat, a ne v den soboty!” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ale Pán mu odpověděl: “Pokrytče! Neodvazuje každý z vás v sobotu svého vola nebo osla od žlabu a nevodí ho napájet? ");
INSERT INTO cesnkb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A tato žena, dcera Abrahamova, kterou Satan držel svázanou - hle, už osmnáct let - neměla být rozvázána z toho pouta v sobotní den?” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Když to řekl, všichni jeho protivníci byli zahanbeni, ale všechen zástup se radoval ze všech těch slavných skutků, které dělal. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tehdy řekl: “Čemu je podobné Boží království a k čemu ho přirovnám? ");
INSERT INTO cesnkb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Je podobné zrnku hořčice, které člověk vzal a hodil do své zahrady; a ono vyrostlo a stalo se velikým stromem a nebeští ptáci se uhnízdili v jeho větvích.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A znovu řekl: “K čemu přirovnám Boží království? ");
INSERT INTO cesnkb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Je podobné kvasu, který žena vzala a zadělala ve třech měřicích mouky, až všechno zkvasilo.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","A tak procházel města a vesnice a učil, konaje cestu do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Někdo mu řekl: “Pane, je málo těch, kteří budou spaseni?” On jim však řekl: ");
INSERT INTO cesnkb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Snažte se vejít těsnou branou, neboť vám říkám, že mnozí se budou pokoušet vejít, ale nebudou moci. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Když hospodář vstane a zavře dveře, tehdy začnete stát venku, tlouci na dveře a říkat: ‘Pane, Pane, otevři nám,’ a on vám odpoví: ‘Neznám vás, nevím, odkud jste.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tehdy začnete říkat: ‘Jedli jsme a pili před tebou a učil jsi na našich ulicích!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A on řekne: ‘Říkám vám, že vás neznám a nevím, odkud jste. Odejděte ode mne, všichni, kdo konáte nepravost!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bude tam pláč a skřípění zubů, až spatříte Abrahama, Izáka a Jákoba a všechny proroky v Božím království, ale sami sebe vyhnané ven. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A přijdou od východu i od západu a od severu i od jihu a budou stolovat v Božím království. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A hle, jsou poslední, kteří budou první, a jsou první, kteří budou poslední.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","V ten den přistoupili někteří farizeové a říkali mu: “Odejdi a běž odsud, protože Herodes tě chce zabít.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Řekl jim tedy: “Jděte a řekněte té lišce: Hle, vymítám démony a uzdravuji dnes i zítra a třetího dne dokonám. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dnes, zítra i pozítří však musím být na cestě; protože není možné, aby prorok zahynul mimo Jeruzalém.” ");
INSERT INTO cesnkb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jeruzaléme, Jeruzaléme, který zabíjíš proroky a kamenuješ ty, kteří jsou k tobě posíláni! Kolikrát jsem chtěl shromáždit tvé děti, jako slepice shromažďuje svá kuřata pod křídla, ale nechtěli jste. ");
INSERT INTO cesnkb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hle, váš dům se vám zanechává pustý. Ale říkám vám jistě, že mě už neuvidíte, dokud nepřijde čas, kdy řeknete: ‘Požehnaný, který přichází v Pánově jménu!’” ");
INSERT INTO cesnkb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Stalo se pak, že v sobotu vešel do domu jednoho z předních farizeů, aby jedl chléb, a oni ho sledovali. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A náhle byl před ním nějaký vodnatelný člověk. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ježíš tedy těm učeným v Zákoně a farizeům odpověděl: “Smí se v sobotu uzdravovat?” ");
INSERT INTO cesnkb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ale oni mlčeli. A tak ho vzal, uzdravil a propustil. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Potom jim odpověděl: “Kdo z vás v sobotní den ihned nevytáhne svého osla nebo vola, když mu spadne do studny?” ");
INSERT INTO cesnkb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A nemohli mu na to odpovědět. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Když pak pozoroval, jak si vybírají přední místa, pověděl pozvaným podobenství. Řekl jim: ");
INSERT INTO cesnkb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kdybys byl někým pozván na svatbu, nesedej si na přední místo, aby tam snad nebyl pozván někdo váženější než ty. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ten, který pozval tebe i jeho, by pak přišel a řekl ti: ‘Uvolni mu místo.’ A tehdy bys s hanbou zaujal poslední místo. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Když jsi tedy pozván, jdi a posaď se na posledním místě, aby ten, který tě pozval, přišel a řekl ti: ‘Příteli, pojď výš.’ Tehdy budeš mít před svými spoluhodovníky chválu. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Neboť každý, kdo se povyšuje, bude ponížen, a kdo se ponižuje, bude povýšen.” ");
INSERT INTO cesnkb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tehdy řekl také tomu, který ho pozval: “Když pořádáš oběd nebo večeři, nezvi své přátele ani své bratry ani své příbuzné ani bohaté sousedy, aby snad zase oni nepozvali tebe a měl bys odplatu. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ale když pořádáš hostinu, zvi chudé, chromé, zmrzačené a slepé ");
INSERT INTO cesnkb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","a budeš požehnaný. Nemají totiž, čím by ti odplatili, ale bude ti odplaceno při vzkříšení spravedlivých.” ");
INSERT INTO cesnkb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Když to uslyšel jeden ze spoluhodovníků, řekl mu: “Blaze tomu, kdo bude jíst chléb v Božím království.” ");
INSERT INTO cesnkb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","On mu však řekl: “Jeden člověk vystrojil velikou večeři a pozval mnoho hostů. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","V čas večeře pak poslal svého služebníka, aby řekl pozvaným: ‘Pojďte, neboť všechno už je připraveno.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Všichni se ale jednomyslně začali vymlouvat. První mu řekl: ‘Koupil jsem pole a musím se na ně jít podívat. Prosím tě, omluv mne.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Druhý řekl: ‘Koupil jsem pět párů volů a jdu je vyzkoušet. Prosím tě, omluv mne.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A jiný řekl: ‘Oženil jsem se, a proto nemohu přijít.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Když se pak ten služebník vrátil, oznámil ty věci svému pánu. Tehdy se hospodář rozhněval a řekl svému služebníku: ‘Vyjdi rychle do ulic a uliček města a přiveď sem chudé, chromé, zmrzačené a slepé.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","A služebník řekl: ‘Pane, stalo se, jak jsi přikázal, a ještě je místo.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pán tedy řekl služebníku: ‘Vyjdi na cesty a mezi ploty a přinuť lidi přijít, ať se můj dům naplní. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Říkám vám totiž, že nikdo z těch mužů, kteří byli pozváni, neokusí mou večeři.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Šly s ním veliké zástupy a on se obrátil a řekl jim: ");
INSERT INTO cesnkb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Jde-li někdo ke mně a nemá v nenávisti svého otce i matku i ženu i děti i bratry i sestry a dokonce i svou vlastní duši, nemůže být mým učedníkem. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","A kdokoli nenese svůj kříž a nejde za mnou, nemůže být mým učedníkem. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Neboť kdo z vás, když chce postavit věž, si nejdříve nesedne a nespočítá náklad, má-li na to, aby ji dokončil? ");
INSERT INTO cesnkb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aby snad, když by položil základ a nemohl stavbu dokončit, nezačali se mu posmívat všichni, kteří by to viděli, ");
INSERT INTO cesnkb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","se slovy: ‘Tento člověk začal stavět a nemohl to dokončit.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Anebo - který král si cestou do boje proti jinému králi nejdříve nesedne, aby se poradil, může-li se s deseti tisíci utkat s tím, který proti němu táhne s dvaceti tisíci? ");
INSERT INTO cesnkb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jinak totiž k němu pošle poselstvo, když bude ještě daleko, a bude se ptát na podmínky míru. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tak tedy žádný z vás, kdo se nerozloučí se vším, co má, nemůže být mým učedníkem. ");
INSERT INTO cesnkb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sůl je dobrá. Jestliže však sůl ztratí svou chuť, čím bude osolena? ");
INSERT INTO cesnkb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nehodí se do země ani do hnoje; vyhazují ji ven. Kdo má uši k slyšení, ať slyší.” ");
INSERT INTO cesnkb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Všichni celníci i hříšníci tedy přicházeli blíž k němu, aby ho slyšeli. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farizeové a zákoníci však reptali a říkali: “Tento přijímá hříšníky a jí s nimi!” ");
INSERT INTO cesnkb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pověděl jim tedy toto podobenství. Řekl: ");
INSERT INTO cesnkb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kdo z vás, má-li sto ovcí a ztratil by jednu z nich, nezanechá těch devadesát devět na poušti a nejde za tou ztracenou, dokud ji nenajde? ");
INSERT INTO cesnkb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A když ji najde, s radostí ji vezme na ramena, ");
INSERT INTO cesnkb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a až přijde domů, svolá přátele a sousedy a řekne jim: ‘Radujte se se mnou, neboť jsem našel svou ovci, která byla ztracená.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Říkám vám, že tak bude v nebi větší radost nad jedním hříšníkem, který činí pokání, než nad devadesáti devíti spravedlivými, kteří pokání nepotřebují.” ");
INSERT INTO cesnkb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“A která žena, když má deset mincí a jednu minci ztratí, nerozsvítí lampu, nevymetá dům a pečlivě nehledá, dokud ji nenajde? ");
INSERT INTO cesnkb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A když ji najde, svolá přítelkyně a sousedky se slovy: ‘Radujte se se mnou, neboť jsem našla minci, kterou jsem ztratila.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Říkám vám, že tak je radost před Božími anděly nad jedním hříšníkem, který činí pokání.” ");
INSERT INTO cesnkb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tehdy řekl: “Jeden člověk měl dva syny, ");
INSERT INTO cesnkb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","z nichž mladší řekl otci: ‘Otče, dej mi díl majetku, který mi patří.’ A tak jim rozdělil své jmění. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Když pak ten mladší syn po nemnoha dnech všechno shromáždil, odešel do daleké země a tam svůj majetek promrhal prostopášným životem. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Když všechno utratil, nastal v té zemi veliký hlad a on začal trpět nouzí. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Šel tedy a přichytil se jednoho občana té země a ten ho poslal na svá pole, aby pásl vepře. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tehdy toužil nasytit své břicho lusky, které žrali vepři, ale nikdo mu nedával ani to. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Když však přišel k sobě, řekl: ‘Kolik nádeníků mého otce má hojnost chleba, a já umírám hlady! ");
INSERT INTO cesnkb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vstanu, půjdu ke svému otci a řeknu mu: Otče, zhřešil jsem proti nebi a před tebou! ");
INSERT INTO cesnkb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nejsem už hoden být nazýván tvým synem. Udělej mě jedním ze svých nádeníků.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A tak vstal a šel ke svému otci. A když byl ještě velmi daleko, jeho otec ho spatřil a pohnut soucitem přiběhl, padl mu kolem krku a políbil ho. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ale syn mu řekl: ‘Otče, zhřešil jsem proti nebi a před tebou a nejsem už hoden být nazýván tvým synem.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Otec však řekl svým služebníkům: ‘Přineste to první roucho a oblečte ho a dejte mu prsten na ruku a obuv na nohy. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A přiveďte to tučné tele a zabijte ho. Jezme a veselme se, ");
INSERT INTO cesnkb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","neboť tento můj syn byl mrtev, a ožil; byl ztracen, a je nalezen.’ A začali se veselit. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jeho starší syn však byl na poli, a když přicházel a přiblížil se k domu, uslyšel hudbu a tanec. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zavolal tedy jednoho ze služebníků a ptal se, co to má být. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A ten mu řekl: ‘Tvůj bratr přišel a tvůj otec zabil tučné tele, že ho dostal zpět zdravého.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ale on se rozhněval a nechtěl jít dovnitř. Jeho otec tedy vyšel a prosil ho. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","On však otci odpověděl: ‘Pohleď, tolik let ti sloužím a nikdy jsem nepřestoupil jediný tvůj příkaz, ale nikdy jsi mi nedal ani kůzle, abych se poveselil se svými přáteli. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ale když přišel tento tvůj syn, který prožral tvé jmění s nevěstkami, zabil jsi mu tučné tele!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A on mu řekl: ‘Synu, ty jsi vždycky se mnou a všechny mé věci jsou tvé. ");
INSERT INTO cesnkb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ale veselit se a radovat bylo potřeba, neboť tento tvůj bratr byl mrtev a ožil; byl ztracen a je nalezen.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Svým učedníkům pak řekl: “Byl jeden bohatý člověk, který měl správce; a ten byl před ním obviněn, že mrhá jeho majetkem. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Zavolal ho tedy a řekl mu: ‘Co to o tobě slyším? Slož účty ze svého správcovství, neboť už nemůžeš být správcem.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Správce si tedy řekl: ‘Co budu dělat, když mi můj pán bere správcovství? Kopat nemohu, žebrat se stydím. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Vím, co udělám - aby mě lidé, až budu zbaven správcovství, přijali do svých domů!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Zavolal tedy každého jednotlivého dlužníka svého pána a prvnímu řekl: ‘Kolik dlužíš mému pánu?’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A on řekl: ‘Sto sudů oleje.’ Řekl mu tedy: ‘Vezmi svůj úpis, rychle si sedni a napiš padesát.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Potom řekl druhému: ‘A kolik dlužíš ty?’ A on řekl: ‘Sto měr pšenice.’ Řekl mu tedy: ‘Vezmi svůj úpis a napiš osmdesát.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","A ten pán pochválil toho nepoctivého správce, že jednal rozumně. Synové tohoto světa jsou totiž ve svém pokolení rozumnější než synové světla. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A já vám říkám: Udělejte si přátele nepravým mamonem, aby vás, až skonáte, přijali do věčných příbytků. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kdo je věrný v nejmenším, je věrný i ve velkém. A kdo je nepoctivý v nejmenším, je nepoctivý i ve velkém. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Když jste tedy nebyli věrní v nepoctivém mamonu, kdo vám svěří pravé bohatství? ");
INSERT INTO cesnkb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A když jste nebyli věrní v cizím, kdo vám dá to, co je vaše? ");
INSERT INTO cesnkb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Žádný sluha nemůže sloužit dvěma pánům. Buď totiž bude jednoho nenávidět a druhého milovat, nebo se toho jednoho bude držet a tím druhým pohrdne. Nemůžete sloužit Bohu i mamonu.” ");
INSERT INTO cesnkb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ale to všechno slyšeli i farizeové, kteří byli milovníci peněz, a vysmívali se mu. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Řekl jim tedy: “Vy ze sebe před lidmi děláte spravedlivé, ale Bůh zná vaše srdce. Neboť co je u lidí vznešené, je v Božích očích ohavnost. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Zákon a Proroci až do Jana; od té doby se káže Boží království a každý se do něj násilně tlačí. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Snadněji však pomine nebe i země, než aby padla jediná čárka ze Zákona. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Každý, kdo propustí svou manželku a bere si jinou, cizoloží, a kdo si bere tu, kterou muž propustil, cizoloží.” ");
INSERT INTO cesnkb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Byl jeden bohatý člověk, oblékal se do purpuru a kmentu a každého dne se skvěle veselil. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A byl jeden žebrák, jménem Lazar, který ležel u jeho vrat plný vředů ");
INSERT INTO cesnkb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","a toužil být nasycen drobty, které padaly ze stolu toho boháče. Dokonce i psi přicházeli a lízali mu vředy. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Stalo se pak, že ten žebrák zemřel a andělé ho odnesli do Abrahamova náručí. A boháč zemřel také a byl pohřben. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Potom v pekle pozvedl své oči, když byl v mukách, a spatřil zdálky Abrahama a Lazara v jeho náručí. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tehdy ten boháč zvolal: ‘Otče Abrahame, smiluj se nade mnou a pošli Lazara, ať smočí konec svého prstu ve vodě a ochladí můj jazyk, protože trpím v tomto plameni!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham však řekl: ‘Synu, vzpomeň si, že ty sis ve svém životě vzal své dobré a podobně Lazar zlé. On je tedy teď potěšován, ale ty jsi trápen. ");
INSERT INTO cesnkb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A kromě toho všeho je mezi námi a vámi ustanovena veliká propast, aby ti, kdo chtějí překročit odsud k vám nebo se dostat odtamtud k nám, nemohli.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","A on řekl: ‘Prosím tě tedy, otče, abys ho poslal do domu mého otce, ");
INSERT INTO cesnkb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","neboť mám pět bratrů. Ať jim svědčí, aby i oni nepřišli do tohoto místa muk!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham mu řekl: ‘Mají Mojžíše a Proroky. Ať poslechnou je.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A on řekl: ‘Ne, otče Abrahame; ale kdyby k nim šel někdo z mrtvých, budou činit pokání.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","On mu ale řekl: ‘Když neposlouchají Mojžíše a Proroky, nedají se přesvědčit, ani kdyby někdo vstal z mrtvých.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tehdy řekl učedníkům: “Není možné, aby pohoršení nepřišla, ale běda tomu, skrze koho přicházejí. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bylo by pro něj lepší, kdyby mu na krk pověsili mlýnský kámen a hodili ho do moře, než aby svedl jednoho z těchto maličkých. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dávejte na sebe pozor. Kdyby však proti tobě zhřešil tvůj bratr, pokárej ho, a bude-li toho litovat, odpusť mu. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A kdyby proti tobě zhřešil sedmkrát za den a sedmkrát za den by se k tobě obrátil se slovy: ‘Je mi to líto,’ odpustíš mu.” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tehdy řekli apoštolové Pánu: “Přidej nám víry.” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ale Pán řekl: “Kdybyste měli víru jako hořčičné zrnko, řekli byste této moruši: ‘Vykořeň se a přesaď se do moře!’ a poslechla by vás.” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“A kdo z vás, kdo má služebníka, který oře nebo pase, řekne mu, hned když se vrátí z pole: ‘Pojď a posaď se za stůl’? ");
INSERT INTO cesnkb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Neřekne mu snad spíše: ‘Připrav mi večeři, přepásej se a obsluhuj mě, dokud se nenajím a nenapiji, a potom budeš jíst a pít ty’? ");
INSERT INTO cesnkb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Děkuje snad tomu služebníku, že udělal to, co mu bylo nařízeno? Nezdá se mi. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tak i vy, když uděláte všechno, co je vám nařízeno, říkejte: ‘Jsme neužiteční služebníci. Udělali jsme, co jsme byli povinni udělat.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Stalo se pak, že cestou do Jeruzaléma procházel Samařím a Galilejí. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A když vcházel do jedné vesnice, setkalo se s ním deset malomocných mužů. Ti zůstali stát opodál, ");
INSERT INTO cesnkb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","pozdvihli hlas a řekli: “Ježíši, mistře, smiluj se nad námi!” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","A když je spatřil, řekl jim: “Jděte a ukažte se kněžím.” A když šli, stalo se, že byli očištěni. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Když pak jeden z nich uviděl, že je uzdraven, vrátil se a hlasitě oslavoval Boha. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Padl na tvář k jeho nohám a děkoval mu. A byl to Samaritán. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ježíš pak odpověděl: “Nebylo jich očištěno deset? Kde je tedy těch devět? ");
INSERT INTO cesnkb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nenašel se z nich nikdo, aby se vrátil a dal Bohu slávu, jedině tento cizinec?” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A řekl mu: “Vstaň a jdi. Tvá víra tě uzdravila.” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Když se ho pak farizeové zeptali, kdy přijde Boží království, odpověděl jim a řekl: “Boží království nepřijde viditelně. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Neřeknou: ‘Hle, je zde’ anebo ‘Hle, je tam.’ Pohleďte přece, Boží království je mezi vámi.” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Učedníkům pak řekl: “Přijdou dny, kdy zatoužíte uvidět jeden ze dnů Syna člověka, ale neuvidíte. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tehdy vám řeknou: ‘Hle, je zde’ anebo ‘Hle, je tam.’ Neodcházejte ani je nenásledujte, ");
INSERT INTO cesnkb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","neboť jako blesk, který se zablýskne z jedné krajiny pod nebem, září až do druhé krajiny pod nebem, tak bude i Syn člověka ve svém dni. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nejdříve ale musí mnoho vytrpět a být tímto pokolením zavržen. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","A jak bylo za dnů Noéma, tak bude i za dnů Syna člověka: ");
INSERT INTO cesnkb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jedli, pili, ženili se a vdávaly se až do toho dne, kdy Noé vešel do archy; a přišla potopa a všechny zahubila. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Také podobně, jako bylo za dnů Lota: Jedli, pili, kupovali, prodávali, sázeli, stavěli; ");
INSERT INTO cesnkb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ale toho dne, kdy Lot vyšel ze Sodomy, pršel z nebe oheň se sírou a všechny zahubil. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Právě tak bude v ten den, kdy se zjeví Syn člověka. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kdo bude v ten den na střeše a jeho věci v domě, ať nesestupuje, aby je pobral, a podobně, kdo na poli, ať se nevrací zpět. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pamatujte na Lotovu ženu. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kdokoli by si chtěl zachránit duši, ten ji ztratí, a kdokoli by ji ztratil, ten ji obživí. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Říkám vám: v tu noc budou dva na jednom loži; jeden bude vzat a druhý zanechán. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dvě budou spolu mlít; jedna bude vzata a druhá zanechána. ");
INSERT INTO cesnkb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dva budou na poli; jeden bude vzat a druhý zanechán.” ");
INSERT INTO cesnkb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Odpověděli mu: “Kde, Pane?” Ale on jim řekl: “Kde bude tělo, tam se shromáždí orli.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Vyprávěl jim také podobenství, jak je potřeba stále se modlit a nepolevovat. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Řekl: “V jednom městě byl jeden soudce, který se nebál Boha a člověka si nevážil. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A v tom městě byla vdova. Ta k němu chodila a říkala: ‘Zjednej mi právo proti mému odpůrci.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","On ale dlouho nechtěl. Potom si však řekl: ‘Nebojím se sice Boha, a člověka si nevážím, ");
INSERT INTO cesnkb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ale proto, že mi tato vdova nedává pokoj, zjednám jí právo, aby snad nakonec nepřišla a neztloukla mě.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pán tedy řekl: “Slyšte, co říká ten nespravedlivý soudce! ");
INSERT INTO cesnkb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A Bůh snad nezjedná právo svým vyvoleným, kteří k němu volají dnem i nocí? A bude jim otálet pomoci? ");
INSERT INTO cesnkb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Říkám vám, že jim zjedná právo rychle. Ale až Syn člověka přijde, nalezne na zemi víru?” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Některým, kteří spoléhali na sebe, že jsou spravedliví, a ostatními pohrdali, pak řekl i toto podobenství: ");
INSERT INTO cesnkb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Dva lidé vstupovali do chrámu, aby se modlili; jeden byl farizeus a druhý celník. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizeus se postavil a takto se sám pro sebe modlil: ‘Bože, děkuji ti, že nejsem jako ostatní lidé, rváči, nespravedliví, cizoložníci, nebo i jako tento celník. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Postím se dvakrát do týdne, desátky dávám ze všeho, co vlastním...’ ");
INSERT INTO cesnkb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Celník však stál opodál a nechtěl ani oči k nebi pozvednout, ale bil se do prsou se slovy: ‘Bože, buď milostivý ke mně hříšnému!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Říkám vám, že tento muž odešel do svého domu ospravedlněn spíše než tamten. Každý, kdo se povyšuje, totiž bude ponížen, a kdo se ponižuje, bude povýšen.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Přinášeli tedy k němu i novorozence, aby se jich dotýkal. Když to však uviděli učedníci, přísně je napomínali. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ježíš je ale zavolal a řekl: “Nechte děti přicházet ke mně a nebraňte jim, neboť takovým patří Boží království. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Amen, říkám vám, že kdokoli nepřijme Boží království jako dítě, nikdy do něho nevejde.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tehdy se ho jeden přední muž zeptal: “Dobrý mistře, co mám udělat, abych se stal dědicem věčného života?” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ale Ježíš mu řekl: “Proč mě nazýváš dobrým? Nikdo není dobrý, jen jediný - Bůh. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Přikázání znáš: abys nezcizoložil, nezabil, neukradl, nevydal falešné svědectví; cti svého otce i svou matku.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A on řekl: “To všechno jsem dodržoval odmalička.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Když to pak Ježíš uslyšel, řekl mu: “Chybí ti ještě jedno. Všechno, co máš, prodej a rozdej chudým a budeš mít poklad v nebi. A pojď, následuj mne.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ale on, když to uslyšel, velice se zarmoutil. Byl totiž nesmírně bohatý. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Když tedy Ježíš uviděl, jak se velice zarmoutil, řekl: “Jak nesnadno vejdou do Božího království ti, kdo mají bohatství! ");
INSERT INTO cesnkb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Je totiž snadnější, aby velbloud prošel uchem jehly, než aby boháč vešel do Božího království.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A ti, kdo to slyšeli, řekli: “Kdo tedy může být spasen?” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","On však řekl: “Co je u lidí nemožné, je možné u Boha.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petr tedy řekl: “Pohleď, my jsme všechno opustili a šli jsme za tebou.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A on jim řekl: “Amen, říkám vám, že není nikdo, kdo opustil dům nebo rodiče nebo bratry nebo ženu nebo děti kvůli Božímu království, ");
INSERT INTO cesnkb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","aby nepřijal v tomto čase mnohem více a v nadcházejícím věku věčný život.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tehdy vzal k sobě těch dvanáct a řekl jim: “Hle, jdeme vzhůru do Jeruzaléma a tam se Synu člověka naplní všechno, co je napsáno skrze proroky. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Neboť bude vydán pohanům a bude zesměšněn, pohaněn a popliván. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Zbičují ho a zabijí, ale třetího dne vstane z mrtvých.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Oni však nic z toho nepochopili. To slovo bylo před nimi skryto a nerozuměli, co bylo řečeno. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Když se pak blížil k Jerichu, stalo se, že jeden slepec seděl u cesty a žebral. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Když uslyšel procházející zástup, ptal se, co se to děje. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Oznámili mu tedy, že tudy jde Ježíš Nazaretský. ");
INSERT INTO cesnkb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A on zvolal: “Ježíši, Synu Davidův, smiluj se nade mnou!” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ti, kdo šli před Ježíšem, ho tedy napomínali, ať mlčí, ale on křičel ještě více: “Synu Davidův, smiluj se nade mnou!” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ježíš se tedy zastavil a přikázal, ať ho k němu přivedou. A když se přiblížil, zeptal se ho: ");
INSERT INTO cesnkb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Co chceš, abych pro tebe udělal?” On tedy řekl: “Pane, ať vidím!” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tehdy mu Ježíš řekl: “Prohlédni. Tvá víra tě uzdravila.” ");
INSERT INTO cesnkb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A on ihned prohlédl a šel za ním a oslavoval Boha. A všechen lid, když to uviděl, vzdal chválu Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Potom vešel do Jericha a procházel jím. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A hle, byl tam muž jménem Zacheus. Ten byl vrchním celníkem a byl bohatý ");
INSERT INTO cesnkb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","a toužil uvidět, kdo je Ježíš, ale nemohl kvůli zástupu, protože byl malé postavy. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A tak běžel napřed a vylezl na planý fíkovník, aby ho uviděl, neboť tudy měl procházet. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Když pak Ježíš přišel k tomu místu, vzhlédl, spatřil ho a řekl mu: “Zachee, pospěš si a pojď dolů, neboť dnes musím zůstat ve tvém domě.” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A tak rychle slezl a radostně ho přijal. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A všichni, kdo to viděli, reptali a říkali: “Vešel jako host k hříšníkovi!” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacheus se pak postavil a řekl Pánu: “Pohleď, polovinu svého majetku dávám chudým, Pane, a jestliže jsem někoho v něčem podvedl, vracím to čtyřnásobně.” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tehdy mu Ježíš řekl: “Dnes do tohoto domu přišlo spasení, protože i on je syn Abrahamův. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Syn člověka přece přišel, aby hledal a spasil to, co zahynulo.” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A když to poslouchali, řekl jim další podobenství, protože byl blízko Jeruzaléma a oni si mysleli, že Boží království se má zjevit hned. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Řekl tedy: “Jeden urozený člověk odešel do daleké země, aby se ujal království a zase se vrátil. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Předtím ale zavolal svých deset služebníků, dal jim deset hřiven a řekl jim: ‘Podnikejte, dokud nepřijdu.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jeho poddaní ho ale nenáviděli a poslali za ním poselstvo se slovy: ‘Nechceme, aby tento nad námi kraloval!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Když se pak ujal království, vrátil se; a stalo se, že si nechal zavolat ty služebníky, kterým dal peníze, aby zjistil, kolik kdo vydělal. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Přišel tedy první a řekl: ‘Pane, tvá hřivna vynesla deset hřiven.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","On mu odpověděl: ‘Výborně, můj dobrý služebníku. Protože jsi byl věrný v nejmenším, měj moc nad deseti městy.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Potom přišel druhý a řekl: ‘Pane, tvá hřivna vydělala pět hřiven.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A tomu řekl: ‘Také ty buď nad pěti městy.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Potom přišel jiný a řekl: ‘Pohleď, Pane, tvá hřivna, kteroujsem měl uloženou v šátku. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bál jsem se tě totiž, neboť jsi přísný člověk. Vybíráš, co jsi neuložil, a sklízíš, co jsi nezasel.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A tomu řekl: ‘Soudím tě z tvých vlastních úst, zlý služebníku. Věděl jsi, že jsem přísný člověk, že vybírám, co jsem neuložil, a sklízím, co jsem nezasel. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Proč jsi tedy nedal mé peníze na stůl směnárníkům, abych si je, až přijdu, vybral i s úroky?’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tehdy řekl těm, kdo tam stáli: ‘Vezměte mu tu hřivnu a dejte ji tomu, který má deset hřiven.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","A oni mu řekli: ‘Pane, má deset hřiven.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Říkám vám totiž, že každému, kdo má, bude dáno, ale tomu, kdo nemá, bude vzato i to, co má. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ty mé nepřátele, kteří nechtěli, abych nad nimi kraloval, pak přiveďte sem a pobijte přede mnou.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","A když to pověděl, šel napřed cestou vzhůru k Jeruzalému. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Když se pak přiblížil k Betfagé a k Betanii u hory zvané Olivetská, stalo se, že poslal dva ze svých učedníků ");
INSERT INTO cesnkb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","se slovy: “Jděte do té vesnice naproti vám. Až do ní budete vcházet, najdete přivázané oslátko, na kterém ještě nikdo z lidí neseděl. Odvažte ho a přiveďte. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A kdyby se vás někdo ptal, proč ho odvazujete, odpovíte mu takto: ‘Pán ho potřebuje.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Když tedy ti, kteří byli posláni, odešli, našli vše tak, jak jim řekl. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Když pak to oslátko odvazovali, řekli jim jeho páni: “Proč odvazujete to oslátko?” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Oni tedy řekli: “Pán ho potřebuje” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A přivedli ho k Ježíši. Přehodili přes oslátko své pláště a Ježíše posadili na ně. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A jak jel, prostírali své pláště na cestu. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Když se pak už blížil k tomu místu, kde se schází z Olivetské hory, začalo celé množství učedníků hlasitě a radostně chválit Boha za všechny zázraky, které spatřili. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Říkali: “Požehnaný král, který přichází v Pánově jménu! Pokoj na nebi a sláva na výsostech!” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Někteří z farizeů ze zástupu mu tedy řekli: “Mistře, napomeň své učedníky!” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","On jim však odpověděl: “Říkám vám, kdyby tito měli mlčet, křičelo by kamení!” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Když se pak přiblížil a spatřil město, rozplakal se nad ním. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Řekl: “\" kdybys i ty poznalo aspoň v tento svůj den, co by ti přineslo pokoj! Teď je to ale před tvýma očima skryto. ");
INSERT INTO cesnkb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Přijdou na tebe dny, kdy tě tví nepřátelé obklíčí valem a oblehnou tě. Sevřou tě ze všech stran ");
INSERT INTO cesnkb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","a srovnají tě se zemí, i tvé syny v tobě; a nenechají v tobě kámen na kameni, protože jsi nepoznalo čas svého navštívení.” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Když potom vešel do chrámu, začal vyhánět ty, kdo v něm prodávali a kupovali ");
INSERT INTO cesnkb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a říkal jim: “Je napsáno: ‘Můj dům je domem modlitby,’ ale vy jste z něj udělali ‘doupě lupičů’!” ");
INSERT INTO cesnkb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A každý den učil v chrámu. Velekněží, zákoníci a přední muži z lidu pak hledali, jak ho zahubit, ");
INSERT INTO cesnkb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ale nenacházeli nic, co by mohli udělat. Všechen lid mu totiž visel na rtech a naslouchal. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jednoho z těch dnů, když učil lid v chrámu a kázal evangelium, se pak stalo, že přišli velekněží a zákoníci se staršími ");
INSERT INTO cesnkb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","a řekli mu: “Pověz nám, jakou mocí děláš tyto věci? A kdo ti tu moc dal?” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","On jim však odpověděl: “Já se vás také zeptám na jednu věc. Povězte mi: ");
INSERT INTO cesnkb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Byl Janův křest z nebe, nebo z lidí?” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Rozvažovali tedy o tom mezi sebou a říkali: “Kdybychom řekli, že z nebe, řekne nám: ‘Proč jste mu tedy neuvěřili?’ ");
INSERT INTO cesnkb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ale když řekneme, že z lidí, všechen lid nás ukamenuje, protože jsou přesvědčeni, že Jan je prorok.” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","A tak odpověděli, že nevědí, odkud byl. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A Ježíš jim řekl: “Ani já vám tedy neřeknu, jakou mocí dělám tyto věci.” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tehdy začal lidu vyprávět toto podobenství: “Jeden člověk vysadil vinici, pronajal ji vinařům a na dlouhou dobu odcestoval. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","V příslušný čas pak poslal k těm vinařům služebníka, aby mu dali díl z úrody vinice. Ti vinaři ho však zbili a poslali pryč s prázdnou. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Poslal tedy ještě jiného služebníka. Ale oni zbili a zohavili i toho a poslali ho pryč s prázdnou. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Poslal tedy třetího, ale oni i toho zranili a vyhnali ven. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tehdy pán té vinice řekl: ‘Co udělám? Pošlu svého milovaného syna. Snad když uvidí jeho, budou ho mít ve vážnosti.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Když ho ale vinaři uviděli, domlouvali se mezi sebou a říkali: ‘Tohle je dědic. Pojďme, zabijme ho, aby to dědictví bylo naše.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pak ho vyhodili z vinice ven a zabili. Co jim tedy udělá pán té vinice? ");
INSERT INTO cesnkb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Přijde a zahubí ty vinaře a vinici dá jiným.” A když to uslyšeli, řekli: “To snad ne!” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","On na ně ale pohlédl a řekl: “Co tedy znamená to, co je napsáno: ‘Kámen, který stavitelé zavrhli, se stal hlavním kamenem klenby’? ");
INSERT INTO cesnkb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Každý, kdo padne na ten kámen, bude roztříštěn, a na koho by padl, toho rozdrtí na prach.” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Velekněží a zákoníci se ho v tu chvíli chtěli zmocnit, ale zalekli se lidu. Poznali totiž, že to podobenství řekl o nich. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sledovali ho tedy a poslali špehy, kteří se vydávali za spravedlivé, aby ho chytili za slovo a potom vydali vrchnosti a moci vladaře. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","A ti se ho zeptali: “Mistře, víme, že správně mluvíš i učíš a nikomu nestraníš, ale pravdivě učíš Boží cestě. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Je správné, abychom dávali císaři daň, nebo ne?” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ježíš ale poznal jejich chytráctví a řekl jim: “Proč mě pokoušíte? ");
INSERT INTO cesnkb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ukažte mi denár. Čí má obraz a nápis?” Odpověděli: “Císařův.” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A on jim řekl: “Dejte tedy to, co je císařovo, císaři, a co je Božího, Bohu.” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A tak ho nemohli před lidmi chytit za slovo a v údivu nad jeho odpovědí zmlkli. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tehdy k němu přišli někteří ze saduceů (kteří popírají, že je vzkříšení) a zeptali se ho: ");
INSERT INTO cesnkb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mistře, Mojžíš nám napsal: ‘Kdyby zemřel něčí bratr, který měl manželku, a zemřel by bezdětný, ať si tu ženu vezme jeho bratr a vzbudí svému bratru potomka.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bylo tedy sedm bratrů. První se oženil a zemřel bezdětný. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A tak si tu ženu vzal druhý a i ten zemřel bezdětný. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Potom si ji vzal třetí a stejně tak i všech sedm; nezanechali děti a zemřeli. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Poslední ze všech pak zemřela i ta žena. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kterého z nich tedy bude manželkou při vzkříšení? Vždyť ji mělo za manželku všech sedm!” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ježíš jim však odpověděl: “Synové tohoto věku se žení a vdávají. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ale ti, kteří jsou hodni dosáhnout onoho věku a vzkříšení z mrtvých, se nebudou ženit ani vdávat. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nebudou už totiž ani moci zemřít, neboť jsou rovni andělům. A jsou synové Boží, poněvadž jsou synové vzkříšení. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A že mrtví vstávají, ukázal i Mojžíš u toho keře, když Pána nazývá Bohem Abrahama, Bohem Izáka a Bohem Jákoba. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bůh není Bohem mrtvých, ale živých, neboť jemu jsou živi všichni.” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Někteří ze zákoníků tedy odpověděli: “Mistře, to jsi řekl dobře.” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A už se ho neodvažovali na nic ptát. ");
INSERT INTO cesnkb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Potom jim řekl: “Jak mohou říkat, že Kristus je Davidův syn? ");
INSERT INTO cesnkb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sám David říká v knize Žalmů: ‘Pán řekl mému Pánu: Seď po mé pravici, ");
INSERT INTO cesnkb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dokud nepoložím tvé nepřátele za podnož tvých nohou.’ ");
INSERT INTO cesnkb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David ho tedy nazývá Pánem. Jak to potom může být jeho syn?” ");
INSERT INTO cesnkb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A když všechen lid naslouchal, řekl svým učedníkům: ");
INSERT INTO cesnkb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Varujte se zákoníků, kteří se chtějí procházet ve slavnostních pláštích a mají rádi zdravení na tržištích a přední sedadla ve shromážděních a čestná místa při večeřích, ");
INSERT INTO cesnkb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","kteří vyjídají domy vdov a předstírají dlouhé modlitby. Ti dostanou těžší rozsudek.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","A když vzhlédl, spatřil bohaté, jak házejí své dary do pokladnice. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tehdy spatřil také jednu chudou vdovu, jak tam hází dva haléřky, ");
INSERT INTO cesnkb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","a řekl: “Vpravdě vám říkám, že tato chudá vdova dala ze všech nejvíce. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Všichni totiž dávali dary Bohu ze svého nadbytku, ale tato žena dala ze svého nedostatku všechno živobytí, které měla.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A když někteří říkali o chrámu, jak je ozdoben pěkným kamením a obětními dary, řekl: ");
INSERT INTO cesnkb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Přijdou dny, kdy z toho, na co se díváte, nebude ponechán kámen na kameni: všechno bude zbořeno.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Zeptali se ho tedy: “Mistře, kdy to bude? A jaké bude znamení času, kdy se to má stát?” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","On pak řekl: “Dejte pozor, abyste nebyli svedeni. Mnozí totiž přijdou pod mým jménem a budou říkat: ‘Já jsem Kristus’ a ‘Čas se přiblížil.’ Nechoďte tedy za nimi. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kdybyste pak uslyšeli o válkách a nepokojích, neděste se; neboť se to musí nejdříve dít, ale konec nebude hned.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tehdy jim řekl: “Povstane národ proti národu a království proti království. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na různých místech budou veliká zemětřesení, hlady a mory a budou hrůzy a veliká znamení z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ale před tím vším na vás vztáhnou ruce a budou vás pronásledovat. Budou vás vydávat do shromáždění a vězení a kvůli mému jménu vás povedou před krále a vládce. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ale to se vám obrátí ve svědectví. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Proto uložte ve svých srdcích, abyste si předem nerozmýšleli, jak máte odpovídat, ");
INSERT INTO cesnkb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","neboť já vám dám ústa i moudrost, proti které nebude moci mluvit ani obstát žádný z vašich protivníků. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Budete však zrazováni i od rodičů a bratrů, od příbuzných i přátel a některé z vás vydají na smrt. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A všichni vás budou kvůli mému jménu nenávidět, ");
INSERT INTO cesnkb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ale ani vlas z vaší hlavy se rozhodně neztratí. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Svou vytrvalostí získejte své duše.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Když však spatříte Jeruzalém obležený vojskem, tehdy vězte, že se přiblížilo jeho zpustošení. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tehdy ať ti, kdo jsou v Judsku, utíkají do hor a ti uprostřed něj ať vyjdou a ti, kdo jsou na venkově, ať do něho nevcházejí. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Neboť to budou dny pomsty, aby se naplnilo všechno, co je napsáno. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ale běda bude v těch dnech těhotným a těm, které kojí, protože na zemi bude veliká tíseň a hněv proti tomuto lidu. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A budou padat ostřím meče a jako zajatci budou odvedeni mezi všechny národy a po Jeruzalému budou šlapat pohané, dokud se časy pohanů nenaplní.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Tehdy budou znamení na slunci a na měsíci a na hvězdách a na zemi úzkost národů nevědoucích kam se podět před řvaním moře a vlnobitím. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lidé budou zmírat strachem a očekáváním toho, co přijde na svět, neboť nebeské mocnosti budou otřeseny. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A tehdy spatří Syna člověka, jak přichází v oblaku s mocí a velikou slávou. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A až se toto začne dít, vzpřimte se a pozvedněte hlavy, protože se blíží vaše vykoupení.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tehdy jim řekl podobenství: “Pohleďte na fíkovník i na všechny stromy. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Když vidíte, jak už pučí, sami poznáváte, že léto už je blízko. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tak i vy, až uvidíte, jak se dějí tyto věci, vězte, že Boží království je blízko. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Amen, říkám vám, že toto pokolení rozhodně nepomine, než se toto všechno stane. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nebe a země pominou, ale má slova nikdy nepominou.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ale dávejte na sebe pozor, aby vaše srdce nebyla obtěžkána hodováním a opilstvím a staráním se o tento život a ten den by na vás přišel nečekaně. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Neboť přijde jako past na všechny, kdo přebývají na povrchu celé země. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Proto bděte a modlete se v každý čas, abyste byli hodni uniknout všemu tomu, co se má dít, a postavit se před Synem člověka.” ");
INSERT INTO cesnkb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","A tak ve dne učíval v chrámu, ale v noci vycházel a zůstával na hoře zvané Olivetská. ");
INSERT INTO cesnkb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Za úsvitu pak k němu v chrámu přicházel všechen lid, aby ho poslouchal. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Blížil se tedy svátek nekvašených chlebů, zvaný Veliká noc. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Velekněží a zákoníci tedy hledali způsob, jak by ho zabili, neboť se báli lidu. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tehdy vstoupil Satan do Jidáše příjmením Iškariotského, který byl z počtu těch dvanácti. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ten odešel a smluvil se s velekněžími a s veliteli chrámové stráže, jak by jim ho zradil. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ti se zaradovali a domluvili se s ním, že mu dají peníze. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Souhlasil tedy a začal hledat příležitost, aby jim ho zradil někde mimo zástup. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tehdy přišel den nekvašených chlebů, ve kterém měl být zabit beránek. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Poslal tedy Petra a Jana se slovy: “Jděte a připravte nám Hod beránka, abychom pojedli.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A oni mu řekli: “Kde chceš, ať ho připravíme?” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Řekl jim tedy: “Hleďte, až vejdete do města, potká vás člověk, který ponese džbán vody. Jděte za ním do domu, do kterého vejde, ");
INSERT INTO cesnkb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","a řekněte hospodáři toho domu: ‘Mistr ti vzkazuje: Kde je místnost, v níž bych se svými učedníky pojedl beránka?’ ");
INSERT INTO cesnkb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","On vám pak ukáže velikou horní místnost prostřenou k jídlu. Tam připravte večeři. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Když tedy odešli, našli všechno tak, jak jim řekl, a připravili beránka. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A když přišla ta chvíle, posadil se za stůl a dvanáct apoštolů s ním. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tehdy jim řekl: “Toužebně jsem si přál jíst s vámi tohoto beránka předtím, než budu trpět; ");
INSERT INTO cesnkb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","neboť vám říkám, že už ho nebudu jíst, dokud nedojde naplnění v Božím království.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A když vzal kalich, vzdal díky a řekl: “Vezměte jej a rozdělte mezi sebou; ");
INSERT INTO cesnkb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","neboť vám říkám, že už nebudu pít z plodu vinného kmene, dokud nepřijde Boží království.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A když vzal chléb, vzdal díky, rozlomil a dal jim ho se slovy: “To je mé tělo, které se dává za vás. To dělejte na mou památku.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tak vzal i kalich, když bylo po večeři, a řekl: “Tento kalich je ta nová smlouva v mé krvi, která se prolévá za vás. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ale pohleďte, ruka mého zrádce je se mnou na stole. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Syn člověka jde vskutku tak, jak je určeno, ale běda člověku, jímž je zrazován.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A oni se začali mezi sebou dohadovat, kdo z nich že je ten, který se to chystá udělat. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tehdy také mezi nimi nastal spor, kdo z nich se zdá být největší. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","On jim však řekl: “Králové národů nad nimi panují a ti, kdo nad nimi užívají moci, jsou nazýváni dobrodinci. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ale vy to tak nedělejte. Naopak, kdo je mezi vámi největší, ať je jako nejmenší, a kdo je vůdce, jako ten, který slouží. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Neboť kdo je větší - ten, který sedí, nebo ten, který slouží? Zdali ne ten, který sedí? Ale já jsem mezi vámi jako ten, který slouží. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Vy jste se mnou zůstali v mých zkouškách ");
INSERT INTO cesnkb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","a já vám odkazuji království, jako ho můj Otec odkázal mně, ");
INSERT INTO cesnkb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","abyste jedli a pili za mým stolem v mém království a seděli na trůnech a soudili dvanáct pokolení Izraele.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tehdy Pán řekl: “Šimone, Šimone, hle, Satan si vyžádal, aby vás tříbil jako pšenici. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Já jsem ale za tebe prosil, aby tvá víra nepřestala. A ty, až se jednou obrátíš, posiluj své bratry.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A on mu řekl: “Pane, s tebou jsem připraven jít i do vězení, i na smrt!” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","On však odpověděl: “Říkám ti, Petře, dnes se kohout neozve, dokud třikrát nezapřeš, že mě znáš.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tehdy jim řekl: “Když jsem vás poslal bez měšce, mošny a bez obuvi, měli jste snad v něčem nedostatek?” A oni řekli: “V ničem.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Řekl jim tedy: “Ale teď, kdo má měšec, ať si ho vezme, podobně i mošnu; a kdo nemá, ať prodá svůj plášť a koupí si meč. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Říkám vám totiž, že se na mně musí splnit ještě toto Písmo: ‘Byl započten mezi zločince.’ Neboť to, co je napsáno o mně, se naplňuje.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oni tedy řekli: “Pane, pohleď, zde jsou dva meče. “A on jim řekl: “To stačí.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Když pak vyšel ven, šel podle svého zvyku na Olivetskou horu a šli za ním i jeho učedníci. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","A když přišel na místo, řekl jim: “Modlete se, abyste nevešli do pokušení.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sám se pak od nich vzdálil asi co by kamenem dohodil, poklekl na kolena a modlil se: ");
INSERT INTO cesnkb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Otče, pokud chceš, odejmi ode mne tento kalich; ať se však nestane má vůle, ale tvá!” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tehdy se mu ukázal anděl z nebe a posiloval ho. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Modlil se tedy ve smrtelném zápase ještě horlivěji a jeho pot začal být jako krůpěje krve stékající na zem. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Když potom vstal od modlitby a přišel k učedníkům, nalezl je spící zármutkem. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Řekl jim: “Jak to, že spíte? Vstaňte a modlete se, abyste nevešli do pokušení.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A když ještě mluvil, hle, zástup a jeden ze dvanácti, jménem Jidáš, šel před nimi a přiblížil se k Ježíši, aby ho políbil. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ježíš mu však řekl: “Jidáši, polibkem zrazuješ Syna člověka?” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Když tedy ti okolo něj uviděli, k čemu se schyluje, řekli mu: “Pane, máme se bít mečem?” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jeden z nich zasáhl otroka nejvyššího kněze a usekl mu pravé ucho. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ježíš však odpověděl: “Nechte už toho!” A dotkl se jeho ucha a uzdravil ho. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tehdy Ježíš řekl těm velekněžím a velitelům chrámové stráže a starším, kteří na něj přišli: “Vypravili jste se jako na zločince, s meči a holemi? ");
INSERT INTO cesnkb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Každý den jsem s vámi býval v chrámu a nevztáhli jste na mě ruce. Ale toto je vaše hodina a vláda temnoty.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A když ho zajali, vedli ho a přivedli do domu nejvyššího kněze. Petr ho ale zpovzdálí následoval, ");
INSERT INTO cesnkb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","a když uprostřed dvora zapálilioheň a společně se posadili, seděl Petr mezi nimi. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jedna služebná si ho všimla, jak sedí u ohně, upřeně se na něj podívala a řekla: “Tenhle byl také s ním.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ale on ho zapřel. Řekl: “Ženo, já ho neznám!” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A když si ho po malé chvíli všiml jiný, řekl: “Ty jsi také jeden z nich.” Petr však řekl: “Člověče, nejsem!” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Když potom uplynula asi jedna hodina, začal někdo jiný tvrdit: “Opravdu, tenhle s ním byl také! Vždyť je také Galilejec!” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petr však řekl: “Člověče, nevím, o čem mluvíš!” A vtom, když ještě mluvil, zakokrhal kohout ");
INSERT INTO cesnkb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","a Pán se obrátil a pohlédl na Petra. Tehdy se Petr rozpomenul na Pánovo slovo, jak mu řekl: “Dříve než se ozve kohout, třikrát mě zapřeš.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A Petr vyšel ven a hořce se rozplakal. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A ti muži, kteří hlídali Ježíše, se mu posmívali a tloukli ho. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Zahalili ho a bili ho do tváře a ptali se ho: “Prorokuj! Kdo tě udeřil?” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A mluvili proti němu mnoho jiného a rouhali se. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jakmile pak nastal den, sešli se starší lidu, velekněží i zákoníci a odvedli ho do své velerady ");
INSERT INTO cesnkb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","se slovy: “Jestliže jsi Kristus, řekni nám to!” Ale on jim odpověděl: “Kdybych vám to řekl, stejně neuvěříte. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A kdybych se vás zeptal, stejně mi neodpovíte ani mě nepropustíte. ");
INSERT INTO cesnkb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Od nynějška bude Syn člověka sedět po pravici Boží moci.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tehdy všichni řekli: “Takže ty jsi Boží Syn?” Ale on jim odpověděl: “Vy to říkáte, protože já jsem.” ");
INSERT INTO cesnkb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Řekli tedy: “Nač ještě potřebujeme svědectví? Vždyť jsme to sami slyšeli z jeho úst!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tehdy jich celé množství povstalo, odvedli ho k Pilátovi ");
INSERT INTO cesnkb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","a začali ho obviňovat. Říkali: “Nalezli jsme tohoto muže, jak rozvrací národ a brání dávat daně císaři a nazývá se Kristem králem. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilát se ho tedy zeptal: “Ty jsi ten židovský král?” Ale on mu odpověděl: “Ty to říkáš.” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilát tedy řekl velekněžím a zástupům: “Žádnou vinu na tomto člověku nenacházím.” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ale oni tím více naléhali a říkali: “Bouří lid! Učí po celém Judsku počínaje od Galileje až sem!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Když tedy Pilát uslyšel o Galileji, zeptal se, zda je ten člověk Galilejec. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A když se dozvěděl, že je z Herodova panství, poslal ho k Herodovi, který v těch dnech byl také v Jeruzalémě. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A když Herodes spatřil Ježíše, velice se zaradoval. Dávno ho totiž toužil vidět, protože o něm hodně slyšel, a doufal, že uvidí nějaký zázrak, který Ježíš udělá. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Vyptával se ho tedy mnohými slovy, ale on mu nic neodpověděl. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Stáli tam však velekněží a zákoníci a usilovně ho obviňovali. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A tak jím Herodes se svými vojáky pohrdl, a když se mu dost naposmíval, oblékl ho do skvostného roucha a poslal ho zpět k Pilátovi. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A toho dne se Pilát a Herodes spřátelili; předtím totiž byli spolu v nepřátelství. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tehdy Pilát svolal velekněze a přední muže i lid ");
INSERT INTO cesnkb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a řekl jim: “Přivedli jste mi tohoto člověka jako rozvraceče lidu; a hle, já jsem ho před vámi vyslechl a nenašel jsem na tom člověku žádnou vinu v tom, z čeho ho obviňujete. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Dokonce ani Herodes ne, neboť jsem vás poslal k němu. Pohleďte, nespáchal nic, za co by si zasloužil smrt! ");
INSERT INTO cesnkb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Proto ho napomenu a propustím.” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Ve svátek jim totiž musel propouštět jednoho vězně.) ");
INSERT INTO cesnkb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ale všichni společně vykřikli: “Odstraň tohoto a propusť nám Barabáše!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ten byl vsazen do vězení za nějakou vzpouru, která vznikla ve městě, a za vraždu.) ");
INSERT INTO cesnkb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilát k nim tedy znovu promluvil, protože chtěl propustit Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ale oni křičeli: “Ukřižuj, ukřižuj ho!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","On jim tedy řekl potřetí: “Ale co tento muž udělal zlého? Nenašel jsem na něm žádnou smrtelnou vinu. Proto ho napomenu a propustím!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ale oni naléhali velikým křikem a dožadovali se, aby byl ukřižován. A jejich hlasy i hlasy velekněží sílily. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilát tedy rozhodl, aby se stalo podle jejich žádosti, ");
INSERT INTO cesnkb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","a propustil jim toho, který byl vsazen do vězení za vzpouru a vraždu, o něhož žádali, ale Ježíše vydal jejich vůli. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A když ho odváděli, chytili nějakého Šimona Kyrénského, který šel z pole, a naložili mu kříž, aby ho nesl za Ježíšem. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Šlo za ním veliké množství lidu i ženy, které nad ním plakaly a naříkaly. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ježíš se k nim obrátil a řekl: “Dcery jeruzalémské, neplačte nade mnou, ale plačte nad sebou a nad svými dětmi. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Neboť hle, přicházejí dny, kdy řeknou: ‘Blaze neplodným a lůnům, která nerodila, a prsům, které nekojily!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tehdy začnou říkat horám: ‘Padněte na nás!’ A kopcům: ‘Přikryjte nás!’ ");
INSERT INTO cesnkb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Když se totiž toto děje zelenému stromu, co se stane se suchým?” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A k popravě s ním byli vedeni ještě dva jiní, zločinci. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Když pak přišli na místo zvané Lebka, ukřižovali ho tam, i ty zločince - jednoho po pravici a druhého po levici. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tehdy Ježíš řekl: “Otče, odpusť jim, vždyť nevědí, co dělají!” A když si dělili jeho šaty, házeli o ně los. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lidé tam stáli a dívali se; a s nimi se mu vysmívali také přední muži, kteří říkali: “Jiné spasil, tak ať spasí sám sebe, jestliže je to Kristus, ten Boží Vyvolený!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A vojáci se mu posmívali také. Přistupovali, nabízeli mu ocet ");
INSERT INTO cesnkb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","a říkali: “Jestli jsi ten židovský král, zachraň sám sebe!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Byl nad ním také nápis, napsaný řeckými, latinskými a hebrejskými písmeny: “TOTO JE ŽIDOVSKÝ KRÁL.” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A jeden z těch zločinců, kteří viseli s ním, mu spílal a říkal: “Jestliže jsi Kristus, zachraň sám sebe i nás!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ale ten druhý mu odpověděl a káral ho slovy: “Ty se ani Boha nebojíš? Vždyť jsi ve stejném odsouzení! ");
INSERT INTO cesnkb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","A my jistě trpíme spravedlivě, protože dostáváme, co si za své skutky zasloužíme, ale tenhle nic zlého neudělal.” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tehdy řekl Ježíši: “Pane, vzpomeň si na mě, až přijdeš ve svém království.” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ježíš mu odpověděl: “Amen, říkám ti, dnes budeš se mnou v ráji.” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A bylo okolo šesté hodiny. Tehdy nastala po celé zemi tma až do deváté hodiny. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A slunce se zatmělo a chrámová opona se roztrhla uprostřed. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tehdy Ježíš hlasitě vykřikl: “Otče, do tvých rukou svěřuji svého ducha.” A když to řekl, vydechl naposled. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Když tedy setník uviděl, co se stalo, vzdal slávu Bohu se slovy: “Tento člověk byl jistě spravedlivý!” ");
INSERT INTO cesnkb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A všechny zástupy, které se sešly k té podívané, se při pohledu na to, co se stalo, bily do prsou a vracely se zpět. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ale všichni jeho známí, i ženy, které ho doprovázely z Galileje, stáli opodál a viděli to. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","A hle, muž jménem Josef, člen rady (dobrý a spravedlivý muž, ");
INSERT INTO cesnkb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","který nesouhlasil s radou a jejím činem), z judského města Arimatie, jenž sám také očekával Boží království, ");
INSERT INTO cesnkb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ten přišel k Pilátovi a požádal o Ježíšovo tělo. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sňal je, zavinul do plátna a pochoval ho do vytesané hrobky, ve které ještě nebyl nikdo pochován. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","(A byl den připravování a začínala sobota.) ");
INSERT INTO cesnkb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Přidaly se také ženy, které s ním přišly z Galileje, a podívaly se na hrob a na to, jak bylo pochováno jeho tělo. ");
INSERT INTO cesnkb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Když se pak vrátily, připravily vonné látky a masti, ale v sobotu podle přikázání zachovaly klid. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Prvního dne týdne pak šly spolu s některými jinými brzy ráno k hrobu a nesly vonné masti, které připravily. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nalezly však kámen odvalený od hrobu, ");
INSERT INTO cesnkb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","a když vešly dovnitř, nenašly tělo Pána Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A když nad tím byly bezradné, hle, stalo se, že se k nim postavili dva muži v zářícím rouchu. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ale když se ulekly a sklonily tváře k zemi, řekli jim: “Proč hledáte živého mezi mrtvými? ");
INSERT INTO cesnkb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Není tu, ale vstal! Vzpomeňte si, jak k vám mluvil, když byl ještě v Galileji. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Řekl: ‘Syn člověka musí být vydán do rukou hříšných lidí a být ukřižován a třetího dne vstát z mrtvých.’” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tehdy si vzpomněly na jeho slova, ");
INSERT INTO cesnkb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","a když se vrátily od hrobu, oznámily to všechno těm jedenácti i všem ostatním. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A ty, které to řekly apoštolům, byly Marie Magdaléna a Johana a Marie Jakubova a ostatní, které byly s nimi. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Oni ale měli jejich slova za tlachání a nevěřili jim. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petr však vstal a běžel k hrobu, a když se naklonil dovnitř, spatřil plátna, ležící sama. Odešel tedy a sám pro sebe se divil, co se stalo. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A hle, dva z nich šli toho dne do vesnice jménem Emauzy, která byla vzdálená šedesát honů od Jeruzaléma, ");
INSERT INTO cesnkb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","a hovořili spolu o tom všem, co se přihodilo. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A když takto hovořili a uvažovali, stalo se, že sám Ježíš se přiblížil a šel s nimi. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ale jejich oči byly drženy, aby ho nepoznali. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Řekl jim tedy: “Co je to za věci, o kterých spolu cestou rozmlouváte a jste smutní?” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jeden z nich, jménem Kleofáš, mu odpověděl: “Ty jsi jediný cizinec v Jeruzalémě, že ses nedozvěděl o tom, co se tam v těchto dnech stalo?” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A on jim řekl: “O čem?” Řekli mu tedy: “O Ježíši Nazaretském, který byl prorok, muž mocný ve skutku i slovu před Bohem i přede vším lidem; ");
INSERT INTO cesnkb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","jak ho velekněží a naši představení vydali k odsouzení na smrt a ukřižovali ho. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","My jsme však doufali, že to je on, kdo má vykoupit Izrael. A k tomu všemu je to dnes už třetí den, co se to stalo. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ale i některé z našich žen nás ohromily. Byly ráno u hrobu, ");
INSERT INTO cesnkb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","a když nenašly jeho tělo, přišly a říkaly, že měly dokonce vidění andělů, kteří řekli, že žije. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Někteří z našich tedy šli ke hrobu a našli všechno tak, jak řekly ženy, ale jeho neviděli.” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","On jim tedy řekl: “nechápaví a srdcem pomalí věřit všemu tomu, co mluvili proroci! ");
INSERT INTO cesnkb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Copak Kristus nemusel vytrpět tyto věci a vejít do své slávy?” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A počínaje od Mojžíše a všech proroků vykládal jim ve všech Písmech, co bylo o něm. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tehdy se přiblížili k vesnici, do které šli, a on naznačil, že půjde dál. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Oni však na něj naléhali: “Zůstaň s námi, vždyť se už připozdívá a den se nachýlil.” A tak šel dovnitř, aby s nimi zůstal. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A když s nimi byl za stolem, stalo se, že vzal chléb, požehnal, rozlomil ho a podával jim. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tehdy se jejich oči otevřely a poznali ho, ale on zmizel jejich očím. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tehdy řekli jeden druhému: “Copak v nás naše srdce nehořelo, když k nám mluvil po cestě a otvíral nám Písma?” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","V tu chvíli tedy vstali a vrátili se do Jeruzaléma a našli shromážděných těch jedenáct i ty, kteří byli s nimi, ");
INSERT INTO cesnkb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","jak říkají: “Pán byl opravdu vzkříšen a ukázal se Šimonovi!” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A oni vyprávěli, co se stalo na cestě a jak se jim dal poznat při lámání chleba. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","A když o tom mluvili, postavil se uprostřed nich sám Ježíš a řekl jim: “Pokoj vám.” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ale oni se vyděsili a ve strachu se domnívali, že vidí ducha. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Řekl jim tedy: “Proč jste rozrušeni? A proč ve vašich srdcích povstávají pochybnosti? ");
INSERT INTO cesnkb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pohleďte na mé ruce a mé nohy, že jsem to já. Dotkněte se mě a podívejte se: duch přece nemá maso a kosti, jako vidíte, že já mám.” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A když to řekl, ukázal jim ruce i nohy. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Když ale ještě pro radost nemohli uvěřit a divili se, řekl jim: “Máte tu něco k jídlu?” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Podali mu tedy kus pečené ryby a plást medu. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","A on si vzal a pojedl před nimi. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tehdy jim řekl: “Toto jsou slova, která jsem k vám mluvil, když jsem ještě byl s vámi, že se musí naplnit všechno, co je o mně napsáno v Mojžíšově zákoně, v Prorocích a v Žalmech.” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tehdy jim otevřel mysl, aby rozuměli Písmům, ");
INSERT INTO cesnkb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","a řekl jim: “Tak je to napsáno a tak musel Kristus trpět a třetího dne vstát z mrtvých ");
INSERT INTO cesnkb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","a v jeho jménu musí být kázáno pokání a odpuštění hříchů všem národům počínaje od Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A vy jste toho svědkové. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A hle, já na vás pošlu zaslíbení svého Otce. Vy však zůstaňte ve městě Jeruzalémě, dokud nebudete oblečeni mocí shůry.” ");
INSERT INTO cesnkb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Potom je odvedl ven, až k Betanii. Tam zvedl ruce a požehnal jim. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A zatímco jim žehnal, stalo se, že se od nich vzdaloval a byl nesen vzhůru do nebe. ");
INSERT INTO cesnkb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A když se mu poklonili, vrátili se s velikou radostí do Jeruzaléma ");
INSERT INTO cesnkb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","a byli stále v chrámu, kde chválili a oslavovali Boha. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na počátku bylo Slovo a to Slovo bylo u Boha a to Slovo byl Bůh. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","To bylo na počátku u Boha. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Všechny věci povstaly skrze něj a bez něho nepovstalo nic, co je. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","V něm byl život a ten život byl světlo lidí. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A to světlo svítí ve tmě, ale tma ho nepohltila. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Byl člověk poslaný od Boha, jehož jméno bylo Jan. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ten přišel na svědectví, aby svědčil o tom Světle, aby skrze něho všichni uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","On nebyl to Světlo, ale přišel, aby o tom Světle vydal svědectví. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tento byl to pravé Světlo, které osvětluje každého člověka přicházejícího na svět. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Byl na světě a svět povstal skrze něj, ale svět ho nepoznal. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Přišel do svého vlastního a jeho vlastní ho nepřijali. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ale všem, kteří ho přijali, dal moc stát se Božími syny, totiž těm, kteří věří v jeho jméno, ");
INSERT INTO cesnkb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","kteří jsou zrozeni ne z krve, ani z vůle těla, ani z vůle muže, ale z Boha. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A to Slovo se stalo tělem a přebývalo mezi námi (a viděli jsme jeho slávu, slávu jakou má Jednorozený od Otce), plné milosti a pravdy. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jan o něm vydával svědectví a volal: “Toto je ten, o němž jsem řekl: Ten, který přichází za mnou, je přede mnou, neboť byl dříve než já.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A my všichni jsme vzali z jeho plnosti, a to milost za milost. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Neboť Zákon byl dán skrze Mojžíše, ale milost a pravda se stala skrze Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Boha nikdy nikdo neviděl; jednorozený Syn, který je v Otcově náručí, ten ho vylíčil. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A toto je Janovo svědectví: Když Židé poslali kněze a levíty z Jeruzaléma, aby se ho zeptali: “Kdo jsi?” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tehdy to vyznal a nezapřel. Vyznal: “Já nejsem Kristus.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Zeptali se ho: “Kdo tedy? Jsi Eliáš?” A on řekl: “Nejsem.” “Jsi ten Prorok?” A odpověděl: “Ne.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Řekli mu tedy: “Kdo jsi? Ať můžeme dát odpověď těm, kteří nás poslali. Co říkáš sám o sobě?” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tehdy řekl: “Já jsem ‘hlas volajícího na poušti: Srovnejte Pánovu cestu!’ jak řekl prorok Izaiáš.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A ti, kteří byli posláni, byli z farizeů. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Zeptali se ho tedy a řekli mu: “Proč tedy křtíš, když nejsi Kristus ani Eliáš ani ten Prorok?” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jan jim odpověděl: “Já křtím vodou, ale uprostřed vás stojí ten, koho vy neznáte. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","To je ten, který přichází po mně, ale je přede mnou. Jemu nejsem hoden ani rozvázat řemínek sandálu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Toto se stalo v Betabaře za Jordánem, kde Jan křtil. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Druhého dne spatřil Jan Ježíše, jak přichází k němu, a řekl: “Hle, Beránek Boží, který snímá hřích světa! ");
INSERT INTO cesnkb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","To je ten, o němž jsem řekl: Po mně přichází muž, který je přede mnou, neboť byl dříve než já. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","A já jsem ho neznal, ale přišel jsem křtít vodou proto, aby byl zjeven Izraeli.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jan tedy vydal svědectví: “Viděl jsem Ducha, jak sestoupil jako holubice z nebe a zůstal na něm. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Já jsem ho neznal, ale Ten, který mě poslal křtít vodou, mi řekl: ‘Na koho spatříš sestoupit Ducha a zůstat na něm, to je ten, který křtí Duchem Svatým.’ ");
INSERT INTO cesnkb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A já jsem to viděl a vydal jsem svědectví, že on je ten Boží Syn.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Druhého dne tam Jan znovu stál se dvěma ze svých učedníků. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Když spatřil Ježíše, jak se prochází, řekl: “Hle, Beránek Boží.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","A ti dva učedníci ho slyšeli, když to říkal, a odešli za Ježíšem. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A když se Ježíš obrátil a spatřil je, jak jdou za ním, řekl jim: ");
INSERT INTO cesnkb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Co hledáte?” A oni mu řekli: “Rabbi” (což se překládá: Mistře), “kde bydlíš?” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Řekl jim: “Pojďte a podívejte se.” Šli tedy a viděli, kde bydlí, a ten den zůstali u něho. (A bylo okolo desáté hodiny.) ");
INSERT INTO cesnkb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jeden z těch dvou, kteří to od Jana slyšeli a následovali ho, byl Ondřej, bratr Šimona Petra. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ten první nalezl svého bratra Šimona a řekl mu: “Našli jsme Mesiáše!” (což je v překladu Kristus). ");
INSERT INTO cesnkb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A přivedl ho k Ježíši. Když na něj Ježíš pohlédl, řekl: “Ty jsi Šimon, syn Jonášův. Budeš se jmenovat Kéfas” (což se překládá Petr). ");
INSERT INTO cesnkb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Druhého dne se Ježíš chtěl vydat do Galileje. Nalezl Filipa a řekl mu: “Pojď za mnou.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip pak byl z Betsaidy, města Ondřejova a Petrova. ");
INSERT INTO cesnkb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Filip našel Natanaele a řekl mu: “Našli jsme toho, o kterém psal Mojžíš v Zákoně a proroci - Ježíše, syna Josefova z Nazaretu!” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael mu však řekl: “Může být z Nazaretu něco dobrého?” Filip mu řekl: “Pojď a podívej se.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Když Ježíš uviděl Natanaele, jak jde k němu, řekl o něm: “Hle, opravdový Izraelita, v němž není žádná lest!” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael mu řekl: “Odkud mne znáš?” Ježíš mu odpověděl: “Viděl jsem tě dříve, než tě Filip zavolal, když jsi byl pod fíkovníkem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Natanael mu odpověděl: “Rabbi, ty jsi Boží Syn, ty jsi král Izraele!” ");
INSERT INTO cesnkb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ježíš mu odpověděl: “Věříš proto, že jsem ti řekl: Viděl jsem tě pod fíkovníkem? Uvidíš větší věci než tyto.”  (John 1:52) A řekl mu: “Amen, amen, říkám vám: Od nynějška uvidíte otevřené nebe a Boží anděly, jak vystupují a sestupují na Syna člověka.”  ");
INSERT INTO cesnkb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Třetího dne pak byla svatba v Káně Galilejské a byla tam Ježíšova matka. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na svatbu byl pozván také Ježíš a jeho učedníci. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","A když došlo víno, řekla Ježíši jeho matka: “Nemají víno.” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ježíš jí řekl: “Ženo, co mám já s tebou? Moje hodina ještě nepřišla.” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jeho matka řekla služebníkům: “Udělejte, cokoli by vám řekl.” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A stálo tam šest kamenných nádob na vodu k židovskému očišťování, každá o obsahu dvou nebo tří měr. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ježíš jim řekl: “Naplňte ty nádoby vodou.” Naplnili je tedy až po okraj. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Potom jim řekl: “Teď nalijte a doneste vrchnímu správci svatby.” A donesli. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jakmile vrchní správce svatby okusil tu vodu, z níž se stalo víno (a nevěděl, odkud je, ale služebníci, kteří tu vodu nalévali, věděli), zavolal ten vrchní správce ženicha ");
INSERT INTO cesnkb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a řekl mu: “Každý člověk podává nejdříve dobré víno, a když jsou hosté opilí, tehdy to horší. Ty jsi zachoval dobré víno až doteď.” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tím udělal Ježíš v Káně Galilejské počátek zázraků a zjevil svou slávu. A jeho učedníci v něho uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Potom sestoupil do Kafarnaum, on, jeho matka, jeho bratři i jeho učedníci; a zůstali tam několik dní. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tehdy byla blízko židovská Veliká noc. Ježíš tedy přišel do Jeruzaléma ");
INSERT INTO cesnkb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","a v chrámu nalezl prodavače volů, ovcí a holubic a směnárníky sedící za stoly. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Udělal si tedy bič z provázků a všechny z chrámu vyhnal, i ovce a voly, a směnárníkům rozsypal peníze a zpřevracel jim stoly. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A těm, kteří prodávali holubice, řekl: “Odneste to odsud! Nedělejte dům mého Otce domem kupectví!” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tehdy si jeho učedníci vzpomněli, že je napsáno: “Horlivost pro tvůj dům mne pohltila.” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Židé tedy odpověděli a řekli mu: “Jaké nám ukážeš znamení, když děláš tyto věci?” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ježíš jim odpověděl: “Zbořte tento chrám a ve třech dnech ho postavím.” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A Židé řekli: “Čtyřicet šest let se stavěl tento chrám a ty ho postavíš za tři dny?” ");
INSERT INTO cesnkb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","On však mluvil o chrámu svého těla. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Proto když vstal z mrtvých, jeho učedníci si vzpomněli, že jim to říkal. A uvěřili Písmu a slovu, které Ježíš řekl. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","A když byl na Velikou noc v Jeruzalémě, mnozí během toho svátku uvěřili v jeho jméno, když viděli zázraky, které dělal. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ale Ježíš se jim nesvěřoval, protože on znal všechny. ");
INSERT INTO cesnkb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A nepotřeboval, aby někdo vydával o člověku svědectví, neboť on věděl, co je v člověku. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mezi farizeji pak byl člověk jménem Nikodém, židovský hodnostář. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ten přišel k Ježíši v noci a řekl mu: “Rabbi, víme, že jsi přišel jako učitel od Boha, neboť nikdo nemůže dělat znamení, která děláš ty, není-li Bůh s ním.” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ježíš mu odpověděl a řekl: “Amen, amen, říkám ti: Jestliže se někdo nenarodí znovu, nemůže spatřit Boží království.” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodém mu řekl: “Jak se může člověk narodit, když je starý? Může snad vejít podruhé do lůna své matky a narodit se?” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ježíš odpověděl: “Amen, amen, říkám ti: Jestliže se někdo nenarodí z vody a z Ducha, nemůže vejít do Božího království. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Co se narodilo z těla, je tělo, a co se narodilo z Ducha, je duch. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nediv se, že jsem ti řekl: Musíte se znovu narodit. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vítr vane, kam chce a slyšíš jeho hlas, ale nevíš, odkud přichází a kam jde. Tak je to s každým, kdo se narodil z Ducha.” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodém mu odpověděl a řekl: “Jak se ty věci mohou stát?” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ježíš mu odpověděl: “Ty jsi učitel Izraele a nevíš to? ");
INSERT INTO cesnkb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Amen, amen, říkám ti, že mluvíme o tom, co známe, a svědčíme o tom, co jsme viděli, ale naše svědectví nepřijímáte. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jestliže nevěříte, když jsem vám říkal pozemské věci, jak uvěříte, budu-li vám říkat nebeské?” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Nikdo nevystoupil do nebe, jen ten, kdo sestoupil z nebe, Syn člověka, který je v nebi. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","A jako Mojžíš vyzdvihl hada na poušti, tak musí být vyzdvižen Syn člověka, ");
INSERT INTO cesnkb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aby žádný, kdo věří v něho, nezahynul, ale měl věčný život. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Neboť Bůh tak miloval svět, že dal svého jednorozeného Syna, aby žádný, kdo věří v něho, nezahynul, ale měl věčný život. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bůh totiž neposlal svého Syna na svět, aby svět odsoudil, ale aby svět byl skrze něho spasen. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kdo v něj věří, není souzen, ale kdo nevěří, je již odsouzen; neboť neuvěřil ve jméno jednorozeného Božího Syna. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A toto je ten soud, že světlo přišlo na svět, ale lidé si více oblíbili tmu nežli světlo, protože jejich skutky byly zlé. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Každý, kdo koná zlo, totiž nenávidí světlo a nepřichází ke světlu, aby jeho skutky nebyly odhaleny. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ale kdo koná pravdu, přichází ke světlu, aby jeho skutky byly zjeveny, že jsou vykonány v Bohu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Potom Ježíš přišel se svými učedníky do judské země a tam s nimi pobýval a křtil. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jan pak také křtil v Ainonu, blízko Sálimu, neboť tam bylo mnoho vody. A lidé přicházeli a byli křtěni. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jan totiž ještě nebyl vsazen do žaláře.) ");
INSERT INTO cesnkb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tehdy mezi některými z Janových učedníků a Židy vyvstala otázka o očišťování. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Přišli tedy k Janovi a řekli mu: “Rabbi, ten, který byl s tebou za Jordánem, o kterém jsi ty vydal svědectví, pohleď, on křtí a všichni přicházejí k němu!” ");
INSERT INTO cesnkb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jan odpověděl: “Člověk nemůže přijmout nic, není-li mu to dáno z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Vy sami jste mi svědky, že jsem řekl: Já nejsem Kristus, ale jsem poslán před ním. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kdo má nevěstu, je ženich, ale přítel ženicha, který stojí a slyší ho, se z ženichova hlasu velmi raduje. Tato má radost se tedy naplnila. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","On musí růst a já se menšit. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kdo přichází shůry, je nade všechny; kdo je ze země, je pozemský a mluví pozemské věci. Ten, který přišel z nebe, je nade všechny. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Svědčí o tom, co viděl a slyšel, ale jeho svědectví nikdo nepřijímá. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kdo přijímá jeho svědectví, zpečetil to, že Bůh je pravdomluvný. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ten, kterého Bůh poslal, mluví Boží slova, neboť Bůh dává Ducha bez omezení. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Otec miluje Syna a všechno dal do jeho rukou. ");
INSERT INTO cesnkb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kdo věří v Syna, má věčný život; kdo ale Synu nevěří, nespatří život a zůstává na něm Boží hněv.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A když se Pán dověděl, že farizeové slyšeli: Ježíš získává a křtí více učedníků než Jan ");
INSERT INTO cesnkb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ačkoli Ježíš sám nekřtil, ale jeho učedníci), ");
INSERT INTO cesnkb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","opustil Judsko a odešel znovu do Galileje. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Musel však projít Samařím. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Přišel tedy k samařskému městu zvanému Sichar, blízko pozemku, který dal Jákob svému synu Josefovi. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tam byla Jákobova studna. Ježíš se tedy, unaven cestou, posadil u té studny. Bylo okolo šesté hodiny. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tehdy přišla žena ze Samaří, aby načerpala vodu. Ježíš jí řekl: “Dej mi napít.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jeho učedníci totiž odešli do města, aby nakoupili jídlo. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ta samařská žena mu tedy řekla: “Jak to, že ty, který jsi Žid, žádáš nápoj ode mne, když jsem Samaritánka?” (Židé se totiž se Samaritány nestýkají.) ");
INSERT INTO cesnkb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ježíš jí odpověděl: “Kdybys znala ten Boží dar, a kdo je ten, který ti říká: ‘Dej mi napít,’ prosila bys ty jeho a dal by ti živou vodu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Žena mu řekla: “Pane, nemáš ani, čím bys čerpal a studna je hluboká. Odkud tedy máš tu živou vodu? ");
INSERT INTO cesnkb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jsi snad větší než náš otec Jákob, který nám tu studnu dal a sám z ní pil, i jeho synové a jeho dobytek?” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ježíš jí odpověděl a řekl: “Každý, kdo pije tuto vodu, bude znovu žíznit. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kdo by se však napil té vody, kterou mu dám já, nebude žíznit navěky, ale ta voda, kterou mu dám, se v něm stane pramenem vody tryskající k věčnému životu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ta žena mu řekla: “Pane, dej mi tu vodu, abych už nežíznila a nechodila sem čerpat.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ježíš jí řekl: “Jdi, zavolej svého muže a přijď sem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Žena odpověděla: “Nemám muže.” Ježíš jí řekl: “Dobře jsi řekla: ‘Nemám muže,’ ");
INSERT INTO cesnkb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","protože jsi měla pět mužů a ten, kterého máš teď, není tvůj muž. To jsi řekla pravdu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Žena mu řekla: “Pane, vidím, že jsi prorok. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naši otcové uctívali Boha na této hoře a vy říkáte, že místo, kde se musí uctívat, je v Jeruzalémě.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ježíš jí řekl: “Ženo, věř mi, že přichází hodina, kdy nebudete uctívat Otce ani na této hoře, ani v Jeruzalémě. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vy uctíváte, co neznáte; my uctíváme, co známe, protože spasení je z Židů. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ale přichází hodina a již je zde, kdy praví uctívači budou uctívat Otce v duchu a pravdě. Takové totiž Otec hledá, aby ho uctívali. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bůh je Duch a ti, kdo ho uctívají, ho musí uctívat v duchu a v pravdě.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Žena mu řekla: “Vím, že přijde Mesiáš” (který je nazýván Kristus). “Ten až přijde, oznámí nám všechno.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ježíš jí řekl: “To jsem já, který s tebou mluvím.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A vtom přišli jeho učedníci a divili se, že mluví se ženou, avšak žádný neřekl: “Co jí chceš?” anebo: “Proč s ní mluvíš?” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ta žena tedy nechala svůj džbán a odešla do města a řekla lidem: ");
INSERT INTO cesnkb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pojďte, podívejte se na člověka, který mi řekl všechno, co jsem udělala. Není to snad Kristus?” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Vyšli tedy z města a šli k němu. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mezitím ho však učedníci prosili: “Rabbi, najez se!” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ale on jim řekl: “Já mám k jídlu pokrm, který vy neznáte.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Učedníci si tedy mezi sebou říkali: “Přinesl mu snad někdo jídlo?” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ježíš jim řekl: “Můj pokrm je, abych konal vůli Toho, který mě poslal, a dokončil jeho dílo. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Neříkáte snad, že jsou ještě čtyři měsíce a potom přijde sklizeň? Hle, říkám vám: Pozvedněte své oči a hleďte na krajiny, že se již bělají ke žni. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ten, kdo sklízí, bere odplatu a shromažďuje úrodu k věčnému životu, aby se i ten, kdo rozsívá, radoval spolu s tím, kdo sklízí. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","V tom je totiž pravdivé to slovo, že ‘jeden rozsívá a jiný sklízí’. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Já jsem vás poslal sklízet to, na čem jste vy nepracovali. Pracovali jiní a vy jste vstoupili do jejich práce.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A mnozí ze Samaritánů z toho města v něho uvěřili kvůli slovu té ženy, která svědčila: “Řekl mi všechno, co jsem udělala.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Když k němu tedy ti Samaritáni přišli, prosili ho, aby u nich zůstal. Zůstal tam tedy dva dny ");
INSERT INTO cesnkb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","a kvůli jeho slovu jich uvěřilo mnohem více. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Té ženě pak řekli: “Už nevěříme jen kvůli tvé řeči; neboť jsme sami slyšeli a víme, že toto je opravdu Spasitel světa, Kristus.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Po dvou dnech pak odtud odešel a vydal se do Galileje. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sám Ježíš měl totiž vydat svědectví, že prorok není ve své vlasti v úctě. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Když tedy přišel do Galileje, Galilejci, kteří viděli všechno, co dělal ve svátek v Jeruzalémě, ho přijali, neboť i oni přišli na ten svátek. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Přišel tedy znovu do Kány Galilejské, kde udělal z vody víno. A tam byl jeden královský úředník, jehož syn byl nemocný v Kafarnaum. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Když uslyšel, že Ježíš přišel z Judska do Galileje, šel k němu a prosil ho, aby sestoupil a uzdravil jeho syna, neboť začínal umírat. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ježíš mu tedy řekl: “Neuvidíte-li znamení a zázraky, nikdy neuvěříte.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Královský úředník mu řekl: “Pane, pojď, než mé dítě umře!” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ježíš mu řekl: “Jdi, tvůj syn žije.” A ten člověk uvěřil slovu, které mu Ježíš řekl, a šel. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A když už byl na cestě, setkali se s ním jeho služebníci a oznamovali mu: “Tvůj syn žije!” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Vyptal se jich tedy na dobu, od které mu bylo lépe, a tak mu řekli: “Včera o sedmé hodině ho opustila horečka.” ");
INSERT INTO cesnkb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Otec tedy poznal, že to bylo v tu chvíli, ve kterou mu Ježíš řekl: “Tvůj syn žije.” A tak uvěřil on i celý jeho dům. ");
INSERT INTO cesnkb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Toto je zase druhý zázrak, který Ježíš udělal, když přišel z Judska do Galileje. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Potom byl židovský svátek a Ježíš přišel do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A v Jeruzalémě je u Ovčí brány rybník hebrejsky zvaný Bethesda, který má pět podloubí. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tam leželo veliké množství nemocných, slepých, chromých a ochrnutých očekávajících pohnutí vody. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Občas totiž sestupoval do rybníka anděl a vířil vodu a ten, kdo po tom zvíření vody do ní vstoupil první, býval uzdraven, ať měl jakoukoli nemoc. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A byl tam jeden člověk, který byl nemocen třicet osm let. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Když ho Ježíš uviděl ležet a poznal, že je už dlouho nemocen, řekl mu: “Chceš být uzdraven?” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ten nemocný mu odpověděl: “Pane, nemám člověka, který by mě snesl do rybníka, když se zvíří voda. Když přicházím, sestupuje přede mnou jiný.” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ježíš mu řekl: “Vstaň, vezmi své lůžko a choď.” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","A ten člověk byl hned uzdraven, vzal své lůžko a chodil. Ten den však byla sobota. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Židé tedy tomu uzdravenému říkali: “Je sobota, není ti dovoleno nosit lůžko!” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","On jim však odpověděl: “Ten, který mě uzdravil, mi řekl: ‘Vezmi své lůžko a choď.’” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Zeptali se ho tedy: “Kdo je ten člověk, který ti řekl: ‘Vezmi své lůžko a choď’?” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ale ten uzdravený nevěděl, kdo to je, protože Ježíš poodešel od zástupu, který byl na tom místě. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Potom ho Ježíš nalezl v chrámu a řekl mu: “Pohleď, jsi uzdraven; už nehřeš, aby se ti nepřihodilo něco horšího.” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ten člověk odešel a oznámil Židům, že ten, kdo ho uzdravil, je Ježíš. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","A tak Židé začali Ježíše pronásledovat a chtěli ho zabít, protože to dělal v sobotu. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ježíš jim ale odpověděl: “Můj Otec až doposud pracuje; i já pracuji.” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Židé ho tedy kvůli tomu chtěli zabít ještě více, neboť nejenom rušil sobotu, ale také nazýval Boha svým vlastním Otcem a tak se dělal rovným Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ježíš jim tedy odpověděl a řekl: “Amen, amen, říkám vám: Syn nemůže sám od sebe dělat nic, jedině to, co vidí dělat Otce. Neboť cokoli dělá on, to podobně dělá i Syn. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Otec totiž má rád Syna a ukazuje mu všechno, co sám dělá; a ukáže mu větší skutky než tyto, abyste se vy divili. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Neboť jako Otec křísí mrtvé a obživuje, tak i Syn obživuje ty, které chce. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Otec totiž nikoho nesoudí, ale všechen soud dal Synu, ");
INSERT INTO cesnkb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aby všichni ctili Syna, jako ctí Otce. Kdo nectí Syna, nectí ani Otce, který ho poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Amen, amen, říkám vám: Kdo slyší mé slovo a věří Tomu, který mě poslal, má věčný život a nepřijde na soud, ale již přešel ze smrti do života. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Amen, amen, říkám vám: Přichází hodina a již je zde, kdy mrtví uslyší hlas Božího Syna a ti, kteří uslyší, budou žít. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Neboť jako má Otec život sám v sobě, tak dal i Synu, aby měl život sám v sobě, ");
INSERT INTO cesnkb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","a dal mu také moc, aby konal soud, protože je Syn člověka. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nedivte se tomu; vždyť přichází hodina, kdy všichni, kteří jsou v hrobech, uslyší jeho hlas ");
INSERT INTO cesnkb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a vyjdou - ti, kdo konali dobro, budou vzkříšeni k životu, ale ti, kdo konali zlo, budou vzkříšeni k soudu. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Já nemohu dělat nic sám od sebe. Jak slyším, tak soudím a můj soud je spravedlivý, protože nehledám svou vůli, ale vůli Toho, který mě poslal, Otcovu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Svědčím-li já sám o sobě, mé svědectví není pravé. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Je někdo jiný, kdo o mně svědčí, a vím, že svědectví, které o mně vydává, je pravdivé. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Vy jste poslali k Janovi a on vydal svědectví pravdě. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Já ovšem svědectví od člověka nepřijímám, ale toto říkám proto, abyste byli spaseni. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","On byl hořící a zářící lampou, vy jste se však chtěli v jeho světle poradovat jen na čas. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Já mám ale větší svědectví než Janovo: skutky, které mi dal Otec, abych je vykonal. Samotné skutky, které dělám, svědčí o mně, že mě poslal Otec. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A sám Otec, který mě poslal, o mně vydal svědectví. Vy jste nikdy neslyšeli jeho hlas ani neviděli jeho tvář. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A jeho slovo ve vás nezůstává, neboť nevěříte tomu, koho on poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Zkoumáte Písma, neboť se domníváte, že v nich máte věčný život, a ona svědčí o mně. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ale nechcete ke mně přijít, abyste měli život. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Chválu od lidí nepřijímám, ");
INSERT INTO cesnkb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ale poznal jsem, že vy v sobě nemáte Boží lásku. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Já jsem přišel ve jménu svého Otce a nepřijímáte mě. Kdyby jiný přišel ve svém vlastním jménu, toho přijmete. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jak byste vy mohli uvěřit? Přijímáte chválu jedni od druhých a tu chválu, která je od samotného Boha, nehledáte. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nemyslete si, že já vás budu žalovat před Otcem. Ten, kdo na vás žaluje, je Mojžíš, v něhož vy doufáte. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kdybyste totiž věřili Mojžíšovi, věřili byste i mně; neboť on psal o mně. ");
INSERT INTO cesnkb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Když ale nevěříte jeho spisům, jak uvěříte mým slovům?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Potom Ježíš odešel za Galilejské (to jest Tiberiadské) moře. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A šel za ním veliký zástup, protože viděli jeho zázraky, které dělal na nemocných. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ježíš tedy vystoupil na horu a tam seděl se svými učedníky. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A byl blízko židovský svátek Veliké noci. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ježíš tedy pozvedl oči, a když uviděl, že k němu jde veliký zástup, řekl Filipovi: “Kde nakoupíme chleby, aby se tito najedli?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ale to řekl, aby ho vyzkoušel, neboť sám věděl, co má udělat.) ");
INSERT INTO cesnkb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip mu odpověděl: “Chléb za dvě stě denárů jim nepostačí, aby každý z nich dostal aspoň maličko.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jeden z jeho učedníků, Ondřej, bratr Šimona Petra, mu řekl: ");
INSERT INTO cesnkb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Je tu jeden chlapec, který má pět ječných chlebů a dvě rybky. Ale co to je pro tolik lidí?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ježíš však řekl: “Zařiďte, ať se lidé posadí.” A na tom místě bylo mnoho trávy. Posadili se tedy v počtu asi pěti tisíc mužů. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ježíš tedy vzal ty chleby, a když vzdal díky, rozdával učedníkům a učedníci sedícím; podobně také z těch ryb rozdal, kolik jen chtěli. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","A když byli nasyceni, řekl svým učedníkům: “Seberte nalámané kousky, které zbyly, ať se nic neztratí.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sebrali je tedy a naplnili dvanáct košů kousky, které zbyly z těch pěti ječných chlebů po těch, kteří jedli. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Když tedy lidé uviděli ten zázrak, který Ježíš udělal, říkali: “Toto je opravdu ten Prorok, který měl přijít na svět!” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Když tedy Ježíš poznal, že se chystají přijít a vzít ho, aby ho udělali králem, odešel jen sám zpátky na horu. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Když pak nastal večer, sestoupili jeho učedníci k moři, ");
INSERT INTO cesnkb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","nastoupili na loď a plavili se přes moře do Kafarnaum. A byla už tma, ale Ježíš k nim nepřišel. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tehdy se moře začalo zvedat vanutím velikého větru. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","A když odpluli asi pětadvacet nebo třicet honů, spatřili Ježíše, jak kráčí po moři a blíží se k lodi, a vystrašili se. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ale on jim řekl: “To jsem já, nebojte se!” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tehdy ho ochotně vzali na loď a loď se hned ocitla u země, k níž pluli. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Druhého dne uviděl zástup, který zůstal za mořem, že tam nebyla jiná loďka než ta jedna, na kterou nastoupili jeho učedníci, a že Ježíš nevešel se svými učedníky na loď, ale jeho učedníci odpluli sami. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Od Tiberiady však připluly jiné loďky blízko k tomu místu, kde jedli chléb, když Pán vzdal díky.) ");
INSERT INTO cesnkb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Když tedy zástup spatřil, že tam není Ježíš ani jeho učedníci, nastoupili i oni do lodí a přijeli do Kafarnaum, kde hledali Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A když ho za mořem našli, řekli mu: “Rabbi, kdy jsi sem přišel?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ježíš jim odpověděl: “Amen, amen, říkám vám: Hledáte mě ne proto, že jste viděli znamení, ale že jste jedli z těch chlebů a byli jste nasyceni. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pracujte ne pro pokrm, který hyne, ale pro ten pokrm, který zůstává k věčnému životu, který vám dá Syn člověka. Na něho totiž položil Bůh Otec svou pečeť.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Řekli mu tedy: “Co máme dělat, abychom konali Boží skutky?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ježíš jim odpověděl: “Toto je ten Boží skutek - abyste věřili v toho, kterého on poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Řekli mu tedy: “Jaké však uděláš znamení, abychom je viděli a uvěřili ti? Co děláš? ");
INSERT INTO cesnkb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Naši otcové jedli manu na poušti, jak je napsáno: ‘Dal jim jíst chléb z nebe.’” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ježíš jim tedy řekl: “Amen, amen, říkám vám: Ne Mojžíš vám dal chléb z nebe, ale můj Otec vám dává ten pravý chléb z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Neboť Boží chléb je ten, který sestupuje z nebe a dává život světu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Řekli mu tedy: “Pane, dávej nám ten chléb vždycky.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ježíš jim však řekl: “Já jsem ten chléb života. Kdo přichází ke mně, nebude nikdy hladovět, a kdo věří ve mne, nebude nikdy žíznit. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ale řekl jsem vám, že jste mě i viděli, a nevěříte. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Všechno, co mi dává Otec, přijde ke mně; a toho, kdo ke mně přichází, jistě nevyženu ven. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sestoupil jsem totiž z nebe, ne abych konal svou vůli, ale vůli Toho, který mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A toto je vůle Otce, který mě poslal - abych nic z toho, co mi dal, neztratil, ale vzkřísil to v poslední den. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Neboť toto je vůle Toho, který mě poslal - aby každý, kdo vidí Syna a věří v něho, měl věčný život. A já ho vzkřísím v poslední den.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Židé na něho tedy reptali, že řekl: “Já jsem ten chléb, který sestoupil z nebe,” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","a říkali: “Není snad toto Ježíš, syn Josefův, jehož otce i matku známe? Jak tedy může říkat: ‘Sestoupil jsem z nebe’?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ježíš jim tedy odpověděl a řekl: “Nereptejte mezi sebou. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nikdo nemůže přijít ke mně, jedině když ho přitáhne můj Otec, který mě poslal; a já ho vzkřísím v poslední den. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","V Prorocích je napsáno: ‘A budou všichni vyučeni od Boha.’ Proto každý, kdo slyšel od Otce a naučil se, přichází ke mně. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ne že by někdo viděl Otce, jedině ten, který je od Boha, ten viděl Otce. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Amen, amen, říkám vám: Kdo věří ve mne, má věčný život. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Já jsem ten chléb života. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vaši otcové jedli na poušti manu, a zemřeli. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Toto je ten chléb sestupující z nebe, aby nikdo, kdo z něho jí, nezemřel. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Já jsem ten živý chléb, který sestoupil z nebe. Bude-li někdo jíst ten chléb, bude žít na věky. A chléb, který já dám, je mé tělo, které dám za život světa.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Židé se tedy hádali mezi sebou a říkali: “Jak nám tenhle může dát jíst své tělo?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ježíš jim řekl: “Amen, amen, říkám vám: Nebudete-li jíst tělo Syna člověka a pít jeho krev, nemáte v sobě život. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kdo jí mé tělo a pije mou krev, má věčný život a já ho vzkřísím v poslední den. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Neboť mé tělo je opravdu pokrm a má krev je opravdu nápoj. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kdo jí mé tělo a pije mou krev, zůstává ve mně a já v něm. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jako mě poslal ten živý Otec a já žiji skrze Otce, tak ten, kdo jí mne, bude žít skrze mne. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Toto je ten chléb, který sestoupil z nebe. Ne jako vaši otcové jedli manu, a zemřeli. Kdo jí tento chléb, bude žít na věky.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Toto řekl v synagoze, když učil v Kafarnaum. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Když to tedy slyšeli mnozí z jeho učedníků, řekli: “To je tvrdá řeč. Kdo ji může poslouchat?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Když ale Ježíš v sobě poznal, že jeho učedníci na to reptají, řekl jim: “To vás pohoršuje? ");
INSERT INTO cesnkb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A co kdybyste viděli Syna člověka, jak vystupuje tam, kde byl dříve? ");
INSERT INTO cesnkb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Duch je ten, kdo obživuje; tělo není nic platno. Slova, která vám mluvím já, jsou Duch a jsou život. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Někteří z vás ale nevěří.” Ježíš totiž věděl od počátku, kdo byli nevěřící a kdo je ten, který ho zradí. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Řekl tedy: “Proto jsem vám řekl, že ke mně nikdo nemůže přijít, jedině když je mu to dáno od mého Otce.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kvůli tomu odešli mnozí z jeho učedníků zpět a už s ním nechodili. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ježíš tedy řekl těm dvanácti: “Chcete snad odejít i vy?” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A Šimon Petr mu odpověděl: “Pane, ke komu půjdeme? Ty máš slova věčného života. ");
INSERT INTO cesnkb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A my jsme uvěřili a poznali, že ty jsi Kristus, ten Syn živého Boha.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ježíš jim odpověděl: “Nevyvolil jsem vás dvanáct? A jeden z vás je ďábel.” ");
INSERT INTO cesnkb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A to řekl o Jidáši, synu Šimona Iškariotského. Ten ho měl zradit, ačkoli byl jedním z dvanácti. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Potom Ježíš chodil po Galileji; nechtěl totiž chodit po Judsku, protože ho Židé chtěli zabít. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A byla blízko židovská Slavnost stánků. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jeho bratři mu tedy řekli: “Vyjdi odsud a jdi do Judska, ať i tvoji učedníci vidí skutky, které děláš. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nikdo, kdo chce být známý, přece nedělá nic v skrytu. Když tedy děláš takové věci, zjev se světu!” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ani jeho bratři v něho totiž nevěřili. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ježíš jim tedy řekl: “Můj čas ještě nepřišel, ale váš čas je vždycky příhodný. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vás svět nemůže nenávidět, ale mě nenávidí, protože o něm vydávám svědectví, že jeho skutky jsou zlé. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Vy jděte na ten svátek. Já na ten svátek ještě nejdu, protože můj čas se ještě nenaplnil.” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","To jim řekl a zůstal v Galileji. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","A když jeho bratři odešli, tehdy šel i on na ten svátek, ne zjevně, ale jakoby potají. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Židé ho pak na tom svátku hledali a říkali: “Kde je?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A v zástupu bylo o něm mnoho řečí; někteří říkali, že je dobrý, a jiní říkali: “Není! Jen svádí zástup!” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kvůli strachu před Židy však o něm nikdo nemluvil otevřeně. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Asi v polovině svátku pak Ježíš vstoupil do chrámu a učil. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A Židé se divili a říkali: “Jak to, že tenhle zná Písma, když se neučil?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ježíš jim odpověděl a řekl: “Mé učení není mé, ale Toho, který mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bude-li někdo chtít konat jeho vůli, pozná, je-li to učení z Boha, nebo zda mluvím sám od sebe. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kdo mluví sám od sebe, hledá svou vlastní slávu; ale kdo hledá slávu Toho, který ho poslal, ten je pravdomluvný a není v něm žádná nepravost. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nedal vám Mojžíš Zákon? A nikdo z vás Zákon neplní. Proč mě chcete zabít?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Zástup odpověděl a řekl: “Máš démona! Kdo tě chce zabít?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ježíš jim odpověděl: “Jeden skutek jsem udělal a všichni se divíte. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mojžíš vám přece vydal obřízku (ne že by byla od Mojžíše, ale od otců) a v sobotu obřezáváte člověka. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jestliže člověk přijímá obřízku v sobotu, aby nebyl porušen Mojžíšův Zákon, proč se na mě hněváte, že jsem v sobotu uzdravil celého člověka? ");
INSERT INTO cesnkb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nesuďte podle osoby, ale suďte spravedlivým soudem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Někteří z Jeruzalémských tedy říkali: “Není snad tohle ten, kterého chtějí zabít? ");
INSERT INTO cesnkb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A hle, mluví svobodně a nic mu neříkají. Copak už hodnostáři opravdu poznali, že toto je skutečně Kristus? ");
INSERT INTO cesnkb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ale o tomto víme, odkud je, až však přijde Kristus, nikdo nebude vědět, odkud je.” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Když pak Ježíš vyučoval v chrámu, zvolal: “Znáte mě a také víte, odkud jsem. A nepřišel jsem sám od sebe, ale Ten, který mě poslal, je pravdomluvný a vy ho neznáte. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Já ho ale znám, neboť jsem od něho a on mě poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Snažili se ho tedy zajmout, ale nikdo na něj nevztáhl ruku, neboť ještě nepřišla jeho hodina. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mnozí ze zástupu však v něho uvěřili a říkali: “Až přijde Kristus, udělá snad více znamení, než udělal tento?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farizeové však uslyšeli zástup, jak o něm vede takové řeči, a tak farizeové a velekněží poslali služebníky, aby ho zatkli. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ježíš jim tedy řekl: “Ještě kratičký čas jsem s vámi; potom odejdu k Tomu, který mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Budete mě hledat, ale nenajdete; a tam, kde já budu, vy nemůžete přijít.” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Židé si tedy mezi sebou řekli: “Kam se chystá jít, že ho nenajdeme? Chce snad jít do řecké diaspory a učit Řeky? ");
INSERT INTO cesnkb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Co je to za slovo, které řekl: ‘Budete mě hledat, ale nenajdete; a tam, kde jsem já, vy nemůžete přijít’?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ve veliký poslední den toho svátku pak Ježíš stál a volal: “Žízní-li kdo, pojď ke mně a pij! ");
INSERT INTO cesnkb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kdo věří ve mne, z jeho nitra potečou řeky živé vody, jak praví Písmo.” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A to řekl o Duchu, kterého měli přijmout věřící v něho; neboť Duch Svatý ještě nebyl dán, protože Ježíš ještě nebyl oslaven. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Když tedy mnozí ze zástupu uslyšeli tu řeč, říkali: “Toto je opravdu ten Prorok.” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Někteří říkali: “Toto je Kristus!” Ale jiní říkali: “Přijde snad Kristus z Galileje? ");
INSERT INTO cesnkb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Neříká snad Písmo, že Kristus přijde ze semene Davidova a z Betléma, městečka, kde bydlel David?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","A tak kvůli němu nastala v zástupu roztržka. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Někteří z nich ho pak chtěli zajmout, ale nikdo na něj nevztáhl ruku. ");
INSERT INTO cesnkb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ti služebníci tedy přišli k farizeům a velekněžím, kteří jim řekli: “Proč jste ho nepřivedli?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Služebníci odpověděli: “Žádný člověk nikdy nemluvil tak jako tento člověk!” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A farizeové jim odpověděli: “Copak jste i vy svedeni? ");
INSERT INTO cesnkb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Uvěřil v něj snad někdo z hodnostářů nebo z farizeů? ");
INSERT INTO cesnkb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jedině ten dav, který nezná Zákon. Jsou zlořečení!” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","A jeden z nich, Nikodém, který k němu přišel v noci, jim řekl: ");
INSERT INTO cesnkb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Soudí snad náš Zákon člověka, aniž by ho nejdříve vyslyšel a zjistil, co dělá?” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Odpověděli a řekli mu: “Jsi snad i ty z Galileje? Zkoumej a viz, že z Galileje žádný prorok nepovstal!” ");
INSERT INTO cesnkb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","A tak šel každý do svého domu. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ježíš pak odešel na Olivetskou horu. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Za úsvitu potom přišel znovu do chrámu a všechen lid se scházel k němu. Posadil se tedy a učil je. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Zákoníci a farizeové pak k němu přivedli ženu přistiženou při cizoložství, a když ji postavili doprostřed, ");
INSERT INTO cesnkb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","řekli mu: “Mistře, tato žena byla přistižena při činu, když cizoložila. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mojžíš nám v Zákoně přikázal takové kamenovat. Co tedy říkáš ty?” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","A tou řečí ho pokoušeli, aby ho mohli obžalovat. Ježíš se však sklonil a psal prstem po zemi. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Když se ho však nepřestávali dotazovat, zvedl se a řekl jim: “Kdo z vás je bez hříchu, ať po ní první hodí kamenem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Potom se opět sklonil a psal po zemi. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A když to uslyšeli, byli obviněni ve svých svědomích a jeden po druhém odcházeli počínaje od starších až po poslední. Ježíš tedy zůstal sám s tou ženou stojící uprostřed. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Když se pak Ježíš zvedl a neviděl nikoho než tu ženu, řekl jí: “Ženo, kde jsou tvoji žalobci? Nikdo tě neodsoudil?” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ona řekla: “Nikdo, Pane.” Ježíš jí tedy řekl: “Ani já tě neodsuzuji. Jdi a už nehřeš.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ježíš k nim tedy znovu mluvil. Řekl: “Já jsem světlo světa. Kdo mě následuje, nebude už chodit v temnotě, ale bude mít světlo života.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farizeové mu však řekli: “Ty svědčíš sám o sobě, tvé svědectví není pravé.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ježíš jim odpověděl: “Ačkoli svědčím sám o sobě, mé svědectví je pravé, neboť vím, odkud jsem přišel a kam jdu. Vy však nevíte, odkud přicházím, ani kam jdu. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vy soudíte podle těla, já nesoudím nikoho. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A i kdybych soudil, můj soud je pravdivý, neboť nejsem sám, ale jsem já a Otec, který mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A ve vašem Zákoně je napsáno, že svědectví dvou lidí je pravé. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Já svědčím sám o sobě a Otec, který mě poslal, svědčí o mně.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Říkali mu tedy: “Kde je ten tvůj otec?” Ježíš odpověděl: “Neznáte mne ani mého Otce. Kdybyste znali mě, znali byste i mého Otce.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tato slova Ježíš mluvil u pokladnice, když učil v chrámu, a nikdo ho nezajal, neboť jeho hodina ještě nepřišla. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ježíš jim tedy znovu řekl: “Já odcházím a budete mě hledat a zemřete ve svém hříchu. Kam já jdu, vy nemůžete přijít.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Židé tedy říkali: “Copak se sám zabije, že říká: ‘Kam já jdu, vy nemůžete přijít’?” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Řekl jim tedy: “Vy jste zdola, já jsem shora. Vy jste z tohoto světa, já nejsem z tohoto světa. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Proto jsem vám řekl, že zemřete ve svých hříších. Jestliže totiž nebudete věřit, že já jsem, zemřete ve svých hříších.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Řekli mu tedy: “Kdo jsi?” A Ježíš jim řekl: “To, co vám říkám od začátku. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mnoho mám o vás mluvit a soudit, ale Ten, který mě poslal, je pravdomluvný; a já mluvím na světě to, co jsem slyšel od něho.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ale neporozuměli, že jim říkal o Otci. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Proto jim Ježíš řekl: “Až vyzdvihnete Syna člověka, tehdy poznáte, že já jsem. A sám od sebe nedělám nic, ale jak mě naučil můj Otec, tak mluvím. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A Ten, který mě poslal, je se mnou. Otec mě nenechal samotného, protože vždycky dělám, co se mu líbí.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A když mluvil tyto věci, mnozí v něho uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ježíš tedy řekl těm Židům, kteří mu uvěřili: “Jestliže zůstanete v mém slově, jste opravdu mými učedníky. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A poznáte pravdu a pravda vás vysvobodí.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Odpověděli mu tedy: “Jsme símě Abrahamovo a nikdy jsme nikomu neotročili. Jak můžeš říkat: ‘Budete svobodní’?” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ježíš jim odpověděl: “Amen, amen, říkám vám, že každý, kdo dělá hřích, je otrokem hříchu. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A otrok nezůstává v domě navěky, syn zůstává navěky. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jestliže vás tedy Syn vysvobodí, budete opravdu svobodní.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Vím, že jste Abrahamovo símě, ale chcete mě zabít, neboť mé slovo ve vás nemá místo. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Já mluvím o tom, co jsem viděl u svého Otce; vy pak také děláte, co jste viděli u svého otce.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Odpověděli mu: “Náš otec je Abraham.” Ježíš jim řekl: “Kdybyste byli děti Abrahama, dělali byste Abrahamovy skutky. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ale teď mě chcete zabít - člověka, který vám pověděl pravdu, kterou slyšel od Boha. To Abraham nedělal. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Vy děláte skutky svého otce.” Řekli mu tedy: “My nejsme zplozeni ze smilstva; máme jednoho Otce, Boha!” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ježíš jim tedy řekl: “Kdyby byl Bůh vaším Otcem, milovali byste mě, protože jsem vyšel z Boha a od něj přicházím. Nepřišel jsem totiž sám od sebe, ale on mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Proč nechápete mou řeč? Protože nemůžete slyšet mé slovo. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Vy jste z otce ďábla a chcete plnit touhy svého otce. On byl vrah od počátku a nestál v pravdě, protože v něm pravda není. Když mluví lež, mluví ze svého vlastního, neboť je lhář a otec lži. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ale protože já říkám pravdu, nevěříte mi. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kdo z vás mě usvědčí z hříchu? A když říkám pravdu, proč mi nevěříte? ");
INSERT INTO cesnkb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kdo je z Boha, slyší Boží slova. Vy neslyšíte proto, že nejste z Boha.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Židé tedy odpověděli a řekli mu: “Neříkáme snad správně, že jsi Samaritán a máš démona?” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ježíš odpověděl: “Já nemám démona, ale ctím svého Otce a vy mnou pohrdáte. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Já však nehledám svou chválu; je někdo, kdo hledá a soudí. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Amen, amen, říkám vám: Zachová-li někdo mé slovo, navěky nespatří smrt.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Židé mu tedy řekli: “Teď jsme poznali, že máš démona! Abraham zemřel, i proroci, a ty říkáš: ‘Zachová-li někdo mé slovo, navěky nezakusí smrt.’ ");
INSERT INTO cesnkb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Jsi snad větší než náš otec Abraham, který zemřel? I proroci zemřeli! Koho ze sebe děláš?” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ježíš odpověděl: “Chválím-li sám sebe, má chvála není nic. Ten, který mě chválí, je můj Otec, o němž říkáte, že je váš Bůh. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ale nepoznali jste ho; já ho však znám. A kdybych řekl, že ho neznám, byl bych podobný vám, lhář. Ale znám ho a jeho slovo zachovávám. ");
INSERT INTO cesnkb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham, se těšil, aby viděl můj den; uviděl ho a zaradoval se.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Židé mu tedy řekli: “Ještě ti není padesát let a viděl jsi Abrahama?” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ježíš jim řekl: “Amen, amen, říkám vám: Dříve než byl Abraham, já jsem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Vzali tedy kamení, aby po něm házeli. Ježíš se však skryl, a když prošel jejich středem, vyšel z chrámu; a tak odešel. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Když pak šel kolem, spatřil člověka slepého od narození. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jeho učedníci se ho tedy zeptali: “Rabbi, kdo zhřešil - on, nebo jeho rodiče - že se narodil slepý?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ježíš odpověděl: “Nezhřešil ani on, ani jeho rodiče, ale mají na něm být zjeveny Boží skutky. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Já musím dělat skutky Toho, který mě poslal, dokud je den. Přichází noc, kdy nikdo nebude moci pracovat. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dokud jsem na světě, jsem světlo světa.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Když to řekl, plivl na zem, udělal ze sliny bláto a tím blátem pomazal oči toho slepce. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Potom mu řekl: “Jdi, umyj se v rybníku Siloe” (což se překládá Poslaný). Odešel tedy a umyl se; a když přišel, viděl. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sousedé a ti, kdo ho dříve vídali slepého, tedy řekli: “Není to snad ten, který tu sedával a žebrával?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Někteří říkali, že je to on, a jiní, že je mu podobný. Ale on říkal: “Jsem to já!” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Říkali mu tedy: “Jak se otevřely tvé oči?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","On odpověděl a řekl: “Člověk jménem Ježíš udělal bláto a pomazal mé oči a řekl mi: ‘Jdi k rybníku Siloe a umyj se.’ Když jsem tedy odešel a umyl se, prohlédl jsem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Řekli mu tedy: “Kde je ten člověk?” Řekl: “Nevím.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","A tak přivedli toho, který byl dříve slepý, k farizeům. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bylo to však v sobotu, když Ježíš udělal bláto a otevřel jeho oči. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farizeové se ho tedy znovu ptali, jak prohlédl, a on jim řekl: “Položil na mé oči bláto, umyl jsem se a vidím.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Někteří z farizeů tedy říkali: “Ten člověk není od Boha, protože nedodržuje sobotu.” Jiní říkali: “Jak může taková znamení dělat hříšný člověk?” A byla mezi nimi roztržka. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tomu slepému znovu řekli: “Co o něm říkáš ty, když otevřel tvé oči?” A on řekl: “Že je prorok.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Židé tedy o něm neuvěřili, že býval slepý a prohlédl, dokud si nezavolali rodiče toho, který prohlédl, ");
INSERT INTO cesnkb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","a nezeptali se jich: “Je toto váš syn, o kterém říkáte, že se narodil slepý? Jak to, že tedy nyní vidí?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jeho rodiče jim odpověděli: “Víme, že toto je náš syn a že se narodil slepý. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ale jak to, že teď vidí, nevíme. A kdo otevřel jeho oči, nevíme. Ptejte se jeho, má na to léta, bude mluvit sám za sebe.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jeho rodiče to řekli, protože se báli Židů. Židé se totiž už dohodli, že kdokoli by ho vyznal jako Krista, bude vyobcován ze synagogy. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Proto jeho rodiče řekli: “Má na to léta, zeptejte se jeho.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A tak toho člověka, který býval slepý, zavolali podruhé a řekli mu: “Vzdej slávu Bohu! My víme, že ten člověk je hříšník.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","On jim tedy odpověděl: “Zda je hříšník, nevím. Vím jedno - že jsem byl slepý a teď vidím.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tehdy mu znovu řekli: “Co ti udělal? Jak otevřel tvé oči?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Odpověděl jim: “Už jsem vám to řekl, neslyšeli jste? Co zase chcete slyšet? Chcete snad i vy být jeho učedníky?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Spílali mu tedy a řekli: “Ty jsi jeho učedník, ale my jsme Mojžíšovi učedníci! ");
INSERT INTO cesnkb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","My víme, že k Mojžíši mluvil Bůh, ale o tomto nevíme, odkud je.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ten člověk jim odpověděl: “To je právě divné, že nevíte, odkud je, a přitom otevřel mé oči. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Víme přece, že Bůh hříšníky neslyší; ale kdo by Boha ctil a konal jeho vůli, toho slyší. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Od věků nebylo slýcháno, že by někdo otevřel oči člověka, který se narodil slepý. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kdyby ten člověk nebyl od Boha, nemohl by nic udělat.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Odpověděli mu: “Ty ses narodil celý v hříších a chceš nás poučovat?” A vyhnali ho ven. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Když pak Ježíš uslyšel, že ho vyhnali ven, nalezl ho a řekl mu: “Věříš v Božího Syna?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","On odpověděl: “A kdo to je, Pane, abych v něho mohl věřit?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ježíš mu tedy řekl: “Už jsi ho i viděl. Je to ten, který s tebou mluví.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A on řekl: “Věřím, Pane.” A poklonil se mu. ");
INSERT INTO cesnkb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tehdy Ježíš řekl: “Přišel jsem na tento svět k soudu: aby ti, kteří nevidí, viděli a ti, kteří vidí, aby oslepli.” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","A uslyšeli to někteří z farizeů, kteří byli s ním, a řekli mu: “Jsme snad i my slepí?” ");
INSERT INTO cesnkb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ježíš jim řekl: “Kdybyste byli slepí, neměli byste hřích; teď ale říkáte: ‘Vidíme,’ a proto váš hřích zůstává.” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Amen, amen, říkám vám: Kdo nevchází do ovčince dveřmi, ale vstupuje jinudy, ten je zloděj a lupič, ");
INSERT INTO cesnkb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ale kdo vchází dveřmi, je pastýř ovcí. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tomu vrátný otvírá a ovce slyší jeho hlas; on pak své ovce volá jménem a vyvádí je. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A když své ovce vypustí, jde před nimi a ovce jdou za ním, neboť znají jeho hlas. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Cizího však nikdy následovat nebudou, ale utečou od něho, neboť neznají hlas cizích.” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ježíš jim řekl toto přirovnání, ale oni nepochopili, co jeho vyprávění znamená. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ježíš jim tedy znovu řekl: “Amen, amen, říkám vám: já jsem dveře ovcí. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Všichni, kolik jich přišlo přede mnou, jsou zloději a lupiči, ale ovce je neposlechly. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Já jsem dveře. Kdokoli vejde skrze mne, bude spasen a bude vcházet i vycházet a nalezne pastvu. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Zloděj přichází, jen aby kradl a zabíjel a ničil; já jsem přišel, aby měly život a měly ho hojně. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Já jsem ten dobrý pastýř. Dobrý pastýř pokládá za ovce svůj život. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ale nádeník a ten, kdo není pastýř, jemuž ty ovce nepatří, když vidí přicházet vlka, opouští ovce a utíká; a vlk chytá ovce a rozhání je. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nádeník tedy utíká, protože je nádeník a nezáleží mu na ovcích. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Já jsem ten dobrý pastýř a znám své ovce a mé ovce znají mne, ");
INSERT INTO cesnkb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","jako mě zná Otec a já znám Otce; a za ty ovce pokládám svůj život. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mám však i jiné ovce, které nejsou z tohoto ovčince. I ty musím přivést a uslyší můj hlas. Tehdy bude jedno stádo a jeden pastýř. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Proto mě Otec miluje, že já pokládám svůj život, abych ho zase přijal. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nikdo mi ho nebere, ale já ho pokládám sám od sebe. Mám moc ho položit a mám moc ho zase přijmout. To přikázání jsem přijal od svého Otce.” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mezi Židy tedy znovu nastala kvůli těm slovům roztržka. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A mnozí z nich říkali: “Má démona a blázní! Co ho posloucháte?” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jiní říkali: “Toto nejsou slova člověka, který má démona. Může snad démon otvírat oči slepým?” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","V Jeruzalémě pak byl svátek Zasvěcení chrámu a bylo to v zimě. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","A Ježíš se procházel v chrámu, v Šalomounově sloupoví. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Židé ho tedy obstoupili a říkali mu: “Jak dlouho budeš držet naši duši v nejistotě? Jestliže jsi Kristus, řekni nám to jasně.” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ježíš jim odpověděl: “Řekl jsem vám to a nevěříte. Skutky, které dělám ve jménu svého Otce, ty o mně vydávají svědectví. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Vy ale nevěříte, protože nejste z mých ovcí, jak jsem vám řekl. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mé ovce slyší můj hlas a já je znám a následují mě. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A já jim dávám věčný život a nezahynou navěky a nikdo je nevytrhne z mé ruky. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Můj Otec, který mi je dal, je větší nade všechny a nikdo je nemůže vytrhnout z ruky mého Otce. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Já a Otec jsme jedno.” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Židé tedy znovu vzali kamení, aby ho ukamenovali. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ježíš jim odpověděl: “Ukázal jsem vám mnoho dobrých skutků od svého Otce. Za který z těch skutků mě kamenujete?” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Židé mu odpověděli: “Nekamenujeme tě za dobrý skutek, ale za rouhání, totiž že ty, člověk, ze sebe děláš Boha!” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ježíš jim odpověděl: “Není ve vašem Zákoně napsáno: ‘Já jsem řekl: Jste bohové’? ");
INSERT INTO cesnkb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jestliže nazval bohy ty, k nimž přišlo Boží slovo (a Písmo nemůže být zrušeno), ");
INSERT INTO cesnkb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","proč mně, kterého Otec posvětil a poslal na svět, říkáte: ‘Rouháš se,’ když jsem řekl: ‘Jsem Boží Syn’? ");
INSERT INTO cesnkb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nedělám-li skutky svého Otce, nevěřte mi. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pokud je však dělám, i kdybyste nevěřili mně, věřte těm skutkům, abyste poznali a uvěřili, že Otec je ve mně a já v něm. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chtěli ho tedy opět zajmout, ale unikl z jejich rukou. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tehdy znovu odešel za Jordán, na místo, kde dříve křtil Jan, a zůstal tam. ");
INSERT INTO cesnkb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mnozí k němu přicházeli a říkali: “Jan jistě neudělal žádný zázrak, ale všechno, co Jan řekl o tomto, bylo pravdivé.” ");
INSERT INTO cesnkb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A mnozí tam v něho uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nějaký Lazar z Betanie, městečka Marie a její sestry Marty, pak byl nemocný. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","A to byla ta Marie, která pomazala Pána mastí a jeho nohy vytřela svými vlasy; její bratr Lazar byl nemocný. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ty sestry tedy poslaly k němu se slovy: “Pane, hle, ten, kterého máš rád, je nemocný.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Když to pak Ježíš uslyšel, řekl: “Ta nemoc není k smrti, ale pro Boží slávu, aby skrze ni byl oslaven Boží Syn.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A Ježíš miloval Martu i její sestru i Lazara. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Když tedy uslyšel, že Lazar je nemocný, zůstal ještě dva dny na místě, kde byl. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Potom řekl svým učedníkům: “Pojďme znovu do Judska.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Učedníci mu řekli: “Rabbi, Židé tě teď chtěli ukamenovat a ty tam jdeš znovu?” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ježíš odpověděl: “Nemá snad den dvanáct hodin? Kdo chodí ve dne, neklopýtá, neboť vidí světlo tohoto světa. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kdo ale chodí v noci, klopýtá, neboť v něm není světlo.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","To pověděl a potom jim řekl: “Lazar, náš přítel, usnul, ale jdu, abych ho probudil.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jeho učedníci řekli: “Pane, jestliže usnul, bude zdráv!” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ježíš to však řekl o jeho smrti, ale oni se domnívali, že mluví o odpočinku ve spánku. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tehdy jim Ježíš řekl jasně: “Lazar zemřel. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","A raduji se kvůli vám, že jsem tam nebyl, abyste uvěřili. Ale pojďme k němu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomáš zvaný Didymus tedy řekl spoluučedníkům: “Pojďme i my, abychom zemřeli s ním.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Když tedy Ježíš přišel, nalezl ho již čtyři dny pochovaného v hrobě. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanie pak byla blízko Jeruzaléma, asi patnáct honů. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","A mnozí z Židů přišli k Martě a Marii, aby je utěšili ve smutku nad jejich bratrem. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jakmile tedy Marta uslyšela, že přichází Ježíš, vyšla mu naproti, ale Marie seděla doma. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta tedy řekla Ježíši: “Pane, kdybys tu byl, můj bratr by nezemřel. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ale i teď vím, že o cokoli bys Boha požádal, to ti Bůh dá.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ježíš jí řekl: “Tvůj bratr vstane.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta mu řekla: “Vím, že vstane při vzkříšení v poslední den.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ježíš jí řekl: “Já jsem vzkříšení i život. Kdo věří ve mne, i kdyby zemřel, bude žít. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A každý, kdo žije a věří ve mne, jistě nezemře navěky. Věříš tomu?” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Řekla mu: “Ano, Pane, já jsem uvěřila, že ty jsi Kristus, Boží Syn, který má přijít na svět.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","A když to pověděla, odešla a tajně zavolala Marii, svou sestru, se slovy: “Mistr je tu a volá tě.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A ona, jakmile to uslyšela, rychle vstala a šla k němu. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ježíš však ještě nepřišel do městečka, ale byl na tom místě, kam mu vyšla naproti Marta. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Když tedy Židé, kteří byli s Marií v domě a utěšovali ji, uviděli, že rychle vstala a šla ven, šli za ní se slovy: “Jde ke hrobu, aby tam plakala.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jakmile tedy Marie přišla tam, kde byl Ježíš, a spatřila ho, padla k jeho nohám a řekla mu: “Pane, kdybys tu byl, můj bratr by nezemřel.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Když tedy Ježíš spatřil, jak pláče a jak pláčou Židé, kteří přišli s ní, v duchu zasténal a zarmoutil se. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Potom řekl: “Kam jste ho položili?” Řekli mu: “Pane, pojďa podívej se.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ježíš se rozplakal. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Židé tedy řekli: “Hleďte, jak ho měl rád!” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Někteří z nich však řekli: “Nemohl snad ten, kdo otevřel oči slepého, způsobit také, aby tento člověk nezemřel?” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ježíš tedy znovu sám v sobě zasténal a přišel ke hrobu. Byla to jeskyně a na ní ležel kámen. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ježíš řekl: “Odvalte ten kámen.” Marta, sestra toho mrtvého, mu řekla: “Pane, už zapáchá, vždyť je v hrobě čtvrtý den!” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ježíš jí řekl: “Neřekl jsem ti, že budeš-li věřit, uvidíš Boží slávu?” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Zvedli tedy kámen z místa, kde byl ten mrtvý pochován. Ježíš pozvedl oči vzhůru a řekl: “Otče, děkuji ti, že jsi mě vyslyšel. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Já vím, že mě vždycky slyšíš, ale řekl jsem to kvůli zástupu, který stojí kolem, aby uvěřili, že jsi mě poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A když to řekl, zavolal mocným hlasem: “Lazare, pojď ven!” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A ten, který zemřel, vyšel ven. Měl ruce i nohy svázané plátny a jeho tvář byla ovinuta rouškou. Ježíš jim řekl: “Rozvažte ho a nechte ho odejít.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tehdy mnozí z těch Židů, kteří přišli k Marii a viděli, co Ježíš udělal, uvěřili v něho. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Někteří z nich však odešli k farizeům a řekli jim, co Ježíš udělal. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Velekněží a farizeové tedy shromáždili veleradu a říkali: “Co uděláme? Vždyť tento člověk dělá mnoho zázraků! ");
INSERT INTO cesnkb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jestli ho tak necháme, všichni v něho uvěří a přijdou Římané a vezmou nám naše místo i národ!” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Avšak jeden z nich, Kaifáš, který byl toho roku nejvyšším knězem, jim řekl: “Vy nic nevíte! ");
INSERT INTO cesnkb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ani nepomyslíte, že je pro nás prospěšné, aby jeden člověk zemřel za lid a ne aby celý tento národ zahynul.” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","To však neřekl sám od sebe, ale protože byl toho roku nejvyšším knězem, prorokoval, že Ježíš má zemřít za tento národ. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A nejen za tento národ, ale také aby shromáždil rozptýlené Boží děti v jedno. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Od toho dne tedy byli dohodnuti, že ho zabijí. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ježíš proto už nechodil mezi Židy veřejně, ale odešel odtud do kraje blízko pouště, do města jménem Efraim, a tam pobýval se svými učedníky. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A byla blízko židovská Veliká noc. Mnozí z toho kraje tedy před Velikou nocí putovali vzhůru do Jeruzaléma, aby se očistili. ");
INSERT INTO cesnkb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hledali tedy Ježíše; a když stáli v chrámu, povídali si mezi sebou: “Co myslíte? Že by nepřišel na svátek?” ");
INSERT INTO cesnkb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Velekněží i farizeové však vydali nařízení, že pokud by se někdo dozvěděl, kde je, má to oznámit, aby ho mohli zajmout. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ježíš tedy přišel šest dní před Velikou nocí do Betanie, kde byl Lazar, ten, který zemřel a kterého vzkřísil z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tam mu připravili večeři a Marta je obsluhovala a Lazar byl jedním z těch, kdo s ním stolovali. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Marie tehdy vzala libru velmi drahé masti z pravého nardu, pomazala Ježíšovy nohy a vytřela je svými vlasy. A dům byl naplněn vůní té masti. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jeden z jeho učedníků, Jidáš, syn Šimona Iškariotského, který ho měl zradit, tedy řekl: ");
INSERT INTO cesnkb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Proč se tato mast neprodala za tři sta denárů a nedalo se chudým?” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","To však řekl ne proto, že měl starost o chudé, ale že byl zloděj a měl na starosti pokladnu a to, co se do ní dávalo, bral. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ježíš tedy řekl: “Nech ji, zachovala to pro den mého pohřbu. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chudé přece máte u sebe vždycky, ale mne vždycky mít nebudete.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tehdy se veliké množství Židů dozvědělo, že je tam, a přišli - nejen kvůli Ježíši, ale také aby viděli Lazara, kterého vzkřísil z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A tak se velekněží rozhodli zabít i Lazara, ");
INSERT INTO cesnkb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","neboť mnozí z Židů kvůli němu odcházeli a uvěřili v Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Když nazítří veliký zástup lidí, kteří přišli na svátek, uslyšel, že Ježíš přichází do Jeruzaléma, ");
INSERT INTO cesnkb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","vzali palmové větve a vyšli mu naproti s voláním: “Hosana! Požehnaný, který přichází v Pánově jménu, král Izraele!” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A když Ježíš nalezl oslátko, vsedl na ně, jak je napsáno: ");
INSERT INTO cesnkb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Neboj se, dcero Sionu, hle, tvůj král přichází, sedě na hříbátku oslice.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jeho učedníci tomu však nejprve neporozuměli; ale když byl Ježíš oslaven, tehdy si vzpomněli, že to o něm je napsáno a že mu to učinili. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Zástup, který byl s ním, pak vydával svědectví, že zavolal Lazara z hrobu a vzkřísil ho z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Proto mu také vyšel naproti zástup lidí, neboť slyšeli, že udělal ten zázrak. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farizeové si tedy mezi sebou řekli: “Vidíte, že nic nezmůžete? Hleďte, svět odešel za ním!” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A někteří z těch, kteří se přišli o tom svátku modlit, byli Řekové. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ti tedy přistoupili k Filipovi, který byl z galilejské Betsaidy, a prosili ho: “Pane, chtěli bychom vidět Ježíše.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip přišel a řekl Ondřejovi a Ondřej s Filipem to zase řekli Ježíši. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ježíš jim tedy odpověděl: “Přišla hodina, aby Syn člověka byl oslaven. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Amen, amen, říkám vám: Pokud zrno pšenice nepadne do země a nezemře, zůstane samo. Ale pokud zemře, přinese mnoho úrody. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kdo má rád svou duši, ten ji ztratí, a kdo nenávidí svou duši v tomto světě, uchrání ji k věčnému životu. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Slouží-li mi někdo, ať mě následuje; a tam, kde jsem já, bude i můj služebník. A bude—li mi někdo sloužit, Otec ho poctí.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Má duše je teď zarmoucená a co mám říci? ‘Otče, vysvoboď mě z této hodiny’? Ale proto jsem přišel, k této hodině. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Otče, oslav své jméno!” Tehdy se z nebe ozval hlas: “Oslavil jsem a ještě oslavím.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A zástup, který tam stál a slyšel to, řekl: “Zahřmělo.” Jiní říkali: “Mluvil k němu anděl.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ježíš na to odpověděl: “Ten hlas nepřišel kvůli mně, ale kvůli vám. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nyní je soud nad tímto světem, nyní bude vládce tohoto světa vyvržen ven. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A já, když budu vyzdvižen od země, potáhnu všechny k sobě.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(A to řekl, aby naznačil, jakou smrtí má zemřít.) ");
INSERT INTO cesnkb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zástup mu odpověděl: “My jsme slyšeli ze Zákona, že Kristus zůstává na věky; jak to, že tedy říkáš, že Syn člověka musí být vyzdvižen? Kdo je ten Syn člověka?” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ježíš jim tedy řekl: “Ještě na krátký čas je světlo s vámi. Choďte, dokud máte světlo, ať vás nezachvátí tma. Kdo totiž chodí ve tmě, neví, kam jde. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dokud máte světlo, věřte ve světlo, abyste byli syny světla.” Když to Ježíš pověděl, odešel a skryl se před nimi. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","A ačkoli před nimi udělal tolik zázraků, přece v něho neuvěřili, ");
INSERT INTO cesnkb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","aby se naplnilo slovo, které řekl prorok Izaiáš: “Pane, kdo uvěřil našemu kázání? A komu je zjevena Pánova paže?” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Proto nemohli věřit, neboť Izaiáš ještě řekl: ");
INSERT INTO cesnkb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Oslepil jejich oči a zatvrdil jejich srdce, aby očima neuviděli a srdcem nepochopili a neobrátili se, abych je neuzdravil.” ");
INSERT INTO cesnkb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","To řekl Izaiáš, když spatřil jeho slávu a mluvil o něm. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Přesto však v něho uvěřili i mnozí z hodnostářů, ale kvůli farizeům ho nevyznávali, aby nebyli vyobcováni ze synagogy. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Milovali totiž lidskou chválu více než chválu Boží. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tehdy Ježíš zvolal: “Kdo věří ve mne, věří ne ve mne, ale v Toho, který mě poslal, ");
INSERT INTO cesnkb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","a kdo mě vidí, vidí Toho, který mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Já, světlo, jsem přišel na svět, aby nikdo, kdo ve mne věří, nezůstal ve tmě. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","A jestliže někdo slyší má slova a nevěří, já ho nesoudím; nepřišel jsem totiž, abych soudil svět, ale abych svět spasil. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kdo mě odmítá a nepřijímá moje slova, ten má, kdo by ho soudil. Slovo, které jsem mluvil, to ho bude soudit v poslední den. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nemluvil jsem totiž sám od sebe, ale Otec, který mě poslal, on mi dal přikázání, co mám říkat a co mluvit. ");
INSERT INTO cesnkb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A vím, že jeho přikázání je věčný život. Proto, co mluvím, mluvím tak, jak mi řekl Otec.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Před svátkem Veliké noci pak Ježíš věděl, že přišla jeho hodina, aby odešel z tohoto světa k Otci. Miloval své, kteří byli na světě, a miloval je až do konce. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","(A když večeřeli, ďábel již vložil do srdce Jidáše, syna Šimona Iškariotského, aby ho zradil.) ");
INSERT INTO cesnkb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ježíš, vědom si toho, že mu Otec dal všechno do rukou a že vyšel od Boha a jde k Bohu, ");
INSERT INTO cesnkb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","vstal od večeře, odložil plášť, vzal zástěru a přepásal se. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Potom nalil vodu do umyvadla a začal učedníkům umývat nohy a vytírat je zástěrou, kterou byl přepásán. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Přišel tedy k Šimonu Petrovi a ten mu řekl: “Pane, ty mi chceš mýt nohy?” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ježíš mu odpověděl: “Ty teď nechápeš, co dělám, ale potom porozumíš.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petr mu řekl: “Nikdy nebudeš mýt mé nohy!” Ježíš mu odpověděl: “Jestliže tě neumyji, nemáš se mnou podíl.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Šimon Petr mu řekl: “Pane, nejen mé nohy, ale i ruce a hlavu!” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ježíš mu řekl: “Kdo je vykoupán, potřebuje umýt jen nohy, neboť je celý čistý. I vy jste čistí, ale ne všichni.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Věděl totiž o svém zrádci; proto řekl: “Ne všichni jste čistí.”) ");
INSERT INTO cesnkb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Když jim tedy umyl nohy, vzal si plášť, posadil se opět za stůl a řekl jim: “Rozumíte, co jsem vám udělal? ");
INSERT INTO cesnkb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Vy mě nazýváte Mistrem a Pánem a říkáte to dobře, neboť jím jsem. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jestliže jsem tedy já, Pán a Mistr, umyl nohy vám, i vy máte mýt nohy jeden druhému. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dal jsem vám totiž příklad, abyste se i vy chovali, jako jsem se já zachoval k vám. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Amen, amen, říkám vám: Služebník není větší než jeho pán a posel není větší než ten, kdo ho poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Víte-li tyto věci, jste požehnaní, budete-li je dělat.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nemluvím o vás všech. Já vím, které jsem vyvolil; ale ať se naplní Písmo: ‘Ten, který jí se mnou chléb, zvedl svou patu proti mně.’ ");
INSERT INTO cesnkb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Říkám vám to již teď, dříve než se to stane, abyste až se to stane, uvěřili, že já jsem. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Amen, amen, říkám vám: Kdo přijímá toho, koho já pošlu, přijímá mne; a kdo přijímá mne, přijímá Toho, který mě poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Když to Ježíš řekl, v duchu se zarmoutil a vydal svědectví: “Amen, amen, říkám vám, že jeden z vás mě zradí.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Učedníci se tedy ohlíželi jeden po druhém, bezradní nad tím, o kom mluví. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jeden z Ježíšových učedníků, ten, kterého Ježíš miloval, pak ležel u stolu v Ježíšově náručí. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tomu tedy dal Šimon Petr znamení, aby se zeptal, kdo je ten, o němž mluví. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A on spočinul na Ježíšových prsou a řekl mu: “Pane, kdo to je?” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ježíš odpověděl: “Je to ten, komu podám namočené sousto.” A když namočil sousto, podal je Jidášovi, synu Šimona Iškariotského. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","A tehdy, po tom soustu, do něho vstoupil Satan. Ježíš mu tedy řekl: “Co děláš, udělej rychle.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nikdo ze stolujících však neporozuměl, proč mu to řekl. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Někteří se totiž domnívali (poněvadž Jidáš měl na starosti pokladnu), že mu Ježíš řekl: “Nakup, co potřebujeme na svátek,” nebo aby dal něco chudým. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jidáš tedy vzal to sousto a hned vyšel ven. A byla noc. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","A když odešel, Ježíš řekl: “Teď je Syn člověka oslaven a Bůh je oslaven v něm. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","A poněvadž je Bůh oslaven v něm, oslaví ho i Bůh sám v sobě a oslaví ho hned. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Synáčkové, ještě krátký čas jsem s vámi. Budete mě hledat, ale jako jsem řekl Židům: ‘Kam já jdu, vy nemůžete přijít,’ to teď říkám i vám.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Dávám vám nové přikázání, abyste se navzájem milovali; jako jsem já miloval vás, abyste i vy milovali jeden druhého. ");
INSERT INTO cesnkb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Podle toho všichni poznají, že jste moji učedníci, když budete mít lásku jedni k druhým.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Šimon Petr mu řekl: “Pane, kam jdeš?” Ježíš mu odpověděl: “Tam, kam jdu, teď nemůžeš jít za mnou, ale půjdeš za mnou potom.” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petr mu řekl: “Pane, proč za tebou nemohu jít teď? Svůj život za tebe položím!” ");
INSERT INTO cesnkb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ježíš mu odpověděl: “Svůj život za mě položíš? Amen, amen, říkám ti: Kohout se neozve, dokud mě třikrát nezapřeš.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ať se vaše srdce nermoutí. Věříte v Boha, věřte i ve mne. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","V domě mého Otce je mnoho příbytků. Kdyby to tak nebylo, pověděl bych vám. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jdu, abych vám připravil místo. A když odejdu a připravím vám místo, zase přijdu a vezmu vás k sobě, abyste i vy byli tam, kde jsem já. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A kam já jdu, víte, i cestu znáte.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomáš mu řekl: “Pane, nevíme, kam jdeš. A jak můžeme znát cestu?” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ježíš mu řekl: “Já jsem ta cesta, pravda i život. Nikdo nepřichází k Otci než skrze mne. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kdybyste znali mne, znali byste i mého Otce; a od nynějška ho znáte a viděli jste ho.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip mu řekl: “Pane, ukaž nám Otce a to nám stačí.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ježíš mu řekl: “Tak dlouhý čas jsem s vámi a nepoznal jsi mě, Filipe? Kdo viděl mne, viděl Otce; jak to, že tedy říkáš: ‘Ukaž nám Otce’? ");
INSERT INTO cesnkb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nevěříš, že já jsem v Otci a Otec ve mně? Slova, která k vám mluvím, nemluvím sám od sebe, ale Otec, který ve mně přebývá, on dělá ty skutky. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Věřte mi, že já jsem v Otci a Otec ve mně; alespoň kvůli těm samotným skutkům mi věřte.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Amen, amen, říkám vám: Kdo věří ve mne, skutky, které dělám já, bude dělat i on; a bude dělat větší skutky než tyto, neboť já jdu ke svému Otci. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","A o cokoli byste poprosili v mém jménu, to udělám, aby byl Otec oslaven v Synu. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Budete-li o něco prosit v mém jménu, já to udělám.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Milujete-li mě, zachovávejte má přikázání. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A já budu prosit Otce a dá vám jiného Utěšitele, aby s vámi zůstal na věky, ");
INSERT INTO cesnkb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","toho Ducha pravdy, jehož svět nemůže přijmout, neboť ho nevidí ani ho nezná. Vy ho však znáte, protože přebývá u vás a bude ve vás. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nenechám vás jako sirotky, přijdu k vám. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ještě krátký čas a svět mě už neuvidí, ale vy mě uvidíte. Protože já žiji, i vy budete žít.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","“V ten den poznáte, že já jsem ve svém Otci a vy ve mně a já ve vás. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kdo má moje přikázání a zachovává je, to je ten, který mě miluje. A kdo mě miluje, bude milován mým Otcem a já ho budu milovat a zjevím mu sám sebe.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (ne ten Iškariotský) mu řekl: “Pane, jak to, že chceš zjevit sám sebe nám, a ne světu?” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ježíš mu odpověděl a řekl: “Jestliže mě někdo miluje, bude zachovávat mé slovo; a můj Otec ho bude milovat a přijdeme k němu a zřídíme si u něj příbytek. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kdo mě nemiluje, nezachovává má slova; a slovo, které slyšíte, není mé, ale Toho, který mě poslal, Otcovo.” ");
INSERT INTO cesnkb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tyto věci jsem k vám mluvil, dokud jsem přebýval u vás. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Avšak Utěšitel, ten Duch Svatý, kterého Otec pošle v mém jménu, ten vás naučí všemu a připomene vám všechno, co jsem vám řekl. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Zanechávám vám pokoj, svůj pokoj vám dávám; já vám dávám, ne jako dává svět. Ať se vaše srdce nermoutí ani nestrachuje. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Slyšeli jste, že jsem vám řekl: ‘Odcházím a zase k vám přijdu.’ Kdybyste mě milovali, radovali byste se, že jsem řekl: ‘Jdu k Otci,’ neboť můj Otec je větší než já. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A řekl jsem vám to teď, předtím než se to stane, abyste až se to stane, uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Už s vámi nebudu mnoho mluvit, protože přichází vládce tohoto světa. Nemá na mně nic, ");
INSERT INTO cesnkb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ale přichází, aby svět poznal, že miluji Otce a že jednám, jak mi Otec přikázal. Vstaňte, pojďme odsud.” ");
INSERT INTO cesnkb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Já jsem ten pravý vinný kmen a můj Otec je vinař. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Každou ratolest, která ve mně nenese ovoce, odřezává a každou, která nese ovoce, čistí, aby nesla více ovoce. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Vy jste již čistí kvůli slovu, které jsem k vám mluvil. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Zůstaňte ve mně a já ve vás. Jako ratolest nemůže nést ovoce sama od sebe, pokud nezůstane ve kmeni, tak ani vy, pokud nezůstanete ve mně. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Já jsem vinný kmen a vy ratolesti. Kdo zůstává ve mně a já v něm, ten nese mnoho ovoce; neboť beze mne nemůžete dělat nic. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jestliže někdo nezůstane ve mně, bude vyhozen ven jako ratolest a uschne; a budou sebrány a hozeny na oheň a shoří. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jestliže zůstanete ve mně a má slova zůstanou ve vás, proste, o cokoli chcete, a stane se vám to. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","V tom bývá oslaven můj Otec, když nesete mnoho ovoce; a budete moji učedníci.” ");
INSERT INTO cesnkb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Jako Otec miloval mne, tak jsem i já miloval vás. Zůstaňte v mé lásce. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Zachováte-li má přikázání, zůstanete v mé lásce, jako jsem já zachoval přikázání svého Otce a zůstávám v jeho lásce. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Toto jsem vám pověděl, aby má radost zůstala ve vás a aby vaše radost byla úplná. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Toto je mé přikázání, abyste se navzájem milovali, jako jsem já miloval vás. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nikdo nemá větší lásku než tu, aby položil svůj život za své přátele. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Vy jste moji přátelé, děláte-li, co vám přikazuji. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nebudu vás už nazývat služebníky, protože služebník neví, co dělá jeho pán. Vás jsem ale nazval přáteli, protože jsem vám oznámil všechno, co jsem slyšel od svého Otce. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ne vy jste vyvolili mne, ale já jsem vyvolil vás a postavil jsem vás, abyste šli a přinesli ovoce a vaše ovoce aby zůstalo; aby vám Otec dal, o cokoli byste ho poprosili v mém jménu. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Toto vám přikazuji, abyste se navzájem milovali.” ");
INSERT INTO cesnkb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Jestliže vás svět nenávidí, vězte, že mne měl v nenávisti dříve než vás. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kdybyste byli ze světa, svět by měl rád, co je jeho; že však nejste ze světa, ale já jsem vás ze světa vyvolil, proto vás svět nenávidí. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pamatujte na slova, která jsem vám řekl: ‘Služebník není větší než jeho pán.’ Jestliže pronásledovali mě, budou pronásledovat i vás; jestliže zachovali mé slovo, zachovají i vaše. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","To všechno vám ale udělají pro mé jméno, neboť neznají Toho, který mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kdybych nepřišel a nemluvil k nim, neměli by hřích, ale teď pro svůj hřích nemají výmluvu. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kdo nenávidí mne, nenávidí i mého Otce. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kdybych mezi nimi nedělal skutky, které neudělal nikdo jiný, neměli by hřích; teď ale viděli a nenáviděli - jak mne, tak mého Otce. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ale to se děje, aby se naplnilo to slovo, které je napsané v jejich Zákoně: ‘Nenáviděli mě bez příčiny.’” ");
INSERT INTO cesnkb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Až však přijde ten Utěšitel, kterého vám já pošlu od Otce, Duch pravdy, který vychází z Otce, ten bude o mně vydávat svědectví. ");
INSERT INTO cesnkb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A vy také vydávejte svědectví, protože jste se mnou od počátku. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Toto jsem vám pověděl, abyste se nenechali svést. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vyobcují vás ze shromáždění, ano, přichází hodina, kdy každý, kdo vás bude zabíjet, se bude domnívat, že tím koná službu Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A to vám udělají, protože nepoznali Otce ani mne. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ale pověděl jsem vám to, abyste si, až ta hodina přijde, vzpomněli, že jsem vám to řekl. Toto jsem vám od začátku neříkal, protože jsem byl s vámi.” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Teď však odcházím k Tomu, který mě poslal, a nikdo z vás se mě neptá: ‘Kam jdeš?’ ");
INSERT INTO cesnkb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ale protože jsem vám pověděl tyto věci, naplnil vaše srdce zármutek. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Já vám však říkám pravdu: Je pro vás užitečné, abych odešel. Jestliže totiž neodejdu, nepřijde k vám Utěšitel; jestliže však odejdu, pošlu ho k vám. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A on, až přijde, bude světu podávat důkaz o hříchu, o spravedlnosti a o soudu. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","O hříchu, že nevěří ve mne, ");
INSERT INTO cesnkb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","o spravedlnosti, že jdu k Otci a už mě neuvidíte, ");
INSERT INTO cesnkb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","a o soudu, že vládce tohoto světa je již odsouzen. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ještě vám mám mnoho co říci, ale teď to nemůžete unést. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Až však přijde on, Duch pravdy, uvede vás do veškeré pravdy. Nebude totiž mluvit sám od sebe, ale cokoli uslyší, to bude mluvit; bude vám oznamovat i věci, které mají přijít. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","On mě oslaví, neboť vezme z mého a bude to oznamovat vám. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Všechno, co má Otec, je mé. Proto jsem řekl, že vezme z mého a bude to oznamovat vám.” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Zakrátko mě už neuvidíte a znovu zakrátko mě uvidíte; protože odcházím k Otci.” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Někteří z jeho učedníků si tedy mezi sebou řekli: “Co znamená to, co nám říká: ‘Zakrátko mě už neuvidíte a znovu zakrátko mě uvidíte’ a: ‘Já odcházím k Otci’?” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Říkali tedy: “Co to znamená, že říká: ‘Zakrátko’? Nevíme, o čem mluví.” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ježíš pak poznal, že se ho chtěli zeptat, a řekl jim: “Dohadujete se mezi sebou o tom, že jsem řekl: ‘Zakrátko mě již neuvidíte a znovu zakrátko mě uvidíte’? ");
INSERT INTO cesnkb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Amen, amen, říkám vám, že vy budete plakat a naříkat, ale svět se bude radovat; budete se rmoutit, ale váš zármutek se obrátí v radost. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Když žena rodí, má bolest, protože přišla její hodina; když ale porodí děťátko, už nevzpomíná na soužení pro radost, že se na svět narodil člověk. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Proto i vy teď máte bolest, ale uvidím vás znovu a vaše srdce se bude radovat a vaši radost vám nikdo nevezme. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A v ten den se mě nebudete ptát na nic. Amen, amen, říkám vám, že o cokoli byste poprosili Otce v mém jménu, to vám dá. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Až dosud jste v mém jménu o nic neprosili. Proste a přijmete to, aby vaše radost byla úplná.” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Toto jsem vám pověděl v přirovnáních, ale přichází hodina, kdy k vám už nebudu mluvit v přirovnáních, ale budu k vám o Otci mluvit otevřeně. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","V ten den budete prosit v mém jménu a neříkám vám, že já budu prosit Otce za vás. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Sám Otec vás totiž má rád, protože jste měli rádi mě a uvěřili jste, že jsem vyšel od Boha. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Vyšel jsem od Otce a přišel jsem na svět; teď zase opouštím svět a jdu k Otci.” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jeho učedníci mu řekli: “Hle, teď mluvíš otevřeně a neříkáš žádné přirovnání. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Teď víme, že víš všechno a nepotřebuješ, aby se tě někdo vyptával. Kvůli tomu věříme, že jsi vyšel od Boha.” ");
INSERT INTO cesnkb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ježíš jim odpověděl: “Teď věříte? ");
INSERT INTO cesnkb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Hle, přichází hodina a již přišla, kdy se rozprchnete každý ke svému a mě necháte samotného. Ale nejsem sám, protože Otec je se mnou. ");
INSERT INTO cesnkb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tyto věci jsem vám pověděl, abyste ve mně měli pokoj. Na světě budete mít soužení, ale buďte stateční: já jsem přemohl svět.” ");
INSERT INTO cesnkb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Když to Ježíš pověděl, pozvedl oči k nebi a řekl: “Otče, přišla ta hodina; oslav svého Syna, aby i tvůj Syn oslavil tebe, ");
INSERT INTO cesnkb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","poněvadž jsi mu dal moc nad veškerým tělem, aby všem těm, které jsi mu dal, dal věčný život. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A toto je ten věčný život, aby poznali tebe, jediného pravého Boha, a toho, kterého jsi poslal, Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Já jsem tě oslavil na zemi; dílo, které jsi mi svěřil, jsem vykonal. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A teď oslav ty mne, Otče, sám u sebe tou slávou, kterou jsem měl u tebe předtím, než byl svět.” ");
INSERT INTO cesnkb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Zjevil jsem tvé jméno lidem, které jsi mi dal ze světa. Byli tvoji a dal jsi je mně; a tvé slovo zachovali. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","A teď poznali, že všechny věci, které jsi mi dal, jsou od tebe. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Neboť slova, která jsi mi dal, jsem dal jim; a oni je přijali a opravdu poznali, že jsem vyšel od tebe, a uvěřili, že ty jsi mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Já prosím za ně; neprosím za svět, ale za ty, které jsi mi dal, neboť jsou tvoji. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A všechny mé věci jsou tvé a tvé jsou mé a jsem v nich oslaven. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Já už nejsem na světě, ale oni jsou na světě a já jdu k tobě. Svatý Otče, zachovej je ve svém jménu, jež jsi mi dal, aby byli jedno jako my. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dokud jsem s nimi byl na světě, zachovával jsem je ve tvém jménu. Chránil jsem ty, které jsi mi dal, a nikdo z nich nezahynul, kromě syna zatracení, aby se naplnilo Písmo. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Teď ale jdu k tobě a toto mluvím na světě, aby v sobě měli plnost mé radosti. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Já jsem jim dal tvé slovo a svět je nenáviděl, protože nejsou ze světa, jako já nejsem ze světa. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Neprosím, abys je vzal ze světa, ale abys je zachoval od toho zlého. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nejsou ze světa, jako ani já nejsem ze světa. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Posvěť je svou pravdou; tvé slovo je pravda. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jako jsi poslal na svět mne, tak jsem i já poslal na svět je. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A já posvěcuji sám sebe za ně, aby i oni byli posvěceni pravdou.” ");
INSERT INTO cesnkb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Neprosím však jen za tyto, ale i za ty, kteří ve mne uvěří skrze jejich slovo, ");
INSERT INTO cesnkb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","aby všichni byli jedno, jako ty, Otče, ve mně a já v tobě, aby i oni byli jedno v nás, aby svět uvěřil, že jsi mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A já jsem jim dal slávu, kterou jsi dal mně, aby byli jedno, jako my jsme jedno. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Já v nich a ty ve mně, aby byli dokonáni v jedno a aby svět poznal, že ty jsi mě poslal a že jsi je miloval, jako jsi miloval mě. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Otče, chci, aby i ti, které jsi mi dal, byli se mnou tam, kde jsem já, aby hleděli na mou slávu, kterou jsi mi dal; neboť jsi mne miloval před založením světa. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Spravedlivý Otče, svět tě nepoznal, ale já jsem tě poznal a i tito poznali, že jsi mě poslal. ");
INSERT INTO cesnkb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A oznámil jsem jim tvé jméno a ještě oznámím, aby láska, kterou jsi mě miloval, byla v nich a já v nich.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Když to Ježíš řekl, vyšel se svými učedníky přes potok Kedron, kde byla zahrada, do které vešel on i jeho učedníci. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","To místo však znal i Jidáš, jeho zrádce, protože se tam Ježíš často scházel se svými učedníky. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jidáš tedy vzal oddíl vojáků a služebníky od velekněží a farizeů a přišel tam s lucernami a s pochodněmi a se zbraněmi. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ježíš, který věděl všechno, co na něj mělo přijít, tedy vyšel a řekl jim: “Koho hledáte?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Odpověděli mu: “Ježíše Nazaretského.” Ježíš jim řekl: “Já jsem to.” A stál tam s nimi i Jidáš, jeho zrádce. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","A jak jim řekl: “Já jsem,” ustoupili nazpět a padli na zem. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Zeptal se jich tedy znovu: “Koho hledáte?” A oni řekli: “Ježíše Nazaretského.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ježíš odpověděl: “Řekl jsem vám, že to jsem já. Jestliže tedy hledáte mě, nechte tyto, ať odejdou.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Aby se naplnilo slovo, které řekl: “Z těch, které jsi mi dal, jsem neztratil nikoho.”) ");
INSERT INTO cesnkb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tehdy Šimon Petr, který měl meč, ho vytasil, zasáhl služebníka nejvyššího kněze a usekl mu pravé ucho. Ten služebník se jmenoval Malchus. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ježíš tedy řekl Petrovi: “Schovej svůj meč do pochvy. Nemám snad pít kalich, který mi dal Otec?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A tak oddíl s velitelem a s židovskými služebníky zajali Ježíše a svázali ho. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A přivedli ho nejdříve k Annášovi; byl totiž tchánem Kaifáše, který byl toho roku nejvyšším knězem. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(A Kaifáš byl ten, který Židům poradil, že je užitečné, aby jeden člověk zemřel za lid.) ");
INSERT INTO cesnkb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Petr a ještě jiný učedník ale šli za Ježíšem. Ten učedník byl známý nejvyššího kněze, a tak vešel s Ježíšem do veleknězova dvora. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ale Petr stál venku u dveří. Ten druhý učedník, který byl známý nejvyššího kněze, tedy vyšel, promluvil s vrátnou a uvedl Petra dovnitř. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta služebná u brány však Petrovi řekla: “Nejsi snad i ty z učedníků toho člověka?” On řekl: “Nejsem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A protože bylo chladno, stáli tam otroci a služebníci, kteří rozdělali oheň, a ohřívali se. A Petr tam byl s nimi; stál a ohříval se. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nejvyšší kněz se tedy Ježíše zeptal na jeho učedníky a na jeho učení. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ježíš mu odpověděl. “Já jsem mluvil ke světu veřejně. Vždycky jsem učil v synagogách nebo v chrámu, kde se Židé vždycky scházejí, a nic jsem nemluvil tajně. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Proč se ptáš mě? Zeptej se těch, kteří slyšeli, co jsem k nim mluvil. Hle, ti vědí, co jsem říkal.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","A když to řekl, jeden ze služebníků, který tam stál, udeřil Ježíše holí se slovy: “Takhle odpovídáš nejvyššímu knězi?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ježíš mu odpověděl: “Jestliže jsem mluvil zle, vydej svědectví o zlém, jestliže však dobře, proč mě biješ?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annáš ho tedy poslal svázaného k nejvyššímu knězi Kaifášovi. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ale Šimon Petr stál a ohříval se. Řekli mu tedy: “Nejsi snad i ty z jeho učedníků? On ho však zapřel a řekl: “Nejsem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jeden ze služebníků nejvyššího kněze, příbuzný toho, kterému Petr usekl ucho, řekl: “Copak jsem tě s ním neviděl v té zahradě?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petr ho tedy znovu zapřel. A vtom zakokrhal kohout. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","A tak Ježíše vedli od Kaifáše do vladařova paláce; a bylo jitro. Sami však do paláce nevešli, aby se neposkvrnili, aby totiž mohli jíst beránka. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilát k nim tedy vyšel a řekl: “Jaké obvinění vznášíte proti tomuto člověku?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Odpověděli mu: “Kdyby to nebyl zločinec, nevydali bychom ti ho.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilát jim tedy řekl: “Vezměte si ho vy a suďte ho podle svého zákona.” Židé mu tedy řekli: “My nemáme dovoleno nikoho zabít.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Aby se naplnilo Ježíšovo slovo, které řekl, když naznačoval, jakou smrtí má zemřít.) ");
INSERT INTO cesnkb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilát tedy znovu vešel do paláce, zavolal Ježíše a řekl mu: “Ty jsi ten židovský král?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ježíš mu odpověděl: “Říkáš to sám od sebe, nebo ti to o mně řekli jiní?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilát odpověděl: “Jsem snad já Žid? Tvůj národ a velekněží mi tě vydali. Co jsi udělal?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ježíš odpověděl: “Mé království není z tohoto světa. Kdyby mé království bylo z tohoto světa, moji služebníci by bojovali, abych nebyl vydán Židům. Teď ale mé království není odsud.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilát mu tedy řekl: “Takže jsi král?” Ježíš odpověděl: “Ty říkáš, že jsem král. Já jsem se proto narodil a proto jsem přišel na svět, abych vydal svědectví pravdě. Každý, kdo je z pravdy, slyší můj hlas.” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilát mu řekl: “Co je pravda?” A když to řekl, vyšel znovu k Židům a řekl jim: “Já na něm žádnou vinu nenalézám. ");
INSERT INTO cesnkb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Je u vás zvykem, abych vám na Velikou noc propustil jednoho vězně. Chcete tedy, abych vám propustil toho židovského krále?” ");
INSERT INTO cesnkb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A všichni znovu vykřikli: “Ne jeho, ale Barabáše!” A ten Barabáš byl zločinec. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tehdy Pilát vzal Ježíše a nechal ho zbičovat. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vojáci upletli korunu z trní a nasadili mu ji na hlavu. Potom mu oblékli purpurový plášť ");
INSERT INTO cesnkb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","a říkali: “Buď zdráv, židovský králi!” A tloukli ho holemi. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilát tedy znovu vyšel ven a řekl jim: “Hle, vyvedu vám ho ven, abyste poznali, že na něm nenacházím žádnou vinu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ježíš tedy vyšel ven. Měl na sobě trnovou korunu a purpurový plášť. Pilát jim řekl: “Hleďte, člověk!” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","A jakmile ho velekněží a jejich služebníci uviděli, vykřikli: “Ukřižuj ho, ukřižuj!” Pilát jim řekl: “Vezměte ho vy a ukřižujte, neboť já na něm žádnou vinu nenalézám.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Židé mu odpověděli: “My máme zákon a podle našeho zákona musí zemřít, protože se dělal Božím Synem.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","A když Pilát uslyšel ta slova, bál se ještě více. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Vešel tedy znovu do paláce a řekl Ježíši: “Odkud jsi?” Ale Ježíš mu nedal odpověď. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilát mu tedy řekl: “Nemluvíš se mnou? Nevíš snad, že mám moc tě ukřižovat a mám moc tě propustit?” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ježíš odpověděl: “Neměl bys nade mnou žádnou moc, kdyby ti to nebylo dáno shůry. Proto ten, kdo mě tobě vydal, má větší hřích.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Od té chvíle ho Pilát usiloval propustit. Ale Židé křičeli: “Jestli ho propustíš, nejsi císařův přítel! Každý, kdo se dělá králem, staví se proti císaři!” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Když tedy Pilát uslyšel ta slova, vyvedl Ježíše ven a posadil se na soudné stolici, na místě zvaném Kamenná dlažba, hebrejsky Gabbatha ");
INSERT INTO cesnkb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","(a byl den připravování před Velikou nocí, okolo šesté hodiny) a řekl Židům: “Hle, váš král.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Oni však vykřikli: “Pryč s ním, pryč! Ukřižuj ho!” Pilát jim řekl: “Mám ukřižovat vašeho krále?” Velekněží odpověděli: “Nemáme krále, jen císaře!” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","A tak jim ho vydal k ukřižování. Vzali tedy Ježíše a odvedli ho. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nesl svůj kříž a vyšel na místo jménem Lebka, hebrejsky nazývané Golgota. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tam ho ukřižovali a s ním dva jiné z obou stran a Ježíše uprostřed. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilát však také napsal nápis a dal ho na kříž. Bylo tam napsáno: “JEŽÍŠ NAZARETSKÝ, ŽIDOVSKÝ KRÁL.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A ten nápis četli mnozí z Židů, neboť to místo, kde byl Ježíš ukřižován, bylo blízko města. A bylo to napsáno hebrejsky, řecky a latinsky. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Židovští velekněží tedy řekli Pilátovi: “Nepiš ‘Židovský král’, ale ‘on řekl: Jsem židovský král.’” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilát odpověděl: “Napsal jsem, co jsem napsal.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Když potom vojáci Ježíše ukřižovali, vzali jeho šaty a udělali z nich čtyři díly, každému vojákovi díl. Vzali mu i košili a ta košile byla nesešívaná, odshora utkaná vcelku. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Řekli si tedy mezi sebou: “Netrhejme ji, ale losujme o ni, čí bude,” aby se naplnilo Písmo, které říká: “Rozdělili si mé šaty mezi sebou a o mé roucho házeli los.” A tak to ti vojáci udělali. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","U Ježíšova kříže však stály jeho matka a sestra jeho matky, Marie Kleofášova a Marie Magdaléna. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Když tedy Ježíš spatřil matku a učedníka, kterého miloval, jak tam stojí, řekl své matce: “Ženo, hle, tvůj syn.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Potom řekl tomu učedníkovi: “Hle, tvá matka.” A od té chvíle ji ten učedník přijal k sobě. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Když potom Ježíš věděl, že je již všechno dokonáno, řekl, aby se naplnilo Písmo: “Žízním.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A stála tam nádoba plná octa. Naplnili tedy houbu octem, dali ji na větev yzopu a podali k jeho ústům. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","A když Ježíš okusil ten ocet, řekl: “Je dokonáno!” Sklonil hlavu a odevzdal ducha Otci. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A protože byl den připravování, požádali Židé Piláta, aby odsouzeným byly zlámány nohy a byli sňati, aby těla nezůstala na kříži do soboty (tu sobotu byl totiž velký den). ");
INSERT INTO cesnkb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A tak přišli vojáci a zlámali nohy prvnímu i druhému, který byl ukřižován s ním. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Když ale přišli k Ježíši a uviděli, že je již mrtev, nelámali mu nohy, ");
INSERT INTO cesnkb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ale jeden z vojáků probodl jeho bok kopím a hned vyšla krev a voda. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A ten, který to viděl, vydal svědectví a jeho svědectví je pravdivé. On ví, že říká pravdu, abyste vy uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Neboť toto se stalo, aby se naplnilo Písmo: “Jeho kost nebude zlomena.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A opět jiné Písmo říká: “Pohlédnou na toho, kterého probodli.” ");
INSERT INTO cesnkb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Potom tedy Josef z Arimatie (který byl Ježíšův učedník, ale tajný, kvůli strachu před Židy) poprosil Piláta, aby mohl sejmout Ježíšovo tělo. Pilát svolil, a tak přišel a sňal Ježíšovo tělo. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A přišel i Nikodém (který předtím přišel k Ježíši v noci) a nesl směs myrhy a aloe, okolo sta liber. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Vzali tedy Ježíšovo tělo a zavinuli ho do pláten s těmi vonnými věcmi, jak je u Židů zvykem pochovávat. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A na tom místě, kde byl ukřižován, byla zahrada a v té zahradě nový hrob, v němž ještě nebyl nikdo pochován. ");
INSERT INTO cesnkb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tam tedy Ježíše pochovali kvůli židovskému dni připravování, protože ten hrob byl blízko. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Prvního dne týdne pak šla Marie Magdaléna za svítání k hrobu, když byla ještě tma, a spatřila kámen odvalený od hrobu. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Běžela tedy a přišla k Šimonu Petrovi a k druhému učedníkovi, kterého měl Ježíš rád, a řekla jim: “Pána vzali z hrobu a nevíme, kam ho položili!” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petr tedy vyšel, i ten druhý učedník a šli k hrobu. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","A běželi oba spolu, ale ten druhý učedník Petra předběhl a přišel k hrobu první. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A když se naklonil dovnitř, spatřil ležící plátna, ale nevešel tam. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tehdy přišel Šimon Petr, který šel za ním, vešel do hrobu a spatřil položená plátna ");
INSERT INTO cesnkb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","a roušku, která byla na jeho hlavě, položenou ne s plátny, ale zvlášť svinutou na jednom místě. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Potom tedy vešel i ten druhý učedník, který přišel k hrobu první, a uviděl a uvěřil. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ještě totiž nepochopili Písmo, že Kristus musí vstát z mrtvých.) ");
INSERT INTO cesnkb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A tak ti učedníci zase odešli k sobě domů. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ale Marie stála venku u hrobu a plakala. A jak plakala, naklonila se do hrobu ");
INSERT INTO cesnkb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","a uviděla dva sedící anděly v bílém rouchu, jednoho u hlavy a druhého u nohou, tam, kde leželo Ježíšovo tělo. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ti jí řekli: “Ženo, proč pláčeš?” Řekla jim: “Vzali mého Pána a nevím, kam ho položili.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A když to řekla, obrátila se zpátky a spatřila Ježíše, jak tam stojí, ale nevěděla, že je to Ježíš. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ježíš jí řekl: “Ženo, proč pláčeš? Koho hledáš?” Ona mu v domnění, že je to zahradník, řekla: “Pane, jestli jsi ho odnesl ty, řekni mi, kam jsi ho položil, a já si ho vezmu.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ježíš jí řekl: “Marie!” Ona se obrátila a řekla mu: “Rabboni!” (což znamená Učiteli). ");
INSERT INTO cesnkb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ježíš jí řekl: “Nedotýkej se mne, neboť jsem ještě nevystoupil ke svému Otci. Ale jdi k mým bratrům a řekni jim: ‘Vystupuji ke svému Otci a k vašemu Otci, ke svému Bohu a k vašemu Bohu.’” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Marie Magdaléna pak přišla a oznámila učedníkům, že viděla Pána a že jí řekl tyto věci. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A když byl večer téhož dne, toho prvního dne týdne, a tam, kde se učedníci shromáždili, byly zavřené dveře kvůli strachu před Židy, přišel Ježíš, postavil se doprostřed a řekl jim: “Pokoj vám.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A když to řekl, ukázal jim své ruce i bok. A když učedníci uviděli Pána, zaradovali se. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ježíš jim tedy znovu řekl: “Pokoj vám. Jako mě poslal Otec, i já posílám vás.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A když to pověděl, dechl a řekl jim: “Přijměte Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Komukoli odpustíte hříchy, těm jsou odpuštěny; komukoli je zadržíte, těm jsou zadrženy.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomáš zvaný Didymus, jeden z dvanácti, však nebyl s nimi, když Ježíš přišel. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ostatní učedníci mu říkali: “Viděli jsme Pána!” ale on jim řekl: “Dokud neuvidím stopu hřebů v jeho rukou a nestrčím svůj prst na místo hřebů a dokud nevložím svou ruku do jeho boku, nikdy neuvěřím.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A po osmi dnech byli jeho učedníci znovu uvnitř a Tomáš s nimi. Ježíš přišel (a dveře byly zavřené) a postavil se doprostřed a řekl: “Pokoj vám.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Potom řekl Tomášovi: “Dej svůj prst sem a pohleď na mé ruce, vztáhni svou ruku a vlož ji do mého boku; a nebuď nevěřící, ale věřící.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","A Tomáš odpověděl slovy: “Můj Pán a můj Bůh!” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ježíš mu řekl: “Tomáši, uvěřil jsi, protože jsi mě viděl. Blaze těm, kteří neviděli, a uvěřili.” ");
INSERT INTO cesnkb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ježíš ovšem před svými učedníky udělal i mnoho jiných zázraků, které nejsou zapsány v této knize. ");
INSERT INTO cesnkb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ale tyto jsou zapsány, abyste uvěřili, že Ježíš je Kristus, Syn Boží, a abyste, když budete věřit, měli život v jeho jménu. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Potom se Ježíš znovu ukázal učedníkům u Tiberiadského moře. A ukázal se takto: ");
INSERT INTO cesnkb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Šimon Petr, Tomáš zvaný Didymus, Natanael, který byl z Kány Galilejské, synové Zebedeovi a další dva z jeho učedníků byli spolu. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Šimon Petr jim řekl: “Jdu lovit ryby.” Řekli mu: “My s tebou půjdeme také.” Šli tedy a hned nastoupili na loď. A té noci nic nechytili. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Když pak nastalo jitro, Ježíš stál na břehu. Učedníci ale nevěděli, že je to Ježíš. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ježíš jim tedy řekl: “Děti, nemáte něco k jídlu?” Odpověděli mu: “Nemáme.” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","On jim však řekl: “Hoďte síť napravo od lodi a najdete.” Hodili tedy a už ji nemohli vytáhnout pro množství ryb. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ten učedník, kterého Ježíš miloval, tedy řekl Petrovi: “To je Pán!” A když Šimon Petr uslyšel, že je to Pán, přepásal se pláštěm (protože byl svlečený) a vrhl se do moře. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ostatní učedníci pak připluli na lodi (neboť byli nedaleko od země, jen asi dvě stě loket) a táhli tu síť s rybami. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","A když vystoupili na zem, viděli rozdělaný oheň a na něm rybu a chléb. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ježíš jim řekl: “Přineste něco ryb, které jste teď chytili.” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Šimon Petr tedy vystoupil na loď a vytáhl na zem síť plnou velkých ryb: bylo jich sto padesát tři. A i když jich bylo tak mnoho, síť se neroztrhla. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ježíš jim řekl: “Pojďte, posnídejte.” Nikdo z učedníků se ho však neodvažoval zeptat: “Kdo jsi?” protože věděli, že je to Pán. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ježíš tedy přistoupil, vzal ten chléb a dával jim a podobně i rybu. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","To se Ježíš už potřetí ukázal svým učedníkům poté, co vstal z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","A když posnídali, zeptal se Ježíš Šimona Petra: “Šimone Jonášův, miluješ mě více než tito?” On mu řekl: “Ano, Pane, ty víš, že tě mám rád.” Řekl mu: “Krm mé beránky.” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Zeptal se ho znovu, podruhé: “Šimone Jonášův, miluješ mě?” Řekl mu: “Ano, Pane, ty víš, že tě mám rád.” Řekl mu: “Pas mé ovce.” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Zeptal se ho potřetí: “Šimone Jonášův, máš mě rád?” Tehdy se Petr zarmoutil, protože se ho potřetí zeptal: “Máš mě rád?” a odpověděl mu: “Pane, ty víš všechno, ty víš, že tě mám rád.” Ježíš mu řekl: “Krm mé ovce. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Amen, amen, říkám ti: Když jsi byl mladší, opásával ses a chodíval jsi, kam jsi chtěl; ale až zestárneš, vztáhneš své ruce a opáše tě jiný a povede tě, kam nechceš.” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","To řekl, aby mu naznačil, jakou smrtí oslaví Boha. A když to pověděl, řekl mu: “Následuj mě.” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petr se obrátil, uviděl toho učedníka, kterého Ježíš miloval, jak jde za ním (a to byl ten, který při večeři spočinul na jeho prsou a řekl: “Pane, kdo je ten, který tě zrazuje?”). ");
INSERT INTO cesnkb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Když ho Petr uviděl, řekl Ježíši: “Pane, a co tento?” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ježíš mu řekl. “Kdybych chtěl, aby tu zůstal, dokud nepřijdu, co s tím máš ty? Ty mě následuj.” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A tak se mezi bratry roznesla řeč, že ten učedník nezemře. Ježíš mu však neřekl, že nezemře, ale: “Kdybych chtěl, aby tu zůstal, dokud nepřijdu, co s tím máš ty?” ");
INSERT INTO cesnkb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","To je ten učedník, který vydává svědectví o těchto věcech a zapsal je; a víme, že jeho svědectví je pravdivé. ");
INSERT INTO cesnkb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Je ovšem i mnoho jiných věcí, které Ježíš udělal, které kdyby měly být vypsány každá zvlášť, mám za to, že by ani celý svět nemohl pojmout ty knihy, které by byly napsány. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","První zprávu jsem zajisté sepsal, ó Teofile, o všech věcech, které Ježíš začal dělat i učit ");
INSERT INTO cesnkb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","až do dne, kdy byl vzat vzhůru, když skrze Ducha Svatého dal přikázání apoštolům, které vyvolil. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Těm také po svém utrpení mnoha jistými důkazy prokázal, že je živý, když se jim po čtyřicet dní ukazoval a mluvil o Božím království. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A když je shromáždil, přikázal jim, aby neodcházeli z Jeruzaléma, ale aby očekávali Otcovo zaslíbení, “které jste,” jak řekl, “slyšeli ode mne; ");
INSERT INTO cesnkb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","neboť Jan zajisté křtil vodou, ale vy budete pokřtěni Duchem Svatým po těchto nemnoha dnech.” ");
INSERT INTO cesnkb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Když se tedy spolu sešli, zeptali se ho: “Pane, obnovíš pro Izrael království v tomto čase?” ");
INSERT INTO cesnkb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","On jim však řekl: “Není vaše věc znát časy nebo doby, které Otec uložil ve své moci; ");
INSERT INTO cesnkb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ale přijmete moc Ducha Svatého přicházejícího na vás a budete mi svědky v Jeruzalémě, v celém Judsku i v Samaří a až do posledních končin země.” ");
INSERT INTO cesnkb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A když to pověděl, byl před jejich zraky vyzdvižen vzhůru a oblak jim ho vzal z očí. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Když se pak za ním upřeně dívali, jak odchází do nebe, hle, postavili se k nim dva muži v bílém rouchu, ");
INSERT INTO cesnkb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","kteří jim řekli: “Muži galilejští, co stojíte a hledíte do nebe? Tento Ježíš, který byl od vás vzat vzhůru do nebe, přijde stejným způsobem, jak jste ho viděli odcházet do nebe.” ");
INSERT INTO cesnkb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tehdy se vrátili do Jeruzaléma od hory zvané Olivetská, která je blízko Jeruzaléma - ve vzdálenosti jedné sobotní cesty. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","A když vešli, vystoupili do horní místnosti domu, kde pobývali: Petr, Jakub, Jan a Ondřej, Filip a Tomáš, Bartoloměj a Matouš, Jakub Alfeův a Šimon Zélótes a Juda Jakubův. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ti všichni zůstávali jednomyslně v modlitbě a prosbě se ženami, i s Marií, Ježíšovou matkou, a s jeho bratry. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","V těch dnech pak povstal uprostřed učedníků Petr (počet lidí byl dohromady asi sto dvacet) a řekl: ");
INSERT INTO cesnkb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bratři, muselo se naplnit to Písmo, které Davidovými ústy předpověděl Duch Svatý o Jidáši, který se stal vůdcem těch, kdo zajali Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Neboť byl započítán mezi nás a obdržel podíl na této službě.” ");
INSERT INTO cesnkb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ten tedy získal za odměnu své nepravosti pole, ale když spadl střemhlav, roztrhl se v půli a všechny jeho vnitřnosti vyhřezly. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A to vešlo ve známost všem obyvatelům Jeruzaléma, takže to pole bylo v jejich vlastním jazyce pojmenováno Akeldama, to jest Pole krve.) ");
INSERT INTO cesnkb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“V knize Žalmů je přece napsáno: ‘Jeho příbytek ať zpustne a ať není, kdo by v něm bydlel’ a: ‘Jeho úřad ať zaujme jiný.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Proto musí jeden z těch mužů, kteří s námi chodili po celý čas, kdy Pán Ježíš přebýval mezi námi, ");
INSERT INTO cesnkb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","počínaje Janovým křtem až do toho dne, kdy byl od nás vzat vzhůru, být s námi svědkem jeho vzkříšení.” ");
INSERT INTO cesnkb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Postavili tedy dva: Josefa zvaného Barsabáš (který měl příjmení Justus) a Matěje. ");
INSERT INTO cesnkb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","A když se pomodlili, řekli: “Ty, Pane, který znáš všechna srdce, ukaž, kterého jsi vyvolil z těchto dvou, ");
INSERT INTO cesnkb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","aby obdržel podíl na této službě a apoštolství, od něhož Jidáš odstoupil, aby odešel na své místo.” ");
INSERT INTO cesnkb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dali jim tedy losy a los padl na Matěje. A tak byl připočten k jedenácti apoštolům. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Když pak přišel den Letnic, byli všichni jednomyslně spolu. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","A náhle nastal zvuk z nebe, jako valícího se prudkého větru, a naplnil celý dům, kde seděli. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tehdy se jim ukázaly jakoby rozdělené jazyky ohně a posadily se na každém z nich. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A všichni byli naplněni Duchem Svatým a začali mluvit jinými jazyky, jak jim Duch dával promlouvat. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","V Jeruzalémě tehdy přebývali Židé, zbožní muži z každého národa pod nebem. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","A když nastal ten zvuk, sešlo se množství lidí a byli zmateni, protože je každý slyšel, jak mluví jeho vlastním jazykem. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Všichni tedy žasli a v údivu říkali jedni druhým: “Hleďte, copak nejsou ti všichni, kteří tu mluví, Galilejci? ");
INSERT INTO cesnkb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Jak to, že tedy každý slyšíme svůj vlastní jazyk, ve kterém jsme se narodili? ");
INSERT INTO cesnkb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthové, Médové, Elamité a obyvatelé Mezopotámie, Judska i Kappadokie, Pontu a Asie, ");
INSERT INTO cesnkb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frygie i Pamfylie, Egypta i krajů Libye vedle Kyrény a příchozí z Říma, Židé i proselyté, ");
INSERT INTO cesnkb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kréťané i Arabové - slyšíme je mluvit našimi jazyky o velikých Božích věcech!” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A tak všichni žasli a bezradně říkali jeden druhému: “Co má tohle znamenat?” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jiní se ale posmívali a říkali: “Jsou opilí novým vínem!” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petr však spolu s jedenácti povstal, pozvedl svůj hlas a promluvil: “Muži z Judska i všichni, kteří přebýváte v Jeruzalémě, toto ať je vám známo a vyslechněte má slova: ");
INSERT INTO cesnkb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jistěže tito nejsou opilí, jak se domníváte. Vždyť je teprve třetí denní hodina! ");
INSERT INTO cesnkb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ale toto je to, co bylo předpověděno ústy proroka Joele: ");
INSERT INTO cesnkb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘A stane se v posledních dnech, praví Bůh, že vyleji ze svého Ducha na veškeré tělo a vaši synové i vaše dcery budou prorokovat; vaši mladíci budou vídat vidění a vaši starci budou mívat sny. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","V těch dnech zajisté vyleji ze svého Ducha na své služebníky i na své služebnice a budou prorokovat. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","A ukážu zázraky nahoře na nebi a znamení dole na zemi, krev a oheň a oblaka dýmu. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Slunce se obrátí v temnotu a měsíc v krev, dříve než přijde ten veliký a zjevný Pánův den. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","A stane se, že každý, kdo bude vzývat jméno Pána, bude spasen.’” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Izraelité, slyšte tato slova: Ježíše Nazaretského, toho muže, kterého mezi vámi Bůh prokázal divy, zázraky a znameními, které skrze něho Bůh dělal uprostřed vás, jak sami víte, ");
INSERT INTO cesnkb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","toho jste, vydaného z Božího uloženého rozhodnutí a předzvědění, vzali a zabili ukřižováním skrze ruce bezbožníků. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bůh ho ale vzkřísil a zprostil bolestí smrti, protože nebylo možné, aby ho držela ve své moci. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David přece o něm říká: ‘Viděl jsem Pána vždycky před sebou, neboť je mi po pravici, abych nezakolísal. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Proto se mé srdce rozveselilo a můj jazyk zajásal, nadto i mé tělo spočine v naději. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Neboť nenecháš mou duši v pekle a svému Svatému nedáš spatřit porušení. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oznámil jsi mi cesty života a svou tváří mě naplníš potěšením.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bratři, mohu vám směle říci o patriarchovi Davidovi, že zemřel a byl pochován a jeho hrob je u nás až do dnešního dne. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","A poněvadž byl prorok a věděl, že se mu Bůh zavázal přísahou, že z plodu jeho beder pozdvihne Krista podle těla a posadí ho na jeho trůn, ");
INSERT INTO cesnkb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","viděl to předem a mluvil o Kristově vzkříšení, že jeho duše ‘nebyla zanechána v pekle’ a jeho tělo ‘nespatřilo porušení’. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tohoto Ježíše Bůh vzkřísil a my všichni jsme toho svědky. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Když byl tedy Boží pravicí vyvýšen, přijal od Otce zaslíbení Ducha Svatého a vylil to, co nyní vidíte a slyšíte. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David přece nevystoupil do nebe, ale sám říká: ‘Pán řekl mému Pánu: Seď po mé pravici, ");
INSERT INTO cesnkb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dokud nepoložím tvé nepřátele za podnož tvých nohou.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ať tedy ví s jistotou všechen dům Izraele, že Bůh ho učinil Pánem a Kristem - toho Ježíše, kterého jste vy ukřižovali.” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","A když to slyšeli, byli zasaženi v srdci a řekli Petrovi i ostatním apoštolům: “Co máme dělat, bratři?” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petr jim tedy řekl: “Čiňte pokání a ať se každý z vás pokřtí ve jménu Ježíše Krista na odpuštění hříchů a přijmete dar Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","To zaslíbení totiž platí vám i vašim dětem i všem, kdo jsou daleko, kohokoli povolá Pán, náš Bůh.” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dosvědčoval to ještě mnoha jinými slovy a vyzýval je: “Zachraňte se z tohoto zvráceného pokolení!” ");
INSERT INTO cesnkb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ti, kteří ochotně přijali jeho slova, tedy byli pokřtěni. V ten den se připojilo okolo tří tisíc duší ");
INSERT INTO cesnkb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","a zůstávali v apoštolském učení a ve společenství, v lámání chleba a v modlitbách. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na každou duši tedy přišla bázeň a skrze apoštoly se dělo mnoho zázraků a znamení. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Všichni věřící pak byli pospolu a měli všechno společné. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Prodávali pozemky a majetky a rozdělovali je všem, jak kdo potřeboval. ");
INSERT INTO cesnkb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Každý den také zůstávali jednomyslně v chrámu a po domech lámali chléb a přijímali pokrm s radostí a prostotou srdce; ");
INSERT INTO cesnkb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","chválili Boha a měli milost u všeho lidu. A Pán denně přidával církvi ty, kteří byli spaseni. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petr a Jan potom vstupovali v hodinu modlitby (to jest o deváté) do chrámu. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A byl tam nesen jeden muž, chromý od lůna své matky, kterého každý den pokládali u chrámové brány zvané Krásná, aby ty, kdo vcházeli do chrámu, prosil o almužnu. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ten uviděl Petra a Jana, jak se chystají vejít do chrámu, a prosil je o almužnu. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petr však na něj s Janem upřel zrak a řekl: “Podívej se na nás.” ");
INSERT INTO cesnkb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pozoroval je tedy s očekáváním, že od nich něco přijme. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ale Petr řekl: “Stříbro a zlato nemám, ale co mám, to ti dám. Ve jménu Ježíše Krista Nazaretského vstaň a choď!” ");
INSERT INTO cesnkb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Uchopil ho za pravou ruku a zvedl ho; a tehdy se jeho nohy a klouby ihned zpevnily. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A když vyskočil, stál a chodil a vešel s nimi do chrámu, kde se procházel, poskakoval a chválil Boha. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Všechen lid ho tedy viděl, jak chodí a chválí Boha, ");
INSERT INTO cesnkb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","a poznali, že je to ten, který kvůli almužně sedával u chrámové Krásné brány, a byli naplněni děsem a úžasem nad tím, co se mu přihodilo. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A když se ten uzdravený chromý držel Petra a Jana, seběhl se k nim všechen vyděšený lid do sloupoví zvaného Šalomounovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Když to tedy Petr uviděl, promluvil k lidu: “Proč se tomu divíte, Izraelité? A proč se na nás tak upřeně díváte, jako bychom svou vlastní mocí nebo zbožností způsobili, že tento člověk chodí? ");
INSERT INTO cesnkb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bůh Abrahama, Izáka a Jákoba, Bůh našich otců oslavil svého služebníka Ježíše, kterého jste vy vydali a jehož jste se zřekli před Pilátem, když se rozhodl, že ho propustí. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Zřekli jste se toho Svatého a Spravedlivého a vyžádali jste si, aby vám byl vydán vrah. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Zabili jste Původce života, kterého Bůh vzkřísil z mrtvých; a my jsme toho svědky. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Skrze víru v jeho jméno dalo jeho jméno sílu tomuto muži, kterého vidíte a znáte. Ano, víra, která je skrze něho, mu dala toto plné zdraví před očima vás všech. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Teď však vím, bratři, že jste to udělali z nevědomosti, stejně jako vaši vůdcové. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bůh však takto naplnil, co předpověděl ústy všech svých proroků: že Kristus bude trpět. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Proto čiňte pokání a obraťte se, aby vaše hříchy byly smazány a přišly časy osvěžení od Pánovy tváře ");
INSERT INTO cesnkb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","a aby poslal toho, který vám byl předem kázán, Ježíše Krista, ");
INSERT INTO cesnkb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","kterého musí nebe držet až do časů nápravy všech věcí, o nichž Bůh mluvil od věků ústy všech svých svatých proroků. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mojžíš přece řekl otcům: ‘Pán, váš Bůh, vám vzbudí z vašich bratrů Proroka jako mne; toho budete poslouchat ve všem, cokoli vám řekne. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A stane se, že každá duše, která by toho Proroka neuposlechla, bude vyhlazena z lidu.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ano, také všichni proroci, kteří mluvili od Samuele a po něm, předpovídali tyto dny. ");
INSERT INTO cesnkb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vy jste synové proroků a smlouvy, kterou Bůh uzavřel s našimi otci, když řekl Abrahamovi: ‘Ve tvém semeni budou požehnána všechna pokolení země.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Vám jako prvním vzbudil Bůh svého služebníka Ježíše a poslal ho žehnat vám, aby každého odvrátil od jeho nepravostí.” ");
INSERT INTO cesnkb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","A když ještě mluvili k lidu, přišli na ně kněží s velitelem chrámové stráže a saduceji, ");
INSERT INTO cesnkb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","protože těžce nesli, že učí lid a kážou vzkříšení z mrtvých skrze Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chopili se jich tedy a dali je až do druhého dne do vězení, protože už byl večer. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mnozí z těch, kdo uslyšeli Slovo, však uvěřili. A počet mužů dosáhl asi pěti tisíc. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Druhého dne se pak stalo, že se v Jeruzalémě sešli židovští hodnostáři, starší a zákoníci, ");
INSERT INTO cesnkb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","nejvyšší kněz Annáš i Kaifáš, Jan, Alexandr a všichni, kdo byli z velekněžského rodu. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A když je postavili doprostřed, vyptávali se: “Jakou mocí a v jakém jménu jste to udělali?” ");
INSERT INTO cesnkb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tehdy jim Petr, naplněn Duchem Svatým, řekl: “Vůdcové lidu a starší Izraele: ");
INSERT INTO cesnkb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Poněvadž jsme dnes vyslýcháni pro dobrý skutek při nemocném člověku, kterým byl uzdraven, ");
INSERT INTO cesnkb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ať je známo vám všem i všemu lidu Izraele, že ve jménu Ježíše Krista Nazaretského, kterého jste vy ukřižovali, jehož Bůh vzkřísil z mrtvých, skrze toho stojí před vámi tento člověk zdravý. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","To je ten ‘kámen, zavržený vámi staviteli, který se stal hlavním kamenem klenby’. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","A v nikom jiném není spasení, protože lidem není dáno jiné jméno pod nebem, v němž bychom měli být spaseni.” ");
INSERT INTO cesnkb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Když tedy viděli Petrovu a Janovu smělost a shledali, že jsou to neučení a prostí lidé, divili se a poznali na nich, že byli s Ježíšem. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","A když viděli toho člověka, který byl uzdraven, jak stojí s nimi, neměli, co by proti nim řekli. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Poručili jim tedy, aby odešli z velerady ven, a radili se spolu. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Říkali: “Co s těmi lidmi uděláme? Všem přebývajícím v Jeruzalémě je přece známo, že se skrze ně stal zjevný zázrak, a my to nemůžeme popřít. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aby se to ale mezi lidmi více nešířilo, důrazně jim pohrozme, aby v tom jménu už k žádnému člověku nemluvili.” ");
INSERT INTO cesnkb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Zavolali je tedy a přikázali jim, aby už vůbec nemluvili ani neučili v Ježíšově jménu. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Petr a Jan jim však odpověděli: “Posuďte, zda je v Božích očích spravedlivé, abychom vás poslouchali více než Boha. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","My totiž nemůžeme nemluvit o tom, co jsme viděli a slyšeli.” ");
INSERT INTO cesnkb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","A když nenalézali nic, za co by je potrestali, znovu jim pohrozili a kvůli lidu je propustili; všichni totiž oslavovali Boha za to, co se stalo. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A tomu člověku, na kterém se stal ten zázrak uzdravení, bylo přes čtyřicet let. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Když tedy byli propuštěni, přišli ke svým a vyprávěli, co jim řekli velekněží a starší. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","A když to bratři uslyšeli, pozvedli jednomyslně hlas k Bohu a řekli: “Hospodine, ty jsi Bůh, který stvořil nebe i zemi, moře i všechno, co je v nich, ");
INSERT INTO cesnkb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","který jsi ústy Davida, svého služebníka, řekl: ‘Proč se rozzuřily národy a lidé vymýšleli marnosti? ");
INSERT INTO cesnkb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Králové země povstali a vládci se spolu shromáždili proti Pánu a proti jeho Pomazanému.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A opravdu se proti tvému svatému služebníku Ježíši, kterého jsi pomazal, sešli Herodes a Pontský Pilát s pohany a lidem Izraele, ");
INSERT INTO cesnkb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","aby udělali to, co tvá ruka a tvá vůle předurčila, aby se stalo. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nyní, Pane, pohleď na jejich výhrůžky a dej svým služebníkům mluvit tvé slovo se vší smělostí, ");
INSERT INTO cesnkb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","když budeš vztahovat svou ruku k uzdravování a k činění znamení a zázraků skrze jméno svého svatého služebníka Ježíše.” ");
INSERT INTO cesnkb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","A když se modlili, zatřáslo se to místo, na kterém byli shromážděni, a všichni byli naplněni Duchem Svatým a mluvili Boží slovo se smělostí. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","To množství věřících pak mělo jedno srdce a jednu duši. Nikdo ani nenazýval nic z toho, co měl, svým vlastním, ale měli všechny věci společné. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apoštolové vydávali velikou mocí svědectví o vzkříšení Pána Ježíše a veliká milost byla na nich všech. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nikdo mezi nimi neměl nouzi, protože všichni, kdo vlastnili pole nebo domy, je prodávali a peníze, za které je prodali, přinášeli ");
INSERT INTO cesnkb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a pokládali k nohám apoštolů. To pak bylo rozdělováno každému podle toho, jak kdo potřeboval. ");
INSERT INTO cesnkb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","A Jozes, který měl od apoštolů jméno Barnabáš (což v překladu znamená Syn potěšení), levíta rodem z Kypru, ");
INSERT INTO cesnkb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","prodal své pole, přinesl peníze a položil je k nohám apoštolů. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jeden muž jménem Ananiáš však se svou manželkou Zafírou prodal pozemek ");
INSERT INTO cesnkb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","a s vědomím své manželky z těch peněz lstivě ubral. Potom přinesl určitou část a položil ji k nohám apoštolů. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petr však řekl: “Ananiáši, proč Satan naplnil tvé srdce, abys lhal Duchu Svatému a lstivě ubral z peněz za to pole? ");
INSERT INTO cesnkb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Copak nebylo tvé, když zůstávalo neprodané? A když bylo prodáno, bylo ve tvé moci. Proč ses tedy ve svém srdci rozhodl k takovému činu? Nezalhal jsi lidem, ale Bohu!” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Když pak Ananiáš uslyšel ta slova, padl a vypustil duši. A na všechny, kteří to slyšeli, přišla veliká bázeň. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mládenci tedy vstali, zabalili ho, vynesli ven a pochovali. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A stalo se, že po uplynutí asi tří hodin přišla i jeho žena, která nevěděla, co se stalo. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petr jí tedy řekl: “Pověz mi, zda jste to pole prodali za tolik?” A ona řekla: “Ano, za tolik.” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petr jí však řekl: “Proč jste se smluvili, abyste pokoušeli Pánova Ducha? Hle, nohy těch, kteří pochovali tvého muže, jsou přede dveřmi, a vynesou i tebe!” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","A ihned padla k jeho nohám a vypustila duši. A když mladíci vešli, nalezli ji mrtvou. Vynesli ji tedy a pochovali vedle jejího muže. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na celou církev i na všechny, kdo to slyšeli, pak přišla veliká bázeň. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Skrze ruce apoštolů se tedy dělo mezi lidem mnoho znamení a zázraků a všichni bývali jednomyslně spolu v Šalomounově sloupoví. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nikdo jiný se k nim však neodvažoval připojit, ale lid si jich velice vážil. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","K Pánu se pak přidávalo stále více věřících, množství mužů i žen, ");
INSERT INTO cesnkb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","takže i na ulice vynášeli nemocné a pokládali je na lůžka a nosítka, aby když tudy půjde Petr, alespoň jeho stín padl na některého z nich. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Do Jeruzaléma se také scházelo množství lidí z okolních měst, kteří přinášeli nemocné a trápené nečistými duchy a ti všichni byli uzdravováni. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tehdy povstal nejvyšší kněz a všichni, kdo byli s ním (což je ta sekta saduceů), naplněni závistí, ");
INSERT INTO cesnkb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","a chopili se apoštolů a vsadili je do veřejné věznice. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ale Pánův anděl v noci otevřel dveře vězení, vyvedl je ven a řekl: ");
INSERT INTO cesnkb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Jděte, postavte se v chrámu a mluvte lidu všechna slova tohoto života.” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Když to tedy uslyšeli, vešli za úsvitu do chrámu a učili. Když pak přišel nejvyšší kněz i ti, kdo byli s ním, svolali veleradu (to jest celé staršovstvo synů Izraele) a poslali do vězení, aby je přivedli. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Když ale služebníci přišli, nenašli je ve vězení. Vrátili se tedy a oznámili: ");
INSERT INTO cesnkb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Vězení jsme sice našli bezpečně zavřené, také strážné stojící venku přede dveřmi, ale když jsme otevřeli, nikoho jsme uvnitř nenašli.” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","A když ta slova nejvyšší kněz s velitelem chrámové stráže a velekněžími uslyšel, byli bezradní nad tím, co se to mohlo stát. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tehdy někdo přišel a oznámil jim: “Hle, muži, které jste vsadili do vězení, stojí v chrámu a učí lid!” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tehdy velitel se služebníky odešel a přivedl je bez násilí; báli se totiž, aby je lid neukamenoval. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","A když je přivedli a postavili ve veleradě, zeptal se jich nejvyšší kněz: ");
INSERT INTO cesnkb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Copak jsme vám přísně nepřikázali, abyste v tom jménu neučili? A hle, naplnili jste Jeruzalém svým učením a chcete krev toho člověka uvést na nás!” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petr a apoštolové však odpověděli: “Je třeba více poslouchat Boha než lidi. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Bůh vašich otců vzkřísil Ježíše, kterého jste vy pověsili na dřevo a zabili. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jeho Bůh vyvýšil svou pravicí jako Vůdce a Spasitele, aby dal Izraeli pokání a odpuštění hříchů. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","A my jsme svědky těchto věcí, a také Duch Svatý, kterého dal Bůh těm, kdo ho poslouchají.” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Když to tedy uslyšeli, rozzuřili se a začali se radit, jak by je zabili. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tehdy vstal ve veleradě jeden farizeus jménem Gamaliel, učitel Zákona ctěný vším lidem, a poručil, aby byli apoštolové na chvíli vyvedeni ven. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Potom jim řekl: “Izraelité, dejte si pozor na to, co chcete udělat s těmito lidmi. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Vždyť před těmito dny povstal Teudas; říkal o sobě, že je někým, a připojilo se k němu množství okolo čtyř set mužů. Ten byl zabit a všichni, kdo ho poslouchali, byli rozptýleni a obráceni vniveč. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Po něm povstal za dnů soupisu Juda Galilejský a strhl za sebou mnoho lidí. Ale i ten zahynul a všichni, kdo ho poslouchali, byli rozptýleni. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Proto vám nyní říkám: Odstupte od těchto lidí a nechte je. Jestliže je totiž tento úmysl nebo toto dílo z lidí, rozpadne se. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Je-li však z Boha, nebudete to moci zrušit. Abyste snad nakonec nebyli shledáni jako Boží nepřátelé!” ");
INSERT INTO cesnkb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A tak ho poslechli. Zavolali apoštoly, zmrskali je, přikázali jim, aby nemluvili v Ježíšově jménu a propustili je. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Oni tedy šli z té velerady s radostí, že byli hodni trpět potupu pro jeho jméno. ");
INSERT INTO cesnkb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","A nepřestávali každého dne v chrámu i po domech učit a kázat Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","V těch dnech, když se rozmnožoval počet učedníků, pak nastalo reptání helénistů proti Hebrejům, že jejich vdovy jsou při každodenní službě zanedbávány. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dvanáct apoštolů tedy svolalo shromáždění učedníků a řeklo: “Nesluší se, abychom my opustili Boží slovo a sloužili u stolů. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Proto ze sebe, bratři, vyberte sedm mužů dobré pověsti, plných Ducha Svatého a moudrosti, kterým svěříme tu práci. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","My se však budeme pilně věnovat modlitbě a službě slova.” ");
INSERT INTO cesnkb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ta řeč se tedy zalíbila celému shromáždění a vybrali Štěpána, muže plného víry a Ducha Svatého, a Filipa, Prochora, Nikanora, Timona, Parména a Mikuláše, proselytu z Antiochie. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ty postavili před apoštoly, kteří na ně po modlitbě vložili ruce. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A Boží slovo rostlo a počet učedníků v Jeruzalémě se mocně rozrůstal. Také veliké množství kněží poslouchalo víru. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Štěpán, plný víry a moci, pak dělal mezi lidem veliké divy a zázraky. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tehdy povstali někteří z takzvané Synagogy Libertinů (Kyrénských, Alexandrijských a těch z Kilikie a Asie) a hádali se se Štěpánem. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nemohli ale obstát proti moudrosti a Duchu, ve kterém mluvil. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Podstrčili tedy muže, kteří řekli: “Slyšeli jsme ho mluvit rouhavé řeči proti Mojžíši a proti Bohu!” ");
INSERT INTO cesnkb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","A tak rozbouřili lid i starší a zákoníky a přišli, chopili se ho a odvedli ho do velerady. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tam postavili falešné svědky, kteří řekli: “Tento člověk nepřestává mluvit rouhavé řeči proti tomuto místu a Zákonu. ");
INSERT INTO cesnkb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Slyšeli jsme ho totiž, jak říká, že ten Ježíš Nazaretský zničí toto místo a změní způsoby, které nám vydal Mojžíš!” ");
INSERT INTO cesnkb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A když se na něj všichni, kdo seděli ve veleradě, upřeně podívali, viděli jeho tvář jako tvář anděla. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tehdy nejvyšší kněz řekl: “Je to tak?” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A on řekl: “Bratři a otcové, slyšte: Bůh slávy se ukázal našemu otci Abrahamovi, když byl v Mezopotámii, předtím než se usadil v Cháranu, ");
INSERT INTO cesnkb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","a řekl mu: ‘Vyjdi ze své země a ze svého příbuzenstva a pojď do země, kterou ti ukážu.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tehdy vyšel ze země Chaldejců a usadil se v Cháranu. A když jeho otec zemřel, přestěhoval ho Bůh odtud do této země, ve které teď bydlíte. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","A nedal mu v ní dědictví ani jako šlápotu nohy, ale slíbil ji dát do vlastnictví jemu i jeho semeni po něm, když ještě neměl syna. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bůh tedy mluvil takto: ‘Tvoji potomci budou žít jako přistěhovalci v cizí zemi. Budou podrobeni do otroctví a bude se s nimi zle nakládat po čtyři sta let. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ale ten národ, kterému budouotročit, budu já soudit,’ řekl Bůh, ‘a potom vyjdou a budou mi sloužit na tomto místě.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","A vydal jim smlouvu obřízky. Abraham tedy zplodil Izáka a osmého dne ho obřezal, Izák potom Jákoba a Jákob dvanáct patriarchů.” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Patriarchové pak žárlili na Josefa a prodali ho do Egypta, ale Bůh byl s ním. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Vysvobodil ho ze všech jeho soužení a dal mu milost a moudrost před faraonem, egyptským králem, a ten ho ustanovil správcem nad Egyptem i nad celým svým domem. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Potom přišel na celou egyptskou i kananejskou zem hlad a veliké soužení a naši otcové nenalézali potravu. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Když pak Jákob uslyšel, že v Egyptě je obilí, poslal tam naše otce poprvé; ");
INSERT INTO cesnkb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","a podruhé se Josef dal svým bratrům poznat a tak byl farao seznámen s Josefovým rodem. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josef tedy poslal a zavolal k sobě svého otce Jákoba i celé své příbuzenstvo v počtu sedmdesáti pěti duší. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tak tedy Jákob sestoupil do Egypta a zemřel on i naši otcové. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Potom byli přeneseni do Sichemu a pochováni v hrobě, který Abraham koupil za cenu stříbra od Emorových synů v Sichemu.” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Jak se však přibližoval čas zaslíbení, o kterém Bůh přísahal Abrahamovi, lid v Egyptě rostl a množil se, ");
INSERT INTO cesnkb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","než povstal jiný král, který neznal Josefa. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ten nakládal s naším rodem lstivě a trápil naše otce, takže museli odkládat své novorozence, aby nezůstávali naživu. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","V tom čase se narodil Mojžíš a byl velice krásný. Ten byl chován tři měsíce v domě svého otce, ");
INSERT INTO cesnkb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","a když byl odložen, vzala si ho faraonova dcera a vychovala si ho jako syna. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mojžíš pak byl vyučen vší moudrosti Egypťanů a byl mocný ve slovech i skutcích. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","A když mu bylo čtyřicet let, přišlo mu na srdce, aby navštívil své bratry, syny Izraele. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A když uviděl jednoho, jak trpí bezpráví, zastal se ho, pomstil toho trápeného a Egypťana zabil. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Domníval se totiž, že jeho bratři porozumí, že jim Bůh skrze jeho ruku dává vysvobození, ale oni nerozuměli. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ukázal se jim tedy i druhého dne, když měli potyčku a snažil se je usmířit slovy: ‘Muži, jste bratři! Proč ubližujete jeden druhému?’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ten, který ubližoval bližnímu, ho však odstrčil se slovy: ‘Kdo tě nad námi ustanovil vůdcem a soudcem?’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Chceš mě snad zabít, jako jsi včera zabil toho Egypťana?’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mojžíš tedy kvůli tomu slovu utekl a bydlel jako přistěhovalec v midjánské zemi, kde zplodil dva syny. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Když se pak naplnilo čtyřicet let, ukázal se mu na poušti u hory Sinaj Pánův anděl v plameni hořícího keře. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Když to Mojžíš uviděl, podivil se tomu vidění. A když přistupoval, aby se lépe podíval, zazněl k němu Pánův hlas: ");
INSERT INTO cesnkb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Já jsem Bůh tvých otců, Bůh Abrahamův, Bůh Izákův a Bůh Jákobův.’ Mojžíš se tedy roztřásl a neodvažoval se podívat. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tehdy mu Pán řekl: ‘Zuj obuv ze svých nohou, protože místo na němž stojíš, je svatá půda. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Viděl jsem zřetelně trápení svého lidu, který je v Egyptě; uslyšel jsem jejich sténání a sestoupil jsem, abych je vysvobodil. Proto nyní pojď, pošlu tě do Egypta.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Toho Mojžíše, kterého zavrhli se slovy: ‘Kdo tě ustanovil vůdcem a soudcem?’, toho Bůh prostřednictvím anděla poslal jako vůdce a vysvoboditele, když se mu ukázal v keři. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ten je vyvedl a dělal divy a zázraky v egyptské zemi, na Rudém moři i na poušti po čtyřicet let.” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“To je ten Mojžíš, který řekl synům Izraele: ‘Pán, váš Bůh, vám vzbudí z vašich bratrů Proroka jako mne; toho budete poslouchat.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","To je ten, který ve shromáždění na poušti stál mezi andělem, jenž k němu mluvil na hoře Sinaj, a našimi otci. Ten přijal živá slova, aby je dal nám. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Toho naši otcové nechtěli poslouchat, ale odmítli ho. Ve svých srdcích se obrátili do Egypta ");
INSERT INTO cesnkb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","a řekli Áronovi: ‘Udělej nám bohy, kteří půjdou před námi, protože nevíme, co se stalo s tím Mojžíšem, který nás vyvedl z egyptské země.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","V těch dnech pak udělali tele a přinesli té modle oběť a veselili se z díla svých rukou. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bůh se tedy odvrátil a vydal je, aby sloužili nebeskému zástupu, jak je napsáno v knize Proroků: ‘Obětovali jste snad mně své oběti a dary čtyřicet let na poušti, dome Izraelský? ");
INSERT INTO cesnkb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Vztyčili jste stánek Molocha a hvězdu svého boha Remfana, obrazy, které jste si udělali, abyste se jim klaněli! Proto vás přestěhuji za Babylón.’” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Naši otcové měli na poušti stánek svědectví, jak nařídil Ten, který řekl Mojžíšovi, aby ho udělal podle vzoru, který viděl. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ten také naši otcové převzali a vnesli s Jozuem do panství pohanů, které Bůh vyhnal před tváří našich otců. Tak to bylo až do dnů Davida, ");
INSERT INTO cesnkb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","který v Božích očích nalezl milost a prosil, aby mohl najít stánek Bohu Jákobovu. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ale dům mu postavil až Šalomoun. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nejvyšší však nebydlí v chrámech udělaných rukama, jak říká prorok: ");
INSERT INTO cesnkb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Nebe je mi trůnem a země podnoží mých nohou. Jaký dům mi postavíte, praví Pán, a jaké bude místo mého spočinutí? ");
INSERT INTO cesnkb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Neučinila snad má ruka toto všechno?’” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Tvrdošíjní a neobřezaného srdce i uší, vy stále jen vzdorujete Duchu Svatému - jak vaši otcové, tak i vy! ");
INSERT INTO cesnkb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kterého z proroků vaši otcové nepronásledovali? A zabili ty, kteří předpověděli příchod Spravedlivého, jehož jste se vy teď stali zrádci a vrahy. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Vy jste přijali Zákon skrze působení andělů a nezachovali jste ho!” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","A když to slyšeli, zuřili ve svých srdcích a skřípali na něj zuby. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","On však, plný Ducha Svatého, upřel zrak do nebe, spatřil Boží slávu a Ježíše, stojícího po Boží pravici, ");
INSERT INTO cesnkb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","a řekl: “Hle, vidím otevřená nebesa a Syna člověka stojícího po Boží pravici!” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tehdy hlasitě vykřikli, zacpali si uši a jednomyslně se na něj vrhli. ");
INSERT INTO cesnkb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Potom ho vyhnali ven z města a kamenovali ho. Svědkové tehdy odložili své pláště u nohou mladíka jménem Saul ");
INSERT INTO cesnkb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","a kamenovali Štěpána, který vzýval Boha a říkal: “Pane Ježíši, přijmi mého ducha.” ");
INSERT INTO cesnkb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Potom klesl na kolena a hlasitě zvolal: “Pane, nepočítej jim tento hřích!” A když to řekl, zesnul. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A Saul jeho zabití schvaloval. V té době přišlo na církev v Jeruzalémě veliké pronásledování a všichni kromě apoštolů se rozprchli po judských a samařských krajích. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","A zbožní muži pochovali Štěpána a velice nad ním naříkali. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul však pustošil církev. Vcházel do domů, odvlékal muže i ženy a dával je do vězení. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ti, kteří se rozprchli, tedy šli a kázali Slovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip pak vešel do města Samaří a kázal tam Krista. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A zástupy jednomyslně poslouchaly to, co Filip říkal, protože slyšely a viděly zázraky, které dělal. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nečistí duchové totiž vycházeli s velikým křikem ze mnohých, kteří je měli, a mnozí ochrnutí a chromí byli uzdraveni. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","A v tom městě nastala veliká radost. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jeden muž jménem Šimon však v tom městě předtím provozoval magii a ohromoval samařský lid, neboť říkal, že je někým velikým. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Všichni, od nejmenšího až po největšího, ho poslouchali a říkali: “Tento je jistě ta veliká Boží moc!” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Poslouchali ho však proto, že je dlouhou dobu ohromoval svou magií. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Když pak uvěřili Filipovi kážícímu o Božím království a o jménu Ježíše Krista, dávali se muži i ženy pokřtít. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tehdy uvěřil i sám Šimon, a když byl pokřtěn, držel se Filipa. A když viděl, jak se dějí veliká znamení a zázraky, žasl. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Když pak apoštolové v Jeruzalémě uslyšeli, že Samaří přijalo Boží slovo, poslali k nim Petra a Jana. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ti přišli a modlili se za ně, aby přijali Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","(Na nikoho z nich totiž ještě nesestoupil, ale byli pouze pokřtěni ve jméno Pána Ježíše.) ");
INSERT INTO cesnkb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tehdy na ně vkládali ruce a oni přijímali Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","A když Šimon spatřil, že se Duch Svatý dává skrze vkládání rukou apoštolů, přinesl jim peníze ");
INSERT INTO cesnkb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","se slovy: “Dejte i mě tu moc, aby každý, na koho vložím ruce, přijal Ducha Svatého!” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petr mu však řekl: “Tvé peníze ať jdou s tebou do záhuby, protože ses domníval, že Boží dar lze získat za peníze! ");
INSERT INTO cesnkb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nemáš podíl ani účast na této věci, protože tvé srdce není před Bohem upřímné. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Proto čiň pokání z této své špatnosti a pros Boha - snad ti ten úmysl tvého srdce bude odpuštěn. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Vidím tě totiž ve žluči hořkosti a v poutu nepravosti.” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Šimon tedy odpověděl: “Vy se za mě modlete k Pánu, aby na mě nepřišlo nic z toho, co jste říkali!” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Když tedy vydali svědectví a domluvili Pánovo slovo, vraceli se do Jeruzaléma a v mnoha samařských vesnicích kázali evangelium. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Potom mluvil Pánův anděl k Filipovi: “Vstaň a jdi k jihu na cestu, která vede z Jeruzaléma dolů do Gázy. Je to pustina.” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Vstal tedy a šel. A hle, muž z Etiopie, mocný komorník Kandaké, etiopské královny, který spravoval všechny její poklady a který se přijel do Jeruzaléma poklonit Bohu, ");
INSERT INTO cesnkb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","se právě vracel. Seděl na svém voze a četl proroka Izaiáše. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Duch tedy řekl Filipovi: “Jdi blíž a připoj se k tomu vozu.” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","A když Filip přiběhl, uslyšel ho, jak čte proroka Izaiáše, a řekl: “Rozumíš snad tomu, co čteš?” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A on řekl: “Jak bych mohl? Jedině, kdyby mě někdo vedl.” A prosil Filipa, aby nastoupil a posadil se k němu. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A to místo v Písmu, které četl, bylo: “Byl veden jako ovce na porážku a jako je beránek němý před tím, kdo ho stříhá, tak neotevřel svá ústa. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ve svém ponížení byl zbaven soudu a kdo vylíčí jeho rod? Vždyť jeho život je vzat ze země.” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Komorník tedy řekl Filipovi: “Prosím tě, o kom to prorok mluví? O sobě nebo o někom jiném?” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip tedy otevřel ústa a počínaje tímto místem Písma mu začal kázat Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","A jak jeli, přijeli cestou k jakési vodě a ten komorník řekl: “Pohleď, voda. Co mi brání, abych byl pokřtěn?” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip tedy řekl: “Jestliže věříš z celého srdce, je to možné.” A on odpověděl: “Věřím, že Ježíš Kristus je Boží Syn!” ");
INSERT INTO cesnkb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Poručil, aby vůz zastavil, a oba sestoupili do té vody, Filip i komorník, a pokřtil ho. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Když pak vystoupili z vody, Pánův Duch uchvátil Filipa a komorník ho už nespatřil; jel tedy svou cestou a radoval se. ");
INSERT INTO cesnkb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip pak byl nalezen v Azotu. Procházel všechna města a kázal jim evangelium, až přišel do Cesareje. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul však ještě stále dychtil po výhrůžkách a po vraždění Pánových učedníků. Přišel k nejvyššímu knězi ");
INSERT INTO cesnkb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a vyžádal si od něho dopisy pro synagogy v Damašku, aby když tam najde nějaké muže nebo ženy té cesty, mohl je přivést svázané do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Když pak byl na cestě a přibližoval se k Damašku, stalo se, že ho náhle obklopilo světlo z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A když padl na zem, uslyšel hlas, jak mu říká: “Saule, Saule, proč mě pronásleduješ?” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Řekl tedy: “Kdo jsi, Pane?” A Pán řekl: “Já jsem Ježíš, kterého ty pronásleduješ. Je pro tebe těžké vzpírat se proti bodcům.” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Řekl tedy s rozechvěním a bázní: “Pane, co chceš, abych dělal?” A Pán mu odpověděl: “Vstaň, vejdi do města a tam ti bude řečeno, co máš dělat.” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A ti muži, kteří šli s ním, stáli oněmělí, protože slyšeli ten hlas, ale nikoho neviděli. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul pak vstal ze země a když otevřel oči, nic neviděl. Vzali ho tedy za ruce a dovedli do Damašku. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A tam byl tři dny bez zraku a nejedl ani nepil. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","V Damašku pak byl jeden učedník, jménem Ananiáš, a Pán mu ve vidění řekl: “Ananiáši!” A on řekl: “Zde jsem, Pane.” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pán mu řekl: “Vstaň, jdi do ulice, které se říká Přímá, a vyhledej v Judově domě Saula zvaného Tarský. Neboť hle, modlí se ");
INSERT INTO cesnkb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","a ve vidění viděl muže jménem Ananiáš, jak jde k němu a vkládá na něj ruku, aby prohlédl.” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiáš však odpověděl: “Pane, slyšel jsem o tom muži od mnoha lidí, kolik zlého napáchal tvým svatým v Jeruzalémě! ");
INSERT INTO cesnkb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A zde má od velekněží zmocnění, aby svázal všechny, kdo vzývají tvé jméno.” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ale Pán mu řekl: “Jdi, protože on je má vyvolená nádoba, aby přinášel mé jméno pohanům, králům i synům Izraele. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ukážu mu totiž, kolik musí vytrpět pro mé jméno.” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiáš tedy odešel, a když vešel do toho domu, vložil na něj ruce a řekl: “Saule, bratře, Pán Ježíš, který se ti ukázal na cestě, po níž jsi šel, mě poslal, abys prohlédl a byl naplněn Duchem Svatým.” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","A hned jako by mu z očí spadly šupiny a náhle prohlédl. Potom vstal a byl pokřtěn, ");
INSERT INTO cesnkb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","a když přijal pokrm, posilnil se. Saul pak zůstal s učedníky, kteří byli v Damašku, několik dní. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A hned v synagogách kázal, že Ježíš Kristus je Boží Syn. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Všichni, kteří ho slyšeli, tedy žasli a říkali: “Copak toto není ten, který v Jeruzalémě vyhlazoval ty, kdo vzývali toto jméno a sem přišel proto, aby je odvedl svázané k velekněžím?” ");
INSERT INTO cesnkb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saul však stále více rostl v síle a pobuřoval Židy, kteří bydleli v Damašku, když dokazoval, že tento Ježíš je Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","A když uběhlo mnoho dní, rozhodli se Židé společně, že ho zabijí. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saul se však o jejich úkladech dozvěděl. Ve dne i v noci hlídali brány, aby ho mohli zabít, ");
INSERT INTO cesnkb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ale učedníci ho v noci vzali a spustili ho v koši přes hradbu. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Když tedy Saul přišel do Jeruzaléma, pokoušel se připojit k učedníkům, ale všichni se ho báli, protože nevěřili, že je učedník. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabáš se ho však ujal. Přivedl ho k apoštolům a vyprávěl jim, jak Saul uviděl na cestě Pána, a že s ním mluvil, a jak v Damašku směle mluvil v Ježíšově jménu. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A tak s nimi pobýval v Jeruzalémě ");
INSERT INTO cesnkb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","a směle mluvil ve jménu Pána Ježíše. Rozmlouval a hádal se s helénisty, a tak se ho pokoušeli zabít. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bratři se to však dozvěděli, odvedli ho do Cesareje a poslali ho do Tarsu. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A tak církve po celém Judsku, Galileji i Samaří měly klid a budovaly se; chodily v Pánově bázni a rozmnožovaly se potěšením Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","A když Petr procházel všechny církve, stalo se, že přišel také ke svatým, kteří bydleli v Lyddě. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tam nalezl jednoho člověka, jménem Eneáš, který byl ochrnutý a ležel na lůžku už osm let. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petr mu tedy řekl: “Eneáši, Ježíš Kristus tě uzdravuje. Vstaň a ustel si!” A tak hned vstal ");
INSERT INTO cesnkb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","a viděli ho všichni, kdo bydleli v Lyddě a Sáronu, a obrátili se k Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","V Joppe pak byla jedna učednice, jménem Tabita (což se v překladu řekne Dorkas), která byla plná dobrých skutků a dávání almužen. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A v těch dnech se stalo, že onemocněla a zemřela. Omyli ji tedy a položili do horní místnosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A protože Lydda je blízko Joppe, učedníci uslyšeli, že je tam Petr, a poslali k němu dva muže s prosbou, aby k nim neváhal přijít. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petr tedy vstal a šel s nimi. A když přišel, zavedli ho do horní místnosti a tam ho s pláčem obstoupily všechny vdovy a ukazovaly košile a pláště, které jim Dorkas dělala, dokud byla s nimi. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petr však poslal všechny ven, poklekl a modlil se. Potom se obrátil k tomu tělu a řekl: “Tabito, vstaň!” A ona otevřela oči, a když uviděla Petra, posadila se. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Podal jí tedy ruku a zvedl ji. Potom zavolal svaté a vdovy a ukázal jim ji živou. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A to se rozneslo po celém Joppe a mnozí uvěřili v Pána. ");
INSERT INTO cesnkb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Stalo se tedy, že Petr zůstal v Joppe po mnoho dní u nějakého Šimona koželuha. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","V Cesareji pak byl jeden muž jménem Kornélius, setník praporu zvaného Italský. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Byl zbožný a bohabojný s celým svým domem, dával mnoho almužen lidu a stále se modlil k Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ten asi okolo deváté denní hodiny uviděl zřetelně ve vidění Božího anděla, jak k němu přišel a řekl mu: “Kornélie!” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A když na něj upřeně pohlédl, ulekl se a řekl: “Co je, Pane?” A on mu řekl: “Tvé modlitby a almužny vystoupily, aby byly připomenuty před Bohem. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Proto nyní pošli muže do Joppe a nech zavolat Šimona, který má příjmení Petr. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ten je hostem u jistého Šimona koželuha, který má dům u moře. On ti poví, co máš dělat.” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Když pak ten anděl, který k němu mluvil, odešel, zavolal Kornélius dva své služebníky a jednoho zbožného vojáka z těch, kteří byli vždycky s ním, ");
INSERT INTO cesnkb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","a když jim všechno vyložil, poslal je do Joppe. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A druhého dne, když byli na cestě a blížili se k městu, vystoupil Petr okolo šesté hodiny na střechu, aby se modlil. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tehdy dostal hlad a chtěl pojíst. Ale zatímco mu připravovali jídlo, upadl do vytržení. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A spatřil otevřené nebe a jakousi nádobu, jak sestupuje k němu jako veliká plachta uvázaná za čtyři cípy a spouští se na zem. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","V ní byla veškerá čtyřnohá zvířata země i šelmy, plazi a nebeské ptactvo. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tehdy k němu zazněl hlas: “Vstaň, Petře, zabíjej a jez!” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petr však řekl: “Nikoli, Pane; nikdy jsem přece nejedl nic nečistého nebo poskvrněného.” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tehdy k němu hlas promluvil podruhé: “Co Bůh očistil, ty neměj za nečisté!” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","To se stalo třikrát a potom byla nádoba znovu vzata do nebe. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A když byl Petr sám o sobě bezradný, co by mohlo znamenat to vidění, které měl, hle, ti muži, které poslal Kornélius, se doptali na Šimonův dům a stáli přede dveřmi. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Zavolali a ptali se, zda je tu hostem Šimon zvaný Petr. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A když Petr přemýšlel o tom vidění, řekl mu Duch: “Hle, tři muži tě hledají. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Proto vstaň, sejdi dolů a jdi s nimi bez rozpaků, protože já jsem je poslal.” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petr tedy sešel k těm mužům, které k němu poslal Kornélius, a řekl: “Hle, já jsem ten, kterého hledáte. z jakého důvodu jste přišli?” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A oni řekli: “Setník Kornélius, spravedlivý a bohabojný muž, který má dobré svědectví od celého židovského národa, dostal pokyn od svatého anděla, aby tě nechal zavolat do svého domu a vyslechl tvá slova.” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pozval je tedy dovnitř a pohostil. A druhého dne Petr vstal a odešel s nimi a někteří bratři z Joppe šli s ním. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Druhého dne pak přišli do Cesareje. Kornélius je očekával a svolal své příbuzné a blízké přátele. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","A když Petr vcházel, stalo se, že mu Kornélius vyšel naproti a padl k jeho nohám a klaněl se mu. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petr ho však zvedl se slovy: “Vstaň, já sám jsem také člověk!” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A jak s ním rozmlouval, vešel dovnitř a nalezl mnoho shromážděných. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Řekl jim tedy: “Vy víte, že je nemístné, aby se Žid připojil nebo přiblížil k cizozemci, ale mně Bůh ukázal, abych žádného člověka nenazýval nečistým nebo poskvrněným. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Proto jsem také bez odmlouvání přišel, když jsem byl zavolán. Ptám se tedy: Z jakého důvodu jste pro mě poslali?” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A Kornélius řekl: “Před čtyřmi dny jsem se postil až do této hodiny a v devátou hodinu jsem se modlil ve svém domě. A hle, přede mnou se postavil muž v zářícím rouchu ");
INSERT INTO cesnkb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a řekl: ‘Kornélie, tvá modlitba byla vyslyšena a tvé almužny byly připomenuty před Bohem. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Proto pošli do Joppe a zavolej Šimona zvaného Petr. Ten je hostem v domě Šimona koželuha u moře. On přijde a bude k tobě mluvit.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Proto jsem k tobě hned poslal a ty jsi udělal dobře, že jsi přišel. Nyní jsme tedy my všichni přítomni před Boží tváří, abychom vyslechli vše, co ti Bůh přikázal.” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petr tedy otevřel ústa a řekl: “Opravdu shledávám, že Bůh nikomu nestraní, ");
INSERT INTO cesnkb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ale v každém národě je mu příjemný ten, kdo se ho bojí a koná spravedlnost. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Slovo, které Bůh poslal synům Izraele, když zvěstoval pokoj skrze Ježíše Krista, který je Pánem všeho: ");
INSERT INTO cesnkb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Vy víte, co se dělo po celém Judsku, počínaje od Galileje, po křtu, který kázal Jan ");
INSERT INTO cesnkb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","- jak Bůh pomazal Duchem Svatým a mocí Ježíše z Nazaretu, který chodil, konal dobro a uzdravoval všechny utlačované od ďábla, protože Bůh byl s ním. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","A my jsme svědkové všeho toho, co dělal v judské zemi a v Jeruzalémě. A toho pověsili na dřevo a zabili, ");
INSERT INTO cesnkb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ale Bůh ho třetího dne vzkřísil a způsobil, aby byl zjeven; ");
INSERT INTO cesnkb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ne všemu lidu, ale svědkům, které Bůh předem vyvolil - nám, kteří jsme s ním jedli a pili po jeho zmrtvýchvstání. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Přikázal nám, abychom kázali lidu a svědčili, že on je ten Bohem ustanovený Soudce živých i mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jemu vydávají svědectví všichni proroci, že skrze jeho jméno přijme odpuštění hříchů každý, kdo v něho věří.” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","A když ještě Petr mluvil ta slova, Duch Svatý sestoupil na všechny, kdo poslouchali Slovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Věřící z obřízky, kteří přišli s Petrem, tedy užasli, že dar Ducha Svatého je vylit i na pohany. ");
INSERT INTO cesnkb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Slyšeli je totiž, jak mluví jazyky a velebí Boha. Tehdy Petr odpověděl: ");
INSERT INTO cesnkb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Může snad někdo odepřít vodu těmto, kteří přijali Ducha Svatého jako my, aby nebyli pokřtěni?” ");
INSERT INTO cesnkb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A přikázal, ať jsou pokřtěni v Pánově jménu. Tehdy ho poprosili, aby s nimi několik dní zůstal. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apoštolové a bratři, kteří byli v Judsku, pak uslyšeli, že i pohané přijali Boží slovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","A když Petr přišel do Jeruzaléma, odporovali mu ti, kteří byli z obřízky: ");
INSERT INTO cesnkb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Vešel jsi k neobřezaným mužům a jedl jsi s nimi!” ");
INSERT INTO cesnkb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petr jim to tedy začal po pořádku vysvětlovat a řekl: ");
INSERT INTO cesnkb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Byl jsem ve městě Joppe a když jsem se modlil, spatřil jsem ve vytržení ducha vidění: jakousi nádobu, sestupující jako veliká plachta, spouštěná za čtyři cípy z nebe; a přišla až ke mně. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Když jsem do ní upřeně pohlédl, rozeznal jsem a spatřil čtvernohá zvířata země i šelmy a plazy a nebeské ptáky. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tehdy jsem uslyšel hlas, který mi říkal: ‘Vstaň, Petře, zabíjej a jez!’ ");
INSERT INTO cesnkb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Řekl jsem však: ‘Nikoli, Pane, vždyť do mých úst nikdy nevstoupilo nic nečistého nebo poskvrněného.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ten hlas mi však podruhé odpověděl z nebe: ‘Co Bůh očistil, ty neměj za nečisté!’ ");
INSERT INTO cesnkb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","To se stalo třikrát a potom bylo všechno znovu vytaženo do nebe. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","A hle, vtom stáli u domu, v němž jsem byl, tři muži, kteří ke mně byli posláni z Cesareje. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Duch mi tedy řekl, abych šel bez rozpaků s nimi. A šlo se mnou i těchto šest bratrů a vešli jsme do domu toho muže, ");
INSERT INTO cesnkb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","který nám vyprávěl, jak viděl ve svém domě anděla, který se před ním postavil a řekl mu: ‘Pošli muže do Joppe a nech pozvat Šimona, který má příjmení Petr. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","On ti bude mluvit slova, skrze která budeš spasen ty i celý tvůj dům.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Když jsem tedy začal mluvit, sestoupil na ně Duch Svatý právě tak, jako na nás na počátku. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tehdy jsem si vzpomněl na Pánovo slovo, jak říkal: ‘Jan zajisté křtil vodou, ale vy budete pokřtěni Duchem Svatým.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jestliže jim tedy Bůh dal stejný dar jako nám, když uvěřili v Pána Ježíše Krista, kdo jsem byl já, abych mohl zabránit Bohu?” ");
INSERT INTO cesnkb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Když to tedy uslyšeli, upokojili se a začali slavit Boha se slovy: “Tedy i pohanům dal Bůh pokání k životu!” ");
INSERT INTO cesnkb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ti, kdo se rozprchli následkem soužení, které nastalo kvůli Štěpánovi, tedy přišli až do Fénicie, na Kypr a do Antiochie a nemluvili Slovo nikomu kromě Židů. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Někteří z nich však byli muži z Kypru a Kyrény, kteří když přišli do Antiochie, mluvili k helénistům a kázali jim Pána Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pánova ruka byla s nimi a veliký počet jich uvěřil a obrátil se k Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Zpráva o tom se tedy donesla k sluchu církve, která byla v Jeruzalémě a vyslali Barnabáše, aby šel až do Antiochie. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Když tam tedy přišel a uviděl tu Boží milost, zaradoval se a všechny povzbuzoval, aby z předsevzetí srdce zůstávali v Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Byl to totiž dobrý muž plný Ducha Svatého a víry. A veliký zástup lidí se přidal k Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabáš tedy odešel do Tarsu vyhledat Saula, ");
INSERT INTO cesnkb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","a když ho nalezl, přivedl ho do Antiochie. A stalo se, že se po celý rok scházeli v tom sboru a učili veliký zástup, takže zde v Antiochii byli učedníci poprvé nazváni křesťany. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","V těch dnech pak přišli do Antiochie proroci z Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jeden z nich jménem Agabus povstal a oznamoval skrze Ducha, že po celém světě bude veliký hlad. (Ten také nastal za císaře Klaudia.) ");
INSERT INTO cesnkb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Učedníci tedy stanovili, že každý podle své možnosti pošle pomoc bratrům bydlícím v Judsku. ");
INSERT INTO cesnkb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","To také udělali a poslali to starším po Barnabášovi a Saulovi. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","V té době se král Herodes dal do toho, aby ubližoval některým z církve. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Popravil tedy Jakuba, Janova bratra, mečem, ");
INSERT INTO cesnkb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","a když viděl, že se to Židům líbilo, rozhodl se zatknout ještě i Petra. (A byly dny nekvašených chlebů.) ");
INSERT INTO cesnkb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A když ho zajal, dal ho do vězení a svěřil šestnácti vojákům, aby ho hlídali, protože ho chtěl po Veliké noci vyvést lidu. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petr byl tedy střežen ve vězení, avšak církev se za něj vroucně modlila k Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Noc předtím, než ho měl Herodes předvést, pak Petr spal mezi dvěma vojáky, spoután dvěma řetězy, a stráže přede dveřmi hlídaly vězení. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A hle, postavil se k němu Pánův anděl a v místnosti zazářilo světlo. Udeřil Petra do boku a vzbudil ho se slovy: “Rychle vstaň!” A řetězy mu spadly z rukou. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tehdy mu anděl řekl: “Opásej se a obuj si sandály.” A tak to udělal. Anděl mu řekl: “Oblékni si plášť a pojď za mnou.” ");
INSERT INTO cesnkb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Vyšel tedy a následoval ho; a nevěděl, že to, co se děje skrze anděla, je opravdové, ale domníval se, že má vidění. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Prošli první i druhou stráží, přišli k železné bráně, která vedla do města, a ta se jim sama od sebe otevřela. Když vyšli ven, přešli jednu ulici a anděl od něj ihned odešel. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tehdy Petr přišel k sobě a řekl: “Teď opravdu vím, že Pán poslal svého anděla a vytrhl mě z Herodovy ruky a ze všeho, co židovský lid očekával.” ");
INSERT INTO cesnkb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Když to tedy zvážil, přišel do domu Marie, matky Jana zvaného Marek, kam se jich mnoho sešlo a modlili se. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petr zatloukl na dveře brány a přišla otevřít služebná jménem Rodé. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Když poznala Petrův hlas, samou radostí neotevřela bránu, ale vběhla dovnitř a oznámila, že Petr stojí před branou. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A oni jí řekli: “Blázníš!” Ale ona tvrdila, že je to tak. Řekli tedy: “Je to jeho anděl.” ");
INSERT INTO cesnkb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petr však nepřestával tlouci. A když otevřeli, spatřili ho a užasli. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ale on jim pokynul rukou, aby mlčeli a vyprávěl jim, jak ho Pán vyvedl z vězení, a řekl: “Povězte to Jakubovi a bratrům.” Potom vyšel a odebral se na jiné místo. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Když pak přišel den, nastal mezi vojáky nemalý rozruch nad tím, co se stalo s Petrem. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","A když ho Herodes hledal a nenašel, vyslechl strážné a poručil je odvést. Potom se odebral z Judska do Cesareje a tam pobýval. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tehdy se Herodes velice hněval na Nýrské a Sidonské. Přišli tedy jednomyslně k němu a když přesvědčili Blasta, královského komorníka, žádali o smír, protože jejich kraj byl zásobován z královského území. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ve stanovený den se tedy Herodes oblečen do královského roucha posadil na soudnou stolici a pronesl k nim řeč. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A lid volal: “To je boží hlas, a ne lidský!” ");
INSERT INTO cesnkb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","A ihned ho ranil Pánův anděl, protože nevzdal slávu Bohu: byl rozežrán červy a vypustil duši. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A Boží slovo rostlo a rozmáhalo se. ");
INSERT INTO cesnkb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Když tedy Barnabáš a Saul vykonali tu službu, vrátili se z Jeruzaléma a vzali s sebou i Jana, který měl příjmení Marek. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","V církvi, která byla v Antiochii, pak byli někteří proroci a učitelé, jako Barnabáš, Šimon zvaný Černý, Lucius Kyrénský, Manahen, který byl vychován společně s tetrarchou Herodem, a Saul. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","A když konali službu Pánu a postili se, řekl Duch Svatý: “Oddělte mi Saula a Barnabáše pro dílo, k němuž jsem je povolal.” ");
INSERT INTO cesnkb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tehdy na ně po půstu a modlitbě vložili ruce a propustili je. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Oni tedy, vysláni Duchem Svatým, přišli do Seleukie a odtud odpluli na Kypr. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","A když dorazili do Salaminy, kázali Boží slovo v židovských synagogách; a měli s sebou i Jana jako pomocníka. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A když ten ostrov prošli až do Páfu, nalezli jakéhosi čaroděje, židovského falešného proroka jménem Barjezus. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ten byl u místodržitele Sergia Pavla, rozumného muže, který si zavolal Barnabáše a Saula, protože toužil slyšet Boží slovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ale Elymas, ten čaroděj (tak se totiž překládá jeho jméno), jim odporoval a snažil se odvrátit místodržitele od víry. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tehdy byl Saul, zvaný také Pavel, naplněn Duchem Svatým, upřeně na něj pohlédl ");
INSERT INTO cesnkb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a řekl: “ďáblův synu, plný vší lsti a vší ničemnosti, nepříteli veškeré spravedlnosti, copak nepřestaneš převracet Pánovy přímé cesty? ");
INSERT INTO cesnkb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","A hle, Pánova ruka je nyní na tobě a budeš slepý a neuvidíš slunce až do uloženého času!” A ihned na něj padla mlha a tma a on začal chodit kolem a hledat, kdo by ho vedl za ruku. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Když tedy místodržitel uviděl, co se stalo, uvěřil a žasl nad Pánovým učením. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Když pak Pavel a ti, kdo byli s ním, vypluli z Páfu, dorazili do Perge v Pamfylii. Jan však od nich odešel a vrátil se do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Oni tedy šli z Perge dál a přišli do Antiochie Pisidské. v sobotní den vešli do synagogy a posadili se. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","A když bylo po čtení Zákona a Proroků, poslali k nim představení synagogy se slovy: “Bratři, jestliže máte pro lid nějaké slovo povzbuzení, mluvte.” ");
INSERT INTO cesnkb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pavel tedy vstal, pokynul rukou a řekl: “Izraelité a vy, kdo se bojíte Boha, slyšte: ");
INSERT INTO cesnkb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Bůh tohoto lidu, Izraele, vyvolil naše otce a pozdvihl tento lid, když pobýval v egyptské zemi, a vyvedl je z ní svou vztaženou paží. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Po dobu čtyřiceti let snášel jejich způsoby na poušti, ");
INSERT INTO cesnkb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","a když vyhladil sedm národů v zemi Kanán, rozdělil jim jejich zem losem. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Potom jim asi po čtyři sta padesát let dával soudce až do proroka Samuele. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tehdy žádali o krále a Bůh jim dal Saula, syna Kísova, muže z pokolení Benjamínova, na čtyřicet let. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Potom ho odstranil a pozdvihl jim za krále Davida, kterému také vydal svědectví, když řekl: ‘Nalezl jsem Davida, syna Isajova, muže podle svého srdce, který naplní všechnu moji vůli.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Z jeho semene Bůh podle zaslíbení vzbudil Izraeli Spasitele - Ježíše, ");
INSERT INTO cesnkb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","před jehož příchodem kázal Jan všemu lidu Izraele křest pokání. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","A když Jan dokončoval svůj běh, říkal: ‘Já nejsem ten, za kterého mě pokládáte, avšak hle, přichází po mně. Jemu nejsem hoden ani rozvázat obuv na nohou.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bratři, synové rodu Abrahamova a kdokoliv se mezi vámi bojí Boha, vám bylo posláno toto slovo spasení. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Obyvatelé Jeruzaléma ani jejich vůdcové ho totiž nepoznali a odsoudili a tak naplnili hlasy Proroků, kteří se čtou každou sobotu. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","I když na něm nenašli žádnou smrtelnou vinu, žádali Piláta, aby byl usmrcen. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","A když naplnili všechno, co o něm bylo napsáno, sňali ho ze dřeva a položili do hrobu. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ale Bůh ho vzkřísil z mrtvých ");
INSERT INTO cesnkb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","a on se po mnoho dní ukazoval těm, kteří s ním přišli z Galileje do Jeruzaléma; ti jsou teď jeho svědky před lidem. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","A my vám kážeme dobrou zprávu: to zaslíbení, dané našim otcům. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Bůh je splnil nám, jejich synům, když vzkřísil Ježíše, jak je také napsáno ve druhém Žalmu: ‘Ty jsi můj Syn, já jsem tě dnes zplodil.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","A že ho vzkřísil z mrtvých, aby se už nikdy nevrátil k porušení, řekl takto: ‘Dám vám svatá a jistá požehnání Davidova.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Proto říká i jinde: ‘Svému Svatému nedáš spatřit porušení.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David zajisté, když posloužil Boží vůli ve svém pokolení, zesnul a byl připojen ke svým otcům a spatřil porušení. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ten, kterého Bůh vzkřísil, však porušení nespatřil. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Proto ať je vám známo, bratři, že skrze něj se vám prohlašuje odpuštění hříchů. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A od všeho, od čeho jste nemohli být ospravedlněni Mojžíšovým zákonem, je skrze něj ospravedlněn každý, kdo věří. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Dejte tedy pozor, aby na vás nepřišlo to, co je napsáno v Prorocích: ");
INSERT INTO cesnkb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Hleďte, pohrdavci, užasněte a rozplyňte se; neboť já dělám za vašich dnů dílo, dílo, jemuž neuvěříte, ani kdyby vám o něm někdo vypravoval.’” ");
INSERT INTO cesnkb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Když potom vycházeli z té židovské synagogy, prosili pohané, aby jim ta slova mluvili i příští sobotu. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","A když bylo shromáždění rozpuštěno, mnozí Židé a zbožní proselyté šli za Pavlem a Barnabášem, kteří k nim mluvili a přesvědčovali je, aby zůstávali v Boží milosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Následující sobotu se pak sešlo téměř celé město, aby slyšeli Boží slovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","A když Židé spatřili ty zástupy, byli naplněni závistí a s odporem a rouháním mluvili proti tomu, co říkal Pavel. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pavel a Barnabáš však směle řekli: “Vám mělo být Boží slovo mluveno nejdříve, ale poněvadž ho odmítáte a soudíte sami sebe za nehodné věčného života, hle, obracíme se k pohanům! ");
INSERT INTO cesnkb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tak nám to totiž přikázal Pán slovy: ‘Postavil jsem tě za světlo pohanům, abys byl spasením až do posledních končin země.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Když to tedy slyšeli pohané, radovali se a oslavovali Pánovo slovo a všichni, kdo byli předurčeni k věčnému životu, uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A Pánovo slovo se šířilo po celém tom kraji. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Židé však poštvali pobožné a ctihodné ženy i přední muže města, podnítili pronásledování proti Pavlovi a Barnabášovi a vyhnali je ze svého kraje. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Oni tedy na ně vyklepali prach ze svých nohou a přišli do Ikonia. ");
INSERT INTO cesnkb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Učedníci pak byli naplňováni radostí a Duchem Svatým. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A v Ikoniu se také stalo, že vešli do židovské synagogy a mluvili tak, že uvěřilo veliké množství Židů i Řeků. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ale ti Židé, kteří neuvěřili, rozezlili duše pohanů a poštvali je proti bratrům. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ti tam tedy strávili dlouhý čas a směle mluvili v Pánu, který vydával svědectví slovu své milosti a působil, aby se skrze jejich ruce děla znamení a zázraky. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Obyvatelstvo města se tedy rozdělilo; jedni byli s Židy, ale jiní s apoštoly. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Když se je však pohané i Židé se svými vůdci pokusili potupit a kamenovat, ");
INSERT INTO cesnkb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","dozvěděli se to a utekli do lykaonských měst Lystry a Derbe a jejich okolí. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","A tam kázali evangelium. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","V Lystře pak sedával jeden muž nemohoucí na nohy, který byl chromý od lůna své matky a nikdy nechodil. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ten poslouchal Pavla, jak mluví. A když na něj Pavel upřel pohled a viděl, že má víru na uzdravení, ");
INSERT INTO cesnkb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","řekl mocným hlasem: “Postav se zpříma na své nohy!” A on vyskočil a chodil. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Když tedy zástupy uviděly, co Pavel udělal, pozdvihly svůj hlas a říkaly lykaonsky: “Bohové sestoupili k nám v lidské podobě!” ");
INSERT INTO cesnkb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","A říkali Barnabášovi Zeus a Pavlovi Hermes, protože hlavně on mluvil. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kněz Diova chrámu, který byl před jejich městem, tedy přivedl k branám býky s věnci a chtěl se zástupy obětovat. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Když to však apoštolové Barnabáš a Pavel uslyšeli, roztrhli svá roucha, vběhli do zástupu a křičeli: ");
INSERT INTO cesnkb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Muži, co to děláte? I my jsme lidé stejné přirozenosti jako vy a kážeme vám evangelium, abyste se obrátili od těchto marností k živému Bohu, který stvořil nebe a zemi i moře a všechno, co je v nich. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ten v minulých pokoleních nechával všechny pohany, aby chodili po svých cestách, ");
INSERT INTO cesnkb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ačkoliv nenechal sám sebe bez svědectví, protože konal dobro, dával nám z nebe déšť a úrodné časy a nasycoval naše srdce pokrmem a potěšením.” ");
INSERT INTO cesnkb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","A těmi slovy sotva upokojili zástupy, aby jim neobětovaly. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A vtom přišli z Antiochie a Ikonia Židé, a když přesvědčili zástupy, ukamenovali Pavla. Potom ho vytáhli ven z města, protože se domnívali, že zemřel. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Když ho však obstoupili učedníci, vstal a vešel do města; a druhého dne odešel s Barnabášem do Derbe. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Když pak tomu městu kázali evangelium a získali mnoho učedníků, vrátili se do Lystry, Ikonia a Antiochie. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Posilovali duše učedníků a vyzývali je, aby zůstávali ve víře, a že musíme vejít do Božího království skrze mnohá soužení. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","A když jim v každé církvi vybrali starší, modlili se s postem a svěřili je Pánu, v něhož uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Potom prošli Pisidii a přišli do Pamfylie. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","A poté, co mluvili Slovo v Perge, odešli do Attalie ");
INSERT INTO cesnkb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","a odtud odpluli do Antiochie, odkud byli předtím svěřeni Boží milosti k dílu, které vykonali. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","A když tam přišli, shromáždili církev a vyprávěli, co všechno skrze ně Bůh učinil a že otevřel dveře víry pohanům. ");
INSERT INTO cesnkb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A strávili tam s učedníky delší dobu. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Potom přišli někteří z Judska a učili bratry: “Nenecháte-li se obřezat podle Mojžíšova způsobu, nemůžete být spaseni.” ");
INSERT INTO cesnkb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","A když s nimi měl Pavel a Barnabáš nemalý spor a hádku, rozhodli, aby Pavel, Barnabáš a někteří další z nich šli s touto otázkou za apoštoly a staršími do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Když tedy byli církví vypraveni na cestu, procházeli Fénicií a Samařím a vyprávěli o obrácení pohanů a působili všem bratrům velikou radost. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","A když přišli do Jeruzaléma, byli přijati církví, apoštoly a staršími a oznámili jim, co skrze ně Bůh udělal. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Povstali však někteří věřící ze sekty farizeů, a říkali, že pohané musí být obřezáváni a že se jim má přikázat, aby zachovávali Mojžíšův zákon. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apoštolové a starší se tedy sešli, aby tu věc zvážili. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","A když došlo k velkému dohadování, vstal Petr a řekl jim: “Bratři, vy víte, že mě Bůh mezi námi odedávna vyvolil, aby pohané slyšeli slovo evangelia z mých úst a uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","A Bůh, který zná srdce lidí, jim vydal svědectví, když jim dal Ducha Svatého tak jako nám. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","A neučinil žádný rozdíl mezi námi a jimi, když vírou očistil jejich srdce. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Proč tedy nyní pokoušíte Boha, když vkládáte na šíji učedníků jho, které nemohli unést ani naši otcové ani my? ");
INSERT INTO cesnkb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Věříme přece, že jsme spaseni milostí Pána Ježíše Krista tak jako oni.” ");
INSERT INTO cesnkb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Celé shromáždění tedy zmlklo a poslouchali Barnabáše a Pavla, kteří vyprávěli, jaká znamení a zázraky dělal Bůh skrze ně mezi pohany. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","A když umlkli, odpověděl Jakub: “Bratři, poslouchejte mě. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Šimon vyprávěl, jak Bůh poprvé pohlédl na pohany, aby z nich přijal lid svému jménu. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A s tím se shodují slova proroků, jak je napsáno: ");
INSERT INTO cesnkb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Potom se navrátím a znovu postavím stánek Davidův, který padl. Jeho trosky znovu postavím a pozdvihnu jej, ");
INSERT INTO cesnkb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","aby zbytek lidí hledal Pána, i všichni pohané, nad nimiž je vzýváno mé jméno, praví Pán, který činí všechny tyto věci.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Bohu jsou známé od věků všechny jeho skutky. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Proto soudím, abychom nedělali potíže těm, kteří se z pohanů obracejí k Bohu, ");
INSERT INTO cesnkb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ale abychom jim napsali, ať se zdržují od věcí poskvrněných modlami, od smilstva, od masa zardoušených zvířat a od krve. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mojžíš přece má od dávných věků kazatele v každém městě, poněvadž bývá čten každou sobotu v synagogách.” ");
INSERT INTO cesnkb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tehdy se apoštolům a starším s celou církví zdálo dobré, aby do Antiochie poslali s Pavlem a Barnabášem muže, které mezi sebou vybrali, totiž Judu zvaného Barsabáš a Sílu, přední muže mezi bratry. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Poslali po nich tento dopis: “Apoštolové, starší a bratři zdraví ty, kdo jsou v Antiochii, v Sýrii a v Kilikii, bratry z pohanů. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Poněvadž jsme slyšeli, že z nás vyšli někteří, kteří vás zneklidnili svými slovy a rozrušili vaše duše, když říkali, že se musíte obřezat a zachovávat Zákon (což jsme jim nepřikázali), ");
INSERT INTO cesnkb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","zdálo se nám, jednomyslně shromážděným, dobré, abychom k vám poslali vybrané muže spolu s našimi milovanými Barnabášem a Pavlem, ");
INSERT INTO cesnkb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","lidmi, kteří vydali své životy pro jméno našeho Pána Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Proto jsme poslali Judu a Sílu a oni vám ústně povědí totéž. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Duchu Svatému i nám se totiž zdálo dobré, nevkládat na vás žádné další břemeno kromě těchto nezbytných věcí: ");
INSERT INTO cesnkb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","abyste se zdržovali od toho, co bylo obětováno modlám, od krve, od masa zardoušených zvířat a od smilstva. Budete-li se chránit těchto věcí, uděláte dobře. Buďte zdrávi.” ");
INSERT INTO cesnkb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Když tedy byli propuštěni, přišli do Antiochie, shromáždili sbor a předali dopis. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","A když ho přečetli, radovali se bratři z toho povzbuzení. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda se Sílou (kteří byli také proroci) tedy mnoha slovy povzbuzovali a posilovali bratry. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","A když tam strávili nějaký čas, bratři je v pokoji propustili k apoštolům. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sílovi se však zdálo dobré tam zůstat. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pavel a Barnabáš zůstali v Antiochii také a učili a kázali s mnoha dalšími Pánovo slovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Po několika dnech pak Pavel řekl Barnabášovi: “Vraťme se nyní a navštivme své bratry ve všech městech, kde jsme kázali Pánovo slovo, a zjistěme, jak se mají. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabáš tedy chtěl, aby s sebou vzali i Jana zvaného Marek. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pavel ale nepovažoval za správné vzít s sebou toho, který od nich odešel z Pamfylie a nešel s nimi do díla. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","A vznikl mezi nimi tak ostrý spor, že se od sebe rozešli. Barnabáš tedy vzal s sebou Marka a odplul na Kypr, ");
INSERT INTO cesnkb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pavel si však vybral Sílu, a když ho bratři svěřili Boží milosti, odešel. ");
INSERT INTO cesnkb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Procházel Sýrii a Kilikii a posiloval církve. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tehdy přišel do Derbe a Lystry, a hle, byl tu jeden učedník jménem Timoteus, syn jedné věřící Židovky, ale otce měl Řeka. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jemu vydávali bratři, kteří byli v Lystře a Ikoniu, dobré svědectví. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Toho si Pavel přál vzít s sebou na cesty, a tak ho vzal a kvůli Židům, kteří byli v těch místech, ho obřezal. (Všichni totiž věděli, že jeho otec byl Řek.) ");
INSERT INTO cesnkb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","A jak procházeli městy, předávali jim k zachovávání ta ustanovení, která rozhodli apoštolové a starší v Jeruzalémě. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","A tak se církve upevňovaly ve víře a rozhojňovaly se v počtu každý den. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","A když prošli Frygii a galatskou zem, Duch Svatý jim zabránil mluvit Slovo v Asii. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Když přišli k Mysii, pokoušeli se jít do Bitynie, ale Duch je nenechal. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Minuli tedy Mysii a přišli do Troady. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pavlovi se pak v noci ukázalo vidění. Nějaký makedonský muž stál a prosil ho: “Přijď do Makedonie a pomoz nám!” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","A jakmile uviděl to vidění, ihned jsme usilovali o to, abychom šli do Makedonie, přesvědčeni, že nás Pán povolal, abychom jim kázali evangelium. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Když jsme tedy vypluli z Troady, vydali jsme se přímým směrem k Samothráké a příštího dne do Neapole. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","A odtud do Filip, což je přední město makedonského kraje a římská kolonie. V tomto městě jsme tedy zůstali několik dní. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","V sobotní den jsme vyšli ven za město k řece, kde bylo zvykem se modlit; a když jsme se posadili, mluvili jsme ke shromážděným ženám. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Naslouchala také jedna pobožná žena jménem Lydie, obchodnice s purpurem z města Thyatir, a Pán otevřel její srdce, aby věnovala pozornost tomu, co Pavel říkal. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A když byla pokřtěna ona i její dům, prosila nás: “Jestliže jste mě uznali za věrnou Pánu, vejděte do mého domu a pobuďte tu.” A tak nás přinutila. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Když jsme se pak šli modlit, stalo se, že se s námi setkala jedna služebná, která měla věšteckého ducha a přinášela svým pánům veliké zisky předpovídáním budoucnosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ta chodila za Pavlem a za námi a křičela: “Tito lidé jsou služebníci Nejvyššího Boha a ohlašují nám cestu spasení!” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A to dělala po mnoho dní. Když toho však Pavel už měl dost, obrátil se a řekl tomu duchu: “Přikazuji ti ve jménu Ježíše Krista, abys z ní vyšel!” A v tu chvíli z ní vyšel. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Když tedy její páni uviděli, že zmizela naděje jejich zisků, chopili se Pavla a Síly a táhli je na náměstí k představeným. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","A když je přivedli před městské úředníky, řekli: “Tito lidé bouří naše město! Jsou to Židé ");
INSERT INTO cesnkb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","a hlásají zvyky, které nemůžeme přijmout ani zachovávat, poněvadž jsme Římané!” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A tak proti nim povstal dav a úředníci jim strhali šaty a nařídili, ať jsou biti holemi. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","A když jim dali mnoho ran, uvrhli je do vězení a žalářníkovi přikázali, aby je bezpečně hlídal. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Když tedy dostal takový rozkaz, uvrhl je do nejhlubšího vězení a sevřel jim nohy kládou. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pavel a Síla se však o půlnoci modlili a zpívali chvály Bohu a vězňové jim naslouchali. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A náhle nastalo tak veliké zemětřesení, že se otřásly základy vězení a hned se otevřely všechny dveře a všem se uvolnila pouta. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Žalářník se probudil, a když uviděl dveře vězení otevřené, vytáhl meč a chtěl se zabít v domnění, že vězňové utekli. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pavel však hlasitě vykřikl: “Nedělej si nic zlého, vždyť jsme všichni zde!” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Požádal tedy o světlo, vběhl dovnitř a rozechvěn padl před Pavlem a Sílou. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Potom je vyvedl ven a řekl: “Páni, co mám dělat, abych byl spasen?” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Oni řekli: “Věř v Pána Ježíše Krista a budeš spasen ty i tvůj dům.” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","A mluvili Pánovo slovo jemu i všem, kdo byli v jeho domě. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","On je tedy v tu noční hodinu vzal a omyl jim rány. Potom byl ihned pokřtěn on i všichni jeho domácí. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A když je přivedl do svého domu, prostřel stůl a radoval se, že s celou rodinou uvěřil Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Když pak nastal den, poslali úředníci biřice se slovy: “Propusť ty lidi!” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Žalářník tedy oznámil ta slova Pavlovi: “Úředníci vzkázali, abyste byli propuštěni. Proto nyní odejděte a běžte v pokoji.” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pavel jim ale řekl: “Zmrskali nás veřejně a bez soudu vsadili do vězení - nás, kteří jsme Římané - a teď nás chtějí tajně vyhnat? To opravdu ne! Ať přijdou sami a vyvedou nás!” ");
INSERT INTO cesnkb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Biřicové tedy ta slova oznámili úředníkům. A když uslyšeli, že to jsou Římané, dostali strach, ");
INSERT INTO cesnkb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","přišli a prosili je za odpuštění. Potom je vyvedli a žádali je, aby odešli z města. ");
INSERT INTO cesnkb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Když tedy vyšli z vězení, přišli k Lydii, a když uviděli bratry, potěšili je a odešli. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","A když prošli Amfipolis a Apolonii, přišli do Tesaloniky, kde byla židovská synagoga. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pavel tedy podle svého zvyku vešel k nim a po tři soboty k nim promlouval z Písem. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Vysvětloval a předkládal jim, že Kristus musel trpět a vstát z mrtvých a že “toto je Kristus: Ježíš, kterého vám kážu!” ");
INSERT INTO cesnkb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Někteří z nich se dali přesvědčit a tak se k Pavlovi a Sílovi připojilo veliké množství pobožných Řeků i nemálo předních žen. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ale ti Židé, kteří neuvěřili, vzpláli žárlivostí. Přibrali si některé zlé lidi z ulice, a když se shlukli, vzbouřili město a zaútočili na Jásonův dům. Hledali je totiž, aby je vyvedli před lid. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Když je však nenašli, táhli Jásona a některé bratry k představeným města a křičeli: “Ti, kteří vzbouřili celý svět, přišli i sem - ");
INSERT INTO cesnkb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a Jáson je přijal! Ti všichni jednají proti císařským ustanovením, protože nazývají králem někoho jiného, totiž Ježíše!” ");
INSERT INTO cesnkb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","A tak rozrušili zástup i představené města, kteří to slyšeli. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Když však dostali od Jásona a ostatních záruku, propustili je. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bratři tedy hned v noci vyslali Pavla i Sílu do Berie. A když tam dorazili, šli do židovské synagogy. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tito Židé však byli ušlechtilejší než tesaloničtí. Přijali Slovo se vší dychtivostí a každý den zkoumali Písma, zda jsou ty věci tak. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mnozí z nich tedy uvěřili, a také nemálo ctihodných řeckých žen a mužů. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Když se však Židé z Tesaloniky dozvěděli, že Pavel káže Boží slovo i v Berii, přišli také tam a rozbouřili zástupy. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tehdy bratři ihned poslali Pavla, aby šel k moři, ale Síla a Timoteus tam zůstali. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A ti, kdo Pavla doprovázeli, ho dovedli až do Athén. A když dostali vzkaz pro Sílu a Timotea, aby co nejrychleji přišli k němu, odešli. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Když pak na ně Pavel čekal v Athénách, rozněcoval se v něm jeho duch, když viděl, jak je to město oddané modlám. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Rozmlouval tedy každý den s Židy a pobožnými lidmi v synagoze i s těmi, které potkal na tržišti. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Setkávali se s ním také někteří epikurejští a stoičtí filozofové a někteří z nich říkali: “Co nám chce ten žvanil povídat?” A jiní: “Zdá se být zvěstovatelem cizích božstev.” Kázal jim totiž Ježíše a vzkříšení z mrtvých. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Popadli ho tedy a vyvedli na Areopág se slovy: “Můžeme se dozvědět, co je to za nové učení, které hlásáš? ");
INSERT INTO cesnkb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Přinášíš totiž našim uším nějaké podivné věci. Chceme tedy vědět, co to má být.” ");
INSERT INTO cesnkb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Všichni Athéňané i cizinci, kteří tam pobývali, totiž netrávili čas ničím jiným, než aby říkali nebo poslouchali něco nového. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pavel se tedy postavil uprostřed Areopágu a řekl: “Muži athénští, vidím, že jste v každém ohledu velice nábožní lidé. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Když jsem tu totiž procházel a pozoroval, co uctíváte, našel jsem také oltář, na kterém je napsáno: ‘Neznámému bohu’. Koho tedy uctíváte nevědomě, toho vám já zvěstuji. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Bůh, který stvořil svět i všechno, co je v něm, ten, který je Pánem nebe i země, nebydlí v chrámech udělaných rukama. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ani si nedává sloužit lidskýma rukama, jako by něco potřeboval, protože on dává všem život i dech i všechno. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","A učinil z jedné krve celý lidský rod, aby přebývali na celém povrchu země; vyměřil jim uložené časy a hranice jejich přebývání, ");
INSERT INTO cesnkb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","aby hledali Pána, zda by se ho snad mohli dotknout a nalézt ho, ačkoli není daleko od žádného z nás. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jím totiž žijeme, hýbeme se a trváme, jak to řekli i někteří z vašich básníků: ‘Vždyť jsme jeho potomstvo.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Když tedy jsme Boží potomstvo, nesmíme se domnívat, že by božská bytost byla podobná zlatu, stříbru nebo kameni, výtvoru lidské zručností a důvtipu. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bůh ale přehlédl časy této nevědomosti a nyní přikazuje lidem, aby všichni všude činili pokání, ");
INSERT INTO cesnkb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","protože určil den, v němž bude spravedlivě soudit svět skrze muže, kterého k tomu ustanovil, o čemž podal každému důkaz, když ho vzkřísil z mrtvých.” ");
INSERT INTO cesnkb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","A když uslyšeli o vzkříšení z mrtvých, někteří se posmívali, ale jiní řekli: “Poslechneme si o tom od tebe ještě jindy.” ");
INSERT INTO cesnkb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tak Pavel vyšel z jejich středu. ");
INSERT INTO cesnkb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Někteří muži se však k němu připojili a uvěřili; mezi nimi i Dionýsius Areopágský, žena jménem Damaris a s nimi ještě jiní. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Potom Pavel odešel z Athén a přišel do Korintu. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A tam nalezl jednoho Žida jménem Akvilu, rodem z Pontu, který nedávno přišel se svou manželkou Priscillou z Itálie (protože Klaudius nařídil, aby všichni Židé odešli z Říma), a přidal se k nim. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","A protože byl stejného řemesla, bydlel a pracoval u nich, neboť jejich řemeslem bylo dělat stany. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Každou sobotu však promlouval v synagoze a přesvědčoval Židy i Řeky. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","A když Síla a Timoteus přišli z Makedonie, Pavel byl puzen v duchu a dosvědčoval Židům, že Ježíš je Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Když mu však odporovali a rouhali se, vytřásl svůj plášť a řekl jim: “Vaše krev na vaši hlavu, já jsem od ní čistý! Od této chvíle půjdu k pohanům.” ");
INSERT INTO cesnkb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A když odtud odešel, vstoupil do domu jistého muže jménem Justus, Božího ctitele, jehož dům sousedil se synagogou. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Také Kristus, představený synagogy, uvěřil Pánu s celým svým domem a mnozí z Korintských, kteří naslouchali, uvěřili a dali se pokřtít. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pán tedy řekl v noci Pavlovi skrze vidění: “Neboj se, ale mluv a nemlč; ");
INSERT INTO cesnkb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","protože já jsem s tebou a nikdo se tě nedotkne, aby ti ublížil; neboť mám mnoho lidu v tomto městě.” ");
INSERT INTO cesnkb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","A tak tu zůstal půl druhého roku a vyučoval mezi nimi Boží slovo. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Když však byl Gallio místodržitelem Acháje, povstali Židé jednomyslně proti Pavlovi a přivedli ho před soudnou stolici ");
INSERT INTO cesnkb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","se slovy: “Tento muž navádí lidi, aby ctili Boha v rozporu se Zákonem!” ");
INSERT INTO cesnkb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","A když měl Pavel otevřít ústa, řekl Gallio Židům: “Židé, kdyby se stala nějaká nepravost nebo bídný zločin, měl bych důvod vás vyslechnout. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ale když jsou to otázky o slovech a jménech a o vašem Zákoně, postarejte se o to sami, protože já tyto věci soudit nechci!” ");
INSERT INTO cesnkb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","A odehnal je od soudné stolice. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Všichni Řekové se tedy chopili Rostena, představeného synagogy, a bili ho před soudnou stolicí, ale Gallio na to vůbec nedbal. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pavel tam však zůstal ještě mnoho dní. Když se potom rozloučil s bratry, odplul do Sýrie a s ním Priscilla i Akvila. V Kenchrejích si dal ostříhat hlavu, protože složil slib, ");
INSERT INTO cesnkb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","a když dorazil do Efezu, nechal je tam; sám však vešel do synagogy a rozmlouval se Židy. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","A když ho prosili, aby u nich zůstal déle, nesvolil, ");
INSERT INTO cesnkb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ale rozloučil se s nimi a řekl: “Já musím nutně strávit tento nadcházející svátek v Jeruzalémě, ale bude-li Bůh chtít, znovu se k vám vrátím.” Tehdy odplul z Efezu. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","A když dorazil do Cesareje, vystoupil, pozdravil církev a odešel do Antiochie. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A když tam pobyl nějaký čas, odešel a postupně procházel galatský kraj i Frygii a posiloval všechny učedníky. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Do Efezu pak přišel jeden Žid jménem Apollo, výmluvný muž mocný v Písmech, rodem z Alexandrie. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ten byl vyučen Pánově cestě, a jelikož byl vroucího ducha, mluvil a přesně vyučoval o Pánu, ačkoliv znal jenom Janův křest. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ten začal směle mluvit v synagoze, a když ho uslyšeli Priscilla s Akvilou, vzali ho k sobě a vysvětlili mu Boží cestu ještě přesněji. ");
INSERT INTO cesnkb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Když potom chtěl jít do Acháje, bratři ho povzbudili a napsali učedníkům, aby ho přijali. A když tam přišel, velmi pomohl těm, kteří skrze Boží milost uvěřili, ");
INSERT INTO cesnkb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","protože mocně překonával Židy, když veřejně dokazoval z Písem, že Ježíš je Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","A když byl Apollos v Korintu, stalo se, že Pavel prošel horními kraji a přišel do Efezu. A když tam nalezl některé učedníky, ");
INSERT INTO cesnkb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","řekl jim: “Přijali jste Ducha Svatého, když jste uvěřili?” Ale oni mu řekli: “Nikdy jsme ani neslyšeli, že je Duch Svatý.” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Řekl jim: “Jak jste tedy pokřtěni?” A oni řekli: “Janovým křtem.” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pavel tedy řekl: “Jistě, Jan křtil křtem pokání a říkal lidem, aby uvěřili v toho, který měl přijít po něm, to jest v Krista Ježíše.” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Když to tedy uslyšeli, byli pokřtěni ve jméno Pána Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","A když na ně Pavel vložil ruce, přišel na ně Duch Svatý a oni mluvili jazyky a prorokovali. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","A bylo jich celkem okolo dvanácti mužů. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pavel pak vešel do synagogy a směle tam mluvil po tři měsíce; rozmlouval s lidmi a přesvědčoval je o Božím království. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","A když se někteří zatvrzovali, byli nepovolní a přede všemi zlořečili té cestě, Pavel od nich odstoupil, oddělil učedníky a každý den promlouval ve škole jistého Tyranna. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","A to se dělo po dva roky, takže všichni obyvatelé Asie, jak Židé, tak Řekové, slyšeli slovo Pána Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bůh pak dělal skrze Pavlovy ruce mimořádné zázraky, ");
INSERT INTO cesnkb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","takže lidé dokonce přinášeli šátky a zástěry z jeho těla na nemocné a nemoci od nich odstupovaly a zlí duchové z nich vycházeli. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Někteří z potulných židovských zaklínačů se pak pokusili vzývat jméno Pána Ježíše nad těmi, kdo měli zlé duchy. Říkali: “Zaklínáme vás Ježíšem, kterého káže Pavel!” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","A to dělalo sedm synů židovského velekněze Skévy. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Zlý duch jim však odpověděl: “Ježíše znám a o Pavlovi vím, ale kdo jste vy?” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ten člověk, ve kterém byl zlý duch, se tedy na ně vrhl, přemohl je a zmocnil se jich, takže utekli z toho domu nazí a zranění. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","A to vešlo ve známost mezi všemi Židy i Řeky bydlícími v Efezu. Na všechny padla bázeň a jméno Pána Ježíše bylo velebeno. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mnozí z těch, kteří uvěřili, tedy přicházeli a vyznávali a odhalovali své skutky. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Také mnozí z těch, kteří se zabývali magií, snesli své knihy a přede všemi je pálili. A když spočítali jejich cenu, shledali, že stály padesát tisíc stříbrných. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tak mocně rostlo Pánovo slovo a rozmáhalo se. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","A když se staly tyto věci, rozhodl se Pavel v duchu, že projde Makedonii a Acháji a půjde do Jeruzaléma. Řekl: “Až tam pobudu, musím také vidět Řím.” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dva z těch, kteří mu pomáhali, Timotea a Erasta, tedy poslal do Makedonie, ale sám zůstal ještě načas v Asii. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tehdy nastal kvůli té cestě nemalý rozruch. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Jeden stříbrotepec jménem Demetrius, který dělal stříbrné napodobeniny Artemidina chrámu, totiž poskytoval nemalý výdělek řemeslníkům. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ty svolal spolu s těmi, kteří dělali podobné věci, a řekl: “Muži, víte, že z tohoto řemesla je naše bohatství. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","A vidíte i slyšíte, že nejen v Efezu, ale téměř po celé Asii ten Pavel přesvědčil a odvrátil veliké množství lidí, protože říká: ‘Ti, kteří jsou udělaní rukama, nejsou bohové!’ ");
INSERT INTO cesnkb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hrozí tedy nejen, že nastane krach našeho řemesla, ale také, že chrám veliké bohyně Artemis nebude považován za nic a bude poškozena důstojnost té, kterou ctí celá Asie i celý svět!” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","A když to uslyšeli, byli naplněni hněvem a začali křičet: “Veliká je efezská Artemis!” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Celé město se tedy naplnilo rozruchem a když chytili Makedonce Gaia a Aristarcha, Pavlovy společníky na cestách, hnali se všichni společně do divadla. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","(Když však chtěl Pavel jít mezi lid, učedníci ho nenechali. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Dokonce i někteří z předních mužů Asie, kteří byli jeho přáteli, k němu poslali s prosbou, aby se nevydával do divadla.) ");
INSERT INTO cesnkb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A jedni křičeli to, druzí ono, protože shromáždění bylo zmatené a mnozí ani nevěděli, proč se sešli. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Potom ze zástupu vytáhli Alexandra, kterého Židé postrčili dopředu. Alexandr tedy pokynul rukou a chtěl před lidem pronést obhajobu. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Když ale poznali, že je to Žid, vydali všichni jeden hlas a křičeli asi dvě hodiny: “Veliká je efezská Artemis!” ");
INSERT INTO cesnkb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","A když městský sekretář upokojil zástup, řekl: “Muži efezští, kdo z lidí by nevěděl, že město Efezských je strážcem chrámu veliké bohyně Artemis a její sochy, která spadla z nebe? ");
INSERT INTO cesnkb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","A poněvadž jsou tyto věci nepopiratelné, je třeba, abyste zachovali klid a nedělali nic ukvapeného. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Přivedli jste totiž tyto muže, kteří ani nespáchali svatokrádež, ani se nerouhají vaší bohyni. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jestliže má tedy Demetrius a řemeslníci, kteří jsou s ním, proti někomu žalobu, konají se veřejné soudy a jsou tu místodržitelé. Tam ať jedni druhé žalují. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A pokud žádáte ještě něco jiného, bude to vyřešeno v zákonném shromáždění. ");
INSERT INTO cesnkb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","41","Hrozí nám totiž, že budeme kvůli dnešku obviněni ze vzpoury, a není žádný důvod, který bychom mohli udat, proč jsme se tu srotili.” A když to řekl, rozpustil shromáždění. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Když pak to pozdvižení skončilo, svolal Pavel učedníky, rozloučil se s nimi a vydal se na cestu do Makedonie. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A když prošel ty kraje a povzbudil je mnohými slovy, přišel do Řecka ");
INSERT INTO cesnkb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","a pobyl tam tři měsíce. Poněvadž mu však Židé činili úklady, když měl vyplout do Sýrie, rozhodl se, že se vrátí přes Makedonii. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Až do Asie ho tedy doprovázel Sopater z Berie, z Tesalonických pak Aristarchos a Sekundus, Gaius z Derbe, také Timoteus, a z Asie Tychikus a Trofimus. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ti šli napřed a čekali na nás v Troadě. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","My jsme pak po dnech nekvašených chlebů vypluli z Filip a během pěti dnů jsme dorazili k nim do Troady, kde jsme strávili sedm dní. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A když se učedníci prvního dne po sobotě sešli k lámání chleba, Pavel k nim mluvil, protože měl nazítří jít pryč, a protáhl svou řeč až do půlnoci. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","V horní místnosti, kde byli shromážděni, bylo hodně svítilen, ");
INSERT INTO cesnkb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","avšak jednoho mladíka jménem Eutychus, sedícího na okně, přemáhal hluboký spánek. A když Pavel mluvil ještě déle, byl spánkem přemožen a spadl z třetího poschodí dolů a zvedli ho mrtvého. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pavel tedy sestoupil dolů, padl na něj, objal ho a řekl: “Neznepokojujte se, vždyť jeho duše je v něm!” ");
INSERT INTO cesnkb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pak vystoupil nahoru, lámal chléb, pojedl a ještě dlouho hovořil, až do rána, a tak odešel. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A toho chlapce přivedli živého a byli velice povzbuzeni. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","My jsme tedy šli napřed na loď a vypluli jsme k Assu, kde jsme k sobě měli vzít Pavla; tak to totiž nařídil, protože chtěl jít sám pěšky. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","A když se s námi v Assu setkal, vyzvedli jsme ho a přijeli jsme do Mitylény. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Potom jsme odtud odpluli a druhého dne jsme se dostali naproti ostrovu Chios. Následující den jsme připluli k Sámu a zůstali jsme v Trogylliu. Nazítří jsme pak dorazili do Milétu. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","(Pavel se totiž rozhodl minout Efez, aby se nezdržel v Asii, protože spěchal, aby se pokud možno dostal na den Letnic do Jeruzaléma.) ");
INSERT INTO cesnkb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Z Milétu tedy poslal zprávu do Efezu a zavolal k sobě starší církve. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Když k němu přišli, řekl jim: “Vy víte, jak jsem byl s vámi po všechen ten čas od prvního dne, kdy jsem přišel do Asie: ");
INSERT INTO cesnkb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Jak jsem sloužil Pánu se vší pokorou a s mnoha slzami a zkouškami, které na mě přicházely skrze úklady Židů; ");
INSERT INTO cesnkb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","jak jsem neopomněl nic užitečného, abych vám to neoznámil a neučil vás veřejně i po domech; ");
INSERT INTO cesnkb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","jak jsem Židům i Řekům vydával svědectví o pokání k Bohu a o víře v našeho Pána, Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","A hle, já nyní jdu, puzen Duchem, do Jeruzaléma a nevím, co se mi v něm má stát, ");
INSERT INTO cesnkb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","mimo to, že mi Duch Svatý v každém městě vydává svědectví, že mě čekají pouta a soužení. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ale já na to nic nedbám, ani si necením své duše víc, než abych s radostí dokončil svůj běh a službu, kterou jsem přijal od Pána Ježíše: abych vydával svědectví evangeliu Boží milosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","A hle, já nyní vím, že vy všichni, mezi kterými jsem chodil a kázal o Božím království, již nikdy nespatříte mou tvář. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Proto vám dnešní den vydávám svědectví, že jsem čistý od krve všech lidí, ");
INSERT INTO cesnkb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","protože jsem neopomněl oznámit vám veškerou Boží vůli. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Dbejte tedy na sebe i na celé stádo, nad nímž vás Duch Svatý ustanovil biskupy, abyste pásli Boží církev, kterou získal svou vlastní krví. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Já totiž vím, že po mém odchodu mezi vás vstoupí draví vlci, kteří nebudou šetřit stádo. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","I z vás samotných povstanou muži, kteří budou mluvit převrácené věci, aby strhli učedníky za sebou. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Proto bděte a pamatujte, že jsem po tři roky nepřestával dnem i nocí se slzami napomínat jednoho každého z vás. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","A nyní vás, bratři, svěřuji Bohu a slovu jeho milosti, které má moc vás vybudovat a dát vám dědictví mezi všemi posvěcenými. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Od nikoho jsem nechtěl stříbro, zlato ani roucho. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Však sami víte, že to, co jsem potřeboval já i ti, kdo byli se mnou, obstarávaly tyto ruce. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ve všem jsem vám ukázal, že máme takto pracovat, podporovat slabé a pamatovat na slova Pána Ježíše, protože on řekl: ‘Požehnanější je dávat, než dostávat.’” ");
INSERT INTO cesnkb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","A když to řekl, poklekl s nimi všemi a modlil se. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","A všichni se dali do velikého pláče, padali Pavlovi kolem krku a líbali ho. ");
INSERT INTO cesnkb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nejvíce se rmoutili nad těmi slovy, která řekl - že už nikdy nespatří jeho tvář. A tak ho doprovázeli k lodi. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jakmile jsme se tedy s nimi rozloučili, vypluli jsme a přímým směrem jsme přijeli na ostrov Kós a druhý den na Rodos a odtud do Patary. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tam jsme našli loď, která plula do Fénicie, nastoupili jsme na ni a vypluli. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Když se nám pak začal ukazovat Kypr, nechali jsme ho po levé straně. Pluli jsme do Sýrie a přistáli v Týru, protože tam měla loď vyložit náklad. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","A když jsme nalezli učedníky, zůstali jsme tam sedm dní. Ti říkali Pavlovi skrze Ducha, aby nechodil do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Po naplnění těch dnů jsme se vydali na cestu a všichni nás vyprovázeli i s ženami a dětmi až za město, kde jsme na břehu poklekli a modlili se. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","A když jsme se spolu rozloučili, nastoupili jsme na loď a oni se vrátili domů. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","My jsme se pak z Týru vydali na další plavbu a dorazili jsme do Ptolemaidy. Pozdravili jsme bratry a zůstali jsme u nich jeden den. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nazítří jsme my, kdo jsme byli s Pavlem, odešli a přišli jsme do Cesareje. Vešli jsme do domu evangelisty Filipa (který byl z oněch sedmi) a zůstali jsme u něho. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ten měl čtyři dcery, panny, které prorokovaly. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","A když jsme tam pobývali již mnoho dní, přišel z Judska jeden prorok jménem Agabus. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Když k nám přišel, vzal Pavlův pás, svázal si ruce i nohy a řekl: “Toto říká Duch Svatý: Toho muže, kterému patří tento pás, takto svážou Židé v Jeruzalémě a vydají ho do rukou pohanů.” ");
INSERT INTO cesnkb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","A jakmile jsme to uslyšeli, prosili jsme ho my i ti, kdo byli z toho místa, aby nechodil do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pavel však odpověděl: “Co děláte? Proč pláčete a trápíte mé srdce? Vždyť já jsem připraven nejenom být svázán, ale také v Jeruzalémě umřít pro jméno Pána Ježíše!” ");
INSERT INTO cesnkb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Když se tedy nechtěl dát přesvědčit, přestali jsme se slovy: “Ať se stane Pánova vůle.” ");
INSERT INTO cesnkb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Po těch dnech jsme se tedy připravili a vydali se vzhůru do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Šli s námi i učedníci z Cesareje a vedli nás k jistému Mnázonovi z Kypru, dávnému učedníkovi, u kterého jsme měli být hosty. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","A když jsme přišli do Jeruzaléma, bratři nás radostně přijali. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Druhého dne tedy šel Pavel s námi k Jakubovi a tam se sešli všichni starší. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","A když je pozdravil, vyprávěl jim jedno po druhém všechno, co Bůh skrze jeho službu udělal mezi pohany. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Když to tedy uslyšeli, oslavovali Pána. Potom mu řekli: “Vidíš bratře, kolik desítek tisíc je Židů, kteří uvěřili, a všichni jsou horliví milovníci Zákona. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ale o tobě mají zprávu, že učíš všechny Židy, kteří jsou mezi pohany, aby odstoupili od Mojžíše, a říkáš, že nemají obřezávat syny ani zachovávat zvyky. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Co tedy s tím? Určitě se shromáždí zástup, protože uslyší, že jsi přišel. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Udělej tedy to, co ti říkáme: Máme tu čtyři muže, kteří na sobě mají slib. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Vezmi je k sobě, nech se s nimi očistit a zaplať za ně náklady, aby si oholili hlavy. Tehdy všichni poznají, že na tom, co o tobě slyšeli, nic není, ale že i ty sám chodíš v řádu a zachováváš Zákon. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A ohledně těch, kteří uvěřili z pohanů, my jsme o tom psali a usoudili jsme, aby nic z toho nedodržovali, jen aby se zdržovali od masa obětovaného modlám, od krve, od zardoušeného a od smilstva.” ");
INSERT INTO cesnkb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tehdy Pavel vzal ty muže a když se s nimi druhého dne očistil, vešel do chrámu, aby ohlásil, kdy se vyplní dny toho očištění - až bude za každého z nich přinesena oběť. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","A když se těch sedm dní už mělo vyplnit, spatřili ho v chrámu Židé z Asie. Ti vzbouřili všechen lid a vrhli se na něj ");
INSERT INTO cesnkb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","s křikem: “Izraelité, pomozte! Toto je ten člověk, který všechny všude učí proti tomuto lidu, Zákonu i místu a k tomu ještě přivedl do chrámu Řeky a poskvrnil toto svaté místo!” ");
INSERT INTO cesnkb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Předtím s ním totiž ve městě viděli Trofima z Efezu a domnívali se, že ho Pavel přivedl do chrámu.) ");
INSERT INTO cesnkb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tak se rozbouřilo celé město. Lidé se seběhli, chopili se Pavla a táhli ho ven z chrámu. A dveře byly ihned zavřeny. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Když už ho však chtěli zabít, došla k veliteli posádky zpráva, že se celý Jeruzalém bouří. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ten ihned vzal vojáky a setníky a přiběhl na ně. A oni, jakmile uviděli velitele a vojáky, přestali Pavla bít. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tehdy velitel přistoupil, chopil se ho, poručil, ať ho sváží dvěma řetězy, a ptal se, kdo to je a co udělal. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","V zástupu však jedni křičeli to a druzí ono. A protože kvůli hluku nemohl zjistit nic jistého, poručil, aby ho odvedli do pevnosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","A když se ocitl na schodech, přihodilo se, že ho kvůli násilí davu museli vojáci nést. ");
INSERT INTO cesnkb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Šlo za ním totiž množství lidí křičících: “Pryč s ním!” ");
INSERT INTO cesnkb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Když pak už měl Pavel být přiveden do pevnosti, řekl veliteli: “Mohu ti něco říci?” A on řekl: “Ty umíš řecky? ");
INSERT INTO cesnkb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Takže ty nejsi ten Egypťan, který před nedávnem vzbouřil a vyvedl na poušť ty čtyři tisíce hrdlořezů? ");
INSERT INTO cesnkb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pavel tedy řekl: “Já jsem Žid z Tarsu v Kilikii, občan ne bezvýznamného města. Proto tě prosím, dovol mi promluvit k lidu.” ");
INSERT INTO cesnkb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","A když mu to dovolil, Pavel zůstal na schodech a pokynul rukou lidu. A když nastalo hluboké ticho, promluvil k nim hebrejským jazykem: ");
INSERT INTO cesnkb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bratři a otcové, vyslechněte nyní mou obhajobu před vámi.” ");
INSERT INTO cesnkb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","(A když uslyšeli, že k nim mluví hebrejským jazykem, ztišili se ještě více.) Řekl tedy: ");
INSERT INTO cesnkb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Já jsem zajisté Žid, narozený v kilickém Tarsu, ale vychován jsem v tomto městě u nohou Gamalielových. Byl jsem se vší přísností vyučen otcovskému zákonu a byl jsem horlivcem pro Boha, jako jste podnes vy všichni. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Já jsem tu cestu pronásledoval až k smrti. Svazoval jsem muže i ženy a dával je do vězení, ");
INSERT INTO cesnkb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","čehož je mi svědkem i nejvyšší kněz a všichni starší. Od nich jsem také přijal dopisy pro bratry a šel jsem do Damašku, abych i ty, kteří byli tam, přivedl svázané do Jeruzaléma k potrestání. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ale stalo se mi, že když jsem se okolo poledne blížil na cestě k Damašku, náhle mě obklopilo veliké světlo z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Padl jsem na zem a uslyšel jsem hlas, který mi říkal: ‘Saule, Saule, proč mě pronásleduješ?’ ");
INSERT INTO cesnkb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Odpověděl jsem: ‘Kdo jsi, Pane?’ A on řekl: ‘Já jsem Ježíš Nazaretský, kterého ty pronásleduješ.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ti, kdo byli se mnou, sice viděli světlo a dostali strach, ale hlas toho, který ke mně mluvil, neslyšeli. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Řekl jsem tedy: ‘Pane, co mám dělat?’ Pán mi řekl: ‘Vstaň, jdi do Damašku a tam ti bude řečeno všechno, co je ti určeno dělat.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","A jelikož jsem byl od jasu toho světla nevidomý, přišel jsem do Damašku veden za ruku těmi, kdo byli se mnou. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","A jistý Ananiáš, muž zbožný podle Zákona, který měl dobré svědectví ode všech Židů, kteří tam bydleli, ");
INSERT INTO cesnkb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","přišel ke mně, postavil se a řekl: ‘Bratře Saule, prohlédni!’ A já jsem hned v tu chvíli na něj pohlédl. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","On řekl: ‘Bůh našich otců tě vyvolil, abys poznal jeho vůli a spatřil Spravedlivého a uslyšel hlas z jeho úst, ");
INSERT INTO cesnkb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","neboť mu budeš přede všemi lidmi svědkem toho, co jsi viděl a slyšel. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","A nyní - proč otálíš? Vstaň, pokřti se a smyj své hříchy a vzývej Pánovo jméno!’ ");
INSERT INTO cesnkb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Když jsem se pak vrátil do Jeruzaléma a modlil se v chrámu, stalo se, že jsem upadl do vytržení ");
INSERT INTO cesnkb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","a viděl jsem ho, jak mi říká: ‘Pospěš si a vyjdi rychle z Jeruzaléma, protože tvé svědectví o mně nepřijmou.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Já jsem řekl: ‘Pane, oni vědí, že jsem věřící v tebe dával do vězení a v každé synagoze je bil. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","A když prolévali krev Štěpána, tvého svědka, i já jsem tam stál a schvaloval jeho zabití a hlídal jsem pláště těch, kdo ho zabíjeli.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","On mi však řekl: ‘Jdi, protože tě pošlu daleko k pohanům.’” ");
INSERT INTO cesnkb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Poslouchali ho tedy až po toto slovo a tehdy pozvedli hlas se slovy: “Pryč s takovým člověkem ze země! Nesmí zůstat naživu!” ");
INSERT INTO cesnkb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","A když takto křičeli a rvali si pláště a házeli prach do vzduchu, ");
INSERT INTO cesnkb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","poručil velitel, aby ho odvedli do pevnosti a řekl, ať ho vyslýchají bičováním, aby zjistil, z jakého důvodu na něj tolik křičeli. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Když ho tedy přivázali řemeny, řekl Pavel setníkovi, který tam stál: “Vy smíte bičovat člověka, který je Říman a není odsouzen?” ");
INSERT INTO cesnkb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","A když to ten setník uslyšel, přišel k veliteli a oznámil mu to. Řekl: “Dej pozor, co chceš dělat, protože tento člověk je Říman!” ");
INSERT INTO cesnkb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Velitel tedy přišel k Pavlovi a řekl mu: “Pověz mi, ty jsi Říman?” A on řekl: “Ano.” ");
INSERT INTO cesnkb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Velitel mu tedy odpověděl: “Já jsem to občanství získal za veliké peníze!” Pavel však řekl: “Ale já jsem se tak už narodil.” ");
INSERT INTO cesnkb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ti, kteří ho měli vyslýchat, tedy od něho ihned odstoupili a i velitel dostal strach, když zjistil, že je to Říman a on ho nechal spoutat. ");
INSERT INTO cesnkb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nazítří ho tedy velitel propustil z pout, protože chtěl s jistotou poznat, z čeho ho Židé obviňují, a nařídil, aby se sešli velekněží i celá jejich velerada. Pak přivedl Pavla a postavil ho před nimi. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pavel tedy upřeně pohlédl na veleradu a řekl: “Bratři, já až do tohoto dne žiji před Bohem s naprosto čistým svědomím.” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nejvyšší kněz Ananiáš tedy přikázal těm, kdo u něj stáli, aby ho bili přes ústa. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tehdy mu Pavel řekl: “Tebe bude bít Bůh, obílená stěno! Ty tu sedíš, abys mě soudil podle Zákona a proti Zákonu mě nařizuješ bít?” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ti, kdo tam stáli tedy řekli: “Ty spíláš Božímu nejvyššímu knězi?” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pavel řekl: “Nevěděl jsem, bratři, že je to nejvyšší kněz. Je přece napsáno: ‘Vůdci svého lidu nebudeš zlořečit.’” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Když pak Pavel poznal, že ve veleradě je jedna strana saduceů a druhá farizeů, zvolal: “Bratři, já jsem farizeus, syn farizea; jsem souzen kvůli naději zmrtvýchvstání!” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","A když to řekl, došlo mezi farizeji a saduceji k hádce a shromáždění se rozdělilo. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceové totiž říkají, že není žádné vzkříšení ani anděl nebo duch, ale farizeové to obojí vyznávají. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nastal tedy veliký křik a z farizejské strany povstali zákoníci a bojovali za něj se slovy: “Nic zlého jsme na tomto člověku nenašli; jestliže tedy k němu mluvil duch nebo anděl, nebojujme proti Bohu!” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A když nastal veliký rozbroj, poručil velitel vojákům (z obavy, aby Pavla neroztrhali), ať sejdou dolů, vytrhnou ho z jejich středu a odvedou do pevnosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","A příští noc se k němu postavil Pán a řekl: “Buď statečný, Pavle; protože tak jako jsi o mně svědčil v Jeruzalémě, musíš svědčit i v Římě.” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Když pak nastal den, srotili se někteří z Židů a zapřísáhli se, že nebudou jíst ani pít, dokud nezabijí Pavla. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","A těch, kteří se takto spikli, bylo více než čtyřicet. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ti přistoupili k velekněžím a starším a řekli: “Zavázali jsme se velikou přísahou, že neokusíme žádný pokrm, dokud nezabijeme Pavla. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vy tedy nyní s veleradou dejte vědět veliteli, ať ho zítra přivede k vám, jako byste o něm chtěli zjistit něco přesnějšího. A my jsme připraveni zabít ho předtím, než se k vám přiblíží.” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","O té léčce však uslyšel syn Pavlovy sestry. Přišel tedy, vešel do pevnosti a pověděl to Pavlovi. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pavel tedy k sobě zavolal jednoho ze setníků a řekl: “Doveď tohoto mladíka k veliteli, protože mu má něco oznámit.” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","On ho tedy vzal, odvedl k veliteli a řekl: “Vězeň Pavel mě zavolal a poprosil, abych k tobě přivedl tohoto mladíka, že ti má něco říci.” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Velitel ho tedy vzal za ruku, poodešel s ním stranou a ptal se: “Co mi to máš oznámit?” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","A on řekl: “Židé se dohodli, že tě požádají, abys zítra přivedl Pavla do velerady, jako by o něm chtěli zjistit něco přesnějšího. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ale ty jim nevěř, protože na něj číhá více než čtyřicet z nich. Ti muži se zapřísáhli, že nebudou jíst ani pít, dokud ho nezabijí. Jsou už připraveni a čekají jen na zprávu od tebe!” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Velitel tedy toho mladíka propustil a přikázal mu: “Nikomu neříkej, že jsi mi to oznámil!” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","A když si zavolal určité dva setníky, řekl: “Připravte na třetí noční hodinu dvě stě vojáků k cestě do Cesareje, také sedmdesát jezdců a dvě stě lehkooděnců. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","A přiveďte zvířata, aby na ně Pavla posadili a bezpečně ho dopravili k vladaři Felixovi.” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Napsal také dopis tohoto znění: ");
INSERT INTO cesnkb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Klaudius Lysiáš zdraví vznešeného vladaře Felixe. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Tohoto muže Židé zajali a chtěli zabít. Když jsem se však dozvěděl, že je Říman, přišel jsem s vojskem a vytrhl jim ho. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","A protože jsem chtěl zjistit, z čeho jej obviňují, přivedl jsem ho do jejich velerady. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tehdy jsem shledal, že jej obviňují kvůli nějakým otázkám jejich Zákona, ale že nemá žádnou vinu zasluhující smrt nebo vězení. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","A když mi bylo oznámeno o úkladech, které tomu muži činili Židé, ihned jsem ho poslal k tobě a jeho žalobcům jsem přikázal, aby řekli před tebou, co proti němu mají. Buď zdráv.” ");
INSERT INTO cesnkb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Vojáci tedy vzali Pavla, jak jim bylo nařízeno, a odvedli ho v noci do Antipatridy. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nazítří s ním pak nechali jet jezdce a vrátili se do pevnosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","A ti, když přijeli do Cesareje, doručili vladaři dopis a postavili před něj Pavla. ");
INSERT INTO cesnkb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Když si tedy vladař dopis přečetl, zeptal se, z jaké je provincie, a když zjistil, že z Kilikie, ");
INSERT INTO cesnkb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","řekl: “Vyslechnu tě, až přijdou také tví žalobci.” A nařídil, ať je hlídán v Herodově paláci. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Po pěti dnech tedy sestoupil do Cesareje nejvyšší kněz Ananiáš se staršími a s nějakým řečníkem Tertullem. Ti oznámili vladaři žalobu proti Pavlovi. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","A když byl předvolán, začal Tertullus obžalobu. Řekl: “Díky tobě zakoušíme veliký pokoj a tvojí prozřetelností se v tomto národě děje mnoho náprav, ");
INSERT INTO cesnkb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","což naprosto a všude přijímáme se vší vděčností, vznešený Felixi. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Abych tě však déle nezdržoval, prosím, abys nás s vlídností sobě vlastní krátce vyslyšel. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Shledali jsme totiž, že tento muž je jako mor. Rozněcuje nesváry mezi všemi Židy po celém světě a je vůdcem té sekty nazaretských. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Dokonce se pokusil znesvětit chrám! Zajali jsme ho tedy a chtěli jsme ho soudit podle našeho Zákona. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Přišel však velitel Lysiáš, s velikým násilím nám ho vzal z rukou ");
INSERT INTO cesnkb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","a přikázal, aby jeho žalobci přišli k tobě. Když ho vyslechneš, budeš se od něho moci sám dovědět o tom všem, z čeho jej obviňujeme.” ");
INSERT INTO cesnkb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A s tím souhlasili i Židé a tvrdili, že je to tak. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Když mu tedy vladař pokynul, aby mluvil, Pavel odpověděl: “Jelikož vím, že jsi již mnoho let soudcem tohoto národa, budu se hájit s dobrou myslí, ");
INSERT INTO cesnkb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","protože ti může být známo, že to není více než dvanáct dní, co jsem přišel do Jeruzaléma, abych se poklonil Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","A nenalezli mě, jak se s někým dohaduji v chrámu nebo působím pozdvižení v zástupu nebo v synagogách nebo ve městě. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","A to, z čeho mě teď obviňují, ani nemohou prokázat. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Vyznávám však před tebou, že podle té cesty, kterou nazývají sektou, tak sloužím Bohu našich otců: věřím všemu, co je napsáno v Zákoně a v Prorocích. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","A mám v Bohu naději, kterou chovají i oni sami, že nastane vzkříšení spravedlivých i nespravedlivých. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Proto se sám snažím o to, abych měl vždycky čisté svědomí před Bohem i před lidmi. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Po mnoha letech jsem tedy přišel, abych svému národu přinesl almužny a oběti, ");
INSERT INTO cesnkb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","při čemž mě někteří Židé z Asie nalezli v chrámu očištěného, ne se zástupem ani s pozdvižením. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ti by měli stát před tebou a žalovat, pokud proti mně něco mají. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Anebo ať tito sami řeknou, zda na mně, když jsem stál před veleradou, našli nějakou nepravost, ");
INSERT INTO cesnkb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","kromě toho jednoho výroku, že jsem zvolal, když jsem stál mezi nimi: ‘Já jsem dnes vámi souzen kvůli vzkříšení z mrtvých!’” ");
INSERT INTO cesnkb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","A když to Felix vyslechl, odložil jejich případ, protože už věděl o té cestě něco přesnějšího, a řekl: “Rozsoudím vaši při, až přijede velitel Lysiáš.” ");
INSERT INTO cesnkb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Poručil tedy setníkovi, aby Pavla střežil a ulehčil mu a aby žádnému z jeho přátel nebránil posluhovat mu nebo ho navštěvovat. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Když pak po několika dnech Felix přišel se svou manželkou Drusillou (která byla Židovka), poslal pro Pavla a vyslechl si ho ohledně víry v Krista. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","A když vyprávěl o spravedlnosti a zdrženlivosti a o nadcházejícím soudu, dostal Felix strach a řekl: “Prozatím odejdi; zavolám si tě, až budu mít čas.” ");
INSERT INTO cesnkb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Zároveň však také doufal, že mu Pavel dá peníze, aby ho propustil. Proto také pro něho častěji posílal a hovořil s ním. ");
INSERT INTO cesnkb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Když pak uplynuly dva roky, stal se Felixovým nástupcem Porcius Festus. A protože se Felix chtěl zavděčit Židům, nechal Pavla ve vězení. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Když se tedy Festus ujal vlády v provincii, vydal se po třech dnech z Cesareje vzhůru do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tehdy mu nejvyšší kněz a přední Židé oznámili žalobu proti Pavlovi. Prosili ho ");
INSERT INTO cesnkb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","a dožadovali se té laskavosti, aby ho nechal poslat do Jeruzaléma; chystali totiž léčku, že ho po cestě zabijí. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ale Festus odpověděl, že Pavel má být střežen v Cesareji a že on sám se chystá brzy odjet. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Proto ti,” řekl, “kdo mezi vámi mají moc, ať se vypraví se mnou, a je-li na tom muži nějaká špatnost, ať ho žalují.” ");
INSERT INTO cesnkb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Když tedy mezi nimi pobyl přes deset dní, sestoupil do Cesareje. Druhého dne pak usedl na soudnou stolici a poručil, ať předvedou Pavla. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","A když přišel, obstoupili ho Židé, kteří přišli z Jeruzaléma, a vznášeli proti Pavlovi mnohá a těžká obvinění. Ta však nemohli dokázat, ");
INSERT INTO cesnkb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","když se Pavel hájil: “Ani proti židovskému Zákonu ani proti chrámu ani proti císaři jsem se v ničem neprovinil.” ");
INSERT INTO cesnkb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ale Festus, který se chtěl zavděčit Židům, Pavlovi odpověděl: “Chceš se vydat do Jeruzaléma a tam být ohledně toho přede mnou souzen?” ");
INSERT INTO cesnkb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pavel tedy řekl: “Stojím před císařskou soudnou stolicí, kde mám být souzen. Židům jsem nijak neublížil, jak sám velmi dobře víš. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Jsem-li tedy opravdu v neprávu a spáchal jsem něco zasluhujícího smrt, neodmítám zemřít; jestliže však na tom, z čeho mě obviňují, nic není, nikdo mě jim nemůže vydat. Odvolávám se k císaři!” ");
INSERT INTO cesnkb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tehdy Festus promluvil s radou a odpověděl: “K císaři ses odvolal, k císaři půjdeš!” ");
INSERT INTO cesnkb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Po několika dnech pak do Cesareje dorazil král Agrippa s Bereniké, aby pozdravili Festa. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","A když tam pobyli mnoho dní, vyprávěl Festus králi o Pavlově při. Řekl: “Felix zanechal ve vězení jistého muže. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","A když jsem byl v Jeruzalémě, řekli mi o něm velekněží a židovští starší a žádali jeho odsouzení. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Odpověděl jsem jim, že Římané nemají ve zvyku vydávat nějakého člověka na smrt dříve, než by ten obžalovaný měl své žalobce tváří v tvář a dostal možnost hájit se proti jejich obvinění. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Když se tu tedy sešli, usedl jsem příštího dne beze všech odkladů na soudnou stolici a poručil, ať toho muže předvedou. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","A když povstali jeho žalobci, neobvinili ho z ničeho takového, jak jsem se já domníval, ");
INSERT INTO cesnkb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ale měli s ním spor o nějakých otázkách ohledně toho jejich náboženství a o nějakém mrtvém Ježíši, o kterém Pavel tvrdil, že žije. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Já jsem však byl nad těmi otázkami bezradný a říkal jsem mu, zda by chtěl jít do Jeruzaléma a tam být ohledně nich souzen. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ale když se Pavel odvolal, aby byl zachován k soudu Jeho Veličenstva, nařídil jsem, ať ho hlídají, dokud ho nepošlu k císaři.” ");
INSERT INTO cesnkb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa tedy Festovi řekl: “Také bych si toho člověka chtěl poslechnout.” A on řekl: “Uslyšíš ho zítra.” ");
INSERT INTO cesnkb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","A druhého dne, když Agrippa a Bereniké přišli s velikou nádherou a vstoupili s veliteli a význačnými muži města do jednací síně, byl na Festův rozkaz přiveden Pavel. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tehdy Festus řekl: “Králi Agrippo a všichni muži, kteří jste tu s námi, vidíte tohoto člověka, o kterém se mnou jak v Jeruzalémě, tak zde jednala celá židovská obec s křikem, že nesmí zůstat naživu. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Já jsem však shledal, že nic zasluhujícího smrt nespáchal. Když se ale sám odvolal k Jeho Veličenstvu, rozhodl jsem se ho k němu poslat. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nemám však, co bych svému pánu o něm napsal jistého. Proto jsem ho přivedl před vás, a zvláště před tebe, králi Agrippo, abych až to bude vyšetřeno, měl co napsat. ");
INSERT INTO cesnkb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Zdá se mi totiž nerozumné posílat vězně a neoznámit, z čeho je obviněn.” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Potom Agrippa řekl Pavlovi: “Povoluje se ti, abys mluvil sám za sebe.” Pavel tedy pokynul rukou a začal svou obhajobu: ");
INSERT INTO cesnkb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Králi Agrippo, pokládám se za šťastného, že se dnes mám před tebou zodpovídat ze všech těch věcí, ze kterých mě Židé obviňují, ");
INSERT INTO cesnkb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","zvláště proto, že jsi znalcem všech zvyků a otázek, které se týkají Židů. Proto tě prosím, vyslyš mě trpělivě: ");
INSERT INTO cesnkb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Jaký byl od mládí můj život, který jsem zpočátku trávil ve svém vlastním národě v Jeruzalémě, vědí zajisté všichni Židé. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ti mě od počátku dobře znali (kdyby chtěli vydat svědectví), že jsem žil podle nejpřísnější sekty našeho náboženství jako farizeus. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","A nyní tu stojím, vydán soudu kvůli naději toho zaslíbení, které Bůh dal našim otcům. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dvanáct našich pokolení ustavičně slouží Bohu dnem i nocí v naději, že dojdou k tomu zaslíbení. Kvůli této naději mě Židé žalují, králi Agrippo! ");
INSERT INTO cesnkb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Co je podle vašeho soudu neuvěřitelného na tom, že Bůh křísí mrtvé? ");
INSERT INTO cesnkb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ačkoliv i mně samotnému se zdálo, že toho musím mnoho vykonat proti jménu Ježíše Nazaretského. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","To jsem také v Jeruzalémě dělal. Poněvadž jsem k tomu od velekněží dostal pravomoc, zavřel jsem mnoho svatých do vězení, a když měli být popravováni, hlasoval jsem proti nim. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ve všech synagogách jsem je často trestal a nutil k rouhání. Nesmírně jsem na ně zuřil a pronásledoval je dokonce až do cizích měst.” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“A v tom, když jsem byl na cestě do Damašku s plnou mocí a pověřením od velekněží, ");
INSERT INTO cesnkb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","spatřil jsem, králi, v poledne na cestě světlo z nebe, jasnější než slunce, které obklopilo mě i ty, kdo šli se mnou. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","A když jsme všichni padli na zem, uslyšel jsem hlas, který ke mně mluvil a říkal hebrejským jazykem: ‘Saule, Saule, proč mě pronásleduješ? Je pro tebe těžké vzpírat se proti bodcům.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Já jsem řekl: ‘Kdo jsi, Pane?’ A on řekl: ‘Já jsem Ježíš, kterého ty pronásleduješ. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ale vstaň a stůj na svých nohou; neboť jsem se ti ukázal proto, abych tě učinil služebníkem a svědkem těch věcí, které jsi viděl, i těch, ve kterých se ti budu ukazovat. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Budu tě vysvobozovat od tohoto lidu i od pohanů, ke kterým tě nyní posílám, ");
INSERT INTO cesnkb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","abys otvíral jejich oči, aby se obrátili od tmy ke světlu a od moci Satana k Bohu, aby skrze víru ve mne přijali odpuštění hříchů a podíl mezi posvěcenými.’” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Proto jsem, králi Agrippo, nebyl neposlušný tomu nebeskému vidění, ");
INSERT INTO cesnkb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ale oznamoval jsem nejprve těm, kdo jsou v Damašku, a potom v Jeruzalémě i po celé judské zemi, i pohanům, že mají činit pokání, obrátit se k Bohu a dělat skutky odpovídající pokání. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kvůli tomu mě Židé zajali v chrámu a pokoušeli se mě zabít. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ale protože jsem až do dnešního dne zakoušel pomoc od Boha, stojím, vydávám svědectví malému i velkému a neříkám nic než to, co pověděli proroci i Mojžíš: ");
INSERT INTO cesnkb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Že Kristus má trpět, že jako první vstane z mrtvých a že bude zvěstovat světlo tomuto lidu i pohanům.” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","A když Pavel takto mluvil na svou obranu, Festus vykřikl: “Pavle, ty šílíš! Tvá veliká učenost tě přivádí k šílenství!” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ale on řekl: “Nešílím, vznešený Feste, ale pronáším slova pravdy a střízlivosti. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Král, před kterým také směle mluvím, o těchto věcech zajisté ví. Jsem přesvědčen, že mu nic z toho není neznámo, poněvadž se to nedělo někde v ústraní. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Věříš, králi Agrippo, prorokům? Vím, že věříš.” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tehdy Agrippa Pavlovi odpověděl: “Téměř jsi mě přesvědčil, abych se stal křesťanem.” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pavel však řekl: “Přál bych si od Boha, abys nejen ty, ale i všichni, kdo mě dnes slyší, byli nejen téměř, ale úplně takoví, jako jsem já, kromě těchto pout!” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Když to řekl, král vstal a s ním i vladař a Bereniké i ti, kdo s nimi seděli. ");
INSERT INTO cesnkb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","A když odešli, mluvili spolu a říkali: “Tento člověk nedělá nic zasluhujícího smrt nebo vězení!” ");
INSERT INTO cesnkb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa tedy řekl Festovi: “Kdyby se tento člověk neodvolal k císaři, mohl být propuštěn.” ");
INSERT INTO cesnkb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Jakmile pak bylo rozhodnuto, že vyplujeme do Itálie, byl Pavel s některými jinými vězni svěřen setníkovi jménem Julius z praporu Jeho Veličenstva. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nastoupili jsme tedy na adramyttskou loď, která měla plout podél pobřeží Asie, a vypluli jsme. Byl s námi také Aristarchos, Makedonec z Tesaloniky. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Druhého dne jsme pak přistáli v Sidonu. Julius se choval k Pavlovi přívětivě a dovolil mu zajít k přátelům a užít jejich péče. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Když jsme tedy odtud vyrazili, obepluli jsme Kypr, protože větry byly proti nám. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Přepluli jsme tedy moře podél Kilikie a Pamfylie a přijeli jsme do lykijského města Myry. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tam setník našel alexandrijskou loď, která plula do Itálie, a přivedl nás na ni. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Potom jsme se pomalu plavili po mnoho dní a sotva jsme se dostali naproti Knidu. Protože nám bránil vítr, obepluli jsme Krétu podél Salmóny, ");
INSERT INTO cesnkb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","a když jsme ji s obtížemi minuli, přijeli jsme na jedno místo zvané Pěkné přístavy, blízko něhož bylo město Lasea. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Když pak uběhlo mnoho času a plavba již byla nebezpečná (protože už minul i Půst), Pavel jim domlouval: ");
INSERT INTO cesnkb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Muži, vidím, že tato plavba skončí neštěstím a velikou škodou nejen na lodi a nákladu, ale i na našich životech!” ");
INSERT INTO cesnkb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ale setník více důvěřoval kormidelníkovi a majiteli lodi, než tomu, co říkal Pavel. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","A protože přístav nebyl vhodný k přezimování, většina radila, aby se odtud vyplulo, zda by nějak nemohli k přezimování dorazit do krétského přístavu Fénix, čelícího jihozápadnímu i severozápadnímu větru. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","A když začal lehce vanout jižní vítr, zdálo se jim, že se mají držet svého předsevzetí, a tak zvedli kotvy a pluli těsně podél Kréty. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Zanedlouho však od ní udeřil bouřlivý vítr zvaný Euroklydon, ");
INSERT INTO cesnkb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","a když jím byla loď uchvácena a nemohla tomu větru odolat, nechali jsme se unášet. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Dostali jsme se pak do závětří jednoho ostrůvku zvaného Klauda, kde jsme stěží byli schopni ovládnout člun. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Když ho vytáhli na palubu, použili pomocných prostředků k podvázání lodi a ve strachu, aby nenarazili na syrtskou mělčinu, spustili plachtu a tak se nechali unášet. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","A když námi bouře velice zmítala, začali druhého dne vyhazovat náklad. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A třetího dne jsme vlastníma rukama vyhodili vybavení lodi. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Když se pak po mnoho dní neukazovalo slunce ani hvězdy a doléhala na nás nemalá bouře, ztrácela se nakonec všechna naděje, že se zachráníme. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A když už byli dlouhou dobu bez jídla, tehdy se Pavel postavil uprostřed nich a řekl: “Muži, měli jste mě poslechnout, nevyplouvat z Kréty a ušetřit si toto neštěstí a škodu. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nyní vás ale vyzývám, abyste se vzchopili, protože nikdo z vás nepřijde o život, jen loď bude zničena. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Této noci totiž ke mně přišel anděl toho Boha, kterému patřím a kterému sloužím, ");
INSERT INTO cesnkb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","a řekl: ‘Neboj se, Pavle, musíš se postavit před císaře; a hle, Bůh ti daroval všechny, kdo se plaví s tebou.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Proto buďte dobré mysli, muži; věřím totiž Bohu, že se vše stane tak, jak mi bylo řečeno. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Musíme však dorazit k nějakému ostrovu.” ");
INSERT INTO cesnkb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A když nastala čtrnáctá noc, co jsme byli unášeni napříč Jadranem, začali se kolem půlnoci námořníci domnívat, že se blíží k nějaké zemi. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Spustili tedy olovnici a zjistili hloubku dvaceti sáhů; a když maličko poodjeli a znovu spustili olovnici, zjistili hloubku patnácti sáhů. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","A protože se báli, abychom nenarazili na útesy, spustili ze zádi čtyři kotvy a přáli si, aby nastal den. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Když pak námořníci chtěli utéci z lodi a spustili člun na moře pod záminkou, že chtějí natahovat kotvy také z přídi, ");
INSERT INTO cesnkb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","řekl Pavel setníkovi a vojákům: “Jestliže oni nezůstanou na lodi, nebudete se moci zachránit!” ");
INSERT INTO cesnkb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tehdy vojáci usekli lana od člunu a nechali ho uplavat. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","A než se začalo rozednívat, vyzýval Pavel všechny, aby pojedli: “Dnes již čtrnáctý den čekáte, zůstáváte lační a nic nejíte. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Proto vás prosím, abyste pojedli, neboť je to pro vaši záchranu; nikomu z vás totiž nespadne ani vlas z hlavy. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","A když to řekl, vzal chléb, přede všemi vzdal díky Bohu, nalámal a začal jíst. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Všichni tedy byli povzbuzeni a pojedli. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(Na lodi nás pak bylo celkem dvě stě sedmdesát šest duší.) ");
INSERT INTO cesnkb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","A když se nasytili pokrmem, sypali pšenici do moře, aby odlehčili loď. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Když pak nastal den, nemohli tu zem poznat. Viděli však nějakou zátoku s břehem, na nějž chtěli, bude-li to možné, s lodí najet. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Zbavili se tedy kotev a nechali je v moři. Rozvázali také provazy u kormidel a když vytáhli přední plachtu proti větru, dali se ke břehu. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Když však narazili na místo, kde se schází dvě moře, loď najela na mělčinu a příď pevně uvázla a nemohla se pohnout, ale záď se lámala pod silou vln. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Vojáci tedy radili, že vězňové mají být zabiti, aby některý neuplaval a neunikl. ");
INSERT INTO cesnkb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ale setník jejich záměru zabránil, protože chtěl zachránit Pavla. Poručil tedy těm, kdo uměli plavat, aby vyskočili první a dostali se na zem ");
INSERT INTO cesnkb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","a ostatní za nimi - někteří na prknech jiní na věcech z lodi. A tak se stalo, že se všichni ve zdraví dostali na zem. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Když se tedy zachránili, zjistili, že se ten ostrov jmenuje Malta. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","A domorodci nám prokazovali neobyčejnou přívětivost. Zapálili totiž oheň a všechny nás přijali, kvůli dešti, který nastal, a kvůli zimě. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Když pak Pavel nasbíral spoustu roští a přikládal na oheň, zakousla se mu do ruky zmije, která unikala před teplem. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Když domorodci uviděli toho hada viset od jeho ruky, říkali jedni druhým: “Tento člověk je určitě vrah! Ačkoli se zachránil z moře, Spravedlnost mu nedovolila žít.” ");
INSERT INTO cesnkb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","On ale setřásl hada do ohně a nic zlého se mu nestalo. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Oni však očekávali, že oteče anebo náhle padne mrtev. A když dlouho čekali a viděli, že se mu nic zlého neděje, změnili názor a říkali, že je to bůh. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","V těch místech měl pozemky přední muž toho ostrova, jménem Publius. Ten nás přijal a po tři dny nás přátelsky hostil. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Přihodilo se pak, že otec toho Publia ležel sužován horečkou a úplavicí. Pavel k němu přišel, a když se pomodlil, vložil na něj ruce a uzdravil ho. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","A když se to stalo, přicházeli i ostatní lidé z toho ostrova, kteří byli nemocní, a byli uzdravováni. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ti nás také zahrnuli mnoha poctami, a když jsme měli vyplout, naložili nám, co jsme potřebovali. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Po třech měsících jsme tedy vypluli na alexandrijské lodi se znakem Diových synů, která na tom ostrově přezimovala. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","A když jsme připluli do Syrakus, zůstali jsme tam tři dny. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Odtud jsme se oklikou dostali do Regia. Po jednom dni pak zavál jižní vítr a my jsme druhého dne přijeli do Puteol. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tam jsme nalezli bratry, kteří žádali, abychom u nich sedm dní zůstali. A tak jsme se vydali k Římu. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Když pak o nás uslyšeli tamější bratři, vyšli nám naproti až k Appiově tržišti a ke Třem krčmám. Když je Pavel uviděl, poděkoval Bohu a nabyl odvahy. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","A když jsme přišli do Říma, předal setník vězně veliteli gardy, ale Pavlovi bylo dovoleno, aby bydlel sám s vojákem, který ho hlídal. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Po třech dnech se pak stalo, že Pavel svolal přední z Židů a když se sešli, řekl jim: “Bratři, já jsem neudělal nic proti našemu lidu ani proti otcovským zvykům, ale byl jsem jako vězeň vydán z Jeruzaléma do rukou Římanů. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ti mě vyslechli a chtěli propustit, protože na mně nebyla žádná smrtelná vina. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Když se ale Židé stavěli proti tomu, byl jsem nucen odvolat se k císaři - avšak ne proto, abych nějak obviňoval svůj národ. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","A z toho důvodu jsem vás pozval, abych vás viděl a promluvil s vámi, protože jsem svázán tímto řetězem kvůli naději Izraele.” ");
INSERT INTO cesnkb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Oni mu tedy řekli: “My jsme o tobě nedostali z Judska žádný dopis, ani nám nikdo z bratrů nepřišel podat zprávu nebo říci o tobě něco zlého. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Považujeme však za správné slyšet od tebe, jak smýšlíš; je nám totiž o té sektě známo, že se všude mluví proti ní.” ");
INSERT INTO cesnkb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","A když mu určili den, sešlo se jich mnoho k němu tam, kde byl ubytován, a on jim vykládal a svědčil o Božím království a od rána až do večera je z Mojžíšova zákona a Proroků přesvědčoval o Ježíši. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","A někteří se tím, co říkal, dali přesvědčit, jiní však nevěřili. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Neměli tedy mezi sebou shodu a začali se rozcházet poté, co Pavel řekl to jedno slovo: “Duch Svatý dobře mluvil k našim otcům skrze proroka Izaiáše, ");
INSERT INTO cesnkb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","když řekl: ‘Jdi k tomuto lidu a řekni: Sluchem uslyšíte, ale nijak nepochopíte a zrakem uvidíte, ale nijak neprohlédnete. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Neboť srdce tohoto lidu ztučnělo a svýma ušima ztěžka slyšeli. Své oči pevně zavřeli, aby snad očima neuviděli, ušima neuslyšeli a srdcem nepochopili a neobrátili se abych je neuzdravil.’ ");
INSERT INTO cesnkb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ať je vám tedy známo, že toto Boží spasení bylo posláno pohanům, a ti uslyší!” ");
INSERT INTO cesnkb_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","A když to řekl, Židé odešli a měli mezi sebou veliké hádky. ");
INSERT INTO cesnkb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pavel pak zůstal celé dva roky ve vlastním pronájmu a přijímal všechny, kdo k němu přicházeli, ");
INSERT INTO cesnkb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","kázal Boží království a učil o Pánu Ježíši Kristu se vší smělostí a bez překážek. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Pavel, služebník Ježíše Krista povolaný apoštol, oddělený pro Boží evangelium, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","které Bůh předem zaslíbil skrze své proroky ve svatých Písmech, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ohledně jeho Syna - který podle těla povstal z Davidova semene ");
INSERT INTO cesnkb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","a který byl podle Ducha svatosti mocně označen za Božího Syna skrze vzkříšení z mrtvých - našeho Pána Ježíše Krista, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","skrze něhož jsme přijali tuto milost, totiž apoštolství pro jeho jméno, k poslušnosti víry mezi všemi národy, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","mezi nimiž jste i vy, povolaní Ježíše Krista, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","všem, kteří jsou v Římě, milovaným Božím, povolaným svatým: Milost vám a pokoj od Boha, našeho Otce, a od Pána Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Především pak děkuji svému Bohu skrze Ježíše Krista za vás všechny, že vaše víra se rozhlašuje po celém světě. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Neboť Bůh, kterému sloužím svým duchem v evangeliu jeho Syna, je mi svědkem, jak se o vás neustále zmiňuji, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","když ve svých modlitbách žádám, aby se mi někdy už konečně podařilo přijít z Boží vůle k vám. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Neboť vás toužím vidět, abych vám předal nějaký duchovní dar k vašemu posílení, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","to jest abych byl spolu s vámi potěšen skrze vaši i moji společnou víru. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nechci však bratři, abyste nevěděli, že jsem se mnohokrát rozhodl přijít k vám (ale až dosud jsem měl překážky), abych měl nějaké ovoce i mezi vámi, tak jako i mezi ostatními národy. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Jsem dlužníkem Řeků i cizích národů, jak moudrých, tak nemoudrých, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","takže pokud se mne týče, jsem připraven kázat evangelium i vám, kteří jste v Římě. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nestydím se totiž za Kristovo evangelium, neboť je to Boží moc ke spasení každého, kdo věří, předně Žida, ale i Řeka. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Neboť v něm je zjevena Boží spravedlnost z víry k víře, jak je napsáno: “Spravedlivý pak bude žít z víry.” ");
INSERT INTO cesnkb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Z nebe se zjevuje Boží hněv proti každé bezbožnosti a nepravosti lidí, kteří zadržují pravdu nepravostí. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Vždyť to, co může být o Bohu poznáno, je jim zjevné, Bůh jim to přece zjevil. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Jeho neviditelné znaky, totiž ta jeho věčná moc a božství, jsou přece od stvoření světa jasně vidět, když lidé přemýšlejí o jeho díle, takže nemají výmluvu. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Protože když poznali Boha, neoslavovali ho jako Boha, ani nebyli vděční, ale ve svých myšlenkách propadli marnosti a jejich nerozumné srdce bylo zatemněno. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Prohlašují se za moudré, ale stali se blázny. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","A zaměnili slávu nepomíjejícího Boha za zpodobení obrazu pomíjejícího člověka, ptáků, zvěře a plazů. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","A proto je Bůh vydal v žádostech jejich srdce nečistotě, aby navzájem zneuctívali svá těla, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ty, kteří zaměnili Boží pravdu za lež a ctili stvoření a sloužili mu raději nežli Stvořiteli, který je požehnaný na věky. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Proto je Bůh vydal hanebným vášním; neboť i jejich ženy zaměnily přirozené obcování za to, které je proti přirozenosti. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","A podobně i muži opustili přirozené obcování se ženou a ve své touze se rozpálili k sobě navzájem, takže muži páchají nestydatost s muži a sami na sobě dostávají nutnou odplatu za ten svůj blud. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","A poněvadž neuznali za dobré mít Boha ve známosti, vydal je Bůh zvrácené mysli, aby dělali to, co se nemá. ");
INSERT INTO cesnkb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Jsou naplněni veškerou nepravostí, smilstvem, ničemností, lakotou, zlobou, plní závisti, vraždy, svárlivosti, lsti, zlomyslnosti; ");
INSERT INTO cesnkb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","donašeči, pomlouvači, nenávidící Boha, zpupní, pyšní, vychloubační, kteří vyhledávají zlé věci, neposlouchají rodiče; ");
INSERT INTO cesnkb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nerozumní, nedodržující smlouvy, bezcitní, nesmiřitelní, nemilosrdní, ");
INSERT INTO cesnkb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","kteří ačkoli znají Boží spravedlivé ustanovení, že ti, kteří provozují takové věci, zasluhují smrt, nejenže je dělají také, ale dokonce to těm, kteří je provozují, schvalují. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Proto nemáš výmluvu, ó každý člověče, který soudíš, neboť v čem soudíš jiného, v tom odsuzuješ sám sebe, poněvadž ty, který soudíš, děláš totéž. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Víme přece, že Boží soud proti těm, kteří dělají takové věci, je podle pravdy. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Domníváš se tedy, ó člověče, který soudíš ty, kteří provozují takové věci, a přitom děláš totéž, že ty unikneš Božímu soudu? ");
INSERT INTO cesnkb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Anebo pohrdáš bohatstvím jeho laskavosti, shovívavosti a trpělivosti? Nevíš, že Boží dobrota tě vede k pokání? ");
INSERT INTO cesnkb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ale ty podle své tvrdosti a nekajícího srdce sám sobě shromažďuješ hněv ke dni hněvu a zjevení spravedlivého Božího soudu. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","On “odplatí každému podle jeho skutků”: ");
INSERT INTO cesnkb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","těm, kteří vytrvalostí v konání dobra hledají slávu, čest a nesmrtelnost, věčným životem; ");
INSERT INTO cesnkb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","těm však, kteří jsou svárliví a neposlušní pravdě, ale poslouchají nepravost, odplatí zuřivostí a hněvem, ");
INSERT INTO cesnkb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","soužením a úzkostí, duši každého člověka, který koná zlo, předně Židu, ale i Řeku. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Avšak sláva, čest a pokoj každému, kdo koná dobro, předně Židu, ale i Řeku. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Neboť Bůh nestraní nikomu. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Všichni, kteří hřešili bez Zákona, bez Zákona také zahynou; a všichni, kteří hřešili pod Zákonem, budou Zákonem souzeni. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","(Neboť před Bohem nejsou spravedliví ti, kdo Zákon slyší, ale ospravedlněni budou ti, kdo Zákon plní. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Když totiž pohané, kteří nemají Zákon, dělají z přirozenosti to, co Zákon přikazuje, takoví, ač nemají Zákon, jsou Zákonem sami sobě. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Takoví prokazují dílo Zákona zapsaného v jejich srdcích, což dosvědčuje i jejich svědomí a myšlenky, které se navzájem obviňují anebo obhajují.) ");
INSERT INTO cesnkb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","To se stane v den, kdy Bůh bude soudit lidská tajemství podle mého evangelia skrze Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Hle, ty si říkáš Žid, spoléháš na Zákon a chlubíš se Bohem. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Znáš jeho vůli a rozeznáváš, co je správné, neboť jsi vyučován ze Zákona. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Jsi přesvědčen, že jsi vůdcem slepých a světlem těch, kteří jsou ve tmě, ");
INSERT INTO cesnkb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","vychovatelem nemoudrých, učitelem nemluvňat, někým, kdo má obraz poznání a pravdy v Zákoně. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Proč tedy ty, který učíš jiného, neučíš sám sebe? Ty, který vyhlašuješ, že se nemá krást, kradeš? ");
INSERT INTO cesnkb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ty, který říkáš: “Necizolož!” cizoložíš? Ty, který se štítíš model, se dopouštíš svatokrádeže? ");
INSERT INTO cesnkb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ty, který se chlubíš Zákonem, zneuctíváš Boha přestupováním Zákona? ");
INSERT INTO cesnkb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Neboť “Boží jméno je mezi pohany tupeno kvůli vám”, jak je napsáno. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Obřízka totiž skutečně prospívá, dodržuješ-li Zákon; pokud jsi však přestupníkem Zákona, tvá obřízka se stala neobřízkou. ");
INSERT INTO cesnkb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Jestliže tedy neobřezaný člověk zachovává ustanovení Zákona, nebude se jeho neobřízka počítat za obřízku? ");
INSERT INTO cesnkb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","A nebude ten, který je podle těla neobřezán, ale plní Zákon, soudit tebe, který i s literou a obřízkou Zákon přestupuješ? ");
INSERT INTO cesnkb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Židem totiž není ten, kdo je jím zjevně a obřízka není to, co je zjevné na těle; ");
INSERT INTO cesnkb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ale Židem je ten, kdo je jím v nitru a má srdce obřezané Duchem, ne literou, jehož chvála není od lidí, ale od Boha. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Jakou má tedy Žid výhodu? A jaký je užitek obřízky? ");
INSERT INTO cesnkb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Veliký v každém ohledu! Předně ovšem ten, že jim byla svěřena Boží slova. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Co totiž na tom, jestliže někteří neuvěřili? Zruší snad jejich nevěra Boží věrnost? ");
INSERT INTO cesnkb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","V žádném případě! Ať je však Bůh pravdomluvný a každý člověk lhář, jak je napsáno: “Abys byl shledán spravedlivým ve svých slovech a zvítězil, kdyby ses soudil.” ");
INSERT INTO cesnkb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Jestliže však naše nepravost dokazuje Boží spravedlnost, co řekneme? Je snad Bůh nespravedlivý, když vylévá svůj hněv? (Mluvím po lidsku.) ");
INSERT INTO cesnkb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","V žádném případě! Vždyť jak by potom Bůh soudil svět? ");
INSERT INTO cesnkb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Jestliže se totiž mou lží rozhojnila Boží pravda k jeho slávě, proč jsem tedy ještě souzen jako hříšník? ");
INSERT INTO cesnkb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","A proč neříci: “Čiňme zlé věci, aby přišly dobré,” jak nás pomlouvají a jak někteří tvrdí, že my říkáme? Jejich odsouzení je spravedlivé. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Co tedy? Máme nějakou přednost? Vůbec ne; vždyť jsme již dříve obvinili jak Židy, tak Řeky, že jsou všichni pod hříchem, ");
INSERT INTO cesnkb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","jak je napsáno: “Není spravedlivého, není ani jednoho. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Není, kdo by rozuměl, není, kdo by hledal Boha. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Všichni se odchýlili, společně se stali neužitečnými; není, kdo by konal dobro, není ani jeden.” ");
INSERT INTO cesnkb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Jejich hrdlo je otevřený hrob, svými jazyky podváděli.” “Pod jejich rty je jed lítých hadů.” ");
INSERT INTO cesnkb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Jejich ústa jsou plná zlořečení a hořkosti.” ");
INSERT INTO cesnkb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Jejich nohy jsou rychlé k prolití krve; ");
INSERT INTO cesnkb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","zkáza a bída je na jejich cestách ");
INSERT INTO cesnkb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","a cestu pokoje nepoznali.” ");
INSERT INTO cesnkb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Před jejich očima není Boží bázně.” ");
INSERT INTO cesnkb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Víme pak, že cokoli Zákon říká, říká těm, kdo jsou pod Zákonem, aby byla zacpána všechna ústa a aby všechen svět byl vinen před Bohem. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Na základě skutků Zákona totiž nebude v jeho očích ospravedlněno žádné tělo; neboť skrze Zákon přichází poznání hříchu. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nyní je však bez Zákona zjevena Boží spravedlnost, dosvědčovaná Zákonem i Proroky, ");
INSERT INTO cesnkb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","totiž Boží spravedlnost skrze víru Ježíše Krista ke všem a na všechny, kdo věří. Není totiž rozdílu, ");
INSERT INTO cesnkb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","neboť všichni zhřešili a chybí jim Boží sláva. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Jsou však zadarmo ospravedlňováni jeho milostí, skrze vykoupení, které je v Ježíši Kristu, ");
INSERT INTO cesnkb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","jehož Bůh určil za nástroj smíření skrze víru v jeho krev, aby prokázal svou spravedlnost; neboť Bůh ve své shovívavosti prominul předešlé hříchy, ");
INSERT INTO cesnkb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","aby prokázal svou spravedlnost v nynějším čase, aby byl spravedlivým a ospravedlňujícím toho, kdo je z Ježíšovy víry. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kde je tedy ta chlouba? Byla vyloučena. Skrze jaký zákon? Snad skutků? Nikoli, ale skrze zákon víry. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Máme tedy za to, že člověk je ospravedlňován vírou bez skutků Zákona. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Je snad Bůh jenom Židů? Není také pohanů? Ano, je i pohanů, ");
INSERT INTO cesnkb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","poněvadž je jeden Bůh, který ospravedlní obřezané z víry a neobřezané skrze víru. ");
INSERT INTO cesnkb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Rušíme tedy vírou Zákon? V žádném případě! Naopak, Zákon potvrzujeme. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Co tedy řekneme? Čeho dosáhl Abraham, náš otec podle těla? ");
INSERT INTO cesnkb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Byl-li totiž Abraham ospravedlněn na základě skutků, má se čím chlubit, ale ne před Bohem! ");
INSERT INTO cesnkb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Neboť co říká Písmo? “Abraham uvěřil Bohu a bylo mu to počteno za spravedlnost.” ");
INSERT INTO cesnkb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Tomu, kdo koná skutky, se nepočítá odplata podle milosti, ale podle dluhu. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Avšak tomu, kdo nekoná skutky, ale věří v Toho, který ospravedlňuje bezbožného, se počítá jeho víra za spravedlnost. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Právě tak i David blahoslaví člověka, kterému Bůh přičítá spravedlnost bez skutků: ");
INSERT INTO cesnkb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Blaze těm, kterým byly odpuštěny nepravosti a jejichž hříchy byly přikryty. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blaze muži, kterému Pán už nepočítá hřích.” ");
INSERT INTO cesnkb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Vztahuje se tedy toto blahoslavení na obřízku, anebo i na neobřízku? Říkáme přece, že Abrahamovi byla víra počtena za spravedlnost. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Jak mu tedy byla počtena? Když byl obřezán, anebo ještě neobřezán? Nebylo to v obřízce, ale před obřezáním! ");
INSERT INTO cesnkb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","A znamení obřízky přijal jako pečeť spravedlnosti z víry, kterou měl už před obřezáním, aby byl otcem všech, kdo věří v neobřízce, aby i jim byla přičtena spravedlnost, ");
INSERT INTO cesnkb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","a otcem obřízky těch, kdo nejsou jen z obřízky, ale kteří také kráčí ve šlépějích víry našeho otce Abrahama, která byla před obřezáním. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Neboť zaslíbení, že bude dědicem světa, nebylo Abrahamovi a jeho semeni dáno skrze Zákon, ale skrze spravedlnost víry. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Jestliže jsou totiž dědici ti, kteří jsou ze Zákona, pak je zmařena víra a zrušeno zaslíbení. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","(Zákon přece působí hněv; neboť kde není Zákon, není ani přestoupení.) ");
INSERT INTO cesnkb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Je proto z víry, aby bylo podle milosti, aby zaslíbení bylo jisté všemu semeni, nejen tomu, které je ze Zákona, ale také tomu, které je z Abrahamovy víry. Vždyť on je otcem nás všech ");
INSERT INTO cesnkb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","(jak je napsáno: “Ustanovil jsem tě otcem mnohých národů”) před Bohem, kterému uvěřil, který obživuje mrtvé a povolává věci, které nejsou, jako by byly. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abraham uvěřil v naději proti vší naději, takže se stal otcem mnohých národů podle toho výroku: “Tolik bude tvého semene.” ");
INSERT INTO cesnkb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Neochaboval ve víře: nehleděl na své již umrtvené tělo (bylo mu přibližně sto let), ani na mrtvost Sářina lůna; ");
INSERT INTO cesnkb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","nepochyboval tedy v nevěře o Božím zaslíbení, ale byl posílen vírou, když dal slávu Bohu, ");
INSERT INTO cesnkb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","v plné jistotě, že co Bůh zaslíbil, je schopen i vykonat. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","A proto “mu to bylo počteno za spravedlnost”. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Že “mu to bylo počteno” však není napsáno jen kvůli němu, ");
INSERT INTO cesnkb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ale také kvůli nám, kterým to má být počteno, nám, věřícím v Toho, který vzkřísil z mrtvých našeho Pána Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","On byl vydán pro naše provinění a vzkříšen pro naše ospravedlnění. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Když jsme tedy ospravedlněni z víry, máme pokoj s Bohem skrze našeho Pána, Ježíše Krista, ");
INSERT INTO cesnkb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","skrze něhož také máme vírou přístup k této milosti, ve které stojíme a chlubíme se v naději Boží slávy. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","A nejen to, ale chlubíme se i souženími, neboť víme, že soužení působí vytrvalost, ");
INSERT INTO cesnkb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","vytrvalost spolehlivost a spolehlivost naději. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A naděje nezahanbuje; neboť v našich srdcích je rozlita Boží láska skrze Ducha Svatého, který nám byl dán. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kristus totiž, když jsme my ještě byli bezmocní, v určený čas zemřel za bezbožné. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","(Neboť sotva kdo zemře za spravedlivého, ačkoli za dobrého by se snad i někdo zemřít odvážil.) ");
INSERT INTO cesnkb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Bůh však dokazuje svoji lásku k nám, neboť když jsme ještě byli hříšníci, Kristus zemřel za nás. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Když jsme tedy nyní ospravedlněni jeho krví, budeme potom mnohem spíše skrze něho zachráněni před hněvem. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Neboť jestliže, když jsme ještě byli nepřátelé, byli jsme s Bohem smířeni skrze smrt jeho Syna, mnohem spíše, když jsme již smířeni, budeme zachráněni jeho životem. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","A nejen to, ale chlubíme se také Bohem skrze našeho Pána, Ježíše Krista, skrze něhož jsme nyní přijali smíření. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","A proto, jako skrze jednoho člověka vešel do světa hřích a skrze hřích smrt, tak také smrt přešla na všechny lidi, poněvadž všichni zhřešili - ");
INSERT INTO cesnkb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","(neboť hřích byl na světě už před Zákonem, ale když není Zákon, hřích se nepočítá. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Smrt však kralovala od Adama až po Mojžíše i nad těmi, kdo nezhřešili podobným přestoupením jako Adam, který je obrazem toho budoucího. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Není tomu však s obdarováním tak jako s proviněním? Vždyť jestliže proviněním toho jednoho jich mnoho zemřelo, mnohem spíše se k mnohým rozhojnila Boží milost a dar v milosti toho jednoho člověka, Ježíše Krista! ");
INSERT INTO cesnkb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","A není tomu s darem tak jako s tím, co přišlo skrze toho jednoho, který zhřešil? Vždyť soud nad jedním proviněním vedl k odsouzení, obdarování pak vede z mnoha provinění k ospravedlnění! ");
INSERT INTO cesnkb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Jestliže totiž kvůli provinění jednoho člověka kralovala skrze toho jednoho smrt, mnohem spíše ti, kteří přijímají hojnost milosti a daru spravedlnosti, budou kralovat v životě skrze toho jednoho, Ježíše Krista!) ");
INSERT INTO cesnkb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Tak tedy, jako skrze jediné provinění přišlo na všechny lidi odsouzení, tak také skrze jediný spravedlivý čin přišlo na všechny lidi ospravedlnění života. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Neboť jako se neposlušností jednoho člověka mnozí stali hříšnými, tak se také poslušností jednoho mnozí stanou spravedlivými. ");
INSERT INTO cesnkb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Zákon však přišel proto, aby se rozhojnilo provinění; ale kde se rozhojnil hřích, tam se ještě více rozhojnila milost, ");
INSERT INTO cesnkb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","aby tak jako skrze smrt zavládl hřích, i milost zavládla skrze spravedlnost k věčnému životu skrze našeho Pána, Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Co tedy řekneme? Máme zůstat v hříchu, aby se rozhojnila milost? ");
INSERT INTO cesnkb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","V žádném případě! Jak bychom mohli ještě žít v hříchu my, kdo jsme mu zemřeli? ");
INSERT INTO cesnkb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nevíte snad, že všichni, kteří jsme pokřtěni do Krista Ježíše, jsme pokřtěni do jeho smrti? ");
INSERT INTO cesnkb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Jsme s ním tedy skrze křest pohřbeni do smrti, abychom tak jako byl Kristus vzkříšen z mrtvých Otcovou slávou, i my mohli začít chodit v novosti života. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Jestliže jsme s ním tedy srostlí zpodobením jeho smrti, budeme jistě takoví i ohledně vzkříšení. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Víme přece, že náš starý člověk byl ukřižován s ním, aby bylo odstraněno tělo hříchu, abychom již dále nesloužili hříchu. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Neboť kdo zemřel, je ospravedlněn od hříchu. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Jestliže jsme tedy s Kristem zemřeli, věříme, že s ním také budeme žít. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Víme přece, že Kristus, když byl vzkříšen z mrtvých, už neumírá, smrt nad ním už nepanuje. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Neboť že zemřel, zemřel hříchu jednou provždy, ale že žije, žije Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Tak se i vy považujte za vskutku mrtvé hříchu, ale za živé Bohu v Kristu Ježíši, našem Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ať tedy ve vašich smrtelných tělech nevládne hřích, tak abyste ho poslouchali v jeho žádostech. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Také nevydávejte své údy hříchu za nástroje nepravosti, ale vydejte se Bohu jako ti, kdo ožili z mrtvých a své údy vydejte Bohu za nástroje spravedlnosti. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Neboť hřích nad vámi nebude panovat, protože nejste pod Zákonem, ale pod milostí. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Co tedy? Máme hřešit, když nejsme pod Zákonem, ale pod milostí? V žádném případě! ");
INSERT INTO cesnkb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Nevíte snad, že když se někomu vydáváte za služebníky, abyste ho poslouchali, pak jste služebníky toho, koho posloucháte, ať už hříchu ke smrti, nebo poslušnosti ke spravedlnosti? ");
INSERT INTO cesnkb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ale díky Bohu, že ačkoli jste byli služebníci hříchu, uposlechli jste ze srdce ten způsob učení, do kterého jste byli uvedeni. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Když jste tedy byli osvobozeni od hříchu, byli jste podrobeni do služby spravedlnosti. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Pro slabost vašeho těla to říkám po lidsku: Jako jste vydali své údy za služebníky nečistoty a nepravosti k páchání nepravosti, tak tedy nyní vydejte své údy za služebníky spravedlnosti k posvěcení. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Když jste totiž byli služebníci hříchu, byli jste svobodní od spravedlnosti. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Jaký jste pak tehdy měli užitek z těch věcí, za které se nyní stydíte? Vždyť jejich výsledkem je smrt! ");
INSERT INTO cesnkb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Nyní však, když jste osvobozeni od hříchu a podrobeni do služby Bohu, máte svůj užitek vedoucí k posvěcení a výsledkem je věčný život. ");
INSERT INTO cesnkb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Neboť odplatou za hřích je smrt, ale Božím darem je věčný život v našem Pánu, Ježíši Kristu. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Nevíte snad, bratři (mluvím přece k těm, kdo znají Zákon), že Zákon panuje nad člověkem jen po dobu jeho života? ");
INSERT INTO cesnkb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Neboť vdaná žena je zákonem vázána k žijícímu muži, ale kdyby ten muž zemřel, je zproštěna zákona o muži. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","A proto, oddá-li se jinému muži, zatímco její muž žije, bude nazvána cizoložnicí. Jestliže však její muž zemře, je od toho zákona svobodná, takže není cizoložnicí, když se oddá jinému muži. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","A tak jste i vy, moji bratři, skrze Kristovo tělo umrtveni Zákonu, abyste se oddali jinému - tomu, který byl vzkříšen z mrtvých - abychom mohli nést ovoce Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Když jsme totiž byli v těle, vášně hříchů, probouzené skrze Zákon, působily v našich údech k plození ovoce smrti. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Nyní jsme však zproštěni Zákona, když jsme zemřeli tomu, čím jsme byli drženi, abychom sloužili Bohu v novosti Ducha a ne ve starobě litery. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Co tedy řekneme? Že Zákon je hřích? V žádném případě! Avšak hřích jsem nepoznal jinak než skrze Zákon. Vždyť ani o žádosti bych nevěděl, kdyby Zákon neříkal: “Nebudeš žádostivý!” ");
INSERT INTO cesnkb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Hřích se pak skrze to přikázání chopil příležitosti a způsobil ve mně veškerou žádost. Bez Zákona je tedy hřích mrtev. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Já jsem pak kdysi žil bez Zákona, ale když přišlo přikázání, hřích ožil ");
INSERT INTO cesnkb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","a já jsem zemřel. A ukázalo se, že přikázání, které mělo být k životu, je mi ke smrti. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Neboť hřích, který se skrze to přikázání chopil příležitosti, mne oklamal a skrze ně mne zabil. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Zákon je tedy jistě svatý a přikázání je svaté, spravedlivé a dobré. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Stalo se mi tedy to dobré smrtí? V žádném případě! Avšak hřích, aby se ukázal hříchem, mi skrze to dobré působí smrt, aby se hřích skrze přikázání stal nadmíru hříšným. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Víme přece, že Zákon je duchovní, ale já jsem tělesný, zaprodaný hříchu. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nerozumím totiž tomu, co dělám; neboť nekonám to, co chci, ale dělám to, co nenávidím. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Jestliže tedy dělám to, co nechci, souhlasím se Zákonem, že je dobrý. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Nyní to pak již nedělám já, ale hřích, který ve mně přebývá. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Vím totiž, že ve mně (to jest v mém těle), nepřebývá nic dobrého. Neboť chtění mám u sebe pohotově, ale vykonání toho dobrého nenacházím. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Nekonám totiž dobro, které chci, ale zlo, které nechci, to dělám. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Jestliže pak dělám to, co nechci, pak to již nedělám já, ale hřích, který ve mně přebývá. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nacházím tedy zákon, že když chci dělat dobro, mám u sebe pohotově zlo. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Podle vnitřního člověka totiž radostně souhlasím s Božím Zákonem, ");
INSERT INTO cesnkb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ale ve svých údech vidím jiný zákon, který bojuje proti zákonu mé mysli a činí mě zajatcem zákona hříchu, který je v mých údech. ");
INSERT INTO cesnkb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Já ubohý člověk! Kdo mě vysvobodí z tohoto těla smrti? ");
INSERT INTO cesnkb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Děkuji Bohu - skrze Ježíše Krista, našeho Pána! A tak tedy tentýž já sloužím myslí Zákonu Božímu, ale tělem zákonu hříchu. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","A proto již není žádné odsouzení pro ty, kdo jsou v Kristu Ježíši, kteří nechodí podle těla, ale podle Ducha. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Neboť zákon Ducha života v Kristu Ježíši mě osvobodil od zákona hříchu a smrti. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Neboť co bylo pro Zákon nemožné, protože byl slabý kvůli tělu, to Bůh vykonal, když poslal svého vlastního Syna v podobě těla hříchu a kvůli hříchu. Odsoudil hřích v těle, ");
INSERT INTO cesnkb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","aby byl spravedlivý požadavek Zákona naplněn v nás, kdo nechodíme podle těla, ale podle Ducha. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ti, kdo jsou podle těla, totiž myslí na věci těla, ale ti, kdo jsou podle Ducha, na věci Ducha. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Neboť smýšlení těla je smrt, ale smýšlení Ducha je život a pokoj. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Smýšlení těla je proto v nepřátelství vůči Bohu, neboť není a vlastně ani nemůže být poddáno Božímu zákonu. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","A tak ti, kteří jsou v těle, se Bohu líbit nemohou. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Vy však nejste v těle, ale v Duchu, pokud ve vás přebývá Duch Boží. Jestliže pak někdo nemá Kristova Ducha, ten není jeho. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Jestliže však je Kristus ve vás, je sice tělo mrtvé kvůli hříchu, ale duch žije kvůli spravedlnosti. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Jestliže tedy Duch Toho, který vzkřísil Ježíše z mrtvých, přebývá ve vás, pak Ten, který vzkřísil z mrtvých Krista, obživí i vaše smrtelná těla skrze svého Ducha přebývajícího ve vás. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","A tak tedy, bratři, nejsme dlužníci těla, abychom žili podle těla. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Žijete-li totiž podle těla, zemřete; jestliže však skutky těla umrtvujete Duchem, budete žít. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Neboť všichni, kdo jsou vedeni Božím Duchem, ti jsou Boží synové. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nepřijali jste přece ducha otroctví, abyste se znovu báli, ale přijali jste Ducha synovství, v němž voláme Abba, Otče! ");
INSERT INTO cesnkb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Sám Duch dosvědčuje našemu duchu, že jsme Boží děti. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","A jestliže děti, pak i dědicové, totiž dědicové Boží a spoludědicové Kristovi, abychom jestliže s ním trpíme, byli s ním také oslaveni. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mám totiž za to, že utrpení nynějšího času nejsou srovnatelná s tou slávou, která se má zjevit na nás. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Neboť stvoření napjatě vyhlíží a očekává zjevení Božích synů ");
INSERT INTO cesnkb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","(stvoření je totiž poddáno marnosti, ne dobrovolně, ale kvůli tomu, který je poddal) ");
INSERT INTO cesnkb_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","v naději, že i ono samo bude vysvobozeno z otroctví zkázy do svobody slávy Božích dětí. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Víme přece, že všechno stvoření až dosud společně sténá a pracuje k porodu. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","A nejen ono, ale i my, kteří máme prvotiny Ducha, i my sami v sobě sténáme, zatímco očekáváme přijetí za syny, to jest vykoupení svého těla. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Byli jsme totiž spaseni nadějí. Avšak naděje, která je zjevná, není naděje. (Vždyť proč by někdo doufal v to, co vidí?) ");
INSERT INTO cesnkb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Doufáme-li však v to, co nevidíme, pak to vytrvale očekáváme. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","A tak nám také Duch pomáhá v našich slabostech. Vždyť ani nevíme, za co bychom se měli modlit, jak je potřeba, ale sám Duch oroduje za nás nevýslovným sténáním. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","A ten, který zkoumá srdce, ví, jaké je smýšlení Ducha, že podle Boží vůle prosí za svaté. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Víme pak, že těm, kteří milují Boha, všechny věci napomáhají k dobrému, totiž těm, kteří jsou povoláni podle jeho předsevzetí. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Neboť ty, které předzvěděl, také předurčil, aby byli připodobněni obrazu jeho Syna, aby on byl prvorozený mezi mnoha bratry. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ty, které předurčil, ty také povolal; které povolal, ty také ospravedlnil, a které ospravedlnil, ty také oslavil. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Co k tomu tedy řekneme? Když je Bůh s námi, kdo proti nám? ");
INSERT INTO cesnkb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Jak by nám Ten, který neušetřil svého vlastního Syna, ale vydal ho za nás za všechny, nedaroval s ním také všechny věci? ");
INSERT INTO cesnkb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kdo obviní Boží vyvolené? Vždyť Bůh, ten ospravedlňuje! ");
INSERT INTO cesnkb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kdo nás odsoudí? Vždyť Kristus, ten zemřel, ale hlavně byl vzkříšen z mrtvých; ten je také po Boží pravici a oroduje za nás! ");
INSERT INTO cesnkb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kdo nás oddělí od Kristovy lásky? Snad soužení, úzkost nebo pronásledování? Snad hlad, nahota, nebezpečí nebo meč? ");
INSERT INTO cesnkb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Jak je napsáno: “Pro tebe jsme zabíjeni celý den, počítáni jsme za ovce na porážku.” ");
INSERT INTO cesnkb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ale v tom všem skvěle vítězíme skrze Toho, který si nás zamiloval. ");
INSERT INTO cesnkb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Jsem totiž přesvědčen, že smrt ani život, andělé, vrchnosti ani mocnosti, věci přítomné ani budoucí, ");
INSERT INTO cesnkb_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","výšina ani hlubina ani žádné jiné stvoření nás nebude moci oddělit od Boží lásky, která je v Kristu Ježíši, našem Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Říkám pravdu v Kristu, nelžu; i mé svědomí dosvědčuje v Duchu Svatém, ");
INSERT INTO cesnkb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","že mám veliký zármutek a neustálou bolest ve svém srdci. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Neboť bych si přál být sám zavržen od Krista ve prospěch svých bratrů, svých příbuzných podle těla, ");
INSERT INTO cesnkb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","kteří jsou Izraelité, jimž patří synovství, sláva i smlouvy, vydání Zákona, bohoslužba i zaslíbení, ");
INSERT INTO cesnkb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","jejichž jsou otcové a z nichž podle těla pochází Kristus, který je nade vším, požehnaný Bůh na věky. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Avšak ne že by Boží slovo selhalo. Neboť ne všichni, kdo pocházejí z Izraele, jsou Izrael. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Také ne proto, že jsou símě Abrahamovo, jsou všichni jeho dětmi, ale: “Tvé símě bude povoláno v Izákovi.” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","To jest: Božími dětmi nejsou děti těla, ale za símě se počítají děti zaslíbení. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Neboť toto je slovo zaslíbení: “V tento čas přijdu a Sára bude mít syna.” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","A nejen to, ale také když Rebeka počala z jednoho muže, našeho otce Izáka, dva syny ");
INSERT INTO cesnkb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","(totiž ještě než se narodili a než udělali cokoli dobrého nebo zlého, aby Boží předsevzetí zůstalo podle vyvolení, ne na základě skutků, ale z Toho, který povolává), ");
INSERT INTO cesnkb_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","bylo jí řečeno: “Starší bude sloužit mladšímu.” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Jak je napsáno: “Jákoba jsem si zamiloval, ale Ezaua jsem pojal v nenávist.” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Co tedy řekneme? Je snad u Boha nespravedlnost? V žádném případě! ");
INSERT INTO cesnkb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Vždyť Mojžíšovi říká: “Smiluji se, nad kým se smiluji, a slituji se, nad kým se slituji.” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","A tak nezáleží na tom, kdo chce, ani na tom, kdo usiluje, ale na Bohu, který se smilovává. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Faraonovi přece Písmo říká: “Právě proto jsem tě pozdvihl, abych na tobě ukázal svou moc a aby mé jméno bylo rozhlášeno po celé zemi.” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","A tak se tedy smilovává, nad kým chce, a koho chce, zatvrzuje. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Řekneš mi však: “Proč je tedy ještě nespokojen? Vždyť kdo se vzepřel jeho vůli?” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ale kdo jsi přece ty, ó člověče, že odmlouváš Bohu? Řekne snad výtvor svému tvůrci: “Proč jsi mě udělal takto?” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Nemá snad hrnčíř moc nad hlínou, aby udělal ze stejné hmoty jednu nádobu ke cti a jinou k hanbě? ");
INSERT INTO cesnkb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","A co když Bůh snášel s velikou trpělivostí nádoby hněvu, připravené ke zničení, protože chtěl ukázat hněv a oznámit svou moc? ");
INSERT INTO cesnkb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","A co když chtěl oznámit bohatství své slávy na nádobách milosrdenství, které předem připravil k slávě, ");
INSERT INTO cesnkb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","totiž na nás, které povolal nejen ze Židů, ale i z pohanů? ");
INSERT INTO cesnkb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Jak také říká skrze Ozeáše: “Ne svůj lid nazvu svým lidem a nemilovanou nazvu milovanou. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","A stane se, že na místě, kde jim bylo řečeno: ‘Vy nejste můj lid’, tam budou nazváni ‘Synové živého Boha.’” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Izaiáš pak volá nad Izraelem: “I kdyby byl počet synů Izraele jako je písku v moři, jen ostatek bude zachráněn. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Neboť on naplní své slovo ve spravedlnosti, a to rychle; neboť Pán vykoná své slovo na zemi rychle.” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","A jak předem řekl Izaiáš: “Kdyby nám Pán zástupů nezanechal semeno, byli bychom jako Sodoma, Gomoře bychom byli podobni!” ");
INSERT INTO cesnkb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Co tedy řekneme? Že pohané, kteří spravedlnost nevyhledávali, dosáhli spravedlnosti, totiž spravedlnosti z víry, ");
INSERT INTO cesnkb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","avšak Izrael, který vyhledával spravedlnost Zákona, k zákonu spravedlnosti nedospěl. ");
INSERT INTO cesnkb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Proč? Protože ji nehledali z víry, ale jako by byla na základě skutků Zákona. Narazili na kámen úrazu, ");
INSERT INTO cesnkb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","jak je napsáno: “Hle, pokládám na Sionu kámen úrazu a skálu pohoršení a nikdo, kdo v něj věří, nebude zahanben.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Bratři, touha mého srdce a modlitba k Bohu za Izrael je, aby byli spaseni. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Neboť jim vydávám svědectví, že mají horlivost pro Boha, ale ne podle pravého poznání. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nepoddali se totiž Boží spravedlnosti, protože Boží spravedlnost neznají a snaží se ustanovit svou vlastní spravedlnost. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Vždyť cílem Zákona je Kristus, k ospravedlnění každého věřícího. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Neboť Mojžíš píše o spravedlnosti, která je ze Zákona, toto: “Člověk, který dělá tyto věci, bude jimi živ.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Spravedlnost z víry však mluví takto: “Neříkej ve svém srdci: ‘Kdo vystoupí do nebe?’ (to jest přivést Krista dolů), ");
INSERT INTO cesnkb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","anebo: ‘Kdo sestoupí do propasti?’ (to jest vyvést Krista z mrtvých).” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Co tedy říká? “Blízko tebe je slovo; ve tvých ústech a ve tvém srdci.” (To jest to slovo víry, které kážeme): ");
INSERT INTO cesnkb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Vyznáš-li svými ústy Pána Ježíše a uvěříš-li ve svém srdci, že ho Bůh vzkřísil z mrtvých, budeš spasen. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Srdcem se totiž věří ke spravedlnosti a ústy se vyznává ke spasení. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Vždyť Písmo říká: “Nikdo, kdo v něj věří, nebude zahanben.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Není totiž rozdílu mezi Židem a Řekem, neboť tentýž Pán všech je bohatý ke všem, kdo ho vzývají. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Neboť “každý, kdo by vzýval jméno Pána, bude spasen.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Jak ale budou vzývat Toho, v něhož neuvěřili? A jak uvěří v Toho, o němž neslyšeli? A jak uslyší bez kazatele? ");
INSERT INTO cesnkb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","A jak budou kázat, jestliže nebyli posláni? Jak je napsáno: “Jak krásné jsou nohy zvěstujících pokoj, těch, kteří zvěstují dobré věci.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ale ne všichni uposlechli evangelium. Vždyť Izaiáš říká: “Pane, kdo uvěřil našemu kázání?” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Víra je tedy ze slyšení a slyšení skrze slovo Boží. ");
INSERT INTO cesnkb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Říkám však: Cožpak neslyšeli? Vždyť přece: “Jejich hlas se roznesl po celé zemi a jejich slova do konců světa.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Pravím však: Cožpak Izrael nepoznal? Vždyť první Mojžíš říká: “Vzbudím ve vás žárlivost kvůli těm, kdo nejsou národ; kvůli nemoudrému národu vás popudím k hněvu.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Izaiáš pak směle říká: “Dal jsem se najít těm, kteří mě nehledali; nechal jsem se poznat těm, kteří se po mně neptali.” ");
INSERT INTO cesnkb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ale o Izraeli říká: “Celý den jsem rozprostíral ruce k lidu neposlušnému a odmlouvavému.” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Říkám tedy: Zavrhl snad Bůh svůj lid? V žádném případě! Vždyť i já jsem Izraelita, ze semene Abrahamova, z pokolení Benjamínova. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Bůh nezavrhl svůj lid, který předzvěděl. Nevíte snad, co Písmo říká o Eliášovi? Jak jedná s Bohem proti Izraeli a říká: ");
INSERT INTO cesnkb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Pane, tvé proroky zabili a tvé oltáře rozbořili; zůstal jsem jen já, a i mně usilují o život!” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Co mu ale říká Boží odpověď? “Ponechal jsem si sedm tisíc mužů, kteří nesklonili koleno před Bálem.” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","A tak tedy i v nynější době vznikl ostatek, vyvolený podle milosti. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","(A jestliže podle milosti, tedy ne na základě skutků, jinak by milost již nebyla milost. Jestliže však na základě skutků, již to není milost; jinak již skutek není skutek.) ");
INSERT INTO cesnkb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Co tedy? Izrael nedosáhl toho, co hledá, ale vyvolení toho dosáhli; ostatní pak byli zatvrzeni. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Jak je napsáno: “Bůh jim dal ducha otupělosti, oči, aby neviděli, a uši, aby neslyšeli, až do dnešního dne.” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","A David říká: “Ať se jim jejich stůl stane pastí a nástrahou, pohoršením a odplatou. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Dej, ať se jejich oči zatmějí, aby neviděli, a jejich záda navždy sehni.” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Říkám tedy: Klopýtli snad, aby padli? V žádném případě! Jejich pokleskem přece přišlo spasení k pohanům, aby to v nich vzbudilo žárlivost. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Jestliže pak jejich poklesek znamená bohatství pro svět a jejich nedostatek bohatství pro pohany, čím více bude jejich plnost? ");
INSERT INTO cesnkb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Vám pohanům pak říkám: Jelikož jsem vskutku apoštolem pohanů, oslavuji Boha za svou službu, ");
INSERT INTO cesnkb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","zda bych nějak nemohl vzbudit žárlivost těch, kdo jsou mé tělo, a některé z nich zachránit. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Neboť jestliže jejich odmítnutí znamená smíření světa, co teprve jejich přijetí, ne-li život z mrtvých? ");
INSERT INTO cesnkb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Jsou-li totiž svaté prvotiny, je svaté i těsto. A je-li svatý kořen, jsou svaté i větve. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Jestliže pak jsou některé větve vylomeny a ty, planá oliva, jsi byl naroubován mezi ně a stal ses spoluúčastníkem kořene a tučnosti olivy, ");
INSERT INTO cesnkb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","nechlub se proti těm větvím. Pokud se však vychloubáš, pamatuj, že ne ty neseš kořen, ale kořen tebe. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Řekneš tedy: “Ty větve byly vylomeny, abych já byl naroubován.” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Dobře; nevěrou byly vylomeny, ty však stojíš vírou. Nebuď namyšlený, ale boj se. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Jestliže totiž Bůh neušetřil přirozené větve, věz, že by neušetřil ani tebe. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Pohleď tedy na Boží laskavost i přísnost: k těm, kteří padli, přísnost, ale k tobě laskavost, budeš-li ovšem v té laskavosti zůstávat. Jinak budeš vyťat i ty. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Oni pak také budou naroubováni, pokud nezůstanou v nevěře; Bůh je přece schopen naroubovat je znovu. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Vždyť jestliže jsi ty byl vyťat z přirozeně plané olivy a proti přirozenosti naroubován do ušlechtilé olivy, čím spíše budou ti, kteří jsou přirozenými větvemi, naroubováni do své vlastní olivy? ");
INSERT INTO cesnkb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Neboť nechci, bratři, abyste neznali toto tajemství (abyste nebyli moudří sami před sebou), že Izraeli nastala částečná zatvrzelost, dokud nevejde plnost pohanů. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","A tak bude spasen celý Izrael, jak je napsáno: “Ze Sionu přijde Vysvoboditel a odvrátí bezbožnosti od Jákoba. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","A toto bude má smlouva s nimi, když odejmu jejich hříchy.” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ohledně evangelia jsou tedy nepřátelé kvůli vám, ale ohledně vyvolení jsou Boží milovaní kvůli otcům. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Svých darů a povolání přece Bůh nelituje! ");
INSERT INTO cesnkb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Vždyť tak jako jste vy kdysi byli neposlušní Bohu, ale nyní se vám dostalo milosrdenství pro jejich neposlušnost, ");
INSERT INTO cesnkb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","tak i oni nyní neuposlechli, aby se pro milosrdenství udělené vám i jim dostalo milosrdenství. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Neboť Bůh zavřel všechny pod neposlušnost, aby se nade všemi smiloval. ");
INSERT INTO cesnkb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ó, hloubko bohatství Boží moudrosti i vědění! Jak nevyzpytatelné jsou jeho soudy a jak nevystižitelné jeho cesty! ");
INSERT INTO cesnkb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Vždyť “kdo poznal Pánovu mysl? A kdo se stal jeho poradcem?” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Anebo “kdo mu něco dal předem a bude mu to odplaceno?” ");
INSERT INTO cesnkb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Neboť z něj a skrze něj a pro něj jsou všechny věci. Jemu buď sláva na věky! Amen. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Proto vás vyzývám, bratři, pro Boží milosrdenství, abyste vydali svá těla jako živou oběť, svatou a příjemnou Bohu, skrze vaši rozumnou službu. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","A nepřizpůsobujte se tomuto světu, ale proměňujte se obnovením své mysli, abyste mohli rozeznat, co je dobrá, příjemná a dokonalá Boží vůle. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Neboť skrze milost, která mi je dána, říkám každému, kdo je mezi vámi, aby o sobě nesmýšlel více než se má, ale aby smýšlel střízlivě podle toho, jak Bůh každému udělil míru víry. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Vždyť tak jako máme v jednom těle mnoho údů, ale všechny údy nemají stejnou práci, ");
INSERT INTO cesnkb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tak i my, ačkoli mnozí, jsme jedno tělo v Kristu a jednotlivě údy jedni druhých. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Když tedy máme rozdílná obdarování podle milosti, která je nám dána, ať už proroctví, to konejme v souladu s vírou; ");
INSERT INTO cesnkb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","nebo službu, ve sloužení; nebo ten, kdo učí, ve vyučování; ");
INSERT INTO cesnkb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","nebo ten, kdo povzbuzuje, v povzbuzování; kdo dává, ve štědrosti; kdo vede, v pilnosti; kdo prokazuje milosrdenství, čiň to s ochotou. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Láska ať je bez pokrytectví. Ošklivte si zlé, lněte k dobrému. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Bratrskou láskou srdečně milujte jedni druhé, vzájemně se předcházejte uctivostí, ");
INSERT INTO cesnkb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","v pilnosti nepolevujte, buďte vroucí duchem, služte Pánu, ");
INSERT INTO cesnkb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","v naději se radujte, v soužení buďte trpěliví, v modlitbě vytrvalí, ");
INSERT INTO cesnkb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","v potřebách se dělte se svatými, věnujte se pohostinnosti. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Dobrořečte těm, kdo vás pronásledují, dobrořečte a nezlořečte. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Radujte se s radujícími a plačte s plačícími. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Buďte k sobě navzájem jednomyslní, nesmýšlejte vysoce, ale nechte se vést k poníženým. Nebuďte moudří sami před sebou. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Nikomu neodplácejte zlo zlem. Opatrujte dobré přede všemi lidmi. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Je-li to možné, pokud je na vás, mějte se všemi lidmi pokoj. ");
INSERT INTO cesnkb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nemstěte se sami, milovaní, ale dejte místo hněvu, neboť je napsáno: “Má je pomsta, já odplatím, praví Pán.” ");
INSERT INTO cesnkb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","A tak: “Hladoví-li tvůj nepřítel, nakrm ho; žízní-li, dej mu napít. Neboť když to uděláš, shrneš na jeho hlavu řeřavé uhlí.” ");
INSERT INTO cesnkb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Nenech se přemáhat zlem, ale přemáhej zlo dobrem. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Každá duše ať je poddána nadřízeným vládám. Vždyť není vlády, kromě od Boha; a vlády, které jsou, jsou ustanoveny Bohem. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Proto kdo se staví proti vládě, postavil se proti Božímu ustanovení; a ti, kteří se postavili proti němu, přivedou na sebe odsouzení. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Vládcové přece nejsou postrachem dobrého jednání, ale zlého. Chceš se tedy nebát vlády? Čiň, co je dobré, a budeš mít od ní chválu. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Vždyť je Božím služebníkem pro tvé dobro. Jestliže však jednáš zle, boj se, neboť ne nadarmo nosí meč. Je přece Božím služebníkem, mstitelem k vykonání hněvu nad tím, kdo páchá zlo. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Proto musíme být poddáni, nejen kvůli hněvu, ale také kvůli svědomí. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Vždyť proto také platíte daň, že jsou to Boží služebníci a právě tomu se pilně věnují. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Dávejte tedy každému, co jste povinni: komu daň, tomu daň, komu clo, tomu clo, komu bázeň, tomu bázeň, komu čest, tomu čest. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nikomu nedlužte nic, než abyste se navzájem milovali; neboť ten, kdo miluje druhého, naplnil Zákon. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Vždyť to “Nezcizoložíš, nezabiješ, nebudeš krást, nevydáš falešné svědectví, nebudeš žádostivý” a je-li ještě nějaké jiné přikázání, je shrnuto v tomto slově: “Budeš milovat svého bližního jako sám sebe.” ");
INSERT INTO cesnkb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Láska nepůsobí bližnímu nic zlého; plností Zákona je tedy láska. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Kromě toho znejte dobu, že už je čas probudit se ze spánku. Vždyť teď je naše spasení blíže, nežli když jsme uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Noc pokročila a přiblížil se den. Odložme tedy skutky tmy a oblečme zbroj světla. ");
INSERT INTO cesnkb_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Choďme počestně jako ve dne, ne v hodování a opilství, ne ve smilstvech a nestydatostech, ne ve svárlivosti a závisti, ");
INSERT INTO cesnkb_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ale oblečte se do Pána Ježíše Krista a nepečujte o tělo podle jeho žádostí. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Slabého ve víře přijímejte ne k hádkám o názorech. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Někdo totiž věří, že může jíst všechno; ten, kdo je slabý, však jí jen zeleninu. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ten, kdo jí, ať nepohrdá tím, kdo nejí, a kdo nejí, ať nesoudí toho, kdo jí; vždyť Bůh ho přijal! ");
INSERT INTO cesnkb_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Kdo jsi ty, že soudíš cizího služebníka? Svému vlastnímu pánu stojí nebo padá! Bude však postaven; Bůh je přece schopen ho postavit. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Někdo totiž uznává jeden den nad jiné, jiný uznává každý den. Každý ať má ve své mysli plnou jistotu. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kdo zachovává den, zachovává ho Pánu, a kdo ten den nezachovává, nezachovává ho Pánu. Kdo jí, jí Pánu, neboť děkuje Bohu, a kdo nejí, nejí Pánu a děkuje Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nikdo z nás přece nežije sám sobě a nikdo sám sobě neumírá. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Žijeme-li totiž, žijeme Pánu a umíráme-li, umíráme Pánu. Ať už tedy žijeme nebo umíráme, patříme Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Vždyť proto také Kristus zemřel a vstal z mrtvých a ožil, aby byl Pánem mrtvých i živých. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ty pak, proč soudíš svého bratra? Anebo ty, proč pohrdáš svým bratrem? Všichni se přece postavíme před Kristovou soudnou stolicí. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Vždyť je napsáno: “Jakože jsem živ, praví Pán, skloní se přede mnou každé koleno a každý jazyk vzdá chválu Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","A tak každý z nás bude sám za sebe skládat účet Bohu. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nesuďme již tedy jedni druhé, ale raději posuďte toto: abyste nekladli před bratra kámen úrazu nebo pohoršení. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Vím a jsem přesvědčen v Pánu Ježíši, že nic není nečisté samo o sobě; jenže tomu, kdo něco považuje za nečisté, je to nečisté. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Jestliže se totiž kvůli pokrmu rmoutí tvůj bratr, již nechodíš podle lásky. Nepřiváděj svým pokrmem k záhubě toho, za koho zemřel Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ať tedy vaše dobré není vydáno potupě. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Vždyť Boží království není pokrm a nápoj, ale spravedlnost, pokoj a radost v Duchu Svatém. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Neboť ten, kdo Kristu slouží v těchto věcech, je příjemný pro Boha a vážený pro lidi. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Následujme tedy to, co vede k pokoji a k vzájemnému budování. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Neboř Boží dílo kvůli pokrmu. Jistě, všechno je čisté, ale pro člověka, který jí s překážkou, je to zlé. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Je dobré nejíst maso ani nepít víno ani nedělat nic, na čem se tvůj bratr uráží nebo pohoršuje nebo čím slábne. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ty máš víru? Měj ji sám pro sebe před Bohem. Blaze tomu, kdo nesoudí sám sebe v tom, co uznává za dobré. ");
INSERT INTO cesnkb_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Kdyby ale jedl ten, kdo pochybuje, je odsouzen, protože to není z víry. A cokoli není z víry, je hřích. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","My silní jsme tedy povinni snášet slabosti těch, kdo silní nejsou, a ne se snažit líbit sami sobě. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Každý z nás ať se snaží líbit bližnímu k jeho dobrému, pro vybudování. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Vždyť ani Kristus se nesnažil líbit sám sobě, ale jak je napsáno: “Hanění těch, kdo hanobili tebe, padla na mě.” ");
INSERT INTO cesnkb_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Neboť vše, co bylo předem napsáno, bylo napsáno k našemu poučení, abychom skrze trpělivost a skrze potěšení Písem měli naději. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ať vám tedy Bůh trpělivosti a potěšení dá být mezi sebou jednomyslnými podle Krista Ježíše, ");
INSERT INTO cesnkb_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","abyste jednomyslně jedněmi ústy oslavovali Boha a Otce našeho Pána Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Proto se navzájem přijímejte, jako i Kristus přijal nás do Boží slávy. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Říkám totiž, že Ježíš Kristus se pro Boží pravdu stal služebníkem obřízky, aby potvrdil zaslíbení daná otcům ");
INSERT INTO cesnkb_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","a aby pohané slavili Boha za jeho milosrdenství, jak je napsáno: “Proto tě budu chválit mezi národy a tvému jménu budu zpívat žalmy. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","A znovu říká: “Veselte se, pohané, s jeho lidem!” ");
INSERT INTO cesnkb_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","A znovu: “Chvalte Pána, všechny národy, a velebte ho, všichni lidé!” ");
INSERT INTO cesnkb_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","A znovu Izaiáš říká: “Bude kořen Isajův a pohané budou spoléhat na Toho, který povstane, aby vládl národům.” ");
INSERT INTO cesnkb_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ať vás tedy Bůh naděje naplní veškerou radostí a pokojem ve víře, abyste se rozhojňovali v naději skrze moc Ducha Svatého. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Také já sám jsem o vás přesvědčen, bratři moji, že i vy jste plni dobroty, naplněni veškerým poznáním a schopni se i navzájem napomínat. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Psal jsem vám však, bratři, poněkud směleji, jako ten, kdo vás upomíná, skrze milost, kterou mi Bůh dal ");
INSERT INTO cesnkb_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","k tomu, abych byl služebníkem Ježíše Krista mezi pohany. Konám kněžskou službu Božího evangelia, aby oběť pohanů, posvěcená Duchem Svatým, byla Bohu příjemná. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ohledně Božích věcí tedy mám chloubu v Kristu Ježíši. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Neodvážil bych se totiž mluvit o něčem, co by skrze mě Kristus nevykonal k přivedení pohanů k poslušnosti slovem i skutkem, ");
INSERT INTO cesnkb_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","v moci divů a zázraků, v moci Božího Ducha, takže jsem od Jeruzaléma a okolo až k Illyrii všechno naplnil Kristovým evangeliem. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","A takto usiluji kázat evangelium tam, kde Kristus ani nebyl jmenován, abych nestavěl na cizí základ, ");
INSERT INTO cesnkb_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ale jako je napsáno: “Ti, kterým nebylo o něm zvěstováno, uvidí; a ti, kteří neslyšeli, porozumí.” ");
INSERT INTO cesnkb_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","A tím mi bylo mnohokrát zabráněno přijít k vám. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Nyní však, když již v těchto krajích nemám místo, a protože mám po mnoho let velikou touhu přijít k vám, ");
INSERT INTO cesnkb_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","přijdu k vám, jakmile půjdu do Španěl. Doufám totiž, že vás uvidím, až tudy půjdu, a že mě tam vypravíte, až se s vámi napřed trochu potěším. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Nyní však jdu do Jeruzaléma posloužit svatým, ");
INSERT INTO cesnkb_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","neboť Makedonským a Achájským se zalíbilo udělat nějakou sbírku pro chudé svaté, kteří jsou v Jeruzalémě. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Zalíbilo se jim to totiž a jsou jejich dlužníky. Vždyť jestliže pohané měli účast na jejich duchovních věcech, jsou jim také povinni posloužit tělesnými. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Když to tedy vykonám a zajistím jim toto ovoce, vydám se přes vás do Španěl. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","A vím, že až k vám přijdu, přijdu v plnosti požehnání evangelia Kristova. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Prosím vás však, bratři, skrze Pána Ježíše Krista a skrze lásku Ducha, abyste za mě spolu se mnou bojovali ve svých modlitbách k Bohu, ");
INSERT INTO cesnkb_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","abych byl vysvobozen od nepovolných lidí v Judsku a aby tato má služba Jeruzalému byla příjemná svatým, ");
INSERT INTO cesnkb_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","abych k vám z Boží vůle přišel s radostí a odpočinul si mezi vámi. ");
INSERT INTO cesnkb_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Bůh pokoje ať je s vámi všemi. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Doporučuji vám Fébé, naši sestru, která je služebnicí církve v Kenchrejích, ");
INSERT INTO cesnkb_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","abyste ji přijali v Pánu, jak se sluší na svaté, a abyste stáli při ní, v jakékoli záležitosti by vás potřebovala, neboť i ona byla zastánkyní mnohých i mě samotného. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Pozdravte Priscillu a Akvilu, mé spolupracovníky v Kristu Ježíši, ");
INSERT INTO cesnkb_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","kteří pro můj život nasadili vlastní hrdlo a kterým děkuji nejen já, ale také všechny církve z pohanů; ");
INSERT INTO cesnkb_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","pozdravte i církev v jejich domě. Pozdravte mého milovaného Epeneta, který je prvotinou Acháje v Kristu. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Pozdravte Marii, která se pro nás mnoho napracovala. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Pozdravte Andronika a Junia, mé příbuzné a spoluvězně, kteří jsou významní mezi apoštoly, kteří také byli v Kristu přede mnou. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Pozdravte Amplia, mého milovaného v Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Pozdravte Urbana, našeho spolupracovníka v Kristu, a Stachyna, mého milovaného. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Pozdravte Apella, osvědčeného v Kristu. Pozdravte domácí Aristobulovy. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Pozdravte Herodiona, mého příbuzného. Pozdravte domácí Narkisovy, kteří jsou v Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Pozdravte Tryfénu a Tryfósu, které pracují v Pánu. Pozdravte milovanou Persidu, která se v Pánu velmi napracovala. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Pozdravte Rufa, vyvoleného v Pánu, a jeho i moji matku. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Pozdravte Asynkrita, Flegonta, Herma, Patróba, Hermu i bratry, kteří jsou s nimi. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Pozdravte Filologa a Julii, Nerea a jeho sestru a Olympa i všechny svaté, kteří jsou s nimi. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Pozdravte se navzájem svatým polibkem. Pozdravují vás Kristovy církve. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Vyzývám vás však, bratři, abyste si dávali pozor na ty, kdo působí roztržky a pohoršení proti učení, které jste poznali, a vyvarujte se jich. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Neboť takoví neslouží našemu Pánu Ježíši Kristu, ale svému břichu a lahodnými řečmi a pochlebováním klamou srdce nevinných. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Vždyť vaše poslušnost dospěla ke všem! Raduji se tedy z vás, ale chci, abyste byli moudří v dobrém, avšak prostoduší ve zlém. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Bůh pokoje pak rozdrtí Satana pod vašima nohama brzy. Milost našeho Pána Ježíše Krista s vámi. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Pozdravuje vás Timoteus, můj spolupracovník, a Lukios, Jáson a Sozipater, moji příbuzní. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Pozdravuji vás v Pánu já, Tercius, který jsem tento dopis psal. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Pozdravuje vás Gaius, hostitel můj i celé církve. Pozdravuje vás Erastus, městský správce, a bratr Kvartus. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Milost našeho Pána Ježíše Krista s vámi všemi. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","A Tomu, který je schopen vás posílit podle mého evangelia a kázání Ježíše Krista, podle zjevení tajemství, které bylo po věčné časy skryto, ");
INSERT INTO cesnkb_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ale nyní bylo zjeveno a podle nařízení věčného Boha bylo oznámeno skrze prorocká Písma všem národům k poslušnosti víry - ");
INSERT INTO cesnkb_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","jedinému moudrému Bohu buď sláva skrze Ježíše Krista na věky. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Pavel, podle Boží vůle povolaný apoštol Ježíše Krista, a bratr Sostenes ");
INSERT INTO cesnkb_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","církvi Boží, která je v Korintu, posvěceným v Kristu Ježíši, povolaným svatým, se všemi, kteří vzývají jméno našeho Pána Ježíše Krista na každém místě, jejich i našem: ");
INSERT INTO cesnkb_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Milost vám a pokoj od Boha, našeho Otce, a od Pána Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Vždycky za vás děkuji svému Bohu pro tu Boží milost, která vám byla dána v Kristu Ježíši, ");
INSERT INTO cesnkb_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","že jste v něm obohaceni v každém ohledu, každým slovem i veškerým poznáním, ");
INSERT INTO cesnkb_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","(poněvadž mezi vámi bylo utvrzeno Kristovo svědectví), ");
INSERT INTO cesnkb_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","takže nemáte nedostatek v žádném daru a očekáváte zjevení našeho Pána Ježíše Krista, ");
INSERT INTO cesnkb_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","který vás také utvrdí až do konce, abyste byli bezúhonní v den našeho Pána Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Věrný je Bůh, jímž jste byli povoláni ke společenství jeho Syna Ježíše Krista, našeho Pána! ");
INSERT INTO cesnkb_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Prosím vás však, bratři, jménem našeho Pána Ježíše Krista, abyste všichni mluvili stejně a aby mezi vámi nebyly roztržky, ale abyste byli dokonale spojeni v téže mysli a v tomtéž úsudku. ");
INSERT INTO cesnkb_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Chloini domácí mi totiž o vás, moji bratři, oznámili, že jsou mezi vámi sváry. ");
INSERT INTO cesnkb_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Míním pak to, že každý z vás říká: “Já jsem Pavlův,” “Já zase Apollův,” “Já zase Kéfův” a “Já zase Kristův.” ");
INSERT INTO cesnkb_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Je Kristus rozdělen? Byl snad za vás ukřižován Pavel? Anebo jste byli pokřtěni ve jméno Pavla? ");
INSERT INTO cesnkb_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Děkuji Bohu, že jsem nikoho z vás nepokřtil, kromě Krispa a Gaia, ");
INSERT INTO cesnkb_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","aby někdo neřekl, že jsem křtil ve své jméno. ");
INSERT INTO cesnkb_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Pokřtil jsem vlastně i Štěpánův dům. Jinak nevím, že bych pokřtil někoho dalšího. ");
INSERT INTO cesnkb_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kristus mě totiž neposlal křtít, ale kázat evangelium, ne v moudrosti řeči, aby snad nebyl zmařen Kristův kříž. ");
INSERT INTO cesnkb_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Neboť slovo kříže je těm, kteří hynou, bláznovstvím, ale pro nás, kteří docházímespasení, je to Boží moc. ");
INSERT INTO cesnkb_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Je přece napsáno: “Zahubím moudrost moudrých a rozumnost rozumných zavrhnu.” ");
INSERT INTO cesnkb_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Kde je moudrý? Kde zákoník? Kde je myslitel tohoto věku? Neobrátil Bůh moudrost tohoto světa v bláznovství? ");
INSERT INTO cesnkb_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Když totiž v Boží moudrosti svět nepoznal Boha skrze moudrost, zalíbilo se Bohu spasit věřící skrze bláznivost kázání. ");
INSERT INTO cesnkb_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Židé totiž žádají znamení, Řekové zase hledají moudrost, ");
INSERT INTO cesnkb_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ale my kážeme Krista ukřižovaného - pohoršení pro Židy a bláznovství pro Řeky, ");
INSERT INTO cesnkb_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","těm však, kteří jsou povoláni, jak Židům, tak Řekům, Krista - Boží moc a Boží moudrost. ");
INSERT INTO cesnkb_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Protože Boží bláznivé je moudřejší než lidé a Boží slabé je silnější než lidé. ");
INSERT INTO cesnkb_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Vidíte přece své povolání, bratři, že nemnozí jsou moudří podle těla, nemnozí mocní, nemnozí urození. ");
INSERT INTO cesnkb_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ale bláznivé tohoto světa Bůh vyvolil, aby zahanbil moudré. A slabé tohoto světa Bůh vyvolil, aby zahanbil silné. ");
INSERT INTO cesnkb_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","A neurozené tohoto světa a opovržené Bůh vyvolil, ba dokonce to, co není, aby obrátil vniveč to, co je, ");
INSERT INTO cesnkb_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","aby se před ním nemohlo chlubit žádné tělo. ");
INSERT INTO cesnkb_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Vy jste však z něho v Kristu Ježíši, který se nám stal Boží moudrostí, spravedlností, posvěcením i vykoupením, ");
INSERT INTO cesnkb_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","aby bylo tak, jak je napsáno: “Kdo se chlubí, ať se chlubí v Pánu.” ");
INSERT INTO cesnkb_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Když jsem k vám tedy, bratři, přišel, nepřišel jsem vám zvěstovat Boží svědectví se vznešeností řeči nebo moudrosti. ");
INSERT INTO cesnkb_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Rozhodl jsem se totiž neznat mezi vámi nic než Ježíše Krista, a to toho ukřižovaného. ");
INSERT INTO cesnkb_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","A byl jsem u vás ve slabosti a v bázni a ve mnohém rozechvění. ");
INSERT INTO cesnkb_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","A má řeč a mé kázání nebylo v přesvědčivých řečech lidské moudrosti, ale v dokázání Ducha a moci, ");
INSERT INTO cesnkb_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","aby vaše víra nespočívala v lidské moudrosti, ale v Boží moci. ");
INSERT INTO cesnkb_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Moudrost pak mluvíme mezi dokonalými, avšak ne moudrost tohoto věku, ani vládců tohoto věku, kteří hynou. ");
INSERT INTO cesnkb_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ale mluvíme tajemnou moudrost Boží, tu skrytou moudrost, kterou Bůh předurčil před věky k naší slávě, ");
INSERT INTO cesnkb_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","kterou nikdo z vládců tohoto věku nepoznal, neboť kdyby ji poznali, neukřižovali by Pána slávy. ");
INSERT INTO cesnkb_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ale jak je napsáno: “Co oko nevidělo, ani ucho neslyšelo, ani na lidské srdce nevstoupilo, to připravil Bůh těm, kteří ho milují.” ");
INSERT INTO cesnkb_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nám to však Bůh zjevil skrze svého Ducha. Duch totiž zkoumá všechny věci, i Boží hlubokosti. ");
INSERT INTO cesnkb_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Vždyť kdo z lidí zná nitro člověka, než duch člověka, který je v něm? Tak ani Boží věci nezná nikdo jiný než Duch Boží. ");
INSERT INTO cesnkb_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","My jsme ovšem nepřijali ducha světa, ale Ducha, který je z Boha, abychom věděli, co nám bylo od Boha darováno. ");
INSERT INTO cesnkb_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","O tom také mluvíme (ne slovy, jimž učí lidská moudrost, ale slovy, jimž vyučuje Duch Svatý), když spojujeme duchovní věci s duchovními. ");
INSERT INTO cesnkb_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ale tělesný člověk nepřijímá věci Božího Ducha, neboť jsou mu bláznovstvím, a nemůže je poznat, protože musí být posuzovány duchovně. ");
INSERT INTO cesnkb_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Kdo však je duchovní, posuzuje všechno, sám pak není posuzován od nikoho. ");
INSERT INTO cesnkb_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Neboť: “Kdo poznal Pánovu mysl, aby ho poučil?” A my máme mysl Kristovu! ");
INSERT INTO cesnkb_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","A já jsem k vám, bratři, nemohl mluvit jako k duchovním, ale jako k tělesným, jako k nemluvňatům v Kristu. ");
INSERT INTO cesnkb_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Napájel jsem vás mlékem, ne hutným pokrmem, neboť jste ho ještě nemohli snést a ani dosud nemůžete, ");
INSERT INTO cesnkb_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","neboť jste dosud tělesní. Když je totiž mezi vámi závist, svár a různice, nejste snad tělesní a nechodíte podle člověka? ");
INSERT INTO cesnkb_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Když totiž někdo říká: “Já jsem Pavlův” a jiný “Já Apollův,” nejste snad tělesní? ");
INSERT INTO cesnkb_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Kdo je tedy Pavel? A kdo Apollo? Služebníci, skrze něž jste uvěřili, a to každý, jak mu dal Pán. ");
INSERT INTO cesnkb_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Já jsem sázel, Apollo zaléval, ale Bůh působil vzrůst. ");
INSERT INTO cesnkb_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","A tak ani ten, kdo sází, není nic, ani ten, kdo zalévá, ale Bůh, který dává vzrůst. ");
INSERT INTO cesnkb_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Ten, kdo sází, a ten, kdo zalévá, jsou pak jedno; každý však dostane svou vlastní odplatu podle své vlastní práce. ");
INSERT INTO cesnkb_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Jsme přece Boží spolupracovníci; vy jste Boží pole, Boží stavba. ");
INSERT INTO cesnkb_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Podle Boží milosti, jež mi byla dána, jsem jako moudrý stavitel položil základ, jiný pak na něm staví. Každý však ať dává pozor, jak na něm staví. ");
INSERT INTO cesnkb_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Neboť nikdo nemůže položit jiný základ vedle toho, který je již položen, jenž je Ježíš Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Staví-li pak někdo na tom základě zlato, stříbro, drahé kamení, dříví, seno, slámu, ");
INSERT INTO cesnkb_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","dílo každého vyjde najevo. Ten den je totiž ukáže, neboť bude zjeveno ohněm a ten oheň vyzkouší dílo každého, jaké je. ");
INSERT INTO cesnkb_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Zůstane-li něčí dílo, které na něm postavil, dostane odplatu. ");
INSERT INTO cesnkb_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Shoří-li něčí dílo, utrpí škodu; ale sám bude spasen, avšak tak jako skrze oheň. ");
INSERT INTO cesnkb_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Cožpak nevíte, že jste Boží chrám a že Boží Duch přebývá ve vás? ");
INSERT INTO cesnkb_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Jestliže někdo ničí Boží chrám, toho zničí Bůh, neboť Boží chrám je svatý, a to jste vy. ");
INSERT INTO cesnkb_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ať nikdo neklame sám sebe. Zdá-li se někomu z vás, že je na tomto světě moudrý, ať se stane bláznem, aby se mohl stát moudrým. ");
INSERT INTO cesnkb_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Moudrost tohoto světa je totiž u Boha bláznovstvím. Je přece napsáno: “On chytá moudré v jejich chytráctví.” ");
INSERT INTO cesnkb_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","A znovu: “Pán zná myšlenky moudrých a ví, že jsou marné.” ");
INSERT INTO cesnkb_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ať se proto nikdo nechlubí lidmi; neboť všechno je vaše. ");
INSERT INTO cesnkb_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Ať už Pavel, Apollo nebo Kéfas, ať už svět, život nebo smrt, ať už přítomné věci nebo budoucí - všechno je vaše. ");
INSERT INTO cesnkb_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Vy pak jste Kristovi a Kristus Boží. ");
INSERT INTO cesnkb_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Tak ať o nás člověk smýšlí, jako o Kristových služebnících a správcích Božích tajemství. ");
INSERT INTO cesnkb_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Od správců se ostatně vyžaduje, aby byl každý shledán věrným. ");
INSERT INTO cesnkb_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Mně pak je to to nejmenší, abych byl posuzován vámi anebo lidským soudem; dokonce ani neposuzuji sám sebe. ");
INSERT INTO cesnkb_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Nejsem si totiž o sobě ničeho vědom, ale tím nejsem ospravedlněn, neboť ten, kdo mě posuzuje, je Pán. ");
INSERT INTO cesnkb_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Proto nesuďte nic předčasně, dokud nepřijde Pán, který osvětlí to, co je skryté ve tmě, a zjeví úmysly srdcí. A tehdy bude mít každý chválu od Boha. ");
INSERT INTO cesnkb_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Tyto věci jsem pak, bratři, v podobenství vztáhl na sebe a Apolla kvůli vám, abyste se na nás naučili nesmýšlet nad to, co je napsáno, aby se někdo kvůli jednomu nepyšnil proti druhému. ");
INSERT INTO cesnkb_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Vždyť kdo tě činí zvláštním? A co máš, co jsi nedostal? A když jsi to dostal, proč se chlubíš, jako bys to nedostal? ");
INSERT INTO cesnkb_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Již jste nasyceni, již jste zbohatli! Bez nás jste začali kralovat! Ale kéž byste začali kralovat tak, abychom i my kralovali s vámi. ");
INSERT INTO cesnkb_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Mám totiž zato, že nás poslední apoštoly Bůh vystavil na odiv jako odsouzence k smrti, protože jsme se tomuto světu, andělům i lidem stali podívanou. ");
INSERT INTO cesnkb_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","My jsme kvůli Kristu blázny, ale vy jste v Kristu rozumní; my slabí, ale vy silní; vy slavní, ale my bezectní. ");
INSERT INTO cesnkb_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Až do této hodiny hladovíme a žízníme, trpíme nahotou, dostáváme rány, jsme bez domova. ");
INSERT INTO cesnkb_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","S námahou pracujeme vlastníma rukama; když se nám spílá, žehnáme, když jsme pronásledováni, snášíme to, ");
INSERT INTO cesnkb_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","když jsme tupeni, potěšujeme. Až doposud jsme učiněni jakoby smetím tohoto světa, odpadky u všech lidí. ");
INSERT INTO cesnkb_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Toto nepíši proto, abych vás zahanboval, ale napomínám vás jako své milované děti. ");
INSERT INTO cesnkb_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Vždyť i kdybyste měli deset tisíc pěstounů v Kristu, přesto ne mnoho otců. V Kristu Ježíši jsem vás přece skrze evangelium zplodil já! ");
INSERT INTO cesnkb_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Vyzývám vás tedy, následujte můj příklad. ");
INSERT INTO cesnkb_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Proto jsem k vám poslal Timotea, který je můj milovaný a věrný syn v Pánu. On vám připomene mé cesty v Kristu, jak učím všude v každé církvi. ");
INSERT INTO cesnkb_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Někteří se naduli, jako bych k vám už neměl přijít. ");
INSERT INTO cesnkb_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Přijdu k vám však brzy, bude-li Pán chtít, a poznám ne řeč těch nadutých, ale jejich moc. ");
INSERT INTO cesnkb_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Neboť Boží království nespočívá v řeči, ale v moci. ");
INSERT INTO cesnkb_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Co chcete? Abych k vám přišel s holí, anebo s láskou a duchem krotkosti? ");
INSERT INTO cesnkb_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Vůbec se proslýchá, že je mezi vámi smilstvo, dokonce takové smilstvo, jaké nemá jméno ani mezi pohany - že někdo má manželku svého otce! ");
INSERT INTO cesnkb_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","A vy jste nadutí, než abyste se raději dali do truchlení, aby ten, kdo spáchal takový skutek, byl vyloučen z vašeho středu. ");
INSERT INTO cesnkb_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Já jsem totiž - jako tělem vzdálený, ale duchem přítomný - již rozhodl o tom, kdo to spáchal, jako bych byl přítomen: ");
INSERT INTO cesnkb_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ve jménu našeho Pána Ježíše Krista, až se shromáždíte, vy a můj duch spolu s mocí našeho Pána Ježíše Krista, ");
INSERT INTO cesnkb_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","vydejte takového Satanovi k záhubě těla, aby jeho duch byl spasen v den Pána Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Vaše chlubení není dobré. Nevíte snad, že maličko kvasu prokvasí celé těsto? ");
INSERT INTO cesnkb_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Vyčistěte tedy starý kvas, abyste byli novým těstem, poněvadž jste nekvašení. Vždyť přece byl za nás obětován náš velikonoční Beránek, Kristus! ");
INSERT INTO cesnkb_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Proto slavme svátek ne se starým kvasem, ani s kvasem špatnosti a ničemnosti, ale s nekvašenými chleby upřímnosti a pravdy. ");
INSERT INTO cesnkb_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Napsal jsem vám v dopisu, abyste se nesměšovali se smilníky, ");
INSERT INTO cesnkb_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ale ne vůbec se smilníky tohoto světa nebo s lakomci, rváči nebo s modláři - vždyť potom byste museli ze světa odejít. ");
INSERT INTO cesnkb_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Teď vám však píši, abyste se nesměšovali, kdyby nějaký takzvaný bratr byl smilník, lakomec, modlář, utrhač, opilec nebo rváč. S takovým ani nejezte. ");
INSERT INTO cesnkb_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Vždyť proč bych já měl soudit ještě ty venku? Nesoudíte snad vy ty, kteří jsou uvnitř? ");
INSERT INTO cesnkb_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Ty venku pak soudí Bůh. A tak toho zlého vylučte ze svého středu. ");
INSERT INTO cesnkb_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Jak se někdo z vás odvažuje, když má při proti druhému, soudit se před nespravedlivými a ne před svatými? ");
INSERT INTO cesnkb_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Nevíte, že svatí budou soudit svět? A budete-li vy soudit svět, jste snad nehodní soudit ty nejmenší věci? ");
INSERT INTO cesnkb_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Nevíte, že budeme soudit anděly? Čím spíše tedy věci tohoto života? ");
INSERT INTO cesnkb_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Když už tedy máte soud ohledně věcí tohoto života, osazujete jej těmi, kterými církev pohrdá? ");
INSERT INTO cesnkb_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Říkám to k vašemu zahanbení. To mezi vámi není ani jediný moudrý, který by mohl rozsoudit své bratry? ");
INSERT INTO cesnkb_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ale bratr se soudí s bratrem, a to před nevěřícími! ");
INSERT INTO cesnkb_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Naprostý nedostatek mezi vámi je již to, že máte jedni s druhými soudy. Proč raději nesnášíte křivdu? Proč raději netrpíte škodu? ");
INSERT INTO cesnkb_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Vy ale křivdíte a škodíte, a to svým bratrům! ");
INSERT INTO cesnkb_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Cožpak nevíte, že nespravedliví nebudou dědici Božího království? Nemylte se! Smilníci ani modláři, cizoložníci, zženštilí ani homosexuálové, ");
INSERT INTO cesnkb_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","zloději ani lakomci, opilci, utrhači ani rváči nebudou dědici Božího království. ");
INSERT INTO cesnkb_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","A takoví jste někteří byli, ale jste omyti, nadto posvěceni, ano, ospravedlněni jménem Pána Ježíše a Duchem našeho Boha! ");
INSERT INTO cesnkb_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Všechno smím, ale ne všechno je prospěšné. Všechno smím, ale já se ničím z toho nedám ovládnout. ");
INSERT INTO cesnkb_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Pokrmy patří břichu a břicho pokrmům; Bůh pak jedno i druhé obrátí vniveč. Tělo však nepatří smilstvu, ale Pánu a Pán tělu. ");
INSERT INTO cesnkb_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Bůh vzkřísil Pána - vzkřísí svou mocí i nás! ");
INSERT INTO cesnkb_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Nevíte, že vaše těla jsou Kristovými údy? Vezmu tedy údy Kristovy a učiním je údy nevěstky? V žádném případě! ");
INSERT INTO cesnkb_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Anebo nevíte, že kdo se spojuje s nevěstkou, je s ní jedno tělo? Vždyť Písmo říká: “Ti dva budou jedno tělo.” ");
INSERT INTO cesnkb_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Kdo se však spojuje s Pánem, je s ním jeden duch. ");
INSERT INTO cesnkb_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Utíkejte před smilstvem! Každý hřích, který člověk udělá, je mimo tělo; kdo však smilní, hřeší proti vlastnímu tělu. ");
INSERT INTO cesnkb_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Anebo nevíte, že vaše tělo je chrámem Ducha Svatého ve vás, kterého máte od Boha, a nejste sami svoji? ");
INSERT INTO cesnkb_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Byli jste přece koupeni za cenu. Oslavujte tedy Boha svým tělem i svým duchem, což obojí je Boží. ");
INSERT INTO cesnkb_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ohledně pak toho, o čem jste mi psali: pro člověka by bylo dobré se ženy nedotýkat. ");
INSERT INTO cesnkb_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Avšak vzhledem k smilstvu ať každý má svou manželku a každá žena ať má svého manžela. ");
INSERT INTO cesnkb_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Muž ať prokazuje manželce povinnou náklonnost a podobně také manželka muži. ");
INSERT INTO cesnkb_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Žena nevládne svým tělem, nýbrž její muž; podobně také muž nevládne svým tělem, nýbrž jeho žena. ");
INSERT INTO cesnkb_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Neodpírejte se jeden druhému - jedině snad ze společné shody, na čas, abyste se uvolnili pro půst a modlitbu, a potom se zase spolu sejděte, aby vás Satan nepokoušel pro vaši nezdrženlivost. ");
INSERT INTO cesnkb_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Toto však říkám jako svolení, ne jako nařízení. ");
INSERT INTO cesnkb_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Chtěl bych totiž, aby všichni lidé byli jako já; ale každý má svůj vlastní dar od Boha, jeden tak a druhý jinak. ");
INSERT INTO cesnkb_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Svobodným a vdovám tedy říkám, že by pro ně bylo dobré, kdyby zůstali jako já. ");
INSERT INTO cesnkb_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Nemohou-li se však zdržet, ať vstoupí do manželství. Je přece lepší vstoupit do manželství, než se pálit. ");
INSERT INTO cesnkb_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Manželům pak přikazuji ne já, ale Pán: Manželka ať neodchází od muže. ");
INSERT INTO cesnkb_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Kdyby však přece odešla, ať zůstává nevdaná, anebo ať se smíří s manželem. Také muž ať neopouští svou ženu. ");
INSERT INTO cesnkb_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Ostatním pak říkám já, nikoli Pán: Má-li nějaký bratr nevěřící manželku a ta je ochotná s ním žít, ať ji neopouští. ");
INSERT INTO cesnkb_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","A žena, která má nevěřícího manžela a ten je ochoten s ní žít, ať ho neopouští. ");
INSERT INTO cesnkb_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Nevěřící muž je totiž posvěcen svou manželkou a nevěřící žena je posvěcena svým mužem. Jinak by přece vaše děti byly nečisté, ale nyní jsou svaté. ");
INSERT INTO cesnkb_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Jestliže však nevěřící chce odejít, ať odejde. Bratr ani sestra v takových případech nejsou otroky a Bůh nás povolal k pokoji. ");
INSERT INTO cesnkb_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Vždyť jak víš, manželko, zda získáš svého muže? A jak víš, muži, zda získáš svou ženu? ");
INSERT INTO cesnkb_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Jen ať každý chodí tak, jak mu Pán odměřil, jak každého Bůh povolal. A tak to nařizuji ve všech církvích. ");
INSERT INTO cesnkb_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Byl někdo povolán jako obřezaný? Ať se nečiní neobřezaným. Byl někdo povolán v neobřízce? Ať se nedává obřezat. ");
INSERT INTO cesnkb_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Obřízka nic není a neobřízka nic není. Záleží přece na zachovávání Božích přikázání. ");
INSERT INTO cesnkb_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Každý ať zůstává v tom povolání, v němž byl povolán. ");
INSERT INTO cesnkb_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Byl jsi povolán jako otrok? Neměj s tím starost. Můžeš-li se však stát svobodným, raději toho využij. ");
INSERT INTO cesnkb_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Neboť kdo byl Pánem povolán jako otrok, je Pánův osvobozený. Podobně také ten, kdo je povolán jako svobodný, je Kristův otrok. ");
INSERT INTO cesnkb_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Byli jste koupeni za cenu; nestávejte se otroky lidí! ");
INSERT INTO cesnkb_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Bratři, ať každý před Bohem zůstává v tom, v čem byl povolán. ");
INSERT INTO cesnkb_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Ohledně panen sice nemám Pánovo nařízení, dávám však radu jako ten, kterému se od Pána dostalo milosrdenství být věrným. ");
INSERT INTO cesnkb_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Domnívám se tedy, že je to dobré vzhledem k nynější tísni, totiž že je dobré, aby člověk zůstal tak, jak je. ");
INSERT INTO cesnkb_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Jsi přivázán k ženě? Nehledej rozvázání. Jsi od ženy rozvázán? Nehledej ženu. ");
INSERT INTO cesnkb_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","I kdyby ses však oženil, nezhřešíš, a vdala-li by se panna, nezhřeší. Takoví ovšem budou mít soužení s tělem; já vás však toho chci ušetřit. ");
INSERT INTO cesnkb_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Říkám vám, bratři, toto: čas je krátký. Po jeho zbytek ať ti, kteří mají ženy, jsou, jako by je neměli, ");
INSERT INTO cesnkb_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ti, kdo pláčou, jako by neplakali, ti, kdo se radují, jako by se neradovali, ti, kdo kupují, jako by nic neměli ");
INSERT INTO cesnkb_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","a ti, kdo používají tento svět, jako by ho nevyužívali. Vždyť podoba tohoto světa pomíjí. ");
INSERT INTO cesnkb_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Přeji si, abyste byli bez starostí. Kdo není ženatý, stará se o věci Pána, jak by se zalíbil Pánu, ");
INSERT INTO cesnkb_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","kdo se však oženil, stará se o věci světa, jak by se zalíbil své ženě. ");
INSERT INTO cesnkb_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Mezi ženou a pannou je také rozdíl. Nevdaná žena se stará o věci Pána, aby byla svatá tělem i duchem; vdaná se však stará o věci světa, jak by se zalíbila svému muži. ");
INSERT INTO cesnkb_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Toto pak říkám k vašemu vlastnímu prospěchu - ne abych vám na krk hodil smyčku, ale kvůli slušnosti a proto, abyste vytrvale sloužili Pánu bez rozptylování. ");
INSERT INTO cesnkb_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Domnívá-li se však někdo, že nejedná slušně vůči své panně, jestliže je ve zralém věku a musí to tak být, ať dělá, jak chce: nehřeší. Ať se vezmou. ");
INSERT INTO cesnkb_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Kdo se ovšem pevně ustanovil v srdci a nemá tíseň, ale má svou vůli ve své moci a rozhodl se v srdci tak, že svou pannu zachová, učiní dobře. ");
INSERT INTO cesnkb_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","A tak ten, kdo vstupuje do manželství, činí dobře a ten, kdo do manželství nevstupuje, učiní ještě lépe. ");
INSERT INTO cesnkb_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Žena je vázána zákonem, dokud její muž žije. Kdyby však její muž zemřel, je svobodná vzít si koho chce, ale pouze v Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Podle mého úsudku je však blaženější, kdyby zůstala tak, jak je. A mám zato, že i já mám Ducha Božího. ");
INSERT INTO cesnkb_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Ohledně pak toho, co se obětuje modlám: víme, že všichni máme poznání. (A poznání nadýmá, láska však buduje. ");
INSERT INTO cesnkb_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Zdá-li se někomu, že něco ví, ještě nic nepoznal tak, jak by měl znát. ");
INSERT INTO cesnkb_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Jestliže však někdo miluje Boha, ten je jím poznán.) ");
INSERT INTO cesnkb_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Tedy ohledně pojídání toho, co se obětuje modlám: víme, že modla není ničím na světě a že není žádný jiný Bůh než jeden. ");
INSERT INTO cesnkb_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","I když totiž jsou někteří takzvaní bohové, ať už na nebi nebo na zemi (jakože je mnoho bohů a mnoho pánů), ");
INSERT INTO cesnkb_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","pro nás je ale jediný Bůh - Otec, z něhož je všechno, i my pro něj; a jediný Pán - Ježíš Kristus, skrze něhož je všechno, i my skrze něj. ");
INSERT INTO cesnkb_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ve všech ale toto poznání není. Někteří totiž až dosud jedí věc obětovanou modle s vědomím o modle a jejich svědomí, které je slabé, se poskvrňuje. ");
INSERT INTO cesnkb_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Pokrm nás však Bohu nepřibližuje; neboť budeme-li jíst, nebudeme lepší, a nebudeme-li jíst, nebudeme horší. ");
INSERT INTO cesnkb_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Dejte však pozor, aby se tato vaše svoboda nestala kamenem úrazu pro slabé. ");
INSERT INTO cesnkb_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Vždyť kdyby někdo spatřil tebe, který máš poznání, jak sedíš u jídla v chrámu model, nebude snad svědomí toho, kdo je slabý, povzbuzeno k tomu, aby jedl věci obětované modlám? ");
INSERT INTO cesnkb_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","A tak kvůli tvému poznání zahyne slabý bratr, pro kterého zemřel Kristus. ");
INSERT INTO cesnkb_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Když tedy takto hřešíte proti bratrům a zraňujete jejich slabé svědomí, hřešíte proti Kristu. ");
INSERT INTO cesnkb_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","A proto, jestliže pokrm pohoršuje mého bratra, nebudu už nikdy jíst maso, abych nepohoršil svého bratra. ");
INSERT INTO cesnkb_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Nejsem snad apoštol? Nejsem snad svobodný? neviděl jsem snad našeho Pána Ježíše Krista? Nejste snad vy mé dílo v Pánu? ");
INSERT INTO cesnkb_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Nejsem-li apoštolem pro jiné, pro vás jím však přece jsem; vždyť pečetí mého apoštolství jste vy v Pánu. ");
INSERT INTO cesnkb_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Má obhajoba před těmi, kdo mě posuzují, je tato: ");
INSERT INTO cesnkb_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Nemáme snad právo jíst a pít? ");
INSERT INTO cesnkb_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Nemáme snad právo mít s sebou věřící ženu jako ostatní apoštolové, i Pánovi bratři, i Kéfas? ");
INSERT INTO cesnkb_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Anebo pouze já a Barnabáš nemáme právo přestat pracovat? ");
INSERT INTO cesnkb_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Kdo kdy bojuje na vlastní náklady? Kdo sází vinici a nejí z jejích plodů? A kdo pase stádo a nepije mléko toho stáda? ");
INSERT INTO cesnkb_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Říkám snad tyto věci podle člověka? Neříká to snad i Zákon? ");
INSERT INTO cesnkb_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","V Mojžíšově zákoně je přece napsáno: “Mlátícímu volu nezavážeš ústa.” Má snad Bůh starost o voly? ");
INSERT INTO cesnkb_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Anebo to říká spíše kvůli nám? Jistěže to bylo napsáno kvůli nám, protože ten, kdo oře, má orat v naději a ten, kdo mlátí, v naději, že bude mít na své naději podíl. ");
INSERT INTO cesnkb_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Jestliže jsme vám my rozsívali duchovní věci, je to snad něco velikého, jestliže budeme sklízet vaše tělesné věci? ");
INSERT INTO cesnkb_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Jestliže toho práva na vás požívají druzí, proč ne raději my? My jsme však tohoto práva nevyužili, ale všechno mlčky snášíme, abychom snad nedali nějakou překážku Kristovu evangeliu. ");
INSERT INTO cesnkb_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Nevíte snad, že ti, kdo pracují se svatými věcmi, jedí ze svatých věcí, a ti, kdo slouží při oltáři, mají podíl z oltáře? ");
INSERT INTO cesnkb_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","A stejně tak Pán nařídil, aby ti, kdo kážou evangelium, z evangelia žili. ");
INSERT INTO cesnkb_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Já jsem však nic z toho nevyužil. A toto jsem nenapsal proto, aby se tak stalo při mně, neboť pro mne by bylo lepší, kdybych umřel, než aby někdo zmařil tuto mou chloubu. ");
INSERT INTO cesnkb_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Kážu-li totiž evangelium, nemám se čím chlubit - vždyť na mne doléhá nutnost a běda mně, kdybych nekázal! ");
INSERT INTO cesnkb_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Dělám-li to tedy dobrovolně, mám odplatu; jestliže však ne z vlastní vůle, je mi svěřen úřad. ");
INSERT INTO cesnkb_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Co je tedy mou odplatou? Abych když kážu evangelium, předložil Kristovo evangelium zdarma a svého práva v evangeliu nevyužil. ");
INSERT INTO cesnkb_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Ačkoli jsem totiž svobodný ode všech, vydal jsem se všem za otroka, abych jich co nejvíce získal. ");
INSERT INTO cesnkb_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","A tak jsem pro Židy jako Žid, abych získal Židy; pro ty pod Zákonem jsem jako pod Zákonem, abych získal ty pod Zákonem. ");
INSERT INTO cesnkb_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Pro ty bez Zákona, jsem jako bez Zákona (i když pro Boha nejsem bez Zákona, ale v Zákoně pro Krista), abych získal ty bez Zákona. ");
INSERT INTO cesnkb_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Pro slabé jsem jako slabý, abych získal slabé: všem jsem se stal vším, abych jakkoli aspoň některé zachránil. ");
INSERT INTO cesnkb_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","A toto činím kvůli evangeliu, abych byl jeho spoluúčastníkem. ");
INSERT INTO cesnkb_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Nevíte snad, že ti, kdo běží závod, běží sice všichni, ale vítěznou odměnu dostává jen jeden? Běžte tak, abyste ji získali. ");
INSERT INTO cesnkb_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","A každý, kdo závodí, je ve všem zdrženlivý. Oni to ovšem dělají, aby získali pomíjející věnec, my však nepomíjející. ");
INSERT INTO cesnkb_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Já tedy běžím takto, ne jako v nejistotě; takto bojuji, ne jako bych bušil do větru. ");
INSERT INTO cesnkb_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Raději své tělo tužím a podrobuji do služby, abych snad, když kážu druhým, nebyl sám vyřazen. ");
INSERT INTO cesnkb_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Bratři, nechci, abyste nevěděli, že naši otcové byli všichni pod tím oblakem a všichni prošli mořem; ");
INSERT INTO cesnkb_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","a všichni byli oblakem a mořem pokřtěni v Mojžíše; ");
INSERT INTO cesnkb_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","a všichni jedli tentýž duchovní pokrm; ");
INSERT INTO cesnkb_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","a všichni pili tentýž duchovní nápoj (neboť pili z duchovní skály, která šla za nimi, a ta skála byl Kristus); ");
INSERT INTO cesnkb_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ale ve většině z nich Bůh nenašel zalíbení, neboť byli pobiti na poušti. ");
INSERT INTO cesnkb_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Tyto věci se staly nám pro výstrahu, abychom nedychtili po zlých věcech, jako dychtili oni. ");
INSERT INTO cesnkb_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Nebuďte ani modláři, jako někteří z nich, jak je napsáno: “Lid si sedl, aby jedl a pil, a vstali, aby se bavili.” ");
INSERT INTO cesnkb_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Ani nesmilněme, jako někteří z nich smilnili a padlo jich v jeden den dvacet tři tisíc. ");
INSERT INTO cesnkb_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Ani nepokoušejme Krista, jako někteří z nich pokoušeli a byli zahubeni hady. ");
INSERT INTO cesnkb_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ani nereptejte, jako někteří z nich reptali a byli zahubeni zhoubcem. ");
INSERT INTO cesnkb_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","A toto všechno se jim stalo na výstrahu a bylo to zapsáno pro napomenutí nám, ke kterým dospěly konce věků. ");
INSERT INTO cesnkb_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Proto ať ten, kdo se domnívá, že stojí, dá pozor, aby nepadl. ");
INSERT INTO cesnkb_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Nezachvátilo vás jiné pokušení než lidské. Ale věrný je Bůh, který vás nenechá pokoušet nad vaše možnosti, ale způsobí se zkouškou také východisko, abyste ji mohli unést. ");
INSERT INTO cesnkb_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","A proto, moji milovaní, utíkejte před modlářstvím. ");
INSERT INTO cesnkb_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Mluvím jako k rozumným lidem; sami posuďte, co říkám. ");
INSERT INTO cesnkb_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Kalich požehnání, který žehnáme - není to snad společenství Kristovy krve? Chléb, který lámeme - není to snad společenství Kristova těla? ");
INSERT INTO cesnkb_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Vždyť jsme, ač mnozí, jedním chlebem, jedním tělem, neboť máme všichni podíl na tom jednom chlebu. ");
INSERT INTO cesnkb_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Pohleďte na Izrael podle těla: nejsou snad ti, kdo jedí z obětí, účastníky oltáře? ");
INSERT INTO cesnkb_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Co tedy říkám? Že modla je něco? Anebo, že modlám obětované je něco? ");
INSERT INTO cesnkb_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Říkám spíše, že to, co obětují pohané, obětují démonům a ne Bohu. A já nechci, abyste byli účastníky démonů. ");
INSERT INTO cesnkb_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Nemůžete pít Pánův kalich i kalich démonů; nemůžete mít podíl na Pánově stolu i na stolu démonů. ");
INSERT INTO cesnkb_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Anebo chceme Pána popouzet k žárlivosti? Jsme snad silnější než on? ");
INSERT INTO cesnkb_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Všechno smím, ale ne všechno je prospěšné; všechno smím, ale ne všechno buduje. ");
INSERT INTO cesnkb_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Nikdo ať nehledá svůj prospěch, ale každý prospěch toho druhého. ");
INSERT INTO cesnkb_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Jezte, cokoli se prodává na masném trhu, a na nic se kvůli svědomí nevyptávejte, ");
INSERT INTO cesnkb_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","neboť “Pánova je země i její plnost.” ");
INSERT INTO cesnkb_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Jestliže vás někdo z nevěřících zve a vy tam chcete jít, jezte, cokoli vám nabídnou, a na nic se kvůli svědomí nevyptávejte. ");
INSERT INTO cesnkb_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Kdyby vám však někdo řekl: “Toto je obětované modlám,” nejezte kvůli tomu, kdo vám to oznámil, a kvůli svědomí. Vždyť “Pánova je země i její plnost.” ");
INSERT INTO cesnkb_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Nemluvím ovšem o tvém vlastním svědomí, ale o svědomí toho druhého. Vždyť proč má být moje svoboda souzena svědomím někoho jiného? ");
INSERT INTO cesnkb_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","A jestliže já požívám pokrm s děkováním, proč mám být tupen kvůli tomu, za co vzdávám díky? ");
INSERT INTO cesnkb_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Ať už tedy jíte nebo pijete nebo děláte cokoli, dělejte všechno k Boží slávě. ");
INSERT INTO cesnkb_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Buďte bezúhonní pro Židy, pro Řeky i pro Boží církev, ");
INSERT INTO cesnkb_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","jako se i já všem snažím líbit v každém ohledu, nehledaje vlastní užitek, ale užitek mnohých, aby byli spaseni. ");
INSERT INTO cesnkb_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Následujte můj příklad, tak jako já následuji Kristův. ");
INSERT INTO cesnkb_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Chválím vás, bratři, že ve všem pamatujete na mne a dodržujete ustanovení tak, jak jsem vám je vydal. ");
INSERT INTO cesnkb_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Chci však, abyste věděli, že hlavou každého muže je Kristus, hlavou ženy muž a hlavou Krista Bůh. ");
INSERT INTO cesnkb_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Každý muž modlící se nebo prorokující s pokrytou hlavou hanobí svou hlavu. ");
INSERT INTO cesnkb_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Také každá žena modlící se nebo prorokující s nezahalenou hlavou hanobí svou hlavu; vždyť je to jedno a totéž, jako kdyby se oholila. ");
INSERT INTO cesnkb_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Jestliže se totiž žena nezahaluje, ať se také ostříhá. Je-li však pro ženu hanba, aby se ostříhala nebo oholila, ať se zahaluje. ");
INSERT INTO cesnkb_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Muž si ovšem nemá zahalovat hlavu, neboť je obrazem a slávou Boží, žena však je slávou muže. ");
INSERT INTO cesnkb_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Vždyť muž není z ženy, ale žena z muže. ");
INSERT INTO cesnkb_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Muž přece také nebyl stvořen kvůli ženě, ale žena kvůli muži. ");
INSERT INTO cesnkb_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Proto má žena mít na hlavě znamení moci kvůli andělům. ");
INSERT INTO cesnkb_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Avšak v Pánu není ani žena bez muže, ani muž bez ženy. ");
INSERT INTO cesnkb_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Neboť jako je žena z muže, tak je také muž skrze ženu, a všechny věci jsou z Boha. ");
INSERT INTO cesnkb_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Posuďte sami mezi sebou: je vhodné, aby se žena modlila k Bohu nezahalená? ");
INSERT INTO cesnkb_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Neučí vás snad ani sama přirozenost, že pro muže je hanba, když má dlouhé vlasy? ");
INSERT INTO cesnkb_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Má-li však dlouhé vlasy žena, je to pro ni sláva; dlouhé vlasy jsou jí totiž dány místo závoje. ");
INSERT INTO cesnkb_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Míní-li však někdo být neústupným, my takový zvyk nemáme a církve Boží také ne. ");
INSERT INTO cesnkb_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Když však přikazuji tyto věci, nechválím to, že se nescházíte k prospěchu, ale ke škodě. ");
INSERT INTO cesnkb_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Především slyším, že když se scházíte v církvi, jsou mezi vámi roztržky, a zčásti tomu věřím. ");
INSERT INTO cesnkb_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Musí totiž mezi vámi být i sekty, aby se ukázali ti, kdo jsou mezi vámi vskutku osvědčení. ");
INSERT INTO cesnkb_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Když se tedy spolu scházíte, není to k tomu, abyste jedli Pánovu večeři; ");
INSERT INTO cesnkb_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","vždyť každý si při jídle bere nejdříve svou večeři, a tak jeden hladoví a jiný je opilý. ");
INSERT INTO cesnkb_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Cožpak nemáte domy, abyste v nich jedli a pili? Anebo pohrdáte Boží církví a zahanbujete ty, kteří nic nemají? Co vám mám říci? Mám vás pochválit? Za toto vás nechválím! ");
INSERT INTO cesnkb_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Neboť já jsem přijal od Pána to, co jsem vám také předal, že Pán Ježíš v tu noc, kdy byl zrazen, vzal chléb, ");
INSERT INTO cesnkb_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","a když vzdal díky, rozlomil jej a řekl: “Vezměte, jezte, toto je mé tělo, které se láme za vás. Toto čiňte na mou památku.” ");
INSERT INTO cesnkb_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Stejně tak i kalich, když povečeřel, se slovy: “Tento kalich je ta nová smlouva v mé krvi. Toto čiňte, kdykoli byste jej pili, na moji památku.” ");
INSERT INTO cesnkb_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Neboť kdykoli byste jedli tento chléb a pili tento kalich, zvěstujete Pánovu smrt, dokud nepřijde. ");
INSERT INTO cesnkb_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","A proto, kdokoli by jedl tento chléb a pil Pánův kalich nehodně, bude vinen tělem a krví Pána. ");
INSERT INTO cesnkb_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Ať tedy člověk prověří sám sebe a takto ať jí z toho chleba a pije z toho kalichu. ");
INSERT INTO cesnkb_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Neboť kdo jí a pije nehodně, jí a pije sám sobě odsouzení, jelikož nerozsuzuje Pánovo tělo. ");
INSERT INTO cesnkb_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Proto jsou mezi vámi mnozí slabí a nemocní a mnozí usínají. ");
INSERT INTO cesnkb_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Kdybychom se totiž rozsuzovali sami, nebyli bychom souzeni. ");
INSERT INTO cesnkb_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Když jsme však souzeni, býváme Pánem vychováváni, abychom nebyli odsouzeni se světem. ");
INSERT INTO cesnkb_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","A tak, moji bratři, když se scházíte k jídlu, čekejte jedni na druhé. ");
INSERT INTO cesnkb_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","A jestliže má někdo hlad, ať jí doma, abyste se nescházeli k odsouzení. Ostatní věci pak zařídím, až přijdu. ");
INSERT INTO cesnkb_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Nechci pak, bratři, abyste nevěděli o duchovních darech. ");
INSERT INTO cesnkb_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Víte, že jste byli pohané a chodili jste k němým modlám, jak jste bývali vedeni. ");
INSERT INTO cesnkb_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Proto vám oznamuji, že nikdo, kdo mluví v Duchu Svatém, neřekne “Ježíš buď proklet,” a nikdo nemůže říci “Ježíš je Pán,” jedině v Duchu Svatém. ");
INSERT INTO cesnkb_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Jsou rozličné dary, ale tentýž Duch, ");
INSERT INTO cesnkb_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","jsou rozličné služby, ale tentýž Pán ");
INSERT INTO cesnkb_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","a jsou rozličná působení, ale Bůh, který to všechno ve všech působí, je tentýž. ");
INSERT INTO cesnkb_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","A tak je každému dáván projev Ducha k užitku: ");
INSERT INTO cesnkb_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","jednomu je totiž skrze Ducha dáváno slovo moudrosti, jinému pak slovo poznání podle téhož Ducha, ");
INSERT INTO cesnkb_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","dalšímu víra v témž Duchu a jinému dary uzdravování v tomtéž Duchu, ");
INSERT INTO cesnkb_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","jinému pak činění zázraků, jinému proroctví, jinému rozlišování duchů, jinému rozličné druhy jazyků, jinému výklad jazyků. ");
INSERT INTO cesnkb_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","To vše ale působí jeden a tentýž Duch, který každému uděluje zvlášť, tak jak chce. ");
INSERT INTO cesnkb_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Vždyť tak jako je tělo jedno a má mnoho údů (ačkoli je totiž všech údů toho jednoho těla mnoho, jsou jedním tělem), tak je tomu i s Kristem. ");
INSERT INTO cesnkb_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Všichni jsme totiž byli v jednom Duchu pokřtěni do jednoho těla - ať už Židé nebo Řekové, otroci nebo svobodní - a všichni jsme byli napojeni jedním Duchem. ");
INSERT INTO cesnkb_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Tělo přece není jeden úd, ale mnoho. ");
INSERT INTO cesnkb_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Kdyby noha řekla: “Protože nejsem ruka, nepatřím do těla,” nepatří snad kvůli tomu do těla? ");
INSERT INTO cesnkb_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","A kdyby ucho řeklo: “Protože nejsem oko, nepatřím do těla,” nepatří snad kvůli tomu do těla? ");
INSERT INTO cesnkb_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Kdyby celé tělo bylo okem, kde by byl sluch? Kdyby bylo celé sluchem, kde by byl čich? ");
INSERT INTO cesnkb_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Nyní však Bůh umístil údy v těle, každý jednotlivý z nich tak, jak chtěl. ");
INSERT INTO cesnkb_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Kdyby však byli všichni jedním údem, kde by bylo tělo? ");
INSERT INTO cesnkb_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Nyní pak je vskutku mnoho údů, avšak jedno tělo. ");
INSERT INTO cesnkb_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","A oko nemůže říci ruce: “Nepotřebuji tě,” nebo zase hlava nohám: “Nepotřebuji vás.” ");
INSERT INTO cesnkb_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Naopak! Mnohem spíše jsou potřebné ty údy těla, které se zdají být slabší. ");
INSERT INTO cesnkb_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","A těm údům těla, které máme za méně ctihodné, těm prokazujeme větší čest. Naše neslušné údy dostávají větší slušnost, ");
INSERT INTO cesnkb_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","kterou ovšem naše slušné údy nepotřebují. Bůh ale složil tělo tak, že dal větší čest tomu, kterému se jí nedostává, ");
INSERT INTO cesnkb_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","aby v těle nebylo rozdělení, ale aby údy měly o sebe navzájem stejnou péči. ");
INSERT INTO cesnkb_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","A tak, jestliže trpí jeden úd, trpí s ním všechny údy. Jestliže je jeden úd chválen, všechny údy se radují spolu s ním. ");
INSERT INTO cesnkb_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Vy jste tedy Kristovo tělo a jednotlivě jeho údy. ");
INSERT INTO cesnkb_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","A Bůh ustanovil v církvi některé takto: za prvé apoštoly, za druhé proroky, za třetí učitele, potom zázraky, potom dary uzdravování, potom pomoci, vedení, rozličné druhy jazyků. ");
INSERT INTO cesnkb_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Jsou snad všichni apoštolové? Jsou snad všichni proroci? Jsou snad všichni učitelé? Činí snad všichni zázraky? ");
INSERT INTO cesnkb_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Mají snad všichni dary uzdravování? Mluví snad všichni jazyky? Vykládají snad všichni? ");
INSERT INTO cesnkb_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Mějte však horlivou touhu po lepších darech a já vám ukážu ještě mnohem vyšší cestu: ");
INSERT INTO cesnkb_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Kdybych mluvil jazyky lidí i andělů, ale neměl bych lásku, stal jsem se dunícím kovem nebo řinčícím činelem. ");
INSERT INTO cesnkb_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","A kdybych měl proroctví a rozuměl všem tajemstvím a veškerému poznání a kdybych měl všechnu víru, takže bych i hory přenášel, ale neměl bych lásku, nejsem nic. ");
INSERT INTO cesnkb_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","A kdybych všechen svůj majetek vynaložil na krmení chudých a kdybych vydal své tělo ke spálení, ale neměl bych lásku, nic mi to neprospěje. ");
INSERT INTO cesnkb_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Láska je trpělivá, je dobrotivá, láska nezávidí, láska se nevychloubá ani nenadýmá; ");
INSERT INTO cesnkb_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","nechová se nepatřičně, nehledá svůj prospěch, nedá se vydráždit, nemyslí na nic zlého; ");
INSERT INTO cesnkb_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","neraduje se z nepravosti, ale raduje se s pravdou; ");
INSERT INTO cesnkb_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","všechno snáší, všemu věří, ve vše doufá, všechno vydrží. ");
INSERT INTO cesnkb_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Láska nikdy neselhává. Avšak proroctví, ta zaniknou, jazyky, ty přestanou, poznání, to bude zmařeno. ");
INSERT INTO cesnkb_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Částečně totiž poznáváme a částečně prorokujeme, ");
INSERT INTO cesnkb_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ale jakmile přijde to dokonalé, tehdy to, co je částečné, zanikne. ");
INSERT INTO cesnkb_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Dokud jsem byl dítě, mluvil jsem jako dítě, smýšlel jsem jako dítě, uvažoval jsem jako dítě; když jsem se však stal mužem, zanechal jsem dětinských věcí. ");
INSERT INTO cesnkb_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Nyní totiž vidíme jako v zrcadle, zastřeně, ale potom tváří v tvář. Nyní poznávám částečně, ale potom poznám tak, jak jsem byl také sám poznán. ");
INSERT INTO cesnkb_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Nyní pak zůstává víra, naděje a láska, tato trojice; ale největší z nich je láska. ");
INSERT INTO cesnkb_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Následujte lásku, mějte horlivou touhu po duchovních darech, nejvíce však, abyste prorokovali. ");
INSERT INTO cesnkb_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Neboť ten, kdo mluví jazykem, nemluví k lidem, ale k Bohu (nikdo mu totiž nerozumí) a duchem mluví tajemství. ");
INSERT INTO cesnkb_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Avšak ten, kdo prorokuje, mluví k lidem pro jejich vybudování, povzbuzení a potěšení. ");
INSERT INTO cesnkb_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Ten, kdo mluví jazykem, buduje sám sebe, avšak ten, kdo prorokuje, buduje církev. ");
INSERT INTO cesnkb_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Chtěl bych, abyste všichni mluvili jazyky, ale ještě více, abyste prorokovali. Ten, kdo prorokuje, je totiž větší než ten, kdo mluví jazyky, ledaže by také vykládal, aby se budovala církev. ");
INSERT INTO cesnkb_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Nyní však, bratři, kdybych k vám přišel a mluvil jazyky, čím vám prospěji, pokud k vám nepromluvím ve zjevení, v poznání, v proroctví nebo v učení? ");
INSERT INTO cesnkb_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Podobně i neživé věci vydávající zvuk, jako flétna nebo harfa: kdyby nevydávaly rozdílné zvuky, jak by se poznalo, co se píská nebo hraje? ");
INSERT INTO cesnkb_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","A kdyby polnice vydala nejistý zvuk, kdo se bude chystat do boje? ");
INSERT INTO cesnkb_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","A tak je to i s vámi: pokud jazykem nepronesete srozumitelné slovo, jak se pozná, co se mluví? Vždyť budete mluvit do větru! ");
INSERT INTO cesnkb_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Přijde-li na to, na světě je tolik druhů řečí a žádná není beze smyslu! ");
INSERT INTO cesnkb_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Jestliže tedy nebudu znát smysl té řeči, budu tomu, kdo mluví, cizincem a ten, kdo mluví, bude cizincem pro mě. ");
INSERT INTO cesnkb_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","A tak i vy, poněvadž jste horliví milovníci duchovních darů, snažte se v tom rozhojňovat pro vybudování církve. ");
INSERT INTO cesnkb_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Proto ať se ten, kdo mluví jazykem, modlí, aby mohl vykládat. ");
INSERT INTO cesnkb_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Modlím-li se totiž jazykem, modlí se můj duch, ale má mysl je bez užitku. ");
INSERT INTO cesnkb_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Co tedy? Budu se modlit duchem, budu se však modlit také myslí. Budu zpívat duchem, budu však zpívat také myslí. ");
INSERT INTO cesnkb_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Kdybys totiž dobrořečil jen v duchu, jak ten, kdo zaujímá místo prostého člověka, řekne “Amen” ke tvému díkůčinění, když neví, co říkáš? ");
INSERT INTO cesnkb_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Ty totiž jistě vzdáváš díky správně, ale jiný se tím nebuduje. ");
INSERT INTO cesnkb_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Děkuji svému Bohu, že mluvím jazyky více než vy všichni; ");
INSERT INTO cesnkb_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ve sboru ale raději chci promluvit pět slov svou myslí, abych poučil i druhé, než deset tisíc slov v jazyce. ");
INSERT INTO cesnkb_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Bratři, nebuďte dětmi ohledně myšlení, ale buďte jako nemluvňata ohledně zlého. Ohledně myšlení pak buďte dospělí. ");
INSERT INTO cesnkb_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","V Zákoně je napsáno: “Jinými jazyky a cizími rty budu mluvit k tomuto lidu a ani tak mě neposlechnou, praví Pán.” ");
INSERT INTO cesnkb_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Jazyky tedy nejsou znamením pro věřící, ale pro nevěřící; proroctví však není pro nevěřící, ale pro věřící. ");
INSERT INTO cesnkb_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Kdyby se tedy sešla celá církev najednou a všichni by mluvili jazyky a přišli by tam prostí lidé nebo nevěřící, neřeknou snad, že blázníte? ");
INSERT INTO cesnkb_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Kdyby ale všichni prorokovali a přišel by někdo nevěřící nebo prostý, bude všemi usvědčován a všemi posuzován. ");
INSERT INTO cesnkb_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","A tak budou zjevena tajemství jeho srdce; potom padne na tvář, pokloní se Bohu a vyzná, že Bůh je opravdu mezi vámi. ");
INSERT INTO cesnkb_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Co tedy, bratři? Když se scházíte, každý z vás má žalm, má vyučování, má jazyk, má zjevení, má výklad. Ať se to všechno děje k budování. ");
INSERT INTO cesnkb_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Mluví-li někdo jazykem, ať mluví dva nebo nejvýše tři, a to postupně, a jeden ať vykládá. ");
INSERT INTO cesnkb_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Kdyby tam však nebyl vykladač, ať ve shromáždění mlčí a mluví jen pro sebe a pro Boha. ");
INSERT INTO cesnkb_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Proroci ať mluví dva nebo tři a ostatní ať to rozsuzují. ");
INSERT INTO cesnkb_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","A jestliže je něco zjeveno jinému, který tam sedí, ať ten první mlčí. ");
INSERT INTO cesnkb_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Můžete přece jeden po druhém prorokovat všichni, aby se všichni učili a všichni byli povzbuzováni. ");
INSERT INTO cesnkb_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Duchové proroků jsou pak poddáni prorokům, ");
INSERT INTO cesnkb_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","neboť Bůh není Bohem nepořádku, ale pokoje, jako ve všech sborech svatých. ");
INSERT INTO cesnkb_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Vaše ženy ať při shromážděních mlčí, neboť se jim nedovoluje mluvit, ale mají být poddány, jak říká i Zákon. ");
INSERT INTO cesnkb_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Chtějí-li se něco dozvědět, ať se ptají svých mužů doma. Je přece hanba, aby ženy při shromáždění mluvily. ");
INSERT INTO cesnkb_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Vyšlo snad Boží slovo od vás? Dorazilo snad jenom k vám? ");
INSERT INTO cesnkb_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Domnívá-li se někdo, že je prorok nebo duchovní, ať uznává, že to, co vám píši, jsou Pánova přikázání. ");
INSERT INTO cesnkb_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Jestliže však někdo neví, ať neví. ");
INSERT INTO cesnkb_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","A proto, bratři, mějte horlivou touhu prorokovat a nikomu nebraňte mluvit v jazycích. ");
INSERT INTO cesnkb_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Všechno ať se děje slušně a podle řádu. ");
INSERT INTO cesnkb_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Připomínám vám, bratři, evangelium, které jsem vám kázal, které jste přijali a v němž stojíte, ");
INSERT INTO cesnkb_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","skrze něž také docházíte spasení (pokud se držíte slova, které jsem vám kázal - jinak byste uvěřili nadarmo). ");
INSERT INTO cesnkb_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Předal jsem vám totiž především to, co jsem také přijal: že Kristus zemřel za naše hříchy podle Písem ");
INSERT INTO cesnkb_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","a že byl pohřben a třetího dne byl vzkříšen podle Písem ");
INSERT INTO cesnkb_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","a že se ukázal Kéfovi a potom dvanácti. ");
INSERT INTO cesnkb_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Poté se ukázal více než pěti stům bratrů najednou, z nichž většina dosud žije a někteří zesnuli. ");
INSERT INTO cesnkb_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Pak se ukázal Jakubovi, potom všem apoštolům ");
INSERT INTO cesnkb_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","a naposledy ze všech se jako nedochůdčeti ukázal i mně. ");
INSERT INTO cesnkb_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Já jsem přece nejmenší z apoštolů; ani nejsem hoden být apoštolem nazýván, protože jsem pronásledoval Boží církev. ");
INSERT INTO cesnkb_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Boží milostí však jsem to, co jsem, a jeho milost ke mně nebyla marná, ale pracoval jsem více než oni všichni; avšak ne já, ale Boží milost, která je se mnou. ");
INSERT INTO cesnkb_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Já i oni tedy takto kážeme a takto jste uvěřili. ");
INSERT INTO cesnkb_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Když se tedy o Kristu káže, že je vzkříšen z mrtvých, jak mohou někteří mezi vámi říkat, že není zmrtvýchvstání? ");
INSERT INTO cesnkb_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Jestliže není zmrtvýchvstání, pak není vzkříšen ani Kristus! ");
INSERT INTO cesnkb_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","A jestliže Kristus není vzkříšen, pak je naše kázání marné; marná je i vaše víra! ");
INSERT INTO cesnkb_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","My jsme pak navíc shledáni jako falešní Boží svědkové, protože jsme vydali o Bohu svědectví, že vzkřísil Krista, jehož nevzkřísil - pokud totiž mrtví nejsou kříšeni. ");
INSERT INTO cesnkb_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Vždyť jestliže mrtví nejsou kříšeni, pak nebyl vzkříšen ani Kristus! ");
INSERT INTO cesnkb_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","A jestliže Kristus nebyl vzkříšen, vaše víra je marná - ještě jste ve svých hříších. ");
INSERT INTO cesnkb_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Pak tedy i ti, kteří zesnuli v Kristu, zahynuli. ");
INSERT INTO cesnkb_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Jestliže pak máme v Kristu naději pouze v tomto životě, jsme nejpolitováníhodnější ze všech lidí. ");
INSERT INTO cesnkb_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Nyní je však Kristus vzkříšen; stal se prvotinou těch, kdo zesnuli. ");
INSERT INTO cesnkb_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Poněvadž totiž skrze člověka přišla smrt, přišlo skrze člověka také zmrtvýchvstání. ");
INSERT INTO cesnkb_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Neboť tak jako v Adamovi všichni umírají, tak také v Kristu budou všichni obživeni. ");
INSERT INTO cesnkb_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Každý však ve svém pořadí: jako prvotina Kristus, při jeho příchodu pak ti, kteří jsou Kristovi. ");
INSERT INTO cesnkb_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Potom bude konec, až Kristus předá království Bohu a Otci, až zruší každou vládu i každou vrchnost a moc. ");
INSERT INTO cesnkb_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","On totiž musí kralovat, dokud nepoloží všechny nepřátele pod jeho nohy. ");
INSERT INTO cesnkb_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Poslední nepřítel, který bude zničen, je smrt. ");
INSERT INTO cesnkb_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Vždyť “všechno poddal pod jeho nohy.” Když však říká, že je mu všechno poddáno, je zřejmé, že je to kromě Toho, který mu to všechno poddal. ");
INSERT INTO cesnkb_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","A až mu bude všechno poddáno, pak se i sám Syn poddá Tomu, který mu všechno poddal, aby Bůh byl všechno ve všem. ");
INSERT INTO cesnkb_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Co potom budou dělat ti, kteří se nechávají křtít za mrtvé? Jestliže mrtví vůbec nejsou kříšeni, proč se tedy křtí za mrtvé? ");
INSERT INTO cesnkb_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Proč i my každou hodinu podstupujeme nebezpečí? ");
INSERT INTO cesnkb_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Při chloubě, kterou mám ve vás v Kristu Ježíši, našem Pánu, prohlašuji, že denně umírám. ");
INSERT INTO cesnkb_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Jestliže jsem v Efezu bojoval se šelmami podle člověka, co mi to prospěje, jestliže mrtví nevstávají? “Jezme a pijme, neboť zítra zemřeme!” ");
INSERT INTO cesnkb_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Nemylte se: “Špatné vztahy kazí dobré mravy.” ");
INSERT INTO cesnkb_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Opravdově procitněte a nehřešte. Někteří totiž neznají Boha - říkám to k vašemu zahanbení. ");
INSERT INTO cesnkb_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Někdo ale řekne: “Jak budou mrtví vzkříšeni? A v jakém přijdou těle?” ");
INSERT INTO cesnkb_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","\" nemoudrý! To, co ty rozsíváš, nebude obživeno, pokud to nezemře. ");
INSERT INTO cesnkb_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","A co rozsíváš? Ne to tělo, které povstane, ale holé zrno - možná zrno pšenice nebo nějaké jiné. ");
INSERT INTO cesnkb_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Bůh mu však dává tělo, jak sám chtěl, totiž každému z těch semen jeho vlastní tělo. ");
INSERT INTO cesnkb_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Každé tělo není stejné, ale jiné je tělo lidské, jiné tělo zvířecí, jiné zase rybí a jiné ptačí. ");
INSERT INTO cesnkb_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Jsou také těla nebeská a těla pozemská; ale jiná je sláva nebeských a jiná pozemských. ");
INSERT INTO cesnkb_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Jiná je sláva slunce, jiná sláva měsíce a jiná sláva hvězd, neboť hvězda od hvězdy se liší ve slávě. ");
INSERT INTO cesnkb_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","A tak je to také se zmrtvýchvstáním. Rozsívá se v pomíjivosti, křísí se v nepomíjivosti. ");
INSERT INTO cesnkb_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Rozsívá se v hanbě, křísí se ve slávě; rozsívá se ve slabosti, křísí se v moci. ");
INSERT INTO cesnkb_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Rozsívá se tělo tělesné, křísí se tělo duchovní. Je tělesné tělo, je i tělo duchovní. ");
INSERT INTO cesnkb_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","(Tak je to i napsáno: “První člověk, Adam, se stal živou duší.” Poslední Adam se stal obživujícím duchem.) ");
INSERT INTO cesnkb_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Nejdříve však není to duchovní, ale to tělesné, a potom to duchovní. ");
INSERT INTO cesnkb_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","První člověk byl ze země, z prachu, druhý člověk je sám Pán z nebe. ");
INSERT INTO cesnkb_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Jaký byl ten z prachu, takoví jsou i ti, kdo jsou z prachu; a jaký ten nebeský, takoví i nebeští. ");
INSERT INTO cesnkb_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","A jako jsme nesli obraz toho, který byl z prachu, tak poneseme i obraz toho nebeského. ");
INSERT INTO cesnkb_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Říkám vám, bratři, toto: tělo a krev nemohou být dědici Božího království a pomíjivost nezdědí nepomíjivost. ");
INSERT INTO cesnkb_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Hle, říkám vám tajemství: ne všichni zemřeme, ale všichni budeme proměněni - ");
INSERT INTO cesnkb_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","naráz, v okamžiku, za zvuku poslední polnice. Neboť zatroubí a mrtví budou vzkříšeni jako nesmrtelní a my budeme proměněni. ");
INSERT INTO cesnkb_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Toto pomíjivé totiž musí obléci nepomíjivost a toto smrtelné musí obléci nesmrtelnost. ");
INSERT INTO cesnkb_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","A když toto pomíjivé oblékne nepomíjivost a toto smrtelné oblékne nesmrtelnost, tehdy se uskuteční to slovo, které bylo napsáno: “Smrt byla pohlcena ve vítězství.” ");
INSERT INTO cesnkb_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","“Kde je, ó smrti, tvůj osten? Kde je, ó peklo, tvé vítězství?” ");
INSERT INTO cesnkb_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Ostnem smrti je pak hřích a mocí hříchu Zákon. ");
INSERT INTO cesnkb_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Ale díky Bohu, který nám dává vítězství skrze našeho Pána Ježíše Krista! ");
INSERT INTO cesnkb_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Proto, moji milovaní bratři, buďte pevní a nepohnutelní, stále se rozhojňujte v Pánově díle a vězte, že vaše práce není v Pánu marná. ");
INSERT INTO cesnkb_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","A ohledně sbírky na svaté, čiňte i vy tak, jak jsem nařídil galatským církvím: ");
INSERT INTO cesnkb_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Vždy prvního dne v týdnu ať každý z vás sám u sebe uloží, kolik se mu podaří nastřádat, aby se sbírky nekonaly teprve tehdy, když přijdu. ");
INSERT INTO cesnkb_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","A až přijdu, pošlu s doporučujícími listy ty, které schválíte, aby váš dar odnesli do Jeruzaléma. ");
INSERT INTO cesnkb_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Jestliže pak bude vhodné, abych šel i já, půjdou se mnou. ");
INSERT INTO cesnkb_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Až tedy projdu Makedonii, přijdu k vám (procházím totiž Makedonii). ");
INSERT INTO cesnkb_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","A u vás snad pobudu, anebo i strávím zimu, abyste mě mohli vypravit na cestu, kamkoli půjdu. ");
INSERT INTO cesnkb_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Nechci vás totiž vidět teď při cestě, neboť doufám, že u vás nějaký čas zůstanu, dovolí-li Pán. ");
INSERT INTO cesnkb_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Až do Letnic však zůstanu v Efezu, ");
INSERT INTO cesnkb_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","neboť mi jsou otevřeny veliké a mocné dveře a protivníků je mnoho. ");
INSERT INTO cesnkb_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Kdyby pak přišel Timoteus, hleďte, aby byl u vás beze strachu, neboť koná Pánovo dílo jako i já. ");
INSERT INTO cesnkb_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Ať jím tedy nikdo nepohrdá, ale vypravte ho v pokoji, aby mohl přijít ke mně, neboť na něj s bratry čekám. ");
INSERT INTO cesnkb_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","A ohledně bratra Apolla - velice jsem ho prosil, aby k vám s bratry přišel, ale vůbec zde nebyla vůle, aby přišel teď; přijde však, až bude příhodný čas. ");
INSERT INTO cesnkb_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Bděte, stůjte ve víře, počínejste si zmužile, buďte silní. ");
INSERT INTO cesnkb_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Všechny vaše věci ať se dějí v lásce. ");
INSERT INTO cesnkb_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","A prosím vás, bratři - víte, že Štěpánův dům je prvotinou Acháje a že se vydali službě svatým - ");
INSERT INTO cesnkb_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","abyste se i vy poddávali takovým i každému, kdo pomáhá a pracuje. ");
INSERT INTO cesnkb_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Raduji se však z příchodu Štěpána, Fortunáta a Achaika, protože doplnili, čeho se mi nedostávalo od vás. ");
INSERT INTO cesnkb_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Občerstvili totiž mého i vašeho ducha. Uznávejte tedy takové. ");
INSERT INTO cesnkb_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Pozdravují vás sbory v Asii. Velmi vás v Pánu pozdravuje Akvila a Priscilla s církví, která je v jejich domě. ");
INSERT INTO cesnkb_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Pozdravují vás všichni bratři. Pozdravte se navzájem svatým polibkem. ");
INSERT INTO cesnkb_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Pozdrav mou, Pavlovou rukou. ");
INSERT INTO cesnkb_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Nemá-li někdo rád Pána Ježíše Krista, ať je proklet. Maranatha! ");
INSERT INTO cesnkb_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Milost Pána Ježíše Krista s vámi. ");
INSERT INTO cesnkb_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Má láska je s vámi všemi v Kristu Ježíši. Amen. ");
INSERT INTO cesnkb_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Pavel, podle Boží vůle apoštol Ježíše Krista, a bratr Timoteus církvi Boží, která je v Korintu, se všemi svatými, kteří jsou v celé Acháji: ");
INSERT INTO cesnkb_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Milost vám a pokoj od Boha, našeho Otce, a od Pána Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Požehnaný Bůh a Otec našeho Pána Ježíše Krista, Otec milosrdenství a Bůh veškerého potěšení, ");
INSERT INTO cesnkb_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","který nás potěšuje v každém našem soužení, abychom mohli potěšovat ty, kteří jsou v jakémkoli soužení, tím potěšením, kterým jsme sami potěšeni od Boha. ");
INSERT INTO cesnkb_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Jak se totiž při nás rozhojňují Kristova utrpení, tak se skrze Krista rozhojňuje také naše potěšení. ");
INSERT INTO cesnkb_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Ať už tedy jsme souženi - je to pro vaše potěšení a spasení, které se projevuje ve snášení stejných utrpení, která trpíme i my; nebo jsme potěšováni - je to pro vaše potěšení a spasení. ");
INSERT INTO cesnkb_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","A naše naděje o vás je pevná, neboť víme, že jak jste účastníky utrpení, tak i potěšení. ");
INSERT INTO cesnkb_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Bratři, nechceme, abyste nevěděli o našem soužení, které na nás přišlo v Asii - že jsme byli nadmíru přetíženi, nad naše síly, takže jsme ztratili i naději na život. ");
INSERT INTO cesnkb_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Měli jsme sami v sobě dokonce rozsudek smrti, abychom nespoléhali sami na sebe, ale na Boha, který křísí mrtvé, ");
INSERT INTO cesnkb_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","který nás z takové smrti vysvobodil a vysvobozuje, v něhož doufáme, že nás i nadále bude vysvobozovat, ");
INSERT INTO cesnkb_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","když nám i vy budete společně pomáhat modlitbou za nás, aby za nás mnoho lidí mohlo děkovat pro dar, který nám byl dán kvůli mnohým. ");
INSERT INTO cesnkb_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Neboť naše chlouba je tato: svědectví našeho svědomí, že jsme si na světě - a obzvláště u vás - počínali v prostotě a upřímnosti Boží, ne v tělesné moudrosti, ale v Boží milosti. ");
INSERT INTO cesnkb_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Nepíšeme vám přece nic jiného, než co čtete a čemu také rozumíte. Doufám pak, že budete rozumět až do konce, ");
INSERT INTO cesnkb_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","jako jste zčásti porozuměli i nám, že jsme vaše chlouba, tak jako i vy naše, v den Pána Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","V této důvěře jsem k vám dříve zamýšlel přijít, abyste měli druhou milost, ");
INSERT INTO cesnkb_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","a přes vás jít do Makedonie a z Makedonie zase přijít k vám, a od vás být vypraven do Judska. ");
INSERT INTO cesnkb_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Když jsem tedy takto uvažoval, jednal jsem snad lehkomyslně? Anebo snad to, co zamýšlím, zamýšlím podle těla, aby při mně bylo “ano, ano” i “ne, ne”? ");
INSERT INTO cesnkb_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Věrný Bůh ví, že naše řeč k vám nebyla “ano a ne”. ");
INSERT INTO cesnkb_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Vždyť Boží Syn Ježíš Kristus, kterého jsme mezi vámi kázali - já, Silvanus a Timoteus - nebyl “ano a ne”, ale bylo v něm “ano”. ");
INSERT INTO cesnkb_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Neboť všechna Boží zaslíbení jsou v něm “ano” a skrze něj “amen”, k slávě Bohu skrze nás. ");
INSERT INTO cesnkb_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Ten, kdo nás s vámi utvrzuje v Kristu a pomazal nás, je Bůh, ");
INSERT INTO cesnkb_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","který nás také označil a dal do našich srdcí záruku Ducha. ");
INSERT INTO cesnkb_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","Já pak volám Boha za svědka na svou duši, že jsem ještě nepřišel do Korintu proto, že vás šetřím. ");
INSERT INTO cesnkb_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Ne že panujeme nad vaší vírou, ale jsme pomocníky vaší radosti; vždyť vírou stojíte. ");
INSERT INTO cesnkb_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Rozhodl jsem se však pro toto: že k vám znovu nepřijdu se zármutkem. ");
INSERT INTO cesnkb_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Vždyť jestliže vás já zarmoutím, kdo by mě pak mohl rozveselit? Jedině ten, kdo je mnou zarmoucen. ");
INSERT INTO cesnkb_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","A toto vám píši, abych až přijdu, neměl zármutek kvůli těm, z nichž bych se měl radovat; jsem o vás všech přesvědčen, že má radost je radostí vás všech. ");
INSERT INTO cesnkb_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Píši vám totiž z velikého soužení a úzkosti srdce, s mnoha slzami, ne abyste byli zarmouceni, ale abyste poznali lásku, kterou k vám oplývám. ");
INSERT INTO cesnkb_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Jestliže však někdo zarmoutil, nezarmoutil mne, ale zčásti (abych nepřeháněl) vás všechny. ");
INSERT INTO cesnkb_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Takovému stačí trest, jehož se mu dostalo od mnohých, ");
INSERT INTO cesnkb_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","takže mu již raději naopak odpusťte a potěšte ho, aby snad nebyl pohlcen přílišným zármutkem. ");
INSERT INTO cesnkb_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Proto vás prosím, potvrďte mu svou lásku. ");
INSERT INTO cesnkb_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Psal jsem vám totiž také proto, abych poznal vaši spolehlivost, zda jste ve všem poslušni. ");
INSERT INTO cesnkb_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Komu pak vy něco odpouštíte, odpouštím i já. Vždyť i já, jestliže jsem komu co odpustil, odpustil jsem kvůli vám před Kristovou tváří, ");
INSERT INTO cesnkb_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","abychom nebyli oklamáni Satanem. Jeho úmysly nám přece nejsou neznámé. ");
INSERT INTO cesnkb_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Když jsem pak kvůli Kristovu evangeliu přišel do Troady, ačkoli mi v Pánu byly otevřeny dveře, ");
INSERT INTO cesnkb_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","neměl jsem ve svém duchu úlevu, protože jsem nenalezl svého bratra Tita, a tak jsem se s nimi rozloučil a vydal se do Makedonie. ");
INSERT INTO cesnkb_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Avšak díky Bohu, který nám vždycky dává vítězství v Kristu a na každém místě skrze nás zjevuje vůni svého poznání. ");
INSERT INTO cesnkb_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Jsme totiž Bohu Kristovou líbeznou vůní mezi těmi, kteří jsou zachraňováni, i mezi těmi, kteří hynou: ");
INSERT INTO cesnkb_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","některým jsme ovšem smrtelnou vůní k smrti, jiným pak vůní života k životu. Kdo je však k tomu způsobilý? ");
INSERT INTO cesnkb_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","Nejsme totiž jako mnozí, kteří kupčí s Božím slovem, ale jakožto z upřímnosti, jakožto z Boha, mluvíme před Boží tváří o Kristu. ");
INSERT INTO cesnkb_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Začínáme zase doporučovat sami sebe? Cožpak potřebujeme, jako někteří, doporučující listy k vám nebo od vás? ");
INSERT INTO cesnkb_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Vy jste náš list zapsaný v našich srdcích, list, který znají a čtou všichni lidé. ");
INSERT INTO cesnkb_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Je přece zjevné, že jste list Kristův zhotovený naší službou, napsaný ne inkoustem, ale Duchem živého Boha, ne na kamenných deskách, ale na masitých deskách srdce. ");
INSERT INTO cesnkb_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","A takovouto důvěru máme skrze Krista k Bohu: ");
INSERT INTO cesnkb_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Ne že jsme sami o sobě způsobilí, abychom si něco mysleli sami o sobě, ale naše způsobilost je z Boha, ");
INSERT INTO cesnkb_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","který nás také učinil způsobilými služebníky nové smlouvy, ne litery, ale Ducha; neboť litera zabíjí, ale Duch obživuje. ");
INSERT INTO cesnkb_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Jestliže pak služba smrti, literami vyrytá do kamenů, byla slavná, takže synové Izraele nemohli pohledět do Mojžíšovy tváře kvůli slávě jeho obličeje, která byla pomíjející, ");
INSERT INTO cesnkb_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","jak by tím spíše neměla být slavná služba Ducha? ");
INSERT INTO cesnkb_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Jestliže totiž služba odsouzení měla slávu, služba spravedlnosti se ve slávě rozhojňuje mnohem více! ");
INSERT INTO cesnkb_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Vždyť vzhledem k té nesmírné slávě ani to, co bylo oslaveno, v tomto ohledu oslaveno není. ");
INSERT INTO cesnkb_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Jestliže totiž to pomíjející přišlo skrze slávu, mnohem spíše je ve slávě to, co zůstává. ");
INSERT INTO cesnkb_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Jelikož tedy máme takovouto naději, mluvíme tak otevřeně, ");
INSERT INTO cesnkb_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","a ne jako Mojžíš, který kladl na svou tvář roušku, aby synové Izraele nehleděli k cíli toho, co mělo pominout. ");
INSERT INTO cesnkb_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","Jejich mysli se však zatvrdily. Až do dnešního dne totiž zůstává při čtení Staré smlouvy tatáž rouška neodkrytá, neboť se odnímá jen v Kristu. ");
INSERT INTO cesnkb_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Když tedy bývá čten Mojžíš, na jejich srdci leží až do dnešního dne rouška. ");
INSERT INTO cesnkb_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Jakmile se však člověk obrátí k Pánu, je ta rouška odstraněna. ");
INSERT INTO cesnkb_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Ten Pán je Duch, a kde je Pánův Duch, tam je svoboda. ");
INSERT INTO cesnkb_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","My všichni se pak s odkrytou tváří zhlížíme v Pánově slávě jako v zrcadle a jsme proměňováni v tentýž obraz, od slávy k slávě, jako od Pánova Ducha. ");
INSERT INTO cesnkb_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Poněvadž tedy máme tuto službu podle milosrdenství, které jsme přijali, nepolevujeme. ");
INSERT INTO cesnkb_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Zřekli jsme se skrytých hanebností, nechodíme v chytráctví, ani nezacházíme s Božím slovem podvodně, ale zjevováním pravdy se v Božích očích osvědčujeme před každým lidským svědomím. ");
INSERT INTO cesnkb_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Jestliže je pak naše evangelium zakryté, je zakryté těm, kteří hynou, ");
INSERT INTO cesnkb_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","nevěřícím, jimž bůh tohoto světa oslepil mysli, aby jim nezazářilo světlo evangelia o slávě Krista, který je obrazem Božím. ");
INSERT INTO cesnkb_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Neboť nekážeme sami sebe, ale Ježíše Krista jako Pána, a sebe jako vaše služebníky pro Ježíše. ");
INSERT INTO cesnkb_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Vždyť ten Bůh, který řekl, aby ze tmy zazářilo světlo, ten zazářil v našich srdcích, aby osvítil poznání Boží slávy ve tváři Ježíše Krista. ");
INSERT INTO cesnkb_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Tento poklad však máme v hliněných nádobách, aby nesmírnost té moci byla Boží a ne z nás: ");
INSERT INTO cesnkb_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ze všech stran býváme souženi, ale ne zcela sevřeni; býváme bezradní, ale ne zoufalí; ");
INSERT INTO cesnkb_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","býváme pronásledováni, ale ne opuštěni; sráženi, ale ne zničeni. ");
INSERT INTO cesnkb_vpl VALUES ("C24_10","077_4_10","2CO","