﻿USE sofia;
DROP TABLE IF EXISTS sofia.ceslb_vpl;
CREATE TABLE ceslb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ceslb_vpl WRITE;
INSERT INTO ceslb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ježíšův rodokmen sahá přes Davida až k Abrahamovi. ");
INSERT INTO ceslb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham – Izák Izák – Jákob ");
INSERT INTO ceslb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jákob – Juda (a bratři) Juda – Peres a Zerach (matka Támar) Peres – Chesrón Chesrón – Rám ");
INSERT INTO ceslb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rám – Amínadab Amínadab – Nachšón Nachšón – Salmón ");
INSERT INTO ceslb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón – Bóaz (matka: Rachab) Bóaz – Obéd (matka: Rút) Obéd – Jišaj ");
INSERT INTO ceslb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jišaj – David (král) David – Šalomoun (matka: Batšeba). ");
INSERT INTO ceslb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Šalomoun – Rechabeám Rechabeám – Abijám Abijám – Ása ");
INSERT INTO ceslb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ása – Jóšafat Jóšafat – Jóram Jóram – Uzijáš ");
INSERT INTO ceslb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzijáš – Jótam Jótam – Achaz Achaz – Chizkijáš ");
INSERT INTO ceslb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Chizkijáš – Menaše Menaše – Ámon Ámon – Jóšijáš ");
INSERT INTO ceslb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jóšijáš – Jechoniáš ");
INSERT INTO ceslb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jekonjáš a jeho bratři. Babylónské zajetí – Jekonjáš – Šealtíel Šealtíel – Zerubábel ");
INSERT INTO ceslb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubábel – Abiud Abiud – Eljakim Eljakim – Azór ");
INSERT INTO ceslb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azór – Sádok Sádok – Achim Achim – Eliud ");
INSERT INTO ceslb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud – Eleazar Eleazar – Mattan Mattan – Jákob ");
INSERT INTO ceslb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jákob – Josef Josef (muž Marie) JEŽÍŠ KRISTUS (narozen z Marie). Rodokmen uzavírá Josef, manžel Marie, které se narodil Ježíš – Boží Syn. ");
INSERT INTO ceslb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Od praotce Abrahama k Davidovi je to čtrnáct generací, dále čtrnáct generací od Davida po babylónské zajetí a od zajetí v Babylóně až ke Kristu také čtrnáct. ");
INSERT INTO ceslb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","S narozením Ježíše Krista to bylo takto: Ježíšova matka Marie byla zasnoubena s Josefem. Dříve, než se vzali, se však ukázalo, že bude matkou. ");
INSERT INTO ceslb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josef byl ohleduplný muž a nechtěl Marii vystavit veřejné hanbě, proto se rozhodl, že se s ní rozejde. ");
INSERT INTO ceslb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Když o tom uvažoval, ukázal se mu ve snu Boží posel a řekl: „Josefe, Davidův synu, neboj se vzít si Marii. Co v ní bylo počato, je z Ducha svatého. ");
INSERT INTO ceslb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Porodí syna a dáš mu jméno Ježíš. On vysvobodí svůj lid z moci zla. ");
INSERT INTO ceslb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Těmito událostmi se splní předpověď proroka Izajáše: ");
INSERT INTO ceslb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‚Slyšte! Panna bude těhotná a porodí syna. Budete mu říkat Immanuel, to znamená: Bůh je s námi.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Když se Josef probudil, udělal vše tak, jak mu přikázal Boží posel, a oženil se s Marií. ");
INSERT INTO ceslb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ale nežil s ní manželsky až do doby, kdy se jí narodil syn, kterému dal jméno Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ježíš se narodil v Betlémě v Judsku za vlády krále Heroda. V té době přijeli do Jeruzaléma učenci z východní země a vyptávali se: ");
INSERT INTO ceslb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","„Kde je ten židovský král, který se právě narodil? Viděli jsme na východě jeho hvězdu a přišli jsme se mu poklonit.“ ");
INSERT INTO ceslb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tato novina velmi znepokojila krále Heroda, a nejen jeho, ale i všechny obyvatele Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Král svolal všechny přední kněze a učitele zákona a ptal se jich, kde se má narodit Kristus. ");
INSERT INTO ceslb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Oni mu odpověděli: „V Betlémě v Judsku. Prorok to předpověděl: ");
INSERT INTO ceslb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‚Betléme, nejsi poslední v Judsku, z tebe vyjde vévoda, který se bude starat o můj lid jako pastýř o ovce.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes si učence z východu tajně pozval a podrobně se jich vyptával, kdy se ta hvězda objevila. Poslal je do Betléma a pověřil je úkolem: ");
INSERT INTO ceslb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","„Jděte a důkladně zjistěte vše o tom dítěti, a až je najdete, přijďte mi to oznámit; půjdu se mu také poklonit.“ ");
INSERT INTO ceslb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Učenci krále vyslechli a vydali se na cestu. A hle! Hvězda, kterou viděli na východě, jim ukazovala cestu až k místu, kde bylo dítě. ");
INSERT INTO ceslb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Měli z toho nevýslovnou radost. ");
INSERT INTO ceslb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Vešli do domu a našli tam dítě s jeho matkou Marií. Padli před ním na kolena, klaněli se mu a dali mu vzácné dary – zlato, kadidlo a drahocenný olej. ");
INSERT INTO ceslb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ve snu je však Bůh varoval, aby se nevraceli k Herodovi. Zvolili tedy jinou zpáteční cestu. ");
INSERT INTO ceslb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Po odchodu učenců měl Josef sen, ve kterém mu anděl přikázal: „Vstaň, vezmi dítě a jeho matku a uteč s nimi do Egypta; tam zůstaň, dokud ti neřeknu. Herodes bude totiž pátrat po dítěti, aby je připravil o život.“ ");
INSERT INTO ceslb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josef hned v noci vstal, vzal dítě i matku a vydal se s nimi do Egypta. ");
INSERT INTO ceslb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tam byli až do smrti krále Heroda. Splnila se tím Boží předpověď vyslovená prorokem: „Z Egypta jsem povolal svého syna.“ ");
INSERT INTO ceslb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Když Herodes poznal, že ho východní učenci zklamali, velmi se rozhněval a dal pobít v Betlémě a okolí všechny chlapce do stáří dvou let. Tento věk odhadl podle výpovědi učenců. ");
INSERT INTO ceslb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tehdy se vyplnilo Jeremjášovo proroctví: ");
INSERT INTO ceslb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","„Slyším nářek, pláč a bědování. To matka oplakává své syny a nedá se utěšit, protože jsou mrtví.“ ");
INSERT INTO ceslb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Když Herodes zemřel, znovu se ukázal Josefovi ve snu anděl ");
INSERT INTO ceslb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a vybídl ho: „Vezmi dítě i jeho matku a vrať se do izraelské země, protože už zemřeli ti, kteří usilovali o život dítěte.“ ");
INSERT INTO ceslb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josef poslechl a vrátili se. ");
INSERT INTO ceslb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Velmi se však zalekl, když se dověděl, že Herodovým nástupcem v Judsku je jeho syn Archelaos. Ve snu dostal od Boha další pokyn, aby šel do Galileje. ");
INSERT INTO ceslb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Usídlil se v Nazaretu a tím se splnila další proroctví o Mesiáši, že totiž bude nazýván Nazaretský. ");
INSERT INTO ceslb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","V té době vystoupil Jan Křtitel a kázal lidem, kteří za ním přicházeli na Judskou poušť: ");
INSERT INTO ceslb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","„Obraťte se od svých hříchů k Bohu, protože přichází jeho vyvolený král.“ ");
INSERT INTO ceslb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","O Janovi prorok Izajáš předpověděl: „Z pouště zazní hlas: Připravte cestu pro Pána a odstraňte všechny překážky.“ ");
INSERT INTO ceslb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan měl oděv z velbloudí srsti přepásaný koženým pásem. Živil se tím, co poskytovala poušť: kobylkami a medem divokých včel. ");
INSERT INTO ceslb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Scházeli se k němu lidé z Jeruzaléma, z celého Judska a ze Zajordání. ");
INSERT INTO ceslb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dávali se od něho křtít v řece Jordánu, aby tím veřejně vyznávali svá provinění. ");
INSERT INTO ceslb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Když Jan uviděl, že ke křtu přicházejí mnozí horliví a nejvznešenější Židé – farizejové a saducejové, řekl jim: „Myslíte si, že se z Božího soudu vykroutíte jako hadi? ");
INSERT INTO ceslb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dokažte změnou svého života, že jste se obrátili od svých vin. ");
INSERT INTO ceslb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nemyslete si, že vám pomůže, budete-li říkat: ‚Jsme potomci Abrahamovi, Boží vyvolený národ.‘ Vždyť Bůh si může proměnit i ty, se kterými vy pohrdáte. ");
INSERT INTO ceslb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sekera Božího soudu je už přiložena ke kořeni stromu. Každý člověk, který nežije novým životem, je jako strom, který nenese dobré ovoce; bude poražen a spálen. ");
INSERT INTO ceslb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Já křtím vodou ty, kteří cítí svá provinění jako břemeno a vyznávají je. Avšak po mně přijde někdo daleko mocnější než já; nejsem hoden ani toho, abych mu vyčistil obuv. On vás bude křtít Duchem svatým a ohněm. ");
INSERT INTO ceslb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jako se prohazováním odděluje zrno od plev – zrno do sýpky, plevy na oheň, tak i on rozsoudí lidi – jedny k životu a druhé ke smrti.“ ");
INSERT INTO ceslb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tehdy přišel Ježíš z Galileje k Jordánu, aby se dal od Jana pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ten se velmi zdráhal: „Já bych měl být pokřtěn od tebe a ty jdeš ke mně.“ ");
INSERT INTO ceslb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ježíš mu odpověděl: „Jen to, prosím, udělej. Musíme splnit Boží vůli.“ A tak ho Jan pokřtil. ");
INSERT INTO ceslb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Když Ježíš vystoupil z vody, uviděl, jak se na něj z nebe snáší Boží Duch v podobě holubice. ");
INSERT INTO ceslb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Současně se ozval hlas: „Toto je ten můj milovaný Syn, moje radost.“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","2","Potom Duch Boží vedl Ježíše na poušť, kde se po dobu čtyřiceti dnů a nocí postil a velmi vyhladověl. ");
INSERT INTO ceslb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tu se k němu přiblížil pokušitel a řekl mu: „Jsi-li Boží Syn, proměň toto kamení v chleby!“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ježíš mu odpověděl: „V Písmu je napsáno: Člověk se nenasytí jen chlebem, ale hlad ve své duši utiší přijetím Božího slova.“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pak ho ďábel vzal do Jeruzaléma na věž chrámu ");
INSERT INTO ceslb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a řekl: „Jsi-li Boží Syn, seskoč dolů! Vždyť je psáno, že Bůh přikáže svým andělům, aby tě zachytili na svých rukou dříve, než dopadneš na kámen.“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ježíš mu zase pohotově odpověděl: „Je však také psáno: Nepokoušej Boha, je tvůj Pán.“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nakonec ho ďábel postavil na vysokou horu a ukázal mu všechna království světa s jejich okázalostí a bohatstvím. ");
INSERT INTO ceslb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tam mu řekl: „Toto všechno ti dám, jestliže přede mnou klekneš a pokloníš se mi!“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ježíš odpověděl: „Odejdi, satane! Vždyť je psáno: Nikomu kromě Boha se nebudeš klanět ani ho uctívat.“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","V tu chvíli ho ďábel opustil; Ježíše obklopili andělé a pečovali o něj. ");
INSERT INTO ceslb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Když Ježíš uslyšel, že Jana uvěznili, vrátil se do Galileje. ");
INSERT INTO ceslb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nezůstal však v Nazaretu, ale usadil se v Kafarnaum. To město leželo u jezera Genezaretského, v oblasti, kterou kdysi obývaly izraelské kmeny Zabulónovy a Neftalího. ");
INSERT INTO ceslb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tím se splnila předpověď proroka Izajáše: ");
INSERT INTO ceslb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","„V Galileji, zemi Zabulónově a Neftalího, mezi mořem a Jordánem, se usídlili pohané. ");
INSERT INTO ceslb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tento lid pohroužený do temnoty uvidí veliké světlo. Těm, nad kterými se rozprostírá noc smrti, se rozední.“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","V té době začal Ježíš kázat: „Změňte se! Bůh je tu a zakládá na zemi svoje království!“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ježíš šel po břehu Galilejského jezera a uviděl dva muže, jak spouštějí sítě do vody. Byli to rybáři Šimon, později nazývaný Petr, a jeho bratr Ondřej. ");
INSERT INTO ceslb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ježíš na ně volal: „Přátelé, pojďte se mnou! Udělám z vás jiné rybáře, budete zachraňovat lidi!“ ");
INSERT INTO ceslb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ti dva všeho nechali a šli s ním. ");
INSERT INTO ceslb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O kus dál jiní dva bratři, Jakub a Jan, seděli spolu se svým otcem Zebedeem ve člunu a spravovali sítě. Také je Ježíš vyzval; ");
INSERT INTO ceslb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","oba se okamžitě zvedli, opustili otce a vykročili za ním. ");
INSERT INTO ceslb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ježíš chodil po celé Galileji, vyučoval v synagogách, šířil radostnou zvěst o Božím království a uzdravoval lidi postižené všemi možnými nemocemi. ");
INSERT INTO ceslb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Zprávy o něm se rychle roznesly, takže až ze Sýrie k němu vodili nemocné, posedlé démony, duševně choré, ochrnuté a on je uzdravoval. ");
INSERT INTO ceslb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Všude se za ním táhly davy lidí; nejen z Galileje, ale i z Desítiměstí, Jeruzaléma, Judska a Zajordání. ");
INSERT INTO ceslb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Když Ježíš uviděl zástupy lidí, vystoupil se svými učedníky na návrší, posadil se v jejich středu ");
INSERT INTO ceslb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","a učil je: ");
INSERT INTO ceslb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","„Kteří lidé jsou skutečně šťastni? Šťastni jsou pokorní, nenamyšlení, vždyť těm patří Boží království. ");
INSERT INTO ceslb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Šťastni jsou ti, kteří pláčou v zármutku, vždyť Bůh je potěší. ");
INSERT INTO ceslb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Šťastni jsou ti, kteří pro sebe nic nevymáhají, vždyť jim Bůh dá celou zemi. ");
INSERT INTO ceslb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Šťastni jsou ti, kteří touží po tom, co je správné, jako žízniví po vodě, vždyť jejich žízeň bude utišena. ");
INSERT INTO ceslb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Šťastni jsou milosrdní, vždyť Bůh k nim bude také milosrdný. ");
INSERT INTO ceslb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Šťastni jsou ti, kteří si zachovali čistý pohled naživot, vždyť oni uvidí Boha. ");
INSERT INTO ceslb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Šťastni jsou ti, kteří působí pokoj, vždyť k těm se Bůh bude hlásit jako ke svým dětem. ");
INSERT INTO ceslb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Šťastni jsou ti, kteří mají těžkosti proto, že poslouchají Boha; jim se otevírá Boží svět. ");
INSERT INTO ceslb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Šťastni jste, když vámi kvůli mně pohrdají, pronásledují vás a vymýšlejí si na vás pomluvy. ");
INSERT INTO ceslb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Máte důvod k radosti a dokonce i k veselí, neboť co vás čeká v nebi, mnohonásobně převýší vaše utrpení. Ostatně takhle zacházeli s Božími lidmi vždycky. ");
INSERT INTO ceslb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Vy jste sůl země. Když už sůl by měla ztratit svoji chuť, čím se bude solit? Sůl bez chuti se nehodí k ničemu a může být jen vyhozena a zašlapána. ");
INSERT INTO ceslb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Vy jste světlo světa. Město postavené na hoře je odevšad vidět. ");
INSERT INTO ceslb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Také svíčku nerozsvěcujete proto, abyste ji schovali, ale stavíte ji na svícen, aby svítila každému v domě. ");
INSERT INTO ceslb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tak ať svítí vaše světlo všem lidem; ať za vašimi dobrými činy vidí Boha a jeho chválí. ");
INSERT INTO ceslb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nemyslete si, že jsem přišel proto, abych zrušil, co bylo přikázáno a předpověděno ve Starém zákoně. Naopak, přišel jsem, abych to všechno uskutečnil a dovršil. ");
INSERT INTO ceslb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ujišťuji vás, že dokud trvá nebe a země, ani písmenko nebo čárka z toho, co Bůh přikázal, neztratí svou platnost, dokud se nenaplní. ");
INSERT INTO ceslb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","A proto každý, kdo by nebral vážně i to nejmenší přikázání a vedl by tak lidi, bude poslední v Božím království. Ale ten, kdo se Božími příkazy řídí a učí tak druhé, bude velký v nebeském království. ");
INSERT INTO ceslb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pamatujte si: chcete-li vejít do nebeského království, musí vám jít o víc než jen o formální plnění příkazů a zákazů, jako to činí učitelé zákona a farizejové. ");
INSERT INTO ceslb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","V Desateru stojí psáno: Nezabiješ. Proto kdo zabil, musí před soud. ");
INSERT INTO ceslb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ale já vám říkám, že bude souzen každý, kdo se hněvá na svého bližního. Pohrdání člověkem je zločin, a kdo svolává na druhého Boží trest, sám mu propadne. ");
INSERT INTO ceslb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dáváš-li do pořádku svůj vztah k Bohu a uvědomíš si, že máš s někým nesrovnalost, ");
INSERT INTO ceslb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","26","odstraň ji a smiř se s ním. Teprve potom předstup před Boha. Nejsi-li ochoten ke smíru s druhým člověkem, bude na tebe žalovat tvůj hněv před Bohem a neunikneš odsouzení. Je to tak, jako když tě věřitel vede k soudci. Nedomluvíš-li se s ním cestou, půjdeš do vězení a celý dluh si odpykáš. ");
INSERT INTO ceslb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Znáte další přikázání Desatera: Nebudeš cizoložit. ");
INSERT INTO ceslb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Já vám však říkám, kdo by se podíval žádostivě na jinou ženu, porušil manželství, byť jenom v myšlenkách. ");
INSERT INTO ceslb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Učiň všechno pro to, aby k tobě pokušení nepronikalo. Neboj se zříci se něčeho, co se ti dnes zdá pro tvůj život tak nepostradatelné jako oko nebo pravá ruka. Lépe je žít s jedním okem nebo jednou rukou než ztratit věčný život. ");
INSERT INTO ceslb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mojžíšův zákon připouští, aby se muž se ženou rozvedl, musí jí to však dát písemně. ");
INSERT INTO ceslb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Já však říkám, že kdo se rozvádí se svojí ženou, aniž mu byla nevěrná, sám ji uvádí do nevěry. Kdo se ožení s takovou ženou, cizoloží. ");
INSERT INTO ceslb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","A další přikázání: Nepřísahej křivě, ale splň své přísahy jako dané Pánu Bohu! ");
INSERT INTO ceslb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Já vám však říkám: Nepřísahejte vůbec; neberte si za svědka nebe, protože je Božím trůnem; ");
INSERT INTO ceslb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nedovolávejte se ničeho na zemi, protože je jeho podnoží. Nepřísahejte ani při posvátném Jeruzalému, protože je městem velikého Krále. ");
INSERT INTO ceslb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nepřísahejte ani při své hlavě, protože není ve vaší moci, aby vám rostly bílé nebo černé vlasy. ");
INSERT INTO ceslb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Říkejte prostě ano, nebo ne. To stačí. Když zdůrazňujete svoje slova přísahou, dokazujete, že nemluvíte vždycky pravdu a každá lež pochází od zlého. ");
INSERT INTO ceslb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Je také psáno: Oko za oko, zub za zub. ");
INSERT INTO ceslb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Já vám říkám, abyste neodpláceli zlým za zlé. Naopak, uhodí-li tě někdo přes pravou tvář, nastav mu i levou. ");
INSERT INTO ceslb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A když by se s tebou chtěl někdo soudit a vzít ti šaty, dej mu i kabát; ");
INSERT INTO ceslb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","jestliže tě někdo nutí, abys s ním šel kus cesty, jdi s ním dvakrát tak daleko. ");
INSERT INTO ceslb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dej tomu, kdo tě prosí, a neodmítej toho, kdo si chce od tebe vypůjčit. ");
INSERT INTO ceslb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","A dále bylo řečeno: Miluj přítele a měj v nenávisti svého nepřítele! ");
INSERT INTO ceslb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Ale já vám říkám: milujte své nepřátele, modlete se za ty, kteří vás pronásledují. Tak budete dělat čest svému Otci v nebi. On dovoluje, aby slunce svítilo na zlé i dobré, a déšť sesílá na ty, kdo ho ctí, i na ty, kdo jím pohrdají. ");
INSERT INTO ceslb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jakou máte zásluhu, když projevujete lásku těm, kteří vám ji oplácejí? Copak to nedokážou i sobci? ");
INSERT INTO ceslb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A chováte-li se přátelsky jen ke svým blízkým, co děláte zvláštního? Na to ještě nemusíte věřit v Boha. ");
INSERT INTO ceslb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nevymlouvejte se na hranice svých možností, ale buďte tak dokonalí v lásce, jako je váš nebeský Otec. ");
INSERT INTO ceslb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Dejte si pozor, abyste nedělali dobré skutky okázale před lidmi a nestavěli tím na odiv svoji dobročinnost. Tak rozhodně nezískáte odměnu od nebeského Otce. ");
INSERT INTO ceslb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Proto když pomáháš bližnímu, nechtěj, aby o tom všichni věděli. Okatě – v synagogách a na ulicích – prokazují dobro pyšní pokrytci, protože chtějí, aby je lidé chválili. Tak si vlastně vybírají svoji odměnu předem. ");
INSERT INTO ceslb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Když ty někomu pomůžeš, udělej to nenápadně. Tvůj nebeský Otec, který vidí všechno, ti to odplatí. ");
INSERT INTO ceslb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","A podobně je to s modlitbami. Když se modlíš, nebuď jako pokrytci, kteří chtějí okázalou modlitbou dokázat svoji zbožnost. Modlí se pro lidi, a tak nemohou čekat, že je Bůh vyslyší. ");
INSERT INTO ceslb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Když se chceš modlit, jdi domů, zavři za sebou dveře a modli se ke svému Otci, který je tam s tebou. A on, který vidí i to, co je skryto, tě vyslyší. ");
INSERT INTO ceslb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Neopakujte bezmyšlenkovitě modlitbu jako nerozumní lidé, kteří si myslí, že Boha umluví a on je vyslyší. ");
INSERT INTO ceslb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nenapodobujte je, vždyť váš Otec zná vaše potřeby dříve, než je vyslovíte. ");
INSERT INTO ceslb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dám vám vzor prosté modlitby: Náš nebeský Otče, vzdáváme čest tvému svatému jménu. ");
INSERT INTO ceslb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ujmi se vlády, ať se děje všechno podle tvé vůle jak v nebi, tak na zemi. ");
INSERT INTO ceslb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dej nám chléb i dnes ");
INSERT INTO ceslb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","a odpusť nám naše provinění, tak jako my odpouštíme těm, kteří nám ublížili. ");
INSERT INTO ceslb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Chraň nás před pokušením a vysvoboď nás z moci zlého. Vždyť tobě navždy patří vláda, moc i sláva. Amen. ");
INSERT INTO ceslb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Odpustíte-li druhým jejich provinění, i váš nebeský Otec vám odpustí. ");
INSERT INTO ceslb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jestliže jim však neodpustíte, nemůžete ani vy počítat s Božím odpuštěním. ");
INSERT INTO ceslb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jestliže svou modlitbu podepřete postem, nenasazujte si ztrápenou, zbožnou masku jako ti, kteří úmyslně zanedbávají svůj vzhled, aby upozornili okolí na to, že se postí. Tím už dosáhli, co chtěli, a víc nemohou čekat. ");
INSERT INTO ceslb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Když se ty postíš, dobře se uprav, ");
INSERT INTO ceslb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","aby na tobě nikdo nic nepoznal. Ví o tom jen tvůj Otec, který vidí to, co je lidem skryto. Jedině tak ti půst přinese duchovní užitek. ");
INSERT INTO ceslb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nehromaďte si bohatství zde na zemi, kde může zrezivět, padnout napospas molům nebo zlodějům. ");
INSERT INTO ceslb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ukládejte si poklady v nebi, kde nepodlehnou žádné zkáze a ani je žádný zloděj nevykope a neukradne. ");
INSERT INTO ceslb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kde je vaše bohatství, tam je i vaše srdce. ");
INSERT INTO ceslb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Světlem těla je oko. Je-li tvé oko čisté, jsi naplněn jasem. ");
INSERT INTO ceslb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Je-li však tvé oko zakaleno nečistými myšlenkami, žiješ v duchovní tmě. Nemáš-li jasno v sobě, tápeš v beznadějné temnotě. ");
INSERT INTO ceslb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nikdo nemůže sloužit dvěma pánům. Jednoho bude nenávidět a druhého mít v lásce, nebo jednomu dávat přednost a druhého zanedbávat. Nelze sloužit zároveň Bohu a majetku. ");
INSERT INTO ceslb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Radím vám: nezatěžujte se starostmi o jídlo, pití a oděv. Cožpak nemají pokrmy sloužit jen k udržení života a šaty k oblečení těla? ");
INSERT INTO ceslb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Podívejte se na ptáky: nesejí ani nesklízejí, neshromažďují obilí do sýpek, ale nebeský Otec je živí. Což vy nejste o mnoho cennější? ");
INSERT INTO ceslb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","I když se budete starat sebevíc, přece svůj život neprodloužíte ani o jediný okamžik. ");
INSERT INTO ceslb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A proč si děláte starosti se svým oblečením? Podívejte se na polní květiny: nepracují ani nepředou, ");
INSERT INTO ceslb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","a vidíte, ani Šalomoun ve svém královském majestátu nebyl tak oděn jako kterákoliv z nich. ");
INSERT INTO ceslb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jestliže tedy Bůh dává takovou krásu nepatrným polním kvítkům, které nemají dlouhého trvání, nepostará se tím spíše o vás? To mu tak málo důvěřujete? ");
INSERT INTO ceslb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","A tak se netrapte otázkami: Co budeme jíst? Co budeme pít? Co si vezmeme na sebe? ");
INSERT INTO ceslb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pro lidi bez Boha je to první a poslední. Ale vy máte nebeského Otce a ten dobře ví, co všechno potřebujete. ");
INSERT INTO ceslb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dejte jeho na první místo a žijte tak, jak on si přeje, a on se o vás postará. ");
INSERT INTO ceslb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nezatěžujte se zítřejšími starostmi. Ty patří k zítřku. Každý den má dost svých problémů. ");
INSERT INTO ceslb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nesuďte druhé, abyste nebyli souzeni. ");
INSERT INTO ceslb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Podle toho, jak soudíte, budete souzeni i vy a na váš život budou přiložena stejná měřítka, jaká sami používáte. ");
INSERT INTO ceslb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Jak to, že vidíš pilinu v oku druhého člověka a poleno ve svém oku přehlížíš? ");
INSERT INTO ceslb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jak můžeš říkat druhému: ‚Dovol, abych ti vyndal smítko z oka,‘ a poleno ti ve vlastním oku nepřekáží? ");
INSERT INTO ceslb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pokrytče! Vyčisti si nejprve svoje oko, a teprve potom jasně uvidíš na to, abys mohl vyjmout pilinu z oka svého bližního. ");
INSERT INTO ceslb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Je zbytečné vysvětlovat Boží pravdy těm, kteří jimi pohrdají. To je stejné, jako byste očekávali, že pes ocení vzácný pokrm a vepř krásu perly. Co se stane? Všechno zašlapou a nakonec vás napadnou. ");
INSERT INTO ceslb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Proste, a dostanete, hledejte, a najdete. Klepejte, a bude vám otevřeno. ");
INSERT INTO ceslb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Protože každý, kdo prosí, dostane, kdo hledá, nalezne a tomu, kdo tluče, bude otevřeno. ");
INSERT INTO ceslb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kdyby kohokoliv z vás poprosilo vlastní dítě o kus chleba, dali byste mu snad kámen? ");
INSERT INTO ceslb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A místo ryby byste mu dali hada? Určitě ne! ");
INSERT INTO ceslb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jestliže tedy vy, lidé tvrdého a hříšného srdce, dovedete dávat svým dětem dobré věci, tím spíše je nebeský Otec dá těm, kteří ho prosí. ");
INSERT INTO ceslb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jednejte s druhými tak, jak byste si přáli, aby jednali oni s vámi. Tak se dá shrnout Starý zákon. ");
INSERT INTO ceslb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Do Božího království lze vstoupit jen úzkou brankou. Prostorná brána a široká cesta vedou do záhuby a mnoho lidí se tudy ubírá. ");
INSERT INTO ceslb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Brána a cesta k životu jsou úzké a je málo těch, kteří je najdou. ");
INSERT INTO ceslb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mějte se na pozoru před falešnými náboženskými učiteli, kteří přicházejí v masce neškodné ovce, ale ve skutečnosti jsou jako lační vlci. ");
INSERT INTO ceslb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Poznáte je podle toho, jak žijí a jednají – právě tak jako posuzujete strom podle ovoce, které se na něm rodí. Cožpak se sklízejí hrozny z trnek a fíky z bodláčí? ");
INSERT INTO ceslb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Dobrý strom nemůže nést špatné ovoce a zase špatný strom dobré. ");
INSERT INTO ceslb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Každý strom, který nedává dobrou úrodu, je poražen a spálen. ");
INSERT INTO ceslb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ovoce – činy člověka, to je spolehlivý rozpoznávací znak. ");
INSERT INTO ceslb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ne každý, kdo mne oslovuje Pane, Pane, přijde do nebeského království. Rozhodující je, zda poslouchá mého Otce. ");
INSERT INTO ceslb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","V den posledního soudu mi mnozí řeknou: ‚Pane, Pane, cožpak jsme v tvém jménu nemluvili, nebojovali proti zlu a nedokázali mnoho divů?‘ ");
INSERT INTO ceslb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Já jim však odpovím: ‚Nikdy jste mi nepatřili a neřídili se podle Boží vůle. Jděte pryč!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kdo slyší tato má slova a jedná podle nich, ten může být přirovnán k prozíravému člověku, který založil svůj dům na skále. ");
INSERT INTO ceslb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Přesto, že přišly deště s povodní a vichřice se opírala do jeho zdí, dům vydržel, protože byl postaven na skále. ");
INSERT INTO ceslb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kdo však slyší tato má slova, ale neuvede je do života, jedná jako pošetilý člověk, který založil svůj dům na písku. ");
INSERT INTO ceslb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Přišly deště, zaplavily krajinu a prudká vichřice se opřela do zdí domu. Ten se zřítil s velkým rachotem.“ ");
INSERT INTO ceslb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Když Ježíš domluvil, lidé žasli nad jeho učením. ");
INSERT INTO ceslb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Na rozdíl od učitelů, které znali, z Ježíše vyzařovala zvláštní síla. ");
INSERT INTO ceslb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Velké zástupy se hrnuly za Ježíšem, když sestupoval s hory. ");
INSERT INTO ceslb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tu se k němu přiblížil malomocný, klekl před ním a řekl: „Pane, budeš-li chtít, můžeš mne uzdravit!“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ježíš zvedl ruku, dotkl se toho muže a řekl: „Ano, chci. Ať tvá nemoc zmizí!“ A hned byl ten malomocný zdráv. ");
INSERT INTO ceslb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ježíš mu pak řekl: „Nikomu nic neříkej, ale jdi, ukaž se knězi a vezmi s sebou obětní dar, který ustanovil Mojžíš pro uzdravené od malomocenství. To bude veřejné svědectví o tvém uzdravení.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Když Ježíš přicházel do Kafarnaum, přistoupil k němu římský setník s prosbou: ");
INSERT INTO ceslb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","„Pane, můj služebník leží doma ochrnutý a má velké bolesti.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ježíš mu odpověděl: „Přijdu za ním a uzdravím ho.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Setník mu však na to řekl: „Pane, nezasloužím si, aby ses namáhal ke mně domů. Vždyť stačí tvé slovo, a bude uzdraven. ");
INSERT INTO ceslb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Já vím, jak to je: sám poslouchám i poroučím. Když vojákovi rozkážu, tak jde, když ho zavolám, přijde. A když uložím svému služebníkovi práci, tak ji vykoná. Takovou moc máš ty i nad nemocemi.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Když to Ježíš uslyšel, podivil se a řekl těm, kteří šli s ním: „Řeknu vám, že s tak velikou vírou jsem se nesetkal v celém Izraeli. ");
INSERT INTO ceslb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Je to opravdu tak, že mnozí lidé z celého světa budou přijati do Boží věčné říše, ");
INSERT INTO ceslb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","zatímco mnozí Izraelci, pro které byla připravena, budou z ní vyloučeni; zbyde jim beznaděj, bolest a pláč.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Potom se Ježíš obrátil opět k setníkovi: „Jdi domů. Čemu jsi uvěřil, ať se stane.“ V tu chvíli se služebník uzdravil. ");
INSERT INTO ceslb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pak Ježíš navštívil Petra a našel jeho tchyni schvácenou horečkou. ");
INSERT INTO ceslb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dotkl se její ruky, teplota klesla a jí se ulevilo natolik, že vstala a obsloužila hosta. ");
INSERT INTO ceslb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Večer k němu přivedli mnoho posedlých, on je pouhým slovem zbavil zlého a všechny nemocné uzdravil. ");
INSERT INTO ceslb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tím se naplnilo, co předpověděl prorok Izajáš: „On na sebe vzal naše slabosti a nesl naše nemoci.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Když Ježíš viděl, jak se kolem něj kupí množství lidí, chtěl se na loďce přeplavit na druhou stranu jezera; ");
INSERT INTO ceslb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","zadržel ho však ještě jeden učitel zákona: „Mistře, chci být stále s tebou.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ježíš mu odpověděl: „Každá liška má svou noru, pták hnízdo, ale já často nemám kde spát.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jeden z jeho žáků mu zase řekl: „Pane, než půjdu s tebou, dovol mi ještě pohřbít mého otce.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ale Ježíš mu odpověděl: „Ty pojď se mnou! Poslední službu mrtvému může poskytnout za tebe i ten, kdo se ještě duchovně neprobudil.“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pak vyplul spolu se svými učedníky. ");
INSERT INTO ceslb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nad jezerem se strhla prudká bouře, takže člunu hrozilo potopení ve vlnách. Ježíš však klidně spal. ");
INSERT INTO ceslb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Probudili ho: „Pane, zachraň nás. Jde o život!“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ale on jim řekl: „Proč se bojíte? Kde je vaše víra?“ Vstal, okřikl vítr i vlny, a nastal klid. ");
INSERT INTO ceslb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kteří to viděli, byli naplněni údivem a říkali si: „Kdo to vlastně je, že ho poslouchají vítr i moře?“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Když přistáli na druhém břehu jezera poblíž Gadary, narazili na dva muže posedlé démony. Ti žili ve skalních hrobech a byli tak nebezpeční, že se nikdo neodvážil tudy chodit. ");
INSERT INTO ceslb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na Ježíše začali křičet: „Co je ti do nás, Boží Synu? Ještě na nás nemáš právo!“ ");
INSERT INTO ceslb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Opodál se páslo velké stádo vepřů. ");
INSERT INTO ceslb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","„Když nám bereš moc nad lidmi, nech nám ji aspoň nad těmi vepři,“ prosili démoni. ");
INSERT INTO ceslb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","On jim řekl: „Zmizte!“ Démoni opustili muže a zmocnili se zvířat. V tom okamžiku se celé stádo splašilo a hnalo se dolů k jezeru, kde se utopilo. ");
INSERT INTO ceslb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pasáci vepřů utekli do města a všude roznesli, co se stalo. ");
INSERT INTO ceslb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Celé město se šlo na Ježíše podívat, ale žádali ho, aby z jejich kraje odešel. ");
INSERT INTO ceslb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ježíš tedy vstoupil opět do člunu, vrátil se na druhý břeh a přišel do Kafarnaum. ");
INSERT INTO ceslb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na nosítkách k němu přinesli ochrnutého člověka. Ježíš viděl jejich víru, a tak řekl nemocnému: „Už se netrap, chlapče! Tvé hříchy jsou ti odpuštěny!“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ale někteří z učitelů zákona se nad tím pozastavovali: „To jsou prázdná slova. Na to má právo jen Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","7","Ježíš však prohlédl jejich myšlenky a obrátil se k nim: „Myslíte si, že zůstalo jen při slovech, když jsem mu odpustil hříchy? Dokážu vám, že moje slovo má moc.“ Nato se obrátil k ochrnutému: „Vstaň a odnes svá nosítka domů!“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lidé nad tím žasli a děkovali Bohu, že dal člověku takovou moc. ");
INSERT INTO ceslb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cestou odtud uviděl Ježíš muže jménem Matouš, jak vybírá poplatky. „Pojď se mnou a staň se mým učedníkem!“ vyzval ho. Matouš hned vstal a následoval ho. ");
INSERT INTO ceslb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Později při hostině v Matoušově domě přišlo také mnoho celníků a lidí pochybné pověsti, aby poznali Ježíše a jeho učedníky. ");
INSERT INTO ceslb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Zbožné farizeje to popudilo: „Jak si váš mistr může sednout k jednomu stolu s takovými lidmi?“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Když to Ježíš uslyšel, řekl jim: „Lékaře potřebují nemocní a ne zdraví. ");
INSERT INTO ceslb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zamyslete se nad tím, co znamená to staré slovo Písma: Nechci vaše oběti a dary, ale chci, abyste byli milosrdní. Nepřišel jsem schvalovat vaši bezúhonnost, ale zvát hříšníky k pokání.“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Potom přišli za Ježíšem žáci Jana Křtitele s otázkou: „My a farizejové často držíme půst. Proč se tvoji učedníci také nepostí, jak je zvykem zbožných lidí?“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ježíš jim odpověděl: „Žádá někdo po svatebčanech, aby byli smutní a odmítali jídlo, dokud je ženich mezi nimi? Kdyby někdo ženicha odvlekl, bude po svatebním veselí. I moji učedníci se jednou postí, až přijde pravý čas. Nový život z Boha se nedá vtěsnat do starých zvyků a forem. ");
INSERT INTO ceslb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","To je podobné, jako kdyby někdo přišil na staré šaty záplatu z neseprané látky. Co se stane? Záplata vytrhne chatrné tkanivo a díra se ještě zvětší. ");
INSERT INTO ceslb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mladé víno přece také nedáváte do měchů ze staré kůže, jinak by popraskaly a obojí by přišlo nazmar. Nové víno potřebuje nové měchy!“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zatímco Ježíš mluvil, přišel jeden z představených místní synagogy a poklonil se mu. „Moje dcera právě zemřela,“ řekl, „ale ty jí můžeš zase vrátit život. Pojď, polož na ni ruku a vrátíš jí život.“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ježíš i jeho učedníci šli s ním. ");
INSERT INTO ceslb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Vtom však jedna žena, již dvanáct let postižená krvácením, se k Ježíšovi zezadu přiblížila a dotkla se okraje jeho roucha. ");
INSERT INTO ceslb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Myslela si: Když se alespoň dotknu jeho šatu, určitě se uzdravím. ");
INSERT INTO ceslb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ježíš se však otočil, podíval se na ni a řekl: „Raduj se, tvá víra tě zachránila.“ A opravdu, v tu chvíli byla žena zbavena svého trápení. ");
INSERT INTO ceslb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pak Ježíš došel k domu onoho představeného synagogy, kde hrála pohřební hudba a naříkal shromážděný dav. ");
INSERT INTO ceslb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Řekl jim: „Jděte všichni pryč! Smrt té dívky pomine jako spánek.“ Ale nikdo ho nebral vážně a vysmívali se mu. ");
INSERT INTO ceslb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Když byl dům konečně vyklizen, Ježíš vešel, vzal děvčátko za ruku a ono vstalo. ");
INSERT INTO ceslb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Zpráva o tom se rychle roznesla po celém kraji. ");
INSERT INTO ceslb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na cestě odtud se k Ježíšovi přidali dva slepci a volali: „Kriste, králi, slituj se nad námi!“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Šli za ním až do domu. Ježíš se jich zeptal: „Opravdu věříte, že vám mohu vrátit zrak?“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","„Určitě, Pane,“ ujišťovali ho slepci. Dotkl se jejich očí a řekl: „Staň se vám, jak věříte.“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","V tu chvíli prohlédli. Pak jim důrazně přikázal: „Nechte si to pro sebe, ať se nikdo o tom nedoví!“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ale oni chodili po celém kraji a všude o něm mluvili. ");
INSERT INTO ceslb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sotva odešli, přivedli k Ježíšovi němého člověka, posedlého zlým duchem. ");
INSERT INTO ceslb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ježíš démona vyhnal a němý začal mluvit. Zástupem proběhla vlna údivu: „Nikdy se v Izraeli nic podobného nedělo!“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farizejové to však vysvětlovali: „Vyhání ďábly, protože je ve spojení s jejich vládcem.“ ");
INSERT INTO ceslb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Potom Ježíš procházel všemi městy i vesnicemi, učil v tamních synagogách a kázal radostnou zvěst o Božím království. A kamkoliv přišel, všude uzdravoval nemoci všeho druhu. ");
INSERT INTO ceslb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Když se tak díval na zástupy lidí stojící před ním, bylo mu jich líto, protože nevěděli, na koho se obrátit a kde hledat pomoc. Byli jako ovce bez pastýře. ");
INSERT INTO ceslb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Svým učedníkům řekl: „Ti všichni patří Bohu jako úroda svému hospodáři. Je však málo ženců. ");
INSERT INTO ceslb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Proto proste Pána, ať pošle pracovníky na své žně.“ ");
INSERT INTO ceslb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Potom Ježíš svolal svých dvanáct žáků a dal jim moc nad temnými silami, aby je vyháněli a uzdravovali všechny nemoci těla i ducha. ");
INSERT INTO ceslb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jména těch dvanácti, které nazval svými vyslanci – apoštoly, jsou: Šimon, zvaný Petr, Ondřej – Petrův bratr, Jakub – syn Zebedeův a jeho bratr Jan, ");
INSERT INTO ceslb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartoloměj, Tomáš, Matouš – bývalý celník, Jakub – syn Alfeův, Tadeáš, ");
INSERT INTO ceslb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Šimon Kenaanský a Jidáš Iškariotský, jenž ho nakonec zradil. ");
INSERT INTO ceslb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Těchto dvanáct Ježíš vyslal a na cestu jim dal pokyny: „Nechoďte nyní mezi pohany a nevcházejte do samařských měst. ");
INSERT INTO ceslb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","7","Raději jděte k těm Izraelcům, kteří se Bohu odcizili, a rozhlašujte, že Boží království je již blízko. ");
INSERT INTO ceslb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uzdravujte nemocné, mrtvé probouzejte k životu, očišťujte malomocné, vyhánějte démony. Co jste zdarma dostali, zdarma rozdávejte. ");
INSERT INTO ceslb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Neshánějte žádné peníze, ");
INSERT INTO ceslb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","neberte si na cestu zavazadlo s náhradními šaty či obuví, ani hůl na obranu. Jako dělník dostává mzdu, tak i ti, kterým sloužíte, by se měli o vás postarat. ");
INSERT INTO ceslb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kdykoliv vstoupíte do města nebo vesnice, ptejte se po bohabojném člověku a v jeho domě pak zůstaňte, dokud se nevydáte na další cestu. ");
INSERT INTO ceslb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Když vstoupíte do domu, pozdravte přáním pokoje. ");
INSERT INTO ceslb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jestliže vaše poselství vděčně přijmou, naplní je pokoj, který přinášíte. ");
INSERT INTO ceslb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Odmítnou-li, jejich škoda, vám pokoj zůstane. Opusťte každé město nebo dům, kde by vás ani vaše svědectví nepřijali, a nezdržujte se s nimi. ");
INSERT INTO ceslb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Říkám vám, že takové město na tom bude v den soudu hůře než Sodoma a Gomora. ");
INSERT INTO ceslb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Posílám vás jako ovce mezi vlky. Buďte tedy obezřetní jako hadi a bezelstní jako holubice. ");
INSERT INTO ceslb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mějte se na pozoru před lidmi, protože vás budou vydávat soudům a budou vás bičovat v synagogách, ");
INSERT INTO ceslb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","vláčet vás před vládce a panovníky kvůli mně. To všechno bude příležitost, abyste jim i celému světu vydali svědectví. ");
INSERT INTO ceslb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Až vás postaví před soud, nedělejte si starosti s tím, jak a co budete mluvit, protože vám budou dána pravá slova v pravý čas. ");
INSERT INTO ceslb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","To nebudete mluvit vy, ale Duch vašeho Otce promluví skrze vás. ");
INSERT INTO ceslb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bratr vydá bratra na smrt, otec syna, děti se vzbouří proti rodičům a zabijí je. ");
INSERT INTO ceslb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Všichni vás budou nenávidět, protože jste moji. Ale ten, kdo vytrvá až do konce, bude zachráněn pro věčnost. ");
INSERT INTO ceslb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Budou-li vás v některém městě pronásledovat, utečte do jiného. Říkám vám, že nestačíte projít všechna izraelská města dříve, než se prokáže, kdo vlastně jsem. ");
INSERT INTO ceslb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Žák nemůže očekávat víc než učitel, ani služebník Boží víc než jeho pán. ");
INSERT INTO ceslb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ať je spokojen s údělem svého učitele a pána. Když mne obvinili, že jsem ve spojení s ďáblem, co si asi vymyslí na vás! ");
INSERT INTO ceslb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ale nebojte se jich. Přijde čas, že pravda vyjde najevo a všechno skryté bude odhaleno. ");
INSERT INTO ceslb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Co vám říkám ve tmě, povězte na světle, a co vám šeptám do ucha, rozhlašujte veřejně! ");
INSERT INTO ceslb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A nebojte se těch, kteří zabíjejí tělo; věčný život vzít nemohou. Spíše mějte strach z toho, který vás může navěky zahubit. ");
INSERT INTO ceslb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","30","Jakoupak cenu má vrabec? A přece ani jeden nespadne na zem bez vědomí vašeho Otce. ");
INSERT INTO ceslb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tak nemějte strach – jste daleko cennější než celé hejno vrabců. Otci záleží na každém vašem vlásku. ");
INSERT INTO ceslb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kdo se ke mně přizná před lidmi, k tomu se i já budu hlásit před svým Otcem v nebi. ");
INSERT INTO ceslb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kdo mne však před lidmi zapře, toho se zřeknu před svým nebeským Otcem. ");
INSERT INTO ceslb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nemyslete si, že můj příchod přinese světu bezprostřední pokoj; můj příchod způsobí i boj a násilí. ");
INSERT INTO ceslb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Víra ve mne může rozdělit syna a otce, dceru a matku, snachu a tchyni. ");
INSERT INTO ceslb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nepochopení a zloba vlastní rodiny bývají nejhlubší. ");
INSERT INTO ceslb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kdo má ve svém srdci na prvním místě otce nebo matku, syna nebo dceru, a ne mne, není mne hoden. ");
INSERT INTO ceslb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kdo by chtěl za mnou jít a nevzal by na sebe tyto těžkosti jako kříž, není mne hoden. ");
INSERT INTO ceslb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kdo lpí na svém životě, ztratí ho, kdo však je ochoten pro mne všechno obětovat, ten teprve pravý život získá. ");
INSERT INTO ceslb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kdo přijímá vás, přijímá mne, a kdo přijímá mne, ten přijímá toho, který mne poslal. ");
INSERT INTO ceslb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Přijme-li někdo mého svědka s vědomím, že Bůh ho posílá, dostane stejnou odměnu jako on. Kdo se ujme věřícího pro jeho víru ve mne, dostane stejnou odměnu jako ten věřící. ");
INSERT INTO ceslb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A kdo by podal třeba jen sklenici studené vody jednomu z nepatrných, protože je můj učedník, ten bude určitě odměněn.“ ");
INSERT INTO ceslb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Když Ježíš skončil s pokyny pro svých dvanáct učedníků, šel, aby učil a kázal v tamějších městech. ");
INSERT INTO ceslb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jan Křtitel ve vězení uslyšel o Ježíšových činech, poslal za ním své dva žáky a ti se ho zeptali: ");
INSERT INTO ceslb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","„Jsi opravdu ten zaslíbený Mesiáš, nebo máme čekat jiného?“ ");
INSERT INTO ceslb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ježíš jim na to odpověděl: „Vraťte se k Janovi a povězte mu o tom, co jste viděli a slyšeli: ");
INSERT INTO ceslb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","slepí vidí, chromí chodí, malomocní jsou uzdravováni, hluší slyší, mrtví vstávají k životu a ti, kteří u lidí neznamenají nic, jsou ujišťováni, že Bůh s nimi počítá. ");
INSERT INTO ceslb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Šťastný je ten, kdo mne přijímá bez výhrad.“ ");
INSERT INTO ceslb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Když Janovi žáci odešli, řekl o něm Ježíš zástupu: „Když jste šli za Janem na poušť, jistě jste v něm nenašli slabocha – ‚kam vítr, tam plášť‘; ");
INSERT INTO ceslb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ani jste nenašli žádnou vysoce postavenou osobu – takoví chodí pěkně oblečeni a bydlí v palácích. ");
INSERT INTO ceslb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Šli jste za ním jako za prorokem a měli jste pravdu. Ujišťuji vás, že on je ještě víc než prorok. Proroci a celý Starý zákon až po Jana vyhlíželi Mesiáše. Chcete-li pochopit to, co míním, Jan je novým Elijášem, o kterém proroci říkali, že má přijít před začátkem království. ");
INSERT INTO ceslb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","To o něm se píše v Písmu, že půjde přede mnou, ohlásí můj příchod a připraví mi cestu k lidským srdcím. ");
INSERT INTO ceslb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Opravdu, mezi všemi lidmi, kteří se kdy narodili, není nikdo, kdo by převyšoval svým posláním Jana Křtitele; a přece i nejskromnější z mých následovníků se dostal dál než on. ");
INSERT INTO ceslb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","15","Od doby, kdy Jan Křtitel začal kázat a křtít, Boží vláda se prosazuje, ale násilí jí škodí. Kdo slyšíš, rozuměj! ");
INSERT INTO ceslb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","K čemu mám přirovnat tuto generaci? Je jako hrající si děti, které sedí na návsi a pokřikují nespokojeně na své kamarády: ");
INSERT INTO ceslb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‚Hráli jsme vám a vy jste netancovali, smutně jsme vám zpívali a vy jste neplakali.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Přišel Jan, žil odříkavě a měli ho za fanatika. ");
INSERT INTO ceslb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Přišel jsem já, Syn člověka, žiji normálně a říkají, že jsem žrout a pijan vína, přítel celníků a nejhorší lůzy. Ale Boží moudrost prokáže, co je pravda!“ ");
INSERT INTO ceslb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tvrdá slova měl Ježíš pro města, která byla svědky mnoha jeho mocných činů, a přece nečinila pokání: ");
INSERT INTO ceslb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","„Běda ti, Korozaim, běda ti, Betsaido! Kdybych udělal v Týru a Sidónu takové zázraky jako u vás, už dávno by jejich obyvatelé činili pokání a projevili nejhlubší lítost nad svými vinami. ");
INSERT INTO ceslb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Proto vám říkám, že Týru a Sidónu bude v den soudu snáze než vám. ");
INSERT INTO ceslb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ty, Kafarnaum, myslíš, že poroste tvá sláva až k nebi? Do propasti věčné záhuby padneš! Kdybych udělal v Sodomě takové zázraky jako u vás, stála by dodnes. ");
INSERT INTO ceslb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Znovu vám říkám, že zemi Sodomské bude lehčeji v den soudu než tobě!“ ");
INSERT INTO ceslb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Potom se Ježíš modlil: „Otče, Pane nebe i země, děkuji ti, že pravdu skrýváš před těmi, kteří se považují za moudré a učené, a odkrýváš ji nepatrným a prostým. ");
INSERT INTO ceslb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Je to, Otče, jak sis přál. ");
INSERT INTO ceslb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Otec mi svěřil všechno, jenom Otec zná Syna a Otce zná jenom Syn a ti, kterým ho Syn zjeví. ");
INSERT INTO ceslb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pojďte ke mně všichni, kteří pracujete a nesete tíhu břemen, najdete u mne klid a úlevu. ");
INSERT INTO ceslb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","To, co na vás já vložím, netlačí a není těžké. Učte se ode mne, mám tiché a pokorné srdce. U mne získáte mír a odpočinutí své duše.“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jednou v sobotu, sváteční den židů, procházel Ježíš se svými učedníky obilným polem. Učedníci měli hlad, trhali klasy a jedli zrní. ");
INSERT INTO ceslb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farizejové to viděli a žalovali Ježíšovi: „Podívej se, tvoji žáci dělají, co je v sobotu zakázáno!“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ježíš na to: „Cožpak jste nečetli, co učinil král David, když on a jeho družina byli hladoví? ");
INSERT INTO ceslb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jak vešli do chrámu a jedli posvátné chleby, které směli jíst jen kněží? ");
INSERT INTO ceslb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nebo jste nečetli v Mojžíšově zákoně, že kněží v chrámu pracují v sobotu? Porušují sobotní klid, a přesto jsou bez hříchu. ");
INSERT INTO ceslb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ale říkám vám, že je tu někdo, kdo je víc než chrám. ");
INSERT INTO ceslb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kdybyste rozuměli biblickému slovu ‚Nejde mi o oběti, ale chci, abyste byli milosrdní!‘ pak byste nikoho neodsuzovali neprávem. ");
INSERT INTO ceslb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kristus je pánem i nad sobotou.“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Odtud šel do synagogy. ");
INSERT INTO ceslb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tam byl člověk s ochrnutou rukou. Farizejové hledali nějakou záminku, aby mohli Ježíše obžalovat, a proto se ho otázali: „Je dovoleno v sobotu uzdravovat?“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","On jim na to řekl: „Kdyby někdo z vás měl jedinou ovci a ta by spadla v sobotu do rokle, nepodnikli byste vše, abyste ji vytáhli? ");
INSERT INTO ceslb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oč cennější je člověk! Proto je správné dělat dobro i v sobotu.“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Obrátil se k postiženému a řekl mu: „Natáhni ruku!“ On to udělal a byla zdravá jako ta druhá. ");
INSERT INTO ceslb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farizejové odešli a radili se, jak by Ježíše zneškodnili. ");
INSERT INTO ceslb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ježíš to poznal a odešel odtud. Mnozí ho však následovali a on uzdravil všechny nemocné. ");
INSERT INTO ceslb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ale přikázal jim, aby o něm moc nemluvili. ");
INSERT INTO ceslb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tak se naplnilo Izajášovo proroctví: ");
INSERT INTO ceslb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","„To je můj služebník, ten, pro kterého jsem se rozhodl, můj milovaný, potěšení mé duše. Dám mu svého Ducha a bude soudit národy. ");
INSERT INTO ceslb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nebude se přít, ani nikoho překřikovat, nebude dělat hluk na ulicích, ");
INSERT INTO ceslb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","nalomené stéblo nedolomí, doutnající knot neuhasí, dokud všechno nenapraví. ");
INSERT INTO ceslb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Stane se nadějí všech národů.“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pak přivedli k Ježíšovi slepého a němého člověka. Ježíš ho uzdravil, takže viděl a mluvil. ");
INSERT INTO ceslb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lidé užasli a říkali: „On je snad opravdu Boží král z rodu Davidova!“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ale slyšeli to farizejové a namítali: „Vždyť neuzdravuje jinak než s pomocí temných sil!“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ježíš však poznal, co si myslí, a proto řekl: „Rozdělené království končí v ruinách a žádné město nebo domov vnitřně rozdvojené neobstojí. ");
INSERT INTO ceslb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tak nemůže satan vyhánět satana. Jak by pak obstálo jeho království? ");
INSERT INTO ceslb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Já, podle vás, odstraňuji temnotu ve jménu duchovní tmy. I mezi vámi jsou lidé, kteří bojují proti temným silám. Zeptejte se jich, jakou mocí to činí. ");
INSERT INTO ceslb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Jestliže já ovšem vyháním zlo v moci Božího Ducha, pak už k vám přišlo Boží království. ");
INSERT INTO ceslb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Když chce někdo ukrást věci z domu silného člověka, musí ho nejdříve svázat, a pak si to může odnést. Tak i ze satanovy moci může vysvobodit jen ten, kdo je silnější než on. ");
INSERT INTO ceslb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kdo není se mnou, je proti mně, kdo se mnou neshromažďuje, rozhazuje. ");
INSERT INTO ceslb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Co mluvíte proti mně, to vám může být odpuštěno. Ale pozor – nemluvte proti moci Ducha, který působí skrze mne. To vám Bůh nikdy neodpustí. ");
INSERT INTO ceslb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jaký strom vypěstujete, takové ponese ovoce. Dobrý dobré, planý plané. ");
INSERT INTO ceslb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Vy podvodníci! Jak byste mohli mluvit dobré, když jste zlí? Čím srdce oplývá, tím ústa přetékají. ");
INSERT INTO ceslb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dobrý člověk rozdává z dobrého pokladu svého srdce a zlý člověk ze zlého. ");
INSERT INTO ceslb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Počítejte s tím, že budete skládat účty z každého neupřímného slova. ");
INSERT INTO ceslb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vaše slova o vás rozhodnou: buď vás ospravedlní, nebo odsoudí.“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Potom žádali farizejové a učitelé zákona Ježíše, aby se prokázal nějakým zázrakem. ");
INSERT INTO ceslb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","On jim však odpověděl: „Vězíte v hříchu a zatvrzelosti, a proto vyžadujete další důkazy. Nedostanete je! ");
INSERT INTO ceslb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tak jako věříte, že byl Jonáš tři dny a tři noci v útrobách mořského živočicha, tak budete muset uvěřit, že Syn člověka třetí den vstane z hrobu. ");
INSERT INTO ceslb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lidé z Ninive vystoupí na soudu proti vám a usvědčí vás, protože oni vzali vážně Jonášovu zvěst. A k vám mluví ten, kdo je víc než Jonáš. ");
INSERT INTO ceslb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Královna ze Sáby vystoupí na soudu jako další svědek proti vám. Neváhala přijet z daleké země, aby poznala Šalomounovu moudrost. A tady je někdo větší než Šalomoun. ");
INSERT INTO ceslb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","Když je z člověka vyhnán nečistý duch, hledá, kde jinde by se zabydlel. Ale nechce se snadno vzdát prvního hostitele. Když vidí, že srdce toho člověka je sice vyčištěné a upravené, ale zůstává prázdné, nastěhuje se tam zpět se sedmi společníky horšími, než je sám. Takový člověk je na tom potom hůř než předtím. To nebezpečí hrozí i vám.“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ježíš ještě mluvil v přeplněném domě, když přišla jeho matka a bratři. Čekali venku, protože s ním chtěli mluvit. ");
INSERT INTO ceslb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Když ho jeden z davu upozornil, že na něho čekají, ");
INSERT INTO ceslb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","řekl: „Kdo je má matka a moji bratři?“ ");
INSERT INTO ceslb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ukázal na své učedníky se slovy: „To je moje rodina. ");
INSERT INTO ceslb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Každý, kdo poslouchá mého nebeského Otce, je můj bratr, sestra i matka!“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Téhož dne vyšel Ježíš z domu a usedl na břehu jezera. ");
INSERT INTO ceslb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Zanedlouho se kolem něho shromáždilo tolik lidí, že musel vstoupit do loďky, aby je mohl všechny oslovit. ");
INSERT INTO ceslb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rád vyjadřoval duchovní pravdy obrazně. Tentokrát začal vyprávět: ");
INSERT INTO ceslb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","„Rolník zaséval na poli obilí. Některá zrna padla na okraj cesty. Slétli se ptáci a sezobali je. ");
INSERT INTO ceslb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jiná zrna dopadla na skalnatou zem, kde bylo málo ornice. Obilí rychle vyhnalo do výšky, ");
INSERT INTO ceslb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ale když začalo pálit slunce, uschlo, protože kořínky nešly do hloubky. ");
INSERT INTO ceslb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Další část zrna zapadla mezi bodláky. Když vyrostlo bodláčí, udusilo klásky. ");
INSERT INTO ceslb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ostatní zrna padla do dobré ornice. Vyrostlo obilí a přineslo úrodu. Některý klas měl sto zrnek, jiný šedesát a jiný třicet. ");
INSERT INTO ceslb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Víte, co tím myslím?“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Učedníci se ho zeptali: „Proč mluvíš v obrazech?“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Vysvětlil jim to: „Vám už Bůh odkrývá svoje záměry se světem. Ostatním je to zatím skryto. ");
INSERT INTO ceslb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kdo přijímá ochotně, bude mít stále víc. Kdo je spokojen s tím, co má, přijde nakonec o všechno. ");
INSERT INTO ceslb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Používám obrazy, lidé slyší i vidí, a přece nechápou. ");
INSERT INTO ceslb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tak se na nich plní Izajášovo proroctví: ‚Budete poslouchat, ale neporozumíte, budete se dívat, ale neuvidíte. ");
INSERT INTO ceslb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Protože srdce tohoto lidu otupělo, jsou hluší a zavřeli oči, aby neviděli, neslyšeli a neporozuměli, aby se neobrátili k Bohu, kde by mohli být uzdraveni.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jak je dobře, že vaše oči vidí a uši slyší. ");
INSERT INTO ceslb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mnoho proroků toužilo vidět to, co vy vidíte, a slyšet to, co vy slyšíte, ale nebylo jim to dopřáno. ");
INSERT INTO ceslb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","A teď k tomu příběhu o rozsévači. ");
INSERT INTO ceslb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cesta, kam padla některá zrna, představuje srdce lidí, kteří slyší o Božím království a nezajímá je to. Přichází satan a sebere, co bylo zaseto. ");
INSERT INTO ceslb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Skalnatá země představuje srdce člověka, který slyší Boží poselství a přijímá je sice s velkou radostí, ale povrchně a ono v něm nezapustí kořeny. Když pak přijdou těžkosti nebo pronásledování pro víru, jeho nadšení ochabne a to, co bylo zaseto, zmizí. ");
INSERT INTO ceslb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Země porostlá bodláčím představuje člověka, který slyší poselství, ale v jehož srdci záležitosti každodenního života a touha po lepším hmotném zajištění slovo udusí. ");
INSERT INTO ceslb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dobrá ornice představuje srdce člověka, který slyší Boží poselství, rozumí mu a nechává působit jeho životodárný vliv. Užitek z toho je mnohonásobný, u někoho větší, u jiného menší.“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Potom použil dalšího přirovnání. „Bůh je jako dobrý hospodář, který zasel na své pole dobré semeno. ");
INSERT INTO ceslb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","V noci, když lidé spali, hospodářův nepřítel rozhodil mezi pšenici semeno plevele. ");
INSERT INTO ceslb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","Když vyrostlo obilí a s ním i plevel, přišli služebníci za hospodářem a řekli mu: ‚Vždyť jsi zasel dobré semeno, kde se tedy vzal plevel?‘ ");
INSERT INTO ceslb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‚To udělal nepřítel!‘ odpověděl. ‚My půjdeme a vyplejeme to pole,‘ nabídli se. ");
INSERT INTO ceslb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ten jim na to řekl: ‚Ne, to nedělejte. Spolu s plevelem byste mohli snadno vytrhnout i pšenici. ");
INSERT INTO ceslb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Necháme obojí vyrůst a při žních řeknu žencům, aby vybrali plevel a spálili ho a pšenici dali do mé stodoly.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Předložil jim jiný obraz: „S Božím dílem je to jako s hořčičným seménkem, které člověk zasel na poli. ");
INSERT INTO ceslb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Je sice drobné, ale vyroste z něho tak mohutná bylina, že i ptáci na ní stavějí hnízda.“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Dále užil tohoto obrazu: „Boží vliv působí jako kvas. Malé množství prokvasí i velkou dávku těsta.“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","V tomto kázání Ježíš používal výhradně podobenství. ");
INSERT INTO ceslb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tak se naplnilo staré proroctví: „Budu mluvit v obrazech a vypovím, co bylo skryto od stvoření světa.“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ježíš pak opustil shromážděné posluchače a šel domů. Obklopili ho jeho učedníci a žádali, aby jim vyložil obraz plevele na poli. ");
INSERT INTO ceslb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","„Dobře,“ řekl, „já jsem ten hospodář, který seje dobré zrní. ");
INSERT INTO ceslb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pole představuje svět a zrna, to jsou lidé, kteří patří Bohu. Plevel, to jsou lidé propadlí zlému. ");
INSERT INTO ceslb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nepřítel, který ho zasel, je ďábel. Žně představují konec světa a ženci jsou andělé. ");
INSERT INTO ceslb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tak jako v tomto příběhu je plevel oddělen a spálen, tak bude na konci světa. ");
INSERT INTO ceslb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Pošlu své anděly a ti vyženou z Boží blízkosti všechny, kteří stáli v cestě Boží věci a páchali zlo. ");
INSERT INTO ceslb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jejich konec bude hrozný. Zbyde jim pláč a zoufalství. ");
INSERT INTO ceslb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A tehdy ti, kteří plnili Boží vůli, budou v království nebeského Otce zářit jako slunce. Přemýšlejte o tom! ");
INSERT INTO ceslb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nový život, k němuž vás Bůh volá, je jako poklad zakopaný v poli. Kdo ho najde, zatím o tom nemluví, ale má takovou radost, že prodá všechno, jen aby to pole získal. ");
INSERT INTO ceslb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Nebo: je jako drahocenná perla, kterou objeví obchodník s perlami. Vyprodá všechno, co má, a koupí ji. ");
INSERT INTO ceslb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Boží království je jako síť spuštěná do moře, ve které uváznou nejrůznější tvorové. ");
INSERT INTO ceslb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Když je síť plná, vytáhnou ji rybáři na břeh, do košů vyberou dobré ryby a ostatní vyhodí. ");
INSERT INTO ceslb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tak to bude i na konci světa. Přijdou Boží andělé a oddělí zlé od bohabojných ");
INSERT INTO ceslb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","a zlé hodí do ohně. Tam bude pláč a zoufalství. ");
INSERT INTO ceslb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Porozuměli jste všemu?“ „Ano,“ odpověděli. ");
INSERT INTO ceslb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Potom dodal: „Každý vykladač Písma, který pochopil, oč mi jde, je jako hospodář, který ze své zásobárny nabízí nové i staré.“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Když Ježíš skončil svůj výklad v podobenstvích, vrátil se do svého domovského města. Učil v tamní synagoze. Všichni se divili: „Kde se v něm bere taková moudrost a moc? ");
INSERT INTO ceslb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Vždyť to je tesařův syn, jeho matka je přece Marie, a Jakub, Josef, Šimon a Juda to jsou jeho bratři! ");
INSERT INTO ceslb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","I jeho sestry žijí mezi námi. Odkud to ten člověk má?“ ");
INSERT INTO ceslb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","58","Nemohli se s tím vyrovnat a pro jejich nedůvěru tam Ježíš nemohl vykonat mnoho zázraků. Vysvětlil to slovy: „Proroka si váží všude víc než v jeho rodném městě a v jeho domově!“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tehdy slyšel galilejský vládce Herodes Antipas vyprávění o Ježíšovi ");
INSERT INTO ceslb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a řekl svým dvořanům: „To musí být Jan Křtitel! Vstal z mrtvých, a proto dělá takové zázraky!“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Před časem dal tento Herodes Jana zatknout a uvěznit. ");
INSERT INTO ceslb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jan mu totiž vytýkal, že žije s Herodiadou, manželkou svého bratra Filipa. ");
INSERT INTO ceslb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes by se Jana rád zbavil, ale bál se, protože lidé v něm viděli proroka. ");
INSERT INTO ceslb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na oslavě Herodových narozenin tančila dcera Herodiady a okouzlila Heroda tak, ");
INSERT INTO ceslb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","že jí přísahal splnit každé přání. ");
INSERT INTO ceslb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodiada navedla svou dceru a ta požádala: „Chci tady na míse hlavu Jana Křtitele.“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","To bylo i na Heroda příliš. Nechtěl se však zostudit před hosty tím, že by zrušil svou přísahu. ");
INSERT INTO ceslb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Poručil proto, aby Jana sťali přímo ve vězení. ");
INSERT INTO ceslb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jeho hlavu přinesli na míse tanečnici a ta ji donesla své matce. ");
INSERT INTO ceslb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Janovi žáci si vyžádali jeho tělo a pohřbili ho. Pak šli oznámit Ježíšovi, co se stalo. ");
INSERT INTO ceslb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Když to Ježíš slyšel, vstoupil do loďky a odplul na osamělé místo. Jakmile však lidé z okolí zjistili, kam jeho loďka míří, shromáždili se tam. ");
INSERT INTO ceslb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Když Ježíš vystoupil na břeh, čekaly ho již davy lidí. Měl s nimi soucit a uzdravil jejich nemocné. ");
INSERT INTO ceslb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Večer za ním přišli jeho učedníci a řekli: „Už je pozdě a tady v pustině se nedá koupit nic k jídlu. Rozluč se s nimi, ať si mohou po vesnicích něco opatřit.“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ježíš jim na to řekl: „Kam by chodili, dejte jim najíst vy!“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Namítli: „Vždyť tu máme všeho všudy pět chlebů a dvě ryby!“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","„Přineste je sem,“ vybídl je. ");
INSERT INTO ceslb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Potom řekl lidem, aby se usadili na trávě. A vzal těch pět chlebů a dvě ryby a poděkoval za ně Bohu. Pak ulamoval, dával učedníkům a ti rozdávali lidem. ");
INSERT INTO ceslb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Najedlo se tam dosyta pět tisíc mužů kromě žen a dětí. A ještě nasbírali plných dvanáct košů zbytků. ");
INSERT INTO ceslb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hned potom Ježíš přiměl své učedníky, aby přepluli na druhý břeh, zatímco on propustí shromážděné lidi. ");
INSERT INTO ceslb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Když se zástupy rozcházely, vystoupil Ježíš na horu, aby se o samotě modlil. Strávil tam skoro celou noc. ");
INSERT INTO ceslb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Loď s učedníky stále nemohla dosáhnout druhého břehu, protože vítr hnal vlny proti ní. ");
INSERT INTO ceslb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","K ránu se Ježíš přiblížil k lodi po hladině jezera. ");
INSERT INTO ceslb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Učedníci ho považovali za přízrak a vyděsili se. ");
INSERT INTO ceslb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ale Ježíš promluvil a uklidnil je: „Vzchopte se, to jsem já, nebojte se!“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petr zvolal: „Pane, když máš takovou moc, rozkaž, ať přijdu k tobě po vodě!“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","„Tak pojď!“ řekl Ježíš. A tak Petr opustil loď a šel k Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Velké vlny ho však přece poděsily a začal se topit. „Pane, pomoz!“ vykřikl. ");
INSERT INTO ceslb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ježíš ho rychle zachytil a řekl: „Kde je tvoje víra? Proč jsi pochyboval?“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Vstoupili na loď a vítr se hned utišil. ");
INSERT INTO ceslb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Učedníci před Ježíšem poklekli a vyznávali: „Ty jsi určitě Boží Syn!“ ");
INSERT INTO ceslb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pak přistáli v genezaretském kraji. ");
INSERT INTO ceslb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jakmile ho tamější lidé poznali, rozneslo se to po širokém okolí a odevšad k němu nosili nemocné. ");
INSERT INTO ceslb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Prosili ho, aby se mohli alespoň dotknout lemu jeho šatu. A kdo se dotkl, byl uzdraven. ");
INSERT INTO ceslb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farizejové a učitelé zákona z Jeruzaléma přišli za Ježíšem s otázkou: ");
INSERT INTO ceslb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","„Proč tvoji žáci nedodržují staré židovské tradice? Vždyť ignorují i obřadní mytí rukou před jídlem!“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ježíš jim na to odpověděl: „Proč vy pro své tradice porušujete Boží přikázání? ");
INSERT INTO ceslb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Například – Boží příkaz zní: ‚Cti otce i matku; a kdo potupí otce nebo matku, ať zemře.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ale vy říkáte: ‚Jestliže odkážeš svůj majetek druhému, nesmíš už z něho podporovat své rodiče, i když mají nedostatek.‘ Tak jste svými ustanoveními zrušili přímý Boží příkaz. ");
INSERT INTO ceslb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Chytráci! I na vás se vztahují slova proroka Izajáše: ");
INSERT INTO ceslb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‚Tento lid říká, že mne ctí, ale jejich srdce je ode mne daleko. ");
INSERT INTO ceslb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jejich uctívání je bezcenné, protože vyučují svým vlastním zákonům místo Božím.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pak kolem sebe shromáždil lid a řekl: „Poslouchejte, co vám říkám, a snažte se porozumět: ");
INSERT INTO ceslb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Vaše nitro nešpiní to, co vchází do úst, ale co z nich vychází.“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Učedníci mu pak řekli: „Víš, že se farizejové urazili, když tě slyšeli?“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","On odpověděl: „S příkazy je to jako s rostlinami. Co nezasel můj Otec, je plevel a podle toho s tím bude naloženo. ");
INSERT INTO ceslb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nechte je! Jsou to slepí vůdcové slepých. Když slepý povede slepého, oba spadnou do jámy.“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petr se Ježíše zeptal: „Jak’s to myslel s tím, co nás špiní?“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ježíš se podivil: „Ani vy tomu nerozumíte? ");
INSERT INTO ceslb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nechápete, že všechno, co jíme, prochází vnitřnostmi a vychází z těla? ");
INSERT INTO ceslb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ale zlá slova vznikají ve zlém srdci, a tak špiní člověka. ");
INSERT INTO ceslb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ze srdce vycházejí špatné myšlenky na vraždu, nevěru, necudnost, krádež, lež a pomluvy. ");
INSERT INTO ceslb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","To jsou věci, které člověka zbavují vnitřní čistoty. Ale jíst nemytýma rukama, to člověka nepošpiní.“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ježíš odešel do týrského a sidónského kraje. ");
INSERT INTO ceslb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jedna obyvatelka těchto pohanských končin za ním přišla a prosila: „Slituj se nade mnou, Pane, ty očekávaný Králi! Moje dcera je posedlá démonem a velmi trpí!“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ale on na to nic neříkal. Jeho učedníci na něho naléhali: „Udělej s ní něco, vždyť za námi stále volá!“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tu se obrátil k té ženě a řekl jí: „Byl jsem poslán pomoci židům a ne pohanům.“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ale ona přišla až k němu, klaněla se mu a prosila: „Pane, pomoz mi!“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","„Není správné brát chléb dětem a házet ho štěňatům!“ řekl. ");
INSERT INTO ceslb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ona odpověděla: „Máš pravdu, ale štěňata dostávají zbytky ze stolů svých pánů.“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","„Ženo,“ řekl jí Ježíš, „máš velikou víru, tvoje přání je splněno!“ A od té chvíle byla její dcera zdravá. ");
INSERT INTO ceslb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pak se Ježíš vrátil a vystoupil na pahorek u jezera. ");
INSERT INTO ceslb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Spousta lidí se k němu začala scházet a měli s sebou chromé, zmrzačené, slepé, němé a jinak postižené. Pokládali je před něj a on je uzdravoval. ");
INSERT INTO ceslb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jaký div! Němí mluví, chromí chodí, zmrzačení jsou zdrávi a slepí vidí. Okolostojící nad tím žasli a vzdávali díky Bohu. ");
INSERT INTO ceslb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ježíš zavolal svoje učedníky a řekl jim: „Je mi těch lidí líto, vždyť tu jsou se mnou tři dny a nemají už nic k jídlu. Nechci je nechat odejít hladové, vždyť by ani nedošli domů!“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Učedníci odpověděli: „Kde v takové pustině vezmeme chléb pro tolik lidí?“ ");
INSERT INTO ceslb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","„Kolik jídla máte s sebou?“ zeptal se Ježíš. „Sedm chlebů a několik ryb,“ odpověděli učedníci. ");
INSERT INTO ceslb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ježíš rozkázal, aby se shromáždění lidé usadili. ");
INSERT INTO ceslb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Vzal těch sedm chlebů a ryby, poděkoval za ně Bohu; pak je lámal a dával učedníkům a ti je rozdávali shromážděným. ");
INSERT INTO ceslb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Najedlo se tam dosyta čtyři tisíce mužů kromě žen a dětí – a ještě sebrali sedm košíků zbytků. ");
INSERT INTO ceslb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pak se Ježíš s nimi rozloučil, vstoupil do člunu a přeplul do Magdalské krajiny. ");
INSERT INTO ceslb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jednou přišli za Ježíšem farizejové a saducejové a vymáhali na něm důkaz, že má Boží pověření. ");
INSERT INTO ceslb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","On jim na to odpověděl: „Když jsou večer červánky, říkáte, že bude jasno; ");
INSERT INTO ceslb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","když jsou červánky ráno, říkáte, že bude špatné počasí. Úkazy na obloze umíte posoudit, a to, co se děje před vašima očima, je vám pořád málo? ");
INSERT INTO ceslb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tento zlý, nevěřící národ se dožaduje zvláštních znamení, ale nakonec si bude muset vzpomenout, co se stalo s prorokem Jonášem,“ a nechal je stát a odešel. ");
INSERT INTO ceslb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Znovu se plavili přes jezero a teprve na druhém břehu jeho učedníci zjistili, že s sebou zapomněli vzít chleba. ");
INSERT INTO ceslb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ježíš jim řekl: „Dejte si pozor na farizejský a saducejský kvas!“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Oni se domnívali, že mluví o skutečném chlebu. ");
INSERT INTO ceslb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ježíš to věděl, a proto jim řekl: „Proč si děláte starosti o jídlo? To máte tak malou víru? ");
INSERT INTO ceslb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ještě nechápete? Cožpak si nevzpomínáte na nasycení pěti tisíc mužů pouhými pěti chleby a na koše posbíraných zbytků? ");
INSERT INTO ceslb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ani na ty čtyři tisíce, které jsem nasytil sedmi chleby a ještě se sebralo tolik zbytků? ");
INSERT INTO ceslb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nechápete, že mi nešlo o skutečný chleba, když jsem vás varoval před kvasem farizejů a saducejů?“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Teprve potom pochopili, že kvasem mínil pokřivené učení židovských vůdců. ");
INSERT INTO ceslb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Když se potom Ježíš přiblížil k Césareji Filipově, zeptal se svých učedníků: „Za koho mne lidé pokládají?“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Oni odpověděli: „Někteří za Jana Křtitele, druzí za Elijáše, jiní za Jeremjáše nebo jiného z proroků.“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","„A vy?“ chtěl Ježíš vědět. ");
INSERT INTO ceslb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Šimon Petr zvolal: „Ty jsi Kristus, Syn živého Boha!“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","„Raduj se, Šimone,“ řekl Ježíš. „To nemáš ze sebe, tu pravdu ti dal poznat sám Bůh. ");
INSERT INTO ceslb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","19","Ty jsi Petr a tvé jméno připomíná skálu. Svou církev zbuduji na Skále a žádná ďábelská moc ji nezničí. Kdekoliv se bude zvěstovat pravda, kterou jsi vyznal o mně, otevřou se lidem dveře do Božího království. Těm, kdo ji odmítnou, oznámíš soud, a ty, kdo ji přijmou, ujistíš o Boží milosti. Co se rozhodne zde na zemi, bude platit i v nebi.“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Svým učedníkům potom přikázal, aby zatím nikomu neříkali, že on je očekávaný Mesiáš. ");
INSERT INTO ceslb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Od toho dne začal Ježíš otevřeně mluvit se svými učedníky o tom, že musí jít do Jeruzaléma a co ho tam čeká – mnoho bude trpět od židovských náboženských vůdců, bude zabit, ale třetí den vstane zase k životu. ");
INSERT INTO ceslb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petr ho odvedl stranou a začal mu to rozmlouvat: „Takhle nemluv, nic takového nedopustíme.“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","On se však od Petra odvrátil a řekl: „Jdi mi z cesty, satane! Pokoušíš mne, protože to vidíš jen z lidského hlediska a ne z Božího!“ ");
INSERT INTO ceslb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Potom řekl učedníkům: „Kdo mě chce následovat, přestaň myslet na sebe, neboj se pro mne trpět a pojď za mnou. ");
INSERT INTO ceslb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Každý, kdo by si chtěl život zachovat pro sebe, ztratí ho. Kdo mi odevzdá svůj život, ten ho získá. ");
INSERT INTO ceslb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Co člověku prospěje, když získá celý svět a ten skutečný život ztratí? Co může vyvážit hodnotu věčného života? ");
INSERT INTO ceslb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Přijdu ve slávě svého Otce se svými anděly a tehdy budu soudit každého člověka podle toho, jak žil. ");
INSERT INTO ceslb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Někteří se ještě za svého života stanete svědky slávy a moci mého království.“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Po šesti dnech vzal s sebou Ježíš pouze Petra, Jakuba a jeho bratra Jana a vyšli na vysokou horu. ");
INSERT INTO ceslb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Náhle učedníci zpozorovali, že Ježíšův vzhled se změnil. Tvář mu oslnivě zářila jako slunce a jeho oděv se skvěl bělostí. ");
INSERT INTO ceslb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vtom uviděli Mojžíše a Elijáše, jak s ním rozmlouvají. ");
INSERT INTO ceslb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petr zvolal: „Pane, je nám tu tak dobře! Jestli chceš, postavíme vám tu přístřeší a zůstaňme tady!“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Než to však dořekl, zahalil je oblak a slyšeli hlas: „Toto je můj milovaný Syn, moje radost, toho poslouchejte!“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Když to učedníci slyšeli, padli k zemi s uctivou bázní. ");
INSERT INTO ceslb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ježíš k nim přišel, dotkl se jich a řekl: „Vstaňte a nebojte se!“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Když se rozhlédli, viděli pouze samotného Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cestou z hory jim Ježíš přikázal: „Nikomu neříkejte, co jste viděli, dokud nevstanu z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Učedníci se ho ptali: „Proč učitelé zákona zdůrazňují, že před tebou měl přijít Elijáš?“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ježíš jim odpověděl: „Mají pravdu. On má přijít a připravit lidská srdce na Kristův příchod. ");
INSERT INTO ceslb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Já vám však říkám, že Elijáš už přišel, ale oni ho neuznali a naložili s ním podle svého. A také pro mne chystají jen utrpení.“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Učedníci pochopili, že mluví o Janu Křtiteli. ");
INSERT INTO ceslb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na úpatí hory na ně čekal zástup lidí. Nějaký muž klekl před Ježíšem a řekl: ");
INSERT INTO ceslb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","„Pane, slituj se nad mým synem! Mnoho zkusí, má zlé záchvaty a při nich často spadne do ohně nebo do vody. ");
INSERT INTO ceslb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Prosil jsem tvé učedníky, ale nevědí si s ním rady.“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ježíš si povzdechl: „Co to s vámi je? Nevěříte a překážíte Boží moci! Nemám to s vámi lehké. Přiveďte mi ho sem!“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pak Ježíš přikázal démonu, který byl příčinou nemoci, aby chlapce opustil. A od té chvíle byl chlapec zdráv. ");
INSERT INTO ceslb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Když potom byli s Ježíšem sami, zeptali se učedníci: „Proč my jsme nemohli toho chlapce uzdravit?“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ježíš jim odpověděl: „Protože málo věříte. Budete-li mít víru alespoň jako semínko hořčice a řeknete této hoře: ‚Posuň se,‘ poslechne vás. Nic pro vás nebude nemožné. ");
INSERT INTO ceslb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Takový případ vyžaduje opravdovou modlitbu a půst.“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Když přišli do Galileje, Ježíš jim řekl: „Mám být vydán do rukou těch, ");
INSERT INTO ceslb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kteří mne zabijí. Ale třetího dne zase vstanu k životu.“ Učedníky to velmi zarmoutilo. ");
INSERT INTO ceslb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","V Kafarnaum přišli k Petrovi výběrčí chrámové daně a zeptali se: „Váš mistr neplatí daň?“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","„Platí,“ odpověděl Petr. Doma ho Ježíš předešel otázkou: „Co myslíš, Petře, od koho vybírají králové a panovníci daně a poplatky? Od synů nebo od cizích?“ ");
INSERT INTO ceslb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","„Od cizích,“ odpověděl Petr. ");
INSERT INTO ceslb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","„Dobře tedy,“ řekl Ježíš, „synové tedy nejsou vázáni touto povinností! Ale nebudeme Jeruzalém zbytečně dráždit. Jdi k jezeru, nahoď udici a v první rybě, kterou chytneš, najdeš minci. Ta bude stačit na poplatek za nás oba.“ ");
INSERT INTO ceslb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tehdy Ježíše obstoupili jeho učedníci a ptali se ho: „Kdo z lidí je v nebeském království nejpřednější?“ ");
INSERT INTO ceslb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zavolal malé dítě, postavil je mezi ně ");
INSERT INTO ceslb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a řekl: „Dobře mne poslouchejte: Půjde-li vám o přední místa, do Božího království se vůbec nedostanete. ");
INSERT INTO ceslb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ujišťuji vás, že jen s pokornou myslí dítěte tam můžete vejít a něco znamenat. ");
INSERT INTO ceslb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kdo si umí vážit takového nepatrného člověka, prokazuje tím úctu mně. ");
INSERT INTO ceslb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Na kom by ztroskotala víra jednoho z těchto maličkých ve mne, tomu by bylo lépe, kdyby ho hodili do moře s mlýnským kamenem na krku. ");
INSERT INTO ceslb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Běda světu, že se tu dějí věci, pro které člověk ztrácí víru. Pokušení jsou sice nevyhnutelná, ale běda tomu, kdo je působí. Neváhej odložit všechno, co tě odvádí od Boha. ");
INSERT INTO ceslb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","I kdyby to měla být tvá ruka nebo noha, raději ji utni a zahoď. Lépe je vkulhat do Božího království než skočit oběma nohama do záhuby. ");
INSERT INTO ceslb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A kdyby tě tvé oko svádělo ke zlému, zbav se ho! Je lepší získat věčný život jednooký než přijít s oběma očima do věčného zatracení. ");
INSERT INTO ceslb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Dejte pozor, abyste nepohrdli ani tím nejprostším člověkem. Věřte tomu, každý z nich má anděla, který ho stále zastupuje před Bohem. ");
INSERT INTO ceslb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Přišel jsem zachránit ztracené. ");
INSERT INTO ceslb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Když má někdo sto ovcí a jedna z nich se ztratí, co myslíte, že takový člověk udělá? Nenechá těch devadesát devět na pastvině a nepůjde hledat tu ztracenou? ");
INSERT INTO ceslb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A když ji najde, má z ní větší radost než z těch devadesáti devíti, které mu zůstaly. ");
INSERT INTO ceslb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","A právě tak můj Otec nechce, aby sebenepatrnější člověk zahynul. ");
INSERT INTO ceslb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Proviní-li se proti tobě někdo z věřících, vyhledej ho a promluv si s ním mezi čtyřma očima. Přizná-li svoji chybu, udělal sis z nepřítele znovu bratra. ");
INSERT INTO ceslb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bude-li neústupný, přizvi ještě jednoho nebo dva z věřících, aby byli svědky rozhovoru. ");
INSERT INTO ceslb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Když si ani tak nedá říci, pověz to shromáždění věřících. Když neuposlechne ani je, ať je vyloučen. ");
INSERT INTO ceslb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mějte přitom na mysli, že co rozhodnete zde na zemi, bude platit i v nebi. ");
INSERT INTO ceslb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A také platí: spojí-li se dva z vás k modlitbám za jakoukoliv záležitost, nebeský Otec je vyslyší. ");
INSERT INTO ceslb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tam, kde se už dva nebo tři sejdou, aby jednali podle mé vůle, tam jsem já s nimi.“ ");
INSERT INTO ceslb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Potom mu Petr položil otázku: „Pane, když se proti mně můj bližní opakovaně prohřešuje, kolikrát mu mám odpustit? Sedmkrát?“ ");
INSERT INTO ceslb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ježíš mu odpověděl: „Ne sedmkrát, ale až sedmdesátkrát sedmkrát. ");
INSERT INTO ceslb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Pán Bůh s námi jedná jako král, který se rozhodl provést vyúčtování se svými podřízenými. ");
INSERT INTO ceslb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mezi prvními mu přivedli jednoho, který měl u něj miliónový dluh. ");
INSERT INTO ceslb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ten muž však neměl na zaplacení. Král tedy nařídil, aby ho s celou rodinou prodali do otroctví, rozprodali jeho majetek, a tak uhradili dluh. ");
INSERT INTO ceslb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","On však před králem padl na kolena a prosil ho: ‚Pane, měj se mnou trpělivost a já všechno zaplatím!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Králi bylo líto toho člověka, propustil ho a dokonce mu celý dluh odpustil. ");
INSERT INTO ceslb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sotva však ten muž vyšel od krále, potkal člověka, který mu dlužil nepatrnou částku. Popadl ho a křičel: ‚Hned mi vrať, co jsi dlužen!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ten chudák si před něj klekl a zoufale ho prosil: ‚Měj strpení a já ti zaplatím!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ale věřitel stál na svém a dal ho zavřít do vězení, dokud dluh nezaplatí. ");
INSERT INTO ceslb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Svědky té události to pobouřilo a šli to oznámit králi. ");
INSERT INTO ceslb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ten si předvolal nemilosrdného věřitele a řekl mu: ‚Ty ničemo! Jak velký dluh jsem ti odpustil, když jsi mne prosil! ");
INSERT INTO ceslb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A tys nemohl odpustit svému druhovi tak směšnou částku?‘ ");
INSERT INTO ceslb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A rozhněvaný král jej potom dal zavřít, dokud svůj dluh do posledního haléře nezaplatí. ");
INSERT INTO ceslb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tak bude jednat můj nebeský Otec s vámi, jestliže nebudete ochotně odpouštět druhým.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Po tomto hovoru Ježíš odešel do Judska za Jordánem. ");
INSERT INTO ceslb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mnoho lidí šlo za ním a on uzdravoval nemocné. ");
INSERT INTO ceslb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Přišli za ním i farizejové a chtěli ho vyprovokovat k nějakému výroku, který by mohli použít proti němu. „Může se člověk rozvést z jakéhokoliv důvodu?“ zeptali se. ");
INSERT INTO ceslb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","6","On odpověděl: „Nečetli jste v Písmu, že když na počátku Bůh stvořil muže a ženu, ustanovil: Muž opustí své rodiče, připojí se ke své ženě a stanou se jednou bytostí? Nikdo nemá právo rozdělit to, co Bůh spojil.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Oni však namítali: „Proč tedy Mojžíš řekl, že muž může propustit manželku jednoduše tím, že jí dá rozlukový lístek?“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ježíš odpověděl: „Toto ustanovení Mojžíšova zákona je ústupkem vaší tvrdosti a nesnášenlivosti. Původní Boží úmysl to však nikdy nebyl. ");
INSERT INTO ceslb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Já vám říkám, že kdo se rozvádí z jiného důvodu, než je cizoložství jeho partnera, a uzavírá nový sňatek, dopouští se sám cizoložství.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Učedníci mu řekli: „Když mohou nastat takové těžkosti mezi mužem a ženou, pak je lepší se neženit.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","On odpověděl: „Tak jednoduché to není. Je zde nutné porozumět Boží vůli. ");
INSERT INTO ceslb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jsou tři důvody proto, aby člověk zůstal svobodný: když je k manželství od narození nezpůsobilý, když mu v uzavření sňatku zabránili lidé, nebo když se manželství zřekne dobrovolně pro plnou službu Boží věci. Rozumíte tomu?“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Potom k Ježíšovi nosili malé děti, aby jim žehnal a modlil se za ně. Učedníci však domlouvali těm, kteří děti přivedli, aby Ježíše neobtěžovali. ");
INSERT INTO ceslb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","On jim ale řekl: „Nechte je, ať jdou ke mně, a nebraňte jim. Jejich místo je u mne.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kladl na ně ruce a žehnal jim. Pak odtud odešel. ");
INSERT INTO ceslb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Za Ježíšem přišel jeden mladý člověk a ptal se ho: „Mistře, jakými dobrými skutky mohu získat věčný život?“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ježíš mu na to řekl: „Snažíš se být dobrý? To se chceš vyrovnat Bohu, který jediný je skutečně dobrý! Plň jeho přikázání a budeš věčně živ.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","„Která to jsou?“ zeptal se mladý muž. Ježíš odpověděl: „Nezabiješ, nezcizoložíš, nebudeš krást, lhát, ");
INSERT INTO ceslb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","budeš ctít svoje rodiče, své bližní budeš milovat jako sebe!“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mladík na to řekl: „To všechno jsem vždycky dodržoval. Co mi ještě chybí?“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ježíš odpověděl: „Chceš-li být dokonalý, jdi a prodej celý svůj majetek a peníze rozdej chudým, a tak budeš mít poklad v nebi. Pak se vrať a staň se mým učedníkem.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mladík zesmutněl a zklamaně odešel. Měl totiž velký majetek. ");
INSERT INTO ceslb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ježíš pak řekl svým učedníkům: „Pro zámožného člověka je velmi nesnadné postavit se na Boží stranu. ");
INSERT INTO ceslb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kdybych to měl k něčemu přirovnat, pak snáze projde velbloud uchem jehly, nežli bohatý branou Božího království.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Učedníky to překvapilo a ptali se: „Kdo tedy vůbec může být spasen?“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ježíš se na ně zadíval a řekl: „V lidských silách to není, ale Bůh dokáže všechno.“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petr se ozval a řekl: „My jsme se vzdali všeho a jdeme za tebou. Co nás čeká?“ ");
INSERT INTO ceslb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ježíš odpověděl: „Ujišťuji vás, že až přijdu, abych stvořil nový svět, nad kterým budu panovat v plné slávě, pak vás dvanáct, kteří mne následujete, posadím po svém boku jako soudce celého Izraele. ");
INSERT INTO ceslb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A každému, kdo se vzdá domova, bratrů, sester, otce, matky, manželky, dětí nebo majetku proto, aby šel za mnou, všechno mu mnohokrát vynahradím a bude mít podíl na věčném životě. ");
INSERT INTO ceslb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mnozí první budou poslední a poslední budou první. ");
INSERT INTO ceslb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Když Bůh dává podíl na věčném životě, jedná jako vi nař, který časně najal dělníky k práci na své vinici ");
INSERT INTO ceslb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","a dohodl se s nimi na denní mzdě ve výši jednoho stříbrňáku. ");
INSERT INTO ceslb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dopoledne šel opět okolo místa, kde se najímaly pracovní síly, a uviděl tam stát ještě jiné, kteří čekali na práci. ");
INSERT INTO ceslb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Řekl jim tedy: ‚Jděte i vy na mou vinici a dostanete mzdu, která vám náleží.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A oni šli. Potom šel znovu na to místo v poledne a opět odpoledne a najal další dělníky. ");
INSERT INTO ceslb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","K večeru tam uviděl postávat jiné a zeptal se jich: ‚Proč tu tak nečinně stojíte celý den?‘ ");
INSERT INTO ceslb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‚Nikdo nás nenajal k práci,‘ odpověděli. On jim na to řekl: ‚Jděte také na mou vinici a dostanete spravedlivou mzdu.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Večer potom vinař nařídil svému správci: ‚Zavolej dělníky a zaplať jim za práci. Začni u těch, kteří přišli poslední.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ti, kteří nastoupili do práce až večer, dostali po stříbrňáku. ");
INSERT INTO ceslb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dělníci, kteří pracovali od rána, si mysleli, že dostanou víc. Dostali však stejnou mzdu. ");
INSERT INTO ceslb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Vzali ji, ale protestovali: ");
INSERT INTO ceslb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‚Ti, co přišli poslední, pracovali jenom hodinu a dostali stejně jako my, kteří jsme dřeli celý den v slunečním žáru!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Majitel vinice se obrátil k jednomu z nich a řekl: ‚Příteli, nekřivdím ti! Což jsme se předem nedohodli na denní mzdě? ");
INSERT INTO ceslb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Dostal jsi svoje, a tak buď spokojený. Když chci zaplatit všem stejně, je to přece moje věc. Nebo chceš závidět, že jsem štědrý?‘ ");
INSERT INTO ceslb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","A tak poslední na tom budou jako první a první jako pos-lední.“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Během cesty do Jeruzaléma si Ježíš vzal stranou svých dvanáct učedníků a mluvil s nimi o tom, co ho tam čeká: ");
INSERT INTO ceslb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","„Vstupujeme do Jeruzaléma, kde budu zrazen a vydán do rukou velekněžím a židovským právníkům. Ti mne odsoudí k smrti ");
INSERT INTO ceslb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","a vydají Římanům, aby mě zesměšnili, zbičovali a ukřižovali. Třetího dne však vstanu opět k životu.“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","21","K Ježíšovi přišla Zebedeova manželka se svými syny Jakubem a Janem. Po uctivém pozdravu mu přednesla své přání: „Slib mi, že až se ujmeš vlády, dáš mým synům nejčestnější místa po svém boku.“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ale Ježíš na to řekl: „Nevíte, co chcete! Můžete pít z kalicha utrpení, který je připraven pro mne?“ Oni odpověděli: „Můžeme!“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ježíš jim řekl: „Z mého kalicha pít budete, avšak čestná místa po mé pravici a levici neurčuji já, ale můj Otec.“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ostatních deset slyšelo tu rozmluvu a zlobili se na ty dva. ");
INSERT INTO ceslb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ale Ježíš je zavolal všechny k sobě a řekl: „Víte, že panovníci vládnou těm, kteří jsou jim podřízení, a kdo má moc, dává ji pociťovat ostatním. ");
INSERT INTO ceslb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Mezi vámi to však musí být jiné. Kdo chce být velký, ať je vaším služebníkem, a kdo chce být mezi vámi první, ať slouží bez nároku všem. ");
INSERT INTO ceslb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ani já jsem nepřišel, abych si dal sloužit, ale abych sloužil a obětoval svůj život jako výkupné za mnohé.“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Když prošli Jerichem, táhl se za Ježíšem velký dav. ");
INSERT INTO ceslb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tam u cesty seděli dva slepci. Když uslyšeli, kdo jde kolem, začali křičet: „Pane, králi Izraele, smiluj se nad námi!“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lidé z davu je okřikovali. Ale oni tím více volali: „Pane, králi Izraele, slituj se nad námi!“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ježíš se zastavil zavolal je k sobě a zeptal se jich: „Co chcete, abych pro vás udělal?“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Oni odpověděli: „Pane, chceme vidět!“ ");
INSERT INTO ceslb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ježíšovi jich bylo líto. Dotkl se jejich očí a oni v tom okamžiku prohlédli. Pak šli za Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Když se blížili k Jeruzalému a přišli do Betfage u Olivové hory, poslal Ježíš dva ze svých učedníků napřed ");
INSERT INTO ceslb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a řekl jim: „Jakmile přijdete do vesnice tady před námi, najdete přivázanou oslici s oslátkem. Odvažte je a přiveďte mi je. ");
INSERT INTO ceslb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","4","Kdyby se vás někdo ptal, co děláte, řekněte, co předpověděl prorok: ");
INSERT INTO ceslb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‚Oznamte Jeruzalému: Tvůj král přichází k tobě, tichý, přijíždí na oslátku.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Učedníci šli a udělali vše podle Ježíšova příkazu. ");
INSERT INTO ceslb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Přivedli oslici i oslátko, místo sedla podložili své pláště a na ně posadili Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mnozí z davu pokládali své pláště na cestu, jiní osekávali větve ze stromů a zdobili jimi cestu. ");
INSERT INTO ceslb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Průvod lidí, který ho obklopoval zepředu i zezadu, volal: ");
INSERT INTO ceslb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Když vjel do Jeruzaléma, celé město vřelo a lidé se vzrušeně ptali: „Kdo je to?“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Z průvodu se ozývalo: „To je Ježíš, ten prorok z galilejského Nazaretu!“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ježíš pak vešel do chrámu a vyhnal všechny, kteří tu prodávali a kupovali, zpřevracel stoly směnárníků a prodavačů obětních holubů ");
INSERT INTO ceslb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","a řekl jim: „Písmo praví: Boží chrám je místem pro modlitbu, ale vy jste z něj udělali zlodějské doupě!“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na chrámovém nádvoří se kolem něj shlukli slepí a chromí a on je uzdravoval. ");
INSERT INTO ceslb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Když však velekněží a vykladači zákona viděli ty zázraky a slyšeli, jak i malé děti volají v chrámu: „Sláva Davidovu synu!“ velmi je to pobouřilo. ");
INSERT INTO ceslb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Vyčítali mu: „Neslyšíš, co volají?“ On jim odpověděl: „Ovšem. Což jste nečetli v Písmu: I křik nemluvňat chválí Boha.“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nechal je být a odešel zpět do Betanie, kde zůstal přes noc. ");
INSERT INTO ceslb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Když se ráno vracel do Jeruzaléma, dostal hlad. ");
INSERT INTO ceslb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Všiml si fíkovníku u cesty. Když však přišel ke stromu, viděl, že na něm nejsou žádné plody, ale jen listí. Řekl: „Už nikdy se na tobě neurodí ovoce!“ A ten fíkovník rázem uschl. ");
INSERT INTO ceslb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Když to viděli učedníci, udiveně říkali: „Jak jsi to dokázal, že ten fíkovník tak rychle uschl?“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ježíš jim odpověděl: „Skutečně vám říkám, věříte-li bez pochybností, můžete dělat i větší věci než to, co jste nyní viděli. Kdybyste rozkázali této hoře, aby se pohnula a sesula do moře, pak se to stane. ");
INSERT INTO ceslb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Všechno je pro vás dosažitelné, zač se s vírou modlíte.“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Když pak zas učil v chrámu, přišli k němu velekněží a židovští předáci a ptali se ho: „Jakým právem zde takto jednáš? Kdo ti k tomu dal moc?“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","26","„Řeknu vám to, ale nejprve odpovězte vy na moji otázku: Křtil Jan z pověření Boha nebo lidí?“ Říkali si mezi sebou: „Odpovíme-li, že byl od Boha, namítne nám, proč jsme tedy nevěřili jeho slovům. A jestliže odpovíme záporně, pak abychom se báli davu, protože Jana všichni považují za proroka.“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tak nakonec odpověděli: „Nevíme.“ Nato Ježíš: „Ani já vám tedy neřeknu, kdo stojí za mnou. ");
INSERT INTO ceslb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jak byste rozsoudili takový případ? Jeden muž měl dva syny a řekl jednomu z nich: ‚Jdi dnes pracovat na vinici!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","On však odpověděl: ‚Nechce se mi!‘ Potom si to ale rozmyslel a šel. ");
INSERT INTO ceslb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","O totéž požádal druhého syna. Ten řekl: ‚Ano, půjdu,‘ ale nešel. ");
INSERT INTO ceslb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Který z těch dvou synů poslechl svého otce?“ Oni odpověděli: „Ten první.“ „Právě tak,“ řekl Ježíš, „vás podvodníci a prostitutky předbíhají do Božího království. ");
INSERT INTO ceslb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jan Křtitel vám ukázal správnou cestu k pokání; vy jste na něj nedali, ale tihle lidé ano. Ani to vás nezahanbilo a stejně jste neposlechli. ");
INSERT INTO ceslb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nyní si poslechněte jiný příběh: Byl jeden hospodář, který založil vinici. Obehnal ji plotem, zřídil v ní lis a postavil věž pro hlídače. Pak vinici pronajal vinařům a odcestoval. ");
INSERT INTO ceslb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","V době vinobraní poslal k vinařům své zástupce, aby vybrali jeho podíl. ");
INSERT INTO ceslb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","36","Vinaři je však popadli, jednoho zbili, druhého utloukli a dalšího ukamenovali. Hospodář tedy poslal další muže; tentokrát jich bylo více. Ale vinaři s nimi naložili stejně. ");
INSERT INTO ceslb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nakonec k nim tedy poslal svého syna. Myslel si, že alespoň před ním budou mít respekt. ");
INSERT INTO ceslb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ale když jej viděli přicházet, řekli si: ‚To je dědic! Zabijme ho a vinice bude naše!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Popadli ho, vyvlekli z vinice ven a zabili. ");
INSERT INTO ceslb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Co myslíte, že udělá hospodář s těmi vinaři, až se vrátí?“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Odpověděli mu: „Ty zločince dá bez milosti popravit a vinici pronajme lidem, kteří mu budou svědomitě odvádět výnosy.“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Potom se jich Ježíš zeptal, zda znají slova Písma: „Kámen, který stavitelé neustále odkládali, sloužil nakonec jako hlavní svorník klenby. Jaký to div! Jak zvláštní věc Bůh udělal!“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","„Chci tím říci, že vám Bůh odejme správu nad svým královstvím a svěří ji lidem, kteří mu budou odvádět, co mu patří. ");
INSERT INTO ceslb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kdo ten kámen nedá na pravé místo, zakopne o něj, nebo ho kámen rozdrtí.“ ");
INSERT INTO ceslb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Když velekněží a farizejové slyšeli tyto příměry, pochopili, že mluví o nich. ");
INSERT INTO ceslb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chtěli ho zatknout, ale báli se davu, protože všichni považovali Ježíše za proroka. ");
INSERT INTO ceslb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ježíš jim vyprávěl další příběh: ");
INSERT INTO ceslb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","„Když Bůh nabízí účast ve svém království, je jako král, který připravil velkou hostinu při svatbě svého syna. ");
INSERT INTO ceslb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pozvaných bylo mnoho, ale když pro ně přišli královi poslové, odmítli pozvání. ");
INSERT INTO ceslb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Král k nim poslal ještě jednou se vzkazem: ‚Je pro vás připravena bohatá hostina, přijďte!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Ale pozvaní to vůbec nebrali vážně. Jeden šel za prací na své pole, jiný za obchodem, někteří se dokonce králových poslů zmocnili, ztýrali je a několik jich zabili. ");
INSERT INTO ceslb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","To krále popudilo, poslal vojsko, dal ty ukrutníky pobít a město vypálit. ");
INSERT INTO ceslb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Potom řekl svým poslům: ‚Hostina je připravena, ale svatební hosté jí nebyli hodni. ");
INSERT INTO ceslb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jděte na rozcestí a pozvěte na svatbu každého, koho potkáte.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Poslové tedy šli a přivedli všechny, které našli, ubohé i slušné, takže svatební síň se zaplnila. ");
INSERT INTO ceslb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Když vstoupil král, aby hosty přivítal, uviděl jednoho, který nepřijal svatební oděv. ");
INSERT INTO ceslb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Řekl mu: ‚Člověče, jak jsi se odvážil vejít bez svatebních šatů?‘ On mlčel. ");
INSERT INTO ceslb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Král pak rozkázal sluhům: ‚Svažte ho a vyhoďte ven do tmy, kde bude jen nářek a utrpení. ");
INSERT INTO ceslb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mnoho je pozvaných, ale těch, kteří skutečně vejdou, je málo.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farizejové se sešli, aby se domluvili na taktice, jak Ježíše chytit do léčky. Chtěli ho vyprovokovat k slovům, kterých by pak mohli použít k obžalobě. ");
INSERT INTO ceslb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Poslali k němu své žáky spolu s Herodovými stoupenci a ti řekli: „Mistře, víme, že jsi čestný a že pravdivě učíš cestě k Bohu, bez ohledu na to, jaké kdo má postavení. ");
INSERT INTO ceslb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Řekni nám: Je správné odvádět římské vládě daň?“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ježíš však prohlédl jejich zlý úmysl. „Vy pokrytci!“ zvolal. „Proč se mne snažíte nachytat takovými otázkami? ");
INSERT INTO ceslb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ukažte mi minci!“ Oni mu podali denár. ");
INSERT INTO ceslb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","„Čí obraz a jméno je na něm vyraženo?“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","„Císaře,“ odpověděli. On jim na to řekl: „Co je tedy císařovo, dávejte císaři, a co je Boží, dávejte Bohu.“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Zaskočeni tou odpovědí, odešli. ");
INSERT INTO ceslb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Také za ním přišli saducejové, kteří tvrdí, že vzkříšení z mrtvých je nemožné. Předložili mu nepravděpodobný příběh: ");
INSERT INTO ceslb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","„Mistře, v Mojžíšově zákoně čteme, že svobodný švagr je povinen vzít si bezdětnou vdovu po svém bratru, aby v dětech zachoval bratrovo jméno. ");
INSERT INTO ceslb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","U nás se vyskytl tento případ: Bylo sedm bratrů. První z nich se oženil a potom jako bezdětný zemřel, takže jeho žena se stala manželkou druhého bratra. ");
INSERT INTO ceslb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tento bratr také zemřel bez dětí, a tak se opakovalo u druhého, třetího – a nakonec u všech sedmi bratrů. ");
INSERT INTO ceslb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Poslední ze všech zemřela i ta žena. ");
INSERT INTO ceslb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kterému z těch bratrů bude patřit po vzkříšení? Byla přece manželkou všech sedmi!“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ježíš odpověděl: „Mluvíte nesmysly, protože neznáte ani Písmo ani Boží moc. ");
INSERT INTO ceslb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Po vzkříšení zaniknou tělesné vztahy. Lidé nebudou žít v manželství, ale budou tvořit Boží rodinu. ");
INSERT INTO ceslb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A pokud jde o vzkříšení z mrtvých, pak čtěte pozorně Písmo. Jak nazývá Bůh sám sebe? ");
INSERT INTO ceslb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Bůh Abrahamův, Izákův a Jákobův. On není Bohem mrtvých, ale živých.“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tyto Ježíšovy odpovědi udělaly na lidi hluboký dojem. ");
INSERT INTO ceslb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farizejové se doslechli, jak Ježíš umlčel saduceje. ");
INSERT INTO ceslb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pověřili jednoho ze svých vykladačů Písma, aby ho vyzkoušel: ");
INSERT INTO ceslb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","„Mistře, které přikázání je v zákoně nejvýznamnější?“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ježíš mu odpověděl: „ ‚Miluj Pána, svého Boha, celým srdcem, duší i myslí.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","To je první a nejdůležitější přikázání. ");
INSERT INTO ceslb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Druhé v pořadí důležitosti je toto: ‚Miluj svého bližního jako sám sebe.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na těch dvou přikázáních stojí celý Mojžíšův zákon a odkaz proroků.“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Potom Ježíš, obklopen farizeji, se jich zeptal: ");
INSERT INTO ceslb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","„Co si myslíte o Kristu? Čí je to syn?“ Odpověděli: „Davidův.“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","On na to řekl: „Jak by mohl David svého vlastního potomka nazývat Pánem? Vždyť o něm z podnětu Ducha svatého píše v žalmu: ");
INSERT INTO ceslb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‚Bůh řekl mému Pánu: Seď po mé pravici, dokud ti nepodložím tvé nepřátele k nohám.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jestliže ho tedy David nazývá svým Pánem, jak může být jeho synem?“ ");
INSERT INTO ceslb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na to nikdo nedovedl odpovědět a už se mu neodvážili klást další otázky. ");
INSERT INTO ceslb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ježíš oslovil shromážděné lidi a učedníky: ");
INSERT INTO ceslb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","„Učitelé a farizejové jsou tu od toho, aby vám vykládali Mojžíšův zákon. ");
INSERT INTO ceslb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Poslouchejte všechny jejich příkazy. Avšak neřiďte se příkladem jejich života, protože oni jen mluví, ale v životě to neuplatňují. ");
INSERT INTO ceslb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vkládají na vás těžká břemena svých požadavků, ale svoje vlastní ústupky dovedou omluvit. ");
INSERT INTO ceslb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Všechno, co dělají, je jen na efekt. Aby vypadali svatě, pořizují si nápadné odznaky své zbožnosti, ");
INSERT INTO ceslb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","rádi sedávají na čestných místech na hostinách a mají vyhrazená místa při bohoslužbách. ");
INSERT INTO ceslb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jak mají rádi, když je lidé zdraví na veřejných místech a když je oslovují ‚Mistře‘! ");
INSERT INTO ceslb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ale vy se tak titulovat nedávejte, protože jenom jeden je váš Mistr a vy všichni jste navzájem bratři. ");
INSERT INTO ceslb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A nikomu z lidí nedávejte titul Otec, protože máte jediného Otce, a ten je v nebi. ");
INSERT INTO ceslb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ani se nepovažujte za svrchovanou autoritu, protože tou je jedině Kristus. ");
INSERT INTO ceslb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Největší mezi vámi je ten, kdo všem slouží. ");
INSERT INTO ceslb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kdo má o sobě příliš dobré mínění, bude zklamán a snížen. Pokorní však budou povýšeni. ");
INSERT INTO ceslb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Běda vám, učitelé zákona a farizejové, pokrytci! Zavíráte lidem vstup do Božího království. Sami do něho nevcházíte a těm, kteří by tam chtěli vejít, bráníte. ");
INSERT INTO ceslb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pod pláštíkem dlouhých a okázalých modliteb jste schopni vymámit peníze i od vdov. Těžko vám bude na soudu! ");
INSERT INTO ceslb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Běda vám, pokrytci! Kraj světa projdete, abyste obrátili jednoho člověka na víru, ale sotva uvěří, zavalíte ho svými předpisy. Jestliže ho předtím čekalo zatracení, vaším přičiněním ho čeká dvojnásob. ");
INSERT INTO ceslb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Běda vám! Chcete vést druhé a sami nevidíte na krok. Stanovili jste: přísaha na chrám nezavazuje, ale teprve přísaha na chrámové zlato platí. ");
INSERT INTO ceslb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Není to nesmysl? Co je víc? To zlato nebo chrám, který mu dodává posvátnost? ");
INSERT INTO ceslb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A další váš vynález: přísaha na obětní oltář nic neznamená, zatímco přísaha na oběť se musí plnit. Jak jste na to mohli přijít? ");
INSERT INTO ceslb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Co je víc? Oběť nebo oltář? Teprve položením na oltář se oběť stává obětí. ");
INSERT INTO ceslb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kdo tedy přísahá při oltáři, přísahá i při všem, co na něm leží. ");
INSERT INTO ceslb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","22","Ať tedy přísaháte na chrám, na nebe nebo na Boží trůn, přísaháte ve skutečnosti na Boha, který tomu všemu dává smysl. ");
INSERT INTO ceslb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Běda vám, vykladači zákona a farizejové, pokrytci. Do chrámu dáváte desetinu i z úrody máty, kopru a kmínu, ale nedbáte na to, co Bůh považuje za důležité: abyste jednali podle jeho práva, milosrdně a s vírou. Odvádějte desátky, ale nezanedbávejte to nejdůležitější! ");
INSERT INTO ceslb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Slepí vůdcové! Dáváte si pozor, abyste nespolkli komára, ale zhltnete velblouda! ");
INSERT INTO ceslb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Běda vám, pokrytci! Omýváte nádobí na povrchu a vnitřek plníte tím, co jste ve své chamtivosti nahrabali. ");
INSERT INTO ceslb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Slepý farizeji, vyčisti nejdříve vnitřek nádoby, jedině tak bude opravdu čistá. ");
INSERT INTO ceslb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Běda vám, vy pokrytci! Podobáte se ozdobeným hrobům: zevnějšek je pěkný, ale uvnitř jsou jen kosti mrtvých a práchnivina. ");
INSERT INTO ceslb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zdáte se být svatí, ale v nitru jste samá přetvářka. ");
INSERT INTO ceslb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Běda vám, vy neviňátka! Stavíte náhrobky prorokům, které zabili vaši předkové, zdobíte hroby mučedníků ");
INSERT INTO ceslb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","a říkáte: ‚Kdybychom my žili v době našich otců, nejednali bychom tak!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nic si nenamlouvejte, jste pravými potomky těch, kteří zabíjeli proroky. ");
INSERT INTO ceslb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jděte v jejich šlépějích a dovršte jejich dílo! ");
INSERT INTO ceslb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","34","Vy si myslíte, že ujdete ohni Božího soudu? Jako jedovatí hadi číháte na proroky, pravé učitele a vykladače Písma, kteří k vám přicházejí z mého pověření. Budete je bičovat ve svých synagogách a pronásledovat od města k městu, některé z nich zavraždíte, jiné ukřižujete. ");
INSERT INTO ceslb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na vás padne vina za všechnu prolitou krev nevinných, počínaje od Ábela až po posledního mučedníka pro Boží věc, kterého připravíte o život. ");
INSERT INTO ceslb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Skutečně vám říkám, že to všechno padne na hlavu této generace. ");
INSERT INTO ceslb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jeruzaléme, Jeruzaléme, město, které zabíjíš proroky a kamenuješ ty, kteří jsou k tobě posláni! Jak často jsem toužil shromáždit vás, jako kvočna ukrývá svá kuřátka pod křídla, ale nechtěli jste. ");
INSERT INTO ceslb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Proto nyní odcházím z vašeho chrámu ");
INSERT INTO ceslb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","a se mnou odchází vaše naděje. Teprve až se vrátím, pochopíte a vyznáte: ‚Požehnaný, který přichází ve jménu Božím!‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pak Ježíš vyšel z chrámu. Učedníci ho dostihli a poukazovali mu na velkolepost staveb v chrámu. ");
INSERT INTO ceslb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ale on jim řekl: „Vidíte to všechno? Pamatujte si, že to bude naprosto zničeno, nezůstane kámen na kameni.“ ");
INSERT INTO ceslb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","„Kdy se to stane?“ vrátili se k Ježíšovým slovům učedníci, když se posadili na Olivové hoře. „Které události ohlásí tvůj příchod a konec světa?“ ");
INSERT INTO ceslb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ježíš jim odpověděl: „Mějte se na pozoru, nenechte se někým oklamat. ");
INSERT INTO ceslb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Někteří se prohlásí za vykupitele a svedou mnohé tím, že budou tvrdit: ‚Já zachráním svět.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Když uslyšíte o válkách daleko i blízko, nebojte se. Ty musí přijít, ale nebude to ještě konec. ");
INSERT INTO ceslb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Národy se znepřátelí a státy se budou vzájemně napadat. Na mnoha místech vypukne hlad, rozšíří se nemoci a nastanou přírodní katastrofy. ");
INSERT INTO ceslb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ale to bude jen počátek hrůz. ");
INSERT INTO ceslb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tehdy budete pro víru ve mne všude nenáviděni, trýzněni i zabíjeni. ");
INSERT INTO ceslb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mnozí toto násilí nevydrží, zradí víru i své spolubratry a navzájem se budou nenávidět. ");
INSERT INTO ceslb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Objeví se také nemálo falešných proroků, jimž mnozí podlehnou. ");
INSERT INTO ceslb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na světě se natolik rozmůže zlo, že udusí lásku mnohých. ");
INSERT INTO ceslb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ale ten, kdo vytrvá až do konce, bude zachráněn. ");
INSERT INTO ceslb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Než však nastane konec, musejí se lidé všech národů dovědět potěšující zprávu, že Bůh v tomto světě vládne, zve všechny k sobě a plně uplatní svou moc. ");
INSERT INTO ceslb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Až uvidíte, že Jeruzalému hrozí zneuctění od pohanů, jak to předpověděl prorok Daniel, ");
INSERT INTO ceslb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","pak utečte z Judska do hor; ");
INSERT INTO ceslb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","18","kdo bude mimo dům nebo při práci, ať se pro nic domů nevrací. ");
INSERT INTO ceslb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Zle na tom budou v těch dnech těhotné a kojící ženy. ");
INSERT INTO ceslb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Modlete se, aby váš útěk nepřišel v zimním období dešťů nebo v době sobotního klidu. ");
INSERT INTO ceslb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","22","Přijde velké utrpení, jaké dosud nebylo a už nebude. Ale kvůli svému lidu Bůh to těžké období zkrátí. Kdyby tak neučinil, žádný by to nepřečkal. ");
INSERT INTO ceslb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Uslyšíte-li: ‚Tady je Kristus, nebo tam je,‘ nevěřte. ");
INSERT INTO ceslb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vystoupí totiž falešní Kristové a proroci a předvedou tak ohromující a přitažlivé činy, že by málem na svou stranu získali i moje vyvolené. ");
INSERT INTO ceslb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pamatujte na tato má varování. ");
INSERT INTO ceslb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A tak když vám budou říkat, že Kristus je už zde, v pustině nebo v úkrytu, nevěnujte tomu pozornost, ani se nechoďte o tom přesvědčit. ");
INSERT INTO ceslb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Skutečný příchod Syna člověka bude viditelný jako blesk, který proletí celou oblohou od východu k západu. ");
INSERT INTO ceslb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Znamení jeho příchodu se budou hromadit, tak jako se rozrůstá hejno supů kroužících nad kořistí. ");
INSERT INTO ceslb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","A hned po tom velkém utrpení se zatmí slunce a měsíc a nastane neobvyklý pohyb nebeských těles. ");
INSERT INTO ceslb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pak se objeví poslední signály mého příchodu na obloze. Všichni lidé budou zděšeni a uvidí mne přicházet s mocí a velkou slávou. ");
INSERT INTO ceslb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pošlu své posly s mohutným zvukem polnice a ti shromáždí mé věrné ze všech světových stran. ");
INSERT INTO ceslb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Poučte se z tohoto přirovnání: Když se větve fíkovníku nalévají mízou a nasazují listy, víte, že brzy bude léto. ");
INSERT INTO ceslb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Podobně když uvidíte, že se plní, co jsem předpověděl, poznáte, že jsem blízko, ve dveřích. ");
INSERT INTO ceslb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Říkám vám, že lidstvo nevyhyne a dočká se splnění všech těchto věcí. ");
INSERT INTO ceslb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nebe a země pominou, ale moje slova budou platit věčně. ");
INSERT INTO ceslb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ten den a hodinu nezná nikdo, ani andělé v nebi. Pouze sám Otec to ví. ");
INSERT INTO ceslb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Můj druhý příchod bude připomínat dobu Noeho. ");
INSERT INTO ceslb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lidé tehdy na nic nedbali, starali se jen o jídlo a pití, ženili se, vdávaly se až do dne, kdy Noe vstoupil do korábu. ");
INSERT INTO ceslb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Potopa je zachvátila, ačkoliv nevěřili, že by se něco takového mohlo stát. Tak to bude i při mém příchodu. ");
INSERT INTO ceslb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dva budou spolu pracovat na poli, jeden z nich bude vzat, druhý zanechán. ");
INSERT INTO ceslb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dvě ženy budou pracovat v jedné domácnosti, jedna bude vzata, druhá zanechána. ");
INSERT INTO ceslb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","A tak buďte připraveni, protože nevíte, kdy váš Pán přijde. ");
INSERT INTO ceslb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Je jasné, že kdyby hospodář věděl, že v noci přijde zloděj, byl by vzhůru a zabránil by vloupání. ");
INSERT INTO ceslb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Stejně i vy musíte být na můj příchod stále připraveni. Přijdu, kdy se toho nenadějete. ");
INSERT INTO ceslb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jak se chová věrný a prozíravý služebník, kterého pán pověřil správou služebnictva? ");
INSERT INTO ceslb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pochválen bude tehdy, když pán při svém návratu shledá, že věrně plnil svěřené povinnosti. ");
INSERT INTO ceslb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Takového pak ustanoví správcem celého svého majetku. ");
INSERT INTO ceslb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Špatný služebník by si řekl: ‚Pán dlouho nejde,‘ ");
INSERT INTO ceslb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","začal by týrat své druhy a hodovat s opilci. ");
INSERT INTO ceslb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Tu se pán neočekávaně vrátí a potrestá ho jako nejhoršího podvodníka. Nezbude mu nic než zoufalství.“ ");
INSERT INTO ceslb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","„Můj druhý příchod se bude v určitém smyslu podobat svatbě. Ti, kteří mne budou očekávat, jsou jako deset družiček, které vyhlížely ženicha, aby ho přivítaly světlem svých lamp. ");
INSERT INTO ceslb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Jenom pět z nich bylo prozíravých a vzalo si s sebou nádobky s olejem na doplnění svítilen. Ostatní dívky na to lehkomyslně zapomněly. ");
INSERT INTO ceslb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ženich dlouho nešel, a tak všechny družičky zmohla únava a usnuly. ");
INSERT INTO ceslb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","O půlnoci je vytrhl ze spánku křik: ‚Ženich jde! Pojďte ho přivítat!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","8","Dívky vyskočily a rychle si upravovaly svítilny. Ty lehkomyslné, které si nevzaly dost oleje, žadonily na ostatních: ‚Dejte nám trochu svého oleje, světlo nám již zhasíná!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ale ty rozumné jim odpověděly: ‚Když se rozdělíme, nevystačí olej nám ani vám. Zkuste to raději u kupce!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sotva však odběhly pro olej, přišel ženich a ty dívky, které byly připraveny, šly s ním na svatební hostinu. ");
INSERT INTO ceslb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dalších pět družiček přišlo už k zavřeným dveřím. Volaly: ‚Pane, otevři nám!‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ale on odpověděl: ‚Je pozdě, už vás nemohu přijmout.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","A tak buďte vždycky připraveni, protože nevíte, ve které chvíli přijdu. ");
INSERT INTO ceslb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","15","Dám vám jiný příklad. Jeden člověk si před odjezdem na dalekou cestu zavolal své zaměstnance a svěřil jim svůj majetek. Každému podle jeho schopností: jednomu pět tisíc, druhému dva a dalšímu jeden. Potom odcestoval. ");
INSERT INTO ceslb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Zaměstnanec, který dostal pět tisíc, začal obchodovat a vydělal dalších pět tisíc. ");
INSERT INTO ceslb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ten, který dostal dva tisíce, také sumu zdvojnásobil. ");
INSERT INTO ceslb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ale ten, kterému byl svěřen jeden tisíc, vykopal v zemi jámu a do ní peníze ukryl. ");
INSERT INTO ceslb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Po delší době se zaměstnavatel vrátil a chtěl, aby mu podřízení předložili účty. ");
INSERT INTO ceslb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","První přinesl peníze a řekl: ‚Pane, svěřil jsi mi pět tisíc a tady máš zisk dalších pět tisíc.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pán ho pochválil za dobrou práci a řekl mu: ‚Osvědčil ses v malém úkolu, proto ti mohu svěřit mnohem víc. A nyní tě zvu na oslavu svého návratu.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Přišel druhý a řekl: ‚Pane, svěřil jsi mi dva tisíce a odevzdávám ti čtyři.‘ – ");
INSERT INTO ceslb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‚Velmi dobře!‘ řekl pán, ‚jsi pilný a spolehlivý. Splnil jsi malý úkol, svěřím ti větší. I tebe zvu na hostinu.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pak skládal účty ten poslední: ‚Pane, vím, že jsi přísný a záleží ti na zisku, ");
INSERT INTO ceslb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ale já jsem měl strach, abych neprodělal, a proto jsem raději peníze zakopal a tady ti je v pořádku vracím.‘ – ");
INSERT INTO ceslb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pán zvolal: ‚Ty lenochu! Ty ničemo! Věděl jsi, oč mi jde. ");
INSERT INTO ceslb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Měl jsi svěřené peníze uložit a vynesly by mně aspoň úrok! ");
INSERT INTO ceslb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vezměte od něho ty peníze a dejte je prvnímu. ");
INSERT INTO ceslb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Protože tomu, kdo dobře využívá, co mu bylo svěřeno, bude ještě přidáno. Kdo se ani trochu nesnaží, přijde o všechno. ");
INSERT INTO ceslb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Toho lenocha vyžeňte ven do tmy. Zbyde mu jen pláč a pozdní lítost.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Až přijdu v královském majestátu, v doprovodu všech andělů, zasednu k soudu, ");
INSERT INTO ceslb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","kam se dostaví všichni lidé. To bude chvíle konečného rozdělení lidstva. Jako pastýř vybírá ze stáda ty, které si ponechá a které vyřadí, ");
INSERT INTO ceslb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tak i já řeknu svým věrným po pravici: ‚Pojďte, sám Otec vás zve do království, které je pro vás připraveno od počátku světa. ");
INSERT INTO ceslb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Měl jsem hlad, a dali jste mi najíst, žíznil jsem, a dali jste mi pít, neměl jsem střechu nad hlavou, a vy jste mne přijali, ");
INSERT INTO ceslb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","neměl jsem co na sebe, a vy jste mne oblékli, v nemoci jste o mne pečovali, a když jsem byl ve vězení, přišli jste za mnou.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","Ti věrní namítnou: ‚Nevzpomínáme si, že bychom měli někdy příležitost se takto o tebe postarat.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tehdy jim odpovím: ‚Co dobrého jste udělali pro jednoho z mých nepatrných bratrů, to jste udělali pro mne.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Těm shromážděným po levici řeknu: ‚Pryč ode mne, propadli jste ohni zatracení, který je připraven pro satana a pro jeho pomocníky! ");
INSERT INTO ceslb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","Vždyť když jsem měl hlad, nedali jste mně najíst, žíznil jsem, a nedali jste mi pít, neměl jsem střechu nad hlavou, a zavřeli jste přede mnou, neměl jsem co na sebe, a neoblékli jste mne, v nemoci jste o mne nepečovali, a když jsem byl ve vězení, nepřišli jste za mnou.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Budou se obhajovat: ‚Pane, jak jsme ti mohli pomoci, když jsme tě nikdy neviděli?‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Řeknu jim: ‚Teď už na tom nic nezměníte. Co jste zůstali dlužni tomu nejposlednějšímu, upřeli jste mně.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ti postavení na levici budou odsouzeni na věky, ale ti na pravici budou žít věčně.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Když Ježíš dokončil tento výklad, řekl svým učedníkům: ");
INSERT INTO ceslb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","„Jak víte, za dva dny budou Velikonoce a já budu zrazen a ukřižován.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","V tu dobu se sešla židovská velerada v paláci nejvyššího kněze Kaifáše. ");
INSERT INTO ceslb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Radili se, jak by se Ježíše nenápadně zmocnili a zprovodili ho ze světa. ");
INSERT INTO ceslb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Dohodli se, že by to nemělo být o velikonočních svátcích, aby to nevzbudilo rozruch mezi shromážděnými poutníky. ");
INSERT INTO ceslb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mezitím byl Ježíš pozván v Betanii do domu Šimona, zvaného Malomocný. ");
INSERT INTO ceslb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Byli již u stolu, když k Ježíšovi přistoupila žena. Měla alabastrovou nádobku s drahocenným vonným olejem, a ten mu všechen vetřela do vlasů. ");
INSERT INTO ceslb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Učedníci tím byli pohoršeni: „Takové plýtvání! ");
INSERT INTO ceslb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","To se dalo výhodně prodat a peníze mohli dostat chudí!“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ježíš to slyšel a řekl: „Proč jí to máte za zlé? Prokázala mi dobrou službu. ");
INSERT INTO ceslb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chudých bude mezi vámi vždy dost, ale já s vámi už dlouho nebudu. ");
INSERT INTO ceslb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tato žena mne pomazala olejem, a tak vlastně připravila mé tělo k pohřbu. ");
INSERT INTO ceslb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","To, co učinila, neupadne v zapomenutí, ale spolu se zvěstí o mém díle záchrany to bude připomínáno.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jeden z dvanácti Ježíšových učedníků, Jidáš Iškariotský, odešel k velekněžím ");
INSERT INTO ceslb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a řekl jim: „Kolik mi zaplatíte, když zradím Ježíše, abyste ho nenápadně dostali do rukou?“ A oni mu dali třicet stříbrňáků. ");
INSERT INTO ceslb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Od té chvíle hledal Jidáš vhodnou příležitost, aby provedl svůj záměr. ");
INSERT INTO ceslb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","První den Velikonoc se učedníci zeptali Ježíše: „Kde máme připravit velikonoční večeři?“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Poslal je do města a k jednomu člověku se vzkazem: „Nastal můj čas, budu u tebe se svými učedníky jíst velikonočního beránka.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Učedníci se podle toho zařídili a připravili tam večeři. ");
INSERT INTO ceslb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Když po setmění Ježíš večeřel s dvanácti učedníky, řekl: „Jeden z vás mne zradí.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","To je velice zarmoutilo a jeden přes druhého se ptali: „To myslíš mne, Pane?“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","On odpověděl: „Je to ten, kdo si bral z mísy současně se mnou. ");
INSERT INTO ceslb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Já musím jít cestou, která je mi určena, ale to nijak neospravedlňuje toho, kdo mne zrazuje. Lépe by mu bylo, kdyby se vůbec nenarodil.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jidáš se ho zeptal: „Mistře, jsem to já?“ On odpověděl: „Ano.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Když jedli, vzal Ježíš chléb, poděkoval Bohu, rozlamoval ho a podával učedníkům se slovy: „Vezměte a jezte, to je mé tělo.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Potom vzal kalich s vínem, vzdal díky Bohu a podal jim ho se slovy: „Pijte z něho všichni, ");
INSERT INTO ceslb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","to je má krev, prolitá, aby smyla hříchy mnohých. To je nová smlouva Boha s člověkem. ");
INSERT INTO ceslb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Já s vámi piji tento nápoj naposled. Příště budeme pít spolu nové víno až v království mého Otce.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Potom zazpívali píseň a šli na Olivovou horu. ");
INSERT INTO ceslb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tam Ježíš řekl: „Ještě této noci se stane něco, co vám vezme odvahu. Vždyť Písmo předpovídá: ‚Budu bít pastýře a jeho stádo se rozprchne.‘ – ");
INSERT INTO ceslb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ale až povstanu k životu, sejdeme se spolu v Galileji.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petr rozhorleně protestoval: „Kdyby tě všichni opustili, já tedy ne!“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ale Ježíš mu odpověděl: „Říkám ti, že ještě této noci, dřív než zakokrhá kohout, mne třikrát zapřeš.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petr zvolal: „To raději s tebou umřu, než bych tě zapřel!“ A stejně mluvili i ostatní. ");
INSERT INTO ceslb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Potom přišli na místo zvané Getsemane a Ježíš řekl svým učedníkům: „Vy se tady posaďte a já se jdu modlit.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Vzal s sebou Petra, Jakuba a Jana. Padl na něho smutek a tíseň. ");
INSERT INTO ceslb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Řekl jim: „Sevřela mne smrtelná úzkost. Zůstaňte tu a buďte se mnou vzhůru.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Poodešel, padl tváří k zemi a modlil se: „Můj Otče! Jestli je to možné, zbav mne toho hrozného údělu! Ale nechci prosazovat svoji vůli. Chci, aby se stalo, co chceš ty.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pak se vrátil k těm třem a oni spali. ");
INSERT INTO ceslb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","„Petře,“ budil ho, „to jste nemohli ani hodinu být se mnou vzhůru? Bděte a modlete se, abyste obstáli ve zkoušce. Máte dobrou vůli, ale slabé tělo.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Opět se vzdálil a modlil se: „Můj Otče! Není-li jiné východisko, ať se stane tvá vůle.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Vrátil se zase ke svým učedníkům a oni opět spali. Byli velice unaveni. ");
INSERT INTO ceslb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nechal je spát, odešel potřetí a modlil se podobnými slovy. ");
INSERT INTO ceslb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pak se vrátil k učedníkům a řekl: „Teď už nepotřebuji, abyste se mnou bděli. Nastává chvíle, kdy budu zrazen a vydán do rukou podlých lidí. ");
INSERT INTO ceslb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Vstaňte, půjdeme! Tam se blíží můj zrádce.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ještě ani nedomluvil a už přicházel Jidáš. S ním táhl oddíl ozbrojený meči a holemi, poslaný veleradou. ");
INSERT INTO ceslb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Měli s Jidášem domluvené znamení: Chopí se toho, koho Jidáš políbí. ");
INSERT INTO ceslb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A tak přistoupil Jidáš k Ježíšovi: „Buď zdráv, Mistře!“ řekl a políbil ho. ");
INSERT INTO ceslb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ježíš mu řekl: „Příteli, co to děláš?“ Tu se však Ježíše chopili a zajali ho. ");
INSERT INTO ceslb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jeden z těch, kteří byli s Ježíšem, vytasil meč, ťal po veleknězovu služebníkovi a usekl mu ucho. ");
INSERT INTO ceslb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ježíš řekl svému obránci: „Schovej svůj meč! Kdo čím zachází, tím také schází. ");
INSERT INTO ceslb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Cožpak nevíš, že kdybych poprosil svého Otce o ochranu, okamžitě by mi poslal celé nebeské vojsko? ");
INSERT INTO ceslb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ale jak by se pak splnil Boží plán spásy?“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pak se obrátil k ozbrojencům: „Přitáhli jste na mne jako na rebela. Proč jste mě nezatkli už v chrámu, kde jsem vám denně kázal? Já vím proč! ");
INSERT INTO ceslb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Plníte tak přesně prorocké předpovědi.“ V té chvíli ho všichni jeho učedníci opustili a rozutekli se. ");
INSERT INTO ceslb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zatčeného Ježíše pak odvedli k nejvyššímu knězi Kaifášovi, kde se sešla velerada. ");
INSERT INTO ceslb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petr je z povzdálí následoval až k veleknězovu paláci. Vešel na nádvoří a vmísil se mezi služebnictvo, aby věděl, jak to dopadne. ");
INSERT INTO ceslb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Velekněží i celá rada se snažili pomocí křivého svědectví Ježíše obvinit tak, aby ho mohli odsoudit k smrti. ");
INSERT INTO ceslb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ale i když sehnali mnoho falešných svědků, přece se nepodařilo najít vhodnou obžalobu. Nakonec vystoupili dva ");
INSERT INTO ceslb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a shodně vypovídali: „Tento muž řekl, že má moc zničit chrám a ve třech dnech ho znovu vystavět.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nato vstal nejvyšší velekněz a řekl Ježíšovi: „Jak se obhájíš proti této obžalobě?“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ale Ježíš mlčel. Tu sáhl velekněz k poslednímu prostředku: „Beru tě pod přísahu při živém Bohu: Jsi ten zaslíbený Mesiáš, Boží Syn?“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ježíš odpověděl: „Ty sám jsi to řekl. Ale ujišťuji vás, že brzy budete svědky toho, že mne Bůh vyzdvihne, abych seděl po jeho pravici, odkud se vrátím ve svém majestátu.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Velekněz si na znamení největšího pohoršení roztrhl své roucho a prohlásil: „To je rouhání! Cožpak potřebujeme ještě svědky? Teď jste to slyšeli na vlastní uši! Jaký vynesete rozsudek?“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Odpověděli: „Zaslouží si smrt!“ Pak mu někteří plivali do obličeje, bili ho po hlavě a tloukli holí s výsměchem: „Když jsi Mesiáš, hádej, kdo ti teď dal ránu!“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petr zatím seděl venku na nádvoří. Tu si ho všimla jedna služka: „Ty jsi také byl s tím Ježíšem z Galileje!“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ale Petr přede všemi popřel: „Ani nevím, o čem mluvíš!“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pak si to namířil k bráně, kde ho uviděla jiná a upozornila okolostojící: „Tento člověk chodil s Ježíšem z Nazaretu.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petr se však zapřísahal a řekl: „Vůbec toho člověka neznám.“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Oni se však kolem něj shlukli a doráželi: „Určitě k němu patříš! Je to znát na tvém nářečí!“ ");
INSERT INTO ceslb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petr se dušoval a přísahal, že Ježíše opravdu nezná. V tom okamžiku se ozval kohout ");
INSERT INTO ceslb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","a Petr si vzpomněl na Ježíšova slova: „Dříve než zakokrhá kohout, třikrát mne zapřeš.“ Vyběhl ven a hořce se rozplakal. ");
INSERT INTO ceslb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ráno se opět sešli členové židovské velerady a domlouvali se, jak by přiměli Římany, aby potvrdili rozsudek smrti. ");
INSERT INTO ceslb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Potom poslali spoutaného Ježíše k římskému místodržiteli Pilátovi. ");
INSERT INTO ceslb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Když Jidáš viděl, že Ježíše odsoudili k smrti, hnulo se v něm svědomí, že ho zradil. Vzal třicet stříbrných, které dostal za zradu, a chtěl je vrátit představitelům velerady: ");
INSERT INTO ceslb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","„Zhřešil jsem, zradil jsem nevinného člověka!“ Oni však lhostejně odpověděli: „Do toho nám nic není, to je tvoje věc!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jidáš odhodil peníze v chrámu, vyběhl ven a oběsil se. ");
INSERT INTO ceslb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Velekněží dali peníze sebrat a řekli si: „Co s nimi? Pro chrámovou pokladnu se nehodí. Lpí na nich krev!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dohodli se tedy, že za ně koupí pozemek, kde si dříve hrnčíři kopali hlínu, a že tam budou pohřbívat cizince, kteří zemřou v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A tak se tomu místu až dodnes říká „Krvavé pole“. ");
INSERT INTO ceslb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tím se splnilo staré proroctví: „Vzali třicet stříbrňáků – náhradu za život otroka, na kterou ho Izrael ocenil, ");
INSERT INTO ceslb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","a dali je podle Božího rozkazu za hrnčířovo pole.“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ježíš byl předveden před římského místodržitele Piláta. Ten se ho zeptal: „Tak ty jsi židovský král?“ „Když tomu tak říkáš, budiž,“ odpověděl mu Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","K dalším žalobám židovské velerady se však nevyjádřil. ");
INSERT INTO ceslb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","„Neslyšíš, z čeho tě obviňují?“ ptal se Pilát. ");
INSERT INTO ceslb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ale k jeho velkému údivu Ježíš mlčel, nehájil se. ");
INSERT INTO ceslb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bývalo zvykem, že místodržitel o velikonočních svátcích propouštěl jednoho vězně podle přání lidu. ");
INSERT INTO ceslb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tehdy právě Římané měli ve vězení zvlášť pověstného zločince jménem Barabáš. ");
INSERT INTO ceslb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Když se lid toho jitra shromáždil před Pilátovým domem, zeptal se jich místodržitel: „Koho vám mám propustit – Barabáše, nebo Ježíše Krista?“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Věděl, že Ježíše udali velekněží, protože mu záviděli jeho popularitu. ");
INSERT INTO ceslb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","V té chvíli dostal Pilát na soudcovském křesle vzkaz od své ženy: „Ruce pryč od toho nevinného člověka! Kvůli němu mne v noci pronásledovaly strašné sny.“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Zástupci velerady zatím přesvědčovali lid, aby žádal svobodu pro Barabáše a pro Ježíše smrt. ");
INSERT INTO ceslb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Když se Pilát znovu zeptal, koho z těch dvou má propustit, ozval se pokřik: „Barabáše!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","„A co mám udělat s Ježíšem Kristem?“ zeptal se Pilát. Dav křičel: „Ukřižuj ho!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilát ještě namítl: „Vždyť se ničeho zlého nedopustil.“ Ale křik davu se stupňoval: „Na kříž! Na kříž!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilát viděl, že jeho snaha zachránit Ježíše je marná a že napětí davu roste, umyl si přede všemi ruce a řekl: „Jsem čistý od krve toho člověka. Je nevinný, odpovědnost je na vás!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nato dav volal: „Jeho krev na nás i na naše děti!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Barabáše jim tedy propustil, Ježíše nechal zbičovat a svolil, aby byl ukřižován. ");
INSERT INTO ceslb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Římští vojáci jej nejprve odvedli do vládní budovy a svolali k němu celou četu. ");
INSERT INTO ceslb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Svlékli ho a přes ramena mu přehodili rudý plášť. ");
INSERT INTO ceslb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Z trní upletli korunu, narazili mu ji na hlavu a do pravé ruky mu dali prut místo žezla. Pak před ním klekali a posměšně volali: „Ať žije židovský král!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Plivali na něj a tím prutem ho bili po hlavě. ");
INSERT INTO ceslb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Když se dost pobavili, vyměnili mu zase plášť za jeho šaty a vedli ho na popraviště. ");
INSERT INTO ceslb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cestou popadli jednoho muže a přinutili ho, aby nesl Ježíšův kříž. Byl to Šimon z Kyrény. ");
INSERT INTO ceslb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Došli až na pahorek zvaný Golgota – Lebka. ");
INSERT INTO ceslb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tam mu nabídli zkyslé víno s hořkou přísadou. Když ochutnal, odmítl. ");
INSERT INTO ceslb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ukřižovali ho a pak mezi sebou losovali o jeho šaty. Tím se splnilo jedno z proroctví: „Rozebrali si můj oděv, o mé šaty losovali.“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pak se posadili a drželi stráž. ");
INSERT INTO ceslb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nad hlavou mu připevnili nápis s označením viny: „Ježíš, král Židů.“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Současně s ním byli po obou stranách ukřižováni dva zločinci. ");
INSERT INTO ceslb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kolemjdoucí se Ježíšovi pošklebovali ");
INSERT INTO ceslb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a vysmívali: „Tak chrám jsi chtěl zbořit a za tři dny znovu postavit. Teď ukaž svou moc a zachraň sám sebe. Když jsi Boží Syn, sestup z kříže!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","K nim se přidali i členové velerady: „Podívejte se na zachránce! Sám se zachránit neumí. Židovský král – visí na kříži! Sestup dolů a uvěříme ti. ");
INSERT INTO ceslb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dovolával se Boha, říkal, že je Boží Syn. Ať ho tedy Bůh vysvobodí!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Podobná slova se ozvala i z vedlejších křížů. ");
INSERT INTO ceslb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","V poledne se nad celým krajem setmělo a tma trvala až do tří hodin. ");
INSERT INTO ceslb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pak Ježíš hlasitě zvolal: „Eli, Eli, lema sabachtani?“ což znamená: „Bože můj, Bože můj, proč jsi mne opustil?“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Někteří z těch, co stáli poblíž, se domnívali, že volá proroka Elijáše. ");
INSERT INTO ceslb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jeden z nich běžel pro houbu, namočil ji v tom kyselém nápoji, nastrčil na prut a podával Ježíšovi k ústům. ");
INSERT INTO ceslb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ostatní ho okřikovali: „Jen ho nech, ať vidíme, jestli mu přijde Elijáš na pomoc!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Potom Ježíš znovu vykřikl a zemřel. ");
INSERT INTO ceslb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","V tom okamžiku se v chrámu roztrhla opona, zakrývající vstup do svatyně. Tak bylo naznačeno, že úloha bohoslužeb je Kristovou obětí naplněna a končí. Země se chvěla, skály pukaly ");
INSERT INTO ceslb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","a hroby se otvíraly. Když pak Ježíš vstal z mrtvých, mnozí v Jeruzalémě dosvědčovali, že viděli vzkříšené z těch hrobů. Byli předzvěstí toho, že Ježíš zvítězil nad smrtí a jednou vzkřísí všechny své věrné. ");
INSERT INTO ceslb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Když velitel s popravčí četou viděli zemětřesení a všechno, co se dělo, padla na ně hrůza a říkali: „On to byl opravdu Boží Syn!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Z povzdálí přihlíželo také mnoho žen, které přišly s Ježíšem až z Galileje a staraly se o něj a jeho učedníky. ");
INSERT INTO ceslb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mezi nimi byla i Marie Magdaléna, Marie – matka Jakuba a Josefa, a matka Jakuba a Jana Zebedeových. ");
INSERT INTO ceslb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Když nastal večer, přišel jeden bohatý muž z Arimatie, jménem Josef, jeden z Ježíšových následovníků. ");
INSERT INTO ceslb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dal se ohlásit u Piláta a prosil, aby mu vydal Ježíšovo tělo. Pilát mu vyhověl. ");
INSERT INTO ceslb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef zavinul Ježíšovo tělo do čistého plátna ");
INSERT INTO ceslb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a uložil do hrobu, který si dal před nedávnem vytesat ve skále. Vchod do hrobky dal po pohřbu uzavřít těžkým balvanem. Pak odešel. ");
INSERT INTO ceslb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Dvě Marie – jedna z nich Marie Magdaléna – přihlížely pohřbu. ");
INSERT INTO ceslb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Druhý den v sobotu šli velekněží a farizejové k Pilátovi ");
INSERT INTO ceslb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","a řekli: „Pane, vzpomněli jsme si, že ten podvodník svého času řekl: ‚Třetího dne opět vstanu k životu.‘ ");
INSERT INTO ceslb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dej tedy aspoň tři dny hlídat hrob, nebo přijdou jeho učedníci, ukradnou ho a pak budou lidem namlouvat, že vstal z mrtvých. A to by k tomu bludu ještě chybělo!“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","„Dobře,“ řekl Pilát, „postavte tam stráž, jak myslíte.“ ");
INSERT INTO ceslb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Oni šli, postavili tam stráž a dokonce zapečetili vstupní kámen. ");
INSERT INTO ceslb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na úsvitu neděle se Marie Magdaléna a ta druhá Marie vypravily k hrobu. ");
INSERT INTO ceslb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nastalo silné zemětřesení. Boží anděl sestoupil s nebe, odvalil kámen a sedl si na něj. ");
INSERT INTO ceslb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Zářil jako blesk a jeho oděv byl bílý jako sníh. ");
INSERT INTO ceslb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Strážci byli tak vyděšeni, že se nemohli ani hnout. ");
INSERT INTO ceslb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anděl promluvil k ženám: „Nebojte se, vím, že hledáte Ježíše, který byl ukřižován. ");
INSERT INTO ceslb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ale on tu již není, vstal opět k životu, jak to předpověděl. Pojďte se podívat do hrobu. ");
INSERT INTO ceslb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A teď si pospěšte a řekněte jeho učedníkům, že vstal z mrtvých a jde napřed do Galileje, kde ho uvidíte. To jsem vám měl vyřídit.“ ");
INSERT INTO ceslb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","S bázní, a přece s velkou radostí opustily ženy rychle hrob a běžely to oznámit učedníkům. ");
INSERT INTO ceslb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na cestě se setkaly se samým Ježíšem. Pozdravil je a ony padly na kolena a objímaly jeho nohy. ");
INSERT INTO ceslb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ježíš jim řekl: „Nebojte se, jen jděte za mými bratry a řekněte jim, ať jdou do Galileje a tam se setkáme.“ ");
INSERT INTO ceslb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Po odchodu žen se někteří strážci odebrali do města, aby ohlásili velekněžím všechno, co se stalo. ");
INSERT INTO ceslb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Ti hned svolali poradu s ostatními židovskými představiteli, aby se dohodli, co dělat. Potom štědře podplatili vojáky, aby mluvili shodně s nimi: „V noci jsme usnuli, a zatímco jsme spali, přišli Ježíšovi učedníci a ukradli jeho tělo.“ ");
INSERT INTO ceslb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pak vojákům slíbili, že doslechne-li se o tom místodržitel, uchlácholí ho a postarají se, aby z toho vyvázli bez nepříjemností. ");
INSERT INTO ceslb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Vojáci si tedy vzali peníze a rozhlašovali, k čemu byli navedeni. Tato verze se mezi židy rozšířila, takže tomu věří dodnes. ");
INSERT INTO ceslb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jedenáct apoštolů šlo do Galileje, na horu, kterou Ježíš určil jako místo setkání. ");
INSERT INTO ceslb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tam ho uviděli, klaněli se mu, ale někteří pochybovali, že to je skutečně on. ");
INSERT INTO ceslb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ježíš jim řekl: „Je mi dána veškerá moc na nebi i na zemi. ");
INSERT INTO ceslb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Proto jděte a získávejte mi následovníky ve všech národech, křtěte je ve jméno Otce, Syna i Ducha svatého. ");
INSERT INTO ceslb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Veďte tyto nové učedníky k tomu, aby poslouchali všechny příkazy, které jsem vám dal. A spoléhejte na to, že já jsem vždy s vámi až do konce světa.“");
INSERT INTO ceslb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Zde začíná radostná zpráva o podivuhodném životě Ježíše Krista, Božího Syna. ");
INSERT INTO ceslb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Již prostřednictvím dávného proroka Izajáše Bůh promluvil tak, jako by mluvil přímo ke svému Synovi: „Pošlu před tebou zvláštního posla, který připraví svět na tvůj příchod. ");
INSERT INTO ceslb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","V době duchovně pusté bude volat: ‚Přichází k vám Bůh! Napravte svůj život, odložte všechno, co mu stojí v cestě!‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tím poslem byl Jan Křtitel. Žil na poušti a vybízel lidi, aby od něho přijali křest a dali tak najevo, že se veřejně přiznávají ke svým proviněním, že jich litují a touží, aby jim Bůh odpustil. ");
INSERT INTO ceslb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lidé z Jeruzaléma a z celého Judska přicházeli, aby mu naslouchali, a když vyznali své viny, Jan je pokřtil v řece Jordánu. ");
INSERT INTO ceslb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan nosil oděv z velbloudí srsti přepásaný pásem a živil se kobylkami a medem divokých včel. ");
INSERT INTO ceslb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ve svých kázáních stále zdůraz-ňoval: „Záhy po mně přijde někdo daleko mocnější, než jsem já; bude tak vznešený, že nejsem hoden ani jako otrok rozvázat řemínek jeho obuvi. ");
INSERT INTO ceslb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Já jsem vás křtil vodou, ale on vás bude křtít Duchem svatým.“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jednoho dne přišel Ježíš z galilejského Nazaretu k Janovi a dal se od něho v Jordánu pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ve chvíli, kdy vystupoval z vody na břeh, viděl, jak se obloha rozevřela a na jeho hlavu se snesl Boží Duch v podobě holubice. ");
INSERT INTO ceslb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Současně z nebe promluvil hlas: „Ty jsi můj milovaný Syn, z tebe mám radost.“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hned nato Boží Duch vnukl Ježíšovi, aby odešel na poušť do samoty. ");
INSERT INTO ceslb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Šel tedy a čtyřicet dní tam strávil sám mezi divokou zvěří, vystaven satanovu pokoušení; potom přišli andělé a pečovali o něho. ");
INSERT INTO ceslb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Později, když král Herodes uvěznil Jana Křtitele, vydal se Ježíš do Galileje a hlásal tam radostné poselství od Boha: ");
INSERT INTO ceslb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","„Konečně přišel čas a přiblížilo se Boží království. Přestaňte myslet jen na pozemské věci, změňte svůj život a uvěřte tomu, co vám Bůh vzkazuje!“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jednoho dne šel Ježíš po břehu Galilejského jezera a uviděl Šimona a jeho bratra Ondřeje, jak vrhají do vody síť; byli totiž rybáři. ");
INSERT INTO ceslb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ježíš na ně zavolal: „Pojďte za mnou! Udělám z vás jiné rybáře, budete lovit lidi!“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ti dva všeho nechali a šli s ním. ");
INSERT INTO ceslb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","O něco dále pak spatřil jiné dva rybáře – Jakuba a Jana Zebedeovy. Seděli v lodi a opravovali potrhané sítě. ");
INSERT INTO ceslb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I ty Ježíš vyzval. Oba bratři se okamžitě zvedli, opustili svého otce a najaté pomocníky a vykročili za Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tak přišli společně do města jménem Kafarnaum; v sobotu navštívili tamější synagogu, ve které se židé scházeli ke společným modlitbám, ke čtení i výkladu Písma. Ježíš tam začal kázat a ");
INSERT INTO ceslb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","posluchači žasli, protože mluvil s nezvyklou přesvědčivostí. Bylo to úplně něco jiného, než co dosud slýchali od učitelů zákona. ");
INSERT INTO ceslb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Byl tam také jeden muž posedlý démonem a ten začal vykřikovat: ");
INSERT INTO ceslb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","„Co je ti po nás, Ježíši Nazaretský? Chceš nás snad zničit? Vím dobře, že jsi svatý Boží Syn!“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ježíš ho rázně okřikl: „Už ani slovo! Vyjdi z něho ven!“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Posedlý se ještě chvíli zmítal a křičel, než ho démon opustil. ");
INSERT INTO ceslb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lidé byli ohromeni a začali se dohadovat: „Co to je? Nové učení? Odkud bere takovou moc? Vždyť i zlým duchům poroučí a oni ho poslouchají!“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A zpráva o tom, co Ježíš učinil, se rychle roznesla po celém kraji. ");
INSERT INTO ceslb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Když pak Ježíš opustil synagogu, vydal se s Jakubem a Janem do Šimonova a Ondřejova domu. ");
INSERT INTO ceslb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Šimonova tchyně právě ležela v horečkách na lůžku, tak o tom pověděli Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ten k ní přistoupil, vzal ji za ruku a pomohl jí, aby si sedla. Horečka hned přestala, žena vstala a začala se starat o hosty. ");
INSERT INTO ceslb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Jakmile slunce zmizelo za obzorem (a skončil sobotní klid), sešli se lidé z celého města u Šimonova domu. Přivedli s sebou nemocné a posedlé. ");
INSERT INTO ceslb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Toho večera uzdravil Ježíš mnoho lidí a z velkého množství posedlých vyhnal démony. Těm však nedovolil mluvit, protože věděli, že je Mesiáš – svatý Boží Syn. ");
INSERT INTO ceslb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Příští ráno vstal Ježíš ještě před svítáním a odešel na osamělé místo, kde se mohl v klidu modlit. ");
INSERT INTO ceslb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","O něco později jej Šimon se svými druhy začali hledat. ");
INSERT INTO ceslb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Když ho našli, řekli mu: „Každý se ptá jenom po tobě!“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ježíš jim však pověděl: „Musím jít také do jiných měst, abych i tam oznámil své poselství. Vždyť proto jsem přišel.“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A tak procházel celou galilejskou zemí, kázal v synagogách a mnohé vysvobozoval z moci démonů. ");
INSERT INTO ceslb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jednou za ním přišel člověk postižený malomocenstvím a na kolenou ho prosil: „Pane, vím, že mne můžeš uzdravit, když budeš chtít.“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ježíš, pohnut soucitem, vztáhl ruku, dotkl se ho a řekl: „Chci, abys byl zdráv.“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","V tu chvíli malomocenství zmizelo a muž byl uzdraven. ");
INSERT INTO ceslb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ježíš mu však přísně nařídil: „Jdi a dej si své uzdravení ověřit knězem. Cestou se však nikde nezastavuj a s nikým nemluv. Vezmi s sebou obětní dar, jak to uzdraveným z malomocenství předepsal Mojžíš, aby se všichni přesvědčili, že jsi očištěn.“ ");
INSERT INTO ceslb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Muž odešel, ale nevydržel mlčet. Každému na potkání radostně vyprávěl, že je uzdraven. A tak Ježíš nemohl veřejně vstoupit do žádného města a zůstával venku na osamělých místech. I tam se však za ním ze všech stran táhly zástupy lidí. ");
INSERT INTO ceslb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Po několika dnech se Ježíš opět vrátil do Kafarnaum a hned se rozneslo, že je opět doma. ");
INSERT INTO ceslb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nahrnulo se tam tolik lidí, že zaplnili celý dům, ba dokonce ani přede dveřmi nebylo k hnutí. ");
INSERT INTO ceslb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Když jim Ježíš zvěstoval Boží poselství, chtěli se k němu dostat čtyři muži, kteří nesli na nosítkách ochrnutého člověka. ");
INSERT INTO ceslb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Protože se k němu nemohli prodrat zástupem, vystoupili po vnějším schodišti na plochou střechu domu, tu rozebrali a spustili lehátko s ochrnutým přímo před Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Když viděl, jak ti muži bezvýhradně věří v jeho pomoc, řekl nemocnému: „Synu, tvé hříchy jsou ti odpuštěny.“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sedělo tam také několik učitelů zákona a ti se mezi sebou začali domlouvat: ");
INSERT INTO ceslb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","„Slyšeli jste, co ten člověk řekl? To je přece rouhání! On si snad o sobě myslí, že je Bohem! Vždyť jedině Bůh může odpouštět hříchy.“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ježíš však četl jejich myšlenky a obrátil se k nim: „Proč vás to tak popudilo, co jsem právě řekl? ");
INSERT INTO ceslb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Co je snadnější? Oznámit ochrnutému, že se mu odpouštějí hříchy, nebo mu rozkázat, aby se zvedl, sebral svoje lehátko a odešel domů? ");
INSERT INTO ceslb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Abyste uvěřili, že mám moc odpouštět lidem hříchy, dívejte se teď dobře.“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nato se obrátil k ochrnutému a vyzval ho: „Vstaň a jdi domů, jsi uzdraven.“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ten vstal, sebral své lehátko a před očima všech odcházel. Udivení lidé chválili Boha a říkali: „Něco takového jsme ještě neviděli.“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jindy vyšel Ježíš k jezeru, aby kázal zástupu, který ho tam očekával. ");
INSERT INTO ceslb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Když potom šel dál, uviděl Alfeova syna Leviho, který seděl v celnici a vybíral poplatky od pocestných. „Pojď za mnou a staň se mým učedníkem,“ řekl mu Ježíš. Levi bez váhání vstal a šel s ním. ");
INSERT INTO ceslb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ježíš se svými učedníky pak přijal pozvání do Leviho domu, kde usedli za stůl společně s dalšími celníky a lidmi pochybné pověsti; tyto vyděděnce společnosti Ježíš zvláštním způsobem přitahoval. ");
INSERT INTO ceslb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Když však židovští náboženští vůdcové viděli, že Ježíš stoluje s lidmi špatné pověsti, vyptávali se jeho učedníků: „Jak si jen může sednout k jednomu stolu s takovou lůzou?“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ježíš to uslyšel a odpověděl jim: „Lékaře nepotřebují zdraví lidé, ale nemocní. Nepřišel jsem proměnit lidi, kteří se považují za dobré, ale ty, kdo znají svou špatnost.“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Janovi učedníci a židovští předáci měli ve zvyku se postit. Jednou přišli lidé za Ježíšem s otázkou: „Proč se tvoji učedníci také nepostí jako žáci Jana a farizejů?“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nato jim Ježíš řekl: „Cožpak ženichovi přátelé odmítají na svatbě jídlo, když je ženich mezi nimi? To se přece radují, ");
INSERT INTO ceslb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","a teprve až je ženich opustí, budou mít důvod ke smutku a k půstu. ");
INSERT INTO ceslb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nový život z Boha nelze vtěsnat do tradičních náboženských zvyků a forem, jako se na staré šaty nedá přišít záplata z neseprané látky. Vždyť záplata by se srazila, vytrhla by okolní chatrné tkanivo a díra by se ještě zvětšila. ");
INSERT INTO ceslb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nové, bouřlivé víno také nedáváte do měchů ze staré kůže; ty by popraskaly a obojí by přišlo nazmar. Nové víno potřebuje nové, nezpuchřelé měchy.“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jednou v sobotu procházel Ježíš se svými učedníky obilným polem. Protože měli hlad, trhali učedníci klasy a jedli zrní. ");
INSERT INTO ceslb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farizejové to uviděli a vytýkali Ježíšovi: „Proč to dělají? Vždyť náš Zákon přece zakazuje v sobotu pracovat, a oni trhají obilí!“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ježíš na to odpověděl: „Nikdy jste nečetli, co udělal král David a jeho družina, když měli na útěku hlad? Neslyšeli jste o tom, jak vešli do Božího chrámu – nejvyšším knězem byl tehdy Ebjátar – a jedli posvátné chleby, které směli jíst pouze kněží?“ ");
INSERT INTO ceslb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A potom ještě dodal: „Sobotní klid má přece sloužit člověku, a ne aby předpisy lidi zotročovaly. ");
INSERT INTO ceslb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Já, jako Syn člověka, který přišel z nebe, stojím nade všemi zákony, i nad dodržováním soboty.“ ");
INSERT INTO ceslb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Když opět přišel Ježíš do synagogy, spatřil tam člověka, který měl bezvládnou ruku. Protože byla právě sobota, ");
INSERT INTO ceslb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ježíšovi nepřátelé napjatě sledovali, co učiní. Jestliže ho uzdraví, bude to vítaná příležitost, jak jej obžalovat z rušení předepsaného svátečního klidu. ");
INSERT INTO ceslb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A opravdu, Ježíš vyzval postiženého, aby předstoupil před celé shromáždění, ");
INSERT INTO ceslb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","a pak položil ostatním otázku: „Co se smí v sobotu? Mohou se konat dobré skutky, nebo se má páchat zlo? Je možné zachránit život, nebo jej zničit?“ Na tyto otázky se nikdo neodvážil odpovědět. ");
INSERT INTO ceslb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jejich mlčení Ježíše naplnilo spravedlivým hněvem, jejich lhostejnost k lidskému utrpení ho roztrpčila. Přeměřil si je přísným pohledem a potom se obrátil k postiženému. „Natáhni tu ruku!“ řekl mu. On to učinil, a ejhle – ruka byla zdravá. ");
INSERT INTO ceslb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farizejové opustili synagogu a šli se domlouvat s přívrženci krále Heroda na tom, jak Ježíše odstranit. ");
INSERT INTO ceslb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ježíš se opět se svými učedníky uchýlil k jezeru. Znovu jej následovaly zástupy lidí z celé Galileje, Judska, ");
INSERT INTO ceslb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jeruzaléma, Idumeje a Zajordání, ba dokonce přišli i lidé z okolních pohanských měst Týru a Sidónu. Široko daleko se roznesly zprávy o jeho zázracích a velmi mnoho lidí se o nich chtělo přesvědčit na vlastní oči. ");
INSERT INTO ceslb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ježíš požádal své učedníky, aby pro něj měli připravenu loďku, na kterou by se mohl uchýlit, kdyby ho dav příliš tísnil. ");
INSERT INTO ceslb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mnoho nemocných už totiž uzdravil a další se k němu přímo vrhali, jen aby se ho mohli dotknout. ");
INSERT INTO ceslb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A když ho spatřili ti, kdo byli posedlí démonem, padali před ním na zem a křičeli: „Ty jsi Boží Syn!“ ");
INSERT INTO ceslb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","On je však rázně umlčoval, protože nestál o jejich svědectví. ");
INSERT INTO ceslb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Potom k sobě zavolal ty, které si vybral pro zvláštní svědecké poslání, a vystoupil s nimi na horu. ");
INSERT INTO ceslb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Z nich pak ustanovil dvanáct, kteří ho měli všude doprovázet a které bude posílat samostatně kázat ");
INSERT INTO ceslb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","a uzdravovat. ");
INSERT INTO ceslb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Byli to: Šimon, kterému přidal jméno Petr, ");
INSERT INTO ceslb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakub a Jan – synové Zebedeovi, kterým někdy říkával „synové hromu“, ");
INSERT INTO ceslb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ondřej, Filip, Bartoloměj, Matouš, Tomáš, Jakub Alfeův, Tadeáš, Šimon Kenaanský a ");
INSERT INTO ceslb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jidáš Iškariotský, který ho později zradil. ");
INSERT INTO ceslb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Když se Ježíš vrátil domů, lidé se k němu začali znovu scházet a brzy jich bylo tolik, že se ani neměl kde najíst. ");
INSERT INTO ceslb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jeho příbuzní uslyšeli, co se děje, a tak se vypravili za ním, aby ho přinutili k návratu domů; domnívali se, že ztratil zdravý rozum. ");
INSERT INTO ceslb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Židovští náboženští učitelé, kteří přišli z Jeruzaléma, dokonce tvrdili, že Ježíš je posedlý Belzebubem, králem všech démonů. Jen proto prý ho ďáblové poslouchají, když je vyhání. ");
INSERT INTO ceslb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ježíš je pozval k sobě a vyvracel tyto pomluvy. Aby mu všichni rozuměli, použil příklad: „Jak může satan vyhnat satana? ");
INSERT INTO ceslb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Království, které je vnitřně rozdělené, se musí zhroutit. ");
INSERT INTO ceslb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Také rodina, kde je svár a nejednota, se nakonec rozpadne. ");
INSERT INTO ceslb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A jestliže satan bojuje sám proti sobě, jak může něco dokázat? Nutně musí přijít jeho konec. ");
INSERT INTO ceslb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Chce-li někdo vniknout do domu siláka a zmocnit se jeho věcí, musí ho nejprve spoutat. Tak i démony může vyhánět jen ten, kdo přemohl satana. ");
INSERT INTO ceslb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ujišťuji vás o jednom: všechno může být lidem odpuštěno, i když se v nevědomosti Bohu rouhají a hrubě ho urážejí slovy i skutky. ");
INSERT INTO ceslb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Když ovšem někdo v zatvrzelosti odmítá Boží zách-rannou moc a přitom ví, co odmítá, takový člověk se rouhá Du-chu svatému. A to je hřích, který nemůže být odpuštěn.“ ");
INSERT INTO ceslb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","To jim Ježíš řekl proto, že jeho činy úmyslně připisovali satanově moci, místo aby přiznali, že uzdravuje mocí Ducha svatého. ");
INSERT INTO ceslb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tehdy přišli k přeplněnému stavení, kde Ježíš učil, také jeho bratři s matkou a vzkázali mu, že s ním potřebují mluvit. ");
INSERT INTO ceslb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sedělo kolem něj plno lidí, když mu kdosi oznámil: „Tvoje matka a tvoji bratři jsou venku a hledají tě.“ ");
INSERT INTO ceslb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ježíš věděl, s jakým záměrem rodina přichází, a proto řekl: „Kdo je má matka? A kdo jsou moji bratři?“ ");
INSERT INTO ceslb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Rozhlédl se po těch, kteří mu dychtivě naslouchali, a řekl: „Hle, tady je má matka a tady jsou moji bratři. ");
INSERT INTO ceslb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Každý, kdo jedná podle Boží vůle, je můj bratr, moje sestra i moje matka.“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jednou Ježíš opět učil na břehu jezera. A protože se kolem něho znovu shromáždily davy lidí, nastoupil do člunu a odtud mluvil k těm, kteří byli na břehu. ");
INSERT INTO ceslb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ježíš své učení často vkládal do zvláštních obrazů – podobenství. Toto je jedno z nich: ");
INSERT INTO ceslb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","„Poslouchejte! Jeden rolník se vydal na pole, aby zasel obilí. ");
INSERT INTO ceslb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ne každé zrno však padlo na vhodnou půdu. Některá se dostala na okraj cesty, kde je sezobali ptáci. ");
INSERT INTO ceslb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jiná padla na skálu, kde bylo jen málo půdy. ");
INSERT INTO ceslb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tam sice zrna brzy vyklíčila, ale ve slunečním žáru osení uschlo, protože kořínky v mělké vrstvě země neměly dost vláhy. ");
INSERT INTO ceslb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jiná zrna zapadla mezi bodláčí, které záhy mladé rostlinky udusilo, takže ani nenasadily klasy. ");
INSERT INTO ceslb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ovšem to zrní, které padlo do úrodné půdy, přineslo třicetinásobný, jiné dokonce šedesáti – až stonásobný užitek.“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","„Kdo má uši k naslouchání, ten ať poslouchá a přemýšlí,“ uzavřel Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Později, když byl sám se svými dvanácti učedníky, ptali se ho: „Jak máme tvým podobenstvím rozumět?“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","„Vy, kteří mi býváte nablízku,“ odpověděl, „jste už pochopili mnohé z tajemství Božího království. Ale těm, co jsou ještě opodál, se to snažím vysvětlovat v podobenstvích. ");
INSERT INTO ceslb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Je však o nich psáno v proroctví: Dívají se, a nevidí, poslouchají, a přece nerozumějí, a tak nejsou ochotni obrátit se k Bohu, aby jim odpustil jejich viny. ");
INSERT INTO ceslb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jestliže ovšem ani vy nechápete tento jednoduchý obraz, jak potom porozumíte všem dalším, které vám chci vyprávět? ");
INSERT INTO ceslb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zde je tedy výklad: Tím rolníkem, o kterém jsem mluvil, je každý, kdo lidem přináší Boží poselství, aby je zasel do jejich života jako dobrou setbu. ");
INSERT INTO ceslb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Srdce některých posluchačů je tvrdé jako ušlapaná cesta. Satan okamžitě přichází a usiluje o to, aby zapomněli, co slyšeli. ");
INSERT INTO ceslb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mělká skalnatá půda představuje srdce nestálých lidí. Boží poselství vyslechnou a radostně přijmou, ");
INSERT INTO ceslb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","jsou však povrchní a slovo u nich nepronikne do hloubky. I když si zpočátku vedou dobře, odpadají, jakmile mají pro víru trpět. ");
INSERT INTO ceslb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Půda zaplevelená bodláčím je obrazem lidí, kteří dobrou Boží zprávu sice vyslechnou a přijmou, ");
INSERT INTO ceslb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ale všední starosti, záliba v majetku a touha po blahobytu Boží poselství v srdci udusí, takže zůstane bez užitku. ");
INSERT INTO ceslb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Úrodné půdě se podobají ti, kteří bez výhrad přijímají Boží zvěst, a proto mohou přinést bohatou sklizeň – někteří dokonce mimořádnou sklizeň.“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","„Když někdo z vás rozsvítí lampu, zakryje ji snad nádobou nebo ji strčí pod postel, aby zakryl její světlo? Určitě ne! Umístí ji tak, aby svítila. ");
INSERT INTO ceslb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","24","Všechno, co je dosud skryto, vyjde najevo a tomu, co je nesrozumitelné, bude porozuměno. Dobře poslouchejte, co vám říkám. Kolik jste ochotni přijmout, tolik dostanete a ještě vám bude přidáno. ");
INSERT INTO ceslb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kdo už něco pochopil, porozumí ještě víc; kdo o to nestojí, přijde o všechno.“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dále Ježíš vyprávěl jiné podobenství: „S Božím královstvím je to jako s rolníkem, který oseje pole a odejde. ");
INSERT INTO ceslb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dny plynou, zrno vyklíčí a roste ve dne v noci, aniž by se o ně musel nějak starat nebo mu pomáhat. ");
INSERT INTO ceslb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Půda sama dává semenu, co potřebuje k růstu. Nejdříve vzejde klíček, pak vyroste stéblo, potom klas. ");
INSERT INTO ceslb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A když v něm nakonec dozraje zrno, přijde rolník a sklidí je.“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","„Jak ještě znázornit Boží království? K čemu ho přirovnat?“ uvažoval Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","„Je to s ním jako se seménkem hořčice. ");
INSERT INTO ceslb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","To sice patří mezi nejmenší semena, ale vyroste z něho největší bylina na poli. Na jejích větvích mohou dokonce hnízdit ptáci.“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ještě mnoho podobných obrazů Ježíš použil, aby lidem přiblížil svoje učení. ");
INSERT INTO ceslb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Když mluvil veřejně, používal výhradně přirovnání. Když však potom býval se svými učedníky o samotě, všechno jim vysvětloval. ");
INSERT INTO ceslb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","K večeru toho dne vyzval Ježíš své učedníky: „Přeplavme se na druhou stranu jezera.“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Odrazili tedy s lodí, ve které seděl, a vzdalovali se od zástupů na břehu. Několik člunů však vyplulo za nimi. ");
INSERT INTO ceslb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Zanedlouho se strhla silná větrná bouře. Vysoké vlny dorážely na člun a ten se začal plnit vodou. ");
INSERT INTO ceslb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ježíš však klidně spal na zádi, s poduškou pod hlavou. Učedníci ho probudili: „Mistře, tobě je jedno, že se potápíme?“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ježíš vstal, okřikl vítr a poručil vlnám: „Uklidněte se!“ V tu chvíli se vítr utišil a kolem se rozhostil klid. ");
INSERT INTO ceslb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pak se Ježíš obrátil na učedníky: „Proč jste se tolik báli? Copak mi nedůvěřujete?“ ");
INSERT INTO ceslb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Byli tím vším ohromeni a ptali se jeden druhého: „Kdo to jen může být, že ho poslouchá vítr i voda?“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na protějším břehu jezera přistáli v gerasenském kraji. ");
INSERT INTO ceslb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jakmile Ježíš vystoupil ze člunu, přiběhl k němu nějaký člověk. Byl to muž posedlý démony, ");
INSERT INTO ceslb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","který žil ve starých hrobech vytesaných do skály ");
INSERT INTO ceslb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","a měl takovou sílu, že když ho spoutali okovy na nohou a řetězy na rukou, pouta vždycky rozlámal a řetězy roztrhal. Nenašel se nikdo tak silný, aby ho mohl zkrotit. ");
INSERT INTO ceslb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ve dne i v noci se skrýval v hrobech a toulal se po okolních pahorcích, skučel a tloukl se kamením. ");
INSERT INTO ceslb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Když teď uviděl Ježíše, přiběhl a vrhl se před ním na zem. Ve chvíli, kdy Ježíš přikazoval démonovi, aby posedlého muže opustil, začal onen ubožák křičet: „Co si mne všímáš, Ježíši, Synu Boha nejvyššího? Zapřísahám tě při Bohu, nech mne na pokoji!“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","„Jak se jmenuješ?“ zeptal se Ježíš. „Zástup, protože je nás v tomto těle mnoho,“ zněla odpověď. ");
INSERT INTO ceslb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A potom démoni žadonili, aby je neposílal nikam daleko. ");
INSERT INTO ceslb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na stráni nad pobřežím se právě páslo stádo vepřů. ");
INSERT INTO ceslb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","„Pošli nás do těch prasat,“ volali démoni. ");
INSERT INTO ceslb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ježíš svolil a nečistí duchové vjeli do zvířat. Vzápětí se to velké, asi dvoutisícové stádo splašilo a hnalo se po stráni dolů k jezeru, vběhlo do vody a utopilo se. ");
INSERT INTO ceslb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pasáci těch vepřů utekli do města a cestou všude rozhlašovali, co se stalo. Každý, kdo je uslyšel, spěchal se o tom přesvědčit na vlastní oči. ");
INSERT INTO ceslb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","A tak se kolem Ježíše shromáždilo mnoho lidí. Když viděli uzdraveného muže, jak sedí oblečený a chová se rozumně, polekali se. ");
INSERT INTO ceslb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ti, kteří byli svědky celé události, jim totiž vyprávěli, co se událo s mužem a kam se poděli vepři. ");
INSERT INTO ceslb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A tak začali všichni Ježíše prosit, aby z jejich kraje raději odešel. ");
INSERT INTO ceslb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nastoupil tedy zase do člunu. Uzdravený muž ho prosil, aby mohl jít s ním. ");
INSERT INTO ceslb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ježíš však odmítl: „Jdi domů ke své rodině a řekni všem známým, jaké dobrodiní ti Bůh prokázal a jak se nad tebou slitoval.“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ten člověk tedy v celém tom kraji zvaném Desítiměstí vyprávěl, jak velké dobrodiní mu prokázal Ježíš. A každý nad tím žasl. ");
INSERT INTO ceslb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Když se Ježíš znovu vrátil na galilejský břeh, sešel se kolem něho zase obrovský zástup lidí. ");
INSERT INTO ceslb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Přišel i představený místní synagogy Jairos, klekl před ním ");
INSERT INTO ceslb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a úpěnlivě ho prosil: „Moje dceruška umírá. Pojď a zachraň ji, aby žila.“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ježíš tedy šel s ním. Také zástup se vydal s nimi a tlačil se na Ježíše ze všech stran. ");
INSERT INTO ceslb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","V davu byla jedna žena, která už dvanáct let trpěla krvácením. ");
INSERT INTO ceslb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mnoho lékařů na ní zkoušelo své umění. Stálo ji to celé jmění, ale nebylo to nic platné, nemoc se stále zhoršovala. ");
INSERT INTO ceslb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Až jednou se doslechla o Ježíšovi a jeho zázračné moci, a tak ho hledala s myšlenkou: „Když si jen sáhnu na jeho plášť, určitě se uzdravím.“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A opravdu! Jakmile se ho dotkla, krvácení přestalo a žena cítila, že je nadobro zdravá. ");
INSERT INTO ceslb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ježíš ovšem ihned poznal, že z něho vyšla uzdravující síla, otočil se a otázal se: „Kdo se to dotkl mého pláště?“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jeho učedníci se divili: „Všichni se na tebe tlačí a ty se ptáš, kdo se tě dotkl?“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ale Ježíš se rozhlížel, aby zjistil, kdo to byl. ");
INSERT INTO ceslb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Žena, celá rozechvělá tím, co se s ní událo, padla mu k nohám a všechno mu pravdivě pověděla. ");
INSERT INTO ceslb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","On ji ujistil: „Dcero, tvá víra tě uzdravila. Můžeš klidně jít, protože nemoc tě už nebude trápit.“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Když s ní ještě mluvil, dorazili poslové z Jairova domu se zprávou, že již je pozdě shánět pomoc. „Tvá dcera právě umřela, už Mistra neobtěžuj,“ oznamovali Jairovi. ");
INSERT INTO ceslb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","37","Jako by nic neslyšel, obrátil se Ježíš k Jairovi a řekl mu: „Jen se neboj a důvěřuj mi!“ Do Jairova domu s sebou vzal pouze Petra, Jakuba a jeho bratra Jana. Ostatní požádal, aby zůstali venku. ");
INSERT INTO ceslb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Dům byl plný hlasitého pláče a nářku. „K čemu ten pláč a rozruch? Vždyť to děvče není mrtvé, jenom spí!“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Vysmáli se mu. Vykázal všechny kromě rodičů a svých tří učedníků. Vešli do místnosti, kde dívka ležela. ");
INSERT INTO ceslb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Vzal ji za ruku a řekl: „Děvčátko, přikazuji ti, vstaň!“ ");
INSERT INTO ceslb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dvanáctiletá dívka vstala a chodila. Přítomní oněměli úžasem. ");
INSERT INTO ceslb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ježíš jim důrazně nařídil, aby nikomu nevypravovali, co se stalo. „Dejte jí najíst,“ připomněl rodičům. ");
INSERT INTO ceslb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pak se Ježíš s učedníky vrátil do svého domovského města Nazaretu. ");
INSERT INTO ceslb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Když přišla sobota, kázal v tamější synagoze, kde mu naslouchalo mnoho lidí. Všichni žasli a říkali si: „Kdepak se to naučil? Kde se u něho vzala ta moudrost? A dokonce dělá i zázraky! ");
INSERT INTO ceslb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Známe ho přece jako tesaře, syna Marie. Jeho bratři jsou Jakub, Josef, Juda a Šimon. A také jeho sestry žijí mezi námi.“ Nemohli se s tím prostě vyrovnat, dokonce se nad tím pohor-šovali. ");
INSERT INTO ceslb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ježíš jen poznamenal: „Nikde prorok neznamená tak málo, jako ve vlastní obci a rodině.“ Jejich nedůvěra ho zarmoutila ");
INSERT INTO ceslb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","a nemohl tam učinit žádný zázrak; jen na několik nemocných položil ruku a uzdravil je. Rozhodl se, že se obrátí k lidem v okolních vesnicích. ");
INSERT INTO ceslb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Potom svolal svých dvanáct učedníků, vysílal je po dvojicích do okolních vesnic a propůjčil jim schopnost osvobozovat lidi z moci zla. ");
INSERT INTO ceslb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Nakázal jim, aby si na cestu kromě hole nic nebrali: žádný chléb, žádná zavazadla, žádné peníze, dokonce ani náhradní obuv nebo šaty. ");
INSERT INTO ceslb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","„V každé vesnici se ubytujte na jediném místě, a to tam, kde vás nejprve přijmou. ");
INSERT INTO ceslb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Když vás někde nebudou chtít přijmout ani vyslechnout, jděte pryč a vyklepejte i ten jejich prach ze svých bot; ať mají, co jim patří.“ ");
INSERT INTO ceslb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Vydali se tedy na cesty a všude vyzývali, aby lidé zanechali svých zlých činů, litovali jich a začali žít nový život. ");
INSERT INTO ceslb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Vyháněli démony, nemocné potírali olejem a uzdravovali je. ");
INSERT INTO ceslb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ježíšův věhlas se šířil a zprávy o něm se donesly až k uším krále Heroda. Někteří lidé říkali, že to ožil Jan Křtitel, proto prý koná takové zázraky. ");
INSERT INTO ceslb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jiní se zase domnívali, že znovu přišel dávný prorok Elijáš, a další byli přesvědčeni, že prostě povstal nový prorok, jak tomu bývalo za starodávna. ");
INSERT INTO ceslb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sám Herodes, když se o Ježíši dozvěděl, se polekal: „Je to Jan, kterého jsem dal popravit. Určitě vstal z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Král dal již dříve Jana zatknout a uvěznil ho ve své tvrzi. ");
INSERT INTO ceslb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jan mu totiž vytýkal, že odloudil vlastnímu bratru Filipovi manželku Herodiadu. ");
INSERT INTO ceslb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ta Jana Křtitele za to nenáviděla a ukládala mu o ivot, bez králova souhlasu se však neodvažovala dát ho zavraždit. ");
INSERT INTO ceslb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Věděla, že Herodes si ho vážil jako spravedlivého a svatého člověka a držel nad ním ochrannou ruku. Rozhovory s ním ho sice vždycky jaksi znepokojovaly, ale přesto mu rád naslouchal a někdy se podle jeho slov i řídil. ");
INSERT INTO ceslb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodiadě se naskytla příležitost Jana odstranit, když král na oslavu svých narozenin uspořádal hostinu pro své dvořany, důstojnictvo a vedoucí osobnosti Galileje. ");
INSERT INTO ceslb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dcera Herodiady při banketu tančila před hosty a všem se velice líbila. ");
INSERT INTO ceslb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Král byl tak okouzlen, že jí pošetile slíbil splnit jakékoliv přání, i kdyby to měla být polovina království. Dokonce to přede všemi slavnostně odpřisáhl. ");
INSERT INTO ceslb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Šla se tedy poradit se svou matkou a ta ji navedla, aby si řekla o hlavu Jana Křtitele. ");
INSERT INTO ceslb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Rychle se vrátila ke králi a přednesla mu své přání: „Chci, abys mi hned teď dal přinést mísu s hlavou Jana Křtitele.“ ");
INSERT INTO ceslb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Král tím byl otřesen, ale neměl odvahu odvolat, co přede všemi hosty tak okázale slíbil. ");
INSERT INTO ceslb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Poslal tedy do vězení kata, aby Jana sťal. ");
INSERT INTO ceslb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kat rozkaz splnil a na míse přinesl Janovu hlavu. Děvče ji předalo své matce. ");
INSERT INTO ceslb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Když se to doslechli Janovi učedníci, přišli pro jeho tělo a pohřbili ho. ");
INSERT INTO ceslb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apoštolové se vrátili z cest a znovu se sešli u Ježíše. Vyprávěli mu o všem, co dělali a o čem hovořili s lidmi, se kterými se setkali. ");
INSERT INTO ceslb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ježíš jim navrhl: „Pojďme na chvíli někam do ústraní a odpočiňme si.“ Stále totiž měli kolem sebe tolik lidí, že jim sotva zbýval čas na jídlo. ");
INSERT INTO ceslb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Odjeli tedy lodí na odlehlé místo. ");
INSERT INTO ceslb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lidé je však viděli odplouvat, nadeběhli si je po břehu, a než loďka přirazila, už tam na ně čekali. ");
INSERT INTO ceslb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Když Ježíš vystoupil a uviděl znovu veliký zástup, bylo mu jich líto, protože byli jako ovce bez pastýře. Začal je tedy opět učit. ");
INSERT INTO ceslb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Později odpoledne mu jeho učedníci připomínali: „Už bys je měl poslat domů. Tady se široko daleko nedá koupit nic k jídlu a za chvíli bude večer.“ ");
INSERT INTO ceslb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","„Tak jim dejte najíst vy!“ navrhl Ježíš. „Kde bychom vzali tolik jídla,“ namítali, „to by stálo pěkné peníze nakrmit takový zástup.“ ");
INSERT INTO ceslb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","„Kolik tu mají lidé potravin? Jděte a zjistěte to!“ požádal Ježíš. „Všeho všudy jen pět chlebů a dvě ryby,“ hlásili mu, když se vrátili. ");
INSERT INTO ceslb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Vyzval je, aby se posadili po padesáti na travnatá místa. ");
INSERT INTO ceslb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vzniklo sto takových skupin. ");
INSERT INTO ceslb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Potom vzal těch pět chlebů a dvě ryby a poděkoval za ně Bohu. Lámal je na kusy a předával učedníkům, aby jídlo roznášeli lidem. ");
INSERT INTO ceslb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tak se všichni najedli dosyta ");
INSERT INTO ceslb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","a ještě se sesbíralo dvanáct plných košů zbytků. ");
INSERT INTO ceslb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Těch, kteří se najedli, bylo na pět tisíc. ");
INSERT INTO ceslb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Hned nato nařídil Ježíš svým učedníkům, aby nasedli na loď a vyrazili přes jezero do Betsaidy. Sám se rozhodl vydat se na cestu o něco později, protože se chtěl ještě s lidmi rozloučit a poslat je domů. Potom vystoupil na blízkou horu, aby se tam modlil. ");
INSERT INTO ceslb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Noc míjela, loď byla někde uprostřed jezera a on sám ještě na hoře. ");
INSERT INTO ceslb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Za ranního svítání viděl, že jeho učeníci stále ještě namáhavě veslují proti větru. Vydal se za nimi po hladině jezera. Přiblížil se až k lodi a chtěl kolem nich přejít. ");
INSERT INTO ceslb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Když ho spatřili kráčet po vodě, začali křičet hrůzou, protože ho pokládali za přízrak. ");
INSERT INTO ceslb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","On je však uklidňoval: „Nebojte se, vždyť jsem to já!“ ");
INSERT INTO ceslb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pak vstoupil k nim do člunu a vítr hned ustal. Dlouho se z toho nemohli vzpamatovat. ");
INSERT INTO ceslb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nechápali ještě, že když Ježíš může rozmnožit chléb, má moc i nad přírodou. ");
INSERT INTO ceslb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Potom přistáli u nejbližšího břehu, v oblasti, která se nazývala stejně jako jezero: Genezaret. ");
INSERT INTO ceslb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sotva vystoupili z lodi, lidé hned Ježíše poznali a po celém okolí se rozkřiklo, že sem připlul. ");
INSERT INTO ceslb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ať Ježíš odešel kamkoliv, z celé té krajiny k němu přinášeli nemocné. ");
INSERT INTO ceslb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Všude, kam přišel, ve vesnicích, městech i venku na samotách, kladli na volně přístupná místa nemocné. Prosili ho, aby se mohli dotknout alespoň cípu jeho šatů. A každý, kdo se ho s vírou dotkl, byl uzdraven. ");
INSERT INTO ceslb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jednou za Ježíšem přišli z Jeruzaléma farizejové a učitelé zákona. ");
INSERT INTO ceslb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Všimli si, že jeho učedníci nedodržují obřad umývání rukou před jídlem a tak porušují židovskou tradici. ");
INSERT INTO ceslb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Židé a zvláště znalci zákona úzkostlivě lpěli na zvycích svých předků a nedotkli se jídla dříve, než si pečlivě umyli ruce. ");
INSERT INTO ceslb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A když přišli z trhu, vždy se umyli celí, než se pustili do přípravy pokrmů. Stejně pečliví byli i při omývání číší, džbánů a kuchyňského nádobí. Už po staletí dodržovali mnoho podobných předpisů. ");
INSERT INTO ceslb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Teď tedy dotírali na Ježíše: „Proč tvoji učedníci nedodržují zvyky našich předků a jedí neumytýma rukama?“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","„Pokrytci!“ odrazil je. „Pravdivě o vás řekl Izajáš: ‚Ústa mají plná Boha, ale srdce prázdné. ");
INSERT INTO ceslb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jejich obřady jsou k ničemu, jejich učení nic než lidské výmysly.‘ ");
INSERT INTO ceslb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Opomíjíte skutečné Boží příkazy a nahrazujete je svými předpisy. ");
INSERT INTO ceslb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Vždyť vy vlastně rušíte Boží zákon ve jménu svých tradic. ");
INSERT INTO ceslb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tak například Mojžíš vám tlumočil toto přikázání Božího zákona: ‚Měj v úctě svého otce i svou matku.‘ K tomu dodal, že každý, kdo by třeba jen nadával svým rodičům, propadá trestu smrti. ");
INSERT INTO ceslb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Vy však připouštíte, aby člověk zanedbával své rodiče, kteří potřebují pomoc, jestliže má výmluvu: ‚Nemohu se o vás postarat, protože to, co z mého výdělku mělo patřit vám, jsem odevzdal jako příspěvek v chrámu.‘ ");
INSERT INTO ceslb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tak stavíte svoje názory nad Boží zákon. A to je jenom jeden příklad z mnoha.“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pak k sobě přivolal zástup lidí a řekl jim: ");
INSERT INTO ceslb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","„Poslouchejte mě a snažte se porozumět. To, co sníte, nemůže nijak ublížit vaší duši; ničíte ji však, když se zabýváte nečistými a zlými myšlenkami a šíříte je kolem sebe.“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Když potom vešel do nějakého domu, aby si odpočinul, začali se ho učedníci vyptávat na význam toho, co právě řekl. ");
INSERT INTO ceslb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","„Ani vy tomu nerozumíte?“ divil se Ježíš. „Nechápete, že duši člověka nemůže uškodit to, co snědl? ");
INSERT INTO ceslb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vždyť jídlo neznečišťuje nitro; projde jen žaludkem a vychází ven.“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","K tomu připojil: „Člověku škodí to, co pochází z jeho nitra. ");
INSERT INTO ceslb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tam se líhnou zlé myšlenky, necudnost, ");
INSERT INTO ceslb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nevěra, krádež, vražda, sobectví, zlost, podlost, sprostota, závist, urážky, pýcha a všelijaké výstřednosti. ");
INSERT INTO ceslb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","To je to zlo, které vychází z nitra člověka a odděluje ho od Boha.“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Když opustil Ježíš Galileu, odešel na sever do pohanské Fénicie, kde se ubytoval v jednom domě. Chtěl utajit svou přítomnost, ale bylo to marné; už se o něm vědělo i tam. ");
INSERT INTO ceslb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tak o něm uslyšela i jedna Syroféničanka. ");
INSERT INTO ceslb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Přišla a prosila ho na kolenou, aby uzdravil její pomatenou dceru. ");
INSERT INTO ceslb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ježíš jí odpověděl: „Přišel jsem především pro ty, kdo se hlásí k živému Bohu. Nech nejprve najíst děti. Nebylo by správné vzít jim jídlo a hodit je štěňatům.“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Žena se však nevzdala: „To je pravda, Pane, ale i štěňata sbírají pod stolem, co dětem upadne.“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","„Když to vidíš tak,“ řekl jí, „jdi klidně domů, tvoje dcera je zdravá.“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Vrátila se tedy domů, kde nalezla dítě, jak klidně spí, beze stopy pomatenosti. ");
INSERT INTO ceslb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Z Fénicie se Ježíš vracel velikou oklikou zpět ke Genezaretskému jezeru, až se ocitl na území Desítiměstí. ");
INSERT INTO ceslb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tamější lidé k němu přivedli hluchoněmého člověka a žádali, aby ho uzdravil. ");
INSERT INTO ceslb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ježíš si vzal muže stranou od zástupu. Nasliněným prstem se dotkl jeho jazyka a vložil mu své prsty do uší. (To byla jeho řeč k hluchoněmému.) ");
INSERT INTO ceslb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pak se Ježíš krátce pomodlil a zvolal: „Otevři se!“ ");
INSERT INTO ceslb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","V té chvíli začal muž slyšet a srozumitelně mluvit. ");
INSERT INTO ceslb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pak Ježíš žádal všechny shromážděné, aby se o tom nikomu nezmiňovali; ale čím více jim to zakazoval, tím více o tom mluvili, protože se s něčím podobným ještě nesetkali. ");
INSERT INTO ceslb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lidé žasli a říkali: „To už je schopen napravit všechno, když hluchým vrací sluch a němým řeč.“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Opět se kolem Ježíše shromáždilo velké množství lidí. Byli s ním tak dlouho, že dojedli své zásoby. Ježíš si svolal učedníky, aby se o tom poradili. ");
INSERT INTO ceslb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","„Je mi líto těch lidí,“ řekl. „Jsou zde již tři dny a nemají co do úst. ");
INSERT INTO ceslb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Když je pošlu domů bez jídla, cesta je vyčerpá. Vždyť někteří bydlí daleko.“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","„Chceš snad, abychom jim tady v té pustině sháněli něco k jídlu?“ ulekli se učedníci. ");
INSERT INTO ceslb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","„Kolik chlebů máte?“ zeptal se Ježíš. „Sedm,“ odpověděli. ");
INSERT INTO ceslb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nato řekl všem shromážděným, aby se posadili na zem. Vzal těch sedm chlebů, děkoval za ně Bohu, ulamoval z nich a dával svým učedníkům, kteří je rozdělovali všem ostatním. ");
INSERT INTO ceslb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Měli ještě několik malých ryb, za které Ježíš také Bohu poděkoval a dal je učedníkům, aby je opět roznesli. ");
INSERT INTO ceslb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Všichni se dosyta najedli; bylo jich tentokrát asi čtyři tisíce. Když potom posbírali zbytky nalámaných chlebů, naplnili jimi sedm košů. Pak Ježíš poslal lidi domů ");
INSERT INTO ceslb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","a sám se svými učedníky nastoupil na loďku a přeplavili se k městečku Magdala. ");
INSERT INTO ceslb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Když se o Ježíšově příchodu dověděli tamější farizejové, přišli k němu a začali na něj dotírat: „Udělej nějaký zázrak! Prokaž se nějakým božským znamením, a pak ti uvěříme.“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","„Kolik zázraků a znamení byste ještě chtěli?“ povzdechl si Ježíš. „Stejně byste ani potom neuvěřili.“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nechal je, nastoupil s učedníky znovu do loďky a pluli jinam. ");
INSERT INTO ceslb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Protože se zapomněli postarat o doplnění zásob, měli s sebou jen jednu chlebovou placku. ");
INSERT INTO ceslb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Během plavby jim Ježíš vážně kladl na srdce: „Dejte si pozor na farizejský a herodovský kvas!“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tu si uvědomili, že nemají dost chleba. Neřešitelná situace! ");
INSERT INTO ceslb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ježíš zaslechl, co je znepokojuje. „Co se staráte o jídlo? Ještě pořád vám nic nedošlo? To jste tak nechápaví? ");
INSERT INTO ceslb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","‚Oči mají a nevidí, uši mají a neslyší.‘ Cožpak si nic nepamatujete? ");
INSERT INTO ceslb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Co těch pět tisíc, které jsem nasytil pěti chleby? A kolik košů jste nasbírali?“ „Dvanáct,“ odpověděli. ");
INSERT INTO ceslb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","21","„A když jsem nasytil čtyři tisíce pouhými sedmi chleby, kolik ještě zbylo? Vzpomínáte si?“ „Sedm plných košů,“ přiznali. „Tak vidíte – ještě vám to nestačí?“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Když dorazili do Betsaidy, přivedli k němu slepce s prosbou, aby ho svým dotekem uzdravil. ");
INSERT INTO ceslb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ježíš ho vzal za ruku a vyvedl za vesnici. Tam se nasliněnými prsty dotkl očí slepce a zeptal se: „Vidíš něco?“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Muž se rozhlédl a zvolal: „Ano, vidím lidi, ale nejasně; vypadají jako chodící stromy!“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ježíš se ještě jednou dotkl jeho očí. Když se muž znovu podíval kolem sebe, viděl všechno jasně; jeho oči byly uzdraveny. ");
INSERT INTO ceslb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ježíš ho poslal domů se slovy: „Přes vesnici raději nechoď a nikomu to neříkej.“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Potom Ježíš se svými učedníky opustil Galileu a procházel vesničkami v okolí Césareje Filipovy, na úpatí pohoří Hermonu. Cestou se svých učedníků zeptal: „Za koho mne lidé považují?“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","„Někteří se domnívají, že jsi Jan Křtitel, jiní říkají, že jsi Elijáš nebo jiný velký prorok.“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","„A za koho mne považujete vy?“ otázal se dále. „Ty jsi ten zaslíbený král – Kristus,“ zvolal Petr. ");
INSERT INTO ceslb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nato jim přikázal, aby to nikomu neříkali, ");
INSERT INTO ceslb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","a začal jim vykládat, co ho čeká, než uskuteční své poslání. Bude muset velmi trpět, velekněží, učitelé zákona i židovští předáci ho odsoudí, bude zabit, ale třetí den vstane z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mluvil s nimi naprosto otevřeně. Petr si ho vzal stranou a chtěl mu to rozmluvit. ");
INSERT INTO ceslb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ježíš se však obrátil k učedníkům a před nimi Petra pokáral: „Mlč, pokušiteli! Díváš se na to z lidského hlediska, a ne z Božího.“ ");
INSERT INTO ceslb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ke svým učedníkům přizval ještě další lidi a kladl jim na srdce: „Kdo mě chce následovat, musí odložit své vlastní zájmy, nést kříž svých nesnází a utrpení a ve všem následovat můj příklad. ");
INSERT INTO ceslb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kdo si život a jeho radosti chce zachovat za každou cenu, ten přijde o všechno. Kdo se však všeho zřekne pro mne a moji nabídku, najde pravý a věčný život. ");
INSERT INTO ceslb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vždyť co člověku prospěje, získá-li celý svět, a pravý život promarní? ");
INSERT INTO ceslb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dostane snad ještě jednou takovou příležitost? ");
INSERT INTO ceslb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jestli se někdo stydí za mne a za má slova před nevěřícími a hříšnými lidmi, za toho se také já budu stydět, až se vrátím se svatými anděly v slávě svého Otce. ");
INSERT INTO ceslb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Někteří z vás, jak tu stojíte, se ještě dočkají mocných projevů Božího království.“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Po šesti dnech vzal s sebou Ježíš Petra, Jakuba a Jana a vystoupili na vršek hory. Tam, daleko od lidí, se před očima učedníků stala s Ježíšem zvláštní proměna. ");
INSERT INTO ceslb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jeho tvář ozářila nadpozemská sláva a oděv se skvěl oslnivou bělostí, nedosažitelnou lidskými prostředky. Tu uviděli dva muže, jak s Ježíšem rozmlouvají; ");
INSERT INTO ceslb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","byli to Elijáš a Mojžíš. ");
INSERT INTO ceslb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petr zvolal: „Mistře, jak je dobře, žes nás vzal s sebou! Hned vám třem postavíme přístřeší.“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ani si vzrušením neuvědomoval, co říká; tak byli tím viděním vyvedeni z míry. ");
INSERT INTO ceslb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Vtom je všechny zahalil oblak a z něho se ozval hlas: „Toto je můj milovaný Syn, toho poslouchejte!“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Když se mrak rozplynul, učedníci se rozhlédli, ale kromě Ježíše už nikoho neviděli. ");
INSERT INTO ceslb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cestou dolů jim Ježíš přikázal, aby o té události nikomu nevyprávěli dříve, než vstane z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Slíbili, že o tom zatím budou mlčet, ale vůbec nechápali, co myslel tím, že „vstane z mrtvých“. ");
INSERT INTO ceslb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","„Proč učitelé zákona říkají, že dříve než Kristus musí znovu přijít prorok Elijáš?“ otázali se Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","„Ano, nejprve měl přijít Elijáš, aby dal vše do pořádku. A on také přišel a připravil mi cestu. Ovšem, jak je v Bibli předpověděno, naložili s ním, jak se jim zlíbilo. Ale všimněte si, že Písmo hovoří také o Synu člověka, jak musí velmi trpět a upadnout do opovržení.“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Když sestoupili k ostatním učedníkům, našli je obklopené množstvím lidí; mezi nimi byli i učitelé zákona, kteří se s učedníky o něčem dohadovali. ");
INSERT INTO ceslb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Když však uviděli Ježíše, uctivě ztichli a šli mu naproti, aby ho uvítali. ");
INSERT INTO ceslb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","„O čem se dohadujete?“ zeptal se jich. ");
INSERT INTO ceslb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Z davu vystoupil jeden muž: „Mistře, přivedl jsem k tobě svého syna; je posedlý démonem, který ho připravuje o řeč i sluch. ");
INSERT INTO ceslb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kdykoliv se ho ten duch zmocní, svíjí se v křeči, skřípe zuby, z úst mu jde pěna a upadá do bezvědomí. Žádal jsem tvé učedníky, aby ho od toho osvobodili, ale nedokázali to.“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","„Ach, vy lidé,“ zvolal Ježíš, „jak dlouho bude trvat, než uvěříte? Jak dlouho vás budu ještě snášet a mít s vámi trpělivost? Přiveďte toho hocha ke mně!“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Šli pro něj. Sotva se s však přiblížil k Ježíšovi, chlapec se svalil na zem a svíjel se s pěnou u úst. ");
INSERT INTO ceslb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","„Jak dlouho tím trpí?“ otázal se Ježíš otce. „Už od malička. ");
INSERT INTO ceslb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Často byl ve smrtelném nebezpečí, protože ten démon jím smýkal do ohně i do vody. Jestliže je to možné, slituj se a pomoz!“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","„Jestli je to možné?“ podivil se Ježíš. „Všechno je možné pro toho, kdo věří.“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","„Věřím, Pane, ale pomoz mi věřit víc!“ zvolal otec se slzami v očích: ");
INSERT INTO ceslb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ježíš si všiml, že se sbíhají další lidé, a tak přikázal: „Duchu, který ovládáš jeho smysly, vyjdi z něho – jednou provždy!“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mladík vykřikl, ještě jednou se zkroutil křečí a pak ztichl. Démon ho opustil. Hoch však zůstal ležet bez známek života. Davem proběhl šepot, že je mrtvý. ");
INSERT INTO ceslb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ale Ježíš ho vzal za ruku, zvedl jej a on se postavil. ");
INSERT INTO ceslb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Když pak Ježíš vešel do domu a jeho učedníci s ním byli sami, zeptali se ho: „Proč jsme toho démona nemohli vyhnat my?“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","„Zde pomůže jen modlitba a půst,“ odpověděl jim. ");
INSERT INTO ceslb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Když se odtamtud vydali na další cestu, procházeli Galileou, ale Ježíš si nepřál, aby se o něm lidé dozvěděli. ");
INSERT INTO ceslb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chtěl mít čas pro své učedníky. Znovu je připravoval na to, že Syn člověka – totiž on sám – bude vydán na pospas lidem, kteří ho zabijí. Ale třetí den po smrti zase vstane k životu. ");
INSERT INTO ceslb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Oni tomu sice stále nerozuměli, styděli se však zeptat se ho. ");
INSERT INTO ceslb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Potom se vrátili do Ježíšova příbytku v Kafarnaum. Tam se Ježíš zeptal svých učedníků, o čem se to cestou dohadovali. ");
INSERT INTO ceslb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Oni však mlčeli. Přeli se totiž, kdo z nich je významnější. ");
INSERT INTO ceslb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ježíš se posadil a shromáždil je kolem sebe. „Kdo chce být na prvním místě u mne, bude u lidí jako ten poslední a všem bude sloužit,“ řekl. ");
INSERT INTO ceslb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pak k sobě zavolal malé děcko a vzal je před nimi do náruče se slovy: ");
INSERT INTO ceslb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","„Kdo se zastane takového dítěte a přijme ho v mém jménu, přijímá mne. Nepřijímá však jenom mne, ale i toho, který mne poslal.“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","„Mistře,“ hlásil mu Jan, „viděli jsme člověka, který tvým jménem vyhání démony, a nebyl to nikdo z našich. Zakázali jsme mu to, když mezi nás nepatří.“ ");
INSERT INTO ceslb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","„Neměli jste mu bránit,“ odpověděl Ježíš. „Vždyť přece žádný, kdo v mém jménu učiní zázrak, nemůže se hned po tom obrátit proti mně. ");
INSERT INTO ceslb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kdo není proti nám, je s námi. ");
INSERT INTO ceslb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A kdyby vám někdo podal sklenici vody jen proto, že jste moji – říkám vám, nepřijde o svou odměnu. ");
INSERT INTO ceslb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kdo by však připravil o víru někoho, kdo mi důvěřuje jako toto dítě, lépe by mu bylo uvázat mlýnský kámen na krk a hodit ho do moře. ");
INSERT INTO ceslb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Svádí-li tě tvá ruka k činění zla, utni ji! Je pro tebe rozhodně lépe být bez ruky a mít jistotu, že budeš žít věčně, než mít obě ruce a jít do neuhasitelného ohně, odkud není vysvobození. ");
INSERT INTO ceslb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Podobně – svádí-li tě ke zlému tvá noha, zbav se jí. Je lépe být chromý a mít jistý věčný život, než s oběma nohama navěky zahynout. ");
INSERT INTO ceslb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","A tak i oko: je-li původcem zla ve tvém životě, zbav se ho. Lépe je vejít do Božího království jednooký, než s oběma očima do věčného zahynutí. ");
INSERT INTO ceslb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ke každé oběti patří sůl. ");
INSERT INTO ceslb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sůl je dobrá věc. Ztratí-li však svou chuť a schopnost bránit rozkladu, čím ji nahradíte? Nebraňte se proto zkouškám a držte spolu.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ježíš opustil Kafarnaum a prošel Zajordáním do Judska. I zde ho obklopilo množství lidí a on je začal učit jako obvykle. ");
INSERT INTO ceslb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Přišli však za ním farizejové a pokoušeli se ho nachytat: zeptali se ho, zda je dovolen rozvod. ");
INSERT INTO ceslb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Místo odpovědi jim dal otázku: „Co řekl o rozvodu Mojžíš?“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","„K tomu, aby manželství bylo zrušeno, podle Mojžíše stačí, když muž napíše ženě rozlukový list.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","„To byl jen Mojžíšův ústupek tvrdosti lidského srdce,“ řekl na to Ježíš. „Bůh si to tak nikdy nepřál. ");
INSERT INTO ceslb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hned na počátku stvořil člověka jako nerozlučnou dvojici, muže a ženu. ");
INSERT INTO ceslb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Proto muž opustí své rodiče a připojí se ke své manželce; ");
INSERT INTO ceslb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","v tom spojení již nežijí jako dva jedinci, ale stávají se jednou bytostí. ");
INSERT INTO ceslb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","A proto člověk nemá právo rozdělit, co Bůh spojil.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Později se učedníci znovu k té otázce vrátili. ");
INSERT INTO ceslb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Vyložil jim to: „Kdo se rozvede se svou ženou a ožení se s jinou, hřeší stejně, jako by měl ženy dvě. ");
INSERT INTO ceslb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A právě tak rozvede-li se žena se svým mužem a vdá se za jiného, dopouští se cizoložství.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lidé nosili k Ježíšovi děti, aby jim žehnal. Učedníci jim domlouvali, aby ho neobtěžovali. ");
INSERT INTO ceslb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Když to Ježíš slyšel, zlobil se: „Neodhánějte ty děti a nebraňte jim, když chtějí ke mně. I jim přece patří Boží království. ");
INSERT INTO ceslb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A říkám vám, že kdo nepřijde k Bohu s dětskou prostotou, nestane se občanem toho království.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bral děti do náruče, hladil je a žehnal jim. ");
INSERT INTO ceslb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Když se zase vydali na cestu, dohonil je nějaký muž a padl před Ježíšem na kolena: „Dobrý učiteli, co mám dělat, abych získal věčný život?“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","„Proč mi říkáš dobrý? Vždyť dobrý je jen Bůh,“ odvětil Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","„A k tvé otázce – přikázání přece znáš: nebudeš zabíjet, cizoložit, krást, lhát, podvádět, budeš si vážit svých rodičů.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","„Mistře, všechno jsem dodržoval od mládí.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ježíš ho objal pohledem: „A přece ti něco schází. Jdi a prodej všechno, co máš, peníze rozdej chudým a získáš tak poklad v nebi. Potom se vrať a staň se mým následovníkem.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Když to ten člověk vyslechl, zesmutněl a odešel s těžkým srdcem. Byl totiž velmi bohatý. ");
INSERT INTO ceslb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ježíš ho mlčky sledoval očima a pak se otočil k učedníkům: „Jak těžké je pro boháče vejít do Božího království!“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","To je zarazilo. Není snad majetek důkazem Boží přízně? „Přátelé, do Božího království se těžko dostanou ti, pro které jsou peníze a majetek smyslem života. ");
INSERT INTO ceslb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Snáze projde velbloud tou uzoučkou brankou, které říkáte jehelné ucho, než bohatý vejde do Božího království.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","To jim dodalo. „Má vůbec někdo naději, že se tam dostane?“ říkali si mezi sebou. ");
INSERT INTO ceslb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Podíval se na ně. „Člověk na to nestačí, ale Bůh je všemocný.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tu promluvil Petr: „Ale my jsme se všeho vzdali a šli za tebou.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","„Ujišťuji vás,“ odpověděl Ježíš, „že každému, kdo se z lásky ke mně a pro šíření evangelia něčeho vzdá – ať už domova, života se sourozenci, rodiči, manželkou a dětmi, nebo majetku, ");
INSERT INTO ceslb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","se to vrátí stonásobně už zde na zemi (i když neujde pronásledování) a v budoucnosti ho čeká věčný život. ");
INSERT INTO ceslb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mnozí, kteří u lidí něco znamenají, budou poslední, a těm nejpohrdanějším se tam dostane čestných míst.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Když potom byli na cestě do Jeruzaléma, Ježíš šel vpředu a ostatní se drželi za ním. Co jim Ježíš řekl, to je znepokojilo a naplnilo obavami. Zavolal k sobě svých dvanáct učedníků a znovu je připravoval na to, co ho čeká: ");
INSERT INTO ceslb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","„Musíme do Jeruzaléma a tam Syn člověka padne do rukou velekněží a učitelů zákona a ti ho odsoudí a vydají pohanům. ");
INSERT INTO ceslb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Budou se mu veřejně vysmívat, plivat na něj, zbičují a zabijí ho. Ale třetí den vstane z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Přihlásili se Zebedeovi synové Jakub a Jan: „Mistře, chtěli bychom tě o něco poprosit.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","„Co si ode mne přejete?“ vzhlédl Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","„Až usedneš na trůn, chtěli bychom ti sedět nejblíže se všech, každý z jedné strany vedle tebe.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","„Nevíte, oč prosíte. Můžete pít z kalicha hořkosti, ze kterého musím pít já, a projít křtem utrpení, který mě čeká?“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","„Ale jistě,“ přisvědčili. „Dobře, budete pít z mého kalicha a budete pokřtěni stejným křtem. ");
INSERT INTO ceslb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ale není mou věcí určovat vám pořadí v Božím království. To už je stanoveno.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ostatních deset se zlobilo na Jakuba a Jana. ");
INSERT INTO ceslb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ale Ježíš je svolal dohromady a řekl jim: „Víte, že vládcové mají moc nad národy, a kdo vládne, obvykle druhé utlačuje. ");
INSERT INTO ceslb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ale mezi vámi to tak být nemá. Naopak, kdo z vás chce být velký, ať všem pokorně slouží. ");
INSERT INTO ceslb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A kdo z vás chce být na předním místě, ať je pomocníkem všech. ");
INSERT INTO ceslb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vždyť já – Syn člověka – jsem nepřišel na svět proto, aby mi ostatní sloužili, ale abych já sloužil jim a abych položil život pro záchranu mnoha lidí.“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Procházeli také Jerichem, kde se k nim přidal velký zástup. U cesty seděl slepý žebrák Bartimeus – Timeův syn. ");
INSERT INTO ceslb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Když uslyšel, že to jde Ježíš Nazaretský, křičel: „Ježíši z rodu krále Davida, slituj se nade mnou!“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lidé mu domlouvali, aby mlčel. Ale on volal tím hlasitěji: „Synu Davidův, slituj se nade mnou!“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ježíš ho uslyšel, zastavil se a přikázal, aby slepce zavolali. Vrátili se tedy k Bartimeovi se vzkazem: „Máš štěstí, Ježíš tě volá – vstaň!“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Slepec odhodil svůj starý kabát, vyskočil a klopýtal k Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","„Co pro tebe mohu udělat?“ dotkl se ho Ježíš. „Mistře, chci vidět!“ ");
INSERT INTO ceslb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","„Staň se, tvá víra tě zachránila.“ V té chvíli se slepci vrátil zrak a on se vydal také za Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Když se blížili k Jeruzalému a stoupali na Olivovou horu, uviděli Betfage a Betanii. Ježíš poslal dva ze svých učedníků napřed ");
INSERT INTO ceslb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a řekl jim: „Jděte do vesnice tamhle před námi. Na kraji vesnice uvidíte u plotu uvázané oslátko, na kterém ještě nikdo nejel. To mi přiveďte. ");
INSERT INTO ceslb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A kdyby se vás někdo ptal, co to děláte, odpovězte krátce: Pán ho potřebuje a brzy ho vrátí.“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Učedníci šli a skutečně našli u jednoho domu přivázané oslátko. ");
INSERT INTO ceslb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Když ho odvazovali, někteří z kolemjdoucích se ptali, proč to dělají. ");
INSERT INTO ceslb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Odpověděli tak, jak jim poradil Ježíš, a lidé je nechali zvíře odvést. ");
INSERT INTO ceslb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Přivedli oslátko k Ježíšovi, přehodili přes ně své pláště, Ježíš se na ně posadil a vydali se na cestu. ");
INSERT INTO ceslb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lidé ze zástupu, který ho provázel, se začali předhánět v pozornostech; prostírali před ním své pláště, jiní lámali větve a zdobili jimi cestu. ");
INSERT INTO ceslb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Za ním i před ním se utvořil průvod a všichni volali: „Ať žije král! Sláva! ");
INSERT INTO ceslb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Jde v Božím jménu! Ať žije Davidovo království! Nebe jásá s námi!“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tak vstoupil Ježíš do Jeruzaléma a vešel do chrámu. Všechno si tam pozorně prohlédl, a protože byl již večer, odešel se svými dvanácti na noc do Betanie. ");
INSERT INTO ceslb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Druhý den cestou z Betanie dostal Ježíš hlad. ");
INSERT INTO ceslb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Z dálky uviděl fíkovník obalený listím a šel se podívat, zda nemá nějaké ovoce. Když pak přišel až ke stromu, zjistil, že kromě listí na něm nic neroste; první úroda byla pryč a na novou strom ještě nenasadil. ");
INSERT INTO ceslb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Učedníci slyšeli, jak říká stromu: „Nikdo už z tebe nebude jíst ovoce!“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vrátili se do Jeruzaléma a Ježíš šel do chrámu. Když na nádvoří chrámu uviděl stánky s obětními zvířaty a pulty směnárníků, zpřevracel je a obchodníky vyhnal. ");
INSERT INTO ceslb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nedovolil ani, aby si někdo tamtudy krátil cestu s vodou od studny. ");
INSERT INTO ceslb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","„Cožpak nevíte,“ horlil, „že je napsáno v Písmu: ‚Můj chrám je určen k tomu, aby se v něm všechny národy modlily?‘ Vy jste však z něho udělali lupičské doupě.“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Slyšeli to i velekněží a učitelé zákona a přemýšleli, jak by se Ježíše zbavili. Měli z něho strach, protože lid byl jeho učením nadšen. ");
INSERT INTO ceslb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Večer Ježíš s učedníky opustil město. ");
INSERT INTO ceslb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Když šli ráno zase kolem toho fíkovníku, viděli, že je úplně suchý. ");
INSERT INTO ceslb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petr si vzpomněl na včerejší příhodu. „Mistře, ten fíkovník, který jsi odsoudil, uschl!“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","„To vás překvapuje?“ usmál se Ježíš. „Boží moc je daleko větší. ");
INSERT INTO ceslb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Když budete věřit Bohu – a myslím to smrtelně vážně – a řekli byste této hoře: ‚Zvedni se a padni do moře,‘ ta hora to udělá. Musíte jen věřit bez nejmenší pochybnosti. ");
INSERT INTO ceslb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pamatujte si: budete-li za něco prosit ve svých modlitbách s pevnou vírou, že vaše prosba bude naplněna, pak se tak určitě stane. ");
INSERT INTO ceslb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ale když se modlíte, odpusťte nejdříve tomu, proti komu něco máte, aby i váš nebeský Otec mohl odpustit vám. ");
INSERT INTO ceslb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jestliže ve vás zůstane hněv, ani Bůh vám nepromine vaše provinění.“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Přišli zase do Jeruzaléma. Když Ježíš procházel chrámem, zastavili ho zástupci představenstva chrámu ");
INSERT INTO ceslb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","„Od koho máš pověření k takovým činům? Kdo tě k tomu zmocnil?“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","„Já se vás také zeptám na jednu věc,“ opáčil Ježíš. „Když mi odpovíte, řeknu i já, od koho mám tu moc. ");
INSERT INTO ceslb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Povězte mi: Byl Jan Křtitel skutečně poslán od Boha, nebo si to vymyslel?“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dali hlavy dohromady: „Odpovíme-li, že od Boha, pak nám řekne, proč jsme mu tedy neuvěřili. ");
INSERT INTO ceslb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A před lidmi zase nemůžeme Jana prohlásit za obyčejného fanatika. Vždyť jsou všichni přesvědčeni, že to byl Boží prorok.“ ");
INSERT INTO ceslb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A tak odpověděli Ježíšovi: „Nevíme!“ „Ani já vám tedy nepovím, od koho mám pověření,“ odtušil Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Začal pak vyprávět následující příběh: „Jeden člověk založil vinici. Obehnal ji plotem, postavil lis na víno a vystavěl hlídkovou věž. Potom vinici pronajal pachtýřům a sám odcestoval. ");
INSERT INTO ceslb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Když přišla doba vinobraní, pověřil jednoho ze svých sluhů, aby od pachtýřů vybral podíl z úrody, který mu náležel. ");
INSERT INTO ceslb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ale pachtýři sluhu ztloukli a vyhodili s prázdnou. ");
INSERT INTO ceslb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Majitel tam poslal jiného. Po něm začali házet kamení, těžce ho zranili na hlavě a vyhnali. ");
INSERT INTO ceslb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Poslal tam tedy dalšího a toho zabili. Tak majitel vinice postupně vyslal ještě několik svých lidí. Ke všem se chovali surově, některé ztloukli, jiné ubili. ");
INSERT INTO ceslb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nakonec tam vypravil svého jediného milovaného syna. Domníval se, že před ním přece jen budou mít respekt. ");
INSERT INTO ceslb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ale nájemci si řekli: ‚To je jediný dědic. Zabijme ho a vinice bude naše.‘ ");
INSERT INTO ceslb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A tak se stalo. Syna zavraždili a tělo vyhodili z vinice ven. ");
INSERT INTO ceslb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Co si myslíte, že udělá ten majitel, až přijde? Spravedlivě je odsoudí k smrti a vinici pronajme jiným. ");
INSERT INTO ceslb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Vzpomeňte si, že v Bibli je psáno: ‚Kámen, kterým stavitelé opovrhli, se nakonec stal kamenem nejdůležitějším – svorníkem klenby. ");
INSERT INTO ceslb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pán Bůh to tak učinil a my stojíme v údivu.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Židovští vůdci pochopili, že ten příběh platil jim, že oni jsou těmi proradnými pachtýři. Rádi by byli Ježíše zatkli, ale báli se davu. Prozatím od toho museli upustit. ");
INSERT INTO ceslb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Poslali však za ním několik farizejů a členů Herodovy strany, aby ho vyprovokovali k nějakému žalovatelnému výroku. ");
INSERT INTO ceslb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","„Mistře,“ oslovili ho úlisně, „víme, že pravda je ti nade všechno; ať se to komu líbí či nelíbí, učíš pravdě tak, jak ji znáš od Boha. Řekni nám: máme platit Římu daně, nebo nemáme?“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ježíš však nastraženou past prohlédl. „Co to na mě zkoušíte, podejte mi peníz!“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Když mu ho podali, zeptal se: „Čí obraz a jméno je na té minci?“ „Římského císaře,“ řekli. ");
INSERT INTO ceslb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","„Dávejte tedy císaři, co je císařovo, a co je Boží, dávejte Bohu.“ Tak jim to zase nevyšlo. ");
INSERT INTO ceslb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Potom přišli se záludnou otázkou příslušníci skupiny saducejů, kteří nevěřili ve vzkříšení z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Řekli: „Mistře, v Mojžíšově zákoně je psáno: Zemře-li ženatý muž a nezanechá po sobě žádného dědice, jeho svobodný bratr je povinen oženit se s vdovou a zplodit bratrovi potomka. ");
INSERT INTO ceslb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Povíme ti příběh: Bylo sedm bratrů. Nejstarší se oženil, brzo však zemřel a nenechal po sobě žádných dětí. ");
INSERT INTO ceslb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Druhý se oženil s vdovou, ale brzy zemřel bezdětný. Tak to stále pokračovalo, až zemřel i poslední. Nikdo z nich nezanechal dědice. ");
INSERT INTO ceslb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nakonec zemřela i ta žena. ");
INSERT INTO ceslb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naše otázka zní: Čí bude ta žena po vzkříšení? Vždyť ji mělo za manželku všech sedm.“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ježíš odpověděl: „Vaše chyba je v tom, že neznáte Bibli a nevěříte v Boží moc. Manželství je záležitostí pozemského života. ");
INSERT INTO ceslb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Až lidé vstanou z mrtvých, nebudou už mezi nimi tělesné svazky. Přetrvají jen svazky ducha. ");
INSERT INTO ceslb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","A o vzkříšení samotném vůbec nepochybujte. Cožpak jste nečetli o Mojžíšovi a hořícím keři? Jak se tam Bůh tehdy představil? ‚Já jsem Bůh Abrahámův, Bůh Izákův, Bůh Jákobův.‘ Když o lidech zesnulých před mnoha staletími říká: ‚já JSEM jejich Bůh,‘ pak je jasné, že pro něj nikdy nepřestali existovat. Vidíte, jak jste vedle.“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tyto rozhovory sledoval jeden z učitelů zákona. Zdálo se mu, že Ježíš odpovídá znamenitě. A tak mu předložil svůj problém: „Které přikázání je nejdůležitější?“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ježíš nezaváhal: „První přikázání zní takto: Slyš Izraeli, Pak Bůh je jediný Pán. ");
INSERT INTO ceslb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Miluj ho z celého srdce, celou bytostí a ze všech sil. ");
INSERT INTO ceslb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A to druhé: Miluj druhého člověka tak, jako miluješ sebe. Nejsou důležitější přikázání než tato.“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","„Mistře, tys dobře vystihl to podstatné,“ musel uznat tazatel. „Bůh je jen jeden a kromě něho není jiného. ");
INSERT INTO ceslb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Milovat ho z celého srdce, celým rozumem a vší silou své vůle a druhé lidi milovat jako sebe – to je víc než všechny oběti zvířat na oltáři.“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","„Ty nejsi daleko od Božího království,“ ocenil jeho postoj Ježíš. Pak už se ho nikdo neodvážil na nic zeptat. ");
INSERT INTO ceslb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Později, když Ježíš učil v chrámu, položil otázku: „Z čeho náboženští učitelé usuzují, že Kristus musí být potomkem krále Davida? ");
INSERT INTO ceslb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Vždyť sám David napsal, inspirován Duchem svatým: ‚Bůh řekl mému Pánu: Seď po mé pravici, dokud ti tvé nepřátele nepoložím k nohám.‘ ");
INSERT INTO ceslb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Když ho David nazývá svým Pánem, jak by tedy mohl být Davidovým synem?“ Ježíš měl vždycky mnoho pozorných posluchačů. ");
INSERT INTO ceslb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jednou je varoval: „Dejte si pozor na učitele, kteří se na veřejnosti procházejí v krásných šatech a čekají, že je lidé budou uctivě zdravit a klanět se jim. ");
INSERT INTO ceslb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rádi si zajišťují přední sedadla v modlitebnách a čestná místa na hostinách. ");
INSERT INTO ceslb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vyjídají vdovské domy tím, že si dávají platit za modlitby, které úmyslně protahují. Protože učí jiné a takhle se chovají, Bůh je potrestá tím přísněji.“ ");
INSERT INTO ceslb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jednou si Ježíš sedl proti chrámové pokladně a pozoroval lidi. Mnozí bohatí tam vkládali značné částky peněz. ");
INSERT INTO ceslb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Přišla také jedna chudá vdova a do pokladny vhodila dvě drobné mince. ");
INSERT INTO ceslb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ježíš si zavolal své učedníky a řekl jim: „Poslyšte, ta chudá vdova vlastně dala víc než boháči. ");
INSERT INTO ceslb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ti dávali jen přebytky, bez kterých se snadno obejdou, ale ta žena dala všechno, co měla na živobytí.“ ");
INSERT INTO ceslb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Když vycházel z chrámu, řekl mu jeden z jeho učedníků: „Podívej, Mistře, z jakých mohutných kvádrů je chrám vystavěn. Není to krása?“ ");
INSERT INTO ceslb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","„Z téhle krásy,“ zachmuřil se Ježíš, „nezbude nic než rozvaliny. Vše bude rozbořeno.“ ");
INSERT INTO ceslb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Vyhledal tiché místo na svahu Olivové hory, odkud byl výhled na chrám. Petr, Jakub, Jan a Ondřej se ho ptali, ");
INSERT INTO ceslb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","kdy ta pohroma nastane a jaké varování ji bude předcházet. ");
INSERT INTO ceslb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ježíš začal hovořit: „Dejte si pozor, aby vás někdo neoklamal. ");
INSERT INTO ceslb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mnozí přijdou a budou tvrdit, že oni spasí svět. A řadu lidí zmatou. ");
INSERT INTO ceslb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na mnohých místech vzplanou války a nepokoje. Neděste se, to bude znamení konce, ale ještě ne konec světa. ");
INSERT INTO ceslb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Znepřátelí se národ s národem, stát se státem. Na různých místech budou zemětřesení, nastane hlad. Ale to bude jen počátek porodních bolestí nového věku. ");
INSERT INTO ceslb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nedejte se překvapit. Budou vás vláčet před soudy, bičovat v synagogách, předvedou vás před vlády a krále, protože jste moji následovníci. A to bude vaše příležitost, abyste jim svědčili, že já jsem přišel zachránit svět. ");
INSERT INTO ceslb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dříve, než nastane konec světa, musí se o mně dozvědět lidé všech národů. ");
INSERT INTO ceslb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Až vás budou vyslýchat, nestarejte se předem, jak budete odpovídat. Duch svatý vám dá pravá slova. ");
INSERT INTO ceslb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bude to těžká doba; bratr vydá na smrt svého bratra, otec syna. Děti se postaví proti rodičům a zničí je. ");
INSERT INTO ceslb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","A vy? Vás budou všichni nenávidět, protože jste mi oddáni. Ale kdo se mne přes všechno nezřekne, bude spasen. ");
INSERT INTO ceslb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","To, co se odehraje zde v Jeruzalémě, bude obrazem událostí na konci světa. Až bude chrám znesvěcen, nečekejte na nic a utečte do hor. ");
INSERT INTO ceslb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Budete-li na schodišti, už se nevracejte do domu, abyste si něco vzali s sebou. ");
INSERT INTO ceslb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Budete-li pracovat na poli, nechoďte se domů převléknout. ");
INSERT INTO ceslb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Zle bude v těchto dnech těhotným ženám a kojícím matkám. ");
INSERT INTO ceslb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Proste Boha, abyste nemuseli utíkat v zimě. ");
INSERT INTO ceslb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Také na konci věků budou strašné doby, jaké tu od stvoření světa nebyly. ");
INSERT INTO ceslb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kdyby Bůh ty dny nezkrátil, žádný člověk by nebyl zachráněn. Ale zkrátí je pro záchranu svých vyvolených. ");
INSERT INTO ceslb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","A když vám někdo řekne: Hleďte, tenhle je spasitel nebo tamten – nevěřte! ");
INSERT INTO ceslb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ukáže se mnoho falešných spasitelů a lživých proroků a budou dělat lecjaké zázraky ve snaze obelstít všechny, kteří patří Bohu – kdyby to bylo možné. ");
INSERT INTO ceslb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Předem vás varuji, dejte si na ně pozor. ");
INSERT INTO ceslb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Po těchto útrapách se slunce zatmí, měsíc přestane svítit, ");
INSERT INTO ceslb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","hvězdy budou padat a zákony vesmíru budou otřeseny. ");
INSERT INTO ceslb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A pak uvidíte mne – skutečného Spasitele, jak přicházím v oblacích s mocí a slávou. ");
INSERT INTO ceslb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Vyšlu své posly, aby shromáždili moje vyvolené ze všech koutů světa. ");
INSERT INTO ceslb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Posuzujte znamení té doby, jako pozorujete ovocné stromy: Nejprve raší listí, pak stromy nasazují na květ a potom na ovoce; tehdy víte, že brzo přijde sklizeň. ");
INSERT INTO ceslb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Až se stanou ty věci, o kterých jsem hovořil, vězte, že konec je blízko, přede dveřmi. ");
INSERT INTO ceslb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Již vaše generace se přesvědčí o pravdivosti mých slov. ");
INSERT INTO ceslb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nebe a země zaniknou, ale má slova nepozbudou platnosti. ");
INSERT INTO ceslb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Dnes nikdo, ani andělé, ani já, neznáme den a hodinu, kdy se to má stát; jen můj Otec to ví přesně. ");
INSERT INTO ceslb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A protože to ani vy nemůžete vědět, buďte bdělí. Čekejte na mne. ");
INSERT INTO ceslb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Můj příchod bude jako návrat muže, který odcestoval do ciziny. Svým zaměstnancům uložil práci, kterou mají zatím vykonávat, a vrátnému poručil, aby bděl. ");
INSERT INTO ceslb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Buďte ostražití! Vždyť nevíte, kdy se mám vrátit. Může to být večer, v noci, za svítání nebo i za bílého dne. ");
INSERT INTO ceslb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nerad bych vás našel spící. Očekávejte můj návrat. ");
INSERT INTO ceslb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Říkám vám i všem po vás: Bděte!“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","9","Dva dny před židovskými Velikonocemi byl Ježíš v Betanii hostem u Šimona, zvaného Malomocný. Právě byli u stolu, když do domu přišla žena s alabastrovou nádobkou drahocenného vonného oleje z pravého nardu. Otevřela ji a olej vylila na Ježíšovu hlavu. Některým se to zdálo přehnané a říkali si mezi sebou: „K čemu takové plýtvání? Vždyť ten olej měl cenu přes tři sta denárů. Mohli jsme ho prodat a výtěžek rozdat chudým.“ Vyčetli to i té ženě. Ale Ježíš se jí ujal: „Nechte ji. Proč jí kazíte radost? Vždyť ona to myslí dobře. Chudých bude vždycky dost a budete mít příležitost jim pomáhat, ale já od vás odejdu. Udělala, co mohla. Vlastně předem ošetřila moje tělo, jako se to dělá před pohřbem. Poslyšte, co vám teď řeknu: Kdekoliv po světě se bude mluvit o mně, tam se také bude připomínat tento její čin.“ Mezitím se radili velekněží a učitelé zákona, jak by Ježíše nenápadně zatkli a odstranili. Usnesli se: „Nesmíme to udělat o svátcích, aby nevznikly nepokoje, když je v Jeruzalémě mnoho poutníků.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jidáš Iškariotský, jeden z dvanácti Ježíšových učedníků, nabídl vedoucím židovským kněžím, že jim Ježíše vydá, až bude na nějakém opuštěném místě. ");
INSERT INTO ceslb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","To právě potřebovali, a tak mu za to slíbili peněžitou odměnu. Od té chvíle čekal Jidáš na svou příležitost. ");
INSERT INTO ceslb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","První den svátků, kdy se zabíjel a jedl velikonoční beránek, zeptali se učedníci Ježíše: „Kde máme připravit velikonoční večeři?“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ježíš poslal dva z nich do města; měli potkat člověka se džbánem vody ");
INSERT INTO ceslb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","a sledovat ho až do domu. Majiteli toho domu měli říci: „Mistr prosí, abys nám ukázal místnost, kde máme jíst velikonoční večeři.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A on jim měl ukázat velikou jídelnu v patře, zařízenou a připravenou. Tam měli prostřít k jídlu. ");
INSERT INTO ceslb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dva z učedníků šli tedy do města, podle Ježíšova návodu našli dům a připravili velikonočního beránka. ");
INSERT INTO ceslb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Večer tam přišel Ježíš s ostatními. ");
INSERT INTO ceslb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Při večeři se na ně obrátil: „Poslyšte, co vám řeknu: Jeden z vás, kteří jste se mnou u stolu, mě zradí.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Zaraženě na sebe pohlédli: „Koho tím míní? Snad ne mne?“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Opakoval jim: „Je to jeden z vás dvanácti, který si nabírá ze stejné mísy se mnou. ");
INSERT INTO ceslb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jdu cestou, která je mi určena, ale běda tomu člověku, který se propůjčil ke zradě. Bylo by pro něho lépe, kdyby se byl nenarodil.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na závěr večeře vzdal Ježíš díky Bohu za chléb, lámal ho a podával kousky stolovníkům se slovy: „Jezte, to je moje tělo!“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pak se pomodlil nad kalichem vína a podával jim ho všem se slovy: ");
INSERT INTO ceslb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","„To je moje krev, prolitá za mnohé jako pečeť nové smlouvy mezi Bohem a člověkem. ");
INSERT INTO ceslb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A já vám říkám, že už neokusím jiného vína až do té doby, než s vámi zasednu k hostině v Božím království.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nakonec zazpívali píseň a vyšli ven na Olivovou horu. ");
INSERT INTO ceslb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Cestou jim Ježíš řekl: „Tuto noc mě všichni opustíte. Prorok o tom napsal: ‚Zabijí pastýře a ovce se rozprchnou.‘ ");
INSERT INTO ceslb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ale vstanu z mrtvých a půjdu napřed do Galileje, kde se setkáme.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","„I kdyby tě všichni zradili, já tě neopustím,“ prohlásil Petr. ");
INSERT INTO ceslb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","„Poslyš, co ti řeknu,“ odvětil Ježíš. „Dřív než kohout ráno podruhé zakokrhá, třikrát mne zapřeš.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","„Kdybych měl i zemřít, nezapřu tě,“ zapřísahal se Petr. Ostatní slibovali podobně. ");
INSERT INTO ceslb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Přišli do olivového sadu, zvaného Getsemane. „Počkejte tady na mne, než se pomodlím,“ požádal Ježíš učedníky. ");
INSERT INTO ceslb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Vzal s sebou jenom Petra, Jakuba a Jana. Ti viděli, že Ježíše se zmocňuje strach a tíseň. ");
INSERT INTO ceslb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Netajil se tím: „Je mi těžko až k smrti. Zůstaňte tady a bděte se mnou.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Odešel kousek dál, padl na zem a modlil se, aby byl ušetřen nastávajících hodin, kdyby to bylo možné. ");
INSERT INTO ceslb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","„Otče, Otče,“ volal, „ty máš všechny možnosti. Ušetři mne toho kalicha utrpení. Nehleď však na to, co chci já, podrobím se poslušně tvé vůli.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Vrátil se k těm, které vzal s sebou, a viděl, že spí. Probudil Petra: „Šimone, jak můžeš spát? To nedokážeš se mnou bdít ani tu chvíli? ");
INSERT INTO ceslb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Probuďte se a modlete se, abyste obstáli v přicházející zkoušce. Odhodlání nestačí, když člověk nemá dost sil.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A opět odešel a modlil se jako předtím. ");
INSERT INTO ceslb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Když se k nim vrátil podruhé, spali zase, protože byli velmi unaveni. Nevěděli, co říci na svou omluvu. ");
INSERT INTO ceslb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Když přišel potřetí, řekl jim: „Ještě spíte? Ještě odpočíváte? Už dost! Přichází chvíle, kdy Syn člověka bude vydán do rukou zlých lidí. ");
INSERT INTO ceslb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Vstaňte a pojďte, můj zrádce už je zde.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jen to dořekl, přicházel Jidáš – jeden z dvanácti nejbližších, a s ním velký zástup mužů, ozbrojených meči a obušky. Byla to chrámová stráž, poslaná velekněžími. ");
INSERT INTO ceslb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aby se ve tmě nezmýlili, zrádce si s nimi smluvil toto znamení: „Kterého z nich políbím na pozdrav, to je on. Chyťte ho a dobře držte.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Přistoupil tedy k Ježíši a se slovem „Mistře“ ho políbil. ");
INSERT INTO ceslb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ozbrojenci Ježíše popadli a zajali ho. ");
INSERT INTO ceslb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jeden z jeho učedníků vytasil meč a sekl po jednom z útočníků tak, že mu uťal ucho. ");
INSERT INTO ceslb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ježíš se hájil pouze slovy: „Cožpak jsem zločinec, že jste na mne přitáhli jako do boje? ");
INSERT INTO ceslb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Každý den jsem přece učíval v chrámu, ale tam jste se na mne neodvážili. Ani nevíte, jak přesně plníte proroctví řečená o mně.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ježíšovi učedníci se rozprchli. ");
INSERT INTO ceslb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pouze jeden chlapec narychlo oblečený sledoval Ježíše z povzdálí. Strážci ho chytili za plášť, ");
INSERT INTO ceslb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ale on se z něj vyvlékl a utekl nahý. ");
INSERT INTO ceslb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ježíše odvedli k veleknězi, který ihned svolal nejvyšší židovskou radu. ");
INSERT INTO ceslb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petr se opatrně vydal za nimi, a tak se dostal až na nádvoří veleknězova paláce. Posadil se k ohni strážců a hřál se s nimi. ");
INSERT INTO ceslb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mezitím velekněz a jeho poradní sbor marně hledali člověka, který by dosvědčil, že Ježíš spáchal nějaký hrdelní zločin. ");
INSERT INTO ceslb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Měli dost falešných svědků, ale jejich výpovědi si příliš odporovaly. ");
INSERT INTO ceslb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Několik se jich shodlo na Ježíšově výroku: „Zbořím tento chrám, postavený rukama. Za tři dny pak postavím jiný a nebude k tomu třeba lidských rukou.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ale ani tato svědectví nebyla jednotná. ");
INSERT INTO ceslb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Velekněz se ujal slova a zeptal se Ježíše: „Jak vyvrátíš tato obvinění?“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ježíš však mlčel a nijak se nehájil. „Jsi Kristus, Boží Syn?“ dotíral velekněz. ");
INSERT INTO ceslb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","„Ano, jsem,“ potvrdil Ježíš. „Uvidíte mne, jak sedím po Boží pravici a jak se vracím na zem z nebeských oblaků.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Teď velekněz roztrhl svoje vnější roucho na znamení pobouření a vykřikl: „Nač ještě svědky? ");
INSERT INTO ceslb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sami jste slyšeli, jak se rouhá. Co si zaslouží?“ Jednohlasně ho odsoudili k smrti. Někteří se vrhli dopředu, ");
INSERT INTO ceslb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","plivali na Ježíše, pak mu zavázali oči, políčkovali ho a křičeli: „Hádej, kdo to byl, ty proroku?“ A také strážci ho začali bít obušky. ");
INSERT INTO ceslb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Mezitím jedna z veleknězových služek uviděla Petra u ohně, prohlédla si ho a řekla: „Ty jsi také jeden z těch, co chodili s tím Nazaretským Ježíšem!“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","„Nechápu, o čem mluvíš,“ zapíral. Vykradl se z nádvoří a tehdy poprvé zakokrhal kohout. ");
INSERT INTO ceslb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Služka ho za chvíli opět zahlédla a začala vykládat okolostojícím: „Je to jeden z jeho přívrženců!“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petr to však znovu popřel. Kdosi se na něj osopil: „Určitě k nim patříš, máš taky galilejský přízvuk.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tu se Petr začal dušovat a přísahal: „Neznám vůbec toho člověka, o kterém mluvíte.“ ");
INSERT INTO ceslb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A právě tehdy zakokrhal kohout podruhé. To připomnělo Petrovi Ježíšova slova, že ho třikrát zapře, než kohout dvakrát zakokrhá. Vyběhl ven a propukl v pláč. ");
INSERT INTO ceslb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Brzy ráno velekněží s nejvyšší židovskou radou vynesli nad Ježíšem rozsudek smrti a poslali ho v poutech k římskému místodržiteli Pilátovi. ");
INSERT INTO ceslb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","„Tak ty jsi ten král Židů?“ ušklíbl se Pilát. „Jak říkáš,“ odpověděl Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Velekněží ho u Piláta obvinili z mnoha zločinů. ");
INSERT INTO ceslb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","„Co ty na?“ dal mu slovo místodržitel. „Co odpovíš na všechny ty žaloby?“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ježíš však už ani nepromluvil, nehájil se. Divný zločinec! ");
INSERT INTO ceslb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vždy o Velikonocích amnestoval místodržitel podle volby lidu jednoho ze židovských vězňů. ");
INSERT INTO ceslb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pro výtržnost a vraždu seděl ve vězení jakýsi Barabáš se svými kumpány. ");
INSERT INTO ceslb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Před Pilátovým sídlem se shromáždil dav a začal se dovolávat tradiční amnestie. ");
INSERT INTO ceslb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilát toho využil a promluvil k nim: „Chcete, abych propustil toho židovského krále?“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tušil totiž, že velekněží ho odsoudili k smrti, protože se báli jeho vlivu na lidi. ");
INSERT INTO ceslb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ale velekněžími navedená chátra žádala propuštění Barabáše. ");
INSERT INTO ceslb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","„Co tedy mám udělat s tím, kterému říkáte židovský král?“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","„Ukřižovat!“ ozvaly se výkřiky. ");
INSERT INTO ceslb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","„Ale za jaký zločin?“ namítal Pilát. Lůza však skandovala: „Na kříž! Na kříž!“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilát tedy ustoupil nátlaku davu, dal propustit z vězení Barabáše a Ježíše vydal popravčí četě, aby ho zbičovali a ukřižovali. ");
INSERT INTO ceslb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Vojáci odvedli Ježíše na nádvoří vládní budovy a svolali celou rotu. ");
INSERT INTO ceslb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Oblékli ho do purpurové látky jako do královského pláště, spletli věnec z trní a posadili mu ho na hlavu jako korunu. ");
INSERT INTO ceslb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Začali ho výsměšně zdravit a volali: „Ať žije židovský král!“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bili jej holí do hlavy, plivali na něj a pak si zase před něj klekali a klaněli se mu. ");
INSERT INTO ceslb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Když se dost pobavili, svlékli mu zase purpurový plášť, oblékli mu jeho vlastní šaty a vedli ho na popraviště. ");
INSERT INTO ceslb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ježíš nemohl těžký kříž sám unést. Do města právě přicházel jistý Šimon, rodák z Kyrény, a toho vojáci přinutili, aby mu pomohl. (Šimon je otec pozdějších křesťanů Alexandra a Rufa.) ");
INSERT INTO ceslb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tak přivedli Ježíše až na popraviště, které se jmenovalo Golgota, což znamená Lebka. ");
INSERT INTO ceslb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nabídli mu víno s omamnou příměsí, ale on je odmítl. ");
INSERT INTO ceslb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pak jej přibili na kříž a losovali o jeho šaty. ");
INSERT INTO ceslb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Poprava se konala v devět hodin ráno. ");
INSERT INTO ceslb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ježíšovu vinu oznamoval nápis nad jeho hlavou: „Židovský král“. ");
INSERT INTO ceslb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Zároveň s ním ukřižovali dva zločince; jednoho po pravé a druhého po levé straně. ");
INSERT INTO ceslb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Splnila se tak prorocká předpověď: „Je zahrnut mezi zločince.“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kolemjdoucí mu nadávali a vysmívali se mu: „Tak tys nám chtěl zbořit chrám a za tři dny ho zase postavit? ");
INSERT INTO ceslb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Když jsi tak mocný, pomoz si sám a sestup z kříže!“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mezi posměvači byla i skupina významných kněží a učitelů zákona, kteří si mezi sebou říkali: „Jiným pomáhal a teď je bezmocný. ");
INSERT INTO ceslb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jestli je to opravdu Mesiáš, zaslíbený král Izraele, ať sestoupí z kříže. To nás přesvědčí a uvěříme mu.“ A také zločinci na křížích mu spílali. ");
INSERT INTO ceslb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","V poledne se náhle setmělo a zlověstné šero trvalo až do tří hodin. ");
INSERT INTO ceslb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ve tři hodiny odpoledne vykřikl Ježíš: „Eloi, Eloi, lema sabachtani?“ Jsou to úvodní slova dvacátého druhého žalmu: „Bože můj, Bože můj, proč jsi mne opustil?“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Někteří z přihlížejících mu nerozuměli a domnívali se, že volá na pomoc proroka Elijáše. ");
INSERT INTO ceslb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jeden z nich připevnil na hůl houbu nasátou kyselým vínem a přistrčil mu ji ke rtům se slovy: „Počkáme si, zda mu Elijáš přijde na pomoc.“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ježíš vykřikl ještě jednou a zemřel. ");
INSERT INTO ceslb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","V tu chvíli se opona, která zastírala nejsvatější místnost chrámu, roztrhla napůl od shora až dolů. ");
INSERT INTO ceslb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Římský setník, který velel popravčí četě a byl svědkem Ježíšových posledních chvil, zvolal: „Ten člověk byl opravdu Boží Syn!“ ");
INSERT INTO ceslb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Zpovzdálí přihlížely některé ženy, mezi nimi Marie Magdaléna, Marie, matka Jakuba „malého“ a Josefa, a Salome. ");
INSERT INTO ceslb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ty v něho uvěřily už kdysi v Galileji a od té doby mu sloužily. A byly tu i jiné ženy, které s ním přišly do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nastával páteční večer, pro židy začátek sobotního svátku. ");
INSERT INTO ceslb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josef z Arimatie, vážený člen velerady, který také vyhlížel Mesiášovu vládu, přišel odvážně k Pilátovi a žádal Ježíšovo tělo. ");
INSERT INTO ceslb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Místodržitel se podivil, že by Ježíš tak brzy zemřel. Zavolal si velitele popravčí čety a zeptal se ho na to. ");
INSERT INTO ceslb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Když mu to setník potvrdil, přikázal vydat Ježíšovo tělo Josefovi. ");
INSERT INTO ceslb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ten koupil plátno, a když sňali Ježíšovo tělo z kříže, zavinul je a uložil do vlastní hrobky, vytesané ve skále. Před vchod přivalili kamennou desku. ");
INSERT INTO ceslb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Marie Magdaléna a Marie Josefova je sledovaly, a věděly tak, kde je Ježíš pohřben. ");
INSERT INTO ceslb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","V sobotu večer, když skončil svátek, Marie Magdaléna, Jakubova matka Marie a Salome nakoupily vonné masti, aby jimi podle židovského zvyku potřely Ježíšovo tělo. ");
INSERT INTO ceslb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Druhý den, již za svítání, šly ke hrobu. ");
INSERT INTO ceslb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cestou hovořily o tom, kdo jim odstraní obrovský kámen, kterým byl vchod zatarasen. ");
INSERT INTO ceslb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Když tam došly, pohlédly na hrob a zjistily, že kámen už někdo odvalil. Vchod byl volný. ");
INSERT INTO ceslb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vešly do hrobky a na pravé straně uviděly sedět mladého muže v bílých šatech. Ženy se ho velice lekly, ");
INSERT INTO ceslb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ale on jim řekl: „Nebojte se! Hledáte ukřižovaného Ježíše Nazaretského? Není tady, vstal z mrtvých. Podívejte se na místo, kam ho položili; je prázdné. ");
INSERT INTO ceslb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jděte a ohlaste jeho učedníkům i Petrovi, že půjde napřed do Galileje. Tam ho uvidíte, jak vám to před svou smrtí řekl.“ ");
INSERT INTO ceslb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ženy vyšly ven a utíkaly pryč, protože se vyděsily. Ze strachu o tom ani nikomu neřekly. ");
INSERT INTO ceslb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ježíš Kristus vstal z mrtvých časně ráno v neděli. Nejprve se ukázal Marii Magdaléně, ženě, ze které kdysi vyhnal sedm démonů. ");
INSERT INTO ceslb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta šla a oznámila to Ježíšovým učedníkům, které nalezla plačící a zoufalé. ");
INSERT INTO ceslb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Vyprávěla jim, že Ježíš žije a že ho viděla, ale nevěřili. ");
INSERT INTO ceslb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pak se Ježíš za jiných okolností ukázal dalším dvěma, kteří odcházeli z Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Když ho poznali, vrátili se, aby to sdělili ostatním. Ale ani těm neuvěřili. ");
INSERT INTO ceslb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Později se ukázal svým jedenácti apoštolům, právě když jedli. Káral je pro jejich nevěru a nechápavost, když odmítali uvěřit, že je živ. ");
INSERT INTO ceslb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pověřil je úkolem: „Jděte do celého světa a neste všem lidem radostnou zprávu: ");
INSERT INTO ceslb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kdo uvěří ve mne a dá se pokřtít, bude zachráněn; kdo však neuvěří, toho Bůh odsoudí. ");
INSERT INTO ceslb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Věřící dostanou různé důkazy moci: budou mým jménem vyhánět démony a mluvit novými jazyky. ");
INSERT INTO ceslb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bez nebezpečí budou brát do ruky hady a jedovatý nápoj jim neuškodí. Svým dotykem budou uzdravovat nemocné.“ ");
INSERT INTO ceslb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Po těchto slovech byl Pán Ježíš vzat do nebe a zaujal své místo po Boží pravici. ");
INSERT INTO ceslb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jeho apoštolové se rozešli do světa a všude zvěstovali radostnou zprávu o Kristu. Pán jim pomáhal a jejich slova potvrzoval mocnými činy.");
INSERT INTO ceslb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Vážený Teofile! Mnozí přede mnou se snažili pravdivě vylíčit život a dílo Ježíše Krista na základě spolehlivých zpráv jeho žáků a jiných očitých svědků. ");
INSERT INTO ceslb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nyní jsem se tedy rozhodl i já důkladně přezkoumat, utřídit a sepsat veškeré dostupné zprávy. Vznikl tento spisek, který ti věnuji, ");
INSERT INTO ceslb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","abys nabyl jistoty, že to, o čem ses již leccos dověděl, je pravda. ");
INSERT INTO ceslb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Začnu tím, co se přihodilo židovskému knězi Zachariášovi, který žil v době vlády judského krále Heroda. Zachariáš byl členem jedné ze čtyřiadvaceti kněžských skupin, jejichž povinností bylo dvakrát do roka, vždy po celý týden, přisluhovat při bohoslužbách v jeruzalémském chrámu. Jeho manželka Alžběta pocházela z kněžského rodu Árónova. ");
INSERT INTO ceslb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oba byli upřímně zbožní a řídili se svědomitě všemi Božími příkazy a předpisy. ");
INSERT INTO ceslb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Byli to již starší lidé a zůstali bezdětní, protože Alžběta byla neplodná. ");
INSERT INTO ceslb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jednoho dne šel Zachariáš do chrámu, aby tam splnil svoji kněžskou povinnost. ");
INSERT INTO ceslb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tentokrát byl vylosován, aby vstoupil do svatyně a tam na oltáři pálil kadidlo. ");
INSERT INTO ceslb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zatím se venku shromáždění lidé modlili, jak bylo v té hodině zvykem. ");
INSERT INTO ceslb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tu se knězi po pravé straně oltáře ukázala postava. ");
INSERT INTO ceslb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zachariáš se vyděsil. ");
INSERT INTO ceslb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Boží posel ho však uklidňoval: „Neboj se, Zachariáši! Přišel jsem ti oznámit, že Bůh vyslyšel tvé modlitby. Tvoje manželka porodí syna, kterému dáte jméno Jan (Bůh je milostivý). ");
INSERT INTO ceslb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Přinese ti mnoho radosti a mnozí budou vděčni, že se narodil. ");
INSERT INTO ceslb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Stane se jedním z velkých Božích mužů. Nedotkne se nikdy vína ani opojného nápoje. Duch svatý ho naplní hned od narození. ");
INSERT INTO ceslb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mnohé z židů přivede zpět k Bohu, jejich skutečnému Pánu. ");
INSERT INTO ceslb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Svou duchovní mocí a horlivostí bude připomínat proroka Elijáše. Smíří otce se syny a vzpurným otevře oči pro pravdu. Jako královský posel připraví lidi na příchod Božího vládce.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zachariáš namítl: „Jak tomu mohu věřit? Vždyť jsem už starý a moje žena také není mladá.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anděl ho pokáral: „Já jsem Gabriel a přijímám rozkazy přímo od Boha. On sám mě poslal, abych ti vyřídil tyto radostné zprávy. ");
INSERT INTO ceslb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Protože jsi však neuvěřil, budeš němý, dokud se má slova ve svůj čas nesplní.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lidé zatím venku čekali na Zachariáše a už jim bylo divné, že tak dlouho nejde. ");
INSERT INTO ceslb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Když se konečně objevil, nemohl promluvit. Posunky jim dal najevo, že měl ve svatyni vidění. ");
INSERT INTO ceslb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Když skončil týden jeho chrámové služby, vrátil se domů. ");
INSERT INTO ceslb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Brzy na to Alžběta otěhotněla, ale tajila to před veřejností až do pátého měsíce. ");
INSERT INTO ceslb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Radovala se: „Bůh se nade mnou slitoval a sejmul ze mne pohrdání a neúctu lidí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Asi půl roku po Zachariášově vidění poslal Bůh anděla Gabriela do galilejského městečka Nazaretu ");
INSERT INTO ceslb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","k dívce jménem Marie. Byla snoubenkou Josefa, který pocházel z Davidova královského rodu. ");
INSERT INTO ceslb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anděl ji oslovil: „Blahopřeji ti, Marie, Bůh ze všech žen vyvolil právě tebe k velikému úkolu!“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jeho slova ji znepokojila a nechápala jejich smysl. ");
INSERT INTO ceslb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Posel pokračoval. „Neboj se, Marie. Bůh ti chce nevídaně požehnat. ");
INSERT INTO ceslb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Narodí se ti syn a dáš mu jméno Ježíš (Bůh vysvobozuje). ");
INSERT INTO ceslb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nebude to obyčejný člověk, ale právem bude nazýván ‚Syn Nejvyššího‘. ");
INSERT INTO ceslb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Usedne na trůn Davidův a bude nejen vládce Izraele, ale založí království, které nikdy neskončí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marie namítla: „Jak se mi může narodit dítě? Vždyť nežiji s mužem!“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anděl jí řekl: „Sám Stvořitel na tobě projeví svou moc. Duch svatý to způsobí, a tak tvé dítě bude svatý Boží Syn. U Boha není nic nemožného. ");
INSERT INTO ceslb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Vždyť i tvá příbuzná Alžběta, po celý život neplodná, bude mít nyní ve svém stáří syna. Již za tři měsíce se jí narodí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marie na to řekla: „Chci přijmout, co mi Bůh ukládá. Ať se tedy stane, jak jsi řekl.“ Pak anděl odešel. ");
INSERT INTO ceslb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Brzy nato se Marie vydala do judských hor, do města, kde žil Zachariáš s Alžbětou. ");
INSERT INTO ceslb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","41","Když k nim vešla a pozdravila, pocítila Alžběta, jak se její dítě živě pohnulo. V tu chvíli Alžbětu nadchl Boží Duch ");
INSERT INTO ceslb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a zvolala: „Marie, Bůh tě vyvolil mezi všemi ženami a tvůj syn bude veliký dar lidem. ");
INSERT INTO ceslb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jaká je to pro mne čest, že mne navštívila matka mého Pána! ");
INSERT INTO ceslb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sotva jsem zaslechla tvůj pozdrav, děťátko ve mně radostí poskočilo. ");
INSERT INTO ceslb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jak je dobře, že jsi uvěřila Božím slibům. On je všechny splní.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nato se Marie začala modlit: „Celým srdcem chválím Pána ");
INSERT INTO ceslb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","a raduji se v Bohu, svém Spasiteli. ");
INSERT INTO ceslb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Mne, nepatrné, si povšiml. Lidé ze všech národů si mne budou vděčně připomínat pro velké věci, které mi Bůh prokázal. Je mocný a svatý, ");
INSERT INTO ceslb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ale neustále se slitovává nad těmi, kteří ho ctí v kterékoliv době. ");
INSERT INTO ceslb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Vztahuje svoji mocnou ruku, aby mařil plány pyšných, ");
INSERT INTO ceslb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","aby sesazoval mocné z trůnů, pozvedal ponížené, ");
INSERT INTO ceslb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","sytil hladové dobrými věcmi a bohaté propouštěl s prázdnýma rukama. ");
INSERT INTO ceslb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ujímá se svého lidu, Izraele, protože slíbil našim otcům, Abrahamovi i jeho potomkům, že k nim bude na věky milosrdný.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marie pobyla u Alžběty asi tři měsíce a pak se vrátila domů. ");
INSERT INTO ceslb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Přišel Alžbětin čas a narodil se jí syn. ");
INSERT INTO ceslb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Všichni sousedé a příbuzní se radovali, že ji Bůh tak obšťastnil. ");
INSERT INTO ceslb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sešli se osmého dne, kdy podle zákona bývali chlapci obřezáváni. Všichni předpokládali, že dítě se bude jmenovat po otci Zachariáš. ");
INSERT INTO ceslb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Alžběta však chtěla, aby se jmenoval Jan. ");
INSERT INTO ceslb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Namítali: „Ale vždyť se tak ve vaší rodině nikdo nejmenoval.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Žádali, aby se k tomu vyjádřil otec. ");
INSERT INTO ceslb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ten vzal tabulku a k překvapení všech napsal: „Jeho jméno je Jan.“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A tehdy se jeho ústa zase otevřela a prvními slovy děkoval Bohu. ");
INSERT INTO ceslb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Užaslí sousedé pochopili, že se tu děje něco mimořádného, a zpráva o tom se roznesla po judských horách. ");
INSERT INTO ceslb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kdo ji slyšel, uvažoval, co s tím dítětem Bůh zamýšlí. Všichni viděli, že ho provází Boží moc. ");
INSERT INTO ceslb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Duch svatý vnukl Zachariášovi tato prorocká slova: ");
INSERT INTO ceslb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","„Chvála Pánu, Bohu Izraele, že přichází svému lidu na pomoc a vysvobozuje ho. ");
INSERT INTO ceslb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Posílá nám mocného Zachránce z rodu krále Davida, ");
INSERT INTO ceslb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kterého již dávno ústy svých proroků ohlašoval. ");
INSERT INTO ceslb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ten nás vytrhne z rukou nepřátel a všech, kteří nás nenávidí. ");
INSERT INTO ceslb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dnes se Bůh láskyplně přiznává k našim otcům a ke své smlouvě s nimi. ");
INSERT INTO ceslb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","78","Vždyť se zavázal Abrahamovi, že jednou budeme sloužit Bohu po celý život, zbaveni útlaku a strachu, očištěni a poslušni. A ty, synu, budeš prorokem Nejvyššího. Připravíš cestu Božímu Synu: Lidem budeš ohlašovat, že je přichází zachránit a odpustit jim všechna provinění. V něm k nám přichází Bůh plný slitovné lásky. Slunce spásy již vychází, ");
INSERT INTO ceslb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","aby zazářilo všem, kdo žijí ve tmách a ve stínu smrti, a osvítilo nám cestu ke smíření s Bohem!“ ");
INSERT INTO ceslb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chlapec Jan se dobře rozvíjel tělesně i duševně. Později odešel na poušť, kde žil v ústraní až do chvíle, kdy vystoupil se svým poselstvím před veřejností. ");
INSERT INTO ceslb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","V té době nařídil císař Augustus, aby bylo provedeno sčítání lidu v celé římské říši. ");
INSERT INTO ceslb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Byl to první soupis a prováděl ho římský místodržitel v Sýrii Quirinius. ");
INSERT INTO ceslb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Každý byl povinen dát se zapsat v místě, odkud pocházel jeho rod. ");
INSERT INTO ceslb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Tak se vydal na cestu i Josef s Marií, která byla již ve vysokém stupni těhotenství. Putovali z galilejského Nazaretu do judského městečka Betléma, rodiště krále Davida; Josef totiž pocházel z jeho rodu. ");
INSERT INTO ceslb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sotva tam došli, naplnil se Mariin čas ");
INSERT INTO ceslb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","a porodila svého prvorozeného syna. Zabalila ho do plenek a položila do jeslí, protože v hostinci bylo plno a jinde než ve chlévě už na ně nezbylo místo. ");
INSERT INTO ceslb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nedaleko Betléma pásli pastýři ovce. V noci se střídali v hlídkách u svých stád. ");
INSERT INTO ceslb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Najednou se před nimi objevil anděl a celá krajina se rozzářila odleskem Boží slávy. Velice se ho ulekli, ");
INSERT INTO ceslb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ale anděl je uklidňoval: „Nebojte se, nesu vám dobrou zprávu, ze které se mohou radovat všichni lidé. ");
INSERT INTO ceslb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","V Betlémě, ze kterého před dávnými časy vyšel David, se vám dnes narodil Kristus, Spasitel poslaný od Boha. ");
INSERT INTO ceslb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jak ho poznáte? Najdete malé dítě v plenkách, položené do jeslí v chlévě.“ ");
INSERT INTO ceslb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Potom se k andělu připojilo mnoho dalších andělů a všichni provolávali: ");
INSERT INTO ceslb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","„Sláva Bohu na nebi! Pokoj lidem na zemi! Zjevil lásku všem!“ ");
INSERT INTO ceslb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Andělé je opustili a pastýři si řekli: „Pojďme do Betléma a přesvědčme se o tom, co nám anděl oznámil.“ ");
INSERT INTO ceslb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Rychle se vydali na cestu a skutečně našli Marii s Josefem i novorozeňátko položené v jeslích. ");
INSERT INTO ceslb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Když je uviděli, začali vyprávět, co jim bylo pověděno o tom dítěti. ");
INSERT INTO ceslb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Všichni, kdo je slyšeli, se divili. ");
INSERT INTO ceslb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marie si to zapamatovala a přemýšlela o tom. ");
INSERT INTO ceslb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pastýři se vrátili ke svým stádům, radovali se a děkovali Bohu, že našli všechno tak, jak jim anděl oznámil. ");
INSERT INTO ceslb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Osmý den dali Marie s Josefem chlapce obřezat. Dostal jméno Ježíš, jak to anděl určil ještě před jeho narozením. ");
INSERT INTO ceslb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Mojžíšův zákon přikazoval, aby každá žena čtyřicátý den po narození chlapce přinesla oběť do chrámu. ");
INSERT INTO ceslb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Proto i Marie po této době splnila tuto povinnost. Zároveň s sebou vzali i dítě, aby ho podle jiného Mojžíšova předpisu jako prvorozeného syna zasvětili Bohu. ");
INSERT INTO ceslb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","V Jeruzalémě žil zbožný stařec jménem Simeon. Řídil se Božími přikázáními a očekával Mesiáše. ");
INSERT INTO ceslb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Byl veden Duchem svatým, který ho také ujistil, že nezemře dříve, dokud Mesiáše na vlastní oči neuzří. ");
INSERT INTO ceslb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na pokyn Ducha přišel do chrámu právě ve chvíli, kdy rodiče zasvěcovali Ježíše Bohu. ");
INSERT INTO ceslb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon vzal dítě do náruče a modlil se: ");
INSERT INTO ceslb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","„Pane, děkuji ti, že jsi splnil svůj slib. Nyní mohu klidně zemřít, ");
INSERT INTO ceslb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","protože jsem na vlastní oči viděl Spasitele, ");
INSERT INTO ceslb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kterého dáváš celému světu. ");
INSERT INTO ceslb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pohanům bude světlem a Izraeli slávou.“ ");
INSERT INTO ceslb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josef a Marie se podivili tomu, co Simeon pověděl o dítěti. ");
INSERT INTO ceslb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Potom jim požehnal a Marii ještě řekl: „Toto dítě bude příčinou pádu jedněch a vyvýšení druhých v Izraeli. On je znamení z nebe, proti kterému se mnozí postaví a tak prozradí svoje nejvnitřnější smýšlení. ");
INSERT INTO ceslb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tvé vlastní srdce pronikne bolest jako meč.“ ");
INSERT INTO ceslb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Byla tam také prorokyně Anna, dcera Fanuelova z rodu Ašerova. Po sedmiletém manželství ovdověla a nyní jí bylo čtyřiaosmdesát let. Nevycházela už vůbec z chrámu a její dny i noci byly naplněny službou Bohu, modlitbami a častými posty. ");
INSERT INTO ceslb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","V tu chvíli k nim přistoupila i ona a děkovala za to dítě. Všem, kteří v Jeruzalémě vyhlíželi Spasitele, oznamovala, že očekávaný Mesiáš je již zde. ");
INSERT INTO ceslb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A tak Josef s Marií splnili, co přikazoval zákon. Později se vrátili do Nazaretu v Galileji. ");
INSERT INTO ceslb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dítě rostlo, sílilo a bylo velice moudré. Všichni mohli poznat, že ho Bůh miluje. ");
INSERT INTO ceslb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ježíšovi rodiče putovali každý rok do Jeruzaléma slavit velikonoční svátky. ");
INSERT INTO ceslb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Když bylo Ježíšovi dvanáct let, vzali ho poprvé s sebou. ");
INSERT INTO ceslb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Po slavnosti se všichni vydali na cestu domů, ale Ježíš zůstal bez vědomí rodičů v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ti ho zpočátku ani nepohřešovali. Domnívali se, že zůstal někde vzadu mezi poutníky, kteří s nimi měli stejnou cestu. Protože se však celý den neukázal, sháněli ho mezi příbuznými a známými. ");
INSERT INTO ceslb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Když ho nenašli, vrátili se do Jeruzaléma a hledali ho tam. ");
INSERT INTO ceslb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Po třech dnech ho objevili v chrámu, jak sedí mezi učiteli zákona, naslouchá jim a hovoří k nim. ");
INSERT INTO ceslb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Všichni, kdo ho slyšeli, žasli nad moudrostí, se kterou odpovídal na otázky. ");
INSERT INTO ceslb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Rodiče tím byli překvapeni a matka mu vyčítala: „Chlapče, proč nám děláš takové starosti? Otec a já jsme tě hledali celí zoufalí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ježíš jim odpověděl: „Proč jste mne hledali? Cožpak nevíte, že musím být tam, kde se jedná o záležitosti mého Otce?“ ");
INSERT INTO ceslb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ale oni nepochopili, co tím mínil. ");
INSERT INTO ceslb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ježíš se pak s rodiči vrátil do Nazaretu a poslouchal je. Jeho matka si všechny takové události dobře zapamatovala. ");
INSERT INTO ceslb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","S Ježíšovým věkem rostla i jeho moudrost a byl milý Bohu i lidem. ");
INSERT INTO ceslb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","3","Z Božího pověření Jan Křtitel procházel údolím řeky Jordánu a kázal: „Zanechejte hříšného života a proste Boha, aby vám odpustil. Já vás pokřtím na znamení vašeho pokání.“ Jana, syna Zachariášova, Bůh vyzval, aby vystoupil z ústraní. Stalo se to v patnáctém roce vlády císaře Tiberia. Tehdy byl římským správcem Judska Pontský Pilát, Herodes byl knížetem v Galileji, jeho bratr Filip v Iturii a Trachonitidě a Lyzaniáš v Abiléně. Velekněžský úřad v Jeruzalémě zastávali Annáš a Kaifáš. ");
INSERT INTO ceslb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tak se splnila dávná předpověď proroka Izajáše: „Z pouště volá hlas: Připravte Pánu cestu a odstraňte mu překážky! ");
INSERT INTO ceslb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","6","Zasypejte všechny strže, srovnejte každou horu a pahorek, napřimte křivé stezky a uhlaďte hrbolaté pěšiny, dříve než se zjeví Boží Vysvoboditel všem!“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lidé se k Janovi hrnuli v zástupech, aby se od něho dali pokřtít. Často však od něho slýchali ostrá napomenutí: „Vy chytráci! Myslíte, že se vykroutíte z Božího soudu jako hadi? ");
INSERT INTO ceslb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ovoce pokání jsou činy; dokažte jimi, že se opravdu chcete změnit! Domníváte se, že se vám nemůže nic stát, protože máte praotce Abrahama? To vám nepomůže. Vždyť i z nevěrců tvrdých jako kámen si může Bůh stvořit dědice Abrahamovy víry. Dejte si pozor! ");
INSERT INTO ceslb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na kořeny stromů již míří sekera. Každý strom, který neponese dobré ovoce, bude poražen a vhozen do ohně.“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lidé se ho ptali: „Tak co máme dělat?“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jan jim odpovídal: „Máš dvě košile? Rozděl se s tím, kdo nemá žádnou. Máš co jíst? Rozděl se s tím, kdo hladoví.“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Přicházeli k němu i výběrčí daní a ptali se ho: „Mistře, co máme dělat my?“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A on jim řekl: „Nevymáhejte více, než je stanoveno.“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","I vojáci se ptali: „A co my?“ Těm říkal: „Nikoho netýrejte a nevydírejte, spokojte se se svým žoldem.“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lidé byli plni očekávání Mesiáše a začali se dohadovat, zdali to není Jan. ");
INSERT INTO ceslb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","On to však popřel: „Já vás křtím vodou, ale přichází mocnější, než jsem já. Tomu nejsem hoden ani boty zavázat. Ten vás bude křtít Duchem svatým a pročistí vás ohněm soudu. ");
INSERT INTO ceslb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Již drží lopatu, aby na mlatu proházel zrno a oddělil je od plev. Pšenici shromáždí do své sýpky, ale plevy spálí neuhasitelným ohněm.“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A podobným způsobem mluvil Jan k lidem, aby je vyburcoval a vnitřně připravil na příchod Mesiáše. ");
INSERT INTO ceslb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","I Heroda, vládce Galileje, káral za to, že svému bratru Filipovi přebral manželku Herodiadu, a za všechno další zlo, které napáchal. ");
INSERT INTO ceslb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Později dal Herodes Jana uvěznit a tím svoje zločiny dovršil. ");
INSERT INTO ceslb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jednoho dne přišel se zástupem ke křtu také Ježíš. Byl pokřtěn, a když se modlil, otevřelo se nebe, ");
INSERT INTO ceslb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Duch svatý na něj sestoupil v podobě holubice a ozval se hlas: „Ty jsi můj milovaný Syn, moje radost.“ ");
INSERT INTO ceslb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ježíšovi bylo asi třicet let, když začal veřejně působit. Lidé ho považovali za syna tesaře Josefa. ");
INSERT INTO ceslb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","V Josefově rodokmenu se setkáváme s některými významnými muži historie. Jsou to například Zerubábel – obnovitel chrámu po babylónském zajetí, král David, praotcové Juda, Jákob, Izák, Abraham, Noeho syn Šém, který byl potomkem Šéta a jeho otce Adama, jehož stvořil Bůh. ");
INSERT INTO ceslb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ježíš se vrátil od Jordánu naplněn Duchem svatým a ten ho nyní vedl do ústraní na poušť. ");
INSERT INTO ceslb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pobyl tam čtyřicet dní a po celou tu dobu nic nejedl. Když už byl vyčerpán hladem, přišel k němu ďábel ");
INSERT INTO ceslb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","a pokoušel ho: „Jsi-li opravdu Boží Syn, nadělej si chleba z těchto kamenů.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ježíš odpověděl: „Je psáno v zákoně: ‚Člověku nestačí k životu jen chléb, ale Boží slovo potřebuje vždycky.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Potom ďábel v jediném okamžiku odkryl moc a bohatství všech království světa ");
INSERT INTO ceslb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","a řekl: „To všechno mi patří a mohu to rozdávat, komu se mi zlíbí. ");
INSERT INTO ceslb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Vzdej mi poctu a všechno to bude tvé.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ježíš řekl: „Je psáno, že jedině Boha máme uctívat a jenom jemu se klanět.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nakonec ho ještě ďábel vyvedl na ochoz chrámu a řekl: „Jsi-li Boží Syn, seskoč dolů. ");
INSERT INTO ceslb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Vždyť je přece psáno, že Bůh přikáže svým andělům, aby tě ochránili, ");
INSERT INTO ceslb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","a že tě ponesou na rukou, aby ses nezranil.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ježíš na to odpověděl: „Ale je také psáno, že nemáme Boží sliby zneužívat, ani Boha pokoušet.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Po těchto slovech ho ďábel opustil a čekal na svou další příležitost. ");
INSERT INTO ceslb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Vyzbrojen mocí Ducha, vrátil se Ježíš do Galileje. Pověst o něm se brzy rozšířila po celém okolí. ");
INSERT INTO ceslb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Učil v synagogách, lidé se mu obdivovali a pozorně mu naslouchali. ");
INSERT INTO ceslb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Přišel i do Nazaretu, kde vyrůstal. I tam šel podle svého zvyku v sobotu do synagogy. Povstal, aby dal najevo, že chce číst z Písma. ");
INSERT INTO ceslb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Podali mu svitek z knihy proroka Izajáše. Rozvinul ho a nalezl místo, kde je psáno: ");
INSERT INTO ceslb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","„Duch Boží mě vede, protože mne Bůh určil, abych chudým přinesl radostnou zprávu, uzdravil ty, kteří jsou v srdci zraněni, sňal lidem pouta, kterými jsou svázáni, slepým abych vrátil zrak, utlačené osvobodil a ohlásil, ");
INSERT INTO ceslb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","že teď přichází čas, kdy se Bůh chce nad každým slitovat a zachránit ho.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pak Ježíš stočil svitek, podal ho sluhovi a posadil se. Lidé napjatě čekali na výklad přečteného oddílu. ");
INSERT INTO ceslb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Obsahem Ježíšova kázání bylo: „Dnes se uskutečňuje to, co jsem právě četl.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Všichni souhlasně přikyvovali a divili se, jak pěkně Ježíš hovořil. Říkali: „A to je syn tesaře Josefa!“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ježíš ale pokračoval: „Asi byste mi rádi připomněli přísloví: Lékaři, uzdrav se sám! Proč neuděláš doma stejné zázraky, o jakých slyšíme třeba z Kafarnaum? – ");
INSERT INTO ceslb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Víte proč? Protože jako každý prorok nacházím nejméně víry u vás doma. ");
INSERT INTO ceslb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jen si vzpomeňte, jak to bylo v době proroka Elijáše, kdy tři a půl roku nepršelo. ");
INSERT INTO ceslb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","V Izraeli bylo mnoho vdov, ale Elijáš byl poslán jen k jediné, a to ještě pohanské vdově ze Sarepty v Sidónsku. ");
INSERT INTO ceslb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Anebo v době proroka Elíši bylo v Izraeli mnoho malomocných, a nakonec byl uzdraven jen Naamán, pohan ze Sýrie.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Po těchto slovech se lidé v synagoze rozzuřili, ");
INSERT INTO ceslb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","popadli Ježíše a vlekli ho za město na sráz hory, odkud ho chtěli svrhnout dolů. ");
INSERT INTO ceslb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","On se jim však ztratil v davu a odešel odtud. ");
INSERT INTO ceslb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Odešel do Kafarnaum v Galileji a kázal tam v sobotu k lidem. ");
INSERT INTO ceslb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na posluchače udělal hluboký dojem, protože z jeho slov vyzařovala zvláštní moc. ");
INSERT INTO ceslb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","V synagoze byl také muž posedlý démonem a ten vykřikoval: ");
INSERT INTO ceslb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","„Co je ti do nás, Ježíši z Nazaretu? Přišel jsi nás zničit? Znám tě, tebe posílá Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ježíš démona okřikl: „Buď zticha a ven z něho!“ Zlý duch s tím mužem ještě zalomcoval, ale už mu neublížil. Od té chvíle měl ten muž pokoj. ");
INSERT INTO ceslb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lidé se polekali a dohadovali se mezi sebou: „Co je to v jeho slovech? S jakou autoritou poroučí démonům, že ho na slovo poslouchají?“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A tak se o Ježíši brzy mluvilo po celém okolí. ");
INSERT INTO ceslb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ze synagogy odešel Ježíš do domu rybáře Šimona. Tam ho prosili, aby pomohl Šimonově tchyni, která ležela na lůžku s vysokou horečkou. ");
INSERT INTO ceslb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ježíš se nad nemocnou sklonil a slovem ji uzdravil. Horečka okamžitě klesla, žena vstala a dokonce byla schopna je pohostit. ");
INSERT INTO ceslb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Večer přicházeli mnozí k Ježíšovi a přiváděli s sebou svoje blízké postižené nejrůznějšími nemocemi. Kladl na ně ruce a uzdravoval je. ");
INSERT INTO ceslb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Osvobodil také mnoho lidí od démonů, kteří hrůzou křičeli: „Ty jsi Boží Syn.“ Ježíš je umlčoval, protože nestál o to, aby právě oni zveřejňovali, že je Mesiáš. ");
INSERT INTO ceslb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Časně ráno opustil Ježíš dům a vyhledal si osamělé místo. Lidé ho všude hledali. Chtěli ho zadržet a zabránit mu, aby od nich odešel. ");
INSERT INTO ceslb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","On jim však řekl: „Musím i v jiných městech hlásat radostnou zprávu o přicházejícím Božím království, vždyť k tomu mne Bůh poslal.“ ");
INSERT INTO ceslb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A tak kázal v různých synagogách i v Judsku. ");
INSERT INTO ceslb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jednoho dne stál Ježíš u Genezaretského jezera. Lidé se kolem něho tlačili a chtěli slyšet jeho kázání. ");
INSERT INTO ceslb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Všiml si, že u břehu jsou dvě lodi. Opodál prali rybáři svoje sítě. ");
INSERT INTO ceslb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Posadil se do jedné lodi, která patřila Šimonovi, a požádal ho, aby ho zavezl kousek od břehu. Odtud pak kázal zástupům. ");
INSERT INTO ceslb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Když skončil, navrhl Šimonovi: „Zajeď s lodí na hloubku a roztáhněte sítě k lovu.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Šimon namítal: „Pane, celou noc jsme se namáhali, ale marně. Když to však říkáš ty, zkusím to ještě jednou.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Vypluli a zatáhli takové množství ryb, že se i sítě trhaly. ");
INSERT INTO ceslb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Museli si zavolat na pomoc své přátele z druhé lodi. Obě lodi byly nakonec rybami tak naplněny, že se div nepotopily. ");
INSERT INTO ceslb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Když to viděl Šimon, padl před Ježíšem na kolena a prosil: „Odejdi Pane, neobstojím v tvé blízkosti, jsem hříšný člověk.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Všichni rybáři, kteří u toho byli – mezi nimi také Šimonovi přátelé, Jakub a Jan, synové Zebedeovi, žasli nad tím neobvyklým úlovkem. Ježíš řekl Šimonovi: „Neboj se! Učiním tě rybářem lidí. Budeš je získávat pro mne.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Přirazili s loděmi ke břehu, všechno tam nechali a šli s Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","V jednom městečku potkal Ježíš člověka s pokročilým malomocenstvím. Ubožák před ním poklekl a prosil: „Pane, kdybys chtěl, mohl bys mne uzdravit.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ježíš se ho dotkl a řekl: „Ano, chci, buď zdráv!“ V tom okamžiku malomocenství zmizelo. ");
INSERT INTO ceslb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ježíš mu poručil: „Nikomu o tom nevyprávěj, jdi, ukaž se knězi, ať tě prohlásí za zdravého, a pak obětuj předepsanou oběť vděčnosti.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Zpráva o Ježíšovi se rychle šířila. Lidé za ním přicházeli v houfech, aby ho slyšeli a aby uzdravoval jejich nemoci. ");
INSERT INTO ceslb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","On si však vždycky našel čas, aby se v ústraní modlil. ");
INSERT INTO ceslb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jednoho dne se kolem Ježíše shromáždili farizejové a učitelé zákona z různých měst Galileje a Judska a dokonce i z Jeruzaléma. Posadili se kolem něho a naslouchali mu. I zde mu dal Bůh moc k uzdravování. ");
INSERT INTO ceslb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Nějací lidé přinesli na nosítkách ochrnutého muže. Chtěli ho vnést dveřmi a položit před Ježíše, ale bylo tam tolik lidí, že nemohli projít. Vystoupili tedy na střechu a otvorem spustili nemocného i s lehátkem přímo před něho. Když ");
INSERT INTO ceslb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ježíš viděl, kolik důvěry v něho mají, řekl: „Příteli, tvoje hříchy jsou ti odpuštěny.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Učitelé zákona a farizejové uvažovali: „Jak se může opovážit něco takového říci? To je přece rouhání. Nikdo jiný než Bůh nemůže odpouštět hříchy!“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ježíš dobře věděl, co si myslí, a proto řekl: „To vám vadí? ");
INSERT INTO ceslb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Co je snazší? Zvěstovat člověku odpuštění jeho hříchů, anebo ho uzdravit? ");
INSERT INTO ceslb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Přesvědčím vás, že Syn člověka má na zemi právo odpouštět hříchy.“ Obrátil se k ochrnutému se slovy: „Vstaň, vezmi si svoje lehátko a jdi domů!“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A tak se stalo: před očima všech muž vstal, sbalil svou rohož, šel domů a cestou hlasitě děkoval Bohu. ");
INSERT INTO ceslb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Celé shromáždění bylo vzrušeno a lidé, plni svaté bázně, chválili Boha a říkali: „Dnes jsme viděli neuvěřitelné věci.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ježíš šel dál. Cestou uviděl v celnici výběrčího daní jménem Levi a řekl mu: „Pojď, staň se mým následovníkem!“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi nechal všeho, vstal a šel za Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Doma pak vystrojil pro Ježíše a jeho žáky hostinu. Na ni pozval i mnoho svých dřívějších kolegů. ");
INSERT INTO ceslb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","To pohoršilo farizeje a učitele zákona, takže vytýkali učedníkům: „Proč jíte a pijete s lidmi, kterými každý slušný člověk pohrdá?“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ježíš na to odpověděl: „Lékaře nepotřebují zdraví, ale nemocní. ");
INSERT INTO ceslb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nepřišel jsem volat k pokání ty, kteří mají o sobě dobré mínění, ale hříšníky.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Někteří farizejové Ježíšovi předhazovali: „Janovi učedníci se často s postem modlí a právě tak i naši žáci. Jak to tedy, že tvoji hodují?“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ježíš odpověděl: „Je přirozené, aby se svatebčané postili, když je ženich s nimi? ");
INSERT INTO ceslb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Však přijde chvíle, kdy ženicha odvedou, a pak bude vhodný čas k půstu.“ ");
INSERT INTO ceslb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ještě přidal další přirovnání: „Nikdo si přece nevystřihne kus látky z nových šatů, aby si jím vyspravil starý oděv. Zničil by si tak šaty nové a na starých šatech by se záplata srazila a díra by byla ještě větší. ");
INSERT INTO ceslb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nikdo také nebude nalévat víno do starých kožených měchů, protože kvasící víno by staré měchy roztrhalo, a tak by obojí přišlo nazmar. ");
INSERT INTO ceslb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Proto mladé víno patří do nových měchů. ");
INSERT INTO ceslb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Vás ovšem znepokojuje moje poselství. Jako mladé víno nesnesou staré měchy, ani ono se nevtěsná do vašich starých tradic a zvyklostí. Jste jako pijáci, kteří si libují ve starém uleželém vínu.“ ");
INSERT INTO ceslb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jedné soboty procházel Ježíš a jeho učedníci obilným polem. Učedníci ulamovali klasy, vymílali je a zrní jedli. ");
INSERT INTO ceslb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Viděli to farizejové a pohoršovali se: „Co to děláte? Vždyť přece Boží zákon zakazuje v sobotu i takovou práci!“ ");
INSERT INTO ceslb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ježíš odpověděl: „Nikdy jste nečetli o tom, co udělal král David se svou družinou, když měli hlad? ");
INSERT INTO ceslb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jak vešel do svatyně, vzal tam posvátné chleby, jedl je a podělil jimi i své druhy? Posvátné chleby přece smějí jíst jen kněží. ");
INSERT INTO ceslb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A pak, Syn člověka je i pánem soboty.“ ");
INSERT INTO ceslb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jinou sobotu šel Ježíš kázat do synagogy. Byl tam člověk, který měl pravou ruku ochrnutou. ");
INSERT INTO ceslb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farizejové a učitelé zákona čekali, zdali se Ježíš odváží v sobotu toho muže uzdravit. Chtěli mít totiž záminku, aby Ježíše mohli obžalovat. ");
INSERT INTO ceslb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","On však dobře znal jejich záměry, a přesto toho člověka s ochrnutou rukou vyzval, aby přišel k němu. Muž poslechl. ");
INSERT INTO ceslb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ježíš pak oslovil všechny přítomné: „Ptám se vás, má se podle zákona konat v sobotu dobro, nebo zlo? Má se člověk zachránit, nebo nechat hynout?“ ");
INSERT INTO ceslb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Když nikdo neodpovídal, řekl nemocnému: „Natáhni tu ruku!“ Muž poslechl a jeho pravice byla zdravá. ");
INSERT INTO ceslb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ježíšovi protivníci, na nejvyšší míru podráždění, se domlouvali, co by se dalo proti Ježíšovi podniknout. ");
INSERT INTO ceslb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","V těch dnech vystoupil Ježíš na horu, aby se modlil. Celou noc hovořil s Bohem. ");
INSERT INTO ceslb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Když se rozednilo, svolal všechny svoje učedníky, které pak nazval apoštoly. ");
INSERT INTO ceslb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Byli to: Šimon, kterému dal nové jméno Petr, jeho bratr Ondřej, Jakub, Jan, Filip, Bartoloměj, ");
INSERT INTO ceslb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matouš – původně výběrčí Levi, Tomáš, Jakub – syn Alfeův, Šimon – bývalý příslušník tajné organizace radikálů, ");
INSERT INTO ceslb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda – syn Jakubův a Jidáš Iškariotský, který později Ježíše zradil. ");
INSERT INTO ceslb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Když pak sestoupili na rovné prostranství, očekával je už veliký dav Ježíšových stoupenců i mnoho lidí z Jeruzaléma, z celého Judska i z pobřežních měst Týru a Sidónu. ");
INSERT INTO ceslb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Přišli, aby si poslechli jeho kázání a dali se uzdravit. Vyléčil tam celou řadu duševně chorých. ");
INSERT INTO ceslb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lidé se ho chtěli alespoň dotknout, protože z něho vycházela uzdravující moc. ");
INSERT INTO ceslb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ježíš se obrátil na své učedníky a řekl: „Radujte se, vy chudí, protože vám bude patřit Boží království. ");
INSERT INTO ceslb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Radujte se, kdo teď hladovíte, protože Bůh vás nasytí. Radujte se i vy, kdo teď pláčete, protože jednou se budete smát. ");
INSERT INTO ceslb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Radujte se, když vás budou nenávidět, vyženou jako prašivé a pošpiní vaše jména, protože se hlásíte k Synu člověka. ");
INSERT INTO ceslb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Radujte se a prozpěvujte si, protože vás v nebi čeká velká odměna. Stejným způsobem zacházeli jejich předkové s Božími proroky. ");
INSERT INTO ceslb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ale běda vám, bohatí, protože vy už máte svoje potěšení. ");
INSERT INTO ceslb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Běda vám, sytí, však budete jednou hladovět. Běda vám, kteří se lehkomyslně smějete, protože jednou budete hořce plakat a naříkat. ");
INSERT INTO ceslb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Běda vám, jestliže vás všichni chválí, vždyť tak se za starodávna chovali k falešným prorokům. ");
INSERT INTO ceslb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Vám pak, moji posluchači, radím: Milujte své nepřátele, prokazujte dobro těm, kteří vás nenávidí. ");
INSERT INTO ceslb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Přejte dobré věci těm, kteří vás proklínají, a modlete se za ty, kteří vám činí bezpráví. ");
INSERT INTO ceslb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tomu, kdo tě uhodí do tváře, nastav i druhou. Tomu, kdo ti bere kabát, přidej i košili. ");
INSERT INTO ceslb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Každému, kdo tě o něco prosí, dej, a jestliže tě někdo okradl, nevymáhej to zpátky. ");
INSERT INTO ceslb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jak chcete, aby s vámi lidé jednali, tak s nimi jednejte vy. ");
INSERT INTO ceslb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Jakou čekáte od Boha pochvalu, když milujete jen ty, kteří milují vás? To umějí lidé, kteří se na Boha neptají. ");
INSERT INTO ceslb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jestliže jednáte dobře jen s těmi, kteří se k vám chovají slušně, jaké uznání od Boha čekáte? ");
INSERT INTO ceslb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A myslíte, že Bůh ocení, když půjčujete jenom těm, kteří vám to vždycky vrátí? Tak to přece na světě chodí, že si lidé půjčují, jenom když mají jistotu, že o nic nepřijdou. Ale vy jednejte jinak. ");
INSERT INTO ceslb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Milujte své nepřátele, konejte dobro, půjčujte a nevymáhejte zpět. Vždyť vás čeká bohatá odměna. Budete jednat jako Boží děti. ");
INSERT INTO ceslb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vždyť Bůh je dobrý i k lidem nevděčným a zlým. Buďte tedy velkorysí jako váš Otec. ");
INSERT INTO ceslb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nesuďte nikoho, a Bůh vás také nebude soudit. Nezavrhujte nikoho, a ani Bůh vás nezavrhne, odpouštějte, a Bůh vám také odpustí. ");
INSERT INTO ceslb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dávejte ochotně, a Bůh vás zahrne svými dary. Bůh neskrblí, ale dává vrchovatou míru. Jak tedy odměříte lidem, tak bude odměřeno i vám.“ ");
INSERT INTO ceslb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ježíš použil také několika přirovnání: „Slepec přece nepovede slepého, vždyť by oba spadli do jámy. ");
INSERT INTO ceslb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Učedník nezná tolik jako mistr; teprve když se vyučí, může se mu podobat. ");
INSERT INTO ceslb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Proč se staráš o pilinu v oku svého bližního a polena ve svém oku si nevšímáš? ");
INSERT INTO ceslb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jak můžeš říkat svému bratrovi: ‚Dovol, odstraním ti pilinu z oka,‘ a přehlížet poleno ve svém vlastním oku? Pokrytče, nejprve si vyčisti své vlastní oko, a teprve potom jasně uvidíš, co potřebuje tvůj bratr. ");
INSERT INTO ceslb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Štěpovaný strom nerodí plané ovoce a žádný planý strom nenese ušlechtilé ovoce. ");
INSERT INTO ceslb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jakost stromu se pozná podle ovoce, které dává. Z trní se nesklízejí fíky ani z bodláků hrozny. ");
INSERT INTO ceslb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Člověk je schopen konat skutečné dobro jen tehdy, je-li jeho srdce plné dobra. Když je však jeho srdce naplněno zlem, šíří jenom zlo. Čím srdce naplněno, tím ústa přetékají. ");
INSERT INTO ceslb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Proč mi stále říkáte: Pane, Pane, a neděláte, co vám říkám? ");
INSERT INTO ceslb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Každý, kdo ke mně přichází a naslouchá tomu, co říkám, a řídí se podle toho, podobá se člověku, který začal stavět dům a vykopal základy hluboko ve skále. Když se přihnala povodeň, dům se ani nepohnul, protože měl dobré základy. ");
INSERT INTO ceslb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Každý, kdo mě slyší, ale neřídí se podle toho, podobá se člověku, který si vystavěl dům bez základů: dům smetla povodeň.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Když Ježíš skončil kázání k lidem, šel do Kafarnaum. ");
INSERT INTO ceslb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tam žil jeden římský důstojník, který vlastnil otroka. Velice si ho cenil, a proto těžce nesl, když otrok smrtelně onemocněl. ");
INSERT INTO ceslb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Důstojník se doslechl o Ježíšovi a poslal k němu židovské starší s prosbou, aby přišel a otroka zachránil. ");
INSERT INTO ceslb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ti se vydali za Ježíšem a naléhali: „Ten muž si zaslouží tvou pomoc. ");
INSERT INTO ceslb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Má rád náš národ a dokonce nám dal postavit synagogu.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ježíš s nimi šel. Když už byli nedaleko jeho domu, poslal k němu důstojník své přátele se vzkazem: „Pane, neobtěžuj se tolik, nezasloužím si, abys mne poctil svou návštěvou. ");
INSERT INTO ceslb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jako pohan jsem se ani neodvážil jít za tebou osobně. Stačí, když řekneš slovo, a můj otrok se určitě uzdraví. ");
INSERT INTO ceslb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Vždyť i já musím splnit rozkaz svých nadřízených a moji podřízení se musí zase podrobit mým povelům. Řeknu-li vojákovi: ‚Jdi!‘ tak jde, a řeknu-li druhému: ‚Přijď!‘ tak přijde. Poručím-li svému otrokovi: ‚Udělej toto!‘ tedy to udělá.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ježíš byl těmi slovy velmi udiven a řekl svým průvodcům: „S tak velkou vírou jsem se nesetkal u žádného Žida.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Když se poslové vrátili do domu římského důstojníka, byl již otrok zdráv. ");
INSERT INTO ceslb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Brzy nato se Ježíš odebral do města Naim. Jeho žáci a mnozí další lidé ho doprovázeli. ");
INSERT INTO ceslb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","V blízkosti městské brány potkali pohřební průvod. Jedna vdova pochovávala svého jediného syna. K pohřbu se sešlo hodně lidí. ");
INSERT INTO ceslb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Když Ježíš spatřil tu vdovu, bylo mu jí velice líto a řekl: „Neplač!“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pak přistoupil blíže, dotkl se már a zastavil průvod. „Mládenče, vstaň!“ zvolal. ");
INSERT INTO ceslb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tu se mrtvý posadil a promluvil. Tak Ježíš vrátil matce syna. ");
INSERT INTO ceslb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Počáteční zděšení okolostojících vystřídala radost a začali chválit Boha: „Velký prorok přišel mezi nás! Bůh navštívil svůj lid.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Zpráva o této události se rozšířila po celém Judsku a okolí. ");
INSERT INTO ceslb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","O tom všem vyprávěli učedníci Jana Křtitele svému učiteli. ");
INSERT INTO ceslb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jan poslal dva z nich za Ježíšem, aby se zeptali: „Jsi Mesiáš, anebo máme čekat ještě někoho jiného!“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Když přišli s tou otázkou, Ježíš právě uzdravoval nemocné, všelijak postižené, osvobozoval spoutané duševními nemocemi, mnohým slepým vracel zrak. ");
INSERT INTO ceslb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Poslům odpověděl: „Jděte zpět k Janovi a řekněte mu, co jste viděli a slyšeli: slepí vidí, chromí chodí, hluší slyší, mrtví ožívají a těm, kteří nic nemají, nabízí Bůh podíl ve svém království. ");
INSERT INTO ceslb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Šťasten je každý, kdo mne neodmítne.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Když poslové odešli, začal Ježíš mluvit ke shromážděným lidem o Janu Křtiteli: „Když jste chodili za mužem, který strávil život v pustinách, koho jste očekávali? Rákos, který se otočí podle větru? ");
INSERT INTO ceslb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nebo jste chtěli vidět člověka v přepychových šatech? Takoví jsou jen v palácích. ");
INSERT INTO ceslb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chtěli jste slyšet proroka? Ano, poznali jste někoho ještě většího než proroka. ");
INSERT INTO ceslb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jan je ten, o němž je napsáno: ‚Posílám svého posla před tebou, aby ti připravil cestu.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jan dostal nejvyšší úkol ze všech lidí: oznámit, že Kristus přichází! A přece i ten nejnepatrnější, kdo se dočkal a uvěřil, byl poctěn více než Jan. ");
INSERT INTO ceslb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Víte, že Janovi posluchači – a byli mezi nimi i lidé s všelijakou pověstí – přijali Jana jako Božího posla a dali se proto od něho pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farizejové a znalci zákona však Janův křest odmítli, protože nepochopili, že i oni potřebují Boží odpuštění.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ježíš pokračoval: „Komu se tak podobají? ");
INSERT INTO ceslb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jsou nespokojení a náladoví jako děti, které si hrají na návsi chvíli na svatbu, chvíli na pohřeb a vzájemně si vyčítají: ‚Pískali jsme vám, a vy jste netancovali. A pak jsme vám zase smutně zpívali, a vy jste neplakali.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Když se Jan Křtitel postil a nepil víno, říkali jste, že je fanatik, ");
INSERT INTO ceslb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","a když Syn člověka jí a pije, říkáte pohrdlivě: ‚Podívejte se na toho žrouta a pijana, který se přátelí i se zrádci národa a s kdejakou sebrankou.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ale kdo přijme Boží moudrost, ten tomu porozumí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jeden farizej pozval Ježíše na oběd. Ten přišel a stoloval s ním. ");
INSERT INTO ceslb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","V tom městě žila také žena, která měla špatnou pověst. Když slyšela, že Ježíš je na návštěvě u farizeje Šimona, vzala alabastrovou nádobku s drahocenným vonným olejem a šla tam. ");
INSERT INTO ceslb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Poklekla k Ježíšovým nohám, smáčela mu je slzami, utírala svými vlasy, líbala je a potírala vonným olejem. ");
INSERT INTO ceslb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Když to viděl farizej, který Ježíše pozval, myslel si: „Kdyby to byl prorok, věděl by, co je to za ženu, a nedovolil by, aby se ho taková hříšnice vůbec dotkla.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tu ho Ježíš oslovil: „Rád bych se tě, Šimone, na něco zeptal.“ „Prosím, jen mluv,“ řekl Šimon. ");
INSERT INTO ceslb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","„Jeden věřitel měl dva dlužníky. První mu byl dlužen pět set stříbrných, druhý padesát. ");
INSERT INTO ceslb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Když však ani jeden z nich nemohl zaplatit, věřitel odpustil dluh oběma. Co myslíš, který z nich ho bude mít víc rád?“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Šimon odpověděl: „Mám za to, že ten, kterému více prominul.“ „Správně,“ řekl Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pak ukázal na ženu u svých nohou a pověděl Šimonovi: „Podívej se na tu ženu. Přišel jsem do tvého domu a ty jsi mi nedal umýt nohy, jak je zvykem; tato žena mi je umyla svými slzami a vytřela svými vlasy. ");
INSERT INTO ceslb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na uvítanou jsi mne jako hostitel nepolíbil, ale tato žena mi nepřestává líbat nohy. ");
INSERT INTO ceslb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nepotřel jsi mi hlavu olejem, ale tato žena nelitovala drahocenného oleje na mé nohy. ");
INSERT INTO ceslb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Je to jako s těmi dlužníky: velký hřích je jí odpuštěn a to se projevuje na lásce, kterou mi prokazuje. Kdo si myslí, že odpuštění nepotřebuje, pak málo miluje.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Potom se obrátil k ženě: „Tvoje hříchy jsou ti odpuštěny.“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Když si ostatní hosté říkali mezi sebou: „Co je to za člověka, že si troufá odpouštět hříchy?“ ");
INSERT INTO ceslb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","uklidnil ji: „Tvoje víra tě zachránila, jdi pokojně domů.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Potom Ježíš chodil od města k městu, od vesnice k vesnici a všude kázal radostnou zvěst, že Boží království přichází. Doprovázelo ho jeho dvanáct učedníků ");
INSERT INTO ceslb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","a některé ženy, které zbavil démonů a uzdravil z různých nemocí. Byly to: Marie Magdaléna, kterou osvobodil od naprosté posedlosti, ");
INSERT INTO ceslb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jana – žena Herodova správce Chuzy, Zuzana a mnohé jiné, které je ze svých prostředků podporovaly. ");
INSERT INTO ceslb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jednou se okolo Ježíše shromáždilo mnoho lidí ze všech koutů. Vyprávěl jim toto podobenství: ");
INSERT INTO ceslb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","„Vyšel rolník na pole, aby rozséval. Jak rozséval, padlo některé zrno na cestu, kde je buď zašlapali lidé, nebo sezobali ptáci. ");
INSERT INTO ceslb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jiné padlo na skalnatou půdu. Vyklíčilo sice, ale pro nedostatek vláhy uschlo. ");
INSERT INTO ceslb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","I do trní některé zapadlo, trní je však přerostlo a udusilo. ");
INSERT INTO ceslb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pouze v připravené půdě se zrno trvale uchytilo a vyhnalo do plných klasů, v jakých bývá i na sto zrnek.“ Když dovyprávěl, řekl: „Slyšeli jste – přemýšlejte!“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Později se ho učedníci ptali, co to podobenství znamená. ");
INSERT INTO ceslb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ježíš odpověděl: „Bůh vám dopřává, abyste porozuměli jeho záměrům se světem. Ostatním jsou dána podobenství: vidí, a přece mnozí nic nepoznají, slyší, a nakonec většinou nepochopí nic. ");
INSERT INTO ceslb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tomu podobenství je třeba rozumět takto: Zrno je Boží řeč k lidem. ");
INSERT INTO ceslb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","U mnohých se mu daří tak jako zrnu, které padlo na cestu. Ti Boží slovo vyslechnou, a pak přichází ďábel a to, co slyšeli, jim ze srdce sebere, jen aby neuvěřili a nebyli zachráněni. ");
INSERT INTO ceslb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","U těch druhých se daří slovu jako zrnu, které padlo na skalnatou půdu. Ti Boží slovo vyslechnou, radostně je přijmou, ale nedovolí, aby v jejich životě zapustilo kořeny. Nějakou dobu vydrží věřit, ale když přijdou zkoušky, odpadnou. ");
INSERT INTO ceslb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","U jiných je to jako se zrnem, které padlo do trní. Ti rozumějí Božímu slovu, ale nedozraje v nich a nepřinese užitek; každodenní starosti, snaha něco vlastnit a honba za požitky je udusí. ");
INSERT INTO ceslb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A konečně u některých je to jako se zrnem, které padlo do úrodné půdy. Ti slyší rádi Boží slovo, opatrují je v připraveném srdci a upřímně mu věří. Ti pak přinášejí trvalý užitek. ");
INSERT INTO ceslb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nikdo nerozsvěcuje svíci proto, aby ji přikryl nádobou nebo strčil pod postel, ale proto, aby ji postavil na svícen. Jenom tak posvítí na cestu těm, kdo vcházejí. ");
INSERT INTO ceslb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Všechno, co je skryté, bude jednou vyneseno na světlo a vše, co se úzkostlivě tají, vyjde najevo. ");
INSERT INTO ceslb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Zamyslete se nad tím, jak nasloucháte Božímu slovu! Kdo je bere vážně, porozumí víc a víc, ale kdo je bere na lehkou váhu, přijde nakonec i o to, co si myslí, že má!“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ježíšova matka a jeho bratři pro něj přišli, ale nemohli se k němu dostat pro nával lidí. ");
INSERT INTO ceslb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lidé mu oznámili: „Tvoje matka a tvoji bratři stojí venku a chtějí ti něco říci.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ježíš jim odpověděl: „Moje matka a moji bratři jsou ti, kteří slyší Boží slovo a řídí se podle něho.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jednoho dne nastoupil Ježíš se svými učedníky na loď a řekl jim: „Přeplavíme se na druhý břeh jezera.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cestou usnul. Vtom se na jezero přihnala větrná bouře. Vlny se vysoko zvedaly, loď se plnila vodou a hrozilo, že se potopí. ");
INSERT INTO ceslb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Učedníci Ježíše vzbudili a volali: „Pane, Pane, utopíme se!“ Ježíš vstal, poručil větru a utišil vlny. ");
INSERT INTO ceslb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","V nastalém tichu se zeptal učedníků: „Kde zůstala vaše víra?“ Byli celí vyděšení a udivení a říkali si mezi sebou: „Kdo to jen může být, že ho i vítr a vlny poslouchají?“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Plavili se dále do gerasenského kraje, který leží na protějším břehu než Galilea. ");
INSERT INTO ceslb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sotva Ježíš vystoupil na břeh, přiběhl k němu muž z Gerasy, posedlý démony. Již delší dobu pobíhal nahý, potloukal se bez domova a přespával v prázdných skalních hrobech. ");
INSERT INTO ceslb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Když uviděl Ježíše, zaječel, vrhl se před ním na zem a křičel: „Co ode mne chceš, Ježíši, synu Nejvyššího Boha? Nech mne na pokoji!“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ježíš přikázal démonu, aby toho muže opustil; záchvaty jej totiž týraly už dlouhou dobu. Lidé ho svazovali na rukou řetězy, na nohy mu nasazovali okovy, ale on měl takovou sílu, že všechno zpřetrhal. Pak se skrýval v pustinách. ");
INSERT INTO ceslb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ježíš se ho zeptal: „Kdo vlastně jsi?“ On odpověděl: „Nás je spousta.“ Byl totiž posedlý mnoha démony. ");
INSERT INTO ceslb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nešťastník teď za ně prosil Ježíše, aby je úplně nezničil. ");
INSERT INTO ceslb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Vybrali si stádo vepřů, které se páslo nedaleko na stráni. Když Ježíš dovolil, ");
INSERT INTO ceslb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","démoni opustili muže a zmocnili se vepřů. Stádo se splašilo a hnalo se po srázu rovnou do jezera, kde utonulo. ");
INSERT INTO ceslb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Když to viděli pasáci vepřů, utekli a ve městě i na vesnicích vyprávěli, co se stalo. ");
INSERT INTO ceslb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","36","Lidé se chtěli na vlastní oči přesvědčit a přišli k Ježíši. U jeho nohou seděl onen muž uzdravený a oblečený, Bylo na něm jasně znát, že má zdravý rozum. Nejvíce lidmi otřáslo vyprávění očitých svědků, jakým způsobem byl ten člověk uzdraven. ");
INSERT INTO ceslb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Zmocnil se jich takový strach, že prosili Ježíše, aby jejich krajinu opustil. A tak vstoupil na loď a plavil se zpět. ");
INSERT INTO ceslb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Muž, kterého Ježíš uzdravil, prosil, aby ho vzal s sebou. Ježíš odmítl a rozloučil se s ním se slovy: ");
INSERT INTO ceslb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","„Jdi domů a vypravuj, jak veliké věci s tebou Bůh učinil.“ Muž poslechl, odešel a všude vyprávěl, jaké dobrodiní mu Ježíš prokázal. ");
INSERT INTO ceslb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na druhém břehu zatím čekal na Ježíšův návrat zástup lidí. ");
INSERT INTO ceslb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Byl mezi nimi také představený synagogy Jairus. Padl Ježíšovi k nohám a prosil, aby šel k němu, ");
INSERT INTO ceslb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","že jeho jediná, dvanáctiletá dcerka umírá. Cestou se na Ježíše tlačili lidé ze všech stran. ");
INSERT INTO ceslb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Byla tam i jedna žena, která již dvanáct let trpěla krvácením, a ačkoliv nechala u lékařů již celé své jmění, nikomu se nepodařilo ji uzdravit. ");
INSERT INTO ceslb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ta se zezadu dotkla třásní Ježíšova pláště a hned ucítila, že její nemoc přestala. ");
INSERT INTO ceslb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ježíš se zeptal: „Kdo se mne to dotkl?“ Nikdo se nepřiznával a Petr řekl: „Pane, vždyť je kolem tebe tolik lidí a ti se na tebe tlačí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ježíš na tom však trval: „Někdo se mne úmyslně dotkl, pocítil jsem, že ze mne vyšla síla.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Když žena viděla, že se to nedá tajit, přišla celá rozechvělá k Ježíši a padla na kolena. Přede všemi lidmi mu vyprávěla, proč se ho dotkla a že se v tom okamžiku uzdravila. ");
INSERT INTO ceslb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ježíš jí řekl: „Tvoje víra tě uzdravila. Jdi pokojně domů.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zatímco Ježíš mluvil, přišel kdosi k Jairovi a sděloval mu: „Tvoje dcera zemřela, už Ježíše neobtěžuj.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ježíš to slyšel a řekl: „Neboj se, jen věř a tvoje dcerka bude zachráněna.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Když došli k Jairovu domu, vzal s sebou Ježíš dovnitř jen Petra, Jana, Jakuba a rodiče dívenky. ");
INSERT INTO ceslb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tam už nad ní všichni plakali a naříkali. Ježíš řekl: „Neplačte, vždyť neumřela, ale spí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hořce se mu vysmáli, protože věděli, že dívka skutečně zemřela. Ježíš všechny poslal ven, ");
INSERT INTO ceslb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","vzal ji za ruku a zvolal: „Dítě, vstaň!“ ");
INSERT INTO ceslb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A ona hned začala dýchat a vstala. Nařídil, aby jí dali něco k jídlu. ");
INSERT INTO ceslb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Rodičů se zmocnil úžas a radost. Ježíš jim však nařídil, aby nikomu nevyprávěli, co se stalo. ");
INSERT INTO ceslb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ježíš svolal svých dvanáct učedníků a dal jim moc nad všemi démony a nemocemi. ");
INSERT INTO ceslb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Poslal je, aby uzdravovali a oznamovali, že Boží království je zde. ");
INSERT INTO ceslb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Řekl jim: „Nic si s sebou na cestu neberte, ani hůl, ani mošnu, ani chléb, ani peníze, ani náhradní šaty. ");
INSERT INTO ceslb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kde vám poskytnou přístřeší, tam nějakou dobu zůstaňte a odtamtud vycházejte ke svým úkolům. ");
INSERT INTO ceslb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jestliže vás někde nepřijmou, nevnucujte se, odejděte a setřeste před nimi i prach se svých opánků, abyste je tak varovali před Božím hněvem.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Učedníci se vypravili na cestu a chodili od vesnice k vesnici. Všude kázali radostnou zvěst o spáse a uzdravovali. ");
INSERT INTO ceslb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Všechno, co Ježíš kázal a činil, se doneslo až k vladaři Galileje Herodovi. Nevěděl dobře, co si o tom má myslet. Někteří tvrdili, že to Jan Křtitel, kterého dal Herodes popravit, vstal z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jiní se domnívali, že se znovu ukázal prorok Elijáš, další usuzovali, že vstal z mrtvých některý ze starých proroků. ");
INSERT INTO ceslb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes říkal: „Jana Křtitele jsem přece dal popravit, kdo je tedy ten muž, o kterém slyším tak zvláštní věci?“ Proto si velice přál Ježíše poznat. ");
INSERT INTO ceslb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Učedníci se vrátili k Ježíšovi a vypravovali mu o všem, co vykonali. Odebral se s nimi na odlehlé místo v okolí města Betsaidy. ");
INSERT INTO ceslb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jakmile se však lidé dozvěděli, kam šel, vypravili se za ním. Ježíš je neodmítl, ale znovu kázal o Božím království a uzdravoval ty, kteří to potřebovali. ");
INSERT INTO ceslb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Začalo se stmívat. Učedníci za ním přišli a říkali: „Propusť už lidi, ať se mohou rozejít do okolních vesnic a dvorců, aby si sehnali něco k jídlu a mohli tam přenocovat; tady v té pustině nic neseženou.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Ježíš jim řekl: „Tak jim dejte najíst vy.“ Podivili se: „My? Vždyť máme jen pět chlebů a dvě ryby a jen mužů je tu asi pět tisíc. Ledaže bychom my sami šli a něco pro ně nakoupili.“ Ježíš nato řekl svým učedníkům: „Rozsaďte je do skupin asi po padesáti.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tak se stalo. ");
INSERT INTO ceslb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Potom vzal Ježíš těch pět chlebů a ty dvě ryby a poděkoval za ně Bohu. Pak lámal ty pokrmy a podával svým učedníkům, aby je předkládali lidem. ");
INSERT INTO ceslb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Všichni se dosyta najedli. Nakonec učedníci ještě sesbírali dvanáct košů zbytků. ");
INSERT INTO ceslb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jednou se Ježíš odebral se svými učedníky na odlehlé místo k modlitbám. Otázal se jich: „Za koho mě vlastně lidé považují?“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Odpověděli mu: „Někteří za Jana Křtitele, jiní za Elijáše, anebo za některého z dávných proroků, který vstal z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A tu jim Ježíš položil přímou otázku. „A za koho mě máte vy?“ Petr odpověděl: „Ty jsi ten Boží Syn, Mesiáš.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ježíš svým učedníkům kladl na srdce, aby o tom zatím nehovořili. ");
INSERT INTO ceslb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A dodal: „Syn člověka musí ještě mnoho vytrpět. Starší, přední kněží a učitelé zákona ho odsoudí, bude zabit, ale třetí den vstane z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Všem pak řekl: „Kdo chceš jít za mnou, přestaň myslet na sebe, den za dnem nes svůj kříž a následuj mne. ");
INSERT INTO ceslb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kdo chce žít podle sebe, promarní svůj život, ale kdo mi svěří celý svůj život, zachrání ho pro věčnost. ");
INSERT INTO ceslb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Co by z toho člověk měl, kdyby získal třeba celý svět, ale prohrál věčnost? ");
INSERT INTO ceslb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kdo se ke mně nezná a za má slova se stydí, za toho se budu jednou stydět i já, až znovu přijdu v plné slávě Boha Otce a v doprovodu andělů. ");
INSERT INTO ceslb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Můžete se spolehnout, že někteří z vás nezemřou dříve, dokud neuvidí rozmach Božího království na zemi.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Asi za týden po této rozmluvě vystoupil Ježíš s Petrem, Jakubem a Janem na jednu horu, aby se tam modlil. ");
INSERT INTO ceslb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Během modlitby se proměnil výraz Ježíšovy tváře a také jeho šat oslnivě zbělel. ");
INSERT INTO ceslb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Pojednou se tam objevili dva muži nadzemského vzhledu – byl to Mojžíš a Elijáš. Hovořili s Ježíšem o událostech, které ho čekají v Jeruzalémě – o závěru jeho pozemského života a jeho odchodu k Otci. ");
INSERT INTO ceslb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petra a jeho druhy však přemohl spánek. Když procitli, uviděli Ježíše zářícího nebeským jasem a ty dva muže vedle něho. ");
INSERT INTO ceslb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Když se pak proroci chtěli vzdálit, řekl Petr Ježíšovi: „Jak je nám tu dobře, Pane! Co kdybychom tu postavili tři přístřešky: jeden tobě, jeden Mojžíšovi a jeden Elijášovi?“ Nevěděl dobře, co mluví. ");
INSERT INTO ceslb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ještě to ani nedořekl, když je zahalil oblak. To je naplnilo bázní. ");
INSERT INTO ceslb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Z oblaku se ozval hlas: „Toto je můj vyvolený Syn, toho poslouchejte!“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Po tom všem zůstal na hoře Ježíš zase jen se svými učedníky. O tom, co zde učedníci prožili, zatím nikomu nevyprávěli. ");
INSERT INTO ceslb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Když příštího dne sestupovali z hory, vyšel jim naproti velký zástup lidí. ");
INSERT INTO ceslb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Z davu začal na Ježíše volat jeden muž: „Pane, prosím tě, ujmi se mého syna. Mám jen jeho. ");
INSERT INTO ceslb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Zmocňuje se ho démon, můj syn pak křičí, u úst má pěnu a je celý zkroucený. Ten záchvat trvá dlouho a nesnadno ho přechází, strašně ho to týrá. ");
INSERT INTO ceslb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Prosil jsem tvoje učedníky, aby mi syna uzdravili, ale nepodařilo se jim to.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ježíš na to řekl: „Vy ale napínáte moji trpělivost. Jak dlouho vám to bude ještě trvat než uvěříte? Přiveď sem svého syna!“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Než však k němu chlapec došel, padl k zemi v novém záchvatu. Ježíš démona vyhnal, chlapce uzdravil a předal ho otci. ");
INSERT INTO ceslb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Všichni byli tím jasným projevem Boží moci ohromeni. Lidé se ještě obdivovali Ježíšovu skutku, ale on se obrátil na své učedníky: ");
INSERT INTO ceslb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","„Teď mne obdivují, ale uvidíte, co se mnou jednou provedou.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","To ovšem učedníci tenkrát nechápali, ale neodvážili se ho zeptat. ");
INSERT INTO ceslb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jednou se učedníci začali dohadovat, kdo z nich je nejvýznamnější. ");
INSERT INTO ceslb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ježíš to postřehl, postavil před ně dítě a ");
INSERT INTO ceslb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","řekl: „Podle toho, jak se chováte k nejmenším, se dá usoudit, jaký vztah máte ke mně, a tak ukazujete svůj postoj k Bohu, který mne poslal. Ten nejpokornější mezi vámi je v Božích očích největší.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ještě se ozval Jan: „Pane, viděli jsme člověka, který ve tvém jménu vyháněl démony. Snažili jsme se mu v tom zabránit, protože s námi nechodí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ježíš odpověděl: „Jen ho nechte, kdo není proti nám, je s námi.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Přiblížil se čas, kdy měl Ježíš zemřít, a tak nastoupit cestu vzhůru k Bohu. Uvědomil si, že proto musí do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na cestě přes samařské území poslal napřed učedníky, aby vyjednali nocleh v jedné vesnici. ");
INSERT INTO ceslb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tamní obyvatelé však Židy a Jeruzalém nenáviděli a nepřijali tedy Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jakuba a Jana to rozhněvalo a řekli: „Pane, nemáme na ně svolat oheň z nebe, jako to kdysi udělal Elijáš? Ať ta vesnice shoří!“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ježíš to rozhodně odmítl: „Jak vás může něco takového napadnout? Jako byste ani nebyli moji učedníci. ");
INSERT INTO ceslb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Syn člověka přece nepřišel lidské životy mařit, ale zachraňovat.“ Šli tedy do jiné vesnice. ");
INSERT INTO ceslb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cestou mu řekl jeden muž: „Pane, jsem připraven tě kamkoliv následovat.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ježíš ho však upozornil: „Lišky mají své nory, ptáci hnízda, ale já často nevím, kam se večer uložím.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jiného muže vyzval: „Pojď se mnou!“ Ale on váhal a vymlouval se: „Dovol mi nejprve pochovat mého otce.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ježíš řekl: „Poslední službu mrtvým může vykonat kdokoliv, ale ty neotálej a kaž o Božím království, o záchraně člověka pro věčnost.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A ještě jiný řekl Ježíši: „Chci jít s tebou, ale dovol, abych se nejprve doma pořádně rozloučil.“ ");
INSERT INTO ceslb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ježíš mu řekl: „Chce-li oráč vyorat rovnou brázdu, nemůže se ohlížet nazpátek. Kdo není ochoten jít hned, není způsobilý pro Boží království.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ježíš vybral ještě jiných sedmdesát svých následovníků a poslal je ve dvojicích napřed do míst, která chtěl později sám navštívit. ");
INSERT INTO ceslb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Řekl jim: „Úroda je bohatá, ale ženců je málo. Proste Boha, ať pošle dělníky na svoji sklizeň. ");
INSERT INTO ceslb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jděte! Posílám vás jako ovce mezi vlky. ");
INSERT INTO ceslb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Neberte s sebou žádnou peněženku, ani mošnu, ani náhradní obuv. Nemarněte čas zbytečným povídáním. ");
INSERT INTO ceslb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Do kteréhokoliv domu vejdete, pozdravte je přáním pokoje. ");
INSERT INTO ceslb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Přijmou-li vás přátelsky, usídlí se skutečně v tom domě pokoj, který jste jim přáli. Odmítnou-li vás, vám pokoj zůstane, a oni ho budou postrádat. ");
INSERT INTO ceslb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","8","Tam, kde vás přijmou, zůstaňte potřebnou dobu a nerozpakujte se přijmout jejich pohostinnost, protože dělník má právo na svou mzdu. ");
INSERT INTO ceslb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","V tom místě uzdravujte nemocné a hlásejte, že docela nablízku je Boží moc a milosrdenství, že Kristus je zde. ");
INSERT INTO ceslb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tam, kde vás nepřijmou, vyjděte do ulic a řekněte: ");
INSERT INTO ceslb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‚Nechceme od vás nic, i ten váš prach setřásáme ze svých nohou. Vezměte však na vědomí, že i k vám přichází Kristus, a protože ho odmítáte, čeká vás Boží soud. ");
INSERT INTO ceslb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Budete na tom hůř než lidé ze Sodomy, kteří neměli takovou příležitost jako vy.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Pak Ježíš začal hovořit o galilejských městech, kde mu tak mnozí neuvěřili: „Běda ti, Korozaim, běda ti, Betsaido! ");
INSERT INTO ceslb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kdyby se v pohanských městech Týru a Sidónu děly takové zázraky jako u vás, dávno by činili pokání ze všeho zlého, kterého se kdy dopustili. A tak Týru a Sidónu bude v den posledního soudu snesitelněji než vám. ");
INSERT INTO ceslb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Poroste až do nebe tvá pýcha, Kafarnaum? Tvůj pád bude veliký!“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Potom učedníkům ještě dodal: „Kdo vám bude naslouchat, naslouchá mně, kdo vámi pohrdne, pohrdá i mnou. A kdo mne odmítne, odmítne toho, který mne poslal – samého Boha!“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Později se těch sedmdesát učedníků vrátilo s radostnými zprávami: „Pane, dařilo se nám vyhnat i démony, když jsme vyslovili tvé jméno.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ježíš řekl: „Mám před očima satanovu konečnou porážku. ");
INSERT INTO ceslb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Už teď vám dávám moc zašlapávat síly tohoto nepřítele, jako když člověk hubí jedovaté hady a štíry. Nebojte se jich, neuškodí vám. ");
INSERT INTO ceslb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Z toho se však neradujte, že se vám mocnosti zla podrobují, ale radujte se, že vaše jména jsou zapsána v nebi.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Boží Duch naplnil Ježíše v té chvíli velkou radostí, takže se modlil: „Děkuji ti, Otče, Pane nebe i země, že jsi skryl před učenými a rozumáři tyto skutečnosti a odkrýváš je dětsky prostým lidem. Ano, Otče, tak se ti to líbí. ");
INSERT INTO ceslb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Všechno jsi mi svěřil; jen ty víš, kdo jsem já, a já vím, kdo jsi ty. Nikdo není schopen tě pochopit, pokud mu to neobjasním.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pak se obrátil na své učedníky a řekl jim: „Radujte se, že to všechno smíte vidět na vlastní oči. ");
INSERT INTO ceslb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mnozí proroci a králové si přáli vidět a slyšet, co vy teď spoluprožíváte, ale nebylo jim to dáno.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jeden z učitelů zákona chtěl přivést Ježíše do úzkých a zeptal se ho: „Mistře, co mám dělat, abych si zajistil věčný život?“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ježíš mu odpověděl otázkou: „Co o tom říká Mojžíšův zákon? Co tam čteš?“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Muž na to uvedl slova ze zákona: „Miluj Pána Boha z celého srdce, z celé duše, vší silou a celým rozumem a svého bližního miluj tak, jako miluješ sebe.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","„Správně,“ řekl Ježíš, „řiď se podle toho a přijdeš do nebe.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Učitel zákona se však nechtěl tak lehce vzdát, a proto se ještě zeptal. „Ale kdo je můj bližní?“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na to mu Ježíš vyprávěl následující příběh: „Jeden muž se vydal z Jeruzaléma do Jericha. Cestou ho přepadli lupiči, okradli, zbili a polomrtvého nechali ležet. ");
INSERT INTO ceslb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Šel kolem kněz, uviděl zraněného, ale vyhnul se mu. ");
INSERT INTO ceslb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","I jeden chrámový sluha šel okolo, ale ani ten mu neposkytl pomoc. ");
INSERT INTO ceslb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nakonec přišel jeden muž ze Samaří. Když uviděl zraněného, bylo mu ho líto. ");
INSERT INTO ceslb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Zapomněl na starou nenávist mezi Židy a Samařany, ošetřil přepadeného a ovázal mu rány. Pak ho posadil na svého mezka, zavezl do hostince a tam o něho pečoval. ");
INSERT INTO ceslb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Druhého dne dal hostinskému dva stříbrňáky s prosbou: ‚Věnuj mu potřebnou péči, a kdyby tě to stálo víc, než jsem ti dal, vyrovnám se s tebou, až pojedu zpátky.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","„Co myslíš,“ zeptal se Ježíš, „který z těch tří se zachoval k tomu přepadenému jako bližní?“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Učitel zákona odpověděl: „Ten, který mu pomohl.“ Ježíš na to řekl: „Jdi a jednej také tak.“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ježíš s učedníky pokračoval v cestě. V jedné vesnici je do svého domu pozvala žena jménem Marta. ");
INSERT INTO ceslb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Její sestra Marie se posadila a pozorně naslouchala Ježíšovým slovům. ");
INSERT INTO ceslb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta měla zatím plné ruce práce s pohoštěním. Za chvíli přišla k Ježíšovi s výčitkou: „Pane, nevidíš, co mám práce, a že Marie si jen tak sedí? Pošli ji, ať mi pomůže!“ ");
INSERT INTO ceslb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ježíš jí odpověděl: „Milá Marto, ty se moc staráš a příliš se namáháš pro věci, které za to nestojí. ");
INSERT INTO ceslb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Člověk potřebuje jen málo. Doopravdy vlastně jen jedno. Marie to pochopila a to jí nikdo nevezme.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jednou se Ježíš opět modlil o samotě. Když skončil, požádal ho jeden z učedníků: „Pane, nauč nás, jak se máme modlit. Jan Křtitel tomu své učedníky také učil.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ježíš mu vyhověl: „Když se modlíte, říkejte: Náš nebeský Otče, vzdáváme čest tvému svatému jménu. Ujmi se vlády, ať se děje všechno podle tvé vůle jak v nebi, tak i na zemi. ");
INSERT INTO ceslb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dej nám chléb i dnes ");
INSERT INTO ceslb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","a odpusť nám naše provinění, tak jako my odpouštíme těm, kteří nám ubližují. Chraň nás před pokušením a vysvoboď nás z moci zlého. Amen.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dále řekl svým učedníkům: „Představte si, že někdo z vás má přítele a o půlnoci u něj zaklepe se žádostí: ‚Prosím tě, půjč mi tři chleby, ");
INSERT INTO ceslb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","dostal jsem nenadálou návštěvu a nemám jí co podat k jídlu.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Přítel neotevře a nevlídně odpoví: ‚Dej mi pokoj! Nevidíš, že je zamčeno, všichni jsme v posteli a děti spí? Teď ti přece nebudu něco dávat!‘ ");
INSERT INTO ceslb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Napřed odmítá, ale nakonec určitě vyhoví, když se žádající nenechá odradit, ale buší a vytrvale prosí. ");
INSERT INTO ceslb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Podobně je tomu i s modlitbami. Proste vytrvale, a bude vám dáno, hledejte bez přestání, a naleznete, tlucte znovu a znovu, a bude vám otevřeno. ");
INSERT INTO ceslb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Protože, kdo prosí, obdrží; kdo hledá, nalezne; kdo klepe, bude mu otevřeno. ");
INSERT INTO ceslb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Je snad mezi vámi takový otec, který by dal svému synovi kámen, kdyby prosil o chléb, nebo by mu dal hada, kdyby prosil o rybu, ");
INSERT INTO ceslb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","či snad jedovatého štíra místo vajec? ");
INSERT INTO ceslb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Vy, hříšní lidé, nikdy nedáte dětem, co by jim uškodilo. Tím spíše váš nebeský Otec vyslyší vaše vytrvalé modlitby. Usměrní vaše přání a dá to, co vám skutečně prospívá.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jednou Ježíš vysvobodil člověka ze zajetí němoty. Když lidé slyšeli, že němý mluví, divili se. ");
INSERT INTO ceslb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Někteří však říkali: „To máte tak: Zlí duchové ho poslouchají, protože mu kníže démonů propůjčil moc.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jiní ho chtěli vyzkoušet a žádali ho, aby nějak prokázal svoje spojení s Bohem. ");
INSERT INTO ceslb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ježíš však věděl, oč jim jde, a proto řekl: „Stát, v němž zuří občanská válka, je v nebezpečí zániku, a jsou-li v rodině neustálé hádky, nemá daleko k rozpadu. ");
INSERT INTO ceslb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Podle vás tedy bojuje satan sám proti sobě. ");
INSERT INTO ceslb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Říkáte, že vyháním démony mocí satana. Ale co vaši léčitelé? Jakou mocí oni přemáhají nemoci? Na nich si ověřte, jak mne nesmyslně obviňujete. ");
INSERT INTO ceslb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jestliže však skrze mne pracuje Boží ruka, buďte si jisti, že k vám už přišlo Boží království. ");
INSERT INTO ceslb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Střeží-li nějaký statný, dobře ozbrojený muž svůj majetek, nemůže se mu nic stát, ");
INSERT INTO ceslb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ledaže by přišel někdo silnější, odzbrojil ho a majetku se zmocnil. ");
INSERT INTO ceslb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kdo není se mnou, je proti mně. Kdo mi nepomáhá, maří moji práci. ");
INSERT INTO ceslb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Když se člověk rozhodne skončit se špatným životem, opouští ho vlastně duch nečistoty. Ten hledá jiný předmět svého zájmu. Když se mu to nedaří, vrací se k člověku, kterého musel opustit. ");
INSERT INTO ceslb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Vidí-li, že dům – srdce toho člověka – je sice čistý, vyzdobený, ale prázdný, ");
INSERT INTO ceslb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","pozve si sedm jiných společníků, horších než je sám, a usídlí se tam. S takovým člověkem je to pak horší než na začátku.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Když domluvil, jedna žena zvolala: „Šťastná ta žena, která tě porodila a odkojila.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ježíš na to řekl: „Šťastnější jsou ti, kteří slyší Boží slovo a žijí podle něho.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lidé se scházeli u Ježíše a on k nim začal mluvit: „Jak jsou dnešní lidé zaslepení! Domáhají se na Bohu nějakého důkazu, ale nedostanou ho. ");
INSERT INTO ceslb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ninivští neviděli od Jonáše žádné zázraky, ale uvěřili, že jeho ústy mluví Bůh. Tak i já mám být pro vás dostatečným důkazem. ");
INSERT INTO ceslb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Královna ze Sáby neváhala podniknout dalekou cestu, aby poznala Šalomounovu moudrost. A proto ona bude jednou soudit tuto generaci pro lhostejnost, se kterou se staví k moudrosti, jež převyšuje moudrost Šalomounovu. ");
INSERT INTO ceslb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","A tak v den posledního soudu obyvatele Ninive obviní lidi dnešní doby, protože oni tenkrát litovali svých zlých činů, když jim Jonáš kázal, a tady je přece kdosi větší, než byl Jonáš. ");
INSERT INTO ceslb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Žádný nerozsvítí lampu proto, aby ji strčil do kouta anebo pod kbelík, ale postaví ji tak, aby všem, kdo chtějí vejít, svítila. ");
INSERT INTO ceslb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Světlo vstupuje do člověka okem. Je-li oko zdravé a čisté, pronikne světlo do celé bytosti; je-li zalepené špínou, je celý člověk ve tmě. ");
INSERT INTO ceslb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dej tedy pozor, aby to světlo, které jsi už obdržel, nebylo zastíněno. ");
INSERT INTO ceslb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Budeš-li naplněn vnitřním světlem a nebude-li v tobě žádného tmavého koutu, pak celý tvůj život bude svítit, jako bys stál v plné záři lampy.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Když Ježíš domluvil, pozval ho jeden farizej k sobě na oběd. Ježíš přišel a posadil se za stůl. Vynechal obřadné omytí rukou a to nemile překvapilo hostitele. ");
INSERT INTO ceslb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ježíš mu řekl: „Vy, farizejové, omýváte nádobí jen zvenku a vnitřku si nehledíte. A právě tak přes všechno obřadné mytí je vaše nitro plné hrabivosti a špatnosti. ");
INSERT INTO ceslb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Vy zaslepenci! Bohu Stvořiteli patříme se vším, co jsme i co máme. ");
INSERT INTO ceslb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Chudým dejte všechno, co máte v mísách, a pak i na vás bude všechno čisté. ");
INSERT INTO ceslb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Běda vám, farizejové! Pečlivě odvádíte desátý díl ze všeho, i z máty, heřmánku a každého koření, ale nejednáte spravedlivě a podle lásky k Bohu. Je pěkné, že odvádíte desátky, ale to hlavní byste neměli zanedbávat. ");
INSERT INTO ceslb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Běda vám, farizejové! Vyhledáváte čestná místa v synagogách a vyžadujete, aby vás lidé na ulicích uctivě zdravili. ");
INSERT INTO ceslb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Jste jako místo, kde je tajně zakopaná mrtvola. Lidé tam klidně chodí a nevědí, jak nakažlivá hniloba se tam skrývá.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ozval se jeden z učitelů zákona: „Mistře, to, co tu říkáš, uráží i nás.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ježíš odpověděl: „Však ani s vámi zákoníky to není lepší. Nakládáte lidem víc, než mohou unést, ale sami s tím nehnete ani prstem. ");
INSERT INTO ceslb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","49","Běda vám! Stavíte sice pomníky prorokům, které zabili vaši otcové, ale od svých předků se nijak nelišíte. Bůh ve své prozřetelnosti věděl, že budete pronásledovat a zabíjet jeho proroky a posly. ");
INSERT INTO ceslb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Na hlavu této generace padne vina za prolitou krev všech Božích mužů od Ábela až po posledního mučedníka pro Boží věc. Říkám vám, že vaše generace na sebe svolá trest. ");
INSERT INTO ceslb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Běda vám, učitelům zákona! Skryli jste klíč, kterým lze otevřít dveře pravého poznání. Sami jste nevešli a překážíte těm, kdo by vejít chtěli.“ ");
INSERT INTO ceslb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Když domluvil, začali na něj farizejové a učitelé zákona zle dotírat a kladli mu záludné otázky, ");
INSERT INTO ceslb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","aby ho pro nějaký výrok mohli obžalovat. ");
INSERT INTO ceslb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mezitím se shromáždily tisíce lidí. Bylo jich tolik, že se málem ušlapali. Ježíš však nejprve promluvil ke svým učedníkům: „Varujte se pokrytectví farizejů. Je jako kvas, který snadno pronikne těsto. ");
INSERT INTO ceslb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nic se nedá navždy zatajit. ");
INSERT INTO ceslb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Všechno, co jste si řekli za tmy, bude jednou řečeno na denním světle. A co jste si šeptali za zavřenými dveřmi, bude voláno ze střech. ");
INSERT INTO ceslb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jako přátelům vám radím: nebojte se těch, kteří mohou zabít jen tělo, ale víc vám udělat nemohou. ");
INSERT INTO ceslb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jen toho se bojte, kdo má moc ukončit nejen časný život, ale rozhodnout i o vaší věčnosti: Boha mějte v úctě! ");
INSERT INTO ceslb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Jakou cenu má vrabec na vašem trhu? Pár haléřů. Vidíte, a ani na jednoho z nich Bůh nezapomene. Jak by tedy mohl zapomenout na vás? ");
INSERT INTO ceslb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","On ví i to, kolik máte vlasů na hlavě. Proto se nebojte, vás si Bůh váží daleko víc než mnoha vrabců dohromady. ");
INSERT INTO ceslb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Říkám vám, kdo se ke mně hlásí před lidmi, toho jako Syn člověka zastoupím na posledním soudu. ");
INSERT INTO ceslb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kdo mě však před lidmi zapře, k tomu se hlásit nebudu. ");
INSERT INTO ceslb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kdo urazí Syna člověka, tomu může být odpuštěno. Ale kdo uráží Ducha svatého, který působí skrze mne, tomu odpuštěno nebude. ");
INSERT INTO ceslb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Až vás budou vyslýchat před úřady a soudy, nestarejte se, co a jak byste měli mluvit, ");
INSERT INTO ceslb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","protože Duch svatý vám to v té chvíli vnukne.“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jeden ze zástupu ho požádal: „Pane, řekni mému bratrovi, ať se se mnou spravedlivě rozdělí o dědictví.“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ježíš mu odpověděl: „Nejsem tu na to, abych rozsuzoval vaše spory.“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Všem potom řekl: „Varujte se chamtivosti. Vždyť smysl života není v tom, aby člověk hromadil.“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","17","A pověděl jim k tomu příběh: „Když jeden člověk sklidil z polí velkou úrodu, přemýšlel, kam ji uložit. ");
INSERT INTO ceslb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","19","Rozhodl se, že dá zbořit staré stodoly a postaví prostornější, kam si všechno uskladní. Těšil se, že bude mít na léta po starosti a v klidu a pohodě si bude všeho užívat. ");
INSERT INTO ceslb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ale promluvil k němu Bůh: ‚Blázne, dnes v noci zemřeš, a komu připadne, co sis nahromadil?‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ježíš uzavřel: „Tak se stane každému, kdo hromadí majetek a nestará se o to, co má věčnou hodnotu v Božích očích.“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pak ještě řekl svým učedníkům: „Týká se to i Vás: Nedělejte si starosti, co budete jíst, pít a jaké šaty si pořídíte. ");
INSERT INTO ceslb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Život je víc než pokrm a nápoj a tělo je důležitější než šaty. ");
INSERT INTO ceslb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Podívejte se na havrany! Nesejí, nežnou, nemají spíže ani stodoly a Bůh je živí. Pro něho máte větší cenu než ptáci! ");
INSERT INTO ceslb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Kdyby se někdo z vás sebevíc snažil, může povyrůst třeba jen o jediný centimetr? Když ani taková maličkost není ve vaší moci, proč se trápíte starostmi o to ostatní? ");
INSERT INTO ceslb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Podívejte se, jak rostou květiny na louce. Nepředou, netkají, a přece ani Šalomoun v celé své nádheře nebyl tak skvostně oblečen jako kterákoliv z nich. ");
INSERT INTO ceslb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Když tedy Bůh tak pěkně odívá rostlinu, která jeden den kvete a druhý den uvadá, jak by se tím spíše nepostaral o vás, vy malověrní. ");
INSERT INTO ceslb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","A tak se tolik nepachtěte po tom, co byste jedli nebo pili, a netrapte se tím. ");
INSERT INTO ceslb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","To bývá hlavní zájem lidí, kteří Boha neznají. Váš Otec ví, že i ty věci potřebujete. ");
INSERT INTO ceslb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hledejte především Boží království a on vás opatří vším, co k životu potřebujete. ");
INSERT INTO ceslb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nebojte se, ač je vás jen malá hrstka; jste občany Božího království. ");
INSERT INTO ceslb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nelpěte na tom, co máte, ale dávejte to do služby a rozdávejte potřebným. To je to nejlepší, co můžete s pomíjivým majetkem udělat. Promění se v nevyčerpatelný poklad u Boha, kde ho žádný zloděj nemůže ukrást a mol rozežrat. ");
INSERT INTO ceslb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Člověk totiž přilne k tomu, na čem mu opravdu záleží. ");
INSERT INTO ceslb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Buďte připraveni a udržujte své lampy rozsvícené. ");
INSERT INTO ceslb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Buďte jako sluhové, kteří čekají na svého pána, až se vrátí ze svatby, aby mu otevřeli na první zaklepání. ");
INSERT INTO ceslb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pochválí ty, kteří budou při jeho příchodu vzhůru. Dokonce je posadí za stůl, sám si vezme zástěru a bude je obsluhovat. ");
INSERT INTO ceslb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dobře bude těm, které jejich pán najde bdělé, i kdyby přišel o půlnoci nebo až k ránu. ");
INSERT INTO ceslb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Je přece jasné: Kdyby hospodář věděl, v kterou dobu přijde zloděj, jistě by se na něj přichystal. ");
INSERT INTO ceslb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Proto buďte připravení vždycky, protože Syn člověka přijde ve chvíli, kdy se toho nenadějete.“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petr se zeptal: „Pane, to, co říkáš, platí jenom nám, anebo všem lidem?“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ježíš odpověděl: „Vy máte být jako dobrý správce, kterému pán dal na starost ostatní pracovníky, aby jim pravidelně rozděloval pokrm. ");
INSERT INTO ceslb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pán bude spokojen s takovým správcem, kterého zastihne, že to tak poctivě dělá. ");
INSERT INTO ceslb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Takovému pak svěří do správy celý svůj majetek. ");
INSERT INTO ceslb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ale běda tomu správci, který by si říkal: ‚Můj pán se hned tak nevrátí‘ a začal by špatně nakládat s těmi, kdo by mu byli svěřeni, a sám by hodoval a opíjel se. ");
INSERT INTO ceslb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Když jeho pán nenadále přijde, potrestá ho a vyhodí. ");
INSERT INTO ceslb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","Kdo zná vůli svého pána, ale neřídí se podle ní, bude tvrdě potrestán; kdo ji nezná a udělá něco, co zasluhuje trestu, nedopadne tak zle. Od toho, komu bylo mnoho svěřeno, bude mnoho očekáváno, a kdo dostal jasné pokyny, od toho bude mnoho vyžadováno. ");
INSERT INTO ceslb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zvěst o spáse, kterou jsem přinesl na zem, se bude šířit jako oheň; a jak si přeji, aby už vzplál! ");
INSERT INTO ceslb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Předtím ovšem musím projít křtem utrpení. Jak je mi úzko, než se dokoná. ");
INSERT INTO ceslb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Myslíte si, že jsem přišel, aby zůstalo všechno při starém? S tím nepočítejte! Zvěst o mně každého zneklidní a dokonce postaví i lidi proti sobě navzájem. ");
INSERT INTO ceslb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","I leckterá rodina se rozdělí do dvou táborů: ");
INSERT INTO ceslb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","otec se postaví proti synovi a syn proti otci, matka proti dceři, dcera proti matce, tchyně proti snaše a snacha proti tchyni.“ ");
INSERT INTO ceslb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pak Ježíš řekl zástupům: „Když vidíte, že se od západu zatahuje, čekáte déšť a míváte pravdu. ");
INSERT INTO ceslb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Když vane jižní vítr, očekáváte horko a bývá horko. ");
INSERT INTO ceslb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Chytráci! Úkazy na nebi i na zemi posuzujete a umíte z nich vyvodit závěry. Jak to, že nedovedete posoudit znamení této doby? ");
INSERT INTO ceslb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jestliže je tu chvíle rozhodnutí, proč otálíte dát věci do pořádku? ");
INSERT INTO ceslb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Je to tak, jako když tě věřitel už vede k soudu. Snažíš se s ním ještě cestou vyrovnat. Jinak tě předá soudu a skončíš ve vězení. ");
INSERT INTO ceslb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Odtamtud se nedostaneš dříve, dokud svůj dluh do posledního haléře nezaplatíš.“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","V té době lidé přinesli Ježíšovi zprávu, že Pilát dal pobít galilejské poutníky, zrovna když obětovali. ");
INSERT INTO ceslb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ježíš na to řekl: „Myslíte si, že ti, které zavraždili, byli horšími hříšníky než ostatní obyvatelé Galileje? ");
INSERT INTO ceslb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ne, nebyli. Ať je vám to výstrahou: Smrt čeká na každého z vás a potom bude pozdě litovat svých hříchů. ");
INSERT INTO ceslb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Anebo těch osmnáct, na které se zřítila věž v Siloe; ti také nebyli horší než druzí lidé v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Když však nebudete litovat svých zlých činů, i vás čeká Boží soud.“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ježíš pak vyprávěl toto podobenství. „Jeden muž si vypěstoval na své vinici fíkovník. Když přišel čas sklizně, hledal na něm ovoce, avšak marně. ");
INSERT INTO ceslb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Řekl vinaři: ‚Podívej, už třetí rok čekám na ovoce z tohoto fíkovníku, ale nic nerodí. Poraž ho, jenom tu překáží.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Vinař se přimlouval: ‚Pane ponech ho ještě jeden rok. Zkypřím mu a pohnojím půdu, snad přece bude rodit. ");
INSERT INTO ceslb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Když na něm ani příští rok nic nebude, dáš ho porazit.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jednou v sobotu kázal Ježíš v synagoze. ");
INSERT INTO ceslb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mezi posluchači byla také žena postižená již osmnáct let nemocí, která ji tak pokřivila, že se nemohla napřímit. ");
INSERT INTO ceslb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Když ji Ježíš uviděl, zavolal ji k sobě a řekl: „Ženo, tvé trápení končí.“ Dotkl se jí ");
INSERT INTO ceslb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","a v tom okamžiku se žena narovnala a srdečně děkovala Bohu. ");
INSERT INTO ceslb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Představený synagogy však byl pobouřen, že Ježíš uzdravoval v sobotu a napomínal zástup: „Šest dní se má pracovat! Nechte se uzdravit jindy a ne v sobotu, kdy dodržujeme klid.“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ježíš na to řekl: „Pokrytci! Kdo z vás neodvazuje dobytek, aby ho zavedl k napajedlu? ");
INSERT INTO ceslb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A tato žena, která je potomkem Abrahamovým, neměla být v sobotu zbavena toho, co ji osmnáct let svazovalo?“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jeho odpůrci se zastyděli, ale ostatní lidé se upřímně radovali z podivuhodných činů, které konal. ");
INSERT INTO ceslb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ježíš řekl: „K čemu mám přirovnat Boží království? ");
INSERT INTO ceslb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Je jako nepatrné hořčičné semeno, které si člověk zaseje do zahrady. Ono vyklíčí a vyroste z něho tak mohutná bylina, že na ní mohou hnízdit ptáci. ");
INSERT INTO ceslb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Boží království se dá také přirovnat ke kvasu, který žena zadělá do těsta. I když mouky bude hodně, postačí jen trochu kvasu, aby celé těsto nakynulo.“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ježíš pokračoval na své cestě do Jeruzaléma. Chodil od města k městu, od vesnice k vesnici a všude kázal. ");
INSERT INTO ceslb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kdosi se ho zeptal: „Pane, je asi málo těch, kteří budou zachráněni, že?“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ježíš odpověděl: „Do Božího království vedou úzké dveře a těmi se snažte za každou cenu vejít. ");
INSERT INTO ceslb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jakmile totiž jednou Pán domu přijde, zamkne a pak už bude pozdě. Mnozí by potom ještě rádi vešli, ale už to nepůjde. Marně byste tloukli na dveře a volali: ‚Pane, Pane, otevři nám!‘ Zůstanete venku a Pán vám odpoví: ‚Nevím, kdo jste a odkud jste.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","A i kdybyste říkali: ‚Sedávali jsme s tebou u stolu a učil jsi v našich ulicích,‘ ani to vám nepomůže. ");
INSERT INTO ceslb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jen byste znovu slyšeli: ‚Neznám vás a nevím, odkud jste. Promarnili jste svůj život v hříchu, pryč s vámi.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bude pozdě na nářek, až uvidíte Abrahama, Izáka, Jákoba a všechny proroky v Božím království a vy budete odmítnuti. ");
INSERT INTO ceslb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ze všech světových stran budou proudit lidé, aby v něm zaujali svá místa. ");
INSERT INTO ceslb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mnozí, kteří dnes platí mezi lidmi za poslední, budou první a mnozí, kteří jsou dnes vysoce ceněni, se octnou mezi posledními.“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Za Ježíšem přišlo několik farizejů a varovali ho: „Měl bys utéci z Galileje, Herodes tě chce zabít.“ ");
INSERT INTO ceslb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","On jim řekl: „Jděte a řekněte tomu lišákovi: Ještě po nějaký čas budu uzdravovat, zbavovat lidi trápení na těle i na duchu. ");
INSERT INTO ceslb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ale přijde chvíle, kdy odtud odejdu do Jeruzaléma a tam všechno dokonám. Vždyť je nesmyslné, aby prorok zemřel jinde než tam. ");
INSERT INTO ceslb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeruzaléme, Jeruzaléme, zabíjíš proroky a kamenuješ ty, které ti Bůh posílá. Jak často jsem toužil shromáždit svoje děti jako kvočna kuřátka pod ochranná křídla, ale nechtěli jste. ");
INSERT INTO ceslb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","I váš slavný chrám bude Bohem opuštěn. Říkám vám, že mne neuvidíte do chvíle, kdy budete volat: ‚Sláva tobě, který přicházíš ve jménu Božím.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jednou v sobotu pozval významný farizej Ježíše do svého domu, aby s ním pojedl. Všichni přítomní pozorně sledovali, zda Ježíš dodrží všechny předpisy zákona. ");
INSERT INTO ceslb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","V blízkosti Ježíšově se objevil muž postižený těžkou vodnatelností. ");
INSERT INTO ceslb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ježíš se na farizeje a vykladače zákona obrátil s otázkou: „Je dovoleno v sobotu uzdravovat, nebo ne?“ ");
INSERT INTO ceslb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","To jim zavřelo ústa. Ježíš se muže dotkl, uzdravil ho a poslal pryč. ");
INSERT INTO ceslb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pak jim ještě řekl: „Kdyby někomu z vás spadlo dítě nebo dobytče do jámy, nevytáhli byste ho, i kdyby byla sobota?“ ");
INSERT INTO ceslb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A zase nevěděli, co na to odpovědět. ");
INSERT INTO ceslb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Všiml si, jak se někteří hosté snaží zaujmout čestná místa u stolu, a řekl jim: ");
INSERT INTO ceslb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","10","„Pozve-li vás někdo na svatbu, nesedejte si na přední místa. Mohlo by se totiž stát, že by přišel někdo váženější než vy a bylo by trapné, kdybyste mu se zahanbením museli ustoupit. Není lépe posadit se skromně stranou a nechat hostitele říci: ‚Pojď, příteli, posaď se blíž?‘ To ti bude v očích druhých ke cti. ");
INSERT INTO ceslb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Protože každý, kdo vynáší sám sebe, bude pokořen, ale kdo se umí pokořit, ten bude povýšen.“ ");
INSERT INTO ceslb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A hostiteli řekl: „Dáváš-li oběd nebo večeři, nezvi své přátele, sourozence, příbuzné či vlivné známé. Oni by zase na oplátku pozvali tebe, aby nezůstali nic dlužni. ");
INSERT INTO ceslb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Raději pozvi chudé, zmrzačené, kulhavé a slepé. ");
INSERT INTO ceslb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ti nemají, čím by ti to vynahradili, ale ty budeš mít radost. Takový čin nebude zapomenut ani na věčnosti.“ ");
INSERT INTO ceslb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jeden z hostů ho slyšel a řekl: „Jaká pocta pro každého, kdo bude pozván ke stolu v Božím království.“ ");
INSERT INTO ceslb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na to mu vyprávěl Ježíš podobenství: „Jeden muž připravoval velkou hostinu a pozval na ni mnoho lidí. ");
INSERT INTO ceslb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Když se už přiblížil ten slavnostní den, poslal svého sluhu k pozvaným se vzkazem: ‚Přijďte, vše je uchystáno!‘ ");
INSERT INTO ceslb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ale pozvaní se začali svorně vymlouvat. Jeden řekl: ‚Koupil jsem pole a musím ho jít obhlédnout. Prosím tě, omluv mě u svého pána.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Druhý řekl: ‚Koupil jsem pět volských spřežení a chci je vyzkoušet. Prosím tě, omluv mě.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jiný řekl: ‚Právě jsem se oženil. Uznáš, že teď nemohu přijít.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Když se sluha vrátil a sdělil vše svému pánovi, ten se rozhněval a nařídil mu: ‚Vyjdi rychle do ulic a na náměstí a pozvi chudé, zmrzačené, slepé a chromé.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Když se tak stalo, oznámil sluha pánovi: ‚Splnil jsem tvůj příkaz a ještě zbývá místo.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pán mu řekl: ‚Prohledej ohrady a příkopy a přiveď všechny tuláky a pobudy, ať se můj dům naplní. Přemluv i ty, kteří by si sami netroufali. ");
INSERT INTO ceslb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ale to vám říkám, žádný z těch pozvaných nevděčníků neokusí nic z mé hostiny.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Když se Ježíš zase vydal na cestu, doprovázely ho davy lidí. Obrátil se k nim a řekl: ");
INSERT INTO ceslb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","„Kdo se chce ke mně připojit a nemiluje mne víc než svého otce, matku, ženu, děti, bratry a sestry a dokonce víc než sám sebe, nemůže se stát mým učedníkem. ");
INSERT INTO ceslb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kdo není ochoten vzít na sebe těžkosti, které mu nastanou, když mne bude následovat, nemůže být mým učedníkem. ");
INSERT INTO ceslb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kdo chce stavět dům, musí si nejprve udělat rozpočet a odhadnout, bude-li mít dost prostředků na to, aby stavbu dokončil. ");
INSERT INTO ceslb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Když tak neučiní, stavbu začne, ale nedokončí ji. Všichni se mu vysmějí a řeknou: ");
INSERT INTO ceslb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‚Podívejte se, chtěl stavět, ale nemá na to.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A když panovníkovi hrozí válka, neporadí se nejprve, zda se může se svými deseti tisíci vojáky postavit proti dvaceti tisícům? ");
INSERT INTO ceslb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nepošle raději mírové poselstvo dříve, než ho nepřítel napadne? ");
INSERT INTO ceslb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","A tak každý, kdo se chce stát mým učedníkem, ať si dobře rozváží, čeho by se pro mne musel vzdát. ");
INSERT INTO ceslb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sůl je dobrá věc, ale k čemu bude, ztratí-li svou chuť a schopnost bránit hnilobě? ");
INSERT INTO ceslb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ani k hnojení se nehodí, musí se vyhodit. Snažte se pochopit, co vám říkám.“ ");
INSERT INTO ceslb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Za Ježíšem přicházeli výběrčí daní a jiní lidé se stejně špatnou pověstí, aby si ho poslechli. ");
INSERT INTO ceslb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farizejové a učitelé zákona se nad tím pohoršovali a říkali: „S takovou sebrankou se přátelí a sedá s nimi za jedním stolem!“ ");
INSERT INTO ceslb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ježíš na to odpověděl podobenstvím: ");
INSERT INTO ceslb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","„Kdyby někdo z vás měl sto ovcí a jedna z nich by se mu zaběhla, nepokusil by se ji nalézt? Těch devadesát devět ponechá na pastvě a půjde za tou ztracenou tak dlouho, dokud ji nenalezne. ");
INSERT INTO ceslb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Když ji najde, vezme ji na ramena ");
INSERT INTO ceslb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a s radostí ji ponese domů. Svolá své přátele a sousedy a vybídne je: ‚Radujte se se mnou, našel jsem svou ztracenou ovečku.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Říkám vám, že v nebi je daleko větší radost nad jedním ztraceným člověkem, který lituje svých hříchů, než nad devadesáti devíti takovými, kteří si myslí, že pokání nepotřebují. ");
INSERT INTO ceslb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nebo si představte ženu, která má deset stříbrných mincí a jedna se jí doma někam zakutálí. Nerozsvítí světlo, nevymete kouty a nebude hledat tak dlouho, až peníz najde? ");
INSERT INTO ceslb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Určitě pak svolá přítelkyně a sousedky a řekne jim: ‚Radujte se se mnou, našla jsem svůj ztracený peníz.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Říkám vám: Zrovna takovou radost mají v nebi andělé nad jedním ztraceným člověkem, který lituje svých hříchů.“ ");
INSERT INTO ceslb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ježíš dále vyprávěl: „Jeden muž měl dva syny. ");
INSERT INTO ceslb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mladší přišel za otcem a řekl: ‚Otče, dej mi už teď podíl z dědictví, které nám chceš jednou odkázat.‘ A tak otec rozdělil svůj majetek mezi oba syny. ");
INSERT INTO ceslb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Po několika dnech zpeněžil ten mladší svůj podíl a odešel daleko od domova. Tam prohýřil všechno, co měl. ");
INSERT INTO ceslb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A nejenže všechno utratil; v té krajině vypukl hlad, a tak neměl co do úst. ");
INSERT INTO ceslb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Konečně si našel práci u jednoho sedláka. Ten ho poslal na pole pást vepře. ");
INSERT INTO ceslb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Byl by se rád dosyta najedl alespoň sladkých lusků, kterými krmili vepře, ale nikdo mu nic nedal. ");
INSERT INTO ceslb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A tak šel do sebe a uvažoval: ‚Dělníci mého otce mají jídla více, než mohou spotřebovat, a já tu umírám hlady. ");
INSERT INTO ceslb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Půjdu za ním a řeknu mu: Otče, zhřešil jsem proti Bohu i proti tobě ");
INSERT INTO ceslb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","a dobře vím, že si nezasloužím, abys mne ještě nazýval svým synem. Najmi mne, prosím, jako dělníka.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A tak se vydal na cestu k domovu. Otec ho už z dálky uviděl a plný soucitné lásky mu vyběhl naproti, objal ho a políbil. ");
INSERT INTO ceslb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‚Otče,‘ řekl syn, ‚zhřešil jsem proti Bohu a proti tobě, nejsem hoden, abych byl ještě tvým synem.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ale otec nařídil služebníkům: ‚Rychle přineste nejlepší šaty, navlékněte mu synovský prsten a obujte ho! ");
INSERT INTO ceslb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Poražte vykrmené tele a připravte hostinu. Oslavíme společně návrat mého syna. ");
INSERT INTO ceslb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Vždyť je to, jako by umřel, a zase oživl. Byl ztracen, a je nalezen.‘ A tak oslavovali jeho návrat. ");
INSERT INTO ceslb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Starší syn se vracel z pole a uslyšel hluk hostiny. ");
INSERT INTO ceslb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zavolal si jednoho sluhu a zeptal se, co se děje. ");
INSERT INTO ceslb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sluha řekl: ‚Tvůj bratr přišel domů a otec dal porazit pěkné tele z radosti, že se mu syn vrátil zdráv.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Starší bratr se rozhněval a vůbec nechtěl jít dovnitř. Otec vyšel ven a domlouval mu. ");
INSERT INTO ceslb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ale syn mu vyčítal: ‚Tolik let jsem pro tebe dřel, ve všem tě poslechl a co z toho mám? Nikdy jsi mi nedal ani kůzle, abych se poveselil se svými přáteli. ");
INSERT INTO ceslb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A teď, když se vrátil tenhle tvůj synáček, který všechno prohýřil s děvkami, ještě mu vystrojíš hostinu.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‚Hochu,‘ řekl otec, ‚my jsme tu přece vždycky byli spolu a ty víš, že všechno, co mám, je tvoje. ");
INSERT INTO ceslb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ale teď nemůžeme dělat nic jiného než se radovat. Vždyť tvůj bratr, kterého jsme považovali za mrtvého, žije, ztratil se a je nalezen.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ježíš vyprávěl svým učedníkům: „Jeden boháč měl správce a ten byl obviněn ze zpronevěry. ");
INSERT INTO ceslb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pán si ho dal zavolat a řekl mu: ‚Co to o tobě slyším? Předlož mi všechny účty, a jestli jsi mě podváděl, dám ti výpověď.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Správce přemýšlel: ‚Co teď? Krumpáčem se neuživím, žebrat se stydím. ");
INSERT INTO ceslb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mám nápad, jak si získat přátele; snad mi pak nabídnou slušné místo, až budu propuštěn!‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dal si zavolat dva dlužníky svého pána, ale s každým mluvil zvlášť. Zeptal se prvního: ‚Kolik jsi dlužen mému pánovi?‘ Muž odpověděl: ‚Sto džbánů olivového oleje.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Správce řekl: ‚Tady máš svůj dlužní úpis, sedni si a napiš nový na padesát.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Zeptal se pak toho druhého: ‚Co dlužíš mému pánovi?‘ On odpověděl: ‚Sto pytlů pšenice.‘ I řekl mu správce: ‚Vezmi si dlužní úpis a napiš jiný na osmdesát.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pán nakonec vychytralého správce pochválil, že si uměl v nouzi poradit. Nutno přiznat, že lidé, kterým jde o hmotný zisk, bývají ve svých záležitostech prozíravější než věřící, ");
INSERT INTO ceslb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","když jde o zajištění věčného života. Říkám vám: Na penězích lpí hodně špíny a jednou úplně ztratí hodnotu. Jestliže však jimi někomu pomůžete, proměníte je na lásku, se kterou se sejdete na věčnosti.“ ");
INSERT INTO ceslb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ježíš pokračoval: „Kdo je spolehlivý v drobnostech, je spolehlivý i v podstatných věcech. A ten, kdo je nečestný v maličkostech, selhává i ve věcech závažných. ");
INSERT INTO ceslb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Jste-li nepoctiví v záležitostech tohoto života, kdo může důvěřovat vaší víře v Boha? Neumíte-li správně zacházet s mizernými penězi, jak vám může Bůh svěřit věčné bohatství? ");
INSERT INTO ceslb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Žádný nemůže sloužit dvěma pánům. Vždycky bude jednoho nenávidět a druhého milovat. Jednomu dá přednost a druhým bude pohrdat. Nemůžete tedy sloužit Bohu a zároveň otročit majetku.“ ");
INSERT INTO ceslb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Slyšeli to farizejové, kteří byli chtiví peněz a vysmáli se mu. ");
INSERT INTO ceslb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","On jim však řekl: „Chcete dělat dobrý dojem na lidi svou zbožností, ale Bůh do vás vidí. Vnějším úspěchem, kterému se obdivují lidé, Bůh pohrdá. ");
INSERT INTO ceslb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Období zákona a proroků skončilo Janem Křtitelem. Teď slyšíte radostnou zprávu, že přišlo Boží království a kdekdo si dělá nárok na vstup do něho. ");
INSERT INTO ceslb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ale nepleťte se, spíše pomine nebe a země, než by jediný z požadavků Božího zákona ztratil svou platnost. ");
INSERT INTO ceslb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Například, kdo se rozvádí se svou ženou a bere si jinou, proviňuje se proti přikázání ‚nezcizoložíš‘; a kdo se žení s rozvedenou, také cizoloží. ");
INSERT INTO ceslb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Byl jednou jeden bohatý muž, který se nákladně oblékal a každý den u něj bylo veselo a bohatě prostřeno. ");
INSERT INTO ceslb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","U vrat jeho domu sedával žebrák Lazar. Jeho tělo bylo samý vřed. ");
INSERT INTO ceslb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aby utišil hlad, čekával na zbytky ze stolu toho boháče. Psi přibíhali a olizovali mu rány. ");
INSERT INTO ceslb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lazar zemřel a andělé ho přenesli k Abrahamovi. Krátce nato zemřel i boháč a pohřbili ho. ");
INSERT INTO ceslb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","V ohnivých mukách pozdvihl oči a uviděl v dálce Abrahama s Lazarem ");
INSERT INTO ceslb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","a prosil: ‚Otče Abrahame, smiluj se nade mnou a pošli Lazara, ať namočí alespoň špičku prstu ve vodě a svlaží mi rty, hrozně tu v tom žáru trpím.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham však řekl: ‚Vzpomeň si, jak se ti vedlo na zemi. Tobě se vždycky dařilo dobře, ale na Lazara zbylo jen to nejhorší. Nyní se má dobře on, a ty trpíš. ");
INSERT INTO ceslb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kromě toho je mezi námi taková propast, že ji nikdo nemůže překonat, i kdyby se snažil.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Boháč se ještě přimlouval: ‚Otče Abrahame, pošli ho tedy do mého rodného domu. ");
INSERT INTO ceslb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mám pět bratrů, ať je někdo varuje, aby nedopadli jako já.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham odpověděl: ‚Mají přece Bibli, ať se podle ní řídí.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Boháč však odporoval: ‚Kdepak, otče Abrahame, Písmo na ně nestačí, ale kdyby tak někdo vstal z mrtvých, to by na všechno hleděli jinak.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham odpověděl: ‚Když nedají na Mojžíšův zákon a proroky, neuvěří nikomu, i kdyby vstal z mrtvých.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ježíš řekl svým učedníkům: „Vždycky se setkáte s někým, kdo svádí ke zlému, ale běda tomu, kdo to dělá. ");
INSERT INTO ceslb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pro takového by bylo lépe, kdyby mu uvázali na krk mlýnský kámen a hodili ho do moře, než aby svedl ke zlému jednoho z těch nejposlednějších. ");
INSERT INTO ceslb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Buďte na to opatrní! Jestliže se proti tobě někdo proviní, domluv mu, a když toho bude litovat, odpusť mu. ");
INSERT INTO ceslb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A i kdyby tě prosil o odpuštění sedmkrát za den a upřímně litoval svých činů, vždy mu znovu odpusť.“ ");
INSERT INTO ceslb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Učedníci prosili Ježíše: „Dej nám mocnou víru!“ ");
INSERT INTO ceslb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","On odpověděl: „Kdybyste měli víru aspoň jako zrnko hořčice a řekli tomuto stromu: ‚Vyrvi se i s kořeny a přesaď se do moře,‘ stalo by se to. ");
INSERT INTO ceslb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","A ještě něco: Když se nějaký otrok vrátí po celodenní práci na poli, není zbaven domácích povinností. Nebo jste snad slyšeli, že by si sedl ke stolu a že by ho pán obsluhoval ");
INSERT INTO ceslb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","a děkoval mu za vyplněný úkol? ");
INSERT INTO ceslb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Podobně je to i s vámi. Když uděláte všechno, co vám Bůh ukládá, řekněte: ‚Jsme jen služebníci, vykonali jsme pouze svou povinnost.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na cestě do Jeruzaléma procházel Ježíš pomezím Samařska a Galileje. ");
INSERT INTO ceslb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","U jedné vesnice se s ním potkalo deset malomocných. Zastavili se opodál ");
INSERT INTO ceslb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","a volali: „Ježíši, Pane, slituj se nad námi.“ ");
INSERT INTO ceslb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Podíval se na ně a řekl: „Jděte a ukažte se kněžím, ať vám potvrdí, že jste zdrávi.“ Poslechli a cestou byli své nemoci zbaveni. ");
INSERT INTO ceslb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jeden z nich, když zjistil, že je zdráv, vrátil se a hlasitě chválil Boha. ");
INSERT INTO ceslb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Padl Ježíšovi k nohám a z celého srdce mu děkoval. Ten muž byl Samařan. ");
INSERT INTO ceslb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ježíš se ho zeptal: „Nebylo vás uzdraveno deset? Kde je devět ostatních? ");
INSERT INTO ceslb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Proč se také nevrátili, aby Bohu poděkovali jako tento cizinec?“ ");
INSERT INTO ceslb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A tomu muži řekl: „Vstaň a jdi, tvá víra tě zachránila.“ ");
INSERT INTO ceslb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farizejové se Ježíše ptali, kdy přijde Boží království. Odpověděl jim: „Boží království nenajdete na určitém místě, ");
INSERT INTO ceslb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","abyste mohli říci: Je tady nebo tam. Ono už je mezi vámi.“ ");
INSERT INTO ceslb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Svým učedníkům řekl: „Přijde doba, kdy si budete toužebně přát, abych se vrátil a viditelně se ujal vlády. Ale ještě to nebude tak hned. ");
INSERT INTO ceslb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nedejte se mýlit, když vám budou říkat: ‚Kristus je tamhle‘ nebo ‚je tady!‘ Nechoďte nikam a nikoho takového nenásledujte. ");
INSERT INTO ceslb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jako když oslňující blesk protne oblohu a je dobře viditelný z mnoha míst země, tak náhlý a zřetelný bude můj návrat. ");
INSERT INTO ceslb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Napřed však musím mnoho vytrpět a tato nevěřící generace mne zavrhne. ");
INSERT INTO ceslb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","V den, kdy znovu přijdu, bude to s lidmi stejné jako za dnů Noeho. ");
INSERT INTO ceslb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","I tehdy se lidé zajímali jen o jídlo, pití a sex až do chvíle, kdy přišla potopa a všechny zahubila. Jen Noe se svou rodinou se zachránil v korábu. ");
INSERT INTO ceslb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Stejně tomu bylo s Lotem. Obyvatelé Sodomy jedli, pili, kupovali, prodávali, sázeli i stavěli ");
INSERT INTO ceslb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","až do dne, kdy Bůh Lota vyvedl z města. Tehdy nastala zkáza a celá Sodoma zahynula v ohni. ");
INSERT INTO ceslb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tak překvapivý a zřejmý bude i můj příchod. ");
INSERT INTO ceslb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ať v té chvíli budete kdekoliv, nevracejte se už pro nic domů. ");
INSERT INTO ceslb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Vzpomeňte si na Lotovu ženu. Jediné ohlédnutí po Sodomě ji stálo život. ");
INSERT INTO ceslb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kdo lpí jenom na svém pozemském životě, ztratí všechno, ale kdo ho odevzdá Bohu, bude zachráněn. ");
INSERT INTO ceslb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Říkám vám: V tu noc budou dva na jednom lůžku, jednoho vezmu k sobě, druhý bude zanechán. ");
INSERT INTO ceslb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dvě ženy budou spolu pracovat v kuchyni, jedna bude zachráněna, druhá zanechána. ");
INSERT INTO ceslb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dva muži budou spolu dělat na jednom poli, jeden bude zachráněn, druhý zanechán.“ ");
INSERT INTO ceslb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Učedníci se ho zeptali: „Kde se to všechno stane?“ Odpověděl jim: „Tak jako supi bezpečně najdou každé mrtvé tělo, tak také nikdo na žádném místě neunikne Božímu soudu.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ježíš ještě připojil podobenství o tom, jak je zapotřebí vytrvale se modlit: ");
INSERT INTO ceslb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","„V jednom městě žil soudce, který na Boha nedal a na lidi se neohlížel. ");
INSERT INTO ceslb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Byla tam také jedna vdova a ta za ním neustále chodila, aby jí dopomohl v právu proti člověku, který jí ublížil. ");
INSERT INTO ceslb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Soudce ji dlouho odbýval, ale nakonec si řekl: ‚Je mi sice jedno, co si Bůh nebo lidé o té věci myslí, ");
INSERT INTO ceslb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ale když je tak neodbytná, vyhovím jí. Jinak bude stále za mnou chodit, až mne umoří.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Vidíte, neodbytné prosebnici nakonec vyhoví i tak špatný soudce. ");
INSERT INTO ceslb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jak by Bůh nepřišel na pomoc těm, kteří k němu volají dnem i nocí. ");
INSERT INTO ceslb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","I když jim okamžitě nevyhoví, přesto jim trpělivě naslouchá a nakonec pomůže v pravý čas. Ale až znovu přijdu, naleznu lidi s tak vytrvalou vírou?“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Těm, kteří si myslí, že jsou bez chyby, a dívají se na druhé spatra, vyprávěl Ježíš toto podobenství: ");
INSERT INTO ceslb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","„Dva muži přišli do chrámu, aby se pomodlili; jeden farizej a druhý publikán. ");
INSERT INTO ceslb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizej si stoupl dopředu a modlil se: ‚Bože, děkuji ti, že nejsem tak chamtivý, nečestný nebo rozbíječ rodiny jako ostatní lidé, třeba jako tady ten výběrčí daní. ");
INSERT INTO ceslb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dvakrát týdně se postím a dávám ti desetinu ze všech svých příjmů.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ten výběrčí stál úplně vzadu, hlavu měl skloněnou, ani se neodvážil pohlédnout vzhůru. Na znamení lítosti se bil do prsou a modlil se: ‚Bože, slituj se nade mnou, jsem velký hříšník.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ježíš uzavřel: „Publikán nebyl v chrámu nadarmo; Bůh ho vzal na milost, ale toho farizeje si ani nevšiml. Každý, kdo vynáší sám sebe, bude pokořen, a kdo se před Bohem koří, bude povýšen.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lidé přinášeli k Ježíšovi i malé děti, aby jim žehnal. Když to učedníci viděli, odháněli je. ");
INSERT INTO ceslb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ježíš však zavolal rodiče s dětmi k sobě a řekl: „Nebraňte dětem v přístupu ke mně, neodhánějte je. Boží království je právě pro takové, jako jsou ony; ");
INSERT INTO ceslb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","kdo neuvěří tak prostě jako dítě, nevejde do něho.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jeden vznešený muž se Ježíše zeptal: „Svatý učiteli, co musím dělat, abych získal věčný život?“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ježíš mu řekl: „Co tě vede k tomu, že mě nazýváš svatým? Vždyť svatý je pouze Bůh! ");
INSERT INTO ceslb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Znáš jeho přikázání: Nezcizoložíš, nezabiješ, nikoho neokradeš, nepomluvíš a nenařkneš nikoho křivě, budeš si vážit svých rodičů.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Muž odpověděl: „Tato přikázání se snažím dodržovat už od svého mládí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ježíš mu řekl: „A přece ti ještě něco chybí. Prodej všechno, co máš, rozdej to chudým, a budeš mít poklad v nebi. Pak přijď a následuj mne.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jak to muž uslyšel, zesmutněl a odešel, protože byl velice bohatý. ");
INSERT INTO ceslb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Když to Ježíš uviděl, řekl: „Jak nesnadno přicházejí lidé k Bohu. ");
INSERT INTO ceslb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","To spíš projde velbloud uchem jehly než boháč do Božího království.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lidé, kteří to slyšeli, se ptali: „Kdo tedy vůbec může být spasen?“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","On odpověděl: „Na co člověk nestačí, to může učinit Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na to řekl Petr: „Ty víš, že jsme pro tebe opustili všechno a šli za tebou.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ježíš odpověděl: „Žádný, kdo se musel pro Boží království něčeho vzdát – domova, manželky, sourozenců, rodičů nebo dětí, nezůstane bez odměny. ");
INSERT INTO ceslb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Již v tomto světě získá mnohem více a v budoucím obdrží život věčný.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ježíš si vzal stranou svých dvanáct učedníků a řekl jim: „Jdeme teď do Jeruzaléma a tam se vyplní všechno, co napsali starodávní proroci o Synu člověka. ");
INSERT INTO ceslb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Budu vydán do rukou pohanů, budou se mi vysmívat, budou mne týrat a plivat na mě. ");
INSERT INTO ceslb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pak mne zbičují a zabijí, ale třetího dne vstanu z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Učedníci to vůbec nechápali a jeho slova jim byla záhadou. ");
INSERT INTO ceslb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Když se blížili k Jerichu, seděl u cesty slepec a žebral. ");
INSERT INTO ceslb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Slyšel, že kolem proudí davy lidí a ptal se, co to má znamenat. ");
INSERT INTO ceslb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Řekli mu, že tudy jde Ježíš z Nazaretu. ");
INSERT INTO ceslb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Začal volat: „Ježíši, Davidův potomku, slituj se nade mnou.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lidé, kteří Ježíše provázeli, slepce okřikovali, ale on volal tím víc: „Králi z Davidova rodu, slituj se nade mnou.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ježíš se zastavil a zavolal slepce k sobě. ");
INSERT INTO ceslb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Když ho k němu přivedli, zeptal se Ježíš: „Co pro tebe mám udělat?“ Slepec odpověděl: „Pane, ať vidím!“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ježíš řekl: „Prohlédni! Tvá víra tě zachránila.“ ");
INSERT INTO ceslb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","V tom okamžiku slepec nabyl zrak, děkoval Bohu a šel za Ježíšem. A všichni, kteří toho byli svědky, chválili Boha. ");
INSERT INTO ceslb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Potom Ježíš vešel do Jericha. ");
INSERT INTO ceslb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Žil tam vrchní výběrčí daní Zacheus, velký boháč. ");
INSERT INTO ceslb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Chtěl za každou cenu vidět Ježíše, ale protože sám byl malé postavy a okolo Ježíše se tísnily davy lidí, ");
INSERT INTO ceslb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","předběhl průvod a vylezl na strom; odtamtud ho vyhlížel. ");
INSERT INTO ceslb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Když Ježíš došel až k tomu místu, podíval se vzhůru a řekl: „Zachee, pojď rychle dolů, chci dnes být tvým hostem.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacheus slezl, jak nejrychleji uměl a plný radosti si odváděl Ježíše domů. ");
INSERT INTO ceslb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lidé se posmívali: „Jde na návštěvu k takovému hříšníkovi!“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tu se Zacheus zastavil a obrátil na Ježíše: „Pane, polovinu svého majetku rozdám chudým a koho jsem okradl, tomu to čtyřnásobně vynahradím.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nato Ježíš řekl: „Dnes se pro tohoto muže a jeho rodinu všechno mění. Teď plným právem patří k Božímu lidu. ");
INSERT INTO ceslb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Přišel jsem hledat a zachránit právě ty ztracené.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tyto události a to, že měl Ježíš namířeno do Jeruzaléma, vedlo lidi k domněnce, že se nyní ujme své vlády. ");
INSERT INTO ceslb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jak to doopravdy bude, jim Ježíš naznačil následujícím vyprávěním: „Jeden vznešený muž odešel daleko za hranice své vlasti, aby se tam dal korunovat a vrátil se zpět jako král. ");
INSERT INTO ceslb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Předtím si však zavolal svých deset úředníků, dal každému z nich určitý obnos a řekl: ‚Nenechte je ležet ladem a snažte se jimi něco získat.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Někteří občané ho však nenáviděli, a proto žádali: ‚Nechceme, aby byl naším králem.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Vladař se však přesto vrátil s královskou hodností. Ihned si dal předvolat úředníky, kterým svěřil peníze, aby zjistil, jak hospodařili. ");
INSERT INTO ceslb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Přišel první a řekl: ‚Pane, získal jsem desetkrát tolik, než jsi mi svěřil.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Král ho pochválil: ‚Výborně, jsi dobrý hospodář. Nešlo o mnoho a obstál jsi. Svěřuji ti proto vládu nad deseti městy.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Přišel druhý úředník, aby vykázal zisk: ‚Pane, mám pro tebe pětkrát tolik, než jsi mi svěřil.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","I toho král pochválil a svěřil mu správu nad pěti městy. ");
INSERT INTO ceslb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pak přišel další a řekl: ‚Pane, vím, že jsi přísný, ");
INSERT INTO ceslb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","a tak jsem se bál o tvůj majetek. Dobře jsem ho ukryl a tady ti ho vracím nedotčený.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Král mu řekl: ‚Tvá vlastní slova tě soudí, lenochu. Věděl jsi, co jsem nařídil, a nesplnil jsi to. ");
INSERT INTO ceslb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Proč jsi moje peníze alespoň neuložil na úrok?‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pak řekl okolostojícím: ‚Vezměte ty peníze od něho a dejte je tomu, kdo získal desetinásobek.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Namítali: ‚Pane, vždyť ten už má dost.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Král odpověděl: ‚Každému, kdo se osvědčí, bude ještě přidáno, ale ten, kdo se neosvědčí, přijde o všechno. ");
INSERT INTO ceslb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A mé nepřátele, kteří mne nechtěli za panovníka, popravte!‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Když skončil svoje vypravování, pokračoval v cestě do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","V blízkosti dvora Betfage u Betanie pod Olivovou horou vyzval dva své učedníky: „Jděte naproti do městečka. Najdete tam uvázané oslátko, na kterém dosud nikdo neseděl. Odvažte ho a přiveďte. ");
INSERT INTO ceslb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kdyby se vás někdo ptal, proč to děláte, řekněte: ‚Pán ho potřebuje.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ti dva šli a nalezli všechno tak, jak Ježíš řekl. ");
INSERT INTO ceslb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Když oslátko odvazovali, přišli majitelé a ptali se, proč to dělají. ");
INSERT INTO ceslb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Odpověděli: „Pán ho potřebuje.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Přivedli oslíka, pokryli mu hřbet svými plášti a posadili na něj Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ostatní lidé stlali dokonce své pláště na cestu, kudy jel. ");
INSERT INTO ceslb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Když začali sestupovat z Olivové hory, zmocnilo se zástupu nadšení; děkovali Bohu za všechny divy, které na vlastní oči viděli. ");
INSERT INTO ceslb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Provolávali: „Sláva králi, Bůh ho posílá! Nebe je smířeno, sláva!“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Byli tam také někteří farizejové a ti mu domlouvali: „Pokárej své učedníky, aby se takhle nerouhali.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ježíš odpověděl: „Jestliže oni zmlknou, bude volat kamení.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Když se před Ježíšem otevřel pohled na Jeruzalém, vstoupily mu slzy do očí a plný smutku ");
INSERT INTO ceslb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","řekl: „Město, kéž bys alespoň dnes pochopilo, co ti může přinést pokoj. Ty však nic nechápeš, ");
INSERT INTO ceslb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","a tak přijde den, kdy tě obklíčí nepřátelé a oblehnou tě. ");
INSERT INTO ceslb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nakonec tě srovnají se zemí a tvé syny pobijí, protože jsi nerozeznalo čas, kdy k tobě přichází Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","V Jeruzalémě vešel do chrámu a hned za branou narazil na ty, kdo tam prodávali. Začal je vyhánět ");
INSERT INTO ceslb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","se slovy: „Je psáno, že tento chrám je svaté místo pro modlitby, a vy jste z něho udělali tržiště.“ ");
INSERT INTO ceslb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Po několik dní se Ježíš vracel do chrámu a učil tam. Velekněží a vykladači zákona se ho chtěli za podpory předních občanů Jeruzaléma zmocnit a připravit ho o život, ");
INSERT INTO ceslb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ale nevěděli, jak to udělat, protože lid ho miloval a rád mu naslouchal. ");
INSERT INTO ceslb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jednoho dne, když Ježíš mluvil k lidem shromážděným v chrámu a ukazoval jim, jak se k nim Bůh přiblížil, přišli za ním velekněží, učitelé zákona a židovští představitelé s otázkou: ");
INSERT INTO ceslb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","„Kdo tě pověřil, od koho máš takovou pravomoc?“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Řekl jim: „Než odpovím, chci slyšet od vás: ");
INSERT INTO ceslb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kdo pověřil Jana Křtitele jeho posláním? Bůh nebo lidé?“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tou otázkou je zaskočil a oni se mezi sebou dohadovali: „Řekneme-li Bůh, pak se nás zeptá, proč jsme mu tedy neuvěřili, ");
INSERT INTO ceslb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","a řekneme-li, že lidé, mohl by nás lid kamenovat, protože oni věří, že Jan Křtitel byl prorok.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nakonec odpověděli: „Nevíme, kdo poslal Jana.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nato Ježíš řekl: „Pak nemá význam, abych vám pověděl, kdo pověřil mne.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pak se obrátil k okolostojícím a vyprávěl jim obrazný příběh: „Jeden člověk založil vinici. Pronajal ji vinařům a na dlouhou dobu odcestoval. ");
INSERT INTO ceslb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Když přišla doba sklizně, poslal k vinařům svého sluhu, aby mu odevzdali podíl z úrody. Ti však posla zmrskali a vyhnali s prázdnou. ");
INSERT INTO ceslb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Majitel vinice tam poslal jiného sluhu, ale i toho zbili, vysmáli se mu a nic mu nedali. ");
INSERT INTO ceslb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ještě třetího sluhu tam pán poslal. Toho dokonce zranili a vyhnali. ");
INSERT INTO ceslb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Majitel vinice si řekl: ‚Co mám dělat? Zkusím to ještě s nimi. Pošlu tam svého syna, před ním budou mít respekt.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ale když vinaři uviděli majitelova syna, dohodli se mezi sebou: ‚To je dědic, zabijeme ho, a vinice bude naše.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","A tak se stalo. Vyvlekli ho ven z vinice a zabili ho. ");
INSERT INTO ceslb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Co myslíte, že udělá majitel s těmi proradnými nájemci? Přijde, podle zásluhy je ztrestá a vinici svěří jiným.“ Posluchači pochopili, kam tím Ježíš míří, a namítali: „Co si to o nás myslíš? Tak hluboko jsme neklesli.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ježíš se na ně podíval a řekl: „Přemýšlejte o tom, co znamenají slova napsaná v Bibli: ‚Kámen, který stavitelé odhodili jako nepotřebný, se ukázal jako nejdůležitější – svorník stavby.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Každý, kdo ten kámen přehlíží, o něj dříve nebo později klopýtne a potluče se. Kdo ho dává jinam, než kámen skutečně patří, vystavuje se nebezpečí, že se mu celá stavba zřítí a ten kámen ho rozdrtí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Velekněží a učitelé zákona mu v té chvíli v duchu podepisovali rozsudek smrti, ale nic nepodnikli, protože se báli lidu. Dobře totiž pochopili, že to podobenství platilo jim. ");
INSERT INTO ceslb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hledali tedy vhodnou příležitost a poslali za ním své lidi. Měli předstírat upřímný zájem o jeho kázání a vyprovokovat ho k nějakému výroku, pro který by mohl být obžalován před římskou správou. ");
INSERT INTO ceslb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Zeptali se ho tedy: „Mistře, my víme, že tvoje učení je správné, neděláš mezi lidmi rozdíl a hlásáš Boží pravdu, padni komu padni. ");
INSERT INTO ceslb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Řekni nám, máme platit daně římskému císaři, nebo nemáme?“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","On však prohlédl jejich lest a vyzval je: ");
INSERT INTO ceslb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","„Podejte mi peníz! Čí obraz a jméno jsou na něm vyraženy?“ Odpověděli: „Císaře.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","On jim na to řekl: „Dávejte tedy, co je císařovo, císaři, a co je Boží, dávejte Bohu.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A tak se jim nepodařilo Ježíše nachytat a zmlkli, překvapeni jeho odpovědí. ");
INSERT INTO ceslb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pak přišli k Ježíšovi saducejové. Ti chtěli být moderní, a tak popírali i vzkříšení z mrtvých a věčný život. Předložili mu vymyšlený problém: ");
INSERT INTO ceslb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","„Mistře, Mojžíš napsal ve svém zákoně: Zemře-li ženatý muž bezdětný, jeho bratr je povinen oženit se s vdovou. ");
INSERT INTO ceslb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Představ si rodinu, kde bylo sedm bratrů. Nejstarší se oženil a zemřel, aniž by zanechal potomka. ");
INSERT INTO ceslb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","S vdovou se oženil druhý bratr, ale také zemřel bez dětí. Tak tomu bylo i s třetím a dalšími, až se s tou ženou oženilo postupně všech sedm a všichni zůstali bezdětní. ");
INSERT INTO ceslb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nakonec zemřela i ona. ");
INSERT INTO ceslb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Komu bude při vzkříšení náležet, když měla sedm manželů?“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","36","Ježíš odpověděl: „Manželství a rodina jsou záležitostí pozemského života. Avšak pro ty, které Bůh vzkřísí a přijme do věčného života, ztratí manželství svůj pozemský smysl. Budou všichni tvořit Boží rodinu, podobně jako jeho andělé. ");
INSERT INTO ceslb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A že bude vzkříšení z mrtvých, to poznal již Mojžíš, na kterého se tak rádi odvoláváte. Když k němu Bůh mluvil z hořícího keře, představil se mu jako Bůh Abrahamův, Bůh Izákův a Bůh Jákobův. Ti přece dávno před tím zemřeli. ");
INSERT INTO ceslb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A tak Bůh není Bohem mrtvých, ale živých; on nabízí život všem, kdo mu uvěří.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Několik učitelů zákona řeklo: „Mistře, to jsi jim dobře odpověděl.“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pak se už nikdo neodvážil na něco se ho zeptat. ");
INSERT INTO ceslb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Položil jim tedy otázku: „Jak to, že někteří z vás nazýváte Mesiáše synem Davidovým? ");
INSERT INTO ceslb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Vždyť sám David o něm píše v knize Žalmů: ‚Bůh říká mému Pánu: Seď po mé pravici a vládni se mnou, ");
INSERT INTO ceslb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dokud ti neodevzdám moc nade všemi lidmi.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jak by tedy mohl být Mesiáš Davidovým potomkem, když ten ho nazývá svým Pánem?“ ");
INSERT INTO ceslb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Učedníkům pak řekl přede všemi lidmi: ");
INSERT INTO ceslb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","47","„Varujte se takových znalců zákona, kteří se rádi ukazují v honosných talárech a čekají, že je lidé budou na ulici uctivě zdravit. Při bohoslužbách sedají v předních řadách a vyhrazují si čestná místa na hostinách. Dlouze se modlí, aby udělali dobrý dojem. Ve skutečnosti jsou to pokrytci, kteří se nestydí vyjídat domácnosti vdov. Ti budou jednou zvlášť přísně potrestáni.“ ");
INSERT INTO ceslb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ježíš pozoroval, jak zámožní lidé vhazují peníze do chrámové pokladny. ");
INSERT INTO ceslb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Přišla také jedna chudá vdova a vhodila tam dvě nepatrné mince. ");
INSERT INTO ceslb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ježíš k tomu poznamenal: „Tato chudá vdova dala vlastně více než kterýkoliv z těch boháčů. ");
INSERT INTO ceslb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ti darovali jen to, co mohli snadno postrádat, ale ta žena obětovala všechny své peníze, vše, co měla na živobytí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Někteří se obdivovali, z jakého pěkného kamene je chrám vystavěn a jak je nádherně vyzdoben. Ježíš ale řekl: ");
INSERT INTO ceslb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","„Přijdou dny, kdy ze všeho, čemu se teď obdivujete, nezůstane kámen na kameni, všechno to bude rozbořeno.“ ");
INSERT INTO ceslb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Zeptali se ho: „Mistře, kdy se to stane? Budou tomu předcházet nějaká znamení?“ ");
INSERT INTO ceslb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Odpověděl: „Nedejte se nikým svést. Mnozí přijdou a budou se prohlašovat za Mesiáše. Budou říkat: ‚Čas se naplnil.‘ Ale nevěřte jim. ");
INSERT INTO ceslb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Až uslyšíte o různých válkách a povstáních, neděste se. To vše musí přijít, ale ještě to nebude konec světa.“ ");
INSERT INTO ceslb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A dodal: „Znepřátelí se národy i státy. ");
INSERT INTO ceslb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Budou velká zemětřesení a z různých stran přijdou zprávy o hladu, nakažlivých nemocech, hrůzách a nezvyklých úkazech na obloze. ");
INSERT INTO ceslb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ale než k tomu dojde, nastane ještě doba velkého pronásledování. Budou vás vláčet před soudy, vodit před krále a vladaře, uvrhnou vás do vězení, a to všechno proto, že jste uvěřili ve mne. ");
INSERT INTO ceslb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","To bude vaše příležitost, abyste se ke mně přiznali. ");
INSERT INTO ceslb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nepřipravujte si předem svoji obhajobu. ");
INSERT INTO ceslb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Já vám v té chvíli vnuknu pravá slova i vhodné argumenty, které vaše protivníky umlčí. ");
INSERT INTO ceslb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Někdy vás zradí i vlastní rodiče, sourozenci, příbuzní a přátelé. A některé z vás dokonce vydají i na smrt. ");
INSERT INTO ceslb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Budete v nenávisti, protože se ke mně hlásíte. ");
INSERT INTO ceslb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ale nebojte se, ani jeden vlas z hlavy neztratíte zbytečně. ");
INSERT INTO ceslb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jen vydržte, získáte život! ");
INSERT INTO ceslb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Až uvidíte, že se kolem Jeruzaléma stahují vojska, pak přišla chvíle, kdy bude zpustošen. ");
INSERT INTO ceslb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Koho to zastihne v Judsku, ať uprchne do hor. Kdo bude v Jeruzalémě, ať se pokusí rychle z něho utéci, a kdo bude mimo, ať se do něho nevrací. ");
INSERT INTO ceslb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","To budou dny trestu a splní se vše, co o tom napsali proroci. ");
INSERT INTO ceslb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Zle bude v těch dnech těhotným ženám a kojícím matkám. Velké strádání čeká tento národ, protože Boží hněv je namířen proti němu. ");
INSERT INTO ceslb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mnozí budou zabiti, mnozí odvlečeni do otroctví po celé říši; v Jeruzalémě se budou roztahovat pohané, ale i na ně nakonec dojde. ");
INSERT INTO ceslb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Na konci času vyměřeného lidstvu se objeví na slunci, měsíci i hvězdách zvláštní úkazy. ");
INSERT INTO ceslb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lidé na zemi budou prožívat velikou úzkost a události se na ně budou valit jako vzedmuté moře. Smrtelný strach zachvátí celý svět. I stálost řádů ve vesmíru bude narušena. ");
INSERT INTO ceslb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A tehdy uvidí přicházet Syna člověka v oblaku s královskou mocí a slávou. ");
INSERT INTO ceslb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Až se to všechno začne dít, vzmužte se a hleďte vzhůru, protože vaše konečné vysvobození bude již blízko.“ ");
INSERT INTO ceslb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ještě jim to zdůraznil přirovnáním: „Všimněte si fíkovníku nebo kteréhokoliv jiného stromu. ");
INSERT INTO ceslb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Když vyraší listí, sami dobře víte, že se blíží léto. ");
INSERT INTO ceslb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Zrovna tak, až uvidíte všechna znamení, o kterých jsem s vámi mluvil, poznáte, že se blíží Boží království ve své plné moci. ");
INSERT INTO ceslb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Říkám vám, že ještě tato generace uvidí, jak se má slova začínají plnit. ");
INSERT INTO ceslb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nebe i země jednou skončí, ale má slova nikdy neztratí svou platnost. ");
INSERT INTO ceslb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Dejte si na sebe pozor! Nedopusťte, aby vaše mysl byla otupena nestřídmostí, opilstvím a starostmi o živobytí. Pak by vás ten den zastihl jako past, ze které nikdo nepřipravený neunikne. ");
INSERT INTO ceslb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Buďte proto na stráži, modlete se, abyste unikli hrůzám, které mají přijít, a mohli nakonec obstát před Synem člověka.“ ");
INSERT INTO ceslb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ve dne učil Ježíš v chrámu a večer odcházel na Olivovou horu a zůstával tam přes noc. ");
INSERT INTO ceslb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Už časně ráno přicházeli lidé do chrámu, aby mu naslouchali. ");
INSERT INTO ceslb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Přiblížily se Velikonoce. ");
INSERT INTO ceslb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Velekněží a učitelé zákona hledali vhodný způsob, jak Ježíše zprovodit ze světa. Báli se však lidí, kteří se v Jeruzalémě shromažďovali k velikonočním svátkům. ");
INSERT INTO ceslb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jidáš Iškariotský – jeden z dvanácti Ježíšových učedníků – podlehl satanskému pokušení, ");
INSERT INTO ceslb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","odešel za veleknězi a veliteli chrámové stráže a nabídl jim pomoc při Ježíšově zatčení. ");
INSERT INTO ceslb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ti se samozřejmě zaradovali a slíbili mu odměnu. ");
INSERT INTO ceslb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jidáš souhlasil a od té chvíle čekal na vhodnou příležitost, kdy by Ježíš mohl být nenápadně, bez mnoha svědků, zatčen. ");
INSERT INTO ceslb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Židé se o Velikonocích scházeli k večeři, při níž jedli nekvašený chléb a předepsaným způsobem připraveného beránka. ");
INSERT INTO ceslb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Proto Ježíš uložil Petrovi a Janovi, aby tuto večeři uchystali pro něj a ostatní učedníky. ");
INSERT INTO ceslb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Zeptali se: „Kde chceš, abychom ji udělali?“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Odpověděl: „Když přijdete do města, potkáte muže, který ponese džbán vody. Jděte za ním do domu, kam vejde. Majiteli domu řekněte: ");
INSERT INTO ceslb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","‚Mistr tě žádá abys nám ukázal místnost, ve které by se mohl se svými učedníky sejít k velikonoční večeři.‘ ");
INSERT INTO ceslb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Zavede vás do velké jídelny v horním patře. Tam všechno nachystejte.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Odešli a našli všechno přesně tak, jak jim Ježíš řekl, a připravili velikonočního beránka. ");
INSERT INTO ceslb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ve stanovenou hodinu zaujal Ježíš se svými dvanácti apoštoly místo u stolu. ");
INSERT INTO ceslb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Řekl jim: „Velice jsem si přál ještě jíst s vámi beránka, dříve než budu trpět. ");
INSERT INTO ceslb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Je to naposledy, co ho takto jíme. Záhy se totiž stane to, co vám Bůh oběťmi velikonočního beránka naznačoval.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Když jim po modlitbě podával kalich s vínem, ");
INSERT INTO ceslb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","řekl, že už ho s nimi nebude pít, dokud se nesejdou k hostině v nebi. ");
INSERT INTO ceslb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pak vzal chléb, poděkoval Bohu, rozlámal ho a podával svým učedníkům se slovy: „To je moje tělo, které se za vás obětuje. Tímto způsobem si mne vždycky znovu připomínejte.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Po večeři jim podal opět víno a řekl: „Tento kalich je znamením nové smlouvy Boha s člověkem, zpečetěné krví, kterou za vás proliji. ");
INSERT INTO ceslb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Zde u stolu sedí člověk, který se tváří jako přítel, ale je odhodlán mne zradit. ");
INSERT INTO ceslb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Vím, že musím zemřít, ale běda zrádci.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Po těchto slovech se začali mezi sebou dohadovat, kdo z nich by byl schopen něčeho takového. ");
INSERT INTO ceslb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nakonec mezi nimi vznikl spor, kdo z nich je přednější. ");
INSERT INTO ceslb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ježíš jim řekl: „Vládci panují nad svými poddanými a dávají si říkat dobrodinci. ");
INSERT INTO ceslb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","U vás ať je tomu naopak. Nechtějte panovat, ale sloužit. Kdo je mezi vámi nejvyšší, ať jedná, jako by byl nejnižší, kdo je vůdčí osobností, ať slouží druhým. ");
INSERT INTO ceslb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kdo je přednější? Ten, kdo sedí za stolem a dá se obsluhovat, nebo ten, kdo obsluhuje? Obecně platí, že ten, kdo se dá obsluhovat. Vidíte, a já jsem mezi vámi jako ten, kdo slouží. ");
INSERT INTO ceslb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Až dosud jste mi v mých zkouškách stáli věrně po boku. ");
INSERT INTO ceslb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Můj Otec mi dal království a já vám uděluji právo, ");
INSERT INTO ceslb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","abyste v tom království jedli a pili u mého stolu. Však také usednete na soudné stolice a budete soudit dvanáct izraelských rodů.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pak oslovil Šimona Petra: „Satan si vyžádal, aby vás mohl prosívat jako obilí, ");
INSERT INTO ceslb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ale já jsem se za tebe přimlouval, aby tvoje víra vydržela. A až se pak obrátíš, utvrzuj ve víře své bratry.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Šimon odpověděl: „Pane, s tebou jsem odhodlán jít do vězení i na smrt.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ježíš mu řekl: „Říkám ti, Petře, že dříve než dnes zakokrhá první kohout, třikrát popřeš, žes mne znal.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pak jim ještě řekl: „Posílal jsem vás za lidmi bez peněz, bez zásob a bosé. Můžete říci, že jste měli v něčem nedostatek?“ Oni odpověděli: „Ne, ani v nejmenším.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ježíš pokračoval. „Teď se situace mění, přijde pro vás těžká doba. Dobře se na ni vybavte a vyzbrojte. ");
INSERT INTO ceslb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Brzy budu souzen jako zločinec, jak to bylo předpověděno. Prorocká slova o mně se plní.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Řekli: „Pane, máme tu dva meče.“ Ježíš odpověděl: „To stačí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pak se jako obvykle vydal na Olivovu horu a jeho učedníci ho provázeli. ");
INSERT INTO ceslb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Když došli na místo, řekl jim: „Modlete se, abyste obstáli v těžkých zkouškách, které vás čekají.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sám se pak vzdálil, co by kamenem dohodil, poklekl a modlil se: ");
INSERT INTO ceslb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","„Otče, kdybys mne mohl ušetřit tohoto kalicha utrpení, ale ať se vyplní tvoje vůle, ne moje.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tu při něm stál anděl a dodával mu sílu. ");
INSERT INTO ceslb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ježíš se modlil v smrtelné úzkosti. Pot jako krvavé kapky mu stékal na zem. ");
INSERT INTO ceslb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Když skončil modlitbu, šel ke svým učedníkům a shledal, že pod tíhou událostí usnuli. ");
INSERT INTO ceslb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Probudil je: „Jak můžete spát? Vstaňte a modlete se, abyste obstáli ve zkouškách, které jsou před vámi.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ještě to ani nedořekl a objevil se houf lidí s Jidášem v čele. Ten přistoupil k Ježíšovi, aby ho políbil. ");
INSERT INTO ceslb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ježíš mu řekl: „Jidáši, polibkem mne zrazuješ?“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Když ostatní učedníci pochopili, co se děje, volali: „Pane, máme tě bránit?“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A jeden z nich skutečně vytasil meč a uťal pravé ucho jednomu muži z chrámové stráže. ");
INSERT INTO ceslb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ježíš však řekl: „Dost! Nechte toho!“ Dotkl se ucha zraněného a uzdravil ho. ");
INSERT INTO ceslb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pak Ježíš oslovil stráž, jejich velitele a kněze, kteří je vedli: „Přišli jste si pro mne s meči a klacky jako pro lotra. ");
INSERT INTO ceslb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A přitom jsem s vámi denně býval v chrámu a ruku jste na mne nevztáhli. Ale já vím, přišla vaše chvíle a tma teď nabývá vrchu.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tu se ho zmocnili a odvedli do veleknězova paláce. Petr je zpovzdálí sledoval. ");
INSERT INTO ceslb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vojáci rozdělali uprostřed nádvoří oheň a sesedli se okolo. Petr se přišel mezi ně také ohřát. ");
INSERT INTO ceslb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jak mu plamen osvěcoval tvář, všimla si ho jedna služka, prohlédla si ho a řekla: „Podívejte se, ten s ním také chodil.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petr se bránil: „Ženo, vždyť já ho vůbec neznám.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Za chvíli si ho všiml někdo jiný: „Ty k nim taky patříš.“ Petr řekl: „To se mýlíte.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Asi za hodinu zase někdo jiný začal tvrdit: „Tenhle s ním určitě byl také, je to Galilejec.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petr to popřel: „Člověče, vůbec nevím, o čem mluvíš.“ Než to dořekl, zakokrhal kohout. ");
INSERT INTO ceslb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A tu se Ježíš otočil a podíval se na Petra a ten si vzpomněl, že mu Pán řekl: „Dříve než kohout zakokrhá, třikrát mne zapřeš.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Vyběhl z nádvoří a venku se hořce rozplakal. ");
INSERT INTO ceslb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Stráž se začala Ježíšovi vysmívat. ");
INSERT INTO ceslb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Zavázali mu oči, bili ho do tváře a říkali: „Jsi přece prorok, tak hádej, kdo tě uhodil.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A předháněli se v tom, kdo ho víc poníží. ");
INSERT INTO ceslb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Když se rozednilo, sešla se nejvyšší rada, kterou tvořili představitelé lidu, velekněží a učitelé zákona. Dali si Ježíše předvést a naléhali na něho: „Jsi Mesiáš? Řekni nám to!“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","On odpověděl: „I kdybych vám to řekl, stejně tomu neuvěříte. ");
INSERT INTO ceslb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A kdybych se já vás na něco zeptal, neodpovíte mi. ");
INSERT INTO ceslb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Řeknu vám jenom to: Již záhy usedne Syn člověka po Boží pravici.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Všichni začali volat: „Ty jsi tedy Boží Syn?“ Ježíš odpověděl: „Vaše vlastní slova to potvrzují.“ ");
INSERT INTO ceslb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tu křičeli jeden přes druhého: „To nám stačí, už žádné další svědectví nepotřebujeme, usvědčil se sám!“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Celé shromáždění velerady povstalo a odvedli Ježíše k římskému místodržiteli Pilátovi. ");
INSERT INTO ceslb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tam ho začali obviňovat: „Tento člověk rozvrací náš národ, nabádá, aby se neplatily daně císaři, a sám se vydává za krále poslaného od Boha.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilát se Ježíše zeptal: „Ty jsi židovský král?“ Ježíš řekl: „Chceš-li mne tak nazvat…“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilát namítl žalobcům: „Nezdá se mi, že by se ten člověk provinil něčím závažným.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ale oni naléhali: „Jeho učení působí nepokoje v celém Judsku. Nejdříve to začalo v Galileji, ale už je toho i tady plno.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Když to Pilát uslyšel, zeptal se, zda je Ježíš Galilejec. ");
INSERT INTO ceslb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Přisvědčili; Pilát se toho chopil a poslal Ježíše k Herodovi, vládci Galileje, který byl právě o svátcích v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes tím byl nadšen, protože si už dávno přál Ježíše vidět. Mnoho o něm slyšel a doufal, že mu Ježíš předvede nějaký zázrak. ");
INSERT INTO ceslb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kladl mu řadu otázek, ale Ježíš na ně neodpovídal. ");
INSERT INTO ceslb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Zato přítomní kněží a zákoníci se předháněli v obviňování. ");
INSERT INTO ceslb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes se od Ježíše pohrdavě odvrátil. Domluvil se se svými dvořany, že Ježíše zesměšní: dal ho obléci do bílého korunovačního roucha a tak ho poslal zpět k Pilátovi. ");
INSERT INTO ceslb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tehdy se Herodes a Pilát spřátelili, ačkoliv předtím si nemohli přijít na jméno. ");
INSERT INTO ceslb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilát svolal přední kněze, členy velerady i lid ");
INSERT INTO ceslb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a řekl jim: „Přivedli jste mi tohoto člověka s obviněním, že pobuřuje lid proti Římu. Byli jste při tom, když jsem ho vyslýchal, a musíte mi dát za pravdu, že jsem ho neusvědčil ze žádného zločinu. ");
INSERT INTO ceslb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Stejně jste dopadli se svou žalobou u Heroda, jinak by mi ho neposlal zpět. Nespáchal žádný hrdelní zločin, ");
INSERT INTO ceslb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","a tak, abyste neřekli, dám ho zbičovat a pak ho propustím. ");
INSERT INTO ceslb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vždyť víte, že každý rok o Velikonocích uděluji milost jednomu vězni. Tentokrát propustím Ježíše.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ale dav křičel: „Pryč s ním, propusť Barabáše!“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabáš byl odsouzen k smrti pro pokus o povstání a pro vraždu. ");
INSERT INTO ceslb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilát se znovu pokusil přesvědčit dav o Ježíšově nevině, aby ho mohl propustit. ");
INSERT INTO ceslb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ale lidé ho přehlušili: „Ukřižovat, ukřižovat!“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Zkusil to ještě do třetice: „Ale čím se provinil? Nedokázal jsem mu přece nic, za co je podle zákona trest smrti. Dám ho zbičovat a propustím ho.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Volání davu, aby byl Ježíš ukřižován, se však stále stupňovalo, ");
INSERT INTO ceslb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","a tak jim Pilát nakonec vyhověl. ");
INSERT INTO ceslb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Propustil Barabáše a Ježíše poslal na popravu, jak žádali. ");
INSERT INTO ceslb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Když vojáci Ježíše odváděli, přinutili cestou jednoho muže, aby nesl Ježíšův kříž. Byl to Šimon z Kyrény, který právě přicházel z pole. ");
INSERT INTO ceslb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Odsouzeného sledoval zástup lidí a mnohé ženy nad ním plakaly a naříkaly. ");
INSERT INTO ceslb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ježíš se k nim otočil a řekl: „Ženy, nade mnou neplačte, ale nad sebou a svými dětmi. ");
INSERT INTO ceslb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Jednou budete litovat, že jste do tohoto světa přivedly děti. ");
INSERT INTO ceslb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lidé budou prosit hory, aby se na ně sesuly a pohřbily je. ");
INSERT INTO ceslb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jestliže se takto nakládá se zeleným stromem, jak to může dopadnout se suchým? Když jdu na smrt já, co můžete čekat vy?“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Spolu s Ježíšem byli vedeni na popraviště ještě dva zločinci. ");
INSERT INTO ceslb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Když je dovedli na místo, kterému se říká Golgota – Lebka, ukřižovali tam Ježíše i ty dva zločince; jednoho po Ježíšově pravici, druhého po levici. ");
INSERT INTO ceslb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ježíš se modlil za své nepřátele: „Otče, odpusť jim, vždyť nevědí, co dělají!“ Vojáci losovali o jeho šaty. ");
INSERT INTO ceslb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kolem stál a přihlížel dav. Ozval se i posměch, který podněcovali přítomní členové nejvyšší rady: „Pomáhal jiným, ať pomůže teď sobě. Mesiáš poslaný od Boha by to dokázal!“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Také vojáci se přidali k posměchu. Nabízeli mu svoje kyselé víno a říkali: ");
INSERT INTO ceslb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","„Jsi-li skutečně židovský král, zachraň se sám!“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nad jeho hlavou byl upevněn nápis v řečtině, latině a hebrejštině: „Král Židů.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Také jeden z ukřižovaných zločinců se Ježíšovi posmíval: „Co jsi za Mesiáše, když nepomůžeš sobě ani nám!“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ale ten druhý ho okřikl. „Ani ve chvíli smrti se nebojíš Boha? ");
INSERT INTO ceslb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","My si to všechno zasloužíme, ale tenhle člověk určitě nespáchal nic špatného a trpí nevinně.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pak se obrátil k Ježíšovi a řekl: „Pane, vzpomeň si na mne, až přijdeš do svého království.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ježíš mu odpověděl: „Slibuji ti, dnes budeš se mnou v ráji.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kolem poledne se najednou setmělo a tma trvala do tří hodin. ");
INSERT INTO ceslb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Chrámová opona, která oddělovala svatyni od nejsvatějšího místa, se v tu chvíli roztrhla od shora až dolů. ");
INSERT INTO ceslb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ježíš hlasitě zvolal: „Otče, odevzdávám svého ducha do tvých rukou!“ A s těmi slovy na rtech zemřel. ");
INSERT INTO ceslb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Když důstojník velící popravě viděl, co se stalo, vzdal čest Bohu a řekl: „Je jasné, že tenhle člověk byl nevinný.“ ");
INSERT INTO ceslb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Také v přihlížejícím davu se probudilo svědomí a lidé odcházeli otřesení. ");
INSERT INTO ceslb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nakonec tam zůstali v povzdálí jen Ježíšovi přátelé a ženy, které ho doprovázely z Galileje a všechno to viděly. ");
INSERT INTO ceslb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jeden z členů velerady, Josef z Arimatie, čestný a ušlechtilý člověk, ");
INSERT INTO ceslb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","nesouhlasil s postupem a rozsudkem ostatních. Patřil k těm, kdo uvěřili zvěsti o Božím království. ");
INSERT INTO ceslb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ten teď navštívil Piláta a vyžádal si tělo mrtvého Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sňal je z kříže, zavinul do plátna a uložil do hrobky vytesané ve skále, kde ještě nikdo nebyl pochován. ");
INSERT INTO ceslb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","To bylo v pátek večer, právě před začátkem soboty. ");
INSERT INTO ceslb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ženy, které provázely Ježíše z Galileje, se připojily k pohřbu. Viděly hrobku i způsob, jakým bylo tělo uloženo. ");
INSERT INTO ceslb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chtěly je ještě potřít vonnými oleji a mastmi, ale musely to odložit, aby neporušily zákon o sobotě. ");
INSERT INTO ceslb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","V neděli brzy ráno se ženy vydaly ke hrobu a nesly s sebou vonné masti a oleje. ");
INSERT INTO ceslb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kámen, který zakrýval vchod do hrobu ve skále, byl však odvalen stranou. ");
INSERT INTO ceslb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ženy vešly dovnitř, ale tělo Pána Ježíše tam nenašly. ");
INSERT INTO ceslb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bezradně se rozhlížely a vtom u nich stáli dva muži v oslnivě bílých oděvech. ");
INSERT INTO ceslb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ženy se jich velice lekly a sklopily oči. Oni jim řekli: „Proč hledáte živého tam, kde jsou jen mrtví? ");
INSERT INTO ceslb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ježíš tady není, je živ! Vzpomeňte si, jak vám ještě v Galileji říkal, ");
INSERT INTO ceslb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","že bude jako Syn člověka vydán do rukou zlých lidí, ukřižován, ale třetí den vstane z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ženy si na to skutečně vzpomněly. ");
INSERT INTO ceslb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Vrátily se od hrobu a všechno vyprávěly jedenácti apoštolům a všem ostatním Ježíšovým žákům, které našly. ");
INSERT INTO ceslb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Svědkyně vzkříšení byly: Marie z Magdaly, Jana, Marie Jakubova a ještě další. ");
INSERT INTO ceslb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Učedníci jim však nevěřili a považovali jejich zprávu za výplod fantazie. ");
INSERT INTO ceslb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petr se však přece jen rozběhl ke hrobu, nahlédl dovnitř a uviděl jen odložená plátna. Vrátil se a nemohl pochopit, co se stalo. ");
INSERT INTO ceslb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jiní dva Ježíšovi učedníci šli toho dne do městečka Emauzy, nedaleko Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Cestou spolu hovořili o událostech posledních dnů. ");
INSERT INTO ceslb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Byli zabráni do rozhovoru, takže skoro ani nezpozorovali, že se k nim někdo přidal; byl to Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ale oni, jako by měli mlhu před očima, nepoznali ho, ");
INSERT INTO ceslb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ani když se s nimi dal do řeči: „O čem to mluvíte, že jste tak smutní?“ Zastavili se ");
INSERT INTO ceslb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","a jeden z nich, Kleofáš, mu řekl: „Jdeš z Jeruzaléma a nevíš, co se tam teď o svátcích stalo?“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ježíš chtěl, aby mu to vyprávěli, a tak pokračovali: „Cožpak jsi nic neslyšel o Ježíši z Nazaretu? O tom prorokovi, který tak mocně kázal a dělal zázraky? Bůh stál při něm a lidé ho měli v úctě. ");
INSERT INTO ceslb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","A toho muže velerada odsoudila k smrti a byl ukřižován! ");
INSERT INTO ceslb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","My jsme doufali, že on je ten očekávaný Mesiáš a že vysvobodí Izrael. Stalo se to předevčírem. ");
INSERT INTO ceslb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dnes nás některé ženy překvapily zprávou: byly časně ráno u hrobu ");
INSERT INTO ceslb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","a nenašly jeho tělo. Dokonce prý viděly anděly, kteří jim řekli, že Ježíš žije. ");
INSERT INTO ceslb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Někteří z našich si ověřili, že hrob je prázdný, ale jeho neviděli. A tak nevíme, co si o tom všem máme myslet.“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ježíš jim na to řekl: „Proč jste tak nechápaví a proč váháte uvěřit tomu, co předpovídali už dávní proroci? ");
INSERT INTO ceslb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mesiáš to musí přece všechno vytrpět, než nastolí své království.“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A začal jim vykládat všechna slova, která o něm byla napsána od Mojžíše až po proroky. ");
INSERT INTO ceslb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Když došli do Emauz, cíle jejich cesty, Ježíš jako by chtěl jít dál. ");
INSERT INTO ceslb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Oni ho však přemlouvali: „Zůstaň s námi, vždyť je již pozdě a stmívá se. Kam bys šel?“ Dal se tedy pozvat a vešel s nimi do domu. ");
INSERT INTO ceslb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Když zasedli k večeři, vzal Ježíš do rukou chléb, poděkoval Bohu, rozlomil ho a podával jim. ");
INSERT INTO ceslb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","A v tu chvíli konečně prohlédli a poznali ho. Ale v tom okamžiku jim Ježíš zmizel. ");
INSERT INTO ceslb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Říkali si vzrušeně: „A proto nám bylo tak dobře u srdce, když s námi na cestě mluvil a vykládal nám smysl proroctví.“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Už nehleděli na to, že je večer a hned se vydali zpátky do Jeruzaléma. Našli jedenáct učedníků pohromadě s ostatními. ");
INSERT INTO ceslb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Apoštolové jim řekli: „Pán opravdu vstal z mrtvých! Ukázal se Petrovi!“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A oni zase vypravovali, co se jim přihodilo na cestě a jak poznali Ježíše podle způsobu lámání chleba. ");
INSERT INTO ceslb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ještě neskončili svoje vyprávění a tu sám Ježíš stál mezi nimi a pozdravil je: „Pokoj vám!“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Velice se lekli; domnívali se, že se jim zjevil nějaký duch. ");
INSERT INTO ceslb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Avšak on je pokáral: „Co se lekáte a proč si vymýšlíte takové věci? ");
INSERT INTO ceslb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Podívejte se na moje ruce a nohy, jsem to opravdu já. Můžete si na mne sáhnout, nejsem duch, ten nemá tělo z masa a kostí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Při těch slovech jim ukázal rány po hřebech na rukou i na nohou. ");
INSERT INTO ceslb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jeho žáci tomu stále nemohli uvěřit, připadalo jim to příliš krásné, než aby to mohla být pravda. Požádal je tedy: „Máte tu něco k jídlu?“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Podali mu pečenou rybu a plástev medu ");
INSERT INTO ceslb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a on to s nimi snědl. ");
INSERT INTO ceslb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pak jim řekl: „Vzpomeňte si! Když jsem býval s vámi, často jsem vám připomínal, že se musí naplnit všechno, co je o mně předpověděno u Mojžíše, Proroků a v Žalmech.“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A tak je dovedl k tomu, že konečně porozuměli slovům Bible, která o něm hovořila. ");
INSERT INTO ceslb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pak pokračoval: „To všechno ukazovalo k tomu, že předpověděný Mesiáš musí mnoho vytrpět, zemřít a třetího dne vstát z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A nyní se lidé všech národů musí dovědět, že on má právo odpouštět hříchy a moc změnit jejich život. Začne se to rozhlašovat nejprve v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Vy budete dosvědčovat všechno, co se událo a čeho jste byli svědky. ");
INSERT INTO ceslb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A já vám pošlu Ducha svatého, kterého vám slíbil můj Otec. Čekejte v Jeruzalémě, pokud vás Bůh nevybaví touto mocí.“ ");
INSERT INTO ceslb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pak je vedl známou cestou z Jeruzaléma do Betanie. Zastavili se a Ježíš zvedl ruce, aby učedníkům požehnal. ");
INSERT INTO ceslb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Když jim žehnal, vzdaloval se vzhůru, až jim zmizel v oblacích. ");
INSERT INTO ceslb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Uctivě se mu poklonili a pak se radostně vrátili do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dobu čekání trávili v chrámu, kde chválili Boha.");
INSERT INTO ceslb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","3","Kristus existoval od věčnosti, byl stále s Bohem Otcem a byl to Bůh sám. On byl tvořícím Božím Slovem, kterým vše vzniklo a trvá. ");
INSERT INTO ceslb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Je zdrojem všeho života a pro lidi světlem na cestě k Bohu. ");
INSERT INTO ceslb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","To světlo přemáhá temnotu světa, ale ta ho nikdy nepřekoná. ");
INSERT INTO ceslb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bůh pověřil muže, který se jmenoval Jan (zvaný Křtitel), ");
INSERT INTO ceslb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","aby svědčil o Ježíši a vedl lidi k víře, že Ježíš je tím světlem. ");
INSERT INTO ceslb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jan nikdy ani nenaznačil, že by jím byl on sám. ");
INSERT INTO ceslb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ježíš je to pravé světlo, které září vstříc každému člověku. ");
INSERT INTO ceslb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","11","Přišel na zem, kterou stvořil a k lidem, které miloval, ale oni ho nepřijali. ");
INSERT INTO ceslb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Těm však, kteří ho přece přijali a uvěřili v něho, otevřel přístup do Boží rodiny. ");
INSERT INTO ceslb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nestali se jejími členy rodem ani lidským úsilím, ale Božím působením. ");
INSERT INTO ceslb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A věčné Slovo se stalo člověkem, který žil mezi námi. Viděli jsme jeho vznešenost, vznešenost vlastní jedinému Božímu Synu. Poznali jsme jej plného lásky a pravdy. ");
INSERT INTO ceslb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Také Jan Křtitel o něm vydával jasné svědectví: „To je ten, který jde sice za mnou, ale je mnohem významnější a byl dávno přede mnou.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Z jeho bohatství jsme přijímali dar za darem. ");
INSERT INTO ceslb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mojžíšovým prostřednictvím nám Bůh sdělil požadavky svého zákona, ale v Ježíši Kristu jsme se setkali s Božím milosrdenstvím a pravdou. ");
INSERT INTO ceslb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Boha nikdo z lidí neviděl; jenom ten, který má k němu blízko jako jediný Syn k Otci, nám o něm sdělil pravdu. ");
INSERT INTO ceslb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Z Jeruzaléma přišla za Janem Křtitelem delegace židovských kněží s otázkou, zda je očekávaný Mesiáš – Boží Syn, izraelský král. ");
INSERT INTO ceslb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","21","„Ne, nejsem Mesiáš,“ řekl jim Jan otevřeně. „Kdo tedy jsi?“ zeptali se ho znovu. „Jsi prorok Elijáš?“ „Nejsem.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","„Tak řekni, kdo jsi. Musíme o tobě podat zprávu těm, kteří nás poslali. Jsi tedy jiný Mesiášův předchůdce?“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","„Nedávejte mi žádný titul. Jsem hlas, který na poušti volá: Upravte cestu pro Pána. Tak to předpověděl prorok Izajáš.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Protože Janovu odpověď nepochopili, ptali se dál: „Když tedy nejsi Mesiáš, ani jeho předchůdce, proč křtíš?“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Jan odpověděl: „Divíte se, že křtím. Ale co budete říkat tomu muži, který přichází za mnou? Ještě ho neznáte, ale je už mezi vámi. Jemu nejsem hoden ani obuv rozvázat.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","To se stalo v Betanii u Jordánu, kde Jan křtil. ");
INSERT INTO ceslb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Druhého dne spatřil Jan Ježíše, jak k němu přichází. Ukázal na něho a řekl: „Beránek Boží, který bere na sebe hříchy celého světa. ");
INSERT INTO ceslb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","To o něm jsem vám včera řekl, že za mnou jde mnohem významnější muž, který byl dávno přede mnou. ");
INSERT INTO ceslb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Když jsem byl pověřen, abych křtil a připravoval izraelský lid na příchod Mesiáše, ještě jsem nevěděl, kdo to je. ");
INSERT INTO ceslb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Bůh mi však řekl: ‚Dávej pozor, na koho při křtu sestoupí můj Duch a zůstane na něm. To je ten, kdo bude křtít Duchem svatým.‘ Pak jsem viděl, jak se Boží Duch v podobě holubice snáší z nebe na Ježíše. Do té chvíle jsem ho neznal, ale protože se to na něm vyplnilo, vydávám svědectví, že je Boží Syn.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Příštího dne, asi ve čtyři hodiny odpoledne, stál Jan se dvěma svými učedníky. ");
INSERT INTO ceslb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Opět spatřil Ježíše, jak jde okolo a zvolal: „Podívejte se, to je Boží Beránek!“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Když to Janovi učedníci uslyšeli, vydali se za Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ten se po chvíli ohlédl a viděl, že ho oba následují. Zeptal se jich: „Přejete si něco?“ „Mistře,“ odpověděli, „kde bydlíš?“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","„Pojďte se mnou!“ řekl Ježíš. Přijali to pozvání a zůstali ten den u něho. ");
INSERT INTO ceslb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jeden z těch učedníků se jmenoval Ondřej a měl bratra Šimona. ");
INSERT INTO ceslb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Po návštěvě u Ježíše vyhledal Ondřej svého bratra a řekl mu: „Nalezli jsme Mesiáše – Krista.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pak ho přivedl k Ježíšovi. Ten se na něj zahleděl a řekl: „Ty jsi Šimon, Janův syn. Ode dneška se však budeš jmenovat Petr.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Příštího dne se Ježíš rozhodl, že půjde do Galileje. Setkal se s Filipem a vyzval ho, aby ho následoval. ");
INSERT INTO ceslb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Stejně jako Ondřej a Petr pocházel i Filip z Betsaidy. ");
INSERT INTO ceslb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip pak vyhledal Natanaela a řekl mu: „Nalezli jsme toho, o kterém hovořil Mojžíš a kterého předpověděli proroci. Jmenuje se Ježíš a je to syn Josefa z Nazaretu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","„Může být z Nazaretu něco dobrého?“ zapochyboval Natanael. „Pojď a přesvědč se sám!“ řekl Filip. ");
INSERT INTO ceslb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Když Ježíš spatřil Natanaela, řekl: „To je pravý a bezelstný Izraelec.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","„Odkud mne znáš?“ zeptal se ho překvapeně Natanael. „Viděl jsem tě pod fíkovým stromem dříve, než tě našel Filip,“ odpověděl Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael s údivem zvolal: „Mistře, ty jsi Boží Syn a izraelský král.“ ");
INSERT INTO ceslb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ježíš mu na to řekl: „Ty mi věříš proto, že jsem ti pověděl, jak jsem tě viděl pod fíkovníkem. ");
INSERT INTO ceslb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Uvidíš větší věci a uvěříš, že jsem v neustálém spojení s nebem.“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","V galilejské vesnici Káně se za tři dny konala svatba a byla tam Ježíšova matka Marie. ");
INSERT INTO ceslb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mezi svatebními hosty byl Ježíš a jeho učedníci. ");
INSERT INTO ceslb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Docházelo jim víno a Marie o tom řekla Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","„Proč mi to říkáš?“ odpověděl Ježíš. „Moje chvíle ještě nepřišla.“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Marie vyzvala obsluhující: „Udělejte všechno, co vám můj syn přikáže.“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na chodbě stálo šest kamenných – asi hektolitrových – nádob, kterých se používalo k obřadnímu umývání. ");
INSERT INTO ceslb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ježíš poručil sloužícím, aby je naplnili vodou. ");
INSERT INTO ceslb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Když to udělali, vyzval je: „Dejte z toho ochutnat správci hostiny.“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nic netušící správce ochutnal vodu, kterou Ježíš proměnil ve víno, zavolal ženicha ");
INSERT INTO ceslb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a řekl mu: „To víno je vynikající. Obvykle se začíná lepším a končí horším. Ale tobě vydrželo dobré víno až do konce.“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Zázrakem v Káni Ježíš poprvé projevil svou božskou moc. A jeho učedníci v něho uvěřili. ");
INSERT INTO ceslb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Potom Ježíš se svou matkou, bratry a učedníky strávil několik dní v Kafarnaum. ");
INSERT INTO ceslb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Blížily se židovské velikonoční svátky, a tak se Ježíš vydal na cestu do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na nádvoří Jeruzalémského chrámu našel směnárníky peněz, prodavače obětních býčků, ovcí a holubů. ");
INSERT INTO ceslb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Upletl si z provázků důtky a z chrámového nádvoří prodavače i s dobytkem vyhnal. Směnárníkům zpřevracel stoly a rozházel peníze. ");
INSERT INTO ceslb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","„Pryč s tím odtud. Nedělejte z domu mého Otce tržiště!“ volal za nimi. ");
INSERT INTO ceslb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","V té chvíli si učedníci vzpomněli na starozákonní proroctví: „Stravuje mne horlivost pro Boží dům.“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Židé se ho hněvivě ptali: „Jak si můžeš dovolit takto jednat? Máš-li pověření od Boha, dokaž je nějakým zázrakem!“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","„Dobře,“ odpověděl Ježíš, „zbořte tento chrám, a já ho ve třech dnech znovu postavím.“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","„Co je to za nesmysl?“ posmívali se mu Židé. „Vždyť chrám stavěli plných čtyřicet šest let, a ty bys ho chtěl vystavět ve třech dnech?“ ");
INSERT INTO ceslb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Židé Ježíšova slova nepochopili. Nemluvil totiž o chrámu, ale o svém těle. ");
INSERT INTO ceslb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","I učedníci tomu porozuměli až po jeho zmrtvýchvstání. ");
INSERT INTO ceslb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Během Velikonoc vykonal Ježíš v Jeruzalémě řadu zázraků, a tak v něj mnozí uvěřili. ");
INSERT INTO ceslb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Věděl o každém všechno, nepotřeboval se na nikoho vyptávat. Sám však zůstával pro mnohé hádankou. ");
INSERT INTO ceslb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jedním z předních Židů byl Nikodém, člen nejvyšší židovské rady. Patřil do skupiny farizejů, kteří přísně dodržovali všechny náboženské předpisy. ");
INSERT INTO ceslb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ten jedné noci vyhledal Ježíše a řekl mu: „Mistře, víme, že jsi učitel poslaný od Boha. Kdyby za tebou nestál sám Bůh, nemohl bys dělat takové zázraky, jaké jsi nám ukázal.“ ");
INSERT INTO ceslb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ježíš mu řekl: „Víš, na čem záleží? Na tom, aby se člověk znovu narodil, protože jinak se nestane občanem Božího království.“ ");
INSERT INTO ceslb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","„Znovu se narodit v mém věku?“ podivil se Nikodém. „Cožpak se někdo může vrátit do matčina těla a narodit se podruhé?“ ");
INSERT INTO ceslb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ježíš vysvětloval: „Jestliže se s člověkem nestane zásadní proměna a není na něm patrný nový život z Ducha a jestliže není na znamení toho pokřtěn, nemůže vstoupit do Božího království. ");
INSERT INTO ceslb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Život zrozený z člověka je tělesný. Teprve Boží Duch v člověku probouzí duchovní život. ");
INSERT INTO ceslb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nediv se mým slovům, že se musíte znovu narodit. ");
INSERT INTO ceslb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ovšem s Duchem svatým je to jako s větrem: Nemůžeš ho ovládat, ale pozoruješ jeho účinky. Tak se člověk znovu narodí z Ducha.“ ");
INSERT INTO ceslb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodém se zeptal: „Jak toho všeho dosáhnu?“ ");
INSERT INTO ceslb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","„Jsi učitelem Božího národa a toto nevíš?“ podivil se Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","„Věř mi, že mluvím o tom, co vím, a svědčím o tom, co jsem viděl. Vy ovšem moje slova neberete vážně. ");
INSERT INTO ceslb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Když nechápete to, co se týká člověka, jak porozumíte tomu, co se týká Boha? ");
INSERT INTO ceslb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nikdo z lidí vám nemůže podat svědectví jako já, vždyť jsem přišel od Boha. ");
INSERT INTO ceslb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Vzpomínáš si, co Izraelcům zachránilo život na poušti, kde je ohrožovali jedovatí hadi? Jak Mojžíš vyzvedl na sloup bronzového hada, a kdo na něj pohlédl s vírou, zachránil si život? Tak i já musím být vyzdvižen na kříž. ");
INSERT INTO ceslb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Každý, kdo ve mne uvěří, ujde smrti a narodí se pro věčnost. ");
INSERT INTO ceslb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Vždyť Bůh tak miloval svět, že dal svého jediného Syna, aby každý, kdo v něho uvěří, unikl záhubě a získal věčný život. ");
INSERT INTO ceslb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bůh svého Syna neposlal proto, aby svět odsoudil, ale zachránil. ");
INSERT INTO ceslb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kdo v něho věří, unikne odsouzení. Kdo však v něho nevěří, odsuzuje sám sebe, protože odmítá milost nabízenou samým Bohem. ");
INSERT INTO ceslb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pro takové lidi je osudné, že na svět přišlo světlo, ale oni se nechtějí vzdát tmy, protože doufají, že ta zakryje jejich viny. ");
INSERT INTO ceslb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Zlé činy dělá člověk potmě, aby to nikdo nevěděl. Bojí se světla, aby nebyl odhalen. ");
INSERT INTO ceslb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kdo se však řídí Boží pravdou, tíhne ke světlu, aby věděl, zda jsou jeho činy v souladu s Boží vůlí.“ ");
INSERT INTO ceslb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Potom Ježíš odešel se svými učedníky na judský venkov, aby tam s nimi mohl v klidu pobývat a aby křtil. ");
INSERT INTO ceslb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Také Jan Křtitel, který byl v té době ještě na svobodě, křtil v Ainonu nedaleko Salimu, kde bylo mnoho vody. Četní lidé se tam dali od Jana pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Někteří Židé se dohadovali s Janovými učedníky, kdo má právo křtít. ");
INSERT INTO ceslb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ti se obrátili na svého učitele: „Mistře, ten, kterého jsi označil za Mesiáše, také křtí a všichni teď chodí k němu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jan jim řekl: „Člověk sám si nemůže přisvojit žádnou duchovní moc, pokud mu není dána od Boha. ");
INSERT INTO ceslb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Vy sami jste svědky, že jsem prohlásil: ‚On je Bohem poslaný Mesiáš a já mu jen připravuji cestu.‘ ");
INSERT INTO ceslb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","30","Nevěsta přece patří ženichovi. Jeho přítel je také na svatbě, ale raduje se z ženichova štěstí. To je právě moje radost. Jeho hvězda vychází a já chci, aby jasně zářila, a nechci jí zaclánět. ");
INSERT INTO ceslb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Protože Ježíš přišel z nebe, převyšuje nás všechny. My lidé mluvíme jen o tom, co jsme prožili na zemi. ");
INSERT INTO ceslb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","On svědčí o tom, co viděl v nebi, a přece ho tak málo lidí přijímá. ");
INSERT INTO ceslb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kdo mu uvěří, dává za pravdu Bohu. Ježíš totiž mluví Boží slova z Božího pověření. ");
INSERT INTO ceslb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bůh jej k tomu také plně uschopnil svým Duchem. ");
INSERT INTO ceslb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Vždyť Otec miluje Syna a svěřuje mu všechno. ");
INSERT INTO ceslb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Proto, kdo věří Synu, má věčný život. Kdo mu nedůvěřuje, místo života ho stíhá Boží hněv.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Stále více lidí se připojovalo k Ježíšovi a jeho učedníci je křtili. ");
INSERT INTO ceslb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aby zabránil případnému střetnutí s náboženskými vůdci, opustil Ježíš Judsko a vrátil se do Galileje. ");
INSERT INTO ceslb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Šel skrze Samařsko. ");
INSERT INTO ceslb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Kolem poledne přišel k Jákobově studni u městečka Sychar. ");
INSERT INTO ceslb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jeho učedníci odešli do města nakoupit něco k jídlu. Ježíš si chtěl u studny odpočinout. Sotva usedl, jedna z místních žen přišla pro vodu. „Prosím tě, dej mi napít,“ obrátil se na ni Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","„Jak to, že žádáš službu od Samařanky, když jsi Žid?“ (Mezi Židy a Samařany vládlo totiž napětí.) ");
INSERT INTO ceslb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ježíš jí odpověděl: „Kdybys věděla, kdo jsem a co ti nabízím, prosila bys ty mne, abych ti dal napít té životodárné vody.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","„Vždyť nemáš žádnou nádobu! Jak chceš nabrat vodu z tak hluboké studny?“ namítla žena. ");
INSERT INTO ceslb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","„Jsi snad mocnější, než byl náš praotec Jákob, který ji vyhloubil? Čerpal z ní vodu pro sebe, svou rodinu i svůj dobytek.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Nato jí Ježíš odpověděl: „Voda, kterou nabízím já, uhašuje žízeň navždy a naplňuje touhu po věčnosti.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","„Pane, tu vodu mi dej ať už sem nemusím chodit,“ prosila ho žena. ");
INSERT INTO ceslb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","„Jdi a přiveď svého muže,“ přikázal jí Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","„Nemám muže,“ odpověděla žena. „To máš pravdu,“ řekl jí Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","„Vystřídala jsi jich pět a ani ten, se kterým žiješ nyní, není tvůj muž.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","„Pane, vidím, že jsi prorok,“ vyhrkla s údivem. ");
INSERT INTO ceslb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","„To bys mi mohl odpovědět, proč vy Židé považujete jen Jeruzalém za místo vhodné k uctívání Boha. Naši předkové se od nepaměti modlili na této hoře.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ježíš jí odpověděl: „Věř mi, blíží se doba, kdy lidé nebudou uctívat Boha ani v Jeruzalémě, ani na této hoře. ");
INSERT INTO ceslb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","My známe smysl naší bohoslužby, ale vy ho neznáte, protože Mesiáš vyjde ze Židů. ");
INSERT INTO ceslb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nastává však doba, kdy nebude záležet na tom, kde se kdo modlí, ale jak se modlí. Skuteční vyznavači budou ctít Otce upřímně a neformálně. O takové vyznavače Otci jde. ");
INSERT INTO ceslb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bůh je duchovní bytost a ti, kdo ho vzývají, mají tak činit opravdově a pod vedením Ducha svatého.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","„Vím, že přijde Mesiáš,“ pravila žena, „ten nám všechno vysvětlí.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","„Ten Mesiáš jsem já,“ řekl jí nato Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","V té chvíli se učedníci vrátili z města a byli překvapeni, když Ježíše zastihli v rozhovoru se ženou. Neodvážili se však zeptat, proč s ní mluví. ");
INSERT INTO ceslb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Žena nechala své vědro ležet u studny a spěchala do města, kde řekla lidem: ");
INSERT INTO ceslb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","„Pojďte se podívat na člověka, s nímž jsem se dosud nesetkala, a přesto o mně všechno ví. Není to snad Mesiáš?“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Lidé z města se tedy vydali za Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Učedníci ho zatím pobízeli, aby se najedl. ");
INSERT INTO ceslb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","On však odmítl: „Nebudu jíst. Mám jiný pokrm, který neznáte.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","„Kdo mu přinesl jídlo?“ říkali si. ");
INSERT INTO ceslb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ježíš je hned vyvedl z nejistoty: „Sytím se tím, že konám Boží vůli. Dokončit jeho dílo – to je můj pokrm. ");
INSERT INTO ceslb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Obilí bude zralé za čtyři měsíce, ale lidé jsou již zralí ke žni. ");
INSERT INTO ceslb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ten, kdo bude sklízet a shromažďovat tuto úrodu pro věčnost, dostane za svou práci odměnu. A ten, kdo rozséval, bude se radovat spolu s ním. ");
INSERT INTO ceslb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Neříká se nadarmo, že jeden zasévá a druhý žne. ");
INSERT INTO ceslb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Já vás posílám sklízet pole, které jste neosévali. Jiní se před vámi lopotili a vy sbíráte výsledky jejich práce.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na základě svědectví té ženy uvěřilo v Ježíše mnoho Samařanů ze Sychar. ");
INSERT INTO ceslb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","41","Prosili ho, aby u nich zůstal. Zdržel se tam dva dny, mluvil k nim a jejich víra rostla. ");
INSERT INTO ceslb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ženě řekli: „Teď už věříme ne pro to, co jsi o něm pověděla, ale slyšeli jsme ho a víme, že je opravdu Spasitel světa.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Po dvou dnech pokračoval Ježíš v cestě do Galileje. ");
INSERT INTO ceslb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","I když doma nebývá nikdo ve vážnosti, přijali ho Galilejští velmi srdečně. I oni byli totiž o Velikonocích v Jeruzalémě a stali se tam svědky některých jeho zázraků. ");
INSERT INTO ceslb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Když Ježíš procházel Galileou, zastavil se také v Káni, kde před nedávnem při svatbě proměnil vodu ve víno. Nedaleko odtud leželo město Kafarnaum. Zde žil jeden královský úředník, jehož syn těžce onemocněl. ");
INSERT INTO ceslb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jakmile se dověděl o Ježíšově návratu, hned ho vyhledal a prosil o pomoc. Žádal ho, aby s ním šel domů a vrátil zdraví umírajícímu synovi. ");
INSERT INTO ceslb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ježíš mu odpověděl: „Cožpak mi neuvěříte, pokud neuvidíte zázraky?“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Královský úředník úpěnlivě prosil: „Pane, pojď hned se mnou, vždyť mi doma umírá syn.“ ");
INSERT INTO ceslb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ježíš mu však jen krátce řekl: „Vrať se domů. Tvůj syn je zdráv.“ Úředník jeho slovům uvěřil a rychle spěchal domů. ");
INSERT INTO ceslb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Již cestou potkal své sluhy, kteří mu běželi naproti se zprávou o synově uzdravení. ");
INSERT INTO ceslb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ten se jich dychtivě zeptal, v kterou dobu se jeho syn uzdravil. „Včera v jednu hodinu odpoledne mu přestala horečka,“ odpověděli. ");
INSERT INTO ceslb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Radostí naplněný otec si uvědomil, že právě v tu chvíli mu Ježíš řekl: „Tvůj syn je zdráv.“ Po této události královský úředník uvěřil, že Ježíš je pravý Mesiáš. A uvěřila tomu i jeho rodina a všechno služebnictvo. ");
INSERT INTO ceslb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tak Ježíš učinil druhý zázrak v Galileji po svém návratu z Judska. ");
INSERT INTO ceslb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","O dalším židovském svátku se Ježíš zase vracel do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ve městě nedaleko Ovčí brány je rybník zvaný Bethesda. ");
INSERT INTO ceslb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Podél jeho břehů leželi pod pěti podloubími nemocní, slepí a ochrnutí. Toužebně čekali na okamžik, kdy se hladina vody zčeří. Čas od času se to stávalo a lidé věřili, že kdo první vstoupí do vřídla, bude uzdraven, ať už trpí čímkoliv. ");
INSERT INTO ceslb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mezi postiženými ležel muž nemocný už třicet osm let. ");
INSERT INTO ceslb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Když ho Ježíš uviděl a zjistil, že je už dlouho nemocen, zeptal se ho: „Chceš být zdráv?“ ");
INSERT INTO ceslb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","„Chci, Pane, ale nemohu,“ odpověděl mu ubohý muž. „Sám se špatně pohybuji a nemám nikoho, kdo by mi pomohl v pravý čas do vřídla. Ať se namáhám, jak chci, pokaždé mě někdo předběhne.“ ");
INSERT INTO ceslb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ježíš mu řekl: „Vstaň, vezmi si své lehátko a choď.“ ");
INSERT INTO ceslb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Muž se zvedl, sebral svoje věci a šel. Po nemoci nebylo ani památky. ");
INSERT INTO ceslb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Protože se to stalo v sobotu, Židé napomínali uzdraveného: „Nesluší se, abys dnes něco nosil.“ ");
INSERT INTO ceslb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","„Vím,“ odpověděl. „Ale poručil mi to člověk, který mne uzdravil.“ ");
INSERT INTO ceslb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","„A kdo to byl?“ ptali se rozhořčeně Židé. ");
INSERT INTO ceslb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","To ovšem uzdravený nevěděl, protože se mu Ježíš ztratil v davu. ");
INSERT INTO ceslb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Později se setkali v chrámu. Ježíš mu řekl: „Važ si toho, že jsi zdráv. Už nehřeš, aby tě nepotkalo něco mnohem horšího.“ ");
INSERT INTO ceslb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Muž běžel za Židy a oznámil jim, že ho uzdravil Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Židé začali na Ježíše dotírat, že ruší sobotní řád. ");
INSERT INTO ceslb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ježíš jim však řekl: „Můj Otec stále pracuje ve prospěch stvoření, proto ani já nemohu odpočívat.“ ");
INSERT INTO ceslb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ta slova Židé považovali za rouhání a rozhodli se, že Ježíše zabijí. ");
INSERT INTO ceslb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ježíš na jejich hrozby odpověděl: „Syn může opravdu dělat jen to, co vidí, že dělá jeho Otec. A činí to právě tak jako on. Vždyť ");
INSERT INTO ceslb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Otec miluje svého Syna a ukazuje mu všechno, co sám koná. Budete žasnout nad ještě většími skutky. ");
INSERT INTO ceslb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tak jako Otec má moc nad životem a smrtí, tak i Syn vzkřísí k životu ty, které bude chtít. ");
INSERT INTO ceslb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Vždyť ani Otec sám nikoho nesoudí, ale všechen soud předal Synovi, ");
INSERT INTO ceslb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aby si ho všichni vážili a ctili ho stejně jako Otce. Kdo si neváží Syna, nemá úctu ani k Otci, který ho poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ujišťuji vás, že každý, kdo přijímá moje slovo jako slovo Boha, má věčný život a unikl smrti při soudu. ");
INSERT INTO ceslb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Říkám vám podle pravdy, že začíná doba, kdy lidé uslyší hlas Božího Syna a kdo ho poslechne, bude žít, ");
INSERT INTO ceslb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","protože jako Otec je dárce života, tak i Syna pověřil, aby dával život. ");
INSERT INTO ceslb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A také jedině jemu dal právo konat soud. ");
INSERT INTO ceslb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jednou však k údivu všech budou muset všichni poslechnout jeho hlas ");
INSERT INTO ceslb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a povstat ze svých hrobů: ti, kteří uvěřili Synu, vstanou k věčnému životu, ti kteří ho za vrhli, vstanou k odsouzení. ");
INSERT INTO ceslb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Já osobně nemohu udělat nic. Má vůle je totožná s vůlí Otce. Jak mi radí, tak soudím. Proto je můj soud spravedlivý. ");
INSERT INTO ceslb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jistě by nepůsobilo věrohodně, kdybych sám dokazoval, že jsem Boží Syn. ");
INSERT INTO ceslb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Já mám někoho, kdo by pro mne svědčil. ");
INSERT INTO ceslb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Sami jste poslali k Janu Křtiteli a on vydal pravdivé svědectví. ");
INSERT INTO ceslb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nemusím však stavět na lidském svědectví, ale připomínám to pro vaši záchranu. ");
INSERT INTO ceslb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jan Křtitel zářil jako pochodeň a vy jste se radovali z jeho světla. Ale bylo to jen na čas. ");
INSERT INTO ceslb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Je tu ještě závažnější svědectví, a to jsou moje skutky. ");
INSERT INTO ceslb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Otec mi je uložil, abych je vykonal. Vydal o mně svědectví i můj Otec, který mne poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ale vy jste jeho hlas nikdy neslyšeli a nemáte o něm ani zdá ní. Jeho slovo ve vás neutkvělo a tomu, kterého poslal, nevěříte. ");
INSERT INTO ceslb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Zkoumáte Písmo a domníváte se, že jeho plněním získáte věčný život. Ale i ono svědčí o mně. ");
INSERT INTO ceslb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Vy mne odmítáte a tak zavrhujete život. ");
INSERT INTO ceslb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nechci, abyste mi děkovali nebo mne chválili, ");
INSERT INTO ceslb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","vždyť já vás dobře znám a poznal jsem, že nemáte pravý vztah k Bohu. ");
INSERT INTO ceslb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Přišel jsem k vám v Božím pověření a to vás dráždí. Kdybych přišel se svým vlastním programem, přijali byste mne s nadšením. ");
INSERT INTO ceslb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jak byste mi mohli uvěřit, když se chcete líbit lidem a ne Bohu. ");
INSERT INTO ceslb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nemyslete si, já na vás nebudu Otci žalovat. Na to stačí Mojžíšův zákon, na jehož plnění tolik spoléháte. ");
INSERT INTO ceslb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kdybyste opravdu věřili Mojžíšovi, věřili byste i mně, protože on o mně psal. ");
INSERT INTO ceslb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Když nevěříte jemu, jak byste mohli věřit mně.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ježíš se vydal na druhou stranu Galilejského jezera, jinak zvaného Tiberiadské. ");
INSERT INTO ceslb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lidé viděli, že mnohé uzdravil, a hrnuli se za ním v zástupech. ");
INSERT INTO ceslb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ježíš vystoupil na jednu horu a tam se posadil se svými učedníky. ");
INSERT INTO ceslb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bylo krátce před velikonočními svátky ");
INSERT INTO ceslb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","a Ježíš ze svého vyvýšeného místa viděl, že se mnoho poutníků připojuje k zástupu jeho posluchačů. Obrátil se na Filipa s otázkou: „Kde nakoupíme tolik chleba, aby se všichni ti lidé najedli?“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ježíš chtěl tou otázkou vyzkoušet Filipovu víru; sám již věděl, jak tu situaci vyřeší.) ");
INSERT INTO ceslb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip mu odpověděl: „Pane, i kdybychom měli chleba za deset tisíc, stále by to pro ně bylo málo, i kdyby každý jen ochutnal.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jeden z učedníků, Šimonův bratr Ondřej, Ježíše upozornil: ");
INSERT INTO ceslb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","„Je tu jeden chlapec, který má s sebou pět ječných chlebů a dvě ryby. Ale to je jako kapka do moře!“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","„Zařiďte, ať se všichni lidé posadí,“ přikázal Ježíš učedníkům. Rozsadili se tedy pohodlně po travnatém úbočí; jen mužů tam bylo asi pět tisíc. ");
INSERT INTO ceslb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ježíš vzal těch pět chlebů, poděkoval za ně Bohu, rozlamoval je a učedníci je roznášeli sedícím. Stejně tak učinil i s rybami a každý dostal, kolik chtěl. ");
INSERT INTO ceslb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Když se všichni najedli, přikázal Ježíš učedníkům: „Seberte všechny zbytky, ať nic nepřijde nazmar.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nasbírali dvanáct košů zbytků. ");
INSERT INTO ceslb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","15","Lidé si uvědomili, jak velký zázrak Ježíš udělal, a s úžasem říkali: „To je jistě ten prorok, na kterého už tak dlouho čekáme.“ A chtěli ho provolat králem, třeba proti jeho vůli. Ježíš to však poznal, a proto se vrátil sám do hor. ");
INSERT INTO ceslb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Když nastal večer, odešli učedníci dolů k jezeru. ");
INSERT INTO ceslb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tma houstla, Ježíš stále nepřicházel, a tak učedníci nasedli do člunu a plavili se do Kafarnaum. ");
INSERT INTO ceslb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Začal vát prudký vítr a jezero se vzdulo silným vlnobitím. ");
INSERT INTO ceslb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Když učedníci urazili pět šest kilometrů od břehu, uviděli Ježíše, jak k nim přichází po vodě. Protože ho hned nepoznali, zmocnil se jich strach. ");
INSERT INTO ceslb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ježíš je však uklidnil: „Nebojte se, to jsem já!“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tak ho pozvali s radostí k sobě do člunu a brzy byli u břehu. ");
INSERT INTO ceslb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Zástupy na protějším břehu čekaly na Ježíše až do rána. Věděly totiž, že učedníci odpluli do Kafarnaum bez něho na jediném člunu, který měli. ");
INSERT INTO ceslb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","K místu, kde Ježíš nasytil zástup, připlulo příštího dne několik člunů z Tiberiady. ");
INSERT INTO ceslb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","25","Když lidé poznali, že se nedočkají ani Ježíše, ani učedníků, nasedli někteří do těch lodí, přeplavili se do Kafarnaum a tam Ježíše skutečně nalezli. Ptali se ho: „Mistře, jak jsi se sem dostal?“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ježíš jim místo odpovědi řekl: „Stále ještě nechápete pravý smysl mých činů. Hledáte mne teď jen proto, že jsem vás včera nasytil. ");
INSERT INTO ceslb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Proč se staráte pořád o tak pomíjivé věci, o jídlo a pití? Usilujte o duchovní pokrm, kterým byste rostli pro věčný život. Nabízím vám ho, protože mne k tomu pověřil Bůh, můj Otec.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","„A co bychom měli dělat, abychom se Bohu líbili?“ ptali se. ");
INSERT INTO ceslb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","„Bůh od vás žádá jenom jedno,“ odpověděl. „Věřte v jeho Syna, kterého poslal!“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","„Jak nám dokážeš, že jsi Bohem poslaný Mesiáš?“ namítli někteří. „Ty jsi sice nasytil několika chleby zástup, ");
INSERT INTO ceslb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ale Mojžíš dělal pro naše předky na poušti větší zázraky. Je přece o něm psáno: ‚Sytil je manou – chlebem z nebe.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","„Ten chléb jim nedával Mojžíš, ale můj Otec,“ řekl na to Ježíš. „On vám nabízí pravý chléb a tím i život věčný.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","„Pane,“ prosili ho lidé, „dávej nám ten chléb pořád!“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","„Já jsem ten životodárný chléb. Kdo přijde ke mně, nebude už nikdy hladovět, ");
INSERT INTO ceslb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","a kdo ve mne uvěří, nebude nikdy žíznit,“ odpověděl jim Ježíš a pokračoval: „Slyšeli jste má slova, viděli jste mé činy, a přece mi nevěříte. ");
INSERT INTO ceslb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Každý, koho mi Bůh dává, přichází ke mně a já ho neodmítám. ");
INSERT INTO ceslb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Přišel jsem z nebe ne proto, abych dělal, co chci, ale abych plnil vůli nebeského Otce. ");
INSERT INTO ceslb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A ten si přeje, abych nikoho z těch, které mi svěřil, neztratil, ale vzkřísil je v den svého druhého příchodu k věčnému životu. ");
INSERT INTO ceslb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Boží vůle je, aby každý, kdo se rozhodne pro Syna a uvěří v něho, získal věčný život. Já ho vzkřísím v onen den.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Židy pobouřilo, že se přirovnal ke chlebu přicházejícímu z nebe. ");
INSERT INTO ceslb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","„Je to přece Ježíš, Josefův syn! Dobře známe jeho rodiče. A to se nám odvažuje tvrdit, že pochází z nebe?“ volali rozhořčeně. ");
INSERT INTO ceslb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","„Nevzpírejte se tomu,“ řekl Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","„Sám Bůh mne poslal k vám a vás přivádí ke mně, abyste ve mne uvěřili a já vás vzkřísil k věčnému životu. ");
INSERT INTO ceslb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Proroci přece předpověděli, že Bůh ke každému člověku promluví. Kdo dbá na tento Otcův hlas, přijde určitě ke mně. ");
INSERT INTO ceslb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","To ovšem neznamená, že pozná o Bohu všechno – jenom já jsem Otce viděl a znám ho. ");
INSERT INTO ceslb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Znovu vám opakuji, že každý, kdo mi uvěří, získává věčný život. ");
INSERT INTO ceslb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Já jsem ten životodárný chléb. ");
INSERT INTO ceslb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vaši předkové jedli na poušti manu, a přesto zemřeli. ");
INSERT INTO ceslb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Kdo však okusí skutečný nebeský chléb – a to jsem já, nezemře. Kdo se mnou sytí, bude věčně žít. Tím chlebem je mé tělo a já je obětuji, aby svět mohl žít.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","To vyvolalo mezi posluchači nový rozruch: „Jak si to představuje, cožpak můžeme jíst jeho tělo?“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Na to jim Ježíš řekl: „Je to tak. Žádný z vás sám o sobě nebude žít věčně. Chcete-li mít věčný život, musíte se sytit mým tělem a krví. ");
INSERT INTO ceslb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jedině ten, kdo přijme moji oběť, bude žít na věky a já ho vzkřísím v poslední den. ");
INSERT INTO ceslb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Moje oběť je váš pravý duchovní pokrm a nápoj. ");
INSERT INTO ceslb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","58","Kdo ji přijme, ten je se mnou nerozlučně spojen. Já mu budu zdrojem života, který vyvěrá z Otce. Proto je moje oběť ten pravý nebeský chléb. Vaši předkové jedli manu, a přece zemřeli. Jestliže vy přijmete mne jako svůj chléb, budete žít věčně.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","To Ježíš prohlásil v kafarnaumské synagoze. ");
INSERT INTO ceslb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mnozí z jeho dosavadních přívrženců teď říkali: „Co je to za nesmysly, to se nedá poslouchat!“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ježíš uslyšel, že se je ho posluchači rozhořčují, a zeptal se jich: „To je vám kamenem úrazu? ");
INSERT INTO ceslb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A co řeknete, až uvidíte, jak vystupuji tam, odkud jsem přišel? ");
INSERT INTO ceslb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mluvil jsem o duchovních skutečnostech, ale vy chápete moje výroky hmotně. Váš rozum na to nestačí, jenom Duch vám pomůže, abyste pochopili a získali tak život. ");
INSERT INTO ceslb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ale někteří mi nevěříte.“ Ježíš totiž hned poznal, kdo k němu přistupoval s nedůvěrou a kdo ho zradí. ");
INSERT INTO ceslb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pak dodal: „Proto jsem vám řekl, že vám ke mně může otevřít cestu jedině Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tehdy Ježíše opustilo mnoho dosavadních přívrženců. ");
INSERT INTO ceslb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Obrátil se tedy ke svým dvanácti nejbližším s otázkou: „Co vy, chcete mě také opustit?“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Šimon Petr odpověděl za všechny: „Pane, ke komu bychom šli? Tvoje slova pro nás znamenají věčný život. ");
INSERT INTO ceslb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Uvěřili jsme a poznali, že jsi Kristus, Boží Syn.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ježíš na to řekl: „Vás dvanáct jsem si vyvolil, a přece i v jednom z vás je ďábel.“ ");
INSERT INTO ceslb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Myslel tím Jidáše, syna Šimona Iškariotského. Věděl, že ten ho zradí, třebaže byl jedním z jeho dvanácti učedníků. ");
INSERT INTO ceslb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pak Ježíš chodil po Galileji, v Judsku mu ukládali o život. ");
INSERT INTO ceslb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Když se blížily židovské svátky díkůvzdání, ");
INSERT INTO ceslb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ježíšovi bratři naléhali: „Jdi do Judska, ať lidé vidí tvoje činy! ");
INSERT INTO ceslb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Neskrývej se v ústraní, ale snaž se prosadit na veřejnosti.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Oni ho totiž nechápali. ");
INSERT INTO ceslb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ježíš jim řekl: „Půjdu, až přijde můj čas. Vy můžete jít kdykoliv, ");
INSERT INTO ceslb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","protože vás lidé nebudou nenávidět tak jako mne. Neradi slyší, když je obviňuji z jejich zlých činů. ");
INSERT INTO ceslb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jděte klidně sami a já přijdu, až bude vhodná chvíle.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","Ježíš zůstal v Galileji, ale brzy po odchodu svých bratrů se tajně vydal na cestu. Chtěl totiž dojít do Jeruzaléma nepoznán. ");
INSERT INTO ceslb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","12","O svátcích ho tam lidé hledali a všude se o něm hovořilo. Někteří ho chválili, jiní zase říkali, že plete lidem hlavu. ");
INSERT INTO ceslb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ale to se jen šeptalo, protože mluvit o něm na veřejnosti bylo nebezpečné. ");
INSERT INTO ceslb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Uprostřed oslav se Ježíš objevil v chrámu a začal kázat. ");
INSERT INTO ceslb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Překvapení Židé se divili: „Jak to, že se tak vyzná v Písmu, když na to nemá školy?“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ježíš jim odpověděl: „Nepředkládám vám své vlastní názory. Tlumočím jen to, co vám chce sdělit Bůh. ");
INSERT INTO ceslb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jste-li ochotni plnit Boží vůli, jistě poznáte, že to nejsou má vlastní slova. ");
INSERT INTO ceslb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kdo přináší světu jen vlastní myšlenky, ten touží po slávě a lidské chvále. Ale ten je upřímný a pravdomluvný, kdo svou řečí oslavuje Boha. ");
INSERT INTO ceslb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mojžíš vám dal zákon, ale nikdo z vás ho neplní. Jakým právem mne osočujete? Proč mi ukládáte o život?“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","„Ty ses snad pomátl na rozumu! Copak tě chce někdo zabít?“ ozvalo se z davu. ");
INSERT INTO ceslb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ježíš jim řekl: „Uzdravil jsem v sobotu nemocného člověka, a vyvedlo vás to z míry. ");
INSERT INTO ceslb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Přitom vy sami nepovažujete za porušení, když připadne na sobotu povinnost udělat obřízku, a klidně ji vykonáte. Proč vás tedy tak rozčiluje, že jsem v sobotu vrátil člověku zdraví? ");
INSERT INTO ceslb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Neulpívejte na povrchu, ale pronikejte k jádru věci.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Někteří z jeruzalémských občanů povstali: „Je to opravdu ten, kterého chtějí zabít? ");
INSERT INTO ceslb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","27","Veřejně káže v chrámu, a oni ho nechají. Že by ho přece uznali za Mesiáše? To se nám nezdá. O Mesiáši prý nikdo nebude vědět, odkud přišel, ale Ježíšův původ známe.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","„Znáte mne a víte, odkud pocházím,“ zvolal Ježíš. „Ale neznáte toho, který mne poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Já ho znám dobře a vím, že si zaslouží naši důvěru. On za mnou stojí, neprosazuji svou vlastní věc.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chtěli ho zatknout, ale nikdo se k tomu neodhodlal, protože ještě nepřišla chvíle, kdy se to mělo stát. Mnozí z posluchačů v Ježíše uvěřili. ");
INSERT INTO ceslb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Řekli si: „Mesiáš by určitě nedělal více zázraků než on!“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Když se to doneslo farizejům a velekněžím, poslali chrámovou stráž, aby ho zatkla. ");
INSERT INTO ceslb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ježíš pokračoval: „Zůstanu s vámi ještě nějaký čas a pak se vrátím k tomu, který mne poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Až odejdu, budete mne marně hledat, ale za mnou se nedostanete.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","Židé se překvapeně ptali: „Kam chce odejít, že se za ním nedostaneme? Chce snad jít mezi pohany a učit je?“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Poslední den svátků, když kněží v průvodu nesli vodu do chrámu, stál tam Ježíš a volal: „Kdo má žízeň, pojď se ke mně napít. Písmo říká, že nitro každého, kdo ve mne uvěří, vydá životodárný pramen.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mluvil o Božím Duchu, který měl být seslán až po dovršení Ježíšova díla na zemi. Měl ho dostat každý, kdo v Ježíše uvěří. ");
INSERT INTO ceslb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ze zástupu se ozvaly dohady: „To je asi Mesiáš.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Někteří však namítali: „Ne, to může být nanejvýš jeho předchůdce. Pochází přece z Galileje! ");
INSERT INTO ceslb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","A Písmo říká, že Mesiáš se narodí v Betlémě a že bude potomkem krále Davida.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nakonec se pohádali. ");
INSERT INTO ceslb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","45","Chrámová stráž se neodvážila Ježíše zatknout. Vrátili se ke kněžím a farizejům, kteří se na ně obořili: „Kde ho máte? Proč jste ho nepřivedli?“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","„Nemohli jsme, takového člověka jsme ještě neslyšeli.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","„Tak i vy jste se nechali svést?“ zlobili se farizejové. ");
INSERT INTO ceslb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","„Uvěřil mu snad někdo z velerady nebo z nás? ");
INSERT INTO ceslb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Co se dá čekat od nevzdělaného davu! Nevyznají se v Bibli a takhle to dopadá.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jeden z farizejů – Nikodém, který před časem Ježíše navštívil, namítl: ");
INSERT INTO ceslb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","„Jak můžete odsoudit člověka, kterého jste nevyslechli? Odpovídá to našemu zákonu?“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","„Nejsi snad jeho krajan?“ zeptali se ho. „Ukaž nám v Bibli, že má přijít prorok z Galileje.“ ");
INSERT INTO ceslb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","A s tím se rozešli. ");
INSERT INTO ceslb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ježíš odešel na Olivovou horu. ");
INSERT INTO ceslb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Brzy ráno se do chrámu vrátil, sedl si tam a začal učit shromážděný dav. ");
INSERT INTO ceslb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Za chvíli k němu znalci zákona a farizejové přivedli jednu ženu přistiženou při nevěře. ");
INSERT INTO ceslb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","„Mistře,“ oslovili Ježíše, „tuto ženu jsme přistihli při cizoložství. ");
INSERT INTO ceslb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mojžíšův zákon je přísný. Odsuzuje ji k smrti ukamenováním. Co ty tomu říkáš?“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Čekali, že jim Ježíšova odpověď poskytne záminku k jeho odsouzení. Ježíš však mlčel, sklonil se k zemi a psal něco prstem v prachu. ");
INSERT INTO ceslb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Žalobci stále dotírali, aby odpověděl. Ježíš se vzpřímil a řekl: „Kdo z vás je bez hříchu, ať po ní hodí první kamenem!“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pak se znovu sklonil a psal po zemi. ");
INSERT INTO ceslb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jeho slovy byli zahanbeni. Ozvalo se v nich svědomí, a tak jeden po druhém odcházeli – ti nejváženější jako první. Nakonec zůstal Ježíš s provinilou ženou sám. ");
INSERT INTO ceslb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Znovu se vzpřímila zeptal se ženy: „Kam se poděli tvoji žalobci? Žádný z nich tě neodsoudil?“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","„Ne, Pane,“ odpověděla žena. „Já tě také neodsuzuji,“ řekl Ježíš. „Jdi, ale už nehřeš!“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jindy Ježíš řekl: „Já jsem světlo světa, kdo mne následuje, nebude tápat ve tmě, ale bude mít světlo na cestu života.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nato mu farizejové řekli: „Mluvíš stále jen sám o sobě. Kdo to potvrdí?“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ježíš jim odpověděl: „Říkám jen pravdu, i když se týká mne samotného. Já vím, odkud jsem přišel a kam jdu, ale vy to nevíte. ");
INSERT INTO ceslb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Vy mne posuzujete nesprávně – jen podle svého zdání. Já tak nesoudím. ");
INSERT INTO ceslb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Můj úsudek odpovídá skutečnosti, protože není jen můj, ale i Boží. ");
INSERT INTO ceslb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A když se dva svědci shodnou ve výpovědi, vaše zákony považují takové svědectví za platné. ");
INSERT INTO ceslb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nemluvím tedy o sobě jen sám, ale svědčí o mně i Otec, který mne poslal.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","„A kde je ten tvůj Otec?“ ptali se farizejové. Řekl jim: „Když neznáte mne, nemůžete znát ani mého Otce. Kdybyste znali mne, znali byste i jeho.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tato slova Ježíš řekl v blízkosti chrámových pokladen, kde byla stráž. Přesto ho nezatkli, protože ještě nepřišel čas, kdy se to mělo stát. ");
INSERT INTO ceslb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","„Opustím vás,“ pokračoval Ježíš. „Budete mne hledat, ale bude pro vás pozdě. Zemřete v zajetí svých hříchů a tam, kam jdu, nebudete moci přijít.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","„Chce snad spáchat sebevraždu?“ ptali se mezi sebou. „Proč by jinak říkal, že za ním nemůžeme přijít tam, kam jde?“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ježíš jim řekl: „Já jsem od Boha, vy jste ze světa, který je Bohu odcizen. ");
INSERT INTO ceslb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Proto zemřete v hříchu, když mi neuvěříte.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","„Tak nám tedy řekni, kdo vlastně jsi!“ naléhali na Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","„Už jsem vám to jasně řekl. Jsem ten, za koho se od začátku prohlašuji,“ odpověděl. „Ale o vás bych mohl říci mnoho, co vás odsuzuje. A není to můj úsudek. Každé mé slovo pochází od toho, který mne poslal. On je pravda sama.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nikdo v té chvíli nepochopil, že Ježíš mluví o Bohu. ");
INSERT INTO ceslb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Proto na vysvětlenou dodal: „Poznáte mne, až mne přibijete na kříž, teprve pak si uvědomíte, že všechno, co jsem vám říkal a co jsem udělal, nebylo ode mne, ale od mého Otce. To on mne naučil všemu, co jsem vám řekl. ");
INSERT INTO ceslb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Je stále se mnou. Neopouští mne, protože dělám jen to, co mu je milé.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Po těch slovech mnozí v něho uvěřili. ");
INSERT INTO ceslb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Těm Ježíš řekl: „Držte se mých slov a budete opravdu mými učedníky. ");
INSERT INTO ceslb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Poznáte pravdu a pravda vás osvobodí.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","„Jsme potomci Abrahama,“ ozvali se. „Nikdy jsme nebyli otroky, proč tedy říkáš, že budeme osvobozeni?“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ježíš jim řekl: „Nemyslete si, že jako potomci Abrahamovi to máte u Boha jisté. Každý člověk je otrokem hříchu ");
INSERT INTO ceslb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","a otrok nemá právo na nic. ");
INSERT INTO ceslb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","38","Musíte se stát svobodnými členy Boží rodiny, a to vám může darovat jedině Syn. Nabízím vám takový dar, ale vy ho odmítáte a chcete se mne zbavit. Nedorozumění mezi námi je v tom, že nemáme stejného Otce.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","„Naším otcem je Abraham,“ řekli jednomyslně Židé. „Byl by vaším otcem,“ odpověděl jim Ježíš, „kdybyste ho svými životy následovali. ");
INSERT INTO ceslb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Chcete mne zabít, přestože vám říkám pravdu, kterou mi sdělil Bůh. Abraham by tak nejednal. ");
INSERT INTO ceslb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Projevujete se jako děti svého skutečného otce.“ To je rozhněvalo a jízlivě mu odsekli: „Nenarodili jsme se ze smilstva jako ty. Kdo myslíš, že je naším otcem? Kdo jiný, než Abrahamův Bůh! Nezpronevěřili jsme se mu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ježíš však namítl: „Kdyby Abrahamův Bůh byl opravdu vaším otcem, milovali byste mne. V něm je můj původ. Nepřicházím sám od sebe, ale on mne k vám posílá. ");
INSERT INTO ceslb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Proč nechápete, co říkám? ");
INSERT INTO ceslb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Protože váš otec je ďábel a vy děláte, co vám našeptává. Jeho lži od počátku přinášejí smrt a nic jiného, protože v něm není ani trochu pravdy. Nemůže si pomoci, lhaní je jeho přirozenost. A je původcem každé lži. ");
INSERT INTO ceslb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","46","Kdo z vás mne může usvědčit z hříchu? Nikdo! Proč mi tedy nevěříte, když říkám pravdu? ");
INSERT INTO ceslb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kdo je opravdu Božím dítětem, ten rád přijímá Boží slovo. Vy je odmítáte, a to dokazuje, že z Boha nepocházíte.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","„Vždyť to říkáme, jsi odrodilec a blázen,“ křičeli na něj Židé. ");
INSERT INTO ceslb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","„Nejsem,“ odpověděl jim Ježíš klidně. „Já Otci vzdávám čest, ale vy mu ji upíráte, když mne nepřijímáte. ");
INSERT INTO ceslb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nemyslete si, že toužím po slávě a velikosti. Mne chce oslavit Bůh. Odsoudí každého, kdo mne odmítne. ");
INSERT INTO ceslb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Budete-li žít podle mého slova, nemusíte se bát smrti.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","„Teď se ukázalo, jaký jsi blázen!“ posmívali se. „Abraham zemřel, proroci zemřeli, a ty tvrdíš, že kdo dá na tebe, unikne smrti. ");
INSERT INTO ceslb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Myslíš si snad, že jsi významnější než náš otec Abraham a větší než proroci? Co to ze sebe děláš? Vždyť ti všichni zem-řeli!“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ježíš jim odpověděl: „Kdybych se chválil sám, má slova by neměla žádnou váhu, ale chválí mne můj Otec, kterého uznáváte za svého Boha. ");
INSERT INTO ceslb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nikdy jste ho však nepoznali, ale já ho znám dobře. Kdybych to zapřel, byl bych stejný lhář jako vy. Opravdu ho dobře znám a ve všem ho poslouchám. ");
INSERT INTO ceslb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jakou radost by měl váš otec Abraham, kdyby se dočkal mého příchodu. Už tehdy věděl, že přijdu, a jak se z toho radoval.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","„Teď jsi se projevil. Není ti ani padesát, a pamatuješ Abrahama?“ smáli se Židé. ");
INSERT INTO ceslb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ježíš odpověděl: „Žil jsem dávno před tím, než se narodil Abraham.“ ");
INSERT INTO ceslb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","To rozpálilo jejich hněv a chtěli ho ukamenovat. V rozruchu, který nastal, se Ježíš vytratil z chrámu. ");
INSERT INTO ceslb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cestou Ježíš potkal člověka, který byl od narození slepý. ");
INSERT INTO ceslb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","„Mistře,“ ptali se Ježíše učedníci, „proč se narodil slepý? Zhřešil on, nebo jeho rodiče?“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","„Nehledejte vinu ani u něho, ani u jeho rodičů,“ odpověděl Ježíš. „Jeho slepota dovolí Bohu, aby ukázal svoje dílo pro člověka. ");
INSERT INTO ceslb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dílo spásy musí být vykonáno, pokud je k němu příležitost. Člověk pracuje ve dne, v noci jsme všichni jako slepí. ");
INSERT INTO ceslb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dokud prosvětluji temnotu světa, je čas k Božímu dílu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pak Ježíš plivl na zem, ze sliny udělal bláto, potřel jím slepcovy oči ");
INSERT INTO ceslb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","a přikázal: „Běž se umýt do rybníka Siloe.“ Slepý Ježíše poslechl. Umyl si v rybníku obličej a pak si promnul oči. Náhle zjistil, že vidí. ");
INSERT INTO ceslb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ti, kdo ho znali jako slepého, se divili: ");
INSERT INTO ceslb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","„Je to ten slepý žebrák, nebo ne?“ Někteří si mysleli, že je to on, jiní, že je to jeho dvojník. Ale on řekl: „Jsem to já!“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","„A jak to, že teď vidíš?“ ptali se ho. ");
INSERT INTO ceslb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Pověděl jim, jak se to stalo: „Nějaký Ježíš mi potřel oči blátem a řekl mi, abych se umyl v rybníku Siloe. Udělal jsem to a od té chvíle vidím.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","„Nevíš, kde bychom ho našli?“ ptali se zvědavě. „To nevím,“ odpověděl. ");
INSERT INTO ceslb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","15","Slepec byl uzdraven v sobotu, a proto ho odvedli k farizejům a tam musel znovu vyprávět, jak se to přihodilo. ");
INSERT INTO ceslb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Některým z nich se to nelíbilo: „Ten člověk neuzdravuje z Božího pověření. Vždyť nezachovává sobotu.“ Jiní ho zase bránili: „Takové zázraky přece nemůže dělat hříšný člověk.“ A už byli v sobě. ");
INSERT INTO ceslb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Znovu se tedy obrátili na uzdraveného: „Co ty si o něm myslíš?“ „Určitě je to Boží posel,“ odpověděl jim. ");
INSERT INTO ceslb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Farizejové začali pochybovat o tom, že býval slepý. Zavolali si jeho rodiče ");
INSERT INTO ceslb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","a zeptali se jich: „Je to váš slepý syn, který od narození neviděl?“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Rodiče odpověděli: „Je to náš syn a býval vždycky slepý. Ovšem nevíme, kdo ho uzdravil. Konečně, je už dospělý, ať vám to řekne sám.“ Odpověděli vyhýbavě, protože se báli. Farizejové hrozili vyloučením z židovské obce každému, kdo by Ježíše prohlásil za Mesiáše. ");
INSERT INTO ceslb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A tak si znovu zavolali toho bývalého slepce a přikázali mu: „Řekni pravdu! Bůh tě slyší! Víme, že Ježíš je špatný člověk.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","„Nevím, co je to za člověka,“ odpověděl uzdravený, „ale vím, že jsem byl slepý a teď vidím!“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","„Jak tě uzdravil, co s tebou dělal?“ ptali se ho znovu. ");
INSERT INTO ceslb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","„Už jsem vám to řekl jednou,“ odpověděl, „proč se mne na to znovu ptáte? Chcete se snad stát jeho učedníky?“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Farizejové mu spílali a osopili se na něj: „Ty jsi jeho učedník, my jsme učedníci Mojžíšovi. ");
INSERT INTO ceslb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Víme, že Bůh mluvil k Mojžíšovi, ale o tomto člověku nevíme vůbec nic.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","„To je ale divné! Vy nevíte, kdo to je, a otevřel mi oči,“ řekl uzdravený. ");
INSERT INTO ceslb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","32","„Bůh by jistě nevyslyšel prosbu zlého člověka! Slyší jen toho, kdo ho poslouchá a ctí. Ještě jsem neslyšel, že by někdo uzdravil slepého od narození. ");
INSERT INTO ceslb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Proto si myslím, že by Ježíš nedokázal něco podobného, kdyby ho neposlal Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","„Ty mrzáku, ty nás budeš poučovat?“ křičeli na něho farizejové a vyhodili ho. ");
INSERT INTO ceslb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Když se Ježíš dověděl, co se mu přihodilo, vyhledal ho a zeptal se: „Věříš v Božího Syna?“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Uzdravený odpověděl: „Rád bych v něho věřil, ale neznám ho.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ježíš řekl: „Vidíš ho a právě s tebou mluví.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","„Věřím, Pane!“ vydechl a padl před Ježíšem na kolena. ");
INSERT INTO ceslb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ježíš dodal: „Přišel jsem na svět proto, abych uvedl věci na pravou míru: slepí prohlédnou a ti, kdo vidí, oslepnou.“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Zaslechli to někteří farizejové a zeptali se: „Jsme my ti slepí?“ ");
INSERT INTO ceslb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","„Kdybyste byli opravdu slepí, byla by to polehčující okolnost pro váš hřích,“ odpověděl jim Ježíš. „Vaše vina však zůstává, protože říkáte, že vidíte, a to znamená, že víte, co děláte.“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","„Každý ví, že kdo nevchází do ovčince dveřmi, ale přelézá ohradu, není pastýř, ale zloděj. ");
INSERT INTO ceslb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pastýř vchází do ovčince zásadně dveřmi. ");
INSERT INTO ceslb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hlídač otevírá jenom jemu a ovce svého pána poznávají už po hlase. Pastýř na ně volá jménem a ony k němu běží, protože vědí, že je vyvede na pastvu. ");
INSERT INTO ceslb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Vodí své stádo a ovce ho následují, protože znají jeho hlas. ");
INSERT INTO ceslb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Cizího člověka neposlechnou a nejdou za ním, protože jeho hlas neznají.“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Posluchači nepochopili toto Ježíšovo srovnání, ");
INSERT INTO ceslb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","a tak je vysvětlil: „Já jsem pastýř, který střeží vchod do ovčince. ");
INSERT INTO ceslb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Všichni, kdo se tam dobývají jinudy, jsou zloději a lupiči a ovce je neposlouchají. ");
INSERT INTO ceslb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Já jsem vchod. Kdo mnou vejde, bude zachráněn. A kdo se mnou bude vcházet i vycházet, nebude mít nedostatek. ");
INSERT INTO ceslb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Zloděj ovce krade a zabíjí, já jim však přináším život plný hojnosti. ");
INSERT INTO ceslb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Já jsem dobrý pastýř, který za ovce i život obětuje. ");
INSERT INTO ceslb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Námezdný pastevec nemá k ovcím vztah, a když se blíží vlk, uteče. Ovce nejsou jeho, a tak mu na nich nezáleží. Ať je vlk třeba rozežene nebo roztrhá. ");
INSERT INTO ceslb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Já jsem však dobrý pastýř a mám rád své ovce a ony mne. ");
INSERT INTO ceslb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Podobně mne miluje Otec a já zas Otce. Za ovce položím i život. ");
INSERT INTO ceslb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mám ještě jiné ovce, mimo vyvolený národ. I ty svolám, přivedu je a bude jeden ovčinec a jeden pastýř. ");
INSERT INTO ceslb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Protože dávám svůj život, Otec mne miluje a z lásky mi ho zase vrátí. ");
INSERT INTO ceslb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nikdo mne nemůže zabít bez mé vůle. Je v mé moci, abych se života vzdal a opět ho získal. Činím to z pověření svého Otce.“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ježíšova slova opět vyvolala mezi posluchači roztržku. ");
INSERT INTO ceslb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mnozí říkali: „Je posedlý démonem a dočista se zbláznil. Vůbec ho neposlouchejte.“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jiní však mínili: „To není řeč posedlého. Což může zlá moc uzdravit slepého?“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","V Jeruzalémě se právě konala výroční slavnost zasvěcení chrámu. Bylo to v zimním období dešťů, ");
INSERT INTO ceslb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","a tak se Ježíš procházel chrámovým podloubím. ");
INSERT INTO ceslb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Židé ho obklopili a ptali se ho: „Jak dlouho nás necháš ještě v nejistotě? Proč nám otevřeně neřekneš, jsi-li opravdu Mesiáš?“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","„Vždyť jsem vám to již nejednou řekl, ale vy jste to nikdy nevzali vážně,“ odpověděl jim Ježíš. „Mé činy vydávají svědectví o tom, že jsem Mesiáš. Vždyť je konám z Otcova pověření. ");
INSERT INTO ceslb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nevěříte mi, protože nepatříte do mého stáda. ");
INSERT INTO ceslb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Moje ovce slyší můj hlas a následují mne; já je miluji ");
INSERT INTO ceslb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","a dávám jim věčný život. Vysvobodím je ze smrti, nikdo a nic mi je z ruky nevyrve. ");
INSERT INTO ceslb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","30","Já a Otec jsme jedno, a koho Bůh uchopil, toho se nikdy nevzdá. Kdo je větší než Bůh?“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","To Židy tak popudilo, že začali sbírat kameny a chtěli Ježíše zabít. ");
INSERT INTO ceslb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ježíš se hájil: „Ve všech mých činech jste mohli vidět Boží lásku. Pro který z nich mne chcete ukamenovat?“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","„Nechceme tě ztrestat pro tvé činy, ale protože se rouháš,“ vyjeli na něho Židé. „Jsi člověk a děláš ze sebe Boha.“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Ježíš se hájil slovem Písma, kde sám Bůh propůjčuje určitým lidem titul bohové. „Písmo berete za neměnnou autoritu. Proč vám najednou vadí, když se Božím Synem nazývám já, zplnomocněný Boží vyslanec? Prokázal jsem přece, že mne Bůh poslal a zplnomocnil. ");
INSERT INTO ceslb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jestliže jsem nekonal Otcovy skutky, nevěřte mi. ");
INSERT INTO ceslb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jestliže jsem je konal, nechte se jimi přesvědčit. Dokazují důvěrnou jednotu mezi mnou a jím.“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Židé se chtěli Ježíše znovu zmocnit, ale on jim unikl. ");
INSERT INTO ceslb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Odešel za Jordán a zdržoval se na místě, kde předtím Jan křtil. ");
INSERT INTO ceslb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mnozí z těch, kteří za Ježíšem přicházeli, si říkali: „Jan sice nedělal zázraky, ale všechno, co o tomto muži řekl, se plní.“ ");
INSERT INTO ceslb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mnozí tam v Ježíše uvěřili. ");
INSERT INTO ceslb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ježíšův přítel Lazar těžce onemocněl. Žil se svými sestrami Marií a Martou ve vesnici Betanii. ");
INSERT INTO ceslb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Marie byla ta žena, která pomazala vzácnou mastí Ježíšovy nohy, jak se ještě dovíme.) ");
INSERT INTO ceslb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bály se o bratrův život, a tak poslaly Ježíšovi vzkaz: „Pane, tvůj milovaný přítel je vážně nemocný.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Když se to Ježíš dověděl, řekl: „Nebojte se, Bůh nechce Lazarovu smrt, chce jen oslavit svého Syna.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Měl velmi rád obě sestry i Lazara, ale přesto se ještě dva dny zdržel na místě, kde ho zastihla zpráva o Lazarově nemoci. ");
INSERT INTO ceslb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Teprve pak řekl svým učedníkům: „Pojďme tedy do Betanie!“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ale ti namítali: „Mistře, ty chceš do Judska? Vždyť tě tam chtěli nedávno zabít, a ty se tam chceš vrátit?“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","„Proč se bojíte, jako by už nastávala noc,“ řekl jim Ježíš. „Můj den ještě neskončil. ");
INSERT INTO ceslb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kdo chodí ve dne, nemusí se bát úrazu, protože dobře vidí na cestu. Teprve cesta za tmy je nebezpečná.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Potom dodal: „Náš přítel Lazar usnul a já ho jdu probudit.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Učedníci se zaradovali: „Tak on spí? To mu udělá dobře.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ježíš však nemluvil o uzdravujícím spánku, ale o Lazarově smrti. ");
INSERT INTO ceslb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Řekl jim tedy otevřeně: „Lazar zemřel ");
INSERT INTO ceslb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","a já jsem rád, že jsem k němu nepřišel před jeho smrtí. Mohu vám tak podat nový důkaz o své moci, abyste mi uvěřili. Pojďme tam.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomáš, kterému říkali Dvojče, rezignovaně povzdechl: „Pojďme, ať třeba umřeme s ním!“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Do Betanie přišli čtyři dny po Lazarově pohřbu. ");
INSERT INTO ceslb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Z Jeru-zaléma bylo do Betanie jen asi tři kilometry, ");
INSERT INTO ceslb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","a tak mnozí známí z města přicházeli těšit Lazarovy sestry v jejich žalu. ");
INSERT INTO ceslb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","21","Ty se dověděly, že Ježíš přichází. Marie zůstala doma, ale Marta mu běžela vstříc se slovy: „Pane, kdybys tu byl, bratr by jistě neumřel. ");
INSERT INTO ceslb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ale já vím, že ani teď Bůh neodmítne žádnou tvoji prosbu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","„Neboj se,“ odpověděl jí Ježíš, „tvůj bratr bude zase žít.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","26","Ježíš jí řekl: „To já přináším vzkříšení a život. Ti, kdo ve mne uvěřili, ať zemřeli nebo ještě žijí, v žádném případě nezemřou navždy. Věříš tomu, Marto?“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","„Věřím, že jsi Boží Syn. Jsi Mesiáš, který měl přijít na svět,“ odpověděla. ");
INSERT INTO ceslb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta se pak vrátila domů a pošeptala své sestře: „Přišel Mistr a chce s tebou mluvit.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sotva to Marie uslyšela, vstala a spěchala k němu. ");
INSERT INTO ceslb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ježíš se zatím zdržoval na místě, kde se setkal s Martou. ");
INSERT INTO ceslb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Židé, kteří Marii utěšovali, se domnívali, že se jde vyplakat k Lazarovu hrobu, proto šli za ní. ");
INSERT INTO ceslb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jakmile Marie našla Ježíše, poklekla před ním na zem a naříkala: „Pane, kdybys byl zastihl Lazara živého, jistě bys ho nenechal zemřít.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mariin pláč Ježíše rozrušil a okázalý nářek Židů se ho nemile dotkl. ");
INSERT INTO ceslb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Zeptal se: „Kam jste Lazara pohřbili?“ „Pojď, Pane, ukážeme ti,“ odpověděli. ");
INSERT INTO ceslb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Teď vyhrkly slzy i Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","„Podívejte, jak ho měl rád,“ šeptali někteří mezi sebou. ");
INSERT INTO ceslb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jiní však namítali: „Proč nechal Lazara zemřít? Vždyť před tím uzdravil slepce. Nemohl ho zachránit?“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","To Ježíše popudilo a vykročil k hrobu. Byla to jeskyně zavalená balvanem. ");
INSERT INTO ceslb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","„Odvalte ten kámen!“ přikázal Ježíš. „Pane, bratr zde leží už čtyři dny a jeho tělo je jistě v rozkladu,“ namítla Marta. ");
INSERT INTO ceslb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","„Kde zůstala tvoje víra, že se Bůh oslaví?“ podivil se Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Otevřeli hrob, Ježíš pohlédl k nebi a modlil se: „Otče, děkuji ti, že mne vyslyšíš. ");
INSERT INTO ceslb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Já vím, že vždycky slyšíš, ale říkám to nahlas, aby tito lidé uvěřili, že jsi mne poslal.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pak zvolal: „Lazare, pojď ven!“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A Lazar vyšel. Ruce a nohy měl ovinuté plátnem, tvář zahalenou šátkem. „Sundejte mu to,“ přikázal Ježíš, „ať může chodit.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tehdy mnoho z přihlížejících Židů Ježíšovi uvěřilo, protože se stali svědky tohoto zázraku. ");
INSERT INTO ceslb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Někteří z nich však zprávu o této události donesli farizejům. ");
INSERT INTO ceslb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ti se sešli k poradě s předními židovskými kněžími: „Co si s ním počneme? Ten člověk dělá skutečné divy! ");
INSERT INTO ceslb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bude-li ve své činnosti pokračovat, všichni mu uvěří a provolají ho králem. Římané zakročí a je konec s naší vládou, chrámem i národem.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Úřadující velekněz Kaifáš řekl: „Vezměte rozum do hrsti! ");
INSERT INTO ceslb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Proč by měl být zničen celý národ, ať zemře jeden za všechny.“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Když Kaifáš navrhoval tento úklad proti Ježíšovi, netušil, že pověděl slova, která se naplní. Jako velekněz prohlásil, že Ježíš má být obětován za svůj lid. ");
INSERT INTO ceslb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jeho výrok se nevztahoval jen na Židy, ale na lidi ze všech národů, ze kterých bude vytvořena Kristova církev. ");
INSERT INTO ceslb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Od této chvíle usilovali židovští kněží a farizejové o Ježíšův život. ");
INSERT INTO ceslb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ježíš přestal veřejně vystupovat mezi Židy a usadil se se svými učedníky v Efrajimu, na okraji pouště. ");
INSERT INTO ceslb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Přiblížily se opět Velikonoce. Do Jeruzaléma přišlo mnoho poutníků, aby se ještě před hlavními svátky očistili od hříchů. ");
INSERT INTO ceslb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ptali se po Ježíši a říkali si mezi sebou: „Co si myslíte o tom, že tu není?“ ");
INSERT INTO ceslb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kněží a farizejové veřejně vyhlásili, že každý, kdo by o Ježíši věděl, musí to ihned oznámit, aby ho mohli zatknout. ");
INSERT INTO ceslb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Asi týden před Velikonocemi se Ježíš vrátil do Betanie, kde žil vzkříšený Lazar. ");
INSERT INTO ceslb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na Ježíšovu počest připravili večeři. Marta obsluhovala a u stolu seděl i Lazar. ");
INSERT INTO ceslb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Marie vzala nádobku s drahým olejem, který byl vyroben z pravého nardu. Pomazala jím Ježíšovy nohy a utřela mu je svými vlasy. Vůně nardu naplnila celý dům. ");
INSERT INTO ceslb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jeden z Ježíšových učedníků – Jidáš Iškariotský, který ho pak zradil, nesouhlasil s počínáním Marie. Řekl jí: ");
INSERT INTO ceslb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","„Proč tak vzácný olej raději neprodáš? Vždyť by na něj musel dělník pracovat celý rok. Utržené peníze se mohly rozdat chudým.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jidáš to neřekl ze soucitu s chudými, ale proto, že byl zloděj. Staral se o společnou pokladnu, avšak často si z ní něco přisvojil. ");
INSERT INTO ceslb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ježíš mu k tomu řekl: „Nech ji, připravila mne tím na můj pohřeb. ");
INSERT INTO ceslb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chudé budete mít mezi sebou stále, ale já už tu s vámi dlouho nebudu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Poutníci v Jeruzalémě se brzo dověděli o Ježíšově pobytu v Betanii. Ve velkých zástupech se za ním vypravili. Nepřitahoval je však jenom Ježíš, ale chtěli spatřit i vzkříšeného Lazara. ");
INSERT INTO ceslb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Přední židovští kněží se proto usnesli, že odstraní i Lazara, ");
INSERT INTO ceslb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","protože byl přesvědčivým dokladem Ježíšovy moci. Mnoho lidí kvůli němu věřilo. ");
INSERT INTO ceslb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Příštího dne se po Jeruzalémě rozkřiklo, že do města přichází Ježíš. Shromáždil se velký dav lidí a šli ho vítat. ");
INSERT INTO ceslb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Natrhali palmové ratolesti a nadšeně volali: „Sláva Ježíši! Ať žije Mesiáš! Ať žije náš Král!“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ježíš k nim přijel na oslátku a tak se naplnila předpověď dávného izraelského proroka: ");
INSERT INTO ceslb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","„Neboj se, Jeruzaléme. Tvůj král se blíží, přijíždí na oslátku.“ (Ježíšovi učedníci si tehdy tuto souvislost neuvědomili. ");
INSERT INTO ceslb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Teprve po Ježíšově vzkříšení pochopili, že se tenkrát naplnilo proroctví.) ");
INSERT INTO ceslb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ježíše doprovázelo mnoho svědků Lazarova vzkříšení. Všem o tomto divu vyprávěli, ");
INSERT INTO ceslb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","a tím zástup narůstal. ");
INSERT INTO ceslb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farizejů se zmocnila panika: „Jsme ztraceni! Všichni se k němu přidávají.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","V Jeruzalémě bylo i několik Řeků, kteří přišli oslavit velikonoční svátky spolu s Židy. Chtěli Ježíše poznat, ");
INSERT INTO ceslb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","a tak poprosili o pomoc Ježíšova učedníka Filipa: „Pane, rádi bychom se setkali s tvým učitelem.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip vyrozuměl o jejich prosbě Ondřeje a společně to sdělili Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ježíš jim na to řekl: „Blíží se chvíle, kdy dílo Božího Syna bude dovršeno. ");
INSERT INTO ceslb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Pšeničné zrno, které není zaseto do země, se sice zachová, ale zůstane samo a bez užitku. Zaseté zrno odumírá, aby mohlo vzklíčit a přinést hojný užitek. ");
INSERT INTO ceslb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ten, kdo hledá jen vlastní prospěch, prohraje všechno, kdo mi však dá svůj život k dispozici, bude zachráněn pro věčnost. ");
INSERT INTO ceslb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Svěřit mi svůj život znamená následovat důsledně mého příkladu. To znamená jít cestou radosti i utrpení. Takového služebníka si i můj Otec váží. ");
INSERT INTO ceslb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nyní mne svírá úzkost. Mám říci: Otče, uchraň mne toho, co se na mne valí? Ne, tím bych zradil svoje poslání. ");
INSERT INTO ceslb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Otče, proveď svůj plán záchrany, ukaž lidem svoji slávu!“ Vzápětí se z nebe ozval hlas: „Již jsem to učinil a ještě učiním.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ježíš v té chvíli stál uprostřed velkého davu lidí. Někteří z nich tvrdili, že zahřmělo. Jiní mínili: „To k němu mluvil anděl.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","„Hlas, který jste slyšeli, nepromluvil kvůli mně, ale kvůli vám,“ vysvětloval Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","„Teď se rozhoduje o tomto světě. Satanova nadvláda nad lidmi bude zlomena. ");
INSERT INTO ceslb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","33","Tím, že za lidi zemřu, vysvobodím je z jeho tyranie a vezmu je pod svoji ochranu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","„Mluvíš o smrti?“ ozvalo se ze zástupu. „Vždyť Písmo říká o Mesiáši, že bude žít navždy. O kom to tedy vlastně mluvíš?“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ježíš jim odpověděl: „Světlo vám zůstane už jen krátce. Važte si ho, dokud svítí. Jděte za světlem, jinak se ocitnete ve tmě. A beze světla ztratíte cestu. ");
INSERT INTO ceslb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Uvěřte tomu světlu a nechte se jím naplnit, aby z vás svítilo dál, až tu nebude.“ Po těchto slovech se Ježíš vzdálil a skryl se. ");
INSERT INTO ceslb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","I když Ježíš učinil mnoho zázraků, lidé mu stejně neuvěřili ");
INSERT INTO ceslb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","a tak se potvrdila slova proroka Izajáše: „Pane, kdo uvěřil našim slovům? Kdo poznal Boží moc?“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Prorok Izajáš dále ukazuje, jaký důsledek Bůh vyvodil z jejich nevíry. ");
INSERT INTO ceslb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","„Zaslepil jejich oči a zatvrdil srdce, takže nevidí a nechápou. Neobrátí se k Bohu, aby jim mohl pomoci.“ ");
INSERT INTO ceslb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Prorok zde mluví o Mesiáši a jeho majestátu. ");
INSERT INTO ceslb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","V Ježíše uvěřilo sice mnoho významných mužů, ale veřejně se k němu nepřiznali, protože se báli o své postavení. ");
INSERT INTO ceslb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Záleželo jim více na lidském než na Božím hodnocení. ");
INSERT INTO ceslb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ježíš mluvil naléhavě k lidem: „Kdo mně věří, věří Bohu, který mne poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kdo mne vidí, vidí také toho, z jehož vůle přicházím. ");
INSERT INTO ceslb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Přišel jsem na svět jako světlo, a kdo ve mne uvěří, nezůstane ve tmě. ");
INSERT INTO ceslb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kdo slyší má slova a nedbá na ně, toho nesoudím. Nepřišel jsem svět soudit, ale zachránit. ");
INSERT INTO ceslb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kdo mne odmítá a má slova nepřijímá, ten má již svého soudce: moje slova ho budou soudit v poslední den. ");
INSERT INTO ceslb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","50","Říkám jen to, čím mne Otec pověřil, a moje poselství přináší věčný život. To, co vám říkám, jsou Otcova slova.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ježíš věděl, že nastávající Velikonoce jsou posledními dny jeho života na zemi, než se vrátí k Otci. Miloval ty, mezi nimiž žil, a prokazoval jim lásku až do konce. ");
INSERT INTO ceslb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","V předvečer svátků večeřel Ježíš společně se svými učedníky. To už Jidáš pojal ďábelský záměr zradit svého Mistra. ");
INSERT INTO ceslb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ježíš si byl vědom velikosti svého poslání a moci jako ten, kdo byl a bude rovný Bohu. Když viděl, že se nikdo z učedníků nechtěl snížit k službě, kterou obvykle konali otroci, vstal od stolu, ");
INSERT INTO ceslb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","odložil svrchní oděv a opásal se ručníkem. ");
INSERT INTO ceslb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nalil vodu do umývadla a začal učedníkům umývat a utírat zaprášené nohy. ");
INSERT INTO ceslb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Když došlo na Petra, ten se začal bránit: „Pane, ty mi přece nebudeš mýt nohy!“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ježíš odpověděl: „Jestliže tě neočistím, ztratíš se mnou spojení a odcizíš se mi.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","9","A tak Petr najednou obrátil: „Když je to tak, Pane, umyj mne celého.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","11","Ježíš mu na to řekl: „Koho Bůh už jednou očistil, ten se potřebuje zbavovat jen každodenní špíny a vy jste čistí, ale ne všichni.“ Tím myslel na svého zrádce. ");
INSERT INTO ceslb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Když umyl nohy poslednímu, oblékl se, vrátil se ke stolu a zeptal se jich: „Pochopili jste, proč jsem to udělal? ");
INSERT INTO ceslb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","14","Jestliže jsem vám umyl nohy já, váš Pán a Mistr, i vy si máte navzájem sloužit v pokorné lásce. ");
INSERT INTO ceslb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dal jsem vám příklad. A vy se jím řiďte a jednejte jako já. ");
INSERT INTO ceslb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Je nepochybné, že sluha není větší než jeho pán a vyslanec není významnější než hlava státu. ");
INSERT INTO ceslb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tak teď to víte, a když se podle toho budete řídit, přinese vám to radost. ");
INSERT INTO ceslb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","20","Na jedno se můžete spolehnout: kdo přijímá moje posly, přijímá mne, a tím i Otce. To, co jsem řekl, netýká se všech. Vím, koho jsem vyvolil. Plní se výrok Písma: ‚Ten, kdo se mnou jídal, podrazil mi nohy.‘ Až se to stane, pochopíte, že to byla řeč o mně a mém zrádci.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Když to Ježíš řekl, teprve to na něj v plné síle dolehlo a dodal otevřeně: „Je to tak, jeden z vás mne zradí.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Učedníci se tázavě dívali jeden na druhého, o kom to vlastně mluví. ");
INSERT INTO ceslb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","25","Petr se naklonil k učedníkovi, který byl u stolu Ježíšovi nejblíže, a naznačil mu, aby se zeptal. Ten se obrátil k Mistrovi: „Pane, kdo to je?“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","„Ten, kterému podám chléb,“ odpověděl Ježíš. Namočil kousek chleba do omáčky a podával ho Jidášovi. ");
INSERT INTO ceslb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","V tu chvíli naplnil Jidáše hněv. Ježíš mu řekl: „Neotálej a proveď rychle, co chceš.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Učedníci nechápali, o čem je řeč. Někteří si dokonce mysleli, že Jidáš má nakoupit nějaké jídlo na svátky nebo že má rozdat peníze chudým; ");
INSERT INTO ceslb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","byl totiž jejich pokladníkem. ");
INSERT INTO ceslb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jidáš přijal podávaný chléb, zvedl se a odešel. Byla noc. ");
INSERT INTO ceslb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","33","Po Jidášově odchodu Ježíš řekl: „Je rozhodnuto, půjdu poslušně cestou, která se líbí Bohu, cestou Božího vítězství. Moji milí, už s vámi dlouho nebudu. Marně mne budete hledat. Na mojí cestě mne nemůžete doprovodit. ");
INSERT INTO ceslb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Odkazuji vám, abyste se navzájem milovali, jako jsem já miloval vás. ");
INSERT INTO ceslb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Vaše vzájemná láska dokáže světu, že jste mými žáky.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","„Mistře, kam chceš odejít?“ zeptal se Petr. „Teď se mnou nemůžeš jít,“ odpověděl mu Ježíš, „budeš mne následovat později.“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","„Proč s tebou nemohu jít už teď?“ ptal se znovu Petr. „Jsem ochoten dát za tebe život!“ ");
INSERT INTO ceslb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","„Život za mne chceš dát?“ zeptal se Ježíš. „Uvidíš, že mne třikrát zapřeš, než ráno zakokrhá kohout.“ ");
INSERT INTO ceslb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","„Nebuďte smutní, věříte v Boha, věřte i ve mne. ");
INSERT INTO ceslb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","U mého Otce je domov pro všechny. Odcházím, abych vám připravil místo. ");
INSERT INTO ceslb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Až ho připravím, přijdu, vezmu si vás k sobě a zůstanete se mnou. Kdyby to nebyla pravda, já bych vám to neřekl. ");
INSERT INTO ceslb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Znáte cíl i cestu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","„Pane, nevíme, kam jdeš,“ namítl Tomáš, „jak bychom mohli znát cestu?“ ");
INSERT INTO ceslb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ježíš mu na to řekl: „Já jsem cesta k Bohu, pravda o Bohu a život s Bohem. Proto k mému Otci můžete přijít jen skrze mne. ");
INSERT INTO ceslb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kdo zná mne, zná i Otce a vidí ho.“ ");
INSERT INTO ceslb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","„Ukaž nám Otce a budeme spokojeni,“ řekl Filip. ");
INSERT INTO ceslb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ježíš ho pokáral: „Filipe, tak dlouho s vámi žiji a ty jsi mne ještě nepoznal? Jak se tak můžeš ptát? Kdo vidí mne, vidí Otce. Proč mne tedy žádáš, abych ti ho ukázal? ");
INSERT INTO ceslb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","11","Nevěříš, že mezi mnou a Otcem je dokonalá jednota? Vždyť všechno, co říkám a dělám, pochází z mého Otce. ");
INSERT INTO ceslb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","V těch, kteří mi uvěří, bude moje dílo pokračovat a rozmáhat se, protože já odcházím k Otci. ");
INSERT INTO ceslb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Tam se postarám o to, aby vaše modlitby v zájmu mého díla došly naplnění. Tak bude oslaven Otec i Syn. ");
INSERT INTO ceslb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Milujte mne a nebude vám zatěžko mne poslouchat. ");
INSERT INTO ceslb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Přimluvím se u Otce, aby vám seslal za mne Zástupce, který by s vámi navždy zůstal. ");
INSERT INTO ceslb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bude to Boží Duch, který vás povede k pravdě. Lidem, kteří dají jen na své smysly a pocity, zůstane skryt. Vám nebude cizí, protože bude s vámi a ve vás. ");
INSERT INTO ceslb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Vrátím se k vám a nenechám vás opuštěné. ");
INSERT INTO ceslb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Zanedlouho mne svět ztratí z očí, ale vy mne budete vidět očima víry a budete mít podíl na mém životě. ");
INSERT INTO ceslb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pak budete prožívat skutečnou jednotu se mnou. ");
INSERT INTO ceslb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Svou lásku mi dokážete tím, že mne budete poslouchat. A kdo mne miluje, zachová si Otcovu lásku. I já ho budu milovat a dám se mu poznat.“ ");
INSERT INTO ceslb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","„Pane, proč tě smíme poznat jen my a ostatní ne?“ zeptal se Juda. ");
INSERT INTO ceslb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","„Kdo mne miluje oddanou láskou, také můj Otec mu vyjde vstříc; přijdeme k němu a budeme u něho. ");
INSERT INTO ceslb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kdo mě nemiluje, nedbá na moje slova a pohrdá Bohem. ");
INSERT INTO ceslb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Řekl jsem vám vše, co jsem vám tu na zemi měl říci. ");
INSERT INTO ceslb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Až odejdu, Otec vám pošle Ducha svatého, který mne zastoupí. Ten vás všemu naučí a bude vám připomínat, co jsem vám kdy řekl. ");
INSERT INTO ceslb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Odkazuji vám svůj pokoj. Dávám jiný pokoj, než slibuje svět, a tak se nebojte a nedejte se zastrašit. ");
INSERT INTO ceslb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Vždyť jsem řekl: odcházím a zase přijdu. Milujete-li mne, pak se z mého odchodu budete radovat spolu se mnou. Vždyť odcházím k Otci, který je větší než já. ");
INSERT INTO ceslb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Odhalil jsem vám to, co se stane, abyste uvěřili, až se mé předpovědi splní. ");
INSERT INTO ceslb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Nezbývá už mnoho času k rozmluvě, protože přichází zlý vládce tohoto světa. Proti mně však nic nezmůže, protože se podřizuji Otcově vůli. Činím to z lásky k Otci a na svědectví světu. Pojďme, přátelé!“ ");
INSERT INTO ceslb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","„Jsem kmen vinné révy a můj Otec je vinařem. ");
INSERT INTO ceslb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Odřezává plané výhonky a plodné očišťuje, aby nesly větší úrodu. ");
INSERT INTO ceslb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","I vás očistil, a to mým poselstvím. ");
INSERT INTO ceslb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Zůstaňte ve spojení se mnou. Vždyť výhonek oddělený od kmene nemůže nést žádné ovoce; právě tak je to i s vámi. ");
INSERT INTO ceslb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Já jsem vinný kmen a vy jste výhonky. Proto jen v těsném spojení se mnou prožijete plodný život. Beze mne to nedokážete. ");
INSERT INTO ceslb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kdo žije beze mne, bude jako planý výhonek odříznut, uschne a bude spálen. ");
INSERT INTO ceslb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Zůstanete-li se mnou spojeni a nepřestane-li na vás působit mé poselství, pak dostanete všechno, o co v modlitbě požádáte. ");
INSERT INTO ceslb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Když povedete plodný život jako moji učedníci, vzdáte tím čest Bohu. ");
INSERT INTO ceslb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Miluji vás tak, jako mne miluje Otec. ");
INSERT INTO ceslb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jste-li se mnou spojeni poslušností mých příkazů, proudí do vás Boží láska jako životodárná míza. Právě tak jsem já spojen poslušností s Otcem a naplněn jeho láskou. ");
INSERT INTO ceslb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Raduji se z toho a chci, abyste se i vy mohli vždycky plně radovat. ");
INSERT INTO ceslb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Přikazuji vám, abyste se vzájemně milovali tak, jako jsem já miloval vás. ");
INSERT INTO ceslb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Největší lásku přátelům prokáže ten, kdo za ně položí vlastní život. ");
INSERT INTO ceslb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Zůstanete mými přáteli, budete-li jednat v souladu se mnou. ");
INSERT INTO ceslb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nejste už mými sluhy, protože sluha se nevyzná v úmyslu svého pána. Řekl jsem vám s důvěrou vše, co vím od Otce, a proto jste se stali mými přáteli. ");
INSERT INTO ceslb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Já jsem si vybral vás, ne vy mne. Vybavil jsem vás k tomu, abyste žili plodný život, který by před Bohem obstál. Proste a Otec vám to dá. ");
INSERT INTO ceslb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Usilujte především o vzájemnou lásku. ");
INSERT INTO ceslb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Lidé vás budou nenávidět, ale vzpomeňte si, že mne nenáviděli dříve než vás. ");
INSERT INTO ceslb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Milovali by vás, kdybyste se přizpůsobili. Vy mezi ně ale nepatříte, protože já jsem si vás vyvolil. Vyvedl jsem vás ze světa a oni vás za to nenávidí. ");
INSERT INTO ceslb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Připomeňte si slova, která jsem vám už jednou řekl: sluha není větší než jeho pán. Jestliže pronásledují mne, jak by nepronásledovali vás! Když chytali za slovo mne, budou číhat i na vás. ");
INSERT INTO ceslb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","To všechno vám budou dělat proto, že nevěří, že za mnou i za vámi stojí Bůh. ");
INSERT INTO ceslb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kdybych byl nepřišel a nemluvil k nim, byli by bez viny. Teď jsou však bez výmluvy. ");
INSERT INTO ceslb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ti, kdo mnou pohrdají, pohrdají Bohem. ");
INSERT INTO ceslb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","25","Usvědčuje je moje dílo, které nemá obdoby. Mají je před očima, a přece se zatvrdili proti mně i Otci. Však je o nich psáno v Písmu: ‚Nenáviděli mne bez důvodu.‘ ");
INSERT INTO ceslb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pošlu vám zastánce od Otce – Ducha pravdy, který pochází z Otce. Ten dosvědčí, co vám říkám. ");
INSERT INTO ceslb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ale i vy budete mými svědky, protože mne všude provázíte. ");
INSERT INTO ceslb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Těmito slovy jsem vás chtěl varovat, abyste nepodlehli zmatku z budoucích událostí. ");
INSERT INTO ceslb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nejdříve vás vyženou ze synagog. Pak vás budou dokonce zabíjet v domnění, že tím slouží Bohu. ");
INSERT INTO ceslb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Budou to dělat, protože nepoznali Otce ani mne. ");
INSERT INTO ceslb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Říkám to proto, abyste se na má slova rozpomněli, až se naplní. Zatím jsem o tom nemluvil, protože jsem byl s vámi. ");
INSERT INTO ceslb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Můj čas se však naplnil a já brzy odejdu k tomu, který mne poslal. Vidím však, že nechápete, kam jdu. Místo abyste se radovali, jste stísněni smutkem a starostmi. ");
INSERT INTO ceslb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Věřte mi, že pro vás bude lepší, když odejdu. Kdybych zůstal, Zastánce by k vám nepřišel. Odejdu-li, pošlu ho k vám. ");
INSERT INTO ceslb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Až přijde, ukáže lidem, v čem spočívá hřích, zda existuje spravedlnost a koho je třeba soudit. ");
INSERT INTO ceslb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hřích je v tom, že lidé ve mne nevěří. ");
INSERT INTO ceslb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Spravedlnost je v tom, že Bůh potrestal Krista jako zástupce hříšníků, vzkřísil ho a přijal do své slávy. ");
INSERT INTO ceslb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A soud znamená, že uchvatitel tohoto světa je již odsouzen. ");
INSERT INTO ceslb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Je toho ještě mnoho, co bych vám chtěl říci, ale vy to nemůžete v této chvíli pochopit. ");
INSERT INTO ceslb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Teprve až přijde Duch svatý, odkryje vám plnou pravdu. ");
INSERT INTO ceslb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","On bude jejím věrným tlumočníkem. Oznámí vám i to, co má přijít. ");
INSERT INTO ceslb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nebude zdůrazňovat sebe, ale vyvyšovat mne, protože mně Otec svěřil všechno. A tak co vám sdělí Duch, bude ukazovat vždycky ke mně. ");
INSERT INTO ceslb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zanedlouho již mezi vámi nebudu, ale brzy potom mě znovu uvidíte. Pak půjdu zase k Otci.“ ");
INSERT INTO ceslb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","„O čem to jen mluví?“ ptali se učedníci jeden druhého. „Kde bude zanedlouho? Kdy ho zase uvidíme? Co to znamená, že půjde k Otci? Tomu nerozumíme.“ ");
INSERT INTO ceslb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ježíš poznal, že si učedníci s jeho slovy nevědí rady. „Vysvětlím vám to,“ řekl. ");
INSERT INTO ceslb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","„Brzy se svět bude radovat z mého utrpení, zatímco vy budete plakat. Ale váš pláč se záhy promění v radost, protože mne opět uvidíte. ");
INSERT INTO ceslb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vaše radost se bude podobat radosti ženy, která zapomněla na všechnu úzkost a porodní bolesti, protože se jí narodilo dítě. ");
INSERT INTO ceslb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","23","Nyní jste smutní, ale budete se zase radovat, až se setkáme. O tuto radost vás nikdo nepřipraví. Pak všechno pochopíte. ");
INSERT INTO ceslb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Znovu vás vyzývám, abyste se ve svých modlitbách k Otci na mne odvolávali a on vás vyslyší. Proste, Bůh vás obdaruje a vaše radost bude plná. ");
INSERT INTO ceslb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Dosud jsem o těchto věcech mluvil v podobenstvích, ale brzy budu o Otci hovořit otevřeně. ");
INSERT INTO ceslb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nespoléhejte se na to, že já budu prosit Otce za vás, ale vy se modlete a odvolávejte na mne. ");
INSERT INTO ceslb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Vždyť vás Otec miluje pro vaši lásku ke mně a pro víru, se kterou jste mne přijali jako Božího Syna. ");
INSERT INTO ceslb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pravda je nejen to, že jsem od Otce přišel, ale i to, že se k němu opět vrátím.“ ");
INSERT INTO ceslb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","„Teď už ti rozumíme,“ přisvědčili učedníci. „Co jsi dříve říkal v náznacích, pověděl jsi teď jasně. ");
INSERT INTO ceslb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pochopili jsme, že víš všechno a rozumíš už napřed našim otázkám. Teď opravdu věříme, že jsi přišel od Boha.“ ");
INSERT INTO ceslb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","„Opravdu tomu věříte?“ otázal se jich Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","„Nastane čas, vlastně už nastal, kdy se rozprchnete do svých domovů a necháte mne samotného. Já však nebudu sám, protože Otec je se mnou. ");
INSERT INTO ceslb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Toto všechno jsem vám řekl proto, abyste ve spojení se mnou našli jistotu a klid. Svět vám připraví mnoho těžkostí, ale neztrácejte odvahu. Já jsem nad ním zvítězil.“ ");
INSERT INTO ceslb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Když Ježíš domluvil, pohlédl vzhůru k nebi a řekl: „Otče, přichází můj čas. Přiznej se ke mně a dovol, abych prokázal tvoji velikost. ");
INSERT INTO ceslb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Svěřil jsi mi přece moc nade všemi, abych ty, které mi dáváš, uvedl do věčného života. ");
INSERT INTO ceslb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kdo chce věčně žít, musí poznat tebe jako jediného pravého Boha a mne jako toho, kterého jsi poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Vykonal jsem vše, co jsi mi uložil, a tím jsem dokázal, v čem je tvoje velikost. ");
INSERT INTO ceslb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Otče, navrať mi nyní moc a čest, kterou jsem měl u tebe dřív, než byl svět. ");
INSERT INTO ceslb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Lidé tě nechápou, ale těm, které jsi mi dal, jsem objasnil, kdo vlastně jsi. Patří tobě a tys mi je svěřil. ");
INSERT INTO ceslb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Dali na má slova a poznali, že pocházejí od tebe. ");
INSERT INTO ceslb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Všechno, cos mi pro ně svěřil, jsem jim předal a oni uvěřili, že jsi mne poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nemodlím se teď za celý svět, ale za ty, které jsi mi už dal, neboť oni jsou tvoji. ");
INSERT INTO ceslb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Vždyť všechno, co patří mně, je tvoje a všechno, co je tvé, je moje. Na nich bude patrná moje sláva. ");
INSERT INTO ceslb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Já odcházím k tobě, oni zůstávají. Otče svatý, vezmi si je teď na starost a sjednocuj je tak, jak jsme my zajedno. ");
INSERT INTO ceslb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Já jsem o ně pečoval, dokud jsem byl s nimi. Chránil jsem je, takže jsem nikoho neztratil – kromě Jidáše. Ale i jeho zrada musí posloužit tvým plánům. ");
INSERT INTO ceslb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Proč o té péči znovu mluvím? Odcházím k tobě, ale chci, aby si oni uchovali plnou radost. ");
INSERT INTO ceslb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Svěřil jsem jim tvé slovo a svět se postavil proti nim, protože stejně jako já nesplynuli s proudem. ");
INSERT INTO ceslb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Neprosím, abys je vzal ze světa, ale abys je chránil od zlého. ");
INSERT INTO ceslb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Oni nepatří světu, jako ani já mu nepatřím. ");
INSERT INTO ceslb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Strhni je svým slovem a přiveď je k dokonalosti svou pravdou. ");
INSERT INTO ceslb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Posílám je do světa právě tak, jako jsi ty poslal mne. ");
INSERT INTO ceslb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Pokládám za ně svůj život, aby oni své životy zasvětili pravdě. ");
INSERT INTO ceslb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nemodlím se jen za ně, ale také za ty, kteří přijmou jejich poselství a uvěří ve mne. ");
INSERT INTO ceslb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","23","Dávej jim tutéž jednotu, která spojuje nás, aby z jejich jednomyslného svědectví svět poznal, že jsi ty mne poslal. Jejich jednomyslnost ať je odleskem jednoty mezi mnou a tebou. Já působím v nich, jako ty působíš ve mně. To je sjednocuje a lidé poznají, že jsi mne poslal a že je miluješ tak jako mne. ");
INSERT INTO ceslb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Otče, dal jsi mi je a já chci, aby přišli tam, kam jdu já. Poznali mne v plné slávě, kterou jsi mi dal z lásky, dřív než byl svět. ");
INSERT INTO ceslb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Otče, vím, že jsi hoden vší důvěry, ale svět si to neuvědomuje. Tito však poznali, že jsi mne poslal. ");
INSERT INTO ceslb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Objasnil jsem jim a ještě objasním, kdo jsi. Ať milují tak, jako miluješ ty mne. Pak se mezi nimi budou lidé setkávat se mnou.“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Po této modlitbě odešel Ježíš se svými učedníky do olivového háje za potok Kidrón. ");
INSERT INTO ceslb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zrádce Jidáš toto místo dobře znal, protože tam s Ježíšem a učedníky často chodíval. ");
INSERT INTO ceslb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Teď tam vedl chrámovou stráž posílenou vojenskou jednotkou; byli ozbrojení a svítili si na cestu kahany a pochodněmi. ");
INSERT INTO ceslb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ježíš věděl, co ho čeká. Vyšel jim naproti a zeptal se: „Koho hledáte?“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","„Ježíše z Nazaretu,“ odpověděli. „To jsem já,“ řekl jim. ");
INSERT INTO ceslb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Když to uslyšeli, ustoupili zpět a padli na zem. ");
INSERT INTO ceslb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","„Koho hledáte?“ zeptal se jich Ježíš znovu. „Ježíše Nazaretského,“ opakovali. ");
INSERT INTO ceslb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","„Vždyť jsem vám již řekl, že jsem to já. Tady mne máte, ale tyhle nechte odejít.“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tak se splnil jeho slib, že neztratí žádného z těch, které mu Otec svěřil. ");
INSERT INTO ceslb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Šimon Petr vytasil meč, napadl jednoho z nich a uťal mu pravé ucho. Byl to Malchos, sluha nejvyššího kněze. ");
INSERT INTO ceslb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ale Ježíš řekl Petrovi: „Schovej svůj meč! Otec určil, abych trpěl.“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","V té chvíli se ozbrojenci Ježíše zmocnili a spoutali ho. ");
INSERT INTO ceslb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Vedli ho nejprve k Annášovi, tchánovi úřadujícího velekněze Kaifáše. ");
INSERT INTO ceslb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Byl to právě Kaifáš, který zastával ve veleradě názor, že je prospěšnější, aby zemřel jeden člověk, než aby byl vydán všanc národ. ");
INSERT INTO ceslb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Petr Ježíše neopustil a sledoval ho s jiným učedníkem. Ten byl známým nejvyššího kněze, a tak se dostali za Ježíšem až na nádvoří veleknězova paláce. ");
INSERT INTO ceslb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petr zůstal před vraty. Jeho společník se přimluvil u vrátné, aby Petra pustila dovnitř. ");
INSERT INTO ceslb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta se Petra zeptala: „Nepatříš i ty mezi společníky toho člověka?“ „Co tě nemá!“ ohradil se Petr. ");
INSERT INTO ceslb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Protože bylo sychravo, zapálili si sluhové a strážci oheň a hřáli se kolem něho. Petr se šel také hřát. ");
INSERT INTO ceslb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mezitím Annáš zahájil výslech: „Kdo s tebou chodil? Čemu jsi učil?“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","„Mé učení je obecně známé,“ odpověděl Ježíš. „Mluvíval jsem veřejně v synagogách i v chrámu. Tam má každý Žid přístup. Potají jsem nemluvil nic. ");
INSERT INTO ceslb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Co se vyptáváš mne? Ptej se mých posluchačů, ti vědí, co jsem říkal.“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","„Jak to mluvíš s veleknězem?“ obořil se na Ježíše jeden ze strážných a udeřil ho. ");
INSERT INTO ceslb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ježíš se ohradil: „Jestli nemám pravdu, tak to dokaž. Jsem-li v právu, proč mne biješ?“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annáš potom předal spoutaného vězně Kaifášovi. ");
INSERT INTO ceslb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jak se tak Petr hřál u ohně, kdosi se ho zeptal: „Nejsi také jeden z Ježíšových učedníků?“ Petr to popřel. ");
INSERT INTO ceslb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jeden z veleknězových sluhů, příbuzný Malchose, kterého Petr poranil, ho obvinil: „Vždyť jsem tě s ním viděl tam v zahradě!“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petr to opět popřel a vtom zakokrhal kohout. ");
INSERT INTO ceslb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ráno odvedli Ježíše od Kaifáše k římskému místodržiteli. Židovští žalobci do jeho domu nevstoupili, aby se neposkvrnili v den svátku a nebyli tak vyloučeni z účasti na velikonoční večeři. ");
INSERT INTO ceslb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilát tedy vyšel k nim a ptal se: „Z čeho toho člověka obviňujete?“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","„Je to zločinec! Proč bychom ho sem jinak vodili,“ odpověděli. ");
INSERT INTO ceslb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","„Tak si ho nechte a suďte podle svých zákonů,“ odsekl Pilát. „Vždyť víš, že nemáme právo nikoho popravit,“ bránili se Židé. ");
INSERT INTO ceslb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tak se naplnila Ježíšova slova, kterými předpověděl způsob své smrti. ");
INSERT INTO ceslb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilát se vrátil dovnitř, nechal si Ježíše předvolat a zeptal se ho: „Ty jsi král Židů?“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","„Zajímá tě to osobně, nebo v souvislosti s žalobou?“ otázal se Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","„Jsem snad Žid, abys mohl být mým králem?“ ohradil se Pilát. „Tvůj vlastní národ a tvoji představení tě sem předvedli. Čeho ses dopustil?“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ježíš odpověděl: „Jsem král, ale nejde mi o politickou moc. Kdyby moje království bylo pozemské, moji poddaní by mne proti Židům ubránili. Má říše je jiného druhu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","„Přece jsi tedy král,“ konstatoval Pilát. „Sám to připouštíš,“ odpověděl Ježíš. „Narodil jsem se proto, abych oznámil pravdu o tomto království. Kdo miluje pravdu, ten mne poslouchá.“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","„Co je pravda?“ ukončil Pilát rozhovor a vyšel opět k Židům. „Ten člověk je nevinný,“ prohlásil. ");
INSERT INTO ceslb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","„Jestli ho vy považujete za zločince, udělím mu velikonoční amnestii, jak je tady zvykem. Chcete, abych vám propustil židovského krále?“ ");
INSERT INTO ceslb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Oni však křičeli: „Toho ne! Propusť Barabáše!“ Ten Barabáš byl buřič. ");
INSERT INTO ceslb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Potom dal Pilát Ježíše zbičovat. ");
INSERT INTO ceslb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vojáci upletli z trní věnec, nasadili ho Ježíšovi na hlavu a hodili mu přes ramena rudý plášť. ");
INSERT INTO ceslb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Obklopili Ježíše, bili ho a pokřikovali: „Ať žije židovský král!“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","5","Pilát se pokusil obměkčit žalobce a přesvědčit je o Ježíšově nevině tím, že jim ho předvedl zmučeného a zesměšněného. Ukázal na něj a řekl: „Člověk.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Velekněží a jejich stráž začali křičet: „Na kříž s ním, na kříž!“ „Ukřižujte si ho sami, pro mne je to nevinný člověk,“ řekl jim Pilát. ");
INSERT INTO ceslb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","„Podle našeho zákona je vinen,“ odporovali Židé. „Vydává se za Božího Syna.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Po tomto obvinění Pilátův neklid ještě více vzrostl. ");
INSERT INTO ceslb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Vrátil se do soudní síně a zeptal se obžalovaného: „Co jsi vlastně zač?“ Ale Ježíš mlčel. ");
INSERT INTO ceslb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","„Tak ty se mnou nemluvíš? Nevíš, že rozhoduji o tvém životě a smrti?“ řekl Pilát. ");
INSERT INTO ceslb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","„Neměl bys nade mnou žádnou pravomoc, kdyby ti ji nedal Bůh,“ odpověděl Ježíš. „Ty porušuješ právo, ale moji žalobci na sebe berou větší vinu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","To ovlivnilo Piláta, aby se ještě jednou pokusil Ježíše osvobodit. Židé však sáhli k hrubému nátlaku: „Jestliže ho propustíš, zpronevěříš se císaři. Kdo se vydává za krále, staví se proti císařskému majestátu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Když to Pilát slyšel, dal Ježíše vyvést na Dlážděné nádvoří a usedl do soudcovského křesla. ");
INSERT INTO ceslb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chtěl už případ uzavřít, protože bylo před polednem a večer začínaly židovské velikonoční svátky. Pověděl Židům: „Tak co s tím vaším králem?“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Oni se dali do křiku: „Pryč s ním! Pryč s ním! Ukřižuj ho!“ Pilát ještě namítl: „Vašeho krále mám poslat na smrt?“ Velekněží prohlásili pokrytecky: „Nepotřebujeme krále! Máme přece římského císaře.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilát se vzdal a předal Ježíše popravčí četě, aby ho ukřižovali. ");
INSERT INTO ceslb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tak naložili Ježíši na záda jeho vlastní kříž a vedli ho za město na pahorek zvaný „Lebka“, hebrejsky Golgota. ");
INSERT INTO ceslb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tam ho ukřižovali a po obou stranách vztyčili kříže pro dva zločince. ");
INSERT INTO ceslb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nad hlavou každého odsouzence bývalo napsáno, čím se provinil; na Ježíšův kříž dal Pilát napsat hebrejsky, latinsky a řecky: Ježíš Nazaretský, židovský král. ");
INSERT INTO ceslb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Popraviště bylo blízko města, takže ten nápis četlo mnoho lidí. ");
INSERT INTO ceslb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Velekněží protestovali u Piláta: „Nepiš, že je židovský král, ale že se za něj jenom vydával.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilát je odbyl: „Co jsem napsal, to tam bude!“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Popravčí četě podle práva náležely svršky odsouzenců. Ježíšův svrchní plášť – pruh plátěné látky – roztrhali na čtyři díly a podělili se o ně. Jeho nesešívaný spodní oděv, utkaný vcelku, nechtěli trhat, ");
INSERT INTO ceslb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ale řekli si: „Budeme losovat, kdo z nás ho dostane.“ Tím nevědomky uskutečnili prorockou předpověď: „Rozdělili si můj plášť a losovali o můj oděv.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","U Ježíšova kříže stála jeho matka, její sestra, Marie Kleofášova a Marie Magdaléna. ");
INSERT INTO ceslb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ježíš pohlédl na svou matku a na milovaného učedníka Jana, který stál vedle ní. Jí řekl: „On teď bude tvůj syn,“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","a jemu: „Přijmi ji jako svou matku.“ Od té chvíle se ten učedník o ni staral jako o vlastní. ");
INSERT INTO ceslb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ježíš věděl, že se blíží konec. Řekl: „Žízním.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vojáci namočili houbu do kyselého vína a na lodyze yzopu mu ji podali k ústům. Tím se také vyplnila prorocká předpověď. ");
INSERT INTO ceslb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ježíš svlažil rty a řekl: „Je dokonáno.“ Hlava mu klesla a skonal. ");
INSERT INTO ceslb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Protože se blížila sobota a navíc začátek velkého svátku, nemohli Židé připustit, aby těla zůstala na křížích. Žádali Piláta, aby urychlil popravu a mrtvé dal sejmout. ");
INSERT INTO ceslb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oběma zločincům vojáci přerazili nohy. ");
INSERT INTO ceslb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","U Ježíše to bylo zbytečné, protože viděli, že je už mrtev. ");
INSERT INTO ceslb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jeden z vojáků mu kopím otevřel bok, aby se přesvědčil, zda již doopravdy zemřel. Z rány vytékala sražená krev a čirá tekutina. ");
INSERT INTO ceslb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Popisuje to, kdo to viděl na vlastní oči. Můžete se na to spolehnout, je to pravda. ");
INSERT INTO ceslb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Opět se naplnila dvě proroctví Písma: „Ani kost mu nebude zlámána,“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","a „Uvidí, koho probodli.“ ");
INSERT INTO ceslb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ježíšovo tělo si na Pilátovi vyžádal Josef z Arimatie. Byl to Ježíšův učedník, který se dosud bál veřejně se k němu přiznat. Pilát souhlasil a Josef Ježíšovo tělo sňal z kříže. ");
INSERT INTO ceslb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pomáhal mu přitom Nikodém, který měl kdysi s Ježíšem noční rozhovor. Ten přinesl velké množství vonných látek. ");
INSERT INTO ceslb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ježíšovo tělo s těmito vonnými věcmi zavinuli do plátna, jak to Židé dělávají při pohřbívání. ");
INSERT INTO ceslb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","V zahradě nedaleko popraviště byla nová, dosud nepoužitá hrobka, vytesaná do skály. ");
INSERT INTO ceslb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tam Ježíše uložili, protože do začátku soboty nezbývalo mnoho času. ");
INSERT INTO ceslb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","První den po sobotě, ještě před rozedněním, přišla k Ježíšovu hrobu Marie Magdaléna. Uviděla, že kamenný uzávěr hrobky je odsunut. ");
INSERT INTO ceslb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Běžela k Petrovi a k učedníkovi, kterého měl Ježíš tolik rád, a oznámila jim: „Našeho Pána vzali z hro-bu a nevíme, kam ho položili.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Ti dva se zvedli a spěchali ke hrobu. Druhý učedník Petra předběhl a byl tam první. ");
INSERT INTO ceslb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Do hrobu však jenom nahlédl a uviděl prázdné plátno. ");
INSERT INTO ceslb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ale tu přiběhl Petr, který vešel dovnitř a kromě plátna nalezl ");
INSERT INTO ceslb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","i šátek, jímž byla ovázána Ježíšova hlava; ten byl svinutý a položený zvlášť. ");
INSERT INTO ceslb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","9","Za Petrem vstoupil do hrobu i druhý učedník, všechno si prohlédl a uvěřil, že Ježíš vstal z mrtvých. Až dosud to totiž stejně jako ostatní nechápal. ");
INSERT INTO ceslb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oba učedníci se vrátili zpět, ");
INSERT INTO ceslb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ale Marie zůstala u hrobu a plakala. ");
INSERT INTO ceslb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Náhle spatřila v hrobce dva anděly v bílém; seděli na obou koncích kamenné lavice, na níž předtím spočívalo Ježíšovo tělo. ");
INSERT INTO ceslb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","„Ženo, proč pláčeš?“ zeptali se jí. „Vzali mého Pána a nevím, kam ho uložili.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Když to řekla, obrátila se a spatřila, že za ní někdo stojí. ");
INSERT INTO ceslb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Neznámý ji oslovil: „Ženo, proč pláčeš? Koho hledáš?“ Myslela, že je to zahradník, a odpověděla: „Pane, jestli jsi ho odnesl, řekni mi, kam jsi ho uložil, a já ho pochovám.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ježíš jí řekl: „Marie!“ Pohlédla na něj a řekla: „Můj Mistře!“ a poklekla před ním. ");
INSERT INTO ceslb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","„Nedotýkej se mne!“ varoval ji Ježíš, „ještě jsem se nevrátil k svému Otci. Běž a pověz bratřím, že odcházím k svému i vašemu Bohu a Otci.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Marie Magdaléna vyhledala učedníky a řekla jim: „Viděla jsem Pána,“ a sdělila jim, co jí uložil. ");
INSERT INTO ceslb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Téhož dne večer byli učedníci pohromadě za zamčenými dveřmi, protože se báli, že teď přijdou Židé na ně. Pojednou stál Ježíš mezi nimi a řekl: „Pokoj vám!“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Potom jim ukázal rány v rukou a v boku. To byla radost pro učedníky, že zase vidí svého Pána! ");
INSERT INTO ceslb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ježíš opakoval: „Pokoj vám!“ a pokračoval: „Otec vyslal mne a já vysílám vás.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dýchl na ně a řekl: „Přijměte svatého Ducha! ");
INSERT INTO ceslb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Komu budete zvěstovat odpuštění hříchů a kdo je přijme, tomu bude odpuštěno. Komu tu zvěst zadržíte, zůstává ve svém hříchu.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toho večera chyběl mezi učedníky Tomáš, kterému přezdívali Dvojče. ");
INSERT INTO ceslb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ostatní mu o setkání s Ježíšem vyprávěli, ale on pochyboval: „Neuvěřím, dokud neuvidím a neohmatám rány na jeho rukou a boku.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Po týdnu byli učedníci znovu spolu a tentokrát byl s nimi i Tomáš. Dveře byly zase zamčeny, když se Ježíš mezi ně postavil a oslovil je: „Pokoj vám!“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Potom se obrátil k Tomášovi: „Podívej se a sáhni si na mé rány! Už nepochybuj, ale věř!“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomáš přesvědčen vyznal: „Jsi můj Pán a můj Bůh!“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ježíš mu na to řekl: „Viděl jsi mne, a proto věříš. Cennější však je nevidět a uvěřit.“ ");
INSERT INTO ceslb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","31","Za dobu svého působení Ježíš před zraky učedníků vykonal mnoho dalších mocných činů, které nejsou v této knize zaznamenány. Ty činy, které jsou zaznamenány, ve vás mají vzbudit víru v Ježíše jako Božího Syna a zajistit vám tak věčný život. ");
INSERT INTO ceslb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Později se Ježíš zjevil učedníkům na břehu Genezaretského jezera. ");
INSERT INTO ceslb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","3","Šimon Petr tehdy totiž řekl ostatním: „Jdu lovit ryby.“ Někteří se přidali: „Půjdeme s tebou.“ Byli to: Tomáš Dvojče, Natanael z galilejské Káně, Jakub a Jan a ještě další dva. Vypluli na jezero, ale celou noc se namáhali zbytečně. ");
INSERT INTO ceslb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Za svítání si všimli, že někdo stojí na břehu. ");
INSERT INTO ceslb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Zavolal na ně: „Přátelé, máte něco k jídlu?“ „Nemáme. Nic jsme neulovili,“ odpověděli. ");
INSERT INTO ceslb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","„Já vám poradím: Hoďte síť na pravou stranu a ulovíte!“ Uposlechli a nemohli přeplněnou síť ani utáhnout. ");
INSERT INTO ceslb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jan řekl Petrovi: „To je Pán!“ Jakmile to Petr uslyšel, přioblékl se a brodil se ke břehu. ");
INSERT INTO ceslb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ostatním učedníkům ještě chvíli trvalo, než se člunem a sítí plnou ryb překonali tu nevelkou vzdálenost. ");
INSERT INTO ceslb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Když vystoupili na břeh, uviděli ohniště, na kterém se pekla ryba a chléb. ");
INSERT INTO ceslb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","„Přineste několik ryb ze svého úlovku,“ řekl jim Ježíš. ");
INSERT INTO ceslb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Petr šel a vytáhl na břeh síť plnou velkých ryb. Napočítal jich sto padesát tři, a přesto se síť nepotrhala. ");
INSERT INTO ceslb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","„A teď se pojďte nasnídat,“ pozval je Ježíš. Nevyptávali se ho, kdo je; věděli že je to Pán. ");
INSERT INTO ceslb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ježíš jim rozdělil chléb i ryby. ");
INSERT INTO ceslb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","To bylo Ježíšovo třetí setkání s učedníky po vzkříšení. ");
INSERT INTO ceslb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Když pojedli, rozvinul se mezi Ježíšem a Petrem tento rozhovor: „Šimone, miluješ mne více než ostatní?“ „Ano, Pane, ty víš, že tě mám rád.“ „Pas mé beránky!“ ");
INSERT INTO ceslb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Podruhé se zeptal: „Miluješ mne, Šimone?“ „Ano, Pane, ty víš, že tě mám rád.“ „Pečuj o mé ovce!“ ");
INSERT INTO ceslb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Zeptal se ho ještě potřetí: „Šimone, máš mne rád?“ Petra zarmoutilo, že se ho potřetí zeptal, zda ho má rád, a odpověděl: „Pane, ty víš všechno, i to, že tě mám rád.“ „Starej se o mé ovečky! – ");
INSERT INTO ceslb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na jedno však nezapomeň: Donedávna jsi chodil, kam jsi chtěl. Jako stařec rozpřáhneš ruce, přivážou tě a povedou vstříc smrti.“ ");
INSERT INTO ceslb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tím mu chtěl naznačit, že bude ukřižován a touto smrtí oslaví Boha. A pak ještě dodal: „Následuj mne!“ ");
INSERT INTO ceslb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petr si všiml, že za nimi jde učedník, který byl Ježíšovi tak blízký. (Ten se při poslední večeři ptal, kdo Ježíše zradí.) ");
INSERT INTO ceslb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petr se zeptal: „Pane, co bude s ním?“ ");
INSERT INTO ceslb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ježíš odpověděl: „Kdybych ho tu ponechal až do svého příchodu, je to moje věc. Nestarej se o to, ale pojď mojí cestou!“ ");
INSERT INTO ceslb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","O tom učedníkovi se rozhlásilo, že nezemře, ale Ježíš nic takového neřekl. ");
INSERT INTO ceslb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Je to učedník, který to všechno zaznamenal, a jeho svědectví je spolehlivé. ");
INSERT INTO ceslb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ježíš učinil ještě mnoho jiného, co tu není zaznamenáno. Kdyby se to všechno mělo vypsat, svět by to nemohl pochopit. To, co je zapsáno, stačí, abyste uvěřili, že Ježíš je Kristus, Boží Syn, a aby se vám v něm otevřel věčný život.");
INSERT INTO ceslb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Milý Teofile, také tuto druhou knihu věnuji tobě. V té první jsem se snažil zachytit vše, co Ježíš dělal a učil od počátku ");
INSERT INTO ceslb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","až do svého odchodu k Bohu. Tehdy dal také poslední pokyny o Duchu svatém úzkému kruhu svých učedníků. V období čtyřiceti dnů od své smrti a zmrtvýchvstání se s nimi setkával, dokázal jim, že je opravdu živ, a pověděl jim, že se vrátí, aby uskutečnil Boží záměr se světem. ");
INSERT INTO ceslb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Když byli ještě pospolu, řekl jim, aby po jeho odchodu neopouštěli Jeruzalém, ale čekali tam, až Bůh vyplní svůj slib. ");
INSERT INTO ceslb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Vysvětlil jim: „Jan křtil vodou, ale vás Bůh v nejbližších dnech pokřtí svým svatým Duchem.“ ");
INSERT INTO ceslb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Učedníci se ho také otázali: „Pane, teď už konečně vezmeš do ruky vládu nad Izraelem?“ ");
INSERT INTO ceslb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Odpověděl: „Není vaše starost, kdy to bude! Nechte to na Bohu, který jedná podle svých rozhodnutí. ");
INSERT INTO ceslb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Teď dostanete Ducha svatého a s ním zvláštní sílu k tomu, abyste se stali mými vyslanci nejen v Jeruzalémě, ale v celém Judsku, v Samařsku a po celém světě.“ ");
INSERT INTO ceslb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Potom byl před jejich očima zdvižen vzhůru a zakryt oblakem. ");
INSERT INTO ceslb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Když se upřeně dívali za ním, objevili se vedle nich dva muži v bílém ");
INSERT INTO ceslb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a oslovili je: „Galilejci, co tu tak stojíte a díváte se do oblak? Ježíš od vás odešel do nebe, aby se jednou vrátil stejným způsobem.“ ");
INSERT INTO ceslb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","To se stalo na Olivové hoře, jen asi čtvrt hodiny cesty od Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Vrátili se do města, kde v horní místnosti domu bydleli společně Petr, Jakub, Jan, Ondřej, Filip, Tomáš, Bartoloměj, Matouš, Jakub – syn Alfeův, Šimon Zélot a Juda – syn Jakubův. ");
INSERT INTO ceslb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ti všichni se jednomyslně a vytrvale modlívali a s nimi ještě některé ženy, Ježíšova matka Marie a Ježíšovi bratři. ");
INSERT INTO ceslb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na jednom shromáždění, kde se sešlo asi sto dvacet Ježíšových následovníků, vystoupil Petr a řekl: ");
INSERT INTO ceslb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","„Bratři, Jidáš byl jeden z nás, dvanácti apoštolů. Dostal stejné pověření jako my, a přece se propůjčil k tomu, že přivedl na Ježíše stráž, aby ho zatkla. Pak se sám zprovodil ze světa tak hrozným způsobem, že mu až vyhřezly vnitřnosti. ");
INSERT INTO ceslb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","19","Za jeho zrádcovskou odměnu byl koupen pozemek, kterému dnes jeruzalémští obyvatelé říkají ‚Hakeldama‘ – Krvavé pole. Tak se naplnila předpověď Bible. To Duch svatý vložil Davidovi do úst slova o Jidášovi, ");
INSERT INTO ceslb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","která jsou zaznamenána v Žalmech: ‚ať zpustne jeho dům, ať v něm nikdo nebydlí,‘ a jinde: ‚…jeho pověření ať převezme jiný.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Je tedy nutné nahradit Jidáše. Vyberme muže, který s námi následoval Pána Ježíše po celou dobu od chvíle, ");
INSERT INTO ceslb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kdy ho pokřtil Jan, a byl s ním až do jeho odchodu do nebe. Takový ať se spolu s námi stane jedním ze svědků Ježíšova zmrtvýchvstání.“ ");
INSERT INTO ceslb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Vybrali dva takové: Josefa Barsabáše, kterému se říkalo Justus, a Matěje. ");
INSERT INTO ceslb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Potom se modlili: „Ty, Pane, znáš srdce každého člověka. Ukaž, kterého z těchto dvou jsi vybral, ");
INSERT INTO ceslb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","aby byl tvým apoštolem místo Jidáše, který zradil.“ ");
INSERT INTO ceslb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dali jim vytáhnout los, a ten označil Matěje. Tak se tedy připojil k jedenácti apoštolům. ");
INSERT INTO ceslb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Padesát dní po Velikonocích začaly Letnice, svátek vděčnosti za úrodu. Kristovi následovníci se opět shromáždili. ");
INSERT INTO ceslb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Náhle se ozval zvláštní zvuk, jako by celým domem zavanul silný vítr. ");
INSERT INTO ceslb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tu se jim objevil plápolající oheň, který se rozdělil a hořel nad každým z nich. ");
INSERT INTO ceslb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A všichni byli naplněni Duchem svatým. Projevilo se to tím, že získali schopnost mluvit cizími jazyky, které předtím neovládali. ");
INSERT INTO ceslb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","V Jeruzalémě byli na svátky zbožní židé, kteří jinak žili mimo Palestinu v různých zemích a s různými národy. ");
INSERT INTO ceslb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ten zvláštní zvuk přilákal zástup těchto poutníků a oni teď naslouchali učedníkům. Přitom každý slyšel, že učedníci mluví jeho rodným jazykem. ");
INSERT INTO ceslb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","To je velice překvapilo a vzrušeně o tom hovořili: „Vždyť je známe, to jsou přece samí prostí Galilejci! ");
INSERT INTO ceslb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A každý z nás je slyší ve svém rodném jazyce! Mluví o tom, že Bůh udělal něco velikého.“ ");
INSERT INTO ceslb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mezi posluchači byli Partové, Médové, Elamité, Mezopotámci, Judejci, lidé z Kapadokie, od Černého moře a z Malé Asie, ");
INSERT INTO ceslb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","z Frýgie, Pamfýlie, z Egypta, Libye, z Říma, Kréty i Arábie, ");
INSERT INTO ceslb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","rození židé i na židovskou víru obrácení pohané. ");
INSERT INTO ceslb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ptali se mezi sebou: „Co se to děje?“ ");
INSERT INTO ceslb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ale někteří se tomu smáli a říkali: „Vždyť jsou opilí!“ ");
INSERT INTO ceslb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tu vystoupilo dvanáct apoštolů do popředí a Petr promluvil k zástupu: „Židé a vy všichni, kteří jste právě v Jeruzalémě! Vysvětlím vám, co se zde děje, ale prosím vás o pozornost. ");
INSERT INTO ceslb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Určitě nejsme opilí, jak se nám někteří posmívají. Vždyť je teprve devět hodin, doba ranních modliteb. ");
INSERT INTO ceslb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tady se však plní, co předpověděl prorok Jóel: ");
INSERT INTO ceslb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‚Bůh říká: V posledních dnech sešlu svého Ducha na lidi, vaši synové a dcery budou prorokovat, mladí budou mít vidění a staří významné sny. ");
INSERT INTO ceslb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Moji služebníci a služebnice dostanou mého Ducha a stanou se proroky. ");
INSERT INTO ceslb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na obloze i na zemi se objeví zvláštní úkazy, krev, oheň a sloupy dýmu, ");
INSERT INTO ceslb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","slunce se zatmí a měsíc zrudne. To bude znamením, že Pán přichází soudit všechny lidi. ");
INSERT INTO ceslb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jenom ten, kdo ho uznává svým Pánem, bude zachráněn.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","23","Izraelci, poslyšte! Žil tady mezi vámi Ježíš z Nazaretu, muž, kterému dal Bůh moc činit zázraky a znamení; mnozí z vás by to mohli dosvědčit. A tohoto muže jste se vy zmocnili a zabili jste ho na kříži rukama pohanů. Tím jste vlastně jen splnili Boží úmysl. ");
INSERT INTO ceslb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bůh však vyrval Ježíše z moci smrti, která ho nemohla udržet, a vzkřísil ho z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","To o něm zpívá David v žalmu: ‚Pána mám neustále před očima, stojí při mně, a tak nezakolísám. ");
INSERT INTO ceslb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Proto se mé srdce raduje, moje ústa zpívají, vždyť i pro mé mrtvé tělo zůstává naděje. ");
INSERT INTO ceslb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ty mne nenecháš mezi mrtvými, nedopustíš, aby tělo tvého vyvoleného podlehlo zkáze. ");
INSERT INTO ceslb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Povedeš mne cestou života a dáš mi, abych se radoval u tebe.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Je nám všem jasné, že dávný král David zemřel, byl pochován a jeho hrob je tady až dodnes. ");
INSERT INTO ceslb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nemluvil tedy o sobě, ale prorokoval to o Mesiáši, který podle Božího slibu měl být Davidovým potomkem. A tak když říkal, že nezůstane mezi mrtvými a jeho tělo nepodlehne zkáze, ");
INSERT INTO ceslb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","viděl vlastně dopředu Kristovo vzkříšení z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ano, právě Ježíše Bůh vzkřísil a my všichni to můžeme dosvědčit. ");
INSERT INTO ceslb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyní je na nebesích po Boží pravici a má právo dávat svatého Ducha. Všechno to zvláštní, co vidíte a slyšíte, pochází od něho. ");
INSERT INTO ceslb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","A zase David nemluvil o sobě, když napsal: ‚Bůh řekl mému Pánu: Seď po mé pravici, až ti všechny nepřátele položím k nohám.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ať tedy ví každý Izraelec: Toho Ježíše, kterého jste ukřižovali, toho poslal Bůh jako Pána a Mesiáše!“ ");
INSERT INTO ceslb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petrova slova zasáhla mnoho posluchačů a ti se začali ptát apoštolů: „Bratři, co máme dělat?“ ");
INSERT INTO ceslb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","„Litujte svých hříchů,“ volal Petr, „vyznávejte je a na znamení Božího odpuštění přijměte křest, který Ježíš Kristu určil pro své následovníky. Také vy dostanete Ducha svatého. ");
INSERT INTO ceslb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Vždyť ten prorocký slib platí vám, vašim dětem, a dokonce lidem po celém světě, které si Pán Bůh zavolá.“ ");
INSERT INTO ceslb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A ještě jim říkal mnoho dalších věcí a radil jim naléhavě: „Nemějte už nic společného s těmi, kteří se postavili proti Mesiáši!“ ");
INSERT INTO ceslb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ti, kteří Petra poslechli, byli nakonec pokřtěni. Toho dne se připojilo k Ježíšovým následovníkům okolo tří tisíc lidí. ");
INSERT INTO ceslb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Všichni chtěli slyšet od apoštolů ještě více, bývali rádi pohromadě, společně stolovali, lámali chléb na památku Kristovy poslední večeře a modlili se. ");
INSERT INTO ceslb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apoštolové činili mnoho mocných činů a divů, takže každý cítil, že tu působí Bůh. ");
INSERT INTO ceslb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Věřící vytvořili pospolitost, ve které se o všechno dělili a dokonce majetek měli společný. ");
INSERT INTO ceslb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Zámožní mezi nimi prodávali své nemovitosti a výtěžek dělili mezi všechny, jak kdo potřeboval. ");
INSERT INTO ceslb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Všichni se společně shromažďovali každý den v jeruzalémském chrámu. V menších skupinách se pak scházeli po domech a jedli společně, s radostí a upřímností. ");
INSERT INTO ceslb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Svou vděčnost Bohu vyjadřovali modlitbami a zpěvem, a kdo to slyšel, tomu se to líbilo. Pán jim denně přidával další, kteří uvěřili a byli zachráněni. ");
INSERT INTO ceslb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petr a Jan šli jednou ve tři hodiny do chrámu, aby se zúčastnili pravidelných odpoledních modliteb. ");
INSERT INTO ceslb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mezi četnými žebráky tam byl také muž chromý od narození, kterého jeho přátelé každý den přinesli a posadili u chrámových vrat, zvaných Krásná brána. Chodilo tudy hodně lidí a on je prosil o almužnu. ");
INSERT INTO ceslb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tak požádal i Petra s Janem. ");
INSERT INTO ceslb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Zastavili se u něho a Petr mu řekl: „Podívej se na nás!“ ");
INSERT INTO ceslb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Žebrák dychtivě zvedl oči, protože čekal dobrou almužnu. ");
INSERT INTO ceslb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petr však pokračoval: „Peníze nemám, ale dám ti cennější dar. Ve jménu Ježíše Krista Nazaretského, vstaň a choď!“ ");
INSERT INTO ceslb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pak uchopil žebráka za napřaženou pravici, pozvedl ho a v tom okamžiku do ochrnutých nohou vstoupila síla. ");
INSERT INTO ceslb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Postavil se, zkusil chodit a za chvíli už mohl jít dovnitř chrámu spolu s apoštoly. Dokonce radostně poskakoval a hlasitě chválil Boha. ");
INSERT INTO ceslb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","11","Lidé nevěřili svým očím, ale jasně poznávali, že dlouholetý mrzák, který žebrával u Krásné brány, teď chodí a z vděčnosti k Bohu prozpěvuje. Sbíhali se kolem uzdraveného i kolem apoštolů, kteří zatím došli do Šalomounova podloubí. ");
INSERT INTO ceslb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","A tak k nim Petr začal mluvit: „Přátelé, proč se divíte? Snad si nemyslíte, že jsme toho člověka uzdravili vlastní mocí nebo mimořádnou zbožností? ");
INSERT INTO ceslb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kdepak! To Bůh, kterého vyznáváte, Bůh našich praotců – Abrahama, Izáka a Jákoba – tu právě před vámi dokázal moc svého Syna Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Toho Ježíše, kterého vy jste vydali Římanům a veřejně jste se ho zřekli před Pilátem, ačkoliv ho chtěl zprostit obžaloby. A když vám dal vybrat, koho má propustit, vy jste se zřekli svatého a spravedlivého muže a vyžádali jste milost pro vraha. ");
INSERT INTO ceslb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Toho, kdo vám chtěl dát věčný život, jste zabili! Ale Bůh ho vzkřísil z mrtvých a my to můžeme osobně dosvědčit. ");
INSERT INTO ceslb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Protože v něho věříme, dal nám sílu uzdravit tohoto muže, kterého znáte po léta jako bezmocného. To, že je teď zdráv, je výsledkem víry v Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Uvědomuji si však, bratři, že jste se Ježíše zřekli z nevědomosti a že ani vaši vůdcové netušili, o koho se jedná. ");
INSERT INTO ceslb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bůh tak vlastně dopustil, aby Kristus trpěl, jak to už dávno předpověděl ústy svých proroků. ");
INSERT INTO ceslb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Přiznejte svou vinu na tomto hrozném činu a proste Boha, aby vám odpustil. ");
INSERT INTO ceslb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Pak se i vy budete moci těšit na dobu, kdy Bůh znovu pošle Ježíše jako vašeho osvoboditele. ");
INSERT INTO ceslb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Teď je v nebi a zůstane tam až do chvíle, kdy se Bůh rozhodne obnovit celý svět, jak to také předpovídali proroci. ");
INSERT INTO ceslb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tak například Mojžíš přece řekl: ‚Z vašeho národa jednou Bůh povolá nového proroka, podobně jako k vám poslal mne, ale toho budete skutečně poslouchat na slovo. ");
INSERT INTO ceslb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kdo by se mu nepodřídil, nebude už náležet mezi Boží vyvolené.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel a všichni další proroci mluvili často o době, kterou my právě prožíváme. ");
INSERT INTO ceslb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vy jste syny těch proroků a máte dědický podíl v úmluvě mezi Bohem a Abrahamem. Bůh přece Abrahamovi slíbil: ‚Tvůj potomek bude požehnáním pro všechny národy země.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Vám na prvním místě poslal Bůh svého Syna Ježíše, aby vám přinesl všechno dobré a odvrátil vás od vašich špatností.“ ");
INSERT INTO ceslb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Zatímco Petr a Jan mluvili, přivedli na ně kněží a saducejové velitele chrámové stráže. ");
INSERT INTO ceslb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","3","Ten je zatkl, a protože byl už večer, vzal je do druhého dne do vazby. Kněze totiž popudilo, že Petr a Jan učili lidi v chrámu a hlásali, že Ježíš vstal z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ale mnozí z posluchačů jim uvěřili, takže počet věřících už dosáhl asi pěti tisíc mužů. ");
INSERT INTO ceslb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Příštího dne právě zasedala v Jeruzalémě židovská velerada – shromáždění politických i náboženských předáků a učitelů zákona, kterému předsedal úřadující velekněz Kaifáš. Byl tam také jeho předchůdce Annáš a dále Jan, Alexandr a ostatní příslušníci velekněžského rodu. ");
INSERT INTO ceslb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dali si předvést Petra a Jana, Ježíšovy apoštoly, a začali je vyslýchat. Chtěli vědět, jaká to je moc, kterou uzdravili chromého, a kdo jim ji svěřil. ");
INSERT INTO ceslb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na to Petr odpověděl z popudu svatého Ducha: „Vůdcové a představitelé národa! ");
INSERT INTO ceslb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vyslýcháte nás pro dobrý skutek a chcete vědět jak to, že postižený mohl být uzdraven. ");
INSERT INTO ceslb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Prohlašujeme tedy jasně před vámi a před celým Izraelem, že jsme to udělali ve jménu Ježíše Krista Nazaretského, kterého jste vy ukřižovali, ale Bůh ho vzkřísil z mrtvých. Je to jeho moc, která postavila na nohy úplně chromého člověka. ");
INSERT INTO ceslb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na Ježíše se vztahuje Izajášovo proroctví: ‚To je ten kámen, který jste vy, stavitelé, odložili, ale který se stal hlavním kamenem celé klenby.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jenom on je Spasitel a nečekejte, že se ozve ještě jiné jméno, které by znamenalo záchranu.“ ");
INSERT INTO ceslb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Členové velerady se podivili, jak odvážně a jasně Petr promluvil. Věděli totiž, že on i Jan jsou jen prostí, nevzdělaní lidé, a byli překvapeni, jaký vliv na ně měl pobyt s Ježíšem. ");
INSERT INTO ceslb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Předvolali uzdraveného a ten teď stál vedle apoštolů jako živý doklad jejich slov. Nikdo z velerady nevěděl jak dál, ");
INSERT INTO ceslb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","a tak dali zase apoštoly odvést a radili se, co s nimi. ");
INSERT INTO ceslb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","„Nemůžeme zakrýt, že udělali nesporný zázrak,“ přiznávali. „Už to ví celý Jeruzalém. ");
INSERT INTO ceslb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Musíme však zabránit tomu, aby se ty jejich zvěsti šířily dál. Postrašíme je, aby už o Ježíšovi nikomu nevyprávěli.“ ");
INSERT INTO ceslb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Zavolali je zpátky a důrazně jim přikázali, že už o Ježíšovi nesmí mluvit. ");
INSERT INTO ceslb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Petr s Janem odpověděli: „Myslíte, že je správné, abychom dali víc na vás než na Boha? ");
INSERT INTO ceslb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nemůžeme přece zamlčet, co jsme viděli a slyšeli.“ ");
INSERT INTO ceslb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Velerada jim ještě vyhrožovala, ale pak je propustila. Neodvažovali se apoštoly potrestat, protože se báli, že by se lid bouřil. Všichni totiž děkovali Bohu za tento zázrak. ");
INSERT INTO ceslb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Vždyť tomu uzdravenému člověku bylo už přes čtyřicet let. ");
INSERT INTO ceslb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jakmile se Petr s Janem dostali na svobodu, šli ke svým a vyprávěli jim, co bylo ve veleradě. ");
INSERT INTO ceslb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Když to všechno vypověděli, modlili se společně: „Pane Bože, ty jsi stvořil nebe, zemi i moře a všechno, co žije. ");
INSERT INTO ceslb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ty jsi vnukl Davidovi slova: ‚Proč se lidé bouří a národy se obírají marnými plány? ");
INSERT INTO ceslb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pozvedají se pozemští králové a vladaři se spolu umlouvají proti Pánu a jeho Mesiáši.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A skutečně se spojil král Herodes s místodržitelem Pilátem, Izraelci neváhali spřáhnout se s pohany, aby zabili tvého svatého Syna Ježíše, kterého jsi ustanovil Vysvoboditelem. ");
INSERT INTO ceslb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Vykonali však jenom to, co jsi předem určil a rozhodl. ");
INSERT INTO ceslb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Pane, teď vyhrožují také nám. Prosíme, dej nám odvahu, abychom tvoje slovo mluvili s odvahou a bez zábran, ");
INSERT INTO ceslb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","a dávej nám i dále svoji moc, abychom ve jménu tvého Svatého Syna Ježíše mohli činit zázraky na důkaz pravdivosti našeho zvěstování.“ ");
INSERT INTO ceslb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ještě během této modlitby se pod nimi zachvěla země a všichni shromáždění byli naplněni svatým Duchem. A tak dále odvážně hlásali Boží poselství. ");
INSERT INTO ceslb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Všichni ti věřící byli podivuhodně jednomyslní. Nikdo z nich nepovažoval nic za vlastní, ale dávali vše ke společnému užívání. ");
INSERT INTO ceslb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Svědectví apoštolů o vzkříšení Pána Ježíše bylo velmi přesvědčivé a všichni se navzájem měli rádi. ");
INSERT INTO ceslb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Netrpěli mezi sebou chudobu a bídu; majitelé pozemků a domů prodávali své nemovitosti ");
INSERT INTO ceslb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a skládali stržené peníze u apoštolů. Ti je rozdělovali všem potřebným. ");
INSERT INTO ceslb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Tak prodal a obětoval své pole také muž, o kterém později ještě uslyšíme: Josef, kterému dali apoštolové přezdívku Barnabáš (to znamená Syn útěchy). Byl z rodu lévijských chrámových pomocníků, ale narodil se na Kypru. ");
INSERT INTO ceslb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Svůj pozemek prodal i jistý Ananiáš a jeho manželka Zafira. ");
INSERT INTO ceslb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ti se však domluvili, že část získaných peněz odnese Ananiáš apoštolům a bude je vydávat za celou částku. ");
INSERT INTO ceslb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ale Petr mu řekl: „Ananiáši, tento podvod ti poradil sám ďábel. Tím, že se nás snažíš obelstít a vydáváš částku za celek, obelháváš vlastně svatého Ducha. ");
INSERT INTO ceslb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Vždyť to pole bylo tvoje a mohl sis je klidně nechat. I stržené peníze patřily tobě a nikdo z nás by ti nevyčítal, kdyby sis je byl všechny ponechal. Co tě to jen napadlo? Chtěl jsi podvést nejen lidi, ale samotného Boha.“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Když to Ananiáš vyslechl, zhroutil se mrtev na zem. Všechny, kdo se to dověděli, naplnila hrůza. ");
INSERT INTO ceslb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Několik mladých mužů vyneslo Ananiášovo tělo, aby ho pohřbili. ");
INSERT INTO ceslb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Asi za tři hodiny přišla také Zafira, která netušila, co se mezitím odehrálo. ");
INSERT INTO ceslb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petr se jí zeptal: „Poslyš, Zafiro, prodali jste to pole za tolik a za tolik?“ Odpověděla: „Ano, jistě za tolik.“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Na to Petr: „Proč jste se tak smluvili? To jste chtěli podvést Božího Ducha? Právě se vracejí chlapci, kteří pohřbili tvého muže. A tebe stihne stejný trest jako Ananiáše.“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Zafira padla k Petrovým nohám a zemřela. Ti mládenci právě vešli do dveří a hned museli jít vykonat ještě druhý pohřeb do stejného hrobu. ");
INSERT INTO ceslb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","To se samozřejmě rychle rozkřiklo nejen mezi věřícími, ale i mezi ostatními lidmi a všemi to hluboce otřáslo. ");
INSERT INTO ceslb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apoštolové se pravidelně scházeli v Šalomounově podloubí v chrámu, ");
INSERT INTO ceslb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","kde se je nikdo neodvážil rušit. Stali se totiž mezi jeruzalémským lidem velmi populárními pro divy a zázračná uzdravení, která se děla jejich prostřednictvím. ");
INSERT INTO ceslb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Došlo to tak daleko, že když měl jít Petr do chrámu nebo zpět, lidé podél cesty připravovali nemocné na rohožích a nosítkách, aby na ně padl alespoň Petrův stín. ");
INSERT INTO ceslb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dokonce z širého okolí snášeli do Jeruzaléma nemocné a pomatené a všichni byli uzdraveni. A mnoho dalších mužů a žen uvěřilo Pánu a připojilo se k církvi. ");
INSERT INTO ceslb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Toto hnutí vyvolalo žárlivost a strach především u nejvyššího kněze a jeho přívrženců – saducejů. Ti totiž učili, že se žádné zázraky – a natož vzkříšení z mrtvých – nedějí. ");
INSERT INTO ceslb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dali proto apoštoly zatknout a uvěznit, tentokrát do městské věznice. ");
INSERT INTO ceslb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Boží anděl však v noci otevřel dveře žaláře, vyvedl apoštoly ven a povzbudil je: ");
INSERT INTO ceslb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","„Nebojte se, jděte zase do chrámu a říkejte lidem, jak mohou dosáhnout věčného života!“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Poslechli a už na úsvitě byli v chrámu a učili. Mezitím velekněz a jeho stoupenci svolali zasedání velerady a přikázali, aby byli apoštolové předvedeni. ");
INSERT INTO ceslb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Chrámoví strážci však našli vězení prázdné, vrátili se a podali hlášení: ");
INSERT INTO ceslb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","„Věznice je v naprostém pořádku, dveře zamčené, strážní u nich drželi řádně hlídku, ale když jsme odemkli, uvnitř nikdo nebyl.“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Velekněz, velitel a jeho chrámová stráž vyslechli tu zprávu a byli zmateni. Nevěděli, co si o tom mají myslet. ");
INSERT INTO ceslb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Vtom někdo přiběhl a hlásil: „Ti muži, které jste včera uvěznili, jsou zase v chrámu a klidně mluví k lidem!“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Velitel tam spěchal se stráží, ale neodvážili se žádného násilí, protože lid by je ukamenoval. ");
INSERT INTO ceslb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Apoštolové však s nimi šli dobrovolně před veleradu. Velekněz je obvinil: ");
INSERT INTO ceslb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","„Copak jsme vám nezakázali Ježíšovo jméno veřejně vyslovit? Jak to, že jste naplnili celý Jeruzalém svými výklady o něm a nás označujete za jeho vrahy?“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petr promluvil jménem ostatních apoštolů: „Boha přece musíme poslechnout víc než lidi. ");
INSERT INTO ceslb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","To Bůh našich praotců vzkřísil z mrtvých Ježíše, kterého jste vy zabili potupným způsobem na římském kříži. ");
INSERT INTO ceslb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bůh mu však svěřil veliký úkol Mesiáše a Vysvoboditele. Jenom on může Izraeli odpustit jeho hříchy, když se mu ovšem pokoříte. ");
INSERT INTO ceslb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","My jsme svědkové všeho, co říkáme. Jasným dokladem vám může být moc svatého Ducha, kterou Bůh dal těm, kdo si už dali říct a učinili pokání.“ ");
INSERT INTO ceslb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","To ovšem veleradu rozzuřilo a ozvalo se volání, aby byli apoštolové popraveni. ");
INSERT INTO ceslb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","O slovo se však přihlásil známý farizejský učitel zákona Gamaliel, muž značné autority, a dal pokyn, aby na chvíli obžalované odvedli. ");
INSERT INTO ceslb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pak oslovil veleradu: „Izraelci, dobře si rozmyslete, co chcete udělat s těmito lidmi. ");
INSERT INTO ceslb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Vzpomínáte na rozruch kolem Teuda? Ten ze sebe dělal velkou osobnost a shromáždil na čtyři sta přívrženců. Když však zemřel, jeho lidé se rozprchli a všechno utichlo. ");
INSERT INTO ceslb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nebo vzpomeňte na povstání Judy z Galileje za sčítání lidu. Měl hodně následovníků, ale i on zahynul a jeho tlupa se rozptýlila. ");
INSERT INTO ceslb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","A tak vám radím, nechte ty lidi prostě na pokoji. Jestli je to zase nějaké lidské hnutí, brzo se rozpadne. ");
INSERT INTO ceslb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Stojí-li však za tím Bůh, nic proti tomu nezmůžete a vlastně byste se snažili bojovat s Bohem.“ Dali na jeho radu. ");
INSERT INTO ceslb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Opět předvedli apoštoly, vyměřili jim obvyklý trest bičování a znovu jim přísně zakázali hlásat cokoliv o Ježíšovi a šířit jeho učení. Pak je propustili. ");
INSERT INTO ceslb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apoštolové šli ze soudu a radovali se, že byli vyznamenáni těžkostmi a utrpením pro jméno Pána Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Učili i nadále každý den o Ježíšovi a jak v soukromí, tak na veřejnosti ho prohlašovali za Božího Syna. ");
INSERT INTO ceslb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jak církev rychle rostla, vyskytly se neshody. Řecky mluvící křesťané si stěžovali, že jejich vdovám se dostává méně podpory než vdovám po křesťanech ze židovského prostředí. ");
INSERT INTO ceslb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dvanáct apoštolů svolalo společné shromáždění celého sboru a předložilo tento návrh: „My se musíme plně věnovat rozhlašování Božího poselství a nemůžeme tedy ještě dohlížet na pořádek a spravedlnost při rozdílení jídla. ");
INSERT INTO ceslb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Navrhujeme vám, bratři, abyste ze svého středu zvolili sedm mužů, kteří se už osvědčili, jsou naplněni svatým Duchem a dovedou moudře rozhodovat. Těm svěříme starost o hmotnou pomoc ve sboru, ");
INSERT INTO ceslb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","abychom se my mohli plně soustředit na modlitby a kázání.“ ");
INSERT INTO ceslb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Sborové shromáždění souhlasilo s návrhem apoštolů a hned přistoupilo k volbě. Zvoleni byli: Štěpán, muž neobyčejně silné víry a plný Ducha svatého, Filip, Prochorus, Nikánor, Timón, Parménas a Mikuláš, který již dříve v Antiochii přestoupil z pohanství k židovskému náboženství. ");
INSERT INTO ceslb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Po volbě se těch sedm postavilo před apoštoly, kteří se modlili a pak jim udělili pro jejich práci zvláštní požehnání. ");
INSERT INTO ceslb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Toto nové rozdělení práce prospělo šíření Božího poselství a k jeruzalémskému sboru věřících se připojovali stále další a další lidé. Dokonce uvěřila v Krista i početná skupina židovských kněží. ");
INSERT INTO ceslb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Štěpán byl tak naplněn vírou, že měl moc ke konání zázračných činů mezi lidmi. ");
INSERT INTO ceslb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jednou se dostal do diskuse s příslušníky takzvané Synagogy propuštěnců, židovského sboru, který shromažďoval bývalé otroky z Kyrenaiky, Alexandrie, Kilikie a Malé Asie. ");
INSERT INTO ceslb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Když viděli, že jejich argumenty neobstojí před Štěpánovou moudrostí a Božím Duchem, který z něho mluvil, ");
INSERT INTO ceslb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","nastrčili proti němu křivé žalobce. Ti ho falešně obvinili: „Slyšeli jsme, jak se posmíval Mojžíšovu zákonu a jak se rouhal samotnému Bohu!“ ");
INSERT INTO ceslb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tak poštvali proti Štěpánovi prosté lidi i některé učitele zákona. Nakonec byl Štěpán zatčen a předveden před veleradu. ");
INSERT INTO ceslb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Falešní svědci tam zopakovali své tvrzení: „Ten člověk stále jen pobuřuje proti chrámu a Mojžíšovu zákonu. ");
INSERT INTO ceslb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Slyšeli jsme, jak říká, že Ježíš z Nazaretu zničí chrám a dá nám nové zákony!“ ");
INSERT INTO ceslb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Po tomto obvinění se všichni obrátili na obžalovaného. Stál tam a z obličeje mu zářil přímo andělský klid. ");
INSERT INTO ceslb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Předsedající kněz ho vyzval: „Můžeš popřít tuto obžalobu?“ (Před židovskou veleradou měl obžalovaný právo obhajoby ");
INSERT INTO ceslb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","a Štěpán toho využil. Chtěl dokázat, jak zvěst o Ježíši zřetelně navazuje na Boží činy v izraelských dějinách.) „Bratři a otcové,“ oslovil je, „sám jediný Bůh se kdysi zjevil našemu předku Abrahamovi, který pocházel z Mezopotámie a později bydlil v Cháranu. ");
INSERT INTO ceslb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dal mu příkaz: ‚Vystěhuj se z rodné země a od svého kmene a putuj do země, kterou ti určím.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nejprve se tedy Abraham přestěhoval z Chaldeje do Cháranu a po smrti svého otce až do této naší vlasti. Ačkoliv měl Boží slib, že té zemi bude vládnout on i jeho potomci, ");
INSERT INTO ceslb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","nepatřil mu zde ani kousek, na který by se mohl postavit, a dokonce ani neměl dědice. ");
INSERT INTO ceslb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Další Boží předpověď Abrahamovi byla ještě podivnější: ‚Tvoji potomci se odtud vystěhují do cizí země a tam budou otročit čtyři sta let ve špatných podmínkách. ");
INSERT INTO ceslb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ten národ otrokářů však potrestám, tvoje potomky vysvobodím a budou mě vzývat v této zemi.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Viditelným znakem smlouvy Boha s člověkem se stala obřízka. A tak, když se Abrahamovi narodil syn Izák, obřezal ho. Posloupnost této smlouvy šla dále přes Izákova syna Jákoba na jeho dvanáct synů, našich patriarchů. ");
INSERT INTO ceslb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jeden z nich, Josef, se stal terčem nenávisti bratrů a oni ho prodali jako otroka do Egypta. ");
INSERT INTO ceslb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bůh však Josefa neopustil a nakonec ho vysvobodil ze všech těžkostí. Vybavil ho neobyčejnou prozíravostí a naklonil mu i samotného egyptského faraóna. Ten ho pak jmenoval svým ministrem a pobočníkem. ");
INSERT INTO ceslb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Potom celý Egypt i Palestinu zachvátil hladomor a naši praotcové prožívali těžké chvíle, když jim došly zásoby potravin. ");
INSERT INTO ceslb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jákob se doslechl, že v Egyptě se ještě prodává obilí, a poslal tam syny. ");
INSERT INTO ceslb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Při druhém nákupu se dal Josef svým bratrům poznat a představil je faraónovi. ");
INSERT INTO ceslb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pak Josef poslal pro otce Jákoba a přestěhoval celou rodinu, celkem sedmdesát pět lidí, do Egypta. ");
INSERT INTO ceslb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Usadili se tam a Jákob i naši patriarchové zůstali v Egyptě do smrti. ");
INSERT INTO ceslb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pochováni však byli v Palestině do hrobky v Šekemu, na malém pozemku, který si Abraham kdysi koupil od místních obyvatel. ");
INSERT INTO ceslb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","A tak se splnilo, o čem Bůh mluvil Abrahamovi. Zpočátku se našemu lidu dařilo v Egyptě dobře a jeho počet rostl. ");
INSERT INTO ceslb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ale přišla jiná dynastie faraónů a na Josefovy zásluhy se zapomnělo. ");
INSERT INTO ceslb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Naše předky zotročili, a protože si nepřáli, aby se rozmáhali, přikázali házet narozené hochy do řeky. ");
INSERT INTO ceslb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tehdy se narodil Mojžíš. Bylo to krásné dítě a rodiče ho tři měsíce skrývali doma. ");
INSERT INTO ceslb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Když už nemohli chlapce dále utajit, položili ho v košíku do rákosí. Našla ho faraónova dcera a dala jej vychovat, jako by to byl její syn. ");
INSERT INTO ceslb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tak se Mojžíšovi dostalo nejlepšího egyptského vzdělání a vyrostl z něho výmluvný a schopný muž. ");
INSERT INTO ceslb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Když mu bylo čtyřicet, napadlo ho, aby navštívil svůj lid. ");
INSERT INTO ceslb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Přitom uviděl, jak Egypťan nespravedlivě trápí Žida, a tak toho otrokáře zabil. ");
INSERT INTO ceslb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Už tehdy totiž tušil, že mu Bůh ukládá, aby svůj lid osvobodil z otroctví. Nenašel však u Izraelců pochopení. ");
INSERT INTO ceslb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Příštího dne se snažil usmířit dva Židy, kteří se hádali, ");
INSERT INTO ceslb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ale ten, který nebyl v právu, Mojžíše odbyl: ‚Kdo tě ustanovil za našeho vládce a soudce? ");
INSERT INTO ceslb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","To mě chceš zabít jako včera toho Egypťana?‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mojžíš se polekal a uprchl z Egypta do Midjánské země. Oženil se tam a měl dva syny. ");
INSERT INTO ceslb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Po čtyřiceti letech tohoto vyhnanství se Mojžíšovi zjevil Boží anděl v hořícím keři na Sínajské poušti. ");
INSERT INTO ceslb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Když se chtěl Mojžíš zblízka podívat na ten neobvyklý úkaz, uslyšel Boží hlas: ");
INSERT INTO ceslb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‚Já jsem Bůh tvých otců Abrahama, Izáka a Jákoba.‘ Mojžíš se vyděsil a zakryl si tvář, aby nic neviděl. ");
INSERT INTO ceslb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ale Bůh mluvil dál: ‚Zuj si opánky, vždyť stojíš na svatém místě! ");
INSERT INTO ceslb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Viděl jsem trápení svého lidu v Egyptě, slyšel jsem jejich vzdechy a jdu, abych je vysvobodil. Seber se a pojď, mám pro tebe v Egyptě úkol!‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","36","A tak prostřednictvím tohoto vidění poslal Bůh Mojžíše Izraelcům za vůdce a vysvoboditele, přestože ho před čtyřiceti lety nechtěli uznat. A on je vysvobodil, činil před jejich očima mnoho zázračných věcí už v Egyptě, pak při přechodu Rudého moře a během čtyřicetiletého putování pouštěmi. ");
INSERT INTO ceslb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Vzpomeňte si, že právě Mojžíš řekl Izraelcům: ‚Pán Bůh vám pošle proroka z vašeho národa, Vysvoboditele, tak jako k vám poslal mne; toho poslouchejte.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mojžíš byl zprostředkovatelem mezi našimi otci a Bohem, který mu na hoře Sínaji svěřil slova života, aby nám je předal. ");
INSERT INTO ceslb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Přesto ho naši otcové neposlouchali, ale bouřili se proti němu a pořád vzpomínali jen na Egypt. ");
INSERT INTO ceslb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Když se Mojžíš ze Sínaje dlouho nevracel, řekli jeho bratru Áronovi: ‚Nevíme, co se stalo s Mojžíšem, který nás vyvedl z Egypta. Udělej nám bohy, aby nás chránili na další cestě.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","A tak zhotovili sochu býčka, obětovali té modle a radovali se, jak si to dobře zařídili. ");
INSERT INTO ceslb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bůh se od nich odvrátil a dopustil, že propadli ještě horšímu modlářství. Uctívali i hvězdné mocnosti, jak o tom mluví Bůh v knize proroka Ámose: ‚Vy, že jste mi věrně sloužili a obětovali po čtyřicet let na poušti, národe izraelský? ");
INSERT INTO ceslb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Naopak, nosili jste s sebou svatyni Moleka a symbol planety Saturna, modly, které jste si sami udělali a pak jste se jim klaněli. Proto půjdete do vyhnanství až za Babylón.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bůh však nařídil Mojžíšovi, aby vybudoval Stan Smlouvy, přesnou svatyni, a dal mu pokyn, jak má vypadat. ");
INSERT INTO ceslb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tento stan přenášeli naši otcové při svém kočování pouští a pod Jozuovým vedením ho vnesli až do zaslíbené země. Ta byla tehdy domovem pohanů, ale Bůh je vytlačil, aby našim otcům udělal místo. Stan Smlouvy sloužil až do dnů krále Davida, kterého Bůh miloval. ");
INSERT INTO ceslb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ten velice stál o to, aby mohl Jákobovu Bohu vystavět chrám, ");
INSERT INTO ceslb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ale uskutečnit to směl až jeho syn Šalomoun. ");
INSERT INTO ceslb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ovšem Nejvyšší nebydlí v chrámech, které postavili lidé. U proroka Izajáše Pán říká: ");
INSERT INTO ceslb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‚Vesmír je můj trůn a země koberec pod mýma nohama. Jaký mi chcete postavit dům a kam mě chcete vtěsnat? ");
INSERT INTO ceslb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Což jsem všechno nestvořil?‘ ");
INSERT INTO ceslb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","A tak se to zase opakuje. Jste právě tak tvrdošíjní jako vaši otcové, zacpáváte si uši, zavíráte srdce a stavíte se proti svatému Duchu. ");
INSERT INTO ceslb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Byl nějaký prorok, aby ho vaši předkové nepronásledovali? Zabíjeli ty, kteří předpovídali příchod Spravedlivého, a vy jste se ho teď úplně zřekli a zavraždili jste ho! ");
INSERT INTO ceslb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dostali jste zákon přímo od Boha, ale stejně se jím neřídíte.“ ");
INSERT INTO ceslb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tato slova působila jako píchnutí do vosího hnízda. ");
INSERT INTO ceslb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ale Štěpán byl v té chvíli uchvácen Boží slávou, kterou mu dal svatý Duch zahlédnout. Díval se vzhůru ");
INSERT INTO ceslb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","a volal: „Vidím otevřené nebe a Ježíše Krista, jak stojí po Boží pravici!“ ");
INSERT INTO ceslb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tu přehlušili Štěpána křikem a zacpávali si uši, aby už nic neslyšeli. Vrhli se na něj, ");
INSERT INTO ceslb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","odvlekli ho za hradby města a tam ho ukamenovali. Ti, kdo házeli na Štěpána kameny, odložili své pláště k nohám mladého farizeje Saula, který souhlasil se Štěpánovou smrtí. ");
INSERT INTO ceslb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Štěpán nejprve stál, vzýval Boha a modlil se: „Pane Ježíši, přijmi mého ducha!“ ");
INSERT INTO ceslb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pak sražen na kolena se ještě modlil: „Pane, nepočítej jim to za vinu!“ a zemřel. ");
INSERT INTO ceslb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Kristovi následovníci odnesli Štěpánovo tělo a pohřbili je. Církev byla velice zarmoucena jeho smrtí. Pro křesťany v Jeruzalémě nastaly zlé časy a všichni – kromě apoštolů – se rozptýlili po Judsku i Samařsku. Saul se teď chopil iniciativy: pronásledoval církev, vnikal do soukromých domů a dával zatýkat věřící muže a ženy, kteří se tam scházeli. ");
INSERT INTO ceslb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ti, kdo uprchli z Jeruzaléma, se však neskrývali, ale na svých cestách šířili Boží poselství. ");
INSERT INTO ceslb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip, další ze sedmi zvolených pracovníků, se dostal do města Samaří a tam hlásal Krista. ");
INSERT INTO ceslb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Celé zástupy lidí mu pozorně naslouchaly, zvláště když se staly svědky Filipových mocných činů. ");
INSERT INTO ceslb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","8","Uzdravil totiž mnoho posedlých, ochrnutých i chromých a město bylo brzo plné těchto radostných zpráv. Mnoho mužů i žen uvěřilo Filipově zvěsti o Božím království a o tom, kdo je Ježíš Kristus, a dávali se od něho pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","V Samaří žil také nějaký Šimon, který ze sebe dělal velkou osobnost, ale vlastně jen pletl Samařanům hlavu kouzelnými triky a magií. ");
INSERT INTO ceslb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Měl však velkou autoritu u prostých i významných lidí a obecně se soudilo, že jeho síla pochází od Boha. ");
INSERT INTO ceslb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","13","Tento Šimon sledoval pozorně Filipa a zachvátila ho posvátná hrůza nad skutečnými zázraky, vykonanými Boží mocí. Vyznal víru v Krista, dal se pokřtít a skoro se od Filipa nehnul. ");
INSERT INTO ceslb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apoštolové v Jeruzalémě se dověděli, že také Samařsko přijalo Boží zvěst, a vyslali tam Petra a Jana. ");
INSERT INTO ceslb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","U Samařanů se zatím projevovala práce svatého Ducha tím, že se obraceli ke Kristu a byli pokřtěni. Petr a Jan se modlili, aby i samařským věřícím byla dána moc svatého Ducha. ");
INSERT INTO ceslb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pak na ně kladli ruce a skutečně i skrze Samařany začala působit Boží moc. ");
INSERT INTO ceslb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Když Šimon viděl, co se dělo s lidmi, na které apoštolové položili ruce, přinesl jim peníze s prosbou: ");
INSERT INTO ceslb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","„Dejte i mně tu moc, abych mohl pokládáním rukou udělovat Ducha svatého!“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petr mu řekl: „Ty tvé peníze tě ještě přivedou do zatracení. Copak myslíš, že se takový Boží dar dá koupit? ");
INSERT INTO ceslb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Předávat Ducha ti nepřísluší a ztrácíš i to, co jsi dostal, protože chceš jednat s Bohem nečestně. ");
INSERT INTO ceslb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Uznej, že je to tak, a pros Boha, snad ti tvůj špinavý úmysl odpustí. ");
INSERT INTO ceslb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Vidím, že v tobě hlodá závist a ještě nejsi osvobozen od své hříšné minulosti.“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Šimon zahanbeně prosil: „Modlete se za mne, aby mne Pán nepotrestal.“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Apoštolové také vykládali Kristova slova a dotvrzovali je tím, co na vlastní oči viděli. Také na zpáteční cestě do Jeruzaléma rozhlašovali evangelium po samařských vesnicích. ");
INSERT INTO ceslb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Filip dostal pokyn od Božího anděla: „Připrav se a jdi na silnici z Jeruzaléma do Gázy, tam, kde prochází pouští.“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip se hned vydal na cestu. Brzy uviděl průvod etiopského hodnostáře, ministra financí kandaky, jak se tehdy nazývala vládkyně Etiopie a Súdánu. Byl v Jeruzalémě, aby vzýval Boha, ");
INSERT INTO ceslb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","a teď jel zpátky a na voze si četl svitek proroka Izajáše. ");
INSERT INTO ceslb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Boží Duch vnukl Filipovi: „Dohoň ten vůz!“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip přiběhl k vozu a tu slyší, že si černoch nahlas předčítá z knihy Izajášových proroctví. Filip se zeptal: „Říká ti to něco?“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ministr mu odpověděl: „Neříká, potřeboval bych to vyložit. Pojď si ke mně sednout a pomoz mi!“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Právě četl slova: „Byl veden jako ovce na porážku, a jako beránek ztichne, když mu stříhají vlnu, tak ani on neotevřel ústa. ");
INSERT INTO ceslb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ponížili ho a nespravedlivě odsoudili. Kdo by čekal, že bude mít tolik potomků, když ho přece zabili!“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dvořan se zeptal Filipa: „Prosím tě, to mluvil prorok o sobě, nebo o někom jiném?“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","A tak Filip navázal na to prorocké slovo a ukázal, jak se vyplnilo na Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Cestou přijeli k nějaké vodě. Dvořan zvolal: „Podívej se, voda! Mohl bych i já být pokřtěn?“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip na to: „Jestliže jsi uvěřil celým srdcem, proč ne?“ A on vyznal: „Věřím, že Ježíš Kristus je Boží Syn.“ ");
INSERT INTO ceslb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Etiopský ministr dal příkaz k zastavení, vstoupil s Filipem do vody a ten ho pokřtil. ");
INSERT INTO ceslb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Když se vrátili na břeh, Kristův Duch způsobil, že se Filip ztratil dvořanovi z očí. Musel tedy pokračovat sám, ale měl velkou radost. ");
INSERT INTO ceslb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip se pak objevil v Azotu, prošel celým krajem až k Césareji a ve všech městech zvěstoval Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul se však snažil Ježíšovy následovníky zastrašit a zlikvidovat. ");
INSERT INTO ceslb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Vyžádal si od velekněze pověřující listiny pro židovské synagogy v Damašku. Chtěl tam pátrat po křesťanech, mužích i ženách, zatknout je a přivést do Jeruzaléma před soud. ");
INSERT INTO ceslb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Vydal se tam se svým doprovodem a byl již před branami Damašku, když ho obklopilo zvláštní světlo z nebe. ");
INSERT INTO ceslb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","V úleku padl na zem a uslyšel hlas: „Saule, Saule, proč mne pronásleduješ?“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Zeptal se: „Ale kdo jsi, pane?“ Pán mu odpověděl: „Já jsem Ježíš a ty mne pronásleduješ v mých učednících. Je to stejné, jako bys chtěl hlavou rozbít zeď.“ Saul zlomený hrůzou řekl: „Pane, čekám na tvoje rozkazy.“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","A Pán k němu: „Vstaň, jdi do města a tam se dozvíš další.“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Muži ze Saulova doprovodu stáli v úžasu; něco slyšeli, ale nevěděli, s kým jejich velitel mluví. ");
INSERT INTO ceslb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul se zvedl ze země, protíral si oči, ale neviděl nic; oslepl. Uchopili ho za ruce, a tak ho odvedli do Damašku. ");
INSERT INTO ceslb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tři dny trvala jeho slepota a po celou tu dobu nic nejedl ani nepil. ");
INSERT INTO ceslb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","V Damašku žil věřící muž jménem Ananiáš. Tomu se zjevil Pán Ježíš a oslovil ho jménem. Ananiáš se zeptal: „Pane, co si přeješ?“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pán mu řekl: „Vstaň a jdi do Přímé ulice. Tam v Judově domě najdeš Saula, který pochází z Tarsu. ");
INSERT INTO ceslb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Při modlitbě tě uviděl, jak k němu jdeš, kladeš na něj ruce a on znovu dostává zrak. Zjevil jsem mu i tvoje jméno.“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ale Ananiáš namítl: „Pane, o tom muži kdekdo vypráví, jak mnoho zla způsobil mezi tvými věrnými v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","I sem prý přišel s pověřením předních kněží, aby pozatýkal všechny, kdo vyznávají tvoje jméno.“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pán mu však řekl: „Přesto jdi. Já jsem si ho vybral za svůj zvláštní nástroj, který bude šířit zvuk mého jména nejen mezi židy, ale i mezi pohany a donese ho až před panovníky. ");
INSERT INTO ceslb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","A ukáži mu, že pro moje jméno hodně vytrpí.“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiáš šel a v určeném domě nalezl Saula. Položil na něj ruce a řekl: „Saule, bratře, posílá mě k tobě Pán Ježíš, který se ti ukázal na cestě k nám. Máš zase prohlédnout a být naplněn svatým Duchem.“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","A tu jako by se protrhla tma a Saul okamžitě prohlédl. Povstal a dal se pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Potom se posilnil jídlem. Připojil se k damašským následovníkům Krista a byl s nimi několik dní. ");
INSERT INTO ceslb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Brzy však začal chodit také do synagog a veřejně hlásal, že Ježíš je Boží Syn. ");
INSERT INTO ceslb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Všichni posluchači se divili a říkali: „Cožpak to není ten, kdo tak tvrdě v Jeruzalémě pronásledoval Ježíšovy vyznavače? I sem přece přišel, aby je pochytal a předvedl před veleradu.“ ");
INSERT INTO ceslb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Avšak Saula tím neumlčeli. Naopak on umlčoval damašské židy a dokazoval jim, že Ježíš je Mesiáš. ");
INSERT INTO ceslb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Když už to trvalo dlouho, domluvili se někteří z nich, že ho zabijí. ");
INSERT INTO ceslb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saul se dozvěděl o těch úkladech, ale oni dali hlídat ve dne i v noci městské brány, aby jim neunikl. ");
INSERT INTO ceslb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tak ho křesťané nakonec spustili v koši přes hradby. ");
INSERT INTO ceslb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul přišel zpět do Jeruzaléma a pokoušel se připojit k Ježíšovým následovníkům, ale všichni se ho báli; nevěřili, že by se mohl tak změnit. ");
INSERT INTO ceslb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tu se ho ujal Barnabáš, přivedl ho k apoštolům a všechno jim vyprávěl: Jak se Pán na cestě ukázal Saulovi a mluvil s ním a jak potom Saul v Damašku bez bázně hlásal Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A tak ho věřící v Jeruzalémě přijali mezi sebe a také zde směle mluvil o Pánu Ježíši. ");
INSERT INTO ceslb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Zvláště rád diskutoval s řecky mluvícími židy. Ti mu nakonec také ukládali o život. ");
INSERT INTO ceslb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Když se to dozvěděli bratři, odvedli ho tajně do Césareje a odtud ho poslali do rodného Tarsu. ");
INSERT INTO ceslb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Saulovým obrácením nastala pro sbory v Judsku, Galileji i v Samařsku pokojná doba vnitřního budování a života v oddanosti Bohu. Duch svatý mezi nimi působil, takže rostly i počtem. ");
INSERT INTO ceslb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petr podnikl okružní cestu po všech sborech a přišel tak i k věřícím v Lyddě. ");
INSERT INTO ceslb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Navštívil tam jakéhosi Eneáše, který byl už osm let ochrnutý upoután na lůžko. ");
INSERT INTO ceslb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petr mu řekl: „Eneáši, Ježíš Kristus tě uzdravuje. Vstaň a skliď si své lůžko!“ A on hned vstal. ");
INSERT INTO ceslb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Když to viděli obyvatelé Lyddy a Sáronu, uvěřili v Pána Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nedaleko Lyddy, v Joppe, žila věřící žena jménem Tabita, řecky Dorkas. Byla známá tím, jak z lásky podporovala chudé. ");
INSERT INTO ceslb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Právě v těch dnech však onemocněla a zemřela. Připravili ji k pohřbu a zatím uložili do místnosti v patře. ");
INSERT INTO ceslb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Věřící se doslechli, že Petr je v Lyddě, a poslali k němu s prosbou, aby k nim hned přišel. ");
INSERT INTO ceslb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petr šel s posly a ti ho vedli přímo nahoru do domu. Tam byl zástup plačících vdov, ty ho obklopily a ukazovaly mu šaty, které jim ušila jejich milá Dorkas. ");
INSERT INTO ceslb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petr požádal, aby všichni odešli, poklekl a modlil se. Po chvíli se obrátil k mrtvému tělu a řekl: „Tabito, vstaň!“ Ona otevřela oči, uviděla Petra a posadila se. ");
INSERT INTO ceslb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petr jí podal ruku a pomohl jí vstát. Pak zase zavolal všechny nahoru a odevzdal jim Tabitu živou. ");
INSERT INTO ceslb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","To se rychle rozkřiklo po celém Joppe a mnoho lidí uvěřilo v Pána Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petr pak bydlel dlouho v Joppe v domě koželuha Šimona. ");
INSERT INTO ceslb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","V Césareji žil římský setník Kornélius, který sloužil u takzvaného Italského pluku. ");
INSERT INTO ceslb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tento voják s celou svojí rodinou uvěřil v jediného Boha. Podporoval chudé a pravidelně se modlíval. ");
INSERT INTO ceslb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Při odpolední modlitbě, která se konala ve tři hodiny, uviděl, jak k němu přichází Boží posel, a uslyšel oslovení: „Kornélie!“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Setník na něj ustrašeně zíral a zeptal se: „Co tě ke mně přivádí, Pane?“ Anděl mu řekl: „Bůh slyší tvé modlitby a ví o tvé dobročinnosti. ");
INSERT INTO ceslb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pošli své sluhy do Joppe a pozvi k sobě Šimona zvaného Petr. ");
INSERT INTO ceslb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Bydlí v domě koželuha Šimona u moře. Petr ti poví, co máš dělat.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Potom anděl odešel. Kornélius si hned zavolal dva ze svých sluhů a jednoho oddaného vojáka ze své stráže. ");
INSERT INTO ceslb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Vysvětlil jim, co se stalo, a poslal je do Joppe. ");
INSERT INTO ceslb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Druhého dne v poledne, když se Kornéliovi poslové blížili k městu, byl Petr na ploché střeše domu, aby se tu mohl v klidu modlit. ");
INSERT INTO ceslb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dostal velký hlad, a zatímco mu připravovali jídlo, spatřil zvláštní vidění. ");
INSERT INTO ceslb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jako by se nebe otevřelo a někdo k němu spouštěl plachtu uvázanou za čtyři rohy. ");
INSERT INTO ceslb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","V té plachtě byla všelijaká zvířata, čtvernožci, plazi i ptáci. ");
INSERT INTO ceslb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Vtom uslyšel hlas: „Vstaň, Petře, zabíjej a jez!“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petr odpověděl: „Kdepak, Pane, zásadně nejím, co je podle tvého zákona nečisté.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ale hlas se ozval znovu: „Neodtahuj se od toho, co Bůh pokládá za čisté!“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tak se to opakovalo třikrát a nakonec byla plachta vytažena do nebe. ");
INSERT INTO ceslb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petr byl zaražený tím viděním a přemýšlel, co mu to má říci. Kornéliovi poslové mezitím nalezli dům Šimona koželuha a stáli před vraty. ");
INSERT INTO ceslb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dotazovali se, zda tam bydlí Šimon zvaný též Petr. ");
INSERT INTO ceslb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrovi, který ještě přemýšlel o tom vidění, ujasnil Boží Duch: „Ti muži, co tě hledají, jsou sice pohané, ");
INSERT INTO ceslb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ale ty sejdi dolů a bez rozpaků se vyprav s nimi. Já jsem je k tobě poslal.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petr tedy sestoupil dolů a řekl jim: „To jsem já, koho hledáte. Proč jste přišli?“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Odpověděli: „Posílá nás římský setník Kornélius, spravedlivý muž, který ctí Boha a má dobrou pověst mezi všemi Izraelci. Zjevil se mu totiž anděl a dal mu pokyn, aby tě pozval do svého domu a vyslechl tvoje poselství.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petr uvedl ty muže dovnitř a oni u něho přenocovali. ");
INSERT INTO ceslb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nazítří se Petr s několika bratřími z Joppe vypravil s nimi. Dalšího dne dorazili do Césareje, kde už je očekával Kornélius. K setkání s Petrem sezval své příbuzné a dobré přátele. ");
INSERT INTO ceslb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Když Petr vcházel do jeho domu, Kornélius mu vyšel naproti, klekl si před ním a hluboce se mu poklonil. ");
INSERT INTO ceslb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petr ho však pozvedl se slovy: „Vstaň, já jsem také jen člověk.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A v přátelském rozhovoru šli spolu dovnitř, kde Petr uviděl to shromáždění. ");
INSERT INTO ceslb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Oslovil je: „Vy jistě víte, že jako žid bych sem neměl chodit a že máme zakázáno přátelit se s lidmi jiného původu. Ale Bůh mi ukázal, že nemám žádného člověka považovat za poskvrněného nebo nečistého. ");
INSERT INTO ceslb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Poslechl jsem proto bez rozpaků vašeho pozvání a tady mě máte. Jen chci vědět, proč jste mě pozvali.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornélius vysvětloval: „Před třemi dny jsem držel půst až do tří hodin a pak jsem se tady doma modlil. Najednou přede mnou stál muž v běloskvoucím rouchu ");
INSERT INTO ceslb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a oslovil mne: ‚Kornélie, Bůh slyší tvé modlitby a ví o tvé dobročinnosti. ");
INSERT INTO ceslb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pošli do Joppe a pozvi k sobě Šimona řečeného Petr. Bydlí u moře v domě koželuha Šimona. Má pro tebe důležité zprávy.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tak jsem tedy pro tebe hned poslal a jsem rád, žes mi vyhověl. Všichni, co jsme tady, věříme v jediného Boha a tvá slova přijmeme jako jeho vzkaz.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petr k nim promluvil: „Teď jsem tedy přesvědčen, že Bůh nedělá mezi lidmi rozdílu ");
INSERT INTO ceslb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","a že je mu milý člověk z kteréhokoliv národa, když ho ctí a jedná správně. ");
INSERT INTO ceslb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Izraelcům svěřil své poselství, radostnou zprávu, že nastává věk smíření ve jménu Ježíše Krista, Pána všech. ");
INSERT INTO ceslb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Snad už víte, jaké události začaly v Galileji a pak se rozšířily i do Judska. Nejprve Jan hlásal pokání a křtil. ");
INSERT INTO ceslb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Potom Ježíše z Nazaretu vybavil Bůh zvláštní mocí a svatým Duchem. Všude, kam přišel, pomáhal a uzdravoval všechny, které sužoval ďábel. Bůh se k němu přiznával ");
INSERT INTO ceslb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","a my můžeme dosvědčit jeho činy v zemi Židů i v Jeruzalémě. A přesto ho tam popravili na kříži! ");
INSERT INTO ceslb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bůh však Ježíše třetího dne vzkřísil a my jsme se s ním opět setkávali. ");
INSERT INTO ceslb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Neukázal se všem lidem, ale jenom nám, které si vybral za svědky zmrtvýchvstání. Dokonce jsme s ním po jeho vzkříšení jedli a pili. ");
INSERT INTO ceslb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dostali jsme příkaz, abychom všem hlásali a dosvědčovali, že toho Ježíše Bůh ustanovil soudcem nad živými i mrtvými. ");
INSERT INTO ceslb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na něho se vztahují sliby, které vyřizovali proroci: každému, kdo v něho uvěří, odpustí Bůh hříchy.“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petr ještě nedomluvil a Duch svatý již sestoupil na všechny posluchače. ");
INSERT INTO ceslb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Petrovi průvodci, kteří byli židé obráceni ke Kristu, žasli, že dar Ducha svatého dostávají nyní i lidé pohanského původu. ");
INSERT INTO ceslb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Vždyť je slyšeli, jak mluví zvláštními jazyky a chválí Boha. Petr jim řekl: ");
INSERT INTO ceslb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","„Copak jim můžeme odepřít křest, když jim Bůh dal svého Ducha jako nám?“ ");
INSERT INTO ceslb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A dal pokyn, aby noví věřící byli pokřtěni ve jméno Ježíše Krista. Na jejich prosbu tam pak ještě několik dní zůstal. ");
INSERT INTO ceslb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apoštolové a ti bratři, kteří zůstali v Judsku, se dozvěděli, že i pohané uvěřili Boží zvěsti. ");
INSERT INTO ceslb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Když se Petr vrátil do Jeruzaléma, někteří křesťané židovského původu mu vyčítali: ");
INSERT INTO ceslb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","„Ty jsi navštěvoval pohany a dokonce jsi s nimi jedl!“ ");
INSERT INTO ceslb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petr jim to pěkně po pořádku vypověděl. ");
INSERT INTO ceslb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","14","Vyprávěl o vidění, které měl na střeše domu v Joppe, o příchodu Kornéliových poslů a o všem, co se pak událo v Césareji. Představil jim i šest křesťanů z Joppe, kteří s ním šli ke Kornéliovi. Pak Petr ukončil slovy: ");
INSERT INTO ceslb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","„Když jsem k nim mluvil o Kristu, sestoupil na ně svatý Duch právě tak jako tenkrát na nás. ");
INSERT INTO ceslb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Vzpomněl jsem si v té chvíli na slova Pána Ježíše: ‚Jan vás křtil na znamení pokání vodou, ale vy budete pokřtěni svatým Duchem.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","A tak když uvěřili v Pána Ježíše Krista jako my a dostali i stejný dar od Boha, nemohl jsem se přece stavět proti Boží vůli!“ ");
INSERT INTO ceslb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Když to židovští bratři vyslechli, uklidnili se, s radostí děkovali Bohu a říkali: „Tedy i pohany probouzí Bůh k pokání a k novému životu!“ ");
INSERT INTO ceslb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ti věřící, kteří po Štěpánově smrti při pronásledování uprchli z Jeruzaléma, se dostali až do Fénicie, na Kypr a do města Antiochie v Sýrii. Radostné zvěsti o spáse hlásali jenom židům. ");
INSERT INTO ceslb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Někteří však, rodáci z Kypru a Kyrenaiky, začali v Antiochii mluvit o Ježíši Kristu také pohanům. ");
INSERT INTO ceslb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pán stál při nich a velký počet lidí uvěřil a obrátil se ke Kristu. ");
INSERT INTO ceslb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Když se o tom doslechli v jeruzalémském sboru, vyslali do Antiochie Barnabáše. ");
INSERT INTO ceslb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ten tam uviděl, jak mocně zapůsobila Boží milost. Měl z toho velkou radost a všechny povzbuzoval, aby věrně vytrvali při svém rozhodnutí pro Pána. ");
INSERT INTO ceslb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabáš byl muž na svém místě, plný Ducha svatého a víry. V Antiochii bylo pro Ježíše získáno velké množství pohanů. ");
INSERT INTO ceslb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabáš se odtud vypravil do Tarsu, vyhledal Saula a přivedl ho s sebou do Antiochie. ");
INSERT INTO ceslb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tam zůstali po celý rok, a když kázali o Kristu, připojilo se ke skupině tamějších věřících překvapivé množství lidí. V Antiochii se poprvé začalo říkat Kristovým následovníkům kristovci – křesťané. ");
INSERT INTO ceslb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Do antiochijského sboru přišli také z Jeruzaléma někteří věřící, kteří měli dar prorockého vidění. ");
INSERT INTO ceslb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jednomu z nich, Agabovi, ukázal Bůh, že v celé říši bude velký hlad. To se skutečně vyplnilo za vlády císaře Klaudia. ");
INSERT INTO ceslb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Křesťané v Antiochii se tedy rozhodli přispět každý podle svých možností a podpořit věřící v Judsku, kde bylo mnoho chudých. ");
INSERT INTO ceslb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Sbírku poslali představeným církve v Jeruzalémě po Barnabášovi a Saulovi. ");
INSERT INTO ceslb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tehdy začal pronásledovat církev také král Herodes. ");
INSERT INTO ceslb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Apoštola Jakuba, bratra Janova, dal popravit mečem. ");
INSERT INTO ceslb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Když viděl, jak se tím zalíbil židovským předákům, dal o Velikonocích zatknout i Petra. ");
INSERT INTO ceslb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Vsadil ho do žaláře, který hlídalo šestnáct vojáků. Střídali se po čtveřicích; z toho dva strážili přede dveřmi a dva byli stále uvnitř s Petrem, který měl s každým z nich spojenu jednu ruku řetězem. ");
INSERT INTO ceslb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tak pečlivě dal král svého vězně hlídat a po Velikonocích ho chtěl okázale soudit. Po celou tu dobu se církev za Petra nepřetržitě modlila. ");
INSERT INTO ceslb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","V noci před chystaným procesem, když Petr spal mezi svými strážci, rýpl ho někdo do boku a probudil ho. ");
INSERT INTO ceslb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","8","Petr vidí, že kobka je plná světla a řetězy z jeho rukou dole. Před ním stojí Boží anděl a říká: „Rychle, vstávej, oblec se a obuj!“ Petr poslechne a dostává další příkaz: „Vezmi si plášť a pojď za mnou!“ ");
INSERT INTO ceslb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Anděl jde napřed, Petr ho následuje, ale neví, zda bdí či sní. ");
INSERT INTO ceslb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Minou bez potíží vnitřní i vnější stráž a už přicházejí k železné hlavní bráně. Ta se před nimi sama otevírá! Vycházejí do ulice, projdou ji a tu se anděl Petrovi ztrácí. ");
INSERT INTO ceslb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tehdy jako by se Petr probral ze sna; stál na ulici a teprve si plně uvědomil, že to Pán poslal svého anděla, vytrhl ho z Herodových rukou a tak zmařil plány Židů. ");
INSERT INTO ceslb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Když si to Petr ujasnil, spěchal do domu Marie, matky Jana Marka. Tam se právě sešli křesťané a modlili se. ");
INSERT INTO ceslb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petr zabušil na dveře a služebná jménem Rodé se přišla zeptat, kdo to je. ");
INSERT INTO ceslb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Když se Petr ohlásil, poznala ho Rodé po hlase, ale samou radostí zapomněla otevřít a běžela zvěstovat dovnitř, kdo to stojí u dveří. ");
INSERT INTO ceslb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nikdo jí nechtěl uvěřit: „To není možné, tys to popletla!“ Rodé však trvala na svém: „Poznala jsem přece Petrův hlas!“ Usoudili tedy, že apoštol byl zabit a že přišel jeho anděl. ");
INSERT INTO ceslb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Vtom však Petr zaklepal znovu. Otevřeli a celí užaslí uvítali Petra živého. ");
INSERT INTO ceslb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Když je konečně utišil, vypravoval jim, jak ho Pán vyvedl ze žaláře. Ještě je požádal, aby podali zprávu Ježíšovu bratru Jakubovi a ostatním křesťanům; pak odešel, aby se ukryl. ");
INSERT INTO ceslb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ráno vypukl mezi strážci poplach: Kam se poděl vězeň? ");
INSERT INTO ceslb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes ho dal hledat, ale marně. Vyslýchal vojáky, a když se od nich nic nedozvěděl, dal je popravit. ");
INSERT INTO ceslb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Záhy nato se Herodes odebral z Judska do Césareje, kde se nějaký čas zdržel. Měl tehdy spory s obyvateli přístavů Týr a Sidón. Ti se nakonec zalekli jeho výhrůžek a chtěli raději uzavřít příměří, protože byli na Herodově území hospodářsky závislí. Poslali společného vyslance a úplatkem získali přízeň předního králova dvořana Blasta. ");
INSERT INTO ceslb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","V den audience usedl Herodes ve slavnostním rouchu na trůn a přednesl řeč. ");
INSERT INTO ceslb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Lid začal provolávat: „Nemluvil člověk, to promluvil bůh!“ ");
INSERT INTO ceslb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herodes tu božskou poctu přijímal jako samozřejmost, ale náhle se zhroutil; Bůh ho ranil pro jeho pýchu. Zemřel pak velice bídně, plný červů. ");
INSERT INTO ceslb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Navzdory pronásledování se Boží poselství rozmáhalo a šířilo. ");
INSERT INTO ceslb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabáš a Saul splnili svoje poslání v Jeruzalémě a vrátili se do Antiochie, kam s sebou vzali Jana Marka. ");
INSERT INTO ceslb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ve sboru v Antiochii bylo několik mužů, kterým Bůh dával zvláštní porozumění jeho pokynům i schopnost tlumočit je lidem. Byli to Barnabáš, Šimon zvaný Černý, Lucius z Kyrény, Manahen, který byl vychováván spolu s galilejským knížetem Herodem Antipou, a Saul. ");
INSERT INTO ceslb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ti se jednou připravovali postem a modlitbami na službu Bohu a dostali pokyn od Ducha svatého: „Vyšlete ze svého středu Barnabáše a Saula k práci, kterou jim chci svěřit!“ ");
INSERT INTO ceslb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Znovu se tedy modlili a postili, pak jim požehnali pokládáním rukou a vyslali je na misii. Jako pomocník s nimi šel Jan Marek. ");
INSERT INTO ceslb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Podle pokynů Ducha se vypravili do přístavu Seleukie a odtud se plavili na ostrov Kypr. ");
INSERT INTO ceslb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Přistáli v městě Salamině a v židovských synagogách začali kázat o Kristu. ");
INSERT INTO ceslb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Prošli tak celým ostrovem až do Páfu. ");
INSERT INTO ceslb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tam sídlil římský místodržitel Sergius Paulus, vzdělaný muž, a ten k sobě pozval Barnabáše a Saula, aby od nich slyšel Boží zvěst. ");
INSERT INTO ceslb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","U Sergia byl také židovský mág Barjezus, který se vydával za proroka. Říkalo se mu Elymas, to znamená čaroděj. Ten se teď tvrdě postavil proti Barnabášovi a Saulovi a snažil se ze všech sil, aby jim Sergius neuvěřil. ");
INSERT INTO ceslb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saul, nyní známější pod jménem Pavel, se v síle svatého Ducha podíval Barjezovi přímo do očí a řekl: ");
INSERT INTO ceslb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","„Tvoje jméno sice znamená ‚syn Ježíšův‘, ale ve skutečnosti jsi syn ďáblův, plný klamu a falše! Jsi nepřítel Boží pravdy a stojíš v cestě lidem, kteří hledají Boha. ");
INSERT INTO ceslb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","On je však pánem i nad tebou. Na důkaz toho teď oslepneš a na čas neuvidíš ani slunce!“ Barjezovi se skutečně setmělo před očima, tápal kolem sebe a hledal, kdo by mu podal ruku a vedl ho. ");
INSERT INTO ceslb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Když místodržitel viděl, co se stalo, uvěřil a dychtivě přijímal Ježíšovo učení. ");
INSERT INTO ceslb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Z Páfu se Pavel a jeho průvodci plavili do Perge v Pamfylii. Jan Marek se však od nich odloučil a vrátil se odtud do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Z Perge šli do Pisidiské Antiochie a zúčastnili se tam sobotní bohoslužby v synagoze. ");
INSERT INTO ceslb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Když byly přečteny oddíly ze zákona a prorockých knih, vyzvali je představení synagogy: „Bratři, jestliže máte pro nás nějaké duchovní povzbuzení, ujměte se slova!“ ");
INSERT INTO ceslb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tu vystoupil Pavel, naznačil obvyklým gestem, že bude hovořit, a začal: „Muži Izraele, i vy, jiného původu, kteří ctíte jediného Boha! Dobře poslouchejte! ");
INSERT INTO ceslb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Bůh si vyvolil naše praotce a za pobytu v Egyptě dal jejich potomkům vyrůst ve veliký národ. Mocnými činy je pak z té otrokářské země vysvobodil. ");
INSERT INTO ceslb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Po čtyřicet let kočovali pouštěmi a Bůh se o ně pečlivě staral. ");
INSERT INTO ceslb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Potom jim podmanil všechny národy, které obývaly Kenaan a daroval tu zemi dědičně Izraeli. ");
INSERT INTO ceslb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Po více než čtyři století jim Bůh vládl prostřednictvím moudrých vůdců, z nichž poslední byl prorok Samuel. ");
INSERT INTO ceslb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","V jeho době zatoužili naši předkové po králi a Bůh jim tedy dal za krále Saula, syna Kíšova z kmene Benjamín. Vládl jim čtyřicet let. ");
INSERT INTO ceslb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bůh se však od něho odvrátil a dal Izraeli za krále Davida, o němž řekl: ‚Vybral jsem si Davida, Jišajova syna. To je muž podle mých představ a bude se řídit mou vůlí.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Slíbil také, že z Davidova rodu se narodí Vysvoboditel, a splnil to, když poslal Ježíše. ");
INSERT INTO ceslb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Před jeho příchodem hlásal Jan všem Izraelcům, aby se zřekli svých hříchů a dali se pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ke konci své činnosti Jan říkal: ‚Nemyslete si, že já už jsem ten očekávaný! Ten přichází po mě a pro mne by byla příliš velká čest, kdybych mu směl třeba jen boty rozvázat.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bratři, kteří jste z Abrahamova národa, i vy ostatní, kteří spolu s námi ctíte jediného Boha, dnes vám přinášíme zvěst o spáse! ");
INSERT INTO ceslb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Obyvatelé Jeruzaléma ani jejich vůdcové však v Ježíšovi nerozeznali Spasitele. Odsoudili ho a nevědomky tak splnili, co o něm psali proroci, jak to čítáme každou sobotu. ");
INSERT INTO ceslb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Neměli žádný důvod, aby ho vydali na smrt. Přesto však naléhali na Piláta, aby ho dal popravit. ");
INSERT INTO ceslb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ale i tak se uskutečnily doslova všechny předpovědi Písma. Ježíšovo tělo bylo sňato z kříže, pohřbeno, ");
INSERT INTO ceslb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ale Bůh jej vzkřísil z mrtvých! ");
INSERT INTO ceslb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Po řadu dní jej vídali jeho galilejští učedníci, kteří s ním přišli do Jeruzaléma. Ti to dosud osobně dosvědčují. ");
INSERT INTO ceslb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","I vám dnes zvěstujeme, že veliký slib, který Bůh dal našim předkům, ");
INSERT INTO ceslb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","34","splnil nyní jejich potomkům a potvrdil ho Ježíšovým vzkříšením. Na něho se vztahují slova druhého žalmu: ‚Ty jsi můj syn, dávám ti dnes život.‘ Bůh slíbil Davidovi, že jeho království bude věčné. ");
INSERT INTO ceslb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","36","A David říká Bohu: ‚Nedopustíš, aby tvůj vyvolený podlehl smrti.‘ To se ovšem netýkalo samého Davida, jenž splnil ve své době úkol, zemřel, byl pohřben a jeho tělo se rozpadlo v prach. ");
INSERT INTO ceslb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ta proroctví se vztahují na Krista, Davidova potomka, kterého Bůh vzkřísil, takže jeho tělo nepodlehlo zkáze. ");
INSERT INTO ceslb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Uvědomte si, bratři, co to pro vás znamená: Každému, kdo uvěří v Ježíše, odpouští Bůh všechny hříchy, a to i ty, které podle Mojžíšova zákona nemohly být odpuštěny. ");
INSERT INTO ceslb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Dejte si však pozor, aby se na vás nesplnila prorocká předpověď: ");
INSERT INTO ceslb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","‚Jen se dobře dívejte, vy, kteří mnou opovrhujete. Zděste se, váš konec se blíží. Před vašimi zraky se děje něco velikého, druzí vám o tom svědčí, ale vy tomu nechcete věřit.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Když vycházeli ze synagogy, posluchači prosili Pavla a Barnabáše, aby jim o tom všem znovu vyprávěli ještě další sobotu. ");
INSERT INTO ceslb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mnozí židé i na židovskou víru obrácení pohané doprovázeli Pavla a Barnabáše. Ti s nimi hovořili a vedli je k tomu, aby se drželi Božího odpuštění. ");
INSERT INTO ceslb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Následující sobotu se shromáždilo skoro celé město, aby slyšelo hlásání Božího slova. ");
INSERT INTO ceslb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Židé žárlili, že se sešlo tolik lidí, skákali Pavlovi do řeči, odporovali a posmívali se mu. ");
INSERT INTO ceslb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nakonec jim tedy Pavel s Barnabášem řekli: „Vy jste měli přednost, vám jsme měli vyřídit Boží slovo jako prvním. Protože je však odmítáte a vzdáváte se tak naděje na věčný život, obracíme se k pohanům. ");
INSERT INTO ceslb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tak nám to Pán totiž přikázal: ‚Neste světlo pohanům a zvěstujte spásu všem lidem.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pohané z toho měli velkou radost a ze srdce děkovali Bohu za to, co od Pavla slyšeli. Ti, v nichž Bůh probudil touhu po věčném životě, uvěřili ");
INSERT INTO ceslb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","a Kristovo evangelium se šířilo v celém kraji. ");
INSERT INTO ceslb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Židé, kteří Krista odmítli, však využili svého vlivu na urozené ženy, které se přiklonily k víře Izraele, a na městské úředníky. Vzbudili tak nepřátelství proti Pavlovi a Barnabášovi, až je vyhnali z kraje. ");
INSERT INTO ceslb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ti se rozhodli, že se nebudou svým odpůrcům vnucovat a odešli do Ikonia. ");
INSERT INTO ceslb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Sbor v Antiochii však rozkvétal a Bůh tamějším věřícím dával radost a svého Ducha. ");
INSERT INTO ceslb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Také v Ikoniu kázali Pavel s Barnabášem nejprve v synagoze, a to tak mocně, že uvěřilo mnoho židů i pohanů. ");
INSERT INTO ceslb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","I tam se ovšem vyskytli židé, kterým se to nelíbilo, popouzeli místní obyvatele a šířili nenávist proti křesťanům. ");
INSERT INTO ceslb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pavel s Barnabášem tam přesto zůstali dost dlouho a neohroženě zvěstovali Krista. Pán se přiznával k jejich hlásání evangelia, dával jim moc konat znamení a divy. ");
INSERT INTO ceslb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Obyvatelé Ikonia se rozdělili na dva tábory – jedni byli s pravověrnými židy a druzí s křesťany. ");
INSERT INTO ceslb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Apoštolové se dozvěděli, že jejich odpůrci – pohané i židé v čele s představenstvem synagogy – je chtějí napadnout a ukamenovat. Proto utekli a zdržovali se v nedalekých městech Lystře, Derbe a v jejich okolí. ");
INSERT INTO ceslb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nedali se však zastrašit a hlásali tam dále Kristovo evangelium. ");
INSERT INTO ceslb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","V Lystře žil muž s ochrnutýma nohama. Měl vrozenou vadu, takže nikdy v životě nechodil. ");
INSERT INTO ceslb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ten byl také mezi Pavlovými posluchači. Pavel se na něj pozorně zahleděl a poznal u něho víru v Boží pomoc. ");
INSERT INTO ceslb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Zavolal na něj: „Narovnej se a postav se na nohy!“ Chromý vyskočil a chodil. ");
INSERT INTO ceslb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lidé, kteří byli u toho, začali provolávat: „Navštívili nás bohové v lidské podobě!“ ");
INSERT INTO ceslb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","O Barnabášovi tvrdili, že je Zeus, a o Pavlovi, že je Hermes – posel bohů, protože většinou mluvil. ");
INSERT INTO ceslb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Došlo to tak daleko, že kněz místního Diova chrámu už přiváděl na shromaždiště ověnčené býky a chystali se je apoštolům obětovat. Ti nejprve netušili, co se děje, protože lidé mezi sebou mluvili lykaonsky. ");
INSERT INTO ceslb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Když to však pochopili, roztrhli svá vrchní roucha na znamení nesouhlasu, rychle sestoupili z vyvýšeného místa, odkud mluvili k lidem, ");
INSERT INTO ceslb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","a horlivě je přesvědčovali: „Přátelé, co to děláte? My jsme přece lidé jako vy! Vyzýváme vás, abyste zanechali též marné modloslužby a obrátili se k jedinému živému Bohu, stvořiteli nebe, země, moře a všech tvorů. ");
INSERT INTO ceslb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dosud vás nechával jít po vašich vlastních cestách, ale nyní chce, abyste opustili své bludy. ");
INSERT INTO ceslb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Vždyť vás má rád a všechno dobré máte od něho: déšť, úrodu, jídla dosyta a každou radost.“ ");
INSERT INTO ceslb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jen stěží jim apoštolové rozmluvili, aby jim neobětovali jako bohům. ");
INSERT INTO ceslb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Potom se však objevili židé z Antiochie a Ikonia, přetáhli zmatený zástup na svou stranu a poštvali ho proti apoštolům. A tak místo pocty Pavla kamenovali a jeho bezvládné tělo vyvlekli za hradby, protože se domnívali, že je mrtev. ");
INSERT INTO ceslb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Křesťané se k němu sběhli, a když se Pavel probral, vrátil se do města. Příštího dne však raději odešel s Barnabášem do Derbe, ");
INSERT INTO ceslb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","kde opět kázali radostnou zvěst o Kristu a získali mu tam mnoho následovníků. Pak se vydali na zpáteční cestu přes Lystru, Ikonium a Pisidiskou Antiochii. ");
INSERT INTO ceslb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Všude dodávali křesťanům odvahu a povzbuzovali je: „Jen vytrvejte ve víře! Čeká nás mnoho utrpení, ale cíl – Boží království – za to stojí.“ ");
INSERT INTO ceslb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","V každém sboru po modlitbách a půstu ustanovili správce a odevzdali všechny do ochrany Pána, v něhož uvěřili. ");
INSERT INTO ceslb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidií tentokrát jen prošli, ");
INSERT INTO ceslb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ale v Pamfylii kázali ve městě Perge. Z přístavu Attalia ");
INSERT INTO ceslb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","se pak plavili zpět do Antiochie v Sýrii, kde jim před časem vyprosili Boží milost k práci, kterou právě dokončili. ");
INSERT INTO ceslb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Po návratu apoštolů se shromáždil celý sbor a oni vyprávěli, co Bůh konal jejich prostřednictvím a jak otevírá pohanům přístup k víře. ");
INSERT INTO ceslb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pavel a Barnabáš pak zůstali s křesťany v Antiochii delší dobu. ");
INSERT INTO ceslb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","V Antiochii se objevili někteří křesťané z Judska a přesvědčovali bývalé pohany, že nestačí jen uvěřit v Krista, ale že ke spáse je nutné přijmout židovské tradice, jak je předepisuje Mojžíšův zákon, a to především obřízku. ");
INSERT INTO ceslb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pavel a Barnabáš s nimi naprosto nesouhlasili a vznikl z toho vážný spor. Nakonec se rozhodli předložit spornou otázku apoštolům a vedení církve v Jeruzalémě. Vyslali tam skupinu pod vedením Pavla a Barnabáše. ");
INSERT INTO ceslb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ti, když cestovali Fénicií a Samařskem, vyprávěli křesťanům, jak pohané přijímají víru v Pána Ježíše, a bratři z toho měli všude velkou radost. ");
INSERT INTO ceslb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","V Jeruzalémě je přijali starší sboru a apoštolové. I těm vyprávěli, jak se Bůh přiznává k jejich práci mezi pohany. ");
INSERT INTO ceslb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Hned se však ozvali někteří křesťané – příslušníci židovské sekty farizejů: „Pohané, kteří uvěřili v Krista, musejí přijmout obřízku a dodržovat Mojžíšův zákon.“ ");
INSERT INTO ceslb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apoštolové a starší svolali poradu o této těžké otázce. ");
INSERT INTO ceslb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Když po dlouhém rozhovoru stále nemohli dojít k žádnému rozhodnutí, vzal si slovo Petr a řekl: „Bratři, víte, že mne si Bůh vybral, abych jako první zvěstoval evangelium pohanům, a oni uvěřili. ");
INSERT INTO ceslb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bůh, který vidí do srdce člověka, se k nim přiznal a dal jim stejného Ducha jako nám. ");
INSERT INTO ceslb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nedělal v tom žádný rozdíl mezi rozeným židem a pohanem – očistil i jejich srdce vírou. ");
INSERT INTO ceslb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Proč chcete být moudřejší než sám Bůh a předělávat je na židy? Vždyť je to zbytečné břemeno, které jsme my ani naši předkové nemohli unést. ");
INSERT INTO ceslb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","I my jsme uvěřili, že nebudeme zachráněni pro svoje židovství, ale pro lásku Pána Ježíše Krista. A v tom jsou nám plně rovni.“ ");
INSERT INTO ceslb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Po tomto projevu celé shromáždění ztichlo a vyslechlo zprávu Barnabáše a Pavla o tom, jaké divy a nadpřirozené věci konal Bůh jejich prostřednictvím mezi pohany. ");
INSERT INTO ceslb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Když skončili, ujal se slova Jakub: „Bratři, chtěl bych něco říci. ");
INSERT INTO ceslb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Slyšeli jsme Šimonovu zkušenost: sám Bůh to byl, kdo poprvé promluvil k pohanům a přijal je mezi svůj lid. ");
INSERT INTO ceslb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","To plně souhlasí se slovy proroka: ");
INSERT INTO ceslb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‚Vrátím se a obnovím svůj příbytek, který je v rozvalinách, znovu budu bydlet s vámi. ");
INSERT INTO ceslb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Potom mne naleznou i pohané, kterým budete hlásat moje jméno.‘ To říká Bůh, ");
INSERT INTO ceslb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","který nyní koná, co slíbil už před věky. ");
INSERT INTO ceslb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nenakládejte tedy na pohany, kteří uvěřili v Boha, zbytečná břemena. ");
INSERT INTO ceslb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Napišme jim, aby zachovávali jen základní pravidla: ať se vyhýbají všemu, co souvisí s modloslužbou, mravní nezřízeností, a ať nejedí maso s krví ani samotnou krev. ");
INSERT INTO ceslb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Vždyť Mojžíšův zákon se už odedávna vyučuje každou sobotu v synagogách a má dost horlivých zastánců.“ ");
INSERT INTO ceslb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","S tím celé shromáždění souhlasilo. Vybrali z vedoucích bratří dva muže. Ti měli v Antiochii vyřídit vše, na čem se v Jeruzalémě usnesli. Byli to Juda zvaný Barsabáš a Silas. ");
INSERT INTO ceslb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Po nich poslali tento dopis: „Apoštolové a starší jeruzalémského sboru vzkazují bratrský pozdrav bratřím v Antiochii, Sýrii a Kylikii, bývalým pohanům. ");
INSERT INTO ceslb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Slyšeli jsme, že k vám přišli od nás lidé, kteří vás znepokojovali a mátli svými názory. My jsme je ničím nepověřili. ");
INSERT INTO ceslb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","Teď jsme se jednomyslně rozhodli poslat k vám Judu a Silase společně s Barnabášem a Pavlem, o nichž víme, že ve službě Kristovu evangeliu nasazují život. Ti vám ještě blíže vysvětlí naše písemné usnesení. ");
INSERT INTO ceslb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Podle rozhodnutí Ducha svatého i podle našeho názoru není nutno vám ukládat jakákoliv břemena kromě těchto nejzákladnějších požadavků: ");
INSERT INTO ceslb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Varujte se toho, co bylo obětováno modlám, nejezte krev ani maso s krví a zachovávejte mravní čistotu. Budete jednat správně, když se přidržíte těchto pokynů. Mějte se dobře!“ ");
INSERT INTO ceslb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pověření bratři se tedy odebrali do Antiochie, odevzdali dopis ");
INSERT INTO ceslb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","a ten byl přečten celému shromáždění. Přinesl všem velikou úlevu a radost. ");
INSERT INTO ceslb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juda a Silas, kterým Duch svatý ukazoval, co mají mluvit, posilovali a povzbuzovali celý sbor. ");
INSERT INTO ceslb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","35","Po nějaké době se měli zase vrátit do Jeruzaléma, ale Silas raději zůstal v Antiochii. Také Pavel a Barnabáš tam zůstali a spolu s mnoha dalšími vyučovali a hlásali Kristovo učení. ");
INSERT INTO ceslb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Po čase navrhl Pavel Barnabášovi: „Měli bychom se vypravit navštívit sbory a bratry ve všech těch městech, kde jsme kázali o Pánu Ježíši. Rád bych věděl, jak si počínají.“ ");
INSERT INTO ceslb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabáš souhlasil a radil, aby s sebou vzali zase Jana Marka. ");
INSERT INTO ceslb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","To se Pavlovi nezdálo, protože je Marek opustil už v Pamfylii a do hlavní práce s nimi nešel. ");
INSERT INTO ceslb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nemohli se dohodnout, a tak se raději rozdělili. Barnabáš vzal s sebou Marka a vypluli na Kypr. ");
INSERT INTO ceslb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pavel si vybral Silase, vyžádali si požehnání od bratří a vydali se na cestu po pevnině. ");
INSERT INTO ceslb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Prošli Sýrií a Kilikií a povzbuzovali křesťany v tamních sborech. ");
INSERT INTO ceslb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Dorazili do Derbe a pak do Lystry. Tam žil mladý věřící muž jménem Timoteus, syn křesťanské Židovky a pohanského otce. ");
INSERT INTO ceslb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Křesťané v Lystře a Ikoniu si ho velice pochvalovali. ");
INSERT INTO ceslb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Také Pavel si ho oblíbil a vybral za svého dalšího průvodce. Protože v těchto oblastech měli stále co činit s židovskými usedlíky, kteří Timotea znali a považovali ho podle otce za pohana, Pavel mu raději doporučil obřízku. ");
INSERT INTO ceslb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Putovali pak společně do dalších měst a seznamovali je s dopisem apoštolů a vedoucích jeruzalémské církve. ");
INSERT INTO ceslb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Maloasijské sbory se upevňovaly ve víře a také tam stále přibývali noví křesťané. ");
INSERT INTO ceslb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","7","Tak procestovali Frygii a obrátili se nazpět do Galacie, protože neměli vnitřní jistotu, že mají pokračovat dále na západ do provincie Asie. Pak chtěli na pobřeží Černého moře do Bytinie, ale cítili, že ani tam je Kristus neposílá. ");
INSERT INTO ceslb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Obrátili se tedy znovu k západu, bez zdržování prošli Mysií, až dorazili do Troady. ");
INSERT INTO ceslb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","V noci měl Pavel sen. Stál před ním muž v makedonském kroji a prosil ho: „Přeplav se do Makedonie a pomoz nám!“ ");
INSERT INTO ceslb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","My všichni jsme uvěřili, že tento sen byl Božím příkazem, abychom šířili zvěst o spáse také v Evropě, a hned jsme se začali připravovat na cestu. ");
INSERT INTO ceslb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Z troadského přístavu jsme se plavili na ostrov Samotraké a na evropskou pevninu jsme vystoupili v makedonské Neapoli. ");
INSERT INTO ceslb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Po souši jsme pokračovali do Filip, nejvýznamnějšího města severní Makedonie, obydleného hlavně římskými kolonisty. Tam jsme se usadili na několik dní. ");
INSERT INTO ceslb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Protože ve městě nebyla synagoga, vyšli jsme v sobotu za bránu na břeh řeky. Předpokládali jsme totiž, že by se tam mohli scházet místní židé a bohabojní pohané k modlitbám. Byla tam opravdu skupina žen, a tak jsme se posadili a mluvili k nim. ");
INSERT INTO ceslb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mezi posluchačkami byla také Lydie, obchodnice s purpurovými sukny, pohanka, která uvěřila v Boha. Kristovo slovo ji zaujalo a ona dychtivě naslouchala Pavlovu kázání. ");
INSERT INTO ceslb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Přijala s celou svou rodinou křest a přiměla nás, abychom se stali hosty v jejich domě. ");
INSERT INTO ceslb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Když jsme zase jednou šli na místo modliteb, potkala nás mladá otrokyně, která měla věštecké nadání. Její majitelé na tom pořádně vydělávali. ");
INSERT INTO ceslb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Připojila se hned k nám a hlasitě vyvolávala: „Vidíte ty lidi? To jsou sluhové nejvyššího Boha a říkají nám, jak najít záchranu!“ ");
INSERT INTO ceslb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tak to dělala den za dnem. Pavel to těžce nesl a jednoho dne jí přikázal: „Ve jménu Ježíše Krista, okamžitě přestaň!“ Dívka se probrala ze svého vytržení a úplně tu schopnost ztratila. ");
INSERT INTO ceslb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","To ovšem rozzlobilo její pány, kteří přišli o zdroj značných příjmů. ");
INSERT INTO ceslb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","Přivlekli Pavla a Silase na radnici před soudce a vznesli proti nim vážné obvinění: „To jsou židé, kteří pobuřují v našem římském městě a snaží se tu šířit svoje náboženství.“ ");
INSERT INTO ceslb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Srocený lid se také připojil k tomu obvinění a úředníci tedy dali Pavla a Silase zmrskat pruty po nahém těle. ");
INSERT INTO ceslb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Po krutém bičování je předali vězeňskému strážci do přísné vazby. ");
INSERT INTO ceslb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ten je vsadil do nejhlubší kobky a nohy jim sevřel kládou. ");
INSERT INTO ceslb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pavel a Silas se ještě o půlnoci hlasitě modlili a zpívali Bohu chvalozpěvy, až se to rozléhalo celou věznicí. ");
INSERT INTO ceslb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tu se zatřásla země, základy vězení byly porušeny, dveře vyvaleny a okovy se uvolnily. ");
INSERT INTO ceslb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Žalářník se probudil a viděl, co se stalo. Tasil svůj meč a chtěl se jím probodnout, protože se domníval, že vězňové utekli, a on za ně ručil svým životem. ");
INSERT INTO ceslb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pavel na něj zavolal: „Nezabíjej se, vždyť nikdo neutekl!“ ");
INSERT INTO ceslb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Správce žaláře popadl pochodeň, seběhl do jejich kobky a vrhl se před nimi na kolena. ");
INSERT INTO ceslb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pak je vyvedl ven a ptal se: „Vy jste jistě bohové; co mám dělat, abych byl zachráněn?“ ");
INSERT INTO ceslb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Řekli mu: „Bůh je Ježíš Kristus, v něho uvěř a budeš zachráněn s celou rodinou.“ ");
INSERT INTO ceslb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","A vyprávěli jemu a všem obyvatelům jeho domácnosti o Kristu. ");
INSERT INTO ceslb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Žalářník je pečlivě ošetřil a ještě v noci se dal s celou svojí rodinou i otroky pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pak zasedli ke stolu a bylo tam veselo, vždyť uvěřili v živého Boha! ");
INSERT INTO ceslb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ráno k němu poslali úředníci vojáka se vzkazem, aby apoštoly propustil. ");
INSERT INTO ceslb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Žalářník měl radost, že mohou klidně odejít, ");
INSERT INTO ceslb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ale Pavel si postavil hlavu: „To tedy ne! Nás, římské občany, dají bez výslechu veřejně zmrskat, vsadit do žaláře, a teď by se nás chtěli v tichosti zbavit? Ať pěkně sami přijdou a propustí nás.“ ");
INSERT INTO ceslb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Voják to vyřídil. Městští úředníci se polekali té skutečnosti, že Pavel a Silas jsou občany Římské říše. ");
INSERT INTO ceslb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Přišli tedy s omluvami, ale prosili je, aby opustili Filipy. ");
INSERT INTO ceslb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","A tak apoštolové ještě navštívili křesťanku Lydii, kde se setkali s věřícími, potěšili se navzájem a odešli z města. ");
INSERT INTO ceslb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Vydali se přes Amfipolis a Apollonii, až přišli do Tesa loniky, kde byla židovská synagoga. ");
INSERT INTO ceslb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pavel, jak už to měl ve zvyku, zahájil svou misijní činnost mezi židy. Tři soboty po sobě k nim promlouval ");
INSERT INTO ceslb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","a snažil se jim dokázat z Bible, že slíbený Mesiáš musel projít utrpením, zemřít a vstát z mrtvých. „Ten Mesiáš je Ježíš a o něm jsem vám přišel povědět,“ říkal Pavel. ");
INSERT INTO ceslb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Někteří z nich tomu uvěřili a ty Pavel a Silas dále vyučovali. Získali pro Krista i mnoho bývalých pohanů, mezi nimi také řadu žen z významných rodin. ");
INSERT INTO ceslb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","To vzbudilo závist židů, kteří v Ježíše neuvěřili. Najali si lidi z městské spodiny a ti vyvolali pouliční výtržnost. Přitáhli k Jásonovu domu, kde Pavel a Silas bydleli, a chtěli je lynčovat. ");
INSERT INTO ceslb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nezastihli je však, a tak dovlekli Jásona s několika věřícími na radnici. Tam židé žalovali na křesťany: ");
INSERT INTO ceslb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","„Tihle lidé organizují vzpoury v celé říši. Ruší císařovy zákony a snaží se nastolit za krále jakéhosi Ježíše. Teď dorazili až k nám a tento muž jim poskytl svůj dům.“ ");
INSERT INTO ceslb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Městští úředníci dostali strach, ");
INSERT INTO ceslb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ale nakonec propustili Jásona a jeho přátele, když zaplatili kauci. ");
INSERT INTO ceslb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Křesťanští bratři hned v noci tajně vyvedli Pavla a Silase z města a vypravili je na cestu do Beroje. Také tam začali činnost v židovské synagoze. ");
INSERT INTO ceslb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berojští židé byli otevřenější a naslouchali ochotně zprávám o Ježíšovi; každý den se scházeli a studovali Písmo a ověřovali si, zda se Pavlova zvěst shoduje s předpověďmi izraelských proroků. ");
INSERT INTO ceslb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mnoho jich uvěřilo a opět se k nim připojili pohané, muži i ženy, někteří i z urozených vrstev. ");
INSERT INTO ceslb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","To se ovšem doneslo k židům v Tesalonice. Vypravili se do Beroje a snažili se i tam Pavlovu práci překazit. ");
INSERT INTO ceslb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","15","Berojští křesťané raději hned dovedli Pavla do nejbližšího přístavu a někteří ho doprovodili po moři až do Atén. Silas a Timoteus zůstali zatím v Beroji. Pavel jim však vzkázal po svých průvodcích, aby se za ním co nejdříve vypravili. ");
INSERT INTO ceslb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Zatímco na ně čekal, procházel Pavel Aténami. Všechno se v něm bouřilo, když viděl, jak tam lidé horlivě uctívali sochy bohů. ");
INSERT INTO ceslb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Den co den hovořil s židy a bohabojnými Řeky v synagoze, ale vycházel i na náměstí a mluvil ke všem, kdo mu byli ochotni naslouchat. ");
INSERT INTO ceslb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","21","Tak se dostal do hovoru i s aténskými filozofy, epikurejci a stoiky, a vyprávěl jim o Ježíšovi, který vstal z mrtvých. Někteří ho okřikovali: „Neposlouchejte toho žvanila!“ ale druhé to začalo zajímat. Říkali: „To bude nějaké nové náboženství.“ Atéňané i lidé, kteří tam přicházeli studovat, byli totiž velice zvědaví a posedlí touhou povědět nebo uslyšet něco nového a neobvyklého. Vzali Pavla mezi sebe, dovedli ho na řečniště zvané Areopag a požádali ho, aby jim pověděl něco více o tom novém učení plném překvapujících myšlenek. ");
INSERT INTO ceslb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pavel tedy vystoupil na místo pro řečníky a oslovil shromážděné: „Atéňané, všiml jsem si, že jste opravdu nábožensky založení lidé. ");
INSERT INTO ceslb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Když jsem prohlížel vaše četné chrámy a svatyně, viděl jsem také oltář zasvěcený ‚neznámému bohu‘. Tušíte tedy, že je zde někdo, kdo přerůstá vaše představy a máte ho v úctě. A právě o něm jsem vám přišel povědět! ");
INSERT INTO ceslb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Jediného pravého Boha, který stvořil svět a všechno živé, který ovládá Zemi a celý vesmír, toho nemůžete postavit jako sochu do svých chrámů. ");
INSERT INTO ceslb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","On není závislý na tom, zda ho někdo uctívá a přináší mu oběti. Vždyť on sám dává všem život a udržuje i zajišťuje ho vším potřebným. ");
INSERT INTO ceslb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Celé lidstvo vytvořil z jediného člověka, rozsadil nás po celé zemi a vymezil jednotlivým národům prostor i dějinná období. ");
INSERT INTO ceslb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","A všichni máme veliký úkol: hledat Boha. A tu po pracném poznávání zjišťujeme, že je nám vlastně nablízku. ");
INSERT INTO ceslb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","On nám totiž dává život, pohyb a celé bytí. Pěkně to vyjádřili někteří vaši básníci: jsme jeho děti, Boží rodina. ");
INSERT INTO ceslb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Jak bychom si tedy měli myslet, že božská pocta přísluší nějakému lidskému dílu ze zlata, stříbra nebo mramoru? To je přece výtvor lidského umění a obratnosti. Vidíte, do takového omylu lidstvo zapadlo, ");
INSERT INTO ceslb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ale Bůh je trpělivý a chce nám to prominout. Teď ale vzkazuje všem lidem, že je na čase toho všeho nechat a obrátit se k němu, k pravému Bohu. ");
INSERT INTO ceslb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Blíží se totiž den, kdy nás bude soudit, a všechno závisí na tom, jaký zaujmeme postoj k jedinému muži, kterého Bůh poslal, ke Kristu Ježíši. K němu se Bůh jasně přiznal tím, že ho vzkřísil z mrtvých.“ ");
INSERT INTO ceslb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","33","Dosud pozorní posluchači teď Pavla přerušili. Vzkříšení z mrtvých bylo na ně příliš. Někteří se mu rovnou vysmáli, druzí se vymluvili: „Pro dnešek to stačí, poslechneme si tě zase příště.“ ");
INSERT INTO ceslb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ale někteří byli přece jen zaujati, požádali Pavla o bližší vysvětlení a uvěřili. Byl mezi nimi i člen soudního dvora Areopagu Dionysios a žena jménem Damaris. ");
INSERT INTO ceslb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pavel pak odcestoval z Atén do Korintu. ");
INSERT INTO ceslb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tam se seznámil s židovskými manžely; Akvila byl rodák z Pontu, ale do Korintu se přistěhoval se svou ženou Priscilou teprve nedávno z Itálie. Císař Klaudius totiž nařídil, aby se všichni židé vystěhovali z Říma. ");
INSERT INTO ceslb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pavel u nich našel byt i zaměstnání, protože měli dílnu na výrobu stanů, a to bylo jeho řemeslo. Pracoval tady s nimi ");
INSERT INTO ceslb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","a o sobotách v synagoze rozmlouval s židy i pohany. ");
INSERT INTO ceslb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Když konečně z Makedonie dorazili Silas a Timoteus, mohl se Pavel více soustředit na šíření evangelia. I tady se především snažil přesvědčit židy, že Ježíš je ten slíbený Mesiáš. ");
INSERT INTO ceslb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Oni mu však napořád odporovali, a když dokonce začali mluvit o Ježíšovi neuctivě, Pavel symbolicky naznačil, že za ně nenese odpovědnost: vytřásl si prach ze šatů a řekl jim: „Přivoláte na sebe Boží soud a moje vina to nebude; já se od této chvíle budu věnovat pohanům.“ ");
INSERT INTO ceslb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ke své další činnosti si zvolil dům zbožného muže Tita Justa, který bydlel hned vedle synagogy. Někteří ze židů uvěřili, ");
INSERT INTO ceslb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","dokonce i sám představený synagogy Krispus s celou rodinou. I mnozí jiní Korinťané se pod vlivem Pavlova kázání obrátili ke Kristu a dali se pokřtít. ");
INSERT INTO ceslb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jedné noci měl Pavel vidění a dostal od Pána Ježíše pokyn: „Neboj se a nedej se umlčet. ");
INSERT INTO ceslb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Já jsem s tebou a odrazím všechny útoky proti tobě. V Korintu je ještě mnoho těch, kteří se stanou mými následovníky.“ ");
INSERT INTO ceslb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","A skutečně, Pavel tam zůstal půldruhého roku a mohl pokojně kázat Boží slovo. ");
INSERT INTO ceslb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Když se římským místodržitelem Řecka stal Gallio, smluvili se židé na Pavla a přivedli ho před soud ");
INSERT INTO ceslb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","s obžalobou: „Tento muž navádí lidi, aby ctili našeho Boha způsobem, který se příčí zákonům.“ ");
INSERT INTO ceslb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pavel se chystal k obhajobě, ale Gallio ho předešel a řekl žalobcům: „Kdyby se jednalo o nějaké bezpráví nebo zločin, vyslechl bych vás jako kterékoliv jiné občany. ");
INSERT INTO ceslb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ale spory o slůvka, jména a články vašeho náboženství si vyřizujte mezi sebou. Do toho mně nic není.“ ");
INSERT INTO ceslb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Potom židy vykázal ze soudní síně. ");
INSERT INTO ceslb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Srocený dav napadl představeného synagogy Sostena. Tloukli ho přímo před Galliovýma očima, ale ten si toho nevšímal. ");
INSERT INTO ceslb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","19","Pavel zůstal v Korintu ještě delší dobu. Nakonec se však rozloučil s bratry a vydal se na cestu lodí zpět do Sýrie. Spolu s ním vypluli i manželé Priscila s Akvilou, kteří se stěhovali do Efezu. Ve východním korintském přístavu si dal Pavel naposled ostříhat vlasy. Po celou cestu až do Jeruzaléma se totiž zavázal dodržovat nazírský slib (vnějšími projevy tohoto slibu bylo, že si muž nestříhal vlasy a vousy a nepil žádné opojné nápoje). V Efezu se Pavel rozloučil s přáteli, ale před odjezdem ještě zašel do tamní synagogy pohovořit si s židy. ");
INSERT INTO ceslb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ti ho dokonce přemlouvali, aby u nich nějakou dobu zůstal, ale Pavel nechtěl. Při loučení jim řekl: ");
INSERT INTO ceslb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","„Bude-li to Boží vůle, tak se k vám vrátím.“ ");
INSERT INTO ceslb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Z Efezu odplul do Césareje v Judsku a pak pěšky pokračoval až do Jeruzaléma. Pozdravil jeruzalémské křesťany a odcestoval do syrské Antiochie. ");
INSERT INTO ceslb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pavel se však ve svém domovském sboru dlouho nezdržel a brzy vyrazil na další cestu do Galacie a Frygie. Postupně tam navštívil všechny sbory a upevňoval jejich členy ve víře. ");
INSERT INTO ceslb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mezitím přišel do Efezu žid z Alexandrie jménem Apollos. Byl to výborný řečník a znalec Starého zákona. Byl pokřtěn po způsobu Jana Křtitele, ");
INSERT INTO ceslb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","znal leccos z Ježíšova učení a nadšeně a přiléhavě mluvil o Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","27","Tak vystoupil bez bázně i v efezské synagoze. Tam ho uslyšeli Priscila a Akvila, pozvali ho k sobě a důkladněji mu vysvětlili Kristovo evangelium. Apollos se pak rozhodl jít dále do Řecka a zvěstovat Ježíše. Efezští křesťané mu to schvalovali a dali mu pěkný doporučující dopis. Svým výjimečným obdarováním prokázal platné služby věřícím v Řecku. ");
INSERT INTO ceslb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Zvláště vynikal v debatách se židy, kterým dokazoval ze Starého zákona, že Ježíš je Mesiáš. ");
INSERT INTO ceslb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Zatímco Apollos působil v Korintu, prošel Pavel hornatým středem Malé Asie a dostal se až do Efezu. Seznámil se tam se skupinou asi dvanácti mužů, kteří si říkali „učedníci“. ");
INSERT INTO ceslb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pavel chtěl zjistit, čemu vlastně věří, a tak se jich vyptával: „Projevila se na vás moc Božího Ducha, když jste uvěřili?“ Oni odpověděli: „Ne, o něčem takovém jsme ani neslyšeli.“ ");
INSERT INTO ceslb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pavel jim položil další otázku: „Čí jste tedy následovníci? Pokřtil vás někdo?“ Prohlásili: „Byli jsme pokřtěni po způsobu Jana Křtitele.“ ");
INSERT INTO ceslb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","„To je dobře,“ navázal na to Pavel. „Jan křtil ty, kdo vyznávali své hříchy a chtěli jich upřímně zanechat. Snad tedy také víte, že Jan vybízel lidi, aby uvěřili v Ježíše, který vystoupil po něm, a přijali ho jako Vykupitele.“ ");
INSERT INTO ceslb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ti mužové přijali vše, co jim Pavel vyprávěl, a dali se pokřtít na znamení toho, že uvěřili v Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","7","Když jim potom Pavel žehnal, sestoupil na ně Duch svatý a oni začali mluvit v prorockém nadšení. ");
INSERT INTO ceslb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tři měsíce pak Pavel navštěvoval synagogu, svobodně tam promlouval a snažil se přesvědčit židy, že zaslíbený Boží Král už přišel. ");
INSERT INTO ceslb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Někteří se však ostře stavěli proti němu, odmítali mu uvěřit a snažili se jeho kázání před ostatními zesměšnit. Nakonec musel Pavel zřídit oddělená shromáždění pro křesťany. Hovořil k nim každodenně v přednáškové síni filozofa Tyrana. ");
INSERT INTO ceslb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kázal tam dva roky, takže snad všichni obyvatelé toho kraje, židé i pohané, uslyšeli o Ježíšovi. ");
INSERT INTO ceslb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bůh se přiznával k této službě tím, že v Pavlově blízkosti byli lidé mimořádným způsobem uzdravováni. ");
INSERT INTO ceslb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Dokonce i Pavlovy kapesníky a části oděvu kladli lidé s vírou na nemocné a ti, zvláště duševně choří, tak byli vyléčeni. ");
INSERT INTO ceslb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Toho se pokoušeli využít někteří židovští zaklínači nemocí. Začali používat novou formulku: „Zaklínám tě ve jménu Ježíše, kterého káže Pavel.“ Nepřineslo jim to však úspěch. ");
INSERT INTO ceslb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sedm synů jakéhosi významného židovského kněze Skévy zkoušelo tímto způsobem uzdravit jednoho šílence. ");
INSERT INTO ceslb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Temný duch z něho promluvil: „Ježíše i Pavla znám, ale kdo jste vy?“ ");
INSERT INTO ceslb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pak se na ně ten člověk vrhl, strhal z nich šaty, ztloukl je a jen tak tak, že vyvázli živí; všechny je zmohl. ");
INSERT INTO ceslb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","To se rozkřiklo po celém Efezu mezi židy i pohany, takže si už na takové čáry nikdo netroufal a jméno Pána Ježíše bylo vyslovováno s úctou. ");
INSERT INTO ceslb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Také křesťané přicházeli a veřejně se přiznávali, že se dříve pokoušeli zaklínat. ");
INSERT INTO ceslb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mnozí teď přinášeli své knihy o magii a veřejně je pálili. Takového čarodějnického braku bylo spáleno dobře za padesát tisíc stříbrných drachem. ");
INSERT INTO ceslb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","I to byl projev šířícího se vlivu a rostoucí moci Kristovy. ");
INSERT INTO ceslb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pavel chtěl pokračovat v misijní cestě do Makedonie, do Řecka a pak se mínil vrátit do Jeruzaléma. Říkal: „Po nějakém čase bych se rád vypravil do Říma.“ ");
INSERT INTO ceslb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dva ze svých pomocníků, Timotea a Erasta, vyslal do Makedonie napřed, ale sám se ještě zdržel v Asii. ");
INSERT INTO ceslb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pak ale vypukl odpor proti křesťanskému učení, tentokrát ze strany pohanů. ");
INSERT INTO ceslb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Příčinou byly ohrožené zisky efezských řemeslníků, kteří ve velkém vyráběli upomínkové modely chrámu se sochou bohyně Diany a prodávali je poutníkům. Vedl je stříbrotepec Demetrios, ");
INSERT INTO ceslb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","který svolal všechny podnikatele a jejich dělníky a oslovil je: ");
INSERT INTO ceslb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","„Přátelé, všichni dobře víme, jak výnosné je naše řemeslo. A teď, jak jste jistě slyšeli, přijde si nějaký Pavel a nejenom v Efezu, ale i po celé Asii odvrací lidi od naší víry! Že prý bohové vyrobení lidskýma rukama nejsou bohové, ale jen modly. ");
INSERT INTO ceslb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tím nejen poškozuje naše obchody, ale vážnost efezského chrámu a samotné Diany tak povážlivě upadá v Asii a snad v celém světě!“ ");
INSERT INTO ceslb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","29","Tím ovšem přivedl shromáždění do varu a ti začali provolávat: „Velká je Diana z Efezu!“ Nepokoje se rychle rozšířily po celém městě, lidé se sbíhali do amfiteátru. Někde chytili Gaja a Aristarcha, Pavlovy makedonské průvodce, a přivlekli je tam. ");
INSERT INTO ceslb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pavel chtěl jít a promluvit ke shromážděnému lidu, ");
INSERT INTO ceslb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ale ostatní křesťané z provinčního úřadu, kteří sympatizovali s Pavlem, mu naléhavě vzkazovali, aby tam nechodil. ");
INSERT INTO ceslb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","V amfiteátru zatím už každý vyvolával něco jiného a většina lidí vůbec nevěděla, proč tam přišli. ");
INSERT INTO ceslb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Židé dostali strach, aby se hněv davu nevybil na nich, a vyslali tam svého řečníka Alexandra. Chtěl si zjednat ticho a vysvětlit, že s Pavlem nemají nic společného. ");
INSERT INTO ceslb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Jakmile však lidé poznali, že je to žid, sjednotili se zase na společném heslu: „Velká je Diana z Efezu!“ A tak křičeli skoro dvě hodiny. ");
INSERT INTO ceslb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Konečně se dostavil tajemník městské rady, podařilo se mu dav utišit a promluvit k nim: „Občané Efezu! To přece ví každý, že právě v našem městě je nejvýznamnější chrám bohyně Diany a že její zdejší socha spadla přímo z nebe. ");
INSERT INTO ceslb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","37","Kdo by se to odvážil popírat? Přivedli jste k soudu tyto muže. Ale oni přece neznesvětili náš chrám, ani se nerouhali naší bohyni. Prosím vás, uklidněte se a neukvapujte se! ");
INSERT INTO ceslb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jestliže si Demetrios a ostatní řemeslníci chtějí na někoho stěžovat, jsou tady od toho veřejné soudy a římské úřady, kde se může konat řádné přelíčení. ");
INSERT INTO ceslb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A máte-li nějaké požadavky, je třeba je projednat ve schůzi městské rady. ");
INSERT INTO ceslb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Takhle je nebezpečí, že budeme obviněni z povstání. Vždyť nemáte pro tenhle rozruch žádný rozumný důvod.“ ");
INSERT INTO ceslb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Po těch slovech se lidé rozešli. ");
INSERT INTO ceslb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Když se rozruch utišil, svolal Pavel shromáždění, povzbuzoval efezské křesťany a zároveň se s nimi loučil; rozhodl se totiž pokračovat ve své misijní cestě. ");
INSERT INTO ceslb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Vydal se do Makedonie a Řecka a cestou dodával skupinám křesťanů odvahu a naději. ");
INSERT INTO ceslb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","V Řecku se zdržel čtvrt roku a potom chtěl odplout zpátky, přímo do Sýrie. Dozvěděl se však, že židé hlídají přístavy a chtějí se ho zmocnit, a tak se rozhodl pro zpáteční cestu zase přes Makedonii. ");
INSERT INTO ceslb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","5","Někteří z Pavlových spolupracovníků se přeplavili napřed do Troady a čekali tam na nás. Byli to Sopatros z Beroje, Aristarchos a Sekundus z Tesaloniky, Gájus a Timoteus z Derbe, Tychikos a Trofimos ze západní Malé Asie. ");
INSERT INTO ceslb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","My s Pavlem jsme nasedli ve Filipách po Velikonocích na loď a po pěti dnech jsme se s nimi sešli v Troadě, kde jsme se zdrželi týden. ");
INSERT INTO ceslb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","V neděli večer se tamní sbor sešel ke svaté večeři Páně. Pavel kázal, a protože to bylo slovo na rozloučenou, mluvil až do půlnoci. ");
INSERT INTO ceslb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","V místnosti hořelo mnoho lamp a byla plná lidí, takže tam bylo horko. Mládenci se proto posadili do oken. ");
INSERT INTO ceslb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Jak se shromáždění protáhlo, jeden z nich, Eutychos, usnul a vypadl z třetího poschodí na dvůr. Běželi k němu, ale ležel tam mrtev. ");
INSERT INTO ceslb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pavel k němu poklekl, vzal ho do náruče a po chvíli řekl: „Nedělejte si starosti, žije.“ ");
INSERT INTO ceslb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Vrátili se nahoru a pokračovali ve večeři Páně. Pavel k nim mluvil celou noc a teprve za svítání se rozloučili. ");
INSERT INTO ceslb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Eutycha přivedli zase zdravého a všichni z toho měli radost. ");
INSERT INTO ceslb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pavel nás poslal lodí napřed do přístavu Assos, ale sám tam šel po souši. ");
INSERT INTO ceslb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","15","V Assu nastoupil k nám. Po přistání v Mityléně a po obeplutí ostrovů Chios a Samos jsme třetí den zakotvili v Milétu. ");
INSERT INTO ceslb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pavel se úmyslně vyhnul Efezu, protože se bál zdržení. Spěchal totiž, aby byl na svátek Letnic v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pozval si však do Milétu představené efezského sboru ");
INSERT INTO ceslb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","19","a řekl jim: „Jistě si pamatujete, že jsem po celý čas u vás sloužil Pánu se vší skromností, ale přesto s velikými obtížemi a úklady ze strany židů. ");
INSERT INTO ceslb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Neopomněl jsem nic, co jste měli slyšet, hlásal jsem to veřejně i v soukromých domech. ");
INSERT INTO ceslb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Židům i pohanům jsem stejně zdůrazňoval, že musejí vyznat Bohu své hříchy a uvěřit v Ježíše Krista jako Pána nás všech. ");
INSERT INTO ceslb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Teď mne však Duch svatý posílá do Jeruzaléma a já nevím, co mne tam potká. ");
INSERT INTO ceslb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","V každém sboru, kde jsme se zastavili, mně bratři z Božího vnuknutí předpovídali, že mě tam čeká vězení a těžkosti. ");
INSERT INTO ceslb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ale já si tolik nezakládám na životě. Jde mi především o to, abych doběhl závod až do konce a splnil úkol, který mi Pán Ježíš dal: být nositelem radostné zvěsti o Boží lásce. ");
INSERT INTO ceslb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Dnes naposled hovořím k vám, kterým jsem tolikrát mluvil o Božím království. ");
INSERT INTO ceslb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mohu říci, že mou vinou nikdo neztratí věčný život. ");
INSERT INTO ceslb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Všechno, co mi Bůh pro vás dal, jsem vyřídil. ");
INSERT INTO ceslb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Teď je na vás, abyste si dobře počínali a jako pastýři vedli stádo, které vám Duch svatý svěřil. Pamatujte, že Kristus za ně prolil svou krev! ");
INSERT INTO ceslb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Vím, že po mém odchodu se mezi vás vplíží jako draví vlci falešní učitelé a nadělají ve stádu škody. ");
INSERT INTO ceslb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dokonce z vašeho vlastního středu povstanou lidé, kteří budou překrucovat pravdu a přetahovat lidi na svou stranu. ");
INSERT INTO ceslb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Buďte na stráži a pamatujte, že po tři roky jsem ve dne v noci na každém osobně pracoval, i když to nebylo lehké. ");
INSERT INTO ceslb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Teď vás tedy poroučím Bohu a jeho milostivému slovu, které má sílu vás zdokonalovat a zajistit vám dědický podíl mezi jeho věrnými. ");
INSERT INTO ceslb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nikdy jsem od vás nežádal peníze ani oděv; ");
INSERT INTO ceslb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","svýma rukama jsem si na všechno vydělával pro sebe i pro své pomocníky. ");
INSERT INTO ceslb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Snažil jsem se dát vám příklad: vaší povinností je ujímat se slabých a pracovat pro ně. Vždycky mějte na paměti slova Pána Ježíše: Větší radost je dávat než dostávat!“ ");
INSERT INTO ceslb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Po těch slovech s nimi poklekl a modlil se. ");
INSERT INTO ceslb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Loučení se neobešlo bez slz a bylo mnoho objímání a bratrských polibků. ");
INSERT INTO ceslb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nejvíce je zarmoutilo, že by se už neměli s Pavlem vidět. Nakonec ho doprovodili až k lodi. ");
INSERT INTO ceslb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Skončilo loučení a loď zvedla kotvy. Pluli jsme k ostrovu Kós, druhý den na ostrov Rodos a jižního pobřeží Malé Asie jsme dosáhli v přístavu Patara. ");
INSERT INTO ceslb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tam jsme přestoupili na loď, která směřovala do fénických měst v Palestině. ");
INSERT INTO ceslb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kypr jsme obepluli vpravo a dorazili jsme do Týru, kam loď vezla nějaký náklad. ");
INSERT INTO ceslb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Využili jsme času a strávili jsme celý týden s tamními křesťany. Také těm Bůh vnukl obavu, že Pavla nečeká v Jeruzalémě nic dobrého, a tak mu další cestu rozmlouvali. ");
INSERT INTO ceslb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Přesto jsme pokračovali dál. Vyprovodili nás s celými svými rodinami až za město. Na pobřeží jsme společně klečeli a modlili se. ");
INSERT INTO ceslb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","8","Pak jsme se rozloučili a vypluli do Ptolemaidy. Také tam jsme mohli zůstat jeden den s věřícími. Naše loď končila svou plavbu v Césareji, kde jsme navštívili známého kazatele Filipa, jednoho z těch prvních sedmi apoštolských pomocníků. Ubytoval nás jako hosty své rodiny. ");
INSERT INTO ceslb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipovy čtyři svobodné dcery byly také nadšené tlumočnice Kristova poselství. ");
INSERT INTO ceslb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Po několika dnech tam přišel jeden křesťan z Judska, Agabos, který měl prorocký dar. ");
INSERT INTO ceslb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Půjčil si od Pavla jeho opasek, spoutal si jím ruce i nohy a řekl: „Duch svatý mi ukázal, že majitele tohoto pásu židé v Jeruzalémě takhle svážou a vydají ho pohanům.“ ");
INSERT INTO ceslb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","To už bylo příliš, a tak jsme všichni, průvodci i místní křesťané, začali Pavla přemlouvat, aby do Jeruzaléma nechodil. ");
INSERT INTO ceslb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","On nás však napomenul: „Proč tolik pláčete a děláte mi to těžší? Pán Ježíš přece stojí za to, abych byl pro něho uvězněn a třeba i zabit.“ ");
INSERT INTO ceslb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Viděli jsme, že je marné na Pavla naléhat, a tak jsme řekli: „Ať se tedy stane, co chce Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Skončil odpočinek u Filipovy rodiny a my nachystali svá zavazadla na poslední pěší úsek cesty do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","17","Několik křesťanů z Césareje nás doprovodilo až do cíle. Zavedli nás tam k našemu dalšímu hostiteli, Mnasonovi z Kypru, jednomu z prvních křesťanů. Jeruzalémská církev nás přijala radostně. ");
INSERT INTO ceslb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Hned druhý den jsme byli všichni pozváni k Jakubovi, představenému sboru, kde se shromáždili všichni starší. ");
INSERT INTO ceslb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pavel se s nimi pozdravil a podal jim zevrubnou zprávu o výsledcích práce mezi pohany, k níž ho Bůh zmocnil. ");
INSERT INTO ceslb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Rádi to slyšeli a chválili Boha. Potom však řekli Pavlovi: „Jistě už víš, že u nás již několik tisíc židů uvěřilo v Pána Ježíše a ti i nadále horlivě zachovávají Mojžíšův zákon. ");
INSERT INTO ceslb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Zde se však šíří zprávy, že ty přesvědčuješ židy v pohanském světě, aby od zákona odstoupili, syny už nedávali obřezat a vůbec zavrhli starobylé židovské zvyky. ");
INSERT INTO ceslb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Měl bys něco podniknout dříve, než se všichni dozvědí, že jsi tady. ");
INSERT INTO ceslb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","24","Máme pro tebe tento návrh: Mezi námi jsou teď čtyři muži, kteří se zavázali plnit nazírský slib. Jejich lhůta vypršela, ale jsou chudí a nemají prostředky na závěrečný obřad v chrámu. Jistě by na židy dobře zapůsobilo, kdybys za ty muže zaplatil a při té příležitosti podstoupil očišťování navrátilců z pohanské ciziny. Všichni by viděli, že máš zákon v úctě a pomlouvačům by to vzalo vítr z plachet. ");
INSERT INTO ceslb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pro obrácené pohany ovšem platí naše původní rozhodnutí, které jsme vám kdysi dali písemně. Žádáme od nich jen základní ohled na zákon, aby totiž nejedli maso obětované předem modlám, krev a maso s krví a především aby odložili pohanskou pohlavní nevázanost.“ ");
INSERT INTO ceslb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Druhého dne tedy Pavel podstoupil spolu s těmi čtyřmi muži obřad očištění. Pak šel do chrámu, aby oznámil, kdy skončí jejich nazírský závazek a jeho očišťování, a aby za každého z nich objednal oběti. ");
INSERT INTO ceslb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Když končilo sedm dní a Pavel s nimi přišel zase do chrámu, aby byli obřadně prohlášeni za čisté, poznali ho židovští poutníci z Malé Asie. Poštvali na něho okolostojící, popadli ho ");
INSERT INTO ceslb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","a křičeli: „Věrní Izraelci, pojďte sem! Tady máme toho odpadlíka! Všude hlásá bludy a nic mu není svaté: ani naše vyvolení, ani zákon, ani chrám. Teď sem dokonce přivedl pohany, aby poskvrnil svaté místo.“ ");
INSERT INTO ceslb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Předtím totiž Pavla zahlédli ve městě s Trofimem z Efezu a mysleli, že ho vzal i do chrámu, kam pohané nesměli. ");
INSERT INTO ceslb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","To ovšem vyvolalo obrovský rozruch a lidé se sbíhali ze všech stran. Mezitím vyvedli Pavla z vnitřního chrámového nádvoří a brány rychle zavřeli. ");
INSERT INTO ceslb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Vypadalo to, že rozlícený dav Pavla utluče, když vtom zasáhli Římané. Velitel posádky hradu Antonia, který přiléhal přímo ke chrámu, dostal hlášení o nepokoji ");
INSERT INTO ceslb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","a seběhl s pohotovostní četou do nádvoří. Lidé se vojáků lekli, přestali Pavla tlouci a stáhli se od něho. ");
INSERT INTO ceslb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Velitel ho považoval za původce výtržnosti, dal ho zatknout a nasadit mu pouta. Pak začal vyšetřovat, kdo to je a co udělal. ");
INSERT INTO ceslb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Lidé křičeli jeden přes druhého. Velitel viděl, že se takhle nic nedozví, a tak dal rozkaz odvést Pavla do pevnosti. ");
INSERT INTO ceslb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Dav však táhl za nimi, dorážel a křičel: „Zabijte ho!“ Po schodišti do hradu museli vojáci vězně dokonce nést, aby na něho rozzuření lidé nemohli. ");
INSERT INTO ceslb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pavel se zeptal velitele, zda s ním může mluvit. Ten se podivil: „Ty mluvíš řecky? ");
INSERT INTO ceslb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Já jsem myslel, že jsi ten Egypťan, co se před nedávnem pokusil o povstání a schovává se někde v poušti se čtyřmi tisíci banditů.“ ");
INSERT INTO ceslb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","„Ne,“ řekl Pavel, „jsem žid z Tarsu v Kilikii, římský občan. Dovol mi, prosím, promluvit k těm lidem.“ ");
INSERT INTO ceslb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Velitel souhlasil, Pavla postavili na vrchol schodiště a on dal znamení, že chce mluvit. Dav se utišil a Pavel začal hebrejsky: ");
INSERT INTO ceslb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","„Bratři a otcové, rád bych se před vámi obhájil.“ ");
INSERT INTO ceslb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lidé byli překvapeni, že mluví jejich rodným jazykem, a tak tiše poslouchali. Pavel pokračoval: ");
INSERT INTO ceslb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","„Jsem žid, narozený sice v Tarsu v Kilikii, ale vychován jsem byl zde v Jeruzalémě. Vám dobře známý učenec Gamaliel mě vyškolil přesně podle zákona našich otců a horlil jsem pro Boha, právě tak jako vy dnes. ");
INSERT INTO ceslb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Víru v Ježíše Krista jsem nenáviděl k smrti. Dokonce jsem jeho vyznavače, muže i ženy, dával zatýkat a věznit. ");
INSERT INTO ceslb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","To mi může dosvědčit velekněz a celá velerada. Jednou mi také vydali pověřující listiny pro židovskou obec v Damašku a já jsem se tam vypravil, abych mezi nimi pozatýkal křesťany a dopravil je do Jeruzaléma k potrestání. ");
INSERT INTO ceslb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","A poslyšte, co se stalo. Bylo kolem poledne a my jsme byli na dohled od damašských hradeb. Náhle se okolo mne rozzářilo oslnivé světlo, mnohem jasnější než polední slunce. ");
INSERT INTO ceslb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Padl jsem na zem, když jsem uslyšel hlas: ‚Saule, Saule, proč mne pronásleduješ?‘ ");
INSERT INTO ceslb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ozval jsem se: ‚Kdo jsi, Pane?‘ Slyšel jsem odpověď: ‚Já jsem Ježíš z Nazaretu a ty bojuješ proti mně.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Moji průvodci byli tím světlem také oslněni, ale neslyšeli, že by ke mně někdo mluvil. ");
INSERT INTO ceslb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Zeptal jsem se: ‚Pane, co mám dělat?‘ Ježíš mi odpověděl: ‚Teď vstaň a jdi do Damašku. Tam ti řeknou, jaký mám pro tebe úkol.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Jas toho světla mne docela oslepil a tak jsem klopýtal do Damašku, veden za ruce svými průvodci. ");
INSERT INTO ceslb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tam mne navštívil Ananiáš, zbožný ctitel zákona, kterého si židé v Damašku velice vážili. ");
INSERT INTO ceslb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Přišel a řekl mi: ‚Bratře Saule, otevři oči!‘ Tu se mi vrátil zrak a já ho uviděl. ");
INSERT INTO ceslb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Řekl ještě: ‚Tak to chtěl Bůh, abys konečně poznal jeho vůli, abys uviděl Božího Spravedlivého a uslyšel jeho vlastní hlas. ");
INSERT INTO ceslb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Staneš se Ježíšovým svědkem celému světu a budeš všude vyprávět, co jsi viděl a slyšel. ");
INSERT INTO ceslb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Neváhej, vyznej, že je tvým Pánem, dej se pokřtít na znamení, že jsi očištěn od hříchů.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Později, když jsem se vrátil do Jeruzaléma a modlil se v chrámu, měl jsem ještě jedno vidění. ");
INSERT INTO ceslb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Viděl jsem Pána a slyšel jeho slova: ‚Nezdržuj se a rychle odejdi z Jeruzaléma. Tady nepřijmou tvoje svědectví o mně.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ale já jsem odporoval: ‚Pane, tady jsem dával tvoje věrné věznit a bičovat v synagogách. ");
INSERT INTO ceslb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tady byla prolita první krev, krev tvého svědka Štěpána. Já byl při tom, souhlasil jsem s tím a hlídal jsem pláště těm, kdo ho kamenovali. Všichni to tu o mně vědí.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pán mi však řekl: ‚Jen jdi, protože tě pošlu k pohanům.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","23","Až potud dav Pavla pozorně poslouchal, ale zmínka o pohanech je znovu pobouřila. Začali mávat plášti, házeli na něho hrsti prachu a křičeli: „Pryč s tím zrádcem! Na smrt! Nemá tu co dělat!“ ");
INSERT INTO ceslb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Velitel dal Pavla rychle odvést do pevnosti a nařídil, aby ho zbičovali a vyslechli; chtěl vědět, čím vzbudil tolik nenávisti. ");
INSERT INTO ceslb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Už ho připoutali k bičovací lavici, když se Pavel obrátil k velícímu setníkovi: „Nemáte přece právo bičovat římského občana. Musím být postaven před řádný soud.“ ");
INSERT INTO ceslb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Důstojník dal přerušit přípravy, šel k veliteli a hlásil mu: „Stal se nějaký omyl, ten člověk prohlašuje, že je občanem Říma.“ ");
INSERT INTO ceslb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Velitel s ním šel k Pavlovi a zeptal se: „Je pravda, že jsi římský občan?“ „Ano, jsem,“ odpověděl vězeň. ");
INSERT INTO ceslb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Velitel zapochyboval: „Vím z vlastní zkušenosti, že je to pěkně drahé. Kdepak bys na to vzal?“ Pavel řekl: „Já jsem nic nekupoval, jsem občanem od narození.“ ");
INSERT INTO ceslb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Po tomto prohlášení vojáci odhodili důtky a spěšně jej odvazovali. Velitel měl obavy, protože se dopustil takového přehmatu vůči rodilému římskému občanu. Rozhodl se, že vyšetří, z čeho židé Pavla vlastně obviňují. ");
INSERT INTO ceslb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Na velitelovu žádost se nazítří sešla židovská velerada za předsednictví úřadujícího i minulého velekněze. ");
INSERT INTO ceslb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Když byl Pavel předveden k výslechu, nijak se nezalekl a odvážně začal: „Bratři, sám Bůh ví, že mám čisté svědomí.“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Velekněz Ananiáš to považoval za rouhání a přikázal strážnému, aby vězně udeřil přes ústa. ");
INSERT INTO ceslb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pavel na něj zavolal: „Ty křiváku, tebe jednou udeří Bůh! Tváříš se jako ochránce zákona a místo spravedlivého soudu rozdáváš rány.“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Strážní ho okřikli: „Takhle mluvíš s Božím veleknězem?“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pavel se omlouval: „Nevěděl jsem, bratři, že je to velekněz. Vím, že je psáno: Nespílej svému vládci!“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Věděl však, že v radě jsou dva tábory, saducejský a farizejský. Zvolal tedy, aby to všichni slyšeli: „Bratři, jsem farizej a byl jsem tak už od mládí vychován. Jsem postaven před soud, protože hlásám naději na vzkříšení a věčný život!“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tím se mu podařilo vnést do velerady rozkol. ");
INSERT INTO ceslb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saducejové totiž popírali vzkříšení, věčný život a existenci duchovního světa, kdežto farizejové to všechno vyznávali. ");
INSERT INTO ceslb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Obě strany se do sebe pustily a byla z toho velká hádka. Bohoslovci farizejského směru nakonec žádali, aby byl Pavel osvobozen. Říkali: „Vždyť se ničím neprovinil. Co když k němu skutečně promluvil duch nebo anděl? Abychom se nestavěli proti Bohu!“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Teď teprve vypuklo pobouření. Velitel se polekal, že vězeň, za kterého ručil, by mohl být ubit. Přivolal rychle vojáky, vysvobodili Pavla z té vřavy a dal ho znovu odvést do pevnosti. ");
INSERT INTO ceslb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Té noci se Pavlovi ukázal Pán Ježíš a posiloval ho slovy: „Neztrácej odvahu! Vydal jsi o mně statečné svědectví v Jeruzalémě a vydáš je i v samotném Římě.“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Druhý den ráno se smluvilo přes čtyřicet židovských mužů, ");
INSERT INTO ceslb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","šli k velekněžím a prohlásili: „Přísahali jsme si, že se nedotkneme jídla ani pití, dokud toho Pavla nezabijeme. ");
INSERT INTO ceslb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vzkažte veliteli, ať ho znovu přivede do velerady, a řekněte, že se chcete jeho případem důkladněji zabývat. My si na něj počkáme a na cestě ho sprovodíme ze světa.“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","O tomto spiknutí se však dověděl syn Pavlovy sestry. Podařilo se mu strýce v pevnosti navštívit a varovat. ");
INSERT INTO ceslb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pavel požádal sloužícího důstojníka: „Prosím, zaveď toho mládence k veliteli, má pro něho důležité sdělení.“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","21","Důstojník jeho přání vyhověl. Velitel hovořil s Pavlovým synovcem mezi čtyřma očima. Ten mu řekl: „Židé chystají léčku; zítra tě požádají, abys jim vězně znovu přivedl do velerady, že ho musí ještě důkladněji vyslechnout. Cestou však bude na Pavla číhat víc než čtyřicet mužů ke všemu odhodlaných; zavázali se slavnostní přísahou, že ho zabijí. Jeho život, pane, je ve tvých rukou!“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Velitel mladíka propustil a varoval ho: „Nikomu ani slovo, že o tom vím!“ Rozhodl se, že raději Pavla odešle pod bezpečným doprovodem k římskému místodržiteli Felixovi do Césareje. ");
INSERT INTO ceslb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Dvěma důstojníkům vydal rozkaz, aby v devět hodin večer nastoupilo dvě stě pěšáků, sedmdesát jezdců a dvě stě lehkooděnců. ");
INSERT INTO ceslb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pro vězně měli připravit nosítka mezi dvěma mezky. ");
INSERT INTO ceslb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Po důstojníkovi eskorty poslal dopis tohoto znění: ");
INSERT INTO ceslb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","„Klaudius Lysias ctěnému místodržiteli Felixovi. ");
INSERT INTO ceslb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Muže, kterého ti posílám, jsem se svým oddílem zachránil z rukou židů. Ti ho málem zabili. Zjistil jsem totiž, že je to římský občan. ");
INSERT INTO ceslb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Abych se dozvěděl, co vlastně proti němu mají, dal jsem ho předvést jejich veleradě. ");
INSERT INTO ceslb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ukázalo se, že nejde o žádný vážný nebo dokonce hrdelní zločin, ale pouze o jejich náboženské spory. ");
INSERT INTO ceslb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Dostal jsem však zprávu, že ho chtějí úkladně zavraždit, a tak ho rychle posílám pod tvoji ochranu. Zároveň dávám na vědomí veleradě, že žalobu na něho mohou podat u tebe. Srdečně tě zdravím!“ ");
INSERT INTO ceslb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Pěší oddíly provázely vězně v noci na hranice Judska, do Antipatridy, odkud se vrátily do kasáren. ");
INSERT INTO ceslb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Za dne doprovodila Pavla již jen jízda. ");
INSERT INTO ceslb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","V Césareji jej předali místodržiteli a odevzdali mu i velitelův dopis. ");
INSERT INTO ceslb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felix vzkaz přečetl a hned se zajímal, ze které římské provincie Pavel pochází, zda totiž vůbec spadá pod jeho pravomoc. Když se dověděl, že je z Kilikie, ");
INSERT INTO ceslb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","řekl: „Vyslechnu tě, až se dostaví tvoji žalobci.“ A dal Pavla střežit ve vládní budově, kterou kdysi postavil Herodes Veliký. ");
INSERT INTO ceslb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Za pět dní dorazil do Césareje sám velekněz Ananiáš v doprovodu několika členů velerady a právního zástupce Tertulla, aby Pavla zažalovali u místodržitele. Ten dal vězně přivést ");
INSERT INTO ceslb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","a Tertullus přednesl obžalobu: „Slavný Felixi! Náš národ ti vděčí za mnoho; tvou zásluhou žijeme již tolik let v míru a pod tvou moudrou vládou se nám dobře daří. Mohl bych tě chválit mnohem déle, ale nechci si dělat nárok na tvůj vzácný čas. ");
INSERT INTO ceslb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Vyjádřím se stručně a prosím, abys nám laskavě věnoval pozornost. ");
INSERT INTO ceslb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Máme důkazy, že tenhle člověk patří k vůdcům křesťanské sekty a znamenitě přispívá k tomu, že se v celé říši mezi židy jako epidemie šíří jejich buřičské názory. ");
INSERT INTO ceslb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nakonec chtěl také znesvětit jeruzalémský chrám. Přitom jsme ho chytili a chtěli jej soudit podle našich zákonů. ");
INSERT INTO ceslb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Velitel Lysias se ho však násilně zmocnil a nás odkázal na tebe. ");
INSERT INTO ceslb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Vyslechni ho a přesvědčíš se, že naše stížnosti jsou oprávněné.“ ");
INSERT INTO ceslb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Potom vystoupili židé jako svědkové obžaloby. ");
INSERT INTO ceslb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nato pak udělil místodržitel slovo Pavlovi. Ten řekl: „Vím, že náš národ spravuješ již delší dobu. Důvěřuji tvým zkušenostem a na svoji obhajobu chci uvést jen to, co si můžeš ověřit. ");
INSERT INTO ceslb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Před dvanácti dny jsem dorazil do Jeruzaléma jako poutník do svatyně. ");
INSERT INTO ceslb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ani v chrámu ani v synagogách jsem za tu dobu nepronesl jediný veřejný projev, s nikým jsem nediskutoval a nikoho jsem nepodněcoval ke vzpouře. ");
INSERT INTO ceslb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nic takového mi nemohou dokázat. ");
INSERT INTO ceslb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Rád se ovšem před tebou přiznávám, že sloužím Bohu našich otců podle způsobu, který oni považují za sektářství. ");
INSERT INTO ceslb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Věřím všemu, co je psáno u Mojžíše i proroků, a vyznávám naději na vzkříšení všech lidí z mrtvých, což ostatně hlásají i mnozí mezi nimi. ");
INSERT INTO ceslb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tato víra mě zavazuje, abych se choval před Bohem i před lidmi podle svého nejlepšího svědomí. ");
INSERT INTO ceslb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Nyní se po několika letech vracím a nesu chudým svého lidu peněžitou podporu od křesťanů z jiných národů. ");
INSERT INTO ceslb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","Když jsem pak v chrámu podstupoval předepsané náboženské očišťování, nařkli mě někteří židé z Malé Asie, že jsem tam přivedl pohany. Nebyla to ovšem pravda a ty židy ani nevidím mezi žalobci. To oni způsobili srocení ve svatyni, ne já. ");
INSERT INTO ceslb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ani velerada mi nedokázala žádný zločin. ");
INSERT INTO ceslb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Jediné, co jsem tam stačil říci, bylo: ‚Mám být souzen pro víru ve vzkříšení!‘ “ ");
INSERT INTO ceslb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix už sice o křesťanství něco věděl, ale přesto líčení odročil s tím, že musí ještě vyslechnout svědectví velitele Lysia. ");
INSERT INTO ceslb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Důstojníkovi pak nařídil, aby Pavla držel jen v lehkém vězení, kde by ho mohli jeho přátelé navštěvovat a posloužit mu. ");
INSERT INTO ceslb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Po několika dnech si dal Felix Pavla předvést v přítomnosti své manželky Drusilly, která byla židovka, a vyptával se ho na učení Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pavel ochotně vykládal, ale když začal mluvit o otázkách mravnosti, sebeovládání a Božího soudu, bylo to Felixovi nepříjemné a přerušil ho: „Pro dnešek to stačí, zase si tě pozvu, až budu mít čas.“ ");
INSERT INTO ceslb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Opravdu si pro Pavla často posílal a hovořil s ním, ale hlavně proto, že od něho čekal nějaký úplatek. Aby si usmířil židy, nechával Pavla i nadále ve vězení. ");
INSERT INTO ceslb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Tak to trvalo po celé dva roky, až byl Felix v úřadě vystřídán Porciem Festem. ");
INSERT INTO ceslb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Třetí den po převzetí úřadu přijel Festus z Césareje do Jeruzaléma, ");
INSERT INTO ceslb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","kde přijal velekněze a další židovské představitele. Ti mu připomněli svou žalobu proti Pavlovi a snažili se pohnout Festa k tomu, ");
INSERT INTO ceslb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","aby dal vězně dopravit zase zpět do Jeruzaléma; ve skutečnosti však zamýšleli Pavla na cestě přepadnout a zavraždit. ");
INSERT INTO ceslb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus je však odbyl: „Vězeň je v Césareji a já se tam vrátím co nevidět. ");
INSERT INTO ceslb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Vyšlete se mnou své zplnomocněnce, a máte-li svou žalobu dobře podloženou, ať ji přednesou u řádného soudu.“ ");
INSERT INTO ceslb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","V Jeruzalémě se zdržel ještě osm deset dní a pak se vrátil do Césareje. ");
INSERT INTO ceslb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Hned následující den zahájil přelíčení a dal Pavla předvést. Jeruzalémští vyslanci vězně obžalovali z mnoha zločinů, ale neměli pro ně žádné důkazy. ");
INSERT INTO ceslb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pavlova obhajoba zněla: „Neprovinil jsem se ani proti židovskému zákonu, ani proti chrámovým předpisům, a tím méně proti římskému právu.“ ");
INSERT INTO ceslb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus chtěl židům ukázat dobrou vůli, a tak Pavlovi navrhl: „Jsi ochoten postavit se v Jeruzalémě před soud, kterému bych předsedal?“ ");
INSERT INTO ceslb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pavel vytušil smrtelné nebezpečí, a tak odmítl: „Ne, trvám na tom, abych byl ponechán v pravomoci římského soudu. Sám jsi zjistil, že jsem se proti židům nijak neprovinil. ");
INSERT INTO ceslb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kdyby mně byl prokázán nějaký zločin, byl bych ochoten podstoupit spravedlivý trest, třeba i popravu. Jejich žaloby jsou však smyšlené a ty nemáš právo vydat mě jim. Odvolám se k císařovu soudu!“ ");
INSERT INTO ceslb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus se odebral k poradě se svými rádci a vynesl rozsudek: „Odvoláváš se k císaři, tedy tam půjdeš.“ ");
INSERT INTO ceslb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","14","Po několika dnech navštívil Césareju král Herodes Agrippa se svojí sestrou Bereniké. Přijeli přivítat Festa a zdrželi se u něho delší dobu. Festus se jim při jedné příležitosti zmínil: „Podědil jsem tu po Felixovi zvláštního vězně. ");
INSERT INTO ceslb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","V Jeruzalémě na něho žalovali velekněží a velerada a žádali na mně rozsudek smrti. ");
INSERT INTO ceslb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Musel jsem jim dát lekci z římského práva a poučit je, že my Římané nikoho nesoudíme bez řádného slyšení obou stran a že každý musí dostat možnost obhajoby. ");
INSERT INTO ceslb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Hned po mém návratu do Césareje se dostavili žalobci, a tak jsem toho muže vyslechl. ");
INSERT INTO ceslb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Očekával jsem kdovíjaké zločiny, ale nic takového mu nemohli dokázat. ");
INSERT INTO ceslb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Mají nějaké náboženské spory o jakéhosi Ježíše; byl popraven, ale ten Pavel tvrdí, že žije. ");
INSERT INTO ceslb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","21","V tom se ovšem nevyznám. Když jsem mu navrhl, aby se obhajoval přímo v Jeruzalémě, trval na tom, aby byl ponechán v pravomoci římského soudu. Je to římský občan, a dokonce se odvolal k císaři. Tak ho tu mám ve vězení a s příštím transportem ho musím poslat do Říma.“ ");
INSERT INTO ceslb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa řekl Festovi: „Ten člověk mě zajímá, rád bych si ho poslechl.“ Festus tedy navrhl, že uspořádá slyšení hned následujícího dne. ");
INSERT INTO ceslb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nazítří se dostavili Agrippa a Bereniké v celé královské pompě s dvorní suitou i hodnostáři města. ");
INSERT INTO ceslb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus dal předvést Pavla a představil ho slovy: „Králi Agrippo, dámy a pánové! To je člověk, jehož smrt tak neodbytně vymáhají židé v Jeruzalémě i zde. ");
INSERT INTO ceslb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","27","Nedopustil se ničeho, za co by podle římského práva mohl být odsouzen k smrti. Sám se však odvolal k jeho císařskému veličenstvu, a tak jsem se rozhodl poslat ho do Říma. Jsem teď na rozpacích, co uvést v obžalovacím spisu, který musím vystavit. Snad mně v tom pomůžete vy, znalci židovských záležitostí, a zvláště ty, králi, až ho vyslechnete.“ ");
INSERT INTO ceslb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa vyzval Pavla: „Pověz, co můžeš uvést na svou obhajobu!“ Pavel pozvedl ruku po způsobu řečníků a začal: ");
INSERT INTO ceslb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","„Jsem rád, králi Agrippo, že se mohu hájit proti obžalobám židů právě před tebou. ");
INSERT INTO ceslb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Vím, že znáš dobře židovské zvyky i sporné otázky. Chci ti vše vyložit od začátku, a tak tě prosím o trpělivost. ");
INSERT INTO ceslb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","5","Už v mládí jsem přišel do Jeruzaléma a všichni se tam na mne pamatují. Musejí připustit, že jsem patřil k nejhorlivější skupině našeho náboženství, k farizejům. ");
INSERT INTO ceslb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","7","A vlastně i dnes stojím před soudem proto, že pevně držím to nejlepší, co vyznávají farizejové: že totiž Bůh splní sliby, které dal našim otcům, když mu budeme všichni vytrvale sloužit. ");
INSERT INTO ceslb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Možná, že vám to připadá absurdní, ale opravdu věřím, že Bůh vzkřísí mrtvé. ");
INSERT INTO ceslb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Tehdy jsem se ovšem i já domníval, že musím všemi prostředky bojovat proti učení Ježíše z Nazaretu, ");
INSERT INTO ceslb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","a byl jsem při tom v Jeruzalémě nejhorlivější. Velekněží mne zplnomocnili, abych Ježíšovy následovníky vyhledával, zatýkal a dával uvěznit. Vždy jsem byl pro to, aby byli odsouzeni k smrti. ");
INSERT INTO ceslb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Dával jsem ty lidi bičovat v synagogách a nutil je, aby veřejně tupili svou víru. Byl jsem jako posedlý a začal jsem je pronásledovat i v jiných městech. ");
INSERT INTO ceslb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Tak jsem se také vypravil s plnou mocí od velekněží do Damašku. ");
INSERT INTO ceslb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A tu na cestě, ačkoliv to bylo v pravé poledne, nás zalilo světlo, proti kterému se polední slunce zdálo stínem. ");
INSERT INTO ceslb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","V úleku jsme se vrhli na zem a ke mně promluvil hlas v hebrejštině: ‚Saule, Saule, proč mne pronásleduješ? Proč biješ hlavou proti zdi?‘ ");
INSERT INTO ceslb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Zeptal jsem se: ‚Kdo jsi, pane?‘ a on mi odpověděl: ‚Já jsem Ježíš, proti kterému se stavíš. ");
INSERT INTO ceslb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ale teď vstaň a poslouchej: Jak jsi mne horlivě pronásledoval, tak horlivě mne budeš vyznávat. Budeš svědkem toho, žes mne potkal, a všeho, co ti ještě ukáži. ");
INSERT INTO ceslb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Budu tě chránit před lidmi, židy i pohany, mezi kterými ti dávám nesnadný úkol: ");
INSERT INTO ceslb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Budeš jim otevírat oči oslepené hříchem, aby přestali tápat ve tmě, kde vládne satan a aby vešli do Božího světla. Všem, kdo ve mne uvěří, odpustím hříchy a dám jim místo mezi svým lidem, který usiluje o nový způsob života podle mé vůle.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Jistě uznáš, Agrippo, že jsem nemohl odmítnout tak zřetelný pokyn z nebe. ");
INSERT INTO ceslb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","A tak jsem začal hned v Damašku, potom v Jeruzalémě, v celém Judsku a konečně i mezi pohany volat lidi, aby se dali na pokání, obrátili se k Bohu a dotvrdili to novým životem. ");
INSERT INTO ceslb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","To je můj ‚zločin‘, pro který mne chtěli židé v chrámu ubít. ");
INSERT INTO ceslb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bůh mne však z jejich rukou vytrhl, a tak tu stojím a mohu vydávat své svědectví prostým i vznešeným. To, co hlásám, je totéž, co předpovídali proroci i Mojžíš: ");
INSERT INTO ceslb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","že Mesiáš bude trpět, že však vstane jako první z mrtvých a tak přinese naději na věčný život židům i pohanům.“ ");
INSERT INTO ceslb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","To už bylo pro Festa příliš, a proto se ozval: „Pavle, ty ses zbláznil. Znáš toho tolik, že tě to připravilo o rozum!“ ");
INSERT INTO ceslb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pavel se však bránil: „Můj rozum je v pořádku, vážený Feste. Mluvím jen pravdu a jsem plně při smyslech. ");
INSERT INTO ceslb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Král je v pojmech židovské víry doma, a proto mohu mluvit tak otevřeně. Myslím, že i o nás křesťanech dobře ví; vždyť nejsme žádná tajná sekta. ");
INSERT INTO ceslb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Jde vlastně o to, králi Agrippo, zda skutečně věříš tomu, co předpověděli židovští proroci. A já vím, že věříš.“ ");
INSERT INTO ceslb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa mu řekl: „Mluvíš tak, že bys mne málem přesvědčil, abych se stal křesťanem.“ ");
INSERT INTO ceslb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pavel nato odpověděl: „Kéž by Bůh dal, abys nejen ty, ale vy všichni byli to, co jsem já, až na ty řetězy.“ ");
INSERT INTO ceslb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Král, místodržitel, Bereniké a pak i ostatní se zvedli a odcházeli. ");
INSERT INTO ceslb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Jejich shodný úsudek byl, že Pavel nespáchal nic, zač by si zasloužil smrt nebo vězení. ");
INSERT INTO ceslb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa řekl Festovi: „Nebýt toho odvolání k císaři, mohl bys ho klidně propustit.“ ");
INSERT INTO ceslb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Přišel čas transportu vězňů do Itálie. Byl do něho zařazen také Pavel a my s Makedoncem Aristarchem z Tesaloniky jako jeho průvodci. Transportu velel důstojník Julius z císařského oddílu. ");
INSERT INTO ceslb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Najal loď, která obeplouvala pobřeží Malé Asie a na cestě k jejímu severnímu cípu měla udělat řadu zastávek. ");
INSERT INTO ceslb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Když jsme druhý den přistáli v Sidónu, dovolil důstojník Julius, který zacházel s Pavlem skutečně lidsky, aby navštívil ve městě své přátele; ti ho vybavili na cestu vším potřebným. ");
INSERT INTO ceslb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kvůli nepříznivému větru jsme se dále plavili mezi Kyprem a pevninou; ");
INSERT INTO ceslb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","minuli jsme Kilikii a Pamfylii a přistáli nakonec v lykijské Myře. ");
INSERT INTO ceslb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tam velitel najal alexandrijskou loď, která měla namířeno do Itálie, a převedl nás na ni. ");
INSERT INTO ceslb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","8","Po několik dalších dní byla plavba obtížná a v Knidu jsme ani nemohli přistát, jak silný vítr vál od pevniny. Propluli jsme tedy mezi Krétou a ostrovem Salmonou a s námahou jsme se drželi jižního pobřeží Kréty až do „Dobrých přístavů“ u Lasaia. ");
INSERT INTO ceslb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Měli jsme zpoždění, byl již konec září a plavba přes otevřené moře je v tomto období nebezpečná. Pavel jako zkušený cestovatel varoval: ");
INSERT INTO ceslb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","„Jestli teď vyplujete, dáváte v sázku nejen loď a její náklad, ale i životy nás všech.“ ");
INSERT INTO ceslb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","12","Důstojník však dal víc na kapitána a majitele lodi, kteří radili sledovat ještě dále krétské pobřeží až k jihozápadnímu přístavu Foiniku. Tvrdili, že je vhodnější k přezimování lodi než Lasaia. Zdálo se, že se to podaří, protože začal vát jižní vítr. Tak jsme tedy zvedli kotvy. ");
INSERT INTO ceslb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Zanedlouho se však zvedl od Kréty silný severovýchodní vítr, kterému loď nemohla vzdorovat, a ten nás unášel dál a dál od krétského pobřeží. ");
INSERT INTO ceslb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","16","Přišel tak nenadále, že jsme ani nestačili naložit do lodi záchranný člun, obvykle vlečený vzadu. To se nám podařilo až v závětří ostrůvku Klauda. ");
INSERT INTO ceslb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Námořníci stáhli lany trup lodi, aby lépe odolával, a spustili vlečnou kotvu, abychom snad v plné rychlosti nenajeli na nebezpečné mělčiny Syrtis u afrického pobřeží. ");
INSERT INTO ceslb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Druhý den vlny už dosahovaly nebezpečné výše, takže jsme museli zmenšit ponor lodi: plavci vyházeli část nákladu ");
INSERT INTO ceslb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","a další den i část lodní výstroje. ");
INSERT INTO ceslb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Po mnoho dní bylo zataženo, neviděli jsme slunce ani hvězdy, takže jsme ztratili orientaci a divoká bouře stále zmenšovala naši naději na záchranu. ");
INSERT INTO ceslb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Po celou tu dobu nikdo na lodi ani nepomyslel na jídlo. Pavel vyšel na palubu a oslovil námořníky: „Přátelé, měli jste dát na mne a přezimovat na Krétě v ‚Dobrých přístavech‘. Byli byste si ušetřili spoustu těžkostí a škod. ");
INSERT INTO ceslb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ale neklesejte na mysli, není všechno ztraceno: nikdo z nás nezahyne, jen loď vezme za své. ");
INSERT INTO ceslb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Dnes v noci se mi zjevil posel Boha, kterému náležím a sloužím, ");
INSERT INTO ceslb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","a řekl mi: ‚Neboj se, Pavle, máš ještě stát před císařem! Jako dar ti Bůh přidá životy všech, kteří se s tebou plaví.‘ ");
INSERT INTO ceslb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Odvahu, přátelé! Já věřím svému Bohu, že se jeho vzkaz doslova splní. ");
INSERT INTO ceslb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Máme se zachránit na nějakém ostrově.“ ");
INSERT INTO ceslb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Už čtrnáctou noc jsme byli unášeni Středozemním mořem do neznáma, když kolem půlnoci hlídka hlásila zemi na obzoru. ");
INSERT INTO ceslb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Námořníci spustili olovnici a naměřili hloubku čtyřiceti metrů a po chvíli už jen třicet metrů. ");
INSERT INTO ceslb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Dostali strach, že bychom mohli potmě najet na skaliska, a tak vyhodili přes záď čtyři kotvy a všichni jsme toužebně očekávali svítání. ");
INSERT INTO ceslb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ale námořníci chtěli zrádně opustit ohroženou loď. Spustili na moře záchranný člun, jako že roztáhnou ještě další kotvy z přídi. ");
INSERT INTO ceslb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pavel však postřehl jejich pravý úmysl a řekl důstojníkovi a vojákům: „Pozor na ně, bez nich se nezachráníte!“ ");
INSERT INTO ceslb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Vojáci tedy přesekli lana člunu a nechali ho odplout prázdný. ");
INSERT INTO ceslb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ještě než se rozednilo, přesvědčoval Pavel posádku: „Čtrnáct dní tu zápolíte, hlídáte a přitom skoro nic nedáte do úst. ");
INSERT INTO ceslb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Alespoň teď se pořádně najezte, ať máte sílu dostat se na břeh. Řekl jsem vám přece, že se nikomu nic nestane.“ ");
INSERT INTO ceslb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Vzal chléb, přede všemi za něj Bohu nahlas poděkoval a začal jíst. ");
INSERT INTO ceslb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ostatní to povzbudilo a dali se také do jídla. ");
INSERT INTO ceslb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bylo nás tam všech dohromady dvě sta sedmdesát šest. ");
INSERT INTO ceslb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Když jsme se najedli, vyhazovali námořníci do moře obilí, hlavní náklad, aby zmenšili ponor lodi. ");
INSERT INTO ceslb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Konečně se rozednilo. Viděli jsme před sebou pás plochého pobřeží se zálivem, ale nikdo tu zemi neznal. Plavci se chtěli pokusit o přistání v zátoce. ");
INSERT INTO ceslb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Kotvy nevytahovali, ale odsekli kotevní lana, odvázali upevněné kormidlo a s přední plachtou na stožáru se pustili ke břehu. ");
INSERT INTO ceslb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Brzy jsme však najeli na písčinu a loď uvázla. Příď se zabořila pevně do dna a prudký příboj začal rozbíjet záď. ");
INSERT INTO ceslb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Vojáci se už chystali podle římských pravidel pro takové situace pobít všechny vězně, aby některý z nich neodplaval na břeh a neutekl. ");
INSERT INTO ceslb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Velitel však chtěl zachovat Pavla při životě, vzal na sebe odpovědnost a nedovolil jim to. Nařídil, aby nejprve skočili přes palubu ti, kdo umějí plavat, ");
INSERT INTO ceslb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ostatní ať si opatří kusy dřeva z lodi a všichni ať se snaží dostat na břeh. Tak nikdo neutonul a všichni se v pořádku dostali na souš. ");
INSERT INTO ceslb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Od lidí, kteří se seběhli k místu naší záchrany, jsme se dozvěděli, že jsme na ostrově Malta. ");
INSERT INTO ceslb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Byli k nám neobyčejně laskaví. Pršelo a bylo zima, a tak nám rozdělali velký oheň a vůbec se o nás starali. ");
INSERT INTO ceslb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pavel také pomáhal sbírat chrastí. Jak je však přikládal na oheň, vylezla z jeho otýpky zmije vypuzená horkem a zakousla se mu do ruky. ");
INSERT INTO ceslb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mezi domorodci se ozvalo: „Ten člověk je jistě vrah! Zachránil se z moře, ale božské spravedlnosti neutekl.“ ");
INSERT INTO ceslb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pavel však klidně hada setřásl do ohně a nic zlého se s ním nedělo. ");
INSERT INTO ceslb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Lidé čekali, že opuchne a zemře. Když však byl Pavel i po hodné době v pořádku, začali si lidé šeptat, že je to asi nějaký vtělený bůh. ");
INSERT INTO ceslb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Zachránili jsme se na pomezí statků Publia, římského správce ostrova. Přijal nás a tři dny přátelsky hostil. ");
INSERT INTO ceslb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiův otec stonal – byl postižen horečnatou úplavicí. Pavel ho navštívil, modlil se nad ním a pak ho dotekem rukou uzdravil. ");
INSERT INTO ceslb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Rozkřiklo se to po ostrově, a tak ze všech stran přicházeli za Pavlem nemocní a on je uzdravoval. ");
INSERT INTO ceslb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Za to si nás ohromně vážili a před odjezdem nás zahrnuli všemi potřebnými věcmi. ");
INSERT INTO ceslb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Trvalo to však tři měsíce, než jsme mohli pokračovat v cestě. Vzala nás loď, která měla domovský přístav v Alexandrii a jejímž znamením byla dvojčata Kastor a Pollux, ochránci námořníků. ");
INSERT INTO ceslb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Přistála nejprve v Syrakusách na Sicílii, kde jsme se zdrželi tři dny. ");
INSERT INTO ceslb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Pak jsme přepluli úžinu do Regia a s jižním větrem v zádech jsme se po dalších dvou dnech dostali do přístavu Puteoli. ");
INSERT INTO ceslb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tam tedy skončila naše pohnutá plavba do Itálie. Na prosby tamních křesťanů jsme zůstali v Puteolech celý týden. ");
INSERT INTO ceslb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Odtud jsme se pěšky vydali do Říma. Mezitím se o nás dozvěděli bratři v Římě a někteří nám přišli naproti sedmdesát kilometrů, až na Appiovo tržiště, jiní alespoň ke Třem hospodám. Když se s nimi Pavel setkal, děkoval Bohu a šel dál s novou odvahou. ");
INSERT INTO ceslb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","V Římě byl potom umístěn v soukromém bytě – vždy s jedním vojenským strážcem. ");
INSERT INTO ceslb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tři dny po příchodu do Říma si Pavel k sobě pozval tamní významné židy. Když přišli, řekl jim: „Bratři, nijak jsem se neprovinil proti našemu národu, ani proti našim tradicím. Přesto jsem byl v Jeruzalémě uvězněn a předán Římanům. ");
INSERT INTO ceslb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ti mě vyslýchali a byli by mě propustili, protože jsem neudělal nic, zač bych zasluhoval smrt. ");
INSERT INTO ceslb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Jeruzalémští židé však proti mně byli zaujatí, a tak jsem nakonec nucen odvolat se k císaři. Nehodlám tu však žalovat na svůj národ. ");
INSERT INTO ceslb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Proto jsem si přál setkat se s vámi a vysvětlit vám to. Pro naši společnou víru v Mesiáše mám tato pouta!“ ");
INSERT INTO ceslb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Odpověděli mu: „My jsme o tobě z Judska nedostali žádnou zprávu nebo žalobu, ani písemně, ani ústně. ");
INSERT INTO ceslb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Chtěli bychom však slyšet tvoje názory. Víme totiž, že vaše sekta se všude setkává s odporem.“ ");
INSERT INTO ceslb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dohodli se tedy na dalším setkání a pak se jich u něho sešlo mnohem více. Pavel jim celý den vykládal o tom, že Boží království přišlo mezi lidi v osobě Ježíše Krista. Snažil se je o tom přesvědčit důkazy a předpověďmi ze Starého zákona. ");
INSERT INTO ceslb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Některé získal, jiní však odmítali uvěřit. ");
INSERT INTO ceslb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Odcházeli takto rozdvojeni a Pavel těm zatvrzelým řekl: „Přesně tak to Duch svatý předpověděl vašim předkům ústy proroka Izajáše: ");
INSERT INTO ceslb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‚Jdi k tomu lidu a řekni mu: Budete naslouchat a naslouchat, a přece neporozumíte. Budete se dívat a dívat, ale nic neuvidíte. ");
INSERT INTO ceslb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Máte totiž otupělé srdce, zacpané uši a zavřené oči, aby se vám snad nestalo, že byste viděli, slyšeli a srdcem pochopili; to byste se totiž ke mně obrátili a já bych vás uzdravil.‘ “ ");
INSERT INTO ceslb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","„Proto se nedivte,“ dodal Pavel, „že zprávu o Boží záchraně hlásáme pohanům. Ti ji dychtivě přijímají.“ ");
INSERT INTO ceslb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Celé dva roky byl Pavel ve svém soukromém římském vězení a směl přijímat všechny návštěvy. ");
INSERT INTO ceslb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","A tak svobodně a bez překážek hlásal Boží království a učil o Pánu Ježíši Kristu.");
INSERT INTO ceslb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Milí přátelé, jako Kristův služebník posílám všem křesťanům v Římě srdečný pozdrav a přeji vám Boží milost a pokoj. Jak víte, byl jsem pověřen šířením radostné zprávy o Božím Synu Ježíši Kristu, ");
INSERT INTO ceslb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","zprávy, kterou z Božího vnuknutí předpovídali už proroci. ");
INSERT INTO ceslb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tělesně je Kristus potomkem Davidovým, ");
INSERT INTO ceslb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ve skutečnosti je však Synem samého Boha, jak nade vší pochybnost dokázalo jeho vzkříšení z hrobu. ");
INSERT INTO ceslb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","7","Nám nehodným prokázal tu přízeň, že z nás učinil své vyslance a uložil nám vybízet lidi všech národů, aby ho uposlechli a uvěřili mu. K tomu jste byli mezi všemi povoláni i vy. ");
INSERT INTO ceslb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nemohu však zamlčet, jak jsem za vás vděčný Bohu, vždyť o vás a vaší víře se všude s uznáním hovoří. ");
INSERT INTO ceslb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bůh dobře ví, jak na vás nepřetržitě myslím ");
INSERT INTO ceslb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","a neustále ho prosím, aby mi někdy dopřál přijít k vám, bude-li chtít. ");
INSERT INTO ceslb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","12","Rád bych vás osobně viděl a rozdělil se s vámi o povzbuzení a potěšení ze společné víry. ");
INSERT INTO ceslb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Už několikrát jsem se k vám chystal, ale vždycky mi do toho něco přišlo. Tak jako v jiných zemích i u vás chci pomáhat v šíření Kristova radostného poselství. ");
INSERT INTO ceslb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Cítím totiž svůj dluh nejen vůči Řekům a vzdělancům, ale i vůči prostým lidem z jiných národů. ");
INSERT INTO ceslb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Všem chci sloužit. A tak toužím promluvit o Ježíši Kristu také u vás v Římě. ");
INSERT INTO ceslb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Za jeho poselství se rozhodně nestydím. Vždyť ono může zachránit každého, kdo mu uvěří; nejen člověka zbožného, ale i toho, kdo žil dosud bez Boha. ");
INSERT INTO ceslb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","On sám v něm oznamuje, jak se postaral o to, abychom před ním obstáli. Nežádá od nás nic jiného než bezpodmínečnou důvěru. Vždyť již prorok Abakuk napsal: „Kdo Bohu důvěřuje, obstojí před ním a bude žít.“ ");
INSERT INTO ceslb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Boží hněv se však obrací proti těm, kdo pošlapávají jeho zákony a svévolně přehlížejí pravdu. ");
INSERT INTO ceslb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Vždyť vše, co může člověk o Bohu poznat, ukázal on sám i jim. I takovým lidem Bůh poskytl možnost, aby jej poznali. ");
INSERT INTO ceslb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Jeho věčnou moc a božství, které jsou neviditelné, mohou spatřit ve stvořené přírodě. Protože nad tím zodpovědně nepřemýšleli, není pro ně omluvy. ");
INSERT INTO ceslb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Leccos o Bohu poznali, a přece ho jako Boha nectili. Spláceli mu nevděčností. To je zavedlo na scestí a jejich mysl pozbyla schopnosti rozpoznat pravdu. ");
INSERT INTO ceslb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Svou pošetilost hrdě nazývali moudrostí ");
INSERT INTO ceslb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","a místo Boha uctívali člověka a přírodu. ");
INSERT INTO ceslb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","25","Bůh jim pak už nebránil, ale nechal je, aby okusili ovoce svého počínání. ");
INSERT INTO ceslb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","27","Proto klesli do nízkých vášní. Začali holdovat pohlavním výstřednostem a oddali se homosexualitě. ");
INSERT INTO ceslb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Jejich bezbožnost je dovedla ke všemu špatnému a zlému; ");
INSERT INTO ceslb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","jsou naplněni podlostí, chamtivostí a nevraživostí. Snížili se k závisti, vraždám, svárům, podvodům a zlomyslnostem, udavačství, ");
INSERT INTO ceslb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","31","pomluvám, urážkám, pýše a domýšlivosti, neúctě k rodičům, otupělosti, bezcitnosti, věrolomnosti a nenávisti k Bohu. Každá bezzákonnost je jim vlastní. ");
INSERT INTO ceslb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ačkoliv vědí, že podle Božích ustanovení odplatou za takové věci je smrt, nejen to sami dělají, ale schvalují to i jiným. ");
INSERT INTO ceslb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","2","„Dobře jim tak,“ říkáš si, „mají, co si zasloužili.“ Ale pozor! Myslíš, že sám jsi na tom lépe? Chceš snad tvrdit, že ses nikdy ničeho špatného nedopustil? ");
INSERT INTO ceslb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Druhé soudíš a doufáš, že sám soudu ujdeš, přestože děláš totéž? ");
INSERT INTO ceslb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nepohrdáš tak i ty Boží laskavostí, trpělivostí a shovívavostí? Uvědom si, že právě Boží laskavost vede člověka k tomu, aby se zastyděl a začal nový život! ");
INSERT INTO ceslb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kdo však setrvává v tvrdošíjném odporu proti Bohu, na toho dopadne Boží hněv v den soudu. ");
INSERT INTO ceslb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","V ten den Bůh spravedlivě odplatí každému po zásluze: ");
INSERT INTO ceslb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","věčný život dá těm, kdo usilují o nepomíjející hodnoty neúnavným konáním dobra; ");
INSERT INTO ceslb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ty však, kteří prosazují sami sebe, odporují pravdě a dopouštějí se bezpráví, stihne spravedlivý trest. ");
INSERT INTO ceslb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Zlo se jako bumerang vrátí na každého, kdo je páchá, ať je to nevěrec nebo pobožnůstkář – na toho tím spíš! ");
INSERT INTO ceslb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Věčná sláva, čest a pokoj budou však odměnou všech, kdo konají dobro: věřících především, ale stejně tak i nekřesťanů. ");
INSERT INTO ceslb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","U Boha neplatí žádná protekce. ");
INSERT INTO ceslb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Každý, kdo hřeší proti Božím přikázáním, musí zahynout, ať už je zná či nikoliv. ");
INSERT INTO ceslb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Aby byl člověk uznán za bezúhonného, k tomu nestačí zákon pouze znát; je nutno také jej plnit. ");
INSERT INTO ceslb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Jestliže nevěrci, přestože Boží zákon neznají, jednají podle svého svědomí tak, že je to v souladu s Božími příkazy, ");
INSERT INTO ceslb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","dokazují tím, že Boží zákon skrytě existuje v jejich svědomí. Ono je jejich zákonem, který je buď obviňuje nebo obhajuje, ");
INSERT INTO ceslb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","a to se ukáže i v den soudu, kdy Bůh odhalí hlubiny lidského nitra. ");
INSERT INTO ceslb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ty jsi věřící, spoléháš na příslušnost k církvi, oháníš se Bohem, ");
INSERT INTO ceslb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","znalostí jeho vůle, poučen Biblí umíš věci správně hodnotit. ");
INSERT INTO ceslb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","20","Domníváš se, že ostatní jsou slepí, nevzdělaní a nevychovaní a ty že jsi jejich vůdce, učitel a vychovatel, poněvadž z Bible čerpáš pravé vědění a poznání. ");
INSERT INTO ceslb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Jak je tedy možné, když druhé poučuješ, že si sám poučení nebereš? Kážeš, že krást je hřích, ale to ti nebrání, aby sis přivlastňoval cizí majetek? ");
INSERT INTO ceslb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Druhým cizoložství zakazuješ, sobě ne? Modláře zatracuješ, jejich peníze jsou ti však dobré? ");
INSERT INTO ceslb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Na všechno máš pohotově biblický citát, ale Boha urážíš tím, že ho neposloucháš. ");
INSERT INTO ceslb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Jaký div, že se nevěrci Bohu posmívají, když u věřících vidí takové jednání! ");
INSERT INTO ceslb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Na svém vyznání si může zakládat jen ten, kdo podle něj žije. ");
INSERT INTO ceslb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Jestliže se věřící člověk ve svém jednání rozchází s učením Bible, není víc než pohan a nevěrec. ");
INSERT INTO ceslb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Spíše má právo počítat se mezi lidi ten, kdo Boha sice nezná, ale žije v souladu s Božími požadavky. Takový člověk, který zásady tvé víry nepoznal – ač třeba jiného náboženství nebo ateista, pokud žije podle biblických zásad, plným právem zahanbí tebe se vším tvým náboženstvím, jehož zákony přestupuješ. ");
INSERT INTO ceslb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Pravým židem rozhodně není ten, kdo tak navenek vypadá nebo se může vykázat židovským původem. To snad udělá dojem na lidi. ");
INSERT INTO ceslb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Před Bohem však je rozhodující čistota srdce. ");
INSERT INTO ceslb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Přece však má židovský národ zvláštní postavení a určité výsady. Jaké? Není jich málo! ");
INSERT INTO ceslb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Předně jim byla svěřena Boží slova. ");
INSERT INTO ceslb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","A co když jim někteří neuvěřili – můžete namítnout. A já se ptám: Myslíte, že Bůh jen pro jejich nedůvěru nedostojí svému slovu? ");
INSERT INTO ceslb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ale kdepak! Právě na tom ukáže, jak dovede být věrný i tehdy, když mu člověk nevěří. Tak to stojí i v Písmu: „Každý uzná, že čestně dodržíš to, co jsi slíbil, a jako vítěz vyjdeš z každého obvinění.“ ");
INSERT INTO ceslb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Někdo však může namítnout: „Jestliže naše špatnost dává vyniknout Boží spravedlnosti, snad by nás Bůh neměl za ni trestat.“ ");
INSERT INTO ceslb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Jaký smysl by potom měl Boží soud? ");
INSERT INTO ceslb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","To bychom mohli rovnou nabádat ke zlu, aby se dobro vedle něj tím víc zaskvělo. ");
INSERT INTO ceslb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Někteří lidé to opravdu dělají, ale my ne, i když nás z toho obviňují. Takoví hříšníci budou plným právem odsouzeni. ");
INSERT INTO ceslb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Napsal jsem vám již, že židovský národ má určité přednosti. To však neznamená, že židé jsou před Bohem lepší než ostatní. O všech lidech je v Žalmech napsáno: ");
INSERT INTO ceslb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","„Nikdo na světě není spravedlivý, ani jediný. ");
INSERT INTO ceslb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nikdo není moudrý, nikdo Boha nehledá. ");
INSERT INTO ceslb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Všichni úplně zabloudili, jejich život ztratil smysl. Opuštěná je cesta dobra, nikdo po ní nekráčí. ");
INSERT INTO ceslb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","14","Jejich hrdlo – otevřený hrob; jazyk – nástroj lsti a podvodu; rty – schránky jedu, uštknou tě jako had. ");
INSERT INTO ceslb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","K prolití krve je nemusíš pobízet, ");
INSERT INTO ceslb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","zkáza a bída jsou jejich průvodci, ");
INSERT INTO ceslb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","cestu k pokoji však neznají, ");
INSERT INTO ceslb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ani úctu před Bohem.“ ");
INSERT INTO ceslb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Víme však, že ustanovení zákona jsou závazná pro všechny, kterým byla určena. Každý tu musí uznat, že před Bohem je vinen, ");
INSERT INTO ceslb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","neboť sebeupřímnější snahou dodržovat zákon si nikdo před Bohem nedobude postavení bezúhonného; zákon naši vinu pouze blíže určuje a usvědčuje nás z ní. ");
INSERT INTO ceslb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Dnes však už známe jinou cestu k věčnému životu než spoléhání se na vlastní dodržování Božích zákonů. Už Mojžíš a proroci o ní mluvili, ");
INSERT INTO ceslb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","23","ale teprve Kristem ji Bůh otevřel. On sám, jak odpovídá jeho povaze, rozhodl se dát novou příležitost lidem, kteří svými vinami ztratili podíl na Boží slávě: odevzdat život do všech důsledků Kristu. ");
INSERT INTO ceslb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Jaká to milost, že nic jiného není člověku zapotřebí. Kristus – toť svrchovaný důkaz Boží shovívavosti k nám. ");
INSERT INTO ceslb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Jeho krev prolitá na popravišti je pečetí smíření Boha se světem. Až dosud Bůh trest za naše viny pouze s nekonečnou trpělivostí odkládal; nyní je však vložil na Ježíše Krista, který pro ně zemřel. A tak jsou nám definitivně odpuštěny; odpuštěny všem, kdo tuto Boží nabídku smíření přijali. Tak Bůh z hříšných dělá opět bezúhonné, aniž sám cokoliv slevuje ze své spravedlnosti. ");
INSERT INTO ceslb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Čím se tedy můžeme před Bohem chlubit? Ničím! Skutky? Ty nás nespasí. Jedině víra nás může zachránit. ");
INSERT INTO ceslb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Jsem přesvědčen, že nikoliv úzkostlivé dodržování všech přikázání a předpisů, ale pouze víra nás uschopní obstát před Bohem. ");
INSERT INTO ceslb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Což je tu Bůh jen pro členy církve? Není snad Bohem všech lidí? To se rozumí, že je! ");
INSERT INTO ceslb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Bůh je pouze jeden a bez rozdílu přijímá všechny, kdo se obrátí ke Kristu. ");
INSERT INTO ceslb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Neprohlašujeme snad zákon za bezcenný tím, že stavíme víru tak vysoko? Rozhodně ne! Naopak, platnost zákona se tím jen potvrzuje. ");
INSERT INTO ceslb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","O Abrahamovi je napsáno: „Uvěřil Bohu, a byl proto uznán za dokonalého.“ ");
INSERT INTO ceslb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kdyby toho byl dosáhl svými skutky, měl by na co být hrdý. ");
INSERT INTO ceslb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","On si však nedobyl Božího uznání tím, co dělal, ale jen tím, že Bohu důvěřoval. ");
INSERT INTO ceslb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","6","Stejně i David mluví o šťastných lidech, které Bůh považuje za bezúhonné bez jakékoliv vlastní zásluhy: ");
INSERT INTO ceslb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","„Jak dobře je těm, jimž Bůh odpustil jejich provinění, ");
INSERT INTO ceslb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","jak šťasten je každý, komu viny nepočítá a na jeho poklesky nehledí!“ ");
INSERT INTO ceslb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Nuže, platí to snad jen o židech, kteří se podrobili obřadu náboženské obřízky? O Abrahamovi jsem řekl, že byl uznán dokonalým pro svoji víru. ");
INSERT INTO ceslb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kdy se to stalo? Po jeho obřezání na znamení židovství – nebo ještě před ním? Ano, bylo to ještě před tím, než se stal židem. ");
INSERT INTO ceslb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Obřízka jako znamení židovství měla jen zpečetit, že ho Bůh uznal za bezúhonného ještě dříve, než toto znamení přijal. ");
INSERT INTO ceslb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Tak se stal Abraham nejen praotcem židů, nýbrž i duchovním předchůdcem všech, kdo se vydali cestou víry, jako to učinil on před svým obřezáním. ");
INSERT INTO ceslb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abrahamovi a jeho potomkům zaslíbil Bůh slavnou budoucnost nikoliv na základě poslušnosti zákona, ale pro jejich bezúhonnost, kterou přijali vírou. ");
INSERT INTO ceslb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kdyby tu rozhodoval jen zákon, víra by nebyla k ničemu a Boží sliby Abrahamovi by pozbyly smyslu. ");
INSERT INTO ceslb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","17","Zákon je pouze měřítkem provinění – bez zákona by vina neexistovala. Protože Bůh je milostivý, zahrnul do svého slibu nejen zákonité potomky Abrahamovy, ale také všechny ty, které s Abrahamem spojuje stejná víra. Proto nezaložil svůj slib na zákonu, ale na víře. Věříme-li tedy, pak naším společným duchovním otcem je Abraham, jak je o něm napsáno: „Otcem početných národů jsem tě ustanovil.“ ");
INSERT INTO ceslb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","On také uvěřil, ač se to zdálo nemožné, že Bůh mu skutečně dá tak četné potomstvo. ");
INSERT INTO ceslb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nepochyboval o Božím slibu, i když mu bylo bezmála sto let a jeho žena Sára již překročila věk, kdy mohla mít děti. ");
INSERT INTO ceslb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","21","Abraham byl přesvědčen, že Bůh nic neslibuje naplano, a to mu stačilo, aby Boha chválil a děkoval mu. ");
INSERT INTO ceslb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","A právě tuto hlubokou Abrahamovu důvěru ocenil Bůh stejně vysoko jako to nejpříkladnější dodržování požadavků zákona. ");
INSERT INTO ceslb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Toto však nebylo zaznamenáno jen kvůli Abrahamovi, ale i pro nás. ");
INSERT INTO ceslb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","I nás Bůh přijme, když se na něj spolehneme. Vždyť on vzkřísil z mrtvých Ježíše, ");
INSERT INTO ceslb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","který odpykal trest za naše viny a vstal z hrobu, aby nás změnil do té podoby, v níž bychom před Bohem mohli obstát. ");
INSERT INTO ceslb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Poněvadž naše víra v Ježíše Krista má u Boha stejnou hodnotu jako nevinnost, nejsme již Bohu odcizeni. ");
INSERT INTO ceslb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Právě Kristus nám umožnil tímto způsobem dosáhnout důstojného postavení u Boha. ");
INSERT INTO ceslb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Naše výsada není však jen v této naději, nýbrž i v nesnázích. Víme přece, že když snášíme nesnáze, získáváme vytrvalost, ");
INSERT INTO ceslb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","vytrvalostí dosahujeme osvědčenost a ta nás opět vede k naději. ");
INSERT INTO ceslb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A to není klamná naděje, protože Bůh nám dal svého Ducha a ten v nás probouzí lásku. ");
INSERT INTO ceslb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Mějme na paměti, že za nás Kristus umíral v době, kdy jsme si zasloužili Boží odsouzení. ");
INSERT INTO ceslb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","A to je co říci, protože i za nejušlechtilejšího člověka málokdo takovou oběť podstoupí. ");
INSERT INTO ceslb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nám však Bůh dokázal svou lásku právě tím, že Kristus zemřel za nás, třebaže jsme byli špatní. ");
INSERT INTO ceslb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Oč více můžeme počítat s jeho milostí teď, kdy jsme Kristovou obětí již očištěni od svých vin! ");
INSERT INTO ceslb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Jestliže Kristova smrt smířila nás s Bohem ještě v době, kdy nás dělilo nepřátelství, tím spíše nás Kristův život zachrání před Božím hněvem nyní, kdy jsme již smířeni. ");
INSERT INTO ceslb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","I Bohem se tedy můžeme chlubit díky Ježíši Kristu, který nás s ním smířil. ");
INSERT INTO ceslb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Hřích se v tomto světě usadil prostřednictvím jednoho člověka a stejně i důsledek hříchu – smrt. A protože všichni podlehli hříchu, propadli také všichni smrti. ");
INSERT INTO ceslb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Již před vydáním zákona lidé Boha neposlouchali, ale nemohli být odsouzeni podle zákona, protože ještě nebyl vydán. ");
INSERT INTO ceslb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ale výsledkem jejich neposlušnosti byla stejně smrt, i když nešlo o stejné provinění jako Adamovo. Ježíš je jakýmsi Adamovým protějškem; ");
INSERT INTO ceslb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","jeho působnost má pro nás stejně zásadní význam, jenže ve smyslu opačném. ");
INSERT INTO ceslb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Tak jako Adamova neposlušnost přivedla k smrti celé množství lidí, tak dar Boží milosti prostřednictvím Ježíše Krista ruší všechna provinění bez ohledu na jejich množství. ");
INSERT INTO ceslb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","A jako vinou jediného člověka ovládla smrt celý svět, tím spíš budou prostřednictvím Ježíše Krista vládnout ti, kterým on jediný vydobyl milost a bezhříšnost. ");
INSERT INTO ceslb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","19","Shrnuto: Jako pro neposlušnost jednoho byli všichni lidé odsouzeni, tak zase poslušnost jednoho přinesla celému lidstvu odpuštění znamenající život. ");
INSERT INTO ceslb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","21","Zákon ovšem přispěl k tomu, že přestupků jen přibylo. Čím větší však odpadnutí od Boha, tím většího významu nabývá jeho milost. Odpadnutí od Božího zákona přineslo člověku smrt. Bůh však nabídl člověku milost, tedy dokonalost získanou prostřednictvím Ježíše Krista, která mu opět vrací život. ");
INSERT INTO ceslb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Co z toho plyne pro nás? Že máme setrvávat v hříchu, abychom mu dali příležitost udělit nám ještě větší milost? ");
INSERT INTO ceslb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ovšemže ne! Náš dřívější bezbožný život přece již zanikl, jak by mohl ještě pokračovat? ");
INSERT INTO ceslb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Kdo se bytostně spojil s Kristem, má účast jak na jeho životě, tak hlavně na jeho smrti, ");
INSERT INTO ceslb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","5","jak vyznáváme ponořením do vody při křtu; vždyť je to výraz definitivního rozchodu s dřívějším životem. Současně však jako za Kristovou smrtí následovalo vzkříšení – je to počátek úplně nového života, nové existence. ");
INSERT INTO ceslb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","7","Víme přece, že naše dřívější „já“ bylo ukřižováno s Kristem. Aby se vymanilo z nadvlády zla, muselo zemřít, protože jen mrtvý je mimo jeho dosah. ");
INSERT INTO ceslb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","9","Když jsme tedy své „já“ nechali s Kristem zemřít, musí teď být na nás vidět, že žijeme docela jiný život. ");
INSERT INTO ceslb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Kristus zemřel proto, aby jednou provždy zničil zlo, jímž člověk dává smrti právo nad sebou. Když potom vstal z mrtvých, je už smrt proti němu bezmocná, na jeho život má nárok pouze Bůh. ");
INSERT INTO ceslb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","I vy tedy – jestliže jste zemřeli hříchu a jste spojeni s Ježíšem Kristem – se zlem teď nemáte nic společného a váš život patří jedině Bohu. ");
INSERT INTO ceslb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Zlo už nesmí nabýt vrchu ve vašem jednání. ");
INSERT INTO ceslb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Nestůjte znovu v jeho službách, ale dejte se plně k dispozici Bohu, aby vás mohl užívat jako své nástroje v šíření dobra. ");
INSERT INTO ceslb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ne už zákon, nýbrž Boží slitování nás zavazuje k dokonalému životu! ");
INSERT INTO ceslb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","To ovšem neznamená, že bychom si nyní mohli dovolit cokoliv. ");
INSERT INTO ceslb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Komu se totiž dáváme do služeb, tomu jsme zavázáni poslušností. Povolíme-li zlu, stane se naším pánem a to vede ke smrti; anebo budeme poslouchat Boha – a pak budeme žít bezhříšně. ");
INSERT INTO ceslb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","18","Bohu díky za to, že vy jste byli vysvobozeni z nevolnictví zla, když jste se přiklonili ke Kristovu učení a rozhodli se žít bezúhonně. ");
INSERT INTO ceslb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Přiblížím vám to ještě jinak: kdysi jste své tělo propůjčovali pochybným požitkům a nevázaným zábavám, takže jste žili nezřízeně. Teď se tedy celou svou osobností oddávejte novému bezúhonnému životu, který by nehyzdila žádná skvrna. ");
INSERT INTO ceslb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Dokud jste se řídili svými choutkami, byly vám nějaké mravní požadavky docela lhostejné. ");
INSERT INTO ceslb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Teď se za to stydíte, a co jste z toho měli tenkrát? Stejně to vše končí smrtí. ");
INSERT INTO ceslb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Teď jste však vůči zlu svobodni a dali jste se do Božích služeb. A co z toho máte? Život bez poskvrny už v přítomnosti a život věčný před sebou. ");
INSERT INTO ceslb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Hřích dává svou odplatu – smrt; Bůh dává jako projev své milosti věčný život. Získáváme ho prostřednictvím našeho Pána, Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Milí, bratři, vy se přece dobře vyznáte v zákoně, a tak víte, že se vztahuje pouze na živého člověka. ");
INSERT INTO ceslb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Podle zákona je například žena vázána věrností svému muži jen potud, dokud její muž žije. ");
INSERT INTO ceslb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Jestliže však manžel zemřel, závazek tím pro ženu skončil; když se tedy provdá za jiného, nikdo ji nemůže obžalovat z mnohomužství. ");
INSERT INTO ceslb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Tak i vaše podřízenost zákonu Kristovou smrtí skončila a vy teď náležíte jinému Pánu, totiž vzkříšenému Kristu, aby z vás měl užitek Bůh. ");
INSERT INTO ceslb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Dokud jsme si žili po svém, ovládal nás hlad po zakázaném ovoci, touha po tom, co zákon zakazuje; tím jsme si vysloužili smrt. ");
INSERT INTO ceslb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Když jsme však s Kristem obrazně zemřeli, unikli jsme moci zákona. Nad naším nynějším životem už není nejvyšší autoritou mrtvá litera zákona, nýbrž Duch živého Krista. ");
INSERT INTO ceslb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tím však nechceme říci, že zákon není dobrý. Vždyť právě zákon nám říká, co je hřích. Kdyby zákon nezakazoval touhu po cizím vlastnictví, ani bych nevěděl, že je to něco špatného. ");
INSERT INTO ceslb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Na druhé straně však zákon také ukazuje, že existuje i zakázané ovoce, když říká: Nepožádáš. Tím podněcuje k silnější touze po zakázaném ovoci. A tak vidíme, že kdyby tu nebyl zákon, nebyl by tu ani hřích. ");
INSERT INTO ceslb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Příchodem zákona do mého života hřích začal existovat ");
INSERT INTO ceslb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","11","a s hříchem přišla smrt. A tak se ukázalo, že Boží příkaz, který měl můj život chránit, způsobil vlastně jeho zkázu. Jakmile jsem chtěl jednat nezávisle na Bohu, byl ortel smrti zpečetěn. ");
INSERT INTO ceslb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","13","Nuže, byla to tedy ta dobrá a správná Boží přikázání, která zapříčinila moji smrt? Nikoliv ona, nýbrž neposlušnost, pýcha mého „já“ přivolala na mou hlavu prostřednictvím dobrých přikázání rozsudek smrti a tím se odhalila jako skutečný nepřítel života. ");
INSERT INTO ceslb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Zákon, jak víme, pochází od Boha. My jsme však slabí lidé, jako otroci prodaní hříchu. ");
INSERT INTO ceslb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","I když víme, co je dobré a správné, a chceme se tím řídit, vyzní naše snaha často v pravý opak. ");
INSERT INTO ceslb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Třebaže dobrou vůli máme, neumíme ji proměnit v čin. ");
INSERT INTO ceslb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Jako by v nás jednal kdosi jiný proti našemu lepšímu přesvědčení, takže Boží vůli neustále přestupujeme, ačkoliv ji rozumem schvalujeme. Čemu to nasvědčuje? ");
INSERT INTO ceslb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","23","Ukazuje to, že uvnitř jsme ovládáni zákonem zla, který i naše nejlepší úmysly dovede převrátit ve špatné jednání. Na jedné straně tedy rozumem chceme sloužit Bohu a dobru, na druhé straně neustále podléháme zlu. ");
INSERT INTO ceslb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Jak ubozí jsme my lidé! Což neexistuje vysvobození z tohoto nešťastného otroctví? ");
INSERT INTO ceslb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Díky Bohu existuje. Je tu cesta, kterou nám otevřel Ježíš Kristus. ");
INSERT INTO ceslb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","My, kdo jsme spojeni s Kristem, nemusíme se již obávat žádného odsouzení k smrti. ");
INSERT INTO ceslb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Vždyť způsob života, jak jej při nás uskutečňuje oživující Duch skrze naše spojení s Kristem, nás vymanil ze zákonitosti hříchu a ze smrti. Zákon nás sice mohl před zlem varovat, ale nemohl nás před ním uchránit. ");
INSERT INTO ceslb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Proto Bůh poslal svého Syna Ježíše Krista, aby se stal člověkem a byl pokoušen k neposlušnosti. Takto odsoudil hřích tam, kde nejvíce působí, tedy v lidské přirozenosti. ");
INSERT INTO ceslb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Tak můžeme i my Ježíšovou zásluhou splnit požadavky zákona, když nepodléháme tomu, co chce tělo, ale jsme vedeni Duchem. ");
INSERT INTO ceslb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Jestliže někdo žije podle své přirozenosti, je ovládán sobeckými touhami. Žije-li však v někom Boží Duch, je jím také usměrňován. ");
INSERT INTO ceslb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","8","Vlastní touhy vedou ke smrti. Duch Boží však dává život a pokoj. Ti první nemají Boha příliš v lásce, protože je jim nepříjemný a jeho zákony nepřijatelné. Takoví se Bohu ovšem nemohou líbit. ");
INSERT INTO ceslb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ale vy, jestliže Boží Duch ve vás působí, jste jím vedeni k docela jinému životu. ");
INSERT INTO ceslb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Patříte-li opravdu Kristu, nemůže to být jinak. Z vlivu zla se vaše tělo vyprostilo Kristovou zásluhou; jeho bezúhonnost vám teď zprostředkovává život, vyvěrající z jeho Ducha. ");
INSERT INTO ceslb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","A tento Duch, jenž vzkřísil z mrtvých Ježíše Krista, vzkřísí i vaše smrtelné tělo, pokud jej v sobě necháte sílit a vládnout. ");
INSERT INTO ceslb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ano, bratři, teď už nejsme podřízeni tomu, k čemu nás dříve naše přirozenost samozřejmě vedla. ");
INSERT INTO ceslb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kdo totiž sám sobě ve všem vyhoví, ten sám sebe zničí. Kdo však s Boží pomocí vítězí nad svými slabostmi, ten získá nepomíjející život. ");
INSERT INTO ceslb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kdo se dá vést Božím Duchem, smí se právem pokládat za Božího syna a dceru. ");
INSERT INTO ceslb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","17","Bůh nám daroval postavení vlastních dětí, které se k němu smějí obracet jako k milujícímu Otci a jimž patří všechno, co patří jemu. Duch svatý nás o tom ujišťuje. ");
INSERT INTO ceslb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Stejnou slávu, jakou obdařil Krista, jednou přizná i nám, budeme-li ochotni podstoupit i stejné utrpení. Jsem plně přesvědčen, že všechno pozemské trápení neznamená nic proti slávě, která nás nakonec čeká. ");
INSERT INTO ceslb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Vždyť celá příroda dychtivě očekává, kdy se objeví Boží synové v plné slávě. ");
INSERT INTO ceslb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","21","Hříchem se porušilo všechno stvořené; přesto však zde zůstává naděje na vysvobození všeho tvorstva. Svým věrným dá Bůh svobodu a slávu a ostatnímu stvoření vrátí neporušenost. ");
INSERT INTO ceslb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Jen se podívejte, jak nyní celá příroda úpí a sténá jako v porodních bolestech! ");
INSERT INTO ceslb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","A dokonce i my křesťané, kterým Bůh jako příslib nového života dal svého Ducha, toužebně vyhlížíme viditelný důkaz, ");
INSERT INTO ceslb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","že jsme byli přijati mezi Boží děti, které zachrání k věčnému životu; touto nadějí jsme naplněni. Těšíme se na to, co brzy uvidíme. ");
INSERT INTO ceslb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Čekáme trpělivě, neboť mít naději znamená čekat, i když ještě není nic vidět. ");
INSERT INTO ceslb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","My sami jsme slabí a často ani nenacházíme slova k modlitbě. Ale Duch Boží nám přichází na pomoc a úpěnlivě volá za nás slovy, která se vymykají našemu jazyku. ");
INSERT INTO ceslb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","A Bůh, který vidí do nejhlubších záhybů lidského srdce, přímluvná volání Ducha přijímá a dobře mu rozumí. ");
INSERT INTO ceslb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","29","Víme, že vše nakonec slouží k prospěchu těch, kteří Boha milují. Ti jsou podle jeho vůle povoláni, aby získali podobu Božího Syna. Mají se stát jeho rodinou a Ježíš bude nejpřednější. Proč jsou k tomu povoláni? ");
INSERT INTO ceslb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Protože je Bůh před věky důvěrně poznal a k tomu vyvolil. Tento cíl dosáhnou, protože je ospravedlní a oslaví. ");
INSERT INTO ceslb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Co z toho plyne? Je-li Bůh s námi, kdo nás může ohrozit? ");
INSERT INTO ceslb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Když neváhal vzdát se kvůli nám svého vlastního Syna, co by pro nás ještě neudělal? ");
INSERT INTO ceslb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kdo se odváží být naším žalobcem před Božím soudem, když soudcem je ten, kdo nás sám ospravedlnil? ");
INSERT INTO ceslb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kdo nás odsoudí, když naším obhájcem je sám Ježíš Kristus? ");
INSERT INTO ceslb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kdo nás odloučí od jeho lásky? Snad těžkosti nebo strach, pronásledování či hlad, nebezpečí života nebo sama smrt? To vše se nám může přihodit. ");
INSERT INTO ceslb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Vždyť už dávný žalmista napsal: „Každou chvíli vedou někoho z nás na smrt kvůli tobě, mají nás za ovce, určené na porážku.“ ");
INSERT INTO ceslb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ale s jeho pomocí máme vítězství zajištěno. Vždyť si nás zamiloval! ");
INSERT INTO ceslb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","A já jsem přesvědčen, že ani smrt, ani život, ani andělé, ani vládci, nic z toho, co se děje nebo teprve má přijít, ani moci světské ani duchovní a vůbec nic z toho, co vyšlo z rukou Stvořitele, nemůže nás odloučit od Boží lásky. Vždyť jsme ji poznali v Ježíši Kristu, když za nás umíral. ");
INSERT INTO ceslb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","2","Ach, Izraeli! Ach, můj národe! Kéž bys i ty našel cestu ke Kristu! Trápím se a naříkám pro tebe dnem i nocí. ");
INSERT INTO ceslb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Život bych za tebe dal, kdyby tě to mohlo zachránit. Kristus ví, že nepřeháním, Božímu Duchu nelze nic předstírat. Tolik jsi toho od Boha dostal, a přesto nechceš poslouchat! ");
INSERT INTO ceslb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Za vlastní děti vás přijal, slavně vás vedl dějinami k ještě slavnější budoucnosti, dal vám své zákony, abyste v životě nemuseli tápat, naučil vás, jak ho máte uctívat, dal vám úžasné sliby, ");
INSERT INTO ceslb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","slavné vůdce jste měli mezi praotci a nejslavnější – Kristus, věčný Bůh a Vládce – se jako člověk také narodil z vaší krve. A toho jste se zřekli! ");
INSERT INTO ceslb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","9","Boží slovo však platit nepřestalo: Izraelci nejsou všichni, kdo odvozují svůj rodokmen od Abrahama nebo Jákoba – Izraele. I když jsou to potomci Abrahamovi, měl Bůh na mysli pouze Izáka, když Sáře sliboval syna. To znamená, že ne všichni z Abrahama jsou Božími dětmi, ale jenom ti, kteří se narodili na základě Božího slibu. ");
INSERT INTO ceslb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Také o synech, které měl Izák se svou ženou Rebekou, ");
INSERT INTO ceslb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","rozhodl Bůh ještě před jejich narozením. Oznámil, že starší z nich bude sloužit mladšímu. Když tak Bůh určil jejich vzájemné postavení ještě před tím, než se o to mohli osobně nějak zasloužit, zdůraznil tím, že má právo rozhodovat o lidech naprosto svobodně, ");
INSERT INTO ceslb_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","13","bez ohledu na jejich záslužné skutky. Proto mohl také říci, jak stojí jinde v Bibli: „Dal jsem přednost Jákobovi před Ezauem.“ ");
INSERT INTO ceslb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Můžeme z toho usuzovat, že je Bůh nespravedlivý? Naprosto ne! ");
INSERT INTO ceslb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Mojžíšovi přece řekl: „Projevím svou přízeň komu chci a slituji se nad kým chci.“ ");
INSERT INTO ceslb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","18","Nikomu tím není povinen, nikdo na to nemá nárok. Je to jen jeho milost, když to učiní. Faraónovi, jak sám říká, propůjčil jeho postavení proto, aby na něm ukázal svou moc a aby rozšířil svůj věhlas po celé zemi. Tak tedy žádným sebevětším úsilím, nýbrž z pouhé Boží milosti jsou lidé to, co jsou. ");
INSERT INTO ceslb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Možná někdo namítne: Proč nám tedy Bůh ještě pořád něco vytýká, když se nic nemůže dít proti jeho vůli? ");
INSERT INTO ceslb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ale člověče, kdo ty vlastně jsi, že si troufáš přít se s Bohem? Říká snad výrobek svému tvůrci: Proč jsi mne udělal zrovna takhle? ");
INSERT INTO ceslb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Copak se hrnčíř ptá hlíny, zda z ní má udělat vázu nebo mísu? ");
INSERT INTO ceslb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nemohl i Bůh ukázat nejen svou pravomoc trestat, ale i svou shovívavost s lidmi zralými k potrestání? ");
INSERT INTO ceslb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Nemá právo projevit svou dobrotu k lidem, které zahrnul milosrdenstvím a určil pro věčnou slávu? ");
INSERT INTO ceslb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Podobně povolal i nás, a to nejen židy nebo členy církve, ale i jiné, ");
INSERT INTO ceslb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","jak naznačuje prorok Ozeáš: „Nazvu svým lidem ty, k nimž jsem se nechtěl znát, vyhnané zase zavolám nazpět. ");
INSERT INTO ceslb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Kdo předtím slyšeli mé slovo odsouzení, budou ujištěni, že je přijímám za své syny.“ ");
INSERT INTO ceslb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","O Izraeli říká Izajáš: „Kdyby jich bylo jak mořského písku, jen hrstka se jich zachrání. ");
INSERT INTO ceslb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Bez odkladu a do písmene splní Bůh své slovo na zemi.“ ");
INSERT INTO ceslb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","A už dříve předvídá: „Kdyby nebyl nebeský vládce ten zbytek lidu nezachoval, byli bychom jak Sodoma zpustli a Gomoře se podobali.“ ");
INSERT INTO ceslb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Co tu vidíme? Že ti, kdo k izraelskému náboženství nepatřili a o bezúhonnost před Bohem nijak neusilovali, ti ji dosáhli na základě víry. ");
INSERT INTO ceslb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","A ti, kdo spoléhali na svou příslušnost k vyvoleným a na plnění náboženských předpisů, vyšli naprázdno. ");
INSERT INTO ceslb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Proč to? Protože se domnívali, že si Boha nakloní okázalou zbožností místo upřímnou vírou. Na tom ztroskotali, ");
INSERT INTO ceslb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","zcela podle slov Izajášových: „Hle, na Sijón kladu kámen úrazu, o něj se mnohý z vás rozbije. Kdo se mne však vírou uchopí, ten žádnou škodu neutrpí.“ ");
INSERT INTO ceslb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Bratři, denně prosím Boha za Izraelce, aby si uvědomili svůj omyl. ");
INSERT INTO ceslb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Musí se jim přiznat, že o Boží přízeň horlivě usilují, ale mají klapky na očích. ");
INSERT INTO ceslb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nepochopili ospravedlnění v tom způsobu, jak je nabízí Bůh, a proto je odmítají a chtějí si je vydobýt sami. ");
INSERT INTO ceslb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Zákon je měl přece přivést ke Kristu, který je vrcholem a dává bezúhonnost tomu, kdo věří. ");
INSERT INTO ceslb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mojžíš řekl, že člověk získá život plněním zákona; říkejme tomu ospravedlnění cestou zákona. ");
INSERT INTO ceslb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ospravedlnění cestou víry je však něco jiného. Klíč k životu není třeba hledat v nadpozemských výšinách, ");
INSERT INTO ceslb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ani pracně dobývat z hlubin země. Vše potřebné již za nás udělal Kristus. ");
INSERT INTO ceslb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Každý člověk má ten klíč na dosah, má ho ve svém srdci: je to víra, kterou hlásáme. ");
INSERT INTO ceslb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Jestliže tedy Krista vyznáváš jako Pána a opravdu věříš, že jej Bůh vzkřísil z mrtvých, jsi zachráněn. ");
INSERT INTO ceslb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kdo věří, ten je před Bohem spravedlivý a jako takový, hlásí-li se k tomu veřejně, je u něho v milosti. ");
INSERT INTO ceslb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Bible přece říká: Kdo mu uvěří, nebude zklamán. ");
INSERT INTO ceslb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","A v tom není rozdíl mezi židem a jinověrcem. Všichni mají jednoho a téhož Pána a ten je stejně štědrý ke všem, kdo se k němu obracejí. ");
INSERT INTO ceslb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Je přece psáno, že každý, kdo ho bude vzývat, bude zachráněn. Každý! ");
INSERT INTO ceslb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Vzývat ho může ovšem jen ten, kdo v něj uvěřil: uvěřil jen ten, kdo o něm slyšel; slyší jen tehdy, když bude někdo mluvit; ");
INSERT INTO ceslb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","a mluvit o něm – k tomu právě Bůh posílá nás. Vždyť víte, co je psáno v Písmu: „Vždy vítán je, kdo dobrou zprávu nese!“ ");
INSERT INTO ceslb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Skutečnost je ovšem taková, že ne všichni tu zprávu uvítali. Vždyť už Izajáš si stěžuje: „Pane, kdo uvěřil tomu, co jsme hlásali?“ ");
INSERT INTO ceslb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Věříme-li my, je to proto, že jsme Kristovo poselství přijali. ");
INSERT INTO ceslb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Pokládám však otázku: Což snad Izraelci neslyšeli stejné poselství? Jistě slyšeli. ");
INSERT INTO ceslb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nepochopili je snad? ptám se dál. Už Mojžíš říkal: „Budete jednou žárlit na ty, kterými pohrdáte, a hněvat se na ně, národe nechápavý!“ ");
INSERT INTO ceslb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","A Izajášovými ústy říká Bůh: „Dal jsem se nalézt těm, kdo mne nehledali, a poznat jsem se dal těm, kdo se o mne nestarali.“ ");
INSERT INTO ceslb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","O Izraelcích však mluví jako o lidu neposlušném a vzpurném. ");
INSERT INTO ceslb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ptám se tedy: Zavrhl snad Bůh svůj národ? Rozhodně ne! Vždyť já jsem také židovské národnosti, potomek Abrahamův z větve Benjamínovy. ");
INSERT INTO ceslb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Bůh nezavrhl svůj lid, který si předtím vybral. V Bibli se dočteme, že už Elijáš si Bohu na svůj národ stěžoval: ");
INSERT INTO ceslb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","„Pane, tvé proroky povraždili, tvé oltáře rozbořili. Už jen já jsem zůstal při tobě a také mně o život ukládají.“ ");
INSERT INTO ceslb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","A co mu na to odpovídá Bůh? „Sedm tisíc věrných – kromě tebe – se bohům cizím ještě neklaní!“ ");
INSERT INTO ceslb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Stejně tak dnes je tu takový zbytek věrných. Bůh je ovšem nevyvolil pro jejich zásluhy, nýbrž ze své milosti. ");
INSERT INTO ceslb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","7","Tak tedy: o co se tolik snažili Izraelci, toho – kromě těch vyvolených – nedosáhli. ");
INSERT INTO ceslb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Bůh je ranil slepotou, takže mají oči – a přesto nevidí, mají uši – a přesto neslyší, slepí a hluší jsou až dodnes. ");
INSERT INTO ceslb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","A David říká v jednom svém žalmu: „Jejich blahobyt ať je jim osidlem a kamenem úrazu. ");
INSERT INTO ceslb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Zatmi jim zrak, ať nevidí a pod břemenem stále se hrbí.“ ");
INSERT INTO ceslb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ptám se tedy: Je snad smyslem jejich klopýtnutí, aby padli nadobro? V žádném případě! ");
INSERT INTO ceslb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Jejich pád však umožnil záchranu pohanů, a to má probudit u židů zdravou žárlivost. Oč větším požehnáním pro svět bude návrat Izraele k Bohu, když jeho úpadek znamenal už takové dobrodiní! ");
INSERT INTO ceslb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Proto vám, bývalým pohanům, sloužím tak horlivě, ");
INSERT INTO ceslb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","abych vyvolal žárlivost u svých soukmenovců a alespoň některé tak zachránil. ");
INSERT INTO ceslb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","To, že se ocitli v nepřátelském táboře, přineslo světu smíření s Bohem. A což teprve, až je Bůh znovu přijme! To bude přímo vzkříšení z mrtvých! ");
INSERT INTO ceslb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Co vyrostlo ze svatých kořenů, je rovněž svaté. ");
INSERT INTO ceslb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Jestli byly některé větve ze svatého stromu ulomeny a vy, jako plané větve, naroubováni na jejich místo, ");
INSERT INTO ceslb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","nevypínejte se nad větve původní. Nezapomeňte, že kořen nese vás a ne naopak! ");
INSERT INTO ceslb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Říkáš: „Byly přece ulámány, abych já mohl zaujmout jejich místo.“ ");
INSERT INTO ceslb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Máš pravdu, byly ulámány kvůli své nevěře a ty rosteš na jejich místě díky své víře. To však měj za důvod spíš k pokoře než k domýšlivosti. ");
INSERT INTO ceslb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Když Bůh neušetřil větve původní, tím spíš by neušetřil tebe. ");
INSERT INTO ceslb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Máš v tom vidět důkaz jeho přísnosti, ale zároveň i dobroty: přísnosti k odpadlým a dobroty k tobě – pokud ovšem zůstaneš věrný. Jinak odřízne i tebe. ");
INSERT INTO ceslb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","24","A stejně i židé, vrátí-li se k Bohu, budou naroubováni zase zpět. Bude to tím snadnější, že Bůh je vlastně jen vrátí na jejich původní místo. Nemělo by vám zůstat tajemstvím, bratři, jaké úmysly má Bůh s Izraelem, ");
INSERT INTO ceslb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","a nechci vás ponechat jen vašim představám. Část židů zůstane od Boha odvrácena tak dlouho, dokud počet povolaných z ostatních národů nebude dovršen. Když se to stane, ");
INSERT INTO ceslb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","otevře se cesta všemu Izraeli a nalezne spasení, jak píše Izajáš: „Z Jeruzaléma přijde vysvoboditel a všechnu bezbožnost z národa vymýtí. ");
INSERT INTO ceslb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Já, Bůh, s nimi učiním smlouvu, že všechny jejich viny zahladím.“ ");
INSERT INTO ceslb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Jak se tedy máte na židy dívat? Nepřijali Pána Ježíše Krista, a proto je můžete pokládat za Boží odpůrce; přitom však nezapomínejte, že vás jejich vzdor přivedl k Božímu milosrdenství. Bůh je však stále miluje, protože jsou dětmi svých předků, které on vyvolil. ");
INSERT INTO ceslb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Když Bůh něco daruje, nebere to zpět; když někoho povolá, sám to neruší. ");
INSERT INTO ceslb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Vy jste kdysi Boha odmítali, ale teď se vám dostalo Božího milosrdenství, když ho židé odmítli. ");
INSERT INTO ceslb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","V podobné situaci jsou teď oni. Staví se odmítavě k milosti, která byla udělena vám právě proto, aby ji nakonec mohli dostat i oni. ");
INSERT INTO ceslb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Tak se všichni nerozdílně stali svou neposlušností stejně závislými na Boží milosti, jak Bůh chtěl. ");
INSERT INTO ceslb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Jak nesmírné je Boží bohatství, jak hluboká jeho moudrost a poznání. Jak nevyzpytatelná jeho rozhodnutí a nepředvídatelné jeho jednání! ");
INSERT INTO ceslb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kdo může pochopit Boží myšlení, kdo byl kdy jeho poradcem? ");
INSERT INTO ceslb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Kdo mu kdy dal něco ze svého, aby mu to on musel vrátit? ");
INSERT INTO ceslb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Vždyť z Boha vše pochází, díky jemu a pro něho vše trvá. Jemu sláva na věky! ");
INSERT INTO ceslb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Když nám Bůh tak mnoha způsoby projevuje své milosrdenství, dejte mu i vy sami sebe plně k službám. Taková oběť je mu nejmilejší, tím ho nejlépe můžeme uctít. ");
INSERT INTO ceslb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Přestaňte napodobovat zvyky a způsoby ostatního světa a změňte celé svoje smýšlení, abyste byli schopni rozeznat, co je v souladu s Boží vůlí, co je tedy správné, dokonalé a jemu milé. ");
INSERT INTO ceslb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Jako Boží vyslanec vám kladu na srdce: nikdo ať si o sobě nemyslí víc, než odpovídá jeho víře. ");
INSERT INTO ceslb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Tělo se skládá z mnoha orgánů a každý v něm má jinou funkci. ");
INSERT INTO ceslb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Také my všichni tvoříme s Kristem jedno tělo, ale jako jeho jednotlivé orgány máme různé úkoly podle schopností, jimiž nás Bůh obdaroval. ");
INSERT INTO ceslb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Komu Bůh svěřil poselství, ať ho zvěstuje v souladu s vírou. ");
INSERT INTO ceslb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Kdo je nadán k službě, ať slouží. ");
INSERT INTO ceslb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Kdo má schopnost vyučovat, ať se věnuje vyučování. Kdo umí povzbuzovat, ať povzbuzuje. Kdo rozdává, ať přitom neskrblí. Kdo stojí v čele, ať je horlivý. Kdo slouží trpícím, ať to dělá s radostí. ");
INSERT INTO ceslb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","V lásce nemá místo přetvářka. Ke zlu mějte odpor, dobro milujte. ");
INSERT INTO ceslb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Mějte se rádi jako bratři, překonávejte se ve vzájemné úctě. ");
INSERT INTO ceslb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","V horlivosti nepodléhejte únavě, ale služte Pánu v duchovním zápalu. ");
INSERT INTO ceslb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Z naděje se radujte, v soužení buďte trpěliví, v modlitbách vytrvalí. ");
INSERT INTO ceslb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Podporujte spolubratry v nouzi, buďte pohostinní. ");
INSERT INTO ceslb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Svým nepřátelům přejte jen dobré a neživte v sobě nenávist. ");
INSERT INTO ceslb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Radujte se s radujícími, plačte s plačícími. ");
INSERT INTO ceslb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Žijte spolu v souladu. Nechtějte dosáhnout závratných úspěchů, spíš buďte svědomití v drobných úkolech. Nepokládejte sami sebe za nejmoudřejší a nejchytřejší. ");
INSERT INTO ceslb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Zlo nikdy neoplácejte zlem, ale usilujte o dobro pro všechny. ");
INSERT INTO ceslb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Pokud bude záležet na vás, udržujte dobré vztahy se všemi lidmi. ");
INSERT INTO ceslb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nezjednávejte si spravedlnost sami, moji drazí, přenechte odplatu Bohu, neboť v Bibli čteme: „Mně patří odveta, já odplatím, praví Pán.“ ");
INSERT INTO ceslb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Pro vás však platí: když má nepřítel hlad, dejte mu najíst, když má žízeň, dejte mu napít. Tím dosáhnete toho, že se za své jednání zastydí. ");
INSERT INTO ceslb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Nenechte se strhnout ke zlému, ale přemáhejte zlo dobrem. ");
INSERT INTO ceslb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Každý se má podřídit pozemské vládě, neboť vládní moc má svůj původ od Boha. ");
INSERT INTO ceslb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Kdo se staví proti ní, staví se proti řádu, který Bůh ustanovil, a přivolává na sebe trest. ");
INSERT INTO ceslb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Vláda tu není od toho, aby naháněla strach za dobré jednání, nýbrž za špatné. Jednej v souladu se zákony a nemusíš se jí bát. ");
INSERT INTO ceslb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Jejím úkolem od Boha je sloužit občanům k dobru. Kdo ovšem páchá zlo, má se proč bát; ne nadarmo má vláda také meč. I to je jejím posláním od Boha, aby trestala zlo. ");
INSERT INTO ceslb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Proto je nutno vládu respektovat nejen ze strachu před trestem; to je i věc svědomí. ");
INSERT INTO ceslb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ze stejného důvodu například platíme daně. Stát je vybírá v zájmu veřejného blaha a také výběrčí svým způsobem slouží všem, když plní tento svěřený úkol. ");
INSERT INTO ceslb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Dávejte tedy každému, co mu náleží: Komu daň – tomu daň, komu clo – tomu clo, komu úcta – tomu úcta, komu čest – tomu čest. ");
INSERT INTO ceslb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nedělejte si dluhy. Jediný dluh nikdy nesplatíte: vzájemnou lásku mezi vámi. Kdo druhé lidi miluje, ten plní zákon. ");
INSERT INTO ceslb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Vždyť všechna ta přikázání jako „nebudeš cizoložit, zabíjet, krást, toužit po cizím vlastnictví“ a kterákoliv jiná jsou zahrnuta v tomto jediném: Miluj svého bližního jako sám sebe. ");
INSERT INTO ceslb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Láska neumí ublížit, proto láska je naplněním zákona. ");
INSERT INTO ceslb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Mějte to vše na paměti tím spíše, že víte, v jak kritické době žijeme. Přišel už čas probrat se z netečnosti. Očekávané vysvobození se blíží. ");
INSERT INTO ceslb_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","13","Noc se chýlí ke konci, den je přede dveřmi. Nechme tedy všeho, co patří do říše tmy, jako jsou pitky a nevázané zábavy, nemravnosti a bezuzdnosti, sváry a závist a připravujme se vstříc světlu. ");
INSERT INTO ceslb_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Všechno vaše jednání ať určuje Ježíš Kristus. Nevěnujte příliš pozornosti tělu, abyste se nestali otroky jeho potřeb. ");
INSERT INTO ceslb_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Lidi, kteří mají příliš úzkostlivou víru, přijímejte mezi sebe, ale ne proto, abyste kritizovali a vyvraceli jejich názory. ");
INSERT INTO ceslb_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Jeden je přesvědčený, že je nutno dodržovat celou řadu náboženských zákazů a příkazů, například nejí jídla, která pokládá za nečistá. ");
INSERT INTO ceslb_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Jiný naopak věří, že na tom tolik nezáleží, že může jíst všechno. Kdo jí všechno, ať se nedívá spatra na toho, kdo třeba nejí vůbec maso. A kdo nepožívá maso, ať nekritizuje toho, kdo ho jí bez zábran: vždyť také on byl přijat Bohem. ");
INSERT INTO ceslb_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Jakým právem chceš odsuzovat toho, jehož pánem nejsi ty, ale Bůh? Je jen Boží záležitostí, zda člověk stojí nebo padá – a i v pádu ho Bůh dokáže zadržet. ");
INSERT INTO ceslb_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","6","Někdo zase činí rozdíl mezi dny v týdnu, zatímco pro jiného je den jako den. Důležité je, aby v těchto věcech každý jednal podle svého přesvědčení a s touhou oslavit Boha. ");
INSERT INTO ceslb_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","8","Vždyť nikdo z nás nežije ani neumírá jen pro sebe. ");
INSERT INTO ceslb_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Proto Kristus zemřel a zase vstal, aby si podmanil vše živé i mrtvé. Tak tedy v životě i ve smrti náležíme jemu. ");
INSERT INTO ceslb_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Proč tedy odsuzovat bratra a pohrdat jím? Všichni se přece budeme muset postavit před Boží soud. ");
INSERT INTO ceslb_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Vždyť je psáno: „Každé koleno přede mnou poklekne, každý jazyk mě bude velebit.“ ");
INSERT INTO ceslb_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Každý sám za sebe bude skládat účty Bohu. ");
INSERT INTO ceslb_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nechte už tedy vzájemného kritizování; raději se mějte na pozoru, aby váš bratr neklopýtl a nepadl vaší vinou. ");
INSERT INTO ceslb_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","16","Vím a jsem o tom plně přesvědčen – tak mi to dal poznat Ježíš, že nic není nečisté samo o sobě. Nečistými se stávají věci jen tomu, kdo je za nečisté považuje. Ale rozhodujícím hlediskem ať je vždy láska. I když nám svědomí v tom či onom nebrání, důležitější je nepohoršit bratra. Co samo o sobě ještě není špatné, může vyvolat špatnou odezvu. ");
INSERT INTO ceslb_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","V Božím království nejde přece o jídlo a pití, ale o spravedlnost, pokoj a radost, jak je dává Duch svatý. ");
INSERT INTO ceslb_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Kdo v tomto duchu slouží Kristu, líbí se Bohu a váží si ho i lidé. ");
INSERT INTO ceslb_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Usilujme tedy především o to, co slouží všem k pokoji a ke vzájemnému duchovnímu prospěchu. ");
INSERT INTO ceslb_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Nepoškozujme Boží dílo kvůli podružnostem a vyhýbejme se všemu, co by mohlo oslabit víru bratra. ");
INSERT INTO ceslb_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Je lepší odepřít si, co vadí mému bratru, než někoho zranit. ");
INSERT INTO ceslb_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","23","Své přesvědčení však nezrazujme; Bůh o něm ví. Budeme šťastni a bez výčitek, když uposlechneme hlas svého svědomí. Neřídit se jím a zapřít své přesvědčení je hřích. ");
INSERT INTO ceslb_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","My vyspělejší ve víře jsme povinni snášet nedostatky těch, kdo tak pokročilí nejsou, a nesmíme být na svou úroveň domýšliví. ");
INSERT INTO ceslb_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Pamatujte především na bližní a na to, co prospívá jim. ");
INSERT INTO ceslb_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Vždyť ani Kristus nehledal svůj prospěch, ale podle prorockých slov ze žalmu snášel výsměch nepřátel: „Urážky těch, kdo tebe, Bože, tupili, snesly se na moji hlavu.“ ");
INSERT INTO ceslb_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","I toto, jako vše v Písmu, bylo napsáno k našemu naučení, abychom získali vytrvalost a čerpali z toho povzbuzení a naději. ");
INSERT INTO ceslb_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ať vám tedy Bůh, dárce toho všeho, dá žít navzájem v souladu. ");
INSERT INTO ceslb_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Tak si to přál Ježíš Kristus, abyste jednomyslně oslavovali Boha, jeho Otce. ");
INSERT INTO ceslb_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Nechtějte být nějakou uzavřenou společností. Nestraňte se jeden druhého; přijímejte se navzájem, jako nás Kristus přijal do slávy. ");
INSERT INTO ceslb_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Kristus byl poslán k židům, aby tak Bůh prokázal svou věrnost a splnil sliby, jež dal praotcům. ");
INSERT INTO ceslb_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Současně přinesl milost i všem ostatním lidem, aby také oni oslavovali Boha. Bible to potvrzuje na mnoha místech. Cituji alespoň některá: „Velebit tě budu mezi pohany a před nevěrci budu chválit tvé jméno.“ ");
INSERT INTO ceslb_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","„Pohani, i vy se radujte společně s jeho lidem!“ ");
INSERT INTO ceslb_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","„Chvalte Boha ve všech národech, celý svět mu vzdej chválu!“ ");
INSERT INTO ceslb_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","„Z kořene Jišajova vyroste výhonek, početných národů stane se vládcem. On bude nadějí pohanů, nadějí vzdálených Bohu.“ ");
INSERT INTO ceslb_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ať vás Bůh, dárce naděje, naplní pokojem, radostí a důvěrou, abyste s pomocí Ducha svatého naději neztráceli, ale naopak šířili. ");
INSERT INTO ceslb_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Nepochybuji o tom, moji bratři, že co do vědomostí i schopností jste sami dostatečně na výši, abyste se obešli i bez mých rad. ");
INSERT INTO ceslb_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Přesto jsem si v tomto dopise dovolil připomenout vám některé věci. ");
INSERT INTO ceslb_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","K tomu mne přece Bůh povolal, abych byl služebníkem Ježíše Krista mezi všemi národy. Plním tedy tento svatý úkol, aby se všichni obrátili k Bohu a pod vedením Ducha svatého se mu cele odevzdali. ");
INSERT INTO ceslb_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Účast na Božím díle je mou největší chloubou. ");
INSERT INTO ceslb_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","19","Považuji za přednost, že Kristus mým prostřednictvím probouzí víru v pohanech, mění jejich život a zázračným způsobem je přesvědčuje o své moci. Rozšířil jsem jeho poselství po celém okolí Jeruzaléma a ve všech krajích až po Illyrii. ");
INSERT INTO ceslb_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Zakládám si na tom, že zvěstuji Krista těm, kteří o něm dosud neslyšeli. Nechci stavět na cizích základech, ");
INSERT INTO ceslb_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ale řídím se slovy Písma: „Uvidí ho ti, kdo o něm nic nevěděli, a poznají ho ti, kdo o něm nikdy neslyšeli.“ ");
INSERT INTO ceslb_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","To byl tedy důvod, který mě dlouho zdržoval od cesty k vám do Říma. ");
INSERT INTO ceslb_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ale nyní jsem v této oblasti svou práci dokončil. ");
INSERT INTO ceslb_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Už několik let se těším, že se u vás zastavím při cestě do Španělska. Doufám, že teď se mi to přání konečně splní a že se s vámi nějakou chvíli potěším, než mne zase vyprovodíte dál. ");
INSERT INTO ceslb_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Zatím však musím ještě podniknout cestu do Jeruzaléma, abych pomohl tamním křesťanům. ");
INSERT INTO ceslb_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","V Makedonii a Řecku uspořádali totiž sbírku na potřebné bratry v Jeruzalémě. ");
INSERT INTO ceslb_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Rozhodli se tak, protože jsou Jeruzalémským zavázáni vděčností za užitek z jejich duchovního bohatství. ");
INSERT INTO ceslb_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Až tedy vyřídím tuto záležitost a vybrané peníze odevzdám, vypravím se do Španělska a cestou se zastavím u vás. ");
INSERT INTO ceslb_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Už teď cítím, že Kristus našemu setkání určitě požehná. ");
INSERT INTO ceslb_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Chci vás ještě poprosit, milí bratři, modlete se za mne, ");
INSERT INTO ceslb_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","abych byl ochráněn před nepřátelstvím nevěřících v Judsku a také aby Jeruzalémští mou službu dobře přijali. ");
INSERT INTO ceslb_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Potom – když mi to dopřeje Bůh – s radostí přijdu k vám, abych mezi vámi trochu pookřál. ");
INSERT INTO ceslb_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Bůh, dárce pokoje, buď s vámi všemi. ");
INSERT INTO ceslb_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Doporučuji vám sestru Fébu, obětavou služebnici Kenchrejského křesťanského sboru. Ochotně pomáhala mně i jiným. ");
INSERT INTO ceslb_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Jestli se na vás obrátí, udělejte pro ni všechno, co budete moci, jak se na křesťany sluší. ");
INSERT INTO ceslb_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","4","Pozdravujte Prisku a Akvilu, kteří pro mne v Kristových službách riskovali život; nejen já, ale všichni křesťané jsou jim za to dlužníky. ");
INSERT INTO ceslb_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Také všem věřícím, kteří se u nich scházejí, posílám srdečný pozdrav. Obzvlášť zdravím Epaineta, prvního asijského křesťana, ");
INSERT INTO ceslb_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","a Marii, která tolik pro vás udělala. ");
INSERT INTO ceslb_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Pozdravujte mé krajany a bývalé spoluvězně Andronika a Junia, vynikající muže mezi apoštoly, kteří se stali křesťany dříve než já. ");
INSERT INTO ceslb_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","16","Dále pozdravujte Ampliáta, Urbana, Stachyna a Apella. Také všechny od Aristobulů a Narcisů, Herodiona, Tryfainu, Tryfosu a Persidu. A ovšem Rufa a jeho matku – měla mě jako vlastního. A ještě Asynkrita, Flegonta, Herma, Patrobu, Hermeu a ostatní tamější bratry, Filologa, Julii, Nerea a jeho sestru, Olympa a všechny křesťany u nich. Pozdravte je ode mne bratrským polibkem. Taky ode všech křesťanských sborů a skupin vyřizuji pozdravy. ");
INSERT INTO ceslb_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Jedno bych vám ještě rád položil na srdce: dejte si pozor na ty, kdo vyvolávají spory a svádějí vás z cesty, kterou jste nastoupili. ");
INSERT INTO ceslb_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Takoví kážou ne proto, aby sloužili Kristu, ale pro svůj vlastní prospěch. Vyhýbejte se jim. Bezelstného člověka snadno zmatou líbivými řečmi. ");
INSERT INTO ceslb_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","O vaší víře všude slyším jen to nejlepší a mám z toho radost. Přeji vám moudrost v konání dobra a zlo ať se vás ani nedotkne. ");
INSERT INTO ceslb_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Bůh, dárce pokoje, už brzo rozdrtí satana u vašich nohou. Náš Pán Ježíš Kristus ať vás obdaří svou milostí. ");
INSERT INTO ceslb_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Pozdravuje vás můj spolupracovník Timoteus a přátelé Lucius, Jáson a Sozipater. ");
INSERT INTO ceslb_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","I já, písař tohoto listu, Tercius, připojuji svůj pozdrav. ");
INSERT INTO ceslb_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Také Gaius, náš hostitel, vás pozdravuje a rovněž vás zdraví správce městské pokladny Erastus a bratr Kvartus. ");
INSERT INTO ceslb_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","26","Bůh vám může dát schopnost žít podle slov, která jsem vám zvěstoval. Byly vám zjeveny jeho dávné plány, dlouho skryté, ale nyní objasněné proroctvími, abyste je vírou poslušně přijali a podle nich žili. ");
INSERT INTO ceslb_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Nade vše moudrému Bohu věčná sláva za Ježíše Krista. Váš Pavel");
INSERT INTO ceslb_vpl VALUES ("C11_1","076_1_1","1CO","1","1","3","Milí přátelé a drazí bratři, srdečně vás zdravím a zároveň i od Sosthena vyřizuji přání Boží milosti a pokoje – nejen vám v Korintu, ale i všem, kteří se kdekoliv hlásí ke Kristovu jménu. ");
INSERT INTO ceslb_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Stále znovu musím děkovat Bohu, když vidím, jaké cenné hodnoty zplodilo mezi vámi svědectví o Ježíši Kristu. ");
INSERT INTO ceslb_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Právě tím se potvrdila jeho pravdivost, takže teď víte a znáte všechno, co je třeba. ");
INSERT INTO ceslb_vpl VALUES ("C11_6","076_1_6","1CO","1","6","7","Zbývá jen jedno: s touhou vyhlížet návrat našeho Pána, Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","On vám dá také sílu vydržet až do konce, takže se toho dne určitě dočkáte bez úhony. ");
INSERT INTO ceslb_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Vždyť ke společenství s Kristem nás povolal přece sám Bůh – můžeme snad mít lepší záruku? ");
INSERT INTO ceslb_vpl VALUES ("C11_10","076_1_10","1CO","1","10","11","Doslechl jsem se, milí bratři, že vaše obec není jednotná a že se dělíte na skupiny, které se mezi sebou hádají. ");
INSERT INTO ceslb_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Jedni prý vynášíte Pavla, jiní držíte s Petrem, jiní se hlásí k Apollovi a jiní zase ke Kristu. Proto vás jménem našeho Pána, Ježíše Krista, napomínám: buďte všichni zajedno a nehádejte se. Smýšlejte a usuzujte stejně; ");
INSERT INTO ceslb_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Kristus je přece jen jeden. Byl snad za vás ukřižován Pavel? Nebo jsem snad někoho křtil ve svém vlastním jménu? ");
INSERT INTO ceslb_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ještě dobře, že jsem kromě Krispa a Gája nikoho z vás nekřtil, ");
INSERT INTO ceslb_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","takže se na můj křest nemůže nikdo odvolávat. ");
INSERT INTO ceslb_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Vlastně jsem křtil ještě Štěpánovu rodinu, ale jinak už o nikom nevím. ");
INSERT INTO ceslb_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kristus mě totiž neposlal křtít, ale hlásat jeho radostné poselství; ne ovšem tak, abych posluchače oslňoval svou moudrostí, která nikomu nepomůže, nýbrž abych jim předkládal jedinou cestu k záchraně – jeho kříž. ");
INSERT INTO ceslb_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kdo směřuje do záhuby, má ovšem učení o Kristově kříži za hloupost. Ale my víme – a to je naše záchrana, že Bůh právě tímto způsobem projevil svou moc. ");
INSERT INTO ceslb_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","V Písmu stojí: „Způsobím, že moudrým nepomůže jejich moudrost a chytrost chytrých nebude k ničemu.“ ");
INSERT INTO ceslb_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Kde jste, filozofové, znalci zákona a všichni učenci? Nedokázal Bůh, jak pošetilá je všechna moudrost světa? ");
INSERT INTO ceslb_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","A protože přemoudřelému světu nestačily projevy Boží moudrosti k poznání Boha, rozhodl se Bůh zachránit ty, kdo mu uvěří, „pošetilým“ kázáním. ");
INSERT INTO ceslb_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Židé čekají jen samé zázraky, Řekové ve všem hledají logiku, ");
INSERT INTO ceslb_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ale my kážeme – ukřižovaného Krista. Židy to uráží a ostatní to pokládají za nesmysl. ");
INSERT INTO ceslb_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ale povolaní, ať židé či jinověrci, získávají v Kristu Boží moc i moudrost. ");
INSERT INTO ceslb_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Boží „pošetilost“ je totiž moudřejší a Boží „nemohoucnost“ je silnější než lidé. ");
INSERT INTO ceslb_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Jen se kolem sebe rozhlédněte, bratři, koho si to vlastně Bůh povolal. Zjistíte, že mezi vámi není mnoho vzdělanců ani lidí vlivných a vážených. ");
INSERT INTO ceslb_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","A přece si Bůh vyvolil právě ty nevzdělané, aby zahanbil moudré. Obyčejné malé lidi si vyvolil, aby zahanbil vlivné a mocné, ");
INSERT INTO ceslb_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","a bezvýznamné „nuly“ si vybral, aby zlomil moc pyšných domýšlivců. ");
INSERT INTO ceslb_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","A to všechno proto, aby se před Bohem nikdo nepovyšoval. ");
INSERT INTO ceslb_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Vždyť jen z vašeho spojení s Ježíšem Kristem pramení vaše moudrost, bezúhonnost, svatost i vykoupení. Opravdu se nemáme chlubit ničím jiným než Kristem, ");
INSERT INTO ceslb_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","jak nás i Písmo napomíná: Kdo se chlubí, chlub se skutky Božími. ");
INSERT INTO ceslb_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Bratři, když jsem vám hlásal poselství o Kristu, také jsem nepřišel s nějakými zvlášť výřečnými proslovy nebo kdovíjak učenými výklady. ");
INSERT INTO ceslb_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Rozhodl jsem se totiž, že pokud budu u vás, nechci mluvit o ničem jiném než právě o Kristu, a to o Kristu ukřižovaném. ");
INSERT INTO ceslb_vpl VALUES ("C12_3","076_2_3","1CO","2","3","4","Často se mi třásl hlas, musel jsem překonávat slabost a všelijaké obavy. A jestli vás nakonec něco přesvědčilo, tak to nebyla moje učenost nebo výmluvnost, nýbrž moc Božího Ducha. ");
INSERT INTO ceslb_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","A to je dobře, protože vaše víra nemá stát na lidské moudrosti, ale na moci Boží. ");
INSERT INTO ceslb_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Je pochopitelné, že pokročilejším křesťanům předkládáme i náročnější učení. Nejsou to ovšem poznatky přírodních nebo společenských věd, ");
INSERT INTO ceslb_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","nýbrž pravdy pocházející z Boha, a proto bez Božího přispění zůstávají tajemné a skryté. Bůh už před věky připravil moudrý plán, jak nás převést do své nebeské slávy. ");
INSERT INTO ceslb_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Nikdo z těch, kdo vládnou světu, neměl o nich tušení. Jinak by byli nemohli Krista ukřižovat. ");
INSERT INTO ceslb_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","My hlásáme, jak stojí i v Písmu: „Co lidské oko nikdy nevidělo ani žádné ucho neslyšelo, co člověka ani ve snu nenapadlo – to nabízí Bůh těm, kdo ho milují.“ ");
INSERT INTO ceslb_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nám to Bůh odhalil prostřednictvím svého Ducha, kterému nic není skryto. ");
INSERT INTO ceslb_vpl VALUES ("C12_11","076_2_11","1CO","2","11","12","Jako nitro člověka je přístupné jen vlastnímu vědomí každého jedince, tak i Boží myšlení je známé jen Božímu Duchu, takže jenom s jeho pomocí můžeme poznat, co všechno nám Bůh daroval. ");
INSERT INTO ceslb_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Když o těchto věcech mluvíme, nejde nám o to, aby to vypadalo „rozumně“, ale nasloucháme prostě tomu, co nám „napovídá“ Boží Duch, a jeho myšlenky tlumočíme slovy, která nám dává. ");
INSERT INTO ceslb_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Člověku vyzbrojenému jen vrozenými schopnostmi jsou ovšem pravdy Božího Ducha proti mysli. Zdají se mu hloupé a nepochopitelné, protože pochopit se dají jen s pomocí Ducha. ");
INSERT INTO ceslb_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Kdo je však proniknut Božím Duchem, dovede ke všemu zaujmout jasný postoj a nemusí se ohlížet, co tomu řeknou lidé; ");
INSERT INTO ceslb_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","vždyť nikdo z nich nestojí ve svém poznání nad Bohem. Naše myšlenky pak vycházejí ze stejného zdroje jako myšlenky Kristovy. ");
INSERT INTO ceslb_vpl VALUES ("C13_1","076_3_1","1CO","3","1","2","Bratři, jestli jsem k vám mluvil jako k malým dětem, mělo to svůj důvod. Nemohl jsem přece od vás v duchovních záležitostech očekávat chápavost vyspělých křesťanů, když vaše víra byla teprve v plenkách. ");
INSERT INTO ceslb_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Mám dokonce dojem, že z nich dosud nevyrostla a že stále ještě u vás převládají tělesné sklony. Řekněte sami – nejsou vaše spory a žárlivost až příliš lidské? ");
INSERT INTO ceslb_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Když někdo tolik zdůrazňuje „já jsem s Pavlem“ a jiný zase „já s Apollem“, nelpíte příliš na osobě? ");
INSERT INTO ceslb_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Vždyť kdo je Apollo? A kdo je Pavel? Pouze služebníci, kteří vám pomohli dospět k víře – každý zase jen tou měrou, jak mu uložil Bůh. ");
INSERT INTO ceslb_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Já jsem zasadil, Apollo zaléval, ale vzrůst dal Bůh. ");
INSERT INTO ceslb_vpl VALUES ("C13_7","076_3_7","1CO","3","7","9","To on dává vznik životu, a ne ten, kdo sází nebo zalévá. On své pomocníky odmění podle jejich práce, ale jinak jsou si všichni rovni v tom, že jsou jen pouhými pomocníky na Božím díle. ");
INSERT INTO ceslb_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Z Božího pověření jsem jako zkušený v tomto směru mohl položit základy, na kterých dál staví už jiný. Dávejte však pozor, jak staví! ");
INSERT INTO ceslb_vpl VALUES ("C13_11","076_3_11","1CO","3","11","12","Základem je Ježíš Kristus, jiný základ už položit nelze. Ale i potom je možno na ten základ stavět buď solidní budovu, jež přetrvá věky, nebo slepit chatrč, kterou rozhází první nápor větru. ");
INSERT INTO ceslb_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Kvalita stavby se musí osvědčit ve zkouškách – teprve ty ukáží, co kdo vlastně postavil. ");
INSERT INTO ceslb_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Když dílo vydrží, dostane stavitel odměnu. ");
INSERT INTO ceslb_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Komu se jeho dílo sesype, ten se sice sám zachrání, ale nic po něm nezůstane. ");
INSERT INTO ceslb_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Nezapomeňte, že ve vás působí Boží Duch, že jste Božím příbytkem. ");
INSERT INTO ceslb_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Kdo by ničil Boží chrám, který je nedotknutelný, toho zničí Bůh. ");
INSERT INTO ceslb_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Nežijte v sebeklamu. Kdo si o sobě myslí, že všechno umí vysvětlit rozumem, jak se to dnes požaduje, ten má nejvíc zapotřebí stát se pro svět „pošetilcem“. Jen to je cesta k opravdové moudrosti. ");
INSERT INTO ceslb_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Všechno vědění, jímž se svět pyšní, je v Božích očích směšné. Stojí přece v Písmu: „On chytá rozumáře do léčky, kterou si sami nastraží“, ");
INSERT INTO ceslb_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","anebo „Pán dobře zná výpočty moudrých: nejsou k ničemu“. ");
INSERT INTO ceslb_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ať si tedy nikdo nezakládá na lidech. ");
INSERT INTO ceslb_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Pavel nebo Petr nebo Apollo – všichni jsou „vaši“ stejným dílem. Vám patří i svět, život i smrt, všechno v přítomnosti a všechno v budoucnosti. Všechno je vaše, ");
INSERT INTO ceslb_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","vy Kristovi a Kristus Boží. ");
INSERT INTO ceslb_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Nedívejte se na nás tedy jinak než jako na Kristovy služebníky a správce Božích tajemství. ");
INSERT INTO ceslb_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Od služebníka se očekává, že bude vykonávat příkazy svého pána. Dá se to říci o mně? ");
INSERT INTO ceslb_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Co o tom soudíte vy, není pro mne nejdůležitější. A nemůže to posoudit ani nikdo jiný, dokonce ani můj vlastní úsudek není rozhodující, ");
INSERT INTO ceslb_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","i když mé svědomí je klidné. Jen sám Pán o tom může rozhodnout s konečnou platností. ");
INSERT INTO ceslb_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Nedělejte proto o nikom předčasné závěry, dokud se nevrátí Kristus. Však on už vynese na světlo to, co bylo zrakům skryto, a odhalí i ty nejtajnější pohnutky. Pak teprve dostane každý od Boha takové uznání, jaké mu náleží. ");
INSERT INTO ceslb_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Bratři, jistě rozumíte, že nemluvím jen o sobě a Apollovi, když vám tohle všechno říkám. Chtěl jsem jen na tom příkladu zdůraznit, že nemáte prosazovat své oblíbené kazatele proti jiným. ");
INSERT INTO ceslb_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Nikdo přece nejsme ničím víc než ostatní. Všichni máme jen to, co jsme dostali, a nemáme se tedy před druhými čím chlubit. ");
INSERT INTO ceslb_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Vy jste přesvědčeni, že už jste duchovně dost vysoko a že víc nepotřebujete. Pyšníte se, že jste příslušníky Božího království. Kéž byste jimi skutečně byli! Necítili byste se pak tolik nad nás povzneseni. ");
INSERT INTO ceslb_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Tak se mi zdá, že nám apoštolům vykázal Bůh to nejposlednější místo, jako odsouzencům na smrt. Stali jsme se podívanou pro svět, anděly i lidi. ");
INSERT INTO ceslb_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Prý nám náboženství popletlo hlavu, zato vy jste docela rozumní a vážení křesťané! Námi kdekdo pohrdá, vás každý uznává, my jsme slabí, vy siláci! ");
INSERT INTO ceslb_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Trpíme hladem a žízní, zimou a nemocemi, jsme štváni z místa na místo ");
INSERT INTO ceslb_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","a na svůj chléb musíme tvrdě vydělávat. Žehnáme těm, kdo nás proklínají, když nás šikanují, trpělivě to snášíme, ");
INSERT INTO ceslb_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","pomlouvají-li nás, modlíme se za ně. Nikde nemáme zastání, jsme stále jen vyděděnci. ");
INSERT INTO ceslb_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Ale to nepíšu proto, že bych vám chtěl něco vyčítat. Vždyť vás mám rád jako vlastní děti. ");
INSERT INTO ceslb_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Kazatelů a vychovatelů můžete mít celou řadu, ale vaším duchovním otcem jsem já, protože prvně jste evangelium slyšeli ode mne. ");
INSERT INTO ceslb_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Proto vás nabádám, abyste žili podle mého příkladu. ");
INSERT INTO ceslb_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Z téhož důvodu k vám posílám svého milovaného a věrného spolupracovníka Timotea. Víte, že ho mám rád jako svého vlastního syna. Ten vám připomene mé křesťanské způsoby, jak jim taky v každé církevní obci vyučuji. ");
INSERT INTO ceslb_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Někteří se začali povyšovat, jako bych už neměl do Korintu přijít. Velice se mýlí! ");
INSERT INTO ceslb_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Přijdu co nejdříve, jak mi jen Pán dovolí, a pak uvidíme, zda je v jejich řeči Boží síla, nebo jen prázdné holedbání. ");
INSERT INTO ceslb_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Boží království přece nestojí na řečnickém umění, ale na síle Božího Ducha. ");
INSERT INTO ceslb_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Co mám tedy přibalit na cestu: hůl – nebo lásku a přívětivost? ");
INSERT INTO ceslb_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Slyšel jsem, že se dokonce u vás vyskytla nemravnost, jakou by člověk i mezi pohany těžko hledal: že si totiž jeden z vás udělal milenku z nevlastní matky. ");
INSERT INTO ceslb_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","A to se ještě nestydíte zdvihat nos až k nebi, místo abyste se zhrozili a vyloučili takového člověka ze svého společenství! ");
INSERT INTO ceslb_vpl VALUES ("C15_3","076_5_3","1CO","5","3","4","Ačkoliv nejsem mezi vámi, mnoho jsem o tom přemýšlel a jako služebník Ježíše Krista jsem už rozhodl, co je třeba udělat. Svolejte shromáždění všech věřících, moc Pána Ježíše bude s vámi – a já v jeho Duchu také – ");
INSERT INTO ceslb_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","a ten člověk ať je vyloučen ze společenství křesťanů a ať je ponechán moci zla. Vždyť může být zachráněn, až Ježíš Kristus přijde soudit svět. ");
INSERT INTO ceslb_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Nechápu, jak se můžete chlubit svou dokonalostí a přitom mezi sebou trpět takovou špínu. Cožpak nechápete, že nákaza, když se jí neučiní přítrž, může brzy zachvátit i ostatní? ");
INSERT INTO ceslb_vpl VALUES ("C15_7","076_5_7","1CO","5","7","8","Ložisko rozkladu musíte odstranit, chcete-li sami zůstat čistí. Kristus byl zabit za nás! Nechme už tedy toho starého, hříchem prolezlého života a oslavujeme Krista v čistotě, upřímnosti a pravdivosti. ");
INSERT INTO ceslb_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Napsal jsem, že od špatných lidí se máte držet co nejdál. ");
INSERT INTO ceslb_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Nemyslel jsem to ovšem tak, že se máte vyhýbat všem nepoctivým, chamtivým, oplzlým a bezbožným lidem. To byste se museli vystěhovat na pustý ostrov. ");
INSERT INTO ceslb_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Jestliže se však někdo vydává za křesťana, ale je nepoctivý a chamtivý, holduje kariéře a majetku, alkoholu, pohlavní nevázanosti nebo jiným neřestem, pak s ním ani nesedejte k jednomu stolu. ");
INSERT INTO ceslb_vpl VALUES ("C15_12","076_5_12","1CO","5","12","13","Soudit nekřesťany – na to právo nemáte, ty ať soudí Bůh. Ale z našich řad musí být takový člověk vyloučen! ");
INSERT INTO ceslb_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Smutné je i to, že mezi sebou vedete spory před světskými soudy. Není vám hanba? ");
INSERT INTO ceslb_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Cožpak křesťané, kterým jednou bude svěřen soud nad celým světem, nejsou schopni dohodnout se sami mezi sebou? ");
INSERT INTO ceslb_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Nevíte, že jednou máte soudit i anděly? ");
INSERT INTO ceslb_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Co jsou proti tomu nějaké obchodní záležitosti? Styďte se, že vám tohle musím vytýkat. ");
INSERT INTO ceslb_vpl VALUES ("C16_5","076_6_5","1CO","6","5","8","To se mezi vámi nenajde ani jeden, kdo by vás rozsoudil? Není v takovém případě lepší nést křivdu než žalovat na svého bratra u nekřesťanů? Určitě tím uděláte svému Pánu větší čest. ");
INSERT INTO ceslb_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Myslíte, že do Božího království se dostane někdo hříšný? Neklamte sami sebe. Žádný chamtivec a požitkář, ani cizoložník nebo homosexuál, ");
INSERT INTO ceslb_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ani zloděj, opilec a hrubián do Božího království nevkročí! ");
INSERT INTO ceslb_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","I vy jste takoví bývali ale byli jste očištěni, prohlášeni za bezúhonné a odděleni pro Boha prostřednictvím jeho Ducha, a to zásluhou Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Křesťanství – to není žádný seznam „smíš – nesmíš“. Nic nám není zakázáno, ne všechno nám však prospívá. Ke všemu smíme přistupovat svobodně – ale ne tak, aby nás to nakonec ovládlo. ");
INSERT INTO ceslb_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Bůh nám dal chuť k jídlu a žaludek pro přijímání potravy; ovšem ani jedno ani druhé tu nebude věčně. Smilstvo je však problém daleko vážnější. Tělo nám nebylo dáno k tomu, abychom ho zneužívali, ale aby sloužilo Kristu. ");
INSERT INTO ceslb_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","A stejnou mocí, jakou vzkřísil Bůh Krista, vzkřísí také nás. ");
INSERT INTO ceslb_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Naše těla jsou vlastně buňkami těla Kristova. ");
INSERT INTO ceslb_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Jak bychom mohli něco takového spojovat s prodejnou ženou? Mojžíš říká, že „dva se stanou jedním tělem“. Je myslitelné a lze si vůbec představit jedno tělo ze dvou tak rozdílných „materiálů“? ");
INSERT INTO ceslb_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","My přece máme usilovat o jinou jednotu – o jednotu s Kristem! ");
INSERT INTO ceslb_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Proto se varujte smilstva. Ostatní přestupky se těla přímo nedotýkají, ale smilstvem se proviňujete na svém vlastním těle. ");
INSERT INTO ceslb_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Mějte na paměti, že vaše tělo je chrámem svatého Ducha, který v něm bydlí a kterého vám dal Bůh. ");
INSERT INTO ceslb_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Nepatříte už sami sobě, byli jste koupeni – a velmi draze koupeni. Ať tedy i vaše tělo dělá Bohu čest! ");
INSERT INTO ceslb_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Teď ještě k dalším otázkám vašeho dopisu. Dokáže-li si muž odepřít ženu, prospěje mu to. ");
INSERT INTO ceslb_vpl VALUES ("C17_2","076_7_2","1CO","7","2","3","Než však své síly přecenit a podlehnout pak pokušení s cizí ženou, je lépe, aby muž měl svou manželku a žena svého manžela. Pohlavní touha je přirozená a její naplnění by si manželé neměli vzájemně odepírat. ");
INSERT INTO ceslb_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","V manželství nemá ani muž ani žena právo nakládat se svým tělem bez ohledu na toho druhého. ");
INSERT INTO ceslb_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Proto se jeden druhému neodpírejte, leda po vzájemné dohodě a jen na čas, kvůli modlitbám; pak se zase jeden druhému odevzdejte, jinak byste se vystavovali nebezpečným pokušením. ");
INSERT INTO ceslb_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Tím samozřejmě manželství nikomu nenařizuji, jenom k němu vyslovuji souhlas. ");
INSERT INTO ceslb_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Pochopitelně bych byl rád, kdyby měl každý takovou svobodu zříci se ho, jako mám já. Ale Bůh nedává všem stejný dar: jednomu dá to, jinému ono. ");
INSERT INTO ceslb_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Osamělým a zejména vdovám doporučuji, aby do manželství už nevstupovali. ");
INSERT INTO ceslb_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Jestliže jim však zdrženlivost dělá potíže, ať se raději ožení či vdají. Je lepší se vdát a oženit, než se trápit neukojenou touhou. ");
INSERT INTO ceslb_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Pro manžele však platí jednoznačně – a to není příkaz můj, nýbrž Kristův: žena ať od svého muže neodchází; ");
INSERT INTO ceslb_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","pokud už odešla a nechce se k němu vrátit, musí zůstat neprovdána. Stejně ani muž se nesmí se ženou rozvést. ");
INSERT INTO ceslb_vpl VALUES ("C17_12","076_7_12","1CO","7","12","13","O dalších problémech se Kristus sám nevyjádřil. Já bych však radil toto: když se stal křesťanem jen jeden z manželů, ale ten druhý s ním chce žít dál, ať se nerozcházejí. Nemusíte mít strach, že by vaše děti byly nečisté. ");
INSERT INTO ceslb_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Víra i jen jednoho z manželů má v tomto případě očistný účinek i na druhého nevěřícího. ");
INSERT INTO ceslb_vpl VALUES ("C17_15","076_7_15","1CO","7","15","16","Ale chce-li nevěřící z manželů odejít, nechte ho odejít. Nejste přece povinni držet se ho za každou cenu, jako byste byli jeho otrokem. Nebo máte nějakou záruku, že ho zachráníte, když rozchod odmítnete? ");
INSERT INTO ceslb_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Každý by měl zůstat v tom postavení, v jakém ho zastihlo Boží povolání. Tak to vykládám ve všech křesťanských obcích. ");
INSERT INTO ceslb_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Kdo se například nechal po židovském způsobu obřezat, nemusí si z toho dělat těžkou hlavu, když se stal křesťanem. A kdo nebyl obřezán, nemusí ten obřad podstupovat ani nyní. ");
INSERT INTO ceslb_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Pro křesťana není důležité, zda podstoupil obřad obřízky či nikoliv. Důležité je, aby vyplnil Boží příkazy. ");
INSERT INTO ceslb_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Zůstaň tedy tím, čím jsi byl, když jsi uslyšel Boží hlas. ");
INSERT INTO ceslb_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Zastihl tě v otroctví? Nic si z toho nedělej; otroctví hříchu je daleko strašnější – a z toho jsi přece vysvobozen. Občanskými svobodami ovšem nepohrdej, když jich můžeš využít. ");
INSERT INTO ceslb_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","A naopak, jestliže jsi svobodný občan, pamatuj, že Kristus tě povolal, aby ses stal jeho otrokem. ");
INSERT INTO ceslb_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","On tě koupil a draze zaplatil. Jak by tě mohlo zotročit ještě něco jiného? ");
INSERT INTO ceslb_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Nehledej tedy únik z postavení, ve kterém jsi se nacházel, když tě Kristus povolal. On je tam přece s tebou. ");
INSERT INTO ceslb_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","O neprovdaných dívkách mi Kristus žádné zvláštní pokyny nedal. Když mi však Bůh dal vaši důvěru, řeknu vám své osobní mínění. ");
INSERT INTO ceslb_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Myslím, že vzhledem k soužením, která jsou před námi, je moudřejší se nevdávat. ");
INSERT INTO ceslb_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Vdané a ženatí ať se kvůli tomu ovšem nerozcházejí, ale svobodní ať do manželství nespěchají. ");
INSERT INTO ceslb_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Kdo se přes všechna nebezpečí rozhodne do manželství vstoupit, ten samozřejmě nehřeší; musí však počítat s tím, že mu z toho rozhodnutí vzejdou nemalé problémy, kterých bych vás rád právě nyní ušetřil. ");
INSERT INTO ceslb_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Hlavně nesmíme zapomínat, že před sebou nemáme už mnoho času. Ať tedy manželku máš nebo nemáš, ");
INSERT INTO ceslb_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ať jsi smutný nebo se raduješ, nedej se tím zdržovat od Božího díla. ");
INSERT INTO ceslb_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Užívej s radostí všeho dobrého, co svět nabízí, ale mysli na to, že nic z toho nepotrvá věčně, a nezabydluj se ve světě, který dnes je a zítra být nemusí. ");
INSERT INTO ceslb_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Byl bych rád, abyste si sami nepřidávali starostí. Svobodný může věnovat svůj čas Božímu dílu, ");
INSERT INTO ceslb_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","kdežto ženatý se musí starat o ženu a rodinu, a tak dělit své myšlenky mezi Boha a pozemské věci. ");
INSERT INTO ceslb_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Stejné problémy má vdaná žena: starost o svůj zevnějšek, o domácnost, jak vyhovět mužovým zálibám a vrtochům. Naproti tomu svobodná dívka a neprovdaná žena má spíš možnost pečovat o krásu ducha, která se líbí Bohu. ");
INSERT INTO ceslb_vpl VALUES ("C17_35","076_7_35","1CO","7","35","36","To všechno vám říkám, abych vám pomohl, ne abych vás odradil od sňatku. Chci vám ukázat, jak sloužit Pánu co nejlépe a co všechno by vás od toho mohlo odvádět. ");
INSERT INTO ceslb_vpl VALUES ("C17_37","076_7_37","1CO","7","37","38","Kdo si nedovede představit život bez manželství, ať do něj vstoupí, není na tom nic špatného. Kdo však má sám sebe tak dalece v moci, že dokáže svou touhu udržet na uzdě, a rozhodne se zůstat svobodný, učinil moudré rozhodnutí. Zkrátka a dobře; obojí je správné, ale to druhé je lepší. ");
INSERT INTO ceslb_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Žena je vázána věrností, pokud její muž žije. Jestliže věřící žena ovdoví, je volná a může se znovu provdat, ovšem jen za křesťana. Bude však šťastnější, když to neudělá. ");
INSERT INTO ceslb_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","To je moje rada a domnívám se, že i já se smím odvolávat na vedení Božím Duchem. ");
INSERT INTO ceslb_vpl VALUES ("C18_1","076_8_1","1CO","8","1","3","Tázali jste se také, zda křesťan smí jíst maso ze zvířat obětovaných při pohanských obřadech. Jsme zajedno v tom, že každý z nás má o Bohu a jeho vůli nějaké poznání. Pouhé vědomosti a vytříbený úsudek však často vedou jen k domýšlivosti. Kdo nehledá nic jiného než vědění a poznatky, jedná v podstatě sobecky. Láska však směřuje k druhému člověku, buduje vzájemné vztahy. ");
INSERT INTO ceslb_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Pokud jde o maso obětované z pohanských obětí, víme, že Bůh je jenom jeden, a modly tudíž naprosto nic neznamenají. ");
INSERT INTO ceslb_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Jestli se jim také říká „bůh“ – a takových „bůžků“ je celá řada, to na věci nic nemění. ");
INSERT INTO ceslb_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","My známe jednoho Boha, našeho Otce, od něhož všechno pochází a jemuž patříme i my. A máme jen jediného Pána, Ježíše Krista, který dal život všemu – a také nám. ");
INSERT INTO ceslb_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ne všichni však dospěli k tomuto poznání. Někteří nedávno sami uctívali modly, a proto v tomto mase dosud cítí příchuť modloslužby. Svědomí ovlivňované ještě pohanskou minulostí, jim to pak ovšem vyčítá. ");
INSERT INTO ceslb_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Je pravda, že jídlo nám u Boha ceny nedodá ani neubere, nic jím nezískáme ani neztratíme. ");
INSERT INTO ceslb_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Ale musíte být opatrní, aby se váš svobodný postoj nestal příčinou poklesku jiných, slabších. ");
INSERT INTO ceslb_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Když tě totiž někdo vidí dělat něco, co sám pokládá za nesprávné, může být tvým příkladem sveden dělat totéž – proti hlasu svého vlastního svědomí! ");
INSERT INTO ceslb_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","A tak se tvé poznání může stát neštěstím pro tvého slabšího bratra, za kterého Kristus zemřel. ");
INSERT INTO ceslb_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Připravovat takto bratrovo svědomí o klid a vyvolávat v něm konflikt je proto nejen nelaskavé vůči bratrovi, ale urážlivé i vůči Kristu. ");
INSERT INTO ceslb_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Jestliže by tedy moje jídlo mělo být příčinou bratrova pádu, raději se toho jídla zřeknu, než bych bratrovi ublížil. ");
INSERT INTO ceslb_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Zamyslete se nad tím, jak já nakládám se svou svobodou. Což nejsem zplnomocněnec Ježíše Krista? Což se mi osobně neukázal u Damašku? ");
INSERT INTO ceslb_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Jestli mi někteří tuto autoritu upírají, vy sami jste živým důkazem, že opravdu mám jeho pověření. Jinak byste přece byli až dosud pohany. ");
INSERT INTO ceslb_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Svým kritikům odpovídám: ");
INSERT INTO ceslb_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Nemám snad i já právo na hmotné zaopatření ");
INSERT INTO ceslb_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","a na manželku jako ostatní apoštolové a Ježíšovi bratři nebo i jako sám Petr? ");
INSERT INTO ceslb_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Proč právě já a Barnabáš bychom měli být odkázáni na to, co si vyděláme prací? ");
INSERT INTO ceslb_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Už jste snad viděli vojáka, který by sloužil v armádě na vlastní náklady? Nebo hospodáře, který by nesklízel plody z toho, co zasadil? Nebo pastevce, který pase krávy a nepije jejich mléko? ");
INSERT INTO ceslb_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Nemyslete si, že jsou to jen moje ziskuchtivé nápady. ");
INSERT INTO ceslb_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","I v Mojžíšově zákoně najdete: „Zvířeti, které používáš při sklizni, nedáš náhubek.“ Má-li na svůj podíl nárok i ta němá tvář, nemá ho mít tím spíš člověk? ");
INSERT INTO ceslb_vpl VALUES ("C19_10","076_9_10","1CO","9","10","12","Když my mezi vámi rozséváme věčné hodnoty, proč by nám nemohlo být dopřáno podílet se na vašich hmotných statcích, tak jako se na nich podílejí i jiní? Přesto však jsme se toho práva nijak nedovolávali a raději budeme snášet i bídu, aby někomu závist nebránila slyšet radostné poselství o Kristu. ");
INSERT INTO ceslb_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Ano, vzdal jsem se práva na zaopatření, ačkoliv víte, že kdo je zaměstnán v chrámových službách, toho platí chrámová pokladna, a kdo slouží u oltáře, dostává z obětí svůj díl. ");
INSERT INTO ceslb_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Tak i Kristus ustanovil, že jeho poslové mají žít z toho, co dostanou od posluchačů. ");
INSERT INTO ceslb_vpl VALUES ("C19_15","076_9_15","1CO","9","15","16","Přesto jsem se nikdy ničeho nedožadoval a ani teď to nepíšu proto, že bych snad něco takového očekával. Raději bych zemřel, než bych zahodil to, nač jsem až dosud mohl být hrdý. ");
INSERT INTO ceslb_vpl VALUES ("C19_17","076_9_17","1CO","9","17","18","Abyste mi dobře rozuměli: to, že hlásám Kristovo poselství, nepokládám si za zásluhu, za níž bych měl nárok na odměnu. Je to prostě moje povinnost, úkol, který musím splnit – jinak se mnou bude zle. Jsem však hrdý na to, že sloužím Kristu jako jeho vyslanec a vůbec nic za to nechci, že se vzdávám i toho, co mi právem náleží. ");
INSERT INTO ceslb_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Na nikom tedy nejsem závislý, a přesto jsem se dobrovolně dal do služby všem, abych získal víc lidí pro Krista. ");
INSERT INTO ceslb_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Abych získal židy, vystupoval jsem mezi nimi jako žid. Mezi lidmi podřízenými Mojžíšovým zákonům jsem se i já podřizoval, i když už jimi vázán nejsem. ");
INSERT INTO ceslb_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","A mezi lidmi, kteří je neznají, jsem na nich ani já nikterak nelpěl. (To ovšem neznamená, že Boží zákony neuznávám; váže mě přece zákon Kristův.) ");
INSERT INTO ceslb_vpl VALUES ("C19_22","076_9_22","1CO","9","22","23","Mojí snahou bylo přiblížit se ke všem na jejich vlastní úrovni, abych alespoň některé zachránil. A mou odměnou za to všechno je, že smím mít podíl na užitku, který jim mé poselství přináší. ");
INSERT INTO ceslb_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","A teď se podívejte na sportovce: v závodě může zvítězit jen jeden, i když o to samozřejmě usilují všichni. Snažte se tedy, abyste to byli vy, kdo zvítězí! ");
INSERT INTO ceslb_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","To ovšem vyžaduje – jako od každého špičkového sportovce – tvrdý trénink a odříkání! Ale jsou-li toho schopni sportovci, kterým jde jen o pozemské vavříny, musíme to brát tím vážněji my, když v našem případě jde o věčnost. ");
INSERT INTO ceslb_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","I váš a můj život je závod a zápas, a to nikoliv pro pouhou zábavu. ");
INSERT INTO ceslb_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Proto držím své tělo pěkně zkrátka a trénuji ho v ukázněnosti, aby se snad nestalo, že bych kázal druhým a sám v boji podlehl. ");
INSERT INTO ceslb_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Jenom si, bratři, připomeňme židovské dějiny! Boží oblak se rozprostíral nad všemi našimi předky, když odcházeli z Egypta, ");
INSERT INTO ceslb_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","a všichni společně s Mojžíšem prošli mořem, v němž pohřbili svoji otrockou minulost. ");
INSERT INTO ceslb_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Všem bylo duchovní potravou stejné slovo od Boha ");
INSERT INTO ceslb_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","a sílu čerpali všichni z téhož duchovního pramene, který je stále doprovázel – a to byl Kristus. ");
INSERT INTO ceslb_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","A přesto se většina z nich svým jednáním Bohu znelíbila a našla svůj hrob na poušti. ");
INSERT INTO ceslb_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Nechť se nám stanou výstražným příladem. ");
INSERT INTO ceslb_vpl VALUES ("C110_7","076_10_7","1CO","10","7","8","Opusťte své modly, pohlavní nepřístojnosti a jiné neřády, abyste nedopadli jako oni: za jediný den jich pomřelo třiadvacet tisíc. ");
INSERT INTO ceslb_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Nesvádějte lidské špatnosti na Boha, ");
INSERT INTO ceslb_vpl VALUES ("C110_10","076_10_10","1CO","10","10","11","neprovokujte ho, jako to dělali někteří z nich; a přivolali na sebe jedovaté hady a smrt. Vezměme si z toho ponaučení, mnoho času nám už nezbývá. ");
INSERT INTO ceslb_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Mějte se na pozoru – nejblíže pádu je ten, kdo si je sám sebou příliš jist. ");
INSERT INTO ceslb_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Až dosud vás nepotkalo nic, co by člověk nedokázal unést. Bůh vaši víru nezklame ani v dalších zkouškách: pokud je dopustí, dá vám i sílu vydržet a překonat je. ");
INSERT INTO ceslb_vpl VALUES ("C110_14","076_10_14","1CO","10","14","16","Proto, moji drazí, co nejdál od modloslužby! Mluvím s vámi jako s rozumnými lidmi. Řekněte sami: neznamená snad kalich, který si vzájemně podáváme, že nás spojuje Kristova krev? A co jiného vyznáváme při lámání chleba než to, že jsme součástí Kristovou? ");
INSERT INTO ceslb_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Jako všechny ty kousky pocházejí z jednoho chleba, tak i my – ať je nás sebevíc – jsme tím jedním chlebem navzájem spojeni. ");
INSERT INTO ceslb_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Podívejte se na rodilé židy: tím, že jedí maso obětované na oltáři, hlásí se i oni k Bohu, kterému ten oltář patří. A stejný význam má pro pohany zase jejich pohanský oltář. ");
INSERT INTO ceslb_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Tím ovšem neříkám, že modla je snad bohem a že maso obětované modle je něco víc než obyčejné maso; samy o sobě ty věci neznamenají nic. ");
INSERT INTO ceslb_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Ale tím obřadem vzývají pohané démony místo Boha, a proto nechci, abyste se něčeho takového zúčastňovali. ");
INSERT INTO ceslb_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Nemůžete se přece současně hlásit k Bohu i ke zlým mocnostem. ");
INSERT INTO ceslb_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Nebo jsme snad tak silní, že si nemusíme nic dělat z Božího hněvu? ");
INSERT INTO ceslb_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Ano, křesťanu je všechno dovoleno, ale ne všechno je prospěšné. Vše je mi dovoleno, ale ne vše slouží k dobru také ostatním. ");
INSERT INTO ceslb_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Nesmíme si hledět jen svého vlastního zájmu, nýbrž především musíme dbát toho, co je dobré pro druhé. ");
INSERT INTO ceslb_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Tedy: co se prodává v obchodech, to jezte klidně a nelamte si hlavu původem jídla. ");
INSERT INTO ceslb_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Země i se vším, co je na ní, patří přece Bohu. ");
INSERT INTO ceslb_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Také na návštěvách jezte s klidným svědomím všechno, co vám hostitel předloží. ");
INSERT INTO ceslb_vpl VALUES ("C110_28","076_10_28","1CO","10","28","29","Když vás však někdo upozorní, že to či ono jídlo leželo předtím na pohanském oltáři, nejezte to, abyste se nešetrně nedotkli jeho svědomí. Jakže – moje svoboda má být omezována cizím svědomím? ");
INSERT INTO ceslb_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Což mě může někdo odsuzovat za to, co vděčně přijímám z Boží ruky? ");
INSERT INTO ceslb_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Milí bratři! Všechno, co děláme – ať už jde o jídlo nebo o pití či cokoliv jiného, všechno má sloužit k Boží oslavě. ");
INSERT INTO ceslb_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Nebuďte tedy kamenem úrazu ani židům, ani nevěrcům, ani křesťanům. ");
INSERT INTO ceslb_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","I já se vždycky snažím vyjít každému vstříc a neohlížím se na sebe, nýbrž na dobro těch druhých, aby jich bylo zachráněno co nejvíc. Tak mě tomu učí Kristus, dělejte to tak i vy. ");
INSERT INTO ceslb_vpl VALUES ("C111_1","076_11_1","1CO","11","1","16","Jinak vás musím pochválit, že na mne nezapomínáte a držíte se toho, co jsem vás naučil. Nelíbí se mi však móda, jakou u vás některé ženy začínají pěstovat: když ve veřejných shromážděních vzývají Boha nebo o něm hovoří, nezahalují si hlavu. Vždyť je to stejný projev neúcty, jako když muž si nechá ve společnosti na hlavě pokrývku. Platí-li v důstojnosti pořadí Bůh – Kristus – muž – žena, pak si má žena hlavu zahalovat, jako si ji zahalují andělé před Bohem. Muž to nedělá proto, že má nezakrytě zrcadlit Boží slávu, a žena to má dělat proto, že tím uznává vyšší autoritu muže. Takový je aspoň všeobecný zvyk. Jinak jsou si ovšem obě pohlaví rovna v tom, že jako žena pochází z muže, tak se muž zase rodí z ženy; oba stejně vděčí za svůj život Bohu. ");
INSERT INTO ceslb_vpl VALUES ("C111_17","076_11_17","1CO","11","17","21","Když už jsem v tom napomínání, ještě jedna věc mě rmoutí. Vidím, že vaše shromáždění začínají být spíš ke škodě než k užitku. Slyšel jsem – a něco pravdy na tom zřejmě je, že do vašich shromáždění pronikají různice. Na tom je dobré snad jedině to, že se aspoň jasně odliší zdravé od nezdravého mezi vámi. Výsledkem však je, že se ani nedá společně zasednout ke stolu Páně, protože každý honem spěchá sníst to, co si přinesl, a pak už často nemůže pozřít sousto s těmi, kdo přišli hladoví. ");
INSERT INTO ceslb_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Copak se nemůžete najíst už doma? Nebo se snad chcete vychloubat svou kuchyní před méně zámožnými bratry a zlehčovat tak Boží církev? Za to tedy ode mne pochvalu nečekejte. ");
INSERT INTO ceslb_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Učil jsem vás přece, co mi Kristus svěřil: v tu noc, kdy byl zrazen, ");
INSERT INTO ceslb_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","vzal chléb, poděkoval za něj Bohu, rozlámal ho a řekl: „Toto je moje tělo, které se za vás obětuje. Čiňte to na mou památku.“ ");
INSERT INTO ceslb_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Po večeři pak pozvedl kalich se slovy: „Hle, nová smlouva, kterou zpečetím svou krví. Ten kalich vám ji připomene, kdykoliv z něho budete pít.“ ");
INSERT INTO ceslb_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Jedením toho chleba a společným pitím z kalicha tedy hlásáte Kristovu smrt až do jeho příchodu. ");
INSERT INTO ceslb_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","To ovšem znamená, že kdo bere ten chléb nebo to víno na lehkou váhu, znevažuje tím Kristovu smrt. ");
INSERT INTO ceslb_vpl VALUES ("C111_28","076_11_28","1CO","11","28","29","Ať tedy každý nejdřív sám sebe zkoumá, než sáhne po chlebu a kalicha. Jinak na sebe přivolává odsouzení, protože pohrdá Kristovou obětí. ");
INSERT INTO ceslb_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Proto je vás tolik nemocných, slabých a umírajících. ");
INSERT INTO ceslb_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Nemuselo by to být, kdybychom byli sami na sebe přísnější. ");
INSERT INTO ceslb_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Takto nás však musí trestat Pán, aby nás pak nemusel odsoudit s ostatním světem. ");
INSERT INTO ceslb_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Proto vás prosím, bratři, abyste při takových setkáních čekali, až se sejdete všichni. ");
INSERT INTO ceslb_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Kdo by nemohl vydržet hladem, ať se nají doma a nepřivolává Boží trest. Ostatní zařídím, až přijdu. ");
INSERT INTO ceslb_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Co se týká projevů Božího Ducha, rád bych, abyste v té věci měli jasno. ");
INSERT INTO ceslb_vpl VALUES ("C112_2","076_12_2","1CO","12","2","3","Sami víte, že modly, které jste nevšedními dary uctívali, byly mrtvé a němé. Teď se však setkáváte s lidmi, kteří o sobě prohlašují, že jejich ústy mluví Bůh. Jak si to můžete ověřit? Spolehlivým vodítkem je vždy toto: kdo pohrdá Kristem, nejedná z pověření Božího Ducha. A naopak: za Pána prohlašuje Krista jen ten, koho k tomu vede Boží Duch. ");
INSERT INTO ceslb_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Je mnoho rozmanitých obdarování, ale Duch je jenom jeden. ");
INSERT INTO ceslb_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Způsoby služby se mohou velice různit, Pán je však stále tentýž. ");
INSERT INTO ceslb_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Duch se projevuje rozmanitě případ od případu, ale vždycky v každém z nás jde o dílo téhož Boha. ");
INSERT INTO ceslb_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Jím obdarovaní jednotlivci mají každý svým způsobem sloužit celé církvi: ");
INSERT INTO ceslb_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","jednomu Boží Duch dává schopnost moudře mluvit, jinému skvěle formulovat nejhlubší myšlenky. ");
INSERT INTO ceslb_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Jednomu dává tentýž Duch víru, která působí zázraky, jinému schopnost uzdravovat ");
INSERT INTO ceslb_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","a jinému zase schopnost velkých činů. Někdo jeho prostřednictvím dovede tlumočit Boží poselství, jiný rozlišovat, z jakého ducha co pochází. A další je obdařen schopností mluvit jinými jazyky a další zase schopností takovou neznámou řeč vyložit srozumitelně. ");
INSERT INTO ceslb_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","To vše je dílo jednoho a téhož Ducha, který každému jednotlivci přiděluje takové obdarování, jaké uzná za dobré. ");
INSERT INTO ceslb_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Křesťanské společenství se dá přirovnat k lidskému tělu, kde je také mnoho údů a orgánů, které tvoří jediný celek. ");
INSERT INTO ceslb_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Tak i každý z nás, ať žid nebo pohan, otrok nebo svobodný občan, byl při křtu začleněn do jednoho společného těla. Způsobil to jeden a týž Duch, kterého nyní společně sdílíme. ");
INSERT INTO ceslb_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Tělo – to přece není jediný orgán, nýbrž mnoho orgánů. ");
INSERT INTO ceslb_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Dejme tomu, že by noha řekla: „Já k tělu nepatřím, protože nejsem ruka.“ Proto však ještě nepřestává patřit k tělu. ");
INSERT INTO ceslb_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Nebo kdyby řeklo ucho: „Já k tělu nepatřím, když nejsem oko,“ přestává snad proto být částí těla? ");
INSERT INTO ceslb_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Kdyby celé tělo bylo okem, jak by mohlo slyšet? A kdyby bylo celé uchem, kde by byl čich? ");
INSERT INTO ceslb_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Bůh však určil každému orgánu zvláštní úlohu v těle, jak sám chtěl. ");
INSERT INTO ceslb_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Kdyby totiž celek byl jediným orgánem, nebylo by tu žádné tělo. ");
INSERT INTO ceslb_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Takto máme mnoho různých orgánů, ale všechny dohromady tvoří jediný organismus. ");
INSERT INTO ceslb_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Oko nemůže říci ruce: „Nepotřebuji tě,“ ani hlava noze: „Obejdu se bez tebe.“ ");
INSERT INTO ceslb_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Spíš naopak: právě ty zdánlivě podřadné orgány jsou nepostradatelné ");
INSERT INTO ceslb_vpl VALUES ("C112_23","076_12_23","1CO","12","23","25","a zrovna těm orgánům, za které se stydíme, věnujeme při oblékání zvláštní péči. Bůh zařídil naše tělo tak, aby se „důstojné“ údy staraly o „nedůstojné“, aby za ně nesly odpovědnost a aby tělo jako celek bylo jednotné. ");
INSERT INTO ceslb_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Když trpí jeden orgán, cítí to i všechny ostatní. Když je jeden z nich obdivován, radují se všechny. ");
INSERT INTO ceslb_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Vy jste nyní Kristovo tělo a každý z vás je údem či orgánem toho těla. ");
INSERT INTO ceslb_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","V našem společenství ustanovil Bůh jedny jako své vyslance, druhé jako proroky, třetí jako učitele, dalším dal moc k podivuhodným činům, některým schopnost uzdravovat, jiným sílu sloužit potřebným nebo spravovat církev či mluvit jazyky. ");
INSERT INTO ceslb_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Jsme snad všichni apoštoly? Jsou všichni proroky, všichni učiteli? Mají všichni moc činit divy, ");
INSERT INTO ceslb_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","uzdravovat, mluvit jazyky a vykládat je? On dává organizační schopnosti k vedení církve, ale umění sloužit v maličkostech je také jeho dar. ");
INSERT INTO ceslb_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Usilujte o ty dary, které jsou jiným nejprospěšnější. ");
INSERT INTO ceslb_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Kdybych ovládal všechny řeči světa a uměl mluvit vznešeně jako sám anděl, ale neměl v sobě lásku, jsou má slova jen prázdnými zvuky jako dunění zvonu nebo řinčení plechu. ");
INSERT INTO ceslb_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","A kdybych se mohl honosit, že mými ústy mluví Bůh a že znám veškerá tajemství, a kdybych měl tak velikou víru, že bych dokázal přenášet hory – jestliže nemám lásku, nejsem nic. ");
INSERT INTO ceslb_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","A kdybych rozdal všechen svůj majetek a nechal se třeba i upálit, a přitom bych to dělal bez lásky, není to k ničemu. ");
INSERT INTO ceslb_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Láska je shovívavá, laskavá, nezná závist. Není chlubivá a domýšlivá, ");
INSERT INTO ceslb_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","nejedná nečestně, nehledá svůj prospěch, nerozčiluje se pro nepochopení ani nevzpomíná na křivdy, ");
INSERT INTO ceslb_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","není škodolibá, ale má zálibu v pravdě. Se vším se dokáže vyrovnat; ");
INSERT INTO ceslb_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","její víra, naděje a vytrvalost jsou nevyčerpatelné. ");
INSERT INTO ceslb_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Láska nemá konce. Proroctví umlknou, jazyky domluví, vědění se rozplyne; ");
INSERT INTO ceslb_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","vždyť všechno naše poznání je kusé a všechna vnuknutí omezená; ");
INSERT INTO ceslb_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","až jejich místo zaujme úplnost a dokonalost, všechno kusé a omezené bude překonáno. ");
INSERT INTO ceslb_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Dokud jsem byl dítě, byl dětský můj rozhled i způsob myšlení. Z dětských bot jsem však vyrostl a spolu s nimi jsem odložil i dětské představy. ");
INSERT INTO ceslb_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","V tomto životě můžeme vidět jenom cosi jako zamžený obraz v zrcadle, ale pak staneme Bohu tváří v tvář. Zatím ho známe jen z nepatrné části; pak ho budeme znát tak úplně, jak on už nyní zná nás. ");
INSERT INTO ceslb_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Tři věci jsou silnější než smrt: víra, naděje a láska. A největší z nich je láska. ");
INSERT INTO ceslb_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Ať je tedy u vás láska na prvním místě. O duchovní dary také usilujte, ale především o schopnost tlumočit Boží slovo. ");
INSERT INTO ceslb_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Když někdo mluví neznámým jazykem, mluví sice k Bohu, ale lidé z toho nic nemají, protože mu nerozumějí. ");
INSERT INTO ceslb_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Jestliže však někdo promluví prorocky, posluchači to pochopí a taková slova jim pomáhají, povzbuzují je a podněcují. ");
INSERT INTO ceslb_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Neznámý jazyk má význam jen pro toho, kdo jím mluví, kdežto srozumitelné poselství buduje křesťanské společenství. ");
INSERT INTO ceslb_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Ne že bych vám nepřál, abyste třeba všichni mluvili cizími jazyky, ale přednost dávám tomu, abyste Boží slovo přinášeli srozumitelně. Vždyť církev má užitek jenom z toho, čemu může každý rozumět. ");
INSERT INTO ceslb_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Řekněte sami: k čemu by vám bylo, kdybych mluvil jazyky pro vás nesrozumitelnými a nevyložil současně, v čem je poučení, co má smysl vzdělávací a co prorocký? ");
INSERT INTO ceslb_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Podívejte se na hudební nástroj – třeba harfu nebo varhany. Kdyby se rozezvučely všemi tóny najednou, kdo by v tom poznal nějakou melodii? ");
INSERT INTO ceslb_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Anebo polnice: když zatroubí nezřetelně, kdo rozezná signál k boji? ");
INSERT INTO ceslb_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Stejně tak vaše řeč: není-li srozumitelná, nikomu nic nedá. Mluvíte do větru. ");
INSERT INTO ceslb_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Na světě se mluví stovkami různých jazyků a kdo je zná, krásně se jimi dorozumí. ");
INSERT INTO ceslb_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Když ale na mne mluví někdo slovy, jejichž význam neznám, zůstaneme si navzájem cizinci. ");
INSERT INTO ceslb_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Vím, že usilujete o duchovní obdarování. Snažte se tedy vyniknout hlavně v tom, co pomáhá budovat církev. ");
INSERT INTO ceslb_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Proto radím tomu, kdo mluví neznámým jazykem: modli se, abys uměl vyložit, co říkáš. ");
INSERT INTO ceslb_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Když totiž někdo hovoří takovým jazykem, modlí se sice jeho duch, ale bez účasti rozumu. ");
INSERT INTO ceslb_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Co s tím? I já se chci modlit vroucně, ale tak, abych se zároveň modlil rozumem. A když zpívám k Boží oslavě, chci ho chválit i svým rozumem. ");
INSERT INTO ceslb_vpl VALUES ("C114_16","076_14_16","1CO","14","16","17","Jak by mohl obyčejný posluchač připojit svůj souhlas k modlitbě, kdyby nerozuměl jejím slovům? I kdyby byla sebeupřímnější, nic z ní nemá. ");
INSERT INTO ceslb_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Jsem vděčný Bohu, že mne tímto darem obdaroval víc, než kohokoliv z vás. ");
INSERT INTO ceslb_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Přesto ve shromáždění povím raději pět srozumitelných vět než tisíce slov nesrozumitelných. ");
INSERT INTO ceslb_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Bratři, nebuďte dětinští. Zlo ať je vám cizí jako nemluvňatům, ale jinak myslete jako dospělí lidé. ");
INSERT INTO ceslb_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Ve starozákonním proroctví říká Bůh: „Pošlu k nim cizince, aby k nim promluvili cizím jazykem, ale ani těm nebudou naslouchat.“ ");
INSERT INTO ceslb_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Ten nesrozumitelný jazyk tedy sotva někoho přivede k víře; a kdo již křesťanem je, potřebuje taky slyšet spíš jasné Boží pravdy. ");
INSERT INTO ceslb_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Představte si, že se sejdete, každý z vás bude mluvit jiným jazykem a teď mezi vás přijde nezasvěcený nebo nevěřící člověk. Neřekne si, že vám nejspíš přeskočilo? ");
INSERT INTO ceslb_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Když ale všichni budete tlumočit Boží pravdu jasnou řečí, pak to, co nahodilý host uslyší, zasáhne jeho svědomí. ");
INSERT INTO ceslb_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Bude usvědčován a jeho nejtajnější myšlenky budou odkrývány, takže padne na kolena a vyzná: Mezi vámi je určitě Bůh! ");
INSERT INTO ceslb_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Jaký závěr z toho udělat? Když se sejdete, jeden poslouží zpěvem, jiný poučením, další poselstvím od Boha a další zase jeho výkladem. Pro všechny tu platí jediné pravidlo: aby to, co dělají, bylo k prospěchu celé obci věřících. ");
INSERT INTO ceslb_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Pokud jde o mluvení cizím jazykem, ať tedy mluví nejvýše dva nebo tři, ale pěkně jeden po druhém a zároveň ať to někdo překládá. ");
INSERT INTO ceslb_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Když se nenajde nikdo, kdo by byl schopen to učinit, ať toho mluvící raději nechá nebo mluví s Bohem potichu, sám pro sebe. ");
INSERT INTO ceslb_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Také ti, kterým se dostálo zvláštního Božího poselství, ať hovoří jen dva nebo tři, ostatní ať o něm uvažují. ");
INSERT INTO ceslb_vpl VALUES ("C114_30","076_14_30","1CO","14","30","31","Jestliže Bůh odhalí něco dalšímu z přítomných, zatímco předchozí ještě mluví, má mu být postoupeno slovo. Tak se dostane na všechny, kdo mají co říci pro pomoc a povzbuzení ostatním. ");
INSERT INTO ceslb_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Pamatujte, že kdo mluví z Božího pověření, umí se také odmlčet a čekat, až na něj zase přijde řada. ");
INSERT INTO ceslb_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Bůh si nelibuje ve zmatku a hluku, ale v řádu a pokoji. ");
INSERT INTO ceslb_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Zatím jsem se nikde nesetkal s tím, aby ženy zasahovaly do průběhu křesťanských shromáždění. Ať to tedy nedělají ani u vás. ");
INSERT INTO ceslb_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Pro ně je vhodnější přijímat usnesení mužů než s nimi diskutovat; konečně jim to ukládá i zákon. ");
INSERT INTO ceslb_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Jestli se jim něco nezdá, ať si to nechají doma vyložit od manžela a nedohadují se na veřejnosti. Někomu se to jistě nebude líbit, ale nemyslete si, že právě vy v Korintu rozumíte všemu nejlíp. Nejste první ani jediní, kdo přijali Krista za svého pána. ");
INSERT INTO ceslb_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","A jestli někdo tam u vás tvrdí, že má zvláštní nadání slyšet Boží hlas a jiné schopnosti z Božího Ducha, měl by tím spíš pochopit, že to, co vám říkám, pochází od Boha. ");
INSERT INTO ceslb_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Kdo to odmítá uznat, ten sám nemá nárok na uznání. ");
INSERT INTO ceslb_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Tak tedy, milí bratři, proste Boha o to, abyste mohli hlásat jeho pravdy. Nebraňte mluvit cizími jazyky, ");
INSERT INTO ceslb_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ale všechno ať má svůj pořádek a kázeň. ");
INSERT INTO ceslb_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Rád bych vám, bratři, připomněl, že i dnes hlásám totéž radostné poselství jako na začátku, jak jste je i vy přijali a na něm založili svou víru. ");
INSERT INTO ceslb_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","V něm je vaše záchrana, pokud se ho pevně držíte v té podobě, jak jsem vám je předal. Stojí-li vaše víra na něčem jiném, není víc než pouhou iluzí. ");
INSERT INTO ceslb_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Učil jsem vás tomu, k čemu jsem byl sám přiveden: že Kristus zemřel za naše viny, ");
INSERT INTO ceslb_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","byl pohřben, ale třetí den vstal z mrtvých, jak to vše Bůh už dávno předtím nechal zapsat do starých Písem. ");
INSERT INTO ceslb_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Pak se ukázal Petrovi, potom všem zbývajícím dvanácti. ");
INSERT INTO ceslb_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Později ho vidělo přes pět set svědků společně; někteří z nich už nežijí, ale většina dosud ano. ");
INSERT INTO ceslb_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Pak ho uviděl Jakub a ostatní apoštolové ");
INSERT INTO ceslb_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","a docela nakonec se ukázal i mně, ač jsem toho nejméně hoden. ");
INSERT INTO ceslb_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Vždyť mezi všemi apoštoly jsem já ten poslední, a to je pro mne ještě přílišná čest po tom, jak jsem pronásledoval církev. ");
INSERT INTO ceslb_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Bůh se však nade mnou slitoval a jen z jeho milosti jsem to, co jsem. A nebylo to nadarmo: vykonal jsem mnohem víc práce než všichni ostatní. Ale co to říkám – ne já, nýbrž Bůh, jehož jsem byl nástrojem. ");
INSERT INTO ceslb_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Ostatně ať už jsem to já nebo někdo jiný, všichni hlásáme totéž poselství, které jste již přijali i vy. ");
INSERT INTO ceslb_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Jestliže však věříte, že Kristus vstal z mrtvých, jak potom mohou někteří z vás tvrdit, že mrtví už nikdy neožijí? ");
INSERT INTO ceslb_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Kdyby měli pravdu, pak by i Kristus musel dosud ležet v hrobě. ");
INSERT INTO ceslb_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","A jestli Kristus zůstal v hrobě, všechno naše mluvení o něm a veškerá vaše důvěra v Boha jsou naprosto zbytečné, bezvýznamné a nesmyslné ");
INSERT INTO ceslb_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","a všichni my, apoštolové, jsme lháři a podvodníci, když o Kristu prohlašujeme, že vstal z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Nevěříte-li v možnost vzkříšení, popíráte i zmrtvýchvstání Kristovo. ");
INSERT INTO ceslb_vpl VALUES ("C115_17","076_15_17","1CO","15","17","18","A jestliže Kristus nevstal z mrtvých, jakou máte naději? Vaše viny zůstaly neodčiněny, stejně jako viny těch, kteří zemřeli před vámi. ");
INSERT INTO ceslb_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Jestliže jsme na Krista vsadili jen pro časný život, neužijeme ani tolik co ateisté. A pak jsme tedy nejubožejší ze všech lidí! ");
INSERT INTO ceslb_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Skutečnost je však taková, že Kristus opravdu vstal, a to je nám zárukou, že ještě další budou po něm následovat. ");
INSERT INTO ceslb_vpl VALUES ("C115_21","076_15_21","1CO","15","21","22","Na počátku dějin člověk svou neposlušností způsobil, že se lidstvo dostalo pod vládu smrti. Kristus, prototyp nového člověka, tuto vládu smrti zase zlomil. My jsme od svých předků zdědili smrt jako nevyhnutelný úděl; kdo však přijme za svůj Kristův život, bude sdílet jeho úděl i ve vzkříšení z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Všechno má svůj pořádek: nejdříve vstal Kristus, při jeho druhém příchodu pak přijdou na řadu ti, kteří k němu patří. ");
INSERT INTO ceslb_vpl VALUES ("C115_24","076_15_24","1CO","15","24","26","Kristův boj o vítězství nad silami zla a smrti zatím stále ještě pokračuje; smrt sice už prohrála, ale ještě není docela zničena. Až Kristus zlomí moc všech svých nepřátel a své království odevzdá Bohu Otci, dějiny se uzavřou. ");
INSERT INTO ceslb_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Bůh totiž svěřil Kristu veškerou moc nad celým vesmírem – samozřejmě s výjimkou sebe sama. ");
INSERT INTO ceslb_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Až tedy Kristus zvítězí nad posledním odpůrcem, tehdy přijde ke svému Otci a složí mu všechnu svou moc k nohám, takže nakonec bude svrchovaným vládcem zase sám Bůh. ");
INSERT INTO ceslb_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Ale ještě zpět ke vzkříšení: Jak zdůvodníte, že někteří z vás v Korintu podstupují zkoušky a utrpení pro svoji víru? Jaký to má smysl, jestliže nebude vzkříšení z mrtvých? ");
INSERT INTO ceslb_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","A proč my stále riskujeme svůj život a denně se díváme smrti v tvář? ");
INSERT INTO ceslb_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Ujišťuji vás při všem, co pro mne znamenáte, že skutečně hledím každý den smrti do tváře. ");
INSERT INTO ceslb_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","K čemu by byl i můj boj na život a na smrt tenkrát v Efezu? Kdyby po smrti nebylo už s čím počítat, mohl bych si to všechno ušetřit a řídit se raději příslovím „dnes užívej života, zítra můžeš být po smrti“. ");
INSERT INTO ceslb_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Takovými názory se však nedejte zmást. Špatná myšlenka je matkou zlého činu. ");
INSERT INTO ceslb_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Uvažujte tedy střízlivě a nezahrávejte si se zlem. Vždyť je to ostuda – někteří z vás se pokládají za křesťany, a přitom nemají ani ponětí o základních věcech víry. ");
INSERT INTO ceslb_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Někdo by se ovšem mohl zeptat: „Jak budou ale vzkříšeni ti mrtví? Jaké pak budou mít tělo?“ ");
INSERT INTO ceslb_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Dětinská otázka! Odpověď roste na tvé vlastní zahrádce. Když semeno zapadne do země, vzejde z něho nová rostlinka – ono samo však tím „zemře“, zanikne. ");
INSERT INTO ceslb_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Co ze semene vyklíčí, ani zdaleka se mu nepodobá: zasel jsi suché zrnko pšenice nebo něčeho jiného, ");
INSERT INTO ceslb_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ale životu skrytému v tom semeni dá Bůh novou, nádhernou podobu, nový tvar, jaký sám určil. Z jednoho semene vyroste to, z jiného ono. ");
INSERT INTO ceslb_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","A zrovna tak, jako jsou různé druhy semen a rostlin, liší se navzájem těla živočichů: člověk, zvíře, ryba, pták – co druh, to jiné tělo. ");
INSERT INTO ceslb_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","A od pozemských bytostí a tvarů liší se zase nebeská tělesa na obloze krásou docela jiného druhu – a dokonce i mezi nimi vidíme rozmanitost: ");
INSERT INTO ceslb_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","jinak svítí slunce, jinak měsíc a jinak zase hvězdy, a z nich každá má svůj osobitý třpyt. ");
INSERT INTO ceslb_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Tak nějak si můžeme představovat i vzkříšení z mrtvých. Tělo, které obdržíme při vzkříšení, bude jiné než to naše dosavadní; toto zemře, tamto bude žít věčně. ");
INSERT INTO ceslb_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","To, které se pohřbívá, podléhá rozkladu a budí odpor. To, které vstane, bude se skvít nadzemskou slávou. ");
INSERT INTO ceslb_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","To nynější je slabé, to budoucí bude plné sil. Z umírajícího těla odchází život biologický, přírodní, vzkříšené tělo bude oživeno Duchem Božím. Jako biologický život musí mít svou hmotnou schránku, tak i život duchovní obdrží své tělesné sídlo. ");
INSERT INTO ceslb_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Mojžíš nás učí, že Adam, první člověk, se stal živou bytostí; Kristus je však víc než to – je duchem života. ");
INSERT INTO ceslb_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Nejdříve máme tedy lidské, živočišné tělo, teprve později nám Bůh dá nové, „duchovní“ tělo. ");
INSERT INTO ceslb_vpl VALUES ("C115_47","076_15_47","1CO","15","47","49","Adam byl stvořen pouze z pozemského materiálu, zato Kristus přišel z říše, která převyšuje vše hmotné. Pozemský člověk je téhož druhu, jako byl Adam, vzkříšený bude bytostí podobnou Kristovi. ");
INSERT INTO ceslb_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Zdůrazňuji vám, milí bratři: naše pozemské tělo z masa a kostí není způsobilé pro Boží říši, protože naše kvality nejsou ani zdaleka takové, aby si zasloužily nesmrtelnost. ");
INSERT INTO ceslb_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Prozradím vám jedno nádherné tajemství: zemřeme jen někteří, ale všichni obdržíme nové tělo. ");
INSERT INTO ceslb_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Až z nebe zazní signál posledního soudu, v jediném okamžiku se naše tělo promění. ");
INSERT INTO ceslb_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Zesnulí křesťané vstanou v novém, nesmrtelném těle a my ostatní, pokud budeme ještě naživu, všichni najednou dostaneme zrovna takové tělo, skvělé a nezničitelné. ");
INSERT INTO ceslb_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Tak se konečně stane skutečností dávné prorokovo vidění: Vítězství je dovršeno, smrt slavně navždy zničena! ");
INSERT INTO ceslb_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","Kam ses poděla, ó smrti, a kam zmizel tvůj náhončí? ");
INSERT INTO ceslb_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Náhončím smrti je míněn hřích – a ten má svou sílu ze zákona. ");
INSERT INTO ceslb_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Bůh nám však prostřednictvím Ježíše Krista umožnil nad obojím zvítězit a za to mu nikdy nemůžeme být dost vděčni. ");
INSERT INTO ceslb_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Vítězství je naše, bratři, zůstaňte pevní a nenechte se zviklat v usilovné spolupráci na Božím díle. Můžete si být jisti, že nic z toho, co jste vykonali pro Pána, se vaší smrtí neztratí. ");
INSERT INTO ceslb_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Teď ještě několik slov ke sbírce pro jeruzalémské křesťany. Doporučili vám stejný postup, jaký jsem zavedl v Galacii. ");
INSERT INTO ceslb_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Vždycky v neděli si doma dejte stranou ze svého týdenního příjmu tolik, kolik můžete postrádat. Nečekejte s tím až na můj příchod, po částkách se šetří lépe než najednou. ");
INSERT INTO ceslb_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Až pak přijdu, napíšu k vašemu daru průvodní dopis a spolehliví poslové, které sami určíte, vezmou peníze s listem do Jeruzaléma. ");
INSERT INTO ceslb_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Bude-li třeba, připojím se k nim i já. ");
INSERT INTO ceslb_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Mám v úmyslu cestovat k vám přes Makedonii, kde bych se krátce zastavil v některých křesťanských obcích. ");
INSERT INTO ceslb_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","U vás bych se rád zdržel trochu déle, možná přes celou zimu, než se zase vypravím dál. ");
INSERT INTO ceslb_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Korintem jen tak projít a s vámi se jen tak letmo uvidět, zdálo se mi příliš málo, a tak doufám, že mi Pán dovolí trochu déle mezi vámi pobýt. ");
INSERT INTO ceslb_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Tady v Efezu zůstanu pravděpodobně až do Letnic, ");
INSERT INTO ceslb_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","otevírají se zde slibné možnosti dalšího působení – i když o nepřátele taky ovšem není nouze. ");
INSERT INTO ceslb_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Až k vám přijde Timoteus, ať se u vás cítí jako mezi svými, vždyť pracuje pro Pána stejně jako já. ");
INSERT INTO ceslb_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Je sice ještě mladý, to je pravda, ale proto si nezaslouží nějaké přezírání. Přijměte ho dobře a pomozte mu s přípravou na zpáteční cestu, budu ho čekat a těšit se i na všechny, kteří přijdou s ním. ");
INSERT INTO ceslb_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Apolla jsem dlouho přemlouval a prosil, aby se k vám vydal spolu s ostatními, ale tentokrát cítil svou povinnost jinde. Vydá se k vám hned, jakmile bude zase volný. ");
INSERT INTO ceslb_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Buďte připraveni na všechno, stůjte věrně při svém Pánu, jednejte jako muži, buďte silní. ");
INSERT INTO ceslb_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Z každého vašeho činu ať vyzařuje láska! ");
INSERT INTO ceslb_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Mám k vám jednu prosbu. Pamatujete se jistě, že Štefan a jeho rodina byli první v Řecku, kdo se stali křesťany a svůj život zasvětili spolubratřím. ");
INSERT INTO ceslb_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Mějte tedy pro ně uznání stejně jako pro všechny, kdo svůj čas a síly věnovali naší společné práci. ");
INSERT INTO ceslb_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Jsem velmi rád, že Štefan, Fortunát a Achaikos přišli, aby mi svou přítomností vynahradili naše odloučení. ");
INSERT INTO ceslb_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Moc mě tím povzbudili, jako jistě i vás. Takových lidí je třeba si vážit. ");
INSERT INTO ceslb_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Asijské křesťanské obce vás všechny srdečně pozdravují. Pozdrav vám vzkazují také Akvila s Priscilou a všichni, kdo se u nich scházívají. ");
INSERT INTO ceslb_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Od všech zde mám vyřídit upřímné pozdravy. Obejměte se navzájem v křesťanské lásce. ");
INSERT INTO ceslb_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Na konec připojuji vlastnoručně i svůj pozdrav. ");
INSERT INTO ceslb_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Náš Pán se vrátí brzy! Kdo jím pohrdá, toho stihne trest. ");
INSERT INTO ceslb_vpl VALUES ("C116_23","076_16_23","1CO","16","23","24","Modlím se, aby vás i nadále provázela milost Ježíše Krista. V jeho lásce, která nás spojuje. Váš Pavel");
INSERT INTO ceslb_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Drazí bratři, tento dopis vám píši jako Bohem zmocněný posel Ježíše Krista, společně s Timotejem. Adresovaný je sice k vám do Korintu, ale je určen všem křesťanům v celém Řecku: ");
INSERT INTO ceslb_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","kéž vás náš Otec Bůh i Ježíš Kristus bohatě obdarují svou milostí a pokojem. ");
INSERT INTO ceslb_vpl VALUES ("C21_3","077_1_3","2CO","1","3","4","Jak nevýslovně dobrý je náš Bůh. V něm, Otci našeho Pána Ježíše Krista, máme nevyčerpatelný zdroj útěchy a posily pro naše zkoušky a utrpení, takže i jiné pak můžeme těšit a posilovat, když je to zapotřebí. ");
INSERT INTO ceslb_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Stejnou pomoc, jakou jsme obdrželi od Boha, rozdáváme všude kolem sebe. ");
INSERT INTO ceslb_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Můžete se spolehnout, že čím víc utrpení podstoupíme pro Krista, tím hojněji nás zahrne svou útěchou a povzbuzením. Kristovo utrpení je mým denním chlebem, ale to je můj příspěvek k vaší záchraně. ");
INSERT INTO ceslb_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","On mi však denně dává též novou sílu a klid – a to má být zase posilou vám ve vašich zkouškách. Pokud s námi sdílíte naše bolesti, nemám o vás obavy: zdroj naší útěchy je otevřen i pro vás. ");
INSERT INTO ceslb_vpl VALUES ("C21_8","077_1_8","2CO","1","8","9","Nebudu vám, drazí, tajit, že tady v Malé Asii jsme prožili snad nejhorší chvíle svého života. Vypadalo to už, že je s námi konec, připravovali jsme se na smrt. Cítím, že to muselo dojít tak daleko proto, abychom nespoléhali již na nic jiného než na Boha, který má moc vzkřísit i mrtvé. ");
INSERT INTO ceslb_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Skutečně nás vyrval přímo z drápů smrti a věřím, že ne naposledy. ");
INSERT INTO ceslb_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","Přesto prosím, abyste na nás stále mysleli ve svých modlitbách – tím větší budou pak vaše chvály a vděčnost za jejich vyslyšení. ");
INSERT INTO ceslb_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","S naprosto čistým svědomím mohu prohlásit, že jsem s vámi ve všech směrech jednal vždy jen a jen upřímně, jak mě Bůh vedl, a na to jsem hrdý. Ne lidská vypočítavost, ale Boží milost je mi vůdčí silou. To platilo vždy i ve vztahu k vám. ");
INSERT INTO ceslb_vpl VALUES ("C21_13","077_1_13","2CO","1","13","14","Všechno, co čtete v mých listech, je míněno naprosto upřímně. Doufám, že to tak přijmete, i když se dosud mnoho neznáme, a že při Kristově návratu se za sebe navzájem nebudeme muset stydět, ale naopak budeme mít důvod k hrdosti. ");
INSERT INTO ceslb_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","V této důvěře jsem vás chtěl navštívit už na cestě do Makedonie a pak se vrátit do Judska zase přes Korint. ");
INSERT INTO ceslb_vpl VALUES ("C21_16","077_1_16","2CO","1","16","20","Proč jsem svůj plán později změnil? Nebylo to z vrtkavosti ani z lehkomyslnosti. Když jednou něco řeknu, pak to také tak myslím; nikdy neříkám „ano“, když myslím „ne“, a naopak. Boží Syn Ježíš Kristus, jak jsme vám ho přiblížili se Silvánem a Timotejem, také nebyl muž dvojí tváře. Jeho osoba je hmatatelným ANO všem slibům, které Bůh kdy dal člověku. Proto taky, když k modlitbě připojíme Amen (tj. „ano“), připomínáme si vlastně, že v Kristu na ně Bůh už odpověděl, a oslavujeme ho za to. ");
INSERT INTO ceslb_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Že jste v Kristu obdrželi tentýž nový život jako my, že v něm dosud pevně stojíme – to je jen Boží dílo. ");
INSERT INTO ceslb_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","To on nás učinil svým vlastnictvím, pověřil svým poselstvím a vtiskl nám svou vlastnickou pečeť – svatého Ducha – jako záruku na vše ostatní, co má ještě pro nás přichystáno. ");
INSERT INTO ceslb_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","Pán Bůh ví, že to nebylo jinak, než vám tady píšu: Korint jsem nakonec rozhodl vynechat jen proto, abych vás ušetřil setkání, které by pro vás mohlo být velice trapné. ");
INSERT INTO ceslb_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Ne že bych vám chtěl vytýkat nedostatky ve vaší víře – v té si stojíte docela dobře. ");
INSERT INTO ceslb_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Přál jsem si však, aby vám můj příjezd přinesl jen radost a ne rozpaky jako posledně. ");
INSERT INTO ceslb_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Kdyby vás měla moje návštěva opět zarmoutit, nemohl bych z našeho setkání mít ani já žádnou radost. ");
INSERT INTO ceslb_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","V tomto smyslu jsem vám také posledně psal, abyste dali všechno do pořádku dřív, než zase přijedu, aby naše shledání nebylo už ničím kaleno. Pevně věřím, že mne nezklamete – vždyť vím, že ani vás by netěšilo, kdybych k vám měl přijet sklíčen a nerad. ");
INSERT INTO ceslb_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Věřte mi, že ani mně nepůsobilo žádné potěšení psát vám takový dopis. Dělal jsem to s velmi těžkým srdcem – a proč to nepřiznat, dokonce jsem přitom plakal. Nechtěl jsem vás ranit, právě naopak, chtěl jsem vám ukázat, jak vroucně vás mám rád a jak mi na vás záleží. ");
INSERT INTO ceslb_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Jestliže mi dal někdo příčinu k zármutku, neublížil ani tolik mně samotnému, jako v jistém smyslu všem vám. ");
INSERT INTO ceslb_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Myslím, že už je potrestán víc než dost; ");
INSERT INTO ceslb_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","teď mu zase ukažte ochotu odpustit a povzbuďte ho, aby nezahořkl a nepropadl beznaději. ");
INSERT INTO ceslb_vpl VALUES ("C22_8","077_2_8","2CO","2","8","11","Přijměte ho zase s láskou mezi sebe. Můj dopis měl, abych tak řekl, vyzkoušet, jakou mám autoritu. Komu však odpustíte vy, tomu odpouštím i já. Osobně tu věc mám už za vyřízenou, ale chcete-li to výslovně slyšet, tedy ano, odpouštím mu podle Kristova příkazu. Mějme se na pozoru, abychom setrváváním v hněvu nespolkli satanovo vnadidlo – však víme dobře, o co mu jde. ");
INSERT INTO ceslb_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Když jsem dorazil do Troady, našel jsem tam pro své poselství o Kristu velice dychtivé posluchače. ");
INSERT INTO ceslb_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Znepokojilo mne však, že jsem se tam nesetkal s Titem, svým milým spolupracovníkem. Neměl jsem stání, musel jsem se s Troadskými rozloučit a pokračovat dál do Makedonie, abych zjistil, co s ním je. ");
INSERT INTO ceslb_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Nemohu si pomoci, znovu musím děkovat Bohu, že se na nás prokazuje jeho vítězná moc a že poznání Boha můžeme šířit okolo sebe jako vzácnou vůni. ");
INSERT INTO ceslb_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","My jsme – obrazně řečeno – kadidlem, které Kristus zapaluje Bohu a jehož vůně se rozlévá mezi všechny lidi, ať patří do tábora Božího, nebo do tábora Bohu nepřátelského. ");
INSERT INTO ceslb_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","S ní vdechují jedni život a druzí smrt. Ale kdo je k tomu způsobilý? ");
INSERT INTO ceslb_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","My nejsme jako kramáři, kteří si z církevní funkce udělali výnosné řemeslo. Naší ctí je vyřizovat nezištně to, co nám bylo Bohem uloženo jako Kristovým služebníkům, s vědomím, že on nás stále vidí. ");
INSERT INTO ceslb_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Že se zase stále oháníme svou důvěryhodností? Máme snad zapotřebí o vaši důvěru se teprve ucházet, či si na ni od vás objednávat vysvědčení? ");
INSERT INTO ceslb_vpl VALUES ("C23_2","077_3_2","2CO","3","2","3","Naším nejlepším vysvědčením jste přece vy sami! Inkoust a papír mohou lhát, ale jak změnil Kristus vaše životy, to může každý vidět na vlastní oči. Vy jste Kristův dopis, který jsem psal ne perem, ale Božím Duchem; ne na papír, ale na živá lidská srdce. ");
INSERT INTO ceslb_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Neužíval bych sám o sobě tak velkých slov, kdybych si nebyl jist, že to všechno působí sám Bůh prostřednictvím Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Ponecháni jen svým vlastním schopnostem nedokázali bychom vůbec nic. Má-li naše práce přece nějaké výsledky, je to působením Boží moci. ");
INSERT INTO ceslb_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Bůh nás učinil hlasateli nové smlouvy, kterou s člověkem uzavírá pro jeho záchranu. Tato smlouva není založena na liteře, ale na Duchu. Litera zabíjí, ale Duch dává život. ");
INSERT INTO ceslb_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Když Mojžíš předával izraelskému národu Boží zákony vytesané do kamenných desek, zářil odlesk Boží slávy na jeho tváři tak silně, že oči všech přítomných byly oslněny; a to šlo o zákony, které za neposlušnost přisuzovaly smrt. ");
INSERT INTO ceslb_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","Oč slavnější je smlouva, v níž Bůh nyní daruje člověku nový život prostřednictvím svého Ducha. ");
INSERT INTO ceslb_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Jestliže vyhlášení zákonů, které odsuzovaly, bylo provázeno takovým leskem, kolik slávy teprve musí být spojeno s tímto darem života? ");
INSERT INTO ceslb_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Proti tomu ani Mojžíšova svatozář není vůbec nic! ");
INSERT INTO ceslb_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Když už to, co bylo jen pomíjející, tak oslňovalo, oč velkolepější bude teprve to trvalé. ");
INSERT INTO ceslb_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Protože víme, že tato Boží sláva nepodléhá zubu času, můžeme vystupovat s jistotou a otevřeností. ");
INSERT INTO ceslb_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Mojžíš si před lidmi zahaloval obličej, aby si nevšimli, jak jeho záře postupně vybledává; toho se my bát nemusíme. Mojžíšův národ byl však postižen ještě jinou slepotou: ");
INSERT INTO ceslb_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","dodnes, kdykoliv se v synagogách čte Starý zákon, zůstává mu jeho pravý smysl zahalen. Lidé nepochopí pravý smysl Starého zákona, dokud jim ho neodhalí Kristus. ");
INSERT INTO ceslb_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","A tak jsou dosud přesvědčeni, že jen podle Mojžíšova návodu získají věčný život. ");
INSERT INTO ceslb_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Kdo se však ze své duchovní bídy obrátí k Pánu, tomu se otevřou oči. ");
INSERT INTO ceslb_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Pán je Duch, a kde je Duch Páně, tam člověk již není otrokem zákona. ");
INSERT INTO ceslb_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","V naší nezakryté tváři se odráží Boží sláva jako v zrcadle; sami se tak postupně stáváme jeho obrazem čím dál věrnějším a krásnějším, jak nás jeho Duch mění a přetváří. ");
INSERT INTO ceslb_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Sám Bůh mi z milosti svěřil úkol, proto neklesám na mysli. ");
INSERT INTO ceslb_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Své posluchače nezískáváme pro křesťanství nějakými lacinými triky ani překrucováním Božího slova. Mluvíme čistou pravdu, a proto nás rád přijme každý, kdo zpytuje své svědomí před Bohem. ");
INSERT INTO ceslb_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Zůstává-li naše poselství někomu nesrozumitelné, pak jen těm, kdo směřují k záhubě. ");
INSERT INTO ceslb_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Zlo, které je ovládá, je natolik zaslepilo, že světlo Božího slova k nim nepronikne a oni nejsou schopni pochopit kázání o slávě Ježíše Krista, v němž se Bůh viditelně ztělesnil. ");
INSERT INTO ceslb_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Účelem našich kázání není přitahovat pozornost k našim osobám, ale k Ježíši Kristu jako Pánu. My jsme jen služebníci, kteří vám slouží na jeho příkaz. ");
INSERT INTO ceslb_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Vždyť tentýž Bůh, který řekl: „Budiž světlo uprostřed tmy“, rozzářil své světlo i v nás, aby lidé viděli božskou krásu vyzařující z Ježíše Krista. ");
INSERT INTO ceslb_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","My jsme jen křehké nádoby, do nichž Bůh nádherný poklad vložil. Každý hned musí poznat, že ta zvláštní moc nepochází z člověka, nýbrž z Boha. ");
INSERT INTO ceslb_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Ačkoliv se na nás útočí ze všech stran, přece nepodléháme. Někdy jsme bezradní a nevíme jak dál, ale nevzdáváme se. ");
INSERT INTO ceslb_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Býváme štváni jako divoká zvěř, ale cítíme, že Bůh je při nás. Sráženi k zemi, přece znovu vstáváme a jdeme dál. ");
INSERT INTO ceslb_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Utrpení a smrt se nám nevyhýbají, jako se nevyhnuly Kristovi. ");
INSERT INTO ceslb_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Dnes a denně nám hrozí mučednická smrt kvůli Ježíšovu jménu, ale právě v takové situaci se na nás nejzřetelněji projevuje Ježíšův život. ");
INSERT INTO ceslb_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Naším údělem je umírat, abyste vy žili. ");
INSERT INTO ceslb_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Pisatel jednoho ze žalmů říká: „Mluvím, protože důvěřuji Boží moci.“ Totéž mohu říci o sobě i já. Protože jsem poznal Boží moc, nedám se ničím odradit od hlásání Božího poselství. ");
INSERT INTO ceslb_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","Bůh vzkřísil z mrtvých Ježíše a já nepochybuji, že vzkřísí i mne a že se s vámi u něho shledám. ");
INSERT INTO ceslb_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Vždyť to všechno konám jen kvůli vám. Čím více vás bude získáno pro Krista; tím více hlasů bude pak Boha oslavovat. ");
INSERT INTO ceslb_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Proto není důvod k malomyslnosti. Náš přirozený život směřuje ke konci, ale život, který nám dává Bůh, se každým dnem obnovuje. ");
INSERT INTO ceslb_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Co musíme dnes podstupovat, to je konec konců stále ještě snesitelné a brzy to přejde. Zato radost, která nás očekává, překonává všechnu lidskou představivost a navíc je věčná, je bez konce. ");
INSERT INTO ceslb_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","Naše budoucnost nestojí na tom, co lze vidět a hmatat, protože všechno hmotné je pomíjivé. My stavíme na základech neviditelných, neboť jen ty jsou trvalé. ");
INSERT INTO ceslb_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Víme přece, že až zemřeme, ožijeme znovu v lepší a konečné podobě. ");
INSERT INTO ceslb_vpl VALUES ("C25_2","077_5_2","2CO","5","2","9","Toužíme po tom a zároveň kolísáme, protože bychom se rádi vyhnuli umírání a vstoupili přímo do nesmrtelného života, k němuž nás Bůh už nyní připravuje: jako záruku nám dal svého Ducha. Proto se můžeme důvěřivě těšit na náš nebeský domov; ve svých tělech tu vlastně žijeme v cizině, daleko od své vlasti, kde nás očekává Kristus. Nevidíme ho, ale jsme s ním spojeni vírou. Proto s plnou důvěrou a rád opustím třeba hned toto tělo, abych získal domov u svého Pána. V každém případě však chci dělat to, co se líbí jemu, ať už to znamená setrvat zde v cizině, nebo se vydat do své vlasti. Na ničem jiném totiž nezáleží. ");
INSERT INTO ceslb_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Tak jako tak se nakonec všichni musíme postavit před Kristův soud, kde bude každý náš čin, dobrý i zlý, spravedlivě ohodnocen. ");
INSERT INTO ceslb_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","Je to právě tahle bázeň před Bohem, která mě nutí vést lidi k víře. Bůh moje pohnutky zná a věřím, že ani vy mne nepodezíráte z něčeho postranního. ");
INSERT INTO ceslb_vpl VALUES ("C25_12","077_5_12","2CO","5","12","13","Ne, nechci znovu sebe vychvalovat. Chci vám jen ukázat, že se za mne nemusíte stydět, a tak můžete zavřít ústa těm, kdo si zakládají na vnějším projevu místo na vnitřní hodnotě. Poslouží-li to k Boží slávě, ať si mě lidé mají třeba za blázna. Jsem-li však při dobrých smyslech, poslouží to zase vám. ");
INSERT INTO ceslb_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Kristova láska nás zajala. Je přece zřejmé, že smrt toho, kdo zemřel za všechny, se rovná tomu, jako kdyby zemřeli všichni, ");
INSERT INTO ceslb_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","takže naše životy nepatří už nám, ale tomu, kdo za nás zemřel a vstal z mrtvých. ");
INSERT INTO ceslb_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Není tedy správné posuzovat někoho podle toho, co o něm soudí svět nebo jaký se navenek jeví. Takto chybně jsem se kdysi i já díval na Krista a posuzoval jej jako každého jiného člověka. Jak jsem se mýlil! ");
INSERT INTO ceslb_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Kdo se stane křesťanem, stává se úplně jiným člověkem. Už nikdy není takovým, jakým byl předtím. Začal docela nový život! ");
INSERT INTO ceslb_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","To je změna, kterou působí sám Bůh. Ačkoliv jsme se nacházeli v nepřátelském táboře, ");
INSERT INTO ceslb_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Bůh s námi prostřednictvím Ježíše Krista uzavřel mír a pak nás pověřil, abychom jeho jménem předložili nabídku smíření všem lidem na této planetě. ");
INSERT INTO ceslb_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Z Kristova pověření – jako jeho velvyslanci – tedy provoláváme, aby to všichni slyšeli: Pojďte a přijměte přátelskou ruku, kterou vám Bůh v Kristu podává! ");
INSERT INTO ceslb_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Na toho, který se nikdy nedopustil ničeho špatného, přenesl Bůh všechnu naši špatnost a jeho spravedlnost přenesl na nás. ");
INSERT INTO ceslb_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Jakožto Boží spolupracovník vás snažně prosím: nepromarněte tu milost, které se vám od Boha dostalo! ");
INSERT INTO ceslb_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Bůh říká: „V čas milosti jsem vyslyšel tvou modlitbu, v den záchrany jsem ti pomohl.“ Ten čas je tu právě teď – nezmeškejte ho! Den záchrany je dnes – nezaspěte ho! ");
INSERT INTO ceslb_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Nikomu nechci svým jednáním zavdat příčinu k urážce, aby nevznikly nějaké pochybnosti o mém poslání. ");
INSERT INTO ceslb_vpl VALUES ("C26_4","077_6_4","2CO","6","4","5","Z celého mého způsobu života má každý poznat, že stojím ve službách Božích. Proto si nestěžuji na starosti, nouzi nebo potíže, bezesné noci, dřinu a hlad, útoky nepřátel, bití a vězení. Jako Boží spolupracovník to všechno snáším bez reptání. ");
INSERT INTO ceslb_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","Mou legitimací je bezúhonný život, trpělivost a přívětivost za všech okolností a pravdivé poznání. Všechny tyto schopnosti mi dává Duch Boží, k tomu upřímnou lásku a Boží sílu k hlásání pravdy. ");
INSERT INTO ceslb_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","Mou zbraní pro útok i pro obranu je mi dobré svědomí před Bohem i před lidmi. ");
INSERT INTO ceslb_vpl VALUES ("C26_8","077_6_8","2CO","6","8","10","Stojím při Bohu věrně, ať mě za to oslavují nebo mi nadávají, ať mi věří nebo mě prohlašují za podvodníka. Pro jedny mé jméno nic neznamená, jiní nahlédli až na dno mého srdce. Denně se nade mnou vznáší smrt, ale nikdy jsem nežil plněji. Bili mě, div jsem ducha nevypustil, ale přece mě nezabili. Stále mi házejí klacky pod nohy, o radost mě tím však nepřipraví. Jsem chudý, a přece rozdávám poklady nesmírné ceny. Nemám nic – a přece mi patří celý svět! Moji drazí přátelé, musel jsem vám to napsat tak, jak to cítím. ");
INSERT INTO ceslb_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Nic neskrývám, ani nepřikrašluji. Nikdo vás přece nemá raději než já! ");
INSERT INTO ceslb_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Jestli mezi námi ještě stojí nějaká překážka, není to nedostatek mé lásky k vám, ale vaše výhrady ke mně. ");
INSERT INTO ceslb_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Říkám vám to jako svým vlastním dětem: opětujte moji lásku stejnou měrou! ");
INSERT INTO ceslb_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Nespolčujte se s nevěrci, to pro vás není dobrá společnost. Co může mít společného světlo s tmou, spravedlnost s bezprávím? ");
INSERT INTO ceslb_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Je snad možné nějaké dorozumění mezi Kristem a ďáblem? ");
INSERT INTO ceslb_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Dovedete si představit pohanské bůžky v křesťanském chrámu? A co jiného jsme, ne-li chrám živého Boha? Bůh řekl: „Budu žít uprostřed nich a mezi nimi bydlet, já budu jejich Bohem a oni budou mým lidem.“ ");
INSERT INTO ceslb_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Proto také řekl: „Oddělte se a odejděte od nich, pryč od všeho nečistého. Jen tak vás přijmu za své, ");
INSERT INTO ceslb_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","abych byl vaším Otcem a vy mými syny a dcerami – praví všemocný Bůh.“ ");
INSERT INTO ceslb_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Mějme na paměti, milí přátelé, že tyto sliby platí právě nám. Zřekněme se proto všeho, co špiní tělo nebo duši. Berme vážně Boží slova a usilujeme o to, abychom se Bohu líbili. ");
INSERT INTO ceslb_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Nikomu z vás jsem neukřivdil, nikdo o nic nepřišel mým přičiněním. Proč by měly být na vaší straně ještě nějaké výhrady? ");
INSERT INTO ceslb_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Nechápejte to, prosím vás, jako výčitku, skutečně vás mám rád a na tom se v životě ani ve smrti nic nezmění. ");
INSERT INTO ceslb_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Mám k vám naprostou důvěru a jsem na vás hrdý; myšlenky na vás mě povzbuzují, takže přes všechny trampoty se mám pořád z čeho radovat. ");
INSERT INTO ceslb_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Ani příchod do Makedonie mi nepřinesl úlevu: okolo samý nepřítel, uvnitř neklid a nejistota. ");
INSERT INTO ceslb_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Ale Bůh se ujímá těch, kdo se octli na dně. Když bylo nejhůř, vrátil se Titus a vlil do mne novou sílu ");
INSERT INTO ceslb_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","– nejen svou přítomností, ale hlavně zprávami, které mi od vás přinesl. Vyprávěl mi o vaší lítosti a jak se těšíte na můj příchod a že jste připraveni postavit se plně za mne. To mě nejen docela uklidnilo, ale přímo zaplavilo radostí. ");
INSERT INTO ceslb_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","I když jste mým dopisem byli dotčeni, jsem nakonec přece jen rád, že jsem ho napsal. ");
INSERT INTO ceslb_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Nejdřív jsem toho skoro litoval, ale teď vidím, že jsem udělal dobře, protože jste přece jen změnili stanovisko. ");
INSERT INTO ceslb_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Bůh užil bolesti jako léku k vaší nápravě, takže jsem vám nijak neublížil. Lítost způsobená Bohem vede člověka ke změně postoje a tím i k záchraně, taková lítost je žádoucí. Na druhé straně nespokojenost bez Boha člověka jen ubíjí. ");
INSERT INTO ceslb_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Podívejte se, jak vám tahle hořká pilulka prospěla! Pryč je lhostejnost ke hříchu. Konečně jste se ho ulekli a zošklivili si hoa horlivě spěcháte omluvit se a viníka potrestat. Udělali jste pro nápravu všechno, co jste mohli. ");
INSERT INTO ceslb_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Když jsem tento dopis psal, nešlo mi však ani tolik o viníka či postiženého, jako jsem se chtěl přesvědčit, zda vám na mně ještě záleží. Díky Bohu, nezklamal jsem se. ");
INSERT INTO ceslb_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Ještě víc mě však potěšilo, jakou radost z vás měl Titus. ");
INSERT INTO ceslb_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Ze vší chvály, kterou ode mne na vás slyšel, nemusel jsem nic brát zpátky. Vždycky jsem mluvil jen pravdu, i Titus se teď mohl přesvědčit, že jsem nepřeháněl. ");
INSERT INTO ceslb_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Po tom, s jakou starostlivostí jste ho přijali a jak ochotně jste se zařídili podle mých pokynů, i on si vás oblíbil. ");
INSERT INTO ceslb_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Jsem šťastný, že je mezi námi zase všechno jako dřív a že vám mohu i nadále plně důvěřovat. ");
INSERT INTO ceslb_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Musím vám teď povědět, jak ohromně zapůsobila Boží milost v křesťanských obcích v Makedonii. ");
INSERT INTO ceslb_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Ačkoliv se tam museli potýkat s všelijakými nesnázemi a podstoupit nejednu tvrdou zkoušku, byla radost věřících tak veliká, že při vší své chudobě sebrali mezi sebou neuvěřitelnou částku. ");
INSERT INTO ceslb_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","Nedávali jen to, co jim přebývalo, ale daleko víc. ");
INSERT INTO ceslb_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","Pokládali to za vyznamenání, že se mohli podílet na sbírce pro jeruzalémské křesťany. ");
INSERT INTO ceslb_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Jejich obětavost předstihla všechna moje očekávání – tak úplně se dali k dispozici Bohu a v jeho jménu i nám. ");
INSERT INTO ceslb_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Proto jsem požádal Tita, který u vás začal organizovat sbírku už dříve, aby se k vám znovu vypravil a pomohl vám toto dílo lásky dokončit. ");
INSERT INTO ceslb_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","Není nic, čeho by se vám nedostávalo: víra, účinné slovo, poznání, dobrá vůle i vřelý vztah k nám – ve všem můžete být dáváni za vzor. Doufám, že i váš příspěvek k této službě lásky bude stejně příkladný. ");
INSERT INTO ceslb_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Neberte to jako příkaz. Přál bych si jen, abyste dokázali svou lásku stejně horlivě. ");
INSERT INTO ceslb_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Jistě jste nezapomněli, co pro vás udělal Kristus: sám bohatý, kvůli vám vzal na sebe dobrovolně chudobu, abyste vy jeho chudobou zbohatli. ");
INSERT INTO ceslb_vpl VALUES ("C28_10","077_8_10","2CO","8","10","12","Měli byste tedy ten nápad, který se zrodil u vás, dotáhnout až do konce. Když jste začali s takovým nadšením, nepolevujte nyní a ochotně dávejte, kolik můžete. Kdo více dát nemůže, ať se netrápí. Bohu záleží na ochotě, a ne na velikosti daru. ");
INSERT INTO ceslb_vpl VALUES ("C28_13","077_8_13","2CO","8","13","14","Nejde o to, aby si jiní mohli dopřávat na váš účet. Ale jestliže se vám nyní vede lépe, rozdělte se s potřebnějšími. Vždyť oni mohou zase pomoci vám, když se situace změní. Tak budete mít každý právě tolik, kolik potřebujete, ");
INSERT INTO ceslb_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","jak čteme v Písmu o Izraelcích sbírajících pokrm na poušti: „Kdo nashromáždil více, tomu nepřebývalo, kdo nasbíral méně, neměl nedostatek.“ ");
INSERT INTO ceslb_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","Jsem vděčný Bohu za to, že Titus k vám přilnul stejně jako já. ");
INSERT INTO ceslb_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Můj návrh hned s radostí přijal, ale myslím, že by byl tak jako tak využil první příležitosti vydat se opět k vám. ");
INSERT INTO ceslb_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Posílám s ním ještě jednoho bratra, kterého si pro jeho oddanost ve službě Kristu váží ve všech církvích. ");
INSERT INTO ceslb_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Byl vybrán, aby mě doprovázel do Jeruzaléma s výtěžkem sbírky, jež má oslavit našeho Pána a veřejně prokázat naši horlivost k službě. ");
INSERT INTO ceslb_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Předejde se tak možným pozdějším dohadům, zda se opravdu všechny peníze dostaly tam, kam byly určeny. ");
INSERT INTO ceslb_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Bůh ví, že nikoho z nás by ani ve snu nenapadlo zpronevěřit jediný haléř, ale abychom vyloučili i sebenepatrnější podezření, zařídili jsme to raději takto. ");
INSERT INTO ceslb_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Doprovází je ještě další bratr, mnohokrát již osvědčený jako upřímný křesťan. Těší se k vám, protože jsem mu vyprávěl o vašem nadšení pro pomoc druhým. Přijměte je tedy všechny přívětivě. ");
INSERT INTO ceslb_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Titus je v této věci mým zplnomocněným zástupcem. Je to můj nejbližší spolupracovník. Ostatní dva vyslaly zdejší církve jako své nejlepší představitele. ");
INSERT INTO ceslb_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Ukažte jim, že všechny moje chvály na vás nebyly plané. ");
INSERT INTO ceslb_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Myslím, že bych se o té akci na pomoc Jeruzalémským ani nemusel tolik rozepisovat. ");
INSERT INTO ceslb_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Vím, že tyto věci jsou pro vás samozřejmé, a v Makedonii jsem hrdě prohlašoval, že vy jste se sbírkou začali už vloni. Právě ta vaše horlivost nakazila mnohé z nich. ");
INSERT INTO ceslb_vpl VALUES ("C29_3","077_9_3","2CO","9","3","4","Teď k vám posílám tyto bratry, abych se přesvědčil, zda jsem vás nepřechválil. Jak bych potom vypadal před Makedonskými, kdyby se ukázalo, že jsem neměl pravdu? Musel bych se propadnout hanbou a vy teprve! ");
INSERT INTO ceslb_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","Proto jsem pokládal za nutné poprosit tyto bratry, aby shromáždili všechny vaše příspěvky ještě před mým příjezdem, aby to pak nevypadalo, že jsem je přijel vymáhat. ");
INSERT INTO ceslb_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Pamatujte však: skoupá setba – hubená sklizeň. Bohatou úrodu sklidí ten, kdo zasévá štědře. ");
INSERT INTO ceslb_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Velikost svého příspěvku ať si určí každý sám, nikoho nenuťte dávat víc, než sám chce. Bůh nemá zájem o vynucené dary: miluje toho, kdo dává rád. On si může dovolit ponechat to na vás: ");
INSERT INTO ceslb_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","vždyť od něho dostáváte nejen všechno, co sami potřebujete, ale navíc ještě tolik, abyste mohli být štědří i k jiným. ");
INSERT INTO ceslb_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Vždyť podle Písma Bůh nikdy nezavře svou ruku před štědrými. ");
INSERT INTO ceslb_vpl VALUES ("C29_10","077_9_10","2CO","9","10","11","On, který dává rolníku chléb i zrno na setí, poskytne potřebnou setbu i vám a z její sklizně budete mít stále víc pro sebe i pro druhé. K němu pak budou směřovat vždy četnější díky, které od vás odevzdáme. ");
INSERT INTO ceslb_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Nejde totiž jenom o to, že se pomůže jeruzalémským křesťanům; neméně důležitá je vděčnost Bohu, která tím bude vzbuzena. ");
INSERT INTO ceslb_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Kdekdo bude Bohu děkovat za to, že jeho slovo milosti a záchrany našlo u vás tak bohatou odezvu. ");
INSERT INTO ceslb_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Budou se za vás modlit a přilnou k vám vřelým bratrským vztahem. ");
INSERT INTO ceslb_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Díky Bohu za Ježíše Krista, ten vzácný dar nad všechny dary! ");
INSERT INTO ceslb_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Ještě jedné věci bych se chtěl dotknout – týká se to mé vlastní osoby a řeknu to beze vší hořkosti a nevraživosti, v duchu Kristovy lásky. Povídá se prý o mně, že v dopisech se stavím jako kdovíjaký silák, ale když dojde k osobnímu střetnutí, jsem prý maličký a ubohý. ");
INSERT INTO ceslb_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Prosím vás, nenuťte mě, abych vás přesvědčil, že mi nechybí odvaha k ráznějšímu postupu proti těm, kdo přičítají mému jednání pouze lidské pohnutky. ");
INSERT INTO ceslb_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Ano, jsme jen obyčejní lidé, ale své boje nevyhráváme pouze vlastní sílou. ");
INSERT INTO ceslb_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Máme účinné zbraně, schopné porazit každého odpůrce. ");
INSERT INTO ceslb_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","Proti nim neobstojí žádná domýšlivost, ani nejchytřejší filozofie, popírající Boží pravdu. Každého myslícího člověka jednoznačně vedeme ke Kristu jako ke konečné odpovědi a svrchované pravdě. Rozhodnete-li se společně pro poslušnost, ");
INSERT INTO ceslb_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","jsem připraven potrestat každého, kdo nebude poslušný. ");
INSERT INTO ceslb_vpl VALUES ("C210_7","077_10_7","2CO","10","7","8","Nenechte se klamat vnějším zdáním. Jestliže si kdokoliv z vás může dělat nárok, že je Kristův, pak můj nárok není o nic menší – spíš naopak! Navíc bych se ještě mohl odvolávat na přímé Boží pověření. ");
INSERT INTO ceslb_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Nechci ovšem vzbudit dojem, jako bych vás chtěl svými listy zastrašovat. ");
INSERT INTO ceslb_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","„Nevšímejte si jeho dopisů,“ říkají někteří, „je to jen plané vyhrožování. Až přijde, poznáte sami, že není proč se ho bát. Slabšího kazatele jste ještě neslyšeli.“ ");
INSERT INTO ceslb_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Ujišťuji vás, že tentokrát budu jednat stejně přísně, jako jsem doposud psal. ");
INSERT INTO ceslb_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","V žádném případě se nechci měřit s těmi oslňujícími kazateli, kteří ve svých projevech vychvalují sami sebe. Těm se samozřejmě nemohu vyrovnat, protože oni jsou sami sobě jediným měřítkem a vzorem vší dokonalosti. Jaká pošetilost! ");
INSERT INTO ceslb_vpl VALUES ("C210_13","077_10_13","2CO","10","13","15","Mým cílem je splnit se ctí úkoly, které mi vytyčil Bůh. K nim patří i má práce v Korintu. Odpovědnost za vás si neosobuji neprávem – vždyť jsem byl první, od koho jste vůbec slyšeli o Kristu! Kdybych svou autoritu odvozoval jen z toho, že pokračuji v díle, které začal někdo jiný, dalo by se o ní možná pochybovat. Ale jako váš duchovní otec bych spíš čekal, že s vaší vírou vzroste i úcta ke mně. ");
INSERT INTO ceslb_vpl VALUES ("C210_16","077_10_16","2CO","10","16","17","Pak budu moci šířit Boží poselství dál i za vaše území, do krajů, kam dosud neproniklo. Písmo nás učí, že se nemáme honosit vlastními úspěchy, ale tím, co vykonal Bůh. Když někdo vykřikuje do světa, jaký je chlapík, to ještě nic neznamená. ");
INSERT INTO ceslb_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Důvěru si zaslouží ten a jenom ten, komu dává své vysvědčení Bůh. ");
INSERT INTO ceslb_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","Doufám, že mé skromné řádky nevyčerpaly ještě všechnu vaši trpělivost. Už jenom chviličku strpení, prosím vás. ");
INSERT INTO ceslb_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Záleží mi totiž na vás, opravdu moc mi na vás záleží – ne méně než samotnému Bohu. Jako byste byli mou jedinou dcerou, kterou jsem zaslíbil jedinému muži – Kristu. Chci mu ji přivést čistou, nedotčenou. Teď mi však svírá srdce úzkost, aby vaše věrná a čistá láska k němu nebyla zkalena a pošpiněna nebo aby docela nezanikla. ");
INSERT INTO ceslb_vpl VALUES ("C211_3","077_11_3","2CO","11","3","4","Víte přece, jak chytře dokázal satan ošálit Evu v ráji! A vy s takovým klidem popřáváte sluchu každému, kdo vám předkládá jiného Krista než my a vnáší mezi vás cizího ducha a rozšiřuje jakési jiné poselství, než jste slyšeli od nás. ");
INSERT INTO ceslb_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","Mám za to, že si s těmi veleapoštoly v ničem nezadám. ");
INSERT INTO ceslb_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Jestli jsem slabší řečník, tak alespoň vím, o čem mluvím. O tom jste se přece mohli už přesvědčit, vždyť jsem to nejednou dokázal. ");
INSERT INTO ceslb_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Nebo jsem snad chybil tím, že jsem od vás za svou kazatelskou službu nepřijal žádný plat? Že jsem sám sebe ponižoval, abych vám pomohl výš? ");
INSERT INTO ceslb_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Můj pobyt u vás hradily jiné křesťanské obce – tak jsem je „vykořisťoval“, jen abych vám nebyl na obtíž. ");
INSERT INTO ceslb_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","A když mi došly peníze a neměl jsem co do úst, zase jsem vás nežádal o pomoc, protože mi vypomohli křesťané z Makedonie. Ani korunu jsem od vás nevzal a také v budoucnu nevezmu. ");
INSERT INTO ceslb_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","A jako že sloužím Kristově pravdě – tak a ne jinak to budu dělat po celém Řecku. ");
INSERT INTO ceslb_vpl VALUES ("C211_11","077_11_11","2CO","11","11","12","Proč? Protože vás snad nemám rád? Bůh ví, že mám. Chci vám i nadále sloužit bez jakékoliv odměny, aby ti lidé nemohli tvrdit, že v naší a jejich činnosti není žádný rozdíl. ");
INSERT INTO ceslb_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Vždyť jsou to podvodníci, tihle „lžiapoštolové“, kteří se za Kristovy vyslance pouze vydávají! ");
INSERT INTO ceslb_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Není se tomu ovšem co divit, vždyť i sám satan na sebe často bere andělskou podobu. ");
INSERT INTO ceslb_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Jaký tedy div, že jeho pomahači se maskují za služebníky Boží! Však je nakonec spravedlivá odplata nemine. ");
INSERT INTO ceslb_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Věřte mi, že to mám v hlavě docela v pořádku. A jestli ne, jak někteří tvrdí, proč bych se nemohl jednou trochu pochlubit po jejich způsobu a vyložit vám nějaké ty svoje přednosti? ");
INSERT INTO ceslb_vpl VALUES ("C211_17","077_11_17","2CO","11","17","21","Jako křesťanovi by se mi to ovšem dost příčilo, ale jako údajný blázen si to snad mohu dovolit. Vy jste přece tak moudří, že umíte být i k bláznům shovívaví! Nevadí vám, že vás tyranizují a vydírají, že vámi pohrdají a šlapou po vás. Tedy ano, přiznávám, že tohle bych já nedokázal. ");
INSERT INTO ceslb_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","A jaké jsou jejich další přednosti? Starobylý původ? Promiňte nerozumnému, můj není horší! Náboženské vzdělání? Ani v tom nejsem pozadu. ");
INSERT INTO ceslb_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Prohlašují se za Kristovy služebníky? Když se již nerozumně chlubím, pak i v tom se jim více než vyrovnám! Kdo vynaložil pro Krista více potu? Kdo byl vícekrát ve vězení, vícekrát týrán, vícekrát riskoval svou kůži? ");
INSERT INTO ceslb_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Pětkrát mi nechali židé vysázet devětatřicet ran karabáčem na holá záda. ");
INSERT INTO ceslb_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Třikrát mě zmlátili klacky, jednou dokonce kamenovali. Třikrát jsem zažil ztroskotání lodi, z toho jednou jsem noc a den strávil ve vlnách moře. ");
INSERT INTO ceslb_vpl VALUES ("C211_26","077_11_26","2CO","11","26","27","Kolikrát jsem cestoval stovky vyčerpávajících kilometrů, ohrožován rozvodněnými řekami, lupiči, vlastními soukmenovci i pohany. Smrt mi hrozila v rozběsněných davech i liduprázdných pouštích, na rozbouřeném moři i mezi falešnými bratry. Vím, co jsou bezesné noci a smrtelná únava, sžíravý hlad a mučivá žízeň, co je být na kost promrzlý a nemít se čím zahřát. ");
INSERT INTO ceslb_vpl VALUES ("C211_28","077_11_28","2CO","11","28","29","A k tomu navíc neustálé starosti, jak se vede mým křesťanským obcím. Odmítl jsem snad někdy pomoc někomu, koho tížilo svědomí? Netrápil jsem se snad, kdykoliv někdo kolísal ve víře? ");
INSERT INTO ceslb_vpl VALUES ("C211_30","077_11_30","2CO","11","30","31","Když už jsem tedy nucen nějak se chlubit, budu mluvit o věcech, které neslouží ke cti mně, nýbrž Bohu. On – věčná sláva jeho jménu – ví, že nelžu. ");
INSERT INTO ceslb_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","V Damašku dal místodržící krále Arety hlídat městské brány, aby mě dopadl. ");
INSERT INTO ceslb_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Nechal jsem se tedy spustit na laně z okna v městských branách a tak jsem z té pasti utekl. Co tomu říkáte? ");
INSERT INTO ceslb_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","A když jsem v tom chlubení (i když to k ničemu není), povím vám ještě o viděních a zjeveních od Pána. ");
INSERT INTO ceslb_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","Před čtrnácti lety jsem byl ve vytržení vzat do nebe. Zdali to bylo vidění nebo skutečnost, to se mě neptejte. Jen Bůh by na to mohl odpovědět. ");
INSERT INTO ceslb_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","Ale tak či onak byl jsem v ráji ");
INSERT INTO ceslb_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","a slyšel jsem věci tak ohromující, že se to nedá vylíčit slovy, ani jinak vykreslit. ");
INSERT INTO ceslb_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Takový zážitek, to už by byl nějaký důvod k vychloubání, ale raději o tom pomlčím a budu poukazovat spíš na svou slabost. ");
INSERT INTO ceslb_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Mohl bych se chlubit ještě jinými věcmi a nebyla by to chlouba neoprávněná, ale ať mě každý posuzuje jen podle toho, co v mém životě vidí a v mém poselství slyší. ");
INSERT INTO ceslb_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Bůh mi toho ukázal tolik, že mi musel přidat i jedno trápení, abych nezpyšněl: je to bolest, která mi jako satanův posel má stále připomínat, že jsem jen smrtelný lidský červíček. ");
INSERT INTO ceslb_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Třikrát jsem Boha prosil, aby mě toho zbavil, ");
INSERT INTO ceslb_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ale on odmítl. „Jsem s tebou, víc nepotřebuješ,“ odpověděl. „Moje moc vynikne tím víc, čím ty sám budeš slabší.“ ");
INSERT INTO ceslb_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Nesu tedy svou nemoc rád a jsem hrdý na to, že právě na jejím pozadí se ve mně tak zřetelně prokazuje Kristova síla. Nevadí mi ani ta nemoc, ani příkoří, ani bída, pronásledování a jiné těžkosti, protože vším sloužím Kristově věci. A největší sílu dostávám tehdy, když jsem s vlastními silami u konce. ");
INSERT INTO ceslb_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","Teď jsem se tedy představil opravdu jako dokonalý blázen. Ale sami jste mě k tomu přinutili. Vždyť to mělo být spíše vaší věcí, abyste se mě zastali! I když nic neznamenám, nejsem přece za těmi „veleapoštoly“ nijak pozadu. ");
INSERT INTO ceslb_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","Když jsem byl mezi vámi, poskytl jsem vám dostatek důkazů, že mě poslal Bůh; trpělivě jsem mezi vámi konal to, co mi uložil, a nebyla to maličkost, nýbrž divy a zázraky. ");
INSERT INTO ceslb_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Jen v jedné věci jsem vás proti křesťanům na jiných místech „zkrátil“: nežádal jsem vás o hmotnou podporu. Tuhle nespravedlnost mi tedy promiňte. ");
INSERT INTO ceslb_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","Chystám se k vám už po třetí. Ani tentokrát od vás nic nežádám. Bez vašich peněz se mohu obejít – ale vás samých se vzdát nemohu. Ostatně rodiče mají živit děti a ne se od dětí nechat vydržovat – a vy jste moje děti. ");
INSERT INTO ceslb_vpl VALUES ("C212_15","077_12_15","2CO","12","15","16","Rád se pro vás zřeknu všeho, i sám sebe, jestli vám to prospěje; ale jak se zdá, projevy mé lásky nacházejí u vás odezvu spíše opačnou. I toto se prý u vás dá slyšet: „Ten Pavel se ale vyzná. Chytře to zařídí tak, aby se zdálo, že nás jeho návštěva nic nestojí, ale můžete si být jisti, že je to jen trik a že z nás peníze dostane jinak.“ ");
INSERT INTO ceslb_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","Jak tedy, ptám se? Chtěl snad od vás něco některý z lidí, které jsem k vám poslal? ");
INSERT INTO ceslb_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Těžil z vaší pohostinnosti Titus nebo někdo z jeho doprovodu? Neřídili se snad stejnými zásadami jako já? Tak vidíte! Jednáme v témž duchu, který řídí každý náš čin – ne k našemu, nýbrž k vašemu prospěchu. ");
INSERT INTO ceslb_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Nemyslete si, že se tím snažím znovu se vemluvit do vaší přízně. Bůh je mi svědkem, že mi opravdu jde o vaše dobro, o váš duchovní růst – a ne o získávání výhod. ");
INSERT INTO ceslb_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Obávám se, až k vám zase přijdu, abych u vás nenašel věci, které nerad vidím. Vám by se pak nelíbilo, jaké důsledky bych z toho musel vyvodit. Nerad bych se shledal s hádkami a závistí, s urážlivostí a pomluvami, vzájemným osočováním, nadutostí a rozkolnictvím. ");
INSERT INTO ceslb_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Nechtěl bych zažít, aby mě Bůh před vámi tak pokořil, že bych musel plakat a naříkat nad některými, kteří místo toho, aby se v pokání odvrátili od svých poklesků, hřeší klidně dál a stále se oddávají nemravnosti a nezřízeným vášním. ");
INSERT INTO ceslb_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1