﻿USE sofia;
DROP TABLE IF EXISTS sofia.ces1613_vpl;
CREATE TABLE ces1613_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ces1613_vpl WRITE;
INSERT INTO ces1613_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Na počátku stvořil Bůh nebe a zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Země pak byla nesličná a pustá, a tma byla nad propastí, a Duch Boží vznášel se nad vodami. ");
INSERT INTO ces1613_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","I řekl Bůh: Buď světlo! I bylo světlo. ");
INSERT INTO ces1613_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","A viděl Bůh světlo, že bylo dobré; i oddělil Bůh světlo od tmy. ");
INSERT INTO ces1613_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A nazval Bůh světlo dnem, a tmu nazval nocí. I byl večer a bylo jitro, den první. ");
INSERT INTO ces1613_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Řekl také Bůh: Buď obloha u prostřed vod, a děl vody od vod! ");
INSERT INTO ces1613_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","I učinil Bůh tu oblohu, a oddělil vody, kteréž jsou pod oblohou, od vod, kteréž jsou nad oblohou. A stalo se tak. ");
INSERT INTO ces1613_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","I nazval Bůh oblohu nebem. I byl večer a bylo jitro, den druhý. ");
INSERT INTO ces1613_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Řekl také Bůh: Shromažďte se vody, kteréž jsou pod nebem, v místo jedno, a ukaž se místo suché! A stalo se tak. ");
INSERT INTO ces1613_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","I nazval Bůh místo suché zemí, shromáždění pak vod nazval mořem. A viděl Bůh, že to bylo dobré. ");
INSERT INTO ces1613_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Potom řekl Bůh: Zploď země trávu, a bylinu vydávající símě, a strom plodný, nesoucí ovoce podlé pokolení svého, v němž by bylo símě jeho na zemi. A stalo se tak. ");
INSERT INTO ces1613_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nebo země vydala trávu, a bylinu nesoucí semeno podlé pokolení svého, i strom přinášející ovoce, v němž bylo símě jeho, podlé pokolení jeho. A viděl Bůh, že to bylo dobré. ");
INSERT INTO ces1613_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","I byl večer a bylo jitro, den třetí. ");
INSERT INTO ces1613_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Opět řekl Bůh: Buďte světla na obloze nebeské, aby oddělovala den od noci, a byla na znamení a rozměření časů, dnů a let. ");
INSERT INTO ces1613_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","A aby svítila na obloze nebeské, a osvěcovala zemi. A stalo se tak. ");
INSERT INTO ces1613_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","I učinil Bůh dvě světla veliká, světlo větší, aby správu drželo nade dnem, a světlo menší, aby správu drželo nad nocí; též i hvězdy. ");
INSERT INTO ces1613_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","A postavil je Bůh na obloze nebeské, aby osvěcovala zemi; ");
INSERT INTO ces1613_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","A aby správu držela nade dnem a nocí, a oddělovala světlo od tmy. A viděl Bůh, že to bylo dobré. ");
INSERT INTO ces1613_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","I byl večer a bylo jitro, den čtvrtý. ");
INSERT INTO ces1613_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Řekl ještě Bůh: Vydejte vody hmyz duše živé v hojnosti, a ");
INSERT INTO ces1613_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","I stvořil Bůh velryby veliké a všelijakou duši živou, hýbající se, kteroužto v hojnosti vydaly vody podlé pokolení jejich, a všeliké ptactvo křídla mající, podlé pokolení jeho. A viděl Bůh, že to bylo dobré. ");
INSERT INTO ces1613_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","I požehnal jim Bůh, řka: Ploďtež se a množte se, a naplňte vody mořské; též ptactvo ať se rozmnožuje na zemi! ");
INSERT INTO ces1613_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","I byl večer a bylo jitro, den pátý. ");
INSERT INTO ces1613_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Řekl též Bůh: Vydej země duši živou, jednu každou podlé pokolení jejího, hovada a zeměplazy, i zvěř zemskou, podlé pokolení jejího. A stalo se tak. ");
INSERT INTO ces1613_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","I učinil Bůh zvěř zemskou podlé pokolení jejího, též hovada vedlé pokolení jejich, i všeliký zeměplaz podlé pokolení jeho. A viděl Bůh, že bylo dobré. ");
INSERT INTO ces1613_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Řekl opět Bůh: Učiňme člověka k obrazu našemu, podlé podobenství našeho, a ať panují nad rybami mořskými, a nad ptactvem nebeským, i nad hovady, a nade vší zemí, i nad všelikým zeměplazem hýbajícím se na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","I stvořil Bůh člověka k obrazu svému, k obrazu Božímu stvořil jej, muže a ženu stvořil je. ");
INSERT INTO ces1613_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","A požehnal jim Bůh, a řekl jim Bůh: Ploďtež se a rozmnožujte se, a naplňte zemi, a podmaňte ji, a panujte nad rybami mořskými, a nad ptactvem nebeským, i nad všelikým živočichem hýbajícím se na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Řekl ještě Bůh: Aj, dal jsem vám všelikou bylinu, vydávající símě, kteráž jest na tváři vší země, a všeliké stromoví, (na němž jest ovoce stromu), nesoucí símě; to bude vám za pokrm. ");
INSERT INTO ces1613_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Všechněm pak živočichům zemským, i všemu ptactvu nebeskému, a všemu tomu, což se hýbe na zemi, v čemž jest duše živá, všelikou bylinu zelenou dal jsem ku pokrmu. I stalo se tak. ");
INSERT INTO ces1613_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","A viděl Bůh vše, což učinil, a aj, bylo velmi dobré. I byl večer a bylo jitro, den šestý. ");
INSERT INTO ces1613_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","A tak dokonána jsou nebesa a země, i všecko vojsko jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","A dokonal Bůh dne sedmého dílo své, kteréž dělal; a odpočinul v den sedmý ode všeho díla svého, kteréž byl dělal. ");
INSERT INTO ces1613_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","I požehnal Bůh dni sedmému a posvětil ho; nebo v něm odpočinul Bůh ode všeho díla svého, kteréž byl stvořil, aby učiněno bylo. ");
INSERT INTO ces1613_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tiť jsou rodové nebes a země, (když stvořena jsou v den, v němž učinil Hospodin Bůh zemi i nebe), ");
INSERT INTO ces1613_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","I každé chrastiny polní, dříve než byla na zemi, i všeliké byliny polní, prvé než vzcházela; nebo ještě byl nedštil Hospodin Bůh na zemi, aniž byl který člověk, ješto by dělal zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","A aniž pára vystupovala z země, aby svlažovala všecken svrchek země. ");
INSERT INTO ces1613_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","I učinil Hospodin Bůh člověka z prachu země, a vdechl v chřípě jeho dchnutí života, i byl člověk v duši živou. ");
INSERT INTO ces1613_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Štípil pak byl Hospodin Bůh ráj v Eden na východ, a postavil tam člověka, jehož byl učinil. ");
INSERT INTO ces1613_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","A vyvedl Hospodin Bůh z země všeliký strom na pohledění libý, a ovoce k jídlu chutné; též strom života u prostřed ráje, i strom vědění dobrého a zlého. ");
INSERT INTO ces1613_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","(A řeka vycházela z Eden, k svlažování ráje, a odtud dělila se, a byla ve čtyři hlavní řeky. ");
INSERT INTO ces1613_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Jméno jedné Píson, ta obchází všecku zemi Hevilah, kdež jest zlato. ");
INSERT INTO ces1613_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A zlato země té jest výborné; tam jest i bdelium, a kámen onychin. ");
INSERT INTO ces1613_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Jméno pak druhé řeky Gihon, ta obchází všecku zemi Chus. ");
INSERT INTO ces1613_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","A jméno řeky třetí Hiddekel, kteráž teče k východní straně Assyrské země. A řeka čtvrtá jest Eufrates). ");
INSERT INTO ces1613_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Pojav tedy Hospodin Bůh člověka, postavil jej v ráji v zemi Eden, aby jej dělal a ostříhal ho. ");
INSERT INTO ces1613_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","I zapověděl Hospodin Bůh člověku, řka: Z každého stromu rajského svobodně jísti budeš; ");
INSERT INTO ces1613_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ale z stromu vědění dobrého a zlého nikoli nejez; nebo v který bys koli den z něho jedl, smrtí umřeš. ");
INSERT INTO ces1613_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Řekl byl také Hospodin Bůh: Není dobré člověku býti samotnému; učiním jemu pomoc, kteráž by při něm byla. ");
INSERT INTO ces1613_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","(Nebo když byl učinil Hospodin Bůh z země všelikou zvěř polní, i všecko ptactvo nebeské, přivedl je k Adamovi, aby pohleděl na ně, jaké by jméno kterému dáti měl; a jak by koli nazval Adam kterou duši živou, tak aby jmenována byla. ");
INSERT INTO ces1613_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","I dal Adam jména všechněm hovadům, i ptactvu nebeskému, a všeliké zvěři polní; Adamovi pak není nalezena pomoc, kteráž by při něm byla.) ");
INSERT INTO ces1613_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Protož uvedl Hospodin Bůh tvrdý sen na Adama, i usnul; a vyňal jedno z žeber jeho, a to místo vyplnil tělem. ");
INSERT INTO ces1613_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","A z toho žebra, kteréž vyňal z Adama, vzdělal Hospodin Bůh ženu, a přivedl ji k Adamovi. ");
INSERT INTO ces1613_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","I řekl Adam: Teď tato jest kost z kostí mých a tělo z těla mého; tato slouti bude mužatka, nebo z muže vzata jest. ");
INSERT INTO ces1613_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Z té příčiny opustí muž otce svého i matku svou, a přídržeti se bude manželky své, i budou v jedno tělo. ");
INSERT INTO ces1613_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Byli pak oba dva nazí, Adam i žena jeho, a nestyděli se. ");
INSERT INTO ces1613_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Had pak byl nejchytřejší ze všech živočichů polních, kteréž byl učinil Hospodin Bůh. A ten řekl ženě: Tak-liž jest, že vám Bůh řekl: Nebudete jísti z každého stromu rajského? ");
INSERT INTO ces1613_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","I řekla žena hadu: Ovoce stromů rajských jíme; ");
INSERT INTO ces1613_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ale o ovoci stromu, kterýž jest u prostřed ráje, řekl Bůh: Nebudete ho jísti, aniž se ho dotknete, abyste nezemřeli. ");
INSERT INTO ces1613_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","I řekl had ženě: Nikoli nezemřete smrtí! ");
INSERT INTO ces1613_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ale ví Bůh, že v kterýkoli den z něho jísti budete, otevrou se oči vaše; a budete jako bohové, vědouce dobré i zlé. ");
INSERT INTO ces1613_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Viduci tedy žena, že dobrý jest strom k jídlu i příjemný očima, a k nabytí rozumnosti strom žádostivý, vzala z ovoce jeho a jedla; dala také i muži svému s sebou, a on jedl. ");
INSERT INTO ces1613_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tedy otevříny jsou oči obou dvou, a poznali, že jsou nazí; i navázali lístí fíkového a nadělali sobě věníků. ");
INSERT INTO ces1613_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","A v tom uslyšeli hlas Hospodina Boha chodícího po ráji k větru dennímu; i skryl se Adam a žena jeho před tváří Hospodina Boha, u prostřed stromoví rajského. ");
INSERT INTO ces1613_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","I povolal Hospodin Bůh Adama, a řekl jemu: Kdež jsi? ");
INSERT INTO ces1613_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kterýžto řekl: Hlas tvůj slyšel jsem v ráji a bál jsem se, že jsem nahý; protož skryl jsem se. ");
INSERT INTO ces1613_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","I řekl Bůh: Kdožť oznámil, že jsi nahý? Nejedl-lis ale z toho stromu, z něhožť jsem jísti zapověděl? ");
INSERT INTO ces1613_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","I řekl Adam: Žena, kterouž jsi mi dal, aby byla se mnou, ona mi dala z stromu toho, a jedl jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","I řekl Hospodin Bůh ženě: Což jsi to učinila? I řekla žena: Had mne podvedl, i jedla jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tedy řekl Hospodin Bůh hadu: Že jsi to učinil, zlořečený budeš nade všecka hovada a nade všecky živočichy polní; po břiše svém plaziti se budeš, a prach žráti budeš po všecky dny života svého. ");
INSERT INTO ces1613_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nad to, nepřátelství položím mezi tebou a mezi ženou, i mezi semenem tvým a semenem jejím; ono potře tobě hlavu, a ty potřeš jemu patu. ");
INSERT INTO ces1613_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ženě pak řekl: Velice rozmnožím bolesti tvé a počínání tvá, s bolestí roditi budeš děti, a pod mocí muže tvého bude žádost tvá, a on panovati bude nad tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adamovi také řekl: Že jsi uposlechl hlasu ženy své, a jedl jsi z stromu toho, kterýžť jsem zapověděl, řka: Nebudeš jísti z něho; zlořečená země pro tebe, s bolestí jísti budeš z ní po všecky dny života svého. ");
INSERT INTO ces1613_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Trní a bodláčí tobě ploditi bude, i budeš jísti byliny polní. ");
INSERT INTO ces1613_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","V potu tváři své chléb jísti budeš, dokavadž se nenavrátíš do země, poněvadž jsi z ní vzat. Nebo prach jsi a v prach se navrátíš. ");
INSERT INTO ces1613_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Dal pak byl Adam jméno ženě své Eva, proto že ona byla mátě všech živých. ");
INSERT INTO ces1613_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","I zdělal Hospodin Bůh Adamovi a ženě jeho oděv kožený, a přioděl je. ");
INSERT INTO ces1613_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tedy řekl Hospodin Bůh: Aj, člověk učiněn jest jako jeden z nás, věda dobré i zlé; pročež nyní, aby nevztáhl ruky své, a nevzal také z stromu života, a jedl by, i byl by živ na věky, vyžeňme jej. ");
INSERT INTO ces1613_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","I vypustil jej Hospodin Bůh z zahrady Eden, aby dělal zemi, z níž vzat byl. ");
INSERT INTO ces1613_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A tak vyhnal člověka a osadil zahradu Eden cherubíny k východní straně s mečem plamenným blýskajícím se, aby ostříhali cesty k stromu života. ");
INSERT INTO ces1613_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam pak poznal Evu ženu svou, kterážto počavši, porodila Kaina a řekla: Obdržela jsem muže na Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","A opět porodila bratra jeho Abele. I byl Abel pastýř ovcí, a Kain byl oráč. ");
INSERT INTO ces1613_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Po mnohých pak dnech stalo se, že obětoval Kain z úrody zemské obět Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ano i Abel také obětoval z prvorozených věcí stáda svého, a z tuku jejich. I vzhlédl Hospodin na Abele a na obět jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Na Kaina pak a na obět jeho nevzhlédl. Protož rozlítil se Kain náramně, a opadla tvář jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","I řekl Hospodin Kainovi: Proč jsi se tak rozpálil hněvem? A proč jest opadla tvář tvá? ");
INSERT INTO ces1613_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Zdaliž nebudeš příjemný, budeš-li dobře činiti? Pakli nebudeš dobře činiti, hřích ve dveřích leží; a pod mocí tvou bude žádost jeho, a ty panovati budeš nad ním. ");
INSERT INTO ces1613_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","I mluvil Kain k Abelovi bratru svému. Stalo se pak, když byli na poli, že povstav Kain proti Abelovi bratru svému, zabil jej. ");
INSERT INTO ces1613_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","I řekl Hospodin Kainovi: Kdež jest Abel bratr tvůj? Kterýž odpověděl: Nevím. Zdaliž jsem já strážným bratra svého? ");
INSERT INTO ces1613_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","I řekl Bůh: Co jsi učinil? Hlas krve bratra tvého volá ke mně z země. ");
INSERT INTO ces1613_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Protož nyní zlořečený budeš i od té země, kteráž otevřela ústa svá, aby přijala krev bratra tvého z ruky tvé. ");
INSERT INTO ces1613_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Když budeš dělati zemi, nebude více vydávati moci své tobě; tulákem a běhounem budeš na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","I řekl Kain Hospodinu: Většíť jest nepravost má, než aby mi odpuštěna býti mohla. ");
INSERT INTO ces1613_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Aj, vyháníš mne dnes z země této, a před tváří tvou skrývati se budu, a budu tulákem a běhounem na zemi. I přijde na to, že kdo mne koli nalezne, zabije mne. ");
INSERT INTO ces1613_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","I řekl mu Hospodin: Zajisté kdo by koli zabil Kaina, nad tím sedmnásobně mštěno bude. Pročež vložil Hospodin znamení naKaina, aby ho žádný nezabil, kdo by jej koli nalezl. ");
INSERT INTO ces1613_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tedy odšed Kain od tváři Hospodinovy, bydlil v zemi Nód, k východní straně naproti Eden. ");
INSERT INTO ces1613_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Poznal pak Kain ženu svou, kterážto počala a porodila Enocha. I stavěl město, a nazval jméno města toho jménem syna svého Enoch. ");
INSERT INTO ces1613_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","I narodil se Enochovi Irád, a Irád zplodil Maviaele, Maviael pak zplodil Matuzaele, a Matuzael zplodil Lámecha. ");
INSERT INTO ces1613_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Vzal sobě pak Lámech dvě ženy; jméno jedné Ada, a jméno druhé Zilla. ");
INSERT INTO ces1613_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","I porodila Ada Jábale, kterýž byl otec přebývajících v staních a stádo pasoucích. ");
INSERT INTO ces1613_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","A jméno bratra jeho Jubal; ten byl otec všech hrajících na harfu a nástroje hudebné. ");
INSERT INTO ces1613_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","A Zilla také porodila Tubalkaina, kterýž byl řemeslník všelikého díla od mědi a od železa. Sestra pak Tubalkainova byla Noéma. ");
INSERT INTO ces1613_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","I řekl Lámech ženám svým, Adě a Zille: Slyšte hlas můj, ženy Lámechovy, poslouchejte řeči mé, že jsem zabil muže k ráně své a mládence k zsinalosti své. ");
INSERT INTO ces1613_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Jestližeť sedmnásobně pomštěno bude pro Kaina, tedy pro Lámecha sedmdesátekrát sedmkrát. ");
INSERT INTO ces1613_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Poznal pak ještě Adam ženu svou, i porodila syna a nazvala jméno jeho Set; nebo řekla: Dal mi Bůh jiné símě místo Abele, kteréhož zabil Kain. ");
INSERT INTO ces1613_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setovi pak také narodil se syn, a nazval jméno jeho Enos. Tehdáž začalo se vzývání jména Hospodinova. ");
INSERT INTO ces1613_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Tato jest kniha rodů Adamových. V ten den, v kterémž stvořil Bůh člověka, ku podobenství Božímu učinil ho. ");
INSERT INTO ces1613_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Muže a ženu stvořil je a požehnal jim, a nazval jméno jejich Adam v ten den, když stvořeni jsou. ");
INSERT INTO ces1613_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Byl pak Adam ve stu a třidcíti letech, když zplodil syna ku podobenství svému a k obrazu svému, a nazval jméno jeho Set. ");
INSERT INTO ces1613_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","I bylo dnů Adamových po zplození Seta osm set let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A tak bylo všech dnů Adamových, v kterýchž byl živ, devět set a třidceti let, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set pak byl ve stu a pěti letech, když zplodil Enosa. ");
INSERT INTO ces1613_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","A po zplození Enosa živ byl Set osm set a sedm let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","I bylo všech dnů Setových devět set a dvanácte let, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Byl pak Enos v devadesáti letech, když zplodil Kainana. ");
INSERT INTO ces1613_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","A po zplození Kainana živ byl Enos osm set a patnácte let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","I bylo všech dnů Enosových devět set a pět let, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kainan pak byl v sedmdesáti letech, když zplodil Mahalaleele. ");
INSERT INTO ces1613_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","A po zplození Mahalaleele živ byl Kainan osm set a čtyřidceti let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","I bylo všech dnů Kainanových devět set a deset let, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel pak byl v šedesáti a pěti letech, když zplodil Járeda. ");
INSERT INTO ces1613_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","A po zplození Járeda živ byl Mahalaleel osm set a třidceti let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","I bylo všech dnů Mahalaleelových osm set devadesáte a pět let, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Járed pak byl ve stu šedesáti a dvou letech, když zplodil Enocha. ");
INSERT INTO ces1613_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","A po zplození Enocha živ byl Járed osm set let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","I bylo všech dnů Járedových devět set šedesáte a dvě létě, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoch pak byl v šedesáti a pěti letech, když zplodil Matuzaléma. ");
INSERT INTO ces1613_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","A chodil Enoch stále s Bohem po zplození Matuzaléma tři sta let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","I bylo všech dnů Enochových tři sta šedesáte a pět let. ");
INSERT INTO ces1613_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","A chodil Enoch stále s Bohem a nebyl více vidín; nebo vzal ho Bůh. ");
INSERT INTO ces1613_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matuzalém pak byl ve stu osmdesáti sedmi letech, když zplodil Lámecha. ");
INSERT INTO ces1613_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","A po zplození Lámecha živ byl Matuzalém sedm set osmdesáte a dvě létě, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","I bylo všech dnů Matuzalémových devět set šedesáte a devět let, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lámech pak byl ve stu osmdesáti a dvou letech, když zplodil syna, ");
INSERT INTO ces1613_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Jehož jméno nazval Noé, řka: Tento nám odpočinutí způsobí od díla našeho, od práce rukou našich, kterouž máme s zemí, jížto zlořečil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","A živ byl Lámech potom, když zplodil Noé, pět set devadesáte a pět let, a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","I bylo všech dnů Lámechových sedm set sedmdesáte a sedm let, i umřel. ");
INSERT INTO ces1613_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","A když byl Noé v pěti stech letech, zplodil Sema, Chama a Jáfeta. ");
INSERT INTO ces1613_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Stalo se pak, když se počali množiti lidé na zemi, a dcery se jim zrodily, ");
INSERT INTO ces1613_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Že vidouce synové Boží dcery lidské, any krásné jsou, brali sobě ženy ze všech, kteréž oblibovali. ");
INSERT INTO ces1613_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Pročež řekl Hospodin: Nebude se nesnaditi duch můj s člověkem na věky, proto že také tělo jest, a bude dnů jeho sto a dvadceti let. ");
INSERT INTO ces1613_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Obrové pak byli na zemi v těch dnech; ano i potom, když vcházeli synové Boží k dcerám lidským, ony rodily jim. To jsou ti mocní, kteříž zdávna byli, muži na slovo vzatí. ");
INSERT INTO ces1613_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ale když viděl Hospodin, an se rozmnožuje zlost lidská na zemi, a že by všeliké myšlení srdce jejich nebylo než zlé po všecken čas, ");
INSERT INTO ces1613_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Litoval Hospodin, že učinil člověka na zemi, a bolest měl v srdci svém. ");
INSERT INTO ces1613_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tedy řekl Hospodin: Vyhladím z země člověka, kteréhož jsem stvořil, od člověka až do hovada, až do zeměplazu, až i do ptactva nebeského; nebo líto mi, že jsem je učinil. ");
INSERT INTO ces1613_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ale Noé našel milost před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Tito jsou příběhové Noé: Noé muž spravedlivý, dokonalý byl za svého věku, s Bohem ustavičně chodil Noé. ");
INSERT INTO ces1613_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","(Zplodil pak Noé tři syny: Sema, Chama a Jáfeta.) ");
INSERT INTO ces1613_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ale země byla porušena před Bohem, a naplněna byla země nepravostí. ");
INSERT INTO ces1613_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Viděl tedy Bůh zemi, a aj, porušena byla, nebo bylo porušilo všeliké tělo cestu svou na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Protož řekl Bůh k Noé: Konec všelikého těla přichází přede mne, nebo naplněna jest země nepravostí od nich; z té příčiny, hle, již zkazím je s zemí. ");
INSERT INTO ces1613_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Učiň sobě koráb z dříví gofer; příhrady zděláš v tom korábu, a oklejuješ jej vnitř i zevnitř klím. ");
INSERT INTO ces1613_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","A na tento způsob uděláš jej: Tří set loktů bude dlouhost toho korábu, padesáti loktů širokost jeho a třidceti loktů vysokost jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Okno uděláš v korábu, a svrchkem na loket vysokým zavřeš jej; dvéře také korábu v boku jeho postavíš, a pokoje spodní, druhé i třetí zděláš v něm. ");
INSERT INTO ces1613_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Já pak, aj, já uvedu potopu vod na zemi, aby zkaženo bylo všeliké tělo, v němž jest duch života pod nebem. Cožkoli bude na zemi, umře. ");
INSERT INTO ces1613_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","S tebou však učiním smlouvu svou; a vejdeš do korábu, ty i synové tvoji, žena tvá i ženy synů tvých s tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","A ze všech živočichů všelikého těla, po dvém z každého uvedeš do korábu, abys je živé zachoval s sebou; samec a samice budou. ");
INSERT INTO ces1613_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Z ptactva podlé pokolení jeho, a z hovad podlé pokolení jejich, ze všelikého také zeměplazu podlé pokolení jeho, po dvém z každého vejdou k tobě, aby živi zůstali. ");
INSERT INTO ces1613_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ty pak nabeř s sebou všeliké potravy, kteráž se jísti může, a shromažď sobě, aby byla tobě i jim ku pokrmu. ");
INSERT INTO ces1613_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","I učinil Noé podlé všeho, jakž mu rozkázal Bůh, tak učinil. ");
INSERT INTO ces1613_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Potom řekl Hospodin k Noé: Vejdiž ty i všecka čeled tvá do korábu; nebo jsem tě viděl spravedlivého před sebou v národu tomto. ");
INSERT INTO ces1613_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ze všech hovad čistých vezmeš sobě sedmero a sedmero, samce a samici jeho, ale z hovad nečistých dvé a dvé, samce a samici jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Z ptactva také nebeského sedmero a sedmero, samce a samici, aby živé zachováno bylo símě na vší zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nebo po dnech ještě sedmi já dštíti budu na zemi za čtyřidceti dnů a čtyřidceti nocí; a vyhladím se svrchku země všelikou podstatu, kterouž jsem učinil. ");
INSERT INTO ces1613_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tedy učinil Noé všecko tak, jakž mu přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","(Byl pak Noé v šesti stech letech, když ta potopa přišla na zemi.) ");
INSERT INTO ces1613_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","A protož přišel Noé a synové jeho, i žena jeho, i ženy synů jeho s ním k korábu, pro vody potopy. ");
INSERT INTO ces1613_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Z hovad také čistých i z hovad nečistých, i z ptactva a ze všeho, což se hýbe na zemi, ");
INSERT INTO ces1613_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Po dvém vešli k Noé do korábu, samec a samice, tak jakž byl rozkázal Bůh Noé. ");
INSERT INTO ces1613_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Stalo se pak po sedmi dnech, že vody potopy přišly na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Léta šestistého věku Noé, druhého měsíce, sedmnáctého dne téhož měsíce, v ten den protrženy jsou všecky studnice propasti veliké, a průduchové nebeští otevříni jsou. ");
INSERT INTO ces1613_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","I byl příval na zemi čtyřidceti dní a čtyřidceti nocí. ");
INSERT INTO ces1613_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Toho dne všel Noé, Sem a Cham i Jáfet, synové Noé, žena Noé, a tři ženy synů jeho s ním do korábu. ");
INSERT INTO ces1613_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Oni i všeliký živočich podlé pokolení svého, i všeliké hovado podlé pokolení svého, a všeliký zeměplaz, kterýž se hýbe na zemi, podlé pokolení svého, i všeliké ptactvo vedlé pokolení svého, všelijací ptáci, všecko, což křídla má, ");
INSERT INTO ces1613_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Vešli k Noé do korábu, po dvém ze všelikého těla, v němž byl duch života. ");
INSERT INTO ces1613_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","A což jich vešlo, samec a samice ze všelikého těla vešli, tak jakž byl přikázal jemu Bůh, a zavřel Hospodin po něm. ");
INSERT INTO ces1613_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","A když byla potopa za čtyřidceti dnů na zemi, tedy rozmnoženy jsou vody, až i vyzdvihly koráb, a vznesly jej od země. ");
INSERT INTO ces1613_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nebo zmohly se vody a rozmnoženy jsou velmi nad zemí, i zplýval koráb na vodách. ");
INSERT INTO ces1613_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","A tak náramně rozmohly se vody nad zemí, že přikryty jsou všecky hory nejvyšší, kteréž byly pode vším nebem. ");
INSERT INTO ces1613_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Patnácte loktů zvýší rozmohly se vody, když přikryty jsou hory. ");
INSERT INTO ces1613_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","I umřelo všeliké tělo, kteréž se hýbe na zemi, tak z ptactva, jako z hovad a živočichů, i všelikého hmyzu, kterýž se plazí po zemi, i každého člověka. ");
INSERT INTO ces1613_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Všecko, což mělo dýchání ducha života v chřípích svých, ze všeho, což bylo na suše, pomřelo. ");
INSERT INTO ces1613_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","A tak vyhladil Bůh všelikou podstatu, kteráž byla na tváři země, od člověka až do hovada, až do zeměplazu, a až do ptactva nebeského, vyhlazeno jest, pravím, z země; a zůstal toliko Noé, a kteříž s ním byli v korábu. ");
INSERT INTO ces1613_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","I trvaly vody nad zemí za sto a padesáte dnů. ");
INSERT INTO ces1613_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Rozpomenul se pak Bůh na Noé, i všecky živočichy a všecka hovada, kteráž byla s ním v korábu; pročež uvedl Bůh vítr na zemi, i zastavily se vody. ");
INSERT INTO ces1613_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","A zavříny jsou studnice propasti i průduchové nebeští, a zastaven jest příval s nebe. ");
INSERT INTO ces1613_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","I navrátily se vody se svrchku země, odcházejíce zase, a opadly vody po stu a padesáti dnech, ");
INSERT INTO ces1613_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tak že odpočinul koráb sedmého měsíce, v sedmnáctý den toho měsíce na horách Ararat. ");
INSERT INTO ces1613_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Když pak vody odcházely a opadaly až do desátého měsíce, prvního dne téhož desátého měsíce ukázali se vrchové hor. ");
INSERT INTO ces1613_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","I stalo se po čtyřidcíti dnech, otevřev Noé okno v korábu, kteréž byl udělal, ");
INSERT INTO ces1613_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Vypustil krkavce. Kterýžto vyletuje zase se vracoval, dokudž nevyschly vody na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Potom vypustil holubici od sebe, aby věděl, již-li by opadly vody se svrchku země. ");
INSERT INTO ces1613_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kterážto když nenašla, kde by odpočinula noha její, navrátila se k němu do korábu; nebo vody byly po vší zemi. On pak vztáhna ruku svou, vzal ji, a vnesl k sobě do korábu. ");
INSERT INTO ces1613_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A počekal ještě sedm dní jiných, a opět vypustil holubici z korábu. ");
INSERT INTO ces1613_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","I přiletěla k němu holubice k večerou, a aj, list olivový utržený v ústech jejích. Tedy poznal Noé, že opadly vody se svrchku země. ");
INSERT INTO ces1613_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","I čekal ještě sedm dní jiných, a opět vypustil holubici, kterážto nevrátila se k němu více. ");
INSERT INTO ces1613_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","I stalo se šestistého prvního léta, v první den měsíce prvního, že vyschly vody na zemi. I odjal Noé přikrytí korábu a uzřel, ano již oschl svrchek země. ");
INSERT INTO ces1613_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Druhého pak měsíce, v dvadcátý sedmý den téhož měsíce oschla země. ");
INSERT INTO ces1613_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","I mluvil Bůh k Noé, řka: ");
INSERT INTO ces1613_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Vyjdi z korábu, ty i žena tvá, a synové tvoji, i ženy synů tvých s tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Všecky živočichy, kteříž jsou s tebou ze všelikého těla, tak z ptactva jako z hovad a všelikého zeměplazu, kterýž se hýbe na zemi, vyveď s sebou; ať se v hojnosti rozplozují na zemi, a rostou a množí se na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","I vyšel Noé a synové jeho, i žena jeho a ženy synů jeho s ním; ");
INSERT INTO ces1613_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Každý živočich, každý zeměplaza všecko ptactvo, všecko, což se hýbe na zemi, po pokoleních svých vyšlo z korábu. ");
INSERT INTO ces1613_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tedy vzdělal Noé oltář Hospodinu, a vzav ze všech hovad čistých i ze všeho ptactva čistého, obětoval zápaly na tom oltáři. ");
INSERT INTO ces1613_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","I zachutnal Hospodin vůni tu příjemnou, a řekl Hospodin v srdci svém: Nebudu více zlořečiti zemi pro člověka, proto že myšlení srdce lidského zlé jest od mladosti jeho; aniž budu více bíti všeho, což živo jest, jako jsem učinil. ");
INSERT INTO ces1613_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nýbrž dokavadž země trvati bude, setí a žeň, studeno i horko, léto a zima, den také a noc nepřestanou. ");
INSERT INTO ces1613_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Tedy požehnal Bůh Noé i synům jeho a řekl jim: Ploďtež se a rozmnožujte se, a naplňte zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Strach váš a hrůza vaše buď na všeliký živočich země, a na všecko ptactvo nebeské. Všecko, což se hýbe na zemi, a všecky ryby mořské v ruce vaše dány jsou. ");
INSERT INTO ces1613_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Všecko, což se hýbe a jest živo, bude vám za pokrm; jako i bylinu zelenou, dal jsem vám to všecko. ");
INSERT INTO ces1613_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","A však masa s duší jeho, kteráž jest krev jeho, nebudete jísti. ");
INSERT INTO ces1613_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","A zajisté krve vaší, duší vašich vyhledávati budu; z rukou každého hovada vyhledávati jí budu, i z ruky člověka, ano i z ruky každého bratra jeho budu vyhledávati duše člověka. ");
INSERT INTO ces1613_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kdo by koli vylil krev člověka, skrze člověka vylita bude krev jeho; nebo k obrazu svému učinil Bůh člověka. ");
INSERT INTO ces1613_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Vy pak ploďte a množte se; v hojnosti se rozploďte na zemi, a rozmnoženi buďte na ní. ");
INSERT INTO ces1613_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","I mluvil Bůh k Noé a synům jeho s ním, řka: ");
INSERT INTO ces1613_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Já zajisté vcházím v smlouvu svou s vámi, i s semenem vaším po vás, ");
INSERT INTO ces1613_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","A se všelikou duší živou, kteráž jest s vámi, z ptactva, z hovad a ze všech živočichů zemských, kteříž jsou s vámi, ode všech, kteříž vyšli z korábu, až do všelikého živočicha zemského. ");
INSERT INTO ces1613_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Protož utvrzuji smlouvu svou s vámi, že nebude vyhlazeno více všeliké tělo vodami potopy; aniž bude více potopa k zkažení země. ");
INSERT INTO ces1613_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","I řekl Bůh: Totoť bude znamení smlouvy, kteréž já dávám, mezi mnou a mezi vámi, a mezi všelikou duší živou, kteráž jest s vámi, po všecky věky. ");
INSERT INTO ces1613_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Duhu svou postavil jsem na oblaku, a bude na znamení smlouvy mezi mnou a mezi zemí. ");
INSERT INTO ces1613_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","A budeť, když uvedu mračný oblak nad zemí, a ukáže se duha na oblaku, ");
INSERT INTO ces1613_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Že se rozpomenu na smlouvu svou, kteráž jest mezi mnou a mezi vámi a mezi všelikou duší živou v každém těle; a nebudou více vody ku potopě, aby zahladily všeliké tělo. ");
INSERT INTO ces1613_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nebo když bude duha ta na oblaku, popatřím na ni, abych se rozpomenul na smlouvu věčnou mezi Bohem a mezi všelikou duší živou v každém těle, kteréž jest na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","I řekl Bůh k Noé: Toť jest znamení smlouvy, kterouž jsem utvrdil mezi sebou a mezi všelikým tělem, kteréž jest na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Byli pak synové Noé, kteříž vyšli z korábu: Sem, Cham a Jáfet; a Cham byl otec Kanánův. ");
INSERT INTO ces1613_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ti tři jsou synové Noé, a ti se rozprostřeli po vší zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé pak obíraje se s zemí, začal dělati vinice. ");
INSERT INTO ces1613_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","A pije víno, opil se, a obnažil se u prostřed stanu svého. ");
INSERT INTO ces1613_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Viděl pak Cham, otec Kanánův, hanbu otce svého, a pověděl oběma bratřím svým vně. ");
INSERT INTO ces1613_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tedy vzali Sem a Jáfet oděv, kterýžto oba položili na ramena svá, a jdouce zpátkem, zakryli hanbu otce svého; tváři pak jich byly odvráceny, a hanby otce svého neviděli. ");
INSERT INTO ces1613_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Procítiv pak Noé po svém víně, zvěděl, co mu učinil syn jeho mladší. ");
INSERT INTO ces1613_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","I řekl: Zlořečený Kanán, služebník služebníků bude bratřím svým. ");
INSERT INTO ces1613_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Řekl také: Požehnaný Hospodin, Bůh Semův, a buď Kanán služebníkem jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Rozšiřiž Bůh milostivě Jáfeta, aby bydlil v stáncích Semových, a buď Kanán služebníkem jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Živ pak byl Noé po potopě tři sta a padesáte let. ");
INSERT INTO ces1613_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","A tak bylo všech dnů Noé devět set a padesáte let; i umřel jest. ");
INSERT INTO ces1613_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tito jsou pak rodové synů Noé, Sema, Chama a Jáfeta, jimž se tito synové zrodili po potopě. ");
INSERT INTO ces1613_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Synové Jáfetovi: Gomer a Magog, a Madai, a Javan, a Tubal, a Mešech, a Tiras. ");
INSERT INTO ces1613_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Synové pak Gomerovi: Ascenez, Rifat, a Togorma. ");
INSERT INTO ces1613_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Synové pak Javanovi: Elisa a Tarsis, Cetim a Dodanim. ");
INSERT INTO ces1613_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Od těch rozděleni jsou ostrovové národů po krajinách jejich, každý podlé jazyku svého, vedlé čeledi své, v národech svých. ");
INSERT INTO ces1613_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Synové pak Chamovi: Chus a Mizraim a Put a Kanán. ");
INSERT INTO ces1613_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","A synové Chusovi: Sába, Evila, a Sabata, a Regma, a Sabatacha. Synové pak Regmovi: Sába a Dedan. ");
INSERT INTO ces1613_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Zplodil také Chus Nimroda; onť jest počal býti mocným na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","To byl silný lovec před Hospodinem; protož se říká: Jako Nimrod silný lovec před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Počátek pak jeho království byl Babylon a Erech, Achad a Chalne, v zemi Sinear. ");
INSERT INTO ces1613_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Z země té vyšel do Assur, kdežto vystavěl Ninive, a Rohobot město, a Chále, ");
INSERT INTO ces1613_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","A Rezen mezi Ninive a mezi Chále; toť jest město veliké. ");
INSERT INTO ces1613_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim pak zplodil Ludim a Anamim, a Laabim, a Neftuim, ");
INSERT INTO ces1613_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","A Fetruzim, a Chasluim, (odkudž pošli Filistinští) a Kafturim. ");
INSERT INTO ces1613_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanán pak zplodil Sidona prvorozeného svého, a Het, ");
INSERT INTO ces1613_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","A Jebuzea, a Amorea, a Gergezea, ");
INSERT INTO ces1613_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","A Hevea, a Aracea, a Sinea, ");
INSERT INTO ces1613_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","A Aradia, a Samarea, a Amatea; a potom odtud rozprostřely se čeledi Kananejských. ");
INSERT INTO ces1613_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","A bylo pomezí Kananejských od Sidonu, když jdeš k Gerar až do Gázy; a odtud když jdeš k Sodomě a Gomoře, a Adama a Seboim až do Lázy. ");
INSERT INTO ces1613_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ti jsou synové Chamovi po čeledech svých, vedlé jazyků svých, po krajinách svých, v národech svých. ");
INSERT INTO ces1613_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semovi také, otci všech synů Heber, bratru Jáfeta staršího zrozeni jsou synové. ");
INSERT INTO ces1613_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","A tito jsou synové Semovi: Elam, a Assur, a Arfaxad, a Lud, a Aram. ");
INSERT INTO ces1613_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Synové pak Aramovi: Hus, a Hul, a Geter, a Mas. ");
INSERT INTO ces1613_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Potom Arfaxad zplodil Sále; a Sále zplodil Hebera. ");
INSERT INTO ces1613_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Heberovi také narodili se dva synové; jméno jednoho Peleg, proto že za dnů jeho rozdělena byla země, a jméno bratra jeho Jektan. ");
INSERT INTO ces1613_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jektan pak zplodil Elmodada, a Salefa, a Azarmota, a Járe, ");
INSERT INTO ces1613_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","A Adoráma, a Uzala, a Dikla, ");
INSERT INTO ces1613_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","A Obale, a Abimahele, a Sebai, ");
INSERT INTO ces1613_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","A Ofira, a Evila, a Jobaba; všickni ti jsou synové Jektanovi. ");
INSERT INTO ces1613_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","A bylo bydlení jejich od Mesa, když jdeš k Sefar hoře na východ slunce. ");
INSERT INTO ces1613_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tiť jsou synové Semovi po čeledech svých, vedlé jazyků svých, po krajinách svých, v národech svých. ");
INSERT INTO ces1613_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ty jsou čeledi synů Noé po rodech svých, v národech svých; a od těch rozdělili se národové na zemi po potopě. ");
INSERT INTO ces1613_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Byla pak všecka země jazyku jednoho a řeči jedné. ");
INSERT INTO ces1613_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","I stalo se, když se brali od východu, nalezli pole v zemi Sinear, a bydlili tam. ");
INSERT INTO ces1613_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","A řekli jeden druhému: Nuže, nadělejme cihel, a vypalme je ohněm. I měli cihly místo kamení, a zemi lepkou místo vápna. ");
INSERT INTO ces1613_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nebo řekli: Nuže, vystavějme sobě město a věži, jejíž by vrch dosahal k nebi; a tak učiňme sobě jméno, abychom nebyli rozptýleni po vší zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Sstoupil pak Hospodin, aby viděl to město a věži, kterouž stavěli synové lidští. ");
INSERT INTO ces1613_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","A řekl Hospodin: Aj, lid jeden a jazyk jeden všechněch těchto, a toť jest začátek díla jejich; nyní pak nedadí sobě v tom překaziti, což umínili dělati. ");
INSERT INTO ces1613_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Protož sstupme a změťme tam jazyk jejich, aby jeden druhého jazyku nerozuměl. ");
INSERT INTO ces1613_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","A tak rozptýlil je Hospodin odtud po vší zemi; i přestali stavěti města toho. ");
INSERT INTO ces1613_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Protož nazváno jest jméno jeho Bábel; nebo tu zmátl Hospodin jazyk vší země; a odtud rozptýlil je Hospodin po vší zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Titoť jsou rodové Semovi: Sem, když byl ve stu letech, zplodil Arfaxada ve dvou letech po potopě. ");
INSERT INTO ces1613_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A byl živ Sem po zplození Arfaxada pět set let; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad pak živ byl pět a třidceti let, a zplodil Sále. ");
INSERT INTO ces1613_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","A po zplození Sále živ byl Arfaxad čtyři sta a tři léta; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sále také živ byl třidceti let, a zplodil Hebera. ");
INSERT INTO ces1613_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","A živ byl Sále po zplození Hebera čtyři sta a tři léta; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Živ pak byl Heber čtyři a třidceti let, a zplodil Pelega. ");
INSERT INTO ces1613_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","A živ byl Heber po zplození Pelega čtyři sta a třidceti let; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg pak živ byl třidceti let, a zplodil Réhu. ");
INSERT INTO ces1613_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","A živ byl Peleg po zplození Réhu dvě stě a devět let; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Réhu také živ byl třidceti a dvě létě, a zplodil Sáruga. ");
INSERT INTO ces1613_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","A po zplození Sáruga živ byl Réhu dvě stě a sedm let; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Živ pak byl Sárug třidceti let, a zplodil Náchora. ");
INSERT INTO ces1613_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","A byl živ Sárug po zplození Náchora dvě stě let; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Náchor pak živ byl dvadceti a devět let, a zplodil Táre. ");
INSERT INTO ces1613_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","A živ byl Náchor po zplození Táre sto a devatenácte let; a plodil syny a dcery. ");
INSERT INTO ces1613_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Živ pak byl Táre sedmdesáte let, a zplodil Abrama, Náchora a Hárana. ");
INSERT INTO ces1613_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tito jsou pak rodové Táre: Táre zplodil Abrama, Náchora a Hárana; Háran pak zplodil Lota. ");
INSERT INTO ces1613_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Umřel pak Háran prvé než Táre otec jeho v zemi narození svého, totiž v Ur Kaldejských. ");
INSERT INTO ces1613_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","I zpojímali sobě ženy Abram a Náchor; jméno ženy Abramovy Sarai, a jméno ženy Náchorovy Melcha, dcera Háranova, kterýž byl otec Melchy a Jeschy. ");
INSERT INTO ces1613_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Byla pak Sarai neplodná, a neměla dětí. ");
INSERT INTO ces1613_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","I vzal Táre Abrama syna svého, a Lota syna Háranova, vnuka svého, a Sarai nevěstu svou, ženu Abrama syna svého, a vyšli spolu z Ur Kaldejských, aby se brali do země Kananejské, a přišli až do Cháran, a bydlili tam. ");
INSERT INTO ces1613_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","A byli dnové Táre dvě stě a pět let; i umřel Táre v Cháran. ");
INSERT INTO ces1613_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nebo byl řekl Hospodin Abramovi: Vyjdi z země své a z příbuznosti své, i z domu otce svého do země, kterouž ukáži tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","A učiním tě v národ veliký, a požehnám tobě, a zvelebím jméno tvé, a budeš požehnání. ");
INSERT INTO ces1613_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Požehnám také dobrořečícím tobě, a zlořečícím tobě zlořečiti budu; ano požehnány budou v tobě všecky čeledi země. ");
INSERT INTO ces1613_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","I vyšel Abram, tak jakž mu byl mluvil Hospodin, a šel s ním Lot. (Byl pak Abram v sedmdesáti pěti letech, když vyšel z Cháran.) ");
INSERT INTO ces1613_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","A vzal Abram Sarai manželku svou, a Lota syna bratra svého, a všecko zboží své, kteréhož nabyli, i duše, kterýchž dosáhli v Cháran. A vyšedše, brali se do země Kananejské, až i přišli do ní. ");
INSERT INTO ces1613_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","I prošel Abram tu zemi až k místu Sichem, to jest až k rovině More. A tehdáž Kananejští byli v zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","I ukázal se Hospodin Abramovi a řekl: Semeni tvému dám zemi tuto. Tedy vzdělal tu oltář Hospodinu, kterýž se byl ukázal jemu. ");
INSERT INTO ces1613_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","A odtud podal se k hoře, kteráž leží na východ od Bethel, kdežto rozbil stan svůj, tak že mu Bethel byl na západ, Hai pak na východ; i vzdělal tam oltář Hospodinu, a vzýval jméno Hospodinovo. ");
INSERT INTO ces1613_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Potom hnul se Abram dále, a odebral se odtud ku poledni. ");
INSERT INTO ces1613_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Byl pak hlad v té zemi; protož sstoupil Abram do Egypta, aby tam byl pohostinu; nebo veliký byl hlad v té zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","I stalo se, že když přicházel blízko k Egyptu, řekl k Sarai manželce své: Aj, nyní znám, že jsi žena krásné tváři. ");
INSERT INTO ces1613_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","A stane se, že když tě uzří Egyptští, řeknou: To jest manželka jeho; i zabijí mne, tebe pak živé nechají. ");
INSERT INTO ces1613_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Prav medle, že jsi sestra má, aby mi dobře bylo příčinou tvou, a živa zůstala duše má pro tebe. ");
INSERT INTO ces1613_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","I stalo se, když všel Abram do Egypta, viděli Egyptští ženu, že krásná byla náramně. ");
INSERT INTO ces1613_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","A vidouce ji knížata Faraonova, schválili ji před ním; i vzata jest žena do domu Faraonova. ");
INSERT INTO ces1613_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kterýžto i Abramovi dobře učinil pro ni; a měl ovce a voly a osly, i služebníky a děvky, též oslice a velbloudy. ");
INSERT INTO ces1613_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ale Hospodin trápil Faraona ranami velikými, i dům jeho, pro Sarai manželku Abramovu. ");
INSERT INTO ces1613_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Protož povolal Farao Abrama a řekl: Cos mi to učinil? Pročežs mi neoznámil, že ona manželka tvá jest? ");
INSERT INTO ces1613_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Proč jsi řekl: Sestra má jest? A vzal jsem ji sobě za ženu. Protož nyní, teď máš manželku svou, vezmi a jdi. ");
INSERT INTO ces1613_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","I poručil o něm Farao mužům, a propustili ho, i manželku jeho i všecko, což měl. ");
INSERT INTO ces1613_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Vstoupil tedy Abram z Egypta on i žena jeho i všecko, což měl, a Lot s ním, ku poledni. ");
INSERT INTO ces1613_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","(Byl pak Abram bohatý velmi na dobytek, na stříbro i na zlato.) ");
INSERT INTO ces1613_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A šel cestami svými od poledne až do Bethel, až k místu tomu, kdež prvé byl stánek jeho, mezi Bethel a Hai, ");
INSERT INTO ces1613_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","K místu oltáře, kterýž tam byl prvé vzdělal, kdežto vzýval Abram jméno Hospodinovo. ");
INSERT INTO ces1613_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Také i Lot, kterýž s Abramem chodil, měl ovce a voly i stany. ");
INSERT INTO ces1613_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","A nemohla jim země postačovati, aby spolu bydlili, proto že zboží jich bylo veliké, tak že nemohli spolu bydliti. ");
INSERT INTO ces1613_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Odkudž vznikla nesnáz mezi pastýři stáda Abramova a mezi pastýři stáda Lotova; nebo Kananejští a Ferezejští tehdáž bydlili v zemi té. ");
INSERT INTO ces1613_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Řekl tedy Abram k Lotovi: Nechžť, prosím, není nesnáze mezi mnou a tebou, a mezi pastýři mými a pastýři tvými, poněvadž muži bratří jsme. ");
INSERT INTO ces1613_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Zdaliž není před tebou všecka země? Odděl se, prosím, ode mne. Půjdeš-li na levo, já na pravo se držeti budu; pakli půjdeš na pravo, na levo se držeti budu. ");
INSERT INTO ces1613_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Pozdvih tedy Lot očí svých, spatřil všecku rovinu vůkol Jordánu, kteráž před tím, než Hospodin zkazil Sodomu a Gomoru, všecka až k Ségor svlažována byla, jako zahrada Hospodinova, a jako země Egyptská. ");
INSERT INTO ces1613_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","I zvolil sobě Lot všecku rovinu Jordánskou, a bral se k východu; a tak oddělili se jeden od druhého. ");
INSERT INTO ces1613_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram bydlil v zemi Kananejské, ale Lot přebýval v městech té roviny, podav stanů až k Sodomě. ");
INSERT INTO ces1613_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Lidé pak Sodomští byli zlí, a hříšníci před Hospodinem velicí. ");
INSERT INTO ces1613_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","I řekl Hospodin Abramovi, když se oddělil od něho Lot: Pozdvihni nyní očí svých, a pohleď z místa, na němž jsi, na půlnoci a na poledne, i na východ a na západ. ");
INSERT INTO ces1613_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nebo všecku zemi, kterouž vidíš, tobě dám a semeni tvému až na věky. ");
INSERT INTO ces1613_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","A rozmnožím símě tvé jako prach země; nebo jestliže kdo bude moci sčísti prach země, tedy i símě tvé sečteno bude. ");
INSERT INTO ces1613_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Vstaň, projdi tu zemi na dýl i na šíř její; nebo tobě ji dám. ");
INSERT INTO ces1613_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tedy Abram hnuv se s stanem, přišel a bydlil v rovinách Mamre, kteréž jsou při Hebronu, kdežto vzdělal oltář Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Stalo se pak ve dnech těch, že Amrafel král Sinearský, Arioch král Elasarský, Chedorlaomer král Elamitský, a Thádal král Goimský, ");
INSERT INTO ces1613_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Vyzdvihli válku proti Bérovi králi Sodomskému, a proti Bersovi králi Gomorskému, a Senábovi králi Adamatskému, a Semeberovi králi Seboimskému, a králi Bélamskému, to jest Ségorskému. ");
INSERT INTO ces1613_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Všickni tito sjeli se do údolí Siddim, to jest již moře solné. ");
INSERT INTO ces1613_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dvanácte let sloužili Chedorlaomerovi, třináctého pak léta zprotivili se. ");
INSERT INTO ces1613_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Protož léta čtrnáctého přitáhl Chedorlaomer a králové, kteříž byli s ním, a pobili Refaimské v Astarotu Karnaimských, a Zuzimské v Cham, a Eminské na rovinách Kariataimských, ");
INSERT INTO ces1613_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","A Horejské na hoře jich Seir, až k rovině Fáran, kteráž leží nad pouští. ");
INSERT INTO ces1613_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","A vracejíce se, přitáhli k En Misfat, kteráž již jest Kádes, a pohubili všecku krajinu Amalechitského, také i Amorejského, bydlícího v Hasesontamar. ");
INSERT INTO ces1613_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Protož vytáhl král Sodomský, a král Gomorský, a král Adamatský, a král Seboimský, a král Bélamský, to jest Ségorský, a sšikovali se proti nim k bitvě v údolí Siddim, ");
INSERT INTO ces1613_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Proti Chedorlaomerovi králi Elamitskému, a Thádalovi králi Goimskému, a Amrafelovi králi Sinearskému, i Ariochovi králi Elasarskému, čtyři králové proti pěti. ");
INSERT INTO ces1613_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","(V údolí pak Siddim bylo mnoho studnic klejovatých.) I utíkajíce král Sodomský a Gomorský, padli tam; a kteří pozůstali, utekli na hory. ");
INSERT INTO ces1613_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","A pobravše všecko zboží Sodomských a Gomorských, a všecky potravy jich, odtáhli. ");
INSERT INTO ces1613_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Vzali také Lota, a zboží jeho, syna bratra Abramova, a odjeli; nebo on bydlil v Sodomě. ");
INSERT INTO ces1613_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Přišel pak jeden, kterýž byl utekl, a zvěstoval Abramovi Hebrejskému, kterýž tehdáž bydlil v rovinách Mamre Amorejského, bratra Eškolova a bratra Anerova; nebo ti měli smlouvu s Abramem. ");
INSERT INTO ces1613_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Uslyšev tedy Abram, že by zajat byl bratr jeho, vypravil způsobných k boji a v domě svém zrozených služebníků tři sta a osmnácte, a honil je až k Dan. ");
INSERT INTO ces1613_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","A odděliv se, připadl na ně v noci, on i služebníci jeho, a porazil je; a stihal je až k Chobah, kteréž leží na levo Damašku. ");
INSERT INTO ces1613_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","I odjal zase všecko zboží; také i Lota bratra svého s statkem jeho zase přivedl, ano i ženy a lid. ");
INSERT INTO ces1613_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Tedy vyšel král Sodomský proti němu, když se navracoval od pobití Chedorlaomera a králů, kteříž byli s ním, k údolí Sáveh, kteréž jest údolí královské. ");
INSERT INTO ces1613_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchisedech také král Sálem, vynesl chléb a víno; a ten byl kněz Boha silného nejvyššího. ");
INSERT INTO ces1613_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I požehnal mu a řekl: Požehnaný Abram Bohu silnému nejvyššímu, kterýž vládne nebem a zemí; ");
INSERT INTO ces1613_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","A požehnaný Bůh silný nejvyšší, kterýž dal nepřátely tvé v ruce tvé. I dal mu Abram desátky ze všech věcí. ");
INSERT INTO ces1613_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Král pak Sodomský řekl Abramovi: Dej mi lid, a zboží vezmi sobě. ");
INSERT INTO ces1613_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","I řekl Abram králi Sodomskému: Pozdvihl jsem ruky své k Hospodinu, Bohu silnému nejvyššímu, kterýž vládne nebem i zemí, ");
INSERT INTO ces1613_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Že nevezmu od niti až do řeménka obuvi ze všech věcí, kteréž jsou tvé, abys neřekl: Já jsem obohatil Abrama, ");
INSERT INTO ces1613_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kromě toliko toho, což snědli bojovníci, a dílu mužů, kteříž se mnou šli, totiž Aner, Eškol a Mamre; oni nechať vezmou díl svůj. ");
INSERT INTO ces1613_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Když pak ty věci pominuly, stalo se slovo Hospodinovo k Abramovi u vidění, řkoucí: Neboj se, Abrame; já budu pavéza tvá, a odplata tvá velmi veliká. ");
INSERT INTO ces1613_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Jemužto řekl Abram: Panovníče Hospodine, což mi dáš, poněvadž já scházím bez dětí, a ten, jemuž zanechám domu svého, bude Damašský Eliezer? ");
INSERT INTO ces1613_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Řekl ještě Abram: Aj, mně jsi nedal semene; a aj, schovanec můj bude mým dědicem. ");
INSERT INTO ces1613_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","A aj, slovo Hospodinovo k němu, řkuci: Nebudeť ten dědicem tvým, ale kterýž vyjde z života tvého, ten dědicem tvým bude. ");
INSERT INTO ces1613_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","I vyvedl jej ven a řekl: Vzhlédniž nyní k nebi, a sečti hvězdy, budeš-li je však moci sčísti? Řekl mu ještě: Tak bude símě tvé. ");
INSERT INTO ces1613_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","I uvěřil Hospodinu, a počteno mu to za spravedlnost. ");
INSERT INTO ces1613_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","(Nebo byl řekl jemu: Já jsem Hospodin, kterýž jsem tě vyvedl z Ur Kaldejských, aťbych dal zemi tuto k dědičnému vládařství. ");
INSERT INTO ces1613_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","I řekl: Panovníče Hospodine, po čem poznám, že ji dědičně obdržím? ");
INSERT INTO ces1613_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","I odpověděl jemu: Vezmi mně jalovici tříletou, a kozu tříletou, a skopce tříletého, hrdličku také a holoubátko. ");
INSERT INTO ces1613_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kterýžto vzav ty všecky věci, zroztínal je na poly, a rozložil na dvě straně, jednu polovici proti druhé; ptáků pak nezroztínal. ");
INSERT INTO ces1613_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ptáci pak sedali na ta mrtvá těla, a Abram je sháněl. ");
INSERT INTO ces1613_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","I stalo se, když slunce zapadalo, že dřímota těžká připadla na Abrama; a aj, hrůza a tma veliká obklíčila jej). ");
INSERT INTO ces1613_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Řekl tedy Bůh Abramovi: To zajisté věz, že pohostinu bude símě tvé v zemi cizí, a v službu je podrobí, a trápiti je budou za čtyři sta let. ");
INSERT INTO ces1613_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Však národ, jemuž sloužiti budou, já souditi budu; a potom vyjdou s velikým zbožím. ");
INSERT INTO ces1613_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ty pak půjdeš k otcům svým v pokoji; a pohřben budeš v starosti dobré. ");
INSERT INTO ces1613_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A čtvrté pokolení sem se navrátí; nebť ještě není doplněna nepravost Amorejských. ");
INSERT INTO ces1613_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","I stalo se, když zapadlo slunce, a tma bylo, a aj, ukázala se pec kouřící se, a pochodně ohnivá, kteráž šla mezi díly těmi. ");
INSERT INTO ces1613_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","V ten den učinil Hospodin smlouvu s Abramem, řka: Semeni tvému dám zemi tuto, od řeky Egyptské až do řeky té veliké, řeky Eufraten: ");
INSERT INTO ces1613_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Cinejské, Cenezejské, Cethmonské, ");
INSERT INTO ces1613_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","A Hetejské, Ferezejské, a Refaimské, ");
INSERT INTO ces1613_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorejské, i Kananejské také, a Gergezejské a Jebuzejské. ");
INSERT INTO ces1613_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai pak manželka Abramova jemu nerodila; a měla děvku Egyptskou, jménem Agar. ");
INSERT INTO ces1613_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","I řekla Sarai Abramovi: Aj, nyní Hospodin zavřel život můj, abych nerodila; vejdi, prosím, k děvce mé, zda bych aspoň z ní mohla míti syny. I povolil Abram řeči Sarai. ");
INSERT INTO ces1613_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tedy vzavši Sarai manželka Abramova Agar Egyptskou děvku svou, po desíti letech, jakž bydliti počal Abram v zemi Kananejské, dala ji Abramovi muži svému za ženu. ");
INSERT INTO ces1613_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","I všel k Agar, kterážto počala. Viduci pak ona, že počala, zlehčila sobě paní svou. ");
INSERT INTO ces1613_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","I řekla Sarai Abramovi: Křivdou mou tys vinen; já jsem dala děvku svou v lůno tvé, kterážto viduci, že počala, zlehčila mne sobě. Sudiž Hospodin mezi mnou a mezi tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","I řekl Abram k Sarai: Aj, děvka tvá v moci tvé; učiň s ní, cožť se za dobré vidí. Tedy trápila ji Sarai, a ona utekla od ní. ");
INSERT INTO ces1613_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Našel ji pak anděl Hospodinův u studnice vody na poušti, u studnice té, kteráž jest při cestě Sur. ");
INSERT INTO ces1613_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","A řekl: Agar, děvko Sarai, odkud jdeš, a kam se béřeš? I řekla: Od tváři Sarai paní své já utíkám. ");
INSERT INTO ces1613_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tedy řekl jí anděl Hospodinův: Navrať se ku paní své, a pokoř se pod ruku její. ");
INSERT INTO ces1613_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Opět řekl anděl Hospodinův: Velice rozmnožím símě tvé, aniž bude moci sečteno býti pro množství. ");
INSERT INTO ces1613_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Potom také řekl anděl Hospodinův: Aj, ty jsi těhotná, a tudíž porodíš syna, a nazůveš jméno jeho Izmael; nebo uslyšel Hospodin trápení tvé. ");
INSERT INTO ces1613_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Budeť pak lítý člověk; ruce jeho proti všechněm, a ruce všech proti němu; a před tváří všech bratří svých bydliti bude. ");
INSERT INTO ces1613_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","I nazvala Agar jméno Hospodinovo, kterýž mluvil jí: Ty jsi silný Bůh vidění; nebo řekla: Zdaliž teď také nevidím po tom, kterýž mne viděl? ");
INSERT INTO ces1613_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Protož nazvala studnici tu studnicí Živého vidoucího mne. Aj, ta jest mezi Kádes a Barad. ");
INSERT INTO ces1613_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Porodila pak Agar Abramovi syna; a nazval Abram jméno syna svého, kteréhož porodila Agar, Izmael. ");
INSERT INTO ces1613_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram pak byl v osmdesáti šesti letech, když mu porodila Agar Izmaele. ");
INSERT INTO ces1613_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Když pak Abram byl v devadesáti devíti letech, ukázal se mu Hospodin, a řekl jemu: Já jsem Bůh silný všemohoucí; chodiž ustavičně přede mnou a budiž dokonalým. ");
INSERT INTO ces1613_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","A učiním smlouvu svou mezi sebou a tebou a rozmnožím tě náramně velmi. ");
INSERT INTO ces1613_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Padl pak Abram na tvář svou; i mluvil Bůh s ním, řka: ");
INSERT INTO ces1613_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Jáť jsem, aj, smlouva má s tebou, a budeš otcem národů mnohých. ");
INSERT INTO ces1613_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Aniž více slouti bude jméno tvé Abram, ale bude jméno tvé Abraham; nebo otcem mnohých národů učinil jsem tě. ");
INSERT INTO ces1613_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","A učiním, abys se rozplodil náramně velmi, a rozšířím tě v národy; i králové z tebe vyjdou. ");
INSERT INTO ces1613_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Utvrdím také smlouvu svou mezi sebou a tebou, i mezi semenem tvým po tobě, po rodech jejich, za smlouvu věčnou, totiž abych byl Bohem tvým i semene tvého po tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nadto dám tobě i semeni tvému po tobě zemi, v nížto obýváš pohostinu, všecku zemi Kananejskou k vládařství věčnému; a budu jejich Bohem. ");
INSERT INTO ces1613_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Řekl ještě Bůh Abrahamovi: Ty pak ostříhati budeš smlouvy mé, ty i símě tvé po tobě, po rodech svých. ");
INSERT INTO ces1613_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tatoť jest smlouva má mezi mnou a mezi vámi, i mezi semenem tvým po tobě, kteréž ostříhati budete: Aby obřezán byl mezi vámi každý pohlaví mužského. ");
INSERT INTO ces1613_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Obřežete pak tělo hanby své; a to bude znamením smlouvy mezi mnou a mezi vámi. ");
INSERT INTO ces1613_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Každý tedy pohlaví mužského osmého dne obřezán bude mezi vámi po rodech vašich, doma narozený i koupený za stříbro, z kterých by koli cizozemců byl, jenž není z semene tvého. ");
INSERT INTO ces1613_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Konečně ať jest obřezán narozený v domě tvém, i koupený za peníze tvé; a budeť smlouva má na těle vašem za smlouvu věčnou. ");
INSERT INTO ces1613_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Neobřezaný pak pacholík, kterýž by neobřezal těla neobřízky své, vyhlazena zajisté bude duše ta z lidu svého; nebo smlouvu mou zrušil. ");
INSERT INTO ces1613_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Řekl také Bůh Abrahamovi: Sarai manželce své nebudeš říkati Sarai, ale Sára bude jméno její. ");
INSERT INTO ces1613_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nebo požehnám jí a dámť z ní syna; požehnámť jí, a bude v národy; králové národů z ní vyjdou. ");
INSERT INTO ces1613_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tedy padl Abraham na tvář svou, a zasmáv se, řekl v srdci svém: Zdali stoletému narodí se syn? A zdali Sára v devadesáti letech porodí? ");
INSERT INTO ces1613_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","I řekl Abraham Bohu: Ó byť jen Izmael živ byl před tebou! ");
INSERT INTO ces1613_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Jemužto řekl Bůh: Nýbrž Sára manželka tvá porodí tobě syna, a nazůveš jméno jeho Izák; i utvrdím smlouvu svou s ním za smlouvu věčnou, i s semenem jeho po něm. ");
INSERT INTO ces1613_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Také o Izmaele uslyšel jsem tě; a aj, požehnám jemu, a učiním to, aby se rozplodil, a rozmnožím ho náramně velmi; dvanáctero knížat zplodí, a rozšířím jej v národ veliký. ");
INSERT INTO ces1613_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ale smlouvu svou utvrdím s Izákem, kteréhožť porodí Sára po roce, při tomto času. ");
INSERT INTO ces1613_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","A když dokonal Bůh řeč svou s ním, vstoupil od Abrahama. ");
INSERT INTO ces1613_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Vzal tedy Abraham Izmaele syna svého, i všecky zrozené v domě svém, i všecky koupené za stříbro své, každého, kdož byl pohlaví mužského, z domácích svých, a obřezal tělo neobřízky jejich hned v ten den, jakž s ním Bůh mluvil. ");
INSERT INTO ces1613_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","A byl Abraham v devadesáti devíti letech, když obřezáno bylo tělo neobřízky jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Izmael pak syn jeho byl v třinácti letech, když obřezáno bylo tělo neobřízky jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Jednoho a téhož dne obřezáni jsou, Abraham a Izmael syn jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","I všickni domácí jeho, doma zrození i za stříbro od cizozemce koupení, obřezáni jsou s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ukázal se pak jemu Hospodin v rovině Mamre; a on seděl u dveří stanu, když veliké horko na den bylo. ");
INSERT INTO ces1613_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A když pozdvihl očí svých, viděl, a aj, tři muži stáli naproti němu. Kteréžto jakž uzřel, běžel jim vstříc ode dveří stanu, a sklonil se až k zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","A řekl: Pane můj, jestliže jsem nyní nalezl milost před očima tvýma, prosím, nepomíjej služebníka svého. ");
INSERT INTO ces1613_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Přineseno bude trochu vody, a umyjete nohy své, a odpočinete pod stromem. ");
INSERT INTO ces1613_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Zatím přinesu kus chleba, a posilníte srdce svého; potom půjdete, poněvadž mimo služebníka svého jdete. I řekli: Tak učiň, jakž jsi mluvil. ");
INSERT INTO ces1613_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tedy pospíšil Abraham do stanu k Sáře, a řekl: Spěšně tři míry mouky bělné zadělej, a napec podpopelných chlebů. ");
INSERT INTO ces1613_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham pak běžel k stádu; a vzav tele mladé a dobré, dal služebníku, kterýžto pospíšil připraviti je. ");
INSERT INTO ces1613_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Potom vzav másla a mléka, i tele, kteréž připravil, položil před ně; sám pak stál při nich pod stromem, i jedli. ");
INSERT INTO ces1613_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Řekli pak jemu: Kde jest Sára manželka tvá? Kterýžto odpověděl: Teď v stanu. ");
INSERT INTO ces1613_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","A řekl: Jistotně se navrátím k tobě vedlé času života, a aj, syna míti bude Sára manželka tvá. Ale Sára poslouchala u dveří stanu, kteréž byly za ním. ");
INSERT INTO ces1613_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham pak i Sára byli staří a sešlého věku, a přestal byl Sáře běh ženský. ");
INSERT INTO ces1613_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","I smála se Sára sama v sobě, řkuci: Teprv když jsem se sstarala, v rozkoše se vydám? A ještě i pán můj se sstaral. ");
INSERT INTO ces1613_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tedy řekl Hospodin Abrahamovi: Proč jest se smála Sára, řkuci: Zdaliž opravdu ještě roditi budu, a já se sstarala? ");
INSERT INTO ces1613_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Zdaliž co skrytého bude před Hospodinem? K času určitému navrátím se k tobě vedlé času života, a Sára bude míti syna. ");
INSERT INTO ces1613_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Zapřela pak Sára a řekla: Nesmála jsem se; nebo se bála. I řekl Hospodin: Neníť tak, ale smála jsi se. ");
INSERT INTO ces1613_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tedy vstavše odtud muži ti, obrátili se k Sodomě; Abraham pak šel s nimi, aby je provodil. ");
INSERT INTO ces1613_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","A řekl Hospodin: Zdali já zatajím před Abrahamem, což dělati budu? ");
INSERT INTO ces1613_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Poněvadž Abraham jistotně bude v národ veliký a silný, a požehnáni budou v něm všickni národové země. ");
INSERT INTO ces1613_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nebo znám jej; protož přikáže synům svým a domu svému po sobě, aby ostříhali cesty Hospodinovy, a činili spravedlnost a soud, aťby naplnil Hospodin Abrahamovi, což mu zaslíbil. ");
INSERT INTO ces1613_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","I řekl Hospodin: Proto že rozmnožen jest křik Sodomských a Gomorských, a hřích jejich že obtížen jest náramně: ");
INSERT INTO ces1613_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Sstoupím již a pohledím, jestliže podle křiku jejich, kterýž přišel ke mně, činili, důjde na ně setření; a pakli toho není, zvím. ");
INSERT INTO ces1613_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","A obrátivše se odtud muži, šli do Sodomy; Abraham pak ještě stál před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","V tom přistoupiv Abraham, řekl: Zdali také zahladíš spravedlivého s bezbožným? ");
INSERT INTO ces1613_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bude-li padesáte spravedlivých v tom městě, zdali předce zahubíš, a neodpustíš místu pro padesáte spravedlivých, kteříž jsou v něm? ");
INSERT INTO ces1613_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Odstup to od tebe, abys takovou věc učiniti měl, abys usmrtil spravedlivého s bezbožným; takť by byl spravedlivý jako bezbožný. Odstup to od tebe; zdaliž soudce vší země neučiní soudu? ");
INSERT INTO ces1613_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","I řekl Hospodin: Jestliže naleznu v Sodomě, v městě tom, padesáte spravedlivých, odpustím všemu tomu místu pro ně. ");
INSERT INTO ces1613_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","A odpovídaje Abraham, řekl: Aj, nyní chtěl bych mluviti ku Pánu svému, ačkoli jsem prach a popel. ");
INSERT INTO ces1613_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Co pak, nedostane-li se ku padesáti spravedlivým pěti, zdali zkazíš pro těch pět všecko město? I řekl: Nezahladím, jestliže najdu tam čtyřidceti pět. ");
INSERT INTO ces1613_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Opět mluvil Abraham a řekl: Snad nalezeno bude tam čtyřidceti? A odpověděl: Neučiním pro těch čtyřidceti. ");
INSERT INTO ces1613_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","I řekl Abraham: Prosím, nechť se nehněvá Pán můj, že mluviti budu: Snad se jich nalezne tam třidceti? Odpověděl: Neučiním, jestliže naleznu tam třidceti. ");
INSERT INTO ces1613_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","A opět řekl: Aj, nyní počal jsem mluviti ku Pánu svému: Snad se nalezne tam dvadceti? Odpověděl: Nezahladím i pro těch dvadceti. ");
INSERT INTO ces1613_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Řekl ještě: Prosím, ať se nehněvá Pán můj, jestliže jednou ještě mluviti budu: Snad se jich najde tam deset? Odpověděl: Nezahladím i pro těch deset. ");
INSERT INTO ces1613_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","I odšel Hospodin, když dokonal řeč k Abrahamovi; Abraham pak navrátil se k místu svému. ");
INSERT INTO ces1613_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Přišli pak dva andělé do Sodomy u večer, a Lot seděl v bráně Sodomské. Kteréžto když uzřel, vstav, šel jim v cestu a sklonil se tváří až k zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","A řekl: Aj, prosím páni moji, uchylte se nyní do domu služebníka svého, a zůstaňte přes noc; umyjete také nohy své a ráno vstanouce, půjdete cestou svou. Oni pak odpověděli: Nikoli, ale přenocujeme na ulici. ");
INSERT INTO ces1613_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ale když on je velmi nutil, obrátivše se k němu, vešli do domu jeho. I udělal jim hody, a napekl chlebů přesných, i jedli. ");
INSERT INTO ces1613_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Prvé pak než lehli, muži města toho, muži Sodomští, osuli se vůkol domu toho, od mladého až do starého, všecken lid odevšad. ");
INSERT INTO ces1613_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","I volali na Lota, a řekli jemu: Kde jsou ti muži, kteříž přišli k tobě v noci? Vyveď je k nám, ať je poznáme. ");
INSERT INTO ces1613_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","I vyšel k nim Lot ven, a zavřel po sobě dvéře. ");
INSERT INTO ces1613_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","A řekl: Prosím, bratří moji, nečiňte zlého. ");
INSERT INTO ces1613_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Aj, mám teď dvě dcery, kteréžto nepoznaly muže; vyvedu je nyní k vám, čiňte s nimi, jak se vám líbí; toliko mužům těmto nic nečiňte, poněvadž vešli pod stín střechy mé. ");
INSERT INTO ces1613_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","I řekli: Odejdi tam! A mluvili: Sám se dostal sem pohostinu, a chce nás souditi? Nyní tobě hůř uděláme, než jim. I obořili se násilně na muže toho, totiž na Lota, a přistoupili, aby vylomili dvéře. ");
INSERT INTO ces1613_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tedy muži ti vztáhli ven ruku svou, a uvedli Lota k sobě do domu, a dvéře zavřeli. ");
INSERT INTO ces1613_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A ty muže, kteříž byli přede dveřmi domu, ranili slepotou velikou, od nejmenšího až do největšího, tak že ustali, hledajíce dveří. ");
INSERT INTO ces1613_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","I řekli muži k Lotovi: Máš-li ještě zde koho, buď zetě neb syny své, neb dcery své, i všecko, což máš v městě, vyveď z místa tohoto. ");
INSERT INTO ces1613_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nebo zkazíme místo toto, proto že se velmi rozmohl křik jejich před Hospodinem, a poslal nás Hospodin, abychom zkazili je. ");
INSERT INTO ces1613_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Vyšed tedy Lot, mluvil k zeťům svým, kteříž již měli pojímati dcery jeho, a řekl: Vstaňte, vyjděte z místa tohoto, nebo zkazí Hospodin město toto. Ale zdálo se zeťům jeho, jako by žertoval. ");
INSERT INTO ces1613_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","A když zasvitávalo, nutili andělé Lota, řkouce: Vstaň, vezmi ženu svou a dvě dcery své, kteréž tu jsou, abys nezahynul v pomstě města. ");
INSERT INTO ces1613_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","A když prodléval, chopili muži ruku jeho, a ruku ženy jeho, a ruku dvou dcer jeho, nebo se slitoval nad ním Hospodin; i vyvedli jej, a pustili za městem. ");
INSERT INTO ces1613_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","A stalo se, když je vedli ven, řekl jeden: Zachovejž život svůj, neohlédej se zpět, ani se zastavuj na vší této rovině; ujdi na horu, abys nezahynul. ");
INSERT INTO ces1613_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","I řekl jim Lot: Ne tak, prosím, páni moji. ");
INSERT INTO ces1613_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Aj, nyní nalezl služebník tvůj milost před očima tvýma, a veliké jest milosrdenství tvé, kteréž jsi učinil se mnou, když jsi zachoval duši mou; ale jáť nebudu moci ujíti na tu horu, aby mne nepostihlo to zlé, a umřel bych. ");
INSERT INTO ces1613_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hle, teď jest toto město blízko, do něhož bych utekl, a toť jest malé; prosím, nechť tam ujdu; však pak neveliké jest, a živa bude duše má. ");
INSERT INTO ces1613_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","I řekl k němu: Aj, uslyšel jsem žádost tvou i v této věci, abych nepodvrátil města toho, o němž jsi mluvil. ");
INSERT INTO ces1613_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pospěšiž, ujdi tam; neboť nebudu moci učiniti ničehož, dokudž tam nedojdeš. A z té příčiny nazváno jest jméno města toho Ségor. ");
INSERT INTO ces1613_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Slunce vzcházelo nad zemi, když Lot všel do Ségor. ");
INSERT INTO ces1613_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","A Hospodin dštil na Sodomu a naGomoru sirou a ohněm od Hospodina s nebe. ");
INSERT INTO ces1613_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A podvrátil ta města i všecku tu rovinu, všecky také obyvatele těch měst, i všecko, což roste z země. ");
INSERT INTO ces1613_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","I ohlédla se žena jeho, jduc za ním, a obrácena jest v sloup solný. ");
INSERT INTO ces1613_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Vstav pak Abraham ráno, pospíšil k místu tomu, kdež byl stál před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","A pohleděv k Sodomě a Gomoře, i na všecku zemi té roviny, uzřel, a aj, vystupoval dým z země té, jako dým z vápenice. ");
INSERT INTO ces1613_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Stalo se tedy, když kazil Bůh města té roviny, že se rozpomenul Bůh na Abrahama, a vytrhl Lota z prostředku podvrácení, když podvracel města, v nichž bydlil Lot. ");
INSERT INTO ces1613_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Potom vyšel Lot z Ségor, a bydlil na hoře té, a obě dvě dcery jeho s ním; nebo nesměl bydliti v Ségor. I bydlil v jeskyni s oběma dcerami svými. ");
INSERT INTO ces1613_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","I řekla prvorozená k mladší: Otec náš jest již starý, a není žádného muže na zemi, ješto by všel k nám podlé obyčeje vší země. ");
INSERT INTO ces1613_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Poď, dejme píti otci našemu vína, a spěme s ním, abychom zachovaly z otce našeho símě. ");
INSERT INTO ces1613_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","I daly píti otci svému vína té noci; a všedši prvorozená, spala s otcem svým, kterýžto necítil, ani když lehla, ani když vstala. ");
INSERT INTO ces1613_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nazejtří pak řekla prvorozená k mladší: Aj, spala jsem včerejší noci s otcem svým; dejme mu píti vína ještě této noci; potom vejduc, spi s ním, a zachovejme símě z otce našeho. ");
INSERT INTO ces1613_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","I daly píti ještě té noci otci svému vína; a vstala ta mladší, a spala s ním; on pak necítil, ani když ona lehla, ani když vstala. ");
INSERT INTO ces1613_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","A tak počaly obě dcery Lotovy z otce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","I porodila prvorozená syna, a nazvala jméno jeho Moáb; onť jest otec Moábských až do dnešního dne. ");
INSERT INTO ces1613_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","I mladší také porodila syna, a nazvala jméno jeho Ben Ammon; onť jest otcem Ammonitských až do dnešního dne. ");
INSERT INTO ces1613_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Odtud bral se Abraham do země polední, aby bydlil mezi Kádes a Sur; i byl pohostinu v Gerar; ");
INSERT INTO ces1613_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kdežto pravil Abraham o Sáře manželce své: Sestra má jest. Tedy poslav Abimelech, král Gerarský, vzal Sáru. ");
INSERT INTO ces1613_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ale přišed Bůh k Abimelechovi ve snách v noci, řekl jemu: Aj, ty již umřeš pro ženu, kterouž jsi vzal, poněvadž jest vdaná za muže. ");
INSERT INTO ces1613_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech pak nepřiblížil se k ní; protož řekl: Pane, zdaž také spravedlivý národ zabiješ? ");
INSERT INTO ces1613_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Zdaliž mi sám nepravil: Sestra má jest? A ona též pravila: Bratr můj jest. V upřímnosti srdce svého a v nevinnosti rukou svých učinil jsem to. ");
INSERT INTO ces1613_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","I řekl jemu Bůh ve snách: Jáť také vím, že v upřímnosti srdce svého učinil jsi to, a já také zdržel jsem tě, abys nezhřešil proti mně; protož nedalť jsem se jí dotknouti. ");
INSERT INTO ces1613_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nyní tedy, navrať ženu muži tomu; nebo prorok jest, a modliti se bude za tebe, a živ budeš. Pakli jí nenavrátíš, věz, že smrtí umřeš ty i všecko, což tvého jest. ");
INSERT INTO ces1613_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","A vstav Abimelech ráno, svolal všecky služebníky své, a vypravoval všecka slova ta v uši jejich. I báli se ti muži velmi. ");
INSERT INTO ces1613_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Potom povolav Abimelech Abrahama, řekl jemu: Co jsi nám to učinil? A co jsem zhřešil proti tobě, že jsi uvedl na mne a na království mé hřích veliký? Učinils mi, čehož jsi učiniti neměl. ");
INSERT INTO ces1613_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","A řekl opět Abimelech Abrahamovi: Cos myslil, žes takovou věc učinil? ");
INSERT INTO ces1613_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Odpověděl Abraham: Řekl jsem: Jistě že není bázně Boží na místě tomto, a zabijí mne pro ženu mou. ");
INSERT INTO ces1613_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","A také v pravdě jest sestra má, dcera otce mého, však ne dcera matky mé; a pojal jsem ji sobě za manželku. ");
INSERT INTO ces1613_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Když pak vyvedl mne Bůh z domu otce mého, abych pohostinu bydlil, tedy řekl jsem jí: Toto mi dobrodiní učiníš: Na každém místě, kamž půjdeme, prav o mně: Bratr můj jest. ");
INSERT INTO ces1613_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tedy vzav Abimelech ovce a voly, služebníky také a děvky, dal je Abrahamovi; a navrátil mu Sáru manželku jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A řekl Abimelech: Aj, země má před tebou; kdežť se koli příhodné býti vidí, tu přebývej. ");
INSERT INTO ces1613_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sáře pak řekl: Aj, dal jsem tisíc stříbrných bratru tvému, hle, onť jest tobě zástěrou očí u všech, kteříž jsou s tebou. A všemi těmito věcmi Sára poučena byla. ");
INSERT INTO ces1613_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","I modlil se Abraham Bohu, a uzdravil Bůh Abimelecha, a ženu jeho, a děvky jeho; i rodily. ");
INSERT INTO ces1613_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Nebo byl zavřel Hospodin každý život ženský v domě Abimelechově, pro Sáru manželku Abrahamovu. ");
INSERT INTO ces1613_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Navštívil pak Hospodin Sáru, tak jakž byl řekl; a učinil Hospodin Sáře, jakož byl mluvil. ");
INSERT INTO ces1613_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nebo počala a porodila Sára Abrahamovi syna v starosti jeho, v ten čas, kterýž předpověděl Bůh. ");
INSERT INTO ces1613_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","A nazval Abraham jméno syna svého, kterýž se mu narodil, jehož porodila Sára, Izák. ");
INSERT INTO ces1613_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","A obřezal Abraham syna svého Izáka, když byl v osmi dnech, tak jakž mu byl přikázal Bůh. ");
INSERT INTO ces1613_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Byl pak Abraham ve stu letech, když se mu narodil Izák syn jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","I řekla Sára: Radost mi učinil Bůh; kdokoli uslyší, radovati se bude spolu se mnou. ");
INSERT INTO ces1613_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A přidala: Kdo by byl řekl Abrahamovi, že bude Sára děti kojiti? A však jsem porodila syna v starosti jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","I rostlo dítě a ostaveno jest. Tedy učinil Abraham veliké hody v ten den, v němž ostaven byl Izák. ");
INSERT INTO ces1613_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Viděla pak Sára, že syn Agar Egyptské, kteréhož porodila Abrahamovi, jest posměvač. ");
INSERT INTO ces1613_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","I řekla Abrahamovi: Vyvrz děvku tuto i syna jejího; neboť nebude dědicem syn děvky té s synem mým Izákem. ");
INSERT INTO ces1613_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ale Abraham velmi těžce nesl tu řeč, pro syna svého. ");
INSERT INTO ces1613_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","I řekl Bůh Abrahamovi: Nestěžuj sobě o dítěti a o děvce své; cožkoli řekla tobě Sára, povol řeči její, nebo v Izákovi nazváno bude tobě símě. ");
INSERT INTO ces1613_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","A však i syna děvky učiním v národ; nebo tvé símě jest. ");
INSERT INTO ces1613_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Vstal tedy Abraham velmi ráno, a vzav chléb a láhvici vody, dal Agar a vložil na rameno její, a pustil ji od sebe i s dítětem. Kterážto odešla a chodila po poušti Bersabé. ");
INSERT INTO ces1613_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","A když nebylo vody v láhvici, povrhla dítě pod jedním stromem. ");
INSERT INTO ces1613_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","A odšedši, sedla naproti tak daleko, jako by mohl z lučiště dostřeliti; nebo pravila: Nebudu se dívati na smrt dítěte. Seděla tedy naproti, a pozdvihši hlasu svého, plakala. ");
INSERT INTO ces1613_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","I uslyšel Bůh hlas dítěte; a anděl Boží s nebe zavolal na Agar, a řekl jí: Coť jest, Agar? Neboj se; nebo Bůh uslyšel hlas dítěte z místa, na kterémž jest. ");
INSERT INTO ces1613_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Vstaň, vezmi dítě, a ujmi je rukou svou; nebo v národ veliký učiním je. ");
INSERT INTO ces1613_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","A otevřel Bůh oči její, aby uzřela studnici vody. I šla a naplnila láhvici vodou, a napojila dítě. ");
INSERT INTO ces1613_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","A Bůh byl s dítětem, kteréžto zrostlo a bydlilo na poušti, a byl z něho střelec. ");
INSERT INTO ces1613_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Bydlil pak na poušti Fáran; i vzala mu matka jeho ženu z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Stalo se pak toho času, že mluvil Abimelech a Fikol, kníže vojska jeho, k Abrahamovi těmito slovy: Bůh s tebou jest ve všech věcech, kteréž ty činíš. ");
INSERT INTO ces1613_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Protož nyní, přisáhni mi teď skrze Boha: Toto ať se stane, jestliže mi sklamáš, neb synu mému, aneb vnuku mému; vedlé milosrdenství, kteréž jsem já učinil s tebou, i ty že učiníš se mnou a s zemí, v níž jsi byl pohostinu. ");
INSERT INTO ces1613_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","I řekl Abraham: A já přisáhnu. ");
INSERT INTO ces1613_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","(A přitom domlouval se Abraham na Abimelecha o studnici vody, kterouž mu mocí odjali služebníci Abimelechovi. ");
INSERT INTO ces1613_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","I řekl Abimelech: Nevím, kdo by učinil takovou věc; a aniž jsi ty mi oznámil, aniž jsem já také co slyšel, až dnes.) ");
INSERT INTO ces1613_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Vzav tedy Abraham ovce i voly dal Abimelechovi; a vešli oba dva v smlouvu. ");
INSERT INTO ces1613_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","A postavil Abraham sedm jehnic stáda obzvlášť. ");
INSERT INTO ces1613_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","I řekl Abimelech Abrahamovi: K čemu jest těchto sedm jehnic, kteréž jsi postavil obzvlášť? ");
INSERT INTO ces1613_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Odpověděl: Že sedm těch jehnic vezmeš z ruky mé, aby mi to bylo na svědectví, že jsem kopal studnici tuto. ");
INSERT INTO ces1613_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Pročež nazváno jest to místo Bersabé, že tu oba dva přisáhli. ");
INSERT INTO ces1613_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","A tak učinili smlouvu v Bersabé. Vstav pak Abimelech a Fikol, kníže vojska jeho, navrátili se do země Filistinské. ");
INSERT INTO ces1613_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","I nasázel stromoví v Bersabé, a vzýval tam jméno Hospodina, Boha silného, věčného. ");
INSERT INTO ces1613_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","A bydlil Abraham v zemi Filistinské za mnoho dní. ");
INSERT INTO ces1613_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Když pakty věci pominuly, zkusil Bůh Abrahama, a řekl k němu: Abrahame! Kterýžto odpověděl: Teď jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","I řekl: Vezmi nyní syna svého, toho jediného svého, kteréhož miluješ, Izáka, a jdi do země Moria; a obětuj ho tam v obět zápalnou na jedné hoře, o níž povím tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tedy vstav Abraham velmi ráno, osedlal osla svého a vzal dva služebníky své s sebou, a Izáka syna svého; a nasekav dříví k oběti zápalné, vstal a bral se k místu, o němž pověděl mu Bůh. ");
INSERT INTO ces1613_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Třetího pak dne pozdvihl Abraham očí svých, a uzřel to místo zdaleka. ");
INSERT INTO ces1613_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","A řekl Abraham služebníkům svým: Pozůstaňte vy tuto s oslem, já pak a dítě půjdeme tamto; a pomodlíce se, navrátíme se k vám. ");
INSERT INTO ces1613_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Tedy vzal Abraham dříví k zápalné oběti, a vložil je na Izáka syna svého; sám pak nesl v ruce své oheň a meč. I šli oba spolu. ");
INSERT INTO ces1613_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Mluvě pak Izák Abrahamovi otci svému, řekl: Otče můj! Kterýž odpověděl: Co chceš, synu můj? A řekl: Aj, teď oheň a dříví, a kdež hovádko k zápalné oběti? ");
INSERT INTO ces1613_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Odpověděl Abraham: Bůh opatří sobě hovádko k oběti zápalné, synu můj. A šli předce oba spolu. ");
INSERT INTO ces1613_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","A když přišli k místu, o němž mu byl mluvil Bůh, udělal tu Abraham oltář, a srovnal dříví; a svázav syna svého, vložil ho na oltář na dříví. ");
INSERT INTO ces1613_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","I vztáhl Abraham ruku svou, a vzal meč, aby zabil syna svého. ");
INSERT INTO ces1613_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tedy zavolal na něho anděl Hospodinův s nebe a řekl: Abrahame, Abrahame! Kterýžto odpověděl: Aj, já. ");
INSERT INTO ces1613_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","I řekl jemu: Nevztahuj ruky své na dítě, aniž mu co čiň; neboť jsem již poznal, že se Boha bojíš, když jsi neodpustil synu svému, jedinému svému pro mne. ");
INSERT INTO ces1613_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","A pozdvih Abraham očí svých, viděl, a hle, skopec za ním vězel v trní za rohy své. I šel Abraham a vzal skopce toho, a obětoval jej v obět zápalnou místo syna svého. ");
INSERT INTO ces1613_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","A nazval Abraham jméno místa toho: Hospodin opatří. Odkudž říká se do dnes: Na hoře Hospodinově opatří se. ");
INSERT INTO ces1613_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Zvolal pak anděl Hospodinův na Abrahama podruhé s nebe, ");
INSERT INTO ces1613_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","A řekl: Skrze sebe samého přisáhl jsem, praví Hospodin, poněvadž jsi učinil tu věc, že jsi neodpustil synu svému, jedinému svému: ");
INSERT INTO ces1613_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Požehnám velmi tobě, a velice rozmnožím símě tvé jako hvězdy nebeské, a jako písek, kterýž jest na břehu mořském; nadto dědičně vládnouti bude símě tvé branami nepřátel svých. ");
INSERT INTO ces1613_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ano požehnáni budou v semeni tvém všickni národové země, proto že jsi uposlechl hlasu mého. ");
INSERT INTO ces1613_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tedy navrátil se Abraham k služebníkům svým; a vstavše, šli spolu do Bersabé; nebo bydlil Abraham v Bersabé. ");
INSERT INTO ces1613_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","A když se tyto věci staly, zvěstováno jest Abrahamovi v tato slova: Aj, porodila také Melcha syny Náchorovi, bratru tvému: ");
INSERT INTO ces1613_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Husa prvorozeného svého, a Buza bratra jeho, a Chamuele, otce Aramova; ");
INSERT INTO ces1613_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","A Kazeda a Azana, a Feldasa, a Jidlafa i Bathuele. ");
INSERT INTO ces1613_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bathuel pak zplodil Rebeku. Osm těchto porodila Melcha Náchorovi, bratru Abrahamovu. ");
INSERT INTO ces1613_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ale i ženina jeho, jejíž jméno bylo Réma, porodila také ona Tábe a Gahama, Thása a Máchu. ");
INSERT INTO ces1613_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Živa pak byla Sára sto a sedmmecítma let; ta jsou léta života Sáry. ");
INSERT INTO ces1613_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","A umřela v městě Arbe, kteréž slove Hebron, v zemi Kananejské. I přišel Abraham, aby kvílil nad Sárou, a plakal jí. ");
INSERT INTO ces1613_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Potom vstav Abraham od mrtvého svého, mluvil k synům Het, řka: ");
INSERT INTO ces1613_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Hostem a příchozím jsem u vás; dejte mi místo ku pohřbu u vás, abych pochoval mrtvého svého od tváři své. ");
INSERT INTO ces1613_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","A odpovídajíce synové Het Abrahamovi, řekli jemu: ");
INSERT INTO ces1613_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Slyš nás, pane milý! Kníže Boží jsi u prostřed nás, v nejpřednějších hrobích našich pochovej mrtvého svého; žádný z nás hrobu svého nebude zbraňovati tobě, abys neměl pochovati v něm mrtvého svého. ");
INSERT INTO ces1613_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham pak vstav, poklonil se lidu země té, totiž synům Het. ");
INSERT INTO ces1613_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A mluvil s nimi, řka: Jestliže se vám líbí, abych pochoval mrtvého svého od tváři své, slyšte mne, a přimluvte se za mne k Efronovi synu Sohar, ");
INSERT INTO ces1613_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ať mi dá jeskyni Machpelah, kterouž má na konci pole svého; za slušné peníze ať mi ji dá u prostřed vás, k dědičnému pohřbu. ");
INSERT INTO ces1613_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","(Ten pak Efron seděl u prostřed synů Het.) Tedy odpověděl Efron Hetejský Abrahamovi při přítomnosti synů Het, přede všemi, kteříž vcházejí do brány města jeho, řka: ");
INSERT INTO ces1613_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nikoli, pane můj, ale slyš mne: Pole to dávám tobě, dávámť také i jeskyni, kteráž na něm jest; před očima synů lidu svého dávám ji tobě; pochovejž mrtvého svého. ");
INSERT INTO ces1613_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tedy poklonil se Abraham před lidem země té, ");
INSERT INTO ces1613_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","A mluvil k Efronovi v přítomnosti lidu země, řka: A však jestliže ty jsi ten, prosím, vyslyš mne! Dámť stříbro za pole, vezmi je ode mne, a pochovám mrtvého svého tam. ");
INSERT INTO ces1613_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","A odpovídaje Efron Abrahamovi, řekl jemu: ");
INSERT INTO ces1613_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Můj pane, poslechni mne: Země ta za čtyři sta lotů stříbrných jest; ale mezi mnou a tebou co jest o to? Mrtvého svého pochovej. ");
INSERT INTO ces1613_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","I uposlechl Abraham Efrona, a odvážil mu stříbra, jakž oznámil při přítomnosti synů Het, čtyři sta lotů stříbrných, běžných mezi kupci. ");
INSERT INTO ces1613_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","A odvedeno jest pole Efronovo, kteréž bylo v Machpelah, proti Mamre, pole a jeskyně na něm, a všecko stromoví, což ho na tom poli i na všech mezech jeho vůkol, ");
INSERT INTO ces1613_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abrahamovi v držení, před očima synů Het, a všech, kteříž vcházejí do brány města toho. ");
INSERT INTO ces1613_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","A potom pochoval Abraham Sáru, manželku svou, v jeskyni pole Machpelah, proti Mamre, (to slove Hebron), v zemi Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Protož odevzdáno jest pole to i jeskyně, kteráž byla na něm, Abrahamovi k dědičnému pohřbu od synů Het. ");
INSERT INTO ces1613_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham pak již byl starý a sešlého věku; a Hospodin požehnal mu ve všech věcech. ");
INSERT INTO ces1613_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Tedy řekl Abraham služebníku svému staršímu v domě svém, kterýž spravoval všecky věci jeho: Vlož nyní ruku svou pod bedro mé, ");
INSERT INTO ces1613_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Abych tě zavázal přísahou skrze Hospodina, Boha nebe a Boha země, abys nebral manželky synu mému ze dcer Kananejských, mezi nimiž já bydlím. ");
INSERT INTO ces1613_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ale půjdeš do země mé a příbuznosti mé; a odtud vezmeš manželku synu mému Izákovi. ");
INSERT INTO ces1613_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","I řekl jemu služebník ten: Kdyby pak nechtěla žena ta se mnou jíti do země této, mám-li zase uvésti syna tvého do země, z níž jsi vyšel? ");
INSERT INTO ces1613_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kterýžto odpověděl: Hleď, abys zase neuvodil syna mého tam. ");
INSERT INTO ces1613_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hospodin Bůh nebe, kterýž vzal mne z domu otce mého a z vlasti mé, a mluvil mi, a kterýž mi přisáhl, řka: Semeni tvému dám zemi tuto, onť pošle anděla svého před tebou, a vezmeš manželku synu mému odtud. ");
INSERT INTO ces1613_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Jestliže by pak žena ta nechtěla jíti s tebou, svoboden budeš od této přísahy mé; toliko syna mého neuvoď tam zase. ");
INSERT INTO ces1613_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tedy vložil služebník ten ruku svou pod bedro Abrahama, pána svého, a přisáhl jemu na tu řeč. ");
INSERT INTO ces1613_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","A vzal služebník ten deset velbloudů z velbloudů pána svého, aby se bral; (nebo měl všecken statek pána svého v rukou svých.) I vstav, bral se k Aram Naharaim do města Náchor. ");
INSERT INTO ces1613_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","A zastavil se s velbloudy před městem, u studnice vody k večerou, času toho, když vycházejí vážiti vody. ");
INSERT INTO ces1613_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A řekl: Hospodine, Bože pána mého Abrahama, dejž, prosím, ať se potká se mnou dnes to, čehož hledám; a učiň milosrdenství se pánem mým Abrahamem. ");
INSERT INTO ces1613_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Aj, já stojím u studnice vody, a dcery mužů města tohoto vycházejí, aby vážily vodu. ");
INSERT INTO ces1613_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Děvečka tedy, kteréž bych řekl: Nachyl medle věderce svého, ať se napiji, a ona by řekla: Pí, také i velbloudy tvé napojím, ta aby byla, kterouž jsi způsobil služebníku svému Izákovi; a po tomť poznám, že jsi milosrdenství učinil se pánem mým. ");
INSERT INTO ces1613_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","I stalo se prvé, než on přestal mluviti, aj, Rebeka, kteráž se narodila Bathuelovi, synu Melchy, manželky Náchora bratra Abrahamova, vycházela, a věderce její bylo na rameni jejím. ");
INSERT INTO ces1613_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A byla děvečka na pohledění velmi krásná, panna, a muž nepoznal jí; kterážto sešla k studnici té, a naplnivši věderce své, šla vzhůru. ");
INSERT INTO ces1613_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tedy běžel služebník ten proti ní, a řekl: Dej mi píti, prosím, maličko vody z věderce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","I řekla: Napí se, pane můj. A rychle složila věderce své na ruku svou a dala mu píti. ");
INSERT INTO ces1613_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","A davši mu píti, řekla: Také velbloudům tvým navážím, dokudž se nenapijí. ");
INSERT INTO ces1613_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tedy rychle vylila z věderce svého do koryta, a běžela ještě k studnici, aby vážila vodu; a vážila všechněm velbloudům jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Muž pak ten s užasnutím divil se jí mlče, rozjímaje, aby zvěděl, zdařil-li Hospodin cestu jeho, čili nic. ");
INSERT INTO ces1613_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","I stalo se, když přestali píti velbloudové, vyňav muž náušnici zlatou, ztíží půl lotu, a dvě náramnice, dal na ruce její, kteréž vážily deset lotů zlata. ");
INSERT INTO ces1613_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A řekl: Èí jsi dcera? Pověz mi, prosím, jest-li v domě otce tvého nám místo, kdež bychom přes noc zůstali? ");
INSERT INTO ces1613_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Jemužto odpověděla: Dcera jsem Bathuele, syna Melchy, kteréhož porodila Náchorovi. ");
INSERT INTO ces1613_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Řekla ještě k němu: Slámy také a potravy hojně u nás jest, ano i místo, kdež byste přes noc zůstali. ");
INSERT INTO ces1613_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tedy skloniv hlavu, poklonu učinil Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","A řekl: Požehnaný Hospodin, Bůh pána mého Abrahama, kterýž neodjal milosrdenství svého a pravdy své od pána mého, mne také na cestě vedl Hospodin k domu bratří pána mého. ");
INSERT INTO ces1613_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","I běžela děvečka, a oznámila v domě matky své tak, jakž se stalo. ");
INSERT INTO ces1613_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","A měla Rebeka bratra, jménem Lábana; ten běžel k muži tomu ven k studnici. ");
INSERT INTO ces1613_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nebo uzřev náušnici a náramnice na rukou sestry své, a slyšev slova Rebeky sestry své, ana praví: Tak mluvil ke mně člověk ten, přišel k muži, a on stál při velbloudích u studnice. ");
INSERT INTO ces1613_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Jemuž řekl: Vejdi, požehnaný Hospodinův. Proč bys stál vně, kdyžť jsem připravil dům a místo velbloudům? ");
INSERT INTO ces1613_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tedy všel muž ten do domu, a odsedlal velbloudy, a dal Lában slámy a potravy velbloudům, i vody k umytí noh jeho a noh mužů těch, kteří s ním byli. ");
INSERT INTO ces1613_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A položil předeň chléb, aby jedl. Ale on řekl: Nebudu jísti, dokudž nevypravím řečí svých. I řekl Lában: Mluv. ");
INSERT INTO ces1613_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tedy řekl: Služebník Abrahamův jsem já. ");
INSERT INTO ces1613_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","A Hospodin požehnal pánu mému velice, tak že veliký učiněn jest; nebo dal mu ovce a voly, stříbro a zlato, služebníky a děvky, velbloudy a osly. ");
INSERT INTO ces1613_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","A porodila Sára, manželka pána mého, pánu mému v starosti své syna, jemuž dal, cožkoli má. ");
INSERT INTO ces1613_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","I zavázal mne přísahou pán můj, řka: Nevezmeš manželky synu mému ze dcer Kananejských, v jejichž zemi já bydlím. ");
INSERT INTO ces1613_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ale k domu otce mého půjdeš, a k rodině mé, a odtud vezmeš manželku synu mému. ");
INSERT INTO ces1613_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","A když jsem řekl pánu svému: Snad nepůjde žena ta se mnou? ");
INSERT INTO ces1613_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Odpověděl mi: Hospodin, před jehož oblíčejem ustavičně jsem chodil, pošle anděla svého s tebou, a šťastnou způsobí cestu tvou, a vezmeš manželku synu mému z rodiny mé, a z domu otce mého. ");
INSERT INTO ces1613_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","A budeš svoboden od přísahy mé, když bys přišel k rodině mé; a jestliže by nedali tobě, budeš prost od přísahy mé. ");
INSERT INTO ces1613_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Protož dnes přišed k studnici, řekl jsem: Hospodine, Bože pána mého Abrahama, jestliže ty nyní šťastně spravuješ cestu mou, po níž já jdu, ");
INSERT INTO ces1613_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Aj, já stojím u studnice vody; protož, nechžť panna, kteráž vyjde vážiti vody, když bych jí řekl: Dej mi píti nyní maličko vody z věderce svého, ");
INSERT INTO ces1613_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","A ona by mi odpověděla: I ty pí, i velbloudům tvým také navážím, ta ať jest manželka, kterouž způsobil Hospodin synu pána mého. ");
INSERT INTO ces1613_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Prvé pak než jsem já přestal mluviti v srdci svém, aj, Rebeka vycházela mající věderce své na rameni svém, a sšedši k studnici, vážila. I řekl jsem jí: Prosím, dej mi píti. ");
INSERT INTO ces1613_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ona pak rychle složila věderce své s sebe, a řekla: Pí, také i velbloudy tvé napojím. Tedy pil jsem, a napojila také velbloudy. ");
INSERT INTO ces1613_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","I ptal jsem se jí, a řekl jsem: Èí jsi dcera? Ona odpověděla: Dcera Bathuele, syna Náchorova, jehož mu porodila Melcha. Tedy dal jsem náušnici na tvář její, a náramnice na ruce její. ");
INSERT INTO ces1613_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","A skloniv hlavu, poklonu jsem učinil Hospodinu, a dobrořečil jsem Hospodina, Boha pána mého Abrahama, kterýž vedl mne po cestě přímé, abych dceru bratra pána svého vzal synu jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Protož nyní, činíte-li milosrdenství, a pravdu se pánem mým, oznamte mi; pakli nic, také mi oznamte, a obrátím se na pravo neb na levo. ");
INSERT INTO ces1613_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tedy odpověděli Lában a Bathuel, řkouce: Od Hospodina vyšla jest věc tato; nemůžemeť odepříti v ničemž. ");
INSERT INTO ces1613_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Aj, Rebeka před tebou, vezmiž ji a jeď; a nechť jest manželkou synu pána tvého, jakož mluvil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","I stalo se, že jakž uslyšel služebník Abrahamův slova jejich, poklonil se Hospodinu až k zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","A vyňav služebník ten nádoby stříbrné a nádoby zlaté a oděv, dal Rebece; drahé také dary dal bratru jejímu a matce její. ");
INSERT INTO ces1613_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Tedy jedli a pili, on i muži, kteříž byli s ním, a zůstali tu přes noc. Ráno pak když vstali, řekl: Propusťte mne ku pánu mému. ");
INSERT INTO ces1613_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","I odpověděl bratr její a matka: Nechať pozůstane děvečka s námi za některý den, aspoň za deset; potom půjdeš. ");
INSERT INTO ces1613_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","On pak řekl jim: Nezdržujte mne, poněvadž Hospodin šťastnou způsobil cestu mou; propusťtež mne, ať jdu ku pánu svému. ");
INSERT INTO ces1613_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","I řekli: Zavolejme děvečky a zeptejme se, co dí k tomu. ");
INSERT INTO ces1613_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tedy zavolali Rebeky, a řekli jí: Chceš-li jíti s mužem tímto? I řekla: Půjdu. ");
INSERT INTO ces1613_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","A propouštějíce Rebeku sestru svou a chovačku její, služebníka také Abrahamova s muži jeho, ");
INSERT INTO ces1613_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Požehnali Rebeky a mluvili jí: Sestro naše, ty buď v tisíce tisíců, a símě tvé dědičně obdrž brány nepřátel svých. ");
INSERT INTO ces1613_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Tedy vstala Rebeka a děvečky její, a vsedše na velbloudy, jely za mužem tím. A tak vzal služebník ten Rebeku, a odjel. ");
INSERT INTO ces1613_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Izák pak šel, navracuje se od studnice Živého vidoucího mne; nebo bydlil v zemi polední. ");
INSERT INTO ces1613_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","A vyšel Izák k přemyšlování na pole, když se chýlilo k večerou; a pozdvih očí svých, uzřel, an velbloudové jdou. ");
INSERT INTO ces1613_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Pozdvihla také Rebeka očí svých, a uzřevši Izáka, ssedla s velblouda. ");
INSERT INTO ces1613_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","(Nebo řekla byla služebníku: Kdo jest ten muž, kterýž jde po poli proti nám? Odpověděl služebník: To jest pán můj.) I vzala rouchu, a přistřela se. ");
INSERT INTO ces1613_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tedy vypravoval služebník Izákovi vše, což působil. ");
INSERT INTO ces1613_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","I uvedl ji Izák do stanu Sáry matky své, a vzal Rebeku, a měl ji za manželku, a miloval ji. I potěšil se Izák po smrti matky své. ");
INSERT INTO ces1613_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham pak opět pojal ženu jménem Ceturu. ");
INSERT INTO ces1613_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kterážto porodila jemu Zamrana, a Jeksana, a Madana, a Madiana, Jezbocha a Suecha. ");
INSERT INTO ces1613_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jeksan potom zplodil Sábu a Dedana. Synové pak Dedanovi byli: Assurim, a Latuzim, a Laomim. ");
INSERT INTO ces1613_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ale synové Madianovi: Efa, a Efer, a Enoch, a Abida, a Helda; všickni ti synové byli Cetury. ");
INSERT INTO ces1613_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","I dal Abraham Izákovi všecko, což měl. ");
INSERT INTO ces1613_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Synům pak ženin svých dal Abraham dary, a odeslal je od Izáka syna svého, ještě živ jsa, k východu do země východní. ");
INSERT INTO ces1613_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Tito pak jsou dnové let života Abrahamova, v nichž byl živ: Sto sedmdesáte a pět let. ");
INSERT INTO ces1613_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","I skonal a umřel Abraham v starosti dobré, stár jsa a plný dnů; a připojen jest k lidu svému. ");
INSERT INTO ces1613_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Tedy pochovali ho Izák a Izmael synové jeho v jeskyni Machpelah, na poli Efrona, syna Sohar Hetejského, naproti Mamre, ");
INSERT INTO ces1613_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Na tom poli, kteréž byl koupil Abraham od synů Het; tu pochován jest Abraham i Sára manželka jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Po smrti pak Abrahamově požehnal Bůh Izákovi synu jeho, a bydlil Izák u studnice Živého vidoucího mne. ");
INSERT INTO ces1613_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Tito jsou pak rodové Izmaele syna Abrahamova, jehož porodila Agar Egyptská, děvka Sářina, Abrahamovi. ");
INSERT INTO ces1613_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","A tato jsou jména synů Izmaelových, jimiž se jmenují po rodech svých: Prvorozený Izmaelův Nabajot, po něm Cedar, a Adbeel a Mabsan, ");
INSERT INTO ces1613_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","A Masma, a Dumah a Massa, ");
INSERT INTO ces1613_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar a Tema, Jetur, Nafis a Cedma. ");
INSERT INTO ces1613_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ti jsou synové Izmaelovi, a ta jména jejich, po vsech jejich, a po městech jejich, dvanáctero knížat po čeledech jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","(Bylo pak života Izmaelova sto třidceti a sedm let, i skonal; a umřev, připojen jest k lidu svému.) ");
INSERT INTO ces1613_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","A bydlili od Hevilah až do Sur, jenž jest proti Egyptu, když jdeš do Assyrie; před tváří všech bratří svých položil se. ");
INSERT INTO ces1613_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Tito jsou také rodové Izáka syna Abrahamova: Abraham zplodil Izáka. ");
INSERT INTO ces1613_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Byl pak Izák ve čtyřidcíti letech, když sobě vzal za manželku Rebeku, dceru Bathuele Syrského, z Pádan Syrské, sestru Lábana Syrského. ");
INSERT INTO ces1613_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","I modlil se Izák pokorně Hospodinu za manželku svou; nebo byla neplodná. A uslyšel jej Hospodin; a tak počala Rebeka manželka jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","A když se děti potiskali v životě jejím, řekla: Má-liť tak býti, proč jsem já počala? Šla tedy, aby se otázala Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","I řekl jí Hospodin: Dva národové jsou v životě tvém, a dvůj lid z života tvého se rozdělí; lid pak jeden nad druhý bude silnější, a větší sloužiti bude menšímu. ");
INSERT INTO ces1613_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","A když se naplnili dnové její, aby porodila, a aj, blíženci byli v životě jejím. ");
INSERT INTO ces1613_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","I vyšel první ryšavý všecken, a jako oděv chlupatý; i nazvali jméno jeho Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Potom pak vyšel bratr jeho, a rukou svou držel Ezau za patu; pročež nazváno jest jméno jeho Jákob. A byl Izák v šedesáti letech, když ona je porodila. ");
INSERT INTO ces1613_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","A když dorostli ti děti, byl Ezau lovec umělý, chodě po polích; Jákob pak byl muž prostý a v staních bydlil. ");
INSERT INTO ces1613_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I byl Izák laskav na Ezau, proto že z lovu jeho míval pokrm; ale Rebeka laskava byla na Jákoba. ");
INSERT INTO ces1613_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Uvařil pak Jákob krmičku. Tedy Ezau přišel z pole zemdlený, ");
INSERT INTO ces1613_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A řekl Jákobovi: Dej mi, prosím, jísti krmě té červené, nebo jsem umdlel. (Protož nazváno jest jméno jeho Edom.) ");
INSERT INTO ces1613_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Odpověděl Jákob: Prodej mi dnes hned prvorozenství své. ");
INSERT INTO ces1613_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","I řekl Ezau: Aj, já k smrti se blížím, k čemuž mi tedy to prvorozenství? ");
INSERT INTO ces1613_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Dí Jákob: Přisáhni mi dnes hned. I přisáhl mu, a prodal prvorozenství své Jákobovi. ");
INSERT INTO ces1613_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tedy Jákob dal Ezauchovi chleba a té krmě z šocovice. Kterýžto jedl a pil, a vstav, odšel; a tak pohrdl Ezau prvorozenstvím. ");
INSERT INTO ces1613_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Byl pak opět hlad na zemi, mimo hlad první, kterýž byl za dnů Abrahamových. Tedy odebral se Izák k Abimelechovi králi Filistinskému do Gerar. ");
INSERT INTO ces1613_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nebo ukázal se jemu Hospodin a řekl: Nesstupuj do Egypta; ale bydli v zemi, kterouž oznámím tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Budiž tedy pohostinu v zemi této, a budu s tebou, a požehnám tobě; nebo tobě a semeni tvému dám všecky země tyto, a utvrdím přísahu, kterouž jsem přisáhl Abrahamovi, otci tvému. ");
INSERT INTO ces1613_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Rozmnožím také símě tvé jako hvězdy nebeské, a dám semeni tvému všecky země tyto, a požehnáni budou v semeni tvém všickni národové země; ");
INSERT INTO ces1613_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Protože uposlechl Abraham hlasu mého, a ostříhal nařízení mých, přikázaní mých, ustanovení mých a zákonů mých. ");
INSERT INTO ces1613_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Bydlil tedy Izák v Gerar. ");
INSERT INTO ces1613_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ptali se pak muži místa toho o manželce jeho. Kterýžto odpověděl: Sestra má jest; nebo nesměl říci: Manželka má jest, mysle sobě: Aby mne nezabili muži místa toho pro Rebeku. Nebo byla krásná na pohledění. ");
INSERT INTO ces1613_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","I přihodilo se, když již čas nějaký tam bydlil, že vyhlédal Abimelech král Filistinský z okna a uzřel Izáka, an pohrává s Rebekou manželkou svou. ");
INSERT INTO ces1613_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Protož povolav Abimelech Izáka, řekl: Aj, v pravdě manželka tvá to jest. Jakž to, že jsi pravil: Sestra má jest? I odpověděl jemu Izák: Nebo jsem řekl sám u sebe: Abych snad neumřel pro ni. ");
INSERT INTO ces1613_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","I řekl Abimelech: Což jsi to učinil nám? O málo, že by byl spal někdo z lidu s manželkou tvou, a ty byl bys uvedl na nás vinu. ");
INSERT INTO ces1613_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","I přikázal Abimelech všemu lidu, řka: Kdo by se dotkl člověka toho, aneb manželky jeho, smrtí umře. ");
INSERT INTO ces1613_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Sel pak Izák v zemi té, a shledal v tom roce sto měr; nebo požehnal mu Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I rostl muž ten, a prospíval vždy více v zrostu, až i zrostl velmi. ");
INSERT INTO ces1613_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nebo měl stáda ovcí i stáda volů, a čeledi mnoho; pročež záviděli mu Filistinští. ");
INSERT INTO ces1613_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","A všecky studnice, kteréž vykopali služebníci otce jeho za dnů Abrahama otce jeho, zařítili Filistinští, zasypavše je prstí. ");
INSERT INTO ces1613_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","I řekl Abimelech Izákovi: Odejdi od nás; nebo mnohem mocnější jsi než my. ");
INSERT INTO ces1613_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tedy odšel odtud Izák, a rozbil stany v údolí Gerar, a bydlil tu. ");
INSERT INTO ces1613_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A kopal zase Izák studnice vod, kteréž byli vykopali za dnů Abrahama otce jeho, a kteréž zařítili Filistinští po smrti Abrahamově; a nazval je těmi jmény, kterýmiž je jmenoval otec jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","I kopali služebníci Izákovi v tom údolí, a nalezli tam studnici vody živé. ");
INSERT INTO ces1613_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Vadili se pak pastýři Gerarští s pastýři Izákovými, pravíce: Naše jest voda. Pročež nazval jméno studnice té Esek, že se vadili s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Vykopali také jinou studnici, a nesnáz byla i o tu; pročež dal jí jméno Sitnah. ");
INSERT INTO ces1613_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","I hnul se odtud, a kopal jinou studnici, o kterouž se nevadili; protož nazval jméno její Rehobot. Nebo řekl: Nyní uprostrannil nám Hospodin, a vzrostli jsme na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Vstoupil pak odtud do Bersabé. ");
INSERT INTO ces1613_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","A ukázal se mu Hospodin v tu noc, a řekl: Já jsem Bůh Abrahama otce tvého; neboj se, nebo s tebou já jsem, a požehnám tobě, a rozmnožím símě tvé pro Abrahama služebníka svého. ");
INSERT INTO ces1613_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","I vzdělal tu oltář, a vzýval jméno Hospodinovo, a rozbil tu stan svůj; a služebníci Izákovi vykopali tam studnici. ");
INSERT INTO ces1613_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelech pak přijel k němu z Gerar, a Ochozat, přítel jeho, a Fikol, kníže vojska jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","I řekl jim Izák: Z jaké příčiny přišli jste ke mně? Poněvadž vy nenáviděli jste mne, a vybyli jste mne od sebe. ");
INSERT INTO ces1613_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kteřížto odpověděli: Patrně jsme to shledali, že jest Hospodin s tebou, i řekli jsme: Učiňme nyní přísahu mezi sebou, mezi námi a mezi tebou; a učiníme smlouvu s tebou: ");
INSERT INTO ces1613_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Že neučiníš nám nic zlého, jako i my nedotkli jsme se tebe, a jakž jsme my toliko dobře činili tobě, a propustili jsme tě v pokoji; ty nyní tedy povol tomu, požehnaný Hospodinův. ");
INSERT INTO ces1613_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tedy učinil jim hody, i jedli a pili. ");
INSERT INTO ces1613_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","A vstavše velmi ráno, přisáhli jeden druhému. I propustil je Izák, a oni odešli od něho v pokoji. ");
INSERT INTO ces1613_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Toho dne přišli služebníci Izákovi, a oznámili mu o studnici, kterouž kopali, řkouce: Nalezli jsme vodu. ");
INSERT INTO ces1613_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I nazval ji Seba. Protož jméno města toho jest Bersabé až do dnešního dne. ");
INSERT INTO ces1613_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ezau pak jsa v letech čtyřidcíti, pojal ženu Judit, dceru Béry Hetejského, a Bazematu, dceru Elona Hetejského. ");
INSERT INTO ces1613_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","A kormoutily Izáka a Rebeku. ");
INSERT INTO ces1613_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Když se pak sstaral Izák, a pošly byly oči jeho, tak že neviděl, povolal Ezau syna svého staršího, a řekl jemu: Synu můj. Kterýžto odpověděl: Aj, teď jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I dí: Aj, já jsem se již sstaral, a nevím dne smrti své. ");
INSERT INTO ces1613_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Protož nyní vezmi medle nástroje své, toul svůj a lučiště své, a vyjda do pole, ulov mi zvěřinu. ");
INSERT INTO ces1613_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","A přistroj mi krmi chutnou, jakž já rád jídám, a přines mi, a budu jísti, aťby požehnala duše má, prvé než umru. ");
INSERT INTO ces1613_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","(Slyšela pak Rebeka, když mluvil Izák s Ezau synem svým.) I odšel Ezau na pole, aby ulovil zvěřinu a přinesl. ");
INSERT INTO ces1613_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Tedy řekla Rebeka Jákobovi synu svému takto: Aj, slyšela jsem, když otec tvůj mluvil k Ezau bratru tvému, a pravil: ");
INSERT INTO ces1613_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Přines mi něco z lovu, a přistroj mi krmě chutné, abych jedl, a požehnámť před Hospodinem, prvé než umru. ");
INSERT INTO ces1613_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nyní tedy, synu můj, poslechni hlasu mého v tom, což já přikazuji tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Jdi medle k stádu, a odtud mi vezmi dva kozelce výborné, abych přistrojila z nich krmě chutné otci tvému, jakž on rád jídá. ");
INSERT INTO ces1613_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","A přineseš otci svému, a on jísti bude, na to, aby požehnal tobě, prvé než umře. ");
INSERT INTO ces1613_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","I řekl Jákob Rebece matce své: Víš, že Ezau bratr můj jest člověk chlupatý, a já jsem člověk hladký. ");
INSERT INTO ces1613_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Jestliže omaká mne otec můj, tedy zůstanu u něho za podvodného; a tak uvedu na sebe zlořečenství, a ne požehnání. ");
INSERT INTO ces1613_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Jemužto odpověděla matka: Nechť jest na mne zlořečenství tvé, synu můj; jen ty poslechni hlasu mého, a jdi, přines mi. ");
INSERT INTO ces1613_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tedy odšed, vzal, a přinesl matce své. I připravila matka jeho krmě chutné, jakž otec jeho rád jídal. ");
INSERT INTO ces1613_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","A vzala Rebeka nejlepší šaty Ezausyna svého staršího, kteréž měla u sebe v domě, a oblékla Jákoba, syna svého mladšího. ");
INSERT INTO ces1613_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A kožkami kozelčími obvinula ruce jeho, a díl hladký hrdla jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","I dala chléb a krmě chutné, kteréž připravila, v ruce Jákoba syna svého. ");
INSERT INTO ces1613_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","A on přišed k otci svému, řekl: Otče můj! Kterýžto odpověděl: Aj, teď jsem. Kdož jsi ty, synu můj? ");
INSERT INTO ces1613_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","I dí Jákob otci svému: Já jsem Ezau, prvorozený tvůj. Učinil jsem, jakž jsi mi poručil. Vstaň, prosím, sedni a jez z lovu mého, aby mi požehnala duše tvá. ");
INSERT INTO ces1613_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tedy řekl Izák synu svému: Což to? Brzys to nalezl, synu můj. A on dí: Nebo Hospodin Bůh tvůj způsobil to, aby mi se pojednou nahodilo. ");
INSERT INTO ces1613_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","I řekl Izák Jákobovi: Přistupiž, ať omakám tě, synu můj, ty-li jsi syn můj Ezau, či nejsi. ");
INSERT INTO ces1613_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tedy přistoupil Jákob k Izákovi otci svému; a on omakal ho, i řekl: Hlas jest hlas Jákobův, ale ruce tyto ruce Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","A nepoznal ho; nebo byly ruce jeho, jako ruce Ezau bratra jeho, chlupaté. I požehnal mu. ");
INSERT INTO ces1613_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","A řekl: Ty-liž jsi pak syn můj Ezau? Odpověděl: Já. ");
INSERT INTO ces1613_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","I řekl: Podejž mi, ať jím z lovu syna svého, aby tobě požehnala duše má. Tedy podal mu, a on jedl. Přinesl mu také vína, a on pil. ");
INSERT INTO ces1613_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","I řekl jemu Izák otec jeho: Přistupiž nyní, a polib mne, synu můj. ");
INSERT INTO ces1613_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","I přistoupil a políbil ho. A jakž ucítil Izák vůni roucha jeho, požehnal mu, řka: Pohleď, vůně syna mého jest jako vůně pole, jemuž požehnal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dejž tobě Bůh z rosy nebeské, a z tučnosti zemské, i hojnost obilé a vína. ");
INSERT INTO ces1613_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nechažť slouží tobě lidé, a sklánějí se před tebou národové. Budiž pánem bratří svých, a ať se sklánějí před tebou synové matky tvé. Kdož by zlořečili tobě, nechť jsou zlořečení, a kdo by dobrořečili tobě, požehnaní. ");
INSERT INTO ces1613_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","A když přestal Izák požehnání dávati Jákobovi, a sotva že vyšel Jákob od Izáka otce svého, Ezau bratr jeho přišel z lovu svého. ");
INSERT INTO ces1613_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A připraviv i on krmě chutné, přinesl otci svému a řekl mu: Nechžť vstane otec můj, a jí z lovu syna svého, aby mi požehnala duše tvá. ");
INSERT INTO ces1613_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","I řekl jemu Izák otec jeho: Kdo jsi ty? Dí on: Já jsem syn tvůj, prvorozený tvůj Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tedy zhrozil se Izák hrůzou velikou náramně, a řekl: Kdo pak a kde jest ten, ješto uloviv zvěřinu, přinesl mi? A já jsem jedl ze všeho, prvé než jsi ty přišel, a požehnal jsem mu, a budeť požehnaným. ");
INSERT INTO ces1613_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Uslyšev Ezau slova otce svého, zkřikl hlasem velikým, a hořkostí naplněn jest náramně, a řekl otci svému: Požehnejž mně, i mně také, můj otče! ");
INSERT INTO ces1613_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kterýžto řekl: Přišel bratr tvůj podvodně a uchvátil požehnání tvé. ");
INSERT INTO ces1613_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tedy řekl: Právětě nazváno jméno jeho Jákob; nebo již po dvakráte mne podvedl, prvorozenství mé odjal, a teď nyní uchvátil požehnání mé. Řekl ještě: Zdali jsi nezachoval i mně požehnání? ");
INSERT INTO ces1613_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Odpověděl Izák a řekl k Ezau: Aj, ustavil jsem ho pánem nad tebou, a všecky bratří jeho dal jsem mu za služebníky; obilím také a vínem opatřil jsem ho. Což tedy již tobě učiniti mohu, synu můj? ");
INSERT INTO ces1613_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","I řekl Ezau otci svému: Zdaliž to jedno toliko máš požehnání, otče můj? Požehnejž mně, i mně také, můj otče! I povýšil Ezau hlasu svého a plakal. ");
INSERT INTO ces1613_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tedy odpověděl Izák otec jeho, a řekl k němu: Aj, v tučnostech země bude bydlení tvé a v rose nebeské s hůry; ");
INSERT INTO ces1613_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","A v meči svém živ budeš, a bratru svému sloužiti budeš; ale přijde čas, že budeš panovati a svržeš jho jeho s šíje své. ");
INSERT INTO ces1613_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Protož v nenávisti měl Ezau Jákoba pro požehnání, jímž požehnal mu otec jeho, a řekl v srdci svém: Přiblížiť se dnové smutku otce mého, a zabiji Jákoba, bratra svého. ");
INSERT INTO ces1613_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","I oznámena jsou Rebece slova Ezau, staršího syna jejího. Pročež ona poslavši, povolala Jákoba syna svého mladšího, a řekla jemu: Hle, Ezau bratr tvůj těší se tím, že tě zabije. ");
INSERT INTO ces1613_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Protož nyní, synu můj, poslechni hlasu mého, a vstana, utec k Lábanovi, bratru mému do Cháran. ");
INSERT INTO ces1613_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","A pobuď s ním za některý čas, až by se odvrátila prchlivost bratra tvého, ");
INSERT INTO ces1613_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","A přestalo rozhněvání bratra tvého na tebe, a zapomenul by na to, což jsi mu učinil. Potom já pošli a vezmu tě odtud. Proč mám zbavena býti obou synů jednoho dne? ");
INSERT INTO ces1613_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","I řekla Rebeka Izákovi: Stýště mi se živu býti pro dcery Het. Vezme-li Jákob ženu ze dcer Het, jako tyto jsou ze dcer země této, k čemu mi život? ");
INSERT INTO ces1613_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Povolal pak Izák Jákoba, a požehnal jemu, a přikázal mu, řka: Nepojímej ženy ze dcer Kananejských. ");
INSERT INTO ces1613_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ale vstana, jdi do Pádan Syrské do domu Bathuele, otce matky své, a pojmi sobě odtud manželku ze dcer Lábana ujce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A Bůh silný všemohoucí požehnejž tobě, a dejžť zrůst, a rozmnožiž tě, abys byl v zástup mnohého lidu. ");
INSERT INTO ces1613_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","A dejž tobě požehnání Abrahamovo, tobě i semeni tvému s tebou, abys dědičně obdržel zemi, v níž pohostinu jsi, kterouž dal Bůh Abrahamovi. ");
INSERT INTO ces1613_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","I odeslal Izák Jákoba, kterýžto šel do Pádan Syrské k Lábanovi synu Bathuele Syrského, bratru Rebeky matky Jákobovy a Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Vida pak Ezau, že požehnání dal Izák Jákobovi, a že ho odeslal do Pádan Syrské, aby sobě odtud vzal manželku, a že, když mu požehnání dával, přikázal mu, řka: Nepojmeš ženy ze dcer Kananejských; ");
INSERT INTO ces1613_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","A že by uposlechl Jákob otce svého a matky své a odšel do Pádan Syrské; ");
INSERT INTO ces1613_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Vida také Ezau, že dcery Kananejské těžké byly v očích Izákovi otci jeho: ");
INSERT INTO ces1613_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tedy odšel Ezau k Izmaelovi, a mimo prvnější ženy své, pojal sobě za ženu Mahalat, dceru Izmaele, syna Abrahamova, sestru Nabajotovu. ");
INSERT INTO ces1613_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Vyšed pak Jákob z Bersabé, šel do Cháran. ");
INSERT INTO ces1613_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I trefil na jedno místo, na kterémžto zůstal přes noc, (nebo slunce již bylo zapadlo,) a nabrav kamení na místě tom, položil pod hlavu svou, a spal na témž místě. ");
INSERT INTO ces1613_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I viděl ve snách, a aj, žebřík stál na zemi, jehožto vrch dosahal nebe; a aj, andělé Boží vstupovali a sstupovali po něm. ");
INSERT INTO ces1613_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","A aj, Hospodin stál nad ním, a řekl: Já jsem Hospodin, Bůh Abrahama otce tvého, a Bůh Izákův; zemi tu, na kteréž ty spíš, tobě dám a semeni tvému. ");
INSERT INTO ces1613_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","A bude símě tvé jako prach země; nebo rozmůžeš se k západu, i k východu, na půlnoci, i ku poledni; nad to požehnány budou v tobě všecky čeledi země, a v semeni tvém. ");
INSERT INTO ces1613_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","A aj, já jsem s tebou, a ostříhati tě budu, kamžkoli půjdeš, a přivedu tě zase do země této; nebo neopustím tebe, až i učiním, což jsem mluvil tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Procítiv pak Jákob ze sna svého, řekl: V pravdě Hospodin jest na místě tomto, a já jsem nevěděl. ");
INSERT INTO ces1613_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","(Nebo zhroziv se, řekl: Jak hrozné jest místo toto! Není jiného, jediné dům Boží, a tu jest brána nebeská.) ");
INSERT INTO ces1613_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Vstav pak Jákob ráno, vzal kámen, kterýž byl podložil pod hlavu svou, a postavil jej na znamení pamětné, a polil jej svrchu olejem. ");
INSERT INTO ces1613_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Protož nazval jméno místa toho Bethel, ješto prvé to město sloulo Lůza. ");
INSERT INTO ces1613_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Zavázal se také Jákob slibem, řka: Jestliže Bůh bude se mnou, a ostříhati mne bude na cestě této, kterouž já jdu; a dá-li mi chléb ku pokrmu a roucho k oděvu, ");
INSERT INTO ces1613_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","A navrátím-li se v pokoji do domu otce svého, a bude mi Hospodin za Boha: ");
INSERT INTO ces1613_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kámen tento, kterýž jsem postavil na památku, bude domem Božím; a ze všech věcí, kteréž mi dáš, desátky spravedlivě tobě dám. ");
INSERT INTO ces1613_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Tedy Jákob vstav, odšel do země východní. ");
INSERT INTO ces1613_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A pohleděv, uzřel studnici v poli a tři stáda ovcí, ana se složila při ní; nebo z té studnice napájeli stáda; a kámen veliký byl navrchu studnice. ");
INSERT INTO ces1613_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Shánívána pak tam bývala všecka stáda, a teprv odvalovali kámen ten od vrchu té studnice, a napájeli dobytky; potom zas přivalovali kámen na vrch studnice, na místo jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Tedy řekl jim Jákob: Bratří moji, odkud jste? Kteřížto odpověděli: Jsme z Cháran. ");
INSERT INTO ces1613_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I řekl jim: Znáte-li Lábana, syna Náchorova? A oni řekli: Známe. ");
INSERT INTO ces1613_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","I dí opět k nim: Dobře-li se má? Odpověděli: Dobře, a aj, Ráchel dcera jeho tamto jde s dobytkem. ");
INSERT INTO ces1613_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Tedy řekl: Však ještě daleko do večera, aniž ještě čas, aby dobytek byl sehnán; napojte stáda, a jděte, paste. ");
INSERT INTO ces1613_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","A oni odpověděli: Nemůžeme, než až se všecka stáda seženou, a odvalen bude kámen od svrchku studnice, abychom napojili ovce. ");
INSERT INTO ces1613_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Když on ještě mluvil s nimi, přišla k tomu Ráchel s stádem otce svého; neb ona pásla stádo. ");
INSERT INTO ces1613_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tedy Jákob uzřev Ráchel, dceru Lábana ujce svého, a stádo jeho, přistoupil a odvalil ten kámen od vrchu studnice, a napojil stádo Lábana ujce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","A políbil Jákob Ráchel, a povýšiv hlasu svého, plakal. ");
INSERT INTO ces1613_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Oznámil jí pak byl Jákob, že jest bratr otce jejího, a že jest syn Rebeky; a ona přiběhši, oznámila to otci svému. ");
INSERT INTO ces1613_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","I stalo se, když Lában uslyšel pověst o Jákobovi, synu sestry své, že vyběhl proti němu, a objav ho, políbil, a uvedl do domu svého; on pak vypravoval Lábanovi o všech těch věcech. ");
INSERT INTO ces1613_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Jemužto odpověděl Lában: Jistě kost má a tělo mé jsi. I zůstal s ním přes celý měsíc. ");
INSERT INTO ces1613_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Tedy řekl Lában Jákobovi: Zdali proto, že jsi bratr můj, darmo mi sloužiti budeš? Pověz mi, jaká má býti mzda tvá? ");
INSERT INTO ces1613_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","(Měl pak Lában dvě dcery; jméno starší Lía, a jméno mladší Ráchel. ");
INSERT INTO ces1613_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Než Lía měla oči mdlé, ale Ráchel byla pěkné postavy a krásné tváři. ");
INSERT INTO ces1613_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","I miloval Jákob Ráchel.) Řekl tedy: Buduť sloužiti sedm let za Ráchel, dceru tvou mladší. ");
INSERT INTO ces1613_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Odpověděl Lában: Lépeť jest, abych ji tobě dal, nežli bych ji dal muži jinému; zůstaniž se mnou. ");
INSERT INTO ces1613_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Takž Jákob sloužil za Ráchel sedm let; a bylo před očima jeho jako něco málo dnů, proto že laskav byl na ni. ");
INSERT INTO ces1613_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Potom řekl Jákob k Lábanovi: Dejž mi ženu mou; nebo vyplněni jsou dnové moji, abych všel k ní. ");
INSERT INTO ces1613_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tedy sezval Lában všecky muže místa toho, a učinil hody. ");
INSERT INTO ces1613_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","U večer pak vzav Líu, dceru svou, uvedl ji k němu; a on všel k ní. ");
INSERT INTO ces1613_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Dal také Lában Zelfu děvku svou Líe, dceři své, za služebnici. ");
INSERT INTO ces1613_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","A když bylo ráno, poznal, že jest Lía. I řekl k Lábanovi: Což jsi mi to učinil? Zdaliž jsem za Ráchel nesloužil u tebe? Pročežs mne tedy oklamal? ");
INSERT INTO ces1613_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Odpověděl Lában: Nebývá toho v kraji našem, aby vdávána byla mladší dříve, než prvorozená. ");
INSERT INTO ces1613_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Vyplň týden této; dámeť potom i tuto za službu, kterouž sloužiti budeš u mne ještě sedm let jiných. ");
INSERT INTO ces1613_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","I udělal tak Jákob, a vyplnil týden její. Potom dal mu Ráchel dceru svou za manželku. ");
INSERT INTO ces1613_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Dal také Lában Ráchel, dceři své, Bálu, děvku svou za služebnici. ");
INSERT INTO ces1613_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tedy všel také k Ráchel, a miloval ji více než Líu; i sloužil u něho ještě sedm let jiných. ");
INSERT INTO ces1613_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Vida pak Hospodin, že Lía nemá lásky, otevřel život její; a Ráchel nechal neplodné. ");
INSERT INTO ces1613_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Tedy počala Lía a porodila syna, a nazvala jméno jeho Ruben; nebo řekla: Jistě viděl Hospodin trápení mé; jižť nyní milovati mne bude muž můj. ");
INSERT INTO ces1613_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","I počala opět a porodila syna, a řekla: Jistě uslyšel Hospodin, že jsem v nenávisti, protož dal mi i tohoto. A nazvala jméno jeho Simeon. ");
INSERT INTO ces1613_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A opět počala a porodila syna, a řekla: Již nyní připojí se ke mně muž můj, nebo jsem mu porodila tři syny. Z té příčiny nazváno jest jméno jeho Léví. ");
INSERT INTO ces1613_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","I počala ještě a porodila syna, a řekla: Již nyní chváliti budu Hospodina. Pročež nazvala jméno jeho Juda; i přestala roditi. ");
INSERT INTO ces1613_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Viduci pak Ráchel, že by nerodila Jákobovi, záviděla sestře své, a řekla Jákobovi: Dej mi syny; pakli nedáš, umru. ");
INSERT INTO ces1613_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Pročež rozhněval se velmi Jákob na Ráchel, a řekl: Zdali já jsem za Boha, kterýžť nedal plodu života? ");
INSERT INTO ces1613_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Řekla ona: Hle, děvka má Bála; vejdi k ní, aby rodila na kolena má, a budu míti já také syny z ní. ");
INSERT INTO ces1613_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","I dala mu Bálu děvku svou za ženu; a všel k ní Jákob. ");
INSERT INTO ces1613_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tedy počavši Bála, porodila Jákobovi syna. ");
INSERT INTO ces1613_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","I řekla Ráchel: Soudil Bůh při mou, a uslyšel také hlas můj, a dal mi syna. Protož nazvala jméno jeho Dan. ");
INSERT INTO ces1613_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Opět počavši Bála, děvka Ráchel, porodila syna druhého Jákobovi. ");
INSERT INTO ces1613_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","I řekla Ráchel: Tuhé jsem odpory měla s sestrou svou, a všakť jsem přemohla. A nazvala jméno jeho Neftalím. ");
INSERT INTO ces1613_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Viduci pak Lía, že by přestala roditi, vzala Zelfu děvku svou, a dala ji Jákobovi za ženu. ");
INSERT INTO ces1613_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","A porodila Zelfa, děvka Líe, Jákobovi syna. ");
INSERT INTO ces1613_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Protož řekla Lía: Již přišel zástup. A nazvala jméno jeho Gád. ");
INSERT INTO ces1613_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Porodila také Zelfa děvka Líe syna druhého Jákobovi. ");
INSERT INTO ces1613_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","A řekla Lía: To na mé štěstí; nebo šťastnou mne nazývati budou ženy. A nazvala jméno jeho Asser. ");
INSERT INTO ces1613_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Vyšel pak Ruben v čas žně pšeničné, a nalezl pěkná jablečka na poli, a přinesl je Líe matce své. I řekla Ráchel Líe: Dej mi, prosím, těch jableček syna svého. ");
INSERT INTO ces1613_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Jížto ona odpověděla: Máloť se snad zdá, že jsi vzala muže mého; chceš také užívati jableček syna mého? I řekla Ráchel: Nechažť tedy spí s tebou této noci za jablečka syna tvého. ");
INSERT INTO ces1613_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Když pak navracoval se Jákob s pole večer, vyšla Lía proti němu, a řekla: Ke mně vejdeš; nebo ze mzdy najala jsem tě za jablečka syna svého. I spal s ní té noci. ");
INSERT INTO ces1613_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","A uslyšel Bůh Líu; kterážto počala a porodila Jákobovi syna pátého. ");
INSERT INTO ces1613_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","I řekla Lía: Dal mi Bůh mzdu mou, i potom, když jsem dala děvku svou muži svému. Pročež nazvala jméno jeho Izachar. ");
INSERT INTO ces1613_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","A počala opět Lía, a porodila šestého syna Jákobovi. ");
INSERT INTO ces1613_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","I řekla Lía: Obdařil mne Bůh darem dobrým; již nyní bydliti bude se mnou muž můj, nebo porodila jsem mu šest synů. A nazvala jméno jeho Zabulon. ");
INSERT INTO ces1613_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Potom porodila dceru; a nazvala jméno její Dína. ");
INSERT INTO ces1613_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","A rozpomenuv se Bůh na Ráchel, uslyšel jí, a otevřel život její. ");
INSERT INTO ces1613_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tedy počala a porodila syna, a řekla: Odjal Bůh pohanění mé. ");
INSERT INTO ces1613_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A nazvala jméno jeho Jozef, řkuci: Přidejž mi Hospodin syna jiného. ");
INSERT INTO ces1613_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Stalo se pak, když porodila Ráchel Jozefa, řekl Jákob Lábanovi: Propusť mne, ať odejdu na místo své a do země své. ");
INSERT INTO ces1613_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dej mi ženy mé a dítky mé, za kteréž jsem sloužil tobě, ať odejdu; nebo ty znáš službu mou, kterouž jsem sloužil tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","I řekl mu Lában: Jestliže nyní nalezl jsem milost před očima tvýma, zůstaň se mnou, nebo v skutku jsem poznal, že požehnal mi Hospodin pro tebe. ");
INSERT INTO ces1613_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Řekl také: Oznam mi ze jména mzdu svou a dámť ji. ");
INSERT INTO ces1613_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jemužto odpověděl: Ty víš, jak jsem sloužil tobě, a jaký byl dobytek tvůj při mně. ");
INSERT INTO ces1613_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nebo to málo, kteréž jsi měl přede mnou, zrostlo velmi, a požehnalť Hospodin, jakž jsem k tobě nohou vkročil. A nyní, kdy pak já své hospodářství opatrovati budu? ");
INSERT INTO ces1613_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","A řekl: Coť mám dáti? Odpověděl Jákob: Nedávej mi nic. Jestliže mi učiníš toto, zase pásti budu a ostříhati dobytka tvého: ");
INSERT INTO ces1613_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Projdu skrze všecka stáda tvá dnes, vyměšuje z nich každé dobytče peřesté a strakaté, a každé dobytče načernalé mezi ovcemi, a strakaté a peřesté mezi kozami; a takové budou mzda má. ");
INSERT INTO ces1613_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","A osvědčena potom bude spravedlnost má před tebou, když přijde na mzdu mou: Cožkoli nebude peřestého, neb strakatého mezi kozami, a načernalého mezi ovcemi, za krádež bude mi to počteno. ");
INSERT INTO ces1613_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","I řekl Lában: Hle, ó by tak bylo, jakž jsi mluvil. ");
INSERT INTO ces1613_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","A odloučil toho dne kozly přepásané na nohách a strakaté, a všecky kozy peřesté a strakaté, všecko, na čemž byla místa bílá, všecko také načernalé mezi dobytkem, a dal v ruce synů svých. ");
INSERT INTO ces1613_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Uložil pak mezi sebou a Jákobem místo vzdálí tří dní cesty; a Jákob pásl ostatek dobytka Lábanova. ");
INSERT INTO ces1613_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nabral pak sobě Jákob prutů topolových zelených, a lískových a kaštanových; a poobloupil s nich po místech kůru až do bělosti, kteráž byla na prutech. ");
INSERT INTO ces1613_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A nakladl těch prutů tak obloupených do žlábků a koryt, (v nichž bývá voda, k nimž přicházel dobytek, aby pil), proti dobytku, aby počínaly, když by přicházely píti. ");
INSERT INTO ces1613_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","I počínaly ovce, hledíce na ty pruty, a rodily jehňata přepásaná na nohách, a peřestá i strakatá. ");
INSERT INTO ces1613_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Potom ta jehňata odloučil Jákob, a dobytek stáda Lábanova obrátil tváří k těm přepásaným na nohách, a ke všemu načernalému; a své stádo postavil obzvlášť, a neobrátil ho k stádu Lábanovu. ");
INSERT INTO ces1613_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","A bylo, že kdyžkoli silnější připouštíny bývaly, kladl Jákob ty pruty před oči ovcem do koryt, aby počínaly, hledíce na pruty. ");
INSERT INTO ces1613_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Když pak pozdní dobytek připouštín býval, nekladl jich; a tak býval pozdní Lábanův a ranný Jákobův. ");
INSERT INTO ces1613_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Vzrostl tedy muž ten náramně velmi, a měl dobytka mnoho, děvek i služebníků, velbloudů i oslů. ");
INSERT INTO ces1613_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Když pak uslyšel Jákob slova synů Lábanových, ani praví: Pobral Jákob všecko, co měl otec náš, a z těch věcí, kteréž byly otce našeho, způsobil sobě tu všecku slávu; ");
INSERT INTO ces1613_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","A viděl tvář Lábanovu, a aj, nebyla k němu tak jako prvé: ");
INSERT INTO ces1613_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","I řekl mu Hospodin: Navrať se do země otců svých, a k příbuznosti své, a budu s tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Protož poslav Jákob, vyvolal Ráchele a Líe na pole k stádu svému. ");
INSERT INTO ces1613_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A řekl jim: Vidím tvář otce vašeho, že není ke mně tak jako prvé, ješto Bůh otce mého byl se mnou. ");
INSERT INTO ces1613_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","A vy samy víte, že vší svou silou sloužil jsem otci vašemu. ");
INSERT INTO ces1613_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ale otec váš oklamal mne, a na desetkráte změnil mzdu mou; však nedopustil mu Bůh, aby mi zle učinil. ");
INSERT INTO ces1613_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Když takto řekl: Co bude peřestého, to nechť jest mzda tvá, tedy všecky ovce rodily peřestý plod. Když pak takto řekl: Co přepásaného na nohách, to bude mzda tvá, tedy všecky ovce rodily přepásané na nohách. ");
INSERT INTO ces1613_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","A tak odjal Bůh stádo otce vašeho a dal mně. ");
INSERT INTO ces1613_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Nebo takto bylo: Tehdáž, když se dobytek běžel, já jsem pozdvihl očí svých, a viděl jsem ve snách, a aj, berani scházející se s ovcemi byli přepásaní na nohách, peřestí a skropení. ");
INSERT INTO ces1613_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tedy řekl mi anděl Boží ve snách: Jákobe! A já jsem odpověděl: Teď jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","I řekl: Pozdvihni nyní očí svých a pohleď, že všickni berani scházející se s ovcemi jsou přepásaní na nohách, peřestí a skropení; nebo jsem viděl všecko, co tobě Lában dělá. ");
INSERT INTO ces1613_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Já jsem ten silný Bůh, kterýž jsem se ukázal tobě v Bethel, kdež jsi pomazal kamene, kdež jsi mi se slibem zavázal; vstaniž nyní, vyjdi z země této, a navrať se do země příbuznosti své. ");
INSERT INTO ces1613_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tedy odpověděly mu Ráchel a Lía, řkouce: Zdaž ještě máme díl jaký a dědictví v domě otce našeho? ");
INSERT INTO ces1613_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Zdaliž nejsme počteny před ním za cizí? Nebo prodal nás, ano i peníze naše do čista utratil. ");
INSERT INTO ces1613_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Všecko zajisté bohatství, kteréž odjal Bůh otci našemu, naše jest a synů našich; protož nyní učiň vše, což mluvil tobě Bůh. ");
INSERT INTO ces1613_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Vstav tedy Jákob, vsadil syny své a ženy své na velbloudy. ");
INSERT INTO ces1613_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A pobral všecken dobytek svůj, a všecko jmění své, kteréhož byl dosáhl, dobytek svého vychování, kteréhož nabyl v Pádan Syrské, aby se navrátil k Izákovi otci svému do země Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","(Lában pak byl odšel, aby střihl ovce své. V tom ukradla Ráchel modly, kteréž měl otec její. ");
INSERT INTO ces1613_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","I ušel Jákob tajně od Lábana Syrského, neoznámiv mu, že jde pryč.) ");
INSERT INTO ces1613_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Takž ušel se vším, což měl; a vstav, přepravil se přes řeku, a bral se přímo k hoře Galádské. ");
INSERT INTO ces1613_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","I povědíno jest Lábanovi dne třetího, že utekl Jákob. ");
INSERT INTO ces1613_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tedy on vzav bratří své s sebou, honil ho za dnů sedm; a postihl ho na hoře Galádské. ");
INSERT INTO ces1613_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","(Přišed pak Bůh k Lábanovi Syrskému ve snách noci té, řekl mu: Varuj se, abys nemluvil s Jákobem nic jináč než přátelsky.) ");
INSERT INTO ces1613_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Dohonil tedy Lában Jákoba; a Jákob již byl rozbil stan svůj na té hoře; Lában také položil se s bratřími svými na též hoře Galádské. ");
INSERT INTO ces1613_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","I řekl Lában k Jákobovi: Cos to učinil? Nebo jsi ušel tajně, a odvedls dcery mé jako zjímané mečem. ");
INSERT INTO ces1613_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Proč jsi tajně utekl, a vykradl se ode mne, a nepověděls mi, ješto bych tě byl vesele sprovodil s zpěvy, s bubnem a s harfou? ");
INSERT INTO ces1613_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","A nedopustils mi, abych políbil synů svých a dcer svých? Nemoudřes jistě udělal, čině tak. ");
INSERT INTO ces1613_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mělť bych dosti s to moci, abych vám zle učinil, ale Bůh otce vašeho mluvil mi noci pominulé, řka: Hleď, abys nemluvil s Jákobem nic jináč, než přátelsky. ");
INSERT INTO ces1613_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ale již to tam, poněvadž jsi předce odšel, roztouživ se po domu otce svého; než proč jsi ukradl bohy mé? ");
INSERT INTO ces1613_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tedy Jákob odpovídaje Lábanovi, řekl: Ušel jsem tajně; nebo jsem se bál a řekl jsem, že bys snad mocí odjal dcery své. ");
INSERT INTO ces1613_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nalezneš-li pak u koho bohy své, nechať ten umře; před bratřími našimi ohledej sobě, jest-li co u mne tvého, a vezmi sobě. Ale nevěděl Jákob, že Ráchel je ukradla. ");
INSERT INTO ces1613_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Všed tedy Lában do stanu Jákobova, a do stanu Líe, a do stanu obou děvek, nic nenalezl. A vyšed z stanu Líe, všel do stanu Ráchel. ");
INSERT INTO ces1613_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ráchel pak vzavši modly, vložila je pod sedlo, kteréž na velbloudu bývá, a sedla na ně. I přemetal Lában všecken stan, ale nic nenalezl. ");
INSERT INTO ces1613_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","A ona řekla otci svému: Nechť to není proti mysli, pane můj, že nemohu povstati proti tobě; nebo vedlé běhu ženského nyní mi se přihodilo. A všecko přehledav, nenalezl modl. ");
INSERT INTO ces1613_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Protož rozhněvav se Jákob, tuze se domlouval na Lábana. I odpověděl Jákob, a řekl Lábanovi: Jaké jest přestoupení mé? Jaký hřích můj, že rozpáliv se, honíš mne? ");
INSERT INTO ces1613_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nu již jsi přemetal všecky mé věci, a cos nalezl ze všech věcí domu svého? Polož teď před bratřími mými a bratřími svými, nechť rozeznají mezi námi dvěma. ");
INSERT INTO ces1613_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Byl jsem již dvadceti let s tebou; ovce tvé ani kozy tvé nikdy nezmetaly; a skopců stáda tvého nejedl jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Co od zvěři roztrháno, toho jsem neodvodil tobě; sám jsem tu škodu nahražoval, a ty jsi z ruky mé vyhledával toho, jako i toho, co bylo ukradeno ve dne aneb v noci. ");
INSERT INTO ces1613_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Bývalo tak, že ve dne trápilo mne horko, a v noci mráz, tak že odcházel i sen můj od očí mých. ");
INSERT INTO ces1613_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Již dvadceti let, jakž jsem v domě tvém; sloužil jsem tobě čtrnácte let za dvě dcery tvé, a šest let za dobytek tvůj, a změnils mzdu mou na desetkrát. ");
INSERT INTO ces1613_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","A kdyby Bůh otce mého, Bůh Abrahamův, a strach Izákův nebyl se mnou, jistě bys ty byl nyní pustil mne prázdného; ale trápení mé, a práci rukou mých viděl Bůh, protož tě pominulé noci trestal. ");
INSERT INTO ces1613_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Odpovídaje pak Lában, dí Jákobovi: Dcery tyto jsou dcery mé a synové tito jsou synové moji, i dobytek tento můj dobytek jest, ano cokoli vidíš, mé jest; ale což mám již učiniti dcerám těmto svým aneb synům jich, kteréž zrodily? ");
INSERT INTO ces1613_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Protož poď, vejděme v smlouvu já a ty, aby byla na svědectví mezi mnou a tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tedy Jákob vzal kámen, a postavil jej vzhůru na znamení. ");
INSERT INTO ces1613_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","A řekl bratřím svým: Nasbírejte kamení. A nabravše kamení, udělali hromadu, a jedli tu na té hromadě. ");
INSERT INTO ces1613_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","I nazval ji Lában Jegar Sahadutha, a Jákob nazval ji Gál Ed. ");
INSERT INTO ces1613_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nebo řekl Lában: Tato hromada nechžť jest svědkem od dnešku mezi mnou a tebou. Protož nazval jméno její Gál Ed, ");
INSERT INTO ces1613_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","A Mispah; nebo řekl Lában: Nechať Hospodin hledí na mne a na tebe, když se rozejdeme od sebe. ");
INSERT INTO ces1613_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Jestliže bys trápil dcery mé, a uvedl bys jiné ženy na dcery mé, žádného člověka není s námi; hlediž, Bůh jest svědek mezi mnou a tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","A řekl ještě Lában Jákobovi: Aj, hromada tato, a aj, sloup, kterýž jsem postavil mezi sebou a tebou, ");
INSERT INTO ces1613_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Svědkem ať jest hromada tato, svědkem také sloup tento, já že nepůjdu dále k tobě za hromadu tuto, a ty tolikéž že nepůjdeš dále ke mně za hromadu tuto a sloup tento, k činění zlého. ");
INSERT INTO ces1613_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bůh Abrahamův, a Bůh Náchorův, Bůh otce jejich nechť soudí mezi námi. Přisáhl tedy Jákob skrze strach otce svého Izáka. ");
INSERT INTO ces1613_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nabil také Jákob hovad na té hoře, a pozval bratří svých, aby hodovali; i hodovali a zůstali přes noc na též hoře. ");
INSERT INTO ces1613_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","I vstal Lában velmi ráno, a políbiv synů svých a dcer svých, požehnal jich; i odšel a navrátil se k místu svému. ");
INSERT INTO ces1613_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jákob pak odšel cestou svou, a potkali se s ním andělé Boží. ");
INSERT INTO ces1613_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","I řekl Jákob, když je viděl: Vojsko Boží jest toto. A nazval jméno místa toho Mahanaim. ");
INSERT INTO ces1613_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Poslal pak Jákob posly před sebou k bratru svému Ezau, do země Seir, do kraje Idumejského. ");
INSERT INTO ces1613_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","A přikázal jim, řka: Takto povězte pánu mému Ezau: Totoť vzkazuje služebník tvůj Jákob: U Lábana jsem byl pohostinu, a zůstával až do tohoto času. ");
INSERT INTO ces1613_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A mám voly a osly, ovce, a služebníky i děvky; a poslal jsem, abych se ohlásil pánu svému, a našel milost před očima tvýma. ");
INSERT INTO ces1613_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","I navrátili se poslové k Jákobovi, řkouce: Přišli jsme k bratru tvému Ezau, kterýž také jde proti tobě, a čtyři sta mužů s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jákob pak bál se velmi, a rmoutil se náramně. Tedy rozdělil lid, kterýž s sebou měl, ovce také a voly, a velbloudy na dva houfy. ");
INSERT INTO ces1613_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nebo řekl: Jestliže by přišel Ezau k houfu jednomu, a pobil by jej, bude aspoň zadní houf zachován. ");
INSERT INTO ces1613_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","I řekl Jákob: Bože otce mého Abrahama, a Bože otce mého Izáka, Hospodine, kterýž jsi mi řekl: Navrať se do země své, a k příbuznosti své, a dobře učiním tobě, ");
INSERT INTO ces1613_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Menší jsem všech milosrdenství a vší pravdy, kterouž jsi učinil s služebníkem svým; nebo s holí svou přešel jsem Jordán tento, nyní pak dva houfy mám. ");
INSERT INTO ces1613_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Vytrhni mne, prosím, z ruky bratra mého, z ruky Ezau; nebť se ho bojím, aby přijda, nepohubil mne i matky s dětmi. ");
INSERT INTO ces1613_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Však jsi ty řekl: Dobře učiním tobě, a rozmnožím símě tvé jako písek mořský, kterýžto pro množství sečten býti nemůže. ");
INSERT INTO ces1613_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I zůstal tu noci té; a vzal z toho, což bylo před rukama, poctu bratru svému Ezau: ");
INSERT INTO ces1613_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Totiž dvě stě koz, a kozlů dvadceti, ovec dvě stě, a beranů dvadceti, ");
INSERT INTO ces1613_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Velbloudů s mladými jich třidceti, krav čtyřidceti, volů deset, oslic dvadceti, a oslátek deset. ");
INSERT INTO ces1613_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","A poručil je služebníkům svým, každé stádo obzvláštně, a řekl služebníkům svým: Jděte přede mnou, a stádo od stáda ať jde opodál. ");
INSERT INTO ces1613_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I poručil přednímu, řka: Když se potká s tebou Ezau bratr můj, a optá se tebe, řka Èí jsi? a kam jdeš? a čí jest to stádo před tebou? ");
INSERT INTO ces1613_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Řekneš: Jsem služebníka tvého Jákoba, a dar tento jest poslán pánu mému Ezau; a teď i sám jde za námi. ");
INSERT INTO ces1613_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Poručil také druhému i třetímu, a všechněm jdoucím za těmi stády, řka: V táž slova mluvte k Ezau, když byste naň trefili. ");
INSERT INTO ces1613_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","A díte také: Aj, služebník tvůj Jákob za námi; nebo řekl: Ukrotím tvář jeho darem, kterýž jde přede mnou, a potom uzřím tvář jeho; snad přijme tvář mou. ");
INSERT INTO ces1613_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","A tak předšel dar před ním; on pak zůstal tu noc při houfu. ");
INSERT INTO ces1613_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","A vstav ještě v noci, vzal obě ženy své, a dvě děvky své, a jedenácte synů svých, a přešel přes brod Jabok. ");
INSERT INTO ces1613_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Vzav tedy je, přepravil je přes tu řeku; přepravil také i vše, což měl. ");
INSERT INTO ces1613_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A zůstal Jákob sám; a tu zápasil s ním muž až do svitání. ");
INSERT INTO ces1613_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A vida, že ho nepřemůže, obrazil jej v příhbí vrchní stehna jeho; i vyvinulo se příhbí stehna Jákobova, když zápasil s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","A řekl: Pusť mne, nebť zasvitává. I řekl: Nepustím tě, leč mi požehnáš. ");
INSERT INTO ces1613_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","I řekl jemu: Jaké jest jméno tvé? Odpověděl: Jákob. ");
INSERT INTO ces1613_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","I dí: Nebude více nazýváno jméno tvé toliko Jákob, ale také Izrael; nebo jsi statečně zacházel s Bohem i lidmi, a přemohls. ");
INSERT INTO ces1613_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","I otázal se Jákob, řka: Oznam, prosím, jméno své. Kterýžto odpověděl: Proč se ptáš na jméno mé? I dal mu tu požehnání. ");
INSERT INTO ces1613_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Tedy nazval Jákob jméno místa toho Fanuel; nebo jsem prý viděl Boha tváří v tvář, a zachována jest duše má. ");
INSERT INTO ces1613_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I vzešlo mu slunce, když pominul místa toho Fanuel, a kulhal na nohu svou. ");
INSERT INTO ces1613_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Protož nejedí synové Izraelští až do tohoto dne té žily krátké, kteráž jest v vrchním příhbí stehna, proto že obrazil příhbí stehna Jákobova na žile krátké. ");
INSERT INTO ces1613_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Pozdvih pak očí svých Jákob, uzřel, an Ezau jde, a čtyři sta mužů s ním; i rozdělil syny Líe zvlášť a Ráchele zvlášť, a obou děvek zvlášť. ");
INSERT INTO ces1613_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Postavil, pravím, děvky s syny jejich napřed, potom Líu s syny jejími za nimi, Ráchel pak a Jozefa nejzáze. ");
INSERT INTO ces1613_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A sám šel před nimi, a poklonil se až k zemi po sedmkrát, až právě přišel k bratru svému. ");
INSERT INTO ces1613_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","I běžel Ezau proti němu, a objal ho; a pad na šíji jeho, líbal ho. I plakali. ");
INSERT INTO ces1613_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Pozdvih pak očí svých, a spatřiv ženy s dětmi, řekl: Kdo jsou onino s tebou? Odpověděl: Jsou dítky, kteréž Bůh dal z milosti služebníku tvému. ");
INSERT INTO ces1613_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mezi tím přiblížily se děvky s syny svými, i poklonili se. ");
INSERT INTO ces1613_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Přiblížila se také Lía s syny svými, a poklonili se; a potom přiblížil se Jozef a Ráchel, a také se poklonili. ");
INSERT INTO ces1613_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","I řekl Ezau: K čemu jest všecken ten houf, kterýž jsem potkal? Odpověděl: Abych nalezl milost před očima pána mého. ");
INSERT INTO ces1613_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tedy řekl Ezau: Mám hojně, bratře můj; nech sobě, což tvého jest. ");
INSERT INTO ces1613_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","I řekl Jákob: Nezbraňuj se, prosím; jestliže jsem nyní nalezl milost před očima tvýma, přijmi dar můj z ruky mé, poněvadž jsem viděl tvář tvou, jako bych viděl tvář Boží, a laskavě jsi mne přijal. ");
INSERT INTO ces1613_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Přijmi, prosím, dar můj obětovaný tobě, poněvadž štědře obdařil mne Bůh, a mám všeho dosti. Takž ho přinutil, a on vzal. ");
INSERT INTO ces1613_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","I dí: Poď, a jděme; já půjdu s tebou. ");
INSERT INTO ces1613_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","I řekl k němu Jákob: Ví pán můj, že děti jsou outlí, a mám s sebou ovce i krávy březí; kteréžto budou-li hnány přes moc jeden den, pomře mi všecken dobytek. ");
INSERT INTO ces1613_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nechžť medle jde pán můj před služebníkem svým, já pak poznenáhlu se poberu, tak jakž bude moci jíti stádo, kteréž před sebou mám, a jakž postačiti budou moci děti, až tak dojdu ku pánu svému do Seir. ");
INSERT INTO ces1613_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","I řekl Ezau: Nechť ale pozůstavím něco lidu, kterýž mám s sebou. I odpověděl: K čemu to? Nechť toliko naleznu milost před očima pána svého. ");
INSERT INTO ces1613_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tedy Ezau toho dne navrátil se cestou svou do Seir. ");
INSERT INTO ces1613_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jákob pak bral se do Sochot, a ustavěl sobě dům, a dobytku svému zdělal stáje; protož nazval jméno místa toho Sochot. ");
INSERT INTO ces1613_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","A tak Jákob navracuje se z Pádan Syrské, přišel ve zdraví k městu Sichem, kteréž jest v zemi Kananejské, a položil se před městem. ");
INSERT INTO ces1613_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","I koupil díl pole toho, na němž byl rozbil stan svůj, od synů Emora, otce Sichemova, za sto ovec. ");
INSERT INTO ces1613_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A postavil tu oltář, kterémužto dal jméno Bůh silný, Bůh Izraelský. ");
INSERT INTO ces1613_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Vyšla pak Dína, dcera Líe, kterouž porodila Jákobovi, aby se dívala na dcery té země. ");
INSERT INTO ces1613_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kteroužto uzřev Sichem, syn Emora Hevejského, knížete v krajině té, vzal ji, i ležel s ní, a ponížil jí. ");
INSERT INTO ces1613_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","I připojila se duše jeho k Díně, dceři Jákobově; a zamilovav děvečku, mluvil k srdci jejímu. ");
INSERT INTO ces1613_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Mluvil potom Sichem k Emorovi, otci svému, těmito slovy: Vezmi mi děvečku tuto za manželku. ");
INSERT INTO ces1613_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Uslyšev pak Jákob, že poškvrnil Díny dcery jeho, (a synové jeho byli s stádem na poli), mlčel, až oni přišli. ");
INSERT INTO ces1613_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tedy vyšel Emor, otec Sichemův, k Jákobovi, aby mluvil s ním o to. ");
INSERT INTO ces1613_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","A v tom synové Jákobovi přišli s pole; a uslyšavše o tom, bolestí naplněni jsou muži ti, a rozhněvali se velmi, proto že hanebnou věc učinil v Izraeli, ležav se dcerou Jákobovou, čehož činiti nenáleželo. ");
INSERT INTO ces1613_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","I mluvil Emor s nimi na tento způsob: Sichem, syn můj, hoří milostí k vaší dceři; prosím, dejte mu ji za manželku. ");
INSERT INTO ces1613_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","A spřízněte se s námi: Dcery své dávejte nám, a naše dcery pojímejte sobě. ");
INSERT INTO ces1613_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","A bydlete s námi, nebo všecka země bude před vámi; osaďte se a obchod veďte v ní, a vládněte jí. ");
INSERT INTO ces1613_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Mluvil i Sichem otci jejímu, a bratřím jejím: Nechť naleznu milost před očima vašima, dám, co mi koli díte. ");
INSERT INTO ces1613_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Jmenujte mi věno i dary jak chcete veliké, dám, jak mi koli řeknete; jen mi tu děvečku dejte za manželku. ");
INSERT INTO ces1613_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Odpovídajíce pak synové Jákobovi Sichemovi a Emorovi, otci jeho, lstivě mluvili, proto že poškvrnil Díny sestry jich. ");
INSERT INTO ces1613_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","A řekli jim: Nemůžeme učiniti toho, abychom dali sestru svou za muže neobřezaného; nebo to ohavnost jest u nás. ");
INSERT INTO ces1613_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Než na tento způsob vám povolíme: Jestliže se chcete srovnati s námi, aby obřezán byl každý z vás pohlaví mužského: ");
INSERT INTO ces1613_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tedy budeme dávati dcery své vám, a dcery vaše bráti sobě; a budeme bydliti s vámi, a budeme lid jeden. ");
INSERT INTO ces1613_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pakli neuposlechnete nás, abyste se obřezali, vezmeme zase dceru svou a odejdeme. ");
INSERT INTO ces1613_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tedy líbila se řeč jejich Emorovi i Sichemovi, synu Emorovu. ");
INSERT INTO ces1613_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","A nemeškal mládenec učiniti toho; nebo se mu zalíbila dcera Jákobova. A on byl nejvzácnější ze všech v domě otce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","I přišel Emor a Sichem, syn jeho, k bráně města svého; a mluvili mužům města svého, řkouce: ");
INSERT INTO ces1613_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Muži tito pokojně se mají k nám, nechť tedy bydlí v zemi této, a obchod vedou v ní, (nebo země jest dosti široká a prostranná před nimi;) dcery jejich budeme sobě bráti za manželky, a dcery své budeme dávati jim. ");
INSERT INTO ces1613_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Než na tento způsob přivolí nám ti muži k tomu, aby bydlili s námi, a abychom byli jeden lid: Jestliže obřezán bude každý pohlaví mužského mezi námi, tak jako oni jsou obřezáni. ");
INSERT INTO ces1613_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Dobytek jejich a statek jejich, i všecka hovada jejich, zdaliž nebudou naše? Toliko v tom jim povolme, a budou bydliti s námi. ");
INSERT INTO ces1613_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","I uposlechli Emora a Sichema, syna jeho, všickni vycházející branou města jeho; a obřezali se všickni pohlaví mužského, což jich koli vycházelo z brány města jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A toť dne třetího, když oni největší bolest měli, dva synové Jákobovi, Simeon a Léví, bratří Díny, vzav každý z nich meč svůj, vpadli do města směle, a pomordovali všecky pohlaví mužského. ");
INSERT INTO ces1613_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Emora také a Sichema, syna jeho, zamordovali mečem, a vzavše Dínu z domu Sichemova, odešli. ");
INSERT INTO ces1613_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Potom synové Jákobovi přišedše na zbité, vzebrali město, proto že poškvrnili sestry jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Stáda jejich, a voly i osly jejich, a což bylo v městě i po poli, pobrali. ");
INSERT INTO ces1613_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","K tomu i všecko jmění jejich, a všecky malé dítky jejich, a ženy jejich zajali, a vybrali, co kde v domích bylo. ");
INSERT INTO ces1613_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Řekl pak Jákob Simeonovi a Léví: Zkormoutili jste mne, a zošklivili jste mne u obyvatelů krajiny této, u Kananejských a Ferezejských, a já jsem s malým počtem lidí. Seberou-li se na mne, zbijí mne, a tak vyhlazen budu já i dům můj. ");
INSERT INTO ces1613_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","A oni odpověděli: A což měli jako nevěstky zle užívati sestry naší? ");
INSERT INTO ces1613_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Potom mluvil Bůh k Jákobovi: Vstana, vstup do Bethel, a bydli tam; a udělej tam oltář Bohu silnému, kterýž se ukázal tobě, kdyžs utíkal před Ezau bratrem svým. ");
INSERT INTO ces1613_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tedy řekl Jákob čeládce své, a všechněm, kteříž s ním byli: Odvrzte bohy cizí, kteréž máte mezi sebou, a očisťte se, a změňte roucha svá. ");
INSERT INTO ces1613_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","A vstanouce, vstupme do Bethel, a udělám tam oltář silnému Bohu, kterýž vyslyšel mne v den ssoužení mého, a byl se mnou na cestě, kterouž jsem šel. ");
INSERT INTO ces1613_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tedy dali Jákobovi všecky bohy cizí, kteréž měli, i náušnice, kteréž byly na uších jejich; i zakopal je Jákob pod tím dubem, kterýž byl u Sichem. ");
INSERT INTO ces1613_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","I brali se odtud. (A byl strach Boží na městech, kteráž byla vůkol nich, a nehonili synů Jákobových.) ");
INSERT INTO ces1613_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Tedy přišel Jákob do Lůz, kteréž jest v zemi Kananejské, (to již slove Bethel,) on i všecken lid, kterýž byl s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","I vzdělal tu oltář, a nazval to místo Bůh silný Bethel; nebo tu se mu byl zjevil Bůh, když utíkal před bratrem svým. ");
INSERT INTO ces1613_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tehdy umřela Debora, chovačka Rebeky, a pochována jest pod Bethel, pod dubem; i nazval jméno jeho Allon Bachuth. ");
INSERT INTO ces1613_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ukázal se pak opět Bůh Jákobovi, když se navracoval z Pádan Syrské, a požehnal mu. ");
INSERT INTO ces1613_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","I řekl jemu Bůh: Jméno tvé jest Jákob. Nebude více nazývano jméno tvé toliko Jákob, ale Izrael také bude jméno tvé. Protož nazval jméno jeho Izrael. ");
INSERT INTO ces1613_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Řekl ještě Bůh jemu: Já jsem Bůh silný všemohoucí; rostiž a množ se; národ, nýbrž množství národů bude z tebe, i králové z bedr tvých vyjdou. ");
INSERT INTO ces1613_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","A zemi tu, kterouž jsem dal Abrahamovi a Izákovi, tobě ji dám; semeni také tvému po tobě dám tu zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","I vstoupil od něho Bůh z místa, na kterémž mluvil s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jákob pak vyzdvihl znamení pamětné na místě tom, na kterémž mluvil s ním, sloup kamenný; a pokropil ho skropením, a svrchu polil jej olejem. ");
INSERT INTO ces1613_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","A nazval Jákob jméno místa toho, na kterémž mluvil s ním Bůh, Bethel. ");
INSERT INTO ces1613_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","I brali se z Bethel, a bylo již nedaleko do Efraty. I porodila Ráchel, a těžkosti trpěla roděci. ");
INSERT INTO ces1613_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","A když s těžkostí rodila, řekla jí baba: Neboj se, nebo také tohoto syna míti budeš. ");
INSERT INTO ces1613_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","I stalo se, když k smrti pracovala, (nebo umřela), nazvala jméno jeho Ben Oni; ale otec jeho nazval ho Beniaminem. ");
INSERT INTO ces1613_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","I umřela Ráchel, a pochována jest na cestě k Efratě, jenž jest Betlém. ");
INSERT INTO ces1613_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","A postavil Jákob znamení pamětné nad hrobem jejím; toť jest znamení hrobu Ráchel až do dnešního dne. ");
INSERT INTO ces1613_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","I odebral se odtud Izrael, a rozbil stan svůj za věží Eder. ");
INSERT INTO ces1613_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Stalo se pak také, když bydlil Izrael v té krajině, že Ruben šel, a spal s Bálou, ženinou otce svého; o čemž uslyšel Izrael. Bylo pak synů Jákobových dvanácte. ");
INSERT INTO ces1613_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Synové pak Líe: Prvorozený Jákobův Ruben, potom Simeon, a Léví, a Juda, a Izachar, a Zabulon. ");
INSERT INTO ces1613_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Synové Ráchel: Jozef a Beniamin. ");
INSERT INTO ces1613_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","A synové Bály, děvky Ráchel: Dan a Neftalím. ");
INSERT INTO ces1613_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","A synové Zelfy, děvky Líe: Gád a Asser. Tiť jsou synové Jákobovi, kteříž mu zrozeni jsou v Pádan Syrské. ");
INSERT INTO ces1613_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Tedy přišel Jákob k Izákovi otci svému do Mamre, do města Arbe, jenž jest Hebron, kdežto bydlil pohostinu Abraham a Izák. ");
INSERT INTO ces1613_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","A bylo dnů Izákových sto osmdesáte let. ");
INSERT INTO ces1613_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","I dokonal Izák, a umřel, a připojen jest k lidu svému, stár jsa a plný dnů; i pochovali ho Ezau a Jákob, synové jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Tito jsou pak rodové Ezau, kterýž měl přijmí Edom. ");
INSERT INTO ces1613_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezau pojal sobě ženy ze dcer Kananejských, Adu, dceru Elona Hetejského, a Olibamu, dceru Anovu, dceru Sebeona Hevejského, ");
INSERT INTO ces1613_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","A Bazematu, dceru Izmaelovu, sestru Nabajotovu. ");
INSERT INTO ces1613_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","I porodila Ada Ezauchovi Elifaza, a Bazemat porodila Rahuele. ");
INSERT INTO ces1613_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama pak porodila Jehusa, a Jheloma, a Koré. Ti jsou synové Ezau, kteříž se mu zrodili v zemi Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","I pobral Ezau ženy své, i syny své, a dcery své, a všecku čeleď svou, i dobytek svůj, a všecka hovada svá, i všecko jmění své, kteréhož nabyl v zemi Kananejské, a odebral se do země Seir, před příchodem Jákoba bratra svého. ");
INSERT INTO ces1613_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nebo zboží jejich bylo tak veliké, že nemohli bydliti spolu; aniž ta země, v níž oni pohostinu byli, mohla jich snésti, pro dobytky jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Protož bydlil Ezau na hoře Seir; Ezau pak ten jest Edom. ");
INSERT INTO ces1613_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","A tak tito jsou rodové Ezau, otce Idumejských, na hoře Seir. ");
INSERT INTO ces1613_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Tato byla jména synů Ezau: Elifaz, syn Ady, ženy Ezau; Rahuel, syn Bazematy, ženy Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Synové pak Elifazovi byli: Teman, Omar, Sefo, a Gatam a Kenaz. ");
INSERT INTO ces1613_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Tamna pak byla ženina Elifaza, syna Ezau. Ta porodila Elifazovi Amalecha. Ti jsou synové Ady, ženy Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Synové pak Rahuelovi tito: Nahat, Zára, Samma a Méza. To byli synové Bazematy, ženy Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","A tito byli synové Olibamy, dcery Anovy, dcery Sebeonovy, ženy Ezau, kteráž porodila Ezauchovi Jehusa, Jheloma a Koré. ");
INSERT INTO ces1613_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Tito všickni byli knížata synů Ezau. Synové Elifaza prvorozeného Ezau: Kníže Teman, kníže Omar, kníže Sefo, kníže Kenaz, ");
INSERT INTO ces1613_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kníže Koré, kníže Gatam, kníže Amalech. Ta jsou knížata pošlá z Elifaza v zemi Idumejské; ti jsou synové Ady. ");
INSERT INTO ces1613_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Tito pak jsou synové Rahuele, syna Ezau: Kníže Nahat, kníže Zára, kníže Samma, kníže Méza. Ta knížata pošla z Rahuele, v zemi Idumejské; to jsou synové Bazematy, ženy Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","A synové Olibamy, ženy Ezau, tito jsou: Kníže Jehus, kníže Jhelom, kníže Koré. To jsou knížata z Olibamy, dcery Anovy, ženy Ezau. ");
INSERT INTO ces1613_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Tiť jsou synové Ezau, a ta knížata jejich; onť jest Edom. ");
INSERT INTO ces1613_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Tito pak jsou synové Seir, totiž Horejští, obyvatelé země té: Lotan, Sobal, Sebeon a Ana, ");
INSERT INTO ces1613_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","A Dison, Eser a Dízan. Ta jsou knížata Horejská, synové Seir, v zemi Idumejské. ");
INSERT INTO ces1613_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Synové Lotanovi byli: Hori a Hemam; a sestra Lotanova Tamna. ");
INSERT INTO ces1613_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Synové pak Sobalovi tito: Alvan, Manáhat, Ebal, Sefo a Onam. ");
INSERT INTO ces1613_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","A tito synové Sebeonovi: Aia a Ana. To jest ten Ana, kterýž nalezl mezky na poušti, když pásl osly Sebeona otce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Tito pak děti Anovi: Dison a Olibama, dcera Anova. ");
INSERT INTO ces1613_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","A synové Dízanovi tito: Hamdan, Eseban, Jetran a Charan. ");
INSERT INTO ces1613_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Synové Eser tito: Balaan, Závan a Achan. ");
INSERT INTO ces1613_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tito synové Dízanovi: Hus a Aran. ");
INSERT INTO ces1613_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Tato jsou knížata Horejská: Kníže Lotan, kníže Sobal, kníže Sebeon, kníže Ana, ");
INSERT INTO ces1613_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Kníže Dison, kníže Eser, kníže Dízan. To byla knížata Horejská, po knížetstvích svých v zemi Seir. ");
INSERT INTO ces1613_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Tito pak byli králové, kteříž kralovali v zemi Idumejské, prvé než kraloval král nad syny Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Kraloval tedy v Edom Béla, syn Beorův, a jméno města jeho Denaba. ");
INSERT INTO ces1613_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","I umřel Béla, a kraloval místo něho Jobab, syn Záre z Bozra. ");
INSERT INTO ces1613_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","I umřel Jobab, a kraloval na místě jeho Husam z země Temanské. ");
INSERT INTO ces1613_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Umřel i Husam, a kraloval místo něho Adad, syn Badadův, kterýž porazil Madianské v krajině Moábské; a jméno města jeho Avith. ");
INSERT INTO ces1613_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Když pak umřel Adad, kraloval místo něho Semla z Masreka. ");
INSERT INTO ces1613_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","A po smrti Semlově kraloval na místě jeho Saul z Rohobot od řeky. ");
INSERT INTO ces1613_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Umřel i Saul, a kraloval místo něho Bálanan, syn Achoborův. ");
INSERT INTO ces1613_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","A když i Bálanan umřel, syn Achoborův, kraloval na místě jeho Adar; a jméno města jeho Pahu; jméno pak ženy jeho Mehetabel, dcera Matredy, dcery Mezábovy. ");
INSERT INTO ces1613_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ta jsou jména knížat pošlých z Ezau, po čeledech jejich, po místech jejich, vedlé jmen jejich: Kníže Tamna, kníže Alva, kníže Jetet, ");
INSERT INTO ces1613_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Kníže Olibama, kníže Ela, kníže Finon. ");
INSERT INTO ces1613_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kníže Kenaz, kníže Teman, kníže Mabsar. ");
INSERT INTO ces1613_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Kníže Magdiel, kníže Híram. Tať jsou knížata Idumejská, tak jakž kteří bydlili v zemi dědictví svého. Toť jest ten Ezau, otec Idumejských. ");
INSERT INTO ces1613_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jákob pak bydlil v zemi putování otce svého, v zemi Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Tito jsou příběhové Jákobovi: Jozef, když byl v sedmnácti letech, pásl s bratřími svými dobytek, (a byl mládeneček), s syny Bály a Zelfy, žen otce svého. A oznamoval Jozef zlou pověst o nich otci svému. ");
INSERT INTO ces1613_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Izrael pak miloval Jozefa nad všecky syny své; nebo v starosti své zplodil jej. A udělal mu sukni proměnných barev. ");
INSERT INTO ces1613_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","A když spatřili bratří jeho, že ho miluje otec jejich nad všecky bratří jeho, nenáviděli ho, aniž mohli pokojně k němu promluviti. ");
INSERT INTO ces1613_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Měl pak Jozef sen, a vypravoval jej bratřím svým; pročež v větší nenávisti ho měli. ");
INSERT INTO ces1613_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nebo pravil jim: Slyšte, prosím, sen, kterýž jsem měl. ");
INSERT INTO ces1613_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Hle, vázali jsme snopy na poli, a aj, povstal snop můj, a stál. Vůkol také stáli snopové vaši, a klaněli se snopu mému. ");
INSERT INTO ces1613_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Jemužto odpověděli bratří jeho: Zdaliž kralovati budeš nad námi, aneb pánem naším budeš? Z té příčiny ještě více nenáviděli ho pro sny jeho, a pro slova jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Potom ještě měl jiný sen, a vypravoval jej bratřím svým, řka: Hle, opět jsem měl sen, a aj, slunce a měsíc, a jedenácte hvězd klanělo mi se. ");
INSERT INTO ces1613_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","I vypravoval otci svému a bratřím svým. A domlouval mu otec jeho, a řekl jemu: Jakýž jest to sen, kterýž jsi měl? Zdaliž přijdeme, já a matka tvá i bratří tvoji, abychom se klaněli před tebou až k zemi? ");
INSERT INTO ces1613_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tedy záviděli mu bratří jeho; ale otec jeho měl pozor na tu věc. ");
INSERT INTO ces1613_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Odešli pak bratří jeho, aby pásli dobytek otce svého v Sichem. ");
INSERT INTO ces1613_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","A řekl Izrael Jozefovi: Zdaliž nepasou bratří tvoji v Sichem: Poď, a pošli tě k nim. Kterýžto odpověděl: Aj, teď jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","I řekl jemu: Jdi nyní, zvěz, jak se mají bratří tvoji, a co se děje s dobytkem; a zase mi povíš o tom. A tak poslal ho z údolí Hebron, a on přišel do Sichem. ");
INSERT INTO ces1613_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Našel ho pak muž nějaký, an bloudí po poli. I zeptal se ho muž ten, řka: Èeho hledáš? ");
INSERT INTO ces1613_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Odpověděl: Bratří svých hledám; pověz mi, prosím, kde oni pasou? ");
INSERT INTO ces1613_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","I řekl muž ten: Odešli odsud; nebo slyšel jsem je, ani praví: Poďme do Dothain. Tedy šel Jozef za bratřími svými, a našel je v Dothain. ");
INSERT INTO ces1613_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kteřížto, jakž ho uzřeli zdaleka, prvé než k nim došel, ukládali o něm, aby jej zahubili. ");
INSERT INTO ces1613_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nebo řekli jeden druhému: Ej, mistr snů teď jde. ");
INSERT INTO ces1613_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nyní tedy poďte, a zabíme jej, a uvržeme ho do některé čisterny, a díme: Zvěř lítá sežrala jej. I uzříme, nač jemu vyjdou snové jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","A uslyšev to Ruben, aby ho vytrhl z ruky jejich, (nebo řekl: Neodjímejme mu hrdla,) ");
INSERT INTO ces1613_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Řekl jim Ruben: Nevylévejte krve. Vrzte jej do této čisterny, kteráž jest na poušti, a nevztahujte ruky na něj. Ale on chtěl vysvoboditi ho z ruky jejich, a pomoci mu, aby se navrátil k otci svému. ");
INSERT INTO ces1613_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","A když přišel Jozef k bratřím svým, strhli s něho sukni jeho, sukni proměnných barev, kterouž měl na sobě. ");
INSERT INTO ces1613_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","A pochopivše, uvrhli jej do čisterny. Èisterna pak ta byla prázdná, v níž nebylo vody. ");
INSERT INTO ces1613_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","I usadili se, aby jedli chléb. A pozdvihše očí svých, uzřeli, a aj, množství Izmaelitských přicházejících z Galád, kteřížto na velbloudích svých nesli vonné věci a kadidlo a mirru do Egypta. ");
INSERT INTO ces1613_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","I řekl Juda bratřím svým: Jaký zisk míti budeme, zabijeme-li bratra svého, a zatajíme-li krve jeho? ");
INSERT INTO ces1613_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Poďte, prodejme ho Izmaelitským, a nevztahujme na něj rukou svých, nebo bratr náš, tělo naše jest. I uposlechli ho bratří jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Když pak mimo ně jeli muži ti, kupci Madianští, vytáhli a vyvedli Jozefa z té čisterny, a prodali jej Izmaelitským za dvadceti stříbrných. Ti zavedli Jozefa do Egypta. ");
INSERT INTO ces1613_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","A navrátil se Ruben k čisterně, a aj, již nebylo Jozefa v ní. I roztrhl roucha svá. ");
INSERT INTO ces1613_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A navrátiv se k bratřím svým, řekl: Pacholete není, a já kam se mám podíti? ");
INSERT INTO ces1613_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tedy vzali sukni Jozefovu, a zabivše kozla, smočili sukni tu ve krvi. ");
INSERT INTO ces1613_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","A poslali sukni tu proměnných barev, a dali ji donésti k otci svému, aby řekli: Tuto jsme nalezli; pohleď nyní, jest-li sukně syna tvého, či není? ");
INSERT INTO ces1613_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","A on poznav ji, řekl: Sukně syna mého jest; zvěř lítá sežrala jej, konečně roztrhán jest Jozef. ");
INSERT INTO ces1613_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","I roztrhl Jákob roucha svá, a vloživ žíni na bedra svá, zámutek nesl po synu svém za mnoho dní. ");
INSERT INTO ces1613_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Sešli se pak všickni synové jeho, a všecky dcery jeho, aby ho těšili. Ale on nedal se potěšiti, a řekl: Nýbrž já tak v zámutku sstoupím za synem svým do hrobu. A plakal ho otec jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mezi tím Madianští prodali Jozefa do Egypta Putifarovi, dvořeninu Faraonovu, hejtmanu žoldnéřů. ");
INSERT INTO ces1613_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Stalo se pak v ten čas, že sstupuje Juda od bratří svých, uchýlil se k muži Odolamitskému, jehož jméno bylo Híra. ");
INSERT INTO ces1613_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","I uzřel tam Juda dceru muže Kananejského, kterýž sloul Sua; a pojav ji, všel k ní. ");
INSERT INTO ces1613_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kterážto počala a porodila syna; i nazval jméno jeho Her. ");
INSERT INTO ces1613_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A počavši opět, porodila syna; a nazvala jméno jeho Onan. ");
INSERT INTO ces1613_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Porodila pak ještě syna, jehož jméno nazvala Séla. A byl Juda v Chezib, když ona jej porodila. ");
INSERT INTO ces1613_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","I dal Juda Herovi prvorozenému svému manželku, jménem Támar. ");
INSERT INTO ces1613_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","A byl Her, prvorozený Judův, zlý před očima Hospodina; i zabil jej Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tedy řekl Juda Onanovi: Vejdi k ženě bratra svého, a podlé příbuznosti pojmi ji, abys vzbudil símě bratru svému. ");
INSERT INTO ces1613_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Věděl pak Onan, že to símě nebude jeho. Protož kdykoli vcházel k ženě bratra svého, vypouštěl símě na zem, aby nezplodil synů bratru svému. ");
INSERT INTO ces1613_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","I nelíbilo se Hospodinu to, co dělal Onan; protož ho také zabil. ");
INSERT INTO ces1613_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tedy řekl Juda k Támar nevěstě své: Pobuď v domě otce svého vdovou, dokudž nedoroste Séla, syn můj. (Nebo řekl: Aby on také neumřel, jako i bratří jeho.) I odešla Támar, a bydlila v domě otce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A po mnohých dnech umřela dcera Suova, manželka Judova. Kterýžto potěšiv se zas, šel do Tamnas k těm, kteříž střihli ovce jeho, a s ním Híra Odolamitský, přítel jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","I oznámeno jest Támar těmito slovy: Aj, tchán tvůj vstupuje do Tamnas, aby střihl ovce své. ");
INSERT INTO ces1613_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tedy ona složivši s sebe šaty své vdovské, zavila se v rouchu, a oděla se a seděla na rozcestí, kudy se jde do Tamnas. Nebo viděla, že Séla dorostl, a že není dána jemu za manželku. ");
INSERT INTO ces1613_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kteroužto uzřev Juda, za to měl, že jest nevěstka; nebo zakryla tvář svou. ");
INSERT INTO ces1613_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Protož uchýliv se k ní s cesty, řekl: Dopusť medle, ať vejdu k tobě. (Nebo nevěděl, aby nevěsta jeho byla.) I řekla: Co mi dáš, jestliže vejdeš ke mně? ");
INSERT INTO ces1613_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Odpověděl: Pošliť kozelce z stáda. Dí ona: Kdybys něco zastavil, dokavadž nepošleš. ");
INSERT INTO ces1613_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","I řekl: Cožť mám dáti v zástavě? Odpověděla ona: Pečetní prsten svůj, a halži svou, a hůl svou, kterouž máš v ruce své. I dal jí, a všel k ní; a počala z něho. ");
INSERT INTO ces1613_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tedy vstavši, odešla, a sňavši rouchu svou s sebe, oblékla se v šaty své vdovské. ");
INSERT INTO ces1613_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","I poslal Juda kozelce po příteli svém Odolamitském, aby vzal zase základ od ženy. A nenalezl jí. ");
INSERT INTO ces1613_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","I ptal se mužů toho místa, řka: Kde jest ta nevěstka, kteráž seděla na rozcestí této cesty? Řekli oni: Nebylotě zde nevěstky. ");
INSERT INTO ces1613_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tedy navrátiv se k Judovi, řekl: Nenašel jsem jí; a také muži místa toho pravili: Nebylo zde nevěstky. ");
INSERT INTO ces1613_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","I řekl Juda: Nechť sobě to má, abychom neuvedli se v lehkost. Jáť jsem poslal toho kozelce, ale tys jí nenalezl. ");
INSERT INTO ces1613_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","I stalo se okolo tří měsíců, že oznámili Judovi, řkouce: Dopustila se smilství Támar nevěsta tvá, a jest již i těhotná z smilství. I řekl Juda: Vyveďte ji, aby byla upálena. ");
INSERT INTO ces1613_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Když pak vedena byla, poslala k tchánu svému, řkuci: Z muže, jehož tyto věci jsou, těhotná jsem. A při tom řekla: Pohleď, prosím, čí jsou tyto věci, pečetní prsten, halže a hůl tato? ");
INSERT INTO ces1613_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tedy pohleděv na to Juda, řekl: Spravedlivějšíť jest než já, poněvadž jsem nedal jí Sélovi synu svému. A více jí nepoznával. ");
INSERT INTO ces1613_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Stalo se pak, že když přišel čas porodu jejího, aj, bliženci v životě jejím. ");
INSERT INTO ces1613_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A když rodila, jeden z nich vyskytl ruku, kteroužto chytivši baba, uvázala na ni červenou nitku, řkuci: Ten vyjde prvé. ");
INSERT INTO ces1613_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Když pak vtáhl ruku svou zase, hle, vyšel bratr jeho. I řekla: Jak jsi protrhl? Tvéť jest protržení. I nazváno jest jméno jeho Fáres. ");
INSERT INTO ces1613_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","A potom vyšel bratr jeho, kterýž měl na ruce nitku červenou. I nazváno jest jméno jeho Zára. ");
INSERT INTO ces1613_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Jozef pak doveden byl do Egypta; a koupil ho Putifar, dvořenin Faraonův, nejvyšší nad drabanty, muž Egyptský, od Izmaelitských, kteříž ho tam dovedli. ");
INSERT INTO ces1613_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Byl pak Hospodin s Jozefem, a všecko se mu šťastně vedlo, a bydlil v domě pána svého toho Egyptského. ");
INSERT INTO ces1613_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A viděl pán jeho, že Hospodin byl s ním, a že všecko, což činil, Hospodin k prospěchu přivedl v rukou jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tedy nalezl Jozef milost před očima jeho, a sloužil mu. I představil ho domu svému, a všecko, což měl, dal v ruku jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","A hned, jakž ustanovil ho nad domem svým, a nade vším, což měl, požehnal Hospodin domu Egyptského toho pro Jozefa. A bylo požehnání Hospodinovo na všech věcech, kteréž měl doma i na poli. ");
INSERT INTO ces1613_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Všech tedy věcí, kteréž měl, zanechal v rukou Jozefových; aniž o čem, tak jako on, věděl, jediné o chlebě, kterýž jedl. Byl pak Jozef ušlechtilé postavy a krásného vzezření. ");
INSERT INTO ces1613_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","I stalo se potom, že vzhlédala žena pána jeho očima svýma na Jozefa, a řekla: Spi se mnou. ");
INSERT INTO ces1613_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kterýžto odpíraje, řekl ženě pána svého: Aj, pán můj neví tak jako já, co jest v domě, a všecko, což má, dal v ruce mé. ");
INSERT INTO ces1613_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Není žádného přednějšího nade mne v domě tomto, aniž co vyňal z správy mé, kromě tebe, jelikož jsi ty manželka jeho. Jak bych tedy učinil takovou nešlechetnost, a hřešil i proti Bohu? ");
INSERT INTO ces1613_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","A když mluvila ona Jozefovi den po dni, nepovolil jí, aby spal s ní, ani aby býval s ní. ");
INSERT INTO ces1613_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tedy dne jednoho, když přišel do domu k práci své, a nebylo tu žádného z domácích v domě, ");
INSERT INTO ces1613_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Chytila jej ona za roucho jeho, řkuci: Lež se mnou. On pak nechav roucha svého v rukou jejích, utekl, a vyšel ven. ");
INSERT INTO ces1613_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","A ona viduci, že nechal roucha svého v rukou jejích a vyběhl ven, ");
INSERT INTO ces1613_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Svolala domácí své, a řekla k nim takto: Pohleďte, přivedl nám muže Hebrejského, kterýž by měl posměch z nás; nebo přišel ke mně, aby ležel se mnou; i křičela jsem hlasem velikým. ");
INSERT INTO ces1613_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","A když uslyšel, že jsem hlasu svého pozdvihla a křičela, nechav roucha svého u mne, utekl a vyšel ven. ");
INSERT INTO ces1613_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tedy schovala roucho jeho u sebe, až přišel pán jeho do domu svého. ");
INSERT INTO ces1613_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","K němuž mluvila v tato slova, řkuci: Přišel ke mně služebník ten Hebrejský, kteréhožs přivedl nám, aby mi lehkost učinil. ");
INSERT INTO ces1613_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","A když jsem hlasu svého pozdvihla a křičela, tedy nechal roucha svého u mne, a utekl ven. ");
INSERT INTO ces1613_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","I stalo se, že, když uslyšel pán jeho slova ženy své, kteráž mluvila mu, pravěci: Tak mi učinil služebník tvůj, rozhněval se velmi. ");
INSERT INTO ces1613_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Protož vzal ho pán jeho, a dal jej do věže žalářné, v to místo, kdež vězňové královští seděli; i byl tam v žaláři. ");
INSERT INTO ces1613_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Byl pak Hospodin s Jozefem, a naklonil se k němu milosrdenstvím; a dal jemu milost u vládaře nad žalářem. ");
INSERT INTO ces1613_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","I dal vládař žaláře v moc Jozefovi všecky vězně, kteříž byli v věži žalářné; a cožkoli tam činiti měli, on to spravoval. ");
INSERT INTO ces1613_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Aniž vládař žaláře k čemu dohlídal, což jemu svěřil; proto že Hospodin byl s ním, a což on činil, Hospodin tomu prospěch dával. ");
INSERT INTO ces1613_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Stalo se potom, že šeňkýř krále Egyptského a pekař provinili proti pánu svému, králi Egyptskému. ");
INSERT INTO ces1613_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","I rozhněval se Farao na oba úředníky své, na vládaře nad šeňkýři, a na vládaře nad pekaři. ");
INSERT INTO ces1613_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A dal je do vězení v domě nejvyššího nad drabanty, do věže žalářné, v místo, v němž Jozef vězněm byl. ");
INSERT INTO ces1613_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","I postavil jim nejvyšší nad drabanty Jozefa k službě; a byli drahně dní u vězení. ");
INSERT INTO ces1613_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","I měli sen oba dva, každý z nich sen svůj noci jedné, každý podlé vyložení sna svého, šeňkýř i pekař krále Egyptského, kteříž seděli v věži. ");
INSERT INTO ces1613_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tedy přišel k nim Jozef ráno, a hleděl na ně; a aj, byli smutní. ");
INSERT INTO ces1613_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","I optal se těch úředníků Faraonových, kteříž s ním byli v vězení v domě pána jeho, řka: Proč jsou dnes tváři vaše smutnější? ");
INSERT INTO ces1613_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kteřížto odpověděli jemu: Měli jsme sen, a nemáme, kdo by jej vyložil. I řekl jim Jozef: Zdaliž Boží nejsou výkladové? Pravte mi medle. ");
INSERT INTO ces1613_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tedy správce nad šeňkýři vypravoval sen svůj Jozefovi, a řekl jemu: Zdálo se mi ve snách, že jsem viděl před sebou vinný kmen, ");
INSERT INTO ces1613_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","A na tom kmenu tři ratolesti; a ten kmen jako by pupence pouštěl, a vycházel květ jeho, až k sezrání přišli hroznové jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","A já maje koflík Faraonův v ruce své, bral jsem hrozny, a vytlačoval je do koflíka Faraonova, a podával jsem koflíka Faraonovi do rukou. ");
INSERT INTO ces1613_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","I řekl jemu Jozef: Toto jest vyložení jeho: Ti tři révové jsou tři dnové. ");
INSERT INTO ces1613_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Po třech dnech povýší Farao hlavy tvé, a k úřadu tvému tě navrátí; i budeš podávati koflíka Faraonova do ruky jeho podlé obyčeje prvního, když jsi byl šeňkýřem jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ale mějž mne v své paměti, kdyžť se dobře povede; a učiň, prosím, se mnou to milosrdenství, abys zmínku učinil o mně před Faraonem, a vysvobodil mne z domu tohoto. ");
INSERT INTO ces1613_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nebo kradmo jsem vzat z země Židovské; a zde jsem ničeho neučinil, pročež by mne do tohoto vězení dali. ");
INSERT INTO ces1613_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Vida pak správce nad pekaři, že dobře vyložil, řekl Jozefovi: Mně také zdálo se ve snách, ano tři košové pletení na hlavě mé. ");
INSERT INTO ces1613_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","A v koši vrchním byli všelijací pokrmové Faraonovi dílem pekařským strojení, a ptáci jedli je z koše nad hlavou mou. ");
INSERT INTO ces1613_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","I odpověděl Jozef a řekl: Toto jest vyložení jeho: Tři košové jsou tři dnové. ");
INSERT INTO ces1613_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Po třech dnech odejme tobě Farao hlavu tvou, a oběsí tě na dřevě; i budou jísti ptáci maso tvé s tebe. ");
INSERT INTO ces1613_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tedy stalo se v den třetí, v den pamatný narození Faraonova, že učinil hody všechněm služebníkům svým; i počítal hlavu vládaře nad šeňky, i hlavu vládaře nad pekaři, mezi služebníky svými. ");
INSERT INTO ces1613_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A navrátil nejvyššího nad šeňky k místu jeho, aby podával koflíku Faraonovi do ruky. ");
INSERT INTO ces1613_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Vládaře pak nad pekaři oběsil, tak jakž jim byl sen vyložil Jozef. ");
INSERT INTO ces1613_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","A nezpomenul správce nad šeňky na Jozefa, ale zapomenul na něj. ");
INSERT INTO ces1613_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Stalo se pak po dvou letech, měl Farao sen. Zdálo mu se, že stál nad potokem. ");
INSERT INTO ces1613_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A aj, z toho potoku vycházelo sedm krav, pěkných na pohledění a tlustých, kteréžto pásly se na mokřinách. ");
INSERT INTO ces1613_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A aj, sedm krav jiných vycházelo za nimi z potoku, šeredných na pohledění a hubených, kteréžto stály podlé oněch krav při břehu potoka. ");
INSERT INTO ces1613_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","A ty krávy na pohledění šeredné a hubené sežraly oněch sedm krav na pohledění pěkných a tlustých. I procítil Farao. ");
INSERT INTO ces1613_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A když usnul zase, zdálo se jemu podruhé. A aj, sedm klasů vyrostlo z stébla jednoho, plných a pěkných. ");
INSERT INTO ces1613_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","A aj, sedm klasů tenkých a východním větrem usvadlých vzcházelo za nimi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","A ti klasové tencí pohltili sedm oněch klasů zdařilých a plných. I procítiv Farao, a aj, byl sen. ");
INSERT INTO ces1613_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Když pak bylo ráno, zkormoucena byla mysl jeho; a poslav, svolal všecky hadače Egyptské, a všecky mudrce jejich. I vypravoval jim Farao sny své; a nebylo žádného, kdo by je vyložil Faraonovi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tedy mluvil nejvyšší šeňk Faraonovi takto: Na provinění své rozpomínám se dnes. ");
INSERT INTO ces1613_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farao rozhněvav se na služebníky své, dal mne byl do vězení v domě nejvyššího nad drabanty, mne a správce nad pekaři. ");
INSERT INTO ces1613_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Měli jsme pak sen jedné noci, on i já, jeden každý podlé vyložení snu svého. ");
INSERT INTO ces1613_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","A byl tam s námi mládenec Hebrejský, služebník nejvyššího nad drabanty, jemuž když jsme vypravovali, vykládal nám sny naše; jednomu každému podlé snu jeho vykládal. ");
INSERT INTO ces1613_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","A stalo se, že jakž vykládal nám, tak bylo: Já jsem navrácen k úřadu svému, a on oběšen. ");
INSERT INTO ces1613_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tedy poslav Farao, povolal Jozefa, a rychle vypustili ho z žaláře. Kterýžto oholiv se, a změniv roucho své, přišel k Faraonovi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","I řekl Farao Jozefovi: Měl jsem sen, a není, kdo by jej vyložil; o tobě pak slyšel jsem to, že když uslyšíš sen, umíš jej vyložiti. ");
INSERT INTO ces1613_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Odpověděl Jozef Faraonovi, řka: Není to má věc; Bůh oznámí šťastné věci Faraonovi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tedy řekl Farao Jozefovi: Zdálo mi se ve snách, že jsem stál na břehu potoka. ");
INSERT INTO ces1613_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","A aj, z potoka toho vystupovalo sedm krav tlustých a pěkných, kteréžto pásly se na mokřinách. ");
INSERT INTO ces1613_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","A aj, sedm jiných krav vystupovalo za nimi churavých a šeredných velmi a hubených; neviděl jsem tak šeredných ve vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","A sežraly krávy ty hubené a šeredné sedm krav prvnějších tlustých. ");
INSERT INTO ces1613_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","A ač dostaly se do břicha jejich, však nebylo znáti, by se dostaly v střeva jejich; nebo na pohledění byly mrzké, jako i před tím. I procítil jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Viděl jsem také ve snách, ano sedm klasů vyrostlo z stébla jednoho plných a pěkných. ");
INSERT INTO ces1613_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A aj, sedm klasů drobných, tenkých a východním větrem usvadlých vycházelo za nimi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","I pohltili klasové ti drobní sedm klasů pěkných. Což když jsem vypravoval hadačům, nebyl, kdo by mi vyložil. ");
INSERT INTO ces1613_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Odpověděl Jozef Faraonovi: Sen Faraonův jednostejný jest. Což Bůh činiti bude, to ukázal Faraonovi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sedm krav pěkných jest sedm let, a sedm klasů pěkných tolikéž jest sedm let; sen jest jednostejný. ");
INSERT INTO ces1613_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sedm pak hubených krav a šeredných, vystupujících za nimi, sedm let jest; a sedm klasů drobných a větrem východním usvadlých bude sedm let hladu. ");
INSERT INTO ces1613_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Toť jest, což jsem mluvil Faraonovi: Což Bůh činiti bude, ukazuje Faraonovi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Aj, sedm let nastane, v nichž hojnost veliká bude ve vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A po nich nastane sedm let hladu, v nichž v zapomenutí přijde všecka ta hojnost v zemi Egyptské; a zhubí hlad zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Aniž poznána bude hojnost ta v zemi, pro hlad, kterýž přijde potom; nebo velmi veliký bude. ");
INSERT INTO ces1613_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Že pak opětován jest sen Faraonovi podvakrát, znamená, že jistá věc jest od Boha, a že tím spíše Bůh vykoná to. ");
INSERT INTO ces1613_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Protož nyní ať vyhledá Farao muže opatrného a moudrého, kteréhož by ustanovil nad zemí Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","To ať učiní Farao, a postaví úředníky nad zemí, a béře pátý díl z úrod země Egyptské, po sedm let hojných. ");
INSERT INTO ces1613_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ať shromáždí všeliké potravy těch úrodných let nastávajících, a sklidí obilí k ruce Faraonovi; a potravy v městech ať se chovají pilně. ");
INSERT INTO ces1613_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","A budou pokrmové ti za poklad zemi této k sedmi letům hladu, kteráž budou v zemi Egyptské, aby nebyla zkažena země tato hladem. ");
INSERT INTO ces1613_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","I líbila se řeč ta Faraonovi i všechněm služebníkům jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tedy řekl Farao služebníkům svým: Najdeme-liž podobného tomuto muži, v němž by byl Duch Boží? ");
INSERT INTO ces1613_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Jozefovi pak řekl: Poněvadž Bůh dal znáti tobě všecko toto, neníť žádného tak rozumného a moudrého, jako ty jsi. ");
INSERT INTO ces1613_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ty budeš nad domem mým, a líbati bude tvář tvou všecken lid můj; stolicí toliko královskou vyšší nad tebe budu. ");
INSERT INTO ces1613_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Řekl také Farao Jozefovi: Aj, ustanovil jsem tě nade vší zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","A sňav Farao prsten svůj s ruky své, dal jej na ruku Jozefovu, a oblékl ho v roucho kmentové, a vložil zlatý řetěz na hrdlo jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A dal ho voziti na svém druhém voze, a volali před ním: Klanějte se! I ustanovil ho nade vší zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","A řekl Farao Jozefovi: Já jsem Farao, a bez dopuštění tvého nepozdvihne žádný ruky své ani nohy své ve vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","A dal Farao jméno Jozefovi Safenat Paneach, a dal mu Asenat dceru Putifera, knížete On, za manželku. I vyšel Jozef na zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","(Jozef pak byl ve třidcíti letech, když stál před Faraonem králem Egyptským.) A vyšed od tváři Faraonovy, projel všecku zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","A vydala země po sedm let úrodných obilí hojnost. ");
INSERT INTO ces1613_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","I nahromáždil všelijakých potrav v těch sedmi letech hojných v zemi Egyptské, a složil potravu tu v městech; úrody polní jednoho každého města, kteréž byly okolo něho, složil v něm. ");
INSERT INTO ces1613_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","A tak nahromáždil Jozef obilí velmi mnoho, jako jest písku mořského, tak že přestali počítati; nebo mu nebylo počtu. ");
INSERT INTO ces1613_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Jozefovi pak narodili se dva synové, prvé než přišel rok hladu, kteréž mu porodila Asenat, dcera Putifera, knížete On. ");
INSERT INTO ces1613_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","A nazval Jozef jméno prvorozeného Manasses, řka: Nebo způsobil to Bůh, abych zapomenul na všecky práce své, a na všecken dům otce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Jméno pak druhého nazval Efraim, řka: Nebo dal mi Bůh zrůst v zemi trápení mého. ");
INSERT INTO ces1613_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tedy pominulo sedm let hojných v zemi Egyptské; ");
INSERT INTO ces1613_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","A počalo sedm let hladu přicházeti, jakž byl předpověděl Jozef. I byl hlad po všech krajinách, ale po vší zemi Egyptské byl chléb. ");
INSERT INTO ces1613_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Potom také nedostatek trpěla všecka země Egyptská, a volal lid k Faraonovi o chléb. I řekl Farao všechněm Egyptským: Jděte k Jozefovi, což vám rozkáže, učiníte. ");
INSERT INTO ces1613_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","A byl hlad na tváři vší země. Tedy otevřel Jozef všecky obilnice, v nichž obilí bylo, a prodával Egyptským; nebo rozmohl se hlad v zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","A všickni obyvatelé země přicházeli do Egypta k Jozefovi, aby kupovali; nebo rozmohl se byl hlad po vší zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Vida pak Jákob, že by potrava byla v Egyptě, řekl synům svým: Co hledíte jeden na druhého? ");
INSERT INTO ces1613_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I mluvil jim: Aj, slyšel jsem, že mají potravu v Egyptě; jděte tam, a kupte nám odtud, abychom živi byli a nezemřeli. ");
INSERT INTO ces1613_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tedy šlo deset bratrů Jozefových, aby nakoupili obilí v Egyptě. ");
INSERT INTO ces1613_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ale Beniamina, bratra Jozefova, neposlal Jákob s bratřími jeho, nebo řekl: Aby se mu tam něco zlého nepřihodilo. ");
INSERT INTO ces1613_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","I šli synové Izraelovi spolu s jinými, aby kupovali; nebo byl hlad v zemi Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Jozef pak byl nejvyšší správce v zemi té; on prodával obilí všemu lidu země. Tedy přišli bratří Jozefovi, a skláněli se před ním tváří až k zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","A uzřev Jozef bratří své, poznal je; a ukázal se k nim jako cizí, a tvrdě mluvil k nim, řka jim: Odkud jste přišli? I odpověděli: Z země Kananejské, abychom nakoupili potrav. ");
INSERT INTO ces1613_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Poznal, pravím, Jozef bratří své, ale oni nepoznali ho. ");
INSERT INTO ces1613_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tedy zpomenul Jozef na sny, kteréž měl o nich, a řekl jim: Špehéři jste, a přišli jste, abyste shlédli nepevná místa země. ");
INSERT INTO ces1613_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kteřížto odpověděli jemu: Nikoli, pane můj, ale služebníci tvoji přišli, aby nakoupili pokrmů. ");
INSERT INTO ces1613_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Všickni my synové jednoho muže jsme, upřímí jsme; nikdyť jsou nebyli služebníci tvoji špehéři. ");
INSERT INTO ces1613_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Jimž zase řekl: Není tak, ale přišli jste, abyste shlédli nepevná místa země. ");
INSERT INTO ces1613_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Odpověděli oni: Dvanácte nás bratří služebníků tvých bylo, synů muže jednoho v zemi Kananejské; a aj, nejmladší s otcem naším nyní jest doma, a jednoho není. ");
INSERT INTO ces1613_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","I řekl jim Jozef: Toť jest, což jsem mluvil vám, když jsem řekl: Špehéři jste. ");
INSERT INTO ces1613_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Touto věcí zkušeni budete: Živť jest Farao, že nevyjdete odsud, až přijde sem bratr váš mladší. ");
INSERT INTO ces1613_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Vyšlete z sebe jednoho, ať vezma, přivede bratra vašeho; vy pak u vězení zůstaňte, a zkušena budou vaše slova, pravdu-li jste mluvili. Pakli nic, živť jest Farao, že jste špehéři. ");
INSERT INTO ces1613_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Tedy dal je všecky spolu do vězení za tři dni. ");
INSERT INTO ces1613_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Třetího pak dne řekl jim Jozef: Toto učiňte, abyste živi byli; neboť já se bojím Boha. ");
INSERT INTO ces1613_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Jste-li šlechetní muži, jeden bratr váš ať jest ukován v žaláři, v němž jste byli; vy pak jděte, a odneste obilí k zapuzení hladu domů vašich. ");
INSERT INTO ces1613_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bratra pak svého mladšího přivedete ke mně; a pravdomluvná prokázána budou vaše slova, a nezemřete. Tedy učinili tak. ");
INSERT INTO ces1613_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","I mluvil jeden k druhému: Jistě provinili jsme proti bratru svému. Nebo viděli jsme ssoužení duše jeho, když nás pokorně prosil, a nevyslyšeli jsme ho; protož přišlo na nás ssoužení toto. ");
INSERT INTO ces1613_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Odpověděl pak jim Ruben, řka: Zdaliž jsem tehdy vám nepravil těmito slovy: Nehřešte proti pacholeti. Ale neposlechli jste; pročež také krve jeho, hle, vyhledává se. ");
INSERT INTO ces1613_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","A nevěděli oni, že by rozuměl Jozef; nebo skrze tlumače mluvil jim. ");
INSERT INTO ces1613_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","A odvrátiv se od nich, plakal. Potom navrátiv se k nim, mluvil s nimi, a vzav Simeona z nich, svázal ho před očima jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Přikázal pak Jozef, aby naplněni byli pytlové jejich obilím, a navráceny peníze jejich jednomu každému do pytle jeho, a aby dána jim byla potrava na cestu. I stalo se tak. ");
INSERT INTO ces1613_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","A vloživše obilí svá na osly své, odešli odtud. ");
INSERT INTO ces1613_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","A rozvázav jeden z nich pytel svůj, aby dal obrok oslu svému v hospodě, uzřel peníze své, kteréž byly na vrchu v pytli jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I řekl bratřím svým: Navráceny jsou mi peníze mé, a aj, jsou v pytli mém. Tedy užasli se, a předěšeni jsouce, mluvili jeden k druhému: Což nám to učinil Bůh? ");
INSERT INTO ces1613_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Navrátivše se pak k Jákobovi otci svému do země Kananejské, vypravovali jemu všecko, co se jim přihodilo, pravíce: ");
INSERT INTO ces1613_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Muž ten, pán země, mluvil k nám tvrdě, a dal nás do vězení, jako špehéře země. ");
INSERT INTO ces1613_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","A řekli jsme jemu: Upřímí jsme, nikdy jsme nebyli špehéři. ");
INSERT INTO ces1613_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Dvanácte bylo nás bratří, synů otce našeho, z nichž jednoho není, a mladší nyní jest s otcem naším v zemi Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","I řekl nám muž ten, pán země té: Po tomto poznám, že upřímí jste: Bratra vašeho jednoho zanechte u mne, a obilí k zapuzení hladu od domů vašich vezmouce, odejděte. ");
INSERT INTO ces1613_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","A přiveďte bratra svého mladšího ke mně, abych poznal, že nejste špehéři, ale upřímí; tehdy bratra vašeho vrátím vám, a budete moci v zemi této obchod vésti. ");
INSERT INTO ces1613_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","I stalo se, že, když vyprazdňovali pytle své, a aj, jeden každý měl uzlík peněz svých v pytli svém. Vidouce pak oni i otec jejich uzlíky peněz svých, báli se. ");
INSERT INTO ces1613_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","I řekl jim Jákob otec jejich: Mne jste zbavili synů: Jozefa není, Simeona nemám, a Beniamina vezmete. Na mneť jsou se tyto všecky věci svalily. ");
INSERT INTO ces1613_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tedy řekl Ruben otci svému těmito slovy: Dva syny mé zabí, jestliže ho nepřivedu zase k tobě; poruč ho v ruce mé, a já zase přivedu ho k tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","I řekl: Nesstoupíť syn můj s vámi. Nebo bratr jeho umřel, a on sám pozůstal; a přihodilo-li by se mu co zlého na té cestě, kterouž půjdete, uvedli byste šediny mé s bolestí do hrobu. ");
INSERT INTO ces1613_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Byl pak hlad veliký v krajině té. ");
INSERT INTO ces1613_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","I stalo se, když vytrávili obilí, kteréž přinesli z Egypta, že řekl k nim otec jejich: Jděte zase, a nakupte nám něco potravy. ");
INSERT INTO ces1613_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","I mluvil k němu Juda těmito slovy: Velice se zařekl muž ten, řka: Neuzříte tváři mé, nebude-li bratr váš s vámi. ");
INSERT INTO ces1613_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Jestliže pošleš bratra našeho s námi, půjdeme a nakoupíme tobě potravy; ");
INSERT INTO ces1613_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pakli nepošleš, nepůjdeme. Nebo pověděl nám muž ten: Neuzříte tváři mé, nebude-li bratr váš s vámi. ");
INSERT INTO ces1613_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","I řekl Izrael: Proč jste mi tak zle učinili, oznámivše muži tomu, že máte ještě bratra? ");
INSERT INTO ces1613_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Odpověděli: Pilně vyptával se muž ten na nás, i na rod náš, mluvě: Jest-li živ ještě otec váš? Máte-li bratra? A dali jsme mu zprávu na ta slova. Zdaž jsme to jak věděti mohli, že dí: Přiveďte bratra svého? ");
INSERT INTO ces1613_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","I řekl Juda Izraelovi, otci svému: Pošli to pachole se mnou, a vstanouce, půjdeme, abychom živi byli, a nezemřeli, i my, i ty, i maličcí naši. ");
INSERT INTO ces1613_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Já slibuji za něj; z ruky mé vyhledávej ho. Jestliže nepřivedu ho k tobě, a nepostavím ho před tebou, vinen budu hříchem tobě po všecky dny. ");
INSERT INTO ces1613_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","A kdybychom byli neprodlévali, jistě již bychom se byli dvakrát vrátili. ");
INSERT INTO ces1613_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","I řekl jim Izrael otec jejich: Jestližeť tak býti musí, učiňtež toto: Nabeřte nejvzácnějších užitků země do nádob svých, a doneste muži tomu dar, něco kadidla, a trochu strdi, a vonných věcí a mirry, daktylů a mandlů. ");
INSERT INTO ces1613_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Peníze také dvoje vezměte v ruce své, a peníze vložené na vrch do pytlů vašich zase doneste v rukou svých; snad z omýlení to přišlo. ");
INSERT INTO ces1613_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bratra svého také vezměte, a vstanouce, jděte zase k muži tomu. ");
INSERT INTO ces1613_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","A Bůh silný všemohoucí dejž vám najíti milost před mužem tím, ať propustí vám onoho bratra vašeho i tohoto Beniamina. Jáť pak zbaven jsa synů, jako osiřelý budu. ");
INSERT INTO ces1613_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tedy vzali muži ti dar ten, a dvoje peníze vzali v ruce své, a Beniamina; a vstavše, sstoupili do Egypta, a postavili se před Jozefem. ");
INSERT INTO ces1613_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Vida pak Jozef Beniamina s nimi, řekl tomu, kterýž spravoval dům jeho: Uveď tyto muže do domu, a zabí hovado a připrav; nebo se mnou jísti budou muži ti o poledni. ");
INSERT INTO ces1613_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","I učinil muž ten, jakž rozkázal Jozef, a uvedl ty lidi do domu Jozefova. ");
INSERT INTO ces1613_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Báli se pak muži ti, když uvedeni byli do domu Jozefova, a řekli: Pro ty peníze, kteréž prvé vloženy byly do pytlů našich, sem uvedeni jsme, aby obvině, obořil se na nás, a vzal nás za služebníky i osly naše. ");
INSERT INTO ces1613_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","A přistoupivše k muži tomu, kterýž spravoval v domě Jozefově, mluvili k němu ve dveřích domu, ");
INSERT INTO ces1613_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","A řekli: Slyš mne, pane můj. Přišli jsme byli ponejprvé kupovati potrav. ");
INSERT INTO ces1613_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","I přihodilo se, když jsme do hospody přišli, a rozvazovali pytle své, a aj, peníze jednoho každého byly svrchu v pytli jeho, peníze naše podlé váhy své; a přinesli jsme je zase v rukou svých. ");
INSERT INTO ces1613_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Jiné také peníze přinesli jsme v rukou svých, abychom nakoupili potravy; nevíme, kdo jest zase vložil peníze naše do pytlů našich. ");
INSERT INTO ces1613_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A on odpověděl: Mějte o to pokoj, nebojte se. Bůh váš, a Bůh otce vašeho dal vám poklad do pytlů vašich; penízeť jsem vaše já přijal. I vyvedl k nim Simeona. ");
INSERT INTO ces1613_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Uved tedy muž ten lidi ty do domu Jozefova, dal jim vody, aby umyli nohy své, dal také obrok oslům jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mezi tím připravili dar ten, dokudž nepřišel Jozef v poledne; nebo slyšeli, že by tu měli jísti chléb. ");
INSERT INTO ces1613_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tedy přišel Jozef domů. I přinesli mu dar, kterýž měli v rukou svých, a klaněli se jemu až k zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I ptal se jich, jak se mají, a řekl: Zdráv-liž jest otec váš starý, o němž jste pravili? Živ-li jest ještě? ");
INSERT INTO ces1613_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kteřížto odpověděli: Zdráv jest služebník tvůj otec náš, a ještě živ jest. A sklánějíce hlavy, poklonu mu činili. ");
INSERT INTO ces1613_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Pozdvih pak očí svých, viděl Beniamina bratra svého, syna matky své, a řekl: Tento-li jest bratr váš mladší, o němž jste mi pravili? I řekl: Učiniž Bůh milost s tebou, synu můj! ");
INSERT INTO ces1613_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Tedy pospíšil Jozef, (nebo pohnula se střeva jeho nad bratrem jeho,) a hledal, kde by mohl plakati; a všed do pokoje, plakal tam. ");
INSERT INTO ces1613_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Potom umyv tvář svou, vyšel zase, a zdržoval se, a řekl: Klaďte chléb. ");
INSERT INTO ces1613_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","I kladli jemu zvláště, a jim obzvláště, Egyptským také, kteříž s ním jídali, obzvláštně; nebo nemohou Egyptští jísti s Židy chleba, proto že to ohavnost jest Egyptským. ");
INSERT INTO ces1613_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tedy seděli proti němu, prvorozený podlé prvorozenství svého, a mladší podlé mladšího věku svého. I divili se muži ti vespolek. ");
INSERT INTO ces1613_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","A bera jídlo před sebou, podával jim; Beniaminovi pak dostalo se pětkrát více než jiným. I hodovali a hojně se s ním napili. ");
INSERT INTO ces1613_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Rozkázal pak tomu, kterýž spravoval dům jeho, řka: Naplň pytle mužů těch potravou, co by jen unésti mohli; a peníze každého polož zas do pytle jeho na vrch. ");
INSERT INTO ces1613_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","A koflík můj, koflík stříbrný, vlož na vrch do pytle mladšího s penězi jeho za obilí. I učinil podlé řeči Jozefovy, kterouž mluvil. ");
INSERT INTO ces1613_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ráno pak propuštěni jsou ti muži, oni i oslové jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","A když vyšli z města, a nedaleko ještě byli, řekl Jozef správci domu svého: Vstaň, hoň muže ty, a dohoně se jich, mluv k nim: Pročež jste se odplatili zlým za dobré? ");
INSERT INTO ces1613_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Zdaliž to není ten koflík, z kteréhož píjí pán můj? A z tohoť on jistým zkušením pozná, jací jste vy. Zle jste učinili, co jste učinili. ");
INSERT INTO ces1613_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tedy dohoniv se jich, mluvil jim slova ta. ");
INSERT INTO ces1613_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kteřížto odpověděli jemu: Proč mluví pán můj taková slova? Odstup od služebníků tvých, aby co takového učinili. ");
INSERT INTO ces1613_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","A my ty peníze, kteréž jsme našli na vrchu v pytlích svých, přinesli jsme tobě zase z země Kananejské; jakž bychom tedy krásti měli z domu pána tvého stříbro neb zlato? ");
INSERT INTO ces1613_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","U koho z služebníků tvých nalezeno bude, nechžť umře ten; a my také budeme pána tvého služebníci. ");
INSERT INTO ces1613_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","I řekl: Nu dobře, nechť jest podlé řeči vaší. U koho se nalezne, ten bude mým služebníkem, a vy budete bez viny. ");
INSERT INTO ces1613_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Protož rychle každý složil pytel svůj na zem, a rozvázal každý pytel svůj. ");
INSERT INTO ces1613_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","I přehledával, od staršího počal, a na mladším přestal; i nalezen jest koflík v pytli Beniaminovu. ");
INSERT INTO ces1613_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tedy oni roztrhše roucha svá, vložil každý břímě na osla svého, a vrátili se do města. ");
INSERT INTO ces1613_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","I přišel Juda s bratřími svými do domu Jozefova, (on pak ještě tam byl,) a padli před ním na zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","I dí jim Jozef: Jakýž jest to skutek, který jste učinili? Zdaž nevíte, že takový muž, jako jsem já, umí poznati? ");
INSERT INTO ces1613_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tedy řekl Juda: Což díme pánu svému? co mluviti budeme? a čím se ospravedlníme? Bůhť jest našel nepravost služebníků tvých. Aj, služebníci jsme pána svého, i my i ten, u něhož nalezen jest koflík. ");
INSERT INTO ces1613_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Odpověděl Jozef: Odstup ode mne, abych to učinil. Muž, u něhož nalezen jest koflík, ten bude mým služebníkem; vy pak jděte u pokoji k otci svému. ");
INSERT INTO ces1613_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","I přistoupil k němu Juda a řekl: Slyš mne, pane můj. Prosím, nechažť promluví služebník tvůj slovo v uši pána svého, a nehněvej se na služebníka svého; nebo jsi ty jako sám Farao. ");
INSERT INTO ces1613_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Pán můj ptal se služebníků svých, řka: Máte-li otce, neb bratra? ");
INSERT INTO ces1613_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","A odpověděli jsme pánu mému: Máme otce starého, a pachole v starosti jeho zplozené malé, jehož bratr umřel, a on sám pozůstal po mateři své, a otec jeho miluje jej. ");
INSERT INTO ces1613_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","I řekl jsi služebníkům svým: Přiveďte ho ke mně, a pohledím na něj. ");
INSERT INTO ces1613_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","A řekli jsme pánu mému: Nemůžeť pachole opustiti otce svého; nebo opustí-li otce svého, on umře. ");
INSERT INTO ces1613_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ty pak řekl jsi služebníkům svým: Nepřijde-li bratr váš mladší s vámi, nepokoušejte se více viděti tváři mé. ");
INSERT INTO ces1613_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","I stalo se, když jsme se vrátili k služebníku tvému, otci mému, a jemu vypravovali slova pána svého, ");
INSERT INTO ces1613_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Že řekl otec náš: Jděte zase, nakupte nám něco potravy. ");
INSERT INTO ces1613_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Odpověděli jsme: Nemůžeme jíti, než bude-li bratr náš mladší s námi, tedy půjdeme; nebo bychom nemohli viděti tváři toho muže, nebyl-li by bratr náš nejmladší s námi. ");
INSERT INTO ces1613_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","I řekl nám služebník tvůj, otec můj: Vy víte, že dva toliko syny porodila mi žena má. ");
INSERT INTO ces1613_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","A vyšel jeden ode mne, o němž jsem pravil: Jistě roztrhán jest, a neviděl jsem ho dosavad. ");
INSERT INTO ces1613_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Vezmete-li i tohoto ode mne, a přišlo by na něj něco zlého, tedy uvedete šediny mé s trápením do hrobu. ");
INSERT INTO ces1613_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Tak tedy, když přijdu k služebníku tvému, otci svému, a pacholete nebude s námi, (ješto duše jeho spojena jest s duší tohoto): ");
INSERT INTO ces1613_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Přijde na to, když uzří, že pacholete není, umře; a uvedou služebníci tvoji šediny služebníka tvého, otce svého, s žalostí do hrobu. ");
INSERT INTO ces1613_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nebo služebník tvůj slíbil za pachole, abych je vzal od otce svého, řka: Jestliže ho nepřivedu zase k tobě, tedy vinen budu hříchem otci mému po všecky dny. ");
INSERT INTO ces1613_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Protož nyní nechť zůstane, prosím, služebník tvůj místo pacholete tohoto za služebníka pánu svému, a pachole ať vstoupí s bratry svými. ");
INSERT INTO ces1613_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nebo jak bych já vstoupil k otci svému, kdyby tohoto pacholete nebylo se mnou? Leč bych chtěl viděti trápení, kteréž by přišlo na otce mého. ");
INSERT INTO ces1613_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Jozef pak nemoha se déle zdržeti, přede všemi přístojícími zvolal: Kažte všechněm ven! I nezůstal žádný s nimi, když se známil Jozef s bratřími svými. ");
INSERT INTO ces1613_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Potom pozdvihl hlasu svého s pláčem; a slyšeli to Egyptští, slyšel také dům Faraonův. ");
INSERT INTO ces1613_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","I řekl Jozef bratřím svým: Já jsem Jozef. Ještě-li jest živ otec můj? A nemohli mu odpovědíti bratří jeho; nebo se ho velmi ulekli. ");
INSERT INTO ces1613_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Tedy řekl Jozef bratřím svým: Přistuptež medle ke mně. I přistoupili. A řekl: Já jsem Jozef bratr váš, kteréhož jste prodali do Egypta. ");
INSERT INTO ces1613_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Protož nyní nermuťte se, a neztěžujte sobě toho, že jste mne sem prodali; nebo pro zachování života vašeho poslal mne Bůh před vámi. ");
INSERT INTO ces1613_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nebo dvě létě již hlad jest v zemi, a ještě pět let přijde, v nichž nebudou orati, ani žíti. ");
INSERT INTO ces1613_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Poslal mne, pravím, Bůh před vámi, pro zachování vás ostatků na zemi, a pro zachování životů vašich vysvobozením velikým. ");
INSERT INTO ces1613_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tak tedy ne vy jste mne poslali sem, ale Bůh, kterýž mne dal za otce Faraonovi, a za pána všemu domu jeho, a panovníka po vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Pospěšte a vstupte k otci mému, a rcete jemu: Toto praví syn tvůj Jozef: Učinil mne Bůh pánem všeho Egypta; přijdiž ke mně, neprodlévej. ");
INSERT INTO ces1613_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","A bydliti budeš v zemi Gesen; a budeš blízko mne, ty i synové tvoji, i vnukové tvoji, stáda tvá, a volové tvoji, a cožkoli máš. ");
INSERT INTO ces1613_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","A budu tě chovati tam, (nebo ještě pět let hlad bude), abys snad pro hlad nezahynul, ty i dům tvůj, a cožkoli máš. ");
INSERT INTO ces1613_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","A aj, oči vaše vidí, i oči bratra mého Beniamina, že ústa má mluví vám. ");
INSERT INTO ces1613_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Povíte také otci mému o vší slávě mé v Egyptě, a což jste koli viděli; pospěštež tedy, a přiveďte otce mého sem. ");
INSERT INTO ces1613_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tedy padl na šíji Beniamina bratra svého, a plakal; Beniamin také plakal na šíji jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A políbiv všech bratří svých, plakal nad nimi; a potom mluvili bratří jeho s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Slyšána pak jest v domě Faraonově pověst tato: Přišli bratří Jozefovi. I bylo to velmi vděčné Faraonovi i všechněm služebníkům jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","A řekl Farao Jozefovi: Rci bratřím svým: Toto učiňte: Naložíce na hovada svá, jděte, a navraťte se do země Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","A vezmouce otce svého a čeládky své, přiďte ke mně, a dám vám dobré místo v zemi Egyptské, a jísti budete tuk země této. ");
INSERT INTO ces1613_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ty pak rozkaž jim: Toto učiňte: Vezměte sobě z země Egyptské vozy pro děti a ženy své, a vezměte otce svého, a přiďte. ");
INSERT INTO ces1613_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Aniž se ohlédejte na nábytky své; nebo nejlepší místo ve vší zemi Egyptské vaše bude. ");
INSERT INTO ces1613_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","I učinili tak synové Izraelovi. A dal jim Jozef vozy podlé rozkázaní Faraonova; dal také jim pokrmy na cestu. ");
INSERT INTO ces1613_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Všechněm jim dal, každému dvoje šaty; ale Beniaminovi dal tři sta stříbrných, a patery šaty jiné a jiné. ");
INSERT INTO ces1613_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Otci pak svému poslal tyto věci: Deset oslů, kteříž nesli z nejlepších věcí Egyptských, a deset oslic, kteréž nesly obilí, a chléb a pokrmy otci jeho na cestu. ");
INSERT INTO ces1613_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","A propouštěje bratří své, aby odešli, řekl jim: Nevaďtež se na cestě. ");
INSERT INTO ces1613_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tedy brali se z Egypta, a přišli do země Kananejské k Jákobovi otci svému. ");
INSERT INTO ces1613_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","A zvěstovali jemu, řkouce: Jozef ještě živ jest, ano i panuje ve vší zemi Egyptské. I omdlelo srdce jeho; nebo slyšev to nevěřil jim. ");
INSERT INTO ces1613_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tedy vypravovali jemu všecka slova Jozefova, kteráž mluvil jim; a vida vozy, kteréž poslal Jozef pro něho, okřál duch Jákoba otce jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","I řekl Izrael: Dostiť jest, když ještě syn můj živ jest; půjdu a uzřím ho, prvé než umru. ");
INSERT INTO ces1613_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tedy bral se Izrael se vším, což měl; a přišed do Bersabé, obětoval oběti Bohu otce svého Izáka. ");
INSERT INTO ces1613_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","I mluvil Bůh Izraelovi u vidění nočním, řka: Jákobe, Jákobe! Kterýžto odpověděl: Aj, teď jsem. ");
INSERT INTO ces1613_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","I řekl: Já jsem ten Bůh silný, Bůh otce tvého. Neboj se sstoupiti do Egypta, nebo v národ veliký tam tebe učiním. ");
INSERT INTO ces1613_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Já sstoupím s tebou do Egypta, a já tě také i zase přivedu; a Jozef položí ruku svou na oči tvé. ");
INSERT INTO ces1613_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Vstal tedy Jákob z Bersabé; a synové Izraelovi vzali Jákoba otce svého, a děti své s ženami svými na vozy, kteréž poslal pro něho Farao. ");
INSERT INTO ces1613_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Pobrali také dobytek svůj, a zboží své, kteréhož nabyli v zemi Kananejské; a přišli do Egypta, Jákob i všecko símě jeho s ním. ");
INSERT INTO ces1613_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Syny i vnuky, dcery i vnučky své, a všecku rodinu svou uvedl s sebou do Egypta. ");
INSERT INTO ces1613_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","A tato jsou jména synů Izraelových, kteříž vešli do Egypta: Jákob a synové jeho. Prvorozený Jákobův Ruben. ");
INSERT INTO ces1613_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","A synové Rubenovi: Enoch, Fallu, Ezron a Charmi. ");
INSERT INTO ces1613_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Synové pak Simeonovi: Jamuel, Jamin, Ahod, Jachin, Sohar a Saul, syn jedné ženy Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Synové Léví: Gerson, Kahat a Merari. ");
INSERT INTO ces1613_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Synové Judovi: Her, Onan, Séla, Fáres a Zára. (Ale umřel Her a Onan v zemi Kananejské.) Fáres pak měl syny: Ezrona a Hamule. ");
INSERT INTO ces1613_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Synové Izacharovi: Tola, Fua, Job a Simron. ");
INSERT INTO ces1613_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","A synové Zabulonovi: Sared, Elon a Jahelel. ");
INSERT INTO ces1613_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Tiť jsou synové Líe, kteréž porodila Jákobovi v Pádan Syrské, a Dínu, dceru jeho. Všech duší synů i dcer jeho bylo třidceti a tři. ");
INSERT INTO ces1613_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Synové Gád: Sefon, Aggi, Suni, Esebon, Heri, Arodi a Areli. ");
INSERT INTO ces1613_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Synové Asser: Jemna, Jesua, Jesui, Beria, a Serach sestra jejich. Synové pak Beriovi: Heber a Melchiel. ");
INSERT INTO ces1613_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","To jsou synové Zelfy, kterouž Lában dal Líe dceři své; a ty porodila Jákobovi, šestnácte duší. ");
INSERT INTO ces1613_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Synové pak Ráchel, manželky Jákobovy: Jozef a Beniamin. ");
INSERT INTO ces1613_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A Jozefovi narodili se v zemi Egyptské z Asenat, dcery Putifera knížete On, Manasses a Efraim. ");
INSERT INTO ces1613_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ale synové Beniaminovi: Béla, Becher, Asbel, Gera, Náman, Echi, Roz, Mufim, Chuppim a Ared. ");
INSERT INTO ces1613_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tiť jsou synové Ráchel, kteréž porodila Jákobovi; všech duší čtrnáct. ");
INSERT INTO ces1613_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","A syn Danův: Chusim. ");
INSERT INTO ces1613_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Synové pak Neftalím: Jaziel, Guni, Jezer a Sallem. ");
INSERT INTO ces1613_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ti jsou synové Bály, kterouž Lában dal Ráchel dceři své, a ty porodila Jákobovi; všech duší sedm. ");
INSERT INTO ces1613_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Všech duší, kteréž vešly s Jákobem do Egypta, což jich pošlo z bedr jeho, kromě žen synů Jákobových, všech duší bylo šedesáte a šest. ");
INSERT INTO ces1613_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","K tomu synové Jozefovi, kteříž se jemu narodili v Egyptě, dva. A tak všech duší domu Jákobova, kteréž vešly do Egypta, bylo sedmdesáte. ");
INSERT INTO ces1613_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Poslal pak Judu napřed k Jozefovi, aby oznámil jemu prvé, než přišel do Gesen. A tak přišli do země Gesen. ");
INSERT INTO ces1613_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jozef pak zapřáh do svého vozu, vyjel vstříc Izraelovi otci svému do Gesen; a jakž ho Jákob uzřel, padl na jeho šíji, a plakal dlouho na šíji jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","I řekl Izrael Jozefovi: Nechť již umru, když jsem viděl tvář tvou; nebo ty ještě jsi živ. ");
INSERT INTO ces1613_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Jozef pak řekl bratřím svým a domu otce svého: Pojedu a zvěstuji Faraonovi, a dím jemu: Bratří moji a dům otce mého, kteříž bydlili v zemi Kananejské, přišli ke mně. ");
INSERT INTO ces1613_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ale jsou pastýři stáda, nebo s dobytkem se obírají; protož ovce své a voly, i cožkoli mají, přihnali. ");
INSERT INTO ces1613_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","A když by povolal vás Farao, a řekl: Jaký jest obchod váš? ");
INSERT INTO ces1613_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Odpovíte: Dobytkem se živili služebníci tvoji od mladosti své až do této chvíle, i my i otcové naši; abyste bydlili v zemi Gesen; nebo v mrzkosti mají Egyptští všecky pastýře stáda. ");
INSERT INTO ces1613_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","A protož přišed Jozef, oznámil Faraonovi, a řekl: Otec můj a bratří moji, s drobným i větším dobytkem svým i se vším, což mají, přišli z země Kananejské, a aj, jsou v zemi Gesen. ");
INSERT INTO ces1613_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A vzav z počtu bratří svých pět mužů, postavil je před Faraonem. ");
INSERT INTO ces1613_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","I řekl Farao bratřím jeho: Jaký jest obchod váš? Kteřížto odpověděli Faraonovi: Pastýři ovcí jsou služebníci tvoji, i my, i otcové naši. ");
INSERT INTO ces1613_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Řekli ještě Faraonovi: Abychom pohostinu byli v zemi této, přišli jsme; nebo není pastvy dobytku, kterýž mají služebníci tvoji, nebo hlad veliký jest v zemi Kananejské; protož nyní prosíme, nechať bydlí služebníci tvoji v zemi Gesen. ");
INSERT INTO ces1613_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","I mluvil Farao Jozefovi, řka: Otec tvůj a bratří tvoji přišli k tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Země Egyptská před tebou jest; v nejlepším kraji země této osaď otce svého a bratří své, nechť bydlí v zemi Gesen. A srozumíš-li, že jsou mezi nimi muži rozšafní, ustanovíš je úředníky nad dobytkem, kterýž mám. ");
INSERT INTO ces1613_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Uvedl také Jozef Jákoba otce svého, a postavil ho před Faraonem; a pozdravil Jákob Faraona. ");
INSERT INTO ces1613_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Tedy řekl Farao k Jákobovi: Kolik jest let života tvého? ");
INSERT INTO ces1613_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Odpověděl Jákob Faraonovi: Dnů let putování mého sto a třidceti let jest; nemnozí a zlí byli dnové let života mého, a nedošli dnů let života otců mých, v nichž živi byli. ");
INSERT INTO ces1613_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","A požehnav Jákob Faraona, vyšel od něho. ");
INSERT INTO ces1613_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","I osadil Jozef otce svého a bratří své, a dal jim vládařství v zemi Egyptské v kraji výborném, v zemi Ramesses, jakž rozkázal Farao. ");
INSERT INTO ces1613_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","A opatroval Jozef otce svého, a bratří své, a všecken dům jeho chlebem, až do nejmenších. ");
INSERT INTO ces1613_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","A chleba nebylo ve vší zemi; nebo veliký hlad byl velmi, a trápení veliké bylo na zemi Egyptské a zemi Kananejské od hladu. ");
INSERT INTO ces1613_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Shromáždil pak Jozef všecky peníze, což jich nalezeno v zemi Egyptské a v zemi Kananejské, za potravy, kteréž kupovali; a vnesl Jozef peníze do domu Faraonova. ");
INSERT INTO ces1613_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","A když utratili peníze z země Egyptské a z země Kananejské, přicházeli všickni Egyptští k Jozefovi, řkouce: Dej nám chleba; nebo proč mříti máme před tebou pro nedostatek peněz? ");
INSERT INTO ces1613_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","I řekl Jozef: Dejte dobytky své, a dám vám chleba za dobytky vaše, poněvadž se vám peněz nedostává. ");
INSERT INTO ces1613_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tedy přivedli dobytky své k Jozefovi; i dal jim Jozef potrav za koně a za stáda ovcí, a za stáda volů i za osly; a přechoval je chlebem, za všecky dobytky jejich, toho roku. ");
INSERT INTO ces1613_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","A po roce tom přišli k němu léta druhého, a řekli mu: Nebudeme tajiti před pánem svým, že jsme všecky peníze utratili, i stáda dobytků jsou u pána našeho; nezůstávají nám před pánem naším kromě těla naše a dědiny naše. ");
INSERT INTO ces1613_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","I proč máme mříti před očima tvýma? I my i rolí naše hyne. Kup nás i rolí naši za chléb, a budeme my i rolí naše ve službě Faraonovi; a dej nám semena, abychom živi byli a nezemřeli, a rolí aby nespustla. ");
INSERT INTO ces1613_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tedy koupil Jozef všecku zemi Egyptskou Faraonovi; nebo prodali Egyptští jeden každý pole své, proto že se rozmohl mezi nimi hlad. I dostala se země Faraonovi. ");
INSERT INTO ces1613_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Lid pak převedl do měst, od jednoho pomezí Egyptského až do druhého. ");
INSERT INTO ces1613_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Rolí toliko kněžských nekoupil. Nebo kněží uloženou potravu měli od Faraona, a jedli z uložených pokrmů svých, kteréž dával jim Farao; protož neprodali rolí svých. ");
INSERT INTO ces1613_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","I řekl Jozef lidu: Aj, koupil jsem vás dnes i rolí vaše Faraonovi; teď máte semeno, osívejtež tedy ji. ");
INSERT INTO ces1613_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A když se urodí, dáte pátý díl Faraonovi, a čtyři díly zůstavíte sobě k semenu a ku pokrmu svému a těm, kteříž jsou v domích vašich, i ku pokrmu dítkám svým. ");
INSERT INTO ces1613_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tedy řekli: Zachoval jsi životy naše. Nechať nalezneme milost v očích pána svého, a budeme služebníci Faraonovi. ");
INSERT INTO ces1613_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","I ustanovil to Jozef za právo až do tohoto dne, po vší zemi Egyptské, aby dáván byl Faraonovi pátý díl; toliko samy rolí kněžské nebyly Faraonovy. ");
INSERT INTO ces1613_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","A tak bydlil Izrael v zemi Egyptské v krajině Gesen; a osadili se v ní, a rozplodili se, a rozmnoženi jsou velmi. ");
INSERT INTO ces1613_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Živ pak byl Jákob v zemi Egyptské sedmnácte let; a bylo dnů Jákobových, a let života jeho, sto čtyřidceti sedm let. ");
INSERT INTO ces1613_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","I přiblížili se dnové Izraelovi, aby umřel. A povolav syna svého Jozefa, řekl jemu: Jestliže jsem nalezl milost v očích tvých, vlož, prosím, ruku svou pod bedro mé, a učiň se mnou milosrdenství a pravdu. Prosím, nepochovávej mne v Egyptě. ");
INSERT INTO ces1613_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Když spáti budu s otci svými, vyneseš mne z Egypta, a pochováš mne v hrobě jejich. Tedy řekl jemu: Já učiním podlé slova tvého. ");
INSERT INTO ces1613_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","I řekl Jákob: Přisáhni mi. Tedy přisáhl jemu. I sklonil se Izrael k hlavám lůže. ");
INSERT INTO ces1613_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Stalo se pak potom, že povědíno jest Jozefovi: Aj, otec tvůj nemocen jest. I vzal s sebou dva syny své, Manasse a Efraima. ");
INSERT INTO ces1613_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tedy oznámeno jest Jákobovi a povědíno: Aj, syn tvůj Jozef přišel k tobě. ");
INSERT INTO ces1613_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","A posilniv se Izrael, usadil se na ložci a řekl Jozefovi: Bůh silný všemohoucí ukázav mi se v Lůza v zemi Kananejské, požehnal mi. ");
INSERT INTO ces1613_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","A řekl ke mně: Aj, já rozplodím tě a rozmnožím tebe, a učiním tě v zástupy lidí; dám také zemi tuto semeni tvému po tobě za dědictví věčné. ");
INSERT INTO ces1613_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Protož nyní, dva synové tvoji, kteřížť jsou se zrodili v zemi Egyptské, prvé než jsem přišel k tobě do Egypta, moji jsou; Efraim a Manasses budou mi jako Ruben a Simeon. ");
INSERT INTO ces1613_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ale děti, kteréž po těchto zplodíš, tvoji budou; jménem bratří svých jmenováni budou v dědictvích svých. ");
INSERT INTO ces1613_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nebo když jsem se vracel z Pádan, umřela mi Ráchel v zemi Kananejské na cestě, když již nedaleko bylo do Efraty; a pochoval jsem ji tam u cesty k Efratě, jenž jest Betlém. ");
INSERT INTO ces1613_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Uzřev potom Izrael syny Jozefovy, řekl: Kdo jsou onino? ");
INSERT INTO ces1613_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Odpověděl Jozef otci svému: Synové moji jsou, kteréž dal mi Bůh zde. I řekl: Přiveď je medle ke mně, a požehnám jim ");
INSERT INTO ces1613_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","(Oči pak Izraelovy mdlé byly pro starost, a nemohl dobře viděti.) I přivedl je k němu, a on líbal a objímal je. ");
INSERT INTO ces1613_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I řekl Izrael Jozefovi: Nemyslilť jsem já, abych měl kdy viděti tvář tvou, a aj, dal mi Bůh, abych viděl i símě tvé. ");
INSERT INTO ces1613_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tedy vzav je Jozef z klína jeho, sklonil se tváří až k zemi. ");
INSERT INTO ces1613_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","A vzav oba, Efraima na pravou stranu sobě, Izraelovi pak na levou, a Manassesa na levou sobě, Izraelovi pak na pravou, postavil je před ním. ");
INSERT INTO ces1613_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tedy vztáh Izrael pravici svou, vložil ji na hlavu Efraimovu, kterýž byl mladší, levici pak svou na hlavu Manassesovu, naschvál přeloživ ruce, ačkoli Manasses byl prvorozený. ");
INSERT INTO ces1613_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","I požehnal Jozefovi, řka: Bůh, před jehož oblíčejem ustavičně chodili otcové moji Abraham a Izák, Bůh, kterýž mne spravoval po všecken život můj až do dne tohoto; ");
INSERT INTO ces1613_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Anděl ten, kterýž vytrhl mne ze všeho zlého, požehnejž dítek těchto; a ať slovou synové moji a synové otců mých Abrahama a Izáka; a ať se jako hmyz rozmnoží u prostřed země. ");
INSERT INTO ces1613_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Vida pak Jozef, že vložil otec jeho ruku svou pravou na hlavu Efraimovu, nerád byl tomu. I zdvihl ruku otce svého, aby ji přenesl s hlavy Efraimovy na hlavu Manassesovu. ");
INSERT INTO ces1613_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","A řekl jemu: Ne tak, otče můj; nebo toto jest prvorozený, vložiž pravici svou na hlavu jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ale nepovolil otec jeho, a řekl: Vím, synu můj, vím; takéť i on bude v lid, a také i on vzroste; však bratr jeho mladší více poroste než on, a símě jeho bude u veliké množství národů. ");
INSERT INTO ces1613_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","I požehnal jim v ten den, řka: Skrze tebe požehnání bude dávati Izrael takto: Učiniž tobě Bůh jako Efraimovi a jako Manassesovi. I představil Efraima Manassesovi. ");
INSERT INTO ces1613_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Řekl také Izrael Jozefovi: Aj, já umírám, a budeť Bůh s vámi, a zase vás přivede do země otců vašich. ");
INSERT INTO ces1613_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Já pak dal jsem tobě jeden díl výš nad bratří tvé, kteréhož jsem mečem svým a lučištěm svým dosáhl z ruky Amorejského. ");
INSERT INTO ces1613_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Povolal pak Jákob synů svých, a řekl: Sejděte se, a oznámím vám, co se s vámi díti bude potomních dnů. ");
INSERT INTO ces1613_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Shromažďte se a slyšte synové Jákobovi, poslyšte Izraele otce svého. ");
INSERT INTO ces1613_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, prvorozený můj jsi ty, síla má, a počátek moci mé, vyvýšenost důstojenství a vyvýšenost síly. ");
INSERT INTO ces1613_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Prudce sběhneš jako voda. Nebudeš vyvýšen, proto že jsi vstoupil na lůže otce svého; a jakž jsi poškvrnil postele mé, zmizelo vyvýšení tvé. ");
INSERT INTO ces1613_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon a Léví bratří, nástrojové nepravosti jsou v příbytcích jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Do tajné rady jejich nevcházej duše má, k shromáždění jejich nepřipojuj se slávo má; nebo v prchlivosti své zbili muže, a svévolně vyvrátili zed. ");
INSERT INTO ces1613_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Zlořečená prchlivost jejich, nebo neustupná; i hněv jejich, nebo zatvrdilý jest. Rozdělím je v Jákobovi, a rozptýlím je v Izraeli. ");
INSERT INTO ces1613_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judo, ty jsi, tebe chváliti budou bratří tvoji; ruka tvá bude na šíji nepřátel tvých; klaněti se budou tobě synové otce tvého. ");
INSERT INTO ces1613_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Lvíče Juda, z loupeže, synu můj, vrátil jsi se; schýliv se, ležel jako lev a jako lvice; kdo zbudí ho? ");
INSERT INTO ces1613_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nebude odjata berla od Judy, ani vydavatel zákona od noh jeho, dokudž nepřijde Sílo; a k němu se shromáždí národové. ");
INSERT INTO ces1613_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Uváže k vinnému kmenu osle své, a k výbornému kmenu oslátko oslice své. Práti bude u víně roucho své, a v červeném víně oděv svůj. ");
INSERT INTO ces1613_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Èervenějších očí bude nad víno, a zubů bělejších nad mléko. ");
INSERT INTO ces1613_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon bydliti bude na břehu mořském, a na přístavu lodí, a pomezí jeho až k Sidonu. ");
INSERT INTO ces1613_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Izachar osel silný, ležící mezi dvěma břemeny. ");
INSERT INTO ces1613_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A vida odpočinutí, že jest dobré, a zemi, že jest rozkošná, sehne rameno své k nošení, a dávati bude daně. ");
INSERT INTO ces1613_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan souditi bude lid svůj, jako jedno z pokolení Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Budeť Dan jako had podlé cesty, jako had rohatý podlé stezky, štípaje kopyta koně, aby spadl jezdec jeho zpět. ");
INSERT INTO ces1613_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Spasení tvého očekávám, ó Hospodine! ");
INSERT INTO ces1613_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gád, vojsko přemůže jej, však on svítězí potom. ");
INSERT INTO ces1613_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asser, tučný bude pokrm jeho, a onť vydávati bude rozkoše královské. ");
INSERT INTO ces1613_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalím jako laň vypuštěná, vydávaje výmluvnosti krásné. ");
INSERT INTO ces1613_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ratolest rostoucí Jozef, ratolest rostoucí podlé studnice; ratolesti vycházely nad zed. ");
INSERT INTO ces1613_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ačkoli hořkostí naplnili jej, a stříleli na něj, a v tajné nenávisti měli ho střelci: ");
INSERT INTO ces1613_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Však zůstalo v síle lučiště jeho, a zsilila se ramena rukou jeho z rukou mocného Jákobova; odkudž byl pastýř a kámen Izraelův; ");
INSERT INTO ces1613_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Od silného Boha, jemuž sloužil otec tvůj, kterýž spomáhá tobě, a od všemohoucího, kterýž požehná tobě požehnáními nebeskými s hůry, požehnáními propasti ležící hluboko, požehnáním prsů a života. ");
INSERT INTO ces1613_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Požehnání otce tvého silnější budou nad požehnání předků mých, až k končinám pahrbků věčných; budou nad hlavou Jozefovou, a na vrchu hlavy Nazarejského mezi bratřími jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamin, vlk dravý, ráno bude jísti loupež, a večer rozdělí kořisti. ");
INSERT INTO ces1613_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Všech těchto pokolení Izraelských jest dvanácte; a to jest, což mluvil jim otec jejich; požehnal jim také, jednomu každému vedlé požehnání jeho požehnal. ");
INSERT INTO ces1613_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","A poroučeje jim, řekl: Já připojen budu k lidu svému; pochovejte mne s otci mými v jeskyni té, kteráž jest na poli Efrona Hetejského, ");
INSERT INTO ces1613_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","V jeskyni, kteráž jest na poli Machpelah, jenž jest naproti Mamre v zemi Kananejské, kterouž koupil Abraham spolu s polem tím od Efrona Hetejského k dědičnému pohřbu. ");
INSERT INTO ces1613_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tam pochovali Abrahama a Sáru ženu jeho; tam pochovali Izáka a Rebeku ženu jeho; tam také pochovali Líu. ");
INSERT INTO ces1613_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Koupeno pak bylo pole a jeskyně, kteráž na něm, od synů Het. ");
INSERT INTO ces1613_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","A když přestal Jákob přikazovati synům svým, složil nohy své na ložci a umřel; a připojen jest k lidu svému. ");
INSERT INTO ces1613_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tedy padl Jozef na tvář otce svého, a plakal nad ním, líbaje ho. ");
INSERT INTO ces1613_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","A poručil služebníkům svým lékařům, aby vonnými věcmi pomazali otce jeho. I pomazali lékaři vonnými věcmi Izraele. ");
INSERT INTO ces1613_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","A vyplnilo se při něm čtyřidceti dní; (nebo tak vyplňují se dnové těch, kteříž mazáni bývají vonnými věcmi). I plakali ho Egyptští za sedmdesáte dní. ");
INSERT INTO ces1613_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Když pak dnové pláče toho pominuli, mluvil Jozef k domu Faraonovu, řka: Jestliže jsem nyní nalezl milost před očima vašima, mluvte, prosím, v uši Faraonovy, a rcete: ");
INSERT INTO ces1613_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Otec můj přísahou mne zavázal, řka: Aj, já umírám; v hrobě mém, kterýž jsem sobě vykopal v zemi Kananejské, tam mne pochovej. Nyní tedy, prosím, nechť vstoupím a pochovám otce svého, a navrátím se zase. ");
INSERT INTO ces1613_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","I řekl Farao: Vstup a pochovej otce svého tak, jakž tě přísahou zavázal. ");
INSERT INTO ces1613_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tedy vstoupil Jozef, aby pochoval otce svého, a vstoupili s ním všickni služebníci Faraonovi, starší domu jeho a všickni starší země Egyptské, ");
INSERT INTO ces1613_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Všecken také dům Jozefův, a všickni bratří jeho i dům otce jeho; toliko dětí svých, ovec a volů nechali v zemi Gesen. ");
INSERT INTO ces1613_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Vstoupili s ním také i vozové a jezdci, a bylo vojsko to veliké velmi. ");
INSERT INTO ces1613_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","I přišli až k místu Atád, kteréž jest při brodu Jordánském, a kvílili tam kvílením velikým a velmi žalostným; i držel tu zámutek po otci svém za dnů sedm. ");
INSERT INTO ces1613_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Vidouce pak obyvatelé země té, totiž Kananejští, zámutek na místě tom Atád, řekli: Těžký to mají zámutek Egyptští. Protož nazváno jest jméno jeho Abel Mizraim, a to jest při brodu Jordánském. ");
INSERT INTO ces1613_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Učinili tedy s ním synové jeho tak, jakž jim byl poručil. ");
INSERT INTO ces1613_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","A donesše ho do země Kananejské, pochovali ho v jeskyni na poli Machpelah, kterouž byl koupil Abraham s tím polem k dědičnému pohřbu od Efrona Hetejského, naproti Mamre. ");
INSERT INTO ces1613_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","A když pochoval Jozef otce svého, navrátil se do Egypta s bratřími svými a se všemi, kteříž byli vstoupili s ním, aby pochovali otce jeho. ");
INSERT INTO ces1613_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Vidouce pak bratří Jozefovi, že umřel otec jejich, řekli: Snad v nenávisti nás míti bude Jozef, a vrchovatě nahradí nám všecko zlé, kteréž jsme jemu činili. ");
INSERT INTO ces1613_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Protož vzkázali Jozefovi, řkouce: Otec tvůj ještě před smrtí svou přikázal, řka: ");
INSERT INTO ces1613_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Takto díte Jozefovi: Prosím, odpusť již bratřím svým přestoupení a hřích jejich; nebo zle učinili tobě. Protož již odpusť, prosím, přestoupení služebníkům Boha, jehož ctil otec tvůj. I rozplakal se Jozef, když k němu mluvili. ");
INSERT INTO ces1613_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Přistoupili potom také bratří jeho, a padše před ním, řekli: Aj, my jsme služebníci tvoji. ");
INSERT INTO ces1613_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Jimž odpověděl Jozef: Nebojte se; nebo zdaliž jsem já vám za Boha? ");
INSERT INTO ces1613_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vy zajisté skládali jste proti mně zlé; ale Bůh obrátil to v dobré, aby učinil to, což vidíte nyní, a při životu zachoval lid mnohý. ");
INSERT INTO ces1613_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Protož nebojte se již; já chovati vás budu i děti vaše. A tak těšil je, a mluvil k srdci jejich. ");
INSERT INTO ces1613_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Bydlil pak Jozef v Egyptě, on i dům otce jeho, a živ byl Jozef sto a deset let. ");
INSERT INTO ces1613_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","A viděl Jozef syny Efraimovy až do třetího pokolení; ano i synové Machira, syna Manassesova, vychováni jsou u Jozefa. ");
INSERT INTO ces1613_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Mluvil potom Jozef bratřím svým: Já tudíž umru; Bůh pak jistotně navštíví vás, a vyvede vás z země této do země, kterouž přisáhl Abrahamovi, Izákovi a Jákobovi. ");
INSERT INTO ces1613_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Protož přísahou zavázal Jozef syny Izraelovy, řka: Když navštíví vás Bůh, vynestež kosti mé odsud. ");
INSERT INTO ces1613_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","I umřel Jozef, když byl ve stu a v desíti letech; a pomazán jsa vonnými věcmi, vložen jest do truhly v Egyptě. ");
INSERT INTO ces1613_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Tato jsou pak jména synů Izraelských, kteříž vešli do Egypta s Jákobem; každý s čeledí svou přišel: ");
INSERT INTO ces1613_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Léví a Juda; ");
INSERT INTO ces1613_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Izachar, Zabulon a Beniamin; ");
INSERT INTO ces1613_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan a Neftalím, Gád a Asser. ");
INSERT INTO ces1613_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","A bylo všech osob pošlých z bedr Jákobových sedmdesáte duší; Jozef pak byl v Egyptě. ");
INSERT INTO ces1613_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","I umřel Jozef a všickni bratří jeho, a všecken ten rod. ");
INSERT INTO ces1613_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Synové pak Izraelští rozmnožili se a rodili se v hojnosti; a rozhojňovali se, i zsilili se náramně velmi, a naplněna jest jimi země. ");
INSERT INTO ces1613_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","V tom povstal král nový v Egyptě, kterýž neznal Jozefa. ");
INSERT INTO ces1613_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ten řekl lidu svému: Aj, lid synů Izraelských jest mnohý a silnější nad nás. ");
INSERT INTO ces1613_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nuže, opatrně sobě počínejme před ním, aby se nerozmohl; a když by přišla válka, aby se nepřipojil i on k nepřátelům našim, a nebojoval proti nám, a nevyšel z země. ");
INSERT INTO ces1613_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Protož ustanovili nad ním úředníky, kteříž by plat vybírali, aby je trápili břemeny svými. I vystavěl lid Izraelský Faraonovi města skladů, Fiton a Ramesses. ");
INSERT INTO ces1613_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ale čím více trápili jej, tím více rostl a tím se více rozmáhal. I vzali sobě syny Izraelské v ošklivost. ");
INSERT INTO ces1613_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","A tak podrobovali Egyptští syny Izraelské v službu těžkou. ");
INSERT INTO ces1613_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","A k hořkosti přivodili život jejich robotami těžkými, v hlině a cihlách a ve všelijakém díle na poli, mimo všelikou potřebu svou, k níž práce jejich užívali nenáležitě a bez lítosti. ");
INSERT INTO ces1613_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","I poručil král Egyptský babám Hebrejským, z nichž jedna sloula Sefora a druhá Fua, ");
INSERT INTO ces1613_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","A řekl: Když budete pomáhati ženám Hebrejským při porodu, a uzříte, že již rodí, byl-li by syn, zabíte ho, pakli dcera, tedy ať jest živa. ");
INSERT INTO ces1613_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Bály se pak ty baby Boha, a nečinily tak, jakž jim poručil král Egyptský, ale živých nechávaly pacholíků. ");
INSERT INTO ces1613_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Povolav tedy bab král Egyptský, mluvil jim: Proč jste to učinily, že jste živé zachovaly pacholíky? ");
INSERT INTO ces1613_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","I odpověděly baby Faraonovi: Nejsou ženy Hebrejské jako ženy Egyptské; nebo ony jsou silnějšího přirození. Dříve než přijde k nim baba, ony porodí. ");
INSERT INTO ces1613_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","I učinil dobře Bůh těm babám. A rozmnožen jest lid, a zsilili se velmi. ");
INSERT INTO ces1613_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Stalo se pak proto, že se bály baby ty Boha, vzdělal jim domy. ");
INSERT INTO ces1613_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","I přikázal Farao všemu lidu svému, řka: Každého syna, kterýž se narodí, do řeky uvrzte; každé pak dcery nechte živé. ");
INSERT INTO ces1613_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Odšed pak muž jeden z domu Léví, vzal dceru z pokolení Léví. ");
INSERT INTO ces1613_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","I počala žena ta, a porodila syna; a viduci, že jest krásný, kryla ho za tři měsíce. ");
INSERT INTO ces1613_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","A když ho nemohla déle tajiti, vzala mu ošitku z sítí, a omazala ji klím a smolou; a vložila do ní to dítě, a vyložila do rákosí u břehu řeky. ");
INSERT INTO ces1613_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A postavila sestru jeho zdaleka, aby zvěděla, co se s ním díti bude. ");
INSERT INTO ces1613_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","A v tom sešla dcera Faraonova, aby se myla v řece; a děvečky její procházely se po břehu řeky. A uzřevši ošitku mezi rákosím, poslala děvečku svou, a vzala ji. ");
INSERT INTO ces1613_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","A když otevřela, uzřela dítě; a aj, plakalo pacholátko. A slitovavši se nad ním, řekla: Z dětí Hebrejských jest toto. ");
INSERT INTO ces1613_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","I řekla sestra jeho k dceři Faraonově: Mám-li jíti a zavolati tobě chůvy z žen Hebrejských, kteráž by odchovala tobě dítě? ");
INSERT INTO ces1613_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Odpověděla dcera Faraonova: Jdi. Tedy šla děvečka a zavolala matky toho dítěte. ");
INSERT INTO ces1613_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","I řekla jí dcera Faraonova: Vezmi toto dítě, a odchovej mi je; a jáť dám mzdu tvou. I vzala žena dítě, a chovala je. ");
INSERT INTO ces1613_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","A když odrostlo pachole, dovedla je k dceři Faraonově, kteráž jej měla za syna; a nazvala jméno jeho Mojžíš, řkuci: Nebo jsem ho z vody vytáhla. ");
INSERT INTO ces1613_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","I stalo se ve dnech těch, když vyrostl Mojžíš, že vyšel k bratřím svým, a hleděl na trápení jejich. Uzřel také muže Egyptského, an tepe muže Hebrejského, jednoho z bratří jeho. A sem i tam se ohlédna, vida, že žádného tu není, zabil Egyptského, a zahrabal jej v písku. ");
INSERT INTO ces1613_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Vyšed potom druhého dne, a aj, dva muži Hebrejští vadili se. I řekl tomu, kterýž křivdu činil: Proč tepeš bližního svého? ");
INSERT INTO ces1613_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kterýžto odpověděl: Kdo tě ustanovil knížetem a soudcí nad námi? Zdali zabiti mne myslíš, jako jsi zabil Egyptského? Protož ulekl se Mojžíš a řekl: Jistě známá jest ta věc. ");
INSERT INTO ces1613_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A uslyšav Farao tu věc, hledal zabiti Mojžíše. Ale Mojžíš utekl od tváři Faraonovy, a bydlil v zemi Madianské; i usadil se podlé studnice. ");
INSERT INTO ces1613_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kníže pak Madianské mělo sedm dcer. Kteréžto přišedše, vážily vodu, a nalívaly do koryt, aby napájely dobytek otce svého. ");
INSERT INTO ces1613_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","I přišli pastýři, a odehnali je. Tedy Mojžíš vstav, pomohl jim a napojil dobytek jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","A když se navrátily k Raguelovi, otci svému, řekl on: Jakž jste to dnes tak brzo přišly? ");
INSERT INTO ces1613_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Odpověděly: Muž Egyptský vysvobodil nás z ruky pastýřů; ano také ochotně navážil nám vody, a napojil dobytek. ");
INSERT INTO ces1613_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","I řekl dcerám svým: Kdež pak jest? Pročež jste pustily muže toho? Povolejte ho, ať pojí chleba. ");
INSERT INTO ces1613_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A svolil Mojžíš k tomu, aby bydlil s mužem tím. Kterýžto dal Zeforu, dceru svou, Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","I porodila syna, a nazval jméno jeho Gerson; nebo řekl: Příchozí jsem byl v zemi cizí. ");
INSERT INTO ces1613_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Stalo se pak po mnohých časích, že umřel král Egyptský; a synové Izraelští úpěli pro roboty, a křičeli. I vstoupil k Bohu křik jejich pro roboty. ");
INSERT INTO ces1613_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A uslyšel Bůh naříkání jejich, a rozpomenul se Bůh na smlouvu svou s Abrahamem, Izákem a Jákobem. ");
INSERT INTO ces1613_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","I vzhlédl Bůh na syny Izraelské, a poznal Bůh. ");
INSERT INTO ces1613_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mojžíš pak pásl dobytek Jetry tchána svého, kněze Madianského, a hnav stádo po poušti, přišel až k hoře Boží Oréb. ");
INSERT INTO ces1613_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Tedy ukázal se mu anděl Hospodinův v plameni ohně z prostředku kře. I viděl, a aj, keř hořel ohněm, a však neshořel. ");
INSERT INTO ces1613_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Protož řekl Mojžíš: Půjdu nyní, a spatřím vidění toto veliké, proč neshoří keř. ");
INSERT INTO ces1613_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Vida pak Hospodin, že jde, aby pohleděl, zavolal naň Bůh z prostředku kře, a řekl: Mojžíši, Mojžíši! Kterýžto odpověděl: Aj, teď jsem. ");
INSERT INTO ces1613_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","I řekl: Nepřistupuj sem, szuj obuv svou s noh svých; nebo místo, na kterémž ty stojíš, země svatá jest. ");
INSERT INTO ces1613_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A řekl: Já jsem Bůh otce tvého, Bůh Abrahamův, Bůh Izákův, a Bůh Jákobův. I zakryl Mojžíš tvář svou, (nebo se bál), aby nepatřil na Boha. ");
INSERT INTO ces1613_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Jemužto řekl Hospodin: Zřetelně viděl jsem trápení lidu mého, kterýž jest v Egyptě; a křik jejich pro přísnost úředníků jeho slyšel jsem; nebo znám bolesti jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Protož jsem sstoupil, abych vysvobodil jej z ruky Egyptských, a vyvedl jej z země té do země dobré a prostranné, do země oplývající mlékem a strdí, na místa Kananejského a Hetejského, a Amorejského a Ferezejského, a Hevejského a Jebuzejského. ");
INSERT INTO ces1613_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nebo nyní, aj, křik synů Izraelských přišel ke mně; viděl jsem také i ssoužení, jímž je ssužují Egyptští. ");
INSERT INTO ces1613_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Protož, nyní poď a pošli tě k Faraonovi; a vyvedeš lid můj, syny Izraelské z Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","I řekl Mojžíš Bohu: Kdo jsem já, abych šel k Faraonovi, a abych vyvedl syny Izraelské z Egypta? ");
INSERT INTO ces1613_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","I odpověděl: Však budu s tebou; a toto budeš míti znamení, že jsem já tě poslal: Když vyvedeš lid ten z Egypta, sloužiti budete Bohu na hoře této. ");
INSERT INTO ces1613_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","I řekl Mojžíš Bohu: Aj, já půjdu k synům Izraelským a dím jim: Bůh otců vašich poslal mne k vám. Řeknou-li mi: Které jest jméno jeho? co jim odpovím? ");
INSERT INTO ces1613_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","I řekl Bůh Mojžíšovi: JSEM, KTERÝŽ JSEM. Řekl dále: Takto díš synům Izraelským: JSEM poslal mne k vám. ");
INSERT INTO ces1613_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Řekl ještě Bůh Mojžíšovi: Takto díš synům Izraelským: Hospodin, Bůh otců vašich, Bůh Abrahamův, Bůh Izákův, a Bůh Jákobův poslal mne k vám; toť jest jméno mé na věčnost, a tať jest památka má po všecky věky. ");
INSERT INTO ces1613_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Jdi, a shromáždě starší Izraelské, mluv jim: Hospodin Bůh otců vašich ukázal mi se, Bůh Abrahamův, Bůh Izákův, a Bůh Jákobův, řka: Rozpomínaje, rozpomenul jsem se na vás, a na to, co se vám dálo v Egyptě. ");
INSERT INTO ces1613_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Protož jsem řekl: Vyvedu vás z trápení Egyptského do země Kananejského, a Hetejského, a Amorejského, a Ferezejského, a Hevejského, a Jebuzejského, do země oplývající mlékem a strdí. ");
INSERT INTO ces1613_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","I poslechnou hlasu tvého. Půjdeš pak ty a starší Izraelští k králi Egyptskému, a díte jemu: Hospodin Bůh Hebrejský potkal se s námi; protož nyní, nechť medle jdeme cestou tří dnů na poušť, abychom obětovali Hospodinu Bohu našemu. ");
INSERT INTO ces1613_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ale já vím, žeť vám nedopustí král Egyptský jíti; leč v ruce silné. ");
INSERT INTO ces1613_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Protož vztáhnu ruku svou, a bíti budu Egypt divnými věcmi svými, kteréž činiti budu u prostřed něho; a potom propustí vás. ");
INSERT INTO ces1613_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","A dám milost lidu tomuto před očima Egyptských. I stane se, že když půjdete, neodejdete prázdní. ");
INSERT INTO ces1613_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ale vypůjčí žena od sousedy své, a od hospodyně domu svého klínotů stříbrných, a klínotů zlatých a roucha; i vložíte to na syny a na dcery své, a tak obloupíte Egypt. ");
INSERT INTO ces1613_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Odpověděl pak Mojžíš, a řekl: Aj, neuvěří mi, ani uposlechnou hlasu mého; nebo řeknou: Neukázalť se tobě Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Tedy řekl jemu Hospodin: Co jest to v ruce tvé? Odpověděl: Hůl. ");
INSERT INTO ces1613_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","I řekl: Vrz ji na zem. I povrhl ji na zem, a obrácena jest v hada; a utíkal Mojžíš před ním. ");
INSERT INTO ces1613_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Tedy řekl Hospodin Mojžíšovi: Vztáhni ruku svou, a chyť ho za ocas. Kterýžto vztáh ruku svou, chytil jej, a obrácen jest v hůl v rukou jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Aby věřili, že se ukázal tobě Hospodin, Bůh otců jejich, Bůh Abrahamův, Bůh Izákův a Bůh Jákobův. ");
INSERT INTO ces1613_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Potom zase řekl jemu Hospodin: Vlož nyní ruku svou za ňadra svá. I vložil ruku svou za ňadra svá; a vyňal ji, a aj, ruka jeho byla malomocná, bílá jako sníh. ");
INSERT INTO ces1613_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Řekl opět: Vlož ruku svou zase v ňadra svá. Kterýž vložil ruku svou zase v ňadra svá; a vyňal ji z ňader svých, a aj, učiněna jest zase jako jiné tělo jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","I budeť, jestliže neuvěří tobě, a neposlechnou hlasu a znamení prvního, uvěří hlasu a znamení druhému. ");
INSERT INTO ces1613_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","A pakli neuvěří ani těm dvěma znamením, a neuposlechnou hlasu tvého, tedy nabereš vody z řeky, a vyliješ ji na zem; a promění se vody, kteréž vezmeš z řeky, a obrátí se v krev na zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","I řekl Mojžíš Hospodinu: Prosím, Pane, nejsem muž výmluvný, aniž prvé, ani jakž jsi mluvil s služebníkem svým; nebo zpozdilých úst a neohbitého jazyku jsem. ");
INSERT INTO ces1613_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Jemuž odpověděl Hospodin: Kdo dal ústa člověku? Aneb kdo může učiniti němého, neb hluchého, vidoucího, neb slepého? Zdali ne já Hospodin? ");
INSERT INTO ces1613_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nyní tedy jdi, a já budu v ústech tvých, a naučím tě, co bys mluviti měl. ");
INSERT INTO ces1613_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","I řekl: Slyš mne, Pane, pošli, prosím, toho, kteréhož poslati máš. ");
INSERT INTO ces1613_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","A rozhněvav se velmi Hospodin na Mojžíše, řekl: Zdaliž nemáš Arona bratra svého z pokolení Léví? Vím, že on výmluvný jest; ano aj, sám vyjde v cestu tobě, a vida tebe, radovati se bude v srdci svém. ");
INSERT INTO ces1613_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ty mluviti budeš k němu, a vložíš slova v ústa jeho; a já budu v ústech tvých a v ústech jeho, a naučím vás, co byste měli činiti. ");
INSERT INTO ces1613_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A on mluviti bude za tebe k lidu; a bude tobě on za ústa, a ty budeš jemu za Boha. ");
INSERT INTO ces1613_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Hůl pak tuto vezmeš v ruku svou, kterouž činiti budeš ta znamení. ");
INSERT INTO ces1613_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Tedy odšed Mojžíš, navrátil se k Jetrovi tchánu svému, a řekl jemu: Nechť jdu nyní, a navrátím se k bratřím svým, kteříž jsou v Egyptě, a pohledím, jsou-li ještě živi. I řekl Jetro Mojžíšovi: Jdi v pokoji. ");
INSERT INTO ces1613_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nebo řekl byl Hospodin Mojžíšovi v zemi Madianské: Jdi, navrať se do Egypta; nebo zemřeli jsou všickni muži, kteříž hledali bezživotí tvého. ");
INSERT INTO ces1613_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","A vzav Mojžíš ženu svou, a syny své, vsadil je na osla, aby se navrátil do země Egyptské; vzal také Mojžíš hůl Boží v ruku svou. ");
INSERT INTO ces1613_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","I řekl Hospodin Mojžíšovi: Když půjdeš a navrátíš se do Egypta, hleď, abys všecky zázraky, kteréž jsem složil v ruce tvé, činil před Faraonem. Jáť pak zatvrdím srdce jeho, aby nepropustil lidu. ");
INSERT INTO ces1613_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Protož díš Faraonovi: Toto praví Hospodin: Syn můj, prvorozený můj jest Izrael. ");
INSERT INTO ces1613_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I řekl jsem tobě: Propusť syna mého, ať slouží mi; a nechtěl jsi ho propustiti. Aj, já zabiji syna tvého, prvorozeného tvého. ");
INSERT INTO ces1613_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","I stalo se, když byl Mojžíš na cestě v hospodě, že se obořil na něj Hospodin, a hledal ho usmrtiti. ");
INSERT INTO ces1613_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tedy vzala Zefora nůž ostrý, a obřezala neobřízku syna svého, kteroužto vrhla k nohám jeho, řkuci: Zajisté ženich krví jsi mi. ");
INSERT INTO ces1613_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","I nechal ho. Ona pak nazvala ho tehdáž ženichem krví pro obřezání. ");
INSERT INTO ces1613_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Řekl také Hospodin Aronovi: Jdi vstříc Mojžíšovi na poušť. I šel a potkal se s ním na hoře Boží, a políbil ho. ");
INSERT INTO ces1613_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","A vypravoval Mojžíš Aronovi všecka slova Hospodinova, kterýž ho poslal, i o všech znameních, kteráž přikázal jemu. ");
INSERT INTO ces1613_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Tedy šel Mojžíš s Aronem, a shromáždili všecky starší synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","I mluvil Aron všecka slova, kteráž byl mluvil Hospodin k Mojžíšovi, a činil znamení před očima lidu. ");
INSERT INTO ces1613_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","A uvěřil lid, když uslyšeli, že navštívil Hospodin syny Izraelské, a že viděl ssoužení jejich. A sklonivše se, poklonu učinili. ");
INSERT INTO ces1613_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Potom pak přišli Mojžíš s Aronem, a řekli Faraonovi: Takto praví Hospodin, Bůh Izraelský: Propusť lid můj, ať mi slaví svátky na poušti. ");
INSERT INTO ces1613_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Odpověděl Farao: Kdo jest Hospodin, abych poslechl hlasu jeho a propustil Izraele? Hospodina neznám, Izraele také nepropustím. ");
INSERT INTO ces1613_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","I řekli: Bůh Hebrejský potkal se s námi. Nechť medle jdeme cestou tří dní na poušť, a obětujeme Hospodinu Bohu našemu, aby nedopustil na nás moru neb meče. ");
INSERT INTO ces1613_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","I řekl jim král Egyptský: Proč ty Mojžíši a Arone, odtrhujete lid od prací jejich? Jděte k robotám svým. ");
INSERT INTO ces1613_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Řekl také Farao: Hle, již nyní mnoho jest lidu toho v zemi, a vy odvozujete je od robot jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","I přikázal Farao v ten den úředníkům nad lidem a šafářům jeho, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Nedávejte již více slámy lidu k dělání cihel jako prvé; nechať jdou sami a sbírají sobě slámu. ");
INSERT INTO ces1613_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Však touž summu cihel, kterouž udělávali prvé, uložte na ně, nic neujímejte z ní; neboť zahálejí, a protož volají, řkouce: Poďme, obětujme Bohu našemu. ");
INSERT INTO ces1613_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Nechť se přitíží robot mužům těm; a nechť pracují v nich, aby se neohlédali na slova lživá. ");
INSERT INTO ces1613_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Vyšedše tedy úředníci nad lidem a šafáři jeho, mluvili k lidu, řkouce: Takto praví Farao: Já nebudu vám dávati slámy. ");
INSERT INTO ces1613_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Sami jděte, beřte sobě slámu, kdekoli naleznete; ale nic nebude ujato díla vašeho. ");
INSERT INTO ces1613_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","I rozběhl se lid po vší zemi Egyptské, aby trhal strniště místo slámy. ");
INSERT INTO ces1613_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","A úředníci nutili je, řkouce: Vyplňte díla svá, úkol denní v den jeho, jako když sláma byla. ");
INSERT INTO ces1613_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","I biti jsou šafáři synů Izraelských, kteréž ustanovili nad nimi úředníci Faraonovi, a mluveno k nim: Proč jste nevyplnili úkolu svého v díle cihel, jako prvé, ani včera ani dnes? ");
INSERT INTO ces1613_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","I přišli šafáři synů Izraelských, a volali k Faraonovi, řkouce: Proč tak děláš služebníkům svým? ");
INSERT INTO ces1613_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Slámy se nedává služebníkům tvým, a říkají nám: Dělejte cihly; a hle, služebníci tvoji biti bývají, a hřeší lid tvůj. ");
INSERT INTO ces1613_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","I řekl: Zahálíte, zahálíte, a protož mluvíte: Poďme, obětujme Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Protož nyní jděte, dělejte; slámy se vám dávati nebude, ale vy summu cihel vyplňujte. ");
INSERT INTO ces1613_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Vidouce šafáři synů Izraelských, že zle s nimi, poněvadž řečeno: Neujmete počtu cihel vašich z úkolu denního v den jeho, ");
INSERT INTO ces1613_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Potkali se s Mojžíšem a Aronem, kteříž stáli, aby jim vstříc vyšli, když by se vraceli od Faraona. ");
INSERT INTO ces1613_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","A mluvili jim: Pohlediž Hospodin na vás, a suď; nebo zošklivili jste nás před Faraonem a služebníky jeho, a dali jste meč v ruku jejich, aby nás zamordovali. ");
INSERT INTO ces1613_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","I navrátil se Mojžíš k Hospodinu a řekl: Pane, proč jsi tyto zlé věci uvedl na lid tento? Proč jsi mne sem poslal? ");
INSERT INTO ces1613_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nebo od té chvíle, jakž jsem všel k Faraonovi, abych mluvil jménem tvým, hůře nakládá s lidem tímto, a ty jsi vždy nevysvobodil lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Odpověděl Hospodin Mojžíšovi: Nyní uzříš, co učiním Faraonovi; nebo v ruce silné propustí je, a v ruce mocné vyžene je z země své. ");
INSERT INTO ces1613_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mluvil ještě Bůh k Mojžíšovi a řekl jemu: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ukázalť jsem se zajisté Abrahamovi, Izákovi a Jákobovi v tom, že jsem Bůh silný všemohoucí; ale v jménu svém, Hospodin, nejsem poznán od nich. ");
INSERT INTO ces1613_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","K tomu utvrdil jsem smlouvu svou s nimi, že jim dám zemi Kananejskou, zemi putování jejich, v níž pohostinu byli. ");
INSERT INTO ces1613_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nad to, já slyšel jsem křik synů Izraelských, kteréž Egyptští v službu podrobují, a rozpomenul jsem se na smlouvu svou. ");
INSERT INTO ces1613_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Protož pověz synům Izraelským: Já jsem Hospodin, a vyvedu vás z robot Egyptských, a vytrhnu vás z služby jejich, a vysvobodím vás v ruce vztažené a skrze soudy veliké. ");
INSERT INTO ces1613_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","A vezmu vás sobě za lid, a budu vám za Boha; a zvíte, že jsem Hospodin Bůh váš, vysvobozující vás z robot Egyptských. ");
INSERT INTO ces1613_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Uvedu vás také do země, o níž jsem, zdvihna ruku svou, přisáhl, že ji dám Abrahamovi, Izákovi a Jákobovi; a dám ji vám v dědictví; Já Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","I mluvil tak Mojžíš synům Izraelským; ale neslyšeli Mojžíše pro úzkost ducha a službu přetěžkou. ");
INSERT INTO ces1613_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Protož mluvil Hospodin Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Vejdi, mluv Faraonovi králi Egyptskému, ať propustí syny Izraelské z země své. ");
INSERT INTO ces1613_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","I mluvil Mojžíš před Hospodinem, řka: Hle, synové Izraelští neposlechli mne, kterakž tedy poslechne mne Farao, a já jsem zpozdilý v řeči? ");
INSERT INTO ces1613_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","I mluvil Hospodin Mojžíšovi a Aronovi, a přikázaní dal jim k synům Izraelským a k Faraonovi králi Egyptskému, aby vyvedli syny Izraelské z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Tito jsou přední v čeledech otců svých. Synové Rubenovi, prvorozeného Izraelova: Enoch, Fallu, Ezron a Charmi. Ty jsou čeledi Rubenovy. ");
INSERT INTO ces1613_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Synové pak Simeonovi: Jamuel, Jamin, Ahod, Jachin, Sohar a Saul, syn Kananejské. Ty jsou čeledi Simeonovy. ");
INSERT INTO ces1613_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","A tato jsou jména synů Léví v rodech jejich: Gerson, Kahat a Merari. Let pak života Léví bylo sto třidceti a sedm let. ");
INSERT INTO ces1613_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Synové Gerson: Lebni a Semei po čeledech svých. ");
INSERT INTO ces1613_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","A synové Kahat: Amram, Izar, Hebron a Uziel. Let pak života Kahat bylo sto třidceti a tři léta. ");
INSERT INTO ces1613_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","A synové Merari: Moholi a Musi. Ty jsou čeledi Léví v rodech svých. ");
INSERT INTO ces1613_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Pojal pak Amram ženu Jochebed, tetu svou, sobě za manželku, kterážto porodila mu Arona a Mojžíše. A let života Amramova bylo sto třidceti a sedm let. ");
INSERT INTO ces1613_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Synové také Izarovi: Chore, Nefega Zechri. ");
INSERT INTO ces1613_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","A synové Uzielovi: Mizael, Elzafan a Sethri. ");
INSERT INTO ces1613_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Pojal pak Aron Alžbětu, dceru Aminadabovu, sestru Názonovu, sobě za manželku; kterážto porodila jemu Nádaba, Abiu, Eleazara a Itamara. ");
INSERT INTO ces1613_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Synové pak Chore: Asser, Elkana a Abiazaf. Ty jsou čeledi Choritských. ");
INSERT INTO ces1613_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar pak syn Aronův vzal jednu ze dcer Putielových sobě za manželku; kteráž mu porodila Fínesa. Ti jsou přední z otců Levítských po čeledech svých. ");
INSERT INTO ces1613_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","To jest ten Aron a Mojžíš, jimž řekl Hospodin: Vyveďte syny Izraelské z země Egyptské po houfích jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Tito jsou, kteříž mluvili Faraonovi, králi Egyptskému, aby vyvedli syny Izraelské z Egypta; toť jest ten Mojžíš a Aron. ");
INSERT INTO ces1613_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Stalo se pak, když mluvil Hospodin k Mojžíšovi v zemi Egyptské, ");
INSERT INTO ces1613_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Že mu řekl takto: Já Hospodin; mluv k Faraonovi, králi Egyptskému, všecko, což já mluvím tobě. ");
INSERT INTO ces1613_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","A řekl Mojžíš před Hospodinem: Aj, já jsem zpozdilý v řeči, kterakž tedy poslouchati mne bude Farao? ");
INSERT INTO ces1613_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","I řekl Hospodin Mojžíšovi: Aj, ustanovil jsem tě za Boha Faraonovi; Aron pak bratr tvůj bude prorokem tvým. ");
INSERT INTO ces1613_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ty mluviti budeš všecko, což tobě přikáži; Aron pak bratr tvůj mluviti bude k Faraonovi, aby propustil syny Izraelské z země své. ");
INSERT INTO ces1613_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ale jáť zatvrdím srdce Faraonovo, a množiti budu znamení svá a zázraky své v zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Aniž poslechne vás Farao. I vzložím ruku svou na Egypt, a vyvedu vojska svá, lid svůj, syny Izraelské, z země Egyptské skrze soudy veliké. ");
INSERT INTO ces1613_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","I zvědíť Egyptští, že já jsem Hospodin, když vztáhnu ruku svou na Egypt; a vyvedu syny Izraelské z prostředku jich. ");
INSERT INTO ces1613_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Tedy učinil Mojžíš a Aron tak; jakž přikázal jim Hospodin, tak učinili. ");
INSERT INTO ces1613_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","A byl Mojžíš v osmdesáti, Aron pak v osmdesáti a třech letech, když mluvili s Faraonem. ");
INSERT INTO ces1613_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","I řekl Hospodin Mojžíšovi a Aronovi takto: ");
INSERT INTO ces1613_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Když mluviti k vám bude Farao, řka: Ukažte od sebe zázrak, tedy díš Aronovi: Vezmi hůl svou, a povrz před Faraonem, i obrátí se v hada. ");
INSERT INTO ces1613_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tedy všel Mojžíš s Aronem k Faraonovi, a učinili tak, jakž přikázal Hospodin; a povrhl Aron hůl svou před Faraonem i před služebníky jeho, a obrácena jest v hada. ");
INSERT INTO ces1613_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Povolal pak také Farao mudrců a čarodějníků; a učinili i ti čarodějníci Egyptští skrze čáry své tolikéž. ");
INSERT INTO ces1613_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Nebo povrhl každý z nich hůl svou, a obráceny jsou v hady; ale požřela hůl Aronova hole jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","I posililo se srdce Faraonovo, a neuposlechl jich, tak jakž byl mluvil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Protož řekl Hospodin Mojžíšovi: Obtížilo se srdce Faraonovo; nechce propustiti lidu toho. ");
INSERT INTO ces1613_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Jdi k Faraonovi ráno, aj, půjde ven k vodě, a stůj naproti němu při břehu řeky; a hůl, kteráž obrácena byla v hada, vezmeš do ruky své. ");
INSERT INTO ces1613_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","A díš mu: Hospodin Bůh Hebrejský poslal mne k tobě, aťbych řekl: Propusť lid můj, aby sloužili mi na poušti; a aj, neuposlechls až dosavad. ");
INSERT INTO ces1613_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Protož takto praví Hospodin: Po tomto poznáš, že já jsem Hospodin: Aj, já udeřím holí, kteráž jest v ruce mé, na vody, kteréž jsou v řece, a obráceny budou v krev. ");
INSERT INTO ces1613_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","A ryby, kteréž jsou v řece, pomrou; i nasmradí se řeka, a ustávati budou Egyptští, hledajíce vody, kterouž by pili z řeky. ");
INSERT INTO ces1613_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Protož řekl Hospodin Mojžíšovi: Rci Aronovi: Vezmi hůl svou, a vztáhni ruku svou na vody Egyptské, na řeky jejich, na potoky jejich, i na jezera jejich, a na všecka shromáždění vod jejich, aby se obrátily v krev; i bude krev po vší zemi Egyptské, tak v nádobách dřevěných, jako kamenných. ");
INSERT INTO ces1613_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tedy učinili tak Mojžíš a Aron, jakž byl přikázal Hospodin; a zdvihna hůl, udeřil v vodu, kteráž byla v řece, před očima Faraonovýma a před očima služebníků jeho; i obráceny jsou všecky vody, kteréž byly v řece, v krev. ");
INSERT INTO ces1613_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ryby pak, kteréž byly v řece, pomřely, a nasmradila se řeka, tak že nemohli Egyptští píti vody z řeky; a byla krev po vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","To též učinili i čarodějníci Egyptští skrze čáry své. I zsililo se srdce Faraonovo, aby neuposlechl jich, tak jakž byl mluvil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","A odvrátiv se Farao, přišel do domu svého; a ani k tomu nepřiložil srdce svého. ");
INSERT INTO ces1613_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Kopali pak všickni Egyptští vůkol řeky, hledajíce vody ku pití; nebo nemohli píti vody z řeky. ");
INSERT INTO ces1613_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","A vyplnilo se dní sedm, jakž ranil Hospodin řeku. ");
INSERT INTO ces1613_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","I mluvil Hospodin k Mojžíšovi: Vejdi k Faraonovi a rci jemu: Takto praví Hospodin: Propusť lid můj, ať mi slouží. ");
INSERT INTO ces1613_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Pakli nebudeš chtíti propustiti, aj, já raním všecky krajiny tvé žabami. ");
INSERT INTO ces1613_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","A vydá řeka množství žab, kteréž vystoupí a polezou do domu tvého a do pokoje, v němž líháš, a na ložce tvé, a do domů služebníků tvých i lidu tvého, a do pecí tvých a do těsta tvého. ");
INSERT INTO ces1613_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","I na tebe a na lid tvůj, i na všecky služebníky tvé polezou žáby. ");
INSERT INTO ces1613_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","I řekl Hospodin Mojžíšovi: Rci Aronovi: Vztáhni ruku svou s holí svou na řeky, na potoky a na jezera, a vyveď žáby na zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","I vztáhl Aron ruku svou na vody Egyptské; a vystoupily žáby a přikryly zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","A učinili tolikéž čarodějníci skrze své čáry; a udělali, že vyšly žáby na zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tedy Farao povolav Mojžíše a Arona, řekl: Modlte se Hospodinu, ať odejme žáby ode mne a od lidu mého; a propustím ten lid, aby obětovali Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","I řekl Mojžíš Faraonovi: Poctím tě tím, a pověz, kdy bych se měl modliti za tě a za služebníky tvé, a za lid tvůj, aby vypléněny byly žáby od tebe, i z domů tvých; toliko v řece zůstanou. ");
INSERT INTO ces1613_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kterýžto odpověděl: Zítra. A Mojžíš řekl: Podlé slova tvého nechť jest, abys věděl, že žádného takového není, jako Hospodin Bůh náš. ");
INSERT INTO ces1613_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","I odejdou žáby od tebe a od domů tvých, i od služebníků tvých a od lidu tvého; toliko v řece zůstanou. ");
INSERT INTO ces1613_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tedy vyšel Mojžíš s Aronem od Faraona. I volal Mojžíš k Hospodinu, aby odjaty byly žáby, kteréž byl dopustil na Faraona. ");
INSERT INTO ces1613_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","I učinil Hospodin podlé slova Mojžíšova; a vymřely žáby z domů, ze vsí i z polí. ");
INSERT INTO ces1613_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","I shrnuli je na hromady; a nasmradila se země. ");
INSERT INTO ces1613_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Vida pak Farao, že by dáno bylo oddechnutí, více zatvrdil se v srdci svém, a neuposlechl jich, jakož byl mluvil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","I řekl Hospodin Mojžíšovi: Rci k Aronovi: Vztáhni hůl svou, a udeř v prach země, aby obrátil se v stěnice na vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kteříž učinili tak. Nebo vztáhl Aron ruku svou s holí svou, a udeřil prach země. I byly stěnice na lidech i hovadech; všecken prach země obrátil se v stěnice ve vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Dělali také tak čarodějníci skrze čáry své, aby vyvedli stěnice, ale nemohli. A byly stěnice na lidech i hovadech. ");
INSERT INTO ces1613_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tedy řekli čarodějníci Faraonovi: Prst Boží toto jest. A posililo se srdce Faraonovo, aniž poslechl jich, jakož mluvil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Řekl pak Hospodin Mojžíšovi: Vstaň ráno a stůj před Faraonem. Hle vyjde k vodě, a díš k němu: Takto praví Hospodin: Propusť lid můj, ať mi slouží. ");
INSERT INTO ces1613_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pakli nepropustíš lidu mého, hle, já pošli na tě a na služebníky tvé, a na lid tvůj, a na domy tvé směsici všelikých škodlivých žížal; a naplněni budou domové Egyptští těmi žížalami, nad to i země ta, na níž oni jsou. ");
INSERT INTO ces1613_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","A oddělím v ten den zemi Gesen, v níž lid můj zůstává, aby tam nebylo směsice té; abys věděl, že jsem já Hospodin u prostřed země. ");
INSERT INTO ces1613_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","A vysvobozením rozdíl učiním mezi lidem svým a lidem tvým. Zítra bude znamení toto. ");
INSERT INTO ces1613_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","I učinil Hospodin tak. Nebo přišla těžká směsice škodlivých žížal na dům Faraonův, a do domů služebníků jeho i na všecku zemi Egyptskou; a nakazila se země od té směsice. ");
INSERT INTO ces1613_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Povolal pak Farao Mojžíše a Arona, a řekl: Jděte, obětujte Bohu svému tu v zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","I řekl Mojžíš: Nenáleží nám tak činiti; nebo ohavnost Egyptských obětovali bychom Hospodinu Bohu našemu. A jestliže bychom obětovali to, což jest ohavnost před očima Egyptských, zdaž by nás neukamenovali? ");
INSERT INTO ces1613_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Cestou tří dnů půjdeme na poušť, a obětovati budeme Hospodinu Bohu našemu, jakž nám rozkázal. ");
INSERT INTO ces1613_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","I řekl Farao: Já propustím vás, abyste obětovali Hospodinu Bohu svému na poušti, však dále abyste nikoli neodcházeli. Modltež se za mne. ");
INSERT INTO ces1613_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Odpověděl Mojžíš: Aj, já vycházím od tebe, a modliti se budu Hospodinu, aby odešla ta směsice od tebe, od služebníků tvých i od lidu tvého zítra; avšak ať Farao více nezklamává, nepropouštěje lidu, aby obětovali Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","A vyšed Mojžíš od Faraona, modlil se Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","I učinil Hospodin podlé slova Mojžíšova, a odjal tu směsici od Faraona, od služebníků jeho i od lidu jeho, tak že ani jedné žížaly nezůstalo. ");
INSERT INTO ces1613_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ale Farao ztížil srdce své také i tehdáž, a nepropustil lidu. ");
INSERT INTO ces1613_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Tedy řekl Hospodin Mojžíšovi: Vejdi k Faraonovi, a mluv k němu: Takto praví Hospodin, Bůh Hebrejský: Propusť lid můj, ať mi slouží. ");
INSERT INTO ces1613_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Pakli nebudeš chtíti propustiti, než předce držeti je budeš: ");
INSERT INTO ces1613_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Aj, ruka Hospodinova bude na dobytku tvém, kterýž jest na poli, na koních, na oslích, na velbloudích, na volích a na ovcech, mor těžký velmi. ");
INSERT INTO ces1613_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","A učiní Hospodin rozdíl mezi dobytky Izraelských a mezi dobytky Egyptských, aby nic neumřelo ze všeho, což jest synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","A uložil Hospodin čas jistý, řka: Zítra učiní Hospodin věc takovou na zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","I učinil Hospodin tu věc na zejtří, a pomřel všecken dobytek Egyptským; z dobytku pak synů Izraelských ani jedno neumřelo. ");
INSERT INTO ces1613_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","I poslal Farao, a aj, neumřelo z dobytků Izraelských ani jedno. Ale obtíženo jest srdce Faraonovo, a nepropustil lidu. ");
INSERT INTO ces1613_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","I řekl Hospodin Mojžíšovi a Aronovi: Vezměte sobě plné hrsti své popela z peci, a ať jej sype Mojžíš k nebi před očima Faraonovýma. ");
INSERT INTO ces1613_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","I obrátí se v prach po vší zemi Egyptské, a budou z něho na lidech i na hovadech vředové prýštící se neštovicemi po vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nabravše tedy popela z peci, stáli před Faraonem, a sypal jej Mojžíš k nebi. I byli vředové plní neštovic, prýštící se na lidech i na hovadech. ");
INSERT INTO ces1613_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Aniž mohli čarodějníci státi před Mojžíšem pro vředy; nebo byli vředové na čarodějnících i na všech Egyptských. ");
INSERT INTO ces1613_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","I zsilil Hospodin srdce Faraonovo, a neposlechl jich, tak jakž byl mluvil Hospodin k Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Tedy řekl Hospodin Mojžíšovi: Vstana ráno, postav se před Faraonem, a rci k němu: Takto praví Hospodin, Bůh Hebrejský: Propusť lid můj, ať mi slouží. ");
INSERT INTO ces1613_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Nebo já teď již pošli všecky rány své na srdce tvé, i na služebníky tvé a na lid tvůj, abys věděl, žeť není podobného mně na vší zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nebo nyní, když jsem vztáhl ruku svou, byl bych tebe také ranil i lid tvůj morem tím; a tak bys byl vyhlazen z země. ");
INSERT INTO ces1613_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ale však proto jsem tě zachoval, abych ukázal na tobě moc svou, a aby vypravovali jméno mé na vší zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ještě ty pozdvihuješ se proti lidu mému, nechtěje ho propustiti? ");
INSERT INTO ces1613_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Aj, já dštíti budu zítra v tentýž čas krupobitím těžkým náramně, jakéhož nebylo v Egyptě od toho dne, jakž založen jest, až do tohoto času. ");
INSERT INTO ces1613_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Protož nyní pošli, shromažď dobytek svůj a cokoli máš na poli. Na všecky lidi i hovada, kteráž by nalezena byla na poli, a nebyla by shromážděna do domu, spadne krupobití, a pomrou. ");
INSERT INTO ces1613_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kdo tedy z služebníků Faraonových ulekl se slova Hospodinova, svolal hbitě služebníky své i dobytek svůj do domu. ");
INSERT INTO ces1613_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ale kdož nepřiložil srdce svého k slovu Hospodinovu, nechal služebníků svých a dobytka svého na poli. ");
INSERT INTO ces1613_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","I řekl Hospodin Mojžíšovi: Vztáhni ruku svou k nebi, ať jest krupobití po vší zemi Egyptské, na lidi i na hovada i na všelikou bylinu polní v zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tedy vztáhl Mojžíš hůl svou k nebi, a Hospodin vydal hřímání a krupobití. I sstoupil oheň na zem, a dštil Hospodin krupobitím na zemi Egyptskou. ");
INSERT INTO ces1613_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","I bylo krupobití a oheň smíšený s krupobitím těžký velmi, jakéhož nebylo nikdy ve vší zemi Egyptské, jakž v ní bydliti lidé začali. ");
INSERT INTO ces1613_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","I ztloukly kroupy po vší zemi Egyptské, cožkoli bylo na poli od člověka až do hovada; všecku také bylinu polní potloukly kroupy, i všecko stromoví na poli zpřerážely. ");
INSERT INTO ces1613_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Toliko v zemi Gesen, v níž byli synové Izraelští, nebylo krupobití. ");
INSERT INTO ces1613_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Poslav tedy Farao, povolal Mojžíše a Arona a řekl jim: Zhřešil jsem i nyní. Hospodinť jest spravedlivý, ale já a lid můj bezbožní jsme. ");
INSERT INTO ces1613_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Modlte se Hospodinu, (nebo dosti jest), ať není hřímání Božího a krupobití. Tedy propustím vás, aniž déle zůstávati budete. ");
INSERT INTO ces1613_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","I řekl jemu Mojžíš: Když vyjdu ven z města, rozprostru ruce své k Hospodinu, a hřímání přestane, i krupobití více nebude, abys poznal, že Hospodinova jest země. ");
INSERT INTO ces1613_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ale vím, že ani ty, ani služebníci tvoji ještě se nebudete báti tváři Hospodina Boha. ");
INSERT INTO ces1613_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","I potlučen jest len a ječmen; nebo ječmen se byl vymetal, len také byl v hlávkách. ");
INSERT INTO ces1613_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ale pšenice a špalda nebyla ztlučena, nebo pozdní byla. ");
INSERT INTO ces1613_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Tedy Mojžíš vyšed od Faraona z města, rozprostřel ruce své k Hospodinu. I přestalo hřímání a krupobití, a ani déšť nelil se na zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Uzřev pak Farao, že přestal déšť a krupobití a hřímání, opět hřešil; a více obtížil srdce své, on i služebníci jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","I zsililo se srdce Faraonovo, a nepropustil synů Izraelských, tak jakž byl mluvil Hospodin skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","I řekl Hospodin Mojžíšovi: Vejdi k Faraonovi, ačkoli jsem já obtížil srdce jeho, a srdce služebníků jeho, abych učinil divy tyto své u prostřed nich; ");
INSERT INTO ces1613_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","A abys ty vypravoval v uši synů svých i vnuků svých, co jsem učinil v Egyptě, a znamení má, kteráž jsem prokázal na nich; abyste věděli, že já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","I všel Mojžíš s Aronem k Faraonovi, a řekli jemu: Takto praví Hospodin Bůh Hebrejský: Dokavadž nechceš se ponížiti přede mnou? Propusť lid můj, ať mi slouží. ");
INSERT INTO ces1613_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Pakli nechceš propustiti lidu mého, aj, já uvedu zítra kobylky na krajinu tvou. ");
INSERT INTO ces1613_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","A přikryjí svrchek země, aby jí nebylo viděti, a snědí ostatky pozůstalé, kteříž vám zanecháni jsou po krupobití; zhryzou vám také každý strom pučící se na poli. ");
INSERT INTO ces1613_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","A naplní domy tvé, i domy všech služebníků tvých, a domy všech Egyptských; čehož neviděli otcové tvoji a otcové otců tvých, od počátku bytu svého na zemi až do dne tohoto. A odvrátiv se, vyšel od Faraona. ");
INSERT INTO ces1613_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Řekli pak služebníci Faraonovi k němu: Dokavadž tento bude nám osídlem? Propusť ty muže, ať slouží Hospodinu Bohu svému. Zdaž ještě nevíš, že zkažen jest Egypt? ");
INSERT INTO ces1613_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","I zavolán jest Mojžíš s Aronem před Faraona. Jimž řekl: Jděte, služte Hospodinu Bohu svému. Kdo jsou ti, kteříž jíti mají? ");
INSERT INTO ces1613_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","A odpověděl Mojžíš: S dítkami i s starými našimi půjdeme, s syny i s dcerami našimi, s ovcemi a s větším dobytkem naším odejdeme; nebo slavnost Hospodinovu držeti máme. ");
INSERT INTO ces1613_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tedy řekl jim: Nechať jest tak Hospodin s vámi, jako já propustím vás i dítky vaše. Hleďte, nebo zlé jest před tváři vaší. ");
INSERT INTO ces1613_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nebudeť tak. Jděte vy sami muži, a služte Hospodinu, nebo toho vy toliko žádáte. I vyhnáni jsou od tváři Faraonovy. ");
INSERT INTO ces1613_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tedy řekl Hospodin Mojžíšovi: Vztáhni ruku svou na zemi Egyptskou pro kobylky, ať vystoupí na zemi Egyptskou, a sežerou všelikou bylinu země té, cožkoli zůstalo po krupobití. ");
INSERT INTO ces1613_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","I vztáhl Mojžíš hůl svou na zemi Egyptskou; a Hospodin uvedl vítr východní na zemi, aby vál celého toho dne a celou noc. A když bylo ráno, vítr východní přinesl kobylky. ");
INSERT INTO ces1613_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","A vystoupily kobylky na všecku zemi Egyptskou, a připadly na všecky končiny Egyptské nesčíslně. Před těmi nebylo takových kobylek, aniž po těch takové budou. ");
INSERT INTO ces1613_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","I přikryly veškeren svrchek země, tak že pro ně nebylo lze znáti země; a sežraly všelikou bylinu země, a všeliké ovoce na stromích, kteréž zůstalo po krupobití; a nepozůstalo nic zeleného na stromích a bylinách polních ve vší zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tedy Farao spěšně povolav Mojžíše s Aronem, řekl: Zhřešil jsem proti Hospodinu Bohu vašemu, i proti vám. ");
INSERT INTO ces1613_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ale nyní, odpusť, prosím, hřích můj aspoň tento, a modlte se Hospodinu Bohu vašemu, ať jen tuto smrt odejme ode mne. ");
INSERT INTO ces1613_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Protož vyšed Mojžíš od Faraona, modlil se Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","I obrátil Hospodin vítr západní tuhý velmi, kterýžto zachvátiv kobylky, uvrhl je do moře Rudého, tak že nezůstalo žádné kobylky ve vší krajině Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ale obtížil Hospodin srdce Faraonovo, a nepropustil synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","I řekl Hospodin Mojžíšovi: Vztáhni ruku svou k nebi, a bude tma na zemi Egyptské, a makati ji budou. ");
INSERT INTO ces1613_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","I vztáhl Mojžíš ruku svou k nebi, a byla tma přehustá po vší zemi Egyptské za tři dni. ");
INSERT INTO ces1613_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Aniž viděl jeden druhého, a aniž kdo vstal z místa svého za tři dni; ale synové Izraelští všickni měli světlo v příbytcích svých. ");
INSERT INTO ces1613_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Potom povolav Farao Mojžíše, řekl: Jděte, služte Hospodinu. Toliko ovce vaše a větší dobytek váš nechať zůstane, také dítky vaše půjdou s vámi. ");
INSERT INTO ces1613_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Odpověděl Mojžíš: Dáš také v ruce naše oběti a zápaly, kteréž bychom obětovali Hospodinu Bohu našemu. ");
INSERT INTO ces1613_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","A protož také dobytek náš půjde s námi, a nezůstane ani kopyta; nebo z nich vezmeme ku poctě Hospodinu Bohu našemu. My pak nevíme, čím sloužiti máme Hospodinu, dokudž nepřijdeme tam. ");
INSERT INTO ces1613_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Zatvrdil pak Hospodin srdce Faraonovo, tak že nechtěl propustiti jich. ");
INSERT INTO ces1613_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","I řekl mu Farao: Odejdi ode mne, a varuj se, abys více neviděl tváři mé; nebo v který den uzříš tvář mou, umřeš. ");
INSERT INTO ces1613_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Odpověděl Mojžíš: Dobře jsi řekl; neuzřímť více tváři tvé. ");
INSERT INTO ces1613_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Řekl pak byl Hospodin Mojžíšovi: Ještě ránu jednu uvedu na Faraona a na Egypt, potom propustí vás odsud; propustí docela, anobrž vypudí vás odsud. ");
INSERT INTO ces1613_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Mluv nyní v uši lidu, ať vypůjčí jeden každý od bližního svého, a každá od bližní své klínotů stříbrných a klínotů zlatých. ");
INSERT INTO ces1613_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","A dal Hospodin milost lidu před očima Egyptských. (Sám také Mojžíš veliký byl velmi v zemi Egyptské, před očima služebníků Faraonových i před očima lidu.) ");
INSERT INTO ces1613_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","I řekl Mojžíš: Takto praví Hospodin: O půlnoci já půjdu prostředkem Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","A pomře všecko prvorozené v zemi Egyptské, od prvorozeného Faraonova, jenž seděti měl na stolici jeho, až do prvorozeného děvky, kteráž jest při žernovu, i všecko prvorozené hovad. ");
INSERT INTO ces1613_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","I bude křik veliký po vší zemi Egyptské, jakéhož nebylo prvé, a jakéhož nikdy nebude více. ");
INSERT INTO ces1613_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","U synů pak Izraelských nikdež nehne pes jazykem svým, ovšem pak ani člověk ani hovado, abyste věděli, že rozdíl učinil Hospodin mezi Egyptskými a Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","I sstoupí všickni tito služebníci tvoji ke mně, a skláněti mi se budou, řkouce: Vyjdi, ty i všecken lid, kterýž jest pod správou tvou; a potom vyjdu. A vyšel od Faraona s velikým hněvem. ");
INSERT INTO ces1613_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","I řekl Hospodin Mojžíšovi: Neposlechneť vás Farao, abych rozmnožil zázraky své v zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ale Mojžíš a Aron činili všecky ty zázraky před Faraonem; Hospodin pak zatvrdil srdce Faraonovo, tak že nepropustil synů Izraelských z země své. ");
INSERT INTO ces1613_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mluvil pak Hospodin k Mojžíšovi a k Aronovi v zemi Egyptské, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Tento měsíc počátek měsíců vám bude; první vám bude mezi měsíci ročními. ");
INSERT INTO ces1613_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mluvte ke všemu shromáždění Izraelskému, řkouce: Desátého dne měsíce tohoto vezmete sobě jeden každý beránka po čeledech, beránka na každý dům. ");
INSERT INTO ces1613_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Byl-li by pak dům tak malý, že by s beránka býti nemohl, přivezme souseda svého, kterýž jest blízký domu jeho, podlé počtu duší; jeden každý počte tolik osob, kolikž by jich snísti mohlo beránka. ");
INSERT INTO ces1613_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Beránka bez vady, samce ročního míti budete, kteréhož z ovcí aneb z koz vezmete. ");
INSERT INTO ces1613_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","A chovati ho budete až do čtrnáctého dne měsíce tohoto; a zabije ho všecko množství shromáždění Izraelského k večerou. ");
INSERT INTO ces1613_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","A vezmouce krve, pomaží obou veřejí a nade dveřmi u domů, v nichž jej jísti budou. ");
INSERT INTO ces1613_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","I budou jísti noci té maso pečené ohněm, s chleby přesnými; s bylinami hořkými jísti jej budou. ");
INSERT INTO ces1613_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nebudete jísti z něho nic surového ani v vodě vařeného, ale pečené ohněm, s hlavou jeho i s nohami a droby. ");
INSERT INTO ces1613_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Nezanecháte z něho ničehož do jitra; pakli by co pozůstalo z něho až do jitra, ohněm spálíte. ");
INSERT INTO ces1613_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Takto jej pak jísti budete: Bedra svá přepásaná míti budete, obuv svou na nohách svých a hůl svou v ruce své, a jísti budete s chvátáním; nebo Jití jest Hospodinovo. ");
INSERT INTO ces1613_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","V tu noc zajisté půjdu po zemi Egyptské, a budu bíti všecko prvorozené v zemi Egyptské, od člověka až do hovada, a nade všemi bohy Egyptskými učiním soud: Já Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Krev pak ta na domích, v nichž budete, budeť vám na znamení; a když uzřím krev, pominu vás, a nebude mezi vámi rána zahubující, když bíti budu prvorozené v zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","A budeť vám den ten na památku, a slaviti jej budete slavný Hospodinu po rodech svých; právem věčným slaviti jej budete. ");
INSERT INTO ces1613_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Za sedm dní přesné chleby jísti budete, a hned prvního dne vyprázdníte kvas z domů vašich; nebo kdožkoli jedl by co kvašeného od prvního až do sedmého dne, vyhlazena bude duše ta z Izraele. ");
INSERT INTO ces1613_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A v den první budeť shromáždění svaté; dne také sedmého shromáždění svaté míti budete. Žádného díla nebude děláno v nich; toliko čehož se užívá k jídlu od každého, to samo připraveno bude od vás. ");
INSERT INTO ces1613_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","A ostříhati budete přesnic, nebo v ten den vyvedl jsem vojska vaše z země Egyptské; protož zachovávati budete den ten po rodech svých právem věčným. ");
INSERT INTO ces1613_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Prvního měsíce, čtrnáctého dne téhož měsíce, u večer jísti budete chleby přesné, až do dne jedenmecítmého téhož měsíce k večerou. ");
INSERT INTO ces1613_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Za sedm dní nebude nalezeno kvasu v domích vašich; nebo kdo by koli jedl něco kvašeného, vyhlazena bude duše ta z shromáždění Izraelského, tak příchozí jako zrozený v zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nic kvašeného jísti nebudete, ale ve všech příbytcích vašich jísti budete chleby přesné. ");
INSERT INTO ces1613_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Tedy svolal Mojžíš všecky starší Izraelské, a řekl jim: Vybeřte a vezměte sobě beránka po čeledech svých, a zabíte Fáze. ");
INSERT INTO ces1613_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Vezmete také svazček yzopu, a omočíte v krvi, kteráž bude v medenici, a pomažete nade dveřmi a na obou veřejích tou krví, kteráž bude v nádobě; z vás pak žádný nevycházej ze dveří domu svého až do jitra. ");
INSERT INTO ces1613_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Neboť půjde Hospodin, aby bil Egypt, a kde uzří krev nade dveřmi a na obou veřejích, přeskočí Hospodin ty dvéře, aniž dopustí zhoubci vjíti do domů vašich k hubení. ");
INSERT INTO ces1613_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Protož ostříhati budete věci této za ustanovení tobě i synům tvým až na věky. ");
INSERT INTO ces1613_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","A když vejdete do země, kterouž dá Hospodin vám, jakž zaslíbil, zachovávati budete službu tuto. ");
INSERT INTO ces1613_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Když by pak řekli vám synové vaši: Jaká jest to služba vaše? ");
INSERT INTO ces1613_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Tedy díte: Obět Fáze toto jest Hospodinu, kterýž pominul domů synů Izraelských v Egyptě, když bil Egypt, domy pak naše vysvobodil. A lid sklonivše hlavy, poklonu učinili. ");
INSERT INTO ces1613_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","A rozšedše se synové Izraelští, učinili, jakž byl Hospodin přikázal Mojžíšovi a Aronovi; tak a nejinak učinili. ");
INSERT INTO ces1613_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Stalo se pak o půlnoci, pobil Hospodin všecko prvorozené v zemi Egyptské, od prvorozeného Faraonova, kterýž seděti měl na stolici jeho, až do prvorozeného vězně, kterýž byl v žaláři, i všecko prvorozené hovad. ");
INSERT INTO ces1613_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tedy vstal Farao noci té, a všickni služebníci jeho i všickni Egyptští, a vzešel křik veliký v Egyptě; nebo žádného nebylo domu, v němž by nebylo něčeho mrtvého. ");
INSERT INTO ces1613_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","A povolav Mojžíše a Arona v noci, řekl: Vstaňte, vyjděte z prostředku lidu mého, i vy i synové Izraelští, a odejdouce, služte Hospodinu, jakž jste mluvili. ");
INSERT INTO ces1613_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ovce také vaše i voly vaše vezměte, jakž jste žádali, a jděte; a dejte mi také požehnání. ");
INSERT INTO ces1613_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","I nutkali Egyptští lid, aby co nejrychleji vyšli z země; nebo pravili: Všickni již teď zemřeme. ");
INSERT INTO ces1613_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Protož vzal lid těsto své, prvé než zkysalo, obaliv je v šaty své, na ramena svá. ");
INSERT INTO ces1613_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Učinili pak synové Izraelští podlé rozkazu Mojžíšova; nebo vyžádali byli od Egyptských klínotů stříbrných a zlatých, i šatů. ");
INSERT INTO ces1613_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","A Hospodin dal milost lidu před očima Egyptských, tak že půjčovali jim. I obloupili Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Tedy táhli synové Izraelští z Ramesses k Sochot, okolo šestkrát sto tisíc pěších, mužů toliko kromě dětí. ");
INSERT INTO ces1613_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ano také jiného lidu mnoho vyšlo s nimi, ovec také a volů, dobytka velmi mnoho. ");
INSERT INTO ces1613_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","I napekli z těsta, kteréž vynesli z Egypta, koláčů nekvašených; nebo ještě bylo nezkynulo, proto že vypuzeni byli z Egypta, a nemohli prodlévati, a ani pokrmů na cestu nepřipravili sobě. ");
INSERT INTO ces1613_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Èas pak bydlení synů Izraelských, kteříž byli v Egyptě, byl čtyři sta a třidceti let. ");
INSERT INTO ces1613_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","A když se vyplnilo čtyři sta a třidceti let, právě toho dne vyšla všecka vojska Hospodinova z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Noc tato pilně ostříhána býti má Hospodinu, v níž vyvedl je z země Egyptské; tať tedy noc Hospodinova ostříhána bude ode všech synů Izraelských po národech jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","I řekl Hospodin Mojžíšovi a Aronovi: Tentoť bude řád při slavnosti Fáze: Žádný cizozemec nebude jísti z něho. ");
INSERT INTO ces1613_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Každý pak služebník váš za stříbro koupený, když by obřezán byl, teprv jísti bude z něho. ");
INSERT INTO ces1613_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Příchozí a nájemník nebude jísti z něho. ");
INSERT INTO ces1613_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","V témž domě jísti jej budeš, nevyneseš z domu ven masa jeho; a kostí v něm nezlámete. ");
INSERT INTO ces1613_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Všecko shromáždění Izraelské tak s ním učiní. ");
INSERT INTO ces1613_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Jestliže by pak cizozemec bydlil s tebou pohostinu, a slaviti by chtěl Fáze Hospodinu, prvé obřezán bude každý pohlaví mužského; a tehdy přistoupí k slavení jeho, a bude jako tu v zemi zrozený; žádný pak neobřezaný nebude jísti z něho. ");
INSERT INTO ces1613_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Jednostejné právo bude tu zrodilému a příchozímu, kterýž jest pohostinu u prostřed vás. ");
INSERT INTO ces1613_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tedy učinili všickni synové Izraelští, jakž přikázal Hospodin Mojžíšovi a Aronovi; tak učinili. ");
INSERT INTO ces1613_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","A tak stalo se právě toho dne, že vyvedl Hospodin syny Izraelské z země Egyptské s vojsky jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Posvěť mi všeho prvorozeného, cožkoli otvírá každý život mezi syny Izraelskými, tak z lidí jako z hovad, nebo mé jest. ");
INSERT INTO ces1613_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Protož řekl Mojžíš lidu: Pamatujte na den tento, v kterémž jste vyšli z Egypta, z domu služby; nebo v silné ruce vyvedl vás odsud Hospodin, aniž kdo jez co kvašeného. ");
INSERT INTO ces1613_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Dnes vycházíte vy, měsíce Abib. ");
INSERT INTO ces1613_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Když tedy uvede tě Hospodin do země Kananejských, Hetejských, Amorejských, Hevejských a Jebuzejských, tak jakž přisáhl otcům tvým, a dá tobě zemi oplývající mlékem a strdí: tedy vykonávati budeš službu tuto v tento měsíc. ");
INSERT INTO ces1613_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Za sedm dní jísti budeš chleby přesné, dne pak sedmého slavnost bude Hospodinova. ");
INSERT INTO ces1613_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Přesní chlebové jedeni budou za dnů sedm, aniž spatříno bude u tebe co kvašeného, aniž se uhlédá u tebe kvas ve všech končinách tvých. ");
INSERT INTO ces1613_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","A vypravovati budeš synu svému v ten den, řka: Proto, což mi učinil Hospodin, když jsem vycházel z Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","A budeť tobě to jako nějaké znamení na ruce tvé, a jako památka před očima tvýma, aby zákon Hospodinův byl v ústech tvých; nebo v ruce silné vyvedl tě Hospodin z Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Protož zachovávati budeš ustanovení toto v čas jistý, rok po roce. ");
INSERT INTO ces1613_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","A když by tě uvedl Hospodin do země Kananejských, tak jakž přisáhl tobě a otcům tvým, a dal by ji tobě: ");
INSERT INTO ces1613_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Tedy všecko, což otvírá život, oddělíš Hospodinu, i každý plod hovada tvého otvírající život, což by koli bylo samců, Hospodinovo jest. ");
INSERT INTO ces1613_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Každé pak prvorozené osle vyplatíš hovádkem; pakli bys nevyplatil, zlom jemu šíji; každého také prvorozeného člověka mezi syny svými vyplatíš. ");
INSERT INTO ces1613_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","A když by se tebe vzeptal syn tvůj potom, a řekl: Co jest to? tedy povíš jemu: V ruce silné vyvedl nás Hospodin z Egypta, z domu služebnosti. ");
INSERT INTO ces1613_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Nebo když se byl zatvrdil Farao, a nechtěl nás propustiti, pobil Hospodin všecko prvorozené v zemi Egyptské, od prvorozeného z lidí, až do prvorozeného z hovad; i tou příčinou já obětuji Hospodinu všecky samce otvírající život, ale všecko prvorozené z synů svých vyplacuji. ");
INSERT INTO ces1613_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mějž to tedy jako znamení na ruce své, a jako náčelník mezi očima svýma, že v ruce silné vyvedl nás Hospodin z Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Stalo se pak, když pustil Farao lid, že nevedl jich Bůh cestou země Filistinské, ačkoli bližší byla; nebo řekl Bůh: Aby nepykal lid, když by uzřel, an válka nastává, a nevrátili se do Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ale obvedl Bůh lid cestou přes poušť, kteráž jest při moři Rudém. A vojensky zpořádaní vyšli synové Izraelští z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Vzal také Mojžíš kosti Jozefovy s sebou; nebo byl přísahou zavázal syny Izraelské, řka: Jistotně navštíví vás Bůh, protož vyneste odsud kosti mé s sebou. ");
INSERT INTO ces1613_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Vytáhše tedy z Sochot, položili se v Etam při kraji pouště. ");
INSERT INTO ces1613_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Hospodin pak předcházel je ve dne v sloupu oblakovém, aby je vedl cestou, v noci pak v sloupu ohnivém, aby svítil jim, aby ve dne i v noci jíti mohli. ");
INSERT INTO ces1613_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Neodjal sloupu oblakového ve dne, ani ohnivého sloupu v noci od tváři toho lidu. ");
INSERT INTO ces1613_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Mluv k synům Izraelským, ať navrátíce se, rozbijí stany před Fiarot, mezi Magdalem a mořem, proti Belsefon; naproti němu rozbijete stany při moři. ");
INSERT INTO ces1613_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","A dí Farao o synech Izraelských: Ssouženi jsou na zemi, sevřela je poušť. ");
INSERT INTO ces1613_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I zatvrdím srdce Faraonovo, a honiti je bude, a oslaven budu v Faraonovi a ve všem vojsku jeho; a zvědí Egyptští, že já jsem Hospodin. I učinili tak. ");
INSERT INTO ces1613_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Povědíno pak bylo králi Egyptskému, že by lid utíkal. I obráceno jest srdce Faraonovo a služebníků jeho proti lidu, a řekli: Co jsme to učinili, že jsme propustili Izraele, aby nesloužil nám? ");
INSERT INTO ces1613_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Protož zapřáhl do svého vozu, a lid svůj vzal s sebou. ");
INSERT INTO ces1613_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","A vzal šest set vozů vybraných, i všecky vozy Egyptské, nad nimiž nade všemi byli hejtmané. ");
INSERT INTO ces1613_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","I zatvrdil Hospodin srdce Faraona krále Egyptského, tak že honil syny Izraelské; synové pak Izraelští vyšli v ruce vyvýšené. ");
INSERT INTO ces1613_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","I honili je Egyptští, a postihli je, když se položili při moři, všickni vozové Faraonovi, a jezdci jeho i vojsko jeho podlé Fiarot, před Belsefon. ");
INSERT INTO ces1613_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","A když se přiblížil Farao, pozdvihli synové Izraelští očí svých, a aj, Egyptští táhnou za nimi. I báli se velmi, a volali synové Izraelští k Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","A řekli Mojžíšovi: Zdali proto, že nebylo hrobů v Egyptě, vyvedl jsi nás, abychom zemřeli na poušti? Co jsi nám to učinil, že jsi vyvedl nás z Egypta? ");
INSERT INTO ces1613_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Zdali jsme toho nemluvili tobě ještě v Egyptě, řkouce: Nech nás, ať sloužíme Egyptským? Nebo lépe bylo nám sloužiti Egyptským, než zemříti na poušti. ");
INSERT INTO ces1613_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","I řekl Mojžíš lidu: Nebojte se, stůjte a vizte spasení Hospodinovo, kteréž vám způsobí dnes; nebo Egyptských, kteréž jste viděli dnes, neuzříte nikdy více až na věky. ");
INSERT INTO ces1613_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hospodin bojovati bude za vás, a vy mlčeti budete. ");
INSERT INTO ces1613_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","I řekl Hospodin Mojžíšovi: Co voláš ke mně? Mluv synům Izraelským, ať jdou předce. ");
INSERT INTO ces1613_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ty pak zdvihni hůl svou, a vztáhni ruku svou na moře, a rozděl je; a nechať jdou synové Izraelští prostředkem moře po suše. ");
INSERT INTO ces1613_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Jáť pak, aj, já zatvrdím srdce Egyptských, a vejdou za nimi; i budu oslaven v Faraonovi, a ve všem vojsku jeho, v vozích jeho i v jezdcích jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","A zvědí Egyptští, že já jsem Hospodin, když oslaven budu v Faraonovi, v vozích jeho a v jezdcích jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","I bral se anděl Boží, kterýž byl prvé předcházel vojsko Izraelské, a šel z zadu za nimi; nebo hnul se sloup oblakový, kterýž byl před nimi, a stál z zadu za nimi. ");
INSERT INTO ces1613_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","A přišed mezi vojska Egyptských a vojska Izraelská, byl Egyptským oblakem a tmou, Izraelským pak osvěcoval noc, tak aby nepřiblížili se jedni k druhým přes celou noc. ");
INSERT INTO ces1613_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","I vztáhl Mojžíš ruku svou na moře, a Hospodin rozdělil moře větrem východním prudce vějícím přes celou noc; a učinil moře v suchost, když se rozstoupily vody. ");
INSERT INTO ces1613_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Tedy šli synové Izraelští prostředkem moře po suše, a vody jim byly jako zed po pravé i po levé straně. ");
INSERT INTO ces1613_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","A honíce je Egyptští, vešli za nimi do prostřed moře, všecka jízda Faraonova, vozové i jízdní jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Stalo se pak v bdění jitřním, že pohleděl Hospodin na vojska Egyptských z sloupu ohně a oblaku, a zmátl vojsko Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A odjal kola vozů jejich, aby je těžce táhli. I řekli Egyptští: Utecme před Izraelem, nebo Hospodin bojuje za ně proti Egyptským. ");
INSERT INTO ces1613_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tedy řekl Hospodin Mojžíšovi: Vztáhni ruku svou na moře, ať se zase vrátí vody na Egyptské, na vozy jejich a na jezdce jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","I vztáhl Mojžíš ruku svou na moře, a navrátilo se moře ráno k moci své, a Egyptští utíkali proti němu; a vrazil Hospodin Egyptské do prostřed moře. ");
INSERT INTO ces1613_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","A navrátivše se vody, zatopily vozy i jezdce se vším vojskem Faraonovým, což jich koli vešlo za nimi do moře, tak že nezůstal z nich ani jeden. ");
INSERT INTO ces1613_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ale synové Izraelští šli po suchu prostředkem moře, a vody jim byly místo zdi po pravé i po levé straně. ");
INSERT INTO ces1613_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","A tak vysvobodil Hospodin v ten den Izraele z ruky Egyptských; a viděl Izrael Egyptské mrtvé na břehu mořském. ");
INSERT INTO ces1613_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Viděl také Izrael moc velikou, kterouž prokázal Hospodin na Egyptských. I bál se lid Hospodina, a věřili Hospodinu i Mojžíšovi, služebníku jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tehdy zpíval Mojžíš a synové Izraelští píseň tuto Hospodinu, a řekli takto: Zpívati budu Hospodinu, neboť jest slavně zveleben; koně i s jezdcem uvrhl do moře. ");
INSERT INTO ces1613_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Síla má a píseň jest Hospodin, nebo vysvobodil mne. Onť jest Bůh můj silný, protož stánek vzdělám jemu; onť jest Bůh otce mého, protož vyvyšovati ho budu. ");
INSERT INTO ces1613_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hospodin jest udatný bojovník, Hospodin jméno jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Vozy Faraonovy i vojsko jeho uvrhl do moře; a nejpřednější hejtmané jeho ztopeni jsou v moři Rudém. ");
INSERT INTO ces1613_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Propasti přikryly je; vpadli do hlubiny jako kámen. ");
INSERT INTO ces1613_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Pravice tvá, Hospodine, zvelebena jest v síle, pravice tvá, ó Hospodine, potřela nepřítele. ");
INSERT INTO ces1613_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","A ve mnohé vyvýšenosti své podvrátil jsi povstávající proti tobě; pustils hněv svůj, kterýžto sežral je jako strniště. ");
INSERT INTO ces1613_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","A duchem chřípí tvých shromážděny jsou vody, stály tekuté vody jako hromada, ssedly se propasti u prostřed moře. ");
INSERT INTO ces1613_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Řekl nepřítel: Honiti budu, dohoním se, budu děliti loupeže, nasytí se jimi duše má, vytrhnu meč svůj, zahladí je ruka má. ");
INSERT INTO ces1613_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Povanul jsi větrem svým, i přikrylo je moře; pohlceni jsou jako olovo v prudkých vodách. ");
INSERT INTO ces1613_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kdo podobný tobě mezi silnými, ó Hospodine? Kdo jest tak, jako ty, velebný v svatosti, hrozný v chvalách, činící divy? ");
INSERT INTO ces1613_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Vztáhls pravici svou, i požřela je země. ");
INSERT INTO ces1613_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Zprovodíš v milosrdenství svém lid tento, kterýž jsi vykoupil; laskavě povedeš jej v síle své k příbytku svatosti své. ");
INSERT INTO ces1613_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Uslyší lidé, bouřiti se budou; bolest zachvátí obyvatele Filistinské. ");
INSERT INTO ces1613_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tedy zkormoucena budou knížata Idumejská, silné Moábské podejme strach, rozplynou se všickni obyvatelé Kananejští. ");
INSERT INTO ces1613_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Připadne na ně strach a lekání, pro velikost ramene tvého; mlčeti budou jako kámen, dokudž nepřejde lid tvůj, ó Hospodine, dokudž nepřejde lid ten, kteréhožs sobě dobyl. ");
INSERT INTO ces1613_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Uvedeš je, a štípíš je na hoře dědictví svého, na místě, kteréž jsi k příbytku svému připravil, Hospodine, v svatyni, kterouž utvrdí ruce tvé, Pane. ");
INSERT INTO ces1613_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Hospodin kralovati bude na věky věků. ");
INSERT INTO ces1613_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Nebo vešli koni Faraonovi s vozy jeho i s jezdci jeho do moře, a obrátil na ně Hospodin vody mořské, synové pak Izraelští šli po suše u prostřed moře. ");
INSERT INTO ces1613_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","I vzala Maria prorokyně, sestra Aronova, buben v ruku svou, a vyšly za ní všecky ženy s bubny a s píšťalami. ");
INSERT INTO ces1613_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","I odpovídala jim Maria: Zpívejte Hospodinu, poněvadž slavně zveleben jest; koně i s jezdcem uvrhl do moře. ");
INSERT INTO ces1613_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hnul pak Mojžíš lidem Izraelským od moře Rudého, a táhli na poušť Sur. I šli tři dni po poušti, a nenalezli vod. ");
INSERT INTO ces1613_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","A přišedše do Marah, nemohli píti vod z Marah, nebo byly hořké; protož nazváno jest jméno jeho Marah. ");
INSERT INTO ces1613_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Z té příčiny reptal lid na Mojžíše, řka: Co budeme píti? ");
INSERT INTO ces1613_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","I volal k Hospodinu, a ukázal mu Hospodin dřevo, kteréž jakž uvrhl do vod, učiněny jsou sladké vody. Tu vydal jemu práva a soudy, a tu ho zkusil. ");
INSERT INTO ces1613_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","A řekl: Jestliže skutečně poslouchati budeš hlasu Hospodina Boha svého, a činiti budeš, což spravedlivého jest před očima jeho, a nakloníš uší k přikázaním jeho, a ostříhati budeš všech ustavení jeho: žádné nemoci, kterouž jsem dopustil na Egypt, nedopustím na tebe; nebo já jsem Hospodin, kterýž tě uzdravuji. ");
INSERT INTO ces1613_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","I přišli do Elim, kdež bylo dvanácte studnic vod a sedmdesáte palm; i rozbili tu stany při vodách. ");
INSERT INTO ces1613_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Když se pak hnuli z Elim, přišlo všecko množství synů Izraelských na poušť Sin, kteráž jest mezi Elim a Sinai, v patnáctý den druhého měsíce po vyjití z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","I reptalo všecko shromáždění synů Izraelských proti Mojžíšovi a proti Aronovi na poušti. ");
INSERT INTO ces1613_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","A mluvili jim synové Izraelští: Ó bychom byli zemřeli od ruky Hospodinovy v zemi Egyptské, když jsme sedávali nad hrnci masa, když jsme se najídali chleba do sytosti! A teď vyvedli jste nás na tuto poušť, abyste zmořili všecko shromáždění toto hladem. ");
INSERT INTO ces1613_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","I řekl Hospodin Mojžíšovi: Aj, já dám vám chleba s nebe jako déšť, a vycházeti bude lid a sbírati, což by postačilo na každý den, abych ho zkusil, bude-li choditi v zákoně mém, či nebude. ");
INSERT INTO ces1613_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","V den pak šestý přistrojí sobě to, co přinesou; a bude toho dvakrát více, než toho, což sbírati mají na každý den. ");
INSERT INTO ces1613_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Tedy mluvil Mojžíš a Aron všechněm synům Izraelským: U večer poznáte, že Hospodin vyvedl vás z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","A ráno uzříte slávu Hospodinovu; neboť jest slyšel reptání vaše proti Hospodinu. My zajisté co jsme, že repcete proti nám? ");
INSERT INTO ces1613_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mluvil dále Mojžíš: Z toho, pravím, poznáte, když vám dá Hospodin u večer masa, abyste se najedli, a chleba ráno do sytosti, poněvadž slyšel Hospodin reptání vaše, jimiž jste na něj reptali. Nebo my co jsme? Ne proti námť jsou reptání vaše, ale proti Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","I řekl Mojžíš Aronovi: Mluv ke všemu shromáždění synů Izraelských: Přistuptež před oblíčej Hospodinův; neboť jest slyšel reptání vaše. ");
INSERT INTO ces1613_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Stalo se pak, když mluvil Aron ke všemu shromáždění synů Izraelských, že se obrátili tváří k poušti, a aj, sláva Hospodinova ukázala se v oblaku. ");
INSERT INTO ces1613_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","(A již byl mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Slyšelť jsem reptání synů Izraelských. Mluviž jim a pověz: K večerou jísti budete maso, a ráno chlebem nasyceni budete, abyste poznali, že já jsem Hospodin Bůh váš.) ");
INSERT INTO ces1613_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Tedy stalo se u večer, že přiletěly křepelky a přikryly tábor; ráno pak spadla rosa okolo táboru. ");
INSERT INTO ces1613_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","A když přestalo padání rosy, aj, ukázalo se po vrchu pouště drobného cosi a okrouhlého, drobného jako jíní na zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Což vidouce synové Izraelští, řekli jeden druhému: Man jest toto. Nebo nevěděli, co by bylo. Tedy řekl jim Mojžíš: To jest ten chléb, kterýž vám dal Hospodin ku pokrmu. ");
INSERT INTO ces1613_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","To jest, o čemž přikázal Hospodin: Nasbírejte sobě toho každý k svému pokrmu; gomer na jednoho člověka vedlé počtu osob vašich, každý na ty, kteříž jsou v stanu jeho, vezmete. ");
INSERT INTO ces1613_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","I učinili tak synové Izraelští, a nasbírali jiní více, jiní méně. ");
INSERT INTO ces1613_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Potom měřili na gomer. A nezbylo tomu, kdo nasbíral mnoho, a ten, kdo nasbíral málo, neměl nedostatku; ale každý, což mohl snísti, nasbíral. ");
INSERT INTO ces1613_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","I řekl jim Mojžíš: Žádný ať nic z toho nepozůstavuje k jitru. ");
INSERT INTO ces1613_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ale neuposlechli Mojžíše. Nebo někteří zanechali díl z toho až do jitra; i zčervivělo a zsmradilo se. Pročež rozhněval se na ně Mojžíš. ");
INSERT INTO ces1613_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tak tedy sbírali to každého jitra, každý což snísti mohl. A když horké bylo slunce, tedy se ta manna rozpouštěla. ");
INSERT INTO ces1613_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Když pak bylo v den šestý, nasbírali toho chleba dvojnásobně, po dvou gomer na každého; protož přišla všecka knížata toho shromáždění, a pověděli Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kterýžto řekl jim: Toť jest, což mluvil Hospodin: Odpočinutí soboty svaté Hospodinu bude zítra. Což byste měli péci, pecte, a což byste vařiti měli, vařte dnes; což pak koli zbude, nechte sobě a schovejte to k jitru. ");
INSERT INTO ces1613_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Protož schovali to do rána, jakž přikázal Mojžíš; a nezsmradilo se, ani v něm červů nebylo. ");
INSERT INTO ces1613_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","I řekl Mojžíš: Jeztež to dnes, poněvadž sobota jest dnes Hospodinu; dnes toho nenaleznete na poli. ");
INSERT INTO ces1613_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Po šest dní budete to sbírávati, den pak sedmý sobota jest; nebude bývati manny v ní. ");
INSERT INTO ces1613_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Stalo se pak dne sedmého, že vyšli někteří z lidu sbírat, a nenašli. ");
INSERT INTO ces1613_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Tedy řekl Hospodin Mojžíšovi: I dokudž zpěčovati se budete přikázaní mých ostříhati a zákonů mých? ");
INSERT INTO ces1613_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Viztež, žeť Hospodin vám dal sobotu, a proto on vám dává v den šestý chleba na dva dni. Zůstaňte každý v svém, aniž kdo vycházej z místa svého v den sedmý. ");
INSERT INTO ces1613_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","I odpočinul lid v den sedmý. ");
INSERT INTO ces1613_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Nazval pak lid Izraelský jméno toho chleba man; kterýž byl jako símě koliandrové, a bílý, a chut jeho jako koláče s medem. ");
INSERT INTO ces1613_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Řekl také Mojžíš: Toť jest, což přikázal Hospodin: Naplň gomer tou mannou, aby chována byla na budoucí věky vaše, aby viděli pokrm, kterýž jsem vám dával jísti na poušti, když jsem vás vyvedl z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","I řekl Mojžíš Aronovi: Vezmi jedno věderce, a vsyp do něho plné gomer manny; a nech jí před tváří Hospodinovou, aby chována byla na budoucí věky vaše. ");
INSERT INTO ces1613_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","A protož jakž byl přikázal Hospodin Mojžíšovi, nechal jí Aron před svědectvím, aby tu chována byla. ");
INSERT INTO ces1613_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Jedli pak synové Izraelští mannu za čtyřidceti let, dokudž nevešli do země, v níž bydliti měli; mannu jedli, dokudž nepřišli k končinám země Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Gomer pak jest desátý díl efi. ");
INSERT INTO ces1613_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Tedy když se odebralo všecko shromáždění synů Izraelských z pouště Sin, po stanovištích svých vedlé rozkazu Hospodinova, položili se v Rafidim, kdež nebylo vod, kteréž by lid píti mohl. ");
INSERT INTO ces1613_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Protož domlouval se lid na Mojžíše, pravě: Dejte nám vody, abychom pili. Jimž odpověděl Mojžíš: Proč se na mne domlouváte? Proč pokoušíte Hospodina? ");
INSERT INTO ces1613_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","I žíznil tu lid pro nedostatek vod, a reptal na Mojžíše a mluvil: Proč jsi vyvedl nás z Egypta, abys mne s syny i dobytky mými žízní zmořil? ");
INSERT INTO ces1613_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tedy volal Mojžíš k Hospodinu, řka: Což mám činiti s tím lidem? Však již tudíž ukamenují mne. ");
INSERT INTO ces1613_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","I řekl Hospodin Mojžíšovi: Jdiž před lidem, pojma s sebou některé z starších Izraelských; hůl také svou kterouž jsi udeřil v vodu, vezmi do ruky své a jdi. ");
INSERT INTO ces1613_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Aj, já státi budu před tebou tam na skále, na Orébě; i udeříš v skálu, a vyjdou z ní vody, kteréž bude píti lid. I učinil tak Mojžíš před očima starších Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","A dal jméno místu tomu Massah a Meribah, pro reptání synů Izraelských, a že pokoušeli Hospodina, řkouce: Jest-li Hospodin u prostřed nás, či není? ");
INSERT INTO ces1613_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Přitáhl pak Amalech, a bojoval s Izraelem v Rafidim. ");
INSERT INTO ces1613_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","I řekl Mojžíš k Jozue: Vybeř nám některé muže, a vytáhna, bojuj s Amalechem; já zítra státi budu na vrchu hory, a hůl Boží v ruce své míti budu. ");
INSERT INTO ces1613_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tedy Jozue udělal tak, jakž mu poručil Mojžíš, a bojoval s Amalechem; Mojžíš pak, Aron a Hur vstoupili na vrch hory. ");
INSERT INTO ces1613_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","A dokudž Mojžíš vzhůru držel ruce své, vítězil Izrael; ale jakž opouštěl ruku svou, přemáhal Amalech. ");
INSERT INTO ces1613_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ale že ruce Mojžíšovy byly obtíženy, protož vzavše kámen, podložili pod něho, a on sedl na něm; Aron pak a Hur podpírali ruce jeho, jeden z jedné, druhý z druhé strany. I byly obě ruce jeho vztažené až do západu slunce. ");
INSERT INTO ces1613_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","A tak porazil Jozue Amalecha i lid jeho mečem. ");
INSERT INTO ces1613_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Mluvil potom Hospodin k Mojžíšovi: Vpiš to do knih na památku, a pilně to vkládej v uši Jozue, že do konce vyhladím památku Amalechovu všudy pod nebem. ");
INSERT INTO ces1613_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Tedy vzdělal Mojžíš oltář a nazval jméno jeho: Hospodin korouhev má. ");
INSERT INTO ces1613_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Nebo řekl: Tak má jmenován býti, proto že ruka nad trůnem Hospodinovým osvědčuje boj Hospodinův proti Amalechovi od národu až do národu. ");
INSERT INTO ces1613_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Uslyšel pak Jetro, kníže Madianské, test Mojžíšův, o všech věcech, kteréž učinil Bůh Mojžíšovi a Izraelovi, lidu svému, že vyvedl Hospodin Izraele z Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","A vzal Jetro, test Mojžíšův, Zeforu manželku Mojžíšovu, kterouž byl odeslal, ");
INSERT INTO ces1613_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","A dva syny její, z nichž jméno jednoho Gerson; nebo řekl: Příchozí jsem byl v zemi cizí; ");
INSERT INTO ces1613_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Jméno pak druhého Eliezer; nebo řekl: Bůh otce mého spomocník můj byl, a vytrhl mne od meče Faraonova. ");
INSERT INTO ces1613_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","I přišel Jetro, test Mojžíšův, s syny jeho i s ženou jeho k Mojžíšovi na poušť, kdež se byl položil při hoře Boží. ");
INSERT INTO ces1613_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","A vzkázal Mojžíšovi: Já, test tvůj Jetro, jdu k tobě, i žena tvá a oba synové její s ní. ");
INSERT INTO ces1613_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","I vyšel Mojžíš proti testi svému, a pokloniv se, políbil ho. I ptal se jeden druhého, jak se má; potom vešli do stanu. ");
INSERT INTO ces1613_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","A vypravoval Mojžíš testi svému všecko, což učinil Hospodin Faraonovi a Egyptským pro Izraele, a o všech nevolech, kteréž přicházely na ně na cestě, a jak je vysvobodil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","I radoval se Jetro ze všeho dobrého, což učinil Hospodin Izraelovi, a že vytrhl jej z ruky Egyptských. ");
INSERT INTO ces1613_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","A řekl Jetro: Požehnaný Hospodin, kterýž vytrhl vás z ruky Egyptských a z ruky Faraonovy, kterýž vytrhl ten lid z poroby Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nyní jsem poznal, že větší jest Hospodin nade všecky bohy; nebo touž věcí, kterouž se vyvyšovali, on je převýšil. ");
INSERT INTO ces1613_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","A vzal Jetro, test Mojžíšův, zápal a oběti, kteréž obětoval Bohu. Potom přišel Aron a všickni starší Izraelští, aby jedli chléb s tchánem Mojžíšovým před Bohem. ");
INSERT INTO ces1613_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nazejtří pak posadil se Mojžíš, aby soudil lid; a stál lid před Mojžíšem od jitra až do večera. ");
INSERT INTO ces1613_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Vida pak test Mojžíšův všecku práci jeho při lidu, řekl: Co jest to, což děláš s lidem? Proč ty sám sedíš, a všecken lid stojí před tebou od jitra až do večera? ");
INSERT INTO ces1613_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Odpověděl Mojžíš tchánu svému: Přichází ke mně lid raditi se s Bohem. ");
INSERT INTO ces1613_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Když mají o nějakou věc činiti, přicházejí ke mně, a soud činím mezi stranami, a oznamuji rady Boží a ustanovení jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","I řekl jemu test Mojžíšův: Nedobře děláš. ");
INSERT INTO ces1613_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tudíž tak ustaneš i ty i lid, kterýž s tebou jest. Nad možnost tvou těžká jest tato věc, nebudeš jí moci sám dosti učiniti. ");
INSERT INTO ces1613_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Protož nyní uposlechni řeči mé; poradím tobě, a bude Bůh s tebou. Stůj ty za lid před Bohem, a donášej věci nesnadné k Bohu. ");
INSERT INTO ces1613_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","A vysvětluj jim řády a zákony, a oznamuj jim cestu, po níž by šli, a co by dělati měli. ");
INSERT INTO ces1613_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Vyhledej také ze všeho lidu muže statečné, bohabojné, muže pravdomluvné, kteříž v nenávisti mají lakomství, a ustanov z nich knížata nad tisíci, setníky, padesátníky a desátníky. ");
INSERT INTO ces1613_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Oni ať soudí lid každého času. Což bude většího, vznesou na tebe, a menší pře sami nechť soudí; a tak lehčeji bude tobě, když jiní ponesou břímě s tebou. ");
INSERT INTO ces1613_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Jestliže to učiníš a rozkážeť Bůh, budeš moci trvati; také i všecken lid tento navracovati se bude k místům svým pokojně. ");
INSERT INTO ces1613_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Tedy uposlechl Mojžíš řeči tchána svého, a učinil všecko, což on řekl. ");
INSERT INTO ces1613_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","A vybral Mojžíš muže statečné ze všeho Izraele, a ustanovil je hejtmany nad lidem, knížata nad tisíci, setníky, padesátníky a desátníky, ");
INSERT INTO ces1613_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Kteříž soudili lid každého času. Nesnadnější věci vznášeli na Mojžíše, všecky pak menší pře sami soudili. ");
INSERT INTO ces1613_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Potom propustil Mojžíš tchána svého; i odšel do země své. ");
INSERT INTO ces1613_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Měsíce třetího po vyjití synů Izraelských z země Egyptské, v ten den přišli na poušť Sinai. ");
INSERT INTO ces1613_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Nebo hnuvše se z Rafidim, přišli až na poušť Sinai a položili se na té poušti; a tu rozbili Izraelští stany naproti hoře. ");
INSERT INTO ces1613_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mojžíš pak vstoupil k Bohu. A mluvil hlasem k němu Hospodin s té hory, řka: Takto díš domu Jákobovu, a oznámíš synům Izraelským: ");
INSERT INTO ces1613_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Sami jste viděli, co jsem učinil Egyptským, a jak jsem vás nesl na křídlách orličích, a přivedl jsem vás k sobě. ");
INSERT INTO ces1613_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Protož nyní, jestliže skutečně poslouchati budete hlasu mého, a ostříhati smlouvy mé, budete mi lid zvláštní mimo všecky lidi, ačkoli má jest všecka země. ");
INSERT INTO ces1613_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","A vy budete mi království kněžské a národ svatý. Tať jsou slova, kteráž mluviti budeš synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Protož přišel Mojžíš a svolav starší lidu, předložil jim všecka slova ta, kteráž mu přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Odpověděl pak všecken lid společně, a řekl: Cožkoli mluvil Hospodin, budeme činiti. A oznámil zas Mojžíš Hospodinu slova lidu. ");
INSERT INTO ces1613_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","I řekl Hospodin Mojžíšovi: Aj, já půjdu k tobě v hustém oblaku, aby slyšel lid, když mluviti budu s tebou, ano také, aby tobě věřil na věky. Nebo byl oznámil Mojžíš Hospodinu slova lidu. ");
INSERT INTO ces1613_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Řekl dále Hospodin Mojžíšovi: Jdi k lidu, a posvěť jich dnes a zítra; a nechť svá roucha zeperou. ");
INSERT INTO ces1613_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","A ať jsou hotovi ke dni třetímu, nebo v den třetí sstoupí Hospodin před očima všeho lidu na horu Sinai. ");
INSERT INTO ces1613_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Uložíš pak lidu meze všudy vůkol a povíš: Varujte se, abyste nevstupovali na horu, ani nedotýkali se krajů jejích. Kdož by se koli dotkl hory, smrtí umře. ");
INSERT INTO ces1613_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nedotkneť se ho ruka, ale ukamenován neb zastřelen bude; buď že by hovado bylo, buď člověk, nebudeť živ. Když se zdlouha troubiti bude, teprv oni vstoupí na horu. ");
INSERT INTO ces1613_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Sstoupiv tedy Mojžíš s hůry k lidu, posvětil ho; a oni zeprali roucha svá. ");
INSERT INTO ces1613_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","I mluvil k lidu: Buďtež hotovi ke dni třetímu; nepřistupujte k manželkám svým. ");
INSERT INTO ces1613_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","I stalo se dne třetího, když bylo ráno, že bylo hřímání s blýskáním a oblak hustý na té hoře, zvuk také trouby velmi tuhý, až se zhrozil všecken lid, kterýž byl v ležení. ");
INSERT INTO ces1613_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Tedy Mojžíš vyvedl lid z ležení vstříc Bohu; a lid stál dole pod horou. ");
INSERT INTO ces1613_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Hora pak Sinai všecka se kouřila, proto že sstoupil na ni Hospodin v ohni, a vystupoval dým její jako dým z vápenice, a třásla se všecka hora velmi hrubě. ");
INSERT INTO ces1613_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Zvuk také trouby více se rozmáhal, a silil se náramně. Mojžíš mluvil, a Bůh mu odpovídal hlasem. ");
INSERT INTO ces1613_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Sstoupil pak Hospodin na horu Sinai, na vrch hory; a když povolal Hospodin Mojžíše na vrch hory, vstoupil Mojžíš. ");
INSERT INTO ces1613_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","I řekl Hospodin Mojžíšovi: Sstup, osvědč lidu, ať se nevytrhují k Hospodinu, chtějíce ho viděti, aby nepadlo jich množství; ");
INSERT INTO ces1613_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Nýbrž ani sami kněží, kteříž, majíce přistupovati k Hospodinu, posvěcují se, aby se neobořil na ně Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mojžíš pak řekl Hospodinu: Nebudeť moci lid vstoupiti na horu Sinai, poněvadž jsi ty osvědčil nám, řka: Obmez horu a posvěť ji. ");
INSERT INTO ces1613_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","I řekl jemu Hospodin: Jdi, sstup, a potom vstup ty a Aron s tebou. Kněží pak a lid ať se nepokoušejí vstoupiti k Hospodinu, aby se na ně neobořil. ");
INSERT INTO ces1613_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","I sešel Mojžíš k lidu, a to jim oznámil. ");
INSERT INTO ces1613_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","I mluvil Bůh všecka slova tato, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Já jsem Hospodin Bůh tvůj, kterýž jsem tě vyvedl z země Egyptské, z domu služby. ");
INSERT INTO ces1613_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nebudeš míti bohů jiných přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Neučiníš sobě rytiny, ani jakého podobenství těch věcí, kteréž jsou na nebi svrchu, ani těch, kteréž na zemi dole, ani těch, kteréž u vodách pod zemí. ");
INSERT INTO ces1613_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Nebudeš se jim klaněti, ani jich ctíti. Nebo já jsem Hospodin Bůh tvůj, Bůh silný, horlivý, navštěvující nepravost otců na synech do třetího i čtvrtého pokolení těch, kteříž nenávidí mne, ");
INSERT INTO ces1613_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","A činící milosrdenství nad tisíci těmi, kteříž mne milují, a ostříhají přikázaní mých. ");
INSERT INTO ces1613_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nevezmeš jména Hospodina Boha svého nadarmo; neboť nenechá bez pomsty Hospodin toho, kdož by bral jméno jeho nadarmo. ");
INSERT INTO ces1613_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Pomni na den sobotní, abys jej světil. ");
INSERT INTO ces1613_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Šest dní pracovati budeš, a dělati všeliké dílo své; ");
INSERT INTO ces1613_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ale dne sedmého odpočinutí jest Hospodina Boha tvého. Nebudeš dělati žádného díla, ty i syn tvůj i dcera tvá, služebník tvůj i děvka tvá, hovado tvé i příchozí, kterýž jest v branách tvých. ");
INSERT INTO ces1613_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nebo v šesti dnech učinil Hospodin nebe a zemi, moře a všecko, což v nich jest, a odpočinul dne sedmého; protož požehnal Hospodin dne sobotního, a posvětil ho. ");
INSERT INTO ces1613_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Cti otce svého i matku svou, ať se prodlejí dnové tvoji na zemi, kterouž Hospodin Bůh tvůj dá tobě. ");
INSERT INTO ces1613_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Nezabiješ. ");
INSERT INTO ces1613_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nesesmilníš. ");
INSERT INTO ces1613_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Nepokradeš. ");
INSERT INTO ces1613_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Nepromluvíš proti bližnímu svému křivého svědectví. ");
INSERT INTO ces1613_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Nepožádáš domu bližního svého, aniž požádáš manželky bližního svého, ani služebníka jeho, ani děvky jeho, ani vola jeho, ani osla jeho, ani cožkoli jest bližního tvého. ");
INSERT INTO ces1613_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Veškeren pak lid viděl hřímání to a blýskání, a zvuk trouby, a horu kouřící se. To když viděl lid, pohnuli se a stáli zdaleka. ");
INSERT INTO ces1613_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","A řekli Mojžíšovi: Mluv ty s námi, a poslouchati budeme; a nechť nemluví s námi Bůh, abychom nezemřeli. ");
INSERT INTO ces1613_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Odpověděl Mojžíš lidu: Nebojte se; nebo pro zkušení vás sám Bůh přišel, aby bázeň jeho byla mezi vámi, abyste nehřešili. ");
INSERT INTO ces1613_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tedy stál lid zdaleka; Mojžíš pak přistoupil k mrákotě, kdež byl Bůh. ");
INSERT INTO ces1613_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","I řekl Hospodin Mojžíšovi: Tak povíš synům Izraelským: Vy jste sami viděli, že s nebe mluvil jsem s vámi. ");
INSERT INTO ces1613_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Protož nevyzdvihujte ničehož ku poctě se mnou; bohů stříbrných a bohů zlatých neučiníte sobě. ");
INSERT INTO ces1613_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Oltář z země uděláš mi a obětovati budeš na něm zápaly své, a pokojné oběti své, ovce své a voly své. Na kterémkoli místě rozkáži slaviti památku jména svého, přijdu k tobě a požehnám tobě. ");
INSERT INTO ces1613_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Jestliže mi pak vzděláš oltář kamenný, nedělej ho z kamene tesaného; nebo jestliže pozdvihneš železa na něj, poškvrníš ho. ");
INSERT INTO ces1613_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Aniž po stupních vstupovati budeš k oltáři mému, aby hanba tvá u něho odkryta nebyla. ");
INSERT INTO ces1613_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Tito jsou pak soudové, kteréž jim předložíš: ");
INSERT INTO ces1613_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Jestliže koupíš k službě Žida, šest let sloužiti bude, a sedmého odejde svobodný darmo. ");
INSERT INTO ces1613_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Přišel-li by sám toliko, sám také odejde; pakli měl ženu, vyjde s ním i žena jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Jestliže pán jeho dá mu ženu, a ona zrodí jemu syny neb dcery: žena ta i děti její budou pána jeho, on pak sám toliko odejde. ");
INSERT INTO ces1613_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pakli by řekl služebník: Miluji pána svého, manželku svou a syny své, nevyjdu svobodný: ");
INSERT INTO ces1613_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Tedy postaví ho pán jeho před soudci, a přivede ho ke dveřím neb k veřeji, a probodne pán jeho ucho jemu špicí; i zůstaneť služebníkem jeho na věky. ");
INSERT INTO ces1613_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Když by pak prodal někdo dceru svou, aby byla děvkou, nevyjdeť tak, jako vycházejí služebníci. ");
INSERT INTO ces1613_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Nelíbila-li by se pánu svému, kterýž jí sobě ještě nezasnoubil, dopustí ji vyplatiti. Lidu cizímu nebude míti práva prodati ji, poněvadž zhřešil proti ní. ");
INSERT INTO ces1613_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Pakli by synu svému ji zasnoubil, učiníť jí tak, jakž obyčej jest činiti dcerám. ");
INSERT INTO ces1613_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","A dal-li by mu jinou, z stravy její, oděvu jejího, a přívětivosti manželské nic této neujme. ");
INSERT INTO ces1613_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Neudělal-li by nic z toho trojího, vyjde darmo bez stříbra. ");
INSERT INTO ces1613_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kdo by ubil člověka, až by od toho umřel, smrtí umře. ");
INSERT INTO ces1613_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Když by pak neukládal o bezživotí jeho, než Bůh dal by jej v ruce jeho: tedy uložím tobě místo, do něhož by takový mohl uteci. ");
INSERT INTO ces1613_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pakli by kdo tak pyšně sobě počínal proti bližnímu svému, že by ho lstivě zabil, i od oltáře mého odtrhneš jej, aby umřel. ");
INSERT INTO ces1613_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Kdo by otce svého neb matku svou bil, smrtí ať umře. ");
INSERT INTO ces1613_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Kdo by pak, ukradna někoho, prodal jej, a nalezen by byl v ruce jeho, smrtí ať umře. ");
INSERT INTO ces1613_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","I ten, kdož by zlořečil otci svému neb mateři své, smrtí ať umře. ");
INSERT INTO ces1613_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Když by se svadili muži, a urazil by který bližního svého kamenem neb pěstí, a ten by neumřel, než složil se na lůži; ");
INSERT INTO ces1613_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","A potom by povstal a chodil vně o holi své: již nebude vinen ten, kdož urazil; toliko co zatím obmeškal, to jemu nahradí, a na vyhojení jeho naloží. ");
INSERT INTO ces1613_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Když by pak ubil kdo služebníka svého neb děvku svou kyjem, tak že by umřel mu v ruce jeho: pomstou pomštěno bude nad takovým. ");
INSERT INTO ces1613_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","A však jestliže by den neb dva přečkal, neponese pomsty, nebo jej zaplatil. ");
INSERT INTO ces1613_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Když by se svadili muži, a urazili ženu těhotnou, tak že by vyšel z ní plod její, však by se zhouba nestala: pokutován bude, jakž by uložil naň muž té ženy, a dá vedlé uznání soudců. ");
INSERT INTO ces1613_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pakliť by smrt přišla, tedy dáš život za život, ");
INSERT INTO ces1613_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Oko za oko, zub za zub, ruku za ruku, nohu za nohu, ");
INSERT INTO ces1613_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Spáleninu za spáleninu, ránu za ránu, modřinu za modřinu. ");
INSERT INTO ces1613_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Jestliže by kdo urazil služebníka svého v oko, aneb děvku svou v oko, tak že by jej o ně připravil: svobodného jej propustí za oko jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Pakli by zub služebníku svému neb zub děvce své vyrazil, svobodného jej propustí za zub jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Jestliže by vůl utrkl muže neb ženu, tak že by umřel člověk: ukamenován bude ten vůl, aniž jedeno bude maso jeho, však pán vola toho bez viny bude. ");
INSERT INTO ces1613_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Než byl-liť by vůl trkavý prvé, a bylo by to osvědčeno pánu jeho, on pak nezavřel by ho, a v tom zabil by muže neb ženu: vůl ten ukamenován bude, a pán jeho také umře. ");
INSERT INTO ces1613_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pakliť mu bude uloženo, aby se vyplatil: tedy dá výplatu za život svůj, jakážkoli na něj uložena bude. ");
INSERT INTO ces1613_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Buď že by syna utrkl, buď dceru, podlé soudu toho stane se jemu. ");
INSERT INTO ces1613_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Jestliže by služebníka vůl ztrkal neb děvku, třidceti lotů stříbra dá pánu jeho, a vůl ten bude ukamenován. ");
INSERT INTO ces1613_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Kdyby kdo odhradil studnici, a neb vykopal někdo studnici, a zase jí nepřikryl, a vpadl by tam vůl neb osel: ");
INSERT INTO ces1613_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Pán té studnice nahradí to, a peníze položí pánu jeho, a což se zabilo, to sobě míti bude. ");
INSERT INTO ces1613_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","A ustrčil-li by vůl něčí vola sousedova, že byl umřel: tedy prodadí vola toho živého, a podělí se penězi jeho; i s zabitým volem také se rozdělí. ");
INSERT INTO ces1613_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pakli vědíno bylo, že vůl byl trkavý prvé, a nezavřel ho pán jeho: bez výmluvy ať dá vola za vola, a zabitý ať mu zůstane. ");
INSERT INTO ces1613_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Jestliže by kdo ukradl vola aneb dobytče, a zabil by je neb prodal: pět volů navrátí za toho vola, a čtvero dobytčat za to dobytče. ");
INSERT INTO ces1613_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","(Jestliže by zloděj zastižen byl při podkopávání a ubit jsa, umřel by: ten, kdo ho ranil, nebude vinen smrtí. ");
INSERT INTO ces1613_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pakli by to ve dne učinil, smrtí vinen bude.) Bez prodlévání ať navrátí; pakli nemá co, prodán bude pro zlodějství své. ");
INSERT INTO ces1613_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Jestliže nalezena bude v rukou jeho krádež, buď vůl, neb osel, buď dobytče ještě živé, dvénásobně navrátí. ");
INSERT INTO ces1613_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Jestliže by kdo spásl pole neb vinici, a vpustil hovado své, aby se páslo na cizím poli: což nejlepšího má na poli svém neb vinici své, tím tu škodu nahradí. ");
INSERT INTO ces1613_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Vyšel-li by oheň, a chytilo by se trní, a shořel by stoh neb stojaté obilí neb pole: nahradí ten, kdož zapálil, to, což shořelo. ");
INSERT INTO ces1613_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kdyby někdo dal schovati bližnímu svému peníze neb nádoby, a bylo by ukradeno z domu muže toho, jestliže nalezen bude zloděj, dvojnásobně navrátí. ");
INSERT INTO ces1613_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pakli nebude zloděj nalezen, tedy postaven bude pán domu toho před soudce, a přisáhne, že nevztáhl ruky své na věc bližního svého. ");
INSERT INTO ces1613_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","O všelijakou věc, o niž by byla nesnáz, buď o vola neb osla, dobytče neb roucho, pro všelikou věc ztracenou, když by kdo pravil, že to jest: před soudce přijde pře obou dvou; ten, kohož oni vinného usoudí, dvojnásobně navrátí bližnímu svému. ");
INSERT INTO ces1613_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Jestliže by kdo dal bližnímu svému k chování osla neb vola, neb dobytče a jakékoli hovado, a umřelo by neb ochromělo, neb zajato bylo, že žádný neviděl: ");
INSERT INTO ces1613_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Přísaha Hospodinova vkročí mezi oba, že nevztáhl ruky své k věci bližního svého; a přijme jej v tom pán věci té, a onen nebude povinen navraceti. ");
INSERT INTO ces1613_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pakli by krádeží vzato bylo od něho, navrátiti zase má pánu jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Pakli by udáveno bylo, postaví svědka a nebude povinen upláceti toho, což udáveno jest. ");
INSERT INTO ces1613_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kdyby pak někdo vypůjčil něčeho od bližního svého, a ochromělo by aneb umřelo v nepřítomnosti pána jeho, bez výmluvy navrátí zase. ");
INSERT INTO ces1613_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pakli by pán jeho byl s ním, není povinen platiti, poněvadž bylo za peníze najaté, a přišlo za mzdu svou. ");
INSERT INTO ces1613_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Jestliže by kdo namluvil pannu, kteráž není zasnoubena, a spal by s ní: dáť jí věno, a vezme ji sobě za manželku. ");
INSERT INTO ces1613_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Pakli by otec její nikoli nechtěl jí dáti jemu, odváží stříbra podlé obyčeje věna panenského. ");
INSERT INTO ces1613_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Èarodějnici nedáš živu býti. ");
INSERT INTO ces1613_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Kdo by koli scházel se s hovadem, smrtí ať umře. ");
INSERT INTO ces1613_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kdo by obětoval bohům, kromě samému Hospodinu, jako proklatý vyhlazen bude. ");
INSERT INTO ces1613_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Příchozímu neučiníš křivdy, aniž utiskneš ho; nebo příchozí byli jste v zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Žádné vdovy neb sirotka trápiti nebudete. ");
INSERT INTO ces1613_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Pakli bez lítosti trápiti je budete, a oni by volali ke mně, vězte, že vyslyším křik jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","A rozhněvá se prchlivost má, i zbiji vás mečem; a budou ženy vaše vdovy a děti vaši sirotci. ");
INSERT INTO ces1613_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Půjčíš-li peněz lidu mému chudému, kterýž jest s tebou: nebudeš jemu jako lichevník, aniž ho lichvou obtížíš. ");
INSERT INTO ces1613_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Pakli v základu vezmeš roucho bližního svého, do západu slunce jemu je navrátíš. ");
INSERT INTO ces1613_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Nebo ten jediný má oděv, to jest roucho, jímž přikrývá tělo své, a na němž spí. Když bude volati ke mně, tedy uslyším, nebo jsem milosrdný. ");
INSERT INTO ces1613_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Soudcům nebudeš utrhati, a knížeti lidu svého zlořečiti nebudeš. ");
INSERT INTO ces1613_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Z hojnosti obilí, a tekutých věcí svých neobmeškáš prvotin obětovati. Prvorozeného z synů svých mně dáš. ");
INSERT INTO ces1613_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tak učiníš s volem svým a s dobytkem svým: Sedm dní bude s matkou svou, dne pak osmého mně je dáš. ");
INSERT INTO ces1613_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Lid svatý budete mi, a nebudete jísti masa z udáveného na poli; psu je vržete. ");
INSERT INTO ces1613_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Nebudeš vynášeti pověsti lživé. Neklaď s bezbožným ruky své, abys měl býti s ním svědek nepravý. ");
INSERT INTO ces1613_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Nepostoupíš po množství ke zlému, a nebudeš se přimlouvati k rozepři, tak abys se uchýlil po větším počtu k převrácení soudu. ");
INSERT INTO ces1613_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ani chudého šanovati nebudeš v při jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Trefil-li bys na vola nepřítele svého neb osla jeho, an bloudí, obrátíš a dovedeš ho k němu. ");
INSERT INTO ces1613_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Uzřel-li bys an osel toho, jenž tě má v nenávisti, leží pod břemenem svým, zdaž se zdržíš, abys mu neměl pomoci? Nýbrž opravdově pomůžeš jemu, spolu s tím, kdož tě v nenávisti má. ");
INSERT INTO ces1613_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Nepřevrátíš soudu chudého svého v jeho při. ");
INSERT INTO ces1613_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Od slova lživého vzdálíš se. Nevinného a spravedlivého nezabiješ, nebo já neospravedlním bezbožného. ");
INSERT INTO ces1613_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Aniž bráti budeš darů, nebo dar oslepuje i prozřetelné, a převrací slova spravedlivých. ");
INSERT INTO ces1613_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Příchozího nebudeš ssužovati; nebo sami znáte, jaký jest život příchozích, poněvadž pohostinu jste byli v zemi Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Po šest let osívati budeš zemi svou, a shromažďovati úrodu její; ");
INSERT INTO ces1613_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Sedmého pak léta ponecháš jí, ať odpočine, aby jedli chudí lidu tvého. Co pak zůstane po nich, pojí zvěř polní. Tak uděláš s vinicí svou i s olivovím svým. ");
INSERT INTO ces1613_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Šest dní budeš dělati díla svá, dne pak sedmého přestaneš, aby odpočinul vůl tvůj i osel tvůj, a oddechl syn děvky tvé i příchozí. ");
INSERT INTO ces1613_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ve všech těch věcech, kteréž mluvil jsem vám, ostříhati se budete. Jména bohů cizích ani připomínati nebudete, aniž bude slyšáno z úst tvých. ");
INSERT INTO ces1613_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Třikrát slaviti mi budeš svátek na každý rok. ");
INSERT INTO ces1613_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Slavnosti přesnic ostříhati budeš. Sedm dní jísti budeš chleby přesné, jakž jsem přikázal tobě, v čas vyměřený měsíce Abib; nebo v ten vyšel jsi z Egypta. Aniž se ukážete přede mnou prázdní. ");
INSERT INTO ces1613_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","A držeti budeš slavnost žně, když mi obětovati budeš prvotiny prací svých z toho, což jsi vsel na poli. Slavnost také sklizení držeti budeš při vyjití roku, když sklidíš práce své z pole. ");
INSERT INTO ces1613_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Třikrát v roce ukáže se každý z tvých pohlaví mužského před tváří Panovníka Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Nebudeš obětovati krve z oběti mé, dokavadž u tebe kvas jest, aniž zůstane tuk slavnosti mé do jitra. ");
INSERT INTO ces1613_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Prvotiny prvních úrod země své přinášeti budeš do domu Hospodina Boha svého. Nebudeš vařiti kozelce v mléku mateře jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Aj, já pošli anděla před tebou, aby ostříhal tebe na cestě, a přivedl tě na místo, kteréž jsem připravil. ");
INSERT INTO ces1613_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Šetrně se měj před ním, a poslouchej hlasu jeho. Nepopouzej ho, neboť nepromine přestoupení vašeho, poněvadž jméno mé jest u prostřed něho. ");
INSERT INTO ces1613_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nebo budeš-li věrně poslouchati hlasu jeho, a činiti, cožť bych koli řekl: tedy nepřítelem budu nepřátel tvých, a trápiti budu ty, jenž tebe trápí. ");
INSERT INTO ces1613_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Nebo půjde anděl můj před tebou, a uvede tě do země Amorejského a Hetejského, Ferezejského a Kananejského, Hevejského a Jebuzejského, kteréž vyhladím. ");
INSERT INTO ces1613_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nebudeš se klaněti bohům jejich, ani jim sloužiti, aniž dělati budeš tak, jako oni dělají; ale z gruntu vyvrátíš je, a obrazy jejich na kusy stroskoceš. ");
INSERT INTO ces1613_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Sloužiti pak budete Hospodinu Bohu svému, a požehnáť chlebu tvému i vodám tvým; a odejmu nemoc z prostředku tvého. ");
INSERT INTO ces1613_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nebudeť, která by potratila, ani neplodná v zemi tvé; počet dnů tvých doplním. ");
INSERT INTO ces1613_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Strach svůj pustím před tebou, a předěsím všeliký lid, proti kterémuž vyjdeš, a způsobím to, aby všickni nepřátelé tvoji utíkali před tebou. ");
INSERT INTO ces1613_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Pošli i sršně před tebou, aby vyhnali Hevea, a Kananea a Hetea před tváří tvou. ");
INSERT INTO ces1613_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nevyženu ho od tváři tvé v jednom roce, aby se země neobrátila v poušť, a nerozmnožily se proti tobě šelmy divoké. ");
INSERT INTO ces1613_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pomalu vyháněti jej budu od tváři tvé, až bys ty se rozplodil, a dědičně mohl ujíti zemi. ");
INSERT INTO ces1613_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Položím pak meze tvé od moře Rudého až k moři Filistinskému, a od pouště až k řece; nebo v ruce vaše dám obyvatele země, a vyženeš je od tváři své. ");
INSERT INTO ces1613_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Neučiníš s nimi a bohy jejich smlouvy. ");
INSERT INTO ces1613_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Nebudou bydliti v zemi tvé, aby nepřipravili tě k hříchu proti mně, když bys ctil bohy jejich; nebo by to bylo tobě osídlem. ");
INSERT INTO ces1613_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mojžíšovi pak řekl: Vstup k Hospodinu ty a Aron, Nádab a Abiu, a sedmdesáte z starších Izraelských, a klaněti se budete zdaleka. ");
INSERT INTO ces1613_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sám pak toliko Mojžíš vstoupí k Hospodinu, ale oni se nepřiblíží; aniž lid vstoupí s ním. ");
INSERT INTO ces1613_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tedy přišel Mojžíš, a vypravoval lidu všecka slova Hospodinova a všecky soudy. I odpověděl všecken lid jedním hlasem, a řekli: Všecka slova, kteráž mluvil Hospodin, učiníme. ");
INSERT INTO ces1613_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Napsal pak Mojžíš všecka slova Hospodinova, a vstav ráno, vzdělal oltář pod horou, a dvanácte sloupů podlé počtu dvanáctera pokolení Izraelského. ");
INSERT INTO ces1613_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A poslal mládence z synů Izraelských, kteříž obětovali zápaly; a obětovali oběti pokojné Hospodinu, totiž voly. ");
INSERT INTO ces1613_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","I vzav Mojžíš polovici krve, vlil do medenic, a polovici druhou vylil na oltář. ");
INSERT INTO ces1613_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Vzav také knihu smlouvy, četl v uších lidu. Kteříž řekli: Cožkoli mluvil Hospodin, činiti a poslouchati budeme. ");
INSERT INTO ces1613_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Vzal také Mojžíš krev a pokropil lidu a řekl: Aj, krev smlouvy, kterouž učinil s vámi Hospodin při všech těchto věcech. ");
INSERT INTO ces1613_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Potom vstoupili Mojžíš a Aron, Nádab a Abiu a sedmdesáte z starších Izraelských, ");
INSERT INTO ces1613_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","A viděli Boha Izraelského. A pod nohami jeho bylo jako dílo z kamene zafirového, a jako nebe, když jest jasné. ");
INSERT INTO ces1613_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Na knížata pak synů Izraelských nevztáhl ruky své, ačkoli viděli Boha, a potom jedli i pili. ");
INSERT INTO ces1613_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","I řekl Hospodin Mojžíšovi: Vstup ke mně na horu a buď tam; a dám tobě tabule kamenné, zákon i přikázaní, kteráž jsem napsal, abys je učil. ");
INSERT INTO ces1613_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Tedy vstal Mojžíš a Jozue služebník jeho; i vstoupil Mojžíš na horu Boží. ");
INSERT INTO ces1613_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Starším pak řekl: Zůstaňte tuto, dokudž se nenavrátíme k vám. A teď Aron a Hur jsou s vámi, kdož by měl rozepři, k nim ať jde. ");
INSERT INTO ces1613_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Tedy vstoupil Mojžíš na horu, a přikryl oblak horu. ");
INSERT INTO ces1613_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","I přebývala sláva Hospodinova na hoře Sinai, a přikryl ji oblak za šest dní; a dne sedmého zavolal na Mojžíše z prostřed oblaku. ");
INSERT INTO ces1613_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","A tvárnost slávy Hospodinovy byla jako spalující oheň na vrchu hory, před očima synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","I všel Mojžíš do prostřed oblaku a vstoupil na horu. A byl Mojžíš na hoře čtyřidceti dní a čtyřidceti nocí. ");
INSERT INTO ces1613_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Mluv k synům Izraelským, ať mi vybírají obět vzhůru pozdvižení. Od každého člověka, kterýž by ji z srdce dobrovolně dal, přijměte takovou obět mou. ");
INSERT INTO ces1613_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Tatoť pak jest obět pozdvižení, kterouž budete bráti od nich: Zlato, a stříbro, a měď, ");
INSERT INTO ces1613_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Postavec modrý, šarlat, a červec dvakrát barvený, bílé hedbáví a srsti kozí; ");
INSERT INTO ces1613_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Též kůže skopcové na červeno barvené, a kůže jezevčí, a dříví setim, ");
INSERT INTO ces1613_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Olej k svícení, vonné věci na olej ku pomazování, a pro kadění vonné věci; ");
INSERT INTO ces1613_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Kamení onychinové, a jiné kamení k vsazování do náramníku a náprsníku. ");
INSERT INTO ces1613_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","I udělajíť mi svatyni, abych bydlil uprostřed nich. ");
INSERT INTO ces1613_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Vedlé všeho, jakž já ukazuji tobě podobenství stánku a podobenství všech nádob jeho, tak uděláte. ");
INSERT INTO ces1613_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Udělají také truhlu z dříví setim. Půl třetího lokte bude dlouhost její, půl druhého lokte širokost její, půl druhého také lokte vysokost její. ");
INSERT INTO ces1613_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","A obložíš ji zlatem čistým, vnitř i zevnitř obložíš ji; a uděláš nad ní vůkol korunu zlatou. ");
INSERT INTO ces1613_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Sliješ k ní také čtyři kruhy zlaté, kteréž přiděláš ke čtyřem úhlům jejím, dva totiž kruhy po jedné straně její, a dva kruhy po druhé straně její. ");
INSERT INTO ces1613_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Uděláš k tomu i sochory z dříví setim, a obložíš je zlatem. ");
INSERT INTO ces1613_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","I uvlečeš sochory do kruhů po stranách té truhly, aby na nich nošena byla truhla. ");
INSERT INTO ces1613_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","V kruzích té truhly budou bývati sochorové; nebudou vytahováni z nich. ");
INSERT INTO ces1613_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","A dáš do truhly svědectví, kteréž dám tobě. ");
INSERT INTO ces1613_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Uděláš i slitovnici z zlata čistého. Půl třetího lokte bude dlouhost její, půl druhého pak lokte širokost její. ");
INSERT INTO ces1613_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Uděláš také dva cherubíny zlaté, z taženého zlata uděláš je na dvou koncích slitovnice. ");
INSERT INTO ces1613_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Uděláš pak cherubína jednoho na jednom konci, a cherubína druhého na druhém konci; na slitovnici uděláte cherubíny na obou koncích jejích. ");
INSERT INTO ces1613_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","A budou míti cherubínové křídla vztažená svrchu, zastírajíce křídly svými slitovnici, a tváři jejich obráceny budou jednoho k druhému; k slitovnici budou tváři cherubínů. ");
INSERT INTO ces1613_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Dáš pak slitovnici svrchu na truhlu, a do truhly vložíš svědectví, kteréž dám tobě. ");
INSERT INTO ces1613_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","A tam budu přicházeti k tobě, a s tebou z té slitovnice, z prostředku dvou cherubínů, kteříž jsou nad truhlou svědectví, mluviti o všecko, cožť bych poroučeti chtěl k synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Uděláš také stůl z dříví setim. Dvou loket bude dlouhost jeho, a na loket širokost jeho, půl druhého pak lokte vysokost jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","A obložíš jej zlatem čistým, a uděláš mu okolek zlatý vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Uděláš také okolo něho lištu čtyř prstů zšíří; a okolek zlatý uděláš okolo té lišty. ");
INSERT INTO ces1613_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Uděláš u něho i čtyři kruhy zlaté, kteréž vpustíš do čtyř úhlů, kteříž jsou ve čtyřech nohách jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Pod tou lištou budou kruhové, skrze něž provlačováni budou sochorové k nošení stolu. ");
INSERT INTO ces1613_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ty pak sochory uděláš z dříví setim, a obložíš je zlatem; i bude stůl nošen na nich. ");
INSERT INTO ces1613_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Uděláš také misy jeho, a lžice jeho, a přikryvadla jeho, a koflíky jeho, k přikrývání; z čistého zlata naděláš toho. ");
INSERT INTO ces1613_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","A klásti budeš na ten stůl chleby předložení před tvář mou ustavičně. ");
INSERT INTO ces1613_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Uděláš také svícen z zlata čistého, z taženého zlata ať jest ten svícen; sloupec jeho i prutové jeho, misky jeho a koule jeho, i květové jeho z něho budou. ");
INSERT INTO ces1613_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","A šest prutů vycházeti bude z boků jeho, tři prutové svícnu s jedné strany jeho, a tři prutové s druhé strany jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tři misky udělané na způsob pecky mandlové ať jsou na prutu jednom, a koule a květ, a tři misky udělané na způsob pecky mandlové na prutu druhém, a koule a květ; takž i na jiných šesti prutech z svícnu vycházejících. ");
INSERT INTO ces1613_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na svícnu také budou čtyři misky udělané na způsob mandlové pecky, a koule jeho, i květové jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","A bude koule pode dvěma pruty z něho, koule též pod druhými dvěma pruty z něho, koule opět pod jinými dvěma pruty z něho; a tak pod šesti pruty vycházejícími z svícna. ");
INSERT INTO ces1613_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Koule jejich i prutové jejich z něho budou; všecko to z cela kované z zlata čistého. ");
INSERT INTO ces1613_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Uděláš i sedm lamp na něj; a bude je rozsvěcovati kněz, aby svítily po stranách jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","I utěradla jeho, i nádoby k oharkům jeho z zlata čistého. ");
INSERT INTO ces1613_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Z centnéře zlata čistého uděláno bude to se vším tím nádobím. ");
INSERT INTO ces1613_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Hlediž pak, abys udělal podlé podobenství toho, kteréž tobě ukázáno jest na hoře. ");
INSERT INTO ces1613_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Příbytek pak uděláš z desíti čalounů, kteříž budou z bílého hedbáví soukaného, a z postavce modrého, a z šarlatu, a z červce dvakrát barveného; a cherubíny dílem řemeslným uděláš. ");
INSERT INTO ces1613_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dlouhost čalounu jednoho osm a dvadceti loket, a širokost čalounu jednoho čtyři lokty; míra jedna bude všech čalounů. ");
INSERT INTO ces1613_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pět čalounů spolu spojeno bude jeden s druhým, a pět druhých čalounů též spolu spojeno bude jeden s druhým. ");
INSERT INTO ces1613_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","A naděláš i ok z hedbáví modrého po kraji čalounu jednoho na konci, kde se má spojovati s druhým; a tolikéž uděláš na kraji čalounu druhého na konci v spojení druhém. ");
INSERT INTO ces1613_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Padesáte ok uděláš na čalounu jednom, a padesáte ok uděláš po kraji čalounu, kterýmž má připojen býti k druhému; oko jedno proti druhému aby bylo. ");
INSERT INTO ces1613_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Uděláš také padesáte haklíků zlatých a spojíš čalouny jeden s druhým haklíky těmi; a tak bude příbytek jeden. ");
INSERT INTO ces1613_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Nadto uděláš houní z srstí kozích na stánek k přistírání příbytku po vrchu; jedenácte takových houní uděláš. ");
INSERT INTO ces1613_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Dlouhost houně jedné třidceti loktů, a širokost houně jedné čtyř loktů; jednostejná míra těch jedenácti houní bude. ");
INSERT INTO ces1613_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","A spojíš pět houní obzvláštně, a šest houní opět obzvláštně, a přehneš na dvé houni šestou napřed v čele stánku. ");
INSERT INTO ces1613_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Uděláš pak padesáte ok po kraji houně jedné na konci, kdež se spojovati má, a padesáte ok po kraji houně k spojení druhému. ");
INSERT INTO ces1613_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Uděláš také haklíků měděných padesát, kteréž vepneš do ok, a spojíš stánek, aby byl jedno. ");
INSERT INTO ces1613_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Co pak zbývá houní po přikrytí stánku, totiž půl houně přesahující, převisne při zadní straně příbytku. ");
INSERT INTO ces1613_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","A loket s jedné a loket s druhé strany, zbývající na dýl z houní stánku, převisne po stranách příbytku sem i tam, aby jej přikrýval. ");
INSERT INTO ces1613_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Uděláš také přikrytí na stánek z koží skopových na červeno barvených, přikrytí také z koží jezevčích svrchu. ");
INSERT INTO ces1613_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Naděláš k příbytku i desk stojatých z dříví setim. ");
INSERT INTO ces1613_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Desíti loktů dlouhost dsky, a půl druhého lokte širokost dsky jedné. ");
INSERT INTO ces1613_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Dva čepy dska jedna míti bude, podobně jako stupně u schodu zpořádané, jeden proti druhému; tak uděláš u všech desk příbytku. ");
INSERT INTO ces1613_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Zděláš pak desky k příbytku, dvadceti desk k straně polední, k větru polednímu. ");
INSERT INTO ces1613_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","(A čtyřidceti podstavků stříbrných uděláš pod dvadceti desk; dva podstavky pod jednu dsku ke dvěma čepům jejím, a dva podstavky pod dsku druhou pro dva čepy její.) ");
INSERT INTO ces1613_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Na druhé pak straně příbytku k straně půlnoční dvadceti desk, ");
INSERT INTO ces1613_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","A čtyřidceti podstavků jejich stříbrných; dva podstavky pod jednu dsku a dva podstavky pod dsku druhou. ");
INSERT INTO ces1613_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Na straně také příbytku k západu šest uděláš desk. ");
INSERT INTO ces1613_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","A dvě dsky uděláš v obou dvou úhlech příbytku; ");
INSERT INTO ces1613_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kteréž budou spojené pozpodu, a tolikéž spojené svrchu k jednomu kruhu; tak bude při dvou těch, ve dvou úhlech budou. ");
INSERT INTO ces1613_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","A tak bude osm desk, a podstavkové jejich stříbrní, šestnácte podstavků; dva podstavkové pod dskou jednou a dva podstavkové pod dskou druhou. ");
INSERT INTO ces1613_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Naděláš také svlaků z dříví setim. Pět jich bude dskám k straně příbytku jedné, ");
INSERT INTO ces1613_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","A pět svlaků dskám při straně příbytku druhé, a pět svlaků dskám k straně západní příbytku dosahující k oběma úhlům. ");
INSERT INTO ces1613_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ale prostřední svlak u prostřed desk provleče se od jednoho konce k druhému. ");
INSERT INTO ces1613_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ty pak dsky obložíš zlatem, a kruhy k nim uděláš zlaté, do nichž by svlakové byli uvlačováni; a obložíš i svlaky zlatem. ");
INSERT INTO ces1613_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","A tak vyzdvihneš příbytek podlé způsobu toho, kterýž tobě ukázán na hoře. ");
INSERT INTO ces1613_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Uděláš i oponu z postavce modrého, a z šarlatu, a z červce dvakrát barveného, a z bílého hedbáví soukaného; dílem řemeslným uděláš ji s cherubíny. ");
INSERT INTO ces1613_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","A zavěsíš ji na čtyřech sloupích z dříví setim, obložených zlatem, (hákové jejich zlatí), na čtyřech podstavcích stříbrných. ");
INSERT INTO ces1613_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","A dáš oponu na háky, a vneseš vnitř za oponu truhlu svědectví; a oddělovati vám bude ta opona svatyni od svatyně svatých. ");
INSERT INTO ces1613_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Položíš také slitovnici na truhlu svědectví v svatyni svatých. ");
INSERT INTO ces1613_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","A postavíš stůl vně před oponou, svícen pak naproti stolu v straně příbytku polední, a stůl dáš na stranu půlnoční. ");
INSERT INTO ces1613_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","A uděláš zastření dveří stánku z postavce modrého a z šarlatu, a z červce dvakrát barveného, a z bílého hedbáví přesukovaného, dílem vyšívaným. ");
INSERT INTO ces1613_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","K zastření pak tomu uděláš pět sloupů z dříví setim, kteréž obložíš zlatem, a hákové jejich zlatí; a sleješ k nim pět podstavků měděných. ");
INSERT INTO ces1613_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Uděláš také oltář z dříví setim pěti loket zdýlí a pěti loket zšíří; čtverhranatý bude oltář, a tří loket zvýší bude. ");
INSERT INTO ces1613_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","A zděláš mu rohy na čtyřech úhlech jeho; z něho budou rohové jeho; a obložíš jej mědí. ");
INSERT INTO ces1613_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Naděláš také k němu hrnců, do kterýchž by popel bral, a lopat a kotlíku, a vidliček a nádob k uhlí. Všecka nádobí jeho z mědi uděláš. ");
INSERT INTO ces1613_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Uděláš mu i rošt mřežovaný měděný, a u té mříže čtyři kruhy měděné na čtyřech rozích jejích. ");
INSERT INTO ces1613_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","A dáš ji pod okolek oltáře do vnitřku; a bude ta mříže až do polu oltáře. ");
INSERT INTO ces1613_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Uděláš k tomu oltáři i sochory z dříví setim, a mědí je okuješ. ");
INSERT INTO ces1613_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","A ti sochorové provlečeni budou skrze ty kruhy; a budou sochorové ti na obou stranách oltáře, když nošen bude. ");
INSERT INTO ces1613_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Uděláš jej z desk, aby byl vnitř prázdný; jakž ukázáno tobě na hoře, tak udělají. ");
INSERT INTO ces1613_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Uděláš také síň příbytku k straně polední; koltry síně té očkovaté budou z bílého hedbáví soukaného; sto loket zdélí ať má kraj jeden. ");
INSERT INTO ces1613_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Sloupů pak bude k nim dvadcet, a podstavků k nim měděných dvadcet; háky na sloupích a přepásaní jich stříbrné. ");
INSERT INTO ces1613_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","A tak i strana půlnoční na dýl ať má koltry očkovaté sto loket zdýlí, a sloupů svých dvadceti, a podstavků k nim měděných dvadceti; háky na sloupích a přepásaní jich stříbrné. ");
INSERT INTO ces1613_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Na šíř pak té síně k straně západní budou koltry očkovaté padesáti loktů zdýlí, a sloupů k nim deset, a podstavků jejich deset. ");
INSERT INTO ces1613_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","A širokost síně v straně přední na východ bude padesáti loktů. ");
INSERT INTO ces1613_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Patnácti loktů budou koltry očkovaté k straně jedné, sloupové k nim tři, a podstavkové jejich tři. ");
INSERT INTO ces1613_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","A k straně druhé patnácti loktů zdýlí budou koltry očkovaté, sloupové jejich tři, a podstavkové jejich tři. ");
INSERT INTO ces1613_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","K bráně pak té síně uděláno bude zastření dvadcíti loktů z postavce modrého a šarlatu, a z červce dvakrát barveného, a bílého hedbáví soukaného, dílem krumpéřským, sloupové k němu čtyři, a podstavkové jejich čtyři. ");
INSERT INTO ces1613_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Všickni sloupové síně vůkol přepásani budou stříbrem; hákové pak jejich budou stříbrní, a podstavkové jejich mědění. ");
INSERT INTO ces1613_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Dlouhost síně bude sto loket, a širokost padesáte, všudy jednostejná, vysokost pak pěti loktů, z bílého hedbáví soukaného, a podstavkové budou mědění. ");
INSERT INTO ces1613_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Všecka nádobí příbytku, ke vší službě jeho, a všickni kolíkové jeho, i všickni kolíkové síně z mědi budou. ");
INSERT INTO ces1613_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ty také přikaž synům Izraelským, ať nanesou oleje olivového čistého, vytlačeného k svícení, aby lampy vždycky rozsvěcovány byly. ");
INSERT INTO ces1613_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","V stánku úmluvy před oponou, kteráž zastírati bude svědectví, spravovati je budou Aron a synové jeho od večera až do jitra před Hospodinem. Toť bude řád věčný, kterýž zachovávati budou potomci jejich mezi syny Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ty pak přijmi k sobě Arona bratra svého s syny jeho z prostředku synů Izraelských, aby úřad kněžský konali přede mnou: Aron, Nádab, Abiu, Eleazar a Itamar, synové Aronovi. ");
INSERT INTO ces1613_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","A uděláš roucha svatá Aronovi bratru svému k slávě a k ozdobě. ");
INSERT INTO ces1613_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ty také mluviti budeš se všechněmi umělými řemeslníky, kteréž jsem naplnil duchem moudrosti, aby dělali roucha Aronovi ku posvěcení jeho, v nichž by úřad kněžský konal přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Tato pak jsou roucha, kteráž udělají, náprsník, náramenník, plášť a sukni s oky, čepici a pás. Takové šaty svaté udělají Aronovi bratru tvému a synům jeho, aby úřad kněžský konali přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","A vezmou řemeslníci zlato a modrý postavec, a šarlat a červec dvakrát barvený a kment. ");
INSERT INTO ces1613_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Udělají pak náramenník z zlata, z postavce modrého a šarlatu, z červce dvakrát barveného a hedbáví bílého, přesukovaného dílem řemeslným. ");
INSERT INTO ces1613_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Dva vrchní kraje spojená míti bude na dvou koncích svých, a tak se spolu držeti bude. ");
INSERT INTO ces1613_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Přepásaní pak přes ten náramenník, kteréž na něm bude, podobné bude dílu jeho; z týchž věcí bude, totiž z zlata, z postavce modrého a z šarlatu, a z červce dvakrát barveného, a z hedbáví bílého přesukovaného. ");
INSERT INTO ces1613_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Vezmeš také dva kameny onychinové, a vyryješ na nich jména synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Šest jmen jejich na kameni jednom, a jmen šest ostatních na kameni druhém, podlé pořádku narození jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Dílem řemeslníka, kterýž řeže na kameni, a kterýž vyrývá pečeti, vyryješ na těch dvou kameních jména synů Izraelských; do zlata je vsadíš. ");
INSERT INTO ces1613_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","A položíš dva kameny ty na vrchních krajích náramenníku, kameny pro pamět na syny Izraelské; a nositi bude Aron jména jejich před Hospodinem na obou ramenách svých na památku. ");
INSERT INTO ces1613_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Uděláš i haklíky zlaté. ");
INSERT INTO ces1613_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","A dva řetízky z zlata čistého jednostejně uděláš dílem točeným, a zavěsíš řetízky ty stočené na ty haklíky. ");
INSERT INTO ces1613_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Uděláš také náprsník soudu dílem řemeslným, takovým dílem, jako náramenník uděláš jej z zlata, z postavce modrého, z šarlatu, z červce dvakrát barveného, a z bílého hedbáví přesukovaného. ");
INSERT INTO ces1613_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ètverhraný bude a dvojnásobní; pídi dlouhost, a pídi širokost jeho bude. ");
INSERT INTO ces1613_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","A vysadíš jej všudy kamením drahým. Ètyřmi řady ať jest kamení, pořádkem tímto: Sardius, topazius a smaragdus v prvním řadu; ");
INSERT INTO ces1613_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","V druhém pak zpořádaní karbunkulus, zafir a jaspis; ");
INSERT INTO ces1613_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","A v řadu třetím linkurius, achates a ametyst; ");
INSERT INTO ces1613_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","V čtvrtém řadu chryzolit, onychin a beryl. Vsazeni budou do zlata v svém pořádku. ");
INSERT INTO ces1613_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Těch pak kamenů s jmény synů Izraelských bude dvanácte, podlé jmen jejich, dílem řežících pečeti; jeden každý podlé jména svého, pro dvanáctero pokolení budou. ");
INSERT INTO ces1613_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Uděláš i k náprsníku řetízky jednostejné dílem točeným z zlata čistého. ");
INSERT INTO ces1613_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Uděláš také k náprsníku dva kroužky zlaté, a dáš je na dva kraje náprsníka. ");
INSERT INTO ces1613_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","A prostrčíš dva řetízky zlaté skrze dva kroužky po krajích náprsníka. ");
INSERT INTO ces1613_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","A druhé konce těch dvou řetízků připneš k haklíkům, a dáš na vrchní kraje náramenníka po předu. ");
INSERT INTO ces1613_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Uděláš i dva kroužky zlaté, kteréž dáš na dva kraje náprsníka, na tu obrubu jeho, kteráž jest po té straně k náramenníku do vnitřku. ");
INSERT INTO ces1613_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Uděláš ještě dva jiné kroužky zlaté, kteréž dáš na dvě strany náramenníka zespod po předu naproti spojení jeho, svrchu nad přepásaním náramenníka. ");
INSERT INTO ces1613_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tak svíží náprsník ten, kroužky jeho s kroužky náramenníka, tkanicí z postavce modrého, aby byl nad přepásaním náramenníka, a neodevstával náprsník od náramenníka. ");
INSERT INTO ces1613_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","I bude nositi Aron jména synů Izraelských na náprsníku soudu na srdci svém, když vcházeti bude do svatyně, na památku před Hospodinem ustavičně. ");
INSERT INTO ces1613_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Položíš pak do náprsníku soudu urim a thumim, aby bylo na srdci Aronově, když vcházeti bude před Hospodina; a nositi bude Aron soud synů Izraelských na srdci svém před Hospodinem vždycky. ");
INSERT INTO ces1613_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Uděláš také plášť pod náramenník, všecken z postavce modrého. ");
INSERT INTO ces1613_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","A bude na vrchu v prostřed něho díra; okolek její všudy vůkol dílem tkaným, jako obojek u pancíře bude, aby se neroztrhl. ");
INSERT INTO ces1613_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Uděláš i na podolku jeho jablka zrnatá z hedbáví modrého, z šarlatu a z červce dvakrát barveného, na podolku jeho vůkol, a zvonečky zlaté mezi nimi vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Zvonček zlatý a jablko zrnaté, opět za tím zvonček zlatý a jablko zrnaté na podolku pláště vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","A bude to míti na sobě Aron při službách, aby slyšán byl zvuk jeho, když vcházeti bude do svatyně před Hospodina, i když vycházeti bude, aby neumřel. ");
INSERT INTO ces1613_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Uděláš také plech z zlata čistého, a vyryješ na něm dílem vyrývajících pečeti: Svatost Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kterýž dáš na tkanici z modrého postavce, a bude na čepici; napřed na čepici bude. ");
INSERT INTO ces1613_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","I bude nad čelem Aronovým, aby nesl Aron nepravosti posvěcených věcí, kterýchž by posvětili synové Izraelští při všech dařích posvěcených věcí svých; a bude nad čelem jeho vždycky, aby příjemné je činil před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Uděláš také sukni z hedbáví bílého vázanou s oky; uděláš i čepici z hedbáví bílého; pás také uděláš dílem krumpéřským. ");
INSERT INTO ces1613_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Synům také Aronovým zděláš sukně; pasy také jim uděláš a klobouky k slávě a k ozdobě. ");
INSERT INTO ces1613_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","A oblečeš v ně Arona bratra svého a syny jeho s ním, a pomažeš jich, a naplníš ruce jejich, a posvětíš mi jich, aby úřad kněžský konali přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Nadělej jim i košilek lněných k zakrytí nahoty těla; od bedr až do stehen budou. ");
INSERT INTO ces1613_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","A ať je na sobě mají Aron i synové, když vcházeti budou do stánku úmluvy, aneb když přistupovati budou k oltáři, aby sloužili v svatyni; a neponesou nepravosti, aniž zemrou. Řád tento bude věčný jemu i potomkům jeho po něm. ");
INSERT INTO ces1613_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Toto také učiníš jim ku posvěcení jich, aby úřad kněžský konali přede mnou: Vezmi volka jednoho ještě mladého a skopce dva bez vady. ");
INSERT INTO ces1613_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Chleby též přesné a koláče přesné s olejem smíšené, a oplatky přesné polité olejem; z běli pšeničné naděláš toho. ");
INSERT INTO ces1613_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","A vklada to do koše jednoho, obětovati to budeš v koši, spolu s tím volkem a dvěma skopci. ");
INSERT INTO ces1613_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Potom Aronovi a synům jeho přistoupiti kážeš ke dveřím stánku úmluvy, a umyješ je vodou. ");
INSERT INTO ces1613_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","A vezma roucha, oblečeš Arona v sukni, a v plášť náležící pod náramenník, a v náramenník, a v náprsník, a přepášeš ho pasem náramenníka. ");
INSERT INTO ces1613_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Vstavíš i čepici na hlavu jeho, a korunu svatosti vstavíš na čepici. ");
INSERT INTO ces1613_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Naposledy vezmeš olej pomazání, a vyleje na hlavu jeho, pomažeš ho. ");
INSERT INTO ces1613_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Potom synům jeho přistoupiti kážeš, a zobláčíš je v sukně. ");
INSERT INTO ces1613_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","A zopasuješ je pasy, Arona i syny jeho, a vstavíš jim čepičky na hlavu. I budouť míti kněžství řádem věčným; a posvětíš ruky Aronovy a ruky synů jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Přivedeš také volka před stánek úmluvy, i vloží Aron a synové jeho ruce své na hlavu volka. ");
INSERT INTO ces1613_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","A zabiješ volka před Hospodinem u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","A nabera krve z volka, pomažeš na rozích oltáře prstem svým, a všecku krev vyleješ k spodku oltáře. ");
INSERT INTO ces1613_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Vezmeš pak všecken tuk přikrývající droby a branici s jater, a dvě ledviny s tukem, kterýž jest na nich, a zapálíš to na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Maso pak z toho volka, a kůži s lejny jeho spálíš ohněm vně za stany; nebo obět za hříchy jest. ");
INSERT INTO ces1613_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Skopce také jednoho vezmeš, a vloží Aron a synové jeho ruce své na hlavu toho skopce. ");
INSERT INTO ces1613_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","A zabiješ toho skopce, a nabera krve jeho, pokropíš oltáře na vrchu vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Skopce pak rozsekáš na kusy, a vymyje droby jeho i nohy, vkladeš je na ty kusy z něho a na hlavu jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","A potom všeho skopce zapálíš na oltáři; nebo zápal ten jest Hospodinu vůně příjemná, obět ohnivá jest Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Vezmeš také skopce druhého; i vloží Aron a synové jeho ruce své na hlavu téhož skopce. ");
INSERT INTO ces1613_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","A zabiješ skopce toho, a vezma krev jeho, pomažeš jí konce ucha Aronova, a konce pravého ucha synů jeho, i palce na pravé ruce jejich, a palce na pravé noze jejich; a vykropíš tu krev na oltář vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","A vezma krve, kteráž bude na oltáři, a oleje pomazání, pokropíš Arona a roucha jeho i synů jeho a roucha jejich s ním; a budeť posvěcen on i roucho jeho, i synové jeho, a roucho synů jeho s ním. ");
INSERT INTO ces1613_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Potom vezmeš z skopce tuk a ocas, a tuk přikrývající droby, a branici s jater, a dvě ledviny s tukem, kterýž jest na nich, a plece pravé, (nebo skopec naplnění jest), ");
INSERT INTO ces1613_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","A jeden pecník chleba, a jeden koláč chleba s olejem, a oplatek jeden z koše chlebů přesných, kterýž jest před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","A dáš to vše v ruce Aronovy a v ruce synů jeho, a obraceti to budeš sem i tam, aby byla obět obracení před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Potom vezma to z rukou jejich, zapálíš na oltáři v zápal, k vůni příjemné před Hospodinem. Toť jest obět ohnivá Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Vezmeš také hrudí z skopce posvěcení, kterýž bude Aronův, a obraceti je budeš sem i tam, aby byla obět obracení před Hospodinem; a budeť na tvůj díl. ");
INSERT INTO ces1613_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Posvětíš tedy hrudí obracení, a plece pozdvižení, kteréž obracíno a kteréž pozdvihováno bylo z skopce posvěcení, z toho, kterýž bude Aronův, a z toho, kterýž bude synů jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","A bude to Aronovi a synům jeho právem věčným od synů Izraelských, když obět pozdvižení bude. Nebo pozdvižení bude od synů Izraelských, z obětí jejich pokojných; pozdvižení jejich náleží Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Roucha pak svatá, kteráž jsou Aronova, zůstanou synům jeho po něm, aby pomazováni byli v nich, a aby posvěcovány byly v nich ruce jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sedm dní bude v nich choditi kněz, kterýž bude na jeho místě z synů jeho, kterýž vcházeti bude do stánku úmluvy, aby sloužil v svatyni. ");
INSERT INTO ces1613_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Skopce pak posvěcení vezma, uvaříš maso jeho na místě svatém. ");
INSERT INTO ces1613_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","A budeť jísti Aron s syny svými maso toho skopce a chléb, kterýž jest v koši u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Jísti budou to ti, za něž očištění se stalo ku posvěcení rukou jejich, aby posvěceni byli. Cizí pak nebude jísti, nebo svatá věc jest. ");
INSERT INTO ces1613_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Zůstalo-li by co masa posvěcení a chleba až do jitra, spálíš ostatky ohněm; nebude jedeno, nebo svatá věc jest. ");
INSERT INTO ces1613_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Tak tedy uděláš s Aronem a syny jeho vedlé všeho, což jsem přikázal tobě; za sedm dní posvěcovati budeš rukou jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","A volka za hřích obětovati budeš na každý den na očištění, a krví za hřích pokropíš oltáře, čině očištění na něm, a pomažeš ho ku posvěcení jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Za sedm dní očišťování konati budeš na oltáři, a posvětíš ho, a ten oltář bude nejsvětější. Cokoli dotkne se oltáře, posvěceno bude. ");
INSERT INTO ces1613_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","A toto jest, což obětovati budeš na oltáři, beránky roční dva, na každý den ustavičně. ");
INSERT INTO ces1613_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Jednoho beránka obětovati budeš ráno, a beránka druhého obětovati budeš k večerou. ");
INSERT INTO ces1613_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","A desátý díl efi běli smíšené s olejem vytlačeným, jehož by bylo s čtvrtý díl hin, a k oběti mokré čtvrtý díl hin vína na jednoho beránka. ");
INSERT INTO ces1613_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tolikéž beránka druhého obětovati budeš k večerou. Jako při oběti suché ranní, a jako při mokré oběti její, tak při této učiníš, aby byla vůně příjemná, obět ohnivá Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Zápalná obět tato ustavičná ať jest po všecky věky vaše u dveří stánku úmluvy před Hospodinem, kdež přicházeti budu k vám, abych tam s tebou mluvil. ");
INSERT INTO ces1613_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","A tam přicházeti budu k synům Izraelským, a posvěceno bude místo slávou mou. ");
INSERT INTO ces1613_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nebo posvětím stánku úmluvy i oltáře; Arona také a synů jeho posvětím, aby mi úřad kněžský konali. ");
INSERT INTO ces1613_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","A bydliti budu u prostřed synů Izraelských, a budu jim za Boha. ");
INSERT INTO ces1613_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","A zvědíť, že já jsem Hospodin Bůh jejich, kterýž jsem je vyvedl z země Egyptské, abych přebýval u prostřed nich, já Hospodin Bůh jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Uděláš i oltář, na němž by se kadilo; z dříví setim uděláš jej. ");
INSERT INTO ces1613_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Lokte zdélí, a lokte zšíří, čtverhraný bude, a dvou loket zvýší; z něho budou rohy jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Obložíš pak jej zlatem čistým, svrchek jeho i po stranách vůkol i rohy jeho; a uděláš mu korunu zlatou vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Po dvou také kruzích zlatých uděláš u něho, pod korunou ve dvou úhlech jeho, po obou stranách jeho; a skrze ně provlečeš sochory, aby nošen byl na nich. ");
INSERT INTO ces1613_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ty pak sochory uděláš z dříví setim, a obložíš je zlatem. ");
INSERT INTO ces1613_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","A postavíš jej před oponou, za kterouž jest truhla svědectví, před slitovnicí, kteráž jest nad svědectvím, kdež přicházeti budu k tobě. ");
INSERT INTO ces1613_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","I kaditi bude na něm Aron kadidlem z vonných věcí; každého jitra, když spraví světla, kaditi bude. ");
INSERT INTO ces1613_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Tolikéž když rozsvítí Aron lampy k večerou, kaditi bude kaděním vonných věcí ustavičně před Hospodinem po rodech vašich. ");
INSERT INTO ces1613_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Nevložíte na něj kadidla cizího, ani zápalu, ani oběti suché, ani oběti mokré obětovati budete na něm. ");
INSERT INTO ces1613_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Toliko očištění vykoná nad rohy jeho Aron jednou v roce, krví oběti za hřích v den očišťování; jednou v roce očištění vykoná na něm po rodech vašich; svatosvaté jest Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Když vyzdvihneš hlavní summu synů Izraelských náležejících ku počtu, dá jeden každý výplatu duše své Hospodinu, když je počítati budeš, aby nebyla na nich rána, když sečteni budou. ");
INSERT INTO ces1613_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Toto pak dají: Každý z těch, kteří jdou v počet, půl lotu dá, podlé lotu svatyně. (Dvadceti peněz platí ten lot.) Půl lotu obět pozdvižení bude Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kdožkoli jde v počet od dvadcíti let a výše, tu obět pozdvižení ať dá Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Bohatý nedá více, a chudý nedá méně, než půl lotu, když dávati budou obět pozdvižení Hospodinu k očištění duší vašich. ");
INSERT INTO ces1613_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","A vezma stříbro očištění od synů Izraelských, dáš je na potřeby k službě stánku úmluvy; a bude to synům Izraelským na památku před Hospodinem k očištění duší vašich. ");
INSERT INTO ces1613_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Uděláš i umyvadlo měděné k umývání a podstavek jeho měděný, a postavíš je mezi stánkem úmluvy a oltářem, a naleješ do něho vody. ");
INSERT INTO ces1613_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Umývati budou z něho Aron i synové jeho ruce své i nohy své. ");
INSERT INTO ces1613_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Když vcházeti budou do stánku úmluvy, umývati se budou vodou, aby nezemřeli, aneb když by měli přistupovati k oltáři, aby sloužili, a zapalovali obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","I budou umývati ruce i nohy své, aby nezemřeli. A bude jim ustanovení toto věčné, Aronovi i semeni jeho po rodech jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Ty pak vezmi sobě vonných věcí předních: Mirry nejčistší pět set lotů, a skořice vonné polovici toho, totiž dvě stě a padesát, a prustvorce vonného dvě stě a padesát; ");
INSERT INTO ces1613_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Kasie pak pět set lotů na váhu svatyně, oleje olivového míru hin. ");
INSERT INTO ces1613_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","A uděláš z toho olej pomazání svatého, mast nejvýbornější dílem apatykářským. Olej pomazání svatého bude. ");
INSERT INTO ces1613_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Pomažeš jím stánku úmluvy i truhly svědectví, ");
INSERT INTO ces1613_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","A stolu i všech nádob k němu, svícnu i všech nádob jeho, i oltáře, na němž se kadí; ");
INSERT INTO ces1613_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Oltáře také, na němž se pálí oběti, a všech nádob jeho, i umyvadla s podstavkem jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tak posvětíš jich, aby byly nejsvětější. Cožkoli dotkne se jich, posvěceno bude. ");
INSERT INTO ces1613_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Arona také a synů jeho pomažeš, a posvětíš jich, aby úřad kněžský konali přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","K synům pak Izraelským mluviti budeš, řka: Tento olej pomazání svatého bude mi v národech vašich. ");
INSERT INTO ces1613_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tělo člověka nebude mazáno jím, a podlé složení jeho neuděláte podobného. Svatýť jest, svatý vám bude. ");
INSERT INTO ces1613_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kdo by koli udělal mast podobnou, a neb mazal by jí cizího, vyhlazen bude z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","I řekl Hospodin Mojžíšovi: Vezmi sobě vonných věcí, balsamu, onychi, galbanu vonného, a kadidla čistého; jednostejná váha toho bude. ");
INSERT INTO ces1613_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","A uděláš z toho kadidlo, složení dílem apatykářským smíšené, čisté a svaté. ");
INSERT INTO ces1613_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","A ztluka to drobně, klásti budeš z něho před svědectvím v stánku úmluvy, kdež přicházeti budu k tobě. Nejsvětější to vám bude. ");
INSERT INTO ces1613_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Neuděláte sobě kadidla podlé složení tohoto, kteréž připravíš; za svatou věc tobě bude pro Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kdo by koli dělal co podobného k vůni sobě, vyhlazen bude z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Hle, povolal jsem ze jména Bezeleele, syna Uri, syna Hur, z pokolení Judova. ");
INSERT INTO ces1613_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","A naplnil jsem ho duchem Božím, moudrostí a rozumností, i uměním všelijakého řemesla, ");
INSERT INTO ces1613_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Aby vtipně smysliti uměl, což by koli řemeslně uděláno býti mohlo z zlata a z stříbra i z mědi. ");
INSERT INTO ces1613_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","I v řezání kamení drahého k vsazování, i v umělém vysazování na dřevě aby dělal všelijaké dílo. ");
INSERT INTO ces1613_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","A aj, já přidal jsem jemu Aholiaba, syna Achisamechova, z pokolení Dan. A v srdci každého vtipného složil jsem moudrost, aby spravili vše, což jsem přikázal tobě: ");
INSERT INTO ces1613_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Stánek úmluvy a truhlu svědectví, a slitovnici, kteráž má býti na ní, i všelijaké nádobí stánku; ");
INSERT INTO ces1613_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Stůl také a nádoby k němu, i svícen čistý se všemi nádobami jeho, a oltář pro kadění; ");
INSERT INTO ces1613_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Též oltář k zápalům se všemi nádobami jeho, a umyvadlo s podstavkem jeho; ");
INSERT INTO ces1613_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","I roucha k službě, i roucha svatá Aronovi knězi, i roucha synů jeho, aby mi úřad kněžský konali; ");
INSERT INTO ces1613_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","I olej pomazání a kadidlo vonné do svatyně. Všecko tak, jakž jsem přikázal tobě, udělají. ");
INSERT INTO ces1613_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Ty pak mluv k synům Izraelským a rci: A však sobot mých ostříhati budete. Nebo to znamením jest mezi mnou a vámi po rodech vašich, aby známo bylo, že já jsem Hospodin, kterýž vás posvěcuji. ");
INSERT INTO ces1613_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Protož ostříhati budete soboty, nebo svatá jest vám. Kdož by ji poškvrnil, smrtí umře; a kdo by koli dělal v ní dílo, vyhlazena bude ta duše z prostředku lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Šest dní děláno bude dílo, ale v den sedmý sobota odpočinutí jest, svatost Hospodinu. Každý, kdož by dělal dílo v den sobotní, smrtí umře. ");
INSERT INTO ces1613_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Protož ostříhati budou synové Izraelští soboty, tak aby světili sobotu po rodech svých smlouvou věčnou. ");
INSERT INTO ces1613_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Mezi mnou a syny Izraelskými za znamení jest na věčnost; nebo šest dní činil Hospodin nebe i zemi, v den pak sedmý přestal a odpočinul. ");
INSERT INTO ces1613_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","I dal Pán Mojžíšovi po dokonání těchto řečí s ním na hoře Sinai dvě dsky svědectví, dsky kamenné, psané prstem Božím. ");
INSERT INTO ces1613_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Vida pak lid, že by prodléval Mojžíš sstoupiti s hůry, sebrali se proti Aronovi a řekli jemu: Vstaň, udělej nám bohy, kteříž by šli před námi; nebo Mojžíšovi, muži tomu, kterýž vyvedl nás z země Egyptské, nevíme, co se přihodilo. ");
INSERT INTO ces1613_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","I řekl jim Aron: Odejměte náušnice zlaté, kteréž jsou na uších žen vašich, synů vašich i dcer vašich, a přineste ke mně. ");
INSERT INTO ces1613_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tedy strhl všecken lid náušnice zlaté, kteréž byly na uších jejich, a přinesli k Aronovi. ");
INSERT INTO ces1613_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kteréžto vzav z rukou jejich, dal je do formy, a udělal z nich tele slité. I řekli: Tito jsou bohové tvoji, Izraeli, kteříž tě vyvedli z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Což vida Aron, vzdělal oltář před ním. I volal Aron, a řekl: Slavnost Hospodinova zítra bude. ");
INSERT INTO ces1613_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","A nazejtří vstavše velmi ráno, obětovali zápaly, a přivedli oběti pokojné. I sedl lid, aby jedl a pil, potom vstali, aby hrali. ");
INSERT INTO ces1613_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mluvil pak Hospodin k Mojžíšovi: Jdi, sstup, nebo porušil se lid tvůj, kterýž jsi vyvedl z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Sešli brzo s cesty, kterouž jsem přikázal jim. Udělali sobě tele slité, a klaněli se mu, a obětovali jemu, řkouce: Tito jsou bohové tvoji, Izraeli, kteříž tě vyvedli z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Řekl také Hospodin Mojžíšovi: Viděl jsem lid tento, a aj, lid jest tvrdé šíje. ");
INSERT INTO ces1613_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Protož nyní nech mne, abych v hněvě prchlivosti své vyhladil je, tebe pak učiním v národ veliký. ");
INSERT INTO ces1613_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","I modlil se Mojžíš Hospodinu Bohu svému, a řekl: Pročež, ó Hospodine, rozněcuje se prchlivost tvá na lid tvůj, kterýž jsi vyvedl z země Egyptské v síle veliké a v ruce mocné? ");
INSERT INTO ces1613_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","A proč mají mluviti Egyptští, řkouce: Lstivě je vyvedl, aby zmordoval je na horách, a aby vyhladil je se svrchku země? Odvrať se od hněvu prchlivosti své, a lituj zlého, kteréžs uložil uvésti na lid svůj. ");
INSERT INTO ces1613_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Rozpomeň se na Abrahama, Izáka a Izraele, služebníky své, jimž jsi zapřisáhl skrze sebe samého a mluvil jsi jim: Rozmnožím símě vaše jako hvězdy nebeské, a všecku zemi tuto, o kteréž jsem mluvil, dám semeni vašemu, a dědičně obdržíte ji na věky. ");
INSERT INTO ces1613_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","I litoval Hospodin zlého, kteréž řekl, že učiní lidu svému. ");
INSERT INTO ces1613_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","A obrátiv se Mojžíš, sstoupil s hůry, dvě dsky svědectví maje v rukou svých, dsky po obou stranách psané; s jedné i s druhé strany byly popsané. ");
INSERT INTO ces1613_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","A dsky ty dílo Boží byly; písmo také písmo Boží bylo vyryté na dskách. ");
INSERT INTO ces1613_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Uslyšev pak Jozue hlas lidu křičícího, řekl Mojžíšovi: Hřmot boje v táboru jest. ");
INSERT INTO ces1613_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Kterýžto odpověděl: Není to křik vítězících, ani křik poražených, hlas zpívajících já slyším. ");
INSERT INTO ces1613_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","I stalo se, když se přiblížil k stanům, že uzřel tele a tance. A rozhněvav se Mojžíš velmi, povrhl z rukou svých dsky, a rozrazil je pod Horou. ");
INSERT INTO ces1613_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Vzal také tele, kteréž byli udělali, a spálil je v ohni, a setřel je až na prach, a vsypav na vodu, dal píti synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","A řekl Mojžíš Aronovi: Coť učinil lid tento, že jsi uvedl na něj hřích veliký? ");
INSERT INTO ces1613_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Odpověděl Aron: Nehněvej se, pane můj. Ty víš, že lid tento k zlému nakloněn jest. ");
INSERT INTO ces1613_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Nebo řekli mi: Udělej nám bohy, kteříž by šli před námi; nebo Mojžíšovi, muži tomu, kterýž vyvedl nás z země Egyptské, nevíme, co se stalo. ");
INSERT INTO ces1613_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Jimž jsem odpověděl: Kdo má zlato, strhněte je s sebe. I dali mi, a uvrhl jsem je do ohně, a udělalo se to tele. ");
INSERT INTO ces1613_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","A vida Mojžíš lid obnažený, že obnažil jej Aron ku potupě před nepřátely, kteříž povstati měli proti nim, ");
INSERT INTO ces1613_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Stoje v bráně táboru, řekl: Kdo jest Hospodinův, přistup ke mně. I shromáždili se k němu všickni synové Léví. ");
INSERT INTO ces1613_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Jimž řekl: Tak praví Hospodin Bůh Izraelský: Připaš jeden každý meč svůj k boku svému; přejděte sem i tam od brány táboru k bráně, a zabí jeden každý bratra svého, a každý přítele svého i bližního svého. ");
INSERT INTO ces1613_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","I učinili synové Léví podlé řeči Mojžíšovy, a padlo jich v ten den z lidu na tři tisíce mužů. ");
INSERT INTO ces1613_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nebo řekl byl Mojžíš: Posvěťtež dnes rukou svých Hospodinu, jeden každý na synu svém a na bratru svém, aby vám dal dnes požehnání. ");
INSERT INTO ces1613_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","A když bylo nazejtří, řekl Mojžíš lidu: Vy jste zhřešili hříchem velikým. Protož nyní vstoupím k Hospodinu, zda bych ho ukrotil pro hřích váš. ");
INSERT INTO ces1613_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tedy navrátiv se Mojžíš k Hospodinu, řekl: Prosím, zhřešilť jest lid ten hříchem velikým; nebo udělali sobě bohy zlaté. ");
INSERT INTO ces1613_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nyní pak neb odpusť hřích jejich, a pakli nic, vymaž mne, prosím, z knihy své, kteroužs psal. ");
INSERT INTO ces1613_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","I řekl Hospodin Mojžíšovi: Kdo zhřešil proti mně, toho vymaži z knihy své. ");
INSERT INTO ces1613_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Protož nyní jdi, veď lid tento, kamž jsem rozkázal tobě. Aj, anděl můj půjde před tebou; v den pak navštívení mého navštívím i na nich hřích jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","I bil Hospodin lid, proto že učinili tele, kteréž byl udělal Aron. ");
INSERT INTO ces1613_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","I mluvil Hospodin k Mojžíšovi: Jdi, vstup odsud, ty i lid, kterýž jsi vyvedl z země Egyptské do země, kterouž jsem přisáhl Abrahamovi, Izákovi a Jákobovi, řka: Semeni tvému dám ji, ");
INSERT INTO ces1613_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","(A pošli před tebou anděla, a vyženu Kananea, Amorea, Hetea, Ferezea, Hevea a Jebuzea,) ");
INSERT INTO ces1613_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Do země oplývající mlékem a strdí. Neboť sám nevstoupím s tebou, proto že lid tvrdé šíje jsi, abych nezahubil tebe na cestě. ");
INSERT INTO ces1613_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","A uslyšav lid řeč tuto přezlou, zámutek nesli, aniž vzal kdo okrasy své na sebe. ");
INSERT INTO ces1613_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nebo byl řekl Hospodin Mojžíšovi: Mluv synům Izraelským: Vy jste lid tvrdé šíje; jakž jen jedinou vstoupím mezi vás, zahladím vás. Protož již, slož okrasu svou s sebe, a zvím, co učiniti mám s tebou. ");
INSERT INTO ces1613_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","I svlékli s sebe synové Izraelští okrasy své u hory Oréb. ");
INSERT INTO ces1613_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mojžíš pak vzav stánek, rozbil jej sobě vně za stany, vzdáliv se od táboru, a nazval jej stánkem úmluvy. Tedy kdokoli hledal Hospodina, ven choditi musil k stánku úmluvy, kterýž byl vně za stany. ");
INSERT INTO ces1613_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","K tomu také, když vycházel Mojžíš k stánku, povstával všecken lid a stál každý u dveří stanu svého, a hleděli za Mojžíšem, dokudž nevšel do stánku. ");
INSERT INTO ces1613_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Bývalo pak toto, že když vcházíval Mojžíš do stánku, sstupoval sloup oblakový, a stával u dveří stánku, a mluvil s Mojžíšem. ");
INSERT INTO ces1613_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","A všecken lid vida sloup oblakový, an stojí u dveří stánku, povstávali všickni, a klaněli se každý u dveří stanu svého. ");
INSERT INTO ces1613_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","A mluvíval Hospodin k Mojžíšovi tváří v tvář, tak jako mluví člověk s přítelem svým. Potom navracel se do táboru, ale služebník jeho Jozue, syn Nun, mládenec, neodcházel z stánku. ");
INSERT INTO ces1613_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","I řekl Mojžíš Hospodinu: Pohleď, ty velíš mi, abych vedl lid tento, a neoznámils mi, koho pošleš se mnou, ještos pravil: Znám tě ze jména, k tomu také nalezl jsi milost přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Již tedy, jestliže jsem jen nalezl milost před tebou, oznam mi, prosím, cestu svou, abych tě poznal, a abych nalezl milost před tebou; a pohleď, že národ tento jest lid tvůj. ");
INSERT INTO ces1613_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","I odpověděl: Tvář má předcházeti vás bude, a dámť odpočinutí. ");
INSERT INTO ces1613_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","I řekl: Nemá-liť předcházeti nás tvář tvá, nevyvozuj nás odsud. ");
INSERT INTO ces1613_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nebo po čem poznáno bude zde, že jsem nalezl milost před tebou, já i lid tvůj? Zdali ne po tom, když půjdeš s námi, a když odděleni budeme, já a lid tvůj, ode všeho lidu, kterýž jest na tváři země? ");
INSERT INTO ces1613_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","I řekl Hospodin Mojžíšovi: I tu také věc, kterouž jsi pravil, učiním; nebo jsi nalezl milost přede mnou, a znám tě ze jména. ");
INSERT INTO ces1613_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Řekl opět: Okažiž mi, prosím, slávu svou. ");
INSERT INTO ces1613_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kterýž odpověděl: Já způsobím to, aby šlo mimo tebe před tváří tvou všecko dobré mé, a zavolám ze jména: Hospodin před tváří tvou. Smiluji se, nad kýmž se smiluji, a slituji se, nad kýmž se slituji. ");
INSERT INTO ces1613_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Řekl také: Nebudeš moci viděti tváři mé; neboť neuzří mne člověk, aby živ zůstal. ");
INSERT INTO ces1613_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","I to řekl Hospodin: Aj, místo u mne, a staneš na skále. ");
INSERT INTO ces1613_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","A když tudy půjde sláva má, postavím tě v rozsedlině skály, a přikryji tě rukou svou, dokudž nepřejdu. ");
INSERT INTO ces1613_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Potom odejmu ruku svou, i uzříš hřbet můj, ale tvář má nebude spatřína. ");
INSERT INTO ces1613_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","I řekl Hospodin k Mojžíšovi: Vyteš sobě dvě dsky kamenné podobné prvním, a napíši na dskách těch slova, kteráž byla na dskách prvních, kteréž jsi rozrazil. ");
INSERT INTO ces1613_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Budiž tedy hotov ráno, a vstoupíš v jitře na horu Sinai, a staneš přede mnou na vrchu hory té. ");
INSERT INTO ces1613_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Žádný ať nevstupuje s tebou, aniž také kdo vidín bude na vší hoře; ani ovce neb volové pásti se budou naproti hoře této. ");
INSERT INTO ces1613_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Tedy Mojžíš vytesal dvě dsky kamenné podobné prvním, a vstav ráno, vstoupil na horu Sinai, jakž mu přikázal Hospodin, a vzal v ruku svou dvě dsky kamenné. ");
INSERT INTO ces1613_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","I sstoupil Hospodin v oblaku, a stál s ním tam, a zavolal ze jména: HOSPODIN. ");
INSERT INTO ces1613_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nebo pomíjeje Hospodin tvář jeho, volal: Hospodin, Hospodin, Bůh silný, lítostivý a milostivý, dlouhočekající a hojný v milosrdenství a pravdě, ");
INSERT INTO ces1613_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Milosrdenství čině tisícům, odpouštěje nepravost a přestoupení i hřích, a kterýž nikoli neospravedlňuje vinného, navštěvuje nepravost otců na synech, a na synech synů do třetího i čtvrtého pokolení. ");
INSERT INTO ces1613_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mojžíš pak rychle sklonil hlavu k zemi, a poklonu učinil. ");
INSERT INTO ces1613_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","A řekl: Prosím, našel-li jsem milost v očích tvých, Pane, nechť jde, prosím, Pán u prostřed nás, nebo lid jest tvrdé šíje, a milostiv buď nepravosti naší a hříchu našemu, a měj nás za dědictví. ");
INSERT INTO ces1613_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kterýžto řekl: Aj, já učiním smlouvu přede vším lidem tvým. Učiním divné věci, kteréž nejsou učiněny na vší zemi a ve všech národech, a viděti bude všecken lid, (mezi nimiž jsi,) skutky Hospodinovy; nebo hrozné bude to, což já učiním s tebou. ");
INSERT INTO ces1613_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Zachovej to, což já dnes tobě přikazuji. Aj, já vyženu před tváří tvou Amorea a Kananea, Hetea a Ferezea, Hevea a Jebuzea. ");
INSERT INTO ces1613_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Varuj se pak, abys nečinil smlouvy s obyvateli země té, do kteréž vejdeš, ať by nebyli osídlem u prostřed tebe. ");
INSERT INTO ces1613_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ale zboříte oltáře jejich, a modly jejich polámete, a jejich háje posekáte. ");
INSERT INTO ces1613_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Nebo nebudeš se klaněti Bohu jinému, proto že Hospodin jest, jméno má horlivý, Bůh silný, horlivý jest. ");
INSERT INTO ces1613_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Nevcházej v smlouvu s obyvateli země té, aby když by smilnili, jdouce po bozích svých, a obětovali bohům svým, nepovolali tě, a jedl bys z oběti jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","A abys nebral ze dcer jeho synům svým, i smilnily by dcery jejich, jdouce po bozích svých, a naučily by smilniti syny tvé, jdouce po bozích svých. ");
INSERT INTO ces1613_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Bohů slitých neuděláš sobě. ");
INSERT INTO ces1613_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Slavnost přesnic zachovávati budeš. Za sedm dní jísti budeš chleby nekvašené, jakž jsem přikázal tobě, v čas vyměřený měsíce Abib; nebo měsíce toho vyšel jsi z Egypta. ");
INSERT INTO ces1613_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Všecko což otvírá život, mé jest, i všeliký samec v dobytku tvém, prvorozený z volů a ovcí. ");
INSERT INTO ces1613_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ale prvorozené osle vyplatíš dobytčetem; pakli bys nevyplatil, šíji zlomíš jemu. Každého prvorozeného z synů svých vyplatíš, aniž ukáží se přede mnou prázdní. ");
INSERT INTO ces1613_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Šest dní pracovati budeš, dne pak sedmého přestaneš; v čas orání i žně přestaneš. ");
INSERT INTO ces1613_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","A učiníš sobě slavnost téhodnů, svátek prvotin žně pšeničné a slavnost klizení po vyjití každého roku. ");
INSERT INTO ces1613_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Třikrát v roce ukáže se každý z vás pohlaví mužského před oblíčejem Panovníka Hospodina, Boha Izraelského. ");
INSERT INTO ces1613_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nebo vyvrhu národy od tváři tvé a rozšířím meze tvé, aniž kdo sáhne na zemi tvou, když vstoupíš, abys se ukázal před Hospodinem Bohem svým třikrát v roce. ");
INSERT INTO ces1613_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Nebudeš obětovati krve oběti mé, dokavadž u tebe kvas jest, aniž zůstane do jitra obět slavnosti Fáze. ");
INSERT INTO ces1613_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Prvotiny prvních úrod země své přinášeti budeš do domu Hospodina Boha svého. Nebudeš vařiti kozelce v mléce matky jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","I řekl Hospodin Mojžíšovi: Napiš sobě slova tato; nebo podlé slov těch učinil jsem smlouvu s tebou a s Izraelem. ");
INSERT INTO ces1613_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Byl pak tam s Hospodinem čtyřidceti dní a čtyřidceti nocí, chleba nejedl a vody nepil; a napsal na dskách slova té smlouvy, totiž deset slov. ");
INSERT INTO ces1613_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","I stalo se, když sstupoval Mojžíš s hory Sinai, (a měl dvě dsky svědectví v rukou svých, když sstupoval s hory), nevěděl, že by se stkvěla kůže tváři jeho, když mluvil s ním. ");
INSERT INTO ces1613_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","A viděl Aron i všickni synové Izraelští Mojžíše, a aj, stkvěla se kůže tváři jeho, a nesměli přistoupiti k němu. ");
INSERT INTO ces1613_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ale Mojžíš zavolal jich, a navrátili se k němu Aron i všecka knížata shromáždění toho, a mluvil Mojžíš s nimi. ");
INSERT INTO ces1613_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Potom přišli také k němu všickni synové Izraelští, jimžto přikázal všecko, což s ním mluvil Hospodin na hoře Sinai. ");
INSERT INTO ces1613_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Dokudž pak mluvil Mojžíš s nimi, měl zástěru na tváři své. ");
INSERT INTO ces1613_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ale když vcházel Mojžíš před tvář Hospodina, aby mluvil s ním, odjímal zástěru, dokudž nevyšel. Vyšed pak, mluvil synům Izraelským, což mu bylo rozkázáno. ");
INSERT INTO ces1613_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Tedy viděli synové Izraelští tvář Mojžíšovu, že se stkvěla kůže tváři jeho. A kladl zase Mojžíš zástěru na tvář svou, dokudž nevcházel, aby mluvil s ním. ");
INSERT INTO ces1613_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Tedy svolal Mojžíš všecko shromáždění synů Izraelských, a řekl jim: Tato jsou slova, kteráž přikázal vám Hospodin, abyste je činili. ");
INSERT INTO ces1613_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Šest dní děláno bude dílo, ale v sedmý den mějte svátek, sobotu odpočinutí Hospodinova. Kdo by dělal v něm dílo, umře. ");
INSERT INTO ces1613_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Nezanítíte ohně nikdež v příbytcích svých v den sobotní. ");
INSERT INTO ces1613_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mluvil také Mojžíš ke všemu shromáždění synů Izraelských takto: Toto jest slovo, kteréž přikázal Hospodin, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Sebeřte z sebe obět pozdvižení Hospodinu. Každý, kdož jest ochotný v srdci svém, přinese tu obět Hospodinu: Zlato, stříbro a měď, ");
INSERT INTO ces1613_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","A postavec modrý, a šarlat, a červec dvakrát barvený, a bílé hedbáví, a kozí srsti; ");
INSERT INTO ces1613_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Též kůže skopců na červeno barvené, a kůže jezevčí, a dříví setim, ");
INSERT INTO ces1613_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","A olej k svícení a vonné věci na olej ku pomazání a pro kadění vonné, ");
INSERT INTO ces1613_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","A kamení onychinové, a jiné kamení k vsazování do náramenníku a náprsníku. ");
INSERT INTO ces1613_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","A všickni, kdož jsou vtipní mezi vámi, přijdou a dělati budou, cožkoli přikázal Hospodin: ");
INSERT INTO ces1613_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Příbytek, stánek jeho i přikrytí jeho a háky jeho, dsky jeho, svlaky jeho, sloupy jeho i podstavky jeho; ");
INSERT INTO ces1613_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Truhlu s sochory jejími, slitovnici a oponu zastření; ");
INSERT INTO ces1613_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Stůl i sochory k němu se všemi nádobami jeho, i chléb předložení; ");
INSERT INTO ces1613_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","A svícen k svícení s nádobami jeho i lampy jeho, a olej k svícení; ");
INSERT INTO ces1613_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Též oltář pro kadění a sochory jeho, i olej pomazání a kadidlo z vonných věcí, i zastření dveří v příbytku; ");
INSERT INTO ces1613_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Oltář k zápalu a rošt jeho měděný a sochory jeho, i všecka nádobí jeho, i umyvadlo s podstavkem jeho; ");
INSERT INTO ces1613_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Koltry očkovaté k síni, sloupy její a podstavky její, i zastření brány do síně; ");
INSERT INTO ces1613_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Kolíky k příbytku, a kolíky síně s provázky jejich; ");
INSERT INTO ces1613_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Roucha k službě, k přisluhování v svatyni, i roucho svaté Arona kněze, i roucho synů jeho k konání úřadu kněžského. ");
INSERT INTO ces1613_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Vyšlo tedy všecko shromáždění synů Izraelských od tváři Mojžíšovy, ");
INSERT INTO ces1613_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","A přišli, každý muž, kteréhož ponuklo srdce jeho, a každý, v němž duch jeho byl dobrovolný, a přinesli obět pozdvižení Hospodinu, k dílu stánku úmluvy a ke vší službě jeho, i k rouchu svatému. ");
INSERT INTO ces1613_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Přicházeli muži i ženy, každý, kdož byl ochotný v srdci, a přinášeli spinadla, a náušnice, a prsteny, a záponky z pravých rukou, všelijaké nádobí zlaté, a kdožkoli obětoval obět zlata Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Každý, kdož měl postavec modrý a šarlat, a červec dvakrát barvený, a bílé hedbáví a kozí srsti, a kůže skopců na červeno barvené, a kůže jezevčí, přinesl to. ");
INSERT INTO ces1613_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Kdokoli obětoval obět stříbra a mědi, přinášeli to za obět pozdvižení Hospodinu; každý také, kdo měl dříví setim, ke všelikému dílu služebnosti, přinášeli je. ");
INSERT INTO ces1613_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ano i všecky ženy vtipné rukama svýma předly, a přinesly, co napředly, postavec modrý a šarlat, a červec dvakrát barvený a bílé hedbáví. ");
INSERT INTO ces1613_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Všecky pak ženy, kterýchž ponuklo srdce jejich, aby předly uměle, předly srsti kozí. ");
INSERT INTO ces1613_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Knížata pak přinášeli kamení onychinové, a jiné kamení k vsazování do náramenníku a náprsníku, ");
INSERT INTO ces1613_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Též vonné věci a olej k svícení, a k oleji pomazání, a k vonnému kadidlu. ");
INSERT INTO ces1613_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Každý muž i žena, v nichž ochotné srdce jejich bylo k tomu, aby přinášeli potřeby ke všelikému dílu, kteréž byl přikázal dělati Hospodin skrze Mojžíše, přinášeli synové Izraelští obět dobrovolnou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Tedy řekl Mojžíš synům Izraelským: Pohleďte, povolal ze jména Hospodin Bezeleele, syna Uri, syna Hur, z pokolení Judova. ");
INSERT INTO ces1613_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","A naplnil ho duchem Božím, moudrostí, rozumností i uměním všelijakého řemesla, ");
INSERT INTO ces1613_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Aby vtipně smysliti uměl, jak by se co dělati mělo na zlatu a stříbru a mědi, ");
INSERT INTO ces1613_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","I v řemeslném strojení kamenů k vsazování, i v díle od dřeva, aby dělal všelijakým řemeslem vtipným. ");
INSERT INTO ces1613_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Dal nadto v srdce jeho i to, aby učiti mohl on i Aholiab, syn Achisamechův z pokolení Dan. ");
INSERT INTO ces1613_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Naplnil je moudrostí srdce, aby dělali všelijaké dílo tesařské a řemeslné, i krumpéřské a vytkávané z postavce modrého a šarlatu, a červce dvakrát barveného, a bílého hedbáví, a aby dělali všelijaké dílo a vymýšleli vtipné věci. ");
INSERT INTO ces1613_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Tedy dělal Bezeleel a Aholiab i všeliký muž vtipný, jimž dal Hospodin moudrost a rozumnost, aby uměli dělati všeliké dílo k službě svatyně, všecko, což přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Povolal pak Mojžíš Bezeleele a Aholiaba i každého muže vtipného, v jehož srdce dal Hospodin moudrost, každého také, kohož ponoukalo srdce jeho, aby přistoupil ku práci díla toho. ");
INSERT INTO ces1613_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","A vzali od Mojžíše všecky dary, kteréž přinesli synové Izraelští k dílu služebnému svatyně, aby dělali je. Ale oni vždy předce přinášeli k němu každého jitra dary dobrovolné. ");
INSERT INTO ces1613_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Tedy přišli všickni vtipní dělníci díla svatyně, každý od díla svého, kteréž dělali, ");
INSERT INTO ces1613_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","A mluvili k Mojžíšovi těmi slovy: Mnohem více přináší lid, nežli potřebí jest k dělání díla, kteréž přikázal Hospodin dělati. ");
INSERT INTO ces1613_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","I rozkázal Mojžíš, aby provoláno bylo v vojště takto: Muž ani žena, žádný nepřinášej více oběti k svatyni. I zbráněno jest lidu, aby nenosili. ");
INSERT INTO ces1613_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Nebo měli potřeb hojně dosti k dělání všelikého díla, tak že zbývalo. ");
INSERT INTO ces1613_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","I dělal každý vtipný z dělníků těch dílo to, příbytek z desíti čalounů, kteříž byli z bílého hedbáví přesukovaného, a z postavce modrého a šarlatu, a z červce dvakrát barveného, cherubíny dílem řemeslným udělal na nich. ");
INSERT INTO ces1613_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Dlouhost čalounu jednoho osm a dvadceti loktů, a čtyř loktů širokost čalounu jednoho; všickni čalounové byli jednostejné míry. ");
INSERT INTO ces1613_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Potom spojil pět čalounů jeden s druhým, a pět jiných čalounů spojil jeden s druhým. ");
INSERT INTO ces1613_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Nadělal i ok z hedbáví modrého po kraji čalounu jednoho na konci, kde se spojovati má s druhým, a tolikéž udělal na kraji čalounu druhého na konci v spojení druhém. ");
INSERT INTO ces1613_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Padesáte ok udělal na čalounu jednom, a padesáte ok udělal po kraji čalounu, kterýmž připojen byl k druhému; oko jedno proti druhému bylo. ");
INSERT INTO ces1613_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Udělal i padesáte haklíků zlatých a spojil čalouny jeden s druhým haklíky těmi; a tak udělán jest příbytek jeden. ");
INSERT INTO ces1613_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nadto nadělal houní z srstí kozích na stánek, k přistírání příbytku po vrchu; jedenácte houní udělal. ");
INSERT INTO ces1613_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dlouhost houně jedné třidceti loktů, a širokost houně jedné čtyř loktů; jednostejná míra byla těch jedenácti houní. ");
INSERT INTO ces1613_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","A spojil pět houní obzvláštně, a šest houní obzvláštně. ");
INSERT INTO ces1613_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Udělal také padesáte ok po kraji houně na konci, kdež se spojovati má, a padesáte ok udělal po kraji houně v spojení druhém. ");
INSERT INTO ces1613_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Udělal k tomu haklíků měděných padesáte k spojení stánku, aby byl jedno. ");
INSERT INTO ces1613_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Nadto udělal přikrytí stánku z koží skopcových na červeno barvených, a přikrytí z koží jezevčích svrchu. ");
INSERT INTO ces1613_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Nadělal k příbytku i desk z dříví setim stojatých. ");
INSERT INTO ces1613_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Desíti loktů dlouhost dsky, a půl druhého širokost dsky každé. ");
INSERT INTO ces1613_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Dva čepy měla dska jedna, podobně jako stupně u schodu spořádané, jeden proti druhému; tak udělal u všech desk příbytku. ");
INSERT INTO ces1613_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Zdělal i dsky k příbytku, dvadceti desk k straně polední, k větru polednímu. ");
INSERT INTO ces1613_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","A čtyřidceti podstavků stříbrných udělal pode dvadceti desk, dva podstavky pod jednu dsku ke dvěma čepům jejím, a dva podstavky pod dsku druhou pro dva čepy její. ");
INSERT INTO ces1613_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Na druhé pak straně příbytku k straně půlnoční udělal dvadceti desk, ");
INSERT INTO ces1613_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","A čtyřidceti podstavků jejich stříbrných, dva podstavky pod jednu dsku a dva podstavky pod dsku druhou. ");
INSERT INTO ces1613_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Na straně pak příbytku k západu udělal šest desk. ");
INSERT INTO ces1613_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Dvě dsky udělal v úhlech po obou stranách příbytku. ");
INSERT INTO ces1613_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","A byly spojené po spodu a tolikéž spojené svrchu k jednomu kruhu; tak udělal po obou stranách ve dvou úhlech. ");
INSERT INTO ces1613_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","A tak bylo osm desk a podstavků jejich stříbrných šestnácte, dva podstavkové pod každou dskou. ");
INSERT INTO ces1613_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Nadělal i svlaků z dřívi setim, pět ke dskám straně příbytku jedné, ");
INSERT INTO ces1613_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","A pět svlaků ke dskám druhé strany příbytku, a pět svlaků ke dskám strany příbytku západní, dosahujících k oběma úhlům. ");
INSERT INTO ces1613_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","A svlak prostřední udělal, aby šel po prostředku desk od jednoho kraje k druhému. ");
INSERT INTO ces1613_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Dsky pak obložil zlatem a kruhy jejich udělal z zlata, aby v nich svlaky byly; a obložil svlaky zlatem. ");
INSERT INTO ces1613_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Udělal také oponu z postavce modrého a šarlatu, a z červce dvakrát barveného, a z bílého hedbáví přesukovaného; dílem řemeslným udělal ji s figurami cherubínů. ");
INSERT INTO ces1613_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","A udělal pro ni čtyři sloupy z dříví setim, a obložil je zlatem; hákové pak jejich byli zlatí, a slil k nim čtyři podstavky stříbrné. ");
INSERT INTO ces1613_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Udělal také zastření ke dveřům stánku z postavce modrého, z šarlatu a z červce dvakrát barveného a z bílého hedbáví přesukovaného, dílem krumpéřským, ");
INSERT INTO ces1613_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","A sloupů k tomu zastření pět s háky jejich, (obložil pak makovice a přepásaní jich zlatem), a podstavků pět měděných. ");
INSERT INTO ces1613_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Udělal také Bezeleel truhlu z dříví setim, jejíž dlouhost byla půl třetího lokte, a půl druhého lokte širokost, vysokost také půl druhého lokte. ");
INSERT INTO ces1613_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A obložil ji zlatem čistým vnitř i zevnitř, a udělal jí korunu zlatou vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Slil jí také čtyři kruhy zlaté ke čtyřem úhlům jejím, dva totiž kruhy po jedné straně její, a dva kruhy po druhé straně její. ");
INSERT INTO ces1613_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Zdělal i sochory z dříví setim a obložil je zlatem. ");
INSERT INTO ces1613_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A uvlékl sochory do kruhů po stranách truhly; aby na nich nošena byla truhla. ");
INSERT INTO ces1613_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Udělal také slitovnici z zlata čistého. Půl třetího lokte byla dlouhost její, a půl druhého lokte širokost její. ");
INSERT INTO ces1613_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Udělal i dva cherubíny z zlata, z taženého zlata udělal je na dvou koncích slitovnice, ");
INSERT INTO ces1613_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Cherubína jednoho na jednom konci a cherubína druhého na druhém konci; na slitovnici udělal cherubíny, na obou koncích jejích. ");
INSERT INTO ces1613_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ti pak cherubínové měli křídla vztažená svrchu nad ní, zastírajíce křídly svými slitovnici; a tváři jejich byly obráceny jedna k druhé, k slitovnici byly obráceny tváři cherubínů. ");
INSERT INTO ces1613_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Udělal i stůl z dříví setim. Dvou loket byla dlouhost jeho a na loket širokost jeho, půl druhého pak lokte vysokost. ");
INSERT INTO ces1613_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","A obložil jej zlatem čistým, i korunu zlatou udělal mu vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Udělal mu i lištu dlani zšíří vůkol, a udělal korunu zlatou okolo té lišty. ");
INSERT INTO ces1613_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Slil také k němu čtyři kruhy zlaté a vpustil je do čtyř úhlů, kteříž byli na čtyřech nohách jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Proti té liště byli kruhové, skrze něž by provlačováni byli sochorové k nošení stolu. ");
INSERT INTO ces1613_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Udělal i sochory z dříví setim, kteréžto obložil zlatem k nošení stolu. ");
INSERT INTO ces1613_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","A zdělal nádoby, kteréž byly na stole, misy jeho a lžice jeho, a koflíky jeho, a přikryvadla k přikrývání z čistého zlata. ");
INSERT INTO ces1613_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Udělal také svícen z zlata čistého, z taženého zlata udělal svícen; sloupec jeho i prutové jeho, misky jeho, koule jeho i květové jeho z něho byli. ");
INSERT INTO ces1613_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Šest pak prutů bylo po stranách jeho, tři prutové s jedné strany jeho, a tři prutové s druhé strany jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Tři misky na způsob pecky mandlové udělány byly na prutu jednom, a koule a květ, a tři misky na způsob pecky mandlové udělány na prutu druhém, a koule a květ; tak i na jiných šesti prutech z svícnu vycházejících. ");
INSERT INTO ces1613_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na svícnu také byly čtyři misky, udělané na způsob mandlové pecky, a koule jeho i květové jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","A byla koule pode dvěma pruty z něho, a koule druhá pode dvěma pruty z něho, a koule třetí pode dvěma pruty z něho, a tak pod šesti pruty vycházejícími z něho. ");
INSERT INTO ces1613_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Koule jejich i prutové jejich z něho byli, všecko hned jedním tažením z zlata čistého. ");
INSERT INTO ces1613_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Udělal i lamp jeho sedm, i utěradla jeho, i nádoby k oharkům jeho z zlata čistého. ");
INSERT INTO ces1613_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Z centnéře zlata čistého udělal jej se vším tím nádobím. ");
INSERT INTO ces1613_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Udělal také oltář pro kadění z dříví setim, lokte zdélí a lokte zšíří, čtverhraný, dvou pak loket zvýší; z něho byli rohové jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A obložil jej zlatem čistým, svrchek jeho i po stranách vůkol, i rohy jeho; a udělal mu korunu zlatou vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Po dvou podobně kruzích zlatých udělal u něho, pod korunou ve dvou úhlech jeho, po dvou stranách jeho, skrze něž by provlačováni byli sochorové, aby nošen byl na nich. ");
INSERT INTO ces1613_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A zdělal ty sochory z dříví setim, a obložil je zlatem. ");
INSERT INTO ces1613_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nadělal také oleje pomazání svatého, a kadidla z vonných věcí, čistého, dílem apatykářským. ");
INSERT INTO ces1613_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Udělal také oltář k zápalu z dříví setim, pěti loket zdélí a pěti loket zšíří, čtverhraný, a tří loket zvýší. ");
INSERT INTO ces1613_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A zdělal mu rohy na čtyřech úhlech jeho; z něho byli rohové jeho, a obložil jej mědí. ");
INSERT INTO ces1613_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Nadělal také všelijakých nádob k oltáři, hrnců a lopat, a kotlíků a vidliček, a nádob jeho k uhlí; všecka nádobí jeho udělal měděná. ");
INSERT INTO ces1613_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Udělal k oltáři i rošt mřežovaný, měděný, pod okolkem oltáře dole, až do prostřed něho. ");
INSERT INTO ces1613_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","A slil čtyři kruhy na čtyřech krajích k roštu měděnému, v nichž by sochorové bývali. ");
INSERT INTO ces1613_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Sochory pak udělal z dříví setim a obložil je mědí. ");
INSERT INTO ces1613_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A uvlékl ty sochory do těch kruhů po obou stranách oltáře k nošení jeho na nich; prázdný z prken udělal jej. ");
INSERT INTO ces1613_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Udělal též umyvadlo měděné, a podstavek jeho měděný z zrcadel houfně přicházejících žen, kteréž přicházely ke dveřím stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Udělal také síň k straně polední; koltry očkovaté síně té z bílého hedbáví přesukovaného na sto loket, ");
INSERT INTO ces1613_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Sloupů jejich dvadceti, a k nim podstavků dvadceti z mědi, háky na sloupích, a přepásaní jejich z stříbra. ");
INSERT INTO ces1613_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tolikéž k straně půlnoční koltry na sto loket, sloupů k nim dvadceti a podstavků jejich dvadceti z mědi, háky na sloupích a přepásaní jejich z stříbra. ");
INSERT INTO ces1613_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","K straně pak západní koltry očkovaté na padesáte loket, sloupů k nim deset a podstavků jejich deset, háky na sloupích a přepásaní jejich z stříbra. ");
INSERT INTO ces1613_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","A v straně přední na východ padesáti loktů, ");
INSERT INTO ces1613_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Koltry očkovaté patnácti loktů byly při straně jedné, sloupové k nim tři, a podstavkové jejich tři. ");
INSERT INTO ces1613_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","A k straně druhé, u brány síně té, jakž tam, tak tuto, koltry očkovaté patnácti loktů, sloupové k nim tři a podstavkové jejich tři. ");
INSERT INTO ces1613_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Všecky koltry síně vůkol očkovaté z bílého hedbáví přesukovaného. ");
INSERT INTO ces1613_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Podstavkové pak sloupů z mědi, hákové na sloupích a přepásaní jich z stříbra, a obložení makovic jejich z stříbra; všickni také sloupové síně přepásáni byli stříbrem. ");
INSERT INTO ces1613_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Zastření pak brány síňce dílem krumpéřským z postavce modrého a šarlatu, a červce dvakrát barveného a hedbáví bílého přesukovaného; dlouhost jeho dvadceti loktů, výsost pak šířky pěti loktů, jako i jiných koltr síně očkovatých. ");
INSERT INTO ces1613_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","A sloupové k ní čtyři a podstavkové jejich čtyři z mědi, hákové jejich stříbrní, a obložení makovic jejich a přepásaní jejich z stříbra. ");
INSERT INTO ces1613_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Všickni pak kolíkové příbytku a síně vůkol byli z mědi. ");
INSERT INTO ces1613_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tyto jsou věci vyčtené k příbytku, příbytku svědectví, kteréž jsou vyčteny podlé rozkázaní Mojžíšova, skrze Itamara, syna Arona kněze, k službě Levítů. ");
INSERT INTO ces1613_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","A Bezeleel, syn Uri, syna Hur, z pokolení Juda, udělal všecky tyto věci, kteréž přikázal Hospodin Mojžíšovi; ");
INSERT INTO ces1613_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","A s ním Aholiab, syn Achisamechův z pokolení Dan, tesař a vtipný řemeslník, a krumpéř na modrém postavci a šarlatu, a červci dvakrát barveném a kmentu. ");
INSERT INTO ces1613_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Všeho zlata vynaloženého na samo dílo, na všecko dílo svatyně, (bylo pak zlato obětované), devět a dvadceti centnéřů, a sedm set třidceti lotů podlé váhy svatyně. ");
INSERT INTO ces1613_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Stříbra pak od těch, jenž náležejí ku počtu shromáždění, sto centnéřů, a tisíc sedm set sedmdesáte pět lotů podlé váhy svatyně. ");
INSERT INTO ces1613_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Půl lotu z každé hlavy podlé váhy svatyně, ode všech jdoucích v počet od dvadcíti let a výše, jichž bylo šestkrát sto tisíc, tři tisíce pět set a padesáte. ");
INSERT INTO ces1613_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","A bylo sto centnéřů stříbra k slévání podstavků svatyně a podstavků opony; sto podstavků ze sta centnéřů, centnéř do podstavku. ");
INSERT INTO ces1613_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A z tisíce sedmi set sedmdesáti pěti lotů udělal háky na sloupy, a obložil makovice jejich a přepásal je. ");
INSERT INTO ces1613_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Mědi pak obětované bylo sedmdesáte centnéřů a dva tisíce a čtyři sta lotů. ");
INSERT INTO ces1613_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","A udělal z ní podstavky ke dveřům stánku svědectví a oltář měděný, a rošt měděný k němu, a všecky nádoby oltáře, ");
INSERT INTO ces1613_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","A podstavky síně vůkol a podstavky brány síně, všecky také kolíky příbytku a všecky kolíky síňce vůkol. ");
INSERT INTO ces1613_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Z modrého pak postavce a šarlatu a červce dvakrát barveného udělali roucha k službě, k přisluhování v svatyni. Udělali i roucho svaté, kteréž by bylo Aronovi, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","A udělal náramenník z zlata, postavce modrého a šarlatu, a červce dvakrát barveného, a bílého hedbáví přesukovaného. ");
INSERT INTO ces1613_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","I nadělali plíšků zlatých, a nastříhali z nich nití, aby jimi províjeli skrze modrý postavec a šarlat, a červec dvakrát barvený a bílé hedbáví, dílem řemeslným. ");
INSERT INTO ces1613_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Náramky u něho udělali tak, aby se jeden s druhým spojiti mohl; na dvou krajích svých spojoval se. ");
INSERT INTO ces1613_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Přepásaní také náramenníka, kteréž bylo na něm, z týchž věcí bylo a týmž dílem, z zlata, postavce modrého a šarlatu a červce dvakrát barveného, a bílého hedbáví přesukovaného, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Přisadili i kamení onychinové, vložené a vsazené do zlata, řezané tak, jako ryty bývají pečeti, s jmény synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","A vložil je na vrchní kraje náramenníku, aby byli kamenové pro pamět na syny Izraelské, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Udělal i náprsník dílem řemeslným, takovým dílem jako náramenník, z zlata, postavce modrého a šarlatu, a červce dvakrát barveného, a bílého hedbáví přesukovaného. ");
INSERT INTO ces1613_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ètverhranatý byl; dvojnásobní udělali náprsník, na píd zdélí, a na píd zšíří, dvojnásobní. ");
INSERT INTO ces1613_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","A vysadili jej čtyřmi řady kamení drahého pořádkem tímto: Sardius, topazius a smaragdus v řadu prvním; ");
INSERT INTO ces1613_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","V řadu pak druhém karbunkulus, zafir a jaspis; ");
INSERT INTO ces1613_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","A v řadu třetím linkurius, achates a ametyst; ");
INSERT INTO ces1613_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","A v čtvrtém řadu chrysolit, onychin a beryl, vložení a vsazení do zlata v svém pořádku. ");
INSERT INTO ces1613_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Těch pak kamenů s jmény synů Izraelských bylo dvanácte vedlé jmen jejich, vyrytých, jako pečet ryta bývá, každý vedlé jména svého pro dvanáctero pokolení. ");
INSERT INTO ces1613_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Udělali i k náprsníku řetízky jednostejné, dílem točeným z zlata čistého. ");
INSERT INTO ces1613_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Udělali také dva haklíky zlaté, a dva kroužky zlaté, a připjali ty dva kroužky na dvou krajích náprsníku. ");
INSERT INTO ces1613_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","A prostrčili dva řetízky zlaté skrze dva kroužky na krajích náprsníku. ");
INSERT INTO ces1613_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Druhé pak dva konce dvou řetízků vpjali do dvou těch haklíků, a dali je na vrchní kraje náramenníku po předu. ");
INSERT INTO ces1613_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Udělali též dva kroužky zlaté, kteréž dali na dva kraje náprsníku, na té obrubě jeho, kteráž byla po straně náramenníka po spodu. ");
INSERT INTO ces1613_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Udělali ještě dva jiné kroužky zlaté, kteréž dali na dvě strany náramenníka zespod po předu, proti spojení jeho, kteréž jest nad přepásaním náramenníka. ");
INSERT INTO ces1613_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","I přivázali náprsník od kroužků jeho k kroužkům toho náramenníka tkanicí hedbáví modrého, aby byl nad přepásaním náramenníka, a aby neodevstával náprsník od náramenníka, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Udělal také plášť náležející k náramenníku, dílem vytkávaným, všecken z postavce modrého, ");
INSERT INTO ces1613_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","A díru u prostřed pláště, jako díra v pancíři; okolek byl po kraji jejím vůkol, aby se neroztrhl. ");
INSERT INTO ces1613_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Udělali také na podolku pláště jablka zrnatá z postavce modrého a šarlatu, a červce dvakrát barveného, a bílého hedbáví přesukovaného. ");
INSERT INTO ces1613_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nadělali i zvonečků z zlata čistého, a zzavěšovali zvonečky ty mezi jablky zrnatými u podolku pláště vůkol, u prostřed mezi jablky zrnatými; ");
INSERT INTO ces1613_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Zvonček a jablko zrnaté, opět za tím zvonček a jablko zrnaté u podolku pláště vůkol, k užívání toho při službě, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Potom udělali sukni z bílého hedbáví dílem vytkávaným, Aronovi a synům jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","I čepici z bílého hedbáví, a klobouky ozdobné z bílého hedbáví, a košilky tenké z bílého hedbáví přesukovaného, ");
INSERT INTO ces1613_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Pás také z bílého hedbáví přesukovaného, a postavce modrého a šarlatu, a červce dvakrát barveného, dílem krumpéřským, jakž byl přikázal Hospodin Mojžíšovi, ");
INSERT INTO ces1613_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Udělali i plech koruny svaté z zlata čistého, a napsali na něm písmo dílem vyrývajících pečeti: Svatost Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","A dali do něho tkanici z hedbáví modrého, aby přivázán byl k čepici na hoře, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","A tak dokonáno jest všecko dílo příbytku stánku úmluvy; a učinili synové Izraelští všecko, jakž přikázal Hospodin Mojžíšovi, tak učinili, ");
INSERT INTO ces1613_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","A přinesli příbytek ten k Mojžíšovi, stánek i všecka nádobí jeho, háky jeho, dsky jeho, svlaky jeho, i sloupy jeho a podstavky jeho, ");
INSERT INTO ces1613_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Přikrytí také z koží skopových na červeno barvených, a přikrytí z koží jezevčích i oponu zastření, ");
INSERT INTO ces1613_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Truhlu svědectví s sochory jejími i slitovnici, ");
INSERT INTO ces1613_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Stůl, všecka nádobí jeho i chléb předložení, ");
INSERT INTO ces1613_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Svícen čistý, lampy jeho, lampy zpořádané, i všecka nádobí jeho, i olej k svícení, ");
INSERT INTO ces1613_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Též oltář zlatý a olej pomazání a kadidlo z vonných věcí a zastření ke dveřům stánku, ");
INSERT INTO ces1613_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Oltář měděný a rošt jeho měděný, sochory jeho a všecka nádobí jeho, i umyvadlo a podstavek jeho, ");
INSERT INTO ces1613_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Očkovaté koltry síně a sloupy k nim s podstavky jejich, i zastření k bráně té síně, provazy také její a kolíky i všecka nádobí k službě příbytku, k stánku úmluvy, ");
INSERT INTO ces1613_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Roucha k službě, k přisluhování v svatyni, roucho svaté Arona kněze i roucho synů jeho k konání úřadu kněžského. ");
INSERT INTO ces1613_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Vedlé všeho, což přikázal Hospodin Mojžíšovi, tak udělali synové Izraelští všecko to dílo. ");
INSERT INTO ces1613_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","A viděl Mojžíš všecko to dílo, a aj, udělali je, jakž byl přikázal Hospodin, tak udělali. I požehnal jim Mojžíš. ");
INSERT INTO ces1613_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Potom mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","V den měsíce prvního, prvního dne téhož měsíce vyzdvihneš příbytek, stánek úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","A postavíš tam truhlu svědectví a zastřeš ji oponou. ");
INSERT INTO ces1613_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Vneseš i stůl a zřídíš řád jeho, vneseš také svícen a rozsvítíš lampy jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Postavíš též oltář zlatý pro kadění naproti truhle svědectví, a zavěsíš zastření ve dveřích příbytku. ");
INSERT INTO ces1613_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Potom postavíš oltář k zápalům přede dveřmi příbytku stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Postavíš také umyvadlo mezi stánkem úmluvy a mezi oltářem, do něhož naleješ vody. ");
INSERT INTO ces1613_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Naposledy vyzdvihneš síň vůkol a zavěsíš zastření brány síně. ");
INSERT INTO ces1613_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Tedy vezmeš olej pomazání a pomažeš příbytku a všech věcí, kteréž v něm jsou, a posvětíš ho i všech nádob jeho, a bude svatý. ");
INSERT INTO ces1613_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Pomažeš i oltáře zápalu a všech nádob jeho a posvětíš oltáře, a budeť oltář svatý. ");
INSERT INTO ces1613_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Pomažeš také umyvadla a podstavku jeho, a posvětíš ho. ");
INSERT INTO ces1613_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","A přistoupiti kážeš Aronovi i synům jeho ke dveřím stánku svědectví, a umyješ je vodou. ");
INSERT INTO ces1613_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","A oblečeš Arona v roucha svatá a pomažeš ho a posvětíš ho, aby úřad kněžský konal přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Synům také jeho přistoupiti kážeš, a zobláčíš je v sukně. ");
INSERT INTO ces1613_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","A pomažeš jich, tak jako jsi pomazal otce jejich, aby úřad kněžský konali přede mnou, aby jim bylo pomazání jejich toto k kněžství věčnému po rodech jejich. ");
INSERT INTO ces1613_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","I učinil Mojžíš tak. Všecko, jakž mu rozkázal Hospodin, tak učinil. ");
INSERT INTO ces1613_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","I stalo se měsíce prvního léta druhého, prvního dne měsíce, že vyzdvižen jest příbytek. ");
INSERT INTO ces1613_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mojžíš tedy vyzdvihl příbytek a podložil podstavky jeho a postavil dsky jeho, a provlékl svlaky jeho, a vyzdvihl sloupy jeho. ");
INSERT INTO ces1613_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Potom postavil stánek v příbytku a dal přikrytí stánku svrchu na něj, jakož mu byl přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","A vzav svědectví, vložil je do truhly, uvlékl také sochory k truhle a dal slitovnici svrchu na truhlu. ");
INSERT INTO ces1613_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","I vnesl truhlu do příbytku a zavěsil oponu zastření, a zastřel truhlu svědectví, jakož byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Postavil i stůl v stánku úmluvy k straně příbytku půlnoční, vně před oponou. ");
INSERT INTO ces1613_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A zřídil na něm zpořádaní chlebů před Hospodinem, jakž přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","A postavil svícen v stánku úmluvy naproti stolu, v straně příbytku ku poledni. ");
INSERT INTO ces1613_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","A rozsvítil lampy před Hospodinem, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Postavil také oltář zlatý v stánku úmluvy před oponou, ");
INSERT INTO ces1613_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","A kadil na něm kadidlem vonným, jakž přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Zavěsil také zastření dveří příbytku. ");
INSERT INTO ces1613_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A oltář zápalu postavil ke dveřům příbytku stánku úmluvy, a obětoval na něm oběti zápalné a suché, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A postavil umyvadlo mezi stánkem úmluvy a mezi oltářem, do něhož nalil vody k umývání. ");
INSERT INTO ces1613_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","A umýval z něho Mojžíš, Aron a synové jeho ruce své i nohy své. ");
INSERT INTO ces1613_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Když vcházeli do stánku úmluvy, a když přistupovali k oltáři, umývali se, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Naposledy vyzdvihl síň vůkol příbytku a oltáře, a zavěsil zastření brány síně. A tak dokonal Mojžíš dílo to. ");
INSERT INTO ces1613_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tedy přikryl oblak stánek úmluvy, a sláva Hospodinova naplnila příbytek. ");
INSERT INTO ces1613_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","A nemohl Mojžíš vjíti do stánku úmluvy; nebo byl nad ním oblak, a sláva Hospodinova naplnila příbytek. ");
INSERT INTO ces1613_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Když pak odnášel se oblak s příbytku, brali se synové Izraelští po všech taženích svých. ");
INSERT INTO ces1613_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pakli se neodnášel oblak, nehýbali se až do dne, v němž se zdvihl. ");
INSERT INTO ces1613_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","A byl oblak Hospodinův nad příbytkem ve dne, a oheň býval v noci na něm, před očima všeho domu Izraelského ve všech taženích jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Povolal pak Hospodin Mojžíše, a mluvil k němu z stánku úmluvy, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Mluv k synům Izraelským a rci jim: Když by kdo z vás obětoval obět Hospodinu, z hovad, totiž z volů aneb z drobného dobytka obětovati budete obět svou. ");
INSERT INTO ces1613_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Jestliže zápalná obět jeho byla by z skotů, samce bez vady obětovati bude. U dveří stánku úmluvy obětovati jej bude dobrovolně, před oblíčejem Hospodinovým. ");
INSERT INTO ces1613_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","A vloží ruku svou na hlavu oběti zápalné, i bude příjemná jemu k očištění jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Tedy zabije volka toho před tváří Hospodinovou, a obětovati budou kněží, synové Aronovi, krev, a pokropí tou krví oltáře svrchu vůkol, kterýž jest u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","I stáhne kůži s oběti zápalné, a rozseká ji na díly své. ");
INSERT INTO ces1613_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","A dají synové Arona kněze oheň na oltář, a narovnají dříví na tom ohni. ");
INSERT INTO ces1613_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Potom zpořádají kněží, synové Aronovi, díly ty, hlavu i tuk, na dříví vložené na oheň, kterýž jest na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A droby jeho i nohy jeho vymyjete vodou. I páliti bude kněz všecko to na oltáři; zápal jest v obět ohnivou, vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Jestliže pak z drobného dobytka bude obět jeho, z ovcí aneb z koz k oběti zápalné, samce bez poškvrny obětovati bude. ");
INSERT INTO ces1613_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","A zabije ho při straně oltáře půlnoční před tváří Hospodinovou, a pokropí kněží, synové Aronovi, krví oltáře vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","I rozseká ho na díly jeho s hlavou jeho i tukem jeho, a zpořádá je kněz na dříví vložené na oheň, kterýž jest na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","A střeva jeho i nohy jeho vymyje vodou. Tedy obětovati bude kněz všecko to, a páliti bude to na oltáři; zápal jest v obět ohnivou, vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Jestliže pak z ptactva obět zápalnou obětovati bude Hospodinu, tedy ať obětuje z hrdliček aneb z holoubat obět svou. ");
INSERT INTO ces1613_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","I vloží je kněz na oltář a nehtem natrhne hlavy jeho, a zapálí na oltáři, vytlače krev jeho na stranu oltáře. ");
INSERT INTO ces1613_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Odejme také vole jeho s nečistotami jeho, a povrže je blízko oltáře k straně východní na místo, kdež jest popel. ");
INSERT INTO ces1613_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","A natrhne ho za křídla jeho, kterýchž však neodtrhne. I páliti bude je kněz na oltáři na dříví, kteréž jest na ohni; zápalť jest v obět ohnivou, vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Když by pak který člověk obětoval dar oběti suché Hospodinu, mouka bělná bude obět jeho. I poleje ji olejem a vloží na ni kadidlo. ");
INSERT INTO ces1613_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Přinese ji pak k synům Aronovým kněžím, a vezme odtud plnou hrst svou té mouky bělné a toho oleje se vším kadidlem jejím; i páliti to bude kněz na památku její na oltáři v obět ohnivou, vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ostatek pak té oběti suché bude Aronovi i synům jeho, svaté svatých, z ohnivých obětí Hospodinových. ");
INSERT INTO ces1613_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Když bys pak obětoval dar oběti suché, pečené v peci, ať jsou z mouky bělné koláčové nekvašení, zadělaní olejem, aneb oplatkové přesní olejem pomazaní. ");
INSERT INTO ces1613_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Jestliže pak obět suchou na pánvici smaženou obětovati budeš, bude z mouky bělné olejem zadělané a nenakvašené. ");
INSERT INTO ces1613_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Rozlámeš ji na kusy a naleješ na ni oleje, obět suchá jest. ");
INSERT INTO ces1613_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Pakli obět suchou v kotlíku připravenou obětovati budeš, z mouky bělné s olejem bude. ");
INSERT INTO ces1613_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","I přineseš obět suchou, kteráž z těch věcí bude Hospodinu, a dáš ji knězi, kterýžto donese ji k oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","A vezma kněz z oběti té pamětné její, páliti je bude na oltáři, v obět ohnivou, vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Což pak zůstane z oběti té suché, bude Aronovi i synům jeho, svaté svatých, z ohnivých obětí Hospodinových. ");
INSERT INTO ces1613_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Žádná obět suchá, kterouž obětovati budete Hospodinu, nebude kvašena; nebo nižádného kvasu, ani medu nebudete obětovati v obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","V oběti prvotin toliko obětovati budete je Hospodinu, ale na tento oltář neobětujte jich u vůni spokojující. ");
INSERT INTO ces1613_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Také všeliký dar suché oběti své solí osolíš, a neodejmeš soli smlouvy Boha svého od suché oběti své. Při každé oběti své sůl obětovati budeš. ");
INSERT INTO ces1613_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Jestliže bys pak obětoval obět suchou z prvotin Hospodinu, klasy nové ohněm upražíš, a což vymneš z těch klasů nových, to obětovati budeš, suchou obět prvotin svých. ");
INSERT INTO ces1613_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","A poleješ ji svrchu olejem, kadidlo také vložíš na ni; obět suchá jest. ");
INSERT INTO ces1613_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","I páliti bude kněz pamětné její z obilí zetřeného, a z oleje toho, se vším tím kadidlem jejím; v obět ohnivou bude Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Jestliže pak obět pokojná bude obět jeho, když by z skotů obětoval, buď vola neb krávu, bez vady bude obětovati je před tváří Hospodinovou. ");
INSERT INTO ces1613_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Tedy položí ruku svou na hlavu oběti své, i zabije ji u dveří stánku úmluvy; a kropiti budou kněží synové Aronovi krví na oltář vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Potom obětovati bude z oběti pokojné ohnivou obět Hospodinu, tuk střeva kryjící, i všeliký tuk, kterýž jest na nich, ");
INSERT INTO ces1613_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Též obě ledvinky s tukem, kterýž jest na nich i na slabinách, tolikéž i branici, kteráž jest na jatrách; s ledvinkami odejme ji. ");
INSERT INTO ces1613_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","I páliti to budou synové Aronovi na oltáři spolu s obětí zápalnou, kteráž bude na dříví vloženém na oheň; obět zajisté ohnivá jest, vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Jestliže pak z drobného dobytka bude obět jeho v obět pokojnou Hospodinu, samce aneb samici, bez poškvrny obětovati bude ji. ");
INSERT INTO ces1613_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Jestliže by obětoval beránka, obět svou, tedy obětovati jej bude před tváří Hospodinovou. ");
INSERT INTO ces1613_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","A vloží ruku svou na hlavu oběti své, a zabije ji před stánkem úmluvy, a kropiti budou synové Aronovi krví její na oltář vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Potom obětovati bude z oběti pokojné obět ohnivou Hospodinu, tuk její i ocas celý, kterýž od hřbetu odejme, též i tuk střeva kryjící se vším tím tukem, kterýž jest na nich, ");
INSERT INTO ces1613_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Též obě dvě ledvinky s tukem, kterýž jest na nich i na slabinách, ano i branici, kteráž jest na jatrách; s ledvinkami odejme ji. ");
INSERT INTO ces1613_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","I páliti to bude kněz na oltáři; pokrm jest oběti ohnivé Hospodinovy. ");
INSERT INTO ces1613_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Jestliže pak koza byla by obět jeho, tedy bude ji obětovati před oblíčejem Hospodinovým. ");
INSERT INTO ces1613_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","A vloží ruku svou na hlavu její, a zabije ji před stánkem úmluvy; i kropiti budou synové Aronovi krví její na oltáři vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Potom obětovati bude z ní obět svou v obět ohnivou Hospodinu, tuk střeva kryjící, i všecken tuk, kterýž jest na nich, ");
INSERT INTO ces1613_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Též obě dvě ledvinky s tukem, kterýž jest na nich i na slabinách, ano i branici, kteráž jest na jatrách; s ledvinkami odejme ji. ");
INSERT INTO ces1613_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","I páliti to bude kněz na oltáři, pokrm oběti ohnivé u vůni příjemnou. Všecken tuk Hospodinu bude. ");
INSERT INTO ces1613_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Právem věčným po rodech vašich, ve všech příbytcích vašich žádného tuku a žádné krve nebudete jísti. ");
INSERT INTO ces1613_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Mluv synům Izraelským a rci: Když by kdo zhřešil z poblouzení proti některému ze všech přikázaní Hospodinových, čině, čehož býti nemá, a přestoupil by jedno z nich; ");
INSERT INTO ces1613_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Jestliže by kněz pomazaný zhřešil hříchem jiných lidí: tedy obětovati bude za hřích svůj, kterýmž zhřešil, volka mladého bez poškvrny Hospodinu v obět za hřích. ");
INSERT INTO ces1613_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","I přivede volka toho ke dveřím stánku úmluvy před oblíčej Hospodinův, a položí ruku svou na hlavu volka toho, a zabije ho před oblíčejem Hospodinovým. ");
INSERT INTO ces1613_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Tedy vezme kněz pomazaný krve z toho volka, a vnese ji do stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Potom omočí kněz prst svůj v té krvi, a kropiti jí bude sedmkráte před Hospodinem, před oponou svatyně. ");
INSERT INTO ces1613_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Pomaže také kněz tou krví rohů oltáře, na němž se kadí vonnými věcmi před Hospodinem, kterýž jest v stánku úmluvy, a ostatek krve volka toho vyleje k spodku oltáře zápalu, kterýž jest u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Všecken pak tuk volka toho za hřích vyjme z něho, totiž tuk přikrývající střeva a všecken tuk, kterýž jest na nich, ");
INSERT INTO ces1613_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Též obě dvě ledvinky s tukem, kterýž jest na nich i na slabinách, tolikéž i branici, kteráž jest na jatrách, s ledvinkami odejme ji, ");
INSERT INTO ces1613_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Tak jako se odjímá od volka oběti pokojné, a páliti to bude kněz na oltáři zápalu. ");
INSERT INTO ces1613_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kůži pak volka toho, i všecko maso jeho s hlavou i s nohami jeho, střeva jeho i s lejny jeho, ");
INSERT INTO ces1613_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","A tak celého volka vynese ven za stany na místo čisté, tam kdež se popel vysýpá, a spálí jej na dříví ohněm; na místě, kdež se popel vysýpá, spálen bude. ");
INSERT INTO ces1613_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Jestliže by pak všecko množství Izraelské pobloudilo, a byla by ta věc skrytá před očima shromáždění toho, a učinili by proti některému ze všech přikázaní Hospodinových, čehož by býti nemělo, tak že by vinni byli, ");
INSERT INTO ces1613_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","A byl by poznán hřích, kterýmž zhřešili: tedy obětovati bude shromáždění volka mladého v obět za hřích, a přivedou ho před stánek úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","I položí starší shromáždění toho ruce své na hlavu volka před Hospodinem, a zabije volka před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","I vnese kněz pomazaný z krve volka toho do stánku úmluvy, ");
INSERT INTO ces1613_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","A omoče kněz prst svůj v té krvi, kropiti jí bude sedmkráte před Hospodinem, před oponou. ");
INSERT INTO ces1613_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Pomaže také kněz tou krví rohů oltáře, kterýž jest před Hospodinem v stánku úmluvy; potom všecku krev pozůstávající vyleje k spodku oltáře zápalu, kterýž jest u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Všecken také tuk jeho vyjme z něho, a páliti bude na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","S tím pak volkem tak učiní, jako učinil s volkem za hřích obětovaným, rovně tak učiní s ním. A tak očistí je kněz, i bude jim odpuštěno. ");
INSERT INTO ces1613_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Volka pak vynese ven z táboru a spálí jej, jako spálil volka prvního; nebo obět za hřích shromáždění jest. ");
INSERT INTO ces1613_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Jestliže pak kníže zhřeší, a učiní proti některému ze všech přikázaní Hospodina Boha svého, čehož býti nemělo, a to z poblouzení, tak že vinen bude, ");
INSERT INTO ces1613_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","A byl by znám hřích jeho, jímž zhřešil: tedy přivede obět svou z koz, samce bez poškvrny. ");
INSERT INTO ces1613_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","I položí ruku svou na hlavu toho kozla a zabije ho na místě, kdež se bijí oběti zápalné před Hospodinem; obět za hřích jest. ");
INSERT INTO ces1613_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","A vezma kněz z krve oběti za hřích na prst svůj, pomaže rohů oltáře zápalu, ostatek pak krve jeho vyleje k spodku oltáře zápalu. ");
INSERT INTO ces1613_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Všecken také tuk jeho páliti bude na oltáři, jako i tuk obětí pokojných. A tak očistí jej kněz od hříchu jeho, a odpuštěn bude jemu. ");
INSERT INTO ces1613_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Jestliže pak zhřeší člověk z lidu obecného z poblouzení, učině proti některému přikázaní Hospodinovu, čehož by nemělo býti, tak že vinen bude, ");
INSERT INTO ces1613_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","A byl by znám hřích jeho, kterýmž zhřešil: tedy přivede obět svou z koz, samici bez poškvrny, za hřích svůj, jímž zhřešil. ");
INSERT INTO ces1613_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","I položí ruku svou na hlavu oběti té za hřích a zabije tu obět za hřích na místě obětí zápalných. ");
INSERT INTO ces1613_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","A vezma kněz z krve její na prst svůj, pomaže rohů oltáře zápalu, a ostatek krve její vyleje u spodku oltáře. ");
INSERT INTO ces1613_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Všecken také tuk její odejme, jako se odjímá tuk od obětí pokojných, a páliti jej bude kněz na oltáři u vůni příjemnou Hospodinu. A tak očistí jej kněz, a bude mu odpuštěno. ");
INSERT INTO ces1613_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Pakli by z ovcí přinesl obět svou za hřích, samici bez poškvrny přinese. ");
INSERT INTO ces1613_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","A vloží ruku svou na hlavu té oběti za hřích a zabije ji v obět za hřích na místě, kdež se bijí oběti zápalné. ");
INSERT INTO ces1613_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Potom vezma kněz krve z oběti té za hřích na prst svůj, pomaže rohů oltáře zápalu, ostatek pak krve její vyleje k spodku oltáře. ");
INSERT INTO ces1613_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Všecken také tuk její odejme, jakž se odjímá tuk beránka z obětí pokojných, a páliti jej bude kněz na oltáři v obět ohnivou Hospodinu. A tak očistí jej kněz od hříchu jeho, kterýmž zhřešil, a odpuštěn bude jemu. ");
INSERT INTO ces1613_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Zhřešil-li by člověk, tak že slyše hlas zakletí a jsa svědkem toho, což viděl neb slyšel, a neoznámil by, poneseť pokutu za nepravost svou. ");
INSERT INTO ces1613_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Aneb jestliže by se dotkl člověk některé věci nečisté, buďto těla zvěři nečisté, buďto těla hovada nečistého, aneb těla žížaly nečisté, a bylo by to skryto před ním, tedy nečistý bude a vinen jest. ");
INSERT INTO ces1613_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Aneb jestliže by se dotkl nečistoty člověka, jaká by koli byla nečistota jeho, kterouž se poškvrňuje, a bylo by to skryto před ním, a potom poznal by to, vinen jest. ");
INSERT INTO ces1613_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Aneb jestliže by se kdo zapřisáhl, vynášeje to rty svými, že učiní něco zlého aneb dobrého, a to o jakékoli věci, o níž člověk s přísahou obyčej má mluviti, a bylo by to skryto před ním, a potom by poznal, že vinen jest jednou věcí z těch, ");
INSERT INTO ces1613_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Když tedy vinen bude jednou věcí z těch: vyzná hřích svůj, ");
INSERT INTO ces1613_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","A přivede obět za vinu svou Hospodinu, za hřích svůj, kterýmž zhřešil, samici z dobytku drobného, ovci aneb kozu za hřích, a očistíť jej kněz od hříchů jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","A pakli by s to býti nemohl, aby dobytče obětoval, tedy přinese obět za vinu svou, kterouž zhřešil, dvě hrdličky aneb dvé holoubátek Hospodinu, jedno v obět za hřích a druhé v obět zápalnou. ");
INSERT INTO ces1613_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","I přinese je k knězi, a on obětovati bude nejprvé to, kteréž má býti v obět za hřích, a nehtem natrhne hlavy jeho naproti tylu jeho, však nerozdělí jí. ");
INSERT INTO ces1613_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","I pokropí krví z oběti za hřích strany oltáře, a což zůstane krve, vytlačí ji k spodku oltáře; nebo obět za hřích jest. ");
INSERT INTO ces1613_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Z druhého pak učiní obět zápalnou vedlé obyčeje. A tak očistí jej kněz od hříchu jeho, kterýmž zhřešil, a bude mu odpuštěn. ");
INSERT INTO ces1613_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","A pakli nemůže s to býti, aby přinesl dvě hrdličky aneb dvé holoubátek, tedy přinese obět svou ten, kterýž zhřešil, desátý díl míry efi mouky bělné v obět za hřích. Nenalejeť na ni oleje, aniž položí na ni kadidla, nebo obět za hřích jest. ");
INSERT INTO ces1613_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kterouž když přinese k knězi, tedy kněz vezma z ní plnou hrst svou, pamětné její, páliti to bude na oltáři mimo obět ohnivou Hospodinu, obět za hřích jest. ");
INSERT INTO ces1613_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","I očistí jej kněz od hříchu jeho, kterýmž zhřešil v kterékoli věci z těch, a budeť mu odpuštěn; ostatek pak bude knězi jako při oběti suché. ");
INSERT INTO ces1613_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Kdyby člověk přestoupil přestoupením, a zhřešil by z poblouzení, ujímaje věcí posvěcených Hospodinu: tedy přinese obět za vinu svou Hospodinu, skopce bez poškvrny z drobného dobytka, podlé ceny tvé, nejníž za dva loty stříbra, vedlé lotu svatyně, za vinu. ");
INSERT INTO ces1613_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","A tak, což zhřešil, ujímaje posvěcených věcí, nahradí, a pátý díl nad to přidá, dada to knězi; kněz pak očistí jej skrze skopce oběti za vinu, a bude jemu odpuštěna. ");
INSERT INTO ces1613_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Jestliže by pak člověk zhřešil, a učinil by proti některému ze všech přikázaní Hospodinových, čehož by nemělo býti, neznaje toho, a byl by vinen, rovně též ponese nepravost svou. ");
INSERT INTO ces1613_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","A přivede skopce bez poškvrny z drobného dobytka vedlé ceny tvé v obět za vinu k knězi. I očistí jej kněz od poblouzení jeho, kterýmž pobloudil a o němž nevěděl, a bude mu odpuštěno. ");
INSERT INTO ces1613_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Obět za provinění jest, nebo zavinil Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Kdyby člověk zhřešil a přestoupením přestoupil proti Hospodinu, buď že by oklamal bližního svého v věci sobě svěřené, aneb v spolku nějakém, aneb mocí by vzal něco, aneb lstivě podvedl bližního svého, ");
INSERT INTO ces1613_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Buď že nalezna ztracenou věc, za přelby mu ji, buď že by přisáhl falešně, kteroukoli věcí z těch, kterouž přihází se člověku učiniti a zhřešiti jí, ");
INSERT INTO ces1613_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Když by tedy zhřešil a vinen byl: navrátí zase tu věc, kterouž mocí sobě vzal, aneb tu, kteréž lstivě s útiskem dosáhl, aneb tu, kteráž mu svěřena byla, aneb ztracenou věc, kterouž nalezl, ");
INSERT INTO ces1613_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Aneb o kterékoli věci falešně přisáhl: tedy navrátí to z cela, a nad to pátý díl toho přidá tomu, číž bylo; to navrátí v den oběti za hřích svůj. ");
INSERT INTO ces1613_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Obět pak za hřích svůj přivede Hospodinu z drobného dobytku, skopce bez poškvrny, vedlé ceny tvé, v obět za vinu knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","I očistí jej kněz před Hospodinem, a odpuštěno mu bude, jedna každá z těch věcí, kterouž by učinil a jí vinen byl. ");
INSERT INTO ces1613_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Přikaž Aronovi i synům jeho a rci: Tento bude řád při oběti zápalné: (slove pak obět zápalná od pálení na oltáři celou noc až do jitra, nebo oheň na oltáři vždycky hořeti bude), ");
INSERT INTO ces1613_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Obleče se kněz v roucho své lněné, a košilku lněnou vezme na tělo své, a vyhrabe popel, když oheň spálí obět zápalnou na oltáři, a vysype jej u oltáře. ");
INSERT INTO ces1613_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Potom svleče šaty své a obleče se v roucho jiné, a vynese popel ven z stanů na místo čisté. ");
INSERT INTO ces1613_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Oheň pak, kterýž jest na oltáři, bude hořeti na něm, nebude uhašován. A bude zapalovati jím kněz dříví každého jitra, a zpořádá na něm obět zápalnou, a páliti bude na něm tuk pokojných obětí. ");
INSERT INTO ces1613_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Oheň ustavičně hořeti bude na oltáři, a nebudeť uhašen. ");
INSERT INTO ces1613_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Tento pak bude řád při oběti suché, kterouž obětovati budou synové Aronovi Hospodinu u oltáře: ");
INSERT INTO ces1613_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Vezme hrst bělné mouky z oběti té a z oleje jejího, se vším tím kadidlem, kteréž bude na oběti suché, a páliti to bude na oltáři u vůni líbeznou, pamětné její Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Což pak zůstane z ní, to jísti budou Aron i synové jeho; přesné jísti se bude na místě svatém, v síni stánku úmluvy jísti to budou. ");
INSERT INTO ces1613_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Nebude vařeno s kvasem, nebo jsem jim to dal za díl z obětí mých ohnivých; svaté svatých to jest, jako i obět za hřích a jako obět za vinu. ");
INSERT INTO ces1613_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Každý mužského pohlaví z synů Aronových jísti bude to právem věčným po rodech vašich, z ohnivých obětí Hospodinových. Což by se koli dotklo toho, svaté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Tato jest obět Aronova a synů jeho, kterouž obětovati budou Hospodinu v den pomazání jeho: Desátý díl míry efi mouky bělné za obět suchou ustavičnou, polovici toho ráno a polovici u večer. ");
INSERT INTO ces1613_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Na pánvici s olejem strojena bude; smaženou přineseš ji, a pečené kusy oběti suché obětovati budeš u vůni spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","A kněz, kterýž z synů jeho po něm pomazán bude, ať ji obětuje právem věčným. Hospodinu všecko to páleno bude. ");
INSERT INTO ces1613_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","A všeliká suchá obět kněžská celá spálena bude; nebudeť jedena. ");
INSERT INTO ces1613_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Mluv Aronovi a synům jeho a rci: Tento bude řád oběti za hřích: Na místě, kdež se zabijí obět zápalná, zabita bude obět za hřích před Hospodinem; svatá svatých jest. ");
INSERT INTO ces1613_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kněz obětující tu obět za hřích budeť jísti ji; na místě svatém jedena bude v síni stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Což by se koli dotklo masa jejího, svaté bude; a jestliže by krví její šaty skropeny byly, to, což skropeno jest, obmyješ na místě svatém. ");
INSERT INTO ces1613_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","A nádoba hliněná, v níž by vařeno bylo, rozražena bude; pakli by v nádobě měděné vařeno bylo, vytřena a vymyta bude vodou. ");
INSERT INTO ces1613_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Všeliký pohlaví mužského mezi kněžími jísti to bude; svaté svatých jest. ");
INSERT INTO ces1613_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ale žádná obět za hřích, (z jejížto krve něco vneseno bylo by do stánku úmluvy k očištění v svatyni), nebude jedena; ohněm spálena bude. ");
INSERT INTO ces1613_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Tento pak bude řád oběti za provinění; svatá svatých jest. ");
INSERT INTO ces1613_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Na kterémž místě zabijí se obět zápalná, na témž zabijí i obět za vinu, a pokropí krví její oltáře svrchu vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Všecken pak tuk její obětovati bude z ní, ocas i tuk střeva přikrývající. ");
INSERT INTO ces1613_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Též obě dvě ledvinky s tukem, kterýž jest na nich i na slabinách; a branici, kteráž jest na jatrách, s ledvinkami odejme. ");
INSERT INTO ces1613_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","I bude páliti to kněz na oltáři v obět ohnivou Hospodinu; obět za provinění jest. ");
INSERT INTO ces1613_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Všeliký pohlaví mužského mezi kněžími jísti bude ji, na místě svatém jedena bude; svatá svatých jest. ");
INSERT INTO ces1613_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Jakož obět za hřích, tak obět za vinu, jednostejné právo míti budou; knězi, kterýž by ho očišťoval, přináležeti bude. ");
INSERT INTO ces1613_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Knězi pak, kterýž by něčí obět zápalnou obětoval, kůže té oběti zápalné, kterouž obětoval, přináležeti bude. ");
INSERT INTO ces1613_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Nadto všeliká obět suchá, kteráž v peci pečena bude, a všecko, což na pánvici aneb v kotlíku strojeno bude, knězi, kterýž to obětuje, přináležeti bude. ");
INSERT INTO ces1613_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Tolikéž všeliká obět suchá olejem zadělaná aneb upražená, všechněm synům Aronovým přináležeti bude, a to jednomu jako druhému. ");
INSERT INTO ces1613_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Tento pak bude řád oběti pokojné, kterouž by obětoval Hospodinu: ");
INSERT INTO ces1613_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Jestliže by ji obětoval v oběti chvály, tedy obětovati bude v obět chvály koláče nekvašené, olejem zadělané a oplatky nekvašené, olejem pomazané a mouku bělnou smaženou, s těmi koláči olejem zadělanými. ");
INSERT INTO ces1613_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Mimo ty koláče také chléb kvašený obětovati bude obět svou, v obět chvály pokojných obětí svých. ");
INSERT INTO ces1613_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A budeť obětovati z něho jeden pecník, ze vší té oběti Hospodinu obět ku pozdvižení, a ten přináležeti bude tomu knězi, kterýž kropil krví té oběti pokojné. ");
INSERT INTO ces1613_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Maso pak obět, z té oběti chvály, jenž jest obět pokojná, v den obětování jejího jedeno bude, aniž co zůstane z něho do jitra. ");
INSERT INTO ces1613_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Jestliže by pak z slibu aneb z dobré vůle obětoval obět svou, tolikéž v den obětování jejího jedena bude; a jestliže by co zůstalo z toho, tedy na druhý den jísti se bude. ");
INSERT INTO ces1613_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Jestliže by pak co masa z té oběti zůstalo do třetího dne, ohněm spáleno bude. ");
INSERT INTO ces1613_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Pakli by kdo předce jedl maso oběti pokojné dne třetího, nebudeť příjemný ten, kterýž ji obětoval, aniž přijata bude, ale ohavnost bude, a kdož by koli jedl je, ponese nepravost svou. ");
INSERT INTO ces1613_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Též maso, kteréž by se dotklo něčeho nečistého, nebude jedeno, ale ohněm spáleno bude; maso pak jiné, kdož by koli čistý byl, bude moci jísti. ");
INSERT INTO ces1613_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Nebo člověk, kterýž by jedl maso z oběti pokojné, kteráž jest Hospodinu obětována, a byl by poškvrněný: tedy vyhlazen bude člověk ten z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","A kdož by se dotkl něčeho nečistého, buďto nečistoty člověka, buď hovada nečistého aneb všeliké ohavnosti nečisté, a jedl by maso z oběti pokojné, kteráž jest Hospodinu posvěcena: tedy vyhlazen bude člověk ten z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Mluv k synům Izraelským a rci jim: Žádného tuku z vola, aneb z ovce, aneb z kozy nebudete jísti. ");
INSERT INTO ces1613_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ačkoli tuk mrtvého a tuk udáveného hovada může užíván býti k všeliké potřebě, ale jísti ho nikoli nebudete. ");
INSERT INTO ces1613_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Nebo kdož by koli jedl tuk z hovada, kteréž obětovati bude člověk v obět ohnivou Hospodinu, vyhlazen bude člověk ten, kterýž jedl, z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Tolikéž krve žádné jísti nebudete ve všech příbytcích svých, buď z ptactva, buď z hovada. ");
INSERT INTO ces1613_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Všeliký člověk, kterýž by jedl jakou krev, vyhlazen bude z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Mluv k synům Izraelským a rci: Kdož by obětoval obět svou pokojnou Hospodinu, on sám přinese obět svou Hospodinu z obětí pokojných svých. ");
INSERT INTO ces1613_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ruce jeho obětovati budou obět ohnivou Hospodinu. Tuk s hrudím přinese, a hrudí aby bylo v obět sem i tam obracení před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Páliti pak bude kněz tuk na oltáři, ale hrudí to zůstane Aronovi i synům jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","A plece pravé dáte knězi ku pozdvižení z obětí pokojných vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kdožkoli z synů Aronových obětovati bude krev obětí pokojných a tuk, tomu se dostane plece pravé na díl jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Nebo hrudí sem i tam obracení a plece vzhůru pozdvižení vzal jsem od synů Izraelských z obětí pokojných jejich, a dal jsem je Aronovi knězi i synům jeho právem věčným od synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Toť jest díl pomazání Aronova, a pomazání synů jeho z ohnivých obětí Hospodinových, ode dne toho, v kterémž jim přistoupiti rozkázal k vykonávání kněžství Hospodinu, ");
INSERT INTO ces1613_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Kterýž přikázal Hospodin, aby jim ode dne, v kterémž jich pomazal, dáván byl od synů Izraelských právem věčným po rodech jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Tenť jest řád oběti zápalné, oběti suché, oběti za hřích, oběti za vinu, a posvěcování i obětí pokojných, ");
INSERT INTO ces1613_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Kteréž přikázal Hospodin Mojžíšovi na hoře Sinai toho dne, když přikázal synům Izraelským, aby obětovali oběti své Hospodinu na poušti Sinai. ");
INSERT INTO ces1613_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Vezmi Arona a syny jeho s ním, i roucha jejich a olej pomazání, též volka k oběti za hřích, a dva skopce, a koš s přesnými chleby, ");
INSERT INTO ces1613_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","A shromažď všecko množství ke dveřím stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","I učinil Mojžíš, jakž přikázal jemu Hospodin, a shromáždilo se všecko množství ke dveřím stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Tedy řekl Mojžíš tomu množství: Totoť jest to slovo, kteréž přikázal vykonati Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","A rozkázav přistoupiti Mojžíš Aronovi a synům jeho, umyl je vodou. ");
INSERT INTO ces1613_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A oblékl jej v sukni a přepásal ho pasem, a oděv ho pláštěm, dal náramenník svrchu na něj, a připásal jej pasem náramenníka a otáhl ho jím. ");
INSERT INTO ces1613_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A vložil na něj náprsník, do něhožto dal urim a thumim. ");
INSERT INTO ces1613_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Potom vstavil čepici na hlavu jeho; a dal na čepici jeho po předu plech zlatý, korunu svatou, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Vzal také Mojžíš olej pomazání a pomazal příbytku i všech věcí, kteréž byly v něm, a posvětil jich. ");
INSERT INTO ces1613_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","A pokropil jím oltáře sedmkrát, a pomazal oltáře i všeho nádobí jeho, též umyvadla i s podstavkem jeho, aby to všecko posvěceno bylo. ");
INSERT INTO ces1613_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Vlil také oleje pomazání na hlavu Aronovu, a pomazal ho ku posvěcení jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Rozkázal také Mojžíš přistoupiti synům Aronovým, a zobláčel je v sukně, a opásal je pasem, a vstavil na ně klobouky, jakož byl přikázal Hospodin jemu. ");
INSERT INTO ces1613_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","A přivedl volka k oběti za hřích, i položil Aron a synové jeho ruce své na hlavu volka oběti za hřích. ");
INSERT INTO ces1613_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","I zabil jej a vzal krev jeho, a pomazal rohů oltáře vůkol prstem svým, a tak očistil oltář. Ostatek pak krve vylil k spodku oltáře a posvětil ho k očišťování na něm. ");
INSERT INTO ces1613_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Vzal také všecken tuk, kterýž byl na střevách, a branici s jater a obě ledvinky i tuk jejich, a pálil to Mojžíš na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Volka pak toho i kůži jeho, i maso jeho, i lejna jeho spálil ohněm vně za stany, jakož byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Potom přivedl skopce oběti zápalné, a položil Aron i synové jeho ruce své na hlavu toho skopce. ");
INSERT INTO ces1613_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","I zabil jej, a pokropil Mojžíš krví oltáře po vrchu vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Skopce také rozsekal na kusy jeho, a pálil Mojžíš hlavu, kusy i tuk. ");
INSERT INTO ces1613_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Střeva pak a nohy vymyl vodou, a tak spálil Mojžíš všeho skopce na oltáři. I byl zápal u vůni líbeznou, obět ohnivá Hospodinu, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Rozkázal také přivésti skopce druhého, skopce posvěcení, a položil Aron i synové jeho ruce své na hlavu skopce. ");
INSERT INTO ces1613_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","I zabil jej, a vzav Mojžíš krve jeho, pomazal jí konce pravého ucha Aronova a palce ruky jeho pravé, i palce nohy jeho pravé. ");
INSERT INTO ces1613_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Tolikéž synům Aronovým rozkázav přistoupiti, pomazal kraje ucha jejich pravého a palce ruky jejich pravé, též palce nohy jejich pravé, a vykropil krev na oltář svrchu vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Potom vzal tuk a ocas i všecken tuk přikrývající droby a branici s jater, též obě dvě ledvinky i tuk jejich i plece pravé. ");
INSERT INTO ces1613_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Také z koše přesných chlebů, kteříž byli před Hospodinem, vzal jeden koláč přesný a jeden pecník chleba s olejem a jeden oplatek, a položil to s tukem a s plecem pravým. ");
INSERT INTO ces1613_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","A dal to všecko v ruce Aronovy a v ruce synů jeho, rozkázav obraceti sem i tam v obět obracení před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Potom vzav z rukou jejich, pálil to na oltáři v zápal. Posvěcení toto jest u vůni rozkošnou, obět ohnivá Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Vzal také Mojžíš hrudí a obracel je sem i tam v obět obracení před Hospodinem; a z skopce posvěcení dostal se Mojžíšovi díl, jakož mu byl přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Vzal také Mojžíš oleje pomazání a krve, kteráž byla na oltáři, a pokropil Arona i roucha jeho, též synů Aronových a roucha jejich s ním. A tak posvětil Arona i roucha jeho, též synů jeho i roucha jejich s ním. ");
INSERT INTO ces1613_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","I řekl Mojžíš Aronovi a synům jeho: Vařte to maso u dveří stánku úmluvy, a jezte je tu, i chléb, kterýž jest v koši posvěcení, jakož jsem přikázal, řka: Aron a synové jeho jísti budou je. ");
INSERT INTO ces1613_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Což by pak zůstalo masa i chleba toho, ohněm to spálíte. ");
INSERT INTO ces1613_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","A ze dveří stánku úmluvy za sedm dní nevycházejte až do dne, v kterémž by se vyplnili dnové svěcení vašeho; nebo za sedm dní posvěcovány budou ruce vaše. ");
INSERT INTO ces1613_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Jakož se stalo dnešní den, tak přikázal Hospodin činiti k očištění vašemu. ");
INSERT INTO ces1613_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Protož u dveří stánku úmluvy zůstanete ve dne i v noci za sedm dní, a ostříhati budete nařízení Hospodinova, abyste nezemřeli; nebo tak mi jest přikázáno. ");
INSERT INTO ces1613_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Učinil tedy Aron i synové jeho všecky věci, kteréž přikázal Hospodin skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Stalo se pak dne osmého, povolal Mojžíš Arona a synů jeho i starších Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","I řekl Aronovi: Vezmi sobě tele k oběti za hřích, a skopce k oběti zápalné, obé bez poškvrny, a obětuj před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","K synům pak Izraelským mluviti budeš, řka: Vezměte kozla k oběti za hřích, a tele a beránka, roční, bez vady, k oběti zápalné, ");
INSERT INTO ces1613_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Vola také a skopce k oběti pokojné, abyste obětovali před Hospodinem, a obět suchou zadělanou olejem; nebo dnes se vám ukáže Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Tedy vzali ty věci, kteréž přikázal Mojžíš před stánkem úmluvy, a přistoupivši všecko shromáždění, stáli před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","I řekl Mojžíš: Toto jest ta věc, kterouž přikázal Hospodin. Vykonejtež ji, a ukáže se vám sláva Hospodinova. ");
INSERT INTO ces1613_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Aronovi pak řekl Mojžíš: Přistup k oltáři a obětuj obět za hřích svůj, a obět zápalnou svou k vykonání očištění za sebe i za lid tento; obětuj také obět lidu všeho, a učiň očištění za ně, jakož přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Přistoupiv tedy Aron k oltáři, zabil tele své k oběti za hřích. ");
INSERT INTO ces1613_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","I dali mu synové Aronovi krev. Kterýžto omočiv prst svůj ve krvi, pomazal rohů oltáře, ostatek pak krve vylil k spodku oltáře. ");
INSERT INTO ces1613_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ale tuk a ledvinky, i branici s jater té oběti za hřích pálil na oltáři, jakož byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Maso pak s kůží spálil vně za stany. ");
INSERT INTO ces1613_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Zabil také obět zápalnou. I podali mu synové Aronovi krve, kterouž pokropil po vrchu oltáře vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Podali jemu také i oběti zápalné s kusy jejími i hlavy její, a pálil ji na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A vymyv střeva i nohy její, pálil je s obětí zápalnou na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Obětoval také obět všeho lidu. A vzav kozla oběti za hřích, kterýž byl všeho lidu, zabil jej a obětoval ho za hřích jako i prvního. ");
INSERT INTO ces1613_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Obětoval též obět zápalnou a učinil ji vedlé obyčeje. ");
INSERT INTO ces1613_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Tolikéž i obět suchou obětoval, a vzav plnou hrst z ní, pálil to na oltáři, mimo obět zápalnou jitřní. ");
INSERT INTO ces1613_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Zabil ještě i vola a skopce k oběti pokojné, kteráž byla za lid. I podali mu synové Aronovi krve, kterouž pokropil oltáře po vrchu vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Dali jemu také tuk z vola a z skopce ocas, a tuk přikrývající střeva i ledvinky a branici s jater. ");
INSERT INTO ces1613_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","A položili včecken tuk na hrudí; i pálil ten tuk na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Hrudí pak a plece pravé obracel sem i tam Aron v obět obracení před Hospodinem, jakož byl přikázal Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Potom Aron pozdvihna rukou svých k lidu, dal jim požehnání, a sstoupil od obětování oběti za hřích a oběti zápalné i oběti pokojné. ");
INSERT INTO ces1613_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Tedy všel Mojžíš s Aronem do stánku úmluvy; a když vycházeli z něho, požehnání dávali lidu. I ukázala se sláva Hospodinova všemu lidu. ");
INSERT INTO ces1613_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Nebo sstoupil oheň od tváři Hospodina, a spálil na oltáři obět zápalnou i všecken tuk. Což když uzřel veškeren lid, zkřikli a padli na tváři své. ");
INSERT INTO ces1613_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Synové pak Aronovi Nádab a Abiu, vzavše jeden každý kadidlnici svou, dali do nich oheň a položili na něj kadidlo, a obětovali před Hospodinem oheň cizí, čehož jim byl nepřikázal. ");
INSERT INTO ces1613_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Protož sstoupiv oheň od Hospodina, spálil je; a zemřeli tu před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","I řekl Mojžíš Aronovi: Toť jest, což mluvil Hospodin, řka: V těch, kteříž přistupují ke mně, posvěcen budu, a před oblíčejem všeho lidu oslaven budu. I mlčel Aron. ");
INSERT INTO ces1613_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Tedy povolal Mojžíš Mizaele a Elizafana, synů Uziele, strýce Aronova, a řekl jim: Poďte a vyneste bratří své od svatyně ven za stany. ");
INSERT INTO ces1613_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","I přišli a vynesli je v sukních jejich ven za stany, jakž byl rozkázal Mojžíš. ");
INSERT INTO ces1613_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mluvil pak Mojžíš Aronovi, Eleazarovi a Itamarovi, synům jeho: Hlav svých neodkrývejte a roucha svého neroztrhujte, abyste nezemřeli, a aby se Bůh na všecko množství nerozhněval; ale bratří vaši, všecka rodina Izraelská, budou plakati nad tím spálením, kteréž uvedl Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Vy pak ze dveří stánku úmluvy nevycházejte, abyste nezemřeli; nebo olej pomazání Hospodinova jest na vás. I učinili vedlé rozkázaní Mojžíšova. ");
INSERT INTO ces1613_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mluvil také Hospodin Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Vína a nápoje opojného nebudeš píti, ty ani synové tvoji s tebou, kdyžkoli budete míti vcházeti do stánku úmluvy, abyste nezemřeli, (ustanovení věčné to bude po rodech vašich); ");
INSERT INTO ces1613_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Také abyste rozeznati mohli mezi svatým a neposvěceným, a mezi čistým a nečistým; ");
INSERT INTO ces1613_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Též abyste učili syny Izraelské všechněm ustanovením, kteráž mluvil Hospodin k nim skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mluvil pak Mojžíš Aronovi, Eleazarovi a Itamarovi, synům jeho, kteříž živi zůstali: Vezměte obět suchou, kteráž zůstala z ohnivých obětí Hospodinových, a jezte ji s přesnicemi u oltáře; nebo svatá svatých jest. ");
INSERT INTO ces1613_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Protož jísti budete ji na místě svatém, nebo to jest právo tvé a právo synů tvých z ohnivých obětí Hospodinových; tak zajisté jest mi přikázáno. ");
INSERT INTO ces1613_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Hrudí pak sem i tam obracení, a plece vznášení jísti budete na místě čistém, ty i synové tvoji, i dcery tvé s tebou; nebo to právem tobě a synům tvým dáno jest z pokojných obětí synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Plece vzhůru vznášení a hrudí sem i tam obracení s obětmi ohnivými tuků, kteréž přinesou, aby sem i tam obracíno bylo, tak jako obět obracení před Hospodinem, bude tobě i synům tvým s tebou právem věčným, jakož přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mojžíš pak hledal pilně kozla k oběti za hřích, a hle, již spálen byl. Tedy rozhněval se na Eleazara a Itamara, syny Aronovy pozůstalé, a řekl: ");
INSERT INTO ces1613_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Pročež jste nejedli oběti za hřích na místě svatém? Nebo svatá svatých byla, poněvadž ji dal vám, abyste nesli nepravost všeho množství k očištění jejich před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","A hle, ani krev její není vnesena do vnitřku svatyně. Jísti jste měli ji v svatyni, jakož jsem byl přikázal. ");
INSERT INTO ces1613_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Tedy odpověděl Aron Mojžíšovi: Aj, dnes obětovali obět svou za hřích a obět svou zápalnou před Hospodinem, ale přihodila se mně taková věc, že, kdybych byl jedl obět za hřích dnes, zdali by se to líbilo Hospodinu? ");
INSERT INTO ces1613_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Což když uslyšel Mojžíš, přestal na tom. ");
INSERT INTO ces1613_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","I mluvil Hospodin Mojžíšovi a Aronovi, řka jim: ");
INSERT INTO ces1613_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Mluvte k synům Izraelským, řkouce: Tito jsou živočichové, kteréž jísti budete ze všech hovad, kteráž jsou na zemi: ");
INSERT INTO ces1613_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Všeliké hovado, kteréž má kopyta rozdělená, tak aby rozdvojená byla, a přežívá, jísti budete. ");
INSERT INTO ces1613_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","A však z těch, kteráž přežívají, a z těch, kteráž kopyta rozdělená mají, nebudete jísti, jako velblouda; nebo ač přežívá, ale kopyta rozděleného nemá, nečistý vám bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ani králíka, kterýž ač přežívá, ale kopyta rozděleného nemá, nečistý vám bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ani zajíce; nebo ač přežívá, ale kopyta rozděleného nemá, nečistý vám bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Tolikéž ani svině; nebo ač má rozdělené kopyto, tak že se rozdvojuje, ale nepřežívá, nečistá bude vám. ");
INSERT INTO ces1613_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Masa jejich nebudete jísti, ani těla jejich mrtvého se dotýkati, nečistá budou vám. ");
INSERT INTO ces1613_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ze všech pak živočichů, kteříž u vodách jsou, tyto jísti budete: Všecko, což má plejtvy a šupiny u vodách mořských i v řekách, jísti budete. ");
INSERT INTO ces1613_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Všecko pak, což nemá plejtví a šupin v moři i v řekách, buď jakýkoli hmyz vodný, aneb jakákoli duše živá u vodách, ohavností bude vám. ");
INSERT INTO ces1613_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","A tak v ohavnosti vám budou, abyste masa jejich nejedli a těla jejich v ohyzdnosti měli. ");
INSERT INTO ces1613_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Což tedy nemá plejtví a šupin u vodách, to v ohavnosti míti budete. ");
INSERT INTO ces1613_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Z ptactva pak tyto v ohavnosti míti budete, jichžto nebudete jísti, nebo ohavnost jsou, jako jest orel, noh a orlice mořská, ");
INSERT INTO ces1613_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Též sup, káně a luňák vedlé pokolení svého, ");
INSERT INTO ces1613_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","A všeliký krkavec vedlé pokolení svého, ");
INSERT INTO ces1613_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Také pstros, sova, vodní káně, a jestřáb vedlé pokolení svého, ");
INSERT INTO ces1613_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","A bukač, křehař a kalous, ");
INSERT INTO ces1613_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","A porfirián, pelikán a labut, ");
INSERT INTO ces1613_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Též čáp a kalandra vedlé pokolení svého, dedek a netopýř. ");
INSERT INTO ces1613_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Všeliký zeměplaz křídla mající, kterýž na čtyřech nohách chodí, v ohavnosti míti budete. ");
INSERT INTO ces1613_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","A však ze všelikého zeměplazu křídla majícího, kterýž na čtyřech nohách chodí, jísti budete ty, kteříž mají stehénka na nohách svých, aby skákali na nich po zemi. ");
INSERT INTO ces1613_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Titoť pak jsou, kteréž jísti budete: Arbes vedlé pokolení svého, sálem vedlé pokolení svého, chargol vedlé pokolení svého, a chagab vedlé pokolení svého. ");
INSERT INTO ces1613_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Jiný pak zeměplaz všeliký křídla mající, kterýž na čtyřech nohách chodí, v ohavnosti míti budete. ");
INSERT INTO ces1613_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Nebo těmi byste se poškvrňovali. Protož kdož by se koli dotkl těla jich, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","A kdož by koli nesl těla jich, zpéřeť roucho své a nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Všeliké hovado, kteréž má rozdělené kopyto, ale není rozdvojené, a nepřežívá, nečisté vám bude. Kdož by koli jeho se dotekl, nečistý bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","A cožkoli chodí na tlapách svých ze všech hovad čtvernohých, nečisté bude vám. Kdož by koli dotkl se těl jejich, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","A kdož by koli nesl těla jejich, zpéře roucha svá a nečistý bude až do večera; nebo nečistá jsou vám. ");
INSERT INTO ces1613_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Také i toto vám nečisté bude mezi zeměplazy, kteříž lezou po zemi: Kolčava a myš a žába, každé vedlé pokolení svého; ");
INSERT INTO ces1613_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Též ježek a ještěrka, hlemejžď, štír a krtice. ");
INSERT INTO ces1613_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Tyto věci nečisté vám budou ze všelijakého zeměplazu. Kdož by se koli dotkl jich mrtvých, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","A všeliká věc, na kterouž by padlo něco z těch již mrtvých těl, nečistá bude, buď nádoba dřevěná, neb roucho, neb kůže, aneb pytel. A všeliká nádoba, kteréž se k dílu nějakému užívá, do vody vložena bude a nečistá zůstane až do večera, potom čistá bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Všeliká pak nádoba hliněná, do níž by něco toho upadlo, i což by koli v ní bylo, nečisté bude, ona pak rozražena bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Všeliký také pokrm, jehož se užívá, jestliže by na něj voda vylita byla, nečistý bude; a všeliký nápoj ku pití příhodný v každé nádobě nečisté bude nečistý. ");
INSERT INTO ces1613_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","A všecko, na čež by něco z těla jejich upadlo, nečisté bude. Pec a kotliště zbořeno bude, nebo nečisté jest; protož za nečisté je míti budete. ");
INSERT INTO ces1613_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ale studnice a čisterna, i všeliké shromáždění vod, čistá budou; však což by se dotklo umrliny jejich, nečisté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Jestliže by pak něco z mrchy jejich upadlo na některé semeno, kteréž síti obyčej jest, čisté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ale když by polito bylo vodou semeno, a potom padlo by něco z umrliny jejich na ně, nečisté bude vám. ");
INSERT INTO ces1613_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Jestliže by umřelo hovado z těch, kteráž vám jsou ku pokrmu, kdož by se koli mrchy jeho dotkl, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kdo by jedl z těla toho, zpéřeť roucha svá a nečistý bude až do večera. Také i ten, kterýž by vynesl tu mrchu, zpéře roucha svá, a nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Tolikéž všeliký zeměplaz, kterýž se plazí po zemi, v ohavnosti bude vám; nebudete ho jísti. ");
INSERT INTO ces1613_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ničeho, což se plazí na prsech, aneb cožkoli čtvermo leze, aneb více má noh, ze všeho zeměplazu, kterýž se plazí po zemi, nebudete jísti nebo jsou ohavnost. ");
INSERT INTO ces1613_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Nezohavujtež duší svých žádným zeměplazem, kterýž se plazí, a nepoškvrňujte se jimi, abyste nečistí nebyli učiněni skrze ně. ");
INSERT INTO ces1613_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Nebo já jsem Hospodin Bůh váš; protož posvěťtež se, a svatí buďte, nebo já svatý jsem, a nepošvrňujte duší svých žádným zeměplazem, kterýž se plazí po zemi. ");
INSERT INTO ces1613_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nebo já jsem Hospodin, kterýž jsem vás vyvedl z země Egyptské, abych vám byl za Boha; protož svatí buďte, nebo já jsem svatý. ");
INSERT INTO ces1613_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Toť jest právo strany hovada, ptactva a všeliké duše živé, kteráž se hýbe u vodách, a každé duše živé, kteráž se plazí na zemi, ");
INSERT INTO ces1613_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Aby rozdíl činěn byl mezi nečistým a čistým, a mezi živočichy, kteříž se mají jísti, a mezi živočichy, kteříž se nemají jísti. ");
INSERT INTO ces1613_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Mluv synům Izraelským a rci: Žena počnuc, porodí-li pacholíka, nečistá bude za sedm dní; podlé počtu dnů, v nichž odděluje se pro nemoc svou, nečistá bude. ");
INSERT INTO ces1613_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Potom dne osmého obřezáno bude tělo neobřízky jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ona pak ještě za třidceti a tři dni zůstávati bude v očišťování se od krve. Nižádné věci svaté se nedotkne a k svatyni nepůjde, dokudž se nevyplní dnové očištění jejího. ");
INSERT INTO ces1613_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Pakli děvečku porodí, nečistá bude za dvě neděle vedlé nečistoty oddělení svého, a šedesáte šest dní zůstávati bude v očištění od krve. ");
INSERT INTO ces1613_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Když pak vyplní se dnové očištění jejího po synu aneb po dceři, přinese beránka ročního na obět zápalnou, a holoubátko aneb hrdličku na obět za hřích, ke dveřím stánku úmluvy, knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kterýž obětovati ji bude před Hospodinem, a očistí ji, a tak očištěna bude od toku krve své. Ten jest zákon té, kteráž porodila pacholíka aneb děvečku. ");
INSERT INTO ces1613_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Pakli nebude moci býti s beránka, tedy vezme dvé hrdličátek, aneb dvé holoubátek, jedno v obět zápalnou a druhé v obět za hřích. I očistí ji kněz, a tak čistá bude. ");
INSERT INTO ces1613_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mluvil také Hospodin Mojžíšovi a Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Èlověk ješto by na kůži těla jeho byla nějaká oteklina aneb prašivina, aneb poškvrna pobělavá, a bylo by na kůži těla jeho něco podobného k ráně malomocenství: tedy přiveden bude k Aronovi knězi, aneb k některému z synů jeho kněží. ");
INSERT INTO ces1613_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","I pohledí kněz na ránu, kteráž jest na kůži těla jeho. Jestliže chlupové na té ráně zbělejí, a ta rána bude-li na pohledění hlubší nežli jiná kůže těla jeho, rána malomocenství jest. Když tedy spatří ji kněz, za nečistého vyhlásí jej. ");
INSERT INTO ces1613_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Pakli by poškvrna pobělavá byla na kůži těla jeho, a rána ta nebyla by hlubší nežli jiná kůže, a chlupové její nezběleli by: tedy rozkáže zavříti kněz majícího takovou ránu za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Potom pohledí na něj kněz v den sedmý, a jestli rána ta zůstává tak před očima jeho a nerozmáhá se po kůži: tedy rozkáže ho zavříti kněz po druhé za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","I pohledí na ni kněz v den sedmý po druhé, a jestliže ta rána pozčernalá bude, a nerozmohla by se po kůži: tedy za čistého vyhlásí ho kněz, nebo prašivina jest. I zpéře roucha svá a čistý bude. ");
INSERT INTO ces1613_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pakliť by se dále rozmohla ta prašivina po kůži jeho, již po ukázání se knězi k očištění svému, tedy ukáže se znovu knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","I pohledí na něj kněz, a jestliže se rozmohla ta prašivina po kůži jeho, za nečistého vyhlásí jej kněz, nebo malomocenství jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Rána malomocenství když bude na člověku, přiveden bude k knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","I pohledí na něj kněz, a bude-li oteklina bílá na kůži, až by učinila chlupy bílé, byť pak i zdravé maso bylo na té oteklině: ");
INSERT INTO ces1613_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Malomocenství zastaralé jest na kůži těla jeho. Protož za nečistého vyhlásí jej kněz, a nedá ho zavříti, nebo zjevně nečistý jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Jestliže by se pak vylilo malomocenství po kůži, a přikrylo by malomocenství všecku kůži nemocného, od hlavy jeho až do noh jeho, všudy kdež by kněz očima viděti mohl: ");
INSERT INTO ces1613_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","I pohledí na něj kněz, a přikrylo-li by malomocenství všecko tělo jeho, tedy za čistého vyhlásí nemocného. Nebo všecka ta rána v bělost se změnila, protož čistý jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ale kdykoli ukáže se na ní živé maso, nečistý bude. ");
INSERT INTO ces1613_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","I pohledí kněz na to živé maso a vyhlásí jej za nečistého, nebo to maso živé nečisté jest, malomocenství jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Když by pak odešlo zase maso živé a změnilo by se v bělost, tedy přijde k knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","A vida kněz, že obrátila se rána ta v bělost, za čistou vyhlásí ji; čistá jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Když by pak byl na kůži těla vřed, a byl by zhojen, ");
INSERT INTO ces1613_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Byla-li by na místě vředu toho oteklina bílá, aneb poškvrna pobělavá a náryšavá, tedy ukázána bude knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","A vida kněz, že na pohledění to místo jest nižší nežli jiná kůže, a chlupové na něm by zběleli, za nečistého vyhlásí jej kněz. Rána malomocenství jest, kteráž na vředu vyrostla. ");
INSERT INTO ces1613_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pakli, když pohledí na ni kněz, uzří, že chlupové nezběleli na něm, a není nižší nežli jiná kůže, ale že jest pozčernalé místo, tedy zavře ho kněz za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Pakliť by šíře se rozmáhala po kůži, za nečistého vyhlásí jej kněz; rána malomocenství jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pakli by ta poškvrna pobělavá zůstávala na místě svém, a nerozmáhala by se, znamení toho vředu jest; protož za čistého vyhlásí jej kněz. ");
INSERT INTO ces1613_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Tělo, na jehož kůži byla by spálenina od ohně, a po zhojení té spáleniny zůstala by poškvrna pobělavá a náryšavá, anebo bílá toliko: ");
INSERT INTO ces1613_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Pohledí na ni kněz, a jestliže chlupové na ní zběleli, a lsknou se, způsob také její jest hlubší nežli jiné kůže vůkol: malomocenství jest, kteréž zrostlo na spálenině; protož za nečistého vyhlásí jej kněz, nebo rána malomocenství jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pakli uzří kněz, an na poškvrně pobělavé není žádného chlupu bílého, a že nižší není nežli jiná kůže, ale že jest pozčernalá, poručí ho zavříti kněz za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","I pohledí na ni kněz dne sedmého. Jestliže se více rozmohla po kůži, tedy za nečistého vyhlásí jej; nebo rána malomocenství jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pakli bělost lsknutá na svém místě zůstávati bude, a nerozmůže se po kůži, ale bude pozčernalá: zprýštění od spáleniny jest; za čistého vyhlásí jej kněz, nebo šrám spáleniny jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Byla-li by pak rána na hlavě aneb na bradě muže neb ženy, ");
INSERT INTO ces1613_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Tedy pohledí kněz na tu ránu, a jestliže způsob její bude hlubší nežli jiná kůže, a bude na ní vlas prožlutlý a tenký: tedy za nečistého vyhlásí jej kněz, nebo poškvrna černá jest; malomocenství na hlavě aneb na bradě jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Když pak pohledí kněz na ránu poškvrny černé a uzří, že způsob její není hlubší nežli jiná kůže, a že není vlasu černého na ní: zavříti dá kněz majícího ránu poškvrny černé za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","I pohledí kněz na tu ránu dne sedmého, a aj, nerozmohla se ta poškvrna černá, a není vlasu žlutého na ní, a způsob té poškvrny černé není hlubší nežli kůže: ");
INSERT INTO ces1613_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Tedy oholen bude člověk ten, ale poškvrny té černé nedá holiti. I dá zavříti kněz majícího tu poškvrnu za sedm dní po druhé. ");
INSERT INTO ces1613_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","I pohledí kněz na poškvrnu černou dne sedmého, a jestliže se nerozmohla poškvrna černá dále po kůži, a místo její není-li hlubší nežli jiná kůže: za čistého vyhlásí ho kněz, i zpéře roucha svá a čistý bude. ");
INSERT INTO ces1613_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pakli by se dále rozmohla poškvrna ta černá po kůži, již po očištění jeho, ");
INSERT INTO ces1613_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Tedy pohledí na ni kněz, a uzří-li, že se dále rozmohla ta poškvrna černá po kůži, nebude více šetřiti vlasu žlutého; nečistý jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pakli poškvrna černá tak zůstává před očima jeho, a černý vlas vzrostl by na ní, tedy zhojena jest ta poškvrna černá; čistý jest, a za čistého vyhlásí jej kněz. ");
INSERT INTO ces1613_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Když by na kůži těla muže aneb ženy byly poškvrny, totiž poškvrny pobělavé, ");
INSERT INTO ces1613_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","I pohledí kněz, a jestliže budou na kůži těla jejich poškvrny bílé, pozčernalé, tedy poškvrna bílá jest, kteráž na kůži zrostla; čistý jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Muž, z jehož by hlavy vlasové slezli, lysý jest a čistý jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Jestliže pak po jedné straně obleze hlava jeho, nálysý jest a čistý jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pakli na té lysině, aneb na tom oblysení byla by rána bílá a ryšavá, tedy malomocenství zrostlo na lysině jeho, aneb na oblysení jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","I pohledí na něj kněz, a uzří-li oteklinu rány bílou a ryšavou na lysině jeho, aneb na oblysení jeho, jako způsob malomocenství na kůži těla: ");
INSERT INTO ces1613_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Èlověk malomocný jest a nečistý jest. Bez meškání za nečistého vyhlásí jej kněz, nebo na hlavě jeho jest malomocenství jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Malomocný pak, na němž by ta rána byla, bude míti roucho roztržené a hlavu odkrytou a ústa zastřená, a Nečistý, nečistý jsem! volati bude. ");
INSERT INTO ces1613_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Po všecky dny, v nichž ta rána bude na něm, za nečistého jmín bude; nebo nečistý jest. Sám bydliti bude, vně za stany bude přebývání jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Když by pak na rouchu byla rána malomocenství, buď na rouchu soukenném aneb na rouchu lněném, ");
INSERT INTO ces1613_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Buď na osnově aneb na outku ze lnu aneb z vlny, buď na kůži aneb na každé věci kožené, ");
INSERT INTO ces1613_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","A byla by ta rána zelená neb náryšavá na rouchu aneb na kůži, aneb na osnově, aneb na outku, aneb na kterékoli nádobě kožené: rána malomocenství jest, ukázána bude knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","I pohledí kněz na tu ránu, a dá zavříti tu věc mající ránu za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","A pohledě na tu ránu dne sedmého, uzří-li, že se dále rozmohla ta rána na rouchu, neb po osnově anebo po outku, aneb na kůži, k čemuž by jí koli užíváno bylo: rána ta malomocenství rozjídavá jest, věc nečistá jest. ");
INSERT INTO ces1613_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","I spálí to roucho aneb osnovu, aneb outek z vlny neb ze lnu, aneb jakoukoli nádobu koženou, na níž by byla rána ta; nebo malomocenství škodlivé jest, protož ohněm spáleno bude. ");
INSERT INTO ces1613_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Pakli pohledě kněz, uzřel by, že se nerozmohla rána ta na rouchu, aneb na osnově, aneb na outku, aneb na kterékoli nádobě kožené: ");
INSERT INTO ces1613_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Rozkáže kněz, aby zeprali tu věc, na níž byla by rána, i káže ji zavříti za sedm dní po druhé. ");
INSERT INTO ces1613_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","I pohledí kněz po zeprání té věci na ránu. Jestliže nezměnila rána barvy své, byť se pak nerozmohla dále, předce nečistá jest. Ohněm spálíš ji; nebo rozjídavá věc jest na vrchní neb spodní straně její. ");
INSERT INTO ces1613_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Pakli pohledě kněz, uzřel by, an pozčernala rána po zeprání svém, odtrhne ji od roucha aneb od kůže, aneb od osnovy, aneb od outku. ");
INSERT INTO ces1613_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Jestliže se pak ukáže ještě na rouchu aneb na osnově, aneb na outku, aneb na kterékoli nádobě kožené, malomocenství rozjídající se jest. Ohněm spálíš věc tu, na kteréž by ta rána byla. ");
INSERT INTO ces1613_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Roucho pak aneb osnovu, aneb outek, aneb kteroukoli nádobu koženou, když bys zepral, a odešla by od ní ta rána, ještě po druhé zpéřeš, a čisté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Tenť jest zákon o ráně malomocenství na rouchu soukenném aneb lněném, aneb na osnově, aneb na outku, aneb na kterékoli nádobě kožené, kterak má za čistou aneb za nečistou uznána býti. ");
INSERT INTO ces1613_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Tento bude řád při malomocném v den očišťování jeho: K knězi přiveden bude. ");
INSERT INTO ces1613_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","I vyjde kněz ven z stanů a pohledí na něj, a uzří-li, že uzdravena jest rána malomocenství malomocného: ");
INSERT INTO ces1613_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Rozkáže kněz tomu, kterýž se očišťuje, vzíti dva vrabce živé a čisté, a dřevo cedrové, a červec dvakrát barvený, a yzop. ");
INSERT INTO ces1613_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","I rozkáže kněz zabiti vrabce jednoho, a vycediti krev z něho do nádoby hliněné nad vodou živou. ");
INSERT INTO ces1613_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","A vezme vrabce živého a dřevo cedrové, též červec dvakrát barvený, a yzop, a omočí to všecko i s vrabcem živým ve krvi vrabce zabitého nad vodou živou. ");
INSERT INTO ces1613_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Tedy pokropí toho, kterýž se očišťuje od malomocenství, sedmkrát, a za čistého jej vyhlásí, i pustí vrabce živého na pole. ");
INSERT INTO ces1613_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ten pak, kterýž se očišťuje, zpéře roucho své a oholí všecky vlasy své, umyje se vodou, a čistý bude. Potom vejde do táboru, a bydliti bude vně, nevcházeje do stanu svého za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Dne pak sedmého sholí všecky vlasy své, hlavu i bradu svou, i obočí své, a tak všecky vlasy své sholí; zpéře také roucha svá a tělo své umyje vodou, a tak očistí se. ");
INSERT INTO ces1613_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Dne pak osmého vezme dva beránky bez poškvrny, a ovci jednu roční bez poškvrny, a tři desetiny efi mouky bělné k oběti suché, olejem zadělané, a oleje jednu mírku. ");
INSERT INTO ces1613_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kněz pak, kterýž očišťuje, postaví toho člověka očišťujícího se s těmi věcmi před Hospodinem u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","I vezme kněz beránka jednoho, kteréhožto obětovati bude v obět za hřích, a mírku oleje, a obraceti bude tím sem i tam v obět obracení před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","A zabije beránka toho na místě, kdež se zabijí obět za hřích a obět zápalná, totiž na místě svatém; nebo jakož obět za hřích, tak obět za vinu knězi přináleží, svatá svatých jest. ");
INSERT INTO ces1613_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","I vezme kněz krve z oběti za hřích, a pomaže jí kraje ucha pravého člověka toho, kterýž se očišťuje, a palce ruky jeho pravé, a palce nohy jeho pravé. ");
INSERT INTO ces1613_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Vezme také kněz z té mírky oleje, a naleje na ruku svou levou. ");
INSERT INTO ces1613_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","A omoče prst svůj pravý v tom oleji, kterýž má na ruce své levé, pokropí z něho prstem svým sedmkrát před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Z ostatku pak oleje toho, kterýž má na ruce své, pomaže kněz kraje ucha pravého člověka toho, kterýž se očišťuje, a palce pravé ruky jeho, a palce pravé nohy jeho, na krev oběti za vinu. ");
INSERT INTO ces1613_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Což pak zůstane oleje, kterýž jest v ruce kněze, pomaže tím hlavy toho, kterýž se očišťuje; a tak očistí jej kněz před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Učiní také kněz obět za hřích, a očistí očišťujícího se od nečistoty jeho. A potom zabije obět zápalnou. ");
INSERT INTO ces1613_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","I bude obětovati kněz tu obět zápalnou, i obět suchou na oltáři; a tak očistí jej, i bude čistý. ");
INSERT INTO ces1613_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Jestliže pak bude chudý, tak že by s to býti nemohl, tedy vezme jednoho beránka v obět za provinění, k obracení jí sem i tam pro očištění své, a desátý díl mouky bělné olejem zadělané k oběti suché, a mírku oleje, ");
INSERT INTO ces1613_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Též dvě hrdličky aneb dvé holoubátek, kteréž by mohl míti, a bude jedno v obět za hřích, a druhé v obět zápalnou. ");
INSERT INTO ces1613_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","I přinese je v osmý den očišťování svého knězi, ke dveřům stánku úmluvy před Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Tedy kněz vezma beránka oběti za vinu a mírku oleje, obraceti je bude sem i tam v obět obracení před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","I zabije beránka oběti za provinění, a vezma krve z oběti za provinění, pomaže jí kraje ucha pravého člověka toho, kterýž se očišťuje, a palce ruky jeho pravé, a palce nohy jeho pravé. ");
INSERT INTO ces1613_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Oleje také naleje kněz na ruku svou levou. ");
INSERT INTO ces1613_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","A omoče prst svůj pravý v oleji, kterýž bude na ruce jeho levé, pokropí jím sedmkrát před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Pomaže také kněz olejem, kterýž má na ruce své, kraje ucha pravého toho, kdož se čistí, a palce pravé ruky jeho, a palce pravé nohy jeho, na místě krve z oběti za vinu. ");
INSERT INTO ces1613_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Což pak zůstává oleje, kterýž jest v ruce kněze, pomaže jím hlavy toho, kterýž se očišťuje; a tak očistí jej před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Tolikéž učiní i s hrdličkou jednou aneb s holoubátkem z těch, kteréž zjednati mohl. ");
INSERT INTO ces1613_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Z těch, kterýchž dostati mohl, obětovati bude jedno za hřích a druhé v obět zápalnou s obětí suchou; a tak očistí kněz očišťujícího se před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ten jest zákon toho, na komž by se ukázala rána malomocenství, a kterýž by nemohl býti s ty věci k očištění svému přináležité. ");
INSERT INTO ces1613_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","I mluvil Hospodin Mojžíšovi a Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Když vejdete do země Kananejské, kterouž já vám za dědictví dávám, a dopustil bych ránu malomocenství na některý dům země, kterouž vládnouti budete, ");
INSERT INTO ces1613_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Tedy přijde hospodář domu a oznámí knězi řka: Zdá mi se, jako by byla rána malomocenství na domě. ");
INSERT INTO ces1613_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","I rozkáže kněz vyprázdniti dům, dříve než by všel do něho hleděti na tu ránu, aby nebylo poškvrněno něco z těch věcí, kteréž v domě jsou. Potom pak vejde, aby pohleděl na ten dům. ");
INSERT INTO ces1613_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Tedy vida ránu tu, uzří-li, že rána jest na stěnách domu, totiž důlkové názelení aneb náčervení, a na pohledění jsou nižší než stěna jinde: ");
INSERT INTO ces1613_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Vyjde kněz z domu toho ke dveřím jeho, a dá zavříti dům ten za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","A v den sedmý navrátí se kněz, a uzří-li, ano se rozmohla rána na stěnách domu toho: ");
INSERT INTO ces1613_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Rozkáže vyníti kamení, na němž by rána taková byla, a vyvrci je ven za město na místo nečisté. ");
INSERT INTO ces1613_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Dům pak rozkáže vystrouhati vnitř všudy vůkol; a vysypou prach ten, kterýž sstrouhali, vně za městem na místo nečisté. ");
INSERT INTO ces1613_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","A vezmouce jiné kamení, vyplní jím místo onoho kamení; tolikéž hliny jiné vezmouce, vymaží dům. ");
INSERT INTO ces1613_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Pakliť by se navrátila rána, a vzrostla by v tom domě po vyvržení kamení a vystrouhání domu, i po vymazání jeho, ");
INSERT INTO ces1613_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Tedy vejda kněz, uzří-li, an se rozmohla rána v domě, malomocenství rozjídající se jest v tom domě, nečistý jest. ");
INSERT INTO ces1613_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","I rozboří ten dům a kamení jeho, i dříví jeho, a všecko mazání domu toho, a vynosí ven za město na místo nečisté. ");
INSERT INTO ces1613_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Jestliže by pak kdo všel do domu toho v ten čas, když zavřín byl, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","A jestliže by kdo spal v tom domě, zpéře roucha svá; tolikéž jestliže by kdo jedl v tom domě, zpéře roucha svá. ");
INSERT INTO ces1613_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Jestliže by pak kněz vejda tam, uzřel, že se nerozmohla rána v domě po obnovení jeho, tedy za čistý vyhlásí dům ten; nebo uzdravena jest rána jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","A vezma k očištění domu toho dva vrabce a dřevo cedrové, a červec dvakrát barvený a yzop, ");
INSERT INTO ces1613_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","I zabije vrabce jednoho, a vycedí krev do nádoby hliněné nad vodou živou. ");
INSERT INTO ces1613_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","A vezme dřevo cedrové a yzop, a červec dvakrát barvený, a vrabce živého, omočí to všecko ve krvi vrabce zabitého a u vodě živé, a pokropí domu toho sedmkrát. ");
INSERT INTO ces1613_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","A tak když očistí dům ten krví vrabce a vodou živou a ptákem živým, dřevem cedrovým, yzopem a červcem dvakrát barveným: ");
INSERT INTO ces1613_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Vypustí ven vrabce živého z města na pole, a očistí dům ten, i budeť čistý. ");
INSERT INTO ces1613_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ten jest zákon o všeliké ráně malomocenství a poškvrny černé, ");
INSERT INTO ces1613_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","A malomocenství roucha i domu, ");
INSERT INTO ces1613_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","I otekliny, prašiviny a poškvrny pobělavé, ");
INSERT INTO ces1613_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","K ukázání, kdy jest kdo čistý, aneb kdy jest kdo nečistý. Tenť jest zákon malomocenství. ");
INSERT INTO ces1613_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mluvil pak Hospodin Mojžíšovi a Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Mluvte synům Izraelským a rcete jim: Když by který muž trpěl tok semene z těla svého, nečistý bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Tato pak bude nečistota jeho v toku jeho: Jestliže vypěňuje tělo jeho tok svůj, aneb že by se zastavil tok v těle jeho, nečistota jeho jest. ");
INSERT INTO ces1613_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Každé lůže, na němž by ležel, kdož má tok semene, nečisté bude; a všecko, na čemž by seděl, nečisté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","A kdož by se dotekl lůže jeho, zpéře roucha svá, a umyje se vodou, a bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","A kdo by sedl na to, na čemž seděl ten, kdož má tok semene, zpéře roucha svá, a umyje se vodou, i bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Jestliže by se kdo dotekl těla trpícího tok semene, zpéře roucha svá, a umyje se vodou, i bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","A jestliže by ten, kdož trpí tok semene, plinul na čistého, zpéře roucha svá, a umyje se vodou, i bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Každé sedlo, na němž by seděl ten, kdož má tok semene, nečisté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","A kdož by koli dotekl se něčeho, což bylo pod ním, nečistý bude až do večera; a kdož by co z toho nesl, zpéře roucha svá, a umyje se vodou, a bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Kohož by se pak dotekl ten, kdož má tok semene, a neumyl rukou svých vodou, zpéře roucha svá, a umyje se vodou, i bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Nádoba hliněná, kteréž by se dotekl ten, kdo má tok semene, bude rozbita, a každá nádoba dřevěná vodou vymyta bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Když by pak očištěn byl ten, kdož tok semene trpěl, od toku svého, sečte sedm dní po svém očištění, a zpéře roucha svá, a vodou živou zmyje tělo své, i bude čist. ");
INSERT INTO ces1613_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Potom dne osmého vezme sobě dvě hrdličky aneb dvé holoubátek, a přijda před Hospodina ke dveřím stánku úmluvy, dá je knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kterýž obětovati je bude, jedno za hřích a druhé v obět zápalnou; a očistí jej kněz před Hospodinem od toku jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Muž, z něhož by vyšlo símě scházení, zmyje vodou všecko tělo své, a bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Každé roucho i každá kůže, na níž by bylo símě scházení, zeprána bude vodou, a nečistá bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Žena také, s kterouž by obýval muž scházením semene, oba zmyjí se vodou, a nečistí budou až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Žena pak, když by trpěla nemoc svou, a tok krve byl by z těla jejího, za sedm dní oddělena bude; každý, kdož by se jí dotekl, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Na čemž by koli ležela v čas oddělení svého, nečistéť bude; tolikéž, na čem by koli seděla, nečisté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Také kdož by se dotekl lůže jejího, zpéře roucho své, a umyje se vodou, i bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Kdož by se koli dotekl toho, na čemž seděla, zpéře roucha svá, a umyje se vodou, i bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Což by koli bylo na lůži tom, neb na jaké by koli věci seděla, a dotekl by se toho někdo, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Jestliže by kdo spal s ní, a byla by nečistota její na něm, nečistý bude za sedm dní; i každé lůže, na němž by spal, nečisté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Žena pak trpěla-li by krvotok po mnohé dny, kromě času nemoci své, totiž krvotok by trpěla přes čas přirozené nemoci: po všecky dny toku nečistoty své, jako i v čas nemoci své přirozené, nečistá bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Každé lůže, na němž by spala po všecky dny toku svého, bude jí jako lůže v přirozené nemoci její; a každá věc, na kteréž by seděla, nečistá bude, podlé nečistoty přirozené nemoci její. ");
INSERT INTO ces1613_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Kdož by koli dotekl se těch věcí, nečistý bude. Protož zpéře roucho své, a umyje se vodou, i bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Když pak očištěna bude od toku svého, sečte sobě sedm dní, a potom očišťovati se bude. ");
INSERT INTO ces1613_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","A v den osmý vezme sobě dvě hrdličky aneb dvé holoubátek, a přinese je knězi ke dveřím stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Z nichž jedno obětovati bude kněz v obět za hřích, a druhé v obět zápalnou, a očistí ji kněz před Hospodinem od toku nečistoty její. ");
INSERT INTO ces1613_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","I budete oddělovati syny Izraelské od nečistot jejich, aby nezemřeli pro nečistoty své, když by poškvrnili příbytku mého, kterýž jest u prostřed nich. ");
INSERT INTO ces1613_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Toť jest právo trpícího tok semene, i toho, z něhož vychází símě scházení, jímž poškvrněn bývá, ");
INSERT INTO ces1613_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Též nemocné ženy v oddělení jejím, i všelikého trpícího tok svůj, buď mužského pohlaví neb ženského, a muže, kterýž by spal s nečistou. ");
INSERT INTO ces1613_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Mluvil pak Hospodin k Mojžíšovi po smrti dvou synů Aronových, kteřížto, když předstoupili před Hospodina, zemřeli, ");
INSERT INTO ces1613_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","A řekl Hospodin Mojžíšovi: Mluv Aronovi bratru svému, ať nevchází každého času do svatyně za oponu před slitovnici, kteráž jest na truhle, aby neumřel; nebo já v oblace ukáži se nad slitovnicí. ");
INSERT INTO ces1613_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","S tímto vcházeti bude Aron do svatyně: S volkem mladým, kterýž bude v obět za hřích, a s beranem k oběti zápalné. ");
INSERT INTO ces1613_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","V sukni lněnou svatou obleče se, a košilku lněnou bude míti na těle hanby své, pasem také lněným opáše se, a čepici lněnou vstaví na hlavu, roucha zajisté svatá jsou tato; i umyje vodou tělo své a obleče se v ně. ");
INSERT INTO ces1613_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Od shromáždění pak synů Izraelských vezme dva kozly k oběti za hřích, a jednoho berana k zápalné oběti. ");
INSERT INTO ces1613_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","I bude obětovati Aron volka svého v obět za hřích, a očistí sebe i dům svůj. ");
INSERT INTO ces1613_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Potom vezme ty dva kozly a postaví je před Hospodinem u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","I dá Aron na ty dva kozly losy, los jeden Hospodinu, a los druhý Azazel. ");
INSERT INTO ces1613_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","A obětovati bude Aron kozla toho, na něhož by los padl Hospodinu, obětovati jej bude za hřích. ");
INSERT INTO ces1613_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Kozla pak toho, na něhož přišel los Azazel, postaví živého před Hospodinem, aby skrze něho učinil očištění, a pustí ho na poušť k Azazel. ");
INSERT INTO ces1613_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","I bude obětovati Aron volka svého v obět za hřích, a očistí sebe i dům svůj, a zabije volka svého v obět za hřích. ");
INSERT INTO ces1613_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Vezme také plnou kadidlnici uhlí řeřavého s oltáře, kterýž jest před tváří Hospodinovou, a plné obě hrsti své vonných věcí stlučených, a vnese za oponu. ");
INSERT INTO ces1613_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","A vloží kadidlo to na oheň před Hospodinem, a dým kadění toho přikryje slitovnici, kteráž jest nad svědectvím, a neumře. ");
INSERT INTO ces1613_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Potom vezma krve volka toho, pokropí prstem svým na slitovnicí k východu; tolikéž před slitovnicí kropiti bude sedmkrát krví tou prstem svým. ");
INSERT INTO ces1613_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Zabije také v obět za hřích kozla toho, kterýž jest lidu, a vnese krev jeho do vnitřku za oponu, a učiní se krví jeho, jakož učinil se krví volka, totiž pokropí jí na slitovnici a před slitovnicí. ");
INSERT INTO ces1613_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","A očistí svatyni od nečistot synů Izraelských a od přestoupení jejich i všech hříchů jejich. Totéž učiní i stánku úmluvy, kterýž jest mezi nimi u prostřed nečistot jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","(Žádný pak člověk ať není v stánku úmluvy, když on vchází k očišťování do svatyně, dokudž by on zase nevyšel a očištění za sebe, za dům svůj i za všecko množství Izraelské nevykonal.) ");
INSERT INTO ces1613_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Vyjde pak k oltáři, kterýž jest před Hospodinem, a očistí jej. A vezma krve volka toho, a ze krve kozla, dá na rohy oltáře vůkol. ");
INSERT INTO ces1613_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","A pokropí ho svrchu krví tou prstem svým sedmkrát, a očistí jej i posvětí ho od nečistot synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","A když by dokonal očištění svatyně a stánku úmluvy a oltáře, obětovati bude kozla živého. ");
INSERT INTO ces1613_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","A vlože Aron obě ruce své na hlavu kozla živého, vyznávati bude nad ním všecky nepravosti synů Izraelských, a všecka přestoupení jejich se všemi hříchy jejich, a vloží je na hlavu kozla, a vyžene ho člověk k tomu zřízený na poušť. ");
INSERT INTO ces1613_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","(Kozel ten zajisté ponese na sobě všecky nepravosti jejich do země pusté.) A pustí kozla toho na poušti. ");
INSERT INTO ces1613_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Potom pak přijda Aron do stánku úmluvy, svleče s sebe roucha lněná, v něž se byl oblékl, když vjíti měl do svatyně, a nechá jich tu. ");
INSERT INTO ces1613_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A umyje tělo své vodou na místě svatém, a obleče se zase v roucha svá, a vyjda, obětovati bude obět zápalnou svou a obět zápalnou lidu, a očistí sebe i lid. ");
INSERT INTO ces1613_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A tuk oběti za hřích páliti bude na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ten pak, kterýž vyvedl kozla na Azazel, zpéře roucha svá, a zmyje tělo své vodou, a potom vejde do stanů. ");
INSERT INTO ces1613_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Volka pak za hřích a kozla za hřích, jejichž krev vnesena byla k vykonání očištění v svatyni, vynese ven z táboru, a spálí ohněm kůže jejich, i maso jejich, i lejna jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Kdož by pak spálil je, zpéře roucha svá, a umyje tělo své vodou, a potom vejde do táboru. ");
INSERT INTO ces1613_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Bude vám i toto za věčné ustanovení: Sedmého měsíce, desátého dne téhož měsíce ponižovati budete duší svých, a žádného díla nebudete dělati, ani doma zrozený, ani příchozí, kterýž jest pohostinu mezi vámi. ");
INSERT INTO ces1613_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Nebo v ten den očistí vás, abyste očištěni byli; ode všech hříchů svých před Hospodinem očištěni budete. ");
INSERT INTO ces1613_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Sobota odpočinutí bude vám, a ponižovati budete duší svých ustanovením věčným. ");
INSERT INTO ces1613_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Očišťovati pak bude kněz, kterýž jest pomazaný, a jehož ruce posvěceny jsou k vykonávání úřadu kněžského místo otce svého, a obleče se v roucha lněná, roucha svatá. ");
INSERT INTO ces1613_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","A očistí svatyni svatou a stánek úmluvy, očistí také i oltář, i kněží, i všecken lid shromážděný očistí. ");
INSERT INTO ces1613_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","A bude vám to ustanovením věčným k očišťování synů Izraelských ode všech hříchů jejich, každého roku jednou. I učinil Mojžíš tak, jakž jemu byl přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","I mluvil Hospodin Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Mluv k Aronovi a synům jeho i ke všechněm synům Izraelským, a rci jim: Tato jest věc, kterouž přikázal Hospodin, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Kdož by koli z domu Izraelského zabil vola aneb beránka, neb kozu, buď mezi stany, aneb kdož by zabil vně za stany, ");
INSERT INTO ces1613_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","A ke dveřím stánku úmluvy nepřivedl by ho, aby obětoval obět Hospodinu před příbytkem Hospodinovým: vinen bude krví, nebo krev vylil; protož vyhlazen bude muž ten z prostředku lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Přivedou tedy synové Izraelští oběti své, kteréž by na poli zabíjeti chtěli, přivedou je, pravím, k Hospodinu ke dveřím stánku úmluvy, k knězi, a obětovati budou oběti pokojné Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","A pokropí kněz krví na oltáři Hospodinovu u dveří stánku úmluvy, a páliti bude tuk u vůni líbeznou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","A nikoli více nebudou obětovati obětí svých ďáblům, po nichžto odcházejíce, oni smilní. Zákon tento bude jim věčný i všechněm potomkům jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Protož povíš jim: Kdož by koli z domu Izraelského aneb z příchozích, kteříž by pohostinu byli mezi vámi, obětoval zápal aneb jinou obět, ");
INSERT INTO ces1613_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","A ke dveřím stánku úmluvy nepřivedl by jí, aby ji obětoval Hospodinu; tedy vyhlazen bude člověk ten z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","A kdož by koli z domu Izraelského aneb z příchozích, kteříž jsou pohostinu mezi nimi, jedl jakou krev: postavím tvář svou proti člověku tomu, a vyhladím jej z prostředku lidu jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nebo duše všelikého těla ve krvi jest, já pak oddal jsem vám ji k oltáři, k očišťování duší vašich. Nebo sama krev na duši očišťuje. ");
INSERT INTO ces1613_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Protož řekl jsem synům Izraelským: Nižádný z vás nebude jísti krve; ani příchozí, kterýž pohostinu jest mezi vámi, nebude krve jísti. ");
INSERT INTO ces1613_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","A kdož by koli z synů Izraelských aneb z příchozích, kteříž jsou pohostinu mezi vámi, honě, ulovil zvíře aneb ptáka, což se jísti může, tedy vycedí krev jeho a zasype ji prstí. ");
INSERT INTO ces1613_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Nebo duše všelikého těla jest krev jeho, kteráž jest v duši jeho. Protož jsem pověděl synům Izraelským: Krve žádného těla jísti nebudete, nebo duše všelikého těla jest krev jeho; kdož by koli jedl ji, vyhlazen bude. ");
INSERT INTO ces1613_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Kdož by pak koli jedl tělo mrtvé aneb udávené, buď on doma zrozený aneb příchozí: zpéře roucha svá, a umyje se vodou, a nečistý bude až do večera, potom pak čistý bude. ");
INSERT INTO ces1613_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","A pakli nezpéře roucha svého, a těla svého neumyje, tedy ponese nepravost svou. ");
INSERT INTO ces1613_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Mluv synům Izraelským a rci jim: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Vedlé skutků země Egyptské, v níž jste bydlili, nečiňte, ani podlé skutků země Kananejské, do kteréž já vás uvozuji, činiti budete, a v ustanoveních jejich nechoďte. ");
INSERT INTO ces1613_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Soudy mé čiňte a ustanovení mých ostříhejte, abyste chodili v nich: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ostříhejte ustanovení mých a soudů mých. Èlověk ten, kterýž by je činil, živ bude v nich: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nižádný člověk k žádné přítelkyni krevní nepřistupuj k obnažení hanby její: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Hanby otce svého a matky své neodkryješ; matka tvá jest, neodkryješ hanby její. ");
INSERT INTO ces1613_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Hanby ženy otce svého neodkryješ; nebo hanba otce tvého jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Hanby sestry své, dcery otce svého aneb dcery matky své, kteráž doma zplozena aneb vně zplozena jest, neodkryješ hanby jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Hanby vnučky své, buď po synu neb dceři své, neodkryješ; nebo hanba tvá jsou. ");
INSERT INTO ces1613_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Hanby dcery manželky otce svého, kteráž jest zplozena od otce tvého, tvá sestra jest, neodkryješ hanby její. ");
INSERT INTO ces1613_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Hanby sestry otce svého neodkryješ; nebo krevní přítelkyně otce tvého jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Hanby sestry matky své neodkryješ; nebo krevní přítelkyně matky tvé jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Hanby bratra otce svého neodkryješ; k manželce jeho nevejdeš, stryna tvá jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Hanby nevěsty své neodkryješ; manželka jest syna tvého, neodkryješ hanby její. ");
INSERT INTO ces1613_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Hanby manželky bratra svého neodkryješ; nebo hanba bratra tvého jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Hanby ženy a dcery její neodkryješ. Vnučky její po synu neb po dceři její nepojmeš, abys odkryl hanbu její; nebo krevní jsou, a nešlechetnost jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Nevezmeš sobě ženy k ženě první, abys ssoužil ji, odkrývaje hanbu její za života jejího. ");
INSERT INTO ces1613_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Také k ženě, když jest v své nemoci nečisté, nepřistoupíš, odkrývaje hanbu její. ");
INSERT INTO ces1613_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","S manželkou bližního svého nebudeš obcovati, poškvrňuje se s ní. ");
INSERT INTO ces1613_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Nedopustíš, aby kdo z semene tvého proveden byl skrze oheň modly Moloch, abys nepoškvrnil jména Boha svého: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Nebudeš obcovati s mužským pohlavím, scházeje se s ním jako s ženou; nebo ohavnost jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","A s žádným hovadem nebudeš obcovati, poškvrňuje se s ním; ani žena nepoddá se hovadu, aby s ním obývala; nebo mrzkost jest. ");
INSERT INTO ces1613_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","A protož nepoškvrňujtež se žádnou touto věcí; nebo těmito všemi věcmi poškvrnili se pohané, kteréž já vyvrhu od tváři vaší. ");
INSERT INTO ces1613_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Nebo poškvrnila se země, a navštívím nepravost její na ní, a vyvrátí země obyvatele své. ");
INSERT INTO ces1613_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ale vy ostříhejte ustanovení mých a soudů mých, a nečiňte nižádných ohavností těchto, tak domácí jako příchozí, kterýž jest pohostinu u prostřed vás. ");
INSERT INTO ces1613_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(Nebo všecky ty ohavnosti činili lidé země té, kteříž byli před vámi, čímž poškvrněna jest země.) ");
INSERT INTO ces1613_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Aby nevyvrátila vás země, proto že byste jí poškvrnili, jako vyvrátila národ, kterýž byl před vámi. ");
INSERT INTO ces1613_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Nebo kdož by koli dopustil se některé ze všech ohavností těch: duše zajisté, kteréž by činily to, vyhlazeny budou z prostředku lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Protož ostříhejte přikázání mých, abyste nečinili ničeho z obyčejů ohavných, kteříž činěni jsou před vámi, aniž sebe jimi poškvrňujte: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Mluv ke všemu množství synů Izraelských a rci jim: Svatí buďte, nebo svatý jsem, já Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Jeden každý matky své a otce svého báti se budete. A sobot mých ostříhejte, nebo já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Neobracejte se k modlám, a bohů litých nedělejte sobě: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","A když obětovati budete oběti pokojné Hospodinu, z dobré vůle své obětovati budete je. ");
INSERT INTO ces1613_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kterého dne obětovati budete, jísti budete je, i nazejtří; což by pak zůstalo až do třetího dne, ohněm spáleno bude. ");
INSERT INTO ces1613_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Pakli předce jísti budete dne třetího, věc ohavná bude, a nebude oblíbena. ");
INSERT INTO ces1613_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Kdož by to jedl, pokutu nepravosti své ponese; nebo svatosti Hospodinovy poškvrnil, protož vyhlazena bude duše ta z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Když budete žíti obilé země vaší, nesežneš naskrze všeho pole svého, a nebudeš sbírati pozůstalých klasů žně své. ");
INSERT INTO ces1613_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Tolikéž ostatků vinice své nebudeš bráti, a zrní vinice své nebudeš sbírati; chudému a příchozímu zanecháš toho: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Nekraďte a nelžete, a nižádný neoklamávej bližního svého. ");
INSERT INTO ces1613_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Nepřisahejte křivě ve jméno mé, aniž kdo poškvrňuj jména Boha svého: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Neutiskneš mocí bližního svého, aniž obloupíš ho. Nezůstane mzda dělníka u tebe až do jitra. ");
INSERT INTO ces1613_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Hluchému nebudeš zlořečiti, a před slepým nepoložíš úrazu, ale báti se budeš Boha svého, nebo já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Neučiníš neprávě v soudu. Nepřijmeš osoby chudého, aniž šanovati budeš osoby bohatého; spravedlivě souditi budeš bližního svého. ");
INSERT INTO ces1613_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Nebudeš choditi jako utrhač v lidu svém, aniž státi budeš na hrdlo bližnímu svému: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Nebudeš nenáviděti bratra svého v srdci svém; svobodně potresceš bližního svého, a nesneseš na něm hříchu. ");
INSERT INTO ces1613_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nebudeš se mstíti, aniž držeti budeš hněvu proti synům lidu svého, ale milovati budeš bližního svého jako sebe samého: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Ustanovení mých ostříhejte. Hovadu svému nedáš se scházeti s hovadem jiného pokolení. Pole svého neposeješ rozdílným semenem, a rouchem z rozdílných věcí, jako z vlny a ze lnu, setkaným nebudeš se odívati. ");
INSERT INTO ces1613_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Jestliže by muž spal s ženou, a obcoval s ní, kteráž děvkou jsuc, byla by zasnoubená jinému muži, a nebyla by žádnou mzdou vykoupena, ani propuštěna: oba dva zmrskáni budou, a neumrouť; nebo nebyla svobodná učiněna. ");
INSERT INTO ces1613_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","On pak přivede obět za vinu svou Hospodinu ke dveřím stánku úmluvy, skopce za vinu. ");
INSERT INTO ces1613_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","I očistí jej kněz skopcem, kterýž se obětuje za vinu před Hospodinem, od hříchů jeho, kterýmž zhřešil, a bude mu odpuštěn hřích jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Když pak vejdete do země, a nasázíte všelikého stromoví ovoce nesoucího, tedy obřežete neobřezání jeho, totiž ovoce jeho. Po tři léta budete míti je za neobřezané, protož nebude jedeno. ");
INSERT INTO ces1613_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ètvrtého pak léta bude všeliké ovoce jeho posvěcené k chválení Hospodina, ");
INSERT INTO ces1613_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","(Pátého teprv léta jísti budete ovoce jeho), aby rozmnožil vám úrody jeho; nebo já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Nic nebudete jísti se krví. Nebudete hádati, aniž na časích zakládati budete. ");
INSERT INTO ces1613_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Nebudeš střihati vlasů hlavy své okrouhle, aniž zohaví kdo brady své. ");
INSERT INTO ces1613_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Nad mrtvým pak nebudete řezati těla svého, a žádného znamení vyrytého na sobě neučiníte: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Nepoškvrňuj dcery své, dopouštěje smilniti jí, aby země nesmilnila a nebyla naplněna nešlechetností. ");
INSERT INTO ces1613_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Sobot mých ostříhati budete, a svatyně mé báti se budete: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Neobracejte se k hadačům a věšťcům, ani od nich rady beřte, poškvrňujíce se s nimi: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Před člověkem šedivým povstaň, a cti osobu starého, a boj se Boha svého, nebo já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Jestliže bude pohostinu u tebe příchozí v zemi vaší, nečiňte jemu křivdy. ");
INSERT INTO ces1613_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Jakožto jeden z doma zrozených vašich, tak bude vám příchozí, kterýž jest u vás pohostinu, a milovati ho budeš jako sebe samého; nebo i vy pohostinu jste byli v zemi Egyptské: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Nečiňte neprávě v soudu, v rozměřování, v váze a v míře. ");
INSERT INTO ces1613_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Závaží spravedlivé, kámen spravedlivý, korec spravedlivý, pintu spravedlivou míti budete: Já jsem Hospodin Bůh váš, kterýž jsem vás vyvedl z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Protož ostříhejte všech ustanovení mých a všech soudů mých, a čiňte je, nebo já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Synům také Izraelským díš: Kdo by koli z synů Izraelských a z příchozích, kteříž by byli pohostinu v Izraeli, dal z semene svého modle Moloch, smrtí umře. Lid země té kamením jej uhází. ");
INSERT INTO ces1613_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nebo já postavím tvář svou proti takovému, a vyhladím ho z prostředku lidu jeho, proto že z semene svého dal modle Moloch, a tak zprznil svatyni mou, a poškvrnil jména svatosti mé. ");
INSERT INTO ces1613_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Jestliže by pak lid země té všelijak přehlídal to na člověku tom, kterýž by dal z semene svého modle Moloch, a nezahubil by ho: ");
INSERT INTO ces1613_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Tedy já postavím tvář svou proti muži tomu a proti čeledi jeho, a vyhladím ho i všecky, kteříž smilníce, odcházeli po něm, aby smilnili, následujíce Molocha, z prostředku lidu jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Duše, kteráž by se obrátila k hadačům a věšťcům, aby smilnila, postupujíc po nich: postavím tvář svou proti duši té, a vyhladím ji z prostředku lidu jejího. ");
INSERT INTO ces1613_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","A protož posvěťte se a buďte svatí, nebo já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","A ostříhejte ustanovení mých, a čiňte je: Já jsem Hospodin posvětitel váš. ");
INSERT INTO ces1613_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Kdož by koli zlořečil otci svému neb matce své, smrtí umře. Otci svému a matce své zlořečil, krev jeho bude na něm. ");
INSERT INTO ces1613_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Muž, pak, kterýž by se cizoložství dopustil s ženou něčí, že zcizoložil s ženou bližního svého, smrtí umře cizoložník ten i cizoložnice. ");
INSERT INTO ces1613_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","A kdož by koli obcoval s ženou otce svého, hanbu otce svého odkryl. Smrtí umrou oba dva, krev jejich bude na ně. ");
INSERT INTO ces1613_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kdož by pak obcoval s nevěstou svou, smrtí umrou oba dva. Mrzkosti se dopustili, krev jejich bude na ně. ");
INSERT INTO ces1613_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","A kdož by se scházel s pohlavím mužským jako s ženou, ohavnost učinili oba dva. Smrtí umrou, krev jejich bude na ně. ");
INSERT INTO ces1613_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","A kdož by vzal ženu a matku její nešlechetnost jest. Ohněm spálí i jej i je, aby nebylo nešlechetností u prostřed vás. ");
INSERT INTO ces1613_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kdož by pak obcoval s hovadem, smrtí umře, a hovado zabijete. ");
INSERT INTO ces1613_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Tolikéž žena, kteráž by přistoupila k některému hovadu, aby obcovala s ním, zabiješ ji i to hovado. Smrtí umrou, krev jejich bude na ně. ");
INSERT INTO ces1613_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kdož by koli vezma sestru svou, dceru otce svého, aneb dceru matky své, viděl by hanbu její, a ona také viděla by hanbu jeho, mrzkost jest. Protož vyhlazeni budou před očima synů lidu svého; nebo hanbu sestry své odkryl, nepravost svou ponese. ");
INSERT INTO ces1613_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","A kdož by koli spal s ženou v její nemoci a obnažil by hanbu její, a tok její by odkryl, i ona ukázala by krvotok svůj: vyhlazeni budou oba z prostředku lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Hanby sestry matky své a sestry otce svého neodkryješ. Nebo kdož by to učinil, krevní přítelkyni svou by obnažil; protož nepravost svou ponesou. ");
INSERT INTO ces1613_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kdož by pak spal s ženou strýce svého, hanbu strýce svého odkryl. Ponesou hřích svůj, bez dětí zemrou. ");
INSERT INTO ces1613_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Tolikéž kdož by vzal manželku bratra svého, mrzkost jest. Hanbu bratra svého obnažil, protož bez dětí budou. ");
INSERT INTO ces1613_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Ostříhejtež tedy všech ustanovení mých a všech soudů mých, a čiňte je, aby nevyvrátila vás země, do níž já uvozuji vás, abyste v ní bydlili. ");
INSERT INTO ces1613_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Aniž choďte v ustanoveních národu toho, kterýž já vyvrhu od tváři vaší; nebo všecky ty věci činili, a měl jsem je v ošklivosti. ");
INSERT INTO ces1613_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Vám jsem pak řekl: Vládnouti budete zemí jejich, a já dám ji vám, abyste ji dědičně obdrželi, zemi tekoucí mlékem a strdí. Já jsem Hospodin Bůh váš, kterýž jsem vás oddělil od jiných národů. ");
INSERT INTO ces1613_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Protož vy mějte rozdíl mezi hovadem čistým a nečistým, a mezi ptákem čistým a nečistým, a nepoškvrňujte duší svých hovady a ptactvem, a tím vším, což se plazí po zemi, kteréž jsem já vám oddělil, abyste je měli za nečisté. ");
INSERT INTO ces1613_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ale budete mi svatí; nebo svatý jsem já Hospodin, a oddělil jsem vás od jiných národů, abyste byli moji. ");
INSERT INTO ces1613_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Muž pak neb žena, kteříž by měli ducha čarodějného a věštího, smrtí umrou. Kamením uházejí je, krev jejich bude na ně. ");
INSERT INTO ces1613_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Řekl také Hospodin Mojžíšovi: Mluv kněžím synům Aronovým a rci jim: Při mrtvém nepoškvrní se žádný z vás v lidu svém. ");
INSERT INTO ces1613_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Toliko při krevním příteli svém, mateři neb otci svém, synu neb dceři své a bratru svém, ");
INSERT INTO ces1613_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Též při sestře své, panně sobě nejbližší, kteráž neměla muže, při té poškvrní se. ");
INSERT INTO ces1613_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Nepoškvrní se při knížeti lidu svého, tak aby nečistý byl. ");
INSERT INTO ces1613_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Nebudou dělati sobě lysiny na hlavě své, vytrhávajíce sobě vlasy. A brady své nebudou holiti, ani těla svého řezati. ");
INSERT INTO ces1613_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Budou svatí Bohu svému, aniž poškvrní jména Boha svého; nebo oběti ohnivé Hospodinovy, chléb Boha svého obětují, protož svatí budou. ");
INSERT INTO ces1613_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ženy nevěstky aneb poškvrněné nevezmou sobě, a ženy zahnané od muže jejího nepojmou; nebo svatý jest jeden každý z nich Bohu svému. ");
INSERT INTO ces1613_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ty také, lide, za svatého budeš jej míti, nebo chléb Boha tvého obětuje. Protož svatý bude tobě, nebo já svatý jsem Hospodin, kterýž posvěcuji vás. ");
INSERT INTO ces1613_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Dcera pak některého kněze, když by se smilství dopustila, otce svého poškvrnila. Ohněm spálena buď. ");
INSERT INTO ces1613_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Kněz pak nejvyšší mezi bratřími svými, na jehožto hlavu vylit jest olej pomazání, a posvětil rukou svých, aby obláčel se v roucho svaté, hlavy své neodkryje a roucha svého neroztrhne. ");
INSERT INTO ces1613_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Aniž k kterému tělu mrtvému přistoupí, a aniž při otci aneb mateři své poškvrní se. ");
INSERT INTO ces1613_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Nevyjde z svatyně a nepoškvrní svatyně Boha svého; nebo koruna oleje pomazání Boha jeho jest na něm: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","On také ženu v panenstvím jejím za manželku sobě pojme. ");
INSERT INTO ces1613_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Vdovy, aneb zahnané, aneb poškvrněné, nevěstky, žádné z těch nebude sobě bráti, ale pannu z lidu svého vezme sobě za manželku. ");
INSERT INTO ces1613_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","A nepoškvrní semene svého v rodu svém, nebo já jsem Hospodin posvětitel jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mluvil opět Hospodin Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Mluv k Aronovi a rci: Kdožkoli z semene tvého po všech rodech svých bude míti na sobě vadu, nechť nepřistupuje, aby obětoval chléb Boha svého. ");
INSERT INTO ces1613_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Nebo žádný muž, kterýž by měl na sobě vadu, nemá přistupovati: Muž slepý, aneb kulhavý, aneb mající oud některý příliš malý, aneb příliš veliký, ");
INSERT INTO ces1613_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Aneb muž, kterýž by měl zlámanou nohu, aneb zlámanou ruku, ");
INSERT INTO ces1613_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Aneb hrbovatý, aneb krhavý, aneb kterýž má bělmo na oku svém, aneb prašivost ustavičnou, neb lišeje, aneb stlačené lůno. ");
INSERT INTO ces1613_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Nižádný muž, kterýž by měl na sobě nějakou vadu, z semene Arona kněze, nepřistoupí, aby obětoval oběti ohnivé Hospodinu; nebo vada na něm jest. Nepřistoupíť, aby obětoval chléb Boha svého. ");
INSERT INTO ces1613_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Chléb však Boha svého z věcí svatosvatých a z věcí svatých jísti bude. ");
INSERT INTO ces1613_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ale za oponu nebude vcházeti a k oltáři nebude přistupovati, nebo vada jest na něm, aby nepoškvrnil svatyně mé; nebo já jsem Hospodin posvětitel jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ta slova mluvil Mojžíš k Aronovi a k synům jeho, i ke všechněm synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Mluv Aronovi a synům jeho, ať se zdržují od věcí těch, kteréž jsou posvěceny od synů Izraelských, a ať nepoškvrňují jména svatého mého v tom, což mi oni posvěcují: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Rci jim: Kdo by koli ze všeho semene vašeho v pronárodech vašich přistoupil ku posvěceným věcem, kterýchž by posvětili synové Izraelští Hospodinu, když nečistota jeho na něm jest, vyhlazena bude duše ta od tváři mé: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Kdo by koli z semene Aronova byl malomocný, aneb tok semene trpící, nebude jísti z věcí posvěcených, dokavadž by se neočistil. A kdož by se koli dotekl nečistoty těla mrtvého, aneb toho, z něhož by vyšlo símě scházení, ");
INSERT INTO ces1613_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Aneb kdo by se dotkl kterého zeměplazu, jímž by se poškvrnil, aneb člověka, pro něhož by byl nečistý vedlé všelijaké nečistoty jeho: ");
INSERT INTO ces1613_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Èlověk, kterýž by se čehokoli toho dotekl, nečistý bude až do večera, a nebude jísti z věcí posvěcených, leč by umyl tělo své vodou. ");
INSERT INTO ces1613_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","A po západu slunce čistý bude, a potom bude moci jísti z věcí posvěcených, nebo pokrm jeho jest. ");
INSERT INTO ces1613_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mrchy a udáveného jísti nebude, aby se tím nepoškvrnil: Já jsem, Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Protož ostříhati budou přisluhování mých, aby hříchů na se neuvedli, a nezemřeli v něm, proto že je zprznili: Jáť jsem Hospodin posvětitel jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Žádný cizí nebude jísti z věcí posvěcených, ani podruh kněžský, ani nájemník nebude jísti věcí posvěcených. ");
INSERT INTO ces1613_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Koupil-li by kněz člověka za své peníze, ten jísti bude z věcí těch, též v domě jeho zplozený; ti budou jísti z pokrmu jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ale dcera knězova, kteráž by se vdala za muže z jiného pokolení, ta z obětí vzhůru pozdvižených, totiž věcí svatých, nebude jísti. ");
INSERT INTO ces1613_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kdyby pak dcera knězova ovdověla, aneb zahnána byla od muže, nemající plodu, a navrátila by se do domu otce svého: tak jako v dětinství svém chléb otce svého jísti bude, cizí pak žádný nebude jísti z něho. ");
INSERT INTO ces1613_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Jedl-li by pak kdo z nedopatření věci posvěcené, pátý díl nad to přidá knězi, a nahradí jemu tu věc posvěcenou, ");
INSERT INTO ces1613_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Aby nepoškvrňovali věcí svatých, kteréž by synové Izraelští obětovali Hospodinu, ");
INSERT INTO ces1613_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","A neuvozovali na ně pokuty za provinění, že jedli věci posvěcené jejich; nebo já jsem Hospodin, kterýž jich posvěcuji. ");
INSERT INTO ces1613_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Dále mluvil Hospodin Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Mluv k Aronovi a k synům jeho i ke všechněm synům Izraelským, a rci jim: Kdož by koli z domu Izraelského aneb z pohostinných, kteříž jsou v Izraeli, obětovali obět svou vedlé všech slibů svých, vedlé všech darů dobrovolných svých, kteréž by obětovali Hospodinu v obět zápalnou: ");
INSERT INTO ces1613_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Z dobré vůle své obětovati budete samce bez poškvrny, z skotů, z ovcí a z koz. ");
INSERT INTO ces1613_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Což by koli mělo na sobě vadu, nebudete toho obětovati; nebo nebude příjemné od vás. ");
INSERT INTO ces1613_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Pakli by kdo obětoval obět pokojnou Hospodinu, vykonávaje slib svůj, aneb dobrovolný dar, buď z skotů, aneb z bravů; ať jest bez vady, aby bylo příjemné; nebudeť žádné poškvrny na něm. ");
INSERT INTO ces1613_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Slepého aneb polámaného, osekaného aneb uhřivého, prašivého aneb s lišeji, takového neobětujte Hospodinu a nedávejte jich k ohnivé oběti na oltář Hospodinův. ");
INSERT INTO ces1613_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Vola neb dobytče s nedorostlými neb přerostlými oudy, v dobrovolný zajisté dar obětovati je budeš, ale za slib nebude příjemný. ");
INSERT INTO ces1613_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ztlačeného aneb ztlučeného, odtrženého, vykleštěného nebudete obětovati Hospodinu; neučiníte toho v zemi vaší. ");
INSERT INTO ces1613_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","A z ruky cizozemce nebudete obětovati chleba Bohu svému ze všech těch věcí, nebo porušení jejich jest na nich; vadu mají, nebudou příjemné od vás. ");
INSERT INTO ces1613_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Vůl neb beran, aneb koza, když se urodí, za sedm dní při matce své zanecháno bude, osmého pak dne i potom bude přijemné k oběti ohnivé Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Krávy pak a dobytčete s mladým jeho nezabijete jednoho dne. ");
INSERT INTO ces1613_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","A když byste obětovali obět chvály Hospodinu, dobrovolně ji obětovati budete. ");
INSERT INTO ces1613_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","V tentýž den snědena bude a nepozůstavíte z ní ničeho až do jitra: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Protož ostříhejte přikázaní mých a čiňte je: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","A nepoškvrňujte jména svatého mého, i buduť posvěcen u prostřed synů Izraelských: Já jsem Hospodin posvětitel váš, ");
INSERT INTO ces1613_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Kterýž jsem vás vyvedl z země Egyptské, abych vám byl za Boha: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mluvil opět Hospodin Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Mluv k synům Izraelským a rci jim: Slavnosti Hospodinovy, kteréž nazývati budete shromáždění svatá, tyto jsou slavnosti mé: ");
INSERT INTO ces1613_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Šest dní dělati budete, dne pak sedmého sobota odpočinutí jest, shromáždění svaté bude. Žádného díla nedělejte, nebo jest sobota Hospodinova, ve všech příbytcích vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Protož tyto jsou slavnosti Hospodinovy, shromáždění svatá, kteréž slaviti budete v časy jich určité: ");
INSERT INTO ces1613_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Měsíce prvního, čtrnáctého dne téhož měsíce u večer bude Fáze Hospodinovo. ");
INSERT INTO ces1613_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","A patnáctého dne téhož měsíce svátek přesnic bude Hospodinu; za sedm dní přesné chleby jísti budete. ");
INSERT INTO ces1613_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Dne prvního sbor svatý míti budete; žádného díla robotného nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ale obětovati budete obět ohnivou Hospodinu za sedm dní. Dne také sedmého sbor svatý bude; žádného díla robotného nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Mluv k synům Izraelským a rci jim: Když vejdete do země, kterouž já dávám vám, a žíti budete obilí její, tedy přinesete snopek prvotiny žně vaší k knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kterýž obraceti bude sem i tam snopek ten před Hospodinem, aby byl příjemnou obětí za vás; nazejtří po sobotě obraceti jej bude kněz. ");
INSERT INTO ces1613_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Kterého dne obraceti budete snopek ten, téhož zabijete beránka ročního bez poškvrny v obět zápalnou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Též i obět suchou jeho, dvě desetiny mouky bělné olejem zadělané, v obět ohnivou Hospodinu u vůni příjemnou, a mokrou obět jeho, vína čtvrtý díl míry hin. ");
INSERT INTO ces1613_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Chleba pak, ani pražmy, ani zrní vymnutého nebudete jísti, až právě do toho dne, když obětovati budete obět Bohu svému. Ustanovení to věčné bude v pronárodech vašich, ve všech příbytcích vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Počtete sobě také od prvního dne po sobotě, ode dne, v němž jste obětovali snopek sem i tam obracení, (plných sedm téhodnů ať jest), ");
INSERT INTO ces1613_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Až do prvního dne po sedmém téhodni, sečtete padesáte dní, a tehdy obětovati budete novou obět suchou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Z příbytků svých přinesete chleby sem i tam obracení, dva bochníky ze dvou desetin mouky bělné budou; kvašené je upečete, prvotiny jsou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","A s tím chlebem obětovati budete sedm beránků ročních bez vady, a volka mladého jednoho, a skopce dva; obět zápalná budou Hospodinu, s obětmi svými suchými i mokrými, obět ohnivá vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Zabijete také kozla jednoho za hřích, a dva beránky roční k oběti pokojné. ");
INSERT INTO ces1613_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","I bude je kněz sem i tam obraceti s chleby prvotin v obět sem i tam obracení před Hospodinem, i s těmi dvěma beránky; a budou svaté věci Hospodinu, a dostanou se knězi. ");
INSERT INTO ces1613_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","I vyhlásíte v ten den slavnost, shromáždění svaté míti budete, žádného díla robotného nebudete dělati. Ustanovení to bude věčné ve všech příbytcích vašich, v pronárodech vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","A když budete žíti obilé krajiny vaší, nesežneš všeho až do konce pole svého, a pozůstalých klasů po žni své nebudeš sbírati; chudému a příchozímu zanecháš jich: Já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mluvil ještě Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Mluv synům Izraelským takto: Měsíce sedmého, v první den téhož měsíce, budete míti odpočinutí, památku troubení, shromáždění svaté držíce. ");
INSERT INTO ces1613_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Žádného díla robotného nebudete dělati, a budete obětovati obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Desátý pak den každého měsíce sedmého den očišťování jest. Shromáždění svaté míti budete, a ponižovati budete životů svých, a obětovati obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Žádného díla nebudete dělati v ten den; nebo den očišťování jest, k očišťování vás před Hospodinem Bohem vaším. ");
INSERT INTO ces1613_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","A všeliká duše, kteráž by neponižovala se toho dne, vyhlazena bude z lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kdož by koli dílo nějaké dělal toho dne, zatratím člověka toho z lidu jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Žádného díla nedělejte. Ustanovení to bude věčné v pronárodech vašich, ve všech příbytcích vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Sobotu odpočinutí míti budete, když ponižovati budete duší svých, devátého dne téhož měsíce u večer; od večera až do druhého večera držeti budete sobotu svou. ");
INSERT INTO ces1613_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Mluv synům Izraelským a rci: Každého patnáctého dne měsíce sedmého slavnost stánků za sedm dní bude Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Dne prvního shromáždění svaté bude; žádného díla robotného nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Za sedm dní obětovati budete obět ohnivou Hospodinu. Dne osmého shromáždění svaté míti budete, a obětovati budete obět ohnivou Hospodinu; svátek jest, žádného díla robotného nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","To jsou slavnosti Hospodinovy, kteréž slaviti budete, mívajíce shromáždění svatá, abyste v nich obětovali obět ohnivou Hospodinu, zápal, obět suchou, obět pokojnou, a oběti mokré, jedno každé ve dni svém, ");
INSERT INTO ces1613_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Kromě sobot Hospodinových, a kromě darů vašich, i všech slibů vašich a kromě všech dobrovolných obětí vašich, kteréž dávati budete Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","A však dne patnáctého toho měsíce sedmého, když byste shromáždili úrody země, světiti budete svátek Hospodinův za sedm dní. Dne prvního odpočinutí bude, tolikéž dne osmého bude odpočinutí. ");
INSERT INTO ces1613_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","A naberouce sobě dne prvního ovoce z stromů krásných, a ratolestí palmových, a větvoví z stromů hustých, a vrbí od potoku, veseliti se budete před Hospodinem Bohem svým za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","A tak držeti budete ten svátek Hospodinův za sedm dní každého roku. Ustanovení to bude věčné v pronárodech vašich; každého měsíce sedmého slaviti jej budete. ");
INSERT INTO ces1613_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","V staních zůstanete za sedm dní. Kdožkoli doma zrozený jest v Izraeli, v staních zůstávati budete, ");
INSERT INTO ces1613_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Aby věděli potomci vaši, že jsem choval v staních syny Izraelské, když jsem je vyvedl z země Egyptské: Já Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","I oznámil Mojžíš slavnosti Hospodinovy synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Přikaž synům Izraelským, ať přinesou tobě oleje olivového, čistého, vytlačeného, k svícení, aby lampy ustavičně rozsvěcovány byly. ");
INSERT INTO ces1613_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Před oponou svědectví v stánku úmluvy zpořádá je Aron, aby hořely od večera až do jitra před Hospodinem vždycky. Toť bude ustanovení věčné v národech vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Na svícen čistý rozstavovati bude lampy před Hospodinem vždycky. ");
INSERT INTO ces1613_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","A vezma mouky bělné, upečeš z ní dvanácte koláčů; jeden každý koláč bude ze dvou desetin efi. ");
INSERT INTO ces1613_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","A rozkladeš je dvěma řady, šest v řadu jednom, na stole čistém před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Dáš také na každý řad kadidla čistého, aby bylo za každý chléb ten kouření pamětné v obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Každého dne sobotního klásti budete je řadem před Hospodinem vždycky, berouce je od synů Izraelských smlouvou věčnou. ");
INSERT INTO ces1613_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","I budou Aronovi a synům jeho, kteřížto jísti budou je na místě svatém; nebo nejsvětější věc jest jim z obětí ohnivých Hospodinových právem věčným. ");
INSERT INTO ces1613_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Vyšel pak syn ženy Izraelské, kteréhož měla s mužem Egyptským, mezi syny Izraelskými, a vadili se v staních syn ženy té Izraelské s mužem Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","I zlořečil syn ženy té Izraelské a rouhal se jménu Božímu. Tedy přivedli ho k Mojžíšovi. (Jméno pak matky jeho bylo Salumit, dcera Dabri, z pokolení Dan.) ");
INSERT INTO ces1613_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","A dali jej do vězení, až by jim bylo oznámeno, co s ním Bůh káže učiniti. ");
INSERT INTO ces1613_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Vyveď toho ruhače ven z stanů, a nechať všickni ti, kteříž slyšeli, vloží ruce na hlavu jeho, a všecken lid ať ho ukamenuje. ");
INSERT INTO ces1613_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Mluvě pak k synům Izraelským, díš jim: Kdož by koli zlořečil Bohu svému, poneseť hřích svůj. ");
INSERT INTO ces1613_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Kdož by zlořečil jménu Hospodinovu, smrtí umře, a všecko shromáždění bez milosti ukamenuje jej. Tak cizí, jako doma zchovaný, když by zlořečil jménu Hospodinovu, smrtí umře. ");
INSERT INTO ces1613_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Zabil-li by kdo kterého člověka, smrtí umře. ");
INSERT INTO ces1613_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Jestliže by pak zabil hovado, navrátí jiné, hovado za hovado. ");
INSERT INTO ces1613_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Kdož by pak zohavil bližního svého, vedlé toho, jakž on učinil, tak se staň jemu: ");
INSERT INTO ces1613_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Zlámaní za zlámaní, oko za oko, zub za zub. Jakouž by ohavu učinil na těle člověka, taková zase učiněna bude jemu. ");
INSERT INTO ces1613_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kdož by zabil hovado, navrátí jiné, ale kdož by zabil člověka, umře. ");
INSERT INTO ces1613_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Jednostejné právo míti budete. Jakož příchozímu, tak domácímu stane se; nebo já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Tedy mluvil Mojžíš k synům Izraelským ty věci. I vyvedli toho ruhače ven za stany, a kamením ho zametali. Učinili, pravím, synové Izraelští vedlé toho, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mluvil ještě Hospodin k Mojžíšovi na hoře Sinai, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Mluv synům Izraelským a rci jim: Když vejdete do země, kterouž já dávám vám, odpočívati bude země, nebo sobota jest Hospodinova. ");
INSERT INTO ces1613_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Šest let osívati budeš rolí svou, a šest let obřezovati budeš vinici svou a sbírati úrody její. ");
INSERT INTO ces1613_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Sedmého pak léta sobotu odpočinutí bude míti země, sobotu Hospodinovu; nebudeš na poli svém síti a vinice své řezati. ");
INSERT INTO ces1613_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Což se samo od sebe zrodí obilí tvého, nebudeš toho žíti, a hroznů vinice zanechané od tebe nebudeš sbírati. Rok odpočinutí bude míti země. ");
INSERT INTO ces1613_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ale ovoce země toho odpočinutí budete míti ku pokrmu, ty i služebník tvůj, i děvka tvá, i nájemník tvůj, i příchozí tvůj, kterýž bydlí u tebe, ");
INSERT INTO ces1613_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","I hovado tvé, i všeliký živočich, kterýž jest v zemi tvé, všecky úrody její budou míti ku pokrmu. ");
INSERT INTO ces1613_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Sečteš také sobě sedm téhodnů let, totiž sedmkrát sedm let, tak aby čas sedmi téhodnů let učinil tobě čtyřidceti devět let. ");
INSERT INTO ces1613_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Tedy dáš troubiti trubou veselé všudy sedmého měsíce v desátý den; v den očišťování dáš troubiti trubou po vší zemi vaší. ");
INSERT INTO ces1613_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","I posvětíte léta padesátého, a vyhlásíte svobodu v zemi té všechněm obyvatelům jejím. Léto milostivé toto míti budete, abyste se navrátili jeden každý k statku svému, a jeden každý k čeledi své zase přijde. ");
INSERT INTO ces1613_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ten rok milostivý padesátého léta míti budete; nebudete síti, ani žíti toho, což by samo od sebe vzrostlo, ani sbírati vína opuštěných vinic léta toho. ");
INSERT INTO ces1613_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Nebo milostivé léto jest, protož za svaté je míti budete; ze všelikého pole jísti budete úrody jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Toho léta milostivého navrátí se jeden každý k statku svému. ");
INSERT INTO ces1613_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Když nějakou věc prodáš bližnímu svému, aneb koupíš něco od bližního svého, nikoli neutiskujte jeden druhého. ");
INSERT INTO ces1613_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Vedlé počtu let po létu milostivém koupíš od bližního svého, a vedlé počtu let, v kterýchž úrody bráti máš, prodá tobě. ");
INSERT INTO ces1613_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Èím více bude let, tím větší placení bude, a čím méně let, tím, menší placení bude; nebo počet úrod prodá tobě. ");
INSERT INTO ces1613_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Protož nikoli neoklamávejte jeden druhého, ale boj se každý Boha svého; nebo já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ostříhejte ustanovení mých, a soudy mé zachovávejte a čiňte je, a bydliti budete v zemi té bezpečně. ");
INSERT INTO ces1613_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","A přinese vám země úrody své; i budete jísti až do sytosti, bydlíce bezpečně v ní. ");
INSERT INTO ces1613_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Pakli díte: Co budeme jísti léta sedmého, jestliže nebudeme síti, ani shromažďovati užitků svých? ");
INSERT INTO ces1613_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Dám požehnání své vám léta šestého, tak že přinese úrody na tři léta. ");
INSERT INTO ces1613_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","I budete síti léta osmého, a jísti úrody staré až do léta devátého; dokudž by nezrostly úrody jeho, jísti budete staré. ");
INSERT INTO ces1613_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Země pak nebude prodávána v manství; nebo má jest země, a vy jste příchozí a podruzi u mne. ");
INSERT INTO ces1613_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","A po vší zemi vládařství svého dopustíte dávati výplatu země. ");
INSERT INTO ces1613_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Jestliže by ochudl bratr tvůj, tak že by prodal něco z statku svého, tedy přijde příbuzný jeho, nejbližší jeho, a vyplatí prodanou věc od bratra svého. ");
INSERT INTO ces1613_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Pakli kdo nemaje výplatce, mohl by tomu sám dosti učiniti, tak že shledal by, což potřebí k vyplacení: ");
INSERT INTO ces1613_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Tedy počte léta prodaje svého, a navrátí, což zůstane, tomu, jemuž prodal; tak zase přijde k statku svému. ");
INSERT INTO ces1613_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pakli by nemohl shledati toho, což by navrátiti měl, tedy zůstane věc prodaná v rukou toho, kterýž ji koupil, až do léta milostivého. I postoupí mu ji v čas léta milostivého, a on navrátí se zase k dědictví svému. ");
INSERT INTO ces1613_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Když by kdo prodal dům k bydlení v městě hrazeném, bude míti právo k vyplacení jeho, dokudž nevyplní se rok prodaje jeho. Za celý rok bude míti právo k vyplacení jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Pakliť ho nevyplatí dříve, než vyjde ten celý rok, tedy zůstane dům ten v městě hrazeném tomu, kterýž jej koupil, dědičně v pronárodech jeho, aniž ho postoupí v létě milostivém. ");
INSERT INTO ces1613_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Domové pak ve vsech, kteréž nejsou zdí ohrazené, tak jako pole země počítati se budou. Budou moci býti vyplacováni, a léta milostivého navráceni budou. ");
INSERT INTO ces1613_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ale města Levítská, a domové v městech dědictví jejich, ti vždycky vyplaceni mohou býti od Levítů. ");
INSERT INTO ces1613_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ten pak, kdož vyplacuje, ať jest z Levítů. Aneb ať vyjde kupec z koupeného domu a města dědictví jeho v čas léta milostivého; nebo domové měst Levítských jsou dědictví jejich mezi syny Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Pole pak na předměstí měst jejich nebude prodáváno, nebo dědictví jejich věčné jest. ");
INSERT INTO ces1613_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Jestliže by schudl bratr tvůj, a ustaly by ruce jeho u tebe, posilníš ho; též příchozí aneb podruh živiti se bude při tobě. ");
INSERT INTO ces1613_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Nevezmeš od něho lichvy aneb úroku, ale báti se budeš Boha svého, aby se mohl bratr tvůj živiti u tebe. ");
INSERT INTO ces1613_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Peněz svých nedáš jemu na lichvu, aniž pro zisk půjčovati budeš obilí svého. ");
INSERT INTO ces1613_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Já jsem Hospodin Bůh váš, kterýž jsem vyvedl vás z země Egyptské, abych vám dal zemi Kananejskou, a byl vám za Boha. ");
INSERT INTO ces1613_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Jestliže by pak schudl bratr tvůj u tebe, tak že by se prodal tobě, nebudeš ho podrobovati v dílo otrocké. ");
INSERT INTO ces1613_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Jakožto nájemník a jako podruh bude při tobě; až do léta milostivého sloužiti bude u tebe. ");
INSERT INTO ces1613_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Potom vyjde od tebe s dětmi svými, a navrátí se k čeledi své, a v dědictví otců svých navrátí se. ");
INSERT INTO ces1613_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Nebo jsou služebníci moji, kteréž jsem vyvedl z země Egyptské; nebudou prodáváni tak jako jiní služebníci. ");
INSERT INTO ces1613_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nebudeš panovati nad ním tvrdě, ale báti se budeš Boha svého. ");
INSERT INTO ces1613_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Služebník pak tvůj aneb děvka tvá, kteréž míti budeš, budou z národů těch, kteříž jsou vůkol vás; z nich kupovati budete služebníky a děvky. ");
INSERT INTO ces1613_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","I od synů bydlitelů, kteříž jsou u vás pohostinu, od těch kupovati budete, a z čeledí těch, kteříž jsou s vámi, kteréž zplodili v zemi vaší, a budou vám v dědictví. ");
INSERT INTO ces1613_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","A vládnouti budete jimi právem dědičným, i synové vaší po vás, abyste je dědičně obdrželi. Na věčnost služby jejich užívati budete, ale nad bratřími svými, syny Izraelskými, nižádný nad bratrem svým nebude tvrdě panovati. ");
INSERT INTO ces1613_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Jestliže by pak zbohatl příchozí aneb host, kterýž bydlí s tebou, a bratr tvůj přišel by na chudobu při něm, tak že by se prodal příchozímu aneb hosti tvému, aneb obyvateli, kterýž jest z čeledi cizí, ");
INSERT INTO ces1613_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Když by se tedy prodal, může zase vyplacen býti. Někdo z bratří jeho vyplatí ho. ");
INSERT INTO ces1613_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Buďto strýc jeho, aneb syn strýce jeho vyplatí jej, aneb někdo z přátel krevních jeho, z rodiny jeho, vyplatí ho; aneb jestli potom sám bude moci s to býti, vyplatí se. ");
INSERT INTO ces1613_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","I počte se s tím, kterýž ho koupil, od léta, v kterémž se jemu prodal, až do léta milostivého, aby peníze, za něž jest prodán, byly vedlé počtu let; a jakožto s nájemníkem, tak se s ním stane. ");
INSERT INTO ces1613_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Jestliže ještě mnoho let zůstává k létu milostivému, vedlé nich navrátí výplatu svou z peněz, za něž koupen jest. ");
INSERT INTO ces1613_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Pakli málo zůstává let do léta milostivého, tedy počte se s ním, a vedlé počtu let jeho navrátí výplatu svou. ");
INSERT INTO ces1613_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Tak jako s čeledínem ročním nakládáno bude s ním; nebude nad ním tvrdě panovati před očima tvýma. ");
INSERT INTO ces1613_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Pakli by se nevyplatil v těch letech, tedy vyjde léta milostivého on, i synové jeho s ním. ");
INSERT INTO ces1613_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Nebo synové Izraelští jsou moji služebníci, služebníci moji jsou, kteréž jsem vyvedl z země Egyptské: Já Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Nedělejte sobě modl, ani obrazu rytého, aneb sloupu nevyzdvihnete sobě, ani kamene malovaného v zemi vaší nestavějte, abyste se jemu klaněli; nebo já jsem Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Sobot mých ostříhejte, a svatyně mé se bojte: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Jestliže v ustanoveních mých choditi budete, a přikázaní mých ostříhajíce, budete je činiti: ");
INSERT INTO ces1613_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Tedy dám vám deště vaše časy svými, a země vydá úrody své, a stromoví polní vydá ovoce své, ");
INSERT INTO ces1613_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Tak že mlácení postihne vinobraní, a vinobraní postihne setí. I budete jísti chléb svůj do sytosti, a přebývati budete bezpečně v zemi své. ");
INSERT INTO ces1613_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Nebo dám pokoj v zemi, i budete spáti, a nebude, kdo by vás předěsil; vypléním i zvěř zlou z země, a meč nebude procházeti země vaší. ");
INSERT INTO ces1613_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Nýbrž honiti budete nepřátely své, a padnou před vámi od meče. ");
INSERT INTO ces1613_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Pět vašich honiti jich bude sto, a sto vašich honiti bude deset tisíců, i padnou nepřátelé vaši před vámi od meče. ");
INSERT INTO ces1613_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nebo obrátím tvář svou k vám, a dám vám zrůst, a rozmnožím vás, a utvrdím smlouvu svou s vámi. ");
INSERT INTO ces1613_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","A jísti budete úrody několikaleté, a když nové přijdou, staré vyprázdníte. ");
INSERT INTO ces1613_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Vzdělám příbytek svůj u prostřed vás, a duše má nebude vás nenáviděti. ");
INSERT INTO ces1613_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","A procházeti se budu mezi vámi, a budu Bohem vaším, a vy budete lidem mým. ");
INSERT INTO ces1613_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Já jsem Hospodin Bůh váš, kterýž jsem vyvedl vás z země Egyptských, abyste jim nesloužili, a polámal jsem závory jha vašeho, abyste chodili prosti. ");
INSERT INTO ces1613_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Pakli nebudete mne poslouchati, a nebudete činiti všech přikázaní těchto, ");
INSERT INTO ces1613_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","A jestli ustanovení má zavržete, a soudy mé zoškliví-li sobě duše vaše, tak abyste nečinili všech přikázaní mých, a zrušili byste smlouvu mou: ");
INSERT INTO ces1613_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Já také toto učiním vám: Uvedu na vás strach, souchotiny a zimnici pálčivou, což zkazí oči vaše, a bolestí naplní duši. Semeno své nadarmo síti budete, nebo nepřátelé vaši snědí je. ");
INSERT INTO ces1613_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Postavím zůřivou tvář svou proti vám, tak že poraženi budete od nepřátel svých, a panovati budou nad vámi ti, kteříž vás nenávidí. Utíkati budete, ano vás žádný nehoní. ");
INSERT INTO ces1613_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Jestliže ani tak poslouchati mne nebudete, tedy ještě sedmkrát více trestati vás budu pro hříchy vaše. ");
INSERT INTO ces1613_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","A potru vyvýšenost síly vaší, a učiním nebe nad vámi jako železo, a zemi vaši jako měď. ");
INSERT INTO ces1613_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Nadarmo bude vynaložena síla vaše, nebo země vaše nevydá vám úrody své, a stromoví země nevydá ovoce svého. ");
INSERT INTO ces1613_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Jestliže pak se mnou maní zacházeti budete, a nebudete mne chtíti poslouchati, tedy přidám na vás sedmkrát více ran vedlé hříchů vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","A pustím na vás zvěř polní, kteráž uvede na vás sirobu, a vyhubí hovada vaše a umenší vás; i zpustnou cesty vaše. ");
INSERT INTO ces1613_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Pakli ani potom nenapravíte se, ale vždy se mnou maní zacházeti budete, ");
INSERT INTO ces1613_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","I já s vámi maní zacházeti budu, a bíti vás budu sedmkrát více pro hříchy vaše. ");
INSERT INTO ces1613_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","A uvedu na vás meč, kterýž vrchovatě pomstí zrušení smlouvy. I shrnete se do měst svých; tam pošli mor mezi vás, a dáni budete v ruce nepřátelům. ");
INSERT INTO ces1613_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","A když polámi vám hůl chleba, tedy deset žen péci bude chléb váš v peci jedné, a zase chléb váš odvažovati vám budou. Budete pak jísti, a nenasytíte se. ");
INSERT INTO ces1613_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Pakli i s tím nebudete mne poslouchati, ale předce maní se mnou zacházeti budete: ");
INSERT INTO ces1613_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","I já také v hněvě maní s vámi zacházeti budu, a trestati vás budu i já sedmkrát více pro hříchy vaše. ");
INSERT INTO ces1613_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","A budete jísti těla synů svých, a těla dcer svých. ");
INSERT INTO ces1613_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","A zkazím výsosti vaše, a vypléním slunečné obrazy vaše, a skladu těla vaše na špalky ukydaných bohů vašich, a duše má bude vás nenáviděti. ");
INSERT INTO ces1613_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Města vaše dám v zpuštění, a učiním, aby zpustly svatyně vaše, aniž více zachutnám oběti vůně příjemné vaší. ");
INSERT INTO ces1613_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Já zpustím zemi, tak že ztrnou nad ní nepřátelé vaši, kteříž bydliti budou v ní. ");
INSERT INTO ces1613_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Vás pak rozptýlím mezi národy, a učiním, aby s dobytým mečem vás honili. I bude země vaše vyhubena, a města vaše zpustnou. ");
INSERT INTO ces1613_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","A tehdy země užive sobot svých po všecky dny, v nichž pustá bude, vy pak budete v zemi nepřátel svých. Tehdáž, pravím, odpočine země, a užive sobot svých. ");
INSERT INTO ces1613_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Po všecky dny, v nichž pustá bude, odpočívati bude; nebo neodpočívala v soboty vaše, když jste vy bydlili v ní. ");
INSERT INTO ces1613_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Kteříž pak ještě pozůstanou z vás, uvedu strach na srdce jejich v krajinách nepřátel jejich, tak že zažene je chřest listu větrem chřestícího. I budou utíkati, rovně jako před mečem, a padnou, an jich žádný honiti nebude. ");
INSERT INTO ces1613_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","A budou padati jeden přes druhého jakožto od meče, ač jich žádný honiti nebude; aniž kdo z vás bude moci ostáti před nepřátely svými. ");
INSERT INTO ces1613_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","I zahynete mezi národy, a zžíře vás země nepřátel vašich. ");
INSERT INTO ces1613_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Kteříž pak pozůstanou z vás, svadnouti budou pro nepravost svou v zemi nepřátel vašich, ano i pro nepravosti otců vašich s nimi usvadnou. ");
INSERT INTO ces1613_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ale jestliže budou vyznávati nepravost svou, a nepravost otců svých vedlé přestoupení svého, kterýmž přestoupili proti mně, a maní se mnou zacházeli, ");
INSERT INTO ces1613_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","I já také že jsem maní s nimi zacházel, a uvedl je do země nepřátel jejich; jestliže, pravím, tehdáž poníží se srdce jejich neobřezané, a schválí pokutu nepravosti své: ");
INSERT INTO ces1613_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Tedy rozpomenu se na smlouvu svou s Jákobem, a na smlouvu svou s Izákem, i na smlouvu svou s Abrahamem rozpomenu se; také i na tu zemi pamětliv budu. ");
INSERT INTO ces1613_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mezi tím země jsuc jich zbavena, užive sobot svých, kdyžto zpuštěna bude pro ně. Tehdáž oni schválí pokutu nepravosti své proto, že všelijak soudy mými pohrdali, a ustanovení má zošklivila sobě duše jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","A však i tak, když by v zemi nepřátel svých byli, nezavrhl bych jich, a nezošklivil jich sobě, abych je měl do konce zkaziti, a zrušiti smlouvu svou s nimi; nebo já jsem Hospodin Bůh jejich. ");
INSERT INTO ces1613_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ale rozpomenu se na ně pro smlouvu učiněnou s předky jejich, kteréž jsem vyvedl z země Egyptské před očima pohanů, abych jim byl za Boha: Já Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ta jsou ustanovení a soudové, i zákonové, kteréž vydal Hospodin na hoře Sinai skrze Mojžíše, aby byli mezi ním a mezi syny Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Mluv synům Izraelským a rci jim: Když by kdo slibem oddal duše Hospodinu, vedlé ceny tvé dá výplatu. ");
INSERT INTO ces1613_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Tato pak bude cena tvá: Osobě mužského pohlaví, počna od toho, kterýž jest ve dvadcíti letech, až do šedesátiletého, uložíš výplatu padesáte lotů stříbra vedlé lotu svatyně. ");
INSERT INTO ces1613_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Pakli ženského pohlaví bude, uložíš výplatu třidceti lotů. ");
INSERT INTO ces1613_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","A od pětiletých až do dvadcítiletých uložíš výplatu, za osobu mužského pohlaví dvadceti lotů, ženského pak deset lotů. ");
INSERT INTO ces1613_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","A od dítěte jednoho měsíce zstáří až do pětiletých, uložíš za pachole pět lotů stříbra, a za děvče tři loty stříbra. ");
INSERT INTO ces1613_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Od šedesáti pak let a výše, bude-li muž, uložíš výplatu patnácte lotů, a ženě deset lotů. ");
INSERT INTO ces1613_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Pakli bude tak chudý, že by nemohl uložené výplaty dáti, tedy postaven bude před knězem, aby mu kněz uložil výplatu. Podlé toho, seč bude moci býti ten, kdož slib učinil, uloží mu výplatu. ");
INSERT INTO ces1613_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Jestliže by pak kdo hovado z těch, kteréž se obětují Hospodinu, slíbil, každé, kteréž dá z nich Hospodinu, svaté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Nesmění ho, aniž dá jiného za ně, lepšího za horší, aneb horšího za lepší. Jestliže by pak jakýmkoli způsobem je směnil, hovado za hovado, tedy ono i toto, kteréž za ně dáno, svaté bude. ");
INSERT INTO ces1613_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Pakli by které nečisté hovado slíbil, z jehož pokolení neobětují oběti Hospodinu, tedy postaví to hovado před knězem. ");
INSERT INTO ces1613_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","A bude je šacovati kněz, buď ono dobré aneb zlé. Jakž je kněz cení, tak buď. ");
INSERT INTO ces1613_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Pakli bude chtíti vyplatiti je, přidá pátý díl nad cenu tvou. ");
INSERT INTO ces1613_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Když by pak někdo posvětil domu svého, aby byl svatý Hospodinu, bude jej kněz ceniti, buďto že by dobrý byl aneb zlý. Jakž jej procení kněz, tak zůstane. ");
INSERT INTO ces1613_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Pakli ten, kterýž posvětil domu svého, chtěl by jej vyplatiti, přidá pátý díl peněz nad cenu tvou, i bude jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Jestliže by kdo díl pole dědictví svého posvětil Hospodinu, tedy budeš je ceniti vedlé toho, jakž se osívá. Chomer ječmene kde se vseje, za padesáte lotů stříbra ceněno bude. ");
INSERT INTO ces1613_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jestliže by hned od léta milostivého posvětil pole svého, tedy vedlé ceny tvé zůstane. ");
INSERT INTO ces1613_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pakli by po létě milostivém posvětil pole svého, tedy sečte mu kněz peníze vedlé počtu let zůstávajících ještě do léta milostivého, i odejme to z ceny tvé. ");
INSERT INTO ces1613_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Chtěl-li by pak vyplatiti pole ten, kterýž ho posvětil, přidá pátý díl peněz nad cenu tvou, a zůstane jemu. ");
INSERT INTO ces1613_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Nevyplatil-li by pak pole toho, a prodáno by bylo někomu jinému, nemůže víc vyplaceno býti. ");
INSERT INTO ces1613_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","I bude pole to, když svobodné vyjde léta milostivého, svaté Hospodinovo, jakožto pole posvěcené; knězi bude v dědictví jeho. ");
INSERT INTO ces1613_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Jestliže pak pole koupené, kteréž by nebylo z pole dědictví jeho, posvětil Hospodinu, ");
INSERT INTO ces1613_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Tedy sečte mu kněz summu ceny jeho až do léta milostivého, i dá cenu jeho v ten den, jako posvěcenou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","V létě milostivém navrátí se pole k tomu, od kohož bylo koupeno, jehož dědictví jest pole to. ");
INSERT INTO ces1613_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Všeliká pak cena tvá bude vedlé lotu svatyně. Lot pak váží dvadceti haléřů. ");
INSERT INTO ces1613_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ale prvorozeného, což právem prvorozenství dává se Hospodinu z hovad, nižádný neposvětí, buďto z skotů aneb z bravů; Hospodinovo jest prvé. ");
INSERT INTO ces1613_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","A jestliže by z hovad nečistých bylo, vyplatí je vedlé ceny tvé, a přidá pátý díl nad ní. Pakliť nebude vyplaceno, tedy nechť jest prodáno vedlé ceny tvé. ");
INSERT INTO ces1613_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Všeliká pak věc posvěcená, kterouž by někdo slibem posvětil Hospodinu ze všech věcí, kteréž má, buď z lidí aneb z hovad, aneb z pole dědictví svého, nebude prodávána, ani vyplacována; nebo všecko, což takovým slibem posvěceno jest, věc nejsvětější bude Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Všeliké hovado tak oddané, kteréž slibem tím se oddává od člověka, nebude vyplacováno, ale smrtí umře. ");
INSERT INTO ces1613_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Všickni také desátkové země, buď z semene země, aneb z ovoce stromů, Hospodinovi budou; nebo posvěceni jsou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Bude-li kdo chtíti vyplatiti desátky své, pátý díl jejich přidá nad ně. ");
INSERT INTO ces1613_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","A všeliký desátek z volů aneb drobného dobytka, jakž přichází pod hůl pastýře, každý ten desátek svatý bude Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Nebude vyhledávati, dobré-li by bylo čili zlé, aniž ho smění. Pakli je předce smění, bude to i ono odměněné svaté, a nebude vyplaceno. ");
INSERT INTO ces1613_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ta jsou přikázaní, kteráž přikázal Hospodin Mojžíšovi na hoře Sinai, aby je oznámil synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Mluvil pak Hospodin k Mojžíšovi na poušti Sinai, v stánku úmluvy, prvního dne měsíce druhého, léta druhého po vyjití jejich z země Egyptské, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Sečtěte summu všeho množství synů Izraelských po čeledech jejich, a po domích otců jejich, vedlé počtu jmen každého pohlaví mužského po hlavách jejich, ");
INSERT INTO ces1613_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Od dvadcítiletých a výše všecky, kteříž by mohli jíti k boji v Izraeli, sečtěte je po houfích jejich, ty a Aron. ");
INSERT INTO ces1613_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","A bude s vámi z každého pokolení jeden muž, kterýž by přední byl v domě otců svých. ");
INSERT INTO ces1613_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Tato pak jsou jména mužů, kteříž stanou s vámi: Z pokolení Rubenova Elisur, syn Sedeurův; ");
INSERT INTO ces1613_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Z Simeonova Salamiel, syn Surisaddai; ");
INSERT INTO ces1613_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Z Judova Názon, syn Aminadabův; ");
INSERT INTO ces1613_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Z Izacharova Natanael, syn Suar; ");
INSERT INTO ces1613_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Z Zabulonova Eliab, syn Helonův; ");
INSERT INTO ces1613_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Z synů Jozefových, z pokolení Efraimova Elisama, syn Amiudův; z Manassesova Gamaliel, syn Fadasurův; ");
INSERT INTO ces1613_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Z Beniaminova Abidan, syn Gedeonův; ");
INSERT INTO ces1613_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Z pokolení Dan Ahiezer, syn Amisaddai; ");
INSERT INTO ces1613_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Z Asser Fegiel, syn Ochranův; ");
INSERT INTO ces1613_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Z pokolení Gád Eliazaf, syn Duelův; ");
INSERT INTO ces1613_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Z Neftalímova Ahira, syn Enanův. ");
INSERT INTO ces1613_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ti jsou slovoutní z lidu, knížata pokolení otců svých, ti jako hlavy tisíců Izraelských budou. ");
INSERT INTO ces1613_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Vzal tedy Mojžíš a Aron muže ty, kteříž jmenováni byli, ");
INSERT INTO ces1613_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","A shromáždili všecko množství prvního dne měsíce druhého, kteříž přiznávali se k rodům svým po čeledech svých, po domích otců svých, a vedlé počtu jmen, od dvadcítiletých a výše po osobách svých. ");
INSERT INTO ces1613_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Jakož byl přikázal Hospodin Mojžíšovi, tak sčetl je na poušti Sinai. ");
INSERT INTO ces1613_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","I bylo synů Rubena prvorozeného Izraelova, rodiny jejich, po čeledech jejich, po domích otců jejich, a podlé počtu jmen, po hlavách jejich, všech pohlaví mužského, od dvadcítiletých a výše, všech, kteříž mohli jíti k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","A načteno jich z pokolení Rubenova čtyřidceti šest tisíců a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Z synů Simeonových, rodiny jejich, po čeledech jejich, po domích otců jejich, sečtených jeho vedlé počtu jmen, po hlavách jejich, všech pohlaví mužského od dvadcítiletých a výše, všech, kteříž mohli jíti k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Načteno jich z pokolení Simeonova padesáte devět tisíců a tři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Z synů Gádových, rodiny jejich, po čeledech jejich, po domích otců jejich, podlé počtu jmen, od dvadcítiletých a výše, všech, kteříž mohli bojovati, ");
INSERT INTO ces1613_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Načteno jich z pokolení Gádova čtyřidceti pět tisíců, šest set a padesát. ");
INSERT INTO ces1613_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Z synů Judových, rodiny jejich, po čeledech jejich, po domích otců jejich, vedlé počtu jmen, od dvadcíti let a výše, všech, kteříž mohli jíti k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Načteno jich z pokolení Judova sedmdesáte čtyři tisíce a šest set. ");
INSERT INTO ces1613_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Z synů Izacharových, rodiny jejich, po čeledech jejich, po domích otců jejich, podlé počtu jmen, od dvadcítiletých a výše, všech, kteříž mohli jíti k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Načteno jich z pokolení Izacharova padesáte čtyři tisíce a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Z synů Zabulonových, rodiny jejich, po čeledech jejich, po domích otců jejich, podlé počtu jmen, od dvadcítiletých a výše, všech, kteříž mohli jíti k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Načteno jich z pokolení Zabulonova padesáte sedm tisíců a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Z synů Jozefových, a nejprv, synů Efraimových, rodiny jejich, po čeledech jejich, po domích otců jejich, podlé počtu jmen, od dvadcítiletých a výše, všech, kteříž mohli jíti k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Načteno jich z pokolení Efraimova čtyřidceti tisíc a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Potom z synů Manassesových, rodiny jejich, po čeledech jejich, po domích otců jejich, vedlé počtu jmen, od dvadcítiletých a výše, všech, kteříž vycházeli k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Načteno jich z pokolení Manassesova třidceti dva tisíce a dvě stě. ");
INSERT INTO ces1613_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Z synů Beniaminových, rodiny jejich, po čeledech jejich, po domích otců jejich, vedlé počtu jmen, od dvadcítiletých a výše, všech, kteříž mohli jíti do boje, ");
INSERT INTO ces1613_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Načteno jich z pokolení Beniaminova třidceti pět tisíců a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Z synů Dan, rodiny jejich, po čeledech jejich, po domích otců jejich, vedlé počtu jmen, od dvadcítiletých a výše, všech, kteříž vycházeli k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Načteno jich z pokolení Dan šedesáte dva tisíce a sedm set. ");
INSERT INTO ces1613_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Z synů Asser, rodiny jejich, po čeledech jejich, po domích otců jejich, vedlé počtu jmen, od dvadcítiletých a výše, všech, kteříž mohli jíti na vojnu, ");
INSERT INTO ces1613_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Načteno jich z pokolení Asser čtyřidceti jeden tisíců a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Z synů Neftalímových, rodiny jejich, po čeledech jejich, po domích otců jejich, vedlé počtu jmen, od dvadcítiletých a výše, všech, kteříž mohli jíti k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Načteno jich z pokolení Neftalímova padesáte tři tisíce a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ten jest počet těch, kteréž sečtl Mojžíš a Aron a knížata Izraelská, dvanácte mužů, kteříž byli vybráni po jednom z domů otců svých. ");
INSERT INTO ces1613_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","I bylo všech sečtených synů Izraelských po domích otců jejich, od dvadcítiletých a výše, všech, kteříž mohli vycházeti k boji v Izraeli, ");
INSERT INTO ces1613_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Všech sečtených bylo šestkrát sto tisíc, a tři tisíce, pět set a padesáte. ");
INSERT INTO ces1613_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Levítové pak vedlé pokolení otců svých nejsou počítáni mezi ně. ");
INSERT INTO ces1613_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Nebo byl mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Pokolení Levítského nebudeš počítati, a nepřičteš jich k synům Izraelským, ");
INSERT INTO ces1613_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ale ustanovíš Levíty nad příbytkem svědectví, a nade vším nádobím jeho, a nade všemi věcmi, kteréž přináležejí k němu. Oni nositi budou příbytek i všecka nádobí jeho, oni přisluhovati budou jemu, a vůkol příbytku klásti se budou. ");
INSERT INTO ces1613_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Když se pak s místa bude míti hýbati příbytek, složí jej Levítové; a když se bude klásti příbytek, vyzdvihnou jej Levítové. Kdož by koli cizí přistoupil, umře. ");
INSERT INTO ces1613_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","I budouť se klásti synové Izraelští, jeden každý v ležení svém, a jeden každý pod praporcem svým, a po houfích svých. ");
INSERT INTO ces1613_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Levítové pak klásti se budou vůkol příbytku svědectví, aby nepřišlo rozhněvání mé na shromáždění synů Izraelských; i budou Levítové držeti stráž u příbytku svědectví. ");
INSERT INTO ces1613_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Učinili tedy to synové Izraelští; všecko, jakž přikázal Hospodin Mojžíšovi, tak učinili. ");
INSERT INTO ces1613_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mluvil také Hospodin k Mojžíšovi a Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Synové Izraelští klásti se budou jeden každý pod korouhví svou, při praporci domu otců svých; vůkol stánku úmluvy opodál klásti se budou. ");
INSERT INTO ces1613_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Tito pak rozbijí stany k východní straně: Korouhev vojska Judova po houfích svých, a kníže synů Juda Názon, syn Aminadabův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","A u vojště jeho lidu sečteného sedmdesáte čtyři tisíce a šest set. ");
INSERT INTO ces1613_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Podlé něho pak položí se pokolení Izachar, a kníže synů Izachar Natanael, syn Suar, ");
INSERT INTO ces1613_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","A u vojště jeho lidu sečteného padesáte čtyři tisíce a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Pokolení Zabulon podlé nich, a kníže synů Zabulon Eliab, syn Helonův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","A u vojště jeho lidu sečteného padesáte sedm tisíců a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Summa všech sečtených u vojště Judově sto osmdesáte šest tisíců a čtyři sta, po houfích jejich. Ti napřed potáhnou. ");
INSERT INTO ces1613_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Korouhev vojska Rubenova klásti se bude ku poledni po houfích svých, a kníže synů Ruben Elisur, syn Sedeurův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","A u vojště jeho lidu sečteného čtyřidceti šest tisíců a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Podlé něho pak položí se pokolení Simeonovo, a kníže synů Simeon Salamiel, syn Surisaddai, ");
INSERT INTO ces1613_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","A u vojště jeho lidu sečteného padesáte devět tisíců a tři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Potom pokolení Gád, a kníže synů Gád Eliazaf, syn Ruelův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","A u vojště jeho lidu sečteného čtyřidceti pět tisíců, šest set a padesáte. ");
INSERT INTO ces1613_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Summa všech sečtených u vojště Rubenově sto padesáte a jeden tisíců, čtyři sta a padesáte, po houfích svých. A ti za prvními potáhnou. ");
INSERT INTO ces1613_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Potom půjde stánek úmluvy s vojskem Levítů u prostřed všeho vojska. Jakýmž pořádkem klásti se budou, takovým potáhnou, každý v svém šiku pod korouhví svou. ");
INSERT INTO ces1613_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Korouhev vojska Efraimova po houfích svých bude k západu, a kníže synů Efraimových Elisama, syn Amiudův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","A u vojště jeho lidu sečteného čtyřidceti tisíc a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Podlé něho pak položí se pokolení Manassesovo, a kníže synů Manassesových Gamaliel, syn Fadasurův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","A u vojště jeho lidu sečteného třidceti dva tisíce a dvě stě. ");
INSERT INTO ces1613_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Potom položí se pokolení Beniaminovo, a kníže synů Beniamin Abidan, syn Gedeonův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","A u vojště jeho lidu sečteného třidceti pět tisíců a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Summa všech sečtených u vojště Efraimově sto osm tisíců a sto osob, po houfích jejich. A tito za druhými potáhnou. ");
INSERT INTO ces1613_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Korouhev vojska Dan bude k straně půlnoční, po houfích svých, a kníže synů Dan Ahiezer, syn Amisaddai, ");
INSERT INTO ces1613_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","A u vojště jeho lidu sečteného šedesáte dva tisíce a sedm set. ");
INSERT INTO ces1613_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Podlé něho položí se pokolení Asser, a kniže Asser Fegiel, syn Ochranův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","A u vojště jeho lidu sečteného čtyřidceti jeden tisíc a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Za nimi pokolení Neftalímovo, a kníže synů Neftalímových Ahira, syn Enanův, ");
INSERT INTO ces1613_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","A u vojště jeho lidu sečteného padesáte tři tisíce a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Summa všech sečtených u vojště Dan sto padesáte sedm tisíců a šest set. Oni nazad potáhnou při praporcích svých. ");
INSERT INTO ces1613_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ta jest summa synů Izraelských po domích otců jejich, všech sečtených v celém vojště po houfích jejich, šestkrát sto tisíců, tři tisíce, pět set a padesáte. ");
INSERT INTO ces1613_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Levítové pak nejsou počítáni mezi syny Izraelské, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","I učinili synové Izraelští všecko; jakž přikázal Hospodin Mojžíšovi, tak rozbijeli stany při korouhvech svých, a tak táhli jeden každý po čeledech svých a po domích otců svých. ");
INSERT INTO ces1613_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Tito jsou příběhové Aronovi a Mojžíšovi od toho dne, když mluvil Hospodin s Mojžíšem na hoře Sinai. ");
INSERT INTO ces1613_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","A tato jsou jména synů Aronových: Prvorozený Nádab, potom Abiu, Eleazar a Itamar. ");
INSERT INTO ces1613_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ta jsou jména synů Aronových, kněží pomazaných, jejichžto ruce naplněny, aby úřad kněžství konali. ");
INSERT INTO ces1613_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Umřel pak Nádab a Abiu před Hospodinem, když obětovali cizí oheň před Hospodinem na poušti Sinai, a neměli synů. Protož konal úřad kněžský Eleazar a Itamar před tváří Arona otce svého. ");
INSERT INTO ces1613_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Rozkaž přistoupiti pokolení Léví, a postav je před Aronem knězem, aby mu přisluhovali, ");
INSERT INTO ces1613_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","A drželi stráž jeho, i stráž všeho množství před stánkem úmluvy k vykonávání služby příbytku, ");
INSERT INTO ces1613_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Též aby ostříhali všeho nádobí stánku úmluvy, a drželi stráž synů Izraelských a konali služby příbytku. ");
INSERT INTO ces1613_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Dáš tedy Levíty Aronovi i synům jeho; vlastně dáni jsou mu oni z synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Arona pak a syny jeho představíš, aby ostříhali kněžství svého; nebo přistoupil-li by kdo cizí, umře. ");
INSERT INTO ces1613_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","I mluvil Hospodin Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Aj, já vzal jsem Levíty z prostředku synů Izraelských na místo všelikého prvorozeného, kteréž otvírá život mezi syny Izraelskými. Protož moji budou Levítové. ");
INSERT INTO ces1613_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Nebo mně přináleží všecko prvorozené. Od toho dne, když jsem pobil všecko prvorozené v zemi Egyptské, posvětil jsem sobě všeho prvorozeného v Izraeli od člověka až do hovada. Mně bude: Já Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Mluvil také Hospodin k Mojžíšovi na poušti Sinai, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Sečti syny Léví vedlé domů otců jejich, po čeledech jejich, každého pohlaví mužského; zstáří jednoho měsíce a výše počítati budeš je. ");
INSERT INTO ces1613_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","I sčetl je Mojžíš podlé řeči Hospodinovy, jakž rozkázáno mu bylo. ");
INSERT INTO ces1613_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","I byli synové Léví ze jména tito: Gerson, Kahat a Merari. ");
INSERT INTO ces1613_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Tato pak jsou jména synů Gersonových po čeledech jejich: Lebni a Semei. ");
INSERT INTO ces1613_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","A synové Kahat po čeledech svých: Amram a Izar, Hebron a Uziel. ");
INSERT INTO ces1613_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Synové pak Merari po čeledech svých: Moholi a Musi. Ty jsou čeledi Léví vedlé domů otců svých. ");
INSERT INTO ces1613_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Od Gersona čeled Lebnitská a čeled Semejská. Ty jsou čeledi Gersonovy. ");
INSERT INTO ces1613_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","A načteno jich v počtu všech pohlaví mužského zstáří jednoho měsíce a výše sedm tisíců a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Èeledi Gersonovy za příbytkem klásti se budou k straně západní. ");
INSERT INTO ces1613_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Kníže pak domu otce Gersonitských bude Eliazaf, syn Laelův. ");
INSERT INTO ces1613_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","A k opatrování synům Gersonovým při stánku úmluvy náležeti bude příbytek i stánek, přikrytí jeho i zastření dveří stánku úmluvy, ");
INSERT INTO ces1613_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","A očkovaté koltry k síni, i zavěšení dveří síně, kteráž jest před příbytkem a při oltáři vůkol, i provazové jeho ke všeliké potřebě jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Od Kahat pak pošla čeled Amramitská a čeled Izaritská, a čeled Hebronitská, a čeled Uzielitská. Ty jsou čeledi Kahat. ");
INSERT INTO ces1613_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","V počtu všech pohlaví mužského zstáří jednoho měsíce a výše bylo osm tisíců a šest set, držících stráž při svatyni. ");
INSERT INTO ces1613_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Èeledi synů Kahat klásti se budou k straně příbytku polední, ");
INSERT INTO ces1613_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","A kníže domu otcovského v čeledech Kahat Elizafan, syn Uzielův. ");
INSERT INTO ces1613_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","V jejich pak opatrování bude truhla, stůl, svícen, oltářové a nádobí svatyně, jímž přisluhovati budou, a opona i všecko, což přináleží k ní. ");
INSERT INTO ces1613_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Kníže pak nad knížaty Levítskými Eleazar, syn Arona kněze, ustavený nad těmi, kteříž drží stráž při svatyni. ");
INSERT INTO ces1613_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Od Merari pak čeled Moholitská a čeled Musitská. Ty jsou čeledi Merari. ");
INSERT INTO ces1613_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","A načteno jich v počtu všech mužského pohlaví zstáří jednoho měsíce a výše šest tisíců a dvě stě. ");
INSERT INTO ces1613_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","A kníže domu otcovského v čeledech Merari Suriel, syn Abichailův. A ti klásti se budou k straně příbytku půlnoční. ");
INSERT INTO ces1613_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Toto pak poručeno k opatrování synům Merari: Dsky příbytku a svlakové jeho, sloupové a podstavkové a všecka nádobí jeho i všecka práce při nich, ");
INSERT INTO ces1613_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Tolikéž sloupové síně vůkol i podstavkové jejich, kolíkové i provazové jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Položí se pak před příbytkem po přední straně před stánkem úmluvy od východu slunce Mojžíš a Aron i synové jeho, držíce stráž při svatyni, stráž za syny Izraelské. Jiný přistoupil-li by kdo, umře. ");
INSERT INTO ces1613_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Všech sečtených Levítů, kteréž sečtl Mojžíš s Aronem vedlé poručení Hospodinova, po čeledech jejich, všech pohlaví mužského jednoho měsíce zstáří a výše dvamecítma tisíců. ");
INSERT INTO ces1613_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","I řekl Hospodin k Mojžíšovi: Sečti všecky prvorozené mužského pohlaví mezi syny Izraelskými jednoho měsíce zstáří a výše, a sečti summu jmen jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","A vezmeš mi Levíty, (jáť jsem Hospodin), místo všech prvorozených mezi syny Izraelskými, i hovada Levítů místo všeho prvorozeného mezi hovady synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Když pak sčetl Mojžíš, jakož mu přikázal Hospodin, všecky prvorozené mezi syny Izraelskými, ");
INSERT INTO ces1613_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Bylo všech prvorozených pohlaví mužského vedlé počtu jmen, jednoho měsíce zstáří a výše sečtených jich, dvamecítma tisíců, dvě stě, sedmdesáte a tři. ");
INSERT INTO ces1613_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","A mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Vezmi Levíty místo všech prvorozených z synů Izraelských, i hovada Levítů za hovada jejich; i budou moji Levítové: Já jsem Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","K vyplacení pak těch dvou set, sedmdesáti a tří, kteříž zbývají nad počet Levítů z prvorozených synů Izraelských, ");
INSERT INTO ces1613_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Vezmeš pět lotů z každé hlavy, (vedlé lotu svatyně bráti budeš, lot pak dvadceti haléřů váží), ");
INSERT INTO ces1613_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","A dáš ty peníze Aronovi a synům jeho, výplatu těch, kteříž zbývají nad počet jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Vzal tedy Mojžíš peníze výplaty od těch, kteříž zbývali, kromě těch, kteréž vykoupili sebou Levítové, ");
INSERT INTO ces1613_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Od prvorozených synů Izraelských vzal peněz tisíc, tři sta, šedesáte pět lotů, vedlé lotu svatyně. ");
INSERT INTO ces1613_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","I dal ty peníze výplaty Aronovi a synům jeho, podlé řeči Hospodinovy, jakož byl přikázal jemu Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","I mluvil Hospodin k Mojžíšovi a k Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Sečti summu synů Kahat z prostředku synů Léví po čeledech jejich a po domích otců jejich, ");
INSERT INTO ces1613_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Od třidcítiletých a výše až do padesátiletých, kteříž by způsobní jsouce k boji, mohli práci vésti při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Tato pak bude práce synů Kahat při stánku úmluvy svatyně svatých: ");
INSERT INTO ces1613_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Když by se měla vojska hnouti s místa, přijde Aron s syny svými a sejmou oponu zastření, a přikryjí ní truhlu svědectví. ");
INSERT INTO ces1613_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","A na to dají přikrytí z koží jezevčích, a přistrou svrchu rouchem z samého postavce modrého, a provlekou sochory její. ");
INSERT INTO ces1613_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Na stůl pak chlebů předložení prostrou roucho z postavce modrého, a dají na něj misy a kadidlnice a koflíky a přikryvadla k přikrývání; a chléb ustavičně na něm bude. ");
INSERT INTO ces1613_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","A prostrou na to roucho z červce dvakrát barveného, a přikryjí to přistřením z koží jezevčích, a provlekou sochory jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Vezmou také roucho z postavce modrého, a přikryjí svícen světla a lampy jeho, i utěradla jeho, i nádoby k oharkům jeho, a všecky nádoby k oleji jeho, jichž při něm užívají. ");
INSERT INTO ces1613_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","A obvinou jej se všechněmi nádobami jeho přikrytím z koží jezevčích, a vloží na sochory. ");
INSERT INTO ces1613_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Na oltář pak zlatý prostrou roucho z postavce modrého, a přikryjí jej přikrytím z koží jezevčích, a provlekou sochory. ");
INSERT INTO ces1613_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Vezmou i všecky nádoby k službě, jimiž přisluhovali v svatyni, a zavinouce do roucha z postavce modrého, přikryjí je přikrytím z koží jezevčích, a vloží na sochory. ");
INSERT INTO ces1613_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Vyprázdní i popel z oltáře, a prostrou na něj roucho šarlatové. ");
INSERT INTO ces1613_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","A vloží svrchu všecko nádobí jeho, jímž přisluhují na něm, nádoby k uhlí, vidličky, pometla, kotlíky a všecko nádobí oltáře, a přistrouce jej přikrytím z koží jezevčích, uvlekou sochory jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","A když to vykoná Aron s syny svými, a přikryje svatyni i všecka nádobí její, a již by se měla hýbati vojska, tedy přijdou synové Kahat, aby nesli; ale nedotknou se svatyně, aby nezemřeli. Ta jest práce synů Kahat při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleazar pak, syn Arona kněze, pečovati bude o olej k svícení a kadění vonnými věcmi a obět ustavičnou i o olej pomazání, svěřený sobě maje všecken příbytek a všecky věci, kteréž v něm jsou, svatyni a nádoby její. ");
INSERT INTO ces1613_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","A mluvil Hospodin k Mojžíšovi a Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Hleďtež, abyste nevyhladili pokolení čeledi Kahat z prostředku Levítů. ");
INSERT INTO ces1613_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ale toto učiníte jim, aby zachováni byli a nezemřeli, když by přistupovali k svatyni svatých: Aron a synové jeho přijdouce, zřídí je, jednoho každého ku práci a břemenu jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","A onino nepřicházejte hleděti na věci svaté, když zavinovány bývají, aby nezemřeli. ");
INSERT INTO ces1613_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Sečti také syny Gersonovy po domích otců jich a po čeledech jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Od třidcítiletých a výše až do padesátiletých sečteš je, kteříž by způsobní jsouce k boji, mohli konati službu při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Tato pak bude práce čeledí Gersonových v službě a nošení: ");
INSERT INTO ces1613_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Nositi budou kortýny příbytku a stánek úmluvy s přikrytím jeho, a přikrytí z koží jezevčích, kteréž svrchu na něm jest, a zastření dveří stánku úmluvy, ");
INSERT INTO ces1613_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","A očkovaté koltry síně, a zastření brány síně, kteráž jest při stanu a při oltáři vůkol, a provazy její, a všecky nádoby přisluhování jejich, a čehožkoli užívají při službě své. ");
INSERT INTO ces1613_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Vedlé rozkazu Aronova a synů jeho konati budou všecky služby své synové Gersonovi při všech pracech svých, a při všech službách svých, a svěříte jim k ostříhání všecka břemena jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ta jest práce čeledí synů Gersonových v stánku úmluvy, a Itamar, syn Arona kněze, stráž nad nimi držeti bude. ");
INSERT INTO ces1613_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Syny také Merari po čeledech jejich a domích otců jejich sečteš. ");
INSERT INTO ces1613_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Od třidcítiletých a výše až do padesátiletých sečteš všecky, kteříž by způsobní jsouce k boji, mohli konati službu při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Tato pak bude povinnost práce jejich, nad všecku službu jejich při stánku úmluvy: Dsky příbytku a svlaky jeho, i sloupy s podstavky jeho nositi, ");
INSERT INTO ces1613_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Sloupy také vůkol síně s podstavky jejich, kolíky a provazy jejich, se všechněmi potřebami, i se vším přisluhováním jejich. A ze jména vyčtete nádoby svěřené jim k ostříhání. ");
INSERT INTO ces1613_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ta bude práce čeledí synů Merari při všech službách jejich při stánku úmluvy, pod spravou Itamara, syna Arona kněze. ");
INSERT INTO ces1613_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","I sečtl Mojžíš s Aronem a s knížaty lidu syny Kahat po čeledech jejich, a po domích otců jejich, ");
INSERT INTO ces1613_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Od třidcítiletých a výše až do padesátiletých, kteříž by způsobní jsouce k boji, mohli konati službu při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","A bylo jich sečtených po čeledech jejich dva tisíce, sedm set, padesáte. ");
INSERT INTO ces1613_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ti jsou sečteni z čeledi Kahat, všickni služebníci při stánku úmluvy, kteréž sčetl Mojžíš s Aronem podlé rozkazu Hospodinova skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Sečtených také synů Gersonových po čeledech jejich, a po domích otců jejich, ");
INSERT INTO ces1613_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Od třidcítiletých a výše až do padesátiletých, kteříž by způsobní jsouce k boji, mohli konati službu při stánku úmluvy, ");
INSERT INTO ces1613_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Sečtených jich po čeledech jejich, po domích otců jejich, dva tisíce, šest set, třidceti. ");
INSERT INTO ces1613_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ti jsou sečteni z čeledí synů Gersonových, všickni přisluhující v stánku úmluvy, kteréž sečtli Mojžíš s Aronem k rozkazu Hospodinovu. ");
INSERT INTO ces1613_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Sečtených pak z čeledí synů Merari po čeledech jejich, po domích otců jejich, ");
INSERT INTO ces1613_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Od třidcítiletých a výše až do padesátiletých, kteříž by způsobní jsouce k boji, mohli konati službu při stánku úmluvy, ");
INSERT INTO ces1613_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Načteno jich po čeledech jejich tři tisíce a dvě stě. ");
INSERT INTO ces1613_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ti jsou sečteni z čeledí synů Merari, kteréž sčetl Mojžíš s Aronem podlé rozkazu Hospodinova skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Všech sečtených, kteréž sčetl Mojžíš s Aronem a s knížaty Izraelskými z Levítů po čeledech jejich a po domích otců jejich, ");
INSERT INTO ces1613_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Od těch, kteříž byli ve třidcíti letech a výše, až do padesátiletých, kteřížkoli přináležejí k vykonávání služby přisluhování a práce břemena při stánku úmluvy, ");
INSERT INTO ces1613_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Sečtených těch bylo osm tisíců, pět set a osmdesáte. ");
INSERT INTO ces1613_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Vedlé rozkazu Hospodinova sečtl je Mojžíš, jednoho každého vedlé přisluhování jeho, a vedlé břemene jeho. Sečteni pak jsou ti, kteréž rozkázal čísti Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Přikaž synům Izraelským, ať vyženou z stanů každého malomocného a každého trpícího tok semene, i každého nad mrtvým poškvrněného. ");
INSERT INTO ces1613_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","I muže i ženu vyženete, ven za stany vyženete je, aby nepoškvrňovali vojska těch, mezi nimiž já přebývám. ");
INSERT INTO ces1613_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","I učinili tak synové Izraelští, a vyhnali je ven za stany. Jakož byl mluvil Hospodin k Mojžíšovi, tak učinili synové Izraelští. ");
INSERT INTO ces1613_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Mluv k synům Izraelským: Muž aneb žena, když učiní nějaký hřích lidský, dopouštěje se výstupku proti Hospodinu, a byla by vinna duše ta: ");
INSERT INTO ces1613_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Tedy vyzná hřích svůj, kterýž učinil, navrátí pak to, čímž vinen byl, v cele, a pátý díl přidá nad to, a dá tomu, proti komuž zavinil. ");
INSERT INTO ces1613_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","A neměl-li by muž ten přítele, jemuž by nahradil tu škodu, pokuta dána buď Hospodinu a knězi, mimo skopce očištění, jímž očištěn býti má. ");
INSERT INTO ces1613_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Též všeliká obět všech věcí posvěcených od synů Izraelských, kterouž přinesou knězi, jemu se dostane. ");
INSERT INTO ces1613_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Tak i věci posvěcené od kohokoli jemu se dostanou; a dal-li kdo co knězi, také jeho bude. ");
INSERT INTO ces1613_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Mluvil ještě Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Mluv k synům Izraelským a rci jim: Kdyby od některého muže uchýlila se žena, a dopustila by se výstupku proti němu, ");
INSERT INTO ces1613_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Tak že by obýval někdo jiný s ní, a bylo by to skryto před očima muže jejího, a tajila by se, jsuci poškvrněna, a svědka by nebylo proti ní, a ona nebyla by postižena; ");
INSERT INTO ces1613_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Pohnul-li by se duch muže horlivostí velikou, tak že by horlil proti ženě své, kteráž by poškvrněna byla; aneb pohnul-li by se duch muže velikou horlivostí, tak že by horlil proti ženě své, kteráž by poškvrněna nebyla: ");
INSERT INTO ces1613_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Tedy přivede muž ženu svou k knězi, a přinese obět její při ní, desátý díl efi mouky ječné. Nenalejeť na ni oleje, aniž dá na ni kadidla; nebo obět veliké horlivosti jest, obět suchá pamětná, uvozující v pamět nepravost. ");
INSERT INTO ces1613_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","I bude ji kněz obětovati, a postaví ji před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","A nabere vody svaté do nádoby hliněné, a vezma prachu, kterýž jest na zemi v příbytku, dá jej do té vody. ");
INSERT INTO ces1613_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Potom postaví kněz ženu tu před Hospodinem, a odkryje hlavu její, a dá jí do rukou obět suchou pamětnou, kteráž jest obět veliké horlivosti; v ruce pak kněze bude voda hořká zlořečená. ");
INSERT INTO ces1613_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","I zaklínati bude ji kněz a řekne k ní: Jestliže neobcoval s tebou žádný, a jestliže jsi neuchýlila se k nečistotě od muže svého, budiž čistá od vody této hořké zlořečené. ");
INSERT INTO ces1613_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Paklis se uchýlila od muže svého a nečistá jsi, a obcoval-li někdo jiný s tebou kromě manžela tvého, ");
INSERT INTO ces1613_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(Zaklínati pak bude kněz tu ženu, čině klatbu zlořečenství, a řekne jí:) Dejž tebe Hospodin v zlořečení a v prokletí u prostřed lidu tvého, dopustě, aby lůno tvé hnilo a břicho tvé oteklo. ");
INSERT INTO ces1613_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Vejdiž voda zlořečená tato do života tvého, aby oteklo břicho tvé, a lůno tvé shnilo. I odpoví žena ta: Amen, amen. ");
INSERT INTO ces1613_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Napíše pak všecko zlořečenství toto do knihy, a smyje je tou vodou hořkou. ");
INSERT INTO ces1613_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","I dá ženě, aby pila vodu hořkou a zlořečenou; a vejdeť do ní voda zlořečená, a obrátí se v hořkosti. ");
INSERT INTO ces1613_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Potom vezme kněz z ruky ženy obět veliké horlivosti, a obraceti ji bude sem i tam před Hospodinem, a bude ji obětovati na oltáři. ");
INSERT INTO ces1613_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","A vezma plnou hrst pamětného jejíhoz oběti suché, páliti to bude na oltáři; a potom dá vypíti ženě tu vodu. ");
INSERT INTO ces1613_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","A když jí dá píti tu vodu, stane se, jestliže nečistá byla, a dopustila se výstupku proti muži svému, že vejde do ní voda zlořečená, a obrátí se v hořkost, i odme se břicho její, a vyhnije lůno její; i bude žena ta v zlořečení u prostřed lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pakli není poškvrněna žena ta, ale čistá jest, tedy bez viny bude, a roditi bude děti. ");
INSERT INTO ces1613_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ten jest zákon veliké horlivosti, když by se uchýlila žena od muže svého, a byla by poškvrněna, ");
INSERT INTO ces1613_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Aneb když by se pohnul duch veliké horlivosti v manželu, tak že by horlil velmi proti ženě své, aby postavil ji před Hospodinem, a aby vykonal při ní kněz všecko vedlé zákona tohoto. ");
INSERT INTO ces1613_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","I bude ten muž očištěn od hříchu, žena pak ponese nepravost svou. ");
INSERT INTO ces1613_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Mluv k synům Izraelským a rci jim: Muž neb žena, když se oddělí, činíce slib nazareův, aby se oddali Hospodinu, ");
INSERT INTO ces1613_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Od vína i nápoje opojného zdrží se, octa vinného a octa z nápoje opojného nebude píti, ani co vytlačeného z hroznů, zelených hroznů ani suchých nebude jísti. ");
INSERT INTO ces1613_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Po všecky dny nazarejství svého nebude jísti žádné věci pocházející z vinného kmene, od zrnka až do šupiny. ");
INSERT INTO ces1613_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Po všecky dny slibu nazarejství svého břitva nevejde na hlavu jeho, dokavadž by se nevyplnili dnové, v nichž se oddělil Hospodinu. Svatý bude, a nechá růsti vlasů hlavy své. ");
INSERT INTO ces1613_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Po všecky dny, v nichž se oddělí Hospodinu, k tělu mrtvému nevejde. ");
INSERT INTO ces1613_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Nad otcem svým aneb nad matkou svou, nad bratrem svým aneb nad sestrou svou, kdyby zemřeli, nebude se poškvrňovati; nebo posvěcení Boha jeho jest na hlavě jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Po všecky dny nazarejství svého svatý bude Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Umřel-li by pak kdo blízko něho náhlou smrtí, a poškvrnil-li by hlavy v nazarejství jeho, oholí hlavu svou v den očišťování svého; dne sedmého oholí ji. ");
INSERT INTO ces1613_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A dne osmého přinese dvě hrdličky, aneb dvé holoubátek knězi, ke dveřím stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","I bude kněz obětovati jedno za hřích, a druhé v zápalnou obět, a očistí jej od toho, čímž zhřešil nad mrtvým, a posvětí hlavy jeho v ten den. ");
INSERT INTO ces1613_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","A oddělí Hospodinu dny nazarejství svého, a přinese beránka ročního za provinění, a dnové první přijdou v nic; nebo poškvrněno jest nazarejství jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Tento pak jest zákon nazareův: V ten den, když se vyplní čas nazarejství jeho, přijde ke dveřím stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","A bude obětovati obět svou Hospodinu, beránka ročního bez poškvrny, jednoho v obět zápalnou, a ovci jednu roční bez poškvrny v obět za hřích, a skopce jednoho bez poškvrny v obět pokojnou, ");
INSERT INTO ces1613_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","A koš chlebů přesných, koláče z mouky bělné olejem zadělané, a pokruty nekvašené, olejem pomazané, s obětmi jejími suchými i mokrými. ");
INSERT INTO ces1613_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kteréžto věci obětovati bude kněz před Hospodinem, a učiní obět za hřích jeho, i zápalnou obět jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Skopce také obětovati bude v obět pokojnou Hospodinu, spolu s košem chlebů přesných; tolikéž obětovati bude kněz i obět suchou i mokrou jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Tedy oholí nazareus u dveří stánku úmluvy hlavu nazarejství svého, a vezma vlasy z hlavy nazarejství svého, vloží je na oheň, kterýž jest pod obětí pokojnou. ");
INSERT INTO ces1613_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Potom vezme kněz plece vařené z skopce toho, a jeden koláč přesný z koše, a pokrutu nekvašenou jednu, a dá v ruce nazarejského, když by oholeno bylo nazarejství jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","I bude obraceti kněz ty věci sem i tam v obět obracení před Hospodinem; a ta věc svatá přináležeti bude knězi mimo hrudí obracení, i plece pozdvižení. A již potom nazareus bude moci víno píti. ");
INSERT INTO ces1613_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ten jest zákon nazarea, kterýž slib učinil, a jeho obět Hospodinu za oddělení jeho, kromě toho, což by více učiniti mohl. Vedlé slibu svého, kterýž učinil, tak učiní podlé zákona oddělení svého. ");
INSERT INTO ces1613_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Mluv k Aronovi a synům jeho a rci: Takto budete požehnání dávati synům Izraelským, mluvíce k nim: ");
INSERT INTO ces1613_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Požehnejž tobě Hospodin, a ostříhejž tebe. ");
INSERT INTO ces1613_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Osvěť Hospodin tvář svou nad tebou, a buď milostiv tobě. ");
INSERT INTO ces1613_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Obratiž Hospodin tvář svou k tobě, a dejž tobě pokoj. ");
INSERT INTO ces1613_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","I budou vzývati jméno mé nad syny Izraelskými, a já jim žehnati budu. ");
INSERT INTO ces1613_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","I stalo se toho dne, když dokonal Mojžíš a vyzdvihl příbytek, a pomazal i posvětil ho se všechněmi nádobami jeho, také oltáře a všeho nádobí jeho pomazal a posvětil, ");
INSERT INTO ces1613_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Že přistupujíce knížata Izraelská, přední v domích otců svých, (ti byli knížata pokolení, postavení nad sečtenými), ");
INSERT INTO ces1613_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Obětovali dar svůj před Hospodinem, šest vozů přikrytých a dvanácte volů. Dvé knížat dalo jeden vůz, a jeden každý jednoho vola, i obětovali to před příbytkem. ");
INSERT INTO ces1613_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","I řekl Hospodin Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Vezmi ty věci od nich, ať jsou ku potřebě při službě stánku úmluvy, a dej je Levítům, každé čeledi podlé přisluhování jejího. ");
INSERT INTO ces1613_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Vzav tedy Mojžíš ty vozy i voly, dal je Levítům. ");
INSERT INTO ces1613_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dva vozy a čtyři voly dal synům Gersonovým vedlé přisluhování jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ètyři pak vozy a osm volů dal synům Merari vedlé přisluhování jejich, kteříž byli pod spravou Itamara, syna Aronova, kněze. ");
INSERT INTO ces1613_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Synům pak Kahat nic nedal; nebo přisluhování svatyně k nim přináleželo, a na ramenou nositi měli. ");
INSERT INTO ces1613_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Obětovali tedy knížata ku posvěcování oltáře v ten den, když pomazán byl; obětovali, pravím, dar svůj před oltářem. ");
INSERT INTO ces1613_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Řekl pak Hospodin Mojžíšovi: Jedno kníže v jeden den, druhé kníže v druhý den, pořád obětovati budou dar svůj ku posvěcení oltáře. ");
INSERT INTO ces1613_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Protož obětoval prvního dne dar svůj Názon, syn Aminadabův, z pokolení Judova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Dar pak jeho byl misa stříbrná jedna, sto třidceti lotů ztíží; též báně jedna stříbrná, sedmdesáti lotů ztíží, jakž jest lot svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Volek jeden mladý, skopec jeden, a beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","A k oběti pokojné volové dva, skopců pět, kozlů pět, a beránků ročních pět. Ta byla obět Názona, syna Aminadabova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Druhého dne obětoval Natanael, syn Suar, kníže z pokolení Izachar. ");
INSERT INTO ces1613_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Obětoval dar svůj misu stříbrnou jednu, sto třidceti lotů ztíží; báni stříbrnou jednu, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Kadidlnici jednu z desíti lotů zlata, plnou kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Volka mladého jednoho, skopce jednoho, a beránka ročního jednoho k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Kozla jednoho za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","A k oběti pokojné voly dva, skopců pět, kozlů pět, a beránků ročních pět. Ten byl dar Natanaele, syna Suar. ");
INSERT INTO ces1613_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Dne třetího kníže synů Zabulonových Eliab, syn Helonův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Dar pak jeho byl misa stříbrná jedna, kteráž sto třidceti lotů vážila; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","A k oběti pokojné volové dva, skopců pět, kozlů pět, a beránků ročních pět. Ta byla obět Eliaba, syna Helonova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ètvrtého dne kníže synů Rubenových Elisur, syn Sedeurův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Dar jeho byl misa stříbrná jedna, kteráž sto třidceti lotů vážila; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané v obět suchou; ");
INSERT INTO ces1613_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","A k oběti pokojné volové dva, skopců pět, kozlů pět, beránků ročních pět. Ten byl dar Elisura, syna Sedeurova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Dne pátého kníže synů Simeonových, Salamiel, syn Surisaddai; ");
INSERT INTO ces1613_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Obět jeho byla misa stříbrná jedna, kteráž sto třidceti lotů vážila; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","A na obět pokojnou volové dva, skopců pět, kozlů pět, beránků ročních pět. Ta byla obět Salamiele, syna Surisaddai. ");
INSERT INTO ces1613_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Dne šestého kníže synů Gád, Eliazaf, syn Duelův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Dar jeho byl misa stříbrná jedna, kteráž sto třidceti lotů vážila; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","A k oběti pokojné volové dva, skopců pět, kozlů pět, a beránků ročních pět. Ten byl dar Eliazafa, syna Duelova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Dne sedmého kníže synů Efraimových, Elisama, syn Amiudův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Dar jeho byl misa stříbrná jedna, kteráž sto třidceti lotů vážila; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané na obět suchou; ");
INSERT INTO ces1613_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","A na obět pokojnou volové dva, skopců pět, kozlů pět, beránků ročních pět. Ten byl dar Elisamův, syna Amiudova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Dne osmého kníže synů Manasse, Gamaliel, syn Fadasurův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Dar jeho byl misa stříbrná jedna, kteráž sto třidceti lotů vážila; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","A k oběti pokojné volové dva, skopců pět, kozlů pět, beránků ročních pět. Ta byla obět Gamaliele, syna Fadasurova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Dne devátého kníže synů Beniaminových, Abidan, syn Gedeonův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Obět jeho misa stříbrná jedna, kteráž sto třidceti lotů vážila; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Volek mladý jeden, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","A k oběti pokojné volové dva, skopců pět, kozlů pět, beránků ročních pět. Ten byl dar Abidanův, syna Gedeonova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Desátého dne kníže synů Dan, Ahiezer, syn Amisaddai. ");
INSERT INTO ces1613_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Obět jeho misa stříbrná jedna, jejížto váha byla sto třidceti lotů; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","A k oběti pokojné volové dva, skopců pět, kozlů pět, a beránků ročních pět. Ten byl dar Ahiezera, syna Amisaddai. ");
INSERT INTO ces1613_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Jedenáctého dne kníže synů Asser, Fegiel, syn Ochranův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Obět jeho misa stříbrná jedna, jejížto váha byla sto třidceti lotů; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Volek jeden mladý, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","A k oběti pokojné volové dva, skopců pět, kozlů pět, beránků ročních pět. Ten byl dar Fegiele, syna Ochranova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Dvanáctého dne kníže synů Neftalím, Ahira, syn Enanův. ");
INSERT INTO ces1613_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Obět jeho byla misa stříbrná jedna, jejížto váha byla sto třidceti lotů; báně stříbrná jedna, sedmdesáti lotů ztíží vedlé lotu svatyně; obě dvě nádoby plné mouky bělné, olejem zadělané k oběti suché; ");
INSERT INTO ces1613_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Kadidlnice jedna z desíti lotů zlata, plná kadidla; ");
INSERT INTO ces1613_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Volek mladý jeden, skopec jeden, beránek roční jeden k oběti zápalné; ");
INSERT INTO ces1613_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Kozel jeden za hřích; ");
INSERT INTO ces1613_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","A k oběti pokojné volové dva, skopců pět, kozlů pět, beránků ročních pět. Ta byla obět Ahiry, syna Enanova. ");
INSERT INTO ces1613_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Toť jest posvěcení oltáře (toho dne, když pomazán jest), od knížat Izraelských: Mis stříbrných dvanácte, bání stříbrných dvanácte, kadidlnic zlatých dvanácte. ");
INSERT INTO ces1613_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Sto třidceti lotů vážila jedna misa stříbrná, a sedmdesáte báně jedna; všecko nádobí stříbrné vážilo dva tisíce a čtyři sta lotů na lot svatyně. ");
INSERT INTO ces1613_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Kadidlnic zlatých dvanácte, plných kadidla; deset lotů vážila každá kadidlnice na váhu svatyně. Všecky kadidlnice zlaté sto a dvadceti lotů vážily. ");
INSERT INTO ces1613_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Všeho dobytka k oběti zápalné dvanácte volků, skopců dvanácte, beránků ročních dvanácte s obětí jejich suchou, a kozlů dvanácte za hřích. ");
INSERT INTO ces1613_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Všeho pak dobytka k oběti pokojné čtyřmecítma volů, skopců šedesáte, kozlů šedesáte, beránků ročních šedesáte. To bylo posvěcení oltáře, když pomazán byl. ");
INSERT INTO ces1613_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Potom když vcházel Mojžíš do stánku úmluvy, aby mluvil s Bohem, tedy slýchal hlas mluvícího k sobě z slitovnice, kteráž byla nad truhlou svědectví mezi dvěma cherubíny, a mluvíval k němu. ");
INSERT INTO ces1613_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Mluv k Aronovi a rci jemu: Když rozsvěcovati budeš lampy, ven z svícnu sedm lamp svítiti má. ");
INSERT INTO ces1613_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","I učinil Aron tak; ven z svícnu světlo od sebe dávající rozsvítil lampy jeho, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Bylo pak dílo svícnu takové: Z taženého zlata byl všecken, až i sloupec jeho i květové jeho z taženého zlata byli; podlé podobenství toho, kteréž ukázal Hospodin Mojžíšovi, tak udělal svícen. ");
INSERT INTO ces1613_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Vezmi Levíty z prostředku synů Izraelských, a očisť je. ");
INSERT INTO ces1613_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Tímto pak způsobem očišťovati je budeš: Pokropíš jich vodou očištění; oholí všecko tělo své, a zperou roucha svá, a očištěni budou. ");
INSERT INTO ces1613_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Potom vezmou volka mladého a obět suchou z mouky bělné, olejem skropené; a druhého volka mladého vezmeš k oběti za hřích. ");
INSERT INTO ces1613_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Tedy přistoupiti rozkážeš Levítům před stánek úmluvy, a shromáždíš všecko množství synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Postavíš Levíty před Hospodinem, a vloží synové Izraelští ruce své na Levíty. ");
INSERT INTO ces1613_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","A obětovati bude Aron Levíty v obět před Hospodinem od synů Izraelských, aby vykonávali službu Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Levítové pak vloží ruce své na hlavy těch volků; a obětovati budeš jednoho za hřích, a druhého v obět zápalnou Hospodinu k očištění Levítů. ");
INSERT INTO ces1613_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","A postavíš Levíty před Aronem a před syny jeho, a obětovati je budeš v obět Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","I oddělíš Levíty z prostředku synů Izraelských, aby moji byli Levítové. ");
INSERT INTO ces1613_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Potom pak přijdou Levítové, aby přisluhovali při stánku úmluvy, když bys očistil je a obětoval v obět. ");
INSERT INTO ces1613_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Nebo vlastně dáni jsou mi z prostředku synů Izraelských za všecky otvírající život, za prvorozené ze všech synů Izraelských vzal jsem je sobě. ");
INSERT INTO ces1613_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Nebo mé jest všecko prvorozené mezi syny Izraelskými, tak z lidí jako z hovad; od toho dne, jakž jsem pobil všecko prvorozené v zemi Egyptské, posvětil jsem jich sobě. ");
INSERT INTO ces1613_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Vzal jsem pak Levíty za všecky prvorozené synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","A dal jsem Levíty darem Aronovi i synům jeho z prostředku synů Izraelských, aby konali službu místo synů Izraelských při stánku úmluvy, a očišťovali od hříchů syny Izraelské; a tak nepřijde na syny Izraelské rána, kteráž by přišla, kdyby přistupovali synové Izraelští k svatyni. ");
INSERT INTO ces1613_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","I učinili Mojžíš a Aron i všecko množství synů Izraelských při Levítích všecko to, což přikázal Hospodin Mojžíšovi o Levítích; tak s nimi učinili synové Izraelští. ");
INSERT INTO ces1613_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","A očistili se Levítové a zeprali roucha svá; a obětoval je Aron v obět před Hospodinem, a očistil je Aron, aby byli čisti. ");
INSERT INTO ces1613_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Potom teprv přistoupili Levítové k vykonávání služby své při stánku úmluvy, před Aronem i před syny jeho; jakž přikázal Hospodin Mojžíšovi o Levítích, tak s nimi učinili. ");
INSERT INTO ces1613_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","I mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","I toto k Levítům přináleží: V pětmecítma letech zstáří a výše jeden každý z nich přistoupí, a postaví se k ochotnému práce konání v službě při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","V padesáti pak letech přestane od práce služby té, a více přisluhovati nebude. ");
INSERT INTO ces1613_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ale přisluhovati bude bratřím svým při stánku úmluvy stráž držícím, sám pak služeb konati nebude. Tak učiníš s Levíty při pracech jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Mluvil pak Hospodin k Mojžíšovi na poušti Sinai, léta druhého po vyjití z země Egyptské, měsíce prvního, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Slaviti budou synové Izraelští velikunoc v čas svůj vyměřený. ");
INSERT INTO ces1613_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ètrnáctého dne měsíce toho u večer budete ji slaviti jistým časem svým, vedlé všech ustanovení jejích, a podlé všech řádů jejích slaviti ji budete. ");
INSERT INTO ces1613_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","I mluvil Mojžíš k synům Izraelským, aby slavili Fáze. ");
INSERT INTO ces1613_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Tedy slavili Fáze v měsíci prvním, čtrnáctého dne u večer na poušti Sinai; vedlé všeho toho, což přikázal Hospodin Mojžíšovi, tak učinili synové Izraelští. ");
INSERT INTO ces1613_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","I byli někteří muži, ješto se poškvrnili při mrtvém, kteříž nemohli slaviti Fáze toho dne. I přistoupili před Mojžíše a Arona v ten den, ");
INSERT INTO ces1613_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","A promluvili muži ti k němu: My jsme se poškvrnili nad mrtvým. Nebude-liž nám zbráněno obětovati oběti Hospodinu v jistý čas spolu s syny Izraelskými? ");
INSERT INTO ces1613_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","I řekl jim Mojžíš: Počekejte, až uslyším, co vám učiniti rozkáže Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Mluv k synům Izraelským a rci: Kdož by koli byl poškvrněný nad mrtvým, aneb byl by na cestě daleké, buď z vás aneb z potomků vašich, budeť slaviti Fáze Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Měsíce druhého, čtrnáctého dne u večer slaviti budou je, s chleby nekvašenými, a s řeřichami jísti je budou. ");
INSERT INTO ces1613_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Nezanechajíť ho nic až do jitra, a kosti v něm nezlámí; vedlé všelikého ustanovení Fáze budou je slaviti. ");
INSERT INTO ces1613_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ale člověk ten, kterýž by byl čistý, a nebyl na cestě, a však by zanedbal slaviti Fáze, vyhlazena bude duše ta z lidu svého; nebo oběti Hospodinu neobětoval v jistý čas její; hřích svůj ponese člověk ten. ");
INSERT INTO ces1613_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Jestliže by s vámi bydlil příchozí, a slavil by Fáze Hospodinu, vedlé ustanovení Fáze, a vedlé řádu jeho bude je slaviti. Ustanovení jednostejné bude vám, tak příchozímu, jako obyvateli v zemi. ");
INSERT INTO ces1613_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Toho pak dne, v kterémž vyzdvižen jest příbytek, přikryl oblak příbytek, a stál nad stánkem svědectví; u večer pak bývalo nad příbytkem na pohledění jako oheň až do jitra. ");
INSERT INTO ces1613_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tak bývalo ustavičně, oblak přikrýval jej ve dne, záře pak ohnivá v noci. ");
INSERT INTO ces1613_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","A když se zdvihl oblak od stánku, hned také hýbali se synové Izraelští; a na kterém místě pozůstal oblak, tu také kladli se synové Izraelští. ");
INSERT INTO ces1613_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","K rozkazu Hospodinovu hýbali se synové Izraelští, a k rozkazu Hospodinovu kladli se; po všecky dny, dokudž zůstával oblak nad příbytkem, i oni leželi. ");
INSERT INTO ces1613_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Když pak trval oblak nad příbytkem po mnohé dny, tedy drželi synové Izraelští stráž Hospodinovu, a netáhli odtud. ");
INSERT INTO ces1613_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","A když oblak byl nad příbytkem po nemnohé dny, k rozkazu Hospodinovu kladli se, a k rozkazu Hospodinovu hýbali se. ");
INSERT INTO ces1613_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kdyžkoli byl oblak od večera až do jitra, a v jitře se vznesl, hned i oni šli; buď že trval přes den a noc, (jakž kdy vznášel se oblak, tak oni táhli,) ");
INSERT INTO ces1613_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Buď že za dva dni, aneb za měsíc, aneb za rok prodléval oblak nad příbytkem, zůstávaje nad ním, synové Izraelští také leželi, a nehnuli se; když pak on vznášel se, též i oni táhli. ");
INSERT INTO ces1613_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","K rozkazu Hospodinovu kladli se, a k rozkazu Hospodinovu hýbali se, stráž Hospodinovu držíce podlé rozkazu jeho skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Udělej sobě dvě trouby stříbrné. Dílem taženým uděláš je, kterýchž užívati budeš k svolání všeho množství, a když by se mělo hnouti vojsko. ");
INSERT INTO ces1613_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Protož kdyžkoli zatroubí na ně, shromáždí se k tobě všecko množství ke dveřím stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Jestliže v jednu toliko zatroubí, tedy shromáždí se k tobě knížata, přední lidu Izraelského. ");
INSERT INTO ces1613_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Pakli by s nějakým přetrubováním troubili, hnou se s místa, kteříž leželi k východní straně. ");
INSERT INTO ces1613_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Když by pak troubili s přetrubováním po druhé, tedy hnou se ti, kteříž leželi ku poledni. S přetrubováním troubiti budou k tažení svému. ");
INSERT INTO ces1613_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ale když byste měli svolati všecko množství, prostě bez přetrubování troubiti budete. ");
INSERT INTO ces1613_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Synové Aronovi kněží trubami těmi budou troubiti, a bude vám to ustanovení věčné v pronárodech vašich. ");
INSERT INTO ces1613_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Když vyjdete na vojnu v zemi vaší proti nepříteli ssužujícímu vás, s přetrubováním troubiti budete v trouby ty, a budete v paměti před Hospodinem Bohem svým, a zachováni budete od nepřátel svých. ");
INSERT INTO ces1613_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","V den také veselí vašeho, a při slavnostech svých, a při začátcích měsíců vašich troubiti budete v trouby ty k obětem svým zápalným a pokojným, i budou vám na památku před Bohem vaším: Já Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","I stalo se léta druhého, dvadcátý den měsíce druhého, že se vyzdvihl oblak z příbytku svědectví. ");
INSERT INTO ces1613_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","I táhli synové Izraelští po svých taženích z pouště Sinai; a zastavil se oblak na poušti Fáran. ");
INSERT INTO ces1613_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Takto nejprvé brali se z rozkazu Hospodinova skrze Mojžíše: ");
INSERT INTO ces1613_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Šla napřed korouhev vojska synů Juda po houfích svých, a nad nimi byl Názon, syn Aminadabův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nad vojskem pak pokolení synů Izachar byl Natanael, syn Suar. ");
INSERT INTO ces1613_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","A nad vojskem pokolení synů Zabulon Eliab, syn Helonův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Složen jest také i příbytek, a šli synové Gersonovi a synové Merari nesouce příbytek. ");
INSERT INTO ces1613_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Potom šla korouhev vojska Rubenova po houfích svých, a nad nimi byl Elisur, syn Sedeurův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Nad vojskem pak pokolení synů Simeon Salamiel, syn Surisaddai. ");
INSERT INTO ces1613_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","A nad vojskem pokolení synů Gád Eliazaf, syn Duelův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Šli také i Kahatští, nesouce svatyni; onino pak vyzdvihovali příbytek, až i tito přišli. ");
INSERT INTO ces1613_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Potom šla korouhev vojska synů Efraim po houfích svých, a nad nimi byl Elisama, syn Amiudův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Nad vojskem pak pokolení synů Manasse Gamaliel, syn Fadasurův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","A nad vojskem pokolení synů Beniamin Abidan, syn Gedeonův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Šla potom i korouhev vojska synů Dan, obsahující ostatek vojska po houfích svých, a nad vojskem jeho Ahiezer, syn Amisaddai. ");
INSERT INTO ces1613_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Nad vojskem pak pokolení synů Asser Fegiel, syn Ochranův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","A nad vojskem pokolení synů Neftalím Ahira, syn Enanův. ");
INSERT INTO ces1613_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ta jsou tažení synů Izraelských po houfích jejich, a tím pořádkem táhli. ");
INSERT INTO ces1613_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Řekl pak Mojžíš Chobabovi, synu Raguelovu Madianskému, tchánu svému: My se béřeme k místu, o kterémž řekl Hospodin: Dám je vám. Protož poď s námi, a dobře učiníme tobě; nebo Hospodin mnoho dobrého zaslíbil Izraelovi. ");
INSERT INTO ces1613_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Kterýž odpověděl jemu: Nepůjdu, ale k zemi své a k příbuznosti své se navrátím. ");
INSERT INTO ces1613_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","I řekl Mojžíš: Neopouštěj medle nás; nebo ty jsi svědom na poušti, kde bychom se měli klásti, a budeš nám za vůdce. ");
INSERT INTO ces1613_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Když pak půjdeš s námi, a přijde to dobré, jímž dobře učiní nám Hospodin, tedy i tobě dobře učiníme. ");
INSERT INTO ces1613_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","A tak brali se od hory Hospodinovy cestou tří dnů, (a truhla smlouvy Hospodinovy předcházela je,) cestou tří dnů, pro vyhlédání sobě místa k odpočinutí. ");
INSERT INTO ces1613_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","A oblak Hospodinův byl nad nimi ve dne, když se hýbali z ležení. ");
INSERT INTO ces1613_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Když pak počínali jíti s truhlou, říkával Mojžíš: Povstaniž Hospodine, a rozptýleni buďte nepřátelé tvoji, a ať utíkají před tváří tvou, kteříž tě v nenávisti mají. ");
INSERT INTO ces1613_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Když pak stavína byla, říkával: Navratiž se, Hospodine, k desíti tisícům tisíců Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","I stalo se, že lid ztěžoval a stýskal sobě, cožse nelíbilo Hospodinu. Protož, slyše to Hospodin, rozhněval se náramně, a roznítil se proti nim oheň Hospodinův, a spálil zadní díl vojska. ");
INSERT INTO ces1613_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tedy volal lid k Mojžíšovi. I modlil se Mojžíš Hospodinu, a uhasl oheň. ");
INSERT INTO ces1613_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","I nazval jméno místa toho Tabbera; nebo rozpálil se proti nim oheň Hospodinův. ");
INSERT INTO ces1613_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Lid pak k nim přimíšený napadla žádost náramná; a obrátivše se, plakali i synové Izraelští a řekli: Kdo nám to dá, abychom se masa najedli? ");
INSERT INTO ces1613_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Rozpomínáme se na ryby, jichž jsme dosti v Egyptě darmo jídali, na okurky a melouny, též na por, cibuli a česnek. ");
INSERT INTO ces1613_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","A nyní duše naše vyprahlá, nic jiného nemá, kromě tu mannu před očima svýma. ");
INSERT INTO ces1613_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Manna pak byla jako semeno koliandrové, a barva její jako barva bdelium. ");
INSERT INTO ces1613_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","I vycházíval lid, a sbírali a mleli žernovy, neb tloukli v moždířích, a smažili na pánvici, aneb koláče podpopelné dělali z ní; chut pak její byla jako chut nového oleje. ");
INSERT INTO ces1613_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Když pak sstupovala rosa na vojsko v noci, tedy sstupovala také i manna). ");
INSERT INTO ces1613_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Tedy uslyšel Mojžíš, an lid pláče po čeledech svých, každý u dveří stanu svého. Pročež roznítila se prchlivost Hospodinova náramně; Mojžíšovi to také těžké bylo. ");
INSERT INTO ces1613_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","I řekl Mojžíš Hospodinu: Proč jsi tak zle učinil služebníku svému? Proč jsem nenalezl milosti před očima tvýma, že jsi vložil břímě všeho lidu tohoto na mne? ");
INSERT INTO ces1613_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Zdaliž jsem já počal všecken lid tento? Zdali jsem já zplodil jej, že mi díš: Nes jej na rukou svých, jako nosí chůva děťátko, do země té, kterouž jsi s přísahou zaslíbil otcům jejich? ");
INSERT INTO ces1613_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Kde mám nabrati masa, abych dal všemu lidu tomuto? Nebo plačí na mne, řkouce: Dej nám masa, ať jíme. ");
INSERT INTO ces1613_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Nemohuť já sám nésti všeho lidu tohoto, nebo jest to nad možnost mou. ");
INSERT INTO ces1613_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Pakli mi tak dělati chceš, prosím, zabí mne raději, jestliže jsem nalezl milost před očima tvýma, abych více nehleděl na trápení své. ");
INSERT INTO ces1613_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Tedy řekl Hospodin Mojžíšovi: Shromažď mi sedmdesáte mužů z starších Izraelských, kteréž znáš, že jsou starší v lidu a správcové jeho; i přivedeš je ke dveřím stánku úmluvy, a státi budou tam s tebou. ");
INSERT INTO ces1613_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","A já sstoupím a mluviti budu s tebou, a vezmu z ducha, kterýž jest na tobě, a dám jim. I ponesou s tebou břímě lidu, a tak ty ho sám neponeseš. ");
INSERT INTO ces1613_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Lidu pak díš: Posvěťtež se k zítřku, a budete jísti maso; nebo jste plakali v uších Hospodinových, řkouce: Kdo nám dá najísti se masa? Jistě že lépe nám bylo v Egyptě. I dá vám Hospodin masa, a budete jísti. ");
INSERT INTO ces1613_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nebudete toliko jeden den jísti, ani dva, ani pět, ani deset, ani dvadcet, ");
INSERT INTO ces1613_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ale za celý měsíc, až vám chřípěmi poleze, a zoškliví se, proto že jste pohrdli Hospodinem, kterýž jest u prostřed vás, a plakali jste před ním, říkajíce: Proč jsme vyšli z Egypta? ");
INSERT INTO ces1613_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","I řekl Mojžíš: Šestkrát sto tisíců pěších jest tohoto lidu, mezi nimiž já jsem, a ty pravíš: Dám jim masa, aby jedli za celý měsíc. ");
INSERT INTO ces1613_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Zdali ovcí a volů nabije se jim, aby jim postačilo? Aneb zdali všecky ryby mořské shromáždí se jim, aby jim dosti bylo? ");
INSERT INTO ces1613_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Tedy řekl Hospodin Mojžíšovi: Zdali ruka Hospodinova ukrácena jest? Již nyní uzříš, přijde-li na to, což jsem mluvil, čili nic. ");
INSERT INTO ces1613_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Vyšed tedy Mojžíš, mluvil lidu slova Hospodinova, a shromáždiv sedmdesáte mužů z starších lidu, postavil je vůkol stánku. ");
INSERT INTO ces1613_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","I sstoupil Hospodin v oblaku a mluvil k němu, a vzav z ducha, kterýž byl na něm, dal sedmdesáti mužům starším. I stalo se, když odpočinul na nich ten duch, že prorokovali, ale potom nikdy více. ");
INSERT INTO ces1613_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Byli pak zůstali v staních dva muži, jméno jednoho Eldad, a druhého Medad, na nichž také odpočinul duch ten, nebo i oni napsani byli, ačkoli nevyšli k stánku. I ti také prorokovali v staních. ");
INSERT INTO ces1613_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Tedy přiběh služebník, oznámil to Mojžíšovi, řka: Eldad a Medad prorokují v staních. ");
INSERT INTO ces1613_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jozue pak, syn Nun, služebník Mojžíšův, jeden z mládenců jeho, dí k tomu: Pane můj, Mojžíši, zabraň jim. ");
INSERT INTO ces1613_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Jemuž odpověděl Mojžíš: Proč ty horlíš pro mne? Nýbrž ó kdyby všecken lid Hospodinův proroci byli, a aby dal Hospodin ducha svého na ně! ");
INSERT INTO ces1613_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","I navrátil se Mojžíš do stanů s staršími Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Tedy strhl se vítr od Hospodina, a zachvátiv křepelky od moře, spustil je na stany tak široce a dlouze, co by mohl za jeden den cesty ujíti všudy vůkol táboru, takměř na dva lokty zvýší nad zemí. ");
INSERT INTO ces1613_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Protož vstav lid, celý ten den a celou noc, i celý druhý den shromažďovali sobě ty křepelky; a kdož nejméně nashromáždil, měl jich s deset měr. I rozvěšeli je sobě pořád okolo stanů. ");
INSERT INTO ces1613_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ještě maso vězelo v zubích jejich, a nebylo právě sžvýkáno, když hněv Hospodinův vzbudil se na lid. I ranil Hospodin lid ranou velikou náramně. ");
INSERT INTO ces1613_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Protož nazváno jest jméno místa toho Kibrot Hattáve; nebo tu pochovali lid, kterýž žádal masa. ");
INSERT INTO ces1613_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","I bral se lid z Kibrot Hattáve na poušť Hazerot, a pozůstali v Hazerot. ");
INSERT INTO ces1613_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","A mluvila Maria i Aron proti Mojžíšovi příčinou manželky Madianky, kterouž sobě vzal; nebo byl pojal manželku Madianku. ");
INSERT INTO ces1613_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","A řekli: Zdaliž jen toliko skrze Mojžíše mluvil Hospodin? Zdaž také nemluvil skrze nás? I slyšel to Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Byl pak Mojžíš člověk nejtišší ze všech lidí, kteříž byli na tváři země). ");
INSERT INTO ces1613_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","A ihned řekl Hospodin Mojžíšovi a Aronovi i Marii: Vyjděte vy tři k stánku úmluvy. I vyšli toliko oni tři. ");
INSERT INTO ces1613_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Tedy sstoupil Hospodin v sloupu oblakovém, a stál u dveří stánku. I zavolal Arona a Marie, a vyšli oba dva. ");
INSERT INTO ces1613_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Jimž řekl: Slyšte nyní slova má: Prorok když jest mezi vámi, já Hospodin u vidění ukáži se jemu, ve snách mluviti budu s ním. ");
INSERT INTO ces1613_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ale není takový služebník můj Mojžíš, kterýž ve všem domě mém věrný jest. ");
INSERT INTO ces1613_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ústy k ústům mluvím s ním, ne u vidění, ani v zavinutí, a podobnost Hospodinovu spatřuje. Pročež jste tedy neostýchali se mluviti proti služebníku mému Mojžíšovi? ");
INSERT INTO ces1613_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","I roznícena jest prchlivost Hospodinova na ně, a odšel. ");
INSERT INTO ces1613_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Oblak také zdvihl se s stánku. A aj, Maria byla malomocná, bílá jako sníh. A pohleděl Aron na Marii, ana malomocná. ");
INSERT INTO ces1613_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Tedy řekl Aron Mojžíšovi: Poslyš mne, pane můj, prosím, nevzkládej na nás té pokuty za hřích ten, jehož jsme se bláznivě dopustili, a jímž jsme zhřešili. ");
INSERT INTO ces1613_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Prosím, ať není tato jako mrtvý plod, kterýž když vychází z života matky své, polovici těla jeho zkaženého bývá. ");
INSERT INTO ces1613_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","I volal Mojžíš k Hospodinu, řka: Ó Bože silný, prosím, uzdraviž ji. ");
INSERT INTO ces1613_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Odpověděl Hospodin Mojžíšovi: Kdyby otec její plinul jí na tvář, zdaž by se nemusila styděti za sedm dní? Protož ať jest vyobcována ven z stanů za sedm dní, a potom zase uvedena bude. ");
INSERT INTO ces1613_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Tedy vyloučena jest Maria ven z stanů za sedm dní; a lid nehnul se odtud, až zase uvedena jest Maria. ");
INSERT INTO ces1613_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Potom pak bral se lid z Hazerot, a položil se na poušti Fáran. ");
INSERT INTO ces1613_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Pošli sobě muže, kteříž by spatřili zemi Kananejskou, kterouž já dám synům Izraelským; jednoho muže z každého pokolení otců jejich vyšlete, ty, kteříž by byli přednější mezi nimi. ");
INSERT INTO ces1613_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Poslal je tedy Mojžíš z pouště Fáran, jakž byl rozkázal Hospodin; a všickni ti muži byli knížata mezi syny Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Tato jsou pak jména jejich: Z pokolení Ruben Sammua, syn Zakurův; ");
INSERT INTO ces1613_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Z pokolení Simeon Safat, syn Huri; ");
INSERT INTO ces1613_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Z pokolení Juda Kálef, syn Jefonův; ");
INSERT INTO ces1613_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Z pokolení Izachar Igal, syn Jozefův; ");
INSERT INTO ces1613_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Z pokolení Efraim Ozeáš, syn Nun; ");
INSERT INTO ces1613_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Z pokolení Beniamin Falti, syn Rafův; ");
INSERT INTO ces1613_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Z pokolení Zabulon Gaddehel, syn Sodi; ");
INSERT INTO ces1613_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Z pokolení Jozef a z pokolení Manasses Gaddi, syn Susi; ");
INSERT INTO ces1613_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Z pokolení Dan Amiel, syn Gemalův; ");
INSERT INTO ces1613_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Z pokolení Asser Setur, syn Michaelův; ");
INSERT INTO ces1613_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Z pokolení Neftalím Nahabi, syn Vafsi; ");
INSERT INTO ces1613_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Z pokolení Gád Guhel, syn Máchův; ");
INSERT INTO ces1613_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ta jsou jména mužů, kteréž poslal Mojžíš, aby shlédli zemi. I přezděl Mojžíš Ozeovi, synu Nun, Jozue. ");
INSERT INTO ces1613_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Tedy poslal je Mojžíš, aby prohlédli zemi Kananejskou, a řekl jim: Jděte tudyto při straně polední a vejděte na hory. ");
INSERT INTO ces1613_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","A shlédněte, jaká jest země ta, i lid, kterýž bydlí v ní, silný-li jest či mdlý? málo-li jich, či mnoho? ");
INSERT INTO ces1613_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","A jaká jest též země ta, v níž on bydlí, dobrá-li jest, či zlá? a jaká jsou města, v nichž přebývají, v staních-li, či v hrazených místech? ");
INSERT INTO ces1613_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Tolikéž jaká jest země, úrodná-li, či neúrodná, jest-li na ní stromoví, či není? A buďte udatné mysli, a přineste nám z ovoce té země. A byl tehdáž čas, v němžto hroznové zaměkali. ");
INSERT INTO ces1613_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Odšedše tedy, prohlédli tu zemi od pouště Tsin až do Rohob, kudy se jde do Emat. ");
INSERT INTO ces1613_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","I šli stranou polední, a přišli až do Hebronu, kdežto byli Achiman a Sesai a Tolmai, synové Enakovi. Hebron pak o sedm let prvé ustaveno jest, nežli Soan, město Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Potom přišli až do údolí Eškol, a tu uřezali ratolest s hroznem jedním jahodek plným, a nesli jej na sochoře dva; též i jablka zrnatá i fíky té země. ");
INSERT INTO ces1613_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","I nazváno jest to místo Nehel Eškol, od hroznu, kterýž tu uřezali synové Izraelští. ");
INSERT INTO ces1613_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Navrátili se pak zase, prošedše zemi, po čtyřidcíti dnech. ");
INSERT INTO ces1613_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","A jdouce, přišli k Mojžíšovi a k Aronovi i ke všemu množství synů Izraelských, na poušti Fáran v Kádes, a oznámili jim i všemu množství to, co spravili, a ukázali jim ovoce země té. ");
INSERT INTO ces1613_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","A vypravujíce jim, řekli: Přišli jsme do země, do kteréž jsi nás poslal, kteráž v pravdě oplývá mlékem a strdí, a toto jest ovoce její. ");
INSERT INTO ces1613_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Než že lid jest silný, kterýž bydlí v zemi té, města také pevná jsou a veliká velmi, k tomu i syny Enakovy tam jsme viděli. ");
INSERT INTO ces1613_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Amalech bydlí v kraji poledním, a Hetejský, Jebuzejský a Amorejský bydlejí na horách, Kananejský pak bydlí při moři a při břehu Jordánském. ");
INSERT INTO ces1613_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","I krotil Kálef lid bouřící se proti Mojžíšovi, a mluvil: Jděme předce, a opanujme zemi, nebo zmocníme se jí. ");
INSERT INTO ces1613_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ale muži ti, kteříž chodili s ním, pravili: Nikoli nebudeme moci vstoupiti proti lidu tomu, nebo silnější jest nežli my. ");
INSERT INTO ces1613_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","I zhaněli a zošklivili zemi shlédnutou synům Izraelským, mluvíce: Země, již jsme prošli a spatřili, jest země taková, ješto hubí obyvatele své; a všecken lid, kterýž jsme viděli u prostřed ní, jsou muži postavy vysoké velmi. ");
INSERT INTO ces1613_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Také jsme tam viděli obry, syny Enakovy, kteříž jsou větší než jiní obrové, ješto se nám zdálo, že jsme proti nim jako kobylky, a takoví jsme se i jim zdáli. ");
INSERT INTO ces1613_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Tehdy pozdvihše se všecko množství, křičeli, a plakal lid v tu noc. ");
INSERT INTO ces1613_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","A reptali proti Mojžíšovi i proti Aronovi všickni synové Izraelští, a řeklo k nim všecko množství: Ó bychom byli zemřeli v zemi Egyptské, aneb na této poušti, ó bychom byli zemřeli! ");
INSERT INTO ces1613_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","A proč Hospodin vede nás do země té, abychom padli od meče, ženy naše i dítky naše aby byly v loupež? Není-liž nám lépe navrátiti se zase do Egypta? ");
INSERT INTO ces1613_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","I řekli jeden druhému: Ustanovme sobě vůdci, a navraťme se do Egypta. ");
INSERT INTO ces1613_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Tedy padli Mojžíš a Aron na tváři své přede vším množstvím shromáždění synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Jozue pak, syn Nun, a Kálef, syn Jefonův, z těch, kteříž byli shlédli zemi, roztrhli roucha svá, ");
INSERT INTO ces1613_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","A mluvili ke všemu množství synů Izraelských, řkouce: Země, kterouž jsme prošli a vyšetřili, jest země velmi velice dobrá. ");
INSERT INTO ces1613_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Bude-li Hospodin laskav na nás, uvedeť nás do země té, a dá ji nám, a to zemi takovou, kteráž oplývá mlékem a strdí. ");
INSERT INTO ces1613_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Toliko nepozdvihujte se proti Hospodinu, ani se bojte lidu země té, nebo jako chléb náš jsou. Odešlatě od nich ochrana jejich, ale s námi jest Hospodin; nebojtež se jich. ");
INSERT INTO ces1613_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Tedy mluvilo všecko množství, aby je kamením uházeli, ale sláva Hospodinova ukázala se nad stánkem úmluvy všechněm synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","I řekl Hospodin Mojžíšovi: I dokavadž popouzeti mne bude lid ten? A dokud nebudou mi věřiti pro tak mnohá znamení, kteráž jsem činil u prostřed nich? ");
INSERT INTO ces1613_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Raním jej morem a rozženu jej, tebe pak učiním v národ veliký a silnější, nežli jest tento. ");
INSERT INTO ces1613_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","I řekl Mojžíš Hospodinu: Ale uslyšíť to Egyptští, z jejichž prostředku vyvedl jsi lid tento v síle své, ");
INSERT INTO ces1613_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","A řeknou s obyvateli země té: (nebo slyšeli, že jsi ty, ó Hospodine, byl u prostřed lidu tohoto, a že jsi okem v oko spatřován byl, ó Hospodine, a oblak tvůj stál nad nimi, a v sloupě oblakovém předcházel jsi je ve dne, a v sloupě ohnivém v noci), ");
INSERT INTO ces1613_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Když tedy zmoříš lid ten, všecky až do jednoho, mluviti budou národové, kteříž slyšeli pověst o tobě, říkajíce: ");
INSERT INTO ces1613_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Proto že nemohl Hospodin uvésti lidu toho do země, kterouž jim s přísahou zaslíbil, zmordoval je na poušti. ");
INSERT INTO ces1613_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nyní tedy, prosím, nechať jest zvelebena moc Páně, jakož jsi mluvil, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Hospodin dlouhočekající a hojný v milosrdenství, odpouštějící nepravost a přestoupení, kterýž však z vinného nečiní nevinného, ale navštěvuje nepravost otců na synech do třetího i čtvrtého pokolení. ");
INSERT INTO ces1613_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Odpusť, prosím, nepravost lidu tohoto podlé velikého milosrdenství svého, tak jako jsi odpouštěl lidu tomuto, jakž vyšel z Egypta až dosavad. ");
INSERT INTO ces1613_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","I řekl Hospodin: Odpustil jsem vedlé slova tvého. ");
INSERT INTO ces1613_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","A však živ jsem já, a sláva má naplňuje všecku zemi, ");
INSERT INTO ces1613_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Že všickni ti, kteříž viděli slávu mou a znamení má, kteráž jsem činil v Egyptě a na poušti této, a kteříž pokoušeli mne již desetkrát, aniž uposlechli hlasu mého, ");
INSERT INTO ces1613_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Neuzří země té, kterouž jsem s přísahou zaslíbil otcům jejich, aniž jí kdo z těch, kteříž mne popouzeli, uhlédá. ");
INSERT INTO ces1613_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ale služebníka svého Kálefa, (nebo v něm byl jiný duch, a cele následoval mne), uvedu jej do země, do kteréž chodil, a símě jeho dědičně obdrží ji. ");
INSERT INTO ces1613_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ale poněvadž Amalechitský a Kananejský bydlí v tom údolí, obraťte se zase zítra, a beřte se na poušť cestou k moři Rudému. ");
INSERT INTO ces1613_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Mluvil také Hospodin k Mojžíšovi a Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Až dokud snášeti budu množství toto zlé, kteréž repce proti mně? Až dokud reptání synů Izraelských, kteříž repcí proti mně, slyšeti budu? ");
INSERT INTO ces1613_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Rci jim: Živ jsem já, praví Hospodin, žeť vám učiním tak, jakž jste mluvili v uši mé: ");
INSERT INTO ces1613_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Na poušti této padnou mrtvá těla vaše, a všickni, kteříž jste sečteni, podlé všeho počtu vašeho od majících let dvadceti a výše, kteříž jste reptali proti mně, ");
INSERT INTO ces1613_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Nevejdete, pravím, vy do země, o kteréž, zdvihna ruku svou, přisáhl jsem, že vás osadím v ní, jediné Kálef, syn Jefonův, a Jozue, syn Nun. ");
INSERT INTO ces1613_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ale dítky vaše malé, o nichž jste řekli, že v loupež budou, ty uvedu, aby užívali země té, kterouž jste vy pohrdli. ");
INSERT INTO ces1613_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Těla pak vaše mrtvá padnou na poušti této. ");
INSERT INTO ces1613_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","A synové vaši budou tuláci na poušti této čtyřidceti let, a ponesou pokutu smilství vašeho, až do konce vyhynou těla vaše na poušti. ");
INSERT INTO ces1613_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Podlé počtu dnů, v nichž jste procházeli zemi tu, totiž čtyřidceti dnů, jeden každý den za rok počítaje, ponesete nepravosti své čtyřidceti let, a poznáte pomstu svého odtržení se ode mne. ");
INSERT INTO ces1613_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Já Hospodin mluvil jsem, že to učiním všemu tomuto množství zlému, kteréž se zrotilo proti mně; na poušti této do konce zhynou, a tu zemrou. ");
INSERT INTO ces1613_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Muži pak ti, kteréž poslal byl Mojžíš k shlédnutí země té, a kteříž, navrátivše se, uvedli v reptání proti němu všecko množství to, haněním ošklivíce zemi, ");
INSERT INTO ces1613_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ti, řku, muži, kteříž haněli zemi, ranou těžkou zemřeli před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Jozue pak, syn Nun, a Kálef, syn Jefonův, živi zůstali z mužů těch, kteříž chodili k vyšetření země. ");
INSERT INTO ces1613_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Tedy mluvil Mojžíš slova ta ke všechněm synům Izraelským; i plakal lid velmi. ");
INSERT INTO ces1613_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","A vstavše ráno, vstoupili na vrch hory, a řekli: Aj, my hotovi jsme, abychom šli k místu, o němž mluvil Hospodin; nebo jsme zhřešili. ");
INSERT INTO ces1613_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Jimž řekl Mojžíš: Proč jest to, že vy přestupujete přikázaní Hospodinovo? ješto vám to na dobré nevyjde. ");
INSERT INTO ces1613_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Nevstupujte, nebo Hospodin není u prostřed vás, abyste nebyli poraženi od nepřátel vašich. ");
INSERT INTO ces1613_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalechitský zajisté a Kananejský jest tu před vámi, a padnete od meče, proto že jste se odvrátili od následování Hospodina, aniž také Hospodin bude s vámi. ");
INSERT INTO ces1613_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Oni pak předce usilovali vstoupiti na vrch hory, ale truhla smlouvy Hospodinovy a Mojžíš nevycházeli z stanů. ");
INSERT INTO ces1613_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tedy sstoupili Amalechitský a Kananejský, kteříž bydlili na těch horách, a porazili je, a potírali je až do Horma. ");
INSERT INTO ces1613_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Mluv k synům Izraelským a rci jim: Když vejdete do země přebývání vašich, kterouž já dám vám, ");
INSERT INTO ces1613_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","A budete chtíti obětovati obět ohnivou Hospodinu v zápal, aneb obět buď slíbenou, buď dobrovolnou, aneb při slavnostech vašich, abyste učinili vůni spokojující Hospodina, buďto z skotů, aneb z drobného dobytku: ");
INSERT INTO ces1613_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Tedy kdož by koli obětoval dar svůj Hospodinu, obětuj obět suchou, desátý díl efi mouky bělné, zadělané olejem, jehož bude čtvrtý díl míry hin. ");
INSERT INTO ces1613_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","A vína v obět mokrou čtvrtinku hin obětovati budeš při zápalu, aneb při oběti vítězné k jednomu každému beránku. ");
INSERT INTO ces1613_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Při beranu pak obětovati budeš obět suchou, mouky bělné dvě desetiny, zadělané olejem, třetinkou míry hin. ");
INSERT INTO ces1613_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Vína také k oběti mokré třetí díl míry hin obětovati budeš u vůni spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Jestliže pak obětovati budeš volka v obět zápalnou, aneb v obět k splnění slibu, aneb v obět pokojnou Hospodinu: ");
INSERT INTO ces1613_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Tedy budeš obětovati spolu s volkem obět suchou, tři desetiny mouky bělné, zadělané olejem, jehož by byla půlka hin. ");
INSERT INTO ces1613_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","A vína k oběti mokré obětovati budeš půlku hin. Ta jest obět ohnivá vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Tak uděláte s každým volem i s každým skopcem, i s dobytčetem buď ono z ovec neb z koz. ");
INSERT INTO ces1613_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Podlé toho, jakž mnoho jich obětovati budete, tak se zachováte při jednom každém z nich. ");
INSERT INTO ces1613_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Všeliký obyvatel tak bude to vykonávati, aby obětoval obět ohnivou vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Takž bude-li u vás i příchozí, aneb kdokoli mezi vámi v pronárodech vašich, a bude obětovati obět ohnivou vůně spokojující Hospodina, jakž vy se při tom chováte, tak i on chovati se bude. ");
INSERT INTO ces1613_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","V shromáždění tomto ustanovení jednostejné buď vám i příchozímu, kterýž by u vás byl, ustanovení věčné v pronárodech vašich; jakož vy, tak příchozí bude před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Zákon jednostejný a pořádek jednostejný bude vám i přichozímu kterýž by u vás byl. ");
INSERT INTO ces1613_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Mluv k synům Izraelským a rci jim: Když přijdete do země, do kteréž já uvedu vás, ");
INSERT INTO ces1613_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Tedy, když počnete jísti chléb země, obětovati budete obět vzhůru pozdvižení Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Z prvotin těsta vašeho koláč obětovati budete v obět vzhůru pozdvižení; tak jako obět z humna, obětovati budete ji. ");
INSERT INTO ces1613_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Z prvotin těsta vašeho dávati budete Hospodinu obět vzhůru pozdvižení, vy i potomci vaši. ");
INSERT INTO ces1613_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","A když byste pozbloudili, a neučinili všech přikázaní těch, kteráž mluvil Hospodin k Mojžíšovi, ");
INSERT INTO ces1613_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Totiž všech věcí, kteréž přikázal Hospodin vám skrze Mojžíše, od toho dne, v kterémž přikázaní vydal Hospodin, i potom v pronárodech vašich: ");
INSERT INTO ces1613_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Tedy jestliže z nedopatření všeho shromáždění to stalo se, obětovati bude všecko množství volka mladého jednoho v obět zápalnou, k vůni spokojující Hospodina, též obět suchou, a obět mokrou při něm podlé pořádku, a kozla jednoho v obět za hřích. ");
INSERT INTO ces1613_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","I očistí kněz všecko množství synů Izraelských, a odpuštěno jim bude; nebo poblouzení jest. A oni také obětovati budou obět svou, obět ohnivou Hospodinu, a obět za hřích svůj před Hospodinem za poblouzení své. ");
INSERT INTO ces1613_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","I bude odpuštěno všemu shromáždění synů Izraelských i příchozímu, kterýž jest pohostinu u prostřed nich; nebo všeho lidu poblouzení jest. ");
INSERT INTO ces1613_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Jestliže by pak člověk jeden zhřešil z poblouzení, bude obětovati kozu roční v obět za hřích. ");
INSERT INTO ces1613_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","I očistí kněz duši pobloudilou, kteráž zhřešila poblouzením před Hospodinem; očistí ji, a budeť jí odpuštěno. ");
INSERT INTO ces1613_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Domácímu mezi syny Izraelskými i příchozímu, kterýž pohostinu mezi nimi jest, zákon tento jednostejný bude vám, když by kdo zhřešil z poblouzení. ");
INSERT INTO ces1613_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Èlověk pak, kterýž by z pychu svévolně zhřešil, tak doma zrozený jako příchozí, takový potupil velice Hospodina; protož vyhlazen bude z prostředku lidu svého. ");
INSERT INTO ces1613_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Nebo slovem Hospodinovým pohrdl, a přikázaní jeho za nic sobě položil; protož konečně vyhlazen bude člověk ten, a nepravost jeho zůstane na něm. ");
INSERT INTO ces1613_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Stalo se pak, když synové Izraelští byli na poušti, že nalezli jednoho, an sbírá dříví v den sobotní. ");
INSERT INTO ces1613_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","A ti, kteříž ho nalezli sbírajícího dříví, přivedli jej k Mojžíšovi a k Aronovi i ke všemu množství. ");
INSERT INTO ces1613_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","I dali jej do vězení; nebo ještě nebylo jim oznámeno, co by s ním mělo činěno býti. ");
INSERT INTO ces1613_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","I řekl Hospodin Mojžíšovi: Smrtí ať umře člověk ten; nechať ho bez milosti ukamenuje všecko množství vně za stany. ");
INSERT INTO ces1613_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","A protož vyvedli jej všecko množství ven za stany, a uházeli ho kamením, až umřel, jakož rozkázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Mluv k synům Izraelským a rci jim, ať sobě dělají třepení široké na podolcích oděvů svých všickni rodové jejich, a ať dávají nad třepením šňůrku modrou. ");
INSERT INTO ces1613_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","A to budete míti za premování, na něžto hledíce, rozpomínati se budete na všecka přikázaní Hospodinova, abyste je činili, a nepustíte se po žádosti srdce svého, a po očích svých, jichžto následujíce, smilnili byste, ");
INSERT INTO ces1613_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ale abyste pamatovali a činili všecka přikázaní má, a byli svatí Bohu svému. ");
INSERT INTO ces1613_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Já jsem Hospodin Bůh váš, kterýž jsem vyvedl vás z země Egyptské, abych vám byl za Boha: Já Hospodin Bůh váš. ");
INSERT INTO ces1613_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Chóre pak syn Izarův, syna Kahat z pokolení Léví, vytrhl se z jiných, tolikéž Dátan a Abiron, synové Eliabovi, také Hon, syn Feletův, z synů Rubenových, ");
INSERT INTO ces1613_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","A povstali proti Mojžíšovi, i jiných mužů z synů Izraelských dvě stě a padesáte, knížata shromáždění, kteříž svoláváni byli do rady, muži slovoutní. ");
INSERT INTO ces1613_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","A sebravše se proti Mojžíšovi a proti Aronovi, řekli jim: Příliště to již na vás; všecko zajisté množství toto, všickni tito svatí jsou, a u prostřed nich jest Hospodin. Pročež se tedy vyzdvihujete nad shromážděním Hospodinovým? ");
INSERT INTO ces1613_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","To když uslyšel Mojžíš, padl na tvář svou, ");
INSERT INTO ces1613_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","A mluvil k Chóre a ke vší rotě jeho, řka: Ráno ukáže Hospodin, kdo jsou jeho, a kdo jest svatý, i kdo před něj předstupovati má; nebo kohožkoli vyvolil, tomu rozkáže přistoupiti k sobě. ");
INSERT INTO ces1613_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Toto učiňte: Vezměte sobě kadidlnice, ty Chóre i všecko shromáždění tvé, ");
INSERT INTO ces1613_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","A naklaďte do nich uhlí, a vložte na ně kadidla před Hospodinem zítra; i stane se, že kohožkoli vyvolí Hospodin, ten bude svatý. Příliště to již na vás, synové Léví. ");
INSERT INTO ces1613_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","I řekl Mojžíš k Chóre: Slyšte, prosím, synové Léví. ");
INSERT INTO ces1613_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Zdaliž málo vám to jest, že vás oddělil Bůh Izraelský ode všeho množství Izraelského, a rozkázal vám přistupovati k sobě, abyste vykonávali službu příbytku Hospodinova, a abyste stáli před shromážděním, a sloužili jim, ");
INSERT INTO ces1613_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","A vzal tě sobě, a všecky bratří tvé syny Léví s tebou, a že ještě přes to i kněžství hledáte? ");
INSERT INTO ces1613_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Protož věz, že ty a všickni tvoji jste ti, kteříž se rotíte proti Hospodinu; nebo Aron co jest, že jste reptali proti němu? ");
INSERT INTO ces1613_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Tedy poslal Mojžíš, aby zavolali Dátana a Abirona, synů Eliabových. Kteříž odpověděli: Nepůjdem. ");
INSERT INTO ces1613_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Cožť se ještě málo zdá, že jsi vyvedl nás z země oplývající mlékem a strdí, abys nás zmořil na poušti, že také chceš i panovati nad námi, a rozkazovati nám? ");
INSERT INTO ces1613_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","A ještě jsi nás neuvedl do země oplývající mlékem a strdí, aniž jsi nám dal v dědictví rolí a vinic. Zdali oči mužům těmto vyloupiti chceš? Nepůjdeme. ");
INSERT INTO ces1613_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","I rozhněval se Mojžíš velmi, a řekl k Hospodinu: Nepatřiž na oběti jejich. Ani jednoho osla od nich jsem nevzal, aniž jsem komu z nich co zlého učinil. ");
INSERT INTO ces1613_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Potom řekl Mojžíš k Chóre: Ty a všickni tvoji, postavte se zítra před Hospodinem, ty i oni, též i Aron. ");
INSERT INTO ces1613_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","A vezmouce jeden každý kadidlnici svou, dáte do nich kadidla, a postavíte se před Hospodinem, jeden každý s kadidlnicí svou; dvě stě a padesáte kadidlnic bude, ty také i Aron, každý s kadidlnicí svou. ");
INSERT INTO ces1613_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Tedy vzal jeden každý kadidlnici svou, a nabravše do nich uhlí, vložili na ně i kadidla, a stáli u dveří stánku úmluvy, i Mojžíši Aron. ");
INSERT INTO ces1613_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Chóre pak již byl sebral proti nim všecko množství ke dveřím stánku úmluvy; i ukázala se sláva Hospodinova všemu množství. ");
INSERT INTO ces1613_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","I mluvil Hospodin k Mojžíšovi a k Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Oddělte se z prostředku množství tohoto, ať je v okamžení zahladím. ");
INSERT INTO ces1613_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Kteřížto padše na tváři své, řekli: Bože silný, Bože duchů i všelikého těla, jediný tento člověk zhřešil, a což na všecko shromáždění hněvati se budeš? ");
INSERT INTO ces1613_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Tedy mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Mluv k množství a rci: Odstupte od příbytku Chóre, Dátana a Abirona. ");
INSERT INTO ces1613_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","A vstav Mojžíš, šel k Dátanovi a Abironovi; i šli za ním starší Izraelští. ");
INSERT INTO ces1613_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","A mluvil k množství, řka: Odstupte, prosím, od stanů bezbožných mužů těchto, aniž se čeho dotýkejte, což jejich jest, abyste nebyli zachváceni ve všech hříších jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","I odstoupili se všech stran od příbytku Chóre, Dátana a Abirona; ale Dátan a Abiron vyšedše, stáli u dveří stanů svých, i ženy jejich a synové jejich, i maličcí jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Tedy řekl Mojžíš: Po tomto poznáte, že Hospodin poslal mne, abych činil všecky skutky tyto, a že nic o své ujmě nečiním: ");
INSERT INTO ces1613_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Jestliže tak jako jiní lidé mrou, zemrou i tito, a navštívením obecným všechněm lidem jestliže navštíveni budou, neposlal mne Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Pakliť něco nového učiní Hospodin, a země, otevra ústa svá, požře je se vším, což mají, a sstoupí-li za živa do pekla, tedy poznáte, že jsou popouzeli muži ti Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","I stalo se, když přestal mluviti slov těch, že rozstoupila se země pod nimi. ");
INSERT INTO ces1613_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","A otevřevši země ústa svá, požřela je i domy jejich i všecky lidi, kteříž byli s Chóre, i všecken statek jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","A tak sstoupili oni se vším, což měli, za živa do pekla, a přikryla je země; i zahynuli z prostředku shromáždění. ");
INSERT INTO ces1613_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Všickni pak Izraelští, kteříž byli vůkol nich, utíkali, slyšíce křik jejich; nebo řekli: Utecme, aby i nás nesehltila země. ");
INSERT INTO ces1613_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Vyšel také oheň od Hospodina, a spálil těch dvě stě a padesáte mužů, kteříž kadili. ");
INSERT INTO ces1613_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Tedy mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Rci Eleazarovi, synu Arona kněze, ať sbéře kadidlnice z toho spáleniště, a uhlí z nich pryč rozmece, nebo posvěceny jsou, ");
INSERT INTO ces1613_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Kadidlnice totiž těch, kteříž proti svým dušem hřešili, a ať je rozkuje na plechy k obložení oltáře; nebo kadili jimi před Hospodinem, protož posvěceny jsou, a budou na znamení synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","I sebral Eleazar kněz kadidlnice měděné, jimiž kadili ti, kteříž spáleni jsou, a rozkovali je k obložení oltáře, ");
INSERT INTO ces1613_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Pro budoucí pamět synům Izraelským, aby nepřistupoval žádný jiný, kdož by nebyl z rodu Aronova, k kadění před Hospodinem, aby se mu nestalo jako Chóre a jako rotě jeho, jakož byl mluvil jemu Hospodin skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Nazejtří pak reptalo všecko množství synů Izraelských na Mojžíše a na Arona, řkouce: Vy jste příčinou smrti lidu Hospodinova. ");
INSERT INTO ces1613_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","I stalo se, když se opět sbíral lid proti Mojžíšovi a proti Aronovi, že se ohlédli k stánku úmluvy, a aj, přikryl jej oblak, a ukázala se sláva Hospodinova. ");
INSERT INTO ces1613_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Přišel také Mojžíš s Aronem před stánek úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Vyjděte z prostředku množství tohoto, a zahladím je v okamžení. I padli na tváři své. ");
INSERT INTO ces1613_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Tedy řekl Mojžíš Aronovi: Vezma kadidlnici, dej do ní uhlí z oltáře, a vlož kadidla, a běž rychle k množství a očisť je; nebo vyšla prchlivost od tváři Hospodinovy, a již rána se začala. ");
INSERT INTO ces1613_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","I vzav Aron kadidlnici, jakž rozkázal Mojžíš, běžel do prostřed shromáždění, (a aj, rána již se byla začala v lidu,) a zakadiv, očistil lid. ");
INSERT INTO ces1613_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","A stál mezi mrtvými a živými; i zastavena jest rána. ");
INSERT INTO ces1613_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Bylo pak těch, kteříž od té rány zemřeli, čtrnácte tisíců a sedm set, kromě těch, jenž zemřeli příčinou Chóre. ");
INSERT INTO ces1613_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","I navrátil se Aron k Mojžíšovi, ke dveřím stánku úmluvy, když ta rána přetržena byla. ");
INSERT INTO ces1613_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Tedy mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Mluv k synům Izraelským, a vezmi od nich po jednom prutu z každého domu otců, totiž ode všech knížat jejich, vedlé domů otců jich dvanácte prutů, a jednoho každého jméno napíšeš na prutu jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Jméno pak Aronovo napíšeš na prutu Léví; nebo jeden každý prut bude místo jednoho předního z domu otců jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","I necháš jich v stánku úmluvy před svědectvím, kdež přicházím k vám. ");
INSERT INTO ces1613_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","I stane se, že kohož vyvolím, toho prut zkvetne; a tak spokojím a svedu s sebe reptání synů Izraelských, kterýmž repcí na vás. ");
INSERT INTO ces1613_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ty věci když mluvil Mojžíš k synům Izraelským, dali jemu všecka jejich knížata pruty své, jedno každé kníže prut z domu otce svého, totiž prutů dvanácte, prut pak Aronův byl též mezi pruty jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","I zanechal Mojžíš prutů před Hospodinem v stánku svědectví. ");
INSERT INTO ces1613_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Nazejtří pak přišel Mojžíš do stánku svědectví, a aj, vyrostl prut Aronův z domu Léví, a vypustiv z sebe pupence, zkvetl a vydal mandly zralé. ");
INSERT INTO ces1613_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","I vynesl Mojžíš všecky ty pruty od tváři Hospodinovy ke všechněm synům Izraelským; a uzřevše je, vzali jeden každý prut svůj. ");
INSERT INTO ces1613_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Řekl pak Hospodin Mojžíšovi: Dones zase prut Aronův před svědectví, aby chován byl na znamení proti buřičům zpurným, a tak přítrž učiníš reptání jejich na mne, aby nezemřeli. ");
INSERT INTO ces1613_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","I učinil tak Mojžíš; jakž byl přikázal jemu Hospodin, tak učinil. ");
INSERT INTO ces1613_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Tedy mluvili synové Izraelští k Mojžíšovi, řkouce: Hle, již mřeme, mizíme a všickni my hyneme. ");
INSERT INTO ces1613_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Kdožkoli blízko přistoupá k příbytku Hospodinovu, umírá. Všickni-liž smrtí zhyneme? ");
INSERT INTO ces1613_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","A protož řekl Hospodin Aronovi: Ty a synové tvoji i dům otce tvého s tebou ponesete nepravost svatyně; ty také i synové tvoji s tebou ponesete nepravost kněžství svého. ");
INSERT INTO ces1613_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Bratří také své, pokolení Léví, čeled otce svého připoj k sobě, ať jsou při tobě a posluhují tobě; ty pak a synové tvoji s tebou před stánkem svědectví sloužiti budete. ");
INSERT INTO ces1613_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","A pilně ostříhati budou rozkázaní tvého, bedlivi jsouce při všem stánku; a však ať k nádobám svatyně a k oltáři nepřistupují, aby nezemřeli i oni i vy. ");
INSERT INTO ces1613_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","A přídržeti se budou tebe, pilně ostříhajíce stánku úmluvy při všech službách jeho; a cizí žádný nepřistupuj k vám. ");
INSERT INTO ces1613_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Protož pilně ostříhejte svatyně i služby oltáře, ať nepřichází více zůřivá prchlivost na syny Izraelské, ");
INSERT INTO ces1613_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Poněvadž jsem já vybral bratří vaše Levíty z synů Izraelských vám, za dar dané Hospodinu, aby konali službu při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ty pak a synové tvoji s tebou ostříhati budete kněžství svého při všech věcech přináležejících k oltáři, a kteréž jsou za oponou, a sloužiti budete. Úřad kněžství vašeho darem jsem vám dal, protož, přistoupil-li by kdo cizí, umře. ");
INSERT INTO ces1613_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mluvil také Hospodin k Aronovi: Aj, já dal jsem tobě k ostříhání oběti své, kteréž se vzhůru pozdvihují; všecko také, což se posvěcuje od synů Izraelských, tobě jsem dal pro pomazání i synům tvým ustanovením věčným. ");
INSERT INTO ces1613_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Toto bude tvé z věcí posvěcených, kteréž nepřicházejí na oheň: Všeliká obět jejich, buď suchá obět jejich, neb obět za hřích jejich, aneb obět za provinění jejich, kteréž mi dávati budou, svatosvaté tobě bude to i synům tvým. ");
INSERT INTO ces1613_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","V svatyni budeš je jísti, každý pohlaví mužského bude je jísti; svaté bude tobě. ");
INSERT INTO ces1613_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Tvá tedy bude obět darů jejich, kteráž vzhůru pozdvižena bývá; každou také obět synů Izraelských, kteráž sem i tam obracína bývá, tobě jsem dal a synům tvým, i dcerám tvým s tebou ustanovením věčným. Každý, kdož jest čistý v domě tvém, bude je jísti. ");
INSERT INTO ces1613_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Všecko, což předního jest z oleje, a což nejlepšího jest vína a obilé, prvotiny těch věcí, kteréž dají Hospodinu, dal jsem tobě. ");
INSERT INTO ces1613_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Prvotiny všech věcí, kteréž rostly v zemi jejich, ty přinesou Hospodinu, a tvé budou. Každý, kdož jest čistý v domě tvém, jísti je bude. ");
INSERT INTO ces1613_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Všecko oddané Bohu v Izraeli tvé bude. ");
INSERT INTO ces1613_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Cožkoli otvírá život všelikého těla, kteréž obětováno bývá Hospodinu, tak z lidí jako z hovad, tvé bude; prvorozené však z lidí, vyplaceno bude, prvorozené také z nečistých hovad vyplatiti kážeš. ");
INSERT INTO ces1613_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Výplata pak jeho, když mu již jeden měsíc bude, vedlé ceny tvé bude pěti loty stříbra podlé lotu svatyně; dvadceti peněz váží lot. ");
INSERT INTO ces1613_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ale prvorozeného z volů, neb z ovcí, neb z koz, nedáš vyplatiti; nebo posvěceny jsou. Krev jejich vykropíš na oltář, a tuk jejich zapálíš, aby byl obětí ohnivou vůně spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Maso pak jejich tvé bude; jako hrudí z oběti sem i tam obracení, a jako plece pravé tvé bude. ");
INSERT INTO ces1613_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Každou obět vzhůru pozdvižení z věcí posvěcených, kteréž přinášejí synové Izraelští Hospodinu, dal jsem tobě, a synům tvým, i dcerám tvým s tebou ustanovením věčným, smlouvou trvánlivou a věčnou před Hospodinem, tobě i semeni tvému s tebou. ");
INSERT INTO ces1613_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mluvil také Hospodin k Aronovi: V zemi jejich, dědictví ani dílu svého mezi nimi nebudeš míti; já jsem díl tvůj, a dědictví tvé u prostřed synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Synům pak Léví, aj, dal jsem všecky desátky v Izraeli za dědictví, za službu jejich, kterouž vykonávají, sloužíce při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","A synové Izraelští nechať nepřistupují k stánku úmluvy, aby nenesli hříchu a nezemřeli. ");
INSERT INTO ces1613_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ale sami Levítové konati budou službu při stánku úmluvy, a sami ponesou nepravost svou. Ustanovení věčné v pronárodech vašich to bude, aby dědictví nemívali mezi syny Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Nebo desátky synů Izraelských, kteréž přinášeti budou Hospodinu v obět vzhůru pozdvižení, dal jsem Levítům za dědictví; protož jsem o nich řekl: U prostřed synů Izraelských nebudou míti dědictví. ");
INSERT INTO ces1613_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Mluv k Levítům a rci jim: Když vezmete desátky od synů Izraelských, kteréž jsem vám dal od nich za dědictví vaše, tedy přinesete z nich obět vzhůru pozdvižení Hospodinu, desátky z desátků. ");
INSERT INTO ces1613_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","A počtena vám bude ta obět vaše jako obilí z humna, a jako víno od presu. ");
INSERT INTO ces1613_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Tak vy také přinesete obět vzhůru pozdvižení Hospodinu ze všech desátků svých, kteréž vezmete od synů Izraelských, a dáte z nich obět Hospodinovu Aronovi knězi. ");
INSERT INTO ces1613_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ze všech darů svých přinesete každou obět vzhůru pozdvižení Hospodinu, díl posvěcený všeho, což nejlepšího jest. ");
INSERT INTO ces1613_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Díš jim také: Když obětovati budete z toho, což nejlepšího jest, počteno bude Levítům jako úrody z humna, a jako úrody od presu. ");
INSERT INTO ces1613_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Jísti pak budete ty desátky na všelikém místě vy i čeled vaše; nebo mzda vaše jest za službu vaši při stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","A neponesete pro to hříchu, když obětovati budete to, což nejlepšího jest; a tak nepoškvrníte věcí posvěcených od synů Izraelských, a nezemřete. ");
INSERT INTO ces1613_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","I mluvil Hospodin k Mojžíšovi a k Aronovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Toto jest ustanovení zákona, kteréž přikázal Hospodin, řka: Mluv k synům Izraelským, ať vezmouce, přivedou k tobě jalovici červenou bez vady, na níž by nebylo poškvrny, a na kterouž by ještě jho nebylo kladeno. ");
INSERT INTO ces1613_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","A dáte ji Eleazarovi knězi, kterýž vyvede ji ven z stanů, a rozkáže ji zabiti před sebou. ");
INSERT INTO ces1613_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","A vezma Eleazar kněz krve její na prst svůj, kropiti bude jí naproti stánku úmluvy sedmkrát. ");
INSERT INTO ces1613_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Potom káže tu jalovici spáliti před očima svýma; kůži její, i maso její, i krev její s lejny jejími dá spáliti. ");
INSERT INTO ces1613_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","A vezma kněz dřeva cedrového, yzopu a červce dvakrát barveného, uvrže to vše do ohně, v kterémž ta jalovice hoří. ");
INSERT INTO ces1613_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","I zpéře kněz roucha svá, a tělo své umyje vodou; potom vejde do stanů, a bude nečistý až do večera. ");
INSERT INTO ces1613_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Takž také i ten, kterýž ji pálil, zpéře roucha svá u vodě, a tělo své obmyje vodou, a nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Popel pak té jalovice spálené smete muž čistý, a vysype jej vně za stany na místě čistém, aby byl všechněm synům Izraelským chován k vodě očištění, kteráž bude k očištění za hřích. ");
INSERT INTO ces1613_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","A ten, kdož by smetl popel té jalovice, zpéře roucha svá a nečistý bude až do večera. A budou to míti synové Izraelští i příchozí, kterýž jest pohostinu u prostřed nich, za ustanovení věčné. ");
INSERT INTO ces1613_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Kdo by se dotkl těla kteréhokoli mrtvého člověka, nečistý bude za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Takový očišťovati se bude tou vodou dne třetího a dne sedmého, i bude čistý; neočistí-li se pak dne třetího a dne sedmého, nebudeť čistý. ");
INSERT INTO ces1613_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Kdo by koli, dotkna se těla mrtvého člověka, kterýž umřel, neočistil se, příbytku Hospodinova poškvrnil. Protož vyhlazena bude duše ta z Izraele, nebo vodou očišťování není pokropen; nečistýť bude, a nečistota jeho zůstává na něm. ");
INSERT INTO ces1613_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Tento jest také zákon, kdyby člověk umřel v stanu: Kdo by koli všel do toho stanu, a kdo by koli byl v stanu, nečistý bude za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tolikéž všeliká nádoba odkrytá, kteráž by neměla svrchu přikryvadla na sobě, nečistá bude. ");
INSERT INTO ces1613_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Tak kdož by se koli dotkl na poli buď mečem zabitého, aneb mrtvého, buďto kosti člověka, aneb hrobu, nečistý bude za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","A vezmou pro nečistého popela z spálené za hřích, a nalejí na něj vody živé do nádoby. ");
INSERT INTO ces1613_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Potom vezme člověk čistý yzopu, a omočí jej v té vodě, a pokropí stanu, i všeho nádobí i lidí, kteříž by tu byli, tolikéž toho, kterýž dotkl se kosti, aneb zabitého, aneb mrtvého, aneb hrobu. ");
INSERT INTO ces1613_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Pokropí tedy čistý nečistého v den třetí a v den sedmý; a když jej očistí dne sedmého, zpéře šaty své, a umyje se vodou, a čistý bude u večer. ");
INSERT INTO ces1613_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Jestliže by pak kdo nečistý jsa, neočistil se, vyhlazena bude duše ta z prostředku shromáždění; nebo svatyně Hospodinovy poškvrnil, vodou očišťování nejsa pokropen; nečistý jest. ");
INSERT INTO ces1613_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","I bude jim to za ustanovení věčné. Kdož by pak tou vodou očišťování kropil, zpéře roucha svá, a kdož by se dotkl vody očišťování, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Èehokoli dotkl by se nečistý, nečisté bude; člověk také, kterýž by se dotkl toho, nečistý bude až do večera. ");
INSERT INTO ces1613_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","I přitáhlo všecko množství synů Izraelských na poušť Tsin, měsíce prvního; i pozůstal lid v Kádes, kdež umřela Maria, a tu jest pochována. ");
INSERT INTO ces1613_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","A když množství to nemělo vody, sešli se proti Mojžíšovi, a proti Aronovi. ");
INSERT INTO ces1613_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","I domlouval se lid na Mojžíše, a mluvili, řkouce: Ó kdybychom i my byli zemřeli, když zemřeli bratří naši před Hospodinem! ");
INSERT INTO ces1613_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Proč jste jen uvedli shromáždění Hospodinovo na poušť tuto, abychom zde pomřeli i my i dobytek náš? ");
INSERT INTO ces1613_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","A proč jste nás vyvedli z Egypta, abyste uvedli nás na toto zlé místo, na němž se nerodí ani obilí, ani fíků, ani hroznů, ani jablek zrnatých, na kterémž ani vody ku pití není? ");
INSERT INTO ces1613_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tedy odšel Mojžíš s Aronem od tváři shromáždění ke dveřím stánku úmluvy, a padli na tváři své; i ukázala se sláva Hospodinova nad nimi. ");
INSERT INTO ces1613_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","A mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Vezmi hůl, a shromáždíce všecko množství, ty i Aron bratr tvůj, mluvte k skále této před očima jejich, a vydá vodu svou. I vyvedeš jim vodu z skály, a dáš nápoj všemu množství i dobytku jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Tedy vzal Mojžíš hůl před tváří Hospodinovou, jakž rozkázal jemu. ");
INSERT INTO ces1613_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","I svolali Mojžíš s Aronem všecko množství před skálu, a řekl jim: Slyštež nyní, ó reptáci: Zdali z skály této vyvedeme vám vodu? ");
INSERT INTO ces1613_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","I pozdvihl Mojžíš ruky své, a udeřil v skálu holí svou po dvakrát; i vyšly vody hojné, a pilo všecko množství i dobytek jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Potom řekl Hospodin Mojžíšovi a Aronovi: Že jste mi nevěřili, abyste posvětili mne před očima synů Izraelských, proto neuvedete shromáždění tohoto do země, kterouž jsem jim dal. ");
INSERT INTO ces1613_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Toť jsou ty vody sváru, o kteréž svařili se synové Izraelští s Hospodinem, a posvěcen jest v nich. ");
INSERT INTO ces1613_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","I poslal Mojžíš posly z Kádes k králi Edom, aby řekli: Totoť vzkazuje bratr tvůj Izrael: Ty víš o všech těžkostech, kteréž přišly na nás, ");
INSERT INTO ces1613_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Že sstoupili otcové naši do Egypta, a bydlili jsme tam za mnoho let. Egyptští pak ssužovali nás i otce naše. ");
INSERT INTO ces1613_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","A volali jsme k Hospodinu, kterýž uslyšel hlas náš, a poslav anděla, vyvedl nás z Egypta, a aj, již jsme v Kádes městě, při pomezí tvém. ");
INSERT INTO ces1613_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Nechť, prosím, projdeme skrze zemi tvou. Nepůjdeme přes rolí, ani přes vinice, aniž píti budeme vody z čí studnice; cestou královskou půjdeme a neuchýlíme se na pravo ani na levo, dokavadž nepřejdeme mezí tvých. ");
INSERT INTO ces1613_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Jemužto odpověděl Edom: Nechoď skrze mou zemi, abych s mečem nevyšel v cestu tobě. ");
INSERT INTO ces1613_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","I řekli mu synové Izraelští: Obecnou silnicí půjdeme, a jestliže vody tvé napili bychom se, buď my neb dobytek náš, zaplatíme ji; nic jiného nežádáme, toliko pěší abychom prošli. ");
INSERT INTO ces1613_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Odpověděl: Neprojdeš. A vytáhl proti nim Edom s množstvím lidu a s silou velikou. ");
INSERT INTO ces1613_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Když tedy nedopustil Edom Izraelovi, aby přešel meze jeho, uchýlil se Izrael od něho. ");
INSERT INTO ces1613_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","A hnuvše se synové Izraelští i všecko množství jejich z Kádes, přišli na horu řečenou Hor. ");
INSERT INTO ces1613_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","I mluvil Hospodin k Mojžíšovi a Aronovi na hoře Hor, při pomezí země Edom, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Připojen bude Aron k lidu svému; nebo nevejde do země, kterouž jsem dal synům Izraelským, proto že jste odporni byli řeči mé při vodách sváru. ");
INSERT INTO ces1613_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Pojmi Arona a Eleazara syna jeho, a uvedeš je na horu Hor. ");
INSERT INTO ces1613_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","A svlečeš Arona z roucha jeho, a oblečeš v ně Eleazara syna jeho; nebo Aron připojen bude k lidu svému, a tam umře. ");
INSERT INTO ces1613_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","I učinil Mojžíš, jakž rozkázal Hospodin, a vstoupili na horu Hor před očima všeho množství. ");
INSERT INTO ces1613_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","A svlékl Mojžíš Arona z roucha jeho, a oblékl v ně Eleazara syna jeho. I umřel tam Aron na pahrbku hory, Mojžíš pak a Eleazar sstoupili s hory. ");
INSERT INTO ces1613_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Vidouce pak všecko množství, že umřel Aron, plakali ho za třidceti dní všecken dům Izraelský. ");
INSERT INTO ces1613_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","To když uslyšel Kananejský král v Arad, kterýž bydlil na poledne, že by táhl Izrael tou cestou, kterouž byli špehéři šli, bojoval s ním, a zajal jich množství. ");
INSERT INTO ces1613_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Tedy Izrael učinil slib Hospodinu, řka: Jestliže dáš lid tento v ruce mé, do gruntu zkazím města jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","I uslyšel Hospodin hlas Izraele a dal mu Kananejské, kterýžto do gruntu zkazil je i města jejich, a nazval jméno toho místa Horma. ");
INSERT INTO ces1613_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Potom hnuli se s hory Hor cestou k moři Rudému, aby obešli zemi Idumejskou; i ustával lid velice na cestě. ");
INSERT INTO ces1613_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","A mluvil lid proti Bohu a proti Mojžíšovi: Proč jste vyvedli nás z Egypta, abychom zemřeli na poušti? Nebo ani chleba ani vody není, a duše naše chléb tento ničemný sobě již zošklivila. ");
INSERT INTO ces1613_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Protož dopustil Hospodin na lid hady ohnivé, kteříž jej štípali, tak že množství lidu zemřelo z Izraele. ");
INSERT INTO ces1613_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Tedy přišel lid k Mojžíšovi a řekli: Zhřešili jsme nebo jsme mluvili proti Hospodinu a proti tobě; modl se Hospodinu, ať odejme od nás ty hady. I modlil se Mojžíš za lid. ");
INSERT INTO ces1613_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","I řekl Hospodin Mojžíšovi: Udělej sobě hada podobného těm ohnivým, a vyzdvihni jej na sochu; a každý ušťknutý, když pohledí na něj, živ bude. ");
INSERT INTO ces1613_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","I udělal Mojžíš hada měděného, a vyzdvihl jej na sochu; a stalo se, když ušťkl had někoho, a on vzhlédl na hada měděného, že zůstal živ. ");
INSERT INTO ces1613_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Tedy hnuli se odtud synové Izraelští, a položili se v Obot. ");
INSERT INTO ces1613_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Potom pak hnuvše se z Obot, položili se při pahrbcích hor Abarim na poušti, kteráž jest naproti zemi Moábské k východu slunce. ");
INSERT INTO ces1613_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Odtud brali se, a položili se v údolí Záred. ");
INSERT INTO ces1613_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Opět hnuvše se odtud, položili se u brodu potoka Arnon, kterýž jest na poušti, a vychází z končin Amorejských. Nebo Arnon jest pomezí Moábské mezi Moábskými a Amorejskými. ");
INSERT INTO ces1613_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Protož praví se v knize bojů Hospodinových, že proti Vahebovi u vichřici bojoval, a proti potokům Arnon. ");
INSERT INTO ces1613_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Nebo tok těch potoků, kterýž se nachyluje ku položení Ar, ten jde vedlé pomezí Moábského. ");
INSERT INTO ces1613_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","A odtud táhli do Beer; a to jest to Beer, o němž byl řekl Hospodin k Mojžíšovi: Shromažď lid, a dám jim vodu. ");
INSERT INTO ces1613_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tedy zpíval lid Izraelský písničku tuto: Vystupiž studnice, prozpěvujte o ní; ");
INSERT INTO ces1613_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Studnice, kterouž kopala knížata, kterouž vykopali přední z lidu s vydavatelem zákona holemi svými. Z pouště pak brali se do Matana, ");
INSERT INTO ces1613_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","A z Matana do Nahaliel, z Nahaliel do Bamot, ");
INSERT INTO ces1613_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","A z Bamot do údolí, kteréž jest na poli Moábském, až k vrchu hory, kteráž leží na proti poušti. ");
INSERT INTO ces1613_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Tedy poslal lid Izraelský posly k Seonovi králi Amorejskému, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Nechť jdeme skrze zemi tvou. Neuchýlíme se ani do pole, ani do vinic, ani z studnic vody píti nebudeme, ale cestou královskou půjdeme, dokavadž nepřejdeme pomezí tvého. ");
INSERT INTO ces1613_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","I nedopustil Seon jíti lidu Izraelskému skrze krajinu svou, nýbrž sebrav Seon všecken lid svůj, vytáhl proti lidu Izraelskému na poušť, a přitáh do Jasa, bojoval proti Izraelovi. ");
INSERT INTO ces1613_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","I porazil jej lid Izraelský mečem, a vzal v dědictví zemi jeho, od Arnon až do Jabok, a až do země synů Ammon; nebo pevné bylo pomezí Ammonitských. ");
INSERT INTO ces1613_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Tedy vzal Izrael všecka ta města, a přebýval ve všech městech Amorejských, v Ezebon a ve všech městečkách jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Nebo Ezebon bylo město Seona krále Amorejského, kterýž když bojoval proti králi Moábskému prvnímu, vzal mu všecku zemi jeho z rukou jeho až do Arnon. ");
INSERT INTO ces1613_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Protož říkávali v přísloví: Poďte do Ezebon, aby vystaveno bylo a vzděláno město Seonovo. ");
INSERT INTO ces1613_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Nebo oheň vyšel z Ezebon, a plamen z města Seon, i spálil Ar Moábských a obyvatele výsosti Arnon. ");
INSERT INTO ces1613_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Běda tobě Moáb, zahynuls lide Chámos; dal syny své v utíkání, a dcery své v zajetí králi Amorejskému Seonovi. ");
INSERT INTO ces1613_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","A království jejich zahynulo od Ezebon až do Dibon, a vyhladili jsme je až do Nofe, kteréž jest až k Medaba. ");
INSERT INTO ces1613_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","A tak bydlil Izrael v zemi Amorejské. ");
INSERT INTO ces1613_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Potom poslal Mojžíš, aby shlédli Jazer, kteréž vzali i s městečky jeho; a tak vyhnal Amorejské, kteříž tam bydlili. ");
INSERT INTO ces1613_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Obrátivše se pak, táhli cestou k Bázan. I vytáhl Og, král Bázan, proti nim, on i všecken lid jeho, aby bojoval v Edrei. ");
INSERT INTO ces1613_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Tedy řekl Hospodin Mojžíšovi: Neboj se ho; nebo v ruce tvé dal jsem jej, i všecken lid jeho, i zemi jeho, a učiníš jemu tak, jakož jsi učinil Seonovi, králi Amorejskému, kterýž bydlil v Ezebon. ");
INSERT INTO ces1613_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","I porazili jej i syny jeho, i všecken lid jeho, tak že žádný živý po něm nezůstal, a uvázali se dědičně v zemi jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","I táhli synové Izraelští a položili se na polích Moábských, nedocházeje k Jordánu, naproti Jerichu. ");
INSERT INTO ces1613_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","A viděl Balák, syn Seforův, všecko, co učinil Izrael Amorejskému. ");
INSERT INTO ces1613_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","I bál se Moáb toho lidu velmi, proto že ho bylo mnoho, a svíral se pro přítomnost synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Protož řekl Moáb k starším Madianským: Tudíž toto množství požere všecko, což jest vůkol nás, jako sžírá vůl trávu polní. Byl pak Balák, syn Seforův, toho času králem Moábským. ");
INSERT INTO ces1613_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","I poslal posly k Balámovi, synu Beorovu, do města Petor, kteréž jest při řece v zemi vlasti jeho, aby povolal ho, řka: Aj, lid vyšel z Egypta, aj, přikryl svrchek země, a usazuje se proti mně. ");
INSERT INTO ces1613_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Protož nyní poď medle, zlořeč mně k vůli lidu tomuto, nebo silnější mne jest; snad svítězím nad ním, a porazím jej, aneb vyženu z země této. Vím zajisté, že komuž ty žehnáš, požehnaný bude, a komuž ty zlořečíš, bude zlořečený. ");
INSERT INTO ces1613_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Tedy šli starší Moábští a starší Madianští, nesouce v rukou svých peníze za zlořečení; i přišli k Balámovi, a vypravovali mu slova Balákova. ");
INSERT INTO ces1613_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","On pak řekl jim: Pobuďte zde přes tuto noc, a dám vám odpověd, jakž mi mluviti bude Hospodin. I zůstala knížata Moábská s Balámem. ");
INSERT INTO ces1613_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Přišel pak Bůh k Balámovi a řekl: Kdo jsou ti muži u tebe? ");
INSERT INTO ces1613_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Odpověděl Balám Bohu: Balák, syn Seforův, král Moábský, poslal ke mně, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Aj, lid ten, kterýž vyšel z Egypta, přikryl svrchek země; protož nyní poď, proklň mi jej, snad svítězím, bojuje s ním, a vyženu jej. ");
INSERT INTO ces1613_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","I řekl Bůh k Balámovi: Nechoď s nimi, aniž zlořeč lidu tomu, nebo požehnaný jest. ");
INSERT INTO ces1613_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Tedy Balám vstav ráno, řekl knížatům Balákovým: Navraťte se do země své, nebo nechce mi dopustiti Hospodin, abych šel s vámi. ");
INSERT INTO ces1613_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","A vstavše knížata Moábská, přišli k Balákovi a řekli: Nechtěl Balám jíti s námi. ");
INSERT INTO ces1613_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tedy opět poslal Balák více knížat a znamenitějších, nežli první. ");
INSERT INTO ces1613_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Kteříž přišedše k Balámovi, řekli jemu: Toto praví Balák, syn Seforův: Nezpěčuj se, prosím, přijíti ke mně. ");
INSERT INTO ces1613_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nebo velikou ctí tě ctíti chci, a což mi koli rozkážeš, učiním; protož přiď, prosím, proklň mi lid tento. ");
INSERT INTO ces1613_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Odpovídaje pak Balám, řekl služebníkům Balákovým: Byť mi pak dal Balák plný dům svůj stříbra a zlata, nemohl bych přestoupiti slova Hospodina Boha svého, a učiniti proti němu malé neb veliké věci. ");
INSERT INTO ces1613_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nyní však zůstaňte, prosím, zde i vy také této noci, abych zvěděl, co dále mluviti bude Hospodin se mnou. ");
INSERT INTO ces1613_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Přišed pak Bůh k Balámovi v noci, řekl jemu: Poněvadž proto, aby povolali tě, přišli muži tito, vstana, jdi s nimi, a však což přikáži tobě, to čiň. ");
INSERT INTO ces1613_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Tedy Balám vstav ráno, osedlal oslici svou, a bral se s knížaty Moábskými. ");
INSERT INTO ces1613_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ale rozpálil se hněv Boží, proto že jel s nimi, a postavil se anděl Hospodinův na cestě, aby mu překazil; on pak seděl na oslici své, maje s sebou dva služebníky své. ");
INSERT INTO ces1613_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","A když uzřela oslice anděla Hospodinova, an stojí na cestě, a meč jeho vytržený v ruce jeho, uhnula se s cesty, a šla polem. I bil ji Balám, aby ji navedl zase na cestu. ");
INSERT INTO ces1613_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","A anděl Hospodinův stál na stezce u vinice mezi dvěma zídkami. ");
INSERT INTO ces1613_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Viduci pak oslice anděla Hospodinova, přitiskla se ke zdi, přitřela také nohu Balámovi ke zdi; pročež opět bil ji. ");
INSERT INTO ces1613_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Potom anděl Hospodinův šel dále, a stál v úzkém místě, kdež nebylo žádné cesty k uchýlení se na pravo neb na levo. ");
INSERT INTO ces1613_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","A viduci oslice anděla Hospodinova, padla pod Balámem; pročež rozhněval se velmi Balám, a bil oslici kyjem. ");
INSERT INTO ces1613_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","I otevřel Hospodin ústa oslice, a řekla Balámovi: Cožť jsem učinila, že již po třetí mne biješ? ");
INSERT INTO ces1613_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Řekl Balám k oslici: To, že jsi mne v posměch uvedla. Ó bych měl meč v rukou, jistě bych tě již zabil. ");
INSERT INTO ces1613_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Odpověděla oslice Balámovi: Zdaliž nejsem oslice tvá? Jezdíval jsi na mně, jak jsi mne dostal, až do dnes; zdaliž jsem kdy obyčej měla tak činiti tobě? Kterýž odpověděl: Nikdy. ");
INSERT INTO ces1613_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","V tom otevřel Hospodin oči Balámovy, i uzřel anděla Hospodinova, an stojí na cestě, maje meč dobytý v ruce své; a nakloniv hlavy, poklonu učinil na tvář svou. ");
INSERT INTO ces1613_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","I mluvil k němu anděl Hospodinův: Proč jsi bil oslici svou po třikrát? Aj, já vyšel jsem, abych se protivil tobě; nebo uchýlil jsi se s cesty přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Když viděla mne oslice, vyhnula mi již po třikrát; a byť mi se byla nevyhnula, již bych byl také tebe zabil, a jí živé nechal. ");
INSERT INTO ces1613_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Odpověděl Balám andělu Hospodinovu: Zhřešilť jsem, nebo jsem nevěděl, že ty stojíš proti mně na cestě; protož nyní, jestliže se nelíbí tobě, raději navrátím se domů. ");
INSERT INTO ces1613_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Řekl anděl Hospodinův k Balámovi: Jdi s muži těmi, avšak slovo, kteréž mluviti budu tobě, to mluviti budeš. Tedy šel Balám s knížaty Balákovými. ");
INSERT INTO ces1613_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Uslyšev pak Balák o příchodu Balámovu, vyšel proti němu do města Moábského, kteréž bylo při řece Arnon, jenž jest při konci pomezí. ");
INSERT INTO ces1613_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","I řekl Balák Balámovi: Zdaliž jsem víc než jednou neposílal pro tě? Pročež jsi tedy nepřišel ke mně? Proto-li, že bych tě náležitě uctiti nemohl? ");
INSERT INTO ces1613_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Odpověděl Balám Balákovi: Aj, již jsem přišel k tobě; nyní pak zdaliž všelijak budu co moci mluviti? Slovo, kteréž vložil Bůh v ústa má, to mluviti budu. ");
INSERT INTO ces1613_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","I bral se Balám s Balákem, a přijeli do města Husot. ");
INSERT INTO ces1613_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Kdežto nabiv Balák volů a ovec, poslal k Balámovi a k knížatům, kteříž s ním byli. ");
INSERT INTO ces1613_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nazejtří pak ráno, pojav Balák Baláma, uvedl ho na výsosti modly Bál, odkudž shlédl i nejdalší díl lidu Izraelského. ");
INSERT INTO ces1613_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","A řekl Balám Balákovi: Udělej mi tuto sedm oltářů, a připrav mi také sedm volků a sedm skopců. ");
INSERT INTO ces1613_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","I udělal Balák, jakž mluvil Balám. Tedy obětoval Balák a Balám volka a na každém oltáři. ");
INSERT INTO ces1613_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Řekl pak Balám Balákovi: Postůj při oběti své zápalné, a půjdu, zdali by se potkal se mnou Hospodin, a což by koli mně ukázal, povím tobě. I odšel sám. ");
INSERT INTO ces1613_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","I potkal se Bůh s Balámem, a řekl jemu Balám: Sedm oltářů zpořádal jsem, a obětoval jsem volka a skopce na každém oltáři. ");
INSERT INTO ces1613_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Vložil pak Hospodin slovo v ústa Balámova a řekl: Navrať se k Balákovi a tak mluv. ");
INSERT INTO ces1613_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","I navrátil se k němu, a nalezl jej, an stojí při oběti své zápalné, i všecka knížata Moábská. ");
INSERT INTO ces1613_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Tedy vzav před sebe přísloví své, řekl: Z Aram přivedl mne Balák král Moábský, z hor východních, řka: Poď, zlořeč mi k vůli Jákoba, a poď, vydej klatbu na Izraele. ");
INSERT INTO ces1613_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Proč bych zlořečil, komuž Bůh silný nezlořečí? A proč bych klel, kohož Hospodin neproklíná? ");
INSERT INTO ces1613_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Když s vrchu skal hledím na něj, a s pahrbků spatřuji jej, aj, lid ten sám bydlí, a k jiným národům se nepřiměšuje. ");
INSERT INTO ces1613_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Kdo sečte prach Jákobův? a kdo počet? Kdo sečte čtvrtý díl Izraelského lidu? Ó bych já umřel smrtí spravedlivých, a dokonání mé ó by bylo jako i jeho! ");
INSERT INTO ces1613_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","I řekl Balák Balámovi: Což mi to děláš? Abys zlořečil nepřátelům mým, povolal jsem tě, a ty pak ustavičně dobrořečíš jim. ");
INSERT INTO ces1613_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Kterýž odpovídaje, řekl: Zdali toho, což Hospodin vložil v ústa má, nemám šetřiti, abych tak mluvil? ");
INSERT INTO ces1613_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","I řekl jemu Balák: Poď, prosím, se mnou na jiné místo, odkudž bys viděl jej, (toliko zadní díl jeho viděti budeš, a všeho nebudeš viděti), a proklň mi jej odtud. ");
INSERT INTO ces1613_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","I pojav jej, vyvedl ho na rovinu Zofim, na vrch jednoho pahrbku, a udělav sedm oltářů, obětoval volka a skopce na každém oltáři. ");
INSERT INTO ces1613_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Řekl pak Balákovi: Postůj tuto při zápalné oběti své, a já půjdu tamto vstříc Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","I potkal se Hospodin s Balámem, a vloživ slovo v ústa jeho, řekl: Navrať se k Balákovi a mluv tak. ");
INSERT INTO ces1613_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Přišel tedy k němu, a hle, on stál při zápalné oběti své, a knížata Moábská s ním. Jemužto řekl Balák: Co mluvil Hospodin? ");
INSERT INTO ces1613_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","A on vzav přísloví své, řekl: Povstaň Baláku a slyš, pozoruj mne, synu Seforův. ");
INSERT INTO ces1613_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Bůh silný není jako člověk, aby klamal, a jako syn člověka, aby se měnil. Což by řekl, zdaliž neučiní? Což by promluvil, zdali neutvrdí toho? ");
INSERT INTO ces1613_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Hle, abych dobrořečil, přijal jsem to na sebe; nebo dobrořečilť jest, a já toho neodvolám. ");
INSERT INTO ces1613_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Nepatříť na nepravosti v Jákobovi, aniž hledí na přestoupení v Izraeli; Hospodin Bůh jeho jestiť s ním, a zvuk krále vítězícího v něm. ");
INSERT INTO ces1613_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Bůh silný vyvedl je z Egypta, jako silou jednorožcovou byv jim. ");
INSERT INTO ces1613_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Nebo není kouzlů proti Jákobovi, ani zaklínání proti Izraelovi; již od toho času vypravováno bude o Jákobovi a Izraelovi, co učinil s ním Bůh silný. ");
INSERT INTO ces1613_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Aj, lid jakožto silný lev povstane, a jakožto lvíče vzchopí se; nepoloží se, dokudž by nejedl loupeže, a dokudž by nevypil krve zbitých. ");
INSERT INTO ces1613_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","I řekl Balák Balámovi: Aniž mu již zlořeč více, ani dobrořeč. ");
INSERT INTO ces1613_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Jemuž odpověděl Balám, řka: Zdaližť jsem nepravil, že, což by mi koli mluvil Hospodin, to učiním? ");
INSERT INTO ces1613_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","I řekl Balák Balámovi: Poď, prosím, povedu tě na jiné místo, odkudž snad líbiti se bude Bohu, abys mi je proklel. ");
INSERT INTO ces1613_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","A pojav Balák Baláma, uvedl jej na vrch hory Fegor, kteráž leží naproti poušti. ");
INSERT INTO ces1613_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Tedy řekl Balám Balákovi: Udělej mi tuto sedm oltářů, a připrav mi také sedm volků a sedm skopců. ");
INSERT INTO ces1613_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","I učinil Balák, jakž řekl Balám, a obětoval volka a skopce na každém oltáři. ");
INSERT INTO ces1613_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Vida pak Balám, že by se líbilo Hospodinu, aby dobrořečil Izraelovi, již více nešel jako prvé, jednou i po druhé, k čárům svým, ale obrátil tvář svou proti poušti. ");
INSERT INTO ces1613_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","A pozdvih očí svých, viděl Izraele bydlícího v staních po svých pokoleních, a byl nad ním duch Boží. ");
INSERT INTO ces1613_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","I vzav podobenství své, dí: Řekl Balám, syn Beorův, řekl muž mající otevřené oči, ");
INSERT INTO ces1613_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Řekl slyšící výmluvnosti Boha silného, kterýž vidění všemohoucího vidí, kterýž když padne, otevřené má oči: ");
INSERT INTO ces1613_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Jak velmi krásní jsou stánkové tvoji, Jákobe, příbytkové tvoji, Izraeli! ");
INSERT INTO ces1613_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Tak jako se potokové rozšiřují, jako zahrady vedlé řeky, jako stromoví aloes, kteréž štípil Hospodin, jako cedrové podlé vod. ");
INSERT INTO ces1613_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Poteče voda z okovu jeho, a símě jeho u vodách mnohých. A král jeho vyvýšen bude více než Agag, a vyzdvihne se království jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Bůh silný vyvedl jej z Egypta, jako udatnost jednorožcova jest jemu; sžereť národy protivné sobě, a kosti jich potře a střelami svými prostřílí. ");
INSERT INTO ces1613_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Složil se a ležel jako lvíče, a jako lev zůřivý; kdo jej zbudí? Kdo by požehnání dával tobě, požehnaný bude, a kdožť by zlořečil, bude zlořečený. ");
INSERT INTO ces1613_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tedy zapáliv se hněvem Balák proti Balámovi, tleskl rukama svýma a řekl Balámovi: Abys zlořečil nepřátelům mým, povolal jsem tebe, a aj, ustavičně dobrořečil jsi jim již po třikrát. ");
INSERT INTO ces1613_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Protož nyní navrať se raději k místu svému. Bylť jsem řekl: Velikou ctí tě ctíti chci, a hle, Hospodin zbavil tě cti. ");
INSERT INTO ces1613_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Jemuž odpověděl Balám: Však hned poslům tvým, kteréž jsi poslal ke mně, mluvil jsem, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Byť mi dal Balák plný dům svůj stříbra a zlata, nebudu moci přestoupiti řeči Hospodinovy, abych činil dobré neb zlé sám od sebe; což mi Hospodin oznámí, to mluviti budu, ");
INSERT INTO ces1613_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","(Ale však ještě já, již odcházeje k lidu svému, počkej, poradím tobě,) co učiní lid ten lidu tvému v posledních dnech. ");
INSERT INTO ces1613_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Tedy vzav podobenství své, dí: Řekl Balám, syn Beorův, řekl muž mající oči otevřené, ");
INSERT INTO ces1613_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Řekl slyšící výmluvnosti Boha silného, kterýž zná naučení nejvyššího, a vidění všemohoucího vidí, kterýž když padne, otevřené má oči: ");
INSERT INTO ces1613_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Uzřímť jej, ale ne nyní, pohledím na něj, ale ne z blízka. Vyjdeť hvězda z Jákoba, a povstane berla z Izraele, kteráž poláme knížata Moábská, a zkazí všecky syny Set. ");
INSERT INTO ces1613_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","I bude Edom podmaněn, a Seir v vládařstí přijde nepřátelům svým; nebo Izrael zmužile sobě počínati bude. ");
INSERT INTO ces1613_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Panovati bude pošlý z Jákoba, a zahladí ostatky z každého města. ");
INSERT INTO ces1613_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","A když uzřel Amalecha, vzav podobenství své, řekl: Jakož počátek národů Amalech, tak konec jeho do gruntu zahyne. ");
INSERT INTO ces1613_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Uzřev pak Cinea, vzav podobenství své, řekl: Pevný jest příbytek tvůj, a na skále založils hnízdo své; ");
INSERT INTO ces1613_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ale však vyhnán bude Cineus, Assur zajatého jej povede. ");
INSERT INTO ces1613_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Opět vzav podobenství své, řekl: Ach, kdo bude živ, když toto učiní Bůh silný? ");
INSERT INTO ces1613_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","A bárky z země Citim připlynou a ssouží Assyrské, ssouží také Židy, ale i ten lid do konce zahyne. ");
INSERT INTO ces1613_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Potom vstav Balám, odšel a navrátil se na místo své; Balák také odšel cestou svou. ");
INSERT INTO ces1613_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","V tom, když pobyl Izrael v Setim, počal lid smilniti s dcerami Moábskými. ");
INSERT INTO ces1613_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Kteréž pozvaly lidu k obětem bohů svých; i jedl lid, a klaněli se bohům jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","I připojil se lid Izraelský k modle Belfegor, a popudila se prchlivost Hospodinova proti Izraelovi. ");
INSERT INTO ces1613_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","I řekl Hospodin Mojžíšovi: Vezmi všecka knížata lidu, a zvěšej ty nešlechetníky Hospodinu před sluncem, aby se odvrátila prchlivost Hospodinova od Izraele. ");
INSERT INTO ces1613_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","I řekl Mojžíš soudcům Izraelským: Zabí jeden každý z svých všelikého, kterýž se připojil k modle Belfegor. ");
INSERT INTO ces1613_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","A aj, jeden z synů Izraelských přišel, a přivedl k bratřím svým ženu Madianku, na odivu Mojžíšovi i všemu množství synů Izraelských; oni pak plakali u dveří stánku úmluvy. ");
INSERT INTO ces1613_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","To když uzřel Fínes, syn Eleazara, syna Aronova, kněze, vyvstal z prostředku množství toho, a vzal kopí do ruky své. ");
INSERT INTO ces1613_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","A všed za mužem Izraelským do stanu, probodl je oba dva, muže Izraelského, i ženu tu skrze břicho její; i odvrácena jest rána od synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Zhynulo jich pak od té rány dvadceti čtyři tisíce. ");
INSERT INTO ces1613_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Tedy mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Fínes, syn Eleazara kněze, syna Aronova, odvrátil prchlivost mou od synů Izraelských, kdyžto horlil horlivostí mou u prostřed nich, tak abych neshladil synů Izraelských v horlivosti své. ");
INSERT INTO ces1613_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Protož díš: Aj, já dám jemu smlouvu svou pokoje. ");
INSERT INTO ces1613_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","I bude míti on i símě jeho po něm smlouvu kněžství věčného, proto že horlil pro Boha svého, a očistil syny Izraelské. ");
INSERT INTO ces1613_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","A bylo jméno muže Izraelského zabitého, kterýž byl zabit s Madiankou, Zamri, syn Sálův, kníže domu otce svého z pokolení Simeonova. ");
INSERT INTO ces1613_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Jméno pak ženy Madianky zabité, Kozbi, dcera Sur, kterýž byl přední v národu svém, v domě otce svého mezi Madianskými. ");
INSERT INTO ces1613_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Nepřátelsky zacházejte s těmi Madianskými, a zbíte je. ");
INSERT INTO ces1613_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Nebo i oni nepřátelsky a lstivě chovali se k vám, a oklamali vás skrze modlu Fegor, a skrze Kozbu, dceru knížete Madianského, sestru svou, kteráž zabita jest v den pomsty přišlé z příčiny Fegor. ");
INSERT INTO ces1613_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","I stalo se po té ráně, že mluvil Hospodin k Mojžíšovi a Eleazarovi, synu Arona kněze, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Sečtěte všecko množství synů Izraelských, od dvadcítiletých a výše po domích otců jejich, všecky, kteříž by mohli jíti k boji v Izraeli. ");
INSERT INTO ces1613_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Tedy mluvil Mojžíš a Eleazar kněz k nim na polích Moábských, při Jordánu proti Jerichu, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Sečtěte lid od dvadceti let majících a výše, jakž rozkázal Hospodin Mojžíšovi a synům Izraelským, kteříž byli vyšli z země Egyptské. ");
INSERT INTO ces1613_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben prvorozený byl Izraelův. Synové Rubenovi: Enoch, z něhož pošla čeled Enochitská; Fallu, z něhož čeled Fallutská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Ezron, z něhož čeled Ezronitská; Charmi, z něhož čeled Charmitská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ty jsou čeledi Rubenovy. A bylo jich sečtených čtyřidceti tři tisíce, sedm set a třidceti. ");
INSERT INTO ces1613_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","A syn Fallův Eliab. ");
INSERT INTO ces1613_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Synové pak Eliabovi: Nemuel, a Dátan, a Abiron. To jsou ti, Dátan a Abiron, přední z shromáždění, kteříž se vadili s Mojžíšem a s Aronem v spiknutí Chóre, když odporni byli Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Pročež otevřela země ústa svá, a požřela je i Chóre, tehdáž když zemřela ta rota, a oheň spálil těch dvě stě a padesáte mužů, kteříž byli za příklad jiným. ");
INSERT INTO ces1613_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Synové pak Chóre nezemřeli. ");
INSERT INTO ces1613_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Synové Simeonovi po čeledech svých: Namuel, z něhož čeled Namuelitská; Jamin, z něhož čeled Jaminská; Jachin, z něhož čeled Jachinská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Sohar, z něhož čeled Soharská; Saul, z něhož čeled Saulitská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ty jsou čeledi Simeonovy, jichž bylo dvamecítma tisíců a dvě stě. ");
INSERT INTO ces1613_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Synové Gád po čeledech svých: Sefon, z něhož čeled Sefonitská; Aggi, z něhož čeled Aggitská; Suni, z něhož čeled Sunitská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, z něhož čeled Oznitská; Heri, z něhož čeled Heritská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodi, z něhož čeled Aroditská; Areli, z něhož čeled Arelitská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ty jsou čeledi synů Gád, podlé toho, jakž sečteni jsou, čtyřidceti tisíců a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Synové Judovi: Her a Onan; ale zemřeli Her i Onan v zemi Kanánské. ");
INSERT INTO ces1613_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Byli pak synové Judovi po čeledech svých: Séla, z něhož čeled Sélanitská; Fáres, z něhož čeled Fáresská; Zára, z něhož čeled Záretská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Byli pak synové Fáresovi: Ezron, z něhož čeled Ezronitská; Hamul, z něhož čeled Hamulská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ty jsou čeledi Judovy, podlé toho, jakž sečteni jsou, sedmdesáte šest tisíců a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Synové Izacharovi po čeledech svých: Tola, z něhož čeled Tolatská; Fua, z něhož čeled Fuatská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jasub, z něhož čeled Jasubská; Simron, z něhož čeled Simronská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ty jsou čeledi Izacharovy, podlé toho, jakž sečteni jsou, šedesáte čtyři tisíce a tři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Synové Zabulonovi po čeledech svých: Sared, z něhož čeled Saredská; Elon, z něhož čeled Elonská; Jahelel, z něhož čeled Jahelelská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ty jsou čeledi Zabulonovy, podlé toho jakž sečteni jsou, šedesáte tisíc a pět set. ");
INSERT INTO ces1613_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Synové Jozefovi po čeledech svých: Manasses a Efraim. ");
INSERT INTO ces1613_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Synové Manassesovi: Machir, z něhož čeled Machirská. A Machir zplodil Galáda, z něhož čeled Galádská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ti jsou synové Galád: Jezer, z něhož čeled Jezerská; Helek, z něhož čeled Helekitská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, z něhož čeled Asrielská; Sechem, z něhož čeled Sechemská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida, z něhož čeled Semidatská; Hefer, z něhož čeled Heferská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","A Salfad, syn Heferův, neměl synů, než toliko dcery, jichž jsou tato jména: Mahla, Noa, Hegla, Melcha a Tersa. ");
INSERT INTO ces1613_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ty jsou čeledi Manassesovy, a načteno jich padesáte dva tisíce a sedm set. ");
INSERT INTO ces1613_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ale synové Efraimovi po čeledech svých: Sutala, z něhož čeled Sutalitská; Becher, z něhož čeled Becherská; Tehen, z něhož čeled Tehenská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","A ti jsou synové Sutalovi: Heran, z něhož čeled Heranská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ty jsou čeledi synů Efraimových, podlé toho, jakž sečteni jsou, třidceti dva tisíce a pět set. Ti jsou synové Jozefovi po čeledech svých. ");
INSERT INTO ces1613_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Synové pak Beniaminovi po čeledech svých: Béla, z něhož čeled Bélitská; Asbel, z něhož čeled Asbelská; Ahiram, z něhož čeled Ahiramská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufam, z něhož čeled Sufamská; Hufam, z něhož čeled Hufamská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Byli pak synové Béla: Ared a Náman; z Ared čeled Aredská, z Náman čeled Námanská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ti jsou synové Beniaminovi po čeledech svých, podlé toho, jakž sečteni jsou, čtyřidceti pět tisíců a šest set. ");
INSERT INTO ces1613_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Tito pak synové Danovi po čeledech svých: Suham, z něhož čeled Suhamská. Ta jest rodina Danova po čeledech svých. ");
INSERT INTO ces1613_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Všech čeledí Suhamských, jakž sečteni jsou, šedesáte čtyři tisíce a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Synové Asser po čeledech svých: Jemna, z něhož čeled Jemnitská; Jesui, z něhož čeled Jesuitská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beria, z něhož čeled Berietská. Synové Beriovi: Heber, z něhož čeled Heberská; Melchiel, z něhož čeled Melchielská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Jméno pak dcery Asser bylo Serach. ");
INSERT INTO ces1613_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ty jsou čeledi synů Asser, tak jakž sečteni jsou, padesáte tři tisíce a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Synové Neftalímovi po čeledech svých: Jasiel, z něhož čeled Jasielská; Guni, z něhož čeled Gunitská; ");
INSERT INTO ces1613_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, z něhož čeled Jezerská; Sallem, z něhož čeled Sallemská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ta jest rodina Neftalímova po čeledech svých, tak jakž sečteni jsou, čtyřidceti pět tisíců a čtyři sta. ");
INSERT INTO ces1613_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ten jest počet synů Izraelských, šestkrát sto tisíců a jeden tisíc, sedm set a třidceti. ");
INSERT INTO ces1613_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Mluvil pak Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Těmto rozdělena bude země k dědictví podlé počtu jmen. ");
INSERT INTO ces1613_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Většímu počtu větší dědictví dáš, a menšímu menší; jednomu každému vedlé počtu sečtených jeho dáno bude dědictví jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","A však losem ať jest rozdělena země; vedlé jmen pokolení otců svých dědictví vezmou. ");
INSERT INTO ces1613_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Losem děleno bude dědictví její, buď jich mnoho neb málo. ");
INSERT INTO ces1613_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Tito pak jsou sečteni z Levítů po čeledech svých: Gerson, z něhož čeled Gersonitská; Kahat, z něhož čeled Kahatská; Merari, z něhož čeled Meraritská. ");
INSERT INTO ces1613_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ty jsou čeledi Léví: Èeled Lebnitská, čeled Hebronitská, čeled Moholitská, čeled Musitská, čeled Choritská. Kahat pak zplodil Amrama. ");
INSERT INTO ces1613_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","A jméno manželky Amramovy Jochebed, dcera Léví, kteráž se mu narodila v Egyptě; ona pak porodila Amramovi Arona a Mojžíše, a Marii sestru jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aronovi pak zrozeni jsou: Nádab a Abiu, Eleazar a Itamar. ");
INSERT INTO ces1613_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ale Nádab a Abiu zemřeli, když obětovali oheň cizí před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","I bylo jich načteno třimecítma tisíců, všech pohlaví mužského zstáří měsíce jednoho a výše; nebo nebyli počteni mezi syny Izraelskými, proto že jim nebylo dáno dědictví mezi syny Izraelskými. ");
INSERT INTO ces1613_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Tito sečteni jsou od Mojžíše a Eleazara kněze; oni sečtli syny Izraelské na polích Moábských při Jordánu, naproti Jerichu. ");
INSERT INTO ces1613_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mezi těmito pak nebyl žádný z oněch sečtených od Mojžíše a Arona kněze, když počítali syny Izraelské na poušti Sinai; ");
INSERT INTO ces1613_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","(Nebo řekl byl Hospodin o nich: Smrtí zemrou na poušti;) a žádný z nich nepozůstal, jediné Kálef, syn Jefonův, a Jozue, syn Nun. ");
INSERT INTO ces1613_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Tehdy přistoupily dcery Salfada, syna Heferova, syna Galád, syna Machir, syna Manasse, z pokolení Manasse, syna Jozefova. Tato pak jsou jména dcer jeho: Mahla, Noa, Hegla, Melcha a Tersa. ");
INSERT INTO ces1613_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","A postavily se před Mojžíšem a před Eleazarem knězem, i před knížaty a vším množstvím, u dveří stánku úmluvy, a řekly: ");
INSERT INTO ces1613_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Otec náš umřel na poušti, kterýž však nebyl z spolku těch, kteříž se zrotili proti Hospodinu v rotě Chóre; nebo pro hřích svůj umřel, synů žádných nemaje. ");
INSERT INTO ces1613_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Což vyhlazeno býti má jméno otce našeho z čeledi jeho, proto že neměl syna? Dej nám dědictví mezi bratřími otce našeho. ");
INSERT INTO ces1613_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","I vznesl tu věc Mojžíš na Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Kterýž odpověděl Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Dobře mluví dcery Salfad. Dejž jim bez odporu právo dědictví mezi bratřími otce jejich, a přenes dědictví otce jejich na ně. ");
INSERT INTO ces1613_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","K synům pak Izraelským toto mluviti budeš: Když by kdo umřel, nemaje syna, tedy přenesete dědictví jeho na dceru jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Pakli by ani dcery neměl, tedy dáte dědictví jeho bratřím jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Pakli by ani bratří neměl, tedy dáte dědictví jeho bratřím otce jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Pakli by ani strýců neměl, tedy dáte dědictví jeho příteli jeho, kterýž jest nejbližší jemu v rodu jeho, aby dědičně obdržel je. A bude to synům Izraelským za ustanovení soudné, jakož přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Řekl také Hospodin Mojžíšovi: Vstup na horu tuto Abarim, a spatř zemi, kterouž jsem dal synům Izraelským. ");
INSERT INTO ces1613_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","A když spatříš ji, připojen budeš k lidu svému i ty, jako připojen jest Aron bratr tvůj, ");
INSERT INTO ces1613_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Poněvadž jste odporovali řeči mé na poušti Tsin, při odporování všeho množství, kdež jste mne měli posvětiti při vodách před očima jejich. To jsou ty vody sváru v Kádes, na poušti Tsin. ");
INSERT INTO ces1613_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","I řekl Mojžíš Hospodinu, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Opatříš Hospodin Bůh duchů, Bůh všelikého těla, shromáždění toto mužem hodným, ");
INSERT INTO ces1613_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Kterýž by vycházel před nimi, a kterýž by vcházel před nimi, kterýž by vyvodil a zase uvodil je, aby nebylo shromáždění Hospodinovo jako ovce, kteréž nemají pastýře. ");
INSERT INTO ces1613_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","I řekl Hospodin Mojžíšovi: Vezmi k sobě Jozue, syna Nun, muže, v kterémž jest duch můj, a vlož ruku svou na něj. ");
INSERT INTO ces1613_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","A postavě jej před Eleazarem knězem a přede vším shromážděním, dáš jemu naučení před očima jejich, ");
INSERT INTO ces1613_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","A udělíš jemu slávy své, aby ho poslouchalo všecko množství synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Kterýž před Eleazarem knězem postavě se, ptáti se ho bude na soud urim před Hospodinem. K rozkazu jeho vyjdou, a k rozkazu jeho vejdou, on i všickni synové Izraelští s ním, a všecko shromáždění. ");
INSERT INTO ces1613_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","I učinil Mojžíš tak, jakž mu byl rozkázal Hospodin, a pojav Jozue, postavil jej před Eleazarem knězem a přede vším shromážděním. ");
INSERT INTO ces1613_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","A vloživ ruce své na něj, dal jemu naučení, jakž mluvil Hospodin skrze Mojžíše. ");
INSERT INTO ces1613_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Přikaž synům Izraelským a rci jim: Obětí mých, chleba mého, v obětech mých ohnivých u vůni spokojující mne, nezanedbávejte mi přinášeti v čas k tomu vyměřený. ");
INSERT INTO ces1613_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Díš tedy jim: Tato jest obět ohnivá, kterouž obětovati budete Hospodinu: Beránky roční bez poškvrny dva, každého dne v obět zápalnou ustavičně. ");
INSERT INTO ces1613_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Beránka jednoho obětovati budeš ráno, a beránka druhého obětovati budeš k večerou. ");
INSERT INTO ces1613_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Desátý také díl míry efi mouky bělné, v obět suchou, zadělané olejem nejčistším, čtvrtou částkou míry hin. ");
INSERT INTO ces1613_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ta jest obět zápalná ustavičná, kteráž obětována jest na hoře Sinai u vůni příjemnou, v obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","A obět mokrá její, čtvrtý díl míry hin na každého beránka; v svatyni obětuj obět mokrou silného nápoje Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Beránka pak druhého obětovati budeš k večerou, tak jako obět suchou jitřní, a jako obět mokrou její obětovati budeš v obět ohnivou, u vůni spokojující Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Dne také sobotního dva beránky roční bez poškvrny, a dvě desetiny mouky bělné, olejem zadělané v obět suchou s obětí její mokrou. ");
INSERT INTO ces1613_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ta bude obět zápalná sobotní každého dne sobotního, mimo zápalnou obět ustavičnou a mokrou obět její. ");
INSERT INTO ces1613_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Také na nov měsíců vašich obětovati budete obět zápalnou Hospodinu, volky mladé dva, skopce jednoho, beránků ročních bez poškvrny sedm; ");
INSERT INTO ces1613_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","A tři desetiny mouky bělné, olejem zadělané v obět suchou při každém volku, a dvě desetiny mouky bělné, olejem zadělané v obět suchou při každém skopci; ");
INSERT INTO ces1613_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","A jednu desetinu mouky bělné olejem zadělané v obět suchou při každém beránku, k oběti zápalné u vůni příjemnou, v obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Tyto pak oběti mokré jejich z vína: Půl míry hin bude při každém volku, a třetí částka hin při skopci, a čtvrtá částka hin při každém beránku. Ta jest obět zápalná k nov měsíci, každého měsíce přes celý rok. ");
INSERT INTO ces1613_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Kozla také jednoho v obět za hřích, mimo obět ustavičnou, obětovati budete Hospodinu s mokrou obětí jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Měsíce pak prvního, čtrnáctý den téhož měsíce velikanoc bude Hospodinu, ");
INSERT INTO ces1613_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","A v patnáctý den téhož měsíce slavnost; za sedm dní chleby nekvašené jísti budete. ");
INSERT INTO ces1613_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Prvního dne shromáždění svaté bude, žádného díla robotného nebudete dělati v něm. ");
INSERT INTO ces1613_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Obětovati pak budete obět ohnivou v zápal Hospodinu, volky mladé dva, skopce jednoho, a sedm beránků ročních; bez poškvrny budou. ");
INSERT INTO ces1613_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","A suchou obět při nich, totiž mouku bělnou, olejem zadělanou, tři desetiny při každém volku, a dvě desetiny při každém skopci obětovati budete. ");
INSERT INTO ces1613_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","A jednu desetinu obětovati budeš při každém beránku z těch sedmi beránků, ");
INSERT INTO ces1613_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","A kozla v obět za hřích jednoho k očištění vás. ");
INSERT INTO ces1613_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mimo obět zápalnou jitřní, kteráž jest obět ustavičná, obětovati budete to. ");
INSERT INTO ces1613_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Tak obětovati budete každého dne za těch sedm dní pokrm oběti ohnivé, u vůni spokojující Hospodina, mimo zápalnou obět ustavičnou, a obět mokrou její. ");
INSERT INTO ces1613_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Sedmého pak dne shromáždění svaté míti budete, žádného díla robotného nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","V den také prvotin, když obětovati budete novou obět suchou Hospodinu, vyplníc téhodny vaše, shromáždění svaté míti budete; žádného díla robotného nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","A obětovati budete obět zápalnou, u vůni spokojující Hospodina, volky mladé dva, skopce jednoho, beránků ročních sedm, ");
INSERT INTO ces1613_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","A obět suchou jejich, mouky bělné olejem zadělané tři desetiny při každém volku, dvě desetiny při každém skopci, ");
INSERT INTO ces1613_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Jednu desetinu při každém beránku z těch sedmi beránků, ");
INSERT INTO ces1613_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Kozla jednoho k očištění vašemu. ");
INSERT INTO ces1613_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","To mimo obět zápalnou ustavičnou, a obět suchou její obětovati budete; bez poškvrny ať jsou s obětmi svými mokrými. ");
INSERT INTO ces1613_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Měsíce pak sedmého v první den jeho shromáždění svaté míti budete, žádného díla robotného nebudete dělati; to jest den troubení vašeho. ");
INSERT INTO ces1613_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","A obětovati budete zápal u vůni příjemnou Hospodinu, volka mladého jednoho, skopce jednoho, beránků ročních bez poškvrny sedm; ");
INSERT INTO ces1613_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","A obět suchou při nich z mouky bělné olejem zadělané, tři desetiny na každého volka, a dvě desetiny na každého skopce; ");
INSERT INTO ces1613_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","A desetina jedna na každého beránka z sedmi beránků; ");
INSERT INTO ces1613_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","A kozla jednoho v obět za hřích k očištění vás. ");
INSERT INTO ces1613_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Mimo zápalnou obět novoměsíčnou s obětí její suchou, a mimo obět zápalnou ustavičnou s obětí její suchou, a s obětmi jejich mokrými vedlé pořádku jejich, u vůni příjemnou, v obět ohnivou Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","V desátý pak den téhož měsíce sedmého shromáždění svaté míti budete, a ponižovati budete životů svých; žádného díla nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","A obětovati budete obět zápalnou Hospodinu u vůni příjemnou, volka mladého jednoho, skopce jednoho, beránků ročních sedm, a ti ať jsou bez poškvrny; ");
INSERT INTO ces1613_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","A obět suchou jejich z mouky bělné olejem zadělané, tři desetiny na každého volka, a dvě desetiny na každého skopce; ");
INSERT INTO ces1613_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","A desetina jedna na každého beránka z těch sedmi beránků; ");
INSERT INTO ces1613_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Kozla jednoho v obět za hřích, mimo obět za hřích k očištění, a mimo zápal ustavičný s obětí suchou jeho, a s obětmi mokrými jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","V patnáctý také den měsíce sedmého shromáždění svaté míti budete; žádného díla robotného nebudete dělati, ale slaviti budete svátek Hospodinu za sedm dní. ");
INSERT INTO ces1613_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","A obětovati budete zápal v obět ohnivou u vůni spokojující Hospodina, volků mladých třinácte, skopce dva, beránků ročních čtrnácte, a ti ať jsou bez poškvrny; ");
INSERT INTO ces1613_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Též obět suchou jejich z mouky bělné olejem zadělané, tři desetiny na každého volka z třinácti volků, dvě desetiny na každého skopce z těch dvou skopců, ");
INSERT INTO ces1613_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","A jednu desetinu na každého beránka z těch čtrnácti beránků; ");
INSERT INTO ces1613_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","A kozla jednoho v obět za hřích, mimo zápal ustavičný s obětí jeho suchou i mokrou. ");
INSERT INTO ces1613_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Potom dne druhého volků mladých dvanácte, skopce dva, beránků ročních bez poškvrny čtrnácte, ");
INSERT INTO ces1613_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","S obětí suchou při nich, a s obětmi mokrými jejich při každém volku, skopci i beránku vedlé počtu jejich, jakž jest obyčej; ");
INSERT INTO ces1613_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","A kozla jednoho v obět za hřích, mimo zápal ustavičný s obětí suchou jeho a s obětmi mokrými jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Dne pak třetího volků jedenácte, skopce dva, a beránků ročních bez poškvrny čtrnácte, ");
INSERT INTO ces1613_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","S obětí suchou a s obětmi mokrými jejich při každém volku, skopci i beránku, vedlé počtu jejich, jakž jest obyčej; ");
INSERT INTO ces1613_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","A kozla v obět za hřích jednoho, mimo obět zápalnou ustavičnou s obětí její suchou i mokrou. ");
INSERT INTO ces1613_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Dne pak čtvrtého volků deset, skopce dva, beránků ročních bez poškvrny čtrnácte, ");
INSERT INTO ces1613_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","S obětí suchou i s obětmi mokrými jejich při každém volku, skopci a beránku, vedlé počtu jejich, jakž jest obyčej; ");
INSERT INTO ces1613_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","A kozla jednoho v obět za hřích, mimo obět zápalnou ustavičnou s obětí její suchou i mokrou. ");
INSERT INTO ces1613_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Dne také pátého volků devět, skopce dva, beránků ročních bez poškvrny čtrnácte, ");
INSERT INTO ces1613_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","S obětí suchou i s obětmi mokrými jejich při každém volku, skopci i beránku, vedlé počtu jejich, jakž jest obyčej; ");
INSERT INTO ces1613_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","A kozla jednoho v obět za hřích, mimo obět zápalnou ustavičnou s obětí její suchou i mokrou. ");
INSERT INTO ces1613_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","A dne šestého volků osm, skopce dva, beránků ročních bez poškvrny čtrnácte, ");
INSERT INTO ces1613_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","S obětí suchou a s obětmi mokrými jejich při každém volku, skopci i beránku, vedlé počtu jejich, jakž jest obyčej; ");
INSERT INTO ces1613_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","A kozla jednoho v obět za hřích, mimo obět zápalnou ustavičnou s obětí její suchou i s obětmi mokrými. ");
INSERT INTO ces1613_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Tolikéž dne sedmého volků sedm, skopce dva, beránků ročních bez poškvrny čtrnácte, ");
INSERT INTO ces1613_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","S obětí suchou i s obětmi mokrými jejich na volky, skopce i beránky, vedlé počtu jejich, jakž jest obyčej; ");
INSERT INTO ces1613_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","A kozla jednoho v obět za hřích, mimo obět zápalnou ustavičnou s obětí její suchou i mokrou. ");
INSERT INTO ces1613_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Dne pak osmého slavnost míti budete; žádného díla robotného nebudete dělati. ");
INSERT INTO ces1613_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","A obětovati budete obět zápalnou, v obět ohnivou vůně spokojující Hospodina, volka jednoho, skopce jednoho, a beránků ročních sedm bez poškvrny, ");
INSERT INTO ces1613_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","S obětí suchou i s obětmi mokrými jejich při volku, skopci i beráncích, vedlé počtu jejich, jakž jest obyčej; ");
INSERT INTO ces1613_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","A kozla jednoho v obět za hřích, mimo obět zápalnou ustavičnou s obětí její suchou i mokrou. ");
INSERT INTO ces1613_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ty věci vykonávati budete Hospodinu při slavnostech vašich, kromě toho, což byste z slibu aneb z dobré vůle své obětovali, buď zápalné, aneb suché, aneb mokré, aneb pokojné oběti vaše. ");
INSERT INTO ces1613_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","I oznámil Mojžíš synům Izraelským všecky ty věci, kteréž přikázal jemu Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mluvil také Mojžíš knížatům pokolení synů Izraelských, řka: Totoť jest, což přikázal Hospodin: ");
INSERT INTO ces1613_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Jestliže by muž slib aneb přísahu učinil Hospodinu, závazkem zavazuje duši svou, nezruší slova svého; podlé všeho, což vyšlo z úst jeho, učiní. ");
INSERT INTO ces1613_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Když by pak osoba ženského pohlaví učinila slib Hospodinu, a závazkem zavázala se v domě otce svého v mladosti své, ");
INSERT INTO ces1613_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","A slyše otec její slib a závazek její, jímž zavázala duši svou, mlčel by k tomu: tedy stálí budou všickni slibové její, i každý závazek, jímž zavázala se, stálý bude. ");
INSERT INTO ces1613_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Jestliže by pak to zrušil otec její toho dne, když slyšel všecky ty sliby a závazky její, jimiž zavázala duši svou, nebudouť stálí; a Hospodin odpustí jí, nebo otec její to zrušil. ");
INSERT INTO ces1613_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Pakli by vdaná byla za muže, a měla by slib na sobě, aneb pronesla by ústy svými něco, čímž by se zavázala, ");
INSERT INTO ces1613_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","A slyše muž její, nic by jí neřekl toho dne, kteréhož slyšel: stálí budou slibové její, i závazkové, jimiž zavázala duši svou, stálí budou. ");
INSERT INTO ces1613_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Jestliže by pak muž její toho dne, jakž uslyšel, odepřel tomu, a zrušil slib, kterýž na sobě měla, aneb něco rty svými pronesla, čímž by se zavázala, také odpustí jí Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Všeliký pak slib vdovy aneb ženy zahnané, jímž by se zavázala, stálý bude. ");
INSERT INTO ces1613_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Ale jestliže v domě muže svého slíbila, a závazkem zavázala se s přísahou, ");
INSERT INTO ces1613_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","A slyše to muž její, mlčel k tomu a neodepřel: tedy stálí budou všickni slibové její, a všickni závazkové, jimiž se zavázala, stálí budou. ");
INSERT INTO ces1613_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Pakli docela odepřel muž její toho dne, jakž uslyšel, všeliký slib, kterýž vyšel z úst jejích, a závazek, jímž zavázala se, nebude stálý; muž její zrušil to, a Hospodin jí odpustí. ");
INSERT INTO ces1613_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Všelikého slibu a každého závazku s přísahou učiněného o trápení života jejího, muž její potvrdí jeho, a muž její zruší jej. ");
INSERT INTO ces1613_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Pakli by muž její den po dni mlčel, tedy potvrdí všech slibů jejích, a všech závazků jejích, kteréž na sobě má; potvrdilť jest jich, nebo neodepřel jí v den ten, když to uslyšel. ");
INSERT INTO ces1613_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Jestliže by pak slyše, potom teprv zrušiti to chtěl, tedy on ponese nepravost její. ");
INSERT INTO ces1613_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ta jsou ustanovení, kteráž přikázal Hospodin Mojžíšovi, mezi mužem a ženou jeho, mezi otcem a dcerou jeho v mladosti její, dokudž jest v domě otce svého. ");
INSERT INTO ces1613_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Pomsti prvé synů Izraelských nad Madianskými, a potom připojen budeš k lidu svému. ");
INSERT INTO ces1613_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mluvil tedy Mojžíš k lidu, řka: Vypravte některé z sebe k boji, aby šli proti Madianským a vykonali pomstu Hospodinovu nad nimi. ");
INSERT INTO ces1613_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Po tisíci z pokolení, ze všech pokolení Izraelských vyšlete k boji. ");
INSERT INTO ces1613_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","I vydáno jest z mnohých tisíců Izraelských po tisíci z každého pokolení, totiž dvanácte tisíců způsobných k boji. ");
INSERT INTO ces1613_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","I poslal je Mojžíš po tisíci z každého pokolení k boji, a Fínesa syna Eleazara kněze s nimi; a nádoby svaté i trouby k troubení byly v ruce jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Tedy bojovali proti Madianským, jakož byl přikázal Hospodin Mojžíšovi, a zbili všecky pohlaví mužského. ");
INSERT INTO ces1613_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Pobili také krále Madianské mezi jinými, kteréž porazili, totiž Evi, Rekem, Sur, Hur a Rebe, pět králů Madianských; Baláma také, syna Beorova, zabili mečem. ");
INSERT INTO ces1613_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","A zajali synové Izraelští ženy Madianské i děti jejich; všecka hovada jejich, i všechny dobytky jejich, a všecka zboží jejich pobrali. ");
INSERT INTO ces1613_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Všecka také města jejich, v kterýchž svá obydlí měli, i všecky hrady jejich vypálili ohněm. ");
INSERT INTO ces1613_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","A všecku loupež i všecky kořisti pobravše, lidi i hovada, ");
INSERT INTO ces1613_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Vedli je k Mojžíšovi a k Eleazarovi knězi, a ke všemu množství synů Izraelských, i zajaté i kořisti, i loupeže, k vojsku na roviny Moábské, kteréž jsou při Jordánu naproti Jerichu. ");
INSERT INTO ces1613_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","I vyšli Mojžíš a Eleazar kněz a všecka knížata shromáždění proti nim ven za stany. ");
INSERT INTO ces1613_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Tedy rozhněval se Mojžíš na vůdce vojska, hejtmany nad tisíci a setníky, kteříž se navraceli z boje, ");
INSERT INTO ces1613_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","A řekl jim Mojžíš: A což jste zachovali všecky ženy? ");
INSERT INTO ces1613_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ej, onyť jsou hle synům Izraelským, podlé rady Balámovy, daly příčinu k přestoupení proti Hospodinu, při modlářství Fegor, pročež ona rána přišla byla na lid Hospodinův. ");
INSERT INTO ces1613_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Protož nyní zmordujte všecky děti pohlaví mužského, a všecky ženy, kteréž poznaly muže. ");
INSERT INTO ces1613_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Všecky pak panny, kteréž nepoznaly muže, zachovejte sobě živé. ");
INSERT INTO ces1613_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Vy pak zůstaňte vně za stany za sedm dní; všickni, kteřížkoli jste někoho zabili, aneb kteříž jste se zabitého dotkli, očištovati se budete dne třetího a dne sedmého, sebe i zajaté své. ");
INSERT INTO ces1613_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Všeliké také roucho a všecky věci kožené, i všelijaké dílo z í kozích, i všelikou nádobu dřevěnou očistíte. ");
INSERT INTO ces1613_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","I řekl Eleazar kněz vojákům, kteříž byli šli k boji: Toto jest ustanovení zákona, kteréž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zlato však, stříbro, měď, železo, cín a olovo, ");
INSERT INTO ces1613_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","A cožkoli trpí oheň, ohněm přepálíte, a přečištěno bude, však tak, když vodou očišťování obmyto bude; což pak nemůže ohně strpěti, to skrze vodu protáhnete. ");
INSERT INTO ces1613_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Zpéřete také roucha svá v den sedmý, a čistí budete; a potom vejdete do stanů. ");
INSERT INTO ces1613_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mluvil i to Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Sečti summu kořistí zajatých, tak z lidí jako z hovad, ty a Eleazar kněz, a přední z čeledi otců v lidu; ");
INSERT INTO ces1613_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","A rozdělíš ty kořisti na dva díly, jeden mezi vojáky, kteříž byli vytáhli na vojnu, a druhý mezi všecko shromáždění. ");
INSERT INTO ces1613_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","A vezmeš díl na Hospodina od mužů bojovných, kteříž byli vyšli na vojnu, jednu duši z pěti set, buďto z lidí neb z hovad, neb z oslů, neb z ovcí. ");
INSERT INTO ces1613_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Z jejich polovice to vezmete, a dáte Eleazarovi knězi obět vzhůru pozdvižení Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Z polovice pak té, kteráž jest synů Izraelských, vezmeš jedno z padesáti, buďto z lidí neb z volů, neb z oslů, neb z ovcí, a tak ze všelijakých hovad, a dáš to Levítům, držícím stráž příbytku Hospodinova. ");
INSERT INTO ces1613_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","I učinil Mojžíš a Eleazar kněz tak, jakž byl rozkázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","A bylo té kořisti z pozůstalé ještě loupeže, kteréž nabral lid válečný, ovec šestkrát sto tisíc, sedmdesáte a pět tisíců; ");
INSERT INTO ces1613_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","A volů sedmdesáte a dva tisíce; ");
INSERT INTO ces1613_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Oslů šedesáte a jeden tisíců; ");
INSERT INTO ces1613_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","A panen, kteréž mužů nepoznaly, všech dva a třidceti tisíců. ");
INSERT INTO ces1613_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Dostala se pak polovice jedna na díl těm, kteříž byli vytáhli na vojnu, dobytka drobného v počtu třikrát sto tisíc, třidceti a sedm tisíců a pět set, ");
INSERT INTO ces1613_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","A na díl vzatý Hospodinu dobytka drobného šest set, sedmdesáte pět. ");
INSERT INTO ces1613_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","A z volů šest a třidceti tisíců, z nichž přišlo na díl Hospodinu sedmdesáte a dva. ");
INSERT INTO ces1613_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Oslů také třidceti tisíc a pět set, z nichž přišlo na díl Hospodinu šedesáte a jeden. ");
INSERT INTO ces1613_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","A lidí šestnácte tisíců, z nichž přišlo na díl Hospodinu třidceti a dvě duše. ");
INSERT INTO ces1613_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Dal tedy Mojžíš díl oddělený Hospodinu Eleazarovi knězi, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Z druhé pak polovice synů Izraelských, kterouž vzal Mojžíš od těch mužů, jenž bojovali, ");
INSERT INTO ces1613_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(A bylo té polovice k shromáždění přináležející z ovec třikrát sto tisíc, třidceti a sedm tisíců a pět set; ");
INSERT INTO ces1613_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Volů třidceti šest tisíců; ");
INSERT INTO ces1613_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Oslů třidceti tisíců a pět set; ");
INSERT INTO ces1613_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","A lidí šestnácte tisíců;) ");
INSERT INTO ces1613_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Z té tedy polovice synů Izraelských vzal Mojžíš po jednom zajatém z padesáti, tak z lidí jako z hovad, a dal to Levítům, držícím stráž příbytku Hospodinova, jakž byl přikázal Hospodin Mojžíšovi. ");
INSERT INTO ces1613_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Tedy přistoupili k Mojžíšovi vývodové vojska, hejtmané nad tisíci a setníci, ");
INSERT INTO ces1613_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","A řekli jemu: My služebníci tvoji sečtli jsme počet bojovníků, kteréž jsme měli pod spravou naší, a neubyl ani jeden z nás. ");
INSERT INTO ces1613_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","A protož obětujeme obět Hospodinu, každý z toho, čehož jest dostal, nádobí zlaté, zápony, náramky, prsteny, náušnice a řetízky, aby očištěny byly duše naše před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Vzal tedy Mojžíš a Eleazar kněz od nich to zlato všelikého díla řemeslného. ");
INSERT INTO ces1613_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Bylo pak všeho zlata odděleného, kteréž obětováno Hospodinu, šestnácte tisíců, sedm set a padesáte lotů, od hejtmanů nad tisíci a od setníků. ");
INSERT INTO ces1613_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(Muži zajisté bojovní, což loupeží vzali, to sobě měli.) ");
INSERT INTO ces1613_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","A vzavše Mojžíš a Eleazar kněz od hejtmanů nad tisíci a setníků to zlato, vnesli je do stánku úmluvy, na památku synů Izraelských před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Měli pak synové Ruben a synové Gád dobytka velmi mnoho, a uzřeli zemi Jazer a zemi Galád, ano místo to místo příhodné pro dobytek. ");
INSERT INTO ces1613_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Protož přistoupivše synové Gád a synové Ruben, mluvili k Mojžíšovi a k Eleazarovi knězi a knížatům shromáždění, řkouce: ");
INSERT INTO ces1613_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot a Dibon, a Jazer a Nemra, Ezebon a Eleale, a Saban a Nébo a Beon, ");
INSERT INTO ces1613_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Země, kterouž zbil Hospodin před shromážděním Izraelským, jest země příhodná ku pastvě dobytku, a my služebníci tvoji máme drahně dobytka. ");
INSERT INTO ces1613_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","(Protož řekli:) Jestliže jsme nalezli milost před očima tvýma, nechť jest dána krajina ta služebníkům tvým k vládařství, ať nechodíme za Jordán. ");
INSERT INTO ces1613_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","I odpověděl Mojžíš synům Gád a synům Ruben: Což bratří vaši půjdou sami k boji, a vy zde zůstanete? ");
INSERT INTO ces1613_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","I proč roztrhujete mysli synů Izraelských, aby nesměli jíti do země, kterouž jim dal Hospodin? ");
INSERT INTO ces1613_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Takť jsou učinili otcové vaši, když jsem je poslal z Kádesbarne, aby prohlédli zemi tu. ");
INSERT INTO ces1613_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Kteřížto, když přišli až k údolí Eškol a shlédli zemi, potom vrátivše se, odvrátili mysl synů Izraelských, aby nešli do země, kterouž dal jim Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Èímž popuzen jsa k hněvu Hospodin v den ten, přisáhl, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Zajisté že lidé ti, kteříž vyšli z Egypta, od dvadcítiletých a výše, neuzří země té, kterouž jsem s přísahou zaslíbil Abrahamovi, Izákovi a Jákobovi, nebo ne cele následovali mne, ");
INSERT INTO ces1613_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Kromě Kálefa, syna Jefonova Cenezejského, a Jozue, syna Nun, nebo cele následovali Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","I popudila se prchlivost Hospodinova na Izraele, a učinil, aby byli tuláci na poušti za čtyřidceti let, dokudž nezahynul všecken ten věk, kterýž činil zlé před očima Hospodinovýma. ");
INSERT INTO ces1613_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","A hle, vy nastoupili jste na místo otců svých, plémě lidí hříšných, abyste vždy přidávali k hněvu prchlivosti Hospodinovy na Izraele. ");
INSERT INTO ces1613_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Jestliže se odvrátíte od následování jeho, i onť také opustí jej na poušti této, a tak budete příčina zahynutí všeho lidu tohoto. ");
INSERT INTO ces1613_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Přistoupivše pak znovu, řekli jemu: Stáje dobytkům a stádům svým zde vzděláme, a města dítkám svým, ");
INSERT INTO ces1613_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Sami pak v odění pohotově budeme, statečně sobě počínajíce před syny Izraelskými, dokavadž jich neuvedeme na místo jejich; mezi tím zůstanou dítky naše v městech hrazených, pro bezpečnost před obyvateli země. ");
INSERT INTO ces1613_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nenavrátíme se do domů svých, až prvé vládnouti budou synové Izraelští jeden každý dědictvím svým; ");
INSERT INTO ces1613_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Aniž vezmeme jakého dědictví s nimi za Jordánem neb dále, když dosáhneme dědictví svého z této strany Jordánu, k východu slunce. ");
INSERT INTO ces1613_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","I odpověděl jim Mojžíš: Jestliže učiníte tak, jakž jste mluvili, a jestliže půjdete v odění před Hospodinem k boji, ");
INSERT INTO ces1613_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","A šli byste za Jordán vy všickni v odění před Hospodinem, dokavadž by nevyhnal nepřátel svých od tváři své, ");
INSERT INTO ces1613_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","A nebyla podmaněna všecka země před Hospodinem: potom navrátíte se, a budete bez viny před Hospodinem i před Izraelem; tak přijde země tato vám v dědictví před Hospodinem. ");
INSERT INTO ces1613_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Pakli neučiníte toho, hle, zhřešíte proti Hospodinu, a vězte, že pomsta vaše přijde na vás. ");
INSERT INTO ces1613_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Stavějte sobě tedy města pro dítky, a stáje pro dobytky své, a což vyšlo z úst vašich, učiňte. ");
INSERT INTO ces1613_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","I odpovědělo pokolení synů Gád a synů Ruben Mojžíšovi, řka: Služebníci tvoji učiní, jakž pán náš rozkazuje. ");
INSERT INTO ces1613_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Dítky naše a ženy naše, dobytek náš a všecka hovada naše, tu zůstanou v městech Galád, ");
INSERT INTO ces1613_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Služebníci pak tvoji přejdou jeden každý v odění způsobný před Hospodinem k boji, jakož mluví pán můj. ");
INSERT INTO ces1613_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","I poručil o nich Mojžíš Eleazarovi knězi a Jozue, synu Nun, a předním v čeledech pokolení synů Izraelských, ");
INSERT INTO ces1613_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","A řekl jim: Jestliže přejdou synové Gád a synové Ruben s vámi za Jordán všickni hotovi k boji před Hospodinem, a byla by již podmaněna země před vámi, dáte jim zemi Galád k vládařství. ");
INSERT INTO ces1613_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Pakli by nešli v odění s vámi, tedy dědictví míti budou u prostřed vás v zemi Kanán. ");
INSERT INTO ces1613_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","I odpověděli synové Gád a synové Ruben, řkouce: Jakž mluvil Hospodin služebníkům tvým, tak učiníme: ");
INSERT INTO ces1613_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","My půjdeme v odění před Hospodinem do země Kanán, a zůstane nám v dědictví vládařství naše z této strany Jordánu. ");
INSERT INTO ces1613_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Tedy dal jim Mojžíš, synům totiž Gád a synům Ruben a polovici pokolení Manasses, syna Jozefova, království Seona, krále Amorejského, a království Oga, krále Bázanského, zemi s městy jejími při pomezích, i města země té všudy vůkol. ");
INSERT INTO ces1613_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","A vzdělali synové Gád, Dibon, Atarot a Aroer, ");
INSERT INTO ces1613_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","A Atrot, Sofan, Jazer a Jegbaa, ");
INSERT INTO ces1613_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","A Betnemra a Betaran, města hrazená, a stáje pro dobytky. ");
INSERT INTO ces1613_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Synové pak Ruben vystavěli Ezebon, Eleale a Kariataim, ");
INSERT INTO ces1613_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","A Nébo a Balmeon, změnivše jim jména; také Sabma, a dali jiná jména městům, kteráž vzdělali. ");
INSERT INTO ces1613_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Táhli pak synové Machir, syna Manassesova, do Galád, a vzavše tu krajinku, vyhnali Amorejského, kterýž tam bydlil. ");
INSERT INTO ces1613_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","I dal Mojžíš zemi Galád Machirovi, synu Manassesovu, a bydlil v ní. ");
INSERT INTO ces1613_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair také syn Manassesův táhl a vzal vsi jejich, a nazval je vsi Jairovy. ");
INSERT INTO ces1613_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobe také táhl, a vzal Kanat a městečka jeho, a nazval je Nobe od jména svého. ");
INSERT INTO ces1613_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Tato jsou tažení synů Izraelských, kteříž vyšli z země Egyptské po houfích svých, pod spravou Mojžíše a Arona. ");
INSERT INTO ces1613_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Sepsal pak Mojžíš vycházení jejich podlé toho, jakž táhli k rozkazu Hospodinovu. Tato jsou tedy vycházení jejich podlé toho, jakž táhli. ");
INSERT INTO ces1613_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Nejprv z Ramesses jdouce prvního měsíce, v patnáctý den téhož prvního měsíce, nazejtří po slavnosti Fáze vyšli synové Izraelští v ruce silné před očima všech Egyptských, ");
INSERT INTO ces1613_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Kdyžto Egyptští pochovávali všecky prvorozené, kteréž zbil Hospodin mezi nimi, a při bozích jejich vykonal Hospodin soudy své. ");
INSERT INTO ces1613_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Hnuvše se tedy synové Izraelští z Ramesses, položili se v Sochot. ");
INSERT INTO ces1613_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Potom hnuvše se z Sochot, položili se v Etam, jenž jest při kraji pouště. ");
INSERT INTO ces1613_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","A hnuvše se z Etam, navrátili se zase k Fiarot, jenž jest před Belsefon, a položili se před Magdalem. ");
INSERT INTO ces1613_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","A hnuvše se z Fiarot, šli prostředkem moře na poušť, a ušedše tří dnů cesty po poušti Etam, položili se v Marah. ");
INSERT INTO ces1613_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Jdouce pak z Marah, přišli do Elim, kdežto bylo dvanácte studnic vod, a sedmdesáte palm. I položili se tu. ");
INSERT INTO ces1613_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","A hnuvše se z Elim, položili se u moře Rudého. ");
INSERT INTO ces1613_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Potom hnuvše se od moře Rudého, položili se na poušti Sin. ");
INSERT INTO ces1613_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","A když se hnuli z pouště Sin, položili se v Dafka. ");
INSERT INTO ces1613_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","A hnuvše se z Dafka, položili se v Halus. ");
INSERT INTO ces1613_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Hnuvše se pak z Halus, rozbili stany v Rafidim, kdežto lid neměl vody ku pití. ");
INSERT INTO ces1613_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","A hnuvše se z Rafidim, položili se na poušti Sinai. ");
INSERT INTO ces1613_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Hnuvše se pak z pouště Sinai, položili se v Kibrot Hattáve. ");
INSERT INTO ces1613_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","A když se hnuli z Kibrot Hattáve, položili se v Hazerot. ");
INSERT INTO ces1613_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Hnuvše se pak z Hazerot, položili se v Retma. ");
INSERT INTO ces1613_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","A z Retma hnuvše se, položili se v Remmon Fáres. ");
INSERT INTO ces1613_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Potom hnuvše se z Remmon Fáres, položili se v Lebna. ");
INSERT INTO ces1613_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","A hnuvše se z Lebna, položili se v Ressa. ");
INSERT INTO ces1613_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","A hnuvše se z Ressa, položili se v Cehelot. ");
INSERT INTO ces1613_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Z Cehelot pak hnuvše se, položili se na hoře Sefer. ");
INSERT INTO ces1613_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","A když se hnuli s hory Sefer, položili se v Arad. ");
INSERT INTO ces1613_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","A hnuvše se z Arad, položili se v Machelot. ");
INSERT INTO ces1613_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Potom hnuvše se z Machelot, položili se v Tahat. ");
INSERT INTO ces1613_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","A hnuvše se z Tahat, položili se v Tár. ");
INSERT INTO ces1613_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","A když se hnuli z Tár, položili se v Metka. ");
INSERT INTO ces1613_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","A hnuvše se z Metka, položili se v Esmona. ");
INSERT INTO ces1613_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Z Esmona pak hnuvše se, položili se v Moserot. ");
INSERT INTO ces1613_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","A když se hnuli z Moserot, položili se v Benejakan. ");
INSERT INTO ces1613_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","A hnuvše se z Benejakan, položili se v Chor Gidgad. ");
INSERT INTO ces1613_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","A hnuvše se z Chor Gidgad, položili se v Jotbata. ");
INSERT INTO ces1613_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Když se pak hnuli z Jotbata, položili se v Habrona. ");
INSERT INTO ces1613_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","A z Habrona hnuvše se, položili se v Aziongaber. ");
INSERT INTO ces1613_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","A odtud hnuvše se, položili se na poušti Tsin, jenž jest Kádes. ");
INSERT INTO ces1613_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","A hnuvše se z Kádes, položili se na hoře řečené Hor, při končinách země Edomské. ");
INSERT INTO ces1613_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Tu vstoupil Aron kněz na horu, jenž slove Hor, k rozkazu Hospodinovu, a umřel tam, léta čtyřidcátého po vyjití synů Izraelských z země Egyptské, v první den měsíce pátého. ");
INSERT INTO ces1613_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","A byl Aron ve stu ve dvadcíti a třech letech, když umřel na hoře Hor. ");
INSERT INTO ces1613_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Uslyšel také Kananejský král v Arad, kterýž bydlil na poledne v zemi Kananejské, že by táhli synové Izraelští. ");
INSERT INTO ces1613_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Tedy hnuvše se s hory Hor, položili se v Salmona. ");
INSERT INTO ces1613_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","A hnuvše se z Salmona, položili se v Funon. ");
INSERT INTO ces1613_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Z Funon pak hnuvše se, položili se v Obot. ");
INSERT INTO ces1613_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","A když se hnuli z Obot, rozbili stany při pahrbcích hor Abarim, na pomezí Moábském. ");
INSERT INTO ces1613_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Potom hnuvše se od těch pahrbků, položili se v Dibongad. ");
INSERT INTO ces1613_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Z Dibongad hnuvše se, položili se v Helmondeblataim. ");
INSERT INTO ces1613_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","A když se hnuli z Helmondeblataim, položili se na horách Abarim proti Nébo. ");
INSERT INTO ces1613_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Odšedše pak z hor Abarim, položili se na rovinách Moábských, při Jordánu proti Jerichu. ");
INSERT INTO ces1613_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","A rozbili stany při Jordánu, od Betsimot až do Abelsetim, na rovinách Moábských. ");
INSERT INTO ces1613_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Mluvil pak Hospodin k Mojžíšovi na rovinách Moábských, při Jordánu naproti Jerichu, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Mluv k synům Izraelským a rci jim: Když přejdete Jordán, a vejdete do země Kananejské, ");
INSERT INTO ces1613_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Vyžeňte všecky obyvatele země té od tváři vaší, a zkazte všecky rytiny jejich; i všecky obrazy slité jejich zkazte, všecky také výsosti jejich zbořte. ");
INSERT INTO ces1613_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","A když vyženete obyvatele země, bydliti budete v ní; nebo vám jsem dal tu zemi, abyste jí dědičně vládli. ");
INSERT INTO ces1613_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Kteroužto rozdělíte sobě k dědictví losem, vedlé čeledí svých. Kterých jest více, těm větší dědictví dáte, kterých pak jest méně, těm menší dědictví dáte. Na kterém místě komu los padne, to jemu bude; podlé pokolení otců svých dědictví dosáhnete. ");
INSERT INTO ces1613_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Pakli nevyženete obyvatelů země od tváři své, tedy ti, kterýchž zanecháte, budou vám jako trní v očích vašich, a jako ostnové po bocích vašich, a budou vás ssužovati na zemi, na kteréž vy bydliti budete. ");
INSERT INTO ces1613_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","A na to přijde, abych to, což jsem jim umínil učiniti, vám učinil. ");
INSERT INTO ces1613_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mluvil také Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Přikaž synům Izraelským a rci jim: Když vejdete do země Kanán, (tať jest země, kteráž se dostane vám v dědictví, země Kananejská s pomezími svými), ");
INSERT INTO ces1613_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Strana polední vaše bude poušť Tsin vedlé pomezí Edomských; a bude vaše pomezí polední od břehu moře slaného k východu. ");
INSERT INTO ces1613_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","A zatočí se to pomezí polední k Maleakrabim, a půjde až k Tsin, a potáhne se od poledne přes Kádesbarne; a odtud vyjde ke vsi Addar, a vztáhne se až k Asmon. ");
INSERT INTO ces1613_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Od Asmon zatočí se pomezí to vůkol až ku potoku Egyptskému, a tu se skonávati bude k západu. ");
INSERT INTO ces1613_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Pomezí pak západní budete míti moře veliké; to bude vaše pomezí západní. ");
INSERT INTO ces1613_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","A pomezí půlnoční toto míti budete: Od moře velikého vyměříte sobě k hoře řečené Hor. ");
INSERT INTO ces1613_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Od hory Hor vyměříte sobě, až kde se vchází do Emat, a skonávati se bude pomezí to u Sedad. ");
INSERT INTO ces1613_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","A odtud půjde pomezí to k Zefronu, a konec jeho u vsi Enan; to bude pomezí vaše k straně půlnoční. ");
INSERT INTO ces1613_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Vyměříte sobě také pomezí k východu od vsi Enan až do Sefama. ");
INSERT INTO ces1613_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","A od Sefama schýlí se to pomezí až k Reblata, od východu maje Ain; a schýlí se pomezí to, a přijde k straně moře Ceneret k východu. ");
INSERT INTO ces1613_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","A vztáhne se to pomezí k Jordánu, a bude konec jeho u slaného moře. Ta země vaše bude po svých pomezích vůkol. ");
INSERT INTO ces1613_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Tedy oznámil to Mojžíš synům Izraelským, řka: Ta jest země, kterouž dědičně obdržíte losem, jakož přikázal Hospodin, abych ji dal devateru pokolení a polovici pokolení Manassesova. ");
INSERT INTO ces1613_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Nebo vzalo pokolení synů Ruben po domích otců svých, a pokolení synů Gád po domích otců svých, a polovice pokolení Manassesova vzali dědictví své. ");
INSERT INTO ces1613_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Půl třetího pokolení vzali dědictví své před Jordánem proti Jerichu, k straně na východ slunce. ");
INSERT INTO ces1613_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Mluvil opět Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Tato jsou jména mužů, kteříž v dědictví rozdělí vám zemi: Eleazar kněz, a Jozue, syn Nun. ");
INSERT INTO ces1613_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Kníže také jedno z každého pokolení vezmete k rozdělování dědictví země. ");
INSERT INTO ces1613_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","A tato jsou jména mužů: Z pokolení Juda Kálef, syn Jefonův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Z pokolení synů Simeon Samuel, syn Amiudův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Z pokolení Beniaminova Helidad, syn Chaselonův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Z pokolení synů Dan kníže Bukci, syn Jogli; ");
INSERT INTO ces1613_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Z synů Jozefových z pokolení synů Manasses kníže Haniel, syn Efodův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Z pokolení synů Efraim kníže Kamuel, syn Seftanův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","A z pokolení synů Zabulon kníže Elizafan, syn Farnachův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Z pokolení synů Izachar kníže Faltiel, syn Ozanův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","A z pokolení synů Asser kníže Ahiud, syn Salonův; ");
INSERT INTO ces1613_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","A z pokolení synů Neftalím kníže Fedael, syn Amiudův. ");
INSERT INTO ces1613_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ti jsou, jimž přikázal Hospodin, aby rozdělili země k dědictví synům Izraelským v zemi Kananejské. ");
INSERT INTO ces1613_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","I mluvil Hospodin k Mojžíšovi na rovinách Moábských, při Jordánu proti Jerichu, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Přikaž synům Izraelským, ať dadí Levítům z dědictví, kterýmž vládnouti budou, města k bydlení, i podměstí měst vůkol nich, ");
INSERT INTO ces1613_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Aby měli města k bydlení, podměstí pak jejich pro dobytky jejich, i pro statky jejich, a pro všecka hovada jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Podměstí pak měst, kteráž dáte Levítům, vzdálí budou ode zdi městské na tisíc loktů zevnitř vůkol. ");
INSERT INTO ces1613_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Protož vyměříte vně za každým městem na východ slunce dva tisíce loktů, na poledne též dva tisíce loktů, také na západ dva tisíce loktů, i na půlnoci dva tisíce loktů, tak aby bylo město v prostředku. Ta bude míra podměstí měst jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Z těch pak měst, kteráž dáte Levítům, oddělíte šest měst k útočišti, aby tam utekl, kdož by někoho zabil; a k těm přidáte jim ještě čtyřidceti dvě města. ");
INSERT INTO ces1613_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","I bude všech měst, kteráž dáte Levítům, čtyřidceti osm měst i s podměstími jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Těch pak měst, kteráž dáte z vládařství synů Izraelských, od těch, kteříž více mají, více vezmete, a od těch, kteříž méně mají, méně vezmete; jedno každé pokolení vedlé velikosti dědictví, jímž vládnouti budou, dá z měst svých Levítům. ");
INSERT INTO ces1613_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","I mluvil Hospodin k Mojžíšovi, řka: ");
INSERT INTO ces1613_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Mluv k synům Izraelským a rci jim: Když přejdete Jordán, a vejdete do země Kananejské, ");
INSERT INTO ces1613_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Vybéřete sobě města, a ta města budete míti k utíkání, aby tam utekl ten, kterýž by někoho zabil z nedopatření. ");
INSERT INTO ces1613_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","A budou vám ta města k útočišti před přítelem, aby neumřel ten, kdož zabil, dokudž by se nepostavil před shromážděním k soudu. ");
INSERT INTO ces1613_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Z těch tedy měst, kteráž dáte, šest měst k útočišti míti budete. ");
INSERT INTO ces1613_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Tři města dáte před Jordánem, též tři města dáte v zemi Kananejské; i budou města útočiště. ");
INSERT INTO ces1613_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Synům Izraelským i příchozímu, i podruhu mezi nimi bude těch šest měst k útočišti, aby tam utekl, kdož by koli ranil někoho z nedopatření. ");
INSERT INTO ces1613_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Jestliže by pak železem ranil někoho, tak až by umřel, vražedlník jest; smrtí umře vražedlník takový. ");
INSERT INTO ces1613_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Pakli by hodě kamenem, jímž by mohl zabiti, udeřil někoho, tak že by umřel, vražedlník jest; smrtí umře vražedlník takový. ");
INSERT INTO ces1613_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Pakli by hodě dřevem, kterýmž by mohl zabiti, udeřil někoho, tak že by umřel, vražedlník jest; smrtí umře vražedlník takový. ");
INSERT INTO ces1613_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Přítel zabitého zabije vražedlníka toho; kdyžkoli ho dostane, on sám zabije ho. ");
INSERT INTO ces1613_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Aneb jestliže by z nenávisti strčil někým, aneb shodil by něco na něho z úkladu, tak že by od toho umřel; ");
INSERT INTO ces1613_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","Aneb jestliže by z nepřátelství rukou udeřil někoho, tak že by umřel: smrtí umře bitec ten, vražedlník jest; přítel zabitého zabije vražedlníka toho, jakž ho nejprv dostane. ");
INSERT INTO ces1613_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Jestliže by pak náhodou a ne z nepřátelství strčil někým, aneb shodil by na něho nějakou věc bez úkladu; ");
INSERT INTO ces1613_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","Aneb jaký koli kámen, od něhož by umříti mohl, shodil by na něj z nedopatření, tak že by umřel, nebyv s ním v nepřátelství, ani nehledaje zlého jeho: ");
INSERT INTO ces1613_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Tedy souditi bude shromáždění mezi bitcem a mezi přítelem zabitého vedlé soudů těchto. ");
INSERT INTO ces1613_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","A vysvobodí shromáždění vražedlníka toho z rukou přítele zabitého, a káže se jemu navrátiti shromáždění k městu útočiště jeho, do něhož utekl; i bude bydliti v něm, dokudž neumře kněz nejvyšší, kterýž pomazán jest olejem svatým. ");
INSERT INTO ces1613_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Jestliže by pak ten, kterýž zabil člověka, vyšel z mezí města útočiště svého, do něhož utekl, ");
INSERT INTO ces1613_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","A přítel zabitého našel by jej vně, an přešel meze města útočiště svého, a zabil by přítel zabitého vražedlníka toho, nebude vinen krví. ");
INSERT INTO ces1613_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Nebo v městě útočiště svého bydliti má, dokudž by neumřel kněz nejvyšší. Když by pak umřel kněz nejvyšší, navrátí se vražedlník do země vládařství svého. ");
INSERT INTO ces1613_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","A bude vám toto za ustanovení soudné v pronárodech vašich, ve všech příbytcích vašich. ");
INSERT INTO ces1613_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Kdož by koli měl na smrt vydati někoho, podlé vyznání svědků sáhne na vražedlníka; ale jeden svědek nebude moci svědčiti proti někomu na smrt. ");
INSERT INTO ces1613_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Nevezmete pak výplaty za člověka vražedlníka, kterýž, jsa nešlechetný, jest smrti hoden, než smrtí ať umře. ");
INSERT INTO ces1613_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Aniž také vezmete výplaty od toho, kterýž utekl do města útočiště svého, aby se navrátil k bydlení do země své, prvé než by umřel kněz, ");
INSERT INTO ces1613_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Abyste nepoškvrnili země, v níž jste. Nebo krev taková poškvrnila by země, aniž také země očištěna býti může od krve, kteráž jest vylita na ní, jediné krví toho, kterýž vylil ji. ");
INSERT INTO ces1613_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Protož nepoškvrňujte země, v kteréž bydlíte, kdežto já přebývám; nebo já Hospodin přebývám u prostřed synů Izraelských. ");
INSERT INTO ces1613_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Přistoupili pak starší z čeledi synů Galád, syna Machir, syna Manassesova, z čeledi synů Jozefových, a mluvili před Mojžíšem a před knížaty předními z synů Izraelských, ");
INSERT INTO ces1613_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","A řekli: Tobě pánu mému přikázal Hospodin, abys losem dal zemi v dědictví synům Izraelským; přikázáno jest také pánu mému od Hospodina, aby dal dědictví Salfada, bratra našeho, dcerám jeho. ");
INSERT INTO ces1613_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Kteréž jestliže někomu z pokolení synů Izraelských, kromě z pokolení svého, dány budou za manželky, odejde dědictví jejich od dědictví otců našich, a přidáno bude k dědictví pokolení toho, do kteréhož by se vdaly, a tak z losu dědictví našeho ubude. ");
INSERT INTO ces1613_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","A když budou míti synové Izraelští léto milostivé, připojeno bude dědictví jejich k dědictví pokolení toho, do kteréhož by se vdaly, a tak od dědictví pokolení otců našich odtrženo bude dědictví jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Tedy přikázal Mojžíš synům Izraelským podlé řeči Hospodinovy, řka: Dobře pokolení synů Jozefových mluví. ");
INSERT INTO ces1613_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","To jest, což přikázal Hospodin o dcerách Salfadových, řka: Za kohož se jim líbiti bude, nechť se vdadí, však v čeledi domu otce svého ať se vdávají, ");
INSERT INTO ces1613_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Aby nebylo přenášíno dědictví synů Izraelských z pokolení na pokolení; nebo synové Izraelští jeden každý přídržeti se bude dědictví pokolení otců svých. ");
INSERT INTO ces1613_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","A každá dcera z pokolení synů Izraelských, kteráž by měla dědictví, za někoho z čeledi pokolení otce svého vdá se, aby vládli synové Izraelští jeden každý dědictvím otců svých, ");
INSERT INTO ces1613_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Aby nebylo přenášíno vládařství z jednoho pokolení na druhé pokolení, ale jeden každý z pokolení synů Izraelských dědictví svého přídržeti se bude. ");
INSERT INTO ces1613_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Jakož přikázal Hospodin Mojžíšovi, tak učinily dcery Salfadovy. ");
INSERT INTO ces1613_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Nebo Mahla, Tersa a Hegla, Melcha a Noa, dcery Salfad, vdaly se za syny strýců svých. ");
INSERT INTO ces1613_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Do čeledi synů Manasse, syna Jozefova, vdaly se, a zůstalo dědictví jejich při pokolení čeledi otce jejich. ");
INSERT INTO ces1613_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Tato jsou přikázaní a soudové, kteréž přikázal Hospodin skrze Mojžíše synům Izraelským, na rovinách Moábských, při Jordánu proti Jerichu. ");
INSERT INTO ces1613_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Tato jsou slova, kteráž mluvil Mojžíš ke všemu lidu Izraelskému před Jordánem na poušti, na rovinách proti moři Rudému, mezi Fáran a Tofel a Lában a Hazerot a Dizahab. ");
INSERT INTO ces1613_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Jedenácte dní cesty jest od Oréb přes hory Seir až do Kádesbarne. ");
INSERT INTO ces1613_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Stalo se pak čtyřidcátého léta, jedenáctého měsíce, v první den téhož měsíce, že mluvil Mojžíš synům Izraelským všecky věci, kteréž jemu byl přikázal Hospodin oznámiti jim, ");
INSERT INTO ces1613_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Kdyžto již byl zabil Seona, krále Amorejského, kterýž bydlil v Ezebon, a Oga, krále Bázan, kterýž bydlil v Astarot, zabil v Edrei. ");
INSERT INTO ces1613_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Před Jordánem, v zemi Moábské, počal Mojžíš vysvětlovati zákona tohoto, řka: ");
INSERT INTO ces1613_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Hospodin Bůh náš mluvil k nám na Orébě, řka: Dosti jste již na hoře této bydlili. ");
INSERT INTO ces1613_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Obraťte se, táhněte a jděte k hoře Amorejských, na všecko vůkolí její, buď na roviny, na hory, na údolí, na poledne, i na břehy mořské, k zemi Kananejské a k Libánu, až k řece veliké, k řece Eufrates. ");
INSERT INTO ces1613_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ej, ukázal jsem vám tu zemi; vejdětež do ní, a dědičně vládněte jí, kterouž s přísahou zaslíbil dáti Hospodin otcům vašim, Abrahamovi, Izákovi a Jákobovi, i semeni jejich po nich. ");
INSERT INTO ces1613_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","A mluvil jsem k vám toho času, řka: Nemohuť sám nésti vás. ");
INSERT INTO ces1613_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Hospodin Bůh váš rozmnožil vás, a hle, rozmnoženi jste dnes jako hvězdy nebeské. ");
INSERT INTO ces1613_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","(Hospodin Bůh otců vašich rozmnožiž vás nad to, jakž jste nyní, tisíckrát více, a požehnej vám, jakož jest mluvil vám.) ");
INSERT INTO ces1613_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kterak bych nesl sám práci vaši, břímě vaše a nesnáze vaše? ");
INSERT INTO ces1613_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Vydejte z sebe muže moudré a opatrné, a zkušené z pokolení svých, abych je vám představil. ");
INSERT INTO ces1613_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","I odpověděli jste mi a řekli jste: Dobráť jest ta věc, kterouž jsi učiniti rozkázal. ");
INSERT INTO ces1613_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Vzav tedy přední z pokolení vašich, muže moudré a zkušené, ustanovil jsem je knížaty nad vámi, hejtmany nad tisíci, setníky, padesátníky, desátníky a správce v pokoleních vašich. ");
INSERT INTO ces1613_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Přikázal jsem také soudcům vašim toho času, řka: Vyslýchejte pře mezi bratřími svými, a suďte spravedlivě mezi mužem a bratrem jeho, i mezi příchozím jeho. ");
INSERT INTO ces1613_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Nebudete přijímati osoby v soudu; jakž malého tak i velikého slyšeti budete, nebudete se báti žádného, nebo Boží soud jest. Jestliže byste pak měli jakou věc nesnadnou, vznesete na mne, a vyslyším ji. ");
INSERT INTO ces1613_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Přikázal jsem vám, pravím, toho času všecko, co byste činiti měli. ");
INSERT INTO ces1613_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Potom pak hnuvše se z Oréb, přešli jsme všecku poušť tuto velikou a hroznou, kterouž jste viděli, jdouce cestou k hoře Amorejských, jakož nám byl přikázal Hospodin Bůh náš, a přišli jsme až do Kádesbarne. ");
INSERT INTO ces1613_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","I řekl jsem vám: Přišli jste až k hoře Amorejské, kterouž Hospodin Bůh náš dává nám. ");
INSERT INTO ces1613_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ej, dal Hospodin Bůh tvůj tu zemi tobě; vstupiž a vládni jí, jakož řekl Hospodin Bůh otců tvých tobě; neboj se, aniž se strachuj. ");
INSERT INTO ces1613_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Vy pak všickni přistoupili jste ke mně a řekli jste: Pošleme muže před sebou, kteříž by nám shlédli zemi, a oznámili by nám něco o cestě, kterouž bychom vstoupiti měli, i města, do nichž bychom přijíti měli. ");
INSERT INTO ces1613_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Kterážto řeč líbila se mně, a vzal jsem z vás dvanácte mužů, jednoho muže z každého pokolení. ");
INSERT INTO ces1613_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","A oni obrátivše se a vstoupivše na horu, přišli až k údolí Eškol a shlédli zemi. ");
INSERT INTO ces1613_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Nabrali také s sebou ovoce země té, a přinesli nám, a oznámili nám o těch věcech, řkouce: Dobráť jest země, kterouž Hospodin Bůh náš dává nám. ");
INSERT INTO ces1613_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","A však jste nechtěli jíti, ale odpírali jste řeči Hospodina Boha svého. ");
INSERT INTO ces1613_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","A reptali jste v staních svých, řkouce: Proto že nás v nenávisti měl Hospodin, vyvedl nás z země Egyptské, aby nás vydal v ruce Amorejského, a zahladil nás. ");
INSERT INTO ces1613_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Kam bychom šli? Bratří naši zstrašili srdce naše, pravíce: Lid ten jest větší a vyšší nežli my, města veliká a hrazená až k nebi, ano i syny Enakovy tam jsme viděli. ");
INSERT INTO ces1613_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","I řekl jsem vám: Nebojte se, ani se strachujte jich. ");
INSERT INTO ces1613_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Hospodin Bůh váš, kterýž jde před vámi, onť bojovati bude za vás rovně tak, jakž učinil s vámi v Egyptě, před očima vašima. ");
INSERT INTO ces1613_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Ano i na poušti viděl jsi, kterak nesl tebe Hospodin Bůh tvůj, jako nosí člověk syna svého, a to po vší cestě, kterouž jste šli, až jste přišli na toto místo. ");
INSERT INTO ces1613_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","A ani tak uvěřili jste Hospodinu Bohu svému, ");
INSERT INTO ces1613_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Kterýž k vyhledání vám místa, na kterémž byste se klásti měli, v noci předcházel vás cestou v ohni, aby vám ukázal cestu, kterouž byste měli jíti, a v oblace ve dne. ");
INSERT INTO ces1613_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Uslyšel pak Hospodin hlas řečí vašich, a rozhněval se, a přisáhl, řka: ");
INSERT INTO ces1613_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Jistě že nižádný z lidí těchto pokolení zlého neuzří země té dobré, kterouž jsem s přísahou zaslíbil dáti otcům vašim, ");
INSERT INTO ces1613_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Kromě Kálefa, syna Jefonova; tenť ji uzří, a jemu dám zemi, po níž chodil, i synům jeho, proto že cele následoval Hospodina. ");
INSERT INTO ces1613_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Ano i na mne rozhněval se Hospodin příčinou vaší, řka: Také ani ty nevejdeš tam. ");
INSERT INTO ces1613_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Jozue, syn Nun, kterýž stojí před tebou, onť vejde tam, jeho posilň, nebo on rozdělí ji losem Izraelovi. ");
INSERT INTO ces1613_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","A dítky vaše, o kterýchž jste pravili, že v loupež budou, a synové vaši, kteříž ještě neznají dobrého ani zlého, oni vejdou do ní, a jim dám ji; oni dědičně ji obdrží. ");
INSERT INTO ces1613_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Vy pak obrátíce se, jděte na poušť cestou k moři Rudému. ");
INSERT INTO ces1613_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","A odpověděvše, řekli jste ke mně: Zhřešiliť jsme Hospodinu. My vstoupíme a budeme bojovati podlé toho všeho, jakž rozkázal nám Hospodin Bůh náš. A vzavše všickni odění svá válečná na sebe, hotovi jste byli vstoupiti na horu. ");
INSERT INTO ces1613_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Hospodin pak řekl mi: Rci jim: Nevstupujte a nebojujte, neboť nejsem u prostřed vás, abyste nebyli poraženi před nepřátely svými. ");
INSERT INTO ces1613_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","A když jsem vám to mluvil, neuposlechli jste, nýbrž odporni jste byli řeči Hospodinově, a všetečně vstoupili jste na horu. ");
INSERT INTO ces1613_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Tedy vytáhl Amorejský, kterýž bydlil na té hoře, proti vám, a honili vás, jako činívají včely, a potřeli vás na hoře Seir až do Horma. ");
INSERT INTO ces1613_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","A navrátivše se, plakali jste před Hospodinem, ale neuslyšel Hospodin hlasu vašeho, a uší svých nenaklonil k vám. ");
INSERT INTO ces1613_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","I zůstali jste v Kádes za mnohé dny, podlé počtu dnů, v nichž jste tam byli. ");
INSERT INTO ces1613_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Potom obrátivše se, táhli jsme na tu poušť cestou k moři Rudému, jakož mluvil Hospodin ke mně, a obcházeli jsme horu Seir za dlouhý čas, ");
INSERT INTO ces1613_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Až mi řekl Hospodin takto: ");
INSERT INTO ces1613_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Dosti jste již obcházeli horu tuto, obraťtež se k straně půlnoční. ");
INSERT INTO ces1613_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","A lidu přikaž, řka: Půjdete přes pomezí bratří svých synů Ezau, kteříž bydlí v Seir. Ačkoli budou se vás báti, hleďte však pilně, ");
INSERT INTO ces1613_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Abyste jich nedráždili; nebo nedám vám z země jejich ani šlepěje nožné, proto že v dědictví Ezau dal jsem horu Seir. ");
INSERT INTO ces1613_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Pokrmů koupíte od nich za peníze, a jísti budete, i vody také ku pití za peníze od nich jednati budete. ");
INSERT INTO ces1613_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Nebo Hospodin Bůh tvůj požehnal tobě při všeliké práci rukou tvých, a zná, že jdeš přes poušť velikou tuto; již čtyřidceti let Hospodin Bůh tvůj byl s tebou, aniž jsi měl v čem nedostatku. ");
INSERT INTO ces1613_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","A šli jsme od bratří našich, synů Ezau, kteříž bydlí v Seir, s cesty polní od Elat a od Aziongaber, a uchýlili jsme se, abychom šli cestou po poušti Moábské. ");
INSERT INTO ces1613_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","I řekl mi Hospodin: Neškoď Moábským, ani jich popouzej k boji, nebo nedám tobě v zemi jejich dědictví, poněvadž synům Lot dal jsem Ar v dědictví. ");
INSERT INTO ces1613_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Emim prvé bydlili v ní, lid veliký a mnohý, a vysokého zrostu, jako Enakim. ");
INSERT INTO ces1613_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Oni také za obry držáni byli jako Enakim, ale Moábští říkali jim Emim. ");
INSERT INTO ces1613_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","V Seir pak bydlili prvé Horejští, kteréž synové Ezau vyhnali, a zahladili je před tváří svou, a bydlili tu místo nich, jako učinil Izrael v zemi vládařství svého, kterouž jim dal Hospodin.) ");
INSERT INTO ces1613_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Nyní vstanouce, přejděte potok Záred. I přešli jsme potok Záred. ");
INSERT INTO ces1613_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Èasu pak, v němž jsme šli z Kádesbarne, až jsme přešli potok Záred, bylo let třidceti osm, dokavadž nebyl vyhlazen všecken věk mužů bojovných z prostřed stanů, jakož jim přisáhl Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Nebo ruka Hospodinova byla proti nim k setření jich z prostředku stanů, dokudž nevyhladil jich. ");
INSERT INTO ces1613_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","I stalo se, když všickni muži ti bojovní vyhynuli z prostředku lidu, ");
INSERT INTO ces1613_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Že mluvil Hospodin ke mně, řka: ");
INSERT INTO ces1613_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Ty přejdeš dnes pomezí Moábské k městu Ar, ");
INSERT INTO ces1613_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","A přiblížíš se k synům Ammon. Nessužujž jich a nepopouzej jich k boji, nebo nedám tobě v zemi synů Ammon dědictví, poněvadž synům Lotovým dal jsem ji k vládařství. ");
INSERT INTO ces1613_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(I ona také držána byla za zemi obrů; nebo obrové před tím bydlili v ní, kterýmž Ammoninští říkali Zamzomim, ");
INSERT INTO ces1613_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Lid veliký a mnohý, a vysokého zrostu, jako Enakim. Ale zahladil je Hospodin před tváří jejich, a vešli v dědictví jejich, a bydlili na místě jejich, ");
INSERT INTO ces1613_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Jakož učinil synům Ezau bydlícím v Seir, pro něž vyhladil Horejské před tváří jejich, i vešli v dědictví jejich, a bydlili na místě jejich až do dnešního dne. ");
INSERT INTO ces1613_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Hevejské také, kteříž bydlili v Azerim až do Gáza, Kaftorejští, kteříž vyšli z Kaftor, zahladili je, a bydlili na místě jejich.) ");
INSERT INTO ces1613_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Vstanouce, beřte se a přejděte potok Arnon. Hle, dal jsem v ruce tvé Seona, krále Ezebon Amorejského, a zemi jeho; začniž jí vládnouti, a bojuj válečně proti němu. ");
INSERT INTO ces1613_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Dnes počnu pouštěti strach a lekání se tebe na lidi, kteříž jsou pode vším nebem, tak že kteřížkoli uslyší pověst o tobě, třásti a lekati se budou tváři tvé. ");
INSERT INTO ces1613_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","I poslal jsem posly z pouště Kedemot k Seonovi, králi Ezebon, s slovy pokojnými, řka: ");
INSERT INTO ces1613_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Nechť projdu skrze zemi tvou, přímo cestou půjdu, neuchýlím se ani na pravo ani na levo. ");
INSERT INTO ces1613_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Pokrmů za peníze prodáš mi, abych jedl, vody také za peníze dáš mi, a píti budu; toliko pěšky projdu, ");
INSERT INTO ces1613_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Jakož mi učinili synové Ezau, kteříž bydlí v Seir, a Moábští, kteříž bydlí v Ar, dokudž nepřejdu Jordánu, jda k zemi, kterouž Hospodin Bůh náš dává nám. ");
INSERT INTO ces1613_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ale nechtěl dopustiti Seon, král Ezebon, abychom prošli zemi jeho; nebo byl zatvrdil Hospodin Bůh tvůj ducha jeho, a ztužil srdce jeho, aby dal jej v ruce tvé, jakož se vidí podnes. ");
INSERT INTO ces1613_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","(Nebo řekl mi byl Hospodin: Aj, již jsem počal v moc dávati tobě Seona i zemi jeho; začniž jí vládnouti, abys dědičně obdržel zemi jeho.) ");
INSERT INTO ces1613_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","A vytáhl byl Seon proti nám, on i všecken lid jeho k boji do Jasa. ");
INSERT INTO ces1613_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","I dal jej nám Hospodin Bůh náš, a porazili jsme ho s syny jeho i se vším lidem jeho. ");
INSERT INTO ces1613_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Vzali jsme také toho času všecka města jeho, a dali jsme v prokletí lid těch všech měst, i ženy i děti, žádného nepozůstavivše. ");
INSERT INTO ces1613_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Toliko hovada rozebrali jsme sobě, a kořisti z měst, kterýchž jsme dobyli. ");
INSERT INTO ces1613_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Od Aroer jenž jest na břehu potoka Arnon, a od města, kteréž jest v údolí, až do Galád nebylo města, kteréž by ostáti mohlo před námi; všecka nám dal Hospodin Bůh náš. ");
INSERT INTO ces1613_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Toliko k zemi synů Ammon nepřiblížils se, ani k žádné krajině ležící při potoku Jabok, ani k městům na horách, a k žádnému místu, kteréž zapověděl Hospodin Bůh náš. ");
INSERT INTO ces1613_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Potom obrátivše se, táhli jsme cestou k Bázan. I vytáhl Og, král Bázan, proti nám, on i všecken lid jeho k bitvě do Edrei. ");
INSERT INTO ces1613_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","I řekl mi Hospodin: Neboj se ho, nebo v ruce tvé dal jsem jej, i všecken lid jeho i zemi jeho, a učiníš jemu tak, jako jsi učinil Seonovi, králi Amorejskému, kterýž bydlil v Ezebon. ");
INSERT INTO ces1613_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Dal tedy Hospodin Bůh náš v ruce naše i Oga, krále Bázan, a všecken lid jeho, i porazili jsme jej, tak že jsme nepozůstavili po něm žádného živého. ");
INSERT INTO ces1613_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Dobyli jsme také téhož času všech měst jeho; nebylo města, kteréhož bychom jim neodjali, šedesáte měst, všecku krajinu Argob, království Oga v Bázan. ");
INSERT INTO ces1613_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Všecka ta města byla ohražená zdmi vysokými, branami a závorami, kromě měst otevřených, jichž bylo velmi mnoho. ");
INSERT INTO ces1613_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","A vyplénili jsme je, jako jsme učinili Seonovi, králi Ezebon, vyhladivše všecka města, muže, ženy i dítky. ");
INSERT INTO ces1613_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Všecka pak hovada a kořisti měst rozebrali jsme sobě. ");
INSERT INTO ces1613_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Vzali jsme také téhož času zemi z ruky dvou králů Amorejských, kteráž byla před Jordánem, od potoku Arnon až k hoře Hermon, ");
INSERT INTO ces1613_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sidonští říkají Hermonu Sarion, a Amorejští říkají jemu Sanir), ");
INSERT INTO ces1613_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Všecka města v kraji, a všecken Galád, a všecken Bázan až do Sálecha a Edrei, kteráž byla města království Og v Bázan. ");
INSERT INTO ces1613_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Sám toliko Og, král v Bázan, z jiných obrů byl pozůstal. Aj, lůže jeho, lůže železné, ještě zůstává v Rabbat synů Ammon, devíti loktů zdýlí, a čtyř loket zšíří, jakž jest loket muže. ");
INSERT INTO ces1613_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Když tedy zemi tu obdrželi jsme dědičně toho času, krajinu od Aroer, jenž jest při potoku Arnon, a polovici hory Galád i města její, dal jsem pokolení Ruben a Gád. ");
INSERT INTO ces1613_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ostatek pak Galád a všecku zemi Bázan, království Oga, dal jsem polovici pokolení Manassesova, totiž všecku krajinu Argob, všecku Bázan, kteráž sloula země obrů. ");
INSERT INTO ces1613_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair, syn Manasse, vzal všecku krajinu Argob, až ku pomezí Gessuri a Machati; pročež nazval zemi Bázan od jména svého Havot Jair až do dnešního dne. ");
INSERT INTO ces1613_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Machirovi pak dal jsem Galád. ");
INSERT INTO ces1613_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","A Rubenovu a Gádovu pokolení dal jsem krajinu od Galád až ku potoku Arnon, polovici potoka s pomezím až ku potoku Jabok, kdež jsou hranice synů Ammonitských, ");
INSERT INTO ces1613_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","A roviny tyto i Jordán s pomezím od Ceneret až k moři pustému, jenž jest moře slané, ležící pod horou Fazga k východu. ");
INSERT INTO ces1613_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","A přikázal jsem vám toho času, řka: Hospodin Bůh váš dal vám zemi tuto, abyste ji dědičně obdrželi; vezmouce odění na sebe, půjdete před bratřími vašimi, syny Izraelskými, kteřížkoli silní jste. ");
INSERT INTO ces1613_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Toliko ženy vaše a dítky vaše, a dobytek váš, (nebo vím, že mnoho dobytka máte,) zůstanou v městech vašich, kteráž jsem dal vám, ");
INSERT INTO ces1613_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Dokudž by nedal odpočinutí Hospodin bratřím vašim jako i vám, aby i oni dědičně obdrželi zemi, kterouž Hospodin Bůh váš dává jim za Jordánem; tedy navrátíte se jeden každý k dědictví svému, kteréž jsem dal vám. ");
INSERT INTO ces1613_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Také i Jozue přikázal jsem toho času, řka: Oči tvé vidí všecko, co učinil Hospodin Bůh váš těm dvěma králům; takť učiní Hospodin všechněm královstvím, do kterýchž ty půjdeš. ");
INSERT INTO ces1613_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Nebojtež se jich, nebo Hospodin Bůh váš, onť jest, kterýž bojuje za vás. ");
INSERT INTO ces1613_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","A tehdáž prosil jsem Hospodina, řka: ");
INSERT INTO ces1613_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Panovníče Hospodine, ty jsi počal ukazovati služebníku svému velikost svou a ruku svou přesilnou; nebo kdo jest Bůh silný na nebi aneb na zemi, ješto by činiti mohl skutky podobné tvým, a moci podobné tobě? ");
INSERT INTO ces1613_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Prosím, nechť vejdu a uzřím zemi tu výbornou, kteráž jest za Jordánem, horu tu výbornou i Libán. ");
INSERT INTO ces1613_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Pohnul se pak Hospodin na mne pro vás a neuslyšel mne, ale řekl mi: Dosti máš, nemluv více o to se mnou. ");
INSERT INTO ces1613_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Vstup na vrch hory Fazga, a pozdvihna očí svých k západu a k půlnoci, ku poledni i k východu, hleď očima svýma; nebo nepřejdeš Jordánu tohoto. ");
INSERT INTO ces1613_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ale přikaž Jozue, a posilň ho, i potvrď ho; nebo půjde před lidem tímto, a on uvede jim v dědictví zemi, kterouž uzříš. ");
INSERT INTO ces1613_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","I zůstali jsme v údolí naproti Betfegor. ");
INSERT INTO ces1613_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Nyní tedy, ó Izraeli, slyš ustanovení a soudy, kteréž já učím vás činiti, abyste živi byli, a vejdouce, dědičně vládli zemí, kterouž Hospodin Bůh otců vašich vám dává. ");
INSERT INTO ces1613_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Nepřidáte nic k slovu, kteréž já přikazuji vám, aniž co ujmete od něho, abyste tak přikázaní Hospodina Boha svého, kteréž já přikazuji vám, zachovali. ");
INSERT INTO ces1613_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Oči vaše viděly, co učinil Hospodin pro Belfegor, jak všecky lidi, kteříž odešli po Belfegor, vyhladil Hospodin Bůh tvůj z prostředku tvého. ");
INSERT INTO ces1613_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Vy pak, přídržející se Hospodina Boha vašeho, živi jste do dnešního dne všickni. ");
INSERT INTO ces1613_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Viztež, učilť jsem vás ustanovením a soudům, jakž mi přikázal Hospodin Bůh můj, abyste tak činili v zemi, do kteréž vejdete k dědičnému držení jí. ");
INSERT INTO ces1613_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ostříhejtež tedy a čiňte je, nebo to jest moudrost vaše a opatrnost vaše před očima národů, kteříž, slyšíce všecka ustanovení tato, řeknou: Jistě lid moudrý a rozumný národ veliký tento jest. ");
INSERT INTO ces1613_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Nebo který národ tak veliký jest, kterýž by měl bohy sobě tak blízké, jako jest Hospodin Bůh váš ve všem volání našem k němu? ");
INSERT INTO ces1613_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","A který jest národ tak veliký, kterýž by měl ustanovení a soudy spravedlivé, jako jest všecken zákon tento, kterýž já vám dnes předkládám? ");
INSERT INTO ces1613_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","A však hleď se a bedlivě ostříhej duše své, abys nezapomenul na ty věci, kteréž viděly oči tvé, a aby nevyšly z srdce tvého po všecky dny života tvého; a v známost je uvedeš synům i vnukům svým. ");
INSERT INTO ces1613_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","A nezapomínej, že jsi onoho dne stál před Hospodinem Bohem svým na Orébě, když mi byl řekl Hospodin: Shromažď mi lid, ať jim předložím slova má, z nichž by se učili mne báti po všecky dny, dokudž živi budou na zemi, a témuž aby syny své učili. ");
INSERT INTO ces1613_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Tedy přistoupili jste, a stáli jste pod horou; (hora pak ta hořela ohněm až do samého nebe, a byly na ní tmy, oblak a mrákota.) ");
INSERT INTO ces1613_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","I mluvil k vám Hospodin z prostředku ohně. Hlas slov slyšeli jste, ale obrazu žádného jste neviděli kromě hlasu, ");
INSERT INTO ces1613_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Jímž vyhlásil vám smlouvu svou, kteréžto přikázal vám ostříhati, totiž desíti slov, a napsal je na dvou dskách kamenných. ");
INSERT INTO ces1613_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Mně také přikázal Hospodin toho času, abych učil vás ustanovením a soudům, abyste činili je v zemi, do kteréž jdete k dědičnému držení jí. ");
INSERT INTO ces1613_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Protož pilně pečujte o duše své, (nebo neviděli jste žádného obrazu toho dne, když k vám mluvil Hospodin na Orébě z prostředku ohně), ");
INSERT INTO ces1613_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Abyste neporušili cesty své, a neučinili sobě rytiny aneb podobenství nějakého obrazu, tvárnosti muže neb ženy, ");
INSERT INTO ces1613_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Podobenství nějakého hovada, kteréž jest na zemi, aneb podobenství jakéhokoli ptáka křídla majícího, kterýž létá v povětří, ");
INSERT INTO ces1613_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","Podobenství jakéhokoli zeměplazu na zemi, aneb podobenství jakékoli ryby, kteráž jest u vodě pod zemí. ");
INSERT INTO ces1613_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ani pozdvihuj očí svých k nebi, abys, vida slunce a měsíc, i hvězdy se vším zástupem nebeským a ponuknut jsa, klaněl bys se jim a sloužil bys jim, ješto ty věci oddal Hospodin Bůh tvůj všechněm lidem pode vším nebem, ");
INSERT INTO ces1613_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Vás pak vzal Hospodin, a vyvedl vás jako z peci železné z Egypta, abyste byli jeho lid dědičný, jako jste dne tohoto. ");
INSERT INTO ces1613_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ale na mne rozhněval se Hospodin příčinou vaší, a přisáhl, že nepřejdu Jordánu, ani nevejdu do země té výborné, kterouž Hospodin Bůh tvůj dává tobě v dědictví. ");
INSERT INTO ces1613_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Nebo já umru v zemi této, a nepřejdu Jordánu, vy pak přejdete, a dědičně obdržíte zemi tu výbornou. ");
INSERT INTO ces1613_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Hleďtež, abyste se nezapomínali na smlouvu Hospodina Boha svého, kterouž učinil s vámi, a nečinili sobě rytiny, aneb obrazu jakékoli věci, jakož přikázal tobě Hospodin Bůh tvůj. ");
INSERT INTO ces1613_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Nebo Hospodin Bůh tvůj jest oheň sžírající, Bůh silný, horlivý. ");
INSERT INTO ces1613_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Když zplodíš syny a vnuky, a zstaráte se v zemi té, jestliže porušíte cestu svou, a uděláte rytinu ku podobenství jakékoli věci, aneb učiníte něco zlého před očima Hospodina Boha svého, popouzejíce ho: ");
INSERT INTO ces1613_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Osvědčuji proti vám dnes před nebem i zemí, že hrozně a rychle vyhlazeni budete z země, do kteréž půjdete přes Jordán, abyste vládli jí. Nedlouho bydliti budete v ní, ale do konce vyhlazeni budete. ");
INSERT INTO ces1613_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","A rozptýlí vás Hospodin mezi národy, a maličký počet vás zůstane mezi pohany, do kterýchž zavede vás Hospodin, ");
INSERT INTO ces1613_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","A sloužiti tam budete bohům, dílu rukou lidských, dřevu a kameni, ješto nevidí ani slyší, ani jedí, ani čijí. ");
INSERT INTO ces1613_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Jestliže pak i tam hledati budeš Hospodina Boha svého, tedy nalezneš, budeš-li ho hledati z celého srdce svého a z celé duše své. ");
INSERT INTO ces1613_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Kdyžť úzko bude, a přijdou na tě všecky ty věci, naposledy však, jestliže bys se navrátil k Hospodinu Bohu svému, a poslouchal bys hlasu jeho, ");
INSERT INTO ces1613_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","(Poněvadž Hospodin Bůh tvůj jest Bůh silný, milosrdný,) neopustí tebe, ani tě nezkazí, ani zapomene se na smlouvu otců tvých, kterouž s přísahou utvrdil jim. ");
INSERT INTO ces1613_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Nebo ptej se nyní na dni staré, kteříž byli před tebou, od toho dne, v kterémž stvořil Bůh člověka na zemi, a od jednoho kraje nebe až do druhého, stala-li se kdy věc podobná této tak veliké, aneb slýcháno-li kdy co takového? ");
INSERT INTO ces1613_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Zdali kdy slyšel který lid hlas Boha mluvícího z prostředku ohně, jako jsi ty slyšel a živ zůstal? ");
INSERT INTO ces1613_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Aneb zdali se kdy který Bůh pokusil, aby přijda, vzal sobě národ některý z jiného národu s zkušováním, znameními a s zázraky, skrze boje a ruku silnou, v rameni vztaženém a v hrůzi veliké, jako učinil všecko toto pro vás Hospodin Bůh váš v Egyptě před očima vašima? ");
INSERT INTO ces1613_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Toběť jest to ukázáno, abys věděl, že Hospodin jest Bůh, a že není jiného kromě něho. ");
INSERT INTO ces1613_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Dalť s nebe slyšeti hlas svůj, aby vyučil tebe, a na zemi ukázal tobě oheň svůj veliký, a slova jeho slyšel jsi z prostředku ohně. ");
INSERT INTO ces1613_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Proto že miloval otce tvé, vyvolil símě jejich po nich, a vyvedl tě před sebou mocí svou velikou z Egypta, ");
INSERT INTO ces1613_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Aby vyžena národy veliké a silnější, než jsi ty, před tváří tvou, uvedl tebe a dal tobě zemi jejich v dědictví, jakož dnes vidíš. ");
INSERT INTO ces1613_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Věziž tedy dnes a obnov to v srdci svém, že Hospodin jest Bůh na nebi svrchu i na zemi dole, a není žádného jiného. ");
INSERT INTO ces1613_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Protož ostříhej po všecky dny ustanovení a přikázaní jeho, kteráž já dnes přikazuji tobě, aby dobře bylo tobě i synům tvým po tobě, a abys prodlil dnů v zemi, kterouž Hospodin Bůh tvůj dá tobě. ");
INSERT INTO ces1613_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Tehdy oddělil Mojžíš tři města před Jordánem k východu slunce. ");
INSERT INTO ces1613_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Aby utekl do nich vražedlník, kterýž by zabil bližního svého nechtě, a neměl by ho před tím v nenávisti; když by utekl do jednoho z těch měst, aby živ zůstal: ");
INSERT INTO ces1613_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Bozor na poušti, na rovinách v kraji Rubenitských, a Rámot v Galád, v pokolení Gád, a Golan v Bázan, v pokolení Manasse. ");
INSERT INTO ces1613_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ten jest zákon, kterýž předložil Mojžíš synům Izraelským, ");
INSERT INTO ces1613_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","A tato jsou svědectví a ustanovení i soudové, kteréž předložil Mojžíš synům Izraelským, když vyšli z Egypta, ");
INSERT INTO ces1613_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Před Jordánem v údolí naproti Betfegor, v zemi Seona, krále Amorejského, kterýž bydlil v Ezebon, jejž porazil Mojžíš a synové Izraelští, když vyšli z Egypta, ");
INSERT INTO ces1613_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","A uvázali se dědičně v zemi jeho, a v zemi Oga, krále Bázan, dvou králů Amorejských, v zemi, kteráž jest před Jordánem k východu slunce, ");
INSERT INTO ces1613_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Od Aroer, (jenž leží při břehu potoka Arnon), až k hoře Sion, kteráž jest Hermon. ");
INSERT INTO ces1613_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","I ve všecku rovinu před Jordánem k východu až k moři pustému, ležící pod horou Fazga. ");
INSERT INTO ces1613_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","I svolal Mojžíš všecken lid Izraelský, a řekl jim: Slyš, Izraeli, ustanovení a soudy, kteréž já dnes mluvím v uši vaše; naučte se jim, a v skutku jich ostříhejte. ");
INSERT INTO ces1613_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Hospodin Bůh náš učinil s námi smlouvu na Orébě. ");
INSERT INTO ces1613_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Ne s otci našimi učinil Hospodin tu smlouvu, ale s námi, kteříž zde jsme nyní my všickni živí. ");
INSERT INTO ces1613_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Tváří v tvář mluvil Hospodin s vámi na té hoře z prostředku ohně, ");
INSERT INTO ces1613_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(Já jsem pak stál mezi Hospodinem a mezi vámi toho času, abych oznámil vám řeč Hospodinovu; nebo jste se báli ohně, a nevstoupili jste na horu), řka: ");
INSERT INTO ces1613_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Já jsem Hospodin Bůh tvůj, kterýž jsem tě vyvedl z země Egyptské z domu služby. ");
INSERT INTO ces1613_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Nebudeš míti bohů jiných přede mnou. ");
INSERT INTO ces1613_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Neučiníš sobě rytiny, ani jakého podobenství těch věcí, kteréž jsou na nebi svrchu, ani těch, kteréž na zemi dole, ani těch, kteréž jsou u vodách pod zemí. ");
INSERT INTO ces1613_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Nebudeš se jim klaněti, ani jich ctíti. Nebo já jsem Hospodin Bůh tvůj, Bůh silný, horlivý, navštěvující nepravost otců na synech do třetího i čtvrtého pokolení těch, kteříž nenávidí mne, ");
INSERT INTO ces1613_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","A činící milosrdenství nad tisíci těch, kteříž mne milují, a ostříhají přikázaní mých. ");
INSERT INTO ces1613_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Nevezmeš jména Hospodina Boha svého nadarmo, neboť nenechá bez pomsty Hospodin toho, kdož by bral jméno jeho nadarmo. ");
INSERT INTO ces1613_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Ostříhej dne sobotního, abys jej světil, jakož přikázal tobě Hospodin Bůh tvůj. ");
INSERT INTO ces1613_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Šest dní pracovati budeš, a dělati všeliké dílo své; ");
INSERT INTO ces1613_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Ale dne sedmého odpočinutí jest Hospodina Boha tvého. Nebudeš dělati žádného díla, ty i syn tvůj i dcera tvá, i služebník tvůj i děvka tvá, vůl i osel tvůj i všeliké hovado tvé, i příchozí tvůj, kterýž jest v branách tvých, aby odpočinul služebník tvůj a děvka tvá jako i ty. ");
INSERT INTO ces1613_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","A pamatuj, že jsi byl služebníkem v zemi Egyptské, a vyvedl tě Hospodin Bůh tvůj odtud v ruce silné, a v rameni vztaženém. Protož přikázal tobě Hospodin Bůh tvůj, abys světil den sváteční. ");
INSERT INTO ces1613_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Cti otce svého i matku svou, jakož přikázal tobě Hospodin Bůh tvůj, aby se prodleli dnové tvoji, a aby tobě dobře bylo na zemi, kterouž Hospodin Bůh tvůj dá tobě. ");
INSERT INTO ces1613_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Nezabiješ. ");
INSERT INTO ces1613_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Nesesmilníš. ");
INSERT INTO ces1613_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Nepokradeš. ");
INSERT INTO ces1613_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Nepromluvíš proti bližnímu svému křivého svědectví. ");
INSERT INTO ces1613_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Nepožádáš manželky bližního svého, aniž požádáš domu bližního svého, pole jeho, neb služebníka jeho, aneb děvky jeho, vola jeho neb osla jeho, aneb čehokoli z těch věcí, kteréž jsou bližního tvého. ");
INSERT INTO ces1613_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Ta slova mluvil Hospodin ke všemu shromáždění vašemu na hoře z prostředku ohně, oblaku a mrákoty, hlasem velikým, a nepřidal nic více, a napsal je na dvou dskách kamenných, kteréž mně dal. ");
INSERT INTO ces1613_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Vy pak když jste uslyšeli hlas z prostředku tmy, (nebo hora ohněm hořela), přistoupili jste ke mně všickni vůdcové pokolení vašich a starší vaši, ");
INSERT INTO ces1613_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","A řekli jste: Ej, ukázal nám Hospodin Bůh náš slávu svou a velikost svou, a slyšeli jsme hlas jeho z prostředku ohně; dnešního dne viděli jsme, že Bůh mluvil s člověkem, a on živ zůstal. ");
INSERT INTO ces1613_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Protož nyní proč máme zemříti? Nebo sežral by nás oheň veliký tento; jestli více slyšeti budeme hlas Hospodina Boha našeho, zemřeme. ");
INSERT INTO ces1613_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Nebo co jest všeliké tělo, aby slyše hlas Boha živého mluvícího z prostředku ohně, jako my, mělo živo býti? ");
INSERT INTO ces1613_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Přistup ty a slyš všecky věci, kteréž mluviti bude Hospodin Bůh náš; potom ty mluviti budeš nám, což by koli řekl tobě Hospodin Bůh náš, a my slyšeti i činiti budeme. ");
INSERT INTO ces1613_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Uslyšev pak Hospodin hlas řečí vašich, když jste mluvili ke mně, řekl mi Hospodin: Slyšel jsem hlas řeči lidu tohoto, kterouž mluvili tobě. Cožkoli mluvili, dobřeť jsou mluvili. ");
INSERT INTO ces1613_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ó kdyby bylo jejich srdce takové, aby se báli mne a ostříhali přikázaní mých po všeliký čas, aby jim dobře bylo i synům jejich na věky! ");
INSERT INTO ces1613_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Jdi, rci jim: Navraťte se k stanům vašim. ");
INSERT INTO ces1613_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Ty pak stůj tuto při mně, a oznámím tobě všecka přikázaní, ustanovení i soudy, kterýmž je učiti budeš, aby je činili v zemi, kterouž já dávám jim, aby jí dědičně vládli. ");
INSERT INTO ces1613_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Hleďtež tedy, abyste činili, jakž přikázal vám Hospodin Bůh váš; neuchylujte se na pravo ani na levo. ");
INSERT INTO ces1613_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Po vší té cestě, kterouž vám přikázal Hospodin Bůh váš, choditi budete, abyste živi byli, a dobře bylo vám, a abyste prodlili dnů na zemi, kterouž dědičně obdržíte. ");
INSERT INTO ces1613_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Toto pak jest přikázaní, ustanovení a soudové, kteréž přikázal Hospodin Bůh váš, abych učil vás, abyste činili je v zemi, do kteréž jdete k dědičnému držení jí, ");
INSERT INTO ces1613_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Abys se bál Hospodina Boha svého, ostříhaje všech ustanovení jeho a přikázaní jeho, kteráž já přikazuji tobě, ty i syn tvůj i vnuk tvůj, po všecky dny života svého, aby se prodlili dnové tvoji. ");
INSERT INTO ces1613_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Slyšiž tedy, Izraeli, a hleď tak skutečně činiti, aby tobě dobře bylo, a abyste se velmi rozmnožili, (jakož mluvil Hospodin Bůh otců tvých tobě,) v zemi oplývající mlékem a strdí. ");
INSERT INTO ces1613_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Slyš, Izraeli, Hospodin Bůh náš, Hospodin jeden jest. ");
INSERT INTO ces1613_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Protož milovati budeš Hospodina Boha svého z celého srdce svého, a ze vší duše své, a ze vší síly své. ");
INSERT INTO ces1613_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","A budou slova tato, kteráž já přikazuji tobě dnes, v srdci tvém. ");
INSERT INTO ces1613_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","A budeš je často opětovati synům svým, a mluviti o nich, když sedneš v domě svém, když půjdeš cestou, a léhaje i vstávaje. ");
INSERT INTO ces1613_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Uvážeš je za znamení na ruce své, a jako náčelník mezi očima svýma. ");
INSERT INTO ces1613_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Napíšeš je také na veřejích domu svého a na branách svých. ");
INSERT INTO ces1613_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","A když tě uvede Hospodin Bůh tvůj do země, kterouž s přísahou zaslíbil otcům tvým, Abrahamovi, Izákovi a Jákobovi, že ji tobě dá, i města veliká a výborná, kterýchžs nestavěl, ");
INSERT INTO ces1613_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","A domy plné všech dobrých věcí, kterýchž jsi nenaplnil, a studnice vykopané, kterýchž jsi nekopal, a vinice i olivoví, jichž jsi neštípil, a jedl bys a nasytil se: ");
INSERT INTO ces1613_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Varuj se, abys nezapomenul na Hospodina, kterýž tě vyvedl z země Egyptské, z poroby těžké. ");
INSERT INTO ces1613_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Hospodina Boha svého báti se budeš, a jemu sloužiti, a ve jméno jeho přisahati. ");
INSERT INTO ces1613_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Neodejdeš po bozích cizích, z bohů jiných národů, kteříž vůkol vás jsou, ");
INSERT INTO ces1613_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","(Nebo Bůh silný, horlivý, Hospodin tvůj u prostřed tebe jest,) aby se neroznítila prchlivost Hospodina Boha tvého na tebe, a shladil by tě se svrchku země. ");
INSERT INTO ces1613_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Nebudete pokoušeti Hospodina Boha svého, jako jste pokoušeli v Massah. ");
INSERT INTO ces1613_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Pilně ostříhejte přikázaní Hospodina Boha svého, a svědectví jeho, i ustanovení jeho, kteráž přikázal tobě, ");
INSERT INTO ces1613_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","A čiň to, což pravého a dobrého jest před očima Hospodinovýma, aby tobě dobře bylo, a vejda, abys dědičně obdržel zemi výbornou, kterouž s přísahou zaslíbil Hospodin otcům tvým, ");
INSERT INTO ces1613_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Aby vypudil všecky nepřátely tvé od tváři tvé, jakož mluvil Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Když by se potom syn tvůj otázal tebe, řka: Co jsou to za svědectví a ustanovení i soudy, kteréž přikázal Hospodin Bůh náš vám? ");
INSERT INTO ces1613_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Tedy díš synu svému: Služebníci jsme byli Faraonovi v Egyptě, i vyvedl nás Hospodin z Egypta v ruce silné. ");
INSERT INTO ces1613_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","A činil Hospodin znamení a zázraky veliké a škodlivé v Egyptě proti Faraonovi, a proti všemu domu jeho před očima našima, ");
INSERT INTO ces1613_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Nás pak vyvedl odtud, aby uvedl nás, a dal nám zemi, kterouž s přísahou zaslíbil otcům našim. ");
INSERT INTO ces1613_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Protož přikázal nám Hospodin, abychom ostříhali všech ustanovení těchto, bojíce se Hospodina Boha svého, aby nám dobře bylo po všecky dny, a aby zachoval nás při životu, jakž to činí i v dnešní den. ");
INSERT INTO ces1613_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","A spravedlnost míti budeme, když ostříhati budeme a činiti všecka přikázaní tato před Hospodinem Bohem svým, jakož přikázal nám. ");
INSERT INTO ces1613_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Když pak tebe uvede Hospodin Bůh tvůj do země, do kteréž ty již vcházíš, abys vládl jí, a vypléní národy mnohé od tváři tvé, Hetea, Gergezea, Amorea, Kananea, Ferezea, Hevea a Jebuzea, sedm národů větších a silnějších, nežli jsi ty, ");
INSERT INTO ces1613_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","A dá je Hospodin Bůh tvůj tobě, abys je pobil: jako proklaté vypléníš je, nevejdeš s nimi v smlouvu, aniž slituješ se nad nimi. ");
INSERT INTO ces1613_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Nikoli nespřízníš se s nimi; dcery své nedáš synu jejich, a dcery jejich nevezmeš synu svému. ");
INSERT INTO ces1613_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Neboť by odvedla syna tvého od následování mne, a sloužili by bohům cizím, pročež popudila by se prchlivost Hospodinova na vás, a zahladila by tě rychle. ");
INSERT INTO ces1613_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ale raději toto jim učiňte: Oltáře jejich zbořte, modly jejich stroskotejte, háje také posekejte, a rytiny jejich ohněm spalte. ");
INSERT INTO ces1613_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Nebo ty lid svatý jsi Hospodinu Bohu svému; tebe vyvolil Hospodin Bůh tvůj, abys jemu byl lidem zvláštním, mimo všecky národy, kteříž jsou na zemi. ");
INSERT INTO ces1613_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Ne proto, že by vás více bylo nad jiné národy, připojil se k vám Hospodin, a vyvolil vás, (nebo menší vás počet byl nežli jiných národů,) ");
INSERT INTO ces1613_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Ale proto, že miloval vás Hospodin, a splniti chtěl přísahu, kterouž přisáhl otcům vašim, vyvedl vás v ruce silné, a vysvobodil vás z domu služby, z ruky Faraona, krále Egyptského. ");
INSERT INTO ces1613_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","I zvíš, že Hospodin Bůh tvůj jest Bůh, Bůh silný a pravdomluvný, ostříhající smlouvy a milosrdenství těm, kteříž ho milují a ostříhají přikázaní jeho, až do tisícího kolena, ");
INSERT INTO ces1613_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Odplacující tomu, kterýž ho nenávidí, v tvář jeho, tak aby zahladil jej. Nebudeť prodlévati; kdož ho nenávidí, v tvář jeho odplatí jemu. ");
INSERT INTO ces1613_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Protož ostříhej přikázaní a ustanovení i soudů, kteréž já tobě dnes přikazuji, abys je činil. ");
INSERT INTO ces1613_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","I budeť to, že když poslouchati budete soudů těchto a ostříhati i činiti je, také Hospodin Bůh tvůj ostříhati bude tobě smlouvy a milosrdenství, kteréž s přísahou zaslíbil otcům tvým. ");
INSERT INTO ces1613_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","A bude tě milovati, i požehná tobě a rozmnoží tebe. Nebo požehná plodu života tvého a úrodám země tvé, obilí tvému, vínu tvému a oleji tvému, plodu skotů tvých i stádům bravů tvých v zemi, kterouž s přísahou zaslíbil otcům tvým, že ji tobě dá. ");
INSERT INTO ces1613_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Požehnaný budeš nad všecky národy; nebude u tebe neplodný aneb neplodná, ani mezi hovady tvými. ");
INSERT INTO ces1613_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Vzdálí také od tebe Hospodin všeliký neduh, a všecky zlé nemoci Egyptské, kteréž znáš; nevzloží jich na tebe, ale vzloží je na všecky, kteříž tě nenávidí. ");
INSERT INTO ces1613_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","A shladíš všecky národy, kteréž Hospodin Bůh tvůj dá tobě. Neslituje se nad nimi oko tvé, aniž sloužiti budeš bohům jejich, nebo to bylo by tobě osídlem. ");
INSERT INTO ces1613_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Řekl-li bys v srdci svém: Větší jsou národové tito nežli já, kterak budu moci vyhnati je? ");
INSERT INTO ces1613_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Neboj se jich, ale pilně pamatuj na to, co učinil Hospodin Bůh tvůj Faraonovi a všechněm Egyptským, ");
INSERT INTO ces1613_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Na pokušení veliká, kteráž viděly oči tvé, i znamení a zázraky, a ruku silnou a rámě vztažené, v kterémž vyvedl tě Hospodin Bůh tvůj. Takť učiní Hospodin Bůh tvůj všechněm národům, kterýchž bys se obával. ");
INSERT INTO ces1613_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Nadto sršně pošle Hospodin Bůh tvůj na ně, dokudž by nezhynuli, kteříž by pozůstali, a kteříž by se skryli před tebou. ");
INSERT INTO ces1613_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Nelekejž se strachu jejich, nebo Hospodin Bůh tvůj jest u prostřed tebe, Bůh silný, veliký a hrozný. ");
INSERT INTO ces1613_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","I vypléní Hospodin Bůh tvůj národy ty od tváři tvé pomalu; nebudeš moci pojednou jich shladiti, aby se nerozmnožila proti tobě zvěř polní. ");
INSERT INTO ces1613_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","A však dá je Hospodin Bůh tvůj tobě, a setře je setřením velikým, dokudž nebudou vyhlazeni. ");
INSERT INTO ces1613_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Vydá i krále jejich v ruce tvé, a vyhladíš jméno jejich pod nebem; neostojíť žádný před tebou, až je i vyhladíš. ");
INSERT INTO ces1613_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Ryté bohy jejich ohněm popálíš; nepožádáš stříbra a zlata, kteréž jest na nich, aniž ho sobě vezmeš, aby nebylo tobě osídlem, nebo ohavnost jest Hospodinu Bohu tvému. ");
INSERT INTO ces1613_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Aniž vneseš ohavnosti do domu svého, abys nebyl proklatý, jako i ona; všelijak v ohyzdnosti a v ohavnosti budeš míti ji, nebo proklatá jest. ");
INSERT INTO ces1613_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Všelikého přikázaní, kteréž já přikazuji tobě dnes, skutečně ostříhejte, abyste živi byli a rozmnožili se, a vešli k dědičnému obdržení země, kterouž s přísahou zaslíbil Hospodin otcům vašim. ");
INSERT INTO ces1613_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","A rozpomínati se budeš na všecku cestu, kterouž tě vedl Hospodin Bůh tvůj již teď čtyřidceti let po poušti, aby ponížil tebe a zkusil tě, aby známé bylo, co jest v srdci tvém, budeš-li ostříhati přikázaní jeho, čili nic. ");
INSERT INTO ces1613_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","I ponížil tě a dopustil na tebe hlad, potom tě krmil mannou, kteréž jsi ty neznal, ani otcové tvoji, aby známé učinil tobě, že ne samým chlebem živ bude člověk, ale vším tím, což vychází z úst Hospodinových, živ bude člověk. ");
INSERT INTO ces1613_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Roucho tvé nevetšelo na tobě, a noha tvá se neodhnetla, již od čtyřidceti let. ");
INSERT INTO ces1613_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Znejž tedy v srdci svém, že jakož cvičí člověk syna svého, tak Hospodin Bůh tvůj cvičí tebe. ");
INSERT INTO ces1613_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","A ostříhej přikázaní Hospodina Boha svého, chodě po cestách jeho, a boje se jeho. ");
INSERT INTO ces1613_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Nebo Hospodin Bůh tvůj uvozuje tě do země výborné, země, v níž jsou potokové vod, studnice a propasti prýštící se po údolích i po horách, ");
INSERT INTO ces1613_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Do země hojné na pšenici a ječmen, na vinice a fíky a jablka zrnatá, do země, v níž jest hojnost olivoví olej přinášejícího a medu. ");
INSERT INTO ces1613_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Země, v níž bez nedostatku chléb jísti budeš, a v ničemž nouze trpěti nebudeš, země, jejíž kamení jest železo, a z hor jejích měď sekati budeš. ");
INSERT INTO ces1613_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Kdyžkoli jísti budeš a nasytíš se, dobrořečiti budeš Hospodina Boha svého za zemi výbornou, kterouž dal tobě. ");
INSERT INTO ces1613_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Aniž se kdy toho dopouštěj, abys se měl zapomenouti na Hospodina Boha svého, a neostříhati přikázaní a soudů jeho i ustanovení jeho, kteráž já dnes přikazuji tobě, ");
INSERT INTO ces1613_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Aby, když bys jedl a nasycen byl, a domů krásných nastavěje, v nich bys bydlil, ");
INSERT INTO ces1613_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","A volové i ovce tvé rozmnoženy byly by, stříbra také a zlata měl bys mnoho, a hojnost ve všech věcech svých, ");
INSERT INTO ces1613_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Nepozdvihlo se srdce tvé, a zapomenul bys na Hospodina Boha svého, kterýž tě vyvedl z země Egyptské, z domu služby, ");
INSERT INTO ces1613_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","A vedl tě přes poušť velikou a hroznou, na níž byli hadové ohniví a štírové, poušť žíznivou, na níž nebylo žádné vody, a vyvedl tobě vodu z přetvrdé skály, ");
INSERT INTO ces1613_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Kterýž tě krmil na poušti mannou, o kteréž nevěděli otcové tvoji, aby tě potrápil a zkusil tebe, naposledy však aby dobře učinil tobě. ");
INSERT INTO ces1613_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Aniž říkej v srdci svém: Moc má a síla ruky mé způsobila mi tato zboží, ");
INSERT INTO ces1613_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Ale pamatuj na Hospodina Boha svého, nebo on dává tobě moc k dobývání zboží, aby utvrdil smlouvu svou, kterouž s přísahou učinil s otci tvými, jakož to ukazuje dnešní den. ");
INSERT INTO ces1613_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Pakli zapomena se na Hospodina Boha svého, postoupil bys po bozích cizích, a sloužil bys jim a klaněl bys se jim: osvědčuji proti vám dnes, že konečně zahynete. ");
INSERT INTO ces1613_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Jako pohané, kteréž Hospodin zahladil před tváří vaší, tak zahynete, proto že jste neposlouchali hlasu Hospodina Boha svého. ");
INSERT INTO ces1613_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Slyš, Izraeli, ty přejdeš dnes přes Jordán, abys vejda, dědičně vládl národy většími a silnějšími, než jsi ty, městy velikými a ohrazenými až k nebi, ");
INSERT INTO ces1613_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Lidem velikým a vysokým, syny Enakovými, o kterýchž víš, a o kterýchž jsi slyšel praviti: Kdo se postaví proti synům Enakovým? ");
INSERT INTO ces1613_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Protož věziž dnes, že Hospodin Bůh tvůj, kterýž jde před tebou, jest jako oheň spalující. On vyhladí je, a on sníží je před tebou; i vyženeš je a vyhladíš je rychle, jakož mluvil tobě Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Neříkejž v srdci svém, když by je zapudil Hospodin Bůh tvůj od tváři tvé, řka: Pro spravedlnost mou uvedl mne Hospodin, abych dědičně obdržel zemi tuto, tak jako pro bezbožnost národů těch Hospodin vyhnal je od tváři tvé. ");
INSERT INTO ces1613_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ne pro spravedlnost svou a pravost srdce svého ty jdeš, abys dědičně obdržel zemi jejich, ale pro bezbožnost národů těch Hospodin Bůh tvůj vyhání je od tváři tvé, a aby splnil slovo, kteréž s přísahou zaslíbil otcům tvým, Abrahamovi, Izákovi a Jákobovi. ");
INSERT INTO ces1613_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Protož věziž, že ne pro spravedlnost tvou Hospodin Bůh tvůj dává tobě zemi tu výbornou, abys dědičně držel ji, poněvadž jsi lid tvrdé šíje. ");
INSERT INTO ces1613_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Pamatujž a nezapomínej, že jsi k hněvu popouzel Hospodina Boha svého na poušti; hned od toho dne, když jsi vyšel z země Egyptské, až jste přišli na místo toto, odporni jste byli Hospodinu. ");
INSERT INTO ces1613_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Také i na Orébě popudili jste k hněvu Hospodina, a rozhněval se na vás Hospodin, aby vás shladil. ");
INSERT INTO ces1613_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Když jsem vstoupil na horu, abych vzal dsky kamenné, dsky smlouvy, kterouž učinil s vámi Hospodin, tehdáž jsem trval na hoře čtyřidceti dní a čtyřidceti nocí, chleba nejeda a vody nepije. ");
INSERT INTO ces1613_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","I dal mi Hospodin dvě dsky kamenné, psané prstem Božím, na nichž byla všecka ta slova, kteráž mluvil vám Hospodin na hoře z prostředku ohně v den shromáždění. ");
INSERT INTO ces1613_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Po skonání pak čtyřidceti dnů a čtyřidceti nocí dal mi Hospodin dvě dsky kamenné, dsky smlouvy. ");
INSERT INTO ces1613_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","I řekl mi Hospodin: Vstana, sstup rychle odsud, nebo poškvrnil se lid tvůj, kterýž jsi vyvedl z Egypta; sešli brzy s cesty, kterouž jsem jim přikázal, a učinili sobě slitinu. ");
INSERT INTO ces1613_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Mluvil také Hospodin ke mně, řka: Viděl jsem lid ten, a jistě lid tvrdošijný jest. ");
INSERT INTO ces1613_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Pusť mne, ať je setru, a zahladím jméno jejich pod nebem, tebe pak učiním v národ větší a silnější, nežli jest tento. ");
INSERT INTO ces1613_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Tedy obrátiv se, sstoupil jsem s hory, (hora pak hořela ohněm), dvě dsky smlouvy maje v obou rukou svých. ");
INSERT INTO ces1613_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Když jsem pak pohleděl a uzřel jsem, že jste zhřešili Hospodinu Bohu vašemu, udělavše sobě tele lité, (brzy jste byli sešli s cesty, kterouž přikázal vám Hospodin): ");
INSERT INTO ces1613_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Pochytiv ty dvě dsky, povrhl jsem je z obou rukou svých, a polámal jsem je před očima vašima. ");
INSERT INTO ces1613_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","A padna, ležel jsem před Hospodinem jako i prvé, čtyřidceti dní a čtyřidceti nocí, chleba nejeda a vody nepije, pro všecky hříchy vaše, kterýmiž jste byli zhřešili, činíce to, což zlého jest před očima Hospodinovýma, a popouzejíce jeho. ");
INSERT INTO ces1613_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Nebo bál jsem se prchlivosti a hněvu, kterýmž se byl popudil Hospodin proti vám, aby zahladil vás, a uslyšel mne Hospodin i tehdáž. ");
INSERT INTO ces1613_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Na Arona též rozhněval se byl Hospodin náramně, tak že ho zahladiti chtěl; tedy modlil jsem se také za Arona téhož času. ");
INSERT INTO ces1613_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Hřích pak váš, kterýž jste byli učinili, totiž tele, vzav, spálil jsem je ohněm a zdrobil jsem je, tluka je dobře, dokudž nebylo setříno na prach. Potom vsypal jsem prach jeho do potoka, kterýž tekl s té hory. ");
INSERT INTO ces1613_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Ano i v Tabbera a v Massah a v Kibrot Hattáve popouzeli jste Hospodina k hněvu. ");
INSERT INTO ces1613_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","A když vás poslal Hospodin z Kádesbarne, řka: Vstupte a opanujte zemi tu, kterouž jsem vám dal, odporni jste byli řeči Hospodina Boha svého, a nevěřili jste jemu, aniž jste uposlechli hlasu jeho. ");
INSERT INTO ces1613_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Odporni jste byli Hospodinu od toho dne, jakž jsem vás poznal. ");
INSERT INTO ces1613_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","A padna, ležel jsem před Hospodinem čtyřidceti dní a čtyřidceti nocí, v nichž jsem rozprostíral se; nebo řekl Hospodin, že vás chce zahladiti. ");
INSERT INTO ces1613_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","I modlil jsem se Hospodinu, řka: Panovníče Hospodine, nezatracujž lidu svého, a to dědictví svého, kteréž jsi vykoupil velikomocností svou, kteréž jsi vyvedl z Egypta v ruce silné. ");
INSERT INTO ces1613_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Rozpomeniž se na služebníky své, Abrahama, Izáka a Jákoba; nepatřiž na tvrdost lidu tohoto, na bezbožnost jeho a na hříchy jeho, ");
INSERT INTO ces1613_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Aby neřekli obyvatelé země té, z níž jsi nás vyvedl: Proto že nemohl Hospodin uvésti jich do země, kterouž zaslíbil jim, aneb že je měl v nenávisti, vyvedl je, aby je pobil na poušti. ");
INSERT INTO ces1613_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Však oni jsou lid tvůj a dědictví tvé, kteréž jsi vyvedl v síle své veliké a v rameni svém vztaženém. ");
INSERT INTO ces1613_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Toho času řekl mi Hospodin: Vyhlaď sobě dvě dsky kamenné, podobné prvním, a vstup ke mně na horu, a udělej sobě truhlu dřevěnou. ");
INSERT INTO ces1613_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","I napíši na dskách těch slova, kteráž byla na dskách prvních, kteréž jsi rozrazil, a vložíš je do té truhly. ");
INSERT INTO ces1613_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Tedy udělal jsem truhlu z dříví setim, a vyhladiv dvě dsky kamenné, podobné prvním, vstoupil jsem na horu, nesa ty dvě dsky v rukou svých. ");
INSERT INTO ces1613_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","I napsal na těch dskách, tak jakž prvé byl napsal, deset slov, kteráž mluvil k vám Hospodin na hoře z prostředku ohně v den shromáždění onoho, a dal je Hospodin mně. ");
INSERT INTO ces1613_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","A obrátiv se, sstoupil jsem s hory té, a vložil jsem ty dsky do truhly, kterouž jsem byl udělal, a byly tam, jakož mi přikázal Hospodin. ");
INSERT INTO ces1613_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Synové pak Izraelští hnuli se z Beerot synů Jakan do Moserah. Tam umřel Aron, a tu jest pochován; i konal úřad kněžský na místě jeho Eleazar, syn jeho. ");
INSERT INTO ces1613_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Odtud táhli do Gadgad, a z Gadgad do Jotbata, do země vod tekutých. ");
INSERT INTO ces1613_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Toho času oddělil Hospodin pokolení Léví, aby nosili truhlu smlouvy Hospodinovy, a aby stáli před Hospodinem k službě jemu, a k dobrořečení ve jménu jeho až do dnešního dne. ");
INSERT INTO ces1613_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Pročež nemělo pokolení Léví dílu a dědictví s bratřími svými, nebo Hospodin jest dědictví jeho, jakož mluvil k němu Hospodin Bůh tvůj. ");
INSERT INTO ces1613_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Já pak zůstal jsem na té hoře jako dnů prvních, čtyřidceti dní a čtyřidceti nocí, a uslyšel mne Hospodin i tehdáž, a nechtěl shladiti tebe. ");
INSERT INTO ces1613_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Potom řekl mi Hospodin: Vstaň, jdi, předcházeje lid, aby vešli a vládli zemí, kterouž jsem s přísahou zaslíbil otcům jejich, že jim ji dám. ");
INSERT INTO ces1613_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Nyní tedy, Izraeli, čeho žádá Hospodin Bůh tvůj od tebe? Jediné abys se bál Hospodina Boha svého, a chodil po všech cestách jeho, a abys miloval ho, a sloužil Hospodinu Bohu svému v celém srdci svém, a ve vší duši své, ");
INSERT INTO ces1613_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Ostříhaje přikázaní Hospodinových a ustanovení jeho, kteráž já přikazuji tobě dnes k tvému dobrému. ");
INSERT INTO ces1613_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Aj, Hospodina Boha tvého jest nebe i nebesa nebes, země a všecky věci, kteréž jsou na ní. ");
INSERT INTO ces1613_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Však toliko v otcích tvých zalíbilo se Hospodinu, aby je zamiloval, a vyvolil símě jejich po nich, vás totiž ze všech národů, jakož dnes vidíš. ");
INSERT INTO ces1613_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Protož obřežtež neobřízku srdce svého, a šíje své nezatvrzujte více. ");
INSERT INTO ces1613_vpl VALUES ("DT10_17","006_10_17","DEU","10","17",