﻿USE sofia;
DROP TABLE IF EXISTS sofia.cekak_vpl;
CREATE TABLE cekak_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cekak_vpl WRITE;
INSERT INTO cekak_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tangsuek naah Sithaw mah van hoi long to sak. ");
INSERT INTO cekak_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Long loe tungkrang om ai, kong sut; kaving loe kathuk nuiah oh. Sithaw ih Muithla loe tui nuiah angtawt. ");
INSERT INTO cekak_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Sithaw mah, Aanghaih om nasoe, tiah thuih pongah, Aanghaih to oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Sithaw mah aanghaih to hnuk naah hoih, tiah thuih; Sithaw mah aanghaih to kaving thung hoiah tapraek. ");
INSERT INTO cekak_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ka-aang to Sithaw mah Khodai, tiah kawk moe, kaving to Khoving, tiah kawk. To tiah duem hoi khawn to oh moe, amtong tangsuekhaih niah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Sithaw mah, Tuinawk um ah van hma to om nasoe loe, tui thung hoiah tui to ampraek nasoe, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","To pongah Sithaw mah van hma to sak moe, van hma tlim ih tui hoi van hma ranui ih tui to tapraek; a thuih ih lok baktih toengah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Sithaw mah van hma to van, tiah kawk; to tiah duem hoi khawn to oh; to loe ni hnetto haih ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Sithaw mah, tuinawk loe van tlim ah nawnto angcu o nasoe loe, saoeng to amtueng nasoe, tiah thuih; a thuih ih lok baktih toengah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Sithaw mah kaphui long to saoeng, tiah kawk moe, nawnto angcuu tui to tuipui, tiah kawk; a sak ih hmuen to Sithaw mah hnuk naah hoih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Sithaw mah, Saoeng nuiah phroh, amuu kaom aan kahingnawk, amuu kaom thingthai congca kathai thingkungnawk to amprawk o nasoe, tiah thuih; a thuih ih lok baktih toengah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Long ah phroh to amprawk, amuu kaom aan congca hoi thingthai congca to amprawk o; a sak ih hmuen to Sithaw mah hnuk naah hoih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Duem hoi khawn to oh, to loe ni thumto haih ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Sithaw mah, khoving thung hoi khodai to tapraek hanah, van hma ah aanghaih to om nasoe, atuenawk, aninawk, saningnawk loe angmathaih ah om nasoe, ");
INSERT INTO cekak_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","long to aanghaih paek hanah van hma ah aanghaih to om nasoe, tiah thuih; a thuih ih lok baktih toengah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Sithaw mah aanghaih paekkung kalen hnetto sak, kalen kue khodai ukkung ka-aang hoi kathoeng kue khoving ukkung ka-aang to a sak; cakaehnawk doeh a sak. ");
INSERT INTO cekak_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Long to aanghaih paek hanah, to aanghaih to Sithaw mah van hma ah suek. ");
INSERT INTO cekak_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Khodai hoi khoving to uk moe, khoving thung hoi khodai to tapraek hanah, to tiah a suek; a sak ih hmuen to Sithaw mah hnuk naah hoih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Duem hoi khawn to oh, to loe ni palito haih ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Sithaw mah, tui thungah Hinghaih katawn, kangtawt thaih moi congca to om nasoe loe, long ranui ah kaom kawk parai van hma ah tavaanawk to azawk o nasoe, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","To tiah Sithaw mah kalen parai tuipui thungah tanga pui, hinghaih katawn angtawt thaih moi congca hoi azawk thaih tava congca doeh pungsak; a sak ih hmuen to Sithaw mah hnuk naah hoih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","To a sak ih moinawk to Sithaw mah tahamhoihaih paek, Athaih pop nasoe loe, tuipui koi mongah pung o nasoe, tavaanawk doeh long ah pung o nasoe, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Duem hoi khawn to oh, to loe ni pangato haih ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Sithaw mah, Hinghaih tawn pacah ih moi congca, long ah kavak moinawk, taw ah kaom congca moinawk loe long mah pungsak nasoe, tiah thuih; a thuih ih lok baktih toengah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Sithaw mah taw ih congca moi, pacah ih congca moi, long ah kavak angtawt thaih congca moi to sak; a sak ih hmuen to Sithaw mah hnuk naah hoih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","To pacoengah Sithaw mah, Kami hae aimacae tungkrang baktih, aimacae hoi kanghmong ah sah si loe, tuipui thung ih tanganawk, van ih tavaanawk, long ah pacah ih moinawk, long ah kavak moinawk boih to uk nasoe, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","To pongah Sithaw mah kami to angmah ih tungkrang baktih toengah sak; Sithaw krang hoi kanghmong ah nongpa hoi nongpata to sak. ");
INSERT INTO cekak_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Sithaw mah, nihnik khaeah, Athaih athai hoih, pung hoih, long ah koi hoi ah loe, long to uk hoih; tuipui thung ih tanganawk, van ih tavaanawk, long nuiah kavak hinghaih katawn moinawk boih to uk hoih, tiah tahamhoihaih paek. ");
INSERT INTO cekak_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","To pacoengah Sithaw mah, Khenah, long pum ah amuu kaom ann congca, thingthaikung congca to kang paek; to hmuennawk loe nang hnik ih buh ah om tih. ");
INSERT INTO cekak_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na caak hoi hanah, long ah kaom taw ih moinawk boih, van ih tavaanawk boih, long ah kavak hinghaih tawn moinawk boih, anqam congca to kang paek, tiah a naa. A thuih ih lok baktih toengah oh. ");
INSERT INTO cekak_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","A sak ih hmuennawk boih Sithaw mah khet naah, Hoih parai, tiah thuih. Duem hoi khawn to oh, to loe ni tarukto haih ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","To tiah van hoi long, to ah kaom hmuennawk boih to a sak pacoeng. ");
INSERT INTO cekak_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ni sarihto naah loe Sithaw mah a sak ih tok to pacoengh, to pongah ni sarihto naah loe a toksakhaih boih thung hoiah anghak. ");
INSERT INTO cekak_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","A sak ih tok boih thung hoiah Sithaw anghakhaih niah oh pongah, sarihto ni to Sithaw mah tahamhoihaih paek moe, ciimcaisak. ");
INSERT INTO cekak_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Angraeng Sithaw mah van hoi long sak na niah, van hoi long sakhaih kawngnawk loe hae tiah oh. ");
INSERT INTO cekak_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Angraeng Sithaw mah long nuiah kho angzosak ai pongah, long ah thingkung to om ai, aan doeh amprawk ai; long ah toksah kami doeh om ai. ");
INSERT INTO cekak_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Toe long thung hoiah tui to tacawt pongah, long to tui mah duksak boih. ");
INSERT INTO cekak_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Angraeng Sithaw mah long ih maiphu hoiah kami to sak moe, anih ih hnahkhaw thungah hinghaih takhi to uengh pae; to naah hinghaih tawn kami ah angcoeng. ");
INSERT INTO cekak_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Angraeng Sithaw mah ni angyae bang ih Eden ah takha maeto sak; to ah a sak ih kami to a suek. ");
INSERT INTO cekak_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Angraeng Sithaw mah to long thung hoiah khet kahoih, caak kahoih thingkung congca to amprawksak; hinghaih thingkung hoi kasae kahoih panoekhaih thingkung doeh takha um ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Takha tui paek hanah Eden takha thung hoiah vapui maeto longh; to ahmuen hoiah ampraek moe, vapui sip palito ah angphae. ");
INSERT INTO cekak_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Hmaloe koek ih ahmin loe Pishon; to vapui loe sui ohhaih, Havilah prae thung boih ah longh. ");
INSERT INTO cekak_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","To prae thung ih sui loe hoih; to ah loe bdellium hmuihoih thing hoi onyx thlungnawk doeh tacawt. ");
INSERT INTO cekak_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Hnetto haih vapui ahmin loe Gihon; to vapui loe Ethiopia prae thung boih ah longh. ");
INSERT INTO cekak_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Thumto haih vapui ahmin loe Hiddekel; to loe Assyria prae ni angyae bangah longh. Palito haih vapui loe Euphrates. ");
INSERT INTO cekak_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Eden takha to khetzawn moe, to ah toksak hanah, Angraeng mah kami to lak moe, takha thungah anih to suek. ");
INSERT INTO cekak_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Angraeng Sithaw mah kami khaeah, Takha thungah kaom thingkung hoi tacawt athaihnawk boih to na caak thaih; ");
INSERT INTO cekak_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","toe kasae kahoih panoekhaih thingthai loe na caa mak ai; na caak niah na dueh tangtang tih, tiah lokpaek. ");
INSERT INTO cekak_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Angraeng Sithaw mah, Kami loe angmabueng oh han hoih ai; anih han kamcuk bomkung maeto ka sak pae han, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Angraeng Sithaw mah long hoiah sak ih taw ih moinawk boih, van ih tavaanawk boih to khetzawn moe, ahmin phui hanah, Adam khaeah sinh pae; kahing moi loe, Adam mah sak ih ahmin baktih toengah ahmin tawnh o boih. ");
INSERT INTO cekak_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adam mah moinawk, van ih tavaanawk hoi taw ih moinawk boih to ahmin sak; toe Adam loe angmah hoi kamcuk bomkung to tawn ai. ");
INSERT INTO cekak_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Angraeng Sithaw mah Adam to iih angmuetsak parai pongah, anih loe iih; anih ih panak huh maeto a lak pae, a lak ih ahmuen ah ngan to pacong pae let. ");
INSERT INTO cekak_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Angraeng Sithaw mah kami khae hoi lak ih, panak huh hoiah nongpata to sak moe, anih to nongpa khaeah a caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adam mah, Hae loe ka huhnawk thung ih ahuh, ka ngan thung ih ngan ah oh; anih loe Nongpa thung hoiah lak ah oh pongah, Nongpata, tiah kawk han oh, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","To pongah nongpa mah ampa hoi amno to caehtaak ueloe, a zu to la tih, to naah nihnik loe takpum maeto ah om hoi tih. ");
INSERT INTO cekak_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nongpa hoi a zu loe bangkrai ah oh hoi, toe azathaih tawn hoi ai. ");
INSERT INTO cekak_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Pahui loe Angraeng mah sak ih moi kasan boih thungah aling thaih koek ah oh. Anih mah nongpata khaeah, Takha thungah kaom thingkung hoiah kathai athaih to caa hoi boih hmah, tiah Sithaw mah thuih tangtang maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nongpata mah pahui khaeah, Takha thungah kaom thingkungnawk hoiah kathai athaih to ka caak hoi thaih; ");
INSERT INTO cekak_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","toe Sithaw mah, Takha um ah kaom thingkung pong ih athaih loe caa hoi hmah, sui doeh sui hoi hmah, na dueh hoi tih, tiah thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pahui mah nongpata khaeah, Na dueh hoi tangtang mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Na caak hoi niah na mik to amtueng ueloe, sithawnawk baktih toengah, kasae kahoih na panoek hoi toeng tih, tiah Sithaw mah panoek pongah ni, to tiah ang thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nongpata mah thingkung loe caak han kahoih thingkung ah a hnuk, mik hoiah khit moe, palunghahaih paek thaih thingkung ah oh pongah, thingthai to pakhrik moe, a caak, a sava han doeh a paek; anih mah doeh caak toeng. ");
INSERT INTO cekak_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","To naah nihnik ih mik to amtueng, nihnik loe bangkrai ah ni ka oh hoi, tiah panoekhaih to a tawnh hoi boeh; to naah thaiduet qamnawk to a huih hoi moe, kaeng ah angzaeng hoi. ");
INSERT INTO cekak_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ni amding ruehaih atue phak naah loe, takha thungah amkae Angraeng Sithaw ih atuen to a thaih hoi: Adam hoi anih ih zu mah Angraeng to takha thung ih thingkungnawk salakah anghawk hoi taak ving. ");
INSERT INTO cekak_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Angraeng Sithaw mah Adam to kawk, anih khaeah, Naa ah maw na oh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Anih mah, Takha thungah na lok to ka thaih, bangkrai ah ka oh pongah, zithaih ka tawnh moe, kang hawk ving boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Anih mah, bangkrai ah na oh, tiah mi mah maw ang thuih? Caa hmah tiah kang thuih ih thingthai to na caak ving boeh tani? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","To naah Adam mah, Kai han nang paek ih nongpata mah thingkung pong ih athaih to ang paek moe, ka caak, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Angraeng Sithaw mah nongpata khaeah, Tipongah hae tiah na sak loe? tiah a naa. Nongpata mah, Pahui mah ang ling pongah, ka caak, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","To pongah Angraeng Sithaw mah pahui khaeah, Hae hmuen hae na sak boeh pongah, Moinawk boih, taw ih moisannawk boih pongah tangoenghaih na zok boeh; nang loe zok hoiah avak ueloe, na hing thung maiphu to na caa tih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nang hoi nongpata salak, na tii hoi nongpata ih atii salak misa ah ka suek han; anih mah na lu to ati tih, nang mah anih ih khok tahmawh to na patuk pae tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nongpata khaeah, Zok na pomh naah nathaih kating ai kang pungsak han, kana pauephaih hoiah caa na sah tih; na sava koehhaih palung loe boeng mak ai, anih mah na uk tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adam khaeah, Na zu ih lok to na tahngaih moe, Caa hmah, tiah kang thuih ih thingthai to na caak boeh pongah, nang pongah long loe tangoenghaih zok boeh; na hing thung patanghaih hoi toksak naah ni buh na caa tih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nang han soekhring congca kam prawksak han; lawk ih aannawk to na caa tih; ");
INSERT INTO cekak_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","long hoiah nang zoh baktih toengah, long ah nam laem let ai karoek to, na mikhmai ah angsatui long naah ni buh na caa vop tih; maiphu ah na oh pongah, maiphu ah nam laem let tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kahing kaminawk boih ih amno ah oh pongah, Adam mah a zu to Evi, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Angraeng Sithaw mah Adam hoi a zu hanah, moihin kahni to sak pae moe, angkhuksak. ");
INSERT INTO cekak_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Angraeng Sithaw mah, Khenah, kami loe kasae kahoih panoekhaih bang ah, aicae thung ih kami maeto baktiah oh toeng boeh; vaihi anih mah ban payangh ueloe, dungzan ah hing hanah thingthai to pakhrik pacoengah, caa moeng tih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","To pongah angmah tacawthaih long ah toksak hanah, Angraeng Sithaw mah kami to Eden takha thung hoiah haek ving. ");
INSERT INTO cekak_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kami to haek pacoengah, hinghaih thingkung loklam to toep hanah, Cherubimnawk hoi ahnuk ahma angmet thaih hmai sumsen to Eden takha ni angyae bang ah a suek. ");
INSERT INTO cekak_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam mah a zu Evi to iih haih, anih loe zokpom moe, Kain to tapen; to naah anih mah, Angraeng khae hoi kami maeto ka hnuk boeh, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","To pacoengah anih mah amnawk Abel to sak let. Abel loe tuu toep kami ah oh, toe Kain loe lawkphrawk kami ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Atue phak naah, Kain mah hmuenpaekhaih maeto ah long hoi tacawt thingthai to Angraeng khaeah sinh. ");
INSERT INTO cekak_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel mah doeh tapen tangsuek, kathawk tuu to sinh toeng. Abel mah paek ih hmuen to Angraeng mah talawk pae; ");
INSERT INTO cekak_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","toe Kain mah paek ih hmuen loe talawk pae ai. To pongah Kain loe palungphui parai moe, mikhmai set. ");
INSERT INTO cekak_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","To naah Angraeng mah Kain khaeah, Tipongah palung na phui loe? Tipongah mikhmai na set? ");
INSERT INTO cekak_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Katoeng hmuen na sak nahaeloe, nang to talawk ai ah om tih maw? Katoeng ah na sah ai pongah, zaehaih loe thok taengah tabok boeh. Anih mah loe na koehhaih to paroi tih, toe anih to na pazawk han angaih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kain mah amnawk Abel khaeah, Lawk ah caeh si, tiah naa. Lawk ah a oh hoi naah, Kain mah amnawk Abel to hmang moe, hum ving. ");
INSERT INTO cekak_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Angraeng mah Kain khaeah, Nam nawk Abel naa ah maw oh? tiah naa. Anih mah, Ka panoek ai; kai loe kam nawk toepkung ah maw ka oh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Angraeng mah, Timaw na sak? Nam nawk ih athii mah long hoiah Kai ang palawk. ");
INSERT INTO cekak_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Vaihi na ban hoi palong ih nam nawk ih athii to talawk hanah, pakha aang long mah tangoeng haih to na zok boeh pongah, ");
INSERT INTO cekak_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","vaihi hoi kamtong long ah tok na sak naah, long mah nang hanah thingthai tacawtsak mak ai boeh; nang loe long nuiah avak rumram hoi kamhet rumram kami ah ni na om tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain mah Angraeng khaeah, Nang thuitaekhaih loe, pauep thai ai khoek to ah lenh. ");
INSERT INTO cekak_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Khenah, vai hniah long hoiah nang haek boeh pongah, na hmaa hoiah kang hawk ving han boeh; long nuiah avak rumram hoi kamhet rumram kami ah ka oh naah, kai hnu kaminawk boih mah na hum o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Toe Angraeng mah anih khaeah, To pongah mikawbaktih doeh Kain hum kami loe, a nuiah alet sarihto lu lakhaih om tih, tiah a naa. Kain hnu kaminawk mah anih to hum o han ai ah, Angraeng mah Kain nuiah angmathaih to sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","To pongah Kain loe Angraeng hmaa hoi tacawt moe, Eden takha ni angyae bang ah kaom Nod prae ah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain mah a zu to iih haih; a zu loe zokpom moe, Enok to sak; Kain mah vangpui maeto sak, a capa ih ahmin to lak moe, vangpui to Enok, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok mah Irad to sak; Irad mah Mehujael to sak; Mahujael mah Methusael to sak; Methusael mah Lamek to sak. ");
INSERT INTO cekak_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek loe zu hnetto lak; a zu ih ahmin loe Adah; kalah zu maeto ih ahmin loe Zillah. ");
INSERT INTO cekak_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah mah Jabal to sak; anih loe kahni im ah om kami hoi pacah ih moinawk toepkung ampa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Amnawk ih ahmin loe Jubal; anih loe katoeng, tamoi kruek kami ih ampa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah mah doeh capa Tubal-Kain to sak; anih loe sum kamling hoi sum kanglung daeng kami ah oh; Tubal-Kain ih tanuh loe Naamah. ");
INSERT INTO cekak_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek mah a zu, Adah hoi Zillah hnik khaeah, Lamek ih zu hnik, ka lok hae tahngai hoih; ka thuih ih lok hae tahngai hoih; kai ahmaa caasak kami, kai pacaekthlaek thendoeng maeto ka hum boeh. ");
INSERT INTO cekak_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kain hum kami to alet sarihto lu lak han om nahaeloe, Lamek mah loe alet qui sarih, vai sarihto lu laa tih, tiah thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam mah a zu to iih haih let, a zu mah capa maeto sak; Kain mah hum ih Abel zuengah Sithaw mah capa maeto ang paek, tih ah a thuih pongah, a capa to Seth, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth mah doeh capa maeto sak; a capa to Enos, tiah ahmin sak; to nathuem hoi kamtong kaminawk mah Angraeng ih ahmin to palawk amtong o. ");
INSERT INTO cekak_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam ih caanawk anghumhaih kawng loe hae tiah oh. Sithaw mah kami sak naah, Sithaw angmah krang hoi kanghmong ah anih to sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Nongpa hoi nongpata to a sak moe, nihnik to tahamhoihaih paek; nihnik sak na niah nihnik ih ahmin to Adam, tiah ahmin paek. ");
INSERT INTO cekak_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam loe saning cumvai, qui thumto hing naah, angmah baktiah kaom, angmah krang hoi kanghmong capa maeto sak; anih ih ahmin to Seth, tiah a sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seth tapen pacoengah, Adam loe saning cumvai tazetto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam loe saning cumvai takawt, qui thumto hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth loe saning cumvaito pacoeng, pangato hing naah, Enos to sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enos tapen pacoengah, Seth loe saning cumvai tazet, pangato hing moe, kalah capa hoi canunawk doeh a sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth loe saning cumvai takawt, hatlai hnetto hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos loe saning qui takawtto hing naah, Kainan to sak; ");
INSERT INTO cekak_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh loe Kainan tapen pacoengah, saning cumvai tazet, hatlai pangato hing moe, kalah capa hoi canunawk doeh sak vop; ");
INSERT INTO cekak_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos loe saning cumvai takawt, pangato hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kainan loe saning qui sarihto hing naah, Mahalalel to sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel tapen pacoengah Kainan loe, saning cumvai tazet, qui palito hing moe, kalah capa hoi canunawk doeh a sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kainan loe saning cumvai takawt, hato hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel loe saning qui taruk, pangato hing naah, Jared to sak; ");
INSERT INTO cekak_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel loe Jared tapen pacoengah, saning cumvai tazet, qui thumto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalel loe saning cumvai tazet, qui takawt, pangato hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared loe saning cumvai qui taruk, hnetto hing naah, Enok to sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared loe Enok tapen pacoengah, saning cumvai tazetto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared loe saning cumvai takawt, qui taruk, hnetto hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok loe saning qui tarukto pacoeng, saning pangato hing naah, Methuselah to sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enok loe Methuselah tapen pacoengah, saning cumvai thumto thung Sithaw hoi nawnto lam caeh; to pacoengah doeh kalah capa hoi canunawk to sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok loe saning cumvai thum, qui tarukto pacoeng, pangato hing. ");
INSERT INTO cekak_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok loe Sithaw hoi nawnto lam caeh pacoengah, Sithaw mah lak ving boeh pongah, om ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah loe saning cumvai qui tazetto pacoeng, sarihto hing naah, Lamek to sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Methuselah loe Lamek tapen pacoengah, saning cumvai sarih, qui tazet, hnetto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah loe saning cumvai takawt, qui taruk, saning takawtto hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek loe saning cumvai qui tazet, hnetto hing naah, capa maeto sak; ");
INSERT INTO cekak_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Angraeng mah tangoeng ih long ah, ban hoi toksak patangh naah, anih mah monghaih na paek tih, tiah a poek pongah anih ih ahmin to Noah, tiah sak. ");
INSERT INTO cekak_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek loe Noah tapen pacoeng, saning cumvai panga, qui takawt, pangato hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek loe saning cumvai sarih, qui sarih, sarihto hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah loe saning cumvai pangato hing naah, Shem, Ham hoi Japheth to sak. ");
INSERT INTO cekak_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Long ah kaminawk pung o aep aep naah, nihcae mah canunawk to sak o, ");
INSERT INTO cekak_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Sithaw capanawk mah kami canunawk to kranghoih parai ah hnuk o; angmacae koeh ih kami to qoih o moe, zu ah lak o. ");
INSERT INTO cekak_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","To pongah Angraeng mah, Kami loe taksa ah oh pongah, nihcae khaeah kai ih Muithla om poe mak ai; toe a hinghaih loe saning cumvai, pumphaeto ni om tih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","To nathuem ah kalen parai kaminawk long ah khosak o; to pacoengah doeh, Sithaw capanawk loe kami canunawk khaeah caeh o moe, nihcae hoiah caa tapen o; to kaminawk loe canghnii ah thacak kami hoi ahmin kamthang kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Long nuiah kami zaehaih to pung, boeng thai ai kasae hmuen khue ni palung thungah a poek, tiah Angraeng mah hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Long ah a sak ih kami nuiah dawnpakhuem moe, palungset. ");
INSERT INTO cekak_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","To pongah Angraeng mah, Long nuiah ka sak ih, kami, taw ih moi, long ah avak hmuen hoi van ih tavaanawk to ka tamit boih han boeh; nihcae ka sak pongah, dawnpakhuemhaih ka tawnh, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Toe Noah loe Angraeng mikcuk naakrak ah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noah kawng loe hae tiah oh; Noah loe koephaih tawn kami ah oh moe, angmah dung ah kaom kaminawk thungah coek koi om ai kami, Sithaw hoi nawnto lam caeh kami ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah mah capa thumto sak; Shem, Ham hoi Japheth. ");
INSERT INTO cekak_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Long loe Sithaw hmaa ah amro boeh moe, athii longhaih hoiah koi. ");
INSERT INTO cekak_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Sithaw mah long to khet naah, set parai boeh, long kaminawk doeh kasae loklam khue ni pazui o boeh, tito a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","To pongah Sithaw mah Noah khaeah, Long loe athii longhaih hoiah koi sut boeh pongah, taksa ah kaom kami amro boihhaih to ka hmaa ah phak boeh; khenah, nihcae to long hoi nawnto kam rosak han. ");
INSERT INTO cekak_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","To pongah kophar thing hoiah palong to sah ah; a thungah ohhaih imkhaan to sah loe, a thung hoi a nui to hmaica thing tangpri hoiah pazut ah. ");
INSERT INTO cekak_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Palongpui loe hae tiah sah ah; palong loe kasawk dong cumvai thum; kakawk dong qui panga hoi dong qui thumto sangsak ah. ");
INSERT INTO cekak_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Palong imphu to sah ah loe, na sak pacoengah dongto kasang thokbuem to pathlung ah; thokbuem sak hanah palong panak bangah pathlung ah loe, atlim koek asom, hnetto haih asom hoi asom thumto ah sah ah. ");
INSERT INTO cekak_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Khenah, Van tlim ah kaom hinghaih takhi tawn moi boih, long ah kaom sak ih hmuennawk to paduek boih hanah, long tui uemhaih to ka phaksak han. ");
INSERT INTO cekak_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Toe Kai loe nang hoi lokmaihaih to ka caksak han; nang loe na capanawk, na zu hoi na capanawk ih zunawk boih hoi nawnto palong thungah akun ah. ");
INSERT INTO cekak_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Hinghaih tawn hmuennawk boih thung hoiah amno hoi ampa kacung ah lah loe, nangmah hoi nawnto hing hanah, palong thungah caeh haih ah. ");
INSERT INTO cekak_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kanghmong tavaanawk, kanghmong moinawk, kanghmong long ah avak moinawk boih, hing hanah amno hoi ampa kacung ah nang khaeah angzo o tih. ");
INSERT INTO cekak_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nangmacae hoi moinawk mah caak hanah, caak koi hmuen congca to patung ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Sithaw mah thuih ih lok baktih toengah, Noah mah sak. ");
INSERT INTO cekak_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Angraeng mah Noah khaeah, Nangmah hoi na imthung takoh boih palong thungah akun oh; nang loe ka hmaa ah vaihi dung ih kaminawk salakah kami katoeng ah kang hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Long nuiah taw ih moi atii anghmat ving han ai ah, atii kamghnong kaciim moi to amno hoi ampa sarihto, acaeng kanghmong kaciim ai moi doeh amno hoi ampa hnetto, ");
INSERT INTO cekak_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","atii kanghmong van ih tavaa doeh amno hoi ampa sarihto ah la boih ah. ");
INSERT INTO cekak_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Vaihi hoi ni sarihto thungah, long ah ni qui palito hoi qum qui palito thung kho kang oihsak moe, long nuiah kaom ka sak ih kahing hmuennawk to kam rosak boih han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Angraeng mah thuih ih lok baktih toengah Noah mah sak boih. ");
INSERT INTO cekak_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Long to tui mah uem naah, Noah loe saning cumvai tarukto oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tui len pongah, Noah mah a capanawk, a zu hoi a capanawk ih zu boih, palong thungah akun haih. ");
INSERT INTO cekak_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Kaciim hoi kaciim ai moinawk, tavaanawk hoi long ah kavak moinawk boih, ");
INSERT INTO cekak_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Sithaw mah Noah khaeah thuih ih lok baktih toengah, amno hoi ampa hnetto kacung ah, Noah hoi nawnto palong thungah akun o. ");
INSERT INTO cekak_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ni sarihto pacoengah loe long nuiah tui uemhaih to phak. ");
INSERT INTO cekak_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah hinghaih saning cumvai tarukto koephaih saning, khrah hnetto haih, ni hatlai sarihto naah, kalen hoi kathuk long thung hoiah tui to puek moe, van thokbuemnawk to am-ongh. ");
INSERT INTO cekak_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ni qui palito hoi qum qui palito long nuiah kho angzoh. ");
INSERT INTO cekak_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","To na niah Noah loe a capa Shem, Ham hoi Japheth, a zu hoi a capa thumto ih zunawk, ");
INSERT INTO cekak_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Moi kasannawk, pacah ih moinawk boih, long ah kavak moi, pakhraeh tawn tavaanawk loe Noah hoi nawnto palong thungah akun o. ");
INSERT INTO cekak_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Hinghaih tawn, moinawk boih loe hnetto kacung ah, Noah khaeah caeh o moe, palong thungah akun o. ");
INSERT INTO cekak_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Sithaw mah Noah khaeah thuih ih lok baktih toengah, moinawk boih amno hoi ampa kacung ah, Noah khaeah palong thungah akun o; to pacoengah Angraeng mah anih to thok khah thuih khoep. ");
INSERT INTO cekak_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Long loe ni qui palito thung tui mah uem; kalen aep aep tui mah palong to long ranui ah atoengh tahang. ");
INSERT INTO cekak_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Tui loe len moe, long ranui bangah sang tahang aep aep; tui mah palong to long ranui ah atoengh tahang. ");
INSERT INTO cekak_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Long nuiah tui len parai pongah, van tlim ah kaom, maesangnawk to tui mah uem boih. ");
INSERT INTO cekak_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mae ranuih dong hatlai panga karoek to tui mah uengh tahang. ");
INSERT INTO cekak_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Long ah kaom angtawt thaih moinawk, tavaanawk, pacah ih moinawk, taw ih moisannawk, long ah kavak moinawk hoi kaminawk to duek o boih. ");
INSERT INTO cekak_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Saoeng ah kaom, hnah hoi anghahaih takhi tawn moinawk to duek o boih. ");
INSERT INTO cekak_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Long nuiah kaom kahing hmuennawk, kami, pacah ih moi, long ah kavak moinawk, van ih tavaanawk to tamit boih; Noah angmah, anih hoi nawnto kaom kaminawk khue ni anghmat o. ");
INSERT INTO cekak_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tui mah long to ni cumvai, qui pangato thung uem. ");
INSERT INTO cekak_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Toe Sithaw mah kahing hmuennawk boih, Noah hoi nawnto kaom moinawk boih to pahnet ai; long nuiah takhi to songsak pongah, tui to anghak. ");
INSERT INTO cekak_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kathuk thung ih tuipueknawk hoi van ih thokbuemnawk to anghak moe, van hoi angzo kho to dip. ");
INSERT INTO cekak_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Long asom ih tui to kaang tathuk; ni cumvai, qui pangato pacoengah, tui to amsah tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Khrah sarihto, ni hatlai sarihto naah, palong to Ararat mae nuiah angtang. ");
INSERT INTO cekak_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Khrah ha karoek to tui to amsah tathuk, khrah hato haih hmaloe koek niah loe kasang maenawk to amtueng boeh. ");
INSERT INTO cekak_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ni qui palito pacoengah, Noah mah a sak ih palong thokbuem to paongh; ");
INSERT INTO cekak_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","pangaah maeto a prawt, pangaah loe long nuiah tui kang ai karoek to, ahnuk ahma azawk. ");
INSERT INTO cekak_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","To pacoengah long nuiah tui kaang boeh maw tiah panoek hanah, pahuu maeto a prawt let; ");
INSERT INTO cekak_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","toe long to tui mah khuk boih vop pongah, acukhaih ahmuen to hnu ai; to pongah a ohhaih palong ah amlaem let; to pacoengah Noah mah ban to payangh moe, pahuu to angmah khaeah palong thungah lak. ");
INSERT INTO cekak_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ni sarihto zing pacoengah, pahuu to palong thung hoiah a prawt let. ");
INSERT INTO cekak_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Duembang ah loe pahuu to angmah khaeah amlaem let, khenah, pahuu loe tahmawh ah olive thingqam to koeng; to naah long nuiah tui to kaang tathuk boeh, tiah Noah mah panoek. ");
INSERT INTO cekak_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ni sarihto zing pacoengah, pahuu to a prawt let; to pacoengah loe pahuu to angmah khaeah amlaem let ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Saning cumvai taruk, maeto, khrahto haih, ni tangsuek naah long nui ih tui to kaang tathuk; Noah mah palong imphu to khok moe, a khet naah, long nuiah tui to kaang boeh, tiah a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Khrah hnetto haih, ni pumphaeto pacoeng, sarihto naah, long nuiah tui to kaang boih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","To naah Sithaw mah Noah khaeah, ");
INSERT INTO cekak_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Nangmah hoi na zu, na capanawk hoi na capanawk ih zunawk, palong thung hoiah tacawt o laih. ");
INSERT INTO cekak_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nang hoi nawnto kaom hinghaih tawn hmuennawk, moinawk boih, tavaanawk, pacah ih moinawk hoi long ah kavak hmuennawk boih tacawt haih ah; long ah caa kapop ah sah o nasoe, thingthai athai o nasoe loe, long nuiah pung o nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","To pongah Noah loe a caanawk, a zu hoi a caanawk ih zunawk hoi nawnto tacawt o. ");
INSERT INTO cekak_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Moi kasannawk boih, long ah kavak hmuennawk boih, tavaanawk boih, atii kanghmong long ah kavak moinawk boih, palong thung hoiah tacawt o. ");
INSERT INTO cekak_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah mah Angraeng hanah hmaicam to sak; kaciim moi, kaciim tavaa to a lak pacoengah, hmai hoi angbawnhaih to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","To tiah hmai angbawnhaih to Angraeng mah hmuihoih ah thaih pae naah, Angraeng mah palung thung hoiah, Kami mah nawkta nathuem hoiah poekhaih kasae tawn cadoeh, kami hanah long hae ka tangoeng let mak ai boeh; ka sak ih hmuen baktih toengah, kahing hmuennawk to natuek naah doeh kam rosak mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Long oh nathung, antii haehhaih tue, thingthai qumpo lakhaih tue, kangqai tue, kabae tue, nipui tue hoi sik tue, khodai hoi khoving to natuek naah doeh boeng mak ai boeh, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Sithaw mah Noah hoi a caanawk to tahamhoihaih paek, nihcae khaeah, athaih athai oh, pung oh loe, long ah koi oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Long nui ih moi boih, van ih tavaa boih, kavak angtawt thaih long nui ih moi boih, tuipui nui ih tanganawk boih mah, nangcae to zii o ueloe, tasoeh o tih; to moinawk to nangcae ban ah kang paek boih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kangtawt moe, hinghaih tawn angtawt thaih hmuen boih to nang hanah buh ah om tih; kahing aannawk hoi hmuen boih nangcae hanah kang paek boeh. ");
INSERT INTO cekak_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Toe hinghaih tawn moi ih athii to caa o hmah. ");
INSERT INTO cekak_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Na hing o haih, nangcae ih athii to ka suk han; kami hoi moinawk to lok ka caek boih han; kami boih mah angmacae nawkamya ih athii to palong o pongah lok ka caek han. ");
INSERT INTO cekak_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Sithaw angmah ih krang hoi kanghmong ah kami to sak pongah, kami ih athii palong kami loe, anih doeh kami mah athii longsak toeng tih. ");
INSERT INTO cekak_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Toe nang loe, thingthai athai ah loe, pung ah; long ah caa sah o mang ah loe, pung oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","To pacoengah Sithaw mah Noah hoi a caanawk khaeah, ");
INSERT INTO cekak_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Khenah, nang hoi lokmaihaih to ka sak moe, nang pacoeng kaom na caanawk, ");
INSERT INTO cekak_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","nang hoi nawnto kaom hinghaih tawn moinawk, tavaanawk, pacah ih moinawk, long ih moisannawk boih, palong thung hoi tacawt moinawk boih, long ih moinawk boih hoiah doeh, lokmaihaih to ka sak. ");
INSERT INTO cekak_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nang hoi ka sak ih lokmaihaih to ka caksak han; hinghaih tawn moinawk boih loe natuek naah doeh tui uemhaih hoiah kam rosak mak ai boeh; long amrosak hanah natuek naah doeh tui uemhaih thok mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Sithaw mah, Hae loe nang hoi kai salak, nang hoi nawnto kaom moinawk boih salakah dungzan khoek to ka sak ih lokmaih angmathaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Tamai thungah khungzae to ka suek, to loe kai hoi long salakah lokmaih angmathaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Long ah tamai to ka taboksak naah, tamai nuiah khungzae to amtueng tih; ");
INSERT INTO cekak_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","moinawk amrosak boih hanah tui uemhaih om let mak ai boeh, tiah aihnik salak hoi hinghaih tawn moinawk boih salakah ka sak ih, lokmaihaih to ka pahnet mak ai. ");
INSERT INTO cekak_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tamai thungah khungzae kamzam ka hnuk nathung, long nui ih hinghaih tawn moinawk boih hoi Sithaw salakah sak ih dungzan lokmaihaih to ka poek poe han, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Sithaw mah Noah khaeah, Hae loe kai hoi long nuiah kaom hinghaih tawn moinawk boih salakah ka sak ih, lokmaihaih ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Palong thung hoi tacawt Noah ih capa thumtonawk loe, Shem, Ham hoi Japheth; Ham loe Kanan ih ampa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nichae loe Noah ih caa ah oh o moe, nihcae thung hoiah ni long boih ah kaminawk to pung o. ");
INSERT INTO cekak_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah loe lawk phrawk kami ah oh pongah, misur takha to sak; ");
INSERT INTO cekak_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","anih loe misurtui to naek moe, misurtui paquih pongah, angmah ih kahni imthung ah bangkrai ah angsong sut. ");
INSERT INTO cekak_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaan ampa Ham loe bangkrai ah kaom ampa to hnuk naah, tasa bangah kaom amya hnik khaeah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Toe Shem hoi Japheth mah loe kahni to lak hoi moe, palaeng ah a thuengh hoi tahang pacoengah, hnukbang angqoi hoi moe, bangkrai ah kaom ampa to a khuk hoi; hnukbang angqoi hoi pongah bangkrai ah kaom ampa to hnu hoi ai. ");
INSERT INTO cekak_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noah misurtui paquihaih cai naah loe, a capa kanawk mah a nuiah sak ih hmuen to panoek. ");
INSERT INTO cekak_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","To naah Kanaan loe tangoenghaih to zok nasoe loe, amya hnik ih tamna ah om nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","To pacoengah anih mah, Shem ih Angraeng Sithaw loe tahamhoihaih om nasoe loe, Kanaan loe Shem ih tamna ah om nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Sithaw mah Japheth ih prae to kawksak nasoe loe, Japheth loe Shem ih kahni im ah om nasoe; Kanaan loe anih ih tamna ah om nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah loe tui uemhaih phak pacoengah, saning cumvai thum, qui pangato hing vop. ");
INSERT INTO cekak_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noah loe saning cumvai takawt, qui pangato hing pacoengah duek. ");
INSERT INTO cekak_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tui uemhaih phak pacoengah kaom, Noah ih caa Shem, Ham hoi Japheth kawng loe hae tiah oh. ");
INSERT INTO cekak_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japheth ih caanawk loe Gomer, Magog, Madai, Javan, Tubal, Meshek hoi Tiras. ");
INSERT INTO cekak_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer ih caanawk loe, Ashkenaz, Riphath hoi Togarmah. ");
INSERT INTO cekak_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan ih caanawk loe, Elishah, Tarshish, Kittim hoi Dodanim. ");
INSERT INTO cekak_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nihcae loe tuipui mah takui ih prae thungah khosah Gentel kami ah oh o; angmacae acaeng hoi angmacae prae thungah kho a sak o moe, angmacae ih lok to patoh o. ");
INSERT INTO cekak_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham ih caanawk loe Kush, Mizraim, Phut hoi Kanaan. ");
INSERT INTO cekak_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kush ih caanawk loe Seba, Havilah, Sabtah, Raamah hoi Sabtaka; Raamah ih caanawk loe, Sheba hoi Dedan. ");
INSERT INTO cekak_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush mah long nuiah misatuh thaih, thacak Nimrod to sak. ");
INSERT INTO cekak_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Anih loe Angraeng hmaa ah thacak, moi kaat kop kami ah oh; to pongah kaminawk mah, Angraeng hmaa ah thacak, moi kaat kop Nimrod baktiah, tiah ruici to thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Anih ih vangpui hmaloe koek loe Babel Erek, Akkad hoi Shinar thungah kaom Kalneh. ");
INSERT INTO cekak_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","To prae thung hoiah Asshur prae thungah a caeh moe, to ah Nineveh, Rehoboth hoi Kalah, ");
INSERT INTO cekak_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Nineveh hoi Kalah salakah kaom, kalen parai vangpui Resen to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim loe Ludim, Anamim, Lehabim, Naphtuhim, ");
INSERT INTO cekak_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusim, Kashluhim, hoi (to thung hoiah Philistin kaminawk to tacawt o), Kaphtor kaminawk ih ampa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan mah calu Sidon hoi Heth to sak, ");
INSERT INTO cekak_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebus, Amor, Girgash, ");
INSERT INTO cekak_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiv, Ark, Sin, ");
INSERT INTO cekak_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvad, Zemar hoi Hammath kaminawk cunkung ah oh; to pacoengah loe Kanaan kaminawk ampraek o phang boeh. ");
INSERT INTO cekak_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaan prae ramri loe Sidon hoi Gerar, Gerar hoi Gaza khoek to oh moe, to ahmuen hoiah Sodom, Gomorrah, Admah hoi Zeboim, Lasha karoek to phak. ");
INSERT INTO cekak_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hae kaminawk loe Ham capa hoi anih ih imthung takoh, a lok, a prae hoi acaeng kaminawk ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem mah doeh caanawk sak toeng, Japheth loe anih ih amya ah oh; Shem loe Eber capanawk boih cunkung ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem ih caanawk loe Elam, Asshur, Arphazad, Lud hoi Aram. ");
INSERT INTO cekak_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ih caanawk loe Uz, Hul, Gether hoi Mash cae hae ni. ");
INSERT INTO cekak_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphazad mah Salah to sak; Salah mah Eber to sak. ");
INSERT INTO cekak_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber mah caa hnetto sak; maeto loe Peleg, tiah ahmin sak; anih dung naah long to tapraek o; anih amnawk ih ahmin loe Joktan. ");
INSERT INTO cekak_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan loe Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO cekak_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO cekak_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO cekak_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah hoi Jobab cungkung ah oh; nihcae boih loe Joktan ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Nihcae ohhaih prae loe Mesha hoi ni angyae bangah Sephar mae karoek to kawk. ");
INSERT INTO cekak_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hae kaminawk loe Shem ih caanawk ah oh o moe, angmacae imthung takoh, angmacae ih lok, angmacae ih prae hoi angmacae ih acaeng baktih toengah khosak o. ");
INSERT INTO cekak_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hae kaminawk loe angmacae acaeng baktih toengah pakuem ih Noah ih caa ah oh o; tui uem pacoengah kaminawk loe hae ahmuen hoiah long nui boih ah ampraek o. ");
INSERT INTO cekak_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","To naah long pum ah lok maeto khue oh moe, lok maeto ni apaeh o. ");
INSERT INTO cekak_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ni angyae bang hoiah a caeh o, Shinar azawn to hnuk o naah, to ah khosak o. ");
INSERT INTO cekak_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","To naah nihcae mah maeto hoi maeto khaeah, Angzo oh, amlai long pahlom o si loe, hmaiqoeng o si, tiah thuih o. Thlung zuengah amlai long to patoh o moe, param long zuengah thing tangpri to patoh o. ");
INSERT INTO cekak_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nihcae mah, Angzo oh, vangpui maeto sah o si loe, van pha khoek to imsang to sah o si; aimacae ahmin amthang hanah sah o si, to tih ai nahaeloe long pum ah ampraek o boih moeng tih, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Angraeng loe kaminawk mah sak ih imsang hoi vangpui to khet hanah, angzoh tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Angraeng mah, Khenah, kaminawk loe maeto ah oh o moe, lok maeto apaeh o boih pongah, hae tok hae sak amtong o boeh; vaihi sak han a poek o ih hmuen hae pakaahaih tidoeh om ai ah sah o tih. ");
INSERT INTO cekak_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Angzo oh, caeh o tathuk si loe, maeto hoi maeto lok angthaih han ai ah, lok anghmangsak si, tiah thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","To pongah Angraeng mah nihcae to long pum ah ampraeksak; to naah vangpui to sah ai ah toengh o sut. ");
INSERT INTO cekak_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Angraeng mah long pum ah kaom kaminawk to lok anghmangsak, to ahmuen hoiah nihcae to long pum ah ampraeksak phang, to pongah vangpui to Babel, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Shem ih caanawk kawng loe hae tiah oh; Shem loe saning cumvaito oh moe, tui uemhaih phak pacoeng, saning hnetto naah, Arphazad to sak; ");
INSERT INTO cekak_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arphazad to a sak pacoengah, Shem loe saning cumvai pangato hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arphazad loe saning qui thum, pangato naah Salah to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arphazad loe Salah sak pacoengah, saning cumvai pali, thumto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salah loe saning qui thumto naah, Eber to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Salah loe Eber sak pacoengah saning cumvai pali, thumto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber loe saning qui thum, palito naah Peleg to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber loe Peleg sak pacoengah, saning cumvai pali, qui thumto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg loe saning qui thumto naah Reu to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg loe Reu sak pacoengah, saning cumvai hnet, takawtto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu loe saning qui thum, hnetto naah Serug to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu loe Serug sak pacoengah, saning cumvai hnet, sarihto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug loe saning qui thumto naah Nahor to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug loe Nahor sak pacoengah, saning cumvai hnetto hing moe, kalah capa hoi canunawk doeh sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor loe saning pumphae takawtto naah, Terah to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor loe Terah sak pacoengah, saning cumvai, hatlai takawtto hing moe, capa hoi canunawk sak vop. ");
INSERT INTO cekak_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah loe saning cumvai sarihto naah, Abram, Nahor hoi Haran to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terah ih caanawk kawng loe hae tiah oh; Terah mah Abram, Nahor hoi Haran to sak; Haran mah Lot to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran loe ampa Terah dueh ai naah, a tapenhaih Khaldia prae Ur vangpui ah duek. ");
INSERT INTO cekak_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram hoi Nahor loe zu lak hoi hmaek; Abram ih zu loe Sarai; Nahor ih zu loe Milkah; Haran mah canu, Milkah hoi Ishkah to sak. ");
INSERT INTO cekak_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai loe caa kaak; to pongah caa sah ai. ");
INSERT INTO cekak_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah mah a capa Abram, Haran ih capa Lot, a capa Abram ih zu, a langah Sarai to kawk moe, Khadia prae Ur vangpui hoiah Kanaan prae ah caeh haih; Haran vangpui phak o naah, to ah khosak o. ");
INSERT INTO cekak_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah loe saning cumvai hnet, pangato hing moe, Haran vangpui ah duek. ");
INSERT INTO cekak_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Angraeng mah Abram khaeah, Na prae, nangmah ih canawk hoi na imthung takohnawk to caehtaak loe, kang patuek han ih prae ah caeh ah. ");
INSERT INTO cekak_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Acaeng kalen kami ah kang sak han, tahamhoihaih kang paek moe, na hmin kang lensak han; tahamhoihaih na hnu tih. ");
INSERT INTO cekak_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nang tahamhoihaih paek kaminawk to tahamhoihaih ka paek moe, nang tangoeng kaminawk to ka tangoeng han; nang rang hoiah long ah kaom kaminawk boih tahamhoih o tih. ");
INSERT INTO cekak_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Angraeng mah anih khaeah thuih pae ih lok baktih toengah, Abram mah loe caeh; Lot doeh anih hoi nawnto caeh; Haran vangpui hoi tacawt naah, Abram loe saning qui sarih, pangato oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram loe a zu Sarai, amya capa Lot, a tawnh ih hmuennawk boih, Haran vangpui hoiah kawk ih kaminawk boih Kanaan prae ah caeh haih, Kanaan prae to a phak o. ");
INSERT INTO cekak_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram loe kahoih Shekem ih ahmuen ah caeh moe, Moreh ih azawn to phak naah, Kanaan kaminawk loe to prae thungah khosak o boeh. ");
INSERT INTO cekak_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Abram khaeah Angraeng angphong moe, hae prae hae na caanawk khaeah ka paek han, tiah a naa. To pongah anih khaeah amtueng, Angraeng hanah to ahmuen ah hmaicam maeto a sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Anih loe to ahmuen hoiah angthawk moe, Bethel ni angyae bang kaom mae ah caeh pacoengah, ni duembang kaom Bethel vangpui hoi ni angyae bang kaom Ai vangpui salakah, kahni im to a sak; to ahmuen ah Angraeng khaeah hmaicam maeto a sak moe, Angraeng ih ahmin to palawk. ");
INSERT INTO cekak_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram loe to ahmuen hoiah angthawk let moe, aloih bangah caeh tatuk. ");
INSERT INTO cekak_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","To nathuem ah Kanaan prae thungah khokhahaih to oh; prae thungah khokha nung parai pongah, Abram loe Izip prae ah khosak han caeh tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Izip prae thung akun tom naah, a zu Sarai khaeah, Nang loe kranghoih nongpata ah na oh, tito ka panoek; ");
INSERT INTO cekak_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Izip kaminawk mah nang ang hnuk o naah, Hae nongpata loe anih ih zu ni, tiah thui o tih; nihcae kai hae na hum o ueloe, nang loe na loih o sak tih. ");
INSERT INTO cekak_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","To pongah kai loe anih ih tanuh ni, tiah thui ah; to tiah ni nang rang hoiah kai hae kahoih ah na khenzawn o ueloe, ka hinghaih loih tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Izip prae thung akun naah, Izip kaminawk mah anih ih zu to kranghoih parai ah hnuk o. ");
INSERT INTO cekak_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Faro ih angraengnawk mah anih to hnuk o naah, Faro khaeah thuih pae o, nongpata to Faro siangpahrang im ah caeh o haih. ");
INSERT INTO cekak_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Anih pongah Abram to Faro mah kahoih ah khetzawn; Abram hanah tuunawk, maitaw taenawk, laa hrang ataenawk, tamna nongpanawk hoi tamna nongpatanawk, laa hrang amnonawk hoi kaengkuu hrangnawk to a paek. ");
INSERT INTO cekak_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Toe Abram ih zu Sarai pongah, Angraeng mah Faro hoi a imthung takoh nuiah kasae nathaih to phaksak. ");
INSERT INTO cekak_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","To pongah Faro mah Abram to kawk moe, Tipongah hae tiah nang sak loe? Tipongah anih loe ka zu ni, tiah nang thui ai loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tikhoe anih loe ka tanuh ni, tiah nang thuih moe, ka zu ah nang laksak loe? To pongah vaihi na zu hae lah loe, caeh lai ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Abram kawng pongah Faro mah angmah ih kaminawk khaeah thuih pae ih lok baktih toengah, nihcae mah Abram to a zu hoi a tawnh ih hmuennawk hoi nawnto patoeh o ving. ");
INSERT INTO cekak_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","To pongah Abram loe a zu hoi a tawnh ih hmuennawk boih to sinh moe, Izip prae thung hoiah caeh tahang; Lot doeh anih hoi nawnto caeh. ");
INSERT INTO cekak_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","To naah Abram loe pacah ih moinawk, sum kanglung, suinawk hoiah angraeng parai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Aloih bang hoiah Bethel ah caeh, tangsuek nathuem hoi a sak ih kahni im ohhaih Bethel hoi Hai salakah a caeh, ");
INSERT INTO cekak_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","a sak hmaloe ih hmaicam ohhaih ahmuen to phak naah, to ahmuen ah Abram mah Angraeng ih ahmin to palawk. ");
INSERT INTO cekak_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abram hoi nawnto kacaeh Lot doeh, tuunawk, maitawnawk hoi kahni imnawk tawnh toeng. ");
INSERT INTO cekak_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nihnik nawnto khosak han long ahmuen mah khawt ai boeh; a tawnh hoi ih hmuennawk pop parai boeh pongah, nawnto om hoi thai ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abram ih maitaw toep kaminawk hoi Lot ih maitaw khenzawn kaminawk to angzoeh o; to naah Kanaan kaminawk hoi Periz kaminawk loe to prae thungah oh o boeh. ");
INSERT INTO cekak_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","To pongah Abram mah Lot khaeah, Aihnik loe nawkamya ah ni a oh o; nang hoi kai salak, nang ih maitaw toep kami hoi kai ih maitaw khen kami salakah, angzoehhaih om hmah nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kawk parai prae na hma ah om ai maw? Kai hoi ampraek halat si; nang banqoi bangah na caeh nahaeloe, kai bantang bangah ka caeh han; nang bantang bangah na caeh nahaeloe, kai banqoi bangah ka caeh han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot mah khet naah, Angraeng ih takha baktih, Zoar vangpui ah na caeh naah Izip prae baktih kaom, ahmuen kruekah long kaduk Jordan azawn ah to a hnuk; to tui kahoih azawn loe Angraeng mah phraek ih Sodom hoi Gomorrah vangpui pha ai naah oh. ");
INSERT INTO cekak_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot mah angmah hanah Jordan azawn to qoih moe, ni angyae bangah a caeh; to tiah maeto hoi maeto ampraek hoi. ");
INSERT INTO cekak_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram loe Kanaan prae ah oh, Lot loe azawn taengah kaom vangpuinawk ah khosak moe, Sodom vangpui taengah kahni im to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom vangpui ih kaminawk loe set o moe, Angraeng hmaa ah doeh pop parai zaehaih hoiah khosak o. ");
INSERT INTO cekak_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot mah anih caehtaak pacoengah, Angraeng mah Abram khaeah, Na ohhaih ahmuen hoi aluek, aloih, ni angyae hoi niduem bang to doeng ah; ");
INSERT INTO cekak_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","na hnuk ih prae boih nangmah hoi na caanawk khaeah, dungzan khoek to kang paek han. ");
INSERT INTO cekak_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Na caanawk to long ih maiphu zetto kang pungsak han; kami mah maiphu kroek thaih nahaeloe, na caanawk doeh kroek o thai tih. ");
INSERT INTO cekak_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Angthawk loe, prae to kasawk hoi kalen boenghaih khoek to amkae boih ah; to ahmuen to nang khaeah kang paek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","To pongah Abram mah kahni im to khok, Hebron ih Mamre azawn ah caeh moe, to ah khosak; to ahmuen ah Angraeng han hmaicam maeto a sak. ");
INSERT INTO cekak_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","To naah Shinar siangpahrang Amraphel, Ellasar siangpahrang Ariok, Elam siangpahrang Kedorlaomer hoi Goiim siangpahrang Tidal cae loe, ");
INSERT INTO cekak_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","caeh o moe, Sodom siangpahrang Bera, Gomorrah siangpahrang Birsha, Admah siangpahrang Shinah, Zeboiim siangpahrang Shemeber hoi Bela (to loe Zoar ni) siangpahrang to tuk o. ");
INSERT INTO cekak_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","To siangpahrangnawk boih loe Siddim paloi tuili azawn ah atai o. ");
INSERT INTO cekak_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Nihcae loe saning hatlai hnetto thung Kedorlaomer ban thungah oh o, toe saning hatlai thumto naah loe, misa angthawk o. ");
INSERT INTO cekak_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Saning hatlai palito naah, Kedorlaomer siangpahrang loe anih angdoe haih siangpahrangnawk hoi nawnto angzoh o moe, Ashteroth Karnaim ah kaom Rephaim kaminawk, Ham ah kaom Zuzim kaminawk, Shaveh Kiriathaim ah kaom Emim kaminawk, ");
INSERT INTO cekak_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Seir mae ah kaom Hor kaminawk to tuk o moe, praezaek taengah kaom El-Paran vangpui khoek to patom o. ");
INSERT INTO cekak_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","To pacoengah amlaem o moe, En-Mishpat (Kadesh) ah caeh o; Amalek prae pum hoi Hazezon-Tamar prae ah kaom, Amor kaminawk doeh tuk pazawk o. ");
INSERT INTO cekak_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","To naah Sodom siangpahrang, Gomorrah siangpahrang, Admah siangpahrang, Zeboiim siangpahrang hoi Bela (Zoar) siangpahrang mah misatuk hanah Siddim azawn ah caeh haih moe, ");
INSERT INTO cekak_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elam siangpahrang Kedorlaomer, Goiim siangpahrang Tidal, Shinar siangpahrang Amraphel hoi Ellasar siangpahrang Ariok, siangpahrang palito hoiah siangpahrang pangatonawk misa angtuk o. ");
INSERT INTO cekak_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddim azawn loe tangnong cing ah oh; Sodom hoi Gomorrah ih siangpahrang hnik loe cawnh hoi ving, toe to ih tangnong thungah krak hoi hmaek; kanghmat kaminawk loe mae nuiah cawnh o. ");
INSERT INTO cekak_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Misatuk pazawk siangpahrangnawk mah Sodom hoi Gomorrah vangpui ih hmuennawk hoi caaknaeknawk to lak pae o boih pacoengah caeh o taak. ");
INSERT INTO cekak_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sodom vangpui ah kaom Abram amya ih capa, Lot hoi anih ih hmuennawk doeh lak pae o boih. ");
INSERT INTO cekak_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Misa angtukhaih thung hoi loih kami maeto mah to kawng to Hebru kami, Abram khaeah thuih pae; to naah Abram loe Eshkol hoi Aner amnawk, Amor kami Mamre ih azawn taengah oh; to ah kaom kaminawk loe Abram hoi ampui ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Misanawk mah amya ih caanawk naeh o boih boeh, tiah Abram mah thaih naah, angmah im ah tapen kami, angmah patuk ih kami cumvai thum, hatlai tazetto hoiah nihcae to Dan vangpui karoek to patom o. ");
INSERT INTO cekak_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Angmah ih kaminawk to tapraek moe, to kaminawk to khoving ah tuksak pacoengah, Damaska vangpui aluek bangah kaom Hobah vangpui khoek to patom o. ");
INSERT INTO cekak_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hmuennawk to lomh pae o let moe, amya capa, Lot hoi anih ih hmuennawk, nongpatanawk hoi kaminawk to hoih pae o boih let. ");
INSERT INTO cekak_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram loe Kedolaomer siangpahrang hoi anih ih ampui siangpahrangnawk to pazawk boih pacoengah amlaem let, to naah Sodom siangpahrang mah anih to Shaveh azawn (to loe siangpahrang ih azawn ah oh) karoek to dawt. ");
INSERT INTO cekak_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","To naah Salem siangpahrang Melkhizedik mah takaw hoi misurtui to sinh; anih loe Sang koek Sithaw ih qaima ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Anih mah Abram tahamhoihaih paek moe, Sang koek Sithaw, van hoi long sahkung mah, Abram tahamhoihaih paek nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na misanawk na ban ah paekkung, Sang koek Sithaw loe, tahamhoihaih om nasoe, tiah a naa. To naah Abram mah a tawnh ih hmuen boih thung hoiah hato thungah maeto anih khaeah paek. ");
INSERT INTO cekak_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom siangpahrang mah Abram khaeah, Kaminawk to kai han na paek ah, hmuennawk loe nangmah hanah la ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Toe Abram mah Sodom siangpahrang khaeah, Sang koek Sithaw, van hoi long sahkung, Angraeng khaeah ban payangh moe, lokkamhaih ka sak boeh pongah, ");
INSERT INTO cekak_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nang ih hmuen tih ta doeh ka la mak ai, khopanai bum aqui hoi tlangqui tetta mataeng doeh ka la mak ai; to tih ai nahaeloe Abram loe kaimah ni kang raengsak, tiah na thui moeng tih; ");
INSERT INTO cekak_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","kai ih kaminawk mah patoh o moe, a caak o ih hmuen khue to ka lak han; kai bomkung Aner, Eshkol hoi Mamre cae loe angmacae hnuk han koi taham to la o nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","To pacoengah hnuksakhaih hoiah Angraeng ih lok Abram khaeah phak; Abram zii hmah; kai loe nang abuephaih, kalen parai nang ih tangqum ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Toe Abram mah, Angraeng Sithaw, timaw nang paek han? Kai loe caa tawn ai ah kho ka sak; Damaska ih Eliezer mah ni kai ih qawk to toep tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram mah, Khenah, kai han caa nang paek ai; to pongah ka imthung ah tapen kami mah ni kai ih qawk to toep tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","To naah Angraeng ih lok anih khaeah angzoh; Na tamna mah nang ih qawk to toep mak ai; toe na takpum thung hoi tacawt na capa tangtang mah ni nang ih qawk to toep tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Abram to tasa bangah caeh haih moe, anih khaeah, Van bang doeng tahang ah, cakaehnawk na kroek thaih nahaeloe, kroek ah; na caanawk loe to tiah om o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram mah Angraeng to tang pongah, a tanghaih to toenghaih ah tapom pae. ");
INSERT INTO cekak_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Anih khaeah, Kai loe hae prae hae qawk ah paek hanah, Khaldia prae Ur vangpui hoiah nang zaehoikung, Angraeng ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Toe Abram mah, Angraeng Sithaw, hae prae hae qawk ah ka toep han, tito kawbang maw ka panoek thai tih? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","To pongah Angraeng mah anih khaeah, Saning thumto kaom maitaw tae maeto, saning thumto kaom maeh amno maeto, saning thumto kaom tuu tae maeto, pahuu maeto hoi im pahuu maeto na sin ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram mah to hmuennawk to sinh boih; hnetto ah a bawk moe, kalah kalah ah suek boih; toe tavaanawk loe hnetto ah bawk ai. ");
INSERT INTO cekak_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Moicaa tavaanawk loe kadueh qok moinawk nuiah azawk o tathuk, to naah Abram mah tavaanawk to huih boih. ");
INSERT INTO cekak_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Niduem naah loe iih kangmue mah kae pongah Abraham loe iih; to naah zit kaom kalen parai khoving mah anih to khuk hmoek. ");
INSERT INTO cekak_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","To naah Angraeng mah anih khaeah, Na caanawk loe minawk prae ah angvin ah om o tih; to kaminawk ih tamna ah om o ueloe, nihcae mah saning cumvai palito thung pacaekthlaek o tih, tito panoek ah; ");
INSERT INTO cekak_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","toe nangcae tamna ah patoh acaeng to lok ka caek han; to pacoengah ni nihcae to paroeai pop hmuenmaenawk hoiah tacawt o vop tih. ");
INSERT INTO cekak_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nang loe lunghoih ta hoi nam panawk khaeah na caeh ueloe, mitong naah na phum o tih. ");
INSERT INTO cekak_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Na caanawk loe dung palito phak naah, hae ahmuen ah angzo o let tih; Amor kaminawk sakpazaehaih koep ai vop, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Aduem bang khoving ah loe, akhue tacawt hmai kangqong, pa-aang ih hmai-im to tacawt moe, kalah kalah ah tapraek ih moi salakah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","To na niah Angraeng mah Abram hoi lokmaihaih to sak moe, Izip prae vapui thung hoiah kalen parai vapui, Euphrates vapui; ");
INSERT INTO cekak_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ken, Ken-zi, Kadmon, ");
INSERT INTO cekak_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit, Periz, Rephaim, ");
INSERT INTO cekak_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor, Kanaan, Girgash hoi Jebus kaminawk ih prae loe na caanawk khaeah ka paek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram zu, Sarai loe caa kaak; toe anih loe Izip tanuh, Hagar tiah ahmin kaom tamna maeto tawnh. ");
INSERT INTO cekak_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","To pongah Sarai mah Abram khaeah, Angraeng mah caa ang kaaksak boeh; caeh ah loe ka tamna nongpata khaeah iip ah, anih mah caa na sah pae khoe doeh om tih, tiah a naa. Abram mah Sarai ih lok to tahngaih pae. ");
INSERT INTO cekak_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abram loe Kanaan prae ah saning hato oh pacoengah, Sarai mah a tamna nongpata, Izip tanuh Hagar to lak moe, zu haih hanah sava khaeah paek. ");
INSERT INTO cekak_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram mah Hagar to iih haih, to naah nongpata to zokpomh; zokpom boeh, tiah Hagar mah panoek naah angmah angraeng ih zupui to hnap. ");
INSERT INTO cekak_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","To naah Sarai mah Abram khaeah, Ka sakpazae ih hmuen loe na lu nuiah om nasoe; ka tamna nongpata to na saoek nuiah kang paek; anih mah zokpom boeh, tiah panoek naah, kai hae ang patoek; nang hoi kai salakah Angraeng mah lokcaek halat nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Toe Abram mah Sarai khaeah, Na tamna nongpata loe na ban ah ni oh; na koeh baktiah a nuiah sah khae, tiah a naa. Sarai mah Hagar to pacaekthlaek, to pongah Hagar loe anih khae hoi cawnh ving. ");
INSERT INTO cekak_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Angraeng ih van kami mah Hagar to praezaek tuipuek taeng, Shur vangpui caehhaih loklam taengah hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Anih mah, Sarai ih tamna nongpata, Hagar, naa hoiah maw nang zoh? Naa ah maw na caeh han? tiah a naa. Anih mah, Ka angraeng zupui Sarai khae hoiah ka cawnh ving, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","To naah Angraeng ih van kami mah anih khaeah, Na angraeng zupui khaeah amlaem let loe, anih tlim ah khosah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Van kami mah anih khaeah, Kroek laek ai khoek to na caanawk kang pungsak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Angraeng ih van kami mah anih khaeah, Khenah, nang loe zokpomh boeh, caa nongpa to na sah tih; na patanghaih Angraeng mah thaih pae boeh pongah, anih ih ahmin to Ishmael, tiah sah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Anih loe poek ham kami ah om ueloe, kami boih hoi angtuh tih, kami boih mah anih to tuh tih; anih loe angmah ih nawkamyanawk taengah khosah tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","To naah Hagar mah, angmah khaeah lokthuikung Angraeng to, Nang loe kai hnukung Sithaw, tiah ahmin paek; anih mah, Vaihi kai Hnukung to ka hnuk boeh, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","To pongah to ih tuipuek to, Beer Lahai Roi, tiah ahmin sak; khenah, to tuipuek loe Kadesh hoi Bered salakah oh. ");
INSERT INTO cekak_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar mah Abram hanah capa maeto sak pae; Hagar mah sak pae ih capa to Abram mah Ishmael, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar mah Abram han Ishmael sak pae naah, Abram loe saning qui tazet, tarukto oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram loe saning qui takawt, takawtto naah, Angraeng mah amtueng thuih; anih khaeah, Kai loe Thacak Sithaw ah ka oh; na koep thai hanah, ka hmaa ah caeh ah. ");
INSERT INTO cekak_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kai hoi nang salakah lokmaihaih ka sak moe, nang to pop parai ah kang pungsak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","To naah Abram loe long ah akuep; Sithaw mah anih khaeah, ");
INSERT INTO cekak_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","khenah, ka sak ih lokmaihaih loe nang khaeah oh; nang loe prae kami boih ih ampa ah na om tih. ");
INSERT INTO cekak_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nang ih ahmin loe Abram, tiah kawk mak ai boeh; Abraham, tiah ni kawk tih boeh; nang loe prae kami boih ih ampa ah kang sak boeh. ");
INSERT INTO cekak_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Athaih paroeai kang thaisak moe, nang khae hoiah kami congca kang coengsak han; siangpahrangnawk doeh nang khae hoiah ni tacawt o tih. ");
INSERT INTO cekak_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kai loe na Sithaw, na caanawk ih Sithaw ah ka oh moe, nang hoi na caanawk boih nuiah dungzan khoek to ka sak ih lokmaihaih to ka caksak han. ");
INSERT INTO cekak_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Vaihi angvin ah na ohhaih prae, Kanaan prae boih to dungzan ah toep hanah, nang hoi na hnuk ah angzo na caanawk khaeah ka paek han; kai loe nihcae ih Sithaw ah ka oh han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","To pacoengah Sithaw mah Abraham khaeah, Nangmah hoi na hnuk ah angzo han koi na caanawk boih mah loe, ka sak ih lokmaihaih to pazui oh. ");
INSERT INTO cekak_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Hae loe nangmah hoi na hnuk ah angzo han koi na caanawk salakah, na pazui o han ih ka lokmaihaih ah oh; nangcae thung ih nongpa boih tangzat hin aat oh. ");
INSERT INTO cekak_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Tangzat hin to aat oh; to loe kai hoi nang salakah sak ih lokmaih angmathaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Angzo han koi na caanawk boih, na imthung ah tapen kami, to tih ai boeh loe nangmah ih acaeng na ai, phoisa hoi qan ih prae kalah kami boih, ni tazetto koep naah tangzat hin aat oh. ");
INSERT INTO cekak_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Na imthung ah tapen kami doeh, phoisa hoi qan ih kami doeh, tangzat hin aah han angaih; na taksa nuiah ka sak ih lokmaihaih to dungzan khoek to om tih. ");
INSERT INTO cekak_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tangzat hin aat ai caa nongpa, tangzat hin aat ai kami loe, acaeng thung hoiah pahnawt ah; anih loe ka lokmaihaih phraekung ah ni oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Sithaw mah Abram khaeah, na zu Sarai loe Sarai, tiah kawk hmah lai ah; anih ih ahmin loe Sarah, tiah om tih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Anih to tahamhoihaih ka paek han, anih mah capa maeto na sah pae tih; ue, anih to tahamhoihaih ka paek han, anih loe prae kami boih ih amno ah om tih; siangpahrangnawk doeh anih thung hoiah ni tacawt tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham loe mikhmai akuep tathuk moe, pahnuih pacoengah, a palung thung hoiah, Saning cumvaito kaom kami mah caa sah vop tih maw? Saning qui takawt, takawtto kaom, Sarah mah caa sah vop tih maw? tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham mah Sithaw khaeah, Aw Ishmael loe na hmaa ah hing nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Sithaw mah, Na zu Sarah mah capa na sah pae tih; anih ih ahmin to Issak, tiah sah ah; anih hoi anih hnuk ah angzo a caanawk khaeah doeh dungzan lokmaihaih to ka sak han. ");
INSERT INTO cekak_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ishmael han na thuih ih lok to ka thaih boeh; khenah, anih to tahamhoihaih ka paek han, athaih ka thaisak moe, pop parai ah ka pungsak han; anih loe ukkung hatlai hnetto ih ampa ah om ueloe, anih to kalen parai acaeng ah kang coengsak han. ");
INSERT INTO cekak_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Toe hmabang saning vaihi atue ah, Sarah mah ang sak pae han ih Issak hoiah ni lokmaihaih to ka sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lokthuih boih pacoengah, Sithaw loe Abraham khae hoiah caeh tahang ving. ");
INSERT INTO cekak_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","To na niah Abraham mah a capa Ishmael, a imthung ah tapen kaminawk boih, phoisa hoi qan ih kaminawk boih, imthung ah kaom nongpa boih to kawk moe, Sithaw mah thuih ih lok baktih toengah, tangzat hin to aahsak. ");
INSERT INTO cekak_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Tangzat hin aah naah, Abraham loe saning qui takawt, takawtto oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","A capa Ishmael loe saning hatlai thumto oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham hoi a capa Ishmael loe to na niah tangzat hin aah hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abraham im ah kaom nongpa boih, anih im ah tapen nongpa boih, prae kalah ah phoisa hoi qan ih kaminawk boih, angmah hoi nawnto tangzat hin aah o. ");
INSERT INTO cekak_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abraham loe Mamre azawn ah oh, ni bet moe, kahni im ah anghnut naah, Angraeng anih khaeah amtueng. ");
INSERT INTO cekak_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham mah doeng tahang naah, a taengah anghnu kami thumto a hnuk; nihcae to a hnuk naah, nihcae tongh hanah angmah ih kahni im khongkha taeng hoiah karangah caeh moe, long ah akuep. ");
INSERT INTO cekak_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Nihcae khaeah, Ka Angraeng na mikcuk naakrak ah ka oh nahaeloe, na tamna kai hae na caehtaak hmah. ");
INSERT INTO cekak_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Na khok pasaeh hanah, tui zetta ka lak han, khok nam saeh o pacoengah doeh, thing tahlip ah anghak o raeh. ");
INSERT INTO cekak_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Caak han takaw zetta ka lak han, nawnetta anghak pacoengah caeh oh, to tiah kang khetzawn o han ih ni na tamna khaeah nang zoh o, tiah a naa. Nihcae mah, Na thuih ih lok baktiah sah ah, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","To pongah Abraham loe kahni imthung ah Sarah khaeah karangah cawnh; anih khaeah, Noekhaih thumto ah takaw dip to karangah naep ah loe, takaw to sah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Maitawnawk pacahhaih ahmuen ah a cawnh moe, caak khawt boek maitaw maeto naeh pacoengah, a tamna thendoeng maeto khaeah paek; anih mah karangah thongh pae. ");
INSERT INTO cekak_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","To pacoengah maitaw tahnutui kamkhawk, maitaw tahnutui hoi caak kahoih maitaw moi to sinh moe, nihcae hmaa ah patoemh pae; nihcae buhcaak o naah, anih loe nihcae taeng ih thing tahlip ah angdoet. ");
INSERT INTO cekak_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nihcae mah, Na zu Sarah loe naa ah maw oh? tiah a naa. Anih mah, Khenah, Sarah loe kahni imthung ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","To naah anih mah hmabang saning vaihi tue thuem ah kang zoh let han, to naah na zu Sarah loe capa maeto sah tih, tiah a naa. To naah anih hnuk ah kaom kahni im thok taeng hoiah anih mah thuih ih lok to Sarah mah thaih. ");
INSERT INTO cekak_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham hoi Sarah loe mitong hoi boeh moe, saning doeh coeh hoi boeh; Sarah loe caasakhaih atue to laemh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","To pongah Sarah mah, Kai loe mitong boeh moe, ka angraeng doeh mitong boeh, vaihi to baktih anghoehaih ka tawn vop tih maw? tiah pahnuihaih hoiah lok a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","To naah Angraeng mah Abraham khaeah, Tipongah Sarah mah pahnuihaih hoiah, Kai loe mitong boeh, caa ka sah thai vop tih maw? tiah lok a thuih loe? ");
INSERT INTO cekak_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Angraeng hanah karai parai hmuen to oh maw? Hmabang saning vaihi tue phak naah nang khaeah kang zoh let han, to naah Sarah mah capa maeto sah tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","To naah Sarah mah zit pongah amsawnlok a thuih moe, Ka pahnui ai, tiah a thuih. Toe anih mah, Na pahnui to loe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","To ih kaminawk loe amsak o moe, angthawk o naah, Sodom vangpui to dan o tathuk; Abraham mah nihcae to loklam ah caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","To naah Angraeng mah, Ka sak han koi tok to Abraham khaeah kang phat pae tih maw? ");
INSERT INTO cekak_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham loe thacak hoi kalen parai acaeng ah angcoeng tih; long nui ih prae kaminawk boih anih rang hoiah tahamhoihaih hnu o tih. ");
INSERT INTO cekak_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Anih loe a hnuk ah angzo han koi nawktanawk hoi imthung takohnawk to thuitaek tih, tiah ka panoek. Nihcae mah Angraeng ih loklam to pazui o ueloe, toenghaih to sah o tih. To naah Angraeng mah Abraham khae thuih ih lok to akoep tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","To pacoengah Angraeng mah, Sodom hoi Gomorrah kaminawk hanghaih lok loe paroeai len moe, zaehaih doeh pop parai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kai khaeah kapha hanghaih lok baktih toengah, to ih kaminawk mah sak o maw, sah o ai tito khet hanah, ka caeh tathuk han; to naah ni to tiah sah o ai nahaeloe, to tiah sah o ai, tito ka panoek tih, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","To kaminawk loe to ahmuen hoiah angqoi o moe, Sodom vangpui bangah caeh o; toe Abraham loe Angraeng hmaa ah angdoet poe. ");
INSERT INTO cekak_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham mah Angraeng khaeah anghnaih moe, Katoeng kami to kazae kami hoi nawnto nam rosak han maw? ");
INSERT INTO cekak_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Vangpui thungah katoeng kami qui pangato om nahaeloe, katoeng kami qui pangato pathlung ai ah, vangpui to nam rosak han maw? ");
INSERT INTO cekak_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Katoeng kami to kazae kami hoi nawnto hum hmaek han ih loe nang khae hoiah angthla nasoe; katoeng kami to kazae kami baktiah hum han ih doeh nang khae hoiah angthla nasoe; long pum lokcaekkung loe, katoeng hmuen to sah mak ai maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Angraeng mah, Sodom vangpui thungah katoeng kami qui pangato ka hnuk nahaeloe, nihcae rang hoiah vangpum to ka paquem han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","To pacoengah Abraham mah, Kai loe maiphu hoi vai poep ah ni ka oh, toe khenah, vaihi Angraeng khaeah tha hoi lokthui rae ue, ");
INSERT INTO cekak_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","katoeng kami qui pangato akoep hanah pangato angaih nahaeloe, kami pangato angaih pongah vangpui to na phraek han maw? tiah a naa. Anih mah, Vangpui thungah kami qui pali, pangato ka hnuk nahaeloe, kam rosak mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Anih mah, vangpui thungah kami qui palito hnu khoe doeh om tih, tiah a naa. To naah anih mah, kami qui palito om nahaeloe, ka phrae mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","To pacoengah, Angraeng, palungphuisak hmah raeh; lok ka thuih han vop; kami qui thumto hnu khoe doeh om tih, tiah a naa. Anih mah qui thumto ka hnuk nahaeloe, vangpui to kam rosak mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham mah, Khenah, vaihi tha ohhaih hoi Angraeng khae lokthuih hanah kam sak; kami pumphaeto hnu khoe doeh om tih, tiah a naa. Anih mah, kami pumphaeto pongah, vangpui kam rosak mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","To pacoengah anih mah, Angraeng, palungphuisak hmah raeh; vaihi khue lokthui rae ue; kami hato hnuk khoe nahaeloe? tiah a naa let bae. Anih mah, Kami hato om nahaeloe, nihcae rang hoiah vangpui to ka phrae mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Abraham hoi lok apaeh pacoengah Angraeng loe a caehhaih loklam ah amlaem let; Abraham doeh angmah im ah amlaem. ");
INSERT INTO cekak_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Van kami hnik loe duembang ah Sodom vangpui ah angzoh hoi; to naah Lot loe Sodom vangpui khongkha ah anghnut; Lot mah nihnik to hnuk hanah angthawk moe, mikhmai long ah kuep tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Anih mah, Khenah, ka Angraeng hnik, vaihi na tamna im ah angzo hoi ah; khok amsae hoih loe, duem to iip hoi ah; khawnbang khawnthaw ah angthawk hoih loe caeh hoih, tiah a naa. Nihnik mah, To tih na ai, Kaihnik loe qum puek loklam ah ka oh hoi han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Toe anih mah pacae khruek pongah, anih hnuk ah bang hoi moe, anih imthung ah akun hoi; nihnik hanah caak koi, taeh thuh ai ih takaw to patoem pae moe, a caak hoi. ");
INSERT INTO cekak_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Toe nihnik iip hoi ai naah, Sodom vangpui thung ih kaminawk, thendoeng hoi mitongnawk, ahmuen kruek ih kaminawk mah, im to takui o khoep. ");
INSERT INTO cekak_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nihcae mah Lot to kawk o moe, anih khaeah, Vai qum ah na im ah katoem nongpanawk loe naa ah maw oh o? Kaicae khaeah na patoeh ah, ka zae o haih han vop, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot loe nihcae khaeah tasa bang ah caeh moe, a hnuk bang ih thok to khah pacoengah, ");
INSERT INTO cekak_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","nihcae khaeah, Nawkamyanawk, tahmenhaih hoi to baktih kasae hmuen to sah o hmah. ");
INSERT INTO cekak_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Khenah, nongpa hoi iip vai ai canu hnetto ka tawnh; nihnik to nangcae khaeah kang zoh haih han, na koeh o ih baktiah sah oh; toe hae kami hnik loe kawbang doeh sah o hmah; nihnik loe ka imphu tlim ah kabuep angvin ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nihcae mah, Hnuk angnawn ah, tiah naa o. To pacoengah nihcae mah, Nang loe hae ah angvin ah ni nang zoh, toe vaihi loe lokcaekkung ah oh han na koeh; nihnik pong kanung kue ah nangmah to kang sak o lat han, tiah a naa o. Lot to hmaang o moe, thok to phraek hanah a caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Toe van kami hnik loe ban payangh hoi moe, Lot to imthung ah zaeh hoi pacoengah, thok to khah hoi khoep. ");
INSERT INTO cekak_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Nihnik mah kathoeng kalen tih ai, thok taengah kaom, kaminawk to mikmaengsak boih pongah, nihcae loe thok pakrong naah angpho o. ");
INSERT INTO cekak_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","To ih kami hnik mah Lot khaeah, Hae ahmuen ah na imthung takoh kaminawk oh o vop maw? Vangpui thung kaom, na canu ih sava, na capanawk, na canunawk to hae ahmuen hoi tacawt haih boih lai ah. ");
INSERT INTO cekak_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Hae ahmuen hae ka phraek hoi han boeh; hae ih kaminawk hanghaih lok Angraeng ih naa ah koi sut boeh pongah, hae vangpui hae phraek hanah ang patoeh boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","To pongah Lot loe tacawt moe, a canu kazu haih, a canu ih sava khaeah, Angthawk ah loe, hae ahmuen hoiah tacawt hoi lai ah; Angraeng mah hae vangpui hae phrae tih boeh, tiah a naa. Toe a canu ih sava hnik mah loe tamhnuilok thuih rumram ih lok tok mue, tiah a poek hoi. ");
INSERT INTO cekak_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Khodai naah loe, van kami hnik mah Lot khaeah, Karangah angthawk ah loe, hae ah kaom na zu hoi na canu hnik to kawk ah; to tih ai nahaeloe hae vangpui zaehaih mah na pha thuih moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Angtawt hnung parai pongah, Angraeng mah nihcae to tahmen, to naah van kami hnik mah Lot ih ban, a zu hoi a canu hnik ih ban to patawnh pae, vangpui tasa bang khoek to zaeh moe, caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nihcae to vangpui tasa bang khoek to zaeh pacoengah loe anih mah, Na hing o hanah cawn oh, hnukbang angqoi o hmah loe, azawn ah doeh anghak o hmah, mae nuiah cawn oh; to tih ai nahaeloe na dueh o moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Toe Lot mah nihnik khaeah, Aw, ka angraeng, to tih na ai ni; ");
INSERT INTO cekak_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","khenah, vaihi na tamna kai loe mikcuk naakrak ah ka oh pongah, nang tahmenhaih amtuengsak moe, ka hinghaih nang pathlung boeh; toe mae ah loe ka cawn thai ai; sethaih maeto ka tongh ueloe, ka dueh moeng tih. ");
INSERT INTO cekak_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Khenah, vaihi cawnhhaih kanghnai daek ah vangpui tetta maeto oh, to ih vangpui tetta ah na cawnsak ah; (to vangpui loe tetta na ai maw?) to ah ka cawnh nahaeloe ka hinghaih loih tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Anih mah, khenah, nang thuih ih lok to ka tapom, nang hnik ih baktih toengah, to vangpui to ka phrae mak ai. ");
INSERT INTO cekak_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Toe to ah karangah cawn ah, to ahmuen na pha ai karoek to tidoeh ka sah thai mak ai, tiah a naa. To pongah to vangpui to Zoar, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Zoar vangpui thungah Lot akun naah loe, long nuiah ni tacawt boeh. ");
INSERT INTO cekak_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","To naah Angraeng mah van bang hoiah kaat hmai hoi kangqong hmai to Sodom hoi Gomorrah vangpui nuiah khotui baktiah angzohsak. ");
INSERT INTO cekak_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","To vangpuinawk hoi nawnto azawn boih, vangpui thungah kaom kaminawk boih, long ah kamprawk akungnawk to amro boih. ");
INSERT INTO cekak_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Toe Lot zu loe hnukbang ah angqoi pongah, paloi tungah angcoeng ving. ");
INSERT INTO cekak_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham loe khawnbang khawnthaw ah angthawk moe, Angraeng hmaa ah angdoethaih ahmuen ah caeh; ");
INSERT INTO cekak_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom hoi Gomorrah, azawn boih to doeng tathuk; khenah, hmaitikhaih ahmuen ih hmaikhue baktiah prae thung boih ah tacawt hmaikhue to a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Angraeng mah azawn ih vangpuinawk to phraek naah, Sithaw mah Abraham to pahnet ai, Lot ohhaih vangpui to phraek han oh naah doeh, kamro vangpui thung hoiah Lot to a loihsak. ");
INSERT INTO cekak_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot loe Zoar vangpui thungah oh han zit pongah, Zoar vangpui thung hoiah tacawt moe, a canu hnik hoi nawnto mae nuiah khosak; a canu hnik hoi nawnto thlung khaw thungah oh. ");
INSERT INTO cekak_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nito naah loe a canu kacoeh mah, a canu kanawk khaeah, Aihnik ampa loe mitong boeh, long pum ah aihnik iih haih han angzo nongpa maeto doeh om ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Pa ih atii anghmat han ai ah, aihnik ampa to misurtui naesak si loe, anih to iip haih si, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","To na aqum ah ampa to misurtui panaek hoi moe, canu kacoeh mah ampa to iih haih; a canu mah natuek naah maw iih haih moe, natuek naah maw angthawk taak, tito ampa mah panoek ai. ");
INSERT INTO cekak_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Khawnbang ah loe a canu kacoeh mah amnawk khaeah, Khenah, cangduem aqum ah pa to ka iih haih; vaiduem doeh misurtui naesak let si; anih khaeah nang caeh ah loe, pa ih atii anghmat han ai ah, nang doeh anih to iip haih toeng ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","To naduem doeh ampa to misurtui panaek hoi let, canu kanawk loe angthawk moe, ampa to iih haih; natuek naah maw iih haih moe, natuek naah maw angthawk, tito ampa mah panoek ai. ");
INSERT INTO cekak_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","To pongah a canu hnik loe ampa ih caa to pomh hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Canu kacoeh mah capa maeto sak moe Moab, tiah ahmin phui; anih loe vaihni ni khoek to Moab kaminawk ih ampa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Canu kanawk mah doeh capa maeto sak moe Ben-Ammi, tiah ahmin phui; anih loe vaihni ni khoek to Ammon kaminawk ih ampa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham loe ohhaih ahmuen hoi aloih bang ah angpuen moe, Kadesh hoi Shur vangpui salakah khosak. Gerar vangpui ah doeh nawnetta thung oh. ");
INSERT INTO cekak_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","To naah Abraham mah a zu Sarah to, Ka tanuh ni, tiah thuih. To pongah Gerar vangpui siangpahrang Abimelek mah kami to patoeh moe, Sarah to laksak. ");
INSERT INTO cekak_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Toe qum amang ah Abimelek khaeah Sithaw angzoh pae moe, anih khaeah, Khenah, nongpata to na naeh pongah nang loe kadueh kami ah ni na oh boeh, anih loe kami maeto ih zu boeh ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Toe Abimelek loe Sarah khaeah caeh ai vop; anih mah, Angraeng, katoeng acaeng to na hum han maw? ");
INSERT INTO cekak_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Anih mah kai khaeah nongpata loe, Ka tanuh ni, tiah ang naa moe, nongpata mah doeh anih loe, Ka thangqoi ni, tiah thuih; kai loe hae hmuen hae poekciimhaih hoi kaciim ban hoiah ni ka sak, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","To naah Sithaw mah amang ah anih khaeah, Ue, poekciimhaih hoiah ni na sak tito ka panoek; to pongah ni ka koeh ai ih hmuen baktiah na zae haih han ai ah kang pakaa moe, anih to kang suisak ai. ");
INSERT INTO cekak_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","To pongah kami ih zu to paek let ah; anih loe tahmaa ah oh, anih mah nang hanah lawk na thui pae nahaeloe, hinghaih na hnu tih; toe anih ih zu to na paek let ai nahaeloe, nangmah hoi na caanawk boih, na dueh o tangtang tih, tiah panoek ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelek loe khawnbang khawnthaw ah angthawk, a tamnanawk to kawk moe, nihcae khaeah amang ah hnuk ih hmuennawk to thuih pae boih, to naah nihcae loe paroeai zit o. ");
INSERT INTO cekak_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","To pacoengah Abimelek mah Abraham to kawk moe, anih khaeah, Tipongah kaicae nuiah hae baktih hmuen hae na sak loe? Na nuiah tih sethaih maw ka sak moe, ka nui hoi ka prae thungah hae baktih kalen zaehaih to nang phaksak? Tikhoe sak koi ai hmuen to ka nuiah na sak loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek mah Abraham khaeah, Kawbang maw na poek moe, hae tiah na sak? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham mah, Hae prae kaminawk loe Sithaw zithaih tawn o ai moe, ka zu pongah kai na hum o tih, tiah ka poek. ");
INSERT INTO cekak_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","To pacoengah anih loe ka tanuh ah doeh oh roe; kam pa ih canu ah oh, toe amno loe lah; anih to ka zu haih. ");
INSERT INTO cekak_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kam pa imthung hoiah Sithaw mah ang proengsak naah, nongpata khaeah, Nam lunghaih kai khaeah amtuengsak hanah, na caehhaih ahmuen kruekah, kai loe, na thangqoi ni, tiah thui ah, tiah ka naa, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","To pacoengah Abimelek mah, tuu hoi maitawnawk, tamna nongpa hoi nongpatanawk to lak moe, a zu Sarah hoi nawnto Abraham khaeah paek let. ");
INSERT INTO cekak_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek mah Abraham khaeah, Khenah, na hmaa ah kaom long loe kai ih boih ni; na koeh ih ahmuen ah khosah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Anih mah Sarah khaeah, Khenah, Na thangqoi khaeah mikhmai sakhaih phoisa shekel sangto ka paek boeh; to phoisa loe na taengah kaom kaminawk boih hmaa ah kaciim ah na oh moe, zaehaih tidoeh na sah ai, tiah nihcae boih mah panoek han ih ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","To pacoengah Abraham mah Sithaw khaeah lawkthuih pae, to naah Sithaw mah Abimelek, anih ih zu hoi a tamna nongpatanawk to ngantuisak; nihcae loe caa sak o. ");
INSERT INTO cekak_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Abraham ih zu Sarah pongah, Angraeng mah Abimelek imthung takoh boih caa kaaksak. ");
INSERT INTO cekak_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Angraeng mah thuih ih lok baktih toengah, Sarah khaeah caeh moe, a thuih ih lok baktih toengah, Angraeng mah Sarah khaeah sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abraham mitong naah Sarah zokpomh moe, Sithaw mah khaeh ih atue phak naah, Abraham han capa maeto a sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sarah mah sak pae ih capa to Abraham mah, Issak, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sithaw mah anih khaeah thuih pae ih lok baktih toengah, ni tazetto akoep naah, Abraham mah a capa Issak ih tangyat hin to aah pae. ");
INSERT INTO cekak_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham loe a capa Issak tapen naah saning cumvaito oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah mah, Sithaw mah kai ang pahnuisak boeh, hae lok thaih kaminawk boih, kai hoi nawnto pahnui o tih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","To pacoengah, Mi mah maw Abraham khaeah, Sarah mah a caa tahnutui panae tih, tiah thui thai tih? Toe mitong lam ah anih han capa maeto ka sak pae, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nawkta loe qoeng tahang moe, tahnutui amphi boeh; tahnutui toengh na niah Abraham mah kalen parai uumhaih poih to sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Toe Abraham han capa maeto kasah pae, Izip nongpata Hagar mah pahnui thuih, tito Sarah mah panoek. ");
INSERT INTO cekak_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","To pongah anih mah Abraham khaeah, Na tamna nongpata hoi a capa hae haek lai ah; tamna nongpata ih capa loe natuek naah doeh ka capa Issak hoi nawnto qawktoep thai mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham loe a capa ah oh pongah, haek ving to anih han karai parai hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Toe Sithaw mah, Nawkta hoi na tamna nongpata pongah palungsae hmah; Sarah mah thuih ih lok to tahngai ah; nang ih atii loe Issak khae hoi ni tacawt tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na tamna nongpata ih capa doeh, na caa ah oh pongah, anih doeh acaeng maeto ah ka sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Khawnbang khawnthaw ah, Abraham mah takaw hoi moihin tui tabu to lak moe, Hagar to paek; anih ih palaeng ah koeng pae moe, nawkta hoi anih to nawnto haek ving; Hagar loe caeh poe moe, Beersheba praezaek ah amhet khing. ");
INSERT INTO cekak_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Moihin tui tabu pong ih tui to boeng naah loe, kabuk thing tlim ah nawkta to pasongh. ");
INSERT INTO cekak_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","To pacoengah kadueh nawkta to hnuk han ka koeh ai, tiah a thuih pongah caeh moe, nawkta hoi kangthla kue pala kahhaih setto kangthla ahmuen maeto ah anghnut pacoengah, tha hoi a qah. ");
INSERT INTO cekak_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nawkta qahhaih lok to Sithaw mah thaih naah, Sithaw ih van kami mah Hagar to van hoiah kawk, anih khaeah, Hagar, tih raihaih maw na tongh? Zii hmah, Sithaw mah angsonghaih ahmuen hoi kaqah nawkta ih lok to thaih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Angthawk ah, nawkta to pathawk ah loe, na ban ah tapom ah; anih loe kalen parai acaeng ah ka sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Sithaw mah Hagar ih mik to amtuengsak naah, anih mah tuipuek maeto hnuk; a caeh moe, moihin tui tabu koi mongah tui to dok pacoengah, nawkta to tui naeksak. ");
INSERT INTO cekak_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nawkta loe qoeng tahang, anih loe Sithaw mah oh thuih; praezaek ah khosak moe, kalii kaat kop kami ah angcoeng. ");
INSERT INTO cekak_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Paran praezaek ah oh naah, amno mah anih hanah Izip tanuh to zu ah lak pae. ");
INSERT INTO cekak_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Abimelek hoi angmah ih misatuh angraeng Phikol mah Abraham khaeah, Na sak ih hmuen boih ah Sithaw mah ang oh thuih. ");
INSERT INTO cekak_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","To pongah ka caa nuiah, to tih ai boeh loe ka caa ih caa patoeng nuiah, amsoem ai hmuen to ayae moe, angvin ah na ohhaih prae thungah kai mah kang tahmen baktih toengah, ka nuiah doeh tahmenhaih nam tuengsak toeng hanah; vaihi kai hanah Sithaw ih ahmin hoi lokkamhaih to sah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham mah, Lokkamhaih ka sak han hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","To naah Abraham mah Abimelek khaeah, Na tamnanawk mah kai ih tuikhaw ang lomh pae o ving, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Toe Abimelek mah, Kai khaeah nang thui ai pongah, mi mah maw to tiah sak, tito ka panoek ai, vaihni ah ni ka thaih vop, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham mah tuu hoi maitawnawk to lak moe, Abimelek hanah paek; to pacoengah nihnik mah lokmaihaih to sak hoi. ");
INSERT INTO cekak_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham mah tuu khongkha thung ih tuu tala sarihto lak. ");
INSERT INTO cekak_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","To naah Abimelek mah Abraham khaeah, Tipongah tuu tala sarihto na pahoe loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Anih mah, Tuikhaw loe kaimah ni takaeh, tiah hnukung ah oh hanah hae tuu tala sarihto hae, ka ban thung hoi la ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Lokmaihaih a sak hoi pongah, to ahmuen to Beersheba, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Abimelek hoi angmah ih misatuh angraeng Phikol loe, Beersheba ah misa angdaehhaih sak pacoengah, Philistin prae ah amlaem hoi let. ");
INSERT INTO cekak_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham mah Beersheba ah thingkung maeto tling moe, to ahmuen hoiah dungzan Angraeng, Sithaw ih ahmin to palawk. ");
INSERT INTO cekak_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham loe Philistin prae thungah saning kasawk ah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","To tiah hmuen oh pacoengah, Sithaw mah Abraham to tanoek, anih khaeah, Abraham tiah kawk; to naah anih mah, Khenah, hae ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","To pacoengah Sithaw mah, Na palung duek moe, maeto khue na tawnh ih na capa, Issak to hoi ah loe, Moriah prae ah caeh haih ah; kang patuek han ih mae ah kai khaeah nang tathlang hanah hmai angbawnhaih sah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham loe khawnbang khawnthaw ah angthawk moe, laa hrang nuiah hmuenmae to a thuengh; a capa Issak hoi nawnto thendoeng hnetto a kawk moe, hmai angbawnhaih sak hanah, thing aek pacoengah, Sithaw mah thuih ih mae nuiah a caeh. ");
INSERT INTO cekak_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ni thumto naah to ahmuen to, Abraham mah kangthla hoiah khet. ");
INSERT INTO cekak_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham mah thendoeng hnik khaeah, Nang hnik loe haeah laa hrang to toep hoih; kai loe ka caa hoi nawnto ka caeh moe, Sithaw ka bok hoi pacoengah, nang hnik khaeah kang zoh let han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham loe hmai angbawnhaih sak hanah thing to cop moe, a capa Issak to aputsak; hmai hoi haita to a ban ah sinh moe, nawnto a caeh hoi. ");
INSERT INTO cekak_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Issak mah ampa Abraham khaeah, Kam pa, tiah kawk. Abraham mah, Ka capa, haeah ka oh, tiah a naa. Issak mah, Hmai hoi thing loe a sin hoi boeh, toe hmai angbawnhaih sak hanah tuu caa loe naa ah maw oh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham mah, Ka capa, Hmai angbawnhaih sak hanah Sithaw angmah to tuu caa ah angpaek tih hmang, tiah a naa. To pacoengah nawnto caeh hoi poe. ");
INSERT INTO cekak_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sithaw mah thuih ih mae to phak hoi naah, Abraham mah to ahmuen ah hmaicam to sak, a nuiah thing to pahong moe, a capa Issak to qui hoi taoengh pacoengah, hmaicam nui ih thing nuiah pasongh. ");
INSERT INTO cekak_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","To pacoengah Abraham mah ban payangh moe, a capa to hum hanah haita to a lak. ");
INSERT INTO cekak_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","To naah van bang hoiah Angraeng ih van kami mah anih to, Abraham! Abraham! tiah kawk. Anih mah, Haeah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Anih mah, Nawkta nuiah na ban phok hmah; anih nuiah tidoeh sah hmah; maeto khue na tawn ih na capa mataeng doeh paawthaih na tawn ai pongah, Sithaw na zit, tito ka panoek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham mah khet moe, doeng tahang naah, khenah, phroh kapring thungah takii kaman caeng, tuu tae to a hnuk; Abraham loe caeh moe, tuu tae to lak pacoengah, a capa zuengah hmai angbawnhaih to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","To pongah Abraham mah to ahmuen to, Jehovah-jireh, tiah kawk; vaihni ni khoek to, Angraeng ih mae nuiah loe Angraeng mah na paek tih, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Van kami ih Angraeng mah Abraham to van hoiah kawk let bae. ");
INSERT INTO cekak_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Nang loe maeto khue na tawnh ih na capa mataeng doeh paawthaih na tawn ai pongah, kaimah hoi kaimah lokkamhaih ka sak boeh, tiah Angraeng mah thuih; ");
INSERT INTO cekak_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","tahamhoihaih kang paek moe, na caanawk to van ih cakaeh hoi tuipui taeng ih savuet zetto kang pungsak han; na caanawk mah misa ih vangpui khongkha to toep o tih; ");
INSERT INTO cekak_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ka lok na tahngaih pongah, na caanawk rang hoiah long nui ih kaminawk boih tahamhoihaih hnu o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","To pacoengah Abraham loe angmah ih thendoeng hnik khaeah amlaem let; nihcae loe amsak o moe, Beersheba ah caeh o; Abraham loe Beersheba ah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","To tiah hmuennawk oh pacoengah Abraham khaeah, Khenah, nam nawk Nahor ih zu, Milkah loe caa sak mangh; ");
INSERT INTO cekak_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Huz loe calu ah oh, amnawk Buz, Aram ih ampa Kemuel, ");
INSERT INTO cekak_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Khesed, Hazo, Pildash, Jidlaph hoi Bethuel cae to sak, tiah a thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel mah Rebekah to sak; Milkah mah Abraham amnawk Nahor hanah capa nongpa tazetto a sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","A zula Reumah mah doeh Tebah, Gaham, Thahash hoi Maakah to sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah loe saning cumvai, pumphae sarihto hing; ");
INSERT INTO cekak_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah loe Kanaan prae Kirjath Arba (Hebron tiah doeh thuih) ah duek; Abraham loe Sarah pongah palungset moe qah. ");
INSERT INTO cekak_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","To pacoengah Abraham loe kadueh a zu qok khae hoi angthawk moe, Hit caanawk khaeah lok a thuih, nihcae khaeah, ");
INSERT INTO cekak_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Kai loe nangcae salakah angvin ah ni ka oh; kadueh ka zu qok aphum hanah long ahmuen na qan o sak thoem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hit kaminawk mah Abraham khaeah, ");
INSERT INTO cekak_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","ka angraeng, Kaicae ih lok hae tahngai ah; nang loe kaicae salakah thacak angraeng capa ah na oh; na koeh ih ahmuen to qoi ah loe, qok to kaicae ih taprong salakah aphum ah; kadueh qok aphum hanah mi mah doeh taprong to paawt mak ai, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","To pacoengah Abraham loe angthawk moe, to prae thungah kaom Hit kaminawk hma ah akuep pae. ");
INSERT INTO cekak_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Nihcae khaeah, Kadueh ka zu ih qok to ka mikhnuk ah aphum sak han nang koeh o haih nahaeloe, ka lok hae tahngai oh; Zohar capa Ephron mah, ");
INSERT INTO cekak_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","angmah ih lawk taengah kaom, Makpelah thlung khaw to, atho kating ah kai khaeah zawh hanah na hni pae oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","To nathuem ah Ephron loe Hit kaminawk salakah anghnut; Hit kami Ephron loe vangpui khongkha thungah akun, Hit kami rangpui hmaa ah Abraham ih lok to pathim pae; anih mah, ");
INSERT INTO cekak_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","ka angraeng, to tih na ai ni, ka lok hae tahngai ah; lawk to kang paek moe, lawk thungah kaom thlung khaw doeh kang paek; kaimah ih kaminawk hma ah nang han kang paek boeh, kadueh na zu ih qok to aphum lai ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham mah to kaminawk hma ah akuep let moe, ");
INSERT INTO cekak_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","prae kaminawk mikhnuk ah Ephron khaeah, Na koeh nahaeloe, ka lok hae tahngai ah; lawk qanhaih atho to kang paek han; to ah qok ka phum thai hanah, atho hae na talawk paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron mah Abraham khaeah, ");
INSERT INTO cekak_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","ka angraeng, tahngai ah, to long loe phoisa shekel cumvai palito a ting; toe nang hoi kai salakah timaw angaih? Kadueh na zu ih qok to mah aphum laih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ephron ih lok to Abraham mah tapom moe, Hit kaminawk ih mikhnuk ah thuih ih lok baktih toengah, hmuen zaw kaminawk mah patoh ih tahhaih pongah, Ephron hanah phoisa cumvai palito a noek pae. ");
INSERT INTO cekak_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","To pongah Mamre hma ah kaom, Makpelah ahmuen, Ephron lawk thung ih thlung khaw hoi thingkungnawk boih, a taengah kaom thingkungnawk boih to, ");
INSERT INTO cekak_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","vangpui khongkha thung akun Hit kaminawk boih mikhnuk ah Abraham ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","To pacoengah Abraham mah a zu sarah to Kanaan prae Mamre (Hebron) taengah kaom Makpelah lawk thung ih thlung khaw thungah aphum. ");
INSERT INTO cekak_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","To pongah lawk hoi a thungah kaom thlung khaw to, Abraham ih taprong ah oh thai hanah, Hit kaminawk mah raihaih om ai ah paek o. ");
INSERT INTO cekak_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham loe mitong boeh moe, saning doeh coeh boeh; Angraeng mah Abraham to hmuen boih ah tahamhoihaih paek. ");
INSERT INTO cekak_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham loe a imthung ih tamna kacoeh koek hoi a tawnh ih hmuennawk boih khenzawnkung khaeah, Na ban to ka phaih tlim ah tapawh ah; ");
INSERT INTO cekak_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ka capa hanah hae Kanaan nongpata zu ah lak pae han ai ah, van hoi long Sithaw khaeah Angraeng ih ahmin hoiah lokkamhaih kang saksak han; ");
INSERT INTO cekak_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ka prae ah kaimah ih acaengnawk khaeah caeh ah loe, ka capa Issak hanah zu to la paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A tamna mah anih khaeah, Nongpata mah hae prae ah angzoh hanah ka hnukah bang koeh ai nahaeloe kawbang maw ka sak han loe? Nang zohhaih prae ah na capa to hoih moe, ka caeh haih let han maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham mah, To ahmuen ah ka capa caeh haih let hmah. ");
INSERT INTO cekak_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Kam pa imthung hoi kaimah ih acaeng kaminawk ohhaih prae thung hoiah kai zaehoikung, van Angraeng Sithaw mah, Na caanawk khaeah hae prae hae ka paek han, tiah ang thuih moe, lokmaihaih to a sak boeh; ka capa han to ahmuen ih zu to na lak pae thai hanah, na hma ah angmah ih van kami to patoeh tih hmang. ");
INSERT INTO cekak_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nongpata mah na hnukah bang han koeh ai nahaeloe, ka lokkamhaih thung hoiah na loih tih; toe ka capa to to ahmuen ah caeh haih let hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","To pongah a tamna mah angmah ih angraeng Abraham ih phaih tlim ah ban to tapawh moe, hae hmuen kawng pongah anih khaeah lokkamhaih to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","To pacoengah a tamna loe angmah angraeng ih kaengkuu hrang hato lak, angmah angraeng ih kahoih hmuen congcanawk to a sin pacoengah, Mesopotamia prae, Nahor vangpui ah caeh hanah amsak. ");
INSERT INTO cekak_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Nongpatanawk tuidok tue duembang phak naah loe, vangpui tasa bang ih tui ohhaih ahmuen ah kaengkuu hrangnawk to taboksak. ");
INSERT INTO cekak_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","To naah anih mah, Aw ka angraeng Abraham ih Angraeng Sithaw, vaihni ah ka thuih ih lok hae angcoengsak ah loe, ka angraeng Abraham nuiah na tahmenhaih amtuengsak ah. ");
INSERT INTO cekak_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Khenah, hae ih tui khaw taengah kang doet, vangpui thung ih nongpatanawk tuidok han angzoh o naah, ");
INSERT INTO cekak_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tangla maeto khaeah, tui tabu to amtii raeh loe tui naek hanah na paek thoem ah, tiah ka naa han, to naah anih mah, Nae khae, nangmah ih kaengkuu hrangnawk hanah doeh tui kang dok paek han, tiah kathui nongpata to na tamna Issak ih zu ah om nasoe; to naah ni ka angraeng nuiah tahmenhaih nam tuengsak, tito ka panoek thai tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","To tiah lawkthuih pacoeng ai naah, khenah, Abraham ih amnawk Nahor zu Milkah capa, Bethuel ih canu, Rebekah loe tui tabu to sin moe, angzoh. ");
INSERT INTO cekak_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","To nongpata loe kranghoih parai moe, kacuem tangla ah oh; kawbaktih nongpa hoiah doeh iip vai ai vop; anih loe tuikhaw ah caeh tathuk moe, tui to dok pacoengah angzoh tahang let. ");
INSERT INTO cekak_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","To naah tamna loe nongpata khaeah karangah caeh moe, anih khaeah, Na tui tabu pong ih tui to na naesak thoem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Anih mah, Ka angraeng, nae khae, tiah a naa. A ban pong ih tui tabu to karangah amtik moe, naek hanah tui to a paek. ");
INSERT INTO cekak_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Anih han naek tui paek pacoengah, nongpata mah, Nang ih kaengkuu hrangnawk hanah doeh tui kang dok pae han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tui tabu pong ih tui to okduk pongah karangah a lawn moe, tuidok let hanah tui khaw ah a caeh let; kaengkuu hrangnawk to tui a paek boih. ");
INSERT INTO cekak_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","To kami mah nongpata to hnuk naah dawnrai, Angraeng mah anih kholong caehhaih to hmacawnsak maw, cawnsak ai, tito panoek hanah anghngai duem. ");
INSERT INTO cekak_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kaengkuu hrangnawk tuinaeksak boih pacoengah, to kami mah shekel ahap kazit naa tangkraeng, shekel hato kazit sui hoiah sak ih banlakok to lak moe, ");
INSERT INTO cekak_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","nang loe mi ih canu aa? Na thui ah, kaicae toem hanah nam pa ih im to kong tih maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nongpata mah anih khaeah, Kai loe Nahor ih zu Milkah capa, Bethuel ih canu ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","To nongpata mah anih khaeah, Caphaeh hoi caaknaek doeh kakhawt ah oh moe, iih haih ahmuen doeh oh bae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","To naah to kami mah akuep moe, Angraeng to a bok. ");
INSERT INTO cekak_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Anih mah, a tahmenhaih hoi oepthohhaih to caehtaak ai, ka angraeng Abraham ih Angraeng Sithaw loe, tahamhoihaih om nasoe; kholong ka caeh naah ka angraeng ih nawkamyanawk im ah Angraeng mah ang patoeh boeh, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nongpata loe cawnh moe, amno ih imthung takoh khaeah to ih hmuen kawng to a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekah mah Laban, tiah ahmin kaom a thangqoi maeto tawnh; anih loe to kami ohhaih ahmuen tui khaw ah karangah cawnh. ");
INSERT INTO cekak_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Laban mah naa tangkraeng hoi a tanuh ban ih banlakok to hnuk moe, Abraham tamna mah thuih ih lok doeh Rebekah khae hoi a thaih pongah, to kami khaeah a caeh, to naah to kami loe tui khaw taengah kaom kaengkuu hrangnawk ohhaih ahmuen ah angdoet. ");
INSERT INTO cekak_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Anih khaeah, Angraeng mah tahamhoihaih paek ih kami nang, angzo ah, tipongah tasa bangah nang doet sut loe? Nang hanah im ka pathoep moe, kaengkuu hrangnawk ohhaih ahmuen doeh ka sak boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","To kami to im ah caeh haih moe, kaengkuu hrang pong ih hmuennawk to amtiksak; kaengkuu hrangnawk hanah caphaeh hoi caak koi hmuennawk to a paek; angmah hoi angmah ih kaminawk khok amsaeh hanah tui doeh a sin pae. ");
INSERT INTO cekak_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","To pacoengah anih han buh to patoem pae, toe anih mah, Ka thuih han koi lok ka thui ai karoek to buh ka caa mak ai, tiah a naa. Laban mah, To tih nahaeloe thui khae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","To pongah to kami mah, Kai loe Abraham ih tamna ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Sithaw mah ka angraeng to kating ai tahamhoihaih to paek pongah, anih loe angraeng parai; tuuunawk, maitawnawk, phoisa hoi suinawk, a tamna nongpa hoi nongpatanawk, kaengkuu hrang hoi laa hrangnawk doeh tawnh mang. ");
INSERT INTO cekak_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ka angraeng ih zu Sarah mah mitong pacoengah capa maeto sak pae moe, a tawnh ih hmuenmaenawk boih a capa hanah paek. ");
INSERT INTO cekak_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ka angraeng mah, Ka ohhaih prae thung ih, Kanaan tanuhnawk to ka capa han zu ah la pae hmah; ");
INSERT INTO cekak_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","toe kam pa ih imthung takohnawk hoi kaimah ih acaeng kaminawk khaeah caeh ah loe, ka capa han zu to la paeh, tiah lok ang kamsak. ");
INSERT INTO cekak_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","To naah kai mah ka angraeng khaeah, Nongpata mah ka hnukah bang han koeh ai nahaeloe kawbang maw ka sak han loe? tiah ka naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","To naah anih mah kai khaeah, Kai loe, Angraeng hmaa ah kacaeh, to Angraeng mah angmah ih van kami to nang hoi nawnto patoeh ueloe, kholong na caehhaih hmacawnsak tih; kaimah ih acaeng hoi kam pa imthung takoh thung ih kami to ka capa han zu ah na la pae thaih tih hmang; ");
INSERT INTO cekak_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ka caengnawk khaeah na caeh pacoengah loe, kang saksak ih lokkamhaih thung hoiah na loih tih boeh; nihcae mah zu na paek o ai cadoeh, nang loe kang saksak ih lokkamhaih thung hoiah na loih tih boeh, tiah ang naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Vaihniah tui ohhaih ahmuen ah ka phak naah, Aw, ka angraeng Abraham ih Angraeng Sithaw, kholong ka caehhaih hae hma na cawnsak nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","khenah, Kai loe tui ohhaih ahmuen taengah kang doet, tui kadoh tangla cuem angzoh naah anih khaeah, Na tui tabu pong ih tui to na naesak thoem ah, tiah ka naa han; ");
INSERT INTO cekak_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","to naah anih mah, Nae khae, nang ih kaengkuu hrangnawk han doeh tui kang dok pae han, tiah thui kami to ka angraeng capa hanah Angraeng mah qoih ih zu ah om nasoe, tiah lawk ka thuih. ");
INSERT INTO cekak_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ka palung thung hoi lawkthuih boeng ai naah, Angmah ih palaeng ah tui tabu koeng moe, angzo Rebekah to ka hnuk; anih loe tuikung ah caeh tathuk moe, tui to a dok; to naah kai mah anih khaeah, Tui na naesak thoem ah, tiah ka naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","To naah anih mah angmah palaeng nui ih tuidue to karangah amtik moe, Nae khae, nang ih kaengkuu hrangnawk doeh tui ka paek han, tiah ang naa. To pongah tui to ka naek pacoengah, kaengkuu hrangnawk to tui a paek. ");
INSERT INTO cekak_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","To pongah kai mah, Nang loe mi ih canu aa? tiah lok ka dueng. Anih mah, Milkah mah sak ih Nahor capa, Bethuel ih canu ni, tiah ang pathim. To naah kai mah anih hanah naa tangkraeng to ka paek moe, a ban ah banlakok to ka buensak. ");
INSERT INTO cekak_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","To pacoengah ka kuep moe, Angraeng to ka bok; ka angraeng Abraham amnawk ih canu patoeng to, a capa ih zu ah laksak hanah, katoeng loklam ah zaehoikung, ka angraeng Abraham ih Angraeng Sithaw to tahamhoihaih ka paek pacoengah, Angraeng to ka bok. ");
INSERT INTO cekak_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Vaihi ka angraeng nuiah tahmenhaih hoi oepthohhaih nam tueng o sak han maw, nam tueng o sak han ai, tito na thui oh; kai doeh bantang bangah maw, to ai boeh loe banqoi bangah maw, angqoi moe ka caeh han, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban hoi Bethuel mah, Hae hmuen loe Angraeng mah khokhan ih boeh ni; nang khaeah kasae kahoih kang thui hoi thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Khenah, Rebakah loe na hma ah oh; anih to la ah loe, caeh haih ah; Angraeng mah thuih ih lok baktih toengah, anih loe na angraeng capa ih zu ah om nasoe, tiah a thuih pae hoi. ");
INSERT INTO cekak_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Nihnik mah thuih ih lok to Abraham ih tamna mah thaih naah, Long ah akuep moe, Angraeng to a bok. ");
INSERT INTO cekak_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","To pacoengah sui hoi phoisa, amthoephaih khukbuennawk to a lak moe, Rebekah hanah a paek pacoengah, atho kana hmuennawk to a thangqoi hoi amno hanah doeh a paek. ");
INSERT INTO cekak_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","To pacoengah angmah hoi nawnto angzo kaminawk hoi nawnto buhcaak o moe, qum to a iih o; khawnbang khawnthaw ah angthawk o pacoengah, anih mah, Ka angraeng khaeah na caehsak lai ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Toe a thangqoi hoi amno mah, Tangla loe kaicae khaeah ni hato om rae nasoe, to pacoengah na caeh haih tih hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Anih mah nihnik khaeah, Na kang hoi hmah; Angraeng mah kholong ka caehhaih hmacawnsak boeh pongah, ka angraeng khaeah na caehsak raeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","To pacoengah nihnik mah, Tangla to kawk si loe, lokdueng rae si, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","To pongah Rebekah to kawk hoi moe, anih khaeah, Hae kami hoi nawnto na caeh han maw? tiah lok a dueng hoi naah, anih mah, Ka caeh han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","To pongah angmah ih tanuh Rebekah hoi anih khenzawnkung loe, Abraham ih tamna, anih hoi nawnto angzo kaminawk hoi nawnto a caehsak. ");
INSERT INTO cekak_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rebekah to tahamhoihaih paek hoi moe, anih khaeah, Ka tanuh, sing sangto kaminawk ih amno ah om nasoe loe, na caanawk mah misanawk ih khongkha to toep o nasoe, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","To pacoengah Rebekah hoi anih ih nongpatanawk angthawk o moe, kaengkuu hrang nuiah angthueng o pacoengah, to kami hnuk ah bang o; Abraham ih tamna mah Rebakah to lak moe, a caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","To naah Issak loe aloih bang prae ah oh pongah, Beer Lahai Roi hoiah angzoh toeng. ");
INSERT INTO cekak_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Niduem naah loe khopoek hanah lawk ah caeh, a danh naah kangzo kaengkuu hrangnawk to a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah mah doeh danh tahang naah, Issak to a hnuk; to naah kaengkuu hrang nui hoi anghum tathuk moe, ");
INSERT INTO cekak_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","aicae dawt hanah taw ah angzo kami loe mi aa? tiah tamna to lok a dueng naah, tamna mah anih loe ka angraeng ni, tiah a naa. To pongah mikhmai khukhaih to a lak moe, a mikhmai to khuk. ");
INSERT INTO cekak_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","To pacoengah tamna mah kangcoeng hmuennawk to Issak khaeah a thuih pae boih. ");
INSERT INTO cekak_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Issak mah anih to amno Sarah ohhaih imthung ah caeh haih moe, Rebekah to a zu haih; anih loe Issak ih zu ah angcoeng, Issak mah anih to palung pongah, amno duek pacoengah doeh poek monghaih to tawnh. ");
INSERT INTO cekak_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham loe zu maeto lak let, anih ih ahmin loe Keturah. ");
INSERT INTO cekak_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Anih mah Zimran, Jokshan, Medan, Median, Ishbak hoi Shuah to sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan mah Sheba hoi Dedan to sak. Dedan ih caanawk loe Asshur kaminawk, Letush kaminawk hoi Leum kaminawk ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian caanawk loe Ephah, Epher, Hanok, Abidah hoi Eldaah. Hae kaminawk boih loe Keturah mah sak ih caanawk ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham loe a tawnh ih hmuennawk boih Issak hanah paek. ");
INSERT INTO cekak_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Toe a hing naah angmah zula ih caanawk hanah tangqumnawk to a paek moe, nihcae to a capa Issak hma hoi ni angyae bangah patoeh boih. ");
INSERT INTO cekak_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham loe mitong boeh moe, saning cumvai qui sarih, pangato hing. ");
INSERT INTO cekak_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","To tiah mitong moe, hinghaih qui apet pacoengah a duek, to pacoengah angmah ih kaminawk khaeah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A caa Issak hoi Ishmael mah Mamre vangpui pha ai nathuem ih, Hit kami Zohar capa Ephron ih lawk thungah kaom, Makpelah thlung khaw thungah aphum hoi. ");
INSERT INTO cekak_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","To lawk loe Abraham mah Hit kaminawk khaeah qanh; Abraham hoi a zu Sarah loe to ahmuen ah aphum hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham duek pacoengah, Sithaw mah Issak to tahamhoihaih paek; Issak loe Beer Lahai Roi taengah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sarah ih tamna Izip tanuh, Hagar mah Abraham han sak pae ih, Abraham capa Ishmael ih caanawk kawng loe hae tiah oh. ");
INSERT INTO cekak_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ishmael caanawk ih ahmin loe, angmacae acaeng anghumhaih ahmin baktih toengah, calu ah Nebajoth, Keder, Adbeel, Mibsam; ");
INSERT INTO cekak_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO cekak_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Naphish hoi Kedemah; ");
INSERT INTO cekak_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","hae kaminawk loe Ishmael ih caa ah oh o, to tiah ahmin kaom kaminawk loe, angmacae ih vangpui, angmacae misa abuephaih baktih toengah, acaeng hatlai hnetto ukkung ah oh o roep. ");
INSERT INTO cekak_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishamael loe saning cumvai qui thum, sarihto hing; a hinghaih qui apet moe, duek pacoengah, angmah ih kaminawk khaeah angkuem. ");
INSERT INTO cekak_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Anih ih caanawk loe Assyria prae caehhaih loklam, Havilah hoi Izip prae ni angyae bang ih Shur vangpui khoek to khosak o; anih loe angmah ih nawkamyanawk boih hma ah duek. ");
INSERT INTO cekak_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham capa, Issak kawng loe hae tiah oh; Abraham mah Issak to sak; ");
INSERT INTO cekak_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Issak loe Padan Aram ahmuen ah kaom, Syria acaeng Bethuel ih canu, Syria acaeng Laban ih tanuh, Rebekah to zu ah lak naah, saning qui palito oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","A zu loe caa kaak pongah, Issak mah a zu hanah Angraeng khaeah lawkthuih pae; Angraeng mah lawkthuihaih lok to tahngaih pae pongah, a zu Rebekah loe zokpomh. ");
INSERT INTO cekak_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","A zok thung ih nawkta loe maeto hoi maeto ang-et hoi khing; to naah amno mah, Tipongah hae tiah oh vai? tiah poek. To pongah lokdueng hanah Angraeng khaeah a caeh. ");
INSERT INTO cekak_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Angraeng mah anih khaeah, Na zok thungah kami acaeng hnetto oh; na zok thung hoiah tuinuen kalah acaeng hnetto tacawt tih; acaeng maeto loe kalah acaeng maeto pongah thacak kue ueloe, kacoeh mah kanawk ih tok to sah pae tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nawkta zahhaih tue phak naah, anih zok thung ih nawkta loe angphae. ");
INSERT INTO cekak_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Tacawt hmaloe loe ngan to thim dung, a tak loe amui cing ah oh; to pongah anih to Esau, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","To pacoengah amnawk to tapen; a ban hoiah Esau ih khok tahmawh to patawnh; to pongah anih to Jakob, tiah ahmin sak; Rebakah mah nihnik to sak naah, Issak loe saning qui tarukto oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nawkta hnik loe qoeng hoi tahang, Esau loe moi kat kop kami, moi zoep thaih kami ah oh; toe Jakob loe kaom duem kami ah oh moe, kahni imthung ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Issak loe taw ih moi to caak pongah Esau to palung, toe Rebekah mah loe Jakob to palung. ");
INSERT INTO cekak_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Nito naah loe Jakob mah caak koi maeto thongh, to naah Esau loe taw hoiah angzoh moe, zok amthlam parai pongah, ");
INSERT INTO cekak_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau mah Jakob khaeah, Na thongh ih kamling huep caak koi to na paek thoem ah, zok amthlam parai boeh, tiah a naa. To pongah anih ih ahmin to Edom, tiah sak. ");
INSERT INTO cekak_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","To naah Jakob mah, Calu ah na ohhaih to vaihniah kai khaeah na zaw ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","To naah Esau mah, Khenah, ka duek tom boeh; calu ah ohhaih loe timaw atho oh? tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob mah vaihniah kai khaeah lokkamhaih sah ah, tiah a naa. Esau mah anih khaeah lokkamhaih sak pacoengah, calu ah ohhaih to Jakob khaeah a zawh. ");
INSERT INTO cekak_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","To pacoengah Jakob mah takaw hoi peh to Esau hanah paek; anih mah caak moe, naek pacoengah, angthawk moe, a caeh. To tiah Esau mah calu ah ohhaih to khet patoek. ");
INSERT INTO cekak_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abraham dung nathuem ah kaom hmaloe koek khokhahaih oh pacoengah, to prae thungah khokhahaih oh let. To pongah Issak loe Gerar ah kaom Philistin siangpahrang Abimelek khaeah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Issak khaeah Angraeng angphong pae moe, Izip prae ah caeh tathuk hmah; oh han kang thuih ih prae ah om ah; ");
INSERT INTO cekak_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","hae prae thungah om ah, kai mah kang oh thuih moe, tahamhoihaih kang paek han; hae prae boih hae nangmah hoi na caanawk khaeah kang paek moe, nam pa Abraham khaeah ka sak ih lokmaihaih to ka koepsak han. ");
INSERT INTO cekak_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Na caanawk to van ih cakaeh zetto kang pungsak moe, hae prae hae kang paek boih han; na caanawk rang hoiah long nui ih kaminawk boih tahamhoihaih hnu o tih; ");
INSERT INTO cekak_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abraham loe ka lok to tahngaih, ka thuih ih loknawk, patuk ih loklamnawk hoi daannawk to pazui, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","To pongah Issak loe Gerar ah oh; ");
INSERT INTO cekak_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","to ah kaom kaminawk mah a zu kawng to dueng o naah, anih mah ka zu ni, tiah thuih han zit pongah, Ka tanuh ni, tiah a thuih. To tiah thui ai nahaeloe Rebekah loe kranghoih pongah, hae prae ah kaom kaminawk mah na hum o moeng tih, tiah a poek. ");
INSERT INTO cekak_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","To prae thungah atue kasawk ah oh; nito naah loe Philistin siangpahrang Abimelek mah thokbuem hoiah dan tathuk naah, kamhai Issak hoi a zu Rebekah to a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","To pongah Abimelek mah Issak to kawk moe, Khenah, anih loe na zu bae to; tipongah anih loe ka tanuh ni, tiah na thuih loe? tiah a naa. Issak mah anih khaeah, to tiah ka thui ai nahaeloe anih pongah ka dueh moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","To pacoengah Abimelek mah, Tipongah kaicae khaeah to tiah lok na thuih loe? Kami maeto mah na zu hae iip haih moeng nahaeloe, kaicae nuiah zaehaih nam tik sut han bae to, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","To pongah Abimelek mah angmah ih kaminawk boih khaeah, Mi kawbaktih doeh hae kami, anih ih zu sui kami loe hum oh, tiah lok paek. ");
INSERT INTO cekak_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Issak loe to prae thungah lawk to sak; Angraeng mah tahamhoihaih paek moe, saningto thungah cang alet cumvaito hak. ");
INSERT INTO cekak_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Anih loe to nathuem hoiah angraeng amtong moe, angraeng parai, a tawnh ih hmuennawk doeh pung pae aep aep; ");
INSERT INTO cekak_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","tuunawk, maitawnawk hoi tamna paroeai a tawnh pongah, Philistin kaminawk mah anih to ut o. ");
INSERT INTO cekak_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ampa Abraham hing na thung a tamnanawk han takaehsak ih tuikhawnawk to Philistinnawk mah pit pae o ving moe, long hoiah taet pae o boih let. ");
INSERT INTO cekak_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","To naah Abimelek mah Issak khaeah, Nang loe kaicae pong thacak boeh pongah, hae ahmuen hoi kalah bangah caeh lai ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","To pongah Issak mah to ahmuen to caehtaak moe, Gerar azawn ah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ampa hing nathuem ah takaeh ih tuikhawnawk, Abraham duek pacoengah Philistinnawk mah pahnawtsak ih tuikhawnawk to Issak mah a tamnanawk han takaehsak let moe, ampa mah sak ih ahmin to sak let. ");
INSERT INTO cekak_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Issak ih tamnanawk mah azawn ah tui takaeh o moe, kaciim tuipuek to hnuk o. ");
INSERT INTO cekak_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Toe Gerar ah maitaw toep kaminawk hoi Issak ih maitaw toep kaminawk loe maeto hoi maeto, Kai ih tui ni, tiah anglomh o. To tiah anglomh o pongah, to ih tuikhaw to Esek, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","To pacoengah kalah tuikhaw to takaeh let, to tuikhaw doeh anglomh o let bae; to pongah to tuikhaw to Sitnah, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","To ahmuen hoi angpuen o moe, kalah tuikhaw maeto takaeh o let; to naah loe mi mah doeh lomh o ai boeh. Vaihi loe Angraeng mah ahmuen paek boeh moe, prae thungah qoeng o tahang tih boeh, tiah a thuih pongah, to tuikhaw to Rehoboth, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Anih loe to ahmuen hoiah Beersheba ah caeh tahang. ");
INSERT INTO cekak_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","To na ni qum ah anih khaeah Angraeng angphong pae, Kai loe nam pa Abraham ih Sithaw ah ka oh; zii hmah, nang hoi nawnto ka oh, ka tamna Abraham rang hoiah tahamhoihaih kang paek moe, na caanawk kang pungsak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Issak mah to ahmuen ah hmaicam to sak moe, Angraeng hmin to kawk; to ah kahni im a sak moe, a tamnanawk mah tuikhaw to takaeh o. ");
INSERT INTO cekak_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","To naah Abimelek loe angmah ih ampui Ahuzzath hoi misatuh angraeng Phikol to hoih moe, Gerar vangpui hoiah Issak ohhaih ahmuen ah caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Issak mah nihcae khaeah, Kai nang hnukma o moe, nang haek o boeh na ai maw, tikhoe nang zoh o let loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nihcae mah, Angraeng loe nang hoi nawnto oh, tito kahoih ah ka panoek o boeh; to pongah, aicae salakah lokmaihaih to om nasoe, kaicae hoi nang salak lokmaihaih to om nasoe, tiah ka thuih o; kaicae hoi nang salakah angdaehhaih sah si; ");
INSERT INTO cekak_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kaicae mah na nuiah kahoih hmuen khue ai ah loe, sethaih tidoeh ka sah o ai, nang to lunghoih ta ah ni kang patoeh o; to pongah nangmah doeh kaicae sethaih to sah hmah; nang loe Angraeng mah vaihi tahamhoihaih paek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","To pacoengah Issak mah nihcae hanah buh raenghaih to sak pae, nihcae loe caak o moe naek o. ");
INSERT INTO cekak_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Khawnbang khawnthaw ah angthawk o moe, maeto hoi maeto lokmaihaih to sak o; to pacoengah Issak mah nihcae to patoeh; nihcae loe lunghoih ta hoiah caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","To na niah Issak ih tamnanawk to angzoh o moe, tuikhaw takaehhaih kawng to thuih pae o, anih khaeah, Tui to ka hnuk o boeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Anih mah to tui to Shebah, tiah ahmin sak; to pongah to vangpui ih ahmin loe vaihni ni khoek to Beersheba, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau loe saning qui palito oh naah, Hit kami Beeri canu, Judith hoi Hit kami Elon canu, Bashemath to zu ah lak; ");
INSERT INTO cekak_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","nihnik loe Issak hoi Rebekah dawnrai paekkung ah oh hoi. ");
INSERT INTO cekak_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Issak loe mitong moe, miktha om ai boeh pongah, mik doeh amtueng ai boeh, to naah a capa kacoeh Esau to kawk moe, Ka capa, tiah a naa. Anih mah, Khenah, haeah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Issak mah, Khenah, kai loe vaihi mitong boeh moe, natuek naah maw ka duek han, tito ka panoek ai. ");
INSERT INTO cekak_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","To pongah vaihi na sin ih hmuen, kalii hoi palaa to la ah; taw ah caeh ah loe, kai han moi na kat paeh. ");
INSERT INTO cekak_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ka caak koeh ih moi to kakhraem ah thong ah loe, caak han ka hmaa ah na patoem ah; ka dueh ai naah tahamhoihaih kang paek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Issak mah a capa Esau khae thuih ih lok to Rebekah mah thaih. To pongah Esau loe moi kah han taw ah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah mah a capa Jakob khaeah, Khenah, Nam pa mah nam ya Esau khaeah, ");
INSERT INTO cekak_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","taw ih moi to kat ah loe kakhraem ah thongh pacoengah, ka caak hanah na sin ah; ka dueh ai naah Angraeng hmaa ah tahamhoihaih kang paek han, tiah thuih ih lok to ka thaih. ");
INSERT INTO cekak_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","To pongah, Ka capa, vaihi kang thuih ih lok hae tahngai ah loe sah ah. ");
INSERT INTO cekak_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Vaihi tuu khongkha thungah caeh ah loe kahoih maeh caa hnetto la ah; nam pa mah koeh baktih toengah ka thongh pae han; ");
INSERT INTO cekak_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","to pacoengah nam pa caak hanah sin paeh, dueh ai naah tahamhoihaih na paek nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakob mah amno Rebekah khaeah, Khenah, kam ya Esau loe ngnmui tawnh moe, kai loe nganmui ka tawn ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pa mah na pathoep doeh om tih, to naah kai loe minawk aling kami baktiah ka om ueloe, tahamhoihaih hnu ai ah, tangoenghaih ka hnu lat tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Amno mah anih khaeah, Ka capa, nang tangoenghaih loe ka nuiah krah nasoe; ka thuih ih lok hae tahngai ah loe, kahoih maeh caa to la ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","To pongah anih loe caeh moe, amno khaeah maeh caa to sinh pae; amno mah ampa caak koeh baktih toengah moi to thongh pae. ");
INSERT INTO cekak_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","To naah Rebekah mah a capa kacoeh Esau ih khukbuen kahoih to imthung ah lak moe, a capa kanawk Jakob to angkhuksak. ");
INSERT INTO cekak_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","To pacoengah Rebakah mah Jakob ih ban hoi tahnong to maeh caa ahin hoiah khuk pae. ");
INSERT INTO cekak_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","To pacoengah a capa Jakob ban ah, caak khraem ah a thong het ih takaw hoi moi to a paek. ");
INSERT INTO cekak_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Anih loe ampa khaeah caeh moe, Pa, tiah a naa. Anih mah, Haeah ka oh, ka capa, nang loe mi aa? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakob mah ampa khaeah, Kai loe na calu Esau ni, nang thuih ih lok baktih toengah ka sak boeh; tahamhoihaih nang paek hanah, angthawk ah loe anghnut pacoengah, ka kah ih moi hae caa lai ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Issak mah a capa khaeah, Kawbang maw akra ai ah moi na hak thaih takan loe? Ka capa? tiah a naa. Anih mah, Na Angraeng Sithaw mah, ang haksak, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","To naah Issak mah Jakob khaeah, Ka capa, kai khaeah angzo ah, Esau tangtang maw, tangtang ai, tito kang pathoep han vop, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakob loe ampa Issak khaeah caeh, anih mah pathoep pacoengah, Lok loe Jakob ih lok, toe ban loe Esau ih ban ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ban loe amya Esau ih ban baktiah amui oh pongah, anih mah panoek thai ai; to pongah anih han tahamhoihaih to a paek. ");
INSERT INTO cekak_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Anih mah, Nang hae ka capa Esau tangtang maw? tiah a naa. Anih mah, Ue, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","To pacoengah anih mah, Tahamhoihaih kang paek hanah, na kah ih moi to caak han na sin ah, tiah a naa. Jakob mah moi to a taengah patoemh pae moe, a caak. To pacoengah misurtui doeh patoemh pae moe, a naek. ");
INSERT INTO cekak_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","To pacoengah ampa Issak mah anih khaeah, Ka capa, ka taengah angzo ah loe, na mok ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Anih mah caeh moe, a mok. Issak mah khukbuen hmui to thaih naah, anih han tahamhoihaih a paek; khenah, ka capa ih hmui loe, Angraeng mah tahamhoihaih paek ih lawk hmui hoiah anghmong; ");
INSERT INTO cekak_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","to pongah Sithaw mah van ih dantui hoi kathawk long to paek nasoe loe, cang hoi misurtui doeh pungsak nasoe; ");
INSERT INTO cekak_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","prae kaminawk boih mah nang ih tok to sah o nasoe loe, kaminawk na hmaa ah akuep o nasoe; nam nawkamyanawk nuiah angraeng ah om ah loe, nam no ih caanawk doeh na hmaa ah akuep o nasoe; nang tangoeng kaminawk loe tangoenghaih tongh o nasoe loe, nang tahamhoihaih paek kaminawk to tahamhoihaih hnu o nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Issak mah Jakob tahamhoihaih paek pacoengah, ampa hmaa hoiah tacawt; akra ai ah Esau loe moi zoephaih ahmuen hoiah phak. ");
INSERT INTO cekak_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Anih mah doeh moi to caak khraem ah thongh moe, ampa hanah patoem pae; ampa khaeah, Pa, tahamhoihaih nang paek hanah, angthawk ah loe ka kah ih moi hae caa ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ampa Issak mah anih khaeah, Nang loe mi aa? tiah a naa. Anih mah, Kai loe na calu, Esau ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","To naah Issak loe paroeai tasoeh moe, Moi kah moe, ka caak hanah moi sin kami loe naa ah maw oh? Nang, nang zo ai naah moi to ka caak ving boeh moe, anih han tahamhoihaih ka paek moeng boeh; tahamhoihaih loe anih mah ni hnu tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau mah ampa ih lok to thaih naah, tha hoi qah moe, ampa khaeah, Aw, pa, kai doeh tahamhoihaih na paek toeng ah, Pa, kai doeh, tahamhoihaih na paek toeng ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Toe anih mah, Nam nawk mah palunghahaih hoiah ang ling boeh moe, nang ih tahamhoihaih to lak boih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau mah, angmah ih ahmin hoi kamcuk ah Jakob, tiah ahmin to phui roe boeh na ai maw? Vaihi a sak ih hmuen hoiah loe kai vai hnetto ang ling boeh; ka calu ah ohhaih to ang lomh pae moe, vaihi doeh tahamhoihaih ang lak pae ving let bae vop, tiah a thuih. To pacoengah anih khaeah, Kai han tahamhoihaih nang suem pae ai boeh maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Issak mah Esau khaeah, Khenah, Anih loe nang ih angraeng ah ka sak moe, anih ih nawkamyanawk boih doeh anih ih tamna ah ka paek boeh; cang hoi misurtui doeh ka paek boeh; to pongah nang han timaw kang sak pae han loe? Ka capa, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau mah ampa khaeah, Tahamhoihaih maeto doeh na tawn ai boeh maw, pa? Pa, kai doeh tahamhoihaih na paek toeng ah, tiah a naa. To pacoengah Esau loe tha hoi qah. ");
INSERT INTO cekak_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ampa Issak mah anih han hae tiah lok pathim pae; khenah, Na ohhaih ahmuen loe kathawk long ah om ueloe, van bang hoiah dantui to krah tih. ");
INSERT INTO cekak_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nang loe sumsen hoi kho na sah ueloe, nam nawk ih tok to na sah pae tih; toe ukhaih atue phak naah loe anih mah phawsak ih kazit hmuen to na tahnong nui hoiah nang khring tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ampa mah Jakob han tahamhoihaih paek king boeh pongah, Esau mah Jakob to hnukma; pa duekhaih ni loe zoi boeh; to na niah kamnawk Jakob hae ka hum han, tiah a poek. ");
INSERT INTO cekak_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","A capa kacoeh Esau ih lok to amno Rebekah mah thaih; to pongah capa kanawk Jakob to kami kawksak moe, anih khaeah, Khenah, nam ya Esau palungphuihaih dip thai hanah, na hum tih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","To pongah ka capa, vaihi kang thuih ih lok hae tahngai ah; vaihi Haran ah kaom ka thangqoi Laban khaeah cawn ah. ");
INSERT INTO cekak_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nam ya palungphuihaih dip ai karoek to anih khaeah om ah. ");
INSERT INTO cekak_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Nam ya palungphuihaih to dip moe, a nuiah na sak ih hmuen to pahnet pacoengah, nang zoh let hanah lok kang pat moe, nang to kang kawksak han hmang; kawbang maw nito thungah ka capa hnik hanah palung ka sae thuih hmaek thai tih? tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah mah Issak khaeah, Heth ih canunawk pongah poek kang pho boeh; Jakob mah hae prae kami canunawk baktih, Heth ih canunawk hoiah imthong krah nahaeloe, kai han hinghaih atho timaw om tih? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","To pongah Issak mah Jakob to kawk moe, anih to tahamhoihaih paek pacoengah, anih khaeah, Kanaan tanuh to zu ah la hmah. ");
INSERT INTO cekak_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Angthawk ah, nam no ih ampa Bethuel ohhaih Padan Aram ah caeh ah loe, to ah nam no ih thangqoi Laban ih canunawk to nangmah han zu ah la ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Acaeng pop mang ai karoek to, Thacak Sithaw mah tahamhoihaih na paek nasoe loe, athaih taksak pacoengah, kami doeh pungsak nasoe; ");
INSERT INTO cekak_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Sithaw mah Abraham khaeah paek ih prae to na toep hanah, Angraeng mah Abraham khaeah paek ih tahamhoihaih baktiah, vaihi angvin ah na ohhaih hae prae hae, nangmah hoi na caanawk khaeah paek nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","To pacoengah Issak mah Jakob to caehsak; anih loe Syria acaeng Bethuel capa, Jakob hoi Esau amno Rebekah ih thangqoi, Laban ohhaih Padan Aram ah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Issak mah Jakob tahamhoihaih paek moe, zu lak hanah Padan Aram ah patoeh; tahamhoihaih paek naah, anih khaeah, Kanaan tanu to zu ah la hmah, tiah lok a thuih pae, ");
INSERT INTO cekak_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jakob loe amno hoi ampa ih lok to tahngaih moe, Padan Aram ah caeh, tito Esau mah panoek, ");
INSERT INTO cekak_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kanaan tanunawk zu ah ka lak pongah kam pa Issak poeknawm ai, tito Esau mah panoek naah, ");
INSERT INTO cekak_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ishmael khaeah a caeh moe, Nebajoth ih tanuh, Abraham capa Ishmael ih canu Mahalath to zu ah lak let. ");
INSERT INTO cekak_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob loe Beersheba hoiah amsak moe, Haran ah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Niduem boeh pongah, ahmuen maeto phak naah, aqum puek to ahmuen ah anghak; to ih thlungnawk to a lak moe, lu anghnoeng hanah a suek pacoengah, to ahmuen ah a iih. ");
INSERT INTO cekak_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Amang ah tadong van khoek to kapha thlak maeto long ah oh; khenah, to thlak nuiah daw tahang moe, anghum tathuk, Sithaw ih van kaminawk to a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Khenah, Angraeng loe thlak ranui ah anghnut moe, Kai loe nam pa Abraham ih Angraeng Sithaw hoi Issak ih Sithaw ah ka oh; nang songhaih ahmuen to nangmah hoi na caanawk khaeah ka paek han; ");
INSERT INTO cekak_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","na caanawk loe long nui ih maiphu zetto pung o ueloe, niduem, ni angyae, aluek aloih bang khoek to koi o tih; nang hoi na caanawk rang hoiah long kaminawk boih tahamhoihaih hnu o tih. ");
INSERT INTO cekak_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Khenah, nang to kang oh thuih han, na caehhaih ahmuen kruekah kang khetzawn moe, hae prae ah kang hoih let han; kang thuih ih lok koep ai karoek to kang caehtaak mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakob loe iihhaih ahmuen hoiah angthawk pacoengah, hae ahmuen ah Angraeng oh tangtang, tito ka panoek ai, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Anih loe zit moe, Hae ahmuen loe zit kaom ahmuen ni; hae ahmuen loe tih kalah doeh na ai, toe Angraeng ih im ah ni oh; hae loe van khongkha ni, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakob loe khawnbang khawnthaw ah angthawk moe, lu koeng han suek ih thlung to a lak, thlung to a thlingh pacoengah, a nuiah situi to a bawh. ");
INSERT INTO cekak_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tangsuek naah loe to vangpui to Luz, tiah ahmin sak, toe to ahmuen to Bethel, tiah a paek. ");
INSERT INTO cekak_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jakob mah, Kai khaeah Sithaw oh moe, vaihi ka caehhaih loklam ah doeh ang khetzawn pacoengah, caaknaek hoi khukbuen doeh ang paek pongah, ");
INSERT INTO cekak_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kam pa im ah lunghoih ta hoi kam laem thai let nahaeloe, Angraeng loe ka Sithaw ah om ueloe, ");
INSERT INTO cekak_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","haeah ka thling ih thlung loe Angraeng ih im ah om tih; nang paek ih hmuennawk boih thung hoi hato thungah maeto kang paek han, tiah lokkamhaih a sak. ");
INSERT INTO cekak_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","To pacoengah Jakob loe kholong a caeh moe, ni angyae bang kaminawk ohhaih ahmuen to phak. ");
INSERT INTO cekak_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Anih mah khet naah, lawk thungah tuikhaw maeto a hnuk; tuunawk loe to ih tuikhaw taengah ahmuen thumto ah tabok o; to ih tuikhaw thung ih tui to tuunawk han naek o sak; to ah tuikhaw kraenghaih kalen parai thlung kangphaek maeto oh. ");
INSERT INTO cekak_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tuutoep kaminawk to ah oh o naah, tuikhaw kraenghaih kalen parai thlung kangphaek to takhoe o moe, tuunawk to tui naek o sak; to pacoengah tuikhaw to thlung hoiah kraeng o let. ");
INSERT INTO cekak_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakob mah tuutoep kaminawk khaeah, Nawkamyanawk naa hoiah maw nang zoh o? tiah lok a dueng. Nihcae mah, Haran hoiah kang zoh o, tiah pathim pae o. ");
INSERT INTO cekak_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nihcae khaeah, Nahor ih capa Laban to na panoek o maw? tiah a naa. Nihcae mah, Ka panoek o bae, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","To pacoengah Jakob mah nihcae khaeah, Anih loe ngantui hmang maw? tiah a naa. Nihcae mah, Ngan a tui bae; khenah, a canu Rachel loe tuunawk hoi nawnto angzoh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Anih mah, Khenah, niduem ai vop; tuunawk huih han atue pha ai vop; tuunawk to tui nae o sak ah loe, rawkcak pacah o rae khae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nihcae mah, Ka hui o mak ai vop; tuunawk to acuu boih moe, tuikhaw kraenghaih kalen parai thlung kangphaek takhoe pacoeng, tuunawk tui ka paek o ai karoek to ka caeh o thai mak ai, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Nihcae hoi lok apaeh li naah, Rachel loe ampa ih tuunawk to huih moe, angzoh; anih loe tuutoep kami ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jakob mah amno ih tangqoi Laban canu Rachel hoi amno ih thangqoi Laban ih tuunawk to hnuk naah, caeh moe, tuikhaw kraenghaih kalen parai thlung kangphaek to takhoe pae, amno ih thangqoi Laban ih tuunawk to tui a naeksak. ");
INSERT INTO cekak_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jakob mah Rachel to mok moe, tha hoi qah. ");
INSERT INTO cekak_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jakob mah Rachel khaeah anih loe ampa ih nawkamya ah oh moe, Rebekah ih capa ah ohhaih kawng to a thuih pae; to pongah Rachel loe cawnh moe, ampa khaeah thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban mah a tanuh ih capa Jakob kawng to thaih naah, anih tongh hanah karangah cawnh; takop moe, a mok pacoengah, angmah im ah a caeh haih. Jakob mah im ah phak naah, kangcoeng tangcae hmuennawk kawng to a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban mah anih khaeah, Nang loe ka thii ka ngan ah ni na oh, tiah a naa. Anih loe khrah to thung Laban khaeah oh. ");
INSERT INTO cekak_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban mah Jakob khaeah, Kai ih nawkamya ah na oh pongah, kai han tih tok doeh nang sah pae mak ai maw? Na toksakhaih atho to na thui ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban loe canu hnetto tawnh; canu kacoeh ahmin loe Leah, canu kanawk ih ahmin loe Rachel. ");
INSERT INTO cekak_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah loe mik hoih parai ai; toe Rachel loe kranghoih moe, palung han koiah oh. ");
INSERT INTO cekak_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakob loe Rachel to koeh moe, Nang han saning sarihto thung tok kang sak pae han, na canu kanawk Rachel to na paek ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban mah anih to minawk kalah han ka paek pongah loe, nang han kang paek to hoih kue, tiah a naa. Kai khaeah mah om poe ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","To pongah Rachel hak hanah saning sarihto thung tok a sak; toe Rachel to koeh pongah setta thung atue kalaem baktiah a poek. ");
INSERT INTO cekak_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","To pacoengah Jakob mah Laban khaeah, Ka zu na paek lai ah, ka toksakhaih atue doeh khawt boeh, anih hoi nawnto iih han ka koeh boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","To pongah Laban mah to ahmuen ih kaminawk boih to kok moe, buh raenghaih a sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Toe niduem naah loe a canu Leah to zaeh moe, Jakob khaeah a caeh haih; anih to Jakob mah iih haih. ");
INSERT INTO cekak_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban mah a tamna Zilpah to a canu Leah khenzawnkung ah paek. ");
INSERT INTO cekak_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Khenah, khawnbang khawnthaw ah loe, Leah ah oh pae ving; to pongah Jakob mah Laban khaeah, Tipongah hae tiah nang sak loe? Rachel han ah ni tok kang sak pae; tipongah kai nang ling loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban mah, Kaicae prae ah loe, Canu kacoeh sava sah ai naah, kanawk sava sah sai ai. ");
INSERT INTO cekak_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Zu lakhaih ni sarihto boeng rae nasoe; to pacoengah saning sarihto toksah let ah, to naah canu kanawk doeh kang paek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob loe to tiah toksak hanah oh let; Leah hoi ni sarihto thung oh hoi pacoengah, Laban mah a canu Rachel to zu ah paek. ");
INSERT INTO cekak_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban mah a tamna nongpata Billah to, a canu Rachel khenzawnkung tamna ah paek. ");
INSERT INTO cekak_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakob mah Rachel to iih haih; anih mah Leah pongah Rachel to palung kue; to pacoengah Laban hanah saning sarihto thung toksak pae let. ");
INSERT INTO cekak_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jakob mah Leah hnukma, tito Angraeng mah hnuk naah, anih ih caa im to paongh pae, toe Rachel loe caa kaak. ");
INSERT INTO cekak_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah loe zokpomh moe, capa maeto sak; kai patangkhanghaih Angraeng mah hnuk boeh, vaihi loe ka sava mah na palung tih boeh, tiah a poek pongah, a capa to Reuben, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Anih loe zokpomh let moe, capa maeto sak; kai hnukmahaih to Angraeng mah ang panoek pae pongah, hae capa doeh ang paek let, tiah a thuih; to pongah Simeon, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Anih loe zokpomh let moe, capa maeto sak; ka sava hanah capa thumto ka sak pae boeh pongah, anih loe kai khaeah ni akap tih boeh, tiah a thuih. To pongah Levi, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Anih loe zokpomh let moe, capa maeto sak, to naah vaihi loe Angraeng to ka pakoeh han boeh, tiah a thuih; to pongah Judah, tiah ahmin sak. To pacoeng loe anih caa sah ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Jakob han caa maeto doeh sah pae ai, tito Rachel mah panoek naah, Rachel mah amya to ut; to pongah Jakob khaeah, Nawkta to na paek ah, to tih ai nahaeloe ka duek han boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakob loe Rachel nuiah palungphui moe, anih khaeah, Kai loe nang caa kaaksak thaih Sithaw ah maw ka oh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","To naah anih mah, Khenah, ka tamna Billah khaeah caeh ah, anih mah caa na sah pae nasoe, anih rang hoiah imthung takoh kang doet toeng han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","To pongah anih mah a tamna Billah to zu ah paek; anih to Jakob mah iih haih. ");
INSERT INTO cekak_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Anih loe zokpomh moe, Jakob hanah capa mae to sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","To naah Rachel mah, Sithaw mah kai ang bomh, tahmen ka hnikhaih lok ang thaih pae moe, capa maeto ang paek boeh, tiah thuih; to pongah anih mah Dan, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rachel ih tamna Billah loe zokpomh let moe, Jakob hanah capa maeto sak pae let. ");
INSERT INTO cekak_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel mah, Kamya hoi kang pan hoi moe, ka pazawk boeh, tiah thuih. To pongah anih mah Naphtali, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah mah doeh caa ka sah ai boeh, tiah panoek naah, a tamna Zilpah to caeh haih moe, Jakob han zu ah paek. ");
INSERT INTO cekak_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Leah ih tamna Zilpah mah Jakob han capa maeto sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","To naah Leah mah, Misatuh kami abu to angzoh, tiah thuih; to pongah anih mah Gad, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leah ih tamna Zilpah mah Jakob hanah capa maeto sak pae let. ");
INSERT INTO cekak_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","To naah Leah mah, Kang hoe parai, nongpatanawk mah tahamhoih kami, tiah na kawk o tih, tiah thuih pongah, Asher, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Cang aah tue naah, Reuben loe lawk ah caeh, to naah tasi ah patoh ih mandrake thaih to a hnuk moe, amno Leah khaeah sinh pae. Rachel mah Leah khaeah, Na capa mah sin ih tasi thingkung to na paek thoem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Toe anih mah, Ka sava nang lomh to khawt ai vop maw? Ka capa ih mandrake thaih doeh na lak bae han vop maw? tiah a naa. Rachel mah, Na capa ih mandrake thaih nang paek pongah, Jakob loe vaiduem nang khaeah iip nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Duembang ah Jakob loe lawk hoiah amlaem, anih to Leah mah dawt moe, Kai na iip haih ah, ka capa ih mandrake thaih hoiah nang kang tlai boeh, tiah a naa. To pongah to na qum ah anih khaeah a iih. ");
INSERT INTO cekak_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Sithaw mah Leah ih lok to tahngaih pae, anih mah zokpomh let moe, Jakob hanah capa pangato haih sak pae let. ");
INSERT INTO cekak_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","To naah Leah mah, Ka tamna nongpata to ka sava hanah ka paek pongah, Sithaw mah kai han tangqum ang paek, tiah thuih; to pongah anih to Issakar, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","To pacoengah Leah loe zokpomh let, Jakob hanah capa tarukto haih sak pae let. ");
INSERT INTO cekak_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","To naah Leah mah, Sithaw mah atho kana tangqum kai han ang paek boeh, ka sava hanah capa tarukto ka sak pae boeh pongah, vaihi loe kai khaeah ni om tih boeh, tiah thuih; to pongah anih to Zebulun, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","To pacoengah canu maeto sak moe, anih to Dinah, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","To naah Sithaw mah Rachel to poek, Sithaw mah anih ih lok tahngaih pae moe, anih ih caa im to paongh pae. ");
INSERT INTO cekak_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Anih loe zokpomh moe, capa maeto sak; Sithaw mah patoekhaih ang takhoe pae boeh, tiah a thuih; ");
INSERT INTO cekak_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","to pongah anih ih ahmin to Joseph, tiah sak; Angraeng mah kalah capa na paek let nasoe, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rachel mah Joseph tapen pacoengah loe, Jakob mah Laban khaeah, Ka ohhaih ahmuen, ka prae ah, na caehsak lai ah. ");
INSERT INTO cekak_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ka zu hoi ka caanawk han tok kang sak pae baktih toengah, nihcae to na paek ah loe, na caehsak lai ah; nazetto maw nang hanah tok kang sak pae, tito na panoek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Toe Laban mah anih khaeah, Na mikcuk naakrak ah ka oh nahaeloe, om raeh; nang pongah ni Angraeng mah tahamhoihaih ang paek, tito ka panoek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","To pacoengah, Na toksakhaih atho thui ah kang paek han hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakob mah anih khaeah, Kawbang maw tok kang sak pae moe, na pacah ih moinawk doeh ka ban thungah kawbang maw pung o, tito na panoek boeh. ");
INSERT INTO cekak_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kai kang zo ai naah hmuen zetta ni na tawnh, vaihi loe pung parai boeh; kai kang zoh nathuem hoi kamtong Angraeng mah tahamhoihaih ang paek boeh; kaimah ih imthung takoh hanah loe natuek naah maw tok ka sah tih boeh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Anih mah, To tih nahaeloe timaw kang paek han? tiah a naa. Jakob mah, Tidoeh na paek hmah; toe ka koeh baktiah nang sak pae nahaeloe, nang ih tuunawk to kang toep pae poe han. ");
INSERT INTO cekak_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Vaihniah nang tuu pacahhaih ahmuen ah ka caeh moe, aem kaom tuunawk, kamnum hoi kanglung angbaeh tuunawk hoi aem kaom maeh caanawk to ka tapraek han; aem kaom maeh, kamnum hoi kanglung angbaeh tuunawk loe ka toksakhaih atho ah om nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","To tiah ni hmabang ah ka toksakhaih atho na hmaa ah phak naah, ka toenghaih mah kai han lok na thui tih; kai taham moinawk thungah aem kaom ai maeh, kamnum hoi kanglung angbaeh ai tuucaanawk om nahaeloe, to maeh hoi tuu loe kai mah paquk, tiah amnoek thai tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban mah, Khenah, na thuih ih lok baktiah om nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","To na niah anih mah aem kaom maeh, aem kaom maeh amno, kanglung hoi aem kaom maeh, rong kamunm hoi kamling angbaeh tuucaanawk to pahoe boih moe, a caanawk ban ah paek. ");
INSERT INTO cekak_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Angmah ohhaih ahmuen hoi Jakob ohhaih ahmuen loe ni thumto caeh, to ahmuen ah tuunawk to a suek; Jakob loe kanghmat Laban ih tuunawk to toep pae. ");
INSERT INTO cekak_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Toe Jakob loe Poplar thing, almond thing hoi azawn ah kaom kahing thing tanghang to lak moe, a thung ih ngan kanglung to amtuengsak hanah, ahin to a saih. ");
INSERT INTO cekak_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Tuunawk tuinaek han angzoh o naah apa cuuk o pongah, angan kanglung amtueng hanah ahin saih ih thing to tuunawk mah hnuk o thai hanah, tui naekhaih okduk hmaa ah a suek pae. ");
INSERT INTO cekak_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","To naah a suek ih thing hmaa ah tuunawk to apaa cuuk o, to pongah caa tapen naah doeh aem kaom ah tacawt boih. ");
INSERT INTO cekak_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakob mah tuucaanawk hoi maeh caanawk to ahmuen kalah ah tapraek moe, aem kaom tuu hoi maeh, kamnum hoi kamling angbaeh tuu hoi maehnawk to Laban ih tuu pacahhaih ahmuen bangah angqoisak; to tiah Laban ih tuu hoi angmah ih tuunawk to angbaeh han ai ah a suek. ");
INSERT INTO cekak_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Thacak tuunawk apa cuuk han koeh o naah, ahin saih ih thing taengah apa cuuk o pongah, Jakob mah ahin saih ih thing to tui paekhaih okduk hmaa ah suek pae. ");
INSERT INTO cekak_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Toe tuunawk thazok o naah loe, ahin saih ih thing to suem pae ai; to pongah thazok tuunawk loe Laban ih tuu ah oh moe, thacak tuunawk loe Jakob ih tuu ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","To tiah Jakob loe angraeng parai; tuunawk, maehnawk, tamna nongpa hoi nongpatanawk, kaengkuu hrang hoi laa hrangnawk a tawnh mang. ");
INSERT INTO cekak_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laban ih caanawk mah, Pa ih hmuennawk boih Jakob mah lak king pongah, vaihi anih loe hmuenmaenawk hoi angraeng boeh, tiah thuih ih lok to Jakob mah thaih. ");
INSERT INTO cekak_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakob mah Laban to khet naah, canghni ih baktiah mikhmai pan ai boeh, tito panoek. ");
INSERT INTO cekak_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Angraeng mah Jakob khaeah, Nam pa ohhaih prae hoi nangmah ih acaeng kaminawk khaeah amlaem ah; kai mah kang oh thuih han hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","To pongah Jakob mah tuutoephaih ahmuen ah a zu Rachel hoi Leah to hoih hanah kami to patoeh. ");
INSERT INTO cekak_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Nihnik khaeah, Nam pa ih mikhmai ka khet naah, canghni ih baktiah om ai boeh, tiah ka panoek; toe kam pa ih Sithaw mah ang oh thuih poe. ");
INSERT INTO cekak_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ka thacakhaih boih hoiah nam pa ih tok ka sak, tito nang panoek hoi. ");
INSERT INTO cekak_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Toe nam pa mah kai ang ling, ka toksakhaih atho doeh vai hato ang ling; toe kai pacaekthlaek hanah Sithaw mah pakaa pae. ");
INSERT INTO cekak_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Anih mah, aem kaom tuunawk loe na toksakhaih atho ah om nasoe, tiah a thuih, to naah tuunawk loe aem oh o boih; rong kangdaek tuunawk loe ka toksakhaih atho ah om nasoe, tiah a thuih, to naah doeh tuunawk loe rong kangdaek ah tapen boih. ");
INSERT INTO cekak_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","To pongah Sithaw mah nam pa ih tuunawk to lak moe, kai han ang paek boeh. ");
INSERT INTO cekak_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Tuunawk apa cuukhaih tue phak moe, ka khet naah, tuu taenawk loe aem kaom tuu amnonawk khaeah ni apa cuuk o, tiah amang ah ka hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sithaw ih van kami mah amang ah kai khaeah, Jakob, tiah ang kawk. Kai mah, Haeah ka oh, tiah ka naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","To naah anih mah, Danh tahang ah, Tuu taenawk loe aem kaom, rong kangdaek tuu amnonawk khae khue ah ni apa cuuk o; Laban mah na nuiah sak ih hmuennawk to ka hnuk boih. ");
INSERT INTO cekak_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kai loe thlung na thling moe, situi na bawh pacoengah, kai khaeah lokkamhaih na sak ih, Bethel hmuen ih Sithaw ah ka oh; vaihi angthawk ah, hae prae hae caehtaak ah loe, na caeng kaminawk ohhaih prae ah amlaem ah, tiah ang thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","To naah Rachel hoi Leah mah anih khaeah, Kam pa im ah kaihnik mah toep han koi qawk hoi taham timaw ka tawn hoi? ");
INSERT INTO cekak_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kaihnik hae prae kalah kami ah a poek, kaihnik hae zawh khue ai ah, kaihnik han paek tangcae hmuen mataeng doeh ang patoh pae king na ai maw? ");
INSERT INTO cekak_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Pa khae hoi Sithaw mah lak ih hmuennawk boih loe, aicae hoi aimacae caanawk ih hmuen ah ni oh boeh; to pongah vaihi Sithaw mah ang thuih ih baktih toengah sah ah, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","To pacoengah Jakob loe angthawk moe, a caanawk hoi a zu hnik to kaengkuu hrang nuiah angthuengsak. ");
INSERT INTO cekak_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Padan Aram ah oh naah, a hak ih hmuennawk boih, pacah ih moinawk to a hoih boih moe, ampa Issak ohhaih Kanaan prae ah caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban loe angmah ih tuu amui aah hanah caeh, to naah Rachel mah sakcop ih ampa imthung ih sithaw krangnawk to paquk pae ving. ");
INSERT INTO cekak_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakob mah ka cawnh ving han boeh, tiah thui pae ai, Syria kami Laban to tamquta hoiah a caehtaak. ");
INSERT INTO cekak_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","To pongah anih loe a tawnh ih hmuennawk boih hoiah a cawnh; angthawk moe, vapui angkat o pacoengah, Gilead mae bangah a caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jakob cawnh ving boeh, tito Laban mah ni thumto naah thaih. ");
INSERT INTO cekak_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Angmah ih nawkamyanawk to kawk moe, ni sarihto thung anih to patom o, anih to Gilead maeah kae o. ");
INSERT INTO cekak_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Syria kami Laban ih amang ah Sithaw to amtueng pae; Jakob khaeah kasae doeh kahoih doeh, lokthuih han ai ah acoe ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban mah nihcae to kae naah, Jakob loe Gilead mae ah kahni im a sak boeh; Laban hoi angmah ih nawkamyanawk doeh Gilead mae ah im to sak o. ");
INSERT INTO cekak_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban mah Jakob khaeah, Tipongah hae tiah na oh loe? Kai hae nang ling moe, ka canu hnik doeh misa mah sumsen hoi pahuem moe, naeh ih kami baktiah, na caeh haih ving loe? ");
INSERT INTO cekak_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Tipongah kai nang ling moe, tamquta hoi na cawnh ving loe? Nang thuih soe nahaeloe, anghoehaih laa to sak moe, cingceng bohhaih, katoeng kruekhaih hoiah kang prawt han bae, tikhoe nang thui ai loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tipongah ka caanawk hoi ka canunawk doeh nang moksak ai loe? Amthuhaih hoiah ni hae hmuen hae na sak. ");
INSERT INTO cekak_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nang han nganbawh kana kang paek thaih; toe cangduem aqum ah nam pa ih Sithaw mah kai khaeah, Kahoih doeh kasae doeh, Jakob khae lokthuih han ai ah acoe ah, tiah ang thuih pongah ni. ");
INSERT INTO cekak_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Vaihi loe nam pa im to na poek boeh pongah, na caeh han angaih boeh; tikhoe kai ih sithawnawk to na paquk loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakob mah Laban khaeah, Na canu hnik hae tha hoi nang lomh ving tih, tiah ka poek moe, ka zit pong ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Toe nang ih sithaw paqu kami na hnuk nahaeloe, anih to hing hmah nasoe; nang ih hmuen ka lak o moeng nahaeloe, aicae nawkamyanawk hmaa roe ah la ah, tiah a naa. Toe Rachel mah sakcop ih sithawnawk paquk pae ving, tito Jakob mah panoek ai. ");
INSERT INTO cekak_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","To pongah Laban loe Jakob ih kahni im, Leah ih kahni im hoi anih ih tamna nongpata hnik ih kahni imthung ah akunh, toe tidoeh hnu ai; Leah ih kahni imthung hoi tacawt pacoengah, Rachel ih kahni imthung ah akun let. ");
INSERT INTO cekak_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel mah ampa imthung ih sithawnawk to lak moe, kaengkuu khrang khukhaih kahni thungah pacaeng, to pacoengah a nuiah anghnut thuih khoep. Laban loe kahni imthung ih hmuennawk to pakrong boih, toe tidoeh hnu ai. ");
INSERT INTO cekak_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel mah ampa khaeah, Ka angraeng, na hmaa ah kangdoe thai ai pongah palungphuisak hmah; athii ka hnuk pongah ni, tiah a naa. Anih loe sakcop ih krangnawk to pakrong, toe hnu ai. ");
INSERT INTO cekak_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","To naah Jakob loe palungphui moe, Laban to zoeh; tih sakpazaehaih maw ka tawnh? Tih zaehaih maw ka sak moe, nang patom? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kai ih hmuennawk to na pakrong boih boeh; na imthung ih hmuen timaw na hnuk? Nam nawk amyanawk hoi kai ih kaminawk hmaa ah suem ah, mi maw katoeng, tito nihcae mah aihnik salakah lokcaek nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nang khaeah saning pumphaeto ka oh; nang ih tuunawk hoi maehnawk a caa zun o vai ai; nang ih tuu tae maeto mataeng doeh ka caa vai ai. ");
INSERT INTO cekak_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nang ih tuunawk to moisannawk mah kaek vai ai; kanghmaa tuu to kai mah ka rong; khoving ah maw, khodai ah maw, tuunawk anghmat naah kai khaeah atho nang suk. ");
INSERT INTO cekak_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","To tiah kho ka sak; khodai ah ni kabae mah ang dawk moe, khoving ah kangqai mah ang koep; iih boep ai ah to tiah kho ka sak. ");
INSERT INTO cekak_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","To tiah na im ah saning pumphaeto thung ka oh; na canu hnik hanah saning hatlai palito thung tok kang sak pae moe, saning tarukto thung na pacah ih moinawk to kang toep pae, ka toksakhaih atho vai hato nang ling. ");
INSERT INTO cekak_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kai khaeah kam pa ih Sithaw, Abraham ih Sithaw, Issak mah zit ih Sithaw om ai nahaeloe, bangkrai ah ni nang patoeh tangtang tih; toe Sithaw mah patangkhanghaih hoi ka ban mah sak ih tok to ang hnuk pae pongah ni, cangduem qum ah nang to ang thuitaek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban mah Jakob khaeah, Hae nongpata hnik loe ka canu ni; hae nawktanawk doeh ka caa ni, hae ih moinawk doeh kai ih ni; na hnuk ih hmuennawk boih doeh kai ih ni; toe vaihniah ka canu hnik hoi nihnik mah sak hoi ih caanawk doeh kawbang maw ka naa thai tih boeh? ");
INSERT INTO cekak_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","To pongah vaihi angzo ah loe, nang hoi kai salakah lokmaihaih to sah si; to lokmaihaih loe nang hoi kai salakah hnukung ah om nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","To pongah Jakob mah thlung to lak moe, tung ah a thling. ");
INSERT INTO cekak_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jakob mah angmah ih nawkamyanawk khaeah, Thlung to a laksak; nihcae mah thlung to sinh pae o moe, pakhueng o pacoengah, pakhueng ih thlung nuiah buh a caak o. ");
INSERT INTO cekak_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","To a hmuen to Laban mah Jegar Sahadutha, tiah ahmin paek; toe Jakob mah loe Galeed, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban mah, Vaihniah haeah pakhueng ih thlung loe nang hoi kai hnukung ah oh boeh, tiah a naa. To pongah to ahmuen to Galeed, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Aihnik loe maeto hoi maeto kangthla ah oh hoi naah doeh, Sithaw mah toep poe nasoe, tiah a thuih pongah, Mizpah, tiah doeh kawk o. ");
INSERT INTO cekak_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Nang mah ka canu hnik hae pacaekthlaek maw, to ai boeh loe ka canu hnik nuiah zu kalah na lak tak ving cadoeh, mi mah doeh aicae hae hnu ai; toe Sithaw loe aihnik salakah hnukung ah oh, tito pahnet hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","To pacoengah Laban mah Jakob khaeah, Khenah, kai hoi nang salakah sak ih, haeah pakhueng ih thlung hoi tung ah thling ih thlung hae oh. ");
INSERT INTO cekak_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Haeah tapop ih thlung loe hnukung ah oh moe, haeah thling ih thlung doeh hnukung ah oh; nang nganbawh kana paek hanah, haeah tapop ih thlung hae ka poeng mak ai; nangmah doeh kai nganbawh kana paek hanah, haeah tapop ih thlung hae poeng hmah. ");
INSERT INTO cekak_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham Sithaw, Nahor Sithaw, nihnik ampa ih Sithaw mah aihnik salakah lok takroek nasoe, tiah a naa. To pongah Jakob loe ampa Issak mah zit ih Sithaw ih ahmin hoiah lokmaihaih to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jakob loe to ih mae nuiah angbawnhaih to sak moe, buhcaak hanah angmah ih nawkamyanawk to kawk; nihcae loe buhcaak o moe, mae nuiah aqum puek oh o. ");
INSERT INTO cekak_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban loe khawnbang khawnthaw ah angthawk moe, a caanawk hoi a canu hnik to mok pacoengah, nihcae to tahamhoihaih a paek. To pacoengah a ohhaih ahmuen ah amlaem. ");
INSERT INTO cekak_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakob loe caehhaih loklam ah caeh poe, to naah Sithaw ih van kaminawk mah anih to tongh o. ");
INSERT INTO cekak_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jakob mah nihcae to hnuk naah, Hae loe Sithaw ih misatuh kaminawk ni, tiah thuih; to pongah to ahmuen to Mahanaim, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakob mah Edom prae, Seir hmuen ah, amya Esau khaeah laicaehnawk to hmaloe ah patoeh. ");
INSERT INTO cekak_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Anih mah nihcae khaeah, Ka angraeng Esau khaeah, Na tamna Jakob mah, Kai loe Laban khaeah ka caeh moe, vaihi doeh to ah ka oh vop; ");
INSERT INTO cekak_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","maitawnawk, laa hrangnawk, tuunawk, tamna nongpa hoi nongpatanawk doeh ka tawnh; na mikcuk naakrak ah ka oh hanah, vaihi ka angraeng khaeah lokthuih hanah ang patoeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Laicaehnawk loe Jakob khaeah amlaem o let, anih khaeah, Nam ya Esau khaeah ka caeh o, vaihi nang hnuk hanah kami cumvai palito angzoh haih, tiah a thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakob loe paroeai zit moe, tasoeh pongah, angmah khae kaom kaminawk, tuunawk, maitawnawk hoi kaengkuu hrangnawk to, abu hnetto ah tapraek. ");
INSERT INTO cekak_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Esau mah abu maeto tuh nahaeloe, kalah abu maeto loih nasoe, tiah a poek pongah to tiah a sak. ");
INSERT INTO cekak_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","To naah Jakob mah, Aw, kam pa Abraham ih Sithaw, kam pa Issak ih Sithaw, Na prae hoi nangmah acaeng kaminawk khaeah amlaem ah, nang hae kang lensak han, tiah kai khaeah lokthuikung, Angraeng, ");
INSERT INTO cekak_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","na tamna khaeah nam tuengsak ih na tahmenhaih hoi oepthohhaih tetta mataeng doeh hnuk han kam cuk ai; hae Jordan vapui kang kaat naah, cunghet khue ni ka tawnh; toe vaihi loe abu hnetto ah ka oh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kam ya ih ban, kam ya Esau ih ban thung hoi nang pahlong hanah, lawk kang thuih; anih loe kaimah hoi ka zu, ka caanawk hum hanah angzo tih, tiah zithaih ka tawnh. ");
INSERT INTO cekak_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Toe nangmah ni kai khaeah, Nang hae kang lensak moe, kroek laek ai ah kaom, tuipui taeng ih savuet zetto, na caanawk kang pungsak han, tiah nang thuih, tiah lawk a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Anih loe aqum puek to ahmuen ah iih; a tawnh ih hmuennawk thung hoiah amya Esau to tangqum paek hanah, ");
INSERT INTO cekak_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","maeh amno cumvai hnetto, maeh tae pumphaeto, tuu tala cumvai hnetto, tuu tae pumphaeto, ");
INSERT INTO cekak_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kaengkuu hrang amno qui thumto hoi a caanawk, maitaw tala qui palito hoi maitaw tae hato, laa hrang tala pumphaeto hoi a caa hato a qoih. ");
INSERT INTO cekak_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","To moinawk to a tamnanawk ban ah paek moe, abu tapraek pacoengah, Ka hmaa ah caeh oh, abu maeto hoi maeto salak kangthla ah caeh oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Nihcae thungah hmaloe koeh caeh kami khaeah, Kam ya Esau mah nang to hnuk naah, nang loe mi aa? Naa ah maw na caeh han? Na hmaa ih moinawk loe mi ih aa? tiah na dueng nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","to moinawk loe na tamna Jakob ih ni; ka angraeng Esau paek han ih tangqum ni, khenah, anih loe hnukah angzoh, tiah thuih paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","To tiah anih hnukah angzo abu hnetto hoi abu thumto kaminawk khaeah doeh, Esau na hnuk o nahaeloe, to tiah thui oh, tiah lok a paek. ");
INSERT INTO cekak_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","To pacoengah na tamna loe kaicae hnukah angzoh, tiah thui oh, tiah a naa. Hmaloe koek caeh kami mah paek ih tangqumnawk hoiah mikhmai ka sak han; to tiah nahaeloe anih hoi kang qum naah na talawk pae khoe doeh om tih, tiah a poek. ");
INSERT INTO cekak_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","To pongah Jakob ih tangqumnawk to hmaloe ah caeh o haih; toe to na aqum ah, anih loe kaminawk ataihaih ahmuen ah ni a oh. ");
INSERT INTO cekak_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","To na aqum ah Jakob loe angthawk moe, a zu hnik, a tamna nongpata hnik hoi a caa hatlaito caeh haih moe, Jabbok vapui ih tui amdaehaih ahmuen ah angkaat haih. ");
INSERT INTO cekak_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Nihcae vapui zaeh ah thak pacoengah, a tawnh ih hmuennawk doeh a thaksak boih. ");
INSERT INTO cekak_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","To pongah Jakob loe angmabueng oh sut; to naah anih loe kami maeto hoiah khodai ai karoek to angpanh. ");
INSERT INTO cekak_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","To kami mah anih to pazawk mak ai, tiah panoek naah, Jakob ih phaih to boh pae tuek; to tiah angpan hoi li naah Jakob ih phaih huh amkhraeng pae ving. ");
INSERT INTO cekak_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","To kami mah, Na prawt lai ah, khodai tom boeh, tiah a naa. Toe Jakob mah, Tahamhoihaih nang paek ai nahaeloe, kang prawt mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","To kami mah, Na hmin loe mi aa? tiah a naa. Anih mah, Jakob, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","To naah to kami mah, Nang loe Sithaw hoi anih ih kaminawk hoiah nang panh moe, na pazawk boeh pongah, na hmin to Jakob, tiah kawk mak ai boeh; Israel, tiah ni kawk tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakob mah, Na hmin loe mi aa? Tahmenhaih hoiah na thui ah, tiah a naa. Toe anih mah, Tih hanah ka hmin nang dueng loe? tiah a naa. To pacoengah anih mah to ahmuen ah Jakob hanah tahamhoihaih paek. ");
INSERT INTO cekak_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakob mah mikhmai kangtong ah Sithaw to ka hnuk boeh, toe anih mah ka hinghaih ang pathlung, tiah a poek pongah, to ahmuen to Jakob mah Peniel, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Penuel to poeng pacoeng loe khodai boeh; to naah Jakob loe khok kangbai baktiah lam caeh. ");
INSERT INTO cekak_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Anih mah Jakob ih phaih thaqui to atumh pae tuek pongah, vaihni ni khoek to Israel caanawk mah phaih thaqui taeng ih angan to caa o ai. ");
INSERT INTO cekak_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakob mah khet tahang naah, kami cumvai palito hoi nanwto angzo Esau to hnuk. To pongah nawktanawk to tapraek moe, Leah, Rachel hoi a tamna nongpata hnik khaeah a paek. ");
INSERT INTO cekak_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A tamna nongpata hnik hoi a caanawk to hmaloe ah a caehsak, to pacoengah Leah hoi a caanawk to caehsak moe, hnukkhuem koekah Rachel hoi Joseph to caehsak. ");
INSERT INTO cekak_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Angmah to hmahmanh moe, amya khaeah a phak naah, a hmaa ah long ah vai sarihto akuep pae. ");
INSERT INTO cekak_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau loe Jakob hnuk hanah cawnh moe takop; tahnong ah takoih moe, anih to mok; to pacoengah loe qah hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau mah khet naah, nongpatanawk hoi a caanawk to hnuk; nang hoi nawnto kaom kaminawk loe mi aa? tiah a naa. Jakob mah, Nihcae loe Sithaw mah na tamna khaeah tahmenhaih hoi paek ih kaminawk ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","To pacoengah a tamna hnik hoi a caanawk to angzoh o moe, anih hmaa ah akuep o. ");
INSERT INTO cekak_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","To pacoengah Leah hoi a caanawk doeh anih khaeah angzoh o moe, akuep o; hnukkhuem koekah Rachel hoi Joseph to angzoh hoi moe, a hmaa ah akuep hoi toeng. ");
INSERT INTO cekak_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esua mah, Ka hnuk ih moinawk loe tih sak han ih aa? tiah a naa. Anih mah, Ka angraeng, na tahmenhaih ka hnuk thai hanah, nang hanah kang sinh pae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Toe Esau mah, Kam nawk, Kai doeh ka tawnh mang bae, nangmah hanah mah suem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob mah, Tahmenhaih hoiah na talawk paeh; na tahmenhaih ka tongh nahaeloe, ka sinh ih tangqum hae na talawk pae ah; na mikhmai ka hnuk hae, Sithaw mikhmai hnuk baktiah ni oh, na mikhmai panhaih to ka hnuk boeh. ");
INSERT INTO cekak_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nang han kang sinh ih taham ka hoihaih tangqumnawk hae na talawk pae ah, Sithaw mah ang tahmen pongah, ka ngaihaih boih ka tawnh boeh, tiah a naa. Jakob mah paek pae khruek pongah, Esau mah talawk pae. ");
INSERT INTO cekak_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","To naah Esau mah, Caeh o si, kholong caeh amsak o si boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Toe Jakob mah, Ka angraeng, nawktanawk loe saning nawk o vop moe, tapen kangtha tuu hoi maitawnawk doeh ka khetzawn han oh, tito na panoek; nito thung karangah ka caeh haih nahaeloe, moinawk hae dueh o boih tih. ");
INSERT INTO cekak_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","To pongah ka angraeng nang loe, na tamna hmaa ah caeh halat ah; kai loe moinawk to amzai ah huih moe, nawktanawk hoi nawnto ka angraeng ohhaih Seir mae ah amzaita hoi kang zoh han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau mah, To tih nahaeloe kaimah ih kaminawk ahap kang caehtaak han, tiah a naa. Toe Jakob mah, Na koehhaih baktiah ka oh nahaeloe, tih han ih nihcae to caehtaak han angai tih loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","To pongah to na niah Esau loe Seir prae ah amlaem let. ");
INSERT INTO cekak_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Toe Jakob loe Sukkoth ah caeh, ohhaih ahmuen maeto a sak, angmah ih maitawnawk ohhaih im doeh a sak pae; to pongah to ahmuen to Sukkoth, tiah ahmin paek. ");
INSERT INTO cekak_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jakob loe Padan prae hoiah angzoh moe, Kanaan prae Shekem vangpui to kamong ah a phak, to vangpui phak tom naah ataihaih ahmuen to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Shekem ampa Hamor caanawk khae ih long to, phoisa cumvaito hoiah a qanh moe, to ahmuen ah ataihaih kahni im to a sak. ");
INSERT INTO cekak_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","To ahmuen ah hmaicam maeto a sak pacoengah, El-Elohe-Israel, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leah mah Jakob han sak pae ih canu Dinah loe to prae thung ih nongpatanawk khaeah paqaih hanah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","To prae ukkung, Hiv acaeng Hanor capa, Shekem mah anih to hnuk naah, anih to naeh moe, iih haih pacoengah amhnongsak. ");
INSERT INTO cekak_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Anih loe poekhaih palungthin boih Jakob canu Dinah hanah paek, nongpata to a palung khruek pongah, lok kanaem ta hoiah anih to paroi. ");
INSERT INTO cekak_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekem mah ampa Hamor khaeah, Hae nongpata hae ka zu ah na la pae ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","A canu Dinah to Shekem mah iih haih boeh, tito Jakob mah thaih, a caanawk loe lawk ah maitaw toep o; Jakob loe nihcae angzo ai karoek to lok apae ai ah anghngai duem. ");
INSERT INTO cekak_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","To naah Shekem ampa Hamor loe lokthuih hanah, Jakob khaeah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jakob ih caanawk mah to tamthang to thaih o naah, im ah amlaem o roep; Shekem loe Israel kaminawk salakah kahoih ai hmuen hoi sak koi ai hmuen ah kaom, Jakob ih canu Dinah to iih haih moeng boeh pongah, nihcae loe palungnat khue khawt ai ah, palung a phui o parai. ");
INSERT INTO cekak_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Toe Hamor mah nihcae khaeah, Ka capa Shekem mah na canu hae palung khruek boeh; anih han zu ah na paek halat ah. ");
INSERT INTO cekak_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kaicae hoi zu sava ah om si, na canunawk to na paek oh loe, nangcae doeh kaicae tanuh hae la o toeng ah. ");
INSERT INTO cekak_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kaicae khaeah khosah oh, hae prae hae nangcae han kang paongh pae; a thungah khosah oh loe, hmuenmaenawk doeh zaw oh; a thung ih hmuennawk to toep oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","To pacoengah Shekem mah Dinah ih ampa hoi nawkamyanawk khaeah, Hae hmuen pongah na tahmen o raeh, nang hnik o ih hmuen boih kang paek han. ");
INSERT INTO cekak_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Avang hoi tangqum loe nazetto doeh pop nasoe, nang hnik o zetto kang paek han hmang, nongpata hae mah ka zu ah na paek oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Anih mah nihcae ih tanuh Dinah to zae haih boeh pongah, Jakob ih caanawk mah Shekem hoi ampa Hamor to aling o; ");
INSERT INTO cekak_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","nihcae mah nihnik khaeah, Tangzat hin aat ai kaminawk khaeah, to baktih hmuen to ka sah o thai mak ai; to baktih hmuen loe kaicae han azat kathok hmuen ah ni oh; ");
INSERT INTO cekak_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","toe kaicae baktih toengah, nangcae thung ih nongpa boih tangzat hin na aah o nahaeloe, na thuih ih lok to kang tapom pae o han; ");
INSERT INTO cekak_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","to pacoengah ni kaicae ih canunawk to kang paek o moe, nangcae ih canunawk doeh ka la o toeng tih; nangcae hoi nawnto ka om o ueloe, acaeng maeto ah om tih. ");
INSERT INTO cekak_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Toe kang thuih o ih baktih toengah, tangzat hin aah han na koeh o ai nahaeloe, ka canu to ka lak o moe, ka caeh o han boeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","To tiah a thuih o ih lok to Hamor hoi a capa Shekem mah palung due hoi. ");
INSERT INTO cekak_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","To thendoeng loe ampa imthung ah khingya o koek ih thendoeng ah oh moe, Jakob ih canu to koeh khruek pongah, nihcae mah thuih ih lok to aek ai. ");
INSERT INTO cekak_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","To naah Hamor hoi a capa Shekem loe to vangpui khongkha taengah caeh hoi moe, angmacae vangpui thung ih kaminawk khaeah lok a thuih pae hoi, ");
INSERT INTO cekak_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","nihnik mah, Hae kaminawk loe angdaeh koeh kami ah oh o; aicae prae ah omsak si loe, hmuenmaenawk doeh zawsak si; khenah, nihcae han kakhawt kalen parai ahmuen doeh oh; nihcae ih canunawk to la o si loe, aicae ih canunawk doeh nihcae han paek si. ");
INSERT INTO cekak_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Toe nihcae loe tangzat aat kami ah oh o pongah, aicae doeh nihcae baktiah tangzat hin aah o naah ni, nihcae loe nangcae hoi nawnto om o thai tih. ");
INSERT INTO cekak_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nihcae ih maitawnawk, nihcae ih hmuennawk hoi moinawk loe aicae ih hmuen ah om mak ai, tiah na poek o maw? To pongah aicae mah nihcae ih lok to paroi o halat si, to tiah ni nihcae loe aicae hoi nawnto om o tih, tiah a thuih pae hoi. ");
INSERT INTO cekak_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Anih ih vangpui khongkha ah kacaeh kaminawk boih mah Hamor hoi a capa Shekem ih lok to paroi o; to pongah anih ih vangpui thungah kaom nongpanawk loe tangzat hin to aah o boih. ");
INSERT INTO cekak_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Aahhaih ahmaa nat li haih, ni thumto naah Jakob ih caa, Dinah ih thangqoi Simeon hoi Levi loe angmah hnik ih sumsen to lak hoi moe, misahoihaih hoiah vangpui to muk hoi pacoengah nongpanawk to hum hoi boih. ");
INSERT INTO cekak_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor hoi a capa Shekem to sumsen hoi a hum hoi moe, Shekem imthung ih Dinah to a lak hoi pacoengah, tacawt hoi. ");
INSERT INTO cekak_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Nihcae mah a tanuh to zae o haih pongah, Jakob ih caanawk loe kadueh kaminawk khaeah caeh o moe, vangpui to phraek o. ");
INSERT INTO cekak_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tuunawk, maitawnawk, la hrangnawk, vangpui thung kaom hmuennawk hoi lawk ah kaom hmuennawk to a lak o, ");
INSERT INTO cekak_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","nihcae ih hmuennawk, nihcae ih nawktanawk hoi zunawk to naeh o boih moe, im ah kaom hmuennawk to paro pae o boih. ");
INSERT INTO cekak_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jakob mah Simeon hoi Levi khaeah, Raihaih nang paek hoi boeh, Kanaan kaminawk hoi Periz kaminawk, hae prae ah kaom kaminawk khaeah panuet thok ah nang sak hoi boeh; aicae loe kami zetta, nihcae loe kai tuk hanah amkhueng o tih, kai na hum o ueloe, kaimah hoi ka imthung takoh doeh hum o boih tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Toe nihnik mah, Anih mah ka tanuh tangzat zaw kami baktiah sak han oh maw? tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","To pacoengah Sithaw mah Jakob khaeah, Angthawk ah, Bethel ah caeh tahang ah loe, to ah om ah; nam ya Esau khae hoi na cawnh naah, nang khae kamtueng Sithaw khaeah, hmaicam maeto sah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","To pongah Jakob mah a imthung takoh hoi anih khae kaom kaminawk boih khaeah, Nangcae salak ih prae kalah sithawnawk to va o boih ah, ciimcai oh loe, khukbuen to angkraih oh. ");
INSERT INTO cekak_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Angthawk oh, Bethel ah caeh o tahang si; raihaih ka tongh na niah ka lok pathimkung hoi ka caehhaih loklam ah kaom thuih Sithaw khaeah, to ih ahmuen ah hmaicam to ka sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","To pongah nihcae ban ah kaom kalah sithawnawk boih, nihcae naa pong ih naa tangkraengnawk to Jakob khaeah paek o boih; to hmuennawk to Jakob mah Shekem ih oak thing tlim ah a phum pae. ");
INSERT INTO cekak_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","To pacoengah a caeh o; nihcae taeng ih vangpuinawk thungah kaom kaminawk nuiah Sithaw zithaih to phak pongah, mi mah doeh nihcae to patom thai ai. ");
INSERT INTO cekak_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakob hoi angmah ih kaminawk loe Kanaan prae thung ih Luz (Bethel thuihhaih ih ni) vangpui ah phak o boih. ");
INSERT INTO cekak_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","To ahmuen ah hmaicam maeto a sak, amya khae hoi cawnh naah to ahmuen ah Sithaw mah angphong thuih pongah, to ahmuen to El Bethel, tiah kawk. ");
INSERT INTO cekak_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","To naah Rebekah khenzawnkung, Deborah loe duek moe, Bethel ih oak thingkung tlim ah a phum o; to pongah to ahmuen to Allon Bakuth, tiah kawk. ");
INSERT INTO cekak_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Padan Aram hoi Jakob angzoh naah, anih khaeah Sithaw angphong pae let moe, anih to tahamhoihaih paek. ");
INSERT INTO cekak_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Sithaw mah anih khaeah, Na hmin loe Jakob; toe na hmin to Jakob, tiah kawk mak ai boeh, Israel, tiah ahmin om tih boeh, tiah a naa. To pongah anih ih ahmin to Israel, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Sithaw mah anih khaeah, Kai loe Thacak Sithaw ah ka oh; thingthai athai oh loe, pung oh; nang khae hoiah prae maeto hoi acaeng maeto ah om ueloe, nang khae hoiah ni siangpahrangnawk to tacawt o tih; ");
INSERT INTO cekak_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Abraham hoi Issak khaeah ka paek ih prae to kang paek moe, na caanawk khaeah doeh ka paek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","To pacoengah anih hoi lokthuihaih ahmuen hoiah Sithaw mah anih to caehtaak. ");
INSERT INTO cekak_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakob mah Sithaw hoi lokpaehhaih ahmuen ah thlung maeto thling moe, a nuiah naek koi hmuen to a bawh pacoengah, situi doeh a bawh. ");
INSERT INTO cekak_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakob mah Sithaw hoi lokpaehhaih ahmuen to, Bethel, tiah kawk. ");
INSERT INTO cekak_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","To pacoengah Bethel hoiah ahmuen kalah bangah angpuen o; Ephrath ahmuen hoi kangthla kue ahmuen ah oh o naah, Rachel caa tapenhaih tue to phak, caa tapen han rai parai. ");
INSERT INTO cekak_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Caa om thai ai naah, nawkta omsakkung mah, anih khaeah, Zii hmah; capa maeto na sah let tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","A hinghaih qui apet tom moe, (duek han oh sut naah) a capa to Ben-Oni, tiah ahmin sak; toe ampa mah loe anih to Benjamin, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel loe duek moe, anih to Ephrath (Bethlehem) caehhaih loklam ah aphum o. ");
INSERT INTO cekak_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Anih aphumhaih taprong nuiah Jakob mah thlung maeto thling; to thlung loe vaihni ni khoek to Rachel ih taprong nuiah thling ih thlung ah oh poe. ");
INSERT INTO cekak_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel loe to ahmuen hoiah caeh moe, Eder imsang to poeng pacoengah kahni im to sak. ");
INSERT INTO cekak_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israel loe to prae ah oh naah, Reuben mah ampa ih zula Billah to iih haih, tiah Israel mah thaih. Jakob loe capa hatlai hnetto tawnh. ");
INSERT INTO cekak_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leah ih caanawk loe, Jakob ih calu Reuben, Simeon, Levi, Judah, Issakar hoi Zebulun. ");
INSERT INTO cekak_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rachel ih caanawk loe, Joseph hoi Benjamin; ");
INSERT INTO cekak_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rachel ih tamna Billah ih caanawk loe, Dan hoi Nephtali; ");
INSERT INTO cekak_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leah ih tamna Zilpah ih caanawk loe, Gad hoi Asher. Hae kaminawk loe Padan Aram ah oh o naah sak ih Jakob ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakob loe Hebron, tiah kawk ih Arba vangpui, Abraham hoi Issak ohhaih Mamre ahmuen ah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Issak loe saning cumvai, qui tazetto hing. ");
INSERT INTO cekak_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Issak loe saning coeh moe, mitong naah duek; anih loe anghahhaih takhi to boeng pacoengah angmah ih kaminawk khaeah nawnto oh; a capa Esau hoi Jakob mah anih to aphum hoi. ");
INSERT INTO cekak_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Edom tiah kawk ih Esau ih caanawk kawng loe hae tiah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau loe Kanaan tanuhnawk to zu ah lak moe, Hit acaeng Elon canu Adah, Hiv acaeng Zibeon ih canu patoeng, Anah ih canu Aholibamah doeh zu ah lak; ");
INSERT INTO cekak_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ishmael canu, Nebajoth ih tanuh, Bashemath doeh zu ah a lak bae vop. ");
INSERT INTO cekak_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah mah Esau hanah Eliphaz to sak pae moe, Bashemath mah Reuel to sak pae; ");
INSERT INTO cekak_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aholibamah mah Jeush, Jaalam hoi Korah to sak; hae kaminawk loe Kanaan prae ah sak ih, Esau ih capa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau loe a zunawk, a capanawk hoi a canunawk, a imthung ah kaom kaminawk boih, angmah ih maitawnawk boih, moinawk boih hoi Kanaan prae ah hnuk ih hmuennawk to sinh boih moe, amnawk Jakob hoi angthla kuehaih ahmuen ah angpuen. ");
INSERT INTO cekak_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","A tawnh ih hmuennawk loe pop hmoek boeh pongah, ahmuen maeto ah nawnto oh hmaek han angcoeng ai boeh; nihnik ohhaih ahmuen loe a tawnh hoi ih moinawk pacah han khawt ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","To pongah Edom tiah kawk ih Esau loe Seir mae ah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Seir mae ah kaom Edom kaminawk ih ampa ah kaom, Esau ih caanawk loe hae tiah oh; ");
INSERT INTO cekak_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau caanawk ih ahmin loe, Eliphaz, anih loe Esau ih zu Adah capa ah oh moe, Reuel loe Esau ih zu Bashemath ih capa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eliphaz ih caanawk loe, Teman, Omar, Zepho, Gatam hoi Kenaz. ");
INSERT INTO cekak_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esau capa Eliphaz mah Timna to zula ah lak let, anih mah Amalek to sak pae; hae kaminawk loe Esau ih zu Adah mah sak ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel ih caanawk loe Nahath, Zerah, Shammah hoi Mizzah; hae kaminawk loe Esau zu Bashemath ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Zibeon ih canu Anah, Anah ih canu hoi Esau ih zu, Aholibamah mah Esau han sak pae ih caanawk loe Jeush, Jaalam hoi Korah. ");
INSERT INTO cekak_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esau ih caanawk thungah angraeng acaeng ah kaom kaminawk loe, Esau ih calu Eliphaz ih caanawk thung hoiah Teman, Omar, Zepho hoi Kenaz, ");
INSERT INTO cekak_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam hoi Amalek; hae kaminawk loe Edom prae thungah Eliphaz mah sak ih caa ah oh o moe, Adah ih caa patoeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau capa Reuel ih caanawk loe Nahath, Zerah, Shammah hoi Mizzah; hae kaminawk loe Edom prae thungah Reuel mah sak ih caa ah oh o moe, Esau ih zu Bashemath ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau zu Aholibamah ih capanawk loe Jeush, Jaalam hoi Korah; hae kaminawk loe Anah canu, Esau zu Aholibamah ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hae kaminawk loe Edom, tiah kawk ih Esau ih caa ah oh o moe, angmacae zaehoikung lu koek ah ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hae kaminawk loe Hor acaeng Seir ih caa ah oh o; to prae thung ah kaom kaminawk loe Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO cekak_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer hoi Dishan; hae kaminawk loe Edom prae thungah kaom, Hor caphung thungah, angraeng acaeng ah kaom Seir ih capa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan capanawk loe, Hori hoi Hemam; Timna loe Lotan ih tanuh ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal capanawk loe Alvan, Manahath, Ebal, Shepho hoi Onam. ");
INSERT INTO cekak_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon ih caanawk loe Ajah hoi Anah; hae Anah loe praezaek ah ampa Zibeon ih laa hrangnawk to toep pae naah, kabae tuipuek hnukung ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah ih caanawk loe Dishon hoi Aholibamah. ");
INSERT INTO cekak_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon ih caanawk loe Hemdan, Eshban, Ithran hoi Keran. ");
INSERT INTO cekak_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer ih caanawk loe Bilhan, Zaavan hoi Akan. ");
INSERT INTO cekak_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan ih caanawk loe Uz hoi Aran. ");
INSERT INTO cekak_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hor acaeng thung ih zaehoikung lu koek loe Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO cekak_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer hoi Dishan; hae kaminawk loe ukkung angraeng, Hor ih acaeng ah oh o moe, Seir prae thungah ukkung angraeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hae kaminawk loe Israel ukkung siangpahrang om ai naah, Edom prae thungah siangpahrang ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor capa Bela loe Edom siangpahrang ah oh; anih ih vangpui ahmin loe Dinhabah. ");
INSERT INTO cekak_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela duek pacoengah, anih zuengah Bozrah ah kaom, Zerah capa Jobab to siangpahrang ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab duek pacoengah, anih zuengah Temani prae ih Husham to siangpahrang ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham duek pacoengah, anih zuengah Moab prae thungah Midian kaminawk pazawkkung, Bedad capa Hadad to siangpahrang ah oh; anih ih vangpui ahmin loe Avith. ");
INSERT INTO cekak_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad duek pacoengah, anih zuengah Masrekah ih Samlah to siangpahrang ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah duek pacoengah, anih zuengah vapui taengah kaom, Rehoboth ih Shaul to siangpahrang ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaul duek pacoengah, anih zuengah Akhor capa Baalhanan to siangpahrang ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akhor capa Baalhanan duek pacoengah, anih zuengah Hadar to siangpahrang ah oh; anih ih vangpui ahmin loe Pau; anih ih zu hmin loe Mehezahab canu Matred, Matred ih canu Mehetabel. ");
INSERT INTO cekak_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esau hoi anghum tathuk angraeng acaengnawk loe, angmacae imthung takoh, angmacae ohhaih ahmuen baktiah paek ih ahminawk loe Timnah, Alvah, Jetheth, ");
INSERT INTO cekak_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibamah, Elah, Pinon, ");
INSERT INTO cekak_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO cekak_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel hoi Iram cae hae ni; hae kaminawk loe angmacae ohhaih ahmuen baktih toengah Edom ukkung angraeng acaeng ah oh o; Esau loe Edom kaminawk ih ampa ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob loe ampa angvin ah ohhaih, Kanaan prae ah khosak. ");
INSERT INTO cekak_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jakob anghumhaih kawng loe hae tiah oh; Joseph loe amyanawk hoi nawnto tuu toep naah, saning hatlai sarihto oh boeh; thendoeng loe Jakob ih zu, Billah hoi Zilpah ih caanawk hoi nawnto ah oh, nihcae sethaih kawng to anih mah ampa khaeah thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel loe mitong lam ah capa Joseph to sak pongah, anih to kalah amyanawk pongah palung kue; to pongah anih hanah rong congca kaom laihaw to a sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ampa loe kalah nawkamyanawk pongah Joseph to palung kue, tiah amyanawk mah panoek o naah, anih to hnukma o moe, lunghoih ta hoiah lok tapring o vai ai. ");
INSERT INTO cekak_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph mah amang to sak, anih mah to amang to amyanawk khaeah thuih pae, to naah nihcae mah anih to hnukma o aep. ");
INSERT INTO cekak_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Amyanawk khaeah, Ka mang hae tahngai oh; ");
INSERT INTO cekak_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","khenah, Aicae loe lawk ah cangqui taoengh o, to naah kai ih cangqui loe angthawk moe, angdoet tahang; toe nangcae ih cangqui loe kangkui ah angdoet o moe, kai ih cangqui to bok o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Amyanawk mah anih khaeah, Kaicae ukkung ah oh han na poek maw? To tiah kaicae nang uk thai tang tih maw? tiah a naa o. A hnuk ih amang hoi a thuih ih lok pongah, nihcae mah anih to hnukma o aep. ");
INSERT INTO cekak_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","To pacoengah anih mah amang to sak let, to amang to amyanawk khaeah a thuih pae let; Tahngai oh, kalah amang ka sak let bae vop; khenah, ka mangah, ni, khrah hoi cakaeh hatlaito mah kai to bok o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ampa hoi amyanawk khaeah a thuih pae naah, ampa mah anih khaeah, Tikhoe to baktih amang to na sak khruek loe? tiah a thuitaek. Na hmaa ah ka kuep o hanah, kai, nam no hoi nam nawk amyanawk, nang khaeah kang zoh o tih maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Amyanawk mah anih to ut o; toe ampa mah loe a thuih ih lok to palung thungah pakuem poe. ");
INSERT INTO cekak_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Amyanawk loe Shekem vangpui ah ampa ih tuu rawkcak pacah hanah caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","To naah Israel mah Joseph khaeah, Nam yanawk loe Shekem vangpui ah tuu rawkcak pacah o; angzo ah, nihcae khaeah kang patoeh han, tiah a naa. Anih mah, Haeah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","To pongah anih khaeah, Caeh ah loe, nam yanawk hoi tuunawk ngantui o vai, khen noek ah, to pacoengah tamthang na thui let ah, tiah a naa. Hebron azawn hoiah Joseph to patoeh pongah, Shekem ah a caeh. ");
INSERT INTO cekak_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Anih taw ah amhet khing naah, lawk caeh kami maeto mah anih to hnuk, Timaw na pakrong loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Anih mah, Kam yanawk to ka pakrong, naa ah maw tuu a toep o, na thui ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","To kami mah, Nihcae loe hae ahmuen hoiah kalah ahmuen bangah caeh o ving boeh; Dothan ah caeh o si, tiah thuih o ih lok to ka thaih, tiah a naa. To pongah Joseph loe amyanawk khaeah caeh, nihcae to Dothan ah a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Anih to kangthla hoiah a hnuk o, nihcae khae pha ai naah, anih hum hanah pacaeng o. ");
INSERT INTO cekak_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nihcae mah, Amang sah kami to angzoh boeh, tiah maeto hoi maeto lok ang thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Angzo oh, anih to hum o si, tangqom khaw maeto thungah va si loe, anih loe moisan mah kaek boeh, tiah thui si. To naah anih ih amang kawbang maw oh, tito khen o si, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reuben mah to lok to thaih naah, anih to hum o hmah si, tiah a naa moe, Joseph to nihcae ban thung hoiah a lak ving. ");
INSERT INTO cekak_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reuben mah nihcae khaeah athii palong o hmah; toe anih to hae praezaek ih tuikhaw thungah mah va o sut ah, a nuiah ban phok o hmah, tiah a naa. Reuben mah, nihcae ban thung hoiah ka pahlong moe, kam pa khaeah ka caeh haih let han, tiah a poek. ");
INSERT INTO cekak_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Joseph amyanawk khae phak naah, anih mah angkhuk ih rong congca kaom laihaw to a khringh pae o; ");
INSERT INTO cekak_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","anih to naeh o moe, tuikhaw thungah vah o; tuikhaw loe tui kaang boeh moe, tui om ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Nihcae loe buhcaak han anghnut o; a danh o tahang moe, a khet o naah, Gilead prae hoiah angzo, kaengkuu hrang pongah hmuihoih hmuen, hmuihoih thing tangpri hoi myrrhnawk kaphaw, Izip prae ah kacaeh Ishmael kaminawk to a hnuk o. ");
INSERT INTO cekak_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah mah amyanawk khaeah, Aimacae ih amnawk to a hum o moe, anih ih athii hawk o khing cadoeh aicae han timaw atho oh? ");
INSERT INTO cekak_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Angzo oh, anih to Ishmael kaminawk khaeah mah zaw si, anih nuiah ban phok o hmah si; anih loe aimacae ih amnawk hoi acaeng ah ni oh, tiah a naa. Anih ih lok to amyanawk mah paroi pae o. ");
INSERT INTO cekak_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","To naah hmuenzaw Midian kaminawk to angzoh o; amnawk Joseph to tuikhaw thung hoiah a zuh o let moe, anih to Ishmael kaminawk khaeah phoisa shekel pumphaeto hoiah a zawh o; nihcae mah Joseph to Izip prae ah caeh o haih. ");
INSERT INTO cekak_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reuben loe amlaem let moe, tuikhaw to khet naah Joseph loe om ai boeh; to pongah angmah ih laihaw to asih. ");
INSERT INTO cekak_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Amnawknawk khaeah amlaem moe, nawkta loe om ai boeh; kai loe naa ah maw ka caeh han boeh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","To naah Joseph ih laihaw to lak o moe, maeh caa maeto a boh o pacoengah, maeh thii thungah laihaw to a nup o; ");
INSERT INTO cekak_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","rong congca kaom laihaw to ampa khaeah a sin pae o moe, hae ni ka hnuk o boeh; na caa ih laihaw maw, laihaw ai tito kahoih ah khenah, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Anih mah maat moe, Hae loe ka caa ih laihaw boeh ni! Anih loe moisan mah ni kaek boeh; Joseph loe moisan mah taprawt pet pet boeh hae loe, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","To naah Jokob loe angmah ih khukbuen to angkhring moe, kazii to kaengah angzaeng pacoengah, a capa to ni paroeai thung qah haih. ");
INSERT INTO cekak_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A capanawk hoi a canunawk boih anih pathloep hanah angzoh o; toe pathloep o thai ai; palungset loiah ka capa caehhaih taprong thungah ka caeh han boeh, tiah a thuih. To tiah a capa pongah ampa to qah. ");
INSERT INTO cekak_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midian kaminawk mah Joseph to, Izip prae ih misatuh angraeng, Faro ih toksahkung angraeng maeto ah kaom, Potiphar khaeah zawh o. ");
INSERT INTO cekak_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","To naah Judah loe angmah ih nawkamyanawk to caehtaak moe, Adullam acaeng Hirah khaeah caeh tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Judah mah to ah Kanaan acaeng Shuah canu to hnuk, anih to zu ah lak moe, a iih haih. ");
INSERT INTO cekak_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nongpata loe zokpomh moe, capa maeto sak; anih to Er, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nongpata loe zokpomh let moe, capa maeto sak, anih to Onan, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Anih loe zokpomh let bae moe, capa maeto sak, anih to Shelah, tiah ahmin sak; to capa loe Kezib vangpui ah oh naah tapen. ");
INSERT INTO cekak_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah mah a calu, Er hanah zu lak pae; anih ih ahmin loe Tamar. ");
INSERT INTO cekak_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Toe Judah ih calu Er loe, Angraeng mikhnuk ah kahoih ai kami ah oh; to pongah anih to Angraeng mah dueksak ving. ");
INSERT INTO cekak_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","To naah Judah mah Onan khaeah, nam ya ih zu khaeah caeh ah, anih to zu haih ah loe nam ya han caa sah paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Anih hoi sak ih caa loe angmah ih caa ah om mak ai, tito Onan mah panoek naah, am ya han caa sak pae han koeh ai pongah, amya ih zu khaeah iih naah, angmah ih atii to tasa bangah pathok ving. ");
INSERT INTO cekak_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","To tiah sak ih hmuen to Angraeng mah koeh ai; to pongah anih doeh dueksak. ");
INSERT INTO cekak_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","To pongah Judah mah angmah ih langah Tamar khaeah, Ka capa Shelah thendoeng ai karoek to nam pa im ah hmai ah, tiah a naa. Anih doeh amya hnik baktiah dueh moeng tih, tiah a poek. To pongah Tamar loe amlaem moe, ampa im ah a hmaih. ");
INSERT INTO cekak_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nasetto maw oh pacoengah Shuah canu, Judah ih zu to duek; Judah palungsae dip pacoengah loe angmah ih tuu mui aat kaminawk khaeah, Adullam acaeng angmah ih ampui Hirah hoi nawnto Timnah vangpui ah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","To naah nam qang loe tuu mui aah hanah Timnah vangpui ah caeh, tiah Tamar khaeah thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","To naah lamhmai khukbuen to angkhring moe, a mikhmai to khuk khoep, a lu to zaeng pacoengah Timnah vangpui caehhaih loklam ah kaom, Enaim akunhaih khongkha taengah anghnut; Shelah loe thendoeng boeh, toe anih to zusak han koeh ai, tito a langah mah panoek. ");
INSERT INTO cekak_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judah mah anih to hnuk naah, mikhmai to khuk khoep pongah, tangzat zaw nongpata mue, tiah a poek. ");
INSERT INTO cekak_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","(To nongpata loe angmah ih langah ni, tito panoek ai) pongah, anih khaeah loklam taengah caeh moe, Nang khaeah na iipsak ah, tiah a naa. Nongpata mah kai nang iih haih nahaeloe, timaw nang paek han? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Anih mah, Maeh caa to kang pat han, tiah a naa. Nongpata mah to tiah nahaeloe to hmuen nang pat ai nathung ah hmuen maeto ka ban ah nang koeng thai tih maw? tiah a naa let. ");
INSERT INTO cekak_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Nongpa mah tih hmuen maw kang koeng han loe? tiah a naa. Nongpata mah, Nangmah ih bantuek, banlakok hoi cunghet, tiah a naa. Anih mah to hmuennawk to nongpata hanah paek pacoengah, anih to a iih haih, to pongah nongpata loe zokpomh. ");
INSERT INTO cekak_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","To pacoengah nongpata loe angthawk moe, a caeh, anih mah mikhmai khukhaih kahni to angkhring moe, lamhmai khukbuen to angkhuk let. ");
INSERT INTO cekak_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah mah nongpata khaeah suek ih hmuennawk to lak let hanah koeh pongah, angmah ih ampui Adullam acaeng khaeah maeh caa to a pat pae; toe anih mah nongpata to hnu ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","To naah to ahmuen ah kaom kaminawk khaeah, Enaim lam taengah kaom tangzat zaw nongpata loe naa ah maw oh? tiah a dueng. Nihcae mah, Haeah tangzat zaw nongpata om ai bae, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Anih loe Judah khaeah amlaem let moe, To nongpata to ka hnu ai boeh; to ah kaom kaminawk mah doeh haeah tangzat zaw kami om ai, tiah ang naa o, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","To naah Judah mah, Khenah, hae maeh caa hae ka pat pae, toe nongpata to na hnu ai boeh pongah, nongpata mah to ih hmuennawk to angmah han la nasoe, to tih ai nahaeloe azat apaw hoi moeng tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Khrah thumto oh pacoengah, Na langah Tamar loe tangzat zawh moe, vaihi zokpom boeh, tiah Judah khaeah thuih pae o. Judah mah, Nongpata to angzo o haih loe hmai hoiah qoeng oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Anih to angzoh o haih naah, Tamar mah amqang khaeah angmah ih bantuek, banlakok hoi cunghetnawk to thaksak, hae hmuen tawnkung mah kai zok angpomsak, tiah a naa. To pacoengah, khenah, bantuek, banlakok hoi cunghet loe mi ih maw, na panoek maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah mah to hmuennawk to panoek naah, Ka capa Shelah ka zusak ai pongah, anih loe kai pongah toeng kue, tiah thuih. To pacoengah loe anih to iip haih let ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Khenah, nawkta ohhaih tue phak naah loe, anih ih zok thungah caa hnetto angphae. ");
INSERT INTO cekak_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Caa tapen naah nawkta maeto loe a ban tasa bangah payangh, Caa omsakkung mah hae kami hae tapen hmaloe, tiah thuih moe, nawkta ih ban to tlangqui kathim hoiah zaeng pae. ");
INSERT INTO cekak_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Toe ban to azuh let moe, anih ih amnawk to tapen lat; to naah nawkta omsakkung mah, Kawbang maw tha hoi na muk puk thaih takan loe? Tha hoi na muk pukhaih loe na nuiah om nasoe, tiah a naa. To pongah anih ih ahmin to Perez, tiah a sak. ");
INSERT INTO cekak_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","To pacoengah ban ah tlangqui kathim zaeng ih amya to tapen; anih to Zerah, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph to Izip prae ah caeh o haih tathuk; Faro ih angraeng maeto ah kaom, Izip kami, misatuh angraeng Potiphar mah, Joseph to Ishmael kaminawk ih ban thung hoiah a qanh. ");
INSERT INTO cekak_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Angraeng mah Joseph to oh haih, anih loe tuinuen hoih kami ah oh; anih loe Izip kami, angmah angraeng ih im ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Angraeng mah anih oh thuih pongah, a sak ih toknawk boih ah hmacawn, tito angmah ih angraeng mah panoek. ");
INSERT INTO cekak_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph loe anih ih mikcuk naakrak ah khosakhaih hoiah anih ih tok to sak pae; angmah ih imthung khenzawnkung ah a suek moe, a tawnh ih hmuennawk boih doeh anih ban ah ap. ");
INSERT INTO cekak_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Anih to imthung takoh hoi a tawnh ih hmuennawk boih khenzawnkung ah suek pacoengah, Joseph rang hoiah Angraeng mah Izip kami ih imthung takoh to tahamhoihaih paek; Angraeng tahamhoihaih loe Potiphar mah tawnh ih im ih hmuennawk hoi lawk ah tawnh ih hmuennawk boih nuiah oh. ");
INSERT INTO cekak_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","To pongah a tawnh ih hmuennawk to Joseph khaeah a paek boih; anih loe takaw caak khue ai ah loe, a tawnh ih hmuen roe poek ai boeh; Joseph loe somsang hoih moe, krang doeh hoih. ");
INSERT INTO cekak_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Nazetto maw oh pacoengah loe angraeng ih zu mah Joseph to khit moe, kai hae na iip haih ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Toe Joseph mah angmak pae, angmah ih angraeng zu khaeah, Khenah, ka angraeng mah imthung ah kaom hmuennawk boih ka ban ah ap boeh pongah, im ah a suek ih hmuenmae to poek ai boeh; ");
INSERT INTO cekak_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","hae imthung takoh ah kai pong kalen kue mi doeh om ai boeh; nang loe anih ih zu ah na oh pongah, nang khue ai ah loe ka angraeng mah kai hanah paawt ih hmuen tidoeh om ai; kawbang maw kalen parai hae baktih kasae hmuen hoiah zaehaih to Sithaw hmaa ah ka sah thai tih? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Nito pacoeng nito Joseph khaeah to baktih lok to a thuih pae, toe Joseph loe anih to iih haih moe, nawnto oh haih han koeh ai pongah, anih ih lok to tahngai pae ai. ");
INSERT INTO cekak_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nito naah Joseph loe angmah ih tok to sak hanah imthung ah caeh; to naah imthung ah tamna maeto doeh om ai. ");
INSERT INTO cekak_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potiphar ih zu mah Joseph ih laihaw to patawnh moe, Kai hae na iip haih ah, tiah a naa. Toe Joseph mah angmah ih laihaw to nongpata ban ah angkhring pae sut moe, im tasa bangah cawnh taak ving. ");
INSERT INTO cekak_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Nongpata mah Joseph loe laihaw angkhring moe, anih ban ah caehtaak sut pacoengah, tasa bangah cawnh ving boeh, tiah panoek naah, ");
INSERT INTO cekak_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nongpata mah a im ih kaminawk to kawk moe, nihcae khaeah, Khenah, aicae pahnui thuih han ih ni hae Hebru kami hae aicae khaeah a hoih; anih loe kai iih haih hanah kai khaeah angzoh, toe tha hoi ka hang; ");
INSERT INTO cekak_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","tha hoi ka hanghaih lok to anih mah thaih naah, angmah ih laihaw to kai khaeah a caehtaak sut moe, im tasa bangah a cawnh ving, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Angmah ih angraeng im ah angzo ai karoek to, Joseph ih laihaw to nongpata angmah khaeah suek. ");
INSERT INTO cekak_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Angraeng angzoh naah loe hae tiah a thuih pae, Kaicae khaeah nang hoih ih Hebru thendoeng loe kai pahnui thuih hanah kai khaeah angzoh; ");
INSERT INTO cekak_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Toe tha hoi ka hangh naah, angmah ih laihaw to kai khaeah a caeh taak moe, angmah to loe im tasa bangah cawnh ving, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","To tiah na tamna mah kai hae ang sak, tiah a zu mah thuih ih lok to angraeng mah thaih naah, a sava palungphuihaih loe hmai baktiah amngaeh. ");
INSERT INTO cekak_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Joseph ih angraeng mah anih to naeh moe, siangpahrang mah thong pakhrak ih kaminawk suekhaih ahmuen ah Joseph to suek; Joseph loe to ih thongim thungah oh. ");
INSERT INTO cekak_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Toe Joseph loe Angraeng mah oh thuih; a nuiah tahmenhaih amtuengsak moe, thongim toepkungnawk mikcuk naakrak ah oh thaihaih to paek. ");
INSERT INTO cekak_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Thongim ukkung mah thongkrah kaminawk boih khenzawnkung ah Joseph to suek; to ah sak o ih hmuennawk boih khenzawnkung ah Joseph to a suek. ");
INSERT INTO cekak_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Angraeng mah anih to oh thuih pongah, a sak ih hmuen boih ah hmacawn; Joseph khetzawnhaih tlim ah kaom hmuennawk loe thongim khenkung mah khet let han angai ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ni nazetto maw oh pacoengah, Izip siangpahrang ih boengloeng sinkung hoi buh thongkung loe angmah ih angraeng Izip siangpahrang koeh ai ih hmuen to sak hoi. ");
INSERT INTO cekak_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faro loe boengloeng sinkung hoi buh thongkung, angmah ih toksah angraeng hnik nuiah paroeai palungphui. ");
INSERT INTO cekak_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","To pongah nihnik to Joseph thongkrakhaih ahmuen, im toepkung ohhaih im ah thong pakhrak hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Thongim ukkung mah nihnik to Joseph ban ah paek moe, Joseph mah nihnik to khetzawn; ni nazetto maw loe to imthung ah thongkrak hoi. ");
INSERT INTO cekak_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","To tiah thongim thungah oh hoi pacoengah, Izip siangpahrang ih boengloeng sinkung hoi buh thongkung mah, qumto naah angmah hnik hnuksak ih amang to a sak hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Joseph loe khawnbang khawnthaw ah nihnik khaeah caeh; nihnik to khet naah, palung a set hoi. ");
INSERT INTO cekak_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","To pongah angmah ih angraeng im ah angmah hoi nawnto thongkrah Faro ih toksah angraeng hnik khaeah, Tipongah vaihni loe palung na set hoi parai loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nihnik mah, Amang ka sak hoi, toe lehkung om ai, tiah a naa hoi. To pongah Joseph mah nihnik khaeah, Sithaw mah leh thai ai, tiah na poek hoi maw? Na mang to na thui hoih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","To pongah boengloeng sinkung mah angmah ih amang to Joseph khaeah thuih pae; anih khaeah, Ka mang ah, misurkung to ka hmaa ah oh; ");
INSERT INTO cekak_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","to misurkung pongah tanghang thumto oh; tanghang nuiah tadok to tacawt moe, apawk to apawk, athaih to tacawt moe, hminh; ");
INSERT INTO cekak_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Faro ih boengloeng loe ka ban ah oh; misurthaih to ka pakhrik moe, Faro ih boengloeng ah ka pasawh pae, boengloeng to a ban ah ka paek, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph mah anih khaeah, Amang thuih koehhaih loe hae tiah oh; tanghang thumto loe ni thumto thuih koehhaih ih ni. ");
INSERT INTO cekak_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ni thumto thungah Faro mah na lu to atoeng tahang ueloe, nangmah ih ahmuen ah na suem let tih; canghniah boengloeng sinkung ah na oh baktih toengah, Faro ban ah boengloeng paekkung ah na om let tih. ");
INSERT INTO cekak_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Khosak hoihaih na tongh naah, kai hae na pahnet hmah loe, ka nuiah na tahmenhaih amtuengsak ah; Faro khaeah kai ih kawng to na thui pae ah loe, hae thongim thung hoiah na loisak toeng ah; ");
INSERT INTO cekak_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","kai loe Hebru prae thung hoiah ang paquk o ving moe, hae prae ah doeh sakpazaehaih om ai ah thongim thungah ang pakhrak o let bae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Joseph mah amang kahoih ah leh pae, tito buh thong kami mah panoek naah, Joseph khaeah, Kai doeh amang ka sak toeng, Khenah, ka lu nuiah takaw suekhaih kanglung takho thumto ka koeng; ");
INSERT INTO cekak_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ranui koek ih takho pongah loe Faro han ih takaw congca to oh; toe ka lu nui ih takaw loe tavaanawk mah caak o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph mah, Amang thuih koehhaih loe hae tiah oh; takho thumto loe ni thumto thuih koehhaih ih ni; ");
INSERT INTO cekak_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ni thumto thungah Faro mah na lu to pathawk tahang ueloe, thing pongah na bang tih; to pacoengah na ngan to tavaanawk mah caa o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ni thumto naah Faro tapenhaih ni to oh; to naah anih mah angmah ih tamnanawk boih hanah buhraenghaih to sak pae; a tamnanawk salakah boengloeng sin kami hoi buh thong kami ih lu to atoengh pae tahang; ");
INSERT INTO cekak_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","boengloeng sin kami hanah loe tok to a paek let pongah, anih loe Faro ban ah boengloeng paek kami ah oh let; ");
INSERT INTO cekak_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Toe buh thong kami loe Joseph mah thuih pae ih lok baktih toengah, thing nuiah a bangh. ");
INSERT INTO cekak_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Toe boengloeng sin kami mah Joseph to panoek ai, pahnet ving boeh. ");
INSERT INTO cekak_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Saning hnetto boeng pacoengah, Faro mah amang to sak; anih loe vapui taengah angdoet. ");
INSERT INTO cekak_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Khenah, to naah krang kahoih, kathawk maitaw sarihto tui thung hoiah tacawt tahang moe, vapui taeng ih phroh to a caak o. ");
INSERT INTO cekak_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","To pacoengah krangsae, zaek kaeng kalah maitaw sarihto vapui thung hoiah tacawt let moe, hmaloe ih maitawnawk khaeah vapui taengah angdoet o. ");
INSERT INTO cekak_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Krangsae zaek kaeng maitawnawk mah, kranghoih kathawk maitaw sarihtonawk to caak o king. To naah Faro loe anglawt. ");
INSERT INTO cekak_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A ih let naah amang to sak let; khenah, katak moe, kahoih parai cangqui sarihto loe cangkung maeto nuiah tacawt o tahang. ");
INSERT INTO cekak_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","To pacoengah ni angyae bang ih takhi mah hmuh phaeng ih, katak ai kazaek cangqui sarihto tacawt let. ");
INSERT INTO cekak_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","To naah katak ai kazaek cangqui sarihto mah, katak moe, kahoih cangqui sarihtonawk to caak boih. Faro anglawt naah to hmuen loe, amang ah oh pae. ");
INSERT INTO cekak_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Khawnbang phak naah loe a dawnrai; to pongah Izip prae thungah kaom miklet kop kaminawk hoi palungha kaminawk to a kawk boih; Faro mah nihcae khaeah angmah ih amang to thuih pae, toe mi mah doeh leh pae o thai ai. ");
INSERT INTO cekak_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","To naah boengloeng sinkung mah Faro khaeah, Vaihniah ka poek vawk; ");
INSERT INTO cekak_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","nito naah Faro loe a tamnanawk nuiah palungphui moe, kai hoi buh thongkung to thongim khenzawnkung ih im ah thong ang pakhrak hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Qumhto naah, anih hoi nawnto amang ka sak hoi; kaimah hnik thuih koehhaih amang to ka sak hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","To naah misatuh angraeng ih tamna, Hebru kami, thendoeng maeto doeh oh toeng; anih khaeah amang to ka thuih pae hoi, anih mah kaihnik hanah amang ang leh pae; ka sak hoi ih amang to ang leh pae hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Anih mah ang leh pae ih amang baktih toengah, hmuen to oh phaek; kai loe tok ka hnuk let, kalah maeto loe thing nuiah bangh o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","To pongah Faro mah Joseph to kawksak; anih to thongim thung hoi karangah angzoh o haih; sam to aah pae moe, khukbuen to angkraisak pacoengah, Faro hmaa ah a caeh. ");
INSERT INTO cekak_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faro mah Joseph khaeah, Amang ka sak, toe mi mah doeh na leh pae o thai ai; toe nang loe amang leh thaih, tiah thuih ih tamthang to ka thaih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph mah Faro khaeah, Kai mah sakthaihaih ka tawn ai; toe Sithaw mah a koehhaih baktih toengah Faro khaeah thui tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","To pacoengah Faro mah Joseph khaeah, khenah, amang ah vapui taengah kang doet; ");
INSERT INTO cekak_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","khenah, vapui thung hoiah krang kahoih, kathawk maitaw sarihto tacawt o moe, vapui taeng ih phrohnawk to a caak o. ");
INSERT INTO cekak_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Khenah, to pacoengah krangsae kathawk ai, kazaek kaeng maitaw sarihto tacawt let bae. ");
INSERT INTO cekak_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kasae moe, kathawk ai, kazaek kaeng maitaw sarihto mah, tacawt hmaloe krang kahoih, kathawk maitaw sarihtonawk to caak o king; ");
INSERT INTO cekak_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","maitawnawk caak o king pacoengah doeh, caak king boeh, tito mi mah doeh panoek thai ai; toe kathawk maitaw kacaa king, kazaek maitawnawk loe, kathawk maitawnawk caa ai nathuem ih baktih toengah, krangset moe, zaek kaeng ah oh o toeng roeng vop. To pongah kang lawt ving. ");
INSERT INTO cekak_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Amang ka sak let naah, khenah, kahoih parai cangkung maeto nuiah tacawt cangqui sarihto ka hnuk; ");
INSERT INTO cekak_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","khenah, to pacoengah katak ai, kazaek, ni angyae bang ih takhi mah hmuh phaeng ih kamprawk cangqui sarihtonawk to ka hnuk let. ");
INSERT INTO cekak_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Atak kaom ai, kazaek cangqui mah atak kaom cangqui sarihtonawk to paaeh boih; hae kawng hae miklet kop kaminawk khaeah ka thuih pae; toe mi mah doeh na thui pae o thai ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","To pacoengah Joseph mah Faro khaeah, Faro ih amang loe maeto ah ni oh; Sithaw mah sak han ih hmuen loe Faro khaeah amtuengsak boeh. ");
INSERT INTO cekak_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Kahoih maitaw sarihto loe saning sarihto thuikoehhaih ih ni; katak cangqui sarihto doeh saning sarihto thuikoehhaih ih ni; amang loe maeto ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","To maitawnawk hnukah tacawt krangsae moe, kazaek kaeng maitaw sarihtonawk doeh, saning sarihto thuikoehhaih ih ni; atak kaom ai, ni angyae bang ih takhi mah hmuh phaeng ih cangqui loe, saning sarihto thung khokha han thuikoehhaih ih ni. ");
INSERT INTO cekak_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Hae loe Faro khaeah ka thuih tangcae ih amang hoiah ni anghmong; Sithaw mah sak han ih hmuen to Faro khaeah amtuengsak boeh. ");
INSERT INTO cekak_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Khenah, Izip prae thung boih ah saning sarihto thung angraeng paraihaih to om tih; ");
INSERT INTO cekak_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","to pacoengah saning sarihto thung khokhahaih to om tih; to naah Izip prae thungah paroeai angraenghaih to mi mah doeh panoek mak ai boeh; khokhahaih mah prae to amrosak boih tih. ");
INSERT INTO cekak_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Khokhahaih nung parai pongah, canghniah angraeng paraihaih to mi mah doeh panoek thai mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sithaw mah sak han ih hmuen to caksak boeh pongah, Faro khaeah amang vai hnetto amtuengsak boeh; to pongah akra ai ah Sithaw mah to hmuen to omsak tih. ");
INSERT INTO cekak_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","To pongah Faro mah, vaihi khopoek thaihaih hoiah palungha kaminawk to pakrong ah loe, Izip prae to uksak ah. ");
INSERT INTO cekak_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faro mah hae tiah sak na nasoe, prae ukkungnawk to kawk ah loe, prae angraenghaih saning sarihto thung tacawt cang to pangato thungah maeto kok o nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Prae angraeng nathung nihcae mah cang to kok o nasoe loe, Faro khaeah suem o nasoe, vangpui kruekah cang to patung o nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Saning sarihto thung Izip prae khokha naah, khokhahaih mah prae to paro ai ah, prae kaminawk mah caak o thai hanah, hae tiah cang patung han oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","To tiah Joseph mah thuih ih lok to Faro hoi a tamnanawk boih mah hoih, tiah poek o. ");
INSERT INTO cekak_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","To pongah Faro mah, a tamnanawk boih khaeah, Sithaw ih Muithla katawn, hae baktih kami a hnu o thai tih maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","To pacoengah Faro mah Joseph khaeah, Sithaw mah nang khaeah hae hmuennawk hae amtuengsak boih boeh pongah, nang pongah khopoek thaih hoi palungha kami om ai boeh; ");
INSERT INTO cekak_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","nang mah ka imthung to uk ah; na thuih ih lok baktih toengah kai ih kaminawk lokcaek han oh; kai loe angraeng tangkhang pongah kang hnut naah khue ni nang pong ka len kue ah ka om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","To pongah Faro mah Joseph khaeah, Izip prae boih ukkung ah kang suek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","To pacoengah Faro mah angmah ih bantuek to angkhring moe, Joseph ih ban ah abuensak; puu kahni to angkhuksak moe, tahnong ah sui bungmu to a oihsak. ");
INSERT INTO cekak_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Anih mah hnetto haih hrang leeng nuiah Joseph to angthuengsak, kaminawk anih hmaa ah khokkhu cangkrawn oh, tiah hang o. To tiah anih loe Izip prae thung boih ukkung ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","To pacoengah Faro mah Joseph khaeah, Kai loe Faro ah ka oh, toe nang ih lok ai ah loe mi kawbaktih doeh Izip prae thung boih ah a ban maw, a khok maw phok o thai mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faro mah Joseph to Zaphnath Paneah, tiah ahmin paek moe, On vangpui ah kaom qaima Potipherah ih canu, Asenath to anih hanah zu ah a paek; Joseph loe Izip prae thung boih ah caeh. ");
INSERT INTO cekak_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph mah Izip siangpahrang Faro ih toksak pae naah, saning qui thumto oh boeh; Joseph loe Faro hmaa hoi caeh moe, Izip prae to takui boih. ");
INSERT INTO cekak_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Saning sarihto thung prae thungah cang paroeai tacawt. ");
INSERT INTO cekak_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Joseph mah saning sarihto thung Izip prae thung boih ah cang to pakhueng moe, vangpui kruekah suek; vangpui taeng ih cang boih vangpui thungah pakhuengsak. ");
INSERT INTO cekak_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Anih mah patung ih cang loe tuipui taeng ih savuet baktiah paroeai pop moe, kroek laek ai khoek to pop, kroek doeh kroek thai ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Khokhahaih amtong ai naah, On vangpui ah kaom qaima, Potipherah ih canu Asenath mah, Joseph han capa hnetto sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph mah Sithaw mah ka raihaih hoi kam pa ih imthung takoh ang pahnetsak boeh, tiah a thuih pongah calu to Manasse, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A capa hnetto haih loe, Ka patanghaih prae ah Sithaw mah athaih ang thaisak, tiah a thuih pongah Ephraim, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Izip prae angraenghaih loe saning sarihto thungah boeng. ");
INSERT INTO cekak_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Joseph mah thuih ih lok baktih toengah, khokhahaih saning sarihto oh amtong boeh; prae boih ah khokha pongah kaminawk loe duek o, toe Izip prae ah loe buh to oh. ");
INSERT INTO cekak_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Izip prae thungah khokhahaih amtong naah, kaminawk loe buh hnik hanah Faro khaeah hang o; to naah Faro mah Izip kaminawk boih khaeah, Joseph khae caeh oh loe, a thuih ih lok baktih toengah sah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Long pum ah khokhahaih to phak, Izip prae thung khokhahaih nung parai boeh pongah, Joseph mah patung ih cang to paongh moe, Izip kaminawk khaeah zawh. ");
INSERT INTO cekak_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Prae thung boih ah khokhahaih nung parai boeh pongah, prae kruek ih kaminawk Izip prae ah angzoh o moe, Joseph khaeah cang to qan o. ");
INSERT INTO cekak_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Izip prae ah cang oh, tito Jakob mah thaih naah, a caanawk khaeah, Tikhoe nangmacae hoi nangmacae to nang khet o khing loe? ");
INSERT INTO cekak_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Khenah, Izip prae ah cang oh, tiah ka thaih; caeh o tathuk loe, a duek o han ai a hing o thai hanah, cang to qan oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","To pongah Joseph ih amya hatonawk loe cang qan hanah Izip prae ah caeh o tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Toe Jakop mah raihaih tong moeng tih, tiah zithaih tawnh pongah, Joseph ih amnawk, Benjamin loe patoeh ai. ");
INSERT INTO cekak_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaan prae ah khokha pongah, cang qan han caeh kaminawk thungah, Israel ih caanawk athum o toeng. ");
INSERT INTO cekak_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph loe prae ukkung ah oh moe, kaminawk khaeah cang zawkung ah oh; Joseph ih amyanawk loe caeh o moe, anih hmaa ah long ah akuep o. ");
INSERT INTO cekak_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph mah amyanawk to hnuk naah, nihcae to maat boih, toe kami kalah baktiah angsak pae moe, nihcae to lok kaham hoiah tapring; nihcae khaeah, Nangcae loe naa hoiah maw nang zoh o? tiah a naa. Nihcae mah, Cang qan hanah Kanaan prae hoiah kang zoh o, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph mah amyanawk to panoek, toe nihcae mah anih to panoek o ai. ");
INSERT INTO cekak_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph mah nihcae kawng thuih koehhaih amang to a poek moe, nihcae khaeah, Nangcae loe tamquta hoi misa khen kami ni, prae thung thazokhaih oh maw, om ai tiah khet han ih ni nang zoh o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nihcae mah, To tih na ai ni, ka angraeng, na tamnanawk loe cang qan han ih ni kang zoh o. ");
INSERT INTO cekak_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kaicae loe kami maeto ih caa ni, kaicae loe kahoih kami ah ni ka oh o, na tamnanawk loe minawk khen paqu kami na ai ni, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nihcae khaeah, To tih na ai ni; prae thung thazokhaih oh maw, om ai tiah khet han ih ni nang zoh o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Toe nihcae mah, Kaicae loe nawkamya hatlai hnetto ka oh o moe, Kanaan prae ah kaom kami maeto ih caa ah ni ka oh o boih; khenah, asoi koek loe kam pa khaeah oh moe, maeto loe om ai boeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph mah nihcae khaeah, Kang thuih o ih baktiah ni na oh o; nangcae loe tamquta hoi misa khen kami ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","To tih boeh loe nangcae tanoek hanah hae tiah om nasoe, nam nawk asoi koek to haeah angzo ai nahaeloe, Faro hing thung hae ahmuen hoiah na tacawt o thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nangcae loktang thuih maw, thui ai tito tanoek hanah, nangmacae thung ih kami maeto patoeh oh, anih mah nam nawk kanawk koek to haeah angzo haih nasoe; to tih ai nahaeloe, Faro hing thung nangcae loe tamquta hoi misa khen kami ah ni na om o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","To pacoengah nihcae to ni thumto thung thongim pakhrak. ");
INSERT INTO cekak_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ni thumto naah loe Joseph mah nihcae khaeah, Kai loe Sithaw ka zit, nangcae na hing o thai hanah, hae tiah sah oh; ");
INSERT INTO cekak_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","kahoih kami ah na oh o nahaeloe, nangcae thung ih kami maeto thongim thungah caeh o taak ah; kalah kaminawk loe im ah kaom zok kamthlam kaminawk hanah cang to phaw pae oh; ");
INSERT INTO cekak_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","nam nawk asoi koek to kai khaeah nang hoih o nahaeloe, nang thuih o ih lok baktih toengah katoeng kami ah na om o ueloe, na hing o tih, tiah a naa. To tiah a thuih pae ih lok baktih toengah nihcae mah sak o. ");
INSERT INTO cekak_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","To naah nihcae mah, aimacae ih amnawk nuiah zaehaih a tawnh o boeh; anih mah tahmenhaih ang hnik naah, anih loe kawkruk maw poek angpho, tito a panoek o, toe aicae mah a thuih ih lok tahngai pae o ai; to pongah vaihi aicae nuiah tasoehhaih phak boeh, tiah maeto hoi maeto a thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben mah nihcae khaeah, Nawkta nuiah zaehaih sah o hmah, tiah kang thuih o naah na tahngai o ai to loe? To pongah khenah, vaihi loe anih ih athii tho a hnu o tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Lok lehkung to patoh pongah, Joseph mah nihcae ih lok to thaih kop, tiah nihcae mah panoek o ai. ");
INSERT INTO cekak_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Joseph loe nihcae khae hoi kalah bangah angqoi moe qah; toe angqoi let moe, nihcae khaeah lokthuih pae let, nihcae mikhnuk ah Simeon to naeh moe, qui hoiah pathlet. ");
INSERT INTO cekak_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph mah nihcae ih dip thungah cang to thaengh pae moe, a paek o ih phoisa doeh angmacae ih dip thungah pacaeng pae let pacoengah, loklam ah caak koi hmuennawk pacaeng pae hanah, lok a thuih pae; to tiah nihcae hanah a sak pae. ");
INSERT INTO cekak_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Angmacae ih laa hrang nuiah cang to thuengh o moe, a caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ataihaih ahmuen ah phak o naah, kami maeto mah angmah ih laa hrang to rawkcak paek hanah dip to paongh, to naah phoisa to dip thungah a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Angmah ih nawkamyanawk khaeah, Khenah, phoisa ang pakut let, kai ih dip thungah oh, tiah a naa. To naah palungboeng o moe, tasoehhaih hoiah oh o; tipongah Sithaw mah aicae nuiah hae tiah hmuen a sak vai? tiah maeto hoi maeto ang thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kanaan prae ah ampa Jakob khae phak o naah, a tongh o ih hmuennawk boih a thuih pae o; nihcae mah, ");
INSERT INTO cekak_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","to prae ukkung angraeng mah lok kaham hoiah kaicae to ang tapring; kaicae loe tamquta hoi prae thazokhaih khen kami ah a poek. ");
INSERT INTO cekak_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kaicae mah anih khaeah, Kaicae loe kahoih kami ni, tamquta hoi minawk khen kami na ai ni; ");
INSERT INTO cekak_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","kaicae loe nawkamya hathai hnetto ka oh o moe, ampa maeto ih caa ni, maeto loe om ai boeh; kanawk koek loe Kanaan prae ah kam pa khaeah oh, tiah ka thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","To naah to prae ukkung angraeng mah, kaicae khaeah, Kami kahoih ah na oh o, tiah ka panoek thai hanah, nangcae thung ih kami maeto kai khaeah na caeh o taak ah, kalah kaminawk loe na imthung takoh zok kamthlam kaminawk hanah cang to phaw pae oh; ");
INSERT INTO cekak_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","nangcae loe tamquta hoi misa khen kami na ai, kahoih kami ni, tiah ka panoek thai hanah, nangcae ih amnawk asoi koek to kai khaeah angzo o haih ah; to pacoengah haeah kaom nam nawk hae kang paek o let han; to naah ni prae thungah hmuenmae na zaw o thai vop tih, tiah ang naa, tiah a thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Angmacae dip thung ih cang to pakong o boih naah, khenah, angmacae ih phoisa bawm loe dip thungah oh boih let; angmacae hoi ampa mah phoisa tabunawk to hnuk naah, tasoeh o. ");
INSERT INTO cekak_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ampa Jakob mah nihcae khaeah, Ka caanawk to nang tahmat pae o boih boeh; Joseph loe om ai boeh moe, Simeon doeh om ai boeh; vaihi Benjamin lak hanah na thuih o let bae vop; hae hmuennawk hae ka koeh baktiah om thai ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","To naah Reuben mah ampa khaeah, Anih nang khaeah kang zo o haih let ai nahaeloe, ka caa hnik hae hum hmaek ah; ka ban ah na paek ah, kai mah kang hoih let han hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Toe Jakob mah, Ka capa hae na caeh haih mak ai; amya duek boeh moe, anih loe angmabueng ah ni oh boeh, loklam ah kasae tongh moeng nahaeloe, palungset loiah ka lu ih sampok hoi nawnto ah ni taprong thungah nang caeh o sak tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Prae thungah khokhahaih nung parai vop. ");
INSERT INTO cekak_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Izip prae thung hoi phawh o ih cang to caak o boih pacoengah ampa mah, nihcae khaeah, Caeh o let ah loe, cang to na qan pae o let raeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Toe Judah mah anih khaeah, To ih kami mah, Nam nawk na hoi o ai nahaeloe, ka mikhmai nang hnu o thai mak ai, tiah ang thuih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kam nawk to kaicae hnukah nang zohsak nahaeloe, ka caeh o tathuk moe, cang to kang qan pae o han; ");
INSERT INTO cekak_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","toe anih to nang zosak ai nahaeloe, ka caeh o tathuk mak ai; to kami mah, Nam nawk na hoi o ai nahaeloe, ka mikhmai na hnu o thai mak ai, tiah a thuih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel mah, kai raihaih paek hanah, tikhoe kam nawk oh vop, tiah na thuih o loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nihcae mah, To kami mah kaimacae kawng hoi imthung takoh kawng, nam pa hing vop maw? Nam nawk kalah oh vop maw? tiah ang dueng; kaicae mah doeh ang dueng ih lok ni ka pathim pae o; nam nawk haeah na hoi o tathuk ah, tiah thui tih tito mi mah maw panoek? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","To pacoengah Judah mah ampa Israel khaeah, Kaicae boih, nangmah hoi nawkta to dueh ai, ka hing o thai hanah, nawkta to kai hoi nawnto patoeh ah, kang thawk o moe, ka caeh o roep han boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Anih to kahoih ah ka khetzawn han hmang; anih to nang khaeah kang zo haih let ai moe, na hmaa ah kang pha haih let ai nahaeloe, ka hing thung zaehaih ka zok han; kai khaeah anih to na suk ah; ");
INSERT INTO cekak_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","hae tiah pakaahaih om ai nahaeloe, ka caeh o moe, vai hnetto doeh kam laem o han boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","To naah ampa Israel mah nihcae khaeah, To tiah om nasoe, tiah na poek o nahaeloe, hae tiah sah oh; hae prae thung ih kahoih koek thingthai, tak angnok koi hmuihoih, khoitui zetta, aan ah thuh ih hmuihoih, myrrh, thingthai mu hoi almond mu to phaw oh loe, to kami hanah tangqum ah paek oh. ");
INSERT INTO cekak_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Phoisa to kamtlai ah sin pae oh; nangmacae ih dip thungah kaom phoisa to sin oh loe, paek o let ah; anih mah pacaeng pazae moeng mue. ");
INSERT INTO cekak_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Nam nawk hae caeh o haih ah, angthawk oh loe, to kami khaeah caeh o let ah. ");
INSERT INTO cekak_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","To kami mah to ih nam nawk to prawt moe, Benjamin na hoih o let thai hanah, Thacak Sithaw mah nangcae to tahmen nasoe; kai loe ka caanawk pongah, palungset hoiah ni ka oh han boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","To pongah nihcae mah tangqum hoi phoisa to kamtlai ah sin o moe, Benjamin doeh caeh o haih; angthawk o moe, Izip prae ah caeh o tathuk pacoengah, Joseph hmaa ah angdoet o. ");
INSERT INTO cekak_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Nihcae salakah kaom Benjamin to Joseph mah hnuk naah, angmah ih im khenzawnkung khaeah, Hae kaminawk hae ka im ah caeh haih ah, maitaw maeto bop oh loe, buh raenghhaih to sah ah; athun naah nihcae hoi nawnto buh ka caak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Joseph mah thuih ih lok baktih toengah to kami mah sak pae, nihcae to Joseph im ah caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Joseph im ah a caeh haih pongah nihcae loe tasoeh o, canghni cang qan han a caeh o tangsuek naah aicae dip thungah phoisa oh let pongah ni, im ah ang caeh haih boeh; aicae hae na bop ueloe, nganbawh kana na paek tih boeh, tamna ah suek pacoengah, aicae ih laa hrangnawk doeh laa boih tih boeh, tiah a poek o. ");
INSERT INTO cekak_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","To pongah Joseph im toepkung khaeah caeh o moe, thok taengah anih khaeah lokthuih pae o. ");
INSERT INTO cekak_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Nihcae mah, Aw angraeng, kaicae loe canghniah haeah cang qan han kang zoh o vai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ataihaih im ka phak o naah, dip to ka paongh o, to naah kaimacae ih dip thungah phoisa tabu angmah toengroeng ah ka hnuk o let; to pongah vaihi kang sin o let. ");
INSERT INTO cekak_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Cang qan hanah kalah phoisa doeh ka sin o let; mi mah maw kaicae ih dip thungah phoisa pacaeng, tito ka panoek o ai, tiah naa o. ");
INSERT INTO cekak_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Anih mah, Lunghoihta hoiah om oh, mawn o hmah; nangcae ih Sithaw, nangcae ampa ih Sithaw mah ni nangcae ih dip thungah phoisa to ang pacaengh pae; nangcae ih phoisa loe ka hnuk bae, tiah a naa. To pacoengah anih mah Simeon to nihcae khaeah caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Im toepkung mah nihcae to Joseph im ah caeh haih, khok amsaeh han tui a paek moe, laa hrangnawk doeh rawkcak pacah. ");
INSERT INTO cekak_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","To ah buhcaak han oh, tiah a thaih o pongah, Joseph athun buhcaak han angzoh naah tangqum hae paek si, tiah a thuih o moe, tangqumnawk to pathok o. ");
INSERT INTO cekak_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Joseph im ah amlaem naah, a sinh o ih tangqum to imthung ah Joseph han paek o moe, a hmaa ah long ah akuep pae o. ");
INSERT INTO cekak_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ngan na tui o maw? Nang thuih o ih nam pa mitong loe ngantui maw? A hing vop maw? tiah a dueng. ");
INSERT INTO cekak_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nihcae mah, Na tamna kaicae ampa loe hing vop, ngan doeh tui vop bae, tiah a naa o; to pacoengah a hmaa ah akuep o moe, khingyahaih paek o. ");
INSERT INTO cekak_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","A khet naah amno ih capa, amnawk Benjamin to a hnuk, Anih loe nang thuih o ih, nam nawk asoi koek maw? tiah a naa. Sithaw mah na tahmen nasoe, ka capa, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Amnawk nuiah palungset pongah, qahhaih ahmuen pakrong hanah karangah a caeh ving; angmah ih imthung ah a caeh moe, to ah a qah. ");
INSERT INTO cekak_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mikhmai pathlak pacoengah, angzoh let, qah amsumh pacoengah, Buhcaak hanah patoemh oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Angmabueng caak hanah buh to patoemh pae o, anih ih nawkamyanawk caak hanah doeh ahmuen kalah ah buh to patoem pae o; anih hoi nawnto buhcaa Izip kaminawk hanah doeh buh to patoem pae o toeng; Izip kaminawk hanah panuet thoh pongah, Izip kaminawk loe Hebru kaminawk hoi nawnto buhcaa o ai. ");
INSERT INTO cekak_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Nawkamyanawk loe kacoeh koek hoi kanawk koek khoek to, angmacae ih saning baktih toengah Joseph hmaa ah anghnut o; nihcae loe maeto hoi maeto ang khet o moe, dawnrai o. ");
INSERT INTO cekak_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Joseph mah nihcae caak hanah buh pazet naah, Benjamin to kalah kaminawk pongah alet pangato kamtlai ah a paek; nihcae loe naek o moe, anih hoi nawnto kanawm ah oh o. ");
INSERT INTO cekak_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph mah angmah ih im khenzawnkung khaeah, nihcae a phawh o thai thung, cang to phawsak ah loe, cang qanhaih phoisa to angmacae dip thungah pacaeng pae boih let ah, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","To pacoengah kai ih boengloeng, sum kanglung hoi sak ih boengloeng to, kanawk koek ih dip thungah cang a qanhaih phoisa hoi nawnto pacaeng paeh, tiah a naa. Joseph mah thuih ih lok baktih toengah anih mah sak. ");
INSERT INTO cekak_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Khawnbang khodai naah loe nihcae to, angmacae ih laa hrang hoi nawnto patoeh. ");
INSERT INTO cekak_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nihcae vangpui thung hoi tacawt o moe, nasetto kangthla ah doeh caeh o ai vop, to naah Joseph mah angmah ih im khenzawn kami khaeah, to kaminawk to patom ah loe, na kae naah, nihcae khaeah, Tipongah kahoih hmuen to kasae hoiah nang pathok o loe? ");
INSERT INTO cekak_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tih hanah ka angraeng mah tui naek naah patoh ih, a boengloeng to na paquk o loe? To boengloeng loe kaom han koi hmuen khet naah patoh ih boengloeng ah oh, na sak o ih hmuen hae hoih ai, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Anih mah nihcae to kae naah, a thuisak ih lok baktih toengah nihcae khaeah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Toe nihcae mah, Tikhoe ka angraeng loe to tiah lokthuih loe? Na tamnanawk loe to baktih hmuen to ka sah o mak ai. ");
INSERT INTO cekak_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Khenah, dip thungah ka hnuk o ih phoisa mataeng doeh, Kanaan prae thung hoiah kang sin o let bae; kawbang maw na angraeng im ih phoisa hoi sui to ka paqu o halat tih? ");
INSERT INTO cekak_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Na tamnanawk thungah mi kawbaktih ih dip thungah doeh to hmuen to na hnuk nahaeloe, anih to dueh nasoe; kalah kaicae boih loe ka angraeng ih tamna ah ka oh o han, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Anih mah, Na thuih o ih lok baktiah om nasoe, mi kawbaktih ih dip thungah doeh boengloeng to ka hnuk nahaeloe, anih to ka tamna ah om nasoe, kalah kaminawk loe loih o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","To pacoengah long ah karangah amtik o moe, angmacae ih dip to paongh o boih. ");
INSERT INTO cekak_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Im toepkung mah kacoeh ih hmuen hoi kanawk ih hmuen khoek to pakrong pae bit; to naah Benjamin ih dip thungah boegloeng to a hnuk. ");
INSERT INTO cekak_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","To naah nihcae loe laihaw to asih o moe, laa hrang nuiah hmuennawk to thuengh o pacoengah, vangpui ah amlaem o let. ");
INSERT INTO cekak_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judah hoi nawkamyanawk Joseph imthung ah akun o naah, Joseph loe imthung ah oh vop, nihcae loe anih hmaa ah long ah akuep o. ");
INSERT INTO cekak_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph mah nihcae khaeah, Tipongah hae tiah na oh o loe? Na sak o ih hmuen ka panoek mak ai, tiah na poek o maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah mah anih khaeah, Ka angraeng khaeah timaw ka thuih o han boeh? Timaw ka thuih o han vop? Kawbang maw toenghaih kam tueng o sak han? Na tamnanawk ih zaehaih Sithaw mah amtuengsak boeh; khenah, kaicae loe nang ih tamna ah ni ka oh o han boeh, kaicae hoi boengloeng phawkung loe na tamna ah ka oh o han boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Toe Joseph mah nihcae khaeah, To baktih hmuen to ka sah mak ai; boengloeng phawkung khue ni kai ih tamna ah om tih; kalah boih loe nam pa khaeah lunghoihta hoiah caeh oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Judah mah anih khaeah caeh moe, Aw, ka angraeng, ka angraeng khaeah lok pakha to mah na thuisak raeh, nang loe Faro hoi kangvan ah na oh; toe na tamna nuiah palungphuisak hma raeh. ");
INSERT INTO cekak_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ka angraeng nang mah, Nam pa hoi nam nawk na tawnh o vop maw? tiah nang dueng. ");
INSERT INTO cekak_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kaicae mah ka angraeng khaeah, Kam pa loe oh vop, anih loe mitong boeh moe, mitong lam ah sak ih capa maeto oh vop; anih ih amya loe duek boeh; amno ih capanawk thungah anih khue ni anghmat boeh; anih loe ampa mah paroeai palung, tiah kang thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","To naah nang mah na tamnanawk khaeah, Kai khaeah angzo o haih ah, hnuk han ka koeh toeng, tiah na thuih. ");
INSERT INTO cekak_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kaicae mah ka angraeng nang khaeah, Nawkta loe ampa hoi ampraek thai ai, anih mah caeh taak nahaeloe, kam pa loe dueh tih, tiah kang thuih o. ");
INSERT INTO cekak_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Toe nang mah na tamnanawk khaeah, Asoi koek nam nawk to nang zo o haih tathuk ai nahaeloe, ka mikhmai nang hnu o let mak ai boeh, tiah nang thuih. ");
INSERT INTO cekak_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na tamnanawk kam pa khaeah ka caeh o let naah, ka angraeng nang mah nang thuih ih loknawk to ka thuih pae o boih. ");
INSERT INTO cekak_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","To naah kam pa mah, Caeh o let ah loe, cang na qan pae o let ah, tiah ang naa. ");
INSERT INTO cekak_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Toe kaicae mah, Ka caeh o tathuk let mak ai; asoi koek kam nawk angzoh naah ni ka caeh o thai tih; asoi koek kam nawk to om ai nahaeloe, to kami ih mikhmai to ka hnu o let thai mak ai boeh, tiah ka naa o. ");
INSERT INTO cekak_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Na tamna ih ampa mah, Ka zu mah caa hnetto ang sak pae, tito na panoek o. ");
INSERT INTO cekak_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Maeto loe kai khae hoiah caeh ving boeh pongah, Anih loe moi kasan mah taprawt pet pet boeh mue, tiah kang naa o. To pacoeng hoiah loe anih to ka hnu let ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Anih hae na lak o let moe, kasae tongh moeng nahaeloe, palungset loiah ka lu nui ih sampok hoiah ni nawnto taprong thungah nang thak o tih boeh, tiah ang naa. ");
INSERT INTO cekak_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","To pongah vaihi, nawkta hae hoi ai ah, na tamna mah kam pa khaeah ka caeh let nahaeloe, nawkta hinghaih hoi amhoe thai ai kam pa mah, ");
INSERT INTO cekak_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","nawkta to khet hawk moe, kaicae hoi nawnto nawkta angzo ai, tiah panoek nahaeloe, anih loe dueh roep tih boeh; na tamnanawk mah palungset loiah anih lu nui ih sampok to taprong thungah ka laem o sak moeng tih. ");
INSERT INTO cekak_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na tamna kai mah nawkta to ngancuem ah kang zoh haih let han hmang, tiah ka thuih pae boeh; anih to kang zo haih let ai nahaeloe, ka hing thung kam pa hmaa ah kasae thuihaih ka phawh han hmang, tiah lok ka thuih boeh. ");
INSERT INTO cekak_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","To pongah vaihi nawkta zuengah kai hae na tamna ah ka oh han, nawkta loe amyanawk hoi nawnto amlaemsak ah. ");
INSERT INTO cekak_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nawkta om ai ah, kawbang maw kam pa khaeah kam laem let thai tih? To tih ai nahaeloe, kam pa nuiah kapha raihaih to ka hnu moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph loe a taengah kangdoe kaminawk hmaa ah angsum thai ai boeh pongah, Kai khae hoi kalah bang caeh o boih ah, tiah a hang; to naah Joseph mah amyanawk khaeah angmah hoi angmah to taphong, to naah a taengah mi doeh om ai. ");
INSERT INTO cekak_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tha hoi a qah pongah, Izip kaminawk hoi Faro imthung takohnawk mah doeh thaih o. ");
INSERT INTO cekak_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph mah amyanawk khaeah, Kai loe Joseph ni! Pa to hing vop maw? tiah a naa. Toe amyanawk loe, Anih hmaa ah poek anghmang o sut pongah, lok pathim pae o ai. ");
INSERT INTO cekak_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","To naah Joseph mah amyanawk khaeah, Ka taengah angzo oh, tiah a naa. Nihcae loe caeh o. Anih mah, Kai loe Izip prae ah nang zawh o ih, nangcae ih amnawk Joseph ni! ");
INSERT INTO cekak_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","To pongah kai nang zawh o pongah vaihi palungsae o sak hmah loe, palung doeh phui o hmah; hinghaih pahlong han ih ni hae ahmuen ah Sithaw mah kai ang patoeh hmaloe. ");
INSERT INTO cekak_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Vaihi prae thungah khokhahaih saning hnetto oh boeh, hmabang saning pangato thung mi mah doeh lawk sah mak ai ueloe, cang doeh aat o mak ai. ");
INSERT INTO cekak_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Toe long ah kanghmat nangcae to hingsak moe, kalen parai pahlonghaih hoiah nangcae to loisak hanah, Sithaw mah hae ahmuen ah kai hae ang patoeh boeh. ");
INSERT INTO cekak_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","To pongah kai haeah patoehkung loe nangcae na ai, Sithaw ni; anih mah Faro to ampa ah ang sak pae, a imthung takoh boih ih angraeng ah ang suek moe, Izip prae boih ukkung ah ang sak. ");
INSERT INTO cekak_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kam pa khaeah karangah caeh oh loe, anih khaeah, Na capa Joseph mah, Kai loe Sithaw mah Izip prae thung boih ukkung angraeng ah ang sak boeh; akra ai ah, kai khaeah angzo tathuk ah, tiah a thuih; ");
INSERT INTO cekak_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","kaimah hoi kazoi ahmuen, Goshen prae ah khosah oh, nangmah hoi na caanawk, na caanawk patoeng, maitawnawk, tuunawk hoi na tawnh ih hmuennawk to sin o boih ah; ");
INSERT INTO cekak_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","kai mah kang pacah o han hmang, saning pangato thung khokha vop tih; to tih ai nahaeloe nangmah hoi na imthung takoh boih, na tawnh ih hmuennawk boih anghmaa tih, tiah thui pae oh. ");
INSERT INTO cekak_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Khenah, nangcae hoi kam nawk Benjamin mikhnuk ah, ka pakha hoiah kang thuih o ih lok to na thaih o boeh. ");
INSERT INTO cekak_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Izip prae ah ka lensawkhaih hoi na hnuk o ih hmuennawk boih, kam pa khaeah thui pae oh; karangah caeh oh loe, kam pa to haeah angzo o haih ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","To pacoengah amnawk Benjamin to takop moe, a qah; Benjamin mah doeh anih to takop moe, qah; ");
INSERT INTO cekak_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","to pacoengah amyanawk boih to a mok moe, a qah; to pacoengah amyanawk hoiah lok apaeh o. ");
INSERT INTO cekak_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Joseph ih amyanawk angzoh o ti, tiah Faro imthung takoh mah thaih naah, Faro hoi a tamnanawk boih poeknawm o. ");
INSERT INTO cekak_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faro mah Joseph khaeah, Nam yannawk khaeah, hae tiah thui paeh loe, hae tiah sahsak ah; laa hrang hoiah hmuennawk to phaw o sak ah loe, Kanaan prae ah amlaemsak ah; ");
INSERT INTO cekak_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","nam pa hoi imthung takoh kaminawk to kai khaeah angzosak ah; Izip prae thungah kahoih koek prae to kang paek han, prae kathawk to na caa o tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Nangmah doeh nihcae khaeah hae tiah sak hanah thui paeh, a caanawk hoi a zunawk to lak hanah Izip prae thung ih hrang leeng to la nasoe loe, nam pa to angzo o haih nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Hmuennawk to paawt o hmah, Izip prae thung boih ih kahoih koek hmuen loe nihcae hanah om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","To pongah Israel caanawk mah to tiah a sak o; Faro mah thuih ih lok baktih toengah, Joseph mah hrang leengnawk to a paek, to pacoengah loklam ah caak han ih hmuen doeh a paek. ");
INSERT INTO cekak_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nihcae boih han khukbuen kangtha to a paek, toe Benjamin loe phoisa cumvai thumto hoi khukbuen zung pangato a paek. ");
INSERT INTO cekak_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ampa hanah Izip prae thung ih kahoih koek hmuennawk to laa hrang hato pongah a phawsak, laa hrang amno hato pongah cang hoi takaw to phawsak pacoengah, ampa mah loklam ah caak han ih hmuennawk to a pat pae. ");
INSERT INTO cekak_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","To pacoengah amyanawk to patoeh, nihcae doeh amsak o; loklam ah maeto hoi maeto angzoeh o hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nihcae loe Izip prae thung hoiah angthawk o tahang moe, ampa Jakob ohhaih Kanaan prae ah caeh o. ");
INSERT INTO cekak_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Anih khaeah, Joseph loe hing vop! Izip prae ukkung ah oh, tiah a naa o. To naah Jakob loe palungboeng sut; nihcae to tang ai. ");
INSERT INTO cekak_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Toe Joseph mah thuih ih loknawk boih a thuih pae o moe, anih phawh hanah Joseph mah pat pae ih hrang leeng to a hnuk naah ni, ampa Jakob loe poekhaih tha oh let vop. ");
INSERT INTO cekak_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","To naah Israel mah, Khawt boeh! Ka capa Joseph loe hing vop, ka caeh moe, ka dueh ai naah anih to ka hnuk han vop, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","To pongah Israel loe a tawnh ih hmuennawk boih hoiah caeh moe, Beersheba phak naah, ampa Issak ih Sithaw khaeah angbawnhaih to sak. ");
INSERT INTO cekak_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Sithaw mah Jakob khaeah aqum ah hnuksakhaih hoi lok to thuih pae, Jakob! Jakob! tiah a naa. Anih mah, Haeah ka oh, tiah pathim. ");
INSERT INTO cekak_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Anih mah, Kai loe Sithaw, nam pa ih Sithaw ah ka oh; Izip prae ah caeh tathuk hanah zii hmah; to ah kalen parai acaeng ah kang sak han. ");
INSERT INTO cekak_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Izip prae ah kang caeh haih moe, kam laem haih let han, Joseph mah na mik nuiah a ban to koeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","To pacoengah Jakob loe kholong caeh hanah Beersheba hoiah amsak, Israel ih caanawk mah ampa Jakob, anih ih caanawk hoi a zunawk to Faro mah nihcae phawh hanah patoeh ih hrang leeng nuiah angthueng o sak. ");
INSERT INTO cekak_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","To pacoengah Jakop mah Kanaan prae ah hnuk o ih hmuennawk hoi maitawnawk to sinh moe, a caanawk hoi nawnto Izip prae ah caeh tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jakob loe angmah hoi a caanawk doeh Izip prae ah caeh haih boih. ");
INSERT INTO cekak_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Hae kaminawk loe Izip prae ah kacaeh Israel ih caanawk, Jakob caanawk ih ahmin ah oh; Reuben loe Jakob ih calu ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben ih caanawk loe Hanok, Phallu, Hezron hoi Karmi. ");
INSERT INTO cekak_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon ih caanawk loe Jemuel, Jamin, Ohad, Jachin, Zohar hoi Kanaan nongpata ih capa Shaul. ");
INSERT INTO cekak_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ih caanawk loe Gershon, Kohath hoi Merari. ");
INSERT INTO cekak_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah ih caanawk loe Er, Onan, Shelah, Pharez hoi Zerah; toe Er hoi Onan loe Kanaan prae ah duek hoi boeh. Perez ih caanawk loe, Hezron hoi Hamul. ");
INSERT INTO cekak_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issakar ih caanawk loe Tola, Puvah, Job hoi Shimron. ");
INSERT INTO cekak_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun ih caanawk loe Sered, Elon hoi Jahleel. ");
INSERT INTO cekak_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hae kaminawk loe Padan Aram ah, Leah mah Jakob hanah, canu Dinah hoi nawnto sak ih caa ah oh o; a capa hoi a canunawk loe sangqum boih ah qui thum, thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad ih caanawk loe Zephion, Haggi, Shuni, Ezbon, Eri, Arodi hoi Areli. ");
INSERT INTO cekak_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher ih caanawk loe Jimnah, Ishuah, Isui hoi Beriah; nihcae ih tanuh loe Serah; Beriah ih caanawk loe Heber hoi Malkiel. ");
INSERT INTO cekak_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hae kaminawk loe Laban mah a canu Leah khaeah paek ih, Zilpah mah Jakob hanah sak pae ih caa ah oh o; kami hatlai tarukto oh o. ");
INSERT INTO cekak_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Joseph hoi Benjamin loe Jakob ih zu Rachel ih caa ah oh, ");
INSERT INTO cekak_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Izip prae, On vangpui ah kaom qaima Photipherah canu, Asenath mah Joseph han sak pae ih caanawk loe Manasseh hoi Ephraim. ");
INSERT INTO cekak_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin ih caanawk loe Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim hoi Ard. ");
INSERT INTO cekak_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hae kaminawk loe Rachel mah, Jakob hanah sak pae ih kami ah oh o moe, sangqum boih ah hatlai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ih caanawk loe Hushim. ");
INSERT INTO cekak_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali ih caanawk loe, Jahzeel, Guni, Jezer hoi Shillem. ");
INSERT INTO cekak_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hae kaminawk loe Laban mah a canu Rachel khaeah paek ih, Bilah mah Jakob han sak pae ih caa ah oh o moe, sangqum boih ah sarihto oh o. ");
INSERT INTO cekak_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jakob hoi nawnto Izip prae ah angzo kaminawk boih, a capa ih zunawk to kroek ai ah, angmah ih caanawk boih loe qui taruk, tarukto oh o. ");
INSERT INTO cekak_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Joseph mah Izip prae thungah sak ih capa hnetto hoi Izip prae ah angzo, Jakob ih canawknawk boih loe, sangqum boih ah qui sarihto oh o. ");
INSERT INTO cekak_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Goshen prae caehhaih loklam duengh hanah Jakob mah Judah to Joseph khaeah patoeh hmaloe, to tiah Goshen prae to a phak o. ");
INSERT INTO cekak_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph loe hrang leeng to suek coek moe, ampa Israel to hnuk hanah Goshen prae ah caeh; Goshen prae ah ampa khaeah phak naah, ampa to takop moe, a qah. ");
INSERT INTO cekak_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel mah Joseph khaeah, Na hing vop pongah, na krang ka hnuk boeh; vaihi loe ka duek cadoeh palung mong boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","To pacoengah Joseph mah amyanawk hoi ampa imthung takohnawk khaeah, Faro khaeah ka caeh tahang moe, Kanaan prae ah kaom kam yanawk hoi kam pa imthung takohnawk angzoh o boeh; ");
INSERT INTO cekak_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","nihcae loe tuu toep kami, maitaw khenzawn kami ah oh o; nihcae loe a tawnh o ih hmuen boih, maitawnawk, tuunawk to sin o, tiah ka thuih pae han. ");
INSERT INTO cekak_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Faro mah kawk moe, tih tok maw na sak o? tiah na dueng nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","nangcae mah, Na tamnanawk loe nawkta nathuem hoi kamtong vaihni ni khoek to, kam pa mah sak ih baktih toengah, maitawnawk ni ka toep o, tiah thui oh; to tiah nahaeloe nangcae to Goshen prae ah na omsak tih; tuutoep kami loe Izip kaminawk mah panuet o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph loe caeh moe, Faro khaeah, Kam pa hoi kam yanawk loe tuu, maitawnawk hoi a tawnh o ih hmuennawk boih phawh o moe, Kanaan prae hoiah angzoh o boeh, vaihi Goshen ah oh o, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Anih mah amya pangato a qoih moe, nihcae to Faro khaeah caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faro mah anih ih amyanawk to lokdueng, Tih tok maw na sak o? tiah a naa. Nihcae mah Faro khaeah, Na tamnanawk loe kam pa mah sak ih tok baktih toengah, tuu toep kami ah ka oh o, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nihcae mah Faro khaeah, Kanaan prae ah khokhahaih nung parai moe, pacah ih moinawk caak han ahmuen om ai boeh pongah, hae prae ah khosak hanah kang zoh o; to pongah vaihi na tamnanawk hae Goshen prae ah na omsak ah, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faro mah Joseph khaeah, Nam pa hoi nam yanawk loe nang khaeah angzoh o boeh. ");
INSERT INTO cekak_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Izip prae loe na hmaa ah ni oh; prae thung ih kahoih koek ahmuen ah nam pa hoi nam yanawk to omsak ah; Goshen prae ah om o nasoe; nihcae thungah hmuenmae sak kophaih tawn kami om nahaeloe, kai ih maitaw khenkung ah suem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","To pacoengah Joseph mah ampa to zaeh moe, Faro to patuek; Jakob mah Faro tahamhoihaih paek. ");
INSERT INTO cekak_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faro mah Jakob khaeah, Saning nazetto maw na oh boeh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob mah Faro khaeah, Kai loe angvin ah ka ohhaih saning cumvai, qui thumto oh boeh; ka hinghaih saning loe tamsi vop, toe raihaih paroeai ka tongh; angvin ah kaom kam panawk khosakhaih saning to ka pha ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","To pacoengah Jakob mah Faro to tahamhoihaih paek moe, a caehtaak. ");
INSERT INTO cekak_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph mah ampa hoi amyanawk Izip prae ah ohsak moe, Faro ih lokpaekhaih baktih toengah, kahoih koek prae, Ramses ahmuen to a paek. ");
INSERT INTO cekak_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph mah angmah ih ampa, amyanawk hoi ampa ih imthung takohnawk boih, kaom kami zetto caaknaek to a paek. ");
INSERT INTO cekak_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Khokha nung parai pongah, prae thung boih ah buh to om ai boeh; Izip prae hoi Kanaan prae doeh zaek sut boeh. ");
INSERT INTO cekak_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Izip hoi Kanaan prae thung ih cang qanhaih phoisa loe Joseph mah patung boih moe, Faro im ah thak pae. ");
INSERT INTO cekak_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Izip prae hoi Kanaan prae ah phoisa boeng naah loe, Izip kaminawk boih Joseph khaeah angzoh o moe, caak hanah buh na paek ah, phoisa ka tawn o ai boeh, to pongah na hmaa ah maw ka duek o han boeh? tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","To naah Joseph mah, Phoisa na tawn o ai boeh nahaeloe, maitaw to sin oh, maitaw zuengah cang to kang paek o han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","To pongah nihcae mah Joseph khaeah maitaw to sinh o; anih mah hrang, tuu, maeh, maitaw hoi laa hrangnawk to cang hoiah alaih pae; to na saning loe nihcae ih maitaw hoiah cang to alaisak boih. ");
INSERT INTO cekak_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","To saning to boeng pacoeng amlaa ah loe, anih khaeah, phoisa ka tawn o ai boeh, tito ka angraeng na hmaa ah kang phat o ai boeh; kaicae ih maitawnawk doeh nang khaeah ni oh boih boeh, ka angraeng mikhnuk ah kaimacae ih takpum hoi lawknawk khue ai ah loe, tidoeh ka tawn o ai boeh. ");
INSERT INTO cekak_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Na hmaa ah ka duek o moe, prae doeh kam ro o sak han boeh maw? Kaimacae hoi ka lawknawk hae cang hoiah qan ah; lawk hoi kaimacae hae Faro ih tamna ah ka oh o halat han boeh; ka hing o moe, prae angqai krang hanah ka duek o han ai ah, cang to na paek ah, tiah a hnik o let bae. ");
INSERT INTO cekak_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","To pongah Joseph mah Faro hanah Izip prae ih lawknawk to qan pae boih; khokhahaih nung parai boeh pongah, Izip kaminawk loe lawk to zawh o boih; to pongah lawknawk loe Faro ih lawk ah angcoeng boih. ");
INSERT INTO cekak_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Izip prae boenghaih maeto bang hoi maeto bang khoek to kaminawk to vangpui ah angpuensak. ");
INSERT INTO cekak_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Toe qaimanawk ih lawk loe qan pae ai; qaimanawk loe Faro khae hoi caaknaek khawt ah hnuk o; Faro mah nihcae han caaknaek khawt ah paek pongah, lawk to zaw o ai. ");
INSERT INTO cekak_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph mah prae kaminawk khaeah, Khenah, vaihi nangcae ih lawk Faro han ka qan pae boeh, hae ih cangtii hae la oh loe, lawk ah tuh oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Toe cang na aah o naah pangato thungah maeto Faro han paek oh; kalah palito loe nangmacae han la oh loe, lawk ah tuh oh; nangmacae, na imthung takoh hoi na caanawk mah caak hanah cang to la oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nihcae mah, Kaicae hinghaih nang pahlong; ka angraeng na mikcuk naakrak ah ka oh o nahaeloe, Faro ih tamna ah ka oh o halat han boeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","To pongah qaimanawk ih lawk khue ai ah loe, Faro mah pangato thung ah maeto la nasoe, tiah Joseph mah sak ih lawk tawnkung nuiah lok takroekhaih to Izip prae thungah vaihni ni khoek to patoh o. ");
INSERT INTO cekak_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israelnawk loe Izip prae Goshen ah oh o; to prae to toep o moe, qoeng o tahang pacoengah, paroeai pung o. ");
INSERT INTO cekak_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jokob loe Izip prae thungah saning hatlai sarihto oh, a hinghaih saning loe sangqum boih ah cumvai qui pali, sarihto phak. ");
INSERT INTO cekak_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israel duek tom naah, a capa Joseph to kawk moe, anih khaeah, Na mikcuk naakrak ah ka oh nahaeloe, na ban to ka phaih tlim ah hawt ah loe, tahmenhaih hoi palungthin tang hoiah kai hoi nawnto lokkamhaih sah ah; tahmenhaih hoi kai hae Izip prae ah na phum hmah; ");
INSERT INTO cekak_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","kai loe kam panawk khaeah ni kang song han, Izip prae thung hoiah na phaw ah loe, nihcae aphumhaih ahmuen ah na phum ah, tiah a naa. Anih mah, Na thuih ih baktih toengah ka sak han hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Anih mah, Kai khaeah lokkamhaih sah ah, tiah a naa. To naah Joseph mah anih khaeah lokkamhaih to a sak; Israel loe angmah iihkhum lu bang ah lu akuep tathuk. ");
INSERT INTO cekak_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Atue nasetto maw oh pacoengah, Nam pa loe ngannat, tiah Joseph khaeah thuih pae o; to pongah a caa Manasseh hoi Ephraim to kawk moe, a caeh haih. ");
INSERT INTO cekak_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jakob khaeah, Na capa Joseph nang khaeah angzoh, tiah thuih pae o; to naah Israel loe tha pathok moe, a iih haih ahmuen ah anghnut. ");
INSERT INTO cekak_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakob mah Joseph khaeah, Kanaan prae Luz vangpui ah Thacak Sithaw kai khaeah angphong moe, tahamhoihaih ang paek, ");
INSERT INTO cekak_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","anih mah kai khaeah, Khenah, athaih kang thaisak moe, kang pungsak han, kami pop parai acaeng ah kang sak moe, angzo han koi na caanawk khaeah, hae prae hae dungzan ah toep hanah kang paek han, tiah ang naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Kai haeah kang zo ai naah Izip prae ah na sak ih na caa Manasseh hoi Ephraim loe ka caa ah ni om hoi tih; Reuben hoi Simeon baktih toengah, nihnik loe ka caa ah om hoi tih. ");
INSERT INTO cekak_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","To pacoengah na sak ih na caa loe nangmah ih hmuen ah om tih, a toep o han koi qawknawk loe angmah ih nawkamya ahmin hoiah nawnto kroek o hmaek tih. ");
INSERT INTO cekak_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Padan hoiah kang zoh, Kanaan prae thungah ka caeh li moe, Ephrath vangpui to phak tom naah, nam no Rachel loe ka taengah duek; to pongah anih to Bethlehem, tiah thuih ih, Ephrath caehhaih loklam ah ka phum sut, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel mah, Joseph ih caanawk hnuk naah, Mi hnik aa? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph mah ampa khaeah, Sithaw mah hae prae ah ang paek ih ka caa hnik ni, tiah a naa. Israel mah, tahamhoihaih paek hanah, ka taengah angzo haih ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel loe mitong boeh pongah a mik tha om ai boeh, to pongah kho hnu thai ai boeh; Joseph mah a caa hnik to anih khaeah caeh haih, ampa mah nihnik to mok moe, takop. ");
INSERT INTO cekak_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel mah Joseph khaeah, Na mikhmai hnuk han ka poek ai boeh, khenah, Sithaw mah vaihi na caa hnik to ang hnuksak boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph mah a caa hnik to ampa ih khokhu salakah suek moe, long ah lu takhumsak. ");
INSERT INTO cekak_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph mah nihnik to lak moe, Ephraim to a bantang ban hoi patawnh pacoengah, ampa ih bangqoi bangah a suek, Manasseh to a banqoi ban hoiah patawnh moe, ampa ih bantang bangah a suek. ");
INSERT INTO cekak_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Manasseh loe calu ah oh, toe Israel mah palunghahaih hoiah a ban to payuengh moe, a bantang ban to Ephraim ih lu ah koeng pacoengah, a banqoi ban to Manaaseh ih lu ah a koeng. ");
INSERT INTO cekak_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Joseph to tahamhoihaih a paek, Kam pa Abraham hoi Issak mah bok ih Sithaw, ka hing thung vaihni ni khoek to kai khenzawnkung Sithaw, ");
INSERT INTO cekak_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","zit kathok raihaih congca thung hoi kai pahlongkung van kami mah, hae ih nawkta hnik hae tahamhoihaih paek nasoe; nihnik loe kai ih ahmin, kam pa Abraham hoi Issak ih ahmin to phui o nasoe, long ah pop parai ah pung o nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ampa mah Ephraim nuiah bantang ban to koeng pae, tiah Joseph mah hnuk naah ampa nuiah palung hoih ai; to pongah Ephraim lu ih ampa ih ban to lak moe, Manasseh ih lu nuiah koeng pae. ");
INSERT INTO cekak_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph mah ampa khaeah, Pa, to tih na ai ni; anih loe calu ni, to pongah anih lu nuiah na bantang ban to koeng ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Toe ampa mah angmaak pae; Ka panoek, ka capa, ka panoek; anih doeh kami ah angcoeng ueloe, paroeai len tahang tih; toe amnawk loe anih pongah len kue tih, anih ih caanawk loe pop parai acaeng ah angcoeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nang loe Sithaw mah Ephraim hoi Manasseh baktih toengah omsak nasoe, Israel caanawk loe nang rang hoiah tahamhoihaih hnu o tih, tiah to na niah nihcae to tahamhoihaih a paek; to tiah Ephraim to Manasseh hmaa ah suek lat. ");
INSERT INTO cekak_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","To pacoengah Israel mah, Joseph khaeah, Kai loe ka duek han boeh; toe Sithaw mah na om haih ueloe, nam panawk ih prae ah na hoi let tih. ");
INSERT INTO cekak_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Toe sumsen hoi kalii hoiah Amor kaminawk khaeah ka lak ih kahoih prae loe nam yanawk han ih na ai ah, nang han ih ni kang paek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","To pacoengah Jakob mah a capanawk to kawk moe, hmabang angzo han koi hmuen kang thuih o han pongah, ahmuen maeto ah amkhueng oh. ");
INSERT INTO cekak_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Jakob ih caanawk, nawnto amkhueng oh loe, nam Pa Israel ih lok hae tahngai oh. ");
INSERT INTO cekak_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, nang loe ka calu, ka thacakhaih, ka tha oh tangsuekhaih, saiqathaih hoi sakthaihaih sang koek ah na oh. ");
INSERT INTO cekak_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tui baktiah nang phui pongah, na hoihhaih om mak ai boeh; nam pa iihhaih nuiah na dawh moe, ka iihhaih to nam hnongsak. ");
INSERT INTO cekak_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon hoi Levi loe nawkamya ah oh moe, sumsen hoiah kasae sakhaih ahmuen ah a oh hoi. ");
INSERT INTO cekak_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Aw ka hinghaih, nihnik mah tamquta hoi sak ih ahmuen ah na thumsak hmah, kai pakoehhaih loe nihcae amkhuenghaih ahmuen ah na thumsak hmah; nihnik loe palungphuihaih hoiah kami to hum hoi moe, a koeh hoi ih baktiah vangpui tapang to paro hoi. ");
INSERT INTO cekak_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nihnik loe palungphui hoi, poek amthueng hoi moe, palungduemh hoi pongah kasae zok hoi nasoe! Jakob acaeng thungah nihnik to ka tapraek moe, Israel acaeng thungah kam hetsak phang han. ");
INSERT INTO cekak_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah, nang loe nam yanawk mah pakoeh o tih; na ban loe misanawk ih tahnong nuiah om tih; nam pa ih caanawk loe na hmaa ah akuep o tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Aw Judah, nang loe kanawk kaipui ah na oh, ka capa, nang loe moi kaekhaih ahmuen hoiah nang zoh tahang moe, na tabok; kaipui baktih, kaipui amno baktih toengah avah; mi mah maw anih to pathawk thai tih? ");
INSERT INTO cekak_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Shiloh pha ai karoek to tayae toeng loe, Judah khae hoi amhoe mak ai ueloe, a ukhaih cunghet doeh a khok salak hoiah takhoe mak ai; kaminawk loe anih khaeah ni amkhueng o tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Misurkung pongah angmah ih hrang to paeh ueloe, laa hrang caa to kahoih koek misurkung pongah paeh tih; angmah ih khukbuen to misurtui hoi pasuk ueloe, angmah ih laihawnawk doeh misurtui hoiah pasuk tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Anih ih mik loe misurtui hoi thim ueloe, a ha doeh maitaw tahnutui hoiah anglung tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun loe tuipui taengah om ueloe, palongpui anghakhaih ahmuen ah om tih; anih ih ramri loe Sidon karoek to kawk tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar loe mae salakah tabok thacak laa hrang ah oh; ");
INSERT INTO cekak_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","anghakhaih ahmuen kahoih to a hnuk moe, prae kahoih to a hnuk pongah, angmah ih palaeng nuiah hmuen to koeng ueloe, tamut paek tamna ah om tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan loe Israel ih acaeng maeto ah oh baktih toengah, angmah ih kaminawk to lokcaek tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan loe loklam ah kaom pahui ah om ueloe, hrang angthueng kami to hnuk angnawnsak hanah, hrang khok tahmawh patuk pahui sae ah om tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Aw Angraeng, na pahlonghaih to ka zing. ");
INSERT INTO cekak_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Misanawk mah Gad to tuh o tih, toe anih mah nihcae to tuh let ueloe, hnukkhuem ah pazawk tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher ah caaknaek kahoih tacawt tih, siangpahrang paek koi caaknaek to tacawt tih. ");
INSERT INTO cekak_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali loe angmah koeh baktiah kaom tasuk, kranghoih caa sahkung tasuk ah oh. ");
INSERT INTO cekak_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph loe thacak thingkung, tui taengah kaom thingkung ah oh; anih ih tanghangnawk loe tapang ranui khoek to amzam. ");
INSERT INTO cekak_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kalii kaat kop kaminawk mah anih to paroeai raihaih paek o, hnukma o moe, a kah o; ");
INSERT INTO cekak_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","toe anih ih kalii loe thazok ai; anih ih ban tampawk loe Jakob Sithaw ih ban thacakhaih rang hoiah, (tuutoep kami ah kaom, Israel ih lungsong ah oh;) ");
INSERT INTO cekak_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","nang loe nang bomkung, nam pa ih Sithaw rang hoiah nang han van ranui hoi tahamhoihaih paekkung, Sithaw rang hoiah tha na cak; atlim ah kaom kathuk tahamhoihaih, tahnutui hoi caa im tahamhoihaih mah nang han tahamhoihaih paek nasoe; ");
INSERT INTO cekak_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","nam pa mah paek ih tahamhoihaih loe, canghni ah mae nui ih tahamhoihaih, dungzan maesomnawk nuiah kaom kahoih hmuennawk pongah doeh len kue; to tahamhoihaih loe Joseph ih lu nuiah om nasoe loe, amyanawk hoi kamhoe ah kaom kami ih lu nuiah om nasoe. ");
INSERT INTO cekak_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin loe kalomh thaih tasui ah oh; anih loe khawnthaw ah moi to kaek ueloe, aqum ah a lomh ih hmuen to tapraek tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hae kaminawk loe Isreal acaeng hatlai hnetto ah oh o, ampa mah nihcae khaeah thuih pae ih lok loe hae tiah oh; ampa mah nihcae hak han koi tahamhoihaih to paek boih. ");
INSERT INTO cekak_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","To pacoengah nihcae khaeah hae tiah lokthuih pae; Kai loe kaimah ih kaminawk amkhuenghaih ahmuen ah ka caeh han boeh; Hit kami Ephron ih lawk thungah kaom thlungkhaw thungah kam panawk hoi nawnto na phum oh, ");
INSERT INTO cekak_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","to thlungkhaw loe Kanaan prae, Mamre vangpui pha ai naah, Makpelah ahmuen ah oh moe, Abraham mah Hit kami Ephron khaeah, lawk hoi nawnto taprong sak hanah a qanh. ");
INSERT INTO cekak_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham hoi a zu Sarah, Issak hoi a zu Rebakah loe to ahmuen ah aphum o; Leah doeh to ahmuen ah ka phum. ");
INSERT INTO cekak_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Lawk hoi thlungkhaw loe, Hit kaminawk khaeah ni ka qanh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","A caanawk khaeah lokthuih boih pacoengah, Jakob loe a iihhaih ahmuen ah a khok to azuh tahang, hinghaih qui apet pacoengah, angmah ih kaminawk amkhuenghaih ahmuen ah angkuem. ");
INSERT INTO cekak_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","To pacoengah Joseph loe ampa nuiah tabok moe, qah pacoengah a mok. ");
INSERT INTO cekak_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","To pacoengah Joseph mah tasi sah kop a tamnanawk khaeah ampa ih qok to tasi pazut hanah thuih pae; tasi sah kop kaminawk mah Israel to tasi hoiah pazut o. ");
INSERT INTO cekak_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Anih ih qok to tasi hoiah pazut hanah, ni qui palito akra; ni akoep pacoengah Izip kaminawk mah anih to ni qui sarihto thung qah o haih. ");
INSERT INTO cekak_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Qahhaih ni boeng pacoengah, Joseph mah Faro imthung takohnawk khaeah, Nangcae mikcuk naakrak ah ka oh nahaeloe, Faro khaeah na thui pae oh, ");
INSERT INTO cekak_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","kam pa mah, Khenah, ka duek tom boeh, ka duek naah Kanaan prae ah kaimah han takaeh ih taprong ah na phum ah, tiah lok ang kamsak. To pongah vaihi kam pa aphum hanah ka caeh moe, aphum pacoengah kam laem let han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faro mah, Lok ang kamsak baktih toengah, caeh tahang ah loe nam pa to aphum ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","To pongah Joseph loe ampa aphum hanah caeh tahang; Faro ih tamnanawk boih, anih im ih kacoehtanawk hoi Izip prae ih kacoehtanawk boih anih hoi nawnto caeh o, ");
INSERT INTO cekak_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Joseph imthung takohnawk, angmah ih amyanawk hoi ampa imthung takoh boih a caeh o; a caanawk, tuunawk hoi maitawnawk khue ni Goshen ah a caeh o taak. ");
INSERT INTO cekak_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Hrang leeng hoi hrang angthueng kaminawk doeh anih hoi nawnto caeh o; to pongah kami paroeai pop o. ");
INSERT INTO cekak_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Jordan vapui taengah kaom, Atad ih cang atithaih ahmuen to phak o naah, nihcae loe tha hoi qah o; Joseph mah ampa to ni sarihto thung qah haih. ");
INSERT INTO cekak_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","To naah Kanaan prae thungah kaom kaminawk mah Atad cang atithaih ahmuen ih kaqah kaminawk to hnuk o naah, nihcae mah, Izip kaminawk loe paroeai qah o, tiah thuih o. To pongah Jordan vapui taeng ih to ahmuen to, Abel Mizraim, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jakob ih caanawk loe ampa mah thuih pae ih lok baktih toengah sak o. ");
INSERT INTO cekak_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","A capanawk mah anih ih qok to Kanaan prae ah caeh o haih moe, Abraham mah Hit kami, Ephron khaeah taprong sak hanah qan ih, Mamre vangpui pha ai naah kaom, Makpelah lawk ih thlung khaw thungah aphum o. ");
INSERT INTO cekak_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ampa aphum o pacoengah, Joseph loe Izip prae ah amlaem let, anih loe angmah ih amyanawk, ampa aphum han caeh kaminawk boih hoi nawnto amlaem let. ");
INSERT INTO cekak_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Joseph ih amyanawk mah ampa duek boeh ti, tiah panoek o naah, nihcae mah, Anih nuiah a sak o ih kasae hmuen pongah, Joseph mah aicae hae hnuma ueloe, aicae nuiah kasae hmuen hoi pathok tih boeh, tiah a poek o. ");
INSERT INTO cekak_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","To pongah Joseph khaeah kami to patoeh o moe, Nam pa mah dueh ai naah kaicae khaeah hae tiah lok ang thuih, ");
INSERT INTO cekak_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Joseph khaeah, Nam yanawk mah na nuiah sak o ih zaehaih hoi sakpazaehaih boih to tahmen ah, tiah nam pa mah tahmenhaih hnik, tiah thui pae oh; nihcae mah na nuiah sak o ih zaehaih hoi nam pa ih Sithaw, anih ih tamnanawk mah sak o ih zaehaih to tahmen ah, tiah ang thuisak, tia a naa o. Nihcae mah thuisak ih hae lok to a thuih pae naah, Joseph loe qah. ");
INSERT INTO cekak_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Amyanawk loe anih hmaa ah caeh o moe, a hmaa ah akuep o; khenah, kaicae loe na tamna ah ni ka oh o boeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Toe Joseph mah nihcae khaeah, Zii o hmah; toe kai loe Sithaw angdoethaih ahmuen ah maw ka oh? ");
INSERT INTO cekak_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nangcae mah kai hum hanah na poek o; toe vai hniah kaom hmuen baktih toengah Sithaw mah loe pop parai kaminawk hinghaih to pahlong hanah kho a khan. ");
INSERT INTO cekak_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","To pongah zii o hmah; nangmacae hoi na caanawk boih kang kok o han hmang, tiah a naa. Nihcae to patloep moe, lok kanaem hoiah tapring. ");
INSERT INTO cekak_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph loe ampa imthung takohnawk boih hoi nawnto Izip prae thungah khosak; Joseph loe saning cumvaito pacoeng, hato hing. ");
INSERT INTO cekak_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph loe a caa dung thumto haih, Ephraim ih caanawk to hnuk; Manasseh capa Makir ih caanawk loe Jospeh ih khokhu nuiah tapensak. ");
INSERT INTO cekak_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","To naah Joseph mah amyanawk khaeah, Kai loe ka duek han boeh; toe nangcae abomh hanah Sithaw angzo ueloe, hae prae thung hoiah Abraham, Issak hoi Jakob khaeah paek han lokkam ih prae thungah na hoi o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Joseph mah Israel ih caanawk to lokkamsak, Nangcae abomh hanah Sithaw angzo tih, to naah hae prae thung hoiah kai ih ahuh hae sin oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","To pongah Joseph loe saning cumvaito pacoeng, hato phak naah duek; anih ih qok to kaqong thai ai tasi pazut o pacoengah, Izip prae ah thingkhong thungah pasong o. ");
INSERT INTO cekak_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Jakob hoi Izip prae ah kalaem imthung takoh Israel kaminawk boih ih ahmin loe, ");
INSERT INTO cekak_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, Judah, ");
INSERT INTO cekak_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zebulun, Benjamin, ");
INSERT INTO cekak_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad hoi Asher. ");
INSERT INTO cekak_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jakob ih caanawk loe sangqum boih ah qui sarihto oh o; Joseph loe Izip prae ah oh hmaloe. ");
INSERT INTO cekak_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph hoi anih ih amyanawk, to nathuem ah kaom kaminawk doeh duek o boih. ");
INSERT INTO cekak_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Israel kaminawk loe caa sak o, paroeai pop o; pung o moe, thacak o parai. ");
INSERT INTO cekak_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","To pacoengah Joseph panoek ai kangtha siangpahrang mah Izip prae to uk. ");
INSERT INTO cekak_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Anih mah angmah ih kaminawk khaeah, Khen oh, Israel kaminawk loe pop o parai moe, aicae pongah thacak o boeh. ");
INSERT INTO cekak_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Angzo oh; nihcae hae palunghahaih hoiah tamet si, to tih ai nahaeloe nihcae loe pop o aep aep tih boeh; misa angtukhaih om nahaeloe, nihcae loe aicae ih misanawk khaeah ni athum o tih, aicae hae tuh o ueloe, aicae prae hae caeh o taak sut tih, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","To pongah nihcae pacaekthlaek hanah hmawsaeng ukkungnawk to suek o. Faro ih hmuenmae patunghaih vangpui, Pithom hoi Raamses to nihcae hanah saksak. ");
INSERT INTO cekak_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nihcae to paroeai pacaekthlaek o, toe nihcae loe pung o moe, qoeng o tahang aep aep; Israel kaminawk loe Izip kaminawk pongah paroeai palung boeng o. ");
INSERT INTO cekak_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Izip kaminawk loe tahmenhaih tawn ai ah Israel caanawk to toksak o sak; ");
INSERT INTO cekak_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Izip kaminawk mah nihcae to thlung kangphaek lakhaih, amlai long hmai qoenghaih hoi laikok thungah karai parai toknawk to a sak o sak moe, pacaekthlaek o. ");
INSERT INTO cekak_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Izip siangpahrang mah nawkta omsakkung Hebru nongpata hnik, Shiphrah hoi Puah khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Hebru nongpatanawk nawkta ohsak naah, kahoihah khen hoih loe, nongpa nahaeloe hum hoi roep ah, nongpata loe pathlung hoih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Toe nawkta omsakkung Hebru nongpata hnik loe Sithaw to zit hoi pongah, Izip siangpahrang mah thuih ih lok baktih toengah sah hoi ai; caa nongpanawk to pathlung hoi. ");
INSERT INTO cekak_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","To pongah Izip siangpahrang mah nihnik to kawk moe, Tipongah hae tiah tok na sak hoi loe? Tipongah caa nongpanawk to na pathlung hoi loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Nawkta omsakkung hnik mah Faro khaeah, Hebru nongpatanawk loe Izip nongpatanawk baktiah om o ai; nihcae loe thacak o pongah, nawkta omsakkung pha ai naah nawkta tapen o ving boeh, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Sithaw mah nawkta omsakkungnawk nuiah anghoehaih tawnh pongah, kami pung o moe, thacak o. ");
INSERT INTO cekak_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Nawkta omsakkung hnik loe Sithaw to zit hoi pongah, Sithaw mah nihnik khaeah imthong hoi khosakhaih to paek. ");
INSERT INTO cekak_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","To naah Faro mah angmah ih kaminawk khaeah, Tapen caa nongpa to vapui thungah va o boih ah, nongpata loe pathlung o boih ah, tiah lok a paek. ");
INSERT INTO cekak_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","To nathuem ah Levi kami maeto mah, Levi canu to zu ah lak. ");
INSERT INTO cekak_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","A zu loe zokpom moe, caa nongpa maeto sak; a khet naah nawkta loe kranghoih parai; to pongah anih to khrah thumto thung a hawk. ");
INSERT INTO cekak_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Toe hawk thai laek ai naah loe, sakrung kung hoiah sak ih thingkhong maeto a lak moe, tuipan hoi thing tangpri hoiah a bet caeng, nawkta to thingkhong thungah suek moe, vapui taengah a bangh. ");
INSERT INTO cekak_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Anih ih tanuh mah kawbang maw oh, tiah panoek hanah, ahmuen kangthla hoiah khet. ");
INSERT INTO cekak_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Faro canu loe tui amthluk hanah vapui ah caeh tathuk; to naah a tamna nongpatanawk loe tui taengah amkaeh o; anih mah tui taeng ih thingkhong to hnuk naah, a tamna nongpata maeto khaeah laksak. ");
INSERT INTO cekak_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Anih mah thingkhong to paongh naah, nawkta to a hnuk; kaqah nawkta to a hnuk naah, tahmen moe, Hae loe Hebru nawkta bae hae, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","To naah anih ih tanuh mah Faro canu khaeah, Nang han nawkta khenzawnkung Hebru nongpatanawk to kang kawk pae han maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Anih mah, Caeh ah loe, kawk ah, tiah a naa. Tamna nongpata loe caeh moe, nawkta ih amno to kawk. ");
INSERT INTO cekak_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Faro canu mah anih khaeah, Hae nawkta hae la ah loe, kai hanah com ah, atho kang paek han hmang, tiah a naa. To pongah nongpata mah nawkta to lak moe, khetzawn pae. ");
INSERT INTO cekak_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nawkta qoeng tahang naah loe, Faro canu khaeah caeh haih moe, anih ih capa ah angcoeng. Nongpata mah tui thung hoiah ka khuih, tiah a thuih pongah, anih to Mosi, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mosi qoeng tahang naah loe, angmah ih acaeng nawkamyanawk toksakhaih ahmuen ah caeh; to nathuem ah nihcae loe karai parai tok a sak o, tiah Mosi mah hnuk; to naah Izip kami maeto mah anih ih nawkamya Hebru kami to boh. ");
INSERT INTO cekak_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ahnuk ahmaa a khet naah, mi doeh hnu ai pongah, Izip kami to a hum moe, savuet thungah aphum. ");
INSERT INTO cekak_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Khawnbang ni hnetto naah a caeh let, to naah kangpanh Hebru kami hnik to a hnuk let bae; anih mah hmuen sah pazae kami khaeah, Tipongah nam pui Hebru kami to na boh loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","To kami mah, Mi mah maw nang hae kaihnik ukkung hoi lokcaekkung ah suek? Izip kami na hum baktih toengah, kai doeh hum han nang patoem maw? tiah a naa. Mosi mah to lok to thaih naah tasoeh moe, Ka sak ih hmuen angphong tih boeh, tiah poek. ");
INSERT INTO cekak_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Faro mah to kawng to thaih naah Mosi to hum hanah pakrong. Toe Mosi loe Faro hmaa hoiah cawnh moe, Midian prae ah khosak; to ah tui khaw taengah anghnut. ");
INSERT INTO cekak_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midian prae ih qaima loe canu sarihto tawnh; anih ih canunawk loe tuidok hanah tui khaw ah caeh o moe, ampa ih tuunawk to tui a paek o. ");
INSERT INTO cekak_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","To naah tuu toep kaminawk to angzoh o moe, tuunawk to huih pae o ving; toe Mosi mah angdoet moe, nongpatanawk to angsak haih pacoengah, tuunawk to tui a naeksak. ");
INSERT INTO cekak_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Tanglanawk loe ampa, Reuel khaeah amlaem o let, to naah ampa mah tikhoe vaihni loe nam laem o palang takan loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","To naah nihcae mah, Izip kami maeto mah tuu toep kaminawk ih ban thung hoiah ang pahlong pongah kam laem o palang, anih mah ni tui dok moe, tuunawk doeh tui a paek, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","To naah anih mah a canunawk khaeah, Anih loe naa ah maw oh? Tikhoe na caeh o taak sut loe? Buhcaak han kawk o khae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mosi loe to kami ih im ah oh han koeh pongah, ampa mah a canu Zipporah to Mosi hanah zu ah paek. ");
INSERT INTO cekak_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipporah mah anih han caa nongpa maeto sak pae, Minawk prae ah angvin ah ka oh, tiah a thuih pongah, Gershom, tiah ahmin phui. ");
INSERT INTO cekak_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","To tiah atue kasawk ah oh na thungah, Izip siangpahrang to duek; Israel kaminawk loe misong ah ohhaih to anghmawt o sut boeh pongah, a qah o; misong ah kaom kaminawk qahhaih lok to Sithaw mah thaih pae. ");
INSERT INTO cekak_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nihcae hanghaih lok Sithaw mah thaih naah, Abraham, Issak hoi Jakob khaeah sak ih lokkamhaih to a poek let. ");
INSERT INTO cekak_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","To pongah Sithaw mah Israel kaminawk to khet tathuk moe, nihcae han kho poek pae. ");
INSERT INTO cekak_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosi loe Midian kami qaima, amsae Jethro ih tuu to toep pae; praezaek taeng ih mae ah tuunawk to a toep moe, Sithaw ih mae Horeb ahmuen ah a phak. ");
INSERT INTO cekak_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","To ah Angraeng ih van kami to hmai kangqong aqam kabuk thing thung hoiah anih khaeah angphong; Mosi mah khet naah, kabuk thing loe hmai angqong, toe thing loe hmai mah kangh ai tito a hnuk. ");
INSERT INTO cekak_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","To pongah Mosi mah, Tipongah kabuk thing loe hmai mah kang ai loe! Kalen parai kamtueng hmuen hae ka khet noek han, tiah a poek. ");
INSERT INTO cekak_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","To tiah kaom hmuen to Mosi mah caeh moe, khet, tiah Angraeng mah hnuk naah, Sithaw mah anih to aqam kabuk thing thung hoiah Mosi! Mosi! tiah kawk. ");
INSERT INTO cekak_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Sithaw mah, Haeah anghnai hmah; na khokpanai to angkhring ah; nang doethaih ahmuen loe hmuenciim ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","To pacoengah, Kai loe nam pa ih Sithaw, Abraham ih Sithaw, Issak ih Sithaw hoi Jakob ih Sithaw ah ka oh, tiah a naa. Mosi mah Sithaw khet han zit moe, a mikhmai to hawk ving. ");
INSERT INTO cekak_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Angraeng mah, Izip prae ah kaom kai ih kaminawk patangkhanghaih to ka hnuk boeh; misong tawnkungnawk mah pacaekthlaek o pongah, a qah o haih lok to ka thaih boeh; nihcae palungsethaih to ka panoek. ");
INSERT INTO cekak_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Izip kaminawk ban thung hoiah nihcae to ka pahlong moe, to prae thung hoiah ka zaeh pacoengah, tahnutui hoi khoitui longhaih, Kanaan prae, Hit, Amor, Periz, Hiv hoi Jebus kaminawk ohhaih prae ah caeh haih hanah, kang hum tathuk boeh. ");
INSERT INTO cekak_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","To pongah, khenah, Israel kaminawk qahhaih lok loe vaihi kai khaeah phak boeh; Izip kaminawk mah nihcae pacaekthlaekhaih doeh ka hnuk boeh. ");
INSERT INTO cekak_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","To pongah vaihi angzo ah, Izip prae thung hoiah kai ih kami, Israel caanawk to zaeh hanah, Faro khaeah kang patoeh han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Toe Mosi mah Sithaw khaeah, Kai loe kawbaktih kami ah maw ka oh moe, Faro khaeah ka caeh pacoengah, Izip prae thung hoiah Israel kaminawk to ka zaeh han loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","To naah Sithaw mah, Kai mah kang oh thuih han hmang! Hae loe nang, kang patoeh boeh, tiah angmathaih ah om tih; Kai ih kaminawk Izip prae thung hoi na zaeh pacoengah loe, hae mae nuiah Sithaw na bok o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mosi mah Sithaw khaeah, Israel kaminawk khaeah ka caeh moe, nihcae khaeah, nangcae ampanawk ih Sithaw mah nangcae khaeah kai ang patoeh, tiah ka thuih pae naah, nihcae mah kai khaeah, Anih ih ahmin loe mi aa? tiah na dueng o nahaeloe, kawbang maw ka thuih pae han loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Sithaw mah Mosi khaeah, KAI LOE KAI NI, tiah Israel kaminawk khaeah thui paeh; KAI, tiah ahmin kaom mah, nangcae khae ah kai ang patoeh, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","To pacoengah Sithaw mah Mosi khaeah, Israel kaminawk khaeah, Nam panawk ih Angraeng Sithaw, Abraham Sithaw, Issak Sithaw hoi Jakob Sithaw mah nangcae khaeah kai ang patoeh, hae loe dungzan ah kaom Kai ih ahmin ah oh, angzo han koi kaminawk boih mah pahnet thaih han ai ih ahmin ah oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Caeh ah, Israel kacoehtanawk to nawnto pakhueng ah loe nihcae khaeah, Nam panawk ih Angraeng Sithaw, Abraham, Issak hoi Jakob ih Sithaw to kai khaeah angphong moe, nangcae khaeah kang paqaih, Izip prae ah nangcae nuiah a sak o ih hmuen ka hnuk boeh; ");
INSERT INTO cekak_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Izip prae patangkhanghaih thung hoiah nangcae to kang zaeh moe, Kanaan, Hit, Amor, Periz, Hiv hoi Jebus kaminawk ih prae, tahnutui hoi khoitui longhaih prae thungah kang caeh o haih han, tiah lok ka thuih boeh, tiah thui paeh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Israel kacoehtanawk mah na lok to tahngai o tih; nang hoi Israel kacoehtanawk Izip siangpahrang khaeah caeh oh loe, anih khaeah, Hebru Angraeng Sithaw mah kaicae hae a tongh boeh; kaimacae ih Angraeng Sithaw khaeah, angbawnhaih ka sak o hanah, ni thumto thung praezaek ah na caehsak ah, tiah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Toe Izip siangpahrang loe kalen parai thacakhaih hnu ai ah loe, nangcae to caehsak mak ai, tito ka panoek. ");
INSERT INTO cekak_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","To pongah ban ka payangh moe, Izip prae thungah dawnrai hmuennawk to ka sak boih han, to tiah prae to ka thuitaek han; to pacoengah ni Izip siangpahrang mah na caeh o sak vop tih. ");
INSERT INTO cekak_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Izip kaminawk mah hae kaminawk palung o thai hanah, tok ka sak han; to naah ni na tacawt o naah bangkrai ah na tacawt o mak ai; ");
INSERT INTO cekak_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","nongpata boih mah a imtaeng kami, a im ah kaom nongpatanawk hanah phoisa, sui hoi khukbuennawk to hni o ueloe, na capanawk hoi na canunawk to abuen o sak tih; to tiah Izip kaminawk ih hmuennawk to na la pae o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosi mah, Toe, khenah, nihcae mah kai na tang o ai moe, ka lok tahngai ai ah, nang khaeah Angraeng angphong ai, tiah na naa o nahaeloe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","To naah Angraeng mah, anih khaeah, Na ban ah timaw na tawnh? tiah a naa. Anih mah, Cunghet, tiah pathim pae. ");
INSERT INTO cekak_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Angraeng mah, Long ah va tathuk ah, tiah a naa. Mosi mah cunghet to long ah vah tathuk naah, pahui ah angcoeng, to naah Mosi mah cawnhtak ving. ");
INSERT INTO cekak_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Angraeng mah, anih khaeah, Na ban to payangh loe, tamai ah naeh ah, tiah a naa. To pongah Mosi mah a ban to payangh moe, pahui to naeh, to naah a ban pongah cunghet ah angcoeng let. ");
INSERT INTO cekak_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Angraeng mah, To tiah na sak nahaeloe ampanawk ih Angraeng Sithaw, Abraham Sithaw, Isaak Sithaw, Jakob Sithaw loe nang khaeah angphong tangtang, tiah tanghaih tawn o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","To pacoengah Angraeng mah, Vaihi laihaw thungah na ban to tapawh ah, tiah a naa. Mosi mah laihaw thungah a ban to tapawh; khenah, a ban azuh let naah, a ban loe dantui baktih kanglung, ngansae ah angcoeng. ");
INSERT INTO cekak_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Laihaw thungah na ban to tapawh let ah, tiah a naa. To pongah Mosi mah laihaw thungah a ban to tapawh let; a ban to lak let naah, khenah, a ban loe angmah ih ngan baktih toengah oh let. ");
INSERT INTO cekak_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","To pacoengah Angraeng mah, Nang to tang o ai moe, kaom hmaloe ih angmathaih to tang o ai cadoeh, hnukkhuem ih angmathaih loe nihcae mah tang o tih. ");
INSERT INTO cekak_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Toe vai hnetto haih angmathaih to ni nihcae mah tang o ai moe, na lok to tahngai o ai nahaeloe, Vapui ih tui to doh ah loe, karoem long ah krai ah; to naah vapui ah na dok ih tui to karoem long nuiah athii ah angcoeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mosi mah Angraeng khaeah, Aw Angraeng, kai loe lok ka thui thai ai; canghniah, na tamna khaeah lok nang thuih pacoengah doeh, lok hae ka thui thai ai; ka lok hae tongaah moe, lok ka pae thai ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Angraeng mah anih khaeah, Kami ih pakha, to tih ai boeh loe lokaa hoi naapang, to tih ai boeh loe kamtueng mik hoi mikmaeng to mi mah maw sak? Kai, Angraeng mah na ai maw sak? ");
INSERT INTO cekak_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","To pongah vaihi caeh ah, na pakha ah Ka oh moe, timaw thuih han tito kang patuk han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Toe Mosi mah, Aw Angraeng, minawk kalah patoeh halat ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","To naah Mosi nuiah Angraeng palungphui moe, Levi kami, nam ya Aaron oh maw? Anih loe lokthuih thaih, tiah ka panoek. Khenah, anih loe nang tongh hanah loklam ah angzoh li vop; anih mah nang to hnuk naah anghoe tih. ");
INSERT INTO cekak_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Anih hoi lok aram hoiah loe, a thuih han koi lok to thui paeh; kai loe na pakha hoi anih ih pakha ah ka oh moe, na sak hoi han koi hmuen to kang patuuk han. ");
INSERT INTO cekak_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Anih loe kaminawk hmaa ah nang han lokthui kami ah om tih; anih loe na pahni zuengah om ueloe, nang doeh anih han Sithaw zuengah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Dawnrai angmathaih hmuennawk na sak hanah, hae cunghet hae na ban ah sin ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mosi loe amsae Jethro khaeah amlaem moe, anih khaeah, Izip prae ah kaimah ih nawkamyanawk hing o vop maw, tiah khet hanah, na caehsak raeh, tiah a naa. Jethro mah, Lunghoihta hoi caeh ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Midian prae ah oh naah, Angraeng mah Mosi khaeah, Izip prae ah caeh let ah, na hinghaih pakrong kaminawk loe duek o boih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","To pongah Mosi mah a zu hoi a capanawk to kawk moe, Laa hrang pongah angthuengsak, Sithaw ih cunghet to a ban ah sin moe, Izip prae ah amlaem let. ");
INSERT INTO cekak_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Angraeng mah Mosi khaeah, Izip prae ah nam laem let naah, Na ban ah kang suek ih dawnrai hmuennawk to Faro hmaa ah sah paeh; toe anih mah Israel kaminawk caehsak han ai ah, anih ih palung to kam taksak han. ");
INSERT INTO cekak_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","To naah Faro khaeah, Angraeng mah, Israel loe ka capa hoi ka calu ah oh; ");
INSERT INTO cekak_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ka capa mah ka tok to sak hanah, prawt ah, tiah lok kang thuih; to tiah na prawt ai nahaeloe, na capa, na calu to ka hum han, tiah thui paeh, tiah Mosi khaeah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","A ohhaih im loklam ah caeh naah, Angraeng mah Mosi to hnuk moe, anih to hum hanah patoem. ");
INSERT INTO cekak_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Toe Zipporah mah thlung kanoe to lak moe, a capa ih tangzat hin to aah pacoengah, Mosi khokkung ah akuep moe, Nang loe athii kalong ka sava ah na oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","To pongah Angraeng mah Mosi to loihsak; tangzat hin aahhaih athii pongah ni, a zu mah nang loe athii kalong ka sava ah na oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Angraeng mah Aaron khaeah, Mosi tongh hanah praezaek ah caeh ah, tiah a naa. To pongah anih loe caeh, Mosi to Sithaw mae ah tongh moe, anih to mok. ");
INSERT INTO cekak_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","To naah Mosi mah Aaron khaeah, Anih patoehkung Angraeng mah thuih ih loknawk boih, a sak han koi dawnrai hmuennawk to a thuih pae boih. ");
INSERT INTO cekak_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mosi hoi Aaron loe caeh hoi moe, Israel kacoehtanawk to kawk boih pacoengah, nawnto amkhuengsak. ");
INSERT INTO cekak_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Angraeng mah Mosi khaeah thuih ih loknawk to Aaron khaeah a thuih pae boih, kaminawk hmaa ah dawnrai hmuennawk doeh a sak pae. ");
INSERT INTO cekak_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","To naah kaminawk mah tang o; Angraeng loe Israel kaminawk khet hanah angzoh, tiah panoek o moe, nihcae patangkhanghaih to a hnuk pae, tiah a thaih o naah, nihcae mah long ah lu akuephaih hoiah bok o. ");
INSERT INTO cekak_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","To pacoengah Mosi hoi Aaron loe Faro khaeah caeh hoi moe, Israel Angraeng Sithaw mah, Praezaek ah kai khae poihsak o hanah, kai ih kaminawk to tacawtsak ah, tiah a thuih, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faro mah, Angraeng ih lok to ka tahngaih moe, Israel kaminawk ka prawt hanah to Angraeng loe mi aa? Angraeng to ka panoek ai, Israel kaminawk doeh ka prawt mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","To naah nihnik mah, Hebru kaminawk ih Sithaw mah kaihnik hae tongh boeh; ni thumto caehhaih praezaek ah, kaimacae ih Angraeng Sithaw khaeah, angbawnhaih sak hanah, na caeh o sak ah; to tih ai nahaeloe kaicae nuiah nathaih maw, to ai boeh loe sumsen hoiah maw na thuitaek moeng tih, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Toe Izip siangpahrang mah nihnik khaeah, Tih hanah hae kaminawk toksak nam pra hoi sak loe? Na sak hoi ih tok to mah sah hoih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","To pacoengah Faro mah, Khenah, prae thungah kami paroeai pop o, toe nihcae khaeah toksak han ai ah na thuih pae hoiah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","To na niah Faro mah tamna khenzawn kaminawk hoi ukkungnawk khaeah, hae tiah lokthuih pae; ");
INSERT INTO cekak_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","amlai long to hmaiqoeng hanah, canghni ah na paek o ih baktiah, kaminawk hanah caphaeh to paek o hma lai ah; angmacae koehah caphaeh to akhuih hanah caeh o nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Toe amlai long hmaiqoenghaih tok loe canghni ah sak ih baktih toengah nihcae to sahsak ah; tamsi o sak hmah; nihcae loe thaset o pongah ni, Sithaw khaeah angbawnhaih sak hanah, na caehsak ah, tiah a hang o. ");
INSERT INTO cekak_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Toksak panki o moe, amsawn loknawk to a tang o han ai ah, nongpanawk to tok karai paek ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","To naah tamna khenzawn kaminawk hoi ukkungnawk loe caeh o moe, kaminawk khaeah, Faro mah, nangcae caphaeh paek han ai ah thuih boeh. ");
INSERT INTO cekak_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Caeh oh loe nangmacae koehah caphaeh to pakrong oh; toe toksak tamsi o sak hmah, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","To pongah kaminawk loe Izip prae ah caeh o moe, caphaeh zuengah anghnoeng to pakrong hanah, Izip prae thung boih ah caeh o. ");
INSERT INTO cekak_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Tamna khenzawn kaminawk mah nihcae to mongh aep aep; caphaeh oh nathuem ah ni thokkruek na sak o ih tok baktih toengah, pacoeng hanah tok to sah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Faro ih tamna khenzawn kaminawk mah, zaehoikung ah suek ih Israel kaminawk khaeah, Tipongah cangduem hoi vaihni na sak o ih, amlai long loe canghni ah na sak o ih zetto pha ai loe? tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","To naah Israel zaehoikungnawk loe Faro khaeah caeh o moe, Tipongah na tamnanawk hae tih khoek to nang pacaekthlaek loe? ");
INSERT INTO cekak_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Na tamnanawk hanah caphaeh paek ai to mah, khenah, ukkungnawk loe kaicae khaeah amlai long sak hanah lok ang thuih o moe, na tamnanawk to boh o; zaehaih loe nangmah ih kaminawk nuiah ni oh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Toe Faro mah, Tha na set o, tha na set o! To pongah ni, Angraeng khaeah angbawnhaih sak hanah na caehsak ah, tiah na thuih o. ");
INSERT INTO cekak_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","To pongah vaihi caeh oh loe, tok to sah oh; caphaeh to kang paek o mak ai boeh; toe amlai long loe na sak o zetto sah o toengtoeng ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nito thung sak ih amlai long to tamsi o sak hmah, tiah thuih ih lok to Israel kaminawk mah thaih o naah, raihaih a tongh o boeh, tiah panoek o. ");
INSERT INTO cekak_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Faro khae hoi amlaem o naah, loklam ah nihcae tongh han kazing, Mosi hoi Aaron to a hnuk o; ");
INSERT INTO cekak_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","nihnik khaeah, Angraeng mah nang hnik to khen nasoe loe, lokcaek nasoe; Faro hoi anih ih toksah tamnanawk mah kaicae hae panuet moe, kaicae hae sumsen hoi hum hanah, na sak hoi boeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mosi loe Angraeng khaeah amlaem moe, Angraeng, tipongah hae kaminawk khaeah raihaih na phaksak loe? Tih pongah kai nang patoeh loe? ");
INSERT INTO cekak_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Na hmin hoi Faro khaeah lokthuih han ka caeh kruek, anih mah hae kaminawk khaeah raihaih a phaksak; nangmah ih kaminawk hae na pahlong ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","To naah Angraeng mah Mosi khaeah, Vaihi loe Faro khaeah ka sak han ih hmuen to na hnuh hoi tih boeh; ka ban thacakhaih rang hoiah nihcae to tacawtsak ueloe, ka ban thacakhaih rang hoiah a prae thung hoiah nihcae to haek tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Sithaw mah Mosi khaeah, Kai loe Angraeng ah ka oh; ");
INSERT INTO cekak_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abraham, Issak hoi Jakob khaeah, Lensawk Sithaw ah kang phong pae; toe ka hmin JEHOVAH hoiah nihcae khaeah kang phong pae ai. ");
INSERT INTO cekak_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nihcae angvin ah oh o haih, nihcae khaeah Kanaan prae to paek hanah, nihcae hoi lokmaihaih ka sak boeh. ");
INSERT INTO cekak_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","To pacoengah, Izip kaminawk mah tamna ah suek o ih, Israel kaminawk hanghaih lok to ka thaih naah, ka sak ih lokmaihaih to ka poek. ");
INSERT INTO cekak_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","To pongah Israel kaminawk khaeah, Kai loe ANGRAENG ah ka oh; Izip kaminawk ih hmuenzit phawhhaih thung hoiah nangcae to kang loih o sak han; nihcae ih tamna ah ohhaih thung hoiah kang loih o sak moe, ban ka payangh pacoengah, thacak lokcaekhaih hoiah nangcae to kang loih o sak han. ");
INSERT INTO cekak_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kami maeto ah kaimah khaeah kang lak o han, Kai loe nangcae ih Sithaw ah ka oh han; to naah Kai loe nangcae ih Angraeng Sithaw, Izip kaminawk hmuenzit phawhhaih thung hoi zaehoikung ah ka oh, tiah na panoek o tih. ");
INSERT INTO cekak_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kai mah Abraham, Issak hoi Jakob khaeah ban ka payangh moe, paek han lokkam ih prae thungah, kang caeh o sak han; to prae to nangcae hanah qawk ah kang paek han; Kai loe Angraeng ah ka oh, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Hae lok hae Mosi mah Israel kaminawk khaeah thuih pae; toe palungboeng o, tamna ah ohhaih nung parai pongah tahngai pae o ai. ");
INSERT INTO cekak_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","a prae thung hoi Israel kaminawk tacawtsak hanah, Faro khaeah caeh ah loe, thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Toe Mosi mah Angraeng khaeah, Khenah, Israel kaminawk mah mataeng doeh ka lok hae tahngai o ai nahaeloe, lok tongaah kai ih lok cae loe kawbang maw Faro mah na tahngai pae tih? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Angraeng mah Mosi hoi Aaron khaeah, Israel kaminawk hoi Izip siangpahrang Faro kawng to thuih pae, Israel kaminawk Izip prae thung hoi tacawt haih hanah nihnik khaeah lok a paek. ");
INSERT INTO cekak_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hae kaminawk loe acaeng lu koek ah oh o; Israel calu Reuben ih caanawk loe Hanok, Pallu, Hezro hoi Karmi; hae kaminawk loe Rueben ih imthung takoh ah oh o. ");
INSERT INTO cekak_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon ih capanawk loe Jemuel, Jamin, Ohad, Jachin, Zohar hoi Kanaan tanuh ih capa Shaul cae hae ni; hae kaminawk loe Simeon ih imthung takoh ah oh o. ");
INSERT INTO cekak_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi caanawk ih ahmin loe Gershon, Kohath hoi Merari; Levi loe saning cumvai qui thum, sarihto hing. ");
INSERT INTO cekak_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershon capanawk hoi imthung takoh kaminawk loe Libni hoi Shimi. ");
INSERT INTO cekak_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohath ih capanawk loe Amram, Izhar, Hebron hoi Uzziel; Kohath loe saning cumvai qui thum, thumto hing. ");
INSERT INTO cekak_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari ih capa hnik loe Mahli hoi Mushi; hae kaminawk loe Levi imthung takoh ah oh o. ");
INSERT INTO cekak_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram mah ampa ih tanuh Jokhebed to zu haih moe, anih mah Aaron hoi Mosi to a sak pae; Amram loe saning cumvai qui thum, sarihto hing. ");
INSERT INTO cekak_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar capanawk loe Korah, Nepheg hoi Zikri. ");
INSERT INTO cekak_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziel capanawk loe Mishael, Elzaphan hoi Zithri. ");
INSERT INTO cekak_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron mah Aminadab canu, Nashon ih tanuh, Elisheba to zu ah lak moe, anih mah Nadab, Abihu, Eleazar hoi Ithamar to sak. ");
INSERT INTO cekak_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korah ih capanawk loe Assir, Elkanah hoi Abiasaph; hae kaminawk loe Korah imthung takoh ah oh o. ");
INSERT INTO cekak_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron capa Eleazar mah Putiel ih canu maeto zu ah lak moe, anih mah Phinehas to sak pae; hae kaminawk loe Levi kaminawk ih acaeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Angraeng mah Aaron hoi Mosi khaeah, Israel kaminawk ih misatuh kaminawk to Izip prae thung hoi tacawt haih ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Nihnik loe Izip siangpahrang Faro khaeah Israel kaminawk Izip prae thung hoi tacawt haih hanah thuikung ah oh hoi; nihnik loe Mosi hoi Aaron hae ni. ");
INSERT INTO cekak_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Angraeng mah Izip prae thungah, Mosi khae lokthuih pae naah, ");
INSERT INTO cekak_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Angraeng mah Mosi khaeah, Kai loe Angraeng ah ka oh; kang thuih ih loknawk boih Izip siangpahrang Faro khaeah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Toe Mosi mah Angraeng khaeah, Khenah, kai loe lok tongaah kami ah ka oh pongah, kawbang maw Faro mah ka lok hae tahngai tih? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","To naah Angraeng mah Mosi khaeah, Khenah, Faro hmaa ah Sithaw baktiah kang suek boeh, nam ya Aaron loe nang ih tahmaa ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kang paek ih loknawk boih to thui ah; Faro mah a prae thung hoi Israel kaminawk tacawtsak hanah, nam ya Aaron mah Faro khaeah lok na thui pae tih. ");
INSERT INTO cekak_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Faro ih palung to kam taaksak moe, Izip prae thungah dawnrai hmuen hoi angmathaih to ka pungsak han. ");
INSERT INTO cekak_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","To pongah Faro mah na lok to tahngai mak ai; to pacoengah Izip nuiah ban ka phok moe, thacak lokcaekhaih hoiah kaimah ih misatuh kaminawk hoi Israel caanawk to Izip prae thung hoi ka tacawtsak han. ");
INSERT INTO cekak_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Izip nuiah ban ka payangh moe, nihcae salak hoiah Israel kaminawk to ka zaehhoih naah, Izip kaminawk mah kai loe Angraeng ni, tito panoek o tih. ");
INSERT INTO cekak_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Angraeng mah paek ih lok baktih toengah Mosi hoi Aaron mah sak hoi. ");
INSERT INTO cekak_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Faro khaeah lokthuih hoi naah, Mosi loe saning qui tazetto oh boeh moe, Aaron loe saning qui tazet, thumto oh boeh. ");
INSERT INTO cekak_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Faro mah nang hnik khaeah lokthuih naah, anih mah Dawnrai hmuen to sah hoi ah, tiah na thui nahaeloe, Aaron khaeah, Nangmah ih cunghet to la ah loe, Faro hmaa ah va ah, tiah thui paeh; to naah cunghet to pahui ah angcoeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","To pongah Mosi hoi Aaron loe Faro khaeah caeh hoi moe, Angraeng mah thuih ih lok baktih toengah a sak hoi; Aaron mah angmah ih cunghet to Faro hoi a tamnanawk hmaa ah vah pae; to naah cunghet to pahui ah angcoeng. ");
INSERT INTO cekak_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Faro mah angmah ih palungha kaminawk hoi lungh aah kop kaminawk to kawk: miklet kop kaminawk mah doeh miklet kophaih hoiah a sak o toeng. ");
INSERT INTO cekak_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Nihcae mah angmacae ih cunghet to vah o naah, pahui ah angcoeng boih; toe Aaron ih cunghet mah nihcae ih cunghet to pa-aeh pae boih. ");
INSERT INTO cekak_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Toe Angraeng mah thuih ih lok baktih toengah, Faro loe palungthah moe, nihnik mah thuih ih lok to tahngai pae ai. ");
INSERT INTO cekak_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Angraeng mah Mosi khaeah, Faro loe palungthah pongah, kaminawk caehsak han koeh ai. ");
INSERT INTO cekak_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Khenah, Faro loe khawnthaw ah tui ohhaih ahmuen ah caeh, to naah anih khaeah caeh hoih; anih angzo ai naah vapui taengah zing hoi ah loe, pahui ah kangcoeng na ban ih cunghet to sin hoih. ");
INSERT INTO cekak_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","To naah anih khaeah, Hebrunawk ih Angraeng Sithaw mah nang khaeah lokthuih han ih ang patoeh; praezaek ah kai bok o hanah, kai ih kaminawk to tacawtsak ah, tiah ang thuisak, toe vaihi khoek to lok na tahngai ai. ");
INSERT INTO cekak_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Angraeng mah hae tiah thuih; Ka ban ah kaom cunghet hoi vapui to ka boh moe, athii ah angcoeng naah, kai loe Angraeng ni, tito na panoek tih. ");
INSERT INTO cekak_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","To naah vapui thung ih tahnganawk to dueh o boih ueloe, vapui to ahmui sae tih; Izip kaminawk loe tui nae o thai mak ai, tiah a thuih, tiah ang thuihsak, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Angraeng mah Mosi khaeah, Aaron khaeah, Cunghet to lak hanah thui paeh loe, Izip prae ih tuinawk, vacongnawk hoi vapuinawk, kangbuem tuinawk hoi pauem ih tuilinawk nuiah na ban to payangh ah, tuinawk loe athii ah angcoeng o boih tih; Izip prae thung boih ah athii to om ueloe, thing sabae hoi thlung hoiah sak ih laom thung khoek to athii to om tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Angraeng mah thuih ih lok baktih toengah, Mosi hoi Aaron mah sak hoi; Faro hoi anih ih tamnanawk hmaa ah, angmah ih cunghet to phok moe, vapui tui to a boh; to naah vapui tuinawk loe athii ah angcoeng boih. ");
INSERT INTO cekak_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Vapui thung ih tanganawk loe duek o boih; vapui tui loe ahmui set parai pongah, Izip kaminawk mah tui to nae o thai ai; Izip prae thung boih ah athii to oh. ");
INSERT INTO cekak_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Toe Izip prae thung ih miklet sah kop kaminawk doeh, miklet kophaih hoiah to baktih hmuen to a sak o toeng; to pongah Faro loe palungthah aep aep; Angraeng mah thuih ih lok baktih toengah, Mosi hoi Aaron mah thuih ih lok to tahngai pae ai. ");
INSERT INTO cekak_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faro loe angqoi moe, nihnik to angmah im ah caehtaak; nihnik mah sak ih hmuen to tiah doeh sah pae ai. ");
INSERT INTO cekak_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Vapui tui to nae o thai ai boeh pongah, Izip kaminawk boih mah, vapui taengah naek han tui to takaeh o. ");
INSERT INTO cekak_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Angraeng mah vapui to boh pacoengah, ni sarihto laemhsak. ");
INSERT INTO cekak_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","To pacoengah Angraeng mah Mosi khaeah, Faro khaeah caeh loe, Angraeng mah, Praezaek ah kai bok hanah, kai ih kaminawk to tacawtsak lai ah. ");
INSERT INTO cekak_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Nihcae to na tacawtsak ai nahaeloe, Khenah, na prae thung boih ukong hoiah raihaih kang paek han; ");
INSERT INTO cekak_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","pop parai ukongnawk loe vapui thung hoiah tacawt o ueloe, na ohhaih siangpahrang im, na iihhhaih ahmuen, na iihhaih imthung, na tamnanawk ih imthung, nangmah kaminawk ih imthung, buh laom thung hoi takaw naephaih laom thung khoek to daw o tih. ");
INSERT INTO cekak_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Nangmah hoi na tamnanawk, nangmah kaminawk ih takpum nui boih ah ukongnawk to daw o tih, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Angraeng mah Mosi khaeah, Aaron hanah, Na ban ih cunghet to vacongnawk, vapui tuinawk hoi kangbuem tuinawk nuiah payangh ah loe, Izip prae boih ah ukongnawk to tacawtsak ah, tiah thuih pae han a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","To pongah Aaron mah Izip prae thung ih tuinawk nuiah a ban to payangh naah, ukongnawk to tacawt o moe, Izip prae thung boih ah koi o. ");
INSERT INTO cekak_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Toe miklet kop kaminawk mah doeh angmacae miklet kophaih hoiah to baktih hmuen to sak o moe, Izip prae thungah ukongnawk to tacawt o sak toeng. ");
INSERT INTO cekak_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","To pacoengah Faro mah Mosi hoi Aaron to kawk moe, Angraeng mah kai hoi kaimah ih kaminawk khaeah kaom ukongnawk to lak let hanah, Angraeng khaeah lawkthui paeh; to tiah nahaeloe nang ih kaminawk mah Angraeng khaeah angbawnhaih to sak hanah, kang caeh o sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mosi mah Faro khaeah, Ukongnawk loe vapui ah khue oh o moe, nangmah hoi na tamnanawk, nangmah ih kaminawk, nangmah im hoi nangmah kaminawk imthung ah kaom ukongnawk to dueksak hanah, lawk ka thuihaih atue to na pahoe paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Faro mah, Khawnbang ah soe, tiah a naa. Mosi mah Kaicae Angraeng Sithaw baktih mi doeh om ai, tiah na panoek thai hanah, na thuih ih lok baktiah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ukongnawk loe nangmah hoi na imnawk, na tamnanawk, nangmah ih kaminawk khae hoiah tacawt o boih tih, toe vapui ah khue ni om o tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mosi hoi Aaron mah Faro to caeh hoi taak pacoengah, Faro khae hoi ukongnawk anghmat o hanah, Mosi mah Sithaw khaeah lawkthuih. ");
INSERT INTO cekak_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mosi mah hnik ih baktih toengah, Angraeng mah sak pae; imthung, avangnawk hoi lawknawk ah kaom ukongnawk loe duek o. ");
INSERT INTO cekak_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kadueh qok to nawnto tapop o pongah, prae thung boih ah ahmui set. ");
INSERT INTO cekak_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Toe hoikhang boeh, tiah Faro mah panoek naah, palungthahsak let moe, Angraeng mah thuih ih lok baktih toengah, Mosi hoi Aaron ih lok to tahngai pae ai. ");
INSERT INTO cekak_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","To pacoengah Angraeng mah Mosi khaeah, Aaron han, Na cunghet to payangh sak tahang ah loe, long ih maiphu to bopsak ah; to naah Izip prae thung boih ih maiphunawk to alung ah angcoeng tih, tiah a thuihsak. ");
INSERT INTO cekak_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","To tiah a sak hoi. Aaron mah a ban ih cunghet to payangh tahang moe, long ih maiphu to boh; to naah kaminawk hoi moinawk nuiah alungh to oh; Izip prae thung boih ih maiphunawk loe alungh ah angcoeng. ");
INSERT INTO cekak_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Toe Izip prae thung ih miklet kop kaminawk mah angmacae kophaih hoiah alungh ah angcoengsak hanah a sak o, toe angcoeng o sak thai ai; to pongah alungh loe kami hoi moinawk nui boih ah acuk o. ");
INSERT INTO cekak_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","To pacoeng loe miklet kop kaminawk mah Faro khaeah, Hae hmuen loe Sithaw ih ban rang hoiah ni oh boeh, tiah a naa o. Toe Angraeng mah thuih ih lok baktih toengah, Faro ih palung to thahsak toengtoeng vop pongah, nihnik mah thuih ih lok to tahngai pae ai. ");
INSERT INTO cekak_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","To pacoengah Angraeng mah Mosi khaeah, Khawnthaw ah angthawk ah loe, Faro vapui ah caeh naah anih to tongh hanah zing ah; Angraeng mah, Kai a bok o hanah, kai ih kaminawk to tacawtsak ah, tiah Angraeng mah thuih, tiah a thuisak. ");
INSERT INTO cekak_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kai ih kaminawk na tacawtsak ai nahaeloe, Khenah, nangmah hoi na tamnanawk, nangmah ih kami hoi na imthung ah, taksae to kang patoeh han; Izip kaminawk ih imthung boih ah taksae to koi tih, nihcae ohhaih long ah doeh taksae cing ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Toe Kai loe Angraeng ni, tiah long um li ah na panoek o hanah, to na ni hoi kamtong kaimah ih kaminawk ohhaih Goshen to, kalah ta ah ka pahoe han, to ahmuen ah loe taksae roe om mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kai ih kami hoi nang ih kaminawk to ka tapraek han; hae dawnrai hmuen loe khawnbang ah om amtong tih, tiah a thuih, tiah thuih pae han a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Angraeng mah to tiah hmuen to ohsak pongah, Faro siangpahrang ih im, a tamna ih im hoi Izip prae thung boih ah taksae to koi. ");
INSERT INTO cekak_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","To naah Faro mah Mosi hoi Aaron to kawk moe, Caeh oh loe, na Sithaw khaeah sak ih angbawnhaih to hae prae thungah sah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Toe Mosi mah, To tiah loe amsoem mak ai; Kaicae Angraeng Sithaw khaeah, ka sak o ih angbawnhaih loe Izip kaminawk hanah panuet thok hmuen ah om tih; khenah, nangcae mikhnuk ah Izip kaminawk panuet thok ah angbawnhaih to ka sak o nahaeloe, thlung hoi na va o mak ai maw? ");
INSERT INTO cekak_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","To pongah ni thumto caehhaih praezaek ah ka caeh o moe, ang thuih ih lok baktih toengah, kaicae Angraeng Sithaw khaeah, angbawnhaih to ka sak o han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Faro mah, Praezaek ah nangmacae ih Angraeng Sithaw khaeah, angbawnhaih sak hanah kang caeh o sak han; toe kangthla ah caeh o hmah; vaihi kai hanah lawk na thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mosi mah, Khenah, nang khae hoi ka tacawt pacoengah, khawnbang hoi kamtong, taksaenawk mah Faro hoi a tamnanawk, angmah ih kaminawk to tacawt taak hanah, Angraeng khaeah lawk ka thuih roep han; toe Israel kaminawk Angraeng khaeah angbawnhaih sak o thai hanah, Faro mah na ling hmah nasoe loe, caehsak ai ah om hmah nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","To pacoengah Mosi mah Faro to caehtaak moe, Angraeng khaeah lawk a thuih. ");
INSERT INTO cekak_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mosi mah hnik ih lok baktih toengah, Angraeng mah sak pae; taksaenawk loe Faro hoi a tamnanawk, anih ih kaminawk khae hoiah tacawt o; to pacoeng hoiah loe taksae to om ai boeh. ");
INSERT INTO cekak_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","To nathuem ah doeh Faro loe palung thah vop moe, kaminawk to caehsak ai. ");
INSERT INTO cekak_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","To pacoengah Angraeng mah Mosi khaeah, Faro khaeah caeh ah loe, Hebrunawk ih Angraeng Sithaw mah, Kai a bok o hanah, kai ih kaminawk to tacawtsak lai ah, tiah a thuih, tiah thuih paeh, tiah ang naa. ");
INSERT INTO cekak_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Nihcae to na caehsak ai ah, na patawn caeng nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","khenah, Angraeng loe lawk ah kaom pacah ih moinawk, hrangnawk, laa hrangnawk, kaengkuu hrangnawk, maitaw taenawk, tuunawk nuiah ban to phok ueloe, karai parai nathaih to phasak tih. ");
INSERT INTO cekak_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Toe Angraeng mah, Israel kaminawk ih moinawk hoi Izip kaminawk ih moinawk to ka tapraek han, Israel kaminawk ih moi loe maeto doeh dueh mak ai, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Angraeng mah atue to pahoe boeh, Angraeng mah khawnbang ah hae hmuen hae prae thungah sah tih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Angraeng mah khawnbang ah to hmuen to sak; Izip kaminawk ih moi loe duek o boih; toe Israel kaminawk ih moinawk loe maeto doeh dueh ai. ");
INSERT INTO cekak_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faro mah kami to patoeh naah, khenah, Israel kaminawk ih moi loe maeto doeh dueh ai, tito panoek; toe Faro loe palung amtaaksak toengtoeng vop moe, Israel kaminawk to tacawtsak ai. ");
INSERT INTO cekak_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","To pacoengah Angraeng mah Mosi hoi Aaron khaeah, Takoeng ih maiphu to ban tamsum maeto la hoih, Mosi mah Faro hmaa ah van bangah haeh nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","To maiphu loe Izip prae thung boih ah koi ueloe, Izip prae thungah kaom kaminawk hoi moinawk to, ahlut mansak boih tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","To pongah nihnik mah takoeng pong ih maiphu to a lak hoi moe, Faro hmaa ah angdoet hoi; Mosi mah maiphu to van ah haeh naah, kaminawk hoi moinawk nuiah ahlut to oh. ");
INSERT INTO cekak_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Miklet kop kaminawk hoi Izip kaminawk boih ahlut manh o pongah, Mosi hmaa ah angdoe o thai ai. ");
INSERT INTO cekak_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mosi khaeah Angraeng mah thuih ih lok baktih toengah, Angraeng mah Faro to palung thahsak, to pongah Mosi hoi Aaron ih lok to tahngai pae ai. ");
INSERT INTO cekak_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","To pacoengah Angraeng mah Mosi khaeah, Khawnthaw ah angthawk ah loe, Faro hmaa ah angdoe ah, anih khaeah, Hebru kaminawk ih Angraeng Sithaw mah, Kai a bok o hanah, kai ih kaminawk to tacawtsak lai ah, tiah a thuih, tiah thui pae hanah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Vaihi loe long pum ah kai baktih mi doeh om ai, tiah na panoek hanah, na palung thungah maw, na tamnanawk hoi kaminawk nuiah maw, raihaihnawk to ka phaksak han boeh. ");
INSERT INTO cekak_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Vaihi ban ka payangh moe, nangmah hoi nang ih kaminawk nuiah raihaih ka phaksak han, nang loe long hoiah kang hmatsak han boeh. ");
INSERT INTO cekak_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Toe na nuiah ka thacakhaih to kam tuengsak moe, long boih ah ka hmin taphong han ih ni, nang hae kang pathawk tahang. ");
INSERT INTO cekak_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Toe nang mah kai kaminawk ih lok to na aek, nangmah hoi nangmah to nam koeh moe, kai ih kaminawk prawt ai ah na oh han maw? ");
INSERT INTO cekak_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Khenah, khawnbang hae atue ah, Izip prae oh tangsuek nathuem hoi kamtong vaihi khoek to kaom vai ai, kanung parai qaetui to ka kraksak han. ");
INSERT INTO cekak_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","To pongah vaihi kami to patoeh ah loe, lawk ah kaom moinawk hoi na tawnh ih hmuennawk boih pakuemsak ah; im ah hoih ai ih lawk ah kaom kami hoi moinawk loe qaetui mah va boih ueloe, dueh o boih tih, tiah thuih, tiah a thuisak. ");
INSERT INTO cekak_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Angraeng ih lok zii kami, Faro ih tamnanawk loe angmacae ih tamnanawk hoi pacah ih moinawk to im ah hoih o. ");
INSERT INTO cekak_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Toe Angraeng ih lok tidoeh sah ai kaminawk loe, angmacae tamnanawk hoi pacah ih moinawk to lawk ah caeh o taak. ");
INSERT INTO cekak_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","To pacoengah Angraeng mah Mosi khaeah, Kaminawk, moinawk hoi Izip prae boih ah kaom lawk ih aannawk nuiah qaetui to kraksak hanah, van bangah na ban to payang ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mosi mah angmah ih cunghet to van ah phok tahang naah, Angraeng mah khopazih hoi qaetui to patoeh, hmai to long ah krak; Angraeng mah Izip prae thungah qaetui to kho baktiah angzohsak. ");
INSERT INTO cekak_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","To tiah kakrah qaetui loe, hmai hoiah angbaeh; Izip prae oh tangsuek nathuem hoiah to baktih kanung parai, qaetui to om vai ai vop. ");
INSERT INTO cekak_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Qaetui mah Izip prae thung boih ih lawk, kami, pacah ih moi, lawk ah kamprawk aannawk to vah boih moe, lawk ih thingnawk doeh angkhaehsak boih. ");
INSERT INTO cekak_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Israel kaminawk ohhaih Goshen ahmuen khue ah ni, qaetui krah ai ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","To pacoengah Faro mah Mosi hoi Aaron to kawk hanah kami to patoeh, nihnik khaeah, Vaihi hmuen kasak pazae boeh, Angraeng loe toeng, kai hoi kai ih kaminawk loe ka set o boeh. ");
INSERT INTO cekak_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","(Khawt boeh); khopazih hoi qaetui to dip thai hanah, Angraeng khaeah lawkthui ah; kang caeh o sak han boeh hmang; kasawk ah na om o mak ai boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mosi mah anih khaeah, Vangpui zaeh ah ka caeh moe, Angraeng khaeah ban ka payangh han, to naah khopazih hoi qaetui to dii roep tih; to tiah ni long loe Angraeng ih ni, tito na panoek tih. ");
INSERT INTO cekak_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Toe nang hoi na tamnanawk mah Angraeng to na zii o mak ai vop, tito ka panoek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Buri sakhaih akung hoi barli cang loe amro boeh; barli cang loe aquih tacawt boeh moe, buri sakhaih akung doeh apawk pawk boeh. ");
INSERT INTO cekak_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Takaw dip sakhaih cang hoi bungaih loe amprawk ai vop pongah, amro ai. ");
INSERT INTO cekak_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","To pacoengah Mosi loe Faro khae hoiah tacawt moe, vangpui zaeh ah a caeh; Angraeng khaeah a ban to payangh, to naah khopazih hoi qaetui to dip moe, long nuiah kho angzo ai boeh. ");
INSERT INTO cekak_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Khotui, qaetui hoi khopazih to dip boeh, tiah Faro mah hnuk naah, zaehaih a sak let bae vop; angmah hoi a tamnanawk doeh palungthah o let. ");
INSERT INTO cekak_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Faro loe palungthah moe, Israel kaminawk to tacawtsak ai. ");
INSERT INTO cekak_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","To pacoengah Angraeng mah Mosi khaeah, Faro khaeah caeh ah; anih hmaa ah hae baktih dawnrai hmuennawk kam tuengsak hanah, anih hoi a tamnanawk ih palungthin to kam taksak boeh; ");
INSERT INTO cekak_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Izip prae nuiah ka sak ih hmuen hoi nihcae khaeah ka sak ih dawnrai hmuennawk to, na capa hoi na capa ih capa patoeng khaeah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","To pongah Mosi hoi Aaron loe Faro khaeah caeh hoi moe, anih khaeah, Hebru kaminawk ih Angraeng Sithaw mah, Ka hmaa ah poek pahnaem hanah nasetto maw nang maak han vop? Kai a bok o hanah, kai ih kaminawk to tacawtsak lai ah. ");
INSERT INTO cekak_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Na tacawtsak ai nahaeloe, khenah, khawnbang ah na prae thung boih ah pakhuh kang tacawtsak han; ");
INSERT INTO cekak_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","pakhuh loe long ah koi o boih tih, long to na hnu o thai mak ai; nihcae loe qaetui mah bop ai ih kanghmat, lawk ah kamprawk aannawk hoi thingnawk to caa o king tih. ");
INSERT INTO cekak_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Nam panawk hoi nam panawk ih ampanawk mah hae long nuiah khosak o tangsuek nathuem hoi kamtong vaihni ni khoek to hnu o vai ai ih, to baktih pakhuhnawk loe na im, na tamnanawk ih im hoi Izip kaminawk ih im boih ah koi o tih, tiah a thuih, tiah a thuih pae hoi; to pacoengah Mosi mah Faro to caehtaak. ");
INSERT INTO cekak_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Faro ih tamnanawk mah anih khaeah, Hae kami mah aicae han nasetto maw thaang patung o vop tih? Angmacae ih Angraeng Sithaw to a bok o hanah, nihcae to tacawtsak lai ah; Izip prae loe amro boeh, tiah na panoek ai vop maw? tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","To pacoengah Mosi hoi Aaron to Faro khaeah kawk o let; Faro mah nihnik khaeah, Caeh hoi ah loe, na Angraeng Sithaw to bok oh; toe mi kawbaktih kaminawk maw caeh o tih? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mosi mah, Angraeng khaeah poihsak han oh pongah, thendoengnawk, mitongnawk, kaimacae ih capa hoi canunawk, tuunawk hoi maitawnawk hoi nawnto ka caeh o han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","To naah Faro mah, Caeh hanah nangcae hoi nawktanawk kang prawt o baktih toengah, nangcae khaeah Angraeng to om nasoe; acoe oh; kasae sak han na poek o bae hae! ");
INSERT INTO cekak_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","To tiah poek han om ai! Nongpanawk khue caeh o nasoe loe, canghni ah nang hnik o ih baktih toengah, Angraeng to bok o nasoe, tiah a naa. To naah Mosi hoi Aaron to Faro hmaa hoiah haek o ving. ");
INSERT INTO cekak_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","To naah Angraeng mah Mosi khaeah, Izip prae thungah pakhuh angzoh moe, qaetui mah tahmat ih, long ah amprawk aankungnawk to caak boih hanah, na ban to Izip prae nuiah payangh ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","To pongah Mosi mah a ban ih cunghet to Izip prae nuiah phok; to na niah aqum athun Angraeng mah ni angzae bang ih takhi to songsak; khawnbang phak naah loe takhi mah pakhuhnawk to caeh haih boih. ");
INSERT INTO cekak_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Izip prae thung boih ah pakhu to koi, Izip prae angzithaih ramri taeng khoek to, kroek laek ai ah oh o; to baktih pakhuhnawk loe natuek naah doeh to tiah om vai ai; angzo han koi atue ah doeh to tiah om mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Long boih ah koi o pongah, long loe amnum ving; qaetui mah bop ai ih kanghmat, lawk ah kamprawk aankungnawk hoi thingkung pong ih kanghmat thingthainawk to a caak o boih; Izip prae thung boih ah thingkung kahing, to ai boeh loe lawk ih aannawk roe om ai boeh. ");
INSERT INTO cekak_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faro mah Mosi hoi Aaron to karangah kawk moe, Nangcae ih Angraeng Sithaw hoi nanghnik nuiah zaehaih ka sak moeng boeh. ");
INSERT INTO cekak_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","To pongah vaihi ka zaehaih to tahmen ah loe, na Angraeng Sithaw mah hae duekhaih maeto hae kai khae hoiah takhoe ving hanah, lawk na thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mosi mah Faro to tacawt taak moe, Angraeng khaeah lawk a thuih. ");
INSERT INTO cekak_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","To naah Angraeng mah thacak takhi to niduem bang hoiah songsak moe, pakhuhnawk to tuipui kathim thungah hmuh pae boih; Izip prae thung boih ah pakhuh maeto doeh anghmat ai boeh. ");
INSERT INTO cekak_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Toe Angraeng mah Faro to palungthahsak toengtoeng vop pongah, Israel kaminawk to prawt ai. ");
INSERT INTO cekak_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","To pacoengah Angraeng mah Mosi khaeah, Khoving mah Izip prae to khuk khoep hanah, van bangah na ban to payangh ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","To pongah Mosi mah van bangah ban to payangh; to naah kathah parai khoving mah Izip prae to ni thumto thung khuk khoep. ");
INSERT INTO cekak_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Maeto hoi maeto ang hnuh o thai ai moe, ni thumto thung naa ah doeh caeh o thai ai; toe Israel kaminawk ohhaih ahmuen ah loe aanghaih to oh. ");
INSERT INTO cekak_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","To naah Faro mah Mosi to kawk moe, anih khaeah, Caeh oh loe Angraeng to bok oh; nongpata hoi nawktanawk doeh caeh o boih ah; tuunawk hoi maitawnawk khue to caeh o taak ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Toe Mosi mah anih khaeah, Kaicae Angraeng Sithaw khaeah angbawnhaih hoi hmuen paekhaih ka sak o haih hanah moi hoi hmuennawk to na paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ka pacah o ih moinawk doeh ka caeh o haih han; maeto doeh ka caeh o taak mak ai; to moinawk loe kaimacae ih Angraeng Sithaw to bok hanah ka patoh o han; to ahmuen ka pha o ai karoek to, kaimacae ih Angraeng Sithaw to kawbaktih moi hoiah maw ka bok o han, tito ka panoek o ai vop, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Toe Angraeng mah Faro palungthahsak pongah, nihcae to caehsak han koeh ai. ");
INSERT INTO cekak_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Faro mah Mosi khaeah, Ka hmaa hoi tacawt ah, kai tongh hanah angzo let hmah lai ah! Ka mikhmai na hnuk lethaih ni loe, na duekhaih niah om tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosi mah, Na thuih ih lok loe hoih; na hmaa ah kam tueng let mak ai boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Angraeng mah Mosi khaeah, Faro hoi Izip prae nuiah raihaih maeto ka phaksak han vop; to pacoengah loe hae ahmuen hoiah na tacawtsak tih boeh; to tiah nawnto na haek o boih ueloe, na tacawt o sak tih boeh. ");
INSERT INTO cekak_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Israel nongpa maw, nongpata maw, mi kawbaktih mah doeh angmacae imtaeng kami khaeah sui hoi sum kanglungnawk hnik hanah, kaminawk khaeah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kai mah Izip kaminawk khaeah kami tahmenhaih palungthin to ka paek han; Mosi doeh Faro tamnanawk hmaa hoi Izip prae thungah paroeai ka lensak han. ");
INSERT INTO cekak_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","To pongah Angraeng mah khoving ah Izip prae um ah ka caeh han, tiah thuih, tiah Mosi mah thuih. ");
INSERT INTO cekak_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Izip prae thungah caa lu to ka dueksak boih han; angraeng tangkhang nuiah anghnu, Faro ih caa lu hoi amtong ueloe, cang kaehhaih set hnuk ah anghnu tamna nongpata ih caa lu khoek to ka dueksak han; tapen tangsuek moinnawk doeh ka dueksak boih han. ");
INSERT INTO cekak_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Izip prae thung boih canghnii ah kaom vai ai, hmabang ah doeh kaom han ai, qahhaih to om tih. ");
INSERT INTO cekak_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Toe Israel kaminawk ohhaih ahmuen ah loe kami, to tih ai boeh loe moi mataeng doeh ui mah uk mak ai; to naah Angraeng mah Izip kaminawk hoi Israel kaminawk tapraek boeh, tito na panoek o tih, tiah a thuih. ");
INSERT INTO cekak_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Hae ih na tamnanawk boih kai khaeah angzoh o moe, ka hmaa ah akuep o pacoengah, nangmah hoi na hnukbang kaminawk to tacawt o boih lai ah, tiah na thuih pacoengah ni ka caeh han vop, tiah a naa. Mosi loe palungphui moe, Faro to tacawt taak. ");
INSERT INTO cekak_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Angraeng mah Mosi khaeah, Izip prae thung boih ah Kai ih dawnrai hmuen to pung han oh pongah, Faro mah na lok to tahngai mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosi hoi Aaron mah Faro hmaa ah hae baktih dawnrai hmuennawk boih a sak hoi; toe Angraeng mah Faro ih palung thahsak pongah, a prae thung hoiah Israel kaminawk tacawtsak ai toengtoeng vop. ");
INSERT INTO cekak_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Izip prae ah Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Vaihi khrah loe nangcae han khrah tangsuek ah om tih; nangcae han saning amtong tangsuekhaih khrah ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Vaihi khrah ni hato naah, kami boih, angmacae imthung takoh maeto mah, tuucaa maeto sin hanah, amkhueng Israel kaminawk boih khaeah thui ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Imthung takoh maeto hanah tuucaa maeto khawt ai nahaeloe, a imtaeng ih kami hoi angcuu o nasoe loe, kami khawt ah tuucaa to sin o nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Coek koi kaom ai, saningto kaom Tuu tae to sin oh; to loe Tuu, to tih ai boeh loe Ma-eh thung hoiah qoi oh; ");
INSERT INTO cekak_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","to khrah ni hatlai palito pha ai karoek to tuucaa to kahoih ah khen oh loe, ani phak naah amkhueng Israel kaminawk mah to tuucaa to khoving ah bop o tih. ");
INSERT INTO cekak_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Athii to la oh loe, tuu moi na caak o haih im thok ranuih hoi thok tung ranui ah nok oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","To na ni duembang ah, hmai pakhaem ih moi to, kakhaa aan hoi taeh thuh ai ih takaw hoiah nawnto caa oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kahaeng moi maw, to tih ai boeh loe tui hoiah bueh ih moi to caa o hmah; toe a lu moi, a khok hoi palung pathinnawk loe hmai pakhaem pacoengah caa oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Moi to khawnbang khoek to suem o hmah; kamthlai zetta om nahaeloe, hmai hoiah qoeng oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Moi na caak o naah, kaengkaeh to angzaeng oh, khokpanaibum abuen oh loe, ban ah cunghet to sin pacoengah, karangah caa oh; hae loe Angraeng ih loihhaih poih ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","To na ni qum ah Izip prae thung boih ah ka caeh moe, kaminawk ih caa lu hoi tapen tangsuek moi to ka dueksak boih han; Izip sithawnawk to lok ka caek boih han; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Athii loe nangcae ohhaih im ah, angmathaih maeto ah om tih; athii ka hnuk naah, nangcae to kang takanh taak han; Izip prae ka tuk naah, nangcae nuiah kasae nathaih pha mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Hae ani hae pakuem o poe ah; na caanawk dung khoek to hae ani phak naah, Angraeng khaeah buh raenghaih poih to sah oh; sakzong ih atawk baktih toengah, to poih to dungzan khoek to sah oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ni sarihto thung taeh thuh ai ih takaw to caa oh; ni amtong tangsuek naah imthung ih taeh to va oh; ni amtong tangsuek hoi ni sarihto thung taeh thuh ih takaw caa kami loe, Israel acaeng thung hoiah pahnawt oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Amtong tangsuekhaih ni hoi sarihto niah, kaciim amkhuenghaih to sah oh; caaknaek khue ai ah loe tok kalah roe sah o hmah. ");
INSERT INTO cekak_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Hae na ni roe ah Izip prae thung hoiah kang tacawt o haih pongah, taeh thuh ai ih takaw caakhaih poih to sah oh; sakzong ih atawk baktih toengah, na caanawk dung khoek to hae ani hae zaa o poe ah. ");
INSERT INTO cekak_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Khrah tangsuek, to akhrah ni hathlai palito duembang hoi kamtong ni pumphaeto pacoeng, nito duembang karoek to taeh thuh ai ih takaw to caa oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ni sarihto thung na imthung ah taeh to suem o hmah; angvin maw, to tih ai boeh loe prae thung tapen kami mah maw, taeh thuh ih takaw to caa nahaeloe, Israel acaeng thung hoiah pahnawt oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Taeh hoi sak ih takaw to caa o hmah; na ohhaih ahmuen kruekah taeh thuh ai ih takaw to caa oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","To pacoengah Mosi mah Israel kacoehtanawk to kawk boih moe, nihcae khaeah, Caeh oh, nangmacae imthung takoh kakhawt ah, tuucaa maeto la oh loe, loihhaih poih sak hanah bop oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hissop thing tadok tamsum maeto la oh, sabae kathuk pong ih tuu thii thungah nup oh loe, thok ranui hoi thok tung ranui boih ah nok oh; khawnbang khoek to mi doeh thok tasa bangah caeh o hmah. ");
INSERT INTO cekak_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Angraeng loe Izip kaminawk hum hanah Izip prae thung boih ah caeh tih; thok ranuih hoi thok tung ranuih boih ah nok ih athii to a hnuk naah, Angraeng mah to im thok to takan taak tih, to tiah kami humkung loe nangcae hum hanah imthung ah akunsak mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Sakzong ih atawk baktih toengah, hae hmuen hae nangmacae hoi na caanawk mah doeh pazui o poe ah. ");
INSERT INTO cekak_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Angraeng mah lokkam ih baktih toengah, anih mah paek han thuih ih prae thungah na kun o naah, hae tok hae sah o poe ah. ");
INSERT INTO cekak_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na caanawk mah, Hae tok loe tih thuih koehhaih ih maw? tiah na dueng o nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","nangcae mah nihcae khaeah, Hae loe Angraeng mah Izip kaminawk to hum moe, kaicae ih im loe pathlung, Izip prae ih Israel kaminawk ih im takan taakhaih, Angraeng ih loihhaih poih ah oh, tiah thui pae oh, tiah a naa. To pacoengah kaminawk mah akuep hoiah bok o. ");
INSERT INTO cekak_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Angraeng mah Mosi hoi Aaron khaeah thuih ih lok baktih toengah, Israel kaminawk mah sak o. ");
INSERT INTO cekak_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Aqum naah Angraeng mah Izip prae ih caa lu boih, angraeng tangkhang nuiah anghnu, Faro caa lu hoi kamtong thongkrah kami ih caa lu, tapen tangsuek moinawk to dueksak boih. ");
INSERT INTO cekak_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Faro, anih ih tamnanawk hoi Izip kaminawk loe qum ah angthawk o boih, Izip prae thungah qahhaih to oh; kadueh ai kami im roe maeto doeh om ai. ");
INSERT INTO cekak_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Aqum ah Faro mah Mosi hoi Aaron to kawk, Angthawk hoih! Nangmah hnik hoi Israel kaminawk to angthawk oh loe, kai kaminawk khae hoiah caeh o lai ah! Nang hnik hoi ih baktih toengah, Angraeng to bok oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nangmacae ih tuunawk hoi maitawnawk doeh la oh loe, na thuih o ih baktih toengah caeh oh! Kai doeh tahamhoihaih na paek o toengah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Izip kaminawk mah, Kaicae loe kadueh kami ah ni ka oh o boih boeh, tiah a thuih o pongah, Israel kaminawk to Izip prae thung hoi karangah haek hanah, kaminawk to karangah pahruek o. ");
INSERT INTO cekak_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","To pongah kaminawk mah taeh thuh ai ih takaw kahaeng to lak o moe, takaw naephaih boengloengnawk doeh kahni hoiah tapawk o pacoengah, palaeng ah aput o. ");
INSERT INTO cekak_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Mosi mah thuih ih lok baktih toengah, Israel kaminawk mah sak o; Izip kaminawk khaeah sui, sum kanglungnawk hoi khukbuennawk to a hnik o; ");
INSERT INTO cekak_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Angraeng mah Izip kaminawk khaeah tahmenhaih palungthin to paek pongah, nihcae mah hnik ih hmuen boih to a paek o. Nihcae mah Izip kaminawk ih hmuen to lak pae o. ");
INSERT INTO cekak_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israel kaminawk loe Rameses hoi Sukkoth ah caeh o; to ah caeh kaminawk loe nongpata hoi nawkta thui ai ah, kami sang cumvai tarukto oh o. ");
INSERT INTO cekak_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Congca kaminawk loe tuunawk, maitawnawk, paroeai pop moinawk hoi nawnto caeh o. ");
INSERT INTO cekak_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Izip prae hoi sin o ih, taeh thuh ai ih takaw to lak o moe, taeh thuh ai ih takaw to hmai paop o; nihcae to Izip prae thung hoi karangah haek o, angmacae caak han mataeng doeh sak patok o pongah, takaw to taeh thuh ai ah a sin o. ");
INSERT INTO cekak_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israel kaminawk loe Izip prae thungah saning cumvai pali, qui thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Angraeng ih misatuh kaminawk loe saning cumvai pali, qui thumto boeng na niah, Izip prae thung hoiah tacawt o. ");
INSERT INTO cekak_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Aqum ah Izip prae thung hoi caeh haih hanah, Angraeng mah nihcae to toep pongah, to aqum loe Israel caanawk boih mah zah han koi Angraeng ih aqum ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Angraeng mah Mosi hoi Aaron khaeah, Hae loe loihhaih poih sakhaih atawk ah oh; to pongah kawbaktih angvin mah doeh caa thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Toe misong ah na qan ih kami loe, tangzat hin aah pacoengah ni, caa tih. ");
INSERT INTO cekak_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Prae kalah kami, toksak han na tlai ih kaminawk loe caa o thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Im maeto ah caa oh; moi to im tasa bangah sin o hmah; ahuh doeh angkhaek o sak hmah. ");
INSERT INTO cekak_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israel kaminawk boih mah to poih to sah oh. ");
INSERT INTO cekak_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Nangcae thung kaom angvin mah Angraeng loihhaih poih to sak koeh nahaeloe, a imthung takoh ih nongpanawk boih tangzat hin aat o nasoe; to pacoengah ni prae kaminawk baktiah sah o thai tih; tangzat hin aat ai kami loe mi doeh caa thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Prae thung tapen kami hoi nangcae salakah kaom prae kalah kami hanah, kanghmong daan maeto patoh oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Angraeng mah Mosi hoi Aaron khaeah thuih ih lok baktih toengah, Israel kaminawk boih mah sak o. ");
INSERT INTO cekak_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","To na niah Angraeng mah Israel misatuh kaminawk to, Izip prae thung hoiah a caeh haih. ");
INSERT INTO cekak_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","caa lu boih kai khaeah ciimcai o sak ah; Israel kaminawk ih zok thung hoi tapen tangsuek loe, kami doeh, moi doeh, kai ih ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","To naah Mosi mah kaminawk khaeah, Angraeng mah a ban thacakhaih hoiah to prae thung hoi ang zaeh o pongah, misong ah na oh o haih Izip prae thung hoi na tacawt o haih ni, hae ni hae pakuem o poe ah; taeh thuh ih takaw to caa o hmah. ");
INSERT INTO cekak_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Vaihni Abib khrah thungah, na caeh o tih boeh. ");
INSERT INTO cekak_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Angraeng mah nangcae paek hanah nam panawk khaeah lokkam ih, tahnutui hoi khoitui longhaih Kanaan, Hit, Amor, Hiv hoi Jebus kaminawk ih prae thungah ang caeh o haih naah, hae khrah ah hae tiah toksak hanah pahnet o hmah. ");
INSERT INTO cekak_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ni sarihto thung taeh thuh ai ih takaw to caa oh loe, ni sarihto naah Angraeng khaeah hae poih hae sah oh. ");
INSERT INTO cekak_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ni sarihto thung taeh thuh ai ih takaw to caa oh; nangcae salakah taeh thuh ih takaw tidoeh suem o hmah; na oh o haih a taengah doeh taeh hoi sak ih takaw to amtueng o sak hmah. ");
INSERT INTO cekak_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","To na niah na capa khaeah, Kaicae Izip prae thung hoi ka tacawt o naah, Angraeng mah tahmenhaih hoi kaicae nuiah hmuen to sak pongah, hae baktih hmuen hae ka sak o, tiah thui pae oh. ");
INSERT INTO cekak_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Hae hmuen loe nangcae ban ah angmathaih ah om tih, na mik salak ih lupataeh ah panoeksakkung ah om ueloe, na pakha ah Angraeng ih kaalok to om tih; Angraeng mah a thacakhaih rang hoiah Izip prae thung hoiah ang zaeh o. ");
INSERT INTO cekak_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Saningto pacoeng saningto, hae tue phak khruek, hae sakzong ih atawk hae sah oh. ");
INSERT INTO cekak_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Angraeng mah nangcae hoi nam panawk khaeah sak ih lokkamhaih baktih toengah, Kanaan prae ah ang caeh o haih moe, prae ang paek o naah, ");
INSERT INTO cekak_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","zok thung hoi tapen tangsuek caa to Angraeng han pahoe oh; na tawnh ih tapen tangsuek moi doeh, ataenawk loe Angraeng ih ni. ");
INSERT INTO cekak_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tapen tangsuek laa hrang to tuucaa hoiah akrang oh; akrang koeh o ai nahaeloe, laa hrang ih tahnong to khaek oh; na caanawk thungah caa lu to akrang oh. ");
INSERT INTO cekak_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Hmabang ah na caanawk mah, Hae hmuen loe tih thuih koehhaih ih maw? tiah na dueng o nahaeloe, Misong ah ohhaih Izip prae thung hoiah Angraeng mah a ban thacakhaih hoiah zaehhaih niah oh; ");
INSERT INTO cekak_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Faro mah aicae tacawtsak han koeh ai naah, Angraeng mah Izip prae thung ih caa lu boih, tapen tangsuek moi to dueksak boih; to pongah zok thung hoi tapen tangsuek moi boih Angraeng khaeah ka paek moe, caalunawk to ka krang, tiah thui pae oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Angraeng mah a ban thacakhaih rang hoiah Izip prae thung hoi zaeh pongah, hae loe na ban hoi na mik salak ih lupataeh ah, angmathaih ah om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faro mah kaminawk caehsak naah, Philistin prae caehhaih loklam loe anghnaih kue, toe to loklam hoiah Angraeng mah nihcae to caeh haih ai; Angraeng mah kaminawk misatukhaih tongh o naah, poekhaih amkhraih o ueloe, Izip prae ah amlaem o let moeng tih, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","To pongah Sithaw mah kaminawk to tuipui kathim caehhaih praezaek loklam bang hoiah caeh haih lat; Israel kaminawk loe misatukhaih khukbuen angkhukhaih hoiah ni Izip prae thung hoiah tacawt o. ");
INSERT INTO cekak_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Joseph mah Israel caanawk khaeah, Nangcae abomh hanah Sithaw angzo tih; to naah kai ih ahuh to hae ahmuen hoiah la o let ah, tiah lokkam baktih toengah, Mosi mah Joseph ih ahuh to laksak. ");
INSERT INTO cekak_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Nihcae leo Sukkoth hoi caeh o moe, praezaek taeng, Etham vangpui ah atai o. ");
INSERT INTO cekak_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Angraeng mah nihcae to khodai ah tamai hoiah zaeh moe, nihcae aanghaih paek hanah, khoving ah hmaithaw hoiah zaeh. ");
INSERT INTO cekak_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Khodai naah tamai tung, khoving naah hmaithaw hoiah kaminawk to hmabang ah a caeh haih. ");
INSERT INTO cekak_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Angraengh mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Israel kaminawk khaeah, Migdol vangpui hoi tuipui salak, Baal-Zephon vangpui taeng, tuipui taeng Pi-Hahiroth ah amlaem oh loe, tuipui taengah atai o han, thui paeh. ");
INSERT INTO cekak_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faro mah Israel kaminawk kawng pongah, Nihcae loe saoeng ah raihaih tongh o, praezaek mah pakaa khoep boeh, tiah thui tih. ");
INSERT INTO cekak_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Faro to palung ka thahsak moe, nihcae ka patomsak let han; toe Faro hoi anih ih misatuh kaminawk nuiah, ka lensawkhaih to kam tuengsak han; to naah Izip kaminawk mah kai loe Angraeng ah ka oh, tito panoek o tih, tiah a naa. To pongah Israel kaminawk mah to tiah sak o. ");
INSERT INTO cekak_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kaminawk cawnh o boih boeh, tiah Izip siangpahrang khaeah thuih pae o naah, Faro hoi a tamnanawk loe uthaih palungthin to tawnh o moe, kaminawk khaeah, Tikhoe hae tiah na sak o moe, aicae han toksah Israel kaminawk to na tacawt o sak boih loe? tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","To pongah angmah ih hrang leeng to suek coek moe, angmah ih kaminawk to nawnto a caeh haih; ");
INSERT INTO cekak_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","kahoih koek hrang leeng cumvai tarukto a lak moe, Izip prae ih hrang angthueng kaminawk, misatuh angraengnawk to a kawk. ");
INSERT INTO cekak_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Angraeng mah Izip siangpahrang, Faro ih palung to thahsak pongah, anih mah Israel kaminawk to patom; toe Israel kaminawk loe amoekhaih hoiah caeh o. ");
INSERT INTO cekak_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Izip kaminawk, Faro ih hrangnawk hoi hrang leengnawk, hrang angthueng kaminawk hoi misatuh kaminawk mah Israel kaminawk to patom o moe, Bal-Zephon hmaa ih, vapui taeng Pi-Hariroth ah anghak o naah a kae o. ");
INSERT INTO cekak_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Israel kaminawk mah doeng o naah, Faro loe anghnai daek ah phak boeh; to naah Izip kaminawk mah nihcae patom boeh, tito panoek o, Israel kaminawk loe paroeai zit o moe, Angraeng khaeah hangh o. ");
INSERT INTO cekak_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Israel caanawk mah Mosi khaeah, Izip prae ah taprong om ai pongah maw, duek hanah praezaek ah nang caeh haih? Tipongah hae tiah sak hanah, Izip prae thung hoi nang caeh haih loe? ");
INSERT INTO cekak_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Izip prae ah, Na caeh o taak ah, kaicae loe Izip kaminawk ih tok to ka sak pae o halat han boeh, tiah kang thuih o na ai maw? Praezaek ah ka duek o pongah loe, Izip kaminawk ih toksak to kaicae han hoih kue, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mosi mah kaminawk khaeah, Zii o hmah, kacakah angdoe oh, vaihni ah Angraeng mah nangcae hnuksak han ih, pahlonghaih to khen oh; vaihni ah na hnuk o ih Izip kaminawk loe, dungzan khoek to na hnu o let mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Nangcae loe anghngai o duem ah, Angraeng mah nangcae han misa na tuh pae tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","To pacoengah Angraeng mah Mosi khaeah, Tipongah kai khaeah na hang o loe? Israel kaminawk khaeah hmabang caeh o poe hanah thui pae oh; ");
INSERT INTO cekak_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","toe na cunghet to phok tahang ah, tuipui nuiah na ban to payang ah loe, tuipui to pakhoih ah; to naah Israel kaminawk loe tuipui um li ah saoeng baktiah caeh o tih. ");
INSERT INTO cekak_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Khenah, nihcae mah nangcae patom o hanah, Izip kaminawk to palung ka thahsak han; Faro hoi angmah ih misatuh kaminawk, hrang leengnawk hoi hrang angthueng kaminawk boih nuiah, ka lensawkhaih to amtueng tih. ");
INSERT INTO cekak_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Faro hoi angmah ih hrang leeng, anih ih hrang angthueng kaminawk nuiah ka lensawkhaih to kam tuengsak naah, Kai loe Angraeng ah ka oh, tito Izip kaminawk mah panoek o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Israel misatuh kaminawk ataihaih hmaa ah kacaeh, Sithaw ih van kami loe amlaem moe, nihcae hnuk ah a caeh; nihcae hmaa ah kacaeh tamai tung doeh nihcae hnukbang ah angdoet sut; ");
INSERT INTO cekak_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Izip misatuh kaminawk ataihaih ahmuen hoi Israel kaminawk ataihaih ahmuen salakah a caeh; tamai loe maeto hanah vinghaih ah oh moe, maeto hanah loe aanghaih ah oh pongah, nihcae loe aqum puek maeto hoi maeto khaeah caeh o thai ai. ");
INSERT INTO cekak_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","To pacoengah Mosi mah tuipui bangah ban to payangh, to naah Angraeng mah aqum puek ni angyae bang hoiah takhi kaham to songsak, tui to saoeng ah angcoengsak moe, tui to hnetto ah amkhoih. ");
INSERT INTO cekak_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israel kaminawk loe tuipui um li ah, saoeng ih lam caeh baktih toengah a caeh o; tui loe banqoi bantang im tapang baktiah oh. ");
INSERT INTO cekak_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Izip kaminawk loe Faro ih hrang, hrang leeng, hrang angthueng kaminawk hoiah nihcae to patom o moe, tuipui um li ah a caeh o. ");
INSERT INTO cekak_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Akhawnbang ah loe Angraeng mah tamai hmai thung hoiah Izip misatuh kaminawk to khet tathuk, to naah Izip misatuh kaminawk to raihaih paek. ");
INSERT INTO cekak_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Hrang leeng caeh thaih han ai ah, hrang leeng khoknawk to angmongsak boih; to naah Izip kaminawk mah, Israel kaminawk khae hoi cawn o ving si boeh; Angraeng mah hae kaminawk hanah Izip kaminawk to misa tuk pae boeh, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","To naah Angraeng mah Mosi khaeah, Izip kaminawk, hrang leengnawk hoi hrang angthueng kaminawk nuiah, tui angcuu let moe, khuk hmoek hanah, tuipui nuiah na ban to payangh ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mosi mah tuipui nuiah a ban to payangh; akhawnbang ah loe tuipui kathuk ah tui to angcuu let; Izip kaminawk loe cawnh o; toe Angraeng mah Izip kaminawk to tuipui um ah uemsak king. ");
INSERT INTO cekak_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tui loe angcuu let moe, Nihcae patom Faro ih misatuh kaminawk, hrang leengnawk hoi hrang angthueng kaminawk to uem boih; kami maeto doeh anghmat o ai. ");
INSERT INTO cekak_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Toe Israel kaminawk loe tuipui um li ah saoeng baktiah caeh o poe; tui loe nihcae han banqoi bantang im tapang baktiah oh. ");
INSERT INTO cekak_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","To na niah Angraeng mah Israel kaminawk to Izip kaminawk ih ban thung hoiah pahlong; tuipui taengah kadueh Izip kaminawk ih qok to Israel kaminawk mah hnuk o. ");
INSERT INTO cekak_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Izip kaminawk nuiah Angraeng mah kalen parai toksakhaih to amtuengsak, tito Israel kaminawk mah hnuk o naah, Angraeng to zit o moe, Angraeng hoi a tamna Mosi nuiah tanghaih to tawnh o. ");
INSERT INTO cekak_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","To pacoengah Mosi hoi Israel kaminawk mah Angraeng khaeah hae laa hae a sak o; Angraeng mah lensawkhaih hoiah pazawk boeh pongah, anih khaeah laa to ka sak han; anih mah hrang hoi a nuiah angthueng kaminawk tui thungah vah boih boeh. ");
INSERT INTO cekak_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Agraeng loe ka thacakhaih hoi kai ih laa ah oh moe, kai pahlonghaih ah oh; anih loe ka Sithaw ah oh pongah, anih to ka pakoeh han; kam pa ih Sithaw ah oh pongah, ka pakoeh han. ");
INSERT INTO cekak_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Angraeng loe misatuh kami ah oh, anih ih ahmin loe Angraeng, tiah oh. ");
INSERT INTO cekak_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Anih mah Faro ih hrang leeng hoi misatuh kaminawk to tui thungah vah boih boeh; Faro mah kahoih koek qoih ih misatuh angraengnawk loe kathim tuipui thungah uem o boih boeh. ");
INSERT INTO cekak_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kathuk tuili mah nihcae to khuk khoep, nihcae loe thlung baktiah tui thungah krak o tathuk boeh. ");
INSERT INTO cekak_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Aw Angraeng, thacak na bantang ban hoiah na misanawk to kadip pueng ah na hnoih. ");
INSERT INTO cekak_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na lensawk na thacakhaih hoiah na misanawk to na vah phaeng, nihcae to na palungphuihaih mah anghnoeng baktiah kangh boeh. ");
INSERT INTO cekak_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na hnahkhaw ih takhi hoiah tuinawk to nang cuusak; tuiphu to im tapang baktiah nang doetsak moe, kathuk tuipui um li ah tui to tha na caksak. ");
INSERT INTO cekak_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Misanawk mah, nihcae kae hanah, ka patom o moe, lomh ih hmuennawk to kam zet o han, to naah loe ka koehhaih akoep tih boeh; ka sumsen to ka phongh moe, nihcae to ka ban hoiah ka hum han, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Toe nang hahhaih takhi hoiah na hmuh, nihcae loe tuipui mah khuk khoep; nihcae loe kalen parai tuinawk thungah, kimlok baktiah krak o zuep boeh. ");
INSERT INTO cekak_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Aw Angraeng, sithawnawk thungah mi maw nang baktiah kaom? Mi maw nang baktiah, lensawk ciimcaihaih, zit kathok pakoehhaih hoiah dawnrai hmuennawk to sah thaih? ");
INSERT INTO cekak_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Na bantang ban na payangh naah, long mah nihcae to paaeh. ");
INSERT INTO cekak_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Kaboeng thai ai na palung nathaih hoiah na krang ih kaminawk to na zaeh; na thacakhaih hoiah na ohhaih hmuenciim to nihcae hanah na patuek. ");
INSERT INTO cekak_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kaminawk mah thaih o naah, zii o tih; Philistin kaminawk loe tasoehhaih hoiah om o tih. ");
INSERT INTO cekak_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom ukkungnawk loe dawnrai o ueloe, Moab zaehoikungnawk doeh tasoeh o tih; Kanaan kaminawk loe palungboeng o tih. ");
INSERT INTO cekak_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Zithaih hoi tasoehhaih to nihcae nuiah krah tih; Aw Angraeng, nangmah ih kaminawk to poeng o moe, na qan ih kaminawk poeng o pacoengah, kalensawk na ban thacakhaih rang hoiah nihcae to thlung baktiah angtawt ai ah nang hngaisak duem tih. ");
INSERT INTO cekak_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Aw Angraeng, qawk ah na toep ih mae, oh hanah na sak ih ahmuen thungah, nangmah ih kaminawk to na kun haih tih; Aw Angraeng, na ban hoi sak ih hmuenciim ah nihcae to na omsak tih. ");
INSERT INTO cekak_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Angraeng mah dungzan hoi dungzan khoek to uk poe tih, tiah laa to a sak o. ");
INSERT INTO cekak_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Faro ih hrangnawk, hrang leengnawk hoi hrang angthueng kaminawk loe, tuipui thungah caeh o pacoengah, Angraeng mah nihcae nuiah tuipui to amlaemsak let; toe Israel kaminawk loe tuipui um li ah saoeng baktiah caeh o. ");
INSERT INTO cekak_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","To naah Aaron ih tanuh, tahmaa nongpata Miriam mah, cingceng to ban ah sin moe, nongpatanawk boih anih hnuk ah cingceng bohhaih hoiah hnawh o. ");
INSERT INTO cekak_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam mah, Angraeng khaeah laa to sah oh; anih mah lensawkhaih hoiah pazawk boeh; hrang hoi a nuiah angthueng kaminawk to tuipui thungah a vah boih boeh, tiah laa to sak. ");
INSERT INTO cekak_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mosi mah Israel kaminawk tuipui kathim hoiah zaeh moe, Shur praezaek ah a caeh haih; ni thumto thung tui om ai ah, praezaek ah a caeh o. ");
INSERT INTO cekak_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Marah ahmuen to a phak o naah, tui loe khaa pongah, Marah ih tui to nae o thai ai; to pongah to ahmuen to Marah, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","To pongah kaminawk mah Mosi khaeah, Timaw ka naek o han? tiah laisaep o thuih. ");
INSERT INTO cekak_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","To naah Mosi mah Angraeng khaeah hangh, to naah Angraeng mah thing maeto a hnuksak; anih mah to thing to tui thungah vah naah, tui to luep; to ahmuen ah Anih mah nihcae to tanoek, a sak o zong ih hmuen hoi daan to a sak pae. ");
INSERT INTO cekak_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Nihcae khaeah, Na Angraeng Sithaw ih lok kahoih ah na tahngaih o, a mikhnuk ah katoeng hmuen to na sak o moe, ang paek o ih lok to na tahngaih o pacoengah, anih ih daannawk to na pazui o nahaeloe, Izip kaminawk nuiah ka phaksak ih nathaih to, nangcae nuiah ka phasak mak ai; Kai loe nangcae ngantuisakkung, Angraeng ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Nihcae loe tui khaw hathlai hnetto hoi ungsikung qui sarihto ohhaih, Elim ahmuen ah caeh o moe, tui taengah anghak o. ");
INSERT INTO cekak_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Israel kaminawk boih, Elim ahmuen hoiah angthawk o moe, Elim hoi Sinai salakah kaom, Sin praezaek ah a caeh o; Izip prae hoi tacawthaih khrah hnetto haih ni hatlai pangato naah to ahmuen to a phak o. ");
INSERT INTO cekak_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Praezaek ah kaminawk boih mah Mosi hoi Aaron to laisaep o thuih. ");
INSERT INTO cekak_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israel kaminawk mah nihnik khaeah, Izip prae ah moi thonghaih laom taengah anghnut moe, zok kamhah ah ka caak o naah, Angraeng ih ban hoi ka duek o nahaeloe hoih kue han to mah! Nanghnik mah haeah amkhueng kaminawk hae zok kamtlam ah dueksak hanah, hae praezaek ah na hoih hoi, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","To naah Angraeng mah Mosi khaeah, Khenah, nangcae han van hoiah takaw kho baktiah kang zohsak han; kaminawk to caeh o nasoe loe, nito caak kakhawt ah takaw to akhui o nasoe; ka paek ih lok tahngai o maw, tahngai o ai, tito hae tiah ka tanoek han. ");
INSERT INTO cekak_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ni tarukto naah loe, ni kalah ah akhuih ih pongah kamtlai alet hnetto ah akhui o nasoe loe, suem o nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","To pongah Mosi hoi Aaron mah Israel kaminawk boih khaeah, Izip prae thung hoi nangcae zaehoikung loe Angraeng ni, tito vai duem ah na panoek o tih; ");
INSERT INTO cekak_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","akhawnbang ah doeh Angraeng lensawkhaih to na hnu o tih; na laisaep o haih to Angraeng mah thaih boeh; kaihnik loe kawbang maw ka oh hoi moe, nang laisaep o thuih? tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mosi mah, Angraeng mah caak han ih moi to duembang ah na paek o ueloe, akhawnbang ah zok amhah hanah takaw to na paek o tih; to naah, Na laisaep o haih lok Angraeng mah thaih boeh, tiah thuih ih lok to akoep tih; kaihnik loe kawbang maw ka oh hoi moe, nang laisaep o thuih? Laisaep kaminawk loe kaihnik laisaep thuih ai ah, Angraeng ni na laisaep o thuih, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","To naah Mosi mah Aaron khaeah, Na laisaep o haih lok to Angraeng mah thaih boeh pongah, anih khaeah angzo oh, tiah thuih pae han a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaron mah amkhueng Israel kaminawk boih khaeah lok to thuih pae, nihcae praezaek bangah doeng o naah, tamai nuiah Angraeng lensawkhaih to amtueng. ");
INSERT INTO cekak_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Israel kaminawk laisaephaih lok to ka thaih boeh; nihcae khaeah, Duembang ah moi to na caa o ueloe, akhawnbang ah takaw to zok kamhah ah na caa o tih; to naah kai loe nangcae ih Angraeng Sithaw ah ka oh, tito na panoek o tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","To na ni duembang ah kuikoemnawk loe nihcae ohhaih ahmuen taeng koimong ah angzoh o tahang; akhawnbang ah loe misatuh kaminawk ataihaih ahmuen taengah dantui to krak. ");
INSERT INTO cekak_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Dantui anghmat pacoengah, khenah, praezaek ih long nui ah, dantui baktih kangbuet luet tetta kaom, hmuen to oh. ");
INSERT INTO cekak_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","To hmuen to Israel kaminawk mah hnuk o naah, hae loe manna maw? tiah maeto hoi maeto a thuih o. To hmuen loe timaw, tito panoek o ai. Mosi mah nihcae khaeah, Hae loe na caak o hanah Angraeng mah paek ih takaw ni. ");
INSERT INTO cekak_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Angraeng mah, Kami boih mah caak kakhawt ah akhui oh; kahni im ah kaom a caanawk caak khawt ah, kami maeto mah omer maeto akhui o hanah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","A thuih ih lok baktih toengah Israel kaminawk mah sak o; thoemto kaminawk loe kapop ah akhuih o, thoemto kaminawk mah loe zetta ah akhuih o. ");
INSERT INTO cekak_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","To tiah akhui o ih manna to omer hoi tah o naah, kapop ah akhui kami doeh amtlai ai; zetta akhui kami doeh vawt ai; kami boih mah caak khawt ah akhuih o. ");
INSERT INTO cekak_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","To naah Mosi mah nihcae khaeah, Mi kawbaktih doeh akhawnbang khoek to amtlai o sak hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Toe thoemto kaminawk mah Mosi mah thuih ih lok to tahngai o ai; akhawnbang khoek to a suek o; toe qong moe, ahmui set pae; to pongah Mosi loe nihcae nuiah palungphui. ");
INSERT INTO cekak_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Akhawnbang kruek kami boih mah angmacae caak khawt ah akhui o; ni bet naah loe, amkaw boih. ");
INSERT INTO cekak_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ni tarukto naah loe kaminawk mah takaw baktiah alet hnetto kamtlai ah akhui o; kami maeto hanah omer hnetto akhuih o; rangpui ukkungnawk loe caeh o moe, to hmuen to Mosi khaeah thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mosi mah nihcae khaeah, Angraeng mah, khawnbang loe kaciim Angraeng anghakhaih ni, Sabbath ah oh, to pongah hmai paaem koi hmuen to hmai paaem oh ah loe, bueh koi to buet o coek ah; kamtlai to akhawnbang khoek to kahoih ah pakuem oh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","To pongah Mosi mah thuih ih lok baktih toengah, akhawnbang caak hanah a suek o; toe hmuisae ai, qong doeh qong ai. ");
INSERT INTO cekak_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosi mah nihcae khaeah, to takaw to vaihniah caa oh; vaihni loe Angraeng ih Sabbath ah oh pongah, to hmuen to long ah na hnu o mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ni tarukto naah akhui oh loe patung oh; toe ni sarihto Sabbath niah loe maeto doeh na hnu o mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Toe thoemto kaminawk loe akhuih han caeh o nganga; toe maeto doeh hnu o ai. ");
INSERT INTO cekak_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","To naah Angraeng mah Mosi khaeah, Nangcae mah nasetto maw kang paek o ih lok hoi kai ih kaalok to na aek o han vop? ");
INSERT INTO cekak_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Angraeng mah Sabbath to ang paek o; to pongah ni tarukto ni ah ni hnetto caak hanah takaw to ang paek o; kami boih ni sarihto naah loe angmah ohhaih ahmuen ah om o boih nasoe loe, mi doeh a ohhaih ahmuen hoi tasa bangah tacawt hmah nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","To pongah kaminawk loe ni sarihto naah anghak o. ");
INSERT INTO cekak_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel kaminawk mah to ih takaw to manna, tiah kawk o; to takaw loe coriander amu baktiah oh, anglung moe, khoitui hoi sak ih takaw baktiah luep. ");
INSERT INTO cekak_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mosi mah Angraeng mah paek ih lok loe hae tiah oh; Izip prae thung hoiah kang zaeh o naah, praezaek ah kang pacah o ih takaw to angzo han koi na caanawk mah hnuk o thai hanah, manna to omer maeto kakoi ah suem oh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","To pongah Mosi mah Aaron khaeah, Boengloeng maeto la ah loe, to thungah manna omer maeto kakoi ah thaeng ah; na caanawk han pakuem pae hanah, Angraeng hmaa ah suem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Angraeng mah Mosi khaeah thuih ih lok baktih toengah pakuem hanah, hnukung hmaa ah Aaron mah thaengh. ");
INSERT INTO cekak_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Anghakhaih prae pha o ai karoek to Israel kaminawk mah saning qui palito thung manna to caak o; Kanaan prae phak khoek to manna to a caak o. ");
INSERT INTO cekak_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ephah hato thungah maeto loe omer maeto ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israel kaminawk loe Angraeng mah thuih ih lok baktih toengah, Sin praezaek hoi tacawt o moe, ahmuen kalah bangah kholong caeh o; Rephidim ahmuen ah anghak o; to ahmuen ah loe kaminawk mah naek o hanah tui to om ai. ");
INSERT INTO cekak_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Topongah kaminawk mah, Ka naek o hanah tui na paek ah, tiah Mosi to zoeh o. Mosi mah nihcae khaeah, Tikhoe kai nang zoeh o moe, Angraeng to na tanoek o loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Toe kaminawk loe tui anghaeh o boeh pongah, Mosi to laisaep o thuih; nihcae mah, Tipongah kaimah hoi ka caanawk khue ai ah, ka tawnh o ih moinawk doeh duek hanah, Izip prae thung hoi hae praezaek ah nang caeh haih loe? tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","To naah Mosi mah Angraeng khaeah, Hae kaminawk hae kawbang maw ka naa han? Kai thlung hoi ang vah o tom boeh, tiah a hang. ");
INSERT INTO cekak_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","To naah Angraeng mah Mosi khaeah, Kaminawk hmaa ah caeh ah, Israel kacoehtanawk hoi nawnto caeh ah, tuipui na bohhaih cunghet to sin ah loe, caeh ah. ");
INSERT INTO cekak_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Khenah, Na hmaa ih Horeb lungsong nuiah kang doet han; lungsong to bop ah, kaminawk mah naek o hanah, lungsong thung hoiah tui to tacawt tih, tiah a naa. Mosi mah to tiah Israel kaminawk mikhnuk ah sak. ");
INSERT INTO cekak_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Israel kaminawk mah, Aicae salakah Angraeng oh maw, om ai? tiah Angraeng to tanoek o moe, zoeh o pongah, to ahmuen to Massah hoi Meribah, tiah ahmin paek o. ");
INSERT INTO cekak_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalek kaminawk loe angzoh o moe, Rephidim ahmuen ah Israel kaminawk hoiah angtuk o. ");
INSERT INTO cekak_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mosi mah Joshua khaeah, Aicae thung hoi thoemto kaminawk to qoi ah loe, Amalek misatuk hanah caeh ah; khawnbang ah Sithaw ih cunghet to ban ah ka sin moe, mae nuiah kang doet han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","To pongah Mosi mah thuih ih lok baktih toengah, Joshua mah Amalek kaminawk to tuk; to naah Mosi, Aaron hoi Hur loe mae nuiah dawh o. ");
INSERT INTO cekak_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mosi ban payangh naah, Israel kaminawk mah misa pazawk o; toe anih ih ban pakhrak tathuk naah, Amalek kaminawk mah pazawk o. ");
INSERT INTO cekak_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mosi ban khah naah thlung to lak o moe, anih tlim ah suek pae o; anih to thlung nuiah anghnut o sak pacoengah, Aaron hoi Hur mah anih ih ban to hae bang hoi ho bang, niduem khoek to, pakhrah ai ah atoengh pae hoi. ");
INSERT INTO cekak_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","To pongah Joshua mah Amalek misa to sumsen hoiah tuk pazawk. ");
INSERT INTO cekak_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","To naah Angraeng mah Mosi khaeah, Hae hmuen hae panoek poe hanah cabu pongah tarik ah loe, Joshua han kahoih ah kroek paeh; Amalek kaminawk poekhaih loe van tlim hoiah kang hmatsak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mosi mah hmaicam maeto sak moe, Jehovah-nissi, tiah ahmin paek. ");
INSERT INTO cekak_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mosi mah, A caanawk adung maeto pacoeng maeto khoek to Angraeng mah Amalek kaminawk to tuh tih, tiah Angraeng mah lokkam boeh, tiah thuih. ");
INSERT INTO cekak_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Sithaw mah Mosi hoi Angraeng ih Israel kaminawk han sak pae ih hmuennawk boih hoi kawbang maw Angraeng mah Israel kaminawk Izip prae thung hoiah zaeh, tiah Mosi ih amsae, Midian kami qaima Jethro mah thaih naah, ");
INSERT INTO cekak_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jethro loe Mosi mah patoeh let ih a zu Zipporah hoi, ");
INSERT INTO cekak_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","a capa hnik to lak let; Mosi mah minawk prae ah angvin ah ka oh, tiah poek pongah, maeto loe Gershom, tiah ahmin paek; ");
INSERT INTO cekak_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","kam pa ih Sithaw loe kai bomkung ah oh, anih mah Faro ih sumsen thung hoiah ang pahlong, tiah a thuih pongah, a capa kalah maeto loe Eliezer, tiah ahmin sak. ");
INSERT INTO cekak_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mosi ih amsae Jethro loe Mosi ih zu, capa hnik hoi nawnto Mosi anghakhaih Sithaw mae taeng ih praezaek ah caeh o; ");
INSERT INTO cekak_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","to naah Jethro mah, Nam sae, kai, Jethro loe na zu, na capa hnik hoi nawnto nang khaeah kang zoh o boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","To pongah Mosi mah amsae to hnuk hanah a dawt, akuep moe, anih to mok; loklang angdueng o pacoengah, kahni imthung ah akun o. ");
INSERT INTO cekak_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosi mah amsae khaeah, Angraeng mah Israel kaminawk hanah, Faro hoi Izip kaminawk nuiah sak pae ih hmuennawk boih, loklam ah a tongh o ih raihaihnawk hoi Angraeng mah Israel kaminawk kawbang maw pahlong, tito a thuih pae boih. ");
INSERT INTO cekak_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro loe Angraeng mah Israel kaminawk nuiah sak ih kahoih hmuennawk boih hoi nihcae to Izip kaminawk ih ban thung hoi pahlong pongah anghoehaih a tawnh. ");
INSERT INTO cekak_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Anih mah, Izip kaminawk hoi Faro ih ban thung hoiah pahlongkung, Izip kaminawk ih ban thung hoi pahlongkung, Angraeng loe tahamhoihaih om nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Angraeng loe kalah sithawnawk boih pongah len kue, tito ka panoek boeh; kaminawk amoekhaih loe anih mah pazawk boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","To pacoengah Mosi amsae Jethro mah hmai angbawnhaih sak hanah moi hoi kalah hmuennawk to Sithaw khaeah sinh; to naah Aaron hoi Israel kacoehtanawk loe Mosi amsae hoi nawnto Sithaw hmaa ah takaw caak hanah angzoh o. ");
INSERT INTO cekak_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mosi loe kaminawk lokcaek hanah akhawnbang ah anghnut; kaminawk loe akhawnbang hoi duembang khoek to Mosi taengah angdoet o. ");
INSERT INTO cekak_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mosi mah kaminawk nuiah sak ih hmuen to amsae mah hnuk naah, kawbang maw kaminawk nuiah hae tiah hmuen hae na sak? Tikhoe kaminawk loe akhawnbang hoi duembang khoek to na taengah anghnut o moe, nangmah bueng lok na caek loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosi mah Sithaw koehhaih pakrong han ih ni kai khaeah angzoh o; ");
INSERT INTO cekak_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","lok angaekhaih oh naah, kai khaeah angzoh o; kai mah nihcae to maeto pacoeng maeto lok ka caek moe, Sithaw zaehhoihhaih daan hoi loknawk to ka thuih pae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mosi amsae mah anih khaeah, Na sak ih hmuen hae hoih ai. ");
INSERT INTO cekak_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Hae tok loe nang hanah azit hmoek pongah, nangmah hoi na taengah kaom kaminawk loe thazok o tangtang tih; nangmah bueng na pazawk thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Vaihi ka lok hae tahngai ah, poekhaih kang paek han; nang khaeah Sithaw om nasoe; nang loe Sithaw hmaa ah laicaeh ah om ah loe, lok angaekhaih Sithaw khaeah thuikung ah om ah; ");
INSERT INTO cekak_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","kaminawk khaeah zaehhoihaih daan hoi kaaloknawk to patuk ah; nihcae caeh han koi loklam to patuek ah loe, nihcae mah sak han koi hmuen to thui paeh. ");
INSERT INTO cekak_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Kaminawk thung hoiah Sithaw zii kami, oepthok kami, kamtlai koeh hmoek ai kaminawk to qoih loe, sangto, cumvaito, qui pangato hoi pangato ukkungnawk to suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","To kaminawk mah hmuen boih nuiah lokcaek o nasoe loe, karai hmuen khue to nang khaeah angzo o haih nasoe; toe kazoi hmuen loe nihcae mah lokcaek o nasoe; to tiah na sak nahaeloe nihcae mah na tok to lawnh o ueloe, na phawh ih hmuen doeh anghoep kue tih. ");
INSERT INTO cekak_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Sithaw mah paek ih lok baktih toengah, hae tiah na sak nahaeloe, kacakah nang doe thai ueloe, hae ih kaminawk boih doeh, lunghoihta hoiah angmacae im ah amlaem o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosi mah amsae ih lok to tahngaih moe, a thuih ih lok baktih toengah sak. ");
INSERT INTO cekak_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mosi loe Israel kaminawk boih thung hoiah toksah thaih kaminawk to qoih moe, sangto ukkung, cumvaito ukkung, qui pangato ukkung, hato ukkung hoi pangato ukkung, tiah a suek boih. ");
INSERT INTO cekak_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nihcae loe kawbaktih atue ah doeh lokcaek kami ah oh o; karai hmuen to Mosi khaeah caeh o haih moe, kazoi hmuen loe angmacae mah pathlaeng o. ");
INSERT INTO cekak_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","To pacoengah Mosi mah amsae to amlaemsak let; Jethro loe angmah prae ah amlaem let. ");
INSERT INTO cekak_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israel kaminawk Izip prae thung hoi tacawt o pacoeng, khrah thumto naah, Sinai praezaek to phak o. ");
INSERT INTO cekak_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Israel kaminawk loe Rephidim hoi amsak o moe, Sinai praezaek phak o pacoengah, mae hmaa ah atai o. ");
INSERT INTO cekak_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mosi mah Sithaw khae caeh tahang naah, Angraeng angmah khaeah angzoh hanah mae nui hoiah a kawk moe, Jakob imthung takoh hoi Israel kaminawk khaeah hae tiah a thui paeh; ");
INSERT INTO cekak_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Izip kaminawk khaeah ka sak ih hmuen na hnuk o boeh; kawbang maw tahmu ih pakhraeh pongah kang hnut o sak moe, kaimah khaeah kang hoih o, tito na panoek o boeh. ");
INSERT INTO cekak_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","To pongah vaihi ka lok hae na tahngaih o moe, ka lokkamhaih na aek o ai nahaeloe, nangcae loe kaminawk boih salakah kai ih qawk ah na om o tih; long pum loe kai ih ni; ");
INSERT INTO cekak_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","nangcae loe kai han kaciim acaeng hoi siangpahrang ukhaih prae ah kai ih qaima ah na om o tih, tiah a thuih pae. Hae loknawk hae Israel kaminawk khaeah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","To pongah Mosi loe amlaem let moe, Israel kacoehtanawk to kawk pacoengah, Angraeng mah anih khaeah thuih ih loknawk to nihcae hmaa ah thuih pae boih. ");
INSERT INTO cekak_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Kaminawk mah, Angraeng mah thuih ih lok to ka sak o boih han, tiah nawnto a thuih o. Nihcae ih lok to Mosi mah Angraeng khaeah tathlangh pae let. ");
INSERT INTO cekak_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Angraeng mah Mosi khaeah, Khenah, nang hoi thuih ih lok kaminawk mah thaih o moe, nang to dungzan khoek to tang o thai hanah, tamai thung hoi nang khaeah kang zoh han, tiah a naa. Kaminawk mah thuih ih loknawk to Mosi mah Angraeng khaeah tathlangh pae. ");
INSERT INTO cekak_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","To pacoengah Angraeng mah Mosi khaeah, Kaminawk khaeah caeh ah loe, nihcae to vaihni hoi khawnbang ah ciimcaisak ah; angmacae ih khukbuennawk to pasuk o nasoe loe, ");
INSERT INTO cekak_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ni thumto naah om o coek nasoe; ni thumto naah loe kaminawk boih hmaa ah, Sinai mae nuiah Angraeng to anghum tathuk tih. ");
INSERT INTO cekak_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kaminawk mah mae sang to poeng o han ai ah sah paeh, mae sang nuiah daw o hmah, mae sang amtonghaih long doeh sui o hmah; mae sang to ban hoi sui kami loe paduek tangtang ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Anih to ban hoi sui hmah, sui kami loe thlung hoi vah maat ai boeh loe, palaa hoi kah maat han oh; kami maw, to tih ai boeh loe moi maw hing o sak hmah, tiah a thuih, tiah thui paeh; atue kasawk ah mongkah ueng pacoengah ni, kaminawk to mae nuiah daw o vop tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mosi mae nui hoi kaminawk khaeah anghum tathuk pacoengah, kaminawk to amprik caisak; nihcae mah khukbuennawk to pasuk o. ");
INSERT INTO cekak_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","To pacoengah kaminawk khaeah, Ni thumto hanah amsak o coek ah, na zunawk khaeah iip o hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ni thumto akhawnbang ah loe, khopazih hoi tangphra to puek moe, kathah parai tamai mah mae to khuk khoep, mongkah lok loe tuen parai pongah, ataihaih im ah kaom kaminawk to tasoeh o boih. ");
INSERT INTO cekak_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","To naah Mosi mah Sithaw tongh hanah, kaminawk to ataihaih im hoiah caeh haih, nihcae loe mae tlim ah angdoet o. ");
INSERT INTO cekak_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","To naah Angraeng loe hmai thung hoiah angzoh pongah, Sinai mae to hmaikhue mah ayaw hmoek; takoeng hoi tacawt hmaikhue baktih toengah, mae to anghuenh boih. ");
INSERT INTO cekak_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Mongkah to kasawkah ueng naah, lok to len aep aep; Mosi mah lok to thuih, to naah Sithaw mah lok hoiah pathim pae. ");
INSERT INTO cekak_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Angraeng loe Sinai mae nuiah anghum tathuk moe, Mosi to mae nuiah kawk; to pongah Mosi loe dawh tahang. ");
INSERT INTO cekak_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Angraeng mah anih khaeah, Kaminawk loe Angraeng khet hanah caeh o nganga moe, a duek o han ai ah, anghum tathuk ah loe kaminawk to thuitaek ah. ");
INSERT INTO cekak_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Angraeng khaeah angzo qaima boih angmacae hoi angmacae to amprik cai o nasoe; to tih ai nahaeloe Angraeng mah nihcae to thuitaek moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosi mah Angraeng khaeah, Kaminawk mah mae to poeng o han ai ah angzithaih ramri to sah paeh loe, amprik caisak ah, tiah na thuih pongah, kaminawk Sinai mae nuiah angzo o thai ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Angraeng mah caeh tathuk ah loe, Aaron to angzo haih ah; toe qaimanawk hoi kaminawk loe Angraeng khaeah angzo o nganga hmah nasoe; to tih ai nahaeloe nihcae to danpaekhaih tong o moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","To pongah Mosi loe kaminawk khaeah anghum tathuk moe, lok to thuih pae. ");
INSERT INTO cekak_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Hae loknawk boih Sithaw mah thuih; ");
INSERT INTO cekak_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","kai loe misong ah na ohhaih, Izip prae thung hoi nangcae zaehoikung, Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ka hmaa ah Sithaw kalah tawn hmah. ");
INSERT INTO cekak_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Van ranui ah kaom krang maw, to tih ai boeh loe long tlim ah kaom krang maw, to tih ai boeh loe tui thungah kaom hmuen hoi kanghmong, kawbaktih krang doeh sah hmah; ");
INSERT INTO cekak_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","nihcae hmaa ah akuep o hmah loe, bok o hmah; na Angraeng Sithaw, Kai loe ut panoek Sithaw ah ka oh moe, kai hnuma ampanawk ih zaehaih pongah, a caanawk adung thumto hoi palito karoek to thuitaekkung ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Toe kai palung moe, ka thuih ih lok pazui kaminawk loe a caanawk ih adung sangto pong kapop adung khoek to amlunghaih patuekkung ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Avang ai ah na Angraeng Sithaw ih ahmin to patoh hmah; anih ih ahmin tidoeh na ai ah patoh rumram kami loe, Angraeng mah anih to khen sut mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabbath ni to ciimsak hanah pakuem poe ah. ");
INSERT INTO cekak_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ni tarukto thung toksah ah, na tok to sah boih ah. ");
INSERT INTO cekak_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Toe ni sarihto naah loe, na Angraeng Sithaw ih Sabbath niah oh; to niah loe tih tok doeh sah hmah; nangmah doeh, na capa doeh, na canu doeh, na tamna nongpa doeh, na tamna nongpata doeh, na tawnh ih moinawk hoi na khongkha thungah kaom angvin doeh toksak o han om ai; ");
INSERT INTO cekak_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Angraeng mah ni tarukto thung van hoi long, tuipui hoi a thungah kaom hmuennawk boih to sak moe, ni sarihto naah loe anghak; to pongah Angraeng mah Sabbath ni to tahamhoihaih paek moe, ciimcaisak. ");
INSERT INTO cekak_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Nam no hoi nam pa khingya ah; to tih nahaeloe Angraeng Sithaw mah paek ih, prae thungah hinglung na sawk tih. ");
INSERT INTO cekak_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Kami hum hmah. ");
INSERT INTO cekak_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Zu sava laep ah nongpa nongpata zaehaih sah hmah. ");
INSERT INTO cekak_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Paqu hmah. ");
INSERT INTO cekak_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Na imtaeng kami nuiah amsawn hnukung ah angdoe hmah. ");
INSERT INTO cekak_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Na imtaeng kami ih im to khit hmah; na imtaeng kami ih zu to khit hmah, to tih ai boeh loe anih ih tamna nongpa, to tih ai boeh loe anih ih tamna nongpata, anih ih maitaw doeh, anih ih laa hrang doeh, na imtaeng kami ih kawbaktih hmuen doeh khit hmah, tiah lok a paek. ");
INSERT INTO cekak_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Khopazih tuen, tangphrapuekhaih hoi mongkah lok to kaminawk mah thaih o, mae thung hoi tacawt hmaikhue to a hnuk o naah, angnawn o moe, kangthla ah angdoet o. ");
INSERT INTO cekak_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Mosi khaeah, Kaicae khae lok na thui ah, kang tahngaih pae o han; Sithaw mah kaicae khaeah lokthui hmah nasoe, ka dueh o moeng tih, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mosi mah kaminawk khaeah, Zii o hmah; mikhmai ah anih zithaih na tawnh o moe, zaehaih na sak o han ai ah, nangcae tanoek han ih Sithaw angzoh tathuk boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kaminawk loe kangthla ah angdoet o, toe Mosi loe Sithaw ohhaih kathah parai tamai kamnum ohhaih bangah a caeh. ");
INSERT INTO cekak_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","To naah Angraeng mah Mosi khaeah, Israel kaminawk khaeah, Kai mah van hoiah kang thuih ih lok to na hnuk o boeh, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kai nang bok o naah, nangmacae hanah sui sithaw doeh, sum kanglung sithaw doeh sah o hmah. ");
INSERT INTO cekak_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kai hanah long hoiah hmaicam mae to sah ah loe, to long hmaicam nuiah hmai angbawnhaih, angdaeh angbawnhaih to tuu hoi maitaw taenawk hoiah sah ah; kai ih ahmin pakoehhaih ahmuen kruekah, nang khaeah kang zoh moe, tahamhoihaih kang paek han. ");
INSERT INTO cekak_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kai hanah thlung hmaicam to na sak nahaeloe, thuk ih thlung kangphaek nuiah hmaicam to sah hmah; thlung kangphaek thukhaih sum to na phok tahang naah, hmaicam to nam hnongsak ah oh boeh. ");
INSERT INTO cekak_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Bangkrai ah na ohhaih amtueng han ai ah, hmaicam ranui ah dawhhaih thlak to sah hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Hae daan hae nihcae hmaa ah suem paeh; ");
INSERT INTO cekak_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Hebru kami to tamna ah na qan nahaeloe, anih mah saning tarukto thung na tok to sah tih; toe saning sarihto naah loe, atho tidoeh hni ai ah loihsak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Angmah bueng tamna ah om nahaeloe, angmah bueng loih han oh; to kami loe zu tawn nahaeloe, a zu hoi nawnto loih tih. ");
INSERT INTO cekak_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Angmah ih angraeng mah anih han zu to lak pae moe, caa nongpa maw, to tih ai boeh loe canu maw sah nahaeloe, anih ih caanawk loe angmah angraeng ih hmuen ah om tih; a tamna loe angmah bueng ah loih tih. ");
INSERT INTO cekak_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Toe a tamna mah, Ka Angraeng, ka zu hoi ka caanawk to palung pongah, tacawt han koeh ai, tiah thui nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","angmah ih angraeng mah anih to lokcaekkungnawk hmaa ah caeh haih tih; anih mah khongkha, to tih ai boeh loe khongkha tung ohhaih ahmuen ah caeh haih ueloe, angmah ih angraeng mah a tamna ih naa to moihin aqawthaih phungvang hoiah aqawt pae tih, to tiah anih loe a hing thung angraeng ih tamna ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Kami maeto mah a canu to tamna ah zaw nahaeloe, to nongpata to nongpa baktiah prawt sut han om ai. ");
INSERT INTO cekak_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Anih qankung angraeng mah to nongpata to zu ah lak han koeh ai nahaeloe, angmah hoi angmah to angkrangsak ah; angraeng mah to nongpata to aling pongah, kalah prae kami khaeah zaw thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","To nongpata to a capa han paek nahaeloe, anih to a canu baktiah khet han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Anih mah kalah nongpata to zu ah la let nahaeloe, hmaloe ih a zu nongpata ih caaknaek maw, to tih ai boeh loe sava sak nathuem ih khukbuen maw, khring pae han om ai. ");
INSERT INTO cekak_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Hae hmuen thumto sah ai nahaeloe, tangka paek angaih ai ah, nongpata to loih han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Minawk hum kami loe, paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pacaenghaih om ai ah, anih ban ah Sithaw mah to kami to paek nahaeloe, anih cawnhaih ahmuen ka suek pae han. ");
INSERT INTO cekak_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Toe pacaenghaih hoiah a imtaeng kami to hum nahaeloe, ka hmaicam ah abuep cadoeh anih loe duek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Amno hoi ampa hum kami loe, paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Kami paqu kami loe, kami to zawh maw, to tih ai boeh loe angmah ban ah maw suem cadoeh, paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Amno hoi ampa tangoeng kami loe paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Kami hnik loe angpan hoi moe, maeto mah kalah maeto thlung hoiah vah maw, to tih ai boeh loe ban pathluem moe a thong, toe to kami loe dueh ai, iihkhun nuiah angsong sut, ");
INSERT INTO cekak_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","toe to kami loe angthawk moe, cunghet hoiah lam caeh thaih nahaeloe, anih bop kami to loihsak han oh; toe to kami loe ahmaa ca nahaeloe, ngantui ai ah a oh nathung, patoh ih kaboeng hmuennawk boih to laem tih. ");
INSERT INTO cekak_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Kami maeto mah a tamna nongpa maw, nongpata maw boh pongah dueh nahaeloe, anih to danpaek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Toe tamna to dueh ai moe, ni hnetto maw, ni thumto maw oh pacoengah angthawk let nahaeloe, a tamna loe anih ih phoisa ah oh pongah, bop kami to danpaek han om ai. ");
INSERT INTO cekak_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Nongpa hnik loe angpan hoi naah, zokpomh nongpata to nganbawh kana paek hoi moeng pongah, nawkta to khrah akoep ai ah zun moeng nahaeloe, nongpata ih sava mah thuih ih baktih toengah, danpaek han oh; lokcaekkung mah thuih ih baktih toengah paek tih. ");
INSERT INTO cekak_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Toe kalah ahmaa casak nahaeloe, hinghaih to hinghaih hoiah pathok han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Mik pongah mik, haa pongah haa, ban pongah ban, khok pongah khok, ");
INSERT INTO cekak_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","hmai hoi thlaek pongah hmai hoi thlaek, ahmaa caksak pongah ahmaa caksak, nganbawh kana paek pongah nganbawh kana paek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kami maeto mah a tamna nongpa maw, nongpata maw mik ah boh pongah, mik amro nahaeloe, mik amrosak kami to danpaekhaih thung hoi loihsak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kami maeto mah a tamna nongpata maw, to tih ai boeh loe nongpa ih haa maw, angkhaeksak nahaeloe, haa angkhaehsak pongah tamna to loihsak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Maitaw tae mah nongpa maw, nongpata maw takhueng moe, dueh nahaeloe, maitaw tae to thlung hoi vah maat han oh; to maitaw moi to caak han om ai; toe maitaw tawnkung loe loihsak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Toe to maitaw tae loe canghnii ah kami daeng vai boeh, tito maitaw tawnkung khaeah thuih pae boeh, toe tawnkung mah kahoih ah khenzawn ai pongah, nongpa maw, nongpata maw takhueng maat bae nahaeloe, maitaw tae to thlung hoi vah maat pacoengah, tawnkung doeh paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Toe phoisa rong nasoe, tiah thui o nahaeloe, thuih ih lok baktih toengah, a hinghaih to pahlong moe, atho rongsak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Maitaw tae mah capa maw, canu maw daeng nahaeloe, lokcaekhaih baktih toengah sak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Maitaw tae mah tamna nongpa maw, nongpata maw daeng nahaeloe, maitaw tae tawnkung mah maitaw tawnkung hanah phoisa shekel qui thumto paek pacoengah, maitaw tae to thlung hoi vah maat han oh. ");
INSERT INTO cekak_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Kami maeto mah tangqom to aphroe moe, suek sut maw, to tih ai boeh loe tangqom to takaeh moe, kraeng ai ah suek sut pongah, maitaw tae maw, laa hrang maw krah moeng nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","tangqom toepkung mah maitaw hoi laa hrang ih atho to rong ueloe, kadueh maitaw to la tih. ");
INSERT INTO cekak_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kami maeto ih maitaw tae mah minawk kalah ih maitaw tae to daeng moe, dueh nahaeloe, kahing maitaw tae to zaw hoi ueloe, atho amzet hoi pacoengah, kadueh maitaw tae ih atho doeh kangvan ah amzet hoi tih. ");
INSERT INTO cekak_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Toe to ih maitaw tae loe hmawhsaeng parai moe, canghnii ah doeh maitawnawk daeng tuektuek boeh, tiah panoek boeh, toe tawnkung mah pathlet ai ah suem sut nahaeloe, kadueh maitaw to angmah la ueloe, maitaw tae hoiah rong pae let tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kami maeto mah maitaw tae maw, to tih ai boeh loe tuu maw, paquk moe boh ving, to tih ai boeh loe zaw ving nahaeloe, maitaw tae maeto zuengah maitaw tae pangato, tuu maeto zuengah tuu palito hoi rong han oh. ");
INSERT INTO cekak_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kamqu mah im muk nathuem ah kamqu to bop maat nahaeloe, a nuiah athii palonghaih om mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Toe ni tacawt boeh nahaeloe, athii longsak pongah anih loe zae ah oh; kamqu loe paqukhaih atho to rong tih; toe tidoeh tawn ai nahaeloe, paqukhaih atho rong hanah angmah to angzawh han oh. ");
INSERT INTO cekak_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","A paquk ih maitaw maw, to tih ai boeh loe laa hrang maw, to tih ai boeh loe tuu maw angmah ban ah hing vop nahaeloe, alet hnetto rong let tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Kami mah a tawnh ih moinawk to lawk ah maw, to tih ai boeh loe misur takha thungah maw pratsak, toe kahoih ah toep ai pongah, minawk ih lawk to caa nahaeloe, a lawk hoi misur takha thung ih kahoih koek hmuen hoiah pathok let tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Hmai thlaek naah hmai to cawnh moe, lawk ih cangqui maw, to tih ai boeh loe cangkung maw, to tih ai boeh loe lawk to kangh boih nahaeloe, hmai thlaek kami mah rong let tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kami maeto mah a imtaeng kami khaeah phoisa maw, hmuen maw pakuemsak, toe anih imthung hoiah kamqu mah paquk pae ving moe, kamqu to naeh nahaeloe, anih mah alet hnetto rong nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Toe kamqu to hnu ai nahaeloe, im tawnkung mah a imtaeng ih hmuen to lak maw, la ai, tito panoek hanah, anih to lokcaekkungnawk hmaa ah kawk moe, lokcaek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kami maeto mah maitaw tae maw, laa hrang maw, tuu maw, khukbuen maw, to tih ai boeh loe kanghmaa hmuen maw amsoem ai ah, Hae hmuen loe kai ih ni, tiah thui nahaeloe, nihnik to lokcaekkung khaeah caeh haih hmaek han oh; lokcaekkungnawk mah paqu kami ah net ih kami mah a imtaeng kami hanah alet hnetto pathok pae tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Kami maeto mah laa hrang maw, to tih ai boeh loe maitaw tae maw, to tih ai boeh loe tuu maw, to tih ai boeh loe kawbaktih moi doeh toepsak hanah a imtaeng kami khaeah aap, toe to moi to duek ving maw, to tih ai boeh loe ahmaa cak maw, to tih ai boeh loe minawk kalah mah huih ving pongah, mi mah doeh hnu ai nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","moi toepsak kami mah, a imtaeng kami ih hmuen to ka la ai tiah, Angraeng hmaa ah lokkam nahaeloe, nihnik salak lokpunghaih to boengsak han oh; moi tawnkung mah to lok to talawk han oh, moi toep kami doeh rongsak han om ai. ");
INSERT INTO cekak_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Toe a imtaeng kami mah to moi to paqu nahaeloe, moi toep kami mah tawnkung hanah rong pae tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Toep ih moi to kalah moisan mah kaek ving nahaeloe, moisan mah kaek ving boeh, tiah hnukung to kawk ah, to tiah nahaeloe moisan mah kaek ving pongah atho rong mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kami maeto mah hmuen maeto a imtaeng kami khaeah tlai, tawnkung om ai naah ahmaa cak, to tih ai boeh loe dueh ving nahaeloe, tlai kami mah pathok let tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Toe tawnkung om toeng nahaeloe, tlaikung mah pathok mak ai; toe atho hoiah tlai nahaeloe, tawnkung mah tlaihaih atho khue to hnik han oh. ");
INSERT INTO cekak_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Sava sak han ai ah lokkamhaih sah nongpata to nongpa maeto mah pacae khing moe, iip haih nahaeloe, nongpata avang to paek ueloe, nongpata to zu ah la tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Nongpata ih ampa mah a canu to anih zusak han koeh ai cadoeh, anih mah tangla ih avang to paek toengtoeng tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ma-uih loe hingsak han om ai. ");
INSERT INTO cekak_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Mi kawbaktih doeh pacah ih moi hoiah zaehaih sah kami loe hum han roe oh. ");
INSERT INTO cekak_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Angraeng khae khue na ai ah, kalah sithaw khaeah angbawnhaih sah kami loe, paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Angvin to pacaekthlaek hmah; anih to hnap doeh hnap hmah; nangcae doeh Izip prae thungah angvin ah ni na oh o toeng. ");
INSERT INTO cekak_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Lamhmainawk, to tih ai boeh loe naqahnawk to pacaekthlaek hmah. ");
INSERT INTO cekak_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Na pacaekthlaek pongah, nihcae mah kai khaeah qah o nahaeloe, nihcae qahhaih lok to ka tahngaih pae han. ");
INSERT INTO cekak_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Palung ka phui moe, nangcae sumsen hoiah kang hum o han; na zunawk to lamhmai ah om o ueloe, na caanawk doeh ampa tawn ai ah om o tih. ");
INSERT INTO cekak_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Na imtaeng ah kaom kamtang kai ih kaminawk khaeah phoisa na coisak nahaeloe, a caa kangpung paek hanah coisak hmah; kapung acaa na lak han om ai. ");
INSERT INTO cekak_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Na imtaeng kaminawk mah nang khaeah a khukbuen pawng nahaeloe, niduem ai naah thaak pae let ah; ");
INSERT INTO cekak_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","anih loe a takpum padap hanah to khukbuen khue ni a tawnh; to tih ai nahaeloe a iih naah, timaw angkhuk tih? Anih mah kai khaeah hang nahaeloe, kai loe minawk tahmen thaih kami ah ka oh pongah, a hanghaih lok to ka tahngaih pae han. ");
INSERT INTO cekak_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","sithawnawk to kasae thui hmah loe, nangmacae kami ukkung doeh tangoeng hmah. ");
INSERT INTO cekak_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Kahmin tangsuek thingthai hoi na pasawh tangsuek ih thingthai tui to akra ai ah paek ah, hawk ving hmah; na caanawk thungah tapen tangsuek calu to na paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","To baktih toengah, maitaw tae hoi tuu doeh paek ah; amno khaeah ni sarihto omsak loe, ni tazetto naah kai khaeah na paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Nangcae loe kai khaeah ciimcai kami ah na om o tih; to pongah taw ah moisan mah kaek ih moi to caa o hmah; uinawk han paek oh. ");
INSERT INTO cekak_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Amsawnlok to haeh hmah; katoeng ai kami hoi amyok hmah loe, amsawn lok hnukung ah angdoe hmah. ");
INSERT INTO cekak_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Kasae hmuen sak hanah minawk hnuk ah bang hmah; lokcaekhaih hmuen ah nang doet naah, toenghaih amkhraeng taak hanah kapop kaminawk bang ah angdoe hmah; ");
INSERT INTO cekak_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","lokcaek naah kamtang kami doeh mikhmai khen hmah. ");
INSERT INTO cekak_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Lam amkhraeng na misa ih maitaw tae maw, to tih ai boeh loe laa hrang maw na hnuk nahaeloe, angmah khaeah thaak pae let ah. ");
INSERT INTO cekak_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nang hnuma kami ih laa hrang to hmuen kazit mah taeh caeng nahaeloe, caehtaak hmah, anih to abom ah. ");
INSERT INTO cekak_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Kamtang nangmah ih kami to lok na caek naah, amsoem ai ah lokcaek hmah. ");
INSERT INTO cekak_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Katoeng ai hmuen to ayae oh; kaom duem kami hoi zaehaih tawn ai kami to hum hmah; zaehaih sah kasae kami loe ka prawt sut mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Bokhaih ah paek ih tangqum to talawk hmah; bokhaih mah palungha kami ih mik to maengsak moe, katoeng kami ih lok to angkawnsak. ");
INSERT INTO cekak_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Angvin to pacaekthlaek hmah; nangcae doeh Izip prae ah angvin ah na oh o pongah, angvin ih palungthin to na panoek o. ");
INSERT INTO cekak_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Saning tarukto thung lawk sah oh loe, cang to aat oh; ");
INSERT INTO cekak_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","toe saning sarihto naah loe lawk sah ai ah, lawk hmuen to anghaksak ah loe, kongsak ah; nangmacae thung ih amtang kaminawk mah caaknaek pakronghaih ah patoh o nasoe loe; nihcae mah caehtaak ih kanghmat to moinawk mah caa o nasoe. To tiah misur takha hoi olive takha doeh sah oh. ");
INSERT INTO cekak_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ni tarukto thung nangmah ih tok to sah ah loe, ni sarihto naah loe anghak ah; nangmah ih maitaw tae hoi laa hrang doeh anghak ueloe, na imthung ah tapen na tamnanawk hoi angvin doeh anghak o nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Kang thuih o ih loknawk boih pongah acoe oh; kalah sithawnawk ih ahmin to thui o hmah; na pakha hoi thuih ih lok doeh minawk han thaih o sak hmah. ");
INSERT INTO cekak_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Saningto naah vai thumto buh raenghaih to sah oh. ");
INSERT INTO cekak_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Taeh thuh ai ih buh raenghaih poih to sah oh; (kang paek o ih lok baktih toengah, atue khaeh ih Abib khrah thungah, ni sarihto thung taeh thuh ai ih takaw caakhaih poih to sah oh; nangcae loe to khrah naah ni Izip prae thung hoiah na tacawt o; to buh raenghaih poih sak nathung, mi kawbaktih doeh ka hmaa ah bangkrai ah angphong han om ai:) ");
INSERT INTO cekak_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","cangrawt tue ih poih loe na lawk thung hoi tacawt kathai tangsuek thingthai qumponawk hoiah sah oh loe, lawksak pacoeng, thingthai qumponawk lakhaih tue ah doeh sah oh. ");
INSERT INTO cekak_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Nangcae thung ih nongpa boih saningto naah vai thumto Angraeng hmaa ah angphong oh. ");
INSERT INTO cekak_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Angbawnhaih moi thii hoi taeh thuh ih takaw to nawnto na paek hmah. Angbawnhaih moithawk to akhawnbang khoek to anghmatsak hmah. ");
INSERT INTO cekak_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Na lawk thung ih hmaloe koek kathai kahoih koek thingthai to na Angraeng Sithaw im ah sin ah; maeh caa to amno ih tahnutui hoiah thong hmah. ");
INSERT INTO cekak_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Khenah, ka sak ih ahmuen ah kang caeh o haih hanah, loklam ah nangcae khenzawnkung, van kami nangcae hmaa ah ka patoeh. ");
INSERT INTO cekak_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Anih to khingya ah, a thuih ih lok to tahngai ah; anih to aek hmah; anih thungah Ka hmin oh pongah, anih mah na zaehaih to tahmen mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Toe a lok kahoih ah na tahngaih moe, ka thuih ih loknawk boih na sak nahaeloe, na misanawk to ka misa ah om tih, nangcae pakaa kaminawk to ka pakaa han. ");
INSERT INTO cekak_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Kai ih van kami to nangcae hmaa ah caeh ueloe, nangcae to Amor, Hit, Periz, Kanaan, Hiv hoi Jebus kaminawk ih prae ah na caeh haih tih; nihcae to kam rosak boih han. ");
INSERT INTO cekak_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nihcae ih sithawnawk hmaa ah akuep hmah, bok hmah loe, nihcae ih tok doeh sah hmah; to hmuennawk to phrae ah loe, krangnawk doeh phrae boih ah. ");
INSERT INTO cekak_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Nang ih takaw hoi tui to tahamhoihaih ang paek hanah, na Angraeng Sithaw to bok oh; na tak thung ih nathaih doeh kang lak pae ving tih. ");
INSERT INTO cekak_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Na prae thungah, caa kamro hoi caa kaak maeto doeh om mak ai; na hing thung khosakhaih ka koepsak han. ");
INSERT INTO cekak_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Kai zithaih nangcae hmaa ah ka patoeh moe, na phak o ih ahmuen kruekah kaom kaminawk to kam rosak han; na misanawk to hnukbang ah kam laemsak boih han. ");
INSERT INTO cekak_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Hiv, Kanaan hoi Hit kaminawk to haek hanah, nangcae hmaa ah khoilangae to ka patoeh han. ");
INSERT INTO cekak_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Saningto thungah to kaminawk to nangcae hmaa hoi ka haek mak ai; to tiah ka sak nahaeloe prae thungah kami angqai krang ueloe, taw ih moinawk to pung o aep moeng tih. ");
INSERT INTO cekak_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nang pung o moe, prae thung boih na koi o ai karoek to, to kaminawk to zetta, zetta hoiah ni ka haek han. ");
INSERT INTO cekak_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Na ramri loe tuipui kathim hoiah Philistin tuipui karoek to, praezaek hoiah vapui khoek to ka suek han; to prae thungah kaom kaminawk to na ban ah kang paek han, nangmacae hmaa hoiah nihcae to na haek o tih. ");
INSERT INTO cekak_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nihcae hoi maw nihcae ih sithawnawk hoiah maw lokkamhaih to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Nihcae mah ka nuiah zaehaih ang sak o sak han ai ah, nihcae to na prae thungah omsak hmah; nihcae ih sithawnawk to na bok nahaeloe, nang han patung ih thaang ah om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","To pacoengah Mosi khaeah, Nangmah hoi Aaron, Nadab, Abihu hoi Israel kacoehta qui sarihto Angraeng khaeah angzo o tahang ah, nihcae loe ahmuen kangthla hoiah bok o nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mosi khue ni Angraeng taengah caeh tih; kalah kaminawk loe a taengah caeh o hmah; kaminawk doeh anih hoi nawnto caeh o hmah nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mosi mah caeh moe, kaminawk khaeah lokcaekhaih hoi Angraeng ih loknawk boih to thuih naah, kaminawk boih mah, Angraeng mah thuih ih lok to ka sak o boih han, tiah nawnto a thuih o. ");
INSERT INTO cekak_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Angraeng mah thuih ih loknawk boih loe Mosi mah tarik; khawnbang khawnthaw ah angthawk moe, mae tlim ah hmaicam maeto a sak pacoengah, Israel acaeng hathlai hnetto angmathaih thlung hathlai hnetto a tling. ");
INSERT INTO cekak_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","To pacoengah anih mah Israel thendoengnawk to patoeh, nihcae mah maitaw tae to lak o moe, Angraeng khaeah hmai angbawnhaih hoi angdaeh angbawnhaih to a sak o. ");
INSERT INTO cekak_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosi mah athii ahap to lak moe, boengloeng pongah suek; athii ahap lak moe, hmaicam nuiah a haeh. ");
INSERT INTO cekak_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Anih mah lokmaihaih cabu to lak pacoengah, kaminawk hanah kroek pae; kaminawk mah Angraeng mah thuih ih loknawk to ka sak o boih moe, lok ka tahngai o han, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","To pacoengah Mosi mah athii to lak moe, kaminawk nuiah haeh pacoengah, Khenah, hae ih loknawk baktih toengah, hae loe Angraeng mah nangcae hoi sak ih lokmaihaih athii ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mosi, Aaron, Nadab, Abihu hoi Israel kacoehta qui sarihtonawk loe caeh o tahang moe, ");
INSERT INTO cekak_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Israel Sithaw to a hnuk o; a khok atlim bangah loe sapphire thlung kanglung hoi baih het ih hmuen baktiah oh moe, kacai pin van baktiah amdueng. ");
INSERT INTO cekak_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Toe Sithaw loe Israel kacoehtanawk bangah ban payangh ai; nihcae mah Sithaw to hnuk o, a caak o moe, naek o. ");
INSERT INTO cekak_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Angraeng mah Mosi khaeah, Kai khaeah mae ah angzo tahang ah loe, haeah om ah; kaminawk to na patuk hanah, thlung kangphaek nuiah ka tarik ih, lokpaekhaih hoi kaalok to kang paek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","To pacoengah Mosi loe anih bomkung Joshua hoi nawnto amsak hoi; Mosi loe Sithaw ih mae ah dawh tahang. ");
INSERT INTO cekak_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Anih mah kacoehtanawk khaeah, Nangcae khae kang zo hoi let ai karoek to haeah na zing oh; khenah, Aaron hoi Hur loe nangcae hoi nawnto oh; lokthuih han tawn kami loe nihnik khaeah caeh oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mosi mae ah caeh tahang naah, mae loe tamai mah khuk khoep. ");
INSERT INTO cekak_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Angraeng lensawkhaih loe Sinai mae ah oh; ni tarukto thung tamai mah mae to khuk khoep; ni sarihto naah loe Angraeng mah Mosi to tamai thung hoiah kawk. ");
INSERT INTO cekak_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Angraeng lensawkhaih loe, Israel kaminawk mikhnuk ah mae nuiah kangqong hmai baktiah aang. ");
INSERT INTO cekak_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mosi loe tamai thungah caeh moe, mae nui a phak pacoengah, to ah ni qui palito hoi qum qui palito oh. ");
INSERT INTO cekak_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Israel kaminawk mah Kai khaeah hmuen sin o hanah thui paeh, tiah a naa. Kami boih mah palung huemhaih hoiah paek ih hmuen to kai hanah talawk ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Nihcae khae hoi na lak han ih hmuennawk loe sui, sum kanglung hoi sum kamling, ");
INSERT INTO cekak_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","rong kam-iing, rong kamling hup hoi kathim kahni, puu tlangqui hoi maeh mui, ");
INSERT INTO cekak_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kamling tui nup ih tuu tae ih ahin hoi caham hin, shittim thing, ");
INSERT INTO cekak_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","hmai paanghaih situi, bawh ih hmuihoih situi, hmai thlaek koi hmuihoih, ");
INSERT INTO cekak_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Onyx thlungnawk, qaima ih kahni hoi saoek ah takaek ih thlungnawk to talawk ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Nangcae salakah ka oh hanah, kai han hmuenciim to sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kang patuek ih kahni im hoi hmuennawk ih krang baktih toengah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Kasawk dongto pacoeng ahap, ka kawk dongto pacoeng ahap, ka sang dongto pacoeng ahap kaom, thingkhong maeto shittim thing hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","To thingkhong to sui hoi pazut ah, athung doeh tasa bang doeh sui hoi pazut loe, aqai taeng boih sui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Sui hoiah aqai kangbuet luet palito sah ah loe, thingkhong takii palito ah suem boih ah; takii maeto pongah kangbuet luet hnetto suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Shittim thing hoiah aputhaih thing to sah loe, sui tui pazut ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Thingkhong aput hanah aputhaih thing loe sui hoi sak ih kangbuet luet akhaw thungah hawt ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Aputhaih thingnawk loe thingkhong aqai ah suek ih kangbuet luet akhaw thungah suem poe ah, azuk ving hmah. ");
INSERT INTO cekak_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","To thingkhong thungah kang paek han ih hnukung to suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Kasawk dong hnetto pacoeng ahap, ka kawk dong maeto pacoeng ahap kaom, palungnathaih tangkhang loe kaciim sui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Cherubim hnetto sui hoiah sah loe, angtaeng koek palungnathaih tangkhang suekhaih ahmuen ah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Cherub maeto loe hae bang ih ahmuen kangtaeng ah suem ah loe, kalah maeto loe ho bang ih kangtaeng ahmuen ah suem ah; cherubim loe hae bang hoi ho bang ih palungnathaih tangkhang taengah suem hmaek ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cherubim ih pakhraehnawk to mikhmai kangtong ah suem ah loe, palungnathaih tangkhang bangah anghaesak ah; pakhraeh to phoksak tahang ah loe, palungnathaih tangkhang to pakhraeh hoi khuksak ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Palungnathaih tangkhang to thingkhong nuiah suemh loe, to thingkhong thungah kang paek ih hnukung to suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Hnukung suekhaih thingkhong nuiah kaom, cherubim hnetto salakah, nang to kang tongh moe, palungnathaih tangkhang ranuih hoiah nang khaeah lok ka thuih han; Israel kaminawk hanah ka paek ih loknawk boih nang khaeah kang paek han. ");
INSERT INTO cekak_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kasawk dong hnetto, kakawk dong maeto, kasang dong maeto pacoeng ahap kaom, caboi maeto shittim thing hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kaciim sui hoi pazut ah loe, aqai taeng boih sui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Aqai karto sah ah loe, aqai taeng boih sui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","To caboi aqai ah kangbuet luet palito sui hoiah sah loe, akhok palito ranuih caboi takii palito ah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","To sui hoiah sak ih kangbuet luet palito loe, aqai ah oh pongah caboi aput han thing hawthaih akhaw ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Caboi aputhaih cung to shittim thing hoiah sah loe, to aputhaih thing to sui hoiah pazut ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","To ih caboi ah patoh han ih sabaenawk, kathlahnawk, kraenghaih akhuemnawk, sabae kathuknawk to sah ah; tui bawhhaih boengloeng doeh sui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ka hmaa ih caboi nuiah takaw to suem poe ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Hmaithawk paanghaih to kaciim sui hoiah sah loe, tung hoi a bannawk, boengloengnawk, apawk hoi apawk tangmuem krangnawk to soi ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Hmaithawk paanghaih tung maeto bangah a ban thumto tacawt ueloe, kalah maeto bangah doeh a ban thumto, sangqum boih ah tarukto tacawtsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Hmaithawk paanghaih tung thung hoi tacawt ban thumto oh, a ban maeto naah almond apawk hoi apawk tangmuem baktih kaom, boengloeng krang thumto soi ah loe, kalah ban maeto pongah doeh almond apawk hoi apawk tangmuem baktih kaom, boengloeng krang thumto soi ah; to tiah hmaithawk paanghaih tung hoi tacawt ban tarukto nuiah soi boih ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Hmai paanghaih tung pongah doeh almond apawk hoi apawk tangmuem baktih kaom, boengloeng krang palito soi han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Hmaithawk paanghaih tung maeto thung hoiah ban tarukto tacawt baktih toengah, a ban maeto atlim ah apawk tangmuem krang maeto, a ban hnetto tlim ah apawk tangmuem krang maeto, a ban thumto tlim ah doeh apawk tangmuem krang maeto soi boih han oh. ");
INSERT INTO cekak_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Apawk tangmuem hoi hmaithawk paanghaih tung hoiah tacawt a bannawk to anghmongsak boih ah; to hmuen to kaciim sui hoiah ah sah boih ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","To pacoengah hmai-im sarihto sah loe, caboi aangsak hanah, hmaiim to paang ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Taitaeh hoi taitaeh suekhaih doeh kaciim sui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Hmai paanghaih tung hoi kalah hmuennawk sak haih boih hanah, sui talent maeto patoh ah. ");
INSERT INTO cekak_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Mae ah kang patuek ih krang baktih toengah, sak azom ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Kahni im loe rong kam-iing, kamling hup hoi kathim, bantok sak kop kaminawk mah sak ih cherubim kaom, imthung pakaahaih puu ngan kahni hato hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Imthung pakaahaih kahni loe dong pumphae tazetto sawk moe, dong palito kawk han oh; imthung pakaahaih kahni loe dong tahhaih anghmong boih han oh. ");
INSERT INTO cekak_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Imthung pakaahaih kahni pangato pacong boih ah loe, kalah kahni pangato doeh pacong bae ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Imthung pakaahaih kahni tasa bang ih, kahni maeto hoi maeto patomhhaih aqai taengah, rong kam-iing hoiah kangbuet luet akhaw to sah ah; kalah kahni pongah doeh kahni maeto hoi maeto paconghaih aqai taengah, to tiah sah let ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Payang ih kahni maeto pongah kangbuet luet akhaw qui pangato sah loe, kalah kahni paconghaih ahmuen ah doeh kangbuet luet akhaw qui pangato sah let ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","To pacoengah kahni ataephaih doeh sui hoiah qui pangato sah loe, to kahni ataephaih hoiah kahni to maeto pacoeng maeto pacong ah; to naah kahni im maeto ah angcoeng tih. ");
INSERT INTO cekak_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Kahni im ranuih khuk hanah imthung pakaahaih kahni to maeh mui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Imthung pakaahaih kahni loe dong qui thumto sawk moe, dong palito kawksak han oh; kahni hathlaito loe kalen kasawk anghmong boih tih. ");
INSERT INTO cekak_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kahni pangato to maeto ah pacong ah loe, kalah kahni tarukto doeh maeto ah patomh ah; tarukto haih kahni loe hnetto ah pakhraep ah loe kahni im hmaa ah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kahni maeto hoi maeto paconghaih aqai ah kangbuet luet akhaw qui pangato sah loe, kalah kahni maeto patomhhaih aqai ah doeh kangbuet luet akhaw qui pangato sah let ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Sum kamling hoiah ataephaih to qui pangato ah sah loe, kangbuet luet akhaw qui pangato pongah pathlet boih ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kahni im ah payang ih kamtlai kahni ahap loe, kahni im hnukbang ah bang ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kahni im ah payang ih kamthlai kahni loe maeto bangah kasawk dong maeto, kalah maeto bangah doeh kasawk dong maeto om tih; to tiah kamtlai kahni hoiah kahni im to khuk ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kahni im khuk hanah tuu hin kamling to patoh ah loe, tuipui caham hin hoiah a nui to khuk ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Kahni im tapang to shittim thingphaek hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Thingphaek maeto loe dong hato sawk moe, dong maeto pacoeng, ahap kawksak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Thingphaek maeto pongah akhok hnetto sah loe, kangvan ah suem ah; to tiah kahni im ih thingphaek boih pongah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kahni im aloih bang pakaa hanah thingphaek pumphaeto sah ah; ");
INSERT INTO cekak_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","to thingphaek pumphaeto atlim ah thingphaek maeto pongah akhok hnetto pahnut hanah, sum kanglung hoiah akhok pahnuthaih akhaw qui palito sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kahni im aluek bang pakaa hanah thingphaek pumphaeto suem ah; ");
INSERT INTO cekak_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","akhok pahnut hanah sum kanglung hoiah akhaw qui palito sah ah; thingphaek maeto pongah akhok hnetto sah boih ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kahni im niduem bangah thingphaek tarukto sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kahni im boenghaih takii tapang haih hanah, thingphaek hnetto sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Takii hnetto loe atlim hoi ranuih nawnto pacong tahang poe ah loe ahmuen maeto ah caehsak hmaek ah; takii hnetto loe to tiah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Thingphaek tazetto om ueloe, sum kanglung hoi sak ih akhok pahnuthaih ahmuen hathlai tarukto oh han angaih; thingphaek maeto pongah akhok hnetto om ueloe, kalah thingphaek maeto pongah doeh akhok hnetto om toeng tih. ");
INSERT INTO cekak_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Takraenghaih thing to shittim thing hoiah sah ah; kahni im maeto ah takraenghaih pangato sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Kahni im maeto bangah takraenghaih pangato sah loe, kahni im boenghaih niduem bangah takraenghaih pangato sah let ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","A um takraenghaih thingphaek loe hae bang hoi ho bang boenghaih khoek to phasak ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Thingphaeknawk loe sui tui hoi pazut boih ah; takraenghaih thingphaek hawthaih ahmuen doeh sui hoiah sah ah; takraenghaih thingphaek doeh sui tui pazut ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Mae nuiah kang patuek ih krang baktih toengah, kahni im to sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Pakaahaih kahni loe rong kamiing, kamling hup, kathim puu ngan hoiah sah loe, bantok sak kop kami khaeah cherubim krang to soisak ah; ");
INSERT INTO cekak_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","sui tui pazut ih shittim tung palito nuiah, to imthung pakaahaih kahni to bang ah; to tungnawk pongah sui hoi sak ih cakoih baktih kaom racahnawk, sum kanglung hoi sak ih akhok pahnuthaih ahmuen palito sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Hnukung suekhaih thingkhong loe kahni hoi pakaa ih imthung ah suek hanah, payang ih kahni to sui hoi sak ih kahni ataephaih atlim ah bang ah; payang ih kahni mah hmuenciim hoi ciimcai koek ahmuen to pakaa khoep tih. ");
INSERT INTO cekak_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Palungnathaih tangkhang loe kaciim koek ahmuen thung ih hnukung thingkhong nuiah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Payang ih kahni tasa bangah caboi to suem ah loe, kahni im aloih bangah hmaithawk, aluek bangah caboi to mikhmai kangtong ah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Kahni im akunhaih pakaa hanah, kahni loe rong kamiing, rong kamling hup hoi kathim puu ngan hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Payang ih kahni to bangh hanah tung pangato shittim thing hoiah sah ah; to tungnawk to sui tui pazut ah; cakoih baktih kaom racahnawk doeh sui hoi sak han angaih; akhok pahnuthaih ahmuen pangato loe sum kanglung hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Dong pangato ka sawk, dong pangato kawk, hmaicam maeto shittim thing hoiah sah ah; hmaicam loe kasawk hoi kalen anghmong moe, dong thumnto sang han oh. ");
INSERT INTO cekak_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Hmaicam ih taki palito ah takii maeto sah boih loe, hmaicam pong ih takii loe anghmongsak boih ah; hmaicam to sum kamling tui hoiah pazut ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","To ah maiphu sohhaih laomnawk, kathuk sabaenawk, moi sohhaih cakoih baktih kaom sumnawk, hmaitikhaih laomnawk hoi laom sabaenawk boih sum kamling hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Hmai hawhhaih loe sum kamling hoiah sah ah loe, hmai hawhhaih takii palito nuiah akhaw kangbuet luet to sum kamling hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Hmai hawhhaih loe hmaicam angkoihaih atlim, a um ah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Hmaicam aputhaih thing loe shittim thing hoiah sah ah loe, sum kamling tui pazut ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Hmaicam aputhaih thing loe hmaicam maeto bang hoi kalah maeto bang ih akhaw thungah hawt ah loe, to tiah suem poe ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hmaicam um ah akhaw pahoe ah, mae nuiah kang patuek ih krang baktih toengah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Kahni im longhma to sah ah; dong cumvaito kasawk puu kahni hoiah aloih bang to pakaa ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Tung pumphaeto sah ah loe, sum kamling hoiah tung pahnuthaih ahmuen pumphaeto sah ah, tung pong ih cakoih baktih kaom, sum hoi paehhaihnawk loe sum kamling hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","To baktih toengah aluek bangah doeh dong cumvaito kasawk payang ih kahni to sah ah; sum kamling hoiah tung pumphaeto hoi tung pahnuthaih ahmuen pumphaeto sah ah; tung pong ih cakoih baktih kaom, sum hoi paehhaihnawk loe sum kanglung hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Longhma niduem bang loe dong qui pangato kawk tih, tung hato oh moe, tung pahnuthaih ahmuen doeh hato sak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ni tacawthaih ni angyae bang ih longhma doeh dong qui pangato kawk han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Thok maeto bang pakaa hanah, dong hathlai pangato kasawk imthung pakaahaih kahni hoi nawnto ah, tung thumto hoi akhok pahnuthaih ahmuen thumto oh han ngaih. ");
INSERT INTO cekak_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Kalah maeto bangah doeh dong hathlai pangato kasawk, pakaa ih kahni hoi nawnto ah, tung thumto hoi tung pahnuthaih ahmuen thumto oh han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Longhma akunhaih thok taeng pakaa haih hanah rong kamiing, rong kamling hup hoi kathim puu ngan hoiah sak ih dong pumphaeto kasawk kahni to om tih; tung palito om ueloe, tung pahnuthaih ahmuen palito om tih. ");
INSERT INTO cekak_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Sum kanglung hoiah longhma taeng kaom tungnawk hoi paehhaihnawk boih to sah ah; cakoih baktih kaom sum to sum kanglung hoiah sah ah loe, tung pahnuthaih ahmuen leo sum kamling hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Longhmaa loe kasawk dong cumvaito, kakawk dong qui pangato om ueloe, kasang dong pangato om tih; puu ngan hoi tung pahnuthaih ahmuen loe sum kamling hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kahni imthung ah patoh ih hmuennawk boih, toksak naah patoh ih hmuennawk boih, kahni im sakhaih sumnawk boih, longhma ah patoh ih sumnawk boih to sum kamling hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Hmaithawk paang poe thaih hanah, Israel kaminawk khaeah kaciim olive situi sin o hanah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaron hoi a caanawk mah kaminawk amkhuenghaih kahni imthung, pakaa ih kahni tasa bang kaom hnukung thingkhong hmaa ah, duembang hoi akhawnbang khoek to Angraeng hmaa ah hmai paang o poe thai hanah, hae loe Israel kaminawk mah a caanawk dung khoek to pazui hanah paek ih lok ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Anih mah qaima baktiah kai ih tok sak thaih hanah, Israel kaminawk salak hoiah nam ya Aaron, a capa Nadab, Abihu, Eleazer hoi Ithamar cae to, nangmah khaeah kawk ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Nam ya Aaron lensawkhaih hoi kranghoihaih amtueng thai hanah, kaciim kahninawk to sah paeh. ");
INSERT INTO cekak_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Aaron mah ka hmaa ah qaima toksak thaih moe, anih to pahoe pacoengah ciimsak hanah, ka paek ih palunghahaih tawn bantok sah kop kaminawk mah Aaron ih kahni to sak pae o hanah thui ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","A sak pae o han ih kahni loe, saoek padaphaih, palaeng ah avak ih kahni, anui ah khuk ih kahni, a aem takaek ih laihaw, lumuek hoi kaeng zaenghaih kaziinawk hae ni: nam ya Aaron hoi a capanawk mah qaima baktiah kai ih tok to sak o thai hanah, kaciim kahninawk to sah pae oh. ");
INSERT INTO cekak_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Nihcae mah sui, rong kamiing, rong kamling hup hoi rong kathim puu ngan kahni to lak han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","A lak o ih sui, rong kamiing, rong kamling hup hoi rong kathim puu ngan kahni hoiah palaeng ah avak ih kahni to kahoih ah sah pae oh. ");
INSERT INTO cekak_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","To palaeng ah avak ih kahni loe, palaeng hnetto pongah avak han sahsak ah loe, atom hnetto zaeng hanah angqumsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kahni ranui ah sak ih kahoih kaengkaeh doeh, palaeng ah avak ih kahni hoi anghmong hanah, sui, rong kamiing, rong kamling hup hoi rong kathim puu ngan hoiah sahsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Onyx thlung hnetto lah ah loe, to thlung pongah Israel caanawk ih ahmin to tarik ah; ");
INSERT INTO cekak_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","angmacae tapenhaih baktih toengah, thlung maeto pongah kami tarukto ih ahmin to tarik ah loe, kalah thlung maeto pongah kami tarukto ih ahmin to tarik ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Thlung thuk kakop kaminawk mah, bantuek nuiah ca tarik o ih baktih toengah, Israel caanawk ih ahmin to thlung hnetto pongah tarik ah; to pacoengah to ih thlung to sui tui palong ih tabu thungah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Israel caanawk mah panoek poehaih thlung ah suek o hanah, palaeng ah avak ih kahni nuiah hui caeng ah; Israel caanawk mah panoek o poe hanah, Aaron mah Angraeng hmaa ah nihcae ih ahminnawk to palaeng ah avak tih. ");
INSERT INTO cekak_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Thlung loe sui hoi sak ih tabu thungah suem ah; ");
INSERT INTO cekak_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","boenghaih aqai ah suek ih qui to kaciim sui hoiah pakhui ah loe, thlung suekhaih tabu hoi nawnto pathlet ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Kahni to rong kamiing, rong kamling hup, rong kathim puu ngan hoi sak ih baktih toengah, saoek padaphaih doeh kahoih ah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","To saoek padaphaih hmuen loe hnetto ah pakhraep ah, kasawk karto, kalen karto omsak ah; taki palito kangvan ah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","To saoek padaphaih nuiah ahmuen palito kangphaeng ah thlung to pahungh ah; ahmuen maeto pongah, sardiz thlung, topaz thlung hoi beryl thlung to pahung ah loe, ");
INSERT INTO cekak_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ahmuen hnetto haih pongah, emerald thlung, sarfai thlung hoi diamond thlung to pahung ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ahmuen thumto haih pongah, Jacinth thlung, agate thlung hoi amethi thlungnawk to pahung ah loe, ");
INSERT INTO cekak_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ahmuen palito haih pongah loe, krisolin thlung, onyx thlung hoi jasper thlungnawk to pahung ah; to thlungnawk loe sui hoi sak ih thingkhong thungah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Israel acaeng hathlai hnetto oh moe, bantuek nuiah tarik ih ca baktih toengah, to thlung pongah, Israel acaeng hathlai hnetto ahmin to tarik ah; thlung maeto pongah Israel acaeng ahmin maeto tarik ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Saoek padaphaih ranuih aqai ih takii hnetto pongah, kaciim sui hoi pakhui ih qui hnetto suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Saoek padaphaih nuiah sui hoiah kangbuet luet akhaw hnetto sah ah loe, padaphaih aqai ah pathlet hmaek ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Saoek padaphaih aqai hnetto pongah kaom sui hoi sak ih kangbuet luet akhaw hnetto thungah, sui hoi sak ih qui hnetto pathlet hmaek ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Sui hoi sak ih qui hnetto loe thlung pahunghaih tabu hnetto pongah pathlet ah loe, palaeng ah avak ih kahni hmaa ah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Sui hoiah kangbuet luet akhaw hnetto sah ah loe, kahni thungah kaom saoek padaphaih tlim ih, aqai hnetto nuiah suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Sui hoiah kalah kangbuet luet akhaw hnetto sah let ah loe, kahni hmaa bang ih atlim, kahoih ah sak ih kahni zaenghaih kazii ranuih, kahni aqai banqoi bangtang bangah suem hmaek ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Saoek padaphaih nui ih sui hoi sak ih kangbuet luet akhaw hnetto loe, kahni nui ih sui hoi sak ih kangbuet luet akhaw hnetto hoi nawnto pathlet ah loe, saoek padaphaih to kahni hoi amhoe han ai ah, kahoih ah sak ih kahni zaenghaih kazii ranui ah, rong kamiing qui hoiah kom ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aaron hmuenciim thung akun kruek, Angraeng hmaa ah panoek poe hanah, lokcaekhaih saoek padaphaih kahni nuiah kaom, Israel caanawk ih ahmin to, angmah ih saoek nuiah avak poe tih. ");
INSERT INTO cekak_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Urim hoi Thummin doeh avak ih saoek padaphaih kahni thungah suem ah; Aaron mah Angraeng hmaa ah akun kruek, Urim hoi Thummin to Aaron ih palung thuem ah oh poe han oh; Aaron mah Israel kaminawk nuiah sak ih lok takroekhaih to angmah ih palung thuem ah Angraeng hmaa ah avak poe tih. ");
INSERT INTO cekak_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Palaeng ah avak ih kahni to rong kamiing tlangqui hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","A um ah lu suekhaih akhaw to suem ah; a um ah suek ih akhaw to angsih han ai ah, a taeng boih ban hoiah sak ih kahni hoiah abu ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kahni tlim ih atom ah tlangqui kamiing, tlangqui kamling hup, tlangqui kathim hoiah pomegranat thingthai krang to soi ah loe, salakah sui hoi sak ih dar krang to soi ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Sui hoi sak ih dar maeto pacoengah, pomegranate thingthai krang maeto, kahni atom ranuih, a taeng boih ah soi ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron mah toksak hanah, Angraeng hmaa ah, hmuenciim thungah akun naah, dueh ai ah, tacawt hanah, to kahni to angkhuk moe, anih ih lok to thaih han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Kaciim sui sabae maeto sah ah loe, bantuek nuiah tarik ih baktih toengah, to sabae nuiah, ANGRAENG HAN CIIMCAIHAIH, tiah tarik ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Lumuek hmaa ah kamiing tlangqui hoiah kom ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","To hmuen loe Aaron ih lupataeh ah om ueloe, Israelnawk mah paek ih kaciim tangqumnawk, kaciim hmuennawk nuiah kaom, zaehaih to anih mah phaw tih; Angraeng mah to hmuennawk talawk thai hanah, to hmuen to Aaron ih lupataeh ah oh poe han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Laihaw loe puu ngan hoiah sah ah loe, lumuek doeh puu ngan hoiah sah paeh; kaeng ah angzaeng ih kazii loe kaengkaeh sah kop kami khaeah sahsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaron capanawk lensawkhaih amtueng thai hanah, laihaw, lumuek hoi kaeng zaenghaih kazii to sah paeh. ");
INSERT INTO cekak_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","To tiah nam ya Aaron hoi a caanawk to khukbuen angkhuksak moe, ka tok a sak o thai hanah, situi hoiah bawh ah, nihcae to caksak ah loe, ciimcaisak ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Nihcae ih takpum to khuk hanah, kaeng hoi phaih khoek to kapha, puu ngan kahni to sah pae ah. ");
INSERT INTO cekak_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron hoi a caanawk mah amkhuenghaih kahni im, to tih ai boeh loe hmuenciim ah toksak o hanah hmaicam taengah a caeh o naah, zaehaih mah phak thuih moe, a duek o han ai ah, to khukbuennawk to angkhuk o han angaih; hae loe Aaron hoi a caanawk hanah dungzan ah paek ih daan ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Qaima baktiah nihcae mah kai ih tok to sak o hanah, nihcae to hae tiah ciimcaisak ah; coek koi kaom ai saning kanawk maitaw caa maeto hoi tuu tae hnetto la ah; ");
INSERT INTO cekak_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","situi hoi atok ih taeh thuh ai ih takaw dip, taeh thuh ai ih situi hoi atok ih takaw kae, taeh thuh ai ih situi hoi atok ih takaw kae kangphaek daek, taeh thuh ai ih situi hoi atok ih takaw karoem to la ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","To takawnawk to benthang maeto pongah suem ah loe, maitaw tae maeto, tuu tae hnetto hoi nawnto sin ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","To pacoengah Aaron hoi a caanawk to kaminawk amkhuenghaih kahni im akunhaih thok taengah hoi ah, nihcae to tui amhluhsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Khukbuennawk to la ah loe, laihaw, kahni, palaeng ah avak ih kahni hoi saoek padaphaih hmuen to Aaron han angkhuksak pacoengah, kazii sah kami mah sak ih kaeng zaenghaih kazii hoiah palaeng ah avak ih kahni to zaeng paeh. ");
INSERT INTO cekak_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","A lu ah lumuek to hui pae ah loe, lumuek nuiah kaciim tacik to bet paeh. ");
INSERT INTO cekak_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Bawhhaih situi to la ah loe, a lu ah bawh paeh. ");
INSERT INTO cekak_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","A capanawk to caeh haih ah loe, laihaw to angkhuksak ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Aaron hoi a caanawk to lumuek angmueksak ah loe, kaeng ah kazii angzaengsak ah; dungzan ah paek ih daan baktih toengah, nihcae mah qaima ih tok to sah o poe tih; Aaron hoi a capanawk to kacak ah tok to paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Kahni im akunhaih thok taengah maitaw tae to hoi ah, Aaron hoi a caanawk mah maitaw lu nuiah ban koeng han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Kaminawk amkhuenghaih kahni im akunhaih thok taengah, Angraeng hmaa ah maitaw tae to bop oh. ");
INSERT INTO cekak_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Maitaw tae ih athii to la ah loe, hmaicam nui ih takiinawk thungah na banpazung tadong hoiah thaeng ah; to pacoengah kamtlai athii to hmaicam kung ah krai ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Zok thung ih athawknawk, pathin taeng ih athawknawk, pakae hnetto taeng ih athawk, a nuiah kaom athawknawk to la boih ah loe, hmaicam nuiah hmai pakhaem ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Toe maitaw tae ih moi, ahin hoi a aek loe, kahni im tasa bangah hmai hoiah thlaek ah; to loe zae angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Tuu tae maeto la ah loe, Aaron hoi a capanawk to lu nuiah ban koengsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tuu tae to bop ah loe, athii lak pacoengah, hmaicam nuiih a taeng boih ah haeh ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tuu tae ih angan to takroek pueng ah loe, takoh moi hoi a khoknawk pasaeh pacoengah, a lu hoi kalah moinawk to nawnto suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tuu loe hmaicam nuiah hmai hoi pakhaem ah; to loe Angraeng khaeah sak ih hmai angbawnhaih ah oh moe, Angraeng khaeah sak ih hmai angbawnhaih, hmuihoih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kalah tuu tae maeto la ah loe, Aaron hoi a capanawk to lu nuiah ban koengsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Tuu tae to bop ah loe, athii lak pacoengah, Aaron hoi a capanawk ih bantang naa ranuih, bantang banpui nui hoi bantang khokpui nuiah nok paeh; to pacoengah athii to hmaicam nui hoi a taeng boih ah haeh ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Hmaicam nui ih athii hoi bawhhaih situi to la ah loe, Aaron hoi a capanawk ih khukbuennawk nuiah bawh paeh; to tiah nahaeloe angmah hoi a capanawk ih khukbuen to ciim tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tuu tae ih athawk, tamai thawk, takoh thung ih athawknawk boih, pathin kakhuk athawk, pakae hnetto nuiah kaom athawk hoi bantang palaeng to la ah; to loe caksakhaih tuu tae ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Angraeng hmaa ah kaom, benthang thung ih taeh thuh ai ih takaw maeto, situi hoi haek ih takaw kae maeto hoi takaw karoem maeto la ah; ");
INSERT INTO cekak_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","to hmuennawk loe Aaron hoi a capanawk ih ban ah suem boih ah loe, Angraeng hmaa ah ahaek moe, paek ih hmuen baktiah paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","To hmuennawk to nihcae ban hoi la let ah loe, Angraeng hmaa ah hmuihoih to paek hanah, hmaicam nuiah hmai angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Aaron to caksak hanah tuu tae ih saoek to la ah loe, Angraeng hmaa ah ahaek moe, paek ih hmuen ah paek ah; tuu ih saoek loe nang taham ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Aaron hoi a capanawk caksakhaih tuu thung hoiah ahaek moe, paek ih moi hoi ahaek ih saoek, paloep tahang moe, paek ih moi hoi paloep tahang ih palaeng to ciimcaisak ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","To saoek hoi palaeng loe dungzan ah paek ih lok baktih toengah, Israel kaminawk mah paek ih Aaron hoi a capanawk ih taham ah om tih; to moi loe Israel kaminawk mah angmacae angdaeh angbawnhaih paek ih hmuen thung hoiah Angraeng hmaa ah ahaek moe, ahaek ah paek ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Situi hoi bawh moe, qaima toksakhaih to caksak hanah, Aaron ih kaciim khukbuennawk loe a caanawk mah toep o poe tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Hmuenciim ah toksak hanah, angmah zuengah qaima ah kaom a capa mah amkhuenghaih kahni imthung ah caeh naah, to kahni to ni sarihto thung angkhuk tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Caksak han boh ih tuu moi to la ah loe, hmuenciim ah moi to thong ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron hoi a caanawk loe tuu moi, benthang thung ih takaw, kaminawk amkhuenghaih kahni im thok taengah caa o tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Nihcae to ciimcaisak moe, caksak hanah, zae tahmenhaih sak han paek o ih hmuen to nihcae mah caa o tih; toe to hmuen loe ciimcai pongah, minawk kalah mah caa thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Caksakhaih tuu moi hoi takaw to khawnbang khoek to amtlai nahaeloe, hmai thungah va ah; to loe ciimcai hmuen ah oh pongah, mi mah doeh caa thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Kang paek ih lok baktih toengah, Aaron hoi a capanawk hanah hmuen to sah pae boih ah; nihcae tok caksakhaih to ni sarihto thung sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Zae loih hanah ni thokkruek maitaw tae maeto hoi zae angbawnhaih to sah ah; zae loihaih na sak naah hmaicam to ciimsak ah; ciimcaisak hanah situi hoiah bawh ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ni sarihto thung hmaicam han zae loihaih to sah ah loe, ciimcaisak ah; to pacoengah loe kaciim koek hmaicam ah om ueloe, hmaicam kasui hmuen boih doeh ciimcai tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Apet ai ah ni thokkruek hmaicam nuiah paek koi hmuen loe, saning to kaom tuucaa hnetto la ah, ");
INSERT INTO cekak_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","akhawnbang ah maeto paek ah loe duembang khoving tom ah maeto paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tuucaa maeto na paek naah, takaw dip ephah hato thungah maeto, olive situi hint palito thungah maeto hoi abaeh pacoengah, naek koi hmuen ah misurtui hint palito thungah maeto hoi nawnto paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Duembang khoving tom ah tuucaa maeto paek ah loe, na paek naah akhawnbang ah na paek ih baktih toengah, situi hoi atok ih takaw, naek koi hmuen ah misurtui to paek ah; to loe Angraeng hmaa ah hmuihoih ah paek ih hmai angbawnhaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Angzo han koi na caanawk boih mah, nang hoi kai anghnuk moe, lokpaehhaih ahmuen, Angraeng hmaa ah, kaminawk amkhuenghaih kahni im hmaa ah, boeng ai ah hmai angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","To ahmuen ah Israel kaminawk hoi angqum moe, ka lensawkhaih hoiah nihcae to ka ciimsak han. ");
INSERT INTO cekak_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Amkhuenghaih kahni im hoi hmaicam to ka ciimsak moe, ka qaima tok a sak o thai hanah, Aaron hoi a capanawk to ka ciimsak han. ");
INSERT INTO cekak_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Israel kaminawk salakah ka oh moe, nihcae ih Sithaw ah ka oh han. ");
INSERT INTO cekak_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Nihcae salakah ka oh hanah, Kai loe Izip prae thung hoiah nihcae zaehoikung, nihcae ih Angraeng Sithaw ah ka oh, Kai loe nihcae ih Angraeng Sithaw ah ka oh, tito nihcae mah panoek o tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Hmuihoih to thlaek hanah, shittim thing hoiah hmaicam maeto sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","To hmaicam loe takii palito om tih; dong maeto sawk ueloe, dong maeto kawk pacoengah, dong hnetto sang tih; takiinawk doeh anghmong boih tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Hmaicam ranuih koek, ataeng hoi takiinawk to sui tui pazut ah loe, sui hoiah aqai taeng boih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Sui hoi sak ih aqai tlim hae bang hoi ho bangah kangbuet luet akhaw hnetto sui hoiah sah ah; to kangbuet luet akhaw loe hmaicam aput naah thing hawthaih akhaw ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Aputhaih thing loe shittim thing hoiah sah ah loe, sui tui pazut ah. ");
INSERT INTO cekak_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kai mah nang kang tonghhaih ahmuen, hnukung nuiah kaom palungnathaih tangkhang, hnukung thingkhong pakaahaih kahni hmaa ah, to hmaicam to suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron mah akhawnbang kruek, hmaiim paang han sak naah, to hmaicam nuiah hmuihoih to thlaek tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Duembang hmai paang naah doeh, to hmaicam nuiah hmuihoih to thlaek tih; angzo han koi a caanawk dung khoek to Angraeng hmaa ah thlaek koi hmuihoih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","To hmaicam nuiah kalah hmuihoih, hmai angbawnhaih, to tih ai boeh loe cang angbawnhaih to sah hmah, naek koi hmuen doeh krai hmah. ");
INSERT INTO cekak_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron mah saningto naah vaito zae loihaih moi thii to sin ueloe, to hmaicam ih takiinawk nuiah zae loih hanah angbawnhaih to sah tih; na caanawk dung khoek to zae loih hanah saning kruek sah ah; hae loe Angraeng hmaa ah ciimcai koek hmaicam ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Israel kaminawk pakoep hanah ahmin na lak naah, kami boih hinghaih to akrang hanah Angraeng khaeah phoisa to paek oh; to tiah na sak nahaeloe nihcae na kroek naah, nihcae salakah nathaih to om mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kroek tangcae ah kaom kaminawk boih loe, hmuenciim ih shekel ahap, (shekel maeto naah, gerah pumphaeto oh) paek tih; shekel ahap loe Angraeng han paek ih hmuen ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kami kroek naah, saning pumphaeto pacoeng, ranui bang boih Angraeng khae hmuen paekhaih to sak han oh. ");
INSERT INTO cekak_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Na hinghaih to akrang hanah, Angraeng khaeah angbawnhaih na sak naah, angraeng kaminawk mah kapop ah paek o mak ai ueloe, kamtang kaminawk mah doeh tamsi ah paek o mak ai; kami boih mah shekel ahap paek o han oh. ");
INSERT INTO cekak_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Israel kaminawk khae hoi zae loih hanah akranghaih phoisa to la ah loe, amkhuenghaih kahni im toksak hanah patoh ah; hae loe Israel kaminawk mah Angraeng hmaa ah panoek poe hanah, na hinghaih loih thai hanah sak ih akranghaih ah om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","To pacoengah angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","amsaehhaih kathuk sabae maeto sum kamling hoiah sah ah loe, pahnuthaih a khok doeh sum kamling hoiah sah ah; to ih sabae kathuk to amkhuenghaih kahni im hoi hmaicam salakah suem ah loe, tui to lawn ah. ");
INSERT INTO cekak_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron hoi a caanawk loe to ih tui hoiah ban amsae o tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Amkhuenghaih kahni imthung ah a caeh o kruek, a duek o han ai ah, to ih tui hoiah amsae o tih; to tih ai boeh loe Angraeng khaeah hmai angbawnhaih sak hanah hmaicam hmaa ah caeh o naah, ");
INSERT INTO cekak_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","a duek o han ai ah, nihcae mah khok hoi ban to amsae o tih; hae loe Aaron hoi angzo han koi a caanawk mah sak o poe han ih atawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","kahoih koek hmuihoih to la ah, kaciim myrrh hmuihoih shekel cumvai pangato, cinnamon hmuihoih ahap shekel cumvai hnet, qui pangato, ");
INSERT INTO cekak_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","hmuenciim ih shekel baktih toengah, kasia shekel cumvai pangato, olive situi hint maeto sin ah; ");
INSERT INTO cekak_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","hmuihoih sah kop kami mah sak ih hmuihoih to kaciim angnok ih kaciim situi ah sah ah, to situi loe angnok ih kaciim situi ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","To situi hoiah amkhuenghaih kahni im hoi hnukung thingkhong, ");
INSERT INTO cekak_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","caboi hoi laom sabaenawk boih, hmaithawk hoi hmaithawk paanghaih tungnawk, hmuihoih thlaekhaih hmaicam, ");
INSERT INTO cekak_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","hmai angbawnhaih hmaicam hoi laom sabaenawk boih, sabae kathuk hoi pahnuthaih a khoknawk to nok boih ah. ");
INSERT INTO cekak_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","To hmuennawk kaciim koek ah oh hanah, to tiah ciimsak ah; to hmuen kasui hmuen boih loe ciimcai tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aaron hoi a capanawk to bawh ah loe, kai ih qaima tok a sak o thai hanah, nihcae to pahoe ah. ");
INSERT INTO cekak_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israel kaminawk khaeah, Hae loe angzo han koi na caanawk dung khoek to angnok ih kaciim situi ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","To situi hoiah takpum to bawh hmah loe, to situi hoi kanghmong kalah situi to sah hmah; to situi loe ciimcai pongah, nang hanah kaciim situi ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","To situi hoi kanghmong kalah situi sah kami, asaenghaih om ai ah to situi hoi minawk kalah nok kami loe, acaeng thung hoi pahnawt ah, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","To pacoengah Angraeng mah Mosi khaeah, Hmuihoih, thing tangpri, hmuihoih onika, hmuihoih kalbanumnawk to la ah loe, to hmuihoih hoi kaciim hmuihoihnawk to kangvan ah noek ah; ");
INSERT INTO cekak_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","to hmuihoih hmuennawk hoiah hmai thlaek koi hmuihoih loe hmuihoih sah kop kami khaeah sahsak ah; paloi thuh ah, to pacoengah loe kathoeng hoi ciimcai hmuihoih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Thoemtonawk to kadip puengah naep ah loe, nang kang hnukhaih, amkhuenghaih kahni im ih hnukung hmaa ah suem ah; hae loe nang hanah ciimcai koek ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","To tiah sak ih hmuihoih hoi kanghmong ah, nangmah han kalah hmuihoih to sah hmah; to loe Angraeng hanah nangcae khaeah ciimcai hmuen ah oh han oh. ");
INSERT INTO cekak_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Mi kawbaktih doeh hae baktih hmai thlaek koi hmuihoih to angmah hanah sah moe, patoh kami loe, acaeng thung hoiah pahnawt ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","khenah, Judah acaeng, Uri capa, Bazalel to ahmin hoiah ka kawk boeh; ");
INSERT INTO cekak_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","anih loe Sithaw ih Muithla, palunghahaih, kophaih, panoek thaihaih hoi congca bantok sak thaihaih hoiah ka koisak boeh. ");
INSERT INTO cekak_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Anih khaeah sui, sum kanglung hoi sum kamling sak thaihaih tok, ");
INSERT INTO cekak_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","thlung aah kophaih hoi thing aah kophaih tok, tok congca sak thaihaih to ka paek boeh. ");
INSERT INTO cekak_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Khenah, anih to abomh hanah Dan acaeng, Ahisamak capa Aholiah to ka paek boeh; palungha kaminawk mah kang thuih ih loknawk to sak o boih hanah, nihcae palung thungah palunghahaih to ka paek boeh; ");
INSERT INTO cekak_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","kaminawk amkhuenghaih kahni im, hnukung ah kaom thingkhong, to thingkhong nuiah kaom palungnathaih tangkhang hoi kahni im ih hmuennawk boih, ");
INSERT INTO cekak_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","caboi hoi hmuennawk, kaciim hmaithawk hoi paanghaih tungnawk boih, hmuihoih thlaekhaih hmaicam, ");
INSERT INTO cekak_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","hmai angbawnhaih hmaicam hoi hmuennawk boih, amsaehhaih sabae kathuk hoi pahnuthaih a khoknawk, ");
INSERT INTO cekak_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","toksakhaih khukbuennawk, qaima toksak naah, Aaron hoi a capanawk mah angkhuk han ih kaciim kahninawk, ");
INSERT INTO cekak_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","bawh ih situi hoi hmuenciim ah thlaek ih hmuihoih to sak hanah, nang khaeah kang thuih ih lok baktih toengah, nihnik mah sah hoi tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","kai loe nangcae ciimsakkung, Angraeng ah ka oh, tiah na panoek o moe, angzo han koi na caanawk dung khoek to, nangcae hoi kai salakah angmathaih ah oh hanah, Kai ih Sabbath to zaa oh, tiah Israel kaminawk khaeah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Sabbath ni loe nangcae han ciimcai pongah, zaa oh; Sabbath ni amhnongsak kami loe, paduek han oh; Sabbath niah toksah kami loe, acaeng thung hoiah pahnawt oh. ");
INSERT INTO cekak_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ni tarukto thung toksah oh, toe ni sarihto haih loe anghakhaih Sabbath niah oh moe, kaciim Angraeng ih niah oh; Sabbath niah toksah kami loe, paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","To pongah Israel kaminawk loe, angzo han koi a caanawk dung khoek to, dungzan lokkamhaih ah patoh hanah, Sabbath ni to zaa oh. ");
INSERT INTO cekak_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Hae loe Israel kaminawk hoi kai salakah dungzan angmathaih ah om tih; Angraeng mah ni tarukto thung van hoi long to sak moe, ni sarihto naah loe, toksah ai ah anghak pongah, tha oh let, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sinai mae ah Angraeng mah Mosi khaeah lokthuih pacoengah, Sithaw ih banpazung hoi tarik ih, hnukung ah kaom, thlung kangphaek hnetto, Mosi hanah a paek. ");
INSERT INTO cekak_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mae hoiah Mosi angzo tathuk ai boeh, tito kaminawk mah panoek o naah, kaminawk loe Aaron khaeah amkhueng o moe, anih khaeah, Angthawk ah; kaicae hmaa ah caeh hanah sithawnawk to na sah pae ah; Izip prae thung hoi kaicae zaehoikung Mosi loe, kawbang maw oh ving boeh, tito a panoek o ai boeh, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron mah nihcae khaeah, Na zunawk, na capanawk hoi na canunawk ih sui naa tangkraengnawk to angkhring oh loe, kai khaeah na sin oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","To pongah kaminawk boih mah angmacae ih sui naa tangkraeng to angkring o moe, Aaron khaeah sin pae o. ");
INSERT INTO cekak_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nihcae mah paek o ih hmuennawk to anih mah talawk boih moe, a sak pae pacoengah maitaw caa ih krang to a soi pae; Aw Israel, hae sithaw loe Izip prae thung hoiah nangcae zaehoikung sithawnawk boeh ni, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron mah to hmuen to hnuk naah, maitaw caa hmaa ah hmaicam maeto sak moe, Khawnbang loe Angraeng hanah poih sakhaih niah om tih, tiah kaminawk khaeah taphongsak. ");
INSERT INTO cekak_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","To pongah kaminawk loe khawnbang khawnthaw ah angthawk o moe, hmai angbawnhaih hoi angdaeh angbawnhaih to sak o; caak naek hanah anghnut o moe, hnawh hanah angthawk o. ");
INSERT INTO cekak_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","To naah Angraeng mah Mosi khaeah, Caeh tathuk ah, Izip prae thung hoiah na hoih ih kaminawk loe, amro o boih boeh; ");
INSERT INTO cekak_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","nihcae han ka thuih pae ih loklam to karangah angqoi o taak moe, angmacae han maitaw caa krang to a sak o boeh; to krang to bok o moe, angbawnhaih to a sak o pacoengah, Aw Israel kaminawk, hae sithaw loe Izip prae thung hoi nangcae zaehoikung sithaw ah ni oh o boeh, tiah a thuih o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Angraeng mah Mosi khaeah, Hae kaminawk hae ka hnuk boeh; nihcae loe palungthah kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","to pongah kaimah bueng na caehtaak ah; hmai baktih kamngaeh palungphuihaih hoiah nihcae to ka kanghsak moe, kam rosak boih han; to pacoengah nang hae kalen parai acaeng ah kang sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Toe Mosi mah angmah ih Angraeng Sithaw khaeah, Angraeng, tipongah na sak thaihaih, na ban thacakhaih hoiah Izip prae thung hoi na zaehhoih ih nangmah ih kaminawk to palungphuihaih hoiah nam rosak boih han loe? ");
INSERT INTO cekak_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Tipongah Izip kaminawk mah, Sithaw loe kasae poekhaih tawnh, to pongah ni nihcae to mae nuiah hum moe, long pum hoiah tamit boih hanah, a caeh haih, tiah thuih han koi ah oh ving loe? Hmai baktih kamngaeh palungphuihaih to dipsak ah loe, nangmah ih kaminawk nuiah sak han ih kasae poekhaih to dawnpakhuem raeh. ");
INSERT INTO cekak_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Na tamna Abraham, Issak hoi Israel khaeah, Na caanawk loe van ih cakaeh zetto kang pungsak moe, dungzan ah qawk na toep o thai hanah, long nuiah kaom hmuennawk boih kang paek han, tiah na thuih ih lok to pahnet hmah raeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","To naah Angraeng mah angmah ih kaminawk nuiah kasae sak han poekhaih to dawnpakhuem let. ");
INSERT INTO cekak_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mosi loe a ban ah hnukung thlung kangphaek hnetto sin moe, mae nui hoiah anghum tathuk; thlung kangphaek hnetto pongah, ahnuk ahmaa ca to tarik. ");
INSERT INTO cekak_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","To thlung kangphaek hnetto loe, Sithaw mah sak ih thlung kangphaek ah oh moe, Sithaw mah ni ca doeh tarik. ");
INSERT INTO cekak_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kaminawk hanghaih lok to Joshua mah thaih naah, Mosi khaeah, ataihaih ahmuen ah misatukhaih lok to ka thaih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mosi mah, To hanghaih lok loe misa pazawhaih lok na ai ni, misa sunghaih lok doeh na ai ah, laasakhaih lok ni ka thaih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ataihaih ahmuen taengah phak naah, Mosi mah maitaw caa hoi nawnto hnawh kaminawk to hnuk; hmai kamngaeh baktiah palung to phui pongah, a ban ih thlung kangphaek to a vah; mae tlim ah a vah phaeng. ");
INSERT INTO cekak_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Nihcae mah sak o ih maitaw caa to a lak moe, hmai thungah a vah pae; kadip puengah naep pae pacoengah, tui pongah phuih moe, Israel kaminawk to a naeksak. ");
INSERT INTO cekak_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Aaron khaeah, Hae tiah kalen zaehaih to sak hanah, nihcae mah na nuiah tih hmuen maw a sak o? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron mah, Ka angraeng, palungphuisak hmah; hae kaminawk loe kasae poekhaih a tawnh o, tito na panoek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Kai khaeah, Kaicae hmabang ah ka caeh o thai hanah, sithawnawk to na sah paeh, Izip prae thung hoi kaicae zaehoikung Mosi loe, kawbang maw oh boeh, tito a panoek o ai boeh, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","To pongah kai mah nihcae khaeah, Sui tawn kaminawk boih sui to angkhring oh loe, kai khaeah na paek oh, tiah ka naa. To naah nihcae mah sui to angkhring o moe, ang paek o; kai mah hmai thungah ka vah naah, maitaw caa ah angcoeng, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","(Aaron mah kaminawk to khen laek ai boeh pongah, a misanawk hmaa ah bangkrai ah ohsak), tito Mosi mah hnuk naah, ");
INSERT INTO cekak_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","to pongah Mosi loe ataihaih khongkha ah angdoet moe, Angraeng bangah angdoe kaminawk boih, kai khaeah angzo oh, tiah a naa. To naah Levi caanawk boih anih taengah amkhueng o. ");
INSERT INTO cekak_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","To pacoengah Mosi mah nihcae khaeah, Israel Angraeng Sithaw mah, Kami boih mah sumsen to avak nasoe; ataihaih ahmuen ih khongkha maeto hoi maeto boenghaih khoek to caeh nasoe loe, kami boih mah angmah ih nawkamya, angmah ih ampuinawk hoi angmah imtaeng kami to hum nasoe, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mosi mah thuih ih lok baktih toengah, Levinawk mah sak o; to na niah kami sang thumto duek o. ");
INSERT INTO cekak_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","To pacoengah Mosi mah, Angraeng mah vai hniah tahamhoihaih paek hanah, kami boih angmah ih capa hoi angmah ih nawkamya humhaih rang hoiah, vaihniah nangmah hoi nangmah to Angraeng khaeah nang paek o boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Khawnbang ah Mosi mah kaminawk khaeah, Kalen parai zaehaih to na sak o boeh; toe vaihi Angraeng khaeah ka caeh tahang moe, nangcae zae loihaih to ka sak thai thung ka sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","To pongah Mosi loe Angraeng khaeah caeh let, Aw, hae kaminawk loe kalen parai zaehaih to a sak o moeng boeh! Sui to angmacae hanah sithaw ah a sak o boeh. ");
INSERT INTO cekak_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Toe vaihiah nihcae zaehaih to tahmen raeh; a zae o haih na tahmen ai nahaeloe, na tarik ih cabu thung hoiah kai ih ahmin to phrae ving halat ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Angraeng mah Mosi khaeah, Ka hmaa ah zaehaih sah kami loe, anih ih ahmin to ka cabu thung hoiah ka phraek han. ");
INSERT INTO cekak_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Vaihi caeh ah loe, kang thuih ih ahmuen ah kaminawk to caeh haih ah; khenah, kai ih van kami to na hmaa ah caeh tih; nihcae thuitaekhaih atue to phak naah, a zae o haih pongah nihcae to ka thuitaek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aaron mah sak pae ih maitaw caa pongah, Angraeng mah kaminawk to nathaih hoiah thuitaek. ");
INSERT INTO cekak_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","To pacoengah Angraeng mah Mosi khaeah, Hae ahmuen hae caehtaak ah loe, Abraham, Issak hoi Jakob khaeah, Na caanawk khaeah ka paek han, tiah lokkam ih, prae thungah Izip prae thung hoi na zaehhoih ih kaminawk hoi nawnto caeh oh; ");
INSERT INTO cekak_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","kai ih van kami to na hmaa ah ka patoeh han, anih mah Kannaan, Amor, Hit, Periz, Hiv hoi Jebus kaminawk to haek boih tih. ");
INSERT INTO cekak_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Khoitui hoi tahnutui longhaih prae ah caeh oh; toe kai loe nangcae salakah ka caeh mak ai; palungthah kami ah na oh o pongah, loklam ah kam rosak boih moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kaminawk mah to baktih tamthang kasae to thaih o naah, palungset o moe, mi doeh amthoephaih khukbuen to angkhuk o ai. ");
INSERT INTO cekak_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Angraeng mah Mosi khaeah, Israel kaminawk khaeah hae tiah thui paeh; nangcae loe palungthah kami ah na oh o; nangcae hae nawnetta thung kang caeh haih nahaeloe, kam rosak boih moeng tih; nangcae to kawbang maw kang sak han, tiah ka panoek hanah, nam thoep o haih hmuennawk to angkhring oh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","To pongah Israel kaminawk mah Horeb mae ah amthoephaih hmuennawk to angkhring o boih. ");
INSERT INTO cekak_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mosi mah ataihaih ahmuen tasa bang, kangthla kue ahmuen ah, kahni im to sak moe, kaminawk amkhuenghaih kahni im, tiah a kawk. Angraeng pakrong han koeh kami boih loe, ataihaih ahmuen tasa bangah sak ih kaminawk amkhuenghaih kahni im ah caeh o nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mosi kahni im ah caeh naah, kaminawk boih angthawk o moe, angmacae kahni im thok taengah angdoet o; Mosi kahni imthung ah akun ai karoek to a khet o. ");
INSERT INTO cekak_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mosi kahni imthung ah akun naah, tamai tung loe kahni im akunhaih thok taengah krak tathuk; to naah Mosi hoi Angraeng to lok apaeh hoi. ");
INSERT INTO cekak_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kaminawk boih mah, kahni imthung akunhaih thok taengah angdoe tamai tung to hnuk o naah, kaminawk boih angmacae ih kahni im thok taengah angdoet o moe, a bok o. ");
INSERT INTO cekak_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kami mah angmah ih ampui hoi lok apaeh baktih toengah, Angraeng hoi Mosi doeh mikhmai kangtong ah lok apaeh hoi; to pacoengah Mosi loe a ohhaih ahmuen ah amlaem let; toe anih bomkung, thendoeng, Nun capa Joshua loe kahni im to caehtaak ai. ");
INSERT INTO cekak_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosi mah Angraeng khaeah, Khenah, Nang mah ih hae kaminawk to zaehhoih hanah nang thuih; toe kai abomh han kaminawk to nang panoeksak ai; na hmin to ka panoek moe, nang loe ka mikhnuk naakrak ah na oh, tiah nang naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","To pongah ka nuiah palung nang hoe nahaeloe, kai nang tahmen, tito ka panoek thai hanah, na loklam to na patuek ah; hae acaengnawk loe nang ih kami ni, tiah panoek poe ah, tiah a hnik. ");
INSERT INTO cekak_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Angraeng mah kang caeh o haih poe moe, anghakhaih kang paek o han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","To naah Mosi mah anih khaeah, Kai nang caeh haih ai nahaeloe, kaicae hae ahmuen hoiah na patoeh hmah. ");
INSERT INTO cekak_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kai hoi nang ih kaminawk loe, na hmaa ah mikcuk naakrak ah ni kho a sak o, tito kawbang maw panoek thai tih? Kaicae hoi nawnto na caeh naah na ai maw amtueng tih? To tiah ni kai hoi nang ih kaminawk loe long nuiah kaom kaminawk boih thung hoiah kalah ta kami ah om o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","To naah Angraeng mah Mosi khaeah, Na thuih ih lok baktih toengah ka sak han; nang loe ka mikcuk naakrak ah na oh; nang loe nangmah ih ahmin hoiah ni kang panoek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mosi mah anih khaeah, Vaihi na lensawkhaih amtuengsak ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Angraeng mah, Na hmaa ah Kaih ih hoihaihnawk boih to ka caehsak moe, Angraeng ih ahmin to na hmaa ah ka taphong han; tahmenhaih ka tawnh ih kaminawk nuiah tahmenhaih ka tawnh moe, tahmenhaih kam tuengsak ih kaminawk nuiah tahmenhaih to kam tuengsak han. ");
INSERT INTO cekak_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Toe ka mikhmai loe na hnu mak ai; ka mikhmai hnu kami loe, hing mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","To pacoengah Angraeng mah, Khenah, ka taengah ahmuen maeto oh; nang loe lungsong nuiah angdoe tih; ");
INSERT INTO cekak_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ka lensawkhaih amtueng naah, nang loe kakoi lungsong thungah kang suek moe, Ka laem ai karoek to, ka ban hoiah kang tamuep han. ");
INSERT INTO cekak_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ka ban to ka zuh naah loe, ka hnukbang to na hnu tih; toe ka mikhmai loe na hnu mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Angraeng mah Mosi khaeah, Na vah phaeng ih thlung kangphaek pongah tarik ih ca baktih toengah ka tarik let hanah, hmaloe ih baktih toengah thlung kangphaek hnetto sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Khawnbang khawnthaw ah amsak coek ah loe, Sinai mae ah daw tahang ah; maesom nuiah nangmah hoi nangmah to kai khaeah ang paek ah. ");
INSERT INTO cekak_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mi doeh angzo haih hmah, mi doeh mae nuiah hnuk han om hmah nasoe; tuu hoi maitawnawk doeh mae hmaa ah toep o hmah nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","To pongah anih mah hmaloe ih baktih toengah, thlung kangphaek hnetto a sak; Angraeng mah thuih ih lok baktih toengah, Mosi loe khawnbang khawnthaw ah angthawk moe, a ban ah thlung kangphaek hnetto sin pacoengah, Sinai mae nuiah dawh tahang. ");
INSERT INTO cekak_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","To naah Angraeng loe tamai thung hoiah anghum tathuk, to ah anih hoi nawnto angdoet moe, Angraeng ih ahmin to taphong. ");
INSERT INTO cekak_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mosi hmaa ah Angraeng to caeh moe, Amlunghaih, palungnathaih hoi kakoi Angraeng, palungsawk, thui laek ai hoihhaih hoi loktang hoiah kakoi, ");
INSERT INTO cekak_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","athawng asang kaminawk tahmenkung, zaehaih, sakpazaehaih hoi kahoih ai hmuen sakhaih tahmenkung, toe zaehaih sah kaminawk loe khensut ai ah; ampanawk ih zaehaih pongah a caanawk adung thumto hoi palito karoek to thuitaekkung, Angraeng Sithaw, tiah taphong. ");
INSERT INTO cekak_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mosi loe karangah long ah akuep moe, a bok. ");
INSERT INTO cekak_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Aw Angraeng, na mikcuk naakrak ah ka oh nahaeloe, Angraeng loe kaicae hoi nawnto caeh nasoe; hae kaminawk loe palungthah o, toe kaicae zaehaih hoi sakpazaehaihnawk to tahmen raeh ah loe, kaicae hae nangmah ih qawktoepkung ah na la ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","To pacoengah anih mah, Khenah, nangcae hoi lokmaihaih ka sak han; long nuiah kaom kaminawk boih hmaa ah, sak vai ai ih dawnraihaih to nang ih kaminawk boih mikhnuk ah ka sak han; nangcae khaeah ka sak han ih dawnrai hmuen loe zit thoh pongah, nang hoi nawnto kaom kaminawk mah Angraeng mah sak ih hmuen to hnu o tih. ");
INSERT INTO cekak_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Vai hniah kang thuih ih lok hae tahngai ah; khenah, Amor, Kannan, Hit, Periz, Hiv hoi Jebus kaminawk to nangcae hmaa ah ka haek han. ");
INSERT INTO cekak_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Na caeh han ih prae kaminawk hoi lokmaihaih na sak han ai ah, acoe ah; na sak moeng nahaeloe nihcae loe nangcae han thaang ah om o tih. ");
INSERT INTO cekak_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nihcae ih hmaicamnawk to phrae pae ah, krangnawk doeh paro pae ah loe, Asherah tungnawk doeh pakhruh pae ah. ");
INSERT INTO cekak_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kalah sithaw to bok hmah; anih ih ahmin loe, Ut panoek Angraeng; ut panoek Sithaw, tiah oh; ");
INSERT INTO cekak_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","to prae thungah kaom kaminawk hoi lokmaihaih na sak nahaeloe, nihcae loe angmacae ih sithawnawk khaeah a takpum to zaw o ueloe, angbawnhaih to sah o tih; nang doeh na kawk o ueloe, nihcae mah sak ih angbawnhaih moi to na caa moeng tih; ");
INSERT INTO cekak_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Na capanawk hanah nihcae ih canunawk zu ah na lak pae nahaeloe, a canunawk loe angmacae ih sithawnawk khaeah takpum zaw o ueloe, na capanawk doeh nihcae ih sithawnawk hoi zaehaih to sah o moeng tih. ");
INSERT INTO cekak_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Nangmah hanah krang to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Taeh thuh ai ih poih to sah ah. Kang paek ih lok baktih toengah, ni sarihto thung taeh thuh ai ih takaw to caa ah; Abib khrah phak naah sah ah; Abib khrah naah ni Izip prae thung hoiah na tacawt. ");
INSERT INTO cekak_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Zok thung hoi tapen tangsuek calu boih loe kai ih ni; tuu doeh, maitaw doeh, tapen tangsuek atae loe kai ih ni. ");
INSERT INTO cekak_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tapen tangsuek laa hrang to tuucaa hoiah akrang ah; na krang ai nahaeloe, laa hrang ih tahnong to khaek paeh. Tapen tangsuek na capanawk to akrang boih ah. Mi kawbaktih doeh ka hmaa ah bangkrai ah angzo hmah nasoe. ");
INSERT INTO cekak_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ni tarukto thung toksah ah loe, ni sarihto naah loe anghak ah; laikok atokhaih atue hoi cang aahhaih atue ah doeh, ni sarihto naah loe anghak ah. ");
INSERT INTO cekak_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Zarto boeng naah kathai tangsuek cang aahhaih poih to sah ah, cang pakhuenghaih poih doeh saning boeng naah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Na capa nongpanawk loe Angraeng Sithaw, Israel Sithaw hmaa ah, saningto naah vai thumto angphong o han angaih. ");
INSERT INTO cekak_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Acaeng kaminawk to na hmaa ah ka haek moe, na prae to ka kawksak han; na Angraeng Sithaw hmaa ah angphong hanah, saningto naah vai thumto na caeh naah, mi mah doeh na prae to khit mak ai. ");
INSERT INTO cekak_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Moi thii hoi taeh thuh ih hmuen hoiah kai khaeah angbawnhaih to sah hmah; loihaih poih sak ih angbawnhaih moi to akhawnbang khoek to suem hmah. ");
INSERT INTO cekak_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Na lawk thung ih athai tangsuek thingthai qumpo to na Angraeng Sithaw im ah sin ah; Maeh caa to amno ih tahnutui hoi nawnto thong hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Angraeng mah Mosi khaeah, Hae loknawk hae tarik ah; hae loknawk baktih toengah, nang hoi Israel kaminawk salakah lokmaihaih to ka sak, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosi loe buhcaa ai, tui doeh nae ai ah, Angraeng hoi nawnto ni qui pali, qum qui palito thung oh; to naah anih mah kaalok hato, lokmaihaih loknawk to thlung kangphaek pongah tarik. ");
INSERT INTO cekak_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mosi loe hnukung thlung kangphaek hnetto ban ah sin moe, mae nui hoiah anghum tathuk, Angraeng hoi nawnto lok apaeh hoi naah, angmah loe kampha angmah ih mikhmai to panoek ai. ");
INSERT INTO cekak_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron hoi Israel kaminawk boih mah Mosi to hnuk o naah, khenah, anih ih mikhmai loe ampha; to pongah anih khae anghnaih hanah a zit o. ");
INSERT INTO cekak_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Toe nihcae to Mosi mah kawk; to pongah Aaron hoi Israel zaehoikungnawk boih, anih khaeah angzoh o let, to tiah Mosi hoi nihcae to lok aram o. ");
INSERT INTO cekak_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","To pacoengah Israel kaminawk boih anih taengah anghnaih o moe, Sinai mae ah Angraeng mah paek ih kaaloknawk to nihcae khaeah thuih pae boih. ");
INSERT INTO cekak_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mosi mah nihcae khaeah lokthuih pae boih pacoengah, a mikhmai to khuk. ");
INSERT INTO cekak_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Toe Mosi loe Angraeng hoi lok apaeh hanah anih hmaa ah caeh kruek, tasa bang angzo let ai karoek to, a mikhmai khukhaih to takhoe ving; tasa bang angzoh pacoengah, anih khaeah thuih pae ih loknawk to Israel kaminawk khaeah a thuih pae patoeng. ");
INSERT INTO cekak_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","To naah kampha Mosi ih mikhmai to Israel kaminawk mah hnuk o; Mosi loe Angraeng hoi lok apaeh hanah caeh karoek to mikhmai to a khuk let. ");
INSERT INTO cekak_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosi mah Israel kaminawk maeto ah pakhueng boih pacoengah, nihcae khaeah, Na sak o hanah, Angraeng mah hae tiah thuih ih lok to oh. ");
INSERT INTO cekak_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ni tarukto thung toksah oh, toe ni sarihto naah loe nangcae han ciimcai ni, Angraeng ih Sabbath niah oh; mi kawbaktih doeh to niah toksah kami loe paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mi kawbaktih doeh Sabbath niah na ohhaih ahmuen ah hmaitik o hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mosi mah amkhueng Israel kaminawk boih khaeah, Angraeng mah hae tiah thuih; ");
INSERT INTO cekak_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","na tawnh ih hmuen Angraeng khaeah sin oh; mi kawbaktih doeh palunghuemhaih hoiah paek koeh kami loe sui, sum kanglung hoi sum kamling to Angraeng khaeah sin oh. ");
INSERT INTO cekak_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Rong kamiing, rong kamling hup, rong kathim, puu ngan hoi maeh muinawk, ");
INSERT INTO cekak_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kathim tuu hinnawk, caham hinnawk, shittim thingnawk, ");
INSERT INTO cekak_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","hmai paaang hanah olive situi, tak bawhhaih situi hoi hmai thlaek koi hmuihoih, ");
INSERT INTO cekak_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","palaeng ah avak ih kahni hoi saoek padaphaih kahni nuiah bet koi thlung hoi onyx thlungnawk to sin oh. ");
INSERT INTO cekak_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Nangcae thung ih palungha kaminawk to angzo o ueloe, Angraeng mah thuih ih lok baktih toengah hmuennawk, ");
INSERT INTO cekak_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","kahni im, buk, buk khukhaih, patomhhaih sumnawk, thingphaeknawk, takraenghaih thingnawk, tungnawk hoi a khok pahnuthaihnawk, ");
INSERT INTO cekak_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","lokkamhaih thingkhong, aputhaih thingnawk, palungnathaih tangkhang hoi khukhaih kahni, ");
INSERT INTO cekak_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","caboi hoi a khoknawk, a thungah kaom laom sabaenawk boih hoi hmaa bangah suek ih takaw, ");
INSERT INTO cekak_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","hmaithawk pa-aanghaih tungnawk, hmuennawk, hmaiimnawk hoi situinawk, ");
INSERT INTO cekak_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","hmaicam ah thlaek koi hmuihoih hoi tungnawk, tak bawhhaih situi hoi hmuihoih, kahni im akunhaih thok taengah payang ih kahni, ");
INSERT INTO cekak_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","angbawnhaih hmaicam hoi sum kamling vaizoek, a khoknawk hoi hmuennawk boih, tak amsaehhaih sabae kathuk hoi a khok, ");
INSERT INTO cekak_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","imthung longhma ah payang ih kahninawk, payanghaih tungnawk hoi a khok pahnuthaih tungnawk, longhma akunhaih ahmuen pakaahaih kahni, ");
INSERT INTO cekak_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","kahni im takhinghaih sumnawk, longhma takhinghaih sumnawk hoi quinawk, ");
INSERT INTO cekak_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","hmuenciim thungah toksak naah angkhuk ih kahni, qaima Aaron ih kaciim kahninawk hoi a capanawk ih kahninawk to sah pae tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","To pacoengah amkhueng Israel kaminawk loe Mosi hmaa hoiah amlaem o boih let. ");
INSERT INTO cekak_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Palung angthawk kaminawk, palunghuem kaminawk mah amkhuenghaih kahni im to sak o moe, toksakhaih hoi kaciim khukbuen to sak hanah, Angraeng han paek o ih hmuennawk to a sin o. ");
INSERT INTO cekak_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Palunghuem kaminawk loe nongpa doeh, nongpata doeh angzoh o boih moe, ban lakok, naa tangkraeng, bantuek, bungmunawk, sui hoi sak ih hmuennawk to a sin o; kami boih mah Angraeng paek hanah sui to sin o. ");
INSERT INTO cekak_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Rong kamiing, rong kamling hup, rong kathim, puu ngan, kathim tuu hinnawk, caham hinnawk doeh a sin o. ");
INSERT INTO cekak_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Sum kanglung hoi sum kamling sin kaminawk doeh, Angraeng han paek o; angaihaih ahmuen ah patoh hanah, kami boih mah shittim thing to sin o. ");
INSERT INTO cekak_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Lahat kaeh kop kaminawk mah, tlangqui kamiing, tlangqui kamling hup, tlangqui kathim hoi puu ngan to sin o. ");
INSERT INTO cekak_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Palunghuem moe, sak han koeh nongpatanawk boih mah, maeh mui to kaeh o. ");
INSERT INTO cekak_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Zaehoikungnawk mah atho kaom onyx thlungnawk, qaima ih palaeng ah avak ih kahni nuiah bet hanah kalah thlungnawk to sin o. ");
INSERT INTO cekak_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Hmuihoih, hmai paaang koi situi, tak bawhhaih situi to a sin o. ");
INSERT INTO cekak_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Palunghuemhaih katawn Israel kaminawk thung ih nongpa hoi nongpata boih, Angraeng mah Mosi patohhaih rang hoiah thuih ih tok congca hanah, Angraeng khaeah palunghuemhaih hoiah a paek o. ");
INSERT INTO cekak_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","To pacoengah Mosi mah Israel kaminawk khaeah, Khen oh, Angraeng mah Judah kami Hur capa Uri, Uri capa Bezalel to ahmin hoiah kawk boeh. ");
INSERT INTO cekak_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Anih to Sithaw ih Muithla, palunghahaih, panoek thaihaih hoi congca bantok sak kophaih hoiah koisak boeh. ");
INSERT INTO cekak_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Anih loe sui, sui kanglung hoi sum kamling sak kophaih tok, ");
INSERT INTO cekak_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","thlung kangphaek aah kophaih tok, thing nuiah krang thuk kophaih tok, tok congca sak thaihaih hoiah koisak boeh. ");
INSERT INTO cekak_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Dan acaeng, Ahisamak capa, Aholiab hanah to baktih sak kophaih tok hoi kami patuk kophaih to a paek let. ");
INSERT INTO cekak_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Nihcae loe palunghahaih, tok congca sak kophaih, krang thuk kophaih, tlangqui kamiing, tlangqui kamling hup, tlangqui kathim, puu ngan sah kop kami ih tok, tangnaeng sak kophaih, tok congca hoi bantok sak thaihaihnawk boih to paek boeh. ");
INSERT INTO cekak_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Angraeng mah thuih ih lok baktih toengah, kaciim ahmuen ah toksak hanah, Bezalel hoi Aholiab loe Angraeng mah paek ih tok congca kasah thaih kaminawk hoi nawnto toksah hoi tih, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","To pacoengah Bazalel hoi Aholiab to Angraeng mah toksak thaihaih paek ih kami, toksak han palung huem kaminawk hoi nawnto Mosi mah kawk. ");
INSERT INTO cekak_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Hmuenciim hoiah tok to sak hanah, Israel kaminawk mah paek o ih hmuennawk boih to Bezalel hoi Aholiab mah Mosi khaeah lak hoi. Kaminawk loe akhawnbang kruek angmacae palung angthawk baktih toengah hmuen to sin o. ");
INSERT INTO cekak_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","To pongah bantok sah kop kami, hmuenciim ah toksah kaminawk boih mah, angmacae toksakhaih to caeh o taak moe, ");
INSERT INTO cekak_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","nihcae mah Mosi khaeah, Angraeng mah toksak han thuih ih lok pong kamtlai ah, kaminawk mah hmuenmae to sin o, tiah thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","To pongah Mosi mah kaciim hmuen to sak hanah nongpa doeh, nongpata doeh hmuen sin han angai ai boeh, tiah a ohhhaih ahmuen boih ah taphongsak. To pongah kaminawk mah hmuen to sin o ai boeh. ");
INSERT INTO cekak_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","A tawnh o ih hmuennawk loe toksak haih hanah khawt amtlai boeh. ");
INSERT INTO cekak_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Toksah kaminawk thungah, bantok sah kop kaminawk mah puu kahni, rong kamiing, rong kamling hup, rong kathim hoi payang ih kahni hato sak o moe, to bantok sah kop kaminawk mah kahni nuiah cherubim krang to soi o. ");
INSERT INTO cekak_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","To ah payang ih kahninawk loe anghmong o boih; kahni loe dong pumphae, tazetto sawk moe, dong palito kawk. ");
INSERT INTO cekak_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Payang ih kahni pangato to maeto ah pacong moe, kalah pangato doeh maeto ah pacong let. ");
INSERT INTO cekak_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Payang ih kahni atom ah kahni maeto hoi maeto pacong naah patoh hanah, rong kamiing hoiah kangbuet luet akhaw to a sak, kalah kahni atom pongah doeh to tiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","To pacoengah payang ih kahni maeto atom ah kangbuet luet akhaw qui pangato a sak; maeto hoi maeto pacong thai hanah, kalah maeto kahni atom ah doeh akhaw qui pangato a sak let bae. ");
INSERT INTO cekak_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Sui hoiah Kahni maeto hoi maeto paconghaih kangbuet luet akhaw qui pangato a sak moe, kahni to pacong naah kahni im maeto ah angcoeng. ");
INSERT INTO cekak_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Kahni im ranuih to khuk hanah, payang ih kahni to maeh mui hoiah a sak; payang ih kahni hathlaito a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","To ah payang ih kahni hathlaito loe anghmong o boih; dong qui thumto sawk moe, dong palito kawk. ");
INSERT INTO cekak_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Payang ih kahni pangato loe maeto ah pacong moe, kalah kahni tarukto doeh maeto ah pacong let. ");
INSERT INTO cekak_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","To pacoengah payang ih kahni aqai ah kangbuet luet akhaw qui pangato a sak moe, kalah kahni maeto pongah doeh kangbuet luet akhaw qui pangato a sak let. ");
INSERT INTO cekak_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Kahni im maeto ah pacong hanah, sum kamling hoiah kangbuet luet akhaw qui pangato a sak let. ");
INSERT INTO cekak_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Kahni im ranuih to khuk hanah, rong kathim nok ih tuu tae ahin, to tuu tae ahin ranuih to khuk hanah caham hin to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Kahni im tapang to shittim thing hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Tapang thingphaek loe dong hato sawk moe, dong maeto pacoeng, ahap len. ");
INSERT INTO cekak_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Thingphaek loe hae bangah akhok maeto, ho bang ah akhok maeto, kangvan ah a sak; to tiah kahni im sakhaih thingphaek nuiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Kahni im aloih bang pakaa hanah, thingphaek pumphaeto a sak moe, ");
INSERT INTO cekak_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","thingphaek pumphaeto pongah akhok pahnuthaih kangbuet luet akhaw qui palito sum kanglung hoiah a sak; thingphaek maeto tlim ah akhok hnetto, a khok pahnuthaih akhaw hnetto oh; kalah thingphaek pongah doeh to tiah oh boih. ");
INSERT INTO cekak_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","To tiah kahni im aluek bang pakaa hanah thingphaek pumphaeto a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Thingphaek maeto pongah akhok pahnuthaih akhaw qui palito sak moe, thingphaek maeto tlim ah akhok hnetto a sak, to tiah kalah thingphaek maeto pongah doeh a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kahni im hnukbang pakaa hanah thingphaek tarukto a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Kahni im takii hnetto ah thingphaek hnetto a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","To im takii hnetto pakaahaih thingphaek hnetto, takung hoi tadong paconghaih to a sak moe, aqai paconghaih akhaw maeto pongah caehsak hmaek; to tiah im takii hnetto ah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","To ah thingphaek tazetto oh moe, sum kanglung hoi sak ih akhok pahnuthaih akhaw hathlai tarukto oh; thingphaek maeto tlim ah akhok pahnuthaih hnetto oh boih. ");
INSERT INTO cekak_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","To pacoengah kahni im takraenghaih to shittim thing hoiah a sak; kahni im hmaa maeto takraeng hanah takraenghaih thing pangato, ");
INSERT INTO cekak_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","kahni im maeto bang ih thingphaek takraenghaih thing pangato, a hnukbang ih thingphaek takraeng hanah takraenghaih thing pangato a sak let. ");
INSERT INTO cekak_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","A um takraeng haih hanah, hae bang hoi ho bang khoek to kapha thing to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Thingphaek boih sui tui pazut moe, takraenghaih thing qukhaih akhaw doeh sui hoiah a sak; takraenghaih thing doeh sui tui pazut boih. ");
INSERT INTO cekak_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Payang ih kahni to rong kamiing, rong kamling hup, rong kathim puu ngan hoiah a sak moe, bantok sah kop kaminawk mah a nuiah cherubim krang to soi o. ");
INSERT INTO cekak_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Shittim thing hoiah kahni payanghaih tung palito a sak moe, sui tui pazut boih; tung pongah banghhaih cakoih baktih kaom sum doeh sui hoiah a sak, akhok pahnuthaih akhaw palito loe sum kanglung hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kahni im akunhaih thok taengah payang hanah, kahni sah kop kaminawk mah, kahni to rong kamiing, rong kamling hup, rong kathim puu ngan hoiah sak o; ");
INSERT INTO cekak_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","tung pangato pongah cakoih baktih kaom sumnawk to a sak moe, tung ranuih hoi tungnawk to sui tui hoiah pazut boih; toe akhok pahnuthaih akhaw pangato loe sum kamling hoiah ni a sak. ");
INSERT INTO cekak_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bazalel mah lokkamhaih thingkhong to shittim thing hoiah sak; to thingkhong loe dong hnetto pacoeng, ahap sawk, dongto pacoeng, ahap kawk moe, dongto pacoeng, ahap sang. ");
INSERT INTO cekak_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Anih mah to thingkhong nui hoi athung boih, kaciim sui tui hoiah pazut moe, aqai to sui hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Sui hoiah kangbuet luet akhaw palito a sak moe, thingkhong taki maeto ah akhaw hnetto a suek, to tiah taki palito ah akhaw to sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","To pacoengah aputhaih thing to shittim thing hoiah a sak moe, sui tui pazut boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","To thingkhong to aput hanah, hae bang ih akhaw hoi ho bang ih akhaw thungah thing to a hawt. ");
INSERT INTO cekak_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Palungnathaih tangkhang loe kaciim sui hoiah a sak; dong hnetto pacoeng, ahap sawk moe, dongto pacoeng, ahap kawk. ");
INSERT INTO cekak_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","To pacoengah palungnathaih tangkhang nui aqai kangtaeng hnetto ah, daengh ih sui hoiah cherubim krang hnetto a sak; ");
INSERT INTO cekak_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","hae bang aqai kangtaeng ah cherub maeto, ho bang ih aqai kangtaeng ah cherub maeto a sak moe, palungnathaih tangkhang hoi aqai hnetto ah cherubim krang to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherubim hnik loe van bangah pakhraeh phok hoi tahang moe, palungnathaih tangkhang to a khuk hoi, mikhmai kangtong ah a oh hoi moe, palungnathaih tangkhang to khet hoi tathuk. ");
INSERT INTO cekak_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Shittim thing hoiah caboi to a sak; dong hnetto sawk, dongto kawk moe, dongto pacoeng, ahap sang. ");
INSERT INTO cekak_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Caboi to kaciim sui tui hoiah pazut moe, aqai to sui hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Aqai to ban tamsum maeto kakawk ah a sak moe, aqai boih sui hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","To caboi pongah akhaw palito sui hoiah a sak moe, a khok palito ranuih, caboi takii palito ah a suek. ");
INSERT INTO cekak_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Sui hoi sak ih akhawnawk loe caboi nuiah oh moe, caboi aputhaih thing hawthaih ahmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Caboi aputhaih loe shittim thing hoiah a sak moe, sui tui to pazut. ");
INSERT INTO cekak_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","To caboi nui ih sabaenawk, kathlahnawk, sabae thuknawk hoi tui lawnhaih hmuennawk loe sui hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hmaithawk paanghaih tung doeh kaciim sui, daengh ih sui hoiah a sak; tungnawk, tanghangnawk, boengloengnawk, apawk tangmuem hoi kanghmong krangnawk hoi apawknawk doeh to tiah a sak boih; ");
INSERT INTO cekak_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","hmaithawk paanghaih tung hoiah loe tanghang tarukto tacawt; hae bangah thumto, ho bang ah doeh thumto tacawt. ");
INSERT INTO cekak_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Tanghang maeto pongah almond thaih, apawk tangmuem, apawk hoi kanghmong boengloeng thumto oh moe, kalah tanghang thumto pongah doeh, to baktih krangnawk to oh boih toeng; to tiah tung maeto pongah tanghang tarukto tacawt. ");
INSERT INTO cekak_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Hmaithawk paanghaih tung pongah loe, almond thaih, apawk tangmuem hoi apawk baktih kaom, boengloeng palito oh. ");
INSERT INTO cekak_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Hmai paanghaih tung maeto pongah, tanghang tarukto tacawt, tanghang hnetto atlim ah loe apawk tangmuem baktih kaom maeto oh, to tiah hnetto haih hoi thumto haih pongah doeh oh boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Apawk tangmuem hoi tanghangnawk loe, hmai paanghaih tung maeto ah oh o boih moe, sui hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Hmaiim to sarihto ah a sak, taitaeh hoi maiphu suekhaih sabaenawk doeh sui hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Hmai paanghaih tung hoi hmuennawk boih loe sui talent maeto hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hmuihoih thlaekhaih hmaicam loe shittim thing hoiah a sak; dongto sawk, dongto kawk moe, dong hnetto sang; takinawk doeh shittim thing hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Hmaicam ranuih, tapang, takinawk to kaciim sui tui hoiah a sak moe, aqainawk doeh sui tui hoiah pazut boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Hmaicam aqai atlim ah hae bangah maeto, ho bang ah maeto, akhaw hnetto sui hoiah a sak; akhaw loe hmaicam aputhaih thing hawt hanah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Hmaicam aputhaih thing loe, shittim thing hoiah a sak moe, sui tui pazut boih. ");
INSERT INTO cekak_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","To pacoengah hmuihoih sah kop kaminawk mah hmuihoih to sak o baktih toengah, tak angnokhaih kaciim situi hoi hmaithlaek hanah kaciim hmuihoih to doeh a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Angbawnhaih hmaicam to shittim thing hoiah a sak, hmaicam loe taki palito oh; dong pangato sawk, dong pangato kawk moe, dong thumto sang. ");
INSERT INTO cekak_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Hmaicam taki palito nuiah takii maeto a sak boih; takiinawk doeh shittim thing hoiah a sak moe, sum kamling tui to pazut boih. ");
INSERT INTO cekak_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Hmaicam nui ih laomnawk, maiphu sohhaihnawk, tui bawhhaih boengloengnawk, moi thunhaih cakoih baktih kaom sumnawk, sabaenawk hoi hmuennawk boih loe sum kamling hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Hmaicam ih vaizoek to sum kamling hoiah a sak moe, hmaicam tlim a um ah a suek. ");
INSERT INTO cekak_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Sum kamling vaizoek ih taki palito pongah aputhaih thing to hawt hanah, sum kamling akhawnawk to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Aputhaih thing to shittim thing hoiah a sak moe, sum kamling tui to pazut. ");
INSERT INTO cekak_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Aputhaih thing to hmaicam aqai ih akhaw thungah a hawt; to hmaicam to ranuih hoi atlim akhaw taqawt hanah thingphaek hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Amkhuenghaih kahni im akunhaih thok taengah kamkhueng nongpatanawk mah patoh ih sum kamling hoi sak ih hmaidan to a lak moe, amsaehhaih sabae kathuk hoi angdoethaih akhok to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","To pacoengah longhmaa to a sak; aloih bang longhma pakaa hanah dong cumvaito kasawk payang ih kahni to puu tlangqui hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Tung pumphaeto oh moe, sum kamling hoi sak ih akhok pahnuthaih akhaw doeh pumphaeto oh; toe tung pong ih cakoih baktih kaom sumnawk hoi cungnawk loe sum kanglung hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Longhmaa aluek bang doeh dong cumvaito kasawk payang ih kahni hoi tung pumphaeto oh moe, sum kamling hoiah sak ih akhok pahnuthaih akhaw doeh pumphaeto oh; tungnawk pong ih cakoih baktih kaom sumnawk hoi cungnawk loe sum kanglung hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Niduem bangah loe dong qui pangato kasawk payang ih kahni to oh; tung hato oh moe, akhok pahnuthaih akhaw hato oh; tungnawk pong ih cakoih baktih kaom sumnawk hoi cungnawk loe sum kanglung hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ni angyae bangah doeh dong qui pangato oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Akunhaih khongkha maeto bang pakaa hanah dong hathlai pangato kasawk payang ih kahni to oh moe, tung thumto pacoengah, akhok pahnuthaih akhaw thumto doeh oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Khongkha hae bang hoi ho bang to pakaa hanah, dong hathlai pangato kasawk payang ih kahni to oh moe, tung thumto hoi akhok pahnuthaih akhaw thumto doeh oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Longhma kangkui ah payang ih kahninawk loe, puu ngan tlangqui hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Tungnawk pahnuthaih akhaw loe, sum kamling hoiah a sak; tungnawk pong ih cakoih baktih kaom sumnawk hoi cungnawk loe sum kanglung hoiah a sak; tung ranuih loe sum kanglung hoiah a sak boih; longhmaa ih tungnawk boih doeh sum kanglung hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Longhmaa akunhaih khongkha taengah payang ih kahni loe, rong kamiing, rong kamling hup, rong kathim puu ngan hoiah a sak; kahni sah kop kaminawk mah a sak o; kahni loe dong pumphaeto sawk moe, longhmaa ah payang ih kahni baktih toengah, dong pangato sang. ");
INSERT INTO cekak_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Tung palito oh moe, sum kamling hoi sak ih a khok pahnuthaih akhaw palito oh; tungnawk pong ih cakoih baktih kaom sumnawk hoi cungnawk loe sum kanglung hoiah a sak moe, tung ranuih to sui tui hoiah pazut. ");
INSERT INTO cekak_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Longhmaa taeng boih ih takhinghaih sumnawk loe sum kamling hoiah a sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hae loe Mosi mah thuih ih lok baktih toengah, qaima Aaron ih capa Ithmar zaehhoihaih thungah, Levi kaminawk mah tarik ih kahni im, hnukung kahni im sak naah patoh ih hmuennawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Judah acaeng Hur capa Uri, Uri capa Bazalel loe, Angraeng mah Mosi khaeah thuih pae ih loknawk baktih toengah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Anih hoi nawnto toksah kami, Dan acaeng Ahisamak capa Aholiab loe, ban hoiah daengh moe, krang soi thaihaih tok, bantok congca sah kop kami, tlangqui kamiing, tlangqui kamling hup, tlangqui kathim puu ngan nuiah a aem takaekhaih sah kop kami ah oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hmuenciim sak naah patoh han paek o ih suinawk boih loe, hmuenciim ih shekel tahhaih hoiah tah naah, talent pumphae takawtto hoi shekel cumvai sarih, qui thumto oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Kroek ih rangpui kaminawk mah paek o ih sum kanglung loe, hmuenciim ih shekel tahhaih hoiah tah naah, talent cumvaito oh, shekel ah tah naah loe sang cumvai sarih, qui sarih, pangato oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Milu kroek tangcae, saning pumphaeto hoi ranuih bang kami boih mah, hmuenciim ih shekel tahhaih pongah, bekah maeto pacoeng, shekel ahap paek o boih, saning pumphae ranuih nongpa boih kami sang cumvai taruk, sang thum, cumvai pangato pacoeng, qui pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Hmuenciim akhok pahnuthaih ahmuen hoi payang ih kahni tung pahnuthaih ahmuen to sak hanah, sum kanglung talent cumvaito patoh; akhok pahnuthaih maeto naah talent maeto, akhok pahnuthaih cumvaito hanah talent cumvaito patoh. ");
INSERT INTO cekak_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Shekel sang, cumvai sarih, qui sarih, pangato loe, tung pong ih cakoih baktih kaom sumnawk hoi cungnawk to sak hanah patoh moe, tung ranuih to kahoih ah a pathoep. ");
INSERT INTO cekak_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Paek o ih sum kamling loe, talent qui sarihto oh moe, shekel sang hnet, cumvai palito oh. ");
INSERT INTO cekak_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Sum kamling loe kami amkhuenghaih kahni im thok tung pahnuthaih akhaw, sum kamling hmaicam, sum kamling vaizoek hoi hmaicam ah patoh ih hmuennawk boih sak naah patoh. ");
INSERT INTO cekak_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Longhmaa pakaahaih tung pahnuthaih akhawnawk, longhmaa ih khongkha tung pahnuthaih akhawnawk, kahni im taeng boih takhuekhaih sumnawk hoi longhmaa kangkui ah takhuekhaih sumnawk boih sak haih hanah doeh patoh. ");
INSERT INTO cekak_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hmuenciim ah toksak hanah, tlangqui kamiing, tlangqui kamling hup, tlangqui kathim hoi laihaw to a sak o; Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Aaron han kaciim laihaw to sak pae o. ");
INSERT INTO cekak_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Palaeng ah avak ih kahni loe sui, rong kamiing, rong kamling hup, rong kathim puu ngan hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Sui to kangphaek daek ah daengh o moe, sui to aqui ah aah pacoengah rong kamiing, rong kamling hup, rong kathim puu ngan pongah a bet o. ");
INSERT INTO cekak_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Palaeng ah avak hanah kahni to sak pae o moe, atom hnetto pacong pae o pacoengah nawnto huih pae o. ");
INSERT INTO cekak_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Angraeng mah Mosi khaeah thuih pae ih lok baktih toengah, kahni sah kop kaminawk mah sak ih kaeng zaenghaih kazii doeh, kahni baktih toengah palaeng ah avak ih kahni nuiah sui to bet o moe, rong kamiing, rong kamling hup, rong kathim puu ngan hoiah a sak o. ");
INSERT INTO cekak_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Onyx thlung to sak o moe, sui thungah bet o; bantuek nuiah ca tarik ih baktih toengah, Israel caanawk angmathaih ahmin to tarik o. ");
INSERT INTO cekak_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Angraeng mah thuih ih lok baktih toengah, Israel caanawk to panoek poe hanah, palaeng hnetto nuiah avak ih kahni pongah bet o. ");
INSERT INTO cekak_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kaahni to sui, rong kamiing, rong kamling hup, rong kathim puu ngan hoiah a sak o baktih toengah, saoep khukhaih kahni doeh kahoih ah a sak o. ");
INSERT INTO cekak_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Saoek khukhaih kahni loe hnetto ah pakhraep o; karto sawk moe, karto kawk; ahnuk ahmaa kangvan taki palito oh. ");
INSERT INTO cekak_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","To saoek khukhaih kahni nuiah ahmuen palito kangphaeng ah thlung to bet o; ahmuen maeto pongah sardium thlung, topaz thlung, beryl thlung to a bet o. ");
INSERT INTO cekak_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ahmuen hnetto haih pongah loe emerald thlung, sapphir thlung hoi diamond to a bet o. ");
INSERT INTO cekak_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ahmuen thumto haih pongah loe, Jacin, anagate hoi amethi thlung to bet o. ");
INSERT INTO cekak_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ahmuen palito pongah loe beryl, onyx hoi jasper thlungnawk to bet o; to thlungnawk loe sui hoi kacakah bet o boih. ");
INSERT INTO cekak_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Bantuek nuiah ahmin tarik ih baktih toengah, to thlungnawk nuiah doeh Israel acaeng hathlai hnetto ahmin to tarik o; thlung maeto nuiah ahmin maeto, thlung hathlai hnetto nuiah acaeng hathlai hnetto ahmin to tarik o boih. ");
INSERT INTO cekak_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Saoek khukhaih kahni nui ih aqai ah kaciim sui qui to zaeng o. ");
INSERT INTO cekak_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Sui hoi sak ih apawk kaom suiqui hnetto, sui hoi sak ih kangbuet luet akhaw hnetto doeh a sak o moe, kangbuet luet hnetto loe saoek khukhaih kahni aqai ah bangh o. ");
INSERT INTO cekak_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Aqai kangtaeng koek saoek padaphaih nui ih akhaw kangbuet luet hnetto thungah pakhui ih sui qui hnetto a suek o. ");
INSERT INTO cekak_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Aqai ah bangh ih suiqui loe sui hoi sak ih apawk kaom suiqui pongah pathlet o moe, palaeng avak ih kahni hmaa bangah bang o. ");
INSERT INTO cekak_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Sui hoiah kangbuet luet akhaw hnetto sak o moe, kahni tlim ah kaom, palaeng ah avak ih kahni aqai hnetto ah a suek o. ");
INSERT INTO cekak_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kalah kangbuet luet akhaw hnetto sui hoiah sak o let moe, hmaa bangah avak ih kahni tlim hoi kaengkaeh zaenghaih ranuih paconghaih ahmuen, kahni aqai hnetto ah suek o. ");
INSERT INTO cekak_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Saoek khukhaih palaeng ah avak ih kahni nui ih sui hoi sak ih kangbuet luet hnetto loe, kahni nuiah kaom sui hoi sak ih kangbuet luet hnetto hoi nawnto pacong o moe, rong kamiing qui hoiah pathlet o; Angraeng mah Mosi khaeah thuih pae ih lok baktih toengah, saoek khukhaih avak ih kahni loe, kahni hoi amhoesak han om ai pongah, kaengkaeh zaenghaih kazii ranuih ah suek o. ");
INSERT INTO cekak_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Palaeng avak ih kahni loe kahni sah kop kami mah, rong kamiing hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kahni loe lu hawthaih akhaw to oh moe, to akhaw to angsih han ai ah, a taeng boih to a huih. ");
INSERT INTO cekak_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","To pacoengah atom ah rong kamiing, rong kamling hup, rong kathim puu ngan hoiah sak ih, pomegranat thingthai krang to a bet thuih. ");
INSERT INTO cekak_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Kaciim sui hoiah dar krangnawk to a sak moe, kahni atom ih pomegranat thaih salakah a bet. ");
INSERT INTO cekak_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, toksakhaih kahni loe, kahni atom kangkui ah dar krang maeto pacoengah, Pomegranat thaih maeto, dar krang maeto pacoengah, pomegranat maeto, tiah a sak. ");
INSERT INTO cekak_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Aaron hoi a caanawk hanah doeh, a nuiah angkhuk ih laihaw kalen to puu ngan hoiah a sak pae, ");
INSERT INTO cekak_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","to pacoengah kahoih puu ngan hoiah sak ih lumuek to a sak pae, kahoih puu ngan hoiah sak ih lu zaenghaih a sak pae moe, a thung ih canghnawh doeh kahoih puu ngan hoiah a sak pae. ");
INSERT INTO cekak_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, kaeng ah zaeng ih kazii doeh rong kamiing, rong kamling hup, rong kathim puu ngan hoiah a aem sah thaih kami mah a sak pae. ");
INSERT INTO cekak_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Sabae hoi kaciim lumuek to kaciim sui tui hoiah a sak; bantuek nuiah tarik ih ca baktih toengah, a nuiah ca tarik o; ANGRAENG HAN CIIMCAIHAIH, tiah tarik o. ");
INSERT INTO cekak_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, rong kamiing hoiah lumuek to pathlet o. ");
INSERT INTO cekak_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","To tiah kaminawk amkhuenghaih kahni im toksakhaih to pacoeng o boih; Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Israel kaminawk boih mah a sak o. ");
INSERT INTO cekak_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","To pacoengah Israel kaminawk mah, kahni im, im sakhaih hmuennawk boih, sui hoi sak ih kangbuet luet akhawnawk, thingphaeknawk, takraenghaih thingnawk, tungnawk hoi tung pahnuthaih akhawnawk, ");
INSERT INTO cekak_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","khuk hanah kathim rong tui nup ih tuu tae ahinnawk, khukhaih caham hinnawk hoi payang ih kahninawk, ");
INSERT INTO cekak_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","hnukung ah kaom thingkhong, thingkhong aputhaih thing hoi palungnathaih tangkhang khukhaih, ");
INSERT INTO cekak_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","caboi hoi caboi nui ih hmuennawk boih, hmaa bangah suek ih takaw, ");
INSERT INTO cekak_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kaciim hmaithawk paanghaih tungnawk, hmaiimnawk, to ah kaom hmuennawk boih, hmai paanghaih situi, ");
INSERT INTO cekak_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","sui hoi sak ih hmaicam, tak bawhhaih situi, hmaithlaek han ih hmuihoih, kahni im akunhaih thok taengah payang ih kahni, ");
INSERT INTO cekak_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","sum kamling hoi sak ih hmaicam, sum kamling hoi sak ih vaizoek, aputhaih thingnawk hoi hmuennawk boih, ");
INSERT INTO cekak_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","longhma ah payang ih kahninawk, tungnawk, khok pahnuthaih akhawnawk, longhma akunhaih khongkha taengah payang ih kahni, quinawk hoi takhuekhaih sumnawk, kahni im sak naah patoh ih hmuennawk boih, kaminawk amkhuenghaih kahni im, ");
INSERT INTO cekak_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","hmuenciim ah toksak naah angkhuk han ih laihawnawk, qaima tok to sak hanah, qaima Aaron hoi a caanawk hanah kaciim laihawnawk to sak o moe, Mosi khaeah a sin pae o. ");
INSERT INTO cekak_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Angraeng mah Mosi khaeah thuih pae ih lok baktih toengah, Israel kaminawk mah tok to sak o boih. ");
INSERT INTO cekak_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mosi mah toksakhaih to khet naah, nihcae loe Angraeng mah thuih ih lok baktih toengah, toksak pacoeng o boeh, tiah a hnuk; to pongah Mosi mah nihcae to tahamhoihaih paek. ");
INSERT INTO cekak_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Kaminawk amkhuenghaih kahni im to, khrah hmaloe koek, ni tangsuek naah sah ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Hnukung thingkhong loe, to kahni imthung ah suem ah, to thingkhong loe payang ih kahni hoiah khuk ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","A thungah caboi suem ah loe, hmuennawk boih caboi nuiah suem ah; to pacoengah hmaithawk paanghaih tung to suem ah loe, hmai to paaang ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Hmuihoih thlaekhaih hmaicam to hnukung thingkhong hmaa ah suem ah loe, kahni im akunhaih khongkha ah payang ih kahni hoiah pakaa ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Amkhuenghaih kahni im akunhaih khongkha hmaa ah, hmai angbawnhaih hmaicam to suem ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kaminawk amkhuenghaih kahni im hoi hmaicam salakah sabae kathuk to suem ah loe, a thungah tui to lawn ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Longhma taeng to paka boih ah loe, longhma akunhaih khongkha taengah kahni to payang ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Tak bawhhaih situi to la ah loe, kahni im hoi a thungah kaom hmuennawk to nok boih ah; to ih hmuennawk to ciimsak boih ah, to tiah ni kahni im to ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","To pacoengah hmai angbawnhaih hmaicam hoi hmuennawk to situi nok boih ah loe, hmaicam to ciimsak ah; to tiah ni kaciim koek hmaicam ah om tih. ");
INSERT INTO cekak_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kathuk sabae hoi pahnuthaih a khok to situi nok ah loe, ciimsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Aaron hoi a caanawk to amkhuenghaih kahni im khongkha ah caehhaih ah loe, tui amhlusak ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Aaron hanah kaciim kahni to angkhuksak ah, qaima toksak thai hanah, situi to nok ah loe ciimsak ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Anih ih caanawk to angzo haih ah loe, laihaw kasawk to angkhuksak ah. ");
INSERT INTO cekak_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Kai khaeah qaima tok a sak o thai hanah, ampa situi hoi na bawh baktih toengah, a caanawk doeh bawh ah; a caanawk dung khoek to qaima ah oh poe han ih ni nihcae to situi hoiah na bawh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Angraeng mah thuih ih lok baktih toengah, Mosi mah hmuennawk to sak boih. ");
INSERT INTO cekak_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","To pongah saning hnetto haih, khrah tangsuek, ni hmaloe koek ah, Mosi mah kahni im to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosi mah kahni im sak naah, akhok pahnuthaih hmuennawk to kacakah a sak, thingphaeknawk to a sak moe, takraenghaih thingnawk to sak pacoengah, tungnawk to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","To pacoengah kahni im to payuengh moe, Angraeng mah thuih ih lok baktih toengah, kani im ranuih to a khuk. ");
INSERT INTO cekak_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Hnukung thingkhong to a lak moe, to thingkhong nuiah aputhaih thing to a hawt pacoengah, palungnathaih tangkhang to a nuiah suek. ");
INSERT INTO cekak_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Thingkhong to kahni imthung ah a sin moe, Angraeng mah thuih ih lok baktih toengah, hnukung thingkhong to payang ih kahni hoiah a khuk. ");
INSERT INTO cekak_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mosi mah caboi to amkhuenghaih kahni imthung aluek bang, payang ih kahni tasa bangah a suek. ");
INSERT INTO cekak_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Angraeng hmaa ah takaw to a suek pae. ");
INSERT INTO cekak_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Hmaithawk paaanghaih tung doeh kahni imthung, kahni im aloih bang ah a suek. ");
INSERT INTO cekak_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Angraeng mah thuih ih lok baktih toengah, Angraeng hmaa ah hmaiim to paaang. ");
INSERT INTO cekak_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mosi mah sui hmaicam to amkhuenghaih kahni imthung, payang ih kahni hmaa ah a suek. ");
INSERT INTO cekak_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Angraeng mah thuih ih lok baktih toengah, to ah hmuihoih to a thlaek. ");
INSERT INTO cekak_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","To pacoengah kahni im akunhaih thok taengah kahni to payang. ");
INSERT INTO cekak_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Kaminawk amkhuenghaih kahni im akunhaih thok taengah hmai angbawnhaih hmacam to a suek moe, Angraeng mah thuih ih lok baktih toengah, to hmaicam nuiah hmai angbawnhaih hoi cang angbawnhaih to a sak. ");
INSERT INTO cekak_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Amkhuenghaih kahni im hoi hmaicam salakah, sabae kathuk to a suek moe, amsaehhaih tui to a lawn. ");
INSERT INTO cekak_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mosi, Aaron hoi a caanawk loe to ih tui hoiah khok bannawk to amsaeh o; ");
INSERT INTO cekak_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","amkhuenghaih kahni imthung ah akun o moe, hmaicam taengah a caeh o naah, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, nihcae loe tui hoiah amsaeh o. ");
INSERT INTO cekak_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","To pacoengah Mosi mah hmaicam hoi longhma pakaahaih kahni to payang; longhma akunhaih khongkha taengah kahni to payang. To tiah Mosi mah toksakhaih to pacoeng. ");
INSERT INTO cekak_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","To naah amkhuenghaih kahni im to tamai mah khuk, kahni im loe Angraeng lensawkhaih hoiah koi. ");
INSERT INTO cekak_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Amkhuenghaih kahni im to tamai mah khuk khoep pongah, Mosi loe kahni imthung ah akun thai ai; to naah kahni im loe Angraeng lensawkhaih hoiah koi. ");
INSERT INTO cekak_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israel kaminawk kholong caeh o naah, kahni im nui hoiah tamai angkhoeng pacoengah ni a caeh o vop; ");
INSERT INTO cekak_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","tamai angkhoeng tahang ai nahaeloe, tamai angkhoeng tahang ai karoek to, kholong caeh o ai. ");
INSERT INTO cekak_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Israel kaminawk kholong caeh o nathung, nihcae boih mikhnuk ah, athun naah Angraeng ih tamai to kahni im nuiah oh, khoving naah loe tamai nuiah hmai to oh. ");
INSERT INTO cekak_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Angraeng mah Mosi to kawk moe, amkhuenghaih kahni im hoiah lok to thuih pae; anih khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Israel kaminawk khaeah hae tiah thui paeh; mi kawbaktih doeh Angraeng paek hanah hmuenmae to sin o nahaeloe, maitaw, tuu hoi maeh to sin o han oh. ");
INSERT INTO cekak_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Maitaw hoi hmai angbawnhaih sah nahaeloe, coek koi kaom ai atae to paek nasoe; Angraeng ih palung tongh hanah, kaminawk amkhuenghaih kahni im akunhaih thok taengah paek nasoe. ");
INSERT INTO cekak_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Paekkung loe hmai angbawnhaih ah sak ih maitaw lu nuiah a ban to koeng han oh; to tiah ni to maitaw to anih mah zae tahmen hanah sak ih angbawnhaih ah talawk pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Anih mah maitaw tae to Agraeng hmaa ah bop tih: Aaron capa qaimanawk mah maitaw thii to sin o ueloe, amkhuenghaih kahni im thok taeng ih hmaicam nuiah haeh o tih. ");
INSERT INTO cekak_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Anih mah hmai angbawnhaih sak ih maitaw ahin to khok ueloe, moi to ahap ahap ah takroek tih. ");
INSERT INTO cekak_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Aaron capa qaimanawk mah hmaicam pongah hmai to tik o ueloe, thing doeh hmaicam nuiah tik o tih; ");
INSERT INTO cekak_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","to pacoengah Aaron capa qaimanawk mah, ahap ahap ah takroek ih angan, alu hoi athawknawk to hmaicam nuiah tik ih hmai thungah pakhaem o tih; ");
INSERT INTO cekak_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","takoh moi hoi akhoknawk to tui hoiah pasae o ueloe, qaima mah hmaicam nuiah pakhaem tih; hae loe Angraeng khaeah hmuihoih ah paek ih, hmai angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Hmai angbawnhaih to tuu hoiah maw, to tih ai boeh loe maeh hoiah maw sah nahaeloe, coek koi kaom ai atae to paek han oh. ");
INSERT INTO cekak_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Tuu hoi maeh loe hmaicam aluek bang ih Angraeng hmaa ah bop tih; to pacoengah qaimanawk, Aaron capanawk mah athii to hmaicam taengah haeh o boih tih. ");
INSERT INTO cekak_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Moi to ahap ahap ah takroek o ueloe, qaima mah alu hoi athawk to hmaicam nuiah tik ih hmai pongah koeng tih; ");
INSERT INTO cekak_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","toe takoh hoi akhoknawk loe tui hoi pasaeh o pacoengah, qaima mah sin ueloe, hmaicam nuiah pakhaem tih; hae loe Angraeng khaeah hmuihoih ah paek ih hmai hoi sak ih angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Tavaanawk hoiah Angraeng khaeah hmai angbawnhaih to sah nahaeloe, pahuu maw, to tih ai boeh loe im ah pacah ih pahuu to sin o ah loe sah oh. ");
INSERT INTO cekak_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","To angbawnhaih hmuen loe qaima mah hmaicam ah sin tih, tahnong takroek pacoengah, hmaicam nuiah hmai hoiah pakhaem tih; athii loe hmaicam taengah krai tih; ");
INSERT INTO cekak_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","taprok pacoengah, taqawn hoi amuinawk to hmaicam taeng ih maiphu suekhaih ahmuen ah va tih; ");
INSERT INTO cekak_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","pakhraeh to takroek ai ah a taak to pakhoih ueloe, qaima mah hmaicam nuiah tik ih thing nuiah hmai pakhaem tih; hae loe Angraeng khaeah hmuihoih ah paek ih, hmai hoi sak ih angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Mi kawbaktih doeh Angraeng khaeah cang hoi angbawnhaih sah nahaeloe, kahoih takaw dip to paek ah; takaw dip nuiah situi to bawh ah loe, hmuihoih to a nuiah suem ah; ");
INSERT INTO cekak_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","qaima Aaron capanawk khaeah sin ah loe, qaima mah takaw ban tamsum maeto, situi hoi hmuihoihnawk to la boih ueloe, panoek poe hanah to hmuennawk to hmaicam nuiah hmai hoiah thlaek tih; to naah Angraeng khaeah hmuihoih ah paek ih, hmai hoi sak ih angbawnhaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kamtlai takaw dip hoiah sak ih angbawnhaih loe, Aaron hoi a capanawk hanah om tih; hae loe Angraeng khaeah hmai hoiah sak ih angbawnhaih thungah kaciim koek ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Camphaek laom pongah haek ih takaw hoi angbawnhaih sah nahaeloe, situi hoi atok ih taeh thuh ai ih takaw dip, to tih ai boeh loe taeh thuh ai situi bawh ih takaw kaenawk to sin ah. ");
INSERT INTO cekak_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Camphaek laom pongah haek ih takaw hoiah angbawnhaih sah nahaeloe, taeh thuh ai situi hoi atok ih kahoih takaw dip hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Takaw to a aeh pacoengah situi hoi bawh ah; to loe cang hoi sak ih angbawnhaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Camphaek laom pongah haek ih takaw hoi angbawnhaih sah nahaeloe, situi hoi atok ih kahoih takaw dip hoiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","To baktih caak koi hoi congca angbawnhaih to Angraeng khaeah sin ah loe, qaima khaeah paek ah; anih mah hmaicam ah sin tih. ");
INSERT INTO cekak_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Qaima mah angbawnhaih sak ih hmuen thung hoiah panoek poe hanah thoemto hmuen to la ueloe, hmaicam nuiah hmai hoiah thlaek tih; hae loe Angraeng khaeah hmuihoih ah paek ih, hmai hoi sak ih angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kamtlai cang hoi sak ih angbawnhaih loe, Aaron hoi a capanawk hanah om tih; hae loe Angraeng khaeah hmuihoih ah paek ih, hmai angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Angraeng khaeah paek ih takaw boih taeh thuh hmah; Angraeng khaeah hmai angbawnhaih sak naah, taeh doeh, khoitui doeh hmai pakhaem hmah. ");
INSERT INTO cekak_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Thingthai tangsuek hoi angbawnhaih sak hanah, kathai hmaloe koek to Angraeng khaeah sin ah, toe hmuihoih paek hanah hmaicam nuiah hmai hoi thlaek hmah. ");
INSERT INTO cekak_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Cang hoi sak ih angbawnhaih hmuen to paloi thuh boih ah; cang hoi sak ih angbawnhaih hmuen nuiah na Sithaw ih lokmaihaih paloi thuh han pahnet hmah; na paek ih hmuen boih paloi thuh ah. ");
INSERT INTO cekak_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Thingthai hmaloe koek hoiah Angraeng khaeah angbawnhaih na sak nahaeloe, hmai pongah haek moe, daengh ih cang to paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","A nuiah situi bawh ah loe hmuihoih to suem ah; hae loe cang hoi angbawnhaih sak ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Qaima mah panoek poe hanah daengh ih cang thoemto hoi situi thoemto la ueloe, atok pacoeng ah hmuihoihnawk hoi nawnto hmai qoeng tih; to loe Angraeng khaeah sak ih hmai angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kami maeto mah maitaw hoi angdaeh angbawnhaih sah nahaeloe, coek koi kaom ai maitaw tae, to tih ai boeh loe maitaw tala to Angraeng khaeah paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Anih mah paek ih maitaw lu nuiah a ban to koeng ueloe, rangpui amkhuenghaih kahnim im thok taengah bop tih; to pacoengah Aaron capa qaimanawk mah athii to hmaicam taeng boih ah haeh o tih. ");
INSERT INTO cekak_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Angdaeh angbawnhaih sak hanah, tazae taqawn kakhuk athawknawk hoi tazae taqawn nui ih athawknawk boih, ");
INSERT INTO cekak_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","pakae hnetto hoi a nuiah kaom athawknawk, panak taeng ih athawknawk, pathin nui ih athawknawk hoi pakaenawk to nawnto la ah loe, Angraeng khaeah hmai angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","To pacoengah Aaron capanawk mah hmaicam ah tik ih hmai nuiah, hmai angbawnhaih ah sak ih moi hoi nawnto hmai pakhaem tih; to loe Angraeng khaeah hmuihoih ah paek ih hmai hoi sak ih angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Tuu hoi angdaeh angbawnhaih sah nahaeloe, coek koi kaom ai, tuu khongkha thung ih tuu tae maw, to tih ai boeh loe tuu tala hoiah maw sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Tuucaa hoi angbawnhaih sah nahaeloe, Angraeng hmaa ah paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Anih mah paek ih tuu lu nuiah a ban to koeng ueloe, rangpui amkhuenghaih kahni im hmaa ah bop tih; Aaron capanawk mah athii to hmaicam taeng boih ah haeh o tih. ");
INSERT INTO cekak_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Tazae taqawn kakhuk athawknawk hoi tazae taqawn nui ih athawknawk boih, athawk hoi kaenghuh taeng ih ngannawk to la ah, angdaeh angbawnhaih sak hanah, ");
INSERT INTO cekak_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","pakae hnetto hoi a nuiah kaom athawknawk, panak taeng ih athawknawk, pathin nui ih athawknawk hoi pakaenawk to nawnto lak pacoengah, Angraeng khaeah hmai angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Qaima mah to athawknawk to hmaicam nuiah hmai hoi pakhaem tih; to loe Angraeng khaeah hmai angbawnhaih ah sak ih buh ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Maeh hoi angbawnhaih sah nahaeloe, Angraeng hmaa ah paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Anih mah paek ih maeh lu nuiah a ban to koeng ueloe, rangpui amkhuenghaih kahni im hma ah bop tih; Aaron capanawk mah athii to hmaicam taeng boih ah haeh o tih. ");
INSERT INTO cekak_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","A paek ih hmuen thung hoiah thoemto hmuen to la ueloe, Angraeng khaeah hmai angbawnhaih to sah tih; tazae taqawn kakhuk athawknawk hoi tazae taqawn nui ih athawknawk boih, ");
INSERT INTO cekak_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","pakae hnetto hoi a nuiah kaom athawknawk, panak taeng ih athawknawk, pathin nui ih athawknawk hoi pakaenawk to nawnto la ah loe, Angraeng khaeah hmai angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Qaima mah athawknawk to hmaicam nuiah hmai hoi pakhaem tih; to loe Angraeng khaeah hmuihoih ah paek ih, buh hoi sak ih angbawnhaih ah oh; athawknawk boih loe Angraeng ih ni. ");
INSERT INTO cekak_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Hae loe kawbaktih ahmuen ah om o cadoeh, angzo han koi na caanawk boih mah moithawk hoi athii caak o han ai ah, dungzan ah kaom Angraeng ih lok ah oh, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Israel kaminawk khaeah, Angraeng mah thuih ih lok to na tahngai o ai pongah, sak han ai a thuih ih lok to na aek o moe, zaehaih na sak o moeng, ");
INSERT INTO cekak_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","situi bawh tangcae qaima doeh kaminawk mah sak o ih zaehaih sah pazae moeng nahaeloe, a sak ih zae angbawn haih hanah, coek koi kaom ai saning kanawk maitaw tae to Angraeng hmaa ah sin nasoe. ");
INSERT INTO cekak_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Anih mah maitaw tae to amkhuenghaih kahni im thok taengah Angraeng hmaa ah hoi ueloe, maitaw tae lu nuiah a ban to koeng pacoengah, Angraeng hmaa ah bop tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","To pacoengah situi bawh tangcae ih qaima mah athii to la ueloe, amkhuenghaih kahni im ah sin tih; ");
INSERT INTO cekak_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","qaima mah a banpazung to athii thungah nup pacoengah, hmuenciim ah payang ih kahni hma hoi Angraeng hmaa ah, vai sarihto haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","To pacoengah qaima mah kaminawk amkhuenghaih kahni imthung ih Angraeng hmaa ah kaom, hmuihoih thlaekhaih hmaicam takii thungah thoemto maitaw thii to thaeng ueloe, athii to amkhuenghaih kahni im thok taengah kaom, hmai angbawnhaih hmaicam kung ah krai tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Tazae taqawn kakhuk athawknawk hoi tazae taqawn nui ih athawknawk boih, maitaw tae ih athawknawk boih, ");
INSERT INTO cekak_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","pakae hnetto hoi a nuiah kaom athawknawk, panak taeng ih athawknawk, pathin nui ih athawknawk hoi pakaenawk doeh, zae angbawnhaih sak hanah la boih tih, ");
INSERT INTO cekak_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","angdaeh angbawnhaih maitaw thawk to lak boih pacoengah, qaima mah hmai angbawnhaih sak hanah hmaicam nuiah hmai pakhaem tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Toe maitaw tae ih ahin, angan, lu, khoknawk, tazae taqawnnawk hoiah a aek, ");
INSERT INTO cekak_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","maitaw takpum boih im tasa bang ih, maiphu kraihaih ahmuen, hmuenciim ah maiphu nuiah, hmai to tik ueloe, hmai hoiah qoeng tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Israel kaminawk loe Angraeng mah thuih ih lok to tahngai o ai, sak han ai a thuih pae ih lok to aek o moe, zaehaih a sak o, toe sakpazaehaih to rangpui hma ah amtueng ai, ");
INSERT INTO cekak_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","toe sakpazae moeng ih zaehaih to panoek o naah, sakpazaehaih hmuen pongah zae angbawnhaih to sah o nahaeloe, kami rangpui mah saning kanawk maitaw tae maeto kaminawk amkhuenghaih kahni im hma ah sin moe, paek o han angaih. ");
INSERT INTO cekak_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Rangpui kacoehtanawk mah, Angraeng hmaa ah paek o ih maitaw tae lu nuiah ban to koeng o nasoe loe, Angraeng hmaa ah bop o nasoe. ");
INSERT INTO cekak_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","To pacoengah situi hoi bawh tangcae qaima mah maitaw tae ih athii to rangpui amkhuenghaih kahni im ah sin tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Qaima mah maitaw thii thungah a banpazung to nup ueloe, kahni payang ih, Angraeng hmaa ah vai sarihto haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","To pacoengah qaima mah amkhuenghaih kahni imthung ih Angraeng hmaa ah kaom, hmaicam takii thungah thoemto maitaw thii to lawn ueloe, amkhuenghaih kahni im thok taengah kaom, hmai angbawnhaih hmaicam kung ah krai tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Athawknawk to la boih ueloe, hmaicam nuiah hmai pakhaem tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Zae angbawnhaih maitaw tae hoi sak ih baktih toengah, hae maitaw tae doeh sah toeng ah; to naah qaima mah kaminawk zaehaih loih thai hanah angbawnhaih to sah pae ueloe, nihcae zaehaih to tahmen pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","To pacoengah a ohhaih im tasa bangah maitaw tae to hoi ueloe, hmaloe ih maitaw tae pakhaem baktih toengah, hmai pakhaem toeng tih; to loe kaminawk zaehaih loih hanah sak ih angbawnhaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Zaehoikung loe angmah Angraeng Sithaw ih lok to tahngai ai, sak han ai a thuih ih lok to aek moe, poek ai pui hoi zaehaih to a sak moeng pongah, zae kami ah oh, ");
INSERT INTO cekak_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","toe a zaehaih hoi a sakpazae moeng ih hmuen to panoek naah, a sak ih zae angbawn haih hanah, coek koi kaom ai maeh caa atae to sin han oh, ");
INSERT INTO cekak_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","a paek ih maeh lu nuiah a ban to koeng ueloe, Angraeng hmaa ah hmai angbawnhaih sak ih ahmuen ah bop tih; to loe zae angbawnhaih sak ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","To pacoengah qaima mah zae angbawnhaih athii to banpazung hoiah la ueloe, hmai angbawnhaih hmaicam ih takiinawk thungah lawn pacoengah, athii to hmaicam kung ah krai tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Angdaeh angbawnhaih athawk to hmai pakhaem baktih toengah, athawknawk boih hmaicam ah hmai pakhaem toeng tih; zaehaih loih hanah qaima mah to tiah angbawnhaih to sah pae ueloe, a zaehaih to tahmen pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Rangpui thung ih kamtang kami maeto loe, Angraeng mah thuih ih lok to tahngai ai, sak han ai a thuih ih lok to aek, poek ai pui hoiah hmuen to a sakpazae moeng pongah, kazae kami ah a oh, ");
INSERT INTO cekak_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","toe a zaehaih hoi a sakpazae moenghaih to panoek naah, a sak ih zaehaih to angbawn haih hanah, coek koi kaom ai maeh caa tala to sin han oh. ");
INSERT INTO cekak_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Zae angbawnhaih sak hanah a paek ih maeh lu nuiah a ban to koeng ueloe, hmai hoi sak ih angbawnhaih ahmuen ah zae angbawnhaih moi to bop tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","To pacoengah qaima mah zae angbawnhaih moi thii to banpazung hoiah la tih, hmai angbawnhaih hmaicam pong ih takiinawk thungah lawn ueloe, athii to hmaicam kung ah krai boih tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Angdaeh angbawnhaih moi thung hoiah athawk to lak baktih toengah, athawknawk to lak boih pacoengah, Angraeng han hmuihoih paek ih hmaicam nuiah hmai hoi pakhaem tih; to tiah zae loih hanah qaima mah angbawnhaih to sah ueloe, a zaehaih to tahmen pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Tuucaa hoi angbawnhaih sah nahaeloe, coek koi kaom ai tuucaa tala to sin han oh. ");
INSERT INTO cekak_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Zae angbawnhaih tuucaa lu nuiah a ban to koeng ueloe, hmai hoi angbawnhaih sak ih ahmuen ah, zae angbawnhaih moi to bop tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","To pacoengah qaima mah zae angbawnhaih athii to banpazung hoiah la tih, hmai angbawnhaih hmaicam pong ih takiinawk thungah lawn ueloe, hmaicam kung ah krai tih. ");
INSERT INTO cekak_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Angdaeh angbawnhaih moi thung hoiah athawk to lak baktih toengah, athawknawk to lak boih pacoengah, Angraeng khaeah hmai hoi sak ih angbawnhaih hoi nawnto hmaicam nuiah hmai pakhaem tih; to tiah anih zae loih hanah qaima mah angbawnhaih to sah pae ueloe, a zaehaih to tahmenhaih pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kami maeto loe a hnuk ih hmuen hoi panoek ih hmuen nuiah hnukung ah oh moe, rangpui hmaa ah lokmaihaih sahkung ih lok doeh a thaih; toe thuih han koeh ai nahaeloe, a zaehaih to a nuiah krah tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","To tih ai boeh loe kami maeto mah kaciim ai hmuen maw, kaciim ai moi maw, to tih ai boeh loe kaciim ai maitaw qok maw, to tih ai boeh loe kaciim ai zok hoi kavak moinawk maw panoek ai pui hoiah sui moeng nahaeloe, to tiah a sak ih hmuen to anih mah panoek let naah, anih loe zaehaih sah kami ah ni om tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","To tih ai boeh loe kami maeto loe panoek ai ah, kami khae ih ciimcai ai hmuen maw, kami maeto mah sak ih ciimcai ai hmuen maw a sui moeng, toe to tiah a sak ih hmuen to anih mah panoek let naah, anih loe zaehaih sah kami ah ni oh boeh. ");
INSERT INTO cekak_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","To tih ai boeh loe kami maeto loe kahoih ai hmuen pongah maw, kahoih hmuen pongah maw, panoek ai pui hoiah lokmaihaih to a sak moeng, toe to tiah a sak ih hmuen to anih mah panoek naah, anih loe zaehaih sah kami ah ni oh boeh. ");
INSERT INTO cekak_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Mi kawbaktih doeh to baktih hmuennawk pongah zae ah om nahaeloe, a zaehaih hmuen to taphong han oh. ");
INSERT INTO cekak_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","A zaehaih hmuen pongah Angraeng khaeah zae angbawnhaih sak hanah, tuucaa tala maw, to tih ai boeh loe maeh tala maw a sin han oh; to pacoengah qaima mah anih hanah zae angbawnhaih sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Tuucaa sin thai ai nahaeloe, Angraeng khaeah zae angbawnhaih sak hanah, pahuu hnetto maw, to tih ai boeh loe im pahuu hnetto maw sin han oh; maeto hoiah zae angbawnhaih to sah ueloe, kalah maeto hoiah hmai angbawnhaih to sah tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","To hmuennawk to qaima khaeah sin ah, anih mah tavaa maeto hoiah zae angbawnhaih to sah pae hmaloe tih, anih mah tahnong to tamet pae poek tih, toe taprawt pat mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Zae angbawnhaih athii to hmaicam taengah haeh tih; kamtlai athii loe hmaicam kung ah krai tih; to loe zae angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","To pacoengah sakhaih atawk baktih toengah, qaima mah hnetto haih tavaa hoiah hmai angbawnhaih to sah pae tih; a zaehaih pongah qaima mah zae angbawnhaih to sah pae tih; to naah anih ih zaehaih to tahmen tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Toe pahuu hnetto maw, im pahuu hnetto maw doeh sin thai ai nahaeloe, zae angbawnhaih sak hanah, takaw dip kahoih ephah hato thungah maeto sin moe, paek han oh; zae angbawnhaih ah oh pongah, situi bawh hmah ah loe, hmuihoih doeh a nuiah suem hmah. ");
INSERT INTO cekak_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","To hmuen loe qaima khaeah sin ah, anih mah takaw dip to ban tamsum maeto la ueloe, Angraeng hmaa ah hmai angbawnhaih sak baktih toengah, hmaicam nuiah hmai hoiah thlaek tih; to loe zae angbawnhaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","To tiah qaima mah anih sakpazaehaih hmuen maeto hanah zae angbawnhaih to sah pae nahaeloe, anih zaehaih to tahmen tih; cang hoi angbawnhaih sak ih baktih toengah, kamtlai angbawnhaih hmuen loe qaima taham ah om tih, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","kami maeto mah Angraeng ih hmuenciim maeto ah, poek ai pui hoiah zaehaih to sah moeng nahaeloe, a sak pazae ih hmuen pongah zae angbawnhaih sak hanah, coek koi kaom ai, tuu khongkha thung ih tuu tae maeto hoiah sak ih zae angbawnhaih ah oh pongah, hmuenciim ih shekel tahhaih dan baktih toengah, sui kanglung shekel nazetto maw tito pakoep ah loe, Angraeng hmaa ah sin ah; ");
INSERT INTO cekak_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","kaciim hmuen nuiah a sakpazae ih hmuen to pathok let pacoengah loe, to hmuen pangato thungah maeto qaima hanah paek thap pae ah; qaima mah tuu khongkha thung ih tuu tae hoiah anih hanah zae angbawnhaih to sah pae ueloe, a zaehaih to tahmen tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kami maeto mah Angraeng mah sak han ai thuih ih lok to aek moe, zaehaih sah moeng nahaeloe, a sakpazae ih hmuen to panoek ai cadoeh, anih loe zae ah oh boeh pongah, a zaehaih tho to hnu tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Sakpazae angbawnhaih ah oh pongah, sum kanglung phoisa nazetto maw tito pakoep ah loe, coek koi kaom ai, tuu khongkha thung ih tuu tae hoi nawnto qaima khaeah sin ah; anih mah poek ai pui hoiah hmuen to sahpazae cadoeh, anih mah hmuen sakpazae boeh, tito panoek ai pongah, qaima mah anih hanah zae angbawnhaih sah pae nahaeloe, a zaehaih to tahmen tih. ");
INSERT INTO cekak_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","To loe zae angbawnhaih ah oh; tangtang ni anih loe Angraeng hmaa ah hmuen sahpazae kami ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","kami maeto loe a imtaeng kami mah hmuen maeto pakuemsak maw, to tih ai boeh loe hmuen to ap naah to hmuen to anih mah lak pae ving maw, to tih ai boeh loe aling pae ving maw; ");
INSERT INTO cekak_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","to tih ai boeh loe hmuen to anghmatsak ving maw, to tih ai boeh loe hmuen kawng pongah amsawnlok a thuih moe, amsoem ai ah lokkamhaih to a sak moeng; to tiah anih mah zaehaih hmuen to sah moeng nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","to kami loe sakpazae moeng moe, zaehaih tawnh boeh pongah, a lomh ih hmuen maw, to tih ai boeh loe aling ih hmuen maw, to tih ai boeh loe minawk mah ap ih hmuen maw, to tih ai boeh loe anghmat pacoengah hnuk let ih hmuen maw, ");
INSERT INTO cekak_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","to tih ai boeh loe amsoem ai ah lokkam ih hmuen to, pangato thungah maeto thap moe, zae angbawnhaih niah, hmuen tawnkung khaeah nawnto paek let han oh. ");
INSERT INTO cekak_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Angraeng hmaa ah zae angbawnhaih sak hanah, zae angbawnhaih sak han khawt tih hmang, tiah na pakoep ih phoisa hoi nawnto, coek koi kaom ai tuu khongkha thung ih tuu tae to qaima khaeah sin ah. ");
INSERT INTO cekak_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","To naah qaima mah Angraeng hmaa ah anih han zae angbawnhaih sah pae ueloe, anih mah sak ih kawbaktih zaehaih doeh tahmen tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aaron hoi a capanawk khaeah hae tiah thui paeh; hmai angbawnhaih daan loe hae tiah oh; hmai angbawnhaih sak naah, hmaicam pongah aqum puek, khawnbang khoek to hmai angqongsak poe ah; hmaicam ih hmai loe dueh ai ah, angqongsak poe han oh. ");
INSERT INTO cekak_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Qaima loe angmah ih puu ngan laihaw to angkhuk moe, puu ngan canghnawh kasawk to abuen han oh; anih mah hmaicam nuiah hmai mah kangh ih moi poep to la ueloe, hmaicam taengah suem tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","To pacoengah angkhuk ih khukbuennawk to angkhring ueloe, kalah khukbuennawk angkraih pacoengah, a ohhaih im tasa bang ih hmuenciim ah moi pakhaemhaih hmaipoep to sin tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Hmaicam nui ih hmai loe angqong poe han oh; paduek han om ai; khawnbang kruek qaima mah hmaicam nuiah thing tik ueloe, to hmai nuiah hmai angbawnhaih ah sak ih moi to suem tih; to hmai nuiah angdaehhaih sak ih moithawk to pakhaem tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Hmaicam pong ih hmai loe dueksak han om ai; boeng ai ah angqong poe han oh. ");
INSERT INTO cekak_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Cang paekhaih daan loe hae tiah oh; Aaron capanawk mah cang hoi angbawnhaih to Angraeng khaeah, hmaicam hma ah sin o tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Qaima mah cang hoi angbawnhaih sak ih hmuen thung hoiah takaw dip ban tamsum maeto la ueloe, panoek poehaih, situi hoi hmuihoihnawk boih to, Angraeng khaeah hmuihoih ah paek hanah hmaicam nuiah hmai hoi thlaek tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kamtlai to Aaron hoi a capanawk mah caa o tih; toe nihcae loe taeh thuh ai ih takaw hoiah hmuenciim, kaminawk amkhuenghaih kahni im longhma ah caa o tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Taeh thuh ih takaw to haek hmah; kai khaeah sak ih hmai angbawnhaih ah sak ih hmuen thung hoiah to takaw dip to nihcae han ka paek boeh; to loe zae angbawnhaih hoi sakpazae pongah angbawnhaih hmuen baktiah ni ciim. ");
INSERT INTO cekak_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","To baktih takaw loe Aaron capanawk boih mah caa o thai tih. Hae loe hmabang angzo han koi caanawk mah toep han ih taham ah kaom, Angraeng khaeah sak ih hmai angbawnhaih daan ah om tih; to angbawnhaih hmuen sui kaminawk boih loe ciimcai o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Aaron hoi a capanawk loe, situi bawh moe, toksak caksakhaih ni hoi kamtong, Angraeng khaeah cang hoi sak ih angbawnhaih dungzan ah a sinh o hanah, takaw dip ephah hato thungah maeto, akhawn bang ah ahap, duembang ah ahap paek o tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","To takaw loe camphaek laom pongah situi hoi haek pacoengah, a thungah sin ueloe, kamtlai takaw dipnawk to hmuihoih ah Angraeng khaeah paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Aaron zuengah qaima ah situi bawh ih a capanawk mah angbawnhaih to sah o tih; hae loe dungzan ah kaom Angraeng khaeah paek ih hmuen tathlanghaih daan ah oh; hmuen boih hmai pakhaem oh. ");
INSERT INTO cekak_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Qaima han sak ih cang hoi angbawnhaih loe, hmai hoi thlaek boih han oh; caak han om ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Aaron hoi a capanawk khaeah hae tiah thui paeh; Zae angbawnhaih daan loe hae tiah oh; hmai hoi sak ih angbawnhaih moi bohhaih ahmuen ah, zae angbawnhaih moi to Angraeng hmaa ah boh han oh; hae loe kaciim koek ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Zae angbawnhaih sah qaima mah moi to caa tih; kaminawk amkhuenghaih kahni im longhma ih, hmuenciim ah caa tih. ");
INSERT INTO cekak_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Angbawnhaih moi sui kaminawk boih loe ciim o tih; khukbuen nuiah athii to akap moeng nahaeloe, hmuenciim ah pasuk ah. ");
INSERT INTO cekak_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Moi thonghaih long laom to pakoih oh; toe moi to sum kamling pongah thong o nahaeloe, laom to hmawt o suidik ah loe tui hoiah pasae oh. ");
INSERT INTO cekak_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Qaima imthung takoh nongpa boih mah moi to caa o tih; hae loe kaciim koek ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Toe zae angbawnhaih sak hanah zae angbawnhaih moi thii to kaminawk amkhuenghaih kahni imthung ih hmuenciim ah sin nahaeloe, to angbawnhaih moi to caa hmah; hmai hoi qoeng oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Hae loe kaciim koek, sakpazae angbawnhaih daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Hmai angbawnhaih moi bohhaih ahmuen ah, nihcae mah sakpazae angbawnhaih moi to bop o tih; anih mah athii to hmaicam taengah haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Anih mah athawknawk boih, tamai ih athawk hoi tazae taqawn nuiah kaom athawknawk boih to tathlang tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Anih mah pakae hnetto hoi pakae nui ih athawk, kaenghuh taeng ih ngannawk, pathin nui ih athawknawk to la boih tih; ");
INSERT INTO cekak_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","to moinawk to qaima mah hmaicam nuiah hmai pakhaem ueloe, Angraeng khaeah hmai angbawnhaih to sah tih; hae loe sakpazae angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Qaima imthung takoh ih nongpa boih mah moi to caa o tih; to loe ciimcai koek ah oh pongah, kaciim ahmuen ah caa o tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Zae angbawnhaih daan hoi sakpazae angbawnhaih daan loe maeto ah ni oh; zae angbawnhaih sahkung qaima mah to daan to tawn han oh. ");
INSERT INTO cekak_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mi kawbaktih kami hanah angbawnhaih sah pae cadoeh, angbawnhaih sah qaima loe, a sak ih angbawnhaih moi hin to angmah hanah suem tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Camphaek laom pongah haek ih takaw, haekhaih laom pongah haek ih takaw, sum kangphaek pongah haek ih takaw boih loe, angbawnhaih sah qaima mah la tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Situi hoi atok maw, atok ai, angbawnhaih takaw boih, Aaron capanawk boih mah kangvan ah la o tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Hae loe kami mah Angraeng khaeah angbawnhaih sak koi, angdaeh angbawnhaih daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kami maeto mah anghoe hmuen paekhaih sah nahaeloe, anghoe angbawnhaih hmuen hoi nawnto, situi hoi atok moe, taeh thuh ai ih takaw kae; situi nok moe, taeh thuh ai ih takaw karoem, situi hoi atok ih takaw kae, kahoih takaw dip, situi hoi haek ih takaw to paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Takaw pacoengah, anghoe pongah angdaeh angbawnhaih hmuen hoi nawnto, taeh thuh ih takaw to paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Angbawnhaih hmuen boih thung hoiah takaw maeto Angraeng khaeah paek ah; to loe angdaeh angbawnhaih athii haehkung qaima taham ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Anghoe pongah angdaeh angbawnhaih ah boh ih moi loe, moi boh niah caa roep ah; akhawn bang khoek to omsak hmah. ");
INSERT INTO cekak_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Toe lokkam hoi sak ih angbawnhaih maw, to tih ai boeh loe angmah koeh ah angbawnhaih to sah nahaeloe, angbawnhaih sak na niah moi to caak roep han oh, amtlai nahaeloe khawnbang ah doeh caak thaih: ");
INSERT INTO cekak_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","toe angbawnhaih moi ni thumto karoek to om nahaeloe, hmai hoiah thlaek ah. ");
INSERT INTO cekak_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Angdaeh angbawnhaih moi ni thumto thung caa nahaeloe, to kami to talawk thai mak ai; paekkung mah paek ih hmuen doeh atho om mak ai; to hmuen loe panuet thoh boeh; to tiah kacaa kami loe a caak pazaehaih atho to hnu tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kaciim ai hmuen hoi kangbet moi to caa hmah; hmai hoi qoeng ah; kaciim moi loe kaciim kaminawk boih mah caa o tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Toe ciimcai ai kami loe, ciimcai ai ah Angraeng khaeah angdaeh angbawnhaih moi to caa nahaeloe, to kami to angmah ih acaeng thung hoiah takhoe ah. ");
INSERT INTO cekak_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ciimcai ai hmuen maw, ciimcai ai kami ih hmuen maw, to tih ai boeh loe ciimcai ai moi maw, to tih ai boeh loe ciimcai ai panuet thok hmuen maw maeto sui moe, Angraeng khaeah paek ih angdaeh angbawnhaih moi to caa kami loe, angmah ih acaeng thung hoi takhoe ving ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Israel kaminawk khaeah, Maitaw thawk, to tih ai boeh loe tuu thawk, to tih ai boeh loe maeh thawk to caa o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Angmah koeh kadueh moi athawk, moisan mah kaek ih kadueh moithawk to kalah angaihaih ahmuen ah patoh oh; toe caa o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Angraeng khaeah sak ih hmai angbawnhaih moithawk caa kami loe, angmah ih acaeng thung hoi takhoe ving ah. ");
INSERT INTO cekak_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Na ohhaih ahmuen kruekah, tavaa ih athii maw, moi ih athii maw to caa o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kawbaktih athii doeh caa kami loe, angmah ih acaeng thung hoi pahnawt ah, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Israel kaminawk khaeah hae tiah thui paeh; Angraeng khaeah angdaeh angbawnhaih sah kami loe, a paek ih angdaeh angbawnhaih moi thung hoiah Angraeng khae tathlang hanah sin ah. ");
INSERT INTO cekak_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Angraeng khaeah hmai angbawnhaih sak hanah, angmah ban ah athawk hoi saoek to sin han oh, anih mah Angraeng hmaa ah ahaek angbawnhaih sak hanah ahaek tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Qaima mah athawk to hmaicam ah pakhaem tih; toe saoek loe Aaron hoi a capanawk ih taham ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Angdaeh angbawnhaih moi bantang bang ih palaeng to qaima han paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Angdaeh angbawnhaih moi thii hoi athawk paekkung, Aaron capa mah bantang bang ih palaeng to angmah hanah la tih. ");
INSERT INTO cekak_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Israel kaminawk mah sak ih angdaeh angbawnhaih moi thung hoiah saoek hoi palaeng to ka lak moe, Israel kaminawk salakah sak poe han paek ih daan baktih toengah, qaima Aaron hoi anih ih capanawk khaeah ka paek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","To moi loe Aaron hoi a capanawk mah Angraeng hmaa ah qaima tok to sak o hanah, Aaron hoi a capanawk situi bawhhaih niah, Angraeng khaeah hmai angbawnhaih sak ih hmuen thung hoiah nihcae mah hak han koi taham ah oh; ");
INSERT INTO cekak_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Israel kaminawk ban thung hoi to baktih qawk to a toep o hanah, nihcae situi bawh na niah, Angraeng mah Israel kaminawk khaeah lokpaek boeh; to lok loe nihcae ih caanawk dung khoek to pazui poe han ih daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Hae loe hmai angbawnhaih, cang angbawnhaih, zae angbawnhaih, sakpazae angbawnhaih, angpaekhaih hoi angdaeh angbawnhaih daan ah oh, ");
INSERT INTO cekak_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Angraeng mah Israel kaminawk khaeah Sinai praezaek ah Angraeng khaeah angbawnhaih sak han thuih pae na niah, Sinai mae ah Mosi han paek ih daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Aaron hoi a capanawk to kawk ah, khukbuennawk, toksak caksakhaih situi, zae angbawnhaih sak hanah maitaw tae maeto, tuu tae hnetto hoi taeh thuh ai ih takaw benthang maeto la ah loe, ");
INSERT INTO cekak_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","rangpui amkhuenghaih kahni im thok taengah kaminawk boih nawnto pakhueng ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Angraeng mah paek ih lok baktih toengah Mosi mah sak; kaminawk loe amkhuenghaih kahni im thok taengah nawnto amkhueng o. ");
INSERT INTO cekak_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mosi mah rangpuinawk khaeah, Angraeng mah hae tiah sak han ang thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","To pacoengah Mosi mah Aaron hoi a capanawk to hmabang tacawtsak pacoengah, tui hoiah pasaeh. ");
INSERT INTO cekak_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aaron to laihaw kasawk angkhuksak, kaengkaeh angzaengsak moe, kahni kasawk angkhuksak pacoengah, qaima kahni to angkhuksak; qaima ih laihaw anui zaenghaih kazii hoiah a takpum to a zaeng pae. ");
INSERT INTO cekak_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","To pacoengah saoek padaphaih kahni to angkhuksak moe, saoek padaphaih kahni nuiah Urim hoi Thummin to a zaeng pae. ");
INSERT INTO cekak_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Aaron to lumuek angmueksak pacoengah, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, kaciim sui tacik kangphaek to hmabang ih lumuek pongah a bet pae. ");
INSERT INTO cekak_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","To pacoengah Mosi mah tak bawhhaih situi to lak moe, kahni im hoi a thungah kaom hmuennawk boih bawh pacoengah, ciimcaisak. ");
INSERT INTO cekak_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Hmaicam to situi hoiah vai sarihto a bawh, hmaicam hoi angmah ih laom sabaenawk boih, kathuk sabae hoi hmuen pahnuthaihnawk boih doeh, ciimcaisak hanah a bawh. ");
INSERT INTO cekak_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Aaron to ciimcaisak hanah, anih ih lu to situi hoiah a bawh pae. ");
INSERT INTO cekak_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Aaron capanawk to hmabang tacawtsak moe, laihaw kasawk to angkhuksak; kazii hoi kaeng angzaengsak pacoengah, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, lumuek to angmueksak. ");
INSERT INTO cekak_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","To pacoengah zae angbawnhaih sak hanah maitaw tae to a sin moe, zae angbawnhaih sak hanah Aaron hoi a capanawk mah maitaw lu nuiah ban to koeng o. ");
INSERT INTO cekak_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mosi mah maitaw tae to boh; hmaicam ciimcaisak hanah, a ban tadong hoi maitaw thii to lak moe, hmaicam nui ah kaom takiinawk thungah a thaengh pacoengah, athii to hmaicam kung ah a kraih; hmaicam nuiah angdaehhaih sak hanah, to tiah a ciimcaisak. ");
INSERT INTO cekak_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mosi mah takoh thung ih athawknawk, pathin nuiah kaom athawknawk, pakae hnetto hoi a nuiah kaom athawknawk to lak boih pacoengah, hmaicam nuiah hmai pakhaem. ");
INSERT INTO cekak_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Toe maitaw hin, ngan hoi aeknawk loe Angraeng mah Mosi khaeah thuih ih lok baktih toengah, angmacae ohhaih im tasa bangah hmai hoiah a thlaek. ");
INSERT INTO cekak_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","To pacoengah hmai angbawnhaih sak hanah tuu tae maeto a sin, Aaron hoi a capanawk mah tuu lu nuiah ban to koeng o. ");
INSERT INTO cekak_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mosi mah tuu tae to boh moe, athii to hmaicam taeng boih ah a haeh. ");
INSERT INTO cekak_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Tuu atae ih moi to abaeh pacoengah, a lu, angan hoi athawknawk to Mosi mah hmai pakhaem. ");
INSERT INTO cekak_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Takoh thung ih moi hoi akhoknawk to tui hoi pasaeh pacoengah, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, tuu tae takpum boih hmaicam nuiah hmai hoiah pakhaem; to loe Angraeng khaeah hmuihoih ah sak ih hmai angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","To pacoengah kalah tuu tae maeto a sin let, to loe angpaekhaih sak hanah patoh; Aaron hoi a capanawk loe tuu tae lu nuiah ban to koeng o. ");
INSERT INTO cekak_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mosi mah tuu tae to boh; athii to lak moe, Aaron ih bantang naa nui, bantang banpui nui hoi bantang khokpui nuiah a suek. ");
INSERT INTO cekak_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Aaron capanawk to hmabang tacawtsak moe, Mosi mah nihcae ih bantang naa nui, bantang banpui nui hoi bantang khokpui nuiah suek pacoengah, athii hoiah hmaicam taeng to a haeh boih. ");
INSERT INTO cekak_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Athawk, tamai ih athawk, takoh thung ih athawknawk boih, pathin kakhuk athawk, pakae hnetto, athawknawk hoi bantang bang ih palaeng to a lak. ");
INSERT INTO cekak_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","To pacoengah Angraeng hmaa ah kaom, benthang pong ih taeh thuh ai ih takaw, takaw kae maeto, situi nok ih takaw kangphaek hoi takaw karoem maeto a lak moe, athawk nui hoi bantang palaeng nuiah a suek. ");
INSERT INTO cekak_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","To hmuennawk to Aaron hoi a capanawk ih ban ah suek boih pacoengah, ahaek moe, paek ih hmuen baktiah, Angraeng hmaa ah ahaek. ");
INSERT INTO cekak_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","To pacoengah to hmuennawk to nihcae ban thung hoiah Mosi mah lak moe, hmai angbawnhaih moi hoi nawnto hmaicam nuiah hmai a qoeng; to loe hmuihoih angpaekhaih ah oh moe, Angraeng hmaa ah hmai hoi sak ih hmuen tathlanghaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mosi mah saoek to lak pacoengah, Angraeng hmaa ah ahaek moe, ahaek hoi hmuen paekhaih to a sak; Mosi khaeah thuih ih lok baktih toengah, angpaekhaih tuu saoek loe Mosi taham ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","To pacoengah Mosi mah bawhhaih situi to lak moe, hmaicam nui ih athii to lak pacoengah, Aaron hoi anih ih khukbuennawk, a capanawk hoi a capanawk ih khukbuennawk to bawh pae; to tiah Aaron hoi a caanawk ih khukbuennawk to a ciimsak. ");
INSERT INTO cekak_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","To pacoengah Mosi mah Aaron hoi a capanawk khaeah, Aaron hoi a capanawk mah caa o tih, tiah ka thuih ih lok baktih toengah, amkhuenghaih kahni im thok taengah, moi to thong oh ah loe, angpaekhaih benthang thung ih takaw hoi nawnto to ahmuen ah caa oh. ");
INSERT INTO cekak_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kamtlai moi hoi takaw loe hmai hoiah qoeng oh. ");
INSERT INTO cekak_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Na takpum angpaekhaih ni boeng ai karoek to, amkhuenghaih kahni im thok tasa bangah caeh o hmah; ni sarihto thung na takpum angpaekhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Vaihniah sak ih hmuen baktih toengah, na zae loihaih to sak hanah, Angraeng mah paek ih lok to oh. ");
INSERT INTO cekak_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","To pongah na duek o han ai ah, amkhuenghaih kahni im thok taengah khoving khodai ni sarihto thung om oh loe, Angraeng ih tok to sah oh; to tiah lok ang paek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","To pongah Aaron hoi a capanawk loe, Angraeng mah Mosi khaeah thuih ih lok baktih toengah a sak o. ");
INSERT INTO cekak_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ni tazetto na niah Mosi mah Aaron, anih capanawk hoi Israel kaminawk to kawk moe, ");
INSERT INTO cekak_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aaron khaeah, Zae angbawnhaih sak hanah maitaw caa maeto, hmai angbawnhaih sak hanah, coek koi kaom ai, tuu tae maeto sin ah loe, Angraeng hmaa ah paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","To pacoengah Israel kaminawk khaeah, Zae angbawnhaih sak hanah maeh caa, atae maeto hmai angbawnhaih sak hanah, saningto kaom, coek koi kaom ai, maitaw caa maeto hoi tuu tae maeto paek ah; ");
INSERT INTO cekak_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","to pacoengah Angraeng hmaa ah, angdaeh angbawnhaih sak hanah, maitaw tae maeto hoi tuu tae maeto, situi hoi atok tangcae takaw to paek ah; vaihniah Angraeng nangcae khaeah amtueng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Mosi mah paek ih lok baktih toengah, hmuennawk to rangpui amkhuenghaih thok hmaa ah a sin o; kaminawk boih a taengah caeh o moe, Angraeng hmaa ah angdoet o. ");
INSERT INTO cekak_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","To naah Mosi mah, Nangcae khaeah Angraeng lensawkhaih amtueng hanah, Angraeng mah thuih ih lok baktih toengah sah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mosi mah Aaron khaeah, Hmaicam kung ah caeh ah, zae angbawnhaih, hmai angbawnhaih to sah ah loe, nangmah hoi nangmah ih kaminawk zaehaih loih o thai hanah angbawnhaih to sah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","To pongah Aaron mah hmaicam ah caeh moe, angmah ih zae angbawnhaih to sak hanah maitaw caa maeto a boh. ");
INSERT INTO cekak_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Aaron capanawk mah anih khaeah athii sin pae o, anih mah athii thungah a banpazung to nup pacoengah, hmaicam nuiah kaom takiinawk thungah a thaengh; kamtlai athii to hmaicam kung ah a kraih. ");
INSERT INTO cekak_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Toe zae angbawnhaih athawknawk, pakaenawk, pathin nuiah kaom athawknawk loe, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, hmaicam nuiah hmai pakhaem. ");
INSERT INTO cekak_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Angan hoi ahin loe, a ohhaih im tasa bangah hmai hoiah a qoeng. ");
INSERT INTO cekak_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","To pacoengah hmai hoiah sak ih angbawnhaih moi to a boh; Aaron capanawk mah athii to paek o, anih mah hmaicam taeng boih ah haeh. ");
INSERT INTO cekak_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Nihcae mah angbawnhaih moi angan hoi alu to paek o, anih mah hmaicam nuiah hmai hoiah qoeng. ");
INSERT INTO cekak_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Takoh hoi akhoknawk loe tui hoi pasaeh pacoengah, hmaicam nuiah hmai angbawnhaih sak hanah hmai hoiah pakhaem. ");
INSERT INTO cekak_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","To pacoengah kaminawk mah angbawnhaih sak han paek ih hmuen to Aaron mah sinh; kaminawk zaehaih loih o thai hanah angbawnhaih maeh to a sin moe, boh pacoengah, hmaloe ih baktih toengah, zae angbawnhaih sak hanah a paek. ");
INSERT INTO cekak_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Hmai angbawnhaih hmuen to a sin moe, a sakhaih atawk baktih toengah a sak. ");
INSERT INTO cekak_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Cang angbawnhaih a sin moe, ban tamsum maeto a lak pacoengah, hmaicam nuiah, akhawnbang hmai angbawnhaih ahmuen taengah hmai hoiah a qoeng. ");
INSERT INTO cekak_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Kaminawk han, angdaeh angbawnhaih sak pae hanah, maitaw tae hoi tuu tae doeh a boh; Aaron ih capanawk mah athii to paek o, anih mah hmaicam taeng boih ah haeh. ");
INSERT INTO cekak_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Toe maitaw tae hoi tuu tae ih athawknawk, tamai thawk, takoh thung ih athawknawk, pakaenawk hoi pathin nui ih athawk, ");
INSERT INTO cekak_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","to baktih athawknawk to saoek nuiah koeng pacoengah, Aaron mah athawknawk to hmaicam nuiah hmai pakhaem. ");
INSERT INTO cekak_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mosi mah paek ih lok baktih toengah, Aaron mah saoek hoi bantang palaeng to, ahaek moe, Angraeng hmaa ah ahaek angbawnhaih to paek. ");
INSERT INTO cekak_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aaron mah rangpui kaminawk khaeah ban payangh moe, nihcae to tahamhoihaih a paek pacoengah, anih loe zae angbawnhaih ahmuen, angdaeh angbawnhaih ahmuen hoiah anghum tathuk. ");
INSERT INTO cekak_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","To pacoengah Mosi hoi Aaron loe rangpui amkhuenghaih kahni im thungah caeh hoi; amlaem hoi let pacoengah, kaminawk to tahamhoihaih a paek hoi; to naah Angraeng lensawkhaih kaminawk boih nuiah amtueng. ");
INSERT INTO cekak_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Angraeng hmaa hoiah hmai to tacawt moe, hmaicam nui ih hmai hoiah sak ih angbawnhaih hoi athawknawk to hmai mah kangh boih; to hmuen to kaminawk boih mah hnuk o naah, hang o moe, long ah akuep o. ");
INSERT INTO cekak_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaron capa Nadab hoi Abihu loe angmah hnik ih hmuihoih thlaekhaih sabae to a lak hoi; a thungah hmai to suek hoi moe, a nuiah hmuihoih a phuih hoi pacoengah, Angraeng mah patoh han ai ah thuih pae ih kalah hmai to a hmaa ah paek hoi. ");
INSERT INTO cekak_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","To naah Angraeng khae hoiah hmai to tacawt moe, nihnik to kangh hmaek; to tiah nihnik loe Angraeng hmaa ah duek hoi. ");
INSERT INTO cekak_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","To pacoengah Mosi mah Aaron khaeah, Angraeng mah hae tiah thuih; kai khaeah anghnai kami loe ciimcai, tiah a poek han oh; Ka lensawkhaih kaminawk boih hmaa ah pakoeh han oh, tiah a thuih, tiah a naa. To naah Aaron loe anghngai duem. ");
INSERT INTO cekak_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","To naah Mosi mah Aaron ih ampu Uzziel capanawk, Mishael hoi Elzaphan to kawk moe, nihcae khaeah, Haeah angzo oh, nam nawkamyanawk to hmuenciim hoiah na oh o haih ahmuen tasa bangah angzawn oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","To pongah Mosi mah paek ih lok baktih toengah, nihcae to angzoh o moe, angmah hnik ih laihaw kasawk hoi nawnto a ohhaih tasa bangah angzawn o. ");
INSERT INTO cekak_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","To naah Mosi mah Aaron ih capa hnik Eleazar hoi Ithamar khaeah, lumuek to angkhring hoi hmah, nang khuk hoi ih khukbuennawk doeh angkhring hoi hmah; to tih ai nahaeloe na dueh hoi tih, Angraeng palungphuihaih acaeng kaminawk nuiah pha moeng tih; toe nam nawkamya hoi Israel imthung takoh boih mah Angraeng mah hmai kanghsak maat ih kami hnik hanah, qah o haih nasoe. ");
INSERT INTO cekak_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Angraeng mah situi bawhhaih to na nuiah oh pongah, amkhuenghaih kahni im thok tasa bangah caeh hmah; to tih ai nahaeloe na dueh moeng tih, tiah a naa. To pongah Mosi mah thuih ih lok baktih toengah, a sak o. ");
INSERT INTO cekak_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","To pacoengah Angraeng mah Aaron khae ah, ");
INSERT INTO cekak_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Nangmah hoi na caanawk, amkhuenghaih kahni imthung ah na caeh o naah, mu hoi paqui thaih hmuen roe nae o hmah; to tih ai nahaeloe na dueh o moeng tih; hae loe angzo han koi na caanawk mah pazui poe hanah paek ih zaehhoihhaih daan ah oh: ");
INSERT INTO cekak_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","kacai hoi cai ai, kaciim hoi ciim ai hmuen to tapraek oh loe, ");
INSERT INTO cekak_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Angraeng mah Mosi patohhaih rang hoiah nihcae khaeah thuih ih zaehhoihhaih daannawk to Israel kaminawk boih han patuk ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mosi mah Aaron hoi kanghmat anih ih capa hnik, Eleazar hoi Ithamar khaeah, taeh thuh ai ah, Angraeng khaeah hmai hoi angbawnhaih ah paek ih kamtlai takaw to la hoih loe, hmaicam taengah caa hoih; to loe ciimcai ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Angraeng khaeah hmai angbawnhaih loe, nang ih taham hoi na capanawk ih taham ah oh pongah, hmuenciim ah caa oh; to lokpaekhaih to ka hnuk boeh. ");
INSERT INTO cekak_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Toe nangmah, na canu hoi na capanawk loe, ahaek ih palaeng hoi saoek to hmueciim ah caa oh; Israel kaminawk mah paek ih angdaeh angbawnhaih ah oh pongah, nangmah hoi na capanawk ih taham ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Hmai hoi angbawnhaih sak ih athawk hoi nawnto, ahaek ih palaeng hoi saoek to Angraeng hmaa ah ahaek angbawnhaih sak hanah ahaek ah; Angraeng mah thuih ih lok baktih toengah, to loe nangmah hoi na capanawk han dungzan ah paek ih taham ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mosi mah zae angbawnhaih maeh to palung tang hoiah pakrong; khenah, maeh loe hmai pakhaem o ving boeh! To naah kahing kanghmat Aaron capa hnik, Eleazar hoi Ithamar nuiah palungphui moe, ");
INSERT INTO cekak_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","kaminawk ih zaehaih to phawh moe, Angraeng hmaa ah nihcae zaehaih loih thai hanah angbawnhaih sak pae han ih nang hnik khaeah ang paek o ih kaciim koek, zae angbawnhaih moi loe tipongah hmuenciim ah na caa hoi ai loe? ");
INSERT INTO cekak_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Khenah, hmuenciim thungah athii to sin ai pongah, kang paek ih lok baktih toengah, maeh moi to hmuenciim thungah na caak hoi han oh bae, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron mah Mosi khaeah, Khenah, vaihniah zae angbawnhaih hoi hmai angbawnhaih Angraeng hmaa ah a sak hoi; toe ka nuiah to baktih hmuen to oh moeng boeh; vaihniah zae angbawnhaih moi to ka caak nahaeloe, Angraeng hmaa ah tapom thai koi hmuen ah om tih maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mosi mah to lok to thaih naah, palung khuek tih. ");
INSERT INTO cekak_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Israel kaminawk khaeah, Long ah kaom moinawk boih thungah, ");
INSERT INTO cekak_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","khokpadae kangphae, rawkcaak pathok thaih moinawk to caa oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Rawkcaak loe pathok, khokpadae doeh angphae, toe caak koi ai moinawk thungah kaengkuu hrang loe, rawkcaak pathok thaih, toe khokpadae angphae ai pongah, nangcae han ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Satlaeh loe rawkcaak pathok thaih, toe khokpadae angphae ai pongah, nangcae han ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Saveh loe rawkcaak pathok thaih, toe khokpadae angphae ai pongah, nangcae han ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ok loe khokpadae hnetto angphae, toe rawkcaak pathok ai pongah, nangcae han ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","To baktih moinawk to caa hmah loe, kadueh qok doeh sui hmah; nangcae han ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Tuipui hoi vapui ih tanganawk thungah loe pakhraeh hoi ahlip kaom tanga to caa ah. ");
INSERT INTO cekak_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Toe tuipui hoi vapui ah kaom, pakhraeh hoi ahlip kaom ai, tuipui hoi vapui thungah kaom, hinghaih katawn, angtawt thaih moinawk loe, nangcae hanah panuet thoh. ");
INSERT INTO cekak_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","To moinawk loe nangcae han panuet thoh pongah, nihcae ih moi to caa o hmah; kadueh moi loe panuet thoh. ");
INSERT INTO cekak_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tui thungah kaom pakhraeh hoi ahlip katawn ai tanganawk loe nangcae hanah panuet thoh. ");
INSERT INTO cekak_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Nangcae han panuet thoh moe, caak koi ai, panuet thok tavaanawk loe tahmu, tuipui ih tahmu, kamnum tahmu kaprawn, ");
INSERT INTO cekak_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","moi kacaa tahmu, van ah kamhet tahmunawk boih, ");
INSERT INTO cekak_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","pangaah hoi kanghmong tavaa boih, ");
INSERT INTO cekak_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","bukbuh, aqum ah kazawk tahmu, tahmu congca, ");
INSERT INTO cekak_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","bukbuh kasim, bukbuh kaho, tahnong ah rawkcaak patunghaih kaom tahmawh sawk tavaa, ");
INSERT INTO cekak_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","tahnong sawk tui tavaa, tanga kacaa tahnong sawk tui tavaa, praezaek ih bukbuh, tanga kacaa tahmu, ");
INSERT INTO cekak_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","khok kasawk tavaa, longpai khokpadae hoi kanghmong tahnongsawk tavaa congca, tahmawh sawk tavaanawk hoi pungpihnawk hae ni. ");
INSERT INTO cekak_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Pakhraeh kaom, khok palito hoi kavak moinawk boih loe, nangcae han panuet thoh. ");
INSERT INTO cekak_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Toe pakhraeh kaom, khok palito hoi kavak, long ah angphet thaih khok kasawk moinawk to loe caa oh. ");
INSERT INTO cekak_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Pakhuh kaho congca, rong kahing pakhuh, pakhuh kasim hoi dongtaritnawk to caa oh. ");
INSERT INTO cekak_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Toe khok palito katawn, long ah kavak azawk thaih moinawk loe nangcae han panuet thoh. ");
INSERT INTO cekak_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","To moinawk loe ciim ai; to moi kadueh qok sui kami loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","To baktih moi qok sui kami loe, a khukbuen to pasuk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Khokpadae akah boih ai, rawkcaak doeh pathok ai moinawk loe nangcae han ciim ai; to baktih kadueh moi sui kami loe ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Khok palito hoi kacaeh moinawk boih, khokpacin hoiah kavak moinawk boih loe, nangcae han ciim ai; to baktih kadueh moi sui kami loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","To baktih kadueh moi sui kami loe, a khukbuen to pasuk han oh; anih loe duembang khoek to ciim mak ai; to moi loe nangcae han ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Long ah kavak moinawk boih doeh, nangcae han ciim ai; caham, pazu, tokkang congca, ");
INSERT INTO cekak_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","tawkkeh, kingkok, lungnat hoi salamhnawk to caa o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Long ah avak moinawk boih loe nangcae han panuet thoh; to baktih kadueh moi sui kami loe, duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","To moinawk to dueh moe, hmuen maeto nuiah krah moeng nahaeloe, to hmuen loe ciim mak ai boeh; to kadueh moi to thing maw, to tih ai boeh loe khukbuen maw, to ai boeh loe moi hin nuiah maw, to tih ai boeh loe kazii nuiah maw, krah moeng nahaeloe, to hmuennawk loe ciim mak ai boeh; to hmuennawk to tui padung ah; duembang khoek to ciim mak ai; to tiah sak pacoeng naah ni ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","To kadueh moi to long laom maeto nuiah krah moeng nahaeloe, to long laom loe ciim ai boeh pongah, laom to pakhoih han oh. ");
INSERT INTO cekak_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","To laom thung ih tui to caak koi buh aan pongah krah moeng nahaeloe, ciim mak ai; a krakhaih boengloeng thung ih tui doeh ciim mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","To moi loe takoeng nuiah maw, to tih ai boeh loe laom nuiah maw, krah moeng nahaeloe, to hmuennawk loe nangcae han ciim ai boeh pongah, pakhoih boih han oh. ");
INSERT INTO cekak_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Vacong, to tih ai boeh loe tuibap ih tui loe ciim, toe kadueh moi maeto mah sui moeng ih hmuen boih loe ciim mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Toe kadueh moi to patit han suek ih aanmu nuiah krah moeng nahaeloe, aanmu loe ciim tih. ");
INSERT INTO cekak_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Toe tui bawh ih aanmu nuiah kadueh moi maeto krah nahaeloe, nangcae han ciim mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Na caak o han koi moi maeto duek naah, kadueh moi sui kami loe, duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Mi kawbaktih doeh kadueh moi caa kami loe, a khukbuennawk to pasuk han oh; anih loe duembang khoek to ciim mak ai; mi kawbaktih doeh kadueh moi akhui kami loe, a khukbuen to pasuk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Long ah zok hoi avak moi loe kawbaktih moi doeh panuet thok moi ah oh; caak han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Long ah zok hoi kavak moi maw, to tih ai boeh loe khok palito hoiah kacaeh moi maw, to tih ai boeh loe khok palito pongah kapop khoknawk hoi kacaeh moi to caa o hmah; nangcae han panuet thoh. ");
INSERT INTO cekak_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Long ah kavak kawbaktih moi hoiah doeh nangmah hoi nangmah to panuet thok ah sah hmah; to moinawk hoiah kaciim ai hmuen to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kai loe na Angraeng Sithaw ah ka oh; Kai loe ciimcai pongah, nangmacae hoi nangmacae to kaciim ah angpaek oh loe, ciimcai oh; nangmacae hoi nangmacae to long ah kavak moi hoiah amhnong o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kai loe Izip prae thung hoi nangcae zaehoikung, na Angraeng Sithaw ah ka oh; to pongah Ka ciimcai baktih toengah, nangcae doeh ciimcai oh. ");
INSERT INTO cekak_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Hae loe hinghaih katawn, long nui hoi tui thungah kavak moi kasannawk, tavaanawk boih kasaeng daan ah oh; ");
INSERT INTO cekak_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","caak koi moi hoi caak koi ai moi, kaciim moi hoi kaciim ai moi to tapraek oh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Israel kaminawk khaeah thui paeh; nongpata loe zokpom moe, capa to sah nahaeloe, khrah kruek athii hnuk naah ciim ai ah ohhaih ih atawk baktih toengah, anih loe nih sarihto thung ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ni tazetto naah a capa ih tangzat hin to aah pae han oh. ");
INSERT INTO cekak_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","To pacoengah nongpata ih kuithlam to ciim hanah, ni qui thumto pacoeng, ni thumto zing vop tih; anih loe kaciim ah ohhaih ni boeng ai karoek to, kaciim hmuen to sui mak ai ueloe, hmuenciim ah doeh caeh mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Toe caa nongpata to sah nahaeloe, athii hnuk naah ciim ai ah ohhaih atawk baktih toengah, zar hnetto thung ciim ai ah om tih; to pacoengah kuithlam to ciim hanah ni qui tarukto pacoeng, ni tarukto thung zing vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Capa hanah maw, canu hanah maw, ciimhaih ni boeng naah, hmai angbawnhaih sak hanah, saningto kaom tuucaa maeto, zae angbawnhaih sak hanah, pahuu caa maeto maw, to tih ai boeh loe im pahuu maeto, amkhuenghaih kahni im thok taengah qaima khaeah sin han oh; ");
INSERT INTO cekak_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","qaima mah nongpata han zae angbawnhaih sah pae tih; to pacoengah loe nongpata to kuithlam hoiah ciim tih boeh; hae loe nongpa maw, nongpata maw caa sah nongpata han paek ih atawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Nongpata mah tuucaa to sin thai ai nahaeloe, pahuu hnetto maw, to tih ai boeh loe im pahuu hnetto sin han oh; maeto hoiah hmai angbawnhaih to sah ueloe, kalah maeto hoiah zae angbawnhaih to sah tih; qaima mah to nongpata han zae angbawnhaih sah pae tih; to naah anih loe zaehaih to ciim tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","kami maeto mah a ngan nuiah kapaw maw, phra maw, to tih ai boeh loe ngan kanglung maw, ngansae maw om nahaeloe, anih to qaima Aaron khaeah maw, to tih ai boeh loe anih capanawk thungah qaima toksah kami maeto khaeah maw caeh haih han oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Qaima mah a ngan nuiah kaom ahmaa to khen pae tih; ahmaa pong ih ngan mui to anglung moe, nganhin pongah ahmaa to thuk kue nahaeloe, ngansae ah oh; to pongah qaima mah anih to khen ueloe, ciimcai ai kami, tiah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Toe nganhin pong ih ahmaa loe anglung, toe ahmaa loe nganhin pongah thuk kue ai nahaeloe, nganmui anglung ai cadoeh, qaima mah to kami to ni sarihto thung ahmuen kalah ah suem tih; ");
INSERT INTO cekak_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ni sarihto naah qaima mah anih to khen tih; to naah ahmaa loe angmah toengroeng ah oh moe, ngan kalah bangah angcen ai nahaeloe, anih to ni sarihto thung ahmuen kalah ah suem let bae vop tih; ");
INSERT INTO cekak_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ni sarihto naah qaima mah khen let tih; to naah ahmaa to amnum moe, ngan kalah bangah angcen ai nahaeloe, to ahmaa loe ngan kapaw rumram ah oh pongah, qaima mah anih to ciim boeh, tiah taphong tih; a khukbuen to pasuk pacoengah ni to kami loe ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Toe qaima mah ciim boeh, tiah taphong pacoengah, nganhin pong ih ahmaa to pung let nahaeloe, anih mah qaima khaeah khensak let tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Qaima mah khet let naah, nganhin nuiah ahmaa to pung nahaeloe, ngansae ah oh pongah, qaima mah anih to ciimcai ai kami, tiah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ngansae man kami to qaima khaeah caeh haih let han oh; ");
INSERT INTO cekak_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","qaima mah anih to khet naah, nganhin pong ih ahmaa loe anglung, nganhin nui ih amui doeh anglung moe, nganhin pong ih ahmaa to sui hnup nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","to baktih nathaih loe kahoih thai ai nganhin nathaih ah oh pongah, qaima mah ciimcai ai kami, tiah taphong tih; anih loe ciim ai ah oh boeh pongah, ahmuen kalah ah suem mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","To nathaih loe nganhin boih ah oh moe, a lu hoi khok khoek to nathaih mah khuk boih boeh, tiah qaima mah kamtuengah hnu nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","qaima mah anih to khen tih; nathaih mah takpum to khuk boih nahaeloe, to kami to ciim boeh, tiah taphong tih; a takpum boih anglung boeh pongah, anih loe ciim boeh. ");
INSERT INTO cekak_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Toe a ngan nui ih ahmaa to sui hnup nahaeloe, anih to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Qaima mah tui baktiah kasui hnup ahmaa to hnuk naah, anih loe ciim ai kami ni, tiah taphong tih; to baktih ngan loe ciim ai pongah, ngansae ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","To ngan kaduk loe amkhraih moe, anglung nahaeloe, qaima khaeah patuek han oh; ");
INSERT INTO cekak_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","qaima mah khet naah, ahmaa to anglung nahaeloe, qaima mah to kami to ciim boeh, tiah taphong tih, to pacoengah loe anih loe ciim tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kami maeto loe takpum ah athlut to oh moe, hoih boeh, ");
INSERT INTO cekak_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","athlut ohhaih ahmuen loe anglung maw, to tih ai boeh loe kanglung hoi kathim ah tangdawh phawt moe, angphong let nahaeloe, qaima khaeah patuek han oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Qaima mah khet naah, ahmaa loe nganhin pongah thuk kue moe, ahmaa pong ih nganmui doeh anglung nahaeloe, athlut thung hoiah ngansae to tacawt pongah, qaima mah anih to kaciim ai kami, tiah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Toe qaima mah khet naah, ahmaa nui ih nganmui loe anglung ai, nganhin pongah doeh thuk ai, toe amnum nahaeloe, qaima mah anih to ni sarihto thung ahmuen kalah ah suem tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Toe to ahmaa to angpung nahaeloe, ngansae ah oh pongah, qaima mah anih to ciim ai kami, tiah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Toe ahmaa loe angmah toengroeng ah oh moe, pung ai nahaeloe, athlut ahmaa rumram ah ni oh; to pongah qaima mah anih to ciim boeh, tiah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kami maeto loe hmai mah kangh, to tiah hmai mah kangh ih ahmaa to anglung, to tih ai boeh loe thim nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","qaima mah to ahmaa to khen tih; ahmaa pong ih nganmui loe anglung moe, nganhin pongah ahmaa to thuk kue nahaeloe, hmai mah kangh ih ahmaa thung hoiah ngansae to tacawt pongah, qaima mah anih to ciimcai ai kami ah taphong tih; to loe ngansae nathaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Toe qaima mah khet naah, ahmaa pong ih nganmui loe anglung ai, ahmaa doeh thuk ai, amnum nahaeloe, qaima mah anih to ahmuen kalah bangah, ni sarihto thung omsak tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ni sarihto thung qaima mah anih to khen tih; to naah ahmaa to pung nahaeloe, qaima mah anih to ciimcai ai kami ah taphong tih; to loe ngansae ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Toe ahmaa to angmah toengroeng ah oh; pung ai moe, amnum nahaeloe, hmai mah kang rumram ih ahmaa ah oh pongah, qaima mah anih to kaciim kami ah taphong tih; to loe hmai mah kangh ih ahmaa rumram ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Nongpa, to tih ai boeh loe nongpata mah lu ah maw, to tih ai boeh loe toektaboe ah maw ahmaa om nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","qaima mah ahmaa to khen tih; ahmaa loe nganhin pongah thuk moe, nganmui doeh amsen hrawng nahaeloe, qaima mah anih to kaciim ai kami ah taphong tih; to loe ngan kamthak ah oh moe, lu nuiah maw, to tih ai boeh loe toektaboe pongah kaom, ngansae ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Toe qaima mah to baktih ahmaa to khet naah, ahmaa loe thuk parai ai moe, nganmui doeh amnum ai nahaeloe, to nathaih tawn kami to qaima mah ni sarihto thung ahmuen kalah ah suem tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ni sarihto thung qaima mah ahmaa to khen pae let tih; to naah ngan kamthak ahmaa to pung ai, nganmui doeh amsen ai, ahmaa doeh thuk ai nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","to kami mah a nganmui to aah han oh, toe ahmaa pong ih nganmui loe aah han om ai; to kami to qaima mah ni sarihto thung ahmuen kalah ah suem tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ni sarihto thung qaima mah ngan kamthak ahmaa to khen tih; toe ahmaa loe pung ai, ahmaa doeh thuk ai nahaeloe, qaima mah anih to kaciim kami ah taphong tih; anih loe a khukbuen to pasuk pacoengah ni ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Toe ciim boeh tiah taphong pacoengah, ngan kamthak ahmaa to pung let nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","qaima mah anih to khen let tih; ahmaa to nganhin nuiah pung let nahaeloe, qaima mah kamsen nganmui pakrong han angai ai; to kami loe ciim ai kami ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Toe a khet naah ahmaa loe angmah toengroeng ah oh, amui kamnum doeh tacawt ai nahaeloe, ngan kamthak ahmaa loe hoih boeh pongah, anih loe ciim boeh; to naah qaima mah anih to ciim kami ah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Nongpa maw, to tih ai boeh loe nongpata loe nganhin nuiah kanglung bok ahmaa to oh moe, ngansae ah om nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","qaima mah khen pae tih; nganhin nuiah kaom kanglung bok ahmaa loe kamnum hoi kanglung angbaeh nahaeloe, nganhin pongah kaom ahmaa rumram ah ni oh; to kami loe ciim. ");
INSERT INTO cekak_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Sam to angmuen moe, a lu doeh angmuilum ah oh; toe to kami loe ciim. ");
INSERT INTO cekak_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Hmabang sam angmuen kami loe, lupataeh amngaeh cadoeh, anih loe ciim. ");
INSERT INTO cekak_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Toe lu angmuilum nuiah maw, to tih ai boeh loe a lupataeh hmabang ah maw, ngan kamling to tadawh phawt nahaeloe, lu angmuilum nuiah kaom, to tih ai boeh loe lupataeh nuiah kaom ahmaa loe ngansae ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Qaima mah anih to khet naah, lu angmuilum nuiah kaom, to tih ai boeh loe a lu pataeh nuiah kaom ahmaa loe ngansae baktiah om nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","to kami loe ngansae man kami ah oh, anih loe ciim ai; a lu nuiah ahmaa oh pongah qaima mah anih to kaciim ai kami ah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ngansae man kami loe angmah ih laihaw to asih moe, a lu to khuk ai ah, pahni to khuk pacoengah, Ciim ai! Ciim ai! tiah hang tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","To ngansae man kami loe nathaih a tawnh thung, ciim ai ah a oh; to kami loe angmah bueng oh han oh, anih loe a ohhaih im tasa bangah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ngansae to tuumui laihaw pongah maw, to tih ai boeh loe puu ngan laihaw pongah maw om nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","thunh ih hmuen maw, to tih ai boeh loe sak ih hmuen maw, to tih ai boeh loe tuumui maw, to tih ai boeh loe moihin maw, to tih ai boeh loe moihin hoi sak ih hmuen maw, ");
INSERT INTO cekak_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","laihaw nuiah kaom ahmaa loe rong kahing maw, to tih ai boeh loe kathim ah maw om nahaeloe, ngansae ah oh; nathaih to qaima khaeah patuek han oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Qaima mah nathaih to khen ueloe, anih to ni sarihto thung ahmuen kalah ah omsak tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ni sarihto thungah khen let tih, to naah nathaih to laihaw kalah ahmuen ah maw, to tih ai boeh loe thunh ih laihaw pongah maw, tuumui hoiah sak ih laihaw pongah maw, to tih ai boeh loe moihin hoiah sak ih laihaw pongah maw, to tih ai boeh loe sak ih kawbaktih laihaw pongah maw angcen nahaeloe, ngansae ah oh pongah, ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","To pongah sak ih khukbuen, to tih ai boeh loe tuumui hoiah thunh ih khukbuen, to tih ai boeh loe tuumui hoiah sak ih khukbuen, to tih ai boeh loe puu ngan khukbuen, to tih ai boeh loe moihin hoiah sak ih khukbuen boih ah nathaih to oh boeh pongah, hmai hoi qoeng ah; angcen thaih ngansae ah oh pongah, khukbuen to hmai hoiah qoeng han oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Toe qaima mah khet naah, tlangqui hoiah sak ih khukbuen, to tih ai boeh loe thunh ih khukbuen, to tih ai boeh loe moihin hoiah sak ih khukbuen boih ah nathaih to angcen ai nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","nathaih ahmaa kaom khukbuen to pasuksak ueloe, anih to ni sarihto thung ahmuen kalah ah omsak tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Nathaih ahmaa kaom khukbuen pasuk pacoengah, qaima mah khen let tih; nathaih ahmaa loe rong amkhraih ai angmah toengroeng ah om nahaeloe, angpung ai cadoeh, ciim mak ai; athung bang hoiah a nui bangah ahnai to oh pongah, hmai hoiah qoeng han oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Qaima mah khet naah, pasuk tangcae khukbuen pong ih nathaih ahmaa to amnum nahaeloe, to ahmaa ohhaih khukbuen, to tih ai boeh loe moihin hoiah sak ih khukbuen, to tih ai boeh loe thunh ih khukbuen, to tih ai boeh loe sak ih khukbuen to asik tih. ");
INSERT INTO cekak_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Toe tlangqui hoiah sak ih khukbuen, to tih ai boeh loe thunh ih khukbuen, to tih ai boeh loe moihin hoiah sak ih khukbuen nuiah nathaih to angphong let nahaeloe, angpung thaih nathaih ah oh pongah, nathaih kaom khukbuen to hmai hoiah qoeng han oh. ");
INSERT INTO cekak_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Tlangqui hoiah sak ih khukbuen, to tih ai boeh loe thunh ih khukbuen, to tih ai boeh loe moihin hoiah sak ih khukbuen loe ciim cadoeh, pasuk let han oh; to tiah sak naah ni ciim vop tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Hae loe ciim maw, ciim ai, tiah taphong hanah, tuumui, to tih ai boeh loe puu ngan, to tih ai boeh loe sak ih khukbuen, to tih ai boeh loe thunh ih khukbuen, to tih ai boeh loe moihin hoiah sak ih khukbuen hoi kasaeng daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","ngansae man kami mah ciimhaih niah patoh koi daan loe hae tiah oh; ");
INSERT INTO cekak_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","qaima mah im tasa bangah caeh moe, to kami to khet naah, ngansae man kami loe ngantui ah om boeh nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","qaima mah nathaih ciim kami khaeah, kaciim moe, kahing tavaa hnetto, sidar thing, tlangqui kathim hoi hyssop thing tadok to sin hanah thui pae tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","qaima mah kalong tui lawn ih long laom thungah tavaa maeto boh hanah thui pae tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","to pacoengah kahing tavaa kalah maeto la ueloe, sidar thing, tlangqui kathim, hyssop thing tadok hoi nawnto kalong tui nuiah boh ih tavaa athii hoiah atok tangcae ih tui thungah nup tih: ");
INSERT INTO cekak_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ngansae ciimsak han kangaih kami nuiah vai sarihto haeh tih; to pacoengah loe anih to ciim boeh, tiah taphong tih; to pacoengah kahing tavaa to taw ah prawt tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Kaciim ah oh han kangaih kami mah a khukbuen to pasuk tih; a sam to aat ueloe, anih mah ciim thai hanah, tui amhluh tih; to pacoengah ni a ohhaih im ah caeh thai vop tih; toe a ohhaih im tasa bangah ni sarihto thung om vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ni sarihto naah lu sam, toektaboe mui, miklakoek mui hoi kalah nganmuinawk to aah boih han oh; a khukbuen to pasuk ueloe, tui amhluh tih; to naah ni anih to ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ni tazetto naah, anih mah coek koi kaom ai, tuu tae hnetto hoi saningto kaom tuu tala maeto sin ueloe, cang hoiah angbawnhaih to sak hanah, situi hoi atok tangcae, takaw dip kahoih ephah hato thungah thumto, situi thoemto hoi nawnto sin tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Anih ciimsakkung qaima mah, ciimsak han kangaih kami to, kaminawk amkhuenghaih kahni im thok taeng, Angraeng hmaa ah cang hoi angbawnhaih sak ih hmuen hoi nawnto tathlang tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","to pacoengah qaima mah tuucaa atae maeto la ueloe, situi hoi nawnto zae angbawnhaih ah paek tih; Angraeng hmaa ah ahaek ueloe, ahaek angbawnhaih ah paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Anih mah zae angbawnhaih hoi hmai angbawnhaih sak han paek ih tuucaa to, hmuenciim ah bop tih; qaima mah zae angbawnhaih sak baktih toengah, sakpazae angbawnhaih doeh qaima ih tok ah oh; hae loe kaciim koek hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Qaima mah sakpazae angbawnhaih athii thoemto la ueloe, ciimsak han kangaih kami ih bantang bang naa nui, bantang banpui nui hoi bantang khokpui nuiah suem pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","To pacoengah qaima mah situi thoemto la ueloe, angmah ih banqoi banpadae nuiah bawh tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","qaima mah a bantang ban tadong to, a banqoi ban ah kaom, situi thungah nup pacoengah, a ban tadong hoiah situi to Angraeng hmaa ah vai sarihto haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Qaima mah a ban ah kaom kamtlai situi to, ciimsak han kangaih kami ih bantang bang naa nui, bantang banpui nui hoi bantang khokpui nuiah suem ueloe, sakpazae angbawnhaih moi thii nuiah doeh suem tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Qaima ban ah kaom kamtlai situi to, ciimsak han kangaih kami lu nuiah bawh ueloe, Angraeng hmaa ah anih han zaehaih loih thai hanah angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","To pacoengah qaima mah, ciim ai kami, ciimsak hanah zae loihhaih angbawnhaih to sah pae tih; to pacoengah hmai angbawnhaih moi to bop tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","qaima mah hmaicam nuiah, cang angbawnhaih hoi hmai angbawnhaih to paek ueloe, anih hanah zae loihhaih angbawnhaih to sah pae tih; to pacoengah ni anih to ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Toe to kami loe amtang moe, to baktih hmuen to sah thai ai nahaeloe, ahaekhaih hmuen paek hoiah a sakpazae angbawnhaih to sak hanah, tuucaa maeto sin ueloe, cang hoi angbawnhaih sak hanah situi hoi atok tangcae ih kahoih takaw dip ephah hato thungah maeto, thoemto situi hoi nawnto sin tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","anih mah hak thaih koiah kaom, pahuu hnetto maw, to tih ai boeh loe im pahuu hnetto sin ueloe, maeto loe zae angbawnhaih ah paek pacoengah, kalah maeto loe hmai angbawnhaih ah paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Anih to ciimsak hanah, Angraeng hmaa ah kaminawk amkhuenghaih kahni im thok taengah, qaima khaeah, ni tazetto naah caeh haih tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Qaima mah sakpazae angbawnhaih tuucaa to la ueloe, situi hoi nawnto Angraeng hmaa ah ahaek pacoengah, ahaek angbawnhaih ah paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Anih mah zae angbawnhaih sak han paek ih tuucaa to bop ueloe, zae angbawnhaih athii thoemto lak pacoengah, ciimsak han kangaih kami ih bantang naa nui, bantang banpui nui hoi bantang khokpui nuiah suem pae tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","qaima mah a banqoi banpadae nuiah situi to bawh ueloe, ");
INSERT INTO cekak_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","a banqoi ban ah kaom kamtlai situi to a bantang banpazung hoi Angraeng hmaa ah vai sarihto haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Qaima mah a ban ah kaom kamtlai situi to, ciimsak han kangaih kami ih bantang naa nui, bantang banpui nui hoi bantang khokpui nuiah suem pae tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","qaima ban ah kaom kamtlai situi to ciimsak kangaih kami ih lu nuiah bawh ueloe, Angraeng hmaa ah zae loih thai hanah angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","To pacoengah to kami mah hak thaih koiah kaom, pahuu hnetto, to tih ai boeh loe im pahuu hnetto angbawnhaih ah paek tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","maeto loe zae angbawnhaih ah paek ueloe, kalah maeto loe cang hoi nawnto, hmai angbawnhaih ah paek tih; hae tiah qaima mah ciimsak kangaih kami hanah, Angraeng hmaa ah zaehaih loih thai hanah angbawnhaih to sah pae tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Hae loe ngansae man kami mah a zaehaih ciim hanah, sah thai ai kamtang kaminawk hanah paek ih daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","na toep o hanah kang paek o ih, Kanaan prae thungah na kun o naah, na toep o ih to prae ih im maeto thungah ngansae ka pungsak naah, ");
INSERT INTO cekak_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","im tawnkung mah caeh ueloe, qaima khaeah, Ka imthung ah nathaih baktiah kaom hmuen to oh, tiah thui nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","qaima mah nathaih khet hanah imthung ah caeh ai naah, imthung ih hmuennawk to kaciim ai hmuen ah oh han ai ah, hmuennawk to puen boih hanah thui pae tih; to pacoengah ni qaima mah im khet hanah caeh vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Anih mah nathaih to khet naah, im tapang nuiah rong kahing maw, to tih ai boeh loe kathim maw om moe, im tapang pongah thuk kue nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","qaima to thok tasa bangah tacawt ueloe, im to ni sarihto thung kha tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ni sarihto pacoengah qaima mah im to khen let tih, to naah nathaih to pung nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","to nathaih kaom thlungnawk to la ueloe, vangpui tasa bang ih kaciim ai ahmuen ah va ving tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","To im tapang nuiah kaom kaciim ai hmuennawk to talaih boih ueloe, vangpui tasa bang ih kaciim ai ahmuen ah va tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","to pacoengah kalah thlungnawk to la ueloe, to thlungnawk zuengah kalah thlungnawk to suem tih; kalah kangbet thaih param long to la ueloe, im tapang to pading tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Thlungnawk to takhoe ving boeh, thlungnawk doeh talaih boih boeh moe, im to pading boih pacoengah doeh nathaih to om let toengtoeng vop nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","qaima mah caeh ueloe, khen tih; imthung ah nathaih to pung nahaeloe, imthung ah kangcen thaih ngansae to oh pongah, im loe ciim mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","To naah anih mah im to phrae tih; thlungnawk, thingnawk hoi thlung bethaih param longnawk to la boih ueloe, anih mah vangpui tasa bang ih kaciim ai ahmuen ah caeh haih tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","To im thok khah nathung, imthung ah akun kami loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","To imthung ah iip kami loe, a khukbuen to pasuk han oh; to imthung ah buh caa kami doeh, a khukbuen to pasuk han oh. ");
INSERT INTO cekak_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Im to pading pacoengah, qaima mah khet naah, nathaih pung ai boeh nahaeloe, to im loe ciim boeh, tiah qaima mah taphong tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Anih mah im ciimsak hanah tavaa hnetto, sidar thing, tlangqui kathim hoi hyssop thing tadok to sin tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","tavaa maeto loe kalong tui nuiah long laom thungah bop ueloe, ");
INSERT INTO cekak_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","sidar thing, hyssop thing tadok, tlangqui kathim hoi kahing tavaa to lak pacoengah, boh ih tavaa athii hoi kaciim tui thungah nup tih; to pacoengah im to vai sarihto haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Tavaa ih athii, tui kalong, kahing tavaa, sidar thing, hyssop thing tadok, tlangqui kathim hoiah im to ciimsak tih; ");
INSERT INTO cekak_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","toe anih mah kahing tavaa to vangpui tasa bang ih taw ah prawt tih; to im to ciimsak hanah, to tiah angbawnhaih na sak nahaeloe, im to ciim tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Hae loe ngansae nathaih, phra, ");
INSERT INTO cekak_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","khukbuen nuiah kaom ngansae hoi im ah kaom ngansae, ");
INSERT INTO cekak_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ngan tangdawh, ngan kamthak, ngansae, ");
INSERT INTO cekak_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","congca nathaih hoi kasaeng atawk ah oh moe, kaciim hoi ciim ai panoek thai hanah, patuk koi ngansae nathaih hoi kasaeng daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Israel kaminawk khaeah, Ngan ahmaa thung hoiah ahnai tacawt kami loe, ahnai tacawt pongah ciim ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ahmaa thung hoiah ahnai tacawt cadoeh, tacawt ai cadoeh, to ahmaa mah anih to ciim ai ah ohsak boeh. ");
INSERT INTO cekak_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ahnai long kami angsonghaih ahmuen hoi anih anghnuthaih ahmuen doeh ciim mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Mi kawbaktih doeh anih angsonghaih ahmuen sui kami loe, a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","To kami anghnuthaih ahmuen ah anghnu kami doeh a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Mi kawbaktih doeh ahnai long kami to sui nahaeloe, a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ahnai tacawt kami mah ciim kami to tamtui hoiah pathoih nahaeloe, to kami loe a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","To kami mah anghnut thuih ih ahmuen boih to ciim ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Anih ohhaih ahmuen ah kaom hmuen kawbaktih doeh sui kami loe, duembang khoek to ciim mak ai; to baktih hmuen maeto sin kami doeh a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ban amsae ai ah, ahnai long kami mah kami maeto sui nahaeloe, to kami loe a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ahnai long kami mah long laom to sui nahaeloe, to long laom to pakhoih ah; thing hoiah sak ih hmuennawk loe tui hoiah pasae ah. ");
INSERT INTO cekak_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ahnai long kami ciim boeh nahaeloe, anih ciimhaih ni hoi kamtong ni sarihto pacoengah, angmah ih khukbuen to pasuk moe, tui amhluk han oh; to pacoengah ni anih to ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ni tazetto naah anih mah pahuu hnetto, to tih ai boeh loe im pahuu caa hnetto sin ueloe, Angraeng hmaa ah, amkhuenghaih kahni im thok taengah angzoh pacoengah, qaima khaeah paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","To pacoengah qaima mah zae angbawnhaih ah maeto paek tih, kalah maeto loe hmai angbawnhaih ah paek tih; to naah qaima mah ahnai long kami hanah Angraeng khaeah zae angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Nongpa loe a takpum thung hoiah tangzat tui to tacawt nahaeloe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kahni pongah maw, to tih ai boeh loe nganhin nuiah maw tangzat tui to akap nahaeloe, tui hoi pasuk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Nongpa hoi nongpata iih naah tangzat tui tacawt nahaeloe, tui amhluk hoi hmaek han oh; nihnik loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Nongpata mah athii hnuk naah, athii hnuk pongah anih loe ni sarihto thung ciim mak ai; anih sui kami loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Athii hnuk thung anih angsonghaih ahmuen to ciim mak ai; anih anghnuthaih kawbaktih ahmuen doeh ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Anih iihhaih iihkhun sui kami loe, a khukbuen to pasuk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Anih anghnuthaih ahmuen maeto sui kami loe, a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Anih anghnuthaih ahmuen maw, to tih ai boeh loe anih anghnuthaih kawbaktih ahmuen doeh sui kami loe, duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Athii hnuh nongpata hoi iip kami loe, athii hnuh nongpata mah anih to sui pongah, ni sarihto thung ciim mak ai; anih angsonghaih ahmuen doeh ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Nongpata loe athii hnuk zonghaih atue pongah kasawk ah athii to long nahaeloe, athii oh nathuem ih baktih toengah, athii long nathung anih loe ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Athii long nathung, anih angsonghaih ahmuen boih, athii long nathuem ih baktih toengah ciim mak ai; anih anghnuthaih ahmuen doeh, athii hnuk nathuem ih baktih toengah, ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","To baktih hmuennawk sui kami doeh ciim ai pongah, a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Toe nongpata loe athii hnukhaih boeng pacoeng, ni sarihto akoep naah ni ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Nongpata loe ni tazetto naah pahuu hnetto, to tih ai boeh loe im pahuu caa hnetto, amkhuenghaih kahni im thok taengah, qaima khaeah sin han oh. ");
INSERT INTO cekak_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Qaima mah zae angbawnhaih ah maeto paek ueloe, kalah maeto loe hmai angbawnhaih ah paek tih; to naah athii long pongah, ciimcai ai nongpata hanah zae angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Israel kaminawk loe angmacae kaciim ai hmuen thung hoiah pahoe ah; to tih ai nahaeloe angmacae salakah kaom Kai ih kahni im to amhnong o sak ueloe, dueh o moeng tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Hae loe ahmaa thung hoiah ahnai tacawt kami, tangzat tui long pongah amhnong kami, ");
INSERT INTO cekak_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","athii hnuh nongpata, takpum thung hoi tacawt ahnai, nongpa maw, nongpata maw, kaciim ai nongpata khaeah iip kami mah pazui han koi daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Angraeng hmaa ah angbawnhaih sak naah, Aaron capa hnik duek hmaek pacoengah, Angraeng mah Mosi khaeah lokthuih pae; ");
INSERT INTO cekak_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Angraeng mah Mosi khaeah, Nam ya Aaron duek han ai ah, hmuenciim koek thungah, lokkamhaih thingkhong ranui ah kaom, palungnathaih tangkhang pakahaih hoi payang ih kahni thungah akun han ai ah thui paeh; kai loe lokkamhaih thingkhong nuiah kaom, palungnathaih tangkhang nuiah tamai thung hoiah kam tueng han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aaron mah hmuenciim thungah akun naah, zae angbawnhaih sak hanah maitaw caa, hmai angbawnhaih sak hanah, tuucaa atae maeto sin tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Anih loe kaciim puu ngan laihaw kasawk to angkhuk ueloe, puu ngan canghnawh kasawk to abuen tih; puu ngan kazii to kaeng ah angzaeng ueloe, puu ngan lumuek to angmuek tih; to khukbuennawk loe ciim pongah, tui amhluk pacoengah angkhuk tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Zae angbawnhaih sak hanah maeh caa hnetto, hmai angbawnhaih sak hanah tuu tae maeto, Israel kaminawk khae hoiah la ah. ");
INSERT INTO cekak_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron mah a zaehaih pongah maitaw tae maeto hoiah angbawnhaih sah ueloe, anih hoi a imthung takoh hanah angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","To pacoengah maeh hnetto sin ueloe, amkhuenghaih kahni im thok taengah, Angraeng hmaa ah tathlang tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron mah maeh hnetto hanah taham khethaih phoisa to va pae tih: maeto loe Angraeng hanah va pae ueloe, kalah maeto loe zaehaih phawkung maeh ah prawt hanah va pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Taham khethaih phoisa to vah pacoengah, qoih ih maeh to Angraeng khaeah sin ueloe, zae angbawnhaih ah paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Toe zaehaih phawkung ah prawt han qoih ih maeh loe, Angraeng hmaa ah kahing ah sin ueloe, angbawnhaih ah sak han ih praezaek ah prawt tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron mah zae angbawnhaih maitaw tae to sin ueloe, angmah hoi a imthung takoh hanah zae angbawnhaih to sah pae tih; to pacoengah maitaw tae to angmah ih zae angbawnhaih sak hanah bop tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Angraeng hmaa ah kaom, hmaicam nuiah kangqong, hmaitikhaih sabae to la ueloe, kadip pueng ah naep ih hmuihoih to ban kakoiah lak pacoengah, kahni payang ih ahmuen thungah caeh haih tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Anih duek han ai ah, hmuihoih hmaikhue mah, hnukung thingkhong nuiah kaom, palungnathaih tangkhang to hmuihoisak hanah, hmuihoih to Angraeng hmaa ah hmai nuiah suem tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Anih mah maitaw tae athii to la ueloe, a banpazung hoiah palungnathaih tangkhang hmaa ah haeh tih; palungnathaih tangkhang nuiah doeh athii to a banpazung hoiah vai sarihto haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","To pacoengah kaminawk hanah, zae angbawnhaih maeh to bop ueloe, athii to kahni payang ih ahmuen thungah sin tih, maitaw tae athii hoi sak ih baktih toengah, anih mah sah let tih; athii to palungnathaih tangkhang nui hoi palungnathaih tangkhang hmaa ah haeh tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ciimcai ai Israel kaminawk zaehaih hoi nihcae sakpazaehaih boih pongah, anih mah hmuenciim ah zae angbawnhaih to sah tih; nihcae khae kaom amkhuenghaih kahni im hanah doeh, ciim ai pongah, hae tiah angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Aaron mah zae angbawnhaih sak hanah hmuenciim thungah akun moe, angmah hoi a imthung takoh, Israel acaengnawk boih han angbawnhaih sak naah, amlaem let ai karoek to, kaminawk amkhuenghaih kahni imthung ah mi doeh oh han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","To pacoengah Angraeng hmaa ih hmaicam ah a caeh moe, angbawnhaih to sak hanah, maitaw tae ih athii hoi maeh thii to la ueloe, hmaicam taengah kaom takiinawk thungah thaeng tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Athii to hmaicam nuiah a banpazung hoiah vai sarihto haeh tih, to tiah Israel kaminawk zaehaih to thoengsak ueloe, ciimsak tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Aaron mah hmuenciim, amkhuenghaih kahni im hoi hmaicam hanah, angbawnhaih sak pacoengah, kahing maeh to hmabang ah caeh haih tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","To naah Aaron mah maeh lu pongah ban to koeng ueloe, Israel kaminawk sethaih hoi sakpazaehaihnawk boih to taphong tih, to pacoengah nihcae zaehaih boih to maeh lu nuiah amtii tih; to naah a qoih ih kami maeto kawk ueloe, maeh to praezaek ah prawtsak tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Maeh mah nihcae zaehaihnawk boih to, kami om ai ahmuen ah phaw ueloe, kami mah maeh to praezaek ah prawt tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","To pacoengah Aaron loe kaminawk amkhuenghaih kahni imthung ah akun tih, hmueciim koek thungah akun ai naah, angmah angkhuk ih khukbuen to angkhring hmaloe ueloe, to ahmuen ah caehtaak tih; ");
INSERT INTO cekak_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","hmuenciim ah tui amhluk pacoengah, angmah ih khukbuen to angkhuk tih; to pacoengah angzo ueloe, angmah han ih hmai angbawnhaih to sah tih, to pacoengah kaminawk ih hmai angbawnhaih to sah pae tih; to pacoengah angmah han hoi kaminawk hanah zae angbawnhaih to sah tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Zae angbawnhaih sak ih athawk to hmaicam pongah pakhaem tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Zaehaih phawkung maeh to praezaek ah prawt kami loe, a khukbuen to pasuk moe, tui amhluk han oh; to pacoengah ni a ohhaih im ah caeh vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Hmuenciim ah zae angbawnhaih sak hanah sin ih maitaw tae hoi maeh tae thii to, a ohhaih tasa bangah sin ueloe, to ah ahin, angan hoi aeknawk to hmai hoiah qoeng tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","To tiah hmai qoeng kami loe, a khukbuen to pasuk moe, tui amhluk han oh; to pacoengah ni a ohhaih im ah caeh vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Hae loe nangcae han dungzan ah paek ih daan ah oh; khrah sarihto haih, ni hato naah, na prae kaminawk maw, to tih ai boeh nangcae khaeah kaom angvinnawk maw, toksah o sak hmah; nangmah hoi nangmah to poek kamtang ah om ah. ");
INSERT INTO cekak_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Angraeng hmaa ah zaehaih na loih o thai boih hanah, to na niah qaima mah nangcae to ciimsak hanah, zae angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hae loe dungzan ah Angraeng mah paek ih lok baktih toengah, Sabbath niah oh, to pongah poek amtanghhaih hoiah om ah. ");
INSERT INTO cekak_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ampa zuengah qaima toksak han angpaek kami, qaima ah oh han situi bawh ih kami mah, zae angbawnhaih to sah tih; anih loe puu ngan khukbuen hoi kaciim khukbuen to angkhuk tih; ");
INSERT INTO cekak_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","anih mah hmuenciim, amkhuenghaih kahni im hoi hmaicam hanah zae angbawnhaih to sah ueloe, qaimanawk hoi amkhueng kaminawk boih hanah zae angbawnhaih to sah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Hae loe Israel kaminawk ih zaehaihnawk boih pongah, saningto naah angbawnhaih vaito sak hanah, nangcae han dungzan ah paek ih daan ah oh, tiah a naa. Angraeng mah Mosi khaeah thuih ih lok baktih toengah anih mah sak. ");
INSERT INTO cekak_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Aaron hoi a capanawk, Israel kaminawk boih khaeah, Angraeng mah hae tiah thuih; ");
INSERT INTO cekak_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","kawbaktih Israel kami mah doeh maitaw maeto, to tih ai boeh loe tuucaa maeto, to tih ai boeh loe maeh to angmacae ohhaih im ah maw, to tih ai boeh loe tasa bangah maw boh moe, ");
INSERT INTO cekak_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Angraeng ih kahni im hmaa ih, amkhuenghaih kahni im thok taengah, Angraeng khaeah paek han sin ai nahaeloe, to kami to athii longsak kami ah net moe, angmah ih acaeng thung hoi pahnawt han oh. ");
INSERT INTO cekak_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Israel kaminawk loe taw ah a sak o ih angbawnhaih to, kaminawk amkhuenghaih kahni im hmaa, Angraeng hmaa ah, qaima khaeah sin o tih; to hmuen to Angraeng khaeah angdaeh angbawnhaih ahmuen ah paek o tih. ");
INSERT INTO cekak_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Qaima mah athii to amkhuenghaih kahni im thok taengah kaom, hmaicam nuiah haeh ueloe, Angraeng khaeah hmuihoih ah athawk to hmai pakhaem tih. ");
INSERT INTO cekak_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Nihcae mah angmacae hoi a takpum zawhhaih, taqawk khaeah angbawnhaih sah o mak ai boeh. Hae loe nihcae hoi a caanawk khoek to pazui han paek ih dungzan ah kaom zaehhoihhaih daan ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Nihcae khae ih, Mi kawbaktih Israel kami doeh, nihcae khaeah kaom angvinnawk doeh, hmai angbawnhaih maw, to tih ai boeh loe paek han ih hmuen maw a sin o naah, ");
INSERT INTO cekak_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","amkhuenghaih kahni im thok taengah, Angraeng khaeah sin o ai nahaeloe, to kami to angmah ih acaeng thung hoi pahnawt oh, tiah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Israel imthung takoh mah maw, to tih ai boeh loe nihcae salakah kaom angvinnawk mah maw, athii to caa o nahaeloe, athii caa kami to mikhmai ka set thuih moe, angmah ih acaeng thung hoiah pahnawt sut han. ");
INSERT INTO cekak_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Taksa hinghaih loe athii thungah oh; na sak o ih zaehaih to tahmen moe, na hing o thai hanah, to athii to hmaicam nuiah ka paek boeh; hae loe kami hing hanah zae angbawnhaih athii ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","To pongah Israel kaminawk khaeah, Nangcae thung ih mi kawbaktih doeh athii to caa o hmah; nangcae salakah kaom angvin mah doeh athii to caak han om ai, tiah ka thuih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Israel kami mah maw, to tih ai boeh loe nangcae salakah kaom angvin mah maw, moi zoep naah moi maw, tavaa maw naeh nahaeloe, athii pathok moe, athii to maiphu hoi aphum pacoengah ni, caak han oh. ");
INSERT INTO cekak_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Athii loe taksa boih hinghaih ah oh; to pongah, Nangcae loe kawbaktih moi thii doeh caa o hmah, tiah Israel kaminawk khaeah ka thuih boeh; taksa boih hinghaih loe athii ah oh pongah, athii caa kami loe, pahnawt sut ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Angmah koeh kadueh moi, moi kasan mah kaek ih moi caa kami, prae thung ih kami maw, to tih ai boeh loe angvin doeh, a khukbuen to pasuk moe, tui amhluk han oh; anih loe duembang khoek to ciim mak ai; tui amhluk pacoengah ni ciim vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Toe a khukbuen to pasuk ai moe, tui doeh amhluh ai nahaeloe, to kami loe a zaehaih tho to hnu tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Israel kaminawk khaeah, Kai loe na Angraeng Sithaw ah ka oh, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Na oh o haih, Izip prae ah na sak o ih hmuen baktiah sah o hmah; kang hoih o ih, Kanaan prae kaminawk mah sak o ih hmuen baktiah doeh sah o hmah; nihcae ih tuinuen doeh awt o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ka lokcaekhaihnawk to pazui oh loe, kang paek ih loknawk to pazui oh; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Kang paek o ih loknawk hoi ka lokcaekhaihnawk to pazui oh; pazui kami loe a pazuihaih rang hoiah hing tih; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Mi kawbaktih doeh athii kanghnai kami hoiah nongpa nongpata zaehaih to sah hmah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Nam pa ih zu ah kaom, nam no hoiah zaehaih to sah hmah; anih loe nam no ah oh pongah, nam no hoiah zaehaih to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Nam pa ih zu hoiah zaehaih to sah hmah; anih loe nam pa ih zu ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Na tanu hoiah zaehaih sah hmah; na imthung ah tapen maw, to tih ai boeh loe ahmuen kalah ah tapen maw, nam pa ih canu, nam no ih canu hoiah, zaehaih to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Nam capa ih canu, na canu ih canu hoiah zaehaih to sah hmah; anih loe nangmah ih athii angan ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Nam pa hoi nam no mah sak ih canu hoiah zaehaih to sah hmah; anih loe na tanu ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Nam pa ih tanu hoiah zaehaih to sah hmah; anih loe nam pa hoi athii kanghnai kami ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Nam no ih amnawk hoiah zaehaih to sah hmah; anih loe nam no hoi athii kanghnai canawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Nam pa amnawk ih zu hoiah zaehaih sak hanah anih to paang hmah; anih loe nam no ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Na langah hoiah zaehaih to sah hmah; anih loe na capa ih zu ah ni oh; anih hoiah zaehaih to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Nam nawk zu hoiah zaehaih to sah hmah; anih loe nam nawk ih zu ni. ");
INSERT INTO cekak_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Nongpata maeto hoi a canu to nawnto zae haih hmaek hmah; to nongpata capa ih canu hoiah maw, to tih ai boeh loe to nongpata canu ih canu patoeng hoiah maw, zaehaih to sah hmah; nihcae loe athii kanghnai canawk ah ni oh o. ");
INSERT INTO cekak_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Na zu ih amnawk to zu ah la hmah; na zu to hing vop pongah, na zu ih amnawk hoiah zaehaih to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Nongpata loe athii hnuk moe, ciimcai ai ah oh nathuem ah iihaih hanah anih taengah caeh hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nangmah hoi nangmah amhnong hanah, na imtaeng kami hoiah zaehaih to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Angbawnhaih sak hanah kawbaktih na caa doeh Molek khaeah paek hmah; na Sithaw ahmin to panuet thok ah sah hmah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Nongpata hoi nawnto iih baktih toengah, nongpa hoi nawnto iip hmah; to loe panuet thok hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Nangmah hoi nangmah amhnong hanah, kahing moi hoiah zaehaih to sah hmah; nongpata mah zaehaih sak hanah kahing moi khaeah ang paek han om ai; to hmuen loe panuet thoh moe, katoeng loklam hoi amkhraenghaih ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Hae baktih hmuen sakhaih hoiah nangmah hoi nangmah to panuet thok ah om hmah; nangcae hmaa ah ka haek ih kaminawk loe to tiah khosak o. ");
INSERT INTO cekak_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Prae to panuet thok ah a sak o; a zae o haih pongah Ka thuitaek moe, prae mah a thungah kaom kaminawk to tasa bangah pathak prok. ");
INSERT INTO cekak_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","To pongah nangcae loe kang paek ih lok hoi ka lokcaekhaihnawk to pazui oh; na prae thung tapen kami, to tih ai boeh loe nangcae salakah kaom angvinnawk mah doeh, to baktih panuet thok hmuen to saksak han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(To baktih hmuen to nangcae hmaa ah kaom, prae kaminawk mah sak o pongah, prae to panuet thoh boeh;) ");
INSERT INTO cekak_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","nangcae hmaa ah kaom kaminawk to pakha thung hoi pathak baktih toengah, nangcae doeh pathak han ai ah, panuet thok hmuen to sah o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Mi kawbaktih doeh to baktih panuet thok hmuen sah kami loe, angmacae acaeng thung hoi pahnawt han oh. ");
INSERT INTO cekak_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","To pongah nangcae hmaa ah a sak o ih panuet thok hmuennawk pongah, nangmacae hoi nangmacae amhnong han ai ah, kang paek ih lok to pazui oh; Kai loe na Angraeng Sithaw ah ka oh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Israel kaminawk boih khaeah, Kai na Angraeng Sithaw loe ciimcai pongah, nangcae doeh ciimcai oh, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kaminawk boih mah amno hoi ampa to khingya han oh, ka Sabbath ninawk to zaa oh; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Krang bokhaih bangah angqoi o hmah loe, na bok hanah hmuen to sithaw ah sah hmah; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Angraeng khaeah angdaeh angbawnhaih na paek naah, palung huemhaih hoiah paek oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","To tiah na paek o ih hmuen to angbawnhaih ni, to tih ai boeh loe khawnbang ah caa o boih ah; ni thumto karoek to amtlai vop nahaeloe, hmai thungah va ah. ");
INSERT INTO cekak_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ni thumto karoek to amtlai vop nahaeloe, caak han panuet thoh boeh pongah, koeh han koi om ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Mi kawbaktih doeh caa nganga kami loe, Angraeng ih kaciim hmuen to ciim ai ah sak pongah, a zaehaih atho to hnu tih; to kami loe angmah ih acaeng thung hoiah pahnawt sut han oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Lawk ih cang na aah o naah, lawk taki ih cangnawk to aat o bit hmah, kanghmat cangqui to akhui let hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Misurthaih doeh pakhrik bit hmah; kanghmat misurthaih to akhui hmah; kamtang kami hoi angvin han caehtaak ah; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Paqu hmah, minawk aling hmah, maeto hoi maeto amsawnlok thui hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ka hmin hoiah amsoem ai lokkamhaih to sah hmah, na Sithaw ih ahmin kasae to thui hmah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Na imtaeng kami to aling hmah, anih ih hmuen doeh lomh pae hmah; atho paek hanah na tlai ih kami hanah toksakhaih atho paek ai ah, duembang hoi khawnbang khoek to patawn pae ving hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Naa pang kami to loksae hoiah tapring hmah, mikmaeng amthaek hanah a hmaa ah thing to pakhang pae khoep hmah; na Sithaw to zii ah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Katoeng lokcaekhaih to toeng ai ah takoih hmah; kamtang kami to pahnawt sut hmah loe, kalen kaminawk ih mikhmai doeh khen hmah; na imtaeng kami to toenghaih hoiah lokcaek ah. ");
INSERT INTO cekak_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Na caeng kaminawk khaeah kami prong hanah paqai hmah; na imtaeng kami ih athii palong hanah pacaeng hmah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Na palung thung hoiah nam nawk to hnuma hmah; na imtaeng kami sakpazaehaih hmuen pongah athum han ai ah, anih to zoeh ah. ");
INSERT INTO cekak_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nangmah ih acaeng kami nuiah a sakpazaehaih baktih toengah pathok hmah; na imtaeng kami to nangmah ih takpum baktiah palung ah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Kang paek ih loknawk to pazui ah. Kanghmong ai maitaw to apaa cuksak hmah; na lawk thungah kanghmong ai anmuu to haeh hmah; kanghmong ai laihaw sak hanah puu ngan hoi tuumui to patoh hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Nongpata maeto loe misong ah oh, anih loe sava sak hanah loksuek tangcae ah oh boeh, toe anih to akrang ai vop moe, misong hoiah doeh loih ai vop; to nongpata misong to nongpa maeto mah iip haih nahaeloe, anih to danpaek han oh; to nongpata loe misong hoiah loih ai vop pongah, paduek hmaek han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Toe nongpa loe a sak ih zaehaih pongah angbawnhaih sak hanah, Tuu tae maeto amkhuenghaih kahni im thok taengah, Angraeng khaeah a sin han oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","To nongpa loe a sak ih zaehaih thung hoi loih thai hanah, qaima mah tuu tae maeto hoiah Angraeng hmaa ah zae angbawnhaih to sah pae tih; to naah anih zaehaih to tahmen tih. ");
INSERT INTO cekak_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Prae thungah na kun o moe, congca thingthai kungnawk na thling o naah, to thingthai to tangzat hin aat ai thingthai tiah poek oh loe, to thingthai to caa o hmah: nangcae han saning thumto thung tangzat hin aat ai thingthai ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Saning palito naah loe athaih to ciim boih tih boeh, to naah Angraeng to pakoeh han oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Toe saning pangato naah loe, thingthai to na caa o tih boeh; to tiah na sak o nahaeloe na thling o ih thingthai to pung tih; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Athii kaom kawbaktih moi doeh caa o hmah; lungh khethaih hoi atue pakoephaih to doeh sah o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Na lu taeng ih sam to aat o boih hmah; toektaboe mui doeh aat o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Kadueh kami hanah na taksa to aat o hmah; na takpum nuiah angmathaih sah o hmah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Na canu to takpum zaw kami ah angcoengsak hanah sah hmah; to tih ai nahaeloe na prae kami boih mah na takpum to zaw o ueloe, na prae to sethaih hoiah koi tih. ");
INSERT INTO cekak_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kai ih Sababth ninawk to zaa ah loe, Ka hmuenciim to saiqathaih paek ah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Kadueh pakhranawk khaeah caeh o hmah; nam hnong o han ai ah lungh aat kop kaminawk khaeah doeh caeh o hmah; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Sampok kami hmaa ah angdoe ah loe, saning coeh kami to saiqat ah; na Sithaw to saiqat ah; Kai loe na Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Na prae thung kaom angvin to poek angphosak hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nangcae khaeah kaom angvin to aimah acaeng kami baktiah poek oh loe, nangmah ih takpum baktih toengah palung ah; nangcae doeh Izip prae ah angvin ah ni na oh o; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Hmuen tahhaih, kazit tahhaih hoi hmuen noek naah, katoeng ai tahhaih to patoh hmah. ");
INSERT INTO cekak_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Katoeng hmuenzit tahhaih, katoeng tahhaih ephah hoi katoeng situi tahhaih hint to patoh ah; Kai loe Izip prae thung hoi nangcae zaehoikung, na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","To pongah kang paek ih loknawk hoi ka lok takroekhaihnawk hae pazui o boih ah; Kai loe Angraeng ah ka oh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Angraeng mah Mosi taengah, ");
INSERT INTO cekak_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Israel kaminawk khaeah, Israel kami maw, to tih ai boeh loe Israel kaminawk khaeah kaom angvinnawk maw, a caanawk to Molek khaeah paek kami loe, hum han oh; angmah ih acaeng kaminawk mah anih to thlung hoiah va o maat tih. ");
INSERT INTO cekak_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ka hmuenciim to amhnongsak moe, kaciim Kai ih ahmin to tidoeh sah ai ah, a caa to Molek khaeah paek pongah, to kami to mikhmai ka pan thuih mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","A caa Molek khaeah paek kami to, acaeng kaminawk mah khen o sut moe, anih to hum o ai nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","to kami to mikhmai ka set thuih han; angmah hoi a imthung takoh, Molek khaeah takpum zawh hanah, a hnukah patom kami loe, angmah ih acaeng thung hoiah ka pahnawt sut han. ");
INSERT INTO cekak_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Kadueh pakhranawk hoi lungh aah kop kami khaeah caeh moe, takpum zawh hanah nihcae hnukah bang kami loe, mikhmai ka set thuih han; anih to angmah ih acaeng thung hoiah ka pahnawt sut han. ");
INSERT INTO cekak_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Kai loe na Angraeng Sithaw ah ka oh pongah, nangmacae hoi nangmacae to amhoe o ah loe, ciimcai ah om oh. ");
INSERT INTO cekak_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kai loe nangcae ciimsakkung Angraeng ah ka oh pongah, ka zaehhoihaih daan to pazui oh loe, sah oh. ");
INSERT INTO cekak_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Amno hoi ampa tangoeng kami loe, paduek han oh; anih loe amno hoi ampa to tangoeng pongah, duek han krak. ");
INSERT INTO cekak_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Minawk zu hoi zaehaih sah kami loe, a imtaeng kami ih zu hoiah zaehaih to a sak pongah, nongpa doeh, nongpata doeh paduek hmaek han oh. ");
INSERT INTO cekak_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ampa ih zu hoi nawnto iip kami loe, ampa ih zu to a zae haih pongah, nongpa doeh, nongpata doeh paduek hmaek han oh; nihnik loe duek hmaek han krak. ");
INSERT INTO cekak_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Angmah ih langah hoi nawnto iip kami loe, panuet thok hmuen to a sak hoi pongah, nongpa doeh, nongpata doeh paduek hmaek han oh; nihnik loe duek han krak. ");
INSERT INTO cekak_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Nongpata iih haih baktih toengah, nongpa hoi nongpa to iip hoi nahaeloe, panuet thok hmuen to a sak hoi pongah, paduek hmaek han oh; nihnik loe duek han krak. ");
INSERT INTO cekak_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Nongpa maeto mah canu hoi amno to zu ah la hmaek nahaeloe, kasae hmuen to a sak pongah, to baktih kasae hmuen to nangcae salakah oh thai han ai ah, nihcae to hmai hoiah thlaek boih han oh. ");
INSERT INTO cekak_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Nongpa maeto mah kahing moi hoiah zaehaih to sah nahaeloe, anih to paduek han oh; zae a sak haih kahing moi doeh paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Nongpata doeh kahing moi hoiah zaehaih to sah nahaeloe, to nongpata hoi kahing moi to hum hmaek han oh; nihnik to paduek hmaek han oh; nihnik loe duek han krak. ");
INSERT INTO cekak_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Nongpa maeto loe ampa ih canu, to tih ai boeh loe amno ih canu hoiah maw, to tih ai boeh loe angmah ih tanu hoiah maw zaehaih sah nahaeloe, kasae hmuen to a sak hoi pongah, angmah ih acaeng kaminawk mikhnuk ah nihnik to pahnawt sut han oh; angmah ih tanu to a zae haih pongah, a zaehaih tho to hnu tih. ");
INSERT INTO cekak_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Nongpata athii hnuk naah, anih hoi iip nongpa loe, athii long nongpata to a zae haih baktih toengah, nongpata mah doeh athii long naah nongpa hoi zaehaih sak pongah, nihnik to angmacae acaeng thung hoiah pahnawt han oh. ");
INSERT INTO cekak_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Nam no ih amnawk nongpata, to tih ai boeh loe nam pa ih tanu nongpata hoiah zaehaih to sah hmah; to bak tih athii kazoi canawk hoi zaehaih sah kaminawk loe, a sak hoi ih zaehaih tho to hnu o tih. ");
INSERT INTO cekak_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ampa amnawk ih zu hoiah iip kami loe, a sak hoi ih zaehaih tho to hnu hoi ueloe, hing thung caa sah ai ah dueh hoi tih. ");
INSERT INTO cekak_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Angmah amnawk ih zu lomh kami loe, ciimcai ai hmuen to a sak; angmah amnawk ih zu to a zae haih pongah, caa sah mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","To pongah ka zaehhoih daannawk hoi ka lokcaekhaih to pazui boih moe, sah nahaeloe, kang paek han ih prae thung hoiah kang pathaak mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Nangcae hmaa ah ka haek ih kaminawk ih tuinuen baktiah khosah o hmah; nihcae loe to baktih hmuennawk to a sak o pongah, ka panuet. ");
INSERT INTO cekak_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Toe nangcae khaeah, Nihcae ih prae to na toep o tih, maitaw tahnutui hoi khoitui longhaih prae to qawk ah kang paek o han, tiah kang thuih o boeh; Kai loe kalah prae kaminawk thung hoi nangcae tapraekkung, na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","To pongah kaciim moi hoi kaciim ai moi, kaciim tavaa hoi kaciim ai tavaa to pahoe ah; moi hoiah maw, to tih ai boeh loe tavaa hoiah maw, to tih ai boeh loe long ah kavak moinawk hoiah maw panuet thok ah om hmah; to moinawk loe nangcae han ciimcai ai moi, tiah ka pahoe boeh. ");
INSERT INTO cekak_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kai Angraeng loe ciimcai pongah, nangcae doeh Kai han ciimcai oh; kai ih kami ah na oh o hanah, kalah prae kaminawk thung hoiah kang pahoe o boeh. ");
INSERT INTO cekak_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Nongpa doeh, nongpata doeh, taqawk muithla tawn kami, to tih ai boeh loe miklet patoh kami loe, paduek han oh; nihcae to thlung hoi vah maat han oh; to baktih kami loe duek han krak, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Angraeng mah Mosi khae ah, Aaron capa qaimanawk hanah, Qaima loe nangcae salak ih kadueh kami pongah amhnong han om ai, tiah thui paeh; ");
INSERT INTO cekak_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","toe kadueh ih caanawk, angmah hoi anghnai kami, amno maw, ampa maw, a capa maw, a canu maw, angmah ih amnawk hanah maw, ");
INSERT INTO cekak_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","to tih ai boeh loe tangla kacuem, angmah khaeah kaom angmah ih tanu maw, sava tawn ai a tanunawk loe ciimcai ai ah doeh oh thaih. ");
INSERT INTO cekak_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Toe angmah ih acaeng ukkung loe, angmah hoi angmah to amhnong han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Qaimanawk loe sam aah muilum han om ai; toektaboe mui doeh aah han om ai; ngan doeh a aah o han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Nihcae loe angmacae ih Sithaw khaeah ciimcai ah oh o moe, angmacae ih Sithaw hmin kasae a thuih o han om ai; Angraeng khaeah hmai angbawnhaih to sak moe, Sithaw khaeah buh hoi angbawnhaih a sak o pongah, nihcae loe ciimcai ah oh o han angaih. ");
INSERT INTO cekak_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Qaimanawk loe angmacae ih Sithaw khaeah ciim o pongah, takpum zaw nongpata, to tih ai boeh loe ciimcai ai nongpata, minawk mah pakhrak ih nongpata to zu ah lak han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Nangcae ih buh to Sithaw khaeah tathlang kami ah oh pongah, anih loe nangcae han ciimcai kami ah om tih; nangcae ciimsakkung, Kai Angraeng loe ciimcai pongah, nihcae to kaciim ah poek oh. ");
INSERT INTO cekak_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Qaima canu loe a takpum to zawh moe, angmah hoi angmah ciimcai ai ah sah nahaeloe, ampa to amhnongsak kami ah oh pongah, anih to hmai hoiah qoeng han oh. ");
INSERT INTO cekak_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Angmah ih nawkamya thungah saning coeh koek, lu nuiah situi bawh ih kami, qaima ih kahni angkhuk hanah caksak ih kami mah loe, a lu nui ih sam to pakhrah mak ai ueloe, a khukbuen doeh angkhring mak ai; ");
INSERT INTO cekak_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","kadueh qok ohhaih ahmuen ah caeh mak ai, ampa hoi amno hanah doeh panuet thok ah oh han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Angmah Sithaw ih situi hoiah bawh moe, caksak boeh pongah, anih mah Sithaw ih hmuenciim to caehtaak han om ai, hmuenciim doeh amhnongsak han om ai; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Anih ih zu loe tangla kacuem ah oh han angaih. ");
INSERT INTO cekak_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Lamhmai maw, minawk mah pakhrak ih nongpata maw, to tih ai boeh loe tangzat zaw nongpata maw to zu ah lak han om ai; angmah acaeng thung ih tangla kacuem khue to zu ah lak han oh. ");
INSERT INTO cekak_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","To tiah sakhaih rang hoiah angmah acaeng thung ih angzo han koi a caanawk loe ciimcai ah om o tih; Kai loe anih ciimsakkung, Angraeng ah ka oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Aaron khaeah, Aangzo han koi na caanawk thungah coek koi kaom kami mah Sithaw khaeah buh tathlang han om ai, tiah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Mi kawbaktih doeh coek koi kaom kami, mikmaeng maw, to tih ai boeh loe khokkhaem maw, to tih ai boeh loe hnah kangphaek kami maw, to tih ai boeh loe ngan kamtlai kami maw, ");
INSERT INTO cekak_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","to tih ai boeh loe khok angkhaek kami maw, ban angkhaek kami maw, ");
INSERT INTO cekak_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kaengkuu maw, to tih ai boeh loe kahnaem daek kami maw, to tih ai boeh loe mik akoep ai kami maw, to tih ai boeh loe phra man kami maw, to tih ai boeh loe ngan kamthak tawn kami maw, to tih ai boeh loe zangtii om ai kami loe, anih taengah caeh han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Qaima Aaron acaeng thungah takpum akoep ai kami loe, hmai angbawnhaih sak hanah Angraeng hmaa ah caeh han om ai; a takpum ah coek koi oh pongah, buh tathlang hanah angmah ih Angraeng khaeah caeh han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Anih loe kaciim hoi kaciim koek, angmah Sithaw ih buh to caa thai tih. ");
INSERT INTO cekak_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Toe anih loe coek koi oh pongah, payang ih kahni thungah caeh mak ai ueloe, hmaicam ah doeh caeh mak ai; ka hmuenciim doeh amhnongsak han om ai; Kai loe nihcae ciimsakkung, Angraeng ah ka oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","To pongah Mosi mah hae lok hae, Aaron hoi a capanawk hoi Israel kaminawk boih khaeah thuih pae. ");
INSERT INTO cekak_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Aaron hoi a capanawk loe Israel kaminawk mah paek o ih kaciim hmuennawk hoi kamhoe ah oh o han oh; kai khaeah paek o ih kaciim hmuennawk hoiah ka hmin to amhnong o sak han om ai, tiah thui paeh; Kai loe Angraeng ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Angzo han koi caanawk boih thung ih, ciimcai ai kami mah, Israel kaminawk mah Angraeng khaeah ciimcai ah paek o ih kaciim hmuen taengah caeh nahaeloe, to kami to Ka hmaa hoi kamhoe ah suem oh; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Aaron ih caanawk thungah ngansae man kami maw, to tih ai boeh loe ahmaa thung hoiah ahnai tacawt kami maw om nahaeloe, ciimcai ai karoek to anih loe, kaciim ah paek ih hmuennawk to caa mak ai. Mi kawbaktih doeh ciimcai ai qok sui kami maw, to tih ai boeh loe tangzat tui pathok nongpa maw, ");
INSERT INTO cekak_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","to tih ai boeh loe ciimcai ai long ah kavak hmuen maeto sui kami maw, kami maeto mah ciimcai ai ah ohsak ih kami maw, to tih ai boeh loe kaciim ai hmuen maeto mah akap thuih ih kami loe ciimcai ai kami ah oh boeh. ");
INSERT INTO cekak_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","To baktih ciimcai ai hmuen sui kami loe, duembang khoek to ciim mak ai; tui amhluh ai ah loe anih mah kaciim ah paek ih hmuennawk to caa mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Anih loe niduem naah ni ciim vop tih, kaciim ah paek ih hmuen loe nihcae ih buh ah oh pongah, ciim pacoengah ni kaciim ah paek ih hmuen to caa o thai vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Angmah koeh ah kadueh moi hoi moisan mah kaek ih moi to caa hmah; a takpum amhnong hanah to baktih moi to caak han om ai; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Qaimanawk loe amhnong o moe, angmacae zaehaih pongah, a duek o han ai ah, ka paek ih loknawk to pazui o han oh; Kai loe nihcae ciimsakkung, Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Prae kalah kami loe kaciim ah paek ih hmuen to caa mak ai; qaima im ah katoem angvin maw, to tih ai boeh loe anih mah tlai ih kami mah doeh kaciim ah paek ih hmuen to caa mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Toe qaima mah angmah ih phoisa hoi qan ih kami maw, to tih ai boeh loe angmah ih imthung ah tapen kami loe, buh to caa thai tih. ");
INSERT INTO cekak_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Qaima canu to minawk kalah khaeah sava sah nahaeloe, kaciim ah paek ih hmuen to caa thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Toe qaima canu loe lamhmai maw, to tih ai boeh loe sava hoi ampraek ving moe, caa sah ai ah ampa im ah amlaem let pacoengah, tangla nathuem ih baktih toengah ampa im ah om nahaeloe, ampa ih buh to caa thai tih; toe minawk kalah mah loe caa thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Panoek ai ah kaciim ah paek ih hmuen to caa moeng kami loe, a caak moeng ih hmuen hoi nawnto ah pangato thungah maeto thap moe, qaima khaeah paek han angaih. ");
INSERT INTO cekak_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Israel kaminawk mah Angraeng khaeah paek o ih, kaciim hmuen to qaima mah amhnongsak han om ai; ");
INSERT INTO cekak_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","to tiah paek ih kaciim hmuen to caak moeng pongah, anih nuiah zaehaih kraksak han om ai; Kai loe nihcae ciimsakkung, Angraeng ah ka oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Aaron hoi a capanawk hoi Israel kaminawk boih khaeah, Israel imthung takoh thung hoi tacawt kami mah maw, to tih ai boeh loe Israel kaminawk salakah kaom prae kalah kami mah maw, lokkamhaih sak ih baktiah hmuen tathlanghaih maw, to tih ai boeh loe angmah koeh ah sak ih hmuen tathlanghaih maw, Angraeng khaeah hmai angbawnhaih ah sak naah; ");
INSERT INTO cekak_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","talawk thai koiah kaom coek koi kaom ai, maitaw tae maw, tuu hoi maeh maw paek han oh. ");
INSERT INTO cekak_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Toe coek koi kaom hmuen to paek hmah; to baktih hmuen loe talawk thai koi hmuen ah om ai; ");
INSERT INTO cekak_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","lokkamhaih baktiah paek ih hmuen, angmah palung angthawk baktiah paek ih hmuen ah, maitaw tae maw, tuu maw Angraeng khaeah na paek nahaeloe, anih mah talawk thai hanah, coek koi kaom ai, kakoep to paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kawbaktih hmuen doeh mikmaeng, to tih ai boeh loe ahuh angkhaek, to tih ai boeh loe khokkhaem, khokban akoep ai, to tih ai boeh loe ahlut hoi ahnai kaom hmuen hoiah Angraeng khaeah hmuen tathlanghaih to sah hmah; Angraeng han hmaicam pongah hmai angbawnhaih to sah hmah; ");
INSERT INTO cekak_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","na palung angthawkhaih hoi paek ih hmuen ah loe, coek koi kaom maitaw maw, tuu maw na paek thaih; toe lokkamhaih baktiah hmuen tathlanghaih sak naah loe coek koi kaom hmuen to talawk thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ngan kabawk, to tih ai boeh loe ahmaa kaom, to tih ai boeh loe ahuh angkhaek, to tih ai boeh loe aahhaih ahmaa kaom moi to Angraeng han paek hmah; na prae thungah to baktih moi tathlanghaih to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","To baktih moi to prae kalah kami mah Angraeng khaeah paek langlacadoeh, akoep ai moe, coek koi doeh oh pongah, talawk thai mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","maitaw tae maw, to tih ai boeh loe tuu maw, to tih ai boeh loe maeh to tapen naah, ni sarihto thung amno khaeah omsak ah; ni tazetto pacoengah loe Angraeng khaeah hmai angbawnhaih to sak thai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Maitaw maw, tuu maw, nito thungah a caa hoi nawnto bop hmaek hmah. ");
INSERT INTO cekak_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Angraeng khaeah anghoehaih hmuen to na paek o naah, na palung angthawkhaih baktih toengah paek oh. ");
INSERT INTO cekak_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Na paek niah moi to caa o boih ah; khawnbang khoek to suem o hmah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","To pongah ka paek ih lok hae pakuem ah loe pazui ah; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kaciim Kai ih ahmin to amhnong o sak hmah; Kai loe Ka ciim, tiah Israel kaminawk mah poek o han oh; Kai loe nangcae ciimsakkung, Angraeng ah ka oh, ");
INSERT INTO cekak_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","nangcae ih Sithaw ah Ka oh hanah, Izip prae thung hoi nangcae zaehoikung ah ka oh; Kai loe Angraeng ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Israel kaminawk khaeah, Angraeng ih poih ninawk, Kai ih hae poih ninawk loe, kaciim amkhuenghaih niah oh, tiah taphong ah. ");
INSERT INTO cekak_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ni tarukto thung toksah oh; toe ni sarihto ni loe anghakhaih Sabbath niah oh, kaciim amkhuenghaih niah oh pongah, tih tok doeh sah o hmah; na oh o haih ahmuen boih loe Angraeng ih Sabbath niah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Atue phak naah nangcae mah taphong han ih, kaciim amkhuenghaih hoi Angraeng ih poih ninawk loe, ");
INSERT INTO cekak_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","khrah tangsuek, ni hatlai palito na ni, duembang loe Angraeng loihhaih niah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","To ih akhrah hatlai pangato haih ni loe, taeh thuh ai ih takaw hoiah Angraeng khaeah sak ih poih ah oh; ni sarihto thung taeh thuh ai ih takaw to caa oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ni hmaloe koek ah toksah ai, kaciim amkhuenghaih to sah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ni sarihto thung Angraeng khaeah hmai angbawnhaih to sah oh; sarihto ni loe kaciim amkhuenghaih niah oh pongah, toksah o hmah, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Israel kaminawk khaeah hae tiah thui paeh; kang paek ih prae thungah na kun o moe, cang na aah o naah, na aah o tangsuek ih cangqui to qaima khaeah sin oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Na paek ih hmuen to talawk hanah, qaima mah cangqui to Angraeng hmaa ah ahaek tih, qaima mah Sabbath ni pacoeng, khawnbang ah ahaek tih. ");
INSERT INTO cekak_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Cangqui to ahaek moe, na paekhaih niah, coek koi kaom ai saningto kaom tuucaa hoiah Angraeng khaeah angbawnhaih to sah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Cang hoi angbawnhaih sak naah, situi hoi atok tangcae kahoih takaw dip ephah hato thungah hnetto, Angraeng khaeah hmuihoih ah paek hanah, hmai angbawnhaih to sah ah; naek koi paek hanah misurtui hint palito thungah maeto paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Na Sithaw khaeah paekhaih ni pha ai karoek to, takaw maw, to tih ai boeh loe haek ih cang maw, to tih ai boeh loe aan kahingnawk to caa o hmah; hae loe na oh o haih ahmuen kruek ah, angzo han koi na caanawk khaeah dungzan ah paek ih lok ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Ahaek moe, paek koi cangqui sinhaih ni, Sabbath ni pacoeng, khawnbang ni hoi kamtong, Sabbath ni sarihto kroek ah. ");
INSERT INTO cekak_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Sabbath ni pacoeng, khawnbang hoi kamtong, ni qui pangato kroek pacoengah, Angraeng khaeah cang kangtha to paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Angraeng hanah athai tangsuek thingthai, taeh hoi abaeh ih kahoih takaw ephah hato thungah hnetto, ahaek moe, paek koi takaw kae hnetto ah sah ah loe, nangmacae im hoiah sin oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","To takaw hoi nawnto coek koi kaom ai, saningto kaom tuucaa sarihto, saning kanawk maitaw tae maeto, tuu tae hnetto paek oh; Angraeng khaeah paek hanah hmai hoi thlaek ih hmuihoih, takaw angbawnhaih hoi naek koi angbawnhaih loe, Angraeng hmaa ah sak ih hmai angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","To pacoengah zae angbawnhaih sak hanah maeh caa maeto, angdaeh angbawnhaih sak hanah, saningto kaom, tuucaa hnetto paek ah. ");
INSERT INTO cekak_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Qaima mah Angraeng hmaa ah tuucaa hnetto, athai tangsuek thingthai hoi sak ih takaw hoi nawnto ahaek ueloe, ahaek angbawnhaih to sah tih; to tiah paek ih hmuen loe qaima han, Angraeng hmaa ah kaciim hmuen paekhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","To na niah karai tok to sah o hmah, kaciim amkhuenghaih ni, tiah taphong oh; na oh o haih ahmuen kruekah, hae loe angzo han koi na caanawk hanah, dungzan ah paek ih lok ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Na prae thung ih cang na aah o naah, lawk taki ah kaom cangnawk to aat o boih hmah, cangqui doeh anghmat ai ah akhui o boih hmah; kamtang hoi angvinnawk hanah caeh o taak ah; Kai loe na Angraeng Sithaw ah ka oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Israel kaminawk khaeah hae tiah thui paeh; Khrah sarihto haih, ni hmaloe koek loe, Sabbath ni, mongkah uenghaih ni hoi kaciim amkhuenghaih niah suem oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Karai tok to sah o hmah; toe Angraeng khaeah hmai angbawnhaih to sah oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Khrah sarihto haih, ni hato naah loe, nangcae han zae angbawnhaih ni, kaciim amkhuenghaih niah oh; nangmah hoi nangmah to poek kamtang ah om ah loe, Angraeng hmaa ah hmai angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Na Angraeng na Sithaw hmaa ah, na zae angbawnhaih niah oh pongah, to na niah toksah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","To na niah angmah hoi angmah poekhaih kamtang ah om ai kami loe, angmah ih acaeng thung hoi pahnawt han oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","To na niah toksah kami loe, kai mah angmah ih acaeng thung hoiah ka pahnawt han. ");
INSERT INTO cekak_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","To na niah loe kawbaktih tok doeh sah hmah; na oh o haih ahmuen kruekah, hae loe angzo han koi na caanawk hanah, dungzan ah paek ih lok ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","To na ni loe anghakhaih Sabbath ni, nangmah hoi nangmah patangkhanghaih niah oh; to khrah ni takawtto haih, duembang hoi kamtong khawnbang aduem khoek to Sababth ni to zaa ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Israel kaminawk khaeah hae tiah thui paeh; Khrah sarihto haih, ni hatlai pangato hoi kamtong, ni sarihto thung loe Angraeng ih kahni im poih sakhaih niah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ni tangsuek loe kaciim amkhuenghaih niah oh pongah, karai tok to sah hmah. ");
INSERT INTO cekak_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ni sarihto thung Angraeng khaeah hmai hoi angbawnhaih to sah oh loe, ni tazetto naah kaciim amkhuenghaih to sah oh; Angraeng khaeah hmai hoi angbawnhaih to sah oh; to loe lensawk amkhuenghaih ah oh pongah, karai tok to sah o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Hae loe Angraeng ih poih niah oh moe, Angraeng khaeah hmai hoi sak ih angbawnhaih, hmai hoi angbawnhaih, cang hoi angbawnhaih, moi hoi angbawnhaih, naek koi hmuen hoi angbawnhaihnawk to na sak o hanah, kaciim amkhuenghaih ah taphong oh; ");
INSERT INTO cekak_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","to pacoengah Angraeng ih Sabbath ni, tangqum paekhaih ni, lokkamhaih baktiah hmuen paekhaih ni, aimah palung angthawk baktih toengah, Angraeng khaeah hmuen paekhaih niah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Lawk thung ih thingthai qumponawk na pakhrik o pacoeng, khrah sarihto haih, ni hatlai pangato naah, ni sarihto thung Angraeng khaeah poih to sah oh; hmaloe koek ni loe Sabbath niah om ueloe, ni tazetto doeh Sabbath niah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ni hmaloe koek ah kahoih thingthai, thaankung tanghangnawk, kabuk thing tanghangnawk, tui taengah amzam akungnawk to la oh loe, na Angraeng Sithaw hmaa ah, ni sarihto thung anghoe oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Saning kruek ni sarihto thung Angraeng ih poih nito sah oh. Hae loe angzo han koi na caanawk khaeah, dungzan ah paek ih lok ah oh; to poih to ni sarihto naah sah oh. ");
INSERT INTO cekak_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Nangcae loe ni sarihto thung im tetta pongah om oh; Israel prae thungah tapen kaminawk boih loe impoem ta thungah na oh o han oh; ");
INSERT INTO cekak_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","to naah ni kai mah Izip prae thung hoiah Israel kaminawk ka zaeh naah, impoem ta thungah ka ohsak, tito na caanawk mah panoek o tih; Kai loe na Angraeng Sithaw ah ka oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","To pongah Mosi mah, Angraeng mah thuih ih poih ninawk to Israel kaminawk khaeah taphong pae. ");
INSERT INTO cekak_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Apet ai ah hmai paang hanah, Israel kaminawk khaeah, kaciim olive situi sin o han thui paeh. ");
INSERT INTO cekak_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Kaminawk amkhuenghaih kahni im thung ih, hnukung kahni payanghaih tasa bangah, duembang hoi khawnbang khoek to Angraeng hmaa ah paaang ih hmai to, Aaron mah boeng ai ah khen tih; hae loe angzo han koi na caanawk khaeah dungzan ah paek ih lok ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron mah Angraeng hmaa ah kaciim sui hoi sak ih hmaithawk tung nuiah paaang ih hmaiim to boeng ai ah khen tih. ");
INSERT INTO cekak_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Kahoih takaw dip to la ah loe, takaw kae hatlai hnetto sah ah; takaw dip ephah hato thung ih hnetto hoiah takaw kae maeto ah sah ah. ");
INSERT INTO cekak_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Takaw to Angraeng hmaa ih kaciim caboi nuiah kaom, suekhaih asom hnetto nuiah suem ah; asom maeto nuiah takaw kae tarukto suem ah. ");
INSERT INTO cekak_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Angraeng khaeah hmai hoi angbawnhaih sak ih panoek poehaih takaw ah oh hanah, asom hnetto nuiah suek ih takaw nuiah hmuihoih to suem ah. ");
INSERT INTO cekak_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Dungzan lokkamhaih baktih toengah, Aaron mah Israel kaminawk ban thung hoi lak ih to takaw to Sabbath ni kruek Angraeng hmaa ah patoem tih. ");
INSERT INTO cekak_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","To takaw loe Aaron hoi a capanawk ih takaw ah oh; to pongah nihcae mah hmuenciim ah caa o tih; to takaw loe Angraeng khaeah sak ih hmai angbawnhaih hmuen thungah, dungzan ah paek ih daan baktih toengah, Aaron hanah kaciim koek hmuen ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Amno loe Israel kami, ampa loe Izip kami ah kaom, kami maeto loe Israel kaminawk salakah caeh; ohhaih ahmuen ah to Israel nongpata ih capa hoi Israel kami maeto angpan hoi. ");
INSERT INTO cekak_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","To naah Israel nongpata ih capa mah Angraeng ih Ahmin to kasae thuih moe, tangoeng. To pongah anih to Mosi khaeah caeh o haih; (anih amno ih ahmin loe Shelomith; Dan acaeng, Debri ih canu ah oh;) ");
INSERT INTO cekak_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Angraeng koehhaih nihcae khaeah amtueng ai karoek to anih to imthung ah a suek o. ");
INSERT INTO cekak_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","tangoeng kami to ohhaih im tasa bangah caeh haih ah; anih ih lok thaih kaminawk boih mah anih ih lu nuiah ban to koeng o pacoengah, rangpui mah anih to thlung hoiah va o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Israel kaminawk khaeah, Mi kawbaktih doeh angmah ih Sithaw tangoeng kami loe, a sak ih zaehaih tho to hnu tih. ");
INSERT INTO cekak_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Angraeng ih ahmin kasae thui kami loe, paduek tangtang han oh; rangpui mah anih to thlung hoiah va o tih; angvin doeh, acaeng kami doeh, Angraeng ih ahmin kasae thui kami loe, paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Kami hum kami loe, paduek tangtang han oh. ");
INSERT INTO cekak_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Moi duehsak kami loe, moi to dueksak pongah tawnkung hanah moi maeto hoiah laem pae let tih; ");
INSERT INTO cekak_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","kami maeto mah a imtaeng kami to ahmaa caasak nahaeloe, a sak ih hmuen baktih toengah anih nuiah sah pathok ah. ");
INSERT INTO cekak_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ahuh khaek nahaeloe, ahuh khaek pae toeng ah; mik hanah mik; haa hanah haa; anih mah kalah kami to ahmaa caaksak baktih toengah, anih to ahmaa caasak toeng ah. ");
INSERT INTO cekak_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Pacah ih moi paduek kami loe, moi hoiah rong let tih; kami hum kami loe, anih doeh hum han oh. ");
INSERT INTO cekak_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Angvin maw, acaeng kami maw, kanghmong lokcaekhaih daan maeto hoiah lokcaek ah; Kai loe na Angraeng Sithaw ah ka oh, tiah a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mosi mah Israel kaminawk khaeah, tangoeng kami to ohhaih im tasa bang caeh o haih ah loe, thlung hoiah va oh, tiah a naa. Angraeng mah Mosi khae thuih ih lok baktih toengah, Israel kaminawk mah sak o. ");
INSERT INTO cekak_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Sinai mae ah Angraeng mah Mosi khaeah lokthuih pae; ");
INSERT INTO cekak_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Israel kaminawk khaeah, Kang paek han ih prae thungah na caeh o naah, prae loe Angraeng khaeah Sabbath ni to zaa tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Saning tarukto thung lawk to sah oh; saning tarukto thung misur takha to pathoep oh loe, misurthai to pakhrik oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Toe saning sarihto naah loe lawk han anghakhaih Sabbath ah om ueloe, Angraeng khaeah Sabbath ah om tih; lawk sah o hmah loe, misur takha doeh sah o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Angmah koeh ah amprawk cang to aat o hmah loe, na sah o ai ih misurthai doeh pakhrik o hmah; lawk to saningto thung anghak o sak ah. ");
INSERT INTO cekak_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Sabbath saning thungah angmah koeh ah amprawk thingthai qumpo boih loe nangmacae han ih, na tamna nongpa hoi na tamna nongpata han ih, na tlai ih na tamna hoi nangcae khaeah kaom angvin hanah om tih; ");
INSERT INTO cekak_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","to pacoengah na pacah ih maitaw hoi na lawk thungah kaom moinawk hanah doeh om tih; lawk thungah kathai thingthainawk to na caak boih thaih. ");
INSERT INTO cekak_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Sabbath saning, saning sarihto kroek ah, saning sarihto to alet sarihto ah pungsak ah; to naah Sabbath saning sarihto loe, saning qui pali, takawt to ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","To pacoengah khrah sarihto haih, ni hato naah, zaehaih loih thai hanah sak ih angbawnhaih niah prae thung boih ah mongkah to ueng oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Saning qui pangato to ciim o sak ah loe, prae thung kaom kaminawk boih khaeah, loihhaih to taphong oh; hae loe nangcae han Jubili ah om tih; kami boih a tawnh o ih hmuen hoiah a oh o haih ahmuen ah amlaem o tih, angmah ih acaeng khaeah amlaem o let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Saning qui pangato naah loe nangcae han Jubili ah om tih; cang tuh o hmah loe, angmah koeh ah amprawk cang doeh aat o hmah; misurthai doeh pakhrik o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Hae loe Jubili ah oh pongah, nangcae han ciim; lawk hoi tacawt thingthai qumponawk to caa oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Jubili saning ah loe, kami boih mah a tawnh o ih hmuen ohhaih ahmuen ah amlaem o let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nangcae loe na imtaeng kami maeto hoi maeto khaeah hmuenmae zawhhaih maw, to tih ai boeh loe qanhaih maw na sak o naah, maeto hoi maeto pacaekthlaek o hmah; ");
INSERT INTO cekak_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Jubili pacoeng ih saning to kroek ah loe, to ih saning zetto atho hoiah na imtaeng kami khaeah qan oh, anih mah doeh kathai han koi thingthai qumpo saning to kroek ueloe, to ih saning zetto ni nang cae khaeah zaw toeng tih; ");
INSERT INTO cekak_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","kathai han koi thingthai saning to khet moe, thingthainawk to zawh ah oh pongah, saning kasawk ah kathai han koi om nahaeloe, atho pasangh oh ah loe, saning tamsi ah kathai han koiah om nahaeloe, atho zoi o sak ah. ");
INSERT INTO cekak_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Maeto hoi maeto pacaekthlaek o hmah; na Sithaw to zii oh; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ka lok takroekhaihnawk to pakuem moe, kang paek ih zaehhoihaih daan to na pazui o nahaeloe, prae thungah monghaih hoi kho na sah o tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","To naah prae mah thingthai qumpo to tacawtsak ueloe, zok kamhah ah na caak o pacoengah, ngancuem ah kho na sah o tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Nangcae mah, Lawk a sah o ai moe, cang doeh a tuh o ai nahaeloe, saning sarihto haih naah timaw a caak o han loe? tiah na poek o doeh om tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Saning tarukto thung tahamhoihaih kang paek o moe, saning thumto thung kakhawt ah thingthai qumpo to kang tacawt o sak han. ");
INSERT INTO cekak_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Saning tazetto haih naah loe cang to na tuh o tih, toe cang kangtha aahhaih tue khoek to, saning takawtto thung cang kangquem to na caa o vop tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Lawk loe kai ih hmuen ah oh pongah, dungzan ah lak hanah minawk khaeah zaw o hmah; nangcae loe kai khaeah kaom angvin ah ni na oh o. ");
INSERT INTO cekak_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Prae boih ah kaom na tawnh o ih hmuen akrang let thai hanah paek oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Nam nawkamya loe amtang parai pongah, a tawnh ih hmuen to zawh ving boeh; toe a canawk mah akrang hanah angzo o nahaeloe, amnawk mah zawh ving ih hmuen to akrang thai let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Toe to long akrang kami to om ai moe, canghni ih long tawnkung angmah akrang thaih koiah om nahaeloe; ");
INSERT INTO cekak_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","long zawhhaih saning hoiah kroek amtong ueloe, katang atho to a zawh ih kami hanah paek let tih; to pacoengah loe to long to angmah ih hmuen ah om let tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Toe long tho to paek thai ai nahaeloe, Jubili saning pha ai karoek to a zawh ih hmuen to qankung khaeah om tih; Jubili phak naah loe, qankung mah paek let ueloe, angmah ih hmuen ah om let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kami maeto mah sipae hoi thungh ih vangpui thungah kaom im to zaw nahaeloe, a zawh pacoeng saningto thung, a zawhhaih saning akoep naah, a zawh ih im to akrang let thaih. ");
INSERT INTO cekak_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Saningto thung akrang let thai ai nahaeloe, sipae kaom vangpui to qankung hoi anih ih caanawk mah dungzan khoek to angmah ih qawk ah suem o tih boeh; Jubili pha cadoeh paek let mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Toe sipae om ai vangta ih imnawk loe, lawk baktiah oh pongah, akrangsak let ueloe, Jubili naah paek let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Levi kaminawk ohhaih vangpuinawk hoi a tawnh o ih imnawk loe, natuek naah doeh akrang o thai let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Israel acaeng thungah Levinawk loe, ohhaih vangpuinawk hoi imnawk ai ah loe, tih kalah hmuen tawn o ai pongah, Levinawk ih vangpui hoi imnawk loe kami maeto mah qan cadoeh, Jubili phak naah loe paek let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Toe angmacae vangpui taeng ih ahmuennawk loe, nihcae mah dungzan ah toep koi qawk ah oh pongah, zawh han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Nam nawkamya loe amtang parai pongah, angmah hoi angmah angcom thai ai, anih loe nawnetta kaom angvin baktiah khosah nahaeloe, nangcae salakah a oh thaih toeng hanah, anih to abomh ah. ");
INSERT INTO cekak_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Anih khae hoiah kamek hmuen maw, to tih ai boeh loe kapung acaa maw la o hmah; nam nawkamya to nangcae khaeah khosak thai hanah, na Sithaw to zii oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Anih khae hoi kapung acaa caak hanah phoisa to coi o sak hmah loe, cang doeh kamtlai ah pathok han paek o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Kai loe na Sithaw, nangcae khaeah Kanaan prae paek hanah, Izip prae hoiah nangcae zaehoikung, na Angraeng Sithaw ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Nangcae salakah kaom nam nawkamya maeto loe amtang parai pongah, nangcae khaeah angmah hoi angmah to angzaw nahaeloe, anih to tamna baktiah toksah o sak hmah. ");
INSERT INTO cekak_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Anih to tlai ih tamna baktih, nangcae khaeah nawnetta kaom kami baktiah poek oh; anih loe Jubili saning pha ai karoek to nangcae han toksah pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","To pacoengah anih to a caanawk hoi nawnto prawt ah, nihcae loe angmacae kaminawk khaeah amlaem o let tih, ampanawk ih hmuen ohhaih ahmuen ah caeh o let tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Israel kaminawk to Izip prae thung hoiah ka zaehhoih, ka tamna ah a oh o pongah, tamna ah zawh han om ai. ");
INSERT INTO cekak_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nihcae to kana parai ah uk o hmah; na Sithaw to zii oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Na tamna nongpa doeh, tamna nongpata doeh, nangmacae taengah kaom Sithaw panoek ai kaminawk khaeah qan oh. ");
INSERT INTO cekak_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nangcae salakah nawnetta thung kaom kaminawk hoi na prae thungah tapen nihcae ih caanawk to na qan o thaih; nihcae loe nangcae ih hmuen ah om o tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Nihcae loe na caanawk hoi nawnto qawktoep o thaih ueloe, hing thung na tamna ah om o poe tih; toe nam nawkamya Israel kami loe, maeto hoi maeto kana parai ah uk o hmah. ");
INSERT INTO cekak_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Nangcae khae nawnetta kaom kami maw, to tih ai boeh loe angvin loe angraeng parai, toe nangcae khaeah kaom nam nawkamya loe amtang parai pongah, nangcae khaeah nawnetta kaom kami khaeah maw, to tih ai boeh loe angvin khaeah maw, to tih ai boeh loe angvin ih imthung takohnawk khaeah maw, angmah hoi angmah to angzaw nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","angmah hoi angmah angzawh pacoengah doeh, akrang let thai vop; angmah ih nawkamya maeto mah anih to akrang thaih; ");
INSERT INTO cekak_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ampa ih amnawk mah maw, to tih ai boeh loe ampa amnawk ih caa mah maw, anih to akrang let thai tih; to tih ai boeh loe anih ih caanawk hoi anih ih imthung takoh mah akrang let thaih. ");
INSERT INTO cekak_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Angmah hoi angmah angzaw kami hoi qankung loe anih khaeah zawhhaih saning hoiah Jubili karoek to kroek ueloe, tawnkung mah anih tamna ah tlaihaih saning zetto atho to khaek tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Saning pop ah om vop nahaeloe, qanhaih phoisa thung hoiah akranghaih phoisa to azuk ueloe, paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Toe Jubili karoek to, tamna ah ohhaih saning zetta ah om nahaeloe, a ohhaih saning zetto kroek ueloe, phoisa to paek tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Anih loe saningto pacoeng saningto tlai ih kami baktiah om tih; na mikhnuk ah anih to kana parai ah uk hmah. ");
INSERT INTO cekak_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Anih to saningto thung akrang o ai cadoeh, Jubili saning phak naah, anih loe a caanawk hoi nawnto tawnkung ban thung hoiah loih tih. ");
INSERT INTO cekak_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Israel kaminawk loe Ka tamna ah oh o; nihcae loe Izip prae thung hoiah Ka zaeh ih, Ka tamna ah oh o, Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Krang maw, to tih ai boeh loe sakcop ih krang maw, to tih ai boeh loe krang doeh thling o hmah; bok hanah na prae thungah kawbaktih krang doeh thling o hmah; Kai loe na Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ka Sabbath to zaa oh loe, kai ih hmuenciim to khingya oh; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ka zaehhoihaih daan to na pazui o moe, ka thuih ih loknawk baktih toengah na sak o nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","atue phak naah kho kang zohsak han, long mah caaknaek to tacawtsak ueloe, thing mah thingthai qumpo to athaisak tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Misurthaih pakhrikhaih atue khoek to cang atithaih om ueloe, misurthaih pakhrikhaih atue doeh, cang tukhaih atue khoek to om tih; zok kamhah ah na caa o ueloe, na prae thungah ngancuem ah kho na sah o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Prae thungah angdaehhaih ka ohsak han, mi mah doeh pazihhaih om ai ah na iip o tih; kasae moisannawk doeh prae thung hoiah ka hawh boih han, na prae thungah sumsen alaekhaih akun mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Na misanawk to na patom o ueloe, nihcae loe nangcae hmaa ah, sumsen hoiah amtim o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Nangcae long pangato mah kami cumvaito na patom o ueloe, nangcae cumvaito mah kami sang hato na patom o tih; na misanawk loe nangcae hmaa ah, sumsen hoiah amtim o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nangcae to kang bomh pongah, kang pungsak moe, nangcae hoiah ka sak ih lokmaihaih to ka caksak han. ");
INSERT INTO cekak_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Na patung o ih cang kangquem to boeng ai naah, cang kangtha to tacawt boeh pongah, caa boih ai ah cang kangquem to na pathok o ving tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ka hinghaih mah nangcae to panuet ai, nangcae salakah kahni im to ka sak han. ");
INSERT INTO cekak_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nangcae salakah ka caeh moe, nangcae ih Sithaw ah ka oh han, nangcae loe kai ih kami ah na om o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Izip kaminawk ih tamna ah na oh o han ai ah, Kai loe Izip prae thung hoi nangcae zaehoikung, na Angraeng Sithaw ah ka oh; hmuen kazit phawhhaih hnam to kang khaehsak moe, katoeng ah kang caeh o sak boeh. ");
INSERT INTO cekak_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Toe ka lok na tahngai o ai moe, ka thuih ih lok na pazui o ai nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Ka zaehhoihaih daan to tiah doeh na sah o ai, to tih ai boeh loe ka lok takroekhaih to na panuet o moe, ka lokmaihaih na phraek o pacoengah, kang paek o ih loknawk to na pazui o ai nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","nangcae nuiah hae tiah ka sak han; nangcae ih mik to kam rosak thaih, poekhaih kang phosak thaih, zit kathok hmuen, kaduehsak thaih kasae nathaih to kang phak o sak han; na tuk o ih cang loe azom pui ah om ueloe, na misanawk mah ni caa o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nangcae to palung kang phui thuih moe, na misanawk hmaa ah kang duek o sak han; nangcae hnuma kaminawk mah na uk o ueloe, mi mah doeh patom ai to mah nangmacae koeh ah na cawn o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Hae tiah hmuen oh pacoengah doeh ka lok hae na tahngai o ai toengtoeng vop nahaeloe, na zaehaihnawk pongah, alet sarihto kang thuitaek o han. ");
INSERT INTO cekak_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nam oek o haih tha to ka khaeh han, nangcae ih van to sum baktiah ka ohsak moe, nangcae ih long doeh sum kamling baktiah ka ohsak han. ");
INSERT INTO cekak_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Azom pui ah ni tha na pathok o tih; na lawk ah cangqui tacawt mak ai ueloe, na prae thung ih thing mah doeh athaih tacawtsak mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ka lok na tahngai o ai moe, ka misa ah na oh o nahaeloe, nangmacae zaehaih baktih toengah, nangcae nuiah raihaih alet sarihto ka pungsak han. ");
INSERT INTO cekak_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Na caanawk to ka lomh ving moe, na tawnh o ih maitawnawk to kam rosak pacoengah, nang ih kaminawk tamsi o hanah, kasan tawmoinawk kang patoeh han, to naah loe na caehhaih loklamnawk to angqai krang tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","To tiah hmuen na tongh o pacoengah doeh, ka thuih ih lok to na tahngai o ai moe, ka misa ah na oh o toengtoeng vop nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","kaimah roe nangcae ih misa ah ka oh moe, na zaehaihnawk pongah alet sarihto raihaih kang paek o han. ");
INSERT INTO cekak_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nangcae nuiah sumsen to ka laek moe, ka lokmaihaih na phraek o haih atho to kang pathok o han; na vangpuinawk thungah nawnto nam khueng o naah, nangcae salakah kasae nathaih to kang phaksak moe, misanawk ban ah kang paek o han. ");
INSERT INTO cekak_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Na caak han ih buh to kang pakha pae o khoep han, nongpata hato mah camphaek laom maeto pongah takaw pahai o ueloe, takaw zetta ni na paek o tih; to naah zok nam hah o mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","To tiah oh pacoengah doeh ka lok hae na tahngai o ai moe, ka misa ah na oh o toengtoeng vop nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","kai doeh palung ka phui moe, nangcae ih misa ah ka oh toeng han; na zaehaihnawk pongah alet sarihto raihaih kang paek o han. ");
INSERT INTO cekak_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Na capanawk hoi na canunawk ih ngan to na caa o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nangcae ih kasang ahmuennawk to ka phraek moe, na sak o ih krang to kang paro pae o pacoengah, nangcae ih kadueh qoknawk to hinghaih tawn ai krangnawk nuiah ka pasongh boih han; nangcae to kang panuet tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Na vangpuinawk to kam rosak boih moe, na hmuenciimnawk doeh angqai krang ah ka ohsak han; nangcae mah na thlaek o ih hmuihoih doeh ka pahnuem mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Na prae to angqai krang ah ka ohsak han, to naah a thungah kaom na misanawk mah dawnrai o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Sithaw panoek ai kaminawk salakah nangcae to kam hetsak moe, ka sumsen hoiah kang patom o han; na prae to angqai krang ah ka suek moe, na vangpuinawk doeh kam rosak boih han. ");
INSERT INTO cekak_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Nangcae loe na misanawk ih prae thungah angqai krang ah na om o tih; to naah na prae to anghak ueloe, Sabbath to zaa tih; na prae mah Sabbath ni to anghoe haih tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Nangcae na oh o naah, Sabbath ni to anghak ai pongah, angqai krang ah oh nathung, prae to anghak tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Misanawk ih prae thungah anghmat nangcae ih kaminawk palungthin thungah, thazokhaih to ka paek han; thingqam kangtawt atuen to nihcae mah thaih o naah zii o ueloe, sumsen zit pongah cawnh ih baktih toengah cawn o tih; mi mah doeh patom ai ah amtimh o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Mi mah doeh patom ai to mah, sumsen zit pongah kacawn kami baktiah maeto nuiah maeto amtimh o tih; na misanawk hmaa ah nang doe o thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Sithaw panoek ai kaminawk hmaa ah nam ro o ueloe, na misanawk ih prae mah na pa-aeh o boih tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Nangcae thung ih kanghmat kaminawk loe angmacae zaehaih hoi ampanawk ih zaehaih pongah, ampanawk hoi nawnto misa prae thungah thazok o sut tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Toe ka nuiah a sak o ih zaehaih, ka koeh ai ih loklam ah a caeh o haih, kahoih ai hmuen pongah a zae o haih hoi ampanawk ih zaehaih pongah, ");
INSERT INTO cekak_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","kai loe nihcae ih misa ah ka oh boeh moe, nihcae to misanawk ih prae thungah ka caeh haih boeh, tiah a zae o haih to taphong o moe, tangzat hin aat ai palungthin to atlim ah pakhrak o pacoengah, a zae o haih atho baktih toengah danpaekhaih to tapom o nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Jakob hoiah ka sak ih lokmaihaih, Issak hoiah ka sak ih lokmaihaih, Abraham hoiah ka sak ih lokmaihaih to ka pakuem poe han, prae to ka pahnet mak ai. ");
INSERT INTO cekak_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Nihcae mah prae to caeh o taak tih, nihcae om ai naah prae mah Sabbath ni to zaa tih; nihcae mah ka lokcaekhaih patoek o moe, ka zaehhoihaih daannawk to panuet o pongah, a zae o haih atho to hnu o tih. ");
INSERT INTO cekak_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","To tiah om o langla cadoeh, misa prae thungah a oh o naah, nihcae to amrosak moe, nihcae hoi ka sak ih lokmaihaih to phraek hanah, nihcae to ka pahnawt mak ai, panuet doeh ka panuet mak ai; Kai loe nihcae ih Angraeng Sithaw ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nihcae ih Sithaw ah ka oh hanah, Sithaw panoek ai kaminawk mikhnuk ah, Izip prae hoiah ka zaeh ih, nihcae cunkungnawk hoi ka sak ih lokmaihaih to nihcae han ka pahnet pae mak ai; Kai loe Angraeng ah ka oh, tiah a thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Hae loe Mosi patohhaih rang hoiah Sinai mae ah Sithaw angmah hoi Israel kaminawk salakah sak ih zaehhoihaih daan, lok takroekhaih hoi kaalok ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Angraeng mah Mosi taengah, ");
INSERT INTO cekak_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Israel kaminawk khaeah hae tiah thui paeh; nihcae khaeah, Kami maeto mah angmah ih atho kating ah, Angraeng khaeah paek han lokkamhaih sah nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","na pakoep o han ih atho loe hae tiah oh; saning pumphaeto hoi saning qui tarukto kaom nongpa loe, hmuenciim ih shekel tahhaih pongah, phoisa shekel qui pangato hoi akrang han oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nongpata ah om nahaeloe phoisa qui thumto hoiah akrang tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Saning pangato hoi saning pumphaeto salak ih kami ah om nahaeloe, nongpa to shekel pumphaeto hoiah akrang ueloe, nongpata to shekel hato hoiah akrang tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Khrahto hoi saning pangato salak kami ah om nahaeloe, nongpa to shekel pangato hoi akrang ueloe, nongpata to shekel thumto hoiah akrang tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Saning qui tarukto hoi ranui bang kami ah om nahaeloe, nongpa to shekel hatlai pangato hoiah akrang ueloe, nongpata to shekel hato hoiah akrang tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Anih loe na khaeh ih atho pongah amtang kue nahaeloe, to kami to qaima khaeah caeh haih ah; qaima mah anih ih atho to khaek tih; lokkamhaih sahkung mah paek thaih ih atho baktih toengah, qaima mah atho to khaek pae tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Paek han lokkam ih hmuen loe pacah ih moi ah oh moe, Angraeng khaeah tathlang hanah sin nahaeloe, a paek ih hmuen to ciim. ");
INSERT INTO cekak_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kahoih maw, kasae maw, moi maeto hoi maeto athlaeng han om ai; moi maeto hoi maeto athlaeng nahaeloe, to moi hoi athlaeng han koeh ih kalah moi maeto loe ciimcai han angaih. ");
INSERT INTO cekak_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kaciim ai moi ah om nahaeloe, Angraeng khaeah tathlang han om ai; to pongah moi to khet hanah qaima khaeah caeh haih ah; ");
INSERT INTO cekak_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","anih mah kasae kahoih, atho to thui tih; atho loe qaima mah khaeh ih baktih toengah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Paekkung mah akrang han koeh nahaeloe, khaeh ih atho nuiah pangato thungah maeto thap ueloe akrang tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kami maeto mah a im to Angraeng khaeah kaciim ah paek han koeh nahaeloe, kahoih maw, ka sae maw, atho loe qaima mah khaeh ih baktih toengah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","To im to ciimsakkung mah akrang koeh nahaeloe, khaeh ih atho nuiah pangato thungah maeto thap ueloe, akrang tih; to pacoengah loe anih ih im ah om tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Kami maeto mah a lawk ahap Angraeng khaeah paek nahaeloe, cang nazetto maw akunh, tito khet moe, atho khaeh han oh; barli cang homer maeto naah, atho phoisa shekel qui pangato oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jubili saning thungah a lawk to paek nahaeloe, atho khaeh tangcae baktiah om poe tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Toe Jubili pacoengah ciimsak hanah lawk to paek nahaeloe, qaima mah hmabang ih Jubili phak hanah saning nazetto maw angai vop, tito kroek ueloe, khaeh tangcae ih atho to azuk tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ciimsakkung mah angmah ih lawk to akrang let han koeh nahaeloe, khaeh tangcae atho nuiah pangato thungah maeto thap ueloe, akrang tih; to pacoengah loe a lawk ah om let tih boeh. ");
INSERT INTO cekak_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Toe lawk to akrang let han koeh ai moe, kalah kami khaeah zaw nahaeloe, akrang let thai mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Jubili naah lawk to paek let nahaeloe, Angraeng khaeah paek ih hmuen ah oh baktih toengah, lawk to ciim tih; to lawk to qaimanawk ih hmuen ah om tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kami maeto mah angmah ih lawk na ai, kalah lawk to qan moe, Angraeng khaeah paek nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","qaima mah Jubili karoek to khaeh ih atho to kroek ueloe, Angraeng khaeah ciimsakhaih niah atho to paek roep tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Jubili saning phak naah loe, to lawk zaw kami, lawk tawnkung khaeah paek let tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Khaeh ih atho loe hmuenciim ih shekel tahhaih baktih toengah om ueloe, shekel maeto naah gerah pumphaeto om tih. ");
INSERT INTO cekak_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Toe Angraeng ih hmuen ah kaom, tapen tangsuek pacah ih moinawk loe mi mah doeh ciimsak hanah tathlang han om ai; maitaw maw, to tih ai boeh loe tuu maw Angraeng ih hmuen ah ni oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kaciim ai pacah ih moi loe, na khaeh ih atho baktih toengah akrang ah, khaeh ih atho nuiah pangato thungah maeto thap ah loe akrang ah; akrang han koeh ai nahaeloe, khaeh tangcae atho baktih toengah zaw ah. ");
INSERT INTO cekak_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Toe kami maeto mah tawnh ih kami maw, to tih ai boeh loe moi maw, to tih ai boeh loe lawk maw, Angraeng khaeah lokkam hoi paek ih hmuennawk boih loe, zaw thai mak ai ueloe, akrang doeh akrang let thai mak ai; palungthin boih hoi paek ih hmuen loe Angraeng khaeah kaciim koek hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Kaminawk mataeng doeh, paek tangcae kami loe, akrang let thai ai; hum han ni oh boeh. ");
INSERT INTO cekak_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Lawk ih cang maw, to tih ai boeh loe thingthai qumponawk maw, hato thungah maeto loe Angraeng ih hmuen ah oh, Angraeng ih kaciim hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kami maeto mah hato thungah maeto akrang koeh nahaeloe, khaeh ih atho nuiah pangato thungah maeto thap pacoengah, akrang han oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Tuu maw, to tih ai boeh loe maitaw maw, tuu khawngkung ih cunghet thungah akun moinawk boih, hato thungah maeto loe, Angraeng khaeah kaciim hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Anih mah kasae maw, kahoih maw, qoi mak ai, moi doeh maeto hoi maeto athlaeng mak ai; athlaeng han koeh nahaeloe, paek ih moi hoi athlaeng ih moi to ciim hmaek han oh; akrang doeh akrang thai mak ai, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Hae loe Sinai mae ah Israel kaminawk han, Angraeng mah Mosi khaeah paek ih loknawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Israel kaminawk Izip prae thung hoi tacawthaih saning hnet, khrah hnetto haih hmaloe koek niah, Sinai praezaek ih kaminawk amkhuenghaih kahni imthung ah, Angraeng mah Mosi khaeah hae tiah lokthuih pae, ");
INSERT INTO cekak_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","nawnto amkhueng Israel kaminawk thungah, angmacae acaeng hoi angmacae imthung takoh thung ih nongpanawk boih, ");
INSERT INTO cekak_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","nang hoi Aaron mah saning pumphaeto pacoeng ranui bang kaom, misatuh thaih Israel kaminawk boih to milu kok hoih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Acaeng maeto thung ih acaeng zaehoikung lu koek kami maeto mah nang hnik to abom o tih. ");
INSERT INTO cekak_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Milu kroek naah nang hnik hoi nawnto angdoe han kami ahminnawk loe, Reuben acaeng thung hoiah Shedeur capa Elizur. ");
INSERT INTO cekak_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon acaeng thung hoiah, Zurishaddai capa Shelumiel. ");
INSERT INTO cekak_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Judah acaeng thung hoiah, Amminadab capa Nahshon. ");
INSERT INTO cekak_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Issakar acaeng thung hoiah, Zuar capa Nathanel. ");
INSERT INTO cekak_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zebulun acaeng thung hoiah, Helon capa Eliab. ");
INSERT INTO cekak_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Joseph ih caanawk; Ephraim acaeng thung hoiah, Ammihud capa Elishama; Manasseh acaeng thung hoiah, Pedahzur capa Gamaliel. ");
INSERT INTO cekak_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benjamin acaeng thung hoiah, Gideoni capa Abidan. ");
INSERT INTO cekak_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan acaeng thung hoiah, Amishaddai capa Ahiezer. ");
INSERT INTO cekak_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asher acaeng thung hoiah, Okran capa Pagiel. ");
INSERT INTO cekak_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad acaeng thung hoiah, Deuel capa Eliasaph. ");
INSERT INTO cekak_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naphtali acaeng thung hoiah, Enan capa Ahira cae hae ni. ");
INSERT INTO cekak_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Hae kaminawk loe amkhueng kaminawk salakah ahmin kamthang, acaeng zaehoikung hoi Israel kaminawk lu koek ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","To tiah ahmin paek ih kaminawk to Mosi hoi Aaron mah kawk moe, ");
INSERT INTO cekak_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","kaminawk to khrah hnetto haih, hmaloe koek niah amkhuengsak; kaminawk loe angmacae ih acaeng hoi imthung takoh ahmin to thuih o moe, saning pumphaeto hoi ranui bang kaminawk ih ahmin to pakoep o. ");
INSERT INTO cekak_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Angraeng mah Mosi khae paek ih lok baktih toengah, Israel kaminawk to Sinai mae ah a kroek. ");
INSERT INTO cekak_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Israel ih calu, Reuben ih caanawk thungah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Reuben acaengnawk loe, sing pali, sang taruk, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeon ih caanawk thungah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Simeon acaengnawk loe, sing panga, sang takawt, cumvai thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad ih caanawk thung hoiah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gad acaengnawk loe, sing pali, sang panga, cumvai taruk, qui pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Judah ih caanawk thung hoiah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Judah acaengnawk loe, sing sarih, sang pali, cumvai tarukto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Issakar ih caanawk thung hoiah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Issakar acaengnawk loe sing panga, sang pali, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zebulun ih caanawk thung hoiah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zebulun acaengnawk loe sing panga, sang sarih, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Joseph ih capa hnik; Ephraim ih caanawk thung hoiah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ephraim acaengnawk loe sing pali, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manasseh ih caanawk thungah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manasseh acaengnawk loe, sing thum, sang hnet, cumvai hnetto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benjamin ih caanawk thung hoiah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Benjamin acaengnawk loe sing thum, sang panga, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan ih caanawk thungah, angmacae ih acaeng hoi imthung takoh thung ih caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan acaengnawk loe sing taruk, sang hnet, cumvai sarihto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Asher ih caanawk thungah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Asher acaengnawk loe, sing pali, sangto pacoeng, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naphtali ih caanawk thung hoiah, angmacae ih acaeng hoi imthung takoh caanawk boih, saning pumphaeto pacoeng ranui bang kaom, misatuh thaih nongpa boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naphtali acaengnawk loe, sing panga, sang thum, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Hae kaminawk loe Mosi hoi Aaron mah, angmacae imthung takoh maeto thung hoi kami maeto, Israel zaehoikung hatlai hnetto thung hoiah qoih hoi ih kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Saning pumphaeto pacoeng ranui bang kaom, misatuh thaih kaminawk boih, Israel caanawk thungah angmacae imthung takoh kaminawk boih ahmin to kroek naah, ");
INSERT INTO cekak_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Sangqum boih ah kami sang cumvai taruk, sang thum, cumvai panga, qui pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Toe Levi acaeng hoi nihcae imthung takohnawk loe, nihcae hoi nawnto kroek o ai. ");
INSERT INTO cekak_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Levi acaeng loe kroek hmah loe, Israel kaminawk thungah doeh athumsak hmah. ");
INSERT INTO cekak_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Toe Levi kaminawk loe hnukung lokthuihaih kahni im khenzawnkung, laom sabaenawk boih hoi to imthung ah kaom hmuennawk boih toepkung ah suem ah; nihcae loe kahni im hoi laom sabaenawk boih to apu o tih; nihcae mah kahni im thung ih sak han koi tok to sah o ueloe, ataihaih ahmuen phak o naah, kahni im taengah om o tih. ");
INSERT INTO cekak_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kahni im puenhaih tue phak naah, Levi kaminawk mah pakuem o ueloe, kahni im sakhaih tue phak naah doeh, Levi kaminawk mah sah o tih; kahni im taengah kacaeh kalah kami loe paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israel kaminawk mah angmacae ih im sak o naah, misatuh kami boih mah, angmacae ataihaih ahmuen to angmacae hoi karaem ah sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Toe amkhueng Israel kaminawk nuiah palungphuihaih phak han ai ah, Levi kaminawk loe hnukung lokthuihaih kahni im taengah atai o ueloe, hnukung lokthuihaih kahni im to khenzawn o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Israel kaminawk mah sak o. ");
INSERT INTO cekak_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Israel kaminawk boih mah, angmah ih khosakhaih dan baktih toengah im to sak moe, imthung takoh angmathaih kahni payanghaih taengah, rangpui amkhuenghaih kahni im to sahsak ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ni tacawthaih ni angyae bangah, Judah acaeng misatuh kaminawk loe angmacae angmathaih kahni payang ih baktih toengah ohhaih im to sah o tih; Amminadab capa Nashon loe, Judah kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Kroek naah anih ih misatuh kaminawk loe sing sarih, sang qui pali, cumvai tarukto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Nihcae taengah Issakar acaengnawk ohhaih im to sah o tih; Zuar capa Nathanel loe Issakar kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Kroek naah anih ih misatuh kaminawk loe sing panga, sang pali, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Zebulun acaengnawk loe nihcae taengah om o tih; Helon capa Eliab loe Zebulun kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Kroek naah anih ih misatuh kaminawk loe sing panga, sang sarih, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Judah kaminawk ohhaih ahmuen ah kaom, angmacae ih misatuh kaminawk to kroek naah sangqum boih ah, sing cumvai, sang qui tazet, sang taruk, cumvai palito oh o. Hae kaminawk loe hmaloe koek ah caeh o tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Reuben ih misatuh kaminawk loe angmacae angmathaih kahni payang ih baktih toengah, aloih bangah ohhaih im to sah o tih; Shedeur capa Elizur loe Reuben kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Kroek naah anih ih misatuh kaminawk loe sing pali, sang taruk, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeon acaengnawk loe nihcae taengah om o tih; Zurishaddai capa Shelumiel loe Simeon kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Kroek naah anih ih misatuh kaminawk loe sing panga, sang takawt, cumvai thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Nihcae taengah Gad acaengnawk to om o tih; Reuel capa Elisaph loe Gad kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Kroek naah anih ih misatuh kaminawk loe sing pali, sang panga, cumvai taruk, qui pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Reuben acaengnawk ohhaih ahmuen ah kaom angmacae ih misatuh kaminawk to kroek naah sangqum boih ah, sing cumvai, sing panga, sang ha, cumvai pali qui pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","To pacoengah misatuh kaminawk um li ah rangpui amkhuenghaih kahni im hoi nawnto Levi kaminawk ohhaih ahmuen to om tih; angmacae angmathaih kahni payang ih baktih toengah, angmacae ohhaih im to sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ephraim acaeng misatuh kaminawk loe angmacae angmathaih kahni payang ih baktih toengah, ohhaih im to sah o tih; Ammihud capa Elishama loe Ephraim acaeng zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Kroek naah anih ih misatuh kaminawk loe sing pali, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Nihcae taengah Manasseh acaengnawk to om o tih; Pedahzur capa Gamaliel loe Manasseh kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Kroek naah anih ih misatuh kaminawk loe sing thum, sang pumphae hnetto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Nihcae taengah Benjamin acaengnawk om o tih; Gideoni capa Abidan loe Benjamin kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Kroek naah anih ih misatuh kaminawk loe sing thum, sang panga, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ephraim acaengnawk ohhaih ahmuen ah kaom angmacae ih misatuh kaminawk to kroek naah sangqum boih ah, sing cumvai, sang tazet, cumvaito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Aluek bangah Judah acaeng misatuh kaminawk loe angmacae angmathaih kahni payang ih baktih toengah, ohhaih im to sah o tih; Ammishaddai capa Ahierzer loe Dan kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Kroek naah anih ih misatuh kaminawk loe sing taruk, sang hnet, cumvai sarihto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Nihcae taengah Asher acaengnawk om o tih; Okran capa Pagiel loe Asher kaminawk zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Kroek naah anih ih misatuh kaminawk loe sing pali, sang cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Nihcae pacoengah Naphtali acaengnawk om o tih; Enan capa Abira loe Naphtali acaeng zaehoikung ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Kroek naah anih ih misatuh kaminawk loe sing panga, sang thum, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan acaengnawk ataihaih ahmuen ah kaom kaminawk to kroek naah sangqum boih ah, sing cumvai, sang qui panga, sang sarih, cumvai tarukto oh o. Angmacae angmathaih kahni payang ih baktih toengah, nihcae loe hnukkhuem koek ah caeh o tih. ");
INSERT INTO cekak_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Angmacae ih acaengnawk boih thung ih kami hoi angmacae ataihaih ahmuen ih misatuh kaminawk to kroek naah, Israel misatuh kaminawk loe sangqum boih ah, sang cumvai taruk, sang thum, cumvai pangato pacoeng, qui pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Levinawk loe Israel kaminawk thungah kroek o ai. ");
INSERT INTO cekak_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Israel kaminawk mah sak o boih; angmacae khosakhaih dan hoi angmacae imthung takoh boih nawnto ataihaih ahmuen to a sak o. ");
INSERT INTO cekak_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Sinai mae ah Angraeng mah Mosi khaeah lokthuih naah, hae ih kaminawk loe Aaron hoi Mosi ih caanawk ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron caanawk ih ahmin loe calu ah Nadab, Abihu, Eleazar hoi Ithamar. ");
INSERT INTO cekak_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Hae kaminawk loe qaima toksak hanah ampa mah situi bawh moe, pahoe ih Aaron caanawk ih ahmin ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab hoi Abihu loe, Sinai praezaek ah sak koi ai kalah hmai hoi angbawnhaih a sak hoi pongah, Angraeng hmaa ah duek hoi hmaek; nihnik loe caa tawn hoi ai; to pongah Eleazar hoi Ithanar to ampa Aaron hmaa ah qaima tok a sak hoi. ");
INSERT INTO cekak_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Levi acaengnawk to kawk loe, Aaron ih toksak hanah, anih hmaa ah caeh haih ah. ");
INSERT INTO cekak_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Nihcae loe Aaron hoi kahni im ah amkhueng kaminawk ih kangaih tok to, amkhuenghaih kahni im hmaa ah sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Nihcae loe kaminawk amkhuenghaih kahni im ih hmuenmaenawk boih khen o ueloe, Israel kaminawk mah sak han koi tok to sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Levi kaminawk to Aaron hoi a caanawk khaeah paek ah; Israel caanawk thung hoi qoi ah loe anih khaeah paek boih ah. ");
INSERT INTO cekak_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaron hoi anih ih caanawk doeh qaima toksak hanah paek ah; hmuenciim taengah kacaeh minawk kalah loe dueksak han oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","khenah, Israel kaminawk thung hoi tapen calu boih zuengah, Israel kaminawk thung hoi Levi kaminawk to ka qoih boeh pongah, Levi kaminawk loe kai ih ni; ");
INSERT INTO cekak_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","tapen tangsuek hmuen boih loe kai ih ni; Izip prae thungah tapen tangsuek ka hum boih naah, Israel prae thungah loe tapen tangsuek to kai hanah pahoe o pongah, to hmuennawk loe kai ih hmuen ah oh o; Kai loe Angraeng ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","14 Angraeng mah Sinai praezaek ah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Levi acaengnawk boih to kroek ah, khrah to pacoeng ranui bang kaom nihcae thung ih nongpanawk to kroek boih hanah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","To pongah Angraeng mah thuih ih lok baktih toengah, Mosi mah nihcae to kroek. ");
INSERT INTO cekak_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi kaminawk ih ahmin loe Gershon, Kohath hoi Merari. ");
INSERT INTO cekak_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershon kaminawk ih ahmin loe Libni hoi Shimei. ");
INSERT INTO cekak_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohath acaengnawk ih ahmin loe Amram, Izehar, Hebron hoi Uzziel. ");
INSERT INTO cekak_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari acaengnawk ih ahmin loe Mahli hoi Mushi. Hae kaminawk loe angmacae acaeng thung hoiah kroek ih Levi acaeng ah oh hoi. ");
INSERT INTO cekak_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gershon khae hoi tacawt, Libni hoi Shimei ih caanawk loe Gershon ih acaeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Khrah to pacoeng ranui bang kaom nongpa to kroek boih naah, sangqum boih ah, sang sarih, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershon ih caanawk loe niduem bang kahni im hnukah om o tih. ");
INSERT INTO cekak_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Lael capa Eliasaph loe Gershon imthung takoh zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gershon kaminawk mah sak han koi tok loe, kaminawk amkhuenghaih kahni im, im hoi anui padihhaih ahmuen, kaminawk amkhuenghaih kahni im akunhaih thok taengah payang ih kahninawk, ");
INSERT INTO cekak_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","longhmaa ah payang ih kahninawk, kahni im hoi hmaicam longhma taengah payang ih kahninawk, longhma akunhaih thok taengah payang ih kahninawk, zaenghaih quinawk boih loe nihcae mah khen o tih. ");
INSERT INTO cekak_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohath hoi tacawt Amram caanawk, Izehar caanawk, Hebron caanawk hoi Uzziel caanawk loe, Kohath ih acaeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Khrah to pacoeng ranui bang kaom nongpanawk to kroek boih naah, sang tazetto pacoeng, cumvai tarukto oh o; nihcae loe hmuenciim khenzawnkung ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohath imthung takoh ih caanawk loe kahni im aloih bangah om o tih. ");
INSERT INTO cekak_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Uzziel capa Elizaphan loe Kohath imthung takoh zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Nihcae loe Sithaw lokkamhaih thingkhong, caboi, hmaithawk, hmaicamnawk, angmacae toksakhaih hmuenciim thung ih laom sabaenawk, payang ih kahninawk hoi hmuennawk boih khenzawnkung ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Aaron capa qaima Eleazar loe Levi kaminawk zaehoikung ah oh; anih loe hmuenciim toep kaminawk khenzawnkung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari khae hoiah tacawt; Mahli hoi Mushi caanawk loe, Merari ih acaeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Khrah to pacoeng ranuih bang kaom nongpa to kroek boih naah, sang tarukto pacoeng, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Abihail capa Zureil loe Merari imthung takoh zaehoikung ah oh; nihcae loe kahni im aluek bangah om o tih. ");
INSERT INTO cekak_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merari ih caanawk mah sak o han koi toknawk loe, kahni im sakhaih thingnawk, pakhang ih thingnawk, tungnawk, tung padoethaih hmuennawk, laom sabaenawk hoi kalah patoh ih hmuennawk boih, ");
INSERT INTO cekak_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","imthung longhma taeng ih tungnawk, tung angdoethaih ahmuennawk, kahni im komhaih quinawk hoi takhuekhaih sumnawk khenzawnkung ah om o tih. ");
INSERT INTO cekak_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mosi hoi Aaron ih caanawk loe ni angyae bang ih kahni im ahma hoi rangpui amkhuenghaih kahni im hma ah om o tih; nihcae loe Israel kaminawk zuengah hmuenciim khenzawnkung ah oh o; hmuenciim taengah angzo kalah kami loe paduek han oh. ");
INSERT INTO cekak_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Angraeng mah paek ih lok baktih toengah, Mosi hoi Aaron mah khrah to pacoeng ranuih bang kaom nihcae imthung takoh ih, nongpanawk to kroek boih naah, Levi acaengnawk loe sangqum boih ah, sing hnet, sang hnetto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Angraeng mah Mosi khaeah, Israel caanawk thungah khrah to pacoeng ranuih bang kaom nongpa to kroek o boih ah loe, nihcae ih ahmin to tarik ah. ");
INSERT INTO cekak_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Israel kaminawk ih calu boih zuengah, Levi kaminawk to la ah loe, Israel kaminawk ih tapen tangsuek moinawk zuengah, Levi kaminawk ih maitaw to kai hanah la ah; Kai loe Angraeng ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","To pongah Angraeng mah paek ih lok baktih toengah, Mosi mah sak moe, Israel ih calu to kroek boih. ");
INSERT INTO cekak_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Khrah to pacoeng ranuih bang kaom, calu to kroek boih moe, nihcae ih ahmin to lak naah, sing hnet, sang hnet qui sarih, thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Israel calunawk boih zuengah, Levi kaminawk to la ah loe, nihcae ih maitaw zuengah, Levinawk ih maitaw to la ah; Levinawk loe kai ih kami ah ni oh o; Kai loe Angraeng ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Levi kaminawk pong pop, Israel calu cumvai hnet, qui sarih, thumto akrang ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Gerah pumphaeto kazit, hmaicam ah patoh ih tahhaih shekel baktih toengah, kami maeto khaeah shekel pangato la ah; ");
INSERT INTO cekak_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","kamtlai Israel kaminawk akranghaih phoisa to Aaron hoi a caanawk khaeah paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","To pongah Levinawk mah kamtlai Israel calunawk akranghaih phoisa to Mosi mah cong; ");
INSERT INTO cekak_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Israel calunawk khaeah cong ih phoisanawk loe, hmuenciim ih shekel tahhaih hoi tah naah, shekel sang hatlai thum, qui taruk, pangato oh. ");
INSERT INTO cekak_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Angraeng mah thuih ih lok baktih toengah, Mosi mah to akranghaih phoisa to Aaron hoi a caanawk khaeah paek. ");
INSERT INTO cekak_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Angmacae acaeng hoi imthung takoh ah kaom kami baktih toengah, Levi acaeng ah kaom Kohath ih caanawk to kroek ah, ");
INSERT INTO cekak_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","amkhuenghaih kahni imthung ah toksak hanah, saning qui thumto hoi saning qui pangato kaom nongpanawk to kroek boih ah. ");
INSERT INTO cekak_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kohath caanawk mah khetzawn ih kaminawk amkhuenghaih kahni im loe, ciimcai koek ahmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ohhaih ahmuen angpuen o naah, Aaron hoi a caanawk to angzo o tih, nihcae mah a nuiah khuk ih kahni to khring o ueloe, hnukung ah kaom thingkhong to khuk o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","To pacoengah tuipui caham ih ahin hoiah khuk o tih; to hmuen ih a nuiah rong kamiing kahni to khuk o ueloe, cung to angmah ih ahmuen ah suem o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Caboi nui ih takaw to kahni kamiing hoiah kraeng o tih, to ah sabaenawk, kathuk sabaenawk, naek han koi tui lawnhaih boengloengnawk, takawnawk to apet ai ah suem o tih; ");
INSERT INTO cekak_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","to ih hmuen nuiah kamling kahni to baih o tih; a nuiah tuipui caham ih ahin hoiah khuk o ueloe, cung to angmah ahmuen ah suem o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Kahni kamiing to la o ueloe, hmaithawk, hmaiim, hmai ataephaih taitaehnawk, hmai cenhaih boengloeng, hmaitui suekhaih boengloengnawk boih to khuk o tih; to tiah nihcae mah toksah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","To pacoengah to ih laom sabaenawk boih to tuipui caham ih ahin hoiah ayaw o hmoek pacoengah, aputhaih to sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Sui hmaicam nuiah kahni kamiing to baih o ueloe, tuipui caham ih ahin hoiah khuk o tih; aputhaih cung to angmah ohhaih ahmuen ah suem o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Hmuenciim thungah toksak naah hmuenmaenawk to la o boih ueloe, kahni kamiing hoiah ayaw o tih; tuipui caham hin hoi khuk o pacoengah, aputhaih to sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Nihcae mah hmaicam pong ih maiphunawk to takhoek o ueloe, a nuiah kahni kamling hup to khuk o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","To hmaicam ah toksak naah kangaih hmuennawk, laom sabaenawk, moi banghaih sumnawk, moi thunhaih sumnawk, hmai kamngaeh sohhaih sum kangphaeknawk, tui bawhhaih boengloengnawk hoi hmaicam ih laom sabaenawk to a nuiah suem o boih tih; to hmuen to tuipui caham hin hoiah khuk o ueloe, aputhaih cung to a ohhaih ahmuen ah suem o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ataihaih ahmuen angpuen han oh naah, Aaron hoi a caanawk loe, hmuenciim hoi hmuenciim ih laom sabaenawk to khuk o pacoengah, to hmuennawk to aput hanah, Kohath ih caanawk angzo o tih; toe nihcae loe kaciim hmuen to sui o mak ai; sui o nahaeloe dueh o tih. Hae hmuennawk loe kaminawk amkhuenghaih kahni im ah Kohath ih caanawk mah sak han koi tok ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Qaima Aaron capa Eleazar mah sak han koi tok loe hmaitui, hmai thlaek koi hmuihoih, ni thokkruek paek ih cang hoi lu bawhhaih situi, kahni im hoi a thung ih hmuennawk boih, hmaicam hoi a thung ih laom sabaenawk boih to khenzawn tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Kohath imthung takoh to Levi acaeng thung hoiah takhoe ving hmah; ");
INSERT INTO cekak_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","to pongah kaciim koek ahmuen ah caeh hoi naah, duekhaih thung hoiah loih moe, hing thai hanah, hae tiah nihcae han sah paeh; Aaron hoi a caanawk to hmuenciim thungah akun o hmaloe ueloe, kaminawk boih mah sak han koi hmuen hoi tok to tapraek pae tih: ");
INSERT INTO cekak_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","toe ciimcai hmuennawk kraeng nathuem ah, to hmuennawk khet hanah Kohath ih caanawk a thungah caehsak hmah; to tih ai nahaeloe dueh o moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Gershon caanawk doeh angmacae ih acaeng hoi imthung takoh ah kami ih ahmin to la ah; ");
INSERT INTO cekak_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","amkhuenghaih kahni imthung ah kaom kaminawk angaihaih toksak hanah, saning qui thumto hoi saning qui pangato kaom nongpanawk to kroek boih ah. ");
INSERT INTO cekak_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gershon imthung takoh mah sak moe, aput han koi hmuennawk loe hae tiah oh; ");
INSERT INTO cekak_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","kahni im ah payang ih kahni, rangpui amkhuenghaih kahni im, a nui khuk ih kahninawk, a nui khukhaih tuipui caham ahinnawk, kaminawk amkhuenghaih kahni im, amkhuenghaih kahni im thok taengah payang ih kahninawk, ");
INSERT INTO cekak_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","kahni im hoi hmaicam taeng ih longhmaa ah payang ih kahni, longhma thok taengah payang ih kahni, toksak naah patoh ih quinawk hoi kangaih hmuennawk loe Gershon ih caanawk mah sah o boih tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gershon acaengnawk mah sak ih hmuen hoi aput han koi hmuennawk boih loe, Aaron hoi a caanawk mah thuih ih lok baktih toengah sah o tih; nihcae mah aput han koi hmuenawk boih to thui pae o tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hae hmuennawk loe Gershon imthung takoh mah, kami amkhuenghaih kahni imthung ah sak han koi tok ah oh; nihcae toksakhaih loe Aaron capa qaima Ithamar mah khenzawn tih. ");
INSERT INTO cekak_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Merari ih caanawk doeh angmacae ih acaeng hoi imthung takoh ah kaom kaminawk baktih toengah kroek ah; ");
INSERT INTO cekak_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","kaminawk amkhuenghaih kahni imthung ah toksak han kangzo, saning qui thumto hoi saning qui pangato kaom nongpa to kroek boih ah. ");
INSERT INTO cekak_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Nihcae mah kaminawk amkhuenghaih kahni im to sak moe, aput o han koi tok loe, kahni im sakhaih thingnawk, pakhang ih thingnawk, tungnawk hoi tung padoethaih hmuennawk, ");
INSERT INTO cekak_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","longhma taeng boih ah kaom tungnawk, tung padoethaih hmuennawk, sumnawk, quinawk, toksak naah patoh ih hmuennawk to sah o boih tih; nihcae mah aput ih hmuennawk to pakuem moe, kroek boih han oh. ");
INSERT INTO cekak_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Hae hmuen loe Aaron capa qaima Ithamar mah khethaih tlim ah, kaminawk amkhuenghaih kahni im ah Merari ih caanawk mah sak han koi tok ah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mosi, Aaron hoi amkhueng kaminawk zaehoikung kacoeh koek mah, angmacae acaeng hoi imthung takoh khosakhaih baktih toengah, Kohath ih caanawk to kroek o. ");
INSERT INTO cekak_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Kaminawk amkhuenghaih kahni im ah toksak han kangzo, saning qui thumto hoi saning qui pangato kaom nongpa boih, ");
INSERT INTO cekak_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","angmacae imthung takoh ih kami to kroek o boih naah, sang hnet, cumvai sarih, qui pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hae kaminawk loe Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Mosi hoi Aaron mah amkhuenghaih kahni im ah toksak hanah kaom Kohath ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gershon ih caanawk loe angmacae acaeng hoi imthung takoh to kroek o boih. ");
INSERT INTO cekak_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Amkhuenghaih kahni im ah toksak han kangzo, saning qui thumto hoi saning qui pangato kaom nongpa boih, ");
INSERT INTO cekak_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","angmacae ih acaeng hoi imthung takoh to kroek o boih naah, sang hnet, cumvai taruk, qui thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Hae kaminawk loe Angraeng mah thuih ih lok baktih toengah, Mosi hoi Aaron mah kroek ih, kahni im ah toksah koi kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari ih caanawk mah angmacae acaeng hoi imthung takoh to kroek o boih. ");
INSERT INTO cekak_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Kaminawk amkhuenghaih im ah toksak han kangzo kami saning qui thumto hoi saning qui pangato kaom nongpa boih, ");
INSERT INTO cekak_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","angmacae acaeng hoi imthung takoh to kroek o boih naah, kami sang thum, cumvai hnetto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hae kaminawk loe Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Mosi hoi Aaron mah kroek ih Merari ih caa ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Levi caanawk loe Mosi, Aaron hoi Israel zaehoikungnawk mah, angmacae acaeng hoi imthung takoh to kroek pae boih. ");
INSERT INTO cekak_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Kaminawk amkhuenghaih kahni im ah toksak moe, aput han angzo saning qui thumto hoi saning qui pangato kaom nongpa boih, ");
INSERT INTO cekak_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","nihcae to kroek o boih naah, sang tazet, cumvai panga, qui tazetto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Angraeng mah Mosi khaeah paek ih lok baktih toengah, kami boih mah sak o ih tok hoi aput koi tok to khet moe, nihcae ih milu to a kroek. ");
INSERT INTO cekak_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Ngansae man kami, kahoih thai ai takpum nathaih tawn kami hoi kaciim ai kadueh qok sui Israel kaminawk loe ataihaih ahmuen tasa bangah suem ah; ");
INSERT INTO cekak_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ka ohhaih ahmuen amhnongsak han ai ah, to baktih nathaih tawn kami loe nongpa maw, nongpata maw ohhaih im tasa bangah suem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Israel kaminawk mah sak o; to baktih nathaih tawn kami loe ohhaih ahmuen tasa bangah a suek o. ");
INSERT INTO cekak_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Israel kaminawk khaeah hae tiah thui paeh; kaminawk mah sak o ih zaehaih to nongpa mah maw, nongpata mah maw, Angraeng hmaa ah oep om ai ah sak o pazae pongah, to kami to zaehaih tawn nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","to kaminawk mah sak o ih zaehaih to taphong han oh; a sakpazae o pongah, a sakpazae o ih kami khaeah ahmuen pangato thungah ahmuen maeto thap ueloe, rong pae boih tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Toe kami maeto mah a sakpazae ih hmuen pongah, rong ih hmuen talawkkung om ai nahaeloe, to rong ih hmuen to Angraeng ih hmuen ah suek moe, qaima khaeah paek han oh; to pacoengah anih zaehaih loih thai hanah angbawnhaih sak hanah tuu tae to paek han oh. ");
INSERT INTO cekak_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Israel kaminawk mah qaima han sin ih ciimcai hmuennawk boih loe anih ih hmuen ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kami boih mah kaciim ah sin ih hmuennawk loe, anih ih hmuen ah om tih; kami mah qaima han paek ih tangqumnawk doeh anih ih hmuen ah om tih, tiah thuih paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Israel kaminawk han hae tiah lokthui paeh; kami maeto ih zu loe oep om ai pongah, loklam amkhraeng ving moe, a sava nuiah zaehaih a sak; ");
INSERT INTO cekak_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kami maeto mah to nongpata to iih haih, toe a sava khaeah thui ai ah angphat; to nongpata loe ciim ai boeh, toe anih hnukung om ai pongah, mi mah doeh a sak ih zaehaih to naeh thai ai, ");
INSERT INTO cekak_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","toe sava mah a zu loe ciim ai boeh, tiah oep vawthaih to tawnh maw, to tih ai boeh loe a zu nuiah palunghaenghaih a tawnh, toe anih ih zu loe amhnonghaih tidoeh om ai to mah a sava mah anih nuiah palunghaenghaih tawn nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","a sava mah a zu to qaima khaeah caeh haih ueloe, barli takaw dip ephah hato thungah maeto a zu ih zae angbawnhaih sak hanah sin tih; takaw dip nuiah situi bawh mak ai, a nuiah hmuihoih doeh thlaek mak ai; to baktih angbawnhaih loe zu nuiah palunghaeng pongah, sak ih angbawnhaih ah oh moe, zaehaih panoek hanah sak ih angbawnhaih ah doeh oh. ");
INSERT INTO cekak_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Qaima mah to nongpata to caeh haih ueloe, Angraeng hmaa ah angdoesak tih; ");
INSERT INTO cekak_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","to naah qaima mah kaciim tui to long laom thungah lawn ueloe, anih mah kahni imthung ih maiphu to lak pacoengah, tui thungah phuih tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Qaima mah nongpata to Angraeng hmaa ah angdoesak ueloe, nongpata ih lu to khuk pae hmoek tih; nongpata nuiah palunghaeng pongah zaehaih panoek hanah sak ih angbawnhaih takaw dip to a ban ah pasumsak tih; qaima mah tangoenghaih kaomsak thaih tui kakhaa to a ban ah sin tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Qaima mah nongpata to, Kaw baktih nongpa hoiah doeh na iip ai, oep om ai loklam ah doeh nam khraeng ai moe, na sava laep ah kalah nongpa hoiah takpum amhnonghaih to na sah ai nahaeloe, hae ih tangoenghaih kaomsak thaih tui kakhaa hae na nuiah pha hmah nasoe, tiah thui tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Toe na sava nuiah oep thok ai ah na oh moe, kalah nongpa hoiah loklam nam khraeng ving; na sava nuiah kalah nongpa hoiah na iih moe, na takpum to amhnong boeh nahaeloe, ");
INSERT INTO cekak_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","qaima mah nang loe nangmah ih kaminawk salakah, Angraeng mah na phaih to zaeksak ueloe, na zok doeh bawksak tih, to tiah nang loe tangoenghaih zok kami ah na om tih, tiah nongpata khaeah thuih pae pacoengah, nongpata to tangoenghaih lok akamsak tih; ");
INSERT INTO cekak_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","tangoenghaih kaomsak hae tui kakhaa hae na zok thungah akun naah, na phaih to zaeksak ueloe, na zok doeh baawk tih, tiah thui pae tih. To naah nongpata mah, Amen, to tiah om nasoe, tiah thui tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Hae tangoenghaih lok loe qaima mah cabu thungah tarik ueloe, kakhaa tui hoiah phrae let tih; ");
INSERT INTO cekak_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","qaima mah tangoenghaih kaomsak kakhaa tui to nongpata hanah naesak tih; nongpata ih zok thungah tangoenghaih kaomsak tui kakhaa akun naah, paroeai khaa pae tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","To pacoengah qaima mah to nongpata ban ah sinsak ih palunghaeng pongah sak ih angbawnhaih takaw dip to la ueloe, Angraeng hmaa ah ahaek pacoengah, hmaicam nuiah suem tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Qaima mah zaehaih panoek han sak ih angbawnhaih takaw dip to ban tangsum maeto la ueloe, hmaicam nuiah hmai hoiah thlaek tih; to pacoengah to tui to nongpata hanah naesak tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","To nongpata mah angmah ih sava nuiah zaehaih to sah moe, ciim ai boeh nahaeloe, tangoenghaih lokkam ih baktih toengah omsakkung tui kakhaa to naek naah, zok thungah tui to paroeai khaa tih; to naah a phaih to zaek ueloe, a zok doeh baawk tih; to naah to nongpata loe angmah ih kaminawk salakah tangoenghaih zok kami ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Toe nongpata loe ciimcai moe, amhnonghaih tidoeh om ai nahaeloe, anih loe zaehaih tawn ai pongah, caa sah let tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Hae loe zu mah oep kaom ai ah, kalah nongpa hoi loklam amkhraeng ving moe, sava nuiah ciimcai ai ah khosak naah maw, palunghaenghaih tawnh naah maw, ");
INSERT INTO cekak_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","to tih ai boeh loe nongpa mah a zu nuiah palunghaenghaih tawnh naah maw, patoh ih kaalok ah oh; sava mah a zu nuiah palunghaenghaih tawnh naah, qaima mah nongpata to Angraeng hmaa ah angdoesak ueloe, hae ih kaalok baktih toengah nongpata to lokcaek tih. ");
INSERT INTO cekak_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","To tiah sava loe zaehaih ciim ueloe, nongpata loe a zaehaih pongah danpaekhaih to zok tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Israel kaminawk khaeah hae tiah thui paeh; nongpa maw, nongpata maw, angmah hoi angmah to Angraeng han ih ni ka oh, tiah thuih moe, Nazaret kami ah oh hanah amhoe pacoengah, lokkamhaih to a sak naah, ");
INSERT INTO cekak_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","mu hoi paqui thaih kalah mu maw, misurtui hoiah sak ih misurtui kathaw maw, kalah paqui thaih misurtui hoiah sak ih kathaw tui maw, misurtui hoiah sak ih munawk to naek han om ai; misurthaih doeh caa mak ai, misurthaih kazaek doeh caak han om ai. ");
INSERT INTO cekak_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A hing thung misurthing hoi tacawt hmuen roe caak han om ai; amu caak hanah ahin doeh et han om ai. ");
INSERT INTO cekak_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Kamhoe ah oh hanah lokkamhaih sak nathung, a lu nui ih sam roe aat mak ai; Angraeng khaeah lokkamhaih sak baktih toengah, amhoehaih tue akoep ai karoek to, anih loe kaciim ah om ueloe, a lu nui ih sam to kasawk ah pathlung tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Angraeng khaeah amhoehaih atue thung, kadueh kami qok taengah caeh mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Angmah ih Angraeng hanah a lu to pahoe pongah, anih loe ampa maw, amno maw, amnawk maw, to tih ai boeh loe a tanu maw dueh cadoeh caeh mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Angraeng khaeah pahoe ih kami ah oh nathung, anih loe ciimcai kami ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Poek ai pui hoiah anih taengah kami dueh moeng nahaeloe, pahoe ah kaom a lu nui ih sam to amhnong boeh pongah, ciimcaihaih ni, ni sarihto naah a lu sam to aat tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ni tazetto naah loe pahu, to tih ai boeh loe im ah pacah ih pahu hnetto amkhuenghaih kahni im thok taengah, qaima khaeah sin tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Anih loe kadueh kami mah zaesak boeh pongah, a zaehaih to loihsak hanah, qaima mah pahu maeto zae angbawnhaih ah bop ueloe, kalah maeto hmai angbawnhaih sah pae tih; to na ni roe ah anih ih lu to kaciim ah suem let tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Pahoe ih atue thungah Angraeng khaeah angpaek ueloe, saningto kaom tuucaa hoiah zae angbawnhaih to sah tih; canghni ah pahoe ih atue thungah ciim ai boeh pongah, hmaloe ih atue to kroek mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Nazaret kami ah oh han pahoehaih atue to boeng naah loe, kaminawk amkhuenghaih kahni im akunhaih thok taengah anih to caeh haih tih; ");
INSERT INTO cekak_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","to ah anih mah Angraeng khaeah anih han angbawnhaih to sah pae tih; coek koi kaom ai saningto kaom tuucaa tae maeto, hmai angbawnhaih ah paek ueloe, coek koi kaom ai saningto kaom tuucaa tala maeto zae angbawnhaih ah paek tih; coek koi kaom ai tuu tae maeto doeh angdaeh angbawnhaih ah paek tih; ");
INSERT INTO cekak_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","taeh thuh ai ih takaw benthang maeto, situi atok ih takaw kangphaek, situi atok ih takaw kaenawk, cang hoi naek koi tuinawk to nawnto paek tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","To hmuennawk to qaima mah Angraeng khaeah sin ueloe, zae angbawnhaih hoi hmai angbawnhaih to sah tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Qaima mah angdaeh angbawnhaih ah, taeh thuh ai ih takaw benthang maeto hoi tuu tae maeto Angraeng khaeah paek pacoengah, cang hoi naek koi tuinawk doeh paek tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","To pacoengah kaminawk amkhuenghaih kahni im akunhaih thok taengah, Nazaret kami mah pahoe ih a lu nui ih sam to aat tih; a sam to angdaeh angbawnhaih hmai thungah va tih. ");
INSERT INTO cekak_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Pahoe ih sam to aah pacoengah, tui hoi bueh ih tuu palaeng maeto, benthang pong ih taeh thuh ai ih takaw kae hoi taeh thuh ai ih takaw karoem to la ueloe, Nazaret kami ih ban ah suem pae tih; ");
INSERT INTO cekak_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","to pacoengah qaima mah to hmuennawk to Angraeng hmaa ah ahaek ih angbawnhaih ah paek tih; to tiah ahaek ih saoek hoi palaeng loe caiimcai moe, qaima han paek ih hmuen ah oh; to pacoengah loe Nazaret kami mah misurtui to nae tih boeh. ");
INSERT INTO cekak_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Hae loe amhoehaih atue thungah, Angraeng han hmuen paek moe, lokkamhaih sah Nazaret kami ih atawk ah oh; hae hmuen pacoengah angpaekhaih kaalok baktiah anih mah sak moe, a lokkamhaih baktih toengah akoepsak han oh, tiah thuih paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Aaron hoi a caanawk khaeah, Israel kaminawk to hae tiah tahamhoihaih paek oh, nihcae khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Angraeng mah tahamhoihaih paek nasoe loe, nihcae to toep nasoe; ");
INSERT INTO cekak_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Angraeng mah nangcae nuiah a mikhmai aangsak nasoe loe, tahmen nasoe; ");
INSERT INTO cekak_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Angraeng loe nangcae khaeah angqoi nasoe loe, monghaih paek nasoe, tiah thui ah. ");
INSERT INTO cekak_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Nihcae mah Israel kaminawk nuiah ka hmin to suem o tih, to naah nihcae to tahamhoihaih ka paek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mosi mah kahni im sak pacoengah, kahni imthung ah kaom hmuenmaenawk, hmaicam hoi laom sabaenawk boih to, situi bawh moe, a ciimsak. ");
INSERT INTO cekak_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","To pacoengah kroek ih kami thungah kaom, Israel kaminawk ukkung, imthung takoh zaehoikung hoi acaeng zaehoikung lu koeknawk mah hmuen paekhaih to sak o. ");
INSERT INTO cekak_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Nihcae mah Angraeng paek hanah sin o ih hmuennawk loe, ukkung maeto mah maitaw tae maeto, ukkung hnetto hanah maitaw mah ruet ih maitaw leeng maeto, imphu kaom maitaw leeng tarukto hoi maitaw tae hatlai hnetto, kahni imthung ah a sin o. ");
INSERT INTO cekak_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","kaminawk amkhuenghaih kahni im ah patoh hanah, nihcae mah paek ih hmuennawk to la ah; kami boih mah toksak angaihaih baktih toengah, to hmuennawk to Levi kaminawk han paek ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","To pongah Mosi mah maitaw leeng hoi maitaw taenawk to lak moe, Levi kaminawk hanah paek. ");
INSERT INTO cekak_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Toksak angaihaih baktih toengah anih mah Gershon ih caanawk hanah, maitaw leeng hnetto hoi maitaw tae palito paek pae; ");
INSERT INTO cekak_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","toksak angaihaih baktih toengah anih mah Merari ih caanawk hanah, maitaw leeng palito hoi maitaw tae tazetto paek pae; nihcae loe qaima Aaron capa Itharma ukhaih tlim ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Hmuenciim ah toksah Kohath ih caanawk loe, angmacae palaeng hoi aput koi tok to a sak o pongah, nihcae han maitaw leeng hoi maitaw taenawk to paek o ai. ");
INSERT INTO cekak_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Hmaicam situi bawh na niah, ukkungnawk mah hmaicam tathlanghaih hmuennawk to hmaicam hmaa ah paek o. ");
INSERT INTO cekak_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Angraeng mah Mosi khaeah, Hmaicam tathlang hanah ukkung maeto boih mah ni thokkruek hmuen to paek o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Hmaloe koek niah Judah acaeng Amminadab capa Nashon mah, tathlang ih hmuen to sinh; ");
INSERT INTO cekak_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih tui pathaek naah patoh ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","shekel hato kazit hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","angbawnhaih paek hanah maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto; ");
INSERT INTO cekak_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","zae angbawnhaih hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","to pacoengah angdaeh angbawnhaih sak hanah, maitaw tae hnetto, tuu tae pangato, maeh tae pangato, saningto kaom tuucaa pangato a sinh; hae loe Amminadab capa Nashon mah paek ih hmuennawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ni hnetto na naah Issakar ih acaeng ukkung, Zuar capa Nethanel mah tathlang ih hmuen to sinh; ");
INSERT INTO cekak_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","anih mah sin ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","shekel hato kazit, hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","hmai angbawnhaih sak hanah, saning kanawk maitaw maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","angdaeh angbawnhaih sak hanah paek ih maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Zuar capa Nethanel mah paek ih hmuennawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ni thumto naah, Zebulun caanawk zaehoikung, Helon capa Eliab mah tathlang ih hmuen to sinh; ");
INSERT INTO cekak_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak han suek ih sabae hnetto koiah situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","shekel hato kazit hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","hmai hoi angbawnhaih sak hanah, saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","zae angbawnhaih sak hanah, maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","angdaeh angbawnhaih sak hanah paek ih maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Helon capa Eliab mah paek ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ni palito naah loe Reuben caanawk zaehoikung, Sheudeur capa Elizur mah tathlang ih hmuennawk to sinh; ");
INSERT INTO cekak_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Shekel hato kazit hmuihoih koimongah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","hmai hoi angbawnhaih sak hanah, saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","angdaeh angbawnhaih sak hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Shedeur capa Elizur mah paek ihhmuennawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ni pangato naah loe Simeon caanawk zaehoikung, Zurishaddai capa Shelumiel mah tathlang ih hmuenawk to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","shekel hato kazit hmuihoih koiah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","hmai hoi angbawnhaih sak hanah, saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","to pacoengah angdaeh angbawnhaih sak hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Zurishaddai capa Shelumiel mah paek ih hmuennawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ni tarukto naah Gad caanawk zaehoikung, Deuel capa Eliasaph mah tathlang ih hmuen to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak han suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","shekel hato kazit hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","hmai hoi angbawnhaih sak hanah saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto; ");
INSERT INTO cekak_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","zae angbawnhaih sak hanah, maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","angdaeh angbawnhaih sak hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Deuel capa Eliasaph mak paek ih hmuennawk ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ni sarihto naah Ephraim caanawk zaehoikung, Ammihud capa Elishama mah tathlang ih hmuen to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Anih mah paek ih hmuen loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","shekel hato kazit hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","hmai hoi angbawnhaih sak hanah saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","angdaeh angbawnhaih sak hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Ammihud capa Elishama mah paek ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ni tazetto naah Manasseh ih caanawk zaehoikung, Pedahzur capa Gamaliel mah tathlang ih hmuen to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","shekel hato kazit hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","hmai angbawnhaih sak hanah saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","zae angbawnhaih hmuen paek hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","angdaeh angbawnhaih hmuen paek hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Pedahzur capa Gamaliel mah paek ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ni takawtto naah, Benjamin kaminawk zaehoikung, Gideoni capa Abidan mah tathlang ih hmuen to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","shekel hato kazit hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","hmai hoi angbawnhaih sak hanah saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto; ");
INSERT INTO cekak_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","angdaeh angbawnhaih sak hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae hmuennawk loe Gideoni capa Abidan mah sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ni hato naah Dan ih caanawk zaehoikung, Ammishaddai capa Ahiezer mah tathlang ih hmuen to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak hanah suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","shekel hato kaom hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","angdaeh angbawnhaih sak hanah saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","angdaeh angbawnhaih sak hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato, saningto kaom tuucaa pangato a sinh; hae loe Ammishaddai capa Ahiezer mah paek ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Khrah hatlaito niah loe Asher ih caanawk zaehoikung, Okran capa Pagiel mah tathlang ih hmuen to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak han suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","shekel hato kazit hmuihoih koimong ah suek ih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","angdaeh angbawnhaih sak hanah saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","angdaeh angbawnhaih sak hanah paek ih maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuu caa pangato a sinh; hae loe Okran capa Pagiel mah paek ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Hatlai hnetto niah Naphtali zaehoikung, Enan capa Ahira mah tathlang ih hmuen to sinh. ");
INSERT INTO cekak_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Anih mah paek ih hmuennawk loe, hmuenciim ih shekel baktih toengah, shekel cumvai, qui thumto kazit sum kanglung hoiah sak ih sabae maeto, shekel qui sarihto kazit sum kanglung hoiah sak ih sabae kathuk maeto, cang hoi angbawnhaih sak han suek ih sabae hnetto kakoi situi hoi atok tangcae ih takaw dip; ");
INSERT INTO cekak_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","shekel hato kazit hmuihoih suek haih sui sabae maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","hmai angbawnhaih sak hanah saning kanawk maitaw tae maeto, tuu tae maeto hoi saningto kaom tuucaa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","zae angbawnhaih sak hanah maeh caa maeto, ");
INSERT INTO cekak_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","angdaeh angbawnhaih sak hanah maitaw tae hnetto, tuu tae pangato, maeh tae pangato hoi saningto kaom tuucaa pangato a sinh; hae loe Enan capa Ahira mah paek ih hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Israel zaehoikungnawk mah, situi bawh moe, hmaicam tathlanghaih niah paek o ih hmuennawk loe, sum kanglung hoiah sak ih sabae hatlai hnetto, sum kanglung hoiah sak ih sui sabae kathuk hatlai hnetto hoi sui kathlah hatlai hnetto oh; ");
INSERT INTO cekak_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","sum kanglung sabae maeto naah shekel cumvai, qui thumto azit; sum kanglung hoiah sak ih sabae kathuk loe shekel qui sarihto azit; hmuenciim ih shekel baktih toengah, sum kanglung hoiah sak ih laom sabaenawk loe sangqum boih ah shekel sang hnetto pacoeng, cumvai palito azit. ");
INSERT INTO cekak_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Hmuenciim ah suek ih shekel baktih toengah, hmuihoih koimong ah suek ih sui kathlah hatlai hnetto loe shekel hato azit; sui kathlahnawk loe sangqum boih ah shekel cumvai, pumphaeto azit. ");
INSERT INTO cekak_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Hmai angbawnhaih sak hanah, cang hoi nawnto a sin o ih moinawk boih loe, maitaw tae hatlai hnetto, tuu tae hatlai hnetto hoi saningto kaom tuucaa tae hatlai hnetto oh moe, zae angbawnhaih sak hanah maeh caa hatlai hnetto a sin o. ");
INSERT INTO cekak_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Angdaeh angbawnhaih sak hanah sin o ih moinawk boih loe, saning kanawk maitaw tae pumphae palito, tuu tae qui tarukto, maeh tae qui tarukto hoi saningto kaom tuucaa qui tarukto oh. Hae tiah paek ih hmuennawk loe situi bawh moe, hmaicam tathlanghaih niah a paek o. ");
INSERT INTO cekak_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mosi loe Angraeng hoi lokpaeh hanah kaminawk amkhuenghaih kahni imthung ah akun naah, cherubim hnetto salak, hnukung thingkhong suekhaih ranuih ah kaom palungnathaih ahmuen hoiah thuih ih lok to a thaih; to tiah Angraeng mah Mosi khaeah lokthuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Aaron han, Hmaiim na thlaek naah, hmaiim sarihto paanghaih tung hmabang ah thlaek hanah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","To naah Aaron mah to tiah a sak; Angraeng mah Mosi khaeah thuih ih lok baktih toengah, anih mah hmaiim tung hmabang ah hmaiim to angqoisak boih. ");
INSERT INTO cekak_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Hmaiim tung loe, Angraeng mah Mosi khaeah patuek ih krang baktih toengah a sak; takung hoi tadong khoek to sui hoiah a sak. ");
INSERT INTO cekak_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Israel kaminawk salak hoi Levinawk to la ah loe, ciimsak ah. ");
INSERT INTO cekak_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Nihcae ciimsak hanah, hae tiah sah ah; ciimsakhaih tui to nihcae nuiah bawh ah; nganmui to aat o nasoe loe, khukbuennawk doeh pasuk o nasoe, to tiah ciimsak ah. ");
INSERT INTO cekak_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Saning kanawk maitaw tae maeto, cang hoi angbawnhaih sak ih baktiah, situi hoiah atok tangcae ih takaw dip hoi nawnto, zae angbawnhaih sak hanah, kalah saning kanawk maitaw tae maeto sin nasoe. ");
INSERT INTO cekak_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Levinawk to amkhuenghaih kahni im hmabang ah angzosak ah loe, Israel acaeng kaminawk to nawnto amkhuengsak boih ah; ");
INSERT INTO cekak_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Levinawk to Angraeng hmaa ah hoi ah; to naah Israel kaminawk mah nihcae nuiah ban koeng o tih. ");
INSERT INTO cekak_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Israel kaminawk mah tathlang o ih hmuen ah, Aaron mah Levinawk to Angraeng khaeah tathlang tih; to naah nihcae mah Angraeng ih tok to sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Levi kaminawk mah maitaw lunawk nuiah ban koeng o tih; Levi kaminawk zae angbawnhaih sak hanah maitaw maeto, hmai hoi angbawnhaih sak hanah kalah maitaw maeto Angraeng khaeah paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Levi kaminawk to Aaron hoi a caanawk hmaa ah angdoesak ah loe, nihcae to tathlang ih hmuen ah Angraeng khaeah paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Hae tiah Levi kaminawk to Israel kaminawk salak hoi pahoe ah; Levinawk loe kai ih hmuen ah om o tih. ");
INSERT INTO cekak_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","To tiah Levinawk ciimsak hanah na tathlang pacoengah ni, nihcae loe amkhuenghaih ahmuen ah toksak han caeh o vop tih. ");
INSERT INTO cekak_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Nihcae loe Israel kaminawk thungah kai khaeah takpum angpaek boih kami ah oh o; zok thung hoi tacawt kami boih, Israel kaminawk ih calu boih zuengah nihcae to ka lak boeh. ");
INSERT INTO cekak_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kami maw, moi maw, Israel kaminawk ih calu boih loe kai ih ni; Izip prae ih calu to ka tamit boih naah, nihcae to kaimah hanah ka pahoe boeh. ");
INSERT INTO cekak_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Israel kaminawk thung ih calu boih zuengah, Levinawk to ka lak boeh. ");
INSERT INTO cekak_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Israel kaminawk hmuenciim ah caeh o naah, nathaih kasae a tongh o han ai ah, amkhuenghaih kahni im ah tok to sak o moe, Israel caanawk akranghaih to a sak o hanah, Israel kaminawk thungah Levi kaminawk loe Aaron hoi a caanawk hanah tangqum ah ka paek boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Levi kawng pongah, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Mosi, Aaron hoi Israel acaengnawk mah, Levinawk nuiah sak o. ");
INSERT INTO cekak_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levinawk loe ciimcai o moe, khukbuennawk to pasuk o; Aaron mah nihcae han paek ih hmuen baktih toengah, Angraeng khaeah a paek moe, nihcae ciim hanah angbawnhaih to a sak pae. ");
INSERT INTO cekak_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Levi kawng pongah, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, kaminawk mah sak o; to pacoengah Levinawk loe kahni im ah toksak hanah, Aaron hoi a caanawk hma ah caeh o. ");
INSERT INTO cekak_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","To pacoengah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Levi kaminawk loe saning pumphae pangato akoep pacoengah ni, amkhuenghaih kahni im ah toksak han caeh o vop tih; hae loe Levinawk mah sak han koi tok ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Toe saning qui pangato akoep naah loe, kahni im thungah toksakhaih hoiah anghak o tih; toksah o mak ai boeh; ");
INSERT INTO cekak_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Angmacae nawkamyanawk hoi nawnto toksah o tih; toe nihcae loe toksah o mak ai boeh. Hae tiah Levi kaminawk mah sak han koi tok to sah paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Izip prae hoi tacawt o pacoeng, saning hnetto haih, khrah hmaloe koek naah, Sinai praezaek ah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","atue phak naah Israel kaminawk misong loihaih ni to uumsak ah. ");
INSERT INTO cekak_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Sakhaih atawk baktih, sakhaih daan baktih toengah, hae khrah hatlai palito, duembang phak naah loe, uumhaih poih to sah oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","To pongah Mosi mah Israel kaminawk khaeah, misong loihaih poih to sak o hanah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","To pongah khrah tangsuek, ni hatlai palito naah, Sinai praezaek ah misong loihaih poih to a sak o; Angraeng mah Mosi khaeah thuih ih lok baktih toengah, Israel kaminawk mah sak o. ");
INSERT INTO cekak_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Toe kadueh kami pongah kaciim ai thoemto kaminawk loe, misong loihaih poih to sah o thai ai pongah, Mosi hoi Aaron khaeah angzoh o moe, ");
INSERT INTO cekak_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Mosi khaeah, Kadueh kami pongah kaicae loe ka ciim o ai boeh; tipongah atue phak naah kalah Israel kaminawk baktih toengah, Angraeng khaeah hmuen tathlanghaih nang sahsak ai loe? tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mosi mah nihcae khaeah, Nangcae kawng pongah Angraeng mah lok na paek ai karoek to, zing o raeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","To naah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Israel kaminawk khaeah, Nangcae hoi na caanawk loe kadueh kami pongah ciimcai ai ah na oh o moe, kholong kangthla ah na caeh o cadoeh, misong loihaih poih to na sah o thai tih. ");
INSERT INTO cekak_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Khrah hnetto haih, ni hatlai palito, duembang ah sah oh; nihcae mah tuucaa moi hoi aan kakhaa to taeh thuh ai ih takaw hoiah nawnto caak o han oh. ");
INSERT INTO cekak_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Moi to khawnbang khoek to amtlai o sak han om ai; ahuh to khaek ai ah, misong loihaih poih sakhaih atawk baktih toengah sak o han oh. ");
INSERT INTO cekak_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Toe amhnonghaih om ai, kholong ah doeh caeh ai to mah, misong loihaih poih to sah ai kami loe, atue phak naah Angraeng khaeah hmuen tathlanghaih sah ai pongah, anih to angmah ih kaminawk salak hoiah takhoe ving han oh; anih loe zaehaih atho to hnu tih. ");
INSERT INTO cekak_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Nangcae khaeah kaom angvin mah Angraeng hanah misong loihaih ni to uum han koeh nahaeloe, sak zong ih misong loihaih baktih, poih sakhaih atawk baktih toengah a sak han oh; prae kami hoi angvin hanah poih sakhaih dan kangvan ah sah paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Kahni im sakhaih niah, hnukung ah kaom, kahni im to tamai mah khuk hmoek; duembang hoi akhawnbang khoek to kahni im ranui ah hmai baktiah amtueng. ");
INSERT INTO cekak_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","To tiah oh poe; athun ah tamai mah khuk moe, aqum ah hmai baktiah amtueng. ");
INSERT INTO cekak_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tamai mah kahni im to caehtaak naah, Israel kaminawk kholong caeh o moe, tamai tabok naah, Israel kaminawk mah im to sak o. ");
INSERT INTO cekak_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Angraeng mah paek ih lok baktih toengah, Israel kaminawk kholong caeh o moe, Angraeng mah paek ih lok baktih toengah nihcae mah im to sak o; kahni im nuiah tamai oh nathung, nihcae loe angmacae ih kahni im ah anghak o. ");
INSERT INTO cekak_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kahni im nuiah atue kasawk ah tamai oh naah, Israel kaminawk kholong caeh o ai, Angraeng mah paek ih lok to a zing o. ");
INSERT INTO cekak_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kahni im nuiah atue setta thung tamai tabok naah loe, Angraeng mah paek ih lok baktih toengah anghak o; to pacoengah Angraeng mah paek ih lok baktih toengah kholong caeh o let. ");
INSERT INTO cekak_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Duembang hoi akhawnbang khoek to tamai tabok moe, akhawnbang ah tamai van bangah angkhong tahang naah, Israel kaminawk kholong caeh o; khodai ah doeh, khoving ah doeh, tamai angkhong tahang kruek, kholong a caeh o. ");
INSERT INTO cekak_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kahni im nuiah ni hnetto maw, to tih ai boeh loe khrah to maw, to tih ai boeh loe saningto maw, tamai mah khuk nahaeloe, Israel kaminawk loe tamai oh nathung kholong caeh o mak ai, anghak o tih; toe tamai van ah angkhong tahang nahaeloe, nihcae mah kholong caeh amsak o tih. ");
INSERT INTO cekak_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Angraeng mah paek ih lok baktih toengah, nihcae loe im ah anghak o moe, Angraeng mah paek ih lok baktih toengah, nihcae loe kholong caeh amsak o; Angraeng mah Mosi ban ah paek ih lok baktih toengah, Angraeng ih lok to tahngaih o. ");
INSERT INTO cekak_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","kaminawk amkhueng o naah kawkhaih, ataihaih ahmuen maeto pacoeng maeto bang angpuen naah patoh hanah, sum kanglung hoiah mongkah hnetto sah ah; ");
INSERT INTO cekak_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","mongkah na ueng o hmaek naah, acaeng kaminawk boih angkhuenghaih kahni im thok taengah, nang ih ahma ah amkhueng o boih tih. ");
INSERT INTO cekak_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Mongkah maeto khue ueng nahaeloe, ukkungnawk hoi Israel ukkung lu koeknawk to na hma ah amkhueng o tih. ");
INSERT INTO cekak_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Acoe paekhaih mongkah to ueng naah, ni angyae bangah kaom kaminawk to hmabang ah caeh o tih. ");
INSERT INTO cekak_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Acoe paekhaih mongkah vai hnetto ueng naah, aloih bang ataihaih ahmuen ah kaom kaminawk to caeh o tih; acoe paekhaih mongkah lok loe nihcae caeh han angmathaih lok ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kaminawk amkhueng o hanah, mongkah to ueng ah; toe kanghmong acoe paekhaih to ueng hmah. ");
INSERT INTO cekak_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aaron caanawk hoi qaimanawk mah mongkah to ueng o tih; hae loe na caanawk dung khoek to sak han koi hmuen ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Na prae thungah nangcae pacaekthlaek misanawk to tuk hanah na caeh o naah, acoe paekhaih lok hoi mongkah to nawnto ueng ah; to naah na Angraeng Sithaw mah nangcae to panoek ueloe, na misanawk ban thung hoiah pahlong tih. ");
INSERT INTO cekak_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Nangcae loe nawmhaih atue, poihsakhaih atue, khrah kangtha uumhaih atue ah na Angraeng Sithaw na panoek o thai hanah, angbawnhaih hoi angdaeh angbawnhaih sak naah mongkah to ueng oh; Kai loe na Angraeng Sithaw ah ka oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Saning hnet, khrah hnetto haih, ni pumphaeto naah, hnukung ah kaom kahni im ranui ih tamai to van bangah angkhoeng tahang. ");
INSERT INTO cekak_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","To naah Israel kaminawk loe kholong caeh han Sinai praezaek hoiah angthawk o; to pacoeng ah Paran praezaek ah tamai to anghak let. ");
INSERT INTO cekak_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Angraeng mah Mosi khaeah paek ih lok baktih toengah, hae loe nihcae hmaloe koek kholong caehhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Judah kaminawk loe angmacae angmathaih kahni to sin o moe, ataihaih ahmuen hoiah hmaloe koek ah caeh o; Amminadab capa Nashon loe nihcae ukkung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Zuar capa Nathanel loe Issakar acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Helon capa Eliab loe Zebulun acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","To pacoengah kahni im to phraek o, Gershon hoi Merari ih caanawk mah aput o moe, a caeh o. ");
INSERT INTO cekak_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","To pacoengah Reuben kaminawk mah angmacae angmathaih kahni to sin o moe, ohhaih ahmuen hoiah hmabang ah caeh o; Shedeur capa Elizur loe nihcae zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Zurshaddai capa Shelumiel loe Simeon acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Deuel capa Eliasaph loe Gad acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","To pacoengah Kohath acaegnawk mah hmuenciim ih hmuenmaenawk to aput o moe, hmabang ah caeh o; hmaloe caeh kaminawk mah nihcae pha ai naah kahni im to sak o. ");
INSERT INTO cekak_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ephraim kaminawk loe angmacae angmathaih kahni to sin o moe, ataihaih hmuen hoiah hmaloe koek ah caeh o; Ammihud capa Elishama loe nihcae zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pehdazur capa Gamaliel loe Manasseh acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gideoni capa Abidan loe Benjamin acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Hnukkhuem koek ah, Dan kaminawk loe angmacae angmathaih kahni to sin o moe, ataihaih ahmuen hoiah hmabang ah caeh o; Ammishaddai capa Ahiezer loe nihcae zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okran capa Pagiel loe Asher acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enan capa Ahira loe Naphatali acaeng zaehoikung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Hae loe Israel kaminawk kholong caeh naah, angmacae acaeng maeto pacoeng maeto caehhaih dan ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Angraeng mah, Mosi khaeah paek ih lok baktih toengah, Mosi mah Midian prae, Mosi ih amsae, Raguel capa Hobab khaeah, Angraeng mah nangcae khaeah ka paek han, tiah lokkam ih prae thungah vaihi ka caeh o; kaicae hnukah bang ah, Angraeng mah Israel kaminawk ih khosak hoihaih kawng to thuih boeh pongah, nang to kang tahmen o han hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab mah anih khaeah, Ka caeh mak ai; ka prae hoi kaimah ih kaminawk khaeah ni ka caeh han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Toe Mosi mah, Kaicae hae na caehtaak hmah; kaicae loe praezaek ah ka tai o han vop, tito na panoek; nang loe kaicae ih mik ah na oh. ");
INSERT INTO cekak_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kaicae hoi nawnto nang zoh nahaeloe, Angraeng mah kaicae khaeah paek ih kahoih hmuen, nang han doeh kang pazet o toeng han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","To pongah Angraeng ih mae hoiah angthawk o moe, ni thumto caehhaih kangthla ahmuen ah a caeh o; ni thumto kholong caeh nathung, Angraeng lokkamhaih thingkhong loe, nihcae ataihaih ahmuen to pakrong pae hanah, nihcae hmaa ah caeh. ");
INSERT INTO cekak_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Khodai ah nihcae kholong caeh o naah, Angraeng ih tamai loe nihcae nuiah oh poe. ");
INSERT INTO cekak_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Thingkhong hmabang ah caeh naah, Mosi mah, Aw Angraeng, Angthawk ah! Na misanawk loe amhet o phang nasoe loe, nang hnuma kaminawk to na hma ah cawn o nasoe, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Anghakhaih ahmuen to a phak o naah, Kroek laek ai Israel kaminawk khaeah, Aw Angraeng, amlaem let lai ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","1 Kaminawk mah laisaep thui ih lok to Angraeng mah thaih naah, palungphui hmai baktiah amngaeh; to pongah Angraeng ih hmai mah nihcae salak to kangh moe, kangthla koek ohhaih ahmuen taeng ih thoemto kaminawk to duek o. ");
INSERT INTO cekak_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","To naah kaminawk loe Mosi khaeah hangh o; Mosi mah Angraeng khaeah lawkthuih naah, hmai to duek let. ");
INSERT INTO cekak_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Angraeng ih hmai mah nihcae salak to kangh pongah, to ahmuen to Taberah, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Israel kaminawk hoi nawnto kaom prae kalah kaminawk loe, zok amthlam o; Israel kaminawk doeh qah o moe, mi mah maw ka caak o hanah moi na paek tih? ");
INSERT INTO cekak_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Izip prae ah atho paek ai ah caak ih tanga moi, paye thaih, yaengkaem thaih, rasawn kathim hoi kanglung rasawn, kalah congca aannawk to ka poek o parai boeh; ");
INSERT INTO cekak_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","toe vaihi loe ka hing o haih thazok sut boeh; hae ih manna khue ai ah loe, kalah tidoeh hnuk han koi om ai, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna loe Coriander thingthai mu baktiah oh moe, arong loe bedellium thingthai mu hoiah anghmong. ");
INSERT INTO cekak_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Kaminawk loe caeh o moe, Manna akhuih o pacoengah, daengh o moe, long laom pongah takaw baktiah pahaih o; to loe situi hoiah haek ih takaw baktiah khraem. ");
INSERT INTO cekak_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ataihaih ahmuen ah aqum ih dantui krak naah, manna doeh dantui hoi nawnto krak toeng. ");
INSERT INTO cekak_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","To naah kami boih angmacae ih thok taengah, angmacae imthung takoh boih hoi nawnto qahhaih lok to Mosi mah thaih; Angraeng loe palungphui parai pongah, Mosi doeh poek nawm ai. ");
INSERT INTO cekak_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","To pongah Mosi mah Angraeng khaeah, Tipongah na tamna raihaih nang paek loe? Tikhoe na hmaa ah mikcuk naakrak ah ka om ai to mah, hae kaminawk boih ih hmuenzit ka nuiah nam tik loe? ");
INSERT INTO cekak_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Hae kaminawk loe kai mah zok ah ka pomh ih kaminawk maw, tikhoe nawkta tapenkung mah nawkta to tapom baktih toengah, hae kaminawk hae ka ban ah tapom moe, nihcae ampanawk khaeah paek hanah lok na kam ih, prae thungah caeh haih hanah nang thuih loe? ");
INSERT INTO cekak_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Hae kaminawk hanah naa ih moi maw ka la pae thai tih? Nihcae mah kai khaeah, Caak han moi na paek ah, tiah ang hnik o. ");
INSERT INTO cekak_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Hae kaminawk hae kaimah bueng ka hoi thai mak ai; hae hmuen loe kai hanah azit hmoek. ");
INSERT INTO cekak_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","To tiah kai hae nang ohsak moe, na mikhnuk ah koeh koiah ka oh nahaeloe, vaihiah na hum halat ah! Amtanghaih na hnusak hma ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Angraeng mah Mosi khaeah, Israel kacoehtanawk qui sarihto hoi zaehoikungnawk, na panoek ih ukkungnawk to nangmah hoi nawnto amkhuenghaih kahni im ah angdoet o thai hanah, kai khaeah angzo haih ah. ");
INSERT INTO cekak_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","To ah nang hoi lokthuih hanah kang zoh tathuk han; na nuiah kaom pakhra to ka lak moe, nihcae nuiah ka suek han; hae kaminawk hae nangmah bueng na hoi mak ai, kaminawk ih hmuen kazit to nihcae mah na lawn o tih. ");
INSERT INTO cekak_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Kaminawk khaeah hae tiah thui paeh; khawnbang hanah ciimcai oh, moi to na caa o tih; nangcae mah, Mi mah maw caak han moi na paek tih? Izip prae ah loe khosak kahoih ah ka oh o, tiah na qah o haih lok Angraeng mah thaih boeh pongah, Angraeng mah moi na paek o ueloe, na caa o tih boeh. ");
INSERT INTO cekak_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nito, ni hnetto, ni pangato, ni hato, ni pumphaeto khue na caa o mak ai; ");
INSERT INTO cekak_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","na hnah thung hoiah moi tacawt moe, na panuet o sut khoek to, khrato thung moi to na caa o poe tih; nangcae salakah kaom Angraeng to khet na patoek o moe, tih pongah maw Izip prae to ka caeh o taak? tiah anih hmaa ah na qah o pongah, khrah to thung moi to na caa o tuek tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Toe Mosi mah loe, Kai hoi nawnto kholong caeh kami sang cumvai tarukto oh o; khrah to thung caak poe han ih moi to kang paek han, tiah na thuih. ");
INSERT INTO cekak_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Nihcae caak kakhawt ah maitaw hoi tuunawk to boh han maw? Tuipui ih tanganawk boih naeh cadoeh, nihcae caak han khawt tih maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Angraeng mah Mosi khaeah, Angraeng ih ban loe duem tet maw? Ka thuih ih lok baktih toengah nangcae khaeah oh maw, om ai, tito vaihi na hnu tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mosi loe caeh moe, Angraeng mah thuih ih loknawk to kaminawk khaeah thuih pae; nihcae thung ih kacoehta qui sarihto a kawk moe, kahni im taengah ohsak. ");
INSERT INTO cekak_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","To naah Angraeng loe tamai hoiah anghum tathuk moe, anih khaeah lokthuih; anih nui ah kaom Pakhra to a lak moe, kacoehta qui sarihto nuiah a suek; nihcae nuiah Pakhra oh naah, nihcae loe boeng ai ah lok taphong o. ");
INSERT INTO cekak_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Toe kami hnetto, Eldad hoi Medad loe ataihaih ahmuen ah oh hoi poe; nihnik doeh kacoehta thungah athum hoi toeng, toe kahni im taengah caeh hoi ai; nihnik nuiah doeh Pakhra to oh pongah, atai hoi haih ahmuen ah lok taphong hoi toeng. ");
INSERT INTO cekak_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Thendoeng maeto loe cawnh moe, Mosi khaeah, Eldad hoi Medad hnik doeh ataihaih im ah lok taphong hoi toeng, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Mosi ih tamna, thendoeng, Nun capa Joshua mah, Ka angraeng Mosi, nihnik to lokthuih anghaksak ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Toe Mosi mah anih khaeah, Ka nuiah uthaih palungthin na tawnh maw? Angraeng ih kaminawk loe tahmaa ah ni oh o boih, Angraeng mah nihcae nuiah angmah ih Muithla to suem tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","To pacoengah Mosi hoi Israel kacoehtanawk loe a oh o haih im ah amlaem o let. ");
INSERT INTO cekak_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","To naah Angraeng khae hoiah takhi to songh moe, nihcae ataihaih im hae bang hoi ni to caehhaih loklam, ho bang hoiah doeh ni to caehhaih loklam karoek to, tuipui hoiah kuikoem to a sin pae; long hoi dong hnetto kathah ah angpopsak. ");
INSERT INTO cekak_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","To naah kaminawk mah athun qui, aqum puek, kuikoem to akhuih o, khawnbang khoek to a lak o; tamsi koek akhui kami mah homer hato akhuih o; kuikoem to atai o haih im taeng boih ah tapop o. ");
INSERT INTO cekak_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Toe kuikoem moi to caa o ai naah, Angraeng palungphuihaih kaminawk nuiah phak; to pongah nihcae khaeah kanung parai nathaih kasae to phaksak. ");
INSERT INTO cekak_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Caak amoeh hmoek kaminawk to aphum o pongah, to ahmuen to Kibroth-Hattaavah, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kaminawk loe Kibroth-Hattavah ahmuen hoiah Hazeroth ahmuen ah caeh o moe, to ah atai o. ");
INSERT INTO cekak_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mosi mah Ethiopia tanu to zu haih moe, Ethiopia nongpata to zu ah a lak pongah, Miriam hoi Aaron mah Mosi to kasae thuih hoi. ");
INSERT INTO cekak_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Nihnik mah, Angraeng mah Mosi khae khue ah maw lokthuih? Aicae khaeah doeh lokthui ai maw? tiah a thuih hoi. To lok to Angraeng mah thaih. ");
INSERT INTO cekak_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(To naah Mosi loe long pum ah kaom kaminawk boih pongah doeh, poek panaemhaih tawn kami ah oh.) ");
INSERT INTO cekak_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Angraeng mah, Mosi, Aaron hoi Miriam khaeah, Nangcae long thumto amkhuenghaih im ah angzo oh, tiah a naa. To pongah nihcae loe caeh o. ");
INSERT INTO cekak_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","To naah Angraeng loe tamai thung hoiah angzoh tathuk, kahni im thok taengah angdoet moe, Aaron hoi Miriam to kawk; nihnik loe hmabang ah tacawt hoi. ");
INSERT INTO cekak_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Anih mah, Ka lok hae tahngai hoih; Nangcae salakah Angraeng ih tahmaa to om nahaeloe, anih khaeah hnuksakhaih hoiah kam tueng moe, anih khaeah amang ah lok ka thuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Toe ka tamna Mosi loe to tiah om ai; anih loe ka imthung takoh boih ah oep thok koek kami ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Anih hoi lok ka thuih naah, mikhmai kangtong ah ni lok ka thuih han, thaih karai lok hoiah ka thui mak ai; anih mah Angraeng ih krang to hnu tih; tikhoe ka tamna Mosi ih lok aek hanah zithaih na tawn hoi ai loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Angraeng palungphuihaih mah nihnik to kangh, to pacoengah anih mah caehtaak. ");
INSERT INTO cekak_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Tamai mah kahni im to caehtaak pacoengah, khenah, Miriam loe dantui kanglung baktiah ngansae man khrung; Aaron mah Miriam to khet naah, anih loe ngansae man kami ah a hnuk. ");
INSERT INTO cekak_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","To naah Aaron mah Mosi khaeah, Ka angraeng, amthuhaih hoiah ni hmuen hae ka sak hoi moeng boeh, tahmenhaih hoiah hae zaehaih hae kai hnik nuiah amtii hmah raeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Anih hae amno ih zok thung hoiah tacawt naah kakoep ai kami, takpum ahap kadueh kami baktiah omsak hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","To pongah Mosi mah Angraeng khaeah, Aw Sithaw, tahmenhaih hoiah anih hae vaihi ngantuisak rae ah, tiah a hangh. ");
INSERT INTO cekak_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Angraeng mah Mosi khaeah, ampa mah Miriam ih mikhmai ah pathoih nahaeloe, anih loe ni sarihto thung azathaih hoiah om mak ai maw? Anih to na oh o haih ahmuen tasa bangah ni sarihto thung suem ah, to pacoengah a thungah akunsak let ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","To pongah Miriam to ataihaih im tasa bangah ni sarihto thung a suek o; Miriam a thungah akun o sak let ai karoek to, kaminawk loe kholong caeh o ai. ");
INSERT INTO cekak_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","To pacoengah kaminawk loe, Hazeroth ahmuen ah angpuen o moe, Paran praezaek ah ohhaih ahmuen takhawh o. ");
INSERT INTO cekak_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","kai mah Israel kaminawk khaeah paek ih Kanaan prae khet hanah kami to patoeh ah; acaeng maeto thung hoi zaehoikung maeto patoeh ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Angraeng mah paek ih lok baktih toengah, Mosi mah Paran praezaek hoiah nihcae to patoeh; nihcae loe Israel zaehoikung ah oh o boih. ");
INSERT INTO cekak_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","To kaminawk ih ahmin loe, Reuben acaeng thung hoiah, Zakur capa Shammua. ");
INSERT INTO cekak_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon acaeng thung hoiah, Hori capa Shaphat. ");
INSERT INTO cekak_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Judah acaeng thung hoiah, Jephunneh capa Kaleb. ");
INSERT INTO cekak_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Issakar acaeng thung hoiah, Joseph capa Igal. ");
INSERT INTO cekak_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ephraim acaeng thung hoiah, Nun capa Oshea. ");
INSERT INTO cekak_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benjamin acaeng thung hoiah, Raphu capa Palti. ");
INSERT INTO cekak_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zebulun acaeng thung hoiah, Sodi capa Gaddiel. ");
INSERT INTO cekak_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Joseph acaeng ah kaom, Mannaseh acaeng thung hoiah, Susi capa Gaddi. ");
INSERT INTO cekak_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan acaeng thung hoiah, Gemalli capa Ammiel. ");
INSERT INTO cekak_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asher acaeng thung hoiah, Mikhael capa Sethur. ");
INSERT INTO cekak_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naphtali acaeng thung hoiah, Vophsi capa Nahbi. ");
INSERT INTO cekak_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad acaeng thung hoiah, Maki capa Geuel. ");
INSERT INTO cekak_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Hae kaminawk loe Mosi mah tamquta hoi prae khet han patoeh ih kami ah oh o. Mosi mah Nun capa Oshea to Jehoshua, tiah ahmin paek. ");
INSERT INTO cekak_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kanaan prae khet hanah Mosi mah nihcae to patoeh naah, aloih bang hoiah caeh o tahang ah loe, mae ah daw o tahang poe ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Prae loe kawbang maw oh; to ah kaom prae kaminawk loe thacak o maw, thacak o ai, kami pop o maw, pop o ai; ");
INSERT INTO cekak_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","nihcae ohhaih prae loe hoih maw, hoih ai; kawbaktih vangpui thungah maw oh o; buk thungah maw, to tih ai boeh loe sipae kaom vangpui thungah; ");
INSERT INTO cekak_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","long loe kawbang maw oh, long loe hoih maw, hoih ai; thing pop maw, pop ai, tito khen oh; misahoih oh loe, prae thung ih thingthai doeh sin oh, tiah a naa. To nathuem ih atue loe misurthaih hmin tangsuekhaih atue ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","To pongah nihcae loe Zin praezaek hoiah caeh o moe, Hammath vangpui taeng ih Rehob ahmuen karoek to prae to a khet o. ");
INSERT INTO cekak_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Aloih bang hoiah caeh o poe moe, Anak caanawk, Ahiman, Sheshai hoi Talmai ohhaih, Hebron vangpui to a phak o. Hebron vangpui loe Izip prae ih Zoan vangpui sah ai naah saning sarihto oh boeh. ");
INSERT INTO cekak_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Eshkol ih vacong to phak o naah, misurthaih kangbom tanghang maeto pakhruk o moe, kami hnetto mah angzawn hoi; pomogranat thaih hoi thaiduet thaih doeh angzawn hoi. ");
INSERT INTO cekak_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israel kaminawk mah to ahmuen ah kanghmat misurthaih tanghang maeto pakhruk o pongah, to ahmuen to Eshkol vacong, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ni qui palito pacoengah prae khethaih ahmuen hoiah amlaem o let. ");
INSERT INTO cekak_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Nihcae loe Mosi hoi Aaron ohhaih Paran praezaek ih Kadesh ah, Israel kaminawk khaeah angzoh o let; nihcae khaeah prae khethaih kawng to thuih pae o, kaminawk khaeah to prae thung ih thingthai to patuek o. ");
INSERT INTO cekak_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Mosi khaeah, Nang patoeh ih prae thungah ka caeh o, to prae loe khoitui hoi tahnutui long tangak boeh; hae loe to prae thung hoi kang sin o ih thingthai ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Toe to prae thungah kaom kaminawk loe thacak o parai moe, vangpuinawk doeh len parai, vangpuinawk loe sipae thungh o boih; to ahmuen ah Anak ih caanawk to ka hnuk o. ");
INSERT INTO cekak_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek kaminawk loe aloih bang prae ah oh o; Hit kaminawk, Jebus kaminawk hoi Amor kaminawk loe mae nuiah oh o; Kanaan kaminawk loe tuipui taeng hoi Jordan vapui taengah oh o, tiah a thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb mah Mosi hmaa ah kaminawk to anghaisak moe, Caeh o si loe, to prae to la o si; a pazawk o thai tih hmang, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Toe anih hoi nawnto caeh kaminawk mah loe, To ih kaminawk to a pazawk o thai mak ai; nihcae loe aicae pongah thacak o kue, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Nihcae mah prae khethaih tamthang kasae to Israel kaminawk salakah haeh o; to kaminawk mah, Ka caeh moe, ka khet o ih prae loe, a thungah kaom kaminawk paaeh boih prae ah oh; to ah kaom ka hnuk o ih kaminawk boih loe len o phi. ");
INSERT INTO cekak_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","To ah kalen parai kami, Anak caanawk to ka hnuk o; nihcae loe kalen parai kami hoi anghum tathuk kami ah oh o; nihcae mikhnuk ah kaicae loe pakhuh baktiah ni ka oh o; kaicae loe nihcae mikhnuk ah to tiah ka oh o, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","To aqum naah kaminawk loe tha hoi hangh o moe, qah o. ");
INSERT INTO cekak_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israel kaminawk boih mah Mosi hoi Aaron to laisaep o thuih, Izip prae ah maw, to tih ai boeh loe praezaek ah duek halat nahaeloe hoih han to mah! ");
INSERT INTO cekak_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Tikhoe aicae loe sumsen hoiah a duek o moe, aicae ih zu caanawk minawk mah lomh hanah, Angraeng mah hae prae ah caeh haih loe? Izip prae ah amlaem let nahaeloe, hoikhang tih, tiah nihnik khaeah thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","To naah angmacae hoi angmacae zaehoikung to qoi o si loe, Izip prae ah amlaem o let si, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mosi hoi Aaron mah to ah amkhueng Israel kaminawk boih hma ah, long ah akuep pae hoi. ");
INSERT INTO cekak_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Kanaan prae khet han kacaeh, Nun capa Joshua hoi Jephunneh capa Kaleb loe, angmah hnik ih kahni to angkhring hoi pacoengah, ");
INSERT INTO cekak_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","to ah amkhueng Israel kaminawk boih khaeah, a caeh o moe, a khet o ih prae loe hoih parai. ");
INSERT INTO cekak_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Angraeng mah aicae nuiah palung tongh nahaeloe, tahnutui hoi khoitui longhaih prae thungah, aicae na caeh haih ueloe, hae prae hae aicae han na paek tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Angraeng nuiah laisaep o hmah loe, to ih prae kaminawk to zii o hmah; nihcae loe a caak o han koi takaw ah ni oh o; nihcae loe angvaenghaih tawn o ai; Angraeng loe aicae hoi nawnto oh; nihcae to zii o hmah, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Toe kaminawk mah nihnik to thlung hoiah vah han thuih o; to naah Angraeng lensawkhaih Israel kaminawk amkhuenghaih kahni imthung ah phak. ");
INSERT INTO cekak_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Angraeng mah Mosi khaeah, Hae kaminawk mah nasetto maw palung na phui o sak tih? Nihcae khaeah ka sak ih dawnrai hmuen to a hnuk o boeh; toe nasetto maw hae kaminawk mah kai tang ai ah om o vop tih? ");
INSERT INTO cekak_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nihcae nuiah kasae nathaih ka phaksak han, qawk doeh ka toepsak mak ai; toe nihcae pong kalen kue, thacak kue acaeng ah nang to kang sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mosi mah Angraeng khaeah, To tiah nahaeloe, Na thacakhaih hoiah hae kaminawk hae na zaehhoih, tiah Izip kaminawk mah panoek o tih boeh; ");
INSERT INTO cekak_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","to naah nihcae mah hae prae ah kaom kaminawk khaeah hae tamthang hae thui pae o tih; Angraeng, nang loe hae kaminawk hoi nawnto na oh, Angraeng, nang to mikhmai kangtong ah a hnuk o boeh; nang ih tamai loe nihcae nuiah angdoet moe, nang loe nihcae hma ah na caeh; khodai ah nihcae to tamai hoiah na zaeh moe, khoving ah hmaithaw hoiah na caeh haih. ");
INSERT INTO cekak_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Hae kaminawk boih hae kami maeto baktiah vaihi na dueksak nahaeloe, nang ih tamthang thaih acaengnawk mah loe, ");
INSERT INTO cekak_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Angraeng mah to kaminawk khaeah prae to kang paek han, tiah lokkamhaih a sak pae; toe anih mah to prae thungah caeh haih thai ai pongah, praezaek ah a hum boih, tiah thui o tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Na thuih ih lok baktih toengah, vaihiah ka Angraeng thacakhaih to len nasoe, ");
INSERT INTO cekak_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Angraeng loe palungsawk, amlunghaih hoiah koi moe, zaehaih hoi sakpazaehaihnawk to tahmen pae; toe zaehaih sah kami loe thuitaek ai ah om ai; anih loe ampanawk zaehaih pongah adung thum, adung pali karoek to a caanawk thuitaekkung ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kalen parai na palungnathaih rang hoiah, Izip prae thung hoi kamtong vaihni ni khoek to hae kaminawk hae na tahmen baktih toengah, hae kaminawk zaehaih doeh tahmen raeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Angraeng mah, Nang hnik ih lok baktih toengah, kang tahmen boeh; ");
INSERT INTO cekak_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","toe kai ka hing tangtang baktih toengah, longpum ah Angraeng lensawkhaih to koi tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Izip prae hoi praezaek ah ka sak ih lensawkhaih hoi dawnrai hmuennawk hnu kaminawk boih mah ka lok hae tahngai o ai, vai hato Kai ang tanoek o pongah, ");
INSERT INTO cekak_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ampanawk khaeah paek han tiah lokkam ih prae to mi mah doeh hnu o mak ai; kai palungphuisak kawbaktih kami mah doeh to prae to hnu o mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Toe ka tamna Kaleb loe, kalah poekhaih pakhra to tawnh moe, palungthin boih hoiah kai ang bang pongah, anih to a caehhaih prae thungah ka hoih han; anih ih caanawk mah prae to toep o tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amalek hoi Kanaan kaminawk loe azawn ah khosak o; khawnbang ah amlaem oh loe, tuipui kathim bang hoiah praezaek ah caeh oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","ka lok to aek moe, laisaep hae ih kasae kaminawk hae nasetto maw ka pauep han vop? Israel kaminawk mah kasae ang thuih o moe, kai laisaep thuihaih lok to ka thaih boeh. ");
INSERT INTO cekak_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Nihcae khaeah, Kai ka hing pongah, ka naa ah nang thuih o ih baktih toengah, ka sak han, tiah Angraeng mah thuih. ");
INSERT INTO cekak_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Na kroek o ih nangmacae kaminawk boih thungah, kai laisaep thuih, saning pumphaeto hoi ranuih bang kaminawk loe praezaek ah dueh o tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Jephunneh capa Kaleb hoi Nun capa Joshua khue ai ah loe, ban ka payangh moe, ohsak hanah lok ka kam ih prae thungah mi doeh akun o mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Misa mah lomh ving tih, tiah na thuih o ih na caanawk to kai mah ka zaeh han, nangcae mah na khet patoek o ih prae to nihcae mah panoek o tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Toe nangcae loe hae praezaek ah na dueh o ueloe, qok doeh pong sut tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Nangcae loe oepthok ah kho na sah o ai pongah, praezaek ah nangcae ih qok to pong sut boih ai karoek to, na caanawk loe saning qui palito thung praezaek ah amhet o tih. ");
INSERT INTO cekak_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Prae pakrong hanah ni qui palito akra baktih toengah, nito hae saningto ah suem oh, na sak o ih zaehaih atho baktih toengah, saning qui palito thung patang na khang o tih; to naah ka lok aekhaih atho to na panoek o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Kai, Angraeng mah lokthuih boeh; kai ih lok aek hanah nawnto amkhueng, kahoih ai hae kaminawk nuiah, hae hmuen hae ka sak tangtang han; nihcae loe hae praezaek ah amro o ueloe, dueh o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","To pongah prae khet hanah Mosi mah patoeh ih kaminawk amlaem o pacoengah, a khet o ih prae loe hoih ai, tiah amkhueng kaminawk hmaa ah laisaep thuih kaminawk, ");
INSERT INTO cekak_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","kanaan prae loe hoih ai tiah thui kaminawk loe, Angraeng hmaa ah kasae nathaih mah phak thuih moe, duek o. ");
INSERT INTO cekak_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Prae khet han kacaeh kaminawk boih thungah, Nun capa Joshua hoi Jephunneh capa Kaleb hnik khue ni hing hoi. ");
INSERT INTO cekak_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","To lok to Mosi mah Israel kaminawk khaeah thuih pae naah, kaminawk loe paroeai hangh o. ");
INSERT INTO cekak_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Khawnbang khawnthaw ah angthawk o moe, mae nuiah caeh o; khenah, a zae o boeh; toe Angraeng mah lokkam ih ahmuen ah caeh o si, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Toe Mosi mah, Tipongah vaihi Angraeng mah paek ih lok to na tahngai o ai loe? Hae tiah na sak o nahaeloe na qoeng o thai mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Nangcae khaeah Angraeng om ai pongah, caeh o tahang hmah; na caeh o nahaeloe misanawk to na pazawk o mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalek hoi Kanaan kaminawk loe, nangcae hma ah oh o boeh pongah, nangcae loe sumsen hoiah na dueh o tih; nangcae mah Angraeng to nang qoi o taak boeh pongah, nangcae khaeah Angraeng om mak ai boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Toe Mosi hoi Angraeng ih thingkhong loe, ataihaih ahmuen to caehtaak ai; toe nihcae loe palungthah o pongah, mae nuiah caeh o nganga. ");
INSERT INTO cekak_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","To naah to mae nuiah kaom, Amalek hoi Kanaan kaminawk anghum o tathuk moe, Israel kaminawk to tuk o, nihcae to pazawk o pacoengah, Hormah vangpui khoek to patom o. ");
INSERT INTO cekak_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Israel kaminawk khaeah hae tiah thui paeh; nihcae khaeah, Kang paek ih prae thungah na kun o naah, ");
INSERT INTO cekak_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Angraeng khaeah hmai angbawnhaih to sah oh; maitaw maw, to tih ai boeh loe tuu to Angraeng khaeah hmai angbawnhaih ah paek oh; maitaw doeh, tuu doeh Angraeng khaeah hmuihoih hmuen ah maw, to tih ai boeh loe angbawnhaih maw, to tiah ai boeh loe tathlang ih hmuen ah maw, to tih ai boeh loe lokkamhaih sak han ih maw, to tih ai boeh loe aimah koehah paek ih hmuen tathlanghaih maw, poihsakhaih ah tathlang ih hmuen ah maw sah oh: ");
INSERT INTO cekak_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","mi kawbaktih doeh Angraeng khaeah hmuen paekhaih sin kami loe, cang paekhaih sak naah situi hint palito thungah maeto hoi atok ih takaw dip ephah hato thungah maeto paek han oh; ");
INSERT INTO cekak_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","tuucaa hoi angbawnhaih sah nahaeloe, naek han koi hmuen hoi misurtui hint palito thungah maeto paek han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Tuu tae maeto hoi angbawnhaih sah nahaeloe, cang ephah hato thungah hnetto, situi hint thumto thungah hint maeto hoi atok ih takaw dip to paek han oh, ");
INSERT INTO cekak_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Angraeng khaeah hmuihoih ah hmuen tathlang nahaeloe, naek koi paek naah misurtui hint thumto thungah maeto paek han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Angraeng khaeah maitaw tae hoi angbawnhaih maw, to tih ai boeh loe hmuen paekhaih, to tih ai boeh loe lokkamhaih sak han angbawnhaih maw, to tih ai boeh loe angdaeh angbawnhaih maw sak naah, ");
INSERT INTO cekak_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","maitaw tae hoi nawnto situi hint ahap hoi atok tangcae ih takaw dip ephah hato thungah thumto sin ah. ");
INSERT INTO cekak_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Naek hanah misurtui hint ahap to sin ah. To tiah hmai hoi sak ih angbawnhaih loe Angraeng khaeah paek ih hmuihoih ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Maitaw tae maeto, to tih ai boeh loe tuu tae maeto, to tih ai boeh loe tuucaa maeto, to tih ai boeh loe maeh caa maeto hoi angbawnhaih sak naah to tiah sak han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Kapop maw, tamsi maw, sak na timhaih nuiah pakoep ah loe, maeto boih hanah to tiah sah ah. ");
INSERT INTO cekak_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Prae thung tapen kaminawk boih mah, Angraeng khaeah hmuihoih sin han hmai hoi angbawnhaih sak naah, to tiah sak han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nangcae salakah kaom angvinnawk maw, to tih ai boeh loe mi kawbaktih doeh, hmuihoih ah paek han Angraeng khaeah hmai hoi angbawnhaih sak naah, nangcae mah sak ih baktih toengah a sak o toeng han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hing thung na caanawk mah pazui o poe hanah paek ih atawk loe, nangcae amkhueng kaminawk hoi nangcae salakah kaom angvinnawk hanah doeh maeto ah ni oh; nangcae Angraeng hmaa ah oh baktih toengah, angvin doeh om toeng tih. ");
INSERT INTO cekak_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Nangcae hoi nangcae salakah kaom angvinnawk hanah, daan maeto hoi atawk maeto ah omsak ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Israel kaminawk khaeah hae tiah thui paeh; nihcae khaeah, Kang hoih o han ih prae thungah na kun o naah, ");
INSERT INTO cekak_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","to prae thung ih takaw na caak o naah doeh, Angraeng khaeah hmuen tathlanghaih to sah oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Na daengh tangsuek ih takaw dip hoi sak ih takaw hoi na tit tangsuek ih cang to paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Na caanawk mah hmaloe koek daengh ih takaw to Angraeng khaeah paek o han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Angraeng mah Mosi khaeah paek ih lok na pazui o ai moe, ");
INSERT INTO cekak_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Angraeng mah Mosi patohhaih rang hoiah ang thuih ih lok to na pazui o ai nahaeloe, Angraeng mah Mosi khaeah thuih ih ni hoi kamtong angzo han koi caanawk dung khoek to, ");
INSERT INTO cekak_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","amkhueng kaminawk mah panoek ai ah, poek ai pui hoi zaehaih sah moeng nahaeloe, rangpuinawk mah Angraeng khaeah hmuihoih angbawnhaih sak hanah, a sak o zong ih atawk baktih toengah, saning kanawk maitaw caa to cang hoi nawnto paek o ueloe, zae angbawnhaih sak hanah maeh caa to paek o tih. ");
INSERT INTO cekak_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Qaima mah kaminawk boih hanah zae angbawnhaih to sah pae tih, to naah nihcae mah poek ai pui hoiah a sak o moeng ih zaehaih to tahmen pae tih; Angraeng khaeah hmai hoi angbawnhaih, poek ai pui hoi sak ih zae angbawnhaih sak hanah hmuen to sin o han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","To tiah sah o nahaeloe, Israel kaminawk hoi nihcae salakah kaom angvinnawk boih mah, poek ai pui hoi sak o moeng ih zaehaih to loihsak tih. ");
INSERT INTO cekak_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Toe kami maeto mah poek ai pui hoiah zaehaih sah moeng nahaeloe, zae angbawnhaih ah saningto kaom, maeh tala maeto a sin han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Poek ai pui hoi Sithaw hmaa ah zaehaih sah kami hanah, qaima mah zae angbawnhaih to sah pae tih; to naah anih zaehaih to loisak tih. ");
INSERT INTO cekak_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Poek ai pui hoi zaehaih sak o naah, Israel kami hoi nihcae salakah kaom angvin hanah doeh, daan maeto khue tawnh han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Toe prae thung tapen Israel kami maw, to tih ai boeh loe angvin maw, zithaih tawn ai ah zaehaih to sah nganga nahaeloe, Angraeng khingyahaih tawn ai pongah, to kami to acaeng thung hoiah pahnawt han oh. ");
INSERT INTO cekak_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Anih loe Angraeng ih lok to patoek moe, anih ih lok to aek pongah, to kami to pahnawt sut han oh; anih loe sakpazaehaih atho to hnu tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israel kaminawk praezaek ah oh o naah, Sabbath niah thing aek kami maeto a hnuk o. ");
INSERT INTO cekak_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Thing aek kami hnukungnawk mah anih to Mosi, Aaron hoi Israel kaminawk boih hmaa ah hoih o. ");
INSERT INTO cekak_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Thing aek kami to kawbang maw lokcaek han tito amtueng ai vop pongah, anih to imthung ah paung o. ");
INSERT INTO cekak_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","To naah Angraeng mah Mosi khaeah, To kami loe duek han oh; anih to ataihaih tasa bangah kaminawk boih mah thlung hoiah va o mat tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","To pongah acaeng kaminawk mah anih to ataihaih imthung hoi tasa bangah zaeh o moe, Angraeng mah Mosi khaeah paek ih lok baktih toengah, duek khoek to thlung hoiah vah o. ");
INSERT INTO cekak_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Israel kaminawk khaeah hae tiah thui paeh; angzo han koi caa nawktanawk khoek to, khukbuen atom nuiah rong kahing hoi bangh hanah, apawk to soi ah; ");
INSERT INTO cekak_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","to apawknawk to na hnuk o naah, palung thung hoiah na poek o ih baktih toengah caeh moe, mik hoiah na hnuk o ih hmuen hnukah na patom pacoengah, na caeh o pazae han ai ah, Angraeng mah thuih ih loknawk to pakuem o poe ah loe sah oh; ");
INSERT INTO cekak_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","to naah kang paek o ih loknawk to pazui boih hanah na panoek o ueloe, na Sithaw khaeah ciimcai hanah kamhoe ah na om tih. ");
INSERT INTO cekak_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Kai loe na Sithaw ah oh hanah, Izip prae thung hoi nangcae zaehoikung, na Angraeng Sithaw ah ka oh; Kai loe na Angraeng Sithaw ah ka oh tiah, a thuih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Levi acaeng Kohath capa Izhar, Izhar capa Korah loe, Reuben acaeng Paleth capa On, On capa Eliab, Eliab capa hnik Dathan hoi Abiram cae to kawk moe, ");
INSERT INTO cekak_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","amkhueng kaminawk thungah minawk mah panoek ih kami, ahmin kamthang kami, amkhuenghaih ukkung Israel kami cumvai hnet, qui pangato hoi nawnto Mosi to hmang o; ");
INSERT INTO cekak_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","nihcae loe nawnto amkhueng o moe, Mosi hoi Aaron ih lok to aek o, nihnik khaeah, Kamtlai hmoek ah tok na sak hoi; amkhueng kaminawk loe ciimcai o; Angraeng loe, kami boih nuiah oh bae, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Nihcae ih lok Mosi mah thaih naah a mikhmai long ah akuep; ");
INSERT INTO cekak_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","to pacoengah Mosi mah, Korah hoi a hnukbang kaminawk khaeah, Angraeng ih kami loe mi maw, mi maw ciimcai, angmah khaeah angzohsak han ih kami loe mi maw, tito khawnbang ah amtuengsak tih; a qoih ih kami doeh angmah taengah amtuengsak tih. ");
INSERT INTO cekak_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Nang, Korah hoi na hnukbang kaminawk boih hae hae sah oh; sabae to la o ah loe, ");
INSERT INTO cekak_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","khawnbang ah Angraeng hmaa ah, sabae thungah hmuihoih hmai thlaekhaih to sah oh; to naah Angraeng mah qoih ih kami loe ciimcai kami ah om tih; nangcae Levi kaminawk loe kamtlai hmoek ah na sak o boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mosi mah Korah khaeah, Nangcae Levi kaminawk, tahngai oh; ");
INSERT INTO cekak_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","nangcae loe Angraeng ih kahni imthung ah toksak moe, kaminawk hma ah angdoet pacoengah, nihcae ih tok to sak hanah, nangcae to Israel Sithaw mah a taengah kawk boeh, Israel kaminawk thung hoi pahoe ih hmuen loe, nangcae han tetta hmuen ah maw oh? ");
INSERT INTO cekak_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Nangmah hoi nam nawkamya Levi ih caanawk boih, angmah hoi kanghnai ah suek boeh to mah, nangcae mah qaima ah oh han ih na pakrong o vop maw? ");
INSERT INTO cekak_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","To pongah nangmah hoi na hnukbang kaminawk boih nawnto nam khueng o moe, Angraeng ih lok to na aek o; Aaron loe kawbaktih kami ah maw oh moe, na laisaep o thuih? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","To pacoengah Mosi mah Eliab capa hnik Dathan hoi Abiram to kawk; toe nihnik mah, Kang zo hoi mak ai, ");
INSERT INTO cekak_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","nang mah ni praezaek ah kaicae dueksak hanah, tahnutui hoi khoitui longhaih prae thung hoiah nang tacawt haih, to hmuen loe tetta ah maw oh moe, vaihi kaicae nuiah angraeng ah oh han na koeh vop? ");
INSERT INTO cekak_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Toe tahnutui hoi khoitui longhaih prae ah kaicae nang caeh haih ai, lawk hoi misur takhanawk doeh qawk ah nang paek ai; hae kaminawk ih mik to na taprok pae han maw? Kaihnik loe nang khaeah kang zo hoi mak ai, tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","To naah Mosi loe paroeai palungphui moe, Angraeng khaeah, nihnik mah paek ih hmuen to talawk pae hmah; nihnik khae ih laa hrang maeto doeh ka la pae ai, nihcae han nganbawh kana doeh ka paek vai ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mosi mah Korah khaeah, Aaron, nangmah hoi na hnukbang kaminawk boih, khawnbang ah Angraeng hmaa ah angphong oh; ");
INSERT INTO cekak_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","kami boih mah hmuihoih thlaekhaih sabae to sin oh, a thungah hmuihoih to suem oh; nangcae boih mah hmuihoih thlaekhaih sabae cumvai hnet, qui pangato Angraeng hmaa ah sin oh; nang hoi Aaron mah doeh hmuihoih sabae to sin hoi toeng ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","To pongah kami boih mah angmah ih hmuihoih sabae to sin o moe, hmuihoih to hmai hoiah thlaek o pacoengah, Mosi, Aaron hoi nawnto kaminawk amkhuenghaih kahni im thok taengah angdoet o boih. ");
INSERT INTO cekak_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah mah doeh Mosi hoi Aaron ohhaih ahmuen maeto bang ih kaminawk amkhuenghaih thok taengah, angmah hnukbang kaminawk to amkhuengsak toeng; to naah Angraeng lensawkhaih kaminawk boih khaeah amtueng. ");
INSERT INTO cekak_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Atue setta thungah hae kaminawk hae ka hum boih han boeh pongah, hae kaminawk salak hoiah amhoe hoi ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Toe Mosi hoi Aaron loe long ah akuep hoi moe, Aw Sithaw, kaminawk boih ih pakhra ukkung Sithaw, kami maeto zaehaih pongah, acaeng kaminawk boih nuiah palung na phui han maw? tiah a naa hoi. ");
INSERT INTO cekak_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","To naah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Korah, Dathan hoi Abiram ih kahni im hoi kamhoe ah oh hanah kaminawk to lokthui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mosi loe angthawk moe, Israel kami kacoehtanawk hoi nawnto Dathan hoi Abiram khaeah caeh. ");
INSERT INTO cekak_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kaminawk khaeah, Hae ah kaom kasae kaminawk ih kahni im hoi kamhoe ah om oh; nihcae ih hmuen tita doeh sui o hmah; to tih ai nahaeloe nangcae doeh nihcae zaehaih pongah nam ro o moeng tih, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Kaminawk loe Korah, Dathan hoi Abiram cae ih kahni imthung hoiah tacawt o boih boeh pongah, Korah, Dathan hoi Abiram loe a zunawk, a capanawk, a caa nawktanawk hoi nawnto angmacae ohhaih im thok taengah angdoet o. ");
INSERT INTO cekak_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","To naah Mosi mah, Hae ah kaom hmuennawk loe kaimah koeh ah sak ih na ai ni; Angraeng mah sak han ang patoeh pongah ni ka sak. ");
INSERT INTO cekak_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kaminawk boih mah tong ih duekhaih hoi thuitaekhaih to hae kaminawk mah tong o nahaeloe, Angraeng mah kai hae patoeh ai, tito panoek oh. ");
INSERT INTO cekak_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Toe Angraeng mah hmuen kangtha to sah moe, long to akah rak pacoengah, hae kaminawk hoi nihcae ih ampuinawk to paaeh moe, kahing ah tangqom thungah caeh o nahaeloe, hae kaminawk mah Angraeng to khet patoek o, tito na panoek o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","To loknawk a thuih boih pacoengah, Nihcae ohhaih im tlim ih long to akah rak, ");
INSERT INTO cekak_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","long loe pakha aangh moe, to kaminawk hoi nihcae ih imnawk, Korah ih imthung takoh boih, a tawnh ih hmuenmaenawk boih to paaeh. ");
INSERT INTO cekak_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","To kaminawk, nihcae hoi angkom kaminawk loe, kahing ah long thungah caeh o tathuk; long mah nihcae to pakuep hmoek; to tiah nihcae loe acaeng kaminawk thung hoiah anghmat angtaa o. ");
INSERT INTO cekak_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Nihcae hanghaih lok to thaih o naah, aicae doeh long mah paaeh toeng tih boeh, tiah a poek o pongah, a taengah kaom Israel kaminawk loe cawnh o boih. ");
INSERT INTO cekak_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","To naah Angraeng khae hoi hmai to angzoh moe, hmuihoih thlaek kami cumvai hnet, qui pangatonawk to hmai mah kangh boih. ");
INSERT INTO cekak_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Aaron capa qaima Eleazar khaeah hmai kangqong hmuihoih thlaekhaih sabae to la ah loe, kangqong hmai to ataek ah; to hmuihoihnawk loe kaciim hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Angmacae hinghaih paduek hanah zaehaih sah kaminawk ih hmuihoih thlaekhaih sabae hoiah hmaicam to khuk hanah sum kangphaek daek to sah ah; to sabaenawk loe Angraeng khaeah paek ih hmuen ah oh pongah ciim; to hmuen loe Israel kaminawk tanoekhaih ah om tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","To pongah qaima Eleazar mah hmuihoih thlaekhaih sabaenawk to lak moe, hmaicam to khuk hanah sum kamling to kangphaek daek ah daengsak. ");
INSERT INTO cekak_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Aaron ih caanawk na ai ah, kalah kami mah Angraeng hmaa ah hmuihoih thlaek hanah angzo nahaeloe, Korah hoi anih hnukbang kaminawk baktiah oh han om ai; to sabaenawk loe Israel kaminawk mah panoek poe han ih hmuen ah om tih, tiah Angraeng mah Mosi khaeah pae thuih ih lok baktih toengah Eleazar mah sak. ");
INSERT INTO cekak_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Khawnbang ah loe amkhueng Israel acaeng kaminawk boih mah, Mosi hoi Aaron khaeah, Nanghnik mah Angraeng ih kaminawk to na hum hoi boih boeh, tiah laisaep o thuih. ");
INSERT INTO cekak_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Mosi hoi Aaron ih lok to aek hanah kaminawk nawnto amkhueng o, amkhuenghaih kahni im bangah angqoi o naah, khenah, tamai mah kahni im to khuk khoep moe, Angraeng lensawkhaih to amtueng. ");
INSERT INTO cekak_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","To pacoengah Mosi hoi Aaron loe amkhuenghaih kahni im hma bangah caeh hoi. ");
INSERT INTO cekak_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","To naah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","akra ai ah hae kaminawk hae ka tamit boih han boeh pongah, hae kaminawk salak hoiah kamhoe ah om ah, tiah a naa. To naah nihnik loe long ah akuep hoi. ");
INSERT INTO cekak_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mosi mah Aaron khaeah, Hmuihoih thlaekhaih sabae to la ah, hmaicam nui ih hmai to la ah loe, sabae thungah suek pacoengah, kaminawk khaeah karangah caeh ah loe, zae angbawnhaih to sahsak ah; Angraeng khae hoi palungphuihaih phak boeh pongah, nathaih kasae to phak boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Mosi mah thuih ih lok baktih toengah, Aaron loe kaminawk salakah cawnh moe, a sak; khenah, to naah kaminawk khaeah nathaih kasae oh amtong boeh; toe Aaron mah hmuihoih to thlaek moe, kaminawk han angbawnhaih to sak pae. ");
INSERT INTO cekak_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Anih loe kahing hoi kadueh salakah angdoet; to naah kasae nathaih to dip. ");
INSERT INTO cekak_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Toe Korah pongah kadueh kaminawk to thui ai, to nathaih kasae pongah kadueh kaminawk loe sangqum boihah sang hatlai pali, qui sarihto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Kasae nathaih dip pacoengah, Aaron loe Mosi khaeah amkhuenghaih kahni im thok taengah amlaem let. ");
INSERT INTO cekak_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Israel kaminawk khaeah hae hae thui paeh; ampanawk ih acaeng zaehoikungnawk khae hoi acaeng maeto naah cunghet maeto, acaeng hatlai hnetto khae hoiah cunghet hatlai hnetto la ah loe, cunghet pongah kami ih ahmin to tarik boih ah. ");
INSERT INTO cekak_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Levi ih cunghet pongah Aaron ih ahmin to tarik ah; acaeng zaehoikung maeto mah cunghet maeto tawnh boih han oh. ");
INSERT INTO cekak_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","To cunghetnawk to lok kang thuihaih ahmuen, kaminawk amkhuenghaih kahni imthung ih hnukung hmaa ah suem ah. ");
INSERT INTO cekak_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ka qoih kami ih cunghet loe tadok tacawt tih; to pacoengah loe Israel kaminawk mah na nuiah laisaephaih to ka dipsak han boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","To pongah Mosi mah Israel kaminawk khaeah lokthuih pae, zaehoikungnawk boih mah anih han cunghet maeto paek o boih, acaeng zaehoikung maeto mah, cunghet maeto sin o, sangqum boih ah cunghet hatlai hnetto oh; Aaron ih cunghet doeh to ih cunghetnawk thungah athum toeng. ");
INSERT INTO cekak_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mosi mah to ih cunghetnawk to hnukung kahni imthung ih Angraeng hmaa ah suek. ");
INSERT INTO cekak_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Khawnbang ah Mosi hnukung kahni imthung ah akun naah, khenah, Levi imthung takoh ah kaom Aaron ih cunghet loe tadok tacawt, aqam tacawt tahang moe, apawk pawk pacoengah, almond thaih to athaih. ");
INSERT INTO cekak_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","To naah Mosi mah Angraeng hmaa ih cunghet to Israel kaminawk hma sinh pae boih; nihcae mah khet o moe, angmacae ih cunghet to lak o boih. ");
INSERT INTO cekak_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Angraeng mah Mosi khaeah, Aaron ih cunghet to hnukung hmaa ah sin ah loe, to ah suem let ah, to cunghet loe lok tahngai ai kaminawk acoe paekhaih angmathaih ah om tih; to naah ni nihcae mah ka nuiah laisaep o haih to na boengsak tih, to tih ai nahaeloe nihcae loe dueh o moeng tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Angraeng mah thuih ih lok baktih toengah, Mosi mah sak boih. ");
INSERT INTO cekak_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israel kaminawk mah Mosi khaeah, Khenah, aicae loe a duek o tangtang boeh; aicae loe anghmat boeh, aicae loe anghmat o boih boeh! ");
INSERT INTO cekak_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mi kawbaktih doeh Angraeng ih kahni im ah angzo kami loe dueh tih; aicae loe a dueh o boih tih boeh maw? tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Angraeng mah Aaron khaeah, Hmuenciim ah sak ih na zae haih pongah loe, nangmah hoi na caanawk, nam pa ih imthung takohnawk mah na zok o tih; qaima toksakhaih pongah zaehaih na sak nahaeloe, nangmah hoi na caanawk mah zok o tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Nam pa acaeng, Levi acaengnawk thung ih nam nawkamyanawk to nangcae hoi nawnto toksak han kawk ah; toe nangmah hoi na caanawk loe hnukung kahni imthung ah tok na sah o tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Levi caanawk loe angmacae ih tok hoi kahni imthung ah sak han koi toknawk boih to sah o tih; toe hmaicam hoi hmuenciim ih laom sabaenawk taengah caeh o mak ai; caeh o nahaeloe, nihcae doeh, nangcae doeh na dueh o boih tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Nihcae loe nangcae hoi nawnto toksah o ueloe, kaminawk amkhuenghaih kahni im to khenzawn o tih; kahni imthung ah sak han koi toknawk boih to sah o tih; asaeng ai kalah kami loe na taengah anghnaih o han om ai. ");
INSERT INTO cekak_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Israel kaminawk nuiah palungphuihaih phak let han ai ah, nangcae loe hmuenciim hoi hmaicam to khenzawn oh. ");
INSERT INTO cekak_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Khenah, Israel kaminawk salak hoiah nam nawkamya Levi kaminawk to ka qoih boeh, amkhuenghaih kahni im ah tok a sak o hanah, Angraeng khaeah paek ih angbawnhaih hmuen baktih toengah nangcae hanah paek boeh. ");
INSERT INTO cekak_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","To pongah nangmah hoi na caanawk loe, hmaicam hoi kahni payanghaih thungah kaom, qaima ih toknawk boih to sah oh; nangcae khaeah qaima toksakhaih to tangqum ah kang paek boeh; kasaeng ai nang khaeah angzo kami loe paduek han oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","To pacoengah Angraeng mah Aaron khaeah, Khenah, Israel kaminawk mah kaciim ah kai khaeah paek o ih hmuennawk to nang han kang paek boih boeh; nangmah hoi na caanawk mah dungzan ah toep hanah taham ah kang paek boeh. ");
INSERT INTO cekak_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Hmai thungah pha ai, nihcae mah kai khaeah kaciim koek ah paek o ih hmuennawk boih, cang paekhaih, zae loisak han paek ih hmuennawk boih, sakpazaehaih loisak han paek ih hmuennawk boih loe, nangmah hoi na caanawk hanah kaciim koek ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","To hmuennawk to kaciim koek ahmuen ah caa ah; nangcae han ciimcai hmuen ah oh pongah, nongpa boih mah caak thaih. ");
INSERT INTO cekak_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","To pacoengah Israel kaminawk mah paek ih hmuennawk hoi tangqum ah paek ih hmuennawk boih to, nangmah hoi na capa hoi na canunawk mah dungzan ah toep hanah atawk baktiah paek ih, nangcae ih qawk ah om tih; na imthung takoh ah kaom kaciim kaminawk mah to hmuennawk to caa o tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Nihcae mah Angraeng khaeah paek ih kathai tangsuek thingthai, kahoih koek situinawk, kahoih koek misurtuinawk hoi cang to, nangcae han kang paek boeh. ");
INSERT INTO cekak_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Nihcae mah Angraeng khaeah sin o ih, lawk thungah kathai tangsuek hmuennawk boih loe, nangcae ih hmuen ah om tih; na imthung takoh ah kaom ciimcai kaminawk mah to hmuennawk to caa o tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Israel kaminawk mah angbawnhaih sak hanah Angraeng khaeah paek o ih hmuennawk boih loe nangcae ih hmuen ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tapen tangsuek capa maw, to tih ai boeh loe kami maw, to tih ai boeh loe pacah ih moi maw, Angraeng khaeah paek ih hmuennawk boih loe nangcae taham ah om tih; toe na calu hoi ciimcai ai tapen tangsuek moinawk loe nangmacae mah akrang oh. ");
INSERT INTO cekak_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Akrang han koi caanawk loe khrah to akoep naah, akrang han atho khaeh ih baktih, hmuenciim ih shekel tahhaih baktih toengah, gerah pumphaeto hoi kangvan shekel pangato hoiah akrang oh. ");
INSERT INTO cekak_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Toe tapen tangsuek maitaw tae maw, to tih ai boeh loe tapen tangsuek tuu tae maw, to tih ai boeh loe tapen tangsuek maeh tae loe na krang o mak ai; to moinawk loe ciim o pongah, nihcae ih athii to hmaicam ah haeh ah, athawknawk loe Angraeng khaeah hmuihoih ah paek hanah, hmai hoi angbawnhaih to sah oh. ");
INSERT INTO cekak_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Angan, saoek hoi bantang bang ih palaeng loe nangcae taham ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Israel kaminawk mah Angraeng khaeah paek ih kaciim hmuennawk boih loe, nangmah hoi na capanawk hoi na canunawk mah dungzan ah toep hanah, atawk baktiah kang paek boeh; hae loe nangmah hoi na caanawk han Angraeng hmaa ah paloi hoiah sak ih dungzan lokmaihaih ah om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Angraeng mah Aaron khaeah, Nang loe nihcae ih prae thungah, qawktoep han ih ahmuen, nihcae salakah na tawnh ih hmuen tidoeh om mak ai; kai loe Israel kaminawk salakah, nangcae taham ah ka oh moe, nangcae mah toep han koi qawk ah ka oh. ");
INSERT INTO cekak_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Khenah, Levi kaminawk loe kaminawk amkhuenghaih kahni imthung ah toksak o pongah, nihcae mah qawktoep hanah Israel kaminawk ih hmuen hato thungah maeto ka paek boeh. ");
INSERT INTO cekak_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Vaihi hoi kamtong Israel kaminawk loe amkhuenghaih kahni im taengah anghnai o mak ai boeh; anghnai o nahaeloe angmacae zaehaih atho to zok o ueloe, dueh o moeng tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Levi kaminawk khue mah ni amkhuenghaih kahni imthung ih tok to sah o tih, nihcae mah kamsoem ai hmuen to sah o nahaeloe, angmacae zaehaih atho to zok o tih; hae loe angzo han koi na caanawk khoek to dungzan ah pazui hanah paek ih daan lok ah oh; nihcae loe Israel kaminawk salakah toep han koi qawk tawn o mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Toe Israel kaminawk mah Angraeng khaeah paek o ih hato thungah maeto loe, Levinawk mah qawk ah toep o hanah ka paek boeh; to pongah ni nihcae khaeah, Israel kaminawk salakah qawktoep han tawn o mak ai, tiah ka thuih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Levi kaminawk khaeah, Nangcae mah qawktoep han kang paek o ih Israel kaminawk khae ih hato thungah maeto na lak o naah, nangcae mah doeh hato thungah maeto Angraeng khaeah paek o patoeng hanah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Nangcae mah hae tiah na paek o ih hmuennawk loe, cang atithaih ahmuen hoiah paek ih cang, misurtui pasawhhaih ahmuen hoiah paek ih misurtui baktiah poek pae tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Nangcae mah doeh Israel kaminawk khae hoi na hak o ih hato thungah maeto to, Angraeng khaeah paek o toeng ah; to tiah Angraeng khaeah paek ih hmuen to qaima Aaron hanah paek oh. ");
INSERT INTO cekak_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Nangcae khaeah paek ih hmuennawk boih thungah, kahoih koek hoi kaciim koek hmuen to Angraeng han paek oh. ");
INSERT INTO cekak_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","To pongah Levi kaminawk khaeah, Nangcae mah kahoih koek hmuen na paek o naah, na paek o ih hmuen to cang atithaih ahmuen, misurtui pasawhaih ahmuen hoi paek ih hmuen baktiah poek pae tih, tiah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Kamtlai to loe nangmah hoi na imthung takoh boih mah kawbaktih ahmuen ah doeh na caak o thaih; to hmuen loe kaminawk amkhuenghaih kahni im ah toksakhaih atho ah paek ih tangqum ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kahoih koek hmuen na paek o pacoengah, kamtlai na caak o ih hmuen nuiah zaehaih om ai; Israel kaminawk mah paek ih kaciim hmuennawk to amhnong o sak hmah, to tih ai nahaeloe na dueh o moeng tih, tiah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Angraeng mah thuih ih atawk lok loe, Coek koi kaom ai, rong angdaek ai, vaito doeh laikok atokhaih thing tahnong ah koeng vai ai, kathim maitaw tala to nang khaeah sin o hanah, Israel kaminawk khaeah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","To maitaw tala to qaima Eleazar khaeah paek oh, anih mah ohhaih im tasa bangah hoi ueloe, kami maeto mah anih hmaa ah bop tih. ");
INSERT INTO cekak_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Qaima Eleazar mah maitaw tala athii to a banpazung tadong hoiah lak pacoengah, amkhuenghaih kahni im hmaa ah vai sarihto haeh tih. ");
INSERT INTO cekak_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kami maeto mah anih hmaa ah maitaw tala to hmai hoiah qoeng tih; ahin, angan, athii hoi aeknawk to hmai hoiah qoeng boih tih. ");
INSERT INTO cekak_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Qaima mah sidar thing, hmuihoih husop kung tadok hoi thlangqui kathim to la ueloe, hmai hoi qoeng ih maitaw tala nuiah va tih. ");
INSERT INTO cekak_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","To pacoengah qaima mah a khukbuen to pasuk ueloe, tui doeh amhluh tih; to pacoengah ni a ohhaih im ah caeh vop tih; toe qaima loe duembang khoek to ciim mak ai vop. ");
INSERT INTO cekak_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Hmai qoeng kami doeh a khukbuen to pasuk pacoengah, tui amhluk han oh; anih doeh duembang khoek to ciim mak ai vop. ");
INSERT INTO cekak_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Kaciim kami mah hmai hoi thlaek ih maitaw tala apoep to phrom ueloe, atai o haih tasa bang ih hmuenciim maeto ah suem tih; to maiphu loe ciimcai ah amsaehhaih tui ah patoh han oh pongah, Israel acaengnawk mah pakuem o tih; to hmuen loe zae ciimhaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Maitaw tala ih maiphu phrom kami loe a khukbuen to pasuk han oh, anih loe duembang khoek to ciim mak ai; hae loe Israel kaminawk hoi nihcae salakah kaom angvin hanah dungzan ah paek ih zaehhoihhaih daan lok ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Kadueh qok sui kami loe, ni sarihto thung ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ni thumto naah to ih maiphu hoiah a takpum to amsae tih, anih loe ni sarihto naah ni ciim vop tih; toe anih mah ni thumto naah a takpum to kaciim ah amsae ai nahaeloe, ni sarihto khoek to ciim mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Kadueh qok to sui to mah a takpum tui hoiah amsae ai kami loe, Angraeng ih kahni im to amhnongsak; to kami loe Israel kaminawk thung hoiah pahnawt han oh; kaciim ah amsaehhaih tui to a nuiah pathaek ai pongah, anih loe ciim ai; anih nuiah amhnonghaih to oh. ");
INSERT INTO cekak_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","A ohhaih im ah kami dueh nahaeloe, sakhaih daan loe hae tiah oh; to kami ohhaih im ah akun kaminawk hoi imthung ah kaom kaminawk boih loe, ni sarihto thung ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Kraeng ai ah kam-ong sut laom sabaenawk boih doeh ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Sumsen hoi hum ih kami qok maw, to tih ai boeh loe kadueh qok maw, to tih ai boeh loe kami huh maw, to tih ai boeh loe taprong maw sui kami loe, ni sarihto thung ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Kaciim ai kami ciimsak hanah hmai hoi thlaek ih maitaw tala ih apoep maiphu to la ah loe, kalong tui to laom thungah lawn pacoengah, ");
INSERT INTO cekak_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","kaciim kami mah hmuihoih husop kung tadok to tui thungah nup ueloe, a ohhaih im maw, laom sabaenawk maw, im ah kaom kaminawk nuiah maw, kami huh sui kami nuiah maw, to tih ai boeh loe hum ih kami maw, to tih ai boeh loe kadueh kami maw, to tih ai boeh loe taprong sui kami nuiah maw pathaek tih. ");
INSERT INTO cekak_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Kaciim kami mah kaciim ai kami to ni thumto hoi ni sarihto niah pathaek tih; ni sarihto naah a takpum to ciimsak ueloe, a khukbuen to pasuk pacoengah, tui amhlu tih; duembang ah loe anih to ciim tih boeh. ");
INSERT INTO cekak_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Toe ciim ai kami mah a takpum to ciimsak ai nahaeloe, Angraeng ih hmuenciim to amhnongsak pongah, anih to amkhueng kaminawk salak hoi pahnawt han oh; kaciim ah pasaehhaih tui to anih nuiah pathaek ai pongah, anih loe ciim ai. ");
INSERT INTO cekak_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hae loe nihcae han dungzan ah paek ih zaehhoihhaih daan lok ah oh; kaciim tui pathaek kami doeh a khukbuen to pasuk han angaih; to tui sui kami doeh duembang khoek to ciim mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kaciim ai kami mah sui ih hmuennawk boih loe, ciim mak ai; to hmuen sui kami doeh duembang khoek to ciim mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Israel rangpuinawk Zin praezaek phakhaih khrah to naah, Kadesh ahmuen ah oh o; Miriam loe to ahmuen ah duek moe, aphum o. ");
INSERT INTO cekak_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","To ahmuen ah kaminawk naek hanah tui om ai pongah, kaminawk mah Mosi hoi Aaron to zoeh hanah amkhueng o. ");
INSERT INTO cekak_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kam nawkamyanawk Angraeng hmaa ah duek o naah, kaicae doeh ka duek o nahaeloe hoih han tomah! ");
INSERT INTO cekak_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Tih hanah kaicae hoi ka pacah o ih moinawk dueksak hanah, Angraeng ih kaminawk hae praezaek ah na caeh hoi haih loe? ");
INSERT INTO cekak_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Tih hanah Izip prae thung hoiah nang tacawthaih moe, lawksak han kahoih ai, thaiduet thaih kaom ai, misurkung kaom ai, pomogranat thai doeh kaom ai, naek han tui doeh kaom ai, hae ahmuen kasae ah nang caeh haih loe? tiah kasae pakung o moe, a zoeh o. ");
INSERT INTO cekak_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mosi hoi Aaron loe amkhueng kaminawk hmaa hoiah angthawk hoi moe, kahni im thok taengah a caeh hoi pacoengah, long ah akuep hoi; to ah Angraeng lensawkhaih to nihnik khaeah amtueng pae. ");
INSERT INTO cekak_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","cunghet to la ah loe nam nawk Aaron hoi nawnto kaminawk to amkhuengsak ah; nihcae hmaa ah kaom lungsong khaeah lok to thui ah; lungsong thung hoiah tui to tacawt tih, lungsong thung hoi tacawt tui to kaminawk khaeah sin paeh loe, kaminawk hoi moinawk to naesak ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Angraeng mah thuih ih lok baktih toengah, Mosi mah Angraeng hmaa ih cunghet to lak. ");
INSERT INTO cekak_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mosi hoi Aaron mah kaminawk to lungsong hmaa ah nawnto amkhuengsak; Mosi mah nihcae khaeah, Nangcae lok aek karah kaminawk, vaihi tahngai oh; hae lungsong thung hoiah nangcae han tui kang tacawt hoi sak han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","To naah Mosi mah ban payangh moe, a cunghet hoiah lungsong to vai hnetto boh; to naah pop parai tui to tacawt, kaminawk hoi a tawnh o ih moinawk mah tui to naek o. ");
INSERT INTO cekak_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Toe Angraeng mah Mosi hoi Aaron khaeah, Nanghnik loe, Israel kaminawk hmaa ah Ka ciimcaihaih amtuengsak hanah kai nang tang hoi ai pongah, nihcae khaeah ka paek ih prae thungah hae kaminawk hae na caeh hoi haih thai mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Israel kaminawk mah to ahmuen ah Angraeng ih lok aek o cadoeh, Angraeng mah nihcae khaeah a ciimcaihaih amtuengsak pongah, to ih tui to Meribah, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mosi mah Kadesh ahmuen hoiah Edom siangpahrang khaeah laicaehnawk to patoeh moe, Nam nawk Israel mah, Kaicae nuiah angzo raihaihnawk to na panoek boih boeh. ");
INSERT INTO cekak_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Kaicae ampanawk loe Izip prae ah caeh o tathuk moe, to ah saning sawk parai ah khosak o; Izip kaminawk mah kaicae hoi kaicae ampanawk to pacaekthlaek o; ");
INSERT INTO cekak_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Toe Angraeng khaeah ka qah o naah, anih mah kaicae qahhaih lok to tahngaih pae, angmah ih van kami to patoeh moe, Izip prae thung hoiah loisak; khenah, kaicae loe vaihi nangcae ramri taeng, Kadesh ahmuen ah ka oh o. ");
INSERT INTO cekak_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Kaicae hae na prae thung hoiah na caehsak raeh; nangcae ih lawk ah maw, to tih ai boeh loe misur takha thungah maw ka caeh o mak ai; na tuipuek tui doeh ka nae o mak ai; Siangpahrang ih Manglaih Lampui hoiah ni ka caeh o han; na prae ka poeng o ai karoek to, banqoi bantang kam khraeng o mak ai, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Toe Edom mah anih khaeah, Hae ahmuen hoiah angzo o hmah; nang zoh o nahaeloe, sumsen hoiah kang takroek o han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israel kaminawk mah anih khaeah, Lampui hoiah ni ka caeh o han; kaicae mah maw, ka tawnh o ih moi mah maw, na tui to nae moeng nahaeloe, atho kang rong o han hmang; tidoeh ka sah o mak ai, khok hoi khue ni ka caeh o han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Toe nihcae mah, Hae ahmuen hoiah na caeh o mak ai, tiah a naa o let bae. Edom loe nihcae tuk hanah thacak pop parai kaminawk hoiah angzoh o. ");
INSERT INTO cekak_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edom mah Israel caehhaih loklam to pahoe pae ai pongah, Isarael kaminawk loe amlaem o let. ");
INSERT INTO cekak_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Israel kaminawk loe Kadesh ahmuen hoiah angqoi o boih moe, Hor mae ah caeh o. ");
INSERT INTO cekak_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Edom prae ramri, Hor mae ah Angraeng mah Mosi hoi Aaron khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron loe angmah ih kaminawk khaeah la tih boeh; Meribah ahmuen ih tui kawng pongah ka thuih ih lok to nang aek hoi pongah, Aaron loe Israel kaminawk khaeah ka paek ih prae thungah akun mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaron hoi a capa Eleazar to kawk ah loe, Hor mae ah caeh haih ah; ");
INSERT INTO cekak_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aaron ih khukbuennawk to khring paeh loe, a capa Eleazar to angkhuksak ah; Aaron loe angmah ih kaminawk khaeah la ueloe, to ah dueh tih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Angraeng mah thuih ih lok baktih toengah, Mosi mah sak; nihcae loe rangpui kaminawk mikhnuk ah Hor mae ah dawh o. ");
INSERT INTO cekak_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mosi mah Aaron ih khukbuennawk to khring pae moe, a capa Eleazar to angkhuksak; Aaron loe mae nuiah duek; to pacoengah Mosi hoi Eleazar loe mae nui hoiah anghum hoi tathuk. ");
INSERT INTO cekak_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aaron duek boeh, tito kaminawk mah panoek o naah, Israel imthung takoh boih mah Aaron hanah ni qui thumto thung palungset o haih. ");
INSERT INTO cekak_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Prae aloih bang kaom, Kanaan siangpahrang Arad mah, Israel kaminawk loe Atharim loklam bang hoiah angzo o tih, tiah a thaih naah, Israel kaminawk to a tuk moe, thoemto Israel kaminawk to a naeh. ");
INSERT INTO cekak_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","To naah Israel mah Angraeng khaeah, Hae kaminawk hae ka ban ah nang paek nahaeloe, nihcae ih vangpuinawk to ka phraek pae boih han, tiah lokkamhaih sak. ");
INSERT INTO cekak_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","To naah Israel lawkthuihaih to Angraeng mah tahngaih pae moe, Kanaan kaminawk to nihcae ban ah a paek; nihcae hoi nihcae ih vangpuinawk to Israel kaminawk mah phraek pae o boih; to pongah to ahmuen to Hormah, tiah kawk o. ");
INSERT INTO cekak_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hor mae hoi tacawt o moe, tuipui kathim bangah caehhaih loklam hoiah, Edom prae takui hanah a caeh o naah, loklam to set pongah kaminawk palungboeng o. ");
INSERT INTO cekak_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","To naah kaminawk mah Sithaw hoi Mosi khaeah, Tipongah kaicae praezaek ah dueksak hanah Izip prae hoiah nang tacawt haih loe? Caak han takaw doeh om ai, tui doeh om ai; kakhraem ai hae takaw doeh ka panuet o boeh, tiah laisaep o thuih. ");
INSERT INTO cekak_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","To naah Angraeng mah kasoetui thacak pahuinawk to kaminawk khaeah patoeh, pahui mah kaminawk to patuk pongah, Israel kaminawk loe paroeai duek o. ");
INSERT INTO cekak_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","To pongah kaminawk loe Mosi khaeah angzoh o moe, Angraeng hoi nang kang laisaep o thuih pongah ka zae o boeh; Angraeng mah pahuinawk hae kaicae khae hoiah lak let hanah, lawk na thui paeh, tiah a naa o. To pongah Mosi mah kaminawk hanah lawkthuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Angraeng mah Mosi khaeah, Kasoetui thacak pahui maeto sah ah loe, cungkui tadong ah bang ah; pahui mah patuk ih kami boih mah, pahui to khet naah, hing o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","To pongah Mosi mah sum kamling hoiah pahui to sak moe, cungkui pongah a bangh; pahui mah patuk ih kami mah, sum kamling hoiah sak ih pahui to khet naah a hing. ");
INSERT INTO cekak_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israel kaminawk loe hmabang caeh o poe moe, Oboth ah anghak o. ");
INSERT INTO cekak_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Oboth hoi amsak o let moe, ni angyae bang ih Moab pha ai naah kaom, Iye-Abarim ahmuen ah atai o. ");
INSERT INTO cekak_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","To ahmuen hoiah amsak o let bae moe, Zered azawn ah anghak o. ");
INSERT INTO cekak_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","To ahmuen hoiah amsak o moe, Amor kaminawk ohhaih prae taeng ih praezaek ah kaom, Arnon vapui taeng ih ahmuen maeto bangah anghak o; Arnon vapui loe Moab hoi Amor prae salakah oh. ");
INSERT INTO cekak_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","To pongah, Tuipui kathim hoi Arnon vacongnawk ah a sak ih hmuen kawng loe Angraeng ih misatukhaih cabu thungah oh, ");
INSERT INTO cekak_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Ar prae ah longh tathuk moe, Moab prae ramri taengah kaom vacong tui ah oh, tiah thuih ih lok to oh. ");
INSERT INTO cekak_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Arnon vapui hoi Beer tuipuek ah caeh o moe, to ih tuipuek ahmuen ah Angraeng mah Mosi khaeah, Kaminawk to nawnto amkhuengsak ah, nihcae to tui ka paek han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","To naah Israel kaminawk mah hae laa hae sak o; Aw tuipuek nang, tacawt tahang ah; tacawt tahang hanah laa to sah o boih ah; ");
INSERT INTO cekak_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ukhaih kaalok sahkung mah thuih ih lok baktih toengah, Angraeng ih caanawk mah tuipuek to takaeh o moe, kami zaehoikungnawk mah doeh angmacae ih cunghet hoiah tuipuek to takaeh o boeh, tiah laa to sak o. To praezaek ahmuen hoiah Mattanah ah a caeh o; ");
INSERT INTO cekak_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattanah ahmuen hoiah Nahaliel ah, Nahaliel hoiah Bamoth ah, ");
INSERT INTO cekak_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamoth hoiah Moab prae thung ih azawn ah caeh o moe, Jeshimon vangpui danhaih Pisgah maesom nuiah a caeh o. ");
INSERT INTO cekak_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel kaminawk mah Amor siangpahrang Sihon khaeah laicaehnawk to patoeh moe, ");
INSERT INTO cekak_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","na prae thung hoiah na caehsak raeh; na lawk thungah maw, to tih ai boeh loe na misur takha thungah maw, ka caeh o mak ai; na tuipuek thung ih tui doeh ka nae o mak ai; na prae ka poeng o ai karoek to, Siangpahrang ih Manglaih Lampui hoiah ni ka caeh o han, tiah thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Toe Sihon mah Israel kaminawk to a prae thung hoiah caehsak ai; anih mah angmah ih misatuh kaminawk to kok boih moe, Israel kaminawk tuk hanah praezaek ah a caeh; Jahaz ahmuen ah caeh moe, Israel kaminawk to a tuk. ");
INSERT INTO cekak_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Toe Israel kaminawk mah anih to sumsen hoiah takroek o moe, anih ih prae to Arnon hoi Jabbok karoek to, Ammon kaminawk ohhaih ahmuen karoek to lak pae o; Ammon kaminawk ih ramri loe kacak ah pakaa o. ");
INSERT INTO cekak_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel kaminawk mah Amor kaminawk ih vangpuinawk to lak o boih moe, Heshbon hoi a taengah kaom avangnawk doeh a lak pae o boih. ");
INSERT INTO cekak_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon loe Armor kaminawk ih siangpahrang, Sihon ohhaih vangpui ah oh; anih mah hmaloe ah kaom Moab siangpahrang to tuk moe, anih khae hoiah a prae to Arnon vapui khoek to a lak pae. ");
INSERT INTO cekak_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","To pongah palungha lokthui kaminawk mah, Heshbon vangpui ah angzo oh, Sihon ih vangpui hae sah o si; ");
INSERT INTO cekak_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Sihon siangpahrang ohhaih, Heshbon hoiah hmai to tacawt moe, Moab prae thungah kaom Ar vangpui hoi Arnon vapui taengah kaom, maesang ukkung siangpahrangnawk to kangh boih boeh. ");
INSERT INTO cekak_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Aw Moab prae, khosak na bingh! Aw Khemosh kaminawk, nam ro o boih boeh! Kacawn a capa to misa mah naeh boeh moe, a canunawk to Amor kaminawk ih siangpahrang Sihon khaeah misong ah caehsak boeh. ");
INSERT INTO cekak_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Kaicae mah Amor kaminawk to ka tuk o pongah, Heshbon prae loe Dibon vangpui khoek to amro boih boeh; Medeba taengah kaom, Nophah vangpui khoek to nihcae to kam ro o sak boih boeh, tiah a thuih o. ");
INSERT INTO cekak_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","To pongah Israel kaminawk loe Amor kaminawk ih prae thungah khosak o. ");
INSERT INTO cekak_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mosi mah Jaazer vangpui to khet hanah kaminawk to patoeh moe, a taengah kaom vangtanawk to a lak o, to ah kaom Amor kaminawk doeh a haek o. ");
INSERT INTO cekak_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","To pacoengah nihcae loe amlaem o moe, Bashan bang caehhaih loklam bangah caeh o tahang; to naah Bashan siangpahrang Og mah, angmah ih misatuh kaminawk boih hoiah Edrei ahmuen ah nihcae to tuk hanah a caeh o. ");
INSERT INTO cekak_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","To naah Angraeng mah Mosi khaeah, Anih to zii hmah; anih doeh, anih ih misatuh kaminawk boih hoi anih ih prae doeh, na ban ah kang paek boeh; to pongah Heshbon ah kaom, Amor kaminawk ih siangpahrang Sihon nuiah na sak ih hmuen baktih toengah, anih nuiah doeh sah ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","To pongah anih to, a capanawk hoi a misatuh kaminawk boih hoiah nawnto, maeto doeh kahing ah loisak ai ah a hum bit; to pacoengah anih ih prae to lak pae o. ");
INSERT INTO cekak_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","To pacoengah Israel kaminawk loe Moab azawn ah caeh o moe, Moab prae azawn, Jordan vapui taeng, Jeriko vangpui maeto bangah atai o. ");
INSERT INTO cekak_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Israel kaminawk mah Amor kami nuiah sak o ih hmuen to, Zippor capa Balak mah hnuk boih. ");
INSERT INTO cekak_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Israel kaminawk loe pop o parai pongah, Moab kaminawk mah nihcae to paroeai zit o. ");
INSERT INTO cekak_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab kaminawk mah Midian kacoehtanawk khaeah, Maitaw tae mah palai hoiah taw ih qam takoih boih baktih toengah, haeah amkhueng kaminawk mah aicae taengah kaom hmuennawk to caa o boih tih boeh, tiah a naa o. To nathuem ah Zippor capa Balak to Moab siangpahrang ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ammon prae thungah kalong vapui taengah kaom, Pethor vangpui ih kami, Beor capa Baalam to kawk hanah laicaehnawk to patoeh. Balak mah, Izip prae hoi angzo acaeng maeto loe, prae koimongah ka taengah atai o boeh. ");
INSERT INTO cekak_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","To pongah vaihi angzo ah, hae kaminawk loe kai pongah thacak o, to pongah kai hanah nihcae to tangoeng paeh; to tiah na sak nahaeloe nihcae ka tuk naah, prae thung hoiah ka haek thai khoe doeh om tih; nang mah tahamhoihaih na paek ih kaminawk loe tahamhoihaih a hnuk o moe, na tangoeng ih kaminawk loe tangoeng ah oh o, tiah ka panoek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moab hoi Midian kacoehtanawk loe tahmaa mah thuih ih lok to atho paek hanah, tangqum to sin o moe, a caeh o; Balaam khaeah a phak o naah, Balak mah thuih ih lok to anih khaeah thuih pae o. ");
INSERT INTO cekak_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam mah nihcae khaeah, Vaiduem loe haeah cam o raeh; Angraeng mah paek ih lok to kang thuih o han hmang, tiah a naa. To pongah Moab ukkung angraengnawk loe to ah Balaam hoi nawnto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Balaam khaeah Sithaw angzoh moe, Nang khaeah kaom kaminawk loe kawbaktih kaminawk maw? tiah a dueng. ");
INSERT INTO cekak_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam mah Sithaw khaeah, Zippor capa, Moab siangpahrang Balak mah hae kaminawk hae kai khaeah ang patoeh, ");
INSERT INTO cekak_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","khenah, Izip prae hoi angzo kaminawk loe, prae koimongah oh o boeh; to pongah vaihi angzo ah loe, hae kaminawk hae kai hanah tangoeng pae ah; to tih nahaeloe hae kaminawk hae ka tuh pazawk ueloe, ka haek thai khoe doeh om tih, tiah ang thuih o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Toe Sithaw mah Balaam khaeah, Nihcae hnukah caeh hmah; to kaminawk loe tahamhoih kami ah oh o pongah, tangoeng hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam loe khawnbang khawnthaw ah angthawk moe, Balak ih toksah angraengnawk khaeah, Nangmacae prae ah amlaem o lai ah, Angraeng mah nangcae hnukah na bangsak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","To pongah Moab ukkung angraengnawk loe Balak khaeah amlaem o let moe, anih khaeah, Balaam loe kaicae hnukah bang hanah angmak khruek, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","To naah Balak mah hmaloe ah patoeh ih ukkungnawk pongah kapop, ahmin kamthang kue kalah ukkung angraengnawk to laicaeh ah patoeh let. ");
INSERT INTO cekak_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nihcae Balaam khaeah angzoh o moe, anih khaeah, Zippor capa Balak mah, Kai khae angzoh han ai ah, tih mah doeh pakaa hmah nasoe; ");
INSERT INTO cekak_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","nang to kasang ah kang pakoeh moe, na thuih ih hmuen to kang sak pae boih han; to pongah angzo ah loe, hae kaminawk hae kai hanah na tangoeng paeh, tiah a thuih, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Toe Balaam mah, Balak ih tamnanawk khaeah, Balak mah sui, sum kanglung hoi koimongah kaom angmah ih siangpahrang im to na paek langlacadoeh, zetta ah maw, to tih ai boeh loe pop parai ah maw, ka Angraeng mah paek ih lok pong kamtlai ah tidoeh ka sah mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","To pongah nangcae doeh, Vaiduem loe haeah cam o raeh; Angraeng mah timaw na thui vop tih, tito tahngai rae si, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","To naduem ah Sithaw Balaam khaeah caeh moe, anih khaeah, Kai nang kawk hanah kaminawk angzo o nahaeloe, angthawk ah loe, nihcae hoi nawnto caeh ah; toe kang thuih ih lok khue ni na sak han oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam loe khawnbang khawnthaw ah angthawk, laa hrang nuiah anghnut moe, Moab ukkung angraengnawk hoi nawnto a caeh. ");
INSERT INTO cekak_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nihcae hoi nawnto a caeh pongah, Sithaw palungphui; nihcae to pakaa hanah Angraeng ih van kami to loklam ah angdoet khoep. Balaam loe angmah ih laa hrang nuiah angthueng moe, a tamna hnetto hoi nawnto a caeh. ");
INSERT INTO cekak_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Angraeng ih van kami loe a ban ah sumsen to sin moe, loklam ah angdoet khoep, tiah laa hrang mah hnuk naah, hrang loe loklam amkhraeng moe, lawk bangah caeh ving; to loklam ah a caeh let thai hanah, Balaam mah laa hrang to boh. ");
INSERT INTO cekak_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Misur takha salak ih loklam ah a caeh naah, Angraeng ih van kami to angdoet moe, hae bangah doeh ho bangah doeh sipae thungh pae khoep. ");
INSERT INTO cekak_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Laa hrang mah Angraeng ih van kami to hnuk let naah, sipae to a daeng hmop moe, Balaam ih khok daeng pae ngawng; to naah Balaam mah hrang to boh let bae. ");
INSERT INTO cekak_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","To pacoengah Angraeng ih van kami loe hmabang ah caeh moe, banqoi bantang angqoi han kaom ai tamcaek loklam ah angdoet pae khoep. ");
INSERT INTO cekak_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Laa hrang mah Angraeng ih van kami to hnuk let naah, Balaam tlim ah tabok pae; to naah Balaam palungphui moe, cunghet hoiah laa hrang to boh let. ");
INSERT INTO cekak_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","To naah Angraeng mah laa hrang ih pakha to paongh pae, hrang mah Balaam khaeah, Kawbang maw kang naa moe, kai vai thumto nang boh? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam mah laa hrang khaeah, Kai hae tiah doeh nang sah ai; ka ban ah sumsen om nahaeloe, vaihi roe kang hum han boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","To naah laa hrang mah Balaam khaeah, Kai loe nang mah vaihni ni khoek to nang thueng ih, nangmah ih laa hrang ah na ai maw ka oh? Nang khaeah hae tiah ka oh vai maw? tiah Balaam hanah a naa. To naah anih mah, Hae tiah na om vai ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Angraeng mah Balaam ih mik to amtuengsak naah, a ban ah sumsen kasin, loklam tamcaek ah kangdoe khoep, Angraeng ih van kami to anih mah hnuk; to pongah anih loe akuep tathuk moe, long ah tabok. ");
INSERT INTO cekak_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Angraeng ih van kami mah, Tipongah nangmah ih laa hrang to vai thumto na boh loe? Khenah, na caehhaih loklam loe kai hoi buenglueng tamlet ah oh, to pongah nangpakaa hanah kang zoh; ");
INSERT INTO cekak_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","laa hrang mah kai ang hnuk pongah, kai khae hoi loklam vai thumto amkhraeng ving; kai khae hoi amkhraeng ai nahaeloe, vaihi roe nang to kang hum moe, nang ih laa hrang to ka hingsak lat han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam mah Angraeng ih van kami khaeah, Ka zae moeng boeh; kai pakaa hanah loklam ah nang doet, tito ka panoek ai; to pongah vaihi na koeh ai nahaeloe, kam laem let han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Angraeng ih van kami mah Balaam khaeah, Kaminawk hoi nawnto caeh ah, toe kang thuih ih lok khue to ni na thuih han, tiah a naa. To pongah Balaam loe Balak ih toksah angraengnawk hoi nawnto caeh. ");
INSERT INTO cekak_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaam angzoh boeh, tiah Balak mah thaih naah, anih dawt hanah, Moab prae ramri Arnon vapui taengah kaom vangpui maeto ah a caeh. ");
INSERT INTO cekak_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak mah Balaam khaeah, Nang kawk hanah vaihi hoi vaihi kami kang patoeh na ai maw, tikhoe hae tih khoek to na kra loe? Nang hae kasang ah kang paloep mak ai, tiah na poek maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam mah Balak khaeah, Khenah, vaihi nang khaeah kang zoh boeh, lok ka thui thai tih maw? Sithaw mah ka pakha thungah suek ih lok khue ni ka thuih han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","To pacoengah Balaam loe Balak hoi nawnto Kirjath-Huzoth ah caeh. ");
INSERT INTO cekak_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak mah maitaw hoi tuunawk hoiah angbawnhaih to sak, to pacoengah Balaam hoi anih khaeah kaom ukkung angraengnawk hanah doeh a pat pae thoem. ");
INSERT INTO cekak_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Khawnbang ah loe Balak mah Balaam to kawk moe, Israel kaminawk patuek hanah, Baal sithaw ohhaih hmuensang ah a caeh haih. ");
INSERT INTO cekak_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam mah Balak khaeah, Kai han haeah hmaicam sarihto sah ah loe, maitaw tae sarihto hoi tuu tae sarihto suem ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaam mah thuih ih lok baktih toengah Balak mah sak pae; Balak hoi Balaam mah hmaicam maeto nuiah, maitaw tae maeto, tuu tae maeto hoiah angbawnhaih a sak hoi. ");
INSERT INTO cekak_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam mah, Balak khaeah, Na sak ih hmai angbawnhaih taengah om ah; kai loe ahmuen maeto ah ka caeh han; to ah kai tongh hanah Angraeng angzo khoe doeh om tih; anih mah ang hnuksak ih hmuen to kang thuih boih han hmang, tiah a naa. To pacoengah anih loe hmuensang ah caeh. ");
INSERT INTO cekak_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Sithaw mah Balaam to tongh, Balaam mah anih khaeah, Hmaicam sarihto ka sak moe, hmaicam maeto boih nuiah maitaw tae maeto hoi tuu tae maeto ka tathlang boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Angraeng mah Balaam ih pakha thungah lok to suek pae, Balak khaeah amlaem let ah loe, hae lok hae anih khaeah thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","To pongah anih Balak khaeah amlaem tathuk naah, khenah, Balak loe Moab ukkung angraengnawk boih hoi nawnto sak ih hmai angbawnhaih taengah angdoet. ");
INSERT INTO cekak_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","To naah Balaam mah patahhaih lok to thuih pae; Moab siangpahrang Balak mah, angzo ah loe, kai hanah Jakob acaengnawk hae tangoeng pae ah; angzo ah loe, Israel kaminawk hae amrosak ah, tiah Aram prae ni angyae bangah kaom maesang hoiah kai hae ang caeh haih boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Sithaw mah tangoeng ai ih kami to kawbang maw ka tangoeng thaih ueloe, Angraeng mah amrosak ai ih kami to kawbang maw kam rosak thai tih? ");
INSERT INTO cekak_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Lungsong nui hoiah anih to ka hnuk moe, maesang hoiah anih to ka dan; khenah, to kaminawk loe angmacae khue om o tih, kalah kaminawk hoi angbaeh o mak ai. ");
INSERT INTO cekak_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Jakob acaeng ih maiphu loe mi mah maw kroek thai tih, Israel acaeng palito thung ih maeto mataeng doeh mi mah maw kroek thai tih? Kai loe katoeng kami baktiah dueh nasoe, ka boenghaih doeh nihcae boenghaih baktiah om nasoe, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak mah Balaam khaeah, Kai khaeah timaw na sak? Ka misanawk tangoeng thuih han ih na ai maw kang kawk, khenah, tipongah nihcae to tahamhoihaih na paek lat loe? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Anih mah, Angraeng mah ka pakha thungah suek ih lok to acoehaih hoiah ka thui mak ai maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak mah anih khaeah, Angzo ah, nihcae khet naah, nihcae boih kamtueng ai ahmuen, nihcae ahap khue amtuenghaih ahmuen kalah bangah caeh si; to ahmuen hoiah nihcae to kai han na tangoeng pae let ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","To pongah Zophim azawn hoiah Pisgah mae nuiah anih to caeh haih moe, to ah hmaicam sarihto sak pacoengah, hmaicam maeto nuiah maitaw tae maeto hoi tuu tae maeto angbawnhaih ah a paek. ");
INSERT INTO cekak_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam mah Balak khaeah, Angraeng tongh hanah ahmuen kalah ah ka caeh nathung, nang loe na sak ih angbawnhaih ahmuen taengah om ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Angraeng mah Balaam to tongh, anih ih pakha ah lok to a suek pae moe, Balak khaeah amlaem let ah loe, hae lok hae thui paeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaam amlaem let naah loe, khenah, Moab ukkung angraengnawk hoi nawnto sak ih hmai angbawnhaih taengah angdoe Balak to a hnuk. To naah Balak mah, Angraeng mah timaw ang thuih? tiah a dueng. ");
INSERT INTO cekak_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","To naah anih mah patahhaih lok to hae tiah a thuih pae; Balak, angthawk ah loe, tahngai ah; Zippor capa, ka lok hae tahngai ah; ");
INSERT INTO cekak_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Sithaw loe amsawnlok thui kami na ai ni; dawnpakhuemhaih tawn kami ih capa doeh na ai ni; anih loe a thuih ih lok baktiah sah ai ah oh vai maw? A lokkam ih baktiah koepsak ai ah oh vai maw? ");
INSERT INTO cekak_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Khenah, Tahamhoihaih paek hanah ang thuih ih lok to ka hnuk boeh; tahamhoihaih ang paek boeh pongah, ka pakhrai thai mak ai boeh. ");
INSERT INTO cekak_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Anih mah Jakob zaehaih to hnu ai, Israel acaeng nuiah doeh kahoih ai loklam amkhraenghaih to hnu ai; anih ih Angraeng Sithaw loe anih hoi nawnto oh moe, nihcae salakah Siangpahrang hanghaih lok to oh. ");
INSERT INTO cekak_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Sithaw mah nihcae to Izip prae thung hoiah tacawtsak boeh; Israel kaminawk loe kokno thacakhaih to tawnh o. ");
INSERT INTO cekak_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Jakob tuk hanah lungh aahhaih om ai, Israel tuk hanah tahmaa baktiah thuih coek ih lok doeh om ai. Jakob hoi Israel kawng pongah, Vaihi Sithaw mah timaw sak, tito khen oh, tiah thui o tih. ");
INSERT INTO cekak_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Khenah, kaminawk loe kaipui baktiah angthawk o tih; saning kanawk kaipui baktiah tacawt o tih; a naeh ih moi to caa ai moe, a kaek ih moi thii to nae ai karoek to, omduem ai kaipui baktiah oh o, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","To naah Balak mah Balaam khaeah, Nihcae to tangoeng thuih hmah loe, tahamhoihaih doeh paek hmah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Toe Balaam mah, Balak khaeah, Angraeng mah thuih ih lok khue ni kang thuih han, tiah kang thuih boeh na ai maw? tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","To pacoengah Balak mah Balaam khaeah, Angzo ah; kalah ahmuen bangah kang caeh haih han; to ahmuen hoiah nihcae nang tangoeng pae hanah, Angraeng ih palung tongh khoe doeh om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak mah Balaam to kawk moe, Jeshimon vangpui bangah angqoi Peor mae nuiah a caeh haih. ");
INSERT INTO cekak_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam mah, Balak khaeah, Hae ahmuen ah kai han hmaicam sarihto sah ah loe, maitaw tae sarihto hoi tuu tae sarihto angbawnhaih ah paek ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaam mah thuih ih lok baktih toengah Balak mah sak moe, hmaicam maeto boih nuiah maitaw tae maeto hoi tuu tae maeto a tathlang. ");
INSERT INTO cekak_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Angraeng mah Israel kaminawk tahamhoihaih paek han koeh, tito Balaam mah panoek naah, hmacawnhaih hnuk hanah, canghniah caeh ih baktih toengah caeh ai ah, a mikhmai to praezaek bangah paqoi ving. ");
INSERT INTO cekak_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam mah khet naah, angmacae acaeng maeto pacoeng maeto nawnto amkhueng Israel kaminawk to a hnuk; to naah Sithaw ih Muithla a nuiah phak. ");
INSERT INTO cekak_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Anih mah taphong han ih patahhaih lok to lak moe, mik amtueng, Beor capa Balaam ih lok; ");
INSERT INTO cekak_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","long ah amtimh pacoengah, mik kamtueng, thacak Angraeng hnuksakhaih hnukung, Sithaw mah thuih ih lok thaih kami mah thuih ih lok loe, ");
INSERT INTO cekak_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Aw Jakob, na ohhaih imnawk loe kawkruk maw hoih, Aw Israel, na kahni im loe kawkruk maw hoih! ");
INSERT INTO cekak_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Nang loe kawk parai azawnnawk, tuipui taengah kaom takhanawk, Angraeng mah thling ih thingnawk hoi tui taengah amprawk sidar thingnawk baktiah na oh o. ");
INSERT INTO cekak_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Anih loe a tui tabu thung hoiah tui to krai ueloe, anih ih aanmunawk loe kapop tui ahmuen ah krah o tih; anih ih siangpahrang loe Agag pongah len kue ueloe, a ukhaih prae doeh kasang ah pakoehhaih om tih. ");
INSERT INTO cekak_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Sithaw mah anih to Izip prae thung hoiah zaeh, anih loe kokno baktiah thacak; anih mah a misa ah kaom prae kaminawk to paaeh ueloe, nihcae ih ahuhnawk to khaek pae tih; angmah ih kalii hoiah nihcae to kat tih. ");
INSERT INTO cekak_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Anih loe kaipui baktiah caeh moe, kalen kaipui baktiah tabok; anih to mi mah maw pathawk thai tih? Nang tahamhoihaih paek kami loe, tahamhoihaih tongh ueloe, nang tangoeng kami loe tangoeng ah om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak mah Balaam to palungphui thuih, a ban tabaeng phang pacoengah, Balak mah Balaam khaeah, Ka misanawk tangoeng hanah kang kawk, toe khenah, nihcae to vai thumto tahamhoihaih na paek lat. ");
INSERT INTO cekak_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","To pongah vaihi na ohhaih ahmuen ah cawn lai ah; nang hae kasang ah kang suek han, tiah poekhaih ka tawnh; toe khenah, to tiah oh han ai ah Angraeng mah pakaa ving boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam mah Balak khaeah, Nang patoeh ih laicaehnawk khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Balak mah sui hoi sum kanglung koimongah suek ih angmah ih siangpahrang im to na paek langlacadoeh, Angraeng mah paek ih lok pong kamtlai ah, kasae hmuen ah maw, to tih ai boeh loe kahoih hmuen ah maw, ka poekhaih to ka thui cop mak ai; Angraeng mah thuih ih lok khue ni ka thuih han, tiah ka thuih boeh na ai maw? ");
INSERT INTO cekak_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Khenah, vaihi loe kaimah ih kaminawk khaeah ka caeh han boeh; to pongah angzo ah; hae kaminawk mah hmabang ah nang ih kaminawk nuiah timaw sah o tih, tito kang thuih han, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Anih mah taphong han ih patahhaih lok to lak moe, mik kamtueng, Beor capa Balaam mah thuih ih lok; ");
INSERT INTO cekak_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","long ah amtimh pacoengah, mik kamtueng, thacak Angraeng hnuksakhaih hnukung, Kasang koek Sithaw palunghahaih panoekkung mah thuih ih lok loe, ");
INSERT INTO cekak_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","anih to ka hnu tih, toe vaihi ka hnu mak ai vop; anih to ka khet han, toe atue loe anghnai ai vop; Jakob acaeng thung hoiah cakaeh maeto tacawt ueloe, Israel thung hoiah angraeng cunghet maeto angthawk tahang tih; anih mah Moab prae taki taket khoek to tuh ueloe, Sheth capanawk to amrosak boih tih. ");
INSERT INTO cekak_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom prae to la ueloe, Seir mae doeh anih ih misanawk mah la o tih; toe Israel loe misahoihaih hoiah thacak aep aep tih. ");
INSERT INTO cekak_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jakob thung hoiah ukkung maeto tacawt ueloe, vangpui thungah anghmat kaminawk to hum tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaam mah Amalek to khet moe, patahhaih lok to a thuih; acaeng kaminawk boih thungah Amalek loe hmaloe koek ah oh; toe anih loe hnukkhuem koek ah amro tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","To pacoengah Ken kaminawk to a khet moe, patahhaih lok to a thuih; na ohhaih ahmuen loe caak moe, tabu doeh lungsong nuiah na boh, ");
INSERT INTO cekak_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","toe Ken kaminawk loe, Ashur ukkung mah tamna ah naeh ueloe, anghma angtaa o tih. ");
INSERT INTO cekak_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","To pacoengah taphong han ih patahhaih lok to lak moe, Ala, Sithaw mah hae hmuen sak naah mi maw hing thai tih? ");
INSERT INTO cekak_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kittim tui taeng hoiah palongpuinawk angzo o ueloe, nihcae mah Asshur hoi Eber to pazawk tih; toe angmacae doeh amro tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam loe angthawk tahang moe, angmah im ah amlaem, to pacoengah Balak doeh angmah ih loklam ah caeh toeng. ");
INSERT INTO cekak_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israel kaminawk Shittim ah oh o naah, Moab canunawk hoiah nongpa nongpata zaehaih sak amtong o. ");
INSERT INTO cekak_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","To nongpatanawk mah angmacae sithaw angbawnhaih ahmuen ah Israel kaminawk angzoh thai hanah pacae o; to kaminawk loe angbawnhaih buh aan to caak o moe, to ih sithawnawk hma ah akuep o. ");
INSERT INTO cekak_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","To tiah Israel kaminawk mah Peor ahmuen ah Baal to bok o pongah, Angraeng palungphuihaih Israel kaminawk nuiah phak. ");
INSERT INTO cekak_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","To naah Angraeng mah Mosi khaeah, Hae kami zaehoikungnawk to kawk boih ah loe, zit kathok Angraeng palungphuihaih Israel khae hoi dip thai hanah, nihcae to khodai ah Angraeng hmaa ah qui hoiah bang ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","To pongah Mosi mah Israel lokcaekkungnawk khaeah, Baal-Peor bokhaih ahmuen ah caeh kaminawk boih to hum oh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Khenah, Israel kami maeto mah, Mosi hoi amkhuenghaih kahni im thok taengah kaqah, kamkhueng angmah ih nawkamya Israel kaminawk boih hma ah, Midian nongpata maeto angzoh haih. ");
INSERT INTO cekak_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Qaima Aaron capa Eleazar, Eleazar capa Phinehas mah anih to hnuk naah, anih mah tayae to ban ah sin, kamkhueng kaminawk salak hoiah angthawk moe, ");
INSERT INTO cekak_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","to tiah zaehaih sah Israel kami ohhaih kahni im khoek to a pangh pacoengah, Israel kami hoi to nongpata to tayae hoiah zok ah takhawh hmaek. To naah Israel salak ih nathaih kasae to dip. ");
INSERT INTO cekak_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Toe to ih kasae nathaih pongah kami sing hnet, sang palito duek o. ");
INSERT INTO cekak_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Qaima Aaron capa Eleazar, Eleazar capa Phinehas loe, kai pakoehhaih bangah palungthin thacak kami ah oh pongah, Israel kaminawk ka hum han ai ah, Israel nuiah palung ka phuihaih to anih mah dipsak boeh. ");
INSERT INTO cekak_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","To pongah, Khenah, anih khaeah angdaeh lokmaihaih to ka paek boeh; ");
INSERT INTO cekak_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","anih loe Sithaw bokhaih bangah palungthin thacak moe, Israel kaminawk zae loih thai hanah, angbawnhaih a sak pongah, angmah hoi a caanawk khoek to dungzan ah qaima toksak hanah lokmaihaih to hnu tih, tiah a thuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Midian nongpata hoi nawnto hum ih Israel kami ahmin loe, Simeon acaeng zaehoikung ah kaom, Salu ih capa Zimri. ");
INSERT INTO cekak_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Hum ih Midian nongpata ahmin loe, Midian imthung takoh lu koek ah kaom, Zur canu Gozbi. ");
INSERT INTO cekak_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Midian kaminawk to na misa baktiah poek ah loe hum ah; ");
INSERT INTO cekak_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Peor sithaw to bok pongah, nathaih kasae phakhaih niah hum ih, Midian kaminawk zaehoikung ih canu, nihcae ih tanu ah kaom, Gozbi hoi Peor kawng pongah, nangcae to ang ling o boeh, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Kasae nathaih phak pacoengah, Angraeng mah Mosi hoi qaima Aaron capa Eleazar khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","saning pumphaeto pacoeng ranuih bang kaom, misa tuh thaih Israel acaeng thung ih kaminawk boih to ahmin la ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","To pongah Mosi hoi qaima Eleazar mah, Moab azawn, Jordan vapui taeng, Jeriko vangpui ahmuen maeto bang ih kaminawk khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Angraeng mah Mosi khaeah paek ih lok baktih toengah, saning pumphaeto ranuih bang kami boih ahmin lak han oh, tiah a thuih pae hoi. Izip prae hoi angzo Israel kaminawk loe, ");
INSERT INTO cekak_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Israel ih calu, Reuben ih caanawk; Hanok ih acaeng loe, Hanok hoi tacawt kami ah oh; Pallu ih acaeng loe, Pallu hoi tacawt kami ah oh; ");
INSERT INTO cekak_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron ih acaeng loe, Hezron hoi tacawt kami ah oh; Karmi ih acaeng loe, Karmi hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","To kaminawk loe Reuben ih acaeng ah oh o moe, ahmin lak naah sangqum boih ah sing pali, sang thum, cumvai sarih, qui thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallu capa loe Eliab; ");
INSERT INTO cekak_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliab capanawk loe Nemuel, Dathan hoi Abiram; to ih Dathan hoi Abiram loe rangpui kaminawk salakah ahmin amthang hoi moe, Aaron hoi Mosi ih lok aek kami, Angraeng ih lok aek kami ah oh hoi pacoengah, Korah hnukbang kaminawk hoi amyok kami ah oh hoi. ");
INSERT INTO cekak_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Nihnik loe long mah pakha aangh moe, Korah hoi nawnto paaeh ving boeh, anih hnukbang kami cumvai hnet, qui pangato doeh hmai mah kangh moe duek o; nihcae loe acoehaih paekkung ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Toe Korah ih caanawk loe dueh o ai. ");
INSERT INTO cekak_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeon imthung takoh hoi tacawt caanawk loe, Nemuel ih acaeng loe, Nemuel hoi tacawt kami ah oh o; Jamim hoi tacawt kami loe, Jamim ih acaeng ah oh o; Jachin ih acaeng loe, Jachin hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah ih acaeng loe, Zerah hoi tacawt kami ah oh o; Shaul ih acaeng loe, Shaul hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeon ih acaengnawk loe, kami sang pumphae hnet, cumvai hnetto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad imthung takoh hoi tacawt caanawk; Zephon ih acaeng loe, Zephon hoi tacawt kami ah oh o; Haggi ih acaeng loe, Haggi hoi tacawt kami ah oh o; Shuni ih acaeng loe, Shuni hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni acaeng loe, Ozni hoi tacawt kami ah oh o; Eri ih acaeng loe, Eri hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodi ih acaeng loe, Arod hoi tacawt kami ah oh o; Areli acaeng loe, Areli hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gad acaengnawk loe, kami sang qui pali, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Er hoi Onan loe, Judah ih capa ah oh hoi moe, Kanaan prae ah duek hoi ving boeh. ");
INSERT INTO cekak_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Judah imthung takoh hoi tacawt caanawk; Shelah ih acaeng loe, Shelah hoi tacawt kami ah oh; Pharez ih acaeng loe, Pharez hoi tacawt kami ah oh o; Zerah ih acaeng loe, Zerah hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Pharez ih caanawk; Hezron ih acaeng loe, Hezron hoi tacawt kami ah oh; Hamul ih acaeng loe, Hamul hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Judah ih acaengnawk loe kami sing sarih, sang taruk, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Issakar imthung takoh hoi tacawt caanawk; Tola ih acaeng loe, Tola hoi tacawt kami ah oh o; Pua ih acaeng loe, Pua hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashub ih acaeng loe, Jashub hoi tacawt kami ah oh, Shimron ih acaeng loe, Shimron hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Issakar ih acaengnawk loe, kami sing taruk, sang pali, cumvai thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Jebulun imthung takoh hoi tacawt caanawk; Sardi ih acaeng loe, Sered hoi tacawt kami ah oh o; Elon ih acaeng loe, Elon hoi tacawt kami ah oh o; Jahleel ih acaeng loe, Jahleel hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Jebulun acaengnawk loe, kami sing taruk, cumvai pangato oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Joseph imthung takoh hoi tacawt caanawk loe, Manasseh hoi Ephraim hae ni. ");
INSERT INTO cekak_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasseh acaengnawk; Makir ih acaeng loe, Makir hoi tacawt kami ah oh o; Makir loe Gilead ih ampa ah oh; Gilead ih acaeng loe, Gilead hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilead ih acaengnawk; Jeezer ih acaeng loe, Jeezer hoi tacawt kami ah oh o; Helek ih acaeng loe, Helek hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel ih acaeng loe, Asriel hoi tacawt kami ah oh o; Shekem ih acaeng loe, Shekem hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida ih acaeng loe, Shemida hoi tacawt kami ah oh o; Hepher ih acaeng loe, Hepher hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hepher ih capa Zelophehad loe, capa tawn ai; canunawk khue ni a tawnh; canunawk ih ahmin loe, Mahlah, Noah, Hoglah, Milkah hoi Tirzah. ");
INSERT INTO cekak_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hae kaminawk loe Manasseh ih acaeng ah oh o moe, kroek naah nihcae loe kami sing panga, sang hnet, cumvai sarihto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ephraim imthung takoh hoi tacawt caanawk; Shuthelah ih acaeng loe, Shuthelah hoi tacawt kami ah oh o; Beker ih acaeng loe, Beker hoi tacawt kami ah oh o; Tahan ih acaeng loe, Tahan hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shutheleh ih caanawk; Eran ih acaeng loe, Eran hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ephraim ih acaengnawk loe kroek naah, kami sing thum, sang hnet, cumvai pangato oh o. Joseph imthung takoh hoi tacawt acaengnawk loe to zetto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benjamin imthung takoh hoi tacawt caanawk; Bela ih acaeng loe, Bela hoi tacawt kami ah oh o; Ashbel ih acaeng loe, Ashbel hoi tacawt kami ah oh o; Ahiram ih acaeng loe, Ahiram hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shupham ih acaeng loe, Shupham hoi tacawt kami ah oh o; Hupham ih acaeng loe, Hupham hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ard hoi Naaman hoi tacawt Bela ih caanawk; Ard ih acaeng loe, Ard hoi tacawt kami ah oh o; Naaman hoi tacawt kami loe, Naaman ih acaeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Benjamin ih acaengnawk loe kroek naah, kami sing pali, sang panga, cumvai tarukto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan imthung takoh hoi tacawt caanawk; Shuham hoi tacawt kami loe, Shuham ih acaeng ah oh o. Hae kaminawk loe Dan ih acaeng ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","To tiah Shulam ih acaengnawk loe kroek naah, kami sing taruk, sang pali, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asher imthung takoh hoi tacawt caanawk; Jimna ih acaeng loe, Jimna hoi tacawt kami ah oh o; Jesui ih acaeng loe, Jesui hoi tacawt kami ah oh o; Beriah ih acaeng loe, Beriah hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriah ih caanawk; Herber ih acaeng loe, Heber hoi tacawt kami ah oh o; Malkiel ih acaeng loe, Malkiel hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asher canu ih ahmin loe Sarah. ");
INSERT INTO cekak_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Asher ih acaengnawk loe kroek naah, kami sing panga, sang thum, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naphtali imthung takoh hoi tacawt caanawk; Jahzeel ih acaeng loe, Jahzeel hoi tacawt kami ah oh o; Guni ih acaeng loe, Guni hoi tacawt kami ah oh o; ");
INSERT INTO cekak_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer ih acaeng loe, Jezer hoi tacawt kami ah oh o; Shillem ih acaeng loe, Shillem hoi tacawt kaminawk ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Naphtali ih acaengnawk loe kroek naah, sing pali, sang panga, cumvai palito oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Israel kaminawk loe kroek naah, kami sing qui taruk, sangto pacoeng, cumvai sarih, qui thumto oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Angmacae ih ahmin baktih toengah, nihcae han prae to pazet paeh. ");
INSERT INTO cekak_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kami pop kue acaeng hanah qawk to pop kueah paek ah loe, kami tamsi kue hanah qawk to tamsi kueah paek ah; angmacae imthung takoh ih kami zetto qawk to paek han oh. ");
INSERT INTO cekak_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Toe prae loe taham khethaih phoisa vah hoiah pazet ah; ampanawk ih acaeng hmin hoiah ni prae to toep o tih. ");
INSERT INTO cekak_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Lawk loe kami pop hoi tamsi baktih toengah, taham khethaih phoisa vahhaih hoiah pazet ah, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Levi imthung takoh hoi tacawt acaengnawk; Gershon ih acaeng loe, Gershon hoi tacawt kami ah oh o; Kohath ih acaeng loe, Kohath hoi tacawt kami ah oh o; Merari ih acaeng loe, Merari hoi tacawt kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levi acaeng thungah loe, Libni ih acaeng, Hebron ih acaeng, Mahli ih acaeng, Mushi ih acaeng hoi Korah ih acaengnawk athum o. Kohath mah Amram to sak. ");
INSERT INTO cekak_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram ih zu hmin loe Jokhebed; anih loe Levi ih canu ah oh moe, Izip prae ah oh naah Levi acaeng thung hoiah tacawt. Amram hoi anih mah Aaron, Mosi hoi nihnik ih tanuh Miriam to sak. ");
INSERT INTO cekak_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron ih capanawk loe, Nadab, Abihu, Eleazar hoi Ithamar. ");
INSERT INTO cekak_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Toe Nadab hoi Abihu loe, Angraeng hmaa ah paek koi ai hmai hoi angbawnhaih to sak hoi pongah duek hoi hmaek. ");
INSERT INTO cekak_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Levi acaeng thung hoiah nongpa khrah to pacoeng ranui bang kaom kami to kroek boih naah, sing hnet, sang thumto oh o. Nihcae loe Israel kaminawk salakah qawktoep o ai pongah, Israel kaminawk hoi nawnto ahmin kroek o hmaek ai. ");
INSERT INTO cekak_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Hae loe Mosi hoi qaima Eleazar mah, Moab azawn, Jordan vapui taeng, Jeriko zaeh ah ah ahmin lak ih Israel kami ah oh o. ");
INSERT INTO cekak_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mosi hoi qaima Aaron mah Sinai praezaek ah Israel kaminawk ih ahmin to kroek hoi naah, hae kaminawk thung ih thoemto kaminawk ih ahmin maeto doeh kroek hoi ai. ");
INSERT INTO cekak_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Jephunneh capa Kaleb hoi Nun capa Joshua khue ai ah loe, maeto doeh anghmat o mak ai, praezaek ah dueh o tih, tiah Angraeng mah thuih boeh pongah, anih ih ahmin to kroek o ai boeh. ");
INSERT INTO cekak_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Manasseh capa Makir, Makir capa Gilead, Gilead capa Hepher, Hepher capa Zelophehad, anih ih canunawk loe, Joseph capa Manasseh acaeng ah oh o. Anih canunawk ih ahmin loe Mahlah, Noah, Hoglah, Milkah hoi Tirzah. ");
INSERT INTO cekak_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Nihcae loe amkhuenghaih kahni im thok taengah, Mosi hoi qaima Eleazar, zaehoikungnawk hoi rangpui kaminawk hmaa ah, angdoet o pacoengah, ");
INSERT INTO cekak_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","kaicae ampa loe praezaek ah duek boeh; anih loe Angraeng ih lok aek kami, Korah hnukbang kaminawk thungah athum ai; anih loe a zaehaih pongah duek moe, capa tawn ai. ");
INSERT INTO cekak_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","To tiah capa tawn ai pongah, anih ih ahmin to canawk thung hoiah tahmat han boeh maw? To pongah kam pa ih nawkamyanawk hoi nawnto qawk na paek o thoem ah, tiah a naa o. ");
INSERT INTO cekak_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","To pongah Mosi mah nihcae kawng to Angraeng khaeah thuih pae. ");
INSERT INTO cekak_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","To naah Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Zelophehad canunawk mah thuih ih lok loe amsoem; ampa ih nawkamyanawk salakah nihcae han qawk na paek han oh; ampa ih qawknawk to nihcae han paek paeh. ");
INSERT INTO cekak_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Israel kaminawk thung ih, Kami maeto loe, capa tawn ai ah dueh nahaeloe, anih ih qawk to a canu han paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Canu doeh tawn ai nahaeloe, anih ih qawk to angmah ih nawkamyanawk khaeah paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Nawkamyanawk doeh tawn ai bae nahaeloe, anih ih qawk to ampa ih nawkamyanawk khaeah paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ampa loe nawkamya tawn ai nahaeloe, acaeng thung kazoi koek kami to paek ah; anih mah qawk to toep tih; hae loe Angraeng mah Mosi khaeah paek ih lok baktih toengah, Israel kaminawk hanah kangaih zaehoihhaih atawk ah om tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Angraeng mah Mosi khaeah, Abarim mae nuiah daw tahang ah loe, Israel kaminawk khaeah ka paek han ih prae to doeng ah. ");
INSERT INTO cekak_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","To prae na hnuk pacoengah loe, nam ya Aaron lak baktih toengah, nang doeh nam panawk khaeah la tih boeh. ");
INSERT INTO cekak_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Israel kaminawk Zin praezaek, Kadesh hmuen ih Meribah tuipuek taengah, laisaep o naah ciimcai ka hmin pakoeh ai ah, ka lok nang aek, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mosi mah Angraeng khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Angraeng, kaminawk boih ih Muithla ukkung Sithaw mah, hae kaminawk, ");
INSERT INTO cekak_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","hma ah caeh thaih kami, akun thaih kami, zaehoi thaih kami, akunsak thaih kami to zaehoikung ah suem nasoe; to tiah nahaeloe Angraeng ih kaminawk loe toepkung om ai tuunawk baktiah om o mak ai, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","To pongah Angraeng mah Mosi khaeah, muithla katawn, Nun capa Joshua to kawk loe, a nuiah na ban to koeng ah; ");
INSERT INTO cekak_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","qaima Eleazar hoi kaminawk hmaa ah angdoesak ah loe, kaminawk hma ah tok to paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Israel kaminawk mah a lok tahngaih o hanah, hmuen na sak thaihaih thoemto anih han paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Anih to qaima Eleazar hma ah angdoesak ah loe, qaima mah Angraeng hmaa ah Urim to lokdueng pacoengah, anih han lok takroek pae tih. Anih mah thuih ih lok baktih toengah, anih hoi Israel kaminawk to tacawt o ueloe, anih mah thuih ih lok baktih toengah akun o tih, tiah a naa. ");
INSERT INTO cekak_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Angraeng mah thuih ih lok baktih toengah, Mosi mah sak; Joshua to kawk moe, qaima Eleazar hoi rangpui hma ah angdoetsak. ");
INSERT INTO cekak_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","To pacoengah anih nuiah ban koeng moe, Angraeng mah Mosi khaeah thuih ih lok baktih toengah, tok to a paek. ");
INSERT INTO cekak_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Angraeng mah Mosi khaeah, ");
INSERT INTO cekak_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Hae lok hae Israel kaminawk khaeah thui paeh; nihcae khaeah, Nangcae mah kai han paek ih hmuen, kai khaeah hmuihoih paek hanah hmai hoi sak ih angbawnhaih takaw to, atue phak naah na paek oh, tiah a thuih, tiah thui paeh. ");
INSERT INTO cekak_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Nihcae khaeah, Ni thokkruek, coek koi kaom ai saningto kaom, tuucaa hnetto, Angraeng khaeah hmai angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Tuucaa maeto akhawnbang ah paek oh loe, kalah tuucaa maeto loe duembang ah paek ah; ");
INSERT INTO cekak_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","olive situi hint palito thungah hint maeto hoi atok ih, takaw dip ephah hato thungah maeto hoi nawnto paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Hae loe Sinai mae ah caksak ih, boeng ai ah Angraeng khaeah paek hanah, hmuihoih ah paek ih hmai angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Tuucaa maeto naah, naek han misurtui hint maeto to palito ah tapraek ah loe, to misurtui to naek koi tui hoiah sak ih angbawnhaih baktiah hmuenciim ih Angraeng hmaa ah krai ah. ");
INSERT INTO cekak_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Kalah tuucaa maeto hoi angbawnhaih loe duembang ah sah ah; akhawn bangah na paek ih takaw dip hoi naek koi tui na paek ih baktih toengah, Sithaw khaeah hmuihoih ah paek ih hmai hoiah angbawnhaih to sah ah. ");
INSERT INTO cekak_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Sabbath niah coek koi kaom ai, saningto kaom tuucaa hnetto loe, naek koi paek ih hmuen hoi nawnto, situi hoi atok tangcae ih takaw dip ephah maeto thung hoi tapraek ih hato thungah hnetto paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Hae loe hmai hoi angbawnhaih, naek koi tui hoi angbawnhaih sak pacoengah, Sabbath ni kruek sak han koi hmuen ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Khrah amtong tangsuek naah, coek koi kaom ai maitaw tae hnetto, tuu tae maeto hoi saningto kaom tuucaa sarihto hoiah Angraeng khaeah hmai angbawnhaih to sah ah; ");
INSERT INTO cekak_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Maitaw tae maeto naah situi hoi atok ih takaw dip ephah maeto thung hoi tapraek ih hato thungah thumto; tuu tae maeto naah situi hoi atok tangcae ih takaw dip ephah maeto thung hoi tapraek ih hato thungah hnetto hoi nawnto paek ah. ");
INSERT INTO cekak_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Tuucaa maeto naah situi hoi atok tangcae ih takaw dip ephah maeto thung hoi tapraek ih hato thungah maeto paek ah; hae loe Angraeng khaeah hmuihoih ah paek ih hmai angbawnhaih ah oh. ");
INSERT INTO cekak_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Maitaw tae maeto naah naek koi hmuen ah misurtui hint ahap; tuu tae maeto naah misurtui hint maeto thung hoi tapraek ih thumto thungah maeto, tuucaa maeto naah misurtui hint maeto thung hoi tapraek ih palito thungah maeto paek ah; hae loe saningto thung khrah kruek sak han ih angbawnhaih ah om tih. ");
INSERT INTO cekak_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ni thokkruek boeng ai ah sak ih hmai angbawnhaih, naek han misurtui hoi angbawnhaih sak pacoengah, zae angbawnhaih sak hanah Angraeng khaeah maeh caa maeto paek han oh. ");
INSERT INTO cekak_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Khrah tangsuek ni hatlai palito loe, Angraeng mak sak ih misong loihhaih niah oh. ");
INSERT INTO cekak_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","To khrah ni hatlai pangato naah poih to sak moe, ni sarihto thung taeh thuh ai ih takaw to caak han oh. ");
INSERT INTO cekak_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Hmaloe koek niah kaciim rangpui amkhuenghaih